﻿USE sofia;
DROP TABLE IF EXISTS sofia.myw_vpl;
CREATE TABLE myw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES myw_vpl WRITE;
INSERT INTO myw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Buk towen waseg delen Yeisuw Kelis, tabun kweiboug Deibid, kweiboug tonen tabun Ebelam. ");
INSERT INTO myw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebelam natun Aysak. Aysak natun Yekob. Yekob nitun Yud siney tuwan budan. ");
INSERT INTO myw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yud nitun Peles son Selak. Ines Temal. Peles natun Eslon. Eslon natun Alam. ");
INSERT INTO myw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alam natun Amminadab. Amminadab natun Na̱son. Na̱son natun Salmon. ");
INSERT INTO myw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon natun Bowas. Bowas inan yagan Leyab. Bowas natun Obed. Obed inan yagan Lut. Obed natun Desiy. ");
INSERT INTO myw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Desiy natun Deibid, mtowen king. Deibid natun Solomon. Solomon inan mtowen Uliyak nakwav. Deibid bo ikow vin mana̱wen. ");
INSERT INTO myw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon natun Lekoboum. Lekoboum natun Ebiy. Ebiy natun Esap. ");
INSERT INTO myw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esap natun Yosepat. Yosepat natun Yolam. Yolam natun Usay. ");
INSERT INTO myw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usay natun Yotam. Yotam natun Akas. Akas natun Esekay. ");
INSERT INTO myw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekay natun Ma̱nas. Ma̱nas natun Emon. Emon natun Yosiyak. ");
INSERT INTO myw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyak nitun Yekonay siney budan, tutan ikoulups ineis Babilon. ");
INSERT INTO myw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ineis Babilon ikous, Yekonay natun Salatiyel. Salatiyel natun Delububel. ");
INSERT INTO myw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Delububel natun Ebiyud. Ebiyud natun Ilayakim. Ilayakim natun Esol. ");
INSERT INTO myw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esol natun Sa̱dok. Sa̱dok natun Ekim. Ekim natun Eliyud. ");
INSERT INTO myw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud natun Eliyesal. Eliyesal natun Mattan. Mattan natun Yekob. ");
INSERT INTO myw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekob natun Yosep, mtowen Meliy namwan. Meliy natun Yeisuw, mtowen yagan Kelis. ");
INSERT INTO myw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yeisuw delen, tasilamaw Ebelam waseg, tavin Ebelam, tayuwein Ebelam natun, tatounun Ebelam tabun, tavasin Ebelam tabun natun, beibus ee... tutan Deibid waseg, babiweis sinawatan teivas. Tasilamaw Deibid waseg, tavin Deibid son natun, tatounun Deibid tabun, tavasin Deibid tabun natun, beibus ee... tutan min-Babilon ikawes inawes wasiven, babiweis sinawatan teivas. Tasilamaw tutan ineis Babilon tavin ee... tutan Kelis waseg, babiweis sinawatan teivas. ");
INSERT INTO myw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nakabsilamaw Yeisuw Kelis ma̱wan. Inan Meliy nibokes va̱gan beivays son Yosep. Nag imasis son, tage bo isum-wan; Kululuwan Yowbad isek Meliy mo isum. ");
INSERT INTO myw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Namwan Yosep ikin neisum, itilikon, idok kid bipiyev. Taw towen tadidumwal, nag bilivan wavtakon ven; adok vin beivag anmwasin; misinaka bikayeb binoun. ");
INSERT INTO myw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ininuway ma̱wan ee... imasis, anmikon waseg Yowbad nataka̱yob ikin neim, idibek, ilana, “Yosep, ya̱koum Deibid tabun yak, bweina kuvays soum Meliy. Awoum beivag nanoum babaw. Yowbad Kululuwan isek mo isum ikakuda̱pom. ");
INSERT INTO myw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Igaw mo bikop natun kuda̱taw; e, kudok yagan Yeisuw, mtowen bikatinabwes nagamag sinap kalbaleb waseg.” ");
INSERT INTO myw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Youd towen ikamat peinan Yowbad anilivan ma̱wan. Napalopit kweiboug nilivnek mamagina: ");
INSERT INTO myw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nakubukwab igaw naptabod mo bikop natun kuda̱taw, yagan bidokes Ima̱nuwel.” Wawun yeg towen ‘Yowbad sod tasesus.’ ");
INSERT INTO myw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep imasis ikous, ikit, ikanow aygan Yowbad nataka̱yob, ivays son nakwav. ");
INSERT INTO myw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ta-imasis son; tana̱ban ises ee... mo ikop natun, taman mo idok natun yagan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Tutan inan nikop Yeisuw ven Betelem waseg, wawnuwan ven Yudiy, ven babaw siking Elod. Tassinaps mwasanin siven wanuvid mo imeis Yelusalem, ilansa, “Yakamiy min-Yudiy miking kweivaw, avanuy mikopweyas? Peinan nakakin anwutun kweivaw neipel, mwana nakam kid bakakulul wamatan.” ");
INSERT INTO myw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Elod iligen mamagin, ivag aspwa̱yat siney min-Yelusalem. ");
INSERT INTO myw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mapun ilivan va̱gan meivek tasiyas tanuwgwes lun, sisiyas takatimlakeins kaleiwag, katuyouns bimeis. Imeis mo ikatugan, ilana, “Kelis avanuy mikopweyas?” ");
INSERT INTO myw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ilansa, “WaBetelem, wawnuwan ven Yudiy; peinan palopit teitan nilel Yowbad anilivan mamagina: ");
INSERT INTO myw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ya̱koum ven Betelem wawnuwan ven Yudiy, bo kumug. Nag kukuyeim Yud guyawaw watiblous, nag. Peinan takaleiwag bikamat ven Betelem waseg; mtowen mo bikaleiwag gungamag Yisleil wasigeis.’ Palopit towen anilivan mamagin.” ");
INSERT INTO myw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wankuyeim Elod mo idawes bimeis tassinaps, tasiyas mwana nimeis; siney tasiyas illivans, ikatugan, ilana, “Wutun towen nukukines, avei-yam waseg neipel?” ");
INSERT INTO myw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ilivans ikous, mo ikayabes bineis Betelem, ilana, “Gwad towen kuneves beibwein; kukin bukuba̱nes, kuyums kumeis, kudibakeigs; yey mo ban akulul wamatan.” ");
INSERT INTO myw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Iliganes aygan King towen, mo inounas ineis. Wutun towen, kweiboug nikines wanuvid, bo imgwayes in, iton wakunuwatan a̱pwaw nabunatum nimsikey-yay. ");
INSERT INTO myw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikines wutun towen, mo imwa̱saws avakaein. ");
INSERT INTO myw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","E, isiws bunatum wanuwan, ikines a̱pwaw son inan Meliy, ikululs wamatan, iya̱kawns waseg. Ikous, mo ikaliyowes siwliyoug isiwyoubus a̱pwaw towen, isekes goul, o pilankisens simasim seikwan, o mul silma̱nin won takanig biptumis. Imulouls ma̱wan ikous. ");
INSERT INTO myw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wankuyeim asmikon waseg Yowbad mo ikatimlakes awoum beiyum binekes Elod, mapuna iyums inoyes kadetan ked, ineis wasiven. ");
INSERT INTO myw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wankuyeim Yowbad nataka̱yob teitan mo inek Yosep, Yosep anmikon waseg, ilana, “Kutamanaw, kutokes gwad son inan, kusawls kuneis Yidipt, kusesus ee... tutan balivan mo kuyums. Peinan Elod binineiv gwad towen, biban kid bikatimet.” ");
INSERT INTO myw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosep ikanow aygan, itamanaw boug waseg, itokes gwad son inan, ineis Yidipt. ");
INSERT INTO myw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","18","Elod gog bikayyamat tasiyas tassinaps, ikayyamata ee... nag; nanon ilana, “O bo ikatidavigs.” Kapasal nuwan, ikayabes nagamag, beiweiys kid a̱pwaw tasiyas tawaw Betelem o walasin ven wasigeis, ilana, “Tasiyas asibweilim katanok o akweiy kuwaweiysa beikous.” Peinan nikatugwan tassinaps wasigeis avei-tut nikop gwad towen. Idok kid Yeisuw bikatimet, tage Yowbad anilivan kweiboug napalopit Yelemay nilivnek mamagina: “Ven Lem waseg mo biliganes va̱lam avakaein. Lakel o vinay-nen Yisleil biva̱lams nitsiyas pines. Ta-ma̱wan bivkakes beitout ninous, peinan nitsiyas bo imtakous.” Yelemay anilivan kweiboug, bo ikamat tut towen waseg. E, Yosep siney angamag Yidipt waseg isesus ee... ikanig Elod. Peinan kweiboug napalopit nilivnek mamagina: “Natug waYidipt mo adouw im.” ");
INSERT INTO myw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","E, Elod ikanig, Yowbad nataka̱yob mo inek Yosep, anmikon waseg, igaw nises Yidipt, ilana, “Kutamanaw, kutokes gwad son inan, kuneis Yisleil; peinan towen sivinan beiweiy gwad bo ikanig. Kameiliw bo ikous.” ");
INSERT INTO myw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mtowen Yosep itamanaw, itokes gwad son inan ineis Yisleil. ");
INSERT INTO myw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Iligen Elod ikanig, o Elod natun Alkelaw, taman nakaleiwag bo ikow, ikaleiwag ven Yudiy waseg. Yosep anpwa̱yat beiyum ven towen waseg, kweitan sinap ikakin anmikon waseg, mo inoyes kidenen Galiliy, ineis ven Nasalet, isiwas. Mapuna ikamat palopit anilivan mamagina: “Bidokes towen gum-Nasalet.” ");
INSERT INTO myw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Igaw nisesus Nasalet mo Yon isilamaw nageiguy ven Yudiy wanawoud, mtowen tabibapta̱ysein gamags, ilana, “Bikanavin ninoumiy, sinap kalbaleb kulavewas, peinan Yowbad kakita bisilamaw nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Palopit towen Isaya kweiboug nilivnek Yon nawotet, ilana, “Aygan bivakaein wanawoud, bilivan, ‘Kukidumwa̱lus daGuyaws inaked; kuva̱ges beibwein.’” ");
INSERT INTO myw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mtowen Yon anakweim wunuwunun kamel, anawat kaleivin kamel, kan gog kulipaw son kitoul. ");
INSERT INTO myw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Mo inounas inekes Yon, min-Yelusalem sisiyas Yudiy gimgilis, sisiyas wunsiyas ven wadadan lay yagan Yoldan, ika̱mats asisinap kalbaleb, Yon mo ibapta̱yses tasiyas lay Yoldan waseg. ");
INSERT INTO myw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","10","Ikin tasiyas Palisiy sisiyas tasiyas Sadusiy imimeis va̱gan bibapta̱yses, mo ika̱nes, ilana, “Mwatet yakamiy, adok teitan tan niguyeimiy mapuna kuwenes Yowbad, amipwa̱yat igaw mo bikatimop amisinap kalbaleb. Adok nag kupiyaves amisinap kalbaleb. Kwatimlakeigs miwotet bwein va̱gan bakin amisinap kweivaw nukukwawes, bwanabwein. Awoum kuninuways, kulansa, ‘Yakamey bwein, peinan Ebelam delen yakamey.’ Nag gog, Yowbad kadilok dakul tasiyas bivag mo bimlavags Ebelam delen. Ebelem delen mamagina kay. Tut kadilakus mo beiteiy kay kasiyas. Kukin amata kay nag beivag anagin mo beiteiy, bilev bein wa̱kov.” ");
INSERT INTO myw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","12","Yon mo ilivan, ilana, “Yey, bo nabapta̱yseimiy yevagam waseg, peinan bo kulavewas amisinap kalbaleb. Igaw teitan beim, tatawtoun; yey nag kadilok ba̱kew inasandol, peinan guyaw avakaein. Mtowen beim mo bibapta̱yseimiy Kululuwan Bwanabwein waseg, mamagina kov. Mamagina nakaytuk wanaman biwaway anawit, va̱gan bikow anagin bwanabwein binow waseigous, simwan gog bisen bigigob kov tuta babaw.” ");
INSERT INTO myw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wankuyeim Yeisuw mo ilisow Galiliy in Yoldan, inek Yon, va̱gan kid bibaptays. ");
INSERT INTO myw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yon idok kid bisilbwed, ilana, “Kadilok kubapta̱yseig yey, awoum yey babapta̱yseim yak.” ");
INSERT INTO myw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iw to Yeisuw, ilana, “Bweina kuvag nagein. Kadiloka sinap babaw bwanabwein bitayakous.” Mo itam. ");
INSERT INTO myw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ibaptays Yeisuw ikous, iga̱lag, liba̱lab bo itavis, Yowbad Kululuwan mo ikin, ankakin ma̱wana bwabun italbelub im, iton Yeisuw wakunun. ");
INSERT INTO myw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aygan teitan walba̱lab mo iligen, ilana, “Towen Natug bwanabwein; singay ibwein nanoug waseg.” ");
INSERT INTO myw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yowbad Kululuwan mo itok Yeisuw, inow wanawoud, va̱gan Seitan biyakwen. ");
INSERT INTO myw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ipos sinawavas yam; ta-kweitan kan ikam yam waseg o boug waseg, nag. Ikous, mo ivag anamoun. ");
INSERT INTO myw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tayakwanein gamags mo isap, ilana, “Magat ya̱koum Yowbad Natun yak, amlivan kusek dakul tasiyas mo bimlavag bled bukukwam.” ");
INSERT INTO myw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeisuw ikatimop aygan, ilana, “Bukitab waseg livan nises mamagina: ‘Kan makaw nag biyamov gamag; nag. Tage Yowbad anilivan kweitan kweitan mo biyamoves gamags.’” ");
INSERT INTO myw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Ikous sinap towen, Seitan mo itok Yeisuw inow Yelusalem waseg, itamnow Yowbad nabunatum wakunuwatan, idibek, ilana, “Magat ya̱koum Yowbad Natun yak, kwaspepel kun watinow. Nag aveiyag bivag, peinan livan nises Bukitab waseg mamagina: ‘Bo bisek nataka̱yobs siwotet va̱gan bimtakavateims, binupeims yak; mata ge dakul iweiy kakeim.’” ");
INSERT INTO myw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeisuw idibek, ilana, “Kweitan livan nises mamagina: ‘Awoum kuyakwen muGuyaw Yowbad.’” ");
INSERT INTO myw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sivtounun mo itok Yeisuw, inow koy singay avakaein, ikatimlek vena babaw ikous, ikin vena babaw bwana̱bweins. ");
INSERT INTO myw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yeisuw ikin ikous, Seitan mo idibek ilana, “Kukulul wamatag mo basekeim vena babaw, wunsiyas ven mukwaleiwag ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeisuw mo ikan Seitan, ilana, “Kusineikik. Bukitab waseg kweitan livan nises mamagina: ‘DaGuyaws Yowbad bukukulul wamatan; Towen anmwa̱net bukutapwa̱loul waseg.’” ");
INSERT INTO myw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Seitan mo ilisow Yeisuw, inoun. Yowbad nataka̱yobs mo imeis, ilabes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wankuyeim kweitan tut gamag mwasanin mo inekes Yeisuw, ilansa, “Bo iyousis Yon inawes wa̱deil.” Yeisuw iligen mo inoun in Galiliy. ");
INSERT INTO myw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","In Nasalet, ilisow, in Kapaneyum mo isin. Ven towen wakawalaw, kweiboug tasiyas Seblon son Naptal siven. ");
INSERT INTO myw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Palopit kweiboug Isaya nilivnek mamagina: “Seblon son Naptal siven, palata-dadan Yoldan, yol niweiw, ven towen Galiliy nimeim; tasiyas igaw dadub misikes. Kweiboug dadub, kamnat avakaein mo ikines. Kweiboug ven kanig-nen misikes, kamnat mo isap wasigeis.” Kweiboug palopit nilivnek, tut towen bo ikamat. ");
INSERT INTO myw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yeisuw mo isilamaw nageiguy, ilana, “Kulavewas amisinap kalbaleb, peinan Yowbad kakita bisilamaw nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ivayal yevagam towen yagan Galiliy, ikin taw teitan son bwadan iplapouls, mtowen Saymon, kweitan yagan Pita, bwadan Andiluw, peinan siwotet poul-wan. ");
INSERT INTO myw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeisuw idibakes, ilana, “Kukikuns waseg yey, mo basekeimiy kweitan miwot, waseg bukukwanes gamag.” ");
INSERT INTO myw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iliganes, ipiyaves wot towen, ikikuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","22","Inounas, ineis mo ikines tawaw asteiy, Sebidiy nitun, Yemes son bwadan Yon, tasiyas sisiy times wa̱wag iymiyeims siwot. Yeisuw idawes, mo ilisawes wag towen, ilisawes times, mo ikikuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ita̱vin ven babaw Galiliy waseg, igeiguy buntuman tapwa̱loul sinagog wasigeis, livan bwanabwein isekes va̱gan bikakins Yowbad nakaleiwag; takatouns ivag ibweins; tasiyas abes igeg, ilabes mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tasiyas min-Siliy mo iliganes butun Yeisuw, imeyes takatouns, askatoun kweitan kweitan, ivag mo ibweins, tasiyas igidaged wous, tasiyas bwagaw neiweiys, takabalamats, tayda̱gwegs, ivag mo ibweins asibabaw. ");
INSERT INTO myw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gamag babaw mo ikikuns waseg, tasiyas min-Galiliy, min-Dikapolis, min-Yelusalem, min-Yudiy, sisiyas tasiyas palata-dadan Yoldan, ikikuns waseg Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yeisuw ikin gamag singay babaw, ikatulag, in wa̱koy, isin, inavamul inekes, mo isilamaw nageiguy, ikatimlakes mamagina: ");
INSERT INTO myw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yakamiy waninoumiy kulansa, ‘Nag aveiyag bwanabwein nises wakululuwem,’ bweina kumwa̱saws, peinan bukusiws Yowbad wanakaleiwag. ");
INSERT INTO myw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Kumwa̱saws yakamiy tavva̱lams, Yowbad bilabeimiy mo beitout ninoumiy. ");
INSERT INTO myw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Kumwa̱saws yakamiy tamma̱nums, igaw Yowbad mo bisekeimiy youda babaw. ");
INSERT INTO myw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Kumwa̱saws yakamiy magat biseiw nuwamiy sinap didumwal silma̱nin, igaw mo bivakaein wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Kumwa̱saws yakamiy bukusiwyoubus tasiyas abes igeg, Yowbad mo bisiwyoubumiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Kumwa̱saws yakamiy tatoukums, igaw mo bukukines Yowbad. ");
INSERT INTO myw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Kumwa̱saws yakamiy bukulabes gamag va̱gan biyakousis sikameiliw sisiyas, igaw Yowbad bilivan, ‘Nitug yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Kumwa̱saws yakamiy, kukin gamag bikamliweimiy peinan amisinap didumwal, bukusiws Yowbad nakaleiwag wanuwan yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Kumwa̱saws magat gamag bitawyageimiy, bikamliweimiy, o peinan gungamag yakamiy, siyaweid avakaein bivtokeimiy livan; bweina kumwa̱saws avakaein, maysamiy bwanabwein igaw mo bukulivatus walba̱lab. Ma̱wan magin gamag nikamliwes tasiyas palopits kweiboug. Yakamiy bo ma̱wan bikamliweimiy. ");
INSERT INTO myw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yakamiy mamagina sol silma̱nin ven babaw sabal-nen yakamiy. Kukin sol sabal-nen bigeg, ta-ma̱wan bitavkek bisabal vayuwein. Peinan bo igeg, misinaka bitalev bein watoulan, gamag mo bivva̱nis. ");
INSERT INTO myw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yakamiy vena babaw sikamnat yakamiy. Magat wunovek ven bibunis koy wakunuwatan, makava kimna̱yawl ven towen. Ma̱wan magin gamag babaw bikines mikamnat yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Lamp nigidaged, awoum takow loutan takatugibliken kunuwatan tage tasen wateibol mo bimteil bunatum, nakamnat kadilok bunatum. ");
INSERT INTO myw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Ma̱wan magin yakamiy kummiteilis gamag babaw va̱gan bikines miwotet bwanabwein, mo biyakawanes Tamads nises wanakaew. ");
INSERT INTO myw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Awoum kudokeigs yey nam tagulekwein Moses nakaleiwag o tasiyas palopit sikaleiwag, awoum. Yey nam va̱gan bakatimweis sikaleiwag, bivakaein. ");
INSERT INTO myw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Mounid adibakeimiy, nag kweitan sikaleiwag beikous tut towen waseg. Tut towen ven watinow son liba̱lab nisesus. Ma̱wan magin tasiyas Moses siney palopits sikaleiwag bisesus ee... igaw mo bikamat anagin. ");
INSERT INTO myw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kavel yak bukulivan, ‘Kaleiwag towen kakit, bweina tanumlaves talavewas,’ yak singay bukubus Yowbad nakaleiwag waseg. Tage bukwanow kaleiwag tasiyas, bukwatimlakes gamag, igaw mo bukumwen Yowbad nakaleiwag waseg. ");
INSERT INTO myw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Taninuways tasiyas takatimlakeins kaleiwag sisiyas tasiyas Palisiy, gamag babaw idokes asisinap bwein. Tage yakamiy amisinap bwanabwein bivakaein; waseg kwalsawes tasiyas. Kukin gog nag, tama̱wan bukusiws Yowbad wanakaleiwag. ");
INSERT INTO myw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kukwakins tammwayas sikaleiwag kweiboug mamagina: ‘Awoum kuweiy gamag. Kukin bukkwatimet gamag, takalleiwags mo biyateleims yak.’ ");
INSERT INTO myw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tage yey gunakaleiwag mamagina: ‘Kukin yak bukkwamliw soum, takalleiwags mo biyateleims yak. Kukin bukuyeg soum, tasiyas takaleiwag kawka̱veks wasigeis mo biyateleims yak. Kukin go bukuyeg avakaein, adok Yowbad bilaveim bukun wadiginasim, kov bigabum yak.’ ");
INSERT INTO myw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Kukin aveiyag bukukow va̱gan bukulun Yowbad waseg mo kunuw kavel nanon igeg waseg yak, bweina kusem mulun abeilun wadadan, kunoun, kun, kulun gamag towen waseg; beikous, mo kuyum kum, kulun Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kukin kavel soum biyateleim, kadiloka wa̱ked kulun amiteiy; kukin gog nag, adok soum towen bitokeim takaleiwag to gabman waseg, gabman mo bidibek plisman, bitokeim binaweim wa̱deil. ");
INSERT INTO myw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","“Mounid adibakeimiy, bukusesus wa̱deil ee... bukupa̱yin soum beikous, mo bispuyeim bukun wamnat. Kukin gog nag, bukusesun-wan wa̱deil. ");
INSERT INTO myw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kukwakins tammwayas sikaleiwag mamagina: ‘Awoum kwanavay mav.’ ");
INSERT INTO myw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tage yey gunakaleiwag mamagina: ‘Kavel yak bukumet vin, wananoum kid bo kukwanavay soum mana̱wen vin. Amsinap towen igeg.’ ");
INSERT INTO myw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Kukin gog matam wamkwa̱tay bikaleiwag mo bukukwalouw, kadiloka kugut kulev bein tana̱ban. Bweina kuyamkwen matam palatanok; mata ge tamkwa̱lan mo son woum bigob wadiginasim. ");
INSERT INTO myw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Kukin mukwa̱tay bikaleiwag va̱gan bukukwalouw, kuboub, kulev bein tana̱ban. Bweina palatanok namam; mata ge bukuyamkwen woum sona tamkwa̱lan wadiginasim. ");
INSERT INTO myw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kukwakins kaleiwag kweitan mamagina: ‘Kukin kal yak bukupiyev mukwav, kusek inalet mo kwayeb binoun.’ ");
INSERT INTO myw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tage yey gunakaleiwag mamagina: ‘Kukin kal yak, nag bukutanid, tage bukupiyev mukwav, mo kuva̱ges tasiyas bikaninavays mav son namwan teivaw.’ ");
INSERT INTO myw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kukwakins tammwayas kweitan sikaleiwag kweiboug mamagina: ‘Awoum kutabudabod mav. Bukutabudabod, bweina kuvag ma̱wan, daGuyaws silma̱nin.’ ");
INSERT INTO myw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Tage yey gunakaleiwag mamagina: ‘Awoum kutatabdabod, misinaka amlivan mounid kusek. Awoum kutabudabod liba̱lab waseg, peinan Yowbad a̱ban. Awoum kutabudabod ven watinow waseg, peinan Yowbad nakabva̱wot kaken. Awoum kutabudabod Yelusalem waseg, peinan daGuyaws inaven. Awoum kutabudabod kunum waseg, peinan ta-ma̱wan bukuvkek bipwapwa̱kaw o bigunugoun walitanok kunum, nag.’ ");
INSERT INTO myw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kukin bukutam, misinaka kulivan, kulana, ‘E!’; o kukin bukupiyev misinaka kulivan, kulana, ‘Nag.’ Peinan tabudabod babaw meinoy neim Seitan waseg. ");
INSERT INTO myw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kukwakins tammwayas sikaleiwag mamagina: ‘Soum matan nukuweiy inalug matam yak beiweiy. Soum kudun nukwatimoun, inalug kudum bikatimoun.’ ");
INSERT INTO myw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","41","Tage yey gunakaleiwag mamagina: ‘Awoum kwatimop soum peinan ansinap kalbaleb. Kukin binep silapam wamkwa̱tay, bweina kutouvin binep paliyuwein silapam. Kukin soum biyateleim bikow amukweim, bweina kusek-vak musag. Kukin soum bikaleiwag, bilana, “Kwanag kukow katanok veit,” bweina kutam, mo kukow kwayuwein veit.’ ");
INSERT INTO myw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aveiyag soum bilivan, bweina kusek, o kukin soum binitoug, awoum kwayus. ");
INSERT INTO myw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kukwakins tammwayas sikaleiwag mamagina: ‘Kusiwyoubus taliwom, kwamliwes gog tasiyas nikamliweims yak.’ ");
INSERT INTO myw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Tage yey gunakaleiwag mamagina: ‘Kusiwyoubus tasiyas nikamliweimiy; kunitougs Yowbad waseg va̱gan kid bilabes tasiyas iyagageimiy.’ Bo ma̱wan bukumlavags Tamads nitun yakamiy, peinan mtowen wanakaew nilabes takalba̱lebs sisiyas toubweins, ka̱las ivag ikal yam katanok katanok wasigeis, o kweis isekes asibabaw-wan. ");
INSERT INTO myw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Kukin bukuyamanes siwa̱youb wasigeis tasiyas nisiwyoubumiy, adok nag kweitan la̱lan bukuba̱nes, kulatanes gog simiyas tasiyas takaweins ta̱kis; peinan tasiyas iyamanes siwa̱youb wasigeis tasiyas nisiwyoubus. Ma̱wana tasiyas, ma̱wana yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“Kukin misinaka simiyas tawlimiyas bukumulouls, amisinap nag bitawtoun, peinan tobwag ven gimgilis asisinap ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Kadiloka bukuyakousis sinap bwanabwein, ma̱wan magin ansinap mtowen Tamads wanakaew. ");
INSERT INTO myw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kukin bukumulouls wasigeis tasiyas tasimavs, awoum gamag babaw bikakins, mo bilansa, ‘Singay tasiwa̱youbs tasiyas’; awoum! Magat amisinap ma̱wan, ta-kweitan maysamiy bukuba̱nes waseg Tamads, walba̱lab nises. ");
INSERT INTO myw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“E, bukumulouls wasigeis tasiyas tasimavs, awoum tayikin bwa̱gig bimgwayeimiy, mamagina tayyaweids tasiyas wavtakon ven o buntuman tapwa̱loul waseg ikaypamwes butus, va̱gan kid gamag babaw bikavasis. Mounid adibakeimiy tut towen mayses iba̱nes, tage wanakougwaw bo nag. ");
INSERT INTO myw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Kavel yak bukumuloul wasigeis tasiyas tasimavs, kadiloka kukwawum mumuloul; awoum teitan gamag bikakin. ");
INSERT INTO myw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","“Mamagina kusowm mumuloul, Tamads anmwa̱net bikin, igaw maysam mo bisekeim.” ");
INSERT INTO myw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yeisuw ilivan, “Gamag mwasanin bo initougs Yowbad waseg, itamanaws itowas wabunatum yagan sinagog, o itowas wavtakon ven mo initougs; tayyaweids gog. Peinan sivines gamag babaw bikakins, bo kid bilansa, ‘O singay tantougins Yowbad tasiyas.’ Ivavags mav, gamag tasiyas. Mounid adibakeimiy tut towen mayses iba̱nes; tage igaw gog wanakougwaw bo nag. ");
INSERT INTO myw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“O yakamiy awoum kuva̱ges ma̱wan. Kal yakamiy binitoug, kadiloka beisiw wanbunatum wanuwan, bikatibog koukwed, anmwa̱net bikulul wamatan Yowbad, mo binitoug. O Tamads bikin anmwa̱net ininitoug, igaw maysan mo bisek. ");
INSERT INTO myw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Kukin bukunitougs, awoum kulivans ma̱wana tamgamegs igaw dadub. Idokes kid biba̱nes youd babaw, peinan asilivan babaw, aveiyov. Awoum kunitougs ma̱wan. E, bukunitougs Tamads waseg, bo ikakin nanawan aveiyag sivinamiy. ");
INSERT INTO myw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","“Kadiloka kunitougs mamagina: ‘Timem walba̱lab, Yagam bakagoul, Mukwaleiwag beim. Aveiyag aw-nanoum sivinam ven watinow bakavag, ma̱wan ivva̱ges walba̱lab. Kaem bukusekem nagein. Kunumlev makalbaleb ma̱wan kanumlev gamag sikalbaleb wasigeis yakamey. Awoum bukusenam abiyokon waseg. Igaw kalbaleb waseg kwatinabwem.’ ");
INSERT INTO myw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bukunumlaves o bukuwidis youd babaw wasigeis gamag tasiyas niyagageimiy, igaw gog Tamads mo biwid amisinap kalbaleb yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","“Tage nag bukunumlaves o bukuwidis asisinap tasiyas niyagageimiy, Tamads gog nag biwid amisinap kalbaleb yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Igaw tutan bukupos, tapwa̱loul silma̱nin, awoum bimma̱yag mitamiy, awoum beivag amisinap ma̱wan tasiyas tayyaweids, ivag mamagina siwsawoul wous, va̱gan gamag bikines, bilansa, ‘O singay tapsapos tasiyas.’ Mounid adibakeimiy, tut towen mayses iba̱nes, tage tut wanakougwaw bo nag. ");
INSERT INTO myw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Kal yak bukupos tapwa̱loul silma̱nin, kuwid magim, kusinat, kuput; mata geg gamag bikakins, anmwa̱net Tamads bikakin imupos wanuwam, mtowen maysam mo bisekeim. ");
INSERT INTO myw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Awoum kwatinakus miwliyoug babaw ven watinow waseg. Ven watinow wuliyougwan ipwapoup o man kekel ikamkoums, o gamag mwasanin ikaliyowes bunatum ivveinaws. ");
INSERT INTO myw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","“Tage liba̱lab wuliyougwan bukwatinakus, nag beipoup, man nag beikoums, ta-kal biven; bwein-wan. ");
INSERT INTO myw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Ampalawen muwliyoug kwatinok, mo biseiw nuwam ven towen. ");
INSERT INTO myw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Woun kamnat-nen matad. Kukin matam inakaleiwag bwein, woum mo bikamnat. ");
INSERT INTO myw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","“Tage kukin matam inakaleiwag kalbaleb, woum bo bidadub. O peinan mukwamnat bo idadub, woum singaya dadub. ");
INSERT INTO myw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ta-ma̱wan gamag anmwa̱net bikanow ages natuwa̱veks asteiy; adok bikamliw natovek teitan, tayuwein gog bisiwyoub; adok bikanaway aygan teitan, tayuwein gog bipiyev. E, ta-ma̱wan gamag bikanow ages takaleiwags asteiy, teitan Yowbad, tayuwein money. Misinaka anmwa̱net aygan bikanow. ");
INSERT INTO myw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mapun adibakeimiy, awoum bikubukub nuwamiy silma̱nin kaemiy va̱gan biyamoveimiy, o silma̱nin amikweim va̱gan bukusikams. Peinan kan na-ikadilok bigimwel mwamovads, o kweim na-ikadilok bigimwel kaleivids, nag. ");
INSERT INTO myw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Kukines mansiyas man iyoyows wanakaew, ta-isapwes kan, ta-ita̱yoys, ta-isenas waseigous; nag. Tamads wanakaew ituyay mansiyas man, mounid mo bitutuyeimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","29","“Nag kavel ya̱koum bukuninuway mutawtoun waseg va̱gan ambweilim bibabaw; nag. Aveiyag wawun kuninuwes amikweim? Kukines la̱lan moloubaw nitatos, na-iwotets, na-iba̱lals, nag; tage askakin singaya bwanabwein. Mounid adibakeimiy kay kasiyas la̱lan ikalisow Solomon antubub. ");
INSERT INTO myw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Kay kasiyas nagein nitatos, nubweig beiyakous, bigob kov. Yowbad kay kasiyas isek astubub, mounid mo bisekeimiy amikweim. Adok nag kunmises bwein va̱gan Yowbad bimtakavateimiy. ");
INSERT INTO myw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","“Awoum ninoumiy bibabaw; awoum kulansa. ‘Aveiyag bitakams? Aveiyag bitamoums? Aveiyag bitasikams?’ Tasiyas igaw dadub asisinap ma̱wan; yakamiy awoum. Tamads gog wanakaew ikakin sivinamiy youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Towen nakaleiwag bimug waninoumiy, o ansinap didumwal bimug waninoumiy, igaw aveiyag sivinamiy mo bisekeimiy. ");
INSERT INTO myw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Nagein kuninuways aveiyag sivinamiy nagein; nubweig mo kuninuways aveiyag sivinamiy nubweig. Yamtan yam mouvitan kweitan; kwayuwein yam mouvitan kweitan. ");
INSERT INTO myw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Awoum kudibek soum, kulana, ‘Yak kalbaleb yak.’ Adok Yowbad mo bidibakeim ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","“Mikaleiwag waseg bukwalawages simiyas, Yowbad ma̱wan mo bikaliwageimiy yakamiy. Magat mukwaleiwag kalbaleb wasigeis simwey. Yowbad mo bikaleiwag ma̱wan waseg ya̱koum. Kukin gog bwein. Yowbad mo bikaleiwag bwanabwein waseg ya̱koum. ");
INSERT INTO myw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","“Adok kukin soum matan musamusan kakit nises, tage nag kukwakin amweilok avakaein wanuwan matam yak nises. “Kulivan kid, kudibek soum, kulana. ‘O musamusan wamatam nises, bakablev’; tage amweilok avakaein matam tatoneim wanuwan nises. “Tayyaweid yak! Kwablev amweilok towen wamatam nises. Ikous, wankuyeim mo bukukinbunik va̱gan bukwablev musamusan towen, soum wamatan. ");
INSERT INTO myw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Awoum Yowbad navavag kuvgen kusekes mansiyas awuk, adok bipiyaves mo bigadeimiy. Awoum veigun kulev bwaloud waseg, mata ge bivva̱nis, bivatunis bikatigayay, bo bigeg. ");
INSERT INTO myw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kunitougs, mo bisekeimiy; kunineivs mo bukuba̱nes. Kugipits, mo bikaliyow nakoukwed pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Tasiyas gog tannitougs ikokews sivavag; tasiyas taninineivs mo biba̱nes sivavag, o tasiyas taggipits, mo bikaliyow koukwed pines tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Adok ta-kal yak, kukin natum binitoug kan mo bukusek dakul; adok nag. ");
INSERT INTO myw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Adok ta-kal yak, kukin natum binitoug in mo bukusek mwatet; adok nag. ");
INSERT INTO myw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Yakamiy takalbalebs yakamiy kukwakins youd bwein bukusekes nitimiyas; singay gog Tamads wanakaew bisekeimiy youd bwanabwein, magat bukunitougs waseg. ");
INSERT INTO myw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aveiyag sivinamiy va̱gan gamag biva̱ges wasigeis yakamiy, kadiloka kuva̱ges ma̱wan wasigeis tasiyas. Moses siney kweiboug palopits sikaleiwag ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Kusiws koukwed kabkakit waseg, peinan diginasim kidenen avakaein, awkwedan baba̱yay, gamag babaw isowsiws, inounas waseg; tage mwamov kidenen kabkakit, awkwedan kabkakit, gamag na-ibabaws bisousiws makadewen ked. ");
INSERT INTO myw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","16","“Kuvna̱semiy, awoum kuliganes ages palopit tasiyas tayyaweids, tasiyas igaw bisaps wasigeis yakamiy, askakin ma̱wana sip, tage wanuwes ma̱wana awuk nakananeiy. Igaw bukukines siwotet mo bukukwakins asisinap bwein, o nag, kalbaleb. Peinan gamag ma̱wana kay. “Adilaboub nag beivag gleip anagin, o ayliluweis nag beivag yaveinun anagin, nag. ");
INSERT INTO myw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","“Kukin amweilok bwein, mo beivag anagin bwein; kukin gog kalbaleb, mo kalbaleb anagin. Mapun alana, ‘Bukukines siwotet mo bukukwakins asisinap ama̱wan.’ ");
INSERT INTO myw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","“Ta-ma̱wan kay bwanabwein beivag anagin kalbaleb, nag. Ta-ma̱wan kay kalbaleb beivag anagin bwein, nag. ");
INSERT INTO myw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Kay kasiyas nag beivag angis, bo beiteiys bilaves bein wa̱kov. ");
INSERT INTO myw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","“Gamag tasiyas bo ma̱wan, bukukines angis mogo kukwakins asisinap bwein, o nag, kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Gamag babaw bidibakeigs, bilansa, ‘MaGuyaw yak,’ tage babaw nag beisiws Yowbad wanakaleiwag, nag. Misinaka tasiyas takaweins aygan Tamag, nises walba̱lab. ");
INSERT INTO myw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Igaw yam towen waseg babaw gamag bidibakeigs, bilansa, ‘Nakageiguy yagam waseg, o nakakawsep bwagaw yagam waseg, o yagam waseg mawotet singay tawtoun.’ ");
INSERT INTO myw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Yey mo bakatimop ages, balana, ‘Tobwag gamag yakamiy, kunounas, kuneis, peinan miwotet kalbaleb.’ ");
INSERT INTO myw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Kal yak bukuligen aygag, bukwanow, ya̱koum mamagina tassinap teitan; towen niwlul nabunatum dakul wakunuwatan. Iwlul ikous, kweis mo ikweis avakaein, yevagam ila̱tay, yag avakaein itow, tage nag igulek bwan towen, peinan niwlul dakul wakunuwatan. ");
INSERT INTO myw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","“Kal yak bukuligen aygag, bukupiyev, ya̱koum mamagina takabala̱wein teitan, towen niwlul nabunatum walekel. Iwlul ikous, kweis mo ikweis avakaein, yevagam ila̱tay, yag avakaein itow, ikalouw bwan towen, singay nuwanaw angwelek.” ");
INSERT INTO myw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Iyakous Yeisuw anilivan towen, bo isom ninous tababaws tasiyas aniganeg aygan waseg, peinan tawtoun ansinap. Nag ma̱wan tasiyas takatimlakeins kaleiwag, nag; tage Yeisuw ansinap sinap tatonen. ");
INSERT INTO myw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Koy towen waseg, Yeisuw iwloubus, singay babaw gamag ibukunis. ");
INSERT INTO myw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Toulepel teitan isineikim, ikulul, ilana, “Guntovek yak, magat sivinam, kadilokeim bukuvag kaleivig beibwein.” ");
INSERT INTO myw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeisuw isen naman wa̱won toulepel towen, ilana, “Bo bukubwein,” mo ibwein kaleivin towen. ");
INSERT INTO myw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeisuw mo idibek, ilana, “Awoum kwamtel sinap towen. Awoum teitan gamag kudibek. Misinaka kukwa̱mat tanuwagan lun waseg, kumuloul waseg Yowbad, ma̱wan Moses nakaleiwag; gamag bikineims, bikakins bo kubwein, mo bilansa, ‘O bo ibwein taw.’” ");
INSERT INTO myw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yeisuw inoun in Kapaneyum, siyas Lom takanaviys sitakalikay mo inek Yeisuw, initoug waseg, ilana, “Guntovek yak, guntouwat ikatoun avakaein, nimmasis wabunatum, ta-ma̱wan bininoun, singaya igidaged won.” ");
INSERT INTO myw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeisuw idibek, ilana, “Yey baw, bavag mo beibwein.” ");
INSERT INTO myw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Takalikay towen ikatimop aygan, ilana, “Adok nag. Peinan guyaw ya̱koum, o yey toul, nag kadilok bukusiw wagunbunatum. Misinaka kulivan mo beibwein guntouwat. Yey gunakaleiwag nises wasigeis guntakanaviys, teitan badibek ‘Kunoun’ mo binoun; teitan badibek ‘Kum’ mo beim; guntouwat badibek ‘Kuvag towen’ mo bivag. Kaleiwag akakin; misinaka kulivana beibwein.” ");
INSERT INTO myw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","12","Yeisuw iligen, bo isom nanon, itouvin idibakes tasiyas tabkunins, ilana, “Guma-Lom towen singay inamis va̱gan baleb! Ta-aban gum-Yisleil teitan inasimounid ma̱wana taw towen. Mounid adibakeimiy ven babaw gimgilis beisiws Yowbad nakabkaleiwag waseg, peinan gamag tasiyas wanuvid sisiyas tasiyas wayavat bo beisiws bikaypuls Yowbad wanakabkaleiwag waseg, sisiyas tamumwey tasiyas Ebelam, Aysak, Yekob. Tage Ebelam tibun mwasanin Yowbad bilev, bineis watoulan, dadub waseg, bivva̱lams o bikakikilis kumtus, peinan igeg abes tasiyas.” ");
INSERT INTO myw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yeisuw mo idibek takalikay towen, ilana, “Bweina kunoun; musimounid waseg bo bivag mawa̱na nanoum.” E, tut towen waseg, mo ibwein natouwat. ");
INSERT INTO myw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","15","Yeisuw mo isiw in Pita wanbunatum, ikin yawan ikatoun, itaka̱lon won; ikabkwen naman mana̱wen vin mo iloulun won, itamanaw mana̱wen; ikatineg kan Yeisuw beikam. ");
INSERT INTO myw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kwayav waseg mo imeyes tasiyas bwagaw nibugawus, ilivan mo ikilaves, o asibabaw takatouns tasiyas ivag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wotet towen kweiboug palopit Isaya ilivnek mamagina: “Im ikow adkatouns, inow, ilavew tana̱ban, iva̱geids gog mo tabweins.” ");
INSERT INTO myw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeisuw ikin gamag singay babaw ikatuyouns nimeis, mapun idibek nagamag, ilana, “Kadiloka tatouws, tadopels, taneis palatan.” ");
INSERT INTO myw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ilivan mo im takatimlakein kaleiwag teitan, ilana, “Tamwey, bo babwa̱kun waseg ya̱koum ampalawen bukunoy.” ");
INSERT INTO myw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iwa̱ge Yeisuw, ilana, “Awuk bulawud sikabmasis sam wanuwan leg, o mansiyas man iyoyows sibunatum nises wakamweilok; tage Gimgilitoun yey ta-ivag gunakabmasis.” ");
INSERT INTO myw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inavamul teitan idibek, ilana, “Yey babkunim, guntovek yak; tage bavta̱meim wanamug ga ba̱yum ban wagunbunatum, bamtakavet tamag, igaw bikanig mo babkunim yak.” ");
INSERT INTO myw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeisuw ilana, “Awoum. Tut towen kubwa̱kun waseg yey. Bweina takanigs tatineis bidibwanis.” ");
INSERT INTO myw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeisuw iginitouw in wa̱wag, navamul itouws wankuyeim, mo ikuks. ");
INSERT INTO myw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikuks ee... bwaw avakaein ilivatus, kakita bimukuls; tage Yeisuw bo imasis. ");
INSERT INTO myw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Navamul aspwa̱yat inekes Yeisuw, iwgunis, ilansa, “Matovek yak, kukit, kwatinabweids, bo bitamukuls.” ");
INSERT INTO myw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ilana, “amipwa̱yat? Adok nag kusimounids waseg yey, ne?” Mo ikit, itamanaw, ikan yag son kaysay, mo idabab, iniwal singay avakaein. ");
INSERT INTO myw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gamag tasiyas ikines, isom ninous, ilansa, “Taw towen kweitana gamag; yag son kaysay iliganes aygan.” ");
INSERT INTO myw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","29","Ikuks ee... ilugs palatan, ven Gadal waseg. Gamag alugwes watakunumwan tawaw asteiy nisesus, yeiluw neiweiys, singay kapasal nuwes; nag kadilok gamag binoyes makadewen ked. Tut towen ilugs tasiyas asteiy ilisawes takunumwan, imekes, iwaks, ilansa, “Awoum aveiyag bukunuwakem yakamey, Yowbad Natun yak. Mata nuwanaw bukuyagagem yakamey.” ");
INSERT INTO myw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Ikines kadiveiyov bwaloud babaw ikamkwams awuyow. Yeiluw tasiyas igilagels, initougs Yeisuw waseg, ilansa, “Bweina kwayabem bakan baka̱siw mansiyas bwaloud wasigeis, ke?” ");
INSERT INTO myw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ilana, “Kuneis.” Ineis, isiws mansiyas bwaloud wasigeis, ikabala̱weins, nuwanaw isisawls, papap waseg ikalka̱louws, inineis yevagam towen waseg, iwgweles. ");
INSERT INTO myw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tasiyas tamtakavateins aleis isawls, ineis waven ika̱mats sinap towen, peinan yeiluw ilisawes gamag, isiws bwaloud wasigeis, iyagages. ");
INSERT INTO myw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Misikena gimgilis asibabaw-wan mo isaps, imekes Yeisuw, initougs waseg, ilansa, “Kadiloka kunoun kulisawem.” ");
INSERT INTO myw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mapuna itouws wa̱wag, ikuks, iyums, ineis Yeisuw wanven. ");
INSERT INTO myw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Gamag mwasanin mo imeyes taw teitan ankatoun avakaein, immasis wakaban, ta-ma̱wan binoun. Yeisuw ikakina tasiyas inamis va̱gan bileb, mapuna idibek takatoun towen, ilana, “Kalin nuwag ya̱koum; amsinap kalbaleb bo awid.” ");
INSERT INTO myw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Takatimlakeins kaleiwag mwasanin bo ikatilutegs, sisiyas illivans, ilansa, “Anilivan waseg ikaypom Yowbad ansinap; singay kalbaleb!” ");
INSERT INTO myw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","5","Tage Yeisuw ikakin ninous, mapuna idibakes, ilana, “Aveiyag wawun ninoumiy kalbaleb? Bweina balivan, balana, ‘Bawid amsinap kalbaleb beikous,’ o bweina balivan-vak balana, ‘Kutamanaw kunoun.’ Wotet akweiy gagab waseg yey. ");
INSERT INTO myw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Kadiloka kukwakins Gimgilitoun yey, o gunakaleiwag nises ven watinow va̱gan bawid gamag asisinap kalbaleb, mapuna badibek taw towen bitamanaw binoun.” Yeisuw idibek, ilana, “Kutamanaw, kukow, a̱bam, kunoun kun wambunatum.” ");
INSERT INTO myw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Taw towen iligen, itamanaw, inoun in wanbunatum. ");
INSERT INTO myw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gamag babaw ikines, igoulus Yeisuw, iya̱kawns Yowbad waseg, peinan bo isek kaleiwag towen wasigeis gamag. ");
INSERT INTO myw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeisuw inoun in, ikin taw teitan yagan Matiw, isin wakaban, gamag isita̱kis ikokew; Yeisuw idibek, ilana, “Kukikun waseg yey.” Mtowen iligen, itamanaw, ibukun Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wankuyeim ikamkwam wanbunatum, takalbalebs babaw imeis, tasiyas takaweins ta̱kis sisiyas takalbalebs mwasanin ikaypuls sisiy Yeisuw siney navamul. ");
INSERT INTO myw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tasiyas Palisiy ikines, idibakes navamul, ilansa, “Aveiyag wawun mitovek ikamkwam siney takalbalebs sisiyas tasiyas takaweins ta̱kis? Bo igak!” ");
INSERT INTO myw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Yeisuw iligen asilivan, ilana, “Misinaka takatouns sivines doket, toubweins nag. Kadiloka kukwakins silawun Yowbad anilivan mamagina: ‘Sivinag siwa̱youb; makava lun apiyev.’ Yey nam silma̱nin takalbalebs, awoum badawes tasiyas toubweins.” ");
INSERT INTO myw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yon navamul mo inekes Yeisuw, idibakes, ilansa, “Yakamey kapsapos, tasiyas Palisiy ipsapos; tage mivamul ipiyaves pos. Aveiyag wawun?” ");
INSERT INTO myw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeisuw ankabebay isekes, ilana, “Kukin kal beivays son nakwav, o taliven bineis biva̱ges kan silma̱nin inakamkwam; bimwa̱saws-wan; ta-ma̱wan biva̱lams, nag. Tage tutan anadouw waseg, taw towen binoun, mo biva̱lams taliven, beipos.” ");
INSERT INTO myw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ankabebay kweitan isen mamagina, “Kweim sigsa̱gob ta-ma̱wan bitabweil waseg kweim kweivaw; bitabweil bo bitadud avakaein.” ");
INSERT INTO myw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kwayuwein ankabebay mamagina. “Awoum bitavgog kunasoup kweiboug, waseg wayn kweivaw; igaw beilol, bitavis kunasoup, biyamkwen wayn; tage kunasoup kweivaw bwein, bitavgog wayn kweivaw waseg, bo bisesun bwein, peinan tawtoun.” ");
INSERT INTO myw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Igawa igeiguy wasigeis, takaleiwag teitan im, ikulul wamatan, ilana, “Natug kuda̱vin mwana ikanig, kum kusen namam wa̱won, va̱gan bukuyamov.” ");
INSERT INTO myw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeisuw itamanaw ibukunis taw towen sen navamul. ");
INSERT INTO myw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Igaw inounas, vin na̱tan isap watibwelon, buya̱vin iwta̱wout yam babaw, bweilim sinawatan akweiy nag beibwein. Nanon ilana, “Bo bakabkwen Yeisuw anakweim, mo ba̱bwein;” mapuna watibwelon Yeisuw ikabikon anakweim matan. ");
INSERT INTO myw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeisuw itouvin, ikin, ilana, “Kalin nuwag ya̱koum. Nukusimounid waseg yey mapuna bo kubwein.” Mo ibwein tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeisuw inoun in takaleiwag towen wanbunatum, ikin taykiyiks pikolel iykiyiks, tavva̱lam ivva̱lams, butus gamag singay avakaein. ");
INSERT INTO myw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yeisuw ikin, ilana, “Kunounas. Nag imat gwad towen, immasis-wan.” Tasiyas gog isiba̱wes, idokes kid Yeisuw takabala̱wein. ");
INSERT INTO myw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tage Yeisuw ikayabes, ineis watoulan, mo isiw wabunatum, iyous gwad towen naman, mo itamanaw. ");
INSERT INTO myw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Butun inawotet towen inganegs ven towen avakaein waseg. ");
INSERT INTO myw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeisuw inoun in, tawaw asteiy ibukunis, ikaw mites, iwkuwaks ilansa, “Ya̱koum Deibid tabun ya̱koum, kusiwyoubum.” ");
INSERT INTO myw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Isiw wabunatum, tasiyas inekes. Yeisuw ikatiga̱nes, ilana, “Tab kusimounids guntawtoun silma̱nin wotet towen?” Ilansa, “E, ma̱wan, peinan guyaw yak.” ");
INSERT INTO myw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yeisuw mo ikabkwen mites, ilana, “Peinan nukusimounids waseg yey, mapuna bo bukubweins.” ");
INSERT INTO myw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mo ilal mites. Anilivan tawtoun isekes, ilana, “Awoum kwamteles sinap towen.” ");
INSERT INTO myw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tasiyas gog, mo inounas ika̱mats, vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","33","Yeisuw siney navamul inounas ineis, gamag mwasanin mo imeyes taw teitan takakon, bwagaw neiweiy anilivan wadadan. Bwagaw towen Yeisuw ikayeb mo ikilev, gamag towen mo ilivan bwein. Gamag babaw ikines, bo isom ninous, ilansa, “Sinap kweitan-wan. Kweiboug nag takines wadavanuys, min-Yisleil ya̱kids, peinan kweivaw sinap towen, tawtoun.” ");
INSERT INTO myw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tasiyas gog Palisiy, ilansa, “Natawtoun, peinan Seitan ileb, Seitan siyas bwagaw sitovek. Seitan ileb mo ikayabes bwagaw.” ");
INSERT INTO myw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeisuw ita̱vin ven katanok katanok wasigeis, sisinagog wasigeis ikatimlakes gamag, Yowbad nakaleiwag bwanabwein liva̱nen issekes tasiyas, o takatouns katanok katanok iva̱ges mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","38","Ikin gamag singay babaw mo inok nuwan, peinan kululuwes isiwsawoul, peinan bo ilassulis ked, ma̱wana sip; o ta-kal bimgwayes. Mapuna idibakes navamul, ilana, “Kan babaw bo imatuw, asteiyuy bitayoys; kunitougs daGuyaws Yowbad va̱gan kid bikayabes tawwotets bilabeids kid mo bitatayawes inabag towen.” ");
INSERT INTO myw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeisuw mo idawes navamul sinawatan teiy, imeis, mo isekes sikaleiwag va̱gan bwagaw bikayyabes, o takatouns biva̱ges beibweins, askatoun kweitan kweitan waseg. ");
INSERT INTO myw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Tasiyas sinawatan teiy takaweins liva̱nen Yeisuw yiges mamagina: Saymon, yagan kwayuwein Pita; Saymon bwadan Andiluw; Yemes, mtowen Sebediy natun; Yemes bwadan Yon; Pilip son Batolomiw; Tomas son Matiw, mtowen takawein ta̱kis; Yemes, mtowen Alpiyow natun, son Tadiw; kweitan gum-Kenan yagan Saymon, son Yudas Iskaliyot, mtowen tasikodein Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Tasiyas sinawatan teiy Yeisuw ikayabes silma̱nin nawotet; iguyes, ilana, “Misinaka kunekes sidayas min-Yisleil, mtasiyas ikanka̱nigs peinan ilassulis ked. Awoun kunekes tobwag ven gimgilis tasiyas ages kweitan; awoum bukuneis ven Samaliy waseg; awoum. ");
INSERT INTO myw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Igaw bukunounas, kuguyes gamag, kulansa, ‘Yowbad nakaleiwag kakita bisap.’ ");
INSERT INTO myw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Takatouns kuva̱ges beibwein; takanigs kuymoves; tasiyas toulepel kuva̱ges kalivis beibwein, bwagaw kwayabes binounas bineis tana̱ban. Peinan Yowbad nisiwyoubumiy, bweina kusiwyoubus tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Money awoum kukwawes, goul dakul, o silib dakul, o kopa dakul; awoum. ");
INSERT INTO myw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Awoum kunamiy kukwawes wa̱ked. Amikweim mwayntanok kusikams; awoum mwaynatan kukwawes; misandol awoum; mikaytuk awoum. Peinan wotet towen bukukwawes, kaeimiy mo bukuba̱nes, maysan wotet. ");
INSERT INTO myw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Amata ven waseg bukuneis, kwatugwans gamag wasigeis kavel ansinap bwanabwein, mo kusiw wanbunatum, kusesus ee... mo kunounas. ");
INSERT INTO myw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","“Aw-bunatum bukusiws waseg, kumulouls wasigeis tasiyas, mo livan siwa̱youb kusekes. Kukin asisinap bwanabwein, mo bimwa̱saws tasiyas; kukin gog nag, livan towen bwanabwein mo beiyum wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kukin bipiyaveimiy o bipiyaves amilivan, igaw bukulisawes ven towen kwatsapis kikeimiy musamusan bein ven towen, mo bikakins asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Kweiboug Yowbad iweiys min-Sodom, min-Gomol peinan asisinap kalbaleb; tage wunsiyas ven ipiyaveimiy asisinap singay kalbaleb. Igaw tutan Yowbad bikatukin, kalamwey-nen beiweiys min-Sodom, min-Gomol, tage singaya-wan beiweiys wunsiyas ven nipiyaveimiy. ");
INSERT INTO myw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Akayabeimiy silma̱nin wotet towen. Igaw bukuneis, bukunekes babaw gamag bikamliweimiy. Yakamiy mamagina mansiyas sip tage tasiyas mamagina awuk bulawud biyagageimiy. Kadiloka kuva̱ges amisinap bitawtoun, o kuyma̱nums mamagina bwabun yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","“Kumtakavateimiy, peinan gamag biyateleimiy ya̱tal avakaein waseg, o sisinagog wasigeis biwaweimiy vatul waseg; biyateleimiy wamtes tasiyas takaleiwags kavka̱veks, o king mwasanin wamtes, peinan gungamag yakamiy; mo bukukwa̱mats liva̱neig. Tasiyas binganegs, sisiyas tobwag ven gimgilis. ");
INSERT INTO myw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","“Igaw biyateleimiy ya̱tal avakaein waseg, awoum ninoumiy bibabaw, awoum kuninuways ama̱wan bukulivans; peinan ya̱tal wanuwan, amilivan tawtoun Yowbad mo bisekeimiy. Nag tatineimiy bukulivans, peinan Tamads Kululuwan bikatipel ansinap, anilivan waseg bukulivans. ");
INSERT INTO myw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tut towen wanakougwaw, tuwan bisilkod bwadan, va̱gan takaleiwags bikatimates, o taman bisilkod natun va̱gan takaleiwags bikatimates; o nitsiyas bipiyaves sikaleiwag timsiyas insiyas, bisilkodes va̱gan gamag mwasanin bikatimates. ");
INSERT INTO myw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","O peinan kukwawes yagag yey, gamag babaw mo bikamliweimiy yakamiy. Kukin gog bukusimkines gunawotet waseg, igaw mo bukusesus bwein. ");
INSERT INTO myw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Kukin gamag mwasanin biyagageimiy ven kweitan waseg, kusawls, kuneis kweitan ven. Mounid adibakeimiy, igaw vena babaw Yisleil waseg, bukutita̱vins ee... Gimgilitoun yey mo ba̱yum bam, tage yakamiy igaw-wan; nag bukuyakousis. ");
INSERT INTO myw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Navamul awoum bimgwey natakatimlakay waseg; natouwat awoum bikaleiwag natovek waseg. Tage gunavamul yakamiy ma̱wana mitakatimlakay yey, o guntouwat yakamiy ma̱wan mitovek yey. Bo idokeigs baloum yey, singay bo bitawyageimiy, peinan gungamag yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Awoum kuwenes gamag tasiyas. Sinap babaw gamag mwasanin nikawwumes, tage igaw gamag babaw mo bikines kamnat waseg, bikakins. ");
INSERT INTO myw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Sinap bo akatamwa̱lag boug waseg, nukuliganes, va̱gan bukugeiguys wavtakon ven, wuda̱yam waseg. ");
INSERT INTO myw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Awoum kuwenes tasiyas bikatimates kalivimiy, peinan nag kadilok bikatimates kululuwamiy. Tage kadiloka kuwenes towen biyageg kululuwamiy son kalivimiy wadiginasim, ven to kalbaleb waseg. ");
INSERT INTO myw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","“Adok maysan skwa̱sik mwanay misinak kweinim toya, tage mwanatan beimat Tamads mo bikakin. Kunukun babewein Tamads bo ivin babewein wakunuds; ansinap tawtoun, bo kadiloka bimtatavateimiy. Awoum kuwenes gamag tasiyas, peinan Tamads imtakavatemiy; maysamiy singay imug mansiyas skwa̱sik wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kal yak bukwamtel wamtes gamag, bukulana, ‘Yey Yeisuw nagamag yey’, igaw mo bakamtel wamatan Tamag wanakaew, balana, ‘Towen gungamag tonen.’ ");
INSERT INTO myw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kukin gog kavel yak bukwaya̱neig wamtes gamag, yey mo bakaya̱neim wamatan Tamag wanakaew. ");
INSERT INTO myw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Awoum kunuways yey nam ven watinow niwal silma̱nin; niwal awoum, tage naviy silma̱nin. ");
INSERT INTO myw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Yey nam va̱gan magaltawaw mwasanin bivatays wasigeis timsiyas, o magalvinay bivatays wasigeis insiyas o wasigeis yiwsiyas, peinan gamag taliven bo bikamliwes. ");
INSERT INTO myw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kal yak kusiwyoubus avakaein tamam son inam, tage yey kusiwyoubug kakit, nag kadilok bukusesuna gungamag ya̱koum. Kal yak kusiwyoubus avakaein nitum, tage yey kusiwyoubug kakit, nag kadilok bukusesuna gungamag ya̱koum. ");
INSERT INTO myw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“Kadilok bukukow amklos, bukwabkunig va̱gan mo bukukwanig; tage kukin bukupiyev, nag kadilok bukusesuna gungamag ya̱koum. ");
INSERT INTO myw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Kukin bukwayus mwamovam, bo biyamkwaneim; kukin gog biyamkwen mwamovam peinag yey, igaw mo bukuba̱nes. ");
INSERT INTO myw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kukin kal beitam waseg yak, mamagina bo itam waseg yey; mo itam-vak waseg Yowbad, peinan Yowbad nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Kukin kal yak bukwaveiyon waseg palopit teitan, peinan palopit towen, mogo palopit maysan bukukow. Kal yak bukwaveiyon waseg tadidumwal, peinan tadidumwal towen, mogo maysan tadidumwal bukukow. ");
INSERT INTO myw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Kal yak bukusiwa̱youb kakit teitan gwad waseg, peinan gunavamul towen, mamagina kwavtanok anasoup bukusek, mounid adibakeim maysam nag biyamkwen.” ");
INSERT INTO myw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeisuw anilivan towen, imulis nagamag tasiyas sinawatan teiy. Imulis ikous, inoun in ven babaw, ikatimlakes gamag babaw, igeiguy. ");
INSERT INTO myw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Misumkwey towen Yon nises wa̱deil, mtowen tabibapta̱ysein gamags, butun Yeisuw inawotet iligen, ikayeb navamul mwasanin inekes Yeisuw, ikatugans, ilansa, “Yowbad bikayeb Mesay beim, mtowen ya̱koum? o nag? tabta teitan bakakayamat igaw beim wankuyeim?” ");
INSERT INTO myw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","6","Yeisuw ikatimop asilivan, ilana, “Kuneis, kwatimlakes Yon sinap towen nukukines o kuliganes; magina toukwaws mites bo ikiplal, takagayals bo inounas bwein, toulepels bo ibwein kalivis, tasiyas ituy tiges bo iliganes livan, takanigs bo ikits mwasanin, o tasiyas tasimavs inganegs Yowbad anilivan bwanabwein. Kal yak bukusimounid gunawotet waseg, tage ta-kupiyaveig, igaw mo bukumwa̱saw.” ");
INSERT INTO myw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iyums tasiyas, Yeisuw mo ikatiga̱nes gamag babaw peinan Yon, ilana, “Kweiboug kuneis wanawoud, aveiyag silma̱nin bukukines? Bukukines kay iguwen yag, ne? ");
INSERT INTO myw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“O bukukines gamag teitan anakweim mwaynamnabwein ne? Nag, adok tasiyas nisesus guyawaw wasibunatum. ");
INSERT INTO myw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Tage, kuneis kukines palopit teitan. Mounid mtowen Yon nimgwayes palopit wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Peinan liva̱nen Yon nises, magina Yowbad anilivan nidibek Mesay, palopit mo ilel Bukitab waseg mamagina: ‘Akayeb guntouwat bimgwayeim, bikidumwal muked beibwein.’” ");
INSERT INTO myw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yeisuw mo ilana, “Mounid adibakeimiy nag kal nikop ven watinow ikalsow mtowen Yon, peinan Yon ikalsawes gamag babaw; tage Yowbad nakaleiwag kweivaw waseg asibabaw ikalsawes Yon. ");
INSERT INTO myw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Misiya̱mun Yon inawotet waseg, tasiyas tatawtouns sivines Yowbad nakaleiwag, isilamaws sitawtoun waseg iyyousis ee... nagein bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Tut kweiboug Moses nakaleiwag o tasiyas palopit, Yowbad nakaleiwag isekes gamag wasigeis ee... wankuyeim mo isap Yon. ");
INSERT INTO myw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Kukin sivinamiy bukuliganes agulivan towen mo bukukwakins kavel Yon. Towen Ilaytiy va̱gan bikidumwal Mesay inaked, mtowen mounid Yon. ");
INSERT INTO myw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Yakamiy tigamiy sam bweina kuliganes.” ");
INSERT INTO myw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Yeisuw mo ilivan, ilana, “Ama̱wan bakabebay mo bukukwakins amisinap? Adok yakamiy mamagina gamagal iwliwals wavtakon ven, idibakes sisiyas, ilansa, ‘Kawaway kup, tage nag kusilasals; ikous mo kalloupid, tage nag kuva̱lams.’ ");
INSERT INTO myw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","“Peinan Yon isap, nag ikamkwam; na-imoum wayn, mo kulansa, ‘Takabala̱wein towen, peinan baloum iweiy.’ Gimgilitoun yey mo asap, akamkwam, amwamoum, mogo kulansa, ‘Tagovek towen, o tamwamwein wayn towen, ikaveiyons siney takalba̱lebs o tasiyas takaweins ta̱kis.’ Ga bukukines aw-wotet bwein, mo silawun bukukwakins, sinap tonen.” ");
INSERT INTO myw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ven mwasanin nikines Yeisuw nawotet tawtoun, tage nag ipiyaves asisinap kalbaleb, mapun Yeisuw mo ika̱nes, ilana: ");
INSERT INTO myw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","“Kuva̱lams yakamiy Kolesin o yakamiy Beteseid. Magat kweiboug tasiyas Ta̱yil o tasiyas Sidon bikines mulin naman Yowbad ma̱wana gunawotet nukukines nagein, nuwanaw mo bisimounids, bipiyaves kid asisinap kalbaleb, sona koun sewed biva̱lams-wan peinan asisinap kalbaleb, mo bipiyaves. Yakamiy gog nag. Mounid adibakeimiy igaw tutan Yowbad bimop vena babaw asisinap, tasiyas bilivatus sikalbaleb kakit, yakamiy gog avakaein. ");
INSERT INTO myw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","“O yakamiy-vak Kapaneyum bukumwens kid wanakaew; nag gog, bukubus watinow, bukuneis wa̱Tum. Magat kweiboug tasiyas Sodom bikines mulin naman Yowbad, ma̱wana gunawotet nukukines, mo biva̱ges asisinap kweitan, Yowbad nag beiweiys tasiyas, bisesus ee... tut towen bisigagas. Mounid adibakeimiy igaw tutan Yowbad bimop vena babaw asisinap, tasiyas Sodom bilivatus sikalbaleb kakit, yakamiy gog avakaein.” ");
INSERT INTO myw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Tut gog towen Yeisuw initoug, idibek Taman, ilana, “Tamag ya̱koum, liba̱lab natovek o ven watinow natovek ya̱koum. Kalin nuwag yak peinan nukusowm sinap tatonen. Tasiyas tassinaps nag bikakins, tage kukwatimlakes tasiyas mamagina gamagal; mo ikakins tasiyas. Peinan kaleiwag bwein wananoum.” ");
INSERT INTO myw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yeisuw mo ilivan, ilana, “Tamag bo itam youd babaw waseg Natun yey. Tamag anmwa̱net ikakin Natun yey; o yey agumwa̱net akakin mtowen Tamag. Igaw, kalisiy beivag sivinag mo bakatimlakes; e, tasiyas mo bikakins Tamag. ");
INSERT INTO myw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Yakamiy kunamiy moumouvit o miwotet moumouvit, kumeis waseg yey, mikabiyeiwas silma̱nin. ");
INSERT INTO myw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","“Kumeis, kulabeigs kwanag waseg, mo bukukwawes agusinap yagan ma̱num; kululuwamiy mo biba̱nes sikabiyeiwas. ");
INSERT INTO myw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","“Peinan kid kwanag gagab, gunawotet bwein.” ");
INSERT INTO myw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Misumkwey towen Yeisuw siney navamul inoyes kweitan ked wanuwan bag, yam tapwa̱loul waseg; navamul asimoun, ilapes wit anagin, ikams. ");
INSERT INTO myw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tasiyas Palisiy ikines, idibakes Yeisuw, ilansa, “Kukin muvamul, nag igoulus Sa̱bat.” ");
INSERT INTO myw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Yeisuw ilana, “Adok nag kukwakins liva̱nen Deibid, nises Bukitab wanuwan. Peinan asimoun siney nagamag, isiws Yowbad wanbunatum, ikams bled towen nises Yowbad wamatan. Tanuwgwes lun bo ikatibomes bled towen. Na-ikadilok Deibid beikam; nagamag-vak nag beikams; misinaka tasiyas tanuwgwes lun. Tage tanuwagan lun isek Deibid sen nagamag, mo ikams, peinan singaya asimoun. ");
INSERT INTO myw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“O adok nag kuvinis Moses nakaleiwag, peinan Sa̱bat waseg tasiyas tanuwgwes lun iwotets lun, Yowbad wanbunatum, tage nag ivag asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Gunakaleiwag towen kweivaw imug-wan Yowbad nabunatum waseg. ");
INSERT INTO myw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Livan nises Bukitab waseg, ‘Makava lun apiyev; sivinag kid siwa̱youb.’ Magat bukukwakins Yowbad anilivan towen, adok nag bukuygages tasiyas toubweins. ");
INSERT INTO myw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Peinan Gimgilitoun yey, Sa̱bat tanuwagan yey.” ");
INSERT INTO myw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeisuw ilisawes, inoun, isiw sisinagog silma̱nin tapwa̱loul. ");
INSERT INTO myw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sinagog wanuwan teitan nises, naman ipam. Tasiyas sivines biyateles Yeisuw, ikatiga̱nes, ilansa, “Tab kadilok bitavag takatouns beibweins, Sa̱bat waseg?” ");
INSERT INTO myw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Iwa̱ge Yeisuw ilana, “Adok nag teitan yakamiy a̱len sip bikalivatow bein wa̱leg Sa̱bat waseg, bilivan, bilana, ‘Deisa bisiw, peinan Sa̱bat.’ Adok nag. Adok biyous, bikatinob, ne? E, gamag singay imgwayes wasigeis aleimiyas. Mapun bweina bitaleb sod Sabat waseg.” ");
INSERT INTO myw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yeisuw mo idibek taw towen, ilana, “Kusayel namam palawen neipam.” Iyasel mo ibwein, ma̱wana paliyuwein. ");
INSERT INTO myw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Siyas Palisiy bo igeg ninous, isaps, illivans sisiyas, sivines kid biyagages mtowen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Yeisuw ikakin ninous, inoun in. Gamag babaw ibwa̱kuns Yeisuw waseg; takatouns ivag mo ibweins; idibakes, ilana, “Awoum kwamteles youd towen; awoum!” ");
INSERT INTO myw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","18","Mo ikamat Yowbad anilivan palopit towen Isaya nilivnek mamagina: ‘Kukines guntouwat, bo adouw silma̱nin gunawotet. Singay ikalin nuwag mtowen. Basek kululuwag, mo bisek nakaleiwag didumwal, ven babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nag biwkuwak, nag bikamniman, gamag nag biliganes aygan wavtakon ven, nag. ");
INSERT INTO myw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kaytuk isasal, nag biwut bilev, nag. Wodam nakagidaged kalbaleb, nag bisuwmet, nag. Igaw nawotet waseg sinap didumwal mo biton. ");
INSERT INTO myw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E, tobwag ven gimgilis binmises va̱gan mtowen bilabes.’ ");
INSERT INTO myw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wankuyeim itokes teitan gamag, baloum neiweiy, imeyes Yeisuw waseg, ankatoun mamagina ikaw matan, o wadon ikapet; ta-ma̱wan bikapwageg bilivan. Inekes Yeisuw, ivag mo ikilev, bo ibwein gamag towen, ikin, ilivan bwanabwein. ");
INSERT INTO myw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gamag babaw ikines, bo isom ninous, ilansa, “Adok mtowen Deibid tabun, Mesay.” ");
INSERT INTO myw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Siyas gog Palisiy iliganes, mo ivtokes livan, ilansa, “Siyas baloum sitovek Seitan mtowen ileb Yeisuw, mo ikayabes baloum.” ");
INSERT INTO myw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeisuw ikakin ninous, mapuna idibakes, ilana, “Kukin bod avakaein tawtoun nises; tage bod to gimgilis bikavikuns sisiyas; bilivis, bo beigwey bod towen, beikous. O ven o kum ma̱wan, kukin gamag bilivis biva̱ges bod babaw, bo beigwey ven towen o kum towen. ");
INSERT INTO myw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Mapuna kuninuways Seitan inabod, kukin Seitan bilabeig mo bakayeb Seitan natouwat tasiyas baloum, mogo Seitan inabod bilivis, bo beikous nakaleiwag tonen. Tage nag. ");
INSERT INTO myw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“O kuvtokeigs livan, kulansa, ‘Seitan ileb mo ikayabes baloum,’ o kal ilabes mivamul mo ikayabes baloum? Kuninuways asisinap tasiyas mo bukukwakins bo ibol amilivan. ");
INSERT INTO myw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Kukin gog Yowbad Kululuwan bilabeig mo bakayeb baloum, mapuna Yowbad nakaleiwag bo isap wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kweitan sinap kuninuways: Ta-ma̱wan bitasiw tawtoun gamag wanabunatum mo bitaven navavag. Deisa bitayous taw towen, tayawen naman, kaken, va̱gan nag binoun, mo bitaven navavag, tayakousis. ");
INSERT INTO myw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kukin kal nag bilabeig gunawotet waseg, gamag towen isilbwed gunawotet. O kalisiy nag bikatikunakus wagunseigous, tasiyas gog bikatigayes. ");
INSERT INTO myw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Mapun adibakeimiy, amisinap kalbaleb o amilivan kalbaleb Yowbad biwid babaw beikous; tage kweitan sinap nag. Magat bukuyeg Yowbad Kululuwan, nag biwid sinap towen, nag. ");
INSERT INTO myw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Kukin bukutawyageig Gimgilitoun yey, Yowbad biwid amsinap towen; tage bukutawyeg Yowbad Kululuwan Bwanabwein, Yowbad nag biwid, tut towen nag, o tut wanakougwaw nag. ");
INSERT INTO myw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Magat kay bwein, anagin bwein. Magat kay kalbaleb, anagin kalbaleb. Takin anagin mo takakin kay ama̱wan, bwein o kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Yakamiy takalbalebs magina mwatet yakamiy, ta-ma̱wan bukulivans bwein, peinan ninoumiy kalbaleba singay; mapun amilivan kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Tasiyas toubweins asisinap bwein, mapuna siwotet bwein; tage tasiyas takalbalebs asisinap kalbaleb, mapuna siwotet kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Kukin bukulivans mav, Yowbad mo biyateleimiy, igaw tutan bikatukin sinap babaw gamag wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Magat amilivan bwein bo bukunounas bwein, o kukin gog amilivan kalbaleb mo bukulivatus kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wankuyeim takatimlakeins kaleiwag mwasanin sisiy tasiyas Palisiy mwasanin idibakes Yeisuw, ilansa, “Tamwey, sivinem namam mulin bakakin, mo bakasimounid waseg yak.” ");
INSERT INTO myw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Yeisuw ikatimop, ilana, “Kalbaleb gamag, tapiyaveins Yowbad yakamiy, sivinamiy bukukwakins namag mulin. Nag kweitan sinap bukukwakins; misinaka sinap towen, peinan palopit towen kweiboug Youna nises uloulas wanuwan, yam kweitoun o boug kweitoun, ma̱wan yey Gimgilitoun yey bo basesun pwepway wanuwan, yam kweitoun o boug kweitoun. ");
INSERT INTO myw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Min-Ninavek igaw mo bitamanaws ya̱tal waseg, bilivans va̱gan bukukwakins amisinap kalbaleb, gudwouvaws yakamiy. Peinan tasiyas iliganes Youna nageiguy mo ilaves asisinap kalbaleb; tage kaleiwag nagein nukuliganes ikalsow Youna nageiguy. Kuliganes; nag gog, nag kulaves amisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Igaw tutan Yowbad biya̱tal wasigeis gamag babaw, mo kwin mana̱wen kweiboug inaven wa̱yals mo bilivan va̱gan bukukwakins amisinap kalbaleb, gudwouvaws yakamiy. Peinan mana̱wen kwin inoun in singay kadiveiyov va̱gan biligen Solomon ansinap; tage sinap towen nagein nukuliganes ikalsow Solomon ansinap waseg. ");
INSERT INTO myw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","“Magat yeiluw bikilev gamag, mo bita̱vin ven babaw, binineiv nakabiyeiwas. Binineiv nag, bilivan bilana, ‘Ba̱yum ban wagunbunatum to nalisow.’ “Beiyum biban nabunatum makaw, bo itaneivis, youd babaw bo ilivkases bwein; bikalin nuwan, bein ikin siney teinim teiy asisinap singaya kalbaleb, tasiyas asibabaw mo beisiws wabunatum, bisesus bisigagas. Kweiboug gamag towen nakalbaleb peinan yeiluw neisiw, tage nakabiyokous waseg singaya kalbaleb. Gudwouvaws yakamiy mikalbaleb bukulivatus ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisuw igawa ilivan gamag wasigeis, inan budan itamanaws watoulan gamag babaw, sivines binekes, bilivans sisiy Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Teitan ilana, “Inamwa budam nitatos watoulan.” ");
INSERT INTO myw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Yeisuw idibek taw towen, ilana, “Kuninuways kalisiy inag budag,” mo ikatimlek navamul tasiyas nitatos wadadan, ilana, “Mtasiyas-one inag o budag. ");
INSERT INTO myw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Kal yak bukukow nanon Tamag walba̱lab, mounid ya̱koum bwadag o nagut o inag.” ");
INSERT INTO myw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yam towen Yeisuw ilisow nabunatum, iwloubus in wakawalaw, isin. ");
INSERT INTO myw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gamag singay babaw inekes, mapuna itouw wa̱wag, isin. Babaw gamag itamanaws itowas wakawalaw. Yeisuw itouvin, ikines gamag babaw, mo ilivan. ");
INSERT INTO myw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tage ansinap babaw-wan livan kabebay waseg isekes gamag tasiyas, ilana, “Teitan taw in wa̱bag ilivelov veitun. ");
INSERT INTO myw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Mwasanin ikalka̱louw ininein wa̱ked, man imeis ikamkwams veitun towen wa̱ked. ");
INSERT INTO myw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","“Mwasanin ininein wadikuda̱kul, pwepway nag mana̱nan; nuwanaw isob peinan pwapwayein kakit-wan, tage ivag ka̱las mo iyag, peinan gidwa̱lin nag beisoul mana̱nan. ");
INSERT INTO myw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Mwasanin sisiyas awuyow veitun in wapwepway. Awuyow isobs, ivkuva̱kaein, mapuna kan igwey. ");
INSERT INTO myw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Mwasanin gog ininein pwepway bwanabwein waseg, isob, ivag anagin bwein, mwasanin lakatutan, mwasanin sinawanim, mwasanin sinawatoun. ");
INSERT INTO myw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Yakamiy tigamiy sam bweina kuliganes.” ");
INSERT INTO myw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wankuyeim gog Yeisuw navamul inekes, ilansa, “Aveiyag silawun mukwabebay wasigeis tasiyas?” ");
INSERT INTO myw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeisuw ikatimop ages, ilana, “Yowbad itam, sinapun liba̱lab kaleiwag-nen isekeimiy; tasiyas gog nag. ");
INSERT INTO myw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Kalisiy yakamiy amisinap nises, igaw amisinap bikatimweis, bivakaein; tasiyas gog nag, bo bikow asisinap tasiyas, makava bisesus. ");
INSERT INTO myw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Mapuna akabebay wasigeis tasiyas, mo bikines tage nag biwtusis, o bikatiliganes tage nag biliganes bunik va̱gan bikakins, nag. ");
INSERT INTO myw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Kweiboug palopit Isaya anilivan bo ikons tasiyas; anilivan ma̱wan: ‘Bukuliganes tage nag bukukwakins. E, bukukines tage nag bukuwtusis. ");
INSERT INTO myw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Peinan ninous gamag tasiyas bo imouvit; bo ituy tiges; bo ikaw mites; mata ge mites waseg beikins, o tiges waseg beinegs, bikakins, mo bikanavin ninous, bava̱ges kid beibweins tasiyas. Nag gog.’ ");
INSERT INTO myw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Yakamiy bwein, mitamiy ikin, tigamiy ineg. ");
INSERT INTO myw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","“Mounid adibakeimiy kweiboug palopit babaw sisiyas tasiyas tadidumwals sivines bikines sinap towen nagein nukukines, o biliganes kaleiwag towen nagein nukuliganes; sivines kid, tage nag. ");
INSERT INTO myw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kadiloka kuliganes silawun kabebay towen talavein veitun. ");
INSERT INTO myw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Veitun tasiyas ininein wa̱ked mamagina gamag tasiyas iliganes Yowbad nakaleiwag, tage nag bikakins, towen takalbaleb mo bisap, bikow livan towen nises waninous, binow. ");
INSERT INTO myw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Veitun wadikuda̱kul mamagina gamag tasiyas iliganes livan towen, isimounids, imwa̱saws waseg, ee... bimwemway nen, gidiwlis nag beisoul mana̱nan, gamag mwasanin biyages liva̱nen Yowbad, biyagages tasiyas takaweins Yowbad anilivan, mo bikalka̱louws gamag tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Veitun tasiyas sisiyas awuyow, mamagina gamag tasiyas iliganes liva̱nen Yowbad, mo inuwes youd babaw ven watinow, sivines kid biguyaws, mo ilisawes ked bwanabwein, mapuna Yowbad nakaleiwag igwey wasigeis tasiyas, nag ivag angis. ");
INSERT INTO myw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Tage veitun tasiyas pwepway bwanabwein waseg, mamagina gamag tasiyas iliganes livan, ikakins mo ivag angis, teitan lakatutan, teitan sinawanim, teitan sinawatoun.” ");
INSERT INTO myw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Vayuwein Yeisuw ikabebay, idibakes, ilana, “Bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana gamag isop veitun bwanabwein wanabag. ");
INSERT INTO myw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","“Wankuyeim boug waseg, gamag babaw bo immasis, teitan nikamliw tagnibag im wanabag isop awuyow magin ma̱wana kan, tobwag gog. Mo iyum in. ");
INSERT INTO myw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Igaw tut wankuyeim iwuw anagin mo iba̱nes awuyow tobwag waseg. ");
INSERT INTO myw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Nagamag inekes tagnibag, ilansa, ‘Tamwey, adok muveitun bwein nitasapwes, avanuy meinoy neim awuyow towen kalbaleb?’ ");
INSERT INTO myw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Tamwey ilana, ‘Adok towen nikamliweids!’ Nagamag ilansa, ‘Tabta bakan kagut awuyow siyas?’ ");
INSERT INTO myw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","“Ilana, ‘Nag. Adok bukugutes mwasanin kan sona bukugutes sisiyas awuyow. Babaw bisesus, bimatuw kan, mo badibek tasiyas tatayaweins kan, balana: Wanmugwana awuyow kugutes kwatikunakus, kusinaves, kukwawes, kunawes, kugabus; ikous; mo kan kuta̱yoys, kwatikunakus kunawes wagunseigous.’” ");
INSERT INTO myw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Kwatounun kabebay isekes, ilana, “Bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana veitun kay yagan tipol, gamag isop wanabag, veitun gog singay kekel, tage isob kay kaywen, mo ivakaein, man iyoyows imeis iwlules sibunatum wayayagein, kay-nen avakaein.” ");
INSERT INTO myw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kwavasin kabebay isekes, ilana, “Bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana yist, na̱tan vin ikow yist kakit, isen wanuwan pwalaw kwavitoun, tamkwa̱lan mo ilol.” ");
INSERT INTO myw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Sinap tasiyas babaw Yeisuw isekes nakabebay waseg; nag kweitan livan kamnat isekes gamag babaw, nag. Tut towen waseg bo ikamat palopit anilivan towen nilivnek mamagina: ‘Gunakabebay balivan; magina baka̱mat sinap misikena kweiboug nikawum.’ ");
INSERT INTO myw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Anilivan ikous, ilisawes gamag babaw, inoun in wabunatum. Navamul mo inekes Yeisuw, ilansa, “Kwamtilakem silawun kabebay awuyow wa̱bag.” ");
INSERT INTO myw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeisuw mo ilik, ilana, “Talavein veitun bwanabwein yey, Gimgilitoun yey. ");
INSERT INTO myw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Abeibag ven towen watinow; veitun bwanabwein, tasiyas itams Yowbad nakaleiwag waseg; awuyow veitun towen takalbaleb inagamag. ");
INSERT INTO myw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","“Mtowen takammeiliw nisop awuyow, mtowen Seitan; tutan ta̱yoy, nakabiyokous tut; tatayaweins kan tasiyas Yowbad nataka̱yob. ");
INSERT INTO myw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","“Nakabiyokous tut mamagina bikatikunakus awuyow bigabus, peinan Gimgilitoun yey bakayeb min-liba̱lab, gunakabkaleiwag waseg bikatikunakus tasiyas takalbalebs sisiyas tapiyaveins sinap bwein, bilaves bineis kov avakaein waseg, mapuna tasiyas bivva̱lams-wan, peinan abes singay kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Tut towen wanakougwaw tasiyas tadidumwals bikamnats ma̱wana ka̱las, wanuwan Tamads nakabkaleiwag. Yakamiy tigamiy sam bweina kuliganes.” ");
INSERT INTO myw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yeisuw mo ilana, “Bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana money singay babaw teitan gog gamag bisown wanabag, bises ee... mo bikanig. Igaw gog kweitan gamag mo biban money towen, bisowm vayuwein, biyamiyis navavag babaw, maysan bikow, bigimwel pwepway towen, singay bikalin nuwan peinan namoney singay babaw pwepway towen waseg. ");
INSERT INTO myw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Vayuwein bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana takunakun teitan inineiv kun bwanabwein, iban kun kuvakaein imgwayes kuna babaw; inakun babaw mo ilev silma̱nin kun to kweivaw, peinan singay bwanabwein. ");
INSERT INTO myw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","“Sivtounun bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana wot ilaves wa̱yol, ikwanes in kweitan magin kweitan magin. Bo ika̱lawt wot; ibiteilis, in wanakaew, mo bikatukins, in bwana̱bweins bidagis bein wanuwan abmavin, siyas gog kalba̱lebs, yegay, ikawes, ilaves. ");
INSERT INTO myw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","“Tut nakabiyokous waseg bo ma̱wan, bakayeb min-liba̱lab bikawes takalba̱lebs bilaves bineis kov avakaein waseg, toubweins gog bisesus. Tasiyas takalba̱lebs mo biva̱lams avakaein, peinan singaya abes bigeg.” ");
INSERT INTO myw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeisuw mo ikatiga̱nes, ilana, “Tab kukwakins sinap siyas babaw?” Itams, ilansa, “Oo!” ");
INSERT INTO myw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ilana, “Tasiyas gog takatimlakeins kaleiwag mwana nikakins Yowbad nakaleiwag sinapun, tasiyas gog asisinap kweivaw bwanabwein, kweiboug bwanabwein; ma̱wana tanuwagan bunatum nawliyoug babaw bwanabwein, kweiboug o kweivaw.” ");
INSERT INTO myw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Yeisuw nakabebay iyakous, inoun in wanven, isiw wanuwan sinagog silma̱nin tapwa̱loul, ikatimlakay. Isimasom ninous tasiyas, ilansa, “Ampalawen meinoy neim ansinap singay avakaein o nawotet singay tawtoun?” ");
INSERT INTO myw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Adok tawtelein amweilok natun towen; inan Meliy nises; budan nisesus, tasiyas Yemes, Yosep, Saymon, Yudas; o nunet asibabaw nisesus. Ansinap avanuy meinoy neim?” ");
INSERT INTO myw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bo igeg ninous, magina ipiyaves kid Yeisuw. Yeisuw gog mo ikatimop asilivan, ilana, “Vena babaw ivna̱ses palopits, tage wasiven tatineis bo nag; wasibunatum tatineis bo nag.” ");
INSERT INTO myw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yeisuw nawotet tawtoun na-ibabaw wanven tatonen, peinan taginvens nag isimounids waseg. ");
INSERT INTO myw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Misiya̱mun towen gabman yagan Elod iligen butun Yeisuw, mapuna idibakes natouwats, ilana, “Mtowen tabibapta̱ysein gamags yagan Yon, kweiboug abob kayon, imat, adok bo ikit vayuwein, mapun nawotet tut towen singay tawtoun.” ");
INSERT INTO myw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","E, kweiboug Elod niyous Yon, iyawen naman, isen wa̱deil, peinan Elod nikwey bwadan Pilip nakwav Elodiyas, Yon nilivan, “Awoum kukwey bwadam nakwav.” Elod sivinan beiweiy mtowen Yon, mapuna iyous, isen wa̱deil, anpwa̱yat gog beiweiy Yon, peinan gamag babaw sivines Yon, idokes palopit teitan. ");
INSERT INTO myw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Wankuyeim isagal, peinan tutan inan nikop-yay, mtowen Elod ikamkwams siney nagamags. Elodiyas natun kuda̱vin isal wamtes tawaw tasiyas, Elod ikalin nuwan, idibek, ilana, “Aveiyag sivinam bo basekeim, tabudabod tamag.” ");
INSERT INTO myw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na̱wen in ikatugwan inan waseg, ilana, “Inag, aveiyag banitoug?” Inan ilana, “Kunitoug busbwesan Yon bisekeim.” Inek Elod, ilana, “Kusekeig busbwesan tabibapta̱ysein gamags, towen Yon. Bibwabwes kayon, busbwesan bisenas wanuwan abmavin, mo kusekeig.” ");
INSERT INTO myw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King towen mo igeg nanon, tage peinan gamag babaw niliganes nitabudabod anilivan, mo itam. ");
INSERT INTO myw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Itam, ikayeb teitan in wa̱deil, ibob kayon Yon, busbwesan isen wakabmavin, imey, isek guwa̱vin, ikow inow, isek inan. ");
INSERT INTO myw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yon navamul iliganes, ineis, ikawes won Yon, inawes idibwanis. Ikous, inekes Yeisuw, ikamteles sinap towen. ");
INSERT INTO myw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeisuw iligen sinap towen, ilisawes gamag babaw, itouw wa̱wag, ikala̱vis ineis ven makaw waseg. Gamag babaw iliganes liva̱nen bo itouw, ilisawes siven kweitan, inoys gog wa̱ked, ikikuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeisuw ilug, ikin gamag singay babaw, ikalin nuwan, takatouns ivag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iwwotet ee... kwayav; navamul inekes, ilansa, “Bo ikwayav, kwayabes gamag babaw bineis waven mwasanin biyamiyises kaeis, peinan nawoud towen nag kweitan ven nises.” ");
INSERT INTO myw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeisuw gog ikayuses, ilana, “Awoum bineis. Kusekes kaeis beikams.” ");
INSERT INTO myw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ilansa, “Kan nag. Misinaka bled kweinim, in mwanay.” ");
INSERT INTO myw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","20","Ilana, “Kumeyes bakin; gamag babaw bisinis awuyow wakunuwatan, beikams.” Ikow bled son in wanaman, ikin wanakaew, ikalin nuwan waseg Yowbad, mo initoug. Ikous mo ikikiv bled issekes navamul, ikawes ivakamus gamag babaw, ikams, ikamuweips. Kan nikambwages isiyavis, idagis in wanuwan kaynad; bo ika̱lawt kaynad sinawatan kadiney. ");
INSERT INTO myw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gamag siyas neikams kweinim tawsan tawaw, sisiyas vinay gamagal babaw. ");
INSERT INTO myw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ikous, mo idibakes navamul, ilana, “Kutouws kumugwas, kusupels kuneis palatan; yey gog bases bakayabes gamag.” ");
INSERT INTO myw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ikayabes ikous, ikatulag in wa̱koy, anmwa̱net binitoug Yowbad waseg. Bo iboug anmwa̱neta ises. ");
INSERT INTO myw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tasiyas gog wa̱wag kadiveiyov-o wabwanit ikalla̱vis, bo ikala̱lav nimes, peinan yag meinoy neim wamtes. ");
INSERT INTO myw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kakita beiyam, Yeisuw mo inoun wakunuwatan yevagam, bo binekes. ");
INSERT INTO myw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Navamul ikines Yeisuw ininoun wakunuwatan yevagam, idokes yeiluw kid, iwkuwaksa aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yeisuw ilana, “Bwein-wan! Awoum beivag amipwa̱yat. Yey nases.” ");
INSERT INTO myw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iw to Pita, ilana, “Guyaw, magat mounid ya̱koum, kudibakeig baw, mo banoun wakunuwatan yevagam, bawekeim.” ");
INSERT INTO myw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeisuw ilana, “Kum.” Pita mo ilisow wag, inoun wakunuwatan yevagam binek kid Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Igaw ininoun, ikin yag itotow, anpwa̱yat, kaken bo isoun, kakita bo bimukul. Iwak, ilana, “Guyaw kwatinabweig!” ");
INSERT INTO myw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeisuw iyasel naman, iyous, ilana, “Adok nag kusimounid waseg yey. Aveiyag wawun ivag nanoum akweiy?” ");
INSERT INTO myw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iyums asteiy inekes tasiyas wa̱wag, itouws, yag mo iyenom. ");
INSERT INTO myw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tasiyas wag aniwnataw mo ikululs wamatan Yeisuw, ilansa, “Mounid Yowbad Natun yak.” ");
INSERT INTO myw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Isupels, ilugs ven yagan Genesalet. ");
INSERT INTO myw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","36","Min-Genesalet iwtusis Yeisuw, ikayabes sisiyas, ineis vena babaw, idibakes takatouns, ilansa, “Kwatuyouns kunekes Yeisuw.” Inekes, initougs waseg, sivines kid misinaka bikabkwanes matan anakweim. Itam, ikabkwanes, mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Tasiyas Palisiy mwasanin sisiyas takatimlakeins kaleiwag mwasanin mo ilisawes Yelusalem, imekes Yeisuw, ilansa, “Aveiyag wawun muvamul isiplaves tammwayas sikaleiwag, peinan beikams kan tage nag iwidis nimes?” ");
INSERT INTO myw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ikatimop asilivan, ilana, “Yakamiy-vak, aveiyag wawun kunuwes amikikun, mo kusiplaves Yowbad nakaleiwag? ");
INSERT INTO myw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Yowbad nakaleiwag mamagina: ‘Kuvna̱ses tamam inam’, o ‘Kukin kal biyeg taman o inan tonen, mo kuweiys gamag towen.’ ");
INSERT INTO myw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Tage yakamiy amisinap, kulansa; ‘Aveiyag bukusekes tamam inam, bweina bukwatibom silma̱nin Yowbad, mo bukwamgwa̱yes tasiyas.’ ");
INSERT INTO myw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Amisinap towen waseg kugidamis Yowbad nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Tayyaweids yakamiy! Mounid palopit towen Isaya nilivnek liva̱nen yakamiy, peinan ilel Yowbad anilivan mamagina: ");
INSERT INTO myw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Gamag siyas wudous waseg ivna̱seigs, tage ninous waseg isina̱leigs. Makava itapwa̱louls waseg yey, peinan gamag mwasanin asisinap ikatimlakays, tage agusinap yey bo ipiyaves.’” ");
INSERT INTO myw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","Mapuna Yeisuw idawes gamag babaw bimeis. Imekes Yeisuw, ilana, “Kuliganes mo bukukwakins. Aveiyag beisiw awn waseg nag biyageg gamag kululuwan, nag. Misinaka sinap towen bisap wawadon mo biyageg gamag.” ");
INSERT INTO myw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tut wankuyeim navamul inekes Yeisuw, idibakes, ilansa, “Tabta kukwakin siyas Palisiy asimwasin amlivan to nukulivan?” ");
INSERT INTO myw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Yeisuw ikabebay, ilana, “Tamag walba̱lab nisop kay bwanabwein; tage kay tobwag nitatos. Tamag mo bigut kay siyas, bilev. Towen nakaleiwag, yakamiy nag. Tasiyas mamagina toukwaws imgwayes sisiyas toukwaws, bitokes sisiyas binawes, babaw mo bikalka̱louws bineis wa̱leg.” ");
INSERT INTO myw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ilana, “Kulik kabebay towen va̱gan silawun bakakakin.” ");
INSERT INTO myw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","18","Yeisuw ilana, “Adok yakamiy-vak igaw tatagouwaws yakamiy. Tabta kukwakins avei-kan beikoum gamag, kan towen bein watoubun, bininoun ee... igaw simwan mo bisap bein wamnat? Tage aw-sinap gamag binuway wananon, igaw mo bilivan, anilivan towen bisap wawadon mo biyageg gamag kululuwan. ");
INSERT INTO myw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","20","“Gamag nanon waseg sinap kalbaleb, katumat gamag, subwan, kaylas, veinaw, yaweid, yagay. Sinap siyas gamag wananon bisap mo biyageg gamag towen. Tage nag biwid naman mo beikam, sinap towen nag biyageg gamag, nag.” ");
INSERT INTO myw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeisuw ilisow ven towen, inoun in walasin ven Ta̱yil o Sidon. ");
INSERT INTO myw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na̱tan vin nag vinen-Yudiy, tage vinen-Kenan, isap, iwak, ilana, “O Guyaw, Deibid tabun yak, kusiwyoubug, peinan natug kuda̱vin yeiluw singay iyageg.” ");
INSERT INTO myw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeisuw gog ika̱pay, nag ikatimop anilivan, nag. Navamul mo iwekes, ilansa, “Kwayeb na̱wen iwkuwak, bo iwegweis wom.” ");
INSERT INTO myw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeisuw ikatimop ages, ilana, “Yowbad nikayabeig nam silma̱nin nagamag min-Yisleil, peinan mamagina sip tasiyas, ilassulis ked.” ");
INSERT INTO myw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mana̱wen vin im, ikulul wamatan, ilana, “O Guyaw, kulabeig.” ");
INSERT INTO myw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeisuw ikabebay, ilana, “Awoum bakow gamagal kaeis, basekes awuk beikams, awoum.” ");
INSERT INTO myw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iw mana̱wen vin, ilana, “E, mounid. Tage gamagal beikams, musamusan kan bikalka̱louw bininein waskawan teibol, bweina beikams mansiyas awuk puskekel, waskawan teibol nisesus.” ");
INSERT INTO myw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeisuw ikatimop aygan, ilana, “Vin yak, singay kunmiseig va̱gan balabeim. Mukwanitoug waseg yey avanin mo bikamat waseg yak.” Mapuna natun ibwein tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeisuw inoun, in, ivvayal yevagam avakaein yagan Galiliy, mo ikatulag in wa̱koy, isin. ");
INSERT INTO myw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Singay babaw gamag inekes sisiyas takatouns babaw, takagayals, toukwaws, tasiyas ipam kikeis o nimes, o takakons. Takatounsa babaw inawes isewas wamatan Yeisuw, ivag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gamag babaw ikines tasiyas takakons, ivag mo ilivans bwein; tasiyas ipam kikeis o nimes ivag mo idamoms; takagayals ivag mo inounas; toukwaws ivag mo ikins bwein; isom ninous, iya̱kawns waseg min-Yisleil siYowbad. ");
INSERT INTO myw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wankuyeim Yeisuw idawes navamul, inekes, ilana, “Inok nuwag gamag babaw asimoun, kweitoun yam sigwey tasiyas nitasesus, kaeis nag beikams. Adok awoum bakayabes sona asimoun, bo bisiwsawoul wous wa̱ked.” ");
INSERT INTO myw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iweis navamul ilansa, “Ven towen makava nawoud, avanuy bakaban kaeis tasiyas babaw gamag beikams?” ");
INSERT INTO myw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeisuw ikatiga̱nes, “Kweivin amibled?” Ilansa, “Kweinim kweiy son in mwanay kekel-e.” ");
INSERT INTO myw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Idibakes gamag babaw, ilana, “Kusinis.” Isinis, ikow bled towen son in, initoug, ikalin nuwan Yowbad waseg, ikikiv, issekes navamul; navamul mo ikawes ivvageins gamag babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asibabaw ikams ikamuweips. Kan towen nikambwages isiyavis, gamwat kweinim kweiy bo ika̱lawt. ");
INSERT INTO myw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Asibabaw tasiyas ikamkwams ikamuweips kweivas tawsan tawaw sisiyas vinay gamagal babaw. ");
INSERT INTO myw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ikous, ikayabes gamag babaw, mo itouw wa̱wag, ikala̱vis ineis ven avakaein yagan Magadan. ");
INSERT INTO myw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wankuyeim siyas Palisiy sisiyas tasiyas Sadusiy inekes Yeisuw iyakwanes, ilansa, “Kwamtilakem mulin naman Yowbad, bakakin.” ");
INSERT INTO myw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ikatimop asilivan, ilana, “Kwayav waseg kulansa, ‘Liba̱lab ikayibwel, ka̱las bo beikal,’ o ga̱boug waseg kulansa, ‘Bwaw beim peinan lov magin ma̱wana musewun kov.’ Yowbad naman mulin tasiyas kuwtusis; tage tut towen waseg Yowbad naman mulin nag kuwtusis. ");
INSERT INTO myw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Kalbaleb gamag tapiyaveins Yowbad yakamiy, sivinamiy bukukines mulin naman Yowbad. Nag gog; misinaka sinapun Youna bukukines. Nag kweitan mulin naman Yowbad bukukines.” Ilivan ikous, ilisawes, mo inoun. ");
INSERT INTO myw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ikala̱vis, ita̱lags palatan, navamul bo inumlaves asibled. ");
INSERT INTO myw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeisuw idibakes, ilana, “Kumtakavateimiy. Kadiloka kupiyaves tasiyas Palisiy asiyist, o tasiyas Sadusiy asiyist.” ");
INSERT INTO myw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Illivans sisiyas wasigeis, idokes Yeisuw anilivan towen peinan bo inumlaves asibled. ");
INSERT INTO myw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","11","Yeisuw go ikakina ninous, ilana, “Adok nag kunmiseigs va̱gan kan basekeimiy bukukwams. Mata kudokes silawun agulivan bled tatonen peinan kunumlaves, nag. Adok nag kunuwes kweinim tawsan tawaw neikams bled kweinim waseg mo kusiyavis kaynad babaw, o nag kunuwes kweivas tawsan tawaw neikams bled kweinim kweiy mo kusiyavis gamwat babaw. Silawun agulivan nag bled tonen. Aveiyag wawun nag kukwakins? Vayuwein badibakeimiy, ‘Kadiloka kupiyaves tasiyas Palisiy asiyist, o tasiyas Sadusiy asiyist.’” ");
INSERT INTO myw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mo ikakins anilivan nag liva̱nen yist tatonen, silawun gog tasiyas Palisiy o Sadusiy sikatimlakay, kadiloka bipiyaves. ");
INSERT INTO myw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeisuw inoun in walasin ven yagan Sisa̱liy Pilipay, ikatiga̱nes navamul, ilana, “Gimgilitoun yey, gamag mwasanin idokes kavel yey?” ");
INSERT INTO myw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iweis tasiyas, ilansa, “Mwasanin idokes ya̱koum tabibapta̱ysein gamags Yon ya̱koum, mwasanin gog idokes ya̱koum kid Ilaytiy ya̱koum, mwasanin idokes ya̱koum Yelemay o teitan palopit kweiboug nukuyum nukum kid.” ");
INSERT INTO myw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ilana, “Tage yakamiy, kudokeigs kavel yey?” ");
INSERT INTO myw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saymon Pita ikatimop, ilana, “Ya̱koum Mesay ya̱koum, Tamwamov Yowbad Natun ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeisuw ilana, “Tammwa̱saw ya̱koum Saymon, Youna natun ya̱koum; bo nukuwtusig, nag ven watinow gimgilis ikatimlakeims, nag; tage Tamag walba̱lab nikatimlakeim. O yey mo balivan badibakeim: ");
INSERT INTO myw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“‘Ya̱koum Pita, wawun yagam “Dakul” o dakul towen wakunuwatan mo bawlul agugwamag mamagina gunbunatum yakamiy, o kanig nag bitawtoun wasigeis yakamiy tayakelesiys.’ ");
INSERT INTO myw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Yowbad nakaleiwag anakiy mo basekeim yak. Aveiyag kuyawen ven watinow, Yowbad mo biyawen walba̱lab, o aveiyag bukulik ven watinow Yowbad mo bilik walba̱lab.” ");
INSERT INTO myw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ikous anilivan towen, idibakes navamul, ilana, “Awoum kukwa̱mats sinap towen. Awoum teitan gamag bikakin yey Kelis Mesay, yey. Awoum.” ");
INSERT INTO myw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tut towen Yeisuw isilamaw anilivan kweitan, va̱gan navamul bikakins, ilana, “Kadiloka ban Yelusalem, biyagageigs singay tammwayas sisiyas tanuwgwes lun situwa̱vek o takatimlakeins kaleiwag; ikous mo beiweigs, bakanatoun mo ba̱kit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita iligen livan towen, itok Yeisuw, ineis palatan, ilana, “Ya̱koum Guyaw, awoum kulivan ma̱wan. Awoum biyagageims ma̱wan sinap towen nukulivan.” ");
INSERT INTO myw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iw to Yeisuw, idibek Pita, ilana, “Kusineikik ya̱koum Seitan. Awoum kusilbwadeig. Amsinap towen meinoy neim gamag sikanuway waseg; Yowbad ansinap kweitan.” ");
INSERT INTO myw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeisuw mo idibek navamul, ilana, “Kal yak bukubkunig, kadiloka bukupiyev nanoum tatoneim, bukukow amklos va̱gan bukukwanig kid, ma̱wan magin yey bo bakanig. E, makadewen ked waseg bukubkunig yey. ");
INSERT INTO myw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Kukin bukwayus mwamovam, bo biyamkwaneim. Kukin gog biyamkwen mwamovam peinag yey, igaw mo bukuban. ");
INSERT INTO myw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Youd babaw bitayous ven watinow, tage mwamovads bigeg, bo bigak! Peinan ta-ma̱wan gamag bivkek bisen mwamovan sivyuwein. ");
INSERT INTO myw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Igaw Gimgilitoun yey mo bakam sigwey guntaka̱yobs, o Tamag inakamnat waseg, mo maysan miwotet basekeimiy katanok katanok yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Mounid adibakeimiy mwasanin yakamiya-nan nag bukulivatus kanig ee... mo bukukineigs Gimgilitoun yey igaw bam, gunakaleiwag mo bisilamaw ven watinow.” ");
INSERT INTO myw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yam kweinim katanok ikous, Yeisuw itokes Pita siney asteiy, tasiyas Yemes son bwadan Yon; ikatulags ineis wakunuwatan koy avakaein; asteivas isiwas. ");
INSERT INTO myw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wamtes ivag ankakin kweitan, magin ikamnat ma̱wana ka̱las mititeilin, anakweim ilapupwa̱kaw singay gimagim. ");
INSERT INTO myw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mo ikines Moses son Ilaytiy illivans sisiy Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iw to Pita, idibek Yeisuw, ilana, “Guyaw, singay bwein tasesus towen. Magat sivinam mo bawlul mibwan bunatoun, bunatan yak, bunatan Moses, bunatan Ilaytiy.” ");
INSERT INTO myw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Igaw ilivan, lov kweitan singay kamnat mo imteilis, aygan teitan wanuwan lov ilana, “Mtowen Natug bwanabwein, singay ibwein nanoug waseg; kuliganes aygan.” ");
INSERT INTO myw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Navamul iliganes livan towen, ikalouws kantukovs, singay aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeisuw gog im ikabkwen wous, ilana, “Kutamanaws. Awoum beivag amipwa̱yat.” ");
INSERT INTO myw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Itamanaws, ikinewas, nag ivag gamag, misinaka Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Igawa iwwloubus, Yeisuw mo idibakes, ilana, “Awoum kwamteles sinap towen nukukines. Kwawumes. Igaw Gimgilitoun yey bakanig, ba̱kit vayuwein, mo kwamteles.” ");
INSERT INTO myw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Navamul ikatiga̱nes, ilansa, “Aveiyag wawun takatimlakeins kaleiwag ilivans, ‘Ilaytiy wanamug beim, Mesay wankuyeim’?” ");
INSERT INTO myw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Iw to Yeisuw, ilana, “Mounid livan towen ‘Ilaytiy beim mo bikatilow youd babaw’; tage bo neim. Tasiyas gog nag iwtusis; tage sivines beiweiys-wan, mo iyagages. Igaw mo biyagageigs yey, Gimgilitoun yey, bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Navamul mo idumwal ninous, peinan ikakins-wan tabibapta̱ysein gamags towen Yon mamagina Ilaytiy. ");
INSERT INTO myw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Ikous, inounas, inekes gamag babaw, teitan taw im, ikulul wamatan Yeisuw, ilana, “Guyaw, binok nuwam natug, peinan ikabala̱wein, ankatoun avakaein. Tut babaw ikalka̱louw ininein wa̱kov, tut babaw ikalka̱louw ininein wayvagam. ");
INSERT INTO myw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","“Awey natug muvamul wasigeis; iyokons bo nag.” ");
INSERT INTO myw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeisuw idibakes tasiyas, ilana, “Takakons yakamiy, minamis nag. Bo akawgwes amisinap kakon. Kumey gwad towen.” ");
INSERT INTO myw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeisuw idibek yeiluw towen neiweiy gwad, mo ikilev. Gwad towen mo ibwein, tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Navamul mo inekes Yeisuw anmwa̱net nises, ikatugwans, “na-ikadilokem bakakayeb yeiluw towen?” ");
INSERT INTO myw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Iw to Yeisuw, ilana, “Peinan nag kunmises Yowbad va̱gan bivag. Mounid adibakeimiy, magat minamis mamagina tipol veitun, igaw bukudibek koy towen kulana, ‘Kunoun kun kutoun palatan,’ mo binoun; e, sinap babaw mo bikadilokeimiy.” ");
INSERT INTO myw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Igaw nisesus Galiliy, Yeisuw idibakes, “Teitan bisilkodeig yey, Gimgilitoun yey; gamag mwasanin mo biyousigs, bikatimateigs, yam kweitoun mo ba̱kit vayuwein.” Iliganes, singay ikalin nuwes. ");
INSERT INTO myw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Inounas ineis Kapaneyum. Iweis tasiyas takaweins ta̱kis (ta̱kis towen silma̱nin Yowbad nabunatum), ikatugans Pita waseg, ilansa, “Tabta mutovek itam nata̱kis issekem, o nag?” ");
INSERT INTO myw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita itam, ilana, “Oo!” Pita iyum in wasibunatum. Iw to Yeisuw, ilana, “Saymon, wananoum yak, takaleiwags ven watinow nitsiyas bipa̱yins wasigeis timsiyas? o tobwag gamag bipa̱yins adok?” ");
INSERT INTO myw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","27","Pita ilana, “Tobwag gamag.” Iw to Yeisuw, ilana, “Mounid. Nitsiyas nag bipa̱yins, nag. Tage bweina bitapa̱yin silma̱nin Yowbad nabunatum; mata ge bigeg ninous tasiyas. Kun kuksikous, in wanamug bukukous, kukin wanuwan mo bukuban idamoney, bo ikadilok idata̱kis aditeiy. Kukow kusekes takaweins ta̱kis tasiyas.” ");
INSERT INTO myw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mitiya̱mun towen navamul inekes Yeisuw, ilansa, “Kal bimug Yowbad nakaleiwag wanuwan?” ");
INSERT INTO myw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Mapuna Yeisuw idouw gwad teitan beim. Im to gwad, Yeisuw itamnow gwad towen wanuwein, ilana, “Mounid adibakeimiy, kukin bikanavin ninoumiy bukumlavags ma̱wana gwad towen mo bukusiws wanuwan Yowbad nakaleiwag. Kukin gog nag, bo nag. ");
INSERT INTO myw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Kal yak bukuma̱num ma̱wana gwad towen, igaw bukumug Yowbad nakaleiwag wanuwan. ");
INSERT INTO myw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kukin bukuleb gwad teitan nisimounid waseg yey, magina bo kulabeig yey. ");
INSERT INTO myw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gamagal tasiyas isimounids waseg yey, kukin kal bikatsilakes silma̱nin bikakins sinap kalbaleb, singay kalbaleb bilouvat gamag towen. Kukin gamag mwasanin bikawes dakul avakaein biyawanis kayon bo bilaves bein wabwanit, biwgwel, nakalbaleb towen kalamwey; tage kukin bisesuna ee... bikatsilek teitan gwad, singaya kalbaleb mo bilouvat. ");
INSERT INTO myw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“O bo igak! Peinan tasiyas takalbalebs ikatsilakes gamag ven watinow. Gamag mwasanis bisilbwades sinap bwein, mo gamag babaw bilivatus kalbaleb. Ven watinow inakaleiwag ma̱wan. Tage tasiyas bisilbwades sinap bwein, igaw singay kalbaleb mo bilivatus. ");
INSERT INTO myw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kukin namam o kakeim bikaleiwag amsinap kalbaleb, kubob kulev. Bweina biyamkwen namam o kakeim, igaw mwamovam bukuban; awoum kid namam paleyun-wan o kakeim paleyun-wan igaw bilaveim bukun wanuwan kov towen nakagdaged nag beikous. ");
INSERT INTO myw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Ma̱wan-vak matam. Kukin matam bikaleiwag amsinap kalbaleb, kugut kulev. Bweina biyamkwen matam palatanok, igaw mwamovam bukuban; awoum kid paleyun-wan igaw bilaveim bukun wadiginasim, kov nigidaged waseg. ");
INSERT INTO myw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Awoum kwasigumis gwad teitan peinan igaw takakit; mounid adibakeimiy anelos tasiyas ililabes gamagal tut babaw sisiy Tamag walba̱lab; ikikines magin. ");
INSERT INTO myw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO myw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","13","“Kuninuways kavel alen sip lakatutan, mwantanok gog bilasisul ked bikanig, adok tanuwagan mtowen tamtakavatein bilisawes mansiyas sip sinawanim sinawavas mwananim mwanavas wa̱koy bisesus, binineiv gog mana̱wen nikanig. Igaw biban, mounid bimwa̱saw avakaein silma̱nin; tage inamwa̱saw kakit wasigeis mansiyas sip nisesus bwein wa̱koy. Tanuwagan nag ivag sivinan biyamkwen mwantanok sip. ");
INSERT INTO myw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Tamag walba̱lab ma̱wan; nag ivag sivinan biyamkwen gwad teitan, mamagina tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kukin soum biyagageim, kunek kwatimlek ansinap kalbaleb. Amiteiy kulivans. Awoum gamag babaw biliganes. Kukin biligen amlivan bo bwein, peinan bukumwas soum bwadam towen. ");
INSERT INTO myw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Kukin gog nag biligen, soum teitan o simwey asteiy kunekes bwadam towen, kulivans waseg va̱gan kid bisimounid amlivan meivek-wan. ");
INSERT INTO myw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Kukin bipiyev amlivan, mo kuneis kudibakes tayakelesiys, tasiyas babaw mo bilivans. Kukin bipiyev tayakalesiys asilivan, bweina kudok gamag towen tadadub, o magina takawein ta̱kis, kalbaleb gamag towen. ");
INSERT INTO myw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mounid adibakeimiy tayakelesiys yakamiy, aveiyag bukuyawanis ven watinow waseg, Yowbad mo biyawen walba̱lab. Aw-kaleiwag bukulikus ven watinow, Yowbad mo bilik walba̱lab. ");
INSERT INTO myw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Vayuwein adibakeimiy, kukin amiteiy ven watinow kusesus, igaw bukutams aw-youd bukunitougs waseg Tamag walba̱lab Tamag mo beitam, bisekeimiy youd towen. ");
INSERT INTO myw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Avanuy kwatuyouns amiteiy o amiteitoun silma̱nin gunawotet, simiy yey mo bitasesus, yey agugwamag yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iw to Pita, ikatigan Yeisuw, ilana, “Guyaw, siva̱vin soug biyagageig, mo bawid ansinap kalbaleb, banumlev? Adok siva̱nim sivay, ne?” ");
INSERT INTO myw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeisuw ilana, “Nag siva̱nim sivay. Deisa lakatunim lakatuy sinawanim sinawey mo siva̱nim sivay. ");
INSERT INTO myw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Mapun bakabebay mo bukukwakins Yowbad nakaleiwag; peinan ma̱wana guyaw teitan itita̱lay wasigeis inagamag. ");
INSERT INTO myw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Itokes teitan gamag imeyes, nakawlavag singay avakaein, sinawatan tawsan kina, ilana, ‘Gunmoney nag. Igaw wanakougwaw mo bamop waseg yak.’ ");
INSERT INTO myw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","“Natovek ilana, ‘Nag. Igaw teitan gamag beim bisekeig maysamiy soum mukwav o nitum, bitokeimiy bukuneis kuwotets towen nawotet, maysamiy money bo bakow kadilok mukwawlavag.’ ");
INSERT INTO myw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Taw towen mo ikulul igilagel, ilana, ‘Binok nuwam yey, igaw mo bamop gunakawlavag babaw, beikous.’ ");
INSERT INTO myw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Iyaka̱lin guyaw towen, ilik nagamag, iwid nakawlavag ikous, ilana, ‘Deisa kunoun. Bo awid mukwawlavag.’ ");
INSERT INTO myw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Inoun taw towen, iban son, peinan asteiy iwteles sitovek nawotet, ilana, ‘Mukwawlavag waseg yey lakatutan toya.’ Deisa iyous kayon son, ilana, ‘Nuwanaw kusekeig.’ ");
INSERT INTO myw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Son mo igilagel, ilana, ‘Binok nuwam yey, igaw mo bamop gunakawlavag babaw, beikous.’ ");
INSERT INTO myw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Towen ikayus, itok son, isen wanuwan deil, ilana, ‘Deisa kuses wa̱deil. Igaw bukumop mukwawlavag mo bukun wamnat.’ ");
INSERT INTO myw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Iliganes sisiyas, tasiyas tawteleins guyaw nawotet, singaya igeg ninous tasiyas, inekes sitovek towen, youd babaw ikamteles ikous. ");
INSERT INTO myw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","“Sitovek idouw mtowen beim. Im, natovek ilivan, ‘Singay takalbaleb ya̱koum. Nukugilagel to nawid mukwawlavag meivek-wan. Inok nuwag yak, tage nag inok nuwam soum. Bo igak!’ ");
INSERT INTO myw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Kapasal nuwan, idawes tamtakavateins deil, ilana, ‘Kutokes gamag towen, kunawes wa̱deil, bises oko igaw bimop nakawlavag beikous, mo bein wamnat.’ ");
INSERT INTO myw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tamag walba̱lab ansinap ma̱wan. Kal yak wananoum ta-bukuwid simwey sikalbaleb waseg yak, Yowbad bo bimop amsinap kalbakeb ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Anilivan tasiyas ikous, Yeisuw ilisow Galiliy, inoun in min-Yudiy siven palata-dadan lay yagan Yoldan. ");
INSERT INTO myw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Singay babaw gamag ikatukuns waseg; inekes Yeisuw, ven towen nises, takatouns iva̱ges mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tasiyas Palisiy mo inekes Yeisuw, iyakwanes, ilansa, “Tab kadiloka bakapiyev makwavas peinan asisinap mwasanin kalbaleb?” ");
INSERT INTO myw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","6","Yeisuw ikatimop asilivan, ilana, “Tabta kuvinis liva̱nen Yowbad, peinan kweiboug nibun gamag, kuda̱taw kuda̱vin, mo ilana. ‘Peinan kuda̱taw kweitan, kuda̱vin kweitan, kadiloka kuda̱taw bilisow taman inan, bikatuvases son nakwav, asteiy bimlavags mamagina wous katanok-wan.’ Peinan Yowbad anilivan ma̱wan, taveivays asteiy wous nag akweiy, bo katanok-wan. Peinan Yowbad bo ilaten, awoum gamag teitan biliv bisenas palatan palatan; awoum.” ");
INSERT INTO myw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ilansa, “Magat kaleiwag towen mounid, aveiyag wawun Moses nakaleiwag va̱gan kid towen tapiyavein nakwav bilel inalet bisek, bikayeb, mo beiyum bein wanven?” ");
INSERT INTO myw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iw to Yeisuw, ilana, “Kweiboug nag kweitan ked va̱gan gamag bipiyev nakwav. Wankuyeim gamag siyas takakons, to Moses isekeimiy miked waseg bukupiyaves mikwavas. ");
INSERT INTO myw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Mounid adibakeimiy kukin kal bipiyev nakwav, mo na̱tan bikow, ansinap towen kalbaleb, magina ikanavaya mav. Misinaka nakwav bimasis son teitan taw, namwan mo bipiyev.” ");
INSERT INTO myw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Navamul ilansa, “Magat veivay kaleiwag-nen bo ma̱wan, adok awoum bitaveivays.” ");
INSERT INTO myw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Yeisuw ilana. “Gamag babaw nag bikakins kaleiwag towen. Misinaka Yowbad ansinap bisekes gamag mwasanin, mo bikakins. Peinan tawaw mwasanin tutan insiyas nikopwes-yay powes nag, o tawaw mwasanin powes nag peinan gamag ikablaves, o gamag mwasanin ikablaves powes tatineis va̱gan bikanawes Yowbad nakaleiwag. Kal yak bukukwakin sinap towen, bweina kuligen.” ");
INSERT INTO myw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","14","Mo imeyes gamagal, sivines Yeisuw bituwanis wanaman, mo binitoug pines. Navamul bikayabes kid, Yeisuw ikayuses, ilana, “Awoum kwayabes. Bweina bimeis waseg yey, peinan Yowbad nakabkaleiwag wanuwan tasiyas babaw asisinap ma̱wana gamagal.” ");
INSERT INTO myw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bo ituwanis ikous, mo inoun. ");
INSERT INTO myw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Teitan gamag inek Yeisuw ilana, “Tamwey, aw-wotet bwanabwein bawtel mo baban mwamovag nag beikous?” ");
INSERT INTO myw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iw to Yeisuw, ilana, “Aveiyag wawun kwatiga̱neig silma̱nin sinap bwein? Anmwa̱net nises ansinap bwein. Magat sivinam mwamovam nag beikous, kadiloka kuvnas nakaleiwag beibwein.” ");
INSERT INTO myw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Ilivan, “Aw-kaleiwag?” Yeisuw ilana, “Tasiyas: Awoum kuweiy gamag; awoum kwanavay mav; awoum kuveinaw; awoum kuyaweid, teitan gamag liva̱nen; kuvna̱ses tamam son inam, kwanow ages; o kuvnas soum ma̱wana kuvna̱seim tatoneim.” ");
INSERT INTO myw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Toubwat towen ilana, “Kaleiwag siyas babaw bo ayakous. Aveiyag nika̱bwag waseg yey?” ");
INSERT INTO myw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iw to Yeisuw, ilana, “Magat sivinam sinap bwein bukuyakous, kun kuymiyis muvavag babaw, money kukow kunow, kuvgen tasiyas tasimavs wasigeis, igaw Yowbad mo biyamiyiseim walba̱lab. E, mumoney kuvgen beikous, mo kum kwabkunig yey.” ");
INSERT INTO myw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Toubwat towen ikatiligen anilivan, ipiyev, peinan ikayus nawliyoug, singay babaw; bo igeg nanon, inoun. ");
INSERT INTO myw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yeisuw mo idibakes navamuls, “Singay keikay guyawaw sikabeisiw wanuwan Yowbad nakabkaleiwag. ");
INSERT INTO myw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","“Vayuwein badibakeimiy, man avakaein mana̱wen kamel kalamwey keikay beisiw vas wawawun; tage guyawaw singay keikay beisiws wanuwan Yowbad nakabkaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Inavamul iliganes, isunasun ninous, ilansa, “Magat tasiyas nag, kalisiy mo beisiws?” ");
INSERT INTO myw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeisuw ikines tasiyas navamul, mo ilana, “Gamag yakamiy wasigeis nag kadilok, tage Yowbad waseg youda babaw bo ikadiloken-wan.” ");
INSERT INTO myw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita mo ikatugan, ilana, “Yakamey bo nakapiyev mavavag babaw, tage bo nakabkunim yak, aveiyag yakamey bakalouvat?” ");
INSERT INTO myw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeisuw ilana, “Mounid adibakeimiy, yakamiy nukubkunigs yey, igaw tut wanakougwaw, Gimgilitoun yey basin a̱bag bwanabwein waseg, yakamiy bukusinis wakabamiy sinawatan akweiy bukwaleiwags wasigeis min-Yisleil adakums sinawatan akweiy. ");
INSERT INTO myw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“E, kalisiy yakamiy kulisawes mibunatum, tawlimiyas, timmiyas, inmiyas, nitimiyas, o mipwepway va̱gan bukukwawes gunawotet, atimapun tasiyas singay babaw bukuba̱nes son mwamovamiy nag beikous. ");
INSERT INTO myw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Gamag babaw nimugwas igaw bikuyeims, o tasiyas nikuyeims igaw bimugwas. ");
INSERT INTO myw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","2","“Yowbad nakaleiwag ma̱wana teitan taw, inaven avakaein. Iyam ga̱boug ikit, iliwon wavtakon ven, ilana, ‘Gunawotet nises, gunabag, bukuneis kuwotets katanok yam, maysan wotet katanok kina, igaw mo basekeimiy.’ Itams mwasanin, inounas ineis wanabag. ");
INSERT INTO myw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","5","“Wankuyeim, ka̱las bo italga̱lag, in waven, iban gamag mwasanin isimavs. Ilana, ‘Kuneis, kuwotets gunabag. Igaw maysan mo basekeimiy.’ Mo itams, ineis. Wankuyeim, ya̱nay, iban gamag, ilivan ma̱wan, mo ineis, iwotets wanabag. Wankuyeim ka̱las itageg, iban gamag, ilivan ma̱wan, mo ineis. ");
INSERT INTO myw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Babaw gamag iwwotets ee... kakita beiboug, tamwey towen in waven, iban gamag mwasanin, ilana, ‘Aveiyag wawun makava kusesusa bo iboug?’ ");
INSERT INTO myw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Iweis tasiyas, ilansa, ‘Peinan ta-kal bisekem mawotet.’ Ilana, ‘Yakamiy-vak kuneis, kuwotets gunabag.’ ");
INSERT INTO myw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Iboug, taginbag idibek natouwat, ‘Kudibakes tawteleins bag bimeis, maysan siwotet kusekes. Kusilamaw kweivaw gamag tasiyas mwana nimeis, mayses kusekes. Ikous, mo tasiyas kwayav nimeis. Ma̱wana bein ee... nakabiyokous tasiyas ga̱boug nisilamaws.’ ");
INSERT INTO myw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tasiyas kweivaw gamag nag bivakaein siwotet, imeis, wotet maysan mo ikawes katanok kina. ");
INSERT INTO myw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Siyas gog ga̱boug nisilamaws, idokes kid avakaein mayses bikawes. Nag gog, katanok kina. Meiveka gamag mayses bo katanok kina. ");
INSERT INTO myw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","“Mayses ikawes, ivtokes livan tamwey towen, idibakes, ilansa, ‘Tasiyas nag bivakaein siwotet mayses bo katanoka ma̱wan yakamey. Yakamey gog nakawotet ka̱las midamed. Ga̱boug nakasilamaw kawwotet oko iboug.’ ");
INSERT INTO myw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","15","“Tamwey ikatimop aygan teitan, ilana, ‘Gwa, nag ayagageim, nag. Ga̱boug agulivan bo kutams: Katanok yam katanok kina. Mukina towen-an kukow kunow. Sivinag basekes kweivaw gamag siyas ma̱wana yakamiy. Kadilok yey bakaleiwag gunavavag waseg. Awoum bimouvit dabam peinan agusinap bwein.’ ");
INSERT INTO myw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Siyas nimugwas igaw bikuyeims, o tasiyas gog nikuyeims igaw bimugwas.” ");
INSERT INTO myw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","19","Ikous, mo inounas, bikatulags kid bineis Yelusalem. Wa̱ked Yeisuw idibakes tasiyas navamul, ilana, “Bo bitakatulags taneis Yelusalem, teitan gamag mo bisilkodeig Gimgilitoun yey, mo biyousigs tasiyas tanuwgwes lun situwa̱vek sisiyas takatimlakeins kaleiwag, biyateleigs va̱gan bikatimateigs, igaw mo bita̱meigs wasigeis tobwag ven gimgilis Yelusalem nisesus; tasiyas bisiba̱weigs, biwaweigs, bikatkaviteigs waklos. Yam kweitoun mo batamanaw vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iweis na̱wen Sebediy nakwav, siney nitun tawaw asteiy, mana̱wen ikulul wamatan Yeisuw, binitoug waseg. ");
INSERT INTO myw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeisuw ilana, “Aveiyag sivinam?” Iw mana̱wen ilana, “Kukwaleiwag va̱gan kid igaw bukuguyaw, nitug siyas-nan bisinis wadadam, teitan wamkwa̱tay, teitan wamkimaw.” ");
INSERT INTO myw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeisuw ikatimop asilivan, ilana, “Nag kukwakins mikanitoug towen. Tab kadiloka bukumoums agukwa̱vig to ba̱moum?” Ilansa, “Bo kadilokem.” ");
INSERT INTO myw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Idibakes, “Mounid bukumoums agukwa̱vig, tage na-ikadilokeig bakaleiwag kavel bisin wagunka̱tay o wagunkimaw, nag. Tamag gog bo ikatineg abes tasiyas bisinis wagunka̱tay o wagunkimaw, mtowen takaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yeisuw navamul tasiyas sinawatan mo iliganes sikanitoug asteiy son bwadan bo ikawkunes. ");
INSERT INTO myw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","27","Yeisuw gog ikakin asisinap, idawes bimeis. Imeis mo ilivan, “Kukwakins ven babaw guyawuns asisinap, keikay wudous; o sikaleiwag tawtoun wasigeis. Yakamiy gog amisinap kweitan. Kukin kal sivinan biguyaw wasigeis yakamiy, bweina bimlavag mitouwat; o kal sivinan bimug, bweina beibus ma̱wana tasimav, bikokew miwotet. ");
INSERT INTO myw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","“Yey gog, Gimgilitoun yey, agusinap ma̱wan. Yey nam, mata ge kulabeigs; deisa balabeimiy. Kaleivig bo atam maysamiy tababaws yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wankuyeim wa̱ked ininounas, bo ilisawes Yelikow, singay babaw gamag ikatukuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tasiyas toukwaws asteiy isinis wadadan ked, bo iliganes liva̱nen Yeisuw, peinan bo neim. Iliganes, mo iwaks, ilansa, “Deibid tabun Mesay ya̱koum, binok nuwam yakamey.” ");
INSERT INTO myw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Asibabaw ilansa, “Kukwa̱pays yakamiy!” Tasiyas gog isimkakinsa waseg, ilansa, “Guyaw, Deibid tabun yak, binok nuwam yakamey.” ");
INSERT INTO myw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeisuw itoun, mo idawes tasiyas bimeis, mo ilana, “Aveiyag sivinamiy bavag wasigeis yakamiy?” ");
INSERT INTO myw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ilansa, “Guyaw, kuvag beilal mitem.” ");
INSERT INTO myw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeisuw inok nuwan tasiyas, mo ikabkwen mites, nuwanawa ikins bwein, mo ibwa̱kuns Yeisuw waseg, inounas. ");
INSERT INTO myw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Inounas ee... kadiykusan-o Yelusalem, koy towen kay siyas oliv nitatos, ven yagan Betepeig; mo ikayeb navamul asteiy, ilana, “Kuneis ven towen palatan, mo bukuba̱nes donkiy nises, anvatul iyawanis wakayon, son natun nisesus; kulikus, kutokes kumeyes. ");
INSERT INTO myw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Kukin kal bikatugwan wasigeis yakamiy, kwatimapus anilivan, kulansa, ‘Tanuwagan sivinan mansiyas donkiy,’ mo beitam towen.” ");
INSERT INTO myw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iva̱ges ma̱wan, mo ikamat liva̱nen Mesay, kweiboug palopit nilivnek, ilel ma̱wan: ");
INSERT INTO myw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kudibakes Sayon vinay-nen, ‘Kukines miguyaw bo beiw, Imwen donkiy watapwan; magina tamma̱num mtowen neiw, Isin donkiy natun watapwan.’” ");
INSERT INTO myw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ineis tasiyas asteiy, ikanawes aygan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Iba̱nes donkiy son natun, itokes imeyes; inibwis asikweim, isenas watapwan donkiy, Yeisuw imwen, isin wakunuwatan donkiy. ");
INSERT INTO myw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gamag babaw iyaves asikweim wa̱ked; mwasanin gog itateiys amweilok yageivein, iyaves wa̱ked. ");
INSERT INTO myw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tammugwas imugwas, takukuyeims ikukuyeims, asibabaw iwkuwaks, ilansa: “Kalin nuwem, Deibid tabun yak. DaGuyaws nikayabeim, nukum va̱gan bukwatinabwem. Kalin nuwem Tamads walba̱lab.” ");
INSERT INTO myw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Isiw in Yelusalem, taginvens babaw isisawls imimeis silma̱nin bikines Yeisuw, illivans, “Kavel mtowen?” ");
INSERT INTO myw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tasiyas sisiy Yeisuw ilansa, “Mtowen palopit yagan Yeisuw, gum-Nasalet teitan, inaven wawnuwan Galiliy.” ");
INSERT INTO myw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeisuw isiw in wanuwan Yowbad nabunatum bunavakaein, mo ikayabes tasiyas niyamiyises sivavag; ikatitan siteibol tasiyas nikatimapus money dakul, o ikatitan abes tasiyas niyamiyises bwabun. ");
INSERT INTO myw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Idibakes, ilana, “Bukitab waseg liva̱nen Yowbad nabunatum nises mamagina: ‘Gunbunatum bikayuses silma̱nin nitoug;’ tage nukuva̱ges buntuman veinaw.” ");
INSERT INTO myw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Igaw nises Yowbad wanbunatum, tasiyas toukwaws sisiyas takagayals inekes Yeisuw; ivag, mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tasiyas gog tanuwgwes lun situwa̱vek sisiyas takatimlakeins kaleiwag ikines Yeisuw, Yowbad wanbunatum, nawotet tawtoun, o gamagal niwkuwaks ilansa, “Kalin nuwem Deibid tabun yak,” singay mo ikawkunes Yeisuw tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ikawkunes, ilansa, “Bo kuligen ages, siyas gamagal?” Yeisuw itam, ilana, “Oo!” Ilana, “Adok nag kukwakins liva̱nen Yowbad, Bukitab waseg, mamagina: ‘Ninous bo kusekes gamagal sisiyas a̱pwaw, mo iya̱kawns bwein.’” ");
INSERT INTO myw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mo ilisawes inoun, ilisow ven towen avakaein, inoun in wunkakit, imasis ven towen Betaniy. ");
INSERT INTO myw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iyam-nen ga̱boug iyum in silma̱nin wunovek, ivag anamoun. ");
INSERT INTO myw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wa̱ked iban yaveinun kaytan, iwekey, anagin nag, yageiveina mav, ikawtun ilana, “Igaw nag kweitan anagim beivag waseg yak.” Nuwanaw mo ikaleyag, imat. ");
INSERT INTO myw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Navamul ikines, isom ninous, ilansa, “Nuwanaw bo ikaleyag yaveinun makaywen! Aw-sinap towen?” ");
INSERT INTO myw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iw to Yeisuw, ilana, “Mounid adibakeimiy, awoum beivag ninoumiy akweiy. Magat bukunamis Yowbad natawtoun waseg, mo bukuva̱ges ma̱wana yey navag yaveinun; e, bukudibakes koy towen kulansa, ‘Kunoun kun kumukul wa̱yol,’ mo binoun bein bimukul wa̱yol. ");
INSERT INTO myw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Aveiyag bukunitougs Yowbad waseg, kunamis beibwein, mo bisekeimiy.” ");
INSERT INTO myw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikous, inoun in Yowbad wanbunatum, ikatimlakay. Mo imeis tasiyas tanuwgwes lun situwa̱vek sisiyas tammwayas, ilansa, “Aw-kaleiwag waseg kuwtel ma̱wan, o kal isekeim mukwaleiwag towen?” ");
INSERT INTO myw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeisuw ikatimop asilivan, ilana, “Kweitan sinap bakatugan wasigeis yakamiy; e, bukulivans kamnat mo basekeimiy livan kamnat va̱gan bukukwakins silawun gunakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","E, Yeisuw mo ikatiga̱nes, ilana, “Kal isek Yon nakaleiwag mo ibapta̱yses gamags? Yowbad? o nag? adok gamag mwasanin?” Bo ibol ninous tasiyas, illivans sisiyas, ilansa, “Kukin bitalivans ‘Yowbad,’ towen gog mo bilivan ‘Aveiyag wawun nukupiyaves aygan?’ Kukin gog bitalivans ‘Gamag mwasanin,’ bo biyagageids gamag babaw, peinan idokes palopit teitan mtowen Yon.” ");
INSERT INTO myw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Idibakes Yeisuw ilansa, “Nag kakakin.” Iw to Yeisuw ilivan, “Yey-vak nag balivan, nag bakamtilakeimiy kal isekeig gunakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeisuw ikabebay, ilana, “Waninoumiy ama̱wan? Tamwey teitan nitun tawaw asteiy. Mo inek kunutaw ilana, ‘Nagein kun gunabag kuwotet.’ ");
INSERT INTO myw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Kunutaw ipiyev. Wankuyeim mo ikanavin nanon; inoun in iwotet. ");
INSERT INTO myw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Tamwey towen mo inek tawa̱nay, ilana, ‘Kun kuwotet.’ “Tawa̱nay ilana, ‘Oo! Bo ban awotet.’ Nag gog, ipiyev wotet, isinal.” ");
INSERT INTO myw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeisuw ilana, “Asteiy ikatiliganes aygan times, tage kal ikanaway aygan?” Ilansa, “Kunutaw.” Iw to Yeisuw ilana, “Mounid adibakeimiy tasiyas ma̱wana kunutaw mo beisiws wanuwan Yowbad nakabkaleiwag. Peinan tasiyas takalba̱lebs, takaweins ta̱kis sisiyas tasiyas ikaninavays mav bo bimugwas Yowbad nakaleiwag waseg; yakamiy ma̱wana tawa̱nay wankuyeim. ");
INSERT INTO myw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Peinan Yon ikatimlakeimiy ked didumwal, tage nag kusimounids. Takalba̱lebs tasiyas bo isimounids, tawaw vinay. Yakamiy nukukines tage nag ikanavin ninoumiy; nag kusimounids, nag. ");
INSERT INTO myw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kabebay kweitan kunages: Tamwey teitan isop gleip babaw, bigulen gleip waseg; kay kaytan isop wadadan bag palavas, bo imlavag anakal; wayn kasinen ivkaes ikous; tamtakavatein bag nabunatum iwlul ikous; ivatam wasigeis gamag mwasanin va̱gan kid bimtakavates inabag; mo inoun in kweitan ven. ");
INSERT INTO myw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Igaw tutan gleip anagin bimwanoug mo ikayabes natouwat mwasanin, binekes tasiyas tamtakavateins bag, idokes tanuwagan bag anagin bikawes. ");
INSERT INTO myw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Nag gog, tasiyas tamtakavateins bag iyagages tamwey natouwat, teitan iwaweiys, tayuwein ikatimates, tatounun iwaweiys dakul waseg, imat. ");
INSERT INTO myw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Wankuyeim tamwey towen ikayabes natouwat kalamwey babaw, mo iyagages tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ikous, mo ikayeb natun, idoki bivna̱ses natun. ");
INSERT INTO myw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nag gog, iwtusis natun, ilansa, ‘Mtowen tamwey natun tatonen, kumeis taweiys, mo bitakawes bag towen, dakiyays ya̱kids.’ ");
INSERT INTO myw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“E, iweis, iyousis, itokes tamwey natun, ilaves in watoulan bag, mo iweiys imat.” ");
INSERT INTO myw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeisuw ikatigan ilana, “Igaw beim tanuwagan bag, ama̱wan bikaleiwag wasigeis tasiyas tawteleins bag?” ");
INSERT INTO myw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iweis tasiyas, ilansa, “Biyagagesa singay, bikatimates, siwotet gog mo bisekes gamag mwasanin asisinap bwein, tasiyas mo beitams anagin bisekes tamwey bweilim katanok katanok waseg.” ");
INSERT INTO myw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeisuw ilana, “Adok nag kuvinis Bukitab liva̱neig, mamagina: ‘Wululay towen tawteleins bunatum nipiyaves, Tage bo imlavag anmwamwan bunatum. DaGuyaws nawotet towen, bo isom nanouds.’” ");
INSERT INTO myw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeisuw mo ilivan, “Mapun adibakeimiy Yowbad bigidem nakaleiwag wasigeis yakamiy, bisekes ven mwasanin, igaw tasiyas mo beitams inakaleiwag waseg, mo anagin beivag. ");
INSERT INTO myw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Kukin kal bipiyaveig mo kalbaleb bilivet, mamagina bikalivatow wakunuwatan wululay towen mo bigulek won, o kukin gog wululay towen bikalivatow beiweiy gamag teitan mo bikatimimey. Wululay towen yey.” ");
INSERT INTO myw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Kabebay tasiyas iliganes siyas tanuwgwes lun situwa̱vek sisiyas tasiyas Palisiy, ikakinsa tatineis askabebay. Sivines kid biyousis Yeisuw. Ta-ma̱wan; iwenes gamags, peinan gamag babaw idokes Yeisuw palopit teitan. ");
INSERT INTO myw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Vayuwein Yeisuw ikabebay liva̱nen Yowbad nakaleiwag. Ilana, “Yowbad nakaleiwag ma̱wana guyaw teitan inasagal. Bo isagal peinan natun teitan beivay. ");
INSERT INTO myw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Inasagal avanin ikatineg ikous, ikayabes natouwat mwasanin, idawes gamag bimeis bisagals. Ipiyaves gog. ");
INSERT INTO myw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Wankuyeim ikayabes natouwat mwasanin, idawes tasiyas ilansa, ‘Datoveks bo ikatineg kan ikous, bulumakaw kawka̱veks bo iweiys ikous, bulumakaw bulwaway, askeitub igegayous, bo iweiys ikous, youd babaw bo ikatinages ikous. Kumeis sagal towen, peinan tamwey natun bo beivay.’ ");
INSERT INTO myw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","“Tasiyas gog ipiyaves, issebaws, inounas ineis palatan palatan, teitan in wa̱bag, teitan in bigimwal, mwasanin gog nisesus waven iyousis tamwey natouwats iyagages. Natouwat tasiyas asimwasin nag bikakit va̱gan; mwasanin ge iweiys ikatimates. ");
INSERT INTO myw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Guyaw towen iligen, kapasal nuwan, ikayabes takanaviys, ineis iweiys takalbalebs tasiyas ikous, sibunatum babaw igabus kov waseg. ");
INSERT INTO myw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","“Iyums takanaviys; iwa̱ge tamwey ilana, ‘Na-ikadilokes tasiyas beikams sagal to nakatineg. Kuneis guntouwat yakamiy, kudawes tasiyas wadadan ked nisesus, kukin kalisiy bukuba̱nes, kudawes bimeis.’ ");
INSERT INTO myw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Inounas palatan palatan, tababaw iba̱nes mo idawes, mwasanin takalba̱lebs, mwasanin toubweins. Iliganes, ikatuyouns imeis, bo ika̱lawt gamag babaw wasagal. ");
INSERT INTO myw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","“Tamwey towen im bikin gamag babaw-wan, iban teitan ta-isikam sagal kweiman, idibek, ilana, ‘Gwa, ama̱wan nukum, ta-ivag amkweim sagal kweiman?’ Towen isesuna ikika̱pay. ");
INSERT INTO myw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Iw to guyaw, idibakes natouwats ilana, ‘Kuywanis naman kaken taw towen, kulaves bein watoulan, dadub waseg.’ Tasiyas watoulan bivva̱lams-wan, singaya bigeg ninous. ");
INSERT INTO myw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Yowbad bo idawes gamag babaw; teyuy-e beisiws bimeis.” ");
INSERT INTO myw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Siyas Palisiy iliganes, mo ineis, illivans sisiyas, idokes bikatiga̱nes kid mo beibol Yeisuw anilivan. ");
INSERT INTO myw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","17","Illivans ee... sinap kweitan mo iton. Ikous mo ikayabes sivamul mwasanin sisiyas Elod nagamag mwasanin, idibakes Yeisuw, ilansa, “Tamwey yak, kakakin amsinap mounid, kakakin Yowbad nakaleiwag kukwatimlakay mounid, o nag kugoulus guyawaw mwasanin, peinan gamag babaw wamatam bo katanok-wan. Wananoum ama̱wan? kadilokeids bitatams Sisal nata̱kis? o nag? bitapiyaves adok?” ");
INSERT INTO myw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Yeisuw gog ikakina asisinap kalbaleb, ilana, “Aveiyag wawun kuyakwaneigs? Tayyaweids yakamiy! Kwatimlakeigs money towen, ta̱kis silma̱nin.” Money katanok mo isekes. ");
INSERT INTO myw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ikow money towen wanaman, ikatimlakes king yagan nises son kululuwan nilel money towen waseg, ikatugan, ilana, “Kavel yagan? kavel kululuwan towen?” ");
INSERT INTO myw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ilansa, “Sisal.” Iw to Yeisuw, ilana, “Sisal navavag bweina kutams Sisal waseg, o Yowbad navavag bweina kutams Yowbad waseg.” ");
INSERT INTO myw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iliganes, isom ninous, iyums ineis wasiven. ");
INSERT INTO myw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Yam towen tasiyas Sadusiy mo inekes Yeisuw. Tasiyas Sadusiy asilivan ilansa, “Gamag nag beikits kanig waseg.” Mapun ikatiga̱nes Yeisuw ilansa, “Tamwey, Moses nakaleiwag mamagina, kukin kal bikanig, nakwav sam, tage natun nag, kadiloka bwadan beivays son nakwab, igaw mo bikop natun bimlavag tuwan natun. ");
INSERT INTO myw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“E, kunutaw teitan wamaven nises, budan teinim tatanok. Kunutaw ivays son nakwav, natun nag, ikanig, isikein ivays son nakwab. ");
INSERT INTO myw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“E, isikein ikanig, natun nag, nakwab ivays son tawa̱nay. Tasiyas tawa̱nay imta̱mats ikous, nitsiyas nag, oko digumasus mo ivays son nakwab; ikanig, natun nag. ");
INSERT INTO myw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","“Ikous tawaw babaw, wankuyeim mo ikanig kuda̱vin mana̱wen. ");
INSERT INTO myw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Igaw tutan beikits kanig waseg, vin mana̱wen namwan amtowen? Peinan asibabaw neivays siney.” ");
INSERT INTO myw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","30","Yeisuw gog ikatimop asilivan, ilana, “Ibol ninoumiy, peinan nag kukwakins Bukitab, o peinan nag kukwakins Yowbad natawtoun. Igaw tut wanakougwaw gamag beikits kanig waseg, mo beikous veivay, peinan gamag bimlavags mamagina Yowbad nataka̱yob nisesus walba̱lab. ");
INSERT INTO myw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“E, mounid gamag beikits kanig waseg. Adok nag bukuvinis Yowbad anilivan wasigeis yakamiy, peinan ilana: ‘Yey Ebelam naYowbad yey; Yey Aysak naYowbad yey; Yey Yekob naYowbad yey.’ Yowbad nag ikaleiwag takanigs tatuwes wasigeis; nag. Tage tamwamovs wasigeis ikaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gamag babaw iliganes ansinap, bo isom ninous waseg. ");
INSERT INTO myw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","36","Tasiyas Palisiy iliganes Yeisuw nikatimop asilivan Sadusiy, nika̱pays, mo ikatuyouns tasiyas Palisiy, imeis. Palisiy teitan ikatigan Yeisuw, mtowen ya̱tal sinapun ikakin; ikatugan va̱gan kid biyakwen Yeisuw, ilana, “Dakaleiwags waseg, aw-kaleiwag imug?” ");
INSERT INTO myw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Iw to Yeisuw ilana, “‘Kadiloka kusiwa̱youb daGuyaws Yowbad, kululuwam waseg, kaleivim waseg, o nanoum waseg.’ Kaleiwag towen imug; imgwayes kaleiwag babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“Kaleiwag tawtoun kwayuwein nises: ‘Kadiloka kuvna̱ses simwey ma̱wana nukuvna̱seim tatoneim.’ ");
INSERT INTO myw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Akweiyuna kaleiwag tasiyas wawun kaleiwag babaw, o wawun siyas palopit asilivan babaw.” ");
INSERT INTO myw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Tasiyas Palisiy ikatuyouns nimeis, Yeisuw mo ikatiga̱nes, ilana, “Waninoumiy Mesay ama̱wan? kavel tabun?” Iweis tasiyas, ilansa, “Deibid tabun.” ");
INSERT INTO myw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","45","Yeisuw mo ikatiga̱nes, ilana, “E, Mesay Deibid tabun; tage kweiboug Yowbad Kululuwan isek Deibid ansinap mo ilivan, idok Mesay inaguyaw tatonen; anilivan mamagina: ‘DaGuyaws idibek gunGuyaw, ilana: Kusin wagunka̱tay, va̱gan bava̱ges beibus siyas astameiliw yak, bukuvnivans wakunutes.’ Peinan Mesay Deibid tabun, ama̱wan Deibid idok tabun naGuyaw tatonen?” ");
INSERT INTO myw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bo ika̱pays tasiyas. Ta-kal bikatimop aygan. Bo iyakous sikatugan waseg Yeisuw. Wankuyeim mo igoulus; nag teitan ikatugan waseg, nag. ");
INSERT INTO myw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","3","Yeisuw mo idibakes gamag babaw, sisiyas navamul, ilana, “Moses kweiboug ikaleiwag gamag wasigeis, o nagein tut towen siyas takatimlakeins kaleiwag, sisiyas Palisiy, bo ikaliwageids ma̱wan. Mapun kadiloka kukwanawes ages; tage asisinap awoum kukwawes, peinan nag ivna̱ses kaleiwag tasiyas nisekeids. ");
INSERT INTO myw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Sikaleiwag tasiyas mamagina kunamiy singay moumouvit nissekeimiy, tage nag kweitan koun kakit bikawes tatineis. ");
INSERT INTO myw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Siwotet iwteles va̱gan gamag babaw bikines mo bikavasis. Bukitab yageivein mwasanin iyawanis ikaygwagwes wawous va̱gan gamag bikines, o kweiman tapwa̱loul issikams va̱gan gamag babaw bikines. ");
INSERT INTO myw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Sivines kid bimgwayes gamag babaw, sagal waseg; o sivines abes wanakaew wanuwan sinagog. ");
INSERT INTO myw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Kukin binounas bineis waven sivines kid gamag babaw bikululs wamtes, o bigoulus, billivans, ‘Guntakatimlakay yak.’ ");
INSERT INTO myw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Awoum gamag bidokeimiy ‘Guntakatimlakay yak,’ awoum; peinan mitakatimlakay anmwa̱net, o yakamiy katanoka gamag yakamiy. Deisa kulansa, ‘Gwa.’ ");
INSERT INTO myw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Ven watinow ya̱kids awoum kudokes teitan, kulansa, ‘Timem,’ peinan Tamads anmwa̱net nises walba̱lab. ");
INSERT INTO myw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Awoum gamag bidokeimiy ‘Guntovek yak,’ peinan mitovek Kelis. Nag tayuwein mitovek nises, nag. ");
INSERT INTO myw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Kukin kal bimlavag mitouwat mtowen mo bimgwayeimiy. ");
INSERT INTO myw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","“Kukin kal sivinan bimliguyaw mo beibus; tage kukin kal binib tatonen igaw mo biguyaw. ");
INSERT INTO myw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus, peinan kusilbwades Yowbad nakabkaleiwag kidenen; yakamiy nag bukusiws; mogo gamag mwasanin beisiws kid; nag gog, bo kusilbwades. ");
INSERT INTO myw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO myw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus. Kuta̱vins vena babaw, ikous mo kukuks, bwanit kadiveiyov kudopels. Aveiyag wawun? gamag anmwa̱net mo bikow mitapwa̱loul bimlavag gum-Yudiy. Ikous, mo gamag towen kuva̱ges imlavag Seitan angamag, ma̱wana yakamiy, tage bo bilisaweimiy ansinap kalbaleb waseg. ");
INSERT INTO myw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Takatimlakeins gamag yakamiy, bo ibol ninoumiy, singay kalbaleb bukulivatus. Kulivans, ‘Bweina bitatabudabod Yowbad nabunatum waseg, adilivan yaweid, tage bitatabudabod waseg goul towen nises Yowbad wanbunatum, awoum bitayaweid.’ ");
INSERT INTO myw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Bo ibol ninoumiy, amisinap nag. Aveiyag imug? Goul towen imug? O Yowbad nabunatum imug? Mounid Yowbad nabunatum imug, peinan goul nises wanuwan. ");
INSERT INTO myw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Kulivans-vak, ‘Bweina bitatabudabod abeilun waseg, adilivan yaweid, tage bitatabudabod waseg lun to nises wakunuwatan, awoun bitayaweid.’ ");
INSERT INTO myw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Bo ibol ninoumiy, amisinap nag. Aveiyag imug? lun towen? o dakabeiluns Yowbad wanbunatum, inalun nises wakunuwatan? ");
INSERT INTO myw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Mapun, igaw bukutabudabod abeilun waseg, bo kutabudabod wasigeis youd babaw nisesus wakunuwatan. ");
INSERT INTO myw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“E bukutabudabod waseg Yowbad nabunatum, bo kutabudabod waseg bunatum son mtowen nises wanuwan. ");
INSERT INTO myw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“E, bukutabudabod liba̱lab waseg, bo kutabudabod waseg Yowbad a̱ban son mtowen-vak nissin waseg. Bo ibol ninoumiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus. Gayas siyas kekel minit, dil, kamin, kulagus sinawatan, kalgutan kutams Yowbad waseg, tage Yowbad nakaleiwag avakaein waseg nag kutams, peinan sinap didumwal kupiyaves, siwa̱youb kupiyaves, simounid kupiyaves Yowbad waseg. Kadiloka kunuwes sinap siyas avakaein. Nag gog. Awoum kupiyaves sinap siyas babaw-wan. ");
INSERT INTO myw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Takatimlakeins gamag yakamiy, mitamiy nag. Kwatkakils sinap kakit wasigeis, mamagina pwasigisig wanuwan amiva̱van mo kupiyaves, tage kamel sona kwanpwanis. ");
INSERT INTO myw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus. Kwa̱vig o abmavin watoulan kwatkakils, kuwidis bwein, gimagim watoulan, tage wanuwan kaeimiy bukuveinaws gamag wasigeis. ");
INSERT INTO myw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Matam nag, Palisiy yak. Bweina beivag amsinap bwein, waseg bukuban kam, mo bukusen wamkwabmavin o amkwa̱vig waseg; babaw mo beibwein watoulan o wanuwan. ");
INSERT INTO myw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus. Mamagina alawag yakamiy, dakul watoulan singay ankakin bwein, singaya pwapwa̱kaw, wanuwan gog kalbaleb, gamag tatuwes seiy, youd bikibik seiy. Yakamiy bo ma̱wan, amikakin watoulan gamag ikines, magina sinap didumwal, waninoumiy gog sinap yaweid, ikamimet, kalbaleb seikwan. ");
INSERT INTO myw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Tayyaweids yakamiy takatimlakeins kaleiwag yakamiy, o yakamiy Palisiy, singay kalbaleb bukulivatus. Tasiyas palopit asisinap didumwal, kweiboug imats, sikalawag nukutoumis, astubub kusenas, mo kulansa, ‘Magat ya̱kids bitasesus sidayas, tammwayas isitut waseg, nag bitalabes igaw iwaweiys siyas palopit.’ ");
INSERT INTO myw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","“Yakamiy gog kulivans ma̱wan, peinan tammwayas tibsiyas yakamiy, amisinap ma̱wana tasiyas, mo bukuyakousis siwotet kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mwatet nitun yakamiy, Yowbad bikaleiwag bilaveimiy bukuneis wadiginasim. Ta-ma̱wan bukusawls bukuneis. ");
INSERT INTO myw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Mapun akayabes palopit babaw, tassinaps babaw, takatimlakeins kaleiwag babaw; tasiyas biwekeimiy, igaw bukwatimates mwasanin, mwasanin bukuweiys waklos, mwasanin wamibuntuman tapwa̱loul bukuwaweiys vatul waseg, bukwatigigayes mwasanin mo bisawls bineis ven kweitan kweitan. ");
INSERT INTO myw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Amisinap mapun mo bukulivatus son mapun asisinap tasiyas kweiboug neiweiys palopits. Ven watinow gimgilis yakamiy nukuweiys tasiyas tadidumwals, nukusilamaws waseg tadidumwal towen Eibel; mo nukuwaweiys tasiyas palopits oko Balakiy natun Sekaliy nukuweiys Yowbad wanbunatum, abeilun palatan, Yowbad nabunatum palakakit palatan. ");
INSERT INTO myw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Mounid adibakeimiy gudwouvaws yakamiy, bo bukulivatus mapun amisinap kalbaleb sona asisinap tasiyas tabga̱bougs.” ");
INSERT INTO myw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Liva̱nen ven towen Yelusalem Yeisuw mo ilivan mamagina “O Yelusalem gimgilis yakamiy, nukuwaweiys tasiyas palopits, o dakul waseg nukuwaweiys tasiyas Yowbad nikayabes niwekeimiy; tut babaw sivinag bamtakavateimiy ma̱wana kolkolek imtakavates nitun; nag gog, kupiyaveigs. ");
INSERT INTO myw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","“Mapuna Yowbad ipiyev miven. Makava bukusesus. Igaw nag bukukineigs ee... anatut bukulivans, ‘DaGuyaws nikayabeim nukum, mapuna kakavasim,’ mounid mo bukukineigs.” ");
INSERT INTO myw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeisuw ilisow Yowbad nabunatum, inoun; navamul mo inekes, ikamtilakes Yeisuw bikin Yowbad nabunatum siyas bunamnabweins. ");
INSERT INTO myw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeisuw ikatimop ages, ilana, “Kukines bunsiyas bunatum. Mounid adibakeimiy bo bigulekwes biyakousis; dakul babaw bilaves bikatiggayes.” ");
INSERT INTO myw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Inounas ineis koy towen bigulen oliv nises, isin; tasiyas navamul inekes, ilansa, “Kudibakem asinavin bigulekwes bunatum bunawen bunavakaein; ama̱wan bakakakin avei-tut bukuyum bukum mo beikous ven watinow?” ");
INSERT INTO myw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iw to Yeisuw, ilana, “Awoum gamag mwasinis bikatidavimiy. ");
INSERT INTO myw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Igaw teitan bisap, bilana, ‘Yey Mesay Kelis yey,’ wankuyeim tayuwein bisap bilana, ‘Yey Mesay Kelis yey,’ wankuyeim tatounun ma̱wan; e, ma̱wana ma̱wana ee... singay babaw. Tasiyas bo bikatidividavs wasigeis gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Liva̱nen naviy bukuliganes, livan kweitan kweitan, awoum beiyow nuwamiy, kadiloka biva̱ges ma̱wan; nakabiyokous tut igaw. ");
INSERT INTO myw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Peinan ven kweitan bikanaviys kweitan ven waseg, ven avakaein bikanaviys ven avakaein waseg; ven mwasanin bikamates moun; ven mwasanin nik avakaein bivag. ");
INSERT INTO myw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","“Youd tasiyas moumouvit bisunaps, igaw mo bivakaein. ");
INSERT INTO myw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tasiyas ikamliweimiy mo biyagageimiy, bikatimateimiy; e, vena babaw gimgilis bikamliweimiy peinan gungamag yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","“Mapuna mwasinis bikalouws; mwasinis bisilkodes sisiyas, bikamliwes. ");
INSERT INTO myw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Palopit siyas mwasanin tayyaweids bisaps, bikatidavis gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“O sinap kalbaleb bo bivakaein, mapuna mo beigwey siwa̱youb wasigeis gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Kukin kalisiy bikaptules, ee... nakabiyokous tut waseg Yowbad mo bikatinabwes. ");
INSERT INTO myw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Gungamag igaw mo bikawes liva̱nen Yowbad nakaleiwag, biguyes vena babaw wadaban pwepway, bikatiliganes, mo beikous ven watinow. ");
INSERT INTO myw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Kweiboug palopit Daniyel nilivnek teitan nawotet igaw biyableb Yowbad navavag, youd singay kalbaleb waseg. E, igaw yakamiy bukukines towen Yowbad wanbunatum. (Bukuvinis livan towen kadiloka bukukwakins). E, igaw bukukines sinap towen, bukusesus Yudiy, kadiloka kusawls kuneis wa̱koy. ");
INSERT INTO myw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Magat bukuyeiwas wampwa̱siw, awoum kusiw vayuwein wambunatum wanuwan va̱gan bukukow muwliyoug, awoum. Nuwanaw kusawls. ");
INSERT INTO myw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","“Magat bukuwotet wa̱bag, awoum bukuyum bukukow amkweim. ");
INSERT INTO myw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Tut towen wanakougwaw singay moumouvit bilivatus siyas vinay kakuda̱poms, o siyas vinvanuns. ");
INSERT INTO myw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Kadiloka kunitougs waseg Yowbad va̱gan awoum bukusawls bulbweilim waseg, o awoum bukusawls Tapwa̱loul waseg. ");
INSERT INTO myw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Peinan tut singay moumouvit. Nag kweitan tut ivag mouvitan ma̱wana towen, kweiboug nag, igaw tut wanakoug nag. ");
INSERT INTO myw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Kukin Yowbad nag bigidem moumouvit towen, nag kal son mwamovan bises. Tage Yowbad bo bigidem moumouvit, pinamiy inagamag yakamiy. ");
INSERT INTO myw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kukin kal bilivan, ‘Mesay towen-an,’ o bilivan, ‘Mesay towen-one,’ awoum kusimounids waseg. ");
INSERT INTO myw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Peinan tayyaweids mwasanin bisaps, gamag bidokes Mesay tasiyas; o tayyaweids mwasanin bisaps, gamag mwasanin bidokes palopit tasiyas, bikatimlakays aniyes, mamagina naman mulin Yowbad, va̱gan kid bikatidavis gamag; idokes kid bikatidavis Yowbad nagamag. ");
INSERT INTO myw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Bo akatiboug nuwamiy sinap towen. ");
INSERT INTO myw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kukin gog gamag mwasinis bidibakeimiy, bilansa, ‘Mesay wanawoud nises,’ awoum bukun kukin; awoum. Kukin bilansa, ‘Nises bunatum wanuwan,’ awoum kusimounids. ");
INSERT INTO myw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Igaw Gimgilitoun yey ba̱yum baw, mamagina mititeilin kavikawn bisap wanuvid bimteil ee... bein wayavat, gamag babaw bikines. ");
INSERT INTO myw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Avanuy takanig nises, mansiyas bunibwan bikatuyouns bimeis. ");
INSERT INTO myw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Moumouvit anatut beikous, ka̱las mo bidadub, tibukon-vak bikanig mititeilin, siyas wutun walba̱lab bikalka̱louws, youd siyas wanakaew bo beigwey. ");
INSERT INTO myw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mo bukukines aniyag wanakaew yey Gimgilitoun. Ven babaw gimgilis biva̱lams, bikineigs Gimgilitoun yey, bo baw lov waseg, soug guntawtoun o yakawanag avakaein waseg. ");
INSERT INTO myw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","“Bwa̱gig biyik avakaein va̱gan guntaka̱yobs bineis bikatiyounis gungamag wanuvid, wa̱yals, wayavat, wabomat, bilisawes vena babaw wadaban pwepway, mo bimekeigs yey. ");
INSERT INTO myw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kabebay nises yaveinun waseg. Kadiloka kuliganes sinapun yaveinun. Bukukin biya̱sus yageivein kweivaw mo bukukwakins wuwal bisilamaw. ");
INSERT INTO myw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","“Ma̱wan magin bukukines youd tasiyas mo bukukwakins Gimgilitoun yey basap, mamagina wakoukwed nases. ");
INSERT INTO myw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Mounid adibakeimiy gamag yakamiy, igaw son mwamovamiy bukusesus, mo bukukines youd siyas babaw. ");
INSERT INTO myw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Liba̱lab son ven watinow bigulek beikous, tage agulivan nag beikous, nag. ");
INSERT INTO myw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ta-kal ikakin avei-yam o avei-tut, nag; min-liba̱lab na-ikakins; yey nag bakakin; misinaka Tamag ikakin. ");
INSERT INTO myw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ma̱wana tutan Now, ma̱wana tutag yey, Gimgilitoun yey. ");
INSERT INTO myw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“Peinan kweiboug anatut yevagam na-ipop ven, gamag ikamkwams, imwamoums, iveivays, Now mo itouw wa̱wag. ");
INSERT INTO myw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“Yam towen na-ikakins ee... kweis mo isap iyagages tasiyas. Ma̱wan magin Gimgilitoun yey ba̱yum bam, gamag nag bikakins avei-tut. ");
INSERT INTO myw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Tawaw asteiy biwwotets wa̱bag, teitan bakow, teitan bises. ");
INSERT INTO myw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","“Vinay asteiy bikanimimayes wit, na̱tan bakow, na̱tan bises. ");
INSERT INTO myw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kadiloka kumtakavateimiy, peinan nag kukwakins avei-tut miGuyaw yey mo bam. ");
INSERT INTO myw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Kadiloka kukwakins sinap towen. Magat tanuwagan bunatum bikakin asinavin boug waseg tavveinaw bisap, bo beikit bimtakavet nabunatum, mata ge tavveinaw ge im iven navavag. ");
INSERT INTO myw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","“Ma̱wan-vak yakamiy, kadiloka kwatunags, peinan Gimgilitoun yey ba̱yum, o yakamiy nag kukwakins tutag ba̱yum bam. ");
INSERT INTO myw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tamwey inagamag isek inawotet va̱gan tut babaw bivakamus tasiyas wanbunatum nisesus. Yam katanok katanok inawotet towen. Kavel bitoukum nawotet towen waseg? Adok towen ansinap bwein. ");
INSERT INTO myw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Igaw natovek beiyum beim, biban nagamag inawotet bwein, bikalin nuwan waseg mtowen; o nagamag towen mo bimwa̱saw. ");
INSERT INTO myw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Mounid mo bisek nagamag towen nawotet mamagina tanuwagan navavag babaw-wan. ");
INSERT INTO myw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","51","“Kukin gog nagamag ansinap kalbaleb, bilivan, ‘Guntovek bo iyouviy,’ mo bikawegweis won, biwaweiys siney, o beikams bimwamoums siney siyas tamwamoums mo bikabala̱weins, natovek gog igaw mo beim, tutan nag bikakin, bisap, bisibilut, mo bimop ansinap kalbaleb; bilev gamag towen binekes tasiyas tayyaweids, mo bivva̱lams, singay bigeg ninous. ");
INSERT INTO myw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tage Yowbad nakaleiwag mamagina guwa̱vin sinawatan, silamp ikawes, inounas binekes kid mtowen taveivay. ");
INSERT INTO myw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","“Na̱nim nag isinaps bwein; na̱nim na̱sinaps. ");
INSERT INTO myw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","“Tasiyas nag isinaps, ikokews silamp, tagon go nag. Tage sisiyas sam sitagon wabotol. ");
INSERT INTO myw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Igaw ikayamats, toge taveivay iyouviy; mites inanup tasiyas, mo imasis. ");
INSERT INTO myw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Watapwan boug, teitan iwak, ilana, ‘Taveivay bo neim; kumeis tanekes.’ ");
INSERT INTO myw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ikits tasiyas, bivakanotes silamp. ");
INSERT INTO myw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Tasiyas nag isinaps idibakes sisiyas, ilansa, ‘Tabta mitagon bukusekemas, ne? Malamp bo imta̱mats.’ ");
INSERT INTO myw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Iweis sisiyas, ilansa, ‘Adok nag ampwa̱vin yakamiy mouy yakamey. Kuneis wastow kugimwals.’ ");
INSERT INTO myw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Inounas tasiyas bigimwals, mo isap towen taveivay; tasiyas bo ikatunags ikous mo isiws sisiy towen taveivay, inasagal silma̱nin; koukwed mo ikatibagus. ");
INSERT INTO myw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wankuyeim sisiyas mo iyum imeis, itamanaws watoulan bwan, ilansa, ‘Maguyaw yak, kwaliyow koukwed pinem yakamey.’ ");
INSERT INTO myw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Iw mtowen, ilana, ‘Nag akakin yakamiy.’” ");
INSERT INTO myw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeisuw ilana, “Kadiloka kutoukums, kumtakavateimiy, peinan nag kukwakins avei-tut o avei-yam mo bam. ");
INSERT INTO myw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Peinan ma̱wana tamwey teitan binoun bilakwen kweitan ven, idawes natouwat asteitoun, imeis, isekes simoney va̱gan biwotets waseg. ");
INSERT INTO myw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Teitan gamag tawtoun, isek kweinim tawsan kina. Tayuwein natawtoun kalamwey avakaein, isek akweiy tawsan kina. Tatounun nag bivakaein natawtoun, isek katanok tawsan kina. Isekes ikous, mo inoun in kweitan ven. ");
INSERT INTO myw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Natovek bo inoun, towen gog tatawtoun ikow inamoney kweinim tawsan kina, igaw bikuney mo bikatimweis inamoney. E, inamoney ikatimweis kweinim tawsan kina, imlavag sinawatan tawsan kina. ");
INSERT INTO myw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","“Ma̱wan-vak tayuwein ikatimweis kweiy tawsan kina, imlavag kweivas tawsan kina. ");
INSERT INTO myw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Tatounun gog, ikow inamoney katanok tawsan kina, ikaviyeil pwepway, idibwen natovek inamoney. ");
INSERT INTO myw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tut kadiveiyov ikous, iyum sitovek im, idibakes tasiyas bimeis va̱gan bimeyes namoney bikin. ");
INSERT INTO myw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Mtowen nisek kweinim tawsan kina, ikow imey namoney, sinawatan tawsan, ilana, ‘Tamwey, kweinim tawsan nukusekeig towen, son kweinim tawsan aban, bo akatimweis.’ ");
INSERT INTO myw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Iw natovek, ilana, ‘Bwein! Guntouwat bwanabwein ya̱koum. Peinan bo kutoukum wotet kakit, mapuna basekeim avakaein. Kusiw kum, gunakabmwa̱saw waseg.’ ");
INSERT INTO myw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tayuwein nisek kweiy tawsan kina, ikow imey namoney, ilana, ‘Tamwey, kweiy tawsan nukusekeig towen, son kweiy tawsan aban, bo akatimweis.’ ");
INSERT INTO myw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Iw natovek, ilana, ‘Bwein! Guntouwat bwanabwein ya̱koum. Peinan bo kutoukum wotet kakit, mapuna basekeim avakaein. Kusiw kum, gunakabmwa̱saw waseg.’ ");
INSERT INTO myw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Tatounun nisek katanok tawsan kina, ikow imey namoney, ilana, ‘Tamwey, akakin amsinap keikay, anagin gamag siwotet kukokew ven babaw; mapun aweneim, akaviyeil pwepway, adibwen mumoney, bo avnas bwein; nises towena.’ ");
INSERT INTO myw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","“Iw natovek, idibek, ilana, ‘Singay tougwey, guntouwat kalbaleb ya̱koum. Kukwakin-wan agusinap keikay, anagin gamag siwotet akokew ven babaw; kadilok-wan bukusen gunmoney wanuwan benk, bikatimweis bibabaw; ga ba̱yum bam mo bakow siyas gunmoney babaw.’ ");
INSERT INTO myw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","“Natovek mo idibek natouwat teitan, ilana, ‘Kukow inamoney katanok tawsan kina, kusek mtowen tatawtoun, bikatimweis inamoney, bimlavag singay babaw, sinawatan katanok tawsan kina.’ Kukin kal navavag sam, igaw mo bikow bikatimweis, bibabaw. Kukin gog kal ta-ivag navavag, teitan mo bikow aveiyag nises; mounida beidev mtowen. ");
INSERT INTO myw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Sitovek mo ilana, ‘Kadiloka kukow guntouwat towen kalbaleb, kulev bein watoulan, dadub waseg. Tasiyas watoulan bivva̱lams-wan, singay bigeg ninous.’ ");
INSERT INTO myw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Igaw bam, Gimgilitoun yey, soug yakawanag, o sigwey min-liba̱lab asibabaw, mo basin a̱bag bwanabwein waseg. ");
INSERT INTO myw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","“Vena babaw gimgilis bikatuyouns bimeis wamatag, bakatukin. Mamagina tamtakavatein alen bikatukin, alen sip bineis palatan, alen gout bineis palatan. Mansiyas sip bineis wanaka̱tay; tage mansiyas gout bineis wankimaw. ");
INSERT INTO myw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","“Miguyaw yey bakatukin, gamag mwasanin wagunkimaw, mwasanin wagunka̱tay. Ikous mo badibakes tasiyas wagunka̱tay nisesus, balana, ‘Kumeis yakamiy, Tamag nisiwa̱youb wasigeis yakamiy, kweiboug nibun ven watinow mo ikatineg mikabmwa̱saw pinamiy yakamiy; e, kumeis kumwa̱saws. Peinan agumoun, kag nukusekeigs; agudak, soup nukusekeigs; agutowous nag mo nukulabeigs; nases sona mwadoyag, nukusekeigs agukweim; agukwatoun nukuvna̱seigs; wa̱deil nases, nukulakwaneigs.’ ");
INSERT INTO myw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Tadidumwals tasiyas mo bikatimapus aygag, bilansa, ‘Tamwey, asinavin kakineim soum amumoun kasekeim kam, o amdak kasekeim soup, o amtowous nag mo kalabeim, o sona mwadoyam kasekeim amkweim, o amkwatoun mo kavna̱seim, o wa̱deil nukuses mo kalakwaneim?’ ");
INSERT INTO myw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Miguyaw yey mo bakatimop ages, balana, ‘Mounid adibakeimiy, kweiboug nukuleb teitan bwadag takakit, ma̱wana yey bo kulabeig.’ ");
INSERT INTO myw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mo badibakes tasiyas wagunkimaw isesus, balana, ‘Kulisaweigs takalbalebs yakamiy, amisinap bo ikunakeimiy, kuneis kov towen nag beikous, Yowbad nikatineg silma̱nin Seitan siney siyas baloum. ");
INSERT INTO myw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","“‘Peinan agumoun, ta-kweitan kag kusekeigs; agudak, ta-kweitan soup kusekeigs; agtowous nag, ta-kulabeigs; sona mwadoyag, ta-kweitan kweim kusekeigs; akatoun, ta-kuvna̱seigs; ases wa̱deil, ta-kulakwaneigs. Takalbaleb yakamiy!’ ");
INSERT INTO myw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tasiyas bikatimapus aygag, bilansa, ‘Tamwey, asinavin kakineim amumoun, kakayus gog kan; o amdak, kakayus soup; o amtowous nag, o sona mwadoyam, o amkwatoun, o wa̱deil kuses, tage nag kalabeim?’ ");
INSERT INTO myw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mo bakatimop asilivan, balana, ‘Mounid adibakeimiy, kweiboug nag kulabes teitan bwadag takakit, ma̱wan yey nag kulabeigs.’ ");
INSERT INTO myw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Tasiyas asisinap kalbaleb bisiwas watoulan, asisinap kalbaleb mapun bilivatus tut nag beikous; tasiyas gog tadidumwals beisiws abmwamov waseg bisigagas.” ");
INSERT INTO myw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Iyakousis anilivan tasiyas, Yeisuw mo idibakes navamul, ilana, “Adok kukwakinsa akweiy yam mo Kaltuwon Sigeilin; teitan mo bisilkodeig, Gimgilitoun yey. Gamag mwasanin mo biyousigs bikatimateigs waklos.” ");
INSERT INTO myw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Misiya̱mun towen tasiyas tanuwgwes lun situwa̱vek sisiyas tammwayas katuyouns ineis tanuwgwes lun sitovek avakaein wanven, mtowen yagan Kayapas. ");
INSERT INTO myw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sivines kid biyousis Yeisuw bikatimates; illivans silma̱nin. ");
INSERT INTO myw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ilansa, “Kadiloka tasinaps beibwein; ama̱wan bitayousis. Awoum bitayousis sagal waseg; peinan gamag singay babaw; adok mwasanin bikayuses, igaw mo bikawpwanaws.” ");
INSERT INTO myw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeisuw nises Betaniy, Saymon wanbunatum, mtowen toulepel. ");
INSERT INTO myw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na̱tan vin inek Yeisuw, nabotol bwanabwein wanaman, tagon nises, tage maysan singay avakaein. Yeisuw igaw ikamkwam, isap mana̱wen, tagon towen iligubok kunun Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Navamul ikines, ikavikuns, ilansa, “Bo iyamkwen tagon bwanabwein. Kadiloka biyamiyis, maysan avakaein bikow, money towen bivgen tasiyas tasimavs wasigeis.” ");
INSERT INTO myw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","13","Yeisuw gog bo itilikwen asilivan, ikatimop, ilana, “Awoum kulivans, ivag geg anmwasin. Inawotet bwanabwein waseg yey. Tut babaw tasiyas tasimavs simiyas nukusesus; yey gog kweitan, igaw mo balisaweimiy. Bo iptum woug silma̱nin anatut bidibwanigs. Mounid adibakeimiy, ampalawen ven watinow igaw bikawes liva̱neig, o liva̱nen-vak mana̱wen vin bikawes binawes, gamag babaw biliganes, mo bininuways inawotet towen.” ");
INSERT INTO myw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Yeisuw navamul sinawatan teiy, teitan gog yagan Yudas Iskaliyot inekes tasiyas tanuwgwes lun situwa̱vek, ilana, “Kweivin maysan bukusekeigs mo bakamtel Yeisuw avanuy misikey-yay, mo bukuyousis?” Isenas money silib sinawatoun, mo itam. ");
INSERT INTO myw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wankuyeim Yudas inineiv amata-ked bwein waseg mo bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yam towen isilamaws anawik bikatunags silma̱nin Kaltuwon Sigeilin. Navamul Yeisuw inekes, ilansa, “Avanuy bakakatineg sagal towen va̱gan bukukwam?” Wik towen nag beikams bled son yist; bwaboum. ");
INSERT INTO myw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iw to Yeisuw, ilana, “Kunekes mtowen nises waven, kudibakes, kulansa, ‘Matovek ilivan, ilana: Tutag bo alivet, wambunatum baka̱kam Kaltuwon Sigeilin, sigwey gunavamul.’” ");
INSERT INTO myw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tasiyas iliganes, ikanawes aygan, inounas, ineis, ikatinages sagal towen. ");
INSERT INTO myw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kwayav mo isinis siney navamul tasiyas sinawatan teiy, beikams. ");
INSERT INTO myw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Igaw ikamkwams, ilivan, “Mounid adibakeimiy, teitan nises wasigeis yakamiy, igaw mo bisilkodeig.” ");
INSERT INTO myw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Singay igeg ninous, katanok katanok mo idibakes, ilansa, “Tamwey, kal bisilkodeim? Yey? o nag? kavel?” ");
INSERT INTO myw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ikatimop, ilana, “Mtowen soug kakokew kan wakabmavin, igaw mo bisilkodeig. ");
INSERT INTO myw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Gimgilitoun yey ba̱noy ban makadewen ked nilivnakes Bukitab waseg, tage taw towen tasilkodeig singay kalbaleb bilivet. Magat inan nag bikop taw towen bo bwein, tage bo ikop, mo singaya kalbaleb bilivet.” ");
INSERT INTO myw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tasilkodein Yeisuw yagan Yudas mo ikatigan, ilana, “Guntovek yak, mtowen kavel? Yey?” Iw to Yeisuw, ilana, “Ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Igaw ikamkwams, Yeisuw ikow bled, anilivan bwanabwein isek, mo ivgen, isekes inavamul wasigeis, ilana, “Kaeimiy towen woug, kukwams.” ");
INSERT INTO myw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Ikous, mo ikow kwa̱vig, ikalin nuwan Yowbad waseg, ikiv, isekes, ilana, “Tababaws yakamiy kumoums towen buya̱vig silma̱nin kaleiwag kweivaw; buya̱vig iwta̱wout biwid kid amisinap kalbaleb, simiyas gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“Adibakeimiy, nag vayuwein ba̱moum gleip sipinen ee... anatut kweivaw sipinen mo bitamoums Tamag wanakabkaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Asiwous ikanweles ikous, mo isaps ineis koy towen bigulen oliv nises. ");
INSERT INTO myw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ineis koy towen, Yeisuw idibakes, ilana, “Boug towen bukupiyaveigs amibabaw-wan yakamiy, liva̱nen nises Bukitab waseg, mamagina: ‘Ba̱weiy tamtakavatein mansiyas sip, mo bikatigayes alen.’ ");
INSERT INTO myw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Igaw ba̱kit vayuwein mo bamug ban Galiliy waseg; yakamiy wankuyeim, mo kuwekeigs Galiliy waseg.” ");
INSERT INTO myw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iw to Pita, ilana, “Magat babaw bipiyaveims, yey gog nag bapiyaveim.” ");
INSERT INTO myw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeisuw ilivan, “Adibakeim yak, boug towen waseg bukwaya̱neig sivatoun, mo beigel kolkolek.” ");
INSERT INTO myw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iw to Pita, ilana, “Kukin bikatimateims, soug yak bikatimateids aditeiy. Nag bakaya̱neim, nag.” Inavamul babaw asilivan bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Siney navamul mo ineis ven yagan Getsemaniy, idibakes, ilana, “Kusinis towen. Yey ban palatan anitoug Yowbad waseg.” ");
INSERT INTO myw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mo idawes tasiyas Pita siney Sebediy nitun asteiy, mo ivag asteivas, ineis isiwas; mo igeg nanon, won imouvit seikwan. ");
INSERT INTO myw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Idibakes, “Woug moumouvit ma̱wana dakul, kakita bakanig adok. Bweina kusesus towen kula̱lals, kulabeigs nitoug waseg.” ");
INSERT INTO myw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Inoun, nag in kadiveiyov, imasis kantukov, initoug, ilana, “Tamag, magat bukutam bo bapiyev kwa̱vig towen, singay yayan; tage ama̱wan ya̱koum nanoum, nanoug yey awoum.” ");
INSERT INTO myw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","41","Ikous, iyum inekes asteitoun, bo imasis. Idibek Pita, “Ta-bukula̱lals bukulabeigs tut kadiyakus waseg. Kutoukums, kula̱lals, kunnitougs; mata ge bukusiws abiyokon waseg. Bo iseiw nuwamiy wotet towen, tage tougwey yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sivyuwein in initoug, ilana, “Tamag, adok nag kadilok bukwayus kwa̱vig towen, bweina ba̱moum. Aveiyag wananoum bo bavag ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iyum inekes bo imasis, peinan bo inanup mites. ");
INSERT INTO myw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sivtounun ilisawes, initoug; anilivan ma̱wana nilivan mo initoug. ");
INSERT INTO myw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Ikous, iyum inekes navamul, idibakes, ilana, “Igaw kuyeiwas, kummasis. Bo deis! Datuts bo ikous. Bo isap tasilkodeig Gimgilitoun yey. Takalbalebs bo nimeis kid biyousigs yey. Kukits tanounas, tasilkodeig bo isap!” ");
INSERT INTO myw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeisuw igaw ilivan, isap inavamul teitan yagan Yudas, siney babaw gamag ikokews sipulut seiy, sinew seiy. Tanuwgwes lun situwa̱vek sisiyas tammwayas nikayabes nimeis. ");
INSERT INTO myw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Towen tasilakod bo nidibakes, “Kukin kal bakamuloul soug, towen kuyousis, mtowen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nuwanaw mo inek Yeisuw, ilivan, “Kalin nuwag guntovek yak,” mo imulouls son. ");
INSERT INTO myw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iw to Yeisuw, ilana, “Gwa, wawun nukum?” Ituts tasiyas, iwekes, iyousis Yeisuw, itawtouns waseg. ");
INSERT INTO myw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Son Yeisuw teitan igut napulut wakaban nises, iweiy natouwat tanuwgwes lun sitovek, ibob teigan. ");
INSERT INTO myw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","54","Iw to Yeisuw, ilana, “Kuyamen mupulut, bein wakaban. Tasiyas gog tawayins gamag pulut waseg, igaw bikanka̱nigs pulut waseg. Adok nag kukwakins gunanitoug waseg Tamag, nuwanaw mo beitam min-liba̱lab bilabeigs, singay babaw tawsans. Nag gog. Kukin nag biyousigs, ta-ma̱wan bikamat liva̱neig Bukitab nilivnek.” ");
INSERT INTO myw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","56","Misiya̱mun towen Yeisuw idibakes asibabaw, ilana, “Yam babaw nases Yowbad wanbunatum akatimlakes gamag, ta-kuyousigs. Nagein gog aveiyag wawun kukokews mipulut, minew, nukumeis kuyousigs mamagina tavveinaw yey? Tage youd towen ikamat peinan tasiyas palopit nilivnakes Bukitab waseg.” Navamul aspwa̱yat ilisawes Yeisuw; mo isawls. ");
INSERT INTO myw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iyousis Yeisuw ikous, inawes Kayapas wanbunatum; mtowen tanuwgwes lun sitovek avakaein. Inaven waseg nikatuyouns nimeis tammwayas sisiyas takatimlakeins kaleiwag. ");
INSERT INTO myw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mtowen gog Pita ikikikun wankuyeim ee... isap waven, isin waven siney tamwey towen natouwats, idoki aveiyag binuwakes. ");
INSERT INTO myw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tasiyas tanuwgwes lun situwa̱vek sisiyas takaleiwags babaw inineivs kalisiy biyaweids ya̱tal waseg va̱gan kid mo bikatimates Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Babaw iyaweids, Yeisuw silma̱nin, tage nag iba̱nes silawun ya̱tal, nag. Wankuyeim asteiy mo imeis, ilansa, “Taw towen ilivan, ‘Kadilokeig bagulek Yowbad nabunatum, yam kweitoun mo bawlulavaw bayakous.’” ");
INSERT INTO myw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Itamanaw tanuwgwes lun sitovek, ikatigan Yeisuw, ilana, “Aveiyag bukwatimop? Aveiyag amsinap towen, tasiyas nillivans?” ");
INSERT INTO myw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yeisuw gog isesuna ikika̱pay. Iwa̱ge tanuwgwes lun sitovek, ilana, “Tamwamov Yowbad iligen amlivan yak; kadiloka kulivan mounid. Tab ya̱koum Yowbad Natun, Mesay? o nag?” ");
INSERT INTO myw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeisuw idibek, ilana, “Ma̱wan amlivan. Vayuwein livan mo badibakeim: ‘Igaw bukukineigs Gimgilitoun yey, biseinig Yowbad wanaka̱tay, guntawtoun waseg; mo bukukineigs wa̱lov walba̱lab bawekeimiy.’” ");
INSERT INTO myw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Kayapas, kapasal nuwan, iksigeb anakweim, ilana, “Bo kuliganes anilivan towen kalbaleb. Nag ivag sivinads gamag biyateles; babaw ya̱kids nitaliganes anilivan kalbaleb. Ama̱wan bitanuwakes mtowen?” ");
INSERT INTO myw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Mo igusus Yeisuw magin, iwaweiys nimes waseg. Igawa iwaweiys, mwasanin ilansa, “Magat ya̱koum Kelis, bukulivan ma̱wana palopit ya̱koum, kwavteg yagan kal iweim!” ");
INSERT INTO myw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita igaw nises Kayapas wanven, wamatan nabunatum, tawtelein bunatum na̱tan inek, ilana, “Adok ya̱koum soum Yeisuw mukunoys Galiliy nukumeis, ne?” ");
INSERT INTO myw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ikayan mtowen, ilana, “Nag. Ta-akakin aveiyag nukulivan.” Babaw gamag ikatiliganes anilivan towen. ");
INSERT INTO myw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Isineikik in wadunan ked waseg, nayuwein vin ikin, idibakes siney, ilana, “Taw towen veiyon gum-Nasalet towen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ikayan vayuwein, ilana, “Nag bakakin gamag towen. Tamad!” ");
INSERT INTO myw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Igaw kakit, tasiyas nitomos wadadan ven iwekes Pita, ilansa, “Adok mounid ya̱koum veiyon gum-Galiliy ya̱koum, ne? Peinan aygam ma̱wana aga-Galiliy.” ");
INSERT INTO myw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ikavikun Pita, anilivan kalbaleb igegayous, itabudabod, ilana, “Nag; ta-bakakin taw towen. Tamad!” Mo igel kolkolek. ");
INSERT INTO myw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita inuway Yeisuw anilivan, “Nuwanaw bukupiyaveig sivatoun, mo beigel kolkolek.” Inuway livan towen, isunap, inoun in tana̱ban, iva̱lam, singay igeg nanon. ");
INSERT INTO myw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iyam-nen ga̱boug, illivans tasiyas tanuwgwes lun situwa̱vek sisiyas tammwayas, idokes kadiloka beiweiys Yeisuw, beimat. ");
INSERT INTO myw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Naman iyawanis vatul waseg, itokes, inawes Paylat waseg, guma-Lom towen sigabman avakaein. ");
INSERT INTO myw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Yudas, mtowen tasilkodein Yeisuw, ikakina beiweiys Yeisuw, ikanavin nanon, iyamen maysan towen, money silib sinawatoun, bisekes kid tanuwgwes lun situwa̱vek sisiyas tammwayas, ilana, “Agusinap kalbaleb; bo asilkod gamag towen bwanabwein.” Iweis tasiyas, ilansa, “Ya̱koum muwotet; yakamey nag.” ");
INSERT INTO myw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas ipiyev money towen, ilev in Yowbad wanbunatum wanuwan, inoun in, ikow vatul, iyawen kayon mo ikayagweg, imat. ");
INSERT INTO myw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tasiyas gog tanuwgwes lun situwa̱vek ikawes money towen, ilansa, “Towen maysan gamag buya̱vin, awoum binek Yowbad namuloul. Ama̱wan bitavkakes money towen?” ");
INSERT INTO myw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mapuna iyamiyises tawtelein loutan napwepway, va̱gan kid bidibwanis takanigs asibwabwal igaw bikanka̱nigs ven towen waseg. ");
INSERT INTO myw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Peinan money towen maysan gamag buya̱vin, mapuna tadokes pwepway towen yagan “Gamag buya̱vin pwapwayein.” Tut towen waseg pwepway yagan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Iva̱ges ma̱wan, mo ikamat liva̱nen palopit towen Yelemay, peinan kweiboug ilivnek mamagina: “Ikawes money silib sinawatoun, maysan mtowen min-Yisleil bo ikaliwages, mo iyamiyises tawtelein loutan napwepway. DaGuyaws bo ikaliwageig ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Inawes Yeisuw gabman waseg, itow wamatan. Mtowen gabman mo ikatigan, ilana, “Tabta ya̱koum min-Yudiy siking ya̱koum?” Iw to Yeisuw ilana, “Ma̱wan amlivan.” ");
INSERT INTO myw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tanuwgwes lun situwa̱veks sisiyas tammwayas mo iyateles Yeisuw; towen gog nag ikatimop ikka̱pay-wan. ");
INSERT INTO myw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iw to Paylat ilana, “Tab kwatiligen liva̱neim babaw illivans?” ");
INSERT INTO myw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Towen gog nag kweitan livan iyamen; mapuna gabman towen bo isunasun nanon. ");
INSERT INTO myw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bweilim katanok katanok sagal towen waseg, gabman ansinap bilik tasiwun deil, am-towen sivines tababaw gamag. E, bilik mo bein wamnat. ");
INSERT INTO myw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Teitan wa̱deil nises, butun avakaein peinan ansinap kalbaleb, yagan Yeisuw Bala̱bas. ");
INSERT INTO myw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Katikunouks gog gamag babaw, Paylat ikatugan, ilana, “Kal sivinamiy? Kwavtagis yagan mo balik bein wamnat. Tabta sivinamiy Yeisuw Bala̱bas? o adok sivinamiy Yeisuw, mtowen idokes Kelis? Takaleiwag yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ikakin geg iyateles Yeisuw peinan ikamliwes. ");
INSERT INTO myw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tage mtowen Paylat issin wakaban va̱gan bikaleiwag, Paylat nakwav mo ikayeb natouwat inek, isek aygan nakwav mamagina, “Awoum kuvag aveiyag taw towen waseg. Gamag towen bwanabwein. Boug akamikon towen silma̱nin; mapuna singay igeg nanoug.” ");
INSERT INTO myw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bo itatays ninous gamag babaw, tasiyas tanuwgwes lun situwa̱veks sisiyas tammwayas; ilansa, “Kwavtagis Bala̱bas yagan; Yeisuw gog beimat.” ");
INSERT INTO myw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Vayuwein gabman towen ikatugan; ilana, “Asteiy wa̱deil nisesus. Am-towen sivinamiy balik beiw wamnat?” Ilansa, “Bala̱bas.” ");
INSERT INTO myw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Tage aveiyag bavag waseg Yeisuw? Mtowen idokes Kelis.” Ilansa, “Kwatimet waklos.” ");
INSERT INTO myw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iw to Paylat ilana, “Aveiyag wawun? Nag ivag ansinap kalbaleb.” Iweis tasiyas, iwkuwaks, ilansa, “Kwatimet waklos!” ");
INSERT INTO myw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paylat go ikakin ta-ma̱wan binuwek, peinan kakita bisilamaws kawpwanaw; mapuna idow natouwat, ilana, “Soup kumey, bawid namag.” Imey, iwid naman wamtes gamag babaw, ilana, “Yey nag ba̱weiy gamag towen bwanabwein; e, takaleiwags yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iweis tasiyas, ilansa, “Yakamey bakakaleiwag, baka̱weiy; mawotet towen mapun bakalivet simayas nitimayas.” ");
INSERT INTO myw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Paylat mo ilik Bala̱bas, inekes tasiyas. Ilivan gog Yeisuw beiweiys vatul waseg, bisekes asibabaw bikatimates waklos. ");
INSERT INTO myw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","29","Gabman nagamag tasiyas takannaviys itokes Yeisuw inawes wasibunatum bunavakaein. Takannaviys asibabaw ikatuyouns nimeis, inibwis Yeisuw anakweim, ivaskoumis anakweim avakaein bwabwel. Ikous, mo ikawes vatul kulikoul mamagina doudiw, ikwanis isenas wakunun, magina anapay; nakaytuk isekes wanaka̱tay; mo ikululs wamatan, ilansa, “Kalin nuwem ya̱koum, min-Yudiys siguyaw ya̱koum!” Isiba̱wes igegayous. ");
INSERT INTO myw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ikous, mo igusus won towen, ikawes nakaytuk iways wakunun. ");
INSERT INTO myw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Isiba̱wes ikous, mo inibwis maynawen kweim bwabwel, ivaskomis anakweim tatonen, itokes, inawes beiweiys waklos. ");
INSERT INTO myw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Isekes Yeisuw anklos kaytan beikew, inounas. Wa̱ked mo ilivatus gum-Saylin yagan Saymon, ilansa, “Kukow anklos taw towen.” ");
INSERT INTO myw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E, Saymon ikokew Yeisuw anklos, inounas ineis koy yagan Golgot. (Takativin livan bein aga-Muyuw ‘Takanig busabwesan.’) ");
INSERT INTO myw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bo isekes Yeisuw wayn son a̱lun beimoum, va̱gan mamayuy biyenom; ikamkwen, ipiyev. ");
INSERT INTO myw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pwapwat ikatikavates wanaman o wakaken; ikayagweg waklos. Takanaviys tasiyas iyakousis wotet towen, mo ikaliwages anakweim, kalisiy bikawes, mamagina makava ilaves kweitan youd silma̱nin bikines kalisiy bikawes asikweim tatanok tatanok tasiyas. ");
INSERT INTO myw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ikous, mo isinis, imtakavates. ");
INSERT INTO myw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Anklos wakunuwatan ileles nakalbaleb mamagina, “Mtowen Yeisuw, min-Yudiy siGuyaw.” ");
INSERT INTO myw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Siney tavveinaws asteiy iweiys waklos, teitan wanaka̱tay, tayuwein wankimaw. ");
INSERT INTO myw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Tasiyas gog inounas makadewen ked isiba̱wes, asilivan kalbaleb, ilansa, “Ya̱koum kudoki bukugulek Yowbad nabunatum, bukuwlulavaw gog yam kweitoun. Magat Yowbad Natun yak, kubus kum, kuymoveim.” ");
INSERT INTO myw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","43","Ma̱wan-vak tanuwgwes lun situwa̱vek, sisiyas takatimkakeins kaleiwag, sisiyas tammwayas iyages Yeisuw, ivtokes livan, ilansa, “Bo ikatinabwes gamag mwasanin, nag kadilok bikatinob tatonen.” E, ilansa, “Mtowen kid Yisleil guyawun, kadiloka beibus waklos beim, mo bitaliganes anilivan. Peinan anilivan, ‘Asimounid Tamag Yowbad waseg; yey Yowbad Natun yey.’ Magat Yowbad sivinan gamag towen, kadiloka beim bikatinob.” ");
INSERT INTO myw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma̱wan-vak tavveinaws tasiyas asteiy nikayagwegs wasklos, iyages Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ya̱nay idadub ven babaw ee... ka̱las itageg mo ikamnat vayuwein. ");
INSERT INTO myw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Igaw dadub ven, Yeisuw mo iwak, aygan avakaein, ilana, “Eli, Eli. Lamasabaktaniy.” (Takatavini go bein aga-Muyuw waseg: ‘Guna Yowbad! GunaYowbad! Aveiyag wawun nukulisaweig?’) ");
INSERT INTO myw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gamag mwasanin nitatos wadadan iliganes, idokes Yeisuw ididow kid Ilaytiy. ");
INSERT INTO myw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mapun teitan isawl in, ikow yotout isen wayn yayan wanuwan, ika̱lawt yotout, ibes wamatan kayal iyasel, isek Yeisuw, imoum. ");
INSERT INTO myw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mwasinis gog ilivans, “Ga ises. Adok Ilaytiy beim bikatinob. Ga takines.” ");
INSERT INTO myw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Vayuwein Yeisuw mo iwak, aygan avakaein, kululuwan ilisow, bo ikanig. ");
INSERT INTO myw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","53","Maynatan kweim nisilbwed palakakit, Yowbad wanbunatum, tut towen waseg mo iksigeb maynawen kweim; isilamaw wanakaew, iksigeb in watinow, ivag mwayney. Nik ivag, dakul itavis, alawag ikaliyowes, tadidumwals mwasinis nimmasis wakalugwes, tutan Yeisuw ikit vayuwein mo ikits tasiyas, inounas ineis Yelusalem, gamag babaw ikines. ");
INSERT INTO myw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Takalikay towen siney tasiyas takannaviys imtakavates Yeisuw, ikines nik, ikines youd siyas nikamats; aspwa̱yat, ilansa, “Mounid Yowbad natun.” ");
INSERT INTO myw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Vinay mwasinis itowas tanbes. Na̱tan vinen-Magdal yagan Meliy; nayuwein valeyin, mana̱wen nitun tasiyas Yemes son Yosep; natounun Sebediy nakwav, ivag nitsiyas tawaw asteiy; sisiyas vinay mwasanin. Tasiyas kweiboug sisiy Yeisuw meinoy Galiliy nimeis, o yam babaw imtakavates. E, tasiyas itowas tanbes ikakins. ");
INSERT INTO myw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Yeisuw inavamul guyaw teitan yagan Yosep. Inaven Alimatiy. Yam towen kwayav waseg inek Paylat, initoug kaleivin Yeisuw bidibwen. Paylat itam. ");
INSERT INTO myw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Yosep ikow kaleivin Yeisuw, isumweil kweim pwapwa̱kaw gimagim, isen wakalawag. Inakalawag takunumwan kweitan bo itateiys wanuwan dakul, bo imlavag Yosep alawagan tatonen. Isen kaleivin Yeisuw wanuwan, iyatipin dakul avakaein, ikatibwed wadon leg, mo inoun. ");
INSERT INTO myw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vinay asteiy isiwas tanaban isinis ikikines, vinen-Magdal yagan Meliy son valeyin. ");
INSERT INTO myw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Yam towen ikatunags silma̱nin sagal. Iyam-nen mo sagal; tasiyas tanuwgwes lun situwa̱vek sisiyas tasiyas Palisiy mo ikatuyouns inekes Paylat, ilansa, “Tamwey, kanuw anilivan tayyaweid towen, igaw mwamov, ilana, ‘Yam kweitoun mo ba̱kit vayuwein.’ ");
INSERT INTO myw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Kadiloka kukwaleiwag gamag mwasanin bimtakavates alawagan kweitoun yam. Mata ge navamul bineis ivenos kaleivin, mo bidibakes gamag, bilansa, ‘Bo ikit vayuwein.’ Singay mo bikatimweisis yaweid, bikatidavis gamag babaw.” ");
INSERT INTO myw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Iw to Paylat, ilana, “Takaymateins alawag nisesus wasigeis yakamiy. Kuneis kuwteles ma̱wan beibwein.” ");
INSERT INTO myw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ineis tasiyas; youd mamagina kaybas ikawes, ipakus wawadon leg; takannaviys isekes siwotet imtakavates alawag towen. ");
INSERT INTO myw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yam tapwa̱loul-nen ikous, kadiyakusa beiyam kweivaw wik Sa̱bat waseg, vinen-Magdal yagan Meliy son valeyin, asteiy ineis ilakwanes alawag. ");
INSERT INTO myw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nik ivag avakaein. Yowbad nataka̱yob ibus walba̱lab im, iyatipin dakul, isen wadadan alawag, isin wakunuwatan. ");
INSERT INTO myw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","4","Magin immteil ma̱wana kavikawn, anakweim singaya pwapwa̱kaw. Aspwa̱yat takaymateins alawag, itatata wous, ikabalamats imasis. ");
INSERT INTO myw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","7","Toge anelos idibakes vinay tasiyas, ilana, “Awoum beivag amipwa̱yat. Akakina kunineivs Yeisuw, kudokes kid takanig. Nag. Mtowen bo nein. Bo ikit ma̱wana nilivnek. Kumeis, kukines nakabmasis makawan. Kunuwanaws, kuyum kuneis, kudibakes navamuls, kulansa, ‘Bo ikit kanig waseg.’ Mtowen bo bimgwayeimiy wa-Galiliy, yakamiy wankuyeim kuneis, mo bukunekes. Bo kuliganes agulivan?” ");
INSERT INTO myw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mapun ilisawes alawag, isawls, iyow nuwes, bogo imwa̱saws; isisawls kid bidibakes navamul. ");
INSERT INTO myw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Isisawls ee... Yeisuw im ilivatus, ilana, “Kalin nuwag.” Iweis tasiyas, iyousis kaken Yeisuw, magina bitapwa̱louls waseg. ");
INSERT INTO myw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Itapwa̱louls, Yeisuw mo idibakes, ilana, “Awoum beivag amipwa̱yat. Kunounas, kunekes budag, kukines bineis Galiliy, mo bikineigs.” ");
INSERT INTO myw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Inounas tasiyas, tamtakavateins alawag mwasinis mo ineis ven towen Yelusalem, inekes tasiyas tanuwgwes lun situwa̱vek, youda babaw ikamteles ikous. ");
INSERT INTO myw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Katuyouns gog asibabaw sisiyas tammwayas, illivans ikous, mo isekes simoney avakaein takannaviy tasiyas, bital kid mites, ilansa, “Igaw kalisiy bikatiga̱neimiy, kuyaweids, kulivans, ‘Navamul bo imeis boug waseg, ivenos takanig towen; igaw kammasis yakamey.’ ");
INSERT INTO myw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Kukin gog mitovek avakaein biligen, deisa bakalivan simey towen, bakasowm amisinap.” ");
INSERT INTO myw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Itams tasiyas, ikawes maysan yaweid towen. Asilivan bo ma̱wan; min-Yudiy mo iliganes. Igaw nagein tut towen min-Yudiy asilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Navamul sinawatan tatanok inounas ineis Galiliy, ikatulags koy towen Yeisuw nilivnek. ");
INSERT INTO myw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ikatulags koy towen, ikines Yeisuw, ikululs wamatan; tage mwasanin nag isimounids bwein, ivag ninous akweiy. ");
INSERT INTO myw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","20","Iw to Yeisuw, ilana, “Tamag bo isekeig gunakaleiwag babaw, walba̱lab, watinow. Kuneis kumulis ven babaw gimgilis, kwatimlakes gunaked, kubapta̱yses Tamag Yowbad yagan waseg, Natun yey yagag waseg, o Kululuwan Towen Bwanabwein yagan waseg; kwatimlakes bivna̱ses kid agulivan towen nasekeimiy. Peinan yam babaw sigwey yakamiy bitasesus ee... igaw mo beikous ven watinow.” ");
INSERT INTO myw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Livan bwanabwein nakabsilamaw towen; liva̱nen Yeisuw Kelis, mtowen Yowbad natun. ");
INSERT INTO myw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Liva̱nen Yon nises wanuwan Bukitab, Yowbad anilivan palopit towen Isaya nilel mamagina: “Kukines guntaka̱yob bakayeb wamatam, Ikidumwal muked. ");
INSERT INTO myw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tawkuwak wanawoud, ilana, ‘DaGuyaws inaked kuva̱ges beibwein; Kukidumwa̱lus va̱gan binoun.’” ");
INSERT INTO myw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yon igeiguy, makava nawoud waseg, ilana, “Kulavewas amisinap kalbaleb, babapta̱yseimiy va̱gan Yowbad biwidimiy bukukwamnats.” Igeiguy ma̱wan mo ibapta̱yses gamags. ");
INSERT INTO myw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gamag babaw inekes Yon wanawoud, siven kweitan kweitan wawnuwan ven Yudiy sisiyas min-Yelusalem babaw, iliganes Yon nageiguy, mo ikamteles asisinap kalbaleb, ipiyaves, mo ibapta̱yses lay Yoldan wanuwan. ");
INSERT INTO myw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yon nag ivag anakweim bwein. Tage wunuwunun kamel ivkek anakweim, isikam. Kaleivin man ivkek anawat. Kan ikamkwam kulipaw son kitoul. ");
INSERT INTO myw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Yon igeiguy, ilivan ma̱wan, ilana, “Yey nag tatawtoun, nag. Tatawtoun wankuyeim beim. Nag kadilokeig bakulul bakablev inasandol. Deisa babapta̱yseimiy wayevagam, towen gog mo bibapta̱yseimiy Yowbad Kululuwan Bwanabwein waseg.” ");
INSERT INTO myw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Misumkwey towen, Yeisuw meinoy neim Nasalet wawnuwan ven Galiliy, iwek Yon, mo ibaptays Yeisuw, lay Yoldan waseg. ");
INSERT INTO myw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ibaptays ikous, iga̱lag, mo ikin liba̱lab bo itavis, Kululuwan ibus im, iton wakunuwatan, ankakin ma̱wana bwabun italbelub im watinow. ");
INSERT INTO myw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aygan teitan walba̱lab ilivan, ilana, “Ya̱koum natug bwanabwein yak. Singaya ibwein nanoug waseg ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Ikous, kululuwan Yowbad mo ikayeb Yeisuw in wanawoud, isiw nawoud makaw waseg, sinawavas yam Seitan iyyakwen. Nawoud towen bulawud man nisesus, tage min-liba̱lab inekes Yeisuw imtakavates. ");
INSERT INTO myw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Wankuyeim mo iyousis Yon inawes wa̱deil, Yeisuw mo iyum im waGaliliy, Yowbad liva̱nen bwanabwein waseg igeiguy mamagin, ilana. “Yowbad nakaleiwag bo bisap tut towen waseg. Kadiloka kulavewas amisinap kalbaleb, kusimounids livan bwanabwein waseg.” ");
INSERT INTO myw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeisuw inoun in ivvayal wadadan yevagam avakaein, yagan Galiliy, ikin Saymon son bwadan Andiluw iplapouls, peinan siwotet poul-wan. ");
INSERT INTO myw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeisuw idibakes, ilana, “Kumeis kwabkunigs yey, mo basekeimiy miwotet kweitan, va̱gan bukukwanes gamags.” ");
INSERT INTO myw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iliganas tasiyas; mo ilavewas siwot, ibukunis gog Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Inounas nag kadiveiyov, ikines Sebediy nitun, Yemes son bwadan sisiyas tasiyas nawnataws wanuwan siwag iymiyeims wot. ");
INSERT INTO myw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yeisuw ikines, mo idawes tasiyas asteiy, ilisawes gog times Sebediy wa̱wag siney natouwats, mo ibukunis Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inounas ineis Kapaneyum. Sabat waseg isiw in wabuntuman tapwa̱loul yagan sinagog, ikatimlakay. ");
INSERT INTO myw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iliganes nakatimlakay, isom ninous, peinan ma̱wana takaleiwag mounid, nag ma̱wan tasiyas takatimlakeins kaleiwag. ");
INSERT INTO myw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Sinagog wanuwan, takayyeiluw teitan nises, ikin Yeisuw, iwak; tasiyas yeiluw ilansa, “Gum-Nasalet ya̱koum Yeisuw, awoum kuyagagem. Kulisawem kunoun. Akakina yak Yowbad natun ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tage Yeisuw idibek, ilana, “Kukwa̱pay, kukilev gamag towen.” ");
INSERT INTO myw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yeiluw iligen, mo iweiy gamag towen kabalamat, aygan avakaein iwak, ikilev, mo inoun. ");
INSERT INTO myw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asibabaw ikines, isom ninous, illivans sisiyas wasigeis, ilansa, “Aw-kaleiwag towen? Adok kweivaw sinap, tawtoun. Idibek yeiluw mo ikanow aygan.” ");
INSERT INTO myw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Butun towen nuwanaw in vena babaw Galiliy waseg. ");
INSERT INTO myw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Ilisawes sinagog towen siney Yemes, Yon; sisiyas Saymon, Andiluw, mo isiws wasibunatum tasiyas; togo yawan Saymon ikatoun nimmasis, won muyamuy; idibakes Yeisuw ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeisuw iligen, inek mana̱wen vin, iyous naman, itamnow; bo ibwein, ivag kaeis ikams. ");
INSERT INTO myw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka̱las iseilil kwayav waseg, mo imeyes takatouns babaw, sisiyas tasiyas baloum neiweiys. ");
INSERT INTO myw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ven to gimgilis katuyouns babaw nimeis, itomos wawkwedan bunatum. ");
INSERT INTO myw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tage Yeisuw mo ivag ibweins askatoun kweitan kweitan, o baloum ikayabes isawls. Tasiyas baloum iwtusis Yeisuw, togo nag itam va̱gan bikamteles. ");
INSERT INTO myw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Iwotet ikous, imasis, ikous, mo ikit kakita beiyam, tage igaw dadub, isap, inoun in wanawoud, ikulul, initoug waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Saymon siney nagamag ikikunis, iba̱nes Yeisuw, ilansa, “Gamag babaw inineveims ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iw to Yeisuw, ilana, “Kumeis, tata̱vins vena babaw, bageiguy. Bo nam wotet towen silma̱nin.” ");
INSERT INTO myw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mapuna inounas, igeiguy sinagog katanok katanok waseg, ven Galiliy wawnuwan; o siyas baloum ikkayabes isisawls. ");
INSERT INTO myw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Toulepel teitan inek Yeisuw, ikulul wamatan, igilagel, ilana, “Tabta sivinam bukuva̱geig ba̱bwein?” ");
INSERT INTO myw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeisuw igeg nanon, iyasel naman, ikabkwen won, ilana, “Sivinag bukubwein.” ");
INSERT INTO myw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ilivan ikous mo ilatimatet won, kaleivin bo ibwein. ");
INSERT INTO myw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yeisuw ikayeb gamag towen, anilivan tawtoun waseg ilivan, ilana, “Awoum kudibek teitan gamag liva̱neig; awoum. Kukwa̱pay-wan, kunoun kun Yowbad wanbunatum bunavakaein, tanuwagan lun bikineim, muvavag kusek, ma̱wan Moses nakaleiwag kweiboug, vagan gamag bikakins, bilansa, ‘O, bo ibwein.’” ");
INSERT INTO myw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Toge nag iligen, isap, illivan liva̱nen Yeisuw nawotet towen, iliganes gamag babaw. Mapuna Yeisuw nag kadilok binoun wamnat o binoun bein waven, tage isiwana wanawoud, vena babaw gimgilis mo ininekes. ");
INSERT INTO myw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mwasanin yam ikous iyum vayuwein in Kapaneyum, gamag babaw mo iliganes Yeisuw wabunatum nises. ");
INSERT INTO myw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iliganes bulagan Yeisuw nises wanuwan bunatum, mo ikatuyouns gamag singaya babaw, ikaven koukwed. Ta-ma̱wan gamag binoun. Tage gamag siyas babaw, silma̱nin Yeisuw anilivan beinegs, mo isekes anilivan bwanabwein. ");
INSERT INTO myw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mo imeyes takatoun teitan nimmasis wakaban. Ta-ma̱wan binoun. Mapuna asteivas gamag idagis takatoun in wakaban mo ikawes. ");
INSERT INTO myw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sivines kid Yeisuw waseg binawes. Ta-ma̱wan, peinan gamag singay babaw. Mapuna imwens wakunuwatan bunatum, itaboulis tapwan bunatum wakunuwatan Yeisuw, ikaygwagwes takatoun towen sona a̱ban nimmasis, italaves in iton wamatan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeisuw ikin, ikakina tasiyas inmises takatoun bivag beibwein, mapuna idibek takatoun towen, ilana, “Gwade, bo awid amsinap kalbaleb, ikous.” ");
INSERT INTO myw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Tage takatimlakeins kaleiwag mwasanin nisinis towen, ikatilutegs anilivan, ininuways, ilansa, “Takalbaleb towen, anilivan mamagina iyeg Yowbad. Yowbad anmwa̱net ikadilok biwid gamag ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Yeisuw wananon ikakina sikanuway tasiyas, idibakes, ilana, “Aveiyag wawun mikanuway ma̱wan? Bweina balivan balana, ‘Bawid amsinap kalbaleb, beikous,’ o bweina balivan-vak balana, ‘Kutamanaw, kukow a̱bam, kunoun.’ ");
INSERT INTO myw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","“Wotet akweiy gagab waseg yey. Kadiloka bukukwakins Gimgilitoun yey, o gunakaleiwag nises ven watinow va̱gan bawid gamag asisinap kalbaleb, mapuna adibakeim takatoun yak, ‘Kutamanaw, kukow a̱bam, kunoun kun wamven.’” ");
INSERT INTO myw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iligen takatoun towen, mo itamanaw wamtes tasiyas, ikow a̱ban mo inoun in. Bo isom ninous tasiyas, iyakawanes Yowbad, ilansa, “Kweitana sinap towen. Kweiboug nag takines ma̱wan, nageina mo takines.” ");
INSERT INTO myw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Vayuwein Yeisuw mo inoun, ivayal wadadan yevagam avakaein; gamag babaw ikatuyouns inekes, mo ikatimlakes sinap. ");
INSERT INTO myw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ikous, inoun in, ikin Alpiyow natun yagan Livay, isin wakaban ikokew gamag sita̱kis; Yeisuw idibek, ilana, “Kwabkunig.” Iligen, mo itamanaw, ibwa̱kun waseg. ");
INSERT INTO myw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wankuyeim isinis beikams Livay wanbunatum, siney navamul sisiyas takalbalebs tasiyas takaweins ta̱kis mwasanin, sisiyas takalbalebs mwasanin. Gamag tasiyas babaw bo ibukunis Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tasiyas gog takatimlakeins Palisiy sikaleiwag, ikines Yeisuw nikammutans siney takalbalebs tasiyas takaweins ta̱kis sisiyas takalbalebs mwasanin, mapuna idibakes Yeisuw navamul, ilansa, “Aveiyag wawun ikammutans siney tasiyas takaweins ta̱kis sisiyas takalbalebs mwasanin? Bo igak!” ");
INSERT INTO myw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeisuw gog iligen asilivan, idibakes, ilana, “Tasiyas tatawtouns nag sivines doket; misinaka tasiyas takatouns. Yey nag am badawes tasiyas toubweins silma̱nin Yowbad nakaleiwag, nag. Yey nam silma̱nin takalbalebs.” ");
INSERT INTO myw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ipsa̱pos tasiyas Yon navamul; Palisiy sivamul-vak ipsa̱pos. Mapuna gamag mwasanin inekes Yeisuw, ilansa, “Aveiyag wawun Yon navamul ipsa̱pos, o tasiyas Palisiy sivamul ipsa̱pos, muvamul gog ya̱koum nag.” ");
INSERT INTO myw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iw to Yeisuw, ilana “Taveivay inasagal waseg taliven nag beipos, peinan taveivay towen sisiy nisesus. Singaya imwa̱saws; ta-ma̱wan beipos. ");
INSERT INTO myw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","“Tut gog wankuyeim taveivay bikanig, mo bigeg ninous, beipos yam towen waseg. Taveivay towen mamagina yey. ");
INSERT INTO myw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Awoum bitakow bwal kweivaw, bitabweil kweim kweiboug. Awoum. Nag kadilok; igaw bitawtoun bwal bikididul kweim kweiboug, bitadud avakaein. ");
INSERT INTO myw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ma̱wan-vak nag ikadilok kunasoup kweiboug bitavgog wayn kweivaw waseg; igaw beilol wayn kweivaw bikatuv kunasoup biyageg; tage wayn biligibaw mo biyamkwen. Tage bitavgwagwes kweivaw kunasoup waseg kweivaw wayn.” ");
INSERT INTO myw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wankuyeim, yam Sa̱bat waseg, ikanapels wa̱bag, siney nava̱mul. Inounas, navamul ilapes anagin wit, beikams. ");
INSERT INTO myw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tasiyas gog Palisiy ikines, idibakes Yeisuw, ilansa, “Kukines muvamul isiplaves Sa̱bat kaleiwag-nen.” ");
INSERT INTO myw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Iw to Yeisuw, ilana, “Adok liva̱nen Deibid, wa̱buk bo kuvinis, tage ninoumiy nag ikamnat. Peinan Deibid siney nagamag asimoun, isiw in wanuwan Yowbad nabunatum, ikow bled towen nisenas silma̱nin Yowbad, ikams siney nagamag. Nag kadilokes beikams bled towen; bwaboum. Misinaka tanuwgwes lun beikams; tage tanuwgwes lun sitovek Ebayatal itam, peinan singaya asimoun, isekes Deibid siney nagamag, ikams.” ");
INSERT INTO myw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Wankuyeim Yeisuw idibakes, ilana, “Sa̱bat pines gamags, nag gamag peinan Sa̱bat, nag. Kadiloka bukukwakins Gimgilitoun yey tanuwagan Sa̱bat yey.” ");
INSERT INTO myw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Vayuwein Yeisuw inoun in wasinagog, taw teitan nises, naman ipam. ");
INSERT INTO myw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tasiyas gog nikamliwes Yeisuw ikakins, idokes kid bivag taw towen beibwein mo biyateles, peinan iwotet Sa̱bat waseg. ");
INSERT INTO myw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeisuw gog idibek toupam towen, ilana, “Kum, kutom, kutamanaw wamtes gamags.” ");
INSERT INTO myw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Im, itom, itamanaw wamtes, Yeisuw idibakes, ilana, “Tab kadilok Sa̱bat waseg bitalabes gamags o adok bitayagages gamags? Bitayamoves gamags o adok bitakatimates?” Tasiyas gog isesusa ikka̱pays. ");
INSERT INTO myw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bo igeg nanon peinan tayakeikays tasiyas. Kapasal nuwan, ikikines ikous, mo idibek toupam towen, ilana, “Kuyasel namam.” Iyasel, bo ibwein. ");
INSERT INTO myw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tasiyas Palisiy ikines, mo isaps, illivans sisiyas gamag tasiyas sivines Elod nakaleiwag; amata ked waseg mo beiweiys Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Wankuyeim Yeisuw siney navamul inounas bineis kid wayvagam; singay babaw gamag ikabkunis, min-Galiliy, min-Yudiy, min-Yelusalem, min-Idumiy, sisiyas tasiyas misikes Yoldan wanpalatan o walasin ven wunsiyas Ta̱yil son Sidon, singay babaw gamag niliganes butun nawotet Yeisuw, mo inekes. ");
INSERT INTO myw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ikatuyouns inekes, takatouns babaw ivag ibweins, mapuna tasiyas askatoun kweitan kweitan ipapeps sisiyas wawous, sivines kid bikabkwanes Yeisuw. Yeisuw mo idibakes navamul, ilana, “Kunibwis wag, kukin gamag babaw biyabinigs mo ba̱touw wa̱wag.” ");
INSERT INTO myw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tasiyas gog takayyeiluws bikalka̱louws Yeisuw wamatan mo beiwaks, bilansa, “Ya̱koum Yowbad natun ya̱koum,” peinan yeiluw tasiyas bo iwtusis Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tage Yeisuw singaya anilivan tawtoun idibakes, ilana, “Awoum kwamteleigs peinan Yowbad natun yey.” ");
INSERT INTO myw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wankuyeim ikatulag in wa̱koy, kalisiy tasiyas itimek nanon ikatigikes, mo idawes inekes. ");
INSERT INTO myw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Bo ikatigik tasiyas sinawatan teiy, mamagina takaweins anilivan, siney bisesus mo bikayabes va̱gan bigeiguys o bitawtouns wasigeis yeiluw, bikayabes. ");
INSERT INTO myw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tasiyas sinawatan teiy yiges Saymon, mtowen idok Pita; ");
INSERT INTO myw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebediy nitun Yemes son bwadan Yon, idokes Bowanages, peinan asisinap ma̱wana pala̱pal tasiyas; ");
INSERT INTO myw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Andiluw, Pilip, Batolomiw, Matiw, Tomas, Yemes, mtowen Alpiyow natun, Tadiw, gum-Keinan yagan Saymon, Yudas Iskaliyot, mtowen tasilkodein Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ikous, iyum in wanven, babaw gamag mo ikatuyouns inekes. Nawotet singay avakaein wasigeis tasiyas babaw gamag. Ta-ma̱wan beikam. ");
INSERT INTO myw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Taliven liva̱nen Yeisuw iliganes, idokes bo ikabala̱wein, bineis kid bitokes binawes. ");
INSERT INTO myw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tasiyas gog takatimlakeins kaleiwag meinoy nimeis Yelusalem, ikines Yeisuw, ilansa, “Bwagaw ileb. Adok tasiyas tabbwagaws sitovek Seitan mtowen nileb Yeisuw, mo ikayabes yeiluw.” ");
INSERT INTO myw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iw to Yeisuw, ikabebay, idibakes ilana, “Ta-ma̱wan Seitan bigulek nawotet tatonen. ");
INSERT INTO myw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Kukin nagamag bilivis bimlavags bod kweitan kweitan, mo bikalouw nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Wanbunatum-vak, kukin bilivis bimlavag bod kweitan kweitan, mo beikous nabunatum gimgilis. ");
INSERT INTO myw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“Seitan-vak ma̱wan, kukin bigulek nawotet tatonen, o biliv inabod, mo bikalouw, nakaleiwag bo beikous. ");
INSERT INTO myw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kukin bitasiw wanuwan tatawtoun towen Seitan nabunatum, bitaven navavag, kadiloka bitayous mtowen, tayawen naman kaken, mo bitakow navavag beikous. Bwagaw nag ilabeigs; nag. Yowbad Kululuwan ilabeig. ");
INSERT INTO myw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","“Mounid adibakeimiy amisinap singay kalbaleb, peinan kuyages Kululuwan Towen Bwanabwein. Gamag asisinap babaw Yowbad biwid; sikalbaleb, o asilivan kalbaleb nillivans, Yowbad biwidis beikous; tage kukin biyages Kululuwan Towen Bwanabwein, nag biwid, peinan asisinap to kalbaleb bises bisiseg. Nag kweitan tut biwid, nag.” ");
INSERT INTO myw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeisuw anilivan ma̱wan peinan ilansa, “Bwagaw ileb.” ");
INSERT INTO myw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yeisuw inan budan nimeis itomos watoulan gamag babaw, ikayabes gamag mwasanin bidawes beim. ");
INSERT INTO myw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Inekes Yeisuw, gamag babaw nisinis wadadan, ilansa, “Inam siney budam inineveims; watoulan nisesus.” ");
INSERT INTO myw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iw to Yeisuw, ilana, “Kavel inag o bwadag?” ");
INSERT INTO myw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Mo ikatimlek bikin gamag siyas nisinis wadadan, ilana, “Tasiyasa inag o bwadag. O kukin kal bikanow aygan Yowbad, mtowen bwadag o nagut o inag.” ");
INSERT INTO myw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Vayuwein inoun in yevagam avakaein wadadan mo ikatimlakes gamags, peinan singay babaw gamag katuyouns inekes, mapuna itouw wa̱wag, isin, ikatimlakes gamag tasiyas wanakaew nisesus. ");
INSERT INTO myw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ikatimlakes, nakabebay babaw isekes, idibakes mamagina: ");
INSERT INTO myw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kuliganes yakamiy. Talavein kaytul wit inoun in wa̱bag, ilivelov nakaytul. ");
INSERT INTO myw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","“Kaytul mwasanin ikalka̱louw ininein waked, man iyoyows imimeis, ikoums ikamiyeivis. ");
INSERT INTO myw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","“Kaytul mwasanin ikalka̱louw ininein wadikuda̱kul; nag ivag pwepway-nen, tage nuwanaw isob, wankuyeim ikal ka̱las, ikalayag peinan gidwa̱lin nag inek pwepway. ");
INSERT INTO myw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Kaytul mwasanin ikalka̱louw inek doudiw kaytul-nen, isibwa̱sobs son doudiw, tage doudiw itawtoun; wit nag ivag anagin. ");
INSERT INTO myw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Tage kaytul mwasanin ikalka̱louw ininein wasapon isibwa̱sobs, ivakaein, ivag kan babaw; kaytan wit anagin sinawatoun, kaytan wit anagin sinawanim, kaytan wit lakatutan.” ");
INSERT INTO myw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ikous nakabebay towen, ilivan, ilana, “Kal yak sam teigam, bweina kuligen.” ");
INSERT INTO myw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wankuyeim gamag babaw ilisawes Yeisuw, asteiyuy sisiy nisesus, mo ikatiga̱nes Yeisuw sisiyas inavamul sinawatan teiy; sivines bikakins nakabebay silawun. ");
INSERT INTO myw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iw to Yeisuw, mo idibakes, ilana, “Sinapun Yowbad o nakaleiwag kukwakins yakamiy, tage tasiyas watoulan biliganes kabebay, tage nag bikakins silawun. ");
INSERT INTO myw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Mapuna ‘Mites bikines tage nag biwtusis. Tiges biliganes tage nag bikakins. Va̱gan nag bikanavin ninous, nag biwidis asisinap kalbaleb, nag.’” ");
INSERT INTO myw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeisuw mo idibakes, ilana, “Adok nag kukwakins kabebay towen. Ama̱wan bukuwkakes mo bukukwakins kabebay babaw? ");
INSERT INTO myw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Mtowen talavein kaytul mamagina livan bilivelov. ");
INSERT INTO myw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Siyas nikalka̱louw wa̱ked man bikawtawes mamagina gamag iliganes bwanabwein, nag inuwes beibwein livan towen, mo isap Seitan, ikwey livan towen. ");
INSERT INTO myw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","“Siyas nikalka̱louw wadikuda̱kul mamagina gamag tasiyas bo iliganes livan bwanabwein, sona simwa̱saw mo itams waseg. Tage nag ikakins livan silawun, mamagina gidwa̱lis nag binek pwepway, nuwanaw mo ikalouws. Gamag tasiyas beitams livan towen waseg, mapuna gamag mwasanin biyagages, abes bigeg, nuwanaw mo bikalouws. ");
INSERT INTO myw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","“Siyas gog nisibwa̱sobs son doudiw mamagina gamag tasiyas iliganes livan towen, tage ininuways sinapun ven watinow, o sivines biguyaws o bimwa̱saws youd kweitan kweitan waseg, mapuna inumlaves livan towen; nag ivag anagin; mamagina bo ikwen doudiw. ");
INSERT INTO myw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Tage tasiyas wasapon, mamagina gamag tasiyas iliganes livan, itams waseg, ivag angis, mwasinis sinawatoun, mwasinis sinawanim, mwasinis lakatutan.” ");
INSERT INTO myw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wankuyeim mo ikabebay, idibakes, ilana, “Nag teitan bikow nalamp bikatgubwel loutan wakunuwatan; nag bisen keb waskawan, nag. Tage dalamp bitasen wateibol. ");
INSERT INTO myw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","“Aveiyag bitasowum, igaw mo bikamat. Aw-livan bitakatmwa̱lag, igaw gamag babaw mo biliganes. ");
INSERT INTO myw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Kal ya̱koum sam teigam, bweina kuligen.” ");
INSERT INTO myw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ikous, mo idibakes, ilana, “Kuvna̱ses livan to kuliganes. Aveiyag kusekes gamags, Yowbad mo bisekeimiy, o bikatimweis bibabaw. ");
INSERT INTO myw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","“Kukin mivavag nises, Yowbad mo bisekeimiy bibabaw; kukin gog mivavag nag, mo biyamen aveiyag nises, bikow, va̱gan bukudeivs.” ");
INSERT INTO myw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Wankuyeim ilivan, ilana, “Yowbad nakaleiwag ama̱wan? Adok ma̱wan gamag teitan ilivelov kaytul ininein wa̱bag, iyum in, ises, ee... yam mwasanin ikous, kaytul mo isob, ivakaein; tage nag ikakin silawun. ");
INSERT INTO myw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“Pwepway nakaleiwag tatonen, kan isob, ivakaein mo ilal, ivag anagin. ");
INSERT INTO myw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","“Anagin bimatuw, nuwanaw mo bitayow, peinan anatut ta̱yoy.” ");
INSERT INTO myw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","32","Wankuyeim ilivan, ilana, “Kweitan kabebay ma̱wan towen kuliganes va̱gan bukukwakins Yowbad nakaleiwag. Adok ma̱wana tipol kaytul-nen, bitasop singay kakit, tage beisob mo bimlavag kay avakaein, yayagen kawka̱veks; man biyoyows bimimeis biwlules sibwan wayayagein.” ");
INSERT INTO myw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nakabebay ma̱wan singay babaw ansinap ikatpel isekes. Aveiyag ikadilokes bikakins mo isekes ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nag anilivan didumwal isekes, nag; kabebay-wan. Wankuyeim siney navamul tatonen, tasiyas-wan mo ilik va̱gan silawun meiveka kabebay bikakins. ");
INSERT INTO myw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yam towen kwayav, Yeisuw wa̱wag nises, idibakes, ilana, “Kumeis kutouws tadopels, taneis palatan.” ");
INSERT INTO myw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Itouws tasiyas, ilisawes gamag babaw nisesus waven mo idopels bineis palatan, ikavetans sisiyas mwasanin wag. ");
INSERT INTO myw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Isisawls, bwaw avakaein ilivatus, soup inay-o; kakita bimukul wag. ");
INSERT INTO myw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Togo Yeisuw nikow abeikun, nisen wawawun wag, imasis kangagay, mo inekes, iwgunis, ilansa, “Tamwey, kukit, tabta kukwakin kakita bitamta̱mats?” ");
INSERT INTO myw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iligen, ikit, idibek yag son kaysay, ilana, “Deisa! Beitay!” Yag mo idabab, niwal avakaein. ");
INSERT INTO myw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ikous, mo idibakes tasiyas, ilana, “Wawun amipwa̱yat? Adok nag kusimounids waseg yey, ne?” ");
INSERT INTO myw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Singaya igoulus, sisiyas illivans, ilansa, “Amata taw towen? Idibakew yag son kaysay, mo ikanawes aygan.” ");
INSERT INTO myw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Idopels ineis palatan, ilugs ven Gelasin waseg. ");
INSERT INTO myw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yeisuw ibus, in wanakaew, mo takayeiluw teitan isap, imek. Bo ilisow alawag towen takunumwan, inoun imek Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Taw towen nag ivag nabunatum, immasisa wakalawag. Nag teitan gamag kadilok bitawtoun biyous taw towen, biyawen sen waseg. Tut babaw niyawwanis sen waseg o kaken nikiptukwes amweilok waseg, tage ivatay, iwlitun sen, iwut amweilok kaken waseg mo isawl. Tut babaw ma̱wan-wan. Nag teitan gamag kadilok vayuwein biyous. ");
INSERT INTO myw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mapuna nises wakalawag o wa̱koy, biwkuwak-wana beiyam oko beiboug, mo biwekey dakul bikow, tatonena-wan biwaway wa̱won. ");
INSERT INTO myw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tage Yeisuw ilug im, ikin kadiveiyov, isawl im, bikulul kid wamatan. ");
INSERT INTO myw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Aygan avakaein iwak, ilana, “Aveiyag bukunuwakeig Yeisuw, ya̱koum Tamam Yowbad walba̱lab. Kunuway Tamam; mata kuweig, ke?” ");
INSERT INTO myw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anilivan ma̱wan peinan Yeisuw bo idibek yeiluw bilisow kid gamag towen, binoun. ");
INSERT INTO myw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeisuw ikatigan yeiluw ilana, “Yeiluw ya̱koum, amiyagam?” Iw to yeiluw, ilana, “Yagag Kamimet, peinan meiveka yakamey ka̱siw nakases.” ");
INSERT INTO myw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mo igilagel waseg Yeisuw, ilana, “Awoum kwayabem bakan kadiveiyov.” ");
INSERT INTO myw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tage bwaloud babaw ikamkwams awuyow wa̱koy. ");
INSERT INTO myw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Siyas yeiluw igilagels, ilansa, “Kwayabem bakan bwaloud wanuwes.” ");
INSERT INTO myw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Itam, ilana, “Kuweis.” Iweis gog, isiws wanuwes bwaloud, mo isisawls, ineis koy tigtageg waseg mo ikalka̱louws inineis wayvagam, iwgweles, bwaloud singay babaw, mamagina akweiy tawsan. ");
INSERT INTO myw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tasiyas gog tamtakavateins aleis, isawls, ikamteles youd towen wawnovek o vena babaw wasigeis. Iliganes gamag babaw, bisaps kid bineis ikines. ");
INSERT INTO myw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Isaps, inekes Yeisuw, ikines towen takayeiluw bo ibwein, bo isikam anakweim, nissin wadadan. Bo iyow nuwes peinan ikakins yeiluw babaw neisiws wanuwan taw towen; nagein gog bo ibwein. ");
INSERT INTO myw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gamag mwasanin nisesus, ikines takayeiluw bo ibwein, yeiluw mo iyagages bwaloud, wankuyeim mo ikamteles gamag tasiyas mwana nimeis. ");
INSERT INTO myw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iliganes tasiyas mo igilagels waseg Yeisuw sivines bilisow siven, binoun. ");
INSERT INTO myw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mapuna itouw wa̱wag, bo beiyum. Toge takayeiluw mtowen mwana neibwein igilagel waseg Yeisuw, sivinan kid sona bineis. ");
INSERT INTO myw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yeisuw gog ipiyev, ilana “Nag. Bweina kuyum kun wamven, kudibakes talawom mo bikakins ama̱wan daGuyaws nikalin nuwan waseg ya̱koum, ilabeim.” ");
INSERT INTO myw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iligen, iyum, in ika̱mat ama̱wan nivkek Yeisuw nileb. Wawnuwan ven towen Dekapolis gamag babaw iliganes, mo isom ninous. ");
INSERT INTO myw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeisuw siney navamul idopels, iyums ineis palatan; babaw gamag iliganes, ikatuyouns imekes Yeisuw, igaw nises walasin yevagam avakaein. ");
INSERT INTO myw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Isap tanuwagan sinagog teitan, yagan Yelos, ikin Yeisuw, ikulul avakaein wamatan, igilagel, ilana, “Natug kuda̱vin ankatoun avakaein. Kum kusen namam wa̱won kuyamov.” ");
INSERT INTO myw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeisuw itam, mo inounas ineis son taw towen. Singay babaw gamag ibwa̱kuns waseg, ipapeps wa̱won. ");
INSERT INTO myw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Inounas, na̱tan vin nakatoun inek Yeisuw. Ankatoun peinan buya̱vin iwta̱wout sinawatan kweiy bweilim; nag imda̱mad. ");
INSERT INTO myw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doket babaw iyyokons, bo nag. Vin na̱wen namoney igimwelena bo iyakous; tage doket tasiyas nag ilabes bwein vin mana̱wen, ankatoun bo ivakaeina singay. ");
INSERT INTO myw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mana̱wen vin bo iligen bulagan Yeisuw, isiw wanuwan gamag babaw, ikikun ee... mo ikabkwen anakweim matan. ");
INSERT INTO myw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Idoki misinaka bikabkwen anakweim matan mo beibwein. ");
INSERT INTO myw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ikabkwen, nuwanaw mo imad buya̱vin; isimkwen wa̱won, ikakina bo ibwein. ");
INSERT INTO myw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tage Yeisuw isimkwen natawtoun bo ilisow won, itouvin wanuwein gamag babaw, ilana, “Kal ikabkwen agukweim?” ");
INSERT INTO myw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iweis navamul, ilansa, “Gamag singay babaw ipapeps wa̱wom. Aveiyag wawun kulana, ‘Kal ikabkwaneig’?” ");
INSERT INTO myw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tage Yeisuw ivvatus gamag babaw, bikin kid kal nikabkwen. ");
INSERT INTO myw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vin mana̱wen ikakina bo ibwein won, anpwa̱yat seikwan, tage inek Yeisuw, ikulul wamatan, ikamtel anilivan iyakous. ");
INSERT INTO myw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iwa̱ge Yeisuw, idibek ilana, “Vin ya̱koum, nukusimounid waseg yey, mapuna bo kubwein. Mwa̱saw waseg kunoun, peinan amkwatoun bo ikous.” ");
INSERT INTO myw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Igawa illivan, teitan gog gamag meinoy neim tanuwagan sinagog wanbunatum, idibek, ilana, “Natum bo ikanig. Awoum kweitan wotet kusek takatimlakay towen.” ");
INSERT INTO myw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeisuw gog iligen, idibek tanuwagan sinagog, ilana, “Awoum bikubukub nuwam, bweina bukusimounid.” ");
INSERT INTO myw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeisuw ilana, “Awoum kumeis tababaw yakamiy. Bweina yey sigwey gunavamul tasiyas Pita, Yemes son bwadan Yon, o gwad taman. Misinaka amateinim.” ");
INSERT INTO myw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Isaps tanuwagan sinagog wanven, ikines tavva̱lams ivva̱lams, talloupids illoupids, ages avakaein. Isiw, ilana, “Aveiyag wawun kuvva̱lams, agamiy avakaein? Gwad na̱wen na-ikanig; immasis-wan.” ");
INSERT INTO myw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tasiyas gog igagigs issiba̱wes. Yeisuw mo idibakes babaw bineis watoulan; misinaka gwad taman inan, sisiyas navamul asteitoun sisiy binekes gwad nimsik-yay. ");
INSERT INTO myw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yeisuw inek gwad towen, iyous naman, ilana, “Talita koum.” (Takativini gog bein aga-Muyuw, mamagina, “Gwade, adibakeim kukit.”) ");
INSERT INTO myw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gwad na̱wen nuwanaw itamanaw inoun, anbweilim mamagina sinawatan kweiy. Ikines, singay isom ninous tasiyas. ");
INSERT INTO myw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","To go Yeisuw anilivan tawtoun idibakes, ilana, “Awoum kwamteles youd towen”, mo ilana, “Kan kusekes nitumiy beikam.” ");
INSERT INTO myw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeisuw ilisow ven towen, iyum in wanven tatonen; navamul gog ibbwa̱kuns waseg. ");
INSERT INTO myw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Sa̱bat waseg isilamaw nakatimlakay wasinagog. Tanganegs babaw isom ninous, ilansa, “Ama̱wan singaya isinap taw towen? Kal isek ansinap mo iwotet singay tawtoun wanaman waseg? Adok towen tawtelein amweilok, ne? Inan Meliy, budan tasiyas Yemes, Yoses, Yud, Saymon, sisiyas nunet nitasesus sidayas.” Mapuna mo ipiyaves mtowen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iw to Yeisuw, idibakes, ilana, “Vena babaw itams palopit waseg. Misinaka naven tatonen bipiyev, o taliven tasiyas wanbunatum bipiyaves.” ");
INSERT INTO myw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mapuna ven towen waseg ta-ma̱wan biwotet tawtoun. Deisa takatouns asteiyuy isen naman wawous mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bo isom nanon peinan nag bisimounids ven towen waseg. ");
INSERT INTO myw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","9","Tage ita̱vin ven mwasanin, ikatimlakay. Mo idawes navamul sinawatan teiy, ikayabes asteiy asteiy bineis ven babaw; isek sitawtoun va̱gan bikayabes yeiluw; ilana, “Awoum kunamiy kukwawes wa̱ked; misinaka mikaytuk; kaeimiy awoum; amikaw awoum, mimoney awoum; misinaka sandol kuvaligaves wakikeimiy; amikweim mwayntanok.” ");
INSERT INTO myw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ilana, “Bukuneis kweitan ven, awoum kuglagals, kukin kal wanbunatum bukusiws, bweina bukusesusa bunatum towen oko tutan bo bukuneis mo bukunounas. ");
INSERT INTO myw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Kukin ven kweitan bipiyaveimiy, o bipiyaves amilivan, kadiloka kulisawes ven towen, kwatsa̱pis musmusan pwepway wakikeimiy bininein wasiven mo bikakins asisinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","13","Iliganes tasiyas sinawatan teiy inounas iggeiguys va̱gan gamag bikanavin ninous; o ikkayabes yeiluw babaw, o takatounsa babaw ilgubokes tagon wawous mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Inounas tasiyas, king towen Elod iligen bulagan, peinan babaw gamag niliganes liva̱nen Yeisuw. Gamag mwasanin idokes Yon bo ikit kanig waseg, mapuna Yeisuw nawotet singaya tawtoun. ");
INSERT INTO myw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mwasanin gog ilansa, “Mtowen Ilaytiy.” Tage mwasanin ilansa, “Mtowen palopit ma̱wana siyas palopits kweiboug.” ");
INSERT INTO myw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tage Elod iligen bulagan Yeisuw mo ilana, “Mtowen Yon, nabob kayon, tage bo imov vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kweiboug Yon ikan Elod ilana, “Amsinap kalbaleb, kuvagut bwadam nakwav.” Peinan bwadan Pilip nakwav Elodiyas ivagut mtowen Elod. Yon ikanan, mo igeg nanon mtowen Elod, ikayeb natouwats iyousis Yon, iyawanis naman, isen wanuwan deil. ");
INSERT INTO myw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Elodiyas-vak ikamliw Yon, sivinan beiweiy. Nag gog, peinan Elod ikayus, iwen Yon, ikakina gamag tadidumwal, bwanabwein; ikayus, sivinan biligen aygan, tage Yon anilivan waseg mo iyageg nanon Elod. ");
INSERT INTO myw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mana̱wen vin sivinan beiwey Yon, ikayamat oko Elod isagal, anva̱van sigeilin, peinan yam towen inan nikop, ikamkwam siney tasiyas gabmans sisiyas takalikays sisiyas min-Galiliy situwa̱veks. ");
INSERT INTO myw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Tasiyas ikamkwams imwamoums, mo isap Elodiyas natun kuda̱vin isilasal. Isilasal oko ikalin nuwes tasiyas sisiy Elod, idibek gwad mana̱wen, ilana, “Aveiyag sivinam, kulivan mo basekeim.” Itabudabod, ilana, “Magat sivinam baliv gunaven to namtakavet, palatadadan yak, palatadadan yey. Bweina kulivan mo baliv basekeim palatan.” ");
INSERT INTO myw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gwad mana̱wen iligen, in watoulan, ikatigan inan, ilana, “Aveiyag balivan?” Iwa̱ge inan, ilana, “Kulivan busabwesan Yon, tabapta̱ysein gamags.” ");
INSERT INTO myw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iligen, nuwanawa iyum, inek king towen, initoug, ilana, “Sivinag Yon busabwesan kusen wakabmavin mo kusekeig, mtowen tabapta̱ysein gamags.” ");
INSERT INTO myw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iligen king towen, igeg nanon, tage nag bipiyev, peinan bo itabudabod, o tasiyas siney bo iliganes anilivan. ");
INSERT INTO myw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Mapuna ikayeb takaymatein bunatum teitan, ilana, “Kun kubob kayon Yon, busabwesan kudeg wakabmavin kumey.” Inoun in wa̱deil, ibob kayon Yon, busabwesan isen wakabmavin, imey, isek gwad mana̱wen; ikow, inow, isek inan. ");
INSERT INTO myw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Inavamul Yon iliganes bo iweiys, mo imeis, ikawes takaning towen, inawes, isenas wakalawag. ");
INSERT INTO myw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","31","Yeisuw nagamag nikayabes mo iyums, ikatuyouns imekes Yeisuw, ika̱mats siwotet babaw o sikatimlakay babaw; mo idibakes, ilana, “Kumeis, taneis nawoud makaw, ya̱kids-wan bitayeiwas tut kadiyakus.” Peinan singay babaw gamag inounawas inounamas; ta-ma̱wan biyeiwas o beikams kan, nag. ");
INSERT INTO myw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mapuna itouws wa̱wag, idopels ineis nawoud makaw, tasiyas-wan bisiwas. ");
INSERT INTO myw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tage gamag babaw bo ikines nikala̱vis-o nineis. Tasiyas gog gamag babaw bo iwtusis, ilisawes siven babaw isisawls, inoys wa̱ked, bo imgwayes, Yeisuw siney navamul wankuyeim. ");
INSERT INTO myw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ita̱lags siney navamul, ikin gamag babaw, inok nuwan, peinan ma̱wana mansiyas sip, ta-ivag sitamtakavatay, mapuna ikatimlakes sinap babaw. ");
INSERT INTO myw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Ikatimlakay ee... kwayav, navamul mo imekes Yeisuw, ilansa, “Ven to nawoud makaw o bo iboug, kwayabes gamag babaw, bineis ven mwasanin walasids va̱gan bigimwals kaeis beikams.” ");
INSERT INTO myw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iw to Yeisuw ilana, “Kusekes kaeis beikams.” Tasiyas gog ikatugwans, ilansa, “Tabta bakan bakagimwal asibled lakatuy kina, bakasekes ikams, ne?” ");
INSERT INTO myw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iwa̱ge, ilana, “Kweivin amibled? Kuneis, kukines.” Ikakins, ivinis, ilansa, “Kweinim bled, son in mwanay.” ");
INSERT INTO myw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeisuw mo ilivan va̱gan bisinis tasiyas wakunuwatan awuyow, kweitan bod, kweitan bod waseg. ");
INSERT INTO myw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mapuna isinis, bod kweitan, kweitan, mwasanin lakatutan, mwasanin sinawanim. ");
INSERT INTO myw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Isinis ikous, Yeisuw mo ikow bled siyas kweinim son in mwanay, ikin walba̱lab, ikalin nuwan Yowbad waseg, mo ikikivis bled tasiyas, isekes navamul bikawes bisenas wamtes gamag, beikams. Mansiyas in-vak ikaleiwag, isekes asibabaw beikams. ");
INSERT INTO myw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ikamkwams tasiyas, ikamuweips-wan. ");
INSERT INTO myw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ikous, kan nikambwages ikatikunakus sinawatan kweiy kaynad, bled son in. ");
INSERT INTO myw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tasiyas takamkwams mamagina kweinim tawsan tawaw. ");
INSERT INTO myw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ikous, mo idibakes navamul, ilana, “Kutouws kudopels, kumugwas, kuneis palatan, ven yagan Beteseid; yey gog bases bakayabes gamag babaw.” ");
INSERT INTO myw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ikayabes ikous, mo ikatulag in wa̱koy, initoug waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ikala̱vis navamul, ineis watapwana yevagam avakaein; bo iboug. Tage Yeisuw anmwa̱net-wan isiwana waven. ");
INSERT INTO myw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yeisuw ikines ikalla̱vis, kala̱lav nimeis, peinan yag itow meinoy neim wamtes. Kakita beiyam mo inoun wakunuwatan yevagam, sivinan binekes. ");
INSERT INTO myw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tasiyas gog ikines Yeisuw wakunuwatan yevagam inoun imimeim, iwaks, aspwa̱yat, idokes kid a̱luw. ");
INSERT INTO myw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Asibabaw ikines, iwenes singay. Towen gog idibakes, ilana, “Yey. Bwein-wan. Awoum beivag amipwa̱yat.” ");
INSERT INTO myw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Mo itouw, inekes wa̱wag, mo idabab yag. Singay isom ninous. Ninous tasiyas keikay, peinan nag ikakins Yeisuw natawtoun silawun tut towen waseg ikow bled kweinim mo ivakamus gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ikala̱vis ee... ita̱lags palatan, ven yagan Genesalet, lon ikawes ilaves in wanakaew, siwag ikot. ");
INSERT INTO myw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Ineis wanakaew, towous bo iwtusis, isisawls, ineis vena babaw, ikawes takatouns nimmasis wakabes, imeyes am-palawen iliganes Yeisuw nises. ");
INSERT INTO myw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yeisuw am-palawen binoun bein, takinew wunkakit, o takinew wunovek, o takinew wanawoud, tasiyas towous mo bikawes takatouns biseinis wavtakon ven, mo binitougs va̱gan bikabkwanes matan anakweim; o kalisiy tasiyas ikabkwanes mo ibweins. ");
INSERT INTO myw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Wankuyeim tasiyas Palisiy sisiyas takatimlakeins kaleiwag mwasanin meinoy nimeis Yelusalem, ikatuyouns imekes Yeisuw; ikines navamul mwasanin nag iwidis nimes, tage sona ikamkwams. ");
INSERT INTO myw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Tasiyas gog Palisiy asisinap kweitan, sisiyas min-Yudiy babaw; kukin nimes nag biwidis beibwein, nag beikams; peinan ikikuns tammwayas asisinap waseg. Asisinap ma̱wana kukin beinoys wamaket bimeis, biwidis nimes mo beikams; kukin nag biwidis nimes nag beikams. Asisinap babaw ma̱wan, iwdiwids askwa̱vig, askunasoup, sikabmavin, o abes. ");
INSERT INTO myw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tasiyas Palisiy sisiyas takatimlakeins kaleiwag ikines, mo ikatiga̱nes Yeisuw, ilansa, “Aveiyag wawun muvamul nag ikikunis tammwayas sikaleiwag; nimes bikibik sona ikamkwams.” ");
INSERT INTO myw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iwa̱ge Yeisuw, mo idibakes, ilana, “Tayyaweid yakamiy! Palopit towen Isaya ilivnek livneimiy, kweiboug Yowbad anilivan ilel, bo ikunakeimiy, mamagina: ‘Gamag tasiyas isiwyoubugs wudousa mav waseg; Tage ninous nag imekeig. ");
INSERT INTO myw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Makava itapwa̱louls waseg yey, Peinan nag ikatimlakays gunakaleiwag, tage gamag mwasanin sikaleiwag ikatimlakays.’ ");
INSERT INTO myw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Yowbad nakaleiwag bo kupiyaves, tage kutams waseg gamag mwasanin sikaleiwag.” ");
INSERT INTO myw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mo idibakes, ilana, “Singaya kusinaps, tage kupiyaves Yowbad nakaleiwag, mo kukwatilawos mikaleiwag tatineimiy. ");
INSERT INTO myw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Kweiboug Moses ilivan Yowbad nakaleiwag mamagina: ‘Kuvna̱ses timmiyas o inmiyas,’ o ‘Kukin kal biyeg taman o inan, kuweiys beimat.’ ");
INSERT INTO myw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tage yakamiy mikaleiwag mamagina: Gamag bweina bidibek taman o inan, bilana, ‘Bo akatibom youd towen silma̱nin Yowbad; ta-ma̱wan basekeim yak.’ ");
INSERT INTO myw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mamagina kutams va̱gan bikamgwayes taman o inan. ");
INSERT INTO myw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Amikikun towen waseg bo kugulekwes Yowbad nakaleiwag. Amisinap babaw ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeisuw mo idawes gamag babaw, isineikimas, idibakes, ilana, “Babaw yakamiy, kuliganes agulivan mo bukukwakins. ");
INSERT INTO myw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Nag aveiyag watoulan gamag beisiw wa̱won biyageg, nag. Tage aveiyag wanuwan gamag bisap bein wamnat mo biyageg gamag towen.” ");
INSERT INTO myw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO myw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ilivan ikous, ilisawes gamag babaw, inoun in wanbunatum. Navamul mo ika̱tiganes Yeisuw, sivines kid bikakins nakabebay silawun. ");
INSERT INTO myw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Iw to Yeisuw, idibakes, ilana, “Adok yakamiy-vak tatagouwaws yakamiy! Youd babaw watoulan gamag beisiw wa̱won, nag biyabik, nag. Peinan nag beisiw wananon; misinaka in watoubun wankuyeim mo bipwal bein wamnat.” Yeisuw anilivan towen waseg ikabwein kan babaw; nag kweitan bwaboum, nag. ");
INSERT INTO myw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Wankuyeim mo ilivan, ilana, “Aveiyag wanuwan gamag bisap bein wamnat, youd towen biyabik gamag. Peinan wanuwan gamag bispuy nakanuway kalbaleb, subwan, veinaw, katumat gamag, kanavay mav, mitmwamon, kameiliw, katadividav, kalimwa̱saw, silponay, livan kalbaleb, kaya̱pam, sinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Sinap tasiyas kalbaleb wanuwan gamag bisap mo biyabik gamag towen.” ");
INSERT INTO myw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ikous, Yeisuw itamanaw in wawnuwan ven Ta̱yil; mo isiw in bunatum kweitan, nag sivinan gamag bikakins; nag gog, ta-ma̱wan bisowum. ");
INSERT INTO myw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Vinen-Saloponis na̱tan, nag vinen-Yudiy; tage bo iligen bulagan Yeisuw nises ven Ta̱yil waseg, mo inoun inek silma̱nin bikulul binitoug waseg, peinan yeiluw neiweiy natun kuda̱vin, sivinan kid bikayeb yeiluw binoun; ilana, “Kum kwayeb yeiluw towen neiweiy natug.” ");
INSERT INTO myw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iw to Yeisuw, ilana, “Wanmugwana bavakamus gamagal. Awoum bakow gamagal kaeis basekes mansiyas awuk beikams, awoum.” Ilivan ma̱wan peinan min-Yudiy idokes tobwag ven gimgilis mamagina awuk. ");
INSERT INTO myw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mana̱wen vin ikatimop aygan, igilagel, ilana, “O guyaw, mansiyas awuk-vak waskawan teibol beikams musmusan gamagal asibled ikalka̱louws.” ");
INSERT INTO myw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iw to Yeisuw ilana, “Amlivan bwein. Kunoun kun, kukin natum, yeiluw bo ilisow.” ");
INSERT INTO myw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Inoun in wanbunatum, iban natun nimmasis wa̱keb, yeiluw bo ilisow. ");
INSERT INTO myw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wankuyeim ilisow wunsiyas ven walasin Ta̱yil, ikanapel Saydon, in yevagam avakaein yagan Galiliy, wawnuwan Dekapolis. ");
INSERT INTO myw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mo imeyes takakon teitan, anilivan wadadan-wan, ilansa, “Tab kadilok bukusen namam wa̱won, takakon towen.” ");
INSERT INTO myw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","Yeisuw itok takakon towen, ilisawes gamag babaw, mo teigan paley ikawgil didin waseg, mo giwun waseg iwlik mayen; ikous iyey, ikin walba̱lab, singay igeg nanon, mo ilana, “Epipat.” (Aga-Muyuw waseg mamagina “Kwaliyow.”) ");
INSERT INTO myw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nuwanaw ikaliyow teigan, mayen ibwein, anilivan mo ididumwal. ");
INSERT INTO myw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Yeisuw gog idibakes, ilana, “Awoum kwamteles gunawotet towen, awoum.” Anilivan babaw ma̱wan, tage nag ikanawes, singaya illivans-wan inawotet bulagan. Singaya isom ninous, ilansa, “Inawotet babaw singay bwein. Takakons ivag ibweins mo iliganes livan, o tasiyas asilivan wadadan ivag mo ilivans bwein.” ");
INSERT INTO myw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Misiya̱mun towen, babaw gamag nikatuyouns nimekes vayuwein Yeisuw, nag ivag kaeis beikams, mo idawes navamul, imekes, idibakes, ilana, “Bo inok nuwag gamag tasiyas babaw nikanatouns waseg yey, kaeis gog nag. ");
INSERT INTO myw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","“Kukin bakayabes bineis wasiven asimoun-wan, adok bisoumats wa̱ked. Peinan mwasanin siven kadiveiyov.” ");
INSERT INTO myw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iweis navamul tasiyas, ilansa, “Ven to nawoud makaw; ama̱wan bitavakamus gamag tasiyas? Kan gog nag.” ");
INSERT INTO myw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iw to Yeisuw, ilana, “Akweivin amibled?” Ilansa, “Kweinim kweiy.” ");
INSERT INTO myw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Idibakes gamag babaw, ilana, “Kusinis wapwepway.” Wankuyeim mo ikow bled siyas kweinim kweiy, ikalin nuwan Yowbad waseg, ikivis bled siyas, isekes navamuls va̱gan bivaganes; mo ikawes isekes babaw gamag wasigeis. ");
INSERT INTO myw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Asiyin mwanayun-wan nisesus, ikow wanaman, mo initoug Yowbad waseg, ikalin nuwan peinan in. Ikous, mo idibakes navamul va̱gan bikawes bisekes babaw gamag, mo isekes. ");
INSERT INTO myw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Babaw gamag ikamkwams, bo ikamuweips, mo ikatikunakus kan towen nikambwages, mo idagis wagamwat, imlavag gibsinim gibsiy. ");
INSERT INTO myw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ikous, mo ikayabes tasiyas kweivas tawsan gamag, inounas; mtowen siney navamul itouws wa̱wag, idopels ineis ven Dalmanut. ");
INSERT INTO myw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tasiyas Palisiy mwasanin mo inekes Yeisuw, ikammnimans, mamagina iyakwanes, ilansa, “Kuvag muwotet bitawtoun ma̱wana naman mulin Yowbad.” ");
INSERT INTO myw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeisuw gog singay igeg nanon, ilana, “Gudwouvaws yakamiy sivinamiy bukukines Yowbad naman mulin,” mo itabudabod, ilana, “Nag bukukines, nag.” ");
INSERT INTO myw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Vayuwein mo ilisawes, itouws wa̱wag, idopels ineis palatan. ");
INSERT INTO myw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tage bo inumlaves kaeis; misinaka katanoka bled wa̱wag. ");
INSERT INTO myw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeisuw mo iguyes, ilana, “Kuvna̱seimiy. Kadiloka kupiyaves tasiyas Palisiy asiyist o Elod anayist.” ");
INSERT INTO myw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iliganes, idibakes sisiyas, ilansa, “Adok anakabebay, peinan tanumlaves adableds.” ");
INSERT INTO myw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeisuw gog ikakina ninous, idibakes, ilana, “Wawun kulansa, ‘Tanumlaves adableds’? Singay tatagouwaws yakamiy; ninoumiy nag. ");
INSERT INTO myw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","“Sam mitamiy tage nag kuwtusis; sam tigamiy tage nag kuliganes beibwein. Adok nag kunuways akivis kweinim bled silma̱nin kweinim tawsan gamag, kweivin kaynad kan nikambwages mo kwatikunakus, ne?” Ilansa, “Sinawatan kadiney.” ");
INSERT INTO myw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Vayuwein Yeisuw ikatiga̱nes, ilana, “Wankuyeim akivis bled kweinim kweiy silma̱nin kweivas tawsan gamag, kweivin gamwat kan nikambwages mo kwatikunakus, ne?” Ilansa, “Gibsinim gibsiy.” ");
INSERT INTO myw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iwa̱ge Yeisuw, ilana, “Igawa tatagouwaws yakamiy!” ");
INSERT INTO myw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wankuyeim Yeisuw inoun in Beteseid, imeyes takatoun teitan, ilansa, “Tabta bukwabkwen matan toukwaw towen, ne?” ");
INSERT INTO myw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeisuw iligen, ivakaben, inow watoulan ven, igus matan, naman waseg ikabkwen, ikatigan, ilana, “Kukin tan?” ");
INSERT INTO myw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Itamnow matan, ilana, “Akin gamag mwasanin, tage askakin ma̱wana amweilok ininounas.” ");
INSERT INTO myw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Vayuwein mo ikabkwen matan, mo ikinbunik, bo ibwein. ");
INSERT INTO myw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeisuw mo ikayeb beiyum bein wanbunatum, ilana, “Awoum bukun waven.” ");
INSERT INTO myw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wankuyeim Yeisuw siney navamul ita̱vins wunsiyas ven wawnuwan Sisaliy, guyaw towen Pilip nikaleiwag wasigeis. Inounas wa̱ked, ikatiga̱nes navamuls, ilana, “Gamag idokeigs kal yey?” ");
INSERT INTO myw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iweis tasiyas, ilansa, “Gamag mwasanin idokes ya̱koum tabibapta̱ysein gamags towen Yon; tage mwasanin idokeims Ilaytiy yak, o mwasanin idokeims ya̱koum palopit teitan.” ");
INSERT INTO myw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yeisuw mo ikatiga̱nes, ilana, “Tage yakamiy, kudokeigs kal yey?” Iw to Pita, ilana, “Yak Kelis yak.” ");
INSERT INTO myw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mapuna Yeisuw idibakes, ilana, “Awoum gamag mwasanin bikakinsa yey Mesay Kelis yey; awoum kwamteleigs; awoum.” ");
INSERT INTO myw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wankuyeim mo ikatimlakes, ilana, “Gimgilitoun yey, kadiloka a̱bag bigeg singay; kadiloka bipiyaveigs tasiyas tammwayas sisiyas tanuwgwes lun situwa̱vek sisiyas takatimlakeins kaleiwag, mo bikatimateigs; yam kweitoun mo ba̱kit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anilivan towen kamnat; toge Pita ika̱nan, ilana, “Awoum kulivan ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeisuw itouvin, ikin navamuls, ikan Pita, ilana, “Kusineikik ya̱koum Seitan, amsinap ma̱wana gamag asisinap, nag ma̱wan Yowbad ansinap.” ");
INSERT INTO myw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ikous, mo idawes gamag babaw sisiyas navamuls, ikatuyouns imekes, mo idibakes, ilana “Kavel tan yakamiy sivinan bibkunig, kadiloka bipiyev nakaleiwag tatonen mo bikokew anklos tatonen va̱gan mo bibkunig. ");
INSERT INTO myw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Kavel-tan yakamiy sivinan bikayus mwamovan mo biyamkwen, tage kukin biyamkwen mwamovan peinan gunawotet, mo bises bwein. ");
INSERT INTO myw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Kukin gog bikow wuliyoug meivek-wan, ven watinow wuliyougwan, mo biyamkwen mwamovan, adok nag bimwa̱saw, nag. ");
INSERT INTO myw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","“Aveiyag mo bisek maysan silma̱nin mwamovan, ne? Nag. ");
INSERT INTO myw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Tut towen gudwouvaws tappeyaws o asisinap babaw kalbaleb. Tage kukin kal bimsin agulivan mamagina bimseneig Gimgilitoun yey; o yey-vak ma̱wan igaw tamag mititeilin waseg ba̱yum bam sigwey Yowbad nataka̱yobs, mo beivag agumwasin gamag towen waseg.” ");
INSERT INTO myw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mo idibakes, ilana, “Mounid adibakeimiy, mwasanin yakamiy nukutablawaws wasalig nag bukukwanigs tage bukusesus-wan mo bukukines Yowbad nakaleiwag beim, son natawtoun.” ");
INSERT INTO myw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Yam kweinim katanok ikous, Yeisuw mo itokes Pita, Yemes, Yon, ikatulags ineis koy avakaein wakunuwatan; tasiyas-wan isiwas. Wamtes mo ivag ankakin kweitan, anakweim ivag ankakin gimagim, pwapwa̱kaw igegayous; nag teitan gamag ven watinow anakweim bivag pwapwaka̱wun ma̱wan, nag. ");
INSERT INTO myw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mo ikines Ilaytiy son Moses isaps, sisiy Yeisuw illivans. ");
INSERT INTO myw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Iw to Pita, idibek Yeisuw, ilana, “Tamwey, bo tamwa̱saws peinan tasesus towen; bakawlul bunatoun bwan, bunatan ya̱koum, buniyuwein Moses, buntounun Ilaytiy.” Anilivan ma̱wana illivan mav; na-ikakin aveiyag bilivan, peinan aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mo lov kweitan ilumwes tasiyas, aygan teitan iliganes wa̱lov, ilana, “Mtowen natug bwanabwein, kuliganes aygan.” ");
INSERT INTO myw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nuwanaw mo ikins palatan palatan, makaw; misinaka Yeisuw sisiy. ");
INSERT INTO myw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wankuyeim iwloubus, idibakes, ilana, “Youd towen nukukines, awoum kwamteles gamag mwasanin wasigeis ee... Gimgilitoun yey bakanig, ba̱kit vayuwein, mo kwamteles wasigeis.” ");
INSERT INTO myw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Youd towen nag ikamteles gamag mwasanin wasigeis; tage tasiyas-wan illivans, idokes aveiyag silawun anilivan towen, “Bakanig mo ba̱kit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iweis tasiyas, ilansa, “Aveiyag wawun tasiyas takatimlakeins kaleiwag asilivan, ilansa, ‘Kadiloka Ilaytiy bimgwey Mesay waseg’?” ");
INSERT INTO myw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yeisuw gog mo idibakes, ilana, “Ilaytiy iginmug, ikatilow youd babaw. Tabta kukwakins silawun Bukitab liva̱nen Gimgilitoun nises, mamagina, ‘Gamag bipiyaves; a̱ban bigeg singay’? Adibakeimiya mtowen-vak Ilaytiy bo neim, itam ninous mo iyagages towen, ma̱wan liva̱nen nises Bukitab waseg.” ");
INSERT INTO myw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yeisuw siney navamul asteitoun, tavasin gog mtowen, mo iwloubus iwekes navamul meivek-wan watinow nisesus, ikines gamag singay babaw nisiwnis, tasiyas takatimlakeins kaleiwag nikikamnimans sisiyas navamul mwasanin. ");
INSERT INTO myw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gamag babaw ikines Yeisuw bo neim, isom ninous, isawls inekes, imulouls sisiy. ");
INSERT INTO myw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iw to Yeisuw, ilana, “Aveiyag silawun mikamniman?” ");
INSERT INTO myw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Iw teitan gamag, ilana, “Tamwey, natug towen amey va̱gan bukukin, peinan yeiluw neiweiy bo ikakon. Kukin beiweiy mo bikalavatouw bikabala̱wein, beipoul wadon, bikakil kimwatun, bilamtumweitol won. Bo adibakes muvamuls va̱gan bikayabes. Iyokons bo nag.” ");
INSERT INTO myw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iw to Yeisuw, ilana, “Takakons yakamiy! Tut kadiveiyov sigwey yakamiy nitasesus bo asoumat. Gwad towen kumey waseg yey.” ");
INSERT INTO myw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Imeyes gwad towen waseg Yeisuw, yeiluw ikin Yeisuw, iweiy gwad towen, itatat won, ikalivatow wapwepway, ikanivnavin, ipoul wadon. ");
INSERT INTO myw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Yeisuw mo ikatigan taman, ilana, “Kweivin tut ankatoun ma̱wan?” Ilana, “Igaw-o wagwa̱din. Tut babaw iwaweiy, ikalivatow in wa̱kov o wayvagam, sivinan bilbaleb. O Tamwey, tabta binok nuwam yakamey? Tabta ikadilokeim bukulabem?” ");
INSERT INTO myw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iw to Yeisuw, ilana, “Aveiyag wawun amlivan kulana, ‘Tabta ikadilokeim’? Kukin bitasimounid, sinap o wotet babaw mo bikadilokeid.” ");
INSERT INTO myw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gwad to taman mo igel, ilana, “Asimounid-wan; tage kulabeig va̱gan basimounid beibwein.” ");
INSERT INTO myw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeisuw gog ikin gamag babaw isisawls imimeis, mo idibek yeiluw towen, ilana, “Yeiluw yak, gwad towen nukuvag nikakon, adibakeim kulisow gwad towen, kusiwana, awoum kuvgavaw bukumek gwad towen; awoum.” ");
INSERT INTO myw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iligen, mo iwak, iweiy gwad towen, itatat won, mo ilisow gwad kabalamat nimmasis ma̱wana takanig, babaw gamag idokes bo ikanig. ");
INSERT INTO myw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yeisuw gog iyous naman, itamnow gwad towen, itamanaw. ");
INSERT INTO myw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wankuyeim Yeisuw mo inoun in isiw wabunatum, navamul mo inekes, tasiyas-wan illivans, ilansa, “Aveiyag wawun na-ikadilokem bakakayeb?” ");
INSERT INTO myw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iw to Yeisuw, ilana, “Singay keikay anka̱yob bitakayabes tasiyas; misinaka bitanitoug waseg Yowbad mo bitakayeb.” ");
INSERT INTO myw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ilisawes ven towen, mo ikanpeles Galiliy, inounas; tage nag sivinan gamag bikakins. ");
INSERT INTO myw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Inawotet gog ikatimlakes navamuls, ilana, “Gimgilitoun yey, teitan gamag bisilkodeig mo gamag mwasanin biyousigs, beiweigs bakanig, bammasis kweitoun yam mo ba̱kit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anilivan towen na-ikakins tasiyas; aspwa̱yat bikatiga̱nes silawun livan towen. ");
INSERT INTO myw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Inounas ineis ven Kapaneyum, isiws wabunatum, mo ikatiga̱nes, ilana, “Aw-livan wa̱ked nukuliva̱nes, ne?” ");
INSERT INTO myw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tasiyas gog isesusa ikka̱pays, peinan wa̱ked nikamnimans, idokes kal biguyaw. ");
INSERT INTO myw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mapuna isin, idawes tasiyas sinawatan teiy, imeis, idibakes, ilana, “Kal yakamiy sivinan biguyaw, kadiloka bimlatoul, babaw gamag bimugwas, mtowen bikuyeim, o bikanow ages gamag babaw.” ");
INSERT INTO myw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ilivan ikous, mo itok gwad teitan, imey, isein wamtes tasiyas, mo inup iwlibob, idibakes, ilana, “Kal ya̱koum bileb teitan gwad, ma̱wana gwad towen, peinan gungamag towen, mamagina bilabeig yey, o mamagina bileb mtowen Tamag nikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iw to Yon, ilana, “Tamwey, nakakin taw teitan ikayabes yeiluw, yagam yak waseg, kasilbwed, peinan nag ibwa̱kun wasigeis ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Yeisuw gog ilivan, ilana, “Awoum kusilbwed. Nag kal biwotet tawtoun yagag waseg mo nuwanaw bitawyageig, nag. Kukin kal nag isilbwadeids mamagina ilabeids-nan. ");
INSERT INTO myw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Kukin kal bisekeimiy amisoup bukumoums peinan kuwteles Kelis nawotet, mounid adibakeimiy nag biyamkwen maysan mtowen. ");
INSERT INTO myw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Gamagal tasiyas isimounids waseg yey, kukin kal bikatsilakes silma̱nin bikakins sinap kalbaleb, singay kalbaleb mo bilouvat gamag towen. Kukin gamag mwasanin bikawes dakul avakaein biyawanis kayon mo bilaves bein wabwanit, nakalbaleb towen kalamwey; tage kukin bisesuna ee... bikatsilek teitan gwad, singaya kalbaleb mo bilouvat. ");
INSERT INTO myw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Kukin gog namam bikatsilakeim silma̱nin amsinap kalbaleb, kadiloka kubob, wankuyeim namam palatanok mo bukuban mwamovam. Awoum namam paley bilaveims bukun wadiginasim, kov nigidaged bigabum tut nag beikous. ");
INSERT INTO myw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO myw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Kukin gog kakeim bikatsilakeim silma̱nin amsinap kalbaleb, kadiloka kubob, wankuyeim kakeim palatanok mo bukuban mwamovam. Awoum ge kakeim paley bilaveims bukun wadiginasim. ");
INSERT INTO myw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO myw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","“Kukin matam bikatsilakeim silma̱nin amsinap kalbaleb, kadiloka kugut kulev, igaw wankuyeim matam palatanok mo bukusiw wanuwan Yowbad nakabkaleiwag. Awoum matam paley bilaveim bukun wadiginasim; simwa̱mwats bitatets wa̱wom; o kov bigidaged-wan; nag beimat. ");
INSERT INTO myw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kov bigabuds va̱gan bitayayan. ");
INSERT INTO myw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol bwanabwein bo bwein. Kukin gog sol bigeg, nag sabal-nen bitaban vayuwein. Sol bises wasigeis yakamiy bo bwein, va̱gan bukumsamwas simsimiyas wasigeis.” ");
INSERT INTO myw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ikous, mo itamanaw Yeisuw, inoun in wawnuwan Yudiy mo iga̱pel lay Yoldan, in palatan. Vayuwein-vak gamag babaw mo ikatuyouns ininekes Yeisuw, mo ivgavaw katimlakay gamag wasigeis, peinan nawotet tut babaw ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tasiyas gog Palisiy mo inekes Yeisuw, sivines kid biyakwanes, mo ikatiga̱nes Yeisuw, ilansa, “Tab kadilok bitapiyev dakwav, ne?” ");
INSERT INTO myw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iw to Yeisuw, ilana, “Kweiboug Moses bo isekeimiy mikaleiwag, ama̱wan?” ");
INSERT INTO myw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ilansa, “Moses bo itam, nakaleiwag ma̱wan towen, kukin vin bitapiyev, inalet bitalel tasek mo tapiyev.” ");
INSERT INTO myw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iw to Yeisuw, ilana, “Peinan ninoumiy keikay yakamiy, mo isekeimiy nakaleiwag towen. ");
INSERT INTO myw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","“Tage kweiboug Yowbad niginbun gamag kuda̱taw son kuda̱vin, mapuna taw bilisow taman son inan, binek nakwav, mapuna asteiy bimlavag wous katanok. Nag teitan na̱tan, nag; wous bo ilatanes imlavag katanok-wan. ");
INSERT INTO myw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","“Peinan Yowbad bo ilaten, awoum gamag bilivis, awoum.” ");
INSERT INTO myw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ikous, iyums ineis wanbunatum, navamul mo ikatiga̱nes vayuwein, sivines kid bikakins silawun nakatimlakay towen. ");
INSERT INTO myw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yeisuw mo idibakes, ilana, “Kukin kal bipiyev nakwav, bivevaw gog nayuwein vin, mo biyageg nakwav tatonen, peinan taggeinawl towen ikanavay mav. ");
INSERT INTO myw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“Na̱wen-vak kukin bipiyev namwan, o beivay gog son tayuwein taw mo bikanavay mav.” ");
INSERT INTO myw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wankuyeim gamag mo imeyes nitsiyas, sivines Yeisuw naman bisen wawous. Tage navamul idokes kid bisilbwades gamagals, awoum kid bimekes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeisuw gog ikines, mo ika̱nes, ilana, “Gamagal bweina bimeis waseg yey. Awoum kusilbwades, peinan tasiyas wanuwan Yowbad nakaleiwag mamagina gamagal. ");
INSERT INTO myw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Mounid adibakeimiy, kukin beivag ninoumiy ma̱wana gamagal mo bukutams Yowbad nakaleiwag waseg, mo bukusiws wanuwan. Kukin gog nag, bo nag.” ");
INSERT INTO myw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ilivan ikous, iwliboub gamagal wasigeis, naman isen wawous, anilivan bwanabwein mo isekes gamagal tasiyas. ");
INSERT INTO myw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ikous, ininoun wa̱ked, mo teitan taw isawl inek, ikulul avakaein wamatan, ilana, “Takatimlakay bwanabwein yak, aveiyag bavag mo mwamovag nag beikous?” ");
INSERT INTO myw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","19","Iw to Yeisuw, ilana, “Aveiyag wawun kudokeig toubwein yey? Toubwein anmwa̱net Yowbad. Adok kaleiwag tasiyas kukwakin: awoum kuweiy gamag, awoum kwanavay mav, awoum kuveinaw, awoum kuyaweid, awoum kusilponay, o kuvna̱ses tamam son inam.” ");
INSERT INTO myw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iwa̱ge, ilana, “Tamwey, igaw-o wagwa̱dig asilamaw kaleiwag tasiyas oko nagein igawa avvalut kaleiwag tasiyas wasigeis.” ");
INSERT INTO myw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Togo Yeisuw ikin taw towen, ikalin nuwan waseg, idibek, ilana, “Katanoka sinap ika̱bwag waseg yak, kadiloka kuymayis muvavag babaw, maysan kukow, kuvgen, kusekes tasiyas tasimavs, mo kum kubkunig; tage maysan bwein igaw mo bukuban walba̱lab.” ");
INSERT INTO myw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mto taw bo isisiyuw nanon, mo itamanaw, inoun, singay igeg nanon, peinan nawliyoug babaw, ikayus. ");
INSERT INTO myw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeisuw gog itouvin, idibakes navamul, ilana, “Singay keikay tasiyas guyawaw beisiws wanuwan Yowbad nakabkaleiwag waseg.” ");
INSERT INTO myw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Navamul gog iliganes anilivan sitovek, bo isunasun ninous. Vayuwein Yeisuw mo idibakes, ilana, “Sigwey, singay keikay tasiyas guyawaw beisiws wanuwan Yowbad nakabkaleiwag waseg. Mansiyas kamel beisiws vas analeg kalimwey-nen keikay, tage guyawaw beisiws Yowbad nakabkaleiwag waseg, singaya keikay.” ");
INSERT INTO myw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tasiyas gog singay isunasun ninous, illivans sisiyas, ilansa, “Kalisiy kid beisiws Yowbad nakabkaleiwag waseg?” ");
INSERT INTO myw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeisuw bo ikinbunikes tasiyas, ilana, “Gamag wasigeis na-ikadilok, tage Yowbad bwein kadilok, peinan Yowbad kadilok youd babaw.” ");
INSERT INTO myw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iw to Pita, ilana, “Yakamey gog nakapiyev mavavag babaw mo kabkunim.” ");
INSERT INTO myw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yeisuw ilana, “Mounid adibakeimiy, kal yakamiy bilisow naven, budan, nunet, inan, taman, nitun, o napwepway, va̱gan bikanow agulivan bwanabwein, nagein tut towen mo biban lakatutan nabunatum, budan, nunet, inan, nitun, napwepway; tage gamag mwasanin biyagages; igaw gog tut wanakougwaw mwamovan bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Tage babaw tasiyas tumumug bikuyeims, o tasiyas takukuyeims mo bimugwas.” ");
INSERT INTO myw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","34","Inounas wa̱ked bineis kid Yelusalem, Yeisuw imug, navamuls wankuyeim bo ikubukub nuwes, sisiyas bod mwasanin wankuyeim aspwa̱yat. Inounas ee... mo idawes navamul sinawatan teiy, vayuwein inekes, ikamteles aveiyag igaw mo bilivet, ilana, “Bitaneis Yelusalem, teitan gamag mo bisilkodeig Gimgilitoun yey, mo biyousigs tasiyas tanuwgwes lun situwa̱vek sisiyas takatimlakeins kaleiwag, biyateleigs bisekeigs wasigeis tobwag ven gimgilis va̱gan beiweigs, bikatimateigs; tasiyas gog bisiba̱weigs, bigusugs, biwaweigs vatul waseg, ikous mo bikatimateigs; yam kweitoun mo ba̱kit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebidiy nitun tasiyas Yemes son Yon mo inekes Yeisuw, ilansa, “Tamwey, sivinem bukutam aveiyag bakalivan.” ");
INSERT INTO myw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ilana, “Aveiyag sivinamiy?” ");
INSERT INTO myw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iweis tasiyas, ilansa, “Igaw muguyaw waseg, kutam va̱gan bakasin teitan wamkwa̱tay, teitan wamkimaw.” ");
INSERT INTO myw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeisuw idibakes, ilana, “Nag kukwakins silawun mikanitoug towen. Tab kadilok bukumwamwes kwa̱vig towen ba̱moum, o tab kadilok bibapta̱yseimiy ma̱wana bibapta̱yseigs yey?” ");
INSERT INTO myw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","Ilansa, “Ikadilokem-wan.” Iw to Yeisuw, ilana, “Mounid bukumwamwes kwa̱vig towen yey ba̱moum o bibapta̱yseimiy ma̱wana bibapta̱yseigs yey; tage nag kadilok bakaliwageimiy va̱gan bukusinis wagunka̱tay o wagunkimaw, nag. Tamag nakaleiwag towen, bikaleiwag kalisiy bisinis wadadag.” ");
INSERT INTO myw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Navamul gog tasiyas sinawatan iliganes, mo ikawkunes Yemes son Yon. ");
INSERT INTO myw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mapuna Yeisuw idawes bimeis, binekes; imeis mo idibakes, ilana, “Kukwakinsa tasiyas idokes guyawaw tobwag ven wasigeis, ikaliwages sigamag, siwotet kweitan kweitan isekes biwteles. ");
INSERT INTO myw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Tage yakamiy nag ma̱wan. Kal yakamiy sivinan biguyaw bweina bimlavag mitouwat. ");
INSERT INTO myw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","“Kal yakamiy sivinan bimlavag mitamumug, kadiloka biwotet silma̱nin miwotet. ");
INSERT INTO myw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Gimgilitoun yey bo ma̱wan, nag am va̱gan bukulabeigs, tage balabeimiy yakamiy, o mwamovag batam mamagina baymiyiseimiy tababaw yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ikous anilivan towen, inounas oko ineis Yelikow, ikanapels Yelikow binounas siney navamul sisiyas gamag babaw. Toukwaw teitan nissin wadadan ked ininitoug money wasigeis gamag babaw; yagan Batamiyas, peinan taman yagan Tamiyas. ");
INSERT INTO myw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Toukwaw towen iligen butun gum-Nasalet yagan Yeisuw, peinan bo neim, mo iwak, ilana, “Yeisuw, ya̱koum Deibid tabun ya̱koum, binok nuwam yey.” ");
INSERT INTO myw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Babaw gamag bo ika̱nes, ilansa, “Kukwa̱pay.” Togo singaya iwkuwak, ilana, “Ya̱koum Deibid tabun ya̱koum, binok nuwam yey.” ");
INSERT INTO myw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeisuw gog im itom, ilana, “Kudibakes beim.” Mapuna idibakes toukwaw towen, ilansa, “Bweina kutamanaw kum. Bo idaweim.” ");
INSERT INTO myw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Togo ilavew anpwa̱lum, nuwanaw mo itamanaw, inoun inek Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Inek Yeisuw, Yeisuw ikatigan, ilana, “Aveiyag sivinam bavag peinam yak?” Iw toukwaw towen, ilana, “Tamwey, sivinag beilal matag.” ");
INSERT INTO myw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeisuw gog idibek, ilana, “Nukusimounid waseg yey, mapuna bo kubwein; bweina kunoun.” Nuwanaw ilal matan, mo ibwa̱kun Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yeisuw inoun in wunsiyas ven Betepeig o Betaniy, walasin koy yagan Oliv, kakita mo bisap Yelusalem waseg. Mapuna mo idibakes navamul asteiy va̱gan bimugwas kid bineis ven wunkakit, ilana, “Kuneis ven towen wamatads, bukusiws wanuwan mo bukuba̱nes donkiy na̱tan, kayon niyawanis vatul waseg, gamag nag itotouws waseg. Igaw. E, bukuba̱nes mo kulikus vitulen, kutokes kumeyes. ");
INSERT INTO myw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Kukin teitan gamag bilivan, bilana, ‘Aveiyag wawun kulikus donkiy na̱wen?’ kulansa, ‘Tanuwagan sivinan. Nawotet biyakous, mo biyamen.’” ");
INSERT INTO myw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inounas tasiyas mo iba̱nes donkiy wavtakon ven, niyawanis kayon wamatan koukwed nititoy, mo ilikus vitulen. ");
INSERT INTO myw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ilikus vitulen, tage gamag mwasanin nitablawaws wadadan ilivans gog, ilansa, “Aveiyag wawun kulikus donkiy mana̱wen?” ");
INSERT INTO myw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mo ikatimapus ages ma̱wana Yeisuw nikatimlakes; ilivans ma̱wan, mo itams. ");
INSERT INTO myw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Itams tasiyas, mo imeyes donkiy waseg Yeisuw, asikweim isenas watapwan mo imwen isin wakunuwatan. ");
INSERT INTO myw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mwasanin gog asikweim iyaves wa̱ked, mwasanin isa̱ves amweilok yayagein wanawoud iyaves wa̱ked. ");
INSERT INTO myw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tasiyas tamumugwas sisiyas takkuyeims iwkuwaks, ilansa, “Osana! Yowbad bikatinabweids. Kakavasim nukum daGuyaws yagan waseg. ");
INSERT INTO myw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tamads Deibid nakaleiwag bukuwgow. Tanuwagan liba̱lab bo bikatinabweids.” ");
INSERT INTO myw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeisuw inoun in wunovek Yelusalem, isiw in wanuwan Yowbad nabunatum bunavakaein, ikin palatan palatan, youd babaw ikikin ikous, mo iyum ineis Betaniy siney navamul; bo iboug. ");
INSERT INTO myw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iyam nen ga̱boug ilisawes Betaniy bineis Yelusalem, ivag anamoun. ");
INSERT INTO myw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Anamoun, ikin kadiveiyov yaveinun nitet, sam yageivein, idoki anagin biban beikam; iwekey gog nag; makava yageivein. Peinan nag tutan beiwuw. Igaw. ");
INSERT INTO myw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iw to Yeisuw, ikawtun kay kaywen, ilana, “Adok nag bukuvgavaw beivag anagim, beikams gamag, nag.” Navamul iliganes anilivan towen. ");
INSERT INTO myw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Inounas ineis Yelusalem, isiws wanuwan Yowbad nabunatum mo ikayabes tasiyas taggimmwals wabunatum, siteibol ikatitan tasiyas nikatimapus money dakul waseg, o ikatitan abes tasiyas niggimwals bwabun. ");
INSERT INTO myw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nag itam va̱gan gamag bikokews kunes wanuwan Yowbad nabunatum. ");
INSERT INTO myw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ikatimlakes, ilana, “Bukitab wanuwan livan nises mamagina: ‘Ven babaw gimgilis bidokes gunbunatum nitoug buntuman.’ Tage yakamiy nukuvkakes mamagina buntuman veinaw.” ");
INSERT INTO myw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tasiyas gog tanuwgwes lun sisiyas takatimlakeins kaleiwag iliganes anilivan, sivines kid ama̱wan bivkakes mo biyablebes; tage iwenes peinan gamag babaw igoulus, sivines biliganes nakageiguy. ");
INSERT INTO myw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kwayav waseg Yeisuw siney navamul mo ilisawes wunovek. ");
INSERT INTO myw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iyam nen ga̱boug, ininounas wa̱ked, mo ikines yaveinun bo ikallayaga ikous. ");
INSERT INTO myw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita inuway, mo ilivan ilana, “Tamwey, kay kaywen nukwawtun bo ikalayag.” ");
INSERT INTO myw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Iw to Yeisuw, idibakes tasiyas, ilana, “Livan mounid badibakeimiy. Kadiloka kunmises Yowbad va̱gan wotet tawtoun biwtel. Kal yak bukubidek koy towen, kulana, ‘Kunoun kun kumukul wabwanit,’ tage nag beivag nanoum akweiy, bukunamisa-wan, mo bivag ma̱wana amlivan nukulivan. ");
INSERT INTO myw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Mapuna badibakeimiy, kukin bukukululs bukunitougs Yowbad waseg, kukwakins-wan bisekeimiy, mo bukuba̱nes youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Kukin bukunitougs Yowbad waseg, aveiyag gamag asisinap waseg yakamiy kuninuwes, kunumlaves, bikalin nuwamiy. Igaw Tamads walba̱lab mo biwidimiy binumlev amisinap kalbaleb yakamiy.” ");
INSERT INTO myw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO myw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Wankuyeim mo inounas, vayuwein ineis Yelusalem. Ineis Yelusalem, Yeisuw ininoun wanuwan Yowbad nabunatum, mo iweis tasiyas tanuwgwes lun situwa̱veks sisiyas takatimlakeins kaleiwag sisiyas tammwayas, inekes Yeisuw, ilansa, “Aw-kaleiwag towen? Kal isekeim mukwaleiwag silma̱nin muwotet towen?” ");
INSERT INTO myw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iw to Yeisuw, ilana, “Kweitan youd bakatiga̱neimiy, kudibakeigs, mo badibakeimiy silawun gunakaleiwag silma̱nin gunawotet towen. ");
INSERT INTO myw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“E, kudibakeigs silawun Yon inawotet waseg ibapta̱yses gamags. Tabta Tamads walba̱lab isek nawotet towen, o gamag teitan watinow isek nawotet? Kudibakeigs silawun nawotet Yon.” ");
INSERT INTO myw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iliganes, illivans sisiyas, ilansa, “Kukin bitalansa, ‘Tamads walba̱lab,’ mtowen Yeisuw bikatimop aygads bilana, ‘Aveiyag wawun nag kusimounids waseg mtowen Yon?’ ");
INSERT INTO myw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Tage awoum talansa, ‘Gamag teitan isek nawotet’; mata ge gamag babaw biyagageids, peinan isimounids waseg Yon, idokes palopit tatonen.” ");
INSERT INTO myw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mapuna ikatimapus Yeisuw aygan, ilansa, “Nag kakakin.” Iw to Yeisuw, ilana, “Yey-vak ma̱wan, nag badibakeimiy kal nisekeig gunawotet towen.” ");
INSERT INTO myw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ikous, mo isilamaw nakabebay, isekes mamagina, “Bigulen gleip teitan tamwey isop; kal ilev ikous wadadan bag palavas; wayn kasinen ivkaes ikous; tamtakavatein bag nabunatum iwlul ikous; mo isekes gamag mwasanin siwotet va̱gan biwwotets inabag, mo inoun in kweitan ven, isiw. ");
INSERT INTO myw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Wankuyeim anagin tutan bo bimwanoug ivag sivinan bikamkwen, mo ikayeb natouwat binekes tasiyas tawteleins bag, anagin bikow bimey, tamwey towen bikamkwen. ");
INSERT INTO myw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","“Inekes, mo iwaweiys; nag kan isekes, ikayabes, makava iyum. ");
INSERT INTO myw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Mo ikayeb tayuwein-vak, inekes tasiyas tawteleins bag, iwaysa wakunun iyagages; mo iyum. ");
INSERT INTO myw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Im, ikayeb-vak tatounun; in mo iweiys, ikatimates. Wankuyeim ikayabes babaw, mwasinis iwaweiys, mwasinis ikatimates. ");
INSERT INTO myw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ikous natouwats babaws, anmwa̱net natun tatonen nises, mo ikayeb binekes; ilana, ‘Bo bivna̱ses natug o bisiwyoubus.’ ");
INSERT INTO myw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nag gog. Tasiyas tamtakavateins bag illivans, ilansa, ‘Kukines tamwey towen natun beim. Kumeis, taweiys; igaw gog tamwey towen bikanig, mo bitakawes dakiyays, bag towen.’ ");
INSERT INTO myw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Mo ituts, inekes, iweiys taw mtowen, tamwey natun, mo inupes, ilaves, in watoulan bag. ");
INSERT INTO myw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tamwey taginibag towen ininuway, ilana, ‘Aveiyag bavag?’ Adok bo binekes, tasiyas tamtakavateins bag bikatimates, bisek gog siwotet gamag mwasinis wasigeis. ");
INSERT INTO myw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Adok nag kukwakins liva̱nen, Bukitab waseg nises mamagina: ‘Wululay towen, tawteleins bunatum nipiyaves, tage bo imlavag anma̱wamwan bunatum. ");
INSERT INTO myw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","DaGuyaws nawotet towen; bo isom nanouds.’” ");
INSERT INTO myw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yeisuw anilivan iyakous, tasiyas ikakins-wan Yeisuw anilivan peinan asisinap kalbaleb, mo ikapasal nuwes, idokes kid biyousis Yeisuw beiweiys. Nag gog; aspwa̱yat peinan ikines gamag singaya babaw, mapuna bo ilisawes, inounas. ");
INSERT INTO myw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Min-Yudiy tasiyas mo ikayabes Palisiy mwasanin sisiyas Elod nagamag mwasanin, binekes Yeisuw bikatiga̱nes, bikines kukin beibol anilivan mo biyateles kid. ");
INSERT INTO myw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inekes Yeisuw, idibakes, ilansa, “Tamwey, kakakina ya̱koum amsinap kamnat. Nag bukuvnas gamag teitan mo bukupiyev kid son, nag. Nag kuninuway gamag askakin watoulan, nag. Tage mukwatimlakay mounid, Yowbad inaked silma̱nin. Tab kadilok bitapa̱yins Sisal nata̱kis, ne? Bitatams Sisal waseg o bitapiyaves adok?” ");
INSERT INTO myw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tage Yeisuw bo ikakin tayyaweids tasiyas, idibakes ilana, “Wawun kuyakwaneigs, ne? Money silma̱nin ta̱kis kumeyes bakin.” ");
INSERT INTO myw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Imeyes money dakul towen yagan danaliyus, ikin, ikatiga̱nes, ilana, “Kal gamag kululuwan nileles money towen waseg, o kal yagan nileles towen?” Iweis tasiyas, ilansa, “Sisal.” ");
INSERT INTO myw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeisuw mo idibakes, ilana, “Sisal navavag kutams Sisal waseg, o Yowbad navavag kutams Yowbad waseg.” Iliganes anilivan towen, bo isom ninous tasiyas. ");
INSERT INTO myw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Tasiyas Sadusiy asilivan, ilansa, “Takanigs nag beikits vayuwein.” Tasiyas gog inekes Yeisuw, ikatiga̱nes, ilansa, “Tamwey, kweiboug Moses nilel dakaleiwags mamagina: Kukin kal taw bikanig, natun nag, bwadan mo beivays son nakwab va̱gan bikop natun mo bimlavag tuwan natun. ");
INSERT INTO myw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Tamwey teitan, budan gog teinim tatanok; tamwey iginivay son nakwav, mo ikanig, natun nag. ");
INSERT INTO myw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","23","“Isiken mo ivay son nakwab, mo ikanig, natun nag. Isiken, isiken, isiken iveivaysa sisiy nakwab, imta̱mats, nitus nag, ee... iyakous tawaw, mo ikanig kuda̱vin na̱wen. Igaw beikits vayuwein takanigs tasiyas, vin namwan kavel; peinan babaw neivays sisiy?” ");
INSERT INTO myw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","25","Iw to Yeisuw, idibakes, ilana, “Adok bo ibol amilivan yakamiy, peinan nag kukwakins Bukitab anilivan, o nag kukwakins Yowbad natawtoun. Igaw beikits vayuwein mamagina anelos tasiyas walba̱lab, nag beivays, nag. ");
INSERT INTO myw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","“Tage takanigs bo beikits vayuwein. Adok nag kukwakins Yowbad anilivan Bukitab waseg, Moses kweiboug ikin kaligweg nigigob kov. Yowbad mo idibek, ilana, ‘Yey Ebelam naYowbad yey, vey Aysak naYowbad yey, yey Yekob naYowbad yey.’ Yowbad tamwamovs tasiyas siYowbad, nag imtakavates tasiyas takanigs, nag. Singay ibol ninoumiy.” ");
INSERT INTO myw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Teitan takatimlakein kaleiwag iligen sikatugwan waseg Yeisuw, ikakina nakatumap tawtoun, mo inek Yeisuw, ikatigan, ilana, “Aw-kaleiwag imug?” ");
INSERT INTO myw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Iw to Yeisuw, ilana, “Kaleiwag tamumug mamagina: Kuliganes min-Yisleil yakamiy, daGuyaws Yowbad anmwa̱net. Kadiloka kusiwyoubus daGuyaws Yowbad, ateimiy mounid kuta̱mes waseg, mwamovamiy mounid kuta̱mes waseg, ninoumiy mounid kuta̱mes waseg, mitawtoun mounid kuta̱mes waseg. ");
INSERT INTO myw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Kwayuwein kaleiwag mamagina: Kuvnas soum ma̱wana ya̱koum tatoneim nukuvna̱seim. Nag kweitan kaleiwag imgwayes tasiyas.” ");
INSERT INTO myw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","33","Takatimlakay towen idibek Yeisuw, ilana, “Singaya bwein mukwatimlakay. Amlivan mounid, peinan daYowbads anmwa̱net; nag tayuwein nises. Kaleiwag tasiyas nukulivan ilisawes mansiyas man bitagob va̱gan bitalun Yowbad waseg. E, bo imug kaleiwag tasiyas va̱gan bitasiwyoubus Yowbad a̱teids mounid waseg, datawtouns mounid waseg, o bitavnas sod ma̱wana ya̱kid tatoneid nitavna̱seid.” ");
INSERT INTO myw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yeisuw iligen, ikakina taw towen anilivan bwanabwein, idibek, ilana, “Ya̱koum kadilakusa Yowbad nakabkaleiwag bukukwakin.” Ikous, mo igoulus Yeisuw; bo iyakousis sikatugwan. ");
INSERT INTO myw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","36","Wankuyeim ikatimlakes gamag wanuwan Yowbad nabunatum, ilana, “Aveiyag wawun takatimlakeins kaleiwag asilivan, ilansa, ‘Kelis Deibid tabun.’ Kweiboug Yowbad Kululuwan ansinap ikatipel isek Deibid, ilana: ‘DaGuyaws idibek gunguyaw, ilana: Kusin wagunka̱tay va̱gan bava̱ges beibus siyas astameiliw yak, bukuvnivans wakunutes.’ ");
INSERT INTO myw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Mtowen Deibid tamwey, ama̱wan bidok tabun naGuyaw?” Yeisuw nakatimlakay gamag babaw sivines binganegs. ");
INSERT INTO myw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Yeisuw nakatimlakay wasigeis, ilana, “Kupiyaves asisinap tasiyas takatimlakeins kaleiwag. Sivines binounas asikweim vayvayov mo gamag bikululs wamtes wavtakon ven. Tapwa̱loul waseg sivines bisinis wa̱keb, o sagal waseg bisinis wapwa̱siw. ");
INSERT INTO myw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Tage tasiyas asisinap kalbaleb kupiyaves, peinan ikwekways nakwabs sivavag, mo sinitoug iveiyov. Tayyaweids tasiyas. Igaw Yowbad mo bimop asisinap kalbaleb, biyagagesa singay.” ");
INSERT INTO myw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeisuw isin wanuwan Yowbad nabunatum, ikin gamag babaw imimeis bimulouls. Simuloul ilaves in wanuwan didawag avakaein. Ikin guyawaw simuloul singaya avakaein. ");
INSERT INTO myw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wankuyeim mo ikin nakwab na̱tan nasimav isiw im, ilev namoney dakul kekel akweiy, mamagina akweiy toya. ");
INSERT INTO myw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeisuw ikin, idawes navamul, imeis, idibakes, ilana, “Mounid adibakeimiy nakwab mana̱wen nasimav namuloul ilisow simuloul tasiyas gamag babaw. ");
INSERT INTO myw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","“Tasiyas imulouls ikous, tage babaw simoney nises. Mana̱wen gog nasimav bo ililavena iyakous. Nag kweitan namoney nises va̱gan bigimwel kan beikam; nag.” ");
INSERT INTO myw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ikous, mo itamanaw, ilisow Yowbad nabunatum, binoun kid; navamul teitan mo idibek, ilana, “Tamwey, kukin wululay tasiyas dakul bwana̱bweins, o bunsiyas bunatum bunamna̱bweins-wan.” ");
INSERT INTO myw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iw to Yeisuw, ilana, “Bunsiyas bunatum bunuwka̱veks bo bigulekwes beikous. Nag kweitan dakul bises wakaban. Babaw-wan bigulekwes beikous.” ");
INSERT INTO myw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Inoun in koy yagan Oliv, isin, ikin Yowbad nabunatum palatan-o nises. Siyas Pita siney Yemes, Yon, Andiluw, tasiyas-wan asteivas mo ikatiga̱nes Yeisuw, ilansa, “Asina̱vin biva̱ges ma̱wan? Sivinem bakakakin anatut abivatus towen, bukulivan mo bakakakin youd tasiyas bisaps wadaban pwepway. Kudibakem va̱gan bakakakin.” ");
INSERT INTO myw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeisuw mo isilamaw anilivan, idibakes tasiyas, ilana, “Kuvna̱seimiy; awoum teitan gamag bikatidavimiy. ");
INSERT INTO myw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Tage babaw gamag biweis, mo bilansa, ‘Yey-aya!’ mo bikatidavis babaw gamag, bidokes kid Kelis. ");
INSERT INTO myw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Tage igaw mo bukuliganes bulagan naviy, naviy mwasanin kadilakus, mwasanin kadiveiyov. Bukuliganes, awoum beivag amipwa̱yat. Bo biva̱ges ma̱wan, tage nakabiyokous tut igaw. ");
INSERT INTO myw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Igaw bod mwasanin bikanaviys wasigeis bod ma̱wasanin, ven mwasanin bikanaviys wasigeis ven mwasanin. Nik beinik ven mwasanin waseg. Gamag bikamates moun. Bisilamaw ma̱wan simoumouvit kalamwey, tage watibwelon tut mo bivakaein singay. ");
INSERT INTO myw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kuvna̱seimiy; igaw mo biyateleimiy takaleiwag wamites, o sinagog wanuwan biwaweimiy, vatul waseg, o peinan agugwamag yakamiy bo bitamnaweimiy wamtes siyas gabman sisiyas guyawaw, mapuna livan bwanabwein mo bukusekes. ");
INSERT INTO myw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","“Tage wanmugwana bukukwawes liva̱neig bwanabwein kunawes, kugeiguys vena babaw wasigeis. Nakabiyokous tut igaw. ");
INSERT INTO myw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Avei-tut bitokeimiy bukuneis silma̱nin ya̱tal, awoum kuninuways aveiyag bukuliva̱nes, tage tut towen aveiyag bikamat waninoumiy bukulivans ma̱wan. Yakimiy amilivan nag, tage Yowbad Kululuwan anilivan. ");
INSERT INTO myw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tut towen wamatads tuwan teitan biyatel va̱gan beiweiys bwadan, o times biyateles va̱gan beiweys nitun, o gamagal gog bitamanaws mo biyagages beiweiys timsiyas o insiyas. ");
INSERT INTO myw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","“Gamag babaw mo bikamliweimiy peinan agugwamag yakamiy. Tage bweina kwaptuleimiy; igaw nakabiyokous tut waseg mwamovamiy mo bukuba̱nes. ");
INSERT INTO myw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Igaw mo bukukines takalbaleb singay bitet ven bwaboum waseg. (Kal bivin mo bikakin silawun livan towen.) Kukines, magat Yudiy bukusesus, kadiloka kusawls kuneis wa̱koy. ");
INSERT INTO myw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Kukin kal bisesuna wapwa̱siw, kadiloka bisawl, awoum biyoubaw beisew bikow nawliyoug; awoum. ");
INSERT INTO myw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","“Kukin kal iwwotet wa̱bag, awoum beiyum bikow anakweim; awoum. ");
INSERT INTO myw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Tut towen wamatads siyas nakakuda̱poms bigeg abes sisiyas siyas nivvasus nitsiyas. ");
INSERT INTO myw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Kuntougis Yowbad, awoum ge bukusawls bulbweilim anatut loulun waseg. ");
INSERT INTO myw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Igaw tut towen beim, singaya gamag abes bibeg. Kweiboug Yowbad niginbuniyay nag ma̱wan. Bweilim babaw nag ma̱wan. Nagein nag ma̱wan. E, tut towen beim singaya gamag abes bigeg, tage nag vayuwein biwgow. ");
INSERT INTO myw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Magat daGuyaws nag bigidem yam mwasanin, adok babaw gamag bikanka̱nigs beikous. Tage peinan bo ikatigik nagamag mwasanin bikatimoves, mapuna bibob yam mwasanin. ");
INSERT INTO myw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tage tut towen wamatads, kukin kal bilivan, bilana, ‘Kukines Kelis towen-one,’ o bilana, ‘Towen-an nises’, awoum kusimounids. ");
INSERT INTO myw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Igaw bisaps yaweid Kelis mwasanin, o yaweid palopit mwasanin, bikatidavis gamag. Mulin nimes biva̱ges tawtoun mo bikatidavis gamags. Magat kadilokes mo bikatidavis Yowbad angamag tasiyas nilivnakes. ");
INSERT INTO myw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Kuvna̱seimiy; peinan bo akatiboug nuwamiy mo kukwakins aveiyag bukulivatus tut wanakougwaw. ");
INSERT INTO myw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Tut towen wamatads, abes singaya bigeg, ka̱las biladadub, o tibukon bikayus mititeilin. Siyas wutun walba̱lab bikalka̱louws. Aveiyag tawtoun nises walba̱lab mo beigwey. ");
INSERT INTO myw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“E, mo bukukineigs Gimgilitoun yey baw, lov waseg, son guntawtoun o mititeilig avakaein. ");
INSERT INTO myw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","“Mo bakayeb guntakayobs bikatinakus agugwamag tasiyas meinoy nimeis ven katanok katanok wadaban pwepway. ");
INSERT INTO myw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","29","“Yaveinun waseg kabebay kweitan nises. Igaw biya̱sus mo bukukwakins, bukulansa, ‘Wuwal bisilamaw.’ Yakamiy ma̱wan, bukukines youd tasiyas mo bukukwakins kakita mo ba̱yum baw. ");
INSERT INTO myw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Mounid adibakeimiy gudwouvaws yakamiy, igaw bukusesus ee... mo bukukines youd siyas babaw. ");
INSERT INTO myw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Liba̱lab son pwepway beikous tage agulivan nag beikous. ");
INSERT INTO myw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yam towen nag takakins. Nag takakins ga̱boug o kwayav o boug adok. Nag takakins. Yowbad natun yey nag akakin. Tamag anmwa̱net ikakin. ");
INSERT INTO myw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Kuvna̱seimiy, kula̱lals. Nag kukwakins asina̱vin ba̱yum bam. ");
INSERT INTO myw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Nagein ma̱wan teitan gamag bein bita̱vin palatan, tage inagamag bimtakavates inaven. Tamwey towen bisekes siwotet kweitan kweitan; tamtakavatein gog koukwed bidibek bilana, ‘Kwaymateig ga ba̱yum.’ ");
INSERT INTO myw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kukwayamatsa beibwein. Nag kukwakins asina̱vin bunatum tanuwagan beiyum, adok kwayav, adok watapwan boug, adok walalayis, adok ga̱boug. Nag kukwakins. ");
INSERT INTO myw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Awoum kumasis kwangagays, mata ge bilabuboleimiy geg. ");
INSERT INTO myw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Adibakeimiy, o babaw gamag badibakes ma̱wan, ‘Kwaymateigs beibwein!’” ");
INSERT INTO myw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Igaw akweiy yam mo Kaltuwon Sigeilin bisagals, makava bled beikams. Tage tanuwges lun situwa̱vek sisiyas takatimlakeins kaleiwag sivines kid beiweiys Yeisuw, idokes kid anmwa̱neta biba̱nes mo biyousis; mapuna ilansa, “Awoum bitayousis sagal wanuwan, mata ge gamag bikayuses mo bikawpwanaws adok.” ");
INSERT INTO myw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeisuw gog nises Betaniy, ikamkwam wanbunatum toulepel teitan, yagan Saymon, mo na̱tan vin isiw im, ikokew nabotol bwanabwein. Wanuwan nabotol tagon nises yagan nad, maysan singay avakaein. Ikatuv nabotol, mo ilgubok kunun Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Mwasanin gog mo ivtokays livan, idibakes sisiyas, ilansa, “Aveiyag wawun iyamkwen tagon towen? Kadiloka bitayamiyis, bitakow lakatutoun kina, mo bitavgen tasekes tasiyas tasimavs.” E, singaya ikawkunes mana̱wen vin. ");
INSERT INTO myw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","7","Yeisuw gog idibakes, ilana, “Deis! Awoum kutawyages mana̱wen vin; nawotet singaya bwanabwein waseg yey. Tasimavs tut babaw simiyas kusesus, asina̱vin sivinamiy bweina bukulabes. Yey gog kweitan, nag simiy yey bitasesun-wan tut babaw, nag. ");
INSERT INTO myw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Wotet towen ikadilok mana̱wen waseg mo niwtel waseg yey. Bo iptum woug nanawan, silma̱nin alawag. ");
INSERT INTO myw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Adibakeimiy igaw ven babaw bigeiguys liva̱neig bwanabwein waseg, mo nawotet mana̱wen vin biliva̱nes va̱gan gamag babaw mo bininuways.” ");
INSERT INTO myw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mtowen gum-Iskaliyot yagan Yudas, Yeisuw navamul teitan, mo inekes siyas tanuwgwes lun situwa̱veks, sivinan kid bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iliganes Yudas anilivan, mo ikalin nuwes, ilivnakes namoney bisekes, maysan nawotet towen. Itam, mo ikayamat tut bwanabwein va̱gan basilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yam towen bisilamaws makava bled bikamkwams, o biwaweiys Kaltuwon bulukwan, navamul idibakes Yeisuw, ilansa, “Nanoum yak, avanuy bakan bakakatineg va̱gan Kaltuwon Sigeilin bitakams?” ");
INSERT INTO myw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yeisuw iligen, ikayabes navamul asteiy, ilana, “Kuneis waven, bukulivatus taw teitan ikokew nakunasoup, kwabkunis taw towen. ");
INSERT INTO myw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","“Kwabkunis, kukines avei-bwan beisiw, kunekes tanuwagan bwan towen, kulansa, ‘Matovek ilana: Avanuy bwabwal mabunatum va̱gan baka̱kam Kaltuwon Sigeilin sigwey gunavamul.’ ");
INSERT INTO myw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Mtowen taw mo bikatimlakeimiy bukukines bunavakaein wanuwan nabunatum, wanakaew nises, bo ikatinages nanawan silma̱nin amkwam; towen waseg kuva̱ges kads.” ");
INSERT INTO myw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Navamul asteiy inounas ineis waven iba̱nes taw towen ibukunis, mo iba̱nes bunatum ma̱wana Yeisuw nilivnek, mo ikatinages Kaltuwon Sigeilin. ");
INSERT INTO myw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kwayav waseg Yeisuw mo isap siney navamul. ");
INSERT INTO myw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Isiws bunatum towen, isinis ikamkwams, Yeisuw mo ilana, “Tawaw, tasilkodeig teitan sods nitakamkwams.” ");
INSERT INTO myw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iliganes tasiyas, singaya igeg ninous, tatanok tatanok idibakes sitovek, ilansa, “Kal? Yey?” ");
INSERT INTO myw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iw to Yeisuw, ilana, “Yakamiy sinwatan amiteiy. Teitan yakamiy gog tasilkodeig soug kasow amabled wanuwan loutan. ");
INSERT INTO myw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Gimgilitoun yey ba̱noy ked towen Bukitab nilivnek, tage mtowen tasilkodeig singay kalbaleb bilivet. Magat inan nag bikop bo bwein, togo bo ikop, imligamag mo singay kalbaleb bilivet.” ");
INSERT INTO myw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Igaw ikamkwams, mo ikow bled kweitan, ikulul, ikalin nuwan Yowbad waseg, ikiv, isekes navamuls, ilana, “Kukwawes kukwams, peinan woug.” ");
INSERT INTO myw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Wankuyeim mo ikow kwa̱vig, itapwa̱loul, isekes, imoums asibabaw-wan; mo idibakes, ilana, “Towen buya̱vig silma̱nin kaleiwag kweivaw, iwta̱wout pinamiy babaw yakamiy. ");
INSERT INTO myw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Adibakeimiy nag vayuwein ba̱moum gleip sipinen ee... Tamag nakabkaleiwag waseg mo sipinen kweivaw ba̱moum.” ");
INSERT INTO myw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ikams ikous, wous kweitan ikanweles, mo isaps, ikatulags ineis wa̱koy yagan Oliv. ");
INSERT INTO myw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeisuw mo idibakes navamuls, ilana, “Babaw yakamiy bukulisaweigs, peinan Bukitab nilivnek mamagina: ‘Baweiy mtowen tamtakavatein sips, mo bikatigayays.’ ");
INSERT INTO myw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Wankuyeim ba̱kit vayuwein mo bamgwayeimiy bitaneis waGaliliy.” ");
INSERT INTO myw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iw to Pita, idibek natovek, ilana, “Magat babaw tasiyas bilisaweims, tage yey nag.” ");
INSERT INTO myw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeisuw idibek, ilana, “Adibakeimiy nagein, boug waseg bukukwaya̱neig siva̱toun, mo kolkolek beigel sivay nubweig ga̱boug.” ");
INSERT INTO myw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tage Pita anilivan tawtoun idibek, ilana, “Nag bakaya̱neim. Kukin bukumat, aditeiy soug yak bitamat.” Babaw asilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Inounas ines ven yagan Getsemaniy, idibakes navamuls, ilana, “Kusinis towen, yey ban anitoug Yowbad waseg.” ");
INSERT INTO myw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Itokes Pita, Yemes, Yon, asteivas ineis palatan, mo singay igeg nanon, anpwa̱yat seikwan. ");
INSERT INTO myw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Idibakes, ilana, “Singay igeg nanoug. Bo bakanig adok. Kusesus towen kukwaymateigs.” ");
INSERT INTO myw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Inoun in kadiyakus, imasis kantukov wapwepway, initoug Taman waseg, idok kid bigidem youd kalbaleb wamatan, kakita bo bilouvat, ilana, “Tamag, bo ikadilokeim youda babaw. Kuyamen agukwa̱vig towen; awoum ba̱moum. Nanoug yey awoum; tage nanoum yak kuvag ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","38","Iyum inekes navamul bo imasis, idibek Pita, ilana, “Bo kumasis, ne? Nag kadilokeimiy tut kadilakus-wan kwaymateigs. Kwaymateigs kunitougs; mata ge bukusiws abiyokon waseg. Ninoumiy waseg bukutawtouns; nag gog, woumiy tougweys.” ");
INSERT INTO myw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Vayuwein mo in palatan initoug, anilivan ma̱wan nilivan. ");
INSERT INTO myw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iyum inekes, vayuwein bo imasis, peinan mites bo inanup. Nag ikakins ama̱wan bikatimapus aygan. ");
INSERT INTO myw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Sivtounun inoun, initoug, iyum, ilana, “Bo kumasis, kuyeiwas, ne? Bo deis. Datuts bo ikous. Teitan gamag bo bisilkodeig Gimgilitoun yey; tasiyas takalbalebs bo biyousigs. Kukits, tanounas; tasilkodeig bo isap.” ");
INSERT INTO myw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Igawa illivan, navamul teitan, Yudas, isaps siney tasiyas takaweins pulut son new; peinan tammwayas bo ikayabes nimeis. E, tammwayas sisiyas tanuwgwes lun situwa̱vek sisiyas takatimlakeins kaleiwag bo ikayabes nimeis. ");
INSERT INTO myw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tasilkodein bo idibakes kweitan sinap va̱gan bikakins kal Yeisuw, ilana, “Kukines kal bakamuloul soug, mtowen Yeisuw, kuyousis, kumtakavates beibwein.” ");
INSERT INTO myw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","46","Mto Yudas iwek Yeisuw, ilana, “Kalin nuwag guntovek yak,” mo ivayams son. Tasiyas ikines, ituts, iweis, iyousis, itawtouns waseg. ");
INSERT INTO myw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Teitan gog nitet wadadan mo ikow napulut tanmunum, iweiy natouwat tanuwgwes lun sitovek avakaein, ibob teigan. ");
INSERT INTO myw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Yeisuw gog idibakes, ilana, “Mipulut minew kukokews, kuyousigs ma̱wana tavveinaw yey. Yam katanok katanok Yowbad wanbunatum wamtamiy akatimlakes gamags, nag kuyousigs. Tage sinap ma̱wan va̱gan bikamat liva̱neig Bukitab waseg nilivnek.” ");
INSERT INTO myw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Inavamul babaw bo isawls, ilisawes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Natabwa̱kun teitan anakweim mwayntanok nisikam, bisawl kid, tage bo iyousis; ilisow anakweim wanimes, sona mwadoyan mo isawl in. ");
INSERT INTO myw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Itokes Yeisuw binawes tanuwgwes lun sitovek avakaein wamatan, biyateles. Ikatuyouns nimeis babaw siyas tanuwgwes lun situwa̱vek, sisiyas tammwayas, sisiyas takatimlakeins kaleiwag. ");
INSERT INTO myw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita anmwa̱net ibwa̱kun kadiveiyov, nag in walisis, isap tanuwgwes lun sitovek avakaein wanven, mo isinis siney tasiyas tawwotets, ikamunuws wa̱kov. ");
INSERT INTO myw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iya̱tals. Tanuwgwes lun situwa̱vek sisiyas tammwayas babaw iyateles Yeisuw va̱gan kid bikatimates, tage silawun nag iba̱nes. ");
INSERT INTO myw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iyya̱tals, gamag babaw asilivan yaweid-wan, peinan asilivan nag ilatanes. ");
INSERT INTO myw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Iyyokons ee... tayyaweids asteiy mo itamanaws, ilansa, “Yakamey nakaligen anilivan mamagina, ‘Yowbad nabunatum towen gamag niwlules, yey bo bagulek, ikous, kweitoun yam mo bawlulavaw, tage nag namag bawlul.’” ");
INSERT INTO myw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ilivans ma̱wan, tage asilivan nag ilatanes katanok-wan. ");
INSERT INTO myw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wankuyeim tanuwgwes lun sitovek avakaein mo itamanaw wanuwein, wamatan Yeisuw, ilana, “Nag aveiyag bukwatimop, ne? Aveiyag silawun asilivan tasiyas?” ");
INSERT INTO myw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yeisuw gog isesuna ikka̱pay. Vayuwein ikatigan, ilana, “Tabta ya̱koum Kelis, Tamwey bwanabwein natun yak, ne?” ");
INSERT INTO myw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iw to Yeisuw, ilana, “O, ma̱wan. Igaw bukukineigs Gimgilitoun yey bassin Tatawtoun wanaka̱tay, mo bam liba̱lab lov-nen waseg.” ");
INSERT INTO myw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Tanuwgwes lun sitovek avakaein ikapasal nuwan, iksigeb anakweim, ilana, “Nag sivinads teitan gamag bikamtel ansinap kalbaleb; peinan bo taliganes anilivan kalbaleb. Aveiyag bitava̱ges?” Babaw itams, ilansa, “Kadiloka bitaweiys.” ");
INSERT INTO myw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mwasanis mo igusus, ilumwes magin, iwaweiys, ilansa, “Kulivan ma̱wana palopit ya̱koum.” Igawa iwaweiys, siyas tawwotets mo itokes Yeisuw, ineis. ");
INSERT INTO myw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pita igawa nises wamatan bunatum, tanuwagan lun natouwat kuda̱vin na̱tan inek Pita, ikin ikamunuw kov, iwtus, ilana, “Adok ya̱koum-vak soum gum-Nasalet Yeisuw ya̱koum, ne?” ");
INSERT INTO myw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ikayan, ilana, “Nag. Nag akakin aveiyag kulivan.” Mo inoun in wadunan ked. ");
INSERT INTO myw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Vin mana̱wen ikin, idibakes tasiyas nitatos, ilana, “Mtowen Yeisuw nagamag teitan.” ");
INSERT INTO myw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Vayuwein Pita ikayan. Tut kadiyakus wankuyeim siney nitabalawaws idibakes Pita, ilansa, “Mounid ya̱koum Yeisuw nagamag teitan, peinan gum-Galiliy yak.” ");
INSERT INTO myw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iw to Pita, ilana, “Nag. Awoum bayaweid; Yowbad beiweig. Nag akakin gamag to nukulivan.” ");
INSERT INTO myw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ilivan ikous, kolkolek mo igel sivay. Pita iligen, inuw Yeisuw anilivan mamagina, “Siva̱toun bukwaya̱neig mo kolkolek beigel sivay.” Anilivan nilivnek ma̱wan, inuw Pita, anmwasin mo iva̱lam. ");
INSERT INTO myw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Walalayis-wan tasiyas tanuwgwes lun situwa̱vek sisiyas tammwayas, sisiyas takatimlakeins kaleiwag, tasiyas tababaws mamagina konsels illivans bo idumwal ninous katanok-wan, mo iyawanis naman Yeisuw, itokes, inawes Paylat wamatan. ");
INSERT INTO myw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mtowen Paylat ikatigan, ilana, “Tabta min-Yudiy siking ya̱koum?” Yeisuw ilana, “Ma̱wan amlivan.” ");
INSERT INTO myw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tasiyas tanuwgwes lun situwa̱vek iyateles Yeisuw, asilivan babaw waseg. ");
INSERT INTO myw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Vayuwein mo Paylat ikatigan, ilana, “Nag bukwatimop, ne? Liva̱neim babaw illivans.” ");
INSERT INTO myw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tage Yeisuw nag ikatimop anilivan, ikka̱pay-wan, Paylat ikin, bo isunasun nanon. ");
INSERT INTO myw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sagal towen waseg Paylat bilik tasiwun deil teitan bein wamnat, kal sivines gamags. ");
INSERT INTO myw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bweilim katanok katanok ma̱wan. Teitan gamag yagan Bala̱bas nises wa̱deil, kweiboug siney tasiyas tapiyaveins gabman nakaleiwag ivvatays waseg gabman natouwats mo iweiy gamag. ");
INSERT INTO myw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Babaw gamag inekes Paylat, ilansa, “Tab bukulik tasiwun deil, kal bakalivan, bisap, ma̱wan mukwaleiwag nukuvvag bweilim babaw.” ");
INSERT INTO myw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iw to Paylat, ilana, “Tab sivinamiy min-Yudiy miking balik beiw, ne?” ");
INSERT INTO myw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paylat gog ikakina antameiliw Yeisuw tasiyas tanuwgwes lun situwa̱veks, to niyateles. ");
INSERT INTO myw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tage tasiyas tanuwgwes lun bo itateiys ninous gamag babaw, igaw mo bikavtagis kid Bala̱bas yagan va̱gan bilik beim wamnat. E, ilivans ma̱wan. ");
INSERT INTO myw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Vayuwein mo Paylat ikatiga̱nes, ilana, “Aveiyag banuwek mtowen miking min-Yudiy yakamiy?” ");
INSERT INTO myw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vayuwein iwaks, ilansa, “Kuweiys waklos, beimat.” ");
INSERT INTO myw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Iw to Paylat, idibakes, ilana, “Aveiyag ansinap kalbaleb?” Tasiyas gog singay iwkuwaks, ilansa, “Kuweiys, kuweiys!” ");
INSERT INTO myw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paylat bo itam wasigeis gamag babaw, ilik Bala̱bas, o idibakes biwaweiys kid Yeisuw, vatul waseg, mo bikatikavates bikayagweg waklos, bikanig. ");
INSERT INTO myw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tasiyas takanaviys mo itokes Yeisuw inawes ilaksiwus wasibunatum bunavakaein, idawes sisiyas takanaviys babaw bimimeis. ");
INSERT INTO myw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Imeis, ikawes kweim bwabwel, ivaskoumis; ikous mo ikawes vatul kulikoul, ikwanis wakunun magina anapay. ");
INSERT INTO myw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ikous, mo illivansa mav, ilansa, “Kalin nuwem, min-Yudiy siking ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Amweilok ikawes, iwaweiys wakunun, igusus, ikululs wamatan. ");
INSERT INTO myw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Isiba̱wes ikous, inisis maynawen kweim bwabwel, ivaskoumis anakweim tonen, itokes inawes va̱gan beiweiys waklos. ");
INSERT INTO myw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Itokes Yeisuw, inounas wa̱ked, ilivatus Saymon meinoy wanawoud neim; gum-Saylin towen nitun asteiy Alekisan son Lup. Ilivatus Saymon, idibakes, ilansa, “Kukew anklos taw towen.” ");
INSERT INTO myw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Itokes inawes ven Golgot. Golgot takativini bein aga-Muyuw, Busabwes. ");
INSERT INTO myw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Isekes beimoum wayn son mul, ipiyev. ");
INSERT INTO myw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ikous mo ikatikavates, ikayagweg waklos. Ikokews anakweim, ikalawages; ilaves kweitan youd bikines kid kalisiy bikawes asikweim tatanok tatanok tasiyas. ");
INSERT INTO myw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikatikavates ga̱boug, ka̱las italga̱lag. ");
INSERT INTO myw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ileles nakalbaleb, isenas waklos mamagina, “Min-Yudiy siking.” ");
INSERT INTO myw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Asteiy sisiy Yeisuw ikatikavates wasklos, tavveinaws, teitan wanaka̱tay, teitan wankimaw. ");
INSERT INTO myw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO myw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Tasiyas gog inounas wa̱ked, itawyages, asilivan kalbaleb, ilansa, “Ya̱koum tagulekwein Yowbad nabunatum, ne? Kweitoun yam kid bukuwlulavaw, ne? Kubus waklos kum; kwatinabweim tatoneim.” ");
INSERT INTO myw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Tasiyas tanuwgwes lun sisiyas takatimlakeins kaleiwag illivans, issebaws, ilansa, “Bo ikatinabwes gamag mwasanin, ta-ma̱wan bikatinob tatonen. Magat mtowen Kelis, min-Yisleil dakins, kadiloka beibus waklos beim, bitakines mo bitasimounids.” Siney-vak igawa nikayagwegs wasklos, itawyages Yeisuw. ");
INSERT INTO myw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yam towen ya̱nay bo iladadub ven, idadub ee... ka̱las itageg, mo ikamnat. ");
INSERT INTO myw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka̱las itageg, Yeisuw iwak, aygan avakaein, ilana, “Eli, Eli, lamasabaktaniy.” Takativini gog bein aga-Muyuw “GunaYowbad, gunaYowbad, aveiyag wawun nukulisaweig?” ");
INSERT INTO myw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iliganes mwasanin siyas nitabalawaws wadadan, ilansa, “Bo idow Ilaytiy beim.” ");
INSERT INTO myw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Teitan gog isawl in, ikow yotout, ibes kayal matan, isow wayn yayan waseg, iyasel binek Yeisuw wadon beimoum, ilana, “Beitay wouds, bitakines ga beim Ilaytiy mo binib.” ");
INSERT INTO myw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ikous, Yeisuw iwak, aygan avakaein, mo ikanig. ");
INSERT INTO myw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Maynawen kweim nisilbwed palakakit wanuwan Yowbad nabunatum, mo isiled, isilamaw wanakaew in watinow, ivag mwayney. ");
INSERT INTO myw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Takalikay towen nitamanaw wamatan Yeisuw, iligen aygan avakaein, ikin ikanig, ilana, “Mounid taw towen Yowbad natun.” ");
INSERT INTO myw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Vinay gog kadiveiyov nitamanaws ikakins, vinen-Magdal yagan Meliy, son valeyin mana̱wen nitun Yemes takakit son Yusitos, sisiy Salom. Kweiboug Galiliy waseg vinay tasiyas ibukunis Yeisuw ivakamus. Tasiyas sisiyas vinay mwasanin nimeis Yelusalem, itamanaws ikakins. ");
INSERT INTO myw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kwayav waseg mo ikatinages silma̱nin sagal nubweig Sa̱bat. ");
INSERT INTO myw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Gum-Alimatiy nises yagan Yosep, min-Yudiy sitakaleiwag teitan bwanabwein, nikaymet Yowbad nakaleiwag beim. Kwayav yam towen mtowen Yosep ikapwapout, inek Paylat, bintoug won Yeisuw va̱gan bikow binow bidibwen. ");
INSERT INTO myw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mtowen Paylat idoki singay nuwanaw ankanig Yeisuw, idow natakalikay; im ikatigan, ilana, “Tabta mtowen Yeisuw bo nikanig, ne?” ");
INSERT INTO myw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Itam, ilana, “O!” mapuna Paylat itam Yeisuw won va̱gan Yosep bikow. ");
INSERT INTO myw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mtowen Yosep in igimwel maynatan kweim pwapwa̱kaw, imey, mo ibwiy Yeisuw waklos, imey watinow, mo isumweil won, kweim to pwapwa̱kaw waseg. Ikous mo ikow inow isen wakalawag. Alawag towen neiteiys takunumwan. Dakul avakaein iyatpinis in ikatibwed wadon leg. ");
INSERT INTO myw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Vinay asteiy ikines alawag towen nisenas, vinen-Magdal yagan Meliy, son valeyin, Yusitos inan. ");
INSERT INTO myw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wankuyeim, Sa̱bat ikous, vinay asteitoun igimweles tagon binawes kid biptumis Yeisuw won. Tasiyas vinen-Magdal yagan Meliy, valeyin Yemes inan, sisiy Salom. ");
INSERT INTO myw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sa̱bat ikous, kweivaw yam, walalayis ikanakons inounas, bilakwanes kid alawag; ka̱las bo neipel. ");
INSERT INTO myw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Illivans sisiyas, ilansa, “Kal biyatipin dakul towen nisilbwed wadon leg va̱gan bitasiws?” ");
INSERT INTO myw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ilivans ma̱wan mo itamnawes mites, ikines nanawan bo iyatpin nises wadadan leg; singay avakaein dakul towen. ");
INSERT INTO myw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iweis tasiyas, isiws wanuwan alawag ikines toubwat teitan nisin waska̱tay, anakweim pwapwa̱kaw. Ikines mo ivag aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mtowen taw idibakes, ilana, “Awoum beivag amipwa̱yat. Kunineivs gum-Nasalet Yeisuw, neimat waklos. Bo ikit. Bo nein. Kukines nakabmasis makaw-wan. ");
INSERT INTO myw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Kuneis kudibakes navamuls sisiy Pita, kulansa, ‘Bo bimgwayeimiy bein waGaliliy, kuneis waGaliliy mo bukukines, ma̱wan nidibakeimiy.’” ");
INSERT INTO myw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Isaps tasiyas, isawls, ilisawes alawag, itatat wous, singay isom ninous. Nag ikamteles teitan gamag waseg, peinan aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sa̱bat ikous, iyam nen bo ikit Yeisuw, wanmugwana isap waseg vinen-Magdal, yagan Meliy, kweiboug nikayeb yeiluw teinim teiy niyagages. Mana̱wen ikin, inoun, inekes Yeisuw nagamag igawa nivva̱lams. ");
INSERT INTO myw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Meliy ilana, “Bo akin Yeisuw sona mwamovan nises.” Tasiyas iliganes, tage nag isimounids. ");
INSERT INTO myw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","13","Wankuyeim nagamag asteiy ikines Yeisuw ankakin kweitan, igaw inounas bineis wanawoud. Ikines, iyums idibakes sisiyas, tage nag isimounids. ");
INSERT INTO myw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wankuyeim navamul sinwatan tatanok, ikamkwams, mo inekes. Ikines, ilana, “Keikay gamag, takakons yakamiy. Gamag mwasanin bo ikineigs, idibakeimiy, tage nag kusimounids.” ");
INSERT INTO myw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","18","Ilana, “Kuneis vena babaw, kugeiguys, kusekes livan bwanabwein, gamag tatanok tatanok wasigeis. Kukin kal bisimounid bibaptays mo Yowbad bikatinob; kukin gog nag, Yowbad mo bikamtan. Tasiyas bisimounids mo biwotets tawtoun; yagag waseg bikayabes bwagaw; kaeig kweitan kweitan billivans; mwatet biyousis wanimes; o pwa̱tuw beimoums nag biyagages; bisenas nimes takatouns wawous mo beibweins.” ");
INSERT INTO myw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","SiGuyaw mtowen siney illivans ikous, mo imwen in walba̱lab, isin Yowbad wanaka̱tay. ");
INSERT INTO myw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tasiyas gog mo ineis ven babaw igeiguys, siGuyaw ilabes, siwotet mo itawtoun singay. Gamag ikines tawtoun siwotet mo isimounids asilivan waseg. ");
INSERT INTO myw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kalin nuwag ya̱koum Tiyopil. Peinan babaw gamag bo isilamaws mo ileles liva̱nen Yeisuw inawotet niwtel wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Peinan wanmugwana mwasanin bo nikines wamtes, mo ikawes liva̱nen Yeisuw, isekemas yakamey. ");
INSERT INTO myw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","O yey-vak tut babaw aligen livan towen, asisawena oko ayakous, mo nanoug alana, “Adok bweina balivkaes livan babaw, basen mulet waseg, beiw bukukin, guyaw ya̱koum Tiyopil.” Bukuvin va̱gan bidumwal nanoum mo bukusimounid waseg sinap towen nikatimlakeims. ");
INSERT INTO myw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tutan min-Yudiy siking yagan Elod, tanuwagan lun teitan yagan Sekaliy. Nakwav yagan Elisabet, mana̱wen Elon delen. Tasiyas tanuwgwes lun dal kweitan kweitan. Mtowen Sekaliy Abiy delen. ");
INSERT INTO myw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mtowen Sekaliy son nakwav asisinap didumwal wamatan Yowbad. Yam katanok katanok ivna̱ses Yowbad nakaleiwag babaw, iyakousis. ");
INSERT INTO myw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tage nitus nag, peinan Elisabet vinakal bo ivnavek, o namwam bo itovek. ");
INSERT INTO myw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tasiyas Abiy delen, anatut waseg iwteles lun Yowbad wanbunatum. ");
INSERT INTO myw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Peinan sikikun ma̱wan, kweitan youd ilavesa mav mo iton yagan mtowen Sekaliy; mo ikow nawotet kweitan, mamagina isiw in Yowbad nabunatum wanuwan, igob gewuw, manisin simasim seikwan. ");
INSERT INTO myw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Gamag meivek-wan watoulan bunatum ikululs ininitougs waseg Yowbad, peinan bo tutan gewuw beigabs. ");
INSERT INTO myw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mo Yowbad nataka̱yob teitan isap waseg Sekaliy, itoun nakabeigab gewuw wanaka̱tay waseg. ");
INSERT INTO myw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mtowen Sekaliy ikin, iyow nuwan, anpwa̱yat seikwan. ");
INSERT INTO myw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mtowen anelos mo idibek, ilana, “O Sekaliy, awoum beivag ampwa̱yat. Yowbad bo iligen mukwanitoug, mukwav Elisabet bo bikop nitumiy, mo bukudok yagan Yon. ");
INSERT INTO myw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Ya̱koum bukumwa̱saw seikwan simwey babaw gamag bimwa̱saws, mukwav inakopway waseg bikop nitumiy. ");
INSERT INTO myw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Mtowen natum bo bitawtoun wamatan Yowbad. Nag beimoum wayn o tawtoun yevagam, nag. Avei-tut inan bikop, Yowbad Kululuwan mo binek gwad towen, son bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Mtowen bo bileb min-Yisleil mwasanin mo bikanavin ninous, beiyum binekes siGuyaw Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Peinan bo bikanow daGuyaws aygan, biwotet Kululuwan tawtoun waseg, ma̱wan Ilaytiy kululuwan. Bivag timsiyas ninous bikanavin mo binekes gamagal; o tasiyas takapidabs bikanavin ninous mo bisinaps ma̱wana tadidumwals. E, natum inawotet ma̱wan, va̱gan bikabutus inagamag silma̱nin Yowbad inawotet.” ");
INSERT INTO myw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iw to Sekaliy idibek anelos, ilana, “Ama̱wan bakakin amlivan towen mounide? Peinan bo atovek, o gunakwav bo ivnavek.” ");
INSERT INTO myw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelos ikatimop anilivan, ilana, “Yey Gebliyel, tut babaw natitamanaw wamatan Yowbad. Bo ikayabeig nam adibakeim bulagan towen bwanabwein. ");
INSERT INTO myw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Peinan nag kusimounid waseg agulivan, bo bukusesuna mamagina gumugum yak. Bukusesuna ee... anatut youd towen nalivnek; wankuyeim mo bukulivan.” ");
INSERT INTO myw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gamag tasiyas ikayamats Sekaliy, idokes aveiyag wawun inayouviy wanuwan bunatum. ");
INSERT INTO myw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ikayamats ee... mo isap. Ta-ma̱wan bilivan; mo ikakins mtowen nikin kweitan youd wanuwan Yowbad nabunatum; anilivan bogo naman-wan; wadon nag ma̱wan bilivan. ");
INSERT INTO myw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mtowen Sekaliy ises iwwotet ee... yam towen iyakous nawotet, mo iyum in wanven. ");
INSERT INTO myw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Wankuyeim nakwav Elisabet mo isum, nises wabunatum kweinim tibukon; mamagina bo issowm wabunatum, ilana, “Yowbad inawotet ma̱wan. Bo ikalin nuwan yey. Gamag nivtokeigs livan vinakal yey, agumwasin; nagein gog bo iyakous.” ");
INSERT INTO myw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Kweinim tibukon ikous, iton kweivaw, mo Yowbad ikayeb anelos Gebliyel in Galiliy, ven yagan Nasalet. Inek nakubukwab nagtabod nibokes beivay kid son taw Yosep, Deibid delen. Nakubukwab mana̱wen yagan Meliy. ");
INSERT INTO myw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mtowen Gebliyel inek Meliy, ilana, “Kalin nuwag! Yowbad soum ya̱koum, ilabeim.” ");
INSERT INTO myw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mana̱wen anpwa̱yat singay; ininuway seik aveiyag silawun livan towen. ");
INSERT INTO myw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","31","Iw to anelos, ilana, “Meliy, awoum beivag ampwa̱yat. Yowbad bo ikalin nuwan ya̱koum. Igaw mo bukukop natum kuda̱taw. Ikous, mo bukudok yagan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","“Mtowen bo bitawtoun. Gamag bidokes ‘Tatawtoun Yowbad Natun.’ DaGuyaws Yowbad bo bisek inakaleiwag tawtoun, peinan tabun Deibid inakaleiwag; mo bikaleiwag Yekob delen wasigeis. Nakaleiwag bises bisigeg.” ");
INSERT INTO myw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meliy ikatigan anelos, ilana, “Ama̱wan ba̱sum, peinan ta-ivag gunamwan.” ");
INSERT INTO myw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iw to anelos, idibek, ilana, “Yowbad Kululuwan biwekeim, Yowbad natawtoun waseg bisekeim. Mapuna bukusum natum, gamag bidokes gwad to takamnat, Yowbad Natun tatonen. ");
INSERT INTO myw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Tage veiyoum Elisabet bo ivnavek mo isum, natun kuda̱taw nises wanuwan. Idokes kid vinakal mana̱wen, tage neisum kweinim tibukon katanok waseg. ");
INSERT INTO myw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","“Peinan Yowbad waseg, youd babaw bo kadilok.” ");
INSERT INTO myw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meliy iligen ikous, mo itam, ilana, “Bwein. Yey Yowbad natouwat yey. Bweina biva̱geig ma̱wan nukulivan.” Anelos towen mo ilisow, inoun. ");
INSERT INTO myw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Tut towen Meliy mo itamanaw, inuwanaw, inoun in koyakoy, ven kweitan wawnuwan Yudiy, isiw in wanuwan Sekaliy nabunatum, imulouls son Elisabet. ");
INSERT INTO myw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Elisabet iligen Meliy anilivan ikous, natun mo ivatay wanuwan, Yowbad Kululuwan mo inek mana̱wen Elisabet, aygan avakaein, ilana, “Singaya namwa̱saw ya̱koum. Vinay babaw isimwa̱saw nag ma̱wan ya̱koum. Natum nukusum singay bwanabwein. ");
INSERT INTO myw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","“Aveiyag wawun Yowbad nisiwyoubug mo kumekeig, daGuyaws inan ya̱koum? ");
INSERT INTO myw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","“Nukum, aligen aygam mo natug ivatay wanuwag, peinan bo imwa̱saw. ");
INSERT INTO myw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Singay tammwa̱saw ya̱koum peinan kunamis va̱gan bikamat youd towen Yowbad nidibakeim.” ");
INSERT INTO myw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Iw to Meliy, ilana, “Kululuwag iya̱kawn waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Singay amwa̱saw, peinan takatinaweig Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","“Peinan bo inuway tasimav natouwat yey. Wankuyeim gamag babaw mo bidokeigs nammwa̱saw yey, bweilim katanok katanok waseg. ");
INSERT INTO myw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","“Towen Tatawtoun, singaya bo ilabeig; yagan tonen kamnat. ");
INSERT INTO myw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","“Bo inok nuwan tasiyas nigigoulus; wankuyeim nitsiyas o tibsiyas bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","“Naman tawtoun waseg bo itakayway. Bo ikatigulekwes tasiyas takaypamweins sinap. ");
INSERT INTO myw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Bo ikatigulekwes sikaleiwag tasiyas tatawtouns; o tasiyas tasimavs bo iyamwenes. ");
INSERT INTO myw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","“Tasiyas asimoun bo isekes kaeis bwanabwein, beikams bikamuweips. Tage bo ikayabes guyawaw, asimoun waseg iyums. ");
INSERT INTO myw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","“Bo inuway anilivan bwein nidibakes tammwayas, tasiyas Ebelam siney delen ya̱kids, tut nag beiyakous. E, bo inuway anilivan, inok nuwan, ilabeids min-Yisleil ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meliy ilivan ikous; asteiy nisesus son Elisabet; adok kweitoun tibukon, mo iyum in wanven. ");
INSERT INTO myw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mana̱wen Elisabet nises ee... tutan bo itup mo itapoy naman, natun kuda̱taw. ");
INSERT INTO myw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ansinva̱lam sisiyas taliven mo iliganes bulagan Yowbad nasiwa̱youb avakaein waseg Elisabet, inekes, sisiy imwa̱saws. ");
INSERT INTO myw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Yam kweinim ikous, kwatounun yam mo inekes va̱gan bibwabwes momwan gwad; bidokes kid yagan Sekaliy, mamagina valeyin taman; tage inan igidem sikaleiwag, ilana, “Nag. Tadokes yagan Yon.” ");
INSERT INTO myw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iweis tasiyas, ilansa, “Aveiyag wawun? Nag ivag amigamag teitan yagan Yon, bukudokes valeyin.” ");
INSERT INTO myw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mo iliva̱tes nimes waseg, ikatiga̱nes taman, avei-yeg waseg bidokes yagan gwad towen. ");
INSERT INTO myw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Taman towen sivinan buk; isekes mo ilel mamagina “Yagan Yon.” Ikines, bo isom ninous. ");
INSERT INTO myw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ilelel ikous, mo ikapwageg wadon, ilivan, iya̱kawn waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bo iyow nuwes tasiyas; bulagan illivans ven babaw koyakoy wawnuwan Yudiy. ");
INSERT INTO myw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Asibabaw iliganes, ininuways, ilansa, “Gwad towen aveiyag mo bimlavag?” Peinan Yowbad son gwad towen, ilileb. ");
INSERT INTO myw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yowbad Kululuwan mo inek taman Sekaliy, ilivnek sinap, ilana: ");
INSERT INTO myw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Min-Yisleil ya̱kids bitaya̱kawns waseg daGuyaws Yowbad, peinan bo ilakwaneids nagamag ya̱kids, ikatinabweids. ");
INSERT INTO myw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","“Natouwat Deibid delen teitan bo isekeids takatinabweids. ");
INSERT INTO myw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Kweiboug Yowbad nilivnek waseg asilivan inapalopits tatonen. ");
INSERT INTO myw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Anilivan mamagina bikatinabweids; awoum tasiyas nikamliweids biyagageids. ");
INSERT INTO myw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“O binok nuwan, peinan nilivnek wasigeis tammwayas. Bo inuw anilivan towen mounid. ");
INSERT INTO myw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","“Anilivan mounid towen nisek tabuds Ebelam, itam va̱gan bikatinabweids. Awoum tasiyas nikamliweids biyagageids; mapuna beiyakous adpwa̱yats, o bitakanawes aygan, waseg adsinaps didumwal, bwanabwein, yam katanok katanok. ");
INSERT INTO myw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“O gwad ya̱koum, igaw gamag mo bidokeims ‘Yowbad Tatawtoun inapalopit ya̱koum.’ Peinan bukumgwey; inaked bukuvag beibwein. ");
INSERT INTO myw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","“Bukwatimlakes inagamag mo bikakins nakatuneib waseg, peinan biwid asisinap kalbaleb, binumlev. ");
INSERT INTO myw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","“Towen Yowbad inasiwa̱youb bwanabwein beinoy walba̱lab bimekeids, mamagina lalayis beim mititeilin waseg bimteilids, o bimteilis kid tasiyas tadadubs, tasiyens kabkanig walasin, mo bikatimlakeids niwal kidenen.” ");
INSERT INTO myw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gwad towen bo itawbwat, bo ivakaein, kululuwan bo itawtoun, misik wanawoud ee... anatut waseg mo ikamat wasigeis min-Yisleil. ");
INSERT INTO myw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gwad towen Yon igaw kakit, king avakaein yagan Sisal Ogoustos mo ikaleiwag ma̱wana gabman, va̱gan bileles yiges gamag babaw, ven meiveka wasigeis. ");
INSERT INTO myw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Inakaleiwag towen wanamug, anatut mtowen Kwilinis nikaluweg ven yagan Siliy. ");
INSERT INTO myw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sisal ikaleiwag ikous; mo inounas gamags meivek-wan, ineis wasiven tatineis, silma̱nin yiges bileles. ");
INSERT INTO myw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yosep-vak ilisow ven Nasalet wawnuwan Galiliy, ikatulags ineis Yudiy, Deibid inaven yagan Betelem, peinan Deibid delen mtowen; e, bilel kid yiges son nakwav Meliy, ankuda̱pom. ");
INSERT INTO myw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Asteiy nisesus Betelem, mo ilouvat anatut bo nitup. ");
INSERT INTO myw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nitup mana̱wen, peinan anigavaw, mo ikop natun kuda̱taw. Isumweil anakweim, isen wada̱wag, bulumakaw astavalel waseg, peinan nag ivag a̱ban wanuwan bunatum. Singay gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ven towen tamtakavateins aleis sip wanawoud boug waseg nimtakavates aleis. ");
INSERT INTO myw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yowbad nataka̱yob mo isap wasigeis, Yowbad inakamnat imteil ven towen nisikes; mapuna ivag aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anelos towen idibakes, ilana, “Awoum beivag amipwa̱yat, peinan basekeimiy mwa̱saw liva̱nen, simiyas meiveka gamag. ");
INSERT INTO myw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Nagein gog, Deibid inaven waseg na̱tan vin bo ikop mtowen takatinabweimiy, daGuyaws Kelis. ");
INSERT INTO myw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Igaw bukuba̱nes a̱pwaw nisumweilis anakweim nimmasis wada̱wag, bukukines mo bukukwakins mtowen Kelis.” ");
INSERT INTO myw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ilivan ikous, nuwanaw mo inekes min-liba̱lab singay babaw, ikavasis Yowbad, ilansa, ");
INSERT INTO myw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Singay tayakawanes Yowbad walba̱lab; O niwal watinow wasigeis tasiyas tasiwa̱youbs.” ");
INSERT INTO myw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anelos tasiyas mo ilisawes, iyum ineis walba̱lab, tamtakavateins aleis mo illivans sisiyas, ilansa, “Kumeis, taneis Betelem, bitakines youd towen nikamat, peinan daGuyaws bo ikamtilakeids.” ");
INSERT INTO myw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iliva̱nes ikous, nuwanaw ineis, iba̱nes Meliy son Yosep, sisiy a̱pwaw nimmasis wada̱wag. ");
INSERT INTO myw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ikines ikous, mo ikamteles liva̱nen gwad towen, peinan gum-liba̱lab nikamtilakes. ");
INSERT INTO myw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tasiyas tamtakavateins aleis ikamteles asilivan ikous, o tasiyas niliganes bo isom ninous. ");
INSERT INTO myw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tage Meliy isesuna, ininuway youd tasiyas waseg. ");
INSERT INTO myw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tasiyas tamtakavateins aleis mo iyums, iya̱kawns waseg Yowbad, peinan ma̱wan gum-liba̱lab anilivan, youd babaw ikines o iliganes ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yam kweinim kweitoun ikous, mo ibwabwes momwan gwad towen, idokes yagan Yeisuw; peinan gum-liba̱lab bo idok yagan kweiboug, inan nag isum; igaw-wan. ");
INSERT INTO myw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wankuyeim anatut bivka̱yes bikamnat ma̱wan Moses nakaleiwag, mo ikopwes gwad towen, ikatulags ineis Yelusalem, inawes Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Peinan Yowbad inakaleiwag waseg anilivan nileles mamagina, “Igaw vin bikop natun kuda̱taw anigavaw waseg, mo bakayus, kudokes ‘Yowbad angamag towen.’” ");
INSERT INTO myw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mapuna ineis Yelusalem va̱gan beiweiys man mwasanin, bigabus silma̱nin Yowbad, peinan inakaleiwag waseg ilana, “Kuweiys kulitapip mwanay, o kukin nag, mo bwabun mungogewns mwanay.” ");
INSERT INTO myw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Ven Yelusalem taw teitan yagan Simiyon, tadidumwal, ansinap bwein. Ikkayamat anatut Yowbad bisiwyoubus tasiyas min-Yisleil va̱gan beitay nuwes. Yowbad Kululuwan waseg taw towen, bo ikatimlakay mo ikakin bisesuna ee... bikin daGuyaws inaMesay Kelis, mo bikanig wankuyeim. ");
INSERT INTO myw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yowbad Kululuwan imgwey taw towen mo inoun in Yowbad wanbunatum. Taman son inan bo ikopwes nitus mtowen Yeisuw, isiws wanuwan bunatum va̱gan biva̱ges peinan, ma̱wan sikikun kweiboug Yowbad inakaleiwag nilel Bukitab waseg. ");
INSERT INTO myw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mtowen Simiyon im inekes, ikin gwad towen, inup, iya̱kawn waseg Yowbad, ilana: ");
INSERT INTO myw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“MaGuyaw yak, o yey mutouwat, Tut towen amwa̱saw. Kukilaveig bakanig niwal waseg, Ma̱wan nukulivan. ");
INSERT INTO myw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","“Peinan wamatag bo akin mtowen takatinabweids. ");
INSERT INTO myw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","“Inawotet nukwaluweg wamtes gamag babaw, va̱gan bimteilis tasiyas igaw dadub, tobwag ven wasigeis, mo bikakins tasiyas, bikamnats. Inawotet-vak silma̱nin yakawanan mubod yakamey min-Yisleil.” ");
INSERT INTO myw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taman son inan iliganes liva̱nen nitus, isom ninous silma̱nin. ");
INSERT INTO myw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyon mo isekes anilivan bwanabwein, idibek gwad inan, ilana, “Peinan gwad towen inawotet igaw bikow, mo min-Yisleil mwasanin bikalivatows o mwasanin bitamanaws. O mwasanin bikines nawotet ma̱wana naman mulin Yowbad, tage bitawyages. ");
INSERT INTO myw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","“Ya̱koum-vak, woum bimouvit, singay bigeg nanoum. Tage mtowen inawotet va̱gan bitakakins ninous babaw gamag.” ");
INSERT INTO myw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Palopit na̱tan yagan An, taman Panuwel, anakum Asel. Bo ivnaveka singay. Igaw naptabod isesuna ee... mo ivays son namwan. Asibweilim nisikes son namwan kweinim kweiy. Namwan mo ikanig. E, isesuna nakwab ee... mo ivag anbweilim sinwanim sinwatoun kweivas. Nag ilisow Yowbad nabunatum, ikikulul wamatan Yowbad yam o boug, ipsapos o ininitoug. ");
INSERT INTO myw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anatut tasiyas sisiy nitus nimeis, mo isap mana̱wen vin, ikalin nuwan waseg Yowbad, o idibakes tasiyas min-Yelusalem, ilana, “Gwad towen inawotet va̱gan bikatinabweids”; peinan tasiyas nikaymates teitan gamag beim silma̱nin nawotet towen. ");
INSERT INTO myw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tasiyas son nakwav iyakousis youd babaw silma̱nin Yowbad nakaleiwag, mo iyums ineis Galiliy wasiven Nasalet. ");
INSERT INTO myw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yowbad ikalin nuwan waseg gwad towen; bo itub, ivakaein bo itawtoun, bo ivag nanon; bo ivag ansinap avakaein. ");
INSERT INTO myw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taman o inan, asigulagul bweilim kanatok kanatok inineis Yelusalem silma̱nin Kaltuwon Sigeilin. ");
INSERT INTO myw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yeisuw anbweilim sinwatan kweiy, ikatulags ineis Yelusalem, ma̱wan asigulagul kweiboug. ");
INSERT INTO myw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Sagal towen iyakousis, iyums ineis wa̱ked, tage nitus nises Yelusalem. Taman inan nag ikakins, idokes kid sisiy, peinan babaw gamag. Inounas ee... iboug, mo inineivs tawlisiyas o sisiyas wasigeis. ");
INSERT INTO myw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ininineivs bo nag, mo iyumnavaws ineis Yelusalem, ininevs nitus. ");
INSERT INTO myw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ininineivs yam kweitoun, mo iba̱nes Yowbad wanbunatum, nisesus ikkaypuls siney tasiyas takatimlakays, iligen asilivan o ikatitugan wasigeis. ");
INSERT INTO myw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Babaw gamag niliganes ansinap waseg ikatimop asilivan, isom ninous, peinan ansinap singay-wan. ");
INSERT INTO myw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Taman inan ikines, bo isom ninous; inan mo idibek, ilana, “Natug yak, aveiyag wawun nukuva̱gem ma̱wan? Soug tamam nakanineveim, ikubukub nuwem seikwan.” ");
INSERT INTO myw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iwa̱ge, ilana, “Aveiyag wawun kunineveigs? Tabta kukwakins yey nases tamag wanbunatum?” ");
INSERT INTO myw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tage tasiyas nag ikakins livan towen nidibakes. ");
INSERT INTO myw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Siney tasiyas mo iwloubus ineis Nasalet, mtowen bo ikanaway ages; tage inan ininuway youd tasiyas silma̱nin. ");
INSERT INTO myw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeisuw bo itub ivakaein, bo isinap. Yowbad ikalin nuwan, o gamag ikalin nuwes waseg. ");
INSERT INTO myw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Astakaleiwag avakaein Sisal Tibeliyas; inakaleiwag anbweilim sinwatan kweivas bweilim bo nein wankuyeim. Ponitiy Paylat takaleiwag ven Yudiy waseg; Elod takaleiwag Galiliy waseg, o bwadan Pilip takaleiwag waseg ven Ituliy son ven Tila̱konit; o Lisaniyas takaleiwag ven Abilen waseg. ");
INSERT INTO myw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tanuwgwes lun sitovek avakaein Anas son Kayapas. Sekaliy natun Yon wanawoud misik, Yowbad anilivan inek Yon mo ikakin. ");
INSERT INTO myw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yowbad anilivan mo ikow, inow ven towen walasin yevagam Yoldan; iguyes gamag va̱gan bilavewas asisinap kalbaleb, bibapta̱yses, Yowbad mo biwid asisinap beikous. ");
INSERT INTO myw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Liva̱nen Yon nises Bukitab, anilivan palopit mtowen Isaya, mamagina: “Aygan mtowen tawkuwak wanawoud mamagina: ‘Kwaleliws daGuyaws inaked, bididumwal. Kadiloka bitadibwanis leg babaw, o bitagiyeilis koy bimamanas. Aveiyag kaydodog mo bitadumwa̱lus, o ked kalbaleb bitagiyeilis bimamanas. Meiveka gamag mo bikines ama̱wan Yowbad bikatinabweids.’” ");
INSERT INTO myw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Singay babaw gamag inekes Yon va̱gan bibapta̱yses tasiyas, mo ilivan, ilana, “Ma̱wana mwatet yakamiy! Adok teitan nidibakeimiy peinan Yowbad anvikun, bimop kid amisinap kalbaleb, mapuna kusawls kumekeigs. ");
INSERT INTO myw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Kadiloka bikanavin ninoumiy va̱gan beibwein miwotet. Awoum kuninuways tibumiy Ebelam. Yowbad nag bikalin nuwan peinan tibumiy Ebelam. Deisa beibwein miwotet, mo bikalin nuwan wasigeis yakamiy. Yowbad kadiloka dakul tasiyas bivag mo bimlavags Ebelam tibun. ");
INSERT INTO myw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Tage tut towen Yowbad ikow ta̱lal bitateiy kasiyas amweilok kalba̱lebs, bikalivatows. Kukin nag beivag anagin bwein, mo bitateiy, bikatikunok, bikow, binow, bilev, bein wa̱kov, bigob.” ");
INSERT INTO myw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gamag babaw mo ikatugans, ilansa, “Aveiyag bakavag yakamey?” ");
INSERT INTO myw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ikatimop, ilana, “Kukin kal anakweim mwayney, kadiloka mwaynatan bisek son, kavel anakweim nag ivag. Kukin sam kan, kadilok-vak bisek son, kavel nag ivag kan.” ");
INSERT INTO myw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takaweins ta̱kis mwasanin sivines-vak bibaptays, inekes, ikatugans waseg Yon, ilansa, “Takatimlakay yak aveiyag bakavag yakamey?” ");
INSERT INTO myw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iwa̱ge, ilana, “Ma̱wan mitovek nakaleiwag kukwawes ta̱kis; meiyum bo deis. Awoum kuva̱ges bivakaein.” ");
INSERT INTO myw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Takaninaviys-vak ikatiga̱nes, ilansa, “Yakamey, aveiyag bakavag?” Iwa̱ge, ilana, “Awoum kutawtouns wasigeis gamag kukwayes siwliyoug. Awoum kuyaweids ya̱tal waseg kukwawes gamag siwliyoug. Maysamiy nises, kadiloka bibabeit mitamiy. Awoum kumtapwags.” ");
INSERT INTO myw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gamag babaw idokes Kelis beim watinow, mo Yon nawotet ikines, idokes kal, takinew Kelis, adok tobwag. ");
INSERT INTO myw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yon ikakina ninous tasiyas, mapuna ikatimop, ilana, “Yey abapta̱yseimiy yevagam waseg; tage teitan beim; natawtoun waseg ilaveig yey. Yey tasimav, nag kadilok basin bastotow bakablev nasandol. Mtowen beim mo bibapta̱yseimiy waseg Kululuwan Bwanabwein, mamagina kov. ");
INSERT INTO myw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Nakaytuk wanaman va̱gan biwaway anawit biyakous, mo bikow anagin binow wanseigous, tage musamusan wit bilev bein wa̱kov bigbugwab yam babaw; nag biyakous.” ");
INSERT INTO myw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Anilivan wa̱seg singay babaw mo igiguyes o ikatimlakes gamag, va̱gan livan bwanabwein biliganes. ");
INSERT INTO myw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Tage bo idibek gabman towen Elod, ilana, “Amsinap kalbaleb peinan bo kukow bwadam nakwav Elodiyas, o peinan muwotet kweitan kweitan kalbaleb.” Elod mo ivag kweitan-vak ansinap kalbaleb, mo iyous Yon, isen wa̱deil. ");
INSERT INTO myw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Yon nibapta̱yses gamag babaw ikous, o nibaptays Yeisuw ikous, misumkwey towen Yeisuw bo ikulul, initoug waseg Yowbad, liba̱lab mo itavis, Kululuwan Bwanabwein ibus im, iton wakunuwatan. Kululuwan won tatonen ankakin ma̱wana bwabun, mo aygan teitan walba̱lab iliganes, ilana, “Yak Natug bwanabwein yak, singaya ibwein nanoug waseg ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeisuw, anatut nisilamaw nawotet anbweilim adok sinwatoun. Gamag idokes taman Yosep. Yosep taman Ilay. ");
INSERT INTO myw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ilay taman Madatat. Madatat taman Livay. Livay taman Melik. Melik taman Danay. Danay taman Yosep. ");
INSERT INTO myw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep taman Mataday. Mataday taman Emos. Emos taman Nekum. Nekum taman Esliy. Esliy taman Nagay. ");
INSERT INTO myw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay taman Makat. Makat taman Mataday. Mataday taman Semein. Semein taman Yosek. Yosek taman Yod. ");
INSERT INTO myw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yod taman Yowanan. Yowanan taman Lis. Lis taman Delububel. Delububel taman Seyaltiyel. Seyaltiyel taman Neliy. ");
INSERT INTO myw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neliy taman Melik. Melik taman Adiy. Adiy taman Kosan. Kosan taman Elmadam. Elmadam taman El. ");
INSERT INTO myw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El taman Yosuw. Yosuw taman Eliyesel. Eliyesel taman Dolim. Dolim taman Madatat. Madatat taman Livay. ");
INSERT INTO myw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livay taman Simiyon. Simiyon taman Yud. Yud taman Yosep. Yosep taman Yonam. Yonam taman Iliyakim. ");
INSERT INTO myw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iliyakim taman Malay. Malay taman Men. Men taman Matat. Matat taman Nadan. Nadan taman Deibid. ");
INSERT INTO myw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibid taman Desiy. Desiy taman Obed. Obed taman Bowas. Bowas taman Sal. Sal taman Nason. ");
INSERT INTO myw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason taman Amminadab. Amminadab taman Edmin. Edmin taman Anay. Anay taman Eslon. Eslon taman Peles. Peles taman Yud. ");
INSERT INTO myw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yud taman Yekob. Yekob taman Aysak. Aysak taman Ebelam. Ebelam taman Telak. Telak taman Neyol. ");
INSERT INTO myw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyol taman Selug. Selug taman Lew. Lew taman Peleg. Peleg taman Ebel. Ebel taman Selak. ");
INSERT INTO myw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selak taman Keinan. Keinan taman Alpaksad. Alpaksad taman Sem. Sem taman Now. Now taman Lemek. ");
INSERT INTO myw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek taman Metuselak. Metuselak taman Inok. Inok taman Deled. Deled taman Ma̱lalel. Ma̱lalel taman Keinan. ");
INSERT INTO myw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinan taman Inos. Inos taman Set. Set taman Adam. Adam taman Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Yowbad Kululuwan Bwanabwein bo itawtoun waseg Yeisuw, ilisow Yoldan iyum in wanawoud. Yowbad Kululuwan imgwey Yeisuw inoun yam sinwavas, waseg Seitan iyyakwen. Yam tasiyas nag ikamkwam ee... nakabiyokous waseg mo ivag anamoun. ");
INSERT INTO myw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yeisuw anamoun, Seitan mo idibek, ilana, “Magat Yowbad Natun yak, kadiloka kudibek dakul towen, mo bimlavag kam.” ");
INSERT INTO myw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iw to Yeisuw, ilana, “Liva̱nen nises Bukitab waseg mamagina: ‘Makava kan nag biyamov gamag.’” ");
INSERT INTO myw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Wankuyeim Seitan mo itok inow wanakaew, ikatimlek ven babaw wadaban pwepway. Sivtanok ikin ikous; mo Seitan ilivan, ilana, “Ven tasiyas son yakawanan basekeim mukwaleiwag, peinan gunakaleiwag towen. Am-towen sivinag mo basek. Magat yak bukukulul wamatag, mo basekeim silma̱nin mukwaleiwag.” ");
INSERT INTO myw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iw to Yeisuw, ilana, “Liva̱nen nises Bukitab waseg mamagina: ‘Kadiloka bukukulul wamatan Guyaw Yowbad. Mtowen anmwa̱net bukwanow aygan.’” ");
INSERT INTO myw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","10","Mo itok Yeisuw inow Yelusalem, isen Yowbad nabunatum wankunumwan, idibek, ilana, “Magat Yowbad Natun yak, kwaspepel kun watinow. Liva̱neim nises Bukitab waseg, ‘Bo bisek nataka̱yobs siwotet mo bimtakavateims.’ ");
INSERT INTO myw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Kweitan livan nises mamagina: ‘Nimes waseg binupeims; Mata ge kakeim beiweiy dakul.’” ");
INSERT INTO myw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iw to Yeisuw, ilana, “Livan nises mamagina: ‘Awoum kuyakwen muGuyaw Yowbad.’” ");
INSERT INTO myw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitan iyakous ansinap babaw waseg iyakwen Yeisuw, mo ilisow, in, ikayamat kweitan tut, idok beiyum binek. ");
INSERT INTO myw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yowbad Kululuwan natawtoun waseg Yeisuw, mo iyum in Galiliy; bulagan in ven babaw Galiliy walasin. ");
INSERT INTO myw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ven babaw sisinagog katanok katanok waseg ikkatimlakay, mapuna gamag babaw ikavasis mtowen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ikous, mo in Nasalet, ven towen nituyay-yay waseg; isiw in wasinagog, ma̱wan ankikun, peinan Sa̱bat. Mo itamanaw va̱gan bivin Bukitab. ");
INSERT INTO myw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Itamanaw, mo isekes buk bivin. Buk towen palopit Isaya inabuk. Ikaliyow buk towen iban mwaynatan yageivein waseg nilel mamagina: ");
INSERT INTO myw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Yowbad Kululuwan waseg yey. Bo isekeig gunawotet va̱gan bageiguy livan bwein, basekes tasiyas tasimavs. Bo ikayabeig nam badibakes tasiyas wa̱deil mo bisaps bineis wamnat. O tasiyas toukwaws mo bikines. O tasiyas, abes igeg, batokes banawes bwanabwein keb waseg. O baliwon baka̱mat Yowbad anbweilim waseg igaw mo bilabeimiy.” ");
INSERT INTO myw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ivin ikous, ikatibog buk towen, isek tanuwagan, mo isin. Tasiyas nisesus wasinagog mites meivek-wan igintoves Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Isin towen, mo idibakes, ilana, “Kweiboug Bukitab nilivnek youd towen, tage nagein bo ikamat; yakamiy nukuliganes.” ");
INSERT INTO myw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Asibabaw asilivan idokes Yeisuw ansinap bwein. Ikatiliganes anilivan peinan singay bwein, mo isom ninous, ikatugans; ilansa, “Tabta mtowen Yosep natun, ne? Ama̱wan bikakin sinap towen?” ");
INSERT INTO myw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iw to Yeisuw, ilana, “Mounid bukudibakeigs adilivans mamagin: ‘Doket ya̱koum, kuva̱geim tatoneim mo bukubwein!’ Adok bukulana, ‘Bulagam Kapaneyum waseg nakaligen, kuvag ma̱wan, wamven tatoneim.’” ");
INSERT INTO myw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeisuw mo ilivan, ilana, “Mounid adibakeimiy, gamag nag biliganes palopit anilivan wanven tatonen.” ");
INSERT INTO myw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Yeisuw ilivan-vak, ilana, “Anatut Ilaytiy nag ikweis kweis kweitoun bweilim mo tibukon kweinim katanok, o nakwabs singay babaw ven towen Yisleil waseg, tage Yowbad nag ikayeb Ilaytiy binek nakwab vinen-Yisleil va̱gan bimtakavet kan Ilaytiy, nag. Ikayeb Ilaytiy inek vinen-Sidon, nakwab na̱tan inaven Salepat. ");
INSERT INTO myw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Toulepel-vak singay babaw ven Yisleil waseg, tage palopit Ilays nag ivag ibweins; misinaka ivag ibwein gum-Siliy teitan yagan Na̱man.” ");
INSERT INTO myw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Tasiyas wanuwan sinagog iliganes Yeisuw anilivan towen, mo ikapasal nuwes, ituts, iyousis Yeisuw, inawes watoulan ven, itokes inawes dibwadeb tigtageg waseg, ven nikabis wakunuwatan, idokes bilaves bein watinow. ");
INSERT INTO myw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tage Yeisuw ilavay wanuwana gamag babaw, inoun in, ilisawes. ");
INSERT INTO myw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","32","Iwloubus in Galiliy ven yagan Kapaneyum. Sa̱bat waseg ikatimlakes gamag, mo isom ninous, peinan inakatimlakay tawtoun, ma̱wana takaleiwag tatonen. ");
INSERT INTO myw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Wasinagog towen gamag teitan, yeiluw kalbaleb nises wa̱won. Aygan avakaein iwak, ilana, “Ya! Aveiyag bukunuwakeig ya̱koum gum-Nasalet Yeisuw? Adok bukuyagageig, ne? Akakina yak, Yowbad Natun yak.” ");
INSERT INTO myw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tage Yeisuw ikan yeiluw towen, ilana, “Kukwa̱pay, kukilev taw towen.” Yeiluw ivag taw towen ikalouw imasis wapwepway wanuwes gamags, ikilev taw towen, inoun; tage taw towen bo ibwein, nag iyageg, nag. ");
INSERT INTO myw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bo isom ninous tasiyas, illivans sisiyas, ilansa, “Aw-sinap towen? Inakaleiwag tawtoun idibakes tasiyas yeiluw kalbaleb mo ikilaves gamags.” ");
INSERT INTO myw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bulagan in ven babaw Kapaneyum walasin. ");
INSERT INTO myw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeisuw itamanaw ilisow sinagog, inoun in Saymon wanbunatum. Saymon yawan nimmasis ankatoun, won mana̱wen vin singay muyamuy, initougs waseg Yeisuw va̱gan bileb. ");
INSERT INTO myw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iligen, inoun in, itamanaw itoun walasin, ikayeb katoun towen, mo iyenom. Bo ibwein, nuwanaw mo itamanaw ivag kaeis mo ikams. ");
INSERT INTO myw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wankuyeim ka̱las iseilil, mo imeyes takatouns waseg Yeisuw, askatoun kweitan kweitan; isen naman wawous tatanok tatanok, mo ibweins. ");
INSERT INTO myw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bwagaw-vak nibugawus gamag mwasanin, Yeisuw ivag mo ilisawes; iwkuwaks, ilansa, “Ya̱koum Yowbad Natun ya̱koum!” Tage Yeisuw ika̱nes; nag itam va̱gan bilivans, peinan iwtusis, ikakins mtowen Kelis, takatinabwein gamags. ");
INSERT INTO myw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Iyam ga̱boug mo inoun in ven makaw. Gamag babaw mo ineis ineves; iba̱nes mo inekes. Bikayuses kid Yeisuw; ilansa, “Awoum bukulisawem.” ");
INSERT INTO myw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iwa̱ge Yeisuw, ilana, “Nag! Kadiloka bageiguy liva̱nen Yowbad nakaleiwag, wasigeis ven kweitan kweitan. Yowbad nikayabeig nam silma̱nin nawotet towen.” ");
INSERT INTO myw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mo ita̱vin in igeiguy sinagog kweitan kweitan Yudiy waseg. ");
INSERT INTO myw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iggeiguy Yowbad anilivan ee... siva̱tan tut itamanaw wadadan yevagan nikatiboul yagan Genesalet. Singay babaw gamag katuyouns inekes, ipapeps wawous va̱gan biliganes anilivan. ");
INSERT INTO myw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Itabinis Yeisuw, mo ikin wag akiy nibiteilis wakawalaw; o tasiyas taplapouls bo ikawes siwoyim, inawes ilasa̱pis. ");
INSERT INTO myw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Itabinis Yeisuw, mo itouw kaytan wag, Saymon inawag, idibek Saymon, ilana, “Kwalises tasineikik-nen mo bageiguy.” E, ikayseles wag, isineikiks-nen, Yeisuw isin wa̱wag, itouvin mo ikatimlakes tasiyas wanakaew nisesus. ");
INSERT INTO myw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Illivan ikous, mo idibek Saymon ilana, “Tata̱bus taneis wabwanit, mo kupouls.” ");
INSERT INTO myw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Iw to Saymon, ilana, “Tamwey, nakaplapoul ee... iyam, bo nag. Tage peinan amlivan waseg mo ba̱poul vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Misinaka sawtanoka ilaves, mo ikwanes in singay babaw. Kakita bikalitounis woyim. Mapuna iloukwams, idibakes sisiyas, ilansa, “Wag kwayuwein kumeyes.” Imeyes kwayuwein wag, ilabes; idagis in, bo ika̱lawt wag akiy. Kakita bimukuls wag. ");
INSERT INTO myw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saymon Pita ikin in singay babaw; iwen Yeisuw, itapop, ikulul waskawan kaken, mo initoug, ilana, “O Guyaw, kunoun kun, kulisaweig, peinan takalbaleb yey.” ");
INSERT INTO myw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita anilivan ma̱wan, peinan iyow nuwes siney tasiyas; ikines asiyin singay babaw. ");
INSERT INTO myw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tasiyas-vak Sebediy nitun iyow nuwes. Yiges tasiyas Yemes, Yon. Sisiy Saymon taplapouls tasiyas. Yeisuw mo idibek Saymon, ilana, “Awoum beivag ampwa̱yat. Igaw bukwatikunakus gamags, ma̱wana wot waseg nukukwanes in.” ");
INSERT INTO myw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ibiteilis siwag ikous, mo ilisawes siwliyoug wa̱wag nises, ikikuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wankuyeim misik kweitan ven toulepel teitan mo inek, meivek kaleivin kakulikul. Im towen, ikin Yeisuw, ikalivatow kantukov wamatan, initoug waseg, ilana, “Guyaw, magat sivinam, bukuvag kaleivig beibwein.” ");
INSERT INTO myw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeisuw iligen, iyasel naman, ikabkwen won, ilana, “Bo bavag kaleivim beibwein.” Nuwanaw mo ibwein toulepel towen. ");
INSERT INTO myw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeisuw anilivan tawtoun mo ilivan, ilana, “Awoum kudibek teitan gamag; awoum. Tage kunoun kunek tanuwagan lun bikineim, mo kukow aleim mansiyas Moses nilivan, kusek Yowbad peinan bo kubwein, o gamag bikineims o bisimounids bo kubwein.” ");
INSERT INTO myw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ilivan; bo nag. Peinan bulagan bo in babaw gamag wasigeis; mo gamag singay babaw katuyouns kid biliganes aygan o bivag askatoun kweitan kweitan mo beibweins. ");
INSERT INTO myw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yeisuw gog ininoun-wan wanawoud, ininitoug waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yam kweitan waseg ikatimlakay, o tasitas Palisiy mwasanin sisiyas takatimlakeins kaleiwag mwasanin isinis wadadan. Tasiyas meinoy nimeis ven babaw Galiliy waseg o Yudiy waseg o Yelusalem waseg nimekes Yeisuw; o Yowbad natawtoun waseg Yeisuw, biva̱ges takatouns mo ibweins. ");
INSERT INTO myw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wankuyeim tawaw mwasanin bimeyes takatoun teitan nimmasis wa̱keb siwsawoul won. Sivines bimeyes wamatan Yeisuw bikin. ");
INSERT INTO myw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Iyokons, nag. Ta-ma̱wan. Gamag singay babaw. Mo imwens watapwan bunatum, ikiboulis tapwan, ikaygwagwes takatoun wakaban nimmasis, mo ibus in, iton Yeisuw wamatan o wanuwes gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeisuw ikin, ikakina singay inmises, o idokes bo bileb takatoun towen, mapuna ilivan, ilana, “Ya̱koum amsinap kalbaleb bo awid; bo ikous.” ");
INSERT INTO myw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tasiyas takatimlakeins kaleiwag sisiyas Palisiy bo isunasun ninous, ilansa, “Kal mtowen ilivan makaw, kalbaleb? Anmwa̱net Yowbad kadilok biwid sinap kalbaleb beikous.” ");
INSERT INTO myw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Yeisuw ikakin ninous, ikatimop asilivan, ilana, “Aveiyag wawun isunasun ninoumiy? Bweina balivan balana, ‘Bawid amsinap kalbaleb; beikous’? O bweina balivan-vak balana, ‘Kutamanaw kunoun’? Wotet akweiy gagab waseg yey. ");
INSERT INTO myw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Kadiloka kukwakins Gimgilitoun yey, o gunakaleiwag nises ven watinow va̱gan bawid gamag asisinap kalbaleb.” Mo idibek towen takatoun, ilana, “Adibakeim yak, kutamanaw, kukow a̱bam, kun wambunatum.” ");
INSERT INTO myw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nuwanaw mo itamanaw wamtes, ikow keb to nimsik, inoun, inow wanven; singaya iya̱kawn waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Asibabawa ikines, bo isom ninous, iyakawanes Yowbad, igoulus, ilansa, “Nageina mo nitakines sinap kweitan.” ");
INSERT INTO myw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wankuyeim Yeisuw isap, ikin takawein ta̱kis teitan, yagan Livay, nissin buntuman ta̱kis waseg, mo idibek, ilana, “Kubkunig.” ");
INSERT INTO myw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mtowen iligen, itamanaw, ilisow navavag babaw, inoun, ibukun Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ibukun, mo ivag kan wanbunatum silma̱nin Yeisuw beikam. O nimeis tasiyas takaweins ta̱kis babaw, sisiyas gamag singay babaw, ikamkwams sisiy Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tasiyas Palisiy sisiyas takatimlakeins kaleiwag ikines, ivtokays livan, idibakes inavamul, ilansa, “Aveiyag wawun kukwams o kumoums simwayas tasiyas takaweins ta̱kis o tasiyas takalbalebs?” ");
INSERT INTO myw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Iw to Yeisuw ilana, “Tasiyas toubweins nag sivines doket; misinaka takatouns. Nag am silma̱nin tasiyas toubweins, tage silma̱nin tasiyas asisinap kalbaleb, badawes va̱gan bikanavin ninous mo beibweins.” ");
INSERT INTO myw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wankuyeim idibakes Yeisuw, ilansa, “Yon inavamul singaya kutukut ipsapos o ininitougs waseg Yowbad, o tasiyas-vak Palisiy sivamul ipsapos o ininitougs; tage ya̱koum muvamul ikamkwams, imwamoums.” ");
INSERT INTO myw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Iw to Yeisuw, idibakes, ilana, “Sigeilin veivay waseg, ta-ma̱wan tasiyas tassagals beipos, peinan taveivay siney tasiyas nisesus. Tage igaw anatut waseg taveivay bilisawes, mo beipos tut towen waseg.” ");
INSERT INTO myw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kabebay kweitan idibakes, ilana, “Nag kal bisiled mwaynavaw kweim bibweil kweim mwaynaboug, peinan kweivaw kweim bo biyageg, o nag bibunek kweiboug kweim waseg. ");
INSERT INTO myw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Nag kal bivgog kunasoup kunaboug waseg wayn kweivaw, peinan beilol wayn mo bitavis kunasoup biyageg, o bo biyamkwen wayn. ");
INSERT INTO myw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Tage bivgog kunasoup kunavaw wanuwan, mo bises bwein. ");
INSERT INTO myw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Nag kal beimoum kweiboug wayn mo sivinan kweivaw. Ilana, ‘Peinan kweiboug bwanabwein.’” ");
INSERT INTO myw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wankuyeim, Sa̱bat waseg, ikanapels bag kweitan, siney navamul, mo inavamul ilpeleps wit mwanoug, inutus, ikimmayes va̱gan biba̱nes anagin beikams. ");
INSERT INTO myw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Palisiy mwasanin ikines, ilansa, “Aveiyag wawun kuva̱ges ma̱wan, kusiplaves Moses nakaleiwag?” ");
INSERT INTO myw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Iw to Yeisuw, ilana, “Adok bo kuvinis liva̱nen Deibid, ne? Peinan asimoun siney nagamag, isiw in wanuwan Yowbad nabunatum, ikow bled towen nisenas wamatan Yowbad, nikatibomes silma̱nin tanuwgwes lun beikams, o towen Deibid nag kadilok beikam. Tage peinan asimoun, ikam, mo isekes siney ikams.” ");
INSERT INTO myw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mo Yeisuw idibakes, ilana, “Gimgilitoun yey; takaleiwag Sa̱bat waseg, yey.” ");
INSERT INTO myw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kwayuwein Sa̱bat isiw in wasinagog ikatimlakay. Taw teitan nises, naka̱tay ipam. ");
INSERT INTO myw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tasiyas takatimlakeins kaleiwag sisiyas tasiyas Palisiy ikinbunikes, idokes kid bivag taw towen beibwein Sa̱bat waseg; bivag ma̱wan mo biyateles Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ikakina sikanuway, idibek towen toupam, ilana, “Kum, kutom towen.” Mo mtowen itamanaw im. ");
INSERT INTO myw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeisuw mo ikatiga̱nes, ilana, “Kadeg? Tab kadilok Sa̱bat waseg bitawotet bwein? o kalbaleb? Bitayamov gamag? o bitayageg gamag?” ");
INSERT INTO myw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeisuw ikines gamag tasiyas babaws ikous, wankuyeim mo idibek mtowen toupam, ilana, “Kudumwes namam.” Idumwes, bo ibwein. ");
INSERT INTO myw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tasiyas gog, bo ikapasal nuwes peinan iwotet Sa̱bat waseg, illivans sisiyas aveiyag binuwakes. ");
INSERT INTO myw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Misiya̱mun towen inoun in ven koyakoy waseg va̱gan binitoug waseg Yowbad; ininitoug ee... iyam. ");
INSERT INTO myw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iyam ga̱boug idawes navamul mo imekes. Waseg bod towen ikatigik inagamag, misinaka sinwatan teiy, va̱gan bimlavag aposol bikanawes kid aygan. ");
INSERT INTO myw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Tasiyas yiges mamagina: teitan Saymon, mo idok yagan Pita, o bwadan yagan Andiluw; o Yemes son Yon; o Pilip son Batolimiw; o Matiw son Tomas; o Alpiyow natun yagan Yemes; o talliwon towen yagan Saymon; o Yemes natun Yudas; o tayuwein Yudas Iskaliyot, mtowen bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Siney tasiyas iwloubus, itamanaws wasapon, sisiyas inavamul singay babaws; sisiyas babaw min-Yudiy o min-Yelusalem o tasiyas misikes ven Ta̱yil o Sidon wakawalaw, asibabaw nimeis kid biliganes aygan, o bivag va̱gan beibwein askatoun. ");
INSERT INTO myw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","O Tasiyas bwagaw nibugawus, ivag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Asibabaw sivines bikabikons wa̱won Yeisuw, silma̱nin natawtoun binekes kid tasiyas, mo beibweins. ");
INSERT INTO myw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Itamnow matan mo ikines navamul ilana: “Tamumwa̱saw yakamiy tasimavs, peinan Yowbad nakaleiwag nises wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Tamumwa̱saw yakamiy amimoun, bo bukwamuweips. Tamumwa̱saw yakamiy tavva̱lams, peinan bukugigs. ");
INSERT INTO myw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Kukin gamag mwasanin bikamliweimiy peinan agugwamag yakamiy, o kukin bipiyaveimiy o bitawyageimiy o bivtokeimiy livan, mamagina takalbaleb yakamiy, kadiloka kumwa̱saws avakaein, kusilasals, peinan maysamiy avakaein nises walba̱lab. Kweiboug timsiyas inuwakes tasiyas palopits ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Tage guyawaw yakamiy, kalbaleb bukulivatus, peinan maysamiy nukukwawes ven watinow, bo misinak. ");
INSERT INTO myw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Bo kukwamuweips yakamiy, tage kalbaleb bukulivatus, moun bikamateimiy. “Kugagigs tut towen, tage kalbaleb bukulivatus, bukuva̱lams. ");
INSERT INTO myw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tut towen gamag babaw ikavasimiy, tage kalbaleb bukulivatus. Peinan kweiboug timsiyas bo ikavasis tasiyas palopit tayyaweids. Yakamiy ma̱wana tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tage adibakeimiy taliganeins agulivan yakamiy: Kadiloka kusiwyoubus tasiyas nikamliweimiy. Kulabes tasiyas nikamliweimiy. ");
INSERT INTO myw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Kulivans bwein wasigeis tasiyas nikawtuneimiy. Kunitougs waseg Yowbad va̱gan bilabes tasiyas niyageimiy. ");
INSERT INTO myw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Kukin kal beiweiy silapam kutouvin-vak paliyuwein beiweiy. Kukin kal bikwey amukweim, kusek-vak musag. ");
INSERT INTO myw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Kukin kal tasimav binitoug waseg yak, kadiloka kusek. Kukin kal bikwey muwliyoug, awoum kulivan biyamen. ");
INSERT INTO myw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Ama̱wan sivinamiy gamag biva̱ges wasigeis yakamiy, kuva̱ges ma̱wan wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kukin bukusiwyoubus tasiyas nisiwyoubumiy nag ivag amisinap bwein. Takalbalebs-vak iva̱ges ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Kukin bukulabes tasiyas nilabeimiy nag ivag amisinap bwein. Takalbalebs-vak iva̱ges ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Kukin bukusekes miwliyoug wasigeis tasiyas kudokes igaw bimapus, nag ivag amisinap bwein. Tasiyas takalbalebs isekes sisiyas va̱gan igaw mo bimapus. ");
INSERT INTO myw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Tage yakamiy, kadiloka kusiwyoubus tasiyas nikamliweimiy, o kulabes gamag, kusekes miwliyoug. Awoum kunmises mapun bukukwawes. Bukuva̱ges ma̱wan agulivan, mo bukuba̱nes maysamiy avakaein, bukumlavags Yowbad nitun yakamiy. Peinan Yowbad issiwyoubus tasiyas tagidukis sisiyas takalbalebs babaw-wan. ");
INSERT INTO myw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Yakamiy-vak kadiloka binok nuwamiy wasigeis tasiyas; ma̱wan ansinap Tamads walba̱lab. ");
INSERT INTO myw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Awoum kudokes gamag mwasanin takalbalebs, ma̱wan Yowbad bidokeimiy takalbalebs yakamiy. Awoum kumapus asisinap; ma̱wan Yowbad bimop amisinap yakamiy. Tage kuwidis, kunumlaves asisinap, mo biwid amisinap yakamiy, binumlev. ");
INSERT INTO myw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Kusekes tasiyas, mo Yowbad bisekeimiy, miwliyoug bibabaw, bo bika̱lawt wasigeis yakamiy. Ama̱wan vakaeinan bukusekes simiyas, bo ma̱wana vakaeinan Yowbad bisekeimiy yakamiy.” ");
INSERT INTO myw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kweitan kabebay isekes mamagina: “Kukin toukwaw bimgwey toukwaw teitan, nag kadilok ked biba̱nes. Asteiy bo bikalivatows bineis wa̱leg.” ");
INSERT INTO myw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kweitan livan isekes mamagina: “Kukin tamwey kal bimulis natouwats, tasiyas navamul nag bikaleiwags; igaw gog biyakousis sitovek ansinap mo bimlavags ma̱wana tamwey towen. ");
INSERT INTO myw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Aveiyag wawun kukines musamus nises bwadam matan waseg, tage nag kukin amweilok avakaein matam toneim wanuwan? ");
INSERT INTO myw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Aveiyag wawun kudibek bwadam, kulana, ‘Gwade, bo bakablev musamus wamatam’ tage nag kukin amweilok matam toneim wanuwan? Tayyaweid ya̱koum, wanamug kwablev amweilok matam waseg, mo bukukin bunik musamus bwadam wamatan, bukwablev. ");
INSERT INTO myw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nag kadilok amweilok bwanabwein beiwuw gog anagin kalbaleb, nag; o nag kadilok amweilok kalbaleb beiwuw gog bwanabwein, nag. ");
INSERT INTO myw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“Bitakin wuwan mo bitakakin amweilok ama̱wan, bwein o kalbaleb. Adilaboub waseg nag bitalep yaveinun. Amweilok kulikoul waseg nag bitalep gleip, nag. ");
INSERT INTO myw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Gamag ma̱wan. Magat nanon bwein mo beivag ansinap bwein; tage kukin nanon kalbaleb mo beivag ansinap kalbaleb. Aveiyag gamag nanon bika̱lawt waseg, mo bisap wadon, billivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aveiyag wawun kudibakeigs kulansa, ‘Guntovek, guntovek,’ tage nag kwanawes aygag? ");
INSERT INTO myw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Kal yak bukumekeig, bukuligen agulivan o bukwanow aygag, bakabebay va̱gan bukukwakins ama̱wan amsinap. ");
INSERT INTO myw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Peinan ya̱koum ma̱wana taw teitan niwlul nabunatum, ikaviyeil in watinow va̱gan kakolan bunatum bisin wakunuwatan dakul. Iwlul iyakous mo ikweis avakaein, yevagam ila̱tay avakaein iwaweiy bunatum towen, tage nag igogewn, peinan iwlul bwein. ");
INSERT INTO myw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Tage kal yak bukuligen agulivan, tage nag bukwanaway aygag, ya̱koum ma̱wana taw teitan niwlul nabunatum, tage kakolan igwey, nikelay pwepway makaw waseg; yevagam mo ila̱tay avakaein, iwaweiy bunatum towen, nuwanaw mo ikalivatow, ikatagulek iyakous. Bo igak.” ");
INSERT INTO myw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Anilivan isekes gamag ikous, mo inoun in Kapaneyum. ");
INSERT INTO myw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ven towen mina-Lom sitakalikay nises; mtowen singay sivinan natouwat teitan; tage bo ikatoun avakaein mtowen natouwat. Kakita bo bikanig. ");
INSERT INTO myw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Takalikay towen iligen bulagan Yeisuw mo idawes min-Yudiy tammwayas mwasanin, ikayabes bikines Yeisuw, binitougs va̱gan beim bivag takalikay natouwat towen mo beibwein. ");
INSERT INTO myw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Min-Yudiy tasiyas inekes Yeisuw, igilagels, ilansa, “Bweina kuvag, peinan takalikay towen ansinap bwein, sivinan gamag ya̱kids mo iwlul dasinagogs.” ");
INSERT INTO myw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Yeisuw iligen, siney tasiyas ineis ee... kakita bisaps takalikay nabunatum waseg, takalikay towen mo ikayabes viyen mwasanin, imekes Yeisuw, isekes takalikay anilivan, ilansa, “Takalikay anilivan mamagina: Guyaw, awoum bivakaein muwotet. Yey toul wamatam yak. Awoum bukusiw wagunbunatum. Mapuna na-ikadilokeig bawekeim yak. Deisa kulivan mo beibwein guntouwat. Yey akakin kaleiwag. Gunakaleiwag nises wasigeis guntakanaviys. Badibek teitan, balana, ‘Kun,’ mo bein. Tayuwein badibek balana, ‘Kum,’ mo beim. O guntouwat badibek, balana, ‘Kuwtel wotet,’ mo biwtel. Bweina kulivan beibwein ankatoun.” ");
INSERT INTO myw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeisuw iligen anilivan towen, bo isom nanon, itouvin, idibakes asibabaw antabwa̱kuns, ilana, “Mounid nag aban gum-Yisleil binamis beibwein waseg yey, tage takalikay towen singay inamis bwein.” ");
INSERT INTO myw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ikous, takalikay natouwats tasiyas mo iyums ineis wanbunatum, iba̱nes natouwat, bo ibwein. ");
INSERT INTO myw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yamtan yam mo ineis ven yagan Neyn siney navamul sisiyas gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","13","Inounas ee... kakita bisaps wakalamatan ven, mo ilivatus tasiyas takaweins takanig nimeis, peinan bo bidibwanis. Takanig kuda̱taw, inan nakwab, tage towen natun anmwa̱net. Yeisuw ikin mana̱wen vin ivva̱lam siney ven gimgilis singay babaw. Yeisuw ikin, inok nuwan, idibek, ilana, “Mata kuva̱lam.” ");
INSERT INTO myw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mo imek takanig a̱ban, ikabkwen. Takaweins toumat tasiyas mo itomos. Mo idibek takanig, ilana, “Tawlat yak, adibakeim, kukit.” ");
INSERT INTO myw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mo takanig towen ikit, illivan. Yeisuw itok mo inow inan waseg. ");
INSERT INTO myw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tasiyas ikines, bo igeg ninous, iyakawanes Yowbad, ilansa, “Palopit avakaein bo isap wasigeis ya̱kids,” o ilansa, “Yowbad bo ilakwaneids inagamag ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bulagan towen in ven babaw wawnuwan Yudiy mo ibekena walasin Yudiy. ");
INSERT INTO myw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tasiyas Yon inavamul ikines, mo inekes Yon wa̱deil nises, ikamteles youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yon iligen, idouw navamul asteiy, ikayabes kid binekes Yeisuw bilansa, “Age ya̱koum Mesay? o nag? bakakaymet tayuwein beim?” ");
INSERT INTO myw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tawaw tasiyas inounas, inekes Yeisuw, ilansa, “Tabibapta̱ysein gamag towen Yon nikayabem nakam, kasekeim anilivan, ilana, ‘Age ya̱koum Mesay? o nag? bakakaymet tayuwein beim?’” ");
INSERT INTO myw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yam towen waseg, Yeisuw iva̱ges mo ibweins takatouns babaw, sisiyas tasiyas bwagaw nibugawus, o toukwaws babaw iva̱ges mo ikines. ");
INSERT INTO myw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","23","Yeisuw iligen asilivan Yon navamul tasiyas, ilana, “Kuyums, kwamtilakes Yon sinap towen nukukines o nukuliganes: toukwaws ikins bwein, takagayals inounas bwein, toulepels kulivis ibwein, takakons iliganes livan, takanigs ikits vayuwein, o tasiyas tasimavs bo inganegs agulivan bwanabwein. Gamag mwasanin idokes gunawotet nag ibwein, tage kalisiy ikalin nuwes waseg yey, mo bimwa̱saws tasiyas. E, kuneis, kudibakes Yon mamagin.” ");
INSERT INTO myw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yon inavamul iyums ineis, mo Yeisuw isilamaw liva̱nen Yon, idibakes gamag babaw, ilana, “Aveiyag silma̱nin bo kuneis wanawoud? Bukukines amweilok giligil, yag itow mo iguwen, ne? Adok nag. ");
INSERT INTO myw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Tage aveiyag silma̱nin bo kuneis wanawoud? Bukukines taw teitan anakweim maynamnabwein, ne? Adok nag. Peinan tasiyas asikweim singay maynamnabwein, abes bwanabwein king sibunatum wanuwan. ");
INSERT INTO myw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Tage aveiyag silma̱nin nukuneis wanawoud? Adok bukukines palopit, ne? Magen! Peinan mtowen Yon ilisawes tasiyas palopits. ");
INSERT INTO myw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","“Liva̱nen mtowen Bukitab waseg mamagina: ‘Bo bakayeb towen bikokew agulivan, bimgwayeim yak, bikaleil muked.’ ");
INSERT INTO myw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Mounid mtowen Yon ikalisawes gamag babaw wadaban pwepway; tage Yowbad nakaleiwag wanuwan asibabaw imugwas; Yon ikuyeim.” ");
INSERT INTO myw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","30","Iliganes Yeisuw anilivan towen, tasiyas takaweins ta̱kis sisiyas gamag babaw; ikavasis Yowbad, peinan bo itams waseg Yon inageiguy, ibapta̱yses tasiyas. Tage tasiyas Palisiy sisiyas tassinaps bo ipiyaves Yowbad nanon pines tatineis, o Yon nag ibapta̱yses tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Yeisuw mo ilivan, ilana, “Ama̱wan bakabebay va̱gan bukukwakins gudwouvaws yakamiy amisinap ama̱wan? Adok yakamiy ma̱wana gamagal iwliwals wavtakon ven, idibakes sisiyas, ilansa, ‘Kawaway kup tage nag kusilasals; ikous, mo kalloupid tage nag kuva̱lams.’ ");
INSERT INTO myw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","34","“Peinan tabapta̱ysein gamags Yon neim, nag ikam kan tonen, nag imwamoum wayn, mo kulansa ‘Takabala̱wein mtowen peinan baloum iweiy.’ Tage Gimgilitoun yey nam akamkwam, amwamoum, mo kulansa ‘Taw towen tagovek, ikamkwam o imwamoum avakaein, ikanubeins siney tasiyas takaweins ta̱kis o tasiyas takalbalebs.’ ");
INSERT INTO myw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Tage misinaka Yowbad nitun ikakins ansinap mounid.” ");
INSERT INTO myw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisiy teitan bo idow Yeisuw bein ikams son. Itam, isiw Palisiy wanbunatum, isin. ");
INSERT INTO myw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Isin, mo vinen ven towen ansinap kalbaleb iligen Yeisuw neisiw beikam Palisiy towen wanbunatum, mo ikow natagon wanuwan botol kakit, inow, itamanaw watibwelon Yeisuw, kaken walasin, ivva̱lam. Ivva̱lam, iwta̱wout mitinagin, ininein wakaken. Ikous, mo kunun vayvayov ikow wanaman, itanob. E, iviyom kaken, peinan singay ikalin nuwan; mo iptum natagon waseg. ");
INSERT INTO myw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tage tanuwagan bunatum, Palisiy mtowen ikin vin mana̱wen. Nanon waseg ivtok livan, ilana, “Kukin Yeisuw palopit bo bikakin kal vin mana̱wen ikabkwen won o bikakin ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iw to Yeisuw, ikatimop nanon, ilana, “Saymon, kweitan youd badibakeim yak.” Saymon ikatimop, ilana, “Aw-youd bukwatimlakeig?” ");
INSERT INTO myw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeisuw mo ikabebay, ilana, “Tamwey teitan waseg, asteiy gamag sikawlavag, teitan lakatunim kina, tayuwein sinawanim kina. ");
INSERT INTO myw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","“Asteiy nag ivag money waseg bimapus sikawlavag; mapuna iwidis iyakousis. Am-towen bikalin nuwan singay waseg?” ");
INSERT INTO myw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Iw to Saymon, ilana, “Adok mtowen nakawlavag avakaein niwid iyakous.” Yeisuw ilana, “Magen.” ");
INSERT INTO myw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mo itouvin bikin vin mana̱wen, idibek Saymon, ilana, “Kukin vin mana̱wen. A̱siw am wambunatum, nag yevagam kusekeig bawid kakeig; tage mana̱wen mitinagin bo idal kakeig mo itanob kunun waseg. ");
INSERT INTO myw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Na̱siw nam wambunatum, nag kumuloul waseg yey, tage mana̱wen vin isap ivviyom kakeig ee... nag iyakous. ");
INSERT INTO myw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Nag tagon kuptum kunug, tage mana̱wen vin bo iptum kakeig natagon mul waseg. ");
INSERT INTO myw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Mapun ansinap babaw kalbaleb bo awid bo ikous, mo ikalin nuwan avakaein; tage kukin kal bawid ansinap kakit kalbaleb, mo bikalin nuwan kakit.” ");
INSERT INTO myw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeisuw mo idibek vin mana̱wen, ilana, “Amsinap kalbaleb bo awid, bo ikous.” ");
INSERT INTO myw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Siney nikamkwams mo illivans sisiyas, ilansa, “Kal mtowen biwid gamag asisinap kalbaleb?” ");
INSERT INTO myw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tage Yeisuw idibek vin, ilana, “Nukusimounid waseg yey mapuna bo kubwein. Kunoun kun niwal waseg.” ");
INSERT INTO myw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Yam mwasanin wankuyeim mo ita̱vin ven babaw wasigeis, iggeiguy, o isekes anilivan bwanabwein, Yowbad inakaleiwag liva̱nen. Siney inavamul sinwatan teiy, sisiyas vinay mwasanin issekes kaeis yam katanok katanok ikams. Vinay tasiyas Yeisuw nivag mo ibweins kweiboug askatoun, peinan yeiluw niyagages. Na̱tan Meliy nididawes Magda̱lein, bo nikayeb yeiluw teinim teiy waseg, mo ilisawes, bo ibwein. ");
INSERT INTO myw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nayuwein vin yagan Yowan, Susa nakwav, mtowen tamtakavatein Elod nabunatum. Natounun Susana. Tasiyas sisiyas vinay babaw sivavag sam; issekes kaeis Yeisuw siney navamul yam katanok katanok ikams. ");
INSERT INTO myw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wankuyeim ven babaw gimgilis ikatuyouns inekes Yeisuw, gamag singay babaw, inakabebay mo isekes, ilana: ");
INSERT INTO myw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Talavein kaytul wit ispusoup wa̱bag. Ilivelov ee... kaytul mwasanin ikalka̱louw ininein wa̱ked. Gamag mo inounas ivva̱nis kaytul tasiyas, mo man iyoyows imimeis, ikikines, ikamkoums ikamiyeivis. ");
INSERT INTO myw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Kaytul mwasanin ikalka̱louws ininein wadikuda̱kul, isibwa̱sobs, mo ka̱las ikalin, ikalayyag; peinan nag ivag pwepway-nen. ");
INSERT INTO myw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Kaytul mwasanin ikalka̱louw ininein wapwepway son doudiw kaytul-nen. Son doudiw isibwa̱sobs; kasiyas doudiw bo iwkuva̱kaeins, mapuna wit iguya̱gweys. ");
INSERT INTO myw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Tage kaytul mwasanin ikalka̱louw ininein pwepway bwanabwein, isibwa̱sobs, iwkuva̱kaeins. Kaytul katanok ivag anagin lakatutan.” Ilivan ikous, mo ilivan, aygan avakaein, ilana, “Kal yak sam teigam, bweina kuligen.” ");
INSERT INTO myw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inavamul mo ikatugans waseg Yeisuw, sivines kid bikakins silawun kabebay. ");
INSERT INTO myw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iw to Yeisuw, ilana, “Yowbad bo itam wasigeis yakamiy va̱gan bukukwakins nakaleiwag sinapun, nisowum wasigeis babaw gamag. Tasiyas gog misinaka kabebay biliganes, Bikikines, nag gog biba̱nes silawun; o biliganes, nag gog bikakins silawun. ");
INSERT INTO myw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Silawun kabebay towen mamagina: kaytul ma̱wana liva̱nen Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Kaytul kasiyas wa̱ked ma̱wana tasiyas iliganes, waninous nises, mogo Seitan isap ikwey livan towen; matage isimounids Yowbad ankatuneib silma̱nin. ");
INSERT INTO myw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Kaytul kasiyas wadikuda̱kul ma̱wana tasiyas iliganes liva̱nen Yowbad, imwa̱saws-wan, tage nag isob wanuwes, tut kadilakus isimounids ee... Seitan iyakwanes mo ikalows. ");
INSERT INTO myw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Kaytul kasiyas ikalka̱louws son doudiw kaytul-nen ma̱wana tasiyas iliganes, inounas ee... ininuways livan towen son ven watinow ankanuway, o ininuways ven watinow mwa̱saw-nen; mapuna liva̱nen Yowbad nag ivag anagin. ");
INSERT INTO myw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Tage kaytul towen wasapon ma̱wana tasiyas asisinap bwanabwein, iliganes livan, iyyousis ikimtuwes, o ikaptules, mo ivag angis bwanabwein. ");
INSERT INTO myw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nag kal bivakanot lamp, mo loutan bikatigubweil wakunuwatan, o nag bisen lamp waskawan keb, nag; tage bisen wanakaew wakaban, mo tasiyas bisousiws wanuwan bunatum towen mo bikines mititeilin. ");
INSERT INTO myw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Peinan sinap babaw nisowmes nisesun-wan, igaw mo bikamat, wakamnat. ");
INSERT INTO myw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kuvna̱seimiy va̱gan bukuliganes bwein. Kukin kal navavag sam, mo bikatimweis bibabaw. O kukin navavag nag, mo bikwey aveiyag idok nises. Mounida beidev mtowen.” ");
INSERT INTO myw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inan siney Yeisuw budan mo binekes, nag gog, peinan gamag babaw katikunouks isibwades ked. ");
INSERT INTO myw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Teitan gamag ikow livan, ikaypwa̱lal in, idibek Yeisuw, ilana, “Inam siney budam nitowas watoulan, sivines bikineims.” ");
INSERT INTO myw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iwa̱ge Yeisuw, idibakes, ilana, “Kalisiy yakamiy bukuliganes liva̱nen Yowbad o bukutams waseg, yakamiy mamagina inag o budag yakamiy.” ");
INSERT INTO myw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yam kweitan, itouws wa̱wag siney navamul, idibakes, ilana, “Tadopels, taneis palata dadan yevagam towen.” Mo ikuks. ");
INSERT INTO myw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ikuks ee... bo imasis Yeisuw. Bwaw kweitan mo ilivatus; iwaweiy wag, yevagam bo neinay-o; kakita bimukuls. Bo igak. ");
INSERT INTO myw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Inekes Yeisuw, iwgunis, ilansa, “Tamwey, bo bitamta̱mats.” Iligen, ikit, ikan yag, ika̱nes kaysay tasiyas kuva̱kaein, mo iyenom. Niwal avakaein. ");
INSERT INTO myw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeisuw mo idibakes, ilana, “Aveiyag wawun amipwa̱yat? Adok nag kunmiseigs, ne, va̱gan balabeimiy?” Bo iwenes tasiyas, isom ninous, sisiyas wasigeis illivans, ilansa, “Adok kweitan gamag towen, idibakes yag son kaysay, mo ikanawes aygan!” ");
INSERT INTO myw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ikuks ee... ilugs min-Gelasin wasiven. Galiliy palatan, Gelasin palatan. ");
INSERT INTO myw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ilugs, Yeisuw in wanakaew mo ilivet gimgeilin ven towen; yeiluw neiweiys taw towen. Yam babaw nag issikam anakweim, nag ivag nabunatum. Sona mwadoyan nimmasis wakalawag. ");
INSERT INTO myw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mtowen im, ikin Yeisuw, mo iwak, ikalivatow, imasis kantukov wamatan Yeisuw, aygan avakaein waseg iyowal, ilana, “Aveiyag bukunuwakeig yey? O ya̱koum Yeisuw, Yowbad Tatawtoun Natun ya̱koum. Beitay! Awoum bukuyagageig, ne?” ");
INSERT INTO myw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Peinan Yeisuw bo nidibek yeiluw towen va̱gan bilisow taw. O peinan tut babaw yeiluw niwaweiys-wan mo ikabala̱wein, o gamag niyousis, imtakavates. Naman, kaken niyawanis tawtoun waseg, tage bo iwlitun; o yeiluw kawsep isawl in wanawoud; singaya iyageg gamag towen. ");
INSERT INTO myw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeiluw igilagel waseg Yeisuw ikous, mo Yeisuw ikatugan, ilana, “Ami-yagam?” Ilana, “Kamimet,” peinan yeiluw babaw neisiws wawnuwan. ");
INSERT INTO myw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Siyas yeiluw mo igilagels waseg Yeisuw, ilansa, “Awoum kwayabem bakan wa̱leg, ne?” ");
INSERT INTO myw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bwaloud babaw nikamkwams awuyow a̱ne wakaytet nitatos; siyas yeiluw igilagels, ilansa, “Tab kadilok baka̱siw bakanekes mansiyas bwaloud, ne?” Yeisuw itam. ");
INSERT INTO myw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Siyas yeiluw mo ilisawes taw, inekes bwaloud mo kabala̱weins, isisawls ikalka̱louws tigtageg, inineis wayvagam, iwgweles. ");
INSERT INTO myw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tasiyas tamtakivateins bwaloud ikines, mo isawls ikamteles youd to nikines, inineis ven waseg o nawoud waseg. ");
INSERT INTO myw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gamag babaw iliganes, isaps kid bikines; e, imekes Yeisuw, iba̱nes taw towen, bo nilisawes yeiluw. E, isin Yeisuw walasin, anakweim bo isikam, nanon bo idumwal; mapuna iwenes. ");
INSERT INTO myw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tasiyas nikines mo ikamteles, ilansa, “Taw towen takabala̱wein, yeiluw neiweiys, Yeisuw gog idibakes mo yeiluw ilisawes, o taw towen bo ibwein.” ");
INSERT INTO myw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ven walasin Gelasin gimgilis iliganes, ininitougs waseg Yeisuw, sivines kid Yeisuw beiyum; peinan aspwa̱yat avakaein. Mo itouw wa̱wag, iyum. ");
INSERT INTO myw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Mtowen neibwein yeiluw waseg mo initoug waseg Yeisuw, ilana, “Soug yak bitatouw,” tage Yeisuw ikayeb, ilana, “Kuyum kun wambunatum; kwamtel Yowbad nasiwa̱youb waseg ya̱koum.” Mo inoun in ikamtilakes ven avakaein wawnuwan, mo ikakins Yeisuw nasiwa̱youb bwanabwein waseg. ");
INSERT INTO myw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeisuw iyum im Galiliy, gamag babaw nikaymates, mo imwa̱saws peinan bo iyum. ");
INSERT INTO myw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Takalawagein sinagog teitan yagan Yelos inek Yeisuw, ikulul wamatan, initoug waseg, ilana, “Kum wagunbunatum, kukin natug ikatoun avakaein.” Natun mana̱wen anbweilim sinwatan akweiy. Idokes kakita bikanig. Asteiy inounas, tage gamag singay babaw katuyouns imimekes, ipapeps Yeisuw wa̱won. ");
INSERT INTO myw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na̱tan vin nises buya̱vin iwta̱wout sinwatan kweiy bweilim, tage nag kal ikakin bivag beimad. ");
INSERT INTO myw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mana̱wen vin meinoy Yeisuw watibwelon, ikabkwen anakweim matan; nuwanaw buya̱vin mo imad. ");
INSERT INTO myw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iwa̱ge Yeisuw, ilana, “Kal ikabikon waseg yey?” Asibabaw ikayans, ikous, mo Pita idibek ilana, “Tamwey, gamag singay babaw ipapeps wa̱woum.” ");
INSERT INTO myw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tage Yeisuw ilana, “Teitan gamag bo ikabikon waseg yey, peinan asimkwen guntawtoun bo ilisaweig, bo inek gamag towen.” ");
INSERT INTO myw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Vin mana̱wen ikakin ta-ma̱wan bisowm, itatat won, inek, ikulul wamatan, ika̱mat wamtes gamag babaw, ilana, “Peinan sivinag ba̱bwein, to nakabkwen anakweim matan; nuwanaw mo a̱bwein.” ");
INSERT INTO myw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iw to Yeisuw, ilana, “Natug yak, nukusimounid waseg yey, mapuna bo kubwein. Ninabwein waseg kunoun.” ");
INSERT INTO myw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Igawa illivan, takaleiwag towen inagamag teitan imek, ilana, “Bo igeg! Natum bo ikanig. Awoum kweitan wotet kusek mtowen takatimlakay.” ");
INSERT INTO myw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeisuw iligen, iwa̱ge, ilana, “Awoum beivag ampwa̱yat. Bweina kusimounid va̱gan beibwein natum.” ");
INSERT INTO myw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yeisuw mo isap wabunatum ilana, “Awoum babaw gamag bukusiws waseg yey. Adok Pita, Yon, Yemes, o gwad taman, inan. Misinak.” ");
INSERT INTO myw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ikin tasiyas tavva̱lams ivva̱lams peinan loupid iva̱ges, ilana, “Awoum kuva̱lams. Na-ikanig gwad mana̱wen; immasis-wan.” ");
INSERT INTO myw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tasiyas gog bo isiba̱wes, peinan ikakinsa bo ikanig. ");
INSERT INTO myw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tage Yeisuw inek mana̱wen gwad, iyous naman, ilana, “Gwa! Kukit!” ");
INSERT INTO myw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mo iyum kululuwan; nuwanawa ikit. Yeisuw mo ilana, “Kusek kan beikam.” ");
INSERT INTO myw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tasiyas inan taman bo isom ninous, tage Yeisuw ilana, “Awoum kwamteles gamag biliganes sinap towen. Awoum.” ");
INSERT INTO myw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mo idawes inavamul sinwatan teiy, imeis mo isekes sikaleiwag o sitawtoun wasigeis tasiyas bwagaw, baloum, katoun. ");
INSERT INTO myw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mo ikayabes kid biggeiguys liva̱nen Yowbad nakaleiwag o biva̱ges va̱gan beibweins tasiyas takatouns. ");
INSERT INTO myw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Idibakes tasiyas, ilana, “Awoum kuneis kukwawes kunamiy, mikaytuk awoum, amikaw awoum, kaeimiy awoum, mimoney awoum; awoum mwaynatan kweim, awoum. ");
INSERT INTO myw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Avei-bwan waseg bukusiws bukumsikes ee... mo bukunounas kuneis. ");
INSERT INTO myw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Am-palawen nag beitams wasigeis yakamiy, bukulisawes ven towen mo musamusan pwepway wakikeimiy kwatsa̱pis bein waven mo bikakins Yowbad bimop asisinap.” ");
INSERT INTO myw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mo inounas, ita̱vins ven katanok katanok waseg, iggeiguys livan bwanabwein o takatouns iva̱ges ibweins ven katanok katanok waseg. ");
INSERT INTO myw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Inounas ee... guyaw avakaein Elod iligen bulagan Yeisuw siney navamuls, bo isunasun nanon, peinan gamag mwasanin asilivan, ilansa, “Yon nikanig, bo ikit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tage mwasanin ilansa, “Ilaytiy bo isap.” O mwasanin ilansa, “Palopit kweiboug teitan bo ikit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Elod iligen asilivan, ilana, “Yon bo abob kayon, tage kavel mtowen alligen nawotet bulagan, ivag ma̱wan?” Mo Elod sivinan bikin. ");
INSERT INTO myw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iyakousis siwotet tasiyas Yeisuw nikayabes, mo iyums, imekes Yeisuw mo ikamteles siwotet liva̱nen. Mo Yeisuw itokes tasiyas-wan ineis ven yagan Beteseid. ");
INSERT INTO myw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gamag babaw iliganes mo ikikunis. Yeisuw ikines, itam wasigeis; isekes liva̱nen Yowbad nakaleiwag, o takatouns tasiyas ivag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iwwotet ee... bo ikwayav, tasiyas sinwatan teiy inekes, ilansa, “Kwayabes gamag babaw, bineis ven mwasanin o bineis nawoud waseg, kaeis biba̱nes o bimasis, peinan ven towen makawan.” ");
INSERT INTO myw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iwa̱ge Yeisuw, idibakes, “Kusekes kaeis beikams.” Ilansa, “Yakamey kaem misinaka bled kweinim son in mwanay, tage nag kadilokes asibabaw beikams. Adok bakan waven bakagimwal kaeis bakamey, beikams, ne?” ");
INSERT INTO myw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tawaw babiweis mamagina kweinim tawsan. Yeisuw mo idibakes navamul, ilana, “Kudibakes tasiyas bisinis bod kweitan kweitan waseg. Kweitan bod sinwanim gamag, kweitan bod simwanim gamag.” ");
INSERT INTO myw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iva̱ges ma̱wan mo isinis asibabaw-wan. ");
INSERT INTO myw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ikous, Yeisuw mo ikow bled kweinim son in mwanay, itamnow kayon, ikin walba̱lab, anilivan bwanabwein isek, silma̱nin kan towen, mo ikikivis, issekes navamul, ikawes, isenas wamtes gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Asibabaw ikams ikamuweips; mo isiyavis kan nikambwages nises, gamwat sinwatan gibsiy. ");
INSERT INTO myw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kweitan tut siney navamul mtowen Yeisuw anmwa̱net initoug waseg Yowbad; ikous, mo ikatugan wasigeis tasiyas ilana, “Gamag babaw idokeigs kal yey?” ");
INSERT INTO myw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ikatimapus aygan, ilansa, “Tabibapta̱ysein gamags Yon adok; o mwasanin idokeims Ilaytiy; o mwasanin idokeims kweiboug palopit teitan ya̱koum nukukit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iwa̱ge Yeisuw, ilana, “Age yakamiy, kudokeigs kal yey?” Pita ikatimop aygan, ilana, “Ya̱koum Kelis, Yowbad nikayabeim nukum bukwatinabwem.” ");
INSERT INTO myw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Tage Yeisuw anilivan tawtoun isekes, ilana, “Awoum kwamteleigs wasigeis gamag mwasanin.” Ilana, “Gimgilitoun yey, kadiloka a̱bag bigeg singay, o tammwayas bipiyaveigs sisiyas tanuwgwes lun o tasiyas takatimlakeins kaleiwag. Ikous mo bikatimateigs; yam kweitoun mo ba̱kit.” ");
INSERT INTO myw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeisuw idibakes asibabaw, ilana, “Kukin kal bikikun waseg yey, kadiloka bipiyev mwamovan tatonen, anklos bikokew yam katanok katanok mo bibkunig. ");
INSERT INTO myw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Kalisiy yakamiy bikayus mwamovan tatonen igaw mo biyamkwen, tage kukin biyamkwen mwamowan peinag yey mo bises bwein. ");
INSERT INTO myw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Kukin kal bikow youd babaw nisesus wadaban pwepway, mo biyamkwen mwamovan tatonen; tage nag bimwa̱saw mtowen, nag. ");
INSERT INTO myw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Kukin kal beivag anmwasin peinan iligen agulivan o peinan gungamag mtowen, igaw Gimgilitoun yey ba̱yum bam ven watinow mo beivag agumwasin waseg gungamag towen. Peinan igaw ba̱yum bam, yakawanag waseg, o Tamag yakawanan waseg, o tasiyas nataka̱yobs yakawanes waseg. ");
INSERT INTO myw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Mounid adibakeimiy mwasanin yakamiy nukutomos, nag bukukwanigs ee... mo bukukines Yowbad nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yam kweinim kweitoun ikous, itokes siney asteitoun, Pita, Yon, Yemes, ikatulags ineis wa̱koy va̱gan binitougs waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yeisuw ininitoug ee... ankakin iviwl ivag kweitan-wan, anakweim-vak bo ilapupwa̱kaw singay. ");
INSERT INTO myw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Asteiy sisiy Yeisuw bo isaps, illivans. Mtasiyas Moses son Ilaytiy bo isaps, kamnat avakaein waseg. Illivans sisiy Yeisuw liva̱nen nakanig igaw mo bilivet Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita siney tasiyas bo imasis ikangagays mo ikits, ikines sikamnat tasiyas Yeisuw siney tasiyas asteiy. ");
INSERT INTO myw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tasiyas asteiy bo beiyums, Pita idibek Yeisuw, ilana, “Tamwey, bweina bitasesus towen. Bo bakawlul bunatum kweitoun, bunatan yak, bunatan Moses, bunatan Ilaytiy.” Ta-ivag silawun; makava ilivan Pita. ");
INSERT INTO myw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Igaw illivan, lov kweitan im ilumwes; tasiyas wanuwan, bo iwenes. ");
INSERT INTO myw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aygan teitan wanuwan lov iliganes, ilana, “Mtowen Natug bwanabwein. Bweina bukuliganes aygan!” ");
INSERT INTO myw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ilivan ikous, mo ikines Yeisuw anmwa̱net nises. Youd towen nikines bo isowmes. Misiya̱mun towen nag ikamteles gamag wasigeis, nag. ");
INSERT INTO myw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iyam nen ga̱boug Yeisuw siney nagamag iwloubus ineis watinow, inounas mo inekes gamag babaw bo nimimeis. ");
INSERT INTO myw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Teitan siney tasiyas iwak, ilana, “Tamwey, kukin natug kuda̱taw. Peinan natug anmwa̱net-wan, yeiluw iwaweiy, isiblut waseg, iwak, itatat won mo ika̱poul wadon, mo bigulek won. Nag biyeiwas waseg. ");
INSERT INTO myw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Bo anitoug wasigeis muvamul va̱gan bikayabes yeiluw, tage nag kadilokes.” ");
INSERT INTO myw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iw to Yeisuw ilana, “Takakon yakamiy. Bo kawegweis woug wasigeis yakamiy. Natum kumey bakin.” ");
INSERT INTO myw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bimeyes kid gwad towen Yeisuw waseg, mo yeiluw iweiy, igulek won, itatat; tage Yeisuw ikan yeiluw towen, ikayeb, mo ibwein gwad; mo iyamen isek taman. ");
INSERT INTO myw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Asibabaw bo isom ninous peinan nikines Yowbad natawtoun. Ikines nawotet babaw, isunasun ninous ee... mo Yeisuw idibakes navamul ilana, “Livan towen kuninuways beibwein, peinan igaw mo bisilkodeigs, Gimgilitoun yey, va̱gan gamag beiweigs.” ");
INSERT INTO myw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tage nag ikakins silawun anilivan towen, mamagina bo isowm wasigeis, va̱gan nag bikakins. Bo igoulus, aspwa̱yat gog bikatugans waseg towen, va̱gan silawun bikakins. ");
INSERT INTO myw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wankuyeim mo ikamnimans sisiyas, sivines kid bikakins kal bikow yagan avakaein mo bimlavag astamumug. ");
INSERT INTO myw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Tage Yeisuw ikakin sikanuway, mo itok gwad teitan, isen wadadan, idibakes, ilana, “Kal yak bukutam waseg gwad towen peinan agugwamag, bo kutam waseg yey; o kal yak bukutam waseg yey bo kutam waseg towen nikayabeig nam, mtowen Tamag. Kalisiy tamumug wasigeis yakamiy? Mounid siyas takekels bimgwayeimiy; guyawaw nag.” ");
INSERT INTO myw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iwa̱ge Yon ilana, “Tamwey, nakakin taw teitan nikayabes yeiluw yagam waseg, mo kasibwed, peinan nag sidayas mtowen.” ");
INSERT INTO myw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeisuw gog ikatimop anilivan, ilana, “Awoum kusibwades. Kukin kal nag bisibwadeimiy bo ilabeimiy.” ");
INSERT INTO myw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","52","Wankuyeim kakita bilivet tutan beimwen bein wanakaew, mo itamanaw silma̱nin bein Yelusalem. Bo ikayabes nagamag mwasanin va̱gan binounas wamatan bineis kweitan ven Samaliy gimgilis bidibakes, bilansa, “Kwatunags. Matovek wankuyeim mo beim.” ");
INSERT INTO myw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tasiyas gog min-Samaliy bo ipiyaves Yeisuw, peinan bein Yelusalem. ");
INSERT INTO myw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Siyas inavamul Yemes son Yon ikines bo nipiyaves, ilansa, “Guyaw, tab sivinam bakadibek kov bikalivatouw walba̱lab bigabus tasiyas, ne?” ");
INSERT INTO myw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Tage Yeisuw itouvin, ika̱nes, ilana, “Awoum.” Mo inounas, ineis ven kweitan. ");
INSERT INTO myw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Inounas wa̱ked, teitan taw idibek Yeisuw, ilana, “Babkunim ampalawen bukun.” ");
INSERT INTO myw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iw to Yeisuw, ilana, “Awuk sibunatum wakiwmawum, o mansiyas man sibunatum wakamweilok, tage Gimgilitoun yey ta-ivag abkunug bamasis.” ");
INSERT INTO myw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeisuw idibek tayuwein, ilana, “Kubukunig yey.” Iwa̱ge towen, ilana, “Tab kadilok bakaymet tamag ee... beikous, bikanig, bakadibwen, mo baw.” ");
INSERT INTO myw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeisuw gog ilana, “Tamam ga-ises; bikanig, tatineis bidibwanis; tage yak, kun kugeiguy liva̱nen Yowbad nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tatounun gamag ilana, “Babkunim gunguyaw yak; tage wanamug ban amuloul wasigeis agugwamag waven nisesus.” ");
INSERT INTO myw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iwa̱ge Yeisuw, ilana, “Kukin kal bikavaveis, tage bitouvin beiyey wankuyeim, mtowen nag kadilok Yowbad nakaleiwag, nag.” ");
INSERT INTO myw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wankuyeim siwotet Yeisuw isekes-vak inagamag sinwanim sinawey, ikayabes va̱gan bineis bimugwas, asteiy asteiy, bineis ven katanok katanok. Tasiyas bimugwas; Yeisuw bitita̱vin wankuyeim. ");
INSERT INTO myw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Idibakes, ilana, “Kan bitata̱yoys singay babaw, tage tawteleins bag nag ibabaws. Kadiloka kunitougs waseg tanuwagan ta̱yoy va̱gan bikayabes nagamag mwasanin bilabeids inata̱yoy waseg. ");
INSERT INTO myw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Bo akayabeimiy, ma̱wana sip nitsiyas yakamiy, bukunekes tasiyas mamagina awuk takananeiys. ");
INSERT INTO myw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Awoum amikaw kukokews, awoum gamwat, awoum sandol; awoum bukulouvats gamag wa̱ked, bukukwaypuls; awoum. ");
INSERT INTO myw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Aw-bunatum bukusiw wawnuwan, wanmugwana bukulivan Yowbad yagan waseg, kulana, ‘Niwal biwekeimiy yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Kukin tanuwagan bunatum ansinap niwal, mo beitaw nuwan mtowen; kukin gog nag, amilivan bwein mo beiyum wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Aw-bunatum waseg bukusikes, aveiyag bisekeimiy bweina kukwams o kumoums. Peinan tawteleins wotet yakamiy, kadiloka kukwams wotet anagin. Awoum kwaninapels bunatum kweitan kweitan. ");
INSERT INTO myw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","“Kukin bukusunaps kweitan ven o taginvens beitams wasigeis yakamiy, kaeimiy bisekeimiy bweina kukwams; o takatouns kuva̱ges beibweins; o kudibakes tasiyas, kulansa, ‘Yowbad nakaleiwag bo isap wasigeis yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","“Tage kukin bukusunaps kweitan ven o towous nag beitams wasigeis yakamiy, kulivans wavtakon ven, kulansa, ‘Kapiyaveimiy yakamiy, simiyas musamusan pwepway wakikem kakatsap bininein wamiven; tage kadiloka kuninuways Yowbad nakaleiwag, peinan bo isap wasigeis yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Adibakeimiy, igaw Yowbad bimop ven babaw asisinap kalbaleb, ven Sodom mapun bilivatus kalbaleb, tage ven towen bipiyaveimiy mapun singay kalbaleb bilivatus. ");
INSERT INTO myw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Yakamiy min-Kolasin, o min-Beteseid yakamiy, singay kalbaleb bukulivatus. Nukukines gunawotet tawtoun, tage nag kupiyaves amisinap kalbaleb. Kukin kweiboug min-Ta̱yil o min-Sidon bikines gunawotet tawtoun mogo bigeg ninous bipiyaves asisinap kalbaleb, bikumus wous son asikweim kalbaleb, gunugoun, o adok sewed, peinan bikakinsa asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Igaw Yowbad bimop ven babaw sikalbaleb, tasiyas min-Ta̱yil o min-Sidon bilivatus mapun sikalbaleb, tage yakamiy singay kalbaleb bukulivatus. ");
INSERT INTO myw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“O yakamiy-vak min-Kapaneyum kudokes bukumwens kuneis walba̱lab, adok bukubus bukuneis watinow.” ");
INSERT INTO myw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ikous anilivan towen, mo idibakes navamul, ilana, “Kukin kalisiy biliganes agamiy, biliganesa aygag. Kukin gog kalisiy bipiyaveimiy, bipiyaveigs yey. Kalisiy tasiyas bipiyaveigs, bo ipiyaves Tamag, towen nikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tasiyas sinwanim sinawey ineis, iwotets ma̱wan, mo iyums, imwa̱saws avakaein, ilansa, “Tamwey, yagam waseg kadibakes siyas bwagaw, mo ikilovs sinap kalbaleb waseg.” ");
INSERT INTO myw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeisuw gog idibakes, ilana, “Bo akin Seitan walba̱lab ikalivatouw ma̱wana kavikawn, in watinow. ");
INSERT INTO myw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Bo asekeimiy mikaleiwag va̱gan bukuvtakus mwatets sisiyas bobos bwabwels, tage nag bigadeimiy; mo bukutawtouns waseg Seitan inakaleiwag babaw. ");
INSERT INTO myw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Tage silawun mimwa̱saw nag peinan tasiyas bwagaw ikanawes agamiy. Silawun mimwa̱saw peinan Yowbad bo nilel yigamiy walba̱lab.” ");
INSERT INTO myw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Misiya̱mun towen Yeisuw bo imwa̱saw Yowbad Kululuwan Bwanabwein waseg, ilana, “Kalin nuwag Tamag ya̱koum, ven watinow son liba̱lab sitovek ya̱koum, peinan nukusowm sinap towen, awoum tasiyas tassinaps bikakins, misinaka siyas ninous ma̱wana pwa̱pwaw. Mounid, Tamag, ma̱wan nanoum tatoneim bwanabwein. ");
INSERT INTO myw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamag bo itam youd babaw waseg yey. Nag kal ikakin Natun; misinaka Tamag. Nag kal ikakin Tamag; misinaka Natun yey, sigwey kalisiy sivinag bakamtel wasigeis mo bikakins Tamag.” ");
INSERT INTO myw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mo itouvin idibakes navamul, tasiyas-wan idibakes, ilana, “Tamumwa̱saws tasiyas, kalisiy mites bikines sinap towen nukukines. ");
INSERT INTO myw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","“Mounid adibakeimiy, kweiboug palopit babaw sisiyas guyawaw babaw ivag sivines bikines sinap towen nukukines, nag gog ikines. O tasiyas sivines biliganes sinap towen nukuliganes nag gog iliganes.” ");
INSERT INTO myw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wankuyeim tassinap teitan inek Yeisuw, idoki biyakwen; ilana, “Takatimlakay yak. Aveiyag yey bavag va̱gan mwamovag bises bisigeg?” ");
INSERT INTO myw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iw to Yeisuw, ilana, “Kuninuway Moses nakaleiwag. Aveiyag nilel?” ");
INSERT INTO myw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ikatimop, ilana, “Kadiloka kusiwyoub Guyaw Yowbad, a̱teim waseg, kululuwam waseg, mutawtoun waseg o nanoum waseg; o kuvnas-vak soum ma̱wana kuvna̱seim tatoneim.” ");
INSERT INTO myw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iwa̱ge Yeisuw, ilana, “Magen! Kukin bukuvag ma̱wan mo bukumov.” ");
INSERT INTO myw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tage taw towen, idok ansinap tonen didumwal, ikatigan Yeisuw, ilana, “Kavel soug bavnas?” ");
INSERT INTO myw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeisuw ikatimop anilivan, ikabebay, ilana, “Teitan taw meinoy neim Yelusalem, iwloubus bein Yelikow. Ininoun ee... tavveinaws mwasanin ituts iweis, iyousis taw towen, ikawes anakweim, iwaweiys ikous, mo ilisawes taw towen immasis, bo katimlowus won. ");
INSERT INTO myw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Yam towen tanuwagan lun teitan idoki biwloubus ked towen waseg, inoun ee... iwekey mtowen taw nimmasis wa̱ked, nag inek, ilisow ises, inoun-wan. ");
INSERT INTO myw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Livay tabun teitan mo iwloubus iwekey mtowen nimmasis wa̱ked, ikin, nago inek, ilisow ises, inoun-wan. ");
INSERT INTO myw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","“Tage gum-Samaliy teitan, ininoun, iwekey nimmasis wa̱ked, ikin, ikalin nuwan, inek, iyakit, ikabiyuv ansasok waseg antagon son wayn, mo isumweil. Ikous mo inup, isen a̱len donkiy watapwan, ivakaben donkiy, inow bunatum kweitan nises wa̱ked, mo ivnas wabunatum. ");
INSERT INTO myw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Iyam nen ga̱boug, mo ikow akweiy kina, isek tanuwagan bunatum, ilana, ‘Kuvnas gamag towen beibwein; o kukin money towen nag kadilok, igaw ba̱yum bam bamop.’” ");
INSERT INTO myw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeisuw mo ilivan, ilana, “Gamag asteitoun iwekes sisiy nimmasis wa̱ked; tage kal ivnas?” ");
INSERT INTO myw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iwa̱ge towen, ilana, “Adok towen ikalin nuwan, mo ileb.” Yeisuw mo idibek, ilana, “Ya̱koum kun, bukuwtel ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeisuw siney nagamag inounas oko isaps kweitan ven; na̱tan vin Ma̱lid itam nabunatum, anbwabwal tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma̱lid bwadan Meliy isin Yeisuw wadadan, iligen nakatimlakay. ");
INSERT INTO myw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mana̱wen Ma̱lid ivag kaeis beikams, inawotet singay babaw, mapuna inek Yeisuw, ilana, “Guyaw, ta-bukukin bwadag nilisaweig agumwa̱net bavag kaeimiy bukukwams. Kudibek beim bilabeig.” ");
INSERT INTO myw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Iwa̱ge Yeisuw, ilana, “Ikubukub nuwam peinan nanoum babaw, tage kweitan sinap ika̱bwag waseg ya̱koum. Meliy gog sivinan sinap towen bwanabwein; iligen aygag. Bweina bises bikatiluteg agulivan.” ");
INSERT INTO myw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ven kweitan waseg Yeisuw bo ikulul, ininitoug waseg Yowbad; ikous, inavamul teitan idibek, ilana, “Tamwey, kwatimlakem bakanitoug waseg Yowbad; ma̱wan Yon nikatimlakes tasiyas inavamul.” ");
INSERT INTO myw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iw to Yeisuw, ilana, “Bukunitougs, kulivans, kulansa: ‘Timem, bakagoul yagam. Mukwaleiwag beim. ");
INSERT INTO myw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kaem bukusekem nagein. ");
INSERT INTO myw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kunumlev amasinap kalbaleb, peinan yakamey kanumlev gamag asisinap kalbaleb wasigeis yakamey. Tage awoum bukusenam abiyokon waseg.’” ");
INSERT INTO myw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Mo idibakes, ilana, “Kal yak bukunek nubeim watapwan boug, bukulana, ‘Gwa, kusekeig bled kweitoun, agubwabwal beikam; peinan mwana isap, anamoun; ta-ivag kan basek beikam.’ ");
INSERT INTO myw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Nubeim adok wanuwan nabunatum bikatimop aygam, bilana, ‘Awoum kuvag mouvit waseg yey. Peinan koukwed bo akatibog, o nitug sigwey kamasis. Ta-ma̱wan basap basekeim.’ ");
INSERT INTO myw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“E, nag bisap bisekeim peinan nubeim, nag. Tage peinan kusimkakin mo bisap bisekeim aveiyag sivinam. ");
INSERT INTO myw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Adibakeimiy, bweina kunitougs, mo bisekeimiy. Kunineivs mo bukuba̱nes. Kugipits mo bikaliyow koukwed pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Kukin kal binitoug, mo bisek. Kukin kal binineiv, mo biban. Kukin kal bigipit, mo bikaliyow koukwed peinan. ");
INSERT INTO myw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","13","“Tawaw yakamiy, kukin nitimiyas sivines in, bilivans, mwatet bukusekes beikams, ne? O kukin sivines pouw, bilivans, kadilayuy bukusekes, ne? Adog nag. E, takalbaleb yakamiy, kukwakins aveiyag bwein bukusekes nitimiyas. Yowbad ansinap bwein. Bukunitougs waseg mtowen, singay mo bisekeimiy Kululuwan Bwanabwein.” ");
INSERT INTO myw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Teitan gamag bo ipiyev livan, peinan yeiluw neisiw wa̱won; Yeisuw ikayeb, ikilev gamag towen mo ilivan bwein; o tasiyas iliganes bo isom ninous. ");
INSERT INTO myw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tage mwasanin iyages Yeisuw ilansa, “Siyas tabbwagaws sitovek Seitan mtowen nileb Yeisuw, mo ikayabes yeiluw.” ");
INSERT INTO myw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","O musinis-vak sivines biyakwanes Yeisuw, ilansa, “Kwamtilakem Yowbad naman mulin, bakakin.” ");
INSERT INTO myw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeisuw gog ikakina ninous tasiyas, idibakes, ilana, “Kukin ven avakaein gimgilis bilivis biva̱ges bod kweitan kweitan, mo bigulekwes ven towen; o kukin gamag bilivis wawnuwan bunatum mo bigayays, singaya bigeg. ");
INSERT INTO myw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“O Seitan-vak, kukin inabod bilivis, inakaleiwag bikalivatow. Awoum kulansa, ‘Bwagaw ilabeim mo kukwayabes yeiluw’; awoum. ");
INSERT INTO myw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Amilivan gog ma̱wan, tage kal ilabes mivamul mo ikayabes yeiluw? Kuninuways asisinap tasiyas mo bukukwakins bo ibol amilivan. ");
INSERT INTO myw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Tage kuninuways, magat Yowbad ilabeig va̱gan bakayabes yeiluw, nakaleiwag bo isap wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","“Kukin tawtoun gamag bikokew naviy wuliyougwan ninamis waseg va̱gan bimtakavet nabwan tatonen, adok nag teitan biyageg nawliyoug. Tage kukin tayuwein gamag singaya tatawtoun mo bivvatay waseg, bitakayway, mo bikwey wuliyougwan naviy son nawliyoug babaw, bivgen bisekes inagamag. ");
INSERT INTO myw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kukin kal nag ilabeig bo isilbwadeig. O kukin kal nag ikatikunouk kan inow wagunseigous, mtowen bo ikatigey. ");
INSERT INTO myw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Magat yeiluw bikilev gamag, mo bita̱van ven makaw, binineiv nakabiyeiwas. Binineiv nag, bilivan bilana, ‘Ba̱yum ban wagunbunatum to nalisow.’ ");
INSERT INTO myw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","26","“Beiyum biban nabunatum, bo itaneivis, youd babaw bo ilivkases bwein, bikalin nuwan, bein ikin siney teinim teiy asisinap singaya kalbaleb, tasiyas asibabaw mo beisiws wabunatum, bisesus bisigagas. Kweiboug gamag towen nakalbaleb peinan yeiluw neisiw, tage nakabiyokous waseg singaya kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeisuw anilivan ma̱wan, na̱tan vin wawnuwes gamags, aygan ivakaein, idibek Yeisuw, ilana, “Singay tamumwa̱saw mana̱wen vin nikopweim yak, o ivsasum.” ");
INSERT INTO myw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iwa̱ge Yeisuw, ilana, “Nag, tasiyas taliganeins Yowbad aygan bimwa̱saws, o takanaweins aygan.” ");
INSERT INTO myw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Gamag singay babaw katikunouks nimeis waseg Yeisuw, mo idibakes, ilana, “Gudwouvaws yakamiy amisinap kalbaleb. Sivinamiy naman mulin Yowbad bukukines. Nag gog. Magat bukuninuways Youna waseg. Ma̱wan min-Ninavek kweiboug ikines Youna nawotet mamagina naman mulin Yowbad; ma̱wan Gimgilitoun yey, gunawotet kukines tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Igaw Yowbad biya̱tal wasigeis gamag babaw, mo kwin mana̱wen kweiboug inaven wa̱yals mo bilivan va̱gan bukukwakins amisinap kalbaleb gudwouvaws yakamiy. Peinan mana̱wen kwin inoun in singay kadiveiyov va̱gan biligen Solomon ansinap; tage sinap towen nagein nukuliganes ikalisow Solomon ansinap waseg. ");
INSERT INTO myw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Min-Ninavek bitamanaws ya̱tal waseg, bilivans va̱gan bukukwakins amisinap kalbaleb gudwouvaws yakamiy. Peinan tasiyas iliganes Youna nageiguy mo ilaves asisinap kalbaleb; tage kaleiwag nagein nukuliganes ikalisow Youna nageiguy. Kuliganes; nag gog, nag kulaves amisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Lamp bitavakanot, awoum aveiyag bitakatugbulik, o awoum bitasen waskawan bunatum; awoum. Tage bitasen wateibol, mo tasiyas beisiws wabunatum bikines mititeilin. ");
INSERT INTO myw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Woun mititelin mat. Kukin matam bwein mo woum meiveka bikamnat; kukin matam kalbaleb mo woum meiveka bidadub. ");
INSERT INTO myw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Kuvna̱ses mititeilimiy, mata ge idadub. ");
INSERT INTO myw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","“Kukin gog woum meiveka bikamnat, dadub nag, mo bukumlavag mamagina lamp kuva̱kaein mititeilin.” ");
INSERT INTO myw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Igawa illivan, Palisiy teitan inek, idibek Yeisuw, ilana, “Kum, bitakams wagunbunatum”. Itam, inek beikams. ");
INSERT INTO myw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","E, kakita beikams, Palisiy towen ikin Yeisuw nag iwid naman, bo igeg nanon, ilana, “Aveiyag wawun nag kuwid namam?” ");
INSERT INTO myw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iwa̱ge Yeisuw, ilana, “Yakamiy Palisiy mamagina abmavin o kwa̱vig, kuwidis watoulan igimagim, tage wanuwan bikibik, kalbaleb, peinan amisinap kukkwayes gamag sivavag. ");
INSERT INTO myw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“Takabala̱wein yakamiy! Yowbad nibun kaleivids, nibun-vak nuwads. ");
INSERT INTO myw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","“Wanuwamiy kadiloka kuva̱ges amisinap beibwein, kusiwa̱youbs gamag wasigeis, mo bukugimagims, o youd katanok katanok beibwein pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tage yakamiy Palisiy, singay kalbaleb bukulivatus. Kukwatkakils waseg miwliyoug babaw, kulagus sinawatan; kalgutan mo kusekes Yowbad. E, kulagus gayas siyas kekel, mamagina minit o luw, tage bo kunumlaves sinap didumwal son siwa̱youb waseg Yowbad. E, kadiloka kuvna̱ses sinap babaw, tage awoum bukuwidis sinap tasiyas avakaein. ");
INSERT INTO myw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yakamiy Palisiy, singay kalbaleb bukulivatus. Peinan tapwa̱loul waseg sivinamiy bukusinis wa̱keb, o sivinamiy gamag wavtakon ven beikoks wamitamiy binounas. ");
INSERT INTO myw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Yakamiy Palisiy, singay kalbaleb bukulivatus. Amikakin bwein, tage wanuwamiy kalbaleb, ma̱wana alawag wanawoud, gamag bikanpeles tage nag ikakins takanig alawagan.” ");
INSERT INTO myw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tassinap teitan idibek Yeisuw, ilana, “Tamwey, amlivan towen waseg kuyagem-vak yakamey.” ");
INSERT INTO myw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iw to Yeisuw, ilana, “Yakamiy-vak tassinap yakamiy, singay kalbaleb bukulivatus. Peinan mikaleiwag kusekes gamags singay moumouvit ma̱wana kunes kusekes avakaein, tage nag kakit bukukwawes va̱gan bukulabes, nag. ");
INSERT INTO myw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Singay kalbaleb bukulivatus. Tibumiyas bo neiweiys siyas palopits mo kuwlules aluwgwes tasiyas palopits. ");
INSERT INTO myw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","“Mapuna kukwakins o kutams waseg tibumiyas siwotet kalbaleb. Tasiyas neiweiys palopits o yakamiy kuwlules aluwgwes. ");
INSERT INTO myw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Yowbad ansinap waseg ilivan ma̱wan, ilana, ‘Bakayeb palopits sisiyas aposols binekes, mo beiweiys mwasanin o bisilkodes mwasanin.’ ");
INSERT INTO myw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“O tasiyas Yowbad inapalopit bo iwaweiys ven watinow. O wotet towen kalbaleb mapun bukulivatus gudwouvaws yakamiy, tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","“Yowbad nibun ven watinow o gamag siyas wanamug, teitan taw iweiy Yowbad nagamag towen Eibel. Yowbad inapalopit iwaweiys ee... nakabiyokous waseg mtowen Sekaliya, neiweys Yowbad wanbunatun, abeilun palatan, bunkakit palatan. E wotet towen kalbaleb mapun bukulivatus gudwouvaws yakamiy, tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Yakamiy tassinaps, singay kalbaleb bukulivatus. Kukwayuses awkwedan sinap, nag bukusiws yakamiy, tage kusilbwades tasiyas sivines kid beisiws. Ta-ma̱wan. Bo kusilbwades.” ");
INSERT INTO myw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ilisow ven towen, mo Palisiy sisiyas tasiyas takatimlakeins kaleiwag singay ivvaluts asilivan waseg, mamagina ivvasiganis; ikayamats waseg Yeisuw anilivan; kukin kalbaleb biliganes, mo biya̱tals. ");
INSERT INTO myw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wankuyeim gamag singay babaw katuyouns nimeis; bo ikalawt ven, nitatos ipapeps-wan; mo isilamaw nakabebay wasigeis navamul, ilana, “Kuvna̱seimiy. Kadiloka kupiyaves tasiyas Palisiy asiyist. Peinan tayyaweid tasiyas Palisiy.” ");
INSERT INTO myw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ilana, “Youd babaw nilumwes igaw mo bikaliyow, bikamat; o aveiyag nisisowmes, igaw mo bispuyes mo bikakins. ");
INSERT INTO myw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","“Youd towen nukuliva̱nes dadub waseg, igaw biliganes wamnat; o aveiyag nukwatimwa̱lags wamibunatum igaw mo bilivans wavtakon ven. ");
INSERT INTO myw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Sigwey, awoum kuwenes tasiyas beiweiys woumiy. Bikatimateimiy bo misinak. Nag aveiyag binuwakeimiy. ");
INSERT INTO myw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Tage kadiloka kuwenes mtowen bikatimateimiy mo bilaveimiy bukuneis wa̱kov. Mounid bukuwenes mtowen. ");
INSERT INTO myw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Skwa̱sik mwana̱nim, adok ten toya maysan; tage Yowbad ikikines; nag binumlev mwantanok, nag. ");
INSERT INTO myw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","“Yowbad gog ikakin kunumiy nakasabwasob babewein nakavnivin. Awoum beivag amipwa̱yat, Yowbad ikakina mansiyas skwa̱sik, imtakavates; singay gog bimtakavateimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kukin kal yak bukwamtel wamtes gamag, kulana, ‘Mounid Yeisuw inagamag yey,’ wankuyeim yey Gimgilitoun yey mo bakamtel wamtes tasiyas Yowbad nataka̱yobs, balana, ‘Taw towen yey gunagamag.’ ");
INSERT INTO myw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Tage bukwaya̱neig wamtes gamag, mo bakaya̱neim wamtes tasiyas Yowbad nataka̱yobs. ");
INSERT INTO myw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kukin kal bitawyageig Gimgilitoun yey, Yowbad bweina biwid ansinap kalbaleb beikous; tage kukin bitawyeg Kululuwan Bwanabwein, Yowbad nag biwid ansinap kalbaleb, nag. ");
INSERT INTO myw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Igaw biyousimiy, biyateleimiy wasinagog o wamtes tasiyas guyawaw o tasiyas takaleiwags, awoum beivag ninoumiy babaw. Awoum kulansa, ‘Ama̱wan bakatimop asilivan?’ Awoum kulansa, ‘Aveiyag balivan?’ Awoum. ");
INSERT INTO myw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","“Yowbad Kululuwan Bwanabwein mo bikamtilakeimiy anilivan bukulivans tut towen waseg.” ");
INSERT INTO myw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Teitan taw wanuwes gamag babaw mo idibek Yeisuw, ilana, “Takatimlakay yak, tuwag bo ikow nakiyay avakaein, kudibek mwasanin bisekeig gunkiyay yey.” ");
INSERT INTO myw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iw to Yeisuw, ilana, “Adok awoum. Nag kal isekeig gunakaleiwag va̱gan bakaluweg mivavag.” ");
INSERT INTO myw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Idibakes tasiyas, ilana, “Kuvna̱seimiy. Awoum bimwamon mitamiy. Nag bitamwa̱saw peinan dawliyoug babaw. Silawun damwa̱saw kweitan.” ");
INSERT INTO myw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","Kabebay kweitan idibakes, ilana, “Guyaw teitan inabag ivag kan singay babaw. Bo ika̱lawt seigous. Nanon ilana, ‘Aveiyag bavag? Peinan bo ika̱lawt seigous.’ ");
INSERT INTO myw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ilana, ‘Adok bagulekwes seigous kweibougs, bawlulavaw bunavka̱veks, waseg basen kan babaw o youd katanok katanok. ");
INSERT INTO myw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“‘Beikous; nanoug mo balana: “O yey guyaw yey, kag babaw, bo kadilok bweilim babaw; bweina bayeiwas, bakamkwam, bamwamoum, bamwa̱saw.” ’ ");
INSERT INTO myw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Tage Yowbad idibek, ilana, ‘Takabala̱wein yak, boug towen bukumat, kululuwam toneim biyamkwaneim, mo kal bikow muvavag tasiyas nukwanlev?’ ");
INSERT INTO myw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Guyawaw mwasanin bo ma̱wan; sivines siwliyoug bikatimweisis bibabaw; tage wanuwes nag ivag Yowbad nawliyoug, nag.” ");
INSERT INTO myw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mapuna idibakes navamul, ilana, “Awoum bikubukub nuwamiy silma̱nin mwamovamiy, aveiyag bukukwams. Awoum bikubukub nuwamiy silma̱nin woumiy, aveiyag bukusikams. ");
INSERT INTO myw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","“Mwamovads nag mamagina kan; o wouds nag mamagina kweim. ");
INSERT INTO myw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Kuninuways mansiyas bwayobway. Nag isapwes kan, nag itayoys binawes wasiseigous; tage Youbad imtakavates, isekes kaeis ikams, singay gog bimtakavateimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Adok nag kal ya̱koum bukuninuway mutawtoun waseg mo beivag ambweilim bibabaw. Nag kadilok. ");
INSERT INTO myw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Sinap towen kakit nag kadilokeimiy. Awoum bikubukub nuwamiy youd babaw silma̱nin. ");
INSERT INTO myw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kuninuways kasiyas moloubaw peinan isibwa̱sobs wadadan ked, nag iwotets, nag iba̱lals, nag. Tage astubub waseg ilisawes mtowen Solomon antubub kweiboug gamag nikavasis singay. ");
INSERT INTO myw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“O kasiyas kay, nagein mwamov wadadan ked, nubweig beimat, o gamag bikawes binawes bilaves bein wa̱kov. Peinan Yowbad isekes kay astubub kamnabwein singay mo bisekeimiy amikweim yakamiy. Adok nag kunmises Yowbad, va̱gan bisekeimiy kan, kweim. ");
INSERT INTO myw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Awoum kuninuways aveiyag bukukwams o aveiyag bukumoums. Awoum bikubukub nuwamiy. ");
INSERT INTO myw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","31","“Ven babaw gimgilis sivines youd tasiyas. Tamads ikakina aveiyag sivinamiy. Kadiloka bukuninuways Yowbad nakaleiwag, bukwanawes, mo bisekeimiy youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Awoum beivag amipwa̱yat. Yakamiy Yowbad alen yakamiy, mapuna bo itam va̱gan bukusiws wanuwan nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Kuymiyises miwliyoug, money kukwawes, kusiwyoubus tasiyas tasimavs; maysamiy walba̱lab mo bises bisigeg. Gamag nag biba̱kews waseg, o man kekel nag bikamkwams, o biyagages, nag. ");
INSERT INTO myw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Ampalawen miwliyoug kwatikunakus, mo biseiw nuwamiy ven towen. ");
INSERT INTO myw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Kadiloka kupa̱yiws o milamp bigidaged mamagina tasiyas nikaymates sitovek wasagal, veivay sigeilin; mtowen beiyum beim, bigipit; tasiyas biliganes, nuwanaw mo bikaliyowes koukwed. E, kadiloka kwayamats ma̱wana tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Igaw sitovek beim mo tasiyas tala̱lals mo bimwa̱saws, bipa̱yiw mtowen, bisekes abes bisinis, mo bimey kaeis beikams. ");
INSERT INTO myw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Kukin beim watapwan boug o biba̱nes ila̱lals, mo bimwa̱saws; o kukin walalayis mo beim o biba̱nes ila̱lals, mo bimwa̱saws-vak tasiyas.” ");
INSERT INTO myw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kweitan livan Yeisuw isekes mamagina, “Kuninuways tanuwagan bunatum; kukin bikakin asina̱vin tavveinaw beim, mo beilal, bisilbwed kid towen tavveinaw; awoum ge beisiw wanbunatum. ");
INSERT INTO myw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Yakamiy ma̱wan, kadiloka kula̱lals, kukwaymateigs Gimgilitoun yey. Awoum balabuboleimiy; awoum.” ");
INSERT INTO myw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ikatugan, ilana, “Tamwey, tabta mukwabebay towen silma̱nin yakamey, o adok gamag babaw?” ");
INSERT INTO myw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Iw to Yeisuw ilana, “Kal natouwat tamwey bisek nawotet va̱gan bimtakavates inagamag, bisekes kaeis bikamkwams? Adok towen tatoukum o tassinap. Igaw natovek beiyum beim o biban inatoukum inawotet waseg, bilana, ‘Kalin nuwag ya̱koum, kadiloka kumtakavet gunwuliyoug babaw.’ ");
INSERT INTO myw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","“Tage kukin natouwat bilana, ‘Guntovek bo iyouviy, adok nag nuwanaw beim,’ mo biwaweiy inagamag, tawaw, vinay, o bimlavag tagovek, o bimwamoum tawtoun soup bikabala̱wein, mo natovek beiyum beim bilabubol natouwat, bimop ansinap kalbaleb, bisen wasigeis tasiyas takapidabs. ");
INSERT INTO myw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Natouwat kavel ikakin natovek nanon, tage nag iwtel ma̱wan, o nag ikatunag, natovek mo biwaweiy avakaein. ");
INSERT INTO myw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Tage kukin kal nag ikakin natovek nanon, mo iwotet kalbaleb, kadiloka natovek biwaweiy gamag towen, tage nag beiweiy bivakaein. Kukin kal natovek bisiwa̱youb avakaein waseg, kadiloka biwotet avakaein peinan. O kukin natovek bisek navavag babaw, sivinan gamag towen biwotet bivakaein peinan. ");
INSERT INTO myw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yey nam bavakanot kov wadaban pwepway, o sivinag nanawan bigidaged. ");
INSERT INTO myw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Igaw mo bibapta̱yseig kweitan youd kalbaleb waseg, o sivinag nuwanaw biyakous. ");
INSERT INTO myw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Awoum kuninuways yey nam silma̱nin niwal ven matinow. Nag. Yey nam silma̱nin abilivis bavag. ");
INSERT INTO myw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Igaw bunatan bunatum wanuwan asteinim bilivis, asteitoun palatan, asteiy palatan. ");
INSERT INTO myw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“E, bilivis, taman palatan, natun palatan; o inan palatan, natun palatan; o asteiy vinay son yawan, na̱tan palatan, na̱tan palatan.” ");
INSERT INTO myw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Idibakes gamag babaw, ilana, “Magat bukukines lov isob wayavat, bukulansa, ‘Bo beikweis.’ E, mo ikweis. ");
INSERT INTO myw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“O magat bukukines yals itow, bukulansa, ‘Ka̱las beikal avakaein,’ mo beikal ka̱las. ");
INSERT INTO myw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Tayyaweid yakamiy! Kukines liba̱lab, ven ankakin mo kukwakins aveiyag bikamat, tage nag kuwtusis Yowbad nawotet tut towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aveiyag wawun nag bukukwakins sinap didumwal? ");
INSERT INTO myw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Kukin kal biyateleim binaweim waseg takaleiwag silma̱nin ya̱tal; igaw wa̱ked kadiloka kuyokons va̱gan ninoumiy bukulatanes. Kukin gog nag, mo biyateleim wamatan towen takaleiwag, o takaleiwag bidibek plisman, bilana, ‘Kutok gamag towen kunow wa̱deil.’ ");
INSERT INTO myw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","“E, bukun wa̱deil, bukusesuna ee... anatut bukupa̱yin inapa̱yin meivek-wan beikous, mo bilikum bukusap wamnat.” ");
INSERT INTO myw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Misiya̱mun towen gamag mwasanin idibakes Yeisuw, ilansa, “Min-Galiliy mwasanin iwaweiys man iluns waseg Yowbad, mo Paylat iweiys gamag tasiyas, imta̱mats sisiyas mansiyas man neiweiys.” ");
INSERT INTO myw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","Iw to Yeisuw ilana, “Awoum kudokes min-Galiliy tasiyas asisinap singay kalbaleb mapuna imta̱mats. Nag. Min-Galiliy babaw asisinap kalbaleb; o yakamiy-vak, kukin nag bukulaves amisinap kalbaleb mo bukukwanigs ma̱wana tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","“Awoum kudokes min-Yelusalem tasiyas sinwatan teinim teitoun asisinap kalbaleb, mo bunatum bunaveiyov yagan Siloum ikalivatouw iwaweiys. Nag. Min-Yelusalem babaw asisinap kalbaleb; o yakamiy-vak, kukin nag bukulaves amisinap kalbaleb, mo bukukwanigs ma̱wana tasiyas.” ");
INSERT INTO myw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeisuw mo isekes nakabebay mamagina: “Taw teitan, wanabag nisop yaveinun nitet. Sivinan wuwan bikow; iwekey, nag. ");
INSERT INTO myw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Idibakes tasiyas tawtelein bag, ilana, ‘Kweitoun bweilim aninek yaveinun makaywen, anineiv wuwan; nag. Kuteiy, awoum biteta mav, biyamkwen pwepway.’ ");
INSERT INTO myw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","“Ikatimop aygan, ilana, ‘Bweina ga itet bweilim towen. Bakaviyeil leis wadadan palavas, basen bulumakaw pwes. Kukin bweilim wamatads beiwuw wuwan, bo bwein. Kukin nag, mo bateiy.’” ");
INSERT INTO myw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sa̱bat waseg, Yeisuw igeiguy wanuwan sinagog. ");
INSERT INTO myw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na̱tan vin nises, sinwatan kweinim kweitoun bweilim ankatoun waseg tapwan idadog. Ta-ma̱wan bitamanaw bidamoms tapwan. ");
INSERT INTO myw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeisuw ikin, idibek, ilana, “Vin yak, bo kubwein, amkatoun waseg.” ");
INSERT INTO myw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Isen naman wa̱won, nuwanaw mo idamoms tapwan; mapuna ikaves Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tage tanuwagan sinagog ikin Yeisuw nivag takatoun ibwein Sa̱bat waseg, ikapasal nuwan, idibakes gamag tasiyas, ilana, “Yam kweinim katanok waseg bitawotets. Awoum kumeis Sa̱bat va̱gan amikatoun biva̱geimiy bukubweins.” ");
INSERT INTO myw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yeisuw ikatimop aygan, ilana, “Tayyaweid yakamiy. Sa̱bat waseg kulikus aleimiy bulumakaw o donkiy wasibunatum nisesus mo kutokes kunawes wayvagam beimoums. ");
INSERT INTO myw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“Tage mana̱wen vin, Ebelam tabun na̱tan, Seitan niyawen bweilim babaw, bweina balik Sa̱bat waseg. Peinan Seitan ankatoun nivag sinwatan kweinim kweitoun bweilim.” ");
INSERT INTO myw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Anilivan ma̱wan, mo ivag asimwasin tasiyas nivtokays livan, tage gamag babaw imwa̱saws peinan ikines nawotet singay tawtoun. ");
INSERT INTO myw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mapuna idibakes, ilana, “Yowbad nakaleiwag ama̱wan? Aw-kabebay basekeimiy va̱gan bukuliganes o bukukwakins. ");
INSERT INTO myw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“Adok ma̱wan tipol veitun, peinan gamag teitan ikow inow isop wanabag; isob, ivakaein, mo mansiyas man iyoyows iwlules sibunatum yayagein waseg.” ");
INSERT INTO myw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Vayuwein ilivan, ilana, “Ama̱wan bakabebay va̱gan bukukwakins Yowbad nakaleiwag? Adok ma̱wana yist, na̱tan vin ikow isen waseg pwalaw avakaein, tamkwa̱lan mo ilol.” ");
INSERT INTO myw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Inoun, in, silma̱nin Yelusalem, ita̱vin ven babaw, ven mwasanin wunoveks, o ven mwasanin wunkekels, ikatimlakes gamags. ");
INSERT INTO myw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Teitan gamag ikatigan, ilana, “Tamwey, tabta Yowbad bikatinabwes gamag asteiyuye?” Iwa̱ge, ilana, “Kuyokons va̱gan bukusiws koukwed kabkakit waseg. Mounid, gamag babaw sivines beisiws, biyokons, bo nag. ");
INSERT INTO myw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Igaw tanuwagan bunatum bitamanaw, bikatibog koukwed, mo bukutowas watoulan, bukugipits, kulansa, ‘Tamwey, kwaliyow koukwed pinem yakamey,’ tage mtowen bikatimop agamiy, bilana, ‘Nag akakin avanuy mukunoy nukumeis yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Mo bukulansa, ‘Nakakamkwam nakamwamoum wamatam yak, o nukwatimlakay wamaven.’ ");
INSERT INTO myw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Towen gog bilivan, ‘Mounid nag akakin avanuy mukunoy nukumeis yakamiy. Kunounas, kuneis, takalbalebs yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mo bukuvva̱lams o bukwakilis kumtumiy, peinan bukukines Ebelam, Aysak, Yekob sisiyas tasiyas palopits, Yowbad nakabkaleiwag waseg, o yakamiy bukusiwas watoulan. ");
INSERT INTO myw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","30","“Gamag babaw meinoys wanuvid, wayavat, wabomat, wa̱yals, bimeis bisinis beikams Yowbad nakabkaleiwag waseg. Tage mwasanin wankuyeim bo bimugwas, o mwasanin wanamug bo bikuyeims.” ");
INSERT INTO myw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tut towen Palisiy mwasanin inekes Yeisuw, ilansa, “Kusawl, kun, Elod sivinan beiweim.” ");
INSERT INTO myw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iw to Yeisuw, ilana, “Kuneis, kudibakes bulawud towen agulivan mamagin: Nagein nubweig siyas bwagaw bakayabes, takatouns bavag mo beibweins, tage bugiy bo bayakous gunawotet. ");
INSERT INTO myw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Kadiloka ba̱noy gunaked nagein, nubweig, bugiy. Peinan palopit babaw yakamey bakamta̱mat Yelusalem. Tobwag ven awoum. ");
INSERT INTO myw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yelusalem. Min-Yelusalem yakamiy kuwaweiys tasiyas palopits, o tasiyas nissekeimiy Yowbad anilivan kuwaweiys dakul waseg, kwatimates. Tut babaw sivinag badaweimiy bukumeis bamtakavateimiy ma̱wan kolkolek imtakavates nitun; nag gog; kupiyaves aygag. ");
INSERT INTO myw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“Nagein mibunatum makaw, o nag bukukineigs ee... igaw anatut wanakoug bukulansa, ‘Kalin nuwads mtowen neim silma̱nin Yowbad nawotet,’ mo bukukineigs vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Siva̱tan tut, Sa̱bat waseg, Yeisuw in beikams son guyaw teitan, mtowen Palisiy. O takatoun towena, won bo ilelol. O tasiyas Palisiy ikinbunikes Yeisuw, bivag takatoun beibwein, o nag. ");
INSERT INTO myw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeisuw idibakes tasiyas tassinaps sisiyas tasiyas Palisiy, ilana, “Tab kadilok bitavag beibwein Sa̱bat waseg, o nag?” ");
INSERT INTO myw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tasiyas gog isesus-wan ikika̱pays. Yeisuw mo ivag ibwein; ikous, mo ilana, “Bweina kunoun.” ");
INSERT INTO myw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mo idibakes tasiyas, ilana, “Tage yakamiy, kukin a̱leim mwanatan bikalivatow bein wa̱leg Sa̱bat waseg, adok donkiy, o bulumakaw, adok bukuyous ne? Sa̱bat waseg, bukunup, bukusem wanakaew?” ");
INSERT INTO myw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tasiyas iliganes. Ta-ma̱wan bikatimapus aygan towen nilivan. ");
INSERT INTO myw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","9","Yeisuw ikines gamag mwasanin imeis silma̱nin sagal, mo sivines guyawaw abes wanakaew. Yeisuw ikines, mo ikabebay, idibakes, ilana, “Bukun silma̱nin veivay sigeilin, awoum kusin guyaw a̱ban waseg. Adok guyaw avakaein beim, mo tanuwagan bidibakeim, bilana, ‘Guyaw a̱ban towen. Kum, kusin watinow.’ Ammwasin, mo bukubus bukun watinow. ");
INSERT INTO myw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Tage bukun wasagal, kadiloka kusin watinow. Wankuyeim tanuwagan beim, adok bidibakeim, bilana, ‘Gwa, kum kusin wanakaew, a̱bam towena.’ Mamagina bukumliguyaw wamtes simwayas tasiyas takamsagals. ");
INSERT INTO myw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Kukin kal sivinan bimliguyaw mo beibus bein watinow; tage kukin kal biseib tatonen igaw mo biguyaw.” ");
INSERT INTO myw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Peinan tanuwagan sagal nidow Yeisuw im silma̱nin sagal; o Yeisuw bo idibek, ilana, “Igaw bukusagal, awoum kudawes veiyom babaw, o taliwom o simwayas guyawaw mwasanin. Peinan tasiyas bisagals mo bidaweims yak mo bimapus. ");
INSERT INTO myw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","“Tage ya̱koum bukusagal, kudawes tasiyas tasimavs, o tasiyas toupams sisiyas takagayals, o tasiyas toukwaws, mo bukumwa̱saw. Peinan tasiyas ta-ma̱wan bimapus. Igaw anatut tadidumwals beikits vayuwein mo maysan bukuban.” ");
INSERT INTO myw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nisinis sagal waseg, son teitan iligen, mo idibek Yeisuw, ilana, “Kukin kalisiy beikams Yowbad nakabkaleiwag wanuwan, singay bimwa̱saws tasiyas!” ");
INSERT INTO myw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iw to Yeisuw, ilana: Tamwey teitan inasagal avakaein, bidawes gamag babaw bimeis. ");
INSERT INTO myw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kan ikatineg ikous, mo idibakes natouwats, ilana, “Kukines tasiyas nadawes, kulansa, ‘Kumeis, tamwey bo ikatineg kaeimiy, kumeis kukwams.’” ");
INSERT INTO myw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tage asibabaw ipiyaves. Teitan ilana, “Bo agimwel pwepway kweitan, bo ban akin; adok awoum ban wasagal.” ");
INSERT INTO myw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tayuwein ilana, “Bo agimwel bulumakaw sinawatan, va̱gan bibteilis plaw kweinim. Bo ban ayakwanes mwanay mwanay bibteilis; babiweis sinawatan mansiyas bulumakaw; adok awoum ban wasagal.” ");
INSERT INTO myw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tatounun ilana, “Bo a̱vay soug gunakwav. Ta-ma̱wan baw.” ");
INSERT INTO myw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Natouwat iyum idibek natovek, ilana, “Bo ipiyaves, babaws.” Natovek iligen, ikavikun, idibek natouwat, ilana, “Nuwanaw kun ven babaw wasigeis kukines tasiyas tasimavs, toupams, toukwaws, takagayals, kudibakes bimeis ikams.” ");
INSERT INTO myw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Natouwat ikanow aygan, in ivag ma̱wan, mo iyum, idibek natovek, ilana, “Bo adawes tasiyas nimeis beikams, tage gamag nag mana̱nan.” ");
INSERT INTO myw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Iwa̱ge natovek, ilana, “Kun ked babaw wasigeis, kun-o wanawoud kuba̱nes gamag, kwabutus bimeis, ikams. Kadiloka gunbunatum bika̱lawt. ");
INSERT INTO myw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Mounid adibakeim tasiyas wanamug nadawes nag beikams gunsagal.” ");
INSERT INTO myw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Siney Yeisuw singay babaw gamag ibukunis. Itouvin, idibakes, ilana, “Kukin kal yak bukumlavag gunavamul, kadiloka kupiyev tamam, inam, mukwav, nitum, budam, nimut, o mwamovam tatoneim, mo bukumlavag gunavamul. Kukin gog nag, bo nag. ");
INSERT INTO myw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Kukin nag tatonen bikow anklos, ma̱wana bibkunig, mtowen nag gunavamul. ");
INSERT INTO myw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kal yak bukuwlul bunatum bunaveiyov, adok wanamug bukusin, kunuw maysan, kadilokeim? o nag? ");
INSERT INTO myw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","“Kukin nag bukunuw maysan, adok kwativtow kakol, bo misinak. Peinan mumoney bo ikous. Tasiyas bikines mo bisiba̱weims, bilansa, ‘Taw towen biwlulay nabunatum, tage ta-ma̱wan biyakous.’ ");
INSERT INTO myw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“E, kuninuways guyaw teitan siney natakanaviy bikanaviys wasigeis tayuwein guyaw siney natakanaviys; adok wanamug bisin binuway, nanon bilana, ‘Guyaw towen natakanaviys sinawey tawsan, o yey guntakanaviys sinawatan tawsan; adok kadilokeig batagagay wasigeis? o nag?’ ");
INSERT INTO myw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Kukin nanon adok nag kadilok, o tayuwein guyaw siney natakanaviy nimimeis kadiveiyov, adok mo bikayeb nagamag mwasanin bikines guyaw towen bilivans va̱gan bibwabwes kanaviy. ");
INSERT INTO myw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“E, kadiloka kupiyaves mivavag babaw mo bukumlavags gunavamul. Kukin gog nag, bo nag. ");
INSERT INTO myw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Sol magat yayan, bwanabwein. Kukin gog nag, ta-ma̱wan bisabal. Sol towen kalbaleb nag bileb bag; nag ivag nawotet. Deisa talev. Yakamiy tigamiy sam bweina kuliganes.” ");
INSERT INTO myw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bo ikatuyouns waseg Yeisuw tasiyas kalbaleb takaweins ta̱kis sisiyas takalbalebsa babaw, sivines kid biliganes aygan. ");
INSERT INTO myw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tasiyas Palisiy sisiy takatimlakeins kaleiwag ikines, ivtokes livan, ilansa, “Taw towen sivinan takalbalebs, ikamkwams siney. Bo igak!” ");
INSERT INTO myw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Yeisuw ikakin-wan asilivan, ikabebay mamagina: “Tab teitan ya̱koum aleim sip lakatutan, na̱tan bikanig wanawoud, bukulana, ‘Bweina bikanig’? Adok nag. Adok bukulisawes asibabaw bisesus, bukunineiv ee... mo bukuban. ");
INSERT INTO myw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","“Kuban, adok beimwan woum, bukukow kumey waven; e, bukuwak, kunukwes adok talawom, ‘A̱leig nikanig bo aban, kumeis bitamwa̱saws babaw ya̱kids.’ ");
INSERT INTO myw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Kuninuways gamag kalisiy toubweins nisesus nag aveiyag asisinap kalbaleb va̱gan bilavewas, o min-liba̱lab imwa̱saws pines tasiyas; tage kukin takalbaleb anmwa̱net bilavew ansinap, min-liba̱lab singaya bimwa̱saws, peinan ilavew ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O peinan asilivan nilansa, “Taw towen sivinan takalbalebs,” Yeisuw sivyuwein mo ikabebay, ilana, “Tabta na̱tan vin nises, inaveigun sinawatan, kweitan bikanig, bilivan, ‘Bweina bikanig’? Adok nag. Adok bikow nawodam, inata̱neiv, bitanev nabunatum, binineiv ee... mo biban. ");
INSERT INTO myw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“Biban, adok mo bidawes taliven bilana, ‘Kumeis tamwa̱saws, peinan gunaveigun nikanig bo aban.’ ");
INSERT INTO myw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Gamag bo ma̱wan, kukin teitan gamag bilavew ansinap kalbaleb, Yowbad siney nataka̱yobs walba̱lab mo bimwa̱saws singay.” ");
INSERT INTO myw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sivtounun Yeisuw ikabebay, ilana, “Tamwey teitan nitun tawaw asteiy. ");
INSERT INTO myw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Digumasus idibek taman ilana, ‘Tamag, igaw bukukwanig gunkiyay mo bakow; nagein kukwaleiwag aveiyag tuwag bikow, aveiyag yey, o yey tut towen bakow.’ “Taman itam, ikaluweg, isek digumasus inavavag. ");
INSERT INTO myw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Yam akweiy ikous, digumasus mo iyamiyis inavavag, maysan ikow, ilisow naven, inoun in kadiveiyov nen; ansinap kalbaleb waseg mo igimwal youd babaw ee... mo iyakous inamoney. ");
INSERT INTO myw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ikous namoney, mo ilivet tut kalbaleb ven towen waseg, kweis nag, kan nag, ikamet moun. ");
INSERT INTO myw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","19","“Anamoun, inek tamwey teitan, ilana, ‘Tabta muwotet nises, yey bawtel, mamagina mutouwat yey?’ Tamwey towen itam, ilana, ‘Bwein, bwaloud aleig nisesus waven, kumtakavates aleig.’ Inoun, iwwotet ee... bo ivag anamoun, peinan nag kal bisek kan beikam. Singay anamoun, sivinan kid bwaloud kaeis beikam; mo idumwal nanon, ilana, ‘O takabala̱wein yey! Tamag wanven natouwat kaeis babaw, yey gog nag; kakita bakanig agumoun. Adok batamanaw banoun banek tamag balana: Tamag, agusinap kalbaleb, waseg Yowbad, o waseg yak. Adok bukupiyaveig natum yey, ne? Tabta bawtel muwotet, mamagina mutouwat yey?’ ");
INSERT INTO myw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“E, mo itamanaw inoun ee... kakita bisap waven, taman ikin, ika̱lin nuwan, isawl, in iwliboub wa̱won, ivva̱lams son. ");
INSERT INTO myw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ivva̱lams ikous, digumasus ilana, ‘Tamag, agusinap kalbaleb, waseg Yowbad o waseg yak, adok bukupiyaveig natum yey.’ ");
INSERT INTO myw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","“Tage taman nag iligen, deisa idibakes natouwats, ilana, ‘Kusawls, kweim maynamnabwein kukwawes kumeyes, natug bisikam, ring kumeyes bisen wanaman, sandol kumeyes bivaligev wakaken. E, kuyousis mana̱wen bulumakaw natun ankaytub avakaein, kuweiys, takams tamwa̱saws, peinan natug neimat, nag gog bo imov; natug bo ikanig, nag gog bo aban.’ Mapuna isagals, imwa̱saws. ");
INSERT INTO myw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tage kunutaw igaw wa̱bag nises. Ikous nawotet im waven. Kadilakusan ven ikatiluteg kup waseg ikannuwels, isilasals. ");
INSERT INTO myw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","“Idow taman natouwat teitan, inek, ikatugan waseg, ilana, ‘Aveiyag silma̱nin imwa̱saws?’ ");
INSERT INTO myw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Gwad towen ilana, ‘Peinan bwadam bo iyum neim, nises bwein, taman bo iyous a̱len namnabwein iweiy.’ ");
INSERT INTO myw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kunutaw towen ikavikun, ipiyev sagal towen, isinal. Taman gog inek, igilagel, sivinan kid natun beitam. ");
INSERT INTO myw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","“Nag gog, idibek taman, ilana, ‘Tut babaw akaninow aygam, nag kweitan tut asiplev amulivan, nag. Tage nag na̱tan a̱leig kakit bukusekeig bakasagal sigwey, nag. Natum gog towen muvavag babaw bo iyagey, isekes nakubukwabs naggeinawls wasigeis, ikous, iyum im, mo kuyous bulumakaw namnabwein kuweiy. Bo igak!’ ");
INSERT INTO myw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","“Taman gog ikatimop aygan, ilana, ‘Gwa, soug yak tasesun yam babaw. Aveiyag gunavavag yey, ma̱wana muvavag yak, peinan natug yak. Awoum kwavikun. Kadiloka tamwa̱saws, peinan bwadam bo imat, nag gog bo imov, tadoki bo ikanig, nag gog bo taba̱nes bo imov.’” Yeisuw ikabebay ma̱wan, peinan asilivan, “Mtowen sivinan tasiyas takalbalebs.” ");
INSERT INTO myw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kabebay tasiyas ikous, kweitan isekes navamuls, ilana, “Guyaw teitan natouwat nawotet imtakavet navavag babaw. Gamag mwasanin ivtokays livan, idibakes natovek ilansa, ‘Mutouwat bo iyageg muvavag.’ ");
INSERT INTO myw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Natovek mo idow, im, ikatigan, ilana, ‘Aveiyag silawun liva̱neim tasiyas illivans? Kuyamen gunabuk. Bo bakayabeim, peinan muwotet kalbaleb.’ ");
INSERT INTO myw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mtowen iyum in va̱gan bikow inabuk; nanon ilana, ‘Gunawotet beikous, peinan guntovek bo bikayabeig. Aveiyag bavag? Nag atawtoun va̱gan babgubag. Tage nag banitoug kag; agumwasin. ");
INSERT INTO myw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“‘Bo akakin, kweitan sinap bavag. Bavag ma̱wan mo guntovek bibob gunawotet, tage bisekeigs kag ba̱kam.’ ");
INSERT INTO myw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“E, mo ivag ma̱wan. Idawes tasiyas nikawlavags waseg natovek, idibek teitan, ilana, ‘Kweivin mukwawlavag waseg guntovek?’ ");
INSERT INTO myw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ilana, ‘Tagon, lakatutan botol.’ Iwa̱ge, ilana, ‘Mubuk towena. Nuwanaw kusin wa̱keb, kugulek lakatutan, kulel sinawanim.’ E, igulek towen, ilel gog sinawanim. ");
INSERT INTO myw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ikous, tayuwein im, idibek, ilana, ‘Kweivin mukwawlavag waseg guntovek?’ Ilana, ‘Wit, lakatutan gamwat.’ Iwa̱ge, ilana, ‘Mubuk towena; kugulek lakatutan, kulel go sinwanim sinwatoun.’ Mo igulek mo ilel ma̱wan. Imimeis, tatanok tatanok idibakes ma̱wan. Igulekwes, ileles mamagina iseibwis sikawlavag. ");
INSERT INTO myw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ikous, mo natovek iligen liva̱nen mtowen tasilponay, waseg niseib sikawlavag gamag babaw. Tage natovek bo ikaves natouwat towen, ilana, ‘Singay ansinap tawtoun.’” Yeisuw ilana, “Tut towen ven watinow gimgilis bo imugwas, peinan asisinap tawtoun. Yowbad nagamag asisinap igwey. ");
INSERT INTO myw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ven watinow wuliyougwan kalbaleb. Miwliyoug waseg, kadiloka kukwaveiyons simiyas wasigeis. Wankuyeim, beikous miwliyoug mo bukuba̱nes miven walba̱lab, bukusesus kusigagas. ");
INSERT INTO myw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kukin kal bitoukum wotet kakit waseg, ma̱wan avakaein waseg bitoukum. Kukin kal bisilponay wotet kakit waseg, ma̱wan avakaein waseg bisilponay. ");
INSERT INTO myw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Ven watinow wuliyougwan kalbaleb. Kukin nag bukutoukum waseg mivavag ven watinow adok Yowbad nag bisekeim liba̱lab wuliyougwan. ");
INSERT INTO myw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","“Kukin nag bukutoukum waseg soum navavag adok Yowbad nag bisekeim muvavag tatoneim. ");
INSERT INTO myw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nag kadilok gamag bikanow ages natovek asteiy, peinan bikamliw teitan, bisiwyoub tayuwein; o adok bitoukum teitan silma̱nin, bipiyev tayuwein. Ta-ma̱wan bitaninuway Yowbad anilivan son ven watinow wuliyougwan.” ");
INSERT INTO myw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tasiyas Palisiy sivines simoney bikatimweisis bibabaw, iliganes Yeisuw anilivan towen, isiba̱wes. ");
INSERT INTO myw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tage Yeisuw idibakes, ilana, “Peinan kuva̱ges amisinap ankakin beibwein wamtes gamag, tage Yowbad ikakin ninoumiy kalbaleb. Youd tasiyas sivinamiy ma̱wana babaw gamag sivines, tage Yowbad ikasigum youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses nakaleiwag kweiboug nises, o tasiyas palopit sigeiguy nileles nises Bukitab wanuwan. Kaleiwag towen ises ee... mo Yon isap, wankuyeim mo kageiguy liva̱nen Yowbad nakaleiwag bwanabwein, o gamag babaw itawtouns, sivines beisiws waseg. ");
INSERT INTO myw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Tage Moses nakaleiwag nag beikous, nag. Kukin liba̱lab son ven watinow biyakous mo beikous kaleiwag siyas kakit, Moses nakaleiwag wanuwan. ");
INSERT INTO myw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kukin kal bipiyev nakwav mo beivay son nayuwein vin bo igeinawl, ikanavay mav. O nakwav nipiyev mo beivay son tayuwein taw, taw towen bo ikanavay mav. ");
INSERT INTO myw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Teitan taw bo iguyaw avakaein, anakweim maynamnabwein, o kan bwanabwein ikamkwam yam katanok katanok. ");
INSERT INTO myw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","“Tage tasimav teitan yagan La̱sal nimmasis guyaw wanakoukwed wadadan, won meivek sasok-wan. Mtowen tasimav sivinan beikam kan musamusan nikambweg guyaw nateibol waseg; o mansiyas awuk inekes ikanmwasis ansasok. ");
INSERT INTO myw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","23","“Mtowen tasimav ikanig, min-liba̱lab mo ikawes inawes va̱gan bimwa̱saw Ebelam wanven waseg. Guyaw-vak ikanig, idibwanis, in wa̱Tum, igidaged kov waseg, imdamed won, itamnow matan, ikin Ebelam kadiveiyov son La̱sal, imwa̱saws. ");
INSERT INTO myw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Iwak, ilana, ‘Tama, Ebelam, binok nuwam yey. Kwayeb La̱sal, bein isow didin wayvagam, beim, isen wamayeig, biyenom. Peinan woug singay asimkwen ma̱wana kov towen nigidaged.’ ");
INSERT INTO myw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Iw to Ebelam, ilana, ‘Gwa, adok kunuw ven watinow nukumov, nukumwa̱saw avakaein, tage La̱sal a̱ban igeg. Tut gog towen La̱sal immwa̱saw, tage yak igidaged woum. ");
INSERT INTO myw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“‘O kweitan youd kukin. Yakamey palatan, yakamiy palatan, o awasas avakaein wanuwein. Ta-ma̱wan bakakanapel bakaw; o nag bukwanpeles bukumeis.’ ");
INSERT INTO myw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Mtowen guyaw mo igilagel, ilana, ‘Tama, tab kadilok bukwayeb La̱sal bein tamag wanbunatum bikines budag asteinim, bidibakes, bilana, “Kuvna̱seimiy. Mata ge bukumeis ven towen kalbaleb.”’ ");
INSERT INTO myw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Iw to Ebelam, ilana, ‘Moses siney siyas palopits asilivan nises. Kadiloka biliganes livan towen.’ ");
INSERT INTO myw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ilana, ‘Nag biliganes tasiyas. Tage kukin takanig teitan beiyum binekes bilivan wasigeis, mo bipiyaves asisinap kalbaleb.’ ");
INSERT INTO myw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Iwa̱ge Ebelam, ilana, ‘Kukin nag biliganes Moses siney palopits asilivan, mo takanig teitan beikit binekes, nag gog bisimounids anilivan waseg.’” ");
INSERT INTO myw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wankuyeim mo idibakes navamuls, ilana, “Mounid gamag mwasanin biyakwanes sisiyas bikatsilakes silma̱nin asisinap kalbaleb, tage tasiyas takatsilakays mo bilivatus kalbaleb. ");
INSERT INTO myw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","“Kadiloka dakul avakaein biyawanis takatsilakay wakayon bilaves bein wabwanit; mata ge bikatsilek gwad kakit ma̱wana gwad towen, va̱gan kid beivag ansinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Kuvna̱seimiy. Kukin bwadam biyagageim, kwamtilek ansinap kalbaleb bikakin. Kukin bikanavin nanon, mo kuwid ansinap, kunumlev. ");
INSERT INTO myw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Kukin katanok yam waseg siva̱nim sivay biyagageim mo siva̱nim sivay bigilagel, bilana, ‘Kuwid agusinap towen’; e, kadiloka kuwid.” ");
INSERT INTO myw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Gamag tasiyas takaweins anilivan mo idibakes siguyaw, ilansa, “Kulabem va̱gan bakasimounid beibwein.” ");
INSERT INTO myw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iw to Yeisuw, ilana, “Kukin bukusimounids ma̱wan tipoul kaytul-nen, mo bukudibakes kay makaywen bukulansa, ‘Kugut gidawa̱lim, mo kunoun kun kutow wabwanit,’ e, mo bikanaway agamiy. ");
INSERT INTO myw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","“Takinew mutouwat biwaway wa̱bag, o takinew bimtakavet mansiyas aleim wanawoud, ikous mo beiyum beim waven, adok nag bukulana, ‘Nuwanaw kum, kukwam.’ Nag. Peinan adok bukulana, ‘Kupa̱yiw kukwaliveinun kag, kusekeig; ba̱kam ba̱moum, ikous; mo kukwam, kumoum wankuyeim.’ ");
INSERT INTO myw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Mutouwat towen bikanaway aygam, adok nag bukulana, ‘Kalin nuwag avakaein ya̱koum.’ Nag. ");
INSERT INTO myw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Yakamiy ma̱wan, bukuyakousis Yowbad nawotet nilivan, mo bukulansa, ‘Ya̱kids nag natouwats bwein ya̱kids. Bo misinak nilivan nitivag, bo deis.’” ");
INSERT INTO myw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Inounas, bineis kid Yelusalem, inoyes ked makadewen Samaliy palatan, Galiliy palatan. ");
INSERT INTO myw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Isap ven kweitan waseg, iwekey toulepel sinawatan, itowas, iwaks, ilansa, “Tamwey, Yeisuw, tabta binok nuwam yakamey?” ");
INSERT INTO myw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeisuw ikines, ilana, “Kunounas kuneis; siyas tanuwgwes lun bikineimiy.” Inounas binekes kid tanuwgwes lun, inounas wa̱ked mo ibweins. ");
INSERT INTO myw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Teitan ikin kaleivin bo ibwein, itouvin, aygan avakaein iya̱kawn Yowbad waseg, iyum inek Yeisuw, ikalivatouw kantukov wamatan, ilana, “Kalin nuwag ya̱koum avakaein.” Mtowen gum-Samaliy. ");
INSERT INTO myw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Iw to Yeisuw ilana, “Adok sinawatan yakamiy nukubweins, avanuy tasiyas teinim teivas? Tabta beiyum bimeis bikavasis Yowbad, peinan ibweins? o misinaka tobwag ven gimgeilin towen?” ");
INSERT INTO myw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mo idibek mtowen ilana, “Kutamanaw, kunoun. Nukusimounid waseg yey, mapuna bo kubwein.” ");
INSERT INTO myw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Palisiy mwasanin inekes, ikatiga̱nes, ilansa, “Asinavin Yowbad nakaleiwag bisilamaw?” Iwa̱ge Yeisuw, ilana, “Nag bitakin kweitan mulin naman Yowbad mo bitakakin nakaleiwag isilamaw, nag. O gamag nag bilivans, bilansa, ‘Kukines a̱ne’ o ‘Towen-one’; nag. Peinan Yowbad nakaleiwag wanuwamiy nises.” ");
INSERT INTO myw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mo idibakes navamul, ilana, “Igaw tut wanakoug, beivag sivinamiy bukukines Gimgilitoun yey gunakaleiwag kweitan yam waseg, tage nag bukukines. ");
INSERT INTO myw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Gamag mwasanin bidibakeimiy, bilansa, ‘Kukin-one’ o ‘A̱ne.’ Tage awoum kuneis kukines; awoum kukikuns tasiyas; awoum. ");
INSERT INTO myw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Peinan yam towen ba̱yum bam bukukineigs ma̱wana kavikawn bimteil liba̱lab palatadadan palatadadan. ");
INSERT INTO myw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Youd towen wanakougwaw, tage wanamug a̱bag bigeg o peinan tut towen gimgilis bo bipiyaveigs. ");
INSERT INTO myw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Gimgilitoun yey. Igaw ba̱yum bam mo gamag mwasanin bilivatus kalbaleb, ma̱wan kweiboug, inatut Now waseg, Gimgilitoun yey gunatut bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","“Peinan Now inatut waseg ikamkwams, imwamoums, iveivays, ita̱mes nitsiyas silma̱nin beivays. Ma̱wana ee... kweitan yam mo Now isiw in wanawag wanuwan, mo ikweis avakaein, imukul ven, iwgweles gamag ikous. ");
INSERT INTO myw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","“Lot-vak inatut ma̱wan, ikamkwams, imwamoums, iyyamayis siwliyoug, isipusops sibag, iwlulays sibunatum. Tage yam towen Lot ilisow Sodom mo kov son dikuda̱kul muyamuy ikalka̱louw ma̱wana kweis, ikatimates gamag babaw iyakous. ");
INSERT INTO myw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Bo ma̱wan yam wanakoug waseg Gimgilitoun yey basap vayuwein ven watinow. ");
INSERT INTO myw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kukin kal biyeiwas wanpwa̱siw awoum beisiw vayuwein wanbunatum va̱gan bikow nawliyoug; awoum. O towen-vak wa̱bag awoum beiyum bein waven. ");
INSERT INTO myw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Kuninuways Lot inakwav. ");
INSERT INTO myw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Kukin sivinamiy bukwatinabweimiy mo mwamovamiy biyamkwaneimiy tage kukin biyamkwaneimiy mwamovamiy mo bukuba̱nes. ");
INSERT INTO myw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Adibakeimiy kukin ba̱yum bam boug waseg, asteiy tawaw bimasis keb katanok waseg, teitan bakow; tayuwein bisiw. ");
INSERT INTO myw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","“Vinay nay biwotets wit bikanimimayes, na̱tan bakow; nayuwein bisiw.” ");
INSERT INTO myw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO myw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iweis tasiyas, ilansa, “Tamwey, avanuy?” Yeisuw idibakes, ilana, “Am-palawen takanig immasis mo bikatuyouns bimeis mansiyas bunibwan.” ");
INSERT INTO myw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kweitan kabebay Yeisuw isekes va̱gan bisimkakins sinitoug waseg Yowbad. Mata ge beigweys. ");
INSERT INTO myw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ilana, “Ven kweitan takaleiwag ansinap kalbaleb. Nag igoul Yowbad, o nag ivna̱ses gamags. ");
INSERT INTO myw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Nakwab ven towen yam katanok katanok ininek mtowen takaleiwag, ilana, ‘Kumop ansinap gamag towen niyagageig.’ ");
INSERT INTO myw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","“Mtowen takaleiwag yam babaw nag iligen, ee... imwemway nen, mo ikawegweis won; nanon ilana, ‘Yey nag agoul Yowbad o nag avna̱ses gamags, tage bo ikawegweis woug, nakwab mana̱wen yam katanok katanok imimeim, mapuna bo bamop ansinap gamag towen niyageg, va̱gan beikous gunamouvit waseg mana̱wen vin. Kukin gog nag, adok bimimeim ee... bo bibilek woug!’” ");
INSERT INTO myw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","8","Ikous ankabebay towen, mo Yeisuw idibakes, ilana, “Kuninuways anilivan takaleiwag towen kalbaleb. Ma̱wan Yowbad bimop asisinap tasiyas iyagages inagamag, peinan igilagels waseg Yowbad iboug ee... iyam. Nag bikabiyun, nag. Bo bimop asisinap kalbaleb. Tage kweitan tut bam Gimgilitoun yey, tabta baba̱nes mwasanin tasiyas tasimounids ven watinow?” ");
INSERT INTO myw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gamag mwasinis idokes tatineis ididumwals o ikasigumis sisiyas. Mapuna Yeisuw idibakes kabebay towen, ilana, ");
INSERT INTO myw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tawaw asteiy ikatulags ineis Yowbad wanbunatun bunavakaein, silma̱nin nitoug. Teitan Palisiy, tayuwein takawein ta̱kis. ");
INSERT INTO myw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","“Palisiy anmwa̱net itamanaw, initoug mamagina, ‘O Yowbad, kalin nuwag ya̱koum, peinan yey nag ma̱wana gamag babaw, takalbalebs tasiyas, takwekways tasiyas, tasilakods tasiyas, tassubwans tasiyas; o yey nag ma̱wana takawein ta̱kis towena. Wik katanok katanok a̱pos akweiy yam va̱gan batapwa̱loul beibwein. O gunwuliyoug babaw alog sinawatan, kalgutan asekeim yak.’ ");
INSERT INTO myw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tage towen takawein ta̱kis itamanaw itow kadiveiyov, ikulul; nag itamnow matan bikin liba̱lab. Deisa iwaway vitakon, igeg nanon, ilana, ‘O Yowbad, binok nuwam takalbaleb yey!’ ");
INSERT INTO myw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Initoug ikous, iyum in wanven; mounid Yowbad idok taw towen tadidumwal, tage son mtowen Palisiy nag. Peinan kukin kal sivinan bimliguyaw mo beibus bein watinow, tage kukin kal biseib tatonen igaw mo biguyaw.” ");
INSERT INTO myw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vinay bimeyes-vak nitsiyas va̱gan Yeisuw bikabkwen wous. Navamul ikines bo isilbwades kid. ");
INSERT INTO myw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tage Yeisuw idawes bimeis, ilana, “Bweina gamagal bimeis waseg yey. Awoum kusilbwades. Yowbad nakaleiwag waseg, asibabaw ma̱wana tasiyas gamagal.” ");
INSERT INTO myw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Mounid adibakeimiy kukin bukumlavags ma̱wana gamagal yakamiy, bukutams waseg Yowbad nakaleiwag mo bukusiws waseg. Kukin gog nag, bo nag.” ");
INSERT INTO myw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Takaleiwag teitan ikatigan Yeisuw, ilana, “Takatimlakay bwanabwein yak. Aveiyag bavag va̱gan mwamovag nag beikous?” ");
INSERT INTO myw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","20","Yeisuw idibek, ilana, “Aveiyag wawun kudokeig toubwein yey? Toubwein anmwa̱net, mtowen Yowbad. Adok kukwakin Yowbad nakaleiwag, ‘Awoum kusubwan; awoum kuweiy gamag; awoum kuveinaw; awoum kuyaweid, teitan gamag liva̱nen; kuvna̱ses tamam, inam.’” ");
INSERT INTO myw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iwa̱ge mtowen, ilana, “Igaw-o wagwa̱dig asilamaw avvag youd tasiyas, o nagein igawa avvalut waseg.” ");
INSERT INTO myw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeisuw iligen, mo idibek, ilana, “Kweitan sinap ika̱bwag waseg yak. Kuvgen muwliyoug babaw kuyakous, kusekes tasiyas tasimavs; awoum bimapus. Maysan igaw mo bukukow walba̱lab. E, kuvgen kuyakous, mo tasimav yak, kum kubkunig yey.” ");
INSERT INTO myw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iligen livan towen, ipiyev; singay igeg nanon, peinan nawliyoug babaw, ikayus. ");
INSERT INTO myw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeisuw ikikin taw towen, ilana, “Singay keikay beisiws Yowbad inakaleiwag, tasiyas sivavag babaw. ");
INSERT INTO myw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","“Mana̱wen kamel beisiw wakunun vas, wotet towen gagab, tage keikay tasiyas sivavag babaw beisiws Yowbad nakaleiwag wanuwan.” ");
INSERT INTO myw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iliganes tasiyas, ilivans, ilansa, “Tage kalisiy beisiws?” ");
INSERT INTO myw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iw to Yeisuw, ilana, “Gamag nag kadilokes wotet babaw, Yowbad anmwa̱net kadilok.” ");
INSERT INTO myw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ikatugan, ilana, “Tage yakamey, bo nakalisow maven nakabkunim yak, aveiyag bakalivet?” ");
INSERT INTO myw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Iw to Yeisuw, ilana, “Mounid adibakeimiy kukin kal bilisow naven o nakwav o budan o taman o inan o nitun va̱gan bikanow Yowbad nakaleiwag, mo biban youd tasiyas, bikatimweis bibabaw ven watinow; ikous mo mwamovan biban, nag beikous.” ");
INSERT INTO myw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Navamul sinwatan asteiy tasiyas-wan idibakes, ilana, “Bo bitakatulags taneis Yelusalem, mo bikamat youd babaw tasiyas palopit kweiboug nilivnakes o nileles nises Bukitab waseg. ");
INSERT INTO myw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","“Bo ilivnakes liva̱nen Gimgilitoun, teitan bisilkod, va̱gan ven tobwag gimgilis biyousis, bisiba̱wes, biyagages, bigusus, biwaweiys waseg vatul, bikatimates; yam kweitoun mo beikit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Navamul nag ikakins youd tasiyas; mamagina bo isowm wasigeis. Nag ikakins silawun anilivan. ");
INSERT INTO myw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","36","Inoun ee... kakita bisap Yelikow, toukwaw teitan nissin wadadan ked, ininitoug money wasigeis tasiyas inounas wa̱ked; iligen butus babaw gamag inounas, ilana, “Aveiyag?” ");
INSERT INTO myw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Idibakes, ilansa, “Gum-Nasalet towen Yeisuw bo neim-ay bo bein.” ");
INSERT INTO myw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iwak, ilana, “Yeisuw, Deibid delen ya̱koum, binok nuwam yey!” ");
INSERT INTO myw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tasiyas nimugwas Yeisuw waseg, ika̱nes toukwaw towen, ilansa, “Kukwa̱pay!” Tage singaya iwak ilana, “Yeisuw, Deibid delen ya̱koum, binok nuwam yey!” ");
INSERT INTO myw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Yeisuw iligen, itoun ilana, “Kumeyes taw towen.” Imeyes, isineikim; Yeisuw ikatigan; ilana, “Aveiyag sivinam bavag peinam?” Ilana, “Tamwey kuvag matag beilal, bakin.” ");
INSERT INTO myw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iw to Yeisuw, ilana, “Bo ilal matam. Nukusimounid waseg yey, mapuna bo kubwein.” ");
INSERT INTO myw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nuwanaw matan ilal, ikin-wan; ikikun Yeisuw, iyya̱kawn waseg Yowbad. Gamag babaw bo ikines, bo ikavasis Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isap Yelikow, ikatidumwal wavtakon ven, in. ");
INSERT INTO myw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ven towen waseg taw yagan Sakiyus, takaweins ta̱kis sitovek, nawliyoug singay babaw. ");
INSERT INTO myw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mtowen Sakiyus sivinan bikin kal mtowen Yeisuw. Ta-ma̱wan. Gamag singay babaw, o towen Sakiyus takayakus. ");
INSERT INTO myw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mapuna isawl in wanakoug, imwen kay kaytan yagan sikamol va̱gan bikin Yeisuw, peinan beinoy beim ked towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeisuw im, itoun, itamnow matan, iban Sakiyus, idibek, ilana, “Sakiyus, nuwanaw kubus kum, sivinag bamasis wambunatum nagein.” ");
INSERT INTO myw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nuwanaw mo ibus, itam peinan bo anbwabwal towen; imwa̱saw silma̱nin. ");
INSERT INTO myw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tasiyas gog nikines, ivtokays livan, ilansa, “Yeisuw bo inek mtowen takalbaleb wanbunatum.” ");
INSERT INTO myw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tage Sakiyus idibek Yeisuw, ilana, “Guyaw, bo baliv gunwuliyoug, mwasanin basekes tasiyas tasimavs, mwasanin yey. O magat kweiboug basilponay gamags siwliyoug bakwey, bo bayamen mo bakatimweis siva̱toun, mamagina bo bimlavag siva̱vas basekes.” ");
INSERT INTO myw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Iw to Yeisuw, ilana, “Nagein Yowbad bo ikatinob bunatum towen, peinan taw towen Ebelam delen. Peinan Gimlilitoun yey gunawotet va̱gan banineiv takalbalebs, tasiyas mamagina sip bo nilasisulis ked, mo bakatinabwes.” ");
INSERT INTO myw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iliganes anilivan towen, mo ankabebay isekes. Silawun kabebay peinan kakita bisap Yelusalem; o tasiyas gog idokes nuwanaw mo bikines Yowbad nakaleiwag. Tage ikakina nag nuwanaw Yowbad bisilamaw nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mapuna ikabebay, ilana, “Tamwey teitan in kadiveiyov ven va̱gan bimlavag takaleiwag avakaein, mo beiyum beim. ");
INSERT INTO myw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Kakita binoun, idawes natouwats sinawatan, isekes simoney, sinawatan sinawatan, ilana, ‘Mimoney towen mamagina biwotet. Kuymiyises miwliyoug kweitan magin, kweitan magin, mamagina stow waseg gamag bigimwals, va̱gan mimoney mo kwatimweisis bibabaw. Kuvva̱ges ma̱wan ee... mo ba̱yum bam.’ ");
INSERT INTO myw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tage nagamag bo ikamliwes, ikayabes gamag mwasanin wankuyeim, asilivan mamagina, ‘Kapiyev taw towen. Awoum bikaleiwag wasigeis yakamey.’ ");
INSERT INTO myw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ilivans, bo nag. Taw towen imlavag takaleiwag avakaein. Iyum, in wanven, mo idawes natouwat bimeis, va̱gan bikin isimoney akweivin ikatimweisis. ");
INSERT INTO myw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Teitan inek, ilana, ‘Guyaw, money nukusekeig sinawatan bo akatimweis imlavag lakatutan sinawatan.’ ");
INSERT INTO myw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Iwa̱ge natovek, ilana, ‘Bwanabwein! Bo kutoukum yak. Peinan nukutoukum waseg wotet kakit bo basekeim mukwaleiwag waseg sinawatan ven.’ ");
INSERT INTO myw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tayuwein inek, ilana, ‘Guyaw, money nukusekeig sinawatan bo akatimweis imlavag sinawanim sinawatan.’ ");
INSERT INTO myw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Iwa̱ge natovek, ilana, ‘Ya̱koum-vak basekeim mukwaleiwag waseg kweinim ven.’ ");
INSERT INTO myw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Tatounun inek ilana, ‘Guyaw, mumoney towena. Bo asumweil asen, peinan bo aweneim, tayakeikay yak, peinan kuninineiv simwey sivavag bukukwey.’ ");
INSERT INTO myw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Iwa̱ge ilana, ‘Guntouwat kalbaleb yak. Amlivan toneim waseg bakatimlakeim amsinap kalbaleb. Kukwakin tayakeikay yey; aninineiv sigwey sivavag, akwekway. Aveiyag wawun nag kusen gunamoney wanuwan benk va̱gan ba̱yum bam mo bakow son intalest-nen bikatimweis bibabaw.’ ");
INSERT INTO myw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mo idibakes tasiyas nitowas wadadan, ilana, ‘Kukow inamoney, kusek mtowen namoney lakatutan.’ ");
INSERT INTO myw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ikatimapus siguyaw aygan, ilansa, ‘Towen namoney babaw, lakatutan.’ ");
INSERT INTO myw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mounid gog adibakeimiy, kukin kalisiy sivavag, bikatimweisis bibabaw; tage kukin kal navavag nag, bo bikwayes aveiyag idok nises, mo bimlavag tasimav tatonen. ");
INSERT INTO myw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Tasiyas gog nikamliweigs o nipiyaves gunakaleiwag, kumeyes kuweiys wamatag.” ");
INSERT INTO myw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ilivan ikous, imug, ikatulag, in silma̱nin Yelusalem. ");
INSERT INTO myw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Inoun ee... koy yagan Oliv, kakita mo bisap ven Betipeig son Betaniy, mo ikayabes navamul asteiy, bineis waven, ilana, “Kuneis waven palatan nises, kusaps ven towen mo bukuba̱nes donkiy mwana̱tan, kayon niyawanis vatul; igaw naptabod, nag ikakin gamag bisinis watapwan. E, bukuba̱nes donkiy mana̱wen, kulikus, kumeyes. ");
INSERT INTO myw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Kukin kal bikatiga̱neimiy, bilana, ‘Aveiyag wawun kulikus?’ mo kwatimapus aygan, kulansa, ‘Peinan tanuwagan sivinan.’” ");
INSERT INTO myw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tasiyas nikayabes nineis, iba̱nes donkiy ma̱wan nilivnek. ");
INSERT INTO myw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bilikus donkiy mana̱wen, natuwa̱vek ikatiga̱nes, ilansa, “Aveiyag wawun kulikus alem mana̱wen?” ");
INSERT INTO myw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iweis tasiyas, ilansa, “Tanuwagan sivinan.” ");
INSERT INTO myw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ilikus, inawes Yeisuw waseg, iyaves asikweim watapwan; Yeisuw isin. ");
INSERT INTO myw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mwasanin iyeves asikweim wa̱ked, Yeisuw mo inoun. ");
INSERT INTO myw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Kakita biwloubus koy towen Oliv, inavamul asibabaw bo imwa̱saws, ikavasis Yowbad, peinan bo ikines nawotet tawtoun. Ages avakaein ilansa, “Kalin nuwem Guyaw ya̱koum; nukum, Yowbad yagan waseg. Niwal son kamnat avakaein, wanakaew, walba̱lab.” ");
INSERT INTO myw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palisiy mwasanin wanuwan babaw gamag mo idibakes Yeisuw, ilansa, “Takatimlakay yak. Kusilbwed asilivan muvamul.” ");
INSERT INTO myw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iw to Yeisuw, ilana, “Magat tasiyas bika̱pays, mo dakul siyas biwkuwaks.” ");
INSERT INTO myw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Kakita bisap Yelusalem, ikin wunovek, iva̱lam peinan, ilana, “Magat nagein bukukwakins miked silma̱nin niwal. Tage bo isowm; mata ge bukukines. ");
INSERT INTO myw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","“Peinan igaw kweitan tut abamiy bigeg singay. Tasiyas ikamliweimiy bituyes pwepway bimlavag koy watoulan miven, o bidiliwunis watibwelon miven, va̱gan bikalituwanis boul biweis, biwaweimiy, bilaveimiy bukuneis wapwepway, simiyas nitimiyas; mibunatum bigulekwes beikous. Nag kweitan dakul bisesun wakaban. E, binuwakeimiy ma̱wan, peinan Yowbad bo ilakwaneimiy; nag gog, nag kuwtusis, nag kukwakins.” ");
INSERT INTO myw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Mo isiw in wanuwan Yowbad nabunatum ikikayabes tasiyas taggimwals, idibakes, ilana, “Yowbad anilivan mamagina: Gunbunatum silma̱nin nitoug, tage nukuva̱ges kid buntuman veinaw.” ");
INSERT INTO myw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Yam katanok katanok ikatimlakay Yowbad wanbunatum. Tanuwgwes lun sisiyas takatimlakeins kaleiwag, sisiyas tammwayas Yudiy sivines kid beiweiys Yeisuw. Ta-ma̱wan binuwakes beiweiys, peinan gamag babaw sivines anilivan. ");
INSERT INTO myw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yam kweitan Yeisuw ikatimlakes gamag Yowbad wanbunatum, o igeiguy livan bwanabwein, mo inekes Yeisuw tasiyas tanuwgwes lun sisiyas takatimlakeins kaleiwag, sisiyas tasiyas tammwayas. ");
INSERT INTO myw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Inekes Yeisuw, ilansa, “Aw-kaleiwag waseg kuwotet ma̱wan? o kal isekeim mukwaleiwag towen?” ");
INSERT INTO myw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Iw to Yeisuw, ilana, “Kweitan youd bakatugan wasigeis yakamiy. Kudibakeigs. Yon inakaleiwag waseg nibapta̱yses gamags, Yowbad isek nakaleiwag? o nag? gamag mwasanin isekes nakaleiwag?” ");
INSERT INTO myw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Sisiyas illivans, ilansa, “Kukin bitalivans ‘Yowbad isek,’ mo bikatimop aygads bilana, ‘Aveiyag wawun kupiyaves?’ Tage kukin bitalivans, ‘Gamag isekes’ mo gamag biwaweids, peinan idokes Yon palopit teitan.” ");
INSERT INTO myw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mapuna ikatimapus Yeisuw anilivan, ilansa, “Yakamey nag kakakin kal isek Yon nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iw to Yeisuw, ilana, “Yey-vak nag badibakeimiy kal nisekeig gunakaleiwag silma̱nin wotet towen.” ");
INSERT INTO myw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mo isekes nakabebay towen, ilana, “Teitan tamwey isop bigulen gleip, isekes gamag mwasanin siwotet va̱gan bimtakavates, mo inoun in kweitan ven, isik tut kadiveiyov. ");
INSERT INTO myw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Tutan gleip bimwanoug ikayeb natouwat bikow bag anagin, bimey, mo beikam, tage tamtakavateins bag bo kayuses anagin, iwaweiys tamwey natouwat towen ikous, mo ikayabes. Makava inoun, iyum. ");
INSERT INTO myw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Wankuyeim tamwey ikayeb tayuwein natouwat, iwaweiys-vak mtowen, iyagages, ivag anmwasin seikwan. Ikous mo ikayabes. Makava iyum. ");
INSERT INTO myw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Wankuyeim tamwey ikayeb tatounun, ibasis mtowen sikayal waseg, ikines bwayan kayal wa̱won, mo ilaves in watoulan ven. ");
INSERT INTO myw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tanuwagan bag nag ikakin seik ama̱wan biwkek, mo ilana, ‘O, bo bakayeb natug bwanabwein; tasiyas bigoulus, bisekes anagin bimey.’ ");
INSERT INTO myw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Inoun in natun, kakita binekes, tamtakavateins bag iwtusis, ilansa, ‘Natun mtowen. Tamwey bikanig mo nakiyay bikow, bag towen. Bo bitaweiys mo takawes dakiyays ya̱kids.’ ");
INSERT INTO myw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“E, ituts, iwekes, iyousis, inawes watoulan bag ikatimates. Tanuwagan bag igaw mo beim, aveiyag binuwakes tasiyas? ");
INSERT INTO myw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Adok beim biwaweiys biyakous gamag tasiyas, mo binineiv gamag mwasanin, bisekes siwotet bimtakavates inabag.” Iliganes anilivan towen; ilansa, “Awoum.” ");
INSERT INTO myw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tage Yeisuw ikikines tasiyas, ilana, “Silawun agulivan towen Bukitab waseg nileles mamagina: ‘Wululay towen tawteleins bunatum nipiyaves, tage bo imlavag anmwamwan bunatum.’ ");
INSERT INTO myw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Wululay towen yey. Kukin kal bikalivatow wakunuwatan wululay towen mo bibilek won; tage wululay towen bikalouw wakunuwatan gamag mo bikanimimey.” ");
INSERT INTO myw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tut towen tasiyas takatimlakeins kaleiwag sisiyas tanuwgwes lun sivines kid biyousis Yeisuw, peinan ikakins Yeisuw nakabebay silawun mamagina asisinap tatineis. Sivines kid biyousis Yeisuw. Ta-ma̱wan, peinan iwenes gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Deisa ikaymates Yeisuw, o ikayabes sitouwat mwasanin, askakin mamagina tasimounids tage tayyaweids; bikatiliganes Yeisuw anilivan va̱gan biliganes silawun ya̱tal, waseg biyateles Yeisuw wamatan takaleiwag avakaein, ven Yudiy waseg. Takaleiwag mo biligen ya̱tal, bikaluweg. ");
INSERT INTO myw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tasiyas inekes Yeisuw ilansa, “Takatimlakay yak, kakakin amlivan bwein o mukwatimlakay bwein, o nag kuwenes gamag mwasanin o mukwatimlakay katanok-wan gamag babaw wasigeis. Peinan Yowbad inaked kwatimlakem mounid. ");
INSERT INTO myw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“E, tab kadilok bitapa̱yin Sisal nata̱kis? o nag?” ");
INSERT INTO myw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Tage Yeisuw ikakin asisinap, idibakes ilana, “Money dakul kusekeig kweitan, bakin.” Isekes mo ilana, “Kal kululuwan nileles? o kal yagan nileles waseg?” Ilansa, “Sisal.” ");
INSERT INTO myw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iwa̱ge Yeisuw, ilana, “Kadiloka Sisal navavag bitasekes Sisal; o Yowbad navavag bitasekes Yowbad.” ");
INSERT INTO myw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Peinan tasiyas iyokons; bo nag. Ta-ma̱wan biba̱nes aveiyag kalbaleb Yeisuw bilivan wamtes gamag babaw va̱gan biyateles. Iliganes gog Yeisuw nakatumap, bo isom ninous, isesusa ikka̱pays. ");
INSERT INTO myw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ikous asilivan tasiyas, mo Sadusiy mwasanin mo inekes. Gamag tasiyas Sadusiy idokes gamag ya̱kids bitakanigs, nag bitakits vayuwein. ");
INSERT INTO myw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tasiyas ikatiga̱nes Yeisuw, ilansa, “Takatimlakay yak. Moses nilel dakaleiwags va̱gan kukin kal taw bikanig, nakwav sam, tage natun nag, takanig bwadan o tuwan mo beivay son nakwab, mo bikop natun bimlavag takanig natun. ");
INSERT INTO myw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","31","“Taw teitan siney budan teinim tatanok, ivay son nakwav, ikanig, natun nag. Isiken ivay son nakwab, mo ikanig, natun nag. Isiken ivay son nakwab, ikanig, natun nag. Ma̱wana ma̱wana ee... tasiyas teinim teiy ivays sisiy vin mana̱wen ikanka̱nigs ikous, nitus nag. ");
INSERT INTO myw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","“Ikous, mo vin ikanig. ");
INSERT INTO myw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Igaw beikits vayuwein, kal nakwav mana̱wen? Peinan sikwev asibabaw.” ");
INSERT INTO myw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","36","Yeisuw ikatimop asilivan, ilana, “Ven watinow gimgilis nibokeimiy kuveivays, tage tasiyas Yowbad idok asisinap kadilok beikits vayuwein silma̱nin tut wanakoug, tasiyas gog nag iveivays o nag ibokes, nag. Ta-ma̱wan bikanigs vayuwein, peinan imlavags min-liba̱lab tasiyas. Peinan ikits vayuwein bo imlavags Yowbad nitun tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","“Takanka̱nigs ikits vayuwein. Moses ikatimlakeids ma̱wan. Bukitab bitavin kweiboug liva̱nen Moses iligen Yowbad aygan wanuwan kaligweg makaywen nigidaged kov, peinan Moses idok Yowbad mamagina Ebelam naYowbad, Aysak naYowbad, Yekob naYowbad. Nag takanig tasiyas. Yowbad tamwamovs gamag siYowbad; nag takanig siYowbad. Yowbad waseg babaw tamwamovs.” ");
INSERT INTO myw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iweis tasiyas takatimlakeins kaleiwag ilansa, “Mounid, takatimlakay ya̱koum amlivan bwein.” ");
INSERT INTO myw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Asilivan babaw ikatimop bwein, mapuna iwenes vayuwein bikatiga̱nes. ");
INSERT INTO myw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeisuw mo ikatiga̱nes tasiyas, ilana, “Ama̱wan gamag bidokes Kelis Deibid tabun? ");
INSERT INTO myw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","“Deibid anilivan, nilel, nises buk yagan Sam waseg: ‘DaGuyaws idibek gunguyaw, ilana: Kusin wagunka̱tay va̱gan bava̱ges tasiyas astameiliw yak, mo bimlavags mamagina mukwabtatet, bukuvnivans wakunuwtes.’ ");
INSERT INTO myw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“E, kuninuways Deibid idok Kelis inaguyaw. Kukin Kelis meinoy neim Deibid waseg, ama̱wan bivkek bikativin bimlavag naguyaw?” Yeisuw ikatiga̱nes, ta-ma̱wan bikatimapus anilivan. ");
INSERT INTO myw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Yeisuw mo iguyes tasiyas inavamul, o gamag babaw niliganes, ilana, “Kadiloka kupiyaves tasiyas takatimlakeins kaleiwag asisinap, sivines kid asikweim vayvayov, o sivines gamag bikakoks binounas wamtes, o tapwa̱loul waseg sivines keb wanakaew, o sivines bimliguyaws sagal waseg. ");
INSERT INTO myw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Tage ikukwayes nakwabs sivavag, mo ikululs initougs aveiyov, va̱gan gamag bisimounids, bidokes asisinap bwein. Nag gog, kalbaleb. Igaw Yowbad bimop asisinap. Singay kalbaleb bilivatus.” ");
INSERT INTO myw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeisuw itamnow matan, ikines guyawaw mwasanin imulouls Yowbad wanbunatum. ");
INSERT INTO myw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wankuyeim mo ikin nakwab nasimav imuloul akweiy toya. ");
INSERT INTO myw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Ikin ikous, mo ilivan ilana, “Mounid adibakeimiy nakwab mana̱wen namuloul bo itamap wasigeis tasiyas asibabaw. Peinan tasiyas simoney babaw, imulouls ikous, tamkwalan nises; tage mana̱wen namoney misinaka kweiy toya, imuloul ikous, nag aveiyag nises bigimwal kan.” ");
INSERT INTO myw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Gamag mwasanin ilivans Yowbad nabunatum liva̱nen, peinan bo ikawyamis dakul bwana̱bweins, o gamag sisiwa̱youb wasigeis. Yeisuw iligen asilivan, ilana, ");
INSERT INTO myw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Youd tasiyas nukukines, igaw kweitan tut mo bigulekwes biyakousis. Nag kweitan dakul bisesuna wakaban.” ");
INSERT INTO myw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iweis tasiyas, ilansa, “Livan towen nukulivan, avei-tut waseg mo bivag ma̱wan? Ama̱wan bakakakin kakita bo bigulekwes?” ");
INSERT INTO myw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ilana, “Awoum gamag bikatidavimiy. Tawaw babaw bisaps yagag waseg bilansa, ‘Yey mtowen yey’; o adok bilansa, ‘Anayam bo neim.’ Awoum kubwa̱kuns wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Igaw bukuliganes bulagan naviy o bulagan kawpwanaw; awoum beivag amipwa̱yat. Sinap tasiyas wanamug, tage tut nakabiyokous wankuyeim.” ");
INSERT INTO myw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mo idibakes, ilana, “Ven avakaein bikanaviys wasigeis ven avakaein. King siney nagamag bikanaviys wasigeis kweitan king siney nagamag. ");
INSERT INTO myw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“O nik binkunik avakaein. O ven mwasanin bikamates moun, o katoun bisap; ven mwasanin gimgilis bimta̱mats. O gamag biwenes singay peinan bikines walba̱lab mulin naman Yowbad. ");
INSERT INTO myw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Youd tasiyas kalbaleb tut wanakoug singay, tage watapwan tut gamag biyousimiy biyagageimiy, biyateleimiy sinagog waseg, o bisena̱miy wa̱deil; o peinan gungamag yakamiy bo biyateleimiy wamtes tasiyas king, o takaleiwags kawka̱veks wamtes. ");
INSERT INTO myw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Igaw tutan biyateleimiy, mo kwamteles liva̱neig yey. ");
INSERT INTO myw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Awoum ninoumiy bibabaw. Awoum ninoumiy kulansa, ‘Ama̱wan bakakatimop asilivan?’ ");
INSERT INTO myw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","“Peinan yey basekeimiy amilivan, o amisinap, o bukutawtouns wasigeis tasiyas niyateleimiy. Nag kadilokes bikatimapus amilivan, nag. ");
INSERT INTO myw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Timimiyas bisilkodeimiy. E, inmiyas, tuwmiyas, budimiyas, tawlimiyas o veimiyas bisilkodeimiy, mo bikatimateimiy yakamiy mwasanin. ");
INSERT INTO myw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","“Asibabaw bikamliweimiy, peinan gungamag yakamiy. ");
INSERT INTO myw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Tage nag biyagageimiy. Nag bigutus walitanok kunumiy. ");
INSERT INTO myw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","“Kukin bukwaptuleimiy mo bukuyamoveimiy. ");
INSERT INTO myw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tage igaw bukukines takanaviy asibod babaw bidiliwunis miven Yelusalem, mo bukukwakins kakita bigulekwes. ");
INSERT INTO myw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","“Yakamiy magat bukusikes Yudiy, kadiloka kusawls kuneis wa̱koy; o yakamiy waven kadiloka kuneis wanawoud; o yakamiy wa̱bag awoum kumeis waven. ");
INSERT INTO myw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Tut towen waseg Yowbad bo bimop gamag asisinap, mamagina bo bikamat sinap babaw nilivnek Bukitab waseg. ");
INSERT INTO myw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Tut towen siyas takakuda̱poms bilivatus kalbaleb, o tasiyas nisasus nitsiyas. Peinan ven watinow gimgilis abes singay bigeg, o Yowbad bikawkunes gamag tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Gamag tasiyas bimta̱mats naviy waseg; o tobwag gamag bimeis bigulekwes ven towen Yelusalem, bitokes min-Yelusalem binawes ven babaw wasigeis; o tobwag gamag tasiyas mo bivva̱nis Yelusalem pwepway-nen ee... tobwag gamag tasiyas situt mo biyakous. ");
INSERT INTO myw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Gamag bikines mulin naman Yowbad bivag ka̱las waseg, o tibukon waseg, o wutun wasigeis, biyagages. O ven watinow, kaysay singay bika̱wot avakaein, mapuna ven babaw gimgilis biliganes, beivag ninous babaw. Ta-ma̱wan bikakins, bikatinabwes. ");
INSERT INTO myw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","“Tawaw bo bisoumats, aspwa̱yat, bininuways ven watinow bo biyageg. Peinan liba̱lab tatonen bo bigulek. ");
INSERT INTO myw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Ikous, mo bukukineigs Gimgilitoun yey bo bam, lov waseg, son guntawtoun o yakawanag avakaein. ");
INSERT INTO myw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Igaw bisilamaws youd tasiyas, bweina bukutamnawes kayoumiy, bukukines takatinabweimiy bo beim.” ");
INSERT INTO myw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nakabebay kweitan isekes mamagina: “Kukines yaveinun siney amweilok babaw, biya̱sus yageivein kweivaw mo bukukwakins wuwal bo beim. ");
INSERT INTO myw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“E, ma̱wan bukukines sinap tasiyas bisipsaps, mo bukukwakins Yowbad nakaleiwag bo bisap. ");
INSERT INTO myw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mounid adibakeimiy tut towen gimgilis bisesus ee... mo sinap tasiyas bisipsaps. ");
INSERT INTO myw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“Liba̱lab son ven watinow beiyakous, tage agulivan nag biyakous, nag. ");
INSERT INTO myw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kuvna̱seimiy. Awoum ge ninoumiy bibula̱bol peinan kuninuways kaeimiy, o amiyoubwein, o amiwiskiy, o youd katanok katanok ven watinow waseg, mo Yowbad anayam bisibluteimiy, mamagina sik bikwaneimiy. ");
INSERT INTO myw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Peinan bo bisiblutes gamag ven watinow wadaban pwepway. ");
INSERT INTO myw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Tage yakamiy, kadiloka kukwaymates tut babaw, kuninitougs va̱gan Yowbad bilabeimiy bikimtuweimiy, mata ge bikwaneimiy youd siyas kalbaleb, wankuyeim mo bukutamanaws yey Gimgilitoun yey wamatag.” ");
INSERT INTO myw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yam katanok katanok ikatimlakes gamag Yowbad wanbunatum, o boug waseg inoun in wa̱koy yagan Oliv, imasis. ");
INSERT INTO myw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ga̱boug katanok katanok gamag babaw mo ikattuyouns imimeis Yowbad wanbunatum va̱gan biliganes aygan. ");
INSERT INTO myw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yam mwasanin ikous mo bisagals, Kaltuwon Sigeilin. Sagal towen nag ikams bled son yist tage makava bled ikams. ");
INSERT INTO myw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tasiyas tanuwgwes lun sisiyas takatimlakeins kaleiwag iyokons ama̱wan beiweiys Yeisuw bikatimates. Ta-ma̱wan, peinan iwenes gamag babaw. ");
INSERT INTO myw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Seitan nanon mo isiw wanuwan Yudas, yagan Iskaliyot, Yeisuw navamul teitan. Navamul babiweis sinawatan asteiy. ");
INSERT INTO myw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Seitan nanon isiw Yudas wananon; Yudas isap, inoun, inekes tasiyas tanuwgwes lun sisiyas tulals, sisiy illivans, ama̱wan bisilkod Yeisuw va̱gan tasiyas mo biyousis. ");
INSERT INTO myw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tasiyas iliganes anilivan, imwa̱saws, ilivans money kid bisekes Yudas, maysan nawotet towen. ");
INSERT INTO myw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mtowen Yudas itam, iyokon ama̱wan bisilkod Yeisuw. Sivinan gamag babaw bigayays, mo Yeisuw biba̱nes anmwa̱net, biyousis. ");
INSERT INTO myw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yudas ikayamat ee... anayam waseg ikams makava bled, o beiweiys aleis la̱miy Yowbad wanbunatum, silma̱nin Kaltuwon Sigeilin. ");
INSERT INTO myw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yam towen Yeisuw mo ikayabes Pita son Yon bineis waven, ilana, “Kuneis kuva̱ges Kaltuwon Sigeilin; bitakams ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iweis tasiyas, ilansa, “Avanuy bakavag kan?” ");
INSERT INTO myw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Ilana, “Bukunounas, bukusaps waven, taw teitan ikokew kunasoup bilivatumiy, mo bein, beisiw wabunatum. Kwabkunis, kudibakes tanuwagan bunatum, kulansa, ‘Datakatimlakays ilana: Avanuy bwabwal yakamey mabunatum waseg bakakamkwam Kaltuwon Sigeilin, sigwey gunavamul?’ ");
INSERT INTO myw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“Kulivans ma̱wan mo bikamtilakeimiy bunavakaein wanakaew wanbunatum nises, son kabanen. Towen waseg kuva̱ges kads.” ");
INSERT INTO myw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iliganes, ineis, iba̱nes ma̱wana nilivnek; mo iva̱ges kan silma̱nin sagal towen beikams. ");
INSERT INTO myw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Anatut beikams, Yeisuw isinis siney tasiyas takaweins anilivan. ");
INSERT INTO myw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Idibakes, ilana, “Singay sivinag sigwey yakamiy bitakams sagal towen, peinan bo balivet mamayuy. ");
INSERT INTO myw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","“Nag vayuwein ba̱kam sagal towen oko anatut sagal towen wuta̱lan beikous Yowbad nakabkaleiwag waseg.” ");
INSERT INTO myw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Ilivan ikous, mo ikow kwa̱vig, ikalin nuwan waseg Yowbad ikous, ilana, “Kukwawes kwa̱vig towen kumoums tatanok tatanok yakamiy, peinan igaw nag ba̱moum gleip sipinen ee... Yowbad nakaleiwag mo bisilamaw.” ");
INSERT INTO myw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","21","Wankuyeim mo ikow bled; ikalin nuwan ikous, ikivis, ivvagein, isekes, ilana, “Woug towen, tage mtowen tasilkodeig sidayas nitakamkwams. ");
INSERT INTO myw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“Peinan Gimgilitoun yey gunaked Yowbad bo ikaluweg. Ked towen ba̱noy ban, tage mtowen tasilkodeig mo bilivet kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Navamul tasiyas mo illivans sisiyas wasigeis, idokes kavel bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ikous, tasiyas-wan kamniman kweitan iva̱ges, peinan idokes kal bimlavag astamumug. ");
INSERT INTO myw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeisuw mo idibakes, ilana, “Ven tasiyas igaw dadub siking ikalawages tasiyas, o ilansa, ‘Amatakaleiwag ilabemas.’ ");
INSERT INTO myw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Tage yakamiy awoum ma̱wana tasiyas. Kadilok amitamumug bimlavag ma̱wana gwad, o mitovek ma̱wana mitouwat. ");
INSERT INTO myw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Kal imug? Towen isin wa̱keb ikamkwam? O adok towen natouwat isek kan ikam? Nag, towen isin wa̱keb tamumug. Tage yey wasigeis yakamiy, ma̱wana mitouwat yey. ");
INSERT INTO myw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","30","“Sigwey yakamiy nukulabeigs gunamouvit waseg. Mapuna bakaluweg abamiy beibwein tut wanakougwaw silma̱nin. Tamag bo ikaluweg a̱bag o gunakabkaleiwag bwanabwein, ma̱wan-vak akaluweg abamiy bwein, sigwey yakamiy mo bitakams bitamoums gunakabkaleiwag waseg, o bukusinis wamikabkaleiwag mamagina guyawun Yisleil yakamiy, bukwaleiwags wasigeis asikum sinawatan kweiy. ");
INSERT INTO myw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Ya̱koum Saymon kuligen agulivan. Seitan bo sivinan bikaweimiy va̱gan biyakwaneimiy ma̱wan tata̱yins wit iwaweiys mo anagin iba̱nes. ");
INSERT INTO myw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","“Tage bo anitoug waseg Yowbad va̱gan bukusimounid beibwein; awoum kukwalouw. Ikous, mo bikanavin nanoun ikous, kadiloka kulabes budam bitawtouns.” ");
INSERT INTO myw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iw to Pita, ilana, “Tamwey, kukin bilaveims bukun wa̱deil o bikatimateims, soug yak bitases.” ");
INSERT INTO myw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeisuw ilana, “Adibakeim Pita, nagein bukwaya̱neig siva̱toun mo beigel kolkolek.” ");
INSERT INTO myw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeisuw idibakes navamul, ilana, “Kweiboug akayabeimiy, kuta̱vins ven babaw, amikaw nag, kunamiy nag, amisandol nag, tabta aveiyag ika̱bwag wasigeis yakamiy?” Ilansa, “Nag.” ");
INSERT INTO myw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Idibakes, ilana, “Tut gog towen kal sam anakaw, bweina bikow, kwanan ma̱wan. O kukin kal nag ivag napulut, bweina biyamiyis anpwa̱lum, maysan bikow mo bigimwel napulut. ");
INSERT INTO myw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Adibakeimiy, bo bikamat liva̱neig nilivnek Bukitab waseg mamagina, ‘Mtowen siney takalbalebs idokes ma̱wana tasiyas.’ Peinan liva̱neig nilivnek, bo bikamat ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iweis tasiyas, ilansa, “Tamwey, kukin pulut siyas akweiy.” Yeisuw ilana, “Bo deis!” ");
INSERT INTO myw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ilisow ven, inoun in koy yagan Oliv ma̱wan angulagul yam babaw. Navamul ikabwa̱kuns waseg. ");
INSERT INTO myw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Isaps ven towen nimsikes-yay, idibakes, ilana, “Kunitougs waseg Yowbad. Mata ge Seitan biyakwaneimiy.” ");
INSERT INTO myw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ilisow navamuls, inay-o tana̱ban-o, mo ibasin kitatun, initoug, ilana, “Tamag, magat sivinam, bukukow agkwa̱vig kwaviwen; awoum ba̱moum, singay yayan. Tage awoum nanoug yey. Nanoum yak kuvag ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Initoug ikous, mo Yeisuw ikin wamatan gum-liba̱lab bo ileb, ikimtuw. ");
INSERT INTO myw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Singay Yeisuw nanon igeg, ikulul, initoug avakaein, anpulikas avakaein mamagina buya̱vin iwta̱wout wawepway. ");
INSERT INTO myw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Initoug ikous, itamanaw, inekes navamul bo imasis, peinan ninous igeg. ");
INSERT INTO myw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iba̱nes, idibakes, ilana, “Aveiyag wawun kummasis? Kukits, kunitougs; mata ge Seitan biyakwaneimiy.” ");
INSERT INTO myw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Igaw ilivan, gamag babaw isaps. Taw towen yagan Yudas, Yeisuw navamul teitan, bo imgwayes tasiyas babaw. Isineikik inek Yeisuw, bimulouls son. ");
INSERT INTO myw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeisuw ilana, “Yudas, bukumuloul waseg Gimgilitoun yey va̱gan bukusilkodeig? Oo-ne!” ");
INSERT INTO myw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tasiyas nitomos walasin Yeisuw ikakins gamag babaw biyousis Yeisuw, ilansa, “Tabta bakawaweiys tasiyas mapulut waseg?” ");
INSERT INTO myw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ilivans ikous, mo teitan itamnow napulut tanmunum iweiy teitan tanuwgwes lun sitovek natouwat, ibob teigan. ");
INSERT INTO myw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iwa̱ge Yeisuw, ilana, “Deisa!” mo ikabkwen teigan, ivag ibwein. ");
INSERT INTO myw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Yeisuw mo idibakes tasiyas tanuwgwes lun sisiyas tulals tasiyas nimtakavates Yowbad nabunatum, sisiyas tammwayas, peinan bo nimeis biyousis Yeisuw; ilana, “Bo nukumeis, mipulut minew kukokews, bukuyousigs ma̱wana tavveinaw yey? Yam katanok katanok sigwey yakamiy nitasesus Yowbad wanbunatum, nag kuyousigs. Nagein gog bukuyousigs, peinan imitut dadub kaleiwag waseg.” ");
INSERT INTO myw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ituts, iwekes, iyousis Yeisuw, inawes tanuwgwes lun sitovek wanbunatum. Pita ikikun kadiveiyov. ");
INSERT INTO myw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tawaw tasiyas ivla̱kes sikov tanuwgwes lun sitovek wanven, isinis wadadan kov. Pita siney tasiyas isinis. ");
INSERT INTO myw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita isin, kov imteil magin, na̱tan nakubukwab ikin bo ikabunik, iwtus, ilana, “Bo akin taw towen son Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita ikayan, ilana, “Nag! Nag akakin taw towen.” ");
INSERT INTO myw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Isesus ee... teitan gamag ikin Pita, ilana, “Ya̱koum Yeisuw nagamag yak, ne?” Iwa̱ge Pita, ilana, “Yey nag.” ");
INSERT INTO myw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Isesus ee... imwemway nen, tatounun anilivan tawtoun, ilana, “Mounid taw towen son Yeisuw nisesus, peinan gum-Galiliy.” ");
INSERT INTO myw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Iwa̱ge Pita, ilana, “Nag! Nag akakin aveiyag kulivan.” Igawa illivan, bo igel kolkolek. ");
INSERT INTO myw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yeisuw mo itouvin ikin Pita wamatan. Pita inuw Yeisuw anilivan mamagina: “Nagein bukwaya̱neig siva̱toun mo beigel kolkolek.” ");
INSERT INTO myw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita inuw Yeisuw anilivan, isap in watoulan ven, iva̱lam, singay igeg nanon. ");
INSERT INTO myw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tasiyas niyousis Yeisuw mo isiba̱wes, iwaweiys. ");
INSERT INTO myw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kweim waseg ilumwes matan, ikatiga̱nes, ilansa, “Kulivnek ma̱wana palopit ya̱koum. Kal to iweim?” ");
INSERT INTO myw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Asilivan babaw ikika̱nes Yeisuw, itawyages. ");
INSERT INTO myw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","69","Iyam ga̱boug, tammwayas katuyouns imimeis, tasiyas tanuwgwes lun sisiyas takatimlakeins kaleiwag. Itokes Yeisuw inawes silma̱nin ya̱tal, ilansa, “Kukin ya̱koum Kelis ya̱koum, kadiloka kudibakem ma̱wan.” Iw to Yeisuw ilana, “Kukin badibakeimiy, nag bukusimounids. O kukin bakatiga̱neimiy, nag bukwatimapus agulivan. Tage nagein Gimgilitoun yey mo bassin Yowbad wanaka̱tay, va̱gan bakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iweis tasiyas, ilansa, “Tage ya̱koum Yowbad Natun, ne?” Yeisuw idibakes, ilana, “Bo nukulivans ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tasiyas mo ilivans, ilansa, “Nag sivinads gamag bikamtilakeids ansinap kalbaleb, peinan nitaliganes anilivan kalbaleb, tatonena ikamumwan.” ");
INSERT INTO myw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","2","Iliganes anilivan, tasiyas babaw itamanaws, itokes Yeisuw, inawes Paylat waseg; mo iyateles, ilansa, “Yakamey min-Yudiy yakamey, o taw towen bimgwayem ked kalbaleb waseg. Nakaligen anilivan, ilana, ‘Awoum kutams Sisal nata̱kis waseg.’ Peinan ilana, ‘Yey Kelis, king yey.’” ");
INSERT INTO myw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Paylat ikatugan, ilana, “Ya̱koum min-Yudiy siking ya̱koum, ne?” Iwa̱ge Yeisuw, ilana, “Nukulivan ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Paylat mo idibakes tanuwgwes lun situwa̱veks sisiyas gamag babaw, ilana, “Nag kweitan aban ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Singay gog illivans, ilansa, “Bo ikabiyun gabman nakaleiwag. Ikatimlakes gamag ma̱wan. Bo isilamaw Galiliy o ven babaw Yudiy ikous, mo im ven towen, waseg anilivan towen kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paylat iligen asilivan, ilana, “Tage taw towen gum-Galiliy, ne?” ");
INSERT INTO myw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ilansa, “Oo!” Paylat ilana, “Elod takaleiwag ven Galiliy waseg, kadiloka kunawes binek Elod; mtowen bikaleiwag.” Tut gog towen Elod nises Yelusalem. Paylat ikayeb Yeisuw, binek Elod va̱gan bikaleiwag. ");
INSERT INTO myw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elod ikin Yeisuw neim, imwa̱saw, peinan tut kadiveiyov sivinan bikin Yeisuw. Bo iligen bulagan Yeisuw, tage sivinan bikin kweitan nawotet tawtoun. ");
INSERT INTO myw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ikatitugwan waseg Yeisuw ee... bo nag. Nag ikatimop anilivan. ");
INSERT INTO myw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tasiyas tanuwgwes lun sisiyas takatimlakeins kaleiwag itomos, singay iyateles Yeisuw, asilivan tawtouna singay. ");
INSERT INTO myw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elod siney natakanaviy iyagages Yeisuw peinan ikasigumis, o issiba̱wes. Ikous, mo isekes Yeisuw anakweim mwaynamnabwein bisikam, peinan isiba̱wes. Ikous mo Elod ikayeb beiyum binek Paylat. ");
INSERT INTO myw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yam towen Elod imwas son Paylat, peinan kweiboug kavikun son. ");
INSERT INTO myw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Paylat mo idawes bimeis tasiyas tanuwgwes lun, sisiyas takalleiwags, sisiyas min-Yudiy babaw. Imeis mo idibakes, ilana, “Nukumeyes taw towen, kuyateles, kulansa, ‘Imgwayem ked kalbaleb waseg, va̱gan bakakabiyun gabman nawotet.’ Wamtamiy bo nakatigan, nag kweitan ansinap kalbaleb aban ma̱wan nukuliva̱nes, nag. ");
INSERT INTO myw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","16","“Wankuyeim mo akayeb inek Elod, o Elod nag kweitan iban ansinap kalbaleb, nag; mo ikayeb vayuwein iyamnavaw; o nag kaban ansinap kalbaleb. Nag ivag silawun bitakatimet gamag towen. Misinaka bawaweiy vatul waseg mo balik binoun.” ");
INSERT INTO myw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO myw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iweis min-Yudiy tasiyas, iwaks, ilansa, “Awoum kulik taw towen, kwatimet-wan! Kulik Bala̱bas beim.” ");
INSERT INTO myw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mtowen Bala̱bas nises wa̱deil peinan bo ikabutus gamag ven towen waseg mo ikanaviys wasigeis gabman natakanaviy, o bo iweiy gamag mwasanin. ");
INSERT INTO myw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Vayuwein Paylat mo iliwon, idibakes tasiyas, sivinan kid bilik Yeisuw, binoun. ");
INSERT INTO myw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tasiyas gog iwkuwaks, ilansa, “Kwatikavates waklos beimat.” ");
INSERT INTO myw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sivtounun idibakes, ilana, “Aveiyag wawun bitaweiy? Aveiyag ansinap kalbaleb? Nag aban ansinap kalbaleb va̱gan bakatimet. Misinaka bawaweiy mo balik binoun.” ");
INSERT INTO myw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Tasiyas gog min-Yudiy singaya iwkuwaks, sivines kid bikatimates Yeisuw. Avakaein ages iwkuwaks ee... bo itawtoun asilivan; Paylat bo iwnatout, mo itam. ");
INSERT INTO myw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ilik taw towen nikabutus gamag silma̱nin naviy waseg gabman, tawa̱yin gamags mtowen Bala̱bas. Bo ilik, peinan gamag sivines. Tage Yeisuw itam silma̱nin ninous tasiyas biva̱ges. ");
INSERT INTO myw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Itokes Yeisuw, inawes, iyousis gum-Saylin mwana meinoy wanawoud neim, isekes Yeisuw anklos, tatonena ikew. Yeisuw imug in, gum-Saylin mtowen wankuyeim. ");
INSERT INTO myw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gamag singay babaw ibukunis, o vinay mwasanin ivva̱lams-wan, peinan beiweiys Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Yeisuw itouvin idibakes tasiyas ilana, “Vinay-nen Yelusalem yakamiy, awoum kuva̱lams peinan beiweigs, kuva̱lams pinamiy simiyas nitimiyas. Peinan tut kalbaleb bukulivatus, mo gamag bilansa, ‘Tasiyas vinakal bwein, ta-ivag nitsiyas, nag ikakuda̱poms, nag ivsasus pwa̱pwaws.’ ");
INSERT INTO myw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Tut towen waseg gamag bidibakes koy, bilansa, ‘Kugiyeil kum kudibwanim’; peinan biwenes Yowbad. E, tut singay kalbaleb bukulivatus. ");
INSERT INTO myw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Yey toubwein mamagina kay mwamov, bo iyagageigs yey, o yakamiy ma̱wana kaligweg nimta̱mats tasiyas bo biyagageimiy singay.” ");
INSERT INTO myw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tasiyas takanaviy bikatimates-vak takalbalebs asteiy. Sisiy Yeisuw inawes bikatikavates wasklos. ");
INSERT INTO myw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inawes ineis ven yagan “Busabwes,” mo ikatikavates naman kaken wanklos waseg, mo kativtawes klos akiwen, Yeisuw bikayagweg ee... beimat. Takalbalebs ma̱wan inuwakes, teitan wanaka̱tay, tayuwein wankimaw. ");
INSERT INTO myw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeisuw ikayagweg wanklos, initoug waseg Yowbad, ilana, “Tamag, kuwid asisimap kalbaleb, kunumlev. Peinan sikalbaleb niva̱ges nag ikakins.” Mo ikalawages anakweim; makava ilaves kweitan youd bikines kalisiy bikawes asikweim tatanok tatanok tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gamag babaw itowas ikikines, tage astakaleiwags isiba̱wes Yeisuw, ilansa, “Bo ikatinob gamag mwasanin; bweina bikatinob tatonen, magat mtowen Yowbad angamag Kelis.” ");
INSERT INTO myw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Tasiyas takanaviys-vak isiba̱wes, imimeis bisekes wayn yayan, ilansa, “Kukin ya̱koum min-Yudiy siking, kadilok kwatinabweim tatoneim.” ");
INSERT INTO myw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Anklos wakunuwatan bo ileles silawun neiweiys, mamagina: “Mtowen min-Yudiy siking.” ");
INSERT INTO myw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Takalbaleb teitan nikayagweg wanklos, iyeg Yeisuw, ilana, “Ya̱koum Kelis ne? Kwatinabweids simey ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Tage son ikan, ilana, “Adok nag kugoul Yowbad, peinan neiweim bukumat ma̱wana taw towen. Ya̱kid aditeiy kadiloka bitamat peinan adsinap kalbaleb; tage taw towen nag ivag ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mo idibek Yeisuw, ilana, “Yeisuw, igaw bukusilamaw mukwaleiwag, kadiloka bukunuweig yey.” ");
INSERT INTO myw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iw to Yeisuw, ilana, “Mounid adibakeim nagein bitasin ven bwanabwein waseg, yey soug yak.” ");
INSERT INTO myw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Bo yanay mo iladadub wadaban pwepway; ka̱las nag imiteil ven ee... itageg ka̱las mo ikamnat vayuwein. Maynawen kweim mwaynavakaein nisilbwed palakakit Yowbad wanbunatum mo iksigeb, ivag mwayney. ");
INSERT INTO myw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeisuw mo iwak, aygan avakaein, ilana, “Tamag, kululuwag kukow.” Ilivan ikous, mo ikanig. ");
INSERT INTO myw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Takalikay towen nikakin mo iya̱kawn waseg Yowbad, ilana, “Mounid taw towen tadidumwal.” ");
INSERT INTO myw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gamag babaw nikatuyouns ikikines ikous, mo iyums ineis wasiven; iwaways wavtakous, peinan ninous igeg. ");
INSERT INTO myw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yeisuw taliven nitowas ikikines, sisiyas vinay tasiyas nibukunis Yeisuw Galiliy waseg mo nimeis Yelusalem. ");
INSERT INTO myw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gum-Alimatiy teitan yagan Yosep, inaven Alimatiy wawnuwan Yudiy. Mtowen Konsel teitan, ansinap bwein, didumwal. ");
INSERT INTO myw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nag itam va̱gan bikatimates Yeisuw, bikayus kid; bo nag. Mtowen ikayamat Yowbad nakaleiwag asina̱vin beim. ");
INSERT INTO myw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mtowen Yosep inek Paylat, initoug won Yeisuw silma̱nin bikow binow bidibwen. ");
INSERT INTO myw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Itam Paylat. Mtowen Yosep in mo inibwis Yeisuw, ikawes inawes, isumweilis kweim pwapwa̱kaw, isenas wanuwan alawag, mamagina takunumwan nitateiys koy dakul waseg. Takanigs nag idibwanis kweiboug wanuwan alawag towen, peinan kweivaw mwana nitateiys, mo itakus Yeisuw alawag towen waseg. ");
INSERT INTO myw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yam towen ikatunags silma̱nin sagal nubweig, bo beiyam nubweig Sa̱dad, min-Yudiy tasiyas siSa̱bat. ");
INSERT INTO myw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vinay-nen Galiliy siyas nibukunis Yeisuw nimeis Yelusalem, bo ikikunis Yosep, ikines ama̱wan inuwek, Yeisuw isen wakalawag, mo iyums, ikatinages tagon simasim va̱gan won Yeisuw biptumis. SiSa̱bat iyeiwas, peinan Moses nakaleiwag ma̱wan. ");
INSERT INTO myw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","(-) ");
INSERT INTO myw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Iyam nen ga̱boug, kweivaw wik isilamaw. Walalayis vinay tasiyas ilakwanes alawagan. Tagon simasim to niva̱ges nisemos, bo ikawes inawes Yeisuw biptumis. ");
INSERT INTO myw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dakul towen nisenas Yeisuw alawagan wadon nikatibwades bo iba̱nes niyatipines nises wadadan. ");
INSERT INTO myw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Isiws ineis wanuwan iwekes makawa-wan. Nag iba̱nes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bo isunasun ninous, peinan alawag makaw; bo itamanaws wadides tawaw asteiy asikweim mamagina kavikawn, ikaligwen mites. ");
INSERT INTO myw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","7","Vinay aspwa̱yat, ikululs avakaein, migis kakita binek pwepway. Tawaw idibakes, ilansa, “Aveiyag wawun kunineivs towen tamwamov, takanig siven waseg? Kuninuways igaw simiy waGaliliy anilivan, ilana, ‘Teitan gamag bisilkodeig Gimgilitoun yey, va̱gan tasiyas takalbalebs bikatimateigs waklos. Kweitoun yam mo ba̱kit vayuwein.’” ");
INSERT INTO myw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Ilivans ikous, mo inuwes Yeisuw anilivan mamagin, mo ilisawes alawag, iyums, asilivan babaw idibakes Yeisuw navamul sinawatan tatanok sisiyas tasiyas babaw. ");
INSERT INTO myw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","Vinay tasiyas yiges Meliy Magdal, Yowan, Yemes inan yagan Meliy, sisiyas vinay mwasanin. Vinay tasiyas asilivan idibakes tasiyas takaweins Yeisuw anilivan. Tage nag isimounids, idokes asilivan mamagina kwa̱neib. ");
INSERT INTO myw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","(-) ");
INSERT INTO myw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yam towen asteiy inounas bineis ven yagan Emeyus. Kukin bitanoy Yelusalem biten Emeyus katanok veit. ");
INSERT INTO myw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tasiyas asteiy inounas illivans sinap tasiyas nikamat Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","16","Igaw illivans asteiy, Yeisuw mo inekes, asteitoun inounas, tage mites nag kadilok biwtusis Yeisuw. ");
INSERT INTO myw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeisuw idibakes, ilana, “Aveiyag kuliva̱nes amiteiy nukuninounas?” Ilivan ikous, itounis tasiyas; bo igeg ninous. ");
INSERT INTO myw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Teitan yagan Kliyopas, ikatimop anilivan, ilana, “Adok kweivaw gamag ya̱koum nukum Yelusalem, nag kukwakin aveiyag niva̱ges tut towen. Peinan gamag babaw bo ikakins.” ");
INSERT INTO myw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","20","Iwa̱ge Yeisuw, ilana, “Aveiyag?” Ilansa, “Liva̱nen gum-Nasalet yagan Yeisuw. Mtowen palopit nawotet tawtoun, anilivan tawtoun, wamatan Yowbad, wamtes-vak gamag babaw. Tage tasiyas imalun tanuwgwes sisiyas amatakaleiwags bo ipiyaves, iyateles; isekes mina-Lom wasigeis va̱gan bikatimates waklos. ");
INSERT INTO myw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Yakamey kadok mtowen bikatinabwem, min-Yisleil yakamey. E, bo iweiys ikous, sinovan. Akweiy yam bo nein wankuyeim. ");
INSERT INTO myw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Sinap kweitan mo kaligen, waseg isom ninom. Peinan simayas vinay mwasanin walalayis nagein ilakwanes alawagan, tage nag iba̱nes Yeisuw; iyums, ilansa, ‘Nakakin mamagina min-liba̱lab, asilivan ilansa, “Yeisuw bo imov.”’ ");
INSERT INTO myw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Simayas mwasanin mo ineis wakalawag, iwekes makaw, ma̱wan vinay asilivan, tage nag ikines Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iw to Yeisuw, idibakes, ilana, “Takabala̱wein yakamiy, bo ibol ninoumiy, peinan nag kusimounids kweiboug palopits asilivan! ");
INSERT INTO myw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“Kadiloka bigeg a̱ban Kelis, ma̱wana nukuliva̱nes; ikous mo bikow yakawanan avakaein.” ");
INSERT INTO myw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mo ikatimlakes liva̱nen tatonen Bukitab waseg. Isilamaw waseg Moses nakaleiwag o tasiyas palopit sikalelel o Bukitab babaw ikatimlakes ikous. ");
INSERT INTO myw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Inounas, ikkatimlakes ee... kakita bisaps wasiven. Yeisuw gog bilisawes binoun. ");
INSERT INTO myw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tasiyas gog kayuses, ilansa, “Kum wamabunatum kumasis, peinan bo ikwayav.” Isimkines mo itam; siney isiws wasibunatum. ");
INSERT INTO myw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Isiws wabunatum, isinis beikams; mo ikow bled, anilivan bwanabwein isek, ikivis, isekes beikams. ");
INSERT INTO myw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mamagina bo ilal mites, peinan iwtusis Yeisuw; ikous, mo imtikiniges tasiyas. ");
INSERT INTO myw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Asteiy ilivans, ilansa, “Mounid bo imwan woud, nikatimlakeid wa̱ked mo takakin Bukitab.” ");
INSERT INTO myw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Nuwanaw itamanaws, iyums ineis Yelusalem; iba̱nes navamul sinawatan tatanok katuyouns nisesus sisiyas gamag mwasanin. Navamul asilivan mamagina, “DaGuyaws bo ikit, inek Saymon, mo ikin.” ");
INSERT INTO myw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tasiyas asteiy mo ikamteles asisinap wa̱ked, peinan Yeisuw inekes, sisiy beikams, ikivis bled, mo iwtusis. ");
INSERT INTO myw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","37","Iliva̱nes ma̱wan, Yeisuw mo itoun wanuwein tasiyas, isiblutes. Aspwa̱yat; idokes tobwag, mamagina a̱luw. ");
INSERT INTO myw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Idibakes, ilana, “Awoum kuweneigs! Awoum ninoumiy bibabaw! Yey! Kukines namag, kakeig; yeya toneig. Kwabkwanes woug, kukines yeya toneig. A̱luw nag ivag viniyon son tatuwan ma̱wana nukukineigs yey.” ");
INSERT INTO myw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(-) ");
INSERT INTO myw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Singaya imwa̱saws, nag isimounids, peinan ninous babaw, mo idibakes, ilana, “Tabta kan nises ba̱kam.” ");
INSERT INTO myw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Iba̱nes in sulusul, isekes; ikam wamtes. ");
INSERT INTO myw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mo idibakes, ilana, “Agulivan towen nasekeimiy kweiboug sigwey yakamiy tasesus, peinan liva̱neig nises Moses nakaleiwag waseg, o liva̱neig nises tasiyas palopit sikalelel waseg, o liva̱neig nises wous tasiyas sam wasigeis; e, kadiloka liva̱neig babaw bikamat.” ");
INSERT INTO myw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mo ikatiboug nuwes bikakins Bukitab. ");
INSERT INTO myw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","Idibakes, ilana, “Bukitab waseg nileles mamagina: kadiloka bigeg a̱ban Kelis, beimat, yam kweitoun mo beikit vayuwein, mo liva̱nen Kelis bigeiguys ven babaw va̱gan gamag bilaves asisinap kalbaleb, mo Yowbad biwid binumlev. E, bisilamaws Yelusalem mo bineis ven babaw. ");
INSERT INTO myw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Yakamiy takaweins livan towen. ");
INSERT INTO myw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tamag nikatigik kululuwan teitan bilabeimiy. Yey ban mo bakayeb towen biwekeimiy. Kadiloka kusesusa ven towen ee... Yowbad natawtoun mo biwekeimiy.” ");
INSERT INTO myw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Anilivan ikous, imgwayes inounas ineis Beta̱niy, itamnow naman, anilivan bwanabwein isekes. ");
INSERT INTO myw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Igawa illivan mo ilisawes, imwen in walba̱lab. ");
INSERT INTO myw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iyums tasiyas, ineis Yelusalem, imwa̱saws seikwan. ");
INSERT INTO myw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tut babaw nisesus Yowbad wanbunatum, iya̱kawns waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wanamug gamag yagan Livan nises. Gamag towen yagan Livan waseg Yowbad nises. Gamag towen yagan Livan son Yowbad katanok-wan. ");
INSERT INTO myw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gamag towen yagan Livan son Yowbad wanamug nisesus. ");
INSERT INTO myw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gamag towen yagan Livan youda babaw ibubun. Peinan Livan towen waseg, mo Yowbad nibun youd meivek-wan. ");
INSERT INTO myw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mtowen taymovein youda babaw; mwamovan towen magina gamag ya̱kids dakamnats. ");
INSERT INTO myw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kamnat towen imteil ven dadub waseg. Dadub nag iyakous kamnat towen. Igawa nises. ");
INSERT INTO myw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yowbad nikayeb gamag teitan, tabibapta̱ysein gamags, yagan Yon. ");
INSERT INTO myw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yon neim; nawotet bikamtilakeids mo bitakines gamag towen ansinap kamnat, va̱gan kid babaw gamag mo bitasimounids waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon nag kamnat tatonen; misinaka ikamtilakeids bitakines mtowen kamnat tatonen. ");
INSERT INTO myw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mtowen kamnat mounid, immiteil wasigeis gamag tatanok tatanok. E, mtowen bo neim ven watinow. ");
INSERT INTO myw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Im watinow, ven towen nibubun; tage ven watinow nag ikakins mtowen. ");
INSERT INTO myw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Inekes inagamag, tage bo ipiyaves. ");
INSERT INTO myw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mwasanin gog bo itams waseg mtowen mo ita̱mes tasiyas, va̱gan bimlavags Yowbad nitun tasiyas, peinan isimounids mtowen Mesay waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nag ikopwes tasiyas, gamag buyvis waseg; nag. Nag ikopwes tasiyas peinan gamag sivines. Nag ikopwes tasiyas gamag sikaleiwag waseg; nag. Yowbad nakaleiwag waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Livan towen im watinow, imlavag gimgilitoun, nisik davanuys. Nakakin mtowen singay takamnat, mamagina Taman Natun tatonen, singaya isiwa̱youb, ansinap mounid waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yon nikatimlakem, niwkuwak, ilana, “Mtowen liva̱nen nalivan: ‘Igaw watibweloug teitan beim, bimug waseg yey. Yey ba̱bus, peinan tutan gunakabsilamaw waseg, mtowen igawa nises.’ ");
INSERT INTO myw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","“Mtowen guyaw avakaein; singaya ivvagein issekeids; nasiwa̱youb ikatitimweis bo ivakaein. ");
INSERT INTO myw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","“Moses bo isekeids nakaleiwag; tage Yeisuw Kelis isiwyoubuds ansinap mounid waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","“Ta-kweitan tut gamag ikin Yowbad, nag. Tage Yowbad nipwa̱kit Natun tatonen; mtowen nikatimlakeids Taman, mo takines.” ");
INSERT INTO myw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wankuyeim gamag mwasanin inekes Yon ikatugans waseg, mo ikatimop asilivan. Peinan min-Yudiy tammwayas tasiyas misikes Yelusalem ikayabes tanuwgwes lun, sisiyas mwasanin Livay delen nimtakavates Yowbad nabunatum. Ikayabes tasiyas, inekes Yon, ikatugans waseg, ilansa, “Kal ya̱koum?” ");
INSERT INTO myw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yon anilivan kamnat isek, ilana, “Yey nag Takatuneib Kelis, nag.” ");
INSERT INTO myw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mo ikatiga̱nes, ilansa, “Kal yak? Ilaytiy adok?” Ilana, “Nag.” Ilansa, “Adok ya̱koum palopit towen nakakayyamat?” Ilana, “Nag.” ");
INSERT INTO myw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mo idibakes, ilansa, “Kal yak? Liva̱neim aveiyag bukulivan, va̱gan bakanow bakasekes tasiyas nikayabemas nakam?” ");
INSERT INTO myw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Iw to Yon, ilana, “Yey tawkuwak wanawoud va̱gan bukukidumwa̱lus daGuyaws inaked, ma̱wan palopit Isaya nilivnek.” ");
INSERT INTO myw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tasiyas Palisiy misikes Yelusalem, nikayabes gamag tasiyas nimeis ikatugans waseg Yon. ");
INSERT INTO myw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","E, vayuwein tasiyas mo ikatiga̱nes, ilansa, “Kukin ya̱koum nag Kelis ya̱koum, nag Ilaytiy ya̱koum, nag palopit towen ya̱koum, aveiyag wawun kubapta̱yses gamags?” ");
INSERT INTO myw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Yon ikatimop asilivan, ilana, “Yey abaptays yevagam waseg. Tage wanuwein yakamiy teitan nises, nag kukwakins kavel; watibweloug mtowen beim, tage nag kadilokeig bakulul wamatan va̱gan kid bakablev nasandol, peinan mtowen singay iguyaw.” ");
INSERT INTO myw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ilivan ma̱wan Betaniy waseg, ven towen palata-dadan Yoldan. Ven towen waseg Yon nibapta̱yses gamags. ");
INSERT INTO myw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Neiyam-nen Yon ikin Yeisuw im, ilana, “Kukines Yowbad a̱len la̱miy mtowen lun bulukwan, beimat silma̱nids ya̱kids, va̱gan biwidids adsinaps kalbaleb waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Mtowen liva̱nen kweiboug nalivan, ‘Watibweloug teitan beim, mtowen bimug. Yey ba̱bus, peinan tutan gunakabsilamaw, towen igawa nises.’ ");
INSERT INTO myw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“E, yey nag bakakin kavel towen, tage nam abapta̱yseimiy min-Yisleil yakamiy yevagam waseg, va̱gan bukukwakins guyaw towen.” ");
INSERT INTO myw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Wankuyeim liva̱nen Yeisuw Yon mo ilivan; ilana, “Akin Kululuwan Yowbad ibus walba̱lab im, magin ma̱wana bwabun, iton Yeisuw wakunun. O yey nag bakakin towen, tage towen nikayabeig nam silma̱nin babaptays yevagam waseg, towen nidibakeig, ‘Kukin kal Kululuwag beibus biton wakunun, mtowen tabapta̱ysein gamags Kululuwag Bwanabwein waseg.’ Yey bo akin, to adibakeimiy mtowen Yowbad Natun tatonen.” ");
INSERT INTO myw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Neiyam-nen Yon mo itamanaws sen inavamul asteiy, itowas. ");
INSERT INTO myw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yon ikin Yeisuw ininoun, ilana, “Kukines Yowbad a̱len.” ");
INSERT INTO myw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Navamul asteiy iliganes, mo ikabwa̱kuns Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeisuw itouvin, ikines tasiyas ikabwa̱kuns waseg, mo ilana, “Aveiyag sivinamiy?” Tasiyas gog, ilansa “O matovek, avanuy mukusik?” (Aga-Muyuw “matovek”, ages gog tasiyas “Labay”.) ");
INSERT INTO myw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ilana, “Kumeis taneis mo bukukines.” Siney mo ineis, ikines nakabmasis, ikaypuls sisiy, asibabaw imasis ven towen, peinan bo ikwayav. ");
INSERT INTO myw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yam towen asteiy tasiyas niliganes Yon anilivan, ikabwa̱kuns Yeisuw waseg. Teitan yagan Andiluw inuw tuwan yagan Saymon Pita nises. ");
INSERT INTO myw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nuwanaw in inineiv tuwan; iban mo ilana, “Saymon, bo kaban towen Mesay.” (Takativini gog yagan “Mesay” bein aga-Gilis “Kelis”.) ");
INSERT INTO myw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andiluw mo itok tuwan inekes Yeisuw. Yeisuw ikabunik, mo ilana, “Ya̱koum Saymon, Yon natun ya̱koum; badokeim Pita.” (Takativini gog bein aga-Muyuw, “Dakul”.) ");
INSERT INTO myw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Neiyam-nen Yeisuw sivinan bein Galiliy. In Galiliy mo iban Pilip, idibek, ilana, “Kwabkunig yey.” ");
INSERT INTO myw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Andiluw son Pita siven Beteseid. To Pilip naven katanok-wan Beteseid. ");
INSERT INTO myw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip inek Nataniyel ilana, “Bo kaban Mesay; Moses nakaleiwag waseg nilel ilivnek mtowen beim bikatinabweids, o tasiyas palopits nileles ilivnakes liva̱nen towen waseg; mtowen gum-Nasalet, yagan Yeisuw, taman yagan Yosep.” ");
INSERT INTO myw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel ilana, “Adok na-ikadilok youd bwanabwein beim ven to Nasalet waseg. Adok nag.” Pilip ilana, “Kum, kukin.” ");
INSERT INTO myw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ineis; Yeisuw mo ikin Nataniyel imimeim, ilana, “Kukines taw towen ansinap bwein, nag bikatidev son, peinan gum-Yisleil mounid.” ");
INSERT INTO myw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel iligen anilivan, mo ilana, “Ama̱wan nukukwakin yey?” Yeisuw ikatimop anilivan, ilana, “Igaw Pilip bidaweim bukum, bo akineim mukusik yaveinun wangwanan.” ");
INSERT INTO myw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel ilana, “O guntovek, mounid ya̱koum Yowbad Natun ya̱koum; min-Yisleil ya̱kids imaking ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Yeisuw ikatimop anilivan, ilana, “Tayyaweid yak! Peinan adibakeim, alana, ‘Bo akineim yaveinun wangwanan’ mo kusimounid. Sinap towen kakit; igaw tawtoun bukukin. Mounid adibakeim igaw bukukin liba̱lab bikaliyow, Yowbad nataka̱yobs mo bimnamwens o bibweibus Mesay Gimgilitoun yey waseg.” ");
INSERT INTO myw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yam akweiy ikous, mina-Ken mwasanin mo isagals, veivay silma̱nin. Ken wawnuwan ven avakaein Galiliy. Yeisuw inan in Ken silma̱nin sagal towen. ");
INSERT INTO myw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bo idawes-vak Yeisuw, sen navamul, ineis sagal towen silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Issagals ee... wayn bo ikous. Yeisuw inan mo idibek, ilana, “Asiwayn bo ikous.” ");
INSERT INTO myw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iw to Yeisuw, ilana, “Adok mukwaleiwag towen; yey gunakaleiwag igaw.” ");
INSERT INTO myw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yeisuw inan mo idibakes tanuwagan sagal navamuls, ilana, “Aveiyag Yeisuw bidibakeimiy, kadiloka bukuwteles.” ");
INSERT INTO myw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kunasoup nisesus kunanim kunatan, silma̱nin min-Yudiy biwidis nimes, kikeis; peinan asisinap ma̱wan. Kunasoup kavka̱vek, vakanes mamagina gamag vakaeinan. ");
INSERT INTO myw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeisuw idibakes, ilana, “Kuvgwagwes kunasoup, yevagam waseg; mo ivgwagwes, in, ika̱lawt.” ");
INSERT INTO myw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yeisuw mo ilana, “Kunasoup waseg kukilis, kukwawes kunawes tanawagan sagal waseg,” mo iwteles ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Tanuwagan sagal ikamkwen yevagam towen bo imlavag wayn; nag bikakin avanuy meinoy neim, tage tasiyas takilins yevagam ikakins; tanuwagan sagal mo idow taveivay va̱gan beim bilivans son. Ilana, “Gamag babaw sagal nakabsilamaw waseg isekes wayn singaya bwein, imwamoums ee... iyakousis, wankuyeim mo isekes kalamwey wayn; tage ya̱koum amsinap kweitan, wayn bwanabwein kwayus, sagal nakabiyokous waseg mo kusekem ka̱moum.” ");
INSERT INTO myw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nakabsilamaw mulin naman Yeisuw nivag towen, ven Ken wawnuwan Galiliy, waseg ikatimlakes natawtoun, navamul mo isimounids waseg. ");
INSERT INTO myw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sagal towen ikous, mo iyum ineis Kapaneyum son inan, siney budan, o navamul. Nag biveiyov tut nisesus Kapaneyum. ");
INSERT INTO myw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Min-Yudiy kakita bo bisagals, sagal towen yagan Kaltuwon. Mapun Yeisuw in Yelusalem. ");
INSERT INTO myw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Isap Yowbad wanbunatum iba̱nes tasiyas tanuwgwes bulumakaw, o sip, o bwabun, nimeyes aleis va̱gan gamag babaw mo bigimwals wasigeis; sisiyas tasiyas takaweins money va̱gan bikatimapus dakul silma̱nin muloul Yowbad wanbunatum. ");
INSERT INTO myw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yeisuw ikow vatul, ivkek inanew va̱gan biwaway, mo ikawsapes, babaw isawls ineis watoulan. Ikawsapes aleis, ineis watoulan. Simoney itigabaw ininein wapwepway; siteibol ikatitan, ikalka̱louw ikanta̱nays. ");
INSERT INTO myw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Idibakes tanuwgwes bwabun, ilana, “Kukwawes, kunawes watoulan. Awoum kuva̱ges Tamag nabunatum magina abgimwal.” ");
INSERT INTO myw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Navamul ikikines, mo inuwes Bukitab nilivnek mamagina, “Bo iseiw nuwag mubunatum.” ");
INSERT INTO myw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Min-Yudiy mo ikatiga̱nes Yeisuw, ilansa, “Namam mulin aveiyag bukwatimlakem va̱gan bakakakin mukwaleiwag, wotet towen silma̱nin?” ");
INSERT INTO myw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeisuw ikatimop asilivan, ilana, “Bukugulekwes bunatum towen, yam kweitoun mo bawlulavaw.” ");
INSERT INTO myw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Min-Yudiy ilansa, “Bweilim sinawavas kweinim katanok iwlules Yowbad nabunatum towen. Adok nag kadilokeim bukuwlulavaw kweitoun yam waseg.” ");
INSERT INTO myw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tage Yeisuw nag ilivan liva̱nen Yowbad nabunatum, ikabebay silma̱nin won tatonen. ");
INSERT INTO myw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Igaw tut wankuyeim mo ikanig, ikit vayuwein; ikous, navamul mo inuwes anilivan towen, mo isimounids Bukitab waseg, o isimounids Yeisuw anilivan waseg. ");
INSERT INTO myw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Igaw nises Yelusalem, sagal towen Kaltuwon waseg, babaw gamag ikikines naman mulin mo isimounids waseg. ");
INSERT INTO myw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Tage Yeisuw nag isimounid wasigeis tasiyas, peinan ikakina gamag babaw asisinap. Nag kadilok teitan bikatimlek sinapun gamag, peinan ikakina gamag ninous. ");
INSERT INTO myw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Palisiy teitan yagan Nikodimos, guyawun ven Yudiy. ");
INSERT INTO myw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mtowen inek Yeisuw, boug waseg, ilana. “Tamwey, kakakin Yowbad nikayabeim nukum kwatimlakem yakamey, peinan namam mulin kuvag mamagina Yowbad nawotet. Kukin nag Yowbad soum bilabeim, nag bukuwtel ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeisuw ilana, “Mounid anukweim, magat nag bikopweim vayuwein, nag bukukin Yowbad nakaleiwag, nag.” ");
INSERT INTO myw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iw to Nikodimos, ilana, “Adok nag kal bikopweig vayuwein! Ta-ma̱wan inag bikopweig vayuwein, peinan yey bo avakaein.” ");
INSERT INTO myw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeisuw ilana, “Yowbad Kululuwan kadilokena bikopweim! Mounid anukweim, kukin Kululuwan Yowbad nag bikopweim yevagam waseg, ta-ma̱wan bukusiw wanuwan Yowbad nakaleiwag. Tage kukin Yowbad Kululuwan bikopweim, bweina bukusiw wanuwan nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","“Gimgeilin inan bikop gimgeilin-wan; tage Kululuwan Yowbad bikop bo kululuwan-wan. ");
INSERT INTO myw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Awoum bisunasun nanoum agulivan towen, ‘Kadiloka bikopweimiy vayuwein.’ ");
INSERT INTO myw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Yag ampalawen sivinan beitow, butkawan bukuligen, tage nag kukwakin avanuy meinoy neim, o bein avanuy. Ma̱wana tasiyas Yowbad Kululuwan ikopwes.” ");
INSERT INTO myw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimos ikatimop anilivan, ilana, “Ama̱wan youd tasiyas?” ");
INSERT INTO myw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","11","Yeisuw idibek, “Adok min-Yisleil wasigeis, ya̱koum takatimlakein gamags, ya̱koum; tage nag kukwakin youd siyas, ne? Mounid anukweim, aveiyag nakakakin youd siyas kanukweimiy, o yakamiy gog nag kusimounids. ");
INSERT INTO myw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Peinan ta-kusimounids agulivan, sinapun ven watinow waseg, ta-ma̱wan bakatimlakeimiy sinapun liba̱lab! ");
INSERT INTO myw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Nag kadilok gamag beimwen bein walba̱lab. Misinak Gimgilitoun yey, bo alisow gunaven liba̱lab, a̱bus am watinow, kadilokeig ba̱yum ban walba̱lab. ");
INSERT INTO myw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","“Kweiboug wanawoud, Moses itamnow mwatet tanmunum, ma̱wan magin igaw mo bitamnaweigs yey, Gimgilitoun yey, va̱gan kal yak bukusimounid waseg yey mo bukuban mwamovam bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Singay Yowbad isiwyoubus ven watinow gimgilis. Natun gog anmwa̱net bo itam, bo isek va̱gan bikatinabwes gamag. Kukin kal bisimounid towen waseg nag bigeg, nag; mwamovan son bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Yowbad ikayeb natun neim ven watinow nag silma̱nin biyateles gamag babaw, nag; nikayeb neim va̱gan kid bikatinabwes gamag. ");
INSERT INTO myw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Kukin kal bisimounid waseg Yowbad Natun, nag biya̱tal; nag. Tapiyaveins gog Yowbad Natun siya̱tal nises, peinan nag isimounids waseg Yowbad Natun anmwa̱net-wan, o peinan yagan ipiyaves. ");
INSERT INTO myw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Silawun ya̱tal towen, peinan kamnat bo isap im ven watinow; tage gamag ipiyaves, sivines kid dadub, peinan siwotet kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Takalbalebs ipiyaves gog kamnat; nag bimeis kamnat waseg, peinan bo bimteil asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Towen gog nawotet mounid bo bimek kamnat waseg, mo bimteil nawotet bwanabwein, niwwtel Yowbad waseg.” ");
INSERT INTO myw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wankuyeim Yeisuw sen navamul mo ineis wawnuwan ven Yudiy; misikes ven towen, ibibapta̱yses gamag. ");
INSERT INTO myw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yon gog misik ibibapta̱yses gamag ven yagan Aynon, walasin Selim, peinan ven towen yevagam avakaein nises. Gamags imimeis mo ibapta̱yses. ");
INSERT INTO myw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nag iyousis Yon va̱gan beisiw wa̱deil. Igaw. ");
INSERT INTO myw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yon navamul mwasanin mo ikamnimans sisiy gum-Yudiy teitan, idokes kalisiy sivka̱kay bwein va̱gan biwid gamag sikalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mapuna inekes Yon, ilansa, “Tamwey, taw towen nukwatimlakem, kulana, ‘Yowbad a̱len towen,’ kweiboug soum nukusesus ven towen niweiw, Yoldan nimeim; tut towen bo neim ibapta̱yses gamags, o gamag babaw ininekes.” ");
INSERT INTO myw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yon ilana, “Tanuwagan liba̱lab takaleiwag inasiwa̱youb wasigeis ya̱kids va̱gan bitamwa̱saws. Towen anmwa̱net takaleiwag. ");
INSERT INTO myw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Yakamiy nukuliganes agulivan mamagina, ‘Yey nag Mesay Kelis; nag. Misinaka Yowbad nikayabeig amgwey mtowen Kelis.’ ");
INSERT INTO myw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Mtowen, imwa̱saw ma̱wana taveivay, peinan taveivay ikow inakwav. Veiyon-vak imwa̱saw peinan ikin taveivay ikow inakwav. Yey ma̱wana veiyon towen, aligen aygan, amwa̱saw avakaein, mtowen Yeisuw silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","“Butun mtowen bo bivakaein; yey gog bo ba̱bus.” ");
INSERT INTO myw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","32","Mtowen meinoy neim walba̱lab, singay imug. Tage min-pwepway ya̱kids mitanoys nitameis pwepway waseg, tallivans kid liva̱nen ven watinow. Mtowen meinoy neim walba̱lab singay imug; aveiyag wamatan nikin, o teigan waseg niligen, mo ikatimlakeids; tage babaw gamag ipiyaves anilivan. ");
INSERT INTO myw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kukin kal bo biligen anilivan, bisimounid, mamagina bo ikamtel Yowbad ansinap mounid. ");
INSERT INTO myw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mtowen Yowbad nikayeb neim, ikatimlakeids Yowbad ansinap, peinan singaya ikatpel Kululuwan isek towen. ");
INSERT INTO myw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taman Yowbad sivinan Natun, youda babaw nisiwa̱youb waseg. ");
INSERT INTO myw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kukin kal bisimounid waseg Natun, mwamovan bises bisigeg; togo tapiyavein Natun nag biban mwamovan, peinan Yowbad bikavvikun waseg. ");
INSERT INTO myw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Tasiyas Palisiy iliganes liva̱nen Yeisuw peinan ibapta̱yses gamag babaw mo imlavags navamul; o iliganes liva̱nen Yon ibapta̱yses gamag nag ibabaw; tage Yeisuw nag ibaptays, navamul gog ibapta̱yses gamags. Yeisuw ikakin ninous tasiyas Palisiy, mapuna ilisow Yoldan, inoun, vayuwein mo in Galiliy. ");
INSERT INTO myw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ked towen waseg kadiloka bikanapel Samaliy mo bein Galiliy. ");
INSERT INTO myw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Isap gog min-Samaliy wasiven yagan Saykal, walasin pwepway towen Yekob nisek natun Yosep pwa̱mug-o. ");
INSERT INTO myw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yevagam towen kweiboug Yekob ikaviyeil. Yeisuw ininoun wa̱ked ee... mo isap, bo isoumat; isin wadadan yevagam. ");
INSERT INTO myw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Navamul ineis waven bigimwals kan. Bo ya̱nay. Nen-Samaliy mo im beikil soup. Yeisuw idibek, ilana, “Soup kumey, ba̱moum.” ");
INSERT INTO myw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Vin mana̱wen mo ilana, “Adok ya̱koum gum-Yudiy ya̱koum. Aveiyag wawun kunitoug soup waseg vinen-Samaliy yey?” (Peinan min-Yudiy isisina̱les min-Samaliy.) ");
INSERT INTO myw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeisuw ikatimop anilivan, ilana, “Magat bukukwakin Yowbad nasiwa̱youb, o magat bukukwakin kavel yey anitoug yevagam waseg yak, adok mo bukunitoug waseg yey va̱gan kid basekeim soup mwamov silma̱nin.” ");
INSERT INTO myw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","12","Vin idibek, ilana, “Ta-kweitan mukwayagweg nises. Ta-ma̱wan bukukil amsoup to kadiveiyov. Avanuy bukukil mo bukusekeig soup mwamov silma̱nin? Datoveks Yekob kweiboug guyaw avakaein, nikaviyeil yevagam towen, imwamoum, alen imwamoums, nitun tibun imwamoums ee... igawa kamwamoum yakamey. Tabta ya̱koum bukumgwey tamwey towen Yekob?” ");
INSERT INTO myw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Yeisuw ilana, “Kalisiy beimoums soup towen, igaw vayuwein mo beivag asidak. Tage kukin kal beimoum soup towen yey basek, nag vayuwein beivag anadak; nag. Soup towen basek bimlavag mamagina yuwyeiwl bibwabwab wanuwan, silma̱nin mwamovan nag beikous.” ");
INSERT INTO myw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vin mana̱wen ilana, “O guyaw, soup towen kumey ba̱moum, va̱gan beikous agudak; awoum ge bamimeim bakilikil agusoup.” ");
INSERT INTO myw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeisuw ilana, “Kun kudibek mumwan, kumeis amiteiy.” ");
INSERT INTO myw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Vin mana̱wen ikatimop anilivan, ilana, “Ta-ivag gunamwan.” Yeisuw ilana, “Mounid amlivan. ‘Ta-ivag gunamwan.’ Adok mumwa̱nas asteinim; towen gog soum kusesus nag mumwan tonen, to amlivan mounid-wan.” ");
INSERT INTO myw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Vin mana̱wen ilana, “O guyaw, akakin ya̱koum palopit ya̱koum. Tammwayas bo ikululs wamatan Yowbad koy towen waseg; min-Yudiy yakamiy kulansa, ‘Kadilokeids bitakululs Yelusalem waseg.’” ");
INSERT INTO myw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeisuw ilana, “Kadiloka kusimounid agulivan towen. Igaw nag bitakulul wamatan Yowbad koy towen waseg, o Yelusalem waseg, peinan kweivaw kaleiwag bo bisap. ");
INSERT INTO myw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Yakamiy nag kukwakins aveiyag towen kukululs wamatan. Yakamey kakakin, peinan wawun katuneib nises wasigeis min-Yudiy yakamey. ");
INSERT INTO myw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Igaw kweivaw sinap bisilamaw. Mounid bo isilamaw tut towen waseg, peinan tasiyas ikululs mounid wamatan Yowbad, kululuwes waseg bikululs, sitapwa̱loul mounid. Peinan Tamads sivinan sinap towen, waseg gamag bitapwa̱louls bwein. ");
INSERT INTO myw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","“Yowbad kululuwan mav. Tasiyas gog sivines bikululs wamatan Yowbad, kadiloka kululuwes waseg bikululs, mounid-wan; awoum bikululs mav.” ");
INSERT INTO myw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Vin mana̱wen mo idibek, ilana, “Akakin igaw Mesay beim, mtowen gamag mwasanin idokes Kelis. Igaw beim, mo bikatimlakeids youda babaw.” ");
INSERT INTO myw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeisuw ilana, “Mesay yey, mtowen nukulivans soum.” ");
INSERT INTO myw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ilivan ma̱wan ikous, navamul mo iyums imeis; bo isunasun ninous peinan Yeisuw ilivans son kuda̱vin; (peinan min-Yudiy idokes nag kadilok taw bilivans son vin watapwan ven); tage nag teitan ilana, “Aveiyag sivinam?” o nag teitan ilana, “Aveiyag wawun kullivans soum mana̱wen vin?” nag. Ikika̱pays-wan. ");
INSERT INTO myw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Vin gog mana̱wen bo ilisow nakunasoup, inoun in waven, idibakes gamags; ilana, “Kumeis taneis kukines gamag teitan nidibakeig agusinap babaw kweiboug navvag. Tabta mtowen Kelis?” ");
INSERT INTO myw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iliganes, mo ilisawes ven towen, inounas kid binekes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tage navamul bo nisimkakins waseg Yeisuw va̱gan kid beikam kan to nimeyes. ");
INSERT INTO myw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Togo Yeisuw ilana, “Yey kag nises. Yakamiy nag kukwakins.” ");
INSERT INTO myw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tasiyas ilansa, “Tabta kal-tan kan isek ikam?” ");
INSERT INTO myw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeisuw ilana, “Yey kag nises. Bo bakanow Yowbad aygan, aveiyag sivinan, mo bayakous nawotet. To silma̱nin nikayabeig nam. Agusinap towen kag-wan. ");
INSERT INTO myw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","36","“Adok yakamiy kulansa, ‘Kweivas tibukon mo bitata̱yoys kan.’ Tage kukin bikiplal mitamiy mo bukukines kan bo iyebwel, peinan bo imatuw. Tatayaweins kan ikawes maysan wotet, o ita̱yoys anagin towen, gamag mwamoves nag beikous. Mapuna mo bimwa̱saws tasiyas tasapweins kan sisiyas tasiyas tatayaweins kan. ");
INSERT INTO myw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Livan towen mounid-wan, mamagina, ‘Tasapwein kan kweitan; tatayawein kan kweitan.’ ");
INSERT INTO myw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","“Yey akayabeimiy va̱gan bukuta̱yoys bag towen. Mwasanin gamag niwteles bag, yakamiy nag; misinaka kuta̱yoys-wan; tage bo niwteles nanawan.” ");
INSERT INTO myw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ven towen Samaliy gimgilis babaw mo isimounids Yeisuw waseg, peinan vin anilivan, “Nidibakeig agusinap babaw kweiboug navvag.” ");
INSERT INTO myw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","42","Min-Samaliy tasiyas mo inekes Yeisuw, ilansa, “Kum kuyeiwas wamaven, amabwabwal ya̱koum.” Itam. Siney tasiyas nisesus akweiy yam, iliganes anilivan. Iliganes, singay babaw mo isimounids waseg; idibakes vin mana̱wen, ilansa, “Kaligen amlivan, kakit kasimounid; tage tut towen yakameyan-wan nakaligen anilivan, mo kakakin mounid mtowen takatinabweids ven watinow gimgilis ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yam akweiy ikous mo ilisawes; inoun in Galiliy. ");
INSERT INTO myw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeisuw anilivan tonen mamagina, “Wanven tatonen nagamag nag biliganes palopit anilivan.” ");
INSERT INTO myw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tutan isap Galiliy mo ibwein ninous min-Galiliy, peinan bo ineis Yelusalem, sagal silma̱nin, bo ikines Yeisuw nawotet sagal towen waseg. ");
INSERT INTO myw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Vayuwein mo in Ken, wawnuwan Galiliy, kweiboug nivag yevagam to mo imlavag wayn. Gabman nises, natun ikatoun ven Kapaneyum waseg; natun kuda̱taw. ");
INSERT INTO myw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gabman towen iligen Yeisuw bo ilisow Yudiy, meinoy neim Galiliy; mapuna inek Yeisuw, ilana, “Kum, biten, natug kuda̱taw kukin, bo ikatoun avakaein. Adok kakita bikanig. Kuvag beibwein.” ");
INSERT INTO myw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeisuw ilana, “Magat bukukines wotet tawtoun, mamagina naman mulin Yowbad, mo bukusimounids. Kukin gog nag, bo nag.” ");
INSERT INTO myw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iw to Gabman, ilana, “Kum, kukin natug. Mata ge bikanig!” ");
INSERT INTO myw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeisuw ilana, “Kuyum kun. Natum bo ibwein.” Gabman mo isimounid peinan Yeisuw anilivan; iyum in silma̱nin naven. ");
INSERT INTO myw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iwloubus ininoun ee... ilivatus natouwat mwasanin; bo nikatulags nimimeis, ilansa, “Natum bo ibwein.” ");
INSERT INTO myw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gabman ikatiga̱nes, ilana, “Asina̱vin mo ibwein?” Ilansa, “Nov, ya̱nay kansow, mo iloulun won. Ankatoun bo ikous.” ");
INSERT INTO myw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taman mo inuway nov ya̱nay anatut kansow, Yeisuw nilivan, “Kuyum kun. Natun bo ibwein”; mo isimounids sen nagamag asibabaw-wan. ");
INSERT INTO myw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tut towen Yeisuw nilisow Yudiy, meinoy neim Galiliy, naman mulin kwayuwein ivag, peinan Gabman natun towen ivag mo ibwein. ");
INSERT INTO myw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kweitan tut wankuyeim, Yeisuw mo ikatulag in Yelusalem, min-Yudiy sisagal silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalem waseg, yevagam kweitan; yagan ag-Ibliw “Beteseid”, sip sikoukwed walasin. Tava̱lel bunanim wadadan yevagam. ");
INSERT INTO myw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bunsiyas bunatum takatouns immasis, ikayamats beibwab yevagam. Takatouns tasiyas ikaw mites mwasanin, takagayals mwasanin, tasiyas ipams, takatounsa babaws-wan. ");
INSERT INTO myw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO myw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kuda̱taw teitan immasis, ankatoun nises bweilim sinwatoun kweinim kweitoun. ");
INSERT INTO myw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeisuw ikin taw towen, ikakin nagwa̱diven ankatoun nises, ilana, “Tab sivinam bukubwein?” ");
INSERT INTO myw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Takatoun ilana, “O guyaw, ta-ma̱wan ba̱bwein. Igaw yevagam beibwab ta-kweitan gamag bilabeig va̱gan ba̱nuw waseg. Igaw bayokon banoun ban wayevagam, teitan gog bo imug in inuw.” ");
INSERT INTO myw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeisuw ilana, “Kutamanaw, kukow musag, kunoun.” ");
INSERT INTO myw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nuwanaw taw towen mo ibwein, ikow nasag, inoun. Yam towen Sa̱dad, min-Yudiy siSa̱bat, tapwa̱loul peinan. ");
INSERT INTO myw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Min-Yudiy ikines taw towen ikokew inasag, idibakes; ilansa, “Nagein Sa̱bat. Nag kadilok bukukow musag.” ");
INSERT INTO myw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ikatimop asilivan, ilana, “Teitan gamag niva̱geig mo a̱bwein mtowen bo idibakeig, ilana, ‘Kukow musag, kunoun.’” ");
INSERT INTO myw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ikatiga̱nes, ilansa, “Kavel taw towen nidibakeim ‘Kukow musag’?” ");
INSERT INTO myw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Togo nag bikakin, peinan Yeisuw bo inoun; gamag singay babaw ven towen. ");
INSERT INTO myw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wankuyeim Yeisuw mo iban taw towen Yowbad wanbunatum, idibek, ilana, “Ya̱koum bo kubwein amkwatoun waseg. Awoum amsinap kalbaleb kuvag vayuwein; mata kalbaleb singay avakaein mo bukulouvat geg.” ");
INSERT INTO myw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Taw towen mo inoun inekes min-Yudiy tasiyas, ilana, “Mtowen Yeisuw iva̱geig mo a̱bwein.” ");
INSERT INTO myw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mapuna ikamliwes Yeisuw, peinan wotet towen niwtel yam Sa̱bat waseg. ");
INSERT INTO myw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeisuw ikatimop asilivan, ilana, “Tamag yam babaw iwwotet ee... nagein gog igawa iwotet. Yey bo ma̱wan, awwotet-wan.” ");
INSERT INTO myw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mapun min-Yudiy singaya sivines beiweiys Yeisuw, idokes ansinap akweiya kalbaleb; kweitan igulek Sa̱bat nakaleiwag; kwayuwein gog idok Yowbad Taman tatonen, mamagina idoki ansinap bo ikadilok tatonen. ");
INSERT INTO myw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iw to Yeisuw, ilana: “Yowbad Natun yey. Aw-wotet kadilokeig bawtel gunawotet tatoneig, ne? Tamag nawotet akin iwwtel. Aveiyag Tamag ivvag, Natun yey mo avag ma̱wan. Nag kweitan tobwag wotet bawtel, nag. ");
INSERT INTO myw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamag gog isiwa̱youb waseg Natun yey, nawotet babaw-wan aveiyag ivvag, mo ikatimlakeig Natun yey. Igaw singay tawtoun wotet mo bikatimlakeig Natun yey. Yakamiy bukukines, mo beisom ninoumiy. ");
INSERT INTO myw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamag ivag takanigs mo imovs vayuwein, ma̱wan-vak Natun yey asekes simwamov, kalisiy sivinag. ");
INSERT INTO myw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Tamag nag bikatukin bikaleiwag gamag sikalbaleb o sikamnabwein wasigeis. Kaleiwag towen bo isekeig Natun yey, va̱gan kid bakaleiwag gamag babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Gamag babaw ivna̱ses Tamag, peinan Yowbad. Bo isekeig Natun yey gunakaleiwag towen va̱gan kid gamag babaw mo bivna̱seigs yey, ma̱wan ivna̱ses Tamag. Kukin kal nag ivna̱seig yey, ma̱wan-vak nag ivnas Tamag, mtowen nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mounid adibakeimiy, kal yak bukuligen aygag, o bukusimounid waseg towen nikayabeig nam, e, mwamovam bises bisigeg. Yowbad nag biyateleim, nag; peinan kanig bo kulisow, mwamovam bo kuban. ");
INSERT INTO myw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Mounid adibakeimiy, tut kadiyakus, nagein gog nises tut towen, tasiyas takanigs bo biliganes aygag, Yowbad Natun yey; e, kalisiy biliganes mo bimwamovs. ");
INSERT INTO myw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamag tonen tamwamov, ma̱wan-vak mwamovag tatoneig bo itam waseg Natun yey. ");
INSERT INTO myw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O peinan bo amlavag Gimgilitoun, bo isekeig gunakaleiwag va̱gan bamop gamag asisinap wasigeis. ");
INSERT INTO myw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","“Awoum bisunasun ninoumiy peinan agulivan towen. Igaw tasiyas wakaluwgwes nisesus, igaw biliganes aygag mo bisaps; tasiyas siwotet bwein beikits waseg mwamoves bo bisigagas; tasiyas siwotet kalbaleb beikits va̱gan kid bamop asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nag kadilokeig aveiyag tatoneig bawtel; nag. Ma̱wan baligen, ma̱wan-vak bakaleiwag; o gunakaleiwag didumwal. Peinan nag bakaleiwag nanoug tatoneig; nag. Nanon gog towen nikayabeig nam bakaleiwag. ");
INSERT INTO myw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kukin liva̱neig balivan, nag balivan mounid; nag. ");
INSERT INTO myw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Teitan gog liva̱neig nilivan; akakin geg mounid anilivan towen. ");
INSERT INTO myw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","“Nukukwayabes gamag mwasanin inekes Yon iliganes anilivan mounid, mo ikatpeles isekeimiy. Liva̱neig bo isekeimiy. Tage nag ivag sivinag gamag asilivan liva̱neig waseg billivans, nag. Livan towen bo adibakeimiy va̱gan kid Yowbad mo bikatinabweimiy. ");
INSERT INTO myw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Mtowen Yon mamagina wodam, mititeilin avakaein waseg nigidaged, o bo ivag sivinamiy kumwa̱saws tut nag biveiyov mititeilin towen waseg. ");
INSERT INTO myw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Liva̱neig Yon nilivan. Tage liva̱neig tawtoun nises waseg gunawotet, peinan gunawotet tawtoun. Wotet towen Tamag nisekeig bawtel beikous. Kukin kalisiy yakamiy bukukines gunawotet towen nawwtel mo bukukwakins Tamads nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","“Tamag tonen liva̱neig nilivan. Yakamiy gog nag kweitan tut kuliganes aygan, o nag kukines magin, nag. Aygan nag bises waninoumiy, peinan nag kusimounids waseg yey; Yowbad nikayabeig mo nam. ");
INSERT INTO myw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bukitab waseg kunineivs amisinap; kudokes kid bukuba̱nes mwamovamiy towen bises bisegeg. Nag gog; liva̱neig yey nises Bukitab waseg. ");
INSERT INTO myw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kuvinis Bukitab, tage nag sivinamiy bukumekeigs va̱gan kid mo basekeimiy mwamovamiy towen. ");
INSERT INTO myw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","“Nag ivag sivinag ven watinow gimgilis yakamiy bukuyakawaneigs, nag. Peinan akakina nag ivag misiwa̱youb waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yey nam Tamag yagan waseg, mo kupiyaveigs. Magat teitan beim yagan tonen waseg, adok bukutams gamag towen waseg. ");
INSERT INTO myw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Ta-ma̱wan bukusimounids, peinan simsimiyas kuyakawaneimiy; tage nag ivag sivinamiy Yowbad anmwa̱net biyakawaneimiy. ");
INSERT INTO myw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Awoum kudokes bayateleimiy wamatan Tamag; nag. Towen Moses kunmises bilabeimiy, togo bo biyeteleimiy. ");
INSERT INTO myw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kukin bukusimounids Moses waseg, mapuna bukusimounids waseg yey, peinan towen Moses liva̱neig yey nilel. ");
INSERT INTO myw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Peinan nag kusimounids Moses nakalelel waseg, ta-ma̱wan bukusimounids agulivan waseg.” ");
INSERT INTO myw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yeisuw anilivan towen ikous mo inoun in palata-dadan yevagam avakaein yagan Galiliy, yagan kweitan Tibeliyas. ");
INSERT INTO myw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Singay babaw gamag ikikuns, peinan bo ikines naman mulin takatouns wasigeis, iva̱ges mo ibweins. ");
INSERT INTO myw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ikatulags koy kweitan, siney navamul, mo isinis. ");
INSERT INTO myw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bo kadiyakus tutan sagal, min-Yudiy sisagal, yagan Kaltuwon. ");
INSERT INTO myw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeisuw mo itamnow matan, ikin singay gamag babaw bo nimeis, idibek Pilip, “Avanuy bitaymiyis kaeis tasiyas beikams?” ");
INSERT INTO myw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ilivan ma̱wan va̱gan biyakwen Pilip. Yeisuw bo ikakin aveiyag mo bivag. ");
INSERT INTO myw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip ilana, “Bitaymiyis kan, lakatuy kina nag kadilok kakit gamag siyas katanok katanok beikams.” ");
INSERT INTO myw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Inavamul teitan, Saymon Pita bwadan, yagan Andiluw, mo ilana, “Gwad towen nises, anbled kekel kweinim, in mwanay; na-ikadilok gamag siyas singay babaw.” ");
INSERT INTO myw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeisuw ilana, “Kunukwes gamag babaw bisinis.” Ven towen awuyow babaw nisesus, mo isinis wakunuwatan awuyow, tawaw babaw, babiweis mamagina kweinim tawsan. ");
INSERT INTO myw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeisuw ikow bled towen, ika̱lin nuwan Yowbad waseg, mo ikikivis, isisekes inavamul, ivvageins gamag babaw wasigeis, tasiyas isinis awuyow wakunuwatan. Asiyin ma̱wan, ma̱wan sivines mo isekes, ikams. ");
INSERT INTO myw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ikamuweips ikous, mo inukwes navamul, ilana, “Kusiyavis kan koubwag; awoum iyamkwen kan bises mav.” ");
INSERT INTO myw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bled kweinim, gamag tasiyas kamkwam ikamwages, mo isiyavis; idagis wanuwan kaynad, bo ika̱lawt sinwatan kadiney kaynad. ");
INSERT INTO myw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","O gamag tasiyas ikines naman mulin Yeisuw mwana nivag, mo ilansa, “Adok mounid palopit towen nitakaymates bo neim.” ");
INSERT INTO myw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeisuw ikakin gamag tasiyas sivines kid bimeis mo biyousis, binawes va̱gan bimlavag siking, mo inoun anmwa̱net-wan, ikatulag vayuwein in wa̱koy. ");
INSERT INTO myw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Kwayav waseg inavamul iwloubus ineis wakawalaw, inibwis siwag, mo ikala̱vis bineis Kapaneyum, palata-dadan yevagam. Ibwages peinan bo idadub; tage Yeisuw ta-inekes. ");
INSERT INTO myw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yag avakaein mo itow; kaysay ivag igegayous. ");
INSERT INTO myw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ikala̱vis ee... katanoka veit, mo ikines Yeisuw inoun wakunuwatan yevagam; bo isineikim, bo ivag aspwa̱yat. ");
INSERT INTO myw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iwa̱ge Yeisuw ilana, “Yey! Awoum kuweneigs!” ");
INSERT INTO myw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sivines kid Yeisuw beitouw wa̱wag. Nuwanaw mo ita̱lags wasiven. ");
INSERT INTO myw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Neiyam-nen gamag babaw igawa nisesus palata-dadan yevagam. Nov bo ikines katanoka wag wakawalaw; ta-kwayuwein nises; nag. Ikakins Yeisuw nag itouw sen navamul; siyas-wan itouws ikala̱vis. ");
INSERT INTO myw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tage Tibeliyas wugwanen mwasanin mo ilugs kadilkusana ven towen Yeisuw nivakamus tasiyas, waseg kan towen ikalin nuwan Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gamag tasiyas mo ikakins ven makaw; Yeisuw nag ises, navamul nag isesus. Mapuna itouws, ikala̱vis ineis Kapaneyum, mo inineivs Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ininineivs mo iba̱nes Yeisuw wayevagam wanpalatan towen, ilansa, “Tamwey, asina̱vin nukum?” ");
INSERT INTO myw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeisuw mo ikatimop ages, ilana, “Mounid adibakeimiy, nag kuneveigs peinan kukines namag mulin; nag. Bogo avakamumiy, kukwamuweips, to kuneveigs. ");
INSERT INTO myw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Awoum kuwwotets peinan kan towen bipsa̱pwas. Tage bweina kuwwotets peinan kan towen silma̱nin mwamovamiy nag beikous. Gimgilitoun yey basekeimiy kan towen. Tamag Yowbad bo ikatigikeig wotet towen silma̱nin.” ");
INSERT INTO myw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iliganes, mo ilansa, “Aveiyag bakavag va̱gan bakawtel Yowbad nawotet?” ");
INSERT INTO myw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iw to Yeisuw, ilana, “Yowbad nawotet mamagina bukusimounids waseg yey, peinan nikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Tasiyas ilansa, “Namam mulin aveiyag bukuvag, va̱gan bakakin mo bakasimounid. Tamumwey pwamug-o wanawoud kaeis yagan mana; liva̱nen nises Bukitab waseg, mamagina, ‘Kaeis liba̱lab avanin issekes, ikamkwams.’ Tage ya̱koum, aw-wotet bukuwtel?” ");
INSERT INTO myw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeisuw mo ilana, “Mounid adibakeimiy, Moses nag isekeimiy liba̱lab avanin; tage Tamag bisekeimiy liba̱lab avanin mounid-wan. ");
INSERT INTO myw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kan towen meinoy neim walba̱lab va̱gan Yowbad bisekeimiy mwamovamiy, ven watinow gimgilis yakamiy.” ");
INSERT INTO myw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mapuna idibakes Yeisuw, ilansa, “O guyaw, kadiloka kussekem kan towen; tuta babaw bakakamkwam.” ");
INSERT INTO myw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeisuw ilana, “Yey kan, mwamov silma̱nin; kal yak bukumekeig nag beivag amumoun; o kal yak bukusimounid waseg yey nag beivag amdak. ");
INSERT INTO myw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Kweiboug adibakeimiy, peinan nukukineigs tage nag kusimounids waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gamag tasiyas Tamag bissekeig mo bimmekeigs kid; o yey nag bapiyaves gamag tasiyas; nag. ");
INSERT INTO myw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Peinan yey bo alisow liba̱lab, a̱bus am ven watinow, silma̱nin bawotet nanon towen nikayabeig Tamag, nanoug tatoneig awoum. ");
INSERT INTO myw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","“Towen nikayabeig sivinan bisekeig gamag, o sivinan bikayus silma̱nin gungamag babaw tasiyas, nag tatanok bika̱bwag; o basekes mwamoves vayuwein, igaw nakabiyokous tut waseg. ");
INSERT INTO myw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tamag nanon bo ma̱wan. Kal yak bukukin Natun yey, o bukusimounid waseg yey, mwamovam yak mo bises bisigeg. Igaw nakabiyokous tut waseg, mo bava̱geim bukukit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Yudiy gimgilis ivtokes livan Yeisuw, peinan ilana, “Yey liba̱lab avanin, a̱bus am watinow”; ilansa, “Adok towen Yosep natun, Yeisuw. Taman, inan takakins; aveiyag silawun anilivan, ‘A̱bus am watinow’?” ");
INSERT INTO myw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","44","Yeisuw ikatimop asilivan, ilana, “Awoum simsimiyas kuvtokays livan. Misinaka takayabeig Tamag bibiteil gamag, mo bimekeig; nag teitan bimekeig mav; nag. Tasiyas bimekeigs bava̱ges mo beikits vayuwein, igaw nakabiyokous tut waseg. ");
INSERT INTO myw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Palopit teitan nilivnek, anilivan nises Bukitab waseg mamagina, ‘Yowbad mo bikatimlakes tasiyas tababaws.’ Mapuna tasiyas biliganes Tamag aygan, bimulis tasiyas, bikakins, mo bimekeigs, asibabaw-wan. ");
INSERT INTO myw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nag teitan bikin Tamag magin; nag. Misinaka yey; peinan kweiboug soug Tamag nakases. ");
INSERT INTO myw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Mounid adibakeimiy, kal towen tasimounid, mwamovan tonen nag beikous. ");
INSERT INTO myw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Yey kan mwamov silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","50","Tammwayas siyas tibudayas bo ikams kan yagan mana wanawoud; ikinka̱nigs. Tage kan towen liba̱lab avanin; bo neim watinow. Kukin kal beikam, nag bikanig; nag. ");
INSERT INTO myw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Yey liba̱lab avanin, mwamov silma̱nin; kal beikam waseg yey, mwamovan towen nag beikous. Kan towen woug tatoneig, bo basekeimiy ven watinow gimgilis silma̱nin mwamovamiy yakamiy.” ");
INSERT INTO myw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mapuna min-Yudiy mo ikamminimans sisiyas; mwasanin ilansa, “Ta-ma̱wan taw towen bisekeids won tatonen bitakams.” ");
INSERT INTO myw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iw to Yeisuw, ilana, “Mounid adibakeimiy, kukin nag bukukwams woug, Gimgilitoun yey, ta-ma̱wan bukumovs. Kukin nag bukumoums buya̱vig, nag bukumovs; nag. ");
INSERT INTO myw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kukin kal beikam woug o beimoum buya̱vig, mwamovan tonen bises bisigeg; igaw nakabiyokous tut waseg, mo bavag gamag towen bitamanaw vayuwein. ");
INSERT INTO myw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","56","Peinan woug kan tonen, buya̱vig soup tonen. Kukin kal beikam woug, o beimoum buya̱vig, soug towen bakases, o yey bases waseg gamag towen. ");
INSERT INTO myw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tamag Tamwamov nikayabeig nam; Tamag mwamovan waseg a̱mov; ma̱wan-vak kavel bikamwig mo bimwamov waseg mwamovag. ");
INSERT INTO myw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kan towen meinoy neim walba̱lab mounid yey; nag ma̱wan mana towen tammwayas ikamkwams, mo ikanigs; nag. Kukin kal bikamwig, mwamowan bises bisigeg.” ");
INSERT INTO myw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Igaw ikatimlakay ven Kapaneyum waseg, ansinap towen igeiguy wanuwan sinagog. ");
INSERT INTO myw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Navamul mwasinis ikatilutegs anilivan towen, ilansa, “Keikay sinap towen, ta-kal biligen.” ");
INSERT INTO myw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","62","Yeisuw ikakina wananon inavamul bo ivtokes livan, peinan anilivan keikay, mapuna idibakes, ilana, “Tabta igeg ninoumiy, sinap towen, ne? Magat bukukines Gimgilitoun yey ba̱yum ba̱mwen ban walba̱lab, adok singaya bisunasun ninoumiy. ");
INSERT INTO myw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","64","Yowbad Kululuwan bisekeimiy mwamovamiy; ta-ma̱wan kalivimiy bilabeimiy; nag. Livan towen nasekeimiy, kululuwamiy o mwamovamiy silma̱nin; tage mwasanin yakamiy ta-kusimounids agulivan towen.” Peinan wanmugwana Yeisuw ikakin kalisiy bisimounids waseg, o kal bisilakod waseg. ");
INSERT INTO myw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ilana, “Peinan kweiboug adibakeimiy: Misinaka Tamag beitam wasigeis gamag kalisiy bimekeigs. Nag teitan bimekeig mav.” ");
INSERT INTO myw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ilivan mamagin, navamul mwasinis mo ipiyaves, ilisawes, inounas. ");
INSERT INTO myw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeisuw mo idibakes navamul sinawatan asteiy, ilana, “Sivinamiy-tan bukuneis yakamiy?” ");
INSERT INTO myw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Iw to Saymon Pita, ilana, “O guyaw, bakalisaweim, kal mo bakanek? Ya̱koum waseg liva̱nen mwamovem bises bisigeg. Kasimounid o kakakin mounid ya̱koum Yowbad naMesay ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","71","Yeisuw mo idibakes, ilana, “Bo adaweimiy, sinwatan amiteiy; tage Seitan nises waseg tatanok gamag.” Liva̱nen towen Yudas, taman yagan Saymon Iskaliyot; mtowen waseg bod towen, igaw mo bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wankuyeim Yeisuw mo ininoun ven Galiliy waseg. Nag bininoun Yudiy waseg, peinan mwasanin Yudiy sivines kid bikatimates. ");
INSERT INTO myw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","4","Kakita bisagals min-Yudiy sisagal towen waseg niwlules tava̱lel. Budan Yeisuw mo idibakes, ilansa, “Kunoun kun Yudiy, va̱gan kid muvamul mo bikines mukwawotet. Kukin kal bisesuna wanven bisowm nawotet, nag bivakaein butun tatonen. Yak ma̱wan, kukin bukutawtoun, kadiloka gamag babaw bikines miwotet.” ");
INSERT INTO myw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Budan-vak nag isimounids waseg, mo ilivans ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeisuw ilana, “Yakamiy bukuneis yam babaw bwein-wan, tage yey nag; igaw tutag waseg mo banoun. ");
INSERT INTO myw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ta-ma̱wan ven watinow gimgilis bikamliweimiy; tage bo ikamliweigs peinan bo akamtel asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yakamiy kukwatulags kuneis sagal towen, yey bases. Igaw tutag beibwein, mo baw.” ");
INSERT INTO myw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ilivan ikous, isesuna ven to Galiliy. ");
INSERT INTO myw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yeisuw budan ikatulags ineis sagal towen. Yeisuw anmwa̱net mo inoun iva̱pana nein, peinan nag sivinan gamag babaw bikakins. ");
INSERT INTO myw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Min-Yudiy ininineivs Yeisuw sagal towen waseg, ilansa, “Avanuy misikey?” ");
INSERT INTO myw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gamag babaw ikatimwa̱lags, liva̱nen Yeisuw illivans. Mwasanin ilansa, “Taw towen kamnat.” Mwasanin gog ilansa, “Nag, peinan ikatidavidav gamag wasigeis.” ");
INSERT INTO myw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tage asilivan kweitan kweitan, nag bilivans kamnat waseg, ikagsowums, peinan iwenes min-Yudiy situwa̱veks. ");
INSERT INTO myw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Watapwan sagal Yeisuw mo isiw in Yowbad wanbunatum, ikatimlakay. ");
INSERT INTO myw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Min-Yudiy mo isunasun ninous, ilansa, “Ama̱wan nikakin ansinap towen, peinan ta-iskul avakaein.” ");
INSERT INTO myw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","17","Yeisuw ikatimop asilivan, ilana, “Ta-agusinap tatoneig, nag. Towen nikayabeig nam, ansinap tonen. Kukin sivinam bukuwtel Yowbad nanon, mo bukukwakins avanuy meinoy neim sinap towen, takinew Yowbad waseg, o takinew agusinap tatoneig. Bukuwtel Yowbad nanon mo bukukwakin. ");
INSERT INTO myw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Kavel bilivan ansinap tatonen, sivinan kid bivakaein butun tatonen. Tage kukin kal bikanow natovek aygan, o sivinan butun natovek bivakaein, towen gamag kamnat, didumwal. ");
INSERT INTO myw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Adok Moses nisekeimiy Yowbad nakaleiwag; tage nag teitan yakamiy bivnas nakaleiwag towen? Wawun sivinamiy bukuweigs?” ");
INSERT INTO myw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iweis gamag babaw, ilansa, “Takabala̱wein ya̱koum! Nag kal beiweim! Adok Baloum bo iyousim.” ");
INSERT INTO myw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeisuw ikatimop asilivan, ilana, “Nawtel gunawotet bwanabwein katanok, Sa̱bat waseg, mo igeg ninoumiy. ");
INSERT INTO myw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tage yakamiy kubwabwes a̱pwaw momwan yam Sa̱bat waseg, peinan Moses nakaleiwag ma̱wan. (Nakabsilamaw sinap towen tammwayas wasigeis, wankuyeim Moses anatut igawa ikokews sinap towen.) ");
INSERT INTO myw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Peinan kubwabwes momwes Sa̱bat waseg, va̱gan nag bukugulekwes Moses nakaleiwag, aveiyag wawun kwavikuns takatoun navag neibwein Sa̱bat waseg? ");
INSERT INTO myw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kakit kukwakins, kwaleiwags, kulansa, ‘Towen bwein; towen kalbaleb.’ Bo ibol mikaleiwag peinan nag kukwakins beibwein. Kadiloka kuneves silawun sinap va̱gan bukwaleiwags bwein.” ");
INSERT INTO myw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","27","Min-Yelusalem mwasanin iliganes anilivan, ilansa, “Adok gamag towen datuwa̱veks ininineivs mtowen, sivines kid bikatimates. Tut gog towen illivan wamnat, o nag ikatimapus aygan. Tabta mounid ikakins taw towen Mesay Kelis? Adok nag. Adok watinow gamag towen, peinan takakins avanuy meinoy neim; tage igaw Kelis beim, nag kal bikakin avanuy meinoy yay.” ");
INSERT INTO myw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Igawa ikatimlakay Yowbad wanbunatum, aygan avakaein ilana, “Mounid kukwakins yey, o kukwakins avanuy ma̱noy nam; tage teitan nikayabeig mo nam. Yey gunakaleiwag nag. Mtowen ikaleiwag, mounid ansinap kamnat; tage nag kukwakins mtowen. ");
INSERT INTO myw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yey akakin mtowen, peinan soug towen nakases, mo ikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iliganes anilivan towen, singaya igeg ninous, iyokons kid biyousis va̱gan biyateles, tage nag kadilokes peinan nag ilouvat Yeisuw inakanig tutan; igaw-wan. ");
INSERT INTO myw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Singay babaw gamag ikatilutegs, mwasanin gog isimounids waseg, ilansa, “Igaw Kelis beim, tabta nawotet bitawtoun mo bitamap waseg towen nawotet? Adok nag.” ");
INSERT INTO myw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gamag babaw liva̱nen Yeisuw ikatimwa̱lags ma̱wan; tasiyas Palisiy mo iliganes; mapuna tasiyas Palisiy sisiyas tanuwgwes lun situwa̱veks mo ikayabes siplismans va̱gan biyousis Yeisuw, ya̱tal silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","34","Yeisuw mo ilana, “Sigwey yakamiy basesun tut nag biveiyov, mo banek towen nikayabeig nam. Bukuneveigs, nag bukuba̱neigs; ta-ma̱wan bukuwekeigs; nag.” ");
INSERT INTO myw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Min-Yudiy sisiyas mo illivans, ilansa, “Avanuy sivinan bein, mo ya̱kids nag bitaba̱nes. Adok sivinan binekes sidayas min-Yudiy tasiyas misikes sisiyas kadiveiyov ven gimgilis, mo bikatimlakay tobwag ven gimgilis wasigeis. Wawun anilivan towen, ‘Bukuneveigs, nag bukuba̱neigs, ta-ma̱wan bukuwekeigs’?” ");
INSERT INTO myw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Yam towen, nakabiyokous sagal waseg, Yeisuw mo itamanaw, aygan avakaein ilana, “Kal yak amdak, kadiloka kumekeig kumoum. Kukin bukusimounid waseg yey, ya̱koum liva̱nen Bukitab nises mamagina, ‘Lay kunus bila̱tays gamag towen wanuwan, soup towen beibwab mwamov silma̱nin.’” ");
INSERT INTO myw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Anilivan towen, liva̱nen gog Yowbad Kululuwan, wasigeis tasiyas tasimounids waseg Yeisuw, peinan Yowbad mo bisek Kululuwan wasigeis tasiyas. Igaw Yeisuw bitawtoun avakaein, beiyum binek Taman, Kululuwan mo beibus bimekes gamag tasiyas tasimounids Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","42","Gamag mwasanin iliganes anilivan towen, ilansa, “Adok mounid towen palopit towen takaymates bimug Mesay waseg.” Tage gamag mwasanin ilansa, “Mtowen Mesay tatonen.” Mwasanin gog ilansa, “Mesay Kelis nag beinoy Galiliy. Adok nag. Peinan liva̱nen nises Bukitab waseg, ilana, ‘Mesay natovek Deibid’ o ‘Mesay mo beinoy Betelem,’ Deibid naven tatonen.” ");
INSERT INTO myw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mapuna gamag babaw ilivis, mwasanin ninous kweitan, mwasanin ninous kweitan. ");
INSERT INTO myw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mwasanin gog sivines biyousis Yeisuw, tage nag teitan iyous; nag. ");
INSERT INTO myw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tasiyas plismans iyum inekes tanuwgwes lun situwa̱veks sisiyas tasiyas Palisiy. Situwa̱veks mo ikatiga̱nes, ilansa, “Aveiyag wawun nag kuyousis Yeisuw?” ");
INSERT INTO myw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Iweis tasiyas plismans, ilansa, “Nag kweitan gamag anilivan ma̱wan taw towen anilivan.” ");
INSERT INTO myw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","49","Tasiyas Palisiy mo idibakes, ilansa, “Adok yakamiy-vak bo ikatidavimiy. Ta-kweitan guyaw isimounid waseg gamag towen; nag. Ta-kweitan Palisiy; nag. Tage tasiyas gamaga babaw, kaleiwag itagouwa̱wes, isiplaves kaleiwag, mapuna Yowbad bimop sikalbaleb.” ");
INSERT INTO myw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikodimos sisiy tasiyas nisesus; kweiboug nilakwen Yeisuw; mtowen mo ilana, “Tab kadilok bitasilkodes taw towen? Adok nag. Dakaleiwags nises mamagina, wanmugwana bitakatiga̱nes gamag, va̱gan kid bitakakins ansinap o nawotet ama̱wan; ikous, mo bweina bitakaleiwags.” ");
INSERT INTO myw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iweis tasiyas, ilansa, “Adok ya̱koum-vak gum-Galiliy ya̱koum! Kunev Bukitab wanuwan; ta-kweitan palopit bisap Galiliy waseg.” ");
INSERT INTO myw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ikous, gamag tatanok tatanok mo inineis wasibwan tatineis. ");
INSERT INTO myw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeisuw mo ikatulag in wa̱koy yagan Oliv. ");
INSERT INTO myw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Walalayis mo iyum in Yowbad wanbunatum; gamag babaw mo inekes, isin, ikatimlakes. ");
INSERT INTO myw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Takatimlakeins kaleiwag sisiyas Palisiy mwasanin mo imeyes na̱tan vin niba̱nes bo imasis son teitan taw; vin mana̱wen mo iseinis wanuwein. ");
INSERT INTO myw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","5","Idibakes Yeisuw, ilansa, “Tamwey, vin mana̱wen bo igeg ansinap. Na-imasis son namwan; nakaban imasis son tobwag taw. Moses nakaleiwag mamagina, kadiloka bitaweiys dakul waseg vinay kalisiy ikanavaysa mav. Ya̱koum aveiyag bukulivan?” ");
INSERT INTO myw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ilivans ma̱wan va̱gan biyakwanes Yeisuw. Magat beibol anilivan, mo biyateles. Yeisuw gog istotow, naman waseg mo ilel wapwepway. ");
INSERT INTO myw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Igawa ivvaluts asilivan, ikatiga̱nes Yeisuw, kaleiwag towen silma̱nin. Mapuna itamanaw, ilana, “Kal yakamiy ta-ivag ansinap kalbaleb, wanmugwana dakul bignilov, babaw yakamiy wankuyeim mo bukulivelovs, beimat.” ");
INSERT INTO myw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ilivan ikous, vayuwein mo istotow ilelel wapwepway. ");
INSERT INTO myw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iliganes anilivan, mo ininuways, tatanok tatanok mo inounas ineis, tamumwey imugwas, gamaga babaw wankuyeim. Ikous, asteiyun-wan nisesus son vin mana̱wen itamanaw wamatan. ");
INSERT INTO myw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeisuw mo itamnow matan, ilana, “Vin yak, avanuy tasiyas tayateleims? Tabta beiweims?” ");
INSERT INTO myw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ilana, “Nag, bo ineis, asibabaw-wan.” Yeisuw ilana, “Yey ma̱wan; nag bayateleim; nag ba̱weim. Kunoun kun. Awoum kuvgavaw amsinap towen kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Vayuwein Yeisuw mo idibakes, ilana, “Yey ven watinow gimgilis sikamnat, yey. Kal yak bukwabkunig, dadub mo beikous muked waseg, peinan bo ivanoum mukwamnat, mwamovam silma̱nin.” ");
INSERT INTO myw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tasiyas Palisiy mo idibakes Yeisuw, ilansa, “Nag kasimounid amlivan, peinan liva̱neim tatoneim.” ");
INSERT INTO myw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iw to Yeisuw, ilana, “Liva̱neig towen alivan, bo mounid-wan; peinan akakin avanuy ma̱noy nam o avanuy ban; yakamiy gog nag kukwakins avanuy ma̱noy nam o avanuy ban. ");
INSERT INTO myw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ven watinow sinapun waseg kukwaleiwags yakamiy; yey gog nag bakaleiwag wasigeis gamag mwasinis; nag. ");
INSERT INTO myw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Magat yey bakaleiwag, gunakaleiwag mounid-wan, peinan nag agmwa̱net bakaleiwag. Towen gog nikayabeig nam, Tamag, soug nakases. Mapuna makaleiwag mounid-wan. ");
INSERT INTO myw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Livan nises wamikaleiwag tatineimiy mamagina: Magat asteiy gamag asilivan bila̱tans katanok-wan, asilivan bo mounid. ");
INSERT INTO myw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Liva̱neig amateiy nakalivan, soug Tamag nikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tasiyas mo ilansa, “Avanuy Tamam?” Yeisuw gog ikatimop asilivan, ilana, “Yakamiy nag kukwakins yey, o nag kukwakins Tamag. Magat bukukwakins yey, mo bukukwakins Tamag.” ");
INSERT INTO myw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Igawa Yeisuw ikatimlakay Yowbad wanbunatum, anilivan towen nilivan money Buntuman wanuwan; tage nag kal iyous, peinan nag ilouvat tutan bikanig. Igaw-wan. ");
INSERT INTO myw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Vayuwein mo idibakes, ilana, “Bo banoun mo bukunineveigs, nag gog; bo bukumta̱mats son amisinap kalbaleb, peinan ta-ma̱wan bukuwekeigs.” ");
INSERT INTO myw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Min-Yudiy tasiyas mo illivans, ilansa, “Adok bo tonena bikatimet peinan ilana, ‘Ven towen ban, ta-ma̱wan bukuwekeigs’?” ");
INSERT INTO myw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeisuw gog idibakes, ilana, “Yakamiy watinow gimgilis yakamiy; yey gog wanakaew gimgeilin yey. Yakamiy miven towen watinow; yey gunaven kweitan. ");
INSERT INTO myw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bo adibakeimiy bukumta̱mats son amisinap kalbaleb. Kukin nag bukusimounids yey Mesay yey, mo bukumta̱mats son amisinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","Ilansa, “Kavel yak?” Yeisuw ilana, “Ma̱wan kweiboug nakatimlakeimiy. Kadilokeig livneimiy babaw balivan o bakaleiwag wasigeis yakamiy; nag gog, peinan towen nikayabeig nam ansinap towen mounid, anilivan tonen naligen, assekeimiy ven watinow gimgilis yakamiy.” ");
INSERT INTO myw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yeisuw bo ilivan liva̱nen Taman, tage tasiyas nag ikakins. ");
INSERT INTO myw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeisuw ilana, “Igaw wakamweilok bukutamnaweigs Gimgilitoun yey, mo bukukwakins yey Mesay yey, o nag alivan gunakaleiwag tatoneig. Peinan Tamag nikatimlakeig mo alivan ma̱wan anilivan tonen. ");
INSERT INTO myw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Towen nikayabeig nam; soug towen nakases. Nag bilisaweig agumwa̱net bases. Peinan tuta babaw gunawotet bo ikadilok nanon waseg.” ");
INSERT INTO myw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tasiyas ikatilutegs anilivan towen, tage mwasanina isimounids waseg. ");
INSERT INTO myw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Min-Yudiy mwasanin bo isimounids waseg Yeisuw, mo idibakes tasiyas ilana, “Kukin tut babaw bukwaninawes agulivan yey, gunavamul mounid yakamiy. E, mo bukukwakins sinap mounid, va̱gan kid bilikumiy bukuneis wamnat.” ");
INSERT INTO myw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ikatimapus aygan, ilansa, “Yakamey Ebelam delen yakamey. Nag kweitan tut nakases wa̱deil; nag. Aveiyag wawun amlivan, ‘Bilikumiy, bukuneis wamnat’?” ");
INSERT INTO myw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeisuw ilana, “Mounid adibakeimiy, kal yak mukwawotet kalbaleb, mamagina tasiwun deil ya̱koum, peinan wanuwan dadub kuses. ");
INSERT INTO myw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tasiwun deil nag ma̱wana tasiyas taginvens. Tage ven tanuwagan natun mo bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Magat Natun bitokeim tasiwun deil ya̱koum mo bukun wamnat, bo mounid bukusesuna bukusigeg. ");
INSERT INTO myw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","38","“Yey akakin Ebelam tibun yakamiy, tage sivinamiy bukuweigs, peinan aygag nag isiw ninoumiy wanuwan. Adibakeimiy sinap towen igaw soug Tamag bo nakin, tage nag kuliganes. Yakamiy gog nukuliganes tibumiy anilivan, mo kuvva̱ges ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","41","Iweis tasiyas, ilansa, “Tibum Ebelam.” Yeisuw ilana, “Magat Ebelam tibun yakamiy, mo bukuwteles Ebelam nawotet. Tage sivinamiy bukuweigs yey, nasekeimiy livan mounid to naligen Yowbad waseg. Ebelam nag bivag ma̱wan. Yakamiy kuwteles tibumiy nawotet.” Iweis tasiyas, ilansa, “Inmayas nag ikanavays mav mo ikopwemas, nag. Yakamey tibum anmwa̱net Yowbad.” ");
INSERT INTO myw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeisuw ilana, “Adok nag. Magat Yowbad tibumiy mo bukusiwyoubugs, peinan Yowbad waseg ma̱noy nam. Yey gunakaleiwag nag; mtowen nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aveiyag wawun nag kukwakins agulivan? Adok peinan nag kadilokeimiy bukuliganes agulivan towen. ");
INSERT INTO myw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Yakamiy tibumiy Seitan; sivinamiy gog bukuwteles nanon tibumiy towen. Wanmugwana tawayin gamag towen; sinap mounid bo ipiyev, peinan ta-ivag ansinap mounid. Misikena tayyaweid towen, tuta babaw anilivan yaweid. Inada tayyaweid mtowen. ");
INSERT INTO myw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Yey gog, agulivan mounid, mapuna kupiyaves. ");
INSERT INTO myw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kal yak ikadilokeim bukwavteg agusinap kalbaleb? Adok nag kavel. Kukin agulivan mounid, aveiyag wawun nag kusimounids waseg? ");
INSERT INTO myw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tage Yowbad angamag bo biligen anilivan. Yakamiy gog nag, nag bukuliganes anilivan, peinan tobwag gamag yakamiy.” ");
INSERT INTO myw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Min-Yudiy tasiyas ikatimapus aygan, ilansa, “Adok mounid amalivan, ‘Ya̱koum gum-Samaliy ya̱koum, Baloum bo iweim.’” ");
INSERT INTO myw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeisuw ilana, “Nag. Nag iweig Baloum. Bo avnas Tamag Yowbad, tage yakamiy nag kuvna̱seigs yey. ");
INSERT INTO myw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Nag ivag sivinag yakawanag bivakaein, nag. Teitan gog sivinan yakawanag bivakaein; mtowen mo bikaleiwag. ");
INSERT INTO myw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mounid adibakeimiy, kukin kal bivnas agulivan, nag bikanig, nag; bo bises bisigeg.” ");
INSERT INTO myw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Min-Yudiy tasiyas mo idibakes, ilansa, “Tut towen mounid kakakin Baloum bo iweim; peinan amlivan, ‘Kukin kal bivnas agulivan, nag bikanig, nag; bo bises bisigeg.’ Datoveks Ebelam bo ikanig. Tasiyas palopits kweiboug bo ikinka̱nigs ikous. Tabta bukulisow Ebelam, ne? Towen nikanig. Tasiyas palopits nikanigs. Kal yak kudok mugwamag nag bikanigs?” ");
INSERT INTO myw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Yeisuw ilana, “Magat bayakawaneig tatoneig, bo balivana makaw. Tage Tamag iyakawaneig, mtowen kudokes miYowbad. Tage nag kukwakins towen. Yey akakin. Kukin balivan, ‘Yey nag bakakin’ mo bamlavag tayyaweid ma̱wana yakamiy. Mounid akakin towen, akanow aygan. ");
INSERT INTO myw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Tabuds Ebelam imwa̱saw peinan iligen tutag bo bam. Mamagin ikineig, mo imwa̱saw avakaein silma̱nig.” ");
INSERT INTO myw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Min-Yudiy tasiyas mo idibakes, ilansa, “Ya̱koum ta-ivag ambweilim sinwanim, mo kulivan, ‘Bo akin Ebelam.’ Takabala̱wein yak!” ");
INSERT INTO myw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeisuw ilana, “Mounid adibakeimiy, yey bo amug; Ebelam anatut wankuyeim.” ");
INSERT INTO myw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iliganes anilivan towen, mo ikawes dakul va̱gan kid beiweiys; tage Yeisuw ivalel gamag inoun, ilisow Yowbad nabunatum. ");
INSERT INTO myw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yeisuw inoun wa̱ked, ikin taw teitan, kweiboug-o inan ikop ikaw matan, o bo ivakaein igawa ikawkwaw matan. ");
INSERT INTO myw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yeisuw inavamul ikatiga̱nes, ilansa, “Tamwey, aveiyag silawun ikaw matan? Silawun adok peinan taman, inan asisinap kalbaleb, o adok taw towen peinan ansinap kalbaleb?” ");
INSERT INTO myw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iw to Yeisuw, ilana, “Nawoum! Nag peinan taman, inan asisinap, o nag peinan ansinap towen kalbaleb mo ikaw matan, nag; tage silma̱nin Yowbad nawotet bikamat taw towen waseg, bo neikaw matan. ");
INSERT INTO myw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tut towen mamagina wudayam, kadiloka bitawteles nawotet towen nikayabeig nam; igaw beiboug, nag teitan gamag biwotet. ");
INSERT INTO myw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Igawa nases ven watinow, gamag babaw sikamnat yey. Balisaweimiy mo bidadub ma̱wana boug.” ");
INSERT INTO myw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Ilivan ma̱wan ikous mo igiw wapwepway, giwun iyik, ilasipisoup pwepway, ikatipiyek matan taw towen, mo idibek, ilana, “Kun kuwid matam yevagam yagan Silowam.” Wawun yagan towen “Ka̱yob”. Iw gog, iwid matan, iyum im, matan bo ibwein. ");
INSERT INTO myw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Taw towen naven gimgilis mo ikines, sisiyas gamag tasiyas kweiboug nikines taw towen ininitoug wa̱ked, mo ilansa, “Adok towen taninitoug, tuta babaw nissin towen.” ");
INSERT INTO myw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mwasanin ilansa, “Mtowen!” Mwasanin gog ilansa, “Nag. Tobwag. Peinan magin ma̱wan towen.” Tage taw towen ilana, “Mounid yey!” ");
INSERT INTO myw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ikatiga̱nes, ilansa, “Ama̱wan nukuvkek mo ikiplal matam?” ");
INSERT INTO myw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ilana, “Taw yagan Yeisuw igiw wapwepway, ilasipisoup, ikatipiyek matag, ilana, ‘Kun yevagam yagan Silowam, kuwid matam.’ An awid yevagam towen waseg, mo ikiplal matag.” ");
INSERT INTO myw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ilansa, “Avanuy taw towen?” Ilana, “Seik-wan.” ");
INSERT INTO myw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Gamag tasiyas mo itokes taw towen mwana neibwein matan, inawes tasiyas Palisiy wasigeis; peinan Sa̱bat waseg Yeisuw neigiw wapwepway, ikatipiyek matan, mo ikiplal. ");
INSERT INTO myw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tasiyas Palisiy mo ikatiga̱nes taw towen, ilansa, “Ama̱wan nukuvkek mo ikiplal matam?” Ilana, “Gamag teitan ikow pwepway to bo ilasipisoup, ikatipiyek matag, awid, mo akin.” ");
INSERT INTO myw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Palisiy mwasanin mo ilansa, “Towen nag Yowbad nagamag. Peinan nag ivnas yam Sa̱bat.” Mwasanin gog ilansa, “Ama̱wan takalbaleb biwtel naman mulin tawtoun, bwanabwein? Adok ta-ma̱wan.” Mapuna ilivis, peinan ninous kweitan kweitan. ");
INSERT INTO myw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Vayuwein mo ikatiga̱nes taw towen, ilansa, “Taw towen nivag matam ibwein, ansinap ama̱wan? Aveiyag bukulivan ya̱koum?” Ilana, “Mtowen palopit.” ");
INSERT INTO myw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Min-Yudiy situwa̱veks tasiyas nag isimounids towen toukwaw neibwein matan; idokes kid iyaweid. Mapuna idawes taman inan, imeis, ikatiga̱nes va̱gan bisimounids sinap towen waseg. Ikatiga̱nes, ilansa, “Tabta natun towen? Tabta ikaw matan igaw-o nukukop-yay? Ama̱wan nagein mo ikiplal matan?” ");
INSERT INTO myw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","21","Ilansa, “Mounid nitum towen; nakakop-yay-o neikaw matan; tage ama̱wan nagein mo ikiplal matan nag kakakin, o kal ivag matan ibwein nag kakakin. Kadiloka tonena bilivan, peinan bo ivakaein; bweina kwatiga̱nes.” ");
INSERT INTO myw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Taman, inan asilivan ma̱wan, peinan iwenes min-Yudiy situwa̱veks. Bogo nanawana sikaleiwag va̱gan gamag nag bilivans mtowen Mesay Yeisuw. Bilivans ma̱wan mo bikayabes bineis watoulan sinagog; awoum ge bititapwa̱louls sisiyas. Situwa̱veks sikaleiwag ma̱wan, mapuna ivag aspwa̱yat, inan taman, ilansa, “Bo ivakaeina tonen, kwatiga̱nes.” ");
INSERT INTO myw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vayuwein mo idawes taw towen mwana neibwein matan, idibakes, ilansa, “Kadiloka kulivan mounid wamatan Yowbad, peinan yakamey kakakin takalbaleb mto Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Taw towen mo ilana, “Nag bakakin ansinap, kalbaleb, o nag, ama̱wan? Misinaka akakin kweiboug neikaw matag, nagein gog akinbunik.” ");
INSERT INTO myw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iweis tasiyas, ilansa, “Taw towen ama̱wan nivkek waseg yak? Ama̱wan nivag matam nikiplal?” ");
INSERT INTO myw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ikatimop asilivan, ilana, “Bo adibakeimiy, tage nag kuliganes. Aveiyag wawun bavgavaw agulivan towen? Tabta yakamiy sivinamiy bukumlavags navamul yakamiy?” ");
INSERT INTO myw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","29","Tasiyas gog mo iyages taw towen, ilansa, “Ya̱koum navamul ya̱koum; yakamey Moses navamul yakamey. Kakakin Yowbad nilivan waseg Moses; tage taw towen nag kakakin silawun ansinap.” ");
INSERT INTO myw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","31","Iwa̱ge towen ilana, “Weinadee...! Taw towen nivag matag ibwein; tage nag kukwakins silawun ansinap. Takakinsa Yowbad nag biligen takalbalebs, iligen gog takanaweins aygan; tasiyas gog bivna̱ses Yowbad nanon, Yowbad biligen sikanitoug tasiyas. ");
INSERT INTO myw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","33","Pwa̱mug-o nag kal bivag va̱gan bikiplal matan towen nikop-yay waseg nikawkwaw matan. Magat nag Yowbad nagamag towen, ta-ma̱wan bivkek wotet silma̱nin.” ");
INSERT INTO myw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tasiyas mo ikatimapus aygan, ilansa, “Mounid kweiboug nikopweims-yay sinap kalbaleb waseg; awoum kwatimlakem yakamey.” Mo ikayabes, inoun, in watoulan. ");
INSERT INTO myw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeisuw iligen nikayabes taw towen, in watoulan tapwa̱loul. Ininineiv mo iban, idibek, ilana, “Tab kusimounid gimgilitoun Mesay waseg?” ");
INSERT INTO myw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ilana, “O guyaw, kwatimlakeig gimgilitoun towen, va̱gan basimounid waseg.” ");
INSERT INTO myw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iw to Yeisuw ilana, “Kukin mtowen, nukulivan soum.” ");
INSERT INTO myw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Taw towen mo ilana, “O guyaw, yey asimounid”; mo ikulul wamatan. ");
INSERT INTO myw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeisuw ilana, “Bo nam ven watinow silma̱nin kweitan kaleiwag; tasiyas toukwaws mo bikiplal mites, o tasiyas ikiplal mites mo bimlavags toukwaws.” ");
INSERT INTO myw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Palisiy mwasanin sisiy Yeisuw nisesus, mo iliganes anilivan towen, idibakes, ilansa, “Adok nukulivan, kulana, ‘Toukwaw yakamiy.’” ");
INSERT INTO myw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iw to Yeisuw, ilana, “Magat toukwaw yakamiy, nag beivag amisinap kalbaleb; o peinan kulansa, ‘Kakakin-wan,’ to amisinap kalbaleb isesun-wan. ");
INSERT INTO myw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","3","“Mounid adibakeimiy, kukin kavel bipiyev sip anakal awkwedan, tage inaked kweitan mo beisiw bein wanuwan, mounid tavveinaw mtowen. Tage towen beisiw wakoukwed waseg, adok mtowen tanuwagan alen sip. Takaymatein koukwed bikaliyow, alen mo bimgwayes binounas bineis. ");
INSERT INTO myw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Mansiyas babaw-wan isunaps ikous, mo imgwayes inounas. Mansiyas sip ibukunis peinan ikakins sitovek aygan. ");
INSERT INTO myw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nag bikikuns tobwag gamag waseg; nag. Peinan nag bikakins aygan; bo bisawls bineis, bilisawes.” ");
INSERT INTO myw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeisuw nakabebay towen, inganegs-wan, tage nag bikakins silawun. ");
INSERT INTO myw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Vayuwein Yeisuw mo idibakes, ilana, “Mounid adibakeimiy yey koukwed silma̱nin sip beisiws bineis wanuwan. ");
INSERT INTO myw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tasiyas tamtakavateins sip kweiboug tavveinaws tasiyas, tage sip nag iliganes ages. ");
INSERT INTO myw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Yey koukwed yey. Tasiyas beisiws waseg yey mo biba̱nes sikabmwamov; bisesus bwein; tuta babaw bimimeis, binineis, kaeis bwanabwein bikamkwams, simwamov silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Tasiyas tavveinaw imimeis va̱gan kid biveinaws, o biwaways, biyagages youd babaw. Yey gog nam mwamov silma̱nin, va̱gan kid bukumwamovsa singay. ");
INSERT INTO myw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yey tamtakavatein aleig, agusinap bwein; bo batam mwamovag ba̱mat, silma̱nin aleig bimwamovs. ");
INSERT INTO myw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Kukin kal bisa̱yin va̱gan bimtakavatay sip mo maysan wotet bikow, tage gamag towen nag bivna̱ses beibwein, nag. Towen gog tanuwagan bivna̱ses beibwein. Kukin kal bisa̱yin silma̱nin wotet towen, igaw bikin bulawud awuk avakaein bo neim, mo bisawl, bilisawes mansiyas sip, peinan nag tanuwagan tatonen; bulawud awuk mo biyousis sip mwasanin, asibabaw bikatigayays. ");
INSERT INTO myw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Towen gog bisawl bein, peinan nag tanuwagan; bweina maysan bikow wotet, tage nag binuway va̱gan bivna̱ses bwein mansiyas sip. ");
INSERT INTO myw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yey tamtakavatein aleig, agusinap bwein. Yey akakin aleig. Tasiyas ma̱wan ikakins yey. ");
INSERT INTO myw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tamag ma̱wan ikakin yey; yey-vak akakin Tamag. Bo batam mwamovag aleig pines. ");
INSERT INTO myw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aleig nisesus ven mwasanin asikal kweitan kweitan; kadiloka bameyes tasiyas, mo biliganes aygag. Wanuwan asikal katanok mo bisesus asibabaws-wan; agumwa̱neta yey mo bamtakavates. ");
INSERT INTO myw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mapuna Tamag ikalin nuwan waseg yey, peinan bo atam mwamovag, va̱gan kid vayuwein mo baban. ");
INSERT INTO myw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nag kal bikow mwamovag, nag; tatoneig bo atam. Kadilokeig mwamovag basem; kadilokeig bakow vayuwein. Peinan Tamag nakaleiwag waseg yey bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Min-Yudiy tasiyas niliganes aygan towen, mo ilivis, mwasinis ninous kweitan, mwasinis gog ninous kweitan. ");
INSERT INTO myw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mwasanin ilansa, “Baloum bo iweiy, to nikabala̱wein. Aveiyag wawun kuliganes aygan?” ");
INSERT INTO myw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mwasanin gog ilansa, “Takabala̱wein aygan nag ma̱wan anilivan towen. Tabta takabala̱wein bivag toukwaw va̱gan bikiplal matan, ne?” ");
INSERT INTO myw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tut towen bulbweilim, tutan sagal Yowbad nabunatum silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeisuw ininoun wanuwan bunkakit wanuwan Yowbad nabunatum waseg. Bunkakit bunawen idokes Solomon nakwa̱now. ");
INSERT INTO myw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tasiyas min-Yudiy situwa̱veks ikines Yeisuw ininoun, mo ikatuyouns inekes, idibakes; ilansa, “Kweivin yam bikubukub nuwem? Magat ya̱koum Kelis, kadiloka amlivan kamnat kudibakem.” ");
INSERT INTO myw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Yeisuw ikatimop asilivan, ilana, “Bo adibakeimiy, tage nag kusimounids. Gunawotet nawwtel Tamag yagan waseg bo bikatimlakeimiy kavel yey; tage yakamiy nag kusimounids, peinan yakamiy nag mamagina aleig yakamiy, magina tobwag sip yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","28","“Aleig tatoneig iliganes aygag, o yey akakin tasiyas; tasiyas-vak ibukunigs. Basekes simwamov bises bisigeg; nag aveiyag biyagages; nag. Takwekway nag bikwayes tasiyas; nag. Sigwey tasiyas bakasigeg. ");
INSERT INTO myw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Tamag bo isekeig gungamag tasiyas. Nag kal towen takwekway kadilok bikwayes Tamag waseg, peinan Tamag Tatawtoun tonen. ");
INSERT INTO myw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yey soug Tamag katanok-wan.” ");
INSERT INTO myw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vayuwein mo ikawes dakul, sivines kid beiweiys Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeisuw mo idibakes, ilana, “Tamag bo isekeig gunawotet babaw bwanabwein, va̱gan bukukines; e, bo nukukines. Aw-wotet mapun bukuweigs dakul waseg?” ");
INSERT INTO myw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iweis tasiyas, ilansa, “Awoum baka̱weim wotet bwanabwein mapun. Tage peinan kullivana mav, mamagina yak Yowbad yak, makava gamag ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeisuw ikatimop asilivan, ilana, “Adok lelel nises mikaleiwag waseg mamagina, ‘Bo alivan: yakamiy Yowbad mwasanin yakamiy.’ ");
INSERT INTO myw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Livneis tasiyas kweiboug Yowbad nisekes aygan wasigeis, mamagina yowbad mwasanin tasiyas; o ta-ma̱wan bitagidamis anilivan towen. Tage kudibakeigs, kulansa, ‘Kulivana mav,’ peinan agulivan ‘Yey Yowbad Natun yey.’ Mounid gog Tamag nikayabeig nam watinow, nawotet silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Kukin nag bawtel Tamag nawotet, bweina bukupiyaveigs. ");
INSERT INTO myw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kukin gog bukupiyaveigs, tage bawtel Tamag nawotet, kadiloka bukukines gunawotet mo bukusimounids, va̱gan kid bukukwakins Tamag waseg yey nises, o yey Tamag waseg nases.” ");
INSERT INTO myw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vayuwein mo iyokons va̱gan biyousis Yeisuw, tage bo ilisawes, inoun in. ");
INSERT INTO myw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Vayuwein mo in palata-dadan Yoldan, ven towen Yon nisilamaw nawotet kweiboug nibapta̱yses gamag; ven towen Yeisuw misik-yay. ");
INSERT INTO myw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gamag babaw ininekes, ilansa, “Yon ta-ivag naman mulin tawtoun, tage anilivan babaw, liva̱nen Yeisuw, bo mounid-wan.” ");
INSERT INTO myw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mapuna, ven towen waseg, namagleis gamag isimounids Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Takatoun teitan, gum-Betaniy yagan Lasalos; nunet asteiy Meliy son Ma̱lid wanven towen. ");
INSERT INTO myw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Takatoun towen nunet Meliy naptumin Yeisuw kaken mul waseg, o natanabwein na̱wen kunun waseg. ");
INSERT INTO myw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Vinay tasiyas mo ikayabes teitan binek Yeisuw va̱gan bidibek, ilana, “Guyaw, gamag towen kusiwa̱youb waseg, bo ikatoun.” ");
INSERT INTO myw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yeisuw iligen, mo ilivan, “Katoun towen nag silma̱nin kanig, nag; tage silma̱nin yakawanan Yowbad, va̱gan kid gamag mo bikavasis Yowbad Natun.” ");
INSERT INTO myw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeisuw nisisiwa̱youb wasigeis Ma̱lid son bwadan sisiy nusit Lasalos. ");
INSERT INTO myw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","Yeisuw niligen Lasalos ikatoun, mo isesuna ven towen akweiy yam. Wankuyeim mo idibakes navamul, ilana, “Kumeis, bitayums taneis Yudiy.” ");
INSERT INTO myw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iweis navamul, ilansa, “Tamwey, min-Yudiy bo iyokons sivines kid beiweims. Aveiyag wawun bukuyum bukun towen?” ");
INSERT INTO myw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Yeisuw ikatimop asilivan, ilana, “Katanok yam wudayam ga̱boug, ya̱nay, kwayav. Kukin kal binoun wudayam waseg, nag bikatpines kaken kid bikalouw, nag; peinan ven nakamnat immiteil; tage kukin binoun boug waseg, adok bikalouw peinan ta-ivag nakamnat.” ");
INSERT INTO myw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Livan towen ikous, mo idibakes, ilana, “Veiyouds towen Lasalos bo imasis; ban Yudiy bavgun.” ");
INSERT INTO myw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Navamul idibakes, ilansa, “Kukin bimasis, mo beibwein.” ");
INSERT INTO myw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Idokes kid imasis kangagay; tage Yeisuw anilivan, “Bo imasis,” peinan bo ikanig. ");
INSERT INTO myw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Yeisuw mo ilivan kamnat, ilana, “Lasalos bo ikanig. Nag ikanig wamatag, tage bo ibwein nanoug pinamiy yakamiy va̱gan bukusimounids waseg yey. Bo bitanekes mtowen. Magat kweiboug nakases soug towen, mo bikanig, adok nag bukusimounids beibwein.” ");
INSERT INTO myw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, towen yagan kweitan Papap, mo idibakes siney, Yeisuw navamul tasiyas, ilana, “Kumeis, taneis; bitakanigs sods datoveks.” ");
INSERT INTO myw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mtowen Lasalos bo ikanig, itakus, yam kweivas ikous, mo isap Yeisuw, iban bo itakus kweivas yam. ");
INSERT INTO myw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Peinan Betaniy kadilakus Yelusalem, mamagina katanok veit, min-Yudiy kalamwey babaw nimeis, ilakwanes Ma̱lid son Meliy, ikalin nuwes, ivva̱lams nusit peinan. ");
INSERT INTO myw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mwasanin idibakes Ma̱lid ilansa, “Yeisuw bo isap,” iligen mana̱wen mo inoun, inek; Meliy gog igaw-wan wabunatum. ");
INSERT INTO myw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Ma̱lid iwekey Yeisuw, ilana, “E Guyaw, magat ya̱koum soum nagut bukusesus, adok nag bikanig; tage tut towen akakin aveiyag bukunitoug Yowbad waseg, mo bisekeim.” ");
INSERT INTO myw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeisuw ilana, “Namut bo beikit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma̱lid ilana, “Akakin nagut beikit nakabiyokous tut waseg, peinan igaw nakabiyokous tut waseg, gamaga babaw mo bitakits vayuwein.” ");
INSERT INTO myw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Yeisuw idibek, ilana, “Yey mikabeikit yey; yey mikabmwamov yey. Kukin kal yak bukusimounid waseg yey, kukin bukukwanig, mo bukumov. Tababaw yakamiy bukusimounids waseg yey, mo bukumwamovs, kusesus kusigagas. Tabta kusimounid sinap towen, ne?” ");
INSERT INTO myw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ilana, “O, mounid. Yey asimounid peinan ya̱koum Kelis, Yowbad Natun ya̱koum, mwana nukum ven watinow.” ");
INSERT INTO myw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ilivan ikous, mo iyum inek bwadan, katimwa̱lag idibek, ilana, “Datoveks bo isap, idaweim yak.” ");
INSERT INTO myw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Iligen, nuwanaw itamanaw inoun inek Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeisuw ta-beim waven, igaw wa̱ked nises towen son Ma̱lid nilivatuy-yay. ");
INSERT INTO myw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Min-Yudiy tasiyas sisiy Meliy nivva̱lams, ikines Meliy nuwanaw itamanaw inoun, idokes kid bein wakalawag va̱gan biva̱lam kid; mapuna ibukunis Meliy. ");
INSERT INTO myw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meliy iw Yeisuw misik-yay, ikin, mo ikulul avakaein wamatan Yeisuw, ilana, “E Guyaw, magat ya̱koum soug nagut bukusesus, adok nag bikanig.” ");
INSERT INTO myw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Yeisuw ikin Meliy ivva̱lams sen min-Yudiy tasiyas nibukunis, singaya igeg nanon, ilana, “Takanig avanuy mukutakus-yay?” Ilansa, “Kum, kukin.” ");
INSERT INTO myw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeisuw mo iva̱lam. ");
INSERT INTO myw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Min-Yudiy tasiyas ikines Yeisuw iva̱lam, ilansa, “Singaya ikalin nuwan takanig waseg.” ");
INSERT INTO myw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mwasanin gog ilansa, “Towen nivag tasiyas toukwaws mo ikiplal mites, adok ikadilok bikatinob ankatoun waseg veiyon towen va̱gan nag bikanig.” ");
INSERT INTO myw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Vayuwein mo igeg nanon Yeisuw, inoun in wakalawag. Alawag gog takunumwan, dakul avakaein wawadon. ");
INSERT INTO myw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeisuw ilana, “Kuyatpinis dakul towen.” Takanig nunet yagan Ma̱lid ilana, “E Guyaw, adok awoum; peinan bo ibog; kweivas yam nimsik wakalawag.” ");
INSERT INTO myw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeisuw ilana, “Bo adibakeim, kukin bukusimounid waseg yey, mo bukukin Yowbad natawtoun.” ");
INSERT INTO myw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Ilivan ikous, iyatpinis dakul, Yeisuw mo itamnow matan, ilana, “Tamag, kalin nuwag peinan nukuligen aygag. Akakin nukunganeg aygag yam babaw; tage bo alivan ma̱wan va̱gan tasiyas nitamanaws wadadag mo bisimounids kid ya̱koum nukwayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Initoug ikous, iwak, aygan avakaein ilana, “Lasalos, kume!” ");
INSERT INTO myw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Takanig sona tibtabwan isunap, namana kaken bo iyawanis kweim waseg, o magin bo isimweilis kweim waseg. Yeisuw mo idibakes, ilana, “Kulikus won va̱gan binoun.” ");
INSERT INTO myw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Min-Yudiy tasiyas tavva̱lams sisiy Meliy bo ikines Yeisuw nawotet towen, mwasanin bo isimounids waseg. ");
INSERT INTO myw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tage mwasanin inekes tasiyas Palisiy mo ikamteles Yeisuw nawotet towen. ");
INSERT INTO myw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Tanuwgwes lun situwa̱vek sisiyas tasiyas Palisiy mo idawes takaleiwags babaw bimeis, ilansa, “Aveiyag bitava̱ges, peinan taw towen nawotet singay tawtoun? Kadiloka bitabwabwes nawotet; kukin gog nag, gamag babaw mo bisimounids waseg, mo bigeg ninous Gabman tasiyas mina-Lom; adok bimeis biyagages davanuys towen, mo biyakousis gamag ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Teitan yagan Kayapas, bweilim towen nawotet tanuwgwes lun sitovek avakaein, towen mo ilana, “Adok tatagouwaws yakamiy. Adok nag kukwakinsa bo kadilok tatanok gamag bikanig, gamag babaw pines. Awoum biyagageids bod Yudiy ya̱kids.” ");
INSERT INTO myw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nag ansinap tonen anilivan towen; tage peinan bweilim towen nawotet tanuwgwes lun sitovek avakaein, mo ilivnek Yeisuw bikanig asibod peinan. ");
INSERT INTO myw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","O nag kid bod Yudiy peinan, nag; Yeisuw gog bikanig pines Yowbad angamag vena babaw wasigeis, va̱gan kid mo bimlavags bod katanok. ");
INSERT INTO myw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yam towen, tasiyas mo isilamaws ininuways ama̱wan mo bikatimates Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yeisuw nanon ilana, “Awoum vayuwein bikineigs min-Yudiy”; mapuna inoun in walasin makava nawoud, misikes ven Epleim sen navamul. ");
INSERT INTO myw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tut kayakus min-Yudiy mo bisagals Kaltuwon silma̱nin, vena babaw gimgilis ikatulags ineis Yelusalem sagal towen silma̱nin, sivines kid bikatinagesa tatineis Yowbad nawotet towen silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tasiyas ineis Yelusalem, sivines kid bikines Yeisuw. Ititamanaws Yowbad wanbunatum, illivans mamagina, “Waninoumiy aveiyag? Towen Yeisuw beim sagal silma̱nin, ne?” ");
INSERT INTO myw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tanuwgwes lun situwa̱vek sisiyas tasiyas Palisiy bo isekes sikaleiwag, ilansa, “Kukin teitan gamag bikakin avanuy Yeisuw misik-yay, kadiloka bikatimlakem va̱gan bakayous.” ");
INSERT INTO myw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yam kweinim katanok mo bisilamaws Sagal Kaltuwon, Yeisuw inoun in Lasalos wanven Betaniy, mtowen kweiboug nikanig Yeisuw ivag mo neikit. ");
INSERT INTO myw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yeisuw inekes, mo iva̱ges kan; Ma̱lid ikokew kan silma̱nin Yeisuw sen tawaw beikams. Lasalos siney tasiyas ikamkwams. ");
INSERT INTO myw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Meliy mo ikow kwavitanok tagon yagan nad, maysan singay avakaein, iptum kaken Yeisuw, wanaman mo ikow kunun tonen vayva̱yov, itanob Yeisuw kaken. Nad towen simsiman bo ika̱lawt bunatum. ");
INSERT INTO myw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Navamul teitan Yudas Iskaliyot igaw bisilkod Yeisuw, mtowen mo ilivan, ilana, “Aveiyag wawun iyamkwen nad? Maysan towen kadiloka biyamiyis lakatutoun kina; money bitakow, bitavgen tasimavs wasigeis.” ");
INSERT INTO myw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anilivan ma̱wan, nag sivinan bilabes tasiyas tasimavs; nag. E, peinan tavveinaw towen Yudas, nawotet imtakavatay simoney Yeisuw sen navamul, ivveinaw waseg. ");
INSERT INTO myw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Yeisuw ikatimop anilivan, ilana, “Awoum kukwa̱nan waseg mana̱wen vin; nawotet towen silma̱nin gunakanig. Tasiyas tasimavs tuta babaw simiyas nukusesus, tage yey nag, igaw kakit mo balisaweimiy.” ");
INSERT INTO myw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Min-Yudiy iliganes Yeisuw nises Betaniy, singay babaw tasiyas mo imeis, sivines kid bikines, o bikines-vak Lasalos, peinan nikanig, Yeisuw ivag mo ikit. ");
INSERT INTO myw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Tanuwgwes lun situwa̱veks mo ininuways, ilansa, “Ama̱wan bitaweiys Lasalos, peinan min-Yudiy babaw Lasalos bo ikines mo ilisaweids, inekes Yeisuw, mo isimounids waseg.” ");
INSERT INTO myw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Neiyam-nen gamag babaw tasiyas nikatuyouns nimeis Yelusalem silma̱nin sagal, mo iliganes Yeisuw bo neim. ");
INSERT INTO myw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mapuna ikawes molay, inounas va̱gan kid binekes Yeisuw, iwkuwaks, ilansa, “Osana! Kalin nuwem ya̱koum, nukum Yowbad nawotet silma̱nin, min-Yisleil daguyaws ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Yeisuw iban donkiy, imwen wakunuwatan, inoun, ma̱wan Bukitab nilivnek mamagina, “Awoum beivag amipwa̱yat min-Sayon yakamiy! Kukines miking bo neim, Isin watapwan donkiy natun.” ");
INSERT INTO myw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Misumkwey towen navamul na-ikakins Bukitab nilivnek Yeisuw nawotet towen; wankuyeim gog Yeisuw iyum in walba̱lab mo inuwes livan towen, liva̱nen Yeisuw nawotet peinan bo ikamat ma̱wana nilivnek. ");
INSERT INTO myw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Gamag mwasanin nikines Yeisuw nidow takanig Lasalos igaw wakalawagan nises mo isap son mwamovan, gamag tasiyas mo ikamteles sinap towen wasigeis gamaga babaw sisiyas; mapuna inekes Yeisuw, peinan iliganes liva̱nen nawotet towen tawtoun. ");
INSERT INTO myw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tasiyas Palisiy iliganes gamag babaw ninekes Yeisuw; sisiyas mo illivans, ilansa, “Bo igak! Ama̱wan bukuvkakes? Gamag tababawsa ininekes mtowen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Min-Gilis mwasanin nimeis Yelusalem sagal towen silma̱nin, sivines kid bitapwa̱louls Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yeisuw navamul Pilip nises Yelusalem, inaven Beteseid wawnuwan Galiliy, min-Gilis tasiyas mo inekes Pilip, ilansa, “Tamwey, sivinem bakakin Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip in idibek Andiluw; Andiluw son Pilip ineis idibakes Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeisuw mo idibakes tasiyas, ilana, “Gimgilitoun yey, bo neim tutag balivet yakawanag tatoneig. ");
INSERT INTO myw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mounid adibakeimiy, kukin kaytul wit nag bein wapwepway bo bisesuna anmwa̱net; tage kukin bein wapwepway, bikanig mo beivag anagin babaw. ");
INSERT INTO myw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Kukin kal sivinan mwamovan, mo biyamkwen mwamovan tonen; tage bipiyev mwamovan ven watinow, mo biban mwamovan tonen bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Kukin kal yak sivinam bukumlavag gunavamul, kadiloka bukwabkunig; mo soug yak bitases. Tamag bo bikalin nuwan ya̱koum, gunavamul ya̱koum. ");
INSERT INTO myw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tut towen bo igeg nanoug. Tabta banitoug, balana, ‘Tamag, kwatinabweig; awoum tut towen bakanig.’ Adok nag, peinan wotet towen silma̱nin bo nam. ");
INSERT INTO myw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamag, kuvag va̱gan gamag babaw bikavasims, peinan yak Tatawtoun yak.” Walba̱lab aygan mo ikatilutegs, ilana, “Bo avag; igaw mo bavgavaw, yagag yakawanan peinan.” ");
INSERT INTO myw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gamag mwasanin nitomos idokes kid pala̱pal. Mwasanin gog ilansa, “Gum-liba̱lab nidibek Yeisuw, anelos adok.” ");
INSERT INTO myw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeisuw ikatimop asilivan, ilana, “Aygan towen nag peinag yey; tage aygan towen pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tut towen Tamag bo bimop sinap kalbaleb wadaban pwepway. Tanugwagan ven watinow towen Seitan, Tamag bo bikayeb. ");
INSERT INTO myw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Igaw bitamnaweigs wakaligweg mo babiteilis gamag babaw bimeis waseg yey.” ");
INSERT INTO myw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yeisuw anilivan towen va̱gan bikatimlakes ama̱wan bikanig. ");
INSERT INTO myw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gamag babaw ikatimapus aygan, ilansa, “Kakakin Bukitab ilivnek Mesay bo bises bisigeg; aveiyag wawun amlivan ‘Kadiloka bitamnaweigs wakaligweg, gimgilitoun yey’? Gimgilitoun yak muwotet ama̱wan?” ");
INSERT INTO myw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iw to Yeisuw, ilana, “Tut nag biveiyov kamnat bises wasigeis yakamiy. Tut towen kadiloka bukunounas; igaw bidadub, ta-ma̱wan bukukwakins ked. ");
INSERT INTO myw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Igaw nases, mikamnat bo ivanoum; kadiloka kusimounids waseg, va̱gan bukumlavags gamag kamnat yakamiy.” Yeisuw ilivan ikous, mo inoun in, itoupan va̱gan nag biba̱nes. ");
INSERT INTO myw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","38","Tasiyas nikines Yeisuw nawotet singay tawtoun; tage nag isimounids mtowen Mesay; to nikamat palopit Isaya anilivan, kweiboug nilivnek mamagina: “E, Guyaw, kal bisimounid youd to nakalivan? Kalisiy bo ikines Yowbad natawtoun?” ");
INSERT INTO myw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Mapun ta-ma̱wan bisimounids, peinan Isaya vayuwein nilivnek, ilana, “Bo ivag mites ikawkwaw, bo ivag tiges ikakon tasiyas; mata mites beikins; mata ninous bikakins; mo bikanavin ninous bimekeigs, va̱gan kid beibweins tasiyas.” ");
INSERT INTO myw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Anilivan towen Isaya nilivnek, peinan matan isisawl, ikin Mesay natawtoun, liva̱nen mo ilivan. ");
INSERT INTO myw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Min-Yudiy gog takaleiwags mwasanin isimounids waseg Yeisuw, tage nag bikamteles ninous, peinan iwenes tasiyas Palisiy, idokes bibwabwes sitapwa̱loul. Tasiyas nag ivna̱ses Yowbad, ivna̱ses gamag ninous; sivines kid gamag bikavasis, Yowbad nag. ");
INSERT INTO myw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeisuw iwak, aygan avakaein ilana, “Kukin kal bisimounid waseg yey, nag go isimounid waseg yey, tage isimounid waseg Towen nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","“Kukin gog kal bikineig, bikin-vak Towen nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","47","“Yey nam watinow silma̱nin mikamnat. Kal yak bukusimounid waseg yey, mo beikous mudadub. Kukin bukwatiligen aygag, tage nag bukuvnas aygag, yey nag bamop amsinap kalbaleb, nag. Peinan nag am watinow va̱gan bayateleimiy ven watinow gimgilis yakamiy, nag; nam gog va̱gan kid bakatinabweimiy. ");
INSERT INTO myw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Kukin bukupiyev aygag tatoneig, o bukupiyaveig yey, igaw nakabiyokous tut waseg, aygag kaka̱wen biyateleim, mo bukulivet mapun amsinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Yey nag alivan agulivan tatoneig, nag. Tamag bo ikaleiwag. Tamag gog nikayabeig, nam watinow, mo alivan, ma̱wan nakaleiwag tonen. ");
INSERT INTO myw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Yey akakin nakaleiwag towen silma̱nin mwamovamiy nag beikous. Tamag nakaleiwag waseg isekeig aygan, mo alivan ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Igaw kakit mo beikams Sagal towen Kaltuwon. Yeisuw ikakin-wan tutan bo ilivet beinoy ven watinow, beiyum binek Taman. Tuta babaw issiwyoubus angamag tonen; nakabiyokous tutan Yeisuw watinow mo bikatimlakes nasiwa̱youb singay wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sagal towen ikamkwams sen navamul. Saymon natun Yudas Iskaliyot nises. Kweiboug Seitan nanon isek Yudas va̱gan kid bisilkod Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeisuw ikakin-wan Taman bo itam youda babaw waseg. Ikakin meinoy neim Yowbad waseg, mo beiyum-vak binek Yowbad. ");
INSERT INTO myw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","5","E, Yeisuw mo itamanaw, inis anakweim mwaynavakaein, taweil isikam, mo iligob soup in wanuwan abmavin, isilamaw biwkiwik navamul kikeis, bititanob taweil towen nisikam waseg. ");
INSERT INTO myw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iwik kikeis mwasanin gamag ikous, mo inek Saymon Pita. Pita ilana, “Yak guyaw; awoum kuwik kakeig.” ");
INSERT INTO myw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeisuw ilana, “Nag kukwakin silawun gunawotet towen; igaw mo bukukwakin.” ");
INSERT INTO myw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ilana, “Nag. Nag kweitan tut bukuwik kakeig.” Yeisuw ilana, “Kukin bukupiyev, nag veiyoug yak.” ");
INSERT INTO myw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saymon Pita ilana, “Gunguyaw yak, bweina kuwik kakeig son namag o kunug.” ");
INSERT INTO myw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeisuw ikatimop aygan, ilana, “Deis. Kal yak bo kukwa̱kay ikous, misinaka bawik kakeim mo bigimagim woum meivek-wan. Yakamiy gimagim yakamiy, tage teitan yakamiy nag.” ");
INSERT INTO myw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeisuw ikakin kal bisilakod waseg, to ilana, “Teitan yakamiy nag.” ");
INSERT INTO myw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","14","Iwik kikeis ikous, ivaligev anakweim, isin wakaban, idibakes, ilana, “Tabta kukwakins gunawotet towen wasigeis yakamiy? Kudokeigs ‘Amatakatimlakay’ o ‘Maguyaw’; bwein ma̱wan, mounid-wan. Kukin yey amitakatimlakay o miguyaw yey bawik kikeimiy, kadiloka kulabes simsimiyas mamagina kuwkiwiks kikeimiy simsimiyas wasigeis. ");
INSERT INTO myw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Bo akatimlakeimiy agusinap wasigeis yakamiy; kadiloka kuva̱ges ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mounid adibakeimiy nag kal bikaleiwag naguyaw waseg, o guyaw teitan nataka̱yob awoum bikaleiwag waseg natovek; awoum. ");
INSERT INTO myw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Magat bukukwakins sinap towen o bukuwteles ma̱wan, bo bukumwa̱saws yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nag alivan livneimiy tababaws yakamiy; nag. Bweina akakin kalisiy yakamiy nadaweimiy; tage teitan bisilkodeig, Bukitab nilivnek mamagina: ‘Towen bo asek kan ikamkwam, mo ipiyaveig.’ ");
INSERT INTO myw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Bo alivnek youd towen, va̱gan igaw bikamat, mo bukusimounids waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Mounid adibakeimiy, guntaka̱yob kal igaw beiw, kal yak bukatam waseg mtowen, mogo bukutam waseg yey; e, bukutam waseg yey, mogo bukutam waseg Tamag towen nikayabeig nam.” ");
INSERT INTO myw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Anilivan towen ikous, singay igeg nanon Yeisuw; idibakes, ilana, “Mounid adibakeimiy teitan yakamiy igaw bisilkodeig!” ");
INSERT INTO myw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Navamul mites ikakins sisiyas wasigeis ikabunikays, idokes kavel. ");
INSERT INTO myw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yeisuw navamul yey, ases kadiykusan Yeisuw; peinan singay nisiwyoubug. ");
INSERT INTO myw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saymon Pita iloukwam waseg yey va̱gan bakatigan Yeisuw, balana, “Kavel towen bisilkodeim?” ");
INSERT INTO myw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mapun asineikim kadiykusan wavtakon Yeisuw, akatimwa̱lag, alana, “Tamwey, kavel towen?” ");
INSERT INTO myw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeisuw ilana, “Mtowen, basouw kan towen mo basek.” E, ikow kan kakit, isow, isek Yudas, mtowen Saymon Iskaliyot natun. ");
INSERT INTO myw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas ikam kan towen, Seitan mo isiw wananon Yudas. Yeisuw mo idibek, ilana, “Muwotet towen nuwanaw kuwtel.” ");
INSERT INTO myw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yakamey nakakamkwam nag kakakin silawun Yeisuw anilivan towen. ");
INSERT INTO myw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","O peinan Yudas tamtakavatein mamoney, mwasanin gog idokes Yeisuw nikayeb Yudas va̱gan biymiyis kan, sagal silma̱nin, o adok money mwasanin bikow bisiwa̱youb tasimavs wasigeis. ");
INSERT INTO myw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas ikam kan towen ikous; nuwanaw mo isap in watoulan. Bo iboug tonen. ");
INSERT INTO myw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas inoun, Yeisuw mo ilana, “Bo isap tutan yakawanag Gimgilitoun yey, o gamag mo biyakawanes Tamag, gunawotet silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nuwanaw gog, Tamag yakawanan mo bisekeig yakawanag yey. ");
INSERT INTO myw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Budag yakamiy, tut kadiyakus sigwey yakamiy bitasesus; igaw mo bukuneveigs; bukunineivs nag. Ma̱wan agulivan wasigeis min-Yudiy situwa̱veks, alana, ‘Banoun ban; ta-ma̱wan bukuwekeigs.’ E, nagein mo adibakeimiy ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Gunakaleiwag kweivaw asekeimiy, kadiloka bukusiwyoubus simsimiyas. Ma̱wan nasiwyoubumiy, kadiloka ma̱wan bukusiwyoubus simsimiyas. ");
INSERT INTO myw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bukuva̱ges ma̱wan, gamag babaw mo bikakins gunavamul yakamiy, peinan misiwa̱youb simsimiyas wasigeis.” ");
INSERT INTO myw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saymon Pita idibek Yeisuw, ilana, “Tamwey, ama-bukun?” Yeisuw ilana, “Tut towen banoun ban; ta-ma̱wan bukwabkunigs. Igaw tut wanakougwaw mo bukwabkunigs yey.” ");
INSERT INTO myw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ilana, “Tamwey, aveiyag wawun nagein na-ikadilokeig babkunim? Bo bakanig peinam yak.” ");
INSERT INTO myw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iw to Yeisuw, ilana, “Tabta bukukwanig peinan yey, ne? Mounid adibakeim, siva̱toun bukwaya̱neig, igaw ga̱boug waseg kolkolek mo beigel.” ");
INSERT INTO myw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeisuw ilana, “Awoum bikubukub nuwamiy yakamiy. Kusimounids waseg Yowbad; kadilok-vak bukusimounids waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","“Tamag wanven bunatum babaw nisesus. Kukin gog nag, tabta badibakeimiy, ‘Ban bakatineg miven pinamiy yakamiy’? Tage peinan agulivan ma̱wan, bo mounid. ");
INSERT INTO myw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Ban bakatineg miven, igaw mo baw va̱gan kid bakaweimiy banaweimiy wagunaven, sigwey yakamiy mo bitasesus. ");
INSERT INTO myw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kukwakins ked towen ba̱noy.” ");
INSERT INTO myw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas mo idibek Yeisuw, ilana, “Tamwey, nag bakakakin ama-bukun. Ta-ma̱wan bakakakin ked.” ");
INSERT INTO myw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeisuw ilana, “Yey miked yey; yey mikamounid yey; yey mikabmwamov yey. Kukin kal sivinan binek Tamag, bweina beim waseg yey mo binek Tamag; ta-kweitan ked nises. ");
INSERT INTO myw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Magat bukukwakin yey, mo bukukwakin Tamag. Nagein gog kukwakins towen, peinan nukukines.” ");
INSERT INTO myw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ilana, “Tamwey, kwatimlakem Tamam mo beitout ninom.” ");
INSERT INTO myw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iw to Yeisuw, ilana, “O Pilip, kadiveiyov tut sigwey yakamiy nitasesus, aveiyag wawun nag kukwakin yey? Kal yak kukineig yey, kukin-vak Tamag. Aveiyag wawun kulansa, ‘Kwatimlakem Tamam’? ");
INSERT INTO myw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tabta kusimounids yey Tamag waseg nases, o Tamag waseg yey nises? Livan towen nasekeimiy, nag agulivan tatoneig; Tamag anilivan; Tamag gog waseg yey nises, iwotet. ");
INSERT INTO myw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Bweina bukusimounids yey waseg Tamag nases, o kusimounids-vak Tamag waseg yey nises. Kukin gog nag, kadiloka kusimounids peinan kukines gunakawotet. ");
INSERT INTO myw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mounid adibakeimiy, kukin kal yak bukusimounid waseg yey, gunakawotet towen mo bukuwtel tawtoun waseg, son mukwawotet singaya tawtoun, peinan bo banek Tamag. ");
INSERT INTO myw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Aveiyag bukunitougs yagag waseg mo bawtel, va̱gan kid gamag babaw mo biyakawanes Tamag. ");
INSERT INTO myw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kukin bukuntougigs yagag waseg, mo bawtel ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kukin bukusiwyoubugs, kadiloka bukuvna̱ses gunakaleiwag. ");
INSERT INTO myw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Yey mo banitoug Tamag waseg va̱gan bisekeimiy Teitan bilabeimiy, mo bises bisigeg. ");
INSERT INTO myw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kululuwan Mounid Towen, ansinap kamnat. Tamag nag bisekes Kululuwan Towen wasigeis gamag babaw; nag. Peinan tasiyas nag kadilok bikines o bikakins Kululuwan Towen. Yakamiy gog kukwakins, peinan wasigeis yakamiy Kululuwan Towen nukusesus simiy. ");
INSERT INTO myw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nag makaw bukusesus yakamiy, peinan yey bo baw. ");
INSERT INTO myw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Igaw kakit mo balakanig wasigeis ven watinow gimgilis, tage yakamiy bukukineigs yey. Yey ba̱mov mapuna yakamiy bukumovs. ");
INSERT INTO myw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“Igaw, yam towen waseg, mo bukukwakins yey Tamag waseg nases, o yakamiy waseg yey, o yey wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Kal yak bukuligen gunakaleiwag, o bukuvnas, mounid yak bukusiwyoubug. Kal yak bukusiwyoubug, Tamag mo bisiwyoubum yak; o yey mo basiwyoubum, tatoneiga bakamat waseg ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas Iskaliyot valeyin yagan Yudas; mtowen idibek Yeisuw, ilana, “Tamwey, aveiyag wawun bukukwamat wasigeis yakamey, tage gamag babaw nag?” ");
INSERT INTO myw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iw to Yeisuw, ilana, “Kal yak bukusiwyoubug mo bukuvnas aygag; mapuna Tamag mo bisiwyoubum yak, soug Tamag bakawekeim yak mo bitasesus simey ya̱koum. ");
INSERT INTO myw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kal yak bukupiyaveig mo bukupiyev aygag, Tamag aygan gog, nikatipel nisekeig agulivan, nikayabeig va̱gan kid basekeimiy aygan towen. ");
INSERT INTO myw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Agulivan towen nasekeimiy, igaw sigwey yakamiy nitasesus. ");
INSERT INTO myw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Igaw Teitan biwekeimiy bilabeimiy, mtowen Kululuwan Yowbad. Tamag bo bikayeb Kululuwan, gunakaleiwag waseg, biwekeimiy; Kululuwan Towen mo bikatimlakeimiy youda babaw wasigeis; e, bilabeimiy va̱gan nag bukunumlaves agulivan babaw. ");
INSERT INTO myw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Balisaweimiy, tage bweina beitaw nuwamiy; sinap bwein nasekeimiy va̱gan beitaw nuwamiy. Ven watinow sinapun nag bilabeimiy ma̱wan agusinap, nag. Awoum bikubukub nuwamiy; awoum beivag amipwa̱yat. ");
INSERT INTO myw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nukuliganes agulivan mamagina: ‘Banoun ban, ba̱yum-vak baw.’ Magat bukusiwyoubugs bo bukumwa̱saws peinan yey banek Tamag, tage mtowen Tamag Tatawtoun singay. ");
INSERT INTO myw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Nagein gog bo alivnek. Igaw bikamat mamagina, mo bukusimounids waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Igaw nag balivan avakaein wasigeis yakamiy. Peinan bo neim takalwagein asisinap ven watinow gimgilis; tage ta-ma̱wan bivkek waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","“Yey awotet ma̱wan Tamag nikaliwageig, va̱gan kid gamaga babaw mo bikakins gunsiwa̱youb waseg Tamag. “Kutamanaws bo bitanounas.” ");
INSERT INTO myw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kweitan livan Yeisuw nisekes ma̱wan: “Yey mamagina kay mounid; Tamag mamagina tawtelein bag. ");
INSERT INTO myw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kukin yayageig nag beivag anagin, Tamag mo bilav yayag towen bilev. Kukin gog beivag anagin, mo bibob matan va̱gan anagin bibabaw. ");
INSERT INTO myw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Bo nasekeimiy agulivan, mapuna ivag amisinap kamnat. ");
INSERT INTO myw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Makava yayagein, kukin wawun nag, ta-ma̱wan beivag anagin. Kadiloka bisesus son wawun kay mo beivag anagin. O yakamiy ma̱wan. Kadiloka bitasesus simiy yey, o yey sigwey yakamiy, mo beivag angimiy; kukin bukusesusa makaw, bo nag. ");
INSERT INTO myw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yey kay yey. Yakamiy yayageig yakamiy. Kal yak soug yey bitases, o yey soum yak, igaw beivag anagim bibabaw; tage ammwa̱net nag aveiyag bukuwtel. ");
INSERT INTO myw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Kukin kal bipiyaveig, mtowen mamagina yayageig ilaves in watoulan, bo biya̱lay, beimat. Igaw gamag mo bikawes, bigabus wa̱kov. ");
INSERT INTO myw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kukin sigwey bitasesus, o gunakaleiwag simiy bukusesus, aveiyag sivinamiy, bweina bukunitougs silma̱nin, mo bukuba̱nes youd towen. ");
INSERT INTO myw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Magat gunavamul mounid yakamiy, mo bukuva̱ges angimiy bibabaw; mapuna gamag babaw mo bikavasis Tamag. ");
INSERT INTO myw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamag ikalpwa̱kit waseg yey, ma̱wan yey, akalpwa̱kit wasigeis yakamiy. Kadiloka kusesus son agusinap siwa̱youb. ");
INSERT INTO myw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kukin bukuvna̱ses gunakaleiwag mo bukusesus son agusinap siwa̱youb. Ma̱wan yey, avnas Tamag nakaleiwag to nasesuna son towen ansinap siwa̱youb. ");
INSERT INTO myw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Bo asekeimiy agulivan towen, va̱gan kid gunakabmwa̱saw waseg bukusesus, o singay bivakaein mwa̱saw wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gunakaleiwag towen: Kadiloka bukusiwyoubus simsimiyas. Peinan yey nasiwyoubumiy, kadiloka bukusiwyoubus simsimiyas bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kukin kal singaya bisiwyoubus nubein, mo bitam mwamovan, bikanig pines tasiyas. ");
INSERT INTO myw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Magat bukwanawes aygag mo bukwanubeins waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kweiboug bo adokeimiy guntouwat yakamiy; tut gog towen nadokeimiy nubeig yakamiy. Kalisiy tasiyas tamwey natouwats nag bikakins tamwey nanon; tage yey bo aligen mo akakin Tamag nanon, bo nakatipel nasekeimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nag kuvkakeigs mitovek yey; tage yey bo avkakeimiy nubeig yakamiy; bo akaleiwag va̱gan bukukwanawes aygag va̱gan kid angimiy bwanabwein bises bisigeg. Igaw aveiyag bukunitougs waseg Tamag, yagag yey waseg, Tamag mo bisekeimiy youd towen. ");
INSERT INTO myw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Gunakaleiwag towen: Kadiloka bukusiwyoubus simsimiyas. ");
INSERT INTO myw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Magat ven watinow gimgilis bikamliweimiy, kadiloka bukunuways wanmugwana yey nikamliweigs. ");
INSERT INTO myw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Magat amisinap ma̱wana asisinap tasiyas, mo bisiwyoubumiy. Tage yakamiy amisinap kweitan. Bo nadaweimiy mo nukulisawes ven watinow asisinap, mapuna ven watinow gimgilis ikamliweimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Kadiloka bukunuwes agulivan nadibakeimiy mamagina, ‘Natouwat nag bimug waseg natovek; nag.’ Kukin bikamliweigs, mogo bikamliweimiy. Kukin bivna̱ses aygag, mogo bivna̱ses agamiy. ");
INSERT INTO myw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ven watinow gimgilis biyagageimiy, peinan agugwamag yakamiy, o peinan nag ikakins Towen nikayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Magat basina̱les, o magat nag basekes aygag, mogo nag badok asisinap kalbaleb. Tage bo anekes, asekes aygag, igaw Yowbad mo bikamta̱nis peinan asisinap kalbaleb, ta-ma̱wan bikatimapus aygan; nag. ");
INSERT INTO myw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kukin kal bikamliweig, mamagina bikamliw-vak Tamag. ");
INSERT INTO myw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","“Magat nag bikines gunawotet tawtoun, nag badok asisinap kalbaleb. Tage gunawotet singay tawtoun. Nag teitan nawotet tawtoun ma̱wana gunawotet tatoneig. Tage nikines gunawotet, mogo nikamliwemas soug Tamag. ");
INSERT INTO myw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bo ikamliweigs va̱gan bikamat liva̱neig nises Bukitab kaleiwag waseg; nilivnek mamagina: ‘Bo ikamliweigs mav; silawun nag.’ ");
INSERT INTO myw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","“Igaw bakayeb Teitan beiw bilabeimiy. Kululuwan Towen ansinap mounid, bo beinoy Tamag waseg biwekeimiy; liva̱neig mo bisekeimiy. O yakamiy gog liva̱neig bukusekes gamag babaw wasigeis, peinan sigwey yakamiy nitasesus nakabsilamaw gunawotet waseg ee... sigwey yakamiy tut towen. ");
INSERT INTO myw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","2","“Livan towen bo adibakeimiy va̱gan awoum bukupiyaveigs; igaw tasiyas bibwabwes mitapwa̱loul, sinagog waseg; o igaw kweitan tut wanakoug gamag mwasanin beiweimiy bukumta̱mats, o igaw biyagageimiy mo bidokes Yowbad bikalin nuwan tasiyas. ");
INSERT INTO myw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","“Siwotet towen biwteles, peinan nag bikakins Tamag, o nag bikakins yey. ");
INSERT INTO myw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bo adibakeimiy sinap towen; igaw youd towen bikamat mo bukunuwes agulivan nadibakeimiy. “Wanmugwana nag adibakeimiy sinap towen, peinan igaw sigwey yakamiy nitasesus. ");
INSERT INTO myw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tut gog towen bo banek Towen nikayabeig nam, tage nag kal yakamiy ikatiga̱neig ilana, ‘Ama-bukun?’ ");
INSERT INTO myw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Peinan nadibakeimiy sinap towen, mo igeg amnamiy. ");
INSERT INTO myw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","8","“Mounid gog adibakeimiy, bweina balisaweimiy. Kukin nag balisaweimiy, nag bakayeb Teitan bilabeimiy; tage bo ban, mogo Towen beiw, mo bikatimlakeimiy ven towen gimgilis babaw yakamiy, va̱gan kid bukukwakins sinap kalbaleb, sinap bwein, o sinap kalbaleb mapun. ");
INSERT INTO myw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Mtowen bikatiboug nuwes kalisiy nag bisimounids waseg yey, mo bikakins asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Bikatimlakeimiy agusinap bwein peinan bo ba̱mwen banek Tamag, o igaw nag bukukineigs. ");
INSERT INTO myw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“E, bikatimlakeimiy sinap kalbaleb mapun, peinan Tamag bo imop ansinap kalbaleb towen tanuwagan ven watinow. ");
INSERT INTO myw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Sinap babaw nisesus, igaw mo badibakeimiy, nagein gog ninoumiy igaw moumouvit. ");
INSERT INTO myw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Igaw beim Yowbad Kululuwan Mounid, mo bimgwayeimiy sinap babaw mounid waseg. Nanon tatonen nag bilivan, nag. Aveiyag biligen, mo bilivan ma̱wan; o bilivnek sinap wanakougwaw silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Mtowen bikow agusinap mo bikatimlakeimiy, va̱gan beivag yakawanag tatoneig. ");
INSERT INTO myw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tamag navavag mamagina yey gunavavag, to nalivan, alana, ‘Mtowen bikow agusinap mo bikatimlakeimiy.’ ");
INSERT INTO myw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Igaw kakit mo balisaweimiy; tut kakit wankuyeim mo bukukineigs vayuwein.” ");
INSERT INTO myw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Navamul mwasanin sisiyas mo illivans, ilansa, “Aveiyag anilivan towen, ‘Igaw kakit mo balisaweimiy,’ o ‘Tut kakit wankuyeim mo bukukineigs vayuwein,’ o ‘Bo banek Tamag.’” ");
INSERT INTO myw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ilansa, “Aveiyag wawun anilivan, ilana, ‘Igaw kakit’; tage nag takakins silawun.” ");
INSERT INTO myw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeisuw gog ikakin aw-youd sivines bikatugwans waseg, to ilana, “Adok kuneves silawun agulivan towen, ‘Igaw kakit mo balisaweimiy’ o ‘Tut kakit wankuyeim mo bukukineigs vayuwein.’ ");
INSERT INTO myw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mounid adibakeimiy, bigeg ninoumiy, bukuva̱lams; tage gamag babaw bo bimwa̱saws. Mimouvit igaw mo bukwatilawos mwa̱saw. ");
INSERT INTO myw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mamagina vin, tutan bitup, namouvit ivag; tage bitapouy naman, mo beikous namouvit, mo bimwa̱saw, peinan kweivaw gamag bo ikamat. ");
INSERT INTO myw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Yakamiy ma̱wan, tut towen mimouvit nises; igaw gog mo bawekeimiy, mo bukumwa̱saws bukusigagas. Ta-kal biyageg mimwa̱saw towen; nag. ");
INSERT INTO myw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Igaw yam towen waseg, nag bukunitougs waseg yey. Mounid adibakeimiy, igaw bukuntougis Tamag, yagag yey waseg, Tamag mo bisekeimiy. ");
INSERT INTO myw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tut kweiboug nag kweitan youd kuntougis Tamag, yagag yey waseg; nag. Kadiloka bukunitougs va̱gan bukukwawes, mo bivakaein mimwa̱saw yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gunakabebay waseg bo adibakeimiy. Igaw kweitan tut beim, mo beikous kabebay; kamnat gog mo basekeimiy liva̱nen Tamag. ");
INSERT INTO myw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Tut towen bukuntougis Tamag yagag yey waseg. Nag balivan, balana, ‘Banitoug Tamag waseg, pinamiy yakamiy’; nag. Tamag tonena nisiwyoubumiy, peinan nukusiwyoubugs yey, o nukusimounids ma̱noy nam Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","“Ma̱noy nam Tamag waseg, nam ven watinow; igaw mo balisow ven towen watinow, ba̱yum gog banek Tamag.” ");
INSERT INTO myw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","30","Navamul mo ilansa, “Tut gog towen amlivan kamnat. Mukwabebay bo ikous. Kakakin-wan ya̱koum kukwakin youd babaw; nag kadilok teitan bikatiga̱neim; mapuna kasimounid mukunoy Yowbad waseg nukum.” ");
INSERT INTO myw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iwa̱ge Yeisuw, ilana, “Tabta mounid bukukwakins, ne? ");
INSERT INTO myw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Igaw kweitan tut beim, adok tut towen bo isilamaw, bikatigayeimiy bukuneis wamiven tatineimiy, bukulisaweigs, agumwa̱net yey bases; tage amateiy soug Tamag bakases. ");
INSERT INTO myw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Sinap towen bo asekeimiy va̱gan bukusimounids waseg yey mo beitaw nuwamiy. Ven watinow mimouvit bukulivatus, tage awoum bigeg ninoumiy, peinan bo atawtoun ven watinow sinapun waseg.” ");
INSERT INTO myw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeisuw anilivan towen ikous, mo itamnow matan, ikin liba̱lab, ilana, “Tamag, tutag bo neim. Kusekeig yakawanag, mo bavag gamag babaw biyakawaneims yak. ");
INSERT INTO myw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","“Bo nukutam agugwamag babaw va̱gan bayamoves mo bisigagas; o bo nukusekeig gunakaleiwag gamag babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Kalisiy bikakinsa ya̱koum mounid Yowbad ya̱koum, o nukukwayabeig Mesay Yeisuw yey, mo nam, tasiyas kalisiy bikakins ma̱wan mo beimovs bisigagas. ");
INSERT INTO myw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","5","“Gunawotet towen nukusekeig bo ayakous, va̱gan ven watinow gimgilis mo biyakawaneims. Tut gog towen kusekeig yakawanag tatoneig walba̱lab wamatam. Ma̱wan nitases nakabsilamaw tut waseg; e, vayuwein kusekeig yakawanag towen. ");
INSERT INTO myw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ven watinow gimgilis tasiyas nukusekeig, bo akatimlakes amsinap ya̱koum. Amgwamag tasiyas nukusekeig agugwamag, o bo ikanawes aygam ya̱koum. ");
INSERT INTO myw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nagein gog bo ikakinsa gunavavag tasiyas nukusekeig meinoy nimeis waseg ya̱koum. ");
INSERT INTO myw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","“Livan towen nukusekeig, bo akatipel asekes tasiyas, mo itams waseg. E, ikakins-wan ma̱noy nam waseg yak, o isimounids nukwayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nag banitoug ven watinow gimgilis pines; nag. Misinaka banitoug pines tasiyas nukusekeig, peinan amgwamag tasiyas. ");
INSERT INTO myw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Agugwamag babaw mamagina amgwamag ya̱koum; o amgwamag mamagina agugwamag yey, o yakawanag peinan. ");
INSERT INTO myw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Tut towen balisow ven watinow, mo baw; tasiyas gog bisesus ven watinow. O Yowbad, kadiloka yagam waseg bukuvna̱ses gamag tasiyas nukusekeig. E, kuvna̱ses tasiyas va̱gan beivag ninous katanok-wan, ma̱wan nanoud ya̱kid katanok-wan. ");
INSERT INTO myw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Tutag watinow waseg, sigwey tasiyas bo amtakavates gamag tasiyas nukusekeig; yagam waseg nisesus bwein. Nag kal iyamkwaneig. Misinaka towen Bukitab nilivnek peinan bo bigeg; e, mtowen anmwa̱net iyamkwaneig. ");
INSERT INTO myw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Tut towen bo baw. Ven watinow waseg nasekes livan towen va̱gan bimwa̱saws avakaein, yey gunamwa̱saw avakaein waseg. ");
INSERT INTO myw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Bo asekes amlivan, ven watinow gimgilis mo ikamliwes tasiyas, peinan idokes tobwag gamag tasiyas; o yey ma̱wan, idokeigs tobwag gamag yey. ");
INSERT INTO myw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Awoum bantougim bukutokes va̱gan bilisawes ven watinow; nag. Misinaka kumtakavates, mata beivag asisinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nag ven watinow gimgilis tasiyas; ma̱wan yey, yey nag gimgeilin ven watinow. ");
INSERT INTO myw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kuva̱ges amgwamag bikamnat, amlivan mounid waseg. ");
INSERT INTO myw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Peinan nukwayabeig nam silma̱nin ven watinow, ma̱wan yey akayabes tasiyas bineis silma̱nin ven watinow gimgilis. ");
INSERT INTO myw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yey akatkileig va̱gan balabes tasiyas, va̱gan kid tasiyas bisesus bwein, asisinap mounid waseg. ");
INSERT INTO myw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Antougim pines tasiyas, sisiyas tasiyas babaw biliganes asilivan mo bisimounids waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","“Tama, anitoug va̱gan tasiyas babaw beivag ninous katanok-wan; ma̱wan yak waseg yey, o yey waseg yak, nanoud katanok-wan; o sivinag sidayas tasiyas beivag nanouds katanok-wan; ven watinow gimgilis mo bikakins nukwayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Sinap kamnat nukusekeig, bo akatipel asekes tasiyas, va̱gan beivag ninous katanok, ma̱wan ya̱kid aditeiy. ");
INSERT INTO myw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","“Yey sigwey tasiyas bakases, o ya̱koum soug yey; nakabiyokous waseg katanoka bod ya̱kids babaw; ven watinow gimgilis mo bikakins nukwayabeig nam, o bikakins kukwalpwa̱kit wasigeis tasiyas, ma̱wana waseg yey. ");
INSERT INTO myw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Tama, sivinag tasiyas biwekeigs wadavanuys. Nakabsilamaw tut waseg nukusiwyoubug gunakamnat waseg. Sivinag tasiyas bikines gunakamnat wadavanuys waseg. ");
INSERT INTO myw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ven watinow gimgilis na-ikakins yak, tadidumwal yak, tage yey akakina yak, o amgwamag tasiyas ikakinsa nukwayabeig nam. ");
INSERT INTO myw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","“Bo akatimlakes yagam o amsinap; igaw-vak mo bakatimlakes amsinap tatoneim, va̱gan kid siwa̱youb towen nukusiwyoubug mo binekes tasiyas, o yey-vak basesuna wasigeis tasiyas.” ");
INSERT INTO myw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Anilivan towen ikous, Yeisuw mo inounas sen navamuls, iwloubus, ikanapels lay Kidlon, ikatulags, ineis bigulen oliv, isinis. ");
INSERT INTO myw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, towen tasilkodein Yeisuw, ikakina Yeisuw sen navamul inineis ven towen. ");
INSERT INTO myw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mapuna Yudas mo imgwayes takannaviys sisiyas tanuwgwes lun situwa̱veks siplismans mwasanin, o Palisiy siplismans mwasanin; ikokews wodama, lampa, son naviy youdanen, inounas, ineis bag towen. ");
INSERT INTO myw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeisuw ikakin youd babaw igaw bilivet, iwa̱ge ilana, “Kal kunineves?” ");
INSERT INTO myw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ilansa, “Gum-Nasalet yagan Yeisuw.” Yeisuw ilana, “Yey.” Yudas gog siney tasiyas nitomos, mtowen tasilkodein Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","E, iliganes Yeisuw anilivan, ilana, “Yey,” mo isineikiks, ikalka̱louws, immasis wapwepway. ");
INSERT INTO myw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ikous, itamanaws, vayuwein Yeisuw mo ikatiga̱nes, ilana, “Kal kunineves?” Ilansa, “Gum-Nasalet yagan Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iwa̱ge Yeisuw, ilana, “Bo adibakeimiy mtowen yey. Bukuyousigs yey, tabta bukuta̱mes tasiyas bineis wasiven; awoum kuyousis tasiyas.” ");
INSERT INTO myw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yeisuw anilivan ma̱wan va̱gan bikamat livan towen Bukitab nilivnek mamagina: “Gamag tasiyas nukusekeig nag teitan iyamkwaneig, nag.” ");
INSERT INTO myw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saymon Pita mo ikow napulut tanmunum, iweiy tanuwgwes-lun sitovek natouwat teitan, yagan Malkos, ibob teigan wanaka̱tay. ");
INSERT INTO myw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeisuw idibek Pita, ilana, “Kusem mupulut wakaban. Kadiloka ba̱moum kwa̱vig yayan Tamag nisekeig.” ");
INSERT INTO myw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Takannaviy babaw sisiy sitovek, sisiyas min-Yudiy siplismans, mo iyousis Yeisuw, iyawanis naman. ");
INSERT INTO myw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","E, itokes Yeisuw inawes wanamug Anas wanbunatum, tamwey towen Kayapas yawan; bweilim towen Kayapas tanuwgwes lun sitovek avakaein. ");
INSERT INTO myw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mtowen Kayapas nidibakes min-Yudiy sitakaleiwag mamagina, “Kadiloka tatanok gamag bikanig peinads ya̱kids, bod Yudiy ya̱kids.” (Kukines Yon 11:50) ");
INSERT INTO myw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Saymon Pita mo ikabwa̱kuns Yeisuw waseg, son navamul teitan; mtowen veiyon tanuwgwes lun sitovek, mapuna isiws wanbunatum sen gamag tasiyas nitokes Yeisuw. Tage Pita itamanaw iton wamatan bunatum. Mtowen veiyon tanuwgwes lun sitovek avakaein mo inek vin mana̱wen ikayamat wakoukwed, ilivans son, mo ikaliyow koukwed va̱gan Pita beisiw beim. ");
INSERT INTO myw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vin mana̱wen mo idibek Pita, ilana, “Adok ya̱koum Yeisuw navamul teitan, ne?” Pita ilana, “Nag.” ");
INSERT INTO myw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Asiloulun; tasiyas tanuwgwes lun sitouwats sisiyas plismans mwasanin mo ivlakes kov, itamanaws ikammunuws kov walasin. Pita siney tasiyas ikammunuws. ");
INSERT INTO myw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tanuwgwes lun sitovek avakaein mo ikatigan Yeisuw, ilana, “Kalisiy muvamul? O aw-sinap waseg nukumulis tasiyas?” ");
INSERT INTO myw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeisuw ilana, “Agusinap bo alivan kamnat, gamag babaw wasigeis, Yowbad wanbunatum o sinagog wasigeis. Sitapwa̱loul waseg min-Yudiy babaw nikatilutegs agusinap nakatimlakay; nag kweitan sinap akatimwa̱lag o aka̱wum; nag. ");
INSERT INTO myw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aveiyag wawun kwatiga̱neig yey? Kwatiga̱nes tanageins agulivan, tasiyas-nan; ikakinsa agulivan.” ");
INSERT INTO myw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeisuw ilivan ikous, teitan plisman wadadan nitamanaw mo iweiy Yeisuw, naman waseg, ilana, “Awoum kwatimop tanuwgwes lun sitovek anilivan ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeisuw ilana, “Magat agulivan kalbaleb, kadiloka kwamtel aveiyag igeg. Kukin gog nag, aveiyag wawun nukuweig?” ");
INSERT INTO myw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yeisuw igawa iyawanis naman, Anas mo ikayeb va̱gan kid biya̱tal wamatan Kayapas, mtowen tanuwgwes lun sitovek avakaein. ");
INSERT INTO myw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saymon Pita, igawa itamanaw ikammunuw kov; gamag mwasanin mo idibakes, ilansa, “Adok ya̱koum navamul teitan, ne?” Pita ilana, “Nag.” ");
INSERT INTO myw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tanuwgwes lun sitovek natouwat nises, mtowen veiyon towen Pita nibob teigan; ilana, “Adok bo akineim wa̱bag soum Yeisuw, ne?” ");
INSERT INTO myw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Vayuwein Pita ikayan, ilana, “Nag.” Mo igel kolkolek. ");
INSERT INTO myw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iyateles Yeisuw wamatan Kayapas ee... walalayis. Ikous, mo inawes gabman avakaein wanbunatum bunavakaein. O peinan min-Yudiy ikatkakils sitapwa̱loul waseg, yam towen beikams Kaltuwon bulukwan la̱miy, nag kadilok beisiws gabman Lom wanbunatum wanuwan. ");
INSERT INTO myw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mapuna Paylat isap in watoulan, idibakes, ilana, “Aveiyag wawun bukuyateles taw towen?” ");
INSERT INTO myw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ilansa, “Kukin nag takalbaleb towen, nag bakamey waseg ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paylat ilana, “Mikaleiwag nises. Kunawes taw towen, kukwaleiwags waseg.” Iweis min-Yudiy, ilansa, “Nag ivag makaleiwag va̱gan baka̱weiy gamag.” ");
INSERT INTO myw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Min-Yudiy asilivan towen waseg mo ikamat livan towen Yeisuw nilivnek, peinan ilivan, “Beiweigs waklos.” ");
INSERT INTO myw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paylat mo iyum in wanbunatum, ilana, “Kukines Yeisuw beim.” Im to Yeisuw; Paylat mo ikatigan; ilana, “Tabta ya̱koum min-Yudiy siking, ya̱koum; ne?” ");
INSERT INTO myw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iw to Yeisuw, ilana, “Sivinam bukukwakin, ne? O adok min-Yudiy bo idibakeims liva̱neig towen.” ");
INSERT INTO myw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paylat ikatimop anilivan, ilana, “Yey nag gum-Yudiy, yey. Ambod tasiyas tanuwgwes lun nimayeims waseg yey. Aveiyag mukwalbaleb?” ");
INSERT INTO myw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeisuw ilana, “Ta-ivag gunakabkaleiwag ven watinow; nag. Magat gunakabkaleiwag ven watinow, gungamag mo bikanaviys va̱gan min-Yudiy nag biyousigs. Tage nag; gunakaleiwag kweitan-wan.” ");
INSERT INTO myw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paylat ilana, “Tabta king teitan ya̱koum, ne?” Yeisuw ilana, “Ma̱wana nukulivan. Inag nikopweig wotet towen silma̱nin. Mapuna bo nam ven watinow va̱gan bakatimlakay sinap mounid. Kalisiy asisinap mounid mo biliganes aygag.” ");
INSERT INTO myw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paylat ilana, “Aveiyag sinap mounid?” Paylat ilivan ikous, vayuwein mo inek min-Yudiy, idibakes, ilana, “Nag aban ansinap kalbaleb waseg taw towen. ");
INSERT INTO myw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tage sagal towen Kaltuwon sinapun balik wa̱deil teitan baspuy bein wamnat. Sagal towen, kavel baspuy beiw? Takaleiwag yakamiy. Adok balik min-Yudiy miking baspuy beiw, ne?” ");
INSERT INTO myw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iwaks avakaein, ilansa, “Taw towen bises; tage Bala̱bas beim.” Mtowen Bala̱bas tavveinaw teitan. ");
INSERT INTO myw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Paylat mo ikaliwages natakannaviys, vatul waseg iwaways wa̱won Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Iwaweiys Yeisuw ikous, tasiyas takannaviy mo isiwa̱kus anapay vatul kulikoul waseg, mamagina doudiw, isenas wakunun, ivaskomis kweim bwabwel waseg, ikululs wamatan, ilansa, “Kalin nuwem min-Yudiy siking ya̱koum”; isiba̱wes-wan; nimes waseg iwaweiys. ");
INSERT INTO myw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Vayuwein Paylat mo in watoulan, idibakes min-Yudiy, ilana, “Kukines gamag towen namey wasigeis yakamiy; kadiloka kukwakins nag aban ansinap kalbaleb waseg.” ");
INSERT INTO myw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeisuw mo isap, anapay kulikoul, anakweim bwabwel, Paylat mo idibakes, ilana, “Kukines gimgilitoun towen.” ");
INSERT INTO myw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tanuwgwes lun situwa̱vek sisiyas siplismans ikines Yeisuw, mo iwaks, ilansa, “Kwatimates waklos!” Paylat ilana, “Yakamiy kutokes, kunawes, kuweiys; yey nag; nag aban ansinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tasiyas Yudiy gimgilis mo ilansa, “Peinan taw towen anilivan, ilana, ‘Yey Yowbad Natun yey,’ kadiloka bikanig. Makaleiwag ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paylat iligen asilivan towen, singay ivag anpwa̱yat. ");
INSERT INTO myw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iyum in wanbunatum wanuwan, idibek Yeisuw, ilana, “Avanuy mukunoy nukum?” Tage nag ikatimop anilivan, isesuna ikika̱pay. ");
INSERT INTO myw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paylat mo ilivan, ilana, “Bo kukwa̱pway ne? Tabta kukwakin yey takaleiwag. Bakaleiwag balikum, o nag, bukukwanig waklos?” ");
INSERT INTO myw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iw to Yeisuw, ilana, “Misinaka Yowbad beitam aveiyag bukunuwakeig. Kukin gog nag, bo nag. Bukuweig, sinap towen kalbaleb, tage mtowen nimayeig waseg yak, ansinap towen singay kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paylat iligen Yeisuw anilivan ikous, mo iyokon va̱gan bilik; tage min-Yudiy iwkuwaks, ilansa, “Kukin bukulik taw towen, Sisal mo bigeg nanon. Peinan taw towen anilivan, ilana, ‘Yey king yey,’ mamagina isilponay Sisal nakaleiwag waseg.” ");
INSERT INTO myw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paylat iligen asilivan, isin kabkaleiwag kabanen waseg, waven towen ag-Ibliw waseg idokes Gabat, peinan dakul babaw nisesus wavtakon ven, mo imey Yeisuw va̱gan bikaleiwag waseg. ");
INSERT INTO myw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bo iya̱nay yam towen bikatunags silma̱nin Kaltuwon sigeilin nubweig. Paylat mo idibakes min-Yudiy, ilana, “Kukines miking.” ");
INSERT INTO myw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tasiyas gog iwkuwaks, ilansa, “Kunawes taw towen, kwatimates waklos.” Iw to Paylat, ilana, “Tabta ba̱weiy miking, ne?” Iweis tanuwgwes lun, ilansa, “Making anmwa̱net Sisal.” ");
INSERT INTO myw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wankuyeim Paylat mo itam Yeisuw va̱gan binawes beiweiys waklos. ");
INSERT INTO myw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Itokes Yeisuw, isekes anklos va̱gan bikow binow ven to yagan Busabwes (Ag-Ibliw waseg idokes Golgot.) ");
INSERT INTO myw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ven towen waseg mo ikatikavates Yeisuw, ikayagweg waklos. Asteiy ikatikavates ikayagwegs wasiklos, teitan palatan, teitan palatan, Yeisuw gog wanuwein. ");
INSERT INTO myw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Paylat ilel liva̱nen, isen wakunuwatan klos, mamagina, “Gum-Nasalet Yeisuw, min-Yudiy siking.” Nileles gog ag-Ibliw waseg, aga-Lom waseg, o aga-Gilis waseg; min-Yudiy singay babaw ivinis, peinan ven towen kadilakus Yelusalem. ");
INSERT INTO myw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Min-Yudiy babaw mo ivnivins lelel towen: “Min-Yudiy siking,” mapuna tasiyas tanuwgwes lun situwa̱vek mo idibakes Paylat, ilansa, “Awoum kulel: Min-Yudiy siking. Tage kadiloka kulel: Taw towen anilivan, ilana, ‘Min-Yudiy siking yey.’” ");
INSERT INTO myw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paylat ilana, “Nag; to nalel bo bisesuna, bisigeg.” ");
INSERT INTO myw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Tasiyas takannaviy ikatikavates Yeisuw ikous, mo ikawes anakweim, ilagus kalguvas; katanok katanok mo ikawes asikweim. Anakweim mwaynavakaein mo iyousis, ilansa, “Awoum bitabwabwes maynawen kweim, peinan aniwniwoun katanok-wan; ta-ivag ankatuvas. Bitalaves youd kweitan, makav bikalouw bein wapwepway, takines kal nakabivatus biton, towen mo bikow anakweim. Sona bikow. Awoum bitabob.” E, iva̱ges ma̱wan va̱gan bikamat lelel towen Bukitab nilivnek mamagina. “Ilagus agukweim, ikokews asikweim; makava mo ilaves kweitan youd, idokes kal bikow agukweim tonen.” Mapuna takannaviys iva̱ges ma̱wan. ");
INSERT INTO myw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yeisuw anklos walasin itowas inan Meliy, son inan kweitan, sisiy Kilopas nakwav yagan Meliy, sisiy vinen-Magdal yagan Meliy. ");
INSERT INTO myw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","27","Yeisuw ikines inan son navamul teitan nitatos, mtowen singay isiwa̱youb waseg, mo idibek inan, ilana, “Inag kukin natum towen.” Mo idibek navamul, ilana, “Kukin inam.” Navamul iligen, tut towen waseg mo itok ineis wanven, imlavag inan tonen. ");
INSERT INTO myw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wankuyeim Yeisuw mo ikakin nawotet bo ikous, ilana, “Agudak! Ta-ma̱wan!” (Peinan Bukitab kweiboug nilivnek mamagin.) ");
INSERT INTO myw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kwavitan kwa̱vig wayn yayan nises; yotout ikawes, isenas wakwa̱vig, ibasis kaligweg yagan yisop wamatan, iyaseles, isekes Yeisuw, imoum. ");
INSERT INTO myw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wankuyeim, ilivan, ilana, “Bo ikous!” Itagud kayon, mo ikanig. ");
INSERT INTO myw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yam towen iyouluks, ikatunags peinan nubweig Sa̱dad towen mamagina Sa̱bat, sagal Kaltuwon waseg; singay ikayuses mamagina siSa̱bat avakaein; mapuna min-Yudiy initougs waseg Paylat va̱gan takannaviys bikatupwes kikeis tasiyas ikayagwegs wasiklos, mo beimats, bikawes bilavewas. Awoum takanigs bikayagwegs ven walasin nubweig to Sa̱bat waseg. ");
INSERT INTO myw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","33","Mapuna takannaviy inekes teitan ikayagweg waklos, ikatupwes kaken, ikanig; ikous, mo inekes teitan ikatupwes kaken, ikanig; ikous mo inekes Yeisuw, ikines nanawan bo nikanig, to na-ikatupwes kaken, nag. ");
INSERT INTO myw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Misinaka takannaviy teitan ikow nakayal, ibes viligan, ila̱tay buyav son yevagam. ");
INSERT INTO myw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yey atamanaw towen akakin, agulivan mounid peinan bo akin wamatag; agulivan towen asekeimiy va̱gan kid bukusimounids yakamiy. ");
INSERT INTO myw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Kweiboug Bukitab nilivnek mamagina: “Awoum bikatup tatuwan tonen.” Kweitan livan nises: “Bo bikines towen nibasis.” E, takannaviy ivkakes ma̱wan va̱gan bikamat Bukitab liva̱nen Yeisuw silma̱nin. ");
INSERT INTO myw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gum-Alimatiy teitan yagan Yosep, kweiboug isimounid Yeisuw waseg, tage nag ika̱mat, peinan anpwa̱yat min-Yudiy situwa̱veks wasigeis. Towen Yosep nag sivinan Yeisuw won tasiyas takannaviys bilaves mav, to initoug waseg Paylat, mo itam Yeisuw won, isek; Yosep ikow inow. ");
INSERT INTO myw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","40","Nikodimos mo inek Yosep, kweiboug nikaypuls son Yeisuw, boug waseg. Nikodimos imey kaybuy singay avakaein va̱gan won Yeisuw nag beipwas, mouvitan magina sinwavas kilos; mul son alow nisesus wanuwan kaybuy towen. Kaybuy son itabwes won Yeisuw, iyawanis kweim pwapwa̱kaw waseg, ma̱wan asigulagul tasiyas min-Yudiy. ");
INSERT INTO myw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Walasin ven towen neiweiys Yeisuw, bag kweitan nises, o bag wanuwan alawag kweivaw; kweiboug nag teitan takanig isenas, nag. ");
INSERT INTO myw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Peinan kadiyakus siSa̱bat avakaein, o peinan alawag towen kadiyakus nises, to inawes Yeisuw, itakus. ");
INSERT INTO myw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wik kweivaw nakabsilamaw waseg, walalayis, kakit mo beikous dadub, vinen Magdal, yagan Meliy, in wakalawag, iban dakul bo iyatpinis wawadon, in wadadan. ");
INSERT INTO myw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Meliy isawl, inekes Pita son Yeisuw navamul towen singay isiwa̱youb waseg, idibek tasiyas, ilana, “DaGuyaws alawagan makaw. Bo ikawes, inawes; nag kakakin, seik avanuy misekeyas.” ");
INSERT INTO myw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita iliganes anilivan, son Yeisuw navamul tayuwein, mo isaps bineis wakalawag. ");
INSERT INTO myw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Isisawls ee... son itamap, Pita ikuyeim. Towen nitamap in wakalawag itapop, ikin alawag wanuwan, tibutobwa mav; tage nag isiw wanuwan. ");
INSERT INTO myw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Wankuyeim Saymon Pita inek, isiw in wanuwan, ikin tibutob palatan; ikin maynatan kweim niyawanis wakunun sinkatupum imasis palatan. ");
INSERT INTO myw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Towen nimug nein wakalawag mo isiw in, ikin, isimounid. ");
INSERT INTO myw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Peinan bo itagouwa̱wes Bukitab nilivnek Mesay beikit kanig waseg. ");
INSERT INTO myw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tasiyas inavamul asteiy mo iyums ineis wasiven. ");
INSERT INTO myw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","13","Meliy gog itamanaw wadadan alawag, ivva̱lam. Igawa ivva̱lam, itapop ikin wanuwan, ikines min-liba̱lab asteiy, asikweim pwapwa̱kaw, isinis nakabmasis Yeisuw, teitan wakunun, teitan wakaken; ikatiga̱nes Meliy, ilansa, “Aveiyag wawun kuvva̱lam?” Ilana, “Peinan guntovek bo inawes; nag bakakin seik avanuy misekeyas.” ");
INSERT INTO myw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ilivan ikous, itouvin, ikin Yeisuw nitet; tage nag biwtus Yeisuw. ");
INSERT INTO myw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeisuw ikatugan, ilana, “Vin ya̱koum, aveiyag wawun kuvva̱lam? Kal kuninineiv?” Wananon idoki towen tawtelein kid bag, ilana, “O tamwey, magat bo kukow, kunow, kadiloka kudibakeig avanuy mukusekey, yey mo ban bakow, bamey.” ");
INSERT INTO myw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeisuw ilana, “Meliy!” Itouvin, iwtus, ilana, “O, guntovek!” (Ages tasiyas “Labonay”; aga-Muyuw gog “Guntovek.”) ");
INSERT INTO myw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iw to Yeisuw ilana, “Awoum kwabikon wa̱woug; awoum. Peinan nag anek Tamag; igaw wankuyeim mo ba̱mwen banek. Nagein kun kudibakes budag agulivan mamagina: ‘Yey bo ba̱mwen banek Tamag, Timamiy, mtowen gunaYowbad, miYowbad, daYowbads babaw ya̱kids.’” ");
INSERT INTO myw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Vinen-Magdal mana̱wen Meliy mo inekes inavamul Yeisuw, ilana, “Bo akin datoveks”; mo ikamtel youd babaw to nilivan. ");
INSERT INTO myw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","20","Yam towen kwayav Sa̱bat, inavamul Yeisuw nisesus wasibunatum. Awkwedan bo ikatibog, peinan iwenes min-Yudiy situwa̱vek. Yeisuw mo isap, itoun wanuwein, ilana, “Beitay nuwamiy yakamiy!”; ikatimlakes naman, viligan. Bo ibwein ninous tasiyas, peinan ikines sitovek, bo imwa̱saws seikwan. ");
INSERT INTO myw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Vayuwein gog mo ilivan, ilana, “Beitay nuwamiy yakamiy. Tamag nikayabeig, ma̱wan bo bakayabeimiy.” ");
INSERT INTO myw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","Ilivan ikous, ipwa̱yik wawous tasiyas, mo ilana, “Yowbad Kululuwan biwekeimiy. Kalisiy asisinap kalbaleb bukulavewas, bo bisiw bisigeg. Magat bukulivans bisesus wasigeis, bo bisesus.” ");
INSERT INTO myw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yeisuw nisap nilivan ma̱wan wasigeis inavamul tasiyas sinwatan; teitan gog Tomas nag ises wasigeis. Tomas yagan kweitan Papap. ");
INSERT INTO myw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wankuyeim Tomas inekes tasiyas sinwatan, mo ilansa, “Bo nakakin datoveks.” Tomas gog idok kid iyaweids, ilana, “Magat bakin naman pwapwat mulin, bakawgil didig waseg, o viligan bwabwagan kayal bakawgil namag waseg, mo basimounid. Kukin gog nag, bo nag.” ");
INSERT INTO myw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","27","Yam kweinim kweitoun ikous, inavamul vayuwein ikatuyouns wasibunatum wanuwan nisesus; e, Tomas sisiy nisesus. Yeisuw isap, koukwed katibog kid, itoun wanuwein, ilana, “Beitay nuwamiy yakamiy.” Mo idibek Tomas, ilana, “Kukin namag, viligag; namam kwabkwen, mo kusimounid; awoum kusesuna mav.” ");
INSERT INTO myw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Iwa̱ge Tomas ilana, “O guntovek, gunYowbad yak.” ");
INSERT INTO myw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeisuw ilana, “Tayyaweid ya̱koum Tomas, kukineig mo kusimounid peinan bo a̱kit. Tasiyas gog nag ikineigs, o singaya ge isimounids waseg yey, bwanabwein tasiyas adok bimwa̱saws.” ");
INSERT INTO myw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeisuw nawotet tawtoun singay babaw; navamul yakamey nakakin. Kweiyuy nalel nises wa̱buk towen; babaw nises. ");
INSERT INTO myw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bo alel tasiyas va̱gan bukuvinis o bukuliganes, mo bukusimounids peinan Yeisuw Mesay, Yowbad natun tonen. Bukusimounids yagan waseg mwamovamiy mo bukuba̱nes. ");
INSERT INTO myw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","(1,14) Yeisuw ikit kanig waseg, sivay isap inavamul wasigeis; sivtounun mo isap mamagina: Yevagam katiboul wanawoud yagan Tibeliyas. Yeisuw inekes navamul wadadan yevagam towen. ");
INSERT INTO myw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tasiyas katanok bod nisesus, Saymon Pita, Tomas (mtowen idudouws Papap), Nataniyel (mtowen naven Ken, wawnuwan Galiliy), sisiy Sebidiy nitun, sisiy Yeisuw navamul asteiy. ");
INSERT INTO myw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saymon Pita mo ilana, “Ban agileloud.” Tasiyas ilansa, “Simey yak bitaneis.” Inibwis siwag, ikala̱vis, igilelouds ee... iyam. Ta-kweitan in ikwanes. Makaw-wan. ");
INSERT INTO myw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Walalayis Yeisuw iton wakawalaw; tage navamul nag iwtusis. ");
INSERT INTO myw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yeisuw idibakes, ilana, “Tawaw! Tabta amiyin?” Ilansa, “Nag. Makawan!” ");
INSERT INTO myw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeisuw ilana, “Kweitan saw kulaves wamika̱tay, mo bukukwanes in.” Ilaves wot in, mo ikwanes asiyin; nag bikawes, peinan singay babaw. Ta-ma̱wan bidagis in wanuwan wag. ");
INSERT INTO myw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yeisuw navamul towen isiwa̱youb waseg, mo idibek Pita, ilana, “Mtowen datoveks.” Saymon Pita sona mwadoyan iwwotet, ikakin mtowen natovek, mo isikam anakweim, inuw wayevagam, igay. ");
INSERT INTO myw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yeisuw navamul tasiyas wa̱wag ikala̱vis ineis wanakaew, isilbiteilis wot peinan bo ika̱lawt in; nag bikadiveiyov mo ita̱lags. ");
INSERT INTO myw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ineis wanakaew ikines kov son in bo ika̱men, son bled. ");
INSERT INTO myw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeisuw idibakes, ilana, “In towen nukukwanes, kumeyes mwasanin.” ");
INSERT INTO myw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saymon Pita mo itow in wa̱wag, iyous wot, ibiteil in wanakaew, bo ika̱lawt in kavka̱veks lakatutan sinwanim mwana̱toun. Tage nag ikayboulis wot; bwein-wan. ");
INSERT INTO myw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeisuw idibakes, ilana, “Kumeis, kukwams.” Nag kal bikatugan, bilana, “Kavel yak?” Aspwa̱yat bikatiga̱nes. Ikakins gog sitovek towen. ");
INSERT INTO myw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeisuw im, ikow bled, ivgen isekes; in-vak mo isekes ma̱wan; ikams. ");
INSERT INTO myw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(-) ");
INSERT INTO myw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ikams ikous, Yeisuw mo idibek Saymon Pita, ilana, “Yon natun yak. Tasiyas isiwyoubugs. Tabta ya̱koum singay bukusiwyoubug, ne?” Pita ilana, “Mounid; guntovek yak, kukwakin asiwyoubum.” Yeisuw ilana, “Kumtakavates aleig la̱miy.” ");
INSERT INTO myw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sivyuwein Yeisuw idibek Saymon, ilana, “Yon natun yak, tabta bukusiwyoubug, ne?” Pita ilana, “Mounid; guntovek yak, kukwakin asiwyoubum.” Yeisuw ilana, “Kumtakavates aleig sip.” ");
INSERT INTO myw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","18","Sivtounun Yeisuw idibek Saymon, ilana, “Yon natun yak, tabta bukusiwyoubug, ne?” Pita mo igeg nanon, peinan Yeisuw nilivan sivtounun, ilana, “Tabta kusiwyoubug?”; to ilana, “O guyaw, youd babaw kukwakin; kukwakina asiwyoubum.” Yeisuw ilana, “Kumtakavates aleig sip. Mounid adibakeim, igaw wagwa̱dim nukusikam amkweim, nukuninoun ampalawen sivinam. Igaw bukutovek namam bukudimwes, soum teitan biyawen amuwat, bivakabanim binaweim palatan nag ivag sivinam.” ");
INSERT INTO myw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeisuw anilivan towen va̱gan bikamtel ama̱wan Pita bikanig, yakawanan Yowbad silma̱nin. Ikous, mo ilana, “Kwabkunig.” ");
INSERT INTO myw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita itouvin ikin Yeisuw navamul teitan ikabwa̱kun waseg, mtowen singay isiwa̱youb waseg, o kamkwam waseg nisineikim kadiyakus wavtakon Yeisuw nikatimwa̱lag, ilana, “Tamwey, kal towen bisilkodeim?” ");
INSERT INTO myw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ikin navamul towen, idibek Yeisuw, ilana, “Taw towen, aveiyag bilouvat?” ");
INSERT INTO myw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeisuw ilana, “Kukin ba̱tam va̱gan mtowen bisesuna ee... mo ba̱yum bam, awoum bigeg nanoum. Misinaka kwabkunig.” ");
INSERT INTO myw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yeisuw nagamag iliganes livan towen, idokes kid taw towen nag bikanig; tage Yeisuw na-ilivan, “Mtowen nag bikanig”; nag. Misinaka ilana, “Kukin ba̱tam va̱gan mtowen bisesuna ee... mo ba̱yum bam.” ");
INSERT INTO myw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yeisuw navamul mtowen nikatimlakeids youd tasiyas, nilel nein wa̱buk; takakins-wan anilivan bo mounid. ");
INSERT INTO myw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Wotet babaw Yeisuw niwtel. Kukin teitan bilel nawotet babaw bein wa̱buk, adok ven watinow mo bika̱lawt buk maynsiyas, tage igawa bilelel. ");
INSERT INTO myw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Kalin nuwag Tiyopil ya̱koum. Kweitan livan kweiboug nalel neiw. Let towen wanuwan nalel liva̱nen Yeisuw. Yeisuw isilamaw nawotet babaw o nageiguy, iwwotet ee... tutan iyakous nakatimlakay nagamag wasigeis, mo imwen in walba̱lab. Peinan bo nikatigikes nagamag tasiyas silma̱nin anilivan bikokews; ikatimlakes waseg Kululuwan Yowbad, ikous, mo imwen in walba̱lab. ");
INSERT INTO myw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Peinan kweiboug mwasanin niyagages Yeisuw, imat, ikit vayuwein; sona mwamovan mo inekes nagamag tasiyas; ikines nawotet tawtouna singay; e, tasiyas isimounids bo imov, peinan siney inounas sinawavas yam waseg, ikkines Yeisuw, o sinapun Yowbad inakaleiwag Yeisuw bo ikatimlakes. ");
INSERT INTO myw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Misumkwey siney nagamags nikatuyouns nisesus, Yeisuw idibakes, ilana, “Awoum kunounas; tage kukwayamats Yelusalem waseg; Tamag mo bikayeb teitan gamag biwekeimiy va̱gan kid bilabeimiy; kweiboug nikatigik ma̱wan, o yey nadibakeimiy ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“Peinan kweiboug Yon nibapta̱yses gamags, soup waseg; tage igaw tut nag biveiyov, Yowbad mo bibapta̱yseimiy yakamiy, waseg kululuwan tatonen.” ");
INSERT INTO myw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Katuyouns tasiyas mo ikatiga̱nes Yeisuw, ilansa, “Tamwey, tabta bukuvag vayuwein bitawtoun dakaleiwags, ya̱kids min-Yisleil, ma̱wana kweiboug? Tut towen bukuvag ma̱wan? o nag? igaw?” ");
INSERT INTO myw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeisuw ikatimop asilivan, ilana, “Tamag nawotet towen. Nag kadilokeimiy bukukwakins avei-tut o avei-yam Yisleil vayuwein mo bitawtoun; peinan takaleiwag anmwa̱net Tamag. ");
INSERT INTO myw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","“Tage yakamiy miwotet kweitan. Igaw Kululuwan Towen Bwanabwein biwekeimiy, bikimtuweimiy va̱gan bukusekes liva̱neig min-Yelusalem wasigeis, o min-Yudiy asibabaw-wan, o min-Samaliy wasigeis, o vena babaw wadaban pwepway.” ");
INSERT INTO myw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Igawa illivan ma̱wan o ikkines; Yowbad mo ikow, inow, ilakanig-o lov kweitan wanuwan. ");
INSERT INTO myw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","E, iyeys, ikakins walba̱lab, Yeisuw nilakanig yay; nuwanaw mo itamanaws wadides tawaw asteiy, asikweim pwapwa̱kaw. Tasiyas mo ilivans, ilansa, “Min-Galiliy yakamiy, aveiyag wawun kutomos kukwakins walba̱lab? Towen Yeisuw mwana nilisaweimiy nein walba̱lab, igaw ma̱wan, mo beiyum bimekeimiy. Ma̱wana nein, e, beiyum beim ma̱wan-wan, ankakin katanok-wan.” ");
INSERT INTO myw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ikous, ilisawes koy towen, yagan Oliv, iyums ineis Yelusalem. Ked towen nag biveiyov, kadiyakus-wan, kadiloka gamag binoun yam Tapwa̱loul waseg. ");
INSERT INTO myw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iyums, mo isiws wasibunatum to nisikeyas, mo imnavaws kasiyuwein waseg, tasiyas Pita, Yon, Yemes, Andiluw; tasiyas Pilip son Tomas; tasiyas Batolomiw son Matiw; Alpiyow natun towen Yemes; talliwon towen yagan Saymon; o Yemes natun towen Yudas. ");
INSERT INTO myw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","16","Asibabaw tasiyas, ninous kid katanok-wan va̱gan bininitougs Yowbad waseg. Sisiyas vinay mwasanin, sisiy Yeisuw inan Meliy, siney Yeisuw budan. Babiweis mamagin lakututan sinawey. Misiya̱mun towen, kweitan yam waseg, Pita mo itamanaw wanuwein gamag siyas babaw, ilana, “Budag yakamiy, kweiboug Yowbad Kululuwan ikatipel ansinap isek Deibid, mo ikatigik nawotet Yudas, towen talabein siyas niyousis Yeisuw; o Deibid anilivan towen nein Bukitab waseg. O kadilok youd siyas bikamats ma̱wan Deibid anilivan kweiboug. ");
INSERT INTO myw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","“O towen Yudas sods nitasesus, o datoveks nisek inawotet, ma̱wana ya̱kids. ");
INSERT INTO myw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","“O towen gog isilakod Yeisuw waseg, mo ikow maysan nawotet towen, igimwel pwepway kweitan. Wankuyeim mo ikalouw kantukov wapwepway towen, nuwan ikatuw, sinewun isap in wamnat. O min-Yelusalem babaw ikakins, mapun idokes pwepway ‘Akeldamak.’ (Kativin bein aga-Muyuw ‘Buyav pwapwayein’). ");
INSERT INTO myw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“O liva̱nen Yudas nises Bukitab, kweitan Sam waseg, ma̱wana, ‘Kadiloka naven bikalipet; awoum teitan gamag bisik.’ E, kweitan livan nises, ‘Kweitan gamag bikow nawotet.’” ");
INSERT INTO myw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pita mo ilivan, ilana, “Kadiloka taneves atimapun Yudas, kavel tut babaw sods nitasesus; nitakines Yon igaw kweiboug nibapta̱yses gamags, o nitakines daGuyaws Yeisuw, yam babaw ininoun ee... tutan ilivet mo imwen in walba̱lab. O sods towen bitakokews liva̱nen Yeisuw nakabeikit waseg; e, bitaneves mtowen atimapun Yudas.” ");
INSERT INTO myw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","E, iliganes Pita anilivan, isenas tawaw asteiy; teitan Yosep, yagan pinatoun, kweitan yagan Ba̱sabas, kweitan yagan Yusitos; tayuwein isenas yagan Matiyas. ");
INSERT INTO myw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ikous, mo ikululs Yowbad wamatan, initougs, ilansa, “O Guyaw, kukwakina gamag babaw amasinap, kwatimlakem mukwaleiwag wasigeis tasiyas asteiy, kal atimapun Yudas bikow nawotet, takawein amlivan; peinan Yudas bo ipiyev nawotet towen, inoun in inaven kweitan.” ");
INSERT INTO myw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wankuyeim mo ileles yiges tasiyas asteiy, akweiy youd waseg, mo ilaves makaw; ikalouws, o yagan Matiyas isin wanakaew, mapun Matiyas isiw inekes tasiyas takaweins liva̱nen Yeisuw; tasiyas sinawatan tatanok. ");
INSERT INTO myw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos anayam waseg, Yeisuw nagamag asibabaw-wan, katanoka bunatum waseg nisesus. ");
INSERT INTO myw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","But meinoy neim walba̱lab, singay nuwanaw inekes; idokes yag itow avakaein; bo iyavka̱vek bunatum towen nisinis wanuwan. ");
INSERT INTO myw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wamtes gog mamagina mayen kov, ililivis in palatan palatan, mo itonas wasigeis gamag katanok katanok. ");
INSERT INTO myw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yowbad Kululuwan Towen Bwanabwein bo inekes, asibabaw-wan, mo igeiguys, asilivan kweitan kaeig kweitan kaeig, peinan asisinap bo isekes Kululuwan Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Misumkwey towen vena babaw gimgilis nimeis sagal towen silma̱nin, nisesus Yelusalem, tawaw bwana̱bweins, gimgilis vena babaw wadaban pwepway. ");
INSERT INTO myw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Butun towen iliganes; ikatuyouns nimeis, bo iyow nuwes peinan asibabaw iliganes ages tatineis. ");
INSERT INTO myw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","11","Singay isom ninous, ilansa, “Adok tasiyas asibabaw-wan min-Galiliy ne? Ama̱wan asilivan nitaliganes teitan gamag aygan tonen, teitan gamag aygan tonen; tage ya̱kids aygads babaw, peinan davanuys babaw, Palit, Mediy, Elam, Mesopotemiy, Yudiy, Kapadokiy, Ponit, Esiy, Piligiy, Pampiliy, Yidipt; o wawnuwan Aplik ven mwasanin, Saylin walasin; o mina-Lom, mwasanin min-Yudiy nikoulups ineis Lom sisiy mina-Lom tasiyas nikawes min-Yudiy datapwa̱louls; o min-Kilit, o min-Alebiy; ya̱kids babaw taliganes liva̱nen Yowbad nawotet tawtoun, o babaw ya̱kids taliganes aygads tatoneids waseg.” ");
INSERT INTO myw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bo isom ninous peinan nag ikakins silawun. Sisiyas ikatiga̱nes, ilansa, “Aw-sinap towen?” ");
INSERT INTO myw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tage mwasanin isiba̱wes, ilansa, “Bo ikabala̱weins, peinan wayn neimoums adok.” ");
INSERT INTO myw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Siney Yeisuw nagamag, tasiyas sinawatan tatanok, Pita mo itamanaw igeiguy, idibakes gamag babaw, ilana, “Sigwey min-Yudiy yakamiy, o Yelusalem gimgilis yakamiy babaw, kuliganes agulivan, mo bakatimlakeimiy sinap kweitan. ");
INSERT INTO myw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Peinan kulivans, ‘Bo imoums wayn, ikabala̱weins,’ nag; nag bakakabala̱wein, peinan igaw ga̱boug. Tasiyas bikabala̱weins, wayn kwayav waseg beimoums mo bikabala̱weins; tage yakamey bwein. ");
INSERT INTO myw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","“Youd towen nukukines peinan palopit Yowel kweiboug-o nikatigik, ilana, ‘Yowbad anilivan ma̱wana: Igaw nakabiyokous tut ven watinow, kululuwag bo basekes ven babaw gimgilis, nitimiyas, tawaw o vinays, mapuna bigeiguys agulivan waseg. Tabwa̱bwat wasigeis yakamiy bikines kweivaw youd, mamagina asmikon; ninous waseg bikakins; o tammwayas, asmikon waseg bikamikons. ");
INSERT INTO myw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O yam towen waseg kululuwag bo basekes gungamag, tawaws o vinays, mo bigeiguys. ");
INSERT INTO myw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aniyag bo basen wanakaew walba̱lab, o ven watinow. Aniyag buyav waseg o kov son musewun waseg. ");
INSERT INTO myw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ka̱las biladadub, o tibukon bilabwabwel ma̱wana buyav. Ikous, mo bikamat Guyaw Yowbad nawotet tawtoun, inayam towen waseg. ");
INSERT INTO myw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Guyaw towen bo bikatinabwes gamag tasiyas kalisiy bidawes yagan.’ ");
INSERT INTO myw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Sigwey min-Yisleil yakamiy, kuliganes agulivan towen. Yowbad bo ikatimlakeids gum-Nasalet towen, yagan Yeisuw, naman mulin waseg, nawotet tawtoun, peinan Yowbad nisek natawtoun tonen silma̱nin wotet towen; o sods nitasesus, nawotet tawtoun nivvag, o babaw yakamiy kukwakins. ");
INSERT INTO myw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“O kweiboug Yowbad ikakin-wan towen nawotet babaw bo biwtel ven watinow waseg; o Yowbad kweiboug nikaleiwag silma̱nin takalbalebs biyousis towen Yeisuw, bikatkavates waklos, mo bikatimates. O yakamiy miwotet ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Tage Yowbad bo iyamov Yeisuw, kanig mouvitan bo ilisow. Nag kadilok kanig bitawtoun Yeisuw waseg, nag. ");
INSERT INTO myw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","28","“Liva̱nen mtowen kweiboug Deibid bo ilivan Yeisuw anilivan mamagina, ‘Tut babaw nakikineim yak gunguyaw yak wamatag. Guntawtoun bisigeg, peinan ya̱koum wagunka̱tay nukuses. Mapun, wadoug waseg allivan, peinan gunmwa̱saw avakaein. Igaw woug waseg nases ven watinow, bo banmiseim gunguyaw ya̱koum bukwatinabweig. Peinan kwayuseig, awoum kululuwag bisesuna wa̱Tum. Awoum woug beipwas; awoum. Bo nukwatimlakeig ked towen kabmwamov kidenen. Wamatam bo bukuvag gunmwa̱saw bivakaein.’ ");
INSERT INTO myw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Sigwey yakamiy, adok balivan liva̱nen datoveks towen Deibid; livan kamnat balivan. Towen Deibid bo ikanig, itakus wakalawagan waseg; e, alawag towen, igaw tut towen wadavanuys nises. ");
INSERT INTO myw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“O peinan Deibid palopit, bo ikakin sinapun Yowbad; o Yowbad bo itabudabod, idibek Deibid, ilana, ‘Mounid wabuya̱vim igaw mo bisap tabum ya̱koum, towen bo biguyaw, bikow kid mukwaleiwag.’ ");
INSERT INTO myw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“O kweiboug, peinan Deibid ikakin mtowen Kelis kanig bo bilisow, bitamanaw vayuwein, liva̱nen bo ilivan mamagina: ‘Awoum bisesuna wa̱Tum. Awoum won beipwas; awoum.’ ");
INSERT INTO myw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Yowbad gog nivag mtowen Yeisuw mo itamanaw vayuwein; o yakamey bo nakakin. ");
INSERT INTO myw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“O tut towen, mtowen Yeisuw, Taman nisek nakaleiwag avakaein, o nises Taman wanaka̱tay. O peinan Taman anilivan, bo bisek Kululuwan Towen Bwanabwein, nagein gog bo isek, katipel mo nisekem yakamey; nawotet towen kukines o kuliganes. ");
INSERT INTO myw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","“Deibid ta-imwen in walba̱lab; Yeisuw gog imwen in walba̱lab. Liva̱nen Yeisuw nilivan ma̱wana, ‘Yowbad bo idibek gunguyaw, ilana: Kusin wagunka̱tay. Tage tasiyas nikamliweims igaw mo bavag beibus, bimlavags mamagina mukwabtatet.’ ");
INSERT INTO myw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kuliganes beibwein, o kadiloka min-Yisleil babaw yakamiy bukukwakins kamnat waseg, Yowbad bo ikatigik guyaw teitan takatinabweids ya̱kids, towen yagan Kelis, mtowen Yeisuw nukuweiys waklos.” ");
INSERT INTO myw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Gamag tasiyas iliganes, bo igeg ninous, ibwayouys avakaein, ikatugwans waseg Pita siney Yeisuw nagamags, ilansa, “Tawaw, bo igak! Ama̱wan bakavkek?” ");
INSERT INTO myw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ikatimop asilivan, idibakes, ilana, “Kulavewas amisinap kalbaleb, mo bakabapta̱yseimiy tatanok tatanok yakamiy, Yeisuw Kelis yagan waseg; mo biwid mikalbaleb, binumlev, nasiwa̱youb mo bisekeimiy, Kululuwan Towen Bwanabwein. ");
INSERT INTO myw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Peinan Yowbad bo ilivnek mounid bisiwyoubuds ya̱kids sidayas nitidayas, o bisiwyoubus vena babaw gimgilis, kalisiy daGuyaws Yowbad bidawes. E, Kululuwan bo isekeids sidayas tasiyas.” ");
INSERT INTO myw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Anilivan ma̱wan mo igeiguy avakaein, idibakes, “Kadiloka kulavewas simiyas, peinan takakons tasiyas.” ");
INSERT INTO myw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Gamag mwasanin iliganes anilivan; yam towen mo ibaptayses, mo iyakelesiys tasiyas, babiweis mamagina kweitoun tawsan gamag. ");
INSERT INTO myw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tasiyas bo itoukums. Yeisuw nagamags asilivan iliganes, o sisiyas tasiyas nisesus, ininitougs Yowbad waseg; o bled ikikivis, ma̱wan asisinap. ");
INSERT INTO myw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gamag babaw bo igoulus Yowbad; peinan ikines Yeisuw nagamag siwotet singaya tawtoun. ");
INSERT INTO myw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","O tasiyas tanageins liva̱nen Yeisuw, sisiyas nisesus; o sivavag mamagina babaw gamag sivavag; nag kweitan ikayuses, nag. ");
INSERT INTO myw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","O sipwepway o siwliyoug iyamiyises, mayses ivganes tasimavs wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Yam babaw ikatuyouns tasiyas-wan, ineis Yowbad wanbunatum. Tage tatineis wasibunatum, bunatan bunatan, ikikivis bled; sisiyas ikamkwams, ikalin nuwes, bo imwa̱saws; ikavvasis Yowbad; o gamag babaw ikalin nuwes tasiyas. O yam babaw Guyaw Yowbad ikatinabwes gamag mwasanin; ikatimweisis nagamag bo ibabaw. ");
INSERT INTO myw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kweitan yam, ka̱las bo itageg, tutan nitoug Yowbad wanbunatum, Pita son Yon mo ineis, nitoug silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","3","Teitan taw igaw kweiboug inan nikop yay igayal, bo ivakaein tage angayal isigeg-wan; o yam katanok katanok issin Yowbad nabunatum wawkwedan, koukwed towen yagan Kamnabwein; e, tut babaw issin towen, ininitoug money wasigeis gamag tasiyas nisowsiws wanuwan. O siney bikokews taw towen biwayes, Koukwed Kamnabwein waseg bisin, yam babaw mo bininitoug; o taw towen ikines Pita son Yon kakita bo beisiws wakoukwed, mo initoug money wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita son Yon ikikines taw towen; Pita mo ilivan, ilana, “Kukinem yakamey.” ");
INSERT INTO myw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Taw towen mo igintoves tasiyas asteiy; idoki bisiwyoubus kid. ");
INSERT INTO myw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nag gog, Pita ilana, “Ta-ivag money waseg yey. Kweitan youd nises waseg yey, bo basekeim. Gum-Nasalet yagan Yeisuw Kelis, mtowen yagan waseg adibakeim kunoun.” ");
INSERT INTO myw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Pita iyous naman wanaka̱tay, mo itamnow. Nuwanaw idamoms kaken, o inatub meivek-wan idamoms; kaspepel, itamanaw, mo inoun; o siney tasiyas asteiy mo isiws Yowbad wanbunatum, inoun palatan palatan, ipilapel, singay iya̱kawn Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Gamag babaw bo ikines taw towen ininoun, o iliganes anaya̱kawn Yowbad waseg; iwtusis tantougein money towen kweiboug nises Yowbad nabunatum watoulan, Koukwed Kamnabwein waseg. Meiveka tasiyas bo isom ninous, mapuna ikalin nuwes, peinan ikines takagayal towen bo ibwein. ");
INSERT INTO myw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Taw towen siney Pita, Yon nisesus. Bo isom ninous gamag babaw, isisawls, imimeis kwa̱now kweitan yagan Solomon nakwa̱now. ");
INSERT INTO myw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ikin, ikatimop asilivan, ilana, “Min-Yisleil yakamiy, aveiyag wawun isom ninoumiy, o wawun kukinemas yakamey. Ta-ivag matawtoun o amasinap tatinem va̱gan bakavag beibwein takagayal towen, nag. ");
INSERT INTO myw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Towen Yowbad nawotet, mtowen Ebelam naYowbad, o Aysak naYowbad, o Yekob naYowbad, o tamumwey babaw siYowbad; mtowen nivag natun Yeisuw mo iguyaw. E, yakamiy nukupiyaves taw towen, nukusilkodes wamatan Paylat; o Paylat gog sivinan bikaluweg towen Yeisuw bilik bisap. ");
INSERT INTO myw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“O yakamiy gog nukupiyaves taw towen bwanabwein, tadidumwal, o nukwavtagis yagan tawayin gamag, va̱gan Paylat bikaluweg taw towen bilik bisap. ");
INSERT INTO myw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","“Nukuweiys abmwamov tanuwagan towen, o Yowbad gog bo ivag ikit kanig waseg, bo kakin yakamey. ");
INSERT INTO myw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Waseg natawtoun mtowen yagan Yeisuw, taw towen bo ibwein. O kweiboug nukukines angayal taw towen, o nagein-vak kukines bo idamoms kaken, peinan bo isimounid waseg Yeisuw. E, isimounid waseg Yeisuw, mo isek natawtoun wamitamiy babaw yakamiy. ");
INSERT INTO myw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sigwey, nagein akakin nukuwteles ma̱wan peinan tatagouwaws yakamiy, o mituwa̱veks-vak ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“O Yowbad gog ikakin gamag mwasanin biyagages naKelis, o kweiboug ikatimlakes napalopit ma̱wan; e, mo ilivans ma̱wan tababaw palopit tasiyas; o ma̱wan asilivan kweiboug, ma̱wana tut towen bo ikamat. ");
INSERT INTO myw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Kadiloka kuva̱ges ninoumiy bikanavin, kulavewas amisinap kalbaleb, va̱gan Yowbad biwid, binumlev. DaGuyaws mo bivag beibwein amnamiy. Peinan bo ikaleiwag Yeisuw Kelis nawotet va̱gan bilabeimiy. Magat bikanavin ninoumiy, Yowbad mo bikayeb mtowen biwekeimiy. ");
INSERT INTO myw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Tut towen Kelis bo nein walba̱lab, kadiloka bisesuna ee... igaw anatut bikatilow youd babaw mo beiyum beim, ma̱wan pwa̱mug-o nilivnek Yowbad wasigeis napalopits tatonen. ");
INSERT INTO myw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","“Moses gog anilivan ma̱wana, ‘Igaw palopit teitan daGuyaws Yowbad mo bisek nawotet, mtowen buda̱miy teitan, palopit ma̱wana yey; kadiloka kuliganes anilivan babaw wasigeis yakamiy. Kavel tapiyavein anilivan palopit towen, bo bagidem taw towen, bilisaweimiy, binoun.’ ");
INSERT INTO myw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“E palopit babaw kweiboug nilivnakes youd towen, asilivan katanok-wan, tage tut towen bo nikamat. Wanmugwana Samwel anilivan ma̱wan, mo tasiyas wankuyeim asilivan bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“O ya̱kids tut towen mamagin tasiyas palopit tibsiyas ya̱kids o Yowbad nakaleiwag tamumwey wasigeis bo ikaluweg silma̱nin ya̱kids; anilivan Ebelam waseg, ilana, ‘Igaw ven babaw gimgilis wadaban pwepway mo bimwa̱saws tabum waseg.’ ");
INSERT INTO myw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Wanamug Yowbad bo isekeimiy natouwat pinamiy yakamiy, nikayeb mtowen niwekeimiy, va̱gan bukulavewas amisinap kalbaleb, mo bukumwa̱saws; wanmugwana yakamiy min-Yudiy, tage vena babaw wankuyeim mo bimwa̱saws.” ");
INSERT INTO myw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Igaw Pita son Yon illivans gamag wasigeis, mo isaps tanuwgwes lun situwa̱vek, sisiy tulal avakaein, towen tamtakavatein Yowbad nabunatum, sisiyas tasiyas Sadusiy; bo igeg ninous tasiyas, peinan ikatimlakes gamags, ilansa, “Kanig waseg gamag beikits vayuwein, peinan Yeisuw nikanig, mo itamanaw vayuwein.” ");
INSERT INTO myw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mapuna iyousis tasiyas tawaw asteiy, isenas wa̱deil, bikayamats yamtan yam kid waseg mo biyateles, peinan bo ikwayav. ");
INSERT INTO myw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tage babaw gamag niliganes asilivan, bo isimounids waseg; tawaw siyas isimounids bo ibabaws, mamagina kweinim tawsan. ");
INSERT INTO myw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iyam-nen Yelusalem waseg mo ikatuyouns tanuwgwes lun situwa̱vek, o tamumwey, o takatimlakeins kaleiwag. ");
INSERT INTO myw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Misumkwey towen tanuwgwes lun sitovek avakaein yagan Anas, nimeis siney Kayapas, Yon, Alekisan, sisiy angamag mtowen tanuwgwes lun sitovek. ");
INSERT INTO myw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Imeyes Pita son Yon itomos wanuwein gamag babaw, mo ikatiga̱nes, ilansa, “Aw-kaleiwag waseg, kal yagan waseg kuwteles sinap towen?” ");
INSERT INTO myw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","10","Kululwan Towen Bwanabwein son Pita nisesus, mapun iwon, ilana, “O matuwa̱vek, o tamumwey yakamiy; magat nagein bukwatiga̱nemas liva̱nen takagayal towen ama̱wan anvavag neibwein, kadiloka bukukwakins, babawa yakamiy, o min-Yisleil babaws, bo ibwein waseg gum-Nasalet, Yeisuw Kelis; yakamiy nukuweiys waklos, ikanig, tage Yowbad ivag mo itamanaw vayuwein. E, natawtoun mtowen Yeisuw waseg, takagayal itamanaw wamatads bo ibwein. ");
INSERT INTO myw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Liva̱nen mtowen waBukitab nises mamagina: ‘Wululay towen tawteleins bunatum nipiyaves, tage bo imlavag anmwamwan bunatum.’ ");
INSERT INTO myw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Mtowen anmwa̱net Yeisuw bikatinabweids; nag kwayuwein kadilok; nag kwayuwein yagan nises liba̱lab waskawan; misinak yagan towen Yeisuw waseg bitaba̱nes damwamovs, ya̱kids gimgilis ven watinow.” ");
INSERT INTO myw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ikines Pita son Yon bo iwons, asilivan tawtoun, o ikakinsa tasiyas nag iskuls avakaein, mamagin ven gimgilis tasiyas, bo isom ninous; mo inuwes tasiyas asteiy sisiy Yeisuw kweiboug nisesus. ");
INSERT INTO myw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","O peinan takagayal towen mwana ibwein, sisiy itamanaws, ta-ma̱wan bikatimop asilivan. ");
INSERT INTO myw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Mapuna ikayabes bineis bikayamats watoulan bunatum; tasiyasa takaleiwags mo illivans sisiyas, ilansa, “Ama̱wan bitavkakes gamag tasiyas? Peinan siwotet tawtoun singay, o min-Yelusalem babaw ikakins. Admwasins. Ta-ma̱wan! ");
INSERT INTO myw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","“Adok bo bitaka̱nes, va̱gan nag bivgavaws liva̱nen Yeisuw. Nagein gog gamag mwasanin bo iliganes asilivan. Bo deis. Kukin bikatpeles livan towen gamag wasigeis, adok bitakatimapus asisinap va̱gan bika̱kin mites. Idakaleiwags ma̱wan!” ");
INSERT INTO myw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ilivans ma̱wan, ikous, mo idawes Pita son Yon bimeis. Imeis; tawtoun asilivan waseg mo idibakes, ilansa, “Awoum kullivans Yeisuw yagan waseg; awoum kugeiguys o kulivans; singay bwaboum.” ");
INSERT INTO myw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Pita son Yon ikatimapus asilivan, ilansa, “Tab kadilok wamatan Yowbad bakaligen amilivan yakamiy? O Yowbad anilivan tonen? Kukwaleiwags yakamiy. O youd siyas nakakin o nakaligen, ta-ma̱wan bakayakous amalivan sinap towen waseg.” ");
INSERT INTO myw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Vayuwein ika̱nes avakaein, mo ikayabes bineis kid wasibunatum. Ta-iba̱nes asisinap kalbaleb aveiyag bikatimapus, nag. Bo iwenes gamag babaw, peinan gamag babaw nikines wotet towen, mapuna iya̱kawns Yowbad waseg. Peinan taw towen mwana ibwein bo itovek, anbweilim bo iyakous sinawavas; o wotet towen tawtoun, mamagina mulin naman Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iyokous, mo iyums inekes tawlisiyas, mo ikamteles livan, tasiyas tanuwgwes lun o tamumwey asilivan. ");
INSERT INTO myw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iliganes ikous, mo ikanavin ninous silma̱nin nitoug Yowbad waseg, ilansa, “Matovek ya̱koum, peinan nukuvag liba̱lab, o pwepway, o yol, o youda babaw wapwepway o wa̱yol. ");
INSERT INTO myw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","“Gamag siyas sivines bisilbwades muwotet, ma̱wan nilivan mutouwat towen, yakamey tibum Deibid. Peinan kweiboug Kululuwam waseg, mo ikakin sinap towen, ilana, ‘Aveiyag wawun iwons ven babaw gimgilis, o min-Yisleil ininuways sinap mav? King babaw wadaban pwepway itamanaws, sisiyas guyawaw ikatuyouns imeis, bikawpwanaws kid wasigeis Yowbad son naKelis.’ ");
INSERT INTO myw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","28","“Mounid, ven towen waseg, bo ipiyaves mutouwat towen bwanabwein; ikawpwanaws waseg towen Yeisuw, mtowen nukusek inawotet, nukwayus peinan towen Mesay. O peinan mukwaleiwag nukulivnakes ma̱wan, mogo iyagages Yeisuw, tasiyas Elod, o Ponitiy Paylat, o min-Yisleil, sisiyas ven mwasanin gimgilis, bo iyagages Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“O Guyaw, tut towen bo kukwakin asilivan kalbaleb, sivines kid biyagagemas yakamey; kulabem mutouwat yakamey va̱gan baka̱won beibwein, mo bakalivan amlivan. ");
INSERT INTO myw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","“O Guyaw kuyasel namam va̱gan bukulabem, takatouns kuva̱ges beibweins, namam mulin kuvvag, wotet tawtoun waseg, wayagan mutouwat bwanabwein towen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Initougs ikous, sibunatum mo igogewn, mamagina bo beinik; Yowbad Kululuwan inekes tasiyasa babaw, mapun iwonsa singay, illivans Yowbad anilivan. ");
INSERT INTO myw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Peinan Kululuwan Yowbad nises wasigeis tasiyas, ninous katanok-wan, o sivavag katanok-wan. Nag teitan gamag bikayus navavag; peinan youd tasiyas gamaga babaw sivavag katanok-wan. ");
INSERT INTO myw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","35","O sitawtoun waseg, takaweins anilivan mo igeiguys liva̱nen Yeisuw, ilansa, “Maguyaw towen nikanig, bo ikit vayuwein.” Babaw tasiyas singay isiwa̱youbs. Nag teitan kal tasimav nises, nag; peinan ven tanuwgwes iyamiyises sipwepway o sibunatum; mayses mo ikawes imeyes, isekes Yeisuw nagamag; tasiyas mo ivagens gamag wasigeis, bo isekes ma̱wana gamag babaw sivines. ");
INSERT INTO myw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Teitan taw Yosep, kweivaw yagan Ba̱nabas, Yeisuw inagamags nidokes. Wawun yagan towen, “Talabein gamags.” Gum-Saypilos mtowen, anakum Livay, napwepway wanven bo iyamiyis; maysan ikow imey, isen wamtes Yeisuw nagamag, tasiyas takaweins anilivan, sinawatan teiy; bo isekes tasiyas maysan napwepway. ");
INSERT INTO myw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Teitan taw son nakwav iyamiyises sipwepway, maysan money mwasanin ikawes isenas wamtes tasiyas takaweins liva̱nen Yeisuw, ilansa, “Maysan tamkwa̱lan towen-an.” Iyaweids gog; taw towen Ananiyas iyaweid, namoney mwasanin ikayus, o nakwav Sapayil ikakina iyyaweid. ");
INSERT INTO myw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iw to Pita, ilana, “Ananiyas, aveiyag wawun Seitan isiw wananoum yak, va̱gan kid Yowbad Kululuwan bukwatidev? Peinan kwayus mumoney mwasanin, maysan pwepway. ");
INSERT INTO myw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“Kweiboug pwepway towen tanuwagan yak; wankuyeim nukuyamiyis, maysan money nukukow tanuwagan yak. Aveiyag wawun amsinap nukuvag ma̱wan? Nag kuyawadem yakamey; tage bo kuyaweid Yowbad waseg.” ");
INSERT INTO myw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyas iligen, ikalouw wapwepway, bo imat. Gamag tasiyas iliganes, mo ivag aspwa̱yat avakaein. ");
INSERT INTO myw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tabwa̱bwat mo itamanaws itabwes won towen takanig, ikawes inawes, itakus. ");
INSERT INTO myw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Taw towen nakwav nag ikakin neimat. Veit kweitoun ikous mo isap, Pita ikatugwan waseg, ilana, “Tabta mipwepway maysan ma̱wan towen?” Ilana, “E, ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ilivan, “Aveiyag wawun ninoumiy amiteiy bo bukuyakwanes kid Yowbad Kululuwan? Kukin! Tadibwanins mumwan bo nimeis, wakoukwed nisesus, bo bikaweims binaweims ya̱koum!” ");
INSERT INTO myw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nuwanaw mo ikalouw wamatan Pita, imat. Tabwa̱bwats mo isaps ikines nikanig mana̱wen, ikawes, inawes, idibwanis namwan wadadan. ");
INSERT INTO myw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tayakelesiys babaw ivag aspwa̱yat, o taliganeins livan towen mo ivag aspwa̱yat meivek-wan. ");
INSERT INTO myw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Takaweins liva̱nen Yeisuw siwotet singay tawtoun, gamag wasigeis; gamag nikines mo ikakins Yowbad nawotet tatonen. Yam babaw asisinap ikatuyouns imimeis Solomon wankwa̱now. ");
INSERT INTO myw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gamag siyas watoulan nag imekes, peinan aspwa̱yat; tage babaw gamag bo iya̱kawns wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","15","Gamag mwasanin mo isimounids Guyaw Yeisuw waseg, vinay, tawaw; bo ikatimweisis gamag singaya babaw. Takatouns imeyes, isenas ked wadadan, ampalawen Pita meinoy; e, isenas wakabes o wa̱sag, sivines kululuwan Pita bilumwes kid tasiyas takatouns, mo beibweins. ");
INSERT INTO myw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ven babaw gimgilis Yelusalem walasin katuyouns imimeis, takatouns imeyes sisiyas tasiyas bwagaw nibugawus; iva̱ges mo ibweins. ");
INSERT INTO myw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Butun wotet towen mo iliganes tanuwgwes lun sitovek avakaein, siney inabod tasiyas Sadusiy, singay igeg ninous, ikamliwes tasiyas takaweins liva̱nen Yeisuw, mapuna iyousis, inawes wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Boug waseg Yowbad nataka̱yob im ikaliyow awkwedan deil, itokes, inawes wamnat, ilana, “Kuneis, kutamanaws Yowbad wanbunatum, kudibakes gamag liva̱nen mimwamov towen Yeisuw nisekeimiy.” ");
INSERT INTO myw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iliganes anelos towen anilivan; walalayis mo ineis Yowbad nabunatum, livan mo ikatimlakes gamag. Tanuwgwes lun sitovek avakaein siney angamag mo idawes min-Yisleil astakaleiwags o tammwayas bimeis, mo idibakes inagamags mwasanin, ilansa, “Kuneis, tasiwuns deil tasiyas kutokes, kumeyes.” ");
INSERT INTO myw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Ineis, bitokes kid wa̱deil, iwekes makawan. Iyums, imeis ilansa, “Nakan nakakin deil buntuman bo ikatabagus keikay-wan, o takaymateins deil nitatos wakoukwed; naka̱siw wanuwan, ta-kweitan gamag nises, makawan.” ");
INSERT INTO myw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tulal avakaein sen tanuwgwes lun situwa̱vek iliganes asilivan, bo isunasun ninous; ikubukub nuwes, peinan na-bikakins aveiyag mo bikamat. ");
INSERT INTO myw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Teitan gamag mo isap, ilana, “Gamag siyas nukusenas wa̱deil bo itamanaws Yowbad wanbunatum, illivans ikatimlakays gamag.” ");
INSERT INTO myw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tulal sen nagamag mo ineis, itokes gamag tasiyas imeyes. Bo ivna̱ses. Nag ika̱nes, peinan iwenes gamag babaw. Mata bigeg ninous, peinan idokes kid beiweiys dakul waseg. ");
INSERT INTO myw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Imeyes gamag tasiyas, mo itomos wanuwein tasiyas takaleiwags. Tanuwgwes lun sitovek avakaein mo ikatiga̱nes, ilana, “Livan kamnat waseg nakadibakeimiy, kalana, ‘Awoum kugeiguys yagan towen waseg;’ tage min-Yelusalem babaw bo iliganes butun towen; o adok sivinamiy gamag kid bilansa, ‘Peinan tanuwgwes lun sikaleiwag bo iweiys Yeisuw.’ Awoum gamag bilivans ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita siney takaweins liva̱nen Yeisuw mo ilivans, “Magat mikaleiwag kweitan, o Yowbad nakaleiwag kweitan, kadiloka bakaligen Yowbad nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","“DaYowbads towen tamumwey siYowbad bo isek Yeisuw vayuwein namwamov, peinan yakamiy nukwatimates, nukwatiptukwes wakamweilok; tage Yowbad bo isek naguyaw, mamagina takatinabwein gamags, aban nisek wanaka̱tay Yowbad; o nawotet silma̱nin min-Yisleil ya̱kids, bikanavin nanouds, mo biwid adsinaps kalbaleb, bilev. ");
INSERT INTO myw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“O yakamey kakakin livan towen mounid, mapuna kallivan ma̱wan; o Yowbad Kululuwan Bwanabwein bo isekem taliganein anilivan yakamey, o Kululuwan Towen ikatimlakeids sinap towen mounid.” ");
INSERT INTO myw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","34","Tasiyas iliganes, bo ikapasal nuwes, sivines bikatimates; tage takaleiwag teitan yagan Gamaliyel itamanaw va̱gan biliwon. Mtowen Palisiy, takatimlakein Yowbad nakaleiwag; mapuna babaw gamag ivna̱ses tamwey towen. Ilana, “Kadilok tasiyas takaweins liva̱nen Yeisuw bineis watoulan, tut kadiyakus bisesus, baliwon, beikous mo beisiws bimeis.” ");
INSERT INTO myw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","E, tasiyas ineis watoulan, Gamaliyel mo iliwon, ilana, “Sigwey min-Yisleil yakamiy, kadiloka kuvna̱seimiy, aveiyag bukunuwakes gamag tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Kunuwes kweiboug teitan gamag yagan Tudas itamanaw, idok guyaw avakaein tonen; gamag babaw mo inekes, mamagin lakatuvas tawaw; wankuyeim mwasanin iweiys taw towen, o taliganeins anilivan bo igayays; butun taw towen bo ikous. ");
INSERT INTO myw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Wankuyeim gum-Galiliy teitan yagan Yudas, anatut yagads gabman nileles wa̱buk, mo itamanaw, ikatidavis gamag mwasanin, ikatkunis; wankuyeim mo ikanig taw towen, o taliganeins anilivan bo igayays, bo ikous. ");
INSERT INTO myw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","40","“O tut towen adibakeimiy, bweina bisesus gamag tasiyas. Awoum kuyagages. Magat gamag sikaleiwag towen, o gamag siwotet, kakita biyakous; tage kukin Yowbad nawotet towen, ta-ma̱wan bukusilbwades; mata ge bukuvatays waseg Yowbad.” Tasiyas iliganes aygan towen; idawes Yeisuw nagamag, imeis, iwaways, mo idibakes, ilansa, “Awoum kwatimlakays yagan Yeisuw waseg;” mo ikayabes, ineis. ");
INSERT INTO myw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ilisawes takaleiwags tasiyas, nag ivag asimwasin, imwa̱saws-wan, ilansa, “Adok Yowbad sivinan ya̱kids, inakaleiwag va̱gan a̱bads bigeg, Yeisuw yagan peinan.” ");
INSERT INTO myw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yam katanok katanok mo ikatimlakes gamag, Yowbad wanbunatum, o bunatum babaw wasigeis; isekes livan towen bwanabwein, liva̱nen Mesay, mtowen yagan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Misumkwey towen sivamul ikatimweisis singay babaw, musinis takagaGilis, musinis takagIbliws; e, tasiyas takagaGilis ivtokes livan siyas takagIbliws, ilansa, “Yam katanok katanok ivganes kaeis isekes nakubukwabs wasigeis, o yakamey nakubukwab siyas nag ivag mana̱nan kaeis.” ");
INSERT INTO myw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yeisuw nagamag tasiyas sinawatan teiy mo idawes sivamul babaw bimeis, mo ilansa, “Mawotet bakalivan Yowbad anilivan; nag kadilok bakasem wotet towen va̱gan bakavgen kan. ");
INSERT INTO myw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“Kadiloka kukines tawaw toubweins mwasanin yakamiy; gamag tasiyas asisinap tawtoun; o Yowbad Kululuwan wasigeis tasiyas; kadilok kusenas teinim teiy va̱gan bakasekes siwotet towen. ");
INSERT INTO myw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","“Yakamey bakaysiyous imawotet silma̱nin Yowbad, bakanitoug waseg, o anilivan bakasekes gamags.” ");
INSERT INTO myw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gamag babaw itams, ilansa, “Bwein”, mo isenas tawaw teinim teiy; teitan Sitiben, Kululuwan Yowbad nises waseg towen, o bwein isimounid Yowbad waseg; teitan Pilip, teitan Pilokol, teitan Nikanol, teitan Timon, teitan Pamenas, teitan Nikolaw, mtowen gum-Antiyok bo imlavag gum-Yudiy, peinan ikow tapwa̱loul-nen Yudiy. ");
INSERT INTO myw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tasiyas bo itamanaws wamtes takaweins liva̱nen Yeisuw; initougs Yowbad waseg, ikous, mo isenas nimes wawous tasiyas, silma̱nin bikawes siwotet va̱gan bimtakavatays kan. ");
INSERT INTO myw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Singay babaw gamag mo iliganes liva̱nen Yowbad, navamul bo ikatimweisis singay babaw, waseg ven towen Yelusalem. Tanuwgwes lun mwasanin bo iliganes livan towen, mo isimounids waseg Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yowbad nasiwa̱youb avakaein isek Sitiben, iwotet tawtoun, mamagin Yowbad naman mulin ivag; o gamag babaw ikines. ");
INSERT INTO myw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","10","Gamag mwasanin mo itamanaws ikamnimans waseg Sitiben; mwasanin min-Yudiy sitapwa̱loul yagan Libetin, sisiyas min-Saylin mwasanin, o min-Aleksanidel, o min-Silisiy, o min-Esiy, tasiyas mo ikamnimans waseg Sitiben; tage nag kadilok bitakayways, peinan kululuwan o ansinap singaya tawtoun. ");
INSERT INTO myw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mapun isilkodes; idibakes mwasanin, ilansa, “Igaw ya̱tal waseg kuyaweidsa, kulansa, ‘Nakaligen anilivan kalbaleb taw towen, ilivan mav, Moses liva̱nen, o Yowbad liva̱nen.’” ");
INSERT INTO myw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","E, mo ivtokes livan Sitiben wasigeis gamag babaw; o tamumwey, o takatimlakeins kaleiwag niliganes; gamag babaw mo itamanaws, iyousis Sitiben, inawes va̱gan biyateles wamtes astakaleiwags min-Yudiy tatineis. ");
INSERT INTO myw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Mo idawes tasiyas tayyaweids bimeis. Imeis, ilansa, “Gamag towen, tut babaw ivtokay livan silma̱nin Yowbad nabunatum towen, o silma̱nin Moses nakaleiwag, o nakaligen anilivan, ilana, ‘Gum-Nasalet towen Yeisuw bo bigulek bunatum towen; o sinap kweiboug Moses nisekeids, Yeisuw bo bikatlow.’ Anilivan ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Takaleiwags isinis, iggintoves magin taw towen Sitiben, ankakin kweitan, magin ma̱wana gum-liba̱lab anelos. ");
INSERT INTO myw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tanuwgwes lun sitovek avakaein mo ikatigan Sitiben, ilana, “Tabta asilivan mounid? Ama̱wan amlivan yak?” ");
INSERT INTO myw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiben ikatimop livan towen, ilana: “Talawog yakamiy o tamumwey yakamiy, kuliganes agulivan. Guyaw avakaein Yowbad bo inek datoveks Ebelam, pwamug-o waMesopotemiy, wankuyeim mo ikoulup in Elan. ");
INSERT INTO myw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“E, igaw Ebelam nises Mesopotemiy, Yowbad inek, idibek, ilana, ‘Kadiloka muven o talawom kulisow, kun ven kweitan bakatimlakeim.’ ");
INSERT INTO myw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Mapuna ilisow Kaldiy, ikoulup, in Elan. Taman son nisesus; e taman ikanig ven towen Elan. Wankuyeim mo im isik pwepway towen Kenan, tut towen idavanuys. ");
INSERT INTO myw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“O Yowbad ta-isek nakiyay towen; igaw. Ta-isek napwepway wavtanok, nag; Yowbad idibek Ebelam, ilana, ‘Igaw basekeimiy simwey tibum mipwepway;’ tage nag ivag natun, nag. ");
INSERT INTO myw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","7","“Yowbad mo idibek Ebelam, ilana, ‘Tibum bisikes kweitan ven, wunovek, o misikena gimgilis bisekes siwotet avakaein biwotets, o bweilim lakatuvas abes bigeg. Igaw mo bamop sikalbaleb misikena gimgilis tasiyas, igaw tibum mo bisaps bimeis biwotets gunawotet ven towen wanuwan.’ ");
INSERT INTO myw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“O peinan Ebelam itam kaleiwag towen waseg, Yowbad mo isek nakabivatus; Ebelam ibwabwes tawaw momwes. Wankuyeim nakwav mo ikop natun Aysak, ikayamat yam kweinim kweitoun, mo ibob momwan; wankuyeim Aysak natun Yekob ma̱wan, o Yekob nitun tawaw sinawatan teiy, tasiyas datuwa̱veks pwa̱mug-o. ");
INSERT INTO myw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Datuwa̱veks tasiyas ikamliwes budas Yosep, isekes gamag mwasanin, ikawes Yosep, inawes Yidipt; tage Yowbad son nisesus, ikatinob Yosep youd babaw kalbaleb nilouvat ven Yidipt waseg; e, isek ansinap avakaein wamatan min-Yidipt siking towen Pelow, mapun ikalin nuwan Yosep waseg, isek nawotet tamtakavatein nabunatum, o tamtakavatein ven towen Yidipt, meivek-wan. ");
INSERT INTO myw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Wankuyeim nag ivag kweis Yidipt waseg, o Kenan waseg; tut singay kalbaleb ilivatus. Kan bo iyakousis datuwa̱veks wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","“Wankuyeim Yekob iligen kan nises Yidipt, mo ikayabes nitun; e, tibdayas ya̱kids tasiyas; ikayabes ineis Yidipt, kan silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Sivyuwein ikayabes, ineis Yidipt, Yosep mo ikamat wasigeis tuwan. Ikamtel waseg Pelow, ilana, ‘Talawog min-Kenan tasiyas.’ ");
INSERT INTO myw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Yosep mo idawes taman Yekob sen taliven bimeis Yidipt; gamag siyas babiweis sinawanim sinawey teinim. ");
INSERT INTO myw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Yekob inoun in Yidipt, ven towen waseg nikanig; e, tibdayas tasiyas nikanka̱nigs. ");
INSERT INTO myw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","“Wous ititabwes guyawaw siyas, mo ikokews, innawes, isenas watakunumwan ven Sekam waseg; kweiboug Ebelam igimwel takunumwan towen, maysan silib nisek Emol nitun, ven Sekam waseg. ");
INSERT INTO myw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kweiboug Yowbad nilivnek Ebelam waseg, ilana, ‘Bakatinabwes tibum ven towen waseg.’ Kadilakusa bo bilouvats tutan bikatinabwes, min-Yisleil mo ibabawsa singay. Ven towen Yidipt bo ika̱lawt min-Yisleil. ");
INSERT INTO myw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","19","“Misumkwey towen mo isap King kweivaw; mtowen nag ikakin Yosep, isilkodes tamumwey, ikaleiwag va̱gan bilavewas nitsiyas a̱pwaw; sivinan gamag tasiyas bimta̱mats beikous. ");
INSERT INTO myw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Tut towen waseg na̱tan vin mo ikop natun a̱pwaw tamnabwein yagan Moses, isowum tibukon kweitoun, namwan wanbunatum. ");
INSERT INTO myw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","“Wankuyeim mo isemos wamnat; Pelow natun kuda̱vin mo ikow, ituy gwad towen, mo imlavag natun tatonen. ");
INSERT INTO myw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","“Towen Moses ivakaein, iskul, itakayes min-Yidipt asisinap babaw ikous, bo itawtoun anilivan waseg, o nawotet-vak tawtoun. ");
INSERT INTO myw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Anbweilim sinawavas waseg, mo inuway taliven, in kid bilakwanes taliven tasiyas min-Yisleil, idoki bo bilabes. ");
INSERT INTO myw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","“In ikin gum-Yidipt iyageg gum-Yisleil teitan, imop nakalbaleb, iweiy gum-Yidipt, imat. ");
INSERT INTO myw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Idoki taliven bikakins Yowbad nisek nawotet va̱gan bikatinabwes tasiyas; tage nag ikakins. ");
INSERT INTO myw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Yamtan yam mo ikines min-Yisleil asteiy ikawpwanaws, idoki bivag beimwas kid, ilana, ‘Tawaw, yakamiy bod katanok-wan, min-Yisleil yakamiy. Aveiyag wawun kuygeg soum?’ ");
INSERT INTO myw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","“Towen niyageg son, mo iyabin Moses, ilana, ‘Kal nisekeim muguyaw o mukwaleiwag wasigeis yakamey? Adok bukuweig ma̱wana towen nov gum-Yidipt nukuweiy, ne?’ ");
INSERT INTO myw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Iligen anilivan towen, ivag anpwa̱yat Moses, mo isawl, ikoulup, in isik ven yagan Midiyan, ivays son nakwav, ikopwes nitun tawaw asteiy. ");
INSERT INTO myw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Isesun ee... bweilim sinawavas ikous, ininoun wanawoud, koy Sinay waseg. Ta-ivag ven, makawan. E, Moses mo ikin gum-liba̱lab son inakov nigidaged amweilok yageivein waseg. ");
INSERT INTO myw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","“Moses ikin, isunasun nanon, isineikim va̱gan kid bikinbunik, mo iligen aygan Yowbad, ilana, ‘Yey tamumwey siYowbad yey; yey Ebelam naYowbad yey; yey Aysak naYowbad yey; yey Yekob naYowbad yey.’ Moses iligen mo itat won, anpwa̱yat bikin Guyaw Towen. ");
INSERT INTO myw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","34","“Yowbad idibek ilana, ‘Kwablev musandol, kusew, peinan ven towen waseg nases. Awoum sona musandol bukumey. Bo akin min-Yidipt iyagages gungamag, bo aligen ildeilids, bo abus va̱gan kid bakatinabwes; e, tut towen kum bakayabeim kid bukun Yidipt, wotet towen silma̱nin.’ ");
INSERT INTO myw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mtowen Moses, min-Yisleil kweiboug nipiyaves, nilansa, ‘Kal nisekeim muguyaw o mukwaleiwag towen?’ O Yowbad gog, gum-liba̱lab waseg, bo isek nakaleiwag o nawotet va̱gan kid bikatinabwes Yowbad nagamag. Gum-liba̱lab towen Moses nikin amweilok waseg. ");
INSERT INTO myw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Moses mo imgwayes gamag tasiyas, peinan nawotet tawtoun, Yidipt waseg, o Yol Bwabwel waseg, o sinawavas bweilim wanawoud waseg, nawotet tawtoun, mamagina Yowbad naman mulin. ");
INSERT INTO myw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mtowen Moses nidibakes min-Yisleil, ilana, ‘Igaw teitan wasigeis yakamiy, Yowbad mo bisek nawotet mo bimlavag palopit, mtowen ma̱wana yey.’ ");
INSERT INTO myw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Towen Moses siney min-Yisleil babaw ininounas wanawoud, o gum-liba̱lab nilivan son Moses koy Sinay waseg, ikatipel ansinap mo isekes tibdayas, tammwayas tasiyas, o mwamov liva̱nen bo isekeids. ");
INSERT INTO myw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","“Tage tammwayas tasiyas nag sivines biliganes Moses anilivan; ipiyaves, waninous kid sivines beiyums bineis Yidipt. Mapuna idibakes Elon, ilansa, ‘Kubun dayowbads va̱gan bimgwayeids, peinan mtowen Moses nitokeids nitalisawes Yidipt, nag kakakin ama̱wan nein.’ ");
INSERT INTO myw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“E, tut towen bo ibunis youd magin ma̱wan bulumakaw natun, o iluns o itapwa̱louls waseg kokotom towen, o imwa̱saws waseg youd towen nibunis wanimes. ");
INSERT INTO myw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","43","“Yowbad mo ilisawes tasiyas, va̱gan tasiyas bikululs kid wamatan wutun babaw, ma̱wana palopit anilivan wanuwan Bukitab mamagina: ‘Adok bweilim lakatuvas wanawoud nukuweiys lun bulukwan, min-Yisleil yakamiy, va̱gan bukuluns waseg yey? Tage nukuyousis yowbad kweitan, yagan Molok, nukuwlules nabunatum, nukukokews; o nukukululs wamatan Lepan nawutun, o nukutapwa̱louls mikalelel waseg. Mapuna bakaweimiy banaweimiy palata-dadan ven Babilon.’ ");
INSERT INTO myw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tamumwey tasiyas ikokews Yowbad nabunatum wanawoud, peinan Yowbad nikatimlek Moses ankakin bunatum towen, ilana, ‘Kuwlul gunbunatum ankakin ma̱wan.’ ");
INSERT INTO myw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Wankuyeim Yosuw imgwayes tibdayas, tamumwey tasiyas; sona bunatum towen nikokews, mo iyousis min-Kenan sipwepway, peinan Yowbad ikawmanayes gamag tasiyas, mo isawls wamtes tibdayas. Bunatum bunawen ises ee... mo isilamaw nakaleiwag Deibid. ");
INSERT INTO myw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Yowbad isiwa̱youb waseg mtowen Deibid, o Deibid sivinan biwlul Yowbad nabunatum silma̱nin sitapwa̱loul Yekob tibun tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","“Togo Deibid nag iwlul nabunatum; natun gog Solomon iwlul Yowbad nabunatum towen. ");
INSERT INTO myw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Tage liba̱lab naYowbad towen nag imasis wanuwan bunatum ven watinow waseg, nag. Palopit teitan Yowbad anilivan nilel mamagina: ");
INSERT INTO myw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Yey a̱bag liba̱lab o kakeig nakabva̱wot wapwepway. Amata-bunatum bukuwlules yey gunbunatum? O amata-bunatum bukuwlules va̱gan bayeiwas wanuwan? Adok nag kadilokeimiy, peinan wanamag bo abun youd tasiyas.’” ");
INSERT INTO myw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitiben mo ilivan, ilana, “Singaya takakon yakamiy, Yowbad ta-ivag nakabivatus waninoumiy o watigamiy, nag; tut babaw kuyblebes Yowbad Kululuwan; ma̱wana tamumwey, ma̱wana yakamiy. ");
INSERT INTO myw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Ta-kweitan palopit tammwayas ikatibomes, nag; babawa iyagages. O ikatimates palopit tasiyas, o palopit asilivan ma̱wana, ‘Igaw beim Tadidumwal, mtowen Kelis.’ E, Tadidumwal towen nukusilkodes-vak, nukuweiys. ");
INSERT INTO myw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","“Min-liba̱lab nisekeimiy Yowbad nakaleiwag; tage nukupiyaves nakaleiwag towen; ma̱wana tamumwey, ma̱wana yakamiy.” ");
INSERT INTO myw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iliganes anilivan towen, singay ikapasal nuwes, ikakilis kumtus, singay ikamliwes. ");
INSERT INTO myw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tage Yowbad Kululuwan Bwanabwein son Sitiben nisesus, Sitiben ikin walba̱lab, ikin mititeilin Yowbad, ikin Yeisuw nitamanaw Yowbad wanaka̱tay. ");
INSERT INTO myw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitiben mo ilana, “Towen-o bo akin ikaliyow liba̱lab, o Gimgilitoun towen Yeisuw itamanaw Yowbad wanaka̱tay.” ");
INSERT INTO myw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tasiyas gog bo iwaks avakaein, nag sivines biliganes livan towen, bo ikibwades tiges; ituts bineis biyousis kid Sitiben. ");
INSERT INTO myw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Iyousis Sitiben, mo itokes inawes watoulan ven, mo iweiys, dakul waseg. O tasiyas niyyaweids ya̱tal towen waseg inisis asikweim isenas wadadan toubwat teitan yagan Soul, va̱gan kid bimtakavet asikweim, mo ikawes dakul, iweiys Sitiben. ");
INSERT INTO myw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Igawa iwaways, Sitiben mo iwak, idow naGuyaw yagan, ilana, “Guyaw Yeisuw, kululuwag kukow.” ");
INSERT INTO myw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mo ibasen kitatun, iwak avakaein, ilana, “O Guyaw awoum kumop asisinap towen kalbaleb;” mo ikanig. Toubwat towen Soul ikikin, idok wotet towen bwein. ");
INSERT INTO myw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Misumkwey towen gamag mwasanin bo isilamaws kid biyagages tayakelesiys Yelusalem waseg; e, bo iyagagesa singay. Mapuna bo igayays ineis Yudiy o Samaliy, o vena babaw wasigeis. Misinaka takaweins liva̱nen Yeisuw nisesus Yelusalem, tasiyas sinawatan teiy. ");
INSERT INTO myw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mwasanin gamag bwana̱bweins bo idibwanis takanig towen Sitiben, iva̱lams avakaein silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tage Soul bo iyagages tayakelesiys, inineves tayakelesiys bunatum katanok katanok wasigeis, iyousis tawaw o vinay, itokes, inawes wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","O tayakelesiys tasiyas nigayays bo inawes liva̱nen Yeisuw vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip in min-Samaliy wasiven kweitan wunovek waseg, isekes liva̱nen Mesay Kelis. ");
INSERT INTO myw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","O min-Samaliy inganegs anilivan, ikines nawotet tawtoun, ninous katanok-wan va̱gan biliganes anilivan. ");
INSERT INTO myw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilip nawotet tawtoun; o tasiyas takayyeiluws ivag, mo iwaks avakaein, yeiluw mo ilisawes gamag tasiyas; o taguya̱gweys o takagayals ivag, mo ibweins. ");
INSERT INTO myw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mapuna misikena gimgilis bo imwa̱saws avakaein. ");
INSERT INTO myw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Tamgameg yagan Saymon nises ven towen; min-Samaliy nikines nawotet, bo isom ninous. Mtowen Saymon bo ilivan, ilana, “Yey tatawtoun yey.” Bo iliganes anilivan, tasiyas guyawaw, o sisiyas toul, gamaga babaw, mo ilansa, “Adok natawtouna tonen, mamagina Yowbad natawtoun.” E, nagwa̱diven inganegs tamgameg towen, nameg nikines bo isom ninous. ");
INSERT INTO myw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tage gamag babaw mo isimounids Pilip anilivan waseg, Yowbad nakaleiwag liva̱nen son Yeisuw yagan liva̱nen, ibapta̱yses tawaw o vinay. ");
INSERT INTO myw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Towen Saymon mo isimounid, ibaptays; ibaptays ikous, isesus son Pilip, ikikin nawotet tawtoun o naman mulin, bo isom nanon. ");
INSERT INTO myw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Takaweins liva̱nen Yeisuw igaw nisesus Yelusalem, iliganes min-Samaliy bo itams Yowbad anilivan waseg, mapuna ikayabes Pita son Yon bikines. ");
INSERT INTO myw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Pita son Yon isaps, mo initougs silma̱nin Yowbad Kululuwan Towen Bwanabwein binekes kid gamag tasiyas; peinan kweiboug nag inekes, deisa nibapta̱yses yagan Guyaw Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Initougs ikous, mo isenas nimes wawous gamag tasiyas, Yowbad Kululuwan mo inekes. ");
INSERT INTO myw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Towen Saymon ikin takaweins liva̱nen Yeisuw siwotet ma̱wan, nisenas nimes gamag wawous, Kululuwan Yowbad mo inekes; towen Saymon mo isekes money, ilana, “Money towen kukow, maysan sinap towen. Sivinag sinap towen, namag kid basen gamag wawous va̱gan Kululuwan Yowbad binekes.” ");
INSERT INTO myw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","23","Pita mo ikawtun taw towen, ilana, “Soum-wan mumoney kov waseg bigabum wadiginasim, peinan kudok kid bukugimwel Yowbad nasiwa̱youb. Ya̱koum tobwag gamag. Nag kweitan muwotet nises wasigeis yakamey. Yak nanoum bo ikaydodog wamatan Yowbad. Kadiloka kulavew amsinap towen kalbaleb; kunitoug Yowbad waseg. Adok mo biwid amsinap, peinan akakin-wan amkameiliw son amsinap kalbaleb bo ika̱lawt nanoum waseg.” ");
INSERT INTO myw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saymon ikatimop anilivan, ilana, “Kunitougs Yowbad waseg va̱gan kid kalbaleb towen nag bimekeig yey.” ");
INSERT INTO myw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita son Yon asilivan kamnat waseg mo idibakes gamags liva̱nen siGuyaw Yeisuw, mo iyums ineis Yelusalem; o igawa wa̱ked inounas, livan towen bwanabwein mo isekes min-Samiliy, vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yowbad ikayeb gum-liba̱leb teitan inek Pilip, ilana, “Kutamanaw kunoun kun wa̱yals, kunoy ked makadewen meinoy neim Yelusalem nein Ges.” Ked towen waseg ta-ivag ven; maka̱wan. ");
INSERT INTO myw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Itamanaw, inoun, mo inek gum-Idiyopiy teitan, mtowen yunak, towen tamtakavatein Kandas namoney, mana̱wen vin min-Idiyopiy sikwin. E, yunak towen nitapwa̱loul Yelusalem waseg mo iyum in waniven. Hos ibiteilis inawag, isin wanuwan ivnivin Bukitab, palopit Isaya anilivan. ");
INSERT INTO myw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yowbad Kululuwan mo idibek Pilip, ilana, “Kun, kunek taw towen wanawag nises.” ");
INSERT INTO myw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip isawl, inek, iligen ivnivin anilivan palopit towen Isaya. Pilip ikatigan ilana, “Tabta kukwakin silawun livan towen?” ");
INSERT INTO myw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Iwa̱ge towen ilana, “Ta-ma̱wan bavkek bakakin. Magat teitan gamag bikatimlakeig, bo bwein.” Mo ilana, “Kumwen kum, kusin wa̱wag;” mo imwen, isin wadadan taw towen. ");
INSERT INTO myw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Bukitab wanuwan bo ivin lelel-nen mamagin, “Ma̱wana la̱miy gamag beiweiys, ta-ivag aygan; o ma̱wana bibwabwes wunuwunun sip, nag beiwey, bo bikka̱pay-wan. O gamag towen ma̱wan, nag bilivan. Asilivan tasiyas yaweid, inaya̱tal waseg. Anmwasin; ta-ma̱wan. Igaw ta-kal bilivan liva̱nen angamag taw towen, peinan bo ikanig.” ");
INSERT INTO myw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yunak mo ikatugwan Pilip waseg, ilana, “Liva̱nen kavel? Palopit towen liva̱nen? O teitan gamag liva̱nen?” ");
INSERT INTO myw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilip isilamaw livan towen Bukitab wanuwan, mo ikatimlek liva̱nen Yeisuw, livan towen bwanabwein. ");
INSERT INTO myw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Igawa ininounas wa̱ked, yunak inganeg livan towen, wankuyeim isaps wayvagam; mo yunak ilivan, ilana, “Kukin yevagam towen. Tab kadilok bukubapta̱yseig yey.” ");
INSERT INTO myw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO myw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","E, idibakes nagamag bisewas wag wadadan ked, mo ibus tasiyas asteiy, Pilip son yunak, ineis wayvagam, ibaptays son. ");
INSERT INTO myw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ibaptays ikous, iga̱lags, Yowbad Kululuwan mo ikow Pilip, inow. Yunak na-ikin Pilip; anmwa̱neta ises. Mo inoun in wa̱ked, singay imwa̱saw. ");
INSERT INTO myw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wankuyeim mwasanin iba̱nes Pilip nises Asot. Inoun in ita̱vin vena babaw, illivan liva̱nen Yeisuw gamaga babaw wasigeis, wankuyeim in isap Sisaliy. ");
INSERT INTO myw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Mtowen Soul singay ikawkunes Yeisuw nagamags, sivinan kid bikatimates. Mapuna inek tanuwgwes lun sitovek avakaein, ilana, “Tab kadilok kulel let, va̱gan bakow banow basekes tanuwgwes bunsiyas sinagog ven Damasik waseg; igaw tanuwgwes tapwa̱loul tasiyas bivinis, mo beitams waseg gunawotet va̱gan banineiv kid kalisiy inoyes Yeisuw inaked, ked towen kalbaleb. Magat vinay o tawaws, mo bayousis gamag tasiyas, bayawen nimes, mo batokes, bameyes Yelusalem.” ");
INSERT INTO myw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mtowen itam, isek nalet, ikow; siney nagamag mo ineis ee... kadilakusana Damasik, mititeilin avakaein imek Soul, ikaligwen matan. Mititeilin towen ma̱wana kavikawn meinoy neim walba̱lab. ");
INSERT INTO myw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ikalouw wapwepway, iligen aygan teitan, ilana, “Soul, Soul, aveiyag wawun kuybilebeig yey?” ");
INSERT INTO myw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","6","Iwa̱ge Soul, ilana, “O guyaw, kavel yak?” Ilana, “Yey Yeisuw, nukuybilebeig. Tage kutamanaw, kun ven towen wamatam, teitan gamag mo bilivnek muwotet va̱gan bukukwakin.” ");
INSERT INTO myw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gamag tasiyas sisiy Soul ineis wa̱ked, itamanaws, bo isom ninous, peinan iliganes aygan; tage ta-kweitan gamag ikines. ");
INSERT INTO myw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Soul itamanaw, bo ikiplal matan, tage nag ikin, magina bo ikaw matan; mapuna iyousis naman mo itokes inawes ven towen Damasik. ");
INSERT INTO myw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yam kweitoun isesuna-wan, matan nag ibwein, ta-ikam, ta-imoum, isesuna-wan. ");
INSERT INTO myw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yeisuw nagamag teitan nises ven Damasik, yagan Ananiyas; anmikon waseg naguyaw idibek Ananiyas, ilana, “Ananiyas.” Ilana, “Yey-ay.” ");
INSERT INTO myw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Naguyaw mo ilivan, ilana, “Kutamanaw kun kunoy ked towen yagan Didumwal, e, kun Yud wanbunatum, kunev gamag teitan gum-Talisus yagan Soul, peinan bo intougig. E, igaw ininitoug, ikin taw teitan yagan Ananiyas isap, isen naman wa̱won, va̱gan matan beibwein.” ");
INSERT INTO myw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","14","Ananiyas ikatimop aygan, ilana, “O Guyaw, gamag babaw ilansa, ‘Taw towen singay takalbaleb, singaya iyagages mugwamag Yelusalem waseg;’ o tut towen ikow inalet tanuwgwes lun sitovek avakaein silma̱nin kid biyawanim yakamey takavtagin yagam yak.” ");
INSERT INTO myw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","16","Naguyaw mo idibek, ilana, “Kun kuwtel agulivan ma̱wan, peinan bo akaluweg nawotet taw towen silma̱nin bikow yagag vena babaw gimgilis wasigeis, o siguyawaw wamtes, o min-Yisleil wamtes. Igaw bakatimlek taw towen youda babaw kalbaleb igaw mo bilouvat peinan yagag yey bikow.” ");
INSERT INTO myw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiyas iligen, inoun, isiw wabunatum towen naGuyaw nikatigik, isen naman wa̱won Soul, ilana, “Bwadag ya̱koum Soul, daGuyaws nikayabeig nam, silma̱nin matam bavag beibwein, o silma̱nin Yowbad Kululuwan Towen Bwanabwein biwekeim. DaGuyaws towen Yeisuw niwekeim yak wa̱ked.” ");
INSERT INTO myw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nuwanaw mo ilatimatet matan, mo ikin bwein. Itamanaw mo ibaptays. ");
INSERT INTO myw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kan ikam, amnan mo ibwein. Soul siney Yeisuw nagamag ven Damasik waseg nisesus mwasanin yam waseg. ");
INSERT INTO myw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tage nuwanaw iggeiguy sinagoga babaw wasigeis, ilana, “Mounid Yowbad natun, mtowen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Taliganeins anilivan towen bo isunasun ninous, ilivans, “Tabta taw towen tayagagein Yeisuw nagamag Yelusalem waseg, mo im wadavanuys silma̱nin biyousis tayakelesiys, mo binawes kid tanuwgwes lun situwa̱vek wasigeis?” ");
INSERT INTO myw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tage Soul mo itawtouna singay, anilivan tawtoun waseg mo ikatimlakes min-Yudiy tasiyas misikesa Damasik waseg, va̱gan kid bikakinsa Yeisuw mounida Kelis; e, tasiyas bo ibol ninous, ta-ma̱wan bikatimapus aygan. ");
INSERT INTO myw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Yam mwasanin ikous, min-Yudiy illivans sisiyas, idokes ama̱wan bikatimates Soul; tage teitan gamag idibek Soul mo ikakin ninous. Tasiyas ikayyamats wawkwedan boul yam waseg o boug waseg; ikayyamats kid Soul bisap mo beiweiys. Ven towen nibasis boul watoulan. Gamag nitatos wadunan ked, ikayyamats. ");
INSERT INTO myw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mapuna boug waseg inavamul idagis Soul in wanuwan kaynad avakaein, ikaygwagwes ee... in iton wapwepway watoulan boul, mo itamanaw inoun. ");
INSERT INTO myw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Soul inoun in Yelusalem, sivinan kid binekes Yeisuw nagamag; tage tasiyas iwenes, ilansa, “Adok mtowen Soul nag ikanavin nanon.” ");
INSERT INTO myw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tage mtowen Ba̱nabas mo itok, inekes tasiyas takaweins liva̱nen Yeisuw, ilana, “DaGuyaws bo inek taw towen wa̱ked, ikin, ilivans son, wankuyeim ven Damasik waseg mo itawtoun, igeiguy Yeisuw yagan waseg.” ");
INSERT INTO myw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Min-Yelusalem tasiyas iliganes aygan towen, mo Soul inekes; siney tasiyas nisesus siwotet babaw waseg; e, mo itawtoun, yagan Yeisuw waseg, illivan. ");
INSERT INTO myw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","E, illivans wasigeis min-Yudiy tasiyas takaga-Gilis, mo ikamnimans waseg, mapuna iyokons kid bikatimates. ");
INSERT INTO myw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tage Yeisuw nagamag ikakinsa ninous bikatimates Soul; mapuna itokes Soul ineis Sisaliy, wankuyeim mo ikayabes in Talisus. ");
INSERT INTO myw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tage tayakelesiys babaw nisesusa bwein, wawnuwan Yudiy, o Galiliy, o Samaliy. Nag aveiyag ilivatus; bwein-wan, ikatimweisisa babaws, itawtouns, ivna̱ses Yowbad; peinan Kululuwan Towen Bwanabwein bo ilabes, imlavags singaya babaws. ");
INSERT INTO myw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ita̱vin inoun vena babaw wasigeis, mo iwloubus inekes Yowbad nagamag mwasanin nisesus ven yagan Lid. ");
INSERT INTO myw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ven towen mo iban taguya̱gwey teitan yagan Ayney, bweilim kweinim kweitoun immasis wakaban, ta-ma̱wan binoun. ");
INSERT INTO myw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita idibek, ilana, “Ayney, Yeisuw Kelis bo iva̱geim kid bukubwein. Kutamanaw, kukow musag.” Iligen, nuwanaw mo itamanaw. ");
INSERT INTO myw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mina-Lid o min-Selon tabebaws-wan ikines, mo isivins, Yowbad nakaleiwag ikawes. ");
INSERT INTO myw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ven Yop waseg, Yeisuw nagamag na̱tan yagan Tabit, pinyuwein yagan Dokas; vin mana̱wen nawotet bwanabwein, singaya isiwyoubus tasiyas tasimavs. ");
INSERT INTO myw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","38","Misumkwey towen ikatoun avakaein, mo ikanig. Iwidis won, isewas bunatum kasiyuwein wanuwan; o peinan Yop kadilakusana Lid, o peinan Yeisuw nagamag niliganes Pita nises ven towen Lid, mo ikayabes tawaw asteiy; inounas, inekes Pita, ilansa, “Nuwanaw kum, taneis Yop.” ");
INSERT INTO myw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita iligen, itamanaw, siney tasiyas mo ineis. Pita isap, im; itokes Pita inawes bunatum towen wanakaew nakanig nimsik-yay. Nakubukwabs babaws-wan itomos wadadan Pita ivva̱lams, ikatimlakes asikweima babaw, ilansa, “Kukin amakweim. Dokas, igaw son mwamovan nises, niba̱lal maynsiyas amakweim magayana.” ");
INSERT INTO myw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ikayabes, ineis watoulan, ibasen kitatun, initoug Yowbad waseg, mo itouvin, inek nakanig, ilana, “Tabit, kukit.” Ilivan ikous, mo ikiplal matan, ikin Pita, ikit. ");
INSERT INTO myw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita iyous wanaman, mo itamnow; idawes tayakelesiys sisiyas nakubukwabs tasiyas, mo imeis, ikines Dokas bo imov. ");
INSERT INTO myw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Butun wotet towen in vena babaw Yop walasin, kalamwey babaw gamag mo isimounids Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita nisesuna Yop, yam babaw waseg; mimsikey Saymon wanbunatum, mtowen naba̱lal kaleivin man. ");
INSERT INTO myw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gum-Sisaliy yagan Koniliy, mina-Lom sitakanaviys sitovek; takanaviy tasiyas mina-Italiy. ");
INSERT INTO myw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","3","Taw towen ansinap bwein, siney angamag ivna̱ses Yowbad; tuta babaw isiwa̱youb gamag wasigeis. E, tuta babaw initoug Yowbad waseg. Kweitan yam, kwayav waseg, igawa ininitoug, ikin magina gum-liba̱lab teitan imek, idibek, ilana, “Koniliy.” ");
INSERT INTO myw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","6","Iggintov, ivag anpwa̱yat, mo ilivan, ilana, “O guyaw, aveiyag sivinam?” Gum-liba̱lab mo ilivan, ilana, “Peinan munitoug babaw, sona musiwa̱youb wasigeis tasimavs, mapuna Yowbad mo inuweim ya̱koum. Tut towen bweina kwayabes mugwamag mwasanin bineis Yop, bidibakes Saymon beim. Mtowen Saymon, yagan kwayuwein Pita, nises valeyin Saymon wanbunatum, towen tawtelein kaleivin man; nabunatum wakawalaw nises.” ");
INSERT INTO myw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Anelos ilivan ikous, inoun, in; Koniliy mo idawes nagamag asteitoun; tawwotets wanuwan nabunatum asteiy, sisiy natakanaviy tatanok. Takanaviy towen ansinap bwein, tuta babaw iwotet natovek waseg, mamagina takanawein aygan. Anelos anilivan ikatipel isekes ikous, mo ikayabes bineis kid Yop. ");
INSERT INTO myw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Iyam-nen, ya̱nay waseg, igawa wa̱ked inounas, ineis kadilakusan ven towen Yop, Pita mo imwen wakunuwatan bunatum silma̱nin binitoug waseg Yowbad. Peinan sibunatum mamanas kunuwatan. ");
INSERT INTO myw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita ivag anamoun, sivinan beikam. Igawa ikaleibwans wabunatum, matan makava isisawl, ikin magina youd kweitan. ");
INSERT INTO myw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","E, ikin liba̱lab itavis, o mamagin kweim avakaein, matan palavas vatul iyawanis mo ikaygwagwes, italaves vatul waseg ee... in, iton watinow. ");
INSERT INTO myw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wanuwan kweim towen man babaw nisesus, mansiyas inounas wapwepway kikeis waseg, o mansiyas itatets wapwepway o mansiyas sam pinpineis iyoyows wanakaew. ");
INSERT INTO myw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita ikin, mo iligen aygan teitan, ilana, “Pita, kun, kuweiy mansiyas man va̱gan bukukwam.” ");
INSERT INTO myw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita ikatimop aygan, ilana, “O Guyaw, adok nag, ta-ma̱wan ba̱kam man tasiyas, bwaboum. Kweiboug nag; adok nagein-vak nag.” ");
INSERT INTO myw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Vayuwein mo ilivan, ilana, “Magat Yowbad bivag bwein, bo bwein; awoum kupiyev; awoum kulana, ‘Bwaboum;’ awoum.” ");
INSERT INTO myw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Siva̱toun ivag ma̱wan, youd towen mo iyum in walba̱lab. ");
INSERT INTO myw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Igawa Pita ininuway, ilana, “Aveiyag silawun youd towen nakin?” Koniliy nagamag tasiyas mo isaps, ikatugwans wasigeis mwasanin gamag, ilansa, “Avanuy Saymon nabunatum?” Tasiyas mo ikatimlakes nabunatum mo ineis bunatum towen waseg. E, itamanaws wakoukwed, ikatugwans, ilansa, “Tabta amibwabwal mtowen Saymon Pita, ne?” ");
INSERT INTO myw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Pita, igaw wanakaew, ininuway waseg youd towen mwana nikin, Yowbad Kululuwan mo ilana, “Kutamanaw. Gamag mwasanin watinow nisesus, inineveims ya̱koum. Kun, kunekes, mo simwey tasiyas kunounas; awoum nuwam bikubukub, peinan yey tatoneig nakayabes nimeis.” ");
INSERT INTO myw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita mo ibus, inekes, ilana, “Yey-yaya, kunneveigs. Aveiyag wawun nukumeis?” ");
INSERT INTO myw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ilivans, “Matovek teitan takalikay, ansinap kamnat, tuta babaw igoul Yowbad aygan, o min-Yudiy babaw ikakinsa ansinap bwein. E, Yowbad nataka̱yob bo idibek matovek, ilana, ‘Kudow Saymon Pita beim wambunatum, anilivan kuligen.’ Mapuna nikayabem nakam.” ");
INSERT INTO myw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ilana, “Bwein, kumeis wabunatum kumasis, peinan bo ikwayav. Nubweig mo tanounas bitaneis.” Iyam nen mo ineis, sisiyas tayakelesiys mina-Yop mwasanin. ");
INSERT INTO myw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Akweiy yam mo isaps Sisaliy. Koniliy bo inmis Pita bo beim, mapuna mo idawes taliven sisiyas ansinva̱lams nikatuyouns nimeis. ");
INSERT INTO myw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita mo isap wanbunatum towen, Koniliy inek Pita, ikulul wamatan. ");
INSERT INTO myw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tage Pita bo iyous wanaman itamnow, ilana, “Awoum kukulul wamatag, awoum; yey gamag ma̱wana yak.” ");
INSERT INTO myw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Igawa ilivans son Koniliy, isiws wanuwan bunatum, Pita mo iban gamaga babaw, nisinkunouks wabunatum nisesus. ");
INSERT INTO myw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","29","Pita mo ilivan wasigeis, ilana, “Kukwakins gum-Yudiy nag bimek tobwag ven gimgeilin, nag bilakwen, nag bikaypuls son; bwaboum. Tage tut towen agumikon waseg, Yowbad bo ikatimlakeig bweina banekes tobwag ven gimgilis; awoum badok bwaboum. Mapuna nukudaweigs nam, nag apiyev. Kadiloka kudibakeigs wawun nukudaweigs nam.” ");
INSERT INTO myw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","32","Wankuyeim Koniliy mo ilivan, ilana, “Yam kweivas nein wankuyeim, kwayav waseg, ka̱las itageg, ma̱wana tut towen nagein; e tutan nitoug kwayav yam towen waseg, yey ases wagunbunatum anitoug waseg Yowbad. Igawa aninitoug mo akin taw teitan itamanaw wamatag, anakweim gimagim seikwan. Taw towen mo ilivan ilana, ‘Koniliy, peinan munitoug babaw, o peinan musiwa̱youb babaw wasigeis tasimavs, Yowbad bo inuweim yak. Tuta towen kwayabes mugwamag mwasanin bineis Yop, bidibakes Saymon beim. Mtowen kwayuwein yagan Pita; valeyin anbwabwal nisesus son. Valeyin tawtelein kaleivin man; nabunatum wakawalaw-o nises.’ ");
INSERT INTO myw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Mapuna akatima̱les gungamag mwasanin, niwekeims, o bo ikalin nuwag ya̱koum peinan nukum. O tut towen yakamey babaw wamatan Yowbad nakases, sivinem bakaligen daGuyaws nakaleiwag; aveiyag nidibakeim yak, kwatipel babaw kusekem.” ");
INSERT INTO myw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Pita mo isilamaw anilivan, ilana, “Mounid akakin wamatan Yowbad gamaga babaw ya̱kids katanok-wan; o vena babaw gimgilis toubweins, kukin bivna̱ses Yowbad, Yowbad mo bikalin nuwan gamag tasiyas wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“O Yeisuw Kelis, gamaga babaw daGuyaws towen. O Yowbad bo isek anilivan bwanabwein silma̱nin min-Yisleil yakamey, va̱gan beitaw nuwem. ");
INSERT INTO myw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","“O yakamiy kukwakins liva̱nen gum-Nasalet towen Yeisuw; e, kweiboug Yon nigeiguy, nibapta̱yses gamag, wankuyeim Yeisuw isilamaw nageiguy Galiliy, ininoun in vena babaw Yudiy wasigeis; liva̱nen Yeisuw vena babaw ibekena, peinan Yowbad natawtoun iligob Yeisuw waseg, magina Kululuwan Towen Bwanabwein inek; mapuna ininoun ililabesa gamag babaw, o tasiyas Seitan niyagages, ilivan mo ibweins, peinan Yowbad son. Liva̱nen towen kukwakins-wan. ");
INSERT INTO myw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“O yakamey nakakin youda babaw nivvag vena babaw wanuwan Yudiy, o Yelusalem waseg; mo iweiys ikatikavates wakamweilok. ");
INSERT INTO myw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","42","“Yam kweitoun Yowbad ivag, mo itamanaw vayuwein; gamag mo ikinbunikes. Tage gamaga babaw nag ikines; misinaka yakamey, kweiboug Yowbad nikatigikem takawein bulagan Yeisuw yakamey; bo nakakin neimov vayuwein; simey naka̱kam; simey naka̱moum; mo isekem mawotet va̱gan bakageiguy gamag wasigeis. E, kaggeiguy va̱gan gamag bikakins Yowbad nikatigik Kelis towen igaw mo bikaleiwag va̱gan bimop asisinap tamwamovs sisiyas takanigs. ");
INSERT INTO myw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","“O towen Kelis, palopit tasiyas kweiboug nilivnakes towen tawidin sinap kalbaleb wasigeis tasiyas kalisiy bisimounids yagan waseg.” ");
INSERT INTO myw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita igawa illivan anilivan towen, Yowbad Kululuwan mo inekes tasiyas taliganeins livan towen. ");
INSERT INTO myw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","47","O min-Yudiy tayakelesiys tasiyas sisiy Pita nimeis bo isom ninous, peinan ikines Yowbad isiwyoubus tobwag ven gimgilis, Kululuwan Towen Bwanabwein bo ininekes tasiyas asibabaw-wan. Ikines tasiyas singaya iyakawanes Yowbad, o ilivans kaeig kweitan kweitan wasigeis, peinan Yowbad Kululuwan nises wasigeis tasiyas. Min-Yudiy tasiyas bo iliganes siya̱kawn o sikapleon amav, mapuna Pita ikatiga̱nes, ilana, “Kal bisilbwed sibaptays tasiyas? Tago-ma̱wan bitasilbwed. Bweina bitabapta̱yses peinan Yowbad Kululuwan bo inekes, ma̱wana ya̱kids kweiboug.” ");
INSERT INTO myw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pita mo ikaleiwag bibapta̱yses kid Yeisuw Kelis yagan waseg. Sibaptays ikous, mo ilivans, ilansa, “Simayas yakamiy bweina tasesus, igaw yam mwasanin waseg mo bukuyums.” ");
INSERT INTO myw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yudiy waseg, takaweins liva̱nen Yeisuw sisiyas tayakelesiys bo iliganes sinap towen, mamagina tobwag ven gimgilis bo itimakes Yowbad anilivan. ");
INSERT INTO myw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Iyum Pita in Yelusalem, tayakelesiys tasiyas Yowbad nakabivatus wasigeis, mo ivtokes livan Pita, ilansa, “Ya̱koum bo kunekes tasiyas nag ivag Yowbad nakabivatus? Kwamtans simwey, ne? Bo igak!” ");
INSERT INTO myw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Pita mo ita̱kud liva̱nen nawotet towen, mamagina; “Yey nases Yop, anitoug Yowbad waseg; matag makava isisawl, kweitan youd akin, mamagina kweim avakaein, vatul iyawanis kweim to matan palavas, mo italaves ee... in iton watinow, wamatag-wan. ");
INSERT INTO myw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","“Yey akinbunik, wanuwan kweim man babaw, mansiyas sam kikeis inounas watinow, o mansiyas bulawud kawka̱vek, o mansiyas ta-ivag nimes tage itatets wapwepway, o mansiyas sam pinpineis iyoyows wanakaew. ");
INSERT INTO myw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Wankuyeim mo aligen aygan teitan idibakeig, ilana, ‘Pita, kun, kuweiy mansiyas man silma̱nin bukukwam.’ ");
INSERT INTO myw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Yey akatimop livan towen, alana, ‘O Guyaw, ta-ma̱wan ba̱kam mansiyas man, bwaboum. Kweiboug nag. Adok nagein-vak nag.’ ");
INSERT INTO myw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Vayuwein aygan towen, liba̱lab waseg, mo ilana, ‘Magat Yowbad bivag bwein, bo bwein; awoum kupiyev; awoum kulana; “Bwaboum.” Awoum.’ ");
INSERT INTO myw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Siva̱toun ivag ma̱wan, youd towen mo iyum in walba̱lab. ");
INSERT INTO myw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Misumkwey towen tawaw teitoun mo itamanaws wawkwedan bunatum towen nakasikey-yay; peinan gum-Sisaliy nikayabes nimekeigs. ");
INSERT INTO myw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Yowbad Kululuwan mo idibakeig, ilana, ‘Simwey tasiyas kunounas; awoum bisunasun nanoum; bwein-wan.’ Sigwey tayakelesiys asteinim tatanok, tasiyas-nan, nakan, ka̱siw taw towen wanbunatum. ");
INSERT INTO myw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","“Towen Koniliy nidibakem ilana, ‘Akin gum-liba̱lab nitamanaw wagunbunatum, ilana: “Kwayabes mwasanin gamag bineis Yop bidawes Saymon Pita beim; mtowen Pita mo bisekeimiy sinap bwanabwein; e, sinap to waseg, Yowbad mo bikatinabweimiy simwey tasiyas mugwamag wambwa̱bwan nisesus.”’ ");
INSERT INTO myw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Asilamaw agulivan wasigeis tasiyas, Yowbad Kululuwan mo inekes tasiyas, ma̱wana ya̱kids kweiboug. ");
INSERT INTO myw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","“Wankuyeim mo anuw daGuyaws anilivan mamagina, ‘Yon bo ibaptays soup waseg, tage yakamiy igaw Yowbad mo bibapta̱yseimiy Kululuwan Towen Bwanabwein waseg.’ ");
INSERT INTO myw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Wanmugwana ya̱kids nitasimounids daGuyaws Yeisuw Kelis waseg, mo isiwyoubuds Yowbad Kululuwan waseg; tut towen mo isiwyoubus tasiyas ma̱wan. Yey ta-ma̱wan bavkek basilbwed Yowbad nawotet.” ");
INSERT INTO myw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Min-Yudiy tasiyas iliganes Pita anilivan, ta-ma̱wan bikatimapus aygan. Tage ikavasisa Yowbad, ilansa, “Tage Yowbad bo isiwyoubus tobwag ven gimgilis, va̱gan asisinap kalbaleb bilavewas, mo sona simwamov bisigagas.” ");
INSERT INTO myw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kweiboug tanuwgwes-lun neiweiys Sitiben, ikous, mo iyablebes tayakelesiys Yelusalem waseg; mapuna igayays, mwasanin ineis Pinisiy, mwasanin ineis Saypilos, mwasanin ineis Antiyok; vena babaw waseg ikatpeles liva̱nen Yeisuw, tage misinaka isekes min-Yudiy tasiyas nikoulups nisesus ven wunsiyas; nag isekes livan towen gamaga babaw wasigeis, nag. ");
INSERT INTO myw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tage sisiyas tasiyas min-Saypilos mwasanin o min-Saylin mwasanin ineis Antiyok mo isekes Guyaw Yeisuw liva̱nen bwanabwein, mina-Gilis wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O peinan Yowbad ilabes, babawa gamag ikanavin ninous; mo isimounids Yeisuw waseg; mo ikatimweisis singaya babaw gamag. ");
INSERT INTO myw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tayakelesiys tasiyas nisesus Yelusalem iliganes, mapuna ikayabes Ba̱nabas bein kid Antiyok. ");
INSERT INTO myw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Towen Ba̱nabas isap, ikakin Yowbad singay isiwa̱youb wasigeis tasiyas, mapuna ikalin nuwan avakaein; e, idibakes gamag tasiyas, ilana, “Kadiloka kusimkines, kutoukums daGuyaws inawotet waseg.” ");
INSERT INTO myw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mtowen Ba̱nabas gimgilitoun towen, singaya isimounid Yowbad waseg, o itawtoun, peinan Kululuwan Yowbad son nisesus. Misiya̱mun towen Yeisuw nagamag ikatimweisis; bo ibabaw. ");
INSERT INTO myw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Wankuyeim Ba̱nabas in Talisus inineiv Soul, iban, mo itok; asteiy mo iyums ineis Antiyok. Nisesus Antiyok bweilim katanok, sitapwa̱loul waseg bo ikatimlakes tayakelesiysa babaw. Wanmugwana Antiyok waseg idokes magawen yeg Kelistiyan mo idawes tayakelesiys yiges tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Misumkwey towen palopit mwasanin meinoy nimeis Yelusalem, imeis isaps Antiyok. ");
INSERT INTO myw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Teitan yagan Agabous; Kululuwan Yowbad ikatipel ansinap isek mtowen Agabous, mo itamanaw ilivan, ilana, “Kadilakusa bo bitalivatus tut kalbaleb, vena babaw wasigeis, peinan nag beikweis kweis, o nag beivag kan.” Magina bo ilivnek livan towen. E, anatut Kalodiw nakaleiwag waseg mo ikamat youd towen. ");
INSERT INTO myw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mapuna tayakalesiys Antiyok waseg, tasiyas sam sivavag, idokes kid katanok katanok bimulouls; o muloul towen igaw mo biwyabes va̱gan bilabes tayakelesiys tasiyas Yudiy nisesus. ");
INSERT INTO myw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Imulouls ikous, mo isekes Ba̱nabas son Soul, ikawes, inawes Yelusalem, silma̱nin tayakelesiys situwa̱veks ven towen waseg. ");
INSERT INTO myw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Misumkwey towen King Elod iyousis tayakelesiys mwasanin va̱gan kid biyagages. ");
INSERT INTO myw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","3","Yemes, mtowen Yon tuwan, bo ibob kayon, pulut tanmunum waseg. Mapuna ikalin nuwes tasiyas min-Yudiy. O peinan ikalin nuwes, Elod mo iyous Pita, wik towen waseg min-Yudiy nag beikams bled son yist, bwaboum. ");
INSERT INTO myw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","E, iyousis Pita, inawes wa̱deil, Elod siwotet isekes natakanaviys va̱gan bimtakavates Pita, natakanaviy tasiyas babiweis sinawatan teinim tatanok. Wananon idok, igaw beikous sagal towen yagan Kaltuwon, mo bitok Pita bisekes min-Yudiy va̱gan kid biyateles. ");
INSERT INTO myw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Igaw Pita nises wa̱deil, tayakelesiys singay ikalin nuwes, initougs, igilagels Yowbad waseg, va̱gan kid bileb towen Pita. ");
INSERT INTO myw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pita nises wa̱deil yam mwasanin ikous, Elod idok yamtan yam mo biya̱tal waseg. E, bo iboug, Pita imasis wanuwein takanaviys, teitan palatan, teitan palatan, immasis, o sen bo iyawanis naman Pita, walitan palatan, walitan palatan; o takanaviys mwasanin itamanaws wakoukwed, imtakavatays deil towen. ");
INSERT INTO myw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","8","Igaw immasis, Yowbad nataka̱yob isap, itamanaw wadadan Pita; mititeilin im imteil nuwan bunatum. Gum-liba̱lab towen im igipit Pita waviligan, iwgun, ilana, “Kutamanaw! Nuwanaw!” Anasen tatonen mo ikabilow wanaman. Mo ilana, “Amuwat kuyawen, musandol kuvaligev.” Ivag ma̱wan, mo ilivan, ilana, “Amukweim kusikam, mo kum kwabkunig yey.” ");
INSERT INTO myw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nuwanawa inek, ikabkun; ineis; nag isimounid waseg youd towen gum-liba̱lab nivag; idoki mamagina matan isisawla mav. ");
INSERT INTO myw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Isaps koukwed kweitan, iwekes takanaviys nisesus; isiws isaps koukwed kwayuwein waseg, iwekes takanaviy nisesus; isiws isaps koukwed avakaein waseg, tanmunum; tatonen ikaliyow, mo isaps wavtakon ven; e inounas wavtakon ven, gum-liba̱lab nuwanaw mo inoun in. ");
INSERT INTO myw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Wankuyeim Pita mo ikakin, ilana, “Bo akakin mounid daGuyaws nikayeb gum-liba̱lab towen nikatinabweig Elod waseg, isilbwed gog asisinap waninous tasiyas min-Yudiy takalbalebs.” ");
INSERT INTO myw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nanon idumwal ma̱wan, mo inoun in Meliy wanbunatum, mana̱wen Yon inan, Yon yagan kwayuwein Mak; o bunatum towen waseg, babaw gamag nikatuyouns nimeis innitougs Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","14","Igipit wakoukwed; nakubukwab nawwotet, yagan Lod, mo in ilivan, “Kal yak kuggipit?” Iligen aygan Pita, sona namwa̱saw isiwlayum; nag ikaliyow koukwed, isawl in wanuwan bunatum, ilana, “Pita bo isap, nitet watoulan.” ");
INSERT INTO myw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ilansa, “Adok nakabala̱wein yak.” Iw mana̱wen, ilana, “Mounida Pita nises.” Mo ilansa, “Adok aluwan-nan.” ");
INSERT INTO myw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Igaw Pita iggipit, mo ikaliyowes koukwed, ikines Pita; singaya bo isom ninous. ");
INSERT INTO myw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tage Pita naman itamnow, ikatitun asilivan, mo ita̱kud ma̱wan siGuyaw nikatinob wa̱deil, mo ilana, “Kudibakes Yemes sen nagamag,” mo inoun in kweitan ven. ");
INSERT INTO myw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Iyam ga̱boug mo ivag mouvit wasigeis takanaviys siyas, peinan nag iba̱nes Pita. ");
INSERT INTO myw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elod siney natakanaviys mo inineivs Pita; inineivs, bo nag. Mapuna iyateles natakanaviys, ikaleiwag mo ikatimates tasiyas. Wankuyeim mo ilisow Yudiy, iwloubus in Sisaliy, nisikey-yay. ");
INSERT INTO myw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elod singay ikawkunes min-Ta̱yil sisiy min-Sidon; o tasiyas sivines beimwas, mapuna isineikimas; wanmugwana imwas waseg Bilasit, mtowen nawotet King Elod wanbunatum; wankuyeim asilivan mo ikow isek King Elod va̱gan kid beimwas siney tasiyas. Iva̱ges ma̱wan peinan niggimweles kaeis Elod waniven. ");
INSERT INTO myw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Elod ikatigik siyam, ilana, “Yam towen waseg mo kumeis.” E, imeis, mo isap wamtes gamag tasiyas; bo isikam King kweiman, singay maynamnabwein, isin wakaban, mo iliwon wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Illivan ikous, mo iwaks, ilansa, “Nag kweitan gamag aygan ma̱wan; towen mamagina yowbad aygan.” ");
INSERT INTO myw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nuwanaw Yowbad nataka̱yob mo iweiy King towen, peinan iba̱kew Yowbad yakawanan; ikasimwa̱mwat nuwan, mo ikanig. ");
INSERT INTO myw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Wankuyeim babaw gamag mo iliganes Yowbad aygan, vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","O peinan siwotet bo ikous, Ba̱nabas son Soul mo ilisawes Yelusalem, sisiy itokes teitan gamag yagan Yon, yagan kwayuwein Mak. ");
INSERT INTO myw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ven Antiyok waseg, tayakelesiys wasigeis palopit mwasanin nisesus, o mwasanin takatimlakeins Yowbad nakaleiwag. Teitan yagan Ba̱nabas; tayuwein Simiyon, mtowen yagan kwayuwein Wobug; tatounun gum-Saylin yagan Lukiyos; tavasin Manen, son Elod asibweilim katanok-wan, kweiboug niskuls son towen, min-Galiliy siguyaw avakaein Elod; o tanimen yagan Soul. ");
INSERT INTO myw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tasiyas ivna̱ses Yowbad nawotet, ipsapos silma̱nin; Kululuwan Towen Bwanabwein mo inekes, ilana, “Kadiloka kuta̱mes Ba̱nabas son Soul silma̱nin wotet kweitan bakatigik siwotet.” ");
INSERT INTO myw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mapuna ipsapos innitougs Yowbad waseg, mo isenas nimes wawous tasiyas, ikayabes silma̱nin wotet towen. ");
INSERT INTO myw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Peinan Yowbad Kululuwan nakaleiwag ma̱wan towen, bo ikayabes, iwloubus, ineis Selusiy, itouws wa̱wag, ikuks ineis Saypilos. ");
INSERT INTO myw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ineis wanakaew ven yagan Salamis, mo igeiguys Yowbad anilivan, min-Yudiy sisinagog nisesus ven kweitan kweitan wasigeis. Sisiy Yon, mtowen illabes. ");
INSERT INTO myw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Sim towen ikanpeles, isaps palatan, ven yagan Pepos, mo ilouvats sisiy tamgameg teitan, gum-Yudiy, yagan Ba̱yosuw; gamag babaw idokes palopit teitan; nag gog, tayyaweid. ");
INSERT INTO myw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","8","Gabman-nen ven towen, yagan Segipawl, tassinap teitan. Mtowen Ba̱yosuw son Segipawl nisesus. Segipawl idawes Ba̱nabas son Soul bimeis, sivinan kid biligen Yowbad aygan, tage tamgameg towen Elaymas idoki bisilbwed; nag sivinan gabman towen biligen Yowbad nakaleiwag. (Yagan Ba̱yosuw takativin bein kaeig kweitan Elaymas.) ");
INSERT INTO myw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Mapuna Soul, nidokes yagan piniyuwein Pawl, bo itawtoun singay, peinan son Kululuwan Yowbad, ikinbunik tamgameg towen, ilana, “Seitan natun ya̱koum, singay takalbaleb o tayyaweid yak; tuta babaw kusilbwed sinap bwein, tuta babaw sivinam Yowbad inaked bukukididog. ");
INSERT INTO myw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","“E, tut towen Yowbad bo beiweiy matam; tut mwasanin nag matam beikin ka̱las mititeilin, peinan bo beikaw matam.” Nuwanawa matan mo ikaligwen, wankuyeim mo ikaw singay dadub. Ininoun, inineiv kavel biyous naman va̱gan bitok, peinan ta-ma̱wan bikin inaked. ");
INSERT INTO myw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gabman towen Segipawl ikin wotet towen, mo isimounid Yowbad waseg; iligen daGuyaws nakaleiwag, waseg isom nanon. ");
INSERT INTO myw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pawl siney nagamag mo ikuks, ilisawes Pepos ineis Pelig, wawnuwan ven avakaein Pampiliy; tage Yon ilisawes, iyum in Yelusalem. ");
INSERT INTO myw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","O tasiyas ikanpeles Pelig ineis Antiyok, ven Pasidiy waseg; isaps ven towen; Sa̱dad waseg mo isiws wanuwan sinagog, tapwa̱loul silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tapwa̱loul waseg ivinis Bukitab, Moses nakaleiwag kweitan yageivein o palopit asilivan kweitan yageivein; ivinis ikous, mo tanuwagan sinagog idibek teitan ikatugwan wasigeis Pawl son Ba̱nabas, ilana, “Sigwey yakamiy, kukin amisinap nises, kadiloka kugeiguys gamag babaw wasigeis.” ");
INSERT INTO myw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pawl mo itamanaw, itamnow naman, ilana, “Min-Yisleil yakamiy, o tagouluns Yowbad yakamiy, kunages agulivan. ");
INSERT INTO myw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","“Min-Yisleil ya̱kids, daYowbads bo idawes tamumwey, igawa nisesus Yidipt; e, ilabes mo itawtounsa singay; o natawtoun waseg imgwayes, mo isaps va̱gan bineis kid wasiven tatineis. ");
INSERT INTO myw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","“Wankuyeim sinawavas bweilim wanawoud mo imgwayes tasiyas, o singay moumouvit, peinan tuta babaw takakons tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","“DaYowbads mo iweiys ven kweinim kweiy, Kenan wawnuwan. Yowbad nisekes tamumwey sipwepway towen; e nisesus ven towen bweilim babaw, lakatuvas sinawanim bweilim. Wankuyeim mo isekes situwa̱vek va̱gan bikaleiwags wasigeis. Tasiyas ikaleiwags bweilim babaw ee... mo isilamaw nakaleiwag palopit towen Samwel. ");
INSERT INTO myw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Wankuyeim mo ivag sivines siking kid beivag; initougs waseg Yowbad, mo isekes siking teitan, Kis natun yagan Soul, anakum Binyamin, anbweilim sinawavas. ");
INSERT INTO myw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“Wankuyeim Yowbad mo ipiyev king towen Soul; siking kweivaw mo ikatipel isek mtowen Deibid. Liva̱nen Deibid Yowbad nilivan, mamagina, ‘Bo aban Desiy natun Deibid, ikalin nuwag waseg; mtowen biwtel youda babaw ma̱wana nanoug yey.’ ");
INSERT INTO myw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“O ma̱wana Yowbad kweiboug-o nilivnek; tut towen bo isek Deibid tabun nawotet va̱gan bikatinabweids min-Yisleil ya̱kids. O Deibid tabun towen yagan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Yon bo ikidumwal ked wamatan Yeisuw, inageiguy min-Yisleil babaw wasigeis, va̱gan bilaves kid asisinap kalbaleb, mo bibapta̱yses. ");
INSERT INTO myw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","“Yon nawotet iyakous, mo ilivan mamagina, ‘Kuninuways kavel yey. Yey nag Kelis mtowen kukwayamats, nag. Tage watibweloug teitan bo beim; nag kadilokeig bakulul wamatan va̱gan bakablev nasandol, nag. Peinan towen guyaw avakaein.’ ");
INSERT INTO myw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Sigwey, Ebelam tibun yakamiy, o kalisiy yakamiy kugoulus Yowbad, anilivan bo isekeimiy va̱gan bikatinabweimiy. ");
INSERT INTO myw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","“O min-Yelusalem sisiyas situwa̱veks nag bikakins mtowen Yeisuw bikatinabweids; o nag bikakins palopits asilivan Bukitab wanuwan. Asilivan tasiyas Sa̱dad katanok katanok, tapwa̱loul waseg, ikatilutegsa mav tage nag bikakins silawun. Mapuna mo iyateles mtowen Yeisuw; o ma̱wana nikatigik kweiboug-o liva̱nen Yeisuw, Bukitab waseg, nagein gog mo ikamat liva̱nen ma̱wana nilivnek. ");
INSERT INTO myw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“E nag iba̱nes ansinap kalbaleb va̱gan beiweiys, tage bo initougs takaleiwag towen Paylat bikatimet kid. ");
INSERT INTO myw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“E liva̱nen babaw nises Bukitab wanuwan, mo iwteles ma̱wan; e, imat, ikaygwagwes wakamweilok ee... inibwis, mo ikawes inawes, isewas watakunumwan. ");
INSERT INTO myw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Yowbad mo iyakit, itamanaw vayuwein. ");
INSERT INTO myw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","“Tasiyas kweiboug sisiy Yeisuw nitanouys ven Galiliy waseg ineis Yelusalem; e, tasiyas yam babaw ikines Yeisuw, bo imov. Asilivan tasiyas mo isekemas yakamey, o isisekes-vak gamag babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“O livan towen bwanabwein kasekeimiy yakamiy, o youd towen kweiboug-o Yowbad nilivnek tamumwey wasigeis. O nagein gog youd towen bo ikamat wasigeis ya̱kids, tamumwey tibsiyas ya̱kids, peinan Yeisuw igawa wakanig nises, Yowbad mo iyakit vayuwein. Liva̱nen nises Sam kwayuwein waseg, mamagina: ‘Ya̱koum natug yak. Nagein mo nukumlavag natug.’ ");
INSERT INTO myw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Igawa wakanig nises bo ikit; nag bikanig vayuwein, nag. Won nag beipwas, nag. Liva̱nen nises, Yowbad anilivan mamagina: ‘Gunasiwa̱youb waseg Deibid, tage igaw mo basekeim yak.’ ");
INSERT INTO myw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“E, livan nises kweitan Sam waseg, mamagina, ‘Mugwamag towen kukwayus, nag bukutam won beipwas, nag.’ ");
INSERT INTO myw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Deibid inatut ven watinow waseg, bo ikokew Yowbad nakaleiwag; mo ikanig, inekes timen, won tonen bo ipwas. ");
INSERT INTO myw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","“Tage Yeisuw won nag ipwas, peinan Yowbad bo iyakit vayuwein. ");
INSERT INTO myw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“O sigwey yakamiy, kunages amalivan, kadiloka kukwakins towen anmwa̱net biwid adsinaps kalbaleb. Adsinapsa babaw, Moses nakaleiwag waseg na-ikadilok biwid; tage kukin bitasimounids waseg Yeisuw, mo biwid adsinaps kalbaleb, babaw-wan; Yowbad mo binumlev, beikous. ");
INSERT INTO myw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","“Palopit kweiboug-o anilivan mamagina: ‘Tayyagays yakamiy, kukines gunawotet, beisom ninoumiy, mo bukumta̱mats. Peinan mitut waseg gunawotet bawtel; gamag mwasanin bikatimlakeimiy gunawotet towen, tage nag bukusimounids; nag.’ E, palopit anilivan mamagin. Kadiloka kuvna̱seimiy, mata ge tut wanakougwaw livan towen bikwaneimiy.” ");
INSERT INTO myw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pawl nageiguy ikous, isaps wamnat, gamag babaw mo initougs wasigeis, sivines kwayuwein Sa̱dad mo bisekes livan towen. ");
INSERT INTO myw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ikous tapwa̱loul, sinagog towen waseg, gamag babaw bo ikabwa̱kuns wasigeis Pawl son Ba̱nabas, min-Yudiy babaw, sisiyas tawaw tadidumwals mwasanin, tasiyas kweiboug nikawes min-Yudiy asisinap. Pawl son Ba̱nabas mo ilivans wasigeis tasiyas, iguyes silma̱nin bisimkines Yowbad nasiwa̱youb waseg. ");
INSERT INTO myw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Katanok wik ikous, Sa̱dad waseg, ven towen gimgilis babaw ikatuyouns nimeis, sivines kid biliganes liva̱nen Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tage Yudiy gimgilis, ven towen waseg, bo igeg ninous, peinan gamag babaw sivines biliganes anilivan Pawl, mapuna ikamnimans sisiyas Pawl nagamag, sona siyagay. ");
INSERT INTO myw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pawl son Ba̱nabas mo iwons, ilansa, “Kadilok wanmugwana bakasekeimiy Yowbad liva̱nen. O peinan kupiyaves livan towen, o peinan kupiyaves ked silma̱nin mwamovamiy nag beikous, takaleiwagsa yakamiy. Adok livan towen bo bakasekes tobwag ven gimgilis wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“DaGuyaws nikalawagem ma̱wan, peinan Bukitab waseg anilivan nises mamagina, ‘Bo akalawageim, vena babaw sikamnat ya̱koum; Va̱gan bukuymoves vena babaw gimgilis wadaban pwepway.’” ");
INSERT INTO myw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Vena babaw gimgilis iliganes Pawl anilivan towen, bo imwa̱saws; ikalin nuwes Yowbad waseg, anilivan towen silma̱nin. O peinan Yowbad nikaleiwag mwasanin son simwamov mo bisigagas, tasiyas bo isimounids Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gamag tasiyas mo ikawes liva̱nen Yowbad, inawes vena babaw wasipalatan. ");
INSERT INTO myw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tage min-Yudiy bo ikamliwes Pawl son Ba̱nabas, mo ivtokes livan. Mwasanin iliganes asilivan, guyvinay siyas nasiwa̱youbs, sisiyas tamumwey mwasanin; wankuyeim mo iva̱ges asisinap kweitan, ipiyaves Pawl son Ba̱nabas, iyagages; ikayabes kid bineis kweitan ven. ");
INSERT INTO myw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tage tasiyas Pawl son Ba̱nabas ikatsapis kikeis, musamusan ven towen waseg, peinan ipiyaves ven towen gimgilis. Tasiyas mo inounas wa̱ked, ineis Ikoniyam. ");
INSERT INTO myw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tasiyas gog nikawes liva̱nen Yeisuw bo imwa̱saws, peinan Kululuwan Yowbad sisiy tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ma̱wana ven towen nilisawes, ma̱wana ven towen Ikoniyam waseg, isiws wanuwan min-Yudiy sisinagog, igeiguys; e, tasiyas min-Yudiy o mina-Gilis, tabebaws-wan, mo iliganes asilivan tawaw tasiyas asteiy. ");
INSERT INTO myw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tage min-Yudiy mwasanin ipiyaves asilivan, ivtokes livan; mapuna tobwag ven gimgilis ikanavin ninous mo ikamliwes Yeisuw nagamag. ");
INSERT INTO myw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Isesus ee... imwemway-nen; e, illivans liva̱nen Yeisuw nasiwa̱youb; nag iwenes gamag, nag. O Yeisuw bo ilabes, siwotet tawtoun mo iwteles, wayagan Yeisuw; magina naman mulin Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gamaga babaw ven towen waseg mo ilivis, mwasanin ilabes Yudiy gimgilis, mwasanin ilabes takaweins liva̱nen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wankuyeim tasiyas tapiyaveins livan towen mo isilamaws sinap kweitan. Min-Yudiy mwasanin, sisiyas vena babaw gimgilis, sisiyas ven towen gabman-nen, asibabaw idokes biyagages Pawl son Ba̱nabas, beiweiys dakul waseg, bikatimates kid. ");
INSERT INTO myw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Tasiyas Pawl son Ba̱nabas bo iliganes livan towen, mo isawls ineis Lisitil o Da̱biy o vena babaw wawnuwan ven avakaein Lakeyoniy; mo igeiguys liva̱nen Yeisuw, vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Taguya̱gwey teitan isin ven Lisitil waseg, kaken paleyuna ipam; ta-ma̱wan binoun. Igaw-o inan nikopweyay ma̱wan-wan. ");
INSERT INTO myw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Pawl isap, ilivan gamag babaw wasigeis, o taw towen iligen. Pawl mo ikinbunik taw towen, ikakin inanamis nises waseg Yeisuw va̱gan bivag kid mo beibwein; mapun mo ilivan, aygan avakaein, ilana, “Kutamanaw, kutadamoms;” taw towen mo ipel, itamanaw, inoun. ");
INSERT INTO myw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gamag babaw ikines Pawl nawotet towen, mo iwaks, aga-Lakiyoniy waseg, ilansa, “Dayowbads bo imlavags gamag, bo ibus, ilakewaneids ya̱kids gamag ven watinow.” ");
INSERT INTO myw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba̱nabas idokes Yupit, peinan siyowbad yagan Yupit; Pawl idokes Makiyul, peinan talliwon. ");
INSERT INTO myw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","E, tanuwagan lun silma̱nin Yupit nises ven towen, o lun buntuman nises ven towen koukwed wadadan. Towen ivaniyel asipay bulumakaw wasigeis, mo itokes, sivinan kid beiweiys bulumakaw mansiyas, va̱gan gog beiluns wasigeis Ba̱nabas son Pawl, o gamag babaw ninous bo ma̱wan, bo bilabes tanuwagan lun. ");
INSERT INTO myw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Tasiyas Pawl son Ba̱nabas iliganes, mo isiledes asikweim, peinan singaya igeg ninous, mo isawls, inekes gamag babaw. Ages avakaein ilivans, ilansa, “Tawaw yakamiy, awoum kuva̱ges ma̱wan. Yakamey gamag ma̱wana yakamiy gamag; sinap bwanabwein bakasekeimiy va̱gan gog bukulavewas makava sinap towenan. Kadiloka kumekes Yowbad towen tamwamov, tabunin liba̱lab, o pwepway, o yol, o youda babaw waseg. ");
INSERT INTO myw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","“Tut kweiboug Yowbad ita̱mes vena babaw gimgilis binoyes siked tatineis. ");
INSERT INTO myw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","“Tage peinan Yowbad sivinan bukukwakins kid ansinap bwanabwein, nissekeimiy kweis o kaeimiy bweilim katanok katanok, va̱gan bukukwamuweips, bukumwa̱saws.” ");
INSERT INTO myw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pawl ilivan ma̱wan, o singay keikay siwotet va̱gan bisilbwades ninous tasiyas; peinan singay sivines beiluns wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wankuyeim min-Yudiy mo isaps, Antiyok o Ikoniyam gimgilis, ivalutsa livan issekes gamag babaw wasigeis, iliganes mo iweiys Pawl, dakul waseg, mo ibiteilis, ilaves in watoulan ven; idokes kid bo imat. ");
INSERT INTO myw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yeisuw nagamag ikatuyouns inekes Pawl nimmasis wapwepway; mo itamanaw, isuwvaw vayuwein wanuwan ven. Iyam ne-ga̱boug Pawl son Ba̱nabas mo ineis Da̱biy. ");
INSERT INTO myw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ven towen Da̱biy waseg mo igeiguys, gamaga babaw iliganes asilivan, Yeisuw liva̱nen. Ikous, mo iyums ineis Lisitil; ilisawes Lisitil mo ineis Ikoniyam, ilisawes Ikoniyam ineis Antiyok. ");
INSERT INTO myw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vena babaw wasigeis tasiyas asteiy ilabes Yeisuw nagamag silma̱nin kid bitawtouns; idibakes, ilansa, “Kadiloka kusimkines misimounid Yeisuw waseg, peinan tuta babaw a̱bads bigeg mo bitasiws wanuwan Yowbad nakabkaleiwag.” ");
INSERT INTO myw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Vena babaw wasigeis sivines tamumwey mwasanin, kalisiy bimtakavates tayakelesiys, mapuna itamnawes gamag mwasanin tasimounids Guyaw Yeisuw waseg, ipsapos katanok yam o akweiy, ininitougs waseg Yowbad, mo itapwa̱louls, isenas nimes wawous gamag tasiyas, intougis Yeisuw va̱gan bikimtuwes silma̱nin siwotet towen. ");
INSERT INTO myw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ikous, ikanpeles Pisidiy, ineis Pampiliy. ");
INSERT INTO myw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","26","Illivans liva̱nen Yeisuw ven Pelig waseg, mo iwloubus ineis Ataliy; itouws wa̱wag, ikuks, iyums ineis Antiyok, ven Siliy waseg. Kweiboug ven towen tayakelesiys nisekes siwotet, ininitougs silma̱nin Yowbad bilabes; e, misumkwey towen mo iyakousis siwotet. ");
INSERT INTO myw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Iyums ineis Antiyok, tayakelesiys mo ikatuyouns, imeis; ita̱kuds liva̱nen Yowbad nawotet tawtoun to niwtel wasigeis tasiyas, peinan bo ikaliyow koukwed va̱gan tobwag ven gimgilis mo bisimounids, beisiws bimekes Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pawl son Ba̱nabas tut kalamwey kadiveiyov nisesus sisiyas tayakelesiys tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Isesusa ee... imwemway-nen mo gamag mwasanin meinoy nimeis Yudiy isaps Antiyok, ikatimlakes tayakelesiys, ilansa, “Kukin bukukwawes nakabivatus Ebelam, ma̱wana Moses nakaleiwag, bweina bikatinabweimiy Yowbad; kukin gog nag, bo nag.” ");
INSERT INTO myw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pawl son Ba̱nabas mo itamanaws, ikamnimans sisiyas; mapuna tayakelesiys mwasanin ilansa, “Simiyas mwasanin kuneis Yelusalem va̱gan bukullivans simsimiyas min-Yelusalem tasiyas tayakelesiys situwa̱veks o tasiyas takaweins liva̱nen Yeisuw; e, liva̱nen Ebelam nakabivatus kwambuvisis va̱gan nanouds bidumwal.” ");
INSERT INTO myw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mapuna ilisawes tayakelesiys ven Antiyok waseg, itanouys mo ikanpeles Pinisiy. Ikous, mo ikanpeles Samaliy. Vena babaw itita̱vins ikatimlakays, ilansa, “Tobwag ven gimgilis bo ikanavin ninous, isimounids waseg Yeisuw.” Tayakelesiys tasiyas iliganes, mo imwa̱saws avakaein. ");
INSERT INTO myw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wankuyeim mo isaps Yelusalem, tayakelesiys babaw imulouls sisiyas tasiyas, o situwa̱veks imulouls, o takaweins liva̱nen Yeisuw imulouls. Pawl son Ba̱nabas mo ita̱kuds Yowbad nawotet babaw niwtel siney tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Takaweins Yeisuw anilivan mwasanin, tasiyas Palisiy kweiboug niyakelesiys, tasiyas mo itamanaws, ilansa, “Kadiloka tobwag ven gimgilis bibwabwes momwes, bikanawes Moses nakaleiwag, mo beisiws biyakelesiys.” ");
INSERT INTO myw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mapuna ikatuyouns takaweins liva̱nen Yeisuw, sisiyas tayakelesiys situwa̱veks, va̱gan bikaleiwags silma̱nin sinap towen. ");
INSERT INTO myw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Illivansa babaw ee... ikous, wankuyeim mo Pita itamanaw, ilana, “Sigwey yakamiy, kukwakins kweiboug-o Yowbad nakaleiwag waseg yey, va̱gan bakow liva̱nen Yeisuw, banow tobwag ven gimgilis wasigeis, va̱gan biliganes, mo bimwa̱saws. ");
INSERT INTO myw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","“O peinan Yowbad ikakin ninous gamaga babaw, bo itimakes tasiyas; Kululuwan Towen Bwanabwein mo isekes, ma̱wana ya̱kids kweiboug. ");
INSERT INTO myw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","“Bo isimounids waseg Yowbad, mo iwid asisinap kalbaleb, ma̱wana ya̱kids. Youda babaw ivag wasigeis tasiyas, ma̱wana ya̱kids. ");
INSERT INTO myw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Tut towen awoum bitayagages nanon Yowbad, awoum bitakaleiwag moumouvit wasigeis budidayas tasiyas. Peinan tammwayas ilapes Moses nakaleiwag; ma̱wana ya̱kids, bo ilapeids, nag kadilokeids. ");
INSERT INTO myw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","“Deisa towen daGuyaws Yeisuw bo isiwyoubuds va̱gan bitasimounids waseg, mo bikatinabweids; o tasiyas gog bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tasiyas babaw bo iliganes, isesusa ge ikika̱pays; wankuyeim mo ita̱kuds Ba̱nabas son Pawl, isekes liva̱nen Yowbad nawotet tawtoun, mamagin naman mulin nivag tobwag ven gimgilis wasigeis; o nawotet towen niwtel wasigeis tasiyas Ba̱nabas son Pawl. ");
INSERT INTO myw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","15","Iliganes, igawa ge ikika̱pays; Yemes mo iliwon, ilana, “Sigwey yakamiy, kuliganes agulivan. Saymon bo idibakeids: Wanmugwana Yowbad ilokon tobwag ven gimgilis wasigeis va̱gan bidawes gamag mwasanin bikawes ansinap, o bikawes yagan tonen. E, mo ikamat youd towen, palopit kweiboug nilel Yowbad anilivan, mamagina: ");
INSERT INTO myw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","“‘Ikous, mo ba̱yum baw, bawlulavaw Deibid nabunatum towen nigulekwes, Naven nises makaw; igaw mo bawlulavaw, mo biton bitadumwal beibwein. Bawtel ma̱wan va̱gan vena babaw gimgilis mo bineveigs siGuyaw yey. O silma̱nin tobwag ven gimgilis tasiyas nadawes gungamag tasiyas.’ DaGuyaws anilivan ma̱wan, o nawotet towen pwa̱mug-o ikamtel tammwayas wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Mapuna akaleiwag, awoum youd moumouvit bitasekes vena babaw gimgilis, tasiyas mwana nitouvins inekes Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","“Deisa takaleiwags wasigeis tasiyas va̱gan bipiyaves kan nimgwavis silma̱nin tobwag yowbad; awoum bisubwans; awoum beikams viniyonan man bo niskwen kayon neimat nanawan, o viniyonan man sona buya̱vin. Misinak. ");
INSERT INTO myw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","“Peinan nagwa̱diven ivnivins Moses nakaleiwag Sa̱dad katanok katanok, vena babaw wasigeis. E, vena babaw sisinagog wasigeis tageiguys ivinis Moses nakaleiwag, igeiguys.” ");
INSERT INTO myw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Takaweins liva̱nen Yeisuw, sisiyas tayakelesiys situwa̱vek, sisiyas tayakelesiysa babaw, idokes bikayabes sigamag mwasanin, sisiy Pawl o Ba̱nabas bikawes silet binawes Antiyok. E, ikayabes tayakelesiys guyawaw asteiy, teitan Yudas, yagan kwayuwein Ba̱sabas, tayuwein yagan Saylas. ");
INSERT INTO myw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Let towen nikawes nakalelel mamagina: “Kalin nuwem budimayas yakamiy, Antiyok gimgilis, o Siliy gimgilis, o Silisiy gimgilis, tobwag ven gimgilis tayakelesiys yakamiy. Yakamey takaweins liva̱nen daGuyaws Yeisuw, simayas tayakelesiys situwa̱vek ven Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“O peinan nakaligen simayas mwasanin bo iva̱ges moumouvit wasigeis yakamiy, o ibol ninoumiy yakamiy asilivan waseg. O yakamey nag kakayabes tasiyas, nag; ninousa tasiyas niweis. ");
INSERT INTO myw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","“Mapuna ninom yakamey bo katanok-wan va̱gan bakakayeb tawaw mwasanin biwekeimiy, sisiyas Ba̱nabas son Pawl. O yakamiy o yakamey, babaw ya̱kids ikalin nuwads tawaw tasiyas Ba̱nabas son Pawl, peinan tuta babaw inounas abkanig waseg, daGuyaws Yeisuw Kelis silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Mapuna nakakayabes Yudas son Saylas, biwekeimiy, mo bidibakeimiy ma̱wana nakalel malet towen waseg. ");
INSERT INTO myw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","“O simey Yowbad Kululuwan kadok kid nag kweitan kaleiwag moumouvit bakasekeimiy; tage kadiloka kupiyaves kalbaleb sinap tasiyas, viniyonan man nimgwavis silma̱nin tobwag yowbad, o buyav, o viniyonan man bo niskwen kayon neimat nanawan, o makava kanavay. “Magat bukuvna̱ses kaleiwag towen bo bukusesusa bwein, bukutawtouns. Taneimiyo.” ");
INSERT INTO myw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bo itanouys, mo inounas, ineis Antiyok. Tayakelesiys babaw ikatuyouns imeis, mo isekes silet towen. ");
INSERT INTO myw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ivinis let towen, bo imwa̱saws, peinan bo ikambuvis ninous, bo idumwal. ");
INSERT INTO myw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","33","O Yudas son Saylas, peinan palopit tasiyas, asilivan babaw wasigeis mo igeiguys tayakelesiys wasigeis, mapuna itawtouns. Nisesus sisiyas ee... imwemway-nen; mo imulouls wasigeis, itanouys, iyums, inekes tayakelesiys tasiyas kweiboug nikayabes niweis. ");
INSERT INTO myw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO myw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pawl son Ba̱nabas sisiy tageiguys mwasanin, nisesus Antiyok, illivans liva̱nen Yeisuw, o Yowbad anilivan bwanabwein ikatimlakays. ");
INSERT INTO myw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yam mwasanin ikous, Pawl mo idibek Ba̱nabas, ilana, “Kum, taneis, takines tayakelesiys vena babaw, kweiboug-o nitaguyes liva̱nen Yeisuw; mo bitakin ama̱wan sikasis.” ");
INSERT INTO myw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ba̱nabas itam, ilana, “Bwein;” ilana, “Adok sod Yon bitanounas.” Yon yagan kwayuwein Mak. ");
INSERT INTO myw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pawl ipiyev, ilana, “Nag, peinan kweiboug nilisaweid ven Pampiliy waseg, ipiyev dawotet, iyum. Nag kadilok sod bitanoun. Bweina bises.” ");
INSERT INTO myw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mapuna ikamnimans. Ba̱nabas son Mak mo ilisawes Pawl, ikuks ineis Saypilos. ");
INSERT INTO myw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","Tage Pawl idow Saylas; tayakelesiys initougs waseg Yowbad, sivines kid Yowbad bilabes tasiyas asteiy mo inounas, ikanpeles Siliy o Silisiy, vena babaw wasigeis ilabes tayakelesiys, va̱gan kid bitawtouns. ");
INSERT INTO myw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","E, isaps Da̱biy, ikanpeles, mo ineis Lisitil. Ven towen waseg mo iba̱nes taw teitan, kweiboug-o niligen liva̱nen Yeisuw. Mtowen yagan Timotiy, inan vinen-Yudiy, isimounid Yeisuw waseg; taman gog guma-Gilis. ");
INSERT INTO myw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tayakelelsiys ven Lisitil waseg o Ikoniyam waseg idokes kid Timotiy singay tadidumwal. ");
INSERT INTO myw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pawl sivinan taw towen sisiy bineis, mapuna ibob momwan, magina Ebelam nakabivatus; peinan gamag babaw ikakins Timotiy taman guma-Gilis; o peinan min-Yudiy babaw nisesus ven towen, o Pawl nag ivag sivinan tasiyas bivtokes livan, mapuna mtowen Timotiy ibob momwan. ");
INSERT INTO myw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Igawa ikaninapels ven katanok katanok wasigeis, mo ikatpeles sikaleiwag isekes, kweiboug nikalawages Yelusalem waseg. Tasiyas takaweins liva̱nen Yeisuw, o tayakelesiys situwa̱veks, isekes sikaleiwag, ilansa, “Kadiloka kuvna̱ses.” ");
INSERT INTO myw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mapuna tayakelesiys iyamweis sisimounid; o yam katanok katanok ikatimweisis, mo ibabaws. ");
INSERT INTO myw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ikanpeles ven avakaein Piligiy, ikous mo ikanpeles ven avakaein Galetiy. Yowbad Kululuwan mo isilbwades, awoum bisekes asilivan min-Esiy wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wankuyeim mo ineis Misiy, sivines kid bineis Bitiniy; iyokonsa, nag; peinan nag beitam Kululuwan Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misiy ikanpeles ikous, mo iwloubus ineis Tilowas. ");
INSERT INTO myw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","O boug waseg, Pawl matan isisawl mav, magina ikamikon, ikintuwen ikin wa̱yol ikin gum-Masidoniy itamanaw iton palatan, ilana, “Kudopel kum wamaven Masidoniy, kulabem yakamey.” ");
INSERT INTO myw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pawl ikikin ikous; bo ikatima̱mal, sivinan kid bidopel bein Masidoniy; kadok kid Yowbad nidawem bakan bakasekes tasiyas liva̱nen Yeisuw. Ninom katanok-wan. ");
INSERT INTO myw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kakilev Tilowas, kadumwala kan Samotiles kamasis; neiyam nen ka̱kuk ee... ka̱lug Niyapolis. ");
INSERT INTO myw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Niyapolis waseg ka̱bus kan Pilipay, ven towen wunovek wawnuwan Masedoniy; mina-Lom babaw o mina-Lom sitakanaviy babaw nisesus ven towen waseg. Yam mwasanin kasesuna ven towen. ");
INSERT INTO myw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sa̱dad waseg kadoki gamag mwasanin ininitougs o ititapwa̱louls Yowbad waseg wadadan lay kweitan; mapuna kasap adunan ked kan lay towen, kawekes vinay mwasanin, kakaypul simayas; kallivan. ");
INSERT INTO myw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Guyouvin na̱tan yagan Lidiy, vinen-Tayatil, taymayisein kweim bwabwel, tuta babaw nititapwa̱loul Yowbad waseg; e, mana̱wen mo iligen amalivan. Peinan Yowbad bo ikatiboug nuwan va̱gan biligen kid Pawl anilivan. ");
INSERT INTO myw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Peinan iligen liva̱nen Yeisuw, mo nakabapta̱yses Lidiy sen angamag. Ikous, Lidiy mo idibakem ilana, “Magat bukudokeig nasimounid yey daGuyaws waseg, kadiloka kumeis wagunbunatum, agubwabwal yakamiy.” Ivvalut ee... mo ka̱tam. ");
INSERT INTO myw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yatam yam nakan tapwa̱loul silma̱nin, kaninoun ee... mo ilivatum nukubukwab na̱tan, kululuwan waseg ikatigigik aveiyag igaw bikamat, o nawotet maysan singay avakaein ikawes taliven. ");
INSERT INTO myw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vin na̱wen ikabkunim yakamey simey Pawl, iwkuwak, ilana, “Yowbad Tatawtoun nagamag tasiyas; tasiyas ikatimlakeids ked towen waseg Yowbad bo bikatinabweids.” ");
INSERT INTO myw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nawkuwak anilivan ma̱wana yam babaw. Mapuna igeg nanon Pawl, itouvin, idibek yeiluw towen, ilana, “Akalawageim wayagan Yeisuw Kelis, kulisow mana̱wen vin, kunoun.” Mitiya̱mun towen yeiluw mo inoun. ");
INSERT INTO myw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vin mana̱wen taliven ikakins bo iyakous wawun simoney, igeg ninous, iyousis Pawl son Saylas, ibiteilis tasiyas ineis wavtakon ven va̱gan kid biyateles wamtes tasiyas takaliwageins ven. ");
INSERT INTO myw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","E, itokes, inawes takalleiwags wasigeis; ilansa, “Min-Yudiy tasiyas kalbaleb sinap iva̱ges wadavanuys, peinan sivines kid bisekemas sinap kweitan, o asisinap towen bwaboum wasigeis yakamey mina-Lom.” ");
INSERT INTO myw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gamag babaw mo ilabes, sivines kid biyagages Pawl son Saylas. Takaleiwags mo ilansa, “Kunisis asikweim, mo kuweiys amweilok waseg.” ");
INSERT INTO myw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iwaways avakaein wawous; ikous, mo ikalabus, idibakes takaymatein deil ilansa, “Kukwaymates tasiyas beibwein. Awoum bisaps bineis watoulan.” ");
INSERT INTO myw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Towen iligen, isenas wa̱deil bunatum tawtoun waseg, ilokes kikeis amweilok akiy wanuwein; ta-ma̱wan biyaganis kikeis. ");
INSERT INTO myw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Watapwan boug Pawl son Saylas ikululs wamatan Yowbad, initougs waseg, ikannuwels asiwous. Tasiwuns deil mwasanin ikatilutegs. ");
INSERT INTO myw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mo ivag nik avakaein, kakolan bunatum dakul igogewns-wan; koukweda babaw ikaliyowes, o sen o amweilok niyousis tasiwuns deil nimes o kikeis bo ipalpa̱leiks o itigta̱gut ikous. ");
INSERT INTO myw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Takaymatein deil mo ilaktukit, ikin koukweda babaw bo ikaliyowes, idok kid bo isawls tasiwuns deil babaw; igeg nanon, ikow napulut tanmunum va̱gan kid bibes nipowun tatonen, beimat. ");
INSERT INTO myw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pawl ikin, aygan avakaein ivag, ilana, “Awoum kuygageim toneim yak. Yakamey-yaya, amababaw-wan.” ");
INSERT INTO myw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Takaymatein deil idow teitan bimey lamp; mo ikow, isawl, isiw wanuwan deil, itatat won, ikulul wamtes Pawl son Saylas. ");
INSERT INTO myw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wankuyeim mo itokes ineis wamnat, ilana, “Adok guntuwa̱vek yakamiy, kadiloka kudibakeigs aveiyag bavag silma̱nin kid Yowbad bikatinabweig.” ");
INSERT INTO myw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ilansa, “Kadiloka kusimounid daGuyaws Yeisuw waseg, mo bikatinabweimiy simwey amgwamag.” ");
INSERT INTO myw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mo idibakes tasiyas liva̱nen Guyaw Kelis, siney gamaga babaw nisesus wanbunatum. ");
INSERT INTO myw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mitiya̱mun towen boug waseg, tanuwagan deil ikow yevagam, buyavis wawous itawis. Ikous, mo ibapta̱yses sen nagamag. ");
INSERT INTO myw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ibapta̱yses ikous, mo isiws wanbunatum, kaeis isekes, ikams, peinan imwa̱saws avakaein sineya-wan angamag; liva̱nen Yowbad niliganes. Ikous, mo iyums ineis wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Iyam nen ga̱boug takaliwageins ven mo ikayabes sipilismans ineis wa̱deil, ilansa, “Kulavewas tasiyas asteiy, bineis.” ");
INSERT INTO myw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tanuwagan deil ikow asilivan towen, isek Pawl, ilana, “Takalawageins ven bo ikayabeimiy bukunounas. Bweina beitout ninoumiy, kuneis.” ");
INSERT INTO myw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pawl idibakes, ilana, “O yakamey mina-Lom yakamey; bo iwemas wamtes gamag babaw nov, o nag iyatelemas va̱gan bikakins amasinap aveiyag kalbaleb. Makaw isenamas wa̱deil; nagein gog bikakiws asimwasin, bikawumemas mo bikayabemas. Kapiyev. Bakasesuna. Kadiloka tasiyas bimeis bitokemas bakan wamnat, mo bikayabemas.” ");
INSERT INTO myw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tasiyas pilismans mo inekes takaliwageins ven; asilivan ikatpeles isekes. Kweiboug nag bikakins Pawl o Saylas mina-Lom tasiyas; e, tut towen mo ikakins, asimwasin seikwan. ");
INSERT INTO myw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Aspwa̱yat inekes Pawl son Saylas, asilivan siwa̱youb, mo itokes ineis wamnat, ikayabes bineis kid kweitan ven. ");
INSERT INTO myw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ilisawes deil mo inekes Lidiy, inekes tayakelesiys, iguyes, mo itanouys, inounas, ineis. ");
INSERT INTO myw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Inounas mo isaps Ampipol; ilisawes Ampipol mo ineis Apoloniy; ilisawes Apoloniy mo ineis Tesalonik. Min-Yudiy sibuntuman tapwa̱loul yagan sinagog nises Tesalonik. ");
INSERT INTO myw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Ma̱wan ansinap vena babaw waseg, Pawl mo isiw wanuwan sinagog ikatimlakes silawun Bukitab. Kweitoun Sa̱dad waseg ikatiboug nuwes min-Yudiy tasiyas. Isekes ninous ma̱wan; ilana, “Kadiloka gamag biyagages Kelis, bikanig, mo beikit vayuwein. Liva̱nen nises Bukitab waseg, bo ma̱wan. Silawun gunkatimlakay Yeisuw, mtowen mounid Kelis.” ");
INSERT INTO myw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pawl ivvalut ee... mo isimounids mwasinis gamag, mapuna ikatuvases sisiyas Pawl son Saylas; mina-Gilis-vak tavna̱seins Yowbad isimounids singaya babaw, sisiyas guyvinays mwasanin. ");
INSERT INTO myw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tage min-Yudiy mwasanin bo ikameiliws, ivtokes livan. O mwasanin tasiyas tabgumats bo iliganes asilivan, ikatuyouns gamag babaw, sivines kid bikawpwanaws wasigeis Yeisuw nagamag, ineis Yeson wanbunatum, iwkuwa̱ksa; ilansa, “Kadilok tasiyas Pawl son Saylas bimeis wamnat.” Peinan min-Yudiy ninous bo biyagages Pawl son Saylas. ");
INSERT INTO myw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Iyyokons, bo nag; mapuna itokes Yeson siney Yeisuw nagamag mwasanin, inawes takaliwageins ven wamtes, iwkuwaks, ilansa, “Gamag tasiyas niyagages vena babaw, nagein mo imeis wadavanuys ya̱kids, Yeson anbwabwal tasiyas nisesus. Tawaw tasiyas bo ibwabwes Sisal nakaleiwag, peinan ilansa, ‘King kweitan nises, yagan Yeisuw.’” ");
INSERT INTO myw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Gamag babaw iliganes livan towen, mo igeg ninous, sisiyas takaliwageins ven; mapuna idibakes, ilansa, “Yakamiy simiy Yeson kadiloka kupa̱yins, money mwasanin kusekemas, mo kunounas. Igaw kukin bukusesusa bwein, o nag kweitan sinap bukuva̱ges ma̱wana kalbaleb sinap towen, igaw tut wanakoug mo bakayamen mimoney.” ");
INSERT INTO myw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yeisuw nagamag ikatima̱mals, boug waseg ikayabes Pawl son Saylas, bineis Beloy. Isaps Beloy mo ineis wasinagog, isiws wanuwan, liva̱nen Yeisuw mo isekes min-Yudiy tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","E, tasiyas asisinap bwein, nag ma̱wan min-Yudiy tasiyas nisesus Tesalonik; bo iseiw nuwes Pawl anilivan towen sivines binganegs-wan; e, yam babaw ivnivins Bukitab va̱gan bikakins kid livan towen mounid, o nag, yaweid. ");
INSERT INTO myw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Babaw gamag mo isimounids, sisiyas vinay-nen Gilis guyvinays, sisiyas tawaw mwasanin. ");
INSERT INTO myw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wankuyeim min-Yudiy tasiyas nisesus Tesalonik mo iliganes Pawl nises Beloy igeiguy liva̱nen Yowbad; mapuna inounas imeis Beloy, ivtokes livan, va̱gan beivag aspwa̱yat gamaga babaw, mo bikamliwes towen Pawl. ");
INSERT INTO myw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mapuna Yeisuw nagamag tayakelesiys ven towen mo ikatima̱mals ikayabes Pawl biwloubus kid bein wa̱yol. Tage Saylas son Timotiy nisesusa ven towen Beloy. ");
INSERT INTO myw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Gamag mwasanin itokes Pawl, itouws wa̱wag, ikuks, ineis Atens; Pawl mo idibakes tasiyas, ilana, “Kuyums kuneis kukines Saylas son Timotiy nuwanaw bimekeigs,” mo iyums ineis Beloy. ");
INSERT INTO myw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pawl, igawa nises Atens ikaymates Saylas son Timotiy bimeis; bo igeg nanon peinan ikines tasiyas taginvens singay imgamegs. O babaw siyowbad tobwag wasigeis ikululs wamtes. ");
INSERT INTO myw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mapuna yam babaw Pawl mo isen kweitan livan, Yowbad liva̱nen, min-Yudiy sisinagog waseg, o tavna̱seins Yowbad wasigeis, o gamag mwasanin ilivatus wavtakon ven, igeiguy wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tassinaps mwasanin tasiyas Epikul sisiyas tasiyas Sitowik illivans sisiy Pawl. Mwasanin iliganes, ilansa, “Taw towen, makava illivan. Aveiyag illivan?” Mwasanin gog ilansa, “Liva̱nen kweitan ven siyowbad illivan.” peinan Pawl anilivan Yeisuw inakanig silma̱nin o neikit vayuwein. ");
INSERT INTO myw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Mapuna itokes Pawl inawes buntuman Konsel waseg, yagan Aliyopag, ilansa, “Tabta bukwatimlakes amsinap towen kweivaw, towen nukulivan wasigeis gamaga babaw; kadok kid youd kweitan towen isowsiw watigem yakamey. Sivinem gog bakakakin silawun sinap towen.” ");
INSERT INTO myw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Peinan min-Atens sisiyas asibwabwal tuta babaw sivines bikatilutegs youd kweivaw, o liva̱nen youd kweivaw billivans sisiyas; mapuna tuta babaw inineivs sinap kweivaw. ");
INSERT INTO myw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Pawl mo itamanaw wakabgeiguy bunatum Aliyopag wanuwan, ilivan. Ilana, “Min-Atens yakamiy, bo akin singay tamgamegs yakamiy. Bo ata̱vin miven akikinena wuliyougwan tapwa̱loul, bo aban abeilun kweitan. Lelel-nen mamagina, ‘Silma̱nin yowbad tamta̱was.’ Yakamiy nag kukwakins Yowbad towen nukukululs wamatan, yey mo bakatimlakeimiy yagan towenan. ");
INSERT INTO myw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Yowbad towen bo ibun youda babaw, o peinan towen tanuwagan liba̱lab, o ven watinow, nag bimasis wabunatum towen tawlules wanamads; nag. ");
INSERT INTO myw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","“O nag ivag sivinan aveiyag namads biwtel silma̱nin towen, peinan bo nisekeids damwamovs o kululuwads, o dawliyougs babaw-wan. ");
INSERT INTO myw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“O tabuds anmwa̱net-wan Adam waseg, bo ibunids, nitamlavags vena babaw gimgilis wadaban pwepway. Bo ikaleiwag idatuts, o dakablivis pwepway ven katanok katanok wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“O bo ikaleiwag va̱gan kid bitaneves mtowen Yowbad; igaw takinew mo bitaban, peinan kadilakus nises wasigeis ya̱kids katanok katanok. ");
INSERT INTO myw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Mtowen waseg tamwamovs, taninounas, tasesus. Ma̱wan tawutun wous nilivan wasigeis yakamiy, ‘Peinan ya̱kids Yowbad tibun ya̱kids.’ ");
INSERT INTO myw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“E, peinan Yowbad tabuds ya̱kids, awoum bitanuways Yowbad kid ma̱wana goul o silib o dakul, o aveiyag gamag teitan binuway mo bibun wanaman, nag. ");
INSERT INTO myw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","31","“O Yowbad gog inumlev tut kweiboug dadub; tut gog towen ikaleiwag vena babaw gimgilis va̱gan bikanavin ninous, peinan nikatigik tutan katukin wanakougwaw, yam towen bo bikatukin gamag babaw wasigeis, amtowen bwein, amtowen kalbaleb; e, teitan taw bo itamnow, takaleiwag tatonen. Kakakin anilivan mounid, peinan taw towen nikanig, Yowbad ivag mo ikit vayuwein.” ");
INSERT INTO myw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ikatiliganes liva̱nen dakabeikits kanig waseg, mwasanin mo igigs peinan nag isimounids; mwasanin gog ilansa, “Igaw, kweitan tut mo bukuwgavaw amlivan towen va̱gan bakaligen.” ");
INSERT INTO myw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","34","Pawl iligen asilivan, mo ilisawes, inoun. Mwasanin gamag bo isimounids anilivan waseg, mo ikatuvases sisiy Pawl, teitan Diyonisiy, mtowen takaleiwag teitan bunatum Aliyopag waseg, na̱tan Damalis, sisiyas mwasinis gamag. ");
INSERT INTO myw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","2","Wankuyeim Pawl mo ilisow Atens in Kolinit; iban gum-Yudiy yagan Akwil, naven Ponit. Kweiboug nises Ita̱liy, o peinan Sisal Kalodiw nakaleiwag va̱gan min-Yudiy babaw bilisawes naven towen Lom, mapuna ilisow Ita̱liy; e, mwana nimeis Kolinit son nakwav Piliskil. ");
INSERT INTO myw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Towen nawotet, ikow man kulivis mo ibsibas ivag bunatum. O peinan Pawl ikakin sinap towen, mo inekes, sisiy nisesus, iwwotets. ");
INSERT INTO myw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tapwa̱loul waseg, Sa̱dad katanok katanok illivans siney Min-Yudiy, o mina-Gilis, isimkakin va̱gan bisimounids waseg Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wankuyeim Saylas son Timotiy meinoy nimeis Masidoniy isaps Kolinit, igawa Pawl ivvalut wotet towen, ikatimlakes min-Yudiy va̱gan bikakins beibwein mtowen Yeisuw mounid Kelis. ");
INSERT INTO myw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wankuyeim tasiyas mo ipiyaves Pawl anilivan, itawyages, asilivan kalbaleb waseg; mapuna ikatsap anakweim va̱gan bikakins bo ipiyaves tasiyas, ilana, “Deis! Peinan kupiyaves livan towen, igaw bukumta̱mats; takaleiwag yakamiy. Bweina bo batouvin basekes livan towen tobwag ven gimgilis, va̱gan bo biliganes.” ");
INSERT INTO myw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ikous, mo ilisawes, isiw wanbunatum tavna̱sein Yowbad teitan, yagan Titos Yusitos, nabunatum nises sinagog wadadan. ");
INSERT INTO myw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tanuwagan sinagog, yagan Kilisip, bo iliganes liva̱nen Guyaw Yeisuw, sen angamags babaw; o min-Kolinit babaw bo iliganes, mo ibapta̱yses. ");
INSERT INTO myw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Kweitan tut, boug waseg, Pawl immasis, anmikon waseg mo ikin naguyaw Yeisuw, ilana, “Pawl, awoum beivag ampwa̱yat, kusimkakin liva̱neig waseg; awoum kukwa̱pay, peinan agugwamag namagleis nisesus ven towen. Ta-kweitan gamag beiweim o biyagageim, peinan soum yey tases.” ");
INSERT INTO myw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mapuna Pawl isesuna katanok bweilim ikous, mo tibukon kweinim katanok. Misumkwey towen waseg ikatimlakes ven towen gimgilis va̱gan kid bikakins liva̱nen Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","13","Mitiya̱mun towen, min-Akay sigabman avakaein, yagan Galiyon, nises ven towen. Min-Yudiy ninous katanok-wan mo itamanaws iyousis Pawl itokes inawes Galiyon wankabkaleiwag, a̱ban towen wamatan, ilansa, “Taw towen sivinan bibob dakaleiwags, ikatimlakay tobwag tapwa̱loul va̱gan bitateiy gamag ninous.” ");
INSERT INTO myw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","15","Pawl sivinan bisilamaw anilivan, tage Galiyon mo idibakes min-Yudiy tasiyas, ilana, “Min-Yudiy yakamiy, magat towen ansinap kalbaleb, o magat biyageg son, bweina baligen amilivan; o peinan sinap towen yakamiyana amisinap, sinapun imiven, o liva̱nen imiven, kadiloka yakamiyana bukwaleiwags; yey apiyev.” ");
INSERT INTO myw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ilivan ma̱wan, mo ikayabes, ilisawes nakabkaleiwag towen. ");
INSERT INTO myw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Gamag babaw mo iyousis tanuwagan sinagog yagan Sositen, iwaways-wan kabkaleiwag towen wamatan; tage Galiyon nag igeg nanon sinap towen waseg. ");
INSERT INTO myw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Wankuyeim Pawl isesuna ven towen, yam mwasanin. Ikous, mo ilisawes Yeisuw nagamag, itanouys siney Piliskil son Akwil; ikuks, bineis Siliy. Isaps ven Kenikil waseg, Pawl iduy kunun peinan anilivan ka̱tout Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ikuks ee... ilugs Epesos, Pawl mo ilisawes tasiyas, isiw wanuwan sinagog mo illivans sisiyas min-Yudiy; va̱gan bivag ninous bikanavin. ");
INSERT INTO myw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","21","Tasiyas mo idibakes Pawl, ilansa, “Kadilok kadiveiyov tut ya̱koum simey yak tasesus.” Ilana, “Nag; bo banoun. Kukin nanon Yowbad ma̱wan, igaw mo ba̱yum bam.” Mo itouw wa̱wag, ikuks, itanes min-Epesos. ");
INSERT INTO myw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ilugs Sisaliy, ikatulag in Yelusalem, imulouls siney tasiyas tayakelesiys; mo inoun in Antiyok. ");
INSERT INTO myw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Isesuna yam mwasanin waseg; ikous, mo inoun ilakwanes tayakelesiys ven katanok katanok wasigeis; isilamaw ven katanok katanok wawnuwan ven Galetiy; iyakous, mo ikanapel in ilakwanes ven katanok katanok wawnuwan Piligiy; ilabes tayakelesiys va̱gan kid bitawtouns. ");
INSERT INTO myw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Gum-Yudiy tassinap teitan mo isap Epesos, towen yagan Apolos, naven Aleksanidel, singay ikakin Bukitab, o itawtoun geiguy waseg. ");
INSERT INTO myw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kweiboug mwasanin gamag bo ikatimlakes, mapuna ikakin Yowbad inaked. E, bo iseiw nuwan liva̱nen Yeisuw bilivan, anilivan mounid-wan. Ikatimlakes gamag mwasanin anilivan towen. E, ikakin sinapun tabapta̱ysein gamag towen Yon. Tage sinapun Yeisuw nag iyakous. ");
INSERT INTO myw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Anilivan kamnat mo isilamaw sinagog wanuwan. Piliskil son Akwil iliganes, mo idawes im wasibunatum, ikatimlakes Yowbad inaked, mo ikakin bwein. ");
INSERT INTO myw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","28","Iyakous nawotet ven towen, mo ivag sivinan kid bein Akay. Yeisuw nagamag ilivans, “Bwein;” mo ilelels let silma̱nin ven towen tayakelesiys-nen, va̱gan bivna̱ses mtowen Apolos, anbwabwal tasiyas. Isap wasiven, mo ikatimweis asisinap tayakelesiys tasiyas. Kweiboug-o Yowbad nilabes mo isimounids Yeisuw waseg, misiya̱mun towen asisinap mo ikatimweis peinan Apolos ilabes; o anilivan itamap wasigeis min-Yudiy asilivan, peinan anilivan tawtoun waseg ikatimlakes silawun Bukitab, va̱gan bikakins kid mounid Kelis mtowen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Igaw Apolos nises Kolinit, Pawl ikaninapel ven tasiyas wanawoud. Ikous mo isap Epesos; mo ilivatus Yeisuw nagamag mwasanin; idibakes, ilana, “Nukuliganes liva̱nen Yeisuw, Yowbad Kululuwan Towen Bwanabwein iwekeimiy tan, o nag?” Ikatimapus aygan; ilansa, “Nag. Nag bakaligen liva̱nen Kululuwan Bwanabwein.” ");
INSERT INTO myw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pawl mo ikatugwan; ilana, “Ama̱wan nukubaptays?” Ilansa, “Nakaligen Yon nageiguy, mo ibapta̱ysem yakamey.” ");
INSERT INTO myw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Iw to Pawl, ilana, “Yon bo ibapta̱yseimiy va̱gan bikanavin ninoumiy, o va̱gan bukulavewas amisinap kalbaleb, sinap bwanabwein bukuyousis; o Yon nidibakeimiy ilana, ‘Kadiloka bukusimounids waseg mtowen nibkunig yey.’ Anilivan gog liva̱nen Yeisuw.” ");
INSERT INTO myw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Gamag tasiyas bo iliganes Pawl anilivan, mo ibapta̱yses Guyaw Yeisuw wayagan. ");
INSERT INTO myw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pawl isen naman wawous tasiyas, Yowbad Kululuwan mo inekes, ilivans kaeig kweitan kweitan wasigeis, o ipalopisays Yowbad anilivan waseg ilivnakes. ");
INSERT INTO myw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Babiweis tawaw tasiyas adok sinawatan teiy. ");
INSERT INTO myw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pawl mo isiw wanuwan sinagog, anilivan kamnat waseg igigeiguy kweitoun tibukon; liva̱nen Yowbad nakaleiwag isekes, va̱gan kid bisimounids waseg. ");
INSERT INTO myw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wankuyeim mwasanin gamag ipiyaves anilivan, ikapidabs, ivtokes livan Yeisuw inaked, e wamtes gamag babaw ivtokays ma̱wan. Mapuna Pawl itokes inagamag ilisawes, isiw wanuwan Tilan nabunatum, sikul buntuman, yam katanok katanok mo ikatimlakes gamag. ");
INSERT INTO myw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nawotet towen niwtel akweiyuna bweilim waseg, min-Esiy babaw-wan mo iliganes liva̱nen Guyaw Yeisuw, min-Yudiy sisiyas mina-Gilis. ");
INSERT INTO myw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yowbad nawotet niwtel Pawl naman waseg. Inawotet kweitan-wan, singay tawtoun. ");
INSERT INTO myw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","E, gamag ikawes Pawl anakweim o kweim towen itanob magin waseg, isen takatouns wawous, inimul, mo ibweins, o yeiluw ilisawes mwasanin gamag mo ibweins. ");
INSERT INTO myw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Min-Yudiy tamgameg mwasinis mo isaps, iyokons kid bikayabes yeiluw, Yeisuw yagan waseg. Tasiyas ininounas vena babaw ikikayabes yeiluw; maysan wotet towen ikokews. Tawaw teinim teiy, times tanuwagan lun avakaein, Sikev yagan; tasiyas iyokons kid bikayabes yeiluw, Yeisuw yagan waseg; ilansa, “Kadibakeimiy Yeisuw wayagan kunounas; yeg towen Yeisuw, Pawl nikavvatag waseg.” ");
INSERT INTO myw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yeiluw towen ikatimop asilivan, ilana, “Akakin Yeisuw, akakin Pawl, tage yakamiy kalisiy yakamiy?” ");
INSERT INTO myw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Takayeiluw towen mo ipel iwawaysa mav tasiyas, itawtoun wasigeis, ikididul wous ibuybuyav-wan; mapuna sona mwadiyes mo isawls ineis wamnat, aspwa̱yat nag bikakit va̱gan. ");
INSERT INTO myw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Min-Epesos babaw iliganes youd towen, mo ivag aspwa̱yat, tasiyas min-Yudiy sisiyas mina-Gilis misikes Epesos. Mapuna mo igoulus mtowen Guyaw Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Babaw gamag tasiyas mwana niliganes liva̱nen Yeisuw mo ikamteles asisinap kweiboug dadub waseg. ");
INSERT INTO myw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","O tamgamegs babaw simeg nileles nein wasibuk, nimeyes sibuk maynsiyas, mo igabus wamtes gamaga babaw. Maysan buk tasiyas ivinis, singay avakaein, sinawanim tawsan kina. ");
INSERT INTO myw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Wotet babaw waseg liva̱nen Yeisuw mo itawtoun, gamaga babaw o sinap babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wotet towen ikous, Kululuwan Teiwen Bwanabwein mo isek nanon Pawl, ilana, “Singay sivinag bata̱vin Masidoniy o Akay, mo ban Yelusalem. Wankuyeim gog mo banoun ban Lom.” ");
INSERT INTO myw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mapuna ikayabes natouwat asteiy, ineis Masidoniy, yiges Timotiy son Elasit. Towen gog Pawl isesuna Esiy tut kayakus waseg. ");
INSERT INTO myw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Misiya̱mun towen, gamaga babaw inoyes Yeisuw inaked, mapuna ven towen Epesos gimgilis mo ilivatus moumouvita singay. ");
INSERT INTO myw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","E, takatanak teitan yagan Dimitil, mtowen tawtelein didawag silib, ibwabubs sen nagamag; biyakousis, mo bimeis gamaga babaw bigimwals; bikawes binawes va̱gan simeg bidagis wanuwan didawag towen; imgamegs silma̱nin siyowbad na̱tan yagan Dayan, va̱gan kid bilabes. Didawag tasiyas singay kawkwa̱vek mayses. ");
INSERT INTO myw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O gamag babaw inganegs Pawl anilivan, mo ipiyaves meg silma̱nin na̱wen Dayan; mapuna Dimitil idawes nagamag sisiyas takatanaks babaw; ikatuyouns imeis, Dimitil mo iliwon; ilana, “Tawaw, kukwakins dawotets towen waseg kads taba̱nes va̱gan bitakams. ");
INSERT INTO myw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","“O kukwakins Epesos gimgilis, o gimgilis ven tasiyas Esiy wawnuwan, bo iliganes aygan Pawl, mo ipiyaves adgeileiws tatoneids, peinan Pawl anilivan ma̱wana, ‘Yowbad tasiyas kubunis wanimamiy, yowbad tobwag tasiyas.’ ");
INSERT INTO myw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","“Adok tut kalbaleb bitalivatus; peinan gamag bipiyaves Dayan navavag tasiyas tabunins; o dayowbads avakaein na̱wen bidokes tobwag yowbad, bipiyaves kid nabunatum; mo biyakous yakawanan mana̱wen Dayan. Bo igak, peinan babaw ya̱kids takululs-wan wamatan Dayan, min-Esiy ya̱kids, o gimgilis vena babaw wadaban pwepway.” ");
INSERT INTO myw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Iliganes, mo ikavikuns avakaein, iwkuwaks, ilansa, “Min-Epesos ya̱kids dayowbads Dayan, mana̱wen singay natawtoun.” ");
INSERT INTO myw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wankuyeim gamaga babaw ven towen waseg mo isilamaws wak, makava ikawna̱weins, mamagina takabala̱weins tasiyas. Wankuyeim babaw gamag mo isawls, iyousis min-Masidoniy tasiyas Gayus son Alistak, mo ibiteilis inawes buntuman kaleiwag waseg. Kweiboug tasiyas sisiy Pawl nimeis wa̱ked. ");
INSERT INTO myw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawl sivinan beisiw bein buntuman kaleiwag wanuwan, tage tayakelesiys bo isilbwades. ");
INSERT INTO myw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tasiyas guyawun Esiy mwasanin, kweiboug-o nisiwa̱youbs waseg Pawl, tasiyas mo ikayabes sigamag va̱gan kid bidibakes Pawl, ilansa, “Awoum ya̱koum bukun buntuman kaleiwag wanuwan; awoum!” ");
INSERT INTO myw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Gamag babaw, asilivan kweitan kweitan iwkuwaks, ta-kal biligen; o babaw gamag nag ikakins aveiyag wawun ikatuyouns nimeis, iwkuwaksa mav. ");
INSERT INTO myw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Min-Yudiy mo idibakes Alekisan, ilansa, “Kulivan va̱gan babaw gamag bikakins yakamey ta-ivag silawun sinap towen;” gamag babaw mo iyabinis towen Alekisan, in wamtes gamag babaw, itamnow naman va̱gan bika̱pays, mo bilivan. ");
INSERT INTO myw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gamaga babaw ikakins gum-Yudiy towen, mo iwaks, ages ikobobt-wan, akweiy veit waseg iwkuwaks, ilansa, “Min-Epesos ya̱kids daguyaws Dayan, mana̱wen singay natawtoun.” ");
INSERT INTO myw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tanuwagan ven isap, mo ikatitun sikawnawein, ilana, “Min-Epesos yakamiy, vena babaw gimgilis ikakinsa davanuys bulagan peinan ya̱kids tamtakavateins nabunatum dayowbads avakaein Dayan, sona nadakul nises, kweiboug-o meinoy neim liba̱lab nikalivatow neim watinow. ");
INSERT INTO myw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","“Peinan youd tasiyas mounid, nag kadilok teitan gamag bisen kweitan livan, nag. E, kadilokena kukwa̱pays kusesus, peinan nag aveiyag bivag, nag. Awoum kuwkuwaks, o kwawnaweinsa mav, awoum. ");
INSERT INTO myw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","“Gamag tasiyas nukumeyes nag ineis iveinaws Dayan wanbunatum; nag ivtokes livan dayowbads mana̱wen, nag. ");
INSERT INTO myw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","“Magat Dimitil sivinan biyatel teitan gamag, o magat takatanaks yakamiy simiy Dimitil sivnamiy bukuyateles teitan gamag, ya̱tal nises, o gabman nisesus; kadiloka bukuyateles simiy, gabman mo bikaleiwags. ");
INSERT INTO myw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","“Kukin bika̱bwag sikaleiwag tasiyas gabmans, igaw tutan gamag babaw bikatuyouns bimeis, mo babawa gamag bikaleiwags sinap towen silma̱nin. ");
INSERT INTO myw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","“Nag ivag silawun sinap towen nagein kwawnaweinsa mav. Magat daguyaws avakaein biligen, mo bikatiga̱neids, nag kweitan livan nises waseg ya̱kids va̱gan bitakatimapus anilivan; moumouvit mo bitalivatus. Kadiloka kunounas kuneis wamibunatum tatineimiy.” Iliganes, mo inounas, ineis wasibunatum. ");
INSERT INTO myw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","(-) ");
INSERT INTO myw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bo iyakousis asisinap to nikawnaweins mav; nag ivag kweitan kawnawein, nag ivag kweitan tamwa̱geg, nag. Bo ikous. Pawl mo idawes ven towen tayakelesiys-nen, iguyes tasiyas, imulouls siney, mo inoun in Masidoniy. ");
INSERT INTO myw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ita̱vin ven tasiyas Masidoniy wawnuwan; anilivan babaw igeiguy wasigeis, mo inoun in Gilis. ");
INSERT INTO myw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","4","Isesuna ee... kweitoun tibukon, min-Yudiy mo asisinap ikatilawos sivines kid beiweiys Pawl. Misiya̱mun towen Pawl nanon ivag bo beikuk bein Siliy; mo iligen liva̱nen asisinap kalbaleb, mapuna ikanavin nanon, mo inounas wa̱ked, ikanapels Masidoniy, siney gum-Beloy teitan, Pilos natun yagan Sopetal, sisiy min-Tesalonik asteiy, Alisitak son Sikanid; sisiyas gum-Da̱biy yagan Gayus son Timotiy, sisiyas min-Esiy tasiyas Tikikos son Tilopim. ");
INSERT INTO myw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tasiyas imgwayemas, mo ikaymatemas ven Tilowas waseg. ");
INSERT INTO myw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ikous sagal to nag bitakams bled son yist, mo ka̱touw ven Pilipay waseg, ka̱kuk ee... yam kweinim ikous mo ka̱lug Tilowas, mo kanekes tasiyas; kases simayas katanok wik. ");
INSERT INTO myw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wik kweitan nakabsilamaw, Sa̱bat waseg, kakatuyoun nakam, va̱gan bakakiv bled baka̱kam, ma̱wan Yeisuw nakaleiwag. Pawl mo iguyes tasiyas; o peinan bo binoun nubweig, singay iveiyov anilivan wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mabunatum wanakaew, o imalamp babaw wabunatum towen. ");
INSERT INTO myw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Watapwan boug, Pawl igawa illivan; tawlat teitan yagan Yutikos isin wasinta̱boul, matan inanup; o Pawl igawa illivan, taw towen imasis kangagay, mo ikalouw bunatum kastounun waseg, in watinow. Gamag ineis watinow, ikines imasis, inupes bo imat. ");
INSERT INTO myw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pawl ibus, ibasin kitatun, mo iwliboub wa̱won taw towen, ilivan, idibakes gamag, ilana, “Awoum bigeg ninoumiy; mwamovan nises.” ");
INSERT INTO myw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Pawl imwen in wanakaew, sinsiney mo ikivis bled ikams, illivans ee... walalayis mo inoun in. Gwad towen itokes inawes wanbunatum, imwa̱saws seikwan, peinan sona mwamovan. ");
INSERT INTO myw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Yakamey nakan naka̱touw wa̱wag, naka̱kuk silma̱nin Asos va̱gan bakakayamat Pawl ven towen waseg; towen gog sivinan kid beinoy wa̱ked, o nidibakem ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","E, imekem Asos waseg, simey towen naka̱kuk nakan Mitilin. ");
INSERT INTO myw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Neiyam nen mo ka̱kuk kan Kiyos walasin; neiyam nen mo kasap Samos; neiyam nen mo ka̱lug Milit. ");
INSERT INTO myw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nakakalipouy Epesos peinan nanon Pawl bo ma̱wan; nag ivag sivinan yam babaw bisesuna Esiy, ikatima̱mal nuwanaw kid bisap Yelusalem, silma̱nin Kaltuwon anayam mo bilouvat Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ven Milit waseg Pawl idawes min-Epesos tayakelesiys situwa̱veks bimeis. ");
INSERT INTO myw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Isaps mo idibakes mamagina, “Kukwakinsa agusinap tuta babaw nases wasigeis yakamiy. Wanmugwana asap Esiy waseg nukukineigs ee... bweilima babaw agusinap bo ma̱wan-wan. ");
INSERT INTO myw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","“Nawwotet daGuyaws nawotet, ta-akaypom sinap; tut babaw nanoug igeg, navva̱lam-wan, o min-Yudiy tut babaw biyagageigs kid, a̱bag niva̱ges singaya igeg. ");
INSERT INTO myw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","“Nag akayus agulivan wasigeis yakamiy, nag. Ivag sivinag balabeimiy; babaw bo asekeimiy, bo akatimlakeimiy buntuman tapwa̱loul waseg o wamibunatum-vak tatineimiy. ");
INSERT INTO myw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","“O min-Yudiy bo adibakeimiy, o mina-Gilis bo adibakeimiy, alana, ‘Kadiloka bikanavin ninoumiy, bukunekes Yowbad, o bukusimounids daGuyaws Yeisuw waseg.’ ");
INSERT INTO myw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","23","“Tut gog towen Yowbad Kululuwan bo isimkineig ban kid Yelusalem. Nag akakin aveiyag balouvat ven towen waseg; deisa vena babaw wasigeis Kululuwan Towen Bwanabwein ikatimlakeig a̱bag bo bigeg, o bisenags wa̱deil ven to Yelusalem waseg.’ ");
INSERT INTO myw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","“O peinan daGuyaws Yeisuw nawotet bo isekeig gunawotet towen, akokew kid liva̱nen nasiwa̱youb Yowbad, bassekes kid gamag babaw wasigeis; o nag akayus mwamovag tatoneig; deisa bayakous Yeisuw nawotet towen. ");
INSERT INTO myw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kweiboug-o nageiguy aguyeimiy liva̱nen Yowbad nakaleiwag; o nagein gog kamnat akakin-wan nag vayuwein ba̱yum bam bukukines magig, nag. ");
INSERT INTO myw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","“Nagein adibakeimiy mounid bo asekeimiy Yowbad anilivan va̱gan biymoveimiy; nag kweitan akayus, nag akawum, nag. Kukin kavel yak bukupiyev, mo bukukwanig; takaleiwag ya̱koum. ");
INSERT INTO myw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Kuvna̱seimiy yakamiy, o kuvna̱ses Yowbad nagamags, Kululuwan Towen Bwanabwein nisekeimiy miwotet va̱gan kid bukumtakavates tasiyas; kadiloka kumtakavates Yowbad alen mamagina tayakelesiys tasiyas, peinan bo iyamayises tasiyas buya̱vin tonen waseg. ");
INSERT INTO myw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Yey bo banoun; akakin-wan takalbalebs mwasanin igaw mo biweis wasigeis yakamiy; biyagages tayakelesiys; o tasiyas magina awuk bulawud, bikapasal nuwes bikananeiys; o tayakelesiys magina sip, mamagina awuk bulawud bigades, bikatimates. ");
INSERT INTO myw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","“Akakin mwasanin gamag yakamiy igaw bukutamanaws, bukwatidavis tayakelesiys mwasanin, va̱gan kid bikabkunimiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","“Kadiloka kuvna̱seimiy. Kununuways-wan kweitoun bweilim nases wasigeis yakamiy, adibakeimiy, aguyeimiy katanok katanok yakamiy; iwta̱wout mitinagig, yam katanok katanok waseg, o boug katanok katanok waseg. ");
INSERT INTO myw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Tut towen nagein kadilok Yowbad bimtakavateimiy, kadiloka kuliganes liva̱nen nasiwa̱youb wasigeis yakamiy, mo bikatimweis kululuwamiy, bikayuseimiy simiyas yakamey, angamag tonen babaw ya̱kids. ");
INSERT INTO myw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Kweiboug simiy yey nitasesus, nag apwa̱kit soug namoney o anakweim o nawliyoug; nag. ");
INSERT INTO myw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","“Kukwakinsa wanamag tatoneig nawtel silma̱nin kag o gunavavag, o bo awotet va̱gan bagimwel sigwey sivavag o kaeis tatineis. ");
INSERT INTO myw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","“Agusinap towen waseg, bo akatimlakeimiy va̱gan kid bukukwakins bweina bitawotets ma̱wan, va̱gan bitalabes sidayas tasiyas tougweys. Kadiloka kid taninuways daGuyaws Yeisuw anilivan mamagina, ‘Soum bisiwyoubum mo bukumwa̱saw; tage bukusiwyoub soum bukumwa̱saw singay avakaein.’” ");
INSERT INTO myw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Illivan ikous, mo ikululs siney tasiyas, initoug Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Ikous, mo iva̱lams asibabaw-wan, iwliboubs Pawl wa̱won, imulouls sisiy. Iva̱lams avakaein peinan anilivan Pawl mamagina, “Nag yamtan yam bukukines magig, nag.” Igawa ivva̱lams mo sisiy Pawl ineis wa̱wag. ");
INSERT INTO myw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pawl itouw wa̱wag, mo itanouy sineyas wasigeis. Yakamey katanouy, ikous, ka̱kuk, kadumwala Kos. Neiyam nen, mo kan Lods; kakilev Lods mo kan Patal. ");
INSERT INTO myw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ven Patal waseg mo kaban wag akitan, kakita bikilev silma̱nin Pinisiy, mapuna ka̱touw mo ka̱kuk. ");
INSERT INTO myw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ka̱kuk kasisawl ee... mo kaban ven Saypilos, inoy wamakimaw, kasawl mo kan Siliy, ka̱lug ven yagan Ta̱yil va̱gan wuliyoug babaw wa̱wag beibus bein wanakaew. ");
INSERT INTO myw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kanineiv tayakelesiys, kaban mwasanin, mo kasesuna simayas tasiyas katanok wik; o peinan Yowbad Kululuwan ikatimlakes, ikakins-wan igaw min-Yelusalem biyagages kid Pawl, mapuna illivans, “Awoum kun Yelusalem.” ");
INSERT INTO myw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","6","Bo ikous matut simayas tasiyas mo katamanaw kanoun. O simayas tasiyas, sisiyas sikwavas o nitsiyas, nakan watoulan ven, kabasin kititum wakawalaw kanitoug Yowbad waseg, mo kamuloul simsimeyas tasiyas, ka̱touw wa̱wag, mo katanouy; tasiyas mo iyums ineis wasiven. ");
INSERT INTO myw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kakilev Ta̱yil kasisawl ee... mo ka̱lug Pitolimey, kanekes tayakelesiys, kamuloul simayas tasiyas, kases-vak wasibunatum katanok yam. ");
INSERT INTO myw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Neiyam nen nakatanouy nakaw Sisaliy, mo ka̱siw Pilip wanbunatum, anbwabwal yakamey. Mtowen Pilip nawotet igeiguy-wan livan bwanabwein, liva̱nen Yeisuw. Kweiboug-o takaweins liva̱nen Yeisuw nisekes siwotet towen siney tawaw teinim tatanok, ven Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nitun nakubukwabs na̱nim nay; Yowbad nisekes asisinap, mo ilivnakes Yowbad anilivan. ");
INSERT INTO myw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","11","Kasesun ee... bo imwemway-nen, teitan palopit meinoy neim Yudiy; mtowen yagan Agabous, imekem mo ikow Pawl anpalit iyawen naman o kaken tatonen; ilana, “Yowbad Kululuwan ilivan ma̱wana: Ven Yelusalem waseg min-Yudiy biyawanis naman o kaken tanuwagan palit towen, bisilkodes va̱gan kid tobwag ven gimgilis mo biyagages.” ");
INSERT INTO myw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kaligen anilivan ma̱wan; simayas tasiyas misikena gimgilis ven towen; yakamey mo kadibek Pawl; kalana, “Awoum kun Yelusalem; bweina kuses.” ");
INSERT INTO myw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pawl mo ikatimop agem, ilana, “Awoum kuva̱lams; ma̱wan bo bigeg nanoug. Nanoug bo atam va̱gan kid tasiyas biyagageigs, daGuyaws Yeisuw peinan. Bweina biyousigs; bweina bikatimateigs; bwein-wan.” ");
INSERT INTO myw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tage Pawl nag biligen amalivan, mapuna kasesun-wan, kalana, “Magat Yowbad nanon ma̱wan, bweina bivag.” ");
INSERT INTO myw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Ikous, mo kakatunag bakan Yelusalem, simayas tasiyas min-Sisaliy tayakelesiys mwasinis. Tasiyas imgwayemas nakan Mineson wanbunatum, kamasis. Mtowen gum-Saypilos, wanmugwana niligen liva̱nen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nakasap Yelusalem, tayakelesiys mo ikinemas, singaya imwa̱saws pinem. ");
INSERT INTO myw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Neiyam nen simey Pawl mo kanekes Yemes siney tayakelesiys situwa̱veksa babaw. ");
INSERT INTO myw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pawl imulouls siney tasiyas ikous, mo ikamtel youd katanok katanok Yowbad niwtel tobwag ven gimgilis wasigeis, peinan Yowbad son Pawl niwteles wotet towen. ");
INSERT INTO myw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Iliganes, iya̱kawns Yowbad waseg, mo idibakes Pawl; ilansa, “Gwade, adok kukwakin min-Yudiy singay babaw tawsans bo niliganes liva̱nen Yeisuw; tasiyas babaw-wan ivna̱ses bwein Moses nakaleiwag waseg. ");
INSERT INTO myw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","“Bo niliganes liva̱neim mamagina, ‘Towen Pawl ipiyev Moses nakaleiwag, o ikatimlakes min-Yudiy vena babaw wadaban pwepway, va̱gan nag bibwabwes momwes nitsiyas, o bipiyaves kid adsinaps kweiboug Moses nisekeids.’ ");
INSERT INTO myw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Ama̱wan bitavkek? Peinan bo biliganes liva̱neim yak, mwana nukum Yelusalem waseg. ");
INSERT INTO myw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","“Adok kuvag ma̱wan. Tawaw tayakelesiys simayas teivas nisesus; peinan asilivan waseg Yowbad, kakita bo biduyes kunus mo bisiwa̱youbs Yowbad waseg, ma̱wan Moses nakaleiwag. Kadiloka kunekes simwey tasiyas, kuwidis woumiy, money kusekes va̱gan beiluns beibwein Yowbad waseg, mo biduyes kunus tasiyas. Gamag babaw bikineimiy simwey tasiyas, mo bikakins liva̱neim to niliganes kweiboug iyyaweids-wan, peinan nukutam Moses nakaleiwag waseg, o kuvnas nakaleiwag towen. ");
INSERT INTO myw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Makaleiwag wasigeis tobwag ven gimgilis, kalisiy isimounids waseg Yeisuw, nakalel silet nein wasigeis tasiyas, nakakaleiwag va̱gan kid bipiyaves kan nimgwavis silma̱nin tobwag yowbad, o buyav, o viniyonan man bo niskwen kayon neimat nanawan; o nag bikanavays mav.” ");
INSERT INTO myw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pawl iligen, itam. Neiyam nen itokes gamag tasiyas, iwidis wous, mo isiw Yowbad wanbunatum, Pawl mo idibek tanuwagan lun; ilana, “Yakamey amalivan Yowbad waseg; yam tasiyas beikous bakaduy kunum, bo baka̱lun Yowbad waseg, ma̱wan Moses nakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","Asiwik kakita beikous, Pawl sen tawaw tasiyas nisesus Yowbad wanbunatum; min-Yudiy siven Esiy waseg mo ikines, ika̱buts gamaga babaw, iyousis Pawl; iwkuwaks; ilansa, “Tawaw, min-Yisleil yakamiy kulabemas. Taw towen tuta babaw ikatimlakes vena babaw gimgilis va̱gan kid bikasigumids ya̱kids, o bikasigumis adsinaps, o Yowbad nabunatum towen. Tut gog towen bo imeyes mina-Gilis, isiws wanuwan Yowbad nabunatum bunawen nikayus silma̱nin min-Yudiy ya̱kids. Bo igak!” ");
INSERT INTO myw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ilivans ma̱wan peinan kweiboug nikines gum-Epesos towen Tilopim son Pawl nisesus waven; idokes kid Pawl itok taw towen ineis Yowbad wanbunatum. ");
INSERT INTO myw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ven towen gimgilis asibabaw-wan mo isaps, isisawls, ikatuyouns imimeis, iyousis Pawl, ibiteilis Pawl, in watoulan Yowbad nabunatum, awkwedan mo ikatibagus. ");
INSERT INTO myw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tasiyas iwaweiys Pawl, sivines kid bikatimates. Mina-Lom sitakanaviy babaw nisesus Yelusalem. Teitan gamag mo inek takanaviys sitovek, ikow liva̱nen asisinap tasiyas min-Yelusalem, peinan ikawnaweinsa mav. ");
INSERT INTO myw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Takanaviys sitovek mo idawes takanaviys sisiyas sitakalikays, nuwanaw isawls va̱gan binekes gamag tasiyasa babaw. Tasiyas ikines takanaviys sisiy sitovek bo nimeis, mo ipiyaves anwaway Pawl. ");
INSERT INTO myw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Takanaviy sitovek mo iyous Pawl, idibakes natakanaviys biyawanis kid Pawl naman palayun-wan sen waseg, mo ilana, “Kal mtowen? Aveiyag inuwek?” ");
INSERT INTO myw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Gamag babaw mo iwkuwaks, livan kweitan kweitan illivans. Ta-ma̱wan biligintun liva̱nen taw towen; idibakes natakanaviys; ilana, “Kutokes taw towen, kumeyes; taneis wadabunatums.” ");
INSERT INTO myw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Mo itokes Pawl, inawes wasibunatum. Ikapasal nuwes gamaga babaw ikabwa̱kunsa watiblous, silma̱nin beiweiys kid, iwkuwaks ilansa, “Kuweiys! Kuweiys!” Ilivatus wa̱tet, takanaviys tasiyas mo inupes Pawl, inounas, peinan gamaga babaw sivinesa biyousis. ");
INSERT INTO myw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","38","Kakita beisiws wanuwan takanaviy sibunatum, Pawl mo idibek sitovek; aga-Gilis waseg ilivan; ilana, “Tab kadilok balivan waseg yak?” Sitovek ilana, “Kukwakin aga-Gilis, ne? Adok ya̱koum gum-Yidipt towen mwana nukumgwayes kweivas tawsan tawaw, tasiyas tawayins gamag, nukuneis wanawoud sivinamiy kid bukwanaviys wasigeis Gabman Lom takanaviy yakamey.” ");
INSERT INTO myw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pawl ilana, “Nag, yey gum-Yudiy, gunaven avakaein yagan Talisus wawnuwan ven avakaein Silisiy. Tab kadilok balivan gamaga babaw wasigeis?” ");
INSERT INTO myw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Takanaviy sitovek itam. Pawl iton tet towen wakunuwatan, itamnow naman, mo ika̱pays tababaws-wan; wankuyeim Pawl mo ilivan aga-Ibliw waseg, ilana: ");
INSERT INTO myw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Sigwey, timog budag yakamiy, kuliganes agulivan, mamagina akayan wasigeis yakamiy.” ");
INSERT INTO myw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tasiyas iliganes aga-Ibliw waseg illivan, mo ikika̱pays va̱gan kid binganegs bwein. Mo ilivan. ");
INSERT INTO myw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ilana, “Yey gum-Yudiy yey. Inag nikopweig ven Talisus waseg, wawnuwan ven avakaein Silisiy; tage bo askul ven towen Yelusalem waseg. Tamwey towen yagan Gamaliyel ikatimlakeig, mo akakin dakaleiwags ya̱kids, akakinbunik, iseiw nuwag Yowbad nawotet, ma̱wana babaw yakamiy tut towen. ");
INSERT INTO myw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“O gamag tasiyas inoyes kadetan ked, bo amop asisinap; mwasinis akatimates. Vinay o tawaw ayousis asenas wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","“Tanuwgwes lun sitovek avakaein, o tammwayas babaw ikakins agulivan towen mounid. Peinan bo isekeigs let silma̱nin budidayas ven Damasik waseg, anounana wa̱ked silma̱nin Damasik va̱gan bayousis gamag, bameyes Yelusalem, va̱gan kid takaleiwags mo bimop asisinap. ");
INSERT INTO myw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ya̱nay waseg anoun kadiyakusa Damasik, mo mititeilin avakaein imekeig, ma̱wana kavikawn meinoy neim walba̱lab. ");
INSERT INTO myw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","“Akalouw wapwepway aligen aygan teitan; ilana, ‘Soul, Soul, aveiyag wawun kuybilebeig yey?’ ");
INSERT INTO myw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Akatimop aygan, alana, ‘O guyaw, kavel yak?’ Ilana, ‘Yey gum-Nasalet Yeisuw, mtowen tut babaw nukuybileb.’ ");
INSERT INTO myw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Tasiyas sigwey nakan, bo ikines mititeilin, tage nag biliganes aygan towen, soug yey nakallivan. ");
INSERT INTO myw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Wankuyeim mo alivan; alana, ‘O guyaw, aveiyag bavag?’ Guyaw towen mo idibakeig, ilana, ‘Kutamanaw kun Damasik, igaw teitan gamag mo bikatimlakeim muwotet, aveiyag bakaleiwag va̱gan bukuwtel.’ ");
INSERT INTO myw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Peinan mititeilin ikaligwen matag, ta-ma̱wan bakin. Misinaka iyousis namag itokeigs, mo kan Damasik. ");
INSERT INTO myw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ven towen waseg taw yagan Ananiyas; min-Yudiy tasiyas misikes ven towen ikakinsa tadidumwal, peinan tavna̱sein Moses nakaleiwag towen. ");
INSERT INTO myw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","“E, mtowen imekeig itamanaw itom mo ilivan; ilana, ‘Bwadag ya̱koum Soul, towen bukukin.’ Ilivan ikous mo akinbunik, akin taw towen Ananiyas. ");
INSERT INTO myw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","16","“Mo ilivan, ilana, ‘Tammwayas siYowbad bo ikaliwageim va̱gan kid bukukwakin nanon, o bukukin tadidumwal towen, o bukuligen aygan tonen; o amsinap towen bisekeim kadiloka bukwatipel kusekes gamag babaw wasigeis. E, tut towen aveiyag kukwayamat? Kutamanaw, kutam mtowen waseg, mo babapta̱yseim, yagan tonen waseg, bo biwid mukwalbaleb, va̱gan beikous.’ ");
INSERT INTO myw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","“Ikous, na̱yum nam Yelusalem, akulul, annitoug Yowbad wanbunatum, matag mo isisawla mav, akin Guyaw towen idibakeig; ilana, ‘Nuwanaw kun kulisow Yelusalem, peinan min-Yelusalem bipiyaves amlivan, liva̱neig yey.’ ");
INSERT INTO myw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","20","“Yey alivan; alana, ‘O Guyaw, tasiyas ikakins sinagoga babaw wasigeis bo ayablebes taliganeins liva̱neim yak; mwasinis awaweiys vatul waseg, mwasinis asenas wa̱deil. Kweiboug neiweiys takanawein aygam mtowen Sitiben, yey bo a̱tam wotet towen waseg, natamanaw akikin, bo amtakavet asikweim tawayins taw towen.’ ");
INSERT INTO myw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Guyaw towen mo idibakeig, ilana, ‘Kunoun, bakayabeim bukun kadiveiyov, silma̱nin tobwag ven gimgilis.’” ");
INSERT INTO myw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Anilivan babaw iligintunis, tage iliganes livan towen “Tobwag ven gimgilis,” mo iwaks avakaein, ilansa, “Singaya takalbaleb towen; kuweiys taw towen. Na-ikadilok son mwamovan bises.” ");
INSERT INTO myw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Iwkuwaksa, ilivelovs asikweim, musamusan pwepway ilivelovs ininein wanakaew, singay ikapasal nuwes. ");
INSERT INTO myw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Takanaviy sitovek mo ilivan; ilana, “Kutokes taw towen kunawes wanuwan bunatum, kuweiys vatul waseg va̱gan bikamtel aveiyag anilivan waseg ikawkunes.” ");
INSERT INTO myw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Iyawanis won Pawl; ta-ma̱wan bigogewn naman o kaken. Takalikay teitan itamanaw wadadan. Pawl mo idibek takalikay towen; ilana, “Nag kadilok bukwatima̱veigs, guma-Lom yey. Kadiloka kuyateleigs, magat bukuba̱nes agusinap kalbaleb, mo kuweigs.” ");
INSERT INTO myw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Takalikay iligen anilivan towen, inek natovek, idibek, ilana, “Aveiyag bukuvag? Taw towen guma-Lom teitan.” ");
INSERT INTO myw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Takanaviy sitovek mo inek Pawl, ikatigan, ilana, “Adok ya̱koum guma-Lom ya̱koum, ne?” Pawl ilana, “Ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Takanaviys sitovek ilana, “Money avakaein bo asek, mo amlavag guma-Lom.” Pawl ilana, “Peinan kweiboug-o tamag imlavag guma-Lom, mo inag nikopweig guma-Lom tatonen yey.” ");
INSERT INTO myw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Iliganes tasiyas, ikakiws wous peinan kakita bo beiweiys Pawl; sitovek-vak anpwa̱yat seikwan, peinan guma-Lom towen bo iyawanis naman o kaken. ");
INSERT INTO myw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Iyam nen ga̱boug mo ilikus vatul wa̱won Pawl, o peinan takanaviys sitovek sivinan bikakin wawun min-Yudiy sikavikun waseg Pawl, mo idibakes bimeis tasiyas tanuwgwes lun situwa̱veks sisiyasa takaleiwags babaw; teitan mo itok Pawl, imey, itamanaw wamtes tasiyas. ");
INSERT INTO myw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pawl ikinbunikes takaleiwags tasiyas, ilana, “Tuwag yakamiy, yam babaw nases agusinap bwein wamatan Yowbad, nagein gog bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tanuwgwes lun sitovek avakaein Ananiyas mo idibakes tasiyas nitamanaws wadadan Pawl, ilana, “Kuweiys wadon taw towen, singay kalbaleb anilivan.” ");
INSERT INTO myw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pawl mo idibek Ananiyas, ilana, “Yowbad bo beiweim yak, magina buda̱kay kalbaleb ya̱koum, ya̱lig isin, magin ibwein, tage bo ipwas, bukuyateleig Moses nakaleiwag waseg; tage bo kugulek nakaleiwag towen, peinan kudibakes tasiyas kid beiweigs mav.” ");
INSERT INTO myw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tasiyas itomos wadadan Pawl, ilansa, “Oo ne! Bo kuyeg Yowbad nagamag towen, ne?” ");
INSERT INTO myw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pawl ilana, “Nag bakakin mtowen tanuwagan lun sitovek avakaein. Akakin Bukitab liva̱nen mamagina, ‘Awoum kuyeg mitovek.’” ");
INSERT INTO myw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pawl mo ikines tasiyas mwasanin Sadusiy, mwasanin Palisiy, aygan avakaein mo idibakes takaleiwags tasiyas, ilana, “Tuwag yakamiy, yey Palisiy yey, tamag gog Palisiy. Bo aya̱tal peinan bo anamis va̱gan bitakits vayuwein kanig waseg.” ");
INSERT INTO myw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","8","Ilivan ma̱wan ikous, tasiyas Palisiy bo ikamnimans sisiyas tasiyas Sadusiy; ilivis, iva̱ges bod akweiy. Peinan tasiyas Sadusiy idokes gamag nag beikits vayuwein; ta-kweitan anelos nises; ta-kweitan kululuwan nises; tasiyas gog Palisiy idokes gamag beikits vayuwein, o anelos nises, o kululuwads nises-vak. ");
INSERT INTO myw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tasiyas babaw-wan mo ikamnimans avakaein. Igawa ikamnimans takatimlakeins Palisiy sikaleiwag mwasanin mo itamanaws, ages avakaein, ilansa, “Kadok nag kweitan kalbaleb nises taw towen waseg; nag. Adok anelos teitan o kululuwan teitan bo ikatimlek ansinap.” ");
INSERT INTO myw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tasiyas babaw-wan singay ikavikuns; takanaviy sitovek idok kakita biyousis Pawl bikisa̱lis kid won, mapuna idibakes natakanaviy biyousis Pawl, bikawes, binawes wasibunatum. ");
INSERT INTO myw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Boug towen waseg naGuyaw Yeisuw mo itamanaw wadadan Pawl, ilana, “Awoum beivag ampwa̱yat. Ma̱wan kweiboug liva̱neig nukusek ven Yelusalem waseg, igaw ven Lom waseg bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Iyam nen ga̱boug, min-Yudiy tabebaws-wan, sinawavas o sinawanim, mo ivta̱mes sisiyas va̱gan beipos kid mo beiweiys Pawl. Ilansa, “Kalisiy yakamiy bukukwams o bukumoums, Yowbad bo beiweimiy. Igaw bitaweiys Pawl, mo bitakams.” ");
INSERT INTO myw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","15","Tasiyas mo inekes tanuwgwes lun situwa̱veks sisiy takaliwageins ven, ilansa, “Yakamey amalivan Yowbad waseg, bo baka̱pos ee... tonena baka̱weiy Pawl. O yakamiy kamnat amilivan kusekes takanaviys sitovek, kulivans mamagina, ‘Taw towen Pawl kutok kumey, sivinem bakaytel, kweitan sinap silma̱nin, va̱gan bakakinbunik.’ E, kukin takanaviys sitovek beitam, Pawl bimey, yakamey bakakayamat, tutan bo beim, mo baka̱weiy.” ");
INSERT INTO myw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Gwad teitan, Pawl kadan, bo iligen asilivan, mo in, isiw takanaviys wasibunatum, livan towen mo ikatipel isek Pawl. ");
INSERT INTO myw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pawl mo idow takalikay teitan, ilana, “Gwad towen sinap kweitan nisisiy. Kadiloka kutok, kuneis mutovek waseg, igaw kweitan livan mo bisek.” ");
INSERT INTO myw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Itok gwad towen, inekes natovek, ilana, “Tasiwun deil towen Pawl bo idaweig, ilana, ‘Kutok gwad towen kunekes mutovek waseg, anilivan mo bisek.’” ");
INSERT INTO myw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Natovek mo itok gwad towen, asteiyuna ineis palatan, mo ilana, “Aw-youd bukunukweig?” ");
INSERT INTO myw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","21","Ilana, “Tasiyas min-Yudiy ninous ma̱wana, nubweig kid bivatams waseg ya̱koum va̱gan kid bukuyamanes towen Pawl kusekes takaleiwags tasiyas wasigeis, mamagina biyateles, bikatugwans waseg, va̱gan ansinap bikakins kid. Nag gog, peinan mwasanin ikayamats, sivines kid beiweiys. Awoum kutam. Tawaw tasiyas sinawavas o sinawanim tapsapos sivines beiweiys. Bo itabudabods Yowbad waseg biva̱ges kid ma̱wan. Bo ikatunags ikous, ikaymatesa ge amlivan ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Takanaviys sitovek ilana, “Bwein-wan. Kadiloka kunoun. Bo talivan aditeiy bo deis; awoum bukudibakes simwayas; awoum!” ");
INSERT INTO myw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Takanaviys sitovek mo idawes takalikays asteiy bimeis, mo idibakes; ilana, “Kukin takanaviys lakatuy bikatunags bineis Sisaliy, sisiyas tasiyas sihos sam sinawanim sinawey, sisiyas takaweins kayal lakatuy. Igaw bidadub, kwayav, mo kuneis. ");
INSERT INTO myw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","“Kuneves hos va̱gan Pawl beimwen, kuvna̱ses beibwein, kunawes binek guyaw towen Piliks.” ");
INSERT INTO myw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Takanaviys sitovek ilel let silma̱nin Piliks, mamagina: ");
INSERT INTO myw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","27","“Kalin nuwag guntovek avakaein ya̱koum Piliks. Yey Kalodiw Lisiyas; gunalet beiw. Peinan min-Yudiy niyousis taw towen, kakita beiweiys; akakina guma-Lom towen, mapuna kakatinob sigwey guntakanaviys. ");
INSERT INTO myw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","“O sivinag bakakin wawun askameiliw waseg taw towen, atok wasigeis tasiyas min-Yudiy takaleiwags va̱gan kid biyateles. ");
INSERT INTO myw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","“Tage nag ivag ansinap kalbaleb va̱gan bikatimates o bises wa̱deil, nag. Misinaka ilivans, ‘Bo igulek makaleiwag min-Yudiy yakamey.’ ");
INSERT INTO myw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","“Wankuyeim, mo aligen asisinap ikatilawos idokes kid beiweiys taw towen, mapuna akayeb va̱gan biwekeim yak; o min-Yudiy tasiyas bo adibakes, ‘Kunekes guyaw avakaein Piliks va̱gan bukuyateles taw towen Pawl.’” ");
INSERT INTO myw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sitovek nakaleiwag bo ma̱wan, takalikay tasiyas mo inawes Pawl, boug waseg, ineis Antipatil, imasis. ");
INSERT INTO myw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Iyam nen ga̱boug, tasiyas wakwakway inounas mo iyums wasiven; tasiyas tatouweins hos igaw binawes Pawl. ");
INSERT INTO myw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Inounas ee... Sisaliy, inekes guyaw towen avakaein, mo isekes Pawl son let. ");
INSERT INTO myw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ivin let ikous, mo ikatigan Pawl, ilana, “Muven avakaein amiyagan?” Ilana, “Silisiy.” ");
INSERT INTO myw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Piliks mo ilana, “Ga bimeis tasiyas biyateleims, baligen amilivan, mo bakaleiwag.” Ikous, mo idibakes nagamag, ilana, “Kadilok kumtakavates taw towen wanuwan bunatum bunavakaein, kweiboug Elod nabunatum.” ");
INSERT INTO myw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Yam kweinim ikous, iwloubus tanuwgwes lun sitovek avakaein Ananiyas son tallivan teitan yagan Telitul sisiyas tamumwey mwasanin. Inekes gabman avakaein, sivines kid biyateles Pawl. ");
INSERT INTO myw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Idow Pawl beim; Pawl im; Telitul mo isilamaw anilivan, iyatel Pawl mamagina, “Kalin nuwem maguyaw avakaein ya̱koum, peinan mukwaleiwag bwein. Nag kweitan kawpwanaw nises wamaven. Bwein-wan nakases. O mukwaleiwaga babaw nilabemas min-Yisleil yakamey. Mapuna tut babaw o vena babaw gimgilis yakamey ikalin nuwem maguyaw ya̱koum. ");
INSERT INTO myw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","“Adok nag biveiyov agulivan, sivinag gog kusiwyoubum bukuligen kid amalivan kakit waseg ya̱koum. ");
INSERT INTO myw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Taw towen kakakin singay takakon, iva̱ges min-Yudiy vena babaw wasigeis va̱gan bikawpwanaws, peinan imgwayes tasiyas min-Nasalet nidokes, mo iva̱ges moumouvit vena babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","“Taw towen idok biyageg Yowbad nabunatum, tage kasilbwed, nakayous. ");
INSERT INTO myw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","(-) ");
INSERT INTO myw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","“Igaw kukwatigan taw towen, mo bukukinbunik nakalbaleb towen nalivan.” ");
INSERT INTO myw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Igaw Telitul ilivan, min-Yudiy tasiyas itimatams, ilansa, “E, ma̱wan! Mounid.” ");
INSERT INTO myw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Guyaw towen Piliks mo ikin Pawl, itam vinum, mo Pawl ikatimop asilivan, ilana, “Peinan bweilim babaw nukusesun matovek ya̱koum, bweina basekeim agulivan. ");
INSERT INTO myw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","“Yam sinawatan akweiy nein wankuyeim mwana asap Yelusalem va̱gan batapwa̱loul. Igaw kukwatugwans min-Yudiy wasigeis mo bilivans ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","13","“Nag kal ikineig aliwon Yowbad wanbunatum, nag; nag alivan va̱gan gamag bikatuyouns biliganes aygag, nag. Nag ikatuyouns wasinagog; nag ikatuyouns waven, nag. Nag kakamniman soug teitan gamag, nag. Nag kadilok teitan bisimounid asilivan tasiyas mwana nilivans, nag. ");
INSERT INTO myw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Misinaka ba̱tam kweitan sinap waseg; makadewen ked atapwa̱loul maYowbad waseg, ked towen idokes ked kalbaleb, kid; isiba̱wemas, mapuna idokem min-Nasalet yakamey. Tage yey asimounid maBukitab sinapun, Moses nakaleiwag babaw, o palopit tasiyas asilivan babaw-wan. ");
INSERT INTO myw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","“Sigwey min-Yudiy tasiyas kanmis Yowbad bivag, mo bitakits kanig waseg, tadidumwals o takalbalebs, ya̱kidsa babaw. ");
INSERT INTO myw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","“Mapuna tut babaw sivinag agusinap bwein wamatan Yowbad, o gamaga babaw wamtes. ");
INSERT INTO myw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Bweilim babaw ikous, mwana nam wagunaven, gunmuloul asekes, o basiwa̱youb kid waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","“Bo awid woug, a̱siw Yowbad wanbunatum; sigwey nag ivag gamaga babaw, nag ikawnaweins, nag. ");
INSERT INTO myw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","“Wankuyeim mo isaps min-Yudiy mwasanin siven Esiy; o tut towen nag bimeis va̱gan bikamteles aveiyag agusinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","“O min-Yudiy tasiyas-nan nikineigs kweiboug naton takaleiwags wamtes, kadilok bikamteles aveiyag agusinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","“Misinaka agusinap towen, sigwey tasiyas nakatamanaw mo awak, alana, ‘Silawun gunya̱tal nagein, peinan asimounid bitakits kanig waseg.’” ");
INSERT INTO myw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Towen gog Piliks bo ikabunik ked makadewen, Pawl nilivan; mtowen Piliks mo ilana, “Ga-ises, ga-beim takanaviys sitovek towen Lisiyas, mo bakaleiwag.” ");
INSERT INTO myw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mo idibek natakalikay, ilana, “Bweina biyeiwas wa̱deil, mtowen Pawl; o taliven bweina bimeyes kan va̱gan bikamkwam.” ");
INSERT INTO myw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yam mwasanin ikous, mo isaps Piliks son nakwav Dilusil, mana̱wen vinen-Yudiy; mo idawes Pawl beim va̱gan bikatilutegs liva̱nen Yeisuw Kelis, livan towen Pawl nisimounid waseg. ");
INSERT INTO myw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pawl mo idibakes liva̱nen sinap didumwal, o liva̱nen kapatul, o liva̱nen Yowbad nakaleiwag igaw mo bikatukin vena babaw wasigeis. Pawl igawa illivan, Piliks gog mo ivag anpwa̱yat, ilana, “Ga-ises. Tut towen kunoun. Igaw kweitan tut bwein waseg, mo badaweim bukuyum bukum, amlivan bukusekeig.” ");
INSERT INTO myw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Bo inimis Pawl bisiwa̱youb waseg; mapuna kutukuta ididow, illivans son; ininamis gog nag, peinan Pawl ta-isek Piliks namoney va̱gan bilik Pawl, nag. ");
INSERT INTO myw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Akweiy bweilim ikous Piliks atimapun neim, yagan Posiw Pestos. Tage Piliks sivinan bilabes min-Yudiy, mapuna ikaleiwag va̱gan Pawl bisesuna wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestos isilamaw nakaleiwag, isesuna ven Sisaliy kweitoun yam, mo in Yelusalem. ");
INSERT INTO myw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Tanuwgwes lun situwa̱vek sisiyas min-Yudiy tamumwey mo inekes Pestos, ilansa, “Takalbaleb towen Pawl nises wa̱deil Sisaliy. Tabta ikadilok bukukwayeb towen beim wamaven Yelusalem va̱gan gog bakaytel?” Sivines kid bikayamats wadadan ked. Igaw beim Pawl mo beiweiys. ");
INSERT INTO myw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","5","Pestos ilana, “Nag. Bweina bises Sisaliy. Igaw kakit mo ba̱yum ban Sisaliy. O sigwey guyawaw mwasanin yakamiy bitaneis Sisaliy, inaya̱tal silma̱nin; magat nakalbaleb nises, kadiloka guyawaw tasiyas biyateles.” ");
INSERT INTO myw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ises Yelusalem nag bibabaw yam, adok kweinin-kweitoun o sinawatan, mo iwloubus in Sisaliy, imasis. Iyam nen ga̱boug mo isin wakaban idibakes nagamag wasigeis va̱gan kid Pawl bimeyes. ");
INSERT INTO myw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pawl imeyes, wankuyeim mo isunaps min-Yudiy tasiyas meinoy nimeis Yelusalem, itowas mo iyateles, ikavtagis Pawl ansinap babaw-wan kalbaleb nivvag kid; tage asilivan nag bikamnat, mapuna takaleiwag nag isimounid asilivan waseg. ");
INSERT INTO myw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pawl ikatimop asilivan, ilana, “Nag agulek min-Yudiy makaleiwag, nag. Nag ayageg Yowbad nabunatum, nag. Nag agulek Sisal nakaleiwag; nag.” ");
INSERT INTO myw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Togo Pestos sivinan bisiwa̱youb min-Yudiy wasigeis; mo idibek Pawl, ilana, “Tab kadilok bukun Yelusalem mo bakaleiwag amsinap ven towen waseg?” ");
INSERT INTO myw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pawl ilana, “Tut towen bo atamanaw Sisal wanakabkaleiwag. Kaleiwag kadilok towen-an waseg. Nag ayablebes min-Yudiy. Kukwakin agulivan towen mounid. Na-ikadilok tasiyas bikaleiwags waseg yey. ");
INSERT INTO myw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","“Magat agusinap singaya kalbaleb, ma̱wan asilivan tasiyas, mogo bweina bakanig; nag bakakiws; nag. O peinan tasiyas tayateleigs iyyaweids-wan, na-ikadilok bukuta̱meig va̱gan kid tasiyas bikatimateigs, nag. Kadiloka Sisal tonen bikaleiwag.” ");
INSERT INTO myw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pestos iligen anilivan towen, mo ineis palatan sen nagamag tassinaps mwasanin, sinsineyas illivans. Ikous, Pestos iyum, im, ilivan; ilana, “Sivinam bukunek Sisal va̱gan kid bikalawageim; mapuna bo bakayabeim bukunek mtowen Sisal.” ");
INSERT INTO myw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tut nag biveiyov wankuyeim King towen Agalip son nakwav Belinis mo imeis Sisaliy va̱gan kid bimulouls sisiy towen Pestos. ");
INSERT INTO myw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yam babaw nisesus sisiy Pestos anbwabwal tasiyas. Liva̱nen Pawl mo isek King towen, ilana, “Tutan Piliks inoun yey mo asap, teitan taw nises wa̱deil. ");
INSERT INTO myw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","“Wankuyeim an Yelusalem, tanuwgwes lun situwa̱veks sisiyas tamumwey, ven towen Yudiy waseg, mo idibakeigs; ilansa, ‘Taw towen takalbaleb; kadiloka bukumop ansinap kalbaleb.’ ");
INSERT INTO myw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Akatimop asilivan, alana, ‘Yakamey mina-Lom, nag ivag amasinap ma̱wan. Kadiloka kuyateles taw towen wamatan, o towen biyamen amilivan; kukin ansinap kalbaleb nises, mo bakamop; kukin gog nag, bo nag.’ ");
INSERT INTO myw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Wankuyeim imeis tasiyas, nag akabiyun, nag. Neiyam nen mo asin wakabag va̱gan kid bakaleiwag, adibakes gungamag bimeyes taw towen. ");
INSERT INTO myw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","19","“Adok ansinap kalbaleb; nag gog, tasiyas itamanaws iyateles, nag ikavtagis ansinap kalbaleb; misinaka liva̱nen sitapwa̱loul tatineis, o liva̱nen teitan taw yagan Yeisuw nikanig, o Pawl ilivan namwamov igawa nises. ");
INSERT INTO myw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","“O yey nag bakakin ama̱wan bakaleiwag sinap towen waseg, akatugwan taw towen waseg, alana, ‘Tab kadilok bukun Yelusalem mo bakaleiwag sinap towen waseg?’ ");
INSERT INTO myw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","“Towen gog ilana, ‘Nag. Sivinag datoveks avakaein bikaleiwag.’ Mapuna akaleiwag alana, ‘Ga-bises wa̱deil mo banineiv amata ked waseg baban, mo bakayeb binek datoveks towen Sisal.’” ");
INSERT INTO myw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agalip mo idibek Pestos, ilana, “Sivinag baligen taw towen anilivan.” Pestos ilana, “Bwein. Nubweig mo bukukin.” ");
INSERT INTO myw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Iyam nen ga̱boug Agalip son Belinis mo ineis wabuntuman liwon, sisiyas takanaviys situwa̱veks o guyawuns ven towen, asikweim maynamnabwein nisikams, askatubub singaya bwanabwein niva̱ges. Pestos mo idawes nagamag bimeyes Pawl, mo imeyes, itamanaw wamtes. ");
INSERT INTO myw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pestos mo ilivan; ilana, “Agalip, making ya̱koum, o tawaw babaw yakamiy wabunatum towen, kukines gamag towen. Min-Yudiy, Yelusalem waseg o ven towen waseg, intougigs va̱gan bamop ansinap, niwkuwaks, ilansa, ‘Kuweiy. Nag kadilok son mwamovan bises.’ ");
INSERT INTO myw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","“Bo akatiligen asilivan, akatugwan waseg, akakin nag ivag ansinap kalbaleb. Na-ikadilok ba̱weiy taw towen. O towen nilivan, ‘Sivinag guntovek avakaein bikaleiwag’; mapun bakayeb binek Sisal. ");
INSERT INTO myw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","“Kukin bakayeb, nago akakin ansinap, aveiyag balel wa̱let. Mapuna bo amey taw towen wamitamiy, ya̱koum making Agalip simwey guyawaw tababaws, va̱gan kid bukunganegs anilivan; adok bitaba̱nes ansinap kweitan, mo balel wa̱let, va̱gan Sisal bikaleiwag. ");
INSERT INTO myw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","“Adok na-ikadilok makava bakayeb, nag.” ");
INSERT INTO myw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agalip mo idibek Pawl, ilana, “Kadiloka kulivan.” Pawl itamnow naman, ilivan mamagina: ");
INSERT INTO myw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Ilana, “Peinan min-Yudiy niyateleigs, ilivans kid agusinap kalbaleb, o tut nagein ikalin nuwag peinan ya̱koum bo kuligen agulivan, matovek avakaein ya̱koum. ");
INSERT INTO myw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","“Peinan kukwakin amasinap, min-Yudiy yakamey, o kukwakin silawun makamnimana babaw, sivinag kwaptuleim bukuligen agulivan. ");
INSERT INTO myw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","5","“Min-Yudiy babaw ikakins agusinap. Ikakins igaw-o wagwa̱dig gungamag wasigeis, o ven Yelusalem waseg, gum-Yudiy yey; o tut kadiveiyov ikakins agusinap, Palisiy teitan yey. O yakamey Palisiy singaya kavnas min-Yudiy makaleiwag babaw. Kukin tasiyas sivines, mo beitams waseg agulivan towen; peinan mounid. ");
INSERT INTO myw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Nagein tasiwun deil yey, o tasiyas bo iyateleigs peinan animis Yowbad bivag ma̱wan anilivan wasigeis tamumwey min-Yudiy yakamey. ");
INSERT INTO myw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","“O yakamey, amakum sinawatan akweiy, meiveka yakamey kasimkakin yam babaw o boug babaw kakanow aygan Yowbad, kadoki bisekem ma̱wan anilivan. O yey anmis sinap towen, igaw kanig waseg bitakits vayuwein, mapun min-Yudiy tasiyas bo iyateleigs. ");
INSERT INTO myw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","“O guyaw, aveiyag wawun isunasun ninoumiy livan towen, ‘Takanigs beikits vayuwein.’ ");
INSERT INTO myw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“O kweiboug ivag sivinag basilbwed nawotet gum-Nasalet mtowen Yeisuw. ");
INSERT INTO myw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","“Yelusalem waseg navvag ma̱wan. Tanuwgwes lun situwa̱veks nisekeigs gunakaleiwag va̱gan bayousis tayakelesiys basenas kid wa̱deil; o igawa niyya̱tals yey bo a̱tam va̱gan bakakatimates. ");
INSERT INTO myw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","“O sinagog babaw wasigeis bo amop asisinap tasiyas, adok kid mo bipiyaves siguyaw towen Yeisuw. Singay kapasal nuwag, aneves tayakelesiys va̱gan bamop asisinap kadiveiyov ven wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Misumkwey towen tanuwgwes lun situwa̱vek bo itams gunawotet towen waseg, ilansa, ‘Bweina bukun Damasik bukuyousis tayakelesiys tasiyas-one.’ ");
INSERT INTO myw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","“Igawa wa̱ked, ya̱nay waseg, bo akin kamnat singay avakaein meinoy neim walba̱lab. Ka̱las mititeilin kalamwey-nen, tage towen mititeilin singay avakaein; imteilim yakamey sigwey tasiyas nakaninoun. ");
INSERT INTO myw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","“Kakalouw wapwepway, kamasis, mo aligen teitan aga-Ibliw waseg idibakeig; ilana, ‘Soul, Soul, aveiyag wawun kuygageig? Tut babaw kwatipiyow kayal toneima ibasim avakaein.’ ");
INSERT INTO myw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","16","“Yey alana, ‘O guyaw, kavel yak?’ Ilana, ‘Yey Yeisuw, mtowen tuta babaw nukuyageg. Tut gog towen kutamanaw kutom. Bo amekeim, va̱gan kid basekeim muwotet. Kadiloka kwanow aygag, kusekes gamaga babaw liva̱neig yey peinan nukukineig nagein; o igaw tut wanakougwaw sinap mo bakamtel waseg ya̱koum, kadiloka bukusekes-vak liva̱neig ma̱wan. ");
INSERT INTO myw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","“‘Bakayabeim bukun tobwag ven gimgilis wasigeis. Igaw tasiyas beivag sivines biyagageims ya̱koum, sisiyas mugwamag min-Yudiy mwasinis; yey mo bakatinabweim ya̱koum. ");
INSERT INTO myw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","“‘O vena babaw gimgilis wasigeis, ya̱koum bukuvag beilal mites, va̱gan kid bipiyaves sinap dadub, kamnat biyousis; o bipiyaves Seitan nakaleiwag, mo binekes Yowbad, va̱gan kid biwid asisinap kalbaleb. E, tasiyas dadub mo binekes tasiyas tasimounids waseg yey, peinan akayuseimiy simiyas tasiyas, asekeimiy amisinap kweivaw, bwanabwein.’ ");
INSERT INTO myw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“O King ya̱koum, peinan Yeisuw meinoy neim walba̱lab nidibakeig ma̱wan, ta-ma̱wan bapiyev aygan. ");
INSERT INTO myw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","“Bo naguyes min-Damasik, wankuyeim min-Yelusalem, o vena babaw wawnuwan Yudiy, mo tobwag ven kadiveiyov wasigeis; adibakes, ‘Kadilok bikanavin ninoumiy, va̱gan kid bukunekes Yowbad. Awoum ninoumiy bikanavin makaw; kadilok sinap bwein kuwteles.’ ");
INSERT INTO myw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","“Peinan gunawotet towen nawtel, min-Yudiy mo iyousigs Yowbad wanbunatum, sivines kid beiweigs. ");
INSERT INTO myw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","“Yam babaw Yowbad nilabeig, nagein gog bo ma̱wan; ililabeig va̱gan kid baguyes gamaga babaw, takinew toul, o takinew guyaw; gamaga babaw wasigeis agulivan katanok-wan; ma̱wan tasiyas palopits sisiy Moses nilivnakes, ma̱wana yey agulivan; nag kid kweitan livan balivan; nag. ");
INSERT INTO myw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","“Ma̱wan tasiyas kweiboug, yey alana, ‘Kadilok a̱ban Kelis bigeg, bikanig, o kanig waseg mtowen biginikit, mo anilivan bwanabwein bimteilis nagamag min-Yudiy, wankuyeim vena babaw.’” ");
INSERT INTO myw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Igawa Pawl illivan ma̱wan, Pestos mo ilivan; aygan avakaein, ilana, “O Pawl, takabala̱wein ya̱koum; peinan buk babaw kuvnivin mo kukwabala̱wein.” ");
INSERT INTO myw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pawl ilana, “Nag akabala̱wein. Guntovek ya̱koum kukineig nanoug idumwal, agulivan mounid-wan. ");
INSERT INTO myw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","“King Agalip ikakina sinap towen, mapun nag ivag agumwasin, peinan nag itagouwaw sinap towen waseg; peinan bo ikamat wavtakon ven. ");
INSERT INTO myw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","O King ya̱koum, tabta kusimounid tasiyas palopit asilivan? Akakina kusimounid-wan.” ");
INSERT INTO myw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","King Agalip mo ilivan, ilana, “Kudokeig yey kakita bamlavag Kelis nagamag, ne?” ");
INSERT INTO myw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pawl ilana, “Igaw tut kadiveiyov o tut kayakus, yakamiy babaw bukumlavags Kelis nagamag yakamiy, bo bwein. Yowbad ikakin nanoug bo ma̱wan. Sivinag nagein bukumlavags ma̱wana yey, ya̱koum making ya̱koum, simwey gamag tasiyas babaw niliganes aygag. O nag sivinag bukusiws wa̱deil; sivinag bukumlavags Kelis nagamag yakamiy, ma̱wan yey.” ");
INSERT INTO myw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","31","King towen mo itamanaws siney Piliks o mana̱wen Belinis, sisiyas tasiyas nisinis bunatum towen, mo isaps. Sisiyas mo illivans, ilansa, “Taw towen nag ivag ansinap kalbaleb; nag kadilok bisesuna wa̱deil; nag kadilok min-Yudiy beiweiys, nag.” ");
INSERT INTO myw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agalip mo idibek Pestos; ilana, “Magat gamag towen nag sivinan Sisal bikaluweg; bweina bitakaluweg va̱gan bisap bein bininoun wamnat.” ");
INSERT INTO myw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ikaleiwags kid bikayabem, baka̱kuk, bakan Ita̱liy, isekes takalikay nawotet va̱gan bikaymates Pawl siney tasiwuns deil mwasanin. Takalikay towen yagan Yuliyas. Natakanaviys nisesus. Meivek-wan tasiyas Ogoustos inabod. ");
INSERT INTO myw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ka̱touw wag kaytan, meinoy neim Adilamiteim bein ven wunsiyas Esiy wakawalaw; simey ka̱kuk Alistak, gum-Masidoniy teitan, naven Tesalonik. ");
INSERT INTO myw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Neiyam nen mo ka̱lug Sidon. Peinan takalikay towen isiwa̱youb, itam waseg Pawl va̱gan kid binek taliven nisesus ven towen, bimasis, asbwabwal towen. ");
INSERT INTO myw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Neiyam nen mo ka̱kuk Sidon, kasawl. Peinan yag kalbaleb ka̱noy wangwanan sim towen Saypilos. ");
INSERT INTO myw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Wankuyeim ka̱kuk kadoupouy awasas avakaein walasin ven yagan Silisiy o Pampiliy, mo ka̱lug Mayl, wawnuwan ven avakaein Lisiy. ");
INSERT INTO myw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ven Mayl waseg matakalikay iban min-Aleksanidel siwag akitan, mo ka̱tow wag akiwen waseg, peinan kid bein Ita̱liy. ");
INSERT INTO myw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Singaya youviy to naka̱kuk; peinan yag meinoy neim wamitem; yam babaw ikous, mo ka̱lug Nidas. Igaw yag nitotow wamitem, mapuna kayawatein kan wangwanan sim yagan Kilit waseg, kan kadounip silbunun yagan Salamon. ");
INSERT INTO myw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Singay keikay to nakadavayal wadadan ven, nakan ee... mo ka̱lug wamunon, yagan Munon Bwanabwein, kadiyakusan ven yagan Lasey. ");
INSERT INTO myw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","10","Bo kalasibwen yam mwasanin nein wankuyeim, peinan yag igeg, o bo ikous yam towen min-Yudiy yakamey kapsapos, bo tutan yag avakaein bisilamaw; mapuna Pawl idibakes tasiyas; ilana, “Tawaw, bweina bitayeiwas munon towen waseg; kukin bitakuks, adok bukuyamkwanes kaydod o wag, o ya̱kids babaw adok bitamta̱mats.” ");
INSERT INTO myw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","12","Tage taginiwag son takavaveis ilansa, “Munon towen kalbaleb; bweina bitadokons; kukin bitalugs kweitan ven, bo bwein.” Takalikay iligen asilivan tasiyas, ipiyev Pawl anilivan. Tabebaws-wan sivines beikuks, bidokons kid bineis munon yagan Piniks, mo bakayeiwas munon towen waseg. Piniks wawnuwan sim to Kilit; munon towen wadon isekew wa̱yals, awasas-nen isekew wayavat. ");
INSERT INTO myw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yag yals mo iyagil, idokes bweina bakadavayal bakan Piniks, mo ikawes lon, ka̱kuk kadavayala ven Kilit wadadan. ");
INSERT INTO myw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Yag mo itet in wabomat, meinoy neim waven, singaya tawtoun, mamagina sinka̱wein! ");
INSERT INTO myw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ta-ma̱wan baka̱kuk peinan yag meinoy neim wamtem, singay avakaein, mo mweg kweitan kakit ka̱kuk mo isigogonem oko wabwanit. ");
INSERT INTO myw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kan wangwanan sim kakit yagan Kilod, mawotet singay keikay waseg kakatimwen kewow, in wakunuwatan wag, kayawen. ");
INSERT INTO myw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ikous, ikawes yiwayon, mo isays wag. Aspwa̱yat wag kid bitul wakunabub yagan Silitus, mapuna ka̱lug, mo iyalaves. ");
INSERT INTO myw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Neiyam nen igaw itotow yag, ilaves kaydod in wabwanit. ");
INSERT INTO myw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Neiyam nen mo ikawes wuliyoug-wan wag, ilaves in wabwanit. ");
INSERT INTO myw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Yam babaw libgagay ivag; nag kakin ka̱las, nag kakin wutun, yag singay avakaein itotow. Kadoki bo bakamta̱mat. ");
INSERT INTO myw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Yam babaw waseg, nag kakamkwam kan. Kweitan yam Pawl mo itamanaw wamitem; ilana, “Tawaw, kadiloka bukuliganes aygag kweiboug; bitayeiwas ven Kilit bo bwein; tut towen bo tayagages, bo tayamkwanes youda babaw. ");
INSERT INTO myw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","“Tage tut towen awoum beivag amipwa̱yat, peinan nag bitamta̱mats; nag. Misinaka bitayamkwanes wag. ");
INSERT INTO myw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","24","“Yey atapwa̱loul Yowbad waseg. Boug waseg gunaYowbad nataka̱yob imekeig, ilana, ‘O Pawl, awoum beivag ampwa̱yat; bo bukunek Sisal. O peinan kwanow Yowbad aygan, bo itam simwey tasiyas tababaws-wan, bo bikatinabweimiy.’ ");
INSERT INTO myw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","26","“Kadilok beibwein amnamiy, peinan animis Yowbad; bo bikamat ma̱wana nilivnek. Dawag gog bo bibilag wa̱sim.” ");
INSERT INTO myw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Akweiy wik iyalavem wabwanit towen yagan Ediliy. Watapwan boug tasiyas wunataw mo idokes ven kid kadiyakusa nises. ");
INSERT INTO myw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mo bitakwanes bwanit ama̱wan vayovan; mo ivinis ova̱vin. Ova̱nim, ova̱nim, ova̱nim, ova̱nim; e, mo imlavag sinawey. Wankuyeim vayuwein mo itakwanes, mo imlavag sinawatan ova̱nim vayovan bwanit towen. ");
INSERT INTO myw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Aspwa̱yat bakan wadakul, mata ge igulek wag, mo ilaves lon walivas wawawun wag; sivines kid ga-iyam. ");
INSERT INTO myw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wunataw inibwis kewow, ilansa, “Lon mwasanin bakanow wadabwen wag bakalev;” iyaweids gog, sivines kid bikala̱vis, bisawls kid bilisawemas. ");
INSERT INTO myw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pawl mo idibek takalikay sen natakanaviys; ilana, “Kukin tasiyas bilisaweids, bo bitamta̱mats babaw ya̱kids. Kukin bisesus, bo bwein.” ");
INSERT INTO myw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Mapuna takanaviys tasiyas mo ibwabwes vatulen kewow, ikalouw in wa̱yol, iyetuwen. ");
INSERT INTO myw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","34","Wankuyeim kakita beiyam. Pawl mo iguyem va̱gan baka̱kam; ilana, “Yam sinawatan kweivas nukusesus, ikubukub nuwamiy, nag kukwams. Kadiloka kukwams va̱gan gog biyamoveimiy; nag aveiyag bivag, nag; bwein-wan bitasesus.” ");
INSERT INTO myw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ilivan ikous, mo ikow bled, ikalin nuwan Yowbad waseg, initoug wamtem meiveka gamag yakamey, bled ikiv, mo isilamaw ikam. ");
INSERT INTO myw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Amnem mo ibwein babaw yakamey, mo ka̱kam. ");
INSERT INTO myw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Meiveka yakamey wag makaywen adagan, lakatuy sinawanim sinawey teinim tatanok gamag. ");
INSERT INTO myw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ka̱kam, kakamuweip, mo kalev kan, in wa̱yol va̱gan kid wag bikayay. ");
INSERT INTO myw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Iyam nen ga̱boug, nag teitan gamag iwtus ven towen, tage kaban awasas kakit alekel kakit nises; tasiyas wunataws idokes biyokons kid beikuks va̱gan wag bein wanuwan, mo bibilag wag. ");
INSERT INTO myw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mapuna ibwabwes yiwayon, lon kalisow wa̱yol; kweiboug niyawanis avaveis naman va̱gan awoum bigogewn kid, tut towen mo ilikus vitulen avaveis va̱gan bigogewn; kanagon mo isenas, mo ka̱kuk silma̱nin kawalaw towen. ");
INSERT INTO myw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ka̱kuk ee... wag mo itul kunabub waseg, dabwen ibilag, kaysay iwaway wag wawawun, mo ikatagulek. ");
INSERT INTO myw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Takanaviys idokes bweina bikatimates tasiyas tasiwuns deil, mata igegays ge iga̱lags mo bisawls. ");
INSERT INTO myw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","44","Tage takalikay towen sivinan biyamov Pawl, mapuna isilbwed asisinap; ilana, “Tasiyas kalisiy ikakins gegay kadiloka bikaspepel bineis wa̱yol bigegays bimgwayemas bineis wanakaew. Yakamey wankuyeim kaypap waseg mo baka̱gay bakan wanakaew.” E, ma̱wan sona mwamovem meiveka yakamey kan wanakaew mo kasap waven. ");
INSERT INTO myw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kaga̱lag kan wanakaew; ven towen gimgilis imeis mo ikavtagis siven yagan Melit. ");
INSERT INTO myw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tasiyas nag isina̱lemas, nag; bo isiwyoubumas. Amaloulun, peinan kweis, mapuna ilabemas, ikavlakes imakov, kakamunuw. ");
INSERT INTO myw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pawl in ikow amweilok sinivtanok, isen wa̱kov, mwatet gog nises amweilok towen wanuwan; muymuyan kov isimkwen, isap, iged naman Pawl. ");
INSERT INTO myw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ven towen gimgilis ikines mwatet towen ikakuva̱tay wanaman Pawl, mo ilansa, “Mounid tawayin gamag taw towen; nag kadilok son mwamovan bises; nag iwgwel wabwanit, tage mwateta na̱wen mo iged, va̱gan kid bikatimet.” ");
INSERT INTO myw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pawl ikatsap mwatet wanaman, mo ikalivatow, in wa̱kov; nag ikatoun, bwein-wan ises. ");
INSERT INTO myw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Idokes kid naman beilol, o bikalouw wapwepway beimat kid; ikayamats ee... nag aveiyag ivag; mo ikanavin ninous, idokes kid yowbad teitan. ");
INSERT INTO myw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Sim towen gimgilis siguyaw avakaein Pubiliy, napwepway nises ven towen waseg; anbwabwal yakamey kasesuna ee... kweitoun yam, singaya ge isiwyoubum, guyaw towen. ");
INSERT INTO myw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Misumkwey towen Pubiliy taman nises wabunatum, ikatoun, itaka̱lon won, mwaliyes isawel. Pawl isiw wanbunatum, initoug Yowbad waseg, isen naman wa̱won, mo ibwein. ");
INSERT INTO myw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wankuyeim takatounsa babaw sim towen gimgilis nimeis, Pawl initoug pines, mo ibweins. ");
INSERT INTO myw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Mapuna isiwyoubumas bwanabwein, o igaw tutan bo baka̱kuk mo itanouys wuliyoug makaw isekemas. ");
INSERT INTO myw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tibukon kweitoun ikous, mo ka̱touw wag akitan nikayamat wa̱sim towen bulbweilim waseg. Min-Aleksanidel siwag makaywen antabuy mamagina tawaw papap asteiy. ");
INSERT INTO myw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ka̱lug Sulakous kases kweitoun yam. ");
INSERT INTO myw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ka̱kuk mo kayeyewousa kayeyewous ee... mo ka̱lug Legiyam, kamasis. Iyam nen ga̱boug, yag in yals mo ka̱kuk silma̱nin Putiyol, akweiy yam mo ka̱lug. ");
INSERT INTO myw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ven Putiyol waseg kaban Yeisuw nagamag mwasanin, ilivans, “Kadiloka kumeis wamabunatum, amabwabwal yakamiy.” Ka̱tam, kases katanok wik. Wankuyeim mo kanoun wa̱ked silma̱nin Lom. ");
INSERT INTO myw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yeisuw nagamag, tayakelesiys mwasanin nisesus Lom; bo iliganes livnem yakamey bo bakan Lom, mo imeis wa̱ked silma̱nin bakalouvat; e, imekemas ven yagan Apiyos Ma̱ket, o kweitan ven Buntuman Masis Bunatoun. Pawl ikines budan tasiyas mo ikalin nuwan Yowbad waseg, ibwein amnan. ");
INSERT INTO myw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kasap Lom, gabman mo itam Pawl nabunatum tatonen va̱gan kid bisikes son takanaviy teitan bikayyamat. ");
INSERT INTO myw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yam kweitoun nein wankuyeim mo idawes min-Yudiy situwa̱veks bimeis. Ikatuyouns imeis, mo idibakes, ilana, “Tuwag yakamiy; yey makava a̱siw wa̱deil. Nag aveiyag avag sidayas wasigeis, o nag apiyev datammwayas asisinap, nag. Tage bo iyousigs Yelusalem waseg mo ita̱meigs mina-Lom takaleiwags wasigeis. ");
INSERT INTO myw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","19","“Bo iyateleigs, nag go iba̱nes agusinap kalbaleb, nag. Tasiyas mina-Lom takaleiwags idokes bweina basap wamnat banoun; tage min-Yudiy ilansa, ‘Awoum. Kuweiys taw towen, peinan takalbaleb.’ Mapuna alivan, alana, ‘Sivinag Sisal bikaleiwag.’ Nag sivinag bayateles min-Yudiy wamatan Sisal; nag. Gunaked kaditanok-wan, ked towen waseg ma̱noy. ");
INSERT INTO myw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","O silawun gunya̱tal towen sivinag bitalivans sigwey yakamiy, mapun to nadaweimiy bukumeis waseg yey. Kukines agusen wanamag niyawanis, o min-Yisleil ya̱kids tanmises Yowbad igaw mo bikatinabweids, o inawotet towen silma̱nin yey na̱siw wa̱deil.” ");
INSERT INTO myw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Tasiyas ikatimapus aygan, ilansa, “Min-Yelusalem nag ileles malet va̱gan bikatimlakemas liva̱neim yak, o min-Yudiy meinoy nimeis palawen, liva̱neim kalbaleb nag isekemas, liwon waseg o asilivan waseg, nag. ");
INSERT INTO myw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","“Sivinem bakaligen nanoum ya̱koum, peinan kakakin ven babaw gimgilis ivtokays livan sinap towen waseg, Yeisuw nagamag amisinap.” ");
INSERT INTO myw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ikaleiwags kweitan yam igaw mo bimeis biliganes Pawl anilivan. Yam towen nimeis wanbunatum, singaya babaw gamag. Ga̱boug isilamaw anilivan, ee... in kwayav mo iyakous. Yowbad nakaleiwag liva̱nen nisekes. Moses nakaleiwag ivin, o tasiyas palopits sikaleiwag ivin, ikatimlakes wawun asilivan, va̱gan kid bisimounids Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mwasanin gamag mo iliganes anilivan Pawl, isimounids; mwasanin nag, ipiyaves. ");
INSERT INTO myw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ta-ma̱wan ninous bilatanes bimlavags katanok-wan, mo inounas. Nakabiyokous Pawl anilivan ma̱wana, “Mounid anilivan Yowbad Kululuwan tamumwey wasigeis. Palopit towen Isaya nikatipel nisekes anilivan towen-an. ");
INSERT INTO myw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Ilana, ‘Kunekes gamag tasiyas, kudibakes ma̱wana: Bukuliganes, tage nag bukukwakins. Bukukines, tage nag bukuwtusis. ");
INSERT INTO myw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Peinan gamag tasiyas ninous bo imouvit, bo ituy tiges; bo ikaw mites; mata ge mites waseg beikins, o tiges waseg beinegs, bikakins mo bikanavin ninous, bava̱ges kid beibweins tasiyas. Nag gog.’ ");
INSERT INTO myw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Kadiloka bukukwakins Yowbad anilivan bo nisekem yakamey, ikayabem, bakan tobwag ven gimgilis bakasekes; tasiyas bo biliganes; e, Yowbad mo bisiwyoubus tasiyas, bikatinabwes.” ");
INSERT INTO myw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(-) ");
INSERT INTO myw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","31","Akweiy bweilim Pawl misik wanbunatum tatonen, peinan bo iyamiyis bunatum towen; nikaypuls siney tabebaws tasiyas ininekes, bo iguyes Yowbad nakaleiwag waseg, o ikatimlakes sinapun daGuyaws Yeisuw Kelis. Bwein-wan illivan, peinan nag teitan gamag isilbwed anilivan. ");
INSERT INTO myw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yey Pawl, Yeisuw Kelis natouwat yey; Yowbad bo ikaluweg gunawotet, silma̱nin bakokew liva̱nen Yowbad; livan towen bwanabwein. ");
INSERT INTO myw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Livan towen bo ilivnek isekes inapalopit wasigeis, mo ileles Bukitab waseg. ");
INSERT INTO myw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Livan towen liva̱nen Yowbad Natun, Deibid delen ven watinow waseg. ");
INSERT INTO myw_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","7","Tage takakins mtowen Yowbad Natun tatonen. Natawtoun nises, peinan Kululuwan Yowbad nises waseg. Kanig waseg ikit vayuwein, mo takakins Yowbad Natun, mtowen daGuyaws Yeisuw Kelis. Mtowen bo isiwyoubum, isekem mawotet mo kakokew liva̱nen, ven babaw iliganes mo isimounids yagan Kelis waseg. Yakamiy-vak, ven babaw gimgilis Yowbad bo idaweimiy va̱gan bukumlavags Yeisuw Kelis angamag yakamiy. Mtowen Yeisuw Kelis bo idaweimiy mina-Lom yakamiy, kalisiy Yowbad nikalin nuwan wasigeis yakamiy; mamagina bo ikayuseimiy angamag yakamiy. Mtowen daGuyaws Yeisuw Kelis son Tamads Yowbad bisiwyoubumiy mo beitaw nuwamiy. ");
INSERT INTO myw_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kalin nuwag waseg Yowbad, peinan tababaws yakamiy kusimounids bwein waseg Yeisuw Kelis; butumiy bo nein ven babaw wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","10","Yowbad ikakin agulivan mounid, bo iseiw nuwag Natun bulagan akokew. E, mounid aninuweimiy tut babaw, aninitoug pinamiy, kukin nanon Yowbad ma̱wan mo bitam gunaked bwein bawekeimiy. E, gunakanitoug ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Sivinag gog bakineimiy bakatimweis kululuwamiy, Yowbad nasiwa̱youb waseg, va̱gan bukutawtouns. ");
INSERT INTO myw_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mamagina bitalabeids meiveka ya̱kids, yakamiy o yey, peinan tasimounids Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Sigwey, awoum kutagouwa̱weigs peinan tut babaw ivag sivinag baw; ayyokon gog, bo nag, peinan gunaked nag. Sivinag baguyeimiy mo bukusimounids mwasanin yakamiy, ma̱wan vena babaw aguyes mo isimounids. ");
INSERT INTO myw_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kadiloka baguyes gamaga babaw, takinew mina-Gilis, o takinew min-koyakoy gimgilis; takinew tassinaps, o takinew tabla̱bols; bagguyes asibabaw-wan. ");
INSERT INTO myw_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Yakamiy-vak mina-Lom yakamiy, bo iseiw nuwag basekeimiy livan towen bwanabwein. ");
INSERT INTO myw_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Akakin-wan liva̱nen Yeisuw Kelis singay tawtoun. Livan towen waseg, Yowbad bikatinabwes gamag, kalisiy tasiyas bisimounids waseg, wanmugwana min-Yudiy yakamey, wankuyeim mo vena babaw gimgilis yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Livan towen waseg ikamat Yowbad ansinap didumwal, Yowbad itoukum pines tasiyas isimounids waseg, peinan Bukitab liva̱nen nises mamagina: “Kal yak tadidumwal yak, peinan kusimounid Yowbad waseg, mo bukuban mumwamov.” Misinaka tasimounid; nag kweitan ked nises. ");
INSERT INTO myw_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Gamag mwasanin asisinap kalbaleb, issilbwades sinap mounid. Takakins gog liba̱lab tanuwagan bikamta̱nis peinan ansinap bo ipiyaves; asisinap gog tasiyas kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sinapun Yowbad bo ikamnat wasigeis tasiyas, peinan bo ikatimlakes. ");
INSERT INTO myw_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Takines bwein nakabwabub Yowbad, nibun natawton tonen waseg, e, natawtoun bo isigeg-wan; mapuna nanouds waseg takakins Yowbad; matads nag bikin, misinaka nanouds. Kweiboug ibun ven, gamag ikines, tut babaw ma̱wan ee... nagein mo takines ya̱kids. Tasiyas ikines inakabwabub, kadiloka bikakins tabunin Yowbad, nag gog itagouwa̱wes. ");
INSERT INTO myw_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kweiboug ikakins Yowbad tage nag iya̱kawns waseg, nag ikalin nuwes, nag. Tage ininuways sinap tobwag waseg, mo ninous ibol, mamagina bo idadubs tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","24","Idokes tassinaps tasiyas, tage bo ikabala̱weins, ibubunis siyowbad, magin ma̱wana gamag o mansiyas man iyoyows o mansiyas inounas waven o itatets wapwepway, atimapun Yowbad ibunis. Tage Yowbad towen ises isigeg, yakawanan avakaein, ipiyaves, ilisawes; o aw-sinap kalbaleb wous sivinan biva̱ges, sisiyas wasigeis mo iva̱ges, iyagages wous sisiyas. ");
INSERT INTO myw_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","E, asisinap ma̱wan, peinan sinapun Yowbad bo ipiyaves, bo iyyaweids tasiyas, ikululs wamatan youd towen nibunis, ikanawes aygan, bo ipiyaves Yowbad tatonen. Yowbad bo ibun youd babaw. Kadilokena bitakavasis Yowbad tut babaw. Eimen. ");
INSERT INTO myw_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Mapuna Yowbad bo ipiyaves, ilisawes igaw biva̱ges kalbaleb, ma̱wan asivikey biva̱ges ma̱wan. Vinay bo ipiyaves kanavay sisiyas tawaw; tatineisa ikanavays sisiyas wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Tawaw ma̱wan bo ipiyaves kanavay wasigeis sikwavas, tage singay sivines bikanavays wasigeis tawaw, mo iyagagays sisiyas wasigeis. Kalbaleb towen mapun tatineis mo iba̱nes, wawous. ");
INSERT INTO myw_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Peinan nag ivag sivines, mo ipiyaves-vak Yowbad. Mapun Yowbad bo ipiyaves tasiyas, va̱gan bininuways kalbaleb mo sinap tobwag biva̱ges. ");
INSERT INTO myw_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","31","Mo ika̱lawt ninous sinap kalbaleb waseg, asisinap kaydodog, mwamon mites, takapidabs tasiyas, singay ikammeiliws, o iwaweiys sisiyas, ikammnimans, ikatidavidavs, ivtokays livan, isilponays o isilakods, ikamliwes Yowbad; bo bipiyaves aygan mo ikaypamwes asisinap, inineivs kid asisinap kalbaleb, ipiyaves ages timsiyas o insiyas; nag ikakins sinap bwein, nag isimounids, nag ikalin nuwes gamag wasigeis; nag inok nuwes, nag. ");
INSERT INTO myw_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bo ikakins Yowbad nakaleiwag kadiloka bimta̱mats tasiyas asisinap ma̱wan, igawa ivvaluts sinap towen waseg, mo ikavasis sisiyas kalisiy asisinap ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kal yak kwasigum soum, magina kwasigumim tatoneim, peinan amsinap kalbaleb ma̱wana towen. Ta-ma̱wan bukwatimop aygan takaleiwag towen bikamta̱nim. ");
INSERT INTO myw_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Taninuways Yowbad ansinap, bweina bikamta̱nis takalbalebs, siyas nalel asisinap. ");
INSERT INTO myw_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Awoum wananoum bukulana, “Bweina bakasigum takalbaleb mo bawtel ma̱wan ansinap towen, Yowbad igaw bikamtan towen, yey gog nag.” Awoum kulivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","5","Awoum kudokes tougwey Yowbad, peinan singay iyama̱num waseg yak, ikapatul, ikalin nuwan yak. Iyama̱num waseg yak va̱gan kid bukulavew amsinap kalbaleb. Nag gog, singay takakon yak, mapun singay Yowbad bikatimop amsinap kalbaleb, igaw tutan bikatkines gamag asisinap, inakaleiwag didumwal waseg. ");
INSERT INTO myw_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","8","Yowbad bimapuds tatanok tatanok ya̱kids ma̱wan dawotets. Kukin bitawotet bwein o bitakapatul va̱gan bitakamnat o Yowbad bikavasid o mwamovad bisigeg, e, Yowbad mo bisekeid mwamovad nag beikous. Tage kukin bitanineiv daked tatoneid, o bitapiyev Yowbad ansinap mounid, o bitakanaway sinap kalbaleb, e, mo singay Yowbad bikamta̱nid. ");
INSERT INTO myw_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kalisiy gamag takalbalebs simouvit mo bilivatus, abes singay bigeg, wanmugwana min-Yudiy, wankuyeim ven babaw gimgilis. ");
INSERT INTO myw_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Tage toubweins bilivatus sikamnat son yakawanes mo beitaw nuwes, wanmugwana min-Yudiy, wankuyeim ven babaw gimgilis. ");
INSERT INTO myw_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Yowbad nakaleiwag ven babaw wasigeis katanoka ivkek. ");
INSERT INTO myw_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Min-Yudiy ikakins Yowbad nakaleiwag; kukin beivag asisinap kalbaleb mo bimta̱mats, peinan bo isiplaves Yowbad nakaleiwag. Ven mwasanin gimgilis nag ikakins Yowbad nakaleiwag, bivag asisinap kalbaleb mo bimta̱mats-vak tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Tasiyas Moses nakaleiwag iliganesa mav, nag mamagina tadidumwals tasiyas, nag. Misinaka takanaweins Moses nakaleiwag, Yowbad mo bidok tadidumwals tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Tobwag ven gimgilis kalisiy nag ikakins Moses nakaleiwag, tage tatineis-wan biwteles bo ma̱wana Moses nakaleiwag, mo ivag sikaleiwag ibwein wasigeis tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","16","E, bitakin kaleiwag bwein waninous, o ninous tatineis ikatimlakes mo ikakins takinew asisinap kalbaleb, o adok bwanabwein. E, ninous bikatimlakes, igaw tutan Yowbad bikatukin nanouds aveiyag nitasowum nises. E, Yowbad bidibek Yeisuw Kelis mo bikatukin, bikaleiwag, ma̱wana allivan, aggeiguy liva̱nen Yowbad bwanabwein. ");
INSERT INTO myw_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","20","Kal takatimlakay yak bukudokeim kid gum-Yudiy ya̱koum, o kudoki Moses nakaleiwag bikatinabweim, o taga̱gas yak peinan Yowbad nagamag yak, o nanon Yowbad kukwakin o Moses nakaleiwag kukwakin ikous, mapuna kukwaves aw-sinap bwanabwein, o kukwakin tamgwayein kaw yak, o tadadubs sikamnat yak, o takatimlakein sinap tabla̱bols wasigeis o gamagal wasigeis, peinan Moses nakaleiwag waseg kudoki sinap mounid nises. ");
INSERT INTO myw_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yak kukwatimlakes gamag mwasanin, adok nag bukwatimlakeim tatoneim. Kuguyes gamag awoum biba̱kews, adok bo kuba̱kew, ne? ");
INSERT INTO myw_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kulana, “Awoum kwaninavay mav,” adok bo kwanavay mav, ne? Kwasigum tobwag yowbad, adok bo kuba̱kew waseg tobwag yowbad nabunatum, ne? ");
INSERT INTO myw_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kukwayapam sinap peinan kukwakin kid Moses nakaleiwag, adok bo kusiplev nakaleiwag, magina kuyageg Yowbad ne? ");
INSERT INTO myw_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Bukitab waseg livneimiy min-Yudiy yakamiy, mamagina: “Ven mwasanin gimgilis bo iyages Yowbad yagan, peinan amisinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ebelam nakabivatus kubwabwes momwamiy. Sinap towen bwein magat bukwanawes Moses nakaleiwag. Kukin gog bukusiplaves Moses nakaleiwag, nag bivag mikabivatus, bo biyadeveimiy. ");
INSERT INTO myw_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ma̱wan magin, kukin kal nag ivag Ebelam nakabivatus mo ikanow Moses nakaleiwag, tadok nakabivatus Ebelam waseg gamag towen, ne? ");
INSERT INTO myw_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Gamag tasiyas nag Ebelam nakabivatus wawous tage ikanawes Moses nakaleiwag, mo biyateleimiy peinan nakabivatus wawoumiy o Moses nakaleiwag buk-nen nises wasigeis yakamiy, o kusiplaves gog. ");
INSERT INTO myw_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kavel bibob momwan ma̱wana gum-Yudiy tage nag gum-Yudiy tatonen. Ebelam nakabivatus wakaleivim-wan nag ikadilok, nag. ");
INSERT INTO myw_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Tage gum-Yudiy wanuwan mounid gum-Yudiy tatonen; o Ebelam nakabivatus kadiloka beisiw waka̱teid o wakululuwad, kaleivid awoum. Yakawanads Yowbad waseg, nag gamag wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Adok Yowbad singay bilabeids peinan min-Yudiy ya̱kids, ne? Ikalin nuwan peinan Ebelam nakabivatus wa̱wouds, ne? ");
INSERT INTO myw_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Magen, bo ilabeids youd babaw waseg. Nakabsilamaw waseg, Yowbad nilivnek anilivan min-Yudiy wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Min-Yudiy mwasanin mo isiplaves aygan Yowbad, tage Yowbad nag ibob ansinap didumwal wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Nag. Magat babaw gamag bitakapidabs, Yowbad mo bisesuna tadidumwal tonen. Liva̱nen Yowbad nises mamagina: “Amlivan bakanuw mo bakaban amsinap didumwal, o igaw ya̱tal waseg bukutawtoun mo bukutamap yak.” ");
INSERT INTO myw_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","6","E, taninuways adsinaps kalbaleb mo takakins Yowbad ansinap didumwal, wankuyeim tabta bitalivans, talansa, “Yowbad takalbaleb, peinan ikawkuneids”? Awoum bitalivans ma̱wan. Livan kalbaleb. Gamag mwasanin asisinap ma̱wan. Kukin Yowbad ansinap bigeg, ta-ma̱wan bikatukin wasigeis gamag yakids. ");
INSERT INTO myw_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","8","Tayyaweids mwasanin ilansa, “Pawl inageiguy mamagina, ‘Bayaweid singay mo bitakakins Yowbad ansinap mounid, mapuna bitakavasis. Adok awoum biyateleig peinan agusinap kalbaleb. Kadiloka beivag adsinap kalbaleb va̱gan kid Yowbad ansinap bwanabwein mo bisap.’” Tayyaweids mwasanin idokes gungeiguy ma̱wan. Kadilok Yowbad bikamta̱nis peinan asilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ama̱wan? Tabta min-Yudiy ya̱kids bitamugwas? Nag. Agulivan mamagina adsinaps kalbaleb, babaw ya̱kids, takinew min-Yudiy, o takinew ven babaw gimgilis tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Liva̱nen nises mamagina: “Nag kal ansinap didumwal. ");
INSERT INTO myw_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nag teitan ikakin; nag teitan inineiv Yowbad. ");
INSERT INTO myw_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Asibabaw bo ipiyaves inaked, ininounas ked kalbaleb waseg; Nag anmwa̱net gamag ansinap bwanabwein, nag. ");
INSERT INTO myw_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Asilivan kalbaleb, wudous ma̱wana alawag, Wudous waseg ikatidavidavs. Mwatet napwa̱tuw yayanen wawudous nises. ");
INSERT INTO myw_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Wudous bo ika̱lawt bwa̱lat son sinap yayan. ");
INSERT INTO myw_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Bo iseiw nuwes anwaway gamag. ");
INSERT INTO myw_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ininounas, igugweileks youd babaw. ");
INSERT INTO myw_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Niwal inaked nag ikakins. ");
INSERT INTO myw_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nag bikakins Yowbad; nag bigoulus, nag.” ");
INSERT INTO myw_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Bukitab anilivan towen silma̱nin tasiyas wanuwan Moses nakaleiwag, va̱gan Yowbad bibob adilivans, o ven babaw ya̱kids mo bitakakins adsinaps kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nag kadilokeid bitakanow Moses nakaleiwag va̱gan bitasesuna wamatan Yowbad tadidumwal ya̱kid, nag. Kaleiwag towen bikatimlakeid mo takakin adsinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Tut towen takakins didumwa̱lun Yowbad inaked kweitan. Moses nakaleiwag nag ma̱wana ked towen, nag; tage liva̱nen ked towen nises Moses nakaleiwag waseg, o tasiyas palopit sikalelel waseg. ");
INSERT INTO myw_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ked towen, bitasimounid waseg Yeisuw Kelis, mo Yowbad bisekeid didumwal tonen. Gamag babaw ya̱kids idakeds katanok-wan. ");
INSERT INTO myw_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Babaw ya̱kids adsinaps kalbaleb; Yowbad nakamnat bo ilisaweids. ");
INSERT INTO myw_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nasiwa̱youb mo ikatinabweids Yeisuw Kelis waseg, mo tamlavags tadidumwals ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Yowbad bo itam Yeisuw mamagina lun bulukwan buya̱vin biwid adsinaps kalbaleb, magat bitasimounids waseg. Lun towen waseg, Yowbad ikamtilakeids ansinap didumwal, peinan bo ikaltuwen adsinap kweiboug kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Bo ikapatul wasigeis ya̱kids mo takakins ansinap didumwal, tut towen ikidumwa̱luds ansinap didumwal waseg, peinan tasimounids waseg Yeisuw. ");
INSERT INTO myw_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tabta bitakaypamwes adsinaps waseg? Adok nag. Aveiyag wawun? Adsinaps waseg nag bitamlavags tadidumwals; misinaka bitasimounids waseg Yeisuw mo bitamlavags tadidumwals ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Mapuna takakins misinaka bitasimounids waseg Yeisuw mo bitamlavags tadidumwals; sinapun Moses nakaleiwag waseg nag aveiyag bitaba̱nes. ");
INSERT INTO myw_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Tabta Yowbad misinaka min-Yudiy daYowbads? o adok vena babaw siYowbad? Mounid vena babaw siYowbad. ");
INSERT INTO myw_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Magen, Yowbad anmwa̱net, mapuna bikidumwa̱luds min-Yudiy ya̱kids peinan tasimounids Yeisuw waseg, o bikidumwa̱lus vena babaw gimgilis peinan isimounids Yeisuw waseg. ");
INSERT INTO myw_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Tabta bitasimounid waseg Yeisuw mo bitagulekwes Moses nakaleiwag? Nag. Bitakatimweisis mo bitawtoun. ");
INSERT INTO myw_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Bitaninuways tabuds ven watinow, yagan Ebelam. Ama̱wan bitalivans? ");
INSERT INTO myw_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kukin Ebelam ansinap didumwal peinan nawotet bwein, kadiloka bikaypom ansinap; tage nag kadilok bikayapam wamatan Yowbad, nag. ");
INSERT INTO myw_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Aveiyag Bukitab nilivan? Ilana: “Ebelam isimounid Yowbad waseg, mapuna idoki tadidumwal.” ");
INSERT INTO myw_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kukin bitawotet, maysad nag mamagina siwa̱youb, nag; maysan dawotet. ");
INSERT INTO myw_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kukin nag bitawotet, misinaka tasimounid waseg towen takidumwa̱lun dakalbaleb ya̱kid, mo bidokeid tadidumwal ya̱kid. ");
INSERT INTO myw_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ma̱wan-vak Deibid anilivan bwanabwein wasigeis gamag kalisiy nag iwotets va̱gan Yowbad bikidumwa̱lus, ilana: ");
INSERT INTO myw_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","8","“Bweina kumwa̱saws yakamiy peinan bo inumlev amisinap kalbaleb, bo iwid. Kumwa̱saws peinan daGuyaws nag binuway amisinap kalbaleb.” ");
INSERT INTO myw_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Tabta ilivan ma̱wan misinaka min-Yudiy bimwa̱saws peinan Yowbad biwid asisinap kalbaleb, o adok vena babaw gimgilis. E, taninuways. “Ebelam isimounid Yowbad waseg mo idoki tadidumwal.” ");
INSERT INTO myw_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Avei-tut waseg mo nidoki tadidumwal? Misumkwey nivag nakabivatus? Nag. Idoki tadidumwal, bweilim mwasanin ikous mo Yowbad isek nakabivatus. ");
INSERT INTO myw_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","12","Kweiboug nag ivag nakabivatus, tage isimounid Yowbad waseg, mo idok tadidumwal; wankuyeim mo isek nakabivatus, mamagina naman mulin towen, peinan bo idok tadidumwal. Takinew bitakow Ebelam nakabivatus, o takinew nag bitakow, deisa tasimounid waseg Yeisuw, mo Yowbad bidokeids tadidumwals o bitamlavags Ebelam tibun ya̱kids, takinew tobwag ven gimgilis yakamiy, o takinew min-Yudiy yakamey. Yakamey Ebelam nakabivatus wawom nises. Magat bakasimounid mo bakamlavag Ebelam tibun mounid. Kukin gog nag, bo nag. Peinan kweiboug Ebelam nag ivag nakabivatus, isimounid mo Yowbad idoki tadidumwal towen. ");
INSERT INTO myw_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Yowbad bo ilivnek Ebelam siney tibun igaw bikawes ven babaw watinow, sikiyay tasiyas. Nag iba̱nes sikiyay towen peinan ikanawes Moses nakaleiwag, nag. Deisa isimounids waseg Yowbad, to nidoki tadidumwals tasiyas, mo iba̱nes sikiyay towen. ");
INSERT INTO myw_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ama̱wan bitaban dakiyays? Bitakanow Moses nakaleiwag, o adok bitasimounid Yowbad anilivan to nilivnek? Adok bitasimounid-wan. Tasiyas idokes bikanawes Moses nakaleiwag mo biba̱nes, nag gog; tasiyas bo ibwabwes simounid waseg Yowbad anilivan to nilivnek. ");
INSERT INTO myw_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Moses nakaleiwag nitasiplev mapuna Yowbad bikawkuneid. Magat kaleiwag nag, nag beivag adsinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","17","Tasimounids mo bitaba̱nes youd towen bwanabwein. Yowbad bo ilivnek youd towen bisekeids peinan nasiwa̱youb avakaein wasigeis ya̱kids. Ebelam delen mounid bikawes. Tasiyas takanaweins Moses nakaleiwag mwasanin sisiyas ya̱kids, peinan tasimounids ma̱wana Ebelam nisimounid waseg Yowbad; mamagina Ebelam tabuds babaw ya̱kids. Liva̱nen Ebelam nises mamagina, “Bo akatigikeim ven babaw tibus ya̱koum.” Youd towen Yowbad nilivnek bo bisek Ebelam delen, peinan bo isimounid wamatan Yowbad, taykitun takanigs; mtowen bidibek aveiyag makaw, bilana, “Kusap,” mo bisap. ");
INSERT INTO myw_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Innamis va̱gan biban natun. Innamis-wan ee... bo itovek, igaw-wan innamis, peinan isimounid mo bimlavag tibus ven babaw, peinan Yowbad anilivan mamagina: “Deleim igaw mo bibabaw.” ");
INSERT INTO myw_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ininuway ee... ikakin wa̱won, ilana, “Bo atovek; kakita bakanig. Agbweilim bo imlavag lakatutan.” E, inuway nakwav Sela peinan vinakal; tage nag igwey, isimounid-wan waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nag ipiyev simounid, peinan iysiyous Yowbad anilivan waseg; tage iya̱kawn waseg Yowbad mo nasimounid itawtoun. ");
INSERT INTO myw_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Singay isimounid, ikakina Yowbad ikadilok biwtel ma̱wana nilivnek. ");
INSERT INTO myw_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Isimounid waseg Yowbad mapuna mo idok tadidumwal towen. ");
INSERT INTO myw_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","Livan towen “Idok tadidumwal towen” nag ilel peinan Ebelam anmwa̱net tadidumwal. Ya̱kids-vak peinads. Igaw bitasimounid waseg Yowbad to nivag daGuyaws Yeisuw ikit kanig waseg, mo bidokeid tadidumwal ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Bo iweiys Yeisuw adsinaps kalbaleb peinan, ivag mo ikit va̱gan kid mo bikidumwa̱lud. ");
INSERT INTO myw_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","2","Tasimounids waseg Yeisuw, mapuna Yowbad bo ikidumwa̱luds. Kadiloka bitamsamwas waseg Yowbad, peinan daGuyaws Yeisuw Kelis bo nilabeids mo taba̱nes Yowbad nasiwa̱youb, waseg tasinis bwein. E, bitamwa̱saws, peinan bo bitasiws Yowbad wanakamnat waseg. ");
INSERT INTO myw_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","5","Bitamwa̱saws-vak peinan gamag biyagageids. Biyagageids mogo takaptuleids-wan, takaptuleids bo beivag adsinaps bwein, o bitanamis va̱gan Yowbad bilabeids. Nag bitanamis mav, peinan Yowbad bo isekeids Kululuwan Bwanabwein, waseg bo ikatimweis nasiwa̱youb, mo ivakaein wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kweiboug igaw tougwey ya̱kids, bo ilouvat anatut, Kelis nikanig silma̱nin takalbalebs ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Adok nag kal bikanig va̱gan bileb tadidumwal teitan, nag. Adok bitatawtoun-wan mo bitakanig va̱gan bitaleb teitan ansinap bwein. ");
INSERT INTO myw_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","9","Singay gog Yowbad nisiwyoubuds peinan Kelis ikanig peinads, kweiboug igaw takalbalebs ya̱kids. Buya̱vin Kelis waseg mo ikidumwa̱luds, mo bikatinabweids Yowbad nakavikun wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kweiboug nitakamliwes Yowbad, tage Natun mo ikanig mamagina lun bulukwan mo tamsamwas sods Yowbad; towen Kelis mo bikatinabweids, mwamovan tonen waseg. ");
INSERT INTO myw_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","E, mo tamwa̱saws waseg Yowbad peinan daGuyaws Yeisuw Kelis iluns son Yowbad mo tamsamwas babaw ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Tatanok gamag waseg sinap kalbaleb nisilamaw wadaban pwepway, mapun kanig mo isap. Babaw gamag takanka̱nigs peinan meivek ya̱kids adsinaps kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kweiboug Moses nakaleiwag nag, gamag asisinap kalbaleb; tage nag idokes asisinap kalbaleb, peinan kaleiwag nag. ");
INSERT INTO myw_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Tutan Adam waseg kanig itawtoun wasigeis gamag oko in ilouvat Moses inatut waseg. Kanig bo itawtoun wasigeis tasiyas asisinap kalbaleb ma̱wan Adam ansinap, sisiyas tasiyas asisinap kalbaleb kweitan kweitan. Taninuways Adam waseg kabebay nises, peinan Adam mamagina teitan gamag. Tayuwein gog wankuyeim mo neim. ");
INSERT INTO myw_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Yowbad nasiwa̱youb nag ma̱wana Adam ansinap kalbaleb; kweitan-wan. Adam ivag ansinap kalbaleb mo babaw ikanka̱nigs; tage singay Yowbad nasiwa̱youb singay mo itam tayuwein gamag mtowen Yeisuw Kelis, mo ikatimweis nasiwa̱youb singaya avakaein wasigeis ya̱kids adbabaws. ");
INSERT INTO myw_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kweiboug teitan gamag ansinap kalbaleb, gamag babaw mo ivag asisinap kalbaleb; Yowbad mo ikamta̱nis. Tage Yowbad nasiwa̱youb anagin kweitan, waseg ikidumwa̱luds ya̱kids, adsinaps babaw kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Teitan gamag kweiboug ansinap kalbaleb, mapun kanig mo itawtoun wasigeis gamag; tayuwein gog, Yeisuw Kelis, bo biyamoves tasiyas itams nasiwa̱youb avakaein waseg, peinan nag kweitan maysan tasekes, tage makava ikidumwa̱luds. ");
INSERT INTO myw_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Taninuways teitan ansinap kalbaleb mo Yowbad bikamtan gamag babaw wasigeis. Tayuwein ma̱wan, inawotet didumwal mapun tamwamovs o tadidumwals tababaw ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Teitan bo isiplev Yowbad aygan, babaw gamag mo ikawes ansinap kalbaleb. Wankuyeim tayuwein ikanow Yowbad aygan mo bitamlavags tadidumwals, ya̱kids babaw. ");
INSERT INTO myw_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Moses nakaleiwag isap mo ikatimweis kalbaleb sinap ivakaein. Sinap kalbaleb ikatimweis ivakaein, tage Yowbad nasiwa̱youb singaya bo ikatimweis, ivakaein singay. ");
INSERT INTO myw_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","E, taninuways. Sinap kalbaleb mapun kanig bo itawtoun wasigeis gamag. Yowbad nasiwa̱youb mo bitawtoun wasigeis gamag peinan ikidumwa̱luds va̱gan bitamovs bitasigagas, peinan daGuyaws Yeisuw Kelis nasiwa̱youb wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ama̱wan? Adok bitavvaluts adsinaps kalbaleb waseg va̱gan Yowbad biwdiwid, mamagina nasiwa̱youb bikatimweis wasigeis ya̱kids, ne? ");
INSERT INTO myw_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Nag. Sinap kalbaleb bo ikanig wasigeis ya̱kids; ta-ma̱wan bitavvaluts waseg. ");
INSERT INTO myw_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Kuninuways peinan tababaw ya̱kids nibapta̱yseids Yeisuw Kelis waseg, nitala̱tans sods, inakanig waseg. ");
INSERT INTO myw_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ma̱wan nidibwanis Yeisuw, bo nibapta̱yseids mamagina nidibwanids takanigs ya̱kids. E, ma̱wan Tamads natawtoun waseg iyakit Kelis, ma̱wan magin bo iyakituds, mo tanounas, mwamovads kweivaw waseg. E, bo nitamta̱mats sods Kelis va̱gan tut towen bitaba̱nes mwamovads kweivaw. ");
INSERT INTO myw_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nitakanigs mamagina tala̱tans sods Kelis, nakanig waseg; mapun mo takits vayuwein, mamagina tala̱tans sods Kelis, nakabeikit waseg. ");
INSERT INTO myw_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Taniniways adsinaps kweiboug bo ikatimet son Kelis, mo ikous woud kalbaleb nakaleiwag, peinan ilikuds sinap kalbaleb ankaleiwag wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Bo ikous sinap kalbaleb nakaleiwag wasigeis tasiyas takanigs. ");
INSERT INTO myw_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nitakanigs sods Kelis mapuna tamwamovs sods Kelis. E, tasimounids ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Taninuways Kelis nakanig, waseg itamanaw, nag vayuwein bikanig. Kanig nakaleiwag bo ikous waseg Kelis. ");
INSERT INTO myw_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Sivtanok ikanig, sinap kalbaleb silma̱nin; tut towen mo imov silma̱nin Yowbad. ");
INSERT INTO myw_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yakamiy-vak, kadiloka kudokeimiy takanigs yakamiy silma̱nin sinap kalbaleb; awoum bukuvgavaws; tage kumovs simiy Yeisuw Kelis, silma̱nin Yowbad nawotet. ");
INSERT INTO myw_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Awoum sinap kalbaleb bikaluweg woumiy ven watinow; awoum bukwanawes aygan, aveiyag sivinan bivag. ");
INSERT INTO myw_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Awoum kuta̱mes woumiy wuliyougwan va̱gan biwtel sinap kalbaleb nawotet, tage kutams Yowbad nawotet waseg, peinan bo niyamoveimiy mikanig waseg, o kuta̱mes woumiy wuliyougwan silma̱nin Yowbad nawotet didumwal. ");
INSERT INTO myw_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Awoum ge sinap kalbaleb bikaleiwag wasigeis yakamiy, peinan dakaleiwags kweivaw, siwa̱youb waseg. Moses nakaleiwag bo ikous wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","E, dakaleiwags kweivaw waseg siwa̱youb. Tabta beivag adsinaps kalbaleb peinan bo ikous Moses nakaleiwag wasigeis ya̱kids, ne? ");
INSERT INTO myw_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nag. Tabta kukwakins igaw bukutams mitovek waseg, bukukwanawes aygan, mo bukumlavags natouwats. Takinew mitovek yagan sinap kalbaleb, mapun mo bukuba̱nes kanig. Takinew gog mitovek yagan toukum, mapun mo bukuba̱nes amisinap didumwal. ");
INSERT INTO myw_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","18","Kalin nuwag Yowbad. Kweiboug sinap kalbaleb natouwat yakamiy, mo kateimiy nukuta̱mes waseg liva̱nen Yowbad. Bo ikous sinap kalbaleb nakaleiwag wasigeis yakamiy, mo sinap didumwal ikaleiwag wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Allivan mamagina sinapun ven watinow waseg, peinan ninoumiy igaw bula̱bol yakamiy. Kweiboug nukuta̱mes woumiy wuliyougwan silma̱nin sinap kalbaleb bikatimweis bivakaein wasigeis yakamiy, kadiloka kuta̱mes silma̱nin sinap didumwal mo bukukwawes Yowbad anmwa̱net nawotet. ");
INSERT INTO myw_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Igaw kweiboug sinap kalbaleb natouwat yakamiy, sinap didumwal nag ikaleiwag wasigeis yakamiy, nag. ");
INSERT INTO myw_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Tut gog towen amimwasin peinan nukuva̱ges ma̱wan. Tage la̱lan bo kuba̱nes tan? Adok nag. Maysan sinap towen yagan kanig. ");
INSERT INTO myw_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Tut towen bo ikous sinap kalbaleb nakaleiwag wasigeis yakamiy, mo nukumlavags Yowbad natouwat yakamiy, la̱lan bo kuba̱nes Yowbad inakamnat, nakabiyokous waseg mwamovamiy nag beikous. ");
INSERT INTO myw_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Sinap kalbaleb maysan kanig; tage Yowbad bo isiwyoubuds daGuyaws Yeisuw Kelis waseg, mwamovads nisekeids nag beikous. ");
INSERT INTO myw_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sigwey yakamiy, kuninuways Moses nakaleiwag. Bo kukwakins Moses nakaleiwag, ne? Igaw bitamta̱mat mo beikous kaleiwag towen waseg ya̱kid. ");
INSERT INTO myw_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kavel mana̱wen navaveig kadiloka bisesus son namwan, peinan Moses nakaleiwag ma̱wan. Igaw namwan beimat mo beikous kaleiwag-nen veivay, peinan bo imlavag nakwab. ");
INSERT INTO myw_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Tage igaw namwan nises, kukin binek tobwag taw, mo bimlavag naggeinawl. Tage kukin namwan bikanig mo beikous veivay kaleiwag-nen, bweina bivevaw son tayuwein taw. Nag bimlavag naggeinawl, nag. ");
INSERT INTO myw_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Yakamiy ma̱wan, won Kelis waseg, mamagina nukumta̱mats, mo ikous Moses nakaleiwag wasigeis yakamiy. Mamagina mitovek kweiboug bo imat. Mitovek kweivaw nises, mtowen neikit kanig waseg va̱gan mo bitawteles beibwein nawotet Yowbad. ");
INSERT INTO myw_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ya̱kids kweiboug igaw mamagina ven watinow gimgilis ya̱kids, Moses nakaleiwag bo iyakit nanouds silma̱nin sinap kalbaleb, wouds wuliyougwan mo iwotet kalbaleb, maysan mo talivatus, yagan kanig. ");
INSERT INTO myw_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Tage mo ilik Moses nakaleiwag wasigeis ya̱kids, mamagina inadeil wanuwan takanigs va̱gan beikous deil nakaleiwag wasigeis ya̱kids, mo tasaps taneis wamnat. Bo ikous Moses nakaleiwag wasigeis ya̱kids, towen nilel wa̱buk, tage takanawes kaleiwag kweivaw, Kululuwan mwamov-nen waseg. ");
INSERT INTO myw_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Aveiyag bitalivans? Tab tadokes Moses nakaleiwag mamagina sinap kalbaleb, ne? Nag. Tage kukin kaleiwag nag, nag bakakin sinap kalbaleb. Kaleiwag kweitan mamagina: “Awoum kupwa̱kit soum navavag.” Kukin nag beivag kaleiwag towen, nag bakakin pwa̱kit. ");
INSERT INTO myw_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Tage Moses nakaleiwag bo ileb sinap kalbaleb waseg yey, mo avag pwa̱kit babaw. Magat kaleiwag nag beivag, nag bitakakins adsinaps kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Magat kweiboug kaleiwag nag, bo ba̱mov, wankuyeim kaleiwag isap, iyakit sinap kalbaleb, mo akanig. ");
INSERT INTO myw_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Moses nakaleiwag silma̱nin mwamov mamagina bo ikatimateig. ");
INSERT INTO myw_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nakaleiwag bo ileb sinap kalbaleb, mo ikatidavig, va̱gan kaleiwag towen beiweig. ");
INSERT INTO myw_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tage Moses nakaleiwag katanok katanok bwanabwein, didumwal. ");
INSERT INTO myw_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Tage youd bwanabwein bikatimateig tan? Nag. Sinap kalbaleb ikatimateig. Kaleiwag bwanabwein, tage sinap kalbaleb ikatimateig, va̱gan bitakakins sinap kalbaleb tonen; o kaleiwag bwanabwein waseg mo bitakakins sinap towen singaya kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Taninuways Moses nakaleiwag bwanabwein, peinan meinoy neim Yowbad waseg. Tage woug igwey, peinan sinap kalbaleb ikalawageig. ");
INSERT INTO myw_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nag akakin agusinap tatoneig. Aveiyag ivag sivinag nag bawtel ma̱wan. Tage sinap towen akasigum mo avag ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nanoug itam ilana, “Moses nakaleiwag bwanabwein,” peinan nag sivinag bawotet kalbaleb, tage bo avag ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nag yey agusinap towen, misinaka sinap kalbaleb nises wanuwag. ");
INSERT INTO myw_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Akakin-wan nag aveiyag bwanabwein wananoug nises, peinan woug igeg. Sivinag sinap bwanabwein, ta-ma̱wan bawtel. ");
INSERT INTO myw_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Sinap bwanabwein sivinag, nag gog; bapiyev sinap kalbaleb tage mo avag kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Sinap kalbaleb bapiyev mo bavag, peinan nag yey agusinap tage sinap kalbaleb towen nises wananoug. ");
INSERT INTO myw_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Bo aban sinap kweitan. Kukin sivinag bawtel bwein, sinap kalbaleb mo bimekeig. ");
INSERT INTO myw_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Wananoug singay ivag sivinag Yowbad nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Tage bo aban tobwag kaleiwag woug wuliyougwan waseg. Kaleiwag kalbaleb ikanaviy waseg kaleiwag bwein, wananoug nises; mo akanow sinap kalbaleb woug wuliyougwan waseg nises. ");
INSERT INTO myw_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Singay ayakalin, peinan nag kavel ikadilok bikatinabweig woug ankalbaleb waseg, peinan kanig nises. ");
INSERT INTO myw_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kalin nuwag Yowbad, peinan daGuyaws Yeisuw Kelis bikatinabweig. Nanoug tatoneig ikanow Yowbad nakaleiwag, tage woug bikanow sinap kalbaleb nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Magat ya̱kids waseg Yeisuw Kelis bitases, Yowbad ta-ma̱wan biyateleid. ");
INSERT INTO myw_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Yowbad Kululuwan iyamoveids ya̱kids sods Kelis. Kululuwan kaleiwag-nen bo ilikud waseg sinap kalbaleb inakaleiwag va̱gan nag bitakanig. ");
INSERT INTO myw_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Yowbad kadilok wotet towen, Moses nakaleiwag nag kadilok bilabeids peinan wouds igwey. E, Yowbad nawotet towen, mamagina, Natun ikayeb neim, ikow kaleivin ma̱wana gamag takalbaleb ya̱kids; itawtoun waseg adsinaps kalbaleb, peinan won tonen imlavag mamagina lun bulukwan. ");
INSERT INTO myw_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Iwotet ma̱wan va̱gan bitayakousis Moses nakaleiwag, peinan bo bitakanawes Yowbad Kululuwan nakaleiwag; wouds inakaleiwag awoum. ");
INSERT INTO myw_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kukin kal yakamiy bikanow woun nakaleiwag mo beivag sivinan woun wuliyougwan; kukin gog bikanow Yowbad Kululuwan nakaleiwag mo beivag sivinan Yowbad Kululuwan wuliyougwan. ");
INSERT INTO myw_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kukin beivag sivinad woud wuliyougwan mo bitakanig, tage kukin beivag sivinad Yowbad Kululuwan wuliyougwan, mwamovad mo bitaban son niwal. ");
INSERT INTO myw_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","8","Kukin kalisiy sivines wous wuliyougwan mo bikamliwes Yowbad, nag beitams Yowbad nakaleiwag waseg. E, ta-ma̱wan gamag tasiyas beitams Yowbad nakaleiwag waseg; o ta-ma̱wan Yowbad bikalin nuwan gamag tasiyas wasigeis, nag. ");
INSERT INTO myw_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Peinan wous ikalawages tatineis; yakamiy gog miked kweitan, peinan Kululuwan Yowbad simiy bikalawageimiy. Kal yak Kelis kululuwan ika̱bwag waseg yak, nag Kelis angamag ya̱koum, nag. ");
INSERT INTO myw_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Tage Kelis niwekeimiy, woumiy bo imta̱mats waseg sinap kalbaleb, tage kululuwamiy imwamovs amisinap didumwal waseg. ");
INSERT INTO myw_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yowbad bo iyamov Yeisuw kanig waseg, mo Kululuwan Yowbad simiy nukusesus, woumiy Yowbad biyamov Kululuwan waseg, peinan nises wanuwamiy. ");
INSERT INTO myw_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","13","Sigwey, awoum bitawotets wouds wuta̱lan. Awoum bitakanawes wouds nakaleiwag. Ked towen beinoy bein kanig waseg. Tage kadiloka bitawotets Yowbad Kululuwan wuta̱lan; waseg bitakatimet wouds inawotet, mo bitamovs. ");
INSERT INTO myw_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kukin Yowbad Kululuwan bikaluwageid, mamagina Yowbad nitun ya̱kid; kukin nag bikaluwageid, tobwag gamag nitun ya̱kid. ");
INSERT INTO myw_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","16","Magat Yowbad nag bisekeids nanouds mamagina nitun ya̱kids, adok mo bivgavaw adpwa̱yats, mamagina natawwotet ya̱kids. Tage bo isekeids nanouds mamagina nitun tatonen, mo tadawes talansa, “Tamad.” (Aga-Ibliw waseg ilansa “Aba.”) Kululuwan tatonen nanon ma̱wana kululuwads ya̱kids, mo takakins Yowbad nitun ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","O peinan Yowbad nitun ya̱kids mo bitakawes dakiyays. Yowbad bisekeids dakiyays sods Kelis, peinan a̱bads bigeg sods Kelis, yakawanads mo bitaba̱nes sods Kelis. ");
INSERT INTO myw_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nanoug ma̱wan. Adok a̱bads bigeg tut towen waseg, tage nag bivakaein mouvitan peinan singay bitamwa̱saws igaw tutan Yowbad yakawanan mo bitaba̱nes ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Yowbad nakabwabub meivek-wan ikayamat avei-tut Yowbad nitun bikamat waseg mtowen, mo bikines; e, singay sivines bikines. ");
INSERT INTO myw_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kweiboug bo iyamkwen inakabwabub. Nanon bo ma̱wan. Nanon nag inek youd tasiyas. Tage tasiyas inmises igaw bikatlow mo beibwein. ");
INSERT INTO myw_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Tut towen nakabwabub babaw ipsa̱pwas. Nag kweitan youd bises bisigeg. Igaw Yowbad mo bilikus youd tasiyas; mo bisesus wamnat bimwa̱saws bisigagas, ma̱wan Yowbad nitun ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Taninuways peinan youd katanok katanok meiveka Yowbad nakabwabub nilidelids sigidaged waseg ee... tut towen bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ya̱kids-vak bo ma̱wan talidelids. Yowbad Kululuwan anagin bo isilamaw wasigeis ya̱kids, tage nanouds waseg talidelids, takayamats avei-tut Yowbad bikanatun wasigeis ya̱kids mamagina bikatinob wouds ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","E, bo ikatinabweids son danamis, peinan igaw wouds mo bikatuneib. Bitakin nawotet towen mo beikous danamis, peinan bo beitout nanoud. ");
INSERT INTO myw_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Tut towen ya̱kids nag takines tage bitanmises, bitakaymates sona dakapatuls. ");
INSERT INTO myw_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Yowbad Kululuwan ma̱wan ilabeids, peinan tougwey ya̱kids; nag takakins ama̱wan igaw bitanitougs waseg Yowbad, tage Yowbad Kululuwan tonen initoug peinads, singaya igel waseg Yowbad. Nag bitalivan! ");
INSERT INTO myw_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Yowbad ikakina nanouds ya̱kids. E, mapuna Kululuwan nanon ikakin-wan, kululuwan tonen initoug peinads ya̱kids tayakelesiys ma̱wana Yowbad nanon. ");
INSERT INTO myw_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Taninuways. Kukin nanoud waseg bitasiwyoubus Yowbad, mtowen mo bikaleiwag youd bwanabweins wasigeis ya̱kids, nidaweids, nitimek nanon wasigeis ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kweiboug ikakin ya̱kids mo ikaleiwag va̱gan bitamlavags ma̱wana Natun ankakin tatonen; mtowen wanamug, budan ya̱kids wankuyeim. ");
INSERT INTO myw_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","E, kweiboug bo ikaluweg mo idaweids; idaweids mo ikidumwa̱luds; ikidumwa̱luds mo isekeids yakawanads. ");
INSERT INTO myw_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Adok livan towen bo misinak. Peinan Yowbad bilabeids, nag kal bisilbwadeids. ");
INSERT INTO myw_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Nag ikayus Natun tatonen, tage bo itam peinads ya̱kids, igaw mo bisekeids youd babaw son Kelis. ");
INSERT INTO myw_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","34","Nag kal biyateleids peinan Yowbad bo ilivnek nagamag ya̱kids. Yowbad bo ikidumwa̱luds; nag kal biban adsinaps kalbaleb. Yeisuw Kelis nikanig mo ikit vayuwein, mtowen misikey Yowbad wanaka̱tay, ininitoug kid peinads ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nag aveiyag kadilok bisilbwed Kelis nasiwa̱youb wasigeis ya̱kids. Takinew gamag biyagageids, o bikamliweids; takinew beivag adamouns, o bitamwadoys, o bitakatouns; takinew gamag beiweids; nag gog. ");
INSERT INTO myw_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Liva̱nen nises Bukitab waseg mamagina: “Mugwamag yakamey, bo iwawemas, bakamta̱mat yam katanok katanok. Yakamey mamagina mansiyas sip, yakamey; idokes beiwemas mo bigabumas.” ");
INSERT INTO myw_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","E, a̱bad bigeg youd katanok katanok waseg, tage mtowen nisiwyoubuds ilabeids mo tatakayways singay. ");
INSERT INTO myw_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Mounid akakin nag aveiyag bigidem Yowbad nasiwa̱youb wasigeis ya̱kids. Ya̱kids bitasesusa bwein; takinew bitakanig, o takinew tamwamov, takinew Seitan siney nagamag biyagageids, o aveiyag binuwakeids tut towen o takinew tut wanakougwaw; takinew takaleiwags mwasanin biyagageids, o bikaweid binaweid wanakaew, o takinew bigimkuluds wabwanit; peinan nag aveiyag nises son natawtoun va̱gan bigidem Yowbad nasiwa̱youb wasigeis ya̱kids, nag. Nasiwa̱youb towen singay avakaein daGuyaws Yeisuw Kelis nisekeids. ");
INSERT INTO myw_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","2","Agulivan mounid, mamagina Kelis waseg. Awoum bayaweid. Yowbad Kululuwan ilabeig. Nanoug waseg mo akakina agulivan mounid. Peinan singaya ikalin nuwag talawog, tasiyas min-Yudiy. E, tut babaw igeg nanoug pines tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Sivinag Yowbad biyagageig o bigidem Kelis nasiwa̱youb waseg yey, va̱gan kid bisiwyoubus tasiyas talawog. ");
INSERT INTO myw_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","5","Mounid min-Yisleil tasiyas. Yowbad dilenen tasiyas bo isekes yakawanan tonen, bo ikaveiyon wasigeis tibsiyas, isekes nakaleiwag, o sitapwa̱loul, o ilivnek youd bwanabwein igaw mo bisekes. E, anilivan ma̱wan wasigeis tammwayas, tasiyas Ebelam, Aysak, Yekob; e, gimgilitoun Kelis delen mtowen Ebelam. Mapuna takavasis Yowbad tut nag beikous, mtowen takaleiwag youd babaw wasigeis. Eimen. ");
INSERT INTO myw_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Awoum bitadokes Yowbad ikatigikesa mav. Tasiyas Yisleil dilenen mwasanin mounid min-Yisleil, mwasanin gog tobwag. ");
INSERT INTO myw_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","O Ebelam tibun mwasanin dilenen mounid, mwasanin gog tobwag. Misinaka Aysak tibun Yowbad idoki dilenen Ebelam. Bo idibek, ilana, “Aysak tibun bimlavags deleim ya̱koum.” ");
INSERT INTO myw_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Mamagina Yowbad nag nitun tasiyas Ebelam tibun nikopwes ven watinow waseg, nag. Tage peinan anilivan mounid isek, mo ya̱kids bitamlavags Yowbad angamag ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kweiboug Yowbad nilivnek; isek Ebelam anilivan ma̱wan: “Igaw tut bwanabwein waseg mo ba̱yum baw, igaw Sela mo bikop natun kuda̱taw.” ");
INSERT INTO myw_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","12","Ma̱wan-vak Libek neivays son tabuds Aysak mo isum papaps wanuwan, Yowbad idibek, ilana, “Kunutaw bikanow aygan digumasus.” Igaw wanuwan ines nisesus; nag ivag asisinap bwanabwein o kalbaleb, nag. Tage Yowbad bikaleiwag va̱gan bilivnek angamag, nag peinan asisinap; misinaka bilivnek ma̱wana nanon. Mapuna Yowbad idibek Libek, ilana, “Kunutaw bikanow aygan digumasus.” ");
INSERT INTO myw_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Liva̱nen nises Bukitab waseg, mamagina: “Sivinag Yekob; Isaw gog apiyev.” ");
INSERT INTO myw_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Aveiyag bitalivan? Adok bitalana, “Yowbad ansinap nag idumwal?” Awoum bitalivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Anilivan gog Moses waseg, ilana, “Kukin kal sivinag basiwyoub; kukin kal binok nuwag, mo binok nuwag.” ");
INSERT INTO myw_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Yowbad binok nuwan ya̱kid nag peinan nanoud o dawotet, nag. Misinaka nasiwa̱youb tatonen waseg mo binok nuwan ya̱kid. ");
INSERT INTO myw_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Liva̱nen Pelow nises Bukitab waseg, peinan Yowbad idibek Pelow, ilana, “Bo asekeim guyaw va̱gan bakamtilakes gamag babaw, bikines guntawtoun waseg yak, mo ven babaw gimgilis biliganes butug. O yagag yey bikavtagis.” ");
INSERT INTO myw_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","E, taninuways, kalisiy Yowbad sivinan binok nuwan mo bisiwyoubus; tage kalisiy sivinan bivag bikakons mo ivag ikakons. ");
INSERT INTO myw_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Adok bukudibakeigs, kulansa, “Kukin Yowbad bikalawageid ma̱wan nanon, ta-ma̱wan bitasilbwed. Igaw beivag adsinap kalbaleb peinan bo ivag nanon ma̱wan, adok awoum biyateleid.” ");
INSERT INTO myw_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Awoum kal gamag ya̱koum kuvtok livan Yowbad, awoum. Magat loutan beivag nanon, tab kadilok bidibek tawtelein, bilana, “Aveiyag wawun nukuva̱geig agukwakin ma̱wan?” Adok awoum bilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Adok tawtelein loutan bikaleiwag bidapwat waseg, ne? E, kadiloka bikow bidapwat babaw, simultanok waseg bivag loutan kweitan anlelel bwein; o som kwayuwein bivag loutan kweitan silma̱nin wotet, anlelel nag. ");
INSERT INTO myw_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Kadilok Yowbad bikaleiwag ma̱wan, peinan sivinan gamag ya̱kids bitakines inaya̱tal o natawtoun wasigeis takalbalebs, ikapatul wasigeis tasiyas ee... igaw mo bigulekwes. ");
INSERT INTO myw_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","O peinan sivinan gamag ya̱kids bitakines ansinap singay kamnat wasigeis ya̱kids nisiwyoubuds, o kweiboug nibun dakamnats peinads ya̱kids. ");
INSERT INTO myw_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","E, bo idaweids nag misinaka min-Yudiy ya̱kids, tage tobwag ven gimgilis mwasanin-vak nidawes tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Liva̱nen nises palopit Osey anilivan mamagina: “Tasiyas nag gungamag Mo badokes balana, ‘Agugwamag tasiyas.’ Peinan bod towen, gamag nag sivines, Mo badokes gunabod tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ven tasiyas nidibakes, ilana, ‘Nag gungamag yakamiy.’ E, ven wunsiyas mo bidokes bilana, ‘Yowbad tamwamov nitun tasiyas.’” ");
INSERT INTO myw_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","28","Isaya kweiboug iwak, liva̱nen Yisleil ilana, “Adok Yisleil tibun bibabaw ma̱wana alekel babewein, Tage teiyuy Yowbad bikatinabwes. Babaw biwaweiys, ven watinow gimgilis, Peinan bitawtoun, nuwanaw, nawotet towen waseg.” ");
INSERT INTO myw_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Isaya ma̱wan nilivnek, ilana, “Kukin liba̱lab guyawun nag bikatibom nitidayas mwasanin, mo biyagageids beikous, ma̱wan Sodom kweiboug, o ma̱wan-vak Gomol, biyagageids beikous.” ");
INSERT INTO myw_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Aveiyag bitalivan? Adok tobwag ven gimgilis igaw dadub nag ivag sivines asisinap bididumwal, tage bo iba̱nes asisinap didumwal peinan isimounids waseg Yowbad. ");
INSERT INTO myw_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Tage min-Yisleil sivines bikanawes Moses nakaleiwag silma̱nin sinap didumwal, iyokons, bo nag, peinan nag ikanawes bwein Moses nakaleiwag. ");
INSERT INTO myw_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Aveiyag wawun? Iyokons, tage nag isimounids Yowbad waseg. Idokes misinaka biwotets bwein mo biba̱nes. Nag gog. Mamagina kikeis ikatpines wululay nimmasis wapwepway mo ikalka̱louws. ");
INSERT INTO myw_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kabebay-nen nises Bukitab waseg mamagina: “Kukines, ven Sayon waseg basen gunawlulay va̱gan bikatpines kikeis, mamagina dakul kikeis bikatpines mo bikalka̱louws. Tage kukin kal bisimounid waseg wululay towen nag beivag anmwasin.” ");
INSERT INTO myw_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Sigwey, singay sivinag Yowbad bikatinabwes tasiyas min-Yisleil, aninitoug Yowbad waseg pines tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Akakin iseiw nuwes silma̱nin Yowbad, tage tatagouwaws tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nag ikakins sinap didumwal meinoy neim Yowbad waseg, mo iyokons kid biva̱ges tatineis asisinap didumwal; tage nag itams Yowbad ansinap didumwal waseg. ");
INSERT INTO myw_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Peinan Kelis mwana neim, bo iyakous Moses nakaleiwag va̱gan kid bikidumwal adsinaps ya̱kids, peinan tasimounids waseg. ");
INSERT INTO myw_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moses nilel mamagina: “Kukin kal bikanow kaleiwag towen, mwamovan mo biban waseg.” ");
INSERT INTO myw_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Tage bitasimounid waseg Yowbad va̱gan bikidumwa̱luds, inakaleiwag kweitan; ilana, “Awoum kuninuways ‘Kal bein walba̱lab?’” (mamagina Kelis bitatok bitamey watinow). ");
INSERT INTO myw_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Awoum kuninuways ‘Kal beibus bein wanuwan leg?’” (mamagina bitayakit Kelis, kanig waseg). “Awoum.” ");
INSERT INTO myw_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Tage ilana, “Livan towen nises, wawdoumiy o waninoumiy.” Livan towen mamagina simounid liva̱nen, waseg nakageiguy. ");
INSERT INTO myw_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kukin bitatam wadoud daGuyaws Yeisuw waseg, o wananoud bitasimounid peinan Yowbad iyakit kanig waseg, e, Yowbad mo bikatinabweid. ");
INSERT INTO myw_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Gamag ya̱kid nanoud bitasimounid, Yowbad mo bikidumwal adsinap; o bitatam wadoud waseg mo bikatinabweid. ");
INSERT INTO myw_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Liva̱nen nises Bukitab waseg, mamagina: “Nag kal bisimounid waseg towen, mo beivag anmwasin, nag.” ");
INSERT INTO myw_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nag ilivis min-Yudiy palatan, ven mwasanin gimgilis palatan, nag. Babaw ya̱kids daGuyaws kanatok-wan. Magat bitanitoug waseg mo bisiwyoubud bwein. ");
INSERT INTO myw_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Adbabaws-wan bitadouws daGuyaws wayagan, mo bikatinabweids. ");
INSERT INTO myw_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Tage gamag mwasanin ta-ma̱wan bidawes yagan, peinan nag isimounids waseg. Ta-ma̱wan bisimounids peinan nag ikakins yagan. Nag ikakins yagan, peinan tageiguy nag. ");
INSERT INTO myw_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kukin go bikayabes tageiguys, mo binekes, biliganes, bisimounids mo bidawes yagan o bikatinabwes. Liva̱nen tageiguy nises mamagina: “Adbwabwals singay bwein peinan igeiguys livan bwanabwein waseg!” ");
INSERT INTO myw_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Tage babaw gamag nag itams waseg livan towen bwanabwein. Isaya anilivan kweiboug mamagina: “O Guyaw nag kavel isimounid agulivan waseg.” ");
INSERT INTO myw_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Tage bigeiguys liva̱nen Kelis mo biliganes mwasanin, bisimounids. ");
INSERT INTO myw_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Tage bulagan inekes, tan? Magen! Liva̱nen nises mamagina: “Ages bo iliganes ven babaw wasigeis. Asilivan bo ikatiliganes ven babaw wadaban pwepway.” ");
INSERT INTO myw_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Tage min-Yisleil nag ikakins. Wanamug Moses anilivan mamagina: “Igaw min-Yisleil yakamiy bukukines makava gamag mwasanin, mo bavag dibamiy bimouvit. Bod tasiyas tabla̱bols bukukines, mo bavag bikapasal nuwamiy min-Yisleil yakamiy.” ");
INSERT INTO myw_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Wankuyeim Isaya ikatiginaney, ilel Yowbad anilivan mamagina: “Tasiyas nag ineveigs tage bo iba̱neigs. Tasiyas nag ikatugwans silma̱nin yey mo akamat wasigeis.” ");
INSERT INTO myw_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Tage liva̱nen min-Yisleil ilel mamagina: “Tut babaw adudouw wasigeis gungamag tasiyas takapidabs o takakons; adudouw, bo nag.” ");
INSERT INTO myw_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Adok Yowbad bo ipiyev angamag tasiyas min-Yisleil, ne? Nag. Yey gum-Yisleil teitan yey. Ebelam delen teitan yey, agukum Binyamin. ");
INSERT INTO myw_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Yowbad nag ipiyev inagamags tasiyas kweiboug nilivnek. Kuninuways liva̱nen Ilaytiy Bukitab waseg, peinan idibek Yowbad, ivtokes livan min-Yisleil, ilana, ");
INSERT INTO myw_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“O Guyaw bo iweiys mupalopits, bo igulekwes mukwabeilun. Agumwa̱neta yey mugwamag nases, mo sivines kid beiweigs.” ");
INSERT INTO myw_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Tage Yowbad ikatimop anilivan, ilana, “Bo akayus gungamag kweinim kweiy tawsan nisesus. Nag ikululs wamatan Bal, gungamag tasiyas.” ");
INSERT INTO myw_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ma̱wan kweiboug Yowbad ikayus nagamag mwasanin, ma̱wan tut towen bo idawem min-Yisleil mwasanin yakamey, peinan nisiwyoubum. ");
INSERT INTO myw_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Deisa isiwyoubum mo idawem. Nag idawem peinan mawotet bwanabwein; nag. Siwa̱youb-wan. ");
INSERT INTO myw_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ama̱wan? Min-Yisleil mwasanin inineivs Yowbad nasiwa̱youb, tage nag iba̱nes, yakamey gog nilivnek mo nakaban; tasiyas babaw bo ikakons. ");
INSERT INTO myw_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Livneis nises Bukitab waseg mamagina: “Yowbad bo iyabol ninous tasiyas. Mites nag bikines; tiges nag biliganes ee... tut towen bo ma̱wan.” ");
INSERT INTO myw_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Deibid-vak anilivan mamagina: “Kadiloka sisagal bimlavag mamagina sik o mamagina wot. O mamagina leg va̱gan bikatimop asisinap kalbaleb wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kadiloka beikaw mites; awoum bikines. Kunes moumouvit waseg tut nag beikous.” ");
INSERT INTO myw_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Adok min-Yudiy ikatpines kikeis, bikalouws ne? Nag. Bo bitamanaws vayuwein. Min-Yudiy bo ikalows, tage Yowbad bo isek nasiwa̱youb wasigeis tobwag ven gimgilis yakamiy, va̱gan bikatinabweimiy. Min-Yisleil bikineimiy mo bimouvit dibes. ");
INSERT INTO myw_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Tut towen min-Yisleil bo ikalouws mo ven mwasanin yakamiy kumwa̱saws. Kukin vayuwein bitamanaws tasiyas min-Yisleil, o beisiws Yowbad nakaleiwag waseg, mo singay bitamwa̱saws. ");
INSERT INTO myw_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","14","Adibakeimiy tobwag ven gimgilis yakamiy, peinan gunawotet akokew liva̱nen Kelis bassekeimiy ven babaw yakamiy; mo atawtoun gunawotet waseg va̱gan bukusimounids yakamiy mo min-Yisleil tasiyas bimouvit dibes, mo bisimounids mwasanin tasiyas, o Yowbad bikatinabwes. ");
INSERT INTO myw_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Yowbad bo ipiyaves tasiyas min-Yisleil mo imsamwas siney ven mwasanin gimgilis. Igaw Yowbad beitam wasigeis min-Yisleil mo singay bimsamwas siney tasiyas. Tut towen nag isimounids; mamagina takanigs tasiyas. Tut wanakougwaw mo bisimounids mamagina takanigs tasiyas bo beikits vayuwein. ");
INSERT INTO myw_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tammwayas Yowbad inagamag, ma̱wan tut towen mo imlavag nagamag min-Yisleil. Kabebay-nen mamagina: Pwalaw ivisan-wan bitakatibom silma̱nin Yowbad, va̱gan tamkwa̱lan mo bimlavag Yowbad navavag. Youpeis-vak bitakatibom silma̱nin Yowbad, beisob mo bimlavag Yowbad nakamweilok. Tammwayas ma̱wana youpeis; kay ma̱wana asibod avakaein. ");
INSERT INTO myw_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Min-Yisleil mamagina Yowbad nakamweilok, yayagein mwasanin bo iwwutus ikalouws, o yakamiy mamagina tobwag kay yayagein yakamiy kunekes kay towen atimapun tasiyas nikalouws, mo kay tonen sipinen iwmwamweimiy. ");
INSERT INTO myw_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Awoum kwaya̱pams peinan yayagein tasiyas nikalouws. Kukin bukwaya̱pams kadiloka kuninuways awoum bukwaleiwags kay-nen waseg, tage kay wawun bikaleiwag wasigeis yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Adok bukulana, “Min-Yisleil mamagina kay; yayagein tonen bo iwut va̱gan tobwag gamag yey ban bikativaseig kay towen waseg.” ");
INSERT INTO myw_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","21","Mounid. Bo iwtuwut tasiyas peinan nag isimounids. Tage ya̱koum nukuses bwein peinan kusimounid. Mata ge bukwaya̱pam. Kadiloka bukuwen Yowbad. Nag ikayus yayagein tatonen; adok nag bikayuseim peinan tobwag yayagein yak. ");
INSERT INTO myw_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kukines Yowbad nasiwa̱youb son nakaleiwag tawtoun. Nakaleiwag tawtoun wasigeis tasiyas nikalivatouws, tage nisiwyoubumiy yakamiy magat bukutoukums nasiwa̱youb waseg. Kukin gog nag, mo biwutumiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Tasiyas-vak, kukin nag bivvalutsa kapidab waseg, mo bikativases vayuwein kay towen waseg, peinan Yowbad kadilok bivag mo bikatuvas vayuwein. ");
INSERT INTO myw_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yowbad inakaleiwag kweitan wasigeis yakamiy, peinan bo iwutumiy tobwag kay waseg mo ikaweimiy ikativaseimiy waseg nakaligweg tatonen. Tage sivinan bikow yayagein tatonen bikativases kay-nen waseg, vayuwein mo binekes. ");
INSERT INTO myw_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","26","Sigwey, awoum kwaypamwes sinap. Sinap kweiboug nisowm, bo ikamat. Sivinag bukukwakins mamagina: Min-Yisleil mwasanin bo ikeikay dibes, ikapidabs ee... igaw tobwag ven gimgilis beisiws Yowbad nakabkaleiwag, babewein bikadilok; mo Yowbad bikatinabwes min-Yisleil asibabaw-wan. Liva̱nen nises Bukitab waseg mamagina: “Towen takatinabweids, Sayon waseg beinoy beim. Bivag mo beikous kalbaleb sinap Yekob delen wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Igaw gunakaleiwag basekes tasiyas, peinan bakow asisinap kalbaleb, banow, balev.” ");
INSERT INTO myw_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Min-Yisleil bo ikamliwes Yowbad, pinamiy yakamiy, va̱gan bukuliganes liva̱nen Yeisuw; tage Yowbad sivinan tasiyas, peinan ilivnek nasiwa̱youb wasigeis tibsiyas. ");
INSERT INTO myw_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Yowbad bidawes gamag mwasanin o bisiwyoubus, ta-ma̱wan bigidem anilivan tatonen. ");
INSERT INTO myw_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ven mwasanin gimgilis yakamiy kweiboug nukusiplaves aygan Yowbad; tasiyas-vak min-Yisleil isiplaves aygan Yowbad, mapuna inok nuwan yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Tasiyas nikapidabs, mo Yowbad inok nuwan yakamiy. Waseg mo binok nuwan tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Yowbad bo ilivan babaw gamag takapidabs ya̱kids mo binok nuwan ya̱kids, bikatinabweids. Nanon bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Yowbad ansinap singaya ivakaein wananon. Inakaleiwag nag takakins. Nawotet waseg bo isom nanouds. ");
INSERT INTO myw_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ta-kal iyakous daGuyaws nanon. Ta-kal bikatimlek Yowbad ansinap. ");
INSERT INTO myw_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ta-kal bisiwa̱youb Yowbad waseg va̱gan Yowbad mo bimop nasiwa̱youb, nag. ");
INSERT INTO myw_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Yowbad tonena ibun youd babaw, nisesus, peinan towen. Mapuna bitayakawanes tut nag beikous. Eimen. ");
INSERT INTO myw_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Aguyeimiy sigwey, peinan Yowbad ikalin nuwan ya̱kids; kadiloka bukuta̱mes woumiy mamagina lun bulukwan, kadilok Yowbad nawotet. E, kululuwamiy waseg kutams Yowbad nawotet waseg, peinan tut towen mwamovamiy son kusesus. ");
INSERT INTO myw_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Awoum kulatanes son ven watinow sinapun; tage beivag ninoumiy kweivaw va̱gan bikatilow amisinap, mo bukukwakins Yowbad nanon, aveiyag kamnat, aveiyag bwein, o aveiyag bikalin nuwan waseg. ");
INSERT INTO myw_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Yey agusinap nisiwyoubug, mapuna adibakeimiy tababaw yakamiy; “Awoum bukwaypamwes sinap, tage ninoumiy bidumwal ma̱wana Yowbad nilabeimiy, o nukusimounids, katanok katanok yakamiy.” ");
INSERT INTO myw_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Taninuways woun wuliyougwan babaw siwotet kweitan kweitan. ");
INSERT INTO myw_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Ma̱wan ya̱kids, babaw gamag ya̱kids, tage Kelis waseg nitamlavags katanoka woun o tananok tatanok ya̱kids talabeids sidsidayas. ");
INSERT INTO myw_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Yowbad nasiwa̱youb waseg yey kweitan, waseg yak kweitan, wasigeis sidayas kweitan kweitan; kadiloka bitawotets ma̱wan. Kukin Yowbad bisiwyoub kavel va̱gan bikakin anilivan bilivnek; e, kadiloka bisimounid waseg, mo bilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kukin kavel Yowbad bisek sinapun wotet, kadiloka biwtel ma̱wan. Kukin kavel Yowbad bisek katimlakay sinapun, kadiloka bikatimlakay ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Kukin kavel bisek geiguy sinapun, kadiloka bigeiguy ma̱wan. Kukin kavel bisek sinapun muloul, kadiloka bimuloul beibwein. Kukin kavel bisek nawotet va̱gan bilabes sidayas kadiloka biseiw nuwan towen silma̱nin. Kukin kavel bisek nawotet va̱gan binok nuwan sidayas, kadiloka bimwa̱saw waseg nawotet towen. ");
INSERT INTO myw_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kadiloka kusiwa̱youbs mounid; sinap kalbaleb kulavewas, tage sinap bwanabwein kuyousis. ");
INSERT INTO myw_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Bikalin nuwamiy, mo bukusiwyoubus simiyas. Kal singaya bivnas son? Kadiloka biseiw nuwamiy va̱gan bukuvna̱ses simiyas! ");
INSERT INTO myw_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Kadiloka tuta babaw biseiw nuwamiy Yowbad nawotet. Yowbad Kululuwan biwekeimiy mo bukukwamnats. Kadiloka bukutoukums daGuyaws nawotet waseg. ");
INSERT INTO myw_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Kumwa̱saws minamis waseg. Igaw gamag biyagageimiy bweina kwaptuleimiy. Kadiloka tut babaw bukuninitougs Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kumulouls va̱gan bukulabes tasiyas tayakelesiys. Kutams tasiyas amibwabwal wasigeis. ");
INSERT INTO myw_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Amilivan siwa̱youb kusekes tasiyas niyagageimiy; e, kusiwyoubus; awoum kubulates. Awoum. ");
INSERT INTO myw_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Kumwa̱saws simiyas tasiyas tammwa̱saws. Kuva̱lams simiyas tasiyas tavva̱lams. ");
INSERT INTO myw_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Kadiloka kumsamwas simsimiyas wasigeis. Awoum bukumliguyaws, kadiloka kutams tasiyas toul wasigeis. Awoum kukwaypamwes sinap. Awoum. ");
INSERT INTO myw_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Tasiyas iyagageimiy awoum kuyagages tasiyas; tage beivag amisinap bwein wamtes gamag babaw. ");
INSERT INTO myw_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Magat kadilokeimiy bukumsamwas simiyas meiveka gamag. Kadiloka kuyokons silma̱nin. ");
INSERT INTO myw_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","O kalin nuwag sigwey, awoum kwatimapus asisinap tasiyas niyagageimiy; bisiw; igaw Yowbad mo bikatimop. Liva̱nen nises mamagina: “Yey bakatimop asisinap kalbaleb. Yey gunawotet towen.” DaGuyaws anilivan mamagin. ");
INSERT INTO myw_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Awoum kwatimapus asisinap. Tage towen nikamliweim, igaw beivag anamoun, bweina kusek kan beikam. Kukin beivag anadak, bweina kukil soup kusek beimoum, mo beivag anmwasin. ");
INSERT INTO myw_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Awoum sinap kalbaleb bitakayway wasigeis yakamiy, tage beibwein amisinap va̱gan bukutakayways waseg sinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kadiloka ya̱kids bitatams tasiyas gabman sikaleiwag waseg. Asibabaw-wan Yowbad bo isekes sikaleiwag. Anmwa̱net Yowbad kaleiwag isekes gamag. ");
INSERT INTO myw_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kukin bitapiyev sikaleiwag, mamagina bitapiyev Yowbad nawotet; igaw mo bikatimop adsinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Tasiyas asisinap bwein nag biwenes tasiyas takaleiwags; nag. Tage takalbalebs biwenes. Kadiloka beibwein amisinap, mo takaleiwag bikalin nuwan yakamiy, va̱gan bikavasimiy. Nag bukuwenes, nag. ");
INSERT INTO myw_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Yowbad bo isek inakaleiwag towen va̱gan bilabeim. Tage kukin beivag amsinap kalbaleb mo bukuwen. Nakaleiwag nises va̱gan beiweiy gamag. Mtowen Yowbad natouwat va̱gan beiweiys tasiyas takalbalebs. ");
INSERT INTO myw_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Kadiloka bitakanaway gabman sikaleiwag. Kukin gog nag, Yowbad mo bikawkuneid. E, kadiloka bitakanawes. ");
INSERT INTO myw_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kadiloka-vak bukupa̱yins gabman waseg. Takaleiwags tasiyas itoukums Yowbad nawotet pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Kutams asibabaw wasigeis. Kupa̱yins wasigeis tasiyas takaweins pa̱yin. Sita̱kis kusekes tasiyas takaweins ta̱kis. Kugoulus tasiyas guyawaw, o kuvna̱ses tammwayas. ");
INSERT INTO myw_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Awoum kukwawlavags wasigeis gamag mwasanin. Misinaka bukusiwa̱youbs simiyas wasigeis. Bitasiwa̱youb mo bitakanow Moses nakaleiwag bitayakous. ");
INSERT INTO myw_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Livan avakaein nises mamagina: “Kuvnas soum ma̱wana kuvna̱seim tatoneim.” E, wanuwan livan towen kaleiwag babaw nisesus, mamagina: “Awoum kusubwan, awoum kuweiy gamag, awoum kuveinaw, awoum matam bimwamon soum navavag.” ");
INSERT INTO myw_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Towen tasiwa̱youb bivna̱ses siney, nag biyagages, nag. Kukin bitasiwa̱youbs mo bitakanawes Moses nakaleiwag bitayakous. ");
INSERT INTO myw_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","E, kuva̱ges ma̱wan, peinan kukwakins datuts bo talivatus. Kadiloka kwannakons tut towen. Kweiboug nitasimounids, tage datuts bo ikous. Yowbad kakita bikatinabweids. ");
INSERT INTO myw_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Boug bo ikous. Kakita beiyam. Kadiloka bitapiyaves dadub sinapun, bitakawes kamnat youdanen va̱gan bitakanaviys waseg sinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Kadiloka bitavna̱ses adsinaps beibwein, mamagina kamnat gimgeilin ya̱kids. Awoum bitamwamoums wiskiy o aveiyag mo bitakabala̱weins. Awoum bitakaninavays mav. Awoum bitakavikuns o bitakamnimans, awoum. ");
INSERT INTO myw_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kadiloka kukwawes daGuyaws Yeisuw Kelis ansinap. Tage awoum kutams waseg woumiy nakaleiwag, aveiyag sivinan, awoum. ");
INSERT INTO myw_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Gamag mwasanin isimounids, tage nag isimounids bwein waseg Kelis; kadiloka kutams amibwabwal tasiyas, tage awoum kwamnimans simiyas amibwabwal tasiyas, awoum kuyakeikays livan wasigeis. Awoum. ");
INSERT INTO myw_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Teitan gamag ilana, “Bweina bitakam kan babaw.” Tayuwein mamagina tougwey ipiyev viniyon, ilana, “Nag kadilok bitakams.” ");
INSERT INTO myw_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Towen takamkwam awoum bikasigum son, peinan ipiyev viniyon. Towen-vak tapiyevein viniyon awoum bilana, “O takalbaleb towen peinan ikam viniyon.” Yowbad bo ikalin nuwan gamag towen; awoum kuvtokays livan. ");
INSERT INTO myw_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Yakamiy awoum kuyages mtowen, teitan gamag natouwat towen. Natovek tatonen bikaleiwag. Kukin natovek bikalin nuwan, bikimtuw mo bisesuna bwein; kukin gog nag, mo bikalouw. ");
INSERT INTO myw_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Teitan gamag ivnas yam mwasanin, tayuwein gog idoki yam babaw katanok-wan. Gamag nanon tatonena bikaleiwag mo bivag ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kukin kal bivnas yam mwasanin, ivnas peinan igoul daGuyaws waseg. Kukin kal bikamkwam, ikam peinan igoul daGuyaws, ikalin nuwan waseg; kukin kal ipiyev kan, ipiyev peinan igoul daGuyaws, ikalin nuwan waseg. ");
INSERT INTO myw_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nag bitamov silma̱nin tatoneid. Nag bitakanig silma̱nin tatoneid. ");
INSERT INTO myw_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Igaw bitamov, silma̱nin daGuyaws mo bitamov. Igaw bitamat, silma̱nin daGuyaws bitamat. Peinan daGuyaws angamag ya̱kids; takinew bitamov o takinew bitamat. ");
INSERT INTO myw_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kelis nawotet ma̱wan. Bo ikanig mo imov vayuwein va̱gan biguyaw wasigeis sidayas takanigs o wasigeis ya̱kids tamwamovs. ");
INSERT INTO myw_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kukin bwadam ansinap kweitan, awoum kulana, “Takalbaleb towen.” Awoum kuyeg, awoum! Igaw ya̱kids babaw mo bitatamanaws wamatan Kelis va̱gan bikatkineids. ");
INSERT INTO myw_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Liva̱nen nises mamagina: “DaGuyaws ilana, ‘Peinan yey tamwamov yey, gamag babaw bikululs wamatag. E, babaw gamag wudous waseg mo bikavasigs yey Yowbad.’” ");
INSERT INTO myw_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","E, Yowbad bikatiga̱neids mo liva̱neids bitasekes, aveiyag bwein, o aveiyag kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Yowbad tonena bikatukin. Awoum ya̱kid bitalivan, talana, “Towen ansinap kalbaleb,” awoum. Tage kadiloka taninuway adsinap tatoneid. Awoum ge sod bikineid bidok adsinap kalbaleb, mo bigeg nanon. ");
INSERT INTO myw_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Yey akakin-wan nag kweitan aveiyag bwaboum. DaGuyaws Yeisuw nikatimlakeig mo akakin nag kweitan aveiyag bwaboum. Tage kukin kal bidok aveiyag bwaboum, mounida bouman gamag towen. ");
INSERT INTO myw_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kukin soum idoki kweitan kan bwaboum mo bukukwam kan towen, soum bikineim nukukwam mo bigeg nanon mtowen. Adok bo kupiyev siwa̱youb waseg soum. Kelis nikanig peinan soum. Awoum kam soum biyageg. ");
INSERT INTO myw_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Kan towen bwein-wan peinam yak, tage awoum kukwam, ma̱wan gamag mwasanin mo biyageims. ");
INSERT INTO myw_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Yowbad nakaleiwag nag silma̱nin kan o soup, tage sinap didumwal, niwal, mwa̱saw. Yowbad Kululuwan waseg bo ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ma̱wan bitakanow aygan Kelis, Yowbad bo beitam waseg ya̱kid, o gamag mo bikalin nuwes wasigeis ya̱kid. ");
INSERT INTO myw_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Kadiloka bitayousis sinap tasiyas silma̱nin niwal va̱gan bitalabes sidayas. ");
INSERT INTO myw_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Awoum kugulek Yowbad nawotet peinan kam. Mounid kan babaw bwein. Tage awoum aveiyag bitakam mo bigeg nanon sod. ");
INSERT INTO myw_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Aw-viniyon o avei-soup tawtoun o aveiyag sod bikineid waseg, bo bigeg nanon, bweina bitapiyev youd tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ya̱koum kudok youd tasiyas bwanabwein o Yowbad ikakin nanoum. Kukin nag bukuygeg sod wasigeis youd tasiyas, mo bukumwa̱saw. ");
INSERT INTO myw_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kukin gog bisisiyuw nanoud mo bitakam, Yowbad igaw bikamta̱nid, peinan nag tasimounid bwein. Adsinaps kalbaleb peinan nag tasimounids bwein. ");
INSERT INTO myw_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ya̱kids magat bitasimounids bwein, kadiloka bitalabes tasiyas tougweys. Awoum ya̱kids nanoud tatoneids bitavag. ");
INSERT INTO myw_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Tatanok tatanok ya̱kids kadiloka bitalabes sidayas, aveiyag sivines va̱gan bikatimweisis asisinap beibwein. ");
INSERT INTO myw_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kelis-vak nag tatonena nanon iwtel, nag. Liva̱nen Bukitab waseg nises, peinan idibek Yowbad mamagina: “Peinan ivtokeims livan mamagina bo iyagageigs yey.” ");
INSERT INTO myw_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Bukitab anilivan tasiyas nileles kweiboug-o. Bo ileles va̱gan bikatimlakeids, mo bitakaptuleids, o livan towen biguyeids mo bitanamis Yowbad waseg. ");
INSERT INTO myw_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Yowbad waseg kapatul nises son geiguy. Sivinag Yowbad bilabeimiy mo bukumsamwas simsimiyas singay bwein, ma̱wan Yeisuw Kelis nanon. ");
INSERT INTO myw_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","E, mo beivag ninoumiy katanok o amilivan katanok, waseg bukuyakawanes Yowbad, mtowen daGuyaws Yeisuw Kelis taman. ");
INSERT INTO myw_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kadiloka bukuta̱meimiy simsimiyas amibwabwal yakamiy, ma̱wan Kelis nita̱meimiy, yakawanan Yowbad silma̱nin. ");
INSERT INTO myw_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","9","Adibakeimiy mamagina: Kelis bo imlavag min-Yudiy sitouwat, peinan Yowbad nilivnek mounid wasigeis tammwayas, ilana, “Igaw mo baw balabeimiy o balabes tobwag ven gimgilis peinan inok nuwag tasiyas.” E, tasiyas mo biyakawanes Yowbad. Liva̱nen nises Bukitab waseg mamagina: “Mapuna bakakavasim sigwayas tobwag ven gimgilis, o yagan waseg bakanuwel.” ");
INSERT INTO myw_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Kweitan livan nises mamagina: “Kumwa̱saws tobwag ven gimgilis yakamiy, simiyas Yowbad inagamag.” ");
INSERT INTO myw_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Kweitan livan-vak: “Kukwavasis daGuyaws, tobwag ven gimgilis yakamiy. E, kadiloka gamag babaw bikavasis.” ");
INSERT INTO myw_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaya anilivan-vak mamagina: “Yeisuw delen igaw mo beim, mtowen bitamanaw bikaleiwag tobwag ven gimgilis wasigeis. E, tasiyas mo binnamis waseg.” ");
INSERT INTO myw_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nitannamis waseg Yowbad. Ivag sivinag bukusimounids waseg, va̱gan namis bivakaein wasigeis yakamiy mo beitaw nuwamiy o bukumwa̱saws. E, Kululuwan Towen Bwanabwein bikatimweis minamis singay bivakaein. ");
INSERT INTO myw_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Sigwey yakamiy, mounid akakin amisinap bwein, tawtoun, o kadilokeimiy sinap kwatimlakes simiyas. ");
INSERT INTO myw_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","16","Tage agulivan tawtoun mwasanin bo alel wamilet towen waseg, va̱gan bukuninuways. Yowbad bo isiwyoubug va̱gan bakokew sinapun Yeisuw Kelis banuwakes ven babaw gimgilis wasigeis. Gunawotet ma̱wana tanuwagan lun, akokew Yowbad anilivan bwanabwein assekeimiy ven babaw gimgilis yakamiy, bukumlavags ma̱wan lun bulukwan. E, Yowbad mo bikalin nuwan wasigeis yakamiy, peinan Kululuwan Bwanabwein biwekeimiy mo bukwamnats. ");
INSERT INTO myw_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Yeisuw Kelis waseg yey, gunawotet towen silma̱nin Yowbad. Kadiloka beimwan woug peinan. ");
INSERT INTO myw_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","19","Agulivan bitawtoun sinap katanok waseg. Nag kwayuwein livan bakaypom. Misinaka Kelis iwotet waseg yey mo ven babaw gimgilis itams waseg, isimounids waseg o ikanawes aygan. Kelis nilabeig natawtoun waseg, mo ageiguy o awotet tawtoun, mamagina naman mulin Yowbad, o Yowbad kululuwan ikimtuweig. E, Kelis waseg yey, gunawotet bo ageiguy liva̱nen Yeisuw vena babaw ikous. Asilamaw Yelusalem, aninoun ven babaw ee... Ililikam. Ma̱yum yay. ");
INSERT INTO myw_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Peinan nanoug bo ma̱wan. Awoum bageiguy ven tasiyas ikakins Kelis liva̱nen. Kadiveiyov ven wasigeis bo ageiguy. Kukin teitan gamag bikelay kakol, awoum yey wululay basen wakunuwatan. Awoum ban ageiguy ven tasiyas bo ikakins. ");
INSERT INTO myw_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Liva̱nen gunawotet nises Bukitab waseg, mamagina: “Liva̱nen towen nag kal idibakes, tage bikines mo bikakins.” ");
INSERT INTO myw_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Gunawotet ven tasiyas wasigeis singay babaw. Ta-ma̱wan baw bakineimiy. ");
INSERT INTO myw_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Bweilim babaw nein wankuyeim sivinag baw, bo nag. Tage tut towen gunawotet bo ayakous ven tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Igaw bakilev ban Spein wanamugwa ba̱lug wamiven bakineimiy, bitamsamwas sigwey yakamiy tut kayakus waseg, mo kutaneigs ba̱kuk ban Spein. ");
INSERT INTO myw_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Nagein gog ga banow muloul silma̱nin tasiyas tayakelesiys ven Yelusalem. ");
INSERT INTO myw_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","27","Tasiyas min-Masidoniy sisiyas min-Akay sivines, mo imulouls pines tasiyas tasimavs tayakelesiys nisesus Yelusalem. Peinan ninous ma̱wan. E, kadiloka bimulouls wasigeis min-Yelusalem peinan min-Yudiy yakamey nakakow liva̱nen Kelis nakasekes ven babaw gimgilis, va̱gan bimwa̱saws. E, kadiloka ven babaw gimgilis bilabes tasiyas simoney waseg. ");
INSERT INTO myw_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","E, bakow simuloul towen, banow basekes, mo baw balakwaneimiy beikous, mo bakilev ban Spein. ");
INSERT INTO myw_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Yey akakin igaw mo baw waseg Kelis nasiwa̱youb avakaein mo bitamwa̱saws sigwey yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","31","Aguyeimiy sigwey, daGuyaws Yeisuw Kelis waseg, o Kululuwan nasiwa̱youb waseg, kadiloka bitatawtouns sigwey yakamiy, bitannitougs waseg Yowbad. E, sigwey, kunitougs peinag, va̱gan Yowbad bikatinabweig. Peinan min-Yudiy tasiyas tapiyavein Kelis sivines kid biyagageigs. E, kunitougs peinag va̱gan tasiyas tayakelesiys Yelusalem mo bikalin nuwes waseg muloul towen; awoum ge bipiyaves. ");
INSERT INTO myw_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","E, kuntougis Yowbad bikaliyow gunaked mo baw, mwa̱saw waseg. Magat Yowbad nanon ma̱wan mo beibwein amnag sigwey yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","DaYowbads waseg niwal nises. Mtowen simiy yakamiy mo beitaw nuwamiy. Eimen. ");
INSERT INTO myw_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","2","Kalin nuwag nadeits Pibiy, peinan ililabes tayakelesiys ven Kenikil waseg. Igaw tutan beiw, kadiloka kutams vin mana̱wen waseg, kuvkakes amibwabwal, peinan numit daGuyaws waseg; o tayakelesiys babaw bweina kutams waseg. E, kadiloka kulabes mana̱wen Pibiy, kukin aveiyag sivinan. Peinan bo nilabem sigwayas babaw gamag. ");
INSERT INTO myw_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kumulouls wasigeis tasiyas Piliskil son Akwil. Sigwey tasiyas nakawtel Yeisuw Kelis nawotet. ");
INSERT INTO myw_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Igaw kweiboug tasiyas takamliweigs idokes kid beiweigs, siyas gog son nakwav ilivatus kalbaleb, peinan ikayuseigs. E, kalin nuwem tasiyas, sigwayas tayakelesiys vena babaw waseg. ");
INSERT INTO myw_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Kumulouls simiyas tasiyas tayakelesiys wasibunatum. Kumulouls simiy Epinet. Singay apwa̱kit waseg taw towen. Ven Esiy waseg mtowen iginsimounid waseg Kelis. ");
INSERT INTO myw_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Kumulouls simiy Meliy. Singay itoukum inawotet pinamiy yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Kumulouls simiyas tasiyas talwog Andlonikus son Duniy. Kweiboug sigwey tasiyas nakases wa̱deil. Buluges avakaein wasigeis takaweins liva̱nen Kelis. Kweiboug iginsimounids tasiyas; yey wankuyeim. ");
INSERT INTO myw_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Kumulouls simiy Ampiliy. Singay apwa̱kit waseg daGuyaws angamag towen. ");
INSERT INTO myw_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kumulouls simiy Uliban, sods mtowen tawteles Kelis nawotet. Kumulouls simiy Sitakiys. Apwa̱kit waseg taw towen. ");
INSERT INTO myw_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Kumulouls simiy Apeles, Kelis angamag mounid towen. Kumulouls simiyas tasiyas Alistobulus taliven. ");
INSERT INTO myw_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Kumulouls simiy veiyoug towen Elodiyan. Kumulouls simiyas Kelis angamag tasiyas nisesus Nalisis wanbunatum. ");
INSERT INTO myw_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Kumulouls simiyas tawteleins daGuyaws inawotet tasiyas asteiy Tilipen son Tilipos. Kumulouls simiy Pelisis; taw towen bwanabwein singay itoukum daGuyaws nawotet waseg. ");
INSERT INTO myw_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Kumulouls simiy Lup. Bo itawtoun daGuyaws nawotet waseg. Kumulouls simiy Lup inan, mamagina yey inag. ");
INSERT INTO myw_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Kumulouls simiyas tasiyas Asinkilit, Pilegon, Emas, Patlobas, Emes, sisiyas tawlisiyas nisesus. ");
INSERT INTO myw_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Kumulouls simiyas tasiyas Pilologus, Duliy, Nelewas son nunet, sisiy Olimpas, sisiyas tayakelesiys babaw sisiyas nisesus. ");
INSERT INTO myw_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Kumulouls beibwein wasigeis simsimiyas, peinan daGuyaws angamag yakamiy, Kelis natayakelesiys ven katanok katanok asilivan siwa̱youb wasigeis yakamey. ");
INSERT INTO myw_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Aguyeimiy sigwey, kukinbunikes tasiyas kalisiy iva̱ges moumouvit o ablivis wamibod yakamiy, peinan isilbwades sinap towen nakakamtilakeimiy. Kadiloka kusina̱les tasiyas. ");
INSERT INTO myw_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Gamag kalisiy asisinap ma̱wan, nag ikanawes aygan daGuyaws Kelis. Asivikey ikalawages tatineis. Kamnag asilivan mo ikatidavis tasiyas nag imatuw ninous. ");
INSERT INTO myw_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Gamag babaw ikakins amisinap, peinan kukwanawes daGuyaws aygan. Mapuna amwa̱saw waseg. Sivinag bukukwakins aw-sinap bwein o bukutaguwa̱wes sinap kalbaleb. ");
INSERT INTO myw_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","E, daYowbads nuwanaw mo bigulek Seitan nakaleiwag, bukuvans waseg, mo beitaw nuwamiy. Sivinag daGuyaws Yeisuw Kelis bisiwyoubumiy. ");
INSERT INTO myw_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotiy, soug yey nakawotet. Mtowen anilivan siwa̱youb wasigeis yakamiy. Tasiyas-vak Lukiyos son Yeson sisiy veiyoug towen Sosipat, tasiyas ikalin nuwes yakamiy. ");
INSERT INTO myw_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Yey Talitus bo alel Pawl inalet mwaynawen; agulivan siwa̱youb wasigeis yakamiy, daGuyaws angamag yakamiy o yey. ");
INSERT INTO myw_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Mtowen Gayus amatouwos sigwey tayekelesiys babaw, anilivan siwa̱youb wasigeis yakamiy. Ila̱sit tamtakavatein money ven towen avakaein waseg, son Kwalitus asilivan ma̱wan. ");
INSERT INTO myw_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","(-) ");
INSERT INTO myw_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","26","Yowbad kadiloka bikimtuweimeiy ma̱wan agulivan bwanabwein naguyeimey waseg. Livan towen liva̱nen Yeisuw Kelis. Kweiboug ansinap towen nisowum tut singay kadiveiyov ee... nagein gog bo ikamat, o tasiyas palopit kweiboug wasiven ileles, tage ven babaw nag ikakins; nagein gog mo ikakins. O Yowbad tut babaw nises o inakaleiwag va̱gan babaw gamag nagein mo bisimounids o bitoukums waseg Kelis. ");
INSERT INTO myw_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yowbad anmwa̱net tassinap. Natun Yeisuw Kelis bilabeids mo bitayakawanes Yowbad tut nag beikous. Eimen. ");
INSERT INTO myw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","3","Yey Pawl, gunawotet akokew liva̱nen Yeisuw Kelis, peinan Yowbad nakaleiwag ma̱wan. Soug bwadag Sosten nilabeig let towen waseg va̱gan bukuvinis, Yowbad nayakelesiy yakamiy Kolinit waseg. Yeisuw Kelis waseg bo ikayuseimiy, mo nukumlavags angamag bwanabwein, simiyas ven babaw gimgilis, kalisiy nikavtagis yagan siGuyaw Yeisuw Kelis; mtowen daGuyaws babaw ya̱kids. E, daGuyaws towen son Tamads bisiwyoubumiy mo beitaw nuwamiy. ");
INSERT INTO myw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","7","Tut babaw bo ikalin nuwag Yowbad, peinan isiwyoubumiy yakamiy, Yeisuw Kelis waseg. Youda babaw nisekeimiy, va̱gan bukukwakins o bukulivans sinap mounid waseg. Yakamiy wasigeis bo ikamat liva̱nen Yeisuw Kelis, ma̱wan nalivan. Nag kweitan navagein Yowbad ika̱bwag wasigeis yakamiy, nag. Mikasis bwein-wan, tut towen nitakayamats daGuyaws Yeisuw Kelis igaw beiyum beim ven watinow. ");
INSERT INTO myw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","9","Yam babaw Yeisuw imtakavateids, o tut wanakougwaw ma̱wan ee... igaw daGuyaws beiyum beim igawa tadidumwals ya̱kids. Yowbad tonen bo idaweids va̱gan bitamsamwas sods daGuyaws Yeisuw Kelis, mtowen natun. E, ansinap Yowbad mounid-wan. ");
INSERT INTO myw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Sivinag baguyeimiy budag yakamiy va̱gan kid beivag ninoumiy katanok-wan. Alivan daGuyaws Yeisuw yagan waseg, awoum kutawleyeimiy. Awoum beivag bod babaw. Awoum! Kadilokena ninoumiy bila̱tan simsimiyas wasigeis, amilivan bimlavag katanok-wan. ");
INSERT INTO myw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","15","Kilow nagamag mwasanin bo ika̱mats waseg yey, idibakeigs liva̱nen mikamniman yakamiy, peinan teitan yakamiy bilana, “Yey Pawl nagamag yey”; teitan yakamiy bilana, “Yey Apolos nagamag yey”; teitan yakamiy bilana, “Yey Pita nagamag yey”; teitan yakamiy bilana “Yey Kelis nagamag yey”; mamagin bo kulakes Kelis, va̱gan kid bibabaw. O budag yakamiy, tabta beiweigs yey Pawl waklos pinamiy? Adok nag. Tabta wayagag yey nibapta̱yseimiy yakamiy? Adok nag. Bo ibwein nanoug peinan nag abapta̱yseimiy yakamiy. Misinak abapta̱yses asteiy Kalisip son Gayus. Magat babaptayseimiy, adok bukulivans, “Bo ibapta̱ysem Pawl, wayagan tonen waseg.” Awoum bukulivans ma̱wan. ");
INSERT INTO myw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","O mounid, bo anuw, abapta̱yses Stepan sen nagamag. Adok misinak tasiyas. ");
INSERT INTO myw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Peinan wawun gunawotet Kelis nisekeig nag babapta̱yseimiy, misinaka basekeimiy anilivan bwanabwein. Kukin bageiguy sinapun ven watinow, liva̱nen Yeisuw neiweiys waklos nag bileb gamag, nag. Awoum bageiguy sinapun ven watinow. ");
INSERT INTO myw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","19","Liva̱nen Kelis neiweiys waklos; gamag tasiyas ikanka̱nigs idokes livan makaw; ya̱kids gog, peinan Yowbad ikatinabweids, takakinsa Yowbad natawtoun nises waseg livan towen. Yowbad anilivan nises Bukitab waseg mamagina: “Tassinaps asisinap bo bagulek. Babob asilivan tasiyas.” ");
INSERT INTO myw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Aveiyag biva̱ges tasiyas tassinaps? Aveiyag biva̱ges tasiyas tamtakavateins kaleiwag? Aveiyag bivag talliwon? Adok nag aveiyag biva̱ges tasiyas. Bitakines Yowbad ansinap tawtoun, mo takakins sinapun ven watinow nag aveiyag bivag. Makaw-wan. ");
INSERT INTO myw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Asisinap waseg, ven watinow gimgilis nag bikakins Yowbad, nag. Yowbad nanon bo bikatinabwes tasiyas nisimounids anilivan waseg. Ven watinow gimgilis idokes livan towen livan makaw. Yowbad nakaleiwag ma̱wan. Bwein-wan ansinap towen. ");
INSERT INTO myw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","24","Peinan min-Yudiy sivines bikines naman mulin Yowbad, o mina-Gilis inineivs asisinap; o ya̱kids talivans liva̱nen Kelis neiweiys waklos; min-Yudiy gog ikasigumis livan towen, o ven babaw gimgilis idokes livan makaw; tage ya̱kids kalisiy Yowbad nidaweids, tasimounids livan towen waseg, takinew min-Yudiy yakamey o takinew mina-Gilis yakamiy; ya̱kidsa babaw takakins Yeisuw Kelis, peinan Yowbad natawtoun waseg Yeisuw, o Yowbad ansinap waseg Yeisuw. ");
INSERT INTO myw_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Yowbad kadilok bitakayway gamag wasigeis, gagab-wa