﻿USE sofia;
DROP TABLE IF EXISTS sofia.myu_vpl;
CREATE TABLE myu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES myu_vpl WRITE;
INSERT INTO myu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kuyjeayũ Jesus Cristo diwatwat. Ixe Jesus tiwat ijop'in ma Davi dak, Abraão dak. Ixe Davi Abraão naxeg̃ebit osunuy. Kuyjeayũ osodop ip. Tobuyũ osodop ip. Ite diwatwat ma. Ibũrũ ma osodop ip: ");
INSERT INTO myu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaque ebay Abraão osunuy. Jacó ebay Isaque o'e. Judá ebay Jacó osunuy―Judá kitpiyũ ebay dak. ");
INSERT INTO myu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Peres ebay Judá osunuy, Zera ebay dak. Ixi Tamar osunuy. Esrom ebay Peres osunuy, Zera ebay dak. Ixi Tamar osunuy. Esrom ebay Peres osunuy. Arão ebay Esrom osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadabe ebay Arão osunuy. Nasom ebay Aminadabe osunuy. Salmom ebay Nasom osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boaz ebay Salmom osunuy. Raabe Boaz xi osunuy. Obede ebay Boaz osunuy. Obede xi Rute osunuy. Jessé ebay Obede osunuy. Imẽn o'e. 14 em osodop―14 gerações osodop. ");
INSERT INTO myu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Davi ebay Jessé osunuy―kuyibit kukukat ebay. Salomão eba y Davi osunuy. Urias tayxibuk Salomão xi osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboão ebay Salomão osunuy. Abias ebay Roboão osunuy. Asa ebay Abias osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafá ebay Asa osunuy. Jorão ebay Josafá osunuy. Uzias ebay Jorão osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotão ebay Uzias osunuy. Acaz ebay Jotão osunuy. Ezequias ebay Acaz osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manassés ebay Ezequias osunuy. Amom ebay Manassés osunuy. Josias ebay Amom osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconias ebay Josias o'e, Jeconias kitpiyũ ebay dak. Imẽn Josias o'e, itakomaayũ Israel naxeg̃ebitbit tujowatwan pima Babilônia eipi be. Imẽn o'e dak. Wara'at 14 em osodop―14 gerações osodop. ");
INSERT INTO myu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tujowat puje, Salatiel ebay ixe Jeconias osunuy. Zorobabel ebay Salatiel osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiúde ebay Zorobabel osunuy. Eliaquim ebay Abiúde osunuy. Azor ebay Eliaquim osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadoque ebay Azor osunuy. Aquim ebay Sadoque osunuy. Eliúde ebay Aquim osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar ebay Eliúde osunuy. Matã ebay Eleazar osunuy. Jacó ebay Matã osunuy. ");
INSERT INTO myu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","17","José Maria itop osunuy. Jacó Maria itop ebay osunuy. Jesus Maria'it osunuy. Cristo i ibutet, ixe Jesus putet. Imẽn o'e dak. Warara'at 14 em osodop―14 gerações osodop. Ibũrũ ma Jesus tobuyũ. ");
INSERT INTO myu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Cristo kapap. Jesus xi José wadip osunuy. Maria i ibutet osunuy. Yukreg̃ o'e, jewebumũn awap. Deus biõg̃buk o'g̃u'ukreg̃. ");
INSERT INTO myu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yukreg̃ puje, José iboam itaybit o'e. Icẽmat osunuy José. Maria musũsũn pin g̃u osunuy ibaripyũ etabun. Imẽnpuye José ibu'u osunuy jewebumũn. Iba'arẽm suiwat ojuy. ");
INSERT INTO myu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","José bit ijop i'e pin pima, Deus ekawẽn tojotjot'ukat ma oajẽm José kay, jexeyxey bima. — José! — io'e. — Davi diwacat ẽn! Epararam g̃u juy Maria eju jewebumũn ãm―ewadip eju. Deus biõg̃buk Xipan o'g̃u'ukreg̃. ");
INSERT INTO myu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I'it je'kap―ag̃okatkat'it'it. Ibuten Jesus i esubutetmõg̃. I'it puten. Judeuyũ bewi ikẽrẽat ju'uk je'e ipiat'ajoap puxim — io'e―Deus ekawẽn tojotjot'ukat o'e José be. ");
INSERT INTO myu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Soat ijop o'jebapuk. Deus o'e jekawẽn muwẽnuwẽn'ukayũ be iap tag̃ o'jebapuk. ");
INSERT INTO myu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Imẽn ixe o'e apẽn Deus o'e iap tag̃: Eya'õpicũg̃cũg̃ cuy epesop. Ayacat yukreg̃ je'e. Ayacat i'it je'kap. Ag̃okatkan je'e. Yaypan'isuat je'it g̃ukap. Emanuel i ibuten je'e, i. (Emanuel o'e Deus omuy wuyweju.) ");
INSERT INTO myu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jewurũg̃ puje, José o'e soat Deus ekawẽn tojotjot'ukato'e cebe. Deus ekawẽn tag̃ José o'jewebumũn Maria eju. ");
INSERT INTO myu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","I'it kap awap, o'jepo g̃u buk ceweju. Maria'it o'subutetmõg̃ Jesus i, ikap puje. ");
INSERT INTO myu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O'kap Jesus Belém ka be, Judéia eipi be. G̃ebuje itaybit cĩcãayũ oajẽm Jerusalém ka kay. Kasopta jujuap itaybit cĩcã ip. Herodes Judeuyũ kukuk'ukat pima, oajẽm ip. Kaxijẽmap eipi bewi oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","— Poce bekicat omuy? — io'e ip. — Xeku Judeuyũ kukuk'ukan em―ixe bekicat. Kasopta ocetajojo oceka be―kaxijẽmap eipi be. Tawaru ma o'jedaebapuk. Imẽnpuye ocetaybit bekicat o'kap iam. Ya'õbacaat xeku. Ocajẽm ixe mubuyxi am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Imẽnpuye Herodes yag̃uybabi'ũm o'e, Jerusalém ka watwat tak. ");
INSERT INTO myu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Judeuyũ epaĩyũ kukukayũ o'tomuwã Herodes. Moisés ekawẽn imutaybitbin'ukayũ dak o'tomuwã ixe. O'je'awero ip Herodes kay. — Poce Deus emunaẽ je'kap? — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","— Belém ka be, Judéia eipi be — io'e ip Herodes pe. — Imẽn Deus ekawẽn muwẽnuwẽn'ukat kuy tupmubararag̃ o'e―Deus ekawẽntup. ");
INSERT INTO myu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Kuy o'e: Belém ka bewi eykukukat omuyku―Judá eipi bewi. Imẽnpuye iboceayũ je'e iboap ika mubog̃ubog̃. Eykukukat Israel naxeg̃ebitbit mujujum je'e. Imẽnpuye ikabog̃ je'e iboka, i. Imẽn Deus ekawẽn muwẽnuwẽn'ukat kuy tupmubararag̃ o'e―Deus ekawẽntup — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","G̃ebuje Herodes itaybit cĩcãayũ o'tomuwã―kaxijẽmap eipi bewiayũ. Iba'arẽm o'tomuwã. Oajẽm ip, o'tomuwã buye. — Puju ixe kasopta o'jedaebapuk kabi be―eyeipi be? — i big̃ ma o'e―Herodes o'e. Kasopta muwẽnuwẽn o'e ip Herodes eju. ");
INSERT INTO myu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","— Epeju Belém ka kay — Herodes o'e cebe ip. — Bekicat kudadam cĩcã epeju. Tobuxik puje, ixe awẽg̃ cuy epeyawẽg̃muwẽn owebe, owebe ijo am, ixe mubuyxin am — Herodes o'e itaybit cĩcãayũ be. Herodes pit bekicat mubuyxin ojuy g̃u. ");
INSERT INTO myu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Herodes ekawẽn co buje, o'jẽm ip. Belém ka kay o'ju ip. Cucum pima, kasopta o'ju cewap ip. Icokcok cĩcã ip o'e waram, tajojom puye. Cum. Cum. Cum. O'jedaecũ. Bekicat tuk'a ase o'jedaecũ. ");
INSERT INTO myu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oajẽm ip uk'a kay. Oõm ip. G̃ebuje bekicat o'jojojo ip. Ixi eju osunuy bekicat―Maria eju. O'jẽg̃'aecõg̃cõg̃ ip bekicat topabe, imubuyxin am. Jebubut mũn'a o'yadomudip'uk ip. Ibubun o'g̃ũm ip Maria be. Ouro o'g̃ũm ip. Darut'a o'yaũm ip. Tade'oatup o'tupũm ip―mirradup. Soat o'g̃ũm ip bekicat peam. ");
INSERT INTO myu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Xet. O'jexeyxey ip, jexet pima. — Epeyepit g̃u juy Herodes kay — Deus o'e cexey bi. Imẽnpuye o'jepit ip jeipi kay wara'at e dag̃wi ma. ");
INSERT INTO myu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Itaybit cĩcãayũ ijẽm puje, Deus ekawẽn tojotjot'ukat o'jebapuk José kay―Maria itop kay. Ixet pima, jexey bi o'jebapuk. O'jekawẽn José eju. — Ecenapõn cuy Egito eipi kay — io'e José be. — Bekicat etujupa'um, ixi dak. Bomaku epesop cuy — i'e'em cebe. — Ajẽm puje, epesop cuy Egito eipi be, Herodes bekicat kudadam puye. Ixe kudadam je'e yaokam — io'e José be. — Emukuyjo buje, epeju juy Egito eipi bewi — io'e Deus ekawẽn tojotjot'ukat. — Hm hm — José o'e. ");
INSERT INTO myu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","O'jenapõn. Egito eipi kay o'ju ip. Bekicat o'tujupa'um ixima dag̃, ixi dak. ");
INSERT INTO myu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Oajẽm ip. Osodop ip Egito eipi be Herodes itait pima, osodop ip. Ce'ũ buje, o'jepit ip jeka be. Deus ekawẽn muwẽnuwẽn'ukat cuk adi o'jekawẽn kuyjeayũ be. Egito eipi bewi okpot otomuwã, i juk o'e Deus, io'e. Imẽn Deus o'e. Ipot muwẽnuwẽn o'e. Jesus muwẽnuwẽn o'e. José itait pima, Deus ja'õ mucũg̃ ãm o'g̃ug̃ẽ. ");
INSERT INTO myu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wara'at e dag̃ itaybit cĩcãayũ epit puje, Herodes itaybit o'e jemug̃uykuku iam. Cekay ip itakoma jĩjã o'e. Te'e ma o'e. Kuy bima kasopta o'jedaebapuk―xepxep koato bima. Iboam osunuy itaybit Herodes. Imẽnpuye jebekitkit o'g̃uju xepxep koatoayũ yaokam, pũg̃ koatoayũ dak yaokam. Kap'isuat tak ip o'yaokaka. O'g̃uju Belém ka be―Belém ka tẽg̃ ma dak. ");
INSERT INTO myu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Imẽn Deus tak o'g̃ug̃ẽ. Ja'õ mucũg̃ ãm o'g̃ug̃ẽ. Jeremias kuyje imẽn kawẽnwẽn o'e Deus a'õ dag̃. ");
INSERT INTO myu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kuyje Jeremias o'e: Raquel o'ya'ĩjojo ip―Rama ka beacat. O'tõtõn cĩcã Raquel ya'õberen. Ig̃uycũg̃ cĩcã o'e ixe. Iba'ore iboceayũ be Raquel mucok am. Bekitkit'ũm'ũm kay o'tõtõn. O'tõtõn jenaxeg̃ebitbit oe'ũ'ũ buye, o'g̃uy'ũm puye, i juk o'e Jeremias Deus a'õ dag̃. ");
INSERT INTO myu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes e'ũ buje, Deus ekawẽn tojotjot'ukat waram o'jebapuk José kay. Ixet pima jexey bi o'jebapuk. Egito eipi be o'jebapuk. ");
INSERT INTO myu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","O'jekawẽn José eju. — Kuy oe'ũ ip―bekicat aoka pinayũ — io'e cebe. — Bekicat etujowat, ixi dak. Israel eipi kay epeju juy — io'e José be. — Hm hm — José o'e. ");
INSERT INTO myu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aripit. O'jepit Israel eipi kay. Bekicat o'tujupit, ixi dak. O'jepit ip. ");
INSERT INTO myu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Imẽnpit iparara o'e José Herodes ipot puxim―Arquelau buxim. Judéia eipi kukukan o'e Herodes'ũm tieg̃ Arquelau. José iboam itaybit pima, iparara o'e Judéia eipi be jajẽm am. Galiléia eipi be o'ju ip José jeparara pibun. O'ju ip, waram ma jexeyxey buye. — Eg̃uy g̃u juy Judéia eipi be — Deus o'e José be, jexeyxey bima. ");
INSERT INTO myu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Oajẽm ip Nazaré ka kay. Osodop ip Nazaré ka be, Judéia eipi be. Imẽn Deus ekawẽn muwẽnuwẽn'ukayũ juk o'e ip bekicat muwẽnuwẽn pima. Nazaré ka wat je'bapuk xeku, i. Soat ma apẽn Deus ekawẽn muwẽnuwẽn'ukayũ o'e iap tag̃ o'jebapuk. Imẽnpit soat etabun xipat'ũm cĩcã osodop ip―Nazaré ka wat. ");
INSERT INTO myu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","G̃ebujeat kabia João Batista o'ju. Judéia eipi be o'ju―Jordãodi be―uk'a'ũmat pe. O'ju, Jesus Nazaré ka be bima. Ipi juacat mutaybitbin oeku ixe João. ");
INSERT INTO myu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","— Epeyepere juy ikẽrẽat mug̃ẽg̃ẽap. Deus soat kukanap kabia jajẽm dao ma. Deus a'õbi ijoceyũ muju am jajẽm — io'e ipi juacat pe. ");
INSERT INTO myu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","4","Camelodap mug̃ẽg̃ẽ osunuy João doti. Jekpumũnpu dak ixee mug̃ẽg̃ẽ osunuy. Ixat osunuy arobidadek puximat, eit kog̃ũnpi dag̃ tak. Kuyje Isaías ixe João muwẽnuwẽn o'e Deus a'õbi Israel naxeg̃ebit pe. Ag̃okatkat jewãwãwãm uk'a'ũmat pe, i. Imẽn jewãwãm: “Soat e juy epesuemukacũg̃ wuykukukat ajẽm ãm,” i. “Ie juy epesuemudim ceku am,” i, io'e. Imẽn e'em Isaías emudupmubararaktup. ");
INSERT INTO myu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","G̃ebuje isu ma Jerusalém ka watwat o'ju ip João kay. O'ju João ekawẽn a'ĩjo am. Soat Jordãodi wãbu korerenayũ dak o'ju, Judéia eipi beacat tak. ");
INSERT INTO myu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Soat ip o'jewemubatatisasan Jordãodi be. O'jewemubatisasan João be. O'g̃ubatisasan ixe João. — Deus etabun ikẽrẽat kug̃ oceju. Imẽnpit ikẽrẽat epere pin oce'e. Imẽnpuye ocemubatisasan cuy ece — io'e ip João be. Ijop ekawẽn muwẽnuwẽnayũ o'g̃ubatisasan João. ");
INSERT INTO myu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseuyũ cucum o'e ip jewemubatisasan Jordãodi be. Saduceuyũ dak cucum o'e ip. João o'jekawẽn cebe ip―Fariseuyũ be, Saduceuyũ be dak. — Deus xewi eyenapõn pin, eykay itakoma buye. Eyenapõn pin ikẽrẽat ipi cĩcãat puxixim. Abu jeymukũyjo eyenapõn ãm? — io'e. — Puybu'it'it buxim eyju. Wuye'ũap mubapukatpu buxim eyju — io'e. — Apẽn puybu o'jenapõn wuykat pewi wuykat mupik pima, imẽn tak eyenapõn pin Deus o'supi'ajoiat pewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","— Cũg̃ ma juy epeku soat etabun. Ikẽrẽat cuy epeyepere — io'e. Imẽn soat itaybit e'em ig̃uycũg̃ cĩcã ip ikẽrẽat e'e buye iam, g̃asũ cũg̃ ma je'ku ip iam tak. ");
INSERT INTO myu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","— Tũibe Deus ipiat supi'ajoat g̃u wuywebe, wuyju Abraão naxeg̃ebitbit puye iãn purut eyju e'em — io'e João cebe ip. — Cedag̃ g̃u eyju jewag̃uydadam. Iba'ore g̃u Deus pe wita'a muwexat am Abraão naxeg̃ebitbiyũm, jekay kũyjobitayũm — io'e. ");
INSERT INTO myu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","— G̃axĩn ma o'a kukat jajẽm ya'a'e'ũmat'ip takat am, yop xik am daxa be — io'e. — Ixe buxim Deus tak g̃axĩn ma ipiat supi'ajoat kũyjobit'ũmayũ be, eywebe — João o'e. ");
INSERT INTO myu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","— Wara'acat omuyku onomuju. Ixe obodi ma ya'õbuyxi. Soat podi ma ya'õbaca. Õn pit ajo peg̃ap g̃u cebeam? Cedag̃ g̃u kuka oce ixe a'õbuywatwat'ukan, obog̃ g̃u buye. Õn ma eymubatisasan idibi be. Ixe bit Deus biõg̃buk g̃uõm eywebe, ya'õ dag̃ eyeku am. Apẽn daxa be taixee mupik, imẽn tak Deus biõg̃buk pe ikẽrẽat g̃uy'ũ. ");
INSERT INTO myu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wuyju taixee xikxig̃ tumũntata mujẽm ãm taixee bewi. Tumũntata muxipanpan wuyju tamũn'a be. Taixee mupikpig̃ daxa be. Imẽnpuxim Deus kũyjobicayũ muwajejẽm kũyjobit'ũmayu xewi. Kũyjobicayũ ixe xe jeedop soat em. Kũyjobit'ũmayũ bit soat em ipiat supi'ajojo — João o'e cebe ip―Fariseuyũ be, Saduceuyũ be dak. ");
INSERT INTO myu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus oajẽm Jordãodi be, ixe jemubatisaan João be. João bit ibu'u o'e Jesus mubatisasan. ");
INSERT INTO myu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","— Okay du ejut? — João o'e Jesus pe. — Õn g̃u bit. Ẽn acã juy ece omubatisan — io'e João Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","— G̃asũ ma — io'e João be. — Omubatisasan cuy ece. Imẽn cuy ace, cũg̃ ma wuyeku am Deus etabun. — Xipat — João o'e. O'g̃ubatisan. ");
INSERT INTO myu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Idibi bewi o'jeu Jesus. Kabi ma o'jekoce. Pukaso jo'iat o'jojojo pupum―Ibiõg̃buk xipacat. Jesus kay oajẽm. Oõm Ibiõg̃buk xipacat cebe―Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","G̃ebuje Deus o'jekawẽn kabi bewi. — Ite okpot―wemukukpinput — io'e. — Soat em ocokcok cĩcã cekay — Deus o'e. ");
INSERT INTO myu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","G̃axĩn ma Ibiõg̃buk xipacat Jesus o'tujowat uk'a'ũmat pe. O'tujowat, ibiõg̃buk kẽrẽayũ kukukat pe ibuyxijo am. ");
INSERT INTO myu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uk'a'ũmat pe osunuy Jesus ade kabia―40 kabia. 40 ixima dak osunuy. Jekõnkõn g̃u osunuy. Repi'ajojom cĩcã osunuy. ");
INSERT INTO myu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ibiõg̃buk kẽrẽayũ kukukat oajẽm Jesus kay. — Jesus — io'e. — Deus ipot ẽn pima, a'õbi ma wita'a juy eyamuwexat pão'am, ere jĩjã buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","— Ap! — io'e. — Imẽn e'em Deus ekawẽntup: Wuyetabẽg̃ wuyxat o'om puye g̃u―Deus wuymutaicin puye, i. Wuyju jekukum, Deus a'õbuyxi buye acã, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","G̃ebuje ibiõg̃buk kẽrẽayũ kukukat Jesus o'tujowat Jerusalém ka be, Deus a'õbi ika xipacatka be. Deus eju kawẽnwẽnap'a kay oajẽm ip―yabog̃at'a kay. O'jeu ibo uk'a jeje. Uk'a yaberenat'a o'yadop. O'jomõg̃ ibo uk'abi jeje. ");
INSERT INTO myu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","— Ẽn Deus ipot pima, ecewemuy'at ijop'abi jejewi ipi ju — io'e. — Imẽn e'em Deus ekawentup: Deus ekawẽn tojotjot'ukayũ g̃uju xipan ekuk am, i. Ixeyũ jeak ekay wita'a be ei mucakcakap puxim, i — io'e. — Imẽn e'em Deus ekawẽntup — io'e Satanás. — Deus ekawẽntup tomuju ecewemuy'at — io'e. ");
INSERT INTO myu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","— Ap! — io'e Jesus. “Cẽm paxi Deus ja'õ dag̃ e'em?” i'ũmg̃u juy epe'e, i — io'e Jesus. — Imẽn tak e'em Deus ekawẽntup — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","G̃ebuje ibiõg̃buk kẽrẽayũ kukukat Jesus o'tujowat co'a kay―yaberenat'a kay. Ibocewi soat o'g̃ubapuk Jesus pe. Jebacaap, ipi juacat, ipi juacat muju'ukayũ; soat ip o'jojojo. Idip cĩcã ma osodop ip. Ixe biõg̃buk kẽrẽat kukukat ja'õbuyxi ojuy Jesus pe. Imẽnpuye ixe o'e Jesus pe: — Soat kuka ijop o'g̃ũm ewebe, owap ẽn a'ecũg̃cũg̃ puje, omubuyxin puje dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","— Ap! — io'e Jesus. — Ecenapõn oxewi, Satanás! Deus ekawẽntup e'em: “Xipat ẽn” i juy epe'e Deus pe acã, i. Deus a'õ kay acã epesop kũyjobin―eykukukat a'õ kay, i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Imẽneju o'jenapõn ibiõg̃buk kẽrẽayũ kukukat Jesus xewi. Deus ekawẽn tojotjot'ukayũ oajẽm ip Jesus buywat am g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Itaybicayũ Jesus pe o'g̃uwẽn ip João omuy daomũnmũnap'a be iam. Imuwẽn puje, o'ju Galiléia eipi be Jesus. ");
INSERT INTO myu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesus o'ju Cafarnaum ka kay. Nazaré ka bewi o'ju. Oajẽm. Osunuy Cafarnaum ka be iodi xe―Galiléiadi xe. Zebulom eipi be osunuy, Naftali eipi be dak. ");
INSERT INTO myu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kuyje Isaías juk o'e Deus a'õbi: ");
INSERT INTO myu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Judeu'ũmayũ kabiaat cĩcãat o'jojojo ip―yobog̃at. Jeipi be o'jojojo ip―Galiléia watwat, iodi wãbu watwat, Jordãodi winabuat ka watwat tak. Zebulom watwat o'jojojo ip, Naftali watwat tak. ");
INSERT INTO myu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kabiokbog̃ pe kaxikxik'iayũ kabiaat o'jojojo. Kabiaat cĩcãat oajẽm kuy je'ũ ojuyayũ kay, i juk o'e Isaías. O'jekawẽn kuyjeayũ be. ");
INSERT INTO myu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ibocewi Jesus kawẽnwẽn o'e adeayũ be. Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere! Eyg̃uycũg̃ cuy epesop, ikẽrẽat kug̃ puye. Deus soat kukanap kabia jajẽm dao ma―kabi beat soat kukanap — io'e. Imẽn soat em kawẽnwẽn o'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pũg̃ kabia Jesus Pedro o'jojojo, André dak. André Pedro kitpit osunuy. Pedro butet osunuy Simão Pedro i. Ixeyũ o'jojojo Jesus. Xĩg̃xĩg̃'i bima Galiléiadi wãbu be o'jojojo. Axima bubuap xikxig̃ ip o'e iodi be, axima bubu'ukayũ osodop ip puye. ");
INSERT INTO myu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","— Epesot okay, oweju jekuku am — Jesus cebe ip. — Axima bubu'ukayũm cuk adi epesop. Ig̃asũ kawẽn idipat epeg̃uwẽnuwẽn ijodiat pe imutabun ip okay — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Axima bubuap o'suiwat ip dao ma. O'ju ip Jesus kay, ceweju jekuku am. ");
INSERT INTO myu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus wara'acayũ o'jojojo―xepxepayũ―Tiago, João dak. O'jojojo, ibocewi cucum pima. João Tiago kitpit osunuy. Zebedeu ipotpoyũ osodop ip. Kobe be osodop ip Zebedeu eju. Axima bubuap muwaketken o'e ip. — Epesot okay, oweju jekuku am — Jesus o'e Zebedeu ipotpoyũ be. ");
INSERT INTO myu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kobe o'suiwat ip, jebay dak. O'suiwat ip cekobe be. O'ju ip Jesus kay. Dao ma o'ju ip, Jesus eju jekuku am. ");
INSERT INTO myu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O'ju Jesus soat tag̃―Galiléia eipi dag̃. Adeayũ mutaybitbin o'e Deus eju kawẽnwẽnap'a be. Kawẽn idipat muwẽnuwẽn o'e adeayũ be. Deus soat kukanap muwẽnuwẽn o'e. Iwãtaxipipiayũ o'g̃u'ada'ada. Ibaca'ũmayũ mubacacan o'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Imẽneju itaybicayũ Jesus awẽg̃ o'g̃uwẽnuwẽn. Soat Síria eipi beacat o'jekũyjojo. Soat iwãtaxipipiayũ: ipi kug̃ayũ, ibiõg̃buk kẽrẽat kug̃ayũ, yag̃uybabi'ũm'ukayũ, ijebit e'ũat puximayũ; soat ip o'tujowat Jesus kay. Soat ip o'g̃u'ada. ");
INSERT INTO myu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Adeayũ o'ju ip Jesus tomuju―ade jĩjã. Galiléia eipi bewiayũ, Dez Cidades ka bewiayũ, Jerusalém ka bewiayũ, Judéia eipi bewiayũ, Jordãodi winabu wiayũ; soat ip o'ju Jesus tomuju. ");
INSERT INTO myu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Adeayũ jojom pima, o'ju Jesus, ade jĩjã ip puye. Co'a kay o'ju. O'jeu co'a dag̃. Oabik iboce. Cebekitkit oajẽm Jesus kay―ceweju etaybitbinayũ. ");
INSERT INTO myu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","G̃ebuje o'jekawẽn jebekitkit pe. Imutaybitbin o'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","— Icokcok okay itabutpinayũ, jetaybicap puye — io'e Jesus. — Itaybit ip Deus oce mubacanucan pima acã, Deus a'õ dag̃ oceku iam. Icokcok ip, soat em Deus xe jeedop puye. ");
INSERT INTO myu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","— Waayũ dak icokcok ip — Jesus o'e. — “Epetõtõn g̃u juy epesop,” Deus waayũ be e'em. Imẽnpuye icokcok cĩcã je'e ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","— Icokcok ya'õkadidim warara'cat kukayũ. Xipacat je'jat ip Deus xewi―apẽn Deus o'e'e iap tag̃. ");
INSERT INTO myu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","— Icokcok cĩcã jeedop ip―Deus xe cũg̃ cĩcãayũ. Apẽn idibi kay wuyju, wuybipuruk pima, imẽn tak Deus bikuyap kay ixeyũ dak jajẽm. Apẽn puybit kay dak wuyrere bima, imẽn tak Deus bikuyap tag̃ jeku pin ip. Imẽnpuye Deus ibikuyap je'g̃ũm cebe ip―cũg̃ cĩcãayũ be. Icũg̃ cĩcã e'em ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","— Icokcok cĩcã jeedop wara'acat kay itabotaidabotbocayũ — io'e. — Deus tak itabotaidabotbot jeenuy cekay ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","— Icokcok cĩcã jeedop ip―yag̃uy'isuayũ. Deus cocom jeedop ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","— Icokcok itakomaat mudinudin'ukayũ. Jekpotpoyũ buxim Deus tak jukuk ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","— Icokcok cĩcã jeedop ip―Deus bikuyap tag̃ jekuku'ukayũ. Ipiat ajojom ip, Deus bikuyap tag̃ jekukum puye. Imẽnpit soat em Deus xe jeedop ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","— Okay eyetabut puye, adeayũ itakoma jeedop eykay. Imẽnpit eycokcog̃ ma epesop — io'e cebe ip. — Eycokcog̃ ma epesop, eymuymuy ip pima, xipat'ũm eykuk ip pima dak, eyawẽg̃ mukẽrẽrẽrẽm ip pima dak. Eycokcog̃ ma epesop itakomaayũ imẽn jeykuk, okay eyetabut puye — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Imẽn tak kuyjeayũ Deus ekawẽn muwẽnuwẽn'ukayũ xipan g̃u o'jukuk ip. Eycokcog̃ cĩcã epesop. Kabi be bit, Deus xe bit, ade kug̃ epesop―idipat kug̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","O'jekawẽn jebekitkit pe. Wuymutaybinap muwẽnuwẽn o'e Jesus―imẽnpuximap ekawẽn. — Ipi juacat pima eyju, kawta buxim epesop — io'e. — Kawta tayu buye, xipat cĩcã. Imẽnpit takõ'õm puje, xipat g̃u kuka. Te'e ma kuka atakuk. Apẽg̃ãm tak takug̃ kuka acesop? Taxik am acã. Taxik puje, tamucakucag̃ kuka wuyju — io'e Jesus. Imẽnpuximap kawẽnuwẽn o'e Jesus. Kawta wuyxat mukun. I'o pin wwuyju, wuyxat pe kawta opop puye. Imẽnpuxim Jesus kay itabucayũ ekukuap cuy ipi juacat mudim. Jekuku ojuy ipi juacat Deus a'õ dag̃, Jesus kay itabucayũ ekukuap jojo buye. Tayu'ũm pima bit, xipat g̃u kuka kawta. Acetaxik kuka, tamucak am. Imẽnpuxim tak cebekitkit Jesus kay itabut'ũm'ũm jekukum pima bit, xipat g̃u kuka, ipi juacat mudim'ũm kuka buye. ");
INSERT INTO myu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","16","Ipi juacat etabixe kabiahamat puximayũ epesop — io'e Jesus. — Xipan eyekukuap cocom pima ip, Deus awẽg̃ mubuyxin jeedop ip―wuyebay awẽg̃―kabi beat awẽg̃ — io'e Jesus. — Apẽn e dag̃ wuyjojo but, kabiaham pima; imẽnpuxim Deus awẽg̃ buxin put warara'acayũ, xipan eyju jekukum pima — io'e Jesus. — Ipi juacat eyju bima, kabiaat puxim epesop — io'e. — Ag̃okaxiri co'a be wuysukamuy bima, ika ba'arẽm g̃u o'sukadop. Ikamunẽm pa'ore. Kuy bi ma ikabapuk soat pe, co'a jeje buye — io'e. — Eyju dak iba'arẽm g̃u epesop, xipan epekuku bima. Soat pe eyekukuap je'bapuk. Imẽn ipi juacat pe kabiaat puxim eyju, itaybit ip puye ajo xipat Deus xe iam, eyekukuap cocom ip pima — io'e. — Lamparina musop puje, ico diotpe g̃u ajomuy. Uk'a be acejomõg̃ imũn ceje. Um ma ajomuy kabia i'e am soat uk'a beat kay, soat ijo but am. ");
INSERT INTO myu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","O'jekawẽn Jesus jebekitkit pe. — Epeyewag̃uy g̃u juy “Osodot teku Moisés ekawẽn mu'ũm ãm, Deus ekawẽn muwẽnuwẽn'ukat imutaybitbinap mu'ũm ãm tak” i. Imẽg̃ãm g̃u ojot. Ojot ma imutaybit am apẽn ape iboap ekawẽn osodop iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","— Moisés ekawẽn i'ũm pa'ore cebe ip. Soat Deus o'e iap tag̃ je'bapuk — io'e Jesus. — Kabi oi'ũm kuka, ipi dak. Deus ekawẽn pit i'ũm g̃u. Pũg̃ a'õ dak ka'ũma ma i'ũm. Soat epa'ũmap jajẽm. Iboap ekawẽn tak jeedop―Moisés ekawẽn. Iboap kay g̃ebum cuy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","— Imẽnpit pũg̃pũg̃ Moisés ekawẽn kay g̃u. Kũyjobit g̃u ip Moisés ekawẽn kay. Warara'acayũ mutaybitbin ip kũyjobit'ũm ãm Moisés ekawẽn kay. Kabi be bima, Deus xe bima, “Teku Deus a'õ kaysũ ã. Xipatput acã teku,” i je'e soat kũyjobit'ũmayũ be. — Pũg̃pũg̃ ma Moisés ekawẽn kay jĩjã. Kũyjobit cĩcã ip. Warara'acayũ mutaybitbin ip kũyjobit am Moisés ekawẽn kay. Kabi be bima, Deus xe bima, “Teku Deus a'õ kay jĩjãat. Xipacat teku,” i je'e soat kũyjobicayũ be. ");
INSERT INTO myu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","— Og̃uwẽn eywebe: Deus bikuyap tag̃ eyeku bimap acã, eywebe ajẽm put Deus kay. Fariseuyũ bodi ma Deus bikuyap tag̃ eyeku'ũm pima, Deus xe g̃u epesop soat em―Moisés ekawẽn imutaybitbin'ukayũ bodi ma dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","— Eyju juk epeya'ĩjojo apẽn Moisés o'e iam. Epeyaoka g̃u juy. Pũg̃ em tak ka'ũma. Wara'at o'yaokaiat epetujowat cuy ibimãmãat ekawẽn coco'ukat pe, i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","— Õn pit e'em eywebe: Soat cuy epetujowat ibimãmãat ekawẽn coco'ukat kay―jewag̃o kay itakomaayũ. Iboce ipiat supi'ajoat itakomaat pe. “Ka'ũmaat ma ẽn,” i'e'e'ukat pe bit itakomaat podi ma ipiat supi'ajoat ibimãmãat ekawẽn coco'ukayũ kukukat a'õ dag̃. “Akpidapi,” i'e'e'ukat pit daxabog̃ kay je'ju―ipiat'ajoat ka kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","— Imẽneju eykitpit epeg̃udin cuy, eykay itakoma bima. Iũmũmap epesuiwat Deus eju kawẽnwẽnap'a be. Ajo epetojot imõg̃ ãm Deus etabixeat'a be, ijop epesuiwat. Epeju juy eykitpit kay, imudin am — io'e Jesus. — Epeju juy, juk epeõm ma'g̃u Deus tuk'a be. Epeju juy, eyju g̃ebum puye “Okitpit itakoma okay,” i — io'e Jesus. — Eykitpit mudin puje acã, epeyepit iũmũmap ũm ãm Deus pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Eybure eymuymuy bima, eyweroap teida'ũm pima, dao ma juy epeg̃udin eybure. Xipan epeyekawẽn — io'e Jesus. — Cucum pima ibimãmãat ekawẽn coco'ukayũ kay, xipan epeyekawẽn cebe — io'e. — Imẽn eyekawẽn'ũm pima, imudin'ũm pima, eymuymuyat eydujowan ibimãmãat ekawẽn coco'ukayũ xe. Ixeyũ eydujowan daomũnmũnap'a kukat kay, eymõg̃ ãm daomũnmũnap'a be. Eyenapõn pa'ore kuka epe'e ibocewi bit — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","— Icẽmãn õn e'em eywebe. Daomũnmũnap'a be epesop soat em. Soat g̃u eyeweroap teida'ũm pima, jeymujẽm g̃u ip daomũnmũnap'a bewi — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","— Moisés o'jekawẽn kuyjeacat pe — Jesus o'e. Ecepo g̃u juy wara'at ayacat eju―etayxi eju acã. Aoyũ dak jepo g̃u juy ip wara'at ag̃okatkat eju―jektop eju acã, i — io'e. — Eyetaybit iboam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","— Imẽnpit õn e'em eywebe: Ayacat kay ag̃ pima eyju, dabi'o pin pima dak, kuy ceweju jepo iap co'i epe'e. Eyag̃uy be ma kuy ibapuk ayacat kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","— Imẽnpuye epeyepere juy jeakap ikẽrẽat kay. Eyba'at kadiata'ũm pima bit purut, kuka ikẽrẽat epeg̃ug̃ẽ. Imẽn ikẽrẽat epeg̃ug̃ẽ g̃u ipiat'ajoap puxixim — io'e―Jesus o'e. Imẽn Jesus o'e, Jesus xe wuyta wuybikuyap puxim. Wuybikuyap pewi wuyju ikẽrẽat kay bima, iboap ibikuyap tag̃ jekukum g̃u juy acesop. Pug̃ ẽm tak ka'ũma. ");
INSERT INTO myu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","— Epeyepere juy ikẽrẽat mug̃eg̃ẽap tak — io'e Jesus. — Eyba'at kadiatpu'ũm pima bit purut, kuka eybum ikẽrẽat epeg̃ujurũg̃. Imẽn ikẽrẽat epeg̃ug̃ẽ g̃u, ipiat'ajoap puxixim — io'e Jesus. Imẽn Jesus o'e, Jesus xe wuyba wuye'eap puxim. Wuye'eap pewi wuyju ikẽrẽat mubapuk pima, iboap e'eap tag̃ jekukum g̃u juy acesop. Jepere juy wuyju. ");
INSERT INTO myu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","— Moisés o'jekawẽn waram kuyjeacat pe. Ag̃okatkat jetayxi epere pin pima, otayxim g̃u ẽn g̃asũ bit iaptup cuy tupũm cebe. Imẽn cuy etupũm cebe, cepere am, i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","— Õn pit e'em eywebe: Ag̃okatkat jetayxi epere buje, jetayxi wara'at eju o'jepo g̃un ma'g̃u, ixe ag̃okatkat ikẽrẽat kug̃ Deus xe. Ixe ayacat waram jewebumũn puje, ikẽrẽat kug̃ Deus xe, itop ikẽrẽat o'g̃ug̃ẽ buye. Wara'at ag̃okatkat tak ixe ayacat eju jewebumũn puje, ikẽrẽat kug̃ Deus xe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","— Moisés o'jekawẽn. Icẽmãn cuy epe'e. Eybu'um g̃u juy eytabucap kay epesop. Eya'õ dag̃ cuy epeku soat em. Eya'õ kay juy epesop―ajo imug̃ẽap ojuy iap kay. Kuy juk epeyekawẽn Deus pe: ‘Wa'õ kay'ũm pima, ipiat osupi'ajoat owebe,’ i juk epe'e. Imẽneju eya'õ kay juy epesop, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","— Õn pit e'em eywebe: Eyetabucap epe'e bima, epeyekawẽn g̃u juy Deus pe: “Wa'õ kay'ũm pima, ipiat osupi'ajoat owebe,” i g̃u juy epe'e. Pũg̃ em tak ka'ũma — io'e Jesus. — “Etaybit icẽmãn kabi kake. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe,” i'ũmg̃u dak cuy epe'e warara'acat pe. Imẽn epe'e bima, “Etaybit icẽmãn Deus kake,” i bima bit purut ka epe'e, kabi Deus abikbikap puxim puye. Imẽn pima pit purut ka epe'e, Deus kabi be omuyiat puye. ");
INSERT INTO myu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","— “Etaybit icẽmãn ipi kake. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe,” i'ũmg̃u dak cuy epe'e warara'acat pe. Imẽn epe'e bima, “Etaybit icẽmãn ipi o'g̃ug̃ẽiat kake,” i bima bit purut ka epe'e, ipi Deus imũnka buxim puye. Imẽn pima bit purut ka epe'e, Deus ipi o'g̃ug̃ẽ buye. — “Etaybit icẽmãn Jerusalém ka kake. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe,” i dak ũmg̃u juy epe'e warara'acat pe. Imẽn epe'e bima, “Etaybit icẽmãn Jerusalém ka watwat kukukat kake,” i bima bit purut ka epe'e, Deus Jerusalém ka watwat kukukat cĩcãat puye. — Imẽneju epe'e g̃u juy soat pe. Pũg̃ em tak ka'ũma. Soat kake ip, Deus a'õbiat ebapukpukap puye. ");
INSERT INTO myu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","— “Etaybit icẽmãn wa'a kake. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe,” i dak ũmg̃u juy epe'e warara'acat pe. Imẽn g̃u juy epe'e, eywebe iba'ore buye yaypan'isuat waram ebapuk am, yaypan cĩcã buje; eywebe iba'ore buye dak yaypan cĩcã ebapuk am, yaypan'isuat pima — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","— I juy epe'e, “Icẽmãn,” i. I dak epe'e, “Ka'ũma,” i. Imẽn acã epeyekawẽn cuy, ibiõg̃buk kẽrẽayũ kukukat pewi beku wara'at ekawẽn ajẽmjẽm puye―dapxi iap ekawẽn ajẽmjẽm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","— Moisés cuk o'jekawẽn. Ag̃okatkat ta'ũm pima, eyju dak wara'at epesutamu'ũm, i. Agokatkat tũy'uk puje, wara'at tak epetũy'uk cuy, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","— Õn pit e'em eywebe: Ikẽrẽm eykukayũ eyba'at kadi eydopaoka buje ip, wara'at kadi koreren epe'e eydopa, wara'at kadi eydopaoka am — io'e Jesus. — Ikẽrẽm g̃u juy ip epejukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","— Eyekamixa kay ip pima, ibimãmãayũ kay eydujowan pima, epeg̃ũm cuy cebe ip. Eyekabek tak epeg̃ũm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","— Wara'at ka bewiat sorara a'õbi pũg̃ kilometroat tag̃ jebubut eymudujowan puje, epeyetujowat cuy xepxep kilometroat tag̃. ");
INSERT INTO myu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","— Eyxewi iojuy buje, epeg̃ũm cuy cebe. Eyweju o'jekawẽn pima: “Eybubut epeg̃ũm cuy owebe darem. Waram iũmũm eywebe ma,” i; darem cuy epeg̃ũm cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","— Kuyje Moisés o'jekawẽn. Eyduk'a xeayũ xipan epejukuk, i. Eykay itakomaayũ bit xipan g̃u juy epejukuk, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","— G̃asũ oce eywebe: Eykay itakomaayũ xipan cuy epejukuk. Xipan g̃u eykukayũ beam cuy epeyekawẽn Deus eju — io'e Jesus. — “On odin ip cekay,” i juy epe'e, kawẽnwẽn pima Deus pe. ");
INSERT INTO myu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","— Imẽn jekukum pima, kabi beat ipotpoyũm epe'e. Soat peam Deus kaxi o'g̃uju kabi be―xipacayũ beam, xipat'ũmayũ beam tak — io'e Jesus. — Soat peam tak Deus muba'at o'g̃uju ipi kay―icũg̃at peam, cũg̃'ũmat peam tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","— Eykayayũ acã ikukpin eyxe bima, imẽn xipat Deus xe du? Ka'ũma. Apẽnpuye Deus a'õbi xipacat ũmap wiwim eyju? Jeyipi iecug̃ap peam dinheiro bubu'ukayũ imẽn tak ixeyũ xe jekayayũ ikukpin jekuku ip―eyxe cekay'ũm cĩcãayũ imẽn jekuku ip. Eykay'ũmayũ dak xipan cuy epejukuk — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","— Eybureyũ eju acã eyekawẽn puje, ajo g̃u e'em cĩcã eyju. Imẽn tak Deus kay itabut'ũmayũ jekuku ip. ");
INSERT INTO myu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","— Wuyebay xipat cĩcãat soat em. Ixe buxim cuy epesop―wuyebay icẽmat puxim cuy epesop―kabi beat puxim — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","O'jekawẽn Jesus jebekitkit pe. — Eyday'em'um cuy epesop — io'e Jesus. — Wara'acayũ be eyjojoap puxim g̃u cũg̃ ma epekuku — io'e. — Imẽn cuy epeg̃ug̃ẽ g̃u ixeyũ be eyjojoap puxim. Imẽn epeg̃ug̃ẽ bima, Deus xewi ka'ũmg̃u jeyjat, eye'eap puye. Ixe kabi beat xewi ka'ũmg̃u epejat — io'e ya'ĩjojo'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","— Imẽnpuye ibubutbet'ũmat kay eyetabotaidabotbot pima, cebe eyebutbut'in ũmũm pima, eyawẽg̃ epeyawẽg̃mupõg̃põg̃ g̃u juy — Jesus o'e. — Eymug̃uykuku'ukayũ jawẽg̃ mupõg̃põg̃ ojuy ip imẽn ma. Deus uk'a be jawẽg̃ mupõg̃põg̃ ip, e dag̃ tak. Jebureyũ ekawẽn kay jĩjã ip, “Xipat cĩcãat ẽn,” i bima cebe ip. Iboap ekawẽn kay jĩjã ip. Icẽmãn oce eywebe. Jebikuyap tag̃ je'jat ip. Imẽnpit ka'ũma ma je'jat Deus xewi — io'e Jesus ya'ĩjojo'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","— Eyju bit ibubutbet'ũmat pe iũmũm pimap, iba'arẽm ma juy epeg̃ũm, jebure jĩjãat cuy itaybit g̃u iũm ãm je'e — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","— Iba'arẽm iũmũm pima eyju, ixe kabi beat o'jojojo―wuyebay. Xipacat je'g̃ũm eywebe. “Xipat ẽn oxe,” Deus e'em eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","— Eyju bit warara'acat mug̃uykuku'ukat puxim g̃u juy epesop. Soat etabutpe ip kawẽn pin Deus eju. Deus eju kawẽnwẽnap'a be kawẽn pin ip soat etabutpe―uk'a ukpibubu dag̃ tak. Warara'acat pe jejojoan acã ip kawẽnwẽn Deus eju. Warara'acat kawẽn ãm ojuy ip. “Xipat ip. Deus kay jĩjã ip,” i. Warara'acat o'jewag̃uy cebe ip ojuy ip. Wararaãcat ijojom ip iap acã je'jat ip. Deus xewi bit ka'ũma ma je'jat ip. ");
INSERT INTO myu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","— Eyju bit eyduk'a be juy epeõm, Deus eju kawẽn ãm — Jesus o'e cebe ip. — Eyduk'a exĩntabi juy epetomudip, warara'acat pe eyjojoap puxim. Epetomudip, kawẽn ãm kabi beat eju―ijo ba'oreat eju―wuyebay eju. Deus imẽn eyjojo. Xipacat je'g̃ũm eywebe. “Xipat ẽn oxe,” i'e'em tak eywebe — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Deus eju kawẽnwẽn pima, eyejoojuyap ade em g̃u juy epeyekawẽn — io'e. — Imẽn Judeu'ũmayũ o'jekawẽn ip Deus baroyũ be. Tũybe ocekawẽn kay ya'ĩjojo je'e oceju ade ma kawẽnwẽn puye iãn je'e ip. ");
INSERT INTO myu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","— Eyju bit ka'ũma. Imẽn epeyekawẽn g̃u juy Deus eju. Deus eyebay buxim. Kabi beat teku. Eyekawẽn awap, itaybit ajo-kug̃ g̃u eyju iam — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","— Imẽn cuy epe'e, Deus eju kawẽnwẽn pima: “Bay!” i juy epe'e kabi beat pe. “Soat cuy ibuyxin ebutet kug̃ jeenuy,” i. ");
INSERT INTO myu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“G̃axĩn ma juy soat kukukan eg̃uy,” i dak. “Soat kukukan eg̃uy bima, ipi juacat cuy jekukum jeedop ip ebikuyap tag̃ apẽn kabi beacat cucum ip ebikuyap tag̃,” i. ");
INSERT INTO myu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","“G̃asũ ocexan cuy eg̃ũm ocewebe,” i. ");
INSERT INTO myu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","“Apẽn oceju g̃ebum g̃u apẽn warara'acayũ be juk adi warẽmtag̃ ocekuk iap kay; imẽn tak g̃ebum g̃u juy eg̃uy apẽn cuk adi ikẽrẽat oceg̃ujurũg̃rũg̃ iap kay,” i dak. ");
INSERT INTO myu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","“Oca'õ mubacanucan cuy eg̃uy ocewebe ikẽrẽat mujurũg̃ap puxim. Ikẽrẽat tak eju'uk cuy ocewebewi,” i dak cuy epe'e — io'e Jesus. — Imẽn ma juy epe'e Deus eju kawẽnwẽn pima — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","— Eyju g̃ebum'ũm pima apẽn warara'cayũ be juk adi ikẽrẽm eykuk iap kay; ikẽrẽat epeg̃ujurũg̃rũg̃ cĩcã ma'g̃u, Deus tak jeg̃ebu g̃u apẽn juk adi ikẽrẽat epeg̃ug̃ẽg̃ẽ iap kay. Kabi beat jeg̃ebu g̃u―wuyebay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","— Eyju g̃ebum pima bit apẽn warara'acayũ be juk adi ikẽrẽm eykuk iap kay, Deus tak jeg̃ebu apẽn juk adi ikẽrẽat epeg̃ug̃ẽg̃ẽ iap kay. Wuyebay xeku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","— Deus kay g̃ebumap kay jekõnkõn'ũm pima eyju, eyg̃uycũg̃cũg̃ g̃u juy epesop. Eymug̃uykuku'ukayũ ig̃uycũg̃cũg̃ oekuku ip, Deus kay g̃ebumap kay jekõnkõn'ũm pima ip. Ig̃uycũg̃cũg̃ oekuku ip, soat itaybit ojuy, “Teku Deus kay g̃ebumap kay jekõnkõn g̃u iam. Jebureyũ juk o'jekawẽn ip. “Deus kay jĩjãat teku,” i. Imẽnpuye jebikuyap tag̃ cuk o'jat ip―soat ma. Iboap kay g̃ebum cuy eyju — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","— Eyju bit Deus kay g̃ebumap kay jekõnkõn'ũm pima, epeyewedopawuywuy juy. Epeyewedapmusem cuy dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","— Imẽn wara'acayũ itaybit g̃u ip teku jekõnkõn g̃u iam. Deus acã je'e itaybit iba'arẽm jekõnkõn g̃u teku iam. Ijo ba'oreat acã itaybit. Xipacat je'g̃ũm eywebe. “Xipat ẽn oxe,” i dak e'em Deus eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","O'jekawẽn jebekitkit pe. — Eywebeam ade bubut epeg̃uxipan g̃u juy epesop — Jesus o'e. — Ijoce imuxipan g̃u juy. Ijoce kopi'i eybubut jo'o. Hi'ep eybubut iokok an e'em Ibukurukat eyduk'a be õm'õm eybubut tujupa'um am — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","— Kabi be bit Deus xe epesop soat em. Eycokcok cĩcã epesop. Kopi'i kake g̃u Deus xe. Hi'ep kake g̃u dak. Ibukurukayũ kake g̃u dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","— Eybubut ijodi bima soat em g̃ebum epesop eybubut kay. Kabi be eyg̃uy pin pima bit, g̃ebum epesop kabi beat kay. Imẽnpuye eycõkcõk cĩcã epesop Deus xe soat em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","— Wuyeta kabiaap puxim. Wuyjebit peam ixe kabiaap. Wuyetadip pima soat ijo but wuywebe. Kabia dag̃ ajeku. Soat ijobucap wuyekukuap puxim―Deus xe cũg̃ ma wuyekukuap puxim. ");
INSERT INTO myu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","— Wuyetakẽrẽ bima bit, ijo ba'ore wuywebe. Kabiok tag̃ ajeku. Kabiok tag̃ jekukuap ikẽrẽat mujurũg̃rũg̃ap puxim. Imẽnpuye kabiaap kabiok e'em pima, kabiok cĩcã e'em wuywebeam. Ikẽrẽat mujurũg̃rũg̃ cĩcã wuyjuyũ. ");
INSERT INTO myu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","— Pũg̃'a be, uk'a be bima, iba'ore ibuywatwat'ukat pe xepxepayũ beam kapik am. Kariwawayũ wara'at tag̃tag̃tag̃ e'em pima, itakoma kuka o'e pũg̃ kay, jekariwa kay, wara'at jekariwa ikuk pin cĩcã bima. Kũyjobit kuka o'e pũg̃ a'õ kay, wara'at a'õ kay kũyjobit'ũm pima. Imẽnpuxim dinheiro kay jĩjã bima, Deus kay jĩjã g̃u epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","— Imẽnpuye og̃uwẽn eywebe: Eyag̃uy'ũm g̃u juy epesop eybubut kay — Jesus o'e cebe ip. — “Ajo paxi acejo'o?” i'ũmg̃u juy epe'e — io'e. — “Ajo paxi acetikõn?” i'ũmg̃u dak cuy epe'e — io'e. — “Ajo paxi aceg̃uõm wuydotim?” i'ũmg̃u dak cuy epe'e. Xipat eyxat kug̃ pima, eydoti kug̃ pima dak. Imẽnpit ibodi ma xipat soat em Deus xe eydop am — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","— G̃ebum cuy epesop wasũ kay — io'e Jesus. — Pupum ip kabi be. Taidadam g̃u ip. Jeku beat tak pupum g̃u ip, jeku bewiat mũn'a be imõg̃ ãm. Imẽnpit Deus ixat ũmũm cebe ip―wasũyũ be. Deus xe wasũ teibog̃ g̃u―wuyebay xe―kabi beat xe. Imẽnpit ag̃ cekay ip. Imẽnpuxim wuykay dak soat em ag̃. ");
INSERT INTO myu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ade koato mabuk wetabẽg̃ og̃uy iap kay g̃ebum cĩcã bima, eyetabẽg̃ xe'e? Ka'ũma. G̃axĩn ma aco'i epe'ũ. ");
INSERT INTO myu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","— Pãm eydoti dak? Apẽnpuye eyag̃uybabi'ũm eydoti kay? Eyag̃uybabi'ũm g̃u juy. G̃ebum cuy epesop apẽn tũmũntitit aypapan iap kay. Tũmũntitit kapikpig̃ g̃u. Jesay mug̃ẽg̃ẽm g̃u dak ip. ");
INSERT INTO myu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Icẽmãn õn e'em eywebe. Salomão ibubut adeat osunuy. Idip cĩcãat kug̃ osunuy―jesay kug̃. Salomão dipap podi ma bit titip tip tag̃atip. ");
INSERT INTO myu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","G̃asũ ma tũmũntitit titetabẽg̃ e'em. Kuyaje bit tite'ũ e'em. Titip Deus a'õbi. Imẽnpuxim ja'õbi dak eyemukaypinput je'g̃ũm eywebe. Eyetabutsu ma'g̃u cekay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","— Imẽnpuye eyag̃uybabi'ũm g̃u juy epesop. “Ajo paxi acejo'o?” i'ũmg̃u juy epe'e. “Ajo paxi acetikon?” i dak. “Ajo paxi aceg̃uõm?” i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","— Judeu'ũmayũ yag̃uy'ũm iboap kay―soat kay. Eyebayat pit itaybit eyju ikug̃'ũm pima iam―kabi beat. ");
INSERT INTO myu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","— Koap g̃ebum cuy epesop Deus soat kukan je'e iap kay―Deus ebikuyap kay dak. Imẽn g̃ebum pima, Deus soat je'g̃ũm eywebe. Eyxan je'g̃ũm, eydotim tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","— Imẽneju eyag̃uybabi'ũm g̃u juy epesop kuyajeat kabia kay. Kuyaje jajẽm pima, eyetaybit epe'e ajo o'jebapuk ixe kabia iam―ajo xipat, ajo xipatpũt tak. G̃asũ bit eyag̃uybabi'ũm g̃u juy epesop kuyajeat kabia kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","O'jekawẽn jebekitkit pe. — “Eykẽrẽ jĩjã Deus xe,” i'ũmg̃u juy epe'e warara'acat pe. Imẽn tak Deus “Eykẽrẽ oxe,” i'ũmg̃u je'e eywebe. ");
INSERT INTO myu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","“Ikẽrẽat kug̃ ẽn,” i'ũmg̃u juy epe'e warara'acat pe. Imẽn e'em'ũm pima, Deus “Ikẽreãt kug̃ eyju,” i'ũmg̃u dak je'e eywebe. Apẽn warara'acat pe eyekawẽnap puxim Deus tak je'e eywebe ajo xipat jexe, ajo xipat g̃u jexe. Warara'acat pe epeg̃ũm pima, Deus tak je'g̃ũm eywebe. Apẽn cuk epeg̃ũm iap puxim epejat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wuymutaybitbinap ekawẽn muwẽnuwẽn o'e Jesus―imẽnpuximap ekawẽn. Jebekitkit pe imuwẽnmuwẽn o'e, itaybit am ip. Warara'acat ekukuap mukorẽm ãm, wuyekuku bima, imukorẽmap tõm puxim Jesus xe, ip puxim tak cexe. Imẽnpuye Jesus o'jekawẽn jebekitkit pe. — Te'e ma eyju jeakag̃ eybure eta beatõmtõm kay, eyeta beap'ip cocom'ũm pima. ");
INSERT INTO myu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Te'e ma eyju e'em cebe: “Ma. Otõmtõm'uk eta bewi,” i, eyeta beap'ip cocom'ũm pima — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","— Eyju jewemug̃uykukukum. Koam eyeta beap'ip cuy epeyop'uk. — Yop'uk puje, iba'ore g̃u je'e eyewebe tõmtõm'uk am eybure eta bewi. Yop'uk puje, xipan epe'e ijojom — io'e. Imẽn Jesus wuymutaybitbin warara'acat kay g̃u juy acejeak iam―wuyekay acã juy acejeak ikẽrẽat mug̃ẽ buje iam―yopit ma ikẽrẽat mug̃ẽ buje iam yobog̃ ma ikẽrẽat mug̃ẽ buje iam tak. ");
INSERT INTO myu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","— Wekawẽn icẽmãn — io'e Jesus. — Soat pe g̃u juy epeg̃uwẽn wekawẽn. Akurice buximayũ be g̃u juy epeg̃uwẽn, wa'õ kay g̃u ip puye. Ya'õpurug̃ jede ip. Warẽmtag̃ webekitkit o'jukuk ip — Jesus o'e. — Xipat ma wekawẽn. Soat pe g̃u juy wekawẽn epeg̃uwẽn. Dajebaro buximayũ be dak g̃u juy epeg̃uwẽn. Itaybit g̃u ip ya'õdip ma iam. Ixeyũ be wekawẽn kawẽn te'e maap puxim — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","O'jekawẽn jebekitkit pe. — Deus xewi juy epejoojuy. Iojuyjuy bima, epejat. Ixe xewi juy epejokudada. Ikudadam pima, epetobuxik. Ixe xewi iojuyjuyap xĩntabi be tag̃tag̃tag̃'iap puxim. Xĩntabi be tag̃tag̃tag̃'i bima, tomudip'uk ip eymuõm ãm. ");
INSERT INTO myu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Soat ojuyjuy'ukat je'jat; soat kudada'ukat tobuxik; xĩntabi tag̃tag̃tag̃'iat pe xĩntabi tomudip'uk ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","— Wita'a g̃u epeyaũm eyipotpot pe “Pão'a kay õn,” i'e buje. Ka'ũma ma ey'in wita'a o'yaũm kuka cebe pão'a yaũmap tieg̃. ");
INSERT INTO myu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Puybu g̃u epesubuũm cebe, “Axima kay õn” i'e buje. Kaũma ma ey'in puybu o'subuũm kuka cebe aximaũmap tieg̃. ");
INSERT INTO myu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eyju ikẽrẽat kug̃. Imẽnpit eyju ma xipacat ũmũm eyipotpoyũ be. Apẽn eyju iũmũmap podi ma eyebayat pit xipacat ũmũm jexewi iojuyjuy'ukayũ be―kabi beat pit. ");
INSERT INTO myu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eybikuy warara'acat pe xipan eykuk am. Imẽnpuye xipan cuy warara'acat epejukuk. Iju Moisés ekawẽn, Deus ekawẽn muwẽnuwẽn'ukayũ emumutaybitbinap tak. ");
INSERT INTO myu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesus tak o'jekawẽn. — Epeõm cuy xĩntabi itok'ĩt tag̃. Xĩntabi itokbog̃ pit daxabog̃ kay wuymujujuap e ma―ipiat'ajojoap kay. E pa'ore'ũmat e. Xĩntabi itokbog̃. Ade wuyjuyũ ie dag̃ jekukum. ");
INSERT INTO myu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Xĩntabi itok'ĩt pit e pa'oreat e xĩntabi. Wuytait'icap e. Pũg̃pũg̃ ma wuyjuyũ ie dobuxikxig̃. ");
INSERT INTO myu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus dak o'jekawẽn jebekitkit pe. — Eyday'em'um cuy epesop eymug̃uykuku ojuyayũ kay―jewexe Deus ekawẽn muwẽnuwẽn'ukayũ kay. Omuyku ip. Ovelha jo'i ma'g̃u ip jajẽm, badi bit ip ika'uayũ buxim, akurice buxim. Eykay itakomaayũ ma ip, xipacat co'iayũ ma'g̃u ip jajẽm — io'e. ");
INSERT INTO myu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","— Eyetaybit widaõhõ ya'a'e g̃u e'em―uva'a iam. Eyetaybit tak aru'ip tag̃ figo'a'e g̃u e'em iam. Imẽn eyetaybit widaõhõ, aru'ip tak. Ya'a nomuju eyetaybit iboyũm. Imẽnpuxim tak eyetaybit je'e abuyũ jewexe Deus ekawẽn muwẽnuwẽn'ukayũ iam. Xipat'ũm cekukuap tomuju eyetaybit ixeyũm. ");
INSERT INTO myu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","— Yopxipacat'ip ya'a xipat e'em. Yopxipat'ũmat'ip ya'a dak xipat g̃u ma e'em. ");
INSERT INTO myu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yopxipcat'ip pit yaku'ũm an g̃u aypatpan. Yopxipat'ũmat'ip tak yaku an g̃u aypatpan. ");
INSERT INTO myu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yop yaku'ũmat'ip soat wuyju ixikxig̃, takatkan daxa be ixik am. ");
INSERT INTO myu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Apẽn yopxipat'ũmat'ip ya'a dak xipat g̃u ma e'em; imẽnpuxim jewexe Deus ekawẽn muwẽnuwẽn'ukayũ xipat g̃u jeku. — Imẽneju eyetaybit epe'e pebicayũ jewexe Deus ekawẽn muwẽnuwẽn'ukayũ xipat'ũm cekukuap tomuju — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","— Deus soat kukanap kabia je'e ip owebe: “Ẽn ocekukukat,” i. Soat pit jeõm g̃u Deus xe kabi be―webay ibikuyap tag̃ cekuibiyũ acã―kabi be omuyat a'õ kayayũ acã — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","— G̃ebujeat kabia Deus abuyũ ikẽrẽat kug̃ iap g̃uwẽn. Adeayũ je'e'e ip owebe: “Ocekukukat! A'õbi ocekuku. Xipacap oceg̃uwẽnuwẽn―Deus soat kukukaniap muwẽnuwẽn oceju,” i. “A'õbi ibiõg̃buk kẽrẽayũ oceg̃ujẽmujem wuyjuyũ xewi,” i dak je'e. “A'õbi ocewebe i'e ba'oreat oceg̃ubapukpuk,” i dak je'e. ");
INSERT INTO myu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","— G̃ebuje õn je'a'õbu. — “Wetaybit g̃u og̃uy eyjum. Pũg̃ em tak ka'ũma,” ioce'e — Jesus o'e. — “Wede epe'e oxewi. Ikẽrẽat mug̃ẽg̃ẽm acã epekuku,” ioce'e dak — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","— Wa'õkayayũ itaybicat puxim ip―ag̃okatkat puxim ixeyũ wekawẽn coco'ukayũ. Ixe ag̃okatkat uk'a o'yamuy wita'a jeje. Uk'a'abi'ip o'yopmuy wita'a jeje. ");
INSERT INTO myu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Muba'at oajẽm wita'a jejeiat'a kay―muba'atxixi. Muba'at idibi o'timubog̃. O'tiajẽm. Kabidoxixi dak o'subidoakaka. Imẽnpit o'ya'at g̃u yacem puye, wita'a jeje buye — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","— Wa'õ dag̃ g̃u jekuku'ukayũ itaybit'ũmat puxim―waramtag̃ ma uk'a o'yamuyiat puxim ip―wekawẽn kay'ũmayu. Wa'ĩjojom ip. Inaka kũyjobit g̃u ip wa'õ kay. Warẽmtag̃ uk'a o'yamuyiat puxim―ag̃okatkat puxim―yag̃uyba'arẽmat puxim. Ixe ag̃okatkat uk'a o'yamuy ipi ju, ka'oririt pe. Cem g̃u o'yamuy. ");
INSERT INTO myu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","— Muba'at oajẽm ka'oririt peat'a kay. Idibi o'tiajẽm―tibog̃ati. Kabido dak o'subidoajẽm. O'subido'at bidobog̃ ya be. O'ya'at. Ig̃o'a o'ya'ũm cĩcã, o'ya'at puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Soat yag̃uybabi'ũm ip osodop, Jesus ekawẽn epere buje. — Wara'an wuymutaybitbin Jesus — io'e ip. — Idim cĩcã teku wuymutaybitbin — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ja'õbi imutaybitbin Jesus osunuy. Moisés ekawẽn imutaybitbin'ukayũ buxim g̃u imutaybitbin osunuy. ");
INSERT INTO myu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","G̃uyjom o'kop Jesus co'a bewi. Ade dak o'kop ip Jesus tomuju. ");
INSERT INTO myu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kopkom pima, ierepat oajẽm Jesus kay, jemu'ada am. O'jeg̃'aecõg̃cõg̃ cewap, Jesus ya'õbuyxiat puye. — Kariwa — io'e Jesus pe. — Ebu'u'ũm pima, omu'adam ece — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","— Obu'u g̃u. Jemu'ada õn — Jesus o'e. O'jebaepucũg̃. O'g̃ucay. O'je'ada dao ma. Ierep topibit xipat o'e. ");
INSERT INTO myu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","— E'adaap cuy eg̃uwẽn g̃u warara'acat pe — io'e. — Paĩ kay juy eju — io'e. — Ecewemubapuk cebe emu'adaam itaybit am — io'e. — Xepxem cuy pukaso eg̃ũm paĩ be Moisés ekawẽn tag̃. Imẽn ece'e soat ijoceayũ itaybit am Jesus ierepat o'g̃u'ada iam. Ẽn pit eg̃uwẽn g̃u e'adaap. Paĩ ma juy g̃uwẽn e'adaap — Jesus o'e ierep tũibit pe. — Hm hm — io'e. ");
INSERT INTO myu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cafarnaum ka be Jesus ajẽm puje, sorarayũ kukukat oajẽm. Jesus kay oajẽm. — Kariwa! — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","— Obuywatwat'ukat opop oduk'a be. Ipi jĩjã opop. Jebit oe'ũat puxim. Iwãtaxipi jĩjã ma. Ikop pa'orean — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","— Ijom puk õn pit, imu'ada am — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","— Ka'ũma, Kariwa — io'e. — Eju g̃u juy oduk'a kay, wa'õbuyxi'ũm puye, Judeu'ũmat õn puye. A'õm ma juy eg̃u'ada. “Ece'ada juy,” i ẽn e'em pima, obuywatwat'ukat je'ada — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","— Õn tak warara'acat mujujum. Wa'õ kay kũyjobit ip wesorarayũ. Pũg̃ pe õn e'em, “Ejẽm,” i bima, je'jẽm. Wara'at pe õn e'em, “Ejot,” i bima, je'dot. Obuywatwat'ukat pe õn e'em, “Imẽn cuy ece,” i bima, imẽn je'e. — Apẽn wesorarayũm wa'õ kay, imẽn tak a'õbi ma obuywatwat'ukat je'ada — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iboap co buje, Jesus itabẽg̃ o'e. — Soat Judeuyũ etabucap podi ma itabut okay ig̃o sorarayũ kukat, Judeu g̃u ma'g̃u — io'e Jesus jenomujuacayũ be. ");
INSERT INTO myu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","— Adeayũ jajẽm ip Deus dopap pe―Judeu'ũmayũ, mesa koreren jabik ãm Abraão eju, Isaque eju dak, Jacó eju dak. Soat eipi bewi jajẽm ip. Pũg̃ ixeyũ'in kaxijẽmap ka bewi jajẽm ip. Wara'acayũ ixeyũ'in kaxiajẽmap ka bewi jajẽm ip, kabi beat soat kukan pima. Icokcok cĩcã e'em ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","— Ajẽmjẽm ip pima, Deus Israel naxeg̃ebitbit joxik ip wũy ma kabiokbog̃ pe. Iboce ma tõtõn jeedop. Tũy yẽyẽy ipi bun jeedop — io'e Jesus jenomujuacayũ be. Ipiat'ajoap ka be iap muwẽnuwẽn o'e Jesus―kabiokat ka be iap. ");
INSERT INTO myu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","— Eju eduk'a kay — Jesus o'e sorarayũ kukukat pe. — Kuy ebuywatwat'ukat o'je'ada, okay etabut puye — io'e Jesus. O'je'ada g̃ebuje bit. Ibuywatwat'ukat o'je'ada. ");
INSERT INTO myu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","O'ju. Jesus oajẽm Pedro duk'a be. Oõm. Pedro daxijo o'jojojo. Ipa'i jĩjã opop xeku. ");
INSERT INTO myu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus o'g̃ucay ipa'iat. O'subaixik. Imẽnpuye ipa'i'ũm o'e. Xipat o'e. O'kop cama bewi. Jesus xat o'g̃ug̃ẽ cebeam. ");
INSERT INTO myu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Katpuje ma iboceayũ ibiõg̃buk kẽrẽat kug̃ayũ o'tujowat ip Jesus kay. Imu'ada am, o'tujowat ip. Ade osodop ip―iwãtaxipiayũ. Ibiog̃buk kẽrẽayũ o'g̃ujẽm Jesus ikukayũ bewi. — Epejẽm — io'e cebe. O'ajẽm ip Jesus a'õbi. Iwãtaxipiayũ dak o'g̃u'ada'ada. ");
INSERT INTO myu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isaías juk o'jekawẽn kuyjeayũ be. Deus ekawẽn muwẽnuwẽn'ukat juk o'jekawẽn. Jesus muwẽnuwẽn o'e. Iwãtaxipipiayũ o'g̃u'ada xeku, ibaca'ũmayũ dak, i juk o'e kuyjeayũ be. Jesus o'g̃ujẽm xipat'ũmayũ jemumukukukayũ xewi―ibiõg̃buk kẽrẽayũ. Imẽn Jesus e'eap puye, soat itaybit o'e icẽmãn Isaías'ũm ekawẽn iam. ");
INSERT INTO myu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Adeayũ o'je'awero ip Jesus kay. Timudek pin Jesus, ade buye. — G̃a'a — io'e. — Iodi atimudek cuy. ");
INSERT INTO myu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Moisés ekawẽn imutaybitbin'ukat tak oajẽm. — Omutaybitbin'ukat — io'e cebe. — Soat ka dag̃ ojekuku eweju ejuap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","— Tapu — Jesus o'e. — Oweju jekukuayũ ya'ũmg̃u jedopdopap'a — io'e cebe―Moisés ekawẽn imutaybitbin'ukat pe. — Kak ikũykẽy. Wasũ dak topipe. Õn pit ka'Ũma. Ya'ũmg̃u odopdopap'a — io'e―Jesus o'e―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","— Kariwa! — io'e wara'at Jesus pe. — Koap webay'ũm ojokot. G̃ebuje cum puk õn eweju — io'e Jesus eju jekukuat. ");
INSERT INTO myu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","— Kã'ã. Ejot cuy okay — Jesus o'e cebe. — Deus ekawẽn kay'ũmat jebadipyũ'ũm'ũm jokot. Ẽn pit ka'ũma. Oweju juy ejekuku — io'e. ");
INSERT INTO myu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kobe be oõm Jesus. O'timukek ip, wĩnãbu o'timudek ip―Jesusyũ. ");
INSERT INTO myu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Timudekdeg̃ pima ip, kabidoxixi oajẽm. Oajẽm iodi kay. Topapũn kobe o'e idibim, kabidoxixi ajẽm puje. Kobe dag̃acat iparara ip o'e kabido buxixim. Jesus pit ixet kobe be. ");
INSERT INTO myu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jesus o'g̃uwurũg̃ ip―ceweju etaybitbinayũ. — Kariwa! — io'e ip. — Ocedaxijom ece. Akõm wuyju! ");
INSERT INTO myu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O'jewurũg̃ Jesus. — Apẽg̃ãm puxim eyparara? — io'e. — Apẽnpuye eyetabutbũt okay? — io'e ipararaayũ be. — Eypararam g̃u juy epesop. Okay juy eyetabut cĩcã. — Ebidopon! — io'e kabido be. — Edipon! — io'e iodi be. Imẽnpuye kabidoxixi o'subido'ũm. Iodi dak tisem cĩcã o'e Jesus a'õbi. ");
INSERT INTO myu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","— Apen ibo o'jebapuk? — io'e ip. — Abu sute? Kabidoxixi o'subido'ũm ya'õbi. Iodi dak kũyjobit ya'õ kay — io'e ip. Jesus muwẽnuwẽn o'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kabido'ũm puje, o'timudek ip. Gadara eipi dag̃ oeku Jesus. Xepxep osodot ip―ibiõg̃buk kẽrẽat kug̃ayũ. Ika'u jĩjã o'e ip. Ce'ũ'ũayũ mõg̃mõg̃ap pewi osodot ip. Bomaku nuynuy soat em. Ixeyũ buxixim, e dag̃ kapkap g̃u o'e ip―ibo ka watwat―Gadara ka watwat. ");
INSERT INTO myu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","— Deus ipot ẽn — io'e ip Jesus pe. — Ag̃ cuy ocesũy. Jajẽm g̃u juy ocekay ipiat'ajoan ocewebe ipi ũm awap ma — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","— Ite ag̃okatkayũ xewi ocemujẽm puje, ocemujum ece dajebaro be―ibiõg̃buk kẽrẽayũ o'e cebe. Imẽn ma o'e ip, dajebaro bomaku wurũrũrũg̃ puye―ade dajebaro. ");
INSERT INTO myu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","— Epejẽm — Jesus o'e. O'jẽm ip ag̃okatkayũ xewi. O'ju dajebaro kay. Oõm. Imẽnpuye dajebaroyũ daudaum o'jenapõn co'a pẽnpẽn tag̃. Iodi be o'kop ip. Oakõmkõm ip. Jeabokabog̃ ip oap. ");
INSERT INTO myu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dajebaro kukukayũ owatwat ip. Soat muwẽnuwẽn o'e ip ag̃oka watwat pe. Dajebaro aokaap awẽg̃ muwẽnuwẽn o'e ip ag̃oka be. Ibiõg̃buk kẽrẽat kug̃ topibiyũ awẽg̃ tak yawẽg̃ muwẽnuwẽn cĩcã o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","G̃ebuje Jesus o'topabe ip―ag̃oka watwat―soat. — Ejẽm cuy oceka bewi — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","O'jẽm. O'jepit Jesus. Jeipi be o'jepit―Cafernaum ka be. O'jepit, waram timudek puje. ");
INSERT INTO myu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ag̃oka watwat ijebit e'ũat o'tujowat Jesus kay. Ixexecap pe ixe ijebit e'ũat o'tujowat ip. Jesus itaybit o'e cekay itabut ip iam. Imẽnpuye o'jekawẽn ijebit e'ũat pe: — A'õcam cuy — io'e cebe. — Ikẽrẽat kuy oju'uk ewebewi, tapu. Iboap ikẽrẽat kay g̃ebum g̃u oce, i'uk puje — io'e. — Pũg̃ em tak ka'ũma — io'e―Jesus o'e ijebit e'ũat pe. ");
INSERT INTO myu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","— Ite Jesus “Deus co'i õn,” i napa ma teku e'em — Moisés ekawẽn imutaybitbin'ukayũ napa ma o'e. Pũg̃pũg̃ ixeyũ'in napa ma o'e jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus itaybit o'e apẽn jewag̃uydadam ip iam. — Apẽnpuye ikẽrẽm epeyewag̃uy? — io'e Jesus Moisés ekawẽn imutaybitbin'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","— “Ikẽrẽat oju'uk ewebewi,” i kuy oce cebe — io'e. — Imẽnpit eyetabut g̃u ikẽrẽat'uk put owebe iap kay — io'e. — “E'ãy,” i oce ibima, “Ecexĩg̃xĩg̃,” i dak, eyetabut g̃u kuka epe'e okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","— Soat wag̃o õn — Jesus o'e. — Wa'õbi teku og̃u'ada. Imu'adaap co buje, “Ja'õbi ma teku o'g̃u'ada,” i epe'e — io'e cebe ip. G̃ebuje Jesus o'jekawẽn ijebit e'ũat pe. — E'ãy — io'e cebe. — Eju eduk'a kay. Exexecap cuy etujowat eweju — io'e. ");
INSERT INTO myu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O'ãy. Jexexecap kug̃ o'ju jeduk'a kay. ");
INSERT INTO myu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Adeayũ iparara jĩjã o'e ip, iboap tobuxik puje. — Ka'ũmg̃u xipacat Deus co'iat — io'e ip. — Deus Jesus a'õ mubacaat puye. Imẽnpuye ixe Jesus pe ikẽrẽat i'uk put wuyxewi — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ibocewi Mateus o'jojojo Jesus. Oajẽm Jesus Mateus kay. Ixe Mateus xik'i osunuy jekapikpikap'a be―iecug̃ap edinheiro bubuap'a be. — Ejot. Oweju ejeku — io'e Mateus pe. O'ãy. Oeku Jesus eju. ");
INSERT INTO myu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mateus tuk'a be oajẽm ip―adeayũ, jekõn ãm. Oabikbik mesa koreren iecug̃ap edinheiro bubu'ukayũ, Deus xe ikẽrẽan e'e'ukayũ dak, Jesus tak, Jesus eju etaybitbinayũ dak. Soat ip oabikbik mesa xe jekõn ãm. ");
INSERT INTO myu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","— Apẽnpuye ixeyũ eju eymutaybitbin'ukat jekõnkõn―iecug̃ap edinheiro bubu'ukayũ eju? Ikẽrẽat mug̃ẽg̃ẽ'ukayũ eju dak? — Fariseuyũ o'e Jesus etaybitbinayũ be. Imẽn kawẽnwẽn o'e ip, Jesus jekõnkõn o'jojojo ip puye. ");
INSERT INTO myu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","O'jede g̃u imutaybitbinayũ. Jesus pit Fariseuyũ o'ya'ĩjojo. O'jekawẽn. — Iwãtaxipi'ũmayũ wuyanũg̃tata'ukat kay je'ju g̃u―iwãtaxipipiayũ acã — io'e. — Imẽnpuxim õn tak jewexe xipacayũ nomuwã ãm g̃u ojot―xipat'ũmayũ nomuwã ãm acã. Ikẽrẽat uk am ixeyũ bewi ojot. Imẽnpuye cekõn ikẽrẽat mug̃ẽg̃ẽ'ukayũ eju — io'e. — Cum cuy eyju eymutaybitbinayũ kay — io'e — eytaybit am apẽn Deus ekawẽntup e'em iam — io'e Jesus Fariseuyũ be. — Imẽn opop ibararakat: Idip ma oxe warara'acayũ eyetabotaidabotbot pima. Imẽnpit idip g̃u oxe warara'acayũ kay g̃u eyetabotaidabotbot pima, obuyxi am carneiroyũ mupig̃ ma'g̃u eyju, i — io'e. — Imẽnpuye ijoce jewexe xipacayũ nomuwã ãm g̃u ojot―xipat'ũmayũ nomuwã ãm acã — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","João Batista eju etaybitbinayũ oajẽm ip Jesus kay. — Apẽnpuye Fariseuyũ jekpiwan ma jewemureren Deus eju kawẽn ãm―oceju dak, eweju etaybitbinayũ bit jekõnkõn ip pima? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","— Oweju etaybitbinayũ jekõnkõn, õn ceweju ip puye. Õn pit ceweju ip'ũm pima, jekõnkõn g̃u ip. Jekpiwan ma jewemureren ip Deus eju kawẽn ãm. Imẽn soat itaybit e'em ig̃uycũg̃ cĩcã ip iam. Õn iwadip puxim. Iwadip cexe ip pima, abu ixeyũ'in ig̃uycũg̃ e'em―jewebumũnap epeta be tomuwãibiyũ'in? Ka'ũma ma! Imẽnpuxim oweju etaybitbinayũ jekõnkõn ip. Jewebumũnap epeta be tomuwãibiyũ buxim ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesus wuymutaybinap ekawẽn o'g̃uwẽn cebe ip―imẽnpuximap ekawẽn. Imẽn o'g̃uwẽn. — Pag̃o iisuan g̃u imuwaketken wuyju―toti iorokat muwaketken. Iisuat pit imuwaket puje, jewa'i'in big̃ ma idieg̃bog̃ e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","— Uva'abidi tiisuati dak acetimõg̃ yaiisuat'a dag̃ — io'e Jesus. — Ya iisuat tag̃'ũm pima, o'jeaebag̃ kuka — io'e. — Imẽnpuye uva'abidi tiisuati acetimõg̃ timũn'a be―yaiisuat'a be, uva'abidi cediepuyat puxixim, tiporoyat puxixim, timun'a'ũmap puxixim — io'e Jesus João Batista eju etaybitbinayũ be. Iboam e'em pima, “Wekawẽn pag̃o iisuat puxim, uva'abidi tiisuati buxim tak,” i'e ojuy osunuy. Imẽn Jesus o'e. Kawẽn iisuat ma Jesus ekawẽn o'e g̃asũ bit. Fariseuyũ ekawẽn tag̃ g̃u o'e, Saduceuyũ ekawẽn tag̃ g̃u o'e dak. ");
INSERT INTO myu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Judeuyũ kukukat tak oajẽm Jesus kay. Ixe osunuy Deus eju kawẽnwẽnap'a kukukat. O'jẽg̃'aecõg̃cõg̃ Jesus topa be, ibuyxi am. — Odaxit g̃axĩn ma oe'ũ — io'e Jesus pe. — Ejot pima bit, eg̃u'ada. Jetait — io'e Jesus pe. — Ebuesubumõg̃ ijeje bima, je'ada odaxit — io'e. ");
INSERT INTO myu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","— G̃a'a — io'e. O'ju ip―Jesusyũ. ");
INSERT INTO myu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Cucum pima, pũg̃ ayacat oajẽm Jesus tomuju, cesay mucay am―Jesus ekabek ukpu mucay am. 12 koato bun ma ixe ayacat iwãtaxipipin o'e, doybucukcug̃ g̃u buye. — Cesay mucay buje ma, oce'ada — ixe ayacat o'e jewebe ma. Jesus ekabek o'g̃ucay. ");
INSERT INTO myu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O'jekorepẽn Jesus. G̃ebuje Jesus ayacat o'jojojo. — A'õcam cuy — io'e ayacat pe. — Etabut okay. Imẽnpuye g̃axĩn ma eceje'ada — io'e. Dao ma o'je'ada ixe ayacat. ");
INSERT INTO myu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oajẽm ip Judeuyũ kukukat tuk'a kay. Ade wãwãm ip osodop. Jebubut'uk muydedeayũ dak o'jojojo Jesus. Imuydedem ip Judeu babi dag̃. Cebabi dag̃ tak wãwã ip osodop. ");
INSERT INTO myu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","— Ce'ũ g̃u teku. Yaypan'isuat ixet ã — io'e Jesus wãwãayũ be. Jesus itaybit o'e yaypan'isuat'ũm oe'ũ iam. Inaka waram imutain. Imẽnpuye “Ixet ã,” io'e. Wãwãibiyũ bit jewaywayway ip o'e Jesus kay. Jesus o'e cebe ip: — Epejẽm uk'a bewi — io'e. O'g̃ujẽm. ");
INSERT INTO myu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ijẽm puje, Jesus oõm yaypan'isuat kay. O'subaixik. Dao ma o'je'ada. Itait o'e waram g̃uto ce'ũ topibit, Jesus o'subaixik puye. Ixe o'kop―ce'ũ topibit. ");
INSERT INTO myu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ipi juayũ ce'ũ topibit awẽg̃ o'yawẽg̃mupõg̃ ip. Jekawẽnwẽn o'e ip soat tag̃―soat ibo eipi dag̃. ");
INSERT INTO myu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesusyũ eipi kukukat ka bewi cẽm puje, xepxep o'ju Jesus tomuju―ita'ũmayũ. — Etabotaidabotbon cuy eg̃uy ocekay — io'e ip. — Ocemu'ada am — io'e ip Jesus pe―Davi'ũm naxeg̃ebit pe―Judeuyũ ajojoyũ'ũm'ũm kukukat naxeg̃ebit pe. ");
INSERT INTO myu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oajẽm ip Jesus kay, ixe jeduk'a be õmõm pima. — Eyetabut tu okay―eyemu'ada õn iap kay? — io'e Jesus cebe ip. — Hm hm — io'e ip. — Ocetabut, kariwa. ");
INSERT INTO myu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","30","O'sutamucay Jesus ita'ũmayũ. O'je'ada. — Eyju eyetabut okay buye, õn jeymu'ada — io'e Jesus itã'ũm topibiyũ be. Itate o'e, Jesus o'sutada buye. — Eymu'adaap epeg̃uwẽn g̃u juy eybureyũ be―ka'ũma be ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Imẽnpit je'adaap o'g̃uypõg̃põg̃ ip soat kaka dag̃. ");
INSERT INTO myu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesusyũ uk'a be cẽmcẽm pima, iboceayũ ibiõg̃buk kẽrẽat kug̃at o'tujowat Jesus kay. Cekawẽn pa'oreat o'e ixe, ibiõg̃buk kẽrẽat kug̃ puye. O'tujowat ip Jesus pe, imu'ada am. ");
INSERT INTO myu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O'je'ada Jesus a'õbi. Ag̃okatkat pewi ibiõg̃buk kẽrẽat cẽm puje, xipan o'jekawẽn ma, o'je'ada buye. — Abu yag̃uyg̃uy imẽn o'jebapuk iam? — adeayũ o'e ip jewewebe. — Ka'ũma ma ijo'iat imẽn wuyjojojo g̃u Israel eipi be―wuyeipi be — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Imẽnpit Fariseuyũ o'jekawẽn. Napa ma o'jekawẽn ip. — Jesus ibiõg̃buk kẽrẽat mujẽmjẽm cebewi ibiõg̃buk kẽrẽayũ kukukat a'õbi―Satanás a'õbi — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","O'ju Jesus ikabog̃atka dag̃, ika'ĩcatka dãg tak. O'ju ag̃oka watwat mutaybitbin. Judeuyũ Deus eju kawẽnwẽnap'a be imutaybitbin o'e. Deus soat kukanap o'g̃uwẽnuwẽn soat pe―kawẽn idipat. Imẽn ma imutaybitbin ip oeku. Ibomaayũ mu'ada'adam oeku: iwãtaxipipiayũ, ibaca'ũmayũ dak―soat mu'ada'adam oeku. ");
INSERT INTO myu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Itabotaidabotbot ma iboka watwat kay Jesus osunuy, yag̃uybabi'ũm osodop puye. Ovelha buxim ip, jekukat'ũm pima ip. Imẽnpuxim ika beacat ikukuk'ukat'ũmayu osodop ip, ka'ũmg̃u ibuywatwat'ukat puye. ");
INSERT INTO myu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Imẽneju Jesus o'jekawẽn jeweju etaybitbinayũ be. — Kadai ya ade opop―kadai'a―yaopat'a. Pũg̃pũg̃ pit omuyku ip yabu am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","— Epeyekawẽn cuy kapikpik'ukayũ kukukat pe. I juy ep'e cebe: “Kapikpik'ukayũ eg̃uju juy kadai'a bu am,” i — io'e Jesus jeweju etaybitbinayũ be. Imẽn Jesus kawẽnwẽn o'e, Jesus eju adeayũ ceku pin ip puye. Apẽn kadai ya ade o'yadop―kadai'a yaopat'a; imẽn tak adeayũ ceku pin ip Deus emunaẽ eju. Imẽnpit pũg̃pũg̃ oekuku Jesus kawẽn muwẽnuwẽn ijodiacat pe. Imẽnpuye imuwẽnuwẽn'ukayũ kukat eju juy jekawẽn ip Deus eju. — Adeayũ juy eg̃uju ekawẽn muwẽn ãm — i juy e'em ip cebe. ");
INSERT INTO myu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus 12 beayũ o'tomuwã―jeweju etaybitbin'ukayũ. O'tomuwã, ja'õbi soat mu'ada am―iwãtaxipipiayũ mu'ada am, ibiõg̃buk kẽrẽayũ mujẽm ãm tak―ja'õbi imujẽm ikug̃ayũ bewi―soat ip pewi. Ja'õbacaap o'g̃ũm cebe ip―12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","12 beayũ ibutet 12 butet pe osodop ip. Ibũrũ ma ibutet osodop ip―Jesus emumujuyũ butet: Koapat Simão i, André i, Tiago i, João i, Filipe i, Bartolomeu i, Tomé i, Mateus i, wara'at Tiago, Tadeu i, wara'at Simão, Judas Iscariotes i. Ibũrũ ma ibutet osodop ip. Wara'at putet Pedro i ibutet osunuy―Simão butet. André Pedro kitpit osunuy. Tiago, João dak, Zebedeu ipotpoyũ osodop. João Tiago kitpit osunuy. Mateus iecug̃ap peam Israel naxeg̃ebitbit xewi dinheiro bubu'ukat osunuy. Wara'at Tiago Alfeu ipot osunuy. Wara'at Simão Israel eipi kay cĩcãat osunuy. Judas Iscariotes g̃uyjom Jesus o'g̃ũm cekay itakomaayũ be yaoka am. Ibũrũ ma osodop ip―12 beayũ―Jesus eju jekuku'ukayũ. ");
INSERT INTO myu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","12 beayũ o'g̃uju Jesus. — Epeju Israel naxeg̃ebitbit kay — io'e cebe ip. — Itabidaoayũ buxim ip — io'e. — Ovelhayũ buxim ip — io'e Jesus. — Wara'at eipi bewiayũ kay epeju g̃u — io'e 12 beayũ be. — Israel naxeg̃ebitbit kay acã juy epeju. Judeu'ũmayũ kay g̃u epeju, Samaria eipi beayũ kay g̃u dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","— “Ijasun Deus soat kukan je'e,” i juy epe'e Judeuyũ be, Israel naxeg̃ebitbit pe cucum pima eyju — Jesus o'e 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","— Iwãtaxipipiayũ epeg̃u'ada juy ip — io'e cebe ip. — Ce'ũ'ũayũ dak epeg̃utait. Waram jetait ip — io'e Jesus. — Ierepayũ epeg̃u'ada juy — io'e cebe ip. — Ibiõg̃buk kẽrẽayũ dak epeg̃ujẽm cuy ibiõg̃buk ikẽrẽat kug̃ayũ bewi — io'e Jesus. — Imẽn epe'e juy wa'õbi―ce'adaap epe'e juy. Epeteida g̃u juy. Imẽn ãm cuk og̃ũm wa'õbacaap eywebe teidam g̃u — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","— Dinheiro epetujowat g̃u juy eyweju. Ouro epetujowat g̃u, prata dak ka'ũma. Cobre dak ka'ũma. Epetujowat g̃u juy dinheiro mũn'a be. ");
INSERT INTO myu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Cucumap pubut mũn'a dak epeyadujowat g̃u juy. Xepxem cuy epetujowat g̃u―eydoti, pũg̃ ma acã. Sandália dak ka'ũma. Eyba'ip tak epeyoptujowat g̃u juy. Eybuywacayũ ma juy eyxan je'g̃ũm. Imẽnpuye eybubut epetujowat g̃u juy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","— Ajẽm pima ag̃oka be jeduk'a be eyg̃uyg̃uy pinat epetobuxik cuy. Ixe duk'a be juy epesopsop, ibo ag̃oka be bima — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","— Ixeyũ duk'a be õmõm pima, epeyekawẽn tuk'a beayũ eju. Kato juy epe'e cebe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","— G̃ebuje eyekawẽn kay ya'õpĩcũg̃cũg̃ je'e ip. Ya'õpĩcũg̃cũg̃ je'e ip, eyekawẽn kay buye. Imẽnpit wara'acayũ eyekawẽn kay'ũm pima bit, ya'õpĩcũg̃cũg̃ g̃u je'e ip. Epajẽm cexe ip. Imẽnpit te'e ma epe'e, “Wuykabia,” cebe ip. “Epeõm,” i g̃u je'e ip, eyekawẽn kay'ũm puye. ");
INSERT INTO myu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","— Eykay'ũmayũ bewi epejẽm cuy, eyekawẽn kay'ũmayũ bewi dak. Cẽm pima eyesandália epeg̃upoypoy, “Deus ipiat supi'ajoat eywebe ya'õ kay'ũm puye” iap mubapuk am ibo ka watwat pe. Imẽn cuy epe'e cebe ip, ag̃oka bewi wan pima, uk'a bewi wan pima — Jesus o'e 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","— Deus kũyjobit'ũmayũ be ipiatpi'ajoap kabia bima, Sodoma ka watwat pe ipiat supi'ajoat, Gomorra ka watwat pe dak. Ixeyũ be iap podi ma bit ibo ka watwat pe ipiat supi'ajoat, eyekawẽn com ip ibu'u buye. Iboap kay g̃ebum cuy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","— Ya'õpicũg̃ cuy epesop — io'e cebe ip. — Eymujum õn. Ovelha buximayũ eyju. Widayũ parakpe eyju ovelhayũ buxim. Imẽnpuxim eykay itakomaayũ parakpe eyju. Ovelhayũ be bit i'e baõre akuriceyũ be. Imẽnpuxim eywebe i'e ba'ore eykay itakomaayũ be. — Wa'õbi eyju buje, itaybit cĩcãayũm epesop. Ag̃ cĩcã juy epesop. Dao g̃u juy eyetakomãm cekay ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","— Ag̃ cuy epesop — io'e. — Eykay itakomaayũ jeydaomũn. Jeydujowat ip wuyekawẽn coco'ukayũ be. Jeymupokupok ip Deus eju kawẽnwẽnap'a be jetakomaap kay. Ixee bum jeymupokupok ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","— Eyju webekitkit puye jeydujowat ip ipi kukayũ be, kariwawayũ be dak. Jeydujowat itaybit am eyetabucap xipat cexe ip iam ma, eyetabucap xipat'ũm cexe ip iam pit. Kawẽn idipat epeg̃uwẽn cebe ip, Judeuyũ'ũmayũ be dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","— Eyag̃uybabi'ũm g̃u juy epesop, eyetaybit'ũm puye ajom epeyekawẽn iam, apẽn epeyekawẽn iam tak. Eydujowatwan pima ip, Deus o'g̃uwẽn eywebe ajom epeyekawẽn iam. Imẽn jeymutaybin. ");
INSERT INTO myu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wa'õbi juy epeyekawẽn. Imẽn epeyekawẽnwẽn Deus biõg̃buk ma kawẽnwẽn je'e eywebewi―Wuyebay biõg̃buk — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","— Adeayũ jebadipyũ kay itakoma je'e, ixeyũ webekitkit puye. Iwag̃o jekitpit tujowat cekay itakomaayũ be yaoka am. Ikitpit tak jewag̃o tujowat yaoka am. Ipotpet tak itakoma jĩjã je'e jebay kay. Jebay tujowat cebe ip, yaoka am — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","— Soat ixeyũ itakoma jĩjã je'e eykay, eyju webekitkit puye. Ipiat pibun eyetaxi bima, Deus a'õ dag̃ jekukum cuy eyju. G̃uyjom Deus jeymuyu, cexe soat em eyedop am — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","— Eywebe ipiat supi'ajojo bima, epeyenapõn cuy. Imẽn e'e ip pima pũg̃ ka be, epeyenapõn cuy wara'at ka be―ag̃oka be — io'e cebe ip. — Soat wag̃o õn — Jesus o'e. — Waram wajẽm awap, ade ag̃oka dag̃ epeju―Israel naxeg̃ebitbit eipi dag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","— Imutaybitbin'ukat podi g̃u je'e jeweju etaybitbinayũ itaybit ip. Kariwa dak podi g̃u dak je'e jekapikpig̃'ukayũ kapikpig̃ ip. ");
INSERT INTO myu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Imẽnpuye kapikpig̃'ukayũ icokcog̃ cuy jeedop ip, jekariwa buximayũ ip puye. Itaybitbinayũ dak icokcog̃ cuy jeedop ip jemutaybitbin'ukat buximayũ ip puye. Ijoceayũ cekariwa a'õ ya'õmuy ip pima, “Belzebu teku,” i bima ip, cebekitkit a'õ dak ijo'i ma ya'õmuy je'e ip. Cekariwa omuymuy ip pima, cebekitkit tak imuymuy ip cekariwa muymiyap podi ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","— Eypararam g̃u juy epesop ixeyũ e'eap puxixim — io'e jebekitkit pe. — Yajuyjuyat jewedobuxik g̃uyjom. Iba'arẽmat ibapuk je'e soat xe. ");
INSERT INTO myu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Imẽnpuxim ajo og̃uwẽn eywebe, kawẽnwẽn wuyeweweju ma, ijop epeg̃uwẽn soat pe g̃uyjom — io'e. — Ibidadaap kay epeya'ĩjojo, ijop soat pe epeg̃uwẽn g̃uyjom — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","— Eypararam g̃u juy epesop eyaoka ojuyayũ buxixim — io'e jebekitkit pe. — Wuyejebit aoka but ip. Imẽnpit wuybiõg̃buk aoka ba'ore cebe ip — io'e. — Deus puxim pit cuy eypararam epesop. Wuyejebit muy'ũm put cebe, wuybiõg̃buk tak. Ipiat'ajojoap pe imu'ũm put — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","— Xepxep pe pidiwe dei tei'ĩt ma―pũg̃pũg̃ centavo ma―wasũ yopĩcat tei. Imẽnpit pũg̃ wasũ yopĩcat at'an pima, Deus itaybit ixe wasũ o'at iam. Deus a'õbi acã je'at — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","— Deus xe teibõg̃ g̃u wasũdei. Imẽnpit ag̃ cekay. Imẽnpuxim wuykay dak ag̃ soat em. Deus itaybit wuyadap peburũdap iam. Imẽneju eyag̃uybabi'ũm'ũm g̃u juy epesop. Deus soat itaybit wuyekuku iam — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","— Eyju “Jesus ebekitkiyũ oceju,” i soat pe e'em pima, õn tak “Teyũku webekitkit,” i oce webay be―kabi beat pe — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","— Eyju bit e'em warara'acayũ be, “Jesus bureyũ g̃u oceju,” i bima, õn tak “Iteyũ bure g̃u õn,” i oce Webay be―kabi beat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","— Epeyewag̃uy g̃u juy: “Jesus osodot kaba'ũm wuydop am,” i. Ojot puye, ipi watwat pe wara'at tag̃tag̃tag̃ ma jekuku. Itakoma je'e ip jewewekay. Pajam jewaokakam je'e ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","— Ibadipyũ itakoma cĩcãayũ je'e jewewekay, pũg̃pũg̃ ixeyũ'in okay itabut puye — Jesus o'e. — Cebay ma okay je'e. Ipot pit okay g̃u je'e. Ixi ma okay je'e. I'iyũ okay g̃u je'e―ayacayũ. I'it tayxi okay g̃u je'e. Yuktayxi okay je'e. Imẽneju wara'at tag̃tag̃tag̃ ma jeku ip — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","— Eyebay kayap podi ma okay'ũm pima, oweju jekukuayũ g̃u epesop, eyxi kayap podi ma dak, eyekpotpoyũ kayap podi ma dak, eydaxityũ kayap podi ma dak. ");
INSERT INTO myu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Owebeam je'ũ ibu'u'ũmat puximayũ acã webekitkit ma oxe. Korosa jeje je'ũ ãm, korosa dujuwatwan õn pima, webekitkit tak cucum onomuju. Cucum ip korosa kug̃, je'ũ ãm. Apẽn ag̃okatkat korosa dujuwatwan cucum, korosa jeje jebamupayam je'ũ ãm; imẽnpuxim cuy epeku soat em owebeam je'ũ ibu'u'ũmat puxim. ");
INSERT INTO myu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","— Eye'ũ bima, õn ma obuyxi eyxe buye, ibin ma soat em eyetabẽg̃ epesop Deus xe. Eywebe ma jewag̃uyg̃uy: “Õn ma obuyxiat,” i bima bit, soat em ipiat'ajojoap pe epesop eye'ũ buje — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","— G̃asũ epeju Israel naxeg̃ebitbit kay. Wa'õbi epeju — Jesus o'e jeweju etaybitbinayũ be. — Pũg̃ ixeyũ'in eyewebe je'e, “Epeõm,” i. Imẽnpuxim ma owebe dak je'e ip — io'e Jesus. — Imẽnpuxim ma og̃ujuiat pe dak je'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","— Deus ekawẽn muwẽnuwẽn'ukat pe dak je'e, “Eõm,” i. Ixe dak iõm pin, Deus ekawẽn muwẽnuwẽn'ukat puye. Iõm pin. Imẽnpuye Deus cekapikaptei je'g̃ũm cebe, kapikaptei ũmũm pima jekawẽn muwẽnuwẽn'ukat pe. — Cũg̃ cĩcãt pe dak je'e, “Eõm,” i. Ixe dak iõm pin, cũg̃ cĩcãat puye. Iõm pin je'e. Imẽnpuye Deus cekapikaptei je'g̃ũm cebe, kapikaptei ũmũm pima cũg̃ cĩcãat pe. ");
INSERT INTO myu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wara'acat webekit'isuat pe idibi ma tiũm ticukati, ixe webekit puye, Deus tak xipacat je'g̃ũm idibiũmat pe — io'e. — Iboap kay g̃ebum cuy epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ibocewi o'ju Jesus ag̃okaxiriyũ be. Wũy g̃u osodop boyũku. 12 beayũ muju bujep, ag̃okaxiri beayũ mutaybit am o'ju. Deus ekawẽn muwẽnuwẽn oeku Jesus. ");
INSERT INTO myu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","João Batista Cristo awẽg̃ o'yawẽg̃coco daomũnmũnap'a be. Bekitkit o'g̃uju Jesus kay. Jeweju etaybitbinayũ o'g̃uju João. O'g̃uju, ja'õ daxijo am. ");
INSERT INTO myu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","— “Deus emumuju ajẽmap wiwim oceju,” i juy epe'e cebe — io'e João. — “Ẽn ma du ixe? Wara'at g̃u xe'e ocejowiwi?” i juy epe'e cebe — io'e João. — Hm hm — io'e ip. João a'õ daxijo am o'ju ip. Oajẽm ip cekay―Jesus kay. — Ẽn ma du omuykuiat? Wara'at g̃u xe'e ocejowiwi? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","— Epeyepit cuy João kay — io'e cebe ip. — Epejojojoiap cuy epeg̃uwẽn João be, epekũyjojoiap tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","— Ita'ũm topibiyũ o'e itate g̃asũ. Taokẽrẽ topibiyũ dak xipan ip o'e jexĩg̃xĩg̃ g̃asũ. Ierep topibiyũ dak xipan o'e g̃asũ. Ya'õpi'ũm topibiyũ dak ya'õpipe o'e ip. Jekũyjojom ip o'e. Ce'ũ topibiyũ dak waram itabẽg̃ o'e g̃asũ. Tadaibotbocayũ dak kawẽn idipat cocom g̃asũ―Deus ipot awẽg̃ cocom. ");
INSERT INTO myu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","— Imẽneju: “Ecokcog̃ eg̃uy okay etabut am ebu'u'ũm pima. ‘Ite g̃u omuykuiat,’ ie'em pima bit, ecokcog̃ g̃u eg̃uy,” i juy epe'e João be — io'e Jesus. — Hm hm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cẽmcẽm ip pima, Jesus João o'g̃uwẽn ibo ka beayũ be. — João jom cuk epeku uk'a'ũmat pe — io'e Jesus. — Pãm ixe João? Ajo-buxim ixe o'e? Ip'ũn'ũn kay kabido ajẽm puje, je'ipe'adedem. Yag̃uykorerenayũ ite'ip puxim, soat em jeweg̃uy muwarurururun puye. João bit yag̃uykoreren g̃u. Ite'ip puxim g̃u. ");
INSERT INTO myu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","João doti teibog̃ g̃u. Teibog̃at kukayũ adeayũ kukat tuk'a be opop ip―ibubut adeayũ. ");
INSERT INTO myu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","João bit ibubut adeat g̃u. Deus ekawẽn muwẽnuwẽn'ukat xeku. Warara'acat podi ma João ya'õbuyxi―Deus ekawẽn muwẽnuwẽn'ukayũ bodi ma. ");
INSERT INTO myu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","— Imẽn Deus ekawẽntup e'em―João muwẽg̃aptup: Ag̃ cuy epesop, ie'em Deus, i. Wemumuju og̃uju ewap ajẽm puje, emuxipan am, i. Imẽn e'em Deus ekawẽntup―João muwẽg̃aptup — io'e. ");
INSERT INTO myu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","— Kuyjeayũ bodi ma João ya'õbuyxi. Ka'ũma ma omuy João Batista jo'i ya'õbuxian. Deus xe bit―kabi beat xe bit―yopĩcat João bodiat ya'õbuyxiat wekawẽn kayayũ'in — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","— Ixe João Deus awẽg̃ o'yawẽg̃tojot ipi juacat kay―Deus soat kukanap awẽg̃. Iboap awẽg̃cocom pima ip, cekay jĩjã ip, Deus xe nuynuy pin cĩcã ip puye. Imẽn g̃asũ dak cekay jĩjã ip — io'e. — Deus xe ajẽm pin ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","— João ajẽm awap, Deus ekawẽn muwẽnuwẽn'ukayũ dak iboap awẽg̃ cuk o'yawẽg̃tojot―soat ip. Imẽn tak Moisés ekawẽn tup e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","— Iboap awẽg̃ kay eyetabut pima, eyetabun tak Elias jajẽmiap João jo'i ma oajẽm. ");
INSERT INTO myu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Epeya'õpicũg̃cũg̃ cuy epesop — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesus waram o'jekawẽn adeayũ eju. — Og̃uwẽn eywebe, abu-buxim g̃asuacat iap iam eyetaybit am. Bekitkit puxim ixeyũ―pasiaham ip iap pe pubutbucayũ buxim. Jewãwãwãm ip jebureyũ―bekitkiyũ. ");
INSERT INTO myu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tẽg̃tẽg̃'a oceyamuyde eywebe ya'ĩjo am. Eydaobu'u'u eyju bit da'i'in,” ie'em ip. “Wa ocesop jewexe i'ũmcocom. Eybu'u eyju bit oceweju totõn,” ie'em ip. Ijoyũ buxim g̃asũacat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","— João Batista oajẽm eykay. Ixe vinhodi o'tikõn g̃u. Ire oeku Deus eju jekawẽn ãm. Soat pit napa ma e'em João muwẽnuwẽn: “Ibiõg̃buk kẽrẽat kukat teku,” i. ");
INSERT INTO myu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","— Soat wag̃o õn. Ojot eykay. Soat xat o'om ojeku, soat tikõnkõn tak. Soat pit napa ma e'em omuwẽnuwẽn: “Ika'o'on'ukat teku,” i. “Teku iecug̃ap peam dinheiro bubu'ukat pure,” i dak. “Teku ikẽrẽat mujurũg̃rũg̃'ukat pure,” i dak — io'e. — Wuyju Deus emumutaybitbinap tag̃ jekukum pima bit, warara'acayũ je'e omuwẽnuwẽn, João muwẽnuwẽn tak, “Deus xe cũg̃ ma wuymutaybitbin,” i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesus tak o'jekawẽn iboceat pe. Ikẽrẽan e'e'ukayũ muwẽnuwẽn o'e Jesus. Ikẽrẽat epere'ũmayũ muwẽnuwẽn o'e. Ikẽrẽat kug̃ o'e ip. Imẽnpit ig̃uycũg̃ g̃u ip ikẽrẽat kay. Jesus a'õbi iba'oreat cuk o'jebapuk ixeyũ etabun. Jesus a'õbi o'jebapuk. Imẽnpit ikẽrẽat mujurũg̃rũg̃. Imẽn o'e―Corazim ka watwat o'e, Betsaida ka watwat tak, Cafaranaum ka watwat tak. ");
INSERT INTO myu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","— Karem ma ipiat epesupi'ajo jĩjã, Corazim ka watwat! — Jesus o'e. — Karem ma ipiat epesupi'ajo jĩjã, Betsaida ka watwat — io'e. — Ka'ũma buk epejojojoiap cuk adi og̃ubapukpuk eyetabut pe eyka be bima — io'e. — Tiro ka be iboap mubapuk pima, Sidom ka be dak, kajuk ikẽrẽat mujurũg̃rũg̃ap o'jepere ip―ibo ka watwat. Itabut kajuk ip Deus kay — io'e. — Ibo ka be iboap mubapuk pima, kajuk ikurususucat o'g̃uõm ip jedotim. Daxa daypibewiaptõm tak kajuk o'tõmõg̃ ip jabi jeje. Imẽn kajuk o'e ip, “Oceg̃uycũg̃ cĩcã ikẽrẽat kug̃ oceju buye” iap mubapuk am; “G̃asũ bit ikẽrẽat ag̃ug̃ẽ g̃u” iap tak mubapuk am jebureyũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","— Deus kũyjobit'ũmayũ be ipiat supi'ajoat iap kabia bima, Tiro ka watwat pe ipiat supi'ajoat, Sidom ka watwat pe dak. Imẽnpit Tiro ka be iap podi ma, Sidon ka be iap podi ma dak eywebe ipiat supi'ajoat. Iboap kay g̃ebum cuy epesop — io'e Jesus Corazim ka watwat pe, Betsaida ka watwat pe dak. ");
INSERT INTO myu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","— Cafarnaum ka watwat! — io'e. — Deus jeymuyu g̃u kabi kay — io'e Jesus. — Jeymukop ipiatpi'ajojoap kay bit. Ka'ũma buk epejojojoiap cuk adi og̃ubapukpuk eyetabut pe eyka be bima oce — io'e. — Iboap mubapuk pima Sodoma ka be, ikẽrẽat kajuk o'jepere ip. Deus kajuk ag̃oka o'sukamupik g̃u — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","— Deus kũyjobit'ũmayũ be ipiat supi'ajoat iap kabia bima, Sodoma ka watwat pe ipiat supi'ajoat, Tiro ka watwat tak. Imẽnpit Sodoma ka be iap podi ma Deus ipiat supi'ajoat eywebe. Iboap kay g̃ebum cuy epesop — io'e Jesus Cafarnaum ka watwat pe. ");
INSERT INTO myu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","— Jesus o'e g̃ebuje bit. — Bay — io'e. — Ẽn acã soat kukukat―kabi beacat kukukat, ipijuacat kukukat tak — io'e. — Apẽn ẽn e'em iap mubapukpug̃ ẽn jewexe itaybit cĩcãayũ be g̃u―imutaybitbin'ũmayũ be acã — io'e. — Ixeyũ acã wekawẽn imutaybitbin ẽn. Imẽn xipat oxe. Ocokcok cĩcã imẽn ebikuy buye. Ocokcok cĩcã xipat exe buye dak — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","— Soat ma juk Webay o'g̃ũm owebe — io'e cebe ip. — Warara'acat g̃u itaybit abu Deus ipot iam―cebay acã. Imẽnpuxim warara'acat g̃u itaybit abu ipote bay iam―ipot acã. Jebay mubapuk am, ipot ibikuy bima acã warara'acat itaybit je'e abu Deus iam — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","— Okay epesot. Ikẽrẽat oju'uk eywebewi — io'e Jesus cebe ip. Deus a'õ kay kũyjobit ojuy ip. Imẽnpit kũyjobit g̃u ip. ");
INSERT INTO myu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","— Eymutaybitbin oce. Webekitkit e'em. Wa'õpurug̃'ũmat õn. Wag̃uybabibi. Yobog̃at pin g̃u owexe. Eywebewi ikẽrẽat oju'uk. ");
INSERT INTO myu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wa'õ kayap iba'ore g̃u imug̃ẽ ãm. Kũyjobit am okay dak iba'ore g̃u eywebe. Wara'at ikẽrẽat kay eyebu'um epe'e, eywebewi ikẽrẽat oju'uk puye — Jesus o'e soat pe. ");
INSERT INTO myu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","G̃ebuje Jesusyũ o'ju trigodip tag̃. Sábado bima o'ju, Judeuyũ jebodoydoyap kabia bima. Trigodadot o'tadot'uk ceweju etaybitbinayũ. Trigoda o'tabu ip, jerere buye. O'ta'o'o ip. ");
INSERT INTO myu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ta o'om pima, Fariseyũ ixeyũ o'jojojo. Jesus eju etaybitbinayũ o'jojojo ip. — Ak'i! — Fariseyũ o'e Jesus pe. — Eweju etaybitbinayũ Moisés ekawẽn tag̃ g̃u jekuku ip. Jebodoydoyap kabia be kapikpig̃ ip. Cũg̃ ma g̃u e'em ip. Trigodadot uk'ug̃ ip. Imẽnpuye ikẽrẽat kug̃ ip, wuywebe jebodoydoyap kabia be kapikpi buye — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","— Tã. Ikẽrẽat kug̃ g̃u ip — io'e Jesus. — Kuyje Davi oõm Deus eju kawẽnwẽnap'a be. Ire bima, oõm Davi, cewejuyũ dak. Deus emesa bewi paõ'a o'ya'o'o ip―Deus etabixe o'yamõg̃ ip iat'a―paĩyũ be acã ya'o pi g̃u iat'a. Moisés ekawẽn tag̃ g̃u ijop'a o'ta'o'o ip―Daviyũ. Apẽn Davi o'e'e iaptup opop Deus ekawẽntup pe. Kuy epetupcoco―iboaptup — io'e Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","— Deus eju kawẽnwẽnap'a be paĩyũ kapikpig̃ ip soat kabia. Jebodoydoyap kabia jekukum ip Moisés ekawẽn tag̃ g̃u yabog̃at'a be. Wara'at tag̃ jekukum ip, kapikpig̃ puye. Imẽnpit ikẽrẽat kug̃ g̃u ip Deus xe. Iboaptup ekawẽn eyetaybit―Deus ekawẽntup. Kuy epetupcoco―iboaptup tak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","— Icẽmãn ocekawẽn eywebe. Deus eju kawẽnwẽnap'a Israel naxeg̃ebitbit o'yamuy―yabog̃at'a. O'yamuy ip, wuyju yamubuyxin am. Imẽnpuye Deus eju kawẽnwẽnap'a kukukayũ ya'õbacaayũ. Imẽnpit ya'õbaca jĩjãat omuy ijoce g̃asũ — io'e Jesus cebe ip. Jewebe ma o'e Jesus, “ya'õbaca jĩjãat” i'e'em pima. ");
INSERT INTO myu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Warara'acayũ kay eyetabotaidabotbocap kay õn, i Deus juk o'e — io'e Jesus cebe ip. Owebeam carneiro mupikap kay g̃u bit õn―eyetabotaidabotbotap kay acã, i — io'e Jesus. Ijoptup ekawẽn eyetaybit pima, “Ikẽrẽat kug̃ ip,” i kajuk epe'e g̃u ikẽrẽat kug̃'ũmayũ muwẽnuwẽn pima — io'e Jesus Fariseyũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","— Soat wag̃o õn. “Epeyekapik cuy,” i õn e'em pima jebodoydoyap kabia be dak, cedag̃ kuka o'e eyekapikap Deus xe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","O'ju Jesus ibocewi. Oajẽm Deus eju kawẽnwẽnap'a kay―Judeuyũ e'aweroroap'a kay. Oõm. ");
INSERT INTO myu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","G̃ebuje ag̃okatkat o'tobuxik ig̃o'a be. Pũg̃bũnũ'a o'subũnũ'anũy ibũnũ'akẽrẽ. Pũg̃pũg̃ o'je'aweroiayu'in Jesus muymuy ojuy ip. — Jesus Moisés ekawẽn tag̃ g̃u jekukum — i'e ojuy ip warara'acayũ be. Imẽnpuye: — Jebodoydoyap kabia bima, xipat tu exe ibũnũ'a kẽrẽat mu'ada am? Imẽn tu Moisés ekawẽn tag̃ ma? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","— Xipat Moisés ekawẽn tag̃ warara'acayũ ikukpin wuyxe bima — Jesus o'e Fariseuyũ be. — Jebodoydoyap kabia bima eyõhõ o'at pima ipikũykũy be i'uk'ug̃ ip ipikũykũy bewi―ixe ovelha — io'e. — Abũ jeõhõyũ ug̃ g̃u? Ka'ũma ma. Ovelha ikukpin ip, jeõhõyũ buye. Imẽnpuye i'ug̃ ip. Imẽn tak wuyju ovelha bodi ma wuykukpin Deus xe. Imẽnpuye xipat Moisés ekawẽn tag̃ wuywebe xipacat mug̃ẽ ãm jebodoydoyap kabia be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","— Paya'i ece ebu — io'e ibũnũ'a kẽrẽat pe. O'jewebũmupaya. O'je'ada ibũnũ'a kẽrẽ topibit. Wara'atpunu'a jo'i o'e. Ibũnũ'adip o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseuyũ bit o'jẽm yabewi. O'jewede ip Jesus xewi. O'jewawẽ ip Jesus aoka am, kapikpig̃ Sábado kabia be buye. ");
INSERT INTO myu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Imẽnpuye Jesus o'ju ibocewi. Fariseuyũ ekawẽn itaybit puye, o'ju. Adeayũ o'ju Jesus tomuju. Iwãtaxipipiayũ o'g̃u'ada'ada―soat ip. ");
INSERT INTO myu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","— Wawẽg̃ epeyawẽg̃muwẽn g̃u juy. Pũg̃ em tak ka'ũma — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ibo o'jebapuk apẽn Deus ekawẽn muwẽnuwẽn'ukat o'e iap tag̃―apẽn Isaías kuyje o'e iap tag̃. ");
INSERT INTO myu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Deus o'e: Ija otaẽiat―obuywatwat'ukat―õn cekay jĩjãiat―omucokcokcok'ukat. Obiõg̃buk ojomõg̃ cebe. Ajo cũg̃ ma oxeiap g̃uwẽn soat pe―Judeu'ũmayũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ya'õxikxig̃ g̃u je'ku. Jewãwãm g̃u je'ku. Soat ka dag̃ tak kawẽnwẽn g̃u je'ku. ");
INSERT INTO myu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ikẽrẽan e'e jĩjãayũ daxijo xeku ikẽrẽat pewi. Okay itabut cĩcã'ũmayũ g̃utabut cĩcã okay. Imẽn ma je'kuku soat pewi ikẽrẽat uk'ug̃―Deus kayayũ bewi. ");
INSERT INTO myu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Soat ipi juacat Deus emunaẽ kay je'e, i. Imẽn Isaías o'g̃uwẽn kuyjeayũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","G̃ebuje iboceayũ ag̃okatkat o'tujowat. Ita'ũmat osunuy ixe ag̃okatkat. Cekawẽn pa'oreat tak o'e ixe, ibiõg̃buk kẽrẽat imuyde'ũm'ũmm puye. O'tujowat ip. O'je'ada Jesus a'õbi. Ijojom o'e, o'je'ada buye. Xipan kawẽnwẽn o'e―ibiõg̃buk kẽrẽat kug̃ tũibit o'e, o'je'ada buye. ");
INSERT INTO myu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iboceayũ yag̃uybabi'ũm o'e ip―soat ip. — Davi naxeg̃ebit paxi sute? — io'e ip. Jesus muwẽnuwẽn o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseuyũ bit Jesus awẽg̃ o'yawẽg̃coco. — Ixe Jesus ibiõg̃buk kẽrẽayũ o'g̃ujẽm ag̃okatkayũ bewi Belzebu a'õbi―ibiõg̃buk kẽrẽayũ kukukat a'õbi―Satanás a'õbi ma — i napa ma o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus itaybit osunuy apẽn ixeyũ jewag̃uyg̃uy iam. — Pũg̃ eipi watwat jeweweju ma jewaoka buje, jewemu'ũm ip. Pũg̃ ka kukukat jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma. Pũg̃ tiwat kukakat pe jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma — io'e Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","— Imẽnpuxim Satanás pe jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma. Imẽn Satanás a'õbacaap mu'ũm kuka o'e. Imẽneju Satanás ja'õbacaap ũmũm g̃u owebe ibiõg̃buk kẽrẽayũ mujẽm ãm―jebekitkit mujẽm am — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","— Belzebu a'õbi õn ibiõg̃buk kẽrẽat mujẽmjẽm pima, abu a'õbi dak eyebekitkiyũ imujẽmjẽm ip? Jewemug̃uykukukum eceju iap mubapukpug̃ cĩcã eyebekitkiyũ. ");
INSERT INTO myu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","— Deus biõg̃buk a'õbi ibiõg̃buk kẽrẽayũ og̃ujẽm. Belzebu a'õbi g̃u og̃ujẽm. Ibiõg̃buk kẽrẽayũ o'jẽm ip puye, kuy eyetaybit Deus soat kukukan je'e iap mubapukpug̃ õn eywebe iam — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","— Wuyõm pa'ore wuykay isapka'oreat tuk'a be ibubut pu am. Imukirig̃ acã koam — io'e. — Imukirik puje bit, wuyõm put soat pu am―uk'a beap pu am — io'e Jesus. Imẽn Jesus o'e, jebacaap Satanás ebacaap podi ma buye. Ibodi ma buye, Jesus pe ibiõg̃buk kẽrẽayũ mujẽm put ikukayũ xewi. ");
INSERT INTO myu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","— Imẽn tak okay'ũmat itakoma okay — io'e Jesus. — Webekitkit mu'awerom obuywatwat'ũmat imuypõg̃põg̃põg̃―webekitkit muypõg̃põg̃põg̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","— Imẽnpuye og̃uwẽn eywebe. Ipi juacayũ be Deus muymuy buje, iboap imuymuyap kay soat em Deus g̃ebum g̃u je'e. Deus iboap ju'uk cebewi ip. Ixeyũ be Deus biõg̃buk muymuy buje bit, iboap imuymuyap kay soat em Deus g̃ebum je'e. Cebewi ip iboap i'uk pa'ore Deus pe; apẽn eyju napa ma e'em, “Ijop e'eap Satanás a'õbi o'jebapuk,” i. Imẽn tak kuy eyetaybit Deus a'õbi ijop e'eap o'jebapuk iam — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","— Soat wag̃o õn — io'e Jesus. — Omuymuy puje ip, Deus jeg̃ebu g̃u iboap kay soat em. Iboap ju'uk cebewi ip. Deus biõg̃buk muymuy ip pima bit, Deus jeg̃ebu iboap kay soat em―g̃asũ, waram tak g̃ebum je'e. Iboap kug̃ jeedop ip soat em―ikẽrẽat kug̃―Deus biõg̃buk muymuyap kug̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","— Wuyetaybit yopkẽrẽat'im. Yopkẽrẽat'ip puye, ya'a e'em yakẽrẽat'a. Wuyetaybit yoptipat'im tak. Yoptipat'ip puye, ya'a e'em yadipat'a. Yoptipat'ip, ya'a dak soat em jeenuy yaku. Yapkẽrẽat'ip pit, ya'a dak soat em jeenuy yakẽrẽat'a. ");
INSERT INTO myu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imẽn puybu tuypiatpu buximayũ eyju, ikẽrẽat kug̃ cĩcã buye. Iba'ore dak eywebe idipat ekawẽn muwẽn ãm. Apẽn wuyju jewag̃uyg̃uy wuywebe, imẽn wuyju e'em. Imẽn tak iba'ore g̃asũacat pe idipat ekawẽn muwẽn ãm, yag̃uykẽrẽ buye. ");
INSERT INTO myu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Apẽn xipacat idipap uk'ug̃ imuxipanpanap'a bewi, imẽn tak wuyag̃uydip pima, wuyekawẽn tak idip ma e'em, wuye'eap tak. Wuyag̃uy nomuju ma wuyju jekawẽnwẽn. Xipat'ũmat idi'ũmap uk'ug̃ imuxipanpanap'a bewi. Imẽn tak wuya'g̃uydip'ũm pima, wuyekawẽnkẽrẽ e'em, wuye'eap tak — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","— Og̃uwẽn eywebe. Wuyekawẽntip pima, “Idip ma eyju oxe,” i je'e Deus wuywebe kũyjobit'ũmayũ be ipiat supi'ajoap kabia. Wuyekawẽnkẽrẽ bima bit, “Ikẽrẽat kug̃ eyju oxe,” i je'e Deus wuywebe. — Deus ipiatpi'ajoan kũyjobit'ũmayũ be iap kabia bima te'e ma juk adi acekawẽn iap ag̃uwẽn Deus pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","— Ocekukukat! — Fariseuyũ o'e cebe. — Ka'ũma buk ocejojojoiap eg̃ubapuk cuy ocewebeam — io'e ip. Imẽn tak Moisés ekawẽn imutaybitbin'ukayũ o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","— Ka'ũma — io'e. — Ikẽrẽat kug̃ eyju. Deus kay eyetabut g̃u. Ka'ũma buk eyejojojoiap co pin eyju. Imẽnpit og̃ubapuk g̃u eywebeam. Jonas awẽg̃ acã ka'ũma buk eyejojojoiap tieg̃ e'em eywebeam―Deus ekawẽn muwẽnuwẽn'ukat awẽg̃ — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","— Soat wag̃o õn — io'e Jesus. — Ixe Jonas osunuy ebapũg̃ kabia axima yobog̃at uk pe. Ebapug̃ ixima osunuy dak. Apẽn Jonas osunuy axima yobog̃at uk pe, imẽnpuxim ma og̃uy ebapũg̃ kabia ipi be, ebapũg̃ ixima dak — io'e Jesus. — Deus a'õbi ixe Jonas o'jẽm axima yobog̃at uk pewi. Cejẽmap Nínive ka watwat pe ka'ũma buk o'jojojoiap osunuy. Õn tak imẽnpuxim Deus a'õbi waram ocetait we'uap tomukadi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","— Kuyje Nínive ka watwat ig̃uycũg̃ o'e ip ikẽrẽat kug̃ puye ip — Jesus o'e. — Ikẽrẽat mujurũg̃rũg̃ap o'jepere ip―ikẽrẽat e'e'ukayũ. O'jepere ip, Jonas pe Deus ekawẽn o'tojot puye. Deus ipiatpi'ajoan kũyjobit'ũmayũ be iap kabia Nínive ka watwat je'bapuk soat etabut pe. Ixeyũ je'e g̃asũacat pe: “Eyju ikẽrẽat kug̃ Deus xe,” i, eyju wekawẽn kay'ũm puye. Jonas kay o'e ip Deus ekawẽn muwẽnuwẽn pima Jonas. Õn pit Jonas etaybicap podi ma wetaybit cĩcã Deus ekawẽn muwẽn ãm. Imẽnpit eyju wekawẽn kay g̃u — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","— Kuyje kaxi etajoreg̃at ka kukat oajẽm wũyat ka bewi. Ayacat oajẽm Salomão ekawẽn co am―itaybit cĩcãat ekawẽn co am. — Deus ipiat'ajoan kũyjobit'ũmayũ be iap kabia ixe ayacat je'bapuk soat etabi xe. “Ikẽrẽat kug̃ eyju Deus xe,” i je'e g̃asũacat pe, eyju wekawẽn kay'ũm puye. Salomão kay o'e ixe, taybit cĩcãp muwẽnuwẽn pima Salomão. Õn pit Salomão etaybicap podi ma wetaybit cĩcã. Imẽnpit eyju wetaybicap kay g̃u — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","— Ag̃okatkat pewi ibiõg̃buk kẽrẽat cẽm puje, ixe ibiõg̃buk jekukum idibi'ũmat tag̃, jebodoyap kudadam. Jebodoyap pit tobuxik'ũm pima kuka o'e jewebe ma: ");
INSERT INTO myu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Jepin ma õn kuy bima onuyap kay,” i — Jesus o'e. — Jepitpin. — Yajẽm puje, ixe ag̃okatkat tobuxikxig̃. Ka'ũmg̃u ibiõg̃buk kẽrẽat opop ixe ag̃okatkat pe g̃asũ. Ixe ag̃okatkat uk'a buxim―yabuk'a buxim―yabi'õg̃'õg̃at'a buxim―yaxipanat'a buxim. ");
INSERT INTO myu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Imẽnpuye ixe ibiõg̃buk kẽrẽat cẽmcẽm ma'g̃uto. 7 beayũ dobuxikxig̃―ibiõg̃buk kẽrẽayũ dobuxikxig̃―ibodi ma xipat'ũmayũ dobuxikxig̃. Ixeyũ dak õmõm ixe ag̃okatkat pe―7 beayũ. Õmõm koapat ibiõg̃buk kẽrẽat eju. Kuy bima ixe ag̃okatkat tadaybot osunuy. G̃asũ bit ibodi ma tadaybot o'e. Imẽnpuxim ma dak g̃asũayũ jeedop. Ikẽrẽat g̃ubapukpuk cĩcã ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ixi oajẽm Jesus kay―ikitpitpit tak. Warara'acat pe kawẽnwẽn pima oajẽm ip. Akiju osodop ip. — Ocekawẽn pin Jesus eju — io'e ip iboceayũ be. ");
INSERT INTO myu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","— Exi oajẽm, ekitpityũ dak — io'e―pug̃ ag̃okatkat o'e Jesus pe. — Akiju opop ip. Cekawẽn pin ip eweju — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","— Icẽmãn ig̃o oxiat. Boyũku okitpitpicat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pacug̃'i o'e jebekitkit kay. — Webekitkit pit oxi jo'i oxe, okitpitpit co'i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","— Kabi beat a'õ kay buye, okitpitpit co'i oxe, wuyĩxĩt co'i dak ip, oxi jo'i dak ip―Deus bikuyap tag̃ jekuku'ukayũ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ixe kabiam ma Jesus o'jẽm uk'a bewi. Iodi kay oajẽm. Oabik iodi wãbu be. ");
INSERT INTO myu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ade jĩjã o'je'awero Jesus xe. Imẽnpuye kobe be oõm ixe. Oabik kobe be. Adeayũ bit kapurũg̃ pe ma osodop ip kacũg̃cũg̃'i. ");
INSERT INTO myu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","G̃ebuje o'jekawẽn adeayũ be. Wuymutaybitbinap ekawẽn muwẽnuwẽn o'e adeayũ be. Adeap muwẽnuwẽn o'e. Koap imẽn o'e: — Ag̃okatkat o'ju — Jesus o'e. — Jekadai damuduudu am o'ju. ");
INSERT INTO myu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tamududum pima, xepxepta o'ta'at. E bitako dag̃ o'ta'at — io'e Jesus. — Ixeda wasũyũ o'ta'o'o, ajẽmjẽm pima ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","— Wara'ata karatũg̃'a parak tag̃ o'ta'at. Ade g̃u ka'wi o'e iboce. Ierũn ma o'e ka'wi. Imẽnpuye dao ma kadai o'tanokap — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","— Imẽn tak kaxiepiat e ajẽm puje, kaxie o'g̃uy'ũ ibo kadai — io'e. — Ikaraw o'e. Oe'ũ tãbuju ba'ore buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","— Wara'ata widaohoda picũg̃ pe o'ta'at. Widaoho yaypan pima, ig̃o kadai o'tipmu'ũm. ");
INSERT INTO myu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","— Wara'ata ma katõ be o'ta'at. Ig̃oda o'ta'acog̃. Katõ be o'ta'acog̃ — io'e Jesus. — Ta'ade o'e. Pũg̃pũg̃ kadai be ta'adesu o'e―30 be o'e ta―katõ peata. Wara'at kadai be ta'ade o'e―60 be o'e ta. Wara'at kadai be ta'ade jĩjã o'e―100 be o'e ta — io'e. ");
INSERT INTO myu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","— Wekawẽn eyetaybit pin pima, eya'õpicũg̃cũg̃ cuy wa'õ kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","G̃ebuje 12 beayũ oajẽm Jesus kay. — Apẽnpuye ocemutaybitbinap ekawẽn acã ecekawẽn ijoceayũ eju? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","— Itaybit g̃u ip puye Deus soat kukan je'e iam. Iba'arẽm ijoceayũ be. Eyju bit eymutaybitbin õn, eyetaybit am kabi beat soat kukan je'e iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","— Xipan'ũm ya'ĩjo buje, yopĩt ma juy eyetaybin. Xipan ya'ĩjo buje bit, yobog̃ cuy eyetaybin―ade jĩjã. ");
INSERT INTO myu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Imẽnpit ijoceayũ mutaybitbinap ekawẽn muwẽnuwẽn õn cebe ip. Jeakag̃ ip. Inaka ijojom g̃u ip. Wekawẽn pa'arẽm cexe ip, wekawẽn cocom ma'g̃u ip — io'e Jesus 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","— Isaías cuk o'jekawẽn apẽn g̃asũ o'jebapuk g̃asũacat pe iam. G̃asũacat muwẽnuwẽn o'e kuyje. Ya'ĩjojom je'e ip iboceayũ. Imẽnpit itaybit g̃u ip je'e. Ijojom je'e ip. Imẽnpit itaybit g̃u je'e ip ajom sute e'em iam. ");
INSERT INTO myu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jag̃uymu'ũm ojuy ip: Ja'õpi o'jewa'õpinomudip ya'ĩjoap puxim. Jeta o'sutanomudip ijoap puxim. Imẽn'ũm pima bit kadi ijojom ip, ya'ĩjojom tak. Imẽn'ũm pima bit kadi ip itaybit o'e. Okay itabut kuka o'e ip. Õn kuka adi ip og̃u'ada, ikẽrẽat uk'ug̃ cewebewi, io'e Deus, i juk o'e Isaías — io'e Jesus. — G̃asũacat muwẽnuwẽn pit o'e — Jesus o'e. Imẽn Jesus o'e itaybit g̃asũacat itaybit pin pima, ip kajuk ig̃uycũg̃ ikẽrẽat kug̃ puye iam―ikẽrẽat kajuk o'jere ip, kajuk Deus ikẽrẽat o'ju'uk ixeyũ bewi buye iam. ");
INSERT INTO myu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","— Eyju bit eycokcok epesop. Eyju ijojo pin. Ya'ĩjo pin tak. Eyeta itaisuata jo'i — Jesus o'e 12 beayũ be. — Wekawẽn kayap eyeta itaisuatate iap puxim. Eya'õpipe iap puxim tak. Imẽnpuye soat wekawẽn epeya'ĩjojo. Imẽnpuye eyetaybit soat wekawẽn. Soat epjojojo, apẽn cuk ocece iap. ");
INSERT INTO myu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","— Kuyje ajo eyju ijojom iap co pin cĩcã osodop ip ade Deus ekawẽn muwẽnuwẽn'ukayũ, Deus xe cũg̃ cĩcãayũ dak. Imẽnpit o'jojojo g̃u ip. Ajo eyju kũyjojom iap co pin cĩcã ip osodop. Imẽnpit o'jekũyjo g̃u ip. G̃ebu'i juy epe'e iboap kay — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","— Epeya'ĩjojo juy kadaida mududumap ekawẽn kay, eyetaybit am apẽg̃ape ibo wekawẽn iam — io'e 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","— Deus ekawẽn a'ĩjojoayũ ig̃oda buxim―e be ta'at'anata buxim. Deus soat kukan ekawẽn ya'ĩjojo ip. Imẽnpit itaybit g̃u ip apẽg̃ape Deus ekawẽn iam. Satanás oajẽm cekay ip―Deus ekawẽn a'ĩjojoayũ kay. Yag̃uyba'ũm'ũm ip cekawẽn kay―Deus ekawẽn kay, Satanás oajẽm ip cekay buye — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","— Wara'acayũ Deus ekawẽn o'ya'ĩjojo ip. Ixeyũ iboapta buxim ip―karatũg̃'a parak tag̃ata buxim ip. Dao ma Deus ekawẽn cocom o'e ip. Koap icokcok cĩcã e'em ip―ijojoayũ. ");
INSERT INTO myu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Imẽnpit kadai tabue'ũmat puxim ip. Deus ekawẽn badi g̃u õmõm cebe ip. Ibureyũ itakoma cekay ip. Ipiat supi'ajoat cebe ip. Imẽneju ibu'u ip jetabut am Deus kay. ");
INSERT INTO myu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","— Warara'acayũ o'ya'ĩjojoiayũ widaoho parak tag̃ata buxim. Ixeyũ Deus ekawẽn o'ya'ĩjojo ip. Imẽnpit soat em g̃ebum ip jemukaypinput kay. Tuybe ocokcok cĩcã oce dinheiro kug̃ pima iãn e'em ip. Deus ekawẽn kay ip yopĩt ma itabut. Deus ekawẽn muwẽnuwẽn g̃u ip warara'acayũ be―jebureyũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","— Warara'acayũ o'ya'ĩjojoayũ ig̃oda buxim―katõ beata buxim. Ixeyũ Deus ekawẽn kay jĩjã ip. Apẽg̃ape Deus ekawẽn iam ip itaybit. Deus ekawẽn tag̃ jekukum ip. Ixeyũ duk'a xeayũ dak Deus ekawẽn tag̃ jekukum, Deus ekawẽn a'ĩjojom pima. Ade Deus ekawẽn kay itabut jeedop ip. Ade ip e'em soat ka dag̃―Deus kay itabucayũ. Kadai'ip puxim ixeyũ―ya'a'eat'ip puxim. 30 be o'e takug̃'iat'ip puxim ip, 60 be o'e takug̃'iat'ip puxim tak, 100 be o'e takug̃'iat'ip puxim tak — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Deus soat kukanap muwẽnuwẽn o'e Jesus. Imẽnpuye wara'acat tak imuwẽnuwẽn o'e iboceayũ be―wuymutaybitbinap―imẽnpuximap ekawẽn. — Deus soat kukanap muwẽnuwẽn pimap, kat pe wuyju tiotatam pimap puxim — io'e Jesus. — Wuyju tiotatam pimap tiotataat jekat pe xipacata o'taida. ");
INSERT INTO myu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","— Ixet. Ixima dag̃ oajẽm ip―itakomaayũ. Ixidipta o'tadum ip trigoda paraktag̃―trigoda jo'iata. O'tadum ip. O'jenapõn itakomaayũ — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","— G̃ebuje ixidip o'jedipuk kadai paraktag̃, yaypapan pima. ");
INSERT INTO myu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Imẽnpuye ibuywatwat'ukayũ o'jekawẽn ip jekariwa be. — “Kariwa,” io'e ip. “Xipacata du etadum ekat pe?” io'e ip. — “Hm hm,” io'e. — “Abu ixidipta o'tadum kadai paraktag̃?” io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","— “Okay itakomaayũ o'tamudu,” io'e. — “Ixidip tu acetip'uk tu?” io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","— “Iba'ore,” io'e cebe ip. “Trigodip kuka epetip'uk, ixidip uk'ug̃ pima. Imẽnpuye trigodip'ukap puxixim tip ug̃ g̃u eyju,” io'e. ");
INSERT INTO myu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","— “Imẽneju ixidip tiptop cuy trigodip'ukap puxim. Yaypan pima, tip pupu'ukayũ be ocekawẽn: ‘Koap ixidip puk epetip'uk tipmũnmũn ãm, daxa be tip mupik am. Trigodip pit epetipu, ta'uk am tip pewi, oduk'a be tamõg̃ ãm,’ ioce'e tip pupu'ukayũ be. Soat tarun pimap, tip pupum ip,” i — io'e Jesus. Imẽn Jesus iboceayũ mutaybitbin o'e. ");
INSERT INTO myu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus waram o'jekawẽn iboceayũ be. Wuymutaybitbinap o'g̃uwẽn―imẽnpuximap ekawẽn. Deus soat kukanap muwẽnuwẽn o'e. — Deus soat kukanap mostardada buxim — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","— Iboda wuykat pe atadaida. Ta'ĩcata mostardada, taidadam pima. Warara'ata bodi ma ta'ĩt ma. Imẽnpuxim Deus soat kukanap koap ma pũg̃pũg̃ ma ikukan. Ade g̃u cekay itabucayũ. Mostardada bit aypapan cĩcã, taida buje. Wara'at kadai bodi ma aypapan e'em. Wasũ ajẽmjẽm jedopi mõg̃ ãm tãku jeje, yaypan pima. Imẽnpuxim Deus soat kukanap g̃uyjom pit ade jĩjã ikukan. Ade cekay itabucayũ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus waram o'jekawẽn―wuymutaybitbinap―imẽnpuximap ekawẽn. Imẽn o'jekawẽn. — Deus soat kukanap pão'a muyhuhuaptõm puxim — io'e Jesus iboceayũ be. — Trigonõm kug̃ osunuy ayacat―ebapũg̃ copo. Ixe ayacat pão'a muyhuhuaptõm o'tõmpu. O'tõmõg̃ trigonõm pe. O'tõmupinã. Soat tag̃ o'jenõmupõg̃põg̃―trigonõm tag̃. Imẽnpuxim soat ka watwat Deus soat kukukan je'e iap awẽg̃ coco―kabi beat soat kukan je'e iap awẽg̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Imẽn o'jekawẽn Jesus iboceayũ be. Wuymutaybitbinap ekawẽn acã o'jekawẽn cebe ip. Soat em o'jekawẽn Jesus imẽn ma. ");
INSERT INTO myu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imẽn o'jebapuk apẽn Deus ekawẽn muwẽnuwẽn'ukat o'e'e iap. O'jekawẽn ixe: Wuymutaybitbinap ekawẽn acã ceweju ip og̃uwẽnwẽn. Ya'õba'arẽm ipi ebapuk ebi kaap ekawẽn og̃uwẽnwẽn, i. Imẽn cuk o'e Deus ekawẽn muwẽnuwẽn'ukat. ");
INSERT INTO myu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","G̃ebuje Jesus o'ju uk'a be. Adeayũ xewi o'ju. Imutaybitbin'ibiyũ oajẽm ip Jesus kay. — Iba'arẽm ocewebe. Ocewebe juy eg̃uwẽn apẽg̃ape―ixidip muwẽnuwẽn iape — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","— Kã — io'e. — Ag̃okatkat co'iat õn. Xipacata o'taidaiat co'i õn. Soat wag̃o õn. ");
INSERT INTO myu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ikat soat ipi beayũ co'i. Xipacata Deus kay itabucayũ jo'iat. Ixidip Satanás kay itabucayũ jo'iat―ibiõg̃buk kẽrẽayũ kukukat kay itabucayũ jo'i. ");
INSERT INTO myu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Itakomat ibiõg̃buk kẽrẽat kukukat co'i. Tabubuap co'i ipi jucayũ'ũmap. Tip pupu'ukayũ Deus ekawẽn tojotjot'ukayũ jo'iayũ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","— Imẽn e'em ipi'ũmat kabia, ipi juacat'ũmap. Apẽn wuyju ixidip pupum pima, tip mupik am; imẽnpuxim je'e ipi juacat'ũmap. ");
INSERT INTO myu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Soat wag̃o õn. Wa'ô dojotjot'ukayũ oce'gudot, soat xipat'ũmayũ uk am xipacap pewi, wara'acat pe xipat'ũmat mug̃ẽg̃ẽ'ukayũ dak. ");
INSERT INTO myu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","— G̃ebuje jomõg̃ ip daxabog̃ pe, ipiat'ajojoap pe. Iboce ip jeedop jetõtõn. Tũy yeiyei je'e ip ipi bun. ");
INSERT INTO myu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","— Soat Deus a'õ kay kũyjobit pin pima, Deus ebekitkit jeedop ip isop Deus xe. Kaxi buxim ip isop jeedop, Deus soat kukan pima. Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus iboceayũ mutaybitbin o'e. Deus soat kukanap kabia muwẽnwẽn o'e. — Deus soat kukanap kabia teibog̃at puxim―xipacap puxim — io'e Jesus. — Ikat pe iba'arẽmat puxim — io'e. — Ag̃okatkat ibo xipacap o'tobuxik wara'at kat pe. Cekay jĩjã o'e. Imẽnpit waram o'g̃unẽm. Icokcok cĩcã o'e. Soat ikug̃at o'g̃ũm wara'acat pe dinheiro bu am ma. — Waram o'jepit. Ibo kat o'jat kat iwat xewi. Imẽnpuxim wuywebe g̃asũ dak ajo wuyju ikug̃iat iũm put, Deus xe wuynuy am. Soat iũm put wuywebe, wuynuy pin cĩcã cexe buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","— Deus soat kukanap kabia wara'acat puxim tak―ag̃okatkat jekukuap puxim — io'e Jesus. — Pérola'a kudadamat ixe. Teibog̃at'a kudadam o'e. ");
INSERT INTO myu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","— Ixe ag̃okatkat pérola'a o'yadobuxik―yabog̃at'a. Ade dinheiro o'g̃ũm yadeim―perola'a deim. Soat ikug̃at o'g̃ũm wara'acat pe, dinheiro bu am ma — io'e Jesus. — Ibocewi oajẽm perola'a kukukat pe. Yabog̃at'a o'yabu yakukat xewi. Imẽnpuxim wuyju dak. Wuybikuyap pupum Deus xewi. Wuywebe ajo wuyju ikug̃iat iũm put Deus pe, cexe wuynuy am, Deus soat kukan pima wuynuy pin cexe buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","— Deus soat kukanap axima bubuap puxim tak — io'e Jesus. — Ag̃okatkayũ ixe axima bubuap o'joxik iodi be. Ade o'jat ip ibubuap pe―axima — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","— Ibubuap topapũn pima, ixe ag̃okatkayũ tojojon ka'oririt kay, axima naẽ ãm. Kaxikxik'i o'e ip ibubuap akokoreren. Taẽhẽm o'e ip ibubuap pewi. Xipacat ico be ip mõg̃mõg̃. Xipat'ũmat ixikxig̃ ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","— Imẽn je'e ipi'ũmat kabia — io'e. — Deus ekawẽn tojotjot'ukayũ jajẽm ijodi wuyjuyũ naẽm―xipat'ũmayũ naẽm xipacayũ xewi. Jajẽm ip xipat'ũmayũ xik am daxabog̃ pe, ipiat'ajojoap pe. Ibocewi jeedop ip tõtõn xipat'ũmayũ. Tũy yeiyei ip je'e ipi bun — io'e. ");
INSERT INTO myu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","— Ijop ekawẽn eyetaybit tu―soat? — io'e jeweju etaybitbinayũ be. — Hm hm — io'e ip. — Kuy ocetaybit. — Xipat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","— Deus soat kukan pima, Moisés ekawẽn imutaybitbinayũ webekitkin je'e―soat ip. Bekicat ebay buxim ip. Ibubut muxipanpanap'a bewi iisuat uk'ug̃, kuyat uk'ug̃ tak xeku. Imẽnpuxim ixeyũ dak itaybit cĩcã Moisés ekawẽn. Ijop ekawẽn kuyat uk'ug̃ap puxim. Wekawẽn pit iisuat uk'ug̃ap puxim — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Imutaybitbinap epere buje, Jesus o'ju jeka kay―Nazaré ka kay. ");
INSERT INTO myu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Oajẽm. Iboceayũ mutaybitbin o'e Deus eju kawẽnwẽnap'a be. O'yag̃uybabi'ũm iboceayũ. — Apẽn sute soan itaybit imẽn? — io'e ip. — Apẽn xe'e sute o'g̃ubapuk wuywebe i'e ba'oreap? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","— José ipot g̃u du sute? — io'e ip jewewebe. — Karepig̃a ipot g̃u du sute? — iboceayũ o'e. Tũybe Jesus José ipot iãn o'e ip. — Maria i ixi butet g̃u du? — io'e ip. — Ikitpityũ butet Tiago i, José i, Simon i, Judás i. Soat ip ikitpityũ g̃u du? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","— Iixĩtyũ dak ijoce ma g̃u du wuyweju―soat iixĩtyũ? — io'e ip. — Apẽn cuk sute itaybit cĩcã g̃asũ? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Itakoma ip o'e cekay. — Wuyju bit kũyjobin g̃u juy ajop ixe a'õ kay, ixe wuyjo'iat puye — i napa ma o'e ip. — Soat ka dag̃acat ibuyxim ma Deus ekawẽn muwẽnuwẽn'ukat kug̃. Jaypanap ka beayũ bit ibuyxim g̃u ikug̃―ipi beayũ bit, uk'a beayũ bit tak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ade g̃u o'g̃ubapuk Jesus―Deus a'õbacaap. Iba'ore o'e, ipi beayũ itabut'ũm cekay buye. ");
INSERT INTO myu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herodes Jesus awẽg̃ o'yawẽg̃coco. Ipi kukukat osunuy ixe Herodes ig̃ebujeat―Galiléia eipi kukukat. ");
INSERT INTO myu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","— Ixe ag̃okatkat João Batista i ibutet — Herodes o'e, tũybe iboap icẽmãn iãn o'e buye. Imẽn kawẽnwẽn o'e jebuywatwat'ukayũ be. Jesus muwẽnuwẽn o'e. — Waram g̃uto o'jetait João je'ũap tomukadi — i cedag̃ g̃u o'e. — Imẽnpuye Deus a'õbaca am wuywebe i'e ba'oreat mubapukpug̃ teku — Herodes o'e. ");
INSERT INTO myu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kuy bima Herodes jebekitkit o'g̃uju João kay. João uk puje, o'g̃ukirikirik. O'g̃ukirikirik imõg̃ ãm daomũnmũnap'a be. Ayacat cekayap puye, o'jomõg̃―Herodías cekayap puye. Herodes kitpit tayxi osunuy ixe ayacat―Filipe tayxi. Imẽn daomũnmũnap'a be Herodes João o'g̃uõmat, João ekawẽn puye. ");
INSERT INTO myu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","— Cũg̃ g̃u ewebe ixe ayacat kuk am. Deus xe cedag̃ g̃u ekitpit tayxi eju jewewbumũn ãm―ixe Herodías eju jewebumũn ãm — i juk o'e João ipi kukukat pe―Herodes pe. ");
INSERT INTO myu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Imẽnpuye Herodes João aoka ojuy. Imẽnpit Judeuyũ xe João Deus ekawẽn muwẽnuwẽn'ukat osunuy. Imẽnpuye Herodes iparara o'e Judeuyũ buxixim. ");
INSERT INTO myu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Peta bima bit Herodías it o'jebapuk da'i'in Herodesyũ etabut pe. O'jebapuk Herodes kapap epeta buye. Cekay jĩjã o'e Herodes―ayacat yaypan'isuat kay. ");
INSERT INTO myu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","— Da'i'iap kay jĩjã õn — io'e yaypan'isuat pe. — Emukaypinput eg̃uwẽn owebe — io'e. — Deus etabun õn e'em ewebe emukaypinput og̃ũm ewebe — Herodes o'e. — Deus cuy ipiat supi'ajoat owebe, wa'õ dag̃ g̃u iũm pima — io'e. ");
INSERT INTO myu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","— Ijoce ma João Batista a prato be eyaũm owebe — io'e. Imẽn yaypan'isuat o'e. — Imẽn ece, o'it — i juk o'e cebe ixi. Imẽnpuye yaypan'isuat o'e imẽn ma. ");
INSERT INTO myu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yaũm pin g̃u o'e Herodes. Ibu'u o'e. Ig̃uycũg̃ o'e, yaypan'isuat imẽn o'e buye. O'yaũm an pit cebe, jekawẽn puye, itakoyiayũ buye dak―jewejuayũ buye. Jekawẽn tag̃ o'yaũm. ");
INSERT INTO myu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","— Daomũnmũnap'a kay eju — io'e sorara be. — João a eya'uk — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","— Hm hm — sorara o'e. O'ju. O'ya'uk. O'yadojot prato be. O'yaũm ayacat'isuat pe. Imẽn Herodes juk itaybit João oe'ũ iam. O'yadujowat jexi kay ixe. Imẽneju Herodes tũybe João'ũm waram o'jetait iãn o'e, Jesus awẽg̃ yawẽg̃cocom pima. ");
INSERT INTO myu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","João eju oekuku'iayũ oajẽm João'ũm kay. Ijebit o'tujowat witabikũy be, ikot am. Jebabim ikot puje, o'ju ip. Oajẽm Jesus kay. João'ũm awẽg̃ muwẽnuwẽn o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tobuxik puje, o'jẽm Jesus adeayũ xewi. O'ju kobe dag̃ ag̃oka'ũmat kay. Oajẽm. Adeayũ dak o'ju ip. E dag̃ pit o'ju ip, Jesus cucumap awẽg̃ cuk o'yawẽg̃coco ip puye. Oajẽm ip ag̃oka'ũmat pe, Jesus ajẽm awap. ");
INSERT INTO myu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kobe bewi cẽm puje, Jesus ade jĩjã o'jojojo. Itabotaidabotbot o'e cekay ip. G̃ebuje iwãtaxipipiayũ o'g̃u'ada Jesus. ");
INSERT INTO myu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jesus eju etaybitbin'ukayũ o'jekawẽn cebe. — Katpuje ma oexe buye, jexat pupu am ip eg̃uju ag̃oka kay — io'e ip. — Ijoceayũ eg̃uju juy. Ka'ũmg̃u ixat ijoce, ag̃oka'ũmat puye — io'e ip. — Iteyũ juy eg̃uju jexat pupu am dinheiro deim — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","— Ka'ũma — Jesus o'e. — Je'ju g̃u juy ixeyũ, jexat pum. Eyju ma ixan epeg̃ũm cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","— Pũg̃pũg̃ ma ixat kug̃ oceju — io'e ip. — Cinco be ma pão'a opop. Axima dak opop―xepxep ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","— Pão'a epeyadojot, axima dak — io'e jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","— Soat epabikbik. Xikxikxik'i — io'e warara'acayũ be―adeayũ be. Kaxikxik'i osodop ip. Pão'a o'yabu Jesus. Axima dak o'jat. Xepxep ma o'jat. G̃ebuje Deus eju o'jekawẽn. Jeapũnpũn o'e kabi kay. — Bay, ẽn xipat — io'e. — Pão'a eyaũm ocexat'am — io'e. O'yadakat jebum. O'yaũmũm jeweju etaybitbinayũ be. O'yaũmũm ip iboceayũ be. Imẽn Jesus o'yamu'acog̃. Ya'ade jĩjã o'e. Ceweju etaybitbinayũ o'yaũm adeayũ be. ");
INSERT INTO myu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","O'jo'o'o soat ip. Ibẽg̃bẽg̃ ip o'e. Cepoyat puje, Jesus eju etaybitbinayũ o'jat ico be. 12 be ico o'g̃unopapũn ip cepoyan―pão'a epoyan, axima epoyan tak. ");
INSERT INTO myu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ag̃okatkayũ 5 mil be osodop ip. Aoyũ dak bekitkit eju, ade ip osodop. Adeayũ osodop ip―jekõnkõnayũ. ");
INSERT INTO myu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","— Owap cuy wĩnãbu epeju kobe dag̃ — io'e jeweju etaybitbinayũ be. — Eyju cucum pima, ijoceayũ mujum puk õn ika be — io'e. — Hm hm — io'e ip. Õmõm ip kobe be. O'ju. ");
INSERT INTO myu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Warara'acayũ o'g̃uypit Jesus ika be. Co'a kay jag̃epũg̃ ma o'ju, jekawẽn ãm Deus eju. Oajẽm. Kabiok pima co'a jeje osunuy jag̃epũg̃ ma. ");
INSERT INTO myu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kobe dag̃ayũ bit iodi bicũg̃pe o'e ip. Wũy ma ipi bewi o'e ip. Tipodoy tibog̃ cĩcã o'e. Kobe mupokupog̃ o'e kabidoxixi buye. Kopũg̃. Kopũg̃. Kopũg̃. O'subidoajẽm topabe. ");
INSERT INTO myu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kaxi jẽm awap ma xĩg̃xĩg̃ o'e. Idibi adopa dag̃ xĩg̃xĩg̃ o'e. Oajẽm jeweju etaybitbinayũ kay. ");
INSERT INTO myu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iparara jĩjã o'e ip. Tũybe axik sute iãn o'e ip iodi adopa dag̃ xĩg̃xĩg̃ puye. — Axik tu sute? — io'e ip. O'jewãwã ip, iparara jĩjã buye. ");
INSERT INTO myu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","— Axik ma g̃u õn. Eya'õcam cuy epesop. Eypararam g̃u juy. Õn ã — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","— Kariwa! — Pedro o'e. — Ẽn pima, “Ejot idibi jeje,” i ece owebe. “Ejot ijodi,” i juy ece owebe — Pedro o'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","— Ejot — io'e. O'jẽm kobe bewi. Xĩg̃xĩg̃ o'e idibi adopa dag̃, ajẽm ãm Jesus kay. ");
INSERT INTO myu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Iparara bit o'e tipodoy buye. Imẽnpuye oakõm pin. — Kariwa! — io'e. — Odaxijom ece iodi bewi — io'e ya'õberen. ");
INSERT INTO myu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","O'jebumupaya Jesus dao ma. O'subuixik Pedro. O'jat. Jesus Pedro o'jat. — Etabutbũt ma okay — io'e cebe. — Etabun cĩcã juy okay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kobe be oõm―xepxem. Kabido o'subido'ũm g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","— Icẽm. Deus ipot ẽn — kobe beayũ o'e ip Jesus pe. Jesus oibuyxin ip. ");
INSERT INTO myu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","35","Iodi mudek puje, Genesaré eipi kay oajẽm Jesusyũ. Jesus itaybit o'e ip―Genesaré watwat. O'ju ip eipi dag̃―soat tag̃. Iwãtaxipipiayũ dakoykoy o'e ip―soat. Iwãtaxipipiayũ o'tojotjot ip Jesus kay. ");
INSERT INTO myu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","— Iwãtaxipipiayũ esay ukpi mucay pin cĩcã je'ada am — io'e ip Jesus pe. Genesaré watwat o'e ip. — Ha'a — Jesus o'e. O'je'ada ip―soat o'g̃ucay'iayũ―soat iwãtaxipi topibiyũ. ");
INSERT INTO myu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseuyũ oajẽm Jesus kay Moisés ekawẽn imutaybitbin'ukayũ eju. Jerusalém ka bewiayũ osodop ip―soat ip. (Kuyje Fariseuyũ oekuku ip aypapayũ'ũm'ũm ekawẽn tag̃. — Jekõn awap jewebuwuywuy'uk'ũm pima, xipat g̃u wuyxe — io'e ip kuyje. Imẽnpuye Fariseuyũ oajẽm Jesus kay.) ");
INSERT INTO myu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Apẽnpuye eweju etaybitbinayũ jewebu wuywuy'uk g̃u ip, jekõn awap? — io'e ip Jesus pe. — Xipat g̃u imẽn — io'e ip. — Wuyajojoyũ'ũm'ũm ekawẽn tag̃ g̃u ip jekukum, jewebuwuywuy g̃u ip puye — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","— Pãm eyju? — Jesus o'e. — Apẽneju Deus ekawẽn tag̃ g̃u eyju jekukum? Apẽneju wuyajojoyũ'ũm'ũm ekawẽn tag̃ acã eyju jekukum? Deus ekawẽn tag̃ g̃u eyju jekukum — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","— Xipan cuy ebay ejukuk, exi dak, i. Imẽn Deus ma juk o'e — io'e Jesus. Jebay muymuy'ukat cuy epeyaoka, jexi muymuy'ukat tak, i. Imẽn Deus o'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","— Eyju warara'acat mukũyjojom pima bit, e'em: “ ‘Dinheiro kuka adi og̃ũm eywebe eybuywat am,’ i juy epe'e eyebay be,” ie'em eyju bit warara'acat mukũyjojom — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","— Eyju dak e'em warara'acat pe: “G̃ebuje cũg̃ ma e'em ewebe ebay jukukuk xipan'ũm pima,” i — io'e Jesus. — Imẽn ma ajojoyũ'ũm'ũm ekawẽn tag̃ ip jekukum, Deus a'õ mubuyxi'ũm'ũmay eyju — Jesus o'e Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","— Wuyjuyũ mug̃uykuku'ukayũ eyju — io'e Fariseuyũ be. — Kuyje ma juk Isaías emuwẽn icẽmãn. Imẽn o'e: ");
INSERT INTO myu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Deus kay oceju,’ i napa ma e'em iteyũ wuyjuyũ,” i. “Imẽnpit okay g̃u ip,” i'e'em Deus, i juk o'e Isaías — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“ ‘Ẽn xipat,’ i te'e ma e'em ip,” i. “Imẽnpit xipat g̃u õn ip cexe,” io'e Deus, io'e Isaías. “ ‘Deus ekawẽn eymutaybitbin oceju bit,’ i napa ma e'em ip. Imẽnpit wuyjuyũ ekawẽn acã adeayũ mutaybitbin ip,” ie'em Deus, i juk o'e Isaías — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","G̃ebuje Jesus adeayũ o'tomuwã. Oajẽm ip. — Ya'õpicũg̃cũg̃ cuy epesop, eyetaybit am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","— Ajo õmõm eybi be iap g̃u eymukẽrẽrẽrẽn g̃u — io'e. — Ajo cẽmcẽm eybi bewi acã eymukẽrẽrẽrẽn — io'e. — Iboap kay juy epeg̃ebu — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","— Etaybit tu Fariseuyũ itakoma ekay iam―ekawẽn puye, itakoma iam? — ceweju etaybitbinayũ o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","— Wetaybit — Jesus o'e. — Kadaidip webay o'taidag̃uiaptip ju'uk Deus. Apẽn wuyju tipkẽrẽatip ju'uk ku bewi; imẽnpuxim Deus fariseuyũ emumutaybitbinap ju'uk wuyag̃uy bewi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","— Eyag̃uybabi'ũm g̃u juy itakomaayũ kay — io'e. — Ikukukat ita'ũmat puxim ip―Fariseuyũ. Ikukukat ita'ũmat pima, jekukukat tomuju wara'at ita'ũmat cucum pima, xepxem ma ip at'an je'e ipikũykũy be, ita'ũmayũ ma ip puye. ");
INSERT INTO myu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ibocewi Pedro o'e: — Wuywebe õmõmap g̃u wuymukẽrẽrẽrẽn―wuybinũn peat acã iat ekawẽn iba'arẽm ocexe. I juy ece ocewebe apẽg̃ape ekawẽn, iba'arẽm puye — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","— Eyju adeayũ buxim: ka'ũmg̃u eyetaybit — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","— Ajo õmõm eybi be, ijop kapkam eydada be. G̃uyjom cẽmcẽm eywebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","— Ajo cẽmcẽm eybi dag̃wi, ixe eymukẽrẽrẽrẽn, eybinũn pewi cẽmcẽm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","— Soat em ijodiat jewag̃uydadam ikẽrẽat kay: warara'acat aokakam ip, warara'acat tayxi kaykay'uk ip, aoyũ kaykay'uk ip, warara'acat pubut tujupa'ũm'ũm'uk ip, warara'acat awẽg̃ mukẽrẽrẽn 'uk ip, warara'acat awẽg̃tatam ip. Soat eybinũn pewi jebapukpug̃, soat em ikẽrẽat kay g̃ebum puye acã — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","— Ijodiacat ikẽrẽat mujurũg̃rũg̃'uk, aypapa'ũm'ũm ekawẽn tag̃ jewebuwuywuy'ũm puye g̃u―soat em ikẽrẽat kay g̃ebum puye acã. Ig̃o ag̃uykẽrẽat acã eymukẽrẽrẽrẽn. Iboam eytaybit g̃u buk? — io'e jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ibocewi o'ju. Jesus Tiro ka tẽg̃ ma o'ju. Sidom ka tẽg̃ ma dak oeku. ");
INSERT INTO myu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ayacat oajẽm Jesus kay―Canaã eipi wat―Judeu'ũmat. — Kariwa! — io'e ya'õberen. — Etabotaidabotbon cuy okay. Ibiõg̃buk kẽrẽat kug̃ o'it, ipiat'ajojom cĩcã ibiõg̃buk kẽrẽat kug̃ puye — io'e Jesus pe―Davi diwacat pe. Ayacat ma i'it osunuy. ");
INSERT INTO myu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","O'jede g̃u Jesus. Imẽnpuye Jesus eju etaybitbinayũ o'jekawẽn ip Jesus pe. — Soat em ixe ayacat wuynomuju ma ya'õkarey. Esu'it mu'ada juy. G̃ebuje juy eg̃unapõn — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","— Iba'ore — io'e. — Deus omuju Israel naxeg̃ebitbit kay acã — Jesus o'e. — Itabidaoat puximayũ kay―ovelha buximayũ kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jesus wap o'jẽg̃'aecõg̃cõg̃ ayacat. — Kariwa — io'e. — Obuywan ece — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","— Ka'ũma. Xipat g̃u oxe, bekicat xat'a yaxikxig̃ pima, akurice be ya'om — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","— Icẽmãn, Kariwa — io'e. — Imẽnpit akuriceyũ wuyxat epoyat o'om. Mesa bewi i'at puje, akurice io'om. ");
INSERT INTO myu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","— Ka — io'e. — Wetaybit g̃asũ okay etabut cĩcã iam — io'e. — Ebikuyap tag̃ e'it mu'ada oce — io'e. G̃asũ ma je'it o'je'ada. ");
INSERT INTO myu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ibocewi o'ju iodi be―Galiléiadi be. O'jeu. Oajẽm co'a jeje Jesus. Oabik. ");
INSERT INTO myu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jesus kay oajẽm ip―ade jĩjãayũ. Taokẽrẽayũ dujotjon ajẽmjẽm o'e ip, ita'ũmayũ dak, jekawẽn pa'oreayũ dak, warara'acayũ iwãtaxipipiayũ dak. Jesus kay imu'ada am ip o'tojot. Oajẽm ip. O'jomõg̃ Jesus wap. Soat ip o'jomõg̃. Soat ip o'je'ada. ");
INSERT INTO myu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yag̃uybabi'ũm o'e ip―adeayũ, xĩg̃xĩg̃ pa'ore topibiyũ o'jojojo ip puye. Yag̃uybabi'ũm o'e ip, kawẽn pa'ore tũibiyũ dak o'jojojo ip puye. Ita'ũm topibiyũ tate o'e. — Ka'ũmg̃u xipacat Deus co'iat. Israel naxeg̃ebitbit Deus mubuyxi. Ixe a'õbi o'je'ada ip — io'e yag̃uybabi'ũmayũ. ");
INSERT INTO myu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","G̃ebuje Jesus jeweju etaybitbinayũ o'tomuwã. — Wetabotaidabotbot adeayũ kay — io'e Jesus. — Ibaca'ũm ip, ixat'ũm puye. Irere ip. Xepxep xet oweju ip jekukum. G̃asũ bit ixat'ũmg̃u ip o'e. E dag̃ jeku am iba'ore e'em cebe ip, irere jĩjã buye, ibaca'ũm puye ip. E dag̃ ma ip kuka o'tao'ũm'ũm repibun puye dak — Jesus o'e jeweju etaybitbinayũ be. — Obu'u kawẽn ãm cebe ip: “Eyduk'a kay juy epeyepit,” i, irere buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","— Pomawi pão'a oceyabu soat muykõn ãm? — io'e ip. — Ya'ũmg̃u uk'a ig̃o ka be. Iba'ore yabu am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","— Pebũrũ pão'a opop? — io'e cebe ip. — 7 be — io'e ip. — Pũg̃pũg̃ ma axima'it'it tak — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","— Kaxikxik'i epabik — Jesus o'e iboceayũ be―adeayũ be. Oabikbik ip ipi ju. ");
INSERT INTO myu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pão'a o'yabu Jesus―7 beat'a. Axima dak o'jat. O'jekawẽn Jesus Jebay be―Deus pe. — Bay! — io'e. — Xipat ẽn, ocewebeam ocexat eg̃ũm — io'e. Soat xat o'takat Jesus―pão'a, axima dak. O'yamu'acog̃ cĩcã. Ya'ade jĩjã o'e. Ade axima dak, imu'acog̃ puye. Iũmũm o'e jeweju etaybitbinayũ be. Cexat ũmũm o'e ip iboceayũ be. ");
INSERT INTO myu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Soat ip o'jo'o'o ip. Ibeg̃beg̃ iboceayũ o'e. Ixat o'jepoyat. 7 beap ico be o'g̃unopapũn ip cepoyan―axima epoyan, pão'a epoyat'am tak. Jesus eweju etaybitbinayũ o'g̃unopapũn. O'tujowat ip. ");
INSERT INTO myu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","4000 beayũ o'jekõn ip―ag̃okatkayũ. Bekitkiyũ dak o'jekõn ayacayũ eju. ");
INSERT INTO myu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","G̃ebuje Jesus ixeyũ ibeg̃beg̃ayũ o'g̃uju. Kobe dag̃ Jesus pit o'ju Magadã ka kay. ");
INSERT INTO myu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseuyũ oajẽm ip, Saduceuyũ dak. Oajẽm ip Jesus kay. Pũg̃pũg̃ ajẽmjẽm o'e Jesus eju kawẽn ãm. — Ocewebe i'e ba'oreat eg̃ubapuk cuy ocewebe — io'e ip Jesus pe. — Deus a'õbacaap co buje, acetabun ẽn Deus xewiat iap kay — io'e ip. Iboap muwẽn o'e ibuyxijo am. ");
INSERT INTO myu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","4","— Og̃ubapuk g̃u juy — Jesus o'e cebe ip. — G̃asũacat ikẽrẽat kug̃ayũ ip. Deus kay itbut'ũmayũ ip. Eywebe i'e ba'oreat og̃ubapuk g̃u. — Kan pima eyju e'em, “Kuyajeat kabia idip ma e'em, kabi ipakpuk puye,” i. Kabia isum pima eyju e'em, “Muba'at oajẽm g̃asũ, kabi ipakpuk puye, kabikerere buye dak,” i. Eyetaybit cĩcã apẽnape kabi ipakpukat iam, kabi kay ag̃ puye. Imẽnpit eyetaybit g̃u apẽnape oce'e'eap iam. Ajo juk o'jebapuk Jonas pe iap puxim pit g̃uyjom je'bapuk eyetabun — io'e Jesus. Imẽn Jesus o'jekawẽn cebe ip, itaybit puye ip apẽnape kabi ipakpukat iam, ijojom pima ip. Imẽnpuxim Jesus e'e'ap cuk o'jojojo ip. Itaybit kuka o'e ip Jesus bacaap Deus xewi osunuy iam. — Kuyje Jonas o'jẽm axima bog̃at uk pewi. Icẽmãn kuyjeacat pe i'e ba'oreat o'e. Imẽnpuxim g̃asũ ag̃okatkat waram g̃uto itait je'e, ce'ũ'ũayũ dopap pewi cẽm puje xeku. G̃asũacat pe i'e baõreat je'e xeku waram itaicap. Wara'at g̃u eywebe i'e ba'oreat g̃ubapuk eyetabun―xeku waram itaicap acã Deus g̃ubapuk — io'e Jesus. Ibocewi Jesusyũ o'ju ip wara'at ka be. ");
INSERT INTO myu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","O'timudek ip. Oajẽm wara'at ka be. Pão'a o'yadujowat g̃u Jesus eju etaybitbinayũ, g̃ebum'ũm puye ip. ");
INSERT INTO myu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","— Ag̃ cuy epesop Fariseuyũ epão'a muyuhuhuaptõm kay, Saduceuyũ enõm kay dak — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","G̃ebuje o'jekawẽn ip jewewebe. — Jesus imẽn o'jekawẽn wuywebe, pão'a wuyadojot g̃u buye — io'e ip. Cedag̃ g̃u o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus pit ixeyũ ekawẽn o'ya'ĩjojo. — Yopĩt ma eyetabut okay — io'e cebe ip. — Apẽnpuye eyewewebe kawẽnwẽn eyju: “Imẽn xeku o'e, wuyju pão'a kug̃ g̃u buye,” i? Imẽn g̃u juy epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","— Eyetaybit g̃u buk? — io'e cebe ip. — G̃ebum g̃u du eyju 5 be pão'a oyaũm 5000 beayũ xat'am iap kay? G̃ebum cuy epesop iboap kay — io'e. — G̃ebum g̃u du eyju pebũrũ ico epeg̃unopapũnpũn yaepoyan? G̃ebum cuy epesop iboap kay dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","— G̃ebum g̃u du eyju 7 be pão'a oyaũm 4000 beayũ xat'am iap kay? G̃ebum cuy epesop iboap kay dak. G̃ebum g̃u du eyju pebũrũ ico epeg̃unopapũnpũn yaepoyan? G̃ebum cuy epesop iboap kay dak. ");
INSERT INTO myu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","— Eyetaybit gu buk tu pão'a muwẽnuwẽn g̃u õn iam? Eyetaybin cuy. Ag̃ cuy ixeyũ be pão'a muyuhuhuaptõm kay―Fariseuyũ epão'a muyuhuhuaptõm kay, Saduceuyũ epão'a muyuhuhuaptõm kay dak — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Imẽneju itaybit ip Jesus pão'a muyuhuhuaptõm i'e buje, Fariseuyũ emumutaybitbinap i'e ojuy osunuy, Saduceuyũ emumutaybitbinap tak. Imẽn ip o'g̃ukũyjo. Xipat g̃u cemumutaybitbin ip. Deus xe cedag̃ g̃u ip imutaybitbin―Fariseuyũ, Saduceuyũ dak. Wuyjuyũ mug̃uykuku'ukayũ ip osodop. ");
INSERT INTO myu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","O'ju ip Cesaréia eipi tẽg̃ ma―Filipe eipi tẽg̃ ma. Oajẽm. — Abu xe'e õn wuyjuyũ xe? — io'e cebe ip―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","— “Teku waram g̃uto o'jetait'iat,” i'e'em ip―pũg̃pũg̃ e'em ip — io'e ip. — “Teku João Batista―waram g̃uto o'jetait'iat,” pũg̃pũg̃pũg̃ e'em — io'e ip. — “Teku Elias―waram g̃uto o'jetait'iat,” i'e'em warara'acayũ — io'e ip. — “Teku Jeremias―waram g̃uto o'jetait'iat,” i'e'em warara'acayũ — io'e ip. — “Teku kuyjeat―Deus ekawẽn muwẽnuwẽn'ukat―waram g̃uto o'jetait'iat,” i'e'em warara'acayũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","— Pãm eyju? — io'e. — Abu õn eyxe bit? — io'e. ");
INSERT INTO myu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","— Cristo ẽn — Simão Pedro o'e Jesus pe. — Deus emunaẽ ẽn. Soat em itaicat ipot ẽn―Deus ipot ẽn — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","— Icẽmãn, Simão — Jesus o'e. — Ijoceayũ dak iboap ekawẽn o'g̃uwẽn g̃u ip ewebe―Deus acã―webay acã―kabi beat acã. Ecokcok ẽn, João ipot, — io'e. ");
INSERT INTO myu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","— Icẽmãn og̃uwẽn ewebe: Ẽn Pedro. “Deus ipot ẽn,” exe iap ekawẽn kay itabucayũ webekitkin e'em ip, itabut puye ip. Okay itabucayũ oe'ũ ip ma'g̃u, jetait waram, ibaca jĩjã buye. Satanás ebekitkit bacaap podi ma e'em okay itabucayũ bacaap. ");
INSERT INTO myu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","— Ajo cũg̃ ma exe ijoce, iboap tak cũg̃ ma je'e Deus xe kabi be — io'e Pedro be. — Ajo bit cũg̃ g̃u exe ijoce, iboap tak cũg̃ g̃u je'e Deus xe kabi be. Imẽnpuye a'õbi Deus emunaẽ kay itabucayũ jeedop ip Deus xe―okay itabucayũ. Deus soat kukan pima, cexe jeedop ip — Jesus o'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","— G̃asũ dak cuy omuwẽnuwẽn epekuku g̃u wara'acayũ be. “Teku Deus emunaẽ,” i'ũmg̃u juy epeku — io'e jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesus jeweju etaybitbinayũ mukũyjojo o'e apẽn kuka o'jebapuk cebe iam. — Jerusalém ka be oju — io'e cebe ip. — Ika watwat xipan g̃u okuk soat ip―Judeuyũ kukukayũ, paĩyũ kukukayũ, Moisés ekawẽn imutaybitbin'ukayũ. Ipiat'ajom õn, ixeyũ buye — io'e jeweju etaybitbinayũ be. — Waoka ip — io'e Jesus. — Imẽnpit xepxep xet kap puje bit, waram ocetait — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro ibodi ma o'tujowat jeweju, kawẽn ãm. — Jaoka g̃u ip. Deus bikuyap tomuju g̃u, Kariwa — io'e Pedro. — Je'bapuk'ũma — io'e. Imẽn Pedro o'e Jesus pe. Imukorẽm pin, Pedro xe xipat g̃u kuka o'e imẽn pima bit. ");
INSERT INTO myu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","O'jekorepẽn Jesus. — Mũg̃ ece! — io'e Pedro be. — Satanás ekawẽn puxim ẽn kawẽnwẽn. Satanás tak ibu'u owebe we'ũ ãm adeayũ beam. Deus ag̃uy dag̃ g̃u ẽn jewag̃uyg̃uy―ipi juacat ag̃uy dag̃ acã ẽn. Imẽnpuye Deus bikuyap tag̃ jekuku am, ẽn omubu'un ojuy — io'e Jesus Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Oweju jeku pin pima, eywekay ma eyag̃uyba'ũm cuy; eybu'um g̃u dak cuy eye'ũ ãm owebeam; wa'õ dag̃ tak cuy epeku — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","— Imẽneju owebeam eye'ũ buje, soat em eyetait epesop Deus xe eye'ũap tomukadi. Eybu'u eye'ũ ãm owebeam pima bit, epajẽm g̃u Deus kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","— Ajo-kug̃ tak epesop soat tarekrek kug̃ ipi juat kug̃, eybiõg̃buk ipiatpi'ajojoap pe imẽnpit? Ka'ũma kug̃ ma! — Jesus o'e cebe ip. Tei'ũmg̃u soat em Deus xe wuydopapteim — io'e. ");
INSERT INTO myu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","— Soat wag̃o õn — Jesus o'e, kawẽnwẽn pima jewebeap pe ma. — Ocepit ma wekawẽn tojotjot'ukayũ eju, webay a'õbacaap eju dak, idip cĩcãap eju dak. Yajẽm puje, teim je'g̃ũm soat pe―apẽn oekuku iapteim — io'e. — ");
INSERT INTO myu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pũg̃pũg̃ pit jeedop wajẽmap wiwim itabẽg̃―ijodiat. Oxe xe ma jeedop ip, soat kukan õn pima. Wajẽmap co'ũm puje, je'ũ g̃u ip — io'e Jesus―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","5 xet kap puje, o'ju ip co'a kay―yaumat'a kay. Jesus ebapũg̃ ma o'tujowat―Pedro, Tiago dak, João dak. Tiago kitpit osunuy ixe João. Jag̃epũg̃ ma o'tujowat ip. Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Co'a jeje Jesus o'jewemuwarurun ebapũg̃ayũ wap. Kaxi sopsepap puxim topasopsep o'e―Jesus topa. Iisuat puxim jekabek―Jesus ekabek. Irut cĩcã o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","G̃ebuje Moisés'ũm o'jebapuk, Elias'ũm tak. O'jebapuk ebapũg̃ayũ wap. Jesus eju jekawẽn ãm o'jebapuk ip. O'jekawẽnwẽn ip Jesus eju. ");
INSERT INTO myu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kawẽnwẽn epere buje, Pedro o'e Jesus pe: — Kariwa — io'e. — Xipat ma wuyju ijoce am. Xipat exe bima, xijap ojomõg̃ ijoce. Pũg̃ edopam ojomõg̃. Wara'at Moisés'ũm dopam ojomõg̃, wara'at Elias'ũm dopam — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kabikerereat tak oajẽm cekay ip―Jesusyũ kay. Isopsepat osunuy. Ixeyũ dak o'yajuy isopsepan. Deus isopsepat pidasewi o'jekawẽn―kabikererereat pidasewi. — Teku okpot. Ikukpin cĩcãat oxe. Omucokcokap cĩcã okpot. Eya'õpicũg̃cũg̃ cuy epesop ya'õ kay — io'e―Deus o'e. Imẽn kawẽnwẽn o'e Deus. Jesus muwẽnuwẽn o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ijo buje, ebapũg̃ayũ o'jẽg̃'aecõg̃cõg̃ ip. Iparara jĩjã o'e ip Deus kabikerereat pidasewi o'jekawẽn puye. ");
INSERT INTO myu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus pit o'jẽg̃'aecõg̃cõg̃'iayũ o'g̃ucay. — Epe'ãy juy — io'e cebe ip. — Eypararam g̃u juy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jeakag̃ ip pima, Jesus ma o'jojojo ip. Ka'ũmg̃u warara'acayũ o'jojojo ip. O'ãy ip. O'kop ip Jesus eju. O'kop ip co'a jejewi. ");
INSERT INTO myu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kopkom pima, Jesus o'jekawẽn ebapũg̃ayũ eju. — G̃asũ g̃u juy epejojojoiap epeg̃uwẽn warara'acayũ be — io'e cebe ip. — G̃uyjom pit epeyawẽg̃muwẽnuwẽn put, waram wetait puje — io'e―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","— Apẽnpuye Moisés ekawẽn ocemutaybitbin'ukayũ e'em, “Koap Elias'ũm omuyku,” i? — io'e ebapũg̃ayũ Jesus pe. Imẽnpuye Jesus kawẽnuwẽn o'e. Elias muwẽnuwẽn o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","— Elias'ũm awẽg̃ itaybit g̃u buye ip — io'e Jesus. — Elias'ũm co'iat kuy oajẽm, soat muxipan am―wajẽmap peam imuxipan. Adeayũ ag̃uymuwarurun itabut am ip Deus kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","— Imẽn Elias'ũm co'iat kuy oajẽm ma ijoceayũ kay. Ixeyũ bit ixem itaybit g̃u o'e―Moisés ekawẽn eymutaybitbin'ukayũ. Warẽmtag̃ ma ip o'jukuk. Ikẽrẽm cĩcã ip o'jukuk. O'g̃udadaibotbon cĩcã ip. Imẽn ma õn tak ipiat osupi'ajojo, xipan g̃u ip okuk puye — io'e Jesus―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Imẽn Jesus eju etaybitbin'ukayũ itaybit o'e Jesus ekawẽn―João Batista ajẽmap ekawẽn. ");
INSERT INTO myu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesusyũ oajẽm adeayũ kay. Iboceat o'jẽg̃'aecõg̃cõg̃―ag̃okatkat. O'jẽg̃'aecõg̃cõg̃ Jesus wap. ");
INSERT INTO myu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— Okpot kay etabotaidabotbon cuy, Kariwa — io'e. — Axik opop cebe. Ipiat'ajojom ibiõg̃buk kẽrẽat pibun — io'e ag̃okatkat Jesus pe. — Ade em o'at'at daxa be. Ade em oakõmkõm idibi be — io'e. ");
INSERT INTO myu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","— Eweju etaybitbin'ukayũ kay otojot. Okpot otojot. Imẽnpit itaybit g̃u ip ibiõg̃buk kẽrẽat mujẽm ãm. Iba'ore cebe ip okpot mu'ada am — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","— Deus kay itabut'ũmayũ eyju! — Jesus o'e. — Soat em wara'at tag̃ epeyag̃uyg̃uy buye, eyetabut'ũm Deus kay. Soat em ikẽrẽan e'e buye dak. Pug̃ũn og̃uy eyxe? Ade koato eyxe og̃uy bima dak, kuka eyeabut'ũm ma epesop okay. Imẽnpit ekpot etojot cuy okay g̃asũ — io'e cebay be. O'tojot. ");
INSERT INTO myu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ibiõg̃buk o'g̃ukorẽm Jesus. — Ejẽm — io'e Jesus ibiõg̃buk kẽrẽat pe. O'jẽm jekukat xewi―ag̃okatkat ipot xewi. O'je'ada g̃axĩn ma ibiõg̃buk kẽrẽat kug̃ topibit. ");
INSERT INTO myu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yag̃epũg̃ ma bima, oajẽm ip Jesus kay. Jesus eju etaybitbinayũ oajẽm. — Apẽnpuye ocewebe ibiõg̃buk kẽrẽat mujẽm pa'ore? — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","— Deus kay eyetabutbũt puye — Jesus o'e. — Deus kay eyetabucap yopĩt pima, ka'ũmg̃u iba'ore kuka eywebe. Eyetabucap yopĩt pima, mostardada buxim acã okay eyetabucap pima, kuka epe'e co'a be: “Ecenapõn ijocewi. Wara'at ka be eju juy,” i. Ig̃o'a dak o'jenapõn kuka wara'at ka be — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","— Deus a'õbi'ũm pima bit, o'jẽm g̃u kuka ip―ibiõg̃buk kẽrẽayũ. O'jẽm g̃u kuka ip ikukukayũ bewi. Deus kay g̃ebum pima, wuyju jekõnkõn g̃u e'em acã o'jẽm ip, Deus eju wuyekawẽnwẽn'uk pima dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","G̃ebuje o'je'aweroro Jesusyũ Galiléia eipi be. — Soat wag̃o õn — Jesus o'e cebe ip. — Ipi juacayũ odujowan ip oaoka pinayũ kay. ");
INSERT INTO myu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Okay itakomaayũ oaoka ip. Imẽnpit ebapũg̃ kabia kap puje, õn pit waram ocetait Deus a'õbi — io'e aweroayũ be. Imẽn Jesus o'e buye, ig̃uycũg̃cũg̃ap kug̃ ma acã ip o'e―aweroayũ o'e. ");
INSERT INTO myu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cafarnaum ka kay oajẽm ip. Israel naxeg̃ebitbit pewi dinheiro bubu'ukayũ osodop ibo ka be. Deus eju kawẽnwẽnap'a muxipanpan'ukayũ beam ibubum o'e ip. — Emutaybitbin'ukat dinheiro je'g̃ũm tu ibubu'ukayũ be Deus eju kawẽnwẽnap'a muxipanpan'ukayũ beam? — io'e ip Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","— Hm hm — Pedro o'e. — Je'g̃ũm — io'e. O'jepit. Dexe. Jesus o'jekawẽn Pedro eju. — Apẽn xipat exe, Simão? — io'e. — Abu-bewi ipi kukukayũ dinheiro je'jat ip? Jekpotpoyũ bewi du? Wara'acayũ bewi g̃u xe'e? — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","— Jekpotpoyũ bewi g̃u―wara'acayũ bewi acã — io'e. — Hm hm — Jesus o'e. — Imẽnpuye ipi kukukat ipotpoyũ dinheiro je'g̃ũm g̃u ip dinheiro bubu'ukayũ be — io'e Jesus. — Imẽnpuxim Deus ipot tak dinheiro je'g̃ũm g̃u juy Deus eju kawẽnwẽnap'a muxipanpan'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","— Inaka wuyju dinheiro ag̃ũm cebe ip — Jesus o'e. — Itakomãn g̃u juy ip wuykay. Eju iodi kay — io'e Pedro be. — Pig̃a ejoxik cuy idibi be — ie'em. — Axima juy eju'uk pig̃a bewi koap ma. Axima bi ixik puje, dinheiro'a eyadobuxik axima bi be. Axima bi bewi eyabu juy — io'e. — Ibo'a eyadujowat dinheiro bubu'ukayũ kay Deus eju kawẽnwẽnap'a muxipanpan'ukayũ beam―dinheiro'a. Yamuxipanpanayũ dei je'e owebewi, ewebewi dak — io'e Jesus Pedro be. — Hm hm — io'e Pedro. O'ju. O'yabu. O'yaũm. ");
INSERT INTO myu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","G̃axĩn ma oajẽm ip―imutaybitbinayũ. Oajẽm Jesus kay, Pedro cẽm awap. — Abu je'e ya'õbuyxian wuy'in warara'acat podi ma, Deus xe acesop pima? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Imẽnpuye Jesus bekicat o'tomuwã jekadi am. Jesusyũ bidase cũg̃'i osunuy bekicat. ");
INSERT INTO myu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","— Wara'acat podi ma wuyetabun ibuyxiat pin'ũmat. Bekicat puxim ixe. Ig̃asũ xipacat xeku Deus xe, soat kukan pima õn. Iboap kay juy g̃ebum epesop — io'e Jesus cebe ip. — Wara'at tag̃ jekukum epesop — io'e cebe ip. — Bekicat puxim cuy epesop. Apẽn ite bekicat ya'õbaca pin g̃u, imẽn tak eyju eya'õbaca pin g̃u juy epesop. Eya'õbaca pin'ũm pima, xipan epeyeku Deus xe. Eya'õbaca pin pima, Deus xe g̃u epesop, soat kukan pima õn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","— Eyju xipan bekitkit kug̃ pima, xipan okug̃ tak epesop — io'e Jesus. Ijop bekicat Jesus itabun'isuat puxim. Jesus tieg̃ Jesus kay itabun'isuat ju'kuk xipan pima, Jesus tak ju'kuk xipan ijo'iat. ");
INSERT INTO myu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","— Bekicat mubu'un puje okay itabut am, ikẽrẽat mujurũg̃rũg̃ eyju, okay itabucat mubu'un puje. Imubu'un puje, Deus cuy ipiat supi'ajoat eykay. Imẽn ey'e awap, xipat kuka juk o'e wita'a yabog̃at'a mukirik am eyag̃obu eju iodi be eymuakõm — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","— Og̃uycũg̃ cĩcã, eyju wara'acat mubu'un pima, okay jetabut am. Okay itabucat ikẽrẽan e'e ip, warara'acat cocom ip pima―ikẽrẽan e'e'ukayũ jojom ip pima. Imẽnpuye ikẽrẽan e'e'ukayũ itabotaidadotbot cĩcã jeedop ip, wara'at osubuyxijo buye. ");
INSERT INTO myu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","— Epeyepere juy ikẽrẽat mug̃ug̃ẽap eybõmbicuk pima bit purut ka. Eybu'ũm pima bit purut ka, ikẽrẽat epeg̃ug̃ẽ g̃u. Imẽn eyajẽm Deus kay, ikẽrẽat mug̃eg̃ẽm g̃u buye. Xipat kuka o'e eyõm ãm Deus kay pũg̃pu bima dak. Xipat g̃u kuka o'e eyõm ãm ipiat'ajojoap pe xepxepu ma―daxa epirẽm'ũmap pe. — Epeyepere juy ikẽrẽat mujurũg̃rũg̃ap. Eyĩ'ũm pima bit purut ka, ikẽrẽat epeg̃ujurũg̃rũg̃ g̃u. Imẽn kuka eywebe ipiat'ajoap puxixim, daxa epirẽm'ũmap pe eyjuap puxixim. Imẽn eyajẽm Deus kay, ikẽrẽat kay g̃u epekuku buye. Xipat kuka o'e eyõm ãm Deus kay taokẽrẽat pima dak. Xipat g̃u kuka o'e eyõm ãm ipiat'ajojoap pe taokẽrẽat'ũmat ma―daxa epirẽm'ũmap pe. ");
INSERT INTO myu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","— Epeyepere juy jeakap ikẽrẽat kay. Eyeta'ũm pima bit purut ka, ikẽrẽat epeg̃ẽg̃ẽ g̃u, ipiat'ajoap puxixim, daxa epirẽm'ũmap pe eyjuap puxixim. Imẽn ikẽrẽat mug̃ẽg̃ẽ'ũm pima, eyajẽm Deus xe, ikẽrẽat kay g̃u buye. Xipat kuka o'e eyõm ãm Deus kay pũg̃ta bima dak. Xipat g̃u kuka o'e eyõm ãm ipiat'ajojoap pe xepxepta ma―daxa epirẽm'ũmap pe. ");
INSERT INTO myu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","— Eyday'em'um cuy epesop — io'e jeweju etaybitbinayũ be. — Okay itabun'isuayũ mubekitkin g̃u juy epesop. Ioce eywebe, Deus ekawẽn tojotjot'ukayũ ixeyũ kug̃ soat em. Deus ekawẽn tojotjot'ukayũ jebikuyap tag̃ cepit put ip Deus kay, ceweju kawẽn ãm―webay eju―kabi beat eju. Imẽnpuye eyday'em'um cuy epesop — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","— Soat wag̃o õn. Ijodi ojot ikẽrẽat mujurũg̃rũg̃'ukat taxijo am — Jesus o'e. — Imẽnpuye okay itabun'isuayũ mubekitkin g̃u juy epesop — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip g̃ebuje bit. — Apẽn kuka o'e jeõhõyũ kukukat, iõhõ oitabidao bima? Jeõhõ kudadam je'e xeku. 100 be iõhõyũ―ovelha. Pũg̃ ixeyũ'in pit oitabidao bima, kudadam je'e. Co'a koreren tag̃ warara'acat kõnkõn pima, je'ju itabidaoat kuda am. 99 beayũ bewi je'ju — io'e. ");
INSERT INTO myu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","— Icẽmãn õn e'em eywebe, itabidao topibit tobuxik puje, icokcok cĩcã ma je'e, jeõhõ o'tobuxik puye. Icokcok cĩcã je'e itabidaoat kug̃ oexe buye. Itabidao'ũmayũ kay icokcokap podi ma je'e itabidaoat kay icokcokap — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","— Jeõhõyũ kukukat ibu'u jeõhõ be itabidao am. Imẽnpuxim Deus ibu'u pũg̃ pe ma okay itabun'isuayũ be ma wũy ma jedop am jexewi―wuyebay xewi―kabi beat xewi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","— Eykitpit ikẽrẽat eywebe e'em pima, epeyekawẽn ceweju. Iboap ikẽrẽat muwẽnuwẽn cuy epesop. Eyag̃uypũg̃ ma epeyekawẽn eykitpit eju. Eyekawẽn kay bima, eyburem epesop―eykitpit, eyju dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","— Eyekawẽn kay'ũm pima bit, eyweju epetujowat pũg̃, xepxep eyekawẽn co am. Waram cuy epeyekawẽn eykitpit eju. Eywejuayũ juy imẽn e'e'eap ya'ĩjo. — Ya'ĩjo buje, soat jekawẽn put wuyjuyũ be: “Aceya'ĩjo soat e'e'eap. Imẽn o'e,” i. Imẽn xepxep ekawẽn tag̃, ebapũg̃ ekawẽn tag̃ g̃u xe'e'i. Imẽn opop ibararak Deus ekawẽntup pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","— Ixeyũ ekawẽn kay'ũm pima dak, okay itabucayũ mukũyjom cuy eyju, jeawero puje ip. Ixeyũ ekawẽn kay'ũm pima bit, Judeu'ũmat puxim epejukuk―eykipit epejukuk. Wuywebewi iecug̃ap peam dinheiro bubu'ukat puxim epejukuk―cekay'ũmat puxim — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","— Icẽmãn e'em õn eywebe. Ipi juacat pe, “Deus xe cũg̃ ma ekukuap,” i ey'e buje, kabi be bima iboap kukuap cũg̃ ma je'e. Ipi juacat pe, “Deus xe cũg̃ g̃u ekukuap,” i ey'e buje bit, kabi be bima iboap kukuap cũg̃ g̃u je'e Deus xe — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Xepxem kawẽnwẽn pima eyju Deus eju pũg̃ tag̃ ma, eybikuyap tag̃ ma webay je'e eywebeam―kabi beat je'e — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","— Xexep xe'e, ebapũg̃ ma xe'e omubuyxi am jeawerorom pima, õn tak e'em ixeyũ xe — io'e. ");
INSERT INTO myu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","G̃ebuje Pedro o'jekawẽn Jesus eju. — Ocexe ibuyxiat — io'e. — Pebũrũ em cuy oceg̃ebu g̃u ikẽrẽat kay? ―owebe okitpit ikẽrẽãn e'eap kay? 7 em ma du? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","— Ka'ũma — Jesus o'e. — 7 em g̃u ma. Ade em ma―490 em ma — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pedro ekawẽn buye, Jesus o'jekawẽn iboceayũ be. Deus soat kukanap muwẽnuwẽn o'e. O'jekawẽn iboceayũ mutaybitbin. — Webay ipi kukukat puxim — io'e Jesus. — Kabi beat webay. Imẽnpit ipi kukukat puxim. Ipi kukukat oajẽm jekapikpik'ukayũ kay. Kapikpik'ukayũ bewi ceweroaptei bu am, oajẽm ipi kukukat. ");
INSERT INTO myu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","— Koap em kapikpik'ukat o'tujot ip jekariwa be. Ade jĩjã ceaweroap o'e―mil be dinheiro'a―prata mug̃ẽg̃ẽat'a. ");
INSERT INTO myu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Imẽnpit ixe kapikpik'ukat kaka g̃u dinheiro. Cedinheiro o'e g̃u ceaweroap teida am. Imẽnpuye jekariwa ja'õbi o'g̃uju soat tuk'a beat ũm ãm, teida am―itayxi ũm ãm, ipotpoyũ ũm ãm tak. ");
INSERT INTO myu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","O'jẽg̃'aecõg̃cõg̃ cewap. — “Imẽnpuk,” io'e jekariwa be. “Oteida g̃uyjom soatei,” io'e kapikpik'ukat. ");
INSERT INTO myu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kapikpik'ukat a'õ buye, cekariwa itabotaidabotbot o'e cekay. — “Eaweroaptei eg̃ũm g̃u juy owebe,” cekariwa o'e cebe. “Pũg̃ em tak ka'ũma,” io'e kapikpik'ukat pe. — “Xipat cĩcãat ẽn,” io'e kapikpik'ukat. ");
INSERT INTO myu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","— O'ju. Kapikpik'ukat o'ju jebureyũ kay―kapikpik'ukayũ kay. Dao ma o'topabijuk jekapikap peayũ. Pũg̃ ma ceaweroap 100 dinheiro osunuy. Yopĩt ma dinheiro osunuy. O'jat jebure yag̃obu eju. — G̃ebuje o'yag̃obuaha. — “Eaweroap owebe eteida,” io'e. ");
INSERT INTO myu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","O'jẽg̃'aecõg̃cõg̃ cewap. — “Obure!” io'e. “Etabotaidabotbot okay,” io'e. “Õn soat oteida g̃uyjom―weaweroap,” io'e jebure be. ");
INSERT INTO myu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","— Ixe imẽnpit: “Ap!” io'e. “G̃axi ma õn cekay,” io'e. — “Iba'ore. Dinheiro kug̃ g̃u õn,” io'e. Imẽnpuye ibure daomũnmũnap'a be o'g̃uju. — “Eaweroap teida buje acã, ecejẽm,” io'e ibure. ");
INSERT INTO myu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Warara'acat kapikpik'ukayũ itakoma ip o'e jebure awẽg̃ cocom pima. — G̃ebuje ip jeipi kukukat pe o'ju. Soat o'g̃uwẽn ip jeipi kukukat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","— G̃ebuje kapikpik'ukat ekariwa o'tomuwã. — “Kapikpik'ukat,” io'e. “Xipat'ũmat,” io'e cebe. “Juk ece owebe, ‘Imẽnpuk. G̃uyjom cuy oteida,’ i. Imẽnpuye eteida'ũmap kay kuy g̃ebum g̃u oce. ");
INSERT INTO myu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wetabotaidabotbot og̃uy ekay õn pit. Imẽnpuxim ma juy eg̃uy ẽn tak ebure kay,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","— Kariwa itakoma jĩjã o'e kapikpik'ukat kay. Imẽnpuye o'g̃uju daomũnmũnap'a be ipiat'ajo am. — “Teida buje acã dak ecejẽm,” io'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eyju dak eyetabotaidabotbot'ũm pima eywag̃oyũ kay, ikẽrẽat kay g̃ebum puye; imẽnpuxim webay dak―kabi beat tak itabotaidabotbot g̃u je'e eykay, ikẽrẽat kay g̃ebum puye — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jekawẽn epere buje, Jesus Galiléia eipi bewi o'ju. Jepitpin o'e Jesusyũ. Judéia eipi kay oajẽm. Wara'at kadi be ma oeku. Jordãodi wĩnãbu ma oeku. ");
INSERT INTO myu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Adeayũ o'ju Jesus tomuju. Ade jĩjã. O'ju ibo ka beayũ―iwãtaxipipiayũ Soat o'g̃u'ada. Judéia eipi be o'g̃u'ada Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseuyũ oajẽm ip cekay waram. Jesus a'õ muwarurunap ojuy ip. — Wuyawẽwẽap tag̃ tu wuytayxi epereperem, wuyxe cũg̃'ũmap tag̃ jekukum pima xeku? — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","— Epetupco juy Deus ekawẽntup — Jesus o'e cebe ip. — Imẽn ibodup e'em: Kuyje soat mug̃ẽg̃ẽ'ukat ag̃okatkat o'g̃ug̃ẽ, ayacat tak. Ixeyũ o'g̃ug̃ẽ xepxem ma jekuku am, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","— Imẽnpuye Deus o'jekawẽn cebe ip―ag̃okatkat pe, ayacat pedak. Jetayxi bu buje, ag̃okatkat cẽmcẽm jebay duk'a bewi, jetayxi eju cucum. Jektop pu buje, ayacat tak jektop eju cucum, i. Xepxep ma ip. Imẽnpit pũg̃at puxim ip o'e jewekug̃ soat em jeweweju ip cucum puye. Imẽnpuye eytayxi juy epeyepere g̃u. Pũg̃at puxim eyju Deus a'õbi. Deus xe eyju pũg̃ ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","— Apẽneju Moisés o'e: “Eytayxi epere pin pima, ‘Otayxim g̃u ece g̃asũ bit’ iaptup cuy epetupmubararak. G̃ebuje ibodup epetupũm ayacat pe, epere am,” i? ");
INSERT INTO myu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","— Moisés imẽn o'e, eybu'u jĩjã buye ya'õ dag̃ jeku am. Kuyje bit imẽn g̃u o'e. Kuyje Deus soat o'g̃ug̃ẽ. ");
INSERT INTO myu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","— Ibocewi e'em õn eywebe. Ag̃okatkat jetayxi epere buje, wara'at pu am pima, ikẽrẽ cĩcãat mug̃ẽg̃ẽm. Itayxi koapat jektop eju acã o'jepo. Imẽn pima, ixe ag̃okatkat ikẽrẽat mug̃ẽg̃ẽm itayxi be. Imẽnpuye ikẽrẽat o'g̃ubapukpuk ixe ag̃okatkat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","— Ibu'u'u ip pima jewewekay, xipat kuka o'jewebumũn g̃u — io'e ip―Jesus eju etaybitbinayũ o'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","G̃ebuje Jesus o'jede. — Soat pe g̃u õn e'em imẽnpit. Pũg̃pũg̃ ma ig̃o ekawẽn tag̃ jekukum. Deus ixeyũ mubacan'ũm pima, iba'ore cebe ip jag̃epũg̃ ma jeku am. ");
INSERT INTO myu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","— Ig̃o ekawẽn tag̃ jewebumũnmũn g̃u ip Deus a'õbi. Deus soat kukanap kay jĩjã ip. Imẽnpuye jewebumũnmũn g̃u ip. Warara'acat pit jewebumũnmũn g̃u ip―ag̃okatkayũ. Jewebumũnmũn g̃u jekapap pibun; iba'ore cebe ip ayacat mu'ukreg̃ am. Warara'at tak jewebumũnmũn g̃u pũg̃ ma o'subudakacap pibun; iba'ore cebe dak. — Imẽneju soat pe g̃u õn e'em. Ig̃o ekawẽn kayayũ be acã õn e'em. Cekay butayũ ig̃o ekawẽn tag̃ cuy jekukum ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","G̃ebuje iboceayũ bekitkit o'tojot ip Jesus kay. Bekicat yabi jeje jebumõg̃ ãm, o'tojot Jesus kay. Bekicat peam kawẽn ãm Deus eju, o'tojot ip. — Bekicat cuy epetojot g̃u juy Jesus kay — io'e ceweju etaybitbinayũ iboceayũ be. Imẽn iboceayũ o'g̃ukorẽm ip. ");
INSERT INTO myu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","— Ãg̃ jeedot ip bekitkit okay — Jesus pit o'e. — Imubu'un g̃u juy okay imudot am. Ixe bekitkit oxe yajẽm pin ip. Imẽnpuxim Deus soat kukanap kabia soat ip yajẽm pin oxe―okay itabucayũ — io'e. — Imẽnpuye epeg̃udot cuy okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O'jebumõg̃ bekitkit abi jeje, bekicat peam kawẽn ãm Deus pe. O'ju. ");
INSERT INTO myu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pũg̃ em ibubut adeat oajẽm Jesus kay. — Omutaybitbin'ukat! — io'e Jesus pe. — Soat em Deus xe og̃uy pin wetait. Apẽn xipacat oce'e juy, soat em cexe og̃uy am? — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","— Apẽnpuye ecekawẽn owebe, “Apẽn xipacat oce'e juy?” i. Pũg̃ acã xipat cĩcãat. Deus xeku. Apẽn wuye'ajojoyũ'ũm'ũm pe Moisés o'e iap tag̃ cuy jekukum ecesop — io'e. — Imẽn jekukum pime, etait eg̃uy cexe soat em. ");
INSERT INTO myu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Ajo a'õ dag̃ cuy oceku Moisés ekawẽn'in? — io'e. — Ig̃o a'õ dag̃ — io'e Jesus. Warara'acat epeyaoka g̃u juy, i. Wara'acat tayxi kay g̃u juy, i dak. Eybukurug̃ g̃u juy epesop, i dak. Warara'at awẽg̃ mukẽrẽrẽrẽn g̃u juy epesop, i dak. ");
INSERT INTO myu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ibuyxim cuy eyebay epejukuk, eyxi dak, i dak. Eyxeat ikukpin epejukuk eyewekukap puxim, i dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","— Ijop ekawẽn tag̃ ojekukuku―soat tag̃ — io'e. — Ajo dak g̃uto og̃ũg̃ẽ? — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","— Soat tag̃ oweju jekuku am, ebubut cuy eteida―soat ma. Ibo juy dinheiro tei'ũma eg̃ũm tadaibocayũ be — io'e. — Imẽn e'e buje, ade je'e ebubut kabi be — io'e. — G̃ebuje ejot okay, oweju jekuku am soat em — io'e Jesus. — Iba'ore — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ig̃uycũg̃ cĩcã o'e, Jesus ekawẽn puye, ibubut ade jĩjã buye. Tacup o'e jebubun. O'jenapõn ixe. ");
INSERT INTO myu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Iba'ore jĩjã ibubut adeat õm ãm Deus xe kabi be — io'e cebe ip. — Ibu'u jĩjã ip Deus a'õ kay ãm, itabut cĩcã ip jebubut kay buye. ");
INSERT INTO myu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Camelo ikap pa'ore awi daobi'atok tag̃. Imẽnpit ibodi ma iba'ore ibubut adeat õm ãm Deus xe, kabi be — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jewag̃uy mug̃ẽg̃ẽm o'e ip, iboap co buje. — Abu jewedaxijo but? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Imẽnpuye Jesus o'jeak cekay―iboceayũ kay. — Wuywedaxijo ba'ore soat em Deus xe wuydop am — io'e cebe ip. — Deus pe bit soat i'e but — io'e. — Deus pe soat daxijo but — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","— Pãm oceju? — Pedro o'e. — Kuy soat ocesuiwat eweju jeku am. Ajo dak ocejat? — io'e. ");
INSERT INTO myu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","— Icẽmãn õn e'em eywebe. Soat wag̃o õn — io'e Jesus. — Ipi be wepit puje, iisu e'em soat ma ipi dag̃. Xik'i e'em õn. Israel diwacayũ kay ya'ĩjojo oce'e. Wa'õbuyxi jĩjãat oce'e. Ajo xipat Deus xe iap og̃uwẽn cebe ip―ajo xipat'ũm Deus xe iap tak. Eyju ma dak Israel diwacayũ epeyewede―12 beayũ diwacayũ. Eyju dak xikxik'i epesop. Epeg̃uwẽn cebe ip ajo xipat Deus xe iap, ajo xipat'ũm Deus xe iap tak. ");
INSERT INTO myu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","— Owebeam soat xewi o'juiayũ ade jĩjã je'jat ip. 100 beat je'jat ip. Jeduk'a bewi o'juiayũ, jeipi bewi o'juiayũ dak, jebadipyũ xewi o'juiayũ dak; jewag̃o xewi o'juiayũ, jekitpit xewi o'juiayũ, jebay xewi o'juiayũ, jexi xewi o'juiayũ, jekpotpoyũ xewi o'juiayũ, jedaxityũ xewi o'juiayũ―soat ip ade jĩjã xipacat je'jat ip. Deus xe dak itait jeedop ip soat em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","— Ade ya'õbuyxiayũ'in yopĩcayũm jeedop ip. Ade yopĩcayũ'in ya'õbuyxiayũm jeedop ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Deus soat kukan pima, uva'a kug̃ jekat peat puxim ixe. Xeku kapikpikayũ kudadam o'e, jewebeam kapik am. Imẽn Jesus ekawẽn o'e jewejuacat mutaybit am. Wuymutaybitbinap muwẽnuwẽn o'e―imẽnpuximap ekawẽn. — Ixe uva kug̃ jekat peat o'ju jebuywatwacayũ kudadam. Kabia isum o'ju, jekat pe tujowat am — io'e. — O'ju — io'e. ");
INSERT INTO myu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","— “G̃asũ epeju, okat pe obuywat am,” io'e cebe ip―soat pe. “Pũg̃ kabia oteida―eyekapikapteim. Okat pe eyepere buje, oteida. Pũg̃ isurũg̃at'a eyekapikaptei e'em―prata'a,” i. Imẽn o'e cebe ip, iboaptei ibabi dag̃ o'e buye―jeka beacat pabi dag̃. — “Xipat,” io'e ip. Imẽnpuye soat o'ju ip ikat pe, ibuywan. ");
INSERT INTO myu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","— Kabia isusu ma o'ju waram kapikpikayũ kuda am. 9 hora bima o'ju. O'tobuxik warara'acayũ―xerem g̃u pẽnpẽnayũ. — Oajẽm ka'ũmg̃u pẽnpẽnayũ kay. Ceaweroroap pe oajẽm―tarekrek muxipanap'a be. ");
INSERT INTO myu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","— “Epeju okat pe. Oteida eywebe eykapikaptei―ajo cũg̃ ma iaptei,” io'e cebe ip. — “Hm hm,” io'e ip. “Ebuywan oceju,”. ");
INSERT INTO myu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Imẽnpuye ip o'ju. — Kariwa waram o'ju. Kaxicug̃ ma waram o'ju. Uvadip kat iwat o'ju. Warara'acayũ o'tujowat jekat pe, kapik am. — Katpujesu warara'acayũ o'g̃uju jekat pe, kapik am tak. 3 hora bima o'g̃uju. ");
INSERT INTO myu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","— Katpuje oeku. 5 hora bima, oeku. Warara'acayũ o'tobuxik―ka'ũma pẽnpẽnayũ. Ceaweroroap pe ip o'e. — “Apẽnpuye eyju kabia bun kapikpig̃ g̃u?” io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","— “O'e g̃u ocewebe buye, oceju g̃u,” io'e ip. — “G̃asũ bit eyju dak õn jeymuju. Oteida eywebe,” io'e. — “Hm hm,” io'e ip. Imẽnpuye o'tujowat jekat pe, kapik am. ");
INSERT INTO myu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","— Kaxi cẽm pima, ixe uvadip kat iwat jedinheiro kukukat o'tomuwã. — “Kapikpikibiyũ etomuwã juy, cekapikaptei ũm ãm,” io'e. “Katpuje ajẽmibiyũ ekapikaptei juy eg̃ũm cebe koam. G̃ebuje katpujesu ajẽmibiyũ be juy eg̃ũm. G̃ebuje kaxicug̃ ajẽmibiyũ be. G̃ebuje kabia isusu ajẽmibiyũ be. Kabia isu ajẽmibiyũ ekapikaptei eg̃ũm kanomũm,” io'e cebe. — “Hm hm,” io'e jekariwa be. ");
INSERT INTO myu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","— Katpuje ajẽmibiyũ o'tomuwã 5 hora be ajẽmibiyũ. Cekapikaptei o'g̃ũm cebe ip, ajẽm puje. Pũg̃ kabia ekapikaptei o'g̃ũm cebe ip. O'jat. O'ju ip. ");
INSERT INTO myu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","— Kabia isu ajẽmibiyũ ekapikaptei o'g̃ũm kanomũm. Tũybe ade ocejat ocekapikaptei iãn o'e ip. Imẽnpit ibitbit ma ip o'jat jedinheiro―jekapikaptei―katpuje ma ajẽmibiyũ ekapikaptei, kabia isu ajẽmibiyũ ekapikaptei dak. ");
INSERT INTO myu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Imẽnpuye uvadip kat iwat kay ip o'e jemãmãmãm. ");
INSERT INTO myu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","— “Katpuje acã kapikpig o'e ip―wara'acayũ. Cũg̃ g̃u o'e tei jo'iat kuka ocedei,” io'e ip. Jemãmãmã ip. “Pũg̃ hora acã kapikpig̃ o'e ip. Oceju bit kapikpig̃ soat em ma―kabia isum pima, kaxicug̃ pima dak. Kajepi kug̃ cĩcã oceju, kapikpig̃ puye,” io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","— “Obure,” io'e uvadip kat iwat jemãmãmãmaat pe. “Xipat õn. Og̃ũm ekapikaptei wa'õ dag̃. Cũg̃at õn. — “‘Pũg̃ kabia ekapikaptei oteida―eyekapikapteim,’ i'e buje, ẽn tak ‘Xipat,’ iece owebe,” io'e jemãmãmãmãat pe. ");
INSERT INTO myu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Imẽn eywebe og̃ũm, katpuje ma ajẽmibiyũ be dak og̃ũm,” io'e. “Teku ekapikaptei,” io'e. “Etujopit eduk'a kay,” io'e. ");
INSERT INTO myu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","— “Etakoma g̃u okay eg̃uy, odacup g̃u buye,” io'e cebe. “Wedinheiro ma beku,” io'e. “Õn bũrũku poro teida pin,” io'e uvadip kat iwat jemãmãmãmãat pe. ");
INSERT INTO myu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","— Imẽntak — Jesus o'e. — Deus icẽmat cĩcãat. Ajo xipat cexe iam, ajo xipat g̃u cexe iam kawẽnwẽn je'e soat pe. Soat ijo'in ma je'e — io'e Jesus. — Imẽnpuye ade ya'õbuyxiayũ'in yopĩcayũm jeedop ip. Ade yopĩcayũ'in ya'õbuyxiayũm jeedop ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalém ka kay cucum pima, Jesus jeweju etaybitbinayũ jewekay o'tomuwã adeayũ parakpewi. O'jekawẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","— Eya'õpicũg̃cũg̃ cuy epesop! — io'e cebe ip. — Jerusalém ka kay cum wuyju — io'e Jesus. — Soat wag̃o õn. Iboceayũ osubamukirik, okay itakomaayũ be odujowat am―paĩyũ kukukayũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. “Ikẽrẽat kug̃ ẽn ocexe,” i je'e ip owebe — io'e Jesus. — “Eje'ũ juy,” i je'e ip owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Judeu'ũmayũ be odujowat ip — io'e. — Owaywayway jĩjã je'e ip. Omupokupok ip. Korosa jeje oba mupaya ip. Oaoka ip. Imẽnpit xepxep xet kap puje, waram g̃uto ocetait — io'e 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","G̃ebuje Zebedeu tayxi oajẽm Jesus kay. Je'iyũ eju oajẽm―ag̃okatkayũ eju. Ojẽg̃'aecõg̃cõg̃ Jesus wap. Ibikuyap kay o'e Jesus xewi. ");
INSERT INTO myu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","— Ajo-kay ẽn? — io'e Jesus cebe. — O'iyũ dak imẽn cekay, pũg̃ xik'i eba'at kadi, wara'at eba'ũg̃at kadi. Imẽn õn cekay, ẽn soat kukan puje — io'e. — I juy ece owebe: “Ekawẽn tag̃ oce'e ewebe,” i — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","— Iba'ore — Jesus o'e cebe ip. — Eyetaybit pũn'ũma eyju iboap ojuyjuy oxewi. Apẽn owebe ipiat o'supi'ajoat ip iap puxim tu eywebe dak ipiatsupi'ajoat ip? — io'e. — Hm hm — io'e ip. — Ocewebe dak ipiatsupiajoat ip apẽn ewebe ipiat o'supi'ajoat ip iap puxim — io'e Zebedeu ipotpoyũ. ");
INSERT INTO myu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","— Ha'a — io'e Jesus. — Apẽn owebe ip ipiat o'supi'ajo iap puxim ma eyju dak ipiat epesupi'ajojo — io'e cebe ip. — Imẽnpit wa'õbi g̃u jeedop ip oba'at kadi―webay a'õbi acã jeedop ip. Wa'õbi g̃u jeedop ip oba'ũg̃at kadi―webay a'õbi acã jeedop ip. Deus a'õbi acã ixeyũ iboka kaxikxik'i jeedop―Deus o'taẽiayũ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Warara'acat iboam co buje bit, itakoma o'e ip xepxepayũ kay―Zebedeu ipotpoyũ kay. 10 beayũ itakoma o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Imẽnpuye Jesus: — Epesot cuy okay — io'e cebe ip―soat pe. — Eyetaybit Judeu'ũmayũ kukukayũ soat em ya'õpurug̃ jebekitkiyũ mujujum iam — io'e cebe ip. — Ikukukayũ soat em big̃ ma jebekitkiyũ mukapikpig̃'uk ip iam — io'e. — “Oca'õbuyxi jĩjã,” i'e'em ip jebekitkit pe soat em. ");
INSERT INTO myu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eyju bit ka'ũma. Imẽn g̃u juy epeyewekuk. Eyju bit kariwabog̃ pin pima, warara'acat puywatwan cuy epesop. ");
INSERT INTO myu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ya'õbuyxian pin pima, eybureyũ beam tei'ũma epeyekapikpik cuy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","— Imẽntak soat wag̃o õn — Jesus o'e. — Warara'acat pe obuywat am g̃u ojot ijodi. Warara'acat puywatwat'ukan ojot. Adeayũ daxijo am ma ojot. Soat em itabẽg̃ jeedop ip kabi be, cewebeam oje'ũ buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó ka bewi o'ju ip―Jesusyũ―adeayũ. Jesus tomuju o'ju ip. ");
INSERT INTO myu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Xepxepayũ oabik e bitako dag̃―ita'ũmayũ. — Jesus ijoma kapkam — adeayũ o'e ita'ũmayũ be. G̃ebuje ya'õberen o'tomuwã ip Jesus kay. — Davi naxeg̃ebit ẽn. Etabotaidabotbon cuy eg̃uy ocekay — ita'ũmayũ o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","— Mũg̃'i juy epesop! — io'e adeayũ. O'g̃ukorem̃. Imẽnpit big̃ ma o'jewãwã ya'õberen. — Kariwa! — io'e ma'g̃uto. — Davi naxeg̃ebit ẽn. Etabotaidabotbon cuy eg̃uy ocekay — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","O'jecũ Jesus. — Epesot okay — io'e ita'ũmayũ be. O'ju ip cekay―Jesusu kay. — Ajo-kay eyju oxewi? — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","— Ocetadam ece — io'e ip jekariwa be. — Jetada õn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","— Ita'ũmayũ kay wetabotaidabotbot — io'e. Ita o'sutamucay itamudim am. Iboap e isum ma o'jewetada. O'jecoan ip. Jesus tomuju o'ju ip, o'je'ada buye. ");
INSERT INTO myu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalém ka tẽg̃ pima Jesusyũ, oajẽm ip Betfagé ka kay. Co'a bicũg̃pe osunuy―Oliveiradip'a bicũg̃pe. Ibocewi jeweju etaybitbinayũ o'g̃uju Jesus. Xepxep o'g̃uju. Wara'at ag̃oka kay o'g̃uju. ");
INSERT INTO myu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","— Epeju juy ag̃oka kay―wuywapat ka kay — io'e. O'g̃ukũyjo. — Bomaku epeju. Dao ma jumenta epetobuxik. I'it'it eju ma juy epetobuxik — io'e. — Ikirikirik opop ip. Epeg̃uwekap cuy. — Imuwekap puje, epetojot okay jumenta, i'it tak — io'e Jesus xepxepayũ be. — Hm hm — io'e ip. — Ocetojot cuy. ");
INSERT INTO myu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","— “Ajo pẽnpẽn eyju?” i'e'em iboceayũ eywebe bima, “Ikug̃'ũm puye, ocekariwa jumenta kay, i'it'it kay dak,” i juy epe'e cebe ip — io'e Jesus. — “Ha'a. Epetujowat g̃axĩn ma,” iboceayũ je'e eywebe — Jesus o'e. — Okay imujujum je'e — Jesus o'e. — Hm hm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","11","Jesus a'õbi o'ju ip. Jumenta o'tobuxik ip. Ikirikirik osunuy. O'g̃uwekap ip. I'it'it tak o'g̃uwekap ip. Jesus kay o'tujuajẽm. Jeekabek jumento ukxabi jeje o'jomõg̃ ip. Oabik Jesus iekabek ceje jumento ukxabi jeje. Ade jĩjã iboceayũ jeekabek o'g̃upayapaya ip Jesus wap e dag̃, ya'õbuyxi cexe ip puye. — Xipat cĩcãat Jesus — io'e adeayũ―Jesus wap cuibiyũ, tomujuayũ dak. — Davi naxeg̃ebit teku. Deus kuy imucokcokcog̃, Deus a'õbi oajẽm teku wuykay buye. Deus ya'õbuyxi jĩjã. Idip cĩcã — io'e ip ya'õberen, icokcok cĩcã buye. Jerusalém ka kay oajẽm Jesus. Soat Jerusalém watwat yag̃uybabi'ũm o'e ip, jetabiba'arẽm puye. — Abu sute? — io'e ip. — Jesus teku — adeayũ o'e cebe ip. Itaybicayũ o'e. — Nazaré ka wat teku. Deus ekawẽn muwẽnuwẽn'ukat teku―Galiléia eipi bewiat — io'e ip. Imẽn soat o'jebapuk apẽn Deus ekawẽn muwẽnuwẽn'ukat o'tupmubararak Deus a'õbi. Imẽn juk adi o'jekawẽn: Jerusalém watwat cuy epeg̃ukũyjo: “Eykukukat omuyku. Jumento ukxabi jeje xik'i omuy―jumenta'it'it ukxabi jeje. Ya'õdidiat eykukukat je'e,” i juy epe'e — i juk o'e―Deus ekawẽn muwẽnuwẽn'ukat o'e. ");
INSERT INTO myu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Oajẽm Jesus puca deidada'ukayũ kay. Deus eju kawẽnwẽnap'a be osodop ip, puca bubu'ukayũ dak. Yabogat'a be osodop ip. Dinheiro mutrokakan'ukayũ emesa o'g̃uy'at. Wũn'i! Pukaso deidada'ukayũ abikbikap o'g̃udu'udu. Batku! Yabikbikap o'g̃uy'at Jesus. O'g̃ujẽm soat ip. ");
INSERT INTO myu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","— Deus ekawẽntup e'em: Oduk'a soat ka dag̃wiacat oweju kawẽnwẽnap'am je'e, i'e'em Deus ekawẽntup. Eyju bit Deus tuk'a epeyamuwexat ibukurukat dopdopap'am Jesus o'e cebe ip. Imẽn o'e Jesus, dinheiro bu am, Deus tuk'a be ajẽmjẽmayũ mug̃uykukum ip puye. ");
INSERT INTO myu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Taokẽrẽayũ oajẽm Jesus kay. Ita'ũmayũ oajẽm. Deus eju kawẽnwẽnap'a be osodop ip. Soat o'g̃u'ada Jesus―ita'ũm topibiyũ, taokẽrẽ topibiyũ dak. ");
INSERT INTO myu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","— Xipat cĩcãat teku — bekicat o'e, Jesus muwẽnuwẽn o'e. — Davi naxeg̃ebit teku — i'e'em ip. Idip ma o'jekawẽn ip. Paĩyũ kukukayũ bit itakoma o'e ip Jesus kay, Deus eju kawẽnwẽnap'a be ma bekicat o'jekawẽn puye, ade o'g̃u'ada buye dak. Moisés ekawẽn imutaybitbin'ukayũ dak itakoma o'e. ");
INSERT INTO myu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","— Eya'ĩjojo g̃u du bekitkit ekawẽn? — io'e ip Jesus pe. — Hm hm — Jesus o'e. — Oya'ĩjo ma. Imẽn tag̃ Deus ekawẽntup e'em: Deus bekitkit o'g̃utaybit cedag̃ ma jawẽg̃mudim am―yopĩcat tak, i. Iboaptup cuk epetupcoco g̃u du? — io'e Jesus. — Iboam eyetaybit — io'e paiyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","O'ju Jesus Jerusalém ka bewi. Betânia ka kay oajẽm. Jexecap ka kay oajẽm. ");
INSERT INTO myu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kabia bima, o'jepit Jerusalém ka be. Jepitpin pima, ire o'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Figueira'ip o'yopcoco, jepitpin pima. E bidase osunuy ibo figueira'ip. Oajẽm yopkay―figueira'ip kay. O'yadobuxik g̃u figueira'a. Ya'ũmg̃u figueira'a. Tup acã o'tuptobuxik. Tõh! — A'a'e g̃u ece'e — io'e Jesus figueira'ip pe. — Waram ma dak ka'ũma — io'e. G̃ebuje figueira'ip dao ma o'je'ip'e'ũ. ");
INSERT INTO myu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jesus eju etaybitbinayũ yopco buje, yag̃uybabi'ũm o'e ip. — Apẽneju dao ma ig̃o'ip yoporo g̃asũ? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","— Soat em eyetabut okay bima, eyju dak kuka epe'e apẽn figueira'ip pe oce iap puxim. Epeyopmupuruk kuka — Jesus o'e cebe ip. — Ka'ũma ibo bit. Eywebe dak i'e but ite co'a be: “Wede ece ijocewi. Aakõm cuy idixidi be,” i. Imẽn yaakõm, Deus yamuakõm puye, Deus kay eyetabut puye. ");
INSERT INTO myu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Deus kay eyetabut pima, epejoojoy epejat, Deus eju kawẽnwẽn pima dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jay. Waram oajẽm ip Jerusalém ka be. Deus eju kawẽnwẽnap'a be oõm ip. Adeayũ mutaybitbin o'e Jesus yabog̃at'a be. Imutaybitbin pima, paĩyũ kukukayũ oajẽm, Judeuyũ kukukayũ dak. — Abu-a'õbi ẽn jekukum? Deus a'õbi du? Abu-a'õbi ijop e'eap tag̃ jekukum ẽn? — paĩyũ kukukayũ o'e cebe. Imẽn tak Judeuyũ kukukayũ o'e cebe. ");
INSERT INTO myu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","— Koap cuy eyju ma omukũyjom cuy epe'e apẽn oce — Jesus o'e. — Iboap muwẽn puje, õn tak ocede eywebe eyetaybit am abu-a'õbi jekukum õn iam. ");
INSERT INTO myu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","27","— Abu-a'õbi juk oeku João Batista? Abu-a'õbi juk ocemubatisasan o'e xeku? Deus a'õbi ma du eyxe? Ijodiat a'õbi g̃u xe'e eyxe? — io'e Jesus cebe ip. — Ocetaybit g̃u — io'e ip Jesus pe. Imẽn o'jekawẽn ip Jesus pe, jeyag̃uy dag̃. — Cebe wuy'e buje, “Deus a'õbi,” i, “Apẽnpuye dak eyetabut g̃u João kay?” i kuka o'e wuywebe — io'e ip jewewebe. — “Ijodiat a'õbi,” i wuy'e bima bit, adeayũ itakoma kuka o'e ip wuykay, ixeyũ xe João Deus ekawẽn muwẽnuwẽn'ukat puye — io'e ip jewewe be. Imẽneju o'jekawẽn ip Jesus pe: — Ocetaybit g̃u — io'e ip. — Kã — io'e. — Abu-a'õbi João Batista oeku iap epeg̃uwen g̃u owebe. Õn tak og̃uwẽn g̃u eywebe abu-a'õbi õn jekukum iap — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus o'jekawẽn tak. — Eya'õpicũg̃cũg̃ cuy epesop wekawẽn kay — Jesus o'e iboceayũ be. Wuymutaybinap ekawẽn o'g̃uwẽn. Uvadip kat iwat muwẽnuwẽn o'e. — Ixe uva'a kukat xepxep ipotpoyũ osodop. Koapat pe o'jekawẽn: “Okpot,” io'e cebe. “Kapig̃ cuy ẽn g̃asũ okat pe.” ");
INSERT INTO myu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","— “Ap!” io'e. Imẽnpit gũyjom o'jewag̃uy: “Kapig̃ cuy õn webay beam,” i. Imẽnpuye o'ju jebay kat pe kapig̃. ");
INSERT INTO myu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","— Wara'at pe o'jekawẽn―cebay o'jekawẽn: “Okpot,” io'e wara'at pe. “Kapig̃ cuy g̃asũ okat pe.” — “Hm hm,” io'e. “Kapig̃ puk õn. Cum puk õn,” io'e jebay be. Imẽnpit o'ju g̃u jebay kat pe. ");
INSERT INTO myu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","— Pebicat jebay bikuyap tag̃ oeku? — Jesus o'e iboceayũ be. — Koapat ma — io'e ip. — Cũg̃ ma epeyekawẽn — Jesus o'e. — Yapoayũ ixe koapat puxim ip, iecug̃ap peam dinheiro bubu'ukayũ dak. Ibuxim ip, João kay itabut puye ip. Deus soat kukan pima, ixeyũ dak Deus xe jeedop ip. Eyju bit ka'ũma! João oajẽm imuwẽn ãm apẽn cũg̃ ma Deus etabun iap. Eyju bit eyetabut g̃u cekay. Cekay itabucayũ epejojojo. Imẽnpit eyetabut g̃u João kay — io'e Jesus. — Ikẽrẽãt kug̃ epesop. Imẽnpit eyg̃uycũg̃ g̃u epesop ikẽrẽãt kay―eyetabut'ũmap kay. Deus a'õ kay jekuku pin g̃u eyju — Jesus o'e paĩyũ kukukayũ be, Judeuyũ kukukayũ be dak. ");
INSERT INTO myu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Waram tak o'jekawẽn Jesus―wuymutaybitbinap ekawẽn―imẽnpuximap ekawẽn. Ag̃okatkat jekat o'tiotaap muwẽnuwẽn o'e. — Ag̃okatkat uva bune o'subunedaida — io'e Jesus. — Pere g̃ebujep — Jesus o'e. — G̃ebuje korara o'g̃ug̃ẽ jekat etako dag̃. Uvadip koreren o'jomuy. Pere. Uva'abidi muwesog̃sog̃ap tak o'g̃ug̃ẽ jekat pe. — G̃ebuje uvadip wiwimap'a o'yamuy jekat pe―kadaidip wiwiap'a―umat'a. Pere. O'jepere. — G̃ebuje uvadip wiwimayũ o'jomuy jekat pe, uvadip wiwi am bomaku. Uva'a o'yaũm cuy ip ikat iwat pe. Imẽn teim ip iũm cuy uvadip iwat pe. — Ikat iwat wara'at eipi kay o'ju. Iboma omuy wara'at eipi be. ");
INSERT INTO myu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","— Yabubuap ekaxi ajẽm puje, jebuywatwat'ukayũ o'g̃uju jekadai'a bu am―pũg̃pũg̃'a jekat peat'a'in. ");
INSERT INTO myu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","— Oajẽm ip uvadip wiwiayũ kay. — “Ijo'a bum ocesot,” io'e ip. “Ikat iwat a'õbi ocesot,” io'e ip. — “Ap!” uvadip wiwiayũ o'e. Ibu'u ip o'e yaũm ãm. Uvadip wiwiayũ oajẽmiayũ o'jat ip. Pũg̃ ixeyũ'in o'yaoka ip. Pog̃. Wara'acayũ ixeyũ'in o'yabug̃bug̃ ip wita'am. Warara'acayũ ixeyũ'in yaokakam ip. O'jenapõnpõn ip―ikat iwat buywatwat'ukayũ. ");
INSERT INTO myu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","— Waram g̃uto wara'acayũ o'g̃uju ixe kadaidip iwat. Jebuywatwat'ukayũ o'g̃uju cekay ip―uvadip wiwiayũ kay. Ade o'g̃uju. — Oajẽm ip. Uvadip wiwiayũ bit oajẽmiayũ o'jat ip. Pũg̃pũg̃ o'yaokaka ip. Wara'acayũ o'yaoka ip. Warara'acat o'yabug̃bug̃ ip. Imẽnpuye ibuywatwat'ukayũ o'jepit jekariwa kay―ikat iwat kay. ");
INSERT INTO myu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","— Imẽneju ikat iwat jekpot o'g̃uju cekay ip―uvadip wiwiayũ kay. Tũybe ibuxim ip okpot jukuk iãn o'e―ikat iwat o'e. O'g̃uju. Jekpot o'g̃uju. ");
INSERT INTO myu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","— Oajẽm ipot cekay ip. Ajẽmjẽm pima, o'jojojo ip. — “Ga'a,” io'e ip jewewebe. “Ayaoka. Ikat iwat ipot teku. Cebay e'ũ buje, ite ma uvadip iwan je'e. Ayaoka juy. Imẽn tip iwacayũm acesop!” io'e ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","— Ipot o'jat ip. O'tujowat ip. Ikat etako be o'yaoka ip. Pog̃. ");
INSERT INTO myu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","— Ikat iwat waram ajẽm puje, apẽn je'e jekat peayũ be? — Jesus o'e ya'ĩjojoayũ be. ");
INSERT INTO myu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","— Uvadip wiwiayũ aokam — io'e ip. — Ajẽm puje, yaoka. Ipiat supi'ajoat cebe ip, yaoka ip. Wara'acayũ jomuy tip wiwi an. G̃ebuje ixeyũ uva'a yaũm ip, yarum puje — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","— Imen e'em Deus ekawẽntup: Uk'a muymuy'ukayũ o'e, “Ite'a xipat g̃u wita'a,” i, i. Yakẽrẽ o'e cexe ip, i. O'yaxik ip, i. Warara'acat pit o'e, “Ite'a yadip ma,” i, i. Uk'a muycemucemat'am o'e, i. Iboap xipat cĩcã wuyxe, Deus imẽn o'e buye, i'e'em Deus ekawẽntup. Iboaptup epetupcoco g̃u du? — io'e Jesus cebe ip. Ig̃o'a Cristo buxim―yamuycemucemat'a. ");
INSERT INTO myu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","— Juk epetupcoco — io'e Jesus. — Imẽneju Deus soat kukan pima, ixe xe g̃u epesop. Ixe bikuyap e'e'ukayũ acã ixe xe jeedop ip — io'e Jesus paĩyũ kukukayũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. ");
INSERT INTO myu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","— Ig̃o'a jejewi je'at puje, o'jewenõmnõmnõm kuka. Ijodiat ceje ig̃o'a at puje, tõm a kuka o'e ip — io'e Jesus. Iboap ekawẽn o'g̃uwẽn Deus a'õbi õn jekukum iam ixeyũ mukũyjoap ojuy. ");
INSERT INTO myu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Paĩyũ kukukayũ Jesus ekawẽn o'ya'ĩjojo ip, Fariseuyũ dak. Ade wuymutaybitbinap ekawẽn o'ya'ĩjojo. Deus ekawẽn itaybit o'e ip ixeyũ muwẽnuwẽn o'e iam. — Jesus ijop ekawẽn o'g̃uwẽn wuymukorẽm ãm — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jesus daomũn ojuy o'e ip. Iparara bit o'e ip adeayũ buxixim. Adeayũ xe Jesus Deus ekawẽn muwẽnuwẽn'ukat o'e, ibuye iparara o'e ip Jesus daomũn ãm. ");
INSERT INTO myu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Waram Jesus o'jekawẽn jewejuayũ be. Wuymutaybitbinap ekawẽn o'g̃uwẽn―imẽnpuximap ekawẽn. Ipi kukukat muwẽnuwẽn o'e jewejuayũ mutaybit am. ");
INSERT INTO myu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","— Deus wuynomuwã jewekay iap ipi kukukat adeayũ o'tomuwã jekpot ewebumũnap epeta kay iap puxim. Ixe ipi kukukat peta o'g̃ug̃ẽ, jekpot o'jewebumũn puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","— Jebuywatwat'ukayũ o'tomuwãiayũ be o'g̃uju tomuwã ãm, jekpot epeta beam ip tomuwã ãm, puybit o am. O'ju ip. O'tomuwã. Imẽnpit o'takoyiayũ oajẽm g̃u ip, taobu'u ip puye. ");
INSERT INTO myu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","— Wara'acayũ o'g̃uju g̃uto―jebuywatwat'ukayũ. — “I juy epe'e o'tomuwãiayũ be: ‘Kuy biopak oyaoka―biopak'it'it tak. Soat ma opop, peta be i'o am. Epesot cuy,’ i. ‘Ade puybit puye,’ i,” ixe o'e―ipi kukuk'ukat o'e jebuywatwat'ukayũ be. O'ju ip. ");
INSERT INTO myu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","— O'tomuwãiayũ bit osodot g̃u. O'taobu'un ip. Jewaywayway ip o'e. Oajẽm g̃u ip peta kay. O'ju ip wara'at ka be. Pũg̃ ixeyũ'in kadaidip pe o'ju. Wara'acayũ tarekrek mũn'a be o'ju ip. O'ju g̃u peta be. Peta iwat ekawẽn kay g̃u o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","— G̃ebuje wararar'acat ixeyũ'in ibuywatwat'ukayũ o'jat ip. Xipan g̃u o'jukuk ip. O'yaoka ip. Oe'ũ. Pog̃. ");
INSERT INTO myu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ipi kukukat itakoma jĩjã o'e ibuye. Sorarayũ o'g̃uju, jemunomuwãayũ aokam, ag̃okaxirixiri kasukamuy'ũm ãm. ");
INSERT INTO myu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","— G̃ebuje jebuywatwat'ukayũ be o'jekawẽn. “Kuy peta opop, okpot jewebumũn puye. Imẽnpit wemunomuwãayũ xipat'ũmayũ. Imẽnpuye ixeyũ ajẽmap cũg̃ g̃u oxe,” io'e. ");
INSERT INTO myu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","— “Epeju juy e dag̃, uk'a ukpibubu dag̃ tak,” io'e jebuywatwat'ũkayũ be. “Wara'acayũ epetakoy―e dag̃ayũ. Soat cuy epetakoy―epetobuxikiayũ,” io'e. — “Hm hm,” io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","O'ju ip. O'takoy. E dag̃ayũ o'takoy. Soat pupum ip o'e―o'tobuxikiayũ―xipacayũ, xipat'ũmayũ dak. — O'tujowat ip jekariwa kay. Imẽnpuye yanopapũn o'e jewebumũnap'a cemudakoyũm. ");
INSERT INTO myu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","— G̃ebuje jemudakoyayũ kay oajẽm. Ipi kukukat oajẽm, ijo am. Jewebumũnap ekabek kug̃'ũmat o'tobuxik. ");
INSERT INTO myu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","— “Apẽnpuye juk eõm, obure?” io'e. “Jewebumũnap ekabek kug̃ g̃u ẽn,” io'e cebe. O'jede g̃u, yag̃uybabi'ũm o'e buye. ");
INSERT INTO myu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","— “Epesubamũnmũn cuy―ceba, sui dak epesuimũnmũn,” io'e ipi kukukat jebikuyap e'e'ukayũ be. “Epejoxik cuy kabiokbog̃ pe, wuy Deus wi,” io'e ixe ipi kukukat. “Bomaku ag̃okatkayũ tõtõn jeedop. Tũy dak ip jenũy yeiyei je'e ip ipi bun,” io'e — io'e Jesus, o'ya'ĩjojoiayũ be imutaybitbin pima. ");
INSERT INTO myu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","— Ade ma o'takoyiayũ e'em ip. Pũg̃pũg̃ pit o'taẽiayũ e'em ip―Deus o'taẽiayũ — io'e Jesus ixeyũ be. Ibũrũ ma o'e Jesus ekawẽn. Imẽn o'jekawẽn Jesus ade ma Deus kay o'takoy buye. Imẽnpit pũg̃pũg̃ acã ip Jesus eju jekukum. Pũg̃pũg̃ acã Deus xe. ");
INSERT INTO myu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseuyũ o'jeawero ip, Jesus a'õ muwarurun ojuy ip puye. — Apẽn Jesus ekawẽn ag̃ukorẽm? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jewewebe imẽn kawẽn puje, Fariseuyũ jeweju etaybitbinayũ o'g̃uju ip Jesus kay. Herodes ebekitkit tak o'g̃uju ip. Oajẽm soat ip. — Ocemutaybitbin'ukat — io'e ip Jesus pe. — Soat em ẽn icẽmãn e'em. Apẽn Deus ibikuy ocewebe jeku am iam ẽn ocemutaybitbin. “Ig̃o du xipat exe?” i'ũmg̃u ẽn e'em warara'acat pe emutaybit am. Kacũg̃ kadiat cocoap tomuju g̃u ẽn e'em “Teku xipat,” i — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","— Cedag̃ tu exe dinheiro ũmũm oceju bima Roma ka kukukat peam? ―César peam? Ixe wuyedinheiro ojuyjuy cebeam teidadam―César beam. Teida buje, wuyawẽwẽap ekawẽn tag̃ g̃u kuka ajeku? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Imẽnpit Jesus itaybit ikẽrẽm okuk pin ip iam. — Apẽnpuye eyju wa'õmuwarurun ojuy? — io'e. — Omuykukum ojuy eyju — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","— Dinheiro isurũg̃at cuy epetojot owebe―pũg̃'a'in―dinheiro'a yaũm Roma ka kukukat peat'a'in — io'e cebe ip. O'yadojot ip dinheiro isurũg̃at'a―yopĩcat'a―prata mug̃ẽg̃ẽat'a. ");
INSERT INTO myu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","— Abu-biõg̃buk ija'a be―dinheiro'a be? — io'e. — Abu-butet tak ija'a be? ");
INSERT INTO myu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","— César biõg̃buk, ibutet tak — io'e ip. — Imẽnpuye ig̃o'a César pubut'a―dinheiro'a — io'e. — Cemuojuyjuy epeg̃ũm César be wuyeipi kukat pe — io'e. — Deus pe dak cuy epeg̃ũm cemuojuyjuy — io'e. ");
INSERT INTO myu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iboap ekawẽn buye, mũg̃ ma osodop ip. O'jẽm ma ip Jesus xewi. O'yag̃uybabi'ũm ip. — Ya'õmuypit pa'ore wuywebe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ixe kabiam Saduceuyũ oajẽm Jesus kay. Judeuyũ osodop ip. Tũybe wuye'ũ buje waram g̃uto acejetait g̃u iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","— Ocemutaybitbin'ukat! — io'e ip Jesus pe. — Moisés juk kuyjeayũ mutaybitbin osunuy: Iwag̃o e'ũ buje, jekitpit jewebumũn cuy jewag̃o'ũm tayxibuk eju, itayxibuk i'it'et'ũm pima, i. I'it'et pima, iwag̃o'ũm tieg̃ ipotpot kuka o'e i'it, i. — Imẽneju ocetaybit g̃u abu-tayxim e'em ixe ayacat iam, waram ce'ũ'ũayũ etait puje — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","— 6 beayũ osodop ip iwag̃o kitpityũ. Iwag̃o jewebumũnat o'e. Oe'ũ, jekpotpet'ũm puxe ma. Imẽnpuye pũg̃ ixeyũ'in o'jewebumũn jewag̃o'ũm tayxibuk eju―jewag̃o nomujuat. ");
INSERT INTO myu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oe'ũ ixe dak. Jekpotpet'ũm puxe ma. Imẽnpuye wara'acat o'jewebumũn itayxibuk eju―pũg̃ ixeyũ'in. Oe'ũ ixe dak. Jekpotpet'ũm puxe ma. Imẽn o'jewebumũn ip―ikitpipiyũ―soat ip. Pũg̃pũg̃pũg̃ ma o'jewebumũn ip itayxibuk eju. Soat oe'ũ ip―pũg̃pũg̃pũg̃ ma. ");
INSERT INTO myu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ibocewi ixe ayacat i'it'et puxe g̃u ma ixe dak oe'ũ. ");
INSERT INTO myu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Imẽn pima, ajo cũg̃ ma exe? Abu-tayxim je'e ixe ayacat waram g̃uto wuyetait puje? Soat ip o'jewebumũn ixe eju―7 beayũ — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","— Cedãg̃ g̃u eyju jewag̃uyg̃uy — Jesus o'e. — Tũybe waram acetait g̃u iãn eyju. Eyetaybit g̃u Deus ekawẽn iam. Deus bacaam tak eyetaybit g̃u. Deus warara'acat podi ma jebacaap kug̃ iam — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","— Waram jetait puje, wuyjuyũ jewebumũnmũn g̃u ip. Kabi beat co'i ip je'e―Deus ekawẽn tojotjot'ukat co'i — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","— Imẽntak Deus oe'ũiayũ kukukat g̃u―itabẽg̃ayũ kukukat acã. Imẽnpit juk o'jekawẽn ixe: Õn Deus, i. Abraão itabut mabuk okay, Isaque dak, Jacó dak, i. Imẽn Deus cuk o'e. “Itabut ip okay,” io'e Deus, waram g̃uto ip o'jetait puye. Ce'ũ'ũayũ g̃u itabut Deus kay―itabẽg̃ayũ acã. — Imẽneju wuyetaybit ce'ũ'ũayũ waram g̃uto itabẽg̃ jeedop ip iam. Wuyetaybit tak Deus ce'ũ'ũayũ kukukat g̃u iam, Deus ekawẽntup e'em. Epetupco — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Adeayũ iboap co buje, yag̃uybabi'ũm o'e ip, imutaybitbinap puye. ");
INSERT INTO myu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseuyũ bit Saduceuyũ o'g̃uymũg̃ iap awẽg̃ co buje, o'jeawero ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pũg̃ ixeyũ'in o'jekawẽn Jesus eju. Moisés ekawẽn imutaybitbin'ukat osunuy xeku. Jesus a'õmuwarurun ojuy xeku. ");
INSERT INTO myu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— Ocemutaybitbin'ukat! — io'e Jesus pe. — Pu-g̃u Moisés ekawẽn'in yobog̃ cĩcã wuymukũyjobit am? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","— Ig̃o ekawẽn: Deus cuy ikukpin cĩcã epejukuk, i. Warara'acat kukpinap podi ma juy epejukuk. Eyxe ikukpin cĩcã buye, ibikuyap tag̃ cuy epeku soat em; xipacat kay dak cuy epesop g̃ebum, i. ");
INSERT INTO myu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","— Imẽn imubararakap opop Deus ekawẽn tup pe. Ig̃odup kay kũyjobin cĩcãn ma epesop. Ig̃odup wara'atup podi ma — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","— Wara'at tak ixe ekawẽn'in yobõg̃ cĩcã wuymukũyjobit am. Imẽn e'em: Xipan cuy warara'acat epejukuk eyewekukap puxim ma, i. ");
INSERT INTO myu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ig̃odup pewi soat tup o'jebapuk―Deus ekawẽn muwẽnuwẽn'ukayũ emumutaybitbinaptup, Moisés ekawẽntup tak, soat o'jebapuk ig̃odup pewi. ");
INSERT INTO myu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseuyũ eawero buje, Jesus o'jekawẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— Abu ipot ixe Cristo? Abu Deus emunaẽ? — Jesus o'e cebe ip. — Davi naxeg̃ebit xeku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","— Apẽnpuye ixe Davi kuyje o'jekawẽn Deus biõg̃buk a'õbi: “Cristo okukukat,” i? Imẽn o'tupmubararak kuyje: Cristo okukat―Deus emunaẽ, i. Deus o'jekawẽn Cristo be, i. “Xik'i. “Ekay itakomaayũ a'õbacaap cuy og̃uy'ũm,” io'e, i. “A'õ kay kũyjobin jeedop ip,” io'e, i. “Ẽn ixeyũ kukan'ũm pima, oxe ma juy eg̃uy,” io'e, i. ");
INSERT INTO myu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davi juk o'e Cristo be―Deus emunaẽ be: “Ẽn ma okukukat,” io'e. Imẽnpuye ibapuk ma wuyxe Davi naxeg̃ebit acã g̃u Cristo osunuy―Davi kukukat tak osunuy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ibocewi ka'ũmg̃uat o'jede Jesus pe. Cede ba'ore osodop ip Jesus pe. Ya'õbabi'ũm ip o'e Jesus a'õbu am. ");
INSERT INTO myu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","G̃ebuje Jesus o'jekawẽn adeayũ be, jeweju etaybitbinayũ be dak. ");
INSERT INTO myu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— Fariseuyũ itaybit cĩcã ip Moisés ekawẽn imutaybit am, Moisés ekawẽn itaybitbin'ukayũ dak itaybit. Imutaybitbin cuy ip ja'õbi, itaybit puye Moisés ekawẽn muwẽn ãm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","— Imẽnpuye soat cuy epe'e ya'õ dag̃ kũyjobin cuy epeku soat i'e'e iap tag̃. Imẽnpit cekukuap tag̃ g̃u juy epeku, Deus kay kũyjobit'ũm ip puye. Deus ekawẽn imutaybitbin ip. Deus a'õ kay bit kũyjobit'ũm — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","— Ixeyũ e'em warara'acayũ be: “Moisés ekawẽn tag̃ cuy epeku―soat tag̃,” i. Imẽnpit soat tag̃ g̃u ixeyũ dak jekukum Moisés ekawẽn tag̃ — io'e. — Eybuywatwan g̃u ip Moisés ekawẽn tag̃ eyeku am. Pũg̃ em tak ka'ũma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","— Soan ma e'em ip warara'acat pe jejojoan. Deus ekawẽntupat ekawẽn mubarararag̃ ip wara'atup pe. Ibo dup mõg̃mõg̃ ip tupmũn pe―tuperenaptup. Ig̃o mũn pe mõg̃mõg̃ ip jedopa'a dag̃, jeba dag̃ tak warara'acat pe tup mũn jojoan. Imẽn ojuy ip ixeyũ kay warara'acat ag̃uy dag̃, “Deus kay cĩcãat teku,” i warara'acat pe i'e am. — Jesay iwaruat kug̃ ip jekukum warara'acat muak am jekay. Jesay ukpi mubõg̃ubõg̃ ip warara'acat pe jejojo an. ");
INSERT INTO myu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","— Petatam pima kariwawayũ nuyap pe abik ojuy ip. Ya'õbuyxiat tũyap pe abik ojuy ip Deus eju kawẽnwẽnap'a be, jebureyũ be jejojo am. ");
INSERT INTO myu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Icokcok cĩcã ip warara'acat “Eya'õbuyxi jĩjã” i'e buje cebe ip, adeayũ etabixe tarekrek pupuap pe. Icokcok warara'acat “Omutaybitbin'ukat” i'e buje cebe ip. Imẽn icokcok cĩcã ip warara'acat pe ibuyxim ikuk am soat etabut pe. ");
INSERT INTO myu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","— Ikitpitpiyũ buximayũ eyju bit―soat — io'e Jesus jewejuayũ be. — Õn ma eykukukat. Wara'acat pit ka'ũma. Imẽnpuye i'ũmg̃u juy warara'cayũ eywebe, “Ocemutaybitbin'ukat,” i, eyju ikitpitpiyũ buxim puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","— Ipi ju bima, “Warara'acat podi ma ya'õbuyxiat ẽn,” i'ũmg̃u juy epe'e. Pũg̃ ma soat podi ma ya'õbuyxiat―kabi beat acã―wuyebay acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","— Warara'acayũ “Okukukayũ eyju,” i'ũmg̃u juy ip eywebe. Imẽn cuy g̃u ip, õn acã eykukukat puye. Õn Deus emunaẽ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","— Ya'õbuyxiat podi ma eyeweweju, eybuywatwat'ukat ma e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","— Ya'õbuyxi pin'ũmat yobog̃ e'em Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","O'jekawẽn Jesus Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. — Karem ma ipiat epesupi'ajo! Ipi juacat mug̃uykuku'ukayũ eyju! Iba'ore warara'acat pe itaybit am ajo xipat Deus xe iam. Xipat Deus xeap ekawẽn itaybit g̃u ip. Deus kay kũyjobit g̃u ip, iboap ekawẽn epeg̃uwẽn g̃u buye. Deus kay eyju kũyjobit g̃u. Warara'acat mubu'u'un tak eyju Deus xe wuynũyap puxixim―Deus kay wuyjuap puxixim. ( ");
INSERT INTO myu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","— Karem ma ipiat epesupi'ajo! Ipi juacat mug̃uykuku'ukayũ eyju — io'e Jesus Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. — Itayxibuk mug̃uykukukum eyju, ibubut pu am — io'e. — Ibun ma eyju jewexe kawẽnwẽn Deus eju, “Teku ya'õbuyxiat,” i'e ojuy eyju warara'acat pe. Deus pit ipiat supi'ajoat eywebe warara'acat pe ipiat supi'ajoat podi ma — io'e Jesus.) ");
INSERT INTO myu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","— Karem ma ipiat epesupi'ajo, Fariseuyũ, Moisés ekawẽn imutaybitbin'ukayũ dak — io'e Jesus. — Soat tag̃ jekukum eyju wara'acat kudadam. Ikudadam cĩcã eyju, imutabun am―Deus kay imutabun am―eyetabucap puxim imutabun am. — Imutabun puje, imuwexaxan eyju ikẽrẽat mujurũg̃rũg̃'ukayũm. Ipiat'ajojoap kay cumayũm ip imuwexaxan eyju. Eybodi ma xipat g̃u ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","— Karem ma ipiat epesupi'ajo. Ya'õpi'ũmat puximayũ eyju. Imẽn ma warẽmtag̃ ma warara'acat mutaybitbin eyju — Jesus o'e cebe ip. — Warara'acat mutaybitbin eyju: “ ‘Etaybit icẽmãn De us eju kawẽnwẽnap'a omuy iam. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe iam tak,’ i epe'e bima, cedag̃ ma epesop Deus xe eya'õ dag̃ g̃u ma'g̃u epekuku,” i'e'em eyju warara'acat pe — io'e Jesus. — Wara'at imutaybitbin eyju dak. “ ‘Etaybit icẽmãn Deus eju kawẽnwẽnap'a be ouro opop iam. Imẽnpuxim cuy etaybit icẽmãn õn e'em ewebe iam tak,’ i epe'e bima, cedag̃ g̃u kuka epe'e Deus xe, eya'õ dag̃ g̃u epekuku,” i'e'em eyju warara'acat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","— Eyetaybit g̃u! Ajom xe'e eyetaybit? Ka'ũma ma! Ya'õpi'ũmat puximayũ eyju. Ajo yobo'g̃ Deus xe―ceweju kawẽnwẽnap'a du? Yabeat ouro g̃u xe'e? Deus eju kawẽnwẽnap'a yabog̃ ma. Ouro xipat Deus eju kawẽnwẽnap'a be buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","— Warẽmtag̃ ma eyju warara'acat mutaybitbin. Warara'acat pe e'em eyju, “Wara'at pe epe'e bima, ‘Etaybit icẽmãn wũnca mupikpikap'a caixa'a opop Deus eju kawẽnwẽnap'a be iam. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe iam tak,’ i. Imẽn e'em pima, cedag̃ ma epesop Deus xe eya'õ dag̃ g̃u ma'g̃u epekuku,” i'e'em eyju warara'acat pe — io'e Jesus. — Warara'acat pe e'em eyju dak: “Wara'at pe epe'e bima, ‘Etaybit icẽmãn wuyju wũnca ũmũm paĩ be imupik am ig̃o'a be iam. Imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe iam tak,’ i. Imẽn e'em pima, cũg̃ ma kuka epesop Deus xe, eya'õ dag̃ g̃u ma'g̃u epekuku,” i'e'em eyju warara'acat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","— Ya'õpi'ũmat puximayũ eyju! Abuat g̃asũ ma ibaca eyxe? Wũnca mupikpikap'a ma du? Ya'a jeje imõg̃ap g̃u xe'e? Wũnca mupikpikap'a ma yabaca — io'e. — Ajo-mõg̃'i buje iat Deus pubut ma e'em. Imẽnpuye imõg̃ap bacaap podi ma wũnca mupikupikap'a ma ibaca — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","— Imẽneju wuyekawẽn tag̃ cuy ace'e, “Oce'e xe'e Deus eju kawẽnwẽnap'a be, wũnca mupikpikap'a be,” i bima. Imẽn ma kawẽnwẽn pima, wũnca mupikpikap'a muwẽnwẽn tak wuyju―soat imõg̃ap tak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","— Imẽneju warara'acat pe e'em pima: “Apẽn etaybit icẽmãn Deus eju kawẽnwẽnap'a oyamuy iam; imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe iam,” i bima, eya'õ dag̃ cuy epeku. Imẽn Deus eju kawẽnwẽnap'a muwẽnuwẽn pima, Deus muwẽnuwẽn tak, Deus omuy buye ibo'a be. ");
INSERT INTO myu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","— Imẽneju warara'acat pe e'em pima: “Apẽn etaybit icẽmãn kabi kake iam; imẽnpuxim cuy etaybit icẽmãn e'em õn ewebe iam,” i bima, eya'õ dag̃ cuy epeku. Imẽn kabi muwẽnuwẽn pima, Deus abikbikap muwẽnuwẽn tak, Deus muwẽnuwẽn tak, Deus omuy jabikbikap ceje xik'i buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","— Karem ma ipiat epesupi'ajojo! Ipi juacat mug̃uykuku'ukayũ eyju! — i dak o'e cebe ip. — Soat em eybubut mu'awerorom 10 be, pũg̃at ũm ãm eyju Deus pe. Wara'at pit eyju imuxipanpan eybubun. Eyju puybit mukunukunaptup ũmũm Deus pe, erva-doce dak ũmũm, puybit mude'o'onaptup tak ũmũm. Xipat eywebe iboap ũmũm Deus pe. Imẽnpit soat Moisés ekawẽn kay kũyjobit g̃u eyju, soat Deus a'õ kay'ũm puye. Soat g̃u cũg̃ ma epeg̃ug̃ẽ Deus etabun. Deus a'õ kay juy epe'e. Warara'acayũ xipan cuy epejukuk. Warara'acayũ kay eyetabotaidabotbon cuy. Soan cuy epe'e cũg̃ ma Deus etabun. Cũg̃ ma jĩjã epeg̃ũm puybit mukunukunaptup pewi―yopĩcat pewi. Imẽnpit soat em epekuku Deus kay kũyjobitsũ ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","— Warara'acayũ kukuk'ukayũ eyju! — io'e Jesus. — Imẽnpit ya'ĩopi'ũmat co'iayũ eyju. Tikõnkõnat puxim eyju. Tikõnkõnapti mukapkam teku pag̃o dag̃, ikoẽro uk am tikõnkõnapti bewi. Imẽnpit camelo uk pin g̃u tikõnkõnapti bewi — Jesus o'e. Imẽn o'jekawẽn Jesus itaybit am ip. Ikoẽro yopĩcat ũmũmap puxim. Deus xe yobog̃ pit warara'acayũ xipan ajukuk iap. Imẽnpuye camelo Deus xe yobog̃at puxim. ");
INSERT INTO myu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","— Karem ma ipiat epesupi'ajojo! — Jesus o'e Fariseuyũ be, Moisés ekawẽn imutaybitbinayũ be dak. Ipi juacat mug̃uykuku'ukayũ eyju. Kopo iokokat puxim eyju. Kacũg̃ kadi acã eyju kopo wuywuy, prato wuywuy dak. Yabi bit ka'ũma. Yabi okok cĩcã. Prato buxim eyju dak. Eyokok. Ade bubut epejat. Iparag̃ epejat warara'acat pubut, ibui bewi ip. Ade eybubut imẽn ibu ibit. Eydacup puye, epejat. Imẽnpuye prato iokokat puxim eyju. ");
INSERT INTO myu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","— Ya'ĩopi'ũmat puximayũ eyju! Ikẽrẽãn g̃u juy epesop. Epejat g̃u juy wara'acayũ bubut. Eydacum g̃u juy epesop. Xipan ma epeku — io'e Jesus fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","— Karem ma epesupi'ajojo! — io'e Jesus Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. — Ce'ũat topap puxim eyju, ce'ũ'ũayũ dao kug̃ ibima. Yarucat'a ika beat'a―wita'a. Yadip'a o'yajojoiayũ xe. Ikũydip g̃u ig̃o'a'a binũn pe, witabikũy be. Ikũykẽrẽ jĩjã badi, ce'ũat tao opop puye. Ig̃ẽmat tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","— Imẽnpuxim badi ma eyju ikẽrẽat kug̃ cĩcã, dapxi jĩjãayũ dak eyju. Kacũg̃ kadi bit eyju xipacayũ jo'i — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","— Karem ma ipiat epesupi'ajojo! — io'e Jesus Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. — Eyju Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm etaypi mubapukap'a epeyamuy wita'a. Ixeyũ'ũm'ũm kay g̃ebum am epeyamuy―Deus xe xipan e'e'ukayũ'ũm'ũm kay. Idip cĩcãat epeg̃ug̃ẽ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","— Epekawẽn: “Kuyje ocetait pima, kajuk Deus ekawẽn muwẽnuwẽn'ukat oceyaoka g̃u,” i'e'em eyju te'e ma. “Ocedobuyũ'ũm'ũm ekukuap tag̃ g̃u kuka ocejeku,” i dak e'em eyju te'e ma. ");
INSERT INTO myu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te'e ma imẽn e'em eyju. Ibapuk e'em soat xe eyju eydobuyũ'ũm'ũm naxeg̃ebitbit―o'yaokaiayũ naxeg̃ebitbit, cekukuap co'i eyju dak jekukum puye. ");
INSERT INTO myu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","— Karem ma ipiat epesupi'ajojo! — io'e cebe ip. — Ikẽrẽat cuy epeg̃ug̃ẽ eydobuyũ'ũm'ũm co'i ixeyũ ekapikap. Ikẽrẽat co'i juy epeg̃ug̃ẽ. Eydobuyũ'ũm'ũm ekapikap mug̃ẽg̃ẽ juy epe'e. Deus ekawẽn muwẽnuwẽn'ukayũ aokaap mug̃ẽg̃ẽ juy epe'e — io'e. — Imẽn cuy epeg̃ẽg̃ẽ kuyjeayũ'ũm'ũm ekapikap epere am — io'e. ");
INSERT INTO myu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","— Puybu buxim eyju―wuye'ũap puybu tũypiat puxim, ikẽrẽ jĩjãat kug̃ayũ eyju buye. Puybu'it'it puxim tak. Iba'ore eywebe ipiat'ajojoap ka bewi eyenapõn ãm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","— Õn e'em eywebe: Deus ekawẽn muwẽnuwẽn'ukayũ og̃uju eykay, itaybit cĩcãayũ dak, wekawẽn imutaybitbin'ukayũ dak, i. Pũg̃pũg̃ epeyaoka―ixeyũ'in. Wara'acayũ epesubamupaya korosa be, ce'ũ ãm. Wara'acayũ epeg̃upokupok Deus eju kawẽnwẽnap'a be. Ixeyũ epeg̃ujẽm soat ka bewi. Wara'at ka kay, wara'at ka kay epeg̃uju ip — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","— Imẽneju soat ibapuk je'e eywebe. Ipiat'ajojoap pe ibapuk je'e. Eydobuyũ'ũm'ũm ikẽrẽat kug̃'ũmayũ o'yaoka ip. Koap Abel'ũm o'yaoka ip. Ikẽrẽat o'g̃ug̃ẽ g̃u Abel'ũm. Kanomũm Zacarias'ũm o'yaoka ip―Baraquias ipot. Deus eju kawẽnwẽnap'a be bima, o'yaoka ip, wũnca mupikapupikap'a xe bima. Eyju eyukpiwat ma soat ixeyũ'ũm'ũm aoka am. Soat ibapuk je'e eywebe ipiat'ajojoap pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","— “Eyju ma karem ma ipiat epesupi'ajojo,” i õn e'em. G̃asũayũ be ipiat supi'ajojoat Deus―soat supi'ajojoat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","— Jerusalém ka watwat! — io'e cebe ip. — Deus ekawẽn muwẽnuwẽn'ukayũ aokakam eyju―Deus emumujuyũ. Yabug̃bug̃ tak eyju ip wita'am. Sapokay'it'it jexi kay. Jedaudaum jexi eg̃ebadap tiotpe kajuk pibun. Eyju bit okay g̃u. Eybu'u jĩjã eyetabut am okay, eykukpin cĩcã a'g̃u oxe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","— Jeywat õn ag̃okatkat jeduk'a iwacap puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","— Imẽnpuye icẽmãn õn e'em eywebe. Waram ojo g̃u eyju waram wajẽm'ũm pima. Wajẽm puje: “Deus xipan wuykukukat a'õbi yajẽm'ibit jukuk,” i epe'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","G̃ebuje o'jẽm Jesus. Deus eju kawẽnwẽnap'a bewi o'jẽm―yabogat'a bewi. Ijẽm puje, imutaybitbin'ukayũ oajẽm Jesus kay. — Ak'i — io'e ip Jesus pe. — Uk'a yadipat'a ijoceat'a. Eyajo juy — io'e ip. Imẽn ip kawẽnwẽn o'e ade o'yadop ibo ka be buye―Deus tuk'a'ayũ. ");
INSERT INTO myu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","— Soat ma epejojojo g̃u du? — io'e Jesus. — Ya'ade opop ijoce. Imẽnpit ya'dop g̃u g̃uyjom pit — io'e. — Soat' je'aedu. Xepxep'a jewa'atẽg̃tẽg̃ g̃u je'e―wita'a — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","O'ju Oliveira'a be―co'a be. Xik'i osunuy iboma. Oajẽm ip cekay―Jesus kay. Ceweju etaybitbinayũ oajẽm. Jag̃epũg̃ pima, oajẽm ip cekay. — Pug̃ũn soat'a je'aedu? — io'e ip Jesus pe. — Pug̃ũn je'bapuk? Pãm ẽn? Pug̃ũn ajẽm waram? Pug̃ũn Deus ipi g̃u'ũm? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","— G̃uyjomsũm — io'e Jesus. — Koap ma eymug̃uykuku pinayũ jajẽm ip eykay. Kawẽnwẽn jajẽm ip. Epeya'ĩjojo g̃u juy iboap ekawẽn. Eyday'em'um epesop ixeyũ be eymug̃uykukuap puxixim — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","— Adeayũ omuyku. “Cristo õn ma―Deus emunaẽ,” i napa ma je'e ip. Warara'acayũ itabun je'e ip. Ixeyũ ade g̃ug̃uykuku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","— Jenopag̃og̃õmap muwẽnuwẽn e'em ip. Yaokakaap epeya'ĩjojo. Eypararam g̃u juy epesop. Imẽn cuy je'bapuk. Imẽnpit soat puk oi'ũm g̃u. ");
INSERT INTO myu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pũg̃ eipi watwat nopag̃og̃õm je'e wara'at eipi watwat eju. Pũg̃ ka watwat nopag̃og̃õm je'e wara'at ka watwat eju. Pũg̃ ka dag̃ ipi jexixim. Wara'at ka beayũ iren je'ku ip — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","— Yopĩt ma ipiat supi'ajojo ip koam―ipi juayũ. I'itpin'isumapi jo'i ma je'e koam. G̃uyjom pit ipiat supi'ajo jĩjã ma ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","— G̃ebuje ipiatpi'ajojoap kay jeydujowat ip. Jeydujowat ip eyaokam. Kawẽnwẽn je'e ip eymuwẽnuwẽn: “Ocexe yukpiwan teku. Oe'ũ juy ocexe,” i. Soat itakoma je'e eykay―wuyjuyũ, pariwayũ, warara'acayũ. Soat ma ipi juacayũ. Soat eykay g̃u jĩjã je'e okay eyetabut puye — io'e Jesus cebe ip―jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","— Ixe kabia ade ip wuywat. Itabut okayayũ oibu'un okay. Eymuwẽnuwẽn je'e ip eykay itakomayũ be, ipiat'ajoan eywebe. Eykay'ũm cĩcã je'e ip. ");
INSERT INTO myu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jewexe Deus ekawẽn muwẽnuwẽn'ukayũ jajẽm ip―ade. Imẽnpuye ade g̃ug̃uykuku ip. Imug̃uykuku'ukayũ e'em ip. ");
INSERT INTO myu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Imẽn ikẽrẽat ade e'em iboce. — Imẽneju xipan g̃u ip jewekuk. Xipan warara'acat kukap suiwat ip. ");
INSERT INTO myu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pũg̃pũg̃ okay itabucayũ jeedop ip, wajẽm puje. Ipiatpi'ajojom ma'g̃u ip okay ibu'u'ũm pima, ixeyũ idaxijo Deus itakomaayũ xewi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","— Wawẽg̃ muwẽnuwẽn je'e ip―Jesus soat kukukat awẽg̃. Kawẽn idipat muwẽnuwẽn je'e ip. Soat eipi dag̃ ijop awẽg̃ muwẽnuwẽn je'e ip―soat eipi watwat itaybit am. Icẽmãn itaybit ip — io'e Jesus cebe ip. — Imẽn soat mu'ũmap kabia jajẽm — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","— Imẽneju ipararu jĩjãat epejojo Deus eju kawẽnwẽnap'a be―yabog̃at'a be―bodiat'a be―Deus nuynuyap'a be. Daniel'ũm ekawẽn tag̃ epejojojo―Deus ekawẽn muwẽnuwẽn'ukat ekawẽn tag̃. (Eyetaybin cuy epesop ijoptup coco'ukayũ!). ");
INSERT INTO myu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","— Ipararu jĩjãat ig̃o'a be bima, jenapõn cuy ip co'a bicũg̃ kay―Judéia eipi watwat — io'e. Imẽn kawẽnwẽn o'e Jesus. Apẽn je'bapuk g̃uyjom iap muwẽnuwẽn o'e Jesus, itaybit puye. ");
INSERT INTO myu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","— Eyduk'a eakiju bima, epeõm g̃u juy eyduk'a be eybubut pum―yabeat pum — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","— Eykat pe bima, epeyepit g̃u juy eyduk'a kay eyeekabek pum — io'e. — Epejat g̃u juy. Dao ma epeyenapõn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","— Ixeyũ kabia dag̃ iba'ore jĩjã je'e yukreg̃ayũ enapõn ãm, je'it mutitinayũ enapõn ãm tak. ");
INSERT INTO myu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Ihi bima g̃u juy ocenapõnap, tirem puye, kajuk puye dak,” i juy epe'e Deus pe. “Sábado bima g̃u dak cuy, jebodoydoyap kabia buye,” i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","— Ixeyũ kabia dag̃ soat ipi juayũ ipiat supi'ajojo jĩjã. Ibiatpi bit ipiat asupi'ajo g̃u, Deus pe ipiat mubapuk'isum — io'e. — Waram pit ibiatpi g̃u acesupi'ajo―ixeyũ kabia dag̃ acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","— Deus pe ipiatpi'ajojoap kabia mu'ũm'ũm pima, ka'ũma ma kuka o'jewedaxijo. Imẽnpit: “Pũg̃pũg̃ kabia ipi watwat supi'ajojo,” i'e'em Deus. “Pũg̃pũg̃ kabia acã,” i'e'em Deus, jemunaẽyũ daxijo am, ikukpin cĩcã cexe buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","— Wara'acat je'e eywebe napa ma: “Ak'i! G̃oku Cristo―wuydaxijojo'ukan―Deus emunaẽ,” i. “Ak'i! G̃oku ixe,” i dak. Imẽn i'e buje, eyetabun g̃u juy epesop ixeyũ ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","— Jewexe Deus emunaẽhẽyũ je'bapuk, jewexe Deus ekawẽn muwẽnuwẽn'ukayũ dak. Wuymucoatcoanap g̃u'bapuk ip Deus ebekitkiyũ mug̃uykuku ojuy. Eywebe i'e ba'oreat g̃u'bapuk ip imug̃uykuku ojuy. ");
INSERT INTO myu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Apẽn g̃uyjom jajẽm ip adeayũ mug̃uykuku ojuy iap kuy og̃uwẽn eywebe. G̃ebu'i epe'e wekawẽn kay, ixeyũ be eymug̃uykukuap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","— Ixeyũ je'e napa ma: “Ak'i! Teku uk'a'ũmat pe,” i. Imẽn i'e buje, epeju g̃u juy uk'a'ũmat pe. Ixeyũ je'e dak napa ma: “Ak'i! Teku ikaba'arẽmatka be,” i. Imẽn i'e buje, eyetabun g̃u juy iboap kay — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","— Soat wag̃o õn. Xiririkxiririkiat jesopsom kaxijẽmap kadiwi i'acap kadibe. Iboap co'i õn oajẽm. Imẽn wajẽm puje, soat itaybit je'e ip. Iba'arẽm g̃u wajẽmap je'e. ");
INSERT INTO myu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Urupuyũ je'awerorom ig̃ẽmat kay i'o am. Imẽnpuxim Deus jajẽm ipiatpi'ajoan ikẽrẽat mujurũg̃rũg̃'ukayũ be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","— Ipiatpi'ajojoap kabia kap puje, kabi beacat muycẽmcẽmap iaruaru je'e — io'e. — Kaxiepiat kaxiepi g̃u je'e. Kabiok je'e. Kaxiamat tak kaxiam g̃u je'e. Kabiok je'e. Kasoptayũ dak ida'at kabi kadiwi — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","— G̃ebuje okop ipi kay. Soat tõtõn je'e ip―ipi juacayũ―soat ip. Soat wag̃o õn. Ojojo ip kabikerereat tag̃wi kopkom. Wa'õbacaap kug̃ okop, odipap kug̃ tak. ");
INSERT INTO myu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Parasuy jo'iat Deus g̃uyde―yobog̃at. Jekawẽn tojotjot'ukayũ g̃uju soat tag̃wi. Cemunaẽhẽyũ g̃u'awero ip. Soat tag̃wi g̃u'awero ip―ipi dag̃wi — io'e Jesus. Imẽn Jesus waram jeedocap o'g̃uwẽn jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","— G̃ebum cuy epesop wajẽmap kay, figueira'ip kay g̃ebum pima. Figueira'a bikit cẽm puje, “Koato ijasun ma,” i'e'em eyju, dup cẽm pima — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","— Imẽnpuxim ipiat'ajoap kabia ajẽm pima, “G̃axĩn ma Deus emunaẽ jajẽm,” i juy epe'e. Wekawẽn puye, eyetaybit epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","— G̃asũayũ'in iboap coco je'ũ awap, soat pe wekawẽn jebapug̃―soat ma. G̃ebum cuy epesop iboap kay — io'e Jesus jewejuacat pe. ");
INSERT INTO myu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","— Kabi i'ũm, ipi dak; wekawẽn pit i'ũm g̃u. Wekawẽn kayayũ bit soat em jeedop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","37","— Soat wag̃o õn. Waram oajẽm õn. Abu itaybit wajẽm ãm? Ka'ũma ma itaybit ip wajẽm ãm. Deus ekawẽn tojotjot'ukayũ itaybit g̃u―kabi beayũ. Õn tak wetaybit g̃u. Webay acã itaybit. Ka'ũma ma owiwim pima, oajẽm. Imẽnpuxim tak Noé kabia be ka'ũma ma iwiwim pima muba'atxiri oajẽm kuyje — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","— Muba'atxiri ajẽm awap, soat ip tikõnkõn'uk osodop. Jekõnkõn'uk ip osodop. Jewebumũnmũn'uk ip osodop. Imẽn ma osodop, kobexixi be Noé õm awap. ");
INSERT INTO myu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Itaybit g̃u osodop ip ajo je'bapug̃ iam. Kobexixi be Noé õm puje acã, muba'atxiri ajẽm puje acã itaybit o'e ip. Itabut g̃u ip Noé kay osodop. Imẽnpuye muba'atxiri wiwim g̃u ip. Imẽnpuye dak soat ip oakõm. Wajẽm puk pima, imẽn ma dak. Ka'ũma ma wajẽmap wiwim je'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","— Wajẽmap kabia be xepxep kapikpig̃ e'em jekat pe―ag̃okatkayũ. Pũg̃ ixeyũ'in tujowat jeweju―Deus emunaẽ eju. Wara'acat tujowat g̃u. ");
INSERT INTO myu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Trigo mug̃ẽg̃ẽap ka be xepxep trigo mug̃eg̃ẽm e'em―aoyũ. Imug̃ẽg̃ẽm pima, pũg̃ ixeyũ'in tujowat jeweju―Deus emunaẽ eju. Warara'acat tujowat g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","— Ag̃ cuy epesop — io'e cebe ip. — Eyetaybit g̃u buye pujuat kabia eykukukat jajẽm iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","44","— Ixima dag̃ uk'a beat iwiwim pima, ibukurukat ajẽmap puxim, iõmap puxim; ixet g̃u kajuk ixe uk'a beat — io'e Jesus cebe ip. — Imẽnpuxim wuyju wuykukukat wiwim'ũm pima, ixe dak imẽnpuxim jajẽm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","— Kariwa jekapikpik'ukat kay pimaap, itaybit cĩcãat kudadam je'e. Xipacat mug̃ẽg̃ẽ'ukat kudadam je'e. Ig̃o kapikpik'ukat warara'acayũ kukuk'ukat kariwa a'õbiat. Irere bima ip, soat em ixat je'g̃ũm ip cebe―warara'acayũ be―kapikpik'ukayũ be. Jexat o am awero am ip cebe, icũg̃ ãm je'g̃ũm. ");
INSERT INTO myu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jekariwa a'õ kay kũyjobin pima, ig̃o kapikpik'ukat icokcok je'e jekariwa ajẽm puje. ");
INSERT INTO myu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Icẽmãn õn e'em eywebe — io'e. — “Obubut kukukan cuy ece―soat ma,” i je'e cekariwa ig̃o kapikpik'ukat pe. ");
INSERT INTO myu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Imẽnpit je'g̃ũm g̃u wara'at pe―kapikpik'ukat pe, “O'jekuyan ma wekariwa,” i'e'em puye. Ikẽrẽat kug̃ xeku. ");
INSERT INTO myu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ibureyũ mupokupog̃ je'e. Tikõnkõn je'e ika'oayũ eju. Jekõnkõn tak je'e ceweju ip. ");
INSERT INTO myu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jekariwa wiwim g̃u xeku. Itaybit g̃u je'e pu kabia wekariwa jajẽm iam, pu ehora iam tak. ");
INSERT INTO myu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","— Iwiwim'ũm pima, je'pit cekariwa. Ipiat supi'ajoat jekapikpik'ukat pe. Jekapikpik'ukat ipiat supi'ajo wuyjuyũ mug̃uykuku'ukayũ ipiat supi'ajojoap co'i. Ixeyũ tõtõn cĩcã ip je'e ipiat'ajojoap ka be. Ipi kug̃ puye, tũy yeiyei ip je'e dak — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Deus soat kukuanap kabia muwẽnuwẽn o'e Jesus o'ya'ĩjojoiayũ mutaybitbin pima. Imẽnpuye wuymutaybitbinap muwẽnuwẽn o'e itaybit am ip. Imẽnpuximap ekawẽn muwẽnuwẽn o'e. — Deus soat kukanap kabia ayacayũ cucumap kabia buxim — io'e Jesus. — Ixe ayacayũ yaypan'isuayũ osodop ip―10 beayũ. Jewebumũnat kay o'ju ip lamparina kug̃. Jewebumũnat dopabijuk am o'ju ip. ");
INSERT INTO myu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","5 beayũ ixeyũ'in yag̃uysacayũ osodop ip. Warara'acayũ 5 beayũ yag̃uyba'arẽmayũ osodop — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","— Yag̃uyba'arẽmayũ o'tidujowat g̃u ip daxadi―lamparina beapti. O'tidujowat g̃u ip timũn'a be. ");
INSERT INTO myu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yag̃uysacayũ acã o'tidujowat daxadi timũn'a be. ");
INSERT INTO myu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","— Ixet pin ip. Etapok'i e'em. Ixet osodop ip―10 beayũ. Ixet, ibun jewebumũnat puye. Xet. ");
INSERT INTO myu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","— Iximadakpe iboceayũ o'tomuwã 10 beayũ be. — “Ak'i!” io'e ip. “Jewebumũnat oajẽm,” io'e ip. “Epeju cekay, topabijuk am,” io'e ip 10 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","— O'g̃uwurũg̃ ip. O'kop ip―10 beayũ. Lamparina mudipudim osodop ip, imusopusop am. ");
INSERT INTO myu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","— G̃ebuje yag̃uyba'arẽmayũ o'jekawẽn yag̃uysacayũ be. — “O'ti'ũm. Imẽnpuye iba'ore ocewebe lamparina musop am. Daxadi epetiũm cuy ocewebe,” i ip o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","— “Ap!” yag̃uysacayũ o'e. “Iba'ore ocewebe tiũm am eywebe. Pũg̃ti ma ocedaxadi. Epeju, ti buam. Dinheiro juy epeg̃ũm warara'acayũ be―tideim,” io'e ip. O'ju ip, tibu am. ");
INSERT INTO myu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","— Jewebumũnat oajẽm peta mug̃ẽg̃ẽat tuk'a kay. Cucum pima ip daxadi bum, oajẽm. O'ju jewebumũnat eju yag̃uysacayũ. O'ju ceweju, kuy buye ip. Oõm ip ceweju. — Bik. O'tomudip ip xĩntabi. ");
INSERT INTO myu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","— Oajẽm g̃uyjom. Yag̃uyba'arẽmayũ oajẽm. O'tomuwã. — “Kariwa!” io'e ip. “Xĩntabi etomudip'uk ocewebeam,” io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","— “Wetaybit g̃u ma eyjum,” io'e cebe ip — io'e―Jesus o'e. Pere. Imẽn 10 beayũ be kawẽnwẽnap pi o'jepere Jesus. Apẽn ixe jewebumũnat kay 10 beayũ oekuku, imẽnpuxim wuyju be jekukum, Deus soat kukan pima. Pũg̃ wuy'in iwiwim je'e Deus soat kukanap kabia bima. Warara'acayũ wuy'in iwiwim g̃u je'e. ");
INSERT INTO myu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","— Ag̃ cuy epesop ekariwa jajẽmap kay — io'e Jesus iboceayũ be. — Eyetaybit g̃u buye puju eyekariwa jajẽm iam. Ajo hora iam eyetaybit g̃u. Ajo kabia iam eyetaybit g̃u. Ag̃ cuy! — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Waram Jesus o'jekawẽn iboceayũ be. Deus soat kukanap kabia muwẽnuwẽn o'e. — Deus soat kukanap kabia ag̃okatkat cuap kabia buxim — io'e Jesus. — Ixe cucum o'e wũy ma. Wara'at eipi be cucum o'e. Cucum awap, kapikpik'ukayũ o'tomuwã―jebuywatwat'ukayũ. Jebubut o'g̃ũm cebe ip. O'g̃ũm imuxipanpan am. ");
INSERT INTO myu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dinheiro'a o'yaũm cebe ip. Ajo-xe imuxipanpan pucat o'yaũm cebe ip. Pũg̃ ixeyũ be 5 mil iat'a o'yaũm. Wara'acat pe 2 mil iat'a o'yaũm. Warara'at pe pũg̃ mil iat'a o'yaũm―dinheiro'a. — Ibocewi o'ju wara'at eipi be. ");
INSERT INTO myu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","— G̃ebuje 5 mil iat'a juk o'yabuiat wara'at dinheiro'a o'yabu―wara'at 5 mil iat'a. Imẽnpuye 10 mil iat'a kug̃ o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wara'at ibuywatwat'ukat ijo'i ma o'g̃ug̃ẽ dinheiro'am―ibo 2 mil iat'am. Imẽnpuye 4 mil iat'a kug̃ o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yabi beat pit ibo pũg̃ mil iat'a o'yamõg̃ ipikũykũy be. O'jokot. Batku. O'yamõg̃. Pere. ");
INSERT INTO myu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","— Ade xet kap puje, oexe. Cekariwa oexe. O'jekawẽn jekapikpik'ukayũ be. Jedinheiro'a muwẽnuwẽn o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Imẽnpuye 5 mil iat'a juk o'jat iat dinheiro'a o'yadojot jekariwa be―10 mil iat'a o'yadojot. — “Juku, Kariwa,” io'e. “Ijoce edinheiro'a―5 mil iat'a. Wara'at oyabu―wara'at 5 mil iat'a. Soat ebubut'a. Edinheiro'am g̃asũ―10 mil iat'a. Wara'at 5 mil oyabu ibo 5 mil iap,” io'e jekariwa be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","— “Xipat,” cekariwa o'e cebe. “Xipacat ẽn. Wedinheiro'a muxipan cĩcã ẽn. Yopĩt ma o'e. Ẽn pit wa'õ dag̃ imuxipanpan cĩcã owebeam. — “Imẽneju ade obubut muxipan ece owebeam,” io'e — io'e Jesus. — “G̃a'a! Peta og̃ug̃ẽ g̃asũ. Acekõnkõn,” io'e cekariwa. ");
INSERT INTO myu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","— Imẽnpuye dak 2 mil iat'a juk o'yabuiat dinheiro'a oyadojot dojot ixe be―jekariwa be. 4 mil iat'a o'yadojot. — “Juku, Kariwa!” io'e. “Ijoce edinheiro'a―2 mil iat'a. Wara'at'a oyabu―wara'at 2 mil iat'a. Soat edinheiro'am g̃asũ. 4 mil iat'a oyabu ibo 2 mil iap,” io'e cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","— “Xipat,” cekariwa o'e cebe. “Xipacat ẽn. Wedinheiro'a muxipanpan cĩcã ẽn. Yopĩt ma o'e. Wa'õ dag̃ imuxipanpan cĩcã eg̃uy owebeam. — “Imẽneju ade bubut cuy eg̃uxipan owebeam,” io'e — io'e Jesus. — “G̃a'a! Peta og̃ug̃ẽ g̃asũ. Acekõnkõn,” io'e cekariwa. ");
INSERT INTO myu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","— G̃ebuje pũg̃ mil iat o'yabuiat o'jekawẽn ixe be―jekariwa be. — “Kariwa!” io'e. “Kuy juk wetaybit edacup iam―warara'at ekat pewi ejat iam―etiotata'ũmap kat pewi,” i napa ma o'e cebe. “Kuy juk wetaybit ekapikap'ũmat pewiata etabu iam,” i napa ma o'e dak. ");
INSERT INTO myu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Oparara ebuxim ibuye. Edinheiro'a oyamõg̃ ipikũykũy be―mil iat'a. Juku,” io'e. “Edinheiro'am―ebubut'am.” ");
INSERT INTO myu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","— “Ibu'u'uat ẽn,” cekariwa o'e. “Ikẽrẽat kug̃ ẽn. Etaybit tu warara'at ekat pewi ojat iam? Wekapikap'ũmat pewiata otabu iam etaybit tu? ");
INSERT INTO myu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Imẽn etaybit pima, wedinheiro'a eyaũm cuy dinheiro'a muxipanpan'ukat pe wara'at dinheiro'a bu am owebeam,” io'e. “Wepit puje, eyaũm kuka owebe,” io'e. ");
INSERT INTO myu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","— “Dinheiro'a juy epeyabu cebewi―pũg̃ mil iat'a,” cekariwa o'e warara'acayũ be. “Epeyaũm cuy wara'at pe―10 mil iat'a kug̃at pe,” io'e kapikpikayũ be. ");
INSERT INTO myu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Imẽn ma. Adeat kukat pe wara'at je'g̃ũm ip. Imẽnpuye ade jĩjã ikug̃ e'em. Imẽnpit yopĩcat kukat xewi ixe yopĩcat je'jat ip,” io'e cekariwa. ");
INSERT INTO myu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Ite ibu'u'uat tak epejoxik cuy kabiokbog̃at ka be―tõtõnap ka be―tũy yeiyeiat ka be,” io'e cekariwa — io'e Jesus. Imẽn Jesus soat o'e iboceayũ imutaybit am. Cekariwa dinheiro muxipatpan cĩcãayũ o'ju ip peta be ceweju. Imẽnpuxim Deus a'õ kayayũ jeedop ip Deus xe soat em. Ipikũykũy be cekariwa dinheiro mõg̃at pit o'joxik ip kabiokbog̃at ka be. Imẽnpuxim Deus ipiat supi'ajoat ja'õ kay'ũmayũ be. Imẽn Jesus imutaybitbin o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus o'jekawẽn waram iboceacat pe. — Soat wag̃o õn. Odipap kug̃ wajẽm puje, soat kukan oce'e. Deus ekawẽn tojotjot'ukayũ jajẽm ip oweju. Jay. Ajo xipat Deus xe iap oceg̃uwẽn, ajo xipat g̃u iap tak. ");
INSERT INTO myu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","— Ipi juacayũ je'awero owap. Apẽn ovelha kukuk'ukat ovelhayũ o'taẽ bodeyũ bewi, imẽnpuxim õn tak ipi juacayũ bewi wa'õ kayayũ otaẽ―kũyjobitbicayũ. Kacũg̃cũg̃'i jeedop ip oba'at kadi. Kũyjobitbit'ũmayũ bit oba'ũg̃ kadi kacũg̃cũg̃'i jeedop ip. ");
INSERT INTO myu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","— Cũg̃'i buje, ocekawẽn oba'at kadiayũ be. — “Deus kuy eymucokcok cĩcã. Webay kay juy epesot! Eyka be juy epeõm―kuy osukamuxipaniap ka be. Deus kuy ipi mug̃ẽg̃ẽm pima, cuk eyka mug̃ẽ dak,” ioce'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Epeõm! Xipan cĩcã juk adi eyju okuk. Ore bima, puybit cuk adi epeg̃ũm owebe. Obipuruk pima, idibi juk adi epetiũm owebe. Oka be'ũm pima, xipan cuk adi eyju okuk eyduk'a be. ");
INSERT INTO myu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka'ũmg̃u wekamixa bima, kamixa juk epeg̃ũm owebe. Owãtaxipi bima, epajẽm obuywat am. Õn daomũnmũnap'a be bima, epajẽm okay,” ioce'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","— “Kariwa!” Deus xe cũg̃ cĩcãayũ e'em. “Ere jekukum ejojo g̃u oceju. Puybit cuk oceg̃ũm g̃u ewebe. Ebipurug̃ jekukum tak ejojo g̃u oceju. Idibi juk ocetiũm g̃u ewebe,” i'e'em ip. ");
INSERT INTO myu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","39","“Ewãtaxipi g̃u ejojo oceju. Cuk ocajẽm g̃u ekay ebuywat am, ẽn daomũnmũnap'a be bima,” i. “Eduk'a'e'ũma jekukum ejojo g̃u oceju. Oceju g̃u xipan ekuk cuk acesop oceduk'a be. Kamixa dak cuk oceg̃ũm g̃u ewebe,” i'e'em ip. ");
INSERT INTO myu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","— “Owebe epeg̃ũm g̃u,” ioce'e cebe ip. “Imẽnpit webekitkit pe epeg̃ũmiap owebe epeg̃ũmiap puxim. Omubuyxin cĩcã webekitkit. Yopĩt ma ip ipi juacat etabun. Imẽnpit ixeyũ be epeg̃ũmiap, owebe epeg̃ũmiap puxim ma,” ioce'e. — Soat kukan oce'e — io'e. ");
INSERT INTO myu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","— G̃ebuje õn e'em cebe ip―oba'ũg̃ kadiayũ be. “Deus xe ikẽrẽat mujugrũg̃rũg̃'ukayũ eyju. Imẽnpuye Deus jajẽm eykay ipiat'ajoan eywebe. Epeyenapõn cuy oxewi. Ipiatpi'ajojoap pe soat em epesop―daxabog̃ pe―ibiõg̃buk kẽrẽayũ kukukat ka be. Deus o'g̃ug̃ẽ ibiõg̃buk kẽrẽayũ kukukat kam―ixe ekawẽn tojotjot'ukayũ kam tak,” ioce'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","— “Xipan g̃u juk adi okuk epesop. Ore bima, puybit cuk adi epeg̃ũm g̃u owebe. Obipuruk pima, idibi juk adi epetiũm g̃u owebe. ");
INSERT INTO myu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Oka be'ũm pima, xipat g̃u juk adi eyju okuk eyduk'a be. Ka'ũmg̃u wekamixa bima, kamixa juk adi epeg̃ũm g̃u owebe. Owãtaxipi bima, kuy obuywatwan g̃u epesop. Õn daomũnmũnap'a be bima, epajẽm g̃u okay,” ioce'e cebe ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","— “Kariwa!” Deus xe ikẽrẽat mujurũg̃rũg̃'ukayũ e'em. “Ere jekukum ejojo g̃u oceju. Imẽnpuye puybit cuk oceg̃ũm g̃u ewebe. Ebipurug̃ jekukum ejojo g̃u oceju. Imẽnpuye idibi juk ocetiũm g̃u ewebe. Ewãtaxipi g̃u ejojo oceju. Imẽnpuye juk ocajẽm g̃u ekay ebuywat am. Ẽn daomũnmũnap'a be g̃u eg̃uy. Imẽnpuye juk ocajẽm g̃u ekay,” i. “Eduk'a'e'ũma jekukum ejojo g̃u oceju. Imẽnpuye oceju g̃u xipan ekuk cuk acesop oceduk'a be. Ejojo g̃u oceju, ekamixa'ũm pima. Imẽnpuye kamixa juk oceg̃ũm g̃u ewebe,” i'e'em ip. ");
INSERT INTO myu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","— “Webekitkit pe g̃u epeg̃ũm iap, owebe g̃u epeg̃ũm iap puxim,” ioce'e cebe ip. “Ipi juacat etabun webekitkit yopĩt ma. Imẽnpit ixeyũ be g̃u epeg̃ũm iap, owebe g̃u epeg̃ũm iap puxim,” ioce'e―soat kukan oce'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","— Imẽntak ixeyũ je'ju ipiatpi'ajojoap pe jedop am — io'e Jesus. — Deus xe cũg̃ cĩcãayũ acã jeedop ip Deus tẽg̃ ma―itait jeedop ip soat em Deus xe — io'e Jesus jewejuayũ be. ");
INSERT INTO myu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wuymutaybinap ekawẽn mutaybitbin epere buje, Jesus o'jekawẽn jewejuacat pe. ");
INSERT INTO myu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Eyetaybit xepxep xet kap puje, Páscoa epeta jajẽm iam. Ijop Páscoa bima, ijoceat odujowat okay itakomaayũ kay obamupaya am. Korosa be oba mupaya ip. Waoka ip — io'e Jesus―soat wag̃o o'e. ");
INSERT INTO myu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","G̃ebuje paĩyũ kukukayũ o'jeawero ip uka yabog̃ cĩcãat'a be―ibuyxi jĩjãat tuk'a be―Caifás tuk'a be. Judeuyũ kukukayũ dak o'jeawerowero. ");
INSERT INTO myu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","O'jewag̃uyda soat ip. Jesus daomũnũnap muwẽnuwẽn o'e ip. Apẽn oce'e iam kawẽnuwẽn o'e jewewebe. Yaoka ojuy ip iba'arẽm. ");
INSERT INTO myu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","— Páscoa bima bit Jesus ataomũn g̃u, adeayũ be wuyaokaap puxim — io'e ip jewewe be. Ixe Páscoa epeta bima Judeuyũ pão'a o'o'uk ip osodop―yamuyuhuhuaptõmtẽm'ũmat'a. Ijop epeta mug̃ẽg̃ẽm pima, apẽn Deus wuye'ajojoyũ'ũm'ũm o'g̃ujẽm Egito eipi bewi iap kay g̃ebum'uk ip osodop. ");
INSERT INTO myu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Ierep tũibit tuk'a be ayacat oajẽm―Simão duk'a be. Jesus xik'i o'e jekõnkõn jeweju itaybitbinayũ xe. Tide'oati kug̃ oajẽm Jesus kay. Jesus'a abi be o'timõg̃ Betânia ka be. O'timõg̃ timũn'a bewi―wita'a mug̃ẽg̃ẽ'a bewi―alabastro'a mug̃ẽg̃ẽ'a bewi. Tideibog̃ cĩcã ixedi tide'oati. ");
INSERT INTO myu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Imẽnpuye itakoma ip o'e ayacat kay Jesus eju etaybitbinayũ. — Te'e ma ig̃odi tide'oati mu'ũm teku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","— Tide'oati deida buje, kajuk teibog̃ o'jat! Ade kuka juk dinheiro isurũg̃at o'jat prata mug̃ẽg̃ẽ. Tadaybotbocayũ be kuka juk dinheiro o'g̃ũm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus itaybit apẽn kawẽnwẽn ip iam. Imẽnpuye o'jekawẽn cebe ip. — Ite mukorẽmrẽm g̃u bit cuy epe'e — io'e cebe ip. — Xipacan ma teku o'e owebe. Apẽnpuye eyetakoma ite kay? Eyetakoma g̃u juy epesop cekay — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","— Tadaybotbocayũ soat em ma eyxe — io'e. — Eybikuy bima, ixeyũ buywan put eywebe. Õn pit soat em g̃u og̃uy eyxe. Soat em g̃u xipacan ey'e but owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","— Ite ayacat ojebit o'g̃ude'on, oje'ũ g̃u buk ma'g̃u. Wetabẽg̃ pima ma kuy omude'on witabikũy be omõg̃ awap — io'e. ");
INSERT INTO myu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","— Okay itabucayũ ijop ekawẽn g̃uwẽnuwẽn soat kaka dag̃―kawẽn idipat. Apẽn ite ayacat o'tidi wa be iap g̃uwẽnuwẽn tak ip soat kaka dag̃. Soat ka watwat g̃ebum je'e apẽn ixe o'e iap kay. G̃ebum cuy epsop iboap kay — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","G̃ebuje Judas Iscariotes oajẽm paĩyũ kukukayũ kay. Pũg̃ 12 beayũ'in ixe Judas osunuy. ");
INSERT INTO myu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ixe o'jekawẽn paĩyu kukukayũ be. — Pebũrũ epeteida owebe Jesusũmap teim? — Judas o'e. — 30 be prata'a — io'e ip. — Xipat — Judas o'e. O'yaũm ip. ");
INSERT INTO myu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Imẽnpuye Judas oeku: — Pu kabia Jesus puap kabia? — io'e jewebe ma. Imẽn oekuku kudadam. G̃ebuje bit ma ag̃u Judas oeku Jesus pu ojuy itakomaayũ be iũm ãm. ");
INSERT INTO myu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Oajẽm ip Jesus kay―12 beayũ. Páscoa epeta osunuy. Iboap epetam Judeuyũ pão'a o'o'uk―yamuyuhuhuaptõmtẽm'ũmat'a. Ovelha dak aokaka'uk osodop ip Páscoa epeta bima―koapat kabia bima. — Poce ovelha ocejoyoy peta ajẽm pima? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","— Epeju juy okay itabucat pe―ag̃okatkat pe — io'e. — Jerusalém ka be xeku omuy. I juy epe'e cebe: “ ‘Omuyku eduk'a kay,’ wuymutaybitbin'ukat o'e ewebe. ‘Páscoa be i'o am omuyku, oweju etaybitbin'ukayũ dak,’ io'e ewebe,” i. “ ‘On oje'ũ g̃asũ,’ io'e dak ewebe,” i dak. Imẽn cuy epe'e cebe — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","— Hm hm — io'e ip. O'ju ip Jerusalém ka be. Oajẽm. Jesus kay itabucat tuk'a oõm. Apẽn cuk ixe o'e, Jesus kay itabucat pe o'e ip―soat ma. Ig̃o'a be ovelha o'joyoy ip peta ajẽm pima. Soat muxipanpan o'e ip peta beam. ");
INSERT INTO myu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Katpuje ma Jesus oajẽm. Oabik mesa koreren 12 beayũ eju. O'jekõnkõn ip ig̃o'a be. ");
INSERT INTO myu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jekõnkõn pima ip, o'jekawẽn 12 beayũ eju. — Icẽmãn õn e'em eywebe. Pũg̃ ey'in jekawẽn okay itakomaayũ be. Poce og̃uyiap g̃uwẽn ixeyũ be, odobuxik am. Imẽn oũm epe'e okay itakomaayũ be waoka am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ig̃uycũg̃cũg̃ cĩcã ip o'e. — Kariwa! Õn xe'e? — io'e'e ip pũg̃pũg̃pũg̃. ");
INSERT INTO myu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","— Oweju pão'a mudirem pũg̃ pe ma prato be cekõnkõnat okay itakomaayũ be oũm waoka am. ");
INSERT INTO myu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Soat wag̃o õn. Apẽn oje'ũ iap tup tag̃ oje'ũ―Deus ekawẽntup tag̃ — io'e Jesus. — Karem g̃u ipiat supi'ajo oũmat pit. Xipat kuka adi a'g̃u ixe bit o'jebapuk'ũma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","— Omutaybitbin'ukat! — Judas o'e―itakomaayũ be Jesusũmat o'e. — Õn tu jeũm itakomaayũ be? — Hm hm. Ẽn ma — io'e Jesus jeũmat pe. ");
INSERT INTO myu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jekõnkõn ip pima, Jesus pão'a o'yabu. — Bay! Xipat ẽn — io'e Deus pe. — Ocexat'am eyaũm ocewebe — io'e. O'yamuweka. O'yaũm jeweju etaybitbinayũ be. — Juku — io'e Jesus. — Epeya'o. Ijop'a ojebit — io'e cebe ip. — Pão'a muwekaap puxim ip obamupaya — io'e. ");
INSERT INTO myu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Uva'abidi dak o'timõg̃ tikõnkõnap pe. — Bay! Xipat ẽn — io'e Deus pe. — Ocexati etiũm ocewebe — io'e. O'tiũm cebe ip. — Juku — io'e. — Ijopti juy epetikõn―soat eyju juy epetikõn — io'e 12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","— We'ũ buje jedoyekereren oce “Adeayũ bewi ikẽrẽat oju'uk,” io'e Deus puye. Imẽnpuye Deus ijop kẽrẽat kay g̃ebum g̃u. Adeayũ g̃uisun Deus ekawẽn iisuat xe. Cũg̃ ma jeedop ip cexe―Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","— Waram g̃u otikõn uva'abidi soat ipi watwat webay a'õ kay kũyjobit'ũm pima. Soat ipi watwat ya'õ kaykũyjobin pima bit, tiisuati otikõn uva'abidi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jekõn puje, jebibododon ip o'e Deus kay. O'ju ip. Oajẽm ip―soat ip. Co'a kay oajẽm―Oliveiradip'a kay. Jay. Jesus o'jekawẽn cebe ip―jewejuayũ be. Xĩg̃xĩg̃ pima co'a jeje, Jesus o'jekawẽn. ");
INSERT INTO myu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","— Ijop exima eyju operem — io'e. — Epeyenapõn okay itakomaayũ buxixim. Imẽn Deus ekawẽntup omuwẽnuwẽn: Ovelha kukuk'ukat oyaoka, i. Soat ip jepõg̃põg̃ iõhõyũ, i. Imẽn Deus ekawẽntup omuwẽnuwẽn — io'e. Imẽn kawẽnwẽn o'e Jesus jeweju etaybitbinayũ kukukat puye. Imẽnpuxim ovelha kukukat Jesus puxim. Jesus eju etaybitbinayũ ovelha buxim kuka ip. Ovelha jepõg̃põg̃ ip jekukukat'ũm pima. Jesus etaybitbinayũ jepõg̃põg̃ kuka ip, Jesus e'ũ buje. ");
INSERT INTO myu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","— Imẽnpit we'ũap tomukadi Deus waram g̃uto omutait. Oju eywap Galiléia eipi be — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","— Soat ip jepere―ebureyũ. Ekay itakomaayũ buxixim iparara buye, ip jepere. Õn pit jepere g̃u. Pũg̃ em tak ka'ũma — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","— Tapu, icẽmãn õn e'em ewebe — io'e Jesus Pedro be. — Ijop exima ma “Obure g̃u teku,” i napa ma ece'e ebapũg̃ em — io'e. — Sapokay ede awap “Obure g̃u teku,” i napa ma ece'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","— Oce g̃u ma buk, “Obure g̃u teku,” i, eweju waokaap puxim — io'e Pedro. Soat cewejuayũ imẽn o'e'e. ");
INSERT INTO myu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","G̃ebuje Jesusyũ o'ju kadaihiaptip kay―G̃etsêmani ka kay. — Jocebuku epabikbik — io'e jewejuayũ be. — Bomaku buk õn cum, Deus eju jekawẽn ãm — io'e cebe ip. Oabik ip. ");
INSERT INTO myu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedro o'tujowat, Zebedeu ipotpoyũ dak. Ebapug o'tujowat. Ig̃uycũg̃ cĩcã Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","— Og̃uycũg̃ap pibun je'ũmat co'i õn — io'e ebapũg̃ayũ be. — Epabik — io'e. — Ag̃ cuy epesop — io'e. — Oweju epeyeak cuy. ");
INSERT INTO myu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bosusu o'ju, jebay eju jekawẽn ãm. O'jepo ipi ju jeg̃uycũg̃ap pibun. — Bay! — io'e. — Ewebe iba'ore'ũm pima, omuwedem ece, owebe ipiat'ajoap puxim. Wa'õbi bit we'ũ pin g̃u. Ẽn ebikuy bima bit oje'ũ — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aripit. O'jepit. Oajẽm ebapũg̃ayũ kay. Ixet ip osodop. — Pedro — io'e Jesus. — Eywebe iba'ore du eyg̃uy pũg̃ hora ma oweju jeak am? ");
INSERT INTO myu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ag̃ cuy epesop! — io'e cebe ip — ebapũg̃ayũ be. — Xen g̃u juy epesop. Deus eju juy epeyekawẽn eywebe ikẽrẽat mujurũg̃ap puxim―eywebe Satanas a'õ kay kũyjobicap puxim — io'e. — Eybu'u jĩjã ikẽrẽat mug̃ẽ ãm. Imẽnpit ikẽrẽat epeg̃ug̃ẽ eya'õbaca'ũm puye. Imẽneju Deus eju juy epeyekawẽn, ixe a'õbacaap kug̃ eyeku am — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O'ju waram. — Bay! — io'e waram Deus pe. — Ewebe iba'ore'ũm pima, omuwedem ece, ip owebe ipiat'ajoap puxim. Ẽn ebikuy bima bit, oje'ũ — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aripit. Jesus waram o'jepit ebapũg̃ayũ kay. Ixet ma'g̃uto ip osodop. Itaxeebaca o'e ip, xet pibun. ");
INSERT INTO myu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Waram o'ju jebay kay, jekawẽn ãm. Kuyat ekawẽn puxim waram o'jekawẽn Deus eju. ");
INSERT INTO myu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aripit. O'jepit ebapũg̃ayũ kay. — Eyxet mabuk g̃u du? — io'e cebe ip. — Jebodoydoy mabuk g̃u du eyju? — io'e. — Soat wag̃o õn. We'ũap kabia kay õn ajẽm — io'e. — G̃asũ okay itakomaayũ oũm ip ikẽrẽat mujurũg̃rũg̃'ukayũ be waoka am. ");
INSERT INTO myu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Epe'ãy! — io'e cebe ip. — Ak'i juy epe'e! Itakomaayũ be oũmat omuyku. G̃ã'ã okay itakomaayũ atopabijuk — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus kay Judas oajẽm. Kawẽnwẽn pima, oajẽm. 12 beayũ'in osunuy Judas. Jesus eju jekuku'uk osunuy. Ade oajẽm ip―paja kukug̃ayũ, jeba'ip kukug̃ayũ dak. Oajẽm ip, Jesus kudadam Judeuyũ kukukayũ a'õbi, paĩyũ kukukayũ a'õbi dak. ");
INSERT INTO myu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","— Oyag̃obukõn'ibit cuy epejat. Ixe Jesus — Judas juk o'e cebe ip―Jesusũm cekay itakomaayũ beiat. — Ocejat cuy — i juk o'e ip―Judas ejuayũ. ");
INSERT INTO myu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Isum yajẽm: — Wuykat, omutaybitbin'ukat! — Judas o'e Jesus pe. O'yag̃obukõn. ");
INSERT INTO myu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","— Obure — io'e Jesus. — Apẽn ẽn e'em iap, g̃asũ ma juy ece — io'e. Oajẽm ip Jesus xe, ibu am. ");
INSERT INTO myu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Imẽnpuye Jesus ejuat jepaja o'ju'uk iyuk pewi. O'sug̃uybu'uk pajam paĩyũ kukukat ebekit g̃uybu ikibi. ");
INSERT INTO myu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","— Paja ejomõg̃ cuy iyuk pe — Jesus o'e. — Pajam wara'at o'yaokaiat ixe dak pajam yaoka ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","— Õn cekay bima, webay 12 mil beat o'g̃uju kuka―jakawẽn tojotjot'ukayũ. G̃axĩn ma kuka o'g̃uju okay itakomaayũ buxim — io'e jewejuacat pe. ");
INSERT INTO myu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","— Deus ekawẽn tojotjot'ukayũ ajẽm puje bit, iba'ore kuka o'e owebe we'ũ ãm Deus a'õ dag̃ pit. Imẽn put ma owebe―we'ũ but ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ixe ehora bima, Jesus o'jekawẽn yajẽmibiyũ be―adeayũ be. — Ade kabia juk adi og̃uy Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Imukũyjojom cuk adi og̃uy. Eyju bit odaomũn ig̃o'a be g̃u bit. Eyju dak epesot odaomũn ãm paja kukug̃, eyba'ip kukug̃ tak, ibukurukat taomũg̃ap puxim — io'e cebe ip. — Ibukurukat g̃u on pit! — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","— Kuy bima o'tupmubararak ip Deus ekawẽntup apẽn ip odaomũniaptup — io'e. — “Ibukurukat taomũg̃ap puxim ixe taomũn ip,” i'e'em ig̃odup — io'e. — Imẽn ma odaomũn ip g̃asũ dak — io'e Jesus. Soat ip Jesus o'jepere ceweju etaybitinayũ. Soat ip o'watwat. ");
INSERT INTO myu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","O'jacayũ o'tujowat ip. Jesus o'tujowat ip Caifás kay―paĩyũ kukukat kay. Iboceayũ juk o'jeawero ip Caifás tuk'a be. Judeuyũ kukukayũ o'jeawero ip, Moisés ekawẽn imutaybitbin'ukayũ dak. ");
INSERT INTO myu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro bit Jesus nomuju o'ju. Wũy ma o'ju. Paĩyũ kukukat tuk'a naxĩnõm pe oajẽm. Oabik sorarayũ parakpe. Oabik, ijo am―apẽn je'bapuk Jesus pe iap co am. ");
INSERT INTO myu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paĩyũ kukukayũ o'je'awero ip, yawẽg̃ mukẽrẽrẽrẽn'ukayũ kudadam, pũg̃ tag̃ ma Jesus muymuy am, Jesus aokam dapxi a'õ nomuju. Soat o'je'awero ip―paĩyũ kukukayũ, Judeuyũ kukukayũ, Moisés ekawẽn imutaybitbin'ukayũ dak―soat o'je'aweroiayũ. ");
INSERT INTO myu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oajẽm ip je'aweroayũ kay. Ade oajẽm―yawẽg̃ mukẽrẽrẽrẽn'ukayũ. Imẽnpit iba'ore o'e Jesus awẽg̃ mukẽrẽ ãm. ");
INSERT INTO myu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Xepxep oajẽm g̃ebuje bit―wuymug̃uykuku'ukayũ. — Ite ag̃okatkat o'e: “Deus eju ekawẽnwẽnap'a oyamuy'ũm put―yabog̃at'a. Imẽnpit oyamuy put waram ebapũg̃ kabiam,” i — io'e xepxepayũ―dapxiyũ. ");
INSERT INTO myu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imẽnpuye paĩyũ kukukat ma o'ãy, jekawẽn ãm. — Apenpuye ecede g̃u awẽg̃ mukẽrẽrẽnayũ be? — io'e. — Icẽm tu ip e'em? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesus mũg̃ ma osunuy. — Deus emunaẽ ẽn pima, eg̃uwẽn cuy ocewebe — koapat paĩyũ kukukat o'e Jesus pe. — Deus a'õbi―soat em itaicat a'õbi eg̃uwẽn cuy. Deus emunaẽ ẽn tu? Deus ipot tu ẽn? — io'e. ");
INSERT INTO myu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","— Hm hm. Ixe ipot ma õn — io'e. — Soat wag̃o õn. G̃uyjom ojojom epe'e. Xik'i og̃uy Deus xe iba'at kadi. Ixe Deus soat podi ma ya'õbacaat. Cexe õn pima ojojom epe'e. Soat kukukan oce ixe eju. G̃uyjom ijodi waram ojot. Kabikerereat tag̃wi okop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Imẽneju jeekabek o'g̃uwek paĩyũ kukukat, jetakoma pibun. — Deus muymuy teku — i napa ma o'e. Jesus muwẽnuwẽn o'e. — Epeya'ĩjojo kuy ixe ekawẽn. Wara'acayũ g̃u ajokudada Jesus awẽg̃ mukẽrẽrẽn ãm — io'e cebe ip―o'je'aweroweroiayũ be. ");
INSERT INTO myu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","— Ajo cũg̃ ma eyxe? Apẽn tak ace'e Jesus pe? — io'e cebe ip. — Ikẽrẽat kug̃ teku Deus xe — i napa ma o'e ip―ibimãmãayũ ekawẽn coco'ukayũ. — Imẽnpuye ayaoka — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","O'je'aweroiayũ o'g̃uxiuxi Jesus dopa be―jebidi. Jetakoma pibun o'g̃uxiuxi. O'yaokaka ip. Pũg̃ ixeyũ'in Jesus dopa o'topaoka. ");
INSERT INTO myu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","— Cristo! — io'e ip cebe. — Abu edopaoka oce'in? Imen o'jekawẽn ip, kuy Jesus o'topamuekabek pag̃õm puye. ");
INSERT INTO myu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro dak xik'i osunuy uk'a daxirõg̃ pe. Paĩyũ kukukat ebuywatwat oajẽm―ayacat'isuat. Oajẽm Pedro kay. — Ẽn tak mo Jesus eju ejeku―G̃aliléia eipi bewiat eju — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","— Õn g̃u. Apẽn ẽn e'em? Ixe bure g̃u õn — i napa ma o'e Pedro, soat ya'ĩjojom pima. ");
INSERT INTO myu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","O'ju yanaxĩnõm pe. Wara'at ayacat'isuat ixe Pedro o'jojojo. — Ite Jesus ejuibit — io'e iboceayũ be. — Nazaré wat ejuibit — i. ");
INSERT INTO myu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","— Ixe eju ocekuku g̃u — Pedro o'e. — Ixe bure g̃u õn. Deus itaybit Jesus wetaybit g̃u iam — i napa ma o'e Pedro. ");
INSERT INTO myu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ibunbun pima, oajẽm cekay iboceayũ. — Icẽman — io'e ip. — Apẽn ẽn kawẽnwẽn, imẽntak G̃aliléia watwat kawẽnwẽn ip. Imẽnpuye ocetaybit Jesusyũ'in ẽn iam — io'e ip Pedro be. ");
INSERT INTO myu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","— Dapxiyũ eyju! — i napa ma o'e Pedro. — Ixe bure g̃u õn! Ceweju õn pit ocekuku g̃u — i napa ma o'e. — Õn icẽmãn e'em'ũm pima, Deus cuy ipiat supi'ajoat owebe — Pedro o'e. Sapokay o'jede g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jesus a'õ kay Pedro o'jeg̃ebu. — Sapokay ede awap, abapũg̃ em ece'e, “Jesus bure g̃u õn,” i — i juk o'e Jesus Pedro be. Iboap kay o'jeg̃ebu Pedro. O'ju uk'a naxĩnõm pewi. O'tõn cĩcã Pedro. Ig̃uycũg̃ cĩcã o'e, ikẽrẽat o'g̃ug̃ẽ buye. ");
INSERT INTO myu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kabia isum soat o'je'awero ip―Judeuyũ kukukayũ, paĩyũ kukukayũ dak. O'je'awero ip, Jesus aokaap muwẽnuwẽn ãm. ");
INSERT INTO myu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesus o'jacayũ o'subamukirik ip jekukukat a'õbi. O'tujowat ip. O'ju ip Jesus eju. Pilatos kay o'ju ip―ipi kukukat kay. ");
INSERT INTO myu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas pe itakomaayũ Jesus dujowat aokam iap co buje, o'ju waram Judas paĩyũ kukukayũ kay. O'yadujowat dinheiro'a―prata'a―30 beat'a. Ig̃uycũg̃ o'e, o'g̃ug̃ẽap puye. Oajẽm cekay―paĩyũ kay, Judeuyũ kukukayũ kay dak. Itakomaayũ be Jesusũmat oajẽm. ");
INSERT INTO myu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","5","O'yaxik prata'a Deus ekawẽnwẽnap'a be―yabog̃at'a be. Batku! — Ikẽrẽat kug̃ g̃u Jesus. Õn ma ikẽrẽat kug̃, Jesus omuyap og̃uwẽn eywebe buye. Ig̃asũ bit ip kuy o'tujowat yaoka am. O'tujowat, cekay itakomaayũ be õn iũm puye — io'e. — Ẽn ma ikẽrẽat kug̃ a'õbi ma―oceju g̃u bit. Ekpiwan ma — io'e ip. O'jenapõn Judas. Oe'ũ Judas'ũm. O'jewag̃obumukirik. O'jewemutoro. Oe'ũ. ");
INSERT INTO myu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","G̃ebuje: dinheiro'a o'yabu ip. — Ijop'a yamõg̃ pa'ore wuywebe Deus edinheiro mũn'a be — io'e paĩyũ kukukayũ. Jewewebe o'e ip. — Cũg̃ g̃u kuka o'e Moisés ekawẽn tag̃ ijop'a Jesus aokaap ma dei an puye — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Imẽneju o'je'awewero ip. Apẽn xe'e ace'e iap muwẽnuwẽn o'e ip. Imẽnpuye ig̃o'a yaũm ip itĩg̃'a buximat'a mug̃ẽg̃ẽ'ukat pe jekat teim. Imẽn iboap kat o'jat ip. O'jat ce'ũ'ũayũ kot am iboce―Jerusalém ka bewi'ũmayũ kot am. ");
INSERT INTO myu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesus aokaapteim ip o'jat iapka i osunuy ika butet. G̃asũ dak imẽn ibutet. ");
INSERT INTO myu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Imẽn o'jebapuk Jeremias ekawẽn tag̃―Deus a'õ muwẽnuwẽn'ukat ekawẽn tag̃. Kuyje Jeremias o'e: Israel naxeg̃ebitbit kukukayũ dinheiro'a o'yadujowat ip―prata'a―30 beat'a. Ijop edinheiro juk o'g̃uwẽn ip itakomaayũ be Deus emunaẽ og̃ũm iaptei o'e iap, i. ");
INSERT INTO myu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","O'yaũm ip itĩg̃'a buximat'a mug̃ẽg̃ẽ'ukat pe ikat teim. Deus a'õbi o'yaũm ip, i juk o'e Jeremias. ");
INSERT INTO myu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Oajẽm Pilatos kay Jesus o'jaciayũ―ipi kukukat kay. — Judeuyũ kukukat tu ẽn? — io'e Pilatos Jesus pe. — Ẽn ma iboam e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jesus tak o'jomuymuy ip―Judeuyũ kukukayũ, paĩyũ kukukayũ dak. Jesus o'jede g̃u bit ixeyũ be. ");
INSERT INTO myu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","— Soat eya'ĩjojo g̃u du ixeyũ o'e iap? — Pilatos o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","O'jede g̃u bit. Pũg̃ em tak ka'ũma. Pilatos yag̃uybabi'ũm cĩcã o'e, Jesus o'jede g̃u buye. ");
INSERT INTO myu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","17","G̃ebuje soat o'je'awero ip Pilatos xe. Judeuyũ o'je'awero ip. — Abu og̃ujẽm cuy daomũnmũnap'a bewi? — Pilatos o'e cebe ip. — Barrabás ma du? — io'e. — Jesus Cristo g̃u xe'e? — io'e. — Pebicat og̃ujẽm cuy? Cristo butetecat tu? io'e Judeuyũ be―adeayũ be. Imẽn Pilatos o'e, imẽn ibikuy buye. Páscoa epeta bima ipi kukukat Judeuyũ emunaẽ mujẽmjẽm'uk osunuy daomũnmũnap'a bewi. Imujẽmjẽm'uk, jekpiwan ma. Ikẽrẽat kug̃ cĩcãat osunuy daomũnmũnap'a be iboap Páscoa bima. Barrabás i osunuy ibutet. Soat ma itaybit ip ixem. ");
INSERT INTO myu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Imẽnpit Pilatos itaybit paĩyũ kukukayũ itabutkarey o'e ip Jesus kay iam. Itaybit jetabutkarey pibun Jesus o'tujowat ip iam. ");
INSERT INTO myu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatos tayxi dak ja'õ dujowacat o'g̃uju. Ja'õdaxijom o'g̃uju jektop kay. Ipi kukukat pe iboceacat aweroroap pe o'g̃uju. Iboce Pilatos xik'i osunuy Jesus awẽg̃ co am. Oajẽm ya'õdujowacat. — “Ixe Jesus cũg̃at,” etayxi o'e — ya'õdujowacat o'e itop pe. — “Jesus oajẽm wexeybi,” i. “Ipiat osupi'ajo jĩjã wexey ixe buye,” i — io'e ya'õdujowacat. — “Ikẽrẽat cuy eg̃ug̃ẽ g̃u cebe―Jesus pe,” i dak — ya'õdujowacat o'e Pilatos pe. ");
INSERT INTO myu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","21","— Pebicat og̃ujẽm cuy daomũnmũnap'a bewi? — Pilatos o'e waram o'je'aweroiayũ be. — Barrabás — io'e ip. Imẽn o'je'aweroiayũ o'e paĩyũ kukukat ekawẽn puye, Judeuyũ kukukayũ ekawẽn puye dak. — “Barrabás,” i juy epe'e Pilatos pe — paĩyũ kukukayũ juk o'e o'je'aweroiayũ be. — “Jesus cuy esubamupaya korosa be,” i juy epe'e Pilatos pe — i juk o'e ip. Imẽnpuye o'je'aweroiyũ o'jekawẽn ip Pilatos pe. — Barrabás eg̃ujẽm cuy daomũmũmap'a bewi — io'e o'je'aweroiayũ. ");
INSERT INTO myu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","— Pam Jesus? Ite butet Cristo i. Apẽn tak oce cebe? — Pilatos o'e o'je'aweroiayũ be. — Esubamupaya juy korosa jeje, yaoka am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","— Ikẽrẽat o'jukuk g̃u teku―pũg̃ em tak ka'ũma! — io'e Pilatos. Imẽnpit big̃ ma ya'õberen o'jewãwã ip. — Esubamupaya juy korosa be, yaoka am. ");
INSERT INTO myu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","O'je'aweroiayũ mukaba'ũm pa'ore o'e Pilatos pe. Jekaba'ũm g̃u o'je'aweroiayũ. Ibuje, Pilatos idibi o'tibu. O'jewebuwuywuy o'je'aweroiayũ etabun, imutaybit am ip õn g̃u okpiwat iam. — Õn g̃u okpiwat Jesus aoka am. Eyju ma epeyaokaat — io'e Pilatos. ");
INSERT INTO myu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","— Ipiat acesupi'ajo — io'e ip. — Wuyipotpot tak, yaokaap puye — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","G̃ebuje Pilatos Barrabás o'g̃ujẽmat daomũnmũnap'a bewi. Jesus pit imupokupog̃ ip o'e ixee mug̃ẽg̃ẽbum Pilatos a'õbi. Ya'õbi Jesus o'tujowat ip o'je'aweroiayũ be, yaoka am, korosa be ibamupaya am. ");
INSERT INTO myu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","G̃ebuje sorarayũ Jesus o'tujowat iecug̃ap tuk'a be. Pilatos a'õbi o'tujowat ip. O'je'awero ip warara'acayũ xe―o'tomuwãayũ―sorarayũ―jewejuacat'in ma. O'je'awero ip iwaywayway am―Jesus waywayway am. Soat ip sorarayũ oajẽm. ");
INSERT INTO myu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesus esay o'ju'uk ip. Iekabek o'g̃uõm ip―ipakpukat―iecug̃ap eekabek puximat. ");
INSERT INTO myu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Widaohobune o'subunemuwakẽn ip yakoreren ma. O'jomõg̃ ip yakoreren. Imẽn o'g̃ug̃ẽ ip Jesus pe, Judeuyũ kukukat puximan imubapuk am, iwaywayway am. Iba'ip o'yopmõg̃ ibui be, iba'at kadi. O'jẽg̃'aecõg̃cõg̃ ip cewap iwaywayway am. — Ẽn ma Judeuyũ kukukat! — io'e ip, iwaywayway am. — Warara'acat podi ma ẽn a'õbuyxi — io'e ip, iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","O'g̃uxiuxi ip Jesus ceje. O'yamupãupã ip iba'im. Iwaywayway o'e ip. Pere. ");
INSERT INTO myu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","G̃ebuje iekabek ipakpukat o'ju'uk ip. Cesay ip waram o'g̃uõm. O'tujowat ip yaokam―iba mupaya am korosa be. ");
INSERT INTO myu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","33","O'ju ip co'a kay―Gólgota'a kay. Gólgota'a “ce'ũat aririt'a” iape. Cucum pima ip, Cirene ka wat o'topabijuk. Simão i ibutet osunuy. Ixe Simão o'g̃uju ip ibuywat am―Jesus puywat am, korosa dujowat am. ");
INSERT INTO myu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vinhodi tiũm ojuy ip Jesus pe. Iboceat o'tupmuwekoy uva'abidi be wuypipimu'ũmapti be. O'tikõ'ajo Jesus. Tikõn pin g̃u o'e. — Ap! — io'e. ");
INSERT INTO myu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","G̃ebuje sorarayũ Jesus o'subamupaya ip korosa be. Cesay bubum o'e ip―sorarayũ. Dado xikxig̃ o'e ip Jesus tiotpe. — Abu cesay je'jat? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","38","Tupmubararakaptup kug̃ o'e ip sorarayũ. Tupmubararara'g̃ o'e ip Jesus puten. Tũybe ajo-ikẽrẽan ip o'e iãn tak ip o'tupmubarararak: “Ibutet Jesus i. Judeuyũ kukukat teku,” i. Ibodup tuparararakatup o'tupmõg̃ ip korosa be, Jesus abi ase. G̃ebuje xepxep o'subamupaya ip wara'at korosa be. Ibukurukayũ osodop ip―xepxep. Jesus pa kadi o'subamupaya ip. Pũg̃ ma Jesus pa'at kadi osunuy; wara'at iba'ũg̃at kadi. Oabik ip Jesus kay jeak am. Iwiwim o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wara'acayũ kapkam o'e ip korosa etako dag̃. Yaaruaru. Iwaywayway o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","— “Deus eju kawẽnwẽnap'a oyamu'ũm―yabog̃at'a,” i juk ece — io'e jewaywaywayayũ Jesus pe. — “Ebapũg̃ kabiam wara'at'a kuka oyamuy,” i juk ece — io'e ip. — Ecewe daxijo juy — io'e ip. — Deus ipot ẽn pima, ekop korosa ejuwi — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Paĩyũ kukukayũ dak Jesus kay jewaywayway o'e ip. Moisés ekawẽn imutaybitbin'ukayũ dak ixe kay jewaywayway ip, Judeuyũ kukukayũ dak. Soat ip jewaywayway o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— Teku wara'acayũ daxijojo'uk osunuy — io'e ip. — Imẽnpit jewedaxijo ba'ore cebe je'ũap puxim. Israel eipi kukukat g̃u du? G̃axĩn ma korosa ejuwi kop puje, ocetabut oce'e cekay — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","— Deus kay itabut teku. Deus cekay bima, Deus o'taxijo juy g̃asũ — io'e ip. — O'taxijo juy teku o'e buye, “Deus ipot õn,” i — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ibukurukayũ dak imẽn o'e Jesus pe―ceweju ibamupaya'ibiyũ. ");
INSERT INTO myu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kaxi wuyase bima, kabiok o'e ibo kabia―Jesus e'ũap kabia. Soat tag̃ o'e kabiok―Judeia eipi dag̃. Kaxicug̃ pima, katpuje bima dak. Ebapũg̃ hora bun kabiok oeku. ");
INSERT INTO myu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Katpuje ya'õberen o'jewãwã Jesus. — Eli, Eli, léma sabactani? — io'e. “Deus, apẽnpuye ẽn opere?” iboap ekawẽn iape. ");
INSERT INTO myu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iboceayũ Jesus ekawẽn o'ya'ĩjojo ip. — Elias nomuwãwãm teku — io'e ip, xipan g̃u ip o'jekũyjo buye. ");
INSERT INTO myu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iboceat o'jedau idibi bubuap munopapũn ãm uva'abidim―tideibog̃'ũmatim. Ixe dak idibi bubuap o'jomõg̃ ip'abi be. G̃ebuje o'yopmuyu Jesus pe imutitit am. ");
INSERT INTO myu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","— Mẽnpuk — warara'acayũ o'e. — Omuyku paxi Elias taxijo am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Waram o'jewãwã Jesus ya'õberen. Oe'ũ g̃ebuje. Jekpiwan ma oe'ũ. ");
INSERT INTO myu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","(Oe'ũ bima pag̃o Deus eju kawẽnwẽnap'a be osunuy―yabog̃at'a be―uk'a exĩntabi nomudipap epag̃o. Jekpiwan ma ixe pag̃o o'jewek, Jesus e'ũ buje. O'jewek kabi kadi wi ipi kay. Ipi o'jexixi ibo ka be. Wita'a o'je'aewekwek. Jesus oe'ũ bima, o'je'aewekwek ip. ");
INSERT INTO myu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Jesus waram g̃uto itait puje, ce'ũ'ũayũ dopap o'tomudip'uk ip, ipi jexixixi buye. O'tomudip'uk g̃uyjom. Oe'ũiayũ itait o'e waram―Deus kay itabucayũ'ũm'ũm. O'jẽm jedopap pewi. O'ju ip Jerusalém ka kay―Deus xe xipacat ka kay. Adeayũ kay o'jebapuk ip―ce'ũ osodopiayũ.) ");
INSERT INTO myu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sorarayũ kukukat o'jojojo, cewejuayũ dak. Soat o'jebapukiap o'jojojo ip, Jesus oe'ũ bima. Ipi jexixixim o'jojojo ip. Soat o'jojojo ip―Jesus kay jeakayũ. Iparara jĩjã o'e ip. — Icẽmãn — io'e ip. — Ite ag̃okatkat'ũm Deus ipot osunuy — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aoyũ dak o'jojojo ip wũy wi―Jesus nomuju tũibiyũ―ibuywatwat tũibiyũ. Cẽmcẽm pima G̃aliléia eipi bewi ibuywatwan ip o'e. Ade osodop ip. ");
INSERT INTO myu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ixeyũ aoyũ parakpe ebapũg̃ aoyũ osodop ip. Ibũrũ ma ip osodop: Maria Madalena, wara'at Maria dak, Zebedeu ipotpoyũ xi dak. Wara'at Maria Tiago xi osunuy, José xi dak. ");
INSERT INTO myu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Katpuje ma Arimatéia ka wat oajẽm Pilatos kay. José i ibutet osunuy―ade ibubutbecat―Jesus kay itabucat. — Jesus'ũm jebit mukop pin oce — io'e Pilatos pe. — Ha'a — io'e. — Ijebit cuy eg̃ukop — io'e. ");
INSERT INTO myu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O'ju José korosa ka. Ijebit o'g̃ukop korosa ejuwi. Jesus'ũm o'g̃ukabekbek pag̃õm―irucan―iisuan. ");
INSERT INTO myu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","O'tujowat ce'ũ'ũay'ũ dopap kay. Ixe'ũm o'jomõg̃ witabikũy be―jemukũymug̃ẽkũy be. Kuy o'sukũymug̃ẽ je'ũap puxim. G̃ebuje wita'a o'yamuypen witabikũy nomudip'am. Yabog̃at'a o'yamõg̃. G̃ebuje José o'jenapõn. ");
INSERT INTO myu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Madalena dak xik'i o'e witabikũy xe, wara'at Maria dak. ");
INSERT INTO myu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kuyaje paĩyũ kukukayũ o'je'awero Pilatos wap Sábado bima. Fariseuyũ dak o'je'awero. ");
INSERT INTO myu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","— Kariwa! — io'e ip Pilatos pe. — Itait pima, Jesus cuk o'e: “Ebapũg̃ kabia bima, waram wetait oce. Ojebapuk g̃uto,” i — io'e ip. — Imẽn wuymug̃uykukum xeku — i napa ma o'e ip. Itabut'ũm ip. Tũybe napa ma e'em iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","— Imẽnpuye juy esukũywiwiat. Sorarayũ eg̃uju juy ebapũg̃ kabia topam ip, witabikũy wiwi am — io'e ip. — Imuju'ũm pima, Jesus kay itabucayũ jajẽm ip ixima dag̃ ijebit pu am. G̃ebuje ip napa ma jĩjã je'e: “Jesus o'je'ada,” i. Xeku juk o'e: “Deus emunaẽ oce,” i — io'e ip Pilatos pe. — Koapat podi ma je'e ip napa jĩjã ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","— Ma — io'e. — Sorarayũ og̃uju eyweju ikũy wiwi am — io'e Fariseuyũ be. — Hm hm — io'e ip. — Cum oceju. ");
INSERT INTO myu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","O'ju ip Jesus'ũm topap kay. Wita'a mudek bõrõbu o'subumupaya ip Pilatos a'õbi―ikũy nomudipap'a pidase. Sorarayũ o'jomõg̃ ip. Ikũy wiwiayũ o'jomõg̃ ip. Aripit. O'jepit ip jeduk'a be―Fariseuyũ, paĩyũ kukukayũ dak. ");
INSERT INTO myu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Domingo bima Maria Madalena o'ju, wara'at Maria dak. Jesus'ũm dopap kay oajẽm ip. Oajẽm kabia isum. ");
INSERT INTO myu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","(Kuy o'jebapuk Deus ekawẽn tojotjot'ukat kabi bewi. Jesus'ũm dopap pe o'jebapuk. Imẽnpuye ipi o'jexixi. Wita'a o'ya'uk Jesus'ũm dopap pewi. Oabik ibo yabog̃at'a jeje. ");
INSERT INTO myu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Osusuy isopsep ãn. Xiririkxiririkiap puxim osunuy. Kabidig̃ buximat co'i iekabek. Irut cĩcã osunuy. ");
INSERT INTO myu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sorarayũ iparara jĩjã o'e ip―topap wiwimayũ. Ce'ũ'ũayũ buxim ip o'e iparara. Jexixixim ip Deus ekawẽn tojotjot'ukat puxixim.) ");
INSERT INTO myu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oajẽm ip. Maria Madalena oajẽm, wara'at Maria dak. O'jekawẽn cebe ip. Deus ekawẽn tojotjot'ukat o'jekawẽn. — Eypararam g̃u juy epesop. Epeyepere. Wetaybit Jesus'ũm kudadam eyju iam―ibamupaya'ibit kudadam iam. ");
INSERT INTO myu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","— Ijoce g̃u bit xeku. Itait waram g̃uto xeku apẽn cuk o'e iap tag̃ — io'e. — Epesot. Epejojojo Jesus'ũm topap — io'e. ");
INSERT INTO myu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","— Ijo buje, dao ma epeju juy Jesus eju etaybitbit topibiyũ kay — io'e aoyũ be. — I juy epe'e cebe ip: “Jesus waram g̃uto o'jetait. Cum eywap Galiléia eipi be. Iboce ixe juy epejojojo,” i. Wekawẽn kay g̃ebum cuy eyju — io'e cebe ip―Deus ekawẽn tojotjot'ukat o'e. — Hm hm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dao ma o'ju ip witabikũy bewi. O'ju Jesus eju imutaybitbit topibiyũ kay. Iparara o'e ip. Imẽnpit icokcok cĩcã o'e ip. O'jedau ip, imukũyjo am. ");
INSERT INTO myu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Daudaum pima ip, Jesus aoyũ o'tobede. — Wuykabia — io'e. O'jẽg̃a'ecõg̃cõg̃ ip Jesus wap. O'suibu ip, ibuyxim ikuk am. ");
INSERT INTO myu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","— Eypararam g̃u juy — io'e cebe ip. — Okitpitpiyũ be epeyekawẽn cuy: “Epeju juy Galiléia eipi kay, ijo am,” i — io'e aoyũ be. ");
INSERT INTO myu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cucum o'e ip imuwẽn ãm cebe ip. Sorarayũ dak o'ju ip Judeuyũ epaiyũ kukukayũ kay. Pũg̃ o'ju―iwiwim topibiyũ'in. O'ju ip Jerusalém ka be. Soat o'g̃uwẽn ip paĩyũ kukukayũ be o'jebapukiap. ");
INSERT INTO myu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","G̃ebuje paĩyũ kukukayũ o'je'awero ip―Judeuyũ kukukayũ dak. Jesus awẽg̃ o'yaweg̃muwẽn ip. G̃ebuje dinheiro o'g̃ũm ip sorarayũ be―Jesus'ũm topap wiwim topibiyũ be. ");
INSERT INTO myu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","— I juy epe'e Jesus awẽg̃ tobuxik pinayũ be: “Jesus'ũm o'tujowat ip ixima be ma. Jesus eju jekukuk topibiyũ o'tujowat ip. Ocexet pima, o'tujowat ip,” i juy epe'e — io'e ip sorarayũ be. ");
INSERT INTO myu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","— Ipi kukukat iboap co buje, ocejekawẽn ceweju. “Ocecokcok cekapikap kay―sorarayũ ekapikap kay,” ioce'e cebe. Imẽn itakoma g̃u je'e eykay — io'e ip―paĩyũ kukukayũ o'e sorarayũ be. ");
INSERT INTO myu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","— Ha'a — io'e ip. — Oceju dak imẽn Jesus awẽg̃ oceyawẽg̃muwẽn. Dinheiro o'jat ip paĩyũ kukukayũ xewi, o'g̃ũm puye. Apẽn paĩyũ kukukayũ o'e iap tag̃ o'e ip. Imẽnpit iboap ekawẽn napaat acã o'e. Imẽneju ibo awẽg̃ te'e ma o'yawẽg̃muypõg̃põg̃ soat Judeuyũ dag̃. G̃asũ dak o'yawẽg̃muypõg̃põg̃ ip―ibo awẽg̃. ");
INSERT INTO myu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Galiléia eipi be onze beayũ o'ju ip. Jesus o'e iap tag̃ o'ju ip. Oajẽm ip co'a kay, Jesus dobede am. ");
INSERT INTO myu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iboce Jesus o'jojojo ip. O'jẽg̃a'ecõg̃cõg̃ ip o'e, ibuyxin ikuk am. Pũg̃pũg̃ pit o'jetabiebarẽm. ");
INSERT INTO myu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oajẽm Jesus ixeyũ tẽg̃ ma. — Wa'õbi soat cucum ip―soat ipi juacayũ, soat kabi beayũ dak — io'e Jesus cebe ip―jejojoayũ be. ");
INSERT INTO myu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","— Epeju juy soat kay―soat ipi juayũ kay — io'e cebe ip. — Imutaybit am ip, epeju juy. Wawẽg̃ cuy epeyekũyjo imutaybitbin ip. Imubatisasan ip epeju juy wa'õbi, webay a'õbi dak, Ibiõg̃buk Xipacat a'õbi dak―Deus biõg̃buk a'õbi — io'e. ");
INSERT INTO myu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","— Soat cuk adi oce eywebe iap cuy epe'e soat pe―ipi juacayũ be — io'e Jesus onze beayũ be. — Okay soat ip imukũyjobit am, wawẽg̃ epe'e — i dak o'e cebe ip. — Ipi opop pima, oju g̃u eywebewi. Soat em og̃uy eyxe. Eyxe og̃uy iap kay g̃ebum cuy epesop — io'e Jesus. — Xipat — io'e ip Jesus pe. — Ẽn ma ejekuku oceweju soat em — io'e ip. Ibũrũ ma");
INSERT INTO myu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijoptup pe ibararak opop Jesus Cristo ekawẽn―kawẽn idipat ekawẽn―Deus ipot ekawẽn. ");
INSERT INTO myu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ixe o'jebapuk ijodi apẽn Deus ekawẽn muwẽnuwẽn'ukat emudupmubararaktup ekawẽn tag̃―Isaías emudupmubararaktup ekawẽn tag̃. Deus o'e: wemumuju og̃uju ewap emubapuk am ewebeam, i. ");
INSERT INTO myu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ixe wemumuju jewãwãwãm uk'a'ũmat pe: E juy epesuemudim wuykukukat kap am, i'e'em. Epesuemucũg̃cũg̃ cuy ixe em, i'e'em. ");
INSERT INTO myu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ibo ekawẽn tag̃ João Batista o'jebapuk uk'a'ũmat pe. O'jebapuk ijodiat mubatisasan, Deus ekawẽn muwẽnuwẽn tak. — Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere — io'e ijodiat pe. — Epeyewemubatisaan cuy “Ikẽrẽat o'gujurlug̃ g̃u g̃asũ bit” i'e am soat pe. Imẽn ey'e buje, Deus ikẽrẽat ju'uk eywebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ade ma o'ju João kay cekawẽn co am. Judéia eipi beayũ o'ju, Jerusalém ka beayũ dak. — Ikẽrẽat cuk adi og̃ujurũg̃rũg̃ — io'e ip. — G̃asũ bit cuy og̃ujurũg̃ g̃u — io'e ip. Imẽnpuye ip o'g̃ubatisaan Jordãodi be. ");
INSERT INTO myu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ixe João doti camelodap mug̃ẽg̃ẽ. Yukpumũnpu kug̃ oeku ixee mug̃ẽg̃ẽ. Arobidadek puximat o'o'uk osunuy. Eit kog̃ũfpi dag̃at o'o'uk tak osunuy João. ");
INSERT INTO myu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Imẽn o'e ijodiacat pe: — Wara'at omuyku onomukadi. Ixe g̃u itaybitbit cĩcã obode ma. Owebe bit suiuk'uk pa'ore ka'ũma ma õn puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","— Idibi be õn eymubatisasan. Ixe bit Ibiõg̃buk xipacat g̃uõm eywebe eykukan — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesus oajẽm João kay. Nazaré ka bewi o'jẽm―Galiléia eipi beatka bewi, ika'ĩtcatka bewi. Oajẽm João kay jemubatisan am. João Jesus o'g̃ubatisan Jordãodi be. ");
INSERT INTO myu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Idibi dag̃wi jeu isum kabi ikoce o'jojojo. Deus biõg̃buk o'jojojo. Pukaso buxim o'kop jekay. ");
INSERT INTO myu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Deus o'jekawẽn kabi kadiwi. — Okpot ẽn―oxe ikukpin cĩcãat! — io'e. — Ocokcok cĩcã ekay — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","G̃ebuje Deus biõg̃buk Jesus o'g̃uju uk'a'ũmat kay. ");
INSERT INTO myu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Quarenta kabia bun oeku iboce. Satanás te'e ma ikẽrẽat o'g̃ujurũg̃at cebe. Puca dak oeku iboce―ika'uayũ. Deus ekawẽn tojotjot'ukayũ bit oajẽm Jesus buywan. Ibuywatwan ip osodop. ");
INSERT INTO myu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Daomũnmũnap'a be ip João muõm puje, Jesus Deus ekawẽn muwẽnuwẽn o'e. Galiléia eipi dag̃ oeku imuwẽnuwẽn. Kawẽn idipat muwẽnuwẽn oeku soat kaka dag̃. ");
INSERT INTO myu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","— G̃axĩn ma Deus soat ijodiacat kukukan je'e — io'e. — Ixe be soat kukukat iap ehora oajẽm. Imẽnpuye ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere! Eyetabun cuy kawẽn idipat kaywuydaxijojoap ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","G̃ebuje Jesus xepxep axima bubu'ukayũ o'jojojo. Galiléiadi wãbu dag̃ cũg̃cũg̃ pima ip o'jojojo iodi wãbu dag̃. Simão o'jojojo, André dak. André Simão kitpit osunuy. Axima bubum ip osodop ũrũm. ");
INSERT INTO myu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus o'e cebe ip: — Epesot cuy oweju — io'e. — Axima bubu'ukayũm cuk adi epesop. G̃asũ bit kawẽn idipat epeg̃uwẽnuwẽn ijodiat pe imutabun ip okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Imẽnpuye ip dao ma jẽg̃rũ o'suiwat axima bubuap. Jesus eju ix o'ju. ");
INSERT INTO myu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bosusu o'ju g̃ebuje Jesus. Xepxep o'jojojo―Tiago, João dak. João Tiago kitpit osunuy. Zebedeu ipotpoyũ osodop ip. Jekobe be ip osodop axima bubuap muwaketken axima bu ojuy. ");
INSERT INTO myu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ijo isum ma Jesus o'tomuwã ip. — Epesop cuy oweju — io'e. Jebay o'suiwat ip. Ceweju ip kapikpik'ukayũ dak o'suiwat ip jebay xe kobe be. Jesus eju ip o'ju soat em jeku am ceweju. ");
INSERT INTO myu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus o'ju Cafarnaum ka kay ebadipdipayũ eju―jeweju etaybitbinayũ eju. Jebodoydoyap kabia bima oõm ip Judeuyũ e'aweroroap'a be―Deus eju kawẽnwẽnap'a be. Ig̃o'a beayũ o'g̃utaybinbin. ");
INSERT INTO myu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","— Idim cĩcã teku wuymutaybitbin! — io'e ip. — Moisés ekawẽn wuymutaybitbin'ukayũ buxim g̃u ite wuymutaybitbin. Wuyeajojoyũ'ũm'ũm a'õbi wuymutaybitbin ixeyũ ma. Jesus pit ja'õbi ma wuymutaybitbin — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","G̃ebuje ag̃okatkat oõm ig̃o'a be ibiõg̃buk kẽrẽat kukat. Ibiõg̃buk kẽrẽat cebe osunuy. O'jewãwã ya'õberen Jesus kay. ");
INSERT INTO myu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","— Jesus, Nazaréka bewiat, apẽn ẽn em ocewebe? — io'e. — Ocemuy'ũm tu ejot? — io'e. — Wetaybit abu ẽn iam. Ẽn Deus emumudot. Ikẽrẽat kug̃ g̃u ẽn―soat tag̃ eisu — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Imẽnpit Jesus ibiõg̃buk kẽrẽat o'g̃ukorẽm. — Ecemũg̃ cuy! — io'e. — Ejẽm cuy cebewi! — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","G̃ebuje ibiõg̃buk kẽrẽat ag̃okatkat o'g̃ukutukutu jĩjã. O'jewãwãwã ya'õberen. O'jẽm cebewi. ");
INSERT INTO myu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Imẽnpuye o'jojojo'iayũ o'jewetakaka jĩjã ip. — Ajo sute? — io'e ip. — Ya'õbuyxiat teku! — io'e ip. Ibiõg̃buk kẽrẽat kũyjobit ixe a'õ kay. Ixe itaybit ibiõg̃buk kẽrẽat mujẽm ãm wuyjuyũ jebit pewi! — io'e ip. — Kawẽn iisuan tu ite wuymutaybitbin? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Imẽneju soat Galiléia eipi dag̃ayũ Jesus awẽg̃ o'yawẽg̃coco ip. ");
INSERT INTO myu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","G̃ebuje Jesus o'jẽm ig̃o'a bewi. O'ju Simão duk'a kay, André duk'a kay. Pũg̃'a uk'a iwat osodop ip―Simão, André dak. O'ju Tiago eju, João eju dak. ");
INSERT INTO myu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simão daxijo ipa'i jĩjã opop. — Simão daxijo ipa'i jĩjã — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus o'ju cekay. O'subaixik. O'g̃u'ag̃obucẽg̃. Ipa'iat oi'ũm g̃ebuje bit. Xipat o'e. Ipa'i topibit ixan o'g̃ũm cebe ip―Jesusyũ be. ");
INSERT INTO myu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Katpuje ade iwãtaxipipiayũ o'tujowat Jesus kay ibo ka watwat. Axik kukukayũ dak o'tujowat cekay. ");
INSERT INTO myu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Soat ag̃oka watwat o'je'awero ip uk'a esũntabi be. ");
INSERT INTO myu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","G̃ebuje Jesus o'g̃u'ada'ada ip iwãtaxipipiayũ. Kiiiih. Ade osodop ip iwãtaxipipiayũ. Soat iwarururu osodop iwãtaxipi cexe ip. Ade axik o'g̃ujẽmjẽm cebewi ip. Itaybit axik osodop ip Jesus Deus emunaẽ iam. Jesus pit ixeyũ be o'g̃uwẽnat g̃u. — Abu õn iam cuy epeg̃ukũyjo g̃u ip — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","G̃ebuje Jesus o'kop kuyg̃u. Kaxi jẽm awap o'kop. O'jẽm uk'a bewi. O'ju uk'a'ũmat kay. Iboce o'jekawẽn Deus eju. ");
INSERT INTO myu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","G̃ebuje Simão o'jẽm uk'a bewi. O'ju Jesus kudadam, cewejuayũ dak. O'tobuxik ip. ");
INSERT INTO myu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","— Soat ijoceayũ ekudadam! — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","— Ijoce g̃u og̃uy — io'e Jesus pit. — G̃a'a juy wara'at ka watwat kay — io'e. — Kawẽn idipat muwẽn pin õn wara'at ka watwat pe. Ixeyũ be dak ojot imuwẽn ãm — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ibocewi soat kaka dag̃ oekuku ip Jesusyũ―Galiléia eipi dag̃. Deus ekawẽn muwẽnuwẽn oekuku ip Judeuyũ e'aweroroap'a be―Deus eju kawẽnwẽnap'a be. Axik mujẽmujẽm oekuku ip ibo eipi watwat pewi. ");
INSERT INTO myu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ag̃okatkat oajẽm Jesus kay ierepat. O'jẽg̃'aecõg̃cõg̃ cewap Jesus ya'õbuyxiat puye. — Omu'ada pin pima, iba'ore g̃u ewebe — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","G̃ebuje Jesus itabotaidabotbot o'e ierepat kay. O'jebaepacũg̃ cekay. O'g̃ucay. — Emu'ada pin õn — io'e. — Kuy õn emu'ada — io'e. ");
INSERT INTO myu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ierep tũibit o'je'ada g̃ebuje bit. Xipat o'e. ");
INSERT INTO myu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","— Eduk'a kay juy ecepit — io'e Jesus ya'õpurug̃ cebe. ");
INSERT INTO myu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","— E'adaap cuy eg̃uwẽn g̃u warara'acat pe — io'e. — Paĩ kay juy eju — io'e. — Ecewemubapuk cebe — io'e. — Xepxem cuy pukaso eg̃ũm paĩ be Moisés ekawẽn tag̃. Imẽn ece'e soat ijoceayũ itaybit am Jesus ierepat o'g̃u'ada iam. Ẽn pit eg̃uwẽn g̃u e'adaap. Paĩ ma juy g̃uwẽn e'adaap — io'e ierep topibit pe. ");
INSERT INTO myu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Imẽnpit ierep tũibit kũyjobit'ũm osunuy. Jesus a'õ kay g̃u osunuy. O'jẽm Jesus xewi. Je'adaap o'g̃uwẽnuwẽn soat pe jebureyũ be. Imẽnpuye soat kaka dag̃ o'yawẽg̃cu ce'adaap awẽg̃. Imẽnpuye Jesus pe ibapug̃ ceku ba'ore o'e ikabog̃atka be. Uk'a'ũmat tag̃ acã oeku. Ade ma'g̃u o'ju ip cekay soat kaka dag̃wi je'adaap ojuy. ");
INSERT INTO myu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xepxep kabia kap puje, Jesus o'jepit Cafarnaum ka kay. — Jesus jeduk'a be omuy — io'e ibo ka beayũ jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Imẽnpuye adeayũ o'je'awero ip Jesus duk'a etakobe. Ka'ũmg̃u topap o'e warara'acat pe iõm ãm uk'a be. Ade osodop ip uk'a be, uk'a esũg̃tabi xe dak. Jesus Deus ekawẽn ixeyũ mukũyjojom o'e. ");
INSERT INTO myu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","G̃ebuje ebadipdip ag̃okatkayũ oajẽm Jesus kay. Jebure dujuajẽm ojuy ip―ijebit e'ũat. ");
INSERT INTO myu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Imẽnpit tujuajẽm pa'ore o'e ip Jesus kay ade jĩjã Jesus akokoreren ip puye. Imẽnpuye ebadipdipayũ o'jeu uk'a abi jeje. Uk'a ip o'yabimutok Jesus ase. Ijebit e'ũat o'g̃ukop ip ixexecap pe. O'g̃ukop ip Jesus wap. ");
INSERT INTO myu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","— Teyũku itabut okay — io'e Jesus jewebe ma. G̃ebuje Jesus o'jekawẽn ijebit e'ũat pe. — Tapu, ikẽrẽat kuy oju'uk ewebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pũg̃pũg̃ Moisés ekawẽn imutaybitbin'ukayũ kaxikxik'i osodop ip i'go'a be. Jewag̃uydadam osodop ip. ");
INSERT INTO myu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","— Teku napa ma e'em! — io'e ip jewewebe. — “Deus co'i õn,” i napa ma teku e'em — io'e ip. — Abu-be ikẽrẽat uk put wuywebewi―Deus pe acã — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus itaybit o'e apẽn jewag̃uydadam ip o'e iam. — Apẽnpuye dak eyju imẽn jewag̃uydadam? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","— “Ikẽrẽat oju'uk ewebewi,” i kuy oce cebe — io'e. — Imẽnpit eyetabut g̃u ikẽrẽat'uk put owebe iap kay — io'e. — “E'ãy,” i oce ibima, “Ecexĩg̃xĩg̃,” i dak, “Exexecap cuy etujuxe eduk'a be,” i dak, eyetabut g̃u kuka epe'e okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","— Soat wag̃o õn — io'e. — Wa'õbi teku og̃u'ada. Imu'adaap co buje, “Ja'õbi ma teku o'g̃u'ada,” i epe'e — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","G̃ebuje Jesus o'jekawẽn ijebit e'ũat pe. — E'ãy — io'e cebe. — Exexecap cuy ejat — io'e. — Eju juy eduk'a be — io'e Jesus cebe. ");
INSERT INTO myu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","G̃ebuje ijebit e'ũ topibit o'ãy. Jexexecap o'jat. O'jẽm soat etabun. Imẽneju soat itabẽg̃bẽg̃ o'e ip ijojom. — Ajojojo g̃u buk imẽg̃at — io'e ip jewewebe — Ka'ũmg̃u xipacat Deus co'iat — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus waram o'jẽm. O'ju iodi kay―Galiléiadi kay. Adeayũ o'ju ikudadam. O'tobuxik ip. Ixeyũ mutaybitbin o'e. ");
INSERT INTO myu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kapkam pima Jesus Levi o'jojojo. Levi Alfeu ipot osunuy. Iecug̃ap edinheiro bubu'ukat osunuy. Xik'i osunuy dinheiro bubuap'a be. — Ejot. Oweju ejeku — Jesus o'e cebe. Levi o'jẽm dinheiro bubuap'a bewi. O'ju Jesus eju. ");
INSERT INTO myu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","G̃ebuje Jesus o'ju Levi duk'a kay. O'jekõn ceweju. Ade iecug̃ap edinheiro bubu'ukayũ awerom osodop ip ig̃o'a be. Jekõnkõn ip o'e Jesus eju, ceweju etaybitbinayũ eju dak, ade ikẽrẽat mug̃ẽg̃ẽ'ukayũ dak. Ade jĩjã osodop ip Jesus eju jekuku'ukayũ. ");
INSERT INTO myu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pũg̃pũg̃ Fariseuyũ'in ixeyũ o'jojojo―Moisés ekawẽn imutaybitbin'ukayũ. Ikẽrẽan e'e'ukayũ eju Jesus jekõnkõn o'e iap o'jojojo ip―iecug̃ap edinheiro bubu'ukayũ eju iap tak. — Apẽnpuye ekariwa jekõnkõn ikẽrẽat mug̃ẽg̃ẽ'ukayũ eju, iecug̃ap edinheiro bubu'ukayũ eju dak? — io'e ip Jesus eju etaybitbinayũ be. Imẽn xipat g̃u — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iboap co buje, Jesus o'jekawẽn ceweju ip. — Iwãtaxipi'ũmayũ bit wuyanũg̃tata'ukat kay je'ju g̃u―iwãtaxipipiayũ acã — io'e. — Imẽnpuxim õn tak jewexe xipacayũ nomuwã ãm g̃u ojot―xipat'ũmayũ nomuwã ãm acã. Ikẽrẽat uk am ixeyũ bewi ojot — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Koap pima João Batista eju etaybitbinayũ jekpiwan ma jewemureren ip osodop Deus eju kawẽn ãm, Fariseuyũ dak. Imẽnpuye ade o'ju Jesus kay. — João eju etaybitbinayũ jekpiwan ma jewemureren Deus eju kawẽn ãm, Fariseuyũ eju etaybitbinayũ dak — io'e ip. — Eweju etaybitbinayũ bit jekõnkõn. Apẽnpuye dak? — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","G̃ebuje Jesus o'jekawẽn ceweju ip. — Oweju etaybitbinayũ jekõnkõn, õn ceweju ip puye — io'e. — Tomuwã'ibiyũ cucum pima jewebumũnap epeta kay, jekõnkõn cĩcã ip. Iwadip cexe ip pima, jekõnkõn cĩcã ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","— G̃uyjom pit iwadip ju'uk ip ceparakpewi — io'e. — I'uk puje, jekõn g̃u ip — io'e. — Imẽnpuxim, õn ixeyũ eju'ũm pima, oweju etaybitbinayũ jekpiwan ma jewemuren ip Deus eju jekawẽn ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","— Pag̃o iisuat ajoinũm g̃u toti iorokat eju―iwekwekat eju imuwaket am — io'e Jesus. — Pag̃o iisuat inũm puje pag̃o iorokat eju, big̃ ma kuka o'jewekwek. Iwekat big̃ ma kuka o'e yobog̃ — Jesus o'e ma'g̃uto. ");
INSERT INTO myu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","— Uva'abidi tiisuati atimuõm g̃u ixee mug̃ẽg̃ẽ'a be―timũn'a be―yaokokat'a be — io'e. — Yaokokat'a be tiisuati muõm puje, kuka o'jeaepaw. Uva'abidi kuka o'jediepuy. Uva'abidi mũn'a dak kuka o'jeaewenõmnõm. Imẽnpuye tiisuati atimuõm timũn'a be yaisuat'a be — io'e Jesus. Iboam e'em pima, “Wekawẽn pag̃o iisuat puxim, uva'abidi tiisuati buxim tak” i'e ojuy osunuy. ");
INSERT INTO myu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","G̃ebuje Jesus kapkam o'e trigodip tag̃ Sábado kabia be―jebodoydoyap kabia be. Kapkam o'e jeweju etaybitbinayũ eju. Kapkam pima ceweju etaybitbinayũ o'tadot'uk, jere buye. ");
INSERT INTO myu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Imẽnpuye Fariseuyũ o'jekawẽn Jesus eju. — Ak'i juy ece! — io'e ip. — Eweju etaybitbinayũ kapikpig̃ Sábado kabia be! Trigo dadot uk'ug̃ ip! — io'e ip. — Cũg̃ g̃u e'em ip! — io'e ip. — Imẽn e'em Moisés ekawẽntup: jebodoydoyap kabia be juy epeyekapik g̃u, i — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","G̃ebuje Jesus o'jede Fariseuyũ be. — Epetupcoco g̃u du apẽn Davi o'e'e iaptup―Deus ekawẽntup? — io'e cebe ip. — Ire bima, Davi oõm Deus eju kawẽnwẽnap'a be jebureyũ eju. ");
INSERT INTO myu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ixe kabia be Abiatar paĩyũ kukukat osunuy. Pão'a o'ya'o Daviyũ―ig̃o beat'a―Deus etabixe o'yamõg̃ ipi iat'a. Moisés ekawẽntup e'em: Deus etabixeat'a ya'opi, i — io'e. — Paĩyũ be acã ya'opi g̃u — i'e'em Deus ekawẽntup — io'e. — Imẽnpit Davi o'ya'o, paĩ g̃u ma'g̃u. O'yaũm jebureyũ be dak — io'e. — Deus pit “Ekẽrẽ oxe,” io'e g̃u cebe ya'o buje. Apẽnpuye dak eyju e'em owebe “Eweju etaybitbin'ukayũ cũg̃ g̃u e'em,” i? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","— Te'e g̃u Deus o'e: Pũg̃ kabia be juy epeyekapik g̃u, i. Imẽn ixe o'e ijodiat ebodoy am — io'e. ");
INSERT INTO myu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","— Soat wag̃o õn. “Epeyekapik cuy,” i õn e'em pima Sábado kabia be dak, cedag̃ kuka o'e Deus xe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sábado kabia be Jesus oõm ma'g̃uto Judeuyũ e'aweroroap'a be―Deus eju kawẽnwẽnap'a be. Ig̃o'a be ag̃okatkat osunuy. Pũg̃bũnũ'a o'subũnũ'anũy ibũnũ'akẽrẽ. ");
INSERT INTO myu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseuyũ o'jeak cĩcã Jesus kay Jesus ibũnũ'a kẽrẽat g̃u'ada paxi jebodoydoyap kabia be iap com. Jesus muymuy ojuy ip. “Moisés ekawẽn tag̃ g̃u ẽn jekukum” i'e ojuy ip Jesus pe. “Jesus kapikpig̃ jebodoydoyap kabia be―Sábado kabia be” i'e ojuy ip Jesus muymuy am. ");
INSERT INTO myu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","— Ejot cuy ijoce — Jesus o'e ibũnũ'a kẽrẽat pe. ");
INSERT INTO myu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesus o'jekawẽn Fariseuyũ eju g̃ebuje bit. — Wuyeaypapayũ'ũm'ũm xe cedag̃ tu osunuy wuywebe xipacat mug̃ẽ ãm jebodoydoyap kabia be? — io'e cebe ip. — Cũg̃ g̃u xe'e wuywebe ikẽrẽat mug̃ẽ ãm? Cedag̃ tu warara'acat aoka am? Cedag̃ g̃u xe'e warara'acat daxijo am Sábado kabia be? — io'e. Mũg̃. O'jemũg̃ ip. Cede ba'ore ip o'e. ");
INSERT INTO myu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","G̃ebuje Jesus o'jeak cekay ip. Itakoma o'e cekay ip, Fariseuyũ itabotaidabotbot'ũm ibũnũ'a kẽrẽat kay buye. Ig̃uycũg̃ tak o'e ibu'u ip jemutaybin jekawẽn puye. — Paya'i ece ebu! — io'e ibũnũ'a kẽrẽat pe. G̃ebuje o'jewebumupaya. Ibũnũ'adip o'e. ");
INSERT INTO myu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Imẽnpuye Fariseuyũ o'jẽm yabewi. O'jewede ip Jesus xewi. O'je'awero ip Herodes ebekitkit eju―Judeuyũ kukukat ebekitkit eju. O'jewawẽ ip Jesus aoka am kapikpig̃ Sábado kabia be buye. Jesus o'ju iodi wãbu be jeweju etaybitbin'ukayũ eju―Galiléiadi wãbu be. ");
INSERT INTO myu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","G̃ebuje ade o'ju ip Jesus kay. Soat ka dag̃wi o'ju ip: Galiléia eipi dag̃wi, Judéia eipi dag̃wi dak, ");
INSERT INTO myu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalém ka bewi dak, Iduméia eipi dag̃wi dak, Jordãodi wĩnãbu wi dak, Tiro ka tẽg̃atka bewi dak, Sidom ka tẽg̃atka bewi dak. Jesus idipat o'g̃ug̃ẽ iam o'jekũyjo ip. Imẽnpuye ade jĩjã ma o'ju ip cekay. Kiiiih. ");
INSERT INTO myu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesus o'jekawẽn jeweju etaybitbin'ukayũ eju. — Kobe epeg̃udim owebeam adeayũ be omukug̃ap puxim — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kuy bima Jesus ade ma o'g̃u'ada'ada. Imẽnpuye soat iwãtaxipipiayũ ajẽm ojuy ip osodop imucay ojuy. — Omu'ada paxi ixe? — io'e ip jewebe ma. ");
INSERT INTO myu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jesus dobuxik puje ip ibiõg̃buk kẽrẽayũ kukukayũ o'jẽg̃'aecõg̃cõg̃ cewap “Teku ya'õbuyxiat,” i'e'em jewebe ma buye. O'jewãwã ip ya'õberen: — Ẽn Deus ipot — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","— Epeg̃uwẽn g̃u juy warara'acat pe: “Teku Deus ipot” i — Jesus pit o'e ya'õpurug̃ cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","G̃ebuje Jesus o'jeu co'a dag̃. Jemukaypinayũ o'taẽ jeweju jeku am. Oajẽm ip cexe. ");
INSERT INTO myu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","12 beayũ o'taẽ. — Soat em cuy epeku oweju — io'e cebe ip. — Deus wuydaxijojom iap ekawẽn cuy epeg̃uwẽnuwẽn soat ka dag̃ — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","— Wa'õbacaap og̃ũm eywebe ibiõg̃buk kẽrẽat mujẽm ãm ikukukayũ bewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ibũrũ ma ibutet osodop ip―taẽ'ibiyũ butet: Simão, i, Tiago i, João i ");
INSERT INTO myu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","19","André i, Filipe i, Bartolomeu i, Mateus i, Tomé i, wara'at Tiago i, Tadeu i, Simão i, Judas iscariotes i. Ibũrũ ma ibutet ip. Jesus wara'at o'subutetmõg̃ Simão buten. Wara'at ibutet Pedro i osunuy. João Tiago kitpit osunuy. Jesus wara'at o'subutetmõg̃ João buten―Tiago buten tak. Boanerges i wara'at ibutet ip osunuy. Boanerges ibaca ip xiririkiap puxim iape. Zebedeu ipotpoyũ ip osodop xepxep. Wara'at Tiago Alfeu ipot osunuy. Simão jeipi kay jĩjãat osunuy. Judas Iscariotes g̃uyjom Jesus o'g̃ũm cekay itakomaayũ be yaoka am. Ibũrũ ma osodop ip 12 beayũ―Jesus emumujuyũ. ");
INSERT INTO myu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ibocewi Jesus o'ju jebure duk'a be. Ade ma'g̃uto oajẽm ip Jesus kay. Cekõn pa'ore o'e cebuxim ip, ceweju etaybitbinayũ dak. ");
INSERT INTO myu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ibadipyũ iboam jekũyjo buje, o'ju ip Jesus dujupit ojuy jeduk'a be. Tũybe Jesus yakpidapin iãn o'e ip jekõnkõn'ũm puye. ");
INSERT INTO myu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisés ekawẽn imutaybitbin'ukayũ oajẽm cekay―Jerusalém ka bewiayũ. Jesus ip o'jomuymuy adeayũ be. — Jesus jekukum ibiõg̃buk kẽrẽayũ kukukat a'õbi―Belzebu a'õbi―Satanás a'õbi — i napa ma o'e ip Jesus muymuy. — Ixe ja'õbacaap ũmũm Jesus pe ibiõg̃buk kẽrẽat mujẽm ãm adeayũ bewi — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Imẽnpuye Jesus jemuymuy ojuyayũ o'tomuwã jewekay―Moisés ekawẽn imutaybitbin'ukayũ. O'jekawẽn ceweju ip. “Napa ma eyju e'em” i'e ojuy. Wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. — Satanás a'õbi g̃u õn imujẽmujẽm — io'e. — Satanás owebe ibiõg̃buk kẽrẽat mujẽmujẽmãn pima, jebekitkit kuka juk ixe o'g̃ujẽm! Imẽnpit Satanás a'õbi g̃u õn imujẽmujẽm — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","— Pũg̃ ka kukat jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","— Pũg̃ti watwat kukat jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","— Imẽnpuxim Satanás jebekitkit mujẽm puje, abu kuka o'e ya'õ kay? Ka'ũma ma! Imẽneju Satanás ja'õbacaap ũmũm g̃u owebe ibiõg̃buk kẽrẽat mujẽm ãm―jebekitkit mujẽm ãm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","— Wuyõm pa'ore wuykay isapka'oreat tuk'a be ibubut pu am. Imukirig̃ acã koam — io'e. — Imukirik puje bit, wuyõm put soat pu am―uk'a beat pu am — io'e. — Imẽnpuxim Satanás a'õbacaap mu'ũm'ũm pima, iba'ore kuka o'e wuywebe Satanás ebekitkit a'õbacaap mu'ũm ãm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","— Icẽmãn õn e'em eywebe — io'e Jesus. — Wuywebe ikẽrẽat mug̃ẽ buje, Deus iboap ju'uk wuywebewi―ikẽrẽat ju'uk — io'e. — Wuywebe Deus muymuy buje dak, Deus iboap ju'uk wuywebewi―ikẽrẽat ju'uk — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","— Wuywebe Deus biõg̃buk muymuy buje bit, Deus iboap ju'uk g̃u wuywebewi. Iboap i'uk pa'ore Deus pe. Iboap kug̃ acesop soat em―ikẽrẽat kug̃, ibiõg̃buk muymuyap kug̃ — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","— Ẽn ibiõg̃buk kẽrẽat a'õbi jekukum — i juk o'e ip Jesus pe. Imẽnpuye Jesus imẽn o'ya'õbu ip imukũyjojom ip. ");
INSERT INTO myu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ixi o'ju Jesus kay, ikitpitpit tak. Akiju osodop ip. — Jesus etomuwã — io'e ip kakijuayũ be. — Ceweju ocekawẽn pin — io'e ip. Kaxikxik'i osodop ip Jesus akokoreren akijuacat. ");
INSERT INTO myu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","— Exi akiju omuy, ekitpitpit tak — io'e ip Jesus pe. — Eweju cekawẽn pin ip — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","— Icẽmãn ig̃o oxiat. Boyũku okitpitpicat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesus o'jeak jexeayũ kay. O'jekawẽn ceweju ip. — Warara'acayũ bit oxi jo'i oxe, okitpitpit co'i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","— Deus bikuyap tag̃ jekuku'ukayũ okitpitpit co'i oxe, oĩxĩt co'i dak ip, oxi jo'i dak ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus waram adeayũ o'g̃utaybin iodi wãbu be. Ade jĩjã o'je'awero ip cexe. Imẽnpuye Jesus oõm kobe be. Oabik kobe bitakobu jeje iwãbu tẽg̃. Adeayũ bit kapurũg̃ pe osodop ip ya'ĩjojom. ");
INSERT INTO myu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wuymutaybitbinap ekawẽn o'g̃uwẽn Jesus. Ade o'g̃utaybin ip. ");
INSERT INTO myu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","— Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e cebe ip. — Ag̃okatkat o'ju jekat pe jekadai damuduudu am. ");
INSERT INTO myu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tamududum pima xepxepta o'ta'at ipi ju e bitako dag̃ — io'e. — Wasũyũ oajẽm. O'ta'o'o ip taduduata―cekadaida―e bitako dag̃ata — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","— Ibocewi wara'ata o'ta'at karatũg̃'a paraktag̃. Ade g̃u ka'wi o'e iboce. Ierũn ma o'e ka'wi. Dao ma o'tanõkap ka'wi ierũn puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","— Imẽnpit kaxiepi bima kaxie kadai o'g̃ukaraw. O'g̃uy'ũ. Oe'ũ tãbuju ba'ore buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","— Wara'ata o'ta'at widaoho parakpe. Yaypan pima widaoho kadai o'g̃u'ũm. Oe'ũ. O'jewa'ada g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","— Wara'ata bit o'ta'at katõ be. O'tanõkap. Xipan o'yaypan. Ta'ade o'e. Pũg̃pũg̃ kadai be ta'adesũ o'e―30 be o'e ta―katõ peat. Wara'at kadai be ta'ade o'e―60 be o'e ta. Wara'at kadai be ta'ade jĩjã o'e―100 be o'e ta — io'e. Jesus imẽn wuymutaybitbinap ekawẽn o'g̃uwẽn. ");
INSERT INTO myu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","— Wekawẽn eyetaybit pin pima, eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Adeayũ epit puje, pũg̃pũg̃ o'ya'ĩjojo'iayũ oajẽm Jesus kay. 12 beayũ eju oajẽm ip. — Iba'arẽm ekawẽn ocexe — io'e ip cebe. — Apẽn ocemutaybin ojuy eg̃uy kadaida mududuap ekawẽn muwẽnuwẽn? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","— Kawẽn ibapukan õn eymutaybitbin — io'e. — Ibapug̃ ma apẽn Deus soat ipi dag̃ayũ kukukan je'e iap muwẽnuwẽn õn eywebe — io'e. — Kuy bima iboam o'g̃utaybin g̃u. Warara'acayũ mutaybitbin pit õn iba'arẽmãn, wa'õ kaykũy ip puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","— Iba'arẽmãn õn ixeyũ mutaybitbin. Ya'ĩjojom ip. Imẽnpit itaybit g̃u ip. Jekũyjojom ip. Imẽnpit wekawẽn pa'arẽm cexe ip. Itaybit pima bit kuka juk ig̃uycũg̃ o'e ip ikẽrẽat kug̃ puye. Ikẽrẽat tak kuka juk o'jepere ip. Ikẽrẽat epere buje ip kuka juk Deus ikẽrẽat o'ju'uk ixeyũ bewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","— Kadai damuduuduap ekawẽn iba'arẽm eyxe. Apẽntak eyetaybit epe'e owebe wara'at muwẽn puje wuymutaybitbinap ekawẽn muwẽn puje? Wara'at muwẽn puje dak, wekawẽn pa'arẽm je'e eyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","— Apẽg̃ape ibo wekawẽn iam õn jeymutaybin. Kadaida muduuduap Deus ekawẽn muwẽnuwẽnap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","— Deus ekawẽn coco'ukayũ kadaida buxim — io'e. — Pũg̃pũg̃ cekawẽn coco'ukayũ e bitako dag̃ata buxim — io'e. — Deus ekawẽn co isu, Satanás ajẽmjẽm cekay ip — io'e. — Yag̃uyba'ũm'ũm ip cekawẽn kay―Deus ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","— Warara'acayũ karatũg̃'a paraktag̃ata buxim―Deus ekawẽn coco'ukayũ — io'e Jesus. — Koap icokcok e'em ip Deus ekawẽn co am. ");
INSERT INTO myu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kadai tãbube'ũmat puxim Deus ekawẽn badi g̃u õmõm cebe ip. Ibureyũ e'em: “Teyũku Deus ekawẽn kay,” i, iwaywayway am. Ibureyũ itakoma cekay ip. Ipiat supi'ajoat cebe ip. Imẽneju ibu'u ip jetabut am Deus kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","— Warara'acayũ widaoho parak tag̃ata buxim Deus ekawẽn coco'ukayũ. Deus ekawẽn cocom ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","— Imẽnpit soat em g̃ebum ip jemukaypinput kay. Tũybe ocokcok cĩcã oce dinheiro kug̃ pima iãn e'em ip. Itabikuku ip soat kay jebubun. Deus ekawẽn kay bit ip yopĩt ma itabut, soat kay itabikuku jebubun puye. Deus ekawẽn muwẽnuwẽn g̃u ip warara'acat pe jebureyũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","— Warara'acayũ bit katõ dag̃ata buxim Deus ekawẽn coco'ukayũ — io'e. — Cekawẽn co buje, cekawẽn kay jĩjã ip. Idipat mujurũg̃rũg̃ ip soat peam. Kadai'ip puxim ixeyũ―ya'a'eat'ip puxim. 30 be o'e takug̃'iat'ip puxim ip, 60 be o'e takug̃'iat'ip puxim tak, 100 be o'e takug̃'iat'ip puxim tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus wara'at kawẽn o'g̃uwẽn jeweju etaybitbinayũ be―12 beayũ be dak―wuymutaybitbinap ekawẽn. — Lamparina musop puje, ico diotpe g̃u ajomuy — io'e. — Wuyxexecap tiotpe g̃u dak ajomuy. Um ma ajomuy kabia i'e am wuykay―soat ijo but am — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","— Soat wuyxe iba'arẽmat ibapuk je'e. G̃asũ ade ma wuyetaybit'ũmat. G̃uyjom pit wuyetaybin ace'e soan ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","— Wekawẽn co pin pima, eya'õpicũg̃cũg̃ cuy — io'e. Imẽn o'g̃uwẽn “Wekawẽn eyetaybin puje, warara'acat pe juy epeg̃uwẽn dao ma eyag̃uyba'ũmap puxim” i'e ojuy. ");
INSERT INTO myu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","— Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. — Xipan'ũm ya'ĩjo buje, yopĩt ma juy eyetaybin. Xipan ya'ĩjo buje bit, yobog̃ cuy eyetaybin — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","— Wara'an eyetaybit pin pima, wara'an ma eyetaybit epesop. Ya'ĩjom eybu'u buje bit, kuy juk epeya'ĩjojoiap kay jeyag̃uyba'ũm — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus waram wuymutaybitbinap ekawẽn o'g̃uwẽn. — Deus soat ipi dag̃acat kukukan iap kadai aypapanap puxim — io'e. — Ag̃okatkat o'taida jekat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","— Taida buje, soat exima xexen ma. Kabia isum kopkom. Nõjẽmjẽm. Aypapan. Ag̃okatkat pit itaybit g̃u apẽn aypapan iam. ");
INSERT INTO myu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kadai jekpiwan ma jewa'adadam. Koap dupcẽmcẽm. Taipuk cẽmcẽm g̃uyjom. Kanomũm dajẽmjẽm taipuk tag̃―tajakata — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","— Tarum'isum kadai bubum kat iwat kadai bubuap kaxi oajẽm puye — io'e. — Imẽnpuxim eya'õbi g̃u warara'acayũ itabut je'e Deus kay―Deus a'õbi acã — io'e. Jesus imẽn wuymutaybitbinap ekawẽn o'g̃uwẽn. ");
INSERT INTO myu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus waram o'jekawẽn. — Deus ade jĩjãayũ kukukan je'e — io'e. — Ajo-buxim xe'e je'e? Eya'õpicũg̃cũg̃ cuy epesop iboap ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","— Deus soat ipi dag̃acat kukukan iap mostardada buxim―e da jo'iat puxim. Ipi be taida buje, ta'ĩt ma mostardada. Warara'ata bodi ma ta'ĩt ma. Aypapan cĩcã taida buje bit. ");
INSERT INTO myu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wara'at kadai bodi ma aypapan e'em. Tãkubog̃ e'em. Wasũ jedopi mõg̃mõg̃ tãku jeje — io'e. — Imẽnpuxim g̃asũ Deus pũg̃pũg̃ayũ kukukat. G̃uyjom pit adeayũ kukukan je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus ibo ekawẽn puximat o'g̃uwẽnuwẽn adeayũ be. Deus soat kukukan je'e iap ekawẽn o'g̃uwẽnuwẽn cebe ip. Imẽnpuye itaybit put ip. ");
INSERT INTO myu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Adeayũ mutaybitbin pima wuymutaybitbinap ekawẽn acã o'g̃uwẽn―kawẽn iba'arẽmat acã. Jeweju etaybitbinayũ mutaybitbin pima bit, ibapug̃ ma o'g̃utaybin ip. Kawẽn iba'arẽmat g̃u o'g̃uwẽn cebe ip―ibapukat ma. ");
INSERT INTO myu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ixe kabia kabiog̃kabiog̃'i bima, Jesus o'jekawẽn jeweju etaybitbinay'u be. — G̃a'a iodi wĩnãbu aju — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ceweju etaybitbinayũ o'jewemuwẽn ip adeayũ be. Jesus kuy kobe be osunuy. Jeweju etaybitbinayũ o'tujowat jeweju. Warara'acayũ dak o'timudek jekobe dag̃ ma ip. ");
INSERT INTO myu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","G̃ebuje kabidoxixi oajẽm cekobe kay. O'subidoajẽm cekay ip―Jesus kay, jewejuayũ kay dak. Kobe be diõmõm o'e tipodoyat. Kobedi tibog̃ o'e. Kobe munopapũn ojuy o'e idibim. ");
INSERT INTO myu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Imẽnpit Jesus ixet osodop kobe ukpu be. Ixet jadipi jeje. G̃ebuje ceweju etaybitbinayũ Jesus o'g̃uwurũg̃. — Ocemutaybitbin'ukat! Ak'adit ma du ẽn ocekay? — io'e ip. — Je'ũm wuyju! — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus o'ãy. G̃ebuje Jesus kabidoxixi o'g̃ukorẽm. — Ebidopon! — io'e kabidoxixi be. — Edipon! — io'e iodi be. Kabido dao ma o'subido'ũm. Tipo o'e iodi. ");
INSERT INTO myu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Imẽneju Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Apẽnpuye dak eyparara? Eyetabut g̃u du Deus kay? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iparara jĩjã ip o'e. — Abu dak sute? — io'e ip jewewebe. — Cekawẽn acã kabido o'subidomu'ũm! Dao ma o'timupon iodi! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus wĩnãbu oajẽm jeweju etaybitbinayũ eju. Oajẽm ip Gerasa eipi be. ");
INSERT INTO myu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kobe bewi Jesus cẽm puje, ag̃okatkat osodot ce'ũ'ũayũ mõg̃mõg̃ap pewi. Ibiõg̃buk kẽrẽat kukat osunuy. ");
INSERT INTO myu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ixe ukã be g̃u osunuy―ce'ũ'ũayũ mõg̃mõg̃ap pe acã, ibiõg̃buk kẽrẽat kug̃ puye. ");
INSERT INTO myu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ade em Gerasa eipi watwat cuk adi ibiõg̃buk kẽrẽat kug̃at o'taomũnmũn ip. Correntebum cuk adi o'taomũnmũn ip, cabobum tak. G̃asũ bit taomũn pa'ore ip osodop. Iba'ore osodop ip correntebum tak. Ade em ma juk adi o'taomũnmũn ip correntebum, cabobum tak. Imẽnpit ixe ag̃okatkat correntebu o'subumuwekapkap. Ixe cabobu o'subudakatkat. Ixe muwag̃õn pa'ore o'e soat pe. ");
INSERT INTO myu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kabia bun, ixima bun tak e'ũ'ũayũ mõg̃mõg̃ap tag̃ oekuku ibiõg̃buk kẽrẽat kug̃at. Co'a dag̃ tak oekuku. Soat em jewãwãwãm oekuku. Jewemuwerikwerig̃ wita'am oekuku. Jewemudadaibotbon oekuku. ");
INSERT INTO myu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wũywi ma Jesus co buje, ibiõg̃buk kẽrẽat kug̃at o'jedau Jesus kay. O'jẽg̃'aecõg̃cõg̃ Jesus wap ya'õbuyxi cexe buye. ");
INSERT INTO myu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","— Ibiõg̃buk kẽrẽat, ejẽm cuy ag̃okatkat pewi — Jesus o'e. Ibiõg̃buk kẽrẽat kug̃at o'jewãwã ya'õberen. — Jesus, apẽn ẽn em owebe? — io'e. — Ẽn Deus ipot―soat podi ma ya'õbacaat ipot! — io'e. — Ipiat'ajoan g̃u juy ẽn owebe, Deus etabutpe wuyju buye — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","10","— Apẽn ebutet? — Jesus o'e. — Obutet Ade i, ade oceju buye — io'e. — Ijop ka bewi g̃u juy ibiõg̃buk kẽrẽat eg̃ujẽm — io'e ag̃okatkat Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ade jĩjã dajebaroyũ wurũrũrũg̃ osodop ip iboce co'a dag̃. ");
INSERT INTO myu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","— Dajebaroyũ be juy eg̃uõm — io'e. — Ãg̃ ocemuõm cebe ip — ag̃okatkat o'e. ");
INSERT INTO myu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","— Ha'a — io'e. — Epeõm cuy cebe ip — Jesus o'e. Ibocewi ibiõg̃buk kẽrẽayũ o'jẽm ag̃okatkat pewi. Oõm ip dajebaroyũ be. Ade jĩjã osodop ip dajebaroyũ. Kiiiih. 2000 be aco'i osodop ip. Daudaum o'jenapõn ip co'a pẽnpẽn tag̃. O'kop ip iodi be. Oakõm ip. Jeabokabog̃ oap ip iodi be. Pog̃. Oe'ũ'ũ ip. ");
INSERT INTO myu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Imẽneju dajebaroyũ kukukayũ owatwat ip. — Jesus ibiõg̃buk kẽrẽayũ o'g̃uõm dajebaroyũ be — io'e ip warara'acayũ be. — Oap ip ade — io'e ip. O'g̃uwẽn ip ikabog̃atka watwat pe, kog̃ũnpi watwat pe dak. Ade o'ju ip apẽn o'jebapuk iap com. ");
INSERT INTO myu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","O'ju ip Jesus kay. Ibiõg̃buk kẽrẽat kug̃ tũibit o'jojojo ip. G̃asũ bit tadaibot g̃u o'e. Xik'i osunuy. Totite o'e g̃asũ bit. Yag̃uysat o'e g̃asũ bit. Imẽneju itabẽg̃bẽg̃ ip o'e ijojom. ");
INSERT INTO myu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ibocewi o'jojojo'iayũ apẽn o'jebapuk iap o'g̃uwẽn oajẽm'iayũ be. — Jesus ibiõg̃buk kẽrẽat o'g̃ujẽm ag̃okatkat pewi — io'e ip. — O'g̃uõm dajebaroyũ be — io'e ip. — Oakõm ip iodi be. O'jeabokabok ip. Oap ip — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Imẽneju: — Ejẽm cuy oceka bewi — io'e ip Jesus pe Gerasa eipi watwat. ");
INSERT INTO myu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Imẽnpuye Jesus oõm kobe be jejẽm ãm. Kobe be iõm puje ibiõg̃buk kẽrẽat kug̃ tũibit o'ju Jesus kay. — Eweju õn tak cum — io'e. — Exe ma onuy pin — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","— Ap — io'e Jesus pit. — Oweju g̃u ejot. Eduk'a be juy eju, ebureyũ kay — io'e Jesus cebe. — “Kariwa ibiõg̃buk kẽrẽat o'g̃ujẽm owebewi,” i juy ece cebe ip — Jesus o'e. — “Kariwa juk xipan okuk,” i juy ece cebe ip — Jesus o'e. — Ha'a — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","G̃ebuje o'ju jeka kay. 10 beatka dag̃ oekuku: — Jesus ibiõg̃buk kẽrẽat o'g̃ujẽm owebewi — i'e'em soat pe. Iboam jekũyjo buje: — Ajo iba'ore cekay―Jesus kay? — io'e jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","G̃ebujep Jesus iodi o'timudek ma'g̃uto kobe dag̃. Timudek puje, ade jĩjã ip o'ju topabe ka'oririt pe. Kiiiih. ");
INSERT INTO myu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judeuyũ e'aweroroap'a kukukat o'ju Jesus kay―Deus eju kawẽnwẽnap'a kukukat. Ibutet Jairo i osunuy. Taxitxet osunuy. Taxit 12 koato osunuy. Jesus dopabijuk puje, o'jẽg̃'aecõg̃cõg̃ cewap, Jesus ya'õbuyxi cexe buye. ");
INSERT INTO myu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","— Tapu, odaxit oe'ũ pin — io'e. — Ejot cuy oduk'a be — io'e. — Ebu juy esubumõg̃ cebe imu'ada am. Esubumõg̃ cuy cebe ce'ũap puxim — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Imẽnpuye Jesus o'ju ceweju―Jairo eju. Ibocewi ade ip o'ju Jesus nomuju. Icẽg̃sũg̃ ip o'e ade jĩjã buye. ");
INSERT INTO myu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iboce ayacat tak osunuy. Ade koato ma toybucukbucug̃ g̃u osunuy―12 koato ma. ");
INSERT INTO myu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ade wuyanũg̃tata'ukayũ ixe ayacat anũg̃tata'uk ip osodop. Imẽnpit big̃ ma xipat'ũm cĩcã o'e. Soat jedinheiro o'g̃u'ũm janũg̃tataapteim. O'jexere g̃u. Big̃ ma xipat'ũm cĩcã o'e. ");
INSERT INTO myu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ixe ayacat Jesus iwãtaxipipi mu'ada'adaap awẽg̃ o'yawẽg̃coco. — Jesus esay mucay buje, oce'ada — ayacat o'e jewebe ma. G̃ebuje o'ju Jesus tẽg̃ adeayũ parakpe―aweromayũ parakpe. ");
INSERT INTO myu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jesus esay o'g̃ucay warara'acat eta'ũmpi. Cesay mucay'isum ma o'toybucuk. Xipat o'e g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wa'õbacaan aco'i og̃u'ada iam itaybit o'e Jesus pit. O'jekorepẽn adeayũ parakpe g̃ebuje bit. — Abu wesay o'g̃ucay? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","— Tã! — io'e ceweju etaybitbinayũ. — Adeayũ wuymukug̃ukug̃ iap cocom g̃u du ẽn? — io'e ip. — Apẽnpuye ẽn e'em “Abu wesay o'g̃ucay?” i? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Imẽnpit Jesus o'jeakak soat kay. Abu wesay o'g̃ucay iat kudadam o'jeakak. ");
INSERT INTO myu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ayacat itaybit o'e Jesus omu'ada iam. Imẽnpit iparara o'e Jesus itakoma je'e okay iap puxixim. Ikarabakbak tak o'e jeparara pibun. O'jẽg̃'aecõg̃cõg̃ Jesus wap. — Õn ma esay og̃ucay — io'e cebe. — Ẽn cuk omu'ada — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Imẽnpuye: — Tũ'ũ, kuy ece'ada etabut okay buye — io'e Jesus. — Ecepit cuy eduk'a be — io'e. — Ecokcog̃ cuy eg̃uy — io'e. — Kuy ece'ada. Xipat ecesũy g̃asũ bit — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus puk kawẽnwẽn ma ayacat eju bima, Jairo duk'a bewiayũ oajẽm cekay―Jairo kay. — Ig̃uje, edaxit'ũm kuy oe'ũ — io'e ip. — Wuymutaybitbin'ukat eg̃uwa'ũm g̃u g̃asũ bit — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Imẽnpit Jesus ak'adit ma o'e oe'ũ iap awẽg̃ kay. — Eg̃uycũg̃ g̃u juy eg̃uy — Jesus o'e Jairo be. — Etabun pit cuy eg̃uy okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","G̃ebuje Jesus ebapũg̃ayũ acã o'tujowat jeweju. Pedro o'tujowat jeweju, Tiago dak, João dak. João Tiago kitpit osunuy. Ibũrũ ma o'tujowat jeweju. ");
INSERT INTO myu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","O'ju ip Deus eju kawẽnwẽnap'a kukukat tuk'a kay―Jairo duk'a kay. Ade osodop ip tuk'a be. Wawa ip osodop. Jewãwãwãm ya'õberen ip osodop yaypan'isuat'ũm cocom. ");
INSERT INTO myu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Uk'a be jeõm puje, Jesus o'jekawẽn ceweju ip. — Apẽnpuye eyju wawa? Eya'õkarey jĩjã oxe! — io'e cebe ip. — Yaypan'isuat ce'ũ g̃u―ixet ã! — Jesus o'e wawaayũ be. Jesus itaybit o'e yaypan'isuat'ũm oe'ũ iam. Inaka waram imutain. Imẽnpuye: — Ixet ã — io'e. ");
INSERT INTO myu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wawaayũ itaybit o'e yaypan'isuat'ũm oe'ũ iam. Imẽnpuye Jesus o'jowayway ip. Jesus soat ip o'g̃ujẽm uk'a bewi. Ibocewi Jesus yaypan'isuat'ũm ebay o'tujowat jeweju, ixi dak, ebapũg̃ayũ dak―jeweju etaybitbin'ukayũ. O'ju ip ce'ũat kay. Oajẽm. ");
INSERT INTO myu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ce'ũat o'subaixik. — Talitá cumi — Jesus o'e ja'õm cebe. (Talitá cumi “Tu'ũ, ag̃obucẽg̃ ece” i õn e'em ewebe iape wuya'õm). ");
INSERT INTO myu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ce'ũ topibit waram o'jetait. O'je'ag̃obucẽg̃ g̃ebuje bit. O'kop. O'jexĩg̃xĩg̃. Imẽnpuye o'jojojo'iayũ itabẽg̃bẽg̃ o'e ip ijojom. ");
INSERT INTO myu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","— Ixan cuy eg̃ũm cebe — Jesus o'e ixi be. — “Jesus waram odaxit'ũm o'g̃utait” i'ũmg̃u juy epe'e warara'acayũ be — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus o'ju ibocewi. O'ju jaypanapka kay. Oajẽm Nazaré ka be jeweju etaybitbin'ukayũ eju. ");
INSERT INTO myu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado bima ade o'g̃utaybin Deus eju kawẽnwẽnap'a be. Jebodoydoyap kabia be ip o'g̃utaybin. Ade ixe ekawẽn o'ya'ĩjojo ip. Ya'õpicũg̃cũg̃ ip o'e cekawẽn kay. — Apẽntak ig̃o ag̃okatkat itaybit soan kawẽn? — io'e ip jeweweju. — Abu dak ixe o'g̃utaybitbin? Wuywebe i'e ba'oreap mubapukpug̃ g̃oku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","— Ig̃o g̃u du karepig̃a? — io'e ip. — Maria it ma g̃oku. Tiago wag̃o ma g̃oku. José wag̃o dak. Judas wag̃o dak. Simão wag̃o dak — io'e ip. Iixĩtyũ dak ijoce ma wuyweju ma — io'e ip. — Wuyju bit kũyjobin g̃u juy ajop ixe a'õ kay, ixe wuyjo'iat puye — i napa ma o'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Imẽnpuye Jesus o'jekawẽn ceweju ip. — Soat ka dag̃acat ibuyxim ma Deus ekawẽn muwẽnuwẽn'ukat kug̃ — io'e. — Jaypanap ka beayũ bit ibuyxim g̃u ikug̃ — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Nazaré ka be bima ade em g̃u Deus a'õbacaap o'g̃ubapuk, itabut'ũm ip puye. — Itabut'ũm cĩcã ip okay — Jesus o'e jewebe ma. Warara'acayũ bit ixe kay jĩjã o'e. Imẽnpuye jebu o'jewebumõg̃ cebe ip―iwãtaxipipiayũ be. O'g̃u'ada'ada ip. G̃uyjom wuyjuyũxirixiri dag̃ oekukuku. Imutaybitbin ip oekukuku. ");
INSERT INTO myu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus 12 beayũ o'tomuwã jewekay. Xepxepxem ip o'g̃ujuju warara'acat ka dag̃. G̃ebuje o'jekawẽn ceweju ip. — Wa'õbi ma ibiõg̃buk kẽrẽat epeg̃ujẽmjẽm ikug̃ayũ bewi — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","— Eyba'ip acã epeyoptujowat eyjuap tag̃ — io'e cebe ip. — Eyxan pit epetujowat g̃u, sacola dak ka'ũma, dinheiro isurũg̃at tak ka'ũma. ");
INSERT INTO myu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eyesandália dak epetujowat — io'e. — Eyewebeat acã eydoti epetujowat―xepxem pit ka'ũma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","— Pũg̃ka be eyajẽm puje, pũg̃'a be ma epesopsop uk'a be. Pũg̃'a be ma epesop ig̃o ka be bima — io'e. ");
INSERT INTO myu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","— Pũg̃ka be eyajẽm puje, ibo ka watwat pe eykukpin'ũm pima, wara'atka kay juy epeju — io'e. — Ibo ka watwat eya'ĩjo pin'ũm pima, epejẽm cuy ibo ka bewi. Cẽm pima eyesandália epeg̃upoypoy “Deus pe ipiat pi'ajoat puje eywebe, ocekpiwatpi g̃u oce'e,” i'e'em cebe ip — io'e. — “Eyju ma eyukpiwat Deus ekawẽn kay'ũm puye,” i juy epe'e cebe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Imẽneju 12 beayũ o'ju. Ade mukũyjojom oekukuku ip kawẽn idipan. — Ikẽrẽat mug̃ẽg̃ẽap epeyepere juy — io'e ip. — Cũg̃ ma juy epeku — io'e ip adeayũ be. ");
INSERT INTO myu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ibiõg̃buk kẽrẽat o'g̃ujẽmujẽm ip soat pewi. Ixepti o'timõg̃mõg̃ ip iwãtaxipipiayũ a jeje imu'ada am. ");
INSERT INTO myu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","G̃ebuje ipi kukukat Herodes Jesus awẽg̃ o'yawẽg̃tobuxik soat kaka dag̃ o'jeawẽg̃epõg̃põg̃ puye. Tũybe waram g̃uto o'jetait'iat teku iãn o'e ip adeayũ. — João Batista teku — io'e ip pũg̃pũg̃. — Waram g̃uto o'jetait teku je'ũap tomukadi — io'e ip. — Imẽnpuye Deus a'õbacaam wuywebe i'e ba'oreat mubapukpug̃ teku — io'e pũg̃pũg̃pũg̃. ");
INSERT INTO myu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","— Ka'ũma — io'e warara'acat pit. — Elias'ũm teku — io'e ip. — Waram g̃uto o'jetait — io'e ip. — Ka'ũma — io'e warara'acayũ bit. — Deus ekawẽn muwẽnuwẽn'ukat'ũm teku — io'e ip. — Waram g̃uto o'jetait'iat teku — io'e ip. — Kuyje osunuyiat teku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Imẽnpit ipi kukukat Herodes Jesus awẽg̃ co buje, imẽn o'jekawẽn. — Oxe bit teku João Batista — io'e. — Kuy bima wemu'a'uk teku. Imẽnpit waram g̃uto o'jetait — io'e. ");
INSERT INTO myu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Kuy bima Herodias Filipe tayxi osunuy. Ikukat Herodes kitpit tayxi osunuy. Herodes pit Herodias o'jat jetayxim. Imẽnpuye João Batista o'e Herodes pe: — Deus xe cedag̃ g̃u ewebe jewebumũn ãm ekitpit tayxi eju — i. Imẽnpuye Herodias itakoma jĩjã o'e João kay. João aoka ojuy o'e. Imẽnpuye Herodes João o'g̃uõmat daomũnmũnap'a be jetayxi be yaokaap puxim. Herodias pe João aoka ba'ore o'e, Herodes xe João ya'õbuyxi buye. ");
INSERT INTO myu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","— João cũg̃ cĩcã — io'e Herodes. — Xipat cĩcã ixe―ikẽrẽat kug̃ g̃u — io'e. Herodes João muxipanpan osunuy daomũnmũnap'a be yaokaap puxim. Herodes pe João ekawẽn co buje, yag̃uybabi'ũm'ũm osunuy. Inaka João ekawẽn co pin cĩcã osunuy. ");
INSERT INTO myu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","G̃ebuje Herodes peta o'g̃ug̃ẽ jekapap kabia kay g̃ebum am. Peta bog̃ cĩcã o'g̃ug̃ẽ ip. Herodes ya'õbuyxiayũ o'tomuwã peta kay jebekitkiyũ. Sorarayũ kukukayũ dak o'tomuwã, Galiléia eipi beayũ dak―kariwawa ecug̃apap. Peta kabia bima Herodias o'e jewebe ma: — G̃asũ ma João oyaokaat — i. ");
INSERT INTO myu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ibocewi Herodias it oõm peta mug̃ẽg̃ẽap'a be. Ayacat osunuy yaypan'isuat. O'jeda'i'in Herodes etabutpe, ceweju jekõnkõnayũ etabutpe dak. Da'i'iap co buje, icokcok o'e ip. Imẽnpuye: — Ajo-kay ẽn oxewi? — io'e Herodes yaypan'isuat pe. — Emukaypin cuy og̃ũm ewebe — io'e. — Ade obubut weipi be. Ipidaseat ma og̃ũm ewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","— Deus etabun õn e'em ewebe — io'e. — Soat emukaypin cuy og̃ũm ewebe — io'e. — Ipidase juy og̃ũm ewebe obubut. A'õ kay je'e ip webekitkiyũ — Herodes o'e. ");
INSERT INTO myu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ixe yaypan'isuat o'jẽm. O'ju jexi kay. — Mamãi, ajo dak ojoojuy? — io'e jexi be. — “João Batista a juy eya'ukat. Eyaũm owebe,” i juy ece cebe — io'e ixi. ");
INSERT INTO myu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Herodes kay yaypan'isuat o'jepit ipi kukukat kay g̃ebuje bit. — João Batista a juy eyaũm owebe parato be — io'e ipi kukukat pe. — G̃axĩn ma juy eyaũm owebe — io'e jexi a'õbi. ");
INSERT INTO myu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ipi kukukat Herodes ig̃uycũg̃ o'e. Ibu'u jĩjã ya'uk an osunuy. — Soat emukaypin cuy og̃ũm ewebe — i juk o'e yaypan'isuat pe jeweju jekõnkõnayũ etabutpe. Imẽnpuye isũsũn o'e jebureyũ buxim. “Oyaũm g̃u ewebe” i'eap puxim isũsũn o'e. ");
INSERT INTO myu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","G̃ebuje o'jekawẽn sorara be. — João a juy eya'uk — io'e. — Eyadojot cuy owebe — io'e sorara be ipi kukukat. Sorara o'ju. João a o'ya'uk daomũnmũnap'a be. ");
INSERT INTO myu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","O'yadujupit parato be. O'yaũm yaypan'isuat pe. Yaypan'isuat o'yadujowat jexi be. O'yaũm cebe. ");
INSERT INTO myu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","João'ũm e'ũ ãm jekũyjo buje, ceweju oekuku'iayũ o'ju Herodes kay. João'ũm jebit o'tujowat ip. Jebabim o'jomõg̃ ip witabikũy be. ");
INSERT INTO myu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ixe be juk o'g̃uju'iayũ o'jepit Jesus kay. Soat cuk o'e'e ip iat o'g̃uwẽn ip cebe, soat cuk o'g̃utaybitbitbin iap tak. ");
INSERT INTO myu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ade jĩjã ajẽmjẽm ip o'e Jesus kay, ceweju etaybitbin'ukayũ dak. Cẽmcẽm tak o'e ip cexewi ip. Ixeyũ dak cekõn pa'ore o'e ade ip puye. Imẽnpuye Jesus o'jekawẽn ceweju ip. — Eydaobire jĩjã — io'e. — G̃a'a aju uk'a'ũmat kay jebodoy am. Wuyju acã aju — Jesus o'e cebe ip. — G̃a'a — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","G̃ebuje o'ju ip uk'a'ũmat kay. Kobe dag̃ ip o'ju. Ixeyũ acã o'ju jebodoy am. ");
INSERT INTO myu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ijẽm puje ip, ade kapurũg̃ tag̃ayũ Jesusyũ o'jojojo. — Jesus o'jẽm jeweju etaybitbinayũ eju — io'e ip jewewebe. — G̃a'a aju kapurũg̃ tag̃wi ixeyũ dopabe — io'e ip. Imẽnpuye o'jedau ip kapurũg̃ tag̃. O'jedau ip Jesusyũ dopabijuk am. Soat kaka dag̃wi o'ju ip. Jesus ajẽm'ũm awap ma oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kobe bewi jejẽm puje, Jesus ade jĩjã o'jojojo. Itabotaidabotbot o'e cekay ip. — Teyũku ovelhayũ buxim oxe―jekukat'ũmayũ buxim — Jesus o'e jewebe ma. Ade ma ip o'g̃utaybin. ");
INSERT INTO myu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kaxi ipi tẽg̃ pima ceweju etaybitbinayũ o'ju Jesus kay. — Ijoce ya'ũmg̃u uk'a — io'e ip. — Ka'ũmg̃u wuyxan. Kuy katpuje jĩjã — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","— Adeayũ juy eg̃uypit ag̃oka kay — io'e ip. — Eg̃uypit ip ikatẽg̃atka be jexat pu am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","— Eyju ma ixan epeg̃ũm cebe ip — Jesus o'e cebe ip. — Apẽntak pão'a oceyabu soat xat'am? — io'e ip. — Pão'a deim kuka o'e teibog̃ cĩcã. 200 dinheiro isurũg̃at kuka o'e―prata mug̃ẽg̃ẽ — io'e ip. (Pũg̃ dinheiro isurũg̃at prata mug̃ẽg̃ẽ pũg̃ kabia ekapikapteim osunuy). ");
INSERT INTO myu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","— Pebũrũ'a eyju pão'a kug̃? Epeju buk eyetaybit am — Jesus o'e. O'ju ip jetaybit am. Itaybit puje ip o'jepit. — 5 be pão'a kug̃ oceju, xepxep axima kug̃ tak — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","— Epe'e juy adeayũ be “Epabik cuy tip kireat ceje,” i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Soat ip awerom oabikbik. Ade jĩjã osodop ip. Pũg̃ eawero 50 be wuyjuyũ osodop ip. Wara'at eawero 100 be osodop ip. Wara'at eawero 50 be osodop ip. Wara'at eawero 100 be osodop ip. Ade jĩjã osodop ip. 5000 ag̃okatkat osodop ip―pão'a omayũ. Ixeyũ tayxiyũ dak ya'om, ipotpoyũ dak, taxityũ dak. ");
INSERT INTO myu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","44","G̃ebuje Jesus o'jekawẽn jebay eju―Deus eju. Pão'a o'yabu. Axima dak o'jat xepxep. Ixe dak o'jeapũn kabi kay. O'jekawẽn Deus eju. — Bay, ẽn xipat — io'e. — Pão'a eyaũm ocexat'am — Jesus o'e Deus pe. Pão'a o'yadakat. — Juku pão'a — io'e jeweju etaybitbinayũ be. Cinco be pão'a o'yadop. Imẽnpit Jesus o'yamu'acog̃. Ya'ade jĩjã o'e. Ceweju etaybitbinayũ o'yaũm adeayũ be. Xepxep axima osodop. Jesus pit axima o'g̃u'acog̃. Imẽnpuye ade jĩjã o'e. Axima dak o'g̃ũm jeweju etaybitbinayũ be. O'g̃ũm ip adeayũ be. Soat ip o'jo'o'o―5000 beayũ―ag̃okatkayũ. Soat ip ibeg̃beg̃ o'e, Jesus o'g̃u'acog̃ puye. Ibocewi ceweju etaybitbinayũ cepoyat o'jat. Ico be ip o'g̃uõm. 12 be o'g̃unopapũn ip cepoyan―pão'a epoyat'am, axima epoyan tak. ");
INSERT INTO myu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","G̃ebujeap tomukadi: — Epeõm cuy kobe be — Jesus o'e jeweju etaybitbinayũ be. — Wĩnãbu epeju owap. Betsaida ka kay juy epeju — io'e. Jesus “Eyduk'a be juy epeyepit,” i'e'em pima adeayũ be, ceweju etaybitbinayũ o'ju wĩnãbu. ");
INSERT INTO myu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tuk'a be adeayũ muju buje, Jesus o'ju co'a kay jekawẽn ãm Deus eju. ");
INSERT INTO myu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kabiok pima Jesus jag̃epũg̃ ma o'e kapurũg̃ pe. Imẽnpit kobe dag̃ayũ iodi bicũg̃ pe o'e ip―ceweju etaybitbinayũ. ");
INSERT INTO myu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesus ip o'jojojo―kobe dag̃ayũ―tibicũg̃ peayũ. Pipim jekoykoy o'e ip kabido o'subidoajẽm topabe buye. O'ju cekay ip kabiakabia'i bima―kaxi jẽm awap ma. Kuyg̃u o'ju tibicũg̃ peayũ kay. O'kop co'a dag̃wi. Idibi adopa dag̃ xĩg̃xĩg̃ o'ju. Cekay ip o'ju. ");
INSERT INTO myu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesus o'jojojo ip idibi adopa dag̃ xĩg̃xĩg̃ pima. Tũybe ite axik iãn o'e ip. Jesus co buje soat ip o'jewãwã jeparara pibun. ");
INSERT INTO myu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Iparara jĩjã ip o'e. — Eya'õcam cuy epesop! Eypararam g̃u juy! Õn ã! — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ibocewi Jesus oõm kobe be ceweju ip. Kabido o'subido'ũm g̃ebuje bit. Dao ma o'tipon. Imẽnpuye o'jekuy ip. Yag̃uybabi'ũm o'e ip. O'jojojo g̃u buk ip imẽg̃at. ");
INSERT INTO myu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ixe kabido o'subidomupon iap o'jojojo ip. Inaka teku Deus a'õbacaap kug̃ jekukum iap kay itabut g̃u ip. Pão'a o'yamu'acog̃ iap o'jojojo ip. Inaka: — Ka'ũma ma ite jo'i ya'õbuyxi — i'ũmg̃u o'e ip. Itabut g̃u o'e ip cekay. ");
INSERT INTO myu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iodi mudek puje ip, Jesusyũ oajẽm Genesaré eipi be. O'jemũg̃ ip ebikopap pe. Kobe ip o'g̃ukirik ka'oririt pe. ");
INSERT INTO myu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kobe bewi ijẽm isum ma ip itaybit o'e teyũku Jesusyũ iam ibo ka watwat. ");
INSERT INTO myu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Daudaum o'ju ip uk'a'a dag̃ iwãtaxipipiayũ dakoykoy. O'tujowat ip Jesus kay. Dobaptup ceje o'tujowat ip. Iwãtaxipipiayũ o'tujowat ip adeayũ o'e “Jesus omuyku ijoce” iap pe. ");
INSERT INTO myu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ag̃oka dag̃ Jesus oeku, ikabog̃atka dag̃ tak, biopak kukukayũ ka dag̃ tak. Yajẽm puje jebureyũ iwãtaxipipiayũ o'jomõg̃ je'aweroroap pe. — Ãg̃ esay ukpi oceg̃ucay — io'e ip Jesus pe. Soat ip o'je'ada o'g̃ucay'iayũ. Soat iwãtaxipipiayũ xipat o'e. ");
INSERT INTO myu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseuyũ o'je'awero ip Jesus kay, Moisés ekawẽn imutaybitbin'ukayũ dak―Jerusalém ka bewiayũ. ");
INSERT INTO myu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Aypapayũ'ũm'ũm ekawẽn tag̃ jekuku'uk osodop ip Fariseuyũ, soat warara'acayũ Judeuyũ dak. Jebu'isu bima dak ip jebuwuywuy'uk ma osodop. Tũybe ade em wuybuwuy'ũm pima wuykẽrẽ Deus xe iãn o'e ip. Imẽnpuye ade em jebuwuy'ũm pima, o'jekõn g̃u ip. Tarekrek pupuap pewi jepit puje, o'jekõn g̃u ip ade em jebuwuy'ũm pima. Ade ma ajojoyũ'ũm'ũm ekawẽn tag̃ jekuku'uk osodop ip―kuyjeayũ'ũm'ũm ekawẽn tag̃. Imẽnpuxim soat em ma kopo'abi wuywuy'uk ip osodop, kamuti'abi wuywuy'uk tak ip osodop, kajarão'abi wuywuy'uk tak ip osodop. Jesus eju etaybitbinayũ bit ade em'ũma o'jewebuwuy jekõn pima―pũg̃ em ã. Fariseuyũ iboap o'jojojo. ");
INSERT INTO myu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","G̃ebuje Fariseuyũ o'jekawẽn Jesus eju, Moisés ekawẽn imutaybitbin'ukayũ dak. — Eweju etaybitbinayũ wuyajojoyũ'ũm'ũm ekawẽn tag̃ g̃u jekukum — io'e ip cebe. — Cedag̃ g̃u ip jekukum. Ade em'ũma jewebuwuywuy'uk ip jekõn ãn — io'e ip imuymuy ip. ");
INSERT INTO myu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","G̃ebuje Jesus o'jekawẽn ceweju ip. Ixeyũ o'g̃ukorẽm. — Kuyje ma juk Isaías emuwẽn icẽmãn — io'e. — Imẽn o'e jemudupmubararaktup pe: Deus e'em: “Deus kay oceju” i napa ma e'em iteyũ wuyjuyũ, i. Imẽnpit okay g̃u ip, i'e'em Deus, i juk o'e Isaías — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“Ẽn xipat,” i te'e ma e'em ip owebe, i. Imẽnpit xipat g̃u õn ip cexe, io'e Deus, io'e Isaías. “Deus ekawẽn eymutaybitbin oceju bit,” i napa ma e'em ip. Imẽnpit wuyjuyũ ekawẽn acã adeayũ mutaybitbin ip, i'e'em Deus, i juk o'e Isaías — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","— Eyju Deus ekawẽn iwatiwan aypapayũ'ũm'ũm ekawẽn tag̃ eyeku am — io'e Jesus Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. ");
INSERT INTO myu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","— Deus ekawẽn kay g̃u eyju―aypapayũ'ũm'ũm ekawẽn kay acã! Jewexe eyetaybit cĩcã! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","13","— Moisés o'e kuyje: Xipan cuy eyebay epejukuk, eyxi dak, i. Waram o'e g̃uto: Jebay muymuy'ukat cuy epeyaoka―jexi muymuy'ukat tak, i. Imẽn Moisés o'e — io'e. — Imẽn eyju warara'acayũ muwa'ũm'ũm cebay buywat am, ixi buywat am tak. “ ‘Dinheiro kuka adi og̃ũm eywebe eybuywat am,’ i juy epe'e eyebay be,” i eyju bit e'em warara'acat mukũyjojom — io'e Jesus. “ ‘Imẽnpit ibo edinheiro og̃ũm cuy Deus pe,’ i juy epe'e eyebay be,” i'e'em eyju bit warara'acat mukũyjojom — io'e Jesus. — “ ‘G̃asũ iba'ore owebe eybuywat am,’ i juy epe'e cebe ip,” i eyju e'em imukũyjojom ip — io'e Jesus. — Imẽn eyju Deus ekawẽn kay g̃u. Deus ekawẽn g̃u warara'acayũ mutaybitbin eyju―eyekawẽn acã. Deus ekawẽn tag̃ g̃u eyju jekukum―eyekawẽn tag̃ acã. Soan eyju e'em cedag̃'ũmãn — Jesus o'e Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","G̃ebuje Jesus waram adeayũ o'tomuwã jewekay. — Eya'õpicũg̃cũg̃ cuy apẽn õn em iap kay — io'e cebe ip. — Eyetaybin cuy epesop! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","— Wuywebe iõmõmap g̃u wuymukẽrẽrẽrẽn―wuybinũn peat acã! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","— Wekawẽn eyetaybit pin pima, xipan cuy eya'õpicũg̃cũg̃! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus o'jẽm adeayũ xewi. G̃ebuje oõm uk'a be jeweju etaybitbinayũ eju. O'jekawẽn ip ceweju―Jesus eju. — “Wuywebe iõmõmap g̃u wuymukẽrẽrẽrẽn―wuybinũn peat acã,” i kuy ece adeayũ be — io'e ip. — Iba'arẽm ekawẽn ocexe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","— Eyju dak eyetaybit g̃u du wekawẽn? io'e. — Adeayũ-buxim wekawẽn pa'arẽm tu eyxe? — Jesus o'e. — Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay. Eyxat õmõm eybinũn pe g̃u―eydada be acã! G̃uyjom cẽmcẽm g̃u to eywebewi — io'e. — Imẽneju eyxat g̃u eymukẽrẽrẽrẽn — io'e. Jesus iboam i'e buje “Soat i'opi g̃u wuywebe” iam imutaybin ojuy ip o'e. ");
INSERT INTO myu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","— Ixat g̃u ijodiacat mukẽrẽrẽrẽn — io'e. — Ijodiacat ikẽrẽat mujurũg̃rũg̃ soat em ikẽrẽat kay g̃ebum puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","— Soat em ijodiat g̃ebum ikẽrẽat kay. Imẽnpuye soat em ikẽrẽat kay jewag̃uydadam ip: aoyũ kaykay dak ip, warara'acat pubut tujupa'um'um tak ip; warara'acat aokakam tak ip, ");
INSERT INTO myu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","warara'acat tayxi kaykay dak ip; itabikuku dak ip warara'acat pubut kay; ikẽrẽat mujurũg̃rũg̃ tak ip; napapa'uk tak ip; warara'acat mug̃uykuku ojuy dak ip; cekawẽnkẽrẽ dak ip; itabutkarey dak ip; warara'acat awẽg̃tatam tak ip; yobog̃an pin tak ip; yag̃uyba'arẽm tak ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","— Ijodiacat ikẽrẽat mujurũg̃rũg̃ jexat o'om puye g̃u―soat em ikẽrẽat kay g̃ebum puye acã — Jesus o'e. Imẽn Jesus jewejuayũ o'g̃utaybitbin ");
INSERT INTO myu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ibocewi Jesus o'ju Tiro ka kay, ig̃o ka tẽg̃atka kay dak. Oõm uk'a be jenuy ãm. Ibu'u osunuy warara'acat pe itaybit am Jesus omuy ijoce iam. Imẽnpit cemunẽm pa'ore osunuy. ");
INSERT INTO myu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","G̃ebuje Jesus uk'a be omuy iam o'jekũyjo ayacat. Ixe ayacat it axik kug̃ osunuy jewebe―ayacat'it'it. Je'it mu'adaap ojuy o'ju Jesus kay. O'jẽg̃'aecõg̃cõg̃ cewap. ");
INSERT INTO myu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Grego a'õm kawẽnwẽn'ukat osunuy ayacat. Judeu g̃u osunuy. Sirofenícia eipi bewiat osunuy. — O'it axik kug̃ — io'e. — Eg̃ujẽm cuy cebewi — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","— Ap! — io'e. — Judeu g̃u ẽn — io'e. — Koap puk õn webekitkit puywan―Judeuyũ buywan. G̃uyjom acã Judeu'ũmayũ osubuywan — io'e. — Cedag̃ g̃u wuywebe webekitkit xat pum iũm ãm akurice be. Icẽm g̃u du? — io'e Jesus ibuyxijojom. ");
INSERT INTO myu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","— Icẽmãn ẽn e'em, Kariwa — ayacat o'e. — Imẽnpit akuriceyũ bekitkit pi nõmnõm acap wiwim mesa diotpe — io'e. — Õn tak ewebe obuywacap wiwim akurice be ibi nõmnõm acap wiwiap puxim — io'e ayacat. ");
INSERT INTO myu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","— Icẽmãn ẽn e'em — io'e. — Imẽnpuye juy ecepit eduk'a kay — io'e. — Axik kuy og̃ujẽm e'it pewi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","O'jepit je'it kay. Je'it o'tobuxik po'i jexexecap pe. Axik kuy o'jẽm cebewi. Xipat o'e. ");
INSERT INTO myu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","G̃ebuje Jesus o'jẽm Tiro ka tẽg̃atka bewi. Jepitpin pima o'kap Sidom ka dag̃, 10 beatka dag̃ tak. O'ju iodi kay Galiléia eipi beati kay. ");
INSERT INTO myu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","G̃ebuje ibureyũ ya'õpi'ũmat o'tujowat Jesus kay. Ya'õpi'ũmat ya'õbabi'ũm tak osunuy. — Ebu juy esubumõg̃ ya'õpi'ũmat pe imu'ada am — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","G̃ebuje Jesus ya'õpi'ũmat o'tujowat adeayũ parakpewi. Jag̃epũg̃ ma o'tujowat. O'jewebumuy ya'õpi'ũmat a'õpi be. O'jexi. Jebidim ya'õpi'ũmat kõ o'sukõmucay. ");
INSERT INTO myu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kabi kay jeapũnapũn pima, o'jepidowat. — Efatá! — Jesus ja'õm o'e cebe. (Efatá “a'õpi juy ja'õpietok” iape). ");
INSERT INTO myu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ya'õpi'ũmat o'jea'õpietok g̃ebuje. O'jekõewut tak. Xipan o'e jekũyjojom. Xipan o'e kawẽnwẽn tak. Jesus o'jepit adeayũ kay ya'õpi'ũm tũĩbit eju. ");
INSERT INTO myu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","— Jesus ya'õpi'ũmat a'õpi o'ya'õpimutok iap awẽg̃ epeguwẽn g̃u warara'acayũ be — io'e Jesus adeayũ be. Imẽnpit big̃ ma ip o'g̃uwẽnuwẽn yawẽg̃. ");
INSERT INTO myu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yawẽg̃ coco'ukayũ itabẽg̃bẽg̃ o'e ip ijojom. — Xipan acã xeku e'em — io'e ip jewewebe. — Ixe a'õbi ya'õpi'ũm tũibiyũ jekũyjojom o'e g̃asũ bit. Ixe a'õbi ya'õkẽrẽ tũibiyũ xipan kawẽnwẽn o'e g̃asũ bit — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","G̃uyjom g̃uto adeayũ oajẽm Jesus kay. Ebapũg̃ kabiabun ixeyũ mutaybitbin osunuy Jesus. Ixat ip oi'ũm. Jesus jeweju etaybitbinayũ o'tomuwã jewekay. ");
INSERT INTO myu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","— Wetabotaidabotbot iteyũ kay — io'e. — Xepxep xet oweju ip jekukum. G̃asũ bit ixat'ũmg̃u ip o'e — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","— Jeduk'a kay ip imuypit puje, e dag̃ ma kuka juk ip o'tao'ũm'ũm repibun — io'e. — Pũg̃pũg̃ wũywi oajẽmjẽm — Jesus o'e jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","— Apẽn iteyũ xan acejat? Ka'ũmg̃u ijoce — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","— Pebũrũ'a eyju pão'a kug̃? — Jesus o'e. — 7 be ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","— Epabik cuy ipi ju — Jesus o'e adeayũ be―jexat kug̃'ũmayũ be o'e. G̃ebuje Jesus ixan o'jat. 7 be o'yabu pão'a. — Bay, ẽn xipat — io'e. — Eyaũm ocexat'am pão'a — Jesus o'e Deus pe. Pão'a o'yadakat. O'yamu'acog̃ cĩcã. Ya'ade jĩjã o'e. — Juku. Epeyaũm cuy adeayũ be — io'e Jesus jeweju etaybitbinayũ be. Yaũmũm o'e cebe ip ixeyũ be yamu'ẽ'ẽ ãm adeayũ be. O'yamu'ẽ'ẽ ip cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Axima kug̃ o'e ip pũg̃pũg̃ ma. — Bay, ẽn xipat — io'e. — Axima eg̃ũm ocewebe — Jesus o'e Deus pe. — Judaku — io'e. — Epeg̃ũm cuy adeayũ be — io'e jeweju etaybitbinayũ be. O'yamu'ẽ'ẽ ip adeayũ be. ");
INSERT INTO myu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","G̃ebuje soat ip o'jo'o'o adeayũ. Ibeg̃beg̃ o'e ip Jesus pão'a o'yamu'acog̃ puye. Ceweju etaybitbinayũ cepoyat o'jat ip. Axima epoyat o'jat ip, pão'a epoyat'a dak. 7 be o'yamunopapũn ip cepoyan yoba'a. ");
INSERT INTO myu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ade jĩjã wuyjuyũ o'jo'o'o. Ebadipdip mil o'jo'o'o. G̃ebuje Jesus adeayũ o'g̃uypit ip tuk'a kay. ");
INSERT INTO myu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ixe oõm kobe be jeweju etaybitbinayũ eju. O'ju ip Dalmanuta eipi be. ");
INSERT INTO myu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseuyũ o'ju Jesus kay. Jesus buyxijo ojuy ip o'ju. — Ocewebe i'e ba'oreat cuy eg̃ubapuk ocewebe — io'e ip. — Iboap co buje, acetabun ẽn Deus xewiat iap kay — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Imẽn o'e ip Jesus buyxijoap ojuy. Jesus ig̃uycũg̃ o'e jekay itabut am ibu'u ip puye. — Ap! — io'e cebe ip. — Eyju e'em “Ocewebe i'e ba'oreat cuy eg̃ubapuk ocewebe,” i — io'e. — Imẽnpit eybu'u'u eyetabut am okay. Imẽnpuye eywebe i'e ba'oreat og̃ubapuk g̃u eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ibocewi Jesus Fariseuyũ o'suiwat. Oõm kobe be. O'ju wĩnãbu jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pũg̃'a ma pão'a kug̃ o'e ip kobe be. O'yag̃uyba'ũm ip wara'at'a dujowat am jexat'am. ");
INSERT INTO myu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus o'jekawẽn ceweju ip. — Fariseuyũ epão'a muyuhuhuaptõm kay g̃u juy epesop, Herodes ebekitkit epão'a muyuhuhuaptõm kay g̃u dak — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","— Apẽnpuye dak ixe kawẽnwẽn oceweju pão'a muyuhuhuaptõm? — io'e ip jewewebe. — Imẽn kawẽnwẽn oceweju pão'a kug̃'ũm puye wuyju — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus itaybit o'e apẽn ip o'jekawẽn jewewebe iam. Imẽnpit pão'a muyuhuhuaptõm i'e buje, Fariseuyũ emumutaybitbinap i'e ojuy osunuy. — “Pão'a kug̃ g̃u wuyju,” i'ũmg̃u juy epe'e! — io'e. — Wekawẽn pa'arẽm tu eyxe? Eyetaybit g̃u du? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","— Eyetaybit g̃u eyetate ma'g̃u. Jekũyjojom g̃u eyju, eya'õpiehe ma'g̃u — io'e. — Eyag̃uyba'ũm wa'õbacaam ma pão'a oyamu'acog̃ iap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","— Pão'a oyaũm 5000 beayũ xat'am iap kay g̃ebum g̃u du eyju? Pebũrũ'a yoba'a epeyamunopapũnpũn yaepoyan? — io'e cebe ip. — 12 beat'a yoba'a — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","— G̃ebum g̃u du eyju 7 be pão'a oyaũm 4000 beayũ xat'am iap kay? — io'e. — Pebũrũ ico epeg̃unopapũnpũn yaepoyan? — io'e. — 7 be ico — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","— Eyetaybit g̃u du ka'ũmãn ma iba'ore owebe iam? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus oajẽm Betsaida ka be jeweju etaybitbinayũ eju. Ig̃o ka watwat ag̃okatkat o'tujowat Jesus kay―ita'ũmat. — Ita'ũmat cuy eg̃ucay imu'ada am — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","G̃ebuje Jesus ita'ũmat o'subaixik. O'tujowat ag̃oka bewi. Jebidi o'timõg̃ ita'ũmat eta be. Jebu o'subumõg̃ cebe. — Ijojom tu ẽn? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ita'ũmat o'jeak. — Ag̃okatkayũ jojom õn — io'e. — Imẽnpit awaydip co'i ip cũg̃cũg̃ oxe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus jebu o'subumõg̃ ma'g̃uto ita be xipan g̃u ijojom puye. Kabia o'e ijojom g̃ebuje bit. Xipan o'e ijojom. ");
INSERT INTO myu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","G̃ebuje Jesus ita'ũm tũibit o'g̃uypit tuk'a kay. — Ecepit cuy eduk'a be — io'e. — Eju g̃u juy ikabog̃atka kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","G̃ebuje Jesus o'ju jeweju etaybitbinayũ eju. O'ju ip ag̃oka kay ika'ĩcatka kay. Cesaréia eipi dag̃ o'kap ip―Filipe eipi dag̃. E dag̃ pima ip o'jekawẽn ceweju ip. — Abu xe'e õn wuyjuyũ xe? — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","— “Teku waram g̃uto o'jetait'iat,” i'e'em ip soat wuyjuyũ — io'e ip. — “Teku João Batista―waram g̃uto o'jetait'iat,” i pũg̃pũg̃pũg̃ e'em — io'e ip. — “Teku Elias―waram g̃uto o'jetait'iat,” i'e'em warara'acayũ — io'e ip. — “Teku kuyjeat―Deus ekawẽn muwẽnuwẽn'ukat―waram g̃uto o'jetait'iat,” i'e'em warara'acayũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","— Abu õn eyxe bit? — io'e. — Ẽn Cristo―Deus emunaẽ ẽn — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","— Omuwẽn g̃u juy epe'e — io'e Jesus. — Adeayũ be: “Teku Deus emunaẽ,” i g̃u juy epe'e cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesus jaokaap o'g̃uwẽn jeweju etaybitbinayũ be. — Soat wag̃o õn — io'e. — Ipiatpi'ajom cĩcã õn — io'e. — Judeuyũ kukukayũ okay'ũm cĩcã je'e, Moisés ekawẽn imutaybitbin'ukayũ dak, Judeuyũ epaĩyũ kukukayũ dak — io'e. — Oaokaat ip. Xepxep xet kap puje waram ocetait — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cekawẽnbapuk cĩcã o'e cebe ip. G̃ebuje Pedro Jesus o'tujowat warara'acayũ xewi. — “Oaokaat ip,” i'ũmg̃u juy ece! — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus o'jekorepẽn. Warara'acayũ jojom pima, jeweju etaybitbinayũ jojom pima dak, Pedro o'g̃ukorẽm. — Mũg̃ ece! — io'e. — Satanás ekawẽn puxim ẽn kawẽnwẽn. Satanás tak ibu'u owebe we'ũ ãm adeayũ beam! Deus ag̃uy dag̃ g̃u ẽn jewag̃uyg̃uy―Satanás ag̃uy dag̃ acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","G̃ebuje Jesus adeayũ o'tomuwã jewekay, jeweju etaybitbinayũ dak. O'jekawẽn ceweju ip. — Oweju jeku pin pima, eywekay ma eyag̃uyba'ũm cuy; eybu'um g̃u dak cuy je'ũ ãm owebeam; wa'õ dag̃ tak cuy epeku — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","— Eybu'u je'ũ ãm owebeam pima, epe'ũ'ũ. Owebeam ey'ũ buje bit, soat em eyetait epesop kabi be eye'ũap tomukadi, kawẽn idipat muwẽn ãm eye'ũ buje dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","— Ajo-kug̃ tak epesop soat tarekrek kug̃ ipi dag̃at kug̃, eybiõg̃buk ipiatpi'ajojoap pe imẽnpit? Ka'ũma kug̃ ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","— Tei'ũmg̃u soat em Deus xe wuydopapteim. ");
INSERT INTO myu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","G̃asũacat ikẽrẽat mujurũg̃rũg̃. Deus kay jetabucap o'jepere ip. Okay'ũm cĩcã ip. Wa'õ kay g̃u dak. Soat wag̃o õn. “Jesus ebekitkiyũ g̃u oceju bit,” i'e'em ip. Wepit puje õn tak “Webekitkiyũ g̃u eyju,” i oce'e cebe ip. Ocepit ma. Idip cĩcã je'e wepicap. Deus ekawẽn tojotjot'ukayũ eju ocepit―idip cĩcãayũ eju — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","— Deus soat kukukan pima ka'ũma ma ixe jo'ian je'e ya'õbacaan. Ixe xe ma epesop ixe soat kukukan pima. Ijo'ũm puje epe'ũ'ũ g̃u pũg̃pũg̃ ey'in — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","5 xet kap puje Jesus Pedro o'tujowat jeweju, João dak, Tiago dak. O'ju ip co'a kay―yaumat'a kay. Oajẽm ip. O'jeu ip. G̃ebuje Jesus o'jewemuwarurun itabun ip. ");
INSERT INTO myu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cesay isopsep cĩcã o'e. Irut cĩcã o'e. Iba'ore wuywebe say murun am cesay rucap co'iam. ");
INSERT INTO myu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","G̃ebuje aypapayũ'ũm'ũm o'jebapuk iboce. Kabi kadiwi o'jebapuk ip. Moisés o'jebapuk, Elias dak. ");
INSERT INTO myu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kawẽnwẽn osodop ip Jesus eju. Pedro o'jekawẽn Jesus eju. — Ocemutaybitbin'ukat, xipat wuyju ijoceam — io'e Pedro. — Ebapũg̃ xijap cuy ocejomõg̃―pũg̃ edopam, wara'at Moisés dopam, wara'at Elias dopam — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Itaybit g̃u o'e jede am jeparara pibun. Pedro bureyũ dak iparara ip o'e. ");
INSERT INTO myu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kabikerereat o'jebapuk. O'g̃uba'arẽm ip Jesusyũ. G̃ebuje Deus o'jekawẽn kabikerereat pewi. — Teku okpot — io'e. — Ikukpin cĩcã oxe. Eya'õpicũg̃cũg̃ cuy epesop ya'õ kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ceweju etaybitbinayũ jeakag̃ pima, xepxepayũ o'jeu ma'g̃uto―kabi kadiwi oajẽm'iayũ. Wara'acat g̃u o'jojojo ip―Jesus acã. ");
INSERT INTO myu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. Co'a dag̃wi kopkom pima o'jekawẽn ceweju ip. — G̃asũ g̃u juy epejojojoiap epeg̃uwẽn adeayũ be — io'e. — Soat wag̃o õn — io'e. — We'ũ buje waram ocetait. Waram wetait puje acã juy epeg̃uwẽn epejojojoiap — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Imẽneju kũyjobit osodop ip Jesus a'õ kay. O'jojojoiap o'g̃uwẽn g̃u ip warara'acat pe. Imẽnpit jeweweju ma ip o'jekawẽn. — Apẽnpuye ixe o'e “Waram g̃uto ocetait,” i? — io'e ip jewewebe ma. ");
INSERT INTO myu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","— Apẽnpuye Moisés ekawẽn ocemutaybitbin'ukayũ e'em “Elias koam omuyku,” i? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","— Icẽmãn õn e'em eywebe — Jesus o'e. — Elias co'iat koam omuyku adeayũ muisun ãm. Adeayũ ag̃uymuwarurun je'e itabut am ip Deus kay — io'e. — Kuyje omuwẽg̃aptup ip o'tupmubararak. Imẽn e'em ibodup: Ite ipiat supi'ajo jĩjã, i. Warẽmtag̃ ma ip ixe jukuk, i. Itakoma jĩjã je'e ip cekay, i'e'em ibodup — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","— Icẽmãn õn e'em eywebe. Elias co'iat kuy oajẽm. Warẽmtag̃ ma ip o'jukuk. Ikẽrẽm cĩcã ip o'jukuk — io'e Jesus. — O'g̃udadaibotbon cĩcã ip. Kuyjeatup ekawẽn tag̃ ikẽrẽm ip o'jukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Warara'acayũ kay, jeweju etaybitbinayũ kay yajẽm puje, ade jĩjã wuyjuyũ o'jojojo yakokoreren ip. Moisés ekawẽn imutaybitbin'ukayũ Jesus eju etaybitbinayũ a'õxikxig̃ o'e ya'õberen. ");
INSERT INTO myu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesus co buje adeayũ itabẽg̃bẽg̃ o'e ip ijojom. O'jedau ip cekay―Jesus kay. — Ajẽm tu? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","— Oajẽm — io'e Jesus. — Apẽnpuye eyju oweju etaybitbinayũ a'õxikxig̃? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","— Ocemutaybitbin'ukat, axik opop okpot pe — io'e pũg̃. — Ixe axik okpot a'õmu'ũmu'ũm, ya'õpimu'ũmu'ũm tak. ");
INSERT INTO myu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Axik pe ixe bu buje, okpot muy'at'an. Ibidopabok cẽmcẽm ibi bewi dak, jenũyekũnũykũnũy dak, ibaca'ũm e'em tak — io'e cebay. — Imẽnpuye okpot otojot ekay. Ajẽm awap “Axik cuy epeg̃ujẽm okpot pewi,” i juk oce eweju etaybitbinayũ be. Imẽnpit iba'ore o'e cebe ip imujẽm ãm — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","— Eyetabut g̃u Deus kay — io'e adeayũ be. — Pug̃ũn og̃uy eyxe? Ade koato eyxe og̃uy bima dak, kuka eyetabut'ũm ma epesop okay — io'e. — Yaypan'isuat cuy epetojot okay — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Imẽnpuye yaypan'isuat o'tujowat ip. Jesus co buje, axik yaypan'isuat o'g̃ukutukutu jĩjã. Ipi ju o'at. O'jejorojoro dak ipi ju. Ibidopabok o'jẽm ibi bewi. ");
INSERT INTO myu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","— Puju ku ite ekpot o'e imên? — io'e Jesus cebay be. ");
INSERT INTO myu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","— Bekin pin ma — io'e. — Ade em imuy'at'an daxa be. Imu'akõmkõm idibi be imuy'ũap ojuy. Etabotaidabotbon cuy eg̃uy ocekay — io'e. — Ocebuywan cuy ece ewebe i'e but pima — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","— “I'e but ewebe bima,” i'ũmg̃u juy ece! Okay etabut pima etaybit ece'e soat i'e but owebe iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","— Wetabut cĩcã g̃u — io'e cebay. — Wetabutsũ ma. Obuywan cuy ece wetabut cĩcã am — io'e ya'õberen g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Adeayũ o'jedau cekay ijo am. Ixeyũ jo buje, Jesus axik o'g̃ukorẽm. — Ejẽm cuy cebewi — io'e wuyjuyũ a'õmu'ũmu'ũm'ukat pe, ya'õpimu'ũmu'ũm'ukat pe. — Waram pit eõm g̃u juy cebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","G̃ebuje axik o'jewãwãwã ya'õberen. Ixe dak yaypan'isuat o'g̃ukutukutu jĩjã. O'jẽm cebewi. Yaypan'isuat ce'ũat puxim o'e. Imẽnpuye: — Oe'ũ teku — io'e adeayũ. Tũybe ce'ũ iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Imẽnpit Jesus yaypan'isuat o'subaixik. O'g̃u'ag̃obucẽg̃. Yaypan'isuat o'ãy. Xipat o'e. ");
INSERT INTO myu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ukã be Jesus õm puje, ceweju etaybitbinayũ o'jekawẽn ceweju. — Apẽnpuye ocewebe axik mujẽm pa'ore o'e? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","— Soat em ma Deus eju kawẽnwẽn'uk'ũm pima, iba'ore wuywebe ite buximat mujẽm ãm — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesus waram g̃uto je'ũap o'g̃uwẽn je'ũm awap. Jesus Galiléia eipi dag̃ oeku jeweju etaybitbinayũ eju. Imutaybin ojuy ip oeku. Imẽnpuye ibu'u o'e warara'acayũ be itaybit am poce omuy iam. — Soat wag̃o õn — io'e. — Oũm ip okay itakomaayũ be — io'e Jesus. — Oaokam ip. Xepxep xet kap puje bit, waram ocetait — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Imẽn imutaybin ojuy o'e. Imẽnpit pẽg̃ape ite o'e iam itaybit g̃u o'e ip. Ade em cuk adi o'e'e cebe: — Ekawẽn pa'arẽm ocexe — i. Imẽnpuye ibisũsũn o'e ip “Pẽg̃ape ẽn e'em” i'e am cebe. ");
INSERT INTO myu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Ibocewi Jesus o'ju Cafarnaum ka be jeweju etaybitbinayũ eju. E dag̃ pima jewa'õxikxig̃ ip. — Õn ma warara'acat podi ma wa'õbuyxiat! — io'e ip soat. Oexexe ip Cafarnaum ka be. G̃ebuje Jesus o'jekawẽn ceweju ip. Ukã be bima o'jekawẽn ceweju ip. — Apẽn cuk epe'e eyewewebe e dag̃ pima? — io'e. O'jede g̃u ip, e dag̃ pima “Õn ma warara'acat podi ma wa'õbuyxiat,” i juk o'e ip puye. O'jewemusũsũn ip jede am. ");
INSERT INTO myu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus oabik. — Eya'õpicũg̃cũg̃ cuy — io'e. — Yobog̃an pin pima, yopican cuy epesop. Soat puywatwan tak cuy epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ixe dak bekicat o'subuixik. O'tujuajẽm cepidase ip. O'yakobot. O'jekawẽn ma'g̃uto jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","— Bekitkit xipan cuy epejukuk, eyju webekitkit puye — io'e. — Xipan bekitkit kug̃ pima, xipan okug̃ tak epesop. Xipan okug̃ pima, xipan omudocat kug̃ tak epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","G̃ebuje João o'jekawẽn Jesus eju. — Kariwa — io'e. — Ag̃okatkat cuk ocejojojo — io'e. — Ibiõg̃buk kẽrẽat mujẽmujẽm o'e ijodiacayũ bewi “Jesus a'õbi õn jemujẽm,” i'e'em — io'e. — “Imẽnmẽn g̃u bit,” i juk oce cebe, ixe wuyweju jekuku'uk'ũm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Imẽnpit Jesus o'jede: — “Imẽnmẽn g̃u bit,” i'ũmg̃u juy epe'e cebe — io'e. — Wa'õbi wuywebe i'e ba'oreat mubapukpug̃ pima, dao g̃u kuka omuy — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","— Wuykay itakoma'ũmat wuykadiat — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","— Icẽmãn õn e'em eywebe. Wara'acat idibi tiũm eywebe tikõn ãm eyju Cristo ebekitkit puye. Deus tak xipacat je'g̃ũm cebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","— Bekicat mubu'un puje okay itabut am, ikẽrẽat mujurũg̃rũg̃ eyju, okay itabucat mubu'un puje. Imubu'un puje, Deus cuy ipiat supi'ajoat eykay. Imẽn ey'e awap, xipat kuka juk o'e wita'a yabog̃at'a mukirik am eyag̃obu eju idibi be eymuakõm. Imubu'un'ũm piam Deus kuka juk ipiat o'supi'ajoat g̃u eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","— Eybum ikẽrẽat mujurũg̃rũg̃ pima, epeyewebudakat cuy — io'e. — Xipat kuka o'e eyõm ãm kabi be pũg̃pu bima dak. Xipat g̃u kuka o'e eyõm ãm ipiat'ajojoap pe xepxepu ma―daxa epirẽm'ũmap pe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","— (Iboce iohe g̃u―soat em ma ierep. Daxa dak jepirẽmrẽm g̃u). ");
INSERT INTO myu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ikẽrẽat mujurũg̃ ãm soat em eyju buje, epeyeweidakat cuy — io'e cebe. — Xipat kuka o'e eyõm ãm kabi be eyeicug̃ tak. Xipat g̃u kuka o'e eywebe eyxik am ipiat'ajojoap pe xepxep im ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","— (Iboce iohe g̃u―soat em ierep. Daxa dak jepirẽmrẽm g̃u). ");
INSERT INTO myu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eyetam ikẽrẽat mujurũg̃rũg̃ pima, epeyeweta'uk cuy! — io'e. — Xipat kuka o'e eyõm ãm kabi be pũg̃ etam tak―soat ma Deus a'õ kay iap pe. Xipat g̃u kuka o'e eywebe eyxik am daxabog̃ pe xepxep eta bima — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","— (Iboce iohe g̃u―soat em ierep. Daxa dak jepirẽmrẽm g̃u. Iboceayũ soat em ipiatpi'ajojom e'em) — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","— Wuyju puybit muyunuyun ig̃ẽmap puxim. Imẽnpuxim Deus tak ipiat pi'ajoan wuywebe, wuywebe ikẽrẽat mujurũg̃ap puxixim — io'e. ");
INSERT INTO myu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","— Kawta tayu bima, xipat cĩcã. Tayu'ũm pima bit, xipat g̃u. Apẽg̃ãm tak takug̃ kuka acesop? Taxik am acã. Kawta tayuat pit xipat. Xipan cuy epeyewekuk eyju dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus oajẽm Judéia eipi kay. Jordãodi wĩnãbu oajẽm. G̃ebuje ade jĩjã wuyjuyũ o'je'awero ma'g̃uto Jesus kay. Adeayũ mutaybitbin'uk osunuy iap puxim imutaybitbin ma'g̃uto o'e waram. ");
INSERT INTO myu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseuyũ oajẽm. O'jekawẽn ip ceweju ya'õmukorẽm ojuy. — Wuyawẽwẽap ekawẽn tag̃ tu wuytayxi epereperem? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","— Apẽn wuy'ajore Moisés o'e kuyje? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","— “Eytayxi epere ojuy bima otayxim g̃u ece g̃asũ bit iaptup cuy epetupmubararak cekay,” i juk o'e Moisés — io'e ip. — “Epetupũm cebe eytayxi be. Tup ũm puje, xipat eytayxi epere am,” i juk o'e Moisés — io'e ip Jesus pe. — Itayxi epereap cũg̃ ma osunuy Moisés xe. Pãm exe? — io'e ip cebe ya'õmuwarurunap ojuy. ");
INSERT INTO myu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","— Moisés imẽn o'e eybu'u jĩjã ya'õ dag jekum puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","— Kuyje bit imẽn g̃u o'e. Kuyje Deus soat o'g̃ug̃ẽ — io'e. — Ag̃okatkat o'g̃ug̃ẽ, ayacat tak. Ixeyũ o'g̃ug̃ẽ xepxem ma jekuku am. ");
INSERT INTO myu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Imẽnpuye jetayxi bu buje, ag̃okatkat cẽmcẽm jebay duk'a bewi. Jetayxi eju cucum. Jektop pu buje ayacat tak cẽmcẽm jexi duk'a bewi. Jektop eju cucum. Xepxep ma ip. Imẽnpit pũg̃at puxim ip o'e jewekug̃ soat em jeweweju ip cucum puye. ");
INSERT INTO myu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Deus xe ip pũg̃ ma. Imẽnpuye eytayxi juy epeyepere g̃u — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","G̃uyjom uk'a be oõm ma'g̃uto Jesus, ceweju etaybitbinayũ dak. — Ekawẽnpa'arẽm ocexe — io'e ip Jesus pe. — Ocetayxi epeream cuy ocemutaybin — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","— Ag̃okatkat jetayxi epere buje wara'at pu am jetayxim, ikẽrẽãn e'em koapat pe―jetayxi be — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","— Imẽnpuxim ayacat jektop epere buje wara'at pu am jektom, ikẽrẽãn e'em koapat pe jektop pe — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iboceayũ je'iyũ o'tujowat ip Jesus kay Deus cuy xipan jeykuk i'e am. — Bekitkit g̃u juy epetujowat Jesus kay — io'e ceweju etaybitbinayũ bit cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus itakoma o'e jeweju etaybitbinayũ kay bekitkit tujowat ojuyacat o'g̃ukorẽmrẽm ip puye. — “Bekitkit g̃u juy epetujowat Jesus kay,” i'ũmg̃u juy epe'e — io'e cebe ip. — Ãg̃ jeedot ip okay — io'e. — Ixeyũ buximayũ jeeõm kabi be soat Deus a'õ kay kũyjobit pima. Jeeõm ip ibu'u'ũm puye ip Deus pe jekukan — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","— Icẽmãn õn e'em eywebe. Bekitkit ibu'u g̃u Deus pe jekuk an. Deus pe eykuk an eybu'u bima, Deus xe g̃u epesop soat Deus a'õ kay kũyjobit pima — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bekicat o'yakobot. O'jekawẽn Deus eju. — Bay, xipan cuy iteyũ bekitkiyũ ejukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ibubut adeat o'ju Jesus kay. Jesus cu ojuy bima ag̃okatkat daudaum oajẽm cekay―yaypan'isuat. O'jẽg̃'aecõg̃cõg̃ cewap, Jesus ya'õbuyxi cexe buye. — Kariwa, — io'e. — Ẽn xipat cĩcã. Soat em Deus xe onuy pin wetait. Apẽntak oce soat em cexe onuy ãm? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","— Apẽnpuye ẽn e'em owebe “Xipat cĩcã ẽn,” i? — io'e. — Ka'ũmg̃u xipacat―Deus acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","— Kuy etaybit apẽn Moisés o'e wuye'ajojoyũ'ũm'ũm pe iam — io'e. — Imẽn o'e: warara'acat epeyaoka g̃u juy, i; wara'acat tayxi kay g̃u juy, i dak; eybukurug̃ g̃u juy epesop, i dak; napa g̃u juy epe'e, i dak; warara'acat epeg̃ug̃uykukuku g̃u juy, i dak; xipan cuy eyebay epejukuk, eyxi dak, i dak. Imẽn Moisés o'e kuyje. Kuy etaybit ijom soan — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","— Kariwa, soat ijop ekawẽn tag̃ ojekukuku bekin pin ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus xe ibubut adeat ikukpin cĩcã o'e. — Wara'an puk ece g̃u — io'e. — Eju — io'e ibubut adeat pe. — Soat ebubut cuy eteida. Ibo juy dinheiro tei'ũma eg̃ũm tadaybocayũ be — io'e. — Imẽn e'e buje, ade je'e ebubut kabi be — io'e. — Imẽn e'e buje juy ejot oweju — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cekawẽn co buje ig̃uycũg̃ cĩcã o'e. Itakoma dak o'e. Ig̃uycũg̃ ma o'jẽm Jesus xewi ibubut ade jĩjã buye. Tacup o'e jebubun. O'ju g̃u Jesus eju. ");
INSERT INTO myu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Imẽnpuye Jesus jakokoreren o'jeak adeayũ kay. Ixe dak o'jekawẽn jeweju etaybitbinayũ eju. — Iba'ore jĩjã ibubut adeat õm ãm kabi be — io'e. — Ibu'u jĩjã ip Deus a'õ kay am, itabut cĩcã ip jebubut kay buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ceweju etaybitbinayũ itabẽg̃bẽg̃ o'e ip ijojom cekawẽn co buje. Imẽnpuye Jesus o'jekawẽn ma'g̃uto ceweju ip. — Tapupuyũ, iba'ore jĩjã ijodiacat õm ãm kabi be. Ibu'u ip Deus a'õ kay am — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","— Camelo ikap pa'ore awi daobi'atok tag̃. Imẽnpit ibodi ma iba'ore ibubut adeat õm ãm kabi be — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jewag̃uymug̃ẽg̃ẽm o'e ip. — Abu be dak jewedaxijo but? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","G̃ebuje Jesus o'jeak cekay ip. — Wuywedaxijo ba'ore soat em Deus xe wuydop am — io'e cebe ip. — Deus pe bit wuydaxijo but. Soat i'e but Deus pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","— Kariwa! Kuy soat ocesuiwat eweju jeku am — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","— Icẽmãn õn e'em eywebe — io'e Jesus. — Eyju okay jĩjã. Eyju kawẽn idipat muwẽn pin cĩcã soat kaka watwat pe. Imuwẽg̃ap ojuy eybubut epere buje, ade epejat wara'at eybubun. Eyduk'a epere buje, ya'ade epeyabu eyduk'am―100 beat'a. Eywag̃o epere buje, “owag̃o” i epe'e adeayũ be―100 beayũ be. Eykitpit epere buje, “okitpit” i epe'e adeayũ be―100 beayũ be. Eyxi epere buje “oxi” i epe'e adeayũ be―100 beayũ be. Eyebay epere buje “webay” i epe'e adeayũ be―100 beayũ be. Eyebekitkit epere buje, “webekitkit” i epe'e adeayũ be―100 beayũ be. Eykat epere buje ade epejat eykan―100 be. Warara'acayũ je'e itakoma eykay. Ipiat supi'ajoat ip eywebe. Guyjom pit Deus xe epesop kabi be. Soat em epesop cexe eyetabẽg̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","— Ade ya'õbuyxiayũ'in yopicayũm jeedop ip. Ade yopicayũ'in ya'õbuyxiayũm jeedop ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Waram Jesus je'ũmap o'g̃uwẽn. Jeweju etaybitbinayũ eju cum o'e e dag̃ Jerusalém ka kay. Jesus o'ju koap. G̃asũ ixeyũ o'ju tomuju. Yag̃uybabi'ũm'ũm ip osodop. Iparara osodop ip warara'acayũ ixeyũ nomujuayũ. Jesus 12 beayũ o'tomuwã jewekay. ");
INSERT INTO myu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","— Eya'õpicũg̃cũg̃ cuy epesop! — io'e cebe ip. — Jerusalém ka kay cum wuyju. Soat wag̃o õn. Oũm ip okay itakomaayũ be, paĩyũ kukukayũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. “Ikẽrẽat kug̃ ẽn Deus xe, ocexe dak,” i je'e ip owebe — io'e. — “Eje'ũ juy,” i je'e ip owebe — io'e. — Judeu'ũmayũ be oũm ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","— Owaywayway jĩjã je'e ip. Jetakomaap pibun ip omuxi. Omupokupok ip. G̃ebuje oaoka ip — io'e. — Xepxep xet kap puje bit, waram g̃uto ocetait — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","G̃ebuje Tiago oajẽm Jesus kay, João dak. Zebedeu ipotpoyũ osodop ip. — Kariwa — io'e ip. — Ocemuojuyjuy eg̃ũm ocewebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","— Ajo ojuyjuy eyju oxewi? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","— Soat kũyjobit a'õkay bima ãg̃ ocabik exe ixeyũ kuk am eweju―pũg̃ oce'in eba'at kadi, wara'at eba'ũg̃at kadi — io'e ip. — Soat kũyjobit a'õ kay iap idip cĩcã je'e — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","— Ap! — io'e. — Eyetaybit pun'ũma eyju iboap ojuyjuy oxewi. Apẽn osupi'ajo iap puxim tu eyju dak epesupi'ajo? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","— Hm hm — io'e ip. — Oceju dak ipiat ocesupi'ajo ebuxim ma. — Imẽn ma — io'e. — Ipiatpi'ajojom pima bit, “Ipiat esupi'ajoat g̃u juy ocewebe,” i du epe'e? — io'e Jesus. — Ap! “Ipiatpi'ajoat g̃u juy ocewebe,” i'ũmg̃u oce'e! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","— Ha'a — io'e Jesus. — Obuxim ma eyju dak ipiat epesupi'ajo — io'e. — Õn g̃u bit e'em: “Abik cuy oba'at kadi oba'ũg̃at kadi,” i. Webay imẽn i'e but. Ixe ma oweju adeayũ kukayũ nuy ãm o'g̃uxipan. Ixe ma je'e abuyũ jabik iboce iap — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Xepxepayũ ekawẽn co buje, warara'acayũ ceweju etaybitbinayũ itakoma o'e ip cekay ip―Tiago kay, João kay dak. ");
INSERT INTO myu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Imẽnpuye: — Epesot cuy okay — io'e Jesus cebe ip. — Eyetaybit Judeu'ũmayũ kukukayũ soat em ya'õpurug̃ jebekitkiyũ mujujum iam — io'e cebe ip. — Ikukukayũ soat em e'em “Oca'õbuyxi jĩjã,” i. Big̃ ma ip jebekitkiyũ mukapikpig̃,” io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","— Eyju bit―imẽn g̃u juy epeyewekuk. Kariwabog̃ pin pima, warara'acat puywatwan cuy epesop! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","— Ya'õbuyxian pin pima, tei'ũma epeyekapik cuy warara'acat peam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","— Imẽntak soat wag̃o õn. Warara'acat pe obuywat am g̃u ojot ijodi. Warara'acat puywatwat'ukan ojot. Adeayũ daxijo am ma ojot. Soat em itabẽg̃ jeedop ip kabi be, oje'ũ buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ibocewi Jesus oajẽm Jericó ka be jeweju etaybitbinayũ eju. O'jẽm ip Jericó ka bewi wuyjuyũxirixiri eju. G̃ebuje Jesus oajẽm ita'ũmat kay. Ita'ũmat xik'i osunuy e bitakobe. Ibutet Bartimeu i osunuy. Timeu ipot osunuy. Kapkamayũ xewi dinheiro ojuyjuy'uk osunuy ita'ũm puye. ");
INSERT INTO myu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","— Jesus Nazareno omuyku — io'e ip kapkamayũ Bartimeu be. Iboap co buje, ita'ũmat o'jewãwã Jesus kay. O'jewãwã ya'õberen. — Jesus! Ẽn Davi'ũm naxeg̃ebit — io'e — wuye'ajojoyũ'ũm'ũm kukukat naxeg̃ebit — io'e. — Etabotaidabotbon cuy eg̃uy okay! — i o'jewãwã ya'õberen. ");
INSERT INTO myu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Imẽnpuye adeayũ ita'ũmat o'g̃ukorẽm. — Ecemũg̃! — io'e ip. — Ecewãwã g̃u juy! — io'e adeayũ Bartimeu be. Imẽnpit big̃ ma o'jewãwã ya'õberen. — Jesus! Davi'ũm naxeg̃ebit! Etabotaidabotbon cuy eg̃uy okay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ibocewi Jesus o'jecũ e bidase. — Ita'ũmat cuy etomuwã — io'e Jesus adeayũ be. Ita'ũmat o'tomuwã ip. — Epararam g̃u eg̃uy! — io'e ip cebe. — E'ãy. Jesus enomuwãwãm — io'e ip ita'ũmat pe. ");
INSERT INTO myu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeu jeekabek o'joxik g̃ebuje jecokcok pibun. Dao ma o'ãy. Jesus kay o'jedau. ");
INSERT INTO myu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","— Ajo-kay ẽn oxewi? — io'e Jesus ita'ũmat pe. — Ocemutaybitbin'ukat, wecoat pin oce! — io'e ita'ũmat. G̃ebuje Jesus o'jekawẽn ita'ũmat eju. ");
INSERT INTO myu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","— Ecepit cuy eduk'a kay — io'e. — Kuy ece'ada okay etabut puye — io'e Jesus. Ita'ũm tũibit o'jecoan g̃ebuje bit. Dao ma o'e ijojom. Xipan o'jojojo. Ixe dak o'ju Jesus eju e dag̃. ");
INSERT INTO myu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesusyũ oajẽm Jerusalén ka be. Jerusalém ka tẽg̃ pima ip oajẽm Betfagé ka tẽg̃ Betânia ka tẽg̃ tak, Oliveira dip'a tẽg̃ tak. Jesus xepxep jeweju etaybitbinayũ o'g̃uju ikabog̃atka be―Jerusalém ka be. ");
INSERT INTO myu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","— Epeju juy ag̃oka kay―wuywapatka kay — io'e cebe ip. — Eyajẽm'isu ma jumento epetobuxik―yaypan'isuat, ikirikat, yakpi jeje ibit'ũmat. Epeg̃uwekap cuy — io'e. — Epetojot cuy okay — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","— “Apẽnpuye eyju jumento dujowan?” i'e buje eywebe ijoceat, “Ocekariwa buk cekay darem ma,” i juy epe'e cebe. “G̃axĩn ma waram ocetujupit eykay,” i juy epe'e cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","O'ju ip. Oajẽm ip jumento kay. Jumento o'tobuxik ip―yaypan'isuat. Uk'a ukpibubu be o'tobuxik ip. Ikirik xintabi be o'tobuxik ip. O'g̃uwekap ip. ");
INSERT INTO myu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","— Apẽnpuye eyju jumento dujowan? — io'e iboceayũ cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","— Ocekariwa buk cekay darem ma — io'e ip. — G̃axĩn ma waram ocetujupit eykay — io'e xepxepayũ cebe ip. — Ha'a. Epetujowat — io'e iboceayũ xepxepayũ be. ");
INSERT INTO myu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jumento o'tujowat ip Jesus kay. Jeekabek ip o'jomõg̃ jumento ukxabi jeje. Jesus oabik iekabek ceje jumento ukxabi jeje. ");
INSERT INTO myu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Adeayũ jeekabek o'g̃upayapaya ip Jesus ajẽmap tag̃ e dag̃. Warara'acayũ uktup o'tuptakat kog̃ũnpi dag̃atup. O'tupmõg̃mõg̃ ip e dag̃. — Wuyekabek ajomõg̃ cuy e dag̃ — io'e ip. — Ya'õbuyxiat omuyku! Uktup atupmõg̃ ixe dobede am — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesus wap iju'ibiyũ o'jewãwã ya'õberen icokcok cĩcã buye, tomujuayũ dak. — Deus xipat cĩcã! — io'e ip. — Teku omuyku Deus a'õbi! — io'e ip ya'õberen. — Deus a'õbacaap kug̃ teku! Teku xipat cĩcã — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","— Teku ijodiacat kukukan jeenuy apẽn cuk adi Davi wuy'ajoreyũ kukukan osunuy iap puxim. Deus ya'õbuyxi jĩjã. Idip cĩcã! — io'e ip Jesus mucokcokcog̃. ");
INSERT INTO myu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","G̃ebuje Jesus oajẽm Jerusalém ka be. Oõm Deus eju kawẽnwẽnap'a be―yabog̃at'a be. O'jeak soat kay―uk'a beat kay. O'ju jeweju etaybitbinayũ eju, Betânia ka be jexet am. O'ju ip katpuje jĩjã buye. Xet. O'xet ip Betânia ka be. ");
INSERT INTO myu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kuyaje Jesusyũ o'jẽm Betânia ka bewi. Cucum pima Jesus ire o'e. ");
INSERT INTO myu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wũy wi figueira'ip o'yopcoco―yoptuptepat'ip. Yajom o'ju ya'a'e paxi iam. Yop xe yajẽm puje o'yadobuxik g̃u. Tup acã o'tuptobuxik ya'a'e g̃u buk puye. ");
INSERT INTO myu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","G̃asũ bit a'a'e g̃u ecesũy wuyjuyũ be ya'oap puxim! — io'e Jesus yop pe. Ceweju etaybitbinayũ iboap o'ya'ĩjojo ip. ");
INSERT INTO myu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","G̃ebuje Jesusyũ oajẽm ma'g̃uto Jerusalém ka be. Oõm ip Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Itakoma o'e wuyjuyũ mug̃uykukuku'ukayũ kay―uk'a eaki korerenayũ kay. Puca deidada'ukayũ o'g̃ujẽm uk'a bewi, puca bubu'ukayũ dak. Wũn'i. Jesus dinheiro mutrokakan'ukayũ emesa o'g̃uy'at. Wũn'i. Pukaso deidada'ukayũ abikbikap tak o'g̃uy'at jetakoma pibun. ");
INSERT INTO myu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","— G̃asũ bit cuy eybubut epetujukap g̃u Deus eju kawẽnwẽnap'a dag̃―yabog̃at'a dag̃ — io'e ya'õpurug̃ cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uk'a beayũ mutaybitbin o'e. — Imẽn e'em Deus kawẽntup: Oduk'a soat ka dag̃wiacat oweju kawẽnwẽnap'am je'e, i'e'em Deus ekawẽntup. Imẽn e'em Deus ekawẽntup — io'e Jesus. — Eyju bit oduk'a be ajẽmjẽmayũ mug̃uykukukum dinheiro bu am. Imẽn oduk'a epeyamuwexat ibukurukat dopdopap'am — io'e. ");
INSERT INTO myu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesus ekawẽn o'ya'ĩjojo paĩyũ kukukayũ, Moisés ekawẽn imutaybitbin'ukayũ dak. Itakoma jĩjã o'e ip cekay. “Apẽntak Jesus aceyaoka?” iap kay ip o'jewag̃uy. Adeayũ bit “Jesus itaybit cĩcã Deus ekawẽn ocemutaybit am” i'e'e'uk osodop ip. Imẽnpuye paĩyũ kukukayũ iparara o'e ip Jesus aokaap puxim. — Apẽn tak iba'arẽm ma Jesus aceyaoka? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Katpuje Jesusyũ o'jẽm ikabog̃atka bewi. O'jepit ip Betânia ka be jexet am. Xet. O'xet ip. ");
INSERT INTO myu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kabia'isu ma o'kop ip. O'jẽm ip ma'g̃uto. O'kap ip figueira'ip tẽg̃ ma. O'yopkaraw g̃asũ bit tãbu dag̃wi. ");
INSERT INTO myu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro g̃ebum o'e “G̃asũ bit a'a'e g̃u ecesũy” io'e iap kay. — Ocemutaybitbin'ukat, ak'i ece! — io'e Pedro. — Eyopmukorẽmiat'ip o'yopkaraw―figueira'ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","— Eyetabun cuy epesop Deus kay! — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","— Deus kay eyetabut pima, “Wede ece ijocewi” i'e but eywebe co'a be, “Idixidi be juy aakõm” i dak — io'e. — Eyetabut pima, Deus co'a yamuakõm idixidi be — io'e. — “Yaakõm paxi?” i ey'e'ũm pima, yamuakõm tak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","— Deus xewi iojuy buje, eyetabun cuy epesop “Ite ma Deus je'g̃ũm owebe” iap kay. Eyetabut pima, epejat ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","— Deus eju kawẽnwẽn pima, eyag̃uyba'ũm cuy epesop apẽn cuk adi wara'acat pe ikẽrẽm eykuk iap kay. Eyag̃uyba'ũm puje, eyebay dak kabi beat yag̃uyba'ũm apẽn cuk adi ikẽrẽat epeg̃ug̃ẽ iap kay. Ikẽrẽat ju'uk eywebewi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","— Apẽn cuk adi warara'acat pe ikẽrẽm eykuk iap kay eyag̃uyba'ũm'ũm pima bit, Deus tak yag̃uyba'ũm g̃u apẽn cuk adi ikẽrẽat epeg̃ug̃ẽg̃ẽ iap kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Oajẽm ma'g̃uto ip Jerusalém ka be. Deus eju kawẽnwẽnap'a ekorara be xĩg̃xĩg̃ pima paĩyũ kukukayũ o'ju Jesusyũ kay, Moisés ekawẽn imutaybitbin'ukayũ dak, Judeuyũ kukukayũ dak. ");
INSERT INTO myu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","30","— Abu-a'õbi ija'a beacat eg̃ujẽm? — io'e ip Jesus pe. — Abu dak “Eg̃ujẽm cuy,” i juk o'e ewebe? — io'e ip cebe. — Abu-a'õbi João Batista'ũm ijoceacat mubatisasan'uk osunuy? — io'e Jesus. — Deus a'õbi du? Ijodiat a'õbi g̃u xe'e? — io'e cebe ip. — Eywebe iboap muwẽn puje, õn tak abu-a'õbi õn jekukum iap og̃uwẽn eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iboap co buje o'jekawẽn cĩcã ip jeweweju. — Apẽn kuka ace cebe? — io'e ip jewewebe. — “Deus a'õbi” i wuy'e buje, “Apẽnpuye dak eyetabut g̃u epesop cekay?” i kuka o'e Jesus wuywebe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","— “Ijodiat a'õbi,” i wuy'e buje bit, adeayũ kuka itakoma jĩjã o'e wuykay — io'e ip. — Soat ip itabut João Batista'ũm Deus a'õbi oekuku iap kay — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Imẽnpuye: — Ocetaybit g̃u — io'e ip Jesus pe. — Ka — io'e. — Abu-a'õbi João Batista oeku iap epeg̃uwẽn g̃u owebe. Õn tak abu-a'õbi õn jekukum iap og̃uwẽn g̃u eywebe — io' e. ");
INSERT INTO myu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","G̃uyjom Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. — Ag̃okatkat uvadip o'tiptaida — io'e Jesus. — Tiptaida buje, korara o'g̃ug̃ẽ. Uvadip koreren korara o'jomuy. Uva'abidi muwesõg̃sõg̃ap o'g̃ug̃ẽ. Uvadip wiwiap'a o'yamuy―umat'a. Warara'acayũ o'jomuy tip wiwi an. Uva'a'in kuka o'yaũm tipwiwi'ukayũ be ya'ade tip wiwiapteim. Wara'at'a'in kuka o'yabu jexat'am. Kadai iwat wara'at ka kay o'ju. ");
INSERT INTO myu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","— Yabubuap ekaxi ajẽm puje, kadai iwat jebuywatwat'ukayũ o'g̃uju tip wiwi'ukayũ kay jekadai'a bu am. — “Oxat'a juy epeyadujupit okay,” io'e cebe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","— Imẽnpit tip wiwi'ukayũ ibuywatwat'ukayũ o'jat. O'yaokaka ip. Ibui pug̃ ma ip o'g̃uypit kadai iwat kay. Oajẽm ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","— Waram g̃uto wara'at jebuywatwat'ukat o'g̃uju. O'yamupãupã ip. Warẽmtaksug̃ ip o'e cebe. O'jepit ip jebui pug̃ ma kadai iwat kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","— Waram g̃uto warara'acayũ jebuywatwat'ukayũ o'g̃ujuju. Pũg̃pũg̃pũg̃ ma imujujum. Imẽn ma ikẽrẽm ip o'jukuk. Pũg̃pũg̃ o'yamupãupã ip. Warara'acayũ o'yaokaka ip. Pog̃. Oe'ũ'ũ ip. O'jepit ip jebui pug̃ ma kadai iwat kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","— Pũg̃ ma o'jepoyat cexe―ipot acã — io'e Jesus. — Cexe ikukpin cĩcã osunuy. Amãm jekpot ma o'g̃uju. — “Ibuyxim ip okpot jukuk,” kadai iwat o'e jewebe ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","— Imẽnpit uvadip wiwi'ukayũ o'jekawẽn jeweweju. “Ak'i! Kadai iwat ipot omuyku!” io'e ip jewewebe. “Cebay e'ũ buje, ite ma kadai iwan je'e. G̃a'a ayaoka. Wuyju ma uva dip iwan ace'e!” io'e ip jewewebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","— G̃ebuje ipot o'jat ip. O'yaoka ip. Pog̃. Oe'ũ. Xik. Ijebit o'joxik ip uva dip pewi — io'e Jesus. Imẽn wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","— “Ãg̃ puk jeedop ip,” i du je'e uva dip iwat? — io'e Jesus Judeuyũ kukukayũ be. — Imẽn g̃u je'e! Ixe je'ju jekadaidip wiwi'ukayũ aoka am — io'e. — Warara'acayũ jomuy uva dip wiwian — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","— Imẽn e'em Deus ekawẽntup: Uk'a muymuy'ukayũ o'e “Ite'a xipat g̃u wita'a” i, i. Yakẽrẽ o'e cexe ip, i. O'yaxik ip, i. Warara'acat pit o'e “Ite'a yadip ma” i, i. Uk'a muycemucemap'am o'e, i. ");
INSERT INTO myu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iboap xipat cĩcã wuyxe, Deus imẽn o'e buye, i'e'em Deus ekawẽntup. Iboaptup epetupcoco g̃u du? — io'e Jesus cebe ip―Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iboap ekawẽn co buje: — “O'yaxik'iayũ buxim eyju!” i'e ojuy osunuy Jesus wuywebe — io'e ip jewewebe. — “Tip ipot o'yaoka'iayũ buxim eyju” i'e ojuy osunuy wuywebe — io'e ip jewewebe. Jesus daomũn ojuy o'e ip. Imẽnpit iparara o'e ip ixe daomũnap puxim adeayũ buxim iparara buye. Imẽnpuye Jesus o'suiwat ip―taomũn ojuyayũ. Ixeyũ dak o'jẽm. ");
INSERT INTO myu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","G̃ebuje Judeuyũ kukukayũ Fariseuyũ o'g̃uju ip Jesus kay. Iecug̃ap Herodes ebekitkit tak o'g̃uju ip cekay. Ixeyũ o'g̃uju ip Jesus a'õmuwarurun ojuy. “Ẽn iecug̃ap muymuy” i'e ojuy osodop ip. ");
INSERT INTO myu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Oajẽm ip. — Kariwa — io'e ip. — Soat em ẽn icẽmãn e'em — io'e ip. — Apẽn Deus ibikuy ocewebe jeku am iam ẽn ocemutaybitbin — io'e ip. — “Ig̃o du xipat exe?” i'ũmg̃u ẽn e'em warara'acat pe emutaybit am. Kacũg̃ kadiat cocoap tomuju g̃u ẽn e'em “Teku xipat” i — io'e ip. — Roma ka kukat wuyedinheiro ojuyjuy cebe teidadam―César be. Teida buje wuyawẽwẽap ekawẽn tag̃ g̃u kuka ajeku? ");
INSERT INTO myu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aceteida xe'e? Aceteida g̃u xe'e? — io'e ip. César ip o'jomuyat pin Jesus pe. Imẽnpit Jesus itaybit o'e wa'õmuwarurun ojuy ip iam. — Apẽnpuye eyju wa'õmuwarurun ojuy? — io'e. — Dinheiro isurũg̃at cuy epetojot owebe. Ojojo buk — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dinheiro isurũg̃at o'tojot ip cekay. — Abu-biõg̃buk ija be dinheiro be? — io'e. — Abu-butet tak ija be? — Jesus o'e. — César biõg̃buk, ibutet tak — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","— Cemuojuyjuy epeg̃ũm César be―wuyeipi kukat pe — io'e. — Deus pe dak cuy epeg̃ũm cemuojuyjuy — io'e Jesus. — Itaybitbin ma o'jede — io'e ip jewewebe. Iba'ore o'e ip cebe ya'õbu am. ");
INSERT INTO myu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceuyũ o'ju Jesus kay g̃ebuje bit. Tũybe wuye'ũ buje waram acejetait g̃u iãn o'e ip. O'jekawẽn ip ceweju. ");
INSERT INTO myu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","— Ocemutaybitbin'ukat — io'e ip. — Imẽn Moisés wuymutaybitbin: Iwag̃o e'ũ buje, jekitpit jewebumũn cuy jewag̃o'ũm tayxibuk eju itayxibuk i'it'et'ũm pima, i. I'itkap puje, iwag̃o'ũm ipot tieg̃ kuka o'e i'it, i. Imẽn Moisés o'g̃utaybin kuyje — io'e ip. — Imẽn e'em Deus ekawẽntup — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","— 7 be ikitpitpiyũ osodop ip — io'e ip. — Koapat o'jewebumũn. Ixe koapat'ũm jekpotpet'ũm puxen ma oe'ũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","— G̃ebuje ikitpit o'jewebumũn jewag̃o'ũm tayxibuk eju. Ixe tomujuat'ũm tak jekpotpet'ũm puxen ma oe'ũ. Imẽnpuxim ma oe'ũ wara'at'ũm ikitpit'ũm tomujuat'ũm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","— Ibocewi 7 beayũ soat o'je webumũnmũn ip jewag̃o'ũm tayxibuk eju―pũg̃ eju ma. Soat ip oe'ũ'ũ jekpotpet'ũm puxen ma. Soat oe'ũ ip pima, ayacat'ũm tak oe'ũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","— Waram ce'ũ'ũayũ etait puje, abu-tayxim xe'e je'e? — io'e ip. — Soat 7 beayũ o'jewebumũnmũn ip ceweju — io'e ip Jesus pe ya'õbuap ojuy. ");
INSERT INTO myu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","— Ijo'i g̃u eyju e'em iboam — io'e Jesus. — Cedag̃ g̃u eyju jewag̃uyg̃uy. Eyetaybit g̃u Deus ekawẽn. Eyetaybit g̃u Deus warara'acat podi ma ja'õbacaap kug̃ iam — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","— Waram jetait puje, wuyjuyũ jewebumũnmũn g̃u ip — io'e. — Kabi beat co'i ip je'e―Deus ekawẽn tojotjot'ukat co'i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","— Moisés emutupmubararaktup epetupcoco g̃u du―wuye'ũ buje waram acejetait iatup? — io'e. — Deus ekawẽn ibararak opop kadai o'jedipesop iaptup pe. Deus o'e Moisés pe: Õn Deus, i. Abraão itabut mabuk okay, Isaque dak, Jacó dak, i. Imẽn Deus o'e Moisés pe. Kuyje ixeyũ'ũm'ũm oe'ũ―Abraão'ũm, Isaque'ũm tak, Jacó'ũm tak. Imẽnpit: “Itabut mabuk ip okay,” io'e Deus — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","— “Itabut ip okay,” io'e Deus, waram g̃uto ip o'jetait puye. Ce'ũ'ũayũ g̃u itabut Deus kay―itabẽg̃ayũ acã. Cedag̃ g̃u jĩjã eyju e'em. “Wuye'ũ buje waram g̃u acejetait,” i te'e ma eyju e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés ekawẽn imutaybitbin'ukat kuy juk oajẽm Jesus kay. Jesus ekawẽn o'ya'ĩjo―ya'õbu ojuyayũ eju iap ekawẽn. — Aiyuuui! Itaybitbit cĩcã o'jede — io'e jexeayũ be. — Moisés ade ma wuymutaybitbin cedag̃ wuyeku am Deus etabutpe iam — io'e Jesus pe. — Pu g̃u ixe ekawẽn'in yobog̃ cĩcã wuymukũyjobit am? — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","— Imẽn Moisés o'e — io'e Jesus. Eya'õpicũg̃cũg̃ cuy epesop, Israel naxeg̃ebitbit, i. Pũg̃ ma Deusat, i. Ixe kay wuyetabut, i. Ka'ũmg̃u wara'at deus, i. ");
INSERT INTO myu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Deus cuy ikukpin cĩcã epejukuk, i. Warara'acat kukpinap podi ma juy epejukuk. Eyxe ikukpin cĩcã buye, ibikuyap tag̃ cuy epeku soat em; xipacat kay dak cuy epesop g̃ebum; kapikpig̃ tak cuy epesop cebeam, i. Imẽn Moisés wuymutaybitbin — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","— Wara'at tak ixe ekawẽn'in yobog̃ cĩcã wuymukũyjobit am. Imẽn o'e: Xipan cuy warara'acat epejukuk eyewekukap puxim ma, i — io'e Jesus. — Ade ma Moisés wuymutaybitbin. Ijop ekawẽn'in kay bit cuy kũyjobin cĩcã ma epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","G̃ebuje Moisés ekawẽn imutaybitbin'ukat o'e: — Kariwa — io'e Jesus pe — Etaybitbit ma ẽn e'em — io'e. — Icẽmãn ẽn e'em — io'e. — Pũg̃ ma Deusat omuy. Ka'ũmg̃u wara'at deusat — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","— Ikukpin cuy Deus ajukuk warara'acat kukpinap podin ma — io'e. — Wuyxe ikukpin puye, ibikuyap tag̃ cuy ajeku soat em; xipacat kay dak cuy ajop g̃ebum; kapikpig̃ tak cuy ajop cebeam — io'e. — Xipan tak cuy warara'acat ajukuk wuyewekukap puxim — io'e. — Deus icokcok e'em wuywebe wũnca ũm puje paĩyũ be imupik am cetabixe. Ibodi ma bit icokcok e'em wuywebe xipan warara'acat kuk puje wuyewekukap puxim — io'e. — Wuyxe ikukpin cĩcã bima dak icokcok cĩcã e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ya'õetaybit o'jede iap co buje, Jesus o'e cebe: — Wũy g̃u ẽn Deus ka wi — io'e. — Jekũyjobin ojuy ẽn Deus a'õ kay — io'e. — Abu be jede but Jesus pe? — io'e ip soat ya'ĩjo'ibiyũ Jesus edeap co buje. ");
INSERT INTO myu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ibocewi Jesus wuyjuyũ mutaybitbin o'e Deus eju kawẽnwẽnap'a be―yabog̃at'a be. — Apẽnpuye “Cristo Davi naxeg̃ebit―Deus emunaẽ,” i'e'em Moisés ekawẽn eymutaybitbin'ukayũ? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","— Davi o'jekawẽn Deus biõg̃buk a'õbi. Imẽn ixe e'em ixe emudupmubararaktup pe: Cristo okukat―Deus emunaẽ, i. Deus o'jekawẽn Cristo be, i. Xik'i Ekay itakomaayũ a'õbacaap cuy og̃u'ũm, io'e, i. A'õ kay kũyjobin jeedop ip, io'e, i. Ẽn ixeyũ kukan'ũm pima oxema juy eg̃uy, io'e, i. Imẽn Davi kuyje o'tupmubararak Deus biõg̃buk a'õbi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","— “Ẽn ma okukukat,” io'e Davi Cristo be―Deus emunaẽ be. Imẽnpuye ibapuk ma wuyxe Davi naxeg̃ebit acã g̃u Cristo osunuy―Davi kukukat tak osunuy — io'e Jesus. Adeayũ icokcok cĩcã ip o'e Jesus ekawẽn co buje. ");
INSERT INTO myu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","— Moisés ekawẽn eymutaybitbin'ukayũ ekukuap puxim g̃u juy epeku — io'e Jesus adeayũ be. — Eymug̃uykukukum ip. Jesay iwaruat kug̃ ip jekukum warara'acat muyak am jekay. Jewexe ip ya'õbuyxi jĩjã. Soat etabutpe ce'aweroroap pe warara'acayũ ya'õbuyxim jeweju ip kawẽnwẽn pima, icokcok e'em ip — io'e. — Kariwawayũ abikbikap pe yabik pin ip Deus eju kawẽnwẽnap'a be. Petatam pima icokcok e'em ip koap jekõn ãm kariwawa ekõn'ũm awap ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","— Itayxibuk mug̃uykukukum ip ibubut pu am — io'e. — Ibun ma ip jewexe kawẽnwẽn Deus eju “Teku ya'õbuyxiat” i'e ojuy warara'acat pe. Deus pit ipiat supi'ajoat ixeyũ be warara'acat pe ipiat supi'ajoat podi ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","G̃ebuje Jesus oajẽm dinheiro mũn'a kay. Ya tẽg̃ ma oabik Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Iboce ajẽmjẽmayũ jojom o'e ya be jedinheiro mõg̃mõg̃ayũ jojom. Ibubut adeayũ dinheiro mõg̃mõg̃ ip o'e ade. ");
INSERT INTO myu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","G̃ebuje itop'ũm e'ũ'ibit oajẽm―ibubut kug̃'ũmat. Dinheiro isurũg̃at o'jomõg̃ ya be xepxep. Ixeyũ xepxep isurũg̃at tei'ĩt ma osodop. ");
INSERT INTO myu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Ak'i juy epesop ixe ayacat kay―ibubut kug̃'ũmat kay―itop'ũm e'ũ'ibit kay — io'e. — Ixeyũ ma ade jexewiat'in o'jomõg̃ dinheiro ibubut adeayũ — io'e. — Deus xe bit ade g̃u o'jomõg̃ ip. Ade kug̃ mabuk ip. Ixe ayacat yopĩt ma o'jomõg̃ jedinheiro. Deus xe bit ade jĩjã o'jomõg̃, soat jexewiat o'jomõg̃ puye―jexat puap ojuy ma o'jomõg̃ puye — io'e. — Ajo-kug̃ g̃asũ ixe ayacat? Ka'ũma kug̃ ma! Imẽnpuye Deus xe ixe ayacat warara'acat pe o'jomõg̃iap podi ma o'jomõg̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Deus eju kawẽnwẽnap'a bewi Jesus cẽm puje, ceweju etaybitbinat o'jekawẽn ceweju uk'a jojom pima. — Kariwa, ak'i juy ece! — io'e. — Wita'a yabog̃ cĩcã g̃u du? Uk'a yadip cĩcã! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","— Ite'a yadip cĩcã du exe? Xipat cĩcã du ite'a exe? — io'e Jesus. — Xepxep'a jewa'atẽg̃tẽg̃ g̃u je'e wita'a. Soat'a je'aedu — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","G̃uyjom Jesus oabik Oliveira dip'a bicũg̃pe―co'a bicũg̃pe. Oabik Deus eju kawẽnwẽnap'a weg̃ũn―yabog̃at'a weg̃ũn. Ebadipdip ceweju etaybitbinayũ o'jekawẽn ceweju. Jag̃epũg̃ pima Pedro o'jekawẽn ceweju, Tiago dak, João dak, André dak―ebadipdip. ");
INSERT INTO myu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","— Pug̃ũn soat'a je'aedu? Ajo je'bapuk iboap em pima? Ajo g̃ubapuk Deus je'aedu awap? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","G̃ebuje Jesus ixeyũ o'g̃utaybin. — Adeayũ omuyku “Deus omudot,” i napa ma e'em warara'acayũ be. “Jesus Cristo õn,” i napa ma je'e ip soat pe. Ixeyũ ade g̃ug̃uykuku. Imẽneju eyday'em'um cuy epesop ixeyũ be eymug̃uykukuap puxim! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","— “Jenopag̃õg̃õm ip ijoxĩn ma,” i warara'acayũ e'em pima, “Jenopag̃õg̃õm ip wũyat eipi be,” i'e'em pima dak, eypararam g̃u juy epesop. Imẽn cuy je'bapuk. Imẽnpit soat puk oi'ũm g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","— Pũg̃ eipi watwat nopag̃õg̃õm je'e wara'at eipi watwat eju. Pũg̃ ka watwat nopag̃õg̃õm je'e wara'at ka watwat eju. Ipi jexixi ijoce, iboce dak soat ka dag̃. Reren cĩcã je'e ip soat ka dag̃. Yopĩt ma ipiat supi'ajo ip koam ipi dag̃ayũ. I'itpin'isumapi jo'ma je'e koam. G̃uyjom pit ipiat supi'ajo jĩjã ma ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","— Eyday'em'um cuy epesop ixeyũ be eymug̃uykukuap puxim — io'e. — Eykay itakomaayũ jeydaomũn. Jeydujowat ip ibimãmãayũ ekawẽn coco'ukayũ be. Jeymupokupok ip Deus eju kawẽnwẽnap'a be. Jeydujowat ip iecug̃apyũ etabixe, ipi kukukayũ etabixe dak, eyetabut okay buye. Kawẽn idipat epeg̃uwẽn cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","— Kawẽn idipan soat ka dag̃ayũ mukũyjojom'ũm pima, ipi buk i'ũm g̃u. ");
INSERT INTO myu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jeydaomũn ip. Ika kukukayũ etabixe ip eydujowat puje, eyag̃uybabi'ũm g̃u juy epesop. “Apẽn paxi oce'e?” i'ũmg̃u juy epe'e. Ixeyũ etabixe buje, Deus ma jeymutaybin apẽn epe'e iam. Eya bewi g̃u juy epeg̃uwẽn. Deus biõg̃buk cuy jeymutaybin imuwẽn ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","— Ixe kabia bima adeayũ jebadipyũ kay itakoma je'e, ixeyũ webekitkit puye. Iwag̃o jekitpit je'g̃ũm cekay itakomaayũ be yaoka am. Ikitpit tak jewag̃o je'g̃ũm yaoka am. Cebayũ dak jekpot je'g̃ũm cebe ip yaoka am. Ipotpetayũ dak itakoma je'e jebay kay. Jebay je'g̃ũm ip cebe yaoka am — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","— Soat itabut'ũmayũ itakoma jĩjã je'e eykay, eyetabut okay buye. Ipiatpi'ajojom ma'g̃u eybu'u g̃u okay bima, Deus jeydaxijo. Jeydakoy jexeam — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","— Ipararu jĩjãat epejojo — io'e. — Imõg̃piat pe jeedop―Deus eju kawẽnwẽnap'a be — io'e. — (Eyetaybin cuy epesop ijudup coco'ukayũ!). Ipararu jĩjãat ig̃o'a be bima, jenapõn cuy ip co'a bicũg̃ kay Judéia eipi watwat — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","— Eyduk'a eakiju bima, epeõm g̃u juy eyduk'a be yabeat pum — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","— Eykat pe bima, epeyepit g̃u juy eyduk'a kay eyesay bum — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","— Ixeyũ kabia dag̃ iba'ore jĩjã je'e yukreg̃ayũ enapõn ãm, je'it mutitinayũ enapõn ãm tak. ");
INSERT INTO myu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Ihi bima g̃u juy ixeyũ eg̃udot ipiatpi'ajo an ocewebe,” i juy epe'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","— Ixeyũ kabia dag̃ soat ipi dag̃ayũ ipiat supi'ajojo jĩjã. Ibitpi bit ipiat asupi'ajo g̃u Deus pe ipi mubapuk isum — io'e. — Waram pit ibitpi g̃u acesupi'ajo―ixeyũ kabia dag̃ acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","— Deus pe ipiatpi'ajojoap kabia mu'ũm'ũm pima, ka'ũma kuka o'jewedaxijo. Imẽnpit: “Pũg̃pũg̃ kabia acã ipi watwat supi'ajojo,” io'e Deus kuy bima. “Pũg̃pũg̃ kabia acã,” io'e Deus, taxijo am o'taẽ'iayũ ikukpin cĩcã cexe buye — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","— Wara'acat je'e eywebe napa ma “Ak'i! Teku Cristo―wuydaxijojo'ukan Deus emunaẽ,” i. “Ak'i! G̃oku Cristo,” i dak je'e. Imẽn i'e buje, eyetabun g̃u juy epesop ixeyũ ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","— Jewexe Deus emunaẽhẽyũ jebapuk, jewexe Deus ekawẽn muwẽnuwẽn'ukayũ dak. Wuymucoatcoanap g̃ubapuk ip Deus emunaẽhẽyũ mug̃uykuku ojuy. Deus a'õbacaap g̃ubapuk ip imug̃uykuku ojuy. ");
INSERT INTO myu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","G̃uyjom jajẽm ip adeayũ mug̃uykuku ojuy iap kuy og̃uwẽn eywebe. G̃ebu'i epe'e wekawẽn kay ixeyũ be eymug̃uykukuap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","— Ipiatpi'ajojoap kabia kap puje kabi beacat muycemcemap iaruaru je'e — io'e. — Kaxiepiat kaxiepi g̃u je'e. Kabiok je'e. Kaxiamat tak kaxiam g̃u je'e. Kabiok je'e. Kasopta dak ida'at kabi kadiwi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","— G̃ebuje okop ipi kay. Kabikerereat tag̃wi okop. Soat wag̃o õn. Wa'õbacaap kug̃ okop, odipap kug̃ tak. Soat ipi dag̃ayũ je'e “Jesus warara'acat podi ma ya'õbaca,” i. “Warara'acat podi ma idip,” i je'e ip. “Abu ixe jo'iat? Ka'ũma ma,” i je'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","— G̃ebuje Deus jekawẽn tojotjot'ukayũ g̃uju soat tag̃wi. Ixeyũ g̃uju jemunaẽhẽyũ kay. Jemunaẽhẽyũ ip g̃u'awero soat tag̃wi. Kabi dag̃wi ixeyũ g̃u'awero ip, ipi dag̃wi dak — io'e. Jesus waram jedocap o'g̃uwẽn jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","— G̃ebum cuy epesop wajẽmap kay figueira'ip kay g̃ebum pima — io'e. — Figueira'a bikit cẽm puje, “Koato ijasũn ma,” i'e'em eyju, dup cẽm pima dak — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","— Imẽnpuxim soat ipi dag̃ayũ ipiatpi'ajojom pima, “G̃axĩn ma Jesus jajẽm,” i juy epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","— G̃asũayũ'in iboap coco ip je'ũ awap. G̃ebum cuy epesop iboap kay! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","— Kabi i'ũm, ipi dak. Wekawẽn pit i'ũm g̃u. Wekawẽn kayayũ bit soat em jeedop — io'e. Imẽn Jesus o'jekawẽn jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","— Itaybit g̃u ip wajẽmap kabiam, ipiatpi'ajoap kabiam tak — io'e. — Deus ekawẽn tojotjot'ukayũ itaybit g̃u ibo kabiam. Õn Deus ipot. Õn tak wetaybit g̃u ibo kabiam. Webay acã itaybit — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","— Eyetaybit g̃u puje oajẽm iam. Imẽneju epejowiwi juy ag̃. Wajẽmap wiwim cĩcã juy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","— Wajẽmap kariwa epicat puxim — io'e. — Kariwa o'jẽm jeduk'a bewi. “Ijoce ma epesop,” io'e jebuywatwat'ukayũ be — io'e. — “Epeyekapik oka be,” io'e cebe ip — io'e. — Jeduk'a exĩntabi wiwi'ukat pe “Ijoce ma eg̃uy warara'acat pe obubut tujupa'umap puxim,” io'e kariwa — io'e. — “Wepicap wiwim cuy epesop,” io'e cebe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","— Ixe kariwa buxim õn tak — io'e. — “Pug̃ũn paxi waram wekariwa je'pit?” i eyju e'em. Katpuje paxi ocepit. Iximadakpe paxi ocepit. Kabiakay paxi ocepit. Kabia'isu paxi ocepit. Eyetaybit g̃u pũg̃ũn ocepit iam — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","— Imẽnpuye juy epejowiwi ag̃. Ocepicap wiwim cuy epesop. Obu'u jĩjã eyxen ma eydobuxik am wepit puje! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","— “Epejowiwi juy ag̃,” i õn e'em soat pe. “Epejowiwi juy ag̃,” i õn e'em eywebe dak — io'e Jesus jeweju etaybitbinay ũ be. ");
INSERT INTO myu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xepxep kabia peta e awap cekay itakomaayũ Jesus daomũn ojuy ip―Páscoa epeta e awap. Ixe epeta bima Judeuyũ pão'a o'o'uk ip osodop―yamuyuhuhuaptõmtẽm'ũmat'a. Ijop epeta mug̃ẽg̃ẽm pima apẽn Deus wuydobuyũ'ũm'ũm o'tujujẽm Egito eipi bewi iap kay g̃ebum'uk ip osodop. Iba'arẽm Jesus daomũn ojuy ip. Paĩyũ kukukayũ Jesus aoka ojuy osodop ip, Moisés ekawẽn imutaybitbin'ukayũ dak. Jesus kay itakoma osodop ip. ");
INSERT INTO myu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","— Petatam pima bit Jesus ataomũn g̃u adeayũ be wuyaokaap puxim — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus Betânia ka be osunuy. Simão duk'a be osunuy―ierep tũibit tuk'a be. Jekõnkõn pima ayacat oajẽm Jesus kay. Timũn'a kug̃ oajẽm―wita'a mug̃ẽg̃ẽ'a kug̃. (Wita'a butet alabastro i osunuy). Tide'oati otinuy ya be. (Tide'oati butet nardo i osunuy). Judeuy'u ce'ũat mude'o'o'uk ip osodop nardodim. Tideibog̃ cĩcã otinuy. Ayacat oajẽm Jesus kay. Timũn'a ũ o'su'ũkaka. Tideo'ati o'tidi Jesus a be Jesus ikukpin cĩcã cexe buye. ");
INSERT INTO myu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iboceayũ bit pũg̃pũg̃ itakoma o'e ayacat kay ixe o'tidi buye. — Ak'i! Etidi! — io'e ip. — Etimukereren — io'e ip ayacat pe. ");
INSERT INTO myu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","— Tide'oati deida buje, kajuk teibog̃ ejat! Ade kuka juk dinheiro isurũg̃at ejat prata mug̃ẽg̃ẽ — io'e ip. — 300 be kuka juk ejat! Tadaybotbocayũ be kuka juk dinheiro eg̃ũm — io'e ip cebe. Ya'õpurug̃ ip ayacat o'g̃ukorẽm o'timukereren puye. ");
INSERT INTO myu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","— Ãg̃ jeenuy ayacat jekpiwan — Jesus pit o'e. — Epeg̃ukorẽm g̃u juy — io'e. — Cekaykay g̃u! Xipacan ma teku o'e owebe! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","— Tadaybotbocayũ soat em ma eyxe — io'e. — Eybikuy bima, ixeyũ buywan put eywebe. Õn pit soat em g̃u og̃uy eyxe. Soat em g̃u xipacan ey'e but owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","— Ite ayacat tide'oati kug̃ osunuy. Tiũm put owebe. Ojebit o'g̃ude'on, oje'ũ g̃u buk ma'g̃u. Wetabẽg̃ pima ma kuy omude'on okot awap — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","— Okay itabucayũ kawẽn idipat g̃uwẽnuwẽn soat kaka dag̃. Apẽn ite ayacat o'tidi wa be iap g̃uwẽnuwẽn tak ip soat kaka dag̃. Soat ka watwat g̃ebum je'e apẽn ixe o'e iap kay. G̃ebum cuy epesop iboap kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","G̃ebuje Judas Iscariotes o'ju paĩyũ kukukayũ kay. — Jesus cuy og̃ũm eywebe yaoka am — io'e cebe ip. Ixe Judas Iscariotes 12 beayũ'in osunuy. ");
INSERT INTO myu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ixe ekawẽn co buje, icokcok cĩcã o'e ip paĩyũ kukukayũ. — Dinheiro juy oceg̃ũm ewebe iũmapteim — io'e ip Judas pe. Imẽnpuye “G̃asũ du Jesus ũm put owebe paĩyũ kukukayũ be?” i'e'em jewebe ma oeku. Cekay itakomaayũ be Jesus ũmap kudadam oeku. ");
INSERT INTO myu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jesus o'jekõn jeweju etaybitbinayũ eju Páscoa epeta bima. Páscoa epeta bima Judeuyũ ovelha aokaka'uk osodop ip―koapat kabia bima. Soat ip pão'a o'o'uk osodop―yamuyuhuhuaptõmtẽm'ũmat'a. Ixe kabia be ceweju etaybitbinayũ o'jekawẽn Jesus eju. — Poce wuyxan oceg̃ug̃ẽ Páscoa epeta be i'o am? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","G̃ebuje Jesus xepxepayũ o'g̃uju Jerusalém ka kay jeweju etaybitbinayũ. — Epeju juy ikabog̃atka be — io'e cebe ip. — Ag̃okatkat epetobuxik―idibi mũn'a kug̃at. Ceweju juy epeju — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","— Uk'a be iõm puje, epeõm cuy ceweju — io'e cebe ip. — “Ocekariwa e'em: ‘Apu'a be juy ocekõn Páscoa kabia oweju etaybitbinayũ eju?’ i,” i juy epe'e ig̃o duk'a iwat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","— Ixe jeduk'a yabimubapuk eywebe―umat'abi, yabibog̃at'abi — io'e. — Kuy mesa kake ig̃o'abi be, abikbikap tak. Soat ixipan je'e kuy — io'e. — Ig̃o'abi be ovelha juy epejoyoy wuywebe i'o am Páscoa kabia be — io'e. — Ha'a — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","G̃ebuje ceweju etaybitbinayũ o'ju ikabog̃atka be. Soat o'tobuxik ip apẽn cuk cebe ip Jesus o'e iap tag̃. Ig̃o'a be ovelha ip o'joyoy Páscoa kabia be i'o am. ");
INSERT INTO myu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kabiog̃ pima Jesus oajẽm ig̃o'a be jeweju etaybitbinayũ eju―12 beayũ eju. Oabik ip mesa akokoreren. ");
INSERT INTO myu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jekõnkõn pima Jesus o'jekawẽn ceweju ip. — Icẽmãn õn e'em eywebe — io'e. — Pũg̃ ey'in oũm okay itakomaayũ be waoka am―oweju jekõnkõnat ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ig̃uycũg̃cũg̃ o'e ip. — Õn xe'e? — io'e'e ip pũg̃pũg̃pũg̃. ");
INSERT INTO myu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","— Pũg̃ eyju'in — io'e Jesus. — Oweju prato be pão'a o'yamuerep'iat ma — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","— Soat wag̃o õn. Apẽn oje'ũ iaptup tag̃ oje'ũ―Deus ekawẽntup tag̃ — io'e. — Karem g̃u ipiat supi'ajo oũmat pit. Xipat kuka adi a'g̃u ixe bit o'jebapuk'ũma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","— We'ũap kay g̃ebum cuy epesop — io'e Jesus cebe ip. Jekõnkõn o'e jeweju etaybitbinayũ eju. Jekõnkõn pima Jesus pão'a o'yabu. — Bay, ẽn xipat — io'e. — Pão'a eyaũm ocewebe — io'e Jesus Deus pe. O'yamuweka. O'yaũm cebe ip. — Juku, epeya'o — io'e cebe ip. — Ite ojebit — Jesus o'e. — Pão'a muwekaap puxim ip obamupaya — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tikõnkõnap o'jat. Uva'abidi o'tinuy tikõnkõnap pe. — Bay, ẽn xipat — io'e. — Uva'abidi etiũm ocewebe — io'e Deus pe. Tikõnkõnap o'g̃ũm cebe ip. Soat ip o'tikõn. ");
INSERT INTO myu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","— Juku. Epetikõn. Ite odoy — io'e Jesus. — We'ũ buje odoy jedoyekoreren “Adeayũ bewi ikẽrẽat oju'uk,” io'e Deus puye — io'e. — Imẽnpuye Deus adeayũ g̃uisun. Cũg̃ ma jeedop ip cexe―Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","— Icẽmãn õn e'em eywebe. Waram g̃u otikõn uva'abidi soat ipi watwat Deus a'õ kay kũyjobit'ũm pima. Soat ipi watwat ya'õ kay kũyjobin pima bit, tiisuati otikõn uva'abidi — io'e Jesus. Imẽn Jesus o'e cebe ip: — We'ũap kay g̃ebum cuy epesop — i. ");
INSERT INTO myu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","G̃ebuje soat ip o'jebibododon Deus kay. Umat'a bewi ip o'kop. O'ju ip co'a bicũg̃pe―Oliveira dip'a bicũg̃pe. ");
INSERT INTO myu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oajẽm ip Oliveira dip'a bicũg̃pe. Jesus waram o'jekawẽn ceweju ip. Soat eyju operem — io'e. — Epeyenapõn — io'e. — Imẽn Deus ekawẽntup omuwẽnuwẽn: Ovelhayũ kukukat oyaoka, i. Soat ip jepõg̃põg̃ iõhõyũ, i. Imẽn Deus ekawẽntup omuwẽnuwẽn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","— Imẽnpit we'ũap tomukadi Deus waram g̃uto omutait. Õn ovelha kukukat puxim. Okay itabucayũ ovelhayũ buxim. Oju eywap Galiléia eipi be — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","— Soat ip jepere obureyũ. Õn pit jepere g̃u — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","— Tapu, icẽmãn õn e'em ewebe — io'e Jesus Pedro be. — Ijop exima ma: “Obure g̃u teku,” i napa ma ece'e ebapũg̃ em — io'e. — Xepxep em sapokay ede awap: “Obure g̃u teku,” i napa ma ece'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","— Oce g̃u ma buk “Obure g̃u teku,” i, eweju waokaap puxim — io'e Pedro. Ya'õpurug̃ o'jede. Soat cewejuayũ imẽn o'e'e. ");
INSERT INTO myu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","G̃ebuje o'ju ip kadaihiaptip kay. Kadaihiaptip putet Getsêmani i osunuy. — Jocebuku epabikbik — io'e Jesus. — Deus eju buk õn jekawẽn — io'e jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ibocewi Jesus o'ju kawẽn ãm Deus eju. Pedro o'tujowat jeweju, Tiago dak, João dak. Ig̃uycũg̃ cĩcã o'e. Yag̃uy'ũm o'e ipiatpi'ajoap kay. ");
INSERT INTO myu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","— Je'ũmayũ jo'i õn og̃uycũg̃ap pibun — io'e. — Ag̃ cuy epesop ijoce — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bosusu Jesus o'ju. Iboce o'jepo ipi ju jeg̃uycũg̃ap pibun. G̃ebuje o'jekawẽn Deus eju. — Bay — io'e. — Odaxijom ece we'ũap puxim, ẽn odaxijo pin pima — io'e Deus pe. — Ipiat esupi'ajoat g̃u owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","— Bay — io'e. — Webay ẽn. Soat iba'ore g̃u ewebe. Omuwedem ece ip owebe ipiat'ajoap puxim. Wa'õbi bit we'ũ pin g̃u. Ẽn ebikuy bima bit, oje'ũ — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","G̃ebuje ebapũg̃ayũ kay o'jepit―Pedro kay, Tiago kay dak, João kay dak. Ixet ma ip o'tobuxik. — Simão Pedro — io'e. — Exet ma du? — io'e. — Pũg̃ hora dak tu ag̃ pa'ore ewebe? ");
INSERT INTO myu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ag̃ cuy epesop! — io'e cebe ip ebapũg̃ayũ be. — Xen g̃u juy epesop. Deus eju juy epeyekawẽn eyewebe ikẽrẽat mug̃ẽap puxim―eywee Satanás a'õ kay kũyjobicap puxim — io'e. — Eybu'u jĩjã ikẽrẽat mug̃ẽ ãm. Imẽnpit ikẽrẽat epeg̃ug̃ẽ eya'õbaca'ũm puye. Imẽneju Deus eju juy epeyekawẽn ixe a'õbacaan kug̃ eyeku am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","G̃ebuje bosusu o'ju waram. Kuyat ekawẽn puxim waram o'jekawẽn Deus eju. ");
INSERT INTO myu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesus waram o'jepit ebapũg̃ayũ kay. Ixet ip o'tobuxik ma'g̃uto. Itaxeebaca o'e ip xet pibun. — Apẽn tak Jesus pe acejede? Wuyxexet teku wuydobuxik — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesus waram o'jepit bosusu. Waram o'jekawẽn Deus eju. Waram g̃uto o'jepit ebapũg̃ayũ kay. — Eyxet mabuk tu? — io'e cebe ip. — Jebodoydoy mabuk tu eyju? — io'e. — Kuy o'e xexecap! Soat wag̃o õn. We'ũap kabia kay õn ajẽm — io'e. — G̃asũ oũm ip ikẽrẽat mujurũg̃rũg̃'ukayũ be waoka am. ");
INSERT INTO myu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Epe'ãy! — io'e cebe ip. — Ak'i juy epe'e! Oũmat omuyku! G̃a'a atopabijuk ip — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","44","Judas oajẽm Jesus kay. Yajẽm puje, Jesus kawẽnwẽn mabuk osunuy jeweju etaybitbinayũ eju. Ixe Judas 12 beayũ'in osunuy. Jesus eju jekuku'uk osunuy. — Wuyajẽm puje juy owebe yag̃obukõn'ibit cuy epejat — i juk o'e ixe Judas jewejuayũ be―Jesus aoka ojuyayũ be. — Cem ma juy epetujowat — i juk o'e cebe ip. Ixe Judas oajẽm Jesus kay. Ceweju adeayũ oajẽm paja kukug̃, jeba'ip kukug̃ tak. Paĩyũ kukukayũ ixeyũ o'g̃uju Jesus daomũn ãm, Moisés ekawẽn imutaybitbin'ukayũ dak, Judeuyũ kukukayũ dak. ");
INSERT INTO myu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yajẽm'isum ma Judas o'ju Jesus kay. — Ocemutaybitbin'ukat! — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judas eju oajẽmiayu Jesus o'jat. Cem ma o'taomũn ip. ");
INSERT INTO myu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Imẽnpuye Jesus ejuat jepaja o'ju'uk iyuk pewi. Paĩyũ kukukayũ ebekit g̃uybuikibi o'sug̃uybuikibika. O'sug̃uybu'uk pajam. ");
INSERT INTO myu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","G̃ebuje Jesus o'jekawẽn oajẽmiayu eju. — Eyju dak epesot odaomũn ãm paja kukug̃, eyba'ip kukug̃ tak ibabikurukat taomũnap puxim — io'e cebe ip. — Ibukurukat g̃u õn pit! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","— Ade kabia adi og̃uy eyxe. Imukũyjojom'uk cuk adi og̃uy Deus eju kawẽnwẽnap'a be―yabog̃at'a be — io'e. — Ig̃o'a be g̃u bit eyju odaomũn. Kuy bima o'tupmubararak ip Deus ekawẽntup apẽn ip odaomũn iaptup — io'e. — “Ibabikurukat taomũnap puxim ixe taomũn ip,” i'e'em ig̃odup — io'e. — Imẽn ma odaomũn ip g̃asũ dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","G̃ebuje soat ip Jesus o'jepere ceweju etaybitbinayũ. Soat ip o'watwat. ");
INSERT INTO myu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesus daomũnmũn ip pima ag̃okatkat o'ju Jesus nomuju―yaypan'isuat. Jeekabek kug̃ acã oeku. Iekabek o'jat ip Jesus daomũnayũ. Yaypan'isuat taomũn ojuy ip. ");
INSERT INTO myu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Imẽnpit jeekabek o'suiwat jedaomũnap puxim. Toti'ũm ma o'jenapõn jeparara pibun. ");
INSERT INTO myu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","G̃ebuje taomũn'ibiyũ Jesus o'tujowat paĩyũ kukukat kay. Wũy ma Pedro o'ju Jesus nomuju jeparara pibun. O'ju paĩyũ kukukat tuk'a kay. Imẽnpit tuk'a naxĩnõm pe osunuy. Xik'i osunuy sorarayũ parakpe. Jewewewem o'e daxa etako be. G̃ebuje paĩyũ kukukayũ o'je'awero ip Judeuyũ kukukayũ dak, Moisés ekawẽn imutaybitbin'ukayũ dak. Ixeyũ ma ibimãmãayũ coco'ukayũ osodop ip. O'je'awero ip ibimãmãayũ ekawẽn cocoap'a be. O'je'awero ip Jesus xipat g̃u iap mubapukap ojuy yaoka am. ");
INSERT INTO myu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ibimãmãayũ ekawẽn coco'ukayũ warara'acayũ kudadam o'e ip Jesus muymuy am. Ibikuy o'e ip xepxepayũ be pũg̃ tag̃ ma Jesus muy am. Jesus aoka ojuy ip. ");
INSERT INTO myu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Adeayũ napa ma ip Jesus o'yawẽg̃mukẽrẽrẽrẽn. Imẽnpit pũg̃ tag̃ g̃u o'yawẽg̃mukẽrẽrẽrẽn ip―wara'at tag̃tag̃tag̃ ma. Jesus muymuy jĩjã o'e ip. ");
INSERT INTO myu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Warara'acayũ imẽn napa ma Jesus o'yawẽg̃mukẽrẽrẽn soat etabutpe. ");
INSERT INTO myu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","— “Ijop'a Deus eju kawẽnwẽnap'a oyamu'ũm―ijodiat emuamuy'a oyamu'ũm,” i kuy juk o'e ite ma — i napa ma o'e ip. — “Xepxep xet kap puje wara'at'a oyamuy,” i kuy juk o'e ite — io'e ip napa ma. — “Ijodiat emuamuy'am g̃u je'e,” i juk o'e — i napa ma o'e ip. — Imẽn ixe ekawẽn oceya'ĩjojo — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Imẽnpit pũg̃ tag̃ g̃u ip o'yawẽg̃mukẽrẽrẽn―wara'at tag̃tag̃tag̃ ma. ");
INSERT INTO myu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ixeyũ ekawẽn co buje paĩyũ kukukat o'ãy soat wap jekawẽn ãm Jesus eju. — Apẽnpuye ecede g̃u awẽg̃mukẽrẽrẽnayũ kay? — io'e. — Icẽm tu ip e'em? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Imẽnpit Jesus mũg̃ ma osunuy. O'jede g̃u. — Ẽn tu Deus emunaẽ? — io'e. — Soat wuyju e'em: “Ẽn xipat cĩcã,” i Deus pe. Ixe ipot tu ẽn? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","— Hm hm — io'e Jesus. — Ixe ipot ma õn — io'e. — Soat wag̃o õn — io'e. — Ojojom epe'e. Xik'i og̃uy Deus xe ibaat kadi. Ixe Deus soat podi ma ya'õbacaat. Cexe õn pima ojojom epe'e. Soat kukukan oce ixe eju. G̃uyjom ijodi waram ojot. Kabikerereat tag̃wi okop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Iboap co buje paĩyũ kukukat jesay o'g̃uwek jetakoma pibun. — Tũybe Deus jo'i õn iãn teku e'em — io'e. — Kuy epeya'ĩjojo ixe ekawẽn — io'e. — Warara'acayũ g̃u ajokudada ixe awẽg̃ mukẽrẽrẽn ãm. Deus muymuy teku — io'e. — Apẽntak ace'e cebe? — io'e cebe ip. — G̃a'a ayaokaat — io'e ip. — Ikẽrẽat kug̃ teku Deus xe — i napa ma o'e ip ibimãmãayũ ekawẽn coco'ukayũ. ");
INSERT INTO myu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jesus o'g̃uxiuxi ip pũg̃pũg̃ ixeyũ'in jetakoma pibun ma. Jesus o'topamuekabek ip pag̃õm. O'yaokaka ip. — Abu aokakam i ece! — io'e ip iwaywayway am. Jesus pu buje sorarayũ dak jebum o'yaokaka. Soat tag̃ ma o'yaokaka ip. ");
INSERT INTO myu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro mabuk uk'a daxirõg̃ pe bima, paĩyũ kukukat puywatwat'ukat o'ju Pedro kay. Ayacat o'ju cekay. ");
INSERT INTO myu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ixe ayacat Pedro o'jojojo jewewewem daxa etako be. O'jeak cĩcã cekay. — Ẽn tak mo Jesus eju ejeku―Nazaré ka bewiat eju — io'e Pedro be ayacat. ");
INSERT INTO myu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","— Õn g̃u! Apên ẽn e'em? Ixe bure g̃u õn! — i napa ma o'e Pedro. Ibocewi Pedro o'ju uk'a ekorara exĩntabi be. Sapokay o'jede g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ixe ibuywatwat'ukat waram Pedro o'jojojo iboce. — Jesus bure tedaku! — io'e iboceayũ be. ");
INSERT INTO myu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Imẽnpit Pedro napa ma o'e g̃uto: — Ite bure g̃u õn — i. Ibũnbũn pima iboceayũ o'jekawẽn Pedro eju. — Ocetaybit ẽn. Ejojo oceju ceweju. “Ite bure g̃u õn,” i'ũmg̃u juy ece! — io'e. — Ẽn tak Galiléia eipi bewiat! — io'e. ");
INSERT INTO myu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","— Dapxi ẽn! — i napa ma o'e Pedro. — Ixe bure g̃u õn! Ceweju õn pit ocekuku g̃u — i napa ma o'e. — Õn icẽmãn e'em'ũm pima, Deus cuy ipiat supi'ajoat owebe — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sapokay waram o'jede g̃ebuje bit. Pedro Jesus a'õ kay o'jeg̃ebu. — Ijop exima ma: “Ite bure g̃u õn,” i napa ma ece'e ebapũg̃ em — i juk o'e Jesus cebe. — Xepxep em sapokay ede awap: “Ite bure g̃u õn,” i napa ma ece'e — i juk o'e Jesus cebe. Iboap kay o'jeg̃ebu Pedro. O'jewemug̃uycũg̃ cĩcã. O 'tõn. ");
INSERT INTO myu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kabia isum paĩyũ kukukayũ o'je'awero ip, Judeuyũ kukukayũ dak, Moisés ekawẽn imutaybitbin'ukayũ dak, ibimãmãayũ ekawẽn coco'ukayũ dak. O'je'awero ip jewawẽ ãm apẽn Jesus aceyaoka iam. Jesus o'subamukirikat ip. O'tujowat ip Pilatos kay―Judéia eipi kukat kay. Pilatos o'jekawẽn Jesus eju. ");
INSERT INTO myu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","— Ẽn tu Judeuyũ kukukat? — io'e Pilatos Jesus pe. — Ẽn imẽn e'em owebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jesus o'jomuymuy jĩjã ip Pilatos pe paĩyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","— A'õpicũg̃ cuy ece! Emuymuy jĩjã ip — io'e Pilatos Jesus pe. — Apẽnpuye ẽn jedem g̃u? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Imẽnpit Jesus mũg̃ ma osunuy. Imẽnpuye Pilatos yag̃uyabi'ũm o'e. — Apẽnpuye mũg̃ ma teku e'em? — io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Ag̃okatkat daomũnmũnap'a be osunuy―iecug̃ap ebekitkit eju jenopag̃og̃o'ibiyũ xe. Ibutet Barrabás i osunuy. Soat ip cuk wara'acat o'yaoka daomũnmũnap'a beayũ iecug̃ap ebekitkit eju jenopag̃og̃õm pima. Páscoa epeta bima iecug̃ap pũg̃ ma taomũnmũnat mujẽmjẽm'uk osunuy daomũnmũnap'a bewi. Adeayũ emuojuyjuy mujẽmjẽm'uk osunuy. ");
INSERT INTO myu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","11","G̃ebuje adeayũ o'je'awero Pilatos xe―iecug̃ap xe. — Ijop epeta bima taomũnmũnat mujẽmjẽm'uk eg̃uy — io'e ip. — Pũg̃ cuy eg̃ujẽm g̃asũ dak ocewebe, — io'e ip Pilatos pe. Paĩyũ kukukayũ itabutkarey o'e ip Jesus kay adeayũ cekay jĩjã buye. Imẽnpuye o'tujowat ip Pilatos pe. Pilatos itaybit osunuy paĩyũ kukukayũ itabutkarey Jesus kay iam. Paĩyũ kukukayũ kuy o'e adeayũ be: — Barrabás cuy epejoojuy Pilatos pe imujẽmãn daomũnmũnap'a bewi — i. — Judeuyũ kukukat mujẽmãn pin tu eyju owebe? — io'e Pilatos Judeuyũ be. — Ap! — io'e ip paĩyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","— Apẽntak oce ite ag̃okatkat pe―Judeuyũ kukukat i eyju e'emat pe? — io'e ma'g̃uto Pilatos adeayũ be. ");
INSERT INTO myu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","— Esubamupayaat korosa be imuy'ũ ãm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","— Apẽnpuye osubamupayaat? Ikẽrẽat o'jukuk g̃u teku―pũg̃ em tak ka'ũma! — io'e Pilatos. Imẽnpit big̃ ma ya'õberen o'jewãwã ip: — Esubamupayaat korosa be imuy'ũ ãm — i. ");
INSERT INTO myu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Imẽnpuye Pilatos Barrabás o'g̃ujẽmat daomũnmũnap'a bewi. O'g̃ujẽmat adeayũ mucokcokap ojuy. Jesus o'tujowacat sorarayũ be. — Jesus cuy epeg̃upok ixee mug̃ẽg̃ẽbum — io'e sorarayũ be. — Epesubamupaya korosa be imuy'ũ ãm — io'e cebe ip. Imẽn Pilatos o'e adeayũ mucokcokap ojuy. ");
INSERT INTO myu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","G̃ebuje sorarayũ Jesus o'tujowat iecug̃ap tuk'a kay. Tuk'a eaki be o'tujowat. Warara'acayũ o'takoy ip sorarayũ―jewejuacat'in ma. — G̃a'a ite ma ajowaywayway — io'e ip jebureyũ be. ");
INSERT INTO myu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iwaywayway am iekabek ip o'g̃uõm cebe―ipakpukg̃ũg̃ũnat. Widaohobune o'subunemuwakẽn ip yakoreren am. O'jomõg̃ ip yakoreren. ");
INSERT INTO myu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","— Ẽn ma Judeuyũ kukukat! — io'e ip iwaywayway am. — Warara'acat podi ma ẽn a'õbuyxi — io'e ip iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","O'yamupãupã ip im. O'g̃uxiuxi ip. O'jẽg̃'aecõg̃cõg̃ ip cewap iwaywayway am: — Soat podi ma ẽn a'õbuyxi — i'e'em cebe. ");
INSERT INTO myu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iwaywaywayap epere buje iekabek o'ju'uk ipakpukg̃ũg̃ũnat. Cesay ip waram o'g̃uõm cebe. O'tujujẽm ip uk'a eaki bewi ibamupaya am korosa be imuy'ũ ãm. ");
INSERT INTO myu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tujujẽm pima oajẽm ip ag̃okatkat kay. Ag̃okatkat ajẽmjẽm o'e kog̃ũnpi bewi. Ibutet Simão i osunuy. Cirene ka bewiat osunuy. Alexandre ebay osunuy, Rufo ebay dak. — Korosa juy ejukuk Jesus pe ikukap puxim — io'e sorarayũ ixe Simão be. ");
INSERT INTO myu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesus o'tujowat ip co'a kay. Gólgota i co'a butet osunuy. (Gólgota ce'ũat aririt'a iape wuya'õm). Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iboceat mirradup o'tupmuwekoy uva'abidi be wuypipimu'ũmaptim. — Juku! Etikõn — io'e ip Jesus pe. — Ap! — io'e bit. O'tikõn g̃u. ");
INSERT INTO myu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","G̃ebuje sorarayũ Jesus o'subamupaya ip korosa be. Tapoa o'jomõg̃ ip Jesus bu be, sui be dak. Korosa o'jomõg̃ ip ipikũykũy be. Imẽn ma o'subamupaya ip. Karatũg̃'a buximat'a ip o'yamuju ipi ju―yabararukat'a. O'yamuju ip Jesus esay bu am. Imẽn Jesus esay o'g̃u'ẽ'ẽ'ẽ ip jewewedag̃. ");
INSERT INTO myu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaxi jeum pima Jesus o'subamupaya ip korosa be―9 hora bima. ");
INSERT INTO myu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","— “Apẽnpuye dak o'subamupaya ip imuy'ũ ãm?” i je'e ip kapkapayũ — io'e Pilatos jewebe ma. Imẽnpuye o'tupmubararakat apẽnpuye o'subamupaya ip iaptup. “Judeuyũ kukukat teku” iaptup o'tupmubararakat Pilatos. O'tupmõg̃ ip korosa be Jesus abi ase. ");
INSERT INTO myu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesus pa mupayapayam pima xepxep ibukurukayũ dak o'subamupaya ip wara'at korosa be. Pũg̃ ma Jesus pa'at kadi osunuy. Wara'at iba'ũg̃at kadi osunuy. ");
INSERT INTO myu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Deus ekawẽn tup o'tupmubararak ip kuyje. Imẽn e'em ibodup: Ikẽrẽat mujurũg̃rũg̃'ukat kukap puxim ixe dak o'jukuk ip, i. Jesus pa o'subamupaya ip ijoptup ekawẽn tag̃. ");
INSERT INTO myu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","G̃ebuje korosa etako dag̃ kapkapayũ Jesus muymuy o'e. Jesus o'jowaywayway jĩjã ip. — “Deus eju kawẽnwẽnap'a oyamu'ũm―yabog̃at'a,” i juk ece — io'e ip cebe. — “Xepxep xet kap puje, wara'at'a oyamuy,” i juk ece — io'e ip Jesus pe iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","— Ecewedaxijo juy! Etaybitbit pima juy korosa ejuwi ekop e'ũap puxim — io'e ip cebe iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Imẽnpuxim paĩyũ kukukayũ dak Jesus o'jowaywayway jeweweju ma ip, Moisés ekawẽn imutaybitbin'ukayũ dak. — Teku warara'acayũ daxijojo'uk osunuy. Imẽnpit jewedaxijo ba'ore je'ũap puxim — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","— Teku juk o'e: “Deus emunaẽ õn,” i, “Judeuyũ kukukat õn,” i dak — i napa ma o'e ip. — Teku Deus emunaẽ bima, juy je'kop korosa ejuwi je'ũap puxim — io'e ip. — Ikop puje, bit kuka wuyetabut ace'e cekay — io'e ip jewewebe. Ceweju ibamupaya'ibiyũ dak Jesus o'jomuymuy jĩjã ibukurukayũ. ");
INSERT INTO myu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaxi wuyase bima kabiok o'e soat tag̃ Judéia eipi dag̃. Ibun ma kabiok oeku. Ebapũg̃ hora bun kabiok oeku. ");
INSERT INTO myu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Katpuje Jesus o'jewãwã ya'õberen. — Eloí, eloí, lemá sabactani? — io'e ja'õm. (Ijop ekawẽn, Deus, Deus, apẽnpuye ẽn opere iape wuya'õm). ");
INSERT INTO myu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iboap o'ya'ĩjojo ip iboceayũ. — Eya'õpicũg̃cũg̃ cuy epesop! Elias nomuwãwãm teku! — io'e ip, xipan g̃u ip o'jekũyjo buye. ");
INSERT INTO myu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iboceat o'jedau idibi bubuap munopapũn ãm uva'abidim―tideibog̃'ũmati. Ixe dak idibi bubuap o'jomõg̃ ip'abi be. G̃ebuje o'yopmuyu Jesus pe timutitit am. — Mẽnpuk! — io'e. — Omuy paxi Elias imukop am korosa ejuwi — io'e. ");
INSERT INTO myu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus o'jewãwã ya'õberen. Pog̃. Oe'ũ. ");
INSERT INTO myu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pag̃o Deus eju kawẽnwẽnap'a be osunuy―yabog̃at'a be―uk'a exĩntabi nomudip epa'go. Jekpiwan ma ixe pag̃o o'jewek Jesus e'ũ buje. O'jewek kabi kadi wi ipi kay. ");
INSERT INTO myu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","100 be sorarayũ kukat cũg̃'i osunuy Jesus wap. Apẽn Jesus oe'ũiap o'jojojo. — Icemãn ite'ũm Deus ipot osunuy — io'e. ");
INSERT INTO myu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jesus korosa eju bima, aoyũ dak iboce ijojom osodop. Wũy wi ip ijojom osodop―Jesus cocom. Ixeyũ aoyũ parakpe ebapũg̃ aoyũ osodop ip. Ibũrũ ma ip osodop: Maria Madalena, Salomé, wara'at Maria dak. Wara'at Maria José xi osunuy―Tiago xi dak―yaypan'isuat xi. ");
INSERT INTO myu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ixeyũ aoyũ Jesus eju oekuku Galiléia eipi dag̃ pima. Ibuywatwan oekuku ip. Ade warara'acayũ aoyũ dak osodop ip korosa xe. Jerusalém ka be oajẽm ip ceweju kuy bima. Soat ip Jesus kay jeakag̃ osodop. ");
INSERT INTO myu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Katpuje jĩjã o'e. Kuyaje Sábado je'e―Judeuyũ xe jebodoydoyap kabia. Kabiog̃kabiog̃'i bima jexat tata'uk ip osodop Judeuyũ Sábado bima jekapikap puxim. ");
INSERT INTO myu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kabiog̃kabiog̃'i bima José o'ju Pilatos kay. Ixe José Arimatéia ka bewiat osunuy. Ixe ibimãmãayũ ekawẽn coco'ukat osunuy. Ya'õbuyxi jĩjã dak osunuy soat xe. Deus pe soat kukukan iap wiwim osunuy. Iparara'ũm o'ju Pilatos kay. Oajẽm. — Jesus'ũm jebit mukop pin oce — io'e Pilatos pe. ");
INSERT INTO myu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","— Kuy du ixe'ũm oe'ũ? — io'e Pilatos. Imẽnpuye 100 be sorarayũ kukat o'tomuwã. — Kuy ma du oe'ũ Jesus? — io'e sorarayũ kukukat pe. ");
INSERT INTO myu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","— Hm hm. Kuy ma — io'e sorarayũ kukukat. — Ha'a — io'e José be. — Ijebit cuy eg̃ukop — io'e. ");
INSERT INTO myu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","G̃ebuje José Jesus'ũm jebit o'g̃ukop korosa ejuwi. Kuy juk pag̃o o'jat―xipacat―irucat. Ijebit o'g̃ukabekbek ixem pag̃õm. O'jomõg̃ witabikũy be. Wita'a yabo'gat'a o'yamuypen witabikũy nomudip'am. ");
INSERT INTO myu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Xepxep Mariayũ osodop iboce. Maria Madalena iboce osunuy. Wara'at Maria José xi osunuy―yaypan'isusu xi. Poce Jesus'ũm jebit o'jomõg̃ ip iap o' jojojo ip. ");
INSERT INTO myu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado jebodoydoyap kabia Judeuyũ xe. Kaxi at puje, waram ip jekapikpig̃ ma'g̃uto. Kaxi at puje ebapũg̃ aoyũ tide'oati o'tibu. O'tibu ip Jesus'ũm jebit mude'on am. Ebapũg̃ aoyũ o'ju: Maria Madalena, Salomé dak, wara'at Maria dak―Tiago xi. Ixeyũ ebapũg̃ayũ o'ju. ");
INSERT INTO myu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo bima o'ju ip witabikũy kay―kabia'isum ma―kaxi jẽm'isum ma. ");
INSERT INTO myu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","— Abu wita'a ug̃ ocewebe―witabikũy nomudip'a? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Imẽn o'jekawẽn ip ikũynomudip'a yabog̃ cĩcã buye. O'jeak ip witabikũy kay. Kuy wita'a yawede o'yadobuxik ip. ");
INSERT INTO myu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oõm ip witabikũy be. Deus xewiat o'jojojo ip―yaypan isuat. Xik'i osunuy iba'at kadi. Cesay irut cĩcã osunuy. G̃ebuje o'jewetakaka ip aoyũ. ");
INSERT INTO myu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","— Epeyekuy g̃u! — io'e cebe ip. — Wetaybit Jesus kudadam eyju iam. Nazaré ka bewiat kudadam eyju―korosa be ibamupaya'ibit kudadam — io'e. — Ijoce g̃u opop. Kuy o'jetait waram — io'e. — Ak epe'e topap kay. Topap acã — io'e. ");
INSERT INTO myu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","— Epeju juy g̃asũ bit — io'e aoyũ be. — Ceweju etaybitbin oekuku'iayũ juy epeg̃ukũyjo — io'e. — Pedro dak cuy epeg̃ukũyjo. “Kuy o'jetait waram,” i juy epe'e cebe ip. “Cum eywap Galiléia eipi kay,” i juy epe'e cebe ip — io'e. — “Iboce ma epetobuxik apẽn ixe kuy o'e eywebe iap tag̃,” i juy epe'e cebe ip — io'e. — “Waram o'jetait'iat cuy epetobuxik,” i juy epe'e cebe ip — io'e―yaypan'isuat o'e. ");
INSERT INTO myu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","G̃ebuje o'jẽm ip. Owatwat ip witabikũy bewi jeparara pibun. Ikarabakbak o'e ip jeparara pibun. Kabi bewiat ekawẽn o'g̃uwẽn g̃u ip warara'acayũ be iparara jĩjã ip puye. ");
INSERT INTO myu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus waram o'jetait kabi'isum. Waram o'jetait Domingo bima. Koam o'jebapuk Maria Madalena kay―kuy bima cebewi 7 be ibiõg̃buk kẽrẽayũ o'g̃ujẽmiat kay. ");
INSERT INTO myu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Jesus eju oekukuiayũ wawa o'e ig̃uykitkit ip Jesus kay buye. Wawa ip pima Maria Madalena o'ju ixeyũ mukũyjom. — Wuyekariwa waram o'jetait! — io'e cebe ip. — O'jebapuk okay. Ojojojo — io'e Maria. Imẽnpit itabut'ũm o'e ip Maria ekawẽn kay. — Dapxi ẽn — io'e ip Maria be. ");
INSERT INTO myu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","G̃uyjom Jesus o'jebapuk xepxepayũ kay. Iwarun ma o'jebapuk cekay ip. O'jebapuk cekay ip cucum pima kog̃ũnpi be. ");
INSERT INTO myu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Imẽnpuye ixeyũ o'jepit warara'acayũ kay―jebureyũ kay. — Wuyekariwa itabẽg̃ ma'g̃uto! Ocejojojo! — io'e ip cebe ip. — Dapxi eyju — io'e ip xepxepayũ be. Itabut'ũm o'e ip ixeyũ ekawẽn kay. ");
INSERT INTO myu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","G̃uyjom o'jebapuk 11 beayũ kay. Jekõnkõn ip pima, o'jebapuk cekay ip. O'g̃ukorẽm ip itabut'ũm puye waram o'jetait iap ekawẽn kay. — Apẽnpuye eyetabut g̃u okay? — io'e. — Oweju oekukuiayũ kuy o'e eywebe: “Wuyekariwa waram o'jetait,” i — io'e. — Eyetabut g̃u ixeyũ ekawẽn kay. Eybu'u jĩjã eyetabut am waram ocetait iap ekawẽn kay — io'e. Imẽn ip o'g̃ukorẽm. ");
INSERT INTO myu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","— Epeju juy soat kaka dag̃ — io'e Jesus. — Soat ka dag̃ayũ be juy kawẽn idipat epeg̃uwẽn — io'e. ");
INSERT INTO myu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","— Okay itabut pima, jemubatisasanan pima dak, Deus taxijo — io'e. — “Eykẽrẽ oxe,” i je'e Deus okay itabut'ũmayũ be bit. “Soat em ipiat epesupi'ajo,” i dak je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","— Deus ja'õbacaap je'g̃ũm okay itabucayũ be ka'ũma ma ajojojoiap mubapuk am soat etabutpe — io'e. — Iboap a'õbacaam ibiõg̃buk kẽrẽayũ g̃ujẽmjẽm ip ikug̃ayũ bewi — io'e. — Warara'acat a'õm jekawẽn ip iisuan — io'e. ");
INSERT INTO myu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","— Itaybit'ũma puybu tũypiatpu mucay buje, je'ũ g̃u ip — io'e. — Itaybit'ũma tipiati kõn puje, je'ũ g̃u ip — io'e. — Iwãtaxipipiayũ jeje jebu mõg̃ puje, je'ada ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kariwa Jesus imẽn o'jekawẽn jeweju etaybitbinayũ eju. Cekawẽn epere buje, Deus Jesus o'g̃uyu kabi kay. Oabik Deus xe ixe eju soat kukukan. ");
INSERT INTO myu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ibocewi ceweju etaybitbinayũ o'jẽm. Soat ka dag̃ o'ju ip. Kawẽn idipat muwẽnuwẽn oekuku ip. Wuyekariwa Jesus ixeyũ buywatwan osunuy. Soat etabutpe ka'ũma buk ajojoiap mubapukpug̃ oekuku ip ixe a'õbi. Imẽneju adeayũ itabut o'e ip ixeyũ ekawẽn kay.");
INSERT INTO myu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teofilo, ẽn a'õbuyxi soat xe ocexe. Õn ijudup mubararag̃ ewebeaptum―apẽn cuk adi Jesus Cristo o'e'e wuyetabutpe iaptup. Kuy bima warara'acayũ apẽn ixe Jesus Cristo o'e'e iaptup o'tupmubararak. Koap o'jekawẽn ip ixe eju oekuku'iayũ eju ixe e'eap o'jojojo'iayũ eju dak. Ixeyũ a'õbi juk ixe e'eaptup o'tupmubararak ip. ");
INSERT INTO myu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Õn pit cuk oce owebe ma: — Õn tak cuy ocekawẽn ceweju ip — i. — Soat eju ixeyũ ejujuy ocekawẽn — i juk oce owebe ma. — “Apẽn ixe Jesus o'e'e?” i juy oce cebe ip — i juk oce owebe ma. Imẽnpuye ixeyũ eju juk ocekawẽn. Soat cuk o'g̃uwẽn ip owebe. Õn tak apẽn o'e'e ip iaptup otupmubararak ewebeaptum g̃asũ bit, Teófilo. ");
INSERT INTO myu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ijudup co buje, ẽn tak ece: — Ixeyũ juk adi icẽmãn omutaybitbin apẽn Jesus Cristo o'e'e iam — i. ");
INSERT INTO myu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Teófilo, koam apẽn o'jebapuk Zacarias pe iap og̃uwẽn ewebe, apẽn o'jebapuk itayxi be iap tak. Herodes Judéia eipi watwat kukukat pima, Zacarias itabẽg̃ osunuy. Judeuyũ epaĩ osunuy ixe Zacarias. Kapikpik'uk osunuy Abias ebekitkit eju Deus eju kawẽnwẽnap'a be. Abias ebekitkit tak paĩyũ osodop ip. Zacarias tayxi Arão badip osunuy―paĩyũ kukukat badip. Itayxi butet Isabel i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ixeyũ xepxepayũ cũg̃ ma ip osodop Deus xe. Kũyjobit ip osodop soat Deus a'õ kay. Deus bikuyap tag̃ jekuku'uk ip osodop. ");
INSERT INTO myu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bekicat kug̃ g̃u ip osodop, itayxi i'it ta ba'ore buye. Yabut osunuy. Zacarias tak aypa osunuy. ");
INSERT INTO myu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","G̃ebuje Zacarias o'ju Deus eju kawẽnwẽnap'a kay―yabog̃at'a kay. Ibo'a be kapikpig̃ osunuy Deus etabixe paĩ buye. Kapikpig̃ osunuy Abias ebekitkit eju. ");
INSERT INTO myu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jebabi dag̃ ibadipyũ juk Zacarias o'taẽ iõm ãm badiat'a be. ");
INSERT INTO myu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Oõm tõmte'oatõm mupik am Deus etabixe. Adeayũ dak Deus eju kawẽnwẽnap'a eakiju ip osodop. Akiju kawẽnwẽn ip osodop Deus eju, Zacarias badi tõmte'oatõm mupikupig̃ pima. ");
INSERT INTO myu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","G̃ebuje Deus ekawẽn tojotjot'ukat oajẽm Zacarias kay. Cũg̃'i osunuy tõmte'oatõm mupikupikap'a ba'at kadi―caixa'a jo'iat'a ba'at kadi. ");
INSERT INTO myu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarias yag̃uy'ũm o'e ixe Deus ekawẽn tojotjot'ukat co buje. Iparara jĩjã o'e. ");
INSERT INTO myu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","G̃ebuje Deus ekawẽn tojotjot'ukat o'jekawẽn Zacarias pe. — Tapu, epararam g̃u juy eg̃uy — io'e. — Apẽn cuk adi ece cebe iap o'ya'ĩjojo Deus — io'e. — G̃asũ ma emumuojuy je'g̃ũm ewebe — io'e. — Etayxi ekpon g̃ukap. João i juy ibuten je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","— Eycokcog̃ cĩcã ma epesop bekicat kap puje. Adeayũ dak icokcok cĩcã je'e eyweju. ");
INSERT INTO myu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ekpot ya'õbuyxian je'e Deus xe. Uva'abidi juy idikõn g̃u, wuymuka'o'onapti dak. Ibiõg̃buk xipacat a'õbi ixe jeku jekap'isum piap — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","— Ekpot Judeuyũ ag̃uymuwarururun je'e ixeyũ be Deus kay am, wuykukukat kay am tak. Deus biõg̃buk a'õbacaap kug̃ ixe jeku Elias ekukuap puxim. Ka'ũma buk ocejojojoiap mubapukpug̃ jeku. Ixe omuyku wuykukukat ajẽm awap. Ixe cebayũ ag̃uymuwarururun je'e ixeyũ be waram g̃uto jebekitkiyũ kay am. Ixe Deus a'õ kay'ũmayũ ag̃uymuwarururun je'e ixeyũ be waram g̃uto kawẽn icẽmat tag̃ jeku am. Ixe ijodiacat g̃ubikuy wuykukukat ajẽmap wiwi am — io'e. Imẽn Deus ekawẽn tojotjot'ukat o'jekawẽn Zacarias pe. ");
INSERT INTO myu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","G̃ebuje Zacarias o'jekawẽn Deus ekawẽn tojotjot'ukat pe. — Iba'ore ma owebe okpotpet am — io'e. — Kuy aypa oce. Otayxi dak yabut kuy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","— Gabriel i obutet — io'e. — Deus etabixe cũg̃'i õn nuynuy. Deus ma omudot jekawẽn ãm eweju. Ixe omudot iboap awẽg̃ muwẽn ãm ewebe―yawẽg̃ tipatawẽg̃ muwẽn ãm ewebe. ");
INSERT INTO myu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ẽn pit etabut g̃u wa'õ kay — io'e. — Imẽnpuye ekõmbicaca ecesũy. Ede ba'ore ecesũy. Wekawẽn tag̃ cebapuk puje bit, waram g̃uto ede but ece'e. Soat ma je'bapuk ixe kabia be apẽn õn e'em ewebe iap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Adeayũ dak Deus eju kawẽnwẽnap'a bewi Zacarias jẽmap wiwim ip osodop. — Apẽnpuye dak Zacarias ibun cĩcã Deus eju kawẽnwẽnap'a be? — io'e ip jewewebe kakijuayũ. ");
INSERT INTO myu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","G̃ebuje Zacarias oajẽm akijuayũ kay. Cekawẽn pa'ore o'e cebe ip. Imẽnpuye itaybit ip o'e Deus eju kawẽnwẽnap'a be bima Zacarias jexey jo'iat o'jojojo iam. Jekawẽn ojuy akijuayũ eju. Cekawẽn pa'ore bit o'e. Imẽnpuye jebum acã o'jekawẽn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Deus eju kawẽnwẽnap'a be jekapikap epere buje, Zacarias o'jepit jeduk'a kay. ");
INSERT INTO myu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","G̃uyjom ma itayxi o'yukreg̃―Isabel. Pũg̃põg̃bi kaxi jeduk'a be ma osunuy Isabel. ");
INSERT INTO myu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","— Okukukat xipat cĩcã oxe! — io'e Isabel. — Koap cuk adi og̃uy osũsũn, o'it'et'ũm puye — io'e. — G̃asũ bit osũsũn g̃u oce o'ukreg̃ puye — io'e Isabel jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","G̃ebuje Deus jekawẽn tojotjot'ukat o'g̃uju yaypan'isuat kay―ag̃okatkat eju o'jepo g̃u'iat kay. O'g̃uju cekay Isabel 6 kaxi yukeg̃ puje. Deus ekawẽn tojotjot'ukat putet Gabriel i osunuy. Oajẽm ag̃okatkat eju o'jepo g̃u'iat kay. Ixe ayacat Galiléia eipi be osunuy. Nazaré ka be osunuy. Maria i ibutet osunuy. José wadip osunuy. José Davi badip osunuy. ");
INSERT INTO myu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Oajẽm Deus ekawẽn tojotjot'ukat Maria kay. — Tũ'ũ, ecokcog̃ cuy eg̃uy — io'e. — Deus xipat cĩcãat je'g̃ũm ewebe. Wuykukukat soat em jekukum eweju — Gabriel o'e. ");
INSERT INTO myu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria yag̃uybabi'ũm o'e cekawẽn co buje. — Apẽnpuye dak imẽn teku odobededem? — io'e Maria jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","— Tũ'ũ, epararam g̃u juy eg̃uy — io'e. — Deus xe ekukpin cĩcã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","— Je'ukreg̃. Ag̃okatkat eceg̃ukap e'in. Jesus i juy esubuteta — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","— Ya'õbuyxian je'e e'it — io'e. — “Deus ipot teku,” i je'e soat ijodiat. “Soat podi ya'õbacaat ipot teku,” i je'e ip. Deus ixe jomuy Judeuyũ kukukan. Kuy bima Davi Judeuyũ kukukat osunuy―Jesus eajot. Imẽnpuxim Jesus Judeuyũ kukukan je'e. ");
INSERT INTO myu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Soat em ma imẽn Jacó naxeg̃ebitbit kukukan jeenuy. Wara'at g̃u jomuy ixe dieg̃ ixeyũ kukukan — Gabriel o'e Maria be. ");
INSERT INTO myu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","— Apẽn xe'e dak osu'itkap? Ocepo g̃u mabuk a'g̃u ag̃okatkat eju — io'e Maria Deus ekawẽn tojotjot'ukat pe. ");
INSERT INTO myu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","— Ibiõg̃buk xipacat jajẽm ekay — io'e. — Je'ukreg̃ soat podi ma ya'õbacaat a'õbi―Deus a'õbi. Imẽnpuye bekicat ikẽrẽat kug̃ g̃u je'e. Deus ipon je'e. ");
INSERT INTO myu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","G̃ebum cuy eg̃uy ebadip kay―Isabel kay — io'e. — Ixe Isabel o'yukreg̃ yabut ma'g̃u. Kuy ag̃okatkat opop yuk pe. “I'it ta ba'ore teku,” io'e'e ip kuy bima. G̃asũ bit 6 kaxi yukreg̃. ");
INSERT INTO myu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ka'ũma ma iba'ore Deus pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","— Ha'a — Maria o'e. — Deus okukukat. Deus a'õbi soat je'bapuk owebe apẽn ẽn e'em owebe iap tag̃ — Maria o'e. Deus ekawẽn tojotjot'ukat o'jẽm cexewi. ");
INSERT INTO myu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","G̃axĩn ma Maria o'ju Isabel kay. Dao ma o'ju co'a'uat kapẽn pe. Judéia eipi be o'ju. Isabel ka be o'ju. Jay. Oajẽm. ");
INSERT INTO myu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oõm Zacarias duk'a be―Isabel duk'a be. Isabel o'tobede. ");
INSERT INTO myu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Joroh. Isabel ukpeat o'jejoro yuk pe Maria be Isabel dobede buje. Ibiõg̃buk xipacat a'õbacaap kug̃ osunuy Isabel. ");
INSERT INTO myu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","G̃ebuje Isabel o'jekawẽn ya'õberen Maria eju. — Deus xipat cĩcã! — io'e. — Deus xipacat ũmũm ewebe. Ecokcok soat cokcokap podi ma―aoyũ cokcokap podi ma. “Ẽn xipat cĩcã,” i je'e adeayũ e'uk peat pe. ");
INSERT INTO myu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Deus xipacan e'em owebeam tak! Ẽn okukukat xi. Inaka okay ajẽm, wa'õbuyxi g̃u ma'g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","— Ewebe odobede buje, o'uk peat o'jejoro jecokcok pibun — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","— “Soat je'bapuk owebe apẽn okukukat e'em owebe iap tag̃,” i ẽn e'em. Imẽnpuye Deus xipacan e'em ewebeam — Isabel o'e. ");
INSERT INTO myu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","G̃ebuje Maria o'jekawẽn Isabel eju. — “Wuykukukat soat podi ma xipat,” i õn e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","— Ocokcok cĩcã Deus xipan okug̃ puye―odaxijojo'ukat xipan okug̃ puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","— Ixe acã okukukat. Odadaybot ma dak. Imẽnpit ixe soat em ag̃ okay — Maria o'e. — “Deus xipacan ixe ayacat o'jukuk,” i je'e soat ka watwat omuwẽnuwẽn — io'e. — G̃asũ imẽn je'e ip, g̃uyjom tak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","— Ixe ka'ũma buk ocejojojoiap o'g̃ubapuk owebe. Soat podi ma ixe ya'õbaca — io'e. — Ibuyxim cuy ibutet ajukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","— Deus itabotaidabotbot cĩcã ibuyxim jekukayũ kay. Wuydobuyũ'ũm'ũm kay itabotaidabotbot cĩcã osunuynuy. G̃asũayũ kay dak itabotaidabotbot―soat kay. G̃uyjomayũ kay dak itabotaidabotbon jeedop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","— Deus ja'õbacaap o'g̃ubapukpuk. Yobog̃an pinayũ o'g̃uypõg̃põg̃. Ixeyũ e'eap o'g̃u'ũm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","— Ika kukukayũ o'g̃ujẽm jenuyap pewi. Ya'õbuyxi'ũmayũm o'e ip. Ya'õbuyxi'ũmayũ o'jomuy ixeyũ nuyap pe. Ya'õbuyxiayũm o'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","— Tadaybotbocayũ be xipat cĩcãat o'g̃ũmg̃ũm. Soat kug̃ ip o'e. Ibubut adeayũ bit ibuipuk o'g̃ujẽmjẽm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","— Ixe Israel naxeg̃ebitbit o'subuywatwan cĩcã―ja'õ kay kũyjobicayũ o'subuywatwan cĩcã. Xipan wuydobuyũ'ũm'ũm o'jukukuk apẽn cuk adi o'e'e iap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","— Xipan wuydobuyũ'ũm'ũm o'jukukuk―Abraão'ũm o'jukukuk, cenaxeg̃ebitbit'ũm'ũm tak o'jukukuk. Ja'õ dag̃ soat em g̃ebum osunuy ixeyũ kay. Soat em ixe g̃ebum osunuy ixeyũ kay xipan ikuk am — io'e―Maria o'e. ");
INSERT INTO myu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ebapũg̃ kaxi Maria Isabel xe osunuy. Ibocewi o'jepit jeduk'a be. ");
INSERT INTO myu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ija kaxi ajẽm puje, Isabel o'su'itkap ag̃okatkat. ");
INSERT INTO myu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","59","Bekicat 8 kabia bima ibadipyũ oajẽm ixe duk'a xeayũ dak. Oajẽm ip ikap'isuat taypu'ag̃obixeedakat am “Deus ebekit teku” i'e am. Soat ibadipyũ icokcok cĩcã o'e ip. — Deus xipan cĩcã ija xi o'jukuk — io'e ip. Ibutetaat ojuy ip. — Zacarias i juy asubutetaat cebay butet kadin ma — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","— Ap! — ixi bit o'e. — Ibo g̃u je'e ibutet―João i acã — io'e ixi. ");
INSERT INTO myu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","— Ebadipyũ butet João i'ũmg̃u — io'e ip ixi be. ");
INSERT INTO myu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","G̃ebuje o'jekawẽn ip cebay eju. — Apẽn ekpot puten je'e? — io'e ip cebay be. Jebum acã o'jekawẽn cebay, cekawẽn pa'ore buye. ");
INSERT INTO myu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","“Taperadup cuy etupũm owebe” iape, cebay o'e jebum cebe ip. O'tupũm ip cebe. Ibocewi o'tupmubararak cebay. Ibutet João i iaptup o'tupmubararak. Soat ip itabẽg̃bẽg̃ o'e ijojom. Zacarias i cebay je'e tũybe iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cebay cekawẽn put o'e g̃ebuje bit. Xipan o'jekawẽn g̃uto. — Deus xipat cĩcã — io'e. — Ka'ũma ma ixe jo'iat ya'õbuyxiat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Imẽneju yag̃uybabi'ũm o'e ip tuk'a xeayũ. João kapap awẽg̃ o'yawẽg̃muwẽnuwẽn ip soat ka dag̃―Judéia eipi dag̃, co'a'uat kapẽn tag̃ tak. ");
INSERT INTO myu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","O'yawẽg̃tobuxik'iayũ jewag̃uydadam ip osodop João kapap awẽg̃ kay. — Apẽn xe'e je'e ite bekicat yaypan pima? — io'e ip jewewebe. Imẽn o'jekawẽn ip, João Deus a'õbacaap kug̃ oeku buye. ");
INSERT INTO myu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","G̃ebuje Zacarias apẽn g̃uyjom je'bapuk iap o'g̃uwẽn―ikap'isuat ebay. Iboap o'g̃uwẽn Ibiõg̃buk xipacat a'õbi. ");
INSERT INTO myu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— G̃a'a ace Deus pe “Ka'ũmg̃u ejo'iat,” i. Ixe Deus kay itabut ip osodop Israel naxeg̃ebitbit. Jebekitkiyũ o'subuywan. Jebekitkiyũ o'taxijo — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","— Deus wuydaxijojo'ukat o'g̃udot wuykay. Ya'õbacaat o'g̃udot wuykay. Wuydaxijojo'ukat Davi naxeg̃ebit―Deus a'õ kay kũyjobicat naxeg̃ebit — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","— Ixe wuydaxijojo'ukat ya'õbacat jĩjã. Ka'ũma ma ixe jo'i ya'õbaca. Imẽnpuxim kuyje Deus ekawẽn muwẽnuwẽn'ukayũ o'e'e Deus a'õbi―soat tag̃ iisuayũ o'e'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","— “Deus wuydaxijo wuykay itakomaayũ be wuyaokaap puxim. Ixe wuykay'ũmayũ a'õbacaap g̃u'ũm ixeyũ be wuyaokaap puxim,” i'e'e'uk osodop ip — io'e Zacarias. ");
INSERT INTO myu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","— Deus itabotaidabotbot osunuy wuydobuyũ'ũm'ũm kay apẽn kuy o'e'e iap tag̃. “Wekawẽn tag̃ oce,” io'e Deus. Jekawẽn tag̃ o'e'e soat em ma. Cekawẽnkẽrẽ g̃u osunuy―cekawẽntip cĩcã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","— Ixe o'jekawẽn wuydobu'ũm eju―Abraão'ũm eju. “Jedaxijo õn ekay itakomaayũ bewi; ebekitkiyũ dak otaxijo,” io'e Abraão be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","— “Jeybuywan õn eypararam g̃u kapik am owebeam,” io'e Abraão be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","— “Cũg̃ ma epesop oxe,” io'e. “Ikẽrẽat kug̃ g̃u epesop oxe,” io'e. “Soat em epesop oxe eyetait,” io'e. Ixe o'e apẽn cuk adi o'e'e iap tag̃ — io'e Zacarias. ");
INSERT INTO myu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","— Bekit — Zacarias o'e jekpot pe―ikap'isuat pe — Wuykukukat wap eceju soat muxipan am ixe mudot am. Deus ekawẽn muwẽnuwẽn'ukan ece'e―soat podi ma ya'õbacaat ekawẽn muwẽnuwẽn'ukan — io'e. ");
INSERT INTO myu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","— Adeayũ be ece'e “Deus ikẽrẽat ju'uk eywebewi,” i. “Deus jeydaxijo,” i ece'e cebe ip — io'e Zacarias. ");
INSERT INTO myu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","— Imẽn Deus itabotaidabotbot cĩcã wuykay. Yukpiceg̃ẽ g̃u wuykay. Wuydaxijojoap kabia jajẽm ixe a'õbi. Ixe jajẽm kabia buxim. ");
INSERT INTO myu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","— Ixe kabiok pe jekuku'ukat puximayũ g̃ukabia. Je'ũap puxim ipararaayũ g̃ukabia. Ixe wuymutaybitbin je'e wuywebe xipan jewewekuk am. Kaba'ũm acesop wuyeweweju. — Imẽneju adeayũ je'e ewebe: “Ẽn Deus ekawẽn muwẽnuwẽn'ukat,” — io'e ikap'isuat ebay. Imẽn Zacarias apẽn g̃uyjom je'bapuk iap o'g̃uwẽn Deus a'õbi. ");
INSERT INTO myu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bekicat o'yaypan. Kũyjobit osunuy Deus a'õ kay. Uk'a'ũmat pe osunuy Judeuyũ kay jeju'ũm pima―Judeuyũ mutaybitbin'ũm pima. ");
INSERT INTO myu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ixeyũ kabia be Augusto cartadup o'tupmubararak―soat ka kukat. O'tupmuju soat pe jebekitkiyũ be. Bekitkit, eykapap ka kay juy epeju eybutet mubararak am taperadup pe i'eaptup o'tupmuju. ");
INSERT INTO myu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ka'ũma ma ig̃o eipi watwat o'g̃uweg̃ũn ijoptup muju awap. Jebekitkit o'g̃uweg̃ẽg̃at Cirênio Síria eipi watwat kukat pima. ");
INSERT INTO myu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Imẽnpuye soat ixe ebekitkit o'ju jebutet mubararak am taperadup pe. Jekapap ka be ip o'ju. ");
INSERT INTO myu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Imẽnpuye José dak o'jẽm Galiléia eipi bewi―Nazaré ka bewi. O'ju Judéia eipi be―Belém ka be―Davi osunuyiat ka be. Ixe José o'ju Davi diwat osunuy buye. ");
INSERT INTO myu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","O'ju jebutet mubararak am Maria eju―jetayxi eju. Maria yukreg̃ osunuy. ");
INSERT INTO myu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ixeyũ Belém ka be bima, Maria o'yukpasuk. ");
INSERT INTO myu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","G̃ebuje Maria o'su'itkap koapat―ag̃okatkat. Ikap'isuat o'yamuekabek pag̃õm. O'g̃uyxet biopak xat mũn pe―cucuayũ nuyap'a be topap'ũm puye. ");
INSERT INTO myu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Kabi bewi Deus ekawẽn tojotjot'ukat tak o'kop ovelha kukukayũ kay. Kog̃ũnpi be osodop ip Belém ka tẽg̃ ma. Ovelha kukug̃ ip osodop ixima be. Deus o'g̃ukabia ovelha kukukayũ akokoreren. Iparara jĩjã ip o'e kabia jo buje, idip cĩcã ma'g̃u kabia. ");
INSERT INTO myu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","G̃ebuje Deus ekawẽn tojotjot'ukat o'jekawẽn ceweju ip. — Eypararam g̃u juy epesop — io'e. — Kawẽn idipat otojot imuwẽn ãm eywebe eymucokcok am. Kawẽn idipat otojot soat pe imuwẽn ãm ijodiat pe. ");
INSERT INTO myu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Eydaxijojo'ukat o'kap g̃asũ. Davi osunuyiat ka be o'kap — io'e. — Soat kukat ixe―ipi dag̃at kukat. Cristo i ibutet — io'e Deus ekawẽn tojotjot'ukat. ");
INSERT INTO myu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","— Ixe ikap'isuat iekabek pag̃õm. Po'i biopak xat mũn pe. Imẽn õn eymukũyjojom eywebe tobuxik am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","G̃ebuje warara'acayũ o'jebapuk kabi kadiwi Deus ekawẽn tojotjot'ukayũ. — Ka'ũma ma Deus co'iat — io'e ip. — Soat podi ma ixe ya'õbuyxi — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Ka'ũmg̃u Deus co'iat xipacat — io'e kabi kadiwiayũ. — Kaba'ũm jeedop ip soat ijodiacat―Deus emumukukpinyũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Waram ip o'jeu kabi kay Deus ekawẽn tojotjot'ukayũ. Cexewi Deus ekawẽn tojotjot'ukayũ cẽm puje, o'jekawẽn ip jeweweju ovelha kukukayũ. — G̃a'a aju — io'e ip. — Belém ka kay juy aju — io'e ip. — Apẽn Deus o'e wuywebe iap cuy ajojo — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dao ma ip o'ju. Oajẽm ip. Ixeyũ dak ikap'isuat o'tobuxik José eju, Maria eju dak. Po'i osodop biopak xat mũn pe. ");
INSERT INTO myu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ikap'isuat tobuxik puje, ikapap awẽg̃ muwẽnuwẽn oekuku ip soat ka dag̃. Apẽn Deus ekawẽn tojotjot'ukayũ bekicat kapap o'g̃uwẽn cebe ip iap muwẽnuwẽn oekuku ip soat ka dag̃. ");
INSERT INTO myu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Itabẽg̃bẽg̃ ip o'e cẽm paxi iam o'ya'ĩjojoiayũ ma. ");
INSERT INTO myu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria bit soat em g̃ebum osunuy apẽn je'it o'kap iap kay. Iboap kay jewag̃uymug̃ẽg̃ẽm osunuy. ");
INSERT INTO myu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ovelha kukukayũ o'jepit kog̃ũnpi be. — Ẽn xipat cĩcã — io'e ip Deus pe. — Idip cĩcãat ocejojojo — io'e ip. — Idim cuk ẽn ocemukũyjo — io'e ip. Soat o'tobuxik ip apẽn Deus ekawẽn tojotjot'ukat o'e cebe ip iap tag̃. Imẽnpuye: — Ka'ũma ma ejo'iat xipacat — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","8 xet kap puje cebaydaap Jesus daypu'ag̃obuxee o'suxeedakacat Judeuyũ babim. Yukreg̃ awap Deus ekawẽn tojotjot'ukat o'e Maria be: — Jesus i ibuten je'e — i. Imẽnpuye Jesus i o'subutetaat ip. ");
INSERT INTO myu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","G̃ebuje cebaydaap Jesus o'tujowat Jerusalém ka kay. Jetayxi eju o'tujowat. O'tujowat ip ikap'isuat mubapuk am paĩ be Moisés ekawẽn tag̃. Ibararak opop wuykukukat ekawẽntup pe: Ag̃okatkat kap puje―koapat kap puje, ixe ikap'isuat Deus ebekit ma, i. Imẽneju cebaydaap Jesus o'tujowat Jerusalém kay imubapuk am Deus etabixe Deus eju kawẽnwẽnap'a be. ");
INSERT INTO myu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","30","Imẽn e'em wuykukukat ekawẽntup: Bekicat kap puje, wũnca juy eg̃ũm paĩ be ixe be imupik am Deus etabixe, i. Xepxep pukaso juy eg̃ũm, i. Pukaso kug̃'ũm pima, xepxep coot cuy eg̃ũm, i. Imẽn e'em wuykukukat ekawẽntup. Imẽneju cebaydaap oajẽm Jerusalém ka be ikap'isuat mubapuk am Deus etabixe. G̃ebuje Ibiõg̃buk xipacat Simeão oõmat Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Cebaydaap tak Jesus o'tujuajẽm Deus eju kawẽnwẽnap'a be pukaso ũm ãm paĩ be Moisés ekawẽn tag̃. Simeão Jesus o'takoy jebakopixirik ceje. Ixe Simeão Jerusalém ka be osunuy. Cũg̃ cĩcã osunuy Deus xe. Itabut cĩcã osunuy Deus kay. Judeuyũ daxijojo'ukat ajẽmap wiwim osunuy. Ibiõg̃buk xipacat ixe mutaybitbin'uk osunuy. Ibiõg̃buk xipacat o'e Simeão be kuy bima: — Eje'ũ g̃u wuykukukat co'ũm pima―soat taxijo am Deus emunaẽ jo'ũm pima — i. G̃ebuje Simeão Deus o'g̃uwẽnuwẽn xipan. — Okukukat — io'e. — G̃asũ õn iju jojom — io'e. — Soat taxijo am etaẽiat cocom õn — io'e. ");
INSERT INTO myu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","— Soat etabixe juk etaẽiat cocom õn — io'e. — G̃asũ bit we'ũ but ocokcog̃ — Simeão o'e. — Ẽn acã okukukat — io'e. — G̃asũ õn iju jojom apẽn cuk ece owebe iap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","— Kabiaap puxim je'e ixe. Judeu'ũmayũ mutaybitbin je'e — io'e. — Ebekitkiyũ dak kũyjobin jeedop ip warara'acat a'õ kay g̃u―ixe a'õ kay acã―Israel naxeg̃ebitbiyũ — io'e. — Edipap kug̃ jeedop ip — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Cebaydaap, ixi dak itabẽg̃bẽg̃ ip osodop Simeão ekawẽn cocom―bekicat muwẽnuwẽnap cocom. ");
INSERT INTO myu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","38","— Xipan cuy ikap'isuat ebayũ ejukuk — Simeão o'e Deus pe. G̃ebuje Simeão o'jekawẽn Maria eju―ikap'isuat xi eju. — A'õpicũg̃ cuy eg̃uy — io'e. — Deus cuk ixe bekicat o'taẽ — io'e. — Inaka adeayũ iju kay g̃u jĩjã je'e Judeuyũ'in. Deus pit ixeyũ g̃u'ũm. Ẽn tak eg̃uycũg̃ cĩcã ece'e — io'e. — Ipiat ecesupi'ajo jĩjã paja ewebe õmap puxim — Simão o'e Maria be. — Warara'acayũ bit iju kay jĩjã je'e. Icokcok cĩcã jeedop ip cekay. Deus imẽn adeayũ ag̃uymubapukpug̃ je'e soat pe — io'e Simeão Maria be. Bekicat ebayũ Deus eju kawẽnwẽnap'a be bima, Ana oajẽm cekay ip. O'jekawẽn Deus eju. — Bay, ẽn xipat cĩcã — io'e Deus pe―Ana o'e. Ixe Ana bekicat o'kapiap o'g̃uwẽn adeayũ be Jerusalém ka watwat pe―Deus jebekitkit taxijoap wiwi'ukayũ be. Ixe Ana Deus ekawẽn muwẽnuwẽn'ukat osunuy. Fanuel daxit osunuy. Aser diwat osunuy. Yabut cĩcã osunuy. Yaypan'isu bima juk o'jewebumũn. 7 koato jektop xe osunuy. Kuy ma itop'ũm oe'ũ. Ixe Ana 84 koato osunuy g̃asũ. Deus eju kawẽnwẽnap'a bewi o'jẽm g̃u. Soat em ma ig̃o'a be nuynuy―kabiam, ixima dag̃ tak. — Ẽn xipat cĩcã — i'e'e'uk osunuy Deus pe soat em. Deus eju kawẽnwẽn'uk osunuy. Jekpiwan ma jewemureren'uk osunuy ceweju jekawẽn ojuy. ");
INSERT INTO myu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Deus ekawẽn tag̃ paĩ be bekicat mubapuk epere buje, cebayũ Jesus o'tujupit jeka kay. Nazaré ka kay ip o'jepit―Galiléia eipi be. ");
INSERT INTO myu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bekicat o'yaypan. Ibacaan o'e. Jebadipyũ bodi ma itaybican o'e. Deus xipacat ũmũm'uk osunuy cebe. ");
INSERT INTO myu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus ebayũ waram o'ju ip Jerusalém ka kay. Soat em Páscoa epeta be cucu'uk ip osodop Jerusalém ka kay. ");
INSERT INTO myu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","12 koato bima, Jesus o'ju g̃uto jebaydaap, ixi iat eju, peta be cucu'uk puye. ");
INSERT INTO myu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Peta epere buje, cebayũ ma o'jepit ip jeka be. Jesus pit o'jecũ Jerusalém ka be. Itaybit g̃u ip osodop cecũam. ");
INSERT INTO myu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tũybe Jesus wuybadipyũ eju o'jepit iãn o'e ip cebayũ. Jepitpin o'ju ip e dag̃ jeka kay. O'xet ip e bidase. Jesus o'jokudada ip jebadipyũ dag̃, jebureyũ dag̃ tak. ");
INSERT INTO myu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ka'ũmg̃u. O'tobuxik g̃u ip. Imẽnpuye ikudadam o'jepit g̃uto ip Jerusalém ka be. Ebapũg̃ kabia ikudadam oekuku ip. ");
INSERT INTO myu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","G̃ebuje Jesus o'tobuxik ip Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Xik'i osunuy Moisés ekawẽn Judeuyũ mutaybitbin'ukayũ xe―aypapayũ xe. Cekawẽn cocom osunuy. Kawẽnwẽn osunuy ceweju ip. ");
INSERT INTO myu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesus kay jĩjã ip o'e soat cekawẽn cocoayũ, itaybit cĩcã buye, cũg̃ cĩcã jededem puye dak. ");
INSERT INTO myu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesus tobuxik puje, cebayũ itabẽg̃bẽg̃ ip o'e ijojom. — Tapu — io'e ixi Jesus pe. — Edaobu'u du eg̃uy jepin? — io'e. — Ocag̃uybabi'ũm cĩcã ocesop ekudadam―õn, ebaydaap tak — io'e―jekpot pe o'e. ");
INSERT INTO myu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","— Aĩ, apẽnpuye dak okudadam epeku? — io'e. — Eyetaybit g̃u du webay duk'a be juy õn iam―Deus eju kawẽnwẽnap'a be? — io'e―jexi be o'e. ");
INSERT INTO myu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Imẽnpit Jesus ekawẽn iba'arem o'e cexe ip. ");
INSERT INTO myu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ibocewi o'jepit jebayũ eju Jesus. Oajẽm jeka be―Nazaré ka be. Jebaydaap a'õ kay kũyjobit osunuy. Ixi dak soat em g̃ebum osunuy apẽn Jesus cuk adi o'e'e cebe iap kay. ");
INSERT INTO myu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ixe Jesus tak jebureyũ bodi ma itaybican o'e. O'yaypan. Ikukpin cĩcã osunuy Deus xe, jexeayũ xe dak. ");
INSERT INTO myu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","G̃ebuje Deus o'jekawẽn João Batista eju―Zacarias ipot eju. João uk'a'ũmat pe osunuy. — Wekawẽn cuy eg̃uwẽnuwẽn itaybit'ũmayũ be — Deus o'e João be. O'jekawẽn João eju Tibério Roma ka kukat pima. 15 koato kuy ika kukat osunuy. O'jekawẽn ceweju Pôncio Pilatos Judéia eipi kukat pima dak, Herodes Galiléia eipi kukat pima dak, Lisânias Abilene eipi kukat pima dak, Filipe Ituréia eipi kukat pima dak. Ixe Filipe Traconites eipi kukat tak osunuy. Filipe Herodes kitpit osunuy. O'jekawẽn João eju Anás Judeuyũ epaĩyũ kukukat pima. Caifás tak Judeuyũ epaĩyũ kukukat osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Imẽnpuye Jordãodi wãbu dag̃ oeku João. G̃uyjom João Deus ekawẽn o'g̃uwẽnuwẽn adeayũ be. — Eyg̃uycũg̃cũg̃ cuy epesop ikẽrẽat kug̃ puye — io'e cebe ip. — Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere — io'e. — Epeyewemubatisasanat cuy — io'e. — Imẽn ey'e buje, Deus ikẽrẽat ju'uk eywebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","— Imẽntak e'em Isaías emudupmubararaktup―Deus ekawẽn muwẽnuwẽn'ukat emudupmubararaktup: Ag̃okatkat jewãwãwãm uk'a'ũmat pe, i. Imẽn jewãwãwãm: Soat e juy epesuemukacũg̃ wuykukukat ajẽmap em, i. Ie juy epesuemudim ceku am, i. ");
INSERT INTO myu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kabioreg̃reg̃at cuy epeg̃udim, i. Ipiweg̃ũn je'e, i. Co'a dak epeyamuweg̃ũg̃ũn, i. Iebixirik tag̃ cuy epesuemujẽm, i. Wakenat e be epesuemujẽm, i. Soat iekẽrẽate iedip cĩcã je'e, i. ");
INSERT INTO myu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wuydaxijo am Deus emunaẽ coco ip soat ijodiacat, i. Imẽn e'em Isaías emudupmubararaktup — io'e João adeayũ be. ");
INSERT INTO myu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Imẽnpuye adeayũ o'ju João be jemubatisanan. G̃ebuje João adeayũ o'g̃ukũyjo. — Deus itakoma eykay, ikẽrẽat kug̃ cĩcã buye — io'e. — Ipiat supi'ajoat eywebe, ikẽrẽat kug̃ puye — io'e. — Eynapõn pa'ore Deus xewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","— Cũg̃ ma juy epeku kuy ikẽrẽat mujurũg̃rũg̃ap ocepere iap mubapuk am warara'acayũ be — io'e. — Tũybe Deus ipiat supi'ajoat g̃u wuywebe wuyju Abraão naxeg̃ebitbit puye iãn purut eyju e'em — João o'e. — Imẽn g̃u juy epe'e — io'e. — Iba'ore g̃u Deus pe wita'a muwexat am Abraão naxeg̃ebitbiyũm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","— G̃axĩn ma o'a kukat jajẽm ya'a'e'ũmat'ip takat am yop xik am daxa be — io'e. — Ixe buxim Deus tak g̃axĩn ma ipiat supi'ajoat kũyjobit'ũmayũ be — João o'e. ");
INSERT INTO myu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","— Apẽntak oce'e ipiat pi'ajoap puxim? — io'e ip João be. ");
INSERT INTO myu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","— Xepxep eyekabek kug̃ pima, pũg̃ cuy epeg̃ũm ikug̃'ũmat pe — io'e. — Puybit kug̃ pima, epeg̃u'ẽ'ẽ juy ikug̃'ũmat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Iecug̃ap peam dinheiro bubu'ukayũ dak oajẽm João be jemubatisanan. — Pãm oceju? Apẽntak oce'e? — io'e ip João be. ");
INSERT INTO myu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","— Iecug̃ap emumubudei bodi g̃u juy epejat cebekitkit pewi―ixe emumubudei acã — io'e João. ");
INSERT INTO myu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","— Pãm oceju? — io'e ip sorarayũ dak. — Puyxibun g̃u juy dinheiro epejat warara'acat xewi — io'e. — Napa g̃u juy epe'e dinheiro bu am warara'acat xewi. Jemãmãmãm g̃u juy epesop eyekapikaptei kug̃―eycokcog̃ acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Soat g̃ebum cĩcã o'e ip João ekawẽn kay. — Ite du Deus emunaẽ soat taxijo am? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","G̃ebuje João o'jekawẽn soat pe. — Õn ma eymubatisasan idibi be — io'e. — Wara'acat pit omuyku. Obodi ma ixe ya'õbuyxi. Soat podi ma ya'õbaca. Õn pit ajo pẽg̃ap g̃u cebeam? Cedag̃ g̃u kuka oce ixe a'õbuywatwat'ukan, obog̃ g̃u buye. Õn ma eymubatisasan idibi be. Ixe bit Deus biõg̃buk g̃uõm eywebe ya'õ dag̃ eyeku am. Ixe dak ipiat supi'ajoat eywebe cũg̃ ma eyeku am. ");
INSERT INTO myu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wuyju taixee xikxig̃ tũmũntata mujẽm ãm taixee bewi. Tũmũntata muxipanpan wuyju tamũn'a be. Taixee mupikpig̃ daxa be. Imẽnpuxim Deus kũyjobicayũ muwajejem kũyjobit'ũmayũ xewi. Kũyjobicayũ ixe xe jeedop soat em. Kũyjobit'ũmayũ bit soat em ipiat supi'ajojo — io'e João. ");
INSERT INTO myu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Imẽn adeayũ awẽwẽm oeku João. Kawẽn idipat muwẽnuwẽn oeku. ");
INSERT INTO myu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Adeayũ mubatisasan epere buje, João Jesus o'g̃ubatisan. G̃ebuje Jesus kay Ibiõg̃buk xipacat o'kop. Jesus Deus eju kawẽnwẽn pima, o'kop. Pukaso jo'i o'kop Ibiõg̃buk xipacat. G̃ebuje Deus o'jekawẽn kabi kadiwi. — Ẽn okpocat — io'e. — Ocokcok cĩcã ekay — Deus o'e Jesus pe. G̃uyjom Herodes João o'g̃uõmat daomũnmũnap'a be. Ixe Herodes Galiléia eipi kukat osunuy. Kuy bima João o'e Herodes pe: — Cedag̃ g̃u ewebe ekitpit tayxi bum etayxim―Herodias bum — i. — Ẽn ikẽrẽat kug̃ — io'e Herodes pe. Herodes ikẽrẽat kukuk'uk osunuy. Waram ikẽrẽat o'jukuk g̃asũ dak. João ikẽrẽat o'jukuk g̃u. Inaka Herodes João o'g̃uõmat daomũnmũnap'a be. ");
INSERT INTO myu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus 30 koato bima ijodiacat mutaybitbin o'e. — Jesus José ipot — io'e'e ip adeayũ. ");
INSERT INTO myu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","José ebay butet Eli i osunuy. Eli ebay butet Matate i osunuy. Matate ebay butet Levi i osunuy. Levi ebay butet Melqui i osunuy. Melqui ebay butet Janai i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Janai ebay butet José i osunuy. José ebay butet Matatias i osunuy. Matatias ebay butet Amós i osunuy. Amós ebay butet Naum i osunuy. Naum ebay butet Esli i osunuy. Esli ebay butet Nagai i osunuy. Nagai ebay butet Maate i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate ebay butet Matatias i osunuy. Matatias ebay butet Semei i osunuy. Semei ebay butet José i osunuy. José ebay butet Joda i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ebay butet Joanã i osunuy. Joanã ebay butet Resa i osunuy. Resa ebay butet Zorobabel i osunuy. Zorobabel ebay butet Salatiel i osunuy. Salatiel ebay butet Neri i osunuy. Neri ebay butet Melqui i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melqui ebay butet Adi i osunuy. Adi ebay butet Cosã i osunuy. Cosã ebay butet Elmadão i osunuy. Elmãdão ebay butet Er i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ebay butet Josué i osunuy. Josué ebay butet Eliézer i osunuy. Eliézer ebay butet Jorim i osunuy. Jorim ebay butet Matate i osunuy. Matate ebay butet Levi i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ebay butet Simeão i osunuy. Simeaão ebay butet Judá i osunuy. Judá ebay butet José i osunuy. José ebay butet Jonã i osunuy. Jonã ebay butet Eliaquim i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ebay butet Meleá i osunuy. Meleá ebay butet Mená i osunuy. Mená ebay butet Matata i osunuy. Matata ebay butet Natã i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natã ebay butet Davi i osunuy. Davi ebay butet Jessé i osunuy. Jessé ebay butet Obede i osunuy. Obede ebay butet Boaz i osunuy. Boaz ebay butet Salá i osunuy. Salá ebay butet Nasson i osunuy. Nasson ebay butet Aminadabe i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadabe ebay butet Admim i osunuy. Admim ebay butet Arni i osunuy. Arni ebay butet Esrom i osunuy. Esrom ebay butet Peres i osunuy. Peres ebay butet Judá i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ebay butet Jacó i osunuy. Jacó ebay butet Isaque i osunuy. Isaque ebay butet Abraão i osunuy. Abraão ebay butet Tera i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tera ebay butet Nacor i osunuy. Nacor ebay butet Seruque i osunuy. Seruque ebay butet Ragaú i osunuy. Ragaú ebay butet Faleque i osunuy. Faleque ebay butet Éber i osunuy. Éber ebay butet Sala i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ebay butet Cainã i osunuy. Cainã ebay butet Arfaxade i osunuy. Arfaxade ebay butet Sem i osunuy. Sem ebay butet Noé i osunuy. Noé ebay butet Lameque i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque ebay butet Matusalém i osunuy. Matusalém ebay butet Enoque i osunuy. Enoque ebay butet Jarete i osunuy. Jarete ebay butet Maleleel i osunuy. Maleleel ebay butet Cainã i osunuy. Cainã ebay butet Enos i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos ebay butet Sete i osunuy. Sete ebay butet Adão i osunuy. Adão Deus ipot osunuy, Deus o'g̃ug̃ẽ buye. ");
INSERT INTO myu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jordãodi bewi Jesus epit puje, Ibiõg̃buk xipacat o'tujowat uk'a'ũmat pe. Jesus ag̃uydada'uk osunuy Ibiõg̃buk xipacat. ");
INSERT INTO myu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uk'a'ũmat tag̃ oeku 40 kabia. Jesus Ibiõg̃buk xipacat a'õbacaap kug̃ osunuy. Ibiõg̃buk kẽrẽayũ kukukat tak Jesus o'subuyxijo iboce. Te'e ma ikẽrẽat mujurũg̃at ojuy Jesus pe iboce. 40 kabia Jesus jekõnkõn g̃u osunuy. Ire jĩjã osunuy. ");
INSERT INTO myu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","G̃ebuje ibiõg̃buk kẽrẽayũ kukukat o'jekawẽn Jesus eju. — Ẽn Deus ipot pima, a'õbi ma wita'a juy eyamuwexat pão'am — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","— Ap! — io'e Jesus. — Imẽn e'em Deus ekawẽntup: “Wuyetabẽg̃ wuyxat o'om puye g̃u―Deus wuymutaicin puye acã,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ibocewi ibiõg̃buk kẽrẽayũ kukukat Jesus o'tujowat umat pe. Soat eipi o'g̃ubapuk cebe. Dao ma soat eipi dag̃acat o'g̃ubapuk cebe. Soat ip o'jojojo. ");
INSERT INTO myu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","— Õn cuy emuy soat eipi watwat kukukan — io'e. — Wa'õbi soat eipi watwat kukukan ecesũy — io'e. — “Ẽn acã ocekukukat,” i je'e ip ewebe — io'e. — Ibubut adeayũ kukukan ecesũy wa'õbi — io'e. — Soat ma iũm put owebe omunaẽ be, soat podi ma õn wa'õbaca buye — io'e napa ma. ");
INSERT INTO myu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","— “Ẽn xipat,” i ẽn e'em owebe bima, soat og̃ũm ewebe — io'e. — A'õbuyxian ecesũy wa'õbi — io'e Satanás Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","— Ap! — io'e Jesus. — Imẽn e'em Deus ekawẽntup: “ ‘Xipat ẽn,’ i juy epe'e Deus pe acã,” i. “Deus a'õ kay acã epesop kũyjobin―eykukukat a'õ kay,” i — Jesus o'e Satanás pe. ");
INSERT INTO myu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibocewi o'tujowat Jerusalém ka be. O'jomõg̃ Deus eju kawẽnwẽnap'abi jeje―yabog̃at'abi jeje. — Ẽn Deus ipot pima, ecewemuy'at ijop'abi jejewi ipi ju — io'e Satanás. ");
INSERT INTO myu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","— Imẽn e'em Deus ekawẽntup: “Deus jekawẽn tojotjot'ukayũ g̃uju xipan ekuk am,” i. “Ixeyũ jedaxijo ewebe xipat'ũmat ebapukap puxim,” i. ");
INSERT INTO myu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Ixeyũ jeak ekay wita'a be eimucakcakap puxim,” i — io'e Satanás. ");
INSERT INTO myu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","— Ap! — io'e Jesus. — “Cẽm paxi Deus ja'õ dag̃ e'em?” i'ũmg̃u juy epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","G̃ebuje ibiõg̃buk kẽrẽayũ kukukat o'jewede Jesus xewi. O'jẽm cexewi Jesus puyxijojoap epere buje. Te'e ma Jesus pe ikẽrẽat mujurũg̃at ojuy. O'jẽm. — Waram g̃uto osubuyxijo jĩjã — io'e jewebe ma ibiõg̃buk kẽrẽayũ kukukat―Satanás. ");
INSERT INTO myu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus o'jepit Galiléia eipi kay. Ibiõg̃buk xipacat a'õbacaap kug̃ oeku. Soat ibo eipi watwat yajẽmap awẽg̃ o'yawẽg̃tobuxik. ");
INSERT INTO myu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","G̃ebuje Jesus kawẽn idipan ip o'g̃utaybitbin Deus eju kawẽnwẽnap'a be. — Soat podi ma Jesus xipan wuymutaybitbin — io'e ip ya'ĩjojoayũ. — Ka'ũmg̃u ixe jo'iat xipacat — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus o'ju jaypanap ka kay―Nazaré ka kay. Jay. Oajẽm. Jebodoydoyap kabia bima Judeuyũ õmõm'uk ip osodop Deus eju kawẽnwẽnap'a be. Sábado bima ip õmõm'uk osodop. Jesus oõm jeweju ip ig̃o'a be. O'ãy Deus ekawẽntup com ig̃o'a beacat pe ya'ĩjo am. ");
INSERT INTO myu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","G̃ebuje ig̃o'a kukukat Deus ekawẽntup o'tupũm Jesus pe―Isaías emudupmubararaktup―Deus ekawẽn muwẽnuwẽn'ukat emudupmubararaktup. Jesus o'tupmupaya. Pũg̃tup o'tuptobuxik. Imẽn e'em itedup: ");
INSERT INTO myu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Deus biõg̃buk owebe nuynuy, i. Imẽnpuye ixe onaẽ owebe kawẽn idipat muwẽn ãm tadaybotbocayũ be, i. Ixe omuju owebe: “Taomũnmũnayũ daomũnmũnap'a bewi g̃ujẽm ip” i'e am taomũnmũnayũ be, i. Ixe omuju owebe: “Ita'ũmayũ itate je'e ip” i'e am ita'ũmayũ be, i. ");
INSERT INTO myu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ixe omuju owebe tadaybotbocayũ mujẽm ãm imudadaybotbot'ukayũ xewi, i. Ixe omuju owebe: “G̃axĩn ma Deus jebekitkit idaxijo” i'e am soat pe, i. ");
INSERT INTO myu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Imẽn e'em itedup. Jesus ibodup o'tupcoco ya'õberen. Otupmupirik. Waram o'tupũm yakukukat puywatwat'ukat pe. Oabik. Soat ig̃o'a beacat o'jeak cĩcã Jesus kay. — Apẽntak teku? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","G̃ebuje Jesus o'jekawẽn ceweju ip. — G̃asũ bit soan o'jebapuk ijudup peat ekawẽn tag̃―g̃asũ otupcocoiatup ekawẽn tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Soat xe Jesus xipat cĩcã osunuy ig̃o'a beacat xe. — Jesus ekawẽn soat podi ma cekawẽntip! — io'e ip jewewebe. — Teku José ipot g̃u du? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus o'jekawẽn ceweju ip. — “Tapu, ecewanũg̃ta juy,” i wuyju e'em wuyanũg̃tata'ukat pe — io'e. — Iboap kuka epe'e owebe dak. “Ocejojojo g̃u bukiap cuy eg̃ubapuk ocewebe ijo am apẽn cuk adi eg̃ubapukpuk Cafarnaum ka be bima,” i aco'i eyju e'em owebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","— Icẽmãn õn e'em eywebe. Deus ekawẽn muwẽnuwẽn'ukat jaypanap ka be bima, ibo ka watwat ixe ekawẽn kay g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","— Icẽmãn õn e'em eywebe. Kuyje Deus Elias o'g̃uju pũg̃ kay itop e'ũ'ibit kay―Sarepta ka beat kay―Judeu'ũmat kay―Sidom eipi beat kay. Ixeyũ kabia dag̃ soat kaka beayũ irere oekuku. Ka'ũmg̃u muba'at osodop ebapũg̃ koato, ipidaseat koato dak. Soat ip irere jĩjã osodop. Imẽnpuye ade itop e'ũ'ibiyũ tadaibotbot cĩcã osodop ixeyũ kabia dag̃―Judeuyũ. ");
INSERT INTO myu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","27","Imẽnpit Deus Elias o'g̃uju Judeuyũ kay g̃u―Sarepta ka beacat kay acã―Sidom ka tẽg̃atka beacat kay acã — Jesus o'e. — Deus Eliseu o'g̃uju Naamã kay imu'ada am. Eliseu Deus ekawẽn muwẽnuwẽn'ukat osunuy. Naamã ierepat osunuy. Ade ierepayũ Judeuyũ eipi dag̃ osodop ip ixeyũ kabia dag̃. Imẽnpit Eliseu warara'acat g̃u o'g̃u'ada. Naamã acã o'g̃u'ada — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Iboap ekawẽn co buje oitakomãn cĩcã ip Jesus kay Deus eju kawẽnwẽnap'a beayũ. Jesus o'tujujẽm ip jeka bewi. Jesus o'tujuu ip co'a bicũg̃ kay yaoka am. Ag̃oka ibo'a pẽnpẽn tag̃ o'sukadop. Co'a bicũg̃ pewi yabitorom Jesus muy'at ojuy ip. ");
INSERT INTO myu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Imẽnpit Jesus o'kap cepidase ip. Jeju pinap tag̃ o'ju. ");
INSERT INTO myu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus o'ju Cafarnaum ka kay―Galiléia eipi beat ka kay, ikabog̃atka kay. Judeuyũ o'g̃utaybitbin Deus eju kawẽnwẽnap'a be jebodoydoyap kabia be. Soat esemana imutaybitbin'uk ip osunuy. ");
INSERT INTO myu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","— Cũg̃ cĩcã ma Jesus wuymutaybitbin — io'e ip. — Jesus ja'õbi ma wuymutaybitbin — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","G̃ebuje ag̃okatkat o'jewãwã ig̃o'a beat―ibiõg̃buk kẽrẽat kukat. O'jewãwã ya'õberen ibiõg̃buk kẽrẽat cebe buye. ");
INSERT INTO myu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Jesus, apẽn ẽn em ocewebe? — io'e Jesus pe―Nazaré ka bewiat pe. — Ocemuy'ũ ãm tu ejot? — io'e. — Wetaybit ẽn — io'e. — Ẽn Deus ipot―ikẽrẽat kug̃'ũmat ipot — io'e. ");
INSERT INTO myu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","G̃ebuje Jesus ibiõg̃buk kẽrẽat o'g̃ukorẽm. — Ecemũg̃ — io'e Jesus cebe. — Ejẽm cuy ag̃okatkat pewi — io'e ibiõg̃buk kẽrẽat pe. Ag̃okatkat pewi o'jẽm ipi ju imuy'at'an pima. Imẽnpit warẽmtag̃ g̃u ag̃okatkat o'jukuk cẽmcẽm pima. ");
INSERT INTO myu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Imẽnpuye itabẽg̃bẽg̃ o'e ip ijojom―ibiõg̃buk kẽrẽat o'g̃ujẽm iap cocomayũ. — Jesus ibiõg̃buk kẽrẽat mujẽmjẽm ja'õbi — io'e ip. — Ya'õbacaat teku — io'e ip jewewebe. — Itaybit ibiõg̃buk kẽrẽat mujẽm ãm — io'e. — Imẽnpuye cẽmcẽm ip ya'õbi — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Soat ka dag̃ Jesus awẽg̃ o'yawẽg̃cu―Galiléia eipi korerenat ka dag̃. ");
INSERT INTO myu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ibocewi Jesus o'jẽm Deus eju kawẽnwẽnap'a bewi. O'ju Simão Pedro duk'a kay. Oajẽm. Cereg̃. Oõm. Simão daxijo osodop ibo'a be. Ipa'i jĩjã osodop. — Ipa'iat eg̃u'ada — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","G̃ebuje Jesus o'ju ipa'iat kay. Pa'i o'g̃ukorẽm. — Ejẽm cebewi — Jesus o'e pa'i be. Imẽnpuye pa'i o'jẽm. Xipat o'e. Ipa'i topibit o'kop g̃ebuje bit. Ixat o'g̃ug̃ẽ Jesus peam, cewejuayũ beam tak. ");
INSERT INTO myu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kaxi at puje ibo ka watwat iwãtaxipipiayũ o'tujowat Jesus kay imu'ada am. Soat kug̃ ip osodop iwãtaxipi. Jesus o'jewebumõg̃ cebe ip―soat pe. Soat ip o'g̃u'ada'ada. Adah. ");
INSERT INTO myu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ibiõg̃buk kẽrẽat o'g̃ujẽmjẽm ikukayũ bewi. Poxerewun. O'jẽm. — Ẽn Deus ipot — io'e ip ya'õberen―ibiõg̃buk kẽrẽayũ o'e. Itaybit ip osodop Jesus Deus emunaẽ iam. Inaka Jesus ibu'u osunuy ixeyũ be iboap muwẽn ãm. — Õn Deus emunaẽ iap epeg̃uwẽn g̃u juy — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kabia'isum Jesus o'jẽm Simão Pedro duk'a bewi. Poxerewun. O'ju uk'a'ũmat pe. Jay. Oajẽm. Adeayũ Jesus kudadam o'e ip. Jay. Oajẽm ip Jesus kay. — Ejẽm g̃u juy ocexewi. Ijoce ma juy eg̃ũy — io'e ip Jesus pe. G̃ebuje o'jekawẽn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","— Warara'acayũ be dak kawẽn idipat og̃uwẽn―wara'atka watwat pe dak — io'e. — “Deus soat kukukan je'e,” i juy oce cebe ip — io'e. — Deus cuk omudot ibo ekawẽn muwẽn ãm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Imẽnpuye kawẽn idipat muwẽnuwẽn oeku Deus eju kawẽnwẽnap'a be. Judéia eipi dag̃ imuwẽnuwẽn oeku―soat kaka dag̃. ");
INSERT INTO myu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Adeayũ o'jewemuwunuwun ip Jesus ekawẽn co pin cĩcã buye. Jesus cũg̃'i osunuy iodi wãbu ka'oririt pe. Iodi Genesaré eipi be o'tinuy. Genesaré i tibutet osunuy. Adeayũ jewemuwunuwun ip Deus ekawẽn co pinayũ. ");
INSERT INTO myu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","G̃ebuje Jesus xepxep kobe o'jojojo kapurũg̃ pe. Axima bubu'ukayũ jekobe be g̃u ip osodop. Kuy o'jẽm ip. Axima bubuap wuywuy ip osodop kapurũg̃ pe. ");
INSERT INTO myu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus oõm pũg̃ pe ixeyũ ekobe be―Simão ekobe be. — Kobe eg̃uwun — io'e. — Eg̃uwun cuy kapurũg̃ pewi — io'e Jesus Simão be. Xik. Jesus oabik kobe be. Kobe be bima adeayũ o'g̃utaybin―kapurũg̃ peayũ o'g̃utaybin. ");
INSERT INTO myu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Imutaybin pu'u bima, o'jekawẽn Simão eju―kobe iwat eju. — Tibucũg̃ pe aju axima bum — io'e. Tibucũg̃ pe ip o'ju. — Axima bubuap cuy eg̃uakõm tibucũg̃ pe axima bu am — io'e Simão be. ");
INSERT INTO myu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","— Kariwa, ixima bun oceku axima bu ojuy — io'e Simão. — Ocejat g̃u. Imẽnpit waram oceg̃uakõm imẽn ẽn e'em ocewebe buye — io'e. Sa. Axima bubuap o'g̃uakõm. ");
INSERT INTO myu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","G̃ebuje axima o'jat ade. Xeresu g̃u axima. Kurekoh. Axima bubuap jewek ojuy axima poxi pibun. ");
INSERT INTO myu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wẽg̃wẽg̃'i o'e ip jebureyũ kay―wara'at kobe beacayũ kay. Jebureyũ o'takoy yajẽm ãm jebuywat am. Ibureyũ oajẽm ibuywat am. Xepxep kobe o'g̃uporan ip aximãm. Imẽnpuye kobe jepirig̃ ojuy axima poxi pibun. ");
INSERT INTO myu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Iboap co buje, Simão Pedro o'jẽg̃'aecõg̃cõg̃ Jesus wap jexe ya'õbuyxi buye. — Okukukat, wede ece oxewi — io'e. — Õn ma ikẽrẽat kug̃. Ẽn pit a'õbuyxi. Oxe g̃u juy eg̃uy — io'e―Simão o'e. ");
INSERT INTO myu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simão itabẽg̃ o'e ijojom, soat cewejuayũ dak. Itabẽg̃bẽg̃ ip o'e ijojom ade jĩjã axima buye. ");
INSERT INTO myu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Warara'acayũ dak itabẽg̃bẽg̃ ip o'e ijojom―Tiago, João dak. Ixeyũ xepxepayũ Zebedeu ipotpoyũ ip osodop. Simão eju kapikpik'uk ip osodop axima bubum. G̃ebuje Jesus o'jekawẽn Simão eju. — A'õ'cam cuy eg̃uy — io'e Simão be. — G̃asũ bit axima bubu'ukan g̃u juy eg̃uy, — io'e. — Kawẽn idipat muwẽnuwẽn'ukan cuy eg̃uy adeayũ be imutabut am ip Deus kay — io'e. — Ha'a — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","G̃ebuje Simão o'ju Jesus kay, cewejuayũ dak. Putwedu'i. Jekobe o'tujuu ip kapurũg̃ pe. Soat o'suiwat ip ibun Jesus eju jeku am. Soat em Jesus eju oekuku ip. ");
INSERT INTO myu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ikabog̃atka be bima ag̃okatkat oajẽm Jesus kay―ierepat. O'jẽg̃'aecõg̃cõg̃ cewap jexe ya'õbuyxi buye. — Kariwa! — io'e Jesus pe. — Ebu'u'ũm pima, omu'adam ece — ierepat o'e. ");
INSERT INTO myu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pucũg̃. Jesus o'jebaepucũg̃ cekay. — Obu'u g̃u emu'adam — io'e. — G̃axĩn ma õn jemu'ada — io'e. Jesus a'õbi ierep topibit dao ma o'je'ada. Xipat o'e. ");
INSERT INTO myu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","— Emu'adaap eg̃uwẽn g̃u juy warara'acayũ be — io'e Jesus cebe. — G̃asũ bit paĩ kay juy eju — io'e. — Eõhõyũ'in cuy eg̃ũm paĩ be imupik am Deus etabixe ece'ada buye. Eg̃ũm cuy cebe Moisés ekawẽn tag̃. Eõhõyũ'in cuy eg̃ũm cebe e'adaap mubapuk am soat ka watwat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Imẽnpit soat ka watwat Jesus awẽg̃ o'yawẽg̃tobuxik ip―ierepat o'g̃u'ada iap awẽg̃. Imẽnpuye adeayũ o'je'awero ip ixe ekawẽn co am. O'je'awero ip Jesus pe jewemu'ada am tak. ");
INSERT INTO myu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesus pit o'jẽm cexewi ip. Poxerwun. Cexewi ip cẽmcẽm'uk osunuy jekawẽn ãm Deus eju. Uk'a'ũmat pe kawẽnwẽn'uk osunuy Deus eju. ");
INSERT INTO myu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","G̃ebuje Jesus adeayũ o'g̃utaybitbin kawẽn idipan. Fariseuyũ kaxikxik'i osodop iboce, Moisés ekawẽn imutaybitbin'ukayũ dak. Judeuyũ osodop ip. Jesus ekawẽn co ojuy osodop ip. Oajẽm ip soat kaka dag̃wi―Galiléia eipi dag̃wi, Judéia eipi dag̃wi dak, Jerusalém ka bewi dak. Jesus iwãtaxipipiayũ mu'ada'adam osunuy Deus a'õbacaap kug̃ puye. ");
INSERT INTO myu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","G̃ebuje ag̃okatkayũ oajẽm Jesus kay. Cexĩg̃xĩg̃ pa'oreat o'tujuajẽm ip Jesus kay. Jay. Uk'a be tujuõm ojuy ip cexĩg̃xĩg̃ pa'oreat mõg̃ ãm Jesus wap. ");
INSERT INTO myu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Imẽnpit tujuõm pa'ore ip o'e uk'a yapora buye. Imẽnpuye o'jeu ip uk'a abi jeje. Weru. Kawi'a'a o'ya'uk ip. Cabobum cexĩg̃xĩg̃ pa'oreat o'g̃ukop ip yabitokat tag̃wi. Kop. O'g̃ukop ip ixexecaptup pe. O'g̃ukop ip Jesus wap imu'ada am. Uk'a beayũ parakpe o'g̃ukop ip. ");
INSERT INTO myu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus itaybit o'e teyũku itabut okay iam. G̃ebuje Jesus o'jekawẽn cexĩg̃xĩg̃ pa'oreat pe. — Tapu — io'e. — Ikẽrẽat kuy oju'uk ewebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moisés ekawẽn imutaybitbin'ukayũ, Fariseuyũ dak jewag̃uydadam o'e ip Jesus ekawẽn kay. — Ite be ikẽrẽat'uk pa'ore wuywebewi. Deus pe acã i'uk put — io'e ip jewewebe. — Teku Deus muymuy — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus itaybit o'e apẽn ip o'e jewag̃uydadam iam. ");
INSERT INTO myu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","— Apẽnpuye dak eyju imẽn jewag̃uydadam? — io'e. — Iba'ore g̃u owebe “Ikẽrẽat kuy oju'uk ewebewi” i'e am cebe — io'e. — Iba'ore g̃u dak owebe “E'ãy” i'e am cebe, “Ece'ada,” i dak — io'e. — Ka'ũma ma iba'ore owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","— Soat wag̃o õn. G̃asũ cexĩg̃xĩg̃ pa'oreat eju ocekawẽn eymutaybit am owebe ikẽrẽat'uk put ijodiat pewi iam. Deus a'õbacaap kug̃ õn ijodi bima dak — io'e cebe ip. — E'ãy! Ecexĩg̃xĩg̃ cuy — Jesus o'e cexĩg̃xĩg̃ pa'oreat pe. — Cũg̃cũg̃ cuy eju — io'e. — Exexecaptup cuy etupu — io'e. — Eju juy eduk'a be — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cexĩg̃xĩg̃ pa'ore topibit o'je'ada. O'ãy. Cũg̃cũg̃ ma o'e adeayũ etabutpe. Jexexecaptup o'tupu. Kuruk. “Ka'ũmg̃u ejo'iat xipacat,” i'e'em Deus pe bima, o'ju jeduk'a be. ");
INSERT INTO myu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Imẽneju ibo ka watwat itabẽg̃bẽg̃ ip o'e ijojom, o'jexĩg̃xĩg̃ puye. — O'je'ada xeku — io'e ip. — Xĩg̃xĩg̃ o'e xeku — io'e ip. Yag̃uybabi'ũm ip o'e. — Ka'ũma buk cexĩg̃xĩg̃ pa'oreat o'g̃u'ada wuyetabutpe — io'e ip jewewebe. — G̃asũ acã cexĩg̃xĩg̃ pa'oreat mu'adaap ajojojo — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","G̃ebuje Jesus o'jẽm. Porewuh. Cucum pima Levi o'jojojo. Levi dinheiro bubu'uk osunuy iecug̃ap peam. Ixe Levi kapikpig̃ osunuy iecug̃ap pe teidadaap'a be. — Ejot cuy okay — io'e Jesus. — Oweju juy ejeku — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Imẽnpuye o'ju Jesus kay. Soat o'suiwat ibun Jesus eju jeku am. ");
INSERT INTO myu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","G̃ebuje Levi Jesus o'takoy jekõn ãm jeweju. O'ju. Oajẽm. Jay. Adeayũ awerom osodop Levi dukta be―iecug̃ap peam dinheiro bubu'ukayũ, warara'acayũ dak. Jesus o'jekõn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","G̃ebuje Fariseuyũ Jesus o'jomuymuy Moisés ekawẽn imutaybitbin'ukayũ dak―Fariseuyũ ebekitkit. — Apẽnpuye dinheiro bubu'ukayũ eju eyju jekõnkõn, ikẽrẽat mujurũg̃rũg̃'ukayũ eju dak? — io'e ip Jesus eju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus o'jekawẽn ceweju ip. — Iwãtaxipi'umat g̃u cucum wuyanũg̃tata'ukat kay―iwãtaxipiat acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","— Imẽnpuxim cũg̃ ma jekuku'ukayũ nomuwã ãm g̃u ojot―ikẽrẽat mujurũg̃rũg̃'ukayũ nomuwã ãm acã — io'e. — Ojot “Eyg̃uycũg̃cũg̃ cuy epesop ikẽrẽat kug̃ puye” i'e am cebe — io'e Jesus. — “Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere” i'e am tak ojot — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","— João eju etaybitbinayũ soat em jekpiwan ma jewemureren xipat je'e am Deus xe — io'e ip Jesus pe. — Deus eju kawẽnwẽn tak ip soat em — io'e ip cebe. — Fariseuyũ eju etaybitbinayũ dak ade em ip jekpiwan ma jewemureren jekawẽn ãm Deus eju — io'e ip. — Eweju etaybitbinayũ bit repi'ajojom g̃u. Jekõnkõn ip — io'e ip. — Apẽnpuye ip repi'ajojom g̃u? — io'e ip. Jesus muymuy ojuy osodop ip. ");
INSERT INTO myu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","— Iba'ore oweju etaybitbinayũ be jekpiwan ma repi'ajo am õn ceweju ip puye — io'e Jesus. — Õn iwadip puxim — io'e. — Iwadip cexe ip pima, ka'ũma ma jekpiwan ma repi'ajojom jewebumũnap epeta be tomuwa'ibiyũ. Jekõnkõn acã ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","— G̃uyjom pit iwadip je'jẽm cexewi ip. Ijẽm puje bit, jekpiwan ma repi supi'ajo ip — io'e. — Õn ixeyũ xe'ũm pima, oweju etaybitbinayũ dak jekpiwan ma repi ip supi'ajo — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. Imẽn o'g̃uwẽn. — Iwuywuy'ũmat g̃u ajoinũm iokokat muwaket am — io'e. — Iwuywuy'ũmat inũm pima, kuka o'jewek. Iwuywuy'ũmat kuka o'jewa'i — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","— Uva'abidi atimuõm yaokokat'a be g̃u timun'a be tiisuati―yaisuat'a be acã — io'e. — Yaokokat'a be timuõm puje, tidai e'em — io'e. — Yaokokat'a timun'a kuka o'jeaebag̃. Uva'abidi dak kuka o'jediepuy — io'e. — Timũn'a dak kuka o'ya'ũm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","— Imẽnpit tiisuati atimõg̃ yaisuat'a be timũn'a be — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","— Uva'abidi kõn puje kuyati kõn puje, tiisuati kay g̃u ace'e — io'e. — “Kuyati tiku e'em uva'abidi,” i wuyju e'em — Jesus o'e. — Imẽnpuxim kuyjeat ekawẽn kay bima, wekawẽn kay g̃u kuka epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jebodoydoyap kabia be ceweju etaybitbinayũ trigodadot o'tadot'uk cucum pima ku dag̃ Jesus eju. ");
INSERT INTO myu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","O'tamukitikitik ip jebui be. O'ta'o'o ip. — Apẽnpuye eyju ta'uk'ug̃? — io'e Fariseuyũ cebe ip. — Kapikpi wuywebe jebodoydoyap kabia be — io'e ip. Tamukitikitikap kapikap osodop Fariseuyũ xe. Imẽnpuye Jesus o'jomuymuy ip. ");
INSERT INTO myu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","— Apẽn cuk o'e Davi, ibureyũ dak, irere bima? — io'e Jesus. — Iboap ekawẽntup epetupco g̃u du? — io'e Jesus Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ixe Davi oõm Deus eju kawẽnwẽnap'a be. Pão'a o'yabu―Deus etabixe yamõg̃mõg̃'ibit'a. O'ya'o. O'yaũm jebureyũ be ya'opiat'a. Paĩyũ be acã ya'o pi g̃u o'yadop — io'e. — Iboap ekawẽntup epetupco g̃u du? ");
INSERT INTO myu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Soat wag̃o õn — Jesus o'e Fariseuyũ be. — Õn pit e'em apẽn i'epi wuywebe jebodoydoyap kabia be iap, apẽn i'epi g̃u iap tak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","G̃ebuje Jesus ibakẽrẽat o'tobuxik. Jebodoydoyap kabia be o'tobuxik. Oõm ma'g̃uto Deus eju kawẽnwẽnap'a be. Ibo'a be o'g̃utaybitbin. Ibo'a be ag̃okatkat osunuy. Pũg̃pa ibakẽrẽ osunuy―ibaatpa. ");
INSERT INTO myu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jesus kay ag̃ cĩcã o'e ip Fariseuyũ, Moisés ekawẽn imutaybitbin'ukayũ dak. — Jebodoydoyap kabia be dak paxi g̃u'ada? — io'e ip jewewebe. Fariseuyũ “Jesus Moisés ekawẽn tag̃ g̃u jekukum” i'e ojuy napa ma. ");
INSERT INTO myu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","— Omuymuy pin teyũku — io'e Jesus pit jewebe ma. G̃ebuje Jesus o'jekawẽn ibakẽrẽat pe. — E'ãy — io'e. — Ejot cuy ijoce soat pe ejo am — io'e. Ibakẽrẽat o'ãy. O'ju ibo'a beayũ wap. ");
INSERT INTO myu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","G̃ebuje Jesus o'jekawẽn Fariseuyũ eju, Moisés ekawẽn imutaybitbin'ukayũ eju dak. — Jebodoydoyap kabia be Moisés ekawẽn tag̃ tu wuywebe xipan i'e am? Ikẽrẽan i'e am g̃u xe'e? — io'e. — Warara'acat taxijo am cekawẽn tag̃ tu? Warara'acat aoka am g̃u xe'e? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","G̃ebuje Jesus o'jeak soat kay. — Pacũg̃ ece eba — Jesus o'e ibakẽrẽat pe. O'jepacũg̃. Ibadip o'e. ");
INSERT INTO myu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Imẽnpuye Fariseuyũ itakoma jĩjã ip o'e Jesus kay, Moisés ekawẽn imutaybitbin'ukayũ dak, jebodoydoyap kabia bima o'subamudim puye. O'je'awero ip. O'jewawẽwẽ ip pẽn paxi ace'e Jesus pe i'e am. ");
INSERT INTO myu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","G̃uyjom Jesus o'ju co'a be jekawẽn ãm Deus eju. Ixima bun o'jekawẽn ceweju. ");
INSERT INTO myu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","G̃ebuje 12 beayũ o'taẽ jeweju etaybitbinayũm. Kabia'isum ixeyũ o'taẽ. — Wa'õbi epeju wekawẽn muwẽn ãm soat pe — io'e ixeyũ be―12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ibũrũn ma ip ibutet osodop: Simão i, André i, Tiago i, João i, Filipe i, Bartolomeu i, Mateus i, Tomé i, wara'at Tiago i, wara'at Simão i, Judas i, wara'at Judas i. Ibũrũn ma ip ibutet osodop. Ibũrũn ma o'taẽ jeweju etaybitbinayũm. Tiago Alfeu ipot osunuy. Jesus Simão wara'an o'subuteta. Pedro i wara'at ibutet osunuy. Xepxep putet osunuy Simão butet. Jeipi kay jĩjãat i dak ibutet osunuy. André Pedro kitpit osunuy. Judas Tiago ipot osunuy. Xepxep putet osunuy Judas putet. Iscariotes i dak ibutet osunuy. Ixe Judas g̃uyjom Jesus o'g̃ũm cekay itakomaayũ be yaoka am. ");
INSERT INTO myu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ibocewi Jesus co'a dag̃wi o'kop jemunaẽyũ eju―12 beayũ eju. G̃ebuje adeayũ oajẽm Jesus kay. Warara'acayũ kuy Jesus xe osodop ip―ceweju etaybitbinayũ. Adeayũ kaweg̃ũnat pe o'je'awero Jesus xe. Wũywi ip oajẽm. Judéia eipi dag̃wi oajẽm ip, Jerusalém ka bewi dak, Tiro ka bewi dak, Sidom ka bewi dak. ");
INSERT INTO myu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Oajẽm ip Jesus ekawẽn co am, jemu'ada am tak. Ibiõg̃buk kẽrẽat kukayũ dak oajẽm cekay imujẽm ãm. Jesus ibiõg̃buk kẽrẽat o'g̃ujẽmujẽm ikukayũ bewi. Imẽnpuye Jesus mucay ojuy ip imu'ada am. ");
INSERT INTO myu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ixe be imu'ada but osunuy Deus a'õbacaap kug̃ puye. Soat o'g̃u'ada'ada iwãtaxipipiayũ. ");
INSERT INTO myu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus o'jeak jeweju etaybitbinayũ kay. O'jekawẽn cebe ip. Koap o'jekawẽn tadaybotbocayũ be. Eycokcok cĩcã eyju — io'e. — Eybubutbet g̃u g̃asũ. Imẽnpit Deus eykukukat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","— Eycokcok cĩcã eyju. G̃asũ acã eyrere. G̃uyjom pit eybeg̃beg̃ epesop — Jesus o'e. — Eycokcok cĩcã eyju. G̃asũ acã eyju wa. G̃uyjom pit jewaywayway epesop. ");
INSERT INTO myu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Eycokcok cĩcã juy epesop warara'acat itakoma eykay bima, eywebe “Oceweju g̃u juy epeku―eyju soat wag̃o ebekitkit puye” i'e buje dak, warara'acat eymuymuy bima dak, warara'acat eyawẽg̃mukẽrẽrẽrẽn pima dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","— Eycokcog̃ cĩcã juy epesop warara'acat warẽmtag̃ eykug̃ pima eyju webekitkit puye — io'e. — “Eycokcog̃ cuy epesop,” i õn e'em eywebe — io'e. — Kabi be ade kug̃ epesop idipat kug̃. Warẽmtag̃ ma Deus ekawẽn muwẽnuwẽn'ukayũ kukuk'uk osodop ip eydobuyũ'ũm'ũm kuyje — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","G̃ebuje Jesus o'jekawẽn ibubut adeayũ be. — Karem g̃u eydadaybot epesop — io'e. — G̃asũ eybubut ade — io'e. — Kapikpig̃'ũm pima dak soat kug̃ eyju g̃asũ ma. ");
INSERT INTO myu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Karem g̃u eydadaybot epesop. G̃asũ acã eybeg̃beg̃. G̃uyjom pit eyrere epesop. Karem g̃u eydadaybot epesop. G̃asũ acã eyju jewaywayway. G̃uyjom pit wawa epe'e. Eyg̃uycũg̃cũg̃ epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","— Karem g̃u eydadaybot epesop, warara'acat xipan eymuwẽnuwẽn pima. Imẽnpuxim xipan jewexe Deus ekawẽn muwẽnuwẽn'ukayũ kukuk'uk ip osodop eydobuyũ'ũm'ũm kuyje — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","G̃ebuje soat pe o'jekawẽn. — Õn kawẽnwẽn soat eju eyweju―soat wa'ĩjojoayũ eju — io'e. — “Eykay itakomaayũ burem cuy epesop,” i õn e'em eywebe — io'e. — “Xipan cuy ixeyũ epejukuk,” i õn e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","— “Xipan cuy omuymuy'ukayũ ejukuk,” i juy epe'e Deus pe. Deus eju juy epeyekawẽn warẽmtag̃ eykukayũ beam — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","— Pũg̃ kadi warara'acat pe eydopaoka buje, epeyaoka g̃u juy. Ãg̃ puk wara'at kadi jeydopaoka. Warara'acat pe eyekabek pu buje, ãg̃ cuy eyekamixa dak ju'uk. ");
INSERT INTO myu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Eyxewi iojuy buje, epeg̃ũm cuy soat pe. Warara'acat pe darem eybubut pu buje, “Obubut cuy epetujupit okay,” i'ũmg̃u juy epe'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eybikuy warara'acat pe xipan eykuk am. Imẽnpuye xipan cuy warara'acat epejukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","— Eykayayũ acã ikukpin eyxe bima, “Deus cuy xipacat je'g̃ũm ocewebe,” i'ũmg̃u juy epe'e. Cekayayũ ikukpin ikẽrẽat mujurũg̃rũg̃'ukayũ xe dak. ");
INSERT INTO myu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xipan eykayayũ kug̃ acã bima, “Deus cuy xipacat je'g̃ũm ocewebe,” i'ũmg̃u juy epe'e. Ikẽrẽat mujurũg̃rũg̃'ukayũ dak xipan jekayayũ kug̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","— Eyju darem iũmũm warara'acat pe waram tujupit okay iam eyetaybit puye. Imẽn iũmũm pima, “Deus cuy xipacat je'g̃ũm ocewebe,” i'ũmg̃u juy epe'e. Ikẽrẽat mujurũg̃rũg̃'ukayũ dak darem ma iũmũm wara'at ikẽrẽat mujurũg̃rũg̃'ukat pe dinheiro buap ojuy cexewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","— Ikẽrẽat mujurũg̃rũg̃'ukayũ ekukuap puxim g̃u juy epeku! — io'e. — Warẽmtag̃ g̃u juy eykay itakomaayũ epejukuk. Xipan cuy ip epejukuk. Darem ma epeg̃ũm cebe ip ibubut puap ojuy g̃u. Imẽn eyeku buje, ade xipacat kug̃ epesop kabi be. Deus ebekitkiyũm epesop. Soat podi ma ya'õbacaat ebekitkiyũm epesop. “Ẽn xipat,” i'ũmg̃u e'em adeayũ Deus pe. Deus pit soat em xipacat ũmũm cebe ip―soat pe―ikẽrẽat mujurũg̃rũg̃'ukayũ be dak. ");
INSERT INTO myu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wuyebay itabotaidabotbot soat kay wuykay. Ixe buxim eyju dak eyetabotaidabotbon cuy epesop warara'acat kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","— “Ekẽrẽ jĩjã Deus xe,” i'ũmg̃u juy epe'e warara'acat pe. Iboap e'em'ũm pima, Deus tak “Eykẽrẽ oxe,” i'ũmg̃u je'e eywebe. “Ikẽrẽat kug̃ ẽn,” i'ũmg̃u juy epe'e warara'acat pe. Imẽn e'em'ũm pima, Deus “Ikẽrẽat kug̃ eyju,” i'ũmg̃u dak je'e eywebe. G̃ebum g̃u juy epesop apẽn cuk adi warara'acat warẽmtag̃ eykuk iap kay. G̃ebum'ũm pima, Deus tak g̃ebum g̃u je'e apẽn cuk adi warẽmtag̃ wara'acat epejukuk iap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","— Warara'acat pe epeg̃ũm pima, Deus tak je'g̃ũm eywebe. Apẽn cuk epeg̃ũm iap puxim epejat. Yobog̃at epeg̃ũm pima, eyju dak yobog̃at epejat. Topapũn epejat―iwajem, ibikbig̃ tak, kutukutu'i ma dak, cũg̃'i ma dak. Apẽn warara'acat pe eyju iũmap puxim Deus tak je'g̃ũm eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. — Ita'ũmat pe emubapuk pa'ore wara'at ita'ũmat pe — io'e. — Ita'ũmat pe wara'at ita'ũmat tujowat puje, xepxem ma kuka ip o'at ipikũykũy be. ");
INSERT INTO myu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Eyetaybitbin pima, eyemutaybitbin'ukat podi g̃u eyetaybit. Eyewemutaybitan cĩcã bima bit, eyemutaybitbin'ukat co'i eyetaybit epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","— Te'e ma eyju jeakag̃ eybure eta beatõmtõm kay, eyeta beap'ip cocom'ũm pima. ");
INSERT INTO myu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Te'e ma eyju e'em cebe: “Tapu, ma, otõmtõm'uk eta bewi,” i, eyeta beap'ip cocom'ũm pima. Eyju jewewemug̃uykukukum. Koam eyeta beap'ip cuy epeyop'uk. Yop'uk puje, iba'ore g̃u je'e eywebe tõmtõm'uk am eybure eta bewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","— Yoptipat'ip pe yakẽrẽat'a'e g̃u―yadipat'a'e acã. Imẽnpuxim yopkẽrẽat'ip pe yadipat'a'e g̃u―yakẽrẽat'a'e acã. ");
INSERT INTO myu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yajo buje, wuyetaybit ace'e pubeat'ip poro iam. Asão'a bubum wuyju widaoho'ip tag̃wi g̃u―asão'ip tag̃wi acã. Banka'a bubum wuyju arũ'ip tag̃wi g̃u―banka'ip tag̃wi acã. ");
INSERT INTO myu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Imẽnpuxim xipacayũ ma xipacat mujurũg̃rũg̃. Xipat'ũmayũ bit ikẽrẽat mujurũg̃rũg̃. Apẽn wuyju jewag̃uyg̃uy iap puxim wuyju kawẽnwẽn. Ikẽrẽat kay jewag̃uyg̃uy bima, ikẽrẽãn wuyju e'em. Idipat kay jewag̃uyg̃uy bima bit, xipacan wuyju e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","— Eyju te'e ma e'em owebe “Ẽn ocekukat,” i, wa'õ kay kũyjobit'ũm pima — io'e. ");
INSERT INTO myu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","— Abu-buxim okay ajẽmjẽmayũ iap og̃uwẽn eywebe―abu-buxim wa'õ kayayũ iap tak, ajo-buxim wa'õ dag̃ jekuku'ukayũ iap tak. ");
INSERT INTO myu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Itaybicat puxim ip―ag̃okatkat puxim. Ixe ag̃okatkat uk'a o'yamuy. Koap ipikũykũy o'sukũykot. Ikũyberen o'sukũykot. Wita'a o'yadobuxik badi. Uk'a'abi'ip o'yopmuy ig̃okũy be badiat'a jeje―wita'a jeje. Cem uk'a o'yamuy. Kabidoxixi oajẽm ig̃o'a kay, muba'atxiri dak. Muba'at idibi o'timubog̃. O'tiajẽm ig̃o'a kay. Imẽnpit o'ya'at g̃u yacem puye―wita'a jeje buye. Wa'õ kayayũ ixe ag̃okatkat puxim―cem jeduk'a o'yamuy'iat puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","— Wa'õ dag̃ g̃u jekuku'ukayũ bit warẽmtag̃ uk'a o'yamuy'iat puxim―wa'õ kay'ũmayũ. Wa'ĩjojom ip. Inaka kũyjobit g̃u ip wa'õ kay. Warẽmtag̃ uk'a o'yamuy'iat puxim ip―ag̃okatkat puxim. Ixe ag̃okatkat uk'a o'yamuy ipi ju. Cem g̃u o'yamuy. Idibi o'tiajẽm ig̃o'a kay―tibog̃ati. Dao ma o'ya'at. O'ya'ũm cĩcã. Wa'õ dag̃ g̃u jekuku'ukayũ ixe ag̃okatkat puxim―wa'õ kay kũyjobit'ũmayũ. Cem'ũma jeduk'a o'yamuy'iat puxim ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Adeayũ be jekawẽn epere buje, Jesus o'ju Cafarnaum ka kay. Oajẽm. Sorarayũ kukat ibo ka be osunuy. ");
INSERT INTO myu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ixe ibuywatwat'ukat iwãtaxipi o'e―kariwa xe ikukpinat. Oe'ũ pin ibuywatwat'uikat. ");
INSERT INTO myu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","G̃ebuje sorarayũ kukat pũg̃pũg̃ Judeuyũ kukukayũ o'g̃uju Jesus kay. O'g̃uju ip Jesus Cafarnaum ka be iam o'jekũyjo buye. — “Ejot cuy obuywatwat'ukat mu'ada am,” i juy epe'e Jesus pe — io'e sorarayũ kukat ixeyũ be. O'jẽm ip. Poxerewun. Jay. ");
INSERT INTO myu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Oajẽm ip. O'jekawẽn ip Jesus eju. — Cemuojuyjuy juy eg̃ũm ixe sorarayũ kukat pe — io'e ip Jesus pe. — Xipat cĩcã ixe ocexe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","— Ocebadipyũ ikukpin cĩcã ixe xe — io'e ip. — Deus eju kawẽnwẽnap'a o'yamuyat ocewebeap'am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Imẽnpuye Jesus o'ju ceweju ip. Sorarayũ kukat tuk'a wi wũy'ũm pima, sorarayũ kukat jebureyũ o'g̃uju Jesus dopabe. O'g̃uju ip ja'õmuwẽn ãm cebe. O'jẽm ip. Poxerewu. Jay. Ibureyũ oajẽm Jesus kay. O'jekawẽn ip Jesus eju. — Ocebure ocemudot ja'õmuwẽn ãm ewebe — io'e ip Jesus pe. — A'õmudodon ewebe — io'e ip Jesus pe. — “ ‘Kariwa, ecewemuwa'ũm g̃u juy oduk'a kay edot am,’ i juy ece,” io'e ocewebe — io'e ip Jesus pe. — “ ‘Osũsũn emudon oduk'a be. ");
INSERT INTO myu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cedag̃ g̃u emudot am oduk'a be wa'õbuyxi'ũm puye,’ i juy ece cebe,” io'e ocewebe — io'e ip Jesus pe. — “ ‘ “Ece'ada juy,” i ẽn e'em pima, obuywatwat'ukat je'ada. ");
INSERT INTO myu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Õn tak warara'acat mujujum. Wa'õ kay kũyjobit ip wesorarayũ. Pũg̃ pe õn e'em “Ejẽm” i bima, je'jẽm. Wara'at pe õn e'em “Ejot” i bima, je'dot. Obuywatwat'ukat pe õn e'em: “Imẽn cuy ece,” i bima, imẽn je'e,’ i juy ece Jesus pe,” io'e ocewebe — io'e ip Jesus pe. — Imẽn ja'õmudodon ewebe — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iboap co buje Jesus itabẽg̃ o'e ixeyũ ekawẽn cocom. O'jekorepẽn adeayũ kay. — Soat Judeuyũ etabucap podi ma itabut okay ig̃o sorarayũ kukat, Judeu g̃u ma'g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","G̃ebuje Jesus kay o'g̃uju'iayũ o'jepit sorarayũ kukat tuk'a kay. Ibuywatwat'ukat o'tobuxik ip―iwãtaxipi topibit. Kuy xipat o'e Jesus a'õbi. ");
INSERT INTO myu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","O'ju jeweju etaybitbinayũ eju. Ade warara'acayũ dak o'ju ceweju. Naim ka be o'ju ip. ");
INSERT INTO myu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesusyũ oajẽm ikabog̃atka exĩntabi be―Naim ka exĩntabi be. Jay. Ibocewi ag̃okatkayũ yaypan'isuat'ũm tujujẽmjẽm ip o'e ikabog̃atka bewi ikot am. Ce'ũat xibuk i'it'et g̃u osunuy wara'at. Jag̃epũg̃ ma dak osunuy ce'ũat xibuk. Itop'ũm e'ũ'ibit osunuy. Adeayũ o'ju ce'ũat xibuk eju ibo ka watwat. ");
INSERT INTO myu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wuykukukat Jesus ite jo buje, itabotaidabotbot cĩcã o'e ce'ũat xibuk kay. — Wa g̃u, tũ'ũ — Jesus o'e ce'ũat xibuk pe. ");
INSERT INTO myu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","O'ju ce'ũat kay. Ce'ũat tujujẽmjẽmap o'g̃ucay. Ce'ũat tujujẽmjẽmayũ o'jecũ ip e bidase. — Tapu — Jesus o'e. — Ag̃obucẽg̃ ece — io'e ce'ũat pe. ");
INSERT INTO myu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","G̃ebuje ce'ũ topibit itabẽg̃ o'e. O'je'ag̃obucẽg̃. O'jekawẽn. G̃ebuje Jesus o'jekawẽn ce'ũ topibit xi eju. — E'it waram g̃uto o'jetait — Jesus o'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Imẽnpit soat imu'adaap cocoayũ yag̃uybabi'ũm cĩcã ip o'e. — Ka'ũmg̃u ejo'iat xipacat — io'e ip Deus pe. — Deus ekawẽn muwẽnuwẽn'ukat wuykay osodot―ya'õbuyxiat — io'e ip jewewebe. — Deus osodot jebekitkit com — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ibocewi Judéia eipi watwat Jesus ce'ũat o'g̃u'ada iap awẽg̃ o'yawẽg̃tobuxik―soat ka watwat. ");
INSERT INTO myu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ceweju etaybitbinayũ be Jesus ce'ũat o'g̃u'ada iam João mukũyjo buje, João xepxepayũ o'tomuwã jewekay―jeweju etaybitbinayũ. ");
INSERT INTO myu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ixeyũ o'g̃uju ja'õmuju am wuykukukat Jesus kay. — “Deus emunaẽ ajẽmap wiwim oceju,” i juy epe'e cebe — io'e João. — “Ẽn tu ixe? Wara'at g̃u xe'e ocejowiwi?” i juy epe'e cebe — io'e João. Poxerewun. O'jẽm ip. ");
INSERT INTO myu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jay. Oajẽm ip Jesus kay. — João Batista ocemudot ekay — io'e xepxepayũ Jesus pe. — “Ẽn tu omuykuiat? Wara'at g̃u xe'e ocejowiwi?” i juk o'e João ocewebe — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","G̃asũ Jesus tak adeayũ o'g̃u'ada'ada João emumudotyũ etabutpe. Iwãtaxipipiayũ o'g̃u'ada'ada. Ibiõg̃buk kẽrẽat o'g̃ujẽmujẽm ikug̃ayũ bewi. Ita'ũmayũ o'sutada. Ierepayũ o'g̃u'ada'ada. Jesus tak o'jekawẽn xepxepayũ eju―João emumudotyũ eju. ");
INSERT INTO myu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","— Epeyepit cuy João kay — io'e cebe ip. — Epejojojoiap cuy epeg̃uwẽn João be, epeyekũyjojoiap tak — io'e. — Ita'ũm topibiyũ itate o'e g̃asũ. Taojere topibiyũ dak xipan ip o'e xĩg̃xĩg̃ g̃asũ. Ierep topibiyũ dak xipat o'e g̃asũ. Ya'õpi'ũm topibiyũ dak ya'õpipe o'e ip. Jekũyjojom ip o'e. Ce'ũ topibiyũ dak waram itait o'e g̃asũ. Itadaybotbocayũ dak kawẽn idipat cocom g̃asũ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","— Imẽneju eycokcog̃ epesop okay eyetabut am eybu'u'ũm pima — io'e Jesus. — “Ite g̃u omuykuiat,” i'e'em pima bit, eycokcog̃ g̃u epesop — io'e xepxepayũ be―João emumudotyũ be. ");
INSERT INTO myu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jesus João o'g̃uwẽn adeayũ be, cemumudotyũ jẽm puje. — João jom cuk epeku uk'a'ũmat pe — io'e Jesus. — Ipi'ũn'ũn kay kabido ajẽm puje je'ipe'adededem. Yag̃uykorererenayũ ite'ip puxim, soat em jewag̃uymuwarururun puye. João bit yag̃uykoreren g̃u. Wita'a buxim pit ixe. ");
INSERT INTO myu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","João doti teibog̃ g̃u. Teibog̃at kukayũ adeayũ kukat tuk'a be opop ip―ibubut adeayũ. ");
INSERT INTO myu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","João bit ibubut adeat g̃u―Deus ekawẽn muwẽnuwẽn'ukat acã. Wara'at Deus ekawẽn muwẽnuwẽn'ukayũ bodi ma João ya'õbuyxi. ");
INSERT INTO myu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Imẽn Deus ekawẽntup e'em―João muwẽg̃aptup: Ag̃ cuy epesop, i'e'em Deus, i. Wemumuju og̃uju ewap soat ajẽm puje emuxipan am, i. Imẽn e'em Deus ekawẽntup―João muwẽg̃aptup — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","— Ka'ũma ma omuy João jo'i ya'õbuyxian. Deus xe bit, yopĩcat João bodiat ya'õbuyxiat cebekitkiyũ'in — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iboap ekawẽn co buje, — Cũg̃ cĩcã Deus — io'e soat ma, iecug̃ap peam dinheiro bubu'ukayũ dak. João ixeyũ o'g̃ubatisasan. ");
INSERT INTO myu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseuyũ bit ibu'u jĩjã osodop ip Deus bikuyap tag̃ jeku am, Moisés ekawẽn imutaybitbin'ukayũ dak. Ixeyũ g̃u bit o'ju João kay jemubatisan am―wara'acat acã―iecug̃ap peam dinheiro bubu'ukayũ acã, wara'at ikẽrẽat mujurũg̃rũg̃'ukayũ dak. ");
INSERT INTO myu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","G̃ebuje Jesus waram o'jekawẽn adeayũ eju. — Abu-buxim g̃asũacat? Ajoap og̃uwẽn eywebe abu-buxim ip iap mubapuk am eywebe? ");
INSERT INTO myu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bekitkit puxim ixeyũ―pasiaham ip iap pe pubutbucayũ buxim. Jewãwãwãm ip jebureyũ kay bekitkiyũ. — “Tẽg̃tẽg̃'a oceyamuyde eywebe ya'ĩjo am. Eydaobu'u'u eyju bit da'i'in,” i'e'em ip. “Wa ocesop jewexe i'ũmcocom. Eybu'u eyju bit oceweju tõn,” i'e'em ip. Ijoyũ buxim g̃asũacat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","— João Batista oajẽm eykay. Ixe jekpiwan ma irere oeku Deus eju jekawẽn ãm. Eyju bit napa ma e'em ixe muwẽnuwẽn: “Ibiõg̃buk kẽrẽat kukat teku,” i. ");
INSERT INTO myu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Soat wag̃o õn. Ojot eykay. Soat xat o'om ojeku, soat tikõnkõn tak. Eyju bit napa ma e'em omuwẽnuwẽn: “Ka'o'on'ukat teku,” i. “Teku iecug̃ap peam dinheiro bubu'ukat pure,” i dak. “Teku ikẽrẽat mujurũg̃rũg̃'ukat pure,” i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","— Wuyju Deus emumutaybitbinap tag̃ jekukum pima bit, warara'acayũ je'e “Deus cũg̃ ma wuymutaybitbin,” i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","G̃ebuje Fariseu Jesus o'tomuwã jeweju jekõn ãm. Simão ibutet osunuy. Jesus o'ju Fariseu duk'a be. Oajẽm. Oabik jekõn ãm ceweju. ");
INSERT INTO myu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","G̃ebuje ayacat oajẽm Jesus kay. Ixe ayacat ibo ka wat osunuy. Ikẽrẽat mujurũg̃rũg̃'ukat osunuy. Ixe itaybit o'e Jesus jekõnkõn Fariseu duk'a be iam. Imẽnpuye tide'oati o'tidojot Jesus kay timũn'a be. Timũn'a waenõm mug̃ẽg̃ẽ jo'i osunuy―alabastro mug̃ẽg̃ẽ osunuy. ");
INSERT INTO myu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Oajẽm Jesus kay. Xik'i osunuy Jesus nõg̃pikadi, sui xe. Wa osunuy. Ig̃uycũg̃ osunuy juk adi ikẽrẽat o'g̃ug̃ẽ iap kay. Jesus i o'suimubot jetadim. O'suisup jadam. O'suikõn. O'suimude'o'on tide'oatim. Imẽn o'e Jesus ikukpin cĩcã cexe buye. ");
INSERT INTO myu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iboap o'jojojo Fariseu―Jesus emunomuwã. G̃ebuje Fariseu o'jekawẽn jewebe ma. — Teku Deus ekawẽn muwẽnuwẽn'ukat tu? — io'e jewebe ma. — Deus ekawẽn muwẽnuwẽn'ukat pima, itaybit kuka o'e abu ite ayacat wuimurerem iam — io'e. — “Ejẽm cuy oxewi,” i kuka o'e cebe — io'e te'e ma. — Ite ayacat ikẽrẽat mujurũg̃rũg̃xiat — io'e Fariseu jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","G̃ebuje Jesus o'jekawẽn Fariseu be. — Simão — io'e. — Kawẽn puk õn eweju — io'e. — Ha'a — io'e. — Ecekawẽn puk, kariwa — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","— Xepxep ag̃okatkat cewero ip osodop jekariwa eju. Pũg̃ ixeyũ'in ceweroap bog̃ jĩjã osunuy. 500 dinheiro osunuy cewero. Wara'acat ixeyũ'in ceweroap bog̃bug̃ ã osunuy. 50 dinheiro isurũg̃at osunuy cewero. ");
INSERT INTO myu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Xepxem ma teida ba'ore o'e ip jekariwa be. Ixe kariwa bit o'e cebe ip: “Teidam g̃u eyju owebe,” i. “Ka'ũmg̃u g̃asũ bit je'e oweju eyeweroap,” i. Abu-xe ixe kariwa ikukpin cĩcã je'e ixeyũ'in? — Jesus o'e. — 500 dinheiro isurũg̃at cewero tũibit xe xe'e? 50 dinheiro isurũg̃at tũibit xe g̃u xe'e? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","— 500 dinheiro isurũg̃at cewero tũibit xe aco'i — Simão o'e. — Cekariwa o'e ixe be: “Teidam g̃u eyju owebe,” i. “Ka'ũmg̃u g̃asũ bit je'e oweju eyeweroap,” i. Imẽnpuye ixe xe aco'i cekariwa ikukpin cĩcã je'e — Simão o'e. — Hm hm — Jesus o'e. — Ixe xe ma ikukpin o'e cekariwa — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesus o'jekorepẽn ayacat kay. Waram o'jekawẽn Simão be bit―Fariseu be. — Ak'i juy ece ite ayacat kay — io'e. — Eduk'a be oõm puje, ẽn ma idibi etiũm g̃u wuiwuyaptim wuybabi dag̃ — io'e. — Ite bit wui o'suimubot jetadim. Wui o'suisup jadam — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","— Ẽn ma wag̃obu eyag̃obukõn g̃u wuybabi dag̃. Ite bit oibu'un g̃u wuikõn ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","— Ẽn ma wa'a eyamude'on g̃u axeptim wuybabi dag̃. Ite bit wui o'suimude'on tide'oatim — io'e. ");
INSERT INTO myu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","— Icẽmãn õn e'em ewebe. Ite ayacat ikẽrẽat kug̃―ade jĩjãat kug̃. Imẽnpit Deus soat o'ju'uk. Ikẽrẽat o'ju'uk cebewi, cexe Deus ikukpin cĩcã buye. Wuywebewi Deus yopĩt ma ikẽrẽat uk puje, ikukpin cĩcã g̃u Deus wuyxe―ikukpinpũn ã — Jesus o'e. — Ade ikẽrẽat uk puje bit, ikukpin cĩcã e'em wuyxe — Jesus o'e Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","G̃ebuje Jesus o'jekawẽn ayacat eju. — Ikẽrẽat kuy oju'uk ewebewi — Jesus o'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Imẽneju ceweju jekõnkõnayũ o'jekawẽn jeweweju. — Abu ite ikẽrẽat'uk'uk'ukan! — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","— Deus kuy edaxijo, cekay etabut puye — Jesus o'e ayacat pe. — Kaba'ũm cuy eg̃uy g̃asũ bit — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ibun'ũm pima Jesus kawẽn idipat o'g̃uwẽnuwẽn. Ikabog̃atka dag̃ oeku ika'ĩcatka dag̃ tak. Deus soat kukukan je'e iap muwẽnuwẽn oeku. ");
INSERT INTO myu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","12 beayũ Jesus eju oekuku ip, aoyũ dak. Jesus cuk ixeyũ aoyũ o'g̃u'ada. Ibiõg̃buk kẽrẽat tak cuk o'g̃ujẽm cebewi ip. Maria Jesus eju oeku, Joana dak, Susana dak, ade warara'acayũ dak. Madalena i osunuy wara'at Maria butet. 7 be ibiõg̃buk kẽrẽat cuk o'g̃ujẽm ixe Maria bewi. Joana Cuza tayxi osunuy. Herodes pubut kukukat ixe Cuza osunuy―Galiléia eipi kukat pubut kukukat. Ixeyũ aoyũ jebubut'in iũmũm'uk osodop ip Jesus pe, 12 beayũ be dak. Jesus eju oekukuku ip Jesus xat mug̃ẽg̃ẽm. ");
INSERT INTO myu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ade ka bewi o'je'awero ip Jesus kay cekawẽn com. Adeayũ e'awero buje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Ag̃okatkat kadaida o'tamudu jekat pe — io'e Jesus. — Tamududum pima, ta'ade g̃u o'ta'at e bitako dag̃. Cũg̃cũg̃ayũ o'tamucakucak e bitako dag̃ puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","— Ibocewi wasũyũ ixeda o'ta'o'o. Tamududum pima wara'ata o'ta'at karatũg̃'a jeje. O'jedae'ũ idibi'ũm puye. O'tanokap g̃u. ");
INSERT INTO myu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tamududum pima wara'ata o'ta'at widaoho nuybi be. Da aypapan o'e widaoho nuybi be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","— Ibocewi widaoho kadai o'g̃u'ũm. Wara'ata bit o'ta'at katõ be. Imẽnpuye xipan o'yaypan. Kadaim o'e. Pũg̃ pe kadai be ta'ada jĩjã o'tadop―100 be o'tadop — io'e Jesus. — Wa'ĩjo pin pima, eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — Jesus o'e adeayũ be. ");
INSERT INTO myu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","G̃ebuje ceweju etaybitbinayũ o'jekawẽn Jesus eju. — Apẽnape ibo kawẽn? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","— Deus soat kukukan je'e — Jesus o'e. — Deus ibikuy eywebe eyetaybit am iboam. Imẽnpuye ibapug̃ ma õn eymutaybitbin. Warara'acayũ be bit imutaybitbinap ekawẽn muwẽnuwẽn õn. Jeakag̃ ip. Inaka ijojom g̃u ip. Wekawẽn pa'arẽm cexe ip wekawẽn cocom ma'g̃u ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Apẽnape ibo kawẽn jeymukũyjo õn. Deus ekawẽn kadaida buxim―tamudu'ibita buxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","— Deus ekawẽn cocomayũ'in e bitako dag̃ata buxim. Deus ekawẽn cocom ip. Cekawẽn co'isum pit Satanás ajẽmjẽm cekay ip ibiõg̃buk kẽrẽayũ kukukat. “Te'e ma eyju iboap cocom,” i napa ma e'em Satanás cebe ip. “Iboap ekawẽn kay eyetabun g̃u juy epesop,” i napa ma e'em. Imẽn Satanás imubu'u'un ip itabucap puxim Deus kay. Ixeyũ mubu'u'un Deus pe ixeyũ daxijoap puxim — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","— Warara'acat karatũg̃'a jejeata buxim Deus ekawẽn cocomayũ — io'e Jesus. — Cekawẽn co buje, icokcok e'em ip. Wekawẽn kay jĩjã ip. Imẽnpit darem ma itabut ip tãbube'ũmat puxim. Deus kay jetabucap epereperem ip. Warara'acat ixeyũ be ikẽrẽat mujurũg̃at puje, ibu'un ip Deus kay jetabut am — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","— Warara'acat widaoho dag̃ata buxim Deus ekawẽn cocomayũ. Wekawẽn cocom ip. G̃uyjom pit soat em g̃ebum ip jemukaypin kay. Adem ibu pin ip jebubun. Jebikuyap tag̃ ip jeku ojuy, jemucokcokcog̃. Warẽmtag̃ ip jeku ojuy. Imẽnpuye ibu'u ip jetabut am Deus kay — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","— Warara'acat katõ beata buxim Deus ekawẽn cocomayũ. Deus ekawẽn cocom ip. Cekawẽn kay jĩjã ip. Oibu'un g̃u ip jetabut am Deus kay. Ixeyũ xipat Deus xe. Cũg̃ ma ip cexe ixeyũ. Cekawẽn muwẽnuwẽn ip warara'acayũ be imutabut am ip Deus kay. Warara'acat mutabunat kadai buxim―ya'a'eat puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","G̃ebuje Jesus wara'at kawẽn o'g̃uwẽn. — Imusop puje lamparina kuka ajomuy g̃u ico'a'a diotpe — io'e. — Ajomuy g̃u dak kuka wuyxexecap tiotpe. Um kuka ajomuy uk'a be õmõm'ukayũ be kabiok tag̃ iõmap puxixim. ");
INSERT INTO myu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Imẽnpuxim soat imunẽm'ibit kuka o'tobuxik ip. Wara'acat pe ya'ĩjoap puxim kawẽnwẽn ãm tak itaybit je'e soat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","— Imẽneju juy eya'õpicũg̃cũg̃ epesop wa'õ kay — io'e. — Eyag̃uyba'ũm g̃u juy epesop wekawẽn kay. Xipan eya'õpicũg̃ pima, waram jeyetaybin wekawẽn. Xipan'ũm pima bit, jeyag̃uyba'ũm wekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ixi ajẽm ojuy oeku Jesus kay jekawẽn ãm, ikitpitpiyũ dak. Cekay yajẽm pa'ore o'e ip adeayũ buye. ");
INSERT INTO myu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","— Exi omuy akiju, ekitpitpiyũ dak — io'e ip. — Ejo pin ip — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","G̃ebuje Jesus o'jekawẽn adeayũ be. — Deus ekawẽn coco'ukayũ oxi jo'i oxe, okitpitpiyũ jo'i dak — io'e. — Kũyjobicayũ oxi jo'i oxe, okitpitpiyũ jo'i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","G̃uyjom Jesus oõm kobe be jeweju etaybitbinayũ eju. Xik. Oabik. — G̃a'a wĩnãbu aju — io'e cebe ip. Timudek ojuy o'ju ip. ");
INSERT INTO myu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Timudekdeg̃ pima, Jesus o'xet. Tibicũg̃ pe bima kabidoxixi oajẽm iodi kay. Idibi o'tiõm kobe be tipodoy buye. Kobe ipoxi o'e idibim. Jepirig̃ ojuy o'e ip. Jakõmap puxixim iparara ip o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Imẽnpuye ceweju etaybitbinayũ Jesus o'g̃uwurũg̃. — Kariwa! — io'e ip. — Akõm wuyju! Wũrũh. O'jewurũg̃. Jewurũg̃ puje, Jesus kabido o'subidomukorẽm. Tipodoyat o'tipon. Iodi tipo o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Imẽnpuye itabẽg̃bẽg̃ ip o'e ijojom dao ma o'tipon iap cocom. — Apẽnpuye eyetabut g̃u Deus kay? — io'e Jesus cebe ip. — Abu dak sute? Kabido kũyjobit ya'õ kay. Tipodoyat tak kũyjobit ya'õ kay — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Oajẽm ip wĩnãbu―Gerasa eipi watwat kay, o'timudek puye. Gerasa eipi Galiléia eipi weg̃ũn opop. Jesusyũ oajẽm. ");
INSERT INTO myu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","G̃ebuje Jesus o'jẽm kobe bewi. Oajẽm ag̃okatkat kay. Ikabog̃atka wat osunuy ixe. Ibiõg̃buk kẽrẽat kukat osunuy ixe. Ika'uat puxim osunuy. Toti'ũm jekuku'uk osunuy kuy bin ma. Uk'a be g̃u osunuy. Ce'ũ'ũayũ mõg̃mõg̃ap tag̃ ma oeku. — Ejẽm cuy ag̃okatkat pewi — io'e Jesus ibiõg̃buk kẽrẽat pe. Imẽn Jesus o'e ibiõg̃buk kẽrẽat pe ag̃okatkat kuku'uk puye. Ixe ag̃okatkat daomunmun'uk osodop ip ibo ka watwat cabobum, correntebum tak kuy bin ma. Imẽnpit cabobu, correntebu dak o'subudakatkat ixe. Ibiõg̃buk kẽrẽat ixe mujuju'uk osodop uk'a'ũmat pe. Jag̃epũg̃ ma oeku uk'a'ũmat tag̃. Jesus cocom pima, o'jewãwã ixe ag̃okatkat. O'jẽg̃'aecõg̃cõg̃ Jesus wap, jexe ya'õbuyxi buye. — Apẽn ẽn em owebe, Jesus? — io'e. — Ẽn Deus ipot―soat podi ma ya'õbacaat ipot — io'e ya'õberen. — Ipiat esupi'ajoat g̃u juy owebe — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ibocewi Jesus o'jekawẽn ag̃okatkat pe. — Apẽn ebutet? — io'e Jesus. — Ade i — io'e. Ade i ibutet osunuy ade ibiõg̃buk kẽrẽat cebe buye. ");
INSERT INTO myu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","G̃ebuje ixeyũ ibiõg̃buk kẽrẽayũ o'jekawẽn Jesus pe. — Ocemujum g̃u juy ipiat'ajojoap kay — io'e. — Dajebaroyũ be acã juy ocemujum ece — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Imẽn o'e ip ade dajebaroyũ co'a pẽnpẽn tag̃ wũrũrũrũg̃ puye. — Ha'a — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","O'jẽm ip ag̃okatkat pewi Jesus a'õbi. Oõm ip dajebaroyũ be. Imẽnpuye dajebaroyũ daudau ip owat co'a pẽnpẽn tag̃. O'kop ip iodi be. Oakõmkõm ip. O'sũm ip. Pog̃. Oap ip. ");
INSERT INTO myu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dajebaroyũ kukukayũ iboap o'tobuxik tak. O'jenapõn ip. Jesus ibiõg̃buk kẽrẽat o'g̃uõm dajebaroyũ be iap muwẽnuwẽn cekuku ip ikabog̃atka watwat pe, kog̃ũnpi watwat pe dak. ");
INSERT INTO myu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","G̃ebuje o'jekũyjo'iayũ o'ju dajebaroyũ'ũm'ũm com. Oajẽm ip Jesus kay. Jay. Ibiõg̃buk kẽrẽat kug̃ tũibit o'tobuxik ip Jesus xe. Xik'i osunuy Jesus xe. Totite o'e. Yag̃uysat o'e. Yag̃uyba'ũm o'e ip oajẽm'iayũ. ");
INSERT INTO myu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Imẽnpuye o'jojojo'iayũ ma Jesus ibiõg̃buk kẽrẽat o'g̃ujẽm iap o'g̃uwẽn soat pe. ");
INSERT INTO myu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ibo eipi watwat pit Jesus o'g̃ujẽm jeka bewi―Geresa eipi watwat. Jesus o'g̃ujẽm ip jeparara pibun. O'jẽm Jesus ixeyũ xewi. Porewuh. Oõm kobe be waram timudek am. Xik. Oabik. ");
INSERT INTO myu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ibiõg̃buk kẽrẽat kug̃ tũibit oajẽm tak Jesus kay. — Ãg̃ eweju oju — io'e Jesus pe. — Eweju ma ojeku — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Ap! Obu'u. Oweju g̃u juy. Ecepit cuy eduk'a be — io'e ibiõg̃buk kẽrẽat kug̃ tũibit pe. — “Deus xipan cuk okuk,” i juy ece cebe ip eduk'a beayũ be — io'e cebe. G̃ebuje ibiõg̃buk kẽrẽat kug̃ tũibit o'jepit jeduk'a kay. Soat kaka dag̃ oeku. — Jesus ibiõg̃buk kẽrẽat o'g̃ujẽm owebewi — i'e'em oeku. Jesusyũ dak waram o'timudek. ");
INSERT INTO myu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Waram Jesus epit puje, Galiléia eipi watwat icokcok o'e iwiwim ip puye. Ag̃okatkat oajẽm Jesus kay. ");
INSERT INTO myu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jairo i ixe ag̃okatkat putet osunuy. Deus eju kawẽnwẽnap'a kukuk'ukat osunuy ixe. O'jẽg̃'aecõg̃cog̃ Jesus topabe Jesus ya'õbuyxi cexe buye. ");
INSERT INTO myu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","— Ejot cuy oduk'a kay — io'e Jesus pe. — Odaxit ce'ũ pin — io'e. Doze koato Jairo daxit osunuy. Wara'at taxit ka'ũmg̃u. Pũg̃ ma osunuy. — G̃a'a — Jesus o'e. E dag̃ cucum pima, adeayũ o'ju ip Jesus nomuju. Jesus o'g̃ukug̃ukug̃ ip, ade buye. ");
INSERT INTO myu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","E dag̃ cucum pima ayacat oajẽm Jesus kay. Jesus tõg̃pikadiwi oajẽm. Ixe ayacat iwãtaxipi o'e. Doybucukcug̃ g̃u osunuy 12 koato bun. Imẽnpuye jedinheiro o'g̃u'ũm janug̃tataapteim. Dinheiro kug̃ g̃u o'e. Ka'ũma ma kuka o'g̃u'ada ayacat. ");
INSERT INTO myu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesus esay ukpu o'g̃ucay ixe. O'toybucuk g̃ebuje bit. O'je'ada. ");
INSERT INTO myu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","G̃ebuje Jesus o'e: — Abu omucay? — i. — Õn g̃u — io'e soat. — Kariwa — Pedro o'e. — Adeayũ ekug̃ukug̃ — io'e. — Akokoreren ip ade — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","— Pũg̃'in ixeyũ'in omucay — io'e. — Wetaybit iboam. Deus a'õbacaap o'jẽm owebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Imẽneju ayacat o'e jewebe ma: — Wemunẽm pa'ore oce — i. Ixe dak oajẽm Jesus dopabe. Ikarabakbak o'e jeparara pibun. Tũybe Jesus omukorẽm iãn o'e. O'jẽg̃'aecõg̃cõg̃ Jesus topabe. G̃ebuje ixe ayacat je'adaap o'g̃uwẽn soat etabun. — Esay og̃ucay omu'ada am — io'e Jesus pe. — Eekabek ukpu mucay buje, oce'ada — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","— Tũ'ũ — Jesus o'e. — Ece'ada, okay etabut puye. Kaba'ũm cuy eg̃uy g̃asũ bit — io'e ayacat pe. ");
INSERT INTO myu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ag̃okatkat oajẽm tak Jairo kay―Jesus xeat kay. Jairo duk'a bewiat oajẽm. Oajẽm ayacat pe Jesus kawẽnwẽn pima. — Edaxit'ũm kuy oe'ũ — io'e. — Kariwa Jesus eg̃uwa'ũm g̃u juy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus pit iboap co buje, o'jekawẽn Jairo eju. — Eg̃uycũg̃ g̃u juy eg̃uy — io'e Jesus cebe. — Etabun cuy eg̃uy okay — io'e. — Etabut pima, je'ada, oe'ũ ma'g̃u edaxit — io'e. ");
INSERT INTO myu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","G̃ebuje Jesus oajẽm Jairo duk'a kay. Pũg̃pũg̃ ã o'g̃uõmat jeweju. Pedro oõm ceweju, João dak, Tiago dak, yaypan'isuat'ũm ebay dak, ixi dak. ");
INSERT INTO myu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Soat ibo'a beayũ dak wawa ip osodop yaypan'isuat'um cocom. Jewãwãwãm ip osodop. Imẽnpuye Jesus o'jekawẽn ceweju ip. — “Wawa g̃u juy epesop,” i õn e'em — io'e cebe ip. — Ixe ce'ũ g̃u―ixet acã — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Waram g̃uto og̃u'ada iam itaybit puye, “Ixet acã” io'e. Imẽnpit Jesus o'jowayway ip, ixe'ũm oe'ũ iam itaybit ip puye uk'a beayũ. ");
INSERT INTO myu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","G̃ebuje Jesus Jairo daxit'ũm pa o'subaixik. — Tũ'ũ, ag̃obucẽg̃ ece — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","O'g̃u'ag̃obucẽg̃ g̃ebuje bit waram g̃uto o'jetait puye. Itabẽg̃ ma o'e g̃asũ bit. — Ixat epeg̃ũm cebe i'o am — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","— Ak'i — io'e ip cebay. — Waram g̃uto o'jetait — io'e ip. — Waram g̃uto imutaicap cuy epeg̃uwẽn g̃u warara'acayũ be — Jesus tak o'e cebay be. Icokcok cĩcã o'e waram o'jetait puye. ");
INSERT INTO myu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Waram pima Jesus 12 beayũ o'tomuwã jeweju etaybitbinayũ. Ja'õbacaap o'g̃ũm cebe ip. — Ibiõg̃buk kẽrẽat cuy epeg̃ujẽm wa'õbi — io'e cebe ip. — Iwãtaxipipiayũ juy epeg̃u'ada wa'õbi — io'e cebe ip. — “Deus soat kukukan je'e,” i juy epe'e soat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ixeyũ mujum pima o'jekawẽn ceweju ip. — Ade g̃u juy epetujowat eyjuap tag̃ — io'e cebe ip. — Eyba'ip g̃u epeyoptujowat, dinheiro mũn tak ka'ũma, eyxat tak ka'ũma, dinheiro dak ka'ũma. Eyekamixa dak pũg̃ ma epetujowat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","— Ag̃oka be eyajẽm puje, wara'at'a bebebe g̃u juy epesop―pũg̃'a be ma — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","— Ibo ka watwat ibu'u eykug̃ pima, juy epejẽm ibo ka bewi. Wara'at ka kay juy epeju. Eyjẽm puje ka'wi epeg̃udu eyei bewi “Deus ipiat supi'ajoat eywebe ya'õ kay'ũm puye” iap mubapuk am ibo ka watwat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Imẽneju 12 beayu o'jẽm. Soat kaka dag̃ oekuku ip. Kawẽn idipat muwẽnuwẽn oekuku ip. Iwãtaxipipiayũ mu'ada'adam oekuku ip. ");
INSERT INTO myu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","G̃uyjom Herodes Jesus e'eap o'ya'ĩjojo―Galiléia eipi kukat. Tũybe Jesus waram g̃uto o'jetaitiat iãn o'e ip adeayũ. Tũybe Jesus João Batista iãn o'e ip pũg̃pũg̃ayũ. — João Batista waram g̃uto o'jetait je'ũap tomukadi — i te'e ma o'e ip Jesus muwẽnuwẽn. ");
INSERT INTO myu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tũybe Elias'ũm waram o'jebapuk ijodi je'ũap tomukadi iãn o'e ip warara'acayũ. Tũybe Deus ekawẽn muwẽnuwẽn'ukat'ũm waram g̃uto o'jetait―kuyjeat'ũm iãn o'e ip warara'acayũ. Imẽnpuye Herodes yag̃uy'ũm o'e Jesus e'eap co buje. ");
INSERT INTO myu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","— Abu sute? — io'e Herodes jewebe ma. — Õn ma João oya'ukat — io'e. — Soat ip ite e'eap muwẽnuwẽn — io'e jewebe ma. Imẽneju Herodes Jesus co pin cĩcã osunuy. ");
INSERT INTO myu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesus emumujuyũ epit puje, soat o'g̃uwẽn ip Jesus pe. Apẽn cuk adi o'e'e ip iap o'g̃uwẽn ip cebe. Ibocewi Jesus ip o'tujowat jeweju. O'jẽm ip adeayũ xewi. O'ju ip Jesus eju Betsaida ka kay. ");
INSERT INTO myu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Adeayũ bit o'ju Jesus nomuju, kuy o'jẽm iam itaybit ip puye. Oajẽm ip adeayũ. G̃ebuje Jesus icokcok o'e jenomuju iju buje ip. G̃axĩn ma Deus soat kukukan je'e iap o'g̃uwẽn cebe ip. Iwãtaxipipiayũ o'g̃u'ada. ");
INSERT INTO myu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Imẽnpit katpuje jĩjã o'e. Imẽnpuye 12 beayũ o'ju kawẽn ãm Jesus eju. — Ajo kuka o'jo'o ip? Ka'ũmg̃u puybit ijoce — io'e ip Jesus pe. — Eg̃uypit cuy ip tomukay ma. Ikatẽg̃atka kay juy ip eg̃uju ixat pu am — io'e ip cebe. — Ixeyũ juy eg̃uju ixet am — io'e ip. — Ijoce bit ya'ũmg̃u uk'a ixet am ip — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","— Eyju ma ixat epeg̃ũm cebe ip — io'e Jesus pit jeweju etaybitbinayũ be. — Apẽntak suteyũ xan acejat? — io'e ip Jesus pe. — Cinco be ma pão'a kug̃ oceju. Axima kug̃ tak xepxep ma oceju — io'e ip. — O'e g̃u kuka cebeam ip. Pomawi dak puybit suteyũ xan acejat? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Imẽn o'e ip ade jĩjã buye. 5000 ag̃okatkayũ osodop ip Jesus ekawẽn cocom. — Adeayũ epeg̃uabik — Jesus o'e cebe ip. — Ha'a — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Soat oabik ip. Kaxikxik'i ip o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","G̃ebuje Jesus ixat o'jat. Akoh. Pão'a o'yabu―cinco beat'a. Axima o'jat xepxepat. Ixe dak o'jeapũn kabi kay. Apũn. — Bay, xipat cĩcã ẽn — Jesus o'e Deus pe. — Ocexan eg̃ubapuk ocewebe i'o am — io'e. Ixat o'takatkat jebum. Pão'a o'yadakatkat. Pan. O'yaũmũm 12 beayũ be yaũm ãm adeayũ be. Iũmũm pima o'g̃u'acog̃ axima. 12 beayũ ixat o'g̃ũmg̃ũm adeayũ be. Soat ip o'jo'o. Ibeg̃beg̃ ip o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","12 beayũ cepoyat o'g̃uxipan. O'jomõg̃ ip ico be. 12 be ico o'g̃unopapũn ip cepoyan. Imẽn Jesus yopĩcat o'g̃u'acog̃ adeayũ xan. G̃ebuje Jesus adeayũ o'g̃uypit tuk'a kay. Irerem g̃u ip o'g̃uypit―ibeg̃beg̃ acã. ");
INSERT INTO myu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Waram pima Jesus o'jekawẽn Deus eju. Jag̃epũg̃ ma kawẽnwẽn o'e ceweju. Ceweju osodop ip 12 beayũ. G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Abu dak õn adeayũ xe? — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","— Ẽn João Batista pũg̃pũg̃ayũ xe — io'e ip. — “Teku João Batista,” i te'e ma e'em ip. “Teku Elias,” i te'e ma e'em warara'acat — io'e ip. — “Teku Deus ekawẽn muwẽnuwẽn'ukat―waram g̃uto o'jetaitiat,” i te'e ma e'em warara'acat — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","— Pãm eyju? Abu dak õn eyxe? — io'e. — Ẽn Cristo ma — io'e Pedro. — Deus pe wuydaxijo am taẽ'ibit ẽn — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","— Iboap pit cuy epeg̃uwẽn g̃u warara'acayũ be — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","— Soat wag̃o õn. Õn pit ipiat osupi'ajo — io'e. — Paĩyũ kukukayũ itakoma jĩjã je'e okay, Moisés ekawẽn imutaybitbin'ukayũ dak, Judeuyũ kukukayũ dak. Waoka ojuy je'e ip. Waoka ip g̃uyjom. Xepxep xet kap puje bit, waram ocetait — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","G̃ebuje Jesus o'jekawẽn soat eju―cekawẽn cocomayũ eju. — Oweju jeku pin pima eybikuyap tag̃ g̃u juy epeku―obikuyap tag̃ acã — io'e. — Wekawẽn tag̃ cuy epeku — io'e. — Eybu'um g̃u juy epesop eye'ũ ãm owebeam — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","— Obikuyap tag̃ eyeku buje, soat em Deus xe eyetait epesop eye'ũ buje — io'e. — Eybikuyap tag̃ eyeku buje bit, wũy ma Deus wi epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","— Eye'ũ buje soat em wũy ma Deus wi epesop pima, te'e ma eyju soat pupum ijodi eybubun. ");
INSERT INTO myu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Soat wag̃o õn. Waram ojot ijodi Deus ekawẽn tojotjot'ukayũ eju―ikẽrẽat kug̃'ũmayũ eju. Waram ojot webay a'õbi. Soat je'e owebe: “Ka'ũmg̃u ejo'iat ya'õbuyxiat,” i. “Ka'ũmg̃u ejo'iat idipat,” i dak. Okay eybu'u bima, õn tak obu'un ma oce eykay wedot puje. Wa'ĩjo am eybu'u bima, õn tak obu'un ma oce eya'ĩjo am — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","— Icẽmãn õn e'em eywebe — io'e. — Deus soat kukukan je'e. Pũg̃pũg̃ puk ijodiacat je'ũ g̃u iboap com'ũm pima — Jesus o'e. Jesus imẽn waram jedocap o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","8 xet kap puje, Jesus o'ju Pedro eju, João eju dak, Tiago eju dak. O'ju ip co'a kay jekawẽn ãm Deus eju. ");
INSERT INTO myu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oajẽm ip. Jay. Jesus o'jekawẽn Deus eju. Kawẽnwẽn pima o'jedopaewarurun. Iekabek irut cĩcã o'e. Isopsep cĩcã o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xepxep ag̃okatkayũ dak o'jekawẽn Jesus eju―kuyayũ, kuy oe'ũ'iayũ. Moisés o'jekawẽn, Elias dak. ");
INSERT INTO myu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Idip cĩcã osunuy cebapukap. O'jekawẽn ip jeweweju. — Jesus je'ũ Jerusalém ka be Deus bikuyap tag̃ — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Imẽnpit Pedro o'xet, Tiago dak, João dak. O'xet ip itaxet pinpin ip puye. Jewurũg̃ puje, Jesus o'jojojo ip. Idip cĩcãat o'jojojo ip. Ixeyũ dak xepxep ag̃okatkayũ o'jojojo―Jesus eju kawẽnwẽnayũ. ");
INSERT INTO myu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","G̃ebuje Pedro o'jekawẽn Jesus eju xepxepayũ cẽm pima. — Kariwa! — io'e Pedro. — Xipat cĩcã wuyju ijoceam. Xijap cuy ocejomõg̃ ebapũg̃ — io'e. — Pũg̃ ewebeam je'e, wara'at Moisés peam je'e. Wara'at Elias peam je'e — io'e. Pedro imẽn o'e itaybit'ũm apẽn oce iam puye. Yag̃uybabi'ũm o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kabikerereat tak Pedro o'g̃uba'arẽm, Tiago dak, João dak. Kabidig̃ pe ip o'e. Iparara ip o'e kabidig̃ pe jeba'arẽm puye. ");
INSERT INTO myu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","G̃ebuje kabikerereat pewi Deus ekawẽn ip o'ya'ĩjojo. — Xeku okpot — io'e Deus. — Wemunaẽ xeku — io'e. — Kũyjobin cuy epesop ya'õ kay — io'e Deus. ");
INSERT INTO myu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ibocewi Jesus acã o'jojojo ip. Kuy o'jẽm xepxepayũ. Warara'acat pe g̃u apẽn cuk o'jojojo ip iap o'g̃uwẽn ip―jewewebe acã. O'jojojo ma'g̃u ip. O'g̃uwẽn g̃u bit ip. ");
INSERT INTO myu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kuyaje Jesus co'a bewi o'kop ebapũg̃ayũ eju. ");
INSERT INTO myu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Adeayũ oajẽm Jesus kay. Ag̃okatkat o'jekawẽn Jesus eju―ceparakpeat ip. — Ocemutaybitbin'ukat — io'e. — Okpot cuy esubuywan! ");
INSERT INTO myu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pũg̃ ma okpot. Axik pe ikukuk puje, pipim imuy'at'an ipi ju, jewãwãwãm ya'õberen, ibidopabokbek e'em, imuwerikwerig̃ — io'e. — Ibu'u o'e cẽm cebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","— “Axik cuy epeg̃ujẽm okpot pewi,” i kuy oce eweju etaybitbinayũ be. Imẽnpit imujẽm pa'ore o'e cebe ip — cebay o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","— Tãh! — io'e. — Eyetabut'ũm cĩcã okay — io'e Jesus iboceayũ be. — Xipat g̃u eyju — io'e. — Pug̃ũn tak og̃uy eyxe? Ibun ma okpiceg̃ẽ eyetabut'ũmap cocom! — Jesus o'e. — Ekpot cuy etojot okay — Jesus o'e cebay be. ");
INSERT INTO myu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","G̃ebuje axik pipim ag̃okatkat'it'it o'g̃uy'at Jesus kay ajẽmjẽm pima. O'g̃uwerik cĩcã. — Ejẽm cuy ag̃okatkat'it'it pewi — io'e axik pe. Ag̃okatkat'it'it pewi o'g̃ujẽm. Waram g̃uto o'g̃ũm cebay be. ");
INSERT INTO myu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","— Soat podi ma Deus ya'õbaca — io'e ip soat o'jojojo'iayũ. G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. Adeayũ itabẽg̃bẽg̃ ip o'e ijojom, axik o'g̃ujẽm puye. G̃ebum osodop ip apẽn Jesus o'g̃ujẽm iap kay. ");
INSERT INTO myu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Eyag̃uyba'ũm g̃u juy wa'õ kay — io'e cebe ip. — Soat wag̃o õn. Warara'acayũ oũm okay itakomaayũ be — io'e. — G̃ebum cuy epesop wa'õ kay — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Imẽnpit cekawẽn pa'arẽm o'e ceweju etaybitbinayũ xe. — Apẽg̃ape dak cekawẽn? — io'e ip jewewebe ma. Imẽnpit isũsũn ip o'e “Apẽg̃ape dak ekawẽn?” i'e am cebe. ");
INSERT INTO myu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ibocewi jewa'õxikxig̃ o'e ip ceweju etaybitbinayũ. — Abu omuy ya'õbuyxiat wuy'in warara'acat podi ma? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus itaybit osunuy yag̃uy ip iam. Imẽnpuye bekicat o'tojot jexe am. ");
INSERT INTO myu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","G̃ebuje o'jekawẽn ceweju ip. — Cexe okukpin puye xipan ite bekicat kug̃ pima, xipan okug̃ tak epe'e — io'e. — Xipan okug̃ pima, omudocat kug̃ tak xipan epe'e — io'e. — “Õn pit wa'õbuyxi” i'e'em'ũmat ya'õbuyxi Deus xe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","G̃ebuje João o'jekawẽn Jesus eju. — Kariwa — io'e. — Ag̃okatkat cuk ocejojojo. A'õbi ma ibiõg̃buk kẽrẽat mujẽmjẽm'Uk osunuy — io'e. — “Imẽn g̃u bit cuy,” i juk oce cebe, wuyweju'ũm puye — io'e João. ");
INSERT INTO myu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","— Imukorẽmrẽm g̃u juy — io'e Jesus pit. — Wuykay itakoma'ũmat wuykadiat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kabi kay waram Jesus euap ekabia ajẽm pin pima: — Jerusalém ka kay juy oju — io'e Jesus jeweju etaybitbinayũ be. Iju pin o'e ibo ka kay. ");
INSERT INTO myu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ja'õdujowacayũ o'g̃uju jewap. O'ju ip. E dag̃ pima ag̃oka be oajẽm ip Jesus nuyap'a muxipan am―Samaria eipi watwat ka be. ");
INSERT INTO myu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ibo ka watwat pit Jesus kay g̃u o'e, Jerusalém ka kay cum puye. Ibu'u o'e ip imu'abig̃ jeka be. ");
INSERT INTO myu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Imẽnpuye Tiago o'jekawẽn Jesus eju, João dak. — Kariwa — io'e ip. — Ebikuy du ocewebe daxa mudot am kabi bewi ijop ka watwat muy'ũ ãm? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","— Ap — io'e Jesus pit cekay ip jekorepẽn puje. — Epeg̃uy'ũ g̃u juy ip — io'e. O'jẽm ip ibo ka bewi. ");
INSERT INTO myu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Soat kaka dag̃ oekuku ip wara'atka dag̃. ");
INSERT INTO myu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E dag̃ cucum pima, ag̃okatkat oajẽm Jesus kay. — Soat ka dag̃ ojekuku eweju ejuap tag̃ — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","— Oweju du eku pin? — io'e Jesus. — Kak ikũykẽy — io'e. — Wasũ topipe. Soat wag̃o õn. Imẽnpit ya'ũmg̃u odopdopap'a. Eku pin tu oweju? — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","G̃ebuje Jesus oajẽm wara'at ag̃okatkat kay. — Oweju juy ejeku — io'e cebe. — G̃asũ g̃u. G̃uyjom acã — io'e. — Ãg̃ webay'ũm ojokot — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","— Ãg̃ Deus ekawẽn kay'ũmat jebadipyũ'ũm'ũm jokot — io'e. — Ẽn pit oweju juy ejeku — io'e. — Deus soat kukukan je'e i'e'e'ukan cuy eg̃uy — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wara'at ag̃okatkat oajẽm Jesus kay. — Kariwa, eweju juy ojeku — io'e. — Oduk'a beat pe buk õn jekawẽn. “Cum puk õn,” i buk oce cebe ip — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","— Biopak kug̃ ipi kotkon pima cekorepẽn puje, ipi kocap wakẽnwakẽn'i kuka o'e — io'e Jesus pit. — Imẽnpuxim etabut am ebu'u bima, te'e ma kuka ece Deus soat kukukan je'e iap ekawẽn muwẽnuwẽn'ukan — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iboap tomukadi wuykukukat Jesus 70 beayũ o'taẽ kawẽn idipat muwẽn ãm adeayũ be. Xepxepxem ma ip o'g̃uju jewap. — Soat kaka dag̃ cuy epeju — io'e cebe ip. — Õn tak oju eynomuju — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","— Jeymuju õn apẽn ag̃okatkat jekat peat'a bum jebuywatwat'ukat mujuap puxim — io'e. — Apẽn ya'ade opop kat pe kadai'a yaopat'a iap puxim ade opop ipi ju Deus ekawẽn itaybit'ũmayũ. Ade g̃u bit Deus ekawẽn muwẽnuwẽn'ukayũ. Imẽnpuye imuwẽnuwẽn'ukayũ kukat eju juy epeyekawẽn―Deus eju. “Adeayũ juy eg̃uju ekawẽn muwẽn ãm,” i juy epe'e cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","— Epeju juy g̃asũ — io'e. — Õn ma dak jeymuju. Deus ekawẽn muwẽnuwẽn pima, ovelha'it'it puxim epesop―widayũ pidaseat puxim, ikẽrẽat kay jĩjãayũ pidase buye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","— Sacola g̃u juy epetujowat eyjuap tag̃, dinheiro mũn tak ka'ũma, eyeiuk tak ka'ũma — io'e. — Ibun g̃u juy epesop kawẽnwẽn warara'acat eju e bidase — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","— Uk'a be eyõm puje, “Deus cuy ija'a watwat jukuk kaba'ũm ip jedop am,” i juy epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","— Xipan jewewekug̃ ip pima, kaba'ũm ip jeedop ig̃o'a watwat. Jewewekay itakoma ip pima bit, te'e ma “Deus cuy ija'a watwat jukuk kaba'ũm ip jedop am,” i epe'e — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","— Ig̃o'a be ma epesop uk'a be — io'e. — Soat cuy epejo'o ajo ip o'g̃ũm eywebe iap. Soati juy epetikõn ajo ip o'tiũm eywebe iapti. Eysũsũn g̃u juy epesop eyxat pu am cexewi ip. Cekapikaptei juy ateida kapikpik'ukat pe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","— Ag̃oka be eyajẽm puje juy ajo ip o'g̃ũm eywebe iap epejo'o xipan ip eykug̃ pima. ");
INSERT INTO myu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Iwãtaxipipiayũ juy epeg̃u'ada―ibo ka watwat. “G̃axĩn ma Deus soat kukukan je'e,” i juy epe'e cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","— Ag̃oka be eyajẽm puje, “Epeõm cuy oduk'a be,” i'e'em'ũm ip pima uk'a ukpibubu dag̃ cuy epeju. ");
INSERT INTO myu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ka'wi opop ocei eju―eyka beat ka'wi,” i juy epe'e cebe ip. “Ka'wi mududum ocei bewi eyukpiwat puye, Deus ekawẽn co pin'ũm puye,” i juy epe'e cebe ip. “Deus soat kukukan je'e,” i juy epe'e. “Eyetaybit g̃u iboam, wekawẽn kay'ũm puye,” i juy epe'e cebe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","— Icẽmãn õn e'em eywebe. Deus kũyjobit'ũmayũ be ipiatpi'ajoap kabia bima, Sodoma ka watwat pe ipiat supi'ajoat. Ixeyũ be iap podi ma bit ibo ka watwat pe ipiat supi'ajoat, eyekawẽn com ip ibu'u buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","G̃ebuje Jesus wara'at kaka watwat o'g̃uwẽn. — Karem ma ipiat epesupi'ajo jĩjã, Corazim ka watwat — Jesus o'e. — Karem ma ipiat epesupi'ajo jĩjã, Betsaida ka watwat — io'e. — Ka'ũma buk epejojojoiap cuk adi og̃ubapukpuk eyetabutpe eyka be bima — io'e. — Tiro ka be iboap mubapuk pima, Sidom ka be dak, kajuk ikẽrẽat mujurũg̃rũg̃ap o'jepere ip ibo ka watwat. Itabut kajuk ip o'e Deus kay — io'e. — Ibo ka be iboap mubapuk pima, kajuk ikurususucat o'g̃uõm ip jedotim. Daxadaypi be dak kajuk o'e ip kaxikxik'i. Imẽn kajuk o'e ip oceg̃uycũg̃ cĩcã ikẽrẽat kug̃ puye iap mubapuk am jebureyũ be, g̃asũ bit ikẽrẽat ag̃ujurũg̃ g̃u iap mubapuk am tak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","— Deus kũyjobit'ũmayũ be ipiatpi'ajoap kabia bima, Tiro ka watwat pe ipiat supi'ajoat, Sidom ka watwat pe dak. Ixeyũ be iat podi ma bit eywebe ipiat supi'ajoat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","— Cafarnaum ka watwat — io'e. — Deus jeymuyu g̃u kabi kay — io'e Jesus. — Jeymukop ipiat'ajojoap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","— Eyekawẽn kayayũ wekawẽn tak ip cekay — io'e jeweju etaybitbinayũ be. — Eykay'ũmayũ õn tak ip okay g̃u. Okay'ũmayũ omudocat tak ip cekay g̃u — Jesus o'e. — Epeju juy g̃asũ — io'e. — Wekawẽn cuy epeg̃uwẽnuwẽn soat ka watwat pe — io'e. — Ha'a — io'e ip. Ibun cĩcã ip oekuku kawẽn idipat muwẽnuwẽn. ");
INSERT INTO myu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","G̃ebuje icokcok cĩcã ip o'jepit Jesus kay — 72 beayũ. O'jekawẽn ip Jesus eju. — Kariwa, ibiõg̃buk kẽrẽayũ kũyjobit oca'õ kay, a'õbi oceju jekukum puye — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","— Hm hm — io'e Jesus. — Kabi bewi Satanás at'anap ojojojo. Dao ma o'at xiriririkiat puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","— Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — Jesus o'e. — Wa'õbacaap cuy og̃ũm eywebe. Wa'õbi juy epeku soat em. Puybu epesubumucak tũypiatpu. Dat tak epeg̃ucak. Ka'ũma bit jeyaoka. Eykay itakomaayũ dak o'e g̃u eywebe, wa'õbi eyju jekukum puye. ");
INSERT INTO myu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Imẽnpit eycokcog̃ cuy epesop ibiõg̃buk kẽrẽat cẽmcẽm eya'õbi iap kay g̃u―kabi beatup pe eybutet ibararak opop iap kay acã — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesus Ibiõg̃buk xipacat a'õbi icokcok cĩcã o'e g̃ebuje bit. G̃ebuje Jesus o'jekawẽn Deus eju. — Bay — io'e. — Ẽn acã soat kukukat―kabi beacat kukukat, ipi juacat kukukat tak — io'e. — Jewexe itaybit cĩcãayũ xewi eg̃unẽmiap eg̃ubapuk itaybit'ũmayũ be — io'e. — Ixeyũ be acã iboap eg̃ubapuk, imẽn ebikuy buye, xipat exe buye dak — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","— Soat ma juk webay o'g̃ũm owebe — io'e. — Warara'acat g̃u itaybit cĩcã abu Deus ipot iam―cebay acã. Imẽnpuxim warara'acat g̃u itaybit cĩcã abu ipot ebay iam―ipot acã. Iboap mubapuk am ipot ibikuy bima acã, warara'acat itaybit je'e abu Deus ipot iam — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","G̃ebuje Jesus jebidadam o'jekawẽn jeweju etaybitbinayũ eju warara'acat pe ya'ĩjoap puxim. — Eycokcok wekawẽn cocom puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","— Kuyje ajo eyju ijojomap co pin cĩcã osodop ip ade Deus ekawẽn muwẽnuwẽn'ukayũ, ika kukukayũ dak. Imẽnpit o'jojojo g̃u ip. Eymukũyjojomap co pin cĩcã ip osodop. Imẽnpit o'jekũyjo g̃u ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","G̃ebuje Moisés ekawẽn imutaybitbin'ukat oajẽm Jesus kay. O'jekawẽn Jesus eju cekawẽn puyxijo ojuy. — Kariwa — io'e. — Apẽntak oce soat em Deus xe onuy ãm? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","— Apẽn e'em wuyawẽwẽap ekawẽntup? Apẽn iboaptup wuymutaybitbin exe? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","— Imẽn e'em wuyawẽwẽaptup — io'e ag̃okatkat. — Deus kay jĩjã juy epesop, i. Ixe Deus eykukukat, i. Ixe bikuyap tag̃ jekukum pima, ixe kay jĩjã epesop; soat em xipacat kay g̃ebum pima dak; ya'õ kay kũyjobit pima dak; ixe ag̃uy dag̃ jewag̃uyg̃uy bima dak, i. Imẽn cuy epeku, i. Xipan cuy eyxeat epejukuk eyewekukap puxim, i. Imẽn e'em wuyawẽwẽap ekawẽntup — io'e Moisés ekawẽn imutaybitbin'ukat. ");
INSERT INTO myu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Icẽmãn ẽn e'em — Jesus ma o'e. — Imẽn eku buje, soat em Deus xe ecesũy etait — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","— Abu oxeat pit? — io'e ixe bit jewedayo ojuy. ");
INSERT INTO myu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Imẽnpuye Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn abu wuyxeat iam imutaybit am. — Ag̃okatkat kopkom o'e Jerusalém ka bewi — Jesus o'e cebe. — Ixe ag̃okatkat cu ojuy Jericó ka kay. Judeu osunuy. Cucum pima ibukurukayũ ixe o'topabijuk e dag̃. — Oajẽm ip cekay. Toti o'ju'uk ip. Soat o'jat ip cexewi ibubut. O'yaokaka jĩjã ip. Je'ũje'ũm ip o'suiwat ebidakpe. ");
INSERT INTO myu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","— Paĩ cucum o'e ixe e dag̃. Je'ũje'ũmat co buje, o'kap wara'at e bitako dag̃. O'subuywan g̃u — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","— Imẽntak paĩ buywatwat'ukat oajẽm ixe e dag̃ cucum pima. Je'ũje'ũmat co buje, o'kap wara'at e bitako dag̃―paĩ buywatwat'ukat. O'subuywan g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","— G̃ebuje bit Samaria eipi bewiat oajẽm cucum pima ixe e dag̃. Samaria eipi watwat Judeuyũ kay'ũm cĩcã ip. Ixe jo buje, itabotaidabotbot o'e je'ũje'ũmat kay. O'ju cekay taxijo ojuy. ");
INSERT INTO myu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Posũg̃ti o'timõg̃ werowero be―uva'abidi, ixepti dak. Werowero o'jomũnmũn pag̃õm. — Je'ũje'ũmat o'tujowat powatwat ajẽmjẽmap'a kay. Jejumento akpi jeje o'tujowat. Xipan ixe o'jukuk ig̃o'a be. ");
INSERT INTO myu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","— Kuyaje xepxep jedinheiro o'jat isurũg̃at, teibog̃at, prata mug̃ẽg̃ẽ. O'g̃ũm uk'a iwat pe je'ũje'ũmat kukapteim. — “Xipan cuy ite ejukuk,” io'e uk'a iwat pe — io'e Jesus. — “Ijop edinheiro'ũm pima, wara'at og̃ũm ewebe wedinheiro wepit puje,” Samaria eipi bewiat o'e — io'e Jesus. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn. ");
INSERT INTO myu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","— Ebapũg̃ayũ je'ũje'ũmat o'jojojo―ibukurukayũ emuaokaka — io'e. — Abu xipan o'jukuk jexeat kukap puxim? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","— O'subuywan'iat — io'e Jesus pe. — Ixe ekukuap co'i juy ejeku — Jesus o'e. — Warara'acat puywatwat'ukan cuy eg̃uy — io'e Moisés ekawẽn imutaybitbin'ukat pe. O'jẽm Jesus xewi. ");
INSERT INTO myu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Waram pima Jesus oõm ag̃oka be jeweju etaybitbinayũ eju. O'ju ip ayacat kay―Marta kay. — Oduk'a be juy epesop — Marta o'e Jesusyũ be. — Ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta duk'a be ip osodop. Marta kibit tak uk'a be osunuy. Ikibit putet Maria i osunuy. G̃ebuje Maria Jesus ekawẽn o'ya'ĩjojo jĩjã jewemutaybin ojuy. Maria ma xik'i osunuy Jesus xe cekawẽn cocom. ");
INSERT INTO myu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta bit kapikpig̃ osunuy ixat tatam, ixat tojotjon tak. Yag̃uybabi'ũm o'e jekapikap kay cekapikap ade buye. G̃ebuje Marta o'jekawẽn Jesus eju. — Kariwa — io'e. — Ak'g̃u du ẽn okay? Okibit oibu'un obuywat am. Wag̃epũg̃ ma õn wuyxat tatam, wuyxat tojotjon — io'e. — “Ewag̃o juy esubuywan,” i juy ece cebe — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","— Ap — io'e Jesus Marta be. — G̃ebum cĩcã ẽn wuyxataap kay―ekapikap kay. Ag̃uykoreren soat kay ekapikap kay. ");
INSERT INTO myu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria bit wekawẽn co pin cĩcã. Soat em g̃u wuyxat dopdom. Soat em pit Maria g̃ebum wekawẽn kay jeenuy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Waram pima Jesus o'jekawẽn Deus eju. Pereh. O'jepere. G̃ebuje ceweju etaybitbinat o'jekawẽn ceweju―12 beayũ'in. — Kariwa — io'e. — João kuy jeweju etaybitbinayũ o'g̃utaybin kawẽn ãm Deus eju. Imẽnpuxim oceju dak cuy ocemutaybin ece — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","— Imẽn cuy epe'e, Deus eju kawẽnwẽn pima — Jesus o'e. — “Bay, soat cuy ip jeedop ibuyxim ebutet kug̃,” i juy epe'e Deus pe―kabi beat pe — io'e. — “G̃axĩn ma juy soat kukukan eg̃uy,” i dak cuy epe'e cebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","— “Soat kabia ocexan cuy eg̃ũmg̃ũm ocewebe,” i dak. ");
INSERT INTO myu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","— “Oceju g̃ebum g̃u apẽn wara'acat cuk adi warẽmtag̃ ocekukiap kay,” i dak. “Imẽnpuye g̃ebum g̃u juy eg̃uy apẽn cuk adi ikẽrẽat oceg̃ujurũg̃rũg̃ iap kay,” i dak cuy epe'e cebe. — “Oca'õmubacacan cuy eg̃uy ocewebe ikẽrẽat kukap puxim,” i dak cuy epe'e — io'e. — Imẽn ma juy epe'e Deus eju kawẽnwen pima — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","G̃ebuje Jesus waram adeayũ o'g̃utaybin. — Apẽn kuka epe'e powatwat ajẽm puje pão'a kug̃'ũm pima? — io'e. — Cum aco'i eyju eybure kay iximadakpe. “Obure, pão'a kay õn pũg̃'a ma,” i aco'i epe'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Wara'at obure oajẽm oduk'a be jekuap tag̃wi,” i aco'i epe'e cebe. ");
INSERT INTO myu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ya'ũmg̃u pão'a. Ya'a'e bima oyaũm kajuk,” i aco'i epe'e cebe. Ixe eybure je'e eywebe badiwi: “Okaykay g̃u juy,” i. “Kuy oduk'a exĩntabi otomudip,” i du je'e? “Webekitkit kuy ixexet,” i du je'e eywebe? “Kuy õn po'i” i du je'e? “Okop pa'ore yaũm ãm ewebe,” i du je'e? Imẽn tu je'e eywebe? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","— Ka'ũma! Imẽn g̃u je'e — io'e. — Eybure je'kop yaũm ãm eywebe. Eybure buye g̃u yaũm eywebe. Ibun eyju yaojuyjuy buye bit kuka o'yaũm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","— Icẽmãn õn e'em eywebe — io'e. — Deus xewi juy epejoojuy. Iojuyjuy bima, epejat. Ixe xewi juy epejokudada. Ikudadam pima epetobuxik. Ixe xewi iojuyjuyap xĩntabi be tag̃tag̃tag̃'iap puxim. Xĩntabi be tag̃tag̃tag̃'i bima, tomudip'uk ip eymuõm ãm. ");
INSERT INTO myu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Soat ojuyjuy'ukat je'jat; soat kudada'ukat tobuxik; xĩntabi be tag̃tag̃tag̃'iat pe xĩntabi tomudip'uk ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","— Puybu g̃u juy epesubuũm eyipotpot pe “Axima kay õn” i'e buje. ");
INSERT INTO myu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Sapokay dopsa kay õn” i'e buje, dat epeg̃ũm g̃u cebe. ");
INSERT INTO myu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eyju ma xipacat ũmũm eyipotpoyũ be ikẽrẽat kug̃ ma'g̃u eyju. Eyju xipacat ũmũmap podi ma eyebayat pit xipacat ũmũm eywebe―kabi beat. Ibiõg̃buk xipacat je'g̃ũm soat pe jexewi iojuyjuy'ukat pe — io'e Jesus. Imẽn Jesus ijodiacat o'g̃utaybin. ");
INSERT INTO myu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","G̃ebuje Jesus ibiõg̃buk kẽrẽat o'g̃ujẽm ag̃okatkat pewi. Ixe ibiõg̃buk kẽrẽat ag̃okatkat muyde'ũm'ũm'uk osunuy. Cekawẽn pa'ore osunuy ag̃okatkat. Ag̃okatkat pewi ibiõg̃buk kẽrẽat cẽm puje bit, xipan o'jekawẽn. Imẽnpuye adeayũ icokcok cĩcã ip o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Warara'acayũ bit o'jekawẽn ip jewewebe. — Belzebu a'õbi Jesus ibiõg̃buk kẽrẽat mujẽmjẽm cebewi―ibiõg̃buk kẽrẽayũ kukat a'õbi―Satanás a'õbi — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","— Ka'ũma buk ocejojojoiap cuy eg̃ubapuk ẽn Deus a'õbi ibiõg̃buk kẽrẽat mujẽmjẽm iap mubapuk am ocewebe — io'e ip warara'acat warẽmtag̃ cekuap ojuy. ");
INSERT INTO myu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Imẽnpit Jesus itaybit osunuy apẽn ixeyũ jewag̃uyg̃uy iam. G̃ebuje Jesus o'jekawẽn ceweju ip. — Pũg̃ eipi watwat jeweweju ma jewaoka buje, jewemu'ũm ip. Imẽnpuxim pũg̃'a watwat uk'a watwat jeweweju ma jewaoka buje, jewemu'ũm ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","— Imẽnpuxim Satanás ebekitkit jeweweju ma jewaoka buje, jewemu'ũm ip. Jewaoka buje, ikoro g̃u ip je'e. Imẽnpuye “Belzebu a'õbi ẽn ibiõg̃buk kẽrẽat mujẽmjẽm ijodiat pewi,” i eyju e'em napa ma owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","— Belzebu a'õbi õn ibiõg̃buk kẽrẽat mujẽmjẽm pima, abu a'õbi dak eyebekitkiyũ imujẽmjẽm ip? Jewemug̃uykukukum eyju iap mubapukpug̃ cĩcã eyebekitkiyũ. ");
INSERT INTO myu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Belzebu a'õbi g̃u õn ibiõg̃buk kẽrẽat mujẽmjẽm―Deus a'õbi acã. Deus soat kukukan je'e iap mubapukpug̃ õn eywebe imujẽmjẽm pima — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","G̃ebuje Jesus meg̃apekawẽnku boku iap o'g̃ubapuk cebe ip. — Ibacaat nobano kug̃ jeduk'a wiwim pima, ibukurukat pe iõm pa'ore tuk'a be ibubut pu am. ");
INSERT INTO myu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ibacaat podiat ajẽm puje bit ixe kuka ibacaat o'g̃uwun pipim jeõm ãm. Ibaca jĩjãat o'e kuka cebe. Cenobano kuka o'jat. Soat ibubut kuka o'jat. Ibubut kuka o'g̃u'ẽ'ẽ jebureyũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","— Okay'ũmat itakoma okay. Imu'awerom obuywatwat'uk'ũmat imuypõg̃põg̃põg̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","— Ag̃okatkat pewi ibiõg̃buk kẽrẽat cẽm puje, idibi'ũmat tag̃ jekukum jebodoyap kudadam. Jebodoyap tobuxik'ũm pima kuka o'e jewebe ma “Jepin ma õn kuy bima onuyap kay,” i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","— Jepitpin. Yajẽm puje, ixe ag̃okatkat tobuxikxig̃. Ka'ũmg̃u ibiõg̃buk kẽrẽat opop ixe ag̃okatkat pe g̃asũ. Ixe ag̃okatkat uk'a buxim―yabi'õg̃'õg̃at'a buxim―yaxipanat'a buxim — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","— Ibocewi ixe ibiõg̃buk kẽrẽat cẽmcẽm ma'g̃uto. 7 beayũ dobuxikxig̃―ibiõg̃buk kẽrẽayũ dobuxikxig̃―cebodi ma xipat'ũmayũ dobuxikxig̃. Ixeyũ dak õmõm ixe ag̃okatkat pe 7 beayũ. Kuy bima ixe ag̃okatkat tadaybot osunuy. G̃asũ bit ibodi ma tadaybot o'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iboam i'e buje ayacat o'jewãwã Jesus kay―adeayũ parakpe at. — Icokcok cĩcã juy exi―emukapat―emuytitit'ukat! — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","— Hm hm — Jesus o'e. — Deus ekawẽn coco'ukat pit oxi cokcokap podi ma icokcok―cekawẽn tag̃ jekuku'ukat tak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","G̃ebuje Jesus o'jekawẽn adeayũ be―jakokoreren je'aweroromayũ be. — Xipat'ũm cĩcã g̃asũacat! — io'e Jesus. — “Ka'ũma buk ocejojojoiap cuy eg̃ubapuk ocewebe,” i eyju e'em owebe — io'e. — “Ẽn Deus a'õbi jekukum iap cuy eg̃ubapuk ocewebe,” i eyju te'e ma e'em. Ade g̃u og̃ubapuk eywebe epejojo g̃u buk iap. ");
INSERT INTO myu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pũg̃ ma og̃ubapuk eywebe. Jonas kay juy g̃ebum epesop. Kuy bima Deus Jonas o'g̃uju Deus soat podi ma ya'õbaca iap mubapuk am Nínive ka watwat pe. Deus Jonas waram g̃uto o'g̃utait ce'ũap tomukadi soat podi ma wa'õbaca iap mubapuk am ig̃o ka watwat pe. Imẽnpuxim Deus omudot eykay g̃asũ dak. Õn soat wag̃o — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","— Kaxi etajoreg̃atka kukat je'bapuk soat etabixe―ayacat — io'e. — “Teyũku ikẽrẽat kug̃ oxe,” i Deus e'emap kabia bima, ixe ka kukat je'bapuk — io'e. — G̃asũacat tak je'bapuk ixe kabia be. “Ikẽrẽat kug̃ eyju Deus xe,” i je'e ibo ka kukat ixeyũ be. Ixe ayacat oajẽm wũyatka bewi Salomão ekawẽn co am―itaybit cĩcãat ekawẽn co am. Õn eyxe g̃asũ. Salomão etaybicap podi ma õn wetaybit cĩcã. Imẽnpit eyju wekawẽn kay g̃u — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","— “Teyũku ikẽrẽat kug̃ oxe,” i Deus e'emap kabia bima, Nínive ka watwat je'bapuk soat etabutpe. Ixeyũ je'e g̃asũacat pe: “Eyju ikẽrẽat kug̃ Deus xe,” i. Nínive ka watwat oibu'un ikẽrẽat mujurũg̃ ãm. Ikẽrẽat mujurũg̃rũg̃ap o'jepere ip Jonas pe Deus ekawẽn muwẽn puje. Õn eyxe g̃asũ. Jonas etaybicap podi ma wetaybit cĩcã Deus ekawẽn muwẽn ãm. Imẽnpit eyju wekawẽn kay g̃u — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","— Imusop puje, lamparina ag̃unẽm g̃u ico diotpe. Ipikũykũy be g̃u ajomuy. Um acã ajomuy uk'a be õmõmayũ be soat co am — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","— Imẽnpuxim wuyeta lamparina buxim. Wuyetadip pima, soat ijo but wuywebe. Kabia dag̃ ajeku. Wuyetakẽrẽ bima, ijo ba'ore wuywebe. Kabiok tag̃ ajeku. Kabiok tag̃ jekukuap ikẽrẽat mujurũg̃rũg̃ap puxim. ");
INSERT INTO myu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ag̃ cuy epesop ikẽrẽat mujurũg̃ap puxim. ");
INSERT INTO myu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ikẽrẽat mujurũg̃rũg̃'ũmap kabia be jekukuap puxim. Ikẽrẽat mujurũg̃rũg̃'ũm pima, kabia buxim wuyju — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus ekawẽn epere buje Fariseu o'jekawẽn ceweju. — Ejot cuy oduk'a be jekõn ãm — io'e. O'ju ceweju. Oabik jekõn ãm. ");
INSERT INTO myu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jekõn pima Jesus Judeuyũ babi dag̃ g̃u o'jewebuwuy. Imẽnpuye Fariseu itabẽg̃ o'e ijojom. ");
INSERT INTO myu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","G̃ebuje Jesus o'jekawẽn ceweju ip. — Fariseuyũ — io'e. — Kacũg̃kadi acã eyju kopo wuywuy, prato wuywuy dak. Yabi bit ka'ũma. Yabiokok cĩcã. Prato buxim eyju dak eyokok, eyetabikuku jĩjã buye, ikẽrẽat mujurũg̃xi buye dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","— Eyag̃uyba'arẽm! Kacũg̃kadiat o'g̃ug̃ẽiat badiat tak o'g̃ug̃ẽ. ");
INSERT INTO myu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eybubut'in cuy epeg̃ũm tadaybotbocayũ be. Iũmũm pima, xipat epesop Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","— Karem ma ipiat epesupi'ajojo — Jesus o'e Fariseuyũ be. — Soat em eybubut mu'awerorom 10 be. Pũg̃at ũmũm eyju Deus pe. Wara'at pit eyju imuxipanpan eybubun. Eyju puybit mukunukunaptup ũmũm Deus pe, arrudadup ũmũm tak, posũg̃ puximatup ũmũm tak, puybit peaptup ũmũm tak. Xipat eywebe iboap ũm ãm Deus pe. Imẽnpit cedag̃ g̃u warara'acat kug̃ eyju―warẽmtag̃ ma! Deus ikukpin g̃u eyxe. Imẽn xipat g̃u! Xipan cuy warara'acat epejukuk. Ikukpin cuy Deus epejukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— Karem ma ipiat epesupi'ajojo, Fariseuyũ — Jesus o'e. — Eyju abik ojuy ya'õbuyxiat tũyap pe Deus eju kawẽnwẽnap'a be. Eycokcok cĩcã warara'acat pe ibuyxim eykuk am soat etabutpe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","— Karem ma ipiat epesupi'ajojo, Fariseuyũ — Jesus o'e. — Eyetaybit Judeu be ce'ũat etaypi jeje cexĩg̃xĩg̃pi iam. Eyju wuyjuyũ'ũm'ũm etaypi buxim iba'arẽmat puxim. Wuyju itaypi dag̃ kapkam itaypi opop ijoce iam wuyetaybit'ũm puye. Imẽnpuxim eyju warara'acat pe ikẽrẽat mujurũg̃an — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","G̃ebuje Moisés ekawẽn imutaybitbin'ukat o'jekawẽn Jesus eju. — Tapu, ẽn oceju dak ocemukorẽmrẽm imẽn e'em Fariseuyũ be bima — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","— Hm hm — Jesus o'e. — Eyju dak karem ma ipiat epesupi'ajojo — io'e. — Warara'acat ukxabi be ipoxiat mõg̃mõg̃at puxim eyju. Eyju e'em warara'acat pe: “Moisés ekawẽn tag̃ cuy epeku―soat tag̃” i. Imẽnpit soat tag̃ g̃u eyju dak jekukum ixe ekawẽn tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","— Karem ma ipiat epesupi'ajojo — io'e. — Eydobuyũ'ũm'ũm ade Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm o'yaoka. Ixeyũ'ũm'ũm etaypi mubapukap'a epeyamuy wita'a yadipat'a. ");
INSERT INTO myu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ig̃o'a muymuy bima, “Ocedobuyũ'ũm'ũm cũg̃ ma oekuku,” i eyju e'em napa ma. Ixeyũ'ũm'ũm ekukuap tag̃ eyju dak warẽmtag̃ ma jekukum. ");
INSERT INTO myu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Imẽnpuye kuyje Deus o'e: Wekawẽn muwẽnuwẽn'ukayũ juy og̃uju cekay ip wa'õdujowatwat'ukayũ dak, i. Pũg̃pũg̃ ip yaoka ixeyũ'in, i. Ipiat supi'ajoat ip warara'acayũ be dak, i — Jesus o'e. — Imẽn Deus o'e kuyje, itaybit soan puye. ");
INSERT INTO myu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Deus ipiat supi'ajoat g̃asũacat pe cekawẽn muwẽnuwẽn'ukayũ'ũm'ũm o'yaoka buye. Kuy jĩjã ixeyũ'ũm'ũm o'yaoka ip. Deus ipi mujurũg̃ puje, ixeyũ'ũm'ũm o'yaoka ip. Koap Abel'ũm o'yaoka ip. Kanomũm Zacarias'ũm o'yaoka ip. Deus eju kawẽnwẽnap'a be bima o'yaoka ip, iõhõ mupikupikap xe bima. Deus ipiat supi'ajoat g̃asũacat pe ikẽrẽat o'g̃ujurũg̃rũg̃ ip puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","— Karem ma ipiat epesupi'ajo — Jesus o'e Moisés ekawẽn imutaybitbin'ukayũ be. — Eyju warara'acat mug̃uykukukum kawẽn icẽmãn itaybicap puxim ip. Eyetabut g̃u kawẽn icẽmat kay. Eyju warara'acat mubu'u'un tak kawẽn icẽmat kayap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ibocewi Jesus cẽm puje itakoma jĩjã o'e ip Jesus kay Moisés ekawẽn imutaybitbin'ukayũ, Fariseuyũ dak. Jesus o'jomuymuy ip. Jewa'õmukorẽmrẽm o'e ip. Ixe ekawẽn cocom cĩcã ip o'e. Yawẽg̃mukẽrẽrẽn ojuy ip. Cekawẽn puyxijo ojuy ip. ");
INSERT INTO myu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ixe warẽmtag̃ e'em pima, kuka o'jomuymuy ip. Warẽmtag̃ e'em pima, kuka o'yawẽg̃mukẽrẽrẽn ip. ");
INSERT INTO myu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tak g̃u ip o'ju Jesus kay―ade jĩjã. Jewemucakucakan ip o'e, ade buye. G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ be―12 beayũ be. — Ag̃ cuy epesop Fariseuyũ be eymug̃uykukuap puxim — io'e. — Ixeyũ emumutaybitbinap pão'a muyuhuhuaptõm puxim. Ixeyũ emumutaybitbinap tag̃ g̃u juy epeku — io'e. — Jewexe ip xipat. ");
INSERT INTO myu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yajuyjuyat jewedobuxik g̃uyjom. Iba'arẽmat ibapuk je'e soat xe. ");
INSERT INTO myu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kabiok tag̃ epeyekawẽn iap ya'ĩjojo ip kabiam. Badiat'a be eybidadadam epeyekawẽn iap g̃uwẽn ip soat a'õpiju — io'e. — Imẽneju warara'acat mug̃uykukukum g̃u juy epesop xipat oceju iam. Fariseuyũ ekukuap puxim g̃u juy epeku — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","— Obureyũ — io'e. — Eyaoka ojuyayũ buxim g̃u juy eypararam epesop. Ixeyũ be eyaoka but ma. G̃uyjom pit eybiõg̃buk mu'ũm pa'ore cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Deus buxim acã juy eypararam epesop. Ixe be bit wuyaoka pi g̃u. Wuye'ũ buje dak ipiat'ajojoap pe wuybiõg̃buk xik put cebe. Imẽneju juy ixe buxim eypararam epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","— 5 be pidiwe dei tei'ĩt ma―pũg̃ centavo ma. Deus pit yag̃uyba'ũm g̃u wasũyũ kay. Pũg̃ kay dak yag̃uyba'ũm g̃u. ");
INSERT INTO myu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Deus itaybit wuyadap pebũrũdap iam. Deus xe teibog̃ g̃u wasũdei. Imẽnpit ag̃ cekay. Imẽnpuxim wuykay dak ag̃ soat em. Imẽneju eyag̃uybabi'ũm'ũm g̃u juy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","— Icẽmãn õn e'em eywebe. Soat wag̃o õn. Eyju “Jesus ebekitkiyũ oceju,” i'e'em pima, õn tak “Teyũku webekitkit,” i oce Deus ekawẽn tojotjot'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eyju e'em warara'acayũ be “Jesus bure g̃u oceju,” i bima, õn tak “Iteyũ bure g̃u õn,” i oce Deus ekawẽn tojotjot'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Soat wag̃o õn. Omuymuy bima, eyju ikẽrẽat kug̃ Deus xe. Deus iboap ju'uk eywebewi ikẽrẽat. Ibiõg̃buk xipacat muymuy bima bit, Deus iboap ju'uk g̃u eywebewi ikẽrẽat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","— Warara'acayũ jeydujowat Deus eju kawẽnwẽnap'a be ipi kukukayũ dopabe dak, iecug̃ap dopabe dak. Eydujowat puje, eyag̃uybabi'ũm g̃u juy epesop eyewedayo am. “Pẽn paxi oce,” i'ũmg̃u juy epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","— Ixeyũ dopabe eydujowat puje Ibiõg̃buk xipacat jeymukũyjo jekawẽn ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","G̃ebuje ag̃okatkat o'jekawẽn Jesus eju adeayũ parakpeat. — Tapu — io'e. — “Ebay'ũm pubut cuy eg̃u'ẽ'ẽ ekitpit pe,” i juy ece owag̃o be — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","— Ap! — io'e. — Deus cuk omudot eykay eyemãmãap coco am g̃u, ce'ũat pubut mu'ẽ'ẽ ãm g̃u dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","— Eyetabikukum g̃u juy epesop! Soat em Deus xe wuyetait acesop ade wuybubut pupum puye g̃u―cekay wuyetabut puye acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn aweromayũ be. — Ibubut adeat kat katõ be osodop. O'jewa'ada jĩjã. Ya'ade o'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","— Imẽnpuye ibubut adeat o'jekawẽn jewebe ma. — “Okat pewiat mũn'a yabog̃ g̃u,” io'e. “Apẽntak oce? Je'e g̃u, ya'ade jĩjã buye,” io'e jewebe ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","— “Imẽn ma oce. Okat pewiat mũn'a oyamuy'at―yabog̃bug̃at'a. Yabog̃at'a oyamuyat,” io'e jewebe ma. “Yamuyisuat'a be okat pewiat og̃uxipan, soat obubut tak,” io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“ ‘Ocokcog̃ og̃uy, ade obubut puye,’ i juy oce owebe ma,” io'e jewebe ma. “ ‘Soat kug̃ og̃uy,’ i juy oce owebe ma,” io'e jewebe ma. “ ‘Kapikpig̃ g̃u og̃uy jebodoydoy acã, jekõnkõn acã dak, tikõnkõn acã dak,’ i juy oce owebe ma,” io'e jewebe ma ibubut adeat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","— Imẽnpit Deus o'jekawẽn ixe ibubut adeat pe. — “Ag̃uyba'arẽm!” io'e. “Ade jĩjã juk adi eg̃uxipan ewebeam ma,” io'e Deus. “Ijop kabiok ma ece'ũ,” io'e. “Abu je'jat ebubut e'ũ buje?” io'e Deus — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","— Pũg̃pũg̃ayũ soat em g̃ebum apẽn xe'e wara'at'in ojat obubun iap kay. Deus kay g̃ebum g̃u ma'g̃u ip. Ixe ag̃okatkat puxim ip―yadaodaoat puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","— Imẽnpuye eyag̃uy'ũm g̃u juy epesop eybubut kay — io'e jeweju etaybitbinayũ be. — “Ajo paxi acejo'o?” i'ũmg̃u juy epe'e — io'e. — “Ajo paxi aceg̃uõm wuydotim?” i'ũmg̃u dak cuy epe'e. ");
INSERT INTO myu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Xipat eyxat kug̃ pima, eydoti kug̃ pima dak. Ibodi ma bit xipat soat em Deus xe eydop am — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","— G̃ebum cuy epesop wasũ iokat kay — io'e. — Taidadam g̃u ip. Jeku beat pupum g̃u dak ip. Jeku bewiat mũn'a'e g̃u ip. Imẽnpit Deus ixat ũmũm cebe ip―wasũyũ be. Deus xe teibog̃ g̃u wasũ. Imẽnpit ag̃ cekay ip. Wuykay dak ag̃ soat em ma. ");
INSERT INTO myu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ade koato mabuk wetabẽg̃ og̃uy iap kay g̃ebum cĩcã bima, eyetabẽg̃ xe'e? Ka'ũma. G̃axĩn ma aco'i epe'ũ. ");
INSERT INTO myu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iboap iba'ore eywebe bima, te'e ma eyag̃uy'ũm ijodiap kay―eydoti kay, eyxat kay dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","— G̃ebum cuy epesop kog̃ũnpi dag̃atit kay, apẽn dit aypapan iap kay. Kapikpig̃ g̃u tũmũntitit. Jedoti mug̃ẽg̃ẽm g̃u dak ip. Icẽmãn õn e'em eywebe. Salomão ibubut adeat osunuy. Idip cĩcãat kug̃ osunuy jesay kug̃. Salomão dipap podi ma bit titip tip tag̃atip. ");
INSERT INTO myu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","G̃asũ ma tũmũntitit titetabẽg̃ e'em. Kuyaje bit tite'ũ e'em. Deus a'õbi titip. Ja'õbi dak eyemukaypinput je'g̃ũm eywebe eyetabutsũ ma'g̃u cekay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","— “Ajo paxi acejo'o,” i'ũmg̃u juy epe'e, “Ajo paxi aceg̃uõm,” i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","— Deus kay itabut'ũmayũ yag̃uy'ũm iboap kay. Wuyebayat pit itaybit wuyju ikug̃'ũm pima iam―kabi beat. ");
INSERT INTO myu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","G̃ebum cuy epesop Deus acã wuykukukat iap kay. Iboap kay g̃ebum pima, Deus soat je'g̃ũm eywebe. Eyxan je'g̃ũm, eydotim tak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","— Eypararam g̃u juy epesop — io'e. — Wuyebay Deus eykukukat ovelha kukuk'ukat puxim. Ixe ibikuy eywebe jekukan — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","— Eybubut'in cuy epeteidaat eyedinheiro bu am — io'e. — Ixe dinheiro juy epeg̃ũm tadaybotbocayũ be. Iũmũm pima eybubut ade epe'e kabi be. Eybubut iwekwek g̃u je'e kabi beat. I'ũm g̃u dak. Ka'ũmg̃u ibukurukat kabi be eybubut tujupa'um am. Kopi'i eybubut jo'o g̃u kabi be. ");
INSERT INTO myu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eybubut ijodi bima, soat em g̃ebum epesop eybubut kay. Kabi be bima bit g̃ebum epesop kabi beat kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","— Kariwa ajẽmap wiwimap puxim cuy epesop wajẽmap wiwim — io'e. — Ixe kariwa juk o'ju jewebumũnap epeta kay. Cepicat wiwim ibuywatwat'ukayũ. Lamparina kug̃ ip―isopsepat kug̃. Jekariwa ajẽmap wiwim ip xĩntabi nomudip'uk am cebeam yajẽm puje, cetag̃tag̃ puje. ");
INSERT INTO myu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ag̃ ip tobuxik puje icokcok je'e ip ixeyũ ibuywatwat'ukayũ jekariwa ajẽm puje. Icẽmãn õn e'em eywebe. Ixe kariwa jeõm jeduk'a be. Ixat je'g̃ũm cebe ip. “G̃a'a acekõn,” i je'e jebuywatwat'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iximadak pe, iximadak pepu i aco'i jajẽm. Yajẽmap wiwim ip tobuxik puje, icokcok je'e ip ixeyũ ibuywatwat'ukayũ. ");
INSERT INTO myu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Imẽnpuxim cuy ag̃ epesop wepicap wiwim―soat wag̃o epicap wiwim. Ocepit eyju wepicap wiwim'ũm pima, ag̃'ũm pima dak. Ibukurukat ajẽmap ehoram itaybit pima, jeduk'a kajuk o'yaiwat g̃u uk'a iwat. O'yaiwat g̃u puyxibut'ũm iõmap puxim. Imẽnpuye juy ag̃ epesop wepicap kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","G̃ebuje Pedro o'jekawẽn Jesus eju. — Kariwa — io'e. — Ẽn ijop ekawẽn muwẽnuwẽn ocewebe ya'ĩjo am acã du? Soat pe ya'ĩjo am g̃u xe'e? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","— Õn ijop ekawẽn muwẽnuwẽn xipan jekariwa bubut kukayũ be ya'ĩjo am―itaybicayũ be ya'ĩjo am — io'e. — “Obubut kukukan cuy ece,” i'e'em kariwa cebe ip. “A'õ kay jeedop ip kũyjobin warara'acayũ obuywatwat'ukayũ,” i'e'em kariwa. “Ixeyũ xan cuy eg̃ũmg̃ũm,” i'e'em cebe, cedag̃ kapikpig̃ puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","— Jekariwa a'õ kay kũyjobin pima, ixe ibuywatwat'ukat icokcok je'e jekariwa ajẽm puje. ");
INSERT INTO myu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Icẽmãn õn e'em eywebe — io'e. — “Obubut kukukan cuy ece,” i je'e kariwa ixe jebuywatwat'ukat pe. ");
INSERT INTO myu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","— “O'jekuyan ma wekariwa,” i'e buje bit, g̃ebuje'isum ma jajẽm cekariwa. Kapikpig̃'ũm pima jajẽm. Ixe ibuywatwat'ukat warara'acayũ kaykay bima, jajẽm. Jekpiwan ma jekõnkõn cĩcã bima jajẽm. Ika'o bima, jajẽm. ");
INSERT INTO myu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jebuywatwat'ukat yajẽmap wiwim'ũm pima jajẽm, yajẽmam itaybit'ũm pima dak. Imẽnpuye cekariwa ipiat supi'ajoat jebuywatwat'ukat pe. Jebuywatwat'ukat g̃uju kũyjobit'ũmayũ dopap pe jenuy am. ");
INSERT INTO myu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Apẽn jekariwa ibikuy osunuy jekapikam iam itaybicat yobog̃ ipiat supi'ajojo jewemuxipan'ũm pima, kũyjobit'ũm pima dak. Yobog̃ ipiat supi'ajojo itaybit puye. ");
INSERT INTO myu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Apẽn jekariwa ibikuy osunuy iam itaybit'ũmat pit yopĩt ma ipiat supi'ajojo kũyjobit'ũm pima. Yopĩt ma ipiat supi'ajojo itaybit'ũm puye. Ade ikug̃at cuy ade je'g̃ũm warara'acat pe. Ade o'jatiat xewi juy ade acejoojuy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","— Daxa buxim okop ijodiacat pe wara'at tag̃tag̃tag̃ ma jewag̃uy ãm — Jesus o'e. — Iboap wekapikap. Wekapik epere ojuy õn. ");
INSERT INTO myu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Warara'acat ipiat supi'ajoat ewebe,” i juk o'e Deus owebe. “Aokam ip,” i juk o'e. Deus bikuyap tag̃ weku pin cĩcã soat em. Soat em g̃ebum õn iboap kay. ");
INSERT INTO myu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tũybe teku osodot kaba'ũm wuydop am iãn eyju e'em. Imẽg̃ãm g̃u ojot. Ojot ijodiacat pe wara'at tag̃tag̃tag̃ ma jeku am. ");
INSERT INTO myu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ibadipyũ wara'at tag̃tag̃tag̃ ma jeku õn ojot puye. Xepxepayũ pũg̃ tag̃ ma jeku ip. Ixeyũ badipyũ bit wara'at tag̃ ma jeku ip ebapũg̃ayũ. ");
INSERT INTO myu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cebay ma okay je'e. Ixe ipot pit okay g̃u je'e. Ixi ma okay je'e. Ixe'it pit okay g̃u je'e. Yuktayxi ma okay je'e. Ixe ayacat uktayxi bit okay g̃u je'e. Imẽneju wara'at tag̃tag̃tag̃ ma jeku ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn adeayũ be. — Kaxi'acap pewi kabikerereat ebapuk puje “Muba'at omuyku,” i eyju e'em. Icẽmãn ajẽmjẽm. ");
INSERT INTO myu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kaxietajoreg̃at pido ajẽm puje “Kaxiepi jĩjã g̃asũ,” i eyju e'em. Icẽmãn kaxiepi je'e. ");
INSERT INTO myu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Eyetaybit muba'at ajẽm iam kabi kay ag̃ puye. Eyetaybit kaxiepi je'e iam kabido jojom puye. Imẽnpit eyetaybit g̃u ajo g̃uyjom je'bapuk eywebe iam wekawẽn cocom ma'g̃u eyju. Wekawẽn pa'arẽm eyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","— Eyju jewawẽwẽm g̃u dak cedag̃ ma eyeku am. ");
INSERT INTO myu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eykay itakomaat e'em eywebe “Eyweroap cuy epeteida owebe,” i. “Teida'ũm pima, jeydujowan õn ibimãmãayũ ekawẽn coco'ukat kay,” i. Imẽn i'e buje, ixe juy epeg̃udin e dag̃ pima. E dag̃ pima itakomaat mudin'ũm pima, ixe jeydujowat ibimãmãayũ ekawẽn coco'ukat kay. Ibimãmãayũ ekawẽn coco'ukat tak jeydujowat sorarayũ kay. Sorarayũ jeymuõm daomũnmũnap'a be. ");
INSERT INTO myu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Soat g̃u eyeweroap teida'ũm pima, jeymujẽm g̃u ip daomũnmũnap'a bewi — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","G̃ebuje pũg̃pũg̃ayũ o'jekawẽn Jesus eju. — Iecug̃ap Pilatos Galiléia eipi watwat'in o'yaokaat — io'e ip. — O'yaokaat ip Deus eju kawẽnwẽnap'a be bima, wũnca ũmũm pima paĩ be imupik an Deus etabixe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","— “O'yaokaat ixeyũ ag̃okatkayũ warara'acat podi ma xipat'ũm puye―Galiléia eipi watwat podi ma,” i du eyju e'em? ");
INSERT INTO myu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Imẽn g̃u juy epe'e'e! Icẽmãn õn e'em eywebe. Ikẽrẽat epere'ũm pima, Deus kay eyetabut'ũm pima dak, ipiat'ajojoap kay epeju eyju dak — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","— Waram pima oap ip Siloé ka watwat 18 beayũ. Oap ip uk'a o'je'aedu buye―umat'a. O'g̃ucak ip. “Oap ip soat podi ma xipat'ũm puye―Jerusalém ka watwat podi ma,” i du eyju e'em? Imẽn g̃u juy epe'e'e! ");
INSERT INTO myu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ikẽrẽat epere'ũm pima, Deus kay eyetabut'ũm pima dak, ixeyũ buxim epeju ipiat'ajojoap kay eyju dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn adeayũ be―figueira'ip ekawẽn. — Ag̃okatkat figueira'ip o'yoptaida jekat pe, uvadip pe — io'e Jesus. — Oajẽm figueira'ip kay figo'a kudadam. ");
INSERT INTO myu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","O'yadobuxik g̃u. Imẽnpuye o'jekawẽn uvadip wiwi'ukat pe — io'e. — “Tapu, ebapũg̃ koato juk adi oajẽm ija'ip kay figueira'ip kay”, io'e cebe — io'e. — “Yaopap ekaxi bima juk adi oajẽm figo'a kudadam,” io'e — io'e. — “Ya'ũmg̃u. Oyadobuxik g̃u. Te'e ma ijop'ip omuy. Eyopxik cuy,” io'e uvadip wiwi'ukat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","— G̃ebuje tipwiwi'ukat o'jekawẽn tip iwat pe — io'e Jesus. — “Kariwa, jewebuyxijo buk,” io'e. “Ijop koato g̃u eyopxikat,” io'e. “Oyokobidog̃ cuy yokobi koreren. Tũmũntũntũn otũnmõg̃ yokobi koreren,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Wara'at koato bima ya'a'e bima, xipat je'e. Ya'a'e'ũm pima bit oyopxik,” io'e tip iwat pe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","12","Waram pima Jesus Deus eju kawẽnwẽnap'a beayũ o'g̃utaybin. Sábado bima ip o'g̃utaybin jebodoydoyap kabia bima. Jesus ayacat o'jojojo ig̃o'a be. Ixe ayacat ikokpiwakun osunuy ade koato―18 koato bun. Ikokpiwakun osunuy ibiõg̃buk kẽrẽat a'õbi. Ce'ag̃obucẽg̃ pa'ore osunuy ibiõg̃buk kẽrẽat a'õbi. Jesus ixe o'g̃udot jekay. — Tũ'ũ — io'e. — Õn jemu'ada — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","O'jewebumõg̃ ixe jeje. O'g̃u'ada g̃ebuje bit. O'sukokpimucũg̃. O'sukokpimudim. Ikokpicũg̃ o'e. — Bay, xipat cĩcã ẽn owebeam — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Deus eju kawẽnwẽnap'a kukuk'ukat pit itakoma o'e Jesus kay, jebodoydoyap kabia bima ayacat o'g̃u'ada buye. Tũybe imu'ada pi jebodoydoyap kabia be iãn o'e. Imu'adaap kapikap co'i osunuy cexe. — Seis kabia bima cũg̃ ma wuywebe wuyekapik am — yakukuk'ukat o'e ig̃o'a beayũ be. — Jebodoydoyap kabia be bit epesot g̃u jemu'adaan―wara'at kabia be acã — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","G̃ebuje Jesus o'jekawẽn ig̃o'a beayã be. — Tũybe imu'ada pi wuywebe iãn eyju e'em — io'e. — Jebodoydoyap kabia bima epeg̃uwekap g̃u du ehõyõ―biopak? — io'e. — Jumento dak epeg̃uwekap g̃u du tujujẽm ãm korara bewi idibi kõn ãm? Soat eyju eyõhõ muwekapkam soat kabia bima―jebodoydoyap kabia bima dak. ");
INSERT INTO myu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Imẽnpuye cedag̃ ma owebe ixe ayacat mu'ada am g̃asũ. Abraão naxeg̃ebit puxim itabut ixe. 18 koato bun Satanás ixe ayacat kokpi muwakunkun'uk osunuy―ibiõg̃buk kẽrẽayũ kukukat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cekay itakomaayũ ma isũsũn o'e ip Jesus edeap co buje. Warara'acayũ bit icokcok o'e ip Jesus kay. — Ka'ũma buk ocejojojoiap mubapukpug̃ Jesus wuyetabutpe — io'e ip. — Idip cĩcãat mubapukpug̃ wuyetabutpe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","G̃ebuje Jesus waram wuymutaybitbinap ekawẽn o'g̃uwẽn. — Apẽn je'e Deus soat kukukan pima? — io'e. — Apu ekawẽn tak og̃uwẽn iboam eymukũyjo am? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","— Ag̃okatkat mostardada o'taida jekat pe. Mostardada ta'ĩt ma. O'yaypan cĩcã bit. Mostarda'im o'e. Yobog̃ o'e. Wasũyũ jedopi o'jomõg̃mõg̃ takũ dag̃. Imẽnpuxim koap Deus ade'ũmayũ kukukan je'e. G̃uyjom pit soat kukukan je'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","— Apu ekawẽn tak og̃uwẽn waram eymukũyjo am Deus soat kukukan je'e iam? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","— Trigonõm kug̃ osunuy ayacat―ebapũg̃ copo. Ixe ayacat pão'a muyuhuhuaptõm o'tõmpu. O'tõmõg̃ trigonõm pe. O'tõmupinã. Soat tag̃ o'jenõmepõg̃põg̃ trigonõm tag̃. Imẽnpuxim soat ka watwat Deus soat kukukan je'e iap awẽg̃ coco — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","G̃ebuje Jesus o'ju Jerusalém ka kay. Cucum pima soat ka dag̃ oekuku―ika'ĩcatka dag̃, ikabog̃atka dag̃ tak. Soat kaka dag̃ imutaybitbin oekuku. ");
INSERT INTO myu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","G̃ebuje ag̃okatkat o'jekawẽn Jesus pe. — Kariwa, taxijojo'ibiyũ xepxep ma du je'e? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Tapu, okay eyetabucap xĩntabi be wuyõmap puxim. Eyetabun cuy epesop okay! — io'e. — Kabi kayat exĩntabi itokbog̃ gu―itok'ĩt ma — io'e. — Soan cuy epe'e kabi be eyõm ãm! Icẽmãn õn e'em eywebe. Adeayũ õm ojuy je'e. Imẽnpit iõm pa'ore je'e ip. ");
INSERT INTO myu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uk'a iwat je'kop xĩntabi nomudim. Tomudip puje, eyõm pa'ore epesop. Kacũg̃kadi epesop. Xĩntabi be tag̃tag̃tag̃'i epesop. “Kariwa, ocewebe xĩntabi etomudip'uk oceõm ãm,” i epe'e. Imẽnpit kariwa je'e eywebe “Wetaybit g̃u pomawiacat eyju iam,” i — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","— “Jekõnkõn tak ocesop eweju,” i epe'e cebe. “Ocemutaybitbin cuk ejeku oceka dag̃,” i epe'e. ");
INSERT INTO myu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Imẽnpit kariwa je'e eywebe: “Icẽmãn õn e'em eywebe. Wetaybit g̃u dak pomawiacat eyju iam,” i. “Eyõm pa'ore ijoce eyju ikẽrẽat kug̃ oxe buye. Epejẽm,” i je'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","— G̃ebuje epetõtõn. Eyg̃uycũg̃cũg̃ cĩcã ma epesop. Deus soat kukukan pima, Abraão cexe jeenuy, Isaque dak, Jacó dak. Deus ekawẽn muwẽnuwẽn'ukayũ dak Deus xe jeedop ip. Wũy wi ixeyũ epejojojo. “Wũy ma juy epesop owi,” i je'e Deus eywebe. ");
INSERT INTO myu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Adeayũ jajẽm soat eipi dag̃wi―kaxijẽmap kadiwi, kaxi'acap kadiwi dak, kaxijẽmapcoreg̃wi dak, kaxiejoreg̃wi dak. Soat ip jabik jekõn ãm Deus ka be Deus soat kukukan pima — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","— Koapayũ kanomũmayũm je'e. Imẽnpuxim kanomũmayũ koapayũm je'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","G̃ebuje isum ma Fariseuyũ oajẽm Jesus kay. — Aoka ojuy Herodes―oceipi kukat — io'e ip Jesus pe. — Ecenapõn cuy ijocewi ixe be aokaap puxim — io'e ip. — Ocenapõn g̃u — io'e. — Deus ibikuy bima acã oje'ũ. Herodes eymug̃uykukuku'ukat kak puxim — Jesus o'e. — Epeju juy cekay. Wa'õ juy epeya'õmuwẽn cebe. ");
INSERT INTO myu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","“G̃asũ, kuyaje dak ibiõg̃buk kẽrẽat og̃ujẽmjẽm ijodiat pewi,” i juy epe'e cebe — Jesus o'e. — “Iwãtaxipipiayũ og̃u'ada'ada,” i juy epe'e. “Kuyajebusu wekapikap og̃u'ũm,” i. ");
INSERT INTO myu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Oje'ũ. Imẽnpit wekupinap tag̃ ojeku g̃asũ, kuyaje dak, kuyajebusu dak,” i juy epe'e cebe — Jesus o'e. — “Eka be g̃u oje'ũ, Jerusalém ka be acã,” i juy epe'e Herodes pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","— Jerusalém ka watwat, Deus ekawẽn muwẽnuwẽn'ukayũ aokakam eyju — io'e Jesus. — Yabug̃bug̃ tak eyju ip wita'am. Sapokay'it'it jexi kay. Jedaudaum jexi eg̃ebadap tiotpe kajuk pibun. Eyju bit okay g̃u. Eybu'u jĩjã eyetabut am okay, eykukpin cĩcã a'g̃u oxe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","— Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. — Jeywat õn ag̃okatkat jedukã iwacap puxim — Jesus o'e. — Icẽmãn õn e'em eywebe. Waram ojo g̃u eyju waram wajẽm'ũm pima. Wajẽm puje, “Deus xipan wuykukukat a'õbi yajẽm'ibit jukuk,” i epe'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jebodoydoyap kabia bima Jesus o'ju ag̃okatkat tuk'a kay―Fariseu duk'a kay―ya'õbuyxiat tuk'a kay. Sábado bima o'ju. Jekõn ãm ceweju o'ju. ");
INSERT INTO myu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iyeuhuhuat Jesus xe osunuy. Uk'a beayũ o'jeak Jesus kay. Tũybe imu'ada pi osunuy jebodoydoyap kabia be iãn o'e ip. Imu'ada buje, kuka o'jomuymuy ip. ");
INSERT INTO myu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","G̃ebuje Jesus o'jekawẽn Fariseuyũ eju, Moisés ekawẽn imutaybitbin'ukayũ eju dak. — Wuyawẽwẽap ekawẽn tag̃ tu iwãtaxipiat mu'ada am jebodoydoyap kabia bima? Cedag̃ g̃u xe'e? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ya'õbu'u osodop ip jedem. Mũg̃ ma ip osodop. G̃ebuje Jesus iyeuhuhuat o'subaixik. O'g̃u'ada. Iyeuhuhu g̃u o'e. Xipat o'e. O'g̃uypit tuk'a be. ");
INSERT INTO myu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","G̃ebuje waram o'jekawẽn Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. — Soat eyju kapikpig̃ jebodoydoyap kabia be — io'e. — Ipikũykũy be eyipot at puje, epeju'uk g̃u du kuka jebodoydoyap kabia bima? Eyeõhõ biopak at puje dak, epeju'uk g̃u xe'e kuka? Dao ma kuka epeju'uk! Imẽnpuye te'e ma eyetakoma okay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ya'õbu ba'ore o'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn jekõn ãm takoy'ibiyũ be. Ixeyũ takoy'ibiyũ kariwa bog̃at nuyap pe abik ojuy ip o'e. Imẽnpuye ijop ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Jewebumũnap epeta be eydakoy buje, kariwa yobog̃at tũyap pe g̃u juy epabik―ka'ũmaap tũyap pe acã — io'e. — Kariwa yobog̃at aco'i o'takoy ip―eybodiat. ");
INSERT INTO myu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kariwa yobog̃at tũyap pe eyabik puje, eydakoyat jajẽm eykay. “Wede'i ece. Ẽn kariwa g̃u,” i je'e eywebe — io'e. — “Ig̃o bit kariwa. Ig̃o abik pin enũyap pe,” i je'e eywebe — io'e. — Imẽn i'e buje, eysũsũn epe'e. Jeymuabik ka'ũmaap tũyap pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","— Eydakoy buje juy epeju. Ka'ũmaap tũyap pe juy epabik. Eydakoyat pe iboap co buje, jajẽm eykay. “Obure, kariwa yobog̃at tũyap pe juy abik, ẽn kariwa buye,” i je'e eywebe — io'e. — Imẽn i'e buje, eyweju jekõnkõnayũ xe eya'õbuyxiayũm epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","— Eya'õbuyxian pin pima, Deus xe eya'õbuyxi g̃u epesop. Eya'õbuyxian pin'ũm pima bit, cexe eya'õbuyxiayũm epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","G̃ebuje Jesus o'jekawẽn jedakoyat pe. — Peta mug̃ẽg̃ẽm pima, ibubut adeayũ acã g̃u juy etomuwã. Ibubut adeayũ acã g̃u juy etomuwã, ebureyũ acã g̃u dak, ewag̃oyũ acã g̃u dak, ebadipyũ acã g̃u dak, eduk'a xeacat kariwaat acã g̃u dak. Ixeyũ waram cuy jenomuwã apẽn cuk ixeyũ enomuwãap puxim. Apẽn cuk eg̃ũm iap puxim ejat. ");
INSERT INTO myu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Peta mug̃ẽg̃ẽm pima tadaybocayũ dak etomuwã, taokẽrẽayũ dak, taojereayũ dak, ita'ũmayũ dak. ");
INSERT INTO myu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ixeyũ be waram iũm pa'ore ewebe apẽn cuk cebe ip eg̃ũm iap puxim. Deus pit xipacat je'g̃ũm ewebe. Waram g̃uto cũg̃ ma jekuku'ukayũ'ũm'ũm etait puje, Deus xipacat je'g̃ũm ewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ceweju jekõnkõnat o'jekawẽn Jesus eju ibo ekawẽn co buje. — Deus soat kukukan pima icokcok cĩcã je'e ceweju cekõn'ibit — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","— Hm hm — Jesus o'e. — Abuyũ jekõn Deus eju iap og̃uwẽn eywebe — io'e. — Ag̃okatkat petabog̃ o'g̃ug̃ẽ. Jebureyũ o'tomuwã―ibubut adeayũ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","— Soat ixipan pima jebuywatwat'ukat o'g̃uju jemunomuwãyũ dakoy am. O'ju. — “Kuy soat ixipan,” io'e. “Epesop cuy wekariwa epeta be,” ibuywatwat'ukat o'e tomuwã'ibiyũ be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","— Imẽnpit tomuwã'ibiyũ “Ocedaobu'u,” io'e ibuywatwat'ukat pe. O'taobu'un ip peta kay. — “Ipi ojat okat mõg̃ ãm,” io'e ibuywatwat'ukat pe — io'e Jesus. — “Cum puk õn ipi jom,” io'e. “Imẽnpuye odaobu'u ekariwa epeta be,” io'e. “Imẽn cuy ece ekariwa be,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","— “10 be ojat biopak,” wara'acat o'e. “Cum puk õn ibuyxijom ip,” io'e. “Imẽnpuye odaobu'u ekariwa epeta be. Imẽn cuy ece ekariwa be,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","— “Kapusu ma juk ocewebumũn ayacat eju,” wara'acat o'e. “Oju ba'ore ekariwa epeta be. Imẽn cuy ece cebe,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","— Imẽneju ibuywatwat'ukat o'jepit jekariwa kay―peta iwat kay. Taobu'u'uayũ a'õ o'ya'õmuwẽn jekariwa be — Jesus o'e. — Iboap co buje cekariwa itakoma jĩjã o'e. — “Tadaybocayũ juy etojot wepeta kay taobu'u'uayũ dieg̃,” io'e jebuywatwat'ukat pe. “Cexĩg̃xĩg̃ pa'oreayũ juy etojot, taokẽrẽayũ dak, ita'ũmayũ dak,” io'e. “Dao ma eju ikabog̃atka kay,” io'e. “Uk'a ukpibubu dag̃ cuy eju, e dag̃ tak,” io'e. “Soat ip etojot wepeta kay,” io'e cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","— O'ju ikabog̃atka kay. Tadaybocayũ o'tojot jekariwa duk'a be. — “Kariwa,” io'e. “Otojot ip a'õbi,” io'e. “Imẽnpit eduk'a be wuydop pun mabuk,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","— “Waram cuy eju tadaybocayũ kay,” io'e cebe. “E dag̃ cuy eju, kog̃ũnpi dag̃ tak. Eg̃uõm ip oduk'a be yamuporan am. ‘Epesot cuy wekariwa epeta be,’ i juy ece cebe ip,” io'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","— “Õn soat kukukan pima koap tomuwã'ibiyũ jekõn g̃u oweju―pũg̃ tak ka'ũma,” io'e peta iwat — io'e Jesus. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn jeweju jekõnkõnat pe. ");
INSERT INTO myu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Waram pima Jesus o'jekawẽn adeayũ be. Ceweju jekuku'uk osodop ip. O'jekawẽn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Oweju eyeku pin pima, okay jĩjã ma juy epesop — io'e. — Eyebay kayap podi ma okay'ũm pima, webekitkin g̃u epe'e, eyxi kayap podi ma dak, eytayxi kayap podi ma dak, eyebekitkit kayap podi ma dak, eywag̃o kayap podi ma dak, eykibit kayap podi ma dak, eykipit kayap podi ma dak. Jewekayap podi ma okay'ũm pima dak, webekitkin g̃u epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","— Owebeam je'ũ ãm eybu'u bima, webekitkin g̃u epe'e, oweju jekum eybu'u bima dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","— Yaberenat'a muy pin pima, koam kuka yamuyaptei epeg̃uweg̃ũn — io'e. — “Je'e paxi wedinheiro?” i juy epe'e eyewewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Imuweg̃ũn'ũm pima yamuy epere ba'ore kuka o'e eywebe. Imuweg̃ũn'ũm pima eyedinheiro kuka oi'ũm ipi kayat muy buje. Ipi kayat'a jojoayũ kuka eywaywayway — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","— “Ak'i juy epe'e ig̃o'a kay,” i kuka o'e ip. “Yaberenat'a muy ojuy. Imẽnpit o'yamuy g̃u cedinheiro oi'ũm puye,” i kuka o'e ip eywaywayway — io'e Jesus. — Uk'a muy pin pima wuyju e'em “Je'e paxi wedinheiro?” i. Imẽnpuxim eyju dak webekitkit pin pima, “Ipiat'ajojom pima paxi kuka ocebu'un?” i juy epe'e eyewewebe ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","— Wara'at ka kukat eju jenopag̃õg̃õ ojuy bima, ag̃oka kukat koam kuka o'jewawẽ jebureyũ eju―itaybit cĩcãayũ eju. “Wuyesorarayũ adesũ―10,000 beayũ,” i kuka o'e cebe ip. “Wuykay itakomaayũ esorarayũ bit ade jĩjã―20,000 beayũ,” i kuka o'e cebe ip. “O'e paxi wuywebe ixeyũ mu'ũm ãm?” i kuka o'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","— Itaybit cĩcãayũ be: “Iba'ore wuywebe” i'e buje, ipi kukukat iparara kuka o'e. Oibu'un kuka jenopag̃õg̃õm. Jexewi wũy bima, jebekitkit kuka o'g̃uju cekay ip jekay itakomaayũ mudin am — io'e. — “G̃a'a juy acenopag̃õg̃õm g̃u,” i kuka o'e cebe — io'e Jesus. — “O'e paxi wesorarayũ be itakomaayũ mu'ũm ãm?” i'e'em ipi kukukayũ. ");
INSERT INTO myu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Imẽnpuxim eyju dak webekitkit pin pima, “G̃uyjom paxi ocebu'un?” i juy epe'e eyewewebe ma. Soat eybubut iwan eybu'u bima, webekitkin g̃u epesop — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","— Kawta xipat. Imẽnpit takõ'õm puje, te'e ma kuka atakuk. ");
INSERT INTO myu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tamuyun pa'ore wuywebe. Taxik am acã xipat. Imẽnpuxim okay eybu'u bima, te'e ma kuka epe'e: “Cristo ebekit õn,” i. Wekawẽn a'ĩjo pin pima juy xipan epeya'ĩjo. ");
INSERT INTO myu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","G̃ebuje iecug̃ap peam dinheiro bubu'ukayũ o'ju Jesus kay, warara'acayũ ikẽrẽat mujurũg̃rũg̃'ukayũ dak. O'ju ip Jesus ekawẽn com. ");
INSERT INTO myu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","G̃ebuje Fariseuyũ Jesus o'jomuymuy Moisés ekawẽn imutaybitbin'ukayũ dak. — Ite ag̃okatkat ikẽrẽat mujurũg̃rũg̃'ukat purem. Jekõnkõn ceweju ip — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iboap co buje, Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip jemuymuyayũ be. ");
INSERT INTO myu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Eyju 100 be eyõhõ kug̃ aco'i―ovelha kug̃ — io'e. — Pũg̃ oitabidao bima, wara'acat eyõhõ kuka epesuiwat kog̃ũnpi dag̃ itabidaoat kuda am. Tobuxik'ũm pima kuka epeju itabidaoat kuda am. Epejokuda kuka tobuxik puje. ");
INSERT INTO myu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tobuxik puje, eycokcok kuka epe'e. Eya'õpi'a jeje kuka epejomõg̃. Eyduk'a be kuka epetujuxe. ");
INSERT INTO myu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eyduk'a be eyõm puje, eybureyũ kuka epetomuwã, eyduk'a xeayũ dak. “Oceõhõ ocetobuxik! Eycokcog̃ cuy oceweju,” i kuka epe'e cebe ip — io'e. — “Ovelha ocetobuxik―itabidao oekuiat,” i kuka epe'e. ");
INSERT INTO myu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Icẽmãn õn e'em eywebe. Itabidao oekuiat puxim ikẽrẽat mujurũg̃rũg̃ap o'jepere iat―ovelha buxim — io'e. — Imẽnpuye Deus icokcok e'em ade cũg̃ayũ kay. Imẽnpit jekay ikẽrẽat mujurũg̃rũg̃'ukat etabun puje, ibodi ma icokcok e'em Deus, ikẽrẽat mujurũg̃rũg̃ap epere buje dak — io'e Jesus. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","G̃ebuje Jesus wara'at ekawẽn o'g̃uwẽn cebe ip. — Ayacat 10 be dinheiro kug̃―isurũg̃at kug̃―teibog̃at kug̃―prata mug̃ẽg̃ẽ kug̃. Pũg̃ ma o'jepa'ũm. Imẽnpuye ixe ayacat lamparina o'g̃usop jedinheiro kuda am. — Jedinheiro o'jokudada. Jedukã o'yabi'õg̃ jedinheiro kudadam. Tobuxik'ũm pima ikudadam mabuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","— Tobuxik puje, jebureyũ o'tomuwã ayacat, jeduk'a xeayũ dak. “Wuycokcog̃ cuy ajop wedinheiro otobuxik puye―isurũg̃at―cepa'ũm'ibit,” i'e'em ixe ayacat cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","— Icẽmãn õn e'em eywebe — io'e. — Deus ekawẽn tojotjot'ukayũ icokcok e'em pũg̃ ma itabun Deus kay buje―ikẽrẽat mujurũg̃rũg̃ap epere buje dak. Ixe ayacat cokcokap puxim icokcok e'em — io'e Jesus. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn adeayũ be. ");
INSERT INTO myu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","G̃ebuje Jesus wara'at ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","— Ag̃okatkat xepxep ipotpot kug̃ osodop. Ikitpit o'jekawẽn jebay be. “Bay,” io'e. “Ebubutei'in cuy eg̃ũm owebe obubuteim,” io'e. “E'ũap wiwim g̃u õn obubut pu am,” io'e jebay be — io'e Jesus. — Imẽnpuye cebay jebubutei o'g̃u'ẽ'ẽ jekpotpoyũ be―xepxepayũ be. Ade ma o'g̃ũm cebe ip — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","— Ibun'ũm pima ikitpit jebubut o'jat. O'g̃uxipan. Oibu'un jebay xe. O'jenapõn jebay xewi. Poxerewun. O'jẽm jebay duk'a bewi. O'ju wũyatka kay. Jay. Oajẽm. Ibo ka be te'e ma jebubut o'g̃u'ũm. ");
INSERT INTO myu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ũm. O'g̃u'ũm. Warẽmtag̃ ma o'g̃u'ũm soat — Jesus o'e. — Muba'at'ũmg̃u oeku. Ibun cĩcã oeku. Imẽnpuye ibo ka watwat irere jĩjã ip o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ikitpit tak ire jĩjã o'e ibubut oi'ũm puye — Jesus o'e. — Ikitpit o'ju ibo ka beat kay. O'jekapik ixe ag̃okatkat eju. Ixe ag̃okatkat ikitpit o'g̃uju jeõhõ muykõn ãm―dajebaro muykõn ãm — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","— Ikitpit dajebaro xat'a kay o'e jexat'am, reren cĩcã buye. Imẽnpit o'g̃ũm g̃u cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","— G̃ebuje ikitpit o'yag̃uysan. O'jewag̃uy. O'jekawẽn jewebe ma. — “Webay eju kapikpik'ukayũ ma soat kug̃ jexat kug̃,” io'e jewebe ma. “Õn pit ijoce oje'ũ repibun!” io'e jewebe ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","— “Jepin puk õn webay kay,” io'e jewebe ma. “Ocekawẽn webay eju,” io'e. “ ‘Bay,’ i juy oce cebe. ‘Ikẽrẽat kug̃ õn Deus xe, exe dak,’ i juy oce cebe,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“ ‘Õn ekpot. Imẽnpit ekpon g̃u juy oce g̃asũ bit, a'õmubuyxi'ũm'ũm ojeku buye. Eweju ocekapik acã dinheiro bu am,’ i juy oce webay be,” io'e ikitpit jewebe ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","— G̃ebuje o'jẽm wũyat ka bewi. O'jepit jebay kay. Cebay duk'a wi wũy bima, cebay bit ikitpit o'jojojo. Tadaybot cĩcã o'e jekpot ibubut kug̃'ũm puye. Itabotaidabotbot cĩcã o'e jekpot kay — io'e. — G̃ebuje cebay o'jedau jekpot kay. O'topabijuk. O'yakobot. O'yag̃obukõn jecokcokap kug̃. ");
INSERT INTO myu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ipot o'jekawẽn jebay eju. “Bay,” io'e. “Ikẽrẽat kug̃ õn Deus xe, exe dak, a'õmubuyxi'ũm'ũm ojeku buye,” io'e. “Ekpon g̃u oce g̃asũ bit. Eweju ocekapik acã,” io'e ipot jebay be — io'e Jesus. — “Ka'ũma!” io'e cebay bit. “Okpon ma ẽn soat em,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","— Cebay o'jekawẽn jebuywatwat'ukayũ be g̃ebuje bit. “Daosuw!” io'e. “Xipacat cuy og̃ũm okpot pe,” io'e cebay. “Iekabek cuy epetojot―xipacat,” io'e. “Epeg̃uõm cuy okpot pe,” io'e cebay. “Ibumũn cuy epeg̃uõm ibu be,” io'e. “Suiyuk cuy epeg̃uõm sui be,” io'e cebay. ");
INSERT INTO myu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Biopak'it'it cuy epejat―kuy ag̃uxep'iat,” io'e. “Epeyaoka juy,” io'e. “G̃a'a peta ag̃ug̃ẽ,” io'e. “G̃a'a acewemucokcog̃,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Tũybe okpot'ũm oe'ũ iãn cuk oce,” io'e. “G̃asũ bit wetaybit oce itabẽg̃ ma iam,” io'e. “Warẽmtag̃ ma oeku wũyat ka dag̃,” io'e. “G̃asũ bit cexe,” io'e cebay. “G̃a'a peta ag̃ug̃ẽ,” io'e. Icokcok cĩcã o'e ip — Jesus o'e. — Petatam o'e ip. Jeda'i'in o'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","— Tuk'a be jewemucokcog̃ ip pima, wara'at ipot tak jekat pe osunuy kapikpig̃―koapat. Oexe jebay duk'a be. Uk'a wi wuy'ũm pima, cedarukrekat'a a'õ o'ya'õdobuxik, da'i'iayũ a'õ dak. ");
INSERT INTO myu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jebay eju kapikpik'ukat o'tomuwã. “Ajo pẽnpẽn i'eayũ?” io'e iwag̃o cebe. ");
INSERT INTO myu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Petatam ip ekitpit oexe buye,” io'e kapikpik'ukat. “Ebay biopak'it'it o'yaokaat―kuy ag̃uxep'iat,” io'e. “O'yaokaat, xipan oexe buye,” io'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","— Imẽnpit iwag̃o itakoma o'e. Taobu'u jĩjã o'e uk'a be jeõm ãm jekitpit tobede am — Jesus o'e. — G̃ebuje cebay oajẽm jekpot kay akiju―koapat kay. “Eõm cuy,” io'e cebay jekpot pe―koapat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","— “Ap!” io'e. “Ade koato juk adi ocekapikpik cĩcã eweju,” io'e. “Puju og̃uy kũyjobit'ũm a'õ kay? Soat em cuk adi a'õ kay og̃uy,” io'e. “Imẽnpit cuk bode'it'it eyaokaat g̃u owebe peta mug̃ẽ ãm obureyũ beam,” io'e jebay be iwag̃o — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","— “Ite ekpot peam pit eyaoka,” io'e. “Soat edinheiro o'g̃u'ũm yapoyũ eju jepoapteim,” io'e jebay be — io'e Jesus. — “Cexe buje bit, ẽn peta mug̃ẽg̃ẽm!” io'e. “Biopak'it'it aokakam ẽn,” io'e iwag̃o — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","— “Tapu,” io'e. “Soat em ẽn oweju. Obubut ebubun je'e soat,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Tũybe okpot'ũm oe'ũ ekitpit'ũm iãn cuk oce,” io'e. “G̃asũ bit wetaybit oce itabẽg̃ ma iam. Warẽmtag̃ ma oeku wũyatka dag̃,” io'e. “G̃asũ bit xipan oexe,” io'e. “Imẽneju cedag̃ ma wuywebe peta mug̃ẽ ãm, wuymucokcok am tak,” cebay o'e — Jesus o'e. — Ikẽrẽat mujurũg̃rũg̃ap o'jepereiat jebay kay o'jepit'iat puxim — io'e Jesus. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn Fariseuyũ be, Moisés ekawẽn imutaybitbin'ukayũ be dak. ");
INSERT INTO myu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","G̃ebuje Jesus wara'at ekawẽn o'g̃uwẽn jeweju etaybitbinayũ be. — Ibubut adeat jedinheiro o'g̃ũm ag̃okatkat pe imuxipan am jewebeam — io'e. — “Warẽmtag̃ ebubut mu'ũmu'ũm edinheiro kukat,” io'e ibureyũ ibubut adeat pe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","— Imẽnpuye ibubut adeat jekaxero o'tomuwã. “ ‘Warẽmtag̃ ebubut mu'ũmu'ũm edinheiro kukat,’ i'e'em obureyũ owebe,” io'e ibubut adeat — io'e Jesus. — “Cũg̃ g̃u ẽn oubut kug̃,” io'e. “Imẽnpuye soat ip cewero oweju iaptup etupmubararak omutaybit am,” io'e. “G̃asũ bit ẽn kapig̃ g̃u oweju,” io'e — io'e Jesus. — “Wara'at ma ojomuy edieg̃,” io'e. Cekaxero o'jẽm. ");
INSERT INTO myu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","— G̃ebuje cekaxero o'jekawẽn jewebe ma. — “Apẽntak oce g̃asũ bit?” io'e jewebe ma. “Wekariwa o'e owebe ‘G̃asũ bit ẽn kapig̃ g̃u oweju,’ i,” io'e jewebe ma. “Iba'ore owebe kapik am kat pe, obaca'ũm puye,” io'e. “Osũsũn oce warara'acat xewi dinheiro ojuy am,” io'e jewebe ma. “Wetaybit apẽn oce iam,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Wekariwa og̃ug̃uykuku,” io'e jewebe ma. “Ixe eju õn kapikpig̃'ũm pima, warara'acayũ je'e owebe: ‘Eõm cuy oduk'a be eg̃uy am,’ i,” io'e jewebe ma cekaxero — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","— Imẽneju cekaxero ceweroap kug̃ayũ o'tomuwã. Pũg̃pũg̃pũg̃ ma ip o'tomuwã. Pũg̃pũg̃pũg̃ ma ip ceweju o'jekawẽn. — “Pebũrũ eweroap wekariwa eju?” io'e koap oajẽmiat pe. ");
INSERT INTO myu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","— “Ade jĩjã omuyku ixepti weweroap teida am―100 be bahi'uk,” io'e. — “Juku. Eweroaptup etupu,” io'e. “Ade g̃u omuyku bahi'uk ixeptim weweroap teida am―50 ma iam cuy eg̃ubararak tup pe,” io'e cekaxero koap oajẽmiat pe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","— “Pãm ẽn? Pebũrũ eweroap wekariwa eju?” io'e warara'acat pe. — “Ta'ade omuyku weweroap teida am trigoda―1000 be trigoda,” io'e. — “Juku. Eweroaptup etupu. “Ade g̃u omuyku weweroap teida am trigoda―800 be iam cuy eg̃ubararak,” cekaxero o'e cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","— Imẽnpuye kaxero itaybit cĩcãat osunuy jekariwa xe, imug̃uykuku'uk ma'g̃u — io'e Jesus. — “Etaybit cĩcã,” io'e cekariwa jekaxero be — Jesus o'e. — Itaybit cĩcã g̃u Deus ekawẽn kayayũ jebubut kug̃. Cekawẽn kay'ũmayũ bit itaybit cĩcã jebubut kug̃ — Jesus o'e. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","— Ceweroap teibubu'ukat ekukuap puxim g̃u juy epeku — io'e Jesus. — Eybubut'in cuy epeg̃ũm tadaybotbocayũ be iburem am ip. Cebe ip iũmũm pima, ixeyũ eybureyũ jeydobede kabi be eyexe buje. Soat em kabi be epesop — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","— Eyju cedag̃ yopĩcat kug̃ pima, cedag̃ ma yobog̃at tak epejukuk. Warẽmtag̃ yopĩcat kug̃ pima bit, warẽmtag̃ ma yobog̃at tak epejukuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","— Eyju warẽmtag̃ ijodiap kug̃ pima―dinheiro kug̃, Deus kabi beat je'g̃ũm g̃u eywebe―idip cĩcãat. ");
INSERT INTO myu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eyju warẽmtag̃ wara'acat pubut kug̃ pima, ka'ũma ma wara'at je'g̃ũm eywebe eybubun. ");
INSERT INTO myu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pũg̃'a be uk'a be bima, iba'ore ibuywatwat'ukat pe xepxepayũ beam kapik am. Kariwawayũ wara'at tag̃tag̃tag̃ e'em pima, itakoma kuka o'e pũg̃ kay jekariwa kay, wara'at jekariwa ikukpin cĩcã bima. Kũyjobit kuka o'e pũg̃ a'õ kay wara'at a'õ kay kũyjobit'ũm pima. Imẽnpuxim dinheiro kay jĩjã bima, Deus kay jĩjã g̃u kuka epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Soat Fariseuyũ iboap o'ya'ĩjojo. Ixeyũ Jesus o'jowaywayway dinheiro kay jĩjã ip puye. ");
INSERT INTO myu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","G̃ebuje Jesus o'jekawẽn Fariseuyũ eju. — “Cũg̃ ma oceju Deus xe,” i napa ma eyju e'em warara'acat pe — io'e. — Deus pit itaybit ajo kay eyju g̃ebum iam. Ijodiat xe xipat cĩcãat Deus xe xipat g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","— Moisés ekawẽn tag̃ jekuku'uk osodop ip kuyjeayũ, Deus ekawẽn muwẽnuwẽn'ukayũ dak. G̃uyjom pit João Batista o'e'e adeayũ be: “Deus soat kukukan je'e,” i. Deus ekawẽn muwẽnuwẽn'ukayũ imẽnpuxim imuwẽnuwẽn g̃asũ dak soat ip. G̃asũ adeayũ ibikuy Deus pe jekukan. ");
INSERT INTO myu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kabi i'ũm, i'pi dak. Deus pe wuyawẽwẽap ekawẽn pit i'ũm g̃u―pũg̃ em tak ka'ũma — io'e. — Soat em cedag̃ cĩcã wuywebe wuyeku am ixe ekawẽn tag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","— Ag̃okatkat jetayxi epere buje, wara'at pu am jetayxim, ikẽrẽat kug̃ Deus xe. Imẽnpuxim cepere'ibit eju jewebumũn puje, ikẽrẽat kug̃ Deus xe ag̃okatkat — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. — Ag̃okatkat jexat o'jo'o'o―iku jĩjãat o'jo'o'o — io'e. — Ibubut adeat osunuy. Ixat ku jĩjã osunuy. Jesay idip cĩcãat kug̃ osunuy. ");
INSERT INTO myu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tadaybocat tak oabik ixe ibubut adeat tuk'a exĩntabi be―ag̃okatkat. Xĩntabi xe abikbik'uk osunuy soat kabia. Lázaro i tadaybocat putet osunuy. Ade werowero kug̃ osunuy ixe Lázaro dag̃ soat tag̃. ");
INSERT INTO myu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oabik iboce ibinõmnõm kay itabiku buye, cemesa be jedudumat o pin puye. Imẽntak akuriceyũ oajẽm cewerowero kõnkõn ãm. ");
INSERT INTO myu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","— Lázaro'ũm e'ũ buje, Deus ekawẽn tojotjot'ukat ixe'ũm o'tujuu Abraão kay―Deus xeat kay. Iku jĩjãat o'om osunuy Abraão eju. Ixe ibubut adeat'ũm pit oe'ũ. Ag̃okatkayũ ixe'ũm o'jokot. ");
INSERT INTO myu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","— G̃ebuje ibubut ade osunuyiat Abraão o'jojojo wũy wi. Ipiat'ajojoap pewi o'jojojo. Lázaro dak o'jojojo Abraão xe. ");
INSERT INTO myu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","— “Ajot!” io'e ibubut ade tũibit Abraão be. “Etabotaidabotbon cuy eg̃uy okay,” io'e ya'õberen. “Lázaro juy eg̃udot okay idibi be ibu'abi muakõm ãm okõ mucuk am idibim,” io'e. “Ipiat'ajojom cĩcã õn daxa be,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","— “Ka'ũma, og̃uju g̃u,” io'e Abraão bit. “Etabẽg̃ pima, ade idip cĩcãat kug̃ cuk adi eg̃uy. Lázaro bit ikẽrẽat kug̃ cuk adi osunuy itabẽg̃ pima. Ẽn ma ecokcok cuk adi eg̃uy. Ixe bit tadaybot osunuy. G̃ebum cuy eg̃uy iboap kay. G̃asũ bit ixe ma icokcok. Ẽn pit ipiat'ajojom,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","— “Imẽntak katek omuy wuypidase. Itediacat pe iju ba'ore ig̃odi kay eykay. Ibodiacat pe dak tot pa'ore ijodi ocekay. Iba'ore cebe ip katek puye,” Abraão o'e. ");
INSERT INTO myu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","— “Ajot,” io'e Abraão be. “Eya'opicũg̃ cuy wa'õ kay! Lázaro juy eg̃uju webay duk'a kay, okitpitpiyũ kay,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","5be opop ip webay duk'a be. Eg̃uju ixeyu mukũyjo am ipiat'ajojoap pe tocap puxim,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","— “Ka'ũma,” io'e. “Og̃uju g̃u,” io'e Abraão. “Ekitpitpiyũ Moisés ekawẽntup kug̃, Deus ekawẽn muwẽnuwẽn'ukayũ emudupmubararaktup kug̃ tak,” io'e. “Kũyjobin cuy ekitpitpiyũ jeedop ibo dup a'õ kay,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","— “Ajot, ebu'um g̃u juy ixe muju am,” io'e. “Ce'ũat tomukadi waram o'jetait'iat co buje bit, ig̃uycũg̃ je'e ip ikẽrẽat kug̃ puye,” io'e. “Ikẽrẽat mujurũg̃rũg̃ap jepere ip,” io'e ibubut ade tũibit. ");
INSERT INTO myu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","— “Ka'ũma. Og̃uju g̃u,” Abraão o'e. “Ekitpitpiyũ kũyjobit'ũm Moisés a'õ kay. Kũyjobit'ũm tak ip Deus ekawẽn muwẽnuwẽn'ukayũ a'õ kay. Ce'ũ'ũayũ dopdopap pewiat tobuxik puje dak, waram g̃uto o'jetait'iat tobuxik puje, itabut g̃u je'e ip. Imẽnpuye og̃uju g̃u cekay ip,” Abraão o'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. — Adeayũ wuymubu'un wuyetabucap epere am — io'e. — Imẽnpit Deus ixeyũ g̃uju ipiat'ajojoap kay. ");
INSERT INTO myu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Warara'acat pe okay itabut'isuat mubu'un puje, ikẽrẽat kug̃ ip Deus xe. Imẽnpuye imutabut'ũm awap xipat kuka wuywebe ixeyũ aoka am―yag̃obu eju wita'a mukirik am yapoxiat'a mukirik am ticog̃ pe imuakõm ãm. Xipat g̃u wuye'ũ ãm. Ibodi ma xipat g̃u wuyju am ipiat'ajojoap kay. Ikẽrẽm g̃u juy epesop eyewewebe―idim acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","— Eybure be ikẽrẽat mujurũg̃ puje juy epeg̃ukũyjo. Ikẽrẽat kay ig̃uycũg̃ pima, g̃ebum g̃u juy epesop apẽn cuk adi ikẽrẽat o'g̃ujurũg̃ iap kay. ");
INSERT INTO myu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sete em aco'i ikẽrẽat mubapukpug̃ eywebe pũg̃ kabia. 7 em tak “Og̃uycũg̃ ikẽrẽat og̃ubapuk ewebe buye” i'e buje, juy g̃ebum g̃u epesop apẽn cuk adi ikẽrẽat o'g̃ujurũg̃rũg̃ iap kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","G̃ebuje cemumujuyũ o'jekawẽn jekukukat eju―Jesus eju. — Ocebuywan cuy ece big̃ ma ocetabut am Deus kay — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","— Deus kay eyetabutbũt pima, eyemuojuy je'g̃ũm eywebe — io'e. — “Ixe-ip cuy eyop'uk tãbu dag̃wi” i'e buje cebe, Deus yop'uk. “Eyoptaida juy ticõg̃ pe” i'e buje, Deus yoptaida — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","— Eya'õpurug̃ eybuywatwat'ukat kug̃―eykat kotkot'ukat kug̃―eyõhõ kukuk'ukat kug̃―ovelha kukuk'ukat kug̃ — io'e. — Jekapikap pewi yajẽm puje, “Xik'i buk. Ecebodoy,” i'ũmg̃u eyju e'em cebe. ");
INSERT INTO myu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Oxan cuy ejoda,” i'e'em eyju cebe. “Dao ma eg̃udot okay,” i dak. “Wekõn epere buje acã ecekõn,” i'e'em eyju cebe. ");
INSERT INTO myu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eybuywatwat'ukat eya'õ dag̃ kapikpig̃ pima, “Xipat cĩcã eyju,” i'ũmg̃u eyju e'em cebe. ");
INSERT INTO myu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Deus a'õ dag̃ jekukum pima, “Xipat cĩcã oceju,” i'ũmg̃u juy epe'e eyju dak. “Ocekukat a'õ dag̃ ocekuku,” i acã juy epe'e — Jesus o'e. Imẽn Jesus o'jekawẽn jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus o'ju Jerusalém ka kay. Kapkam o'e Galiléia eipi dag̃, Samaria eipi dag̃ tak. ");
INSERT INTO myu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","G̃ebuje 10 be ierepayũ Jesus o'topabijuk ag̃oka be yajẽm pima. Kacũg̃cũg̃'i osodop ip bosusu cewi. ");
INSERT INTO myu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","— Jesus! Kariwa! — io'e ip y'õberen. — Etabotaidabotbon cuy eg̃uy ocekay! — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ixeyũ jo buje, o'jekawẽn ceweju ip. — Epeju juy paĩ kay, ixe be eyjo am — io'e ierepayũ be. O'ju ip. Jeju buje ip o'je'ada ierep topibiyũ. Xipat o'e ip. ");
INSERT INTO myu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","G̃ebuje pũg̃ ma o'jepit Jesus kay ixeyũ'in je'adaap tobuxik puje. — Deus, ẽn xipat cĩcã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O'jẽg̃'aecõg̃cõg̃ Jesus topabe ya'õbuyxi jexe buye. — Xipat cĩcã ẽn, Kariwa — io'e. — Ẽn omu'ada — io'e ya'õberen. Samaria eipi beat osunuy ixe o'jepitiat. ");
INSERT INTO myu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","G̃ebuje Jesus o'jekawẽn ceweju. — Dez be g̃u du og̃u'ada? — io'e. — Pu warara'acayũ―9 beayũ? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","— 9 beayũ g̃u o'jepit “Xipat cĩcã ẽn omu'ada” i'e am Deus pe. Ite Samaria eipi beat acã o'jepit — io'e jexeayũ be. ");
INSERT INTO myu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","— E'ãy — Jesus o'e cẽg̃'aecõg̃cõg̃'ibit pe. — Õn emu'ada, etabut okay buye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Waram pima Fariseuyũ o'jekawẽn Jesus pe. — Pug̃ũn Deus soat kukukan je'e? — io'e ip. — Ixe soat kukukan pima, ibapuk g̃u je'e wuyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","— “Bomaku Deus soat kukukan,” i'ũmg̃u ace'e, “Jodiku Deus soat kukukan,” i'ũmg̃u dak — io'e. — Ibapuk g̃u warara'acat xe. Deus wuykukukan pima, wuywebe nuynuy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju―12 beayũ eju. — G̃uyjom ojo pin cĩcã epesop―soat wag̃o jo pin. “Ocebikuy jĩjã g̃axĩn ma soat wag̃o jajẽm ocekay,” i epe'e — io'e. — “Ocebikuy pũg̃ kabia ocexe am,” i epe'e — io'e Jesus. — Imẽnpit eyxe g̃u og̃uy — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","— Warara'acayũ napa ma je'e eywebe “Ak'i juy epe'e,” i, “Soat wag̃o o'jepit,” i, “Bomaku omuy,” i. “Soat wag̃o o'jepit,” i je'e ip eywebe. “Joceku omuy,” i napa ma je'e ip. Epeju g̃u juy okudadam ya'õbi ip. Eyetabun g̃u juy epesop ixeyũ a'õ kay — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","— Wepit puje, eyetaybit epesop―soat wag̃o epit puje — io'e. — Xiririkiat soat tag̃ kabiam. Jodiwiku kabiam, bodiwidaku. Soat ijodiat xiririkiat cocom. Imẽnpuxim soat ijodiat wepicap jojo. ");
INSERT INTO myu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Imẽnpit koam cuy ipiat osupi'ajo — io'e. — Ade g̃asũacat okay g̃u je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","— Wepit puje, ijodiat jeku apẽn Noé kabia be juk adi oekuku ip iap puxim. ");
INSERT INTO myu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jekõnkõn'uk osodop ip Noé itabẽg̃ pima, tikõnkõn'uk tak, jewebumũnmũn'uk tak. Ag̃'ũm pima, dao ma muba'atxiri oajẽm — io'e. — Kobexixi be Noé õm puje, muba'atxiri oajẽm soat kay ipi juacat kay. Soat ipi juacat o'g̃u'ũm. Oe'ũ'ũ ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","— Imẽnpuxim ip oekuku Ló itabẽg̃ pima — io'e. — Jekõnkõn'uk osodop ip, tikõnkõn'uk tak, jebubut pupu'uk tak, teidada'uk tak, taidada'uk tak, uk'a muymuy'uk tak. Sodoma ka watwat ag̃'ũm pima dao ma Deus daxa o'g̃udot i'g̃o ka kay. ");
INSERT INTO myu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma ka bewi Ló jẽm puje, Deus daxa isopat o'g̃udot kabi kadiwi daxa daxik tak. Soat ibo ka watwat'ũm'ũm o'g̃u'ũm — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","— Soat wag̃o õn. Wepit puje ka'ũma ma wepicatp wiwim je'e. Apẽn kuyje oekuku ip iap puxim jeku ip ijodiat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","— Wepit puje, jeduk'a be g̃u juy jeõm akijuat yabeat pu am — io'e. — Jepit g̃u juy jeduk'a kay jekat peat. ");
INSERT INTO myu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","G̃ebum cuy epesop Ló tayxi epit ojuyap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","— Oburemap tomuju eybu'u je'ũm pima, soat em ipiat'ajojoap pe epesop eye'ũ buje. Je'ũm eybu'u'ũm pima bit, soat em Deus xe epesop eye'ũ buje — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","— Wepicap exima be xepxepayũ ixet ip jeedop pũg̃ pe ma kama be. Deus pũg̃ ma tujowat jeweju. Wara'at pit suiwat. ");
INSERT INTO myu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Imẽnpuxim xepxep aoyũ tadedem ip jeedop. Deus pũg̃ ma tujowat jeweju. Wara'at pit suiwat. ");
INSERT INTO myu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Xepxep ag̃okatkat jekat pe kapikpig̃ ip je'e. Deus pũg̃ ma tujowat jeweju. Wara'at pit suiwat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","— Poma ip tujowat, Kariwa? — io'e ip Jesus pe. — Urupuyũ je'awerorom ig̃ẽmat kay i'o am. Imẽnpuxim Deus ja'jẽm ipiatpi'ajoan ikẽrẽat mujurũg̃rũg̃'ukayũ be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn jeweju etaybitbinayũ be soat em cuy epeyekawẽnwẽn Deus eju iam ixeyũ mutaybit am, eybu'un g̃u juy epesop Deus eju jekawẽn ãm iam tak. ");
INSERT INTO myu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Ibimãmãmãat ekawẽn coco'ukat osunuy ikabog̃atka be — io'e Jesus. — Tũybe Deus ya'õbuyxi g̃u iãn o'e. Warara'acat kug̃ tak ibuyxim g̃u osunuy — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","— Itop'ũm e'ũibit ade em ma ajẽmjẽm ixe ibimãmãmãat ekawẽn coco'ukat kay — io'e. — O'taobu'un g̃u cekay. — “Obuywan cuy ece okay itakomaat pe okaykayap puxim,” io'e'e itop'ũm e'ũibit — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","— Ade kabia ibimãmãmãat ekawẽn coco'ukat ibu'u osunuy itop'ũm e'ũibit puywan. G̃uyjom pit o'jekawẽn jewebe ma. “Deus ya'õbuyxi g̃u oxe,” io'e jewebe ma — io'e. — “Warara'acat tak ibuyxim g̃u ojukuk,” io'e jewebe ma — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","— “Imẽnpit ixe itop'ũm e'ũibit cuy osubuywan ixe be omu'ukpiceg̃ẽg̃ap puxim,” io'e jewebe ma — io'e. — “Ibuywan'ũm pima, soat em kuka oajẽmjẽm okay, omu'adaodao kuka,” io'e jewebe ma — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","— Ixe ibimãmãmãat ekawẽn coco'ukat itop'ũm e'ũibit o'subuywan jemu'ukceg̃ẽap puxim cũg̃ g̃u ma'g̃u jekukum — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","— Pãm Deus? Eyxe Deus ibu'u du jemunaẽhẽyũ buywan―soat kabia, soat ixima be dak jekay jewãwãwã'ukayũ buywan― “Obuywatwan cuy ece” i'e'e'ukayũ buywan? ");
INSERT INTO myu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibu'u g̃u ixeyũ buywan — io'e. — Soat em ag̃ cekay ip. G̃axĩn ma ixeyũ buywan — io'e. — Soat wag̃o õn. Ocepit cuy ijodi. Wepit puje Deus kay itabucayũ xe'e otobuxik? Tobuxik pin cĩcã oxe. Imẽnpuye juy eybu'un g̃u epesop Deus eju jekawẽn ãm — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","G̃ebuje Jesus wara'at ekawẽn o'g̃uwẽn jewexe xipacayũ be―warara'acat mubuyxi'ũm'ũmayũ be― “Oceju acã xipat Deus xe” i'e'e'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Xepxep ag̃okatkat o'ju Deus eju kawẽnwẽnap'a kay―yabog̃at'a kay — io'e. — Oajẽm ip Deus eju jekawẽn ãm. Pũg̃ Fariseu osunuy. Wara'at iecug̃ap peam dinheiro bubu'ukat osunuy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","— G̃ebuje Fariseu o'jekawẽn Deus eju. Jag̃epũg̃ ma cũg̃'i osunuy. Jewexe ya'õbuyxi jĩjã osunuy. Imẽn o'jekawẽn: — “Deus,” io'e. “Ocokcok oce warara'acat puxim g̃u õn etabixe buye,” io'e. “Ixeyũ ma itabikuku warara'acat pubut kay. Õn pit ka'ũma,” io'e. “Ixeyũ ma warẽmtag̃ ma jekukum. Õn pit ka'ũma,” io'e. “Ixeyũ ma jepopom warara'acat tayxi eju. Õn pit ka'ũma,” io'e. “Ig̃o buxim g̃u dak õn―iecug̃ap peam dinheiro bubu'ukat puxim g̃u,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Pũg̃ semana be xepxep kabia okpiwat ma õn jewemureren kawẽn ãm eweju,” io'e Deus pe. “Wedinheiro'in õn iũmũm ewebe,” io'e. “10 be ikug̃ pima, pũg̃ ma õn iũmũm ewebe,” io'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","— Iecug̃ap peam dinheiro bubu'ukat pit cũg̃'i osunuy wũy ma Fariseu wi. Isũsũn osunuy kabi kay jeak am ya'õbuyxi'ũm cexe buye. Yatoro ma o'jekawẽn Deus eju. O'jewekũmpiokaka jeg̃uycũg̃ap pibun, ikẽrẽat kug̃ puye — io'e. — “Deus,” io'e — io'e. — “Ikẽrẽat kug̃ õn,” io'e — io'e. — “Imẽnpuye etabotaidabotbon cuy eg̃uy okay,” io'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","— Icẽmãn õn e'em eywebe — Jesus o'e. — Jeduk'a be ixeyũ epit puje, Fariseu g̃u cũg̃ ma o'e Deus xe―iecug̃ap peam dinheiro bubu'ukat acã — io'e. — Eya'õbuyxian pin cĩcã bima, eya'õbuyxian g̃u epesop Deus xe. Eya'õbuyxian pin'ũm pima bit, eya'õbuyxian epesop cexe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","G̃ebuje Jesus eju etaybitbinayũ warara'acat o'g̃ukorẽm. O'g̃ukorẽm ip Jesus kay mucayan bekitkit tojotjon puye. ");
INSERT INTO myu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Imẽnpit: — Ebekitkit cuy epetojot okay — io'e Jesus cebayũ be ip. G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju―12 beayũ eju. — Bekitkit mubu'un g̃u juy okay imudot am — io'e. — “Epeju g̃u juy Jesus kay,” i'ũmg̃u juy epe'e cebe ip. Deus ixeyũ buximayũ kukukan je'e soat kukukan pima. ");
INSERT INTO myu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Icẽmãn õn e'em eywebe. Bekitkit ibu'u g̃u Deus pe jekukan. Imẽnpuxim Deus pe eykukan eybu'u'ũm pima, cexe epesop ixe soat kukukan pima — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","G̃ebuje ag̃oka kukat oajẽm Jesus kay. O'jekawẽn Jesus eju. — Tapu — io'e. — Ẽn xipat, cedag̃ ocemutaybitbin puye — io'e. — Apẽntak oce soat em Deus xe onũy ãm? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","— Apẽnpuye dak ẽn e'em owebe “Ẽn xipat,” i? — Jesus o'e. — Ka'ũmg̃u xipacat―Deus acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","— Etaybit Deus pe wuyawẽwẽap ekawẽn — io'e. — “Warara'acat tayxi kaykay g̃u juy epesop,” io'e Deus. “Warara'acat epeyaoka g̃u juy,” i dak. “Eyetabikum g̃u juy warara'acat pubut kay,” i dak. “Napa g̃u juy epe'e,” i dak. “Ibuyxim cuy eyebay epejukuk, eyxi dak,” i dak o'e Deus wuywebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","— Soat tag̃ ibiat ekawẽn tag̃ cuk adi ojekuku bekin piman ma — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iboap co buje, Jesus waram o'jekawẽn cebe. — Pũg̃ ma buk omuy ewebe i'e am — io'e. — Soat ebubut cuy eteida dinheiro bu am. Dinheiro juy eg̃ũm ikug̃'ũmayũ be — io'e. — Iũm puje, ebubut ade ece'e kabi be — io'e. — G̃ebuje juy ejot. Oweju juy ejeku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ig̃uycũg̃ cĩcã o'e iboap co buje, ade jĩjã ibubut puye. Tacup osunuy. Ibu'u o'e jebubut ũm tadaybotbocayũ be. Xerewun. O'jẽm Jesus xewi. ");
INSERT INTO myu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ag̃oka kukat cemap co buje, Jesus o'jekawẽn jeweju etaybitbinayũ eju―ig̃uycũg̃at cẽmap co buje. — Iba'ore jĩjã ibubut adeat Deus pe jekukan — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","— Iba'ore camelo be ikap am awi daobi'atog̃. Imẽnpuxim iba'ore jĩjã ma ibubut adeat Deus pe jekukan, ibu'u ip puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","— Abu be dak kuka o'e taxijo but? — io'e o'ya'ĩjojo'iayũ. ");
INSERT INTO myu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","— Ijodiat pe jewedaxijo ba'ore — io'e. — Deus pe bit iba'ore g̃u soat ma — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","G̃ebuje Pedro o'jekawẽn Jesus eju. — Oceju bit soat ocesuiwat eweju am — Pedro o'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","— Icẽmãn õn e'em eywebe — Jesus o'e. — Deus bikuyap tag̃ eybadip iwat puje, eywebe epesuiwat podi ma epejat — io'e. — Eyduk'a beayũ aco'i epesuiwat, eytayxi dak, eywag̃o dak, eyebay dak eyxi dak, eyebekitkit tak. ");
INSERT INTO myu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Deus bikuyap tag̃ iwat puje, eywebe epesuiwat podi ma epejat — io'e. — Eyetait pima Deus xipacat je'g̃ũm eywebe. Eye'ũ buje dak waram g̃uto epeyetait — io'e. — Soat em Deus xe epesop — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Adeayũ parakpewi Jesus 12 beayũ o'tujowat. O'jekawẽn ceweju ip. — Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e cebe ip. — Jerusalém ka kay aju — io'e. — Soat wag̃o õn. Kuyjeayũ emudupmubararaktup ekawẽn tag̃ adeayũ warẽmtag̃ ma ip okuk — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","— Ixeyũ oũm Judeu'ũmayũ be okay itakomaayũ be. Owaywayway ip je'e. Warẽmtag̃ ma ip okuk. Omuxixuxi ip. Omupokupok ip. ");
INSERT INTO myu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oaoka ip. Imẽnpit xepxep xet kap puje, waram g̃uto ocetait — io'e Jesus cebe ip―12 beayũ be. ");
INSERT INTO myu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Imẽnpit 12 beayũ xe cekawẽn pa'arẽm osunuy Jesus ekawẽn. — Apẽnape ite e'em? — io'e ip jewewebe. — Cekawẽn pa'arẽm ocewebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó ka be Jesus ajẽm pima, ita'ũmat dinheiro o'joojuy kapkapayũ xewi. ");
INSERT INTO myu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","E bitako dag̃ xik'i bima kapkapayũ daobiwẽg̃ cocom ixe ita'ũmat. — Apẽnpuye eyju kapkam ijoma? — io'e kapkapayũ be. ");
INSERT INTO myu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","— Jesus ijoma kapkam puye―Nazaré ka bewiat — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","G̃ebuje ita'ũmat o'jewãwã Jesus kay. — Jesus! — io'e. — Davi naxeg̃ebit ẽn! — io'e. — Etabotaidabotbon cuy eg̃uy okay — io'e ya'õberen. ");
INSERT INTO myu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Imẽnpuye kapkapayũ ita'ũmat o'g̃ukorẽm. — Ecemũg̃ cuy! — io'e ip. Imẽnpit big̃ ma o'jewãwã ya'õberen. — Jesus! — io'e ma'g̃uto. — Davi naxeg̃ebit ẽn! Etabotaidabotbon cuy eg̃uy okay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus oajẽm ita'ũmat kay. O'jecũ e bidase. — Ixe ita'ũmat epetojot okay — io'e jexeacat pe. O'tojot. O'jekawẽn cebe, yajẽm puje. ");
INSERT INTO myu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Ajo-kay ẽn oxewi? — io'e―Jesus o'e. — Wetadam ece — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","— Jetada õn — io'e Jesus. — Etate ece'e Deus kay etabut puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesus iboap e isum ma o'jewetada. Jecoatcoan o'e. Ixe dak o'ju Jesus eju. — Ka'ũmg̃u ejo'iat xipacat — io'e Deus pe. Imẽneju soat o'jojojo'iayũ: — Ka'ũmg̃u ejo'iat xipacat — io'e ip Deus pe. ");
INSERT INTO myu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus oajẽm ikabog̃atka kay―Jericó ka kay. Kapkam oeku ibo ka dag̃. ");
INSERT INTO myu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ibo ka be ag̃okatkat osunuy. Ibutet Zaqueu i osunuy. Iecug̃ap peam dinheiro bubu'ukat osunuy. Ibubut adeat osunuy. ");
INSERT INTO myu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ixe dak Jesus co ojuy o'e. Imẽnpit Jesus co ba'ore osunuy taoapĩn puye. Ijo ba'ore osunuy adeayũ Jesus akokoreren oekuku buye. ");
INSERT INTO myu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Imẽnpuye Zaqueu o'jedau Jesus topabe. Jesus co am o'jeu figueira'ip eju. O'jeu ijop'ip tẽg̃ ma je'kap iam itaybit puye. ");
INSERT INTO myu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ibo'ip tiotpe yajẽm puje, Jesus o'jeapũn Zaqueu kay. — Zaqueu — io'e. — Ekop cuy! — io'e. — Daosuw! — io'e. — Eduk'a be õn cum — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueu dao ma o'kop ip ejuwi. Icokcok o'e Jesus tuk'a be cu ojuy buye. — Ejot cuy oduk'a be — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iboap o'jojojo'iayũ Jesus o'jomuymuy ip jeweweju. — Jesus o'ju Zaqueu duk'a be — io'e ip jewewebe. — Ixe Zaqueu ikẽrẽat mujurũg̃rũg̃xi! — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","G̃ebuje Zaqueu o'jekawẽn Jesus eju jeduk'a be. — Kariwa — io'e. — A'õpicũg̃ cuy eg̃uy. Ikẽrẽat cuk adi og̃ujurũg̃rũg̃iap cuy ocepere. Obubut'in og̃ũm ikug̃'ũmayũ be. Ipidase og̃ũm cebe ip — io'e. — Adeayũ mug̃uykukukum cuk adi og̃uy dinheirom — io'e. — Ebadipdip dinheiro juy og̃ũm pũg̃ dinheiro ojat'iat pe soat pe — io'e Zaqueu. ");
INSERT INTO myu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","— Zaqueu, Deus edaxijo g̃asũ bit — io'e Jesus. — Xipat ixe be edaxijo am ẽn Abraão naxeg̃ebit puye. ");
INSERT INTO myu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Soat wag̃o õn. Ijodi ojot ikẽrẽat mujurũg̃rũg̃'ukat kudada am. Ixeyũ daxijo am ojot — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Adeayũ be iboap co buje, Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. Jerusalém ka be Jesus oajẽm pin. Tũybe g̃axĩn ma Deus soat kukukan je'e iãn o'e ip adeayũ. Imẽnpuye iboap ekawẽn o'g̃uwẽn Jesus. ");
INSERT INTO myu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","— Kariwa yobog̃at cu ojuy wũyatka kay — io'e Jesus. — Wũyatka watwat ixe kariwa yobog̃at muy ojuy jekukan. ");
INSERT INTO myu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iju'ũm pima 10 beayũ o'g̃udot jewekay jebuywatwat'ukayũ. Pũg̃pũg̃pũg̃ ma o'g̃ũm soat pe dinheiro isurũg̃at. Soat ip pũg̃pũg̃pũg̃ o'e ikug̃. “Õn ijoce'ũm pima, epeyekapik ijop kug̃ dinheiro kug̃ wara'at pu am―dinheiro bu am,” io'e ixe kariwa cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Imẽnpit cebekitkityũ'in itakoma osodop ip jekariwa yobog̃at kay. Imẽnpuye itakomaayũ jebureyũ o'g̃uju jekariwa nomuju jekawẽn ãm ceweju. E dag̃ ip o'e cebe: “Ekay g̃u oceju,” i. “Ocekukat pin g̃u ewebe,” io'e ip cebe e dag̃ — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","— G̃ebuje o'ju wũyat ka kay — io'e. — Wũyatka be bima ibo ka watwat ixe kariwa yobog̃at o'jomuy jekukan. Ade ka kukan ip o'jomuy. O'jẽm wũyatka bewi. Jay. Oajẽm g̃uto jeka be — io'e. — Jebuywatwat'ukayũ o'tomuwã jewekay. 10 be dinheiro o'g̃ũmg̃ũm cebe'iayũ o'tomuwã. Itaybit pin o'e pebũrũ paxi ip dinheiro o'jat wara'at iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","— G̃ebuje ibuywatwat'ukat oajẽm jekariwa kay — io'e. — “Kariwa,” io'e. “Pũg̃ dinheiro eg̃ũm owebe isurũg̃at. 10 be ojat wara'at,” io'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","— “Xipat ẽn,” io'e. “Xipan cĩcã juk adi ecekapik,” io'e. “Xipan cuk adi ecekapik pũg̃at kug̃ ewebe og̃ũm'iat kug̃―dinheiro kug̃―yopĩcat kug̃,” io'e. “Imẽnpuye 10 be ag̃oka kukan ecesũy,” io'e kariwa cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","— Ibocewi wara'at oajẽm ibuywatwat'ukat — io'e. — “Kariwa,” io'e. “Ixaat kug̃ pima, 5 be ojat wara'at,” io'e wara'acat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","— “5 be ikabog̃atka kukan ecesũy―wũyat eipi ka kukan,” io'e kariwa cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","— Ibocewi wara'at oajẽm ibuywatwat'ukat — io'e. — “Juku, kariwa,” io'e. “Edinheirom. Pũg̃ ma,” io'e. “Ocekapik g̃u wara'at pu am. Og̃uekabek pit pag̃õm,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Oparara ebuxim, ẽn warara'acat mudadaybotbon puye,” io'e. “Ẽn ibubum warara'acat xewi iũmũm g̃u ma'g̃u,” io'e. “Ẽn ibubum cexewi ip taidadam g̃u ma'g̃u,” io'e ibuywatwat'ukat — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","— “Xipat'ũm cĩcã ẽn,” io'e kariwa. “Ajo pẽg̃ap g̃u ẽn?” kariwa o'e ya'õberen jebuywatwat'ukat pe. “ ‘Ocekapik g̃u wara'at pu am,’ i ẽn e'em owebe. ‘Og̃uekabek pag̃õm,’ i ẽn e'em owebe,” io'e. ‘Ẽn warara'acat mudadaybotbon,’ i ẽn e'em owebe,” io'e. ‘Ẽn ibubum warara'acat xewi iũmũm g̃u ma'g̃u,’ i ẽn e'em owebe,” io'e. “ ‘Ẽn ibubum cexewi ip taidadam g̃u ma'g̃u,’ i ẽn e'em owebe,” io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Apẽnpuye dak dinheiro eg̃ũm g̃u dinheiro muxipanpan'ukat pe ixe be wara'at pu am? Ixe be iũm puje, wara'at kug̃ kajuk ece'e dinheiro kug̃,” io'e kariwa — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","— “Pũg̃ ma ikug̃at pui bewi juy cedinheiro epejat,” io'e kariwa jexeayũ be. 10 be ikug̃at pe juy epeg̃ũm,” io'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","— “Kariwa, imẽn g̃u bit,” io'e ip. “Teku kuy 10 be ikug̃!” io'e ip kariwa be. ");
INSERT INTO myu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","— “Imẽn ma õn e'em,” io'e kariwa bit. “Adeat kukat pe wara'at je'g̃ũm ip. Ade'ũmat kukat xewi bit je'jat ip,” io'e kariwa — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","— “Okay itakomaayũ juy epetojot ijoce,” io'e. “ ‘Ocekukat pin g̃u ewebe,’ i juk o'e ip owebe,” io'e. “Ixeyũ juy epetojot ijoce,” io'e. “Ixeyũ ma epeyaoka wetabixe,” io'e kariwa — Jesus o'e. Imẽn Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus iboap e buje, o'ju Jerusalém ka kay. Jeweju etaybitbinayũ wap o'ju Jesus. ");
INSERT INTO myu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oajẽm ip Betfagé ka xe, Betânia ka xe dak, co'a xe. Co'a butet Oliveira dip'a i osunuy. Ajẽm pima xepxepayũ o'g̃uju wara'atka be jeweju etaybitbinayũ. ");
INSERT INTO myu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","— Epeju juy ag̃oka kay―wuywapatka kay — io'e xepxepayũ be. — Iboce jumento'it'it epetobuxik―ikirikat―yakpi jeje'ibit'ũmat. Ixe jumento'it'it epeg̃uwekap — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","— Ixe juy etojot ijoce — io'e. — “Apẽnpuye dak eyju jumento'it'it muwekapkam?” i'e buje ip, “Ocekariwa cekay, ikug̃'ũm puye,” i juy epe'e cebe — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","O'ju ip xepxepayũ. Oajẽm ip jumento'it'it kay. O'tobuxik ip apẽn cuk Jesus o'e iap tag̃. ");
INSERT INTO myu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Imuwekapkam pima õhõ iwat o'jekawẽn cebe ip. — Apẽnpuye eyju jumento'it'it muwekapkam? — io'e õhõ iwat. ");
INSERT INTO myu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","— Ocekariwa cekay, ikug̃'ũm puye — io'e xepxepayũ. — Ha'a — io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","O'tujowat ip Jesus kay. Oajẽm. Jumento'it'it akpi jeje jeekabek o'jomõg̃ ip. Ceweju etaybitbinayũ Jesus o'g̃uju jumento'it'it akpi jeje―iekabek ceje. ");
INSERT INTO myu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jerusalém ka xe Jesus ajẽm pima, adeayũ jeekabek o'g̃upayapaya ip Jesus wap e dag̃ ya'õbuyxi cexe ip puye. ");
INSERT INTO myu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesus o'tobede jĩjã ip g̃ebuje. Icokcok cĩcã ip o'e Oliveira dip'a pẽnpẽn tag̃ kopkom pima―soat cebekitkit. O'jewãwã ip Jesus kay. — Deus xipat cĩcã — io'e ip ya'õberen. — Teku ka'ũma buk ajojojoiap mubapukpug̃ jekukum — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","— Wuykukukat omuyku Deus a'õbi — io'e ip jewewebe. — Ka'ũma ma ixe jo'iat idipat! — io'e ip. — Kaba'ũm jeedop ip kabi watwat — io'e ip. — Deus cuy xipacat je'g̃ũm cebe — io'e ip Jesus cocom pima. ");
INSERT INTO myu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Imẽneju Fariseuyũ o'jewãwã Jesus pe adeayũ parakpewi. — Tapu — io'e ip. — “Epeyemũg̃ cuy,” i juy ece eweju etaybitbinayũ be, warẽmtag̃ ma ip e'em puye — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","— Iteyũ mũg̃'i bima, wita'a ma kuka o'jeaewãwã odobede am — io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jajẽm puje, Jerusalém ka kay o'jeak Jesus. O'tõn ika jojom pima ade ika watwat kũyjobit'ũm puye. O'jekawẽn ika jojom pima. ");
INSERT INTO myu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","— Jerusalém ka watwat, Deus omudot eydaxijoap ojuy kaba'ũm eydop am — io'e Jesus. — Obikuy jĩjã g̃asũ ma eymutaybit am iboam. Eyju bit eybu'u ixe be eydaxijo am. Imẽnpuye wekawẽn ba'arẽm eyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","— Imẽnpuye g̃uyjom eykay itakomaayũ korara jo'iat jomuy ip eyka koreren jeõm ãm eyaokaka am — io'e. — Ka'wi mug̃ẽg̃ẽ ip jomuy. Jeymukoreren ip eyenapõnap puxixim. Jeyakodip ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","— Jeymu'ũm ip. Soat eyka watwat g̃u'ũm ip. Ka'ũma ma jepoyat. Ikabog̃atka sukamu'ũm cĩcã ip. Wita'a yamudu ip―soat'a uk'a mug̃ẽg̃ẽap'a. Pũg̃'a iwat g̃u ip wara'at'a jeje. Deus omudot eydaxijo am. Eyju bit okay g̃u. G̃asũ ocedaxijo pin Deus iam eyetaybit g̃u. Imẽnpuye soat ip jeymu'ũm. Pũg̃ tak epeyepoyat g̃u. Soat ip jeymu'ũm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus oajẽm Deus eju kawẽnwẽnap'a kay―yabog̃at'a kay. Ya be oõm. Ag̃okatkayũ o'g̃ujẽm uk'a ekorara bewi―õhõ deidada'ukayũ. ");
INSERT INTO myu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","— Imẽn e'em Deus ekawẽntup: “Oduk'a bit cuy yanuy Deus eju kawẽnwẽnap'am” i — io'e cebe ip. — Eyju bit epeyamuwexat ibukurukayũ munẽmap'am — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesus adeayũ mutaybitbin osunuy soat kabia Deus eju kawẽnwẽnap'a be―yabog̃at'a be. G̃ebuje paĩyũ kukukayũ Jesus aoka ojuy oeku ip―Moisés ekawẽn imutaybitbin'ukayũ dak, warara'acayũ dak―Judeuyũ kukukayũ. Jesus aoka ojuy osodop ixeyũ ma. ");
INSERT INTO myu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Adeayũ bit Jesus ekawẽn kay jĩjã osodop. Imẽnpuye Jesus aoka ba'ore o'e cekay'ũmayũ be. ");
INSERT INTO myu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesus imutaybitbin pima paĩyũ kukukayũ oajẽm cekay. Oajẽm ip Jesus kawẽn idipat muwẽnuwẽn pima Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Oajẽm ip Moisés ekawẽn imutaybitbin'ukayũ eju, Judeuyũ kukukayũ eju dak. ");
INSERT INTO myu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Soat ip o'jekawẽn Jesus eju. — Abu-a'õbi juk ija'a beayũ eg̃ujẽm? — io'e ip. — Abu-a'õbi ẽn jekukum? — io'e ip. — Iboam cuy ocemukũyjom ece — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","— Eyju ma omukũyjom cuy epe'e — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","— Abu-a'õbi g̃u juk João ijodiat mubatisasan oeku? Deus a'õbi du? Ijodiat a'õbi g̃u xe'e? Iboam cuy epe'e omukũyjom — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","G̃ebuje o'jewa'õxikxik ip jeweweju. — Apẽn xe'e acejede? — io'e ip. — “Deus a'õbi” i'e buje cebe, “Apẽnpuye juk eyetabut g̃u João kay?” i je'e Jesus wuywebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","— “Ijodiat a'õbi,” i'e buje bit cebe, adeayũ wuyabug̃bug̃ je'e wita'am, ixeyũ xe João Deus a'õbi juk adi oeku buye — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Imẽnpuye: — Ocetaybit g̃u abu-a'õbi juk João ijodiat mubatisasan oeku iam — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","— Õn tak jeymukũyjo g̃u abu-a'õbi õn jekukum iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn adeayũ mukũyjo am Deus a'õbi õn jekukum iam. — Ag̃okatkat ibune'ĩcatpune o'taida uvabune — io'e Jesus. — Ixe uvadip iwat ag̃okatkayũ o'jomuy tip wiwi an. “Wekadaidip cuy epetipwiwi,” io'e cebe ip. O'ju wara'at ka be ixeyũ ag̃okatkayũ tip wiwim pima. Ibun cĩcã osunuy wara'at ka be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","— Yaopap ekaxi bima tip iwat uva'a kay o'e. Jebuywatwat'ukat o'tomuwã. — “Eju juy wekadaidip kay,” io'e. “Uva'a juy eyadojot oxat'am,” io'e. Imẽn jebuywatwat'ukat o'g̃uju uva'a bum. O'jẽm. Jay. Oajẽm uvadip pe. Imẽnpit tip wiwi'ukayũ ibuywatwat'ukat o'yamupãupã tip iwat buywatwat'ukat. O'g̃ujẽm ip tip pewi. Ibui pug̃ ma o'g̃ujẽm ip. Pũg̃'a dak ip o'yaũm g̃u cebe. Jebui pug̃ ma o'jepit tip iwat pe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","— Ibocewi tip iwat wara'at o'g̃uju uva'a kay jebuywatwat'ukat. — “Eju juy uvadip kay wekadaidip kay,” io'e wara'at pe. “Uva'a juy eyadojot oxat'am,” io'e. — Xerewun. O'jẽm ibuywatwat'ukat. Jay. Oajẽm uvadip pe. Imẽnpit ixe wara'acat tak o'g̃ujẽm ip. Ixe dak ip o'yaokaka jĩjã. Warẽmtag̃ ma o'jukuk ip. Ibui pug̃ ma o'g̃ujẽm ip. Pũg̃'a dak ip o'yaũm g̃u cebe. Jebui pug̃ ma o'jepit kadai iwat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","— Ibocewi wara'at o'g̃uju uva'a kay jebuywatwat'ukat. Ixe wara'acat oajẽm tip pe. Ixe dak ip o'yamupãupã. Ixe dak o'g̃ujẽm ip tip pewi. Jebui pug̃ ma o'jepit tip iwat pe — io'e. — Imẽn kadaidip wiwi'ukayũ ebapũg̃ayũ o'g̃ujẽm tip pewi. Tip iwat buywatwat'ukayũ o'g̃ujẽm ip. Ebapũg̃ em ip ibui pug̃ ma o'g̃uypit kadaidip iwat kay. ");
INSERT INTO myu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","— Imẽneju tip iwat o'jekawẽn jewebe ma. — “Apẽn paxi oce?” io'e jewebe ma. Okpot cuy og̃uju tip kay yabum,” io'e. “Oxe ikukpin cĩcãat cuy og̃uju. Ibuyxim ma ip okpot jukuk,” io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","— Kadaidip tip iwat jekpot o'g̃uju tip kay. Xerewun. O'jẽm. Jay. Oajẽm tip pe. Imẽnpit ipot co buje, tip wiwi'ukayũ o'jekawẽn jewewebe. — “G̃a'a tip iwat ipot ayaoka,” io'e ip jewewebe. “Cebay e'ũ buje, teku soat je'jat jebay'ũm pubut,” io'e ip. “Tip kukan je'e,” io'e ip. “G̃a'a ayaoka. Wuyju ma ibubut ajat. Wuyju ma tip kukan acesop,” io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","— Tip iwat ipot o'tujujẽm ip tip pewi. Kacũg̃ kay o'tujowat ip. Ipot'ũm o'yaoka ip — io'e Jesus imutaybitbin. — Apẽn je'e tip iwat jekpot'ũm o'yaoka'iayũ be? — io'e Jesus ja'ĩjojomayũ be. ");
INSERT INTO myu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","— Og̃uwẽn eywebe. Kadaidip iwat je'ju tip wiwi'ukayũ kay. Yaoka ip. Warara'acayũ jomuy ixeyũ'ũm'ũm tieg̃ jekadaidip wiwi an — io'e. — Cẽm tu? — io'e Jesus ekawẽn cocoayũ. — Imẽn xe'e je'e? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","— Icẽmãn — io'e Jesus. — Omuwẽg̃aptup imẽn e'em: “Ite'a wita'a xipat g̃u,” io'e uk'a muymuy'ukayũ jewewebe, i. Ite'a o'yaxik ip, i. Imẽnpit o'yaxikiat'a xipat cĩcãat'am o'e, i. Wara'at'a muycemap'am o'e ce'aeduap puxim, i. Imẽn e'em Deus ekawẽntup―omuwẽg̃aptup — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","— Ig̃o'a jejewi je'at puje, o'jewenõmnõmnõm kuka. Ijodiat ceje ig̃o'a at puje, tõm ã kuka o'e ip — io'e. Iboap ekawẽn o'g̃uwẽn Deus a'õbi õn jekukum iam ixeyũ mukũyjoap ojuy. ");
INSERT INTO myu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","O'ya'ĩjojo'iayũ oitakomãn Jesus kay ibo ekawẽn cocom puye―Moisés ekawẽn imutaybitbin'ukayũ, paĩyũ kukukayũ dak. — Jesus ijop ekawẽn o'g̃uwẽn wuymukorẽm ãm — io'e ip jewewebe. Imẽnpuye Jesus pu ojuy o'e ip. Imẽnpit iparara o'e ip adeayũ buxim. ");
INSERT INTO myu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ixeyũ dak dinheiro o'g̃ũm ag̃okatkayũ be Jesus ekawẽn puyxijo am. — Jewexe juy Jesus ekawẽn kay epeku — io'e ip. — Ixe dobatban cuy epeku — io'e ip cebe. — Ixe ekawẽn puyxijojom cuy epeku — io'e ip. — Warẽmtag̃ ma aco'i jekawẽn — io'e ip. — Warẽmtag̃ ma cekawẽn puje, iecug̃ap kay juy atujowat — io'e ip. — Iecug̃ap a'õbi acã yaoka but wuywebe — io'e ip. O'ju ip Jesus kay. Jay. Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","— Tapu — io'e ip. — Ocetaybit cedag̃ ma ẽn kawẽnwẽn iam. Cedag̃ ma ẽn ocemutaybitbin tak — io'e ip cebe. — Kocũg̃ kadi kay g̃u ẽn ag̃―badiat kay acã — io'e ip. Imẽn o'e ip ya'ĩjojoayũ mug̃uykuku ojuy Jesus kay oceju iam. ");
INSERT INTO myu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","— Cedag̃ tu exe wuywebe dinheiro ũm ãm soat xe ya'õbuyxiat pe―wuyeipi kukat pe―César be? Aceg̃ũm g̃u xe'e? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesus pit o'e jewebe ma: — Iteyũ wekawẽn puyxijo ojuy — i. ");
INSERT INTO myu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Dinheiro isurũg̃at cuy epetojot okay — io'e Jesus cebe ip―jedobatbanayũ be―jekawẽn puyxijojo ojuyacat pe. — Juku — io'e ip. O'g̃ubapuk cebe. — Abu-biõg̃buk ija cebe? — io'e. — Abu-butet tak? — io'e. — César biõg̃buk―soat xe ya'õbuyxiat biõg̃buk — io'e ip. — Ixe butet tak opop cebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","— César emukaypin cuy epeg̃ũm cebe — io'e. — Deus emukaypin pit cuy epeg̃ũm cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesus ekawẽn puyxijo ba'ore o'e cebe ip soat etabun. Cede ba'ore o'e ip. Mũg̃ ma osodop ip. — Itaybit cĩcã teku jede am — io'e ip. — Ya'õmuypit pa'ore wuywebe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceuyũ oajẽm Jesus kay. Saduceuyũ Judeuyũ dak osodop ip. Tũybe wuye'ũ buje acejetait'ũma waram iãn o'e ip. O'jekawẽn ip Jesus eju. ");
INSERT INTO myu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Tapu — io'e ip. — Moisés Deus pe wuyawẽwẽaptup cuk adi o'tupmubararak ocewebeaptum — io'e ip. — Imẽn e'em ibodup: Ag̃okatkat wag̃o'ũm e'ũ buje, ikitpit puk cuy jewebumũn jewago'ũm tayxibuk eju itayxibuk i'it'et'ũm pima, i. Jewebumũn cuy imu'ukreg̃ am, bekicat muaypan am jewag̃o'ũm tieg̃, i. ");
INSERT INTO myu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Imẽn Moisés o'tupmubararak — io'e ip. G̃ebuje 7 beayũ o'g̃uwẽn ip Jesus pe―ikitpitpiyũ. — Koapat o'jewebumũn. Ixe koapat'ũm oe'ũ jekpotpet'ũm pima ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","— G̃ebuje jewag̃o'ũm tomujuat o'jewebumũn jewag̃o'ũm tayxibuk eju. Ixe tomujuat'ũm oe'ũ jekpotpet'ũm pima ma'g̃uto — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","— Ibocewi warara'acayũ o'jewebumũnmũn jewag̃o'ũm tayxibuk eju 5 beayũ―koapat tayxibuk eju―pũg̃ eju ma. Soat ip o'jewebumũnmũn ceweju. Jekpotpet'ũm pima ma oe'ũ'ũ ip soat ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","— Soat ip ce'ũ buje, ayacat'ũm tak oe'ũ. ");
INSERT INTO myu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Soat o'jewebumũnmũn ceweju 7 beayũ. Imẽneju waram wuyetait puje, abu-tayxim xe'e je'e? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","G̃ebuje Jesus o'jekawẽn Saduceuyũ be. — Ijodiat ma jewebumũnmũn — io'e. — Waram o'jetait'iayũ bit jewebumũnmũn g̃u. Deus ixeyũ o'g̃utait ce'ũap tomukadi. Jewebumũnmũn g̃u ip. ");
INSERT INTO myu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Waram o'jetait'iayũ waram g̃u je'ũ, Deus ekawẽn tojotjot'ukat puxim ip puye. Deus ipotpoyũ ip, Deus ixeyũ o'g̃utait ce'ũap tomukadi buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","— Napa ma eyju e'em “Waram acejetait g̃u,” i. Waram epeyetait — io'e. — Waram acejetait wuye'ũ buje iam cuk adi o'g̃utaybitbin Moisés — io'e. — Ixe Moisés tipsopat ekawẽntup o'tupmubararak. “Deus Abraão kukukat, Isaque kukukat tak, Jacó kukukat tak,” i juk o'e Moisés, ce'ũ'ũ ip puje. ");
INSERT INTO myu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Deus ce'ũat kukukat g̃u―itaicat kukukat acã. Imẽnpuye wuyetaybit ixeyũ'ũm'ũm waram o'jetait ce'ũap tomukadi iam. Soat itait Deus xe―itaicayũ, waram o'jetait'iayũ dak — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","— Etaybit cĩcã ma jede am — io'e Moisés ekawẽn imutaybitbin'ukat. ");
INSERT INTO myu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ya'õbabi'ũm ip o'e Jesus a'õbu am. ");
INSERT INTO myu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus pit o'e cebe ip: — Addeayũ e'em “Deus emunaẽ Davi naxeg̃ebit,” i — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","— Imẽn e'em Davi Salmodup pe: Deus o'e okukukat pe: “Xik'i abik oba'at kadi,” i. ");
INSERT INTO myu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Ekay itakomaat a'õbacaap og̃u'ũm,” i. Kũyjobit jeedop ip a'õ kay, i — io'e. ");
INSERT INTO myu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","— Imẽn Davi e'em Salmodup pe―jebibododonaptup pe — io'e. — Davi o'e Deus emunaẽ be “Okukukat” i. Imẽnpuye Deus emunaẽ Davi naxeg̃ebit acã g̃u osunuy. Davi kukukat tak osunuy — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","G̃ebuje Jesus o'jekawẽn jeweju etaybitbinayũ eju. 12 beayũ eju o'jekawẽn adeayũ a'õpiju. ");
INSERT INTO myu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Eyday'em'um cuy epesop Moisés ekawẽn eymutaybitbin'ukayũ be eymug̃uykukuap puxim — io'e. — Tũybe soat podi ma oca'õbuyxi iãn e'em ip — io'e. — Jesay ukpi wẽnẽg̃wẽnẽg̃ãn ip jekukum soat pe jejojoan. Icokcok cĩcã ip warara'acat pe ibuyxim ikuk am soat etabutpe — io'e. — Kariwa yobog̃at tũyap pe abik ojuy ip Deus eju kawẽnwẽnap'a be. Peta kabia be dak cucum ip kariwa yobog̃at tũyap kay yabikap ojuy. ");
INSERT INTO myu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ag̃okatkat'ũm e'ũ buje, itayxibuk pubut pupum ip. Cekawẽn wa'ũm cĩcã ip Deus eju warara'acat pe “Eyetaybit cĩcã Deus eju kawẽn ãm” i'e am cebe ip. Jewexe Deus eju ip kawẽnwẽn. Deus xe g̃u ip ya'õbuyxi―jewexe acã. Imẽnpuye soat podi ma ipiat supi'ajo ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","G̃ebuje Jesus o'jeak dinheiro mũn'a kay―isurũg̃at mũn'a kay. Dinheiro mũn'a Deus eju kawẽnwẽnap'a be o'yanuy. Ibubut adeayũ dinheiro mõg̃mõg̃ ip o'e ig̃o'a be. Xeresu g̃u o'jomõg̃mõg̃ ip ya be. ");
INSERT INTO myu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","G̃ebuje Jesus ayacat o'jojojo―itop'ũm e'uibit―tadaybocat. Ixe ayacat dinheiro isurũg̃at o'jomõg̃ ig̃o'a be―xepxep ã o'jomõg̃. Xepxepatei teibog̃ g̃u osodop―tei'ĩt ma. ");
INSERT INTO myu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","— Icẽmãn õn e'em eywebe — Jesus o'e jexeayũ be. — Ibubut adeayũ ma ade o'jomõg̃mõg̃ ip. Yopĩt ma bit jexewiat'in o'jomõg̃mõg̃ ip ya be jedinheiro'in. Ixe ayacat pit soat jexewiat o'jomõg̃ jedinheiro. Ka'ũma ma o'jepoyat cexe. Tei'ĩcat o'jomõg̃. Inaka soat o'jomõg̃ jedinheiro. Jexat pu ojuyap tak o'jomõg̃. Imẽnpuye Deus xe ayacat teibog̃ o'jomõg̃ tei'ĩt ma'g̃u wuyxe. Deus xe warara'acat podi ma o'jomõg̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","G̃ebuje ceweju etaybitbinayũ o'jekawẽn Jesus eju. — Tapu, ak'i juy ece — io'e ip. — Deus eju kawẽnwẽnap'a yadip cĩcã! — io'e ip. — Wita'a mug̃ẽg̃ẽ'a yadip cĩcã! — io'e ip. — Adeayũ juk adi jedinheiro o'g̃ũmg̃ũm yamudipapteim — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Icẽmãn — io'e Jesus cebe ip. — Yadip cĩcã g̃asũ. G̃axĩn ma bit soat'a je'aedu. Xepxep'a jewa'awebotbon g̃u je'e wita'a — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","— Tapu, pug̃ũn xe'e je'aedu? — io'e ip. — Ajo je'bapuk g̃asũ je'aedu iam ocemutaybit am? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","— Eyday'em'um cuy epesop warara'acat pe eymug̃uykukuap puxim! — io'e. — Napapa'ukayũ jajẽm. “Cristo õn,” i napa ma je'e ip warara'acat pe. “Ijodiat taxijojo'ukan Deus emunaẽ õn,” i napa ma je'e ip. “G̃axĩn ma Deus soat kukukan je'e,” i napa ma je'e ip. Eyetabun g̃u juy epesop ixeyũ ekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","— Soat kaka dag̃ nopag̃õg̃õm je'e ip―ijoxĩn ma, wũy dak. Nopag̃õg̃õmap awẽg̃ tobuxik puje, eyag̃uykorereren g̃u juy epesop. Imẽn cuy je'e koam. Imẽnpit soat i'ũmap kabia oajẽm g̃u buk. ");
INSERT INTO myu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","— Pũg̃ eipi watwat nopag̃õg̃õm je'e wara'at eipi watwat eju. Pũg̃ ka watwat nopag̃õg̃õm je'e wara'at ka watwat eju. ");
INSERT INTO myu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Soat kaka dag̃ ipi jexixi. Soat ka dag̃ je'e reap. Soat ka dag̃ je'e iwãtaxipipi ade. Xipat'ũm cĩcãat je'bapuk. Wuymuparararanap tak je'bapuk kabi be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","— Iboap ebapuk awap itakomaayũ jeydaomũn. Ipiat supi'ajoat ip eywebe. Jeydujowat ip Deus eju kawẽnwẽnap'a be Judeuyũ be eymuymuy am. Daomũnmũnap'a be ip jeymuõm. Jeydujowat ip iecug̃ap dopabe ika kukukayũ dopabe dak, okay eyetabut puye. ");
INSERT INTO myu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ixeyũ dopabe bima juy kawẽn idipat epeg̃uwẽn cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","— “Apẽn paxi oce'e cebe ip?” i'ũmg̃u juy epe'e. “Apẽn paxi ocewedayo?” i'ũmg̃u dak cuy epe'e. Eyag̃uybabi'ũm'ũm g̃u juy epesop apẽn paxi ocewedayo iap kay. ");
INSERT INTO myu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Õn ma jeymutaybin jedem ixeyũ dopabe bima. Eya'õmuypit pa'ore je'e cebe ip eykay itakomaayũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","— Eyebay ma jeyũm eykay itakomaayũ be eyaoka am, eywag̃oyũ dak, eybadipyũ dak, eybureyũ dak. Ixeyũ ma ey'in yaoka pũg̃pũg̃. ");
INSERT INTO myu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Soat eykay g̃u jĩjã je'e okay eyetabut puye — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","— Õn pit soat em ag̃ og̃uy eykay. Soat em õn xipan jeykuk. ");
INSERT INTO myu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Eyetabun cuy epesop okay ipiat'ajojom ma'g̃u eyju. Soat em Deus xe epesop eye'ũ buje — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","— Sorarayũ be Jerusalém ka mukoreren puje, eyetaybit epesop g̃axĩn ma ip ikamu'ũm iam. ");
INSERT INTO myu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jerusalém ka koreren pima, jewat cuy ip co'a kay jaokaap puxim Judéia eipi watwat. Jeka bewi juy ip je'jẽm g̃u ikabog̃atka watwat. Ikabog̃atka kay g̃u juy ip jenapõn kog̃ũnpi watwat. ");
INSERT INTO myu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jenapõn g̃u juy ip ixe kabia be Deus jekay itakomaayũ be jeweig̃ puye. Ixe soat pe jeweik jemudupmubararaktup ekawẽn tag̃―kuyjeatup ekawẽn tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","— Yukreg̃ayũ ipiat supi'ajojo jĩjã ixe kabia be, jekũm pe je'it kukayũ dak. Judéia eipi watwat ipiat supi'ajojo jĩjã. Deus ipiat supi'ajoat Judeuyũ be itakoma jĩjã buye. ");
INSERT INTO myu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cekay itakomaayũ Judeuyũ yaokaka pajam. Warara'acat ip taomũn. Taomũnmũn ip tujowat wara'at ka dag̃. Jerusalém ka sukamu'ũm Judeu'ũmayũ. Imẽn je'bapuk Judeu'ũmayũ soat kukukan pima — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","— Iwaruat je'bapukpuk kaxiepiat pe, kaxiaat pe dak, kasopta be dak. Soat ka watwat yag̃uybabi'ũm'ũm cĩcã je'e. Yag̃uybabi'ũm'ũm je'e ip soati jediexixi jĩjã buye, tipodoy jĩjã buye dak. ");
INSERT INTO myu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Soat kabi beacat muycemcemap jearere. Soat ya'õca'ũm je'e jeparara pibun. Ya'õca'ũm je'e ip ipararuat ebapuk puje — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","— G̃ebuje ip ojo — io'e Jesus. — Kabikerereat eju oajẽm puje ip ojo — io'e Jesus. — Soat wag̃o õn. Ixeyũ ojo. “Ka'ũma ma ejo'iat ya'õbacaat,” i je'e ip owebe — io'e Jesus. — “Soat podi ma edip,” i je'e ip owebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","— Iboap ebapuk puje, g̃axĩn ma taxijojom epe'e. Imẽnpuye eycokcog̃ cuy epesop. Eya'õcam cuy epesop — io'e. Imẽn Jesus o'jekawẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn jexeayũ be. — Figueira'ip cuy epeyopcoco, wara'at'ip tak. ");
INSERT INTO myu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tupkireatup cẽm puje, eyetaybit g̃axĩn ma koato je'e iam. ");
INSERT INTO myu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Imẽnpuxim ipararuat ebapuk puje, eyetaybit epe'e g̃axĩn ma Deus soat kukukan je'e iam — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","— Icẽmãn õn e'em eywebe. Soat g̃asũacayũ e'ũ awap soat je'bapuk wekawẽn tag̃. ");
INSERT INTO myu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kabi i'ũm, i'pi dak. Wekawẽn pit i'ũm g̃u. Soat em wekawẽn kay itabut jeedop ip adeayũ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","— Ag̃ cuy epesop wajẽmap kay — io'e. — Puybitxim g̃u juy epesop kawedixim g̃u dak, tarekrek pupuxim g̃u dak — io'e. — Ag̃ cuy epesop wepit pujeap kay. ");
INSERT INTO myu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ag̃'ũm pima epeyekuy wepit puje puca ekuyap puxim ibu buje. ");
INSERT INTO myu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Imẽnpuye soat em ma ag̃ cuy epesop wepicap kay. Soat em cuy epeyekawẽn Deus eju — io'e. — “Bay, ocemutaxin cuy eg̃uy ipiat'ajoap puxim,” i juy epe'e Deus pe. “Bay, ocebuywatwan cuy eg̃uy soat wag̃o kay ocajẽm puje ocesũsũnap puxim,” i juy epe'e cebe — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Soat kabia Jesus adeayũ mutaybitbin'uk osunuy Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Kabia'isum adeayũ je'aweroro'uk ip osodop ig̃o'a be Jesus ekawẽn com. Kabiog̃kabiog̃'i bima o'jepitpit Jesus Oliveira dip'a bicũg̃pe xexen. ");
INSERT INTO myu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Peta ajẽm pima paĩyũ kukukayũ Jesus aoka ojuy ip, Moisés ekawẽn imutaybitbin'ukayũ dak. Peta butet Páscoa i osunuy. ");
INSERT INTO myu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ixe epeta bima Judeuyũ pão'a o'o'uk osodop―yamuyuhuhuaptõmtẽm'ũmat'a. Soat kabia Jesus aoka ojuy oekuku ip paĩyũ kukukayũ, Moisés ekawẽn imutaybitbin'ukayũ dak. — Apẽn g̃u xe'e aceyaoka? — io'e ip jewewebe. Adeayũ eta'ũm pima ip yaoka ojuy oekuku, adeayũ buxim iparara ip puye. ");
INSERT INTO myu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","G̃ebuje Judas o'ju paĩyu kukukayũ kay oibu'un Jesus kay buye. Kũyjobit o'e Satanás a'õ kay. Ixe Judas xepxep putet osunuy. Iscariote i wara'at ibutet osunuy. 12 beayũ'in osunuy ixe. Deus eju kawẽnwẽnap'a wiwi'ukayũ kukukayũ kay dak o'ju. Jekawẽn ãm ceweju ip o'ju. Oajẽm cekay ip. Jay. — Õn ma Jesus og̃ũm eywebe yaoka am — io'e. — Apẽn xe'e og̃ũm eywebe? — io'e Judas. ");
INSERT INTO myu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Icokcok cĩcã ip o'e paĩyũ kukukayũ, Deus eju kawẽnwẽnap'a wiwi'ukayũ kukukayũ dak. — Ocewebe Jesus ũm puje, dinheiro oce'g̃ũm ewebe iũmapteim — io'e ip Judas pe. ");
INSERT INTO myu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","— Ha'a, dinheiro juy eg̃ũm owebe — io'e cebe ip. Imẽneju soat kabia paĩyũ be Jesus ũm ojuy oeku Judas. Adeayũ eta'ũm pi iũm ojuy oeku. ");
INSERT INTO myu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Peta ajẽm puje, Jesus Pedro o'g̃uju ikabog̃atka be, João dak. Ixe epeta bima Judeuyũ pão'a o'o'uk osodop ip yamuyuhuhuaptõmtẽm'ũmat'a. Ovelha aokaka'uk ip osodop Páscoa epeta bima. Imẽnpuye Jesus Pedroyũ o'g̃uju soat muxipan am. — Ikabog̃atka be juy epeju — io'e. — Ovelha juy epejat. Epeyaoka juy. Epejoyoy juy wuywebe i'o am Páscoa kabia be — io'e cebe ip―Pedro be, João be dak. ");
INSERT INTO myu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","— Pu'a be xe'e oceyoyoy wuyxat? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","— Eya'õpicũg̃cũg̃ cuy epesop! — io'e. — Ikabog̃atka be eyõm puje, ag̃okatkat eydopabijuk―idibi mũn'a kukat. Ixe nomuju juy epeju — io'e. — Ixe be uk'a be iõm puje, eyju dak epeõm ig̃o'a be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","— Uk'a iwat pe juy epeyekawẽn. “Ocemutaybitbin'ukat o'jewa'õmudot ewebe,” i juy epe'e cebe. “ ‘Pu'abi be ebikuy omujum jekõn ãm oweju etaybitbinayũ eju Páscoa kabia bima,’ i juk o'e ocemutaybitbin'ukat,” i juy epe'e uk'a iwat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","— Uk'a iwat yabimubapuk eywebe umat'abi, yabog̃at'abi, soat opop iat'abi — io'e. — Ibo'abi be juy ovelha epejoyoy wuyxan — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","O'ju ip ikabog̃atka be. Apẽn cuk adi Jesus o'e cebe ip iap tag̃ o'tobuxik ip soat tag̃. Ovelha o'joyoy ip ig̃o'abi be. ");
INSERT INTO myu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jekõn pima Jesus o'jekawẽn jemumujuyũ eju―12 beayũ eju. Kaxikxik'i osodop ip mesa be. ");
INSERT INTO myu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","— Páscoa xat o pin cĩcã õn eyweju ijop epeta bima — io'e. — G̃axĩn ma juy õn ipiat'ajom — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","— Deus soat kukukan'ũm pima Páscoa xat ojo'o g̃u. Imẽnpit Deus soat kukukan pima, ojo'o waram — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","G̃ebuje Jesus uva'abidi o'timuõm tikõnkõg̃ap pe. — Bay, ẽn xipat cĩcã — io'e Deus pe. Tikõnkõg̃ap o'g̃ũm jeweju etaybitbinayũ be. — Juku — io'e. — Epetikõn. Epetimu'ẽ'ẽ eyewewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","— Ijodi g̃u waram uva'abidi otikõn. Deus soat kukukan pima bit, waram otikõn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","G̃ebuje pão'a o'yabu. — Bay, ẽn xipat — io'e Deus pe. O'yadakat. O'yaũm cebe ip. — Iju'a ojebit — io'e. — Eywebeam oje'ũ. Ya'o buje we'ũap kay juy g̃ebum epesop — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jekõn epere buje, uva'abidi o'tiũm cebe ip. — Ijudi kõn puje, odoymukererenap kay juy g̃ebum epesop — io'e. — G̃asũ Deus ikẽrẽat ju'uk eywebewi odoymukereren puye, oje'ũ buye. Ikẽrẽat ju'uk eywebewi apẽn kuyje ixe o'e iap tag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","— Mesa be xik'i owejuat ma oũm okay itakomaayũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","— Soat wag̃o õn. Oje'ũ apẽn cuk adi webay ibikuy osunuy iap tag̃. Imẽnpit Deus ipiat supi'ajoat oũmat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","— Abu xe'e wuy'in kuka Jesus o'g̃ũm cekay itakomaayũ be? — io'e ip jewewebe Jesus eju jekõnkõnayũ. ");
INSERT INTO myu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","G̃ebuje Jesus eju etaybitbinayũ o'jewa'õbubu jeweweju. — Abu wuy'in soat podi ma ya'õbuyxian je'e? — io'e ip jewewebe. O'jewa'õxikxik ip. ");
INSERT INTO myu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus o'jekawẽn cebe ip. — “Kũyjobin cuy epesop wa'õ kay,” i'e'em ijodiat kukukayũ jebekitkit pe. “Kariwa yobog̃at õn,” i'e'em ip — io'e. — Ijodiat bure ip adeayũ xe. ");
INSERT INTO myu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eyju bit imẽn g̃u juy epesop. Kariwa yobog̃at pin pima, ya'õbuyxi'ũmat puxim cuy epeku — io'e Jesus cebe ip. — Warara'acat kukukat pin pima juy ibuywatwan ip epesop — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","— Abu kariwa yobog̃at? — io'e. — Jekõn ãm mesa be xik'iat tu? Ixat tojotjot'ukat g̃u xe'e? Jekõn ãm mesa be xik'iat ma kariwa yobog̃at. Imẽnpit eyxe bima wuyxat tojotjot'ukat puxim cuk adi ojekuku. Warara'acat puywatwan cuk adi ojekuku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Eybu'un g̃u juk adi epesop okay, warara'acat a'g̃u ipiat o'supi'ajoat owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","— Kuy bima webay o'e owebe “Soat kukukan ecesũy,” i. Imẽnpuxim “Eyju dak soat kukukayũm epesop oweju,” i õn e'em eywebe. ");
INSERT INTO myu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Õn soat kukukan pima, wemesa be epeyekõn oweju — io'e. — “Eyju ikẽrẽat kug̃ Deus xe,” i epe'e kũyjobit'ũmayũ be. “Eyju ikẽrẽat kug̃ g̃u Deus xe,” i dak cuy epe'e kũyjobicayũ be. Imẽn epe'e Israel naxeg̃ebitbit pe―12 be tiwatwat pe — io'e Jesus jeweju etaybitbinayũ be. ");
INSERT INTO myu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","— Simão — io'e Jesus Simão Pedro be. — Eya'õpicũg̃ cuy — io'e. — Satanás kuy o'e owebe “Simão buyxijo pin õn, itabut paxi je'e wa'õ kay iam,” i — io'e Jesus Simão be. — Satanás itabucayũ xewi emujẽm pim apẽn wuyju tarekrektata mujẽmjẽm taixee bewi iap puxim — io'e. — “Ha'a. Esubuyxijo,” i juk oce Satanás pe — io'e Jesus. — “Soat cuy esubuyxijo oweju etaybitbinayũ,” i juk oce cebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","— Imẽnpit kuy ocekawẽn Deus eju ewebeam. “Simão juy esubuywan itabucap epereap puxim,” i oce Deus pe — Jesus o'e. — Waram okay etabun pima, eykitpitpiyũ juy esubuywan itabut cĩcã am ip okay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","— Kariwa, jeiwat g̃u õn — io'e Simão Jesus pe. — Obu'un g̃u ekay — io'e. — Daomũnmũnap'a be dak cuy oju eburem. We'ũap kay ma juy oju eburem — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","— Pedro — io'e. — Sapokay ede'ũm awap, ebapũg̃ em “Ixe bure g̃u õn,” i ece'e — io'e Jesus pit. ");
INSERT INTO myu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","G̃ebuje o'jekawẽn wara'acayũ eju―jeweju etaybitbinayũ eju. — Patorõn kug̃'ũm cuk adi õn eymuju, sako kug̃'ũm tak, bolsa kug̃'ũm tak, eyiuk kug̃'ũm tak — io'e. — Irerem tu juk adi epekuku? — io'e. — Ka'ũma. Xipan cuk adi ocekuku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","— G̃asũ bit — io'e cebe ip — patorõn kug̃ pima juy epetujowat eyekuap tag̃ — io'e. — Sako kug̃ pima juy epetujowat. Payao kug̃'ũm pima juy eyeekabek epeteida ibu am — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","— Imẽn e'em Deus ekawẽntup―omuwẽg̃aptup: “Ikẽrẽat mug̃ẽg̃ẽ'ukat ẽn,” i napa ma ijodiat e'em Deus emunaẽ be, i. Ibodup ekawẽn tag̃ je'e ip owebe g̃asũ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","— Kariwa, ak'i ece — io'e ip. — Xepxep oceju payao kug̃ — io'e ip. — O'e ma burut — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ibocewi o'jẽm ip jekõnkõnap'a bewi umat'abi bewi. Jesus o'ju co'a kay―Oliveira dip'a kay―cucu'uk osunuyiap'a kay. Ceweju etaybitbinayũ dak o'ju tomuju. ");
INSERT INTO myu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","O'jekawẽn ceweju ip yajẽm puje. — Epeyekawẽn cuy Deus eju eywebe ikẽrẽat kukap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesus o'jewerũg̃ jeweju etaybitbinayũ xewi. Bosusu o'ju. Jag̃ẽpũg̃ ma o'e. G̃ebuje Jesus o'jekawẽn Deus eju. Jẽg̃'aecõg̃cõg̃ o'jekawẽn. ");
INSERT INTO myu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","— Bay, ebu'u bima bit ipiat esupi'ajoat g̃u owebe — io'e Deus pe. — Imẽnpit obikuyap tag̃ g̃u juy ece―ebikuyap tag̃ acã — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ibocewi Deus ekawẽn tojotjot'ukat o'kop kabi kadiwi Jesus a'õmucan am. ");
INSERT INTO myu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Big̃ ma ja'õbuyxim o'jekawẽn Deus eju. Jeg̃uycũg̃at pibun ma oe'ũ pin. Topa'adiayey o'e toy buxim, ig̃uycũg̃ cĩcã buye. O'jedopadoyebot ipi ju. ");
INSERT INTO myu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Deus eju jekawẽn epere buje o'ãy. Kirik'ãy. Jeweju etaybitbinayũ kay oajẽm. Jay. Ixexet ma ip o'tobuxik. Ixexet ip jeg̃uycũg̃ap kug̃ ip yobog̃ cĩcã buye. ");
INSERT INTO myu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","— Apẽnpuye eyxexet? — io'e. — Epeyewurũg̃ cuy! — io'e cebe ip. — Epeyekawẽn cuy Deus eju eywebe ikẽrẽat kukap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Warara'acayũ dak oajẽm Judas eju. Ixe Judas warara'acayũ wap oajẽm jaku Jesus iam imutaybin am ip. Ixe 12 beayũ'in osunuy. Oajẽm Jesus kay Judas. Oajẽm Jesus ag̃obu kõn ãm tobede am. ");
INSERT INTO myu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","— Judas — io'e Jesus. — Soat wag̃o õn — io'e. — Wag̃obu kõn tu ẽn oũm ãm okay itakomaayũ be? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","G̃ebuje Jesus eju etaybitbinayũ itaybit o'e Jesus pum ip iam. — Kariwa, oceyaoka du ip pajam? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pũg̃ ixeyũ'in tak paĩyũ kukukat puywatwat'ukat o'sug̃uybu'uk pajam. Tep. Iba'at kadiat g̃uybu o'sug̃uybu'uk. ");
INSERT INTO myu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","— Imẽn g̃u bit epesop! — io'e Jesus jeweju etaybitbinayũ be. Cay. O'sug̃uybumucay. O'sug̃uybumuwedap. G̃uybudip o'e. ");
INSERT INTO myu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","G̃ebuje Jesus o'jekawẽn Judas ejuayũ eju―paĩyũ kukukayũ eju, Deus eju kawẽnwẽnap'a wiwi'ukayũ kukukayũ eju dak, Judeuyũ kukukayũ eju dak. — Epajẽm odaomũn ãm ibukurukat taomũnap puxim — io'e. — Eyba'ip kukug̃ epajẽm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","— Soat kabia Deus eju kawẽnwẽnap'a be juk adi og̃uy. Epesot g̃u juk adi odaomũn ãm ig̃o'a be bima — io'e. — G̃asũ bit okuk put eywebe eybikuyap tag̃. Eybikuyap tag̃ eyeku but g̃asũ. Kabiokbog̃ tag̃ jekuku'ukayũ kukat ijodiat kukat g̃asũ. Satanás ijodiat kukat g̃asũ. Eyju dak kũyjobit ixe a'õ kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Judas ejuayũ Jesus o'jat. O'tujowat ip paĩyũ kukukat duk'a kay. Pedro dak o'ju Jesus nomuju. Wũy ma oeku Jesus nomuju. Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","G̃ebuje daxa o'g̃usop ip paĩyũ kukat tuk'a xe, uk'a ekorara be. Oabikbik ip daxa etako be. Pedro xik'i o'e ixeyũ parakpe. ");
INSERT INTO myu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","G̃ebuje ayacat Pedro o'jojojo―yaypan'isuat―paĩyũ kukukat puywatwat'ukat. O'jojojo Pedro daxa ekabia dag̃ puye. O'jeak cekay. — Ixe dak Jesus eju oeku — io'e ixe ayacat. ");
INSERT INTO myu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","— Ka'ũma — Pedro bit o'e napa ma. — Tũ'ũ, ixe bure g̃u õn — io'e napa ma jebuap puxim. ");
INSERT INTO myu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wara'acat Pedro o'jojojo ibun'ũm pima ag̃okatkat. — Ẽn tak ejeku Jesus eju — io'e cebe. — Ka'ũma — Pedro o'e. — Jekukum g̃u õn ceweju. Ojeku g̃u õn pit ceweju — io'e napa ma. ");
INSERT INTO myu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pũg̃ hora kap puje, wara'acat o'jekawẽn. — Icẽmãn ẽn ma Jesus eju ejeku — io'e. — Galiléia eipi bewiat ẽn — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","— Tapu — Pedro bit o'e. — Wetaybit g̃u apẽn ẽn e'em iam — io'e napa ma. — Ixe bure g̃u õn pit — io'e napa ma. Sapokay o'jede iboam i'e buje. Kariwa Jesus o'jekorepẽn. ");
INSERT INTO myu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","G̃ebuje o'jeak Pedro kay. Pedro dak o'jeg̃ebu Jesus a'õ kay―kuy bimaap a'õ kay. — Ebapũg̃ em napa ma ece'e “Jesus bure g̃u õn,” i — i juk o'e Jesus Pedro be. ");
INSERT INTO myu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kacũg̃ kay Pedro o'ju. Jesus bure g̃u õn iap kay o'jeg̃ebu. Imẽnpuye o'tõn cĩcã. ");
INSERT INTO myu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iwiwi'ukayũ Jesus o'jowayway―o'jat'iayũ. Jesus o'g̃upokupok ip. ");
INSERT INTO myu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jesus eta o'sutamuekabek ip pag̃õm. — Abu emupok exe? — io'e ip cebe iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jesus o'jomuymuy jĩjã ip. Warẽmtag̃ ma ip Jesus o'jukuk. ");
INSERT INTO myu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","G̃ebuje Judeuyũ kukukayũ o'je'awero ip, paĩyũ kukukayũ dak, Moisés ekawẽn imutaybitbin'ukayũ dak. Judeuyũ awẽwẽ'ukayũ yobog̃ayũ ip osodop. Kabia'isum ip o'je'awero. Jesus o'tujowat ip ixeyũ kay. Waram g̃uto Jesus o'jowaywayway ip. ");
INSERT INTO myu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","— Ẽn tu Deus emunaẽ? — io'e ip. “Cemunaẽ bima bit cuy ece ocewebe,” io'e ip Jesus pe. — Õn eymukũyjo bima, okay eyetabut g̃u kuka epe'e — io'e Jesus pit. ");
INSERT INTO myu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","— Omukũyjom cuy epe'e i õn e'em eywebe bima, kuka omukũyjom g̃u epe'e. ");
INSERT INTO myu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Imẽnpit soat wag̃o õn. G̃axĩn ma oabik Deus ba'at kadi―soat podi ma ya'õbacaat ba'at kadi. Ixe jo'i wa'õbaca og̃uy — io'e Jesus. — Jewejojo'i ma ocesop oca'õbacaap kug̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","— Deus ipot tu ẽn? — io'e ip Jesus pe. — Eyju ma iboam e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","— Apẽg̃ãm kuka warara'acat atakoy Jesus muy am? Kuy o'e! Kuy ixe ekawẽn oceya'ĩjojo — io'e Judeuyũ kukukayũ. Deus muymuy xeku — io'e ip napa ma. Oibu'un ip awerom. ");
INSERT INTO myu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","G̃ebuje Jesus o'tujowat ip Pilatos kay―iecug̃ap kay. Jesus o'jomuymuy ip Pilatos pe. ");
INSERT INTO myu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","— Ite ag̃okatkat warẽmtag̃ ma ocemutaybitbin — io'e ip Pilatos pe napa ma. — “Kũyjobin g̃u juy epesop wuyeipi kukat a'õ kay,” i'e'em Jesus ocewebe — io'e ip napa ma. — “Eyedinheiro juy epeg̃ũm g̃u César be―wuyeipi kukat pe,” i'e'em ocewebe — Judeuyũ napa ma o'e Pilatos pe. — “Adeayũ kukukat õn,” i'e'em teku — io'e ip napa ma Judeuyũ. — “Deus emunaẽ õn,” i'e'em teku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","— Judeuyũ kukukat tu ẽn? — Pilatos o'e Jesus pe. — Ẽn ma iboam e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","— Ite ag̃okatkat ikẽrẽat kug̃ g̃u oxe bit — io'e Pilatos soat pe paĩyũ kukukat pe, je'awero'ibiyũ be dak. ");
INSERT INTO myu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","— Warẽmtag̃ ma teku ebekitkit mutaybitbin — io'e ip napa ma Pilatos pe. — Koap warẽmtag̃ ma Galiléia eipi watwat mutaybitbin oekuku. Soat tag̃ imutaybitbin oekuku―Judéia eipi dag̃. G̃asũ ijoce oajẽm. Teku ebekitkit mubu'u'un César a'õ kayap puxim — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","— Teku Galiléia eipi bewiat tu? — io'e Pilatos cebe ip. — Hm hm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Imẽnpuye Pilatos Jesus o'g̃uju Herodes kay, Herodes Galiléia eipi kukukat puye, Jesus tak Galiléia eipi bewiat puye dak. Ixe Herodes Jerusalém ka be osunuy ixeyũ kabia be. ");
INSERT INTO myu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Oajẽm ip Herodes kay. Herodes Jesus o'jojojo. Icokcok cĩcã o'e ijojom pima. Kuy bima Herodes ijo pin osunuy Jesus awẽg̃ o'yawẽg̃tobuxik puye. — Wuywebe i'e ba'oreat paxi g̃ubapuk wetabutpe? — io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O'jekawẽn Jesus eju. — Abu-a'õbi ẽn jekukum? — io'e cebe. — Ojojojo g̃u buk iat mubapug̃ tu ebu'u wetabutpe? — io'e cebe. Mũg̃ ma osunuy Jesus pit. ");
INSERT INTO myu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paĩyũ kukukayũ dak Jesus o'jomuymuy jĩjã, Moisés ekawẽn imutaybitbin'ukayũ dak. ");
INSERT INTO myu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes tak Jesus o'jowayway jĩjã. Warẽmtag̃ ma Jesus o'jukuk, cesorarayũ dak. Cesay idipat o'g̃uõm ip Jesus pe iwaywayway am. G̃ebujep waram Jesus o'g̃uju Pilatos kay. ");
INSERT INTO myu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ixe kabia dak Herodes Pilatos burem o'e. Kuy bima itakoma jĩjã osodop ip jewewekay. ");
INSERT INTO myu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","G̃ebuje Pilatos paĩyũ kukukayũ o'tomuwã, Judeuyũ kukukayũ dak, warara'acat tak Judeuyũ. ");
INSERT INTO myu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","O'jekawẽn cebe ip. — Ite ag̃okatkat epetojot okay — io'e. — “Ite ag̃okatkat warẽmtag̃ ma ocemutaybitbin,” i juk epe'e owebe — io'e. — Kuy ocekawẽn ceweju eyetabun — io'e. — Oxe bit ikẽrẽat o'g̃ujurũg̃ g̃u―pũg̃ em tak ka'ũma — io'e. — Te'e ma eyju e'em “Ikẽrẽat kug̃ teku,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","— Herodes tak o'jekawẽn ceweju — io'e. — Herodes xe dak ikẽrẽat kug̃ g̃u — io'e. — Imẽnpuye waram Jesus o'tujupicat ip ocekay. Cedag̃ g̃u ocewebe bit yaoka am. ");
INSERT INTO myu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Imẽnpuye imupok puje og̃uwekap jekpiwan ma iju am — io'e Pilatos. ");
INSERT INTO myu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","— Ap! — io'e adeayũ ya'õberen Pilatos pe — Ite ag̃okatkat eg̃ujẽm g̃u — io'e ip. — Eyaoka ma! — io'e ip. — Barrabás pit eg̃ujẽm daomũnmũnap'a bewi. Ite ag̃okatkat pit eg̃ujẽm g̃u — io'e ip ya'õberen. Ig̃o epeta bima Pilatos pũg̃ ma daomũnmũnap'a beat mujẽmjẽm'uk osunuy. Ixe Barrabás daomũnmũnap'a be osunuy. ");
INSERT INTO myu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kuy bima ixe Barrabás iecug̃ap ebekitkit eju o'jenopag̃õg̃õm. Jenopag̃õg̃õm pima wara'acat o'yaoka. Imẽnpuye daomũnmũnap'a be osunuy. ");
INSERT INTO myu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","G̃ebuje Pilatos ma Jesus muwekap ojuy o'e. — Jesus ma og̃uwekap — io'e adeayũ be. ");
INSERT INTO myu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Adeayũ bit Jesus pamupayaat ojuy korosa be ce'ũ ãm. — Jesus cuy epeyaokaat! — io'e ip Pilatos pe. — Jesus juy esubamupayaat korosa be ce'ũ ãm — io'e ip ya'õberen. ");
INSERT INTO myu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","— Apẽnpuye dak osubamupayaat? — io'e Pilatos. — “Ikẽrẽat o'g̃ujurũg̃ g̃u,” i õn e'em — io'e. — Cedag̃ g̃u wuywebe yaoka am — io'e. — Og̃upokupokat acã. Imupokupok puje, juy og̃uwekap — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","— Ap! — io'e ip. — Jesus esubamupayaat korosa be — ixeyũ bit o'e. Imẽn o'e ip ade em ma. Ya'õberen o'jewãwã ip. Imẽnpuye: ");
INSERT INTO myu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","— Iteyũ bikuyap tag̃ oce, big̃ ma cewãwãwãap puxim ip — io'e Pilatos jewebe ma. — Ixeyũ etabun imuwekap pa'ore owebe — io'e jewebe ma. — Ha'a — io'e adeayũ be―aweromayũ be. — Eybikuyap tag̃ cuy oce — io'e Pilatos cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Imẽnpuye Pilatos Barrabás o'gujẽmat daomũnmũnap'a bewi―iecug̃ap ebekitkit eju o'jenopag̃õg̃õm'iat o'g̃ujẽmat―wara'acat o'yaoka'iat o'g̃ujẽmat―adeayũ o'joojuy imujẽm ãm'iat o'g̃ujẽmat. Jesus pit o'g̃ũm adeayũ be. — Eybikuyap tag̃ cuy epe'e cebe — io'e Pilatos. Jesus o'jat ip. ");
INSERT INTO myu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","G̃ebuje sorarayũ Simão o'jat. Cirene ka bewiat o'jat ip―kog̃ũnpi bewi ajẽm'ibit. O'jat ip Jesus korosa dujowan co'a kay bima. Korosa o'jomuy ip Simão a'õpi'a jeje. O'tujowacat Jesus nomuju. ");
INSERT INTO myu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adeayũ dak o'ju Jesus nomuju. Aoyũ dak o'tõn cĩcã Jesus kay. Ig̃uycũg̃ cĩcã ip o'e Jesus kay. ");
INSERT INTO myu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Imẽnpit Jesus o'jekorepẽn cekay ip. — Tũ'ũ'ũyũ — io'e cebe ip―Jerusalém ka watwat pe―aoyũ be. — Eyewewekay acã juy epetõtõn―okay bit ka'ũma — io'e. — Ey'iyũ kay dak cuy epetõtõn — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","— Ipiat epesupi'ajojo. Ipiat'ajojom pima soat je'e “Icokcok e'em i'it kapkap'ũmayũ, i'it'it'ibit'ũmayũ dak, i'it muytin'ũm'ibiyũ dak,” i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","— Adeayũ ce'ũ pin je'e ixe kabia be ipiat'ajojom puye. “Ocejeje juy a'a'at ocemuy'ũ ãm,” i je'e ip co'a be. “Ocemunẽm cuy,” i je'e ip co'a'ũn'a be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","— “Imẽn yopkicat'ip kukug̃ pima, apẽn xe'e kuka yopkarawat'ip o'jukuk ip?” i'e'em eyju — io'e Jesus waayũ be. Imẽn Jesus o'e cebe ip warẽmtag̃ ip jekug̃ puye. ");
INSERT INTO myu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xepxepayũ dak o'tujowat ip Jesus eju yaoka am―iecug̃ap a'õ kay'ũmayũ. ");
INSERT INTO myu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Co'a be yajẽm puje Jesus pa o'subamupaya ip korosa jeje. Ce'ũat'a ririt'a i omuy co'a butet. Iecug̃ap a'õ kay kũyjobit'ũmayũ dak o'subamupaya ip wara'at pe korosa be―xepxepayũ. Pũg̃ korosa o'jomuy ip ipikũykũy be Jesus ba'at kadi. Wara'at o'jomuy ip iba'ũg̃at kadi. Jesus tak o'jekawẽn Deus eju. ");
INSERT INTO myu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","— Bay — io'e. — G̃ebum g̃u juy apẽn ip warẽmtag̃ okuk iap kay, itaybit g̃u ip ajo pẽnpẽn oceju iam puye — io'e Jesus. G̃ebuje dado o'joxikxik ip Jesus pa o'subamupaya'iayũ. Jesus esay mu'ẽ'ẽ ãm jewewebe o'joxikxik ip ipi ju. Dado karatũg̃'a buxim o'yanuy. Ibararuk o'yanuy. ");
INSERT INTO myu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Adeayũ dak osodop Jesus cocom. Judeuyũ kukukayũ bit warẽmtag̃ o'e ip Jesus pe iwaywayway am. — Teku warara'acat o'taxijo — io'e Judeuyũ kukukayũ. — Teku Deus emunaẽ bima, juy jewedaxijo — io'e ip iwaywayway am. — Deus pe wuydaxijo am o'taẽ'ibit pima juy jewedaxijo — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorarayũ dak Jesus o'jowaywayway. Uva'abidi ũm ojuy ip o'e cebe tikõn ãm―tideibog̃'ũmati. ");
INSERT INTO myu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","— Ẽn Judeuyũ kukukat pima juy ecewedaxijo — io'e sorarayũ. ");
INSERT INTO myu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Taperadup toro'i oeku korosa eju Jesus abi ase―tupararukatup―Judeuyũ kukukat teku iap mubapukatup. ");
INSERT INTO myu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","G̃ebuje wara'at korosa ejuat Jesus o'jomuymuy―iecug̃ap a'õ kay kũyjobit'ũmat. — Ẽn Deus emunaẽ bima, ocedaxijom cuy ece — io'e ya'õberen Jesus pe. — Ecewedaxijo dak cuy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wara'at ejuat pit jebure o'g̃ukorẽm korosa ejuat. — Eparara g̃u du Deus puxim? — io'e jebure be. — Wuyeweweju ma wuyju je'ũm korosa eju. ");
INSERT INTO myu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Cedag̃ wuywebe je'ũ ãm ikẽrẽat cuk adi ag̃ujurũg̃rũg̃iap teim — io'e. — Ite bit o'g̃ujurũg̃rũg̃ g̃u ikẽrẽat — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","— Jesus — io'e ixe wara'at. — G̃ebum cuy okay eg̃uy ẽn soat kukukan pima — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","— Icẽmãn õn e'em ewebe, g̃asũ ma ẽn oweju ecesũy onuyapka be―idip cĩcãatka be — io'e Jesus ixe wara'at pe. ");
INSERT INTO myu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Pag̃o oicuk jekpiwan ma―Deus eju kawẽnwẽnap'a beat epag̃o―xĩntabi nomudip epag̃o. Oicuk ipidase ixe pag̃o bit. Kaxi wuyase bima kabiok o'e soat tag̃ i'pi dag̃. Kaxiepiat o'jepirẽm. O'jekabia g̃u. Ibun ma kabiok oeku―ebapũg̃ ehora. ");
INSERT INTO myu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","G̃ebuje Jesus o'jekawẽn Deus pe. — Bay — io'e. — Ag̃ cuy eg̃uy okay. Je'ũm cuy õn ebikuyap tag̃ — io'e ya'õberen. Oe'ũ. ");
INSERT INTO myu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","100 be sorarayũ kukat o'jeak cekay. Apẽn oe'ũ iap o'jojojo. — A'õbuyxi soat podi ma — io'e Deus pe. — Icẽmãn ite ag̃okatkat ikẽrẽat kug̃ g̃u osunuy — io'e. ");
INSERT INTO myu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Korosa be ce'ũap com o'je'awero'iayũ dak o'jepit ip jeduk'a be. O'jepit ip jewekũmpi okakam jeg̃uycũg̃ap pibun. ");
INSERT INTO myu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesus bureyũ dak wũywũy ma korosa wi ip osodop, aoyũ dak―Galiléia eipi bewi Jesus eju yajẽm'ibiyũ. Kacũg̃cũg̃'i osodop ip Jesus e'ũap cocom. ");
INSERT INTO myu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","G̃ebuje José o'ju Pilatos kay―Arimatéia ka bewiat―Judéia eipi bewiat. Ixe Judeuyũ awẽwẽ'ukat yobog̃at osunuy. Xipat cĩcã osunuy. Cũg̃ cĩcã osunuy. Soat xe ya'õbuyxi osunuy. ");
INSERT INTO myu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Warara'acayũ juk adi Jesus aoka ojuy osodop ip Judeuyũ awẽwẽ'ukayũ yobog̃ayũ. José bit ka'ũma. Deus soat kukukan iap wiwim osunuy José bit. ");
INSERT INTO myu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Oajẽm Pilatos kay ixe José. G̃ebuje korosa ejuwi Jesus'ũm jebit mukop ojuy o'e. — Jesus'ũm jebit cuy oju'ukat — io'e Pilatos pe. — Eju'uk cuy — io'e Pilatos. ");
INSERT INTO myu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O'ju i'ug̃. Oajẽm. Jesus'ũm jebit o'ju'uk korosa ejuwi José. Jesus'ũm jebit o'jomũnmũn pag̃õm―idip cĩcãan, irucan. Imũnmũn epere buje, o'tujowat witabikũy kay. Jesus'ũm jebit o'jomõg̃ witabikũy be ikũykot'isuatkũy be. ");
INSERT INTO myu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sexta-feira osunuy. Katpuje jĩjã o'e. G̃axĩn ma jebodoydoyap kabia Judeuyũ be. ");
INSERT INTO myu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aoyũ o'ju José eju―Galiléia eipi bewiayũ. Witabikũy o'sukũyjojo ip. Apẽn Jesus'ũm jebit o'jomõg̃'iap o'jojojo ip. ");
INSERT INTO myu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ibocewi o'jepit ip jeduk'a be. Tõmte'oatõm o'tõmuwekoy ip Jesus'ũm jebit mude'onap ojuy. Kuyaje acã ijebit mude'on ojuy ip osodop, kuy jebodoydoyap kabia buye. Kapikpi kuka o'e kuyaje. ");
INSERT INTO myu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Judeuyũ ebodoydoyap kabia bima aoyũ o'jebodoy jawẽwẽap ekawẽn tag̃. Kabia'isum pit waram o'ju ip witabikũy kay. Domingo bima ip o'ju. Tõmte'oatõm tujowan o'ju ip Jesus'ũm mude'on ojuy. Jay. Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yajẽm puje wita'a o'yadobuxik ip yawede―ikũynomudip'a. ");
INSERT INTO myu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oõm ip witabikũy be. Jesus'ũm jebit o'tobuxik g̃u ip. ");
INSERT INTO myu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yag̃uybabi'ũm cĩcã ip o'e tobuxik'ũm puye. — Apẽn xe'e ixe o'e? — io'e ip jewewebe. Xepxep ag̃okatkayũ dak o'jebapuk aoyũ wap―kabi bewiayũ. Cesay kug̃ osodop ip isopsupat kug̃. ");
INSERT INTO myu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jeparara pibun ma ip o'jẽg̃'aecõg̃cõg̃ cewap ip. Ag̃okatkayũ dak o'jekawẽn aoyũ be. — Tũ'ũ'ũyũ — io'e ip. — Apẽnpuye eyju itaicat kudadam ce'ũat topapkũy be? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","— Ixe ijoce g̃u. Deus ixe o'g̃utait waram. O'g̃uyu kabi kay — io'e ip. — G̃ebum cuy epesop ixe a'õ kay―Galiléia eipi be bima iap a'õ kay. ");
INSERT INTO myu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Soat wag̃o õn,” i mo o'e eywebe. “Ikẽrẽat mujurũg̃rũg̃'ukayũ be oũm ip,” i mo o'e eywebe — io'e ip. — “Obamupaya ip korosa be. Oje'ũ. Imẽnpit xepxep xet kap puje waram ocejetait,” i mo o'e eywebe — io'e aoyũ be ixeyũ ag̃okatkayũ. ");
INSERT INTO myu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","G̃ebuje Jesus a'õ kay o'jeg̃ebu ip. O'jẽm ip witabikũy bewi. ");
INSERT INTO myu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aripit. O'jepit onze beayũ mukũyjo am apẽn cuk ip o'jojojo iam. Jay. Oajẽm ip. Soat o'g̃uwẽn ip onze beayũ be―Jesus eju oekuku'iayũ be, warara'acayũ be dak. ");
INSERT INTO myu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Madalena soat o'g̃uwẽn Jesus emumujuyũ be, Joana dak, Tiago xi dak, warara'acayũ dak. Tiago xi butet Maria i osunuy. Soat o'g̃uwen ip Jesus emumujuyũ be. ");
INSERT INTO myu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Warẽmtag̃ ma tũybe aoyũ kawẽnwẽn iãn o'e ip. Itabut g̃u ip o'e cekawẽn kay. ");
INSERT INTO myu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro bit dao ma o'ju witabikũy kay. Oajẽm. O'jeerot. Itaburuh. O'jetaburut witabikũy kay. Pag̃o acã o'jojojo―idip cĩcãat―irucat. Wara'at pit o'jojojo g̃u. — Ka'ũmg̃u Jesus! — io'e. Ibocewi o'jepit jeduk'a be. Yag̃uybabi'ũm cĩcã o'e. — Apen xe'e o'e ip Jesus'ũm jebit pe? — io'e jewebe ma. — Poma xe'e ijebit o'tujowat ip? — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ixe kabia be xepxep Jesus eju oekuku'iayũ o'ju Emaús ka kay. Emaús ka 10 kilometros osunuy Jerusalém ka wi. ");
INSERT INTO myu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","E dag̃ ip kawẽnwẽn oeku. Apẽn Jesus'ũm o'tobuxik g̃u ip witabikũy be iam kawẽnwẽn ip oeku. ");
INSERT INTO myu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kawẽnwẽn pima Jesus oajẽm ixeyũ kay―xepxepayũ kay. Ceweju ip o'ju e dag̃. ");
INSERT INTO myu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesus o'jojojo ip. O'jetabiebarẽm ip Jesus teku iam. Tũybe Jesus ce'ũ mabuk opop iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","— Apẽn eyju kawẽnwẽn e dag̃? — io'e Jesus cebe ip. Topag̃uycũg̃cũg̃ o'jecũcũ ip. ");
INSERT INTO myu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ixeyũ'in o'jede Jesus pe. Cleopas i ibutet osunuy. — Soat Jerusalém ka watwat itaybit apẽn o'jebapuk ibo ka be g̃asũ iam. Ẽn acã etaybit g̃u! — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Apẽn xe'e o'jebapuk? — io'e Jesus cebe ip. — Apẽn Jesus pe o'e ip iap awẽg̃ eyawẽg̃tobuxik g̃u du―Nazaré ka bewiat pe iap awẽg̃? — io'e. — Ixe Jesus Deus ekawẽn muwẽnuwẽn'ukat osunuy. Soat xe ya'õbuyxi osunuy. Ocejojojo g̃u iap mubapukpug̃ oekuku Deus a'õbi. Ixe juk cedag̃ ocemutaybitbitbin — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","— Paĩyũ kukukayũ wuyka kukukayũ dak Jesus o'g̃ũm Judeu'ũmayũ be yaoka am. Jesus pa o'subamupaya ip korosa be — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","— Oceju bit tũybe ixe Judeuyũ taxijo iãn cuk adi oce'e — io'e. — Inaka ebapũg̃ kabia kuy o'kap ce'ũap kabia. ");
INSERT INTO myu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Imẽnpit oce'in ip ocag̃uymubabi'ũm aoyũ — io'e. — Witabikũy be o'ju ip kabia'isum. Ikudadam ip oeku — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","— Jesus'ũm jebit o'tobuxik g̃u ip ikũy be — io'e. — Ocekay o'jepit ip — io'e. — “Deus ekawẽn tojotjot'ukayũ ocejojojo,” i mo o'e ip ocewebe — io'e Jesus pe. — “Kabi bewiat ocejojojo,” i mo o'e ip ocewebe — io'e. — “Jesus waram o'jetait,” i mo o'e ip ocewebe — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","— Wara'at ocebureyũ o'ju witabikũy kay — io'e. — Apẽn aoyũ o'e iap tag̃ o'tobuxik ip — io'e. — Jesus pit o'jojojo g̃u ip — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","— Eyetaybin wa'ũm cĩcã Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm ekawẽn — io'e Jesus cebe ip. — Eyetabun wa'ũm cĩcã! ");
INSERT INTO myu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cedag̃ osunuy Deus xe Cristo imẽn ipiat'ajo am, je'ũ ãm tak―wuydaxijo am Deus emunaẽ. Cedag̃ osunuy waram kabi kay jeu am soat kukukan―Deus co'i ya'õbacaan―Deus co'i idipan — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jemuwẽnuwẽg̃aptup ekawẽn o'g̃ukũyjojo ip soatup ekawẽn―Deus ekawẽntup ekawẽn―Moisés emudupmubararaktup ekawẽn, soat Deus ekawẽn muwẽnuwẽn'ukayũ emudupmubararaktup ekawẽn tak. Iboaptup ekawẽn o'g̃ukũyjojo ip. ");
INSERT INTO myu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Imẽn oajẽm ip jejuapka kay―Emaús ka kay. — Bosusu ma buk oju — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","— Ocexe juy eg̃uy — ixeyũ bit o'e. — Katpuje jĩjã o'e kuy. Kabiog̃ wuyju — io'e xepxepayũ Jesus pe. Imẽnpuye Jesus o'ju ceweju ip cexe ip jenũy ã. Oõm ip tuk'a be. ");
INSERT INTO myu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","G̃ebuje Jesus pão'a o'yabu jekõn pima ceweju ip. — Bay, ẽn xipat — io'e Deus pe. O'yadakatkat. O'yaũm cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jetaan ip o'jeak. Teku Jesus iam itaybit ip o'e. Imẽnpit Jesus o'jepa'ũm. ");
INSERT INTO myu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","— Oca'õxabida karabakbakãn oce'e e dag̃ oceweju kawẽnwẽn pima, Deus ekawẽn muwẽnuwẽn pima — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","G̃ebuje o'jẽm ip mesa bewi. Aripit. O'jepit ip Jerusalém ka kay. Jay. Oajẽm ip. G̃ebuje onze beayũ o'tobuxik ip―jebureyũ. Awerom ip o'tobuxik. ");
INSERT INTO myu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","— Wuykukukat waram o'jetait — io'e ip xepxepayũ be. — Simão itaicat o'jojojo — io'e ip. ");
INSERT INTO myu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","G̃ebuje xepxepayũ apẽn Jesus o'e cebe ip iap o'g̃uwẽn jebureyũ be. — Jesus o'jebapuk ocekay e dag̃ — io'e ip. — Pão'a dakat puje, ocetaybit oce'e teku Jesus iam — io'e xepxepayũ cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dao ma Jesus o'jebapuk aweromayũ kay imẽn kawẽnwẽn pima ip. — Kaba'ũm cuy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","O'jekuy ip. Iparara jĩjã ip o'e. Tũybe axik iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","— Apẽnpuye eykuykuykuy? — io'e Jesus. — Apẽnpuye eyju e'em “Cẽm tu Jesus waram o'jetait?” i? Apẽnpuye eyetabut g̃u okay? — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","— Ak epe'e obu kay, wui kay dak. G̃oku tapoa kuybut — io'e. — Obu kukug̃ cuy epe'e — io'e. — Wui kukug̃ tak cuy epe'e. Asubit'ũm! Axik tu õn eyxe? Axik taohe g̃u. Õn pit odaohe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Imẽn e'em pima, o'jewebumubapuk cebe ip. O'jeweimubapuk. ");
INSERT INTO myu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Imẽnpit itabut g̃u ma buk o'e ip Jesus kay jecokcok pibun, yag̃uybabi'ũm'ũm ip puye. — Ajo opop eyxe i'o am? — Jesus tak o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Axima yoyoy o'g̃ũm ip cebe i'o am. ");
INSERT INTO myu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O'jat. Etabutpe ip o'jo'o. ");
INSERT INTO myu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","G̃ebuje o'jekawẽn ceweju ip. — Moisés apẽn warẽmtag̃ itakomaayũ okuk iaptup o'tupmubararak, Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm tak — io'e. — Davi dak apẽn warẽmtag̃ ip okuk iaptup o'tupmubararak Salmodup pe―jebibododonaptup pe — io'e. — Ixeyũ'ũm'ũm emudupmubararakatup pe iap tag̃ ma ip okuk ikẽrẽm — io'e. — Eyweju õn pima iboap og̃uwẽn eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ixeyũ mutaybitbin o'e apẽnape Deus ekawẽn iam. ");
INSERT INTO myu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","— Imẽn e'em ig̃odup: Deus emunaẽ juy ipiat supi'ajo, i. Je'ũ juy, i. Xepxep xet kap puje, waram jetait g̃uto, i. ");
INSERT INTO myu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ixe a'õbi itabucayũ juy kawẽn idipat g̃uwẽn soat ka watwat pe, i. Koap Jerusalém ka watwat pe juy g̃uwẽn ip, i. G̃uyjom wara'atka watwat pe juy g̃uwẽn ip, i. “Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere,” i juy je'e ip, i. “Ikẽrẽat mujurũg̃rũg̃ap epere buje, Deus ikẽrẽat ju'uk eywebewi,” i juy je'e ip, i. Imẽn e'em ig̃odup, — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","— Wekawẽn epeya'ĩjojo. We'ũap tak epejojojo ma. Soat ka watwat pe juy iboap epeg̃uwẽn — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","— “Jeya'õmucan õn,” io'e webay eywebe — io'e. — Webay a'õbi õn jeya'õmucan — io'e Jesus. — Deus pe eya'õmucanap wiwim cuy epesop ikabog̃atka be―Jerusalém ka be — io'e. — G̃axĩn ma juy jeya'õmucan — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesus ixeyũ o'tujowat Betânia ka be. G̃ebuje o'jekawẽn Deus eju cebeam ip. — Bay, xipan cuy teyũku ejukuk — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bosusu o'ju cexewi ip Deus eju kawẽnwẽn pima. G̃ebuje Deus o'tujowat jewekay, kabi kay. ");
INSERT INTO myu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","— Bay, ẽn xipat cĩcã — io'e ip Deus pe tujowacap cocoayũ. — Ka'ũma ma ejo'iat ya'õbacaat — io'e ip cebe. G̃ebuje o'jepit ip Jerusalém ka kay. Icokcok cĩcã ip osodop. ");
INSERT INTO myu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Deus eju kawẽnwẽnap'a be osodop ip soat em―yabog̃at'a be. — Bay, ka'ũma ma ejo'iat ya'õbuyxiat — i'e'em ip osodop.");
INSERT INTO myu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jesus Cristo oajẽm Deus mubapuk am ijodiayũ be. Ipi mug̃ẽ awap Deus mubapukpuk'ukat kuy osunuy. Deus xe osunuy. Deus co'i osunuy. ");
INSERT INTO myu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ixe Deus xe osunuy ipi mug̃ẽm pima. ");
INSERT INTO myu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Deus eju ixe soat o'g̃ug̃e―ipi dag̃at, kabi beat tak. Ka'ũma ma kajuk o'e ipi dag̃ ixe imujurũg̃'ũm pima. ");
INSERT INTO myu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja'õbi dak ixe itabẽg̃ayũ mujurũgrũg̃'uk osunuy. Ixe icẽmãn wuymutaybitbin'uk osunuy Deus ekawẽn―apẽn kaxi wuymukabiahamap puxim. ");
INSERT INTO myu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ixe oajẽm ijodi Deus ekawẽn wuymutaybin am. Ade jĩjã ikẽrẽat mujurũg̃rũg̃'ukayũ osodop ijodi. Imẽnpit ixe ekawẽn muwẽnmu'ũm pa'ore osodop ip. ");
INSERT INTO myu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ixe ajẽm awap Deus warara'acat o'g̃udot ijodi ag̃okatkat. Ja'õbi o'g̃udot. João i ibutet osunuy. ");
INSERT INTO myu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Oajẽm Jesus Cristo muwẽn ãm―kabiaap puximat muwẽn ãm ijodiayũ be. Ixe o'g̃uwẽnuwẽn adeayũ mutabun am cekay. ");
INSERT INTO myu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João ma ixe Deus mubapukpuk'ukat g̃u osunuy. Oajẽm ixe muwẽn ãm acã. ");
INSERT INTO myu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","— Ixe kawẽn icẽmat wuymutaybitbin je'e — io'e João. — Ixe jajẽm ijodi — io'e João. — Soat mutaybitbin jeku Deus ekawẽn — io'e João. ");
INSERT INTO myu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Deus mubapukpuk'ukat oajẽm ipi kay. Ijodi oekuku. Soat ipi dag̃acat ixe emumug̃ẽ osodopdop ip. Inaka ibu'u o'e ip jetabun cekay. ");
INSERT INTO myu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jebadipyũ kay oajẽm―Judeuyũ kay. Inaka itabut g̃u o'e ip cekay. ");
INSERT INTO myu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Warara'acayũ bit ixe kay osodop ip. Itabut ip osodop ixe kay. Imẽnpuye: — Deus ebekitkiyũ eyju g̃asũ, okay eyetabut puye — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bekitkit jebapukpug̃ ijodi ayacat'uk pewi kapkam puye; ag̃okatkat aoyũ dabi'o pin e'em puye dak; ag̃okatkat jekpot mujurũg̃ pin puye dak. Imẽn g̃u bit wuyju Deus ebekitkin e'em. Ijodiayũ Deus ebekitkin e'em Deus ibikuy buye acã. ");
INSERT INTO myu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Deus mubapukpuk'ukat ijodian o'e. Jesus Cristo ijodian o'e. Wuyxe osunuy. Pũg̃ ma Deus ipot osunuy. Wara'at ka'ũmg̃u―ixe acã. Ijodiayũ ikẽrẽat mujurũg̃rũg̃ oekuku. Inaka ixe xe ikukpin cĩcã osodop ip. Icẽmãn ixe Deus ekawẽn wuymutaybitbin'uk osunuy. Imẽneju: — Warara'acat podi ma teku idip — i juy ace'e'e wuyewewebe. ");
INSERT INTO myu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Batista abu Deus mubapukpuk'ukat iap muwẽnuwẽn oeku adeayũ be. Ixe imẽn o'e: Omuykuiat ma ya'õbuyxi, i. Õn pit ka'ũma, i. Okap awap ixe itabẽg̃ osunuy iwag̃o ma'g̃u õn, i. Imẽnpuye obodi ma ya'õbuyxi ixe ma, i. Ixe kuy og̃uwẽn eywebe, io'e — João o'e. Imẽn abu Deus mubapukpuk'ukat iap muwẽnuwẽn oeku João Batista. ");
INSERT INTO myu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Soat kabia ixe xe wuykukpin cĩcã ikẽrẽat mujurũg̃rũg̃ ma'g̃u wuyju. Soat podi ma xipan wuykug̃, ixe xe wuykukpin puye. ");
INSERT INTO myu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","— Eyju cũg̃ ma Deus xe cekawẽn tag̃ jekukum pima — i juk adi o'e'e Moisés'ũm wuydobuyũ'ũm'ũm pe. — Deus xe eykukpin cĩcã ikẽrẽat mujurũg̃rũg̃ ma'g̃u eyju — i juk adi o'e'e Jesus Cristo bit. Ixe kawẽn icẽmat muwẽnuwẽn oekuku. ");
INSERT INTO myu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka'ũma ma Deus o'jojojo buk. Ixe ipot pũg̃ ma. Ipot acã o'jojojo. Ipot ikukpin cĩcã jebay mubapukpuk'uk osunuy wuywebe. Deus mubapukpuk'ukat ixe. ");
INSERT INTO myu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","28","Judeuyũ kukukayũ jepaĩyũ o'g̃uju João Batista kay. O'g̃uju ip jekawẽn ãm ceweju. Jerusalém ka beayũ osodop ip ixeyũ Judeuyũ kukukayũ. Paĩyũ buywatwat'ukayũ dak o'g̃uju ip. Levitayũ i ibuywatwat'ukayũ butet osunuy. Fariseuyũ ixeyũ o'g̃uju João kay. Betânia ka xe o'jekawẽn ip. Jordãodi wĩnãbu o'jekawẽn ip. João iboceayũ mubatisasan osunuy ijudi be. Oajẽm ip João kay. Jay. João ibu'u g̃u o'e jekawẽn ãm ceweju ip. — Abu ẽn? — io'e ip João be. — Cristo g̃u õn — io'e João. — Ijodiayũ daxijojo'ukan Deus emunaẽ g̃u õn. — Abu ẽn? — io'e ma'g̃uto ip. — Elias du ẽn? — io'e ip. — Deus ekawẽn muwẽnuwẽn'ukat tu ẽn? Waram g̃uto du ekop ocekay? Kuyjeat tu ẽn? — io'e ip cebe. — Ka'ũma — io'e. — Elias g̃u õn. — Deus ekawẽn muwẽnuwẽn'ukat tu ẽn―ocemumuwiwiiat? — io'e ip. — Ka'ũma — io'e. — Eyemumuwiwiiat g̃u õn — io'e. — Abu ẽn? — io'e ma'g̃uto ip. — Abu ẽn iap cuy eg̃uwẽn ocewebe. Abu ẽn iap muwẽn pin oceju ocemudocayũ be — io'e ip João be. — Uk'a'ũmat pe wuyjuyũ mukũyjojom pit õn — io'e João. — “Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere,” i õn e'em cebe ip. “Wuykukukat jajẽm,” i õn e'em. “Kũyjobin cuy epesop ya'õ kay,” i õn e'em cebe ip — io'e. — Imẽn õn e'em cebe ip Isaías ekawẽn tag̃―kuyat ekawẽn tag̃―Deus ekawẽn muwẽnuwẽn'ukat ekawẽn tag̃ — io'e. — “Deus ekawẽn muwẽnuwẽn'ukat g̃u õn,” i juk ece ocewebe, “Eymumuwiwiiat g̃u õn,” i dak, “Elias g̃u õn,” i dak — io'e ip. — Apẽnpuye dak ẽn wuyjuyũ mubatisasan? — io'e ip. — Õn ma ijodiayũ mubatisasan idibi be — io'e João. — Wara'at pit omuy wuyparakpe. Eyetaybit g̃u ixem. Deus ekawẽn eymutaybitbin cuk adi ojekuku. G̃asũ bit ixe jeymutaybin. Omuykuiat ya'õbuyxiat. Õn pit ixe jo'i'ũmg̃u. Wa'õbuyxi g̃u õn pit ixe buxim — io'e João. ");
INSERT INTO myu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kuyaje João jekay Jesus ajẽmap o'jojojo. — Ak'i juy epe'e! — io'e João adeayũ be. — Teku Deus emunaẽ. Paĩyũ cordeiro aokaka'uk osodop ip ikẽrẽat uk am wuydobuyũ'ũm'ũm pewi — io'e. — Imẽnpuxim teku je'ũ ikẽrẽat uk am wuywebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","— Ixe og̃uwẽn eywebe kapusu — io'e. — “G̃asũ bit wara'at Deus ekawẽn jeymutaybin,” i juk oce eywebe. “Okap awap ixe kuy itabẽg̃ osunuy iwag̃o ma'g̃u õn,” i juk oce eywebe. “Imẽnpuye ixe ya'õbuyxiat. Õn pit ixe jo'i'ũmg̃u. Wa'õbuyxi g̃u õn pit” i juk oce eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","— Õn pit wetaybit g̃u og̃uy abu ixe osunuy iam. Imẽnpit Israel naxeg̃ebitbit mutaybin ojuy og̃uy abu Deus emunaẽ iam. Imẽnpuye ojot ijodiacat mubatisasan — io'e. — Õn pit wetaybit g̃u og̃uy abu ixe iam — io'e João. — Imẽnpit Deus cuk o'e owebe: “Obiõg̃buk je'kop wemunaẽ kay,” i. “Ixe be jeedop,” i. “Ixe epejojojo,” i. “Ixe jebiõg̃buk g̃uõm ijoceayũ be,” i. Imẽn omudocat cuk o'e owebe — io'e―João o'e. Imẽn João Jesus muwẽnuwẽn oekuku. — Deus biõg̃buk ojojojo — io'e João. — O'kop kabi kadiwi. Pukaso jo'i osunuy ibiõg̃buk. Jesus abi jeje o'jecũg̃ — io'e João. ");
INSERT INTO myu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","— Ixe ma ojojojo. Ixe Deus ipot. Iboap og̃uwẽn eywebe — io'e João iboceayũ be. ");
INSERT INTO myu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kuyaje João Batista waram Jesus o'jojojo. João cũg̃'i osunuy jeweju etaybitbinayũ eju―xepxepayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus cũg̃cũg̃ o'e cewap ip. — Ak'i juy epe'e! — io'e João. — Teku Deus emunaẽ — io'e. — Cordeiro e'ũap co'i teku je'ũ ikẽrẽat uk am wuywebewi — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iboap co buje, Jesus kay o'ju ip João eju etaybitbinayũ―xepxepayũ. João ip o'suiwat Jesus kay jeju am. ");
INSERT INTO myu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus o'jekorepẽn. — Ajo-kudadam eyju? — io'e Jesus. — Ocemutaybitbin'ukat, poce ẽn? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","— G̃a'a onuynuyap'a kay aju — io'e Jesus. O'ju ip Jesus eju. Oajẽm ip Jesus nuynuyap'a be. Katpuje ip oajẽm―16 hora bima. Uk'a be ip oõm. Jesus eju ip osodop ixe kabia. ");
INSERT INTO myu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pũg̃ ma ixeyũ'in André i osunuy―xepxepayũ'in. André kuy João ekawẽn itaybit osunuy. Imẽneju Jesus eju o'ju. Ixe André Simão kitpit osunuy. ");
INSERT INTO myu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","G̃ebuje André o'ju Simão kay―jewag̃o kay. — Cristo ocetobuxik — io'e Simão be. (Wuydaxijo am Deus emunaẽ iape Cristo.) ");
INSERT INTO myu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O'tujowat Jesus kay. Jesus Simão o'jojojo. — Ẽn aco'i Simão — io'e. — João ipot aco'i ẽn. Wara'at ebuten g̃asũ — io'e. — Ojomõg̃ ebuten. Céfo i ebuten je'e — io'e Jesus. (Céfo Pedro iape Grego a'õm, wita'a iape Mundurukú a'õm). ");
INSERT INTO myu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kuyaje: — Cum puk õn Galiléia eipi kay — io'e Jesus. Jesus Filipe o'tobuxik e dag̃ pima. — Filipe, oweju juy ejeku — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe Betsaida ka bewiat osunuy, André dak, Simão Pedro dak. Pũg̃ka bewiat ip osodop. ");
INSERT INTO myu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","G̃ebuje Filipe Natanael o'tobuxik. — Deus emunaẽ ocetobuxik — io'e Natanael be. — Moisés ixe muwẽg̃aptup o'tupmubararak kuyje — io'e. — Deus a'õbi o'tupmubararak. Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm tak ixe muwẽg̃aptup o'tupmubararak. Jesus i ibutet. José'ũm ipot ixe, Nazaré ka bewiat — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","— Apẽn ẽn e'em? — io'e Natanael. — Nazaré ka bewi g̃u Deus emunaẽ jajẽm — io'e. — Ejot cuy ijom — io'e Filipe bit. ");
INSERT INTO myu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus Natanael o'jojojo ajẽm pima. — Ak'i juy epe'e — Jesus o'e jewejuacat pe. — Teku Israel naxeg̃ebit — io'e. — Wuymug̃uykukuku'ukat g̃u teku! Icẽmãn e'e'ukat ma teku! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","— Ẽn pit ojojo g̃u buk — io'e. — Apẽntak ẽn etaybit õn? — io'e Natanael. — Filipe be enomuwã buje õn ejojo wũy ma'g̃u ẽn — io'e Jesus. — Ẽn figueira'ip kabicuk pe bima ejojo õn — io'e. — Wa'õbacaam õn ejojo — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","— Ocemutaybitbin'ukat — io'e. — Ẽn ma Deus ipot — io'e. — Icẽmãn ẽn ma Israel naxeg̃ebitbiyũ kukukat — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","— Etabut okay, “Ẽn figueira'ip kabicuk pe bima ejojo õn,” i juk oce buye. “Jesus itaybit cĩcã,” i ẽn e'em. G̃uyjom pit obacaap ojomõg̃ ijodiacayũ be. Iboap epejojojo. “Soat podi ma Jesus ya'õbaca,” i ece g̃ebuje bit — io'e. ");
INSERT INTO myu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","— Icẽmãn õn e'em eywebe — io'e Jesus soat pe ijodiacayũ be. — Soat wag̃o õn — io'e. — Koce'i je'e kabi. Deus ekawẽn tojotjot'ukayũ je'kop okay. Jeu dak ip oxewi. Soat iboap epejojojo — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Xepxep xet kap puje Jesus o'ju jewebumũnap epeta kay. O'ju jeweju etaybitbinayũ eju―12 beayũ eju. Judeuyũ peta mug̃ẽg̃ẽ'uk osodop ip jewebumũn puje. Caná ka be peta o'g̃ug̃ẽ. Ibo ka Galiléia eipi be o'sukadop. ");
INSERT INTO myu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesusyũ juk o'tomuwã ip. Ixi dak o'ju ceweju ip. ");
INSERT INTO myu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","G̃ebuje uva'abidi kay o'e ip o'ti'ũm puye. — Uva'abidi o'ti'ũm — io'e ixi Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","— Aĩ — io'e Jesus. — I'e but g̃u iboap owebe. G̃asũ bit cũg̃ g̃u owebe Deus a'õbacaap mõg̃ ãm. ");
INSERT INTO myu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","G̃ebuje ixi o'ju peta iwat a'õbuywatwat'ukayũ kay. — O'it a'õ kay juy epe'e — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Idibi mũn'a o'yadop iboce 6 be. Wita'a mug̃ẽg̃ẽ o'yadop yabog̃at'a. 80 litro opop pũg̃'a be idibi, 100 litro dak. Judeuyũ jewebuwuywuy'uk ip osodop jekõn puje, jekõn epere buje dak. Jevasília wuywuy'uk osodop ip soat em. Imẽnpuye ti'ade o'tidop ig̃o'a be. ");
INSERT INTO myu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O'jekawẽn ibuywatwat'ukayũ be ixe Jesus. — Idibi juy epetibu ite'a munopapũn ãm―pote'a munopapũn ãm — io'e. — Epeyamunopapũnpũn cuy ip idibim — io'e. Idibi o'eimuõm ip pote'a be. Yanopapũn o'e. ");
INSERT INTO myu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","— Ti'in cuy epeti'uk yabewi — Jesus o'e cebe ip. — Eyekariwa kay juy epetidujowat — io'e. O'ti'uk ip yabewi. O'tidujowat ip jekariwa kay. ");
INSERT INTO myu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Idibim g̃u o'e. Uva'abidim o'jediewexat. Peta iwat o'tikõn. Peta iwat ma itaybit g̃u o'e abu o'timuwexat uva'abidim iam. O'ti'uk'iayũ bit itaybit o'e. G̃ebuje peta iwat jewebumũniat o'tomuwã. ");
INSERT INTO myu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","— Soat oceju koam tikujĩjãti ũmũm ocebureyũ be. Ibeg̃beg̃ ip pima, oceju tikõõmati ũmũm cebe ip. Ẽn pit imẽn g̃u e'em. G̃asũ acã tikujĩjãati ũmũm ẽn ocewebe! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Imẽneju ceweju etaybitbinayũ oitabun cekay. — Deus a'õbacaap kug̃ teku — io'e ip. Jesus idibi o'timuwexat uva'abidim. Jesus koam wuywebe i'e ba'oreat o'g̃ubapuk Caná ka beayũ etabutpe Galiléia eipi be. Õn Deus a'õbacaap kug̃ iap o'g̃ubapuk adeayũ be. ");
INSERT INTO myu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iboap tomukadi Jesus o'ju Cafarnaum ka be. O'ju jexi eju, jekitpityũ eju dak, doze beayũ eju dak. Ade xet g̃u osodop ip ig̃o ka be―pũg̃pũg̃ ã. ");
INSERT INTO myu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","G̃ebuje o'ju Jerusalém ka kay jeweju etaybitbinayũ eju. O'ju ip Judeuyũ epeta kay. Peta mujurũg̃rũg̃'uk osodop ip Judeuyũ jeg̃ebu am Egito eipi bewi Deus wuydobuyũ'ũm'ũm o'tujujẽm iap kay. Páscoa i ig̃o epeta butet osunuy. ");
INSERT INTO myu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O'ju Deus eju kawẽnwẽnap'a kay―yabog̃at'a kay. Oajẽm. Oõm. Adeayũ o'jojojo ya be. Biopak teidada'ukayũ o'jojojo uk'a naxirõg̃ pe. Carneiro teidada'ukayũ dak o'jojojo. Pukaso deidada'ukayũ dak o'jojojo. Soat ip o'jojojo yanaxirõg̃ pe. Ajẽmjẽmayũ edinheiro mutrokakan ip osodop warara'acayũ. ");
INSERT INTO myu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus oitakomãn uk'a beacat kay. Ixibu o'subumukirik bõrõbum. Iõhõyũ o'g̃uwat ya bewi soat. Bioooh. Aki kay o'g̃ujẽm. Dinheiro mutrokakan'ukayũ dak o'g̃ujẽm. Biopak deidada'ukayũ dak o'g̃ujẽm. Carneiro deidada'ukayũ dak o'g̃ujẽm. Soat ip o'g̃ujẽm. Bug̃. Dinheiro mutrokakan'ukayũ emesa o'g̃uy'at. Duooooh. O'jedu. Soat o'g̃udu dinheiro isurũg̃at mesa bewi. ");
INSERT INTO myu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","— Soat cuy epetujujẽm ite'a naxirõg̃ pewi! — io'e Jesus pukaso deidada'ukayũ be. — Webay duk'a be g̃u juy epeteidada! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","O'jeg̃ebu ip Deus ekawẽn kay doze beayũ. Ibodup pe ibararak opop: Bay, ijop'a eduk'a! i. Inaka warẽmtag̃ e'em ip ite'a be, i. Imẽnpuye wetakoma jĩjã, i. ");
INSERT INTO myu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","G̃ebuje Judeuyũ kukukayũ o'jekawẽn Jesus eju. — Abu-a'õbi iteyũ eg̃ujẽm Deus eju kawẽnwẽnap'a bewi? — io'e ip Jesus pe. — Deus a'õbacaap cuy ejomõg̃ ocewebe — io'e ip. — Iboap mõg̃ puje, “Cũg̃ ma cebe iteyũ mujẽm ãm,” i kuka oce'e — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","— Eywebe Deus eju kawẽnwẽnap'a muy'at puje, wara'at'a juy oyamuy õn ma — io'e Jesus. — Xepxep xet kap puje, wara'at'a oyamuy uk'a — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","— Iba'ore ewebe wara'at'a muy ãm xepxep xet — io'e ip. — Oceju ite'a muymuy ade koato―46 koato — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesus ekawẽn cekawẽn pa'arẽm o'e cexe ip. “Uk'a” i'e buje, jejebit o'g̃uwẽn Jesus. ");
INSERT INTO myu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ce'ũ'ũayũ xewi Deus pe Jesus muyu buje, Jesus ekawẽn kay o'jeg̃ebu ip doze beayũ. — Deus ekawẽntup pe ibararak icẽmãn — io'e ip. — Jesus icẽmãn o'e'e ocewebe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Adeayũ oitabun Jesus kay ixe Jerusalém ka be bima―Judeuyũ Páscoa epeta mug̃ẽg̃ẽm pima. Õn Deus a'õbacaap kug̃ iap o'g̃ubapukpuk Jesus. Iboap co buje itabut o'e ip cekay. Imẽnpit Pũg̃pũg̃ayũ yopĩt ma itabut o'e. ");
INSERT INTO myu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesus pit itaybit osunuy apẽn ixeyũ jewag̃uyg̃uy iam. Imẽnpuye ibapug̃ g̃u o'jewemuwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Abu-be Jesus e'em: — Apẽn teku jewag̃uyg̃uy — i? Ka'ũma be ma. Jewewebe ma itaybit osunuy. ");
INSERT INTO myu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ixima be Nicodemos oajẽm Jesus kay. Nicodemos ya'õbuyxiat osunuy. Judeu osunuy. Fariseu osunuy. — Ocemutaybitbin'ukat — io'e Jesus pe. — Ocetaybit ẽn ocemutaybitbin'ukat iam. Wuywebe i'e ba'oreat mubapukpuk'ukat ẽn. Deus a'õbacaap mõg̃mõg̃'ukat ẽn. Abu-be Deus a'õbacaap mõg̃ put? Deus bikuyap tag̃ jekuku'ukat pe acã! Ocexe ẽn Deus xewiat — io'e Nicodemos. ");
INSERT INTO myu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","— Icẽmãn õn e'em ewebe — io'e Jesus. — Waram eykap'ũm pima, iba'ore Deus pe eykukan — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","— Apẽn kuka dak waram akap aypa bima? Iba'ore! — io'e Nicodemos. — Waram xe'e kuka aõm wuyxi uk pe? Iba'ore! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","— Aoyũ uk pewi wuykap puje, wuyebay ipotpoyũm acesop — io'e Jesus. — Deus biõg̃buk a'õbi bit Deus ebekitkiyũm acesop. Wuyag̃uyisum aceku. Icẽmãn õn e'em ewebe — io'e Jesus. — Idibi be eymubatisasan'ũm pima Deus eykukukan g̃u je'e, Deus biõg̃buk eywebe'ũm pima dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","— “Deus ebekin cuy eg̃uy,” i õn e'em ewebe — Jesus o'e. — “Ag̃uyisum cuy ejeku,” i õn e'em ewebe. Ag̃uybabi'ũm g̃u juy eg̃uy wa'õ kay — io'e Nicodemos pe. ");
INSERT INTO myu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","— Kabido jekpiwan ma pidojujum. Kabido a'ĩjojom pit wuyju. Eyetaybit g̃u poma pidojujum iam, pomawi o'subidodot iam tak. Imẽnpuxim eyetaybit g̃u dak apẽn kuka Deus ebekitkiyũm acesop ibiõg̃buk a'õbi iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","— Apẽn paxi kuka o'jebapuk? Ekawẽn pa'arẽm oxe — io'e Nicodemos. ");
INSERT INTO myu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","— Ẽn Israel naxeg̃ebitbit mutaybitbin'ukat―Judeuyũ mutaybitbin'ukat — io'e Jesus. — Ẽn pit a'õbuyxi adeayũ xe. Apẽnpuye dak wekawẽn pa'arẽm exe? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","— Icẽmãn õn e'em ewebe — io'e Jesus. — Wetaybicap muwẽnuwẽn õn. Kuy ojojojoiat muwẽnuwẽn õn. Inaka ẽn wekawẽn kay g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","— Ipi dag̃ayũ e'eap muwẽnuwẽn pima, etabut g̃u wekawẽn kay. Kabi beayũ e'eap muwẽn puje, iboap kay dak etabut g̃u kuka epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","— Warara'acat g̃u o'kop kabi kadiwi o'jojojoiap muwẽn ãm ipi dag̃acat pe. Õn acã okop — io'e. — Soat wag̃o õn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","— Moisés puybujo'iatpu o'subumu'ãy ip-takũbi dag̃―bronze mug̃ẽg̃ẽbu. Uk'a'ũmat pe o'subumu'ãy kuyje. Ig̃obu kay ceak'ibiyũ oe'ũ g̃u puybu nuy pibun. O'je'ada ip soat. Imẽnpuxim itakomaayũ obamupaya korosa be we'ũ ãm. Soat wag̃o õn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","— Okay itabucayũ yag̃uyisum jeku g̃asũ―soat ip. Soat em itait jeedop ip Deus xe je'ũ buje dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","— Deus xe wuykukpin cĩcã ajop. Imẽnpuye jekpot o'g̃udot wuykay. Pũg̃ ma ipot. Ixe ipot kay wuyetabut pima, soat em g̃u wuye'ũ acesop. Ce'ũ'ũayũm g̃u acesop. Waram acejetait. Soat em wuyetait acesop Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","— “Ipiat osupi'ajoat eywebe ikẽrẽat kug̃ eyju oxe buye,” i'e ojuy g̃u Deus. Imẽnpuye jekpot o'g̃ukop ipi kay. O'g̃udot ipi dag̃ayũ daxijo am ipiatpi'ajojoap kay cuap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","— Deus ipot pũg̃ ma. Deus e'em g̃u “Ikẽrẽat kug̃ eyju oxe,” i jekpot kay itabucayũ be. Deus kuy o'e “Ikẽrẽat kug̃ eyju oxe,” i itabut'ũmayũ be bit, jekpot kay itabut'ũm puye. ");
INSERT INTO myu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Deus ipot osodot ipi kay apẽn ikẽrẽat Deus xe iap mubapuk am wuywebe, apẽn cũg̃ ma iap mubapuk am tak. Ixe kabiaap puxim. Ijodiayũ bit ikẽrẽat mujurũg̃rũg̃. Kabiok tag̃ jekuku'ukat puxim ip. Imẽnpuye ip ibu'u jetabut am Deus ipot kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","— Ikẽrẽat mujurũg̃rũg̃'ukayũ ibu'u jĩjã jemutaybinan ajo ikẽrẽ Deus xe iam. Imẽnpuye Jesus ekawẽn a'ĩjojom g̃u ip. Ibu'u jĩjã ip warara'acat pe itaybit am ikẽrẽat mujurũg̃rũg̃ teyũku iam. Kabiok tag̃ jekuku'ukat puxim ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","— Idipat mujurũg̃rũg̃'ukayũ bit itabut Deus ipot kay, õn pit Deus ekawẽn tag̃ jekukum iap mubapuk am warara'acat pe. Kabia dag̃ jekuku'ukat puxim ip — io'e. Imẽn Jesus o'jekawẽn Nicodemos eju. ");
INSERT INTO myu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","G̃uyjom Jesus o'ju Judéia eipi kay. Jeweju etaybitbinayũ eju o'ju―doze beayũ eju. Iboceayũ mubatisasan osodop ip. ");
INSERT INTO myu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João Batista dak Enom ka be osunuy. Imubatisasan ip osunuy iboceayũ mutaybit am teyũku João Batista ebekitkiyũ iam. Salim ka xe osunuy tibog̃ puye. Adeayũ cucum o'e João kay. Imẽn João imubatisasan ip osunuy, ");
INSERT INTO myu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","daomũnmũnap'a be g̃u buk puye. ");
INSERT INTO myu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","João eju etaybitbinayũ o'jewa'õxikxik ip Judeu eju. — Abu g̃u cũg̃ ma wuyjuyũ mubatisasan teyũku webekitkiyũ iap mubapuk am? — io'e ip jewewebe. — Jesus g̃u xe'e? — io'e ip. — João Batista g̃u xe'e? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Imẽnpuye o'jekawẽn ip João eju. — Ocemutaybitbin'ukat — io'e ip. — Ag̃okatkat iboceayũ mubatisasan g̃asũ! Kuy bima ixe oceweju oeku Jordão wĩnãbu bima — io'e ip. — Ixe juk adi eg̃uwẽn ocewebe — io'e ip. — Soat iboceayũ cum cekay acã oceju ixe ebekitkiyũm g̃asũ bit i'e am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","— Ocokcok cĩcã adeayũ cum Jesus kay buye — io'e João bit. — Deus acã wuymõg̃mõg̃ wuya'õbuyxian — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","— “Õn pit Cristo g̃u―Deus emunaẽ g̃u õn,” i juk adi oce eywebe — io'e João. — “Deus acã omudot tot awap,” i juk adi oce eywebe. Kuy wekawẽn epeya'ĩjojo — io'e João. ");
INSERT INTO myu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","— Wuyewebumũn puje jewebumũnat jetayxi bum — io'e João. — Jewebumũnat pure bit jewebumũnat xe nuynuy. Ibure icokcok e'em jewebumũnat icokcok puye. Jewebumũnat pure buxim õn — io'e João. — Õn tak ocokcok cĩcã adeayũ cum Jesus kay ya'õkayayũm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","— Ade jĩjã je'e ip Jesus a'õ kayayũm. Wa'õkayayũ bit ade g̃u je'e ip―pũg̃pũg̃ ã. Imẽnpit ocokcok cĩcã — io'e João. Imẽn João o'jekawẽn jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kabi kadiwi oajẽmiat itaybit cĩcã. Soat podi ma itaybit. Ipi dag̃at pit ka'ũma. Itaybit ipi dag̃ayũ e'e am. Ipi dag̃ayũ e'e am acã kawẽnwẽn. Kabi bewiat pit itaybit cĩcã. ");
INSERT INTO myu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O'jojojoiap muwẽnuwẽn ixe. O'ya'ĩjojoiap muwẽnuwẽn tak. Inaka pũg̃pũg̃ acã itabut ya'õ kay. ");
INSERT INTO myu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ixe a'õ kay itabucat pit e'em: — Deus cũg̃ wuykug̃ — i soat pe jebureyũ be. ");
INSERT INTO myu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Deus emumudot Deus ekawẽn muwẽnuwẽn. Cebay tacup g̃u. Jebiõg̃buk muõmõm jekpot pe. Imẽnpuye soat em jebay biõg̃buk a'õbi jekukum ipot. ");
INSERT INTO myu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Deus xe jekpot kukpin cĩcã. Imẽnpuye soat ja'õbacaap o'g̃ũm jekpot pe. — Okpot pit wa'õbaca jo'i — io'e Deus. ");
INSERT INTO myu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Deus ipot kay itabucat yag̃uyisum jeku ijodi bima. Ce'ũ buje itait jeenuy Deus xe. Itabut'ũmat pit Deus xe g̃u ma jeenuy itait. Soat em Deus itakoma jĩjã cekay―ja'õ kay kũyjobit'ũmat kay. ");
INSERT INTO myu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ibocewi Jesus o'jẽm Judéia eipi bewi, Fariseuyũ Jesus awẽg̃ o'yawẽg̃tobuxik puye. Adeayũ juk Fariseuyũ o'g̃ukũyjojo. — Ade g̃u João Batista eju etaybitbinayũ — io'e Fariseuyũ be. — Jesus eju etaybitbinayũ bit ade jĩjã — io'e ip. — Ade iboceacat mubatisasan Jesus — i napa ma o'e ip. Imẽnpit Jesus g̃u iboceacat mubatisasan osunuy idibi be―ceweju etaybitbinayũ acã. Jesus epit ojuy Galiléia eipi kay jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","— G̃a'a aju Samaria eipi dag̃ — io'e Jesus. — G̃a'a — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ibocewi oajem ip ag̃oka be―Sicar ka be. Kuyje Jacó jekat o'g̃ũm jekpot pe―José be. Sicar ka José katpuk tẽg̃ ma o'sukadop. ");
INSERT INTO myu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jesus o'ju idibikũy kay. Ig̃okũy Jacó juk o'sukũykocat kuy bima. Jesus taopipi o'e cũg̃cũg̃ãm. Jebodoy am oabik. Oabik idibikũy xe o'sukopibareren puye. Kaxicug̃ o'e. ");
INSERT INTO myu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesus eju etaybitbinayũ o'ju ag̃oka be jexat pum. Ijẽm ip puje, ayacat oajẽm ikũy be―Samaria eipi beat. Idibi bu ojuy oajẽm. G̃ebuje Jesus o'jekawẽn ayacat eju. — Etibu buk wekõnaptim — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","— Ap! — io'e. — Ẽn Judeu. Õn pit Samaria eipi beat — io'e ayacat. — Apẽnpuye ẽn e'em owebe “Etibu buk wekõnaptim,” i? — io'e. Judeuyũ ibu'u jĩjã osodop Samaria eipi beat ewa'e bewi jekõn ãm. Imẽnpuye ayacat o'e ibu'u jewa'e beati ũm Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","— Deus tei'ũma iũmũm wuywebe. Etaybit g̃u iboam — io'e. — “Etibu buk wekõnaptim,” i oce ewebe. Etaybit g̃u dak abu õn iam — io'e. — Etaybit õn ibima, “Etibu buk wekõnaptim,” i kuka ece owebe. Oxewi tiojuyjuy bima, ekõnaptim kuka otiũm ewebe. Itedi kõn puje, ag̃uyisum eceku. E'ũ buje dak soat em etait ecesũy Deus xe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","— Tapu — io'e. — Tibubuap kug̃ g̃u ẽn — io'e. — Ikũyberen cĩcã idibikũy. Pomawi kuka ig̃odi etibu―wuymutaiticapti? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","— Ocedobu'ũm ya'õbuyxi osunuy―Jacó'ũm — io'e ayacat. — Soat xe ya'õbuyxi osunuy. Ixe'ũm itekũy o'sukũykocat ocewebeam kuyje. Ixe Jacó'ũm tikõnkõn'uk osunuy itekũy bewiati. Cebekitkiyũ dak tikõnkõn'uk osodop, iõhõyũ dak. Ya'õbuyxi osunuy ixe'ũm Jacó'ũm. Ẽn pit ibodi ma'g̃u a'õbuyxi? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","— Itekũybewiati kõn puje, waram tak ebipuruk ece'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","— Wemudiũmti kõn puje bit, waram ebipuruk g̃u ece'e―pũg̃ em tak ka'ũma — io'e. — Wemudiũmti bit tiwaru. Idi'a buxim je'e ewebe―tiapep'ũmati buxim. Imẽnpuxim je'e wemudiũmti. Tiapap g̃u je'e. Wemudiũmti kõn puje, waram eybipuruk g̃u epe'e. Itedi kõn puje, eyag̃uyisum epeku ijodi. Soat em eyetait epesop Deus xe eye'ũ buje dak — Jesus o'e cebe. ");
INSERT INTO myu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","— Tapu — io'e. — Itedi buk etiũm owebe! — io'e. — Etiũm waram obipurukap puxim — io'e. — Etiũm puk waram ijoce tibum wajẽmap puxim — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","— Ektop cuy eg̃udot okay — io'e cebe. — Ektop eju juy ecepit — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Tã — io'e. — Oktoptep g̃u — io'e. — Icẽmãn ẽn e'em “Oktoptep g̃u,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","— Cinco beayũ eju juk a'g̃u ecewebumũn―emumukukukyũ eju — io'e. — G̃asũ ewejuat ektop g̃u — io'e. — Imẽn ikẽrẽ Deus xe — io'e. — Icẽmãn ẽn e'em pit “Oktoptep g̃u,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","— Tapu — io'e. — G̃asũ bit iba'arẽm g̃u o'e oxe. Ẽn Deus ekawẽn muwẽnuwẽn'ukat ma — io'e ayacat. ");
INSERT INTO myu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","— “Cũg̃ ma wuywebe Deus kay g̃ebum ma ijoce ma―co'a be―Gerazim'a be,” i juk adi o'e ocedobuyũ'ũm'ũm. Eyju bit Judeuyũ. “Cũg̃ ma wuywebe Deus kay g̃ebum am wara'atka be g̃u―Jerusalém ka be acã,” i eyju e'em — io'e. — Abuyũ icẽm g̃u e'em exe? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","— Tũ'ũ, eya'õpicũg̃cũg̃ cuy wa'õ kay — io'e Jesus. — Eyju Samaria eipi beayũ — io'e. — Eyju e'em Deus pe “Ẽn ma ocekukukat,” i. Imẽnpit eyetaybit g̃u abu ixe iam. Oceju bit Judeuyũ. Oceju bit ocetaybit abu ixe iam. Deus Judeu o'taẽ ijodiayũ daxijojo'ukan, — io'e. — G̃uyjom ma “ ‘Ẽn ocekukukat,’ i juy ace'e wuyebay be Gerazim'a be acã,” i'ũmg̃u epe'e; “Jerusalém ka be acã,” i'ũmg̃u dak. Soat ka dag̃ “Ẽn ocekukukat,” i epe'e'e cebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","— G̃axĩn ma Deus pe eykukukan epesop — io'e. — Ixe bikuyap tag̃ epeku. Ixe ekawẽn kay kũyjobin epesop. Imẽn eyeku buje, Deus kay g̃ebum epesop soat em. Eyebay ibikuy imẽn ma eyeku am — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","— Deus ijebitbet g̃u. Ijo ba'ore eywebe — io'e. — Ixe kay juy g̃ebum epesop ijojom g̃u ma'g̃u. Ixe biõg̃buk a'õbi juy epesop g̃ebum cekay. Cekawẽn tag̃ tak cuy epesop g̃ebum cekay―kawẽn icẽmat tag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","— Wetaybit Cristo omuyku iam. Wuydaxijo am Deus emunaẽ omuyku — io'e ayacat. — “Deus emunaẽ ixe,” i wuyju e'em, “Wuydaxijo ixe,” i dak — io'e. — Yajẽm puje soan ocemutaybin ixe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","— Õn ma Cristo — Jesus o'e ayacat pe. — Õn ma kawẽnwẽn eweju — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iboam e buje, ceweju etaybitbinayũ o'jepit Jesus kay jexat kug̃. Yag̃uybabi'ũm o'e ip ibapug̃ ma Jesus ayacat eju kawẽnwẽn puye. Imẽnpit: — Ajo-kay ẽn ayacat xewi? — i'ũmg̃u o'e ip Jesus pe. — Apẽnpuye ẽn kawẽnwẽn ayacat eju? — i'ũmg̃u dak ip o'e cebe. ");
INSERT INTO myu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","G̃ebuje ayacat o'jepit jeka kay. O'ju jeka beacat kay. Timũn'a o'yaiwat idibikũy xe. Jay. Oajẽm. ");
INSERT INTO myu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","— Epesot cuy ag̃okatkat com — io'e cebe ip―jeka beacayũ be. — Idibikũy xe omuy — io'e. — “Ẽn cuk adi ikẽrẽat eg̃ujurũg̃rũg̃,” i juk o'e owebe — ayacat o'e. — Ixe xe'e Cristo? — io'e. — Ixe xe'e Deus emunaẽ? — io'e ayacat. ");
INSERT INTO myu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","O'ju ip Jesus kay. O'jẽm ip ag̃oka bewi. ");
INSERT INTO myu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ag̃oka bewiayũ ajẽm awap ceweju etaybitbinayũ o'jekawẽn Jesus eju. — Ocemutaybitbin'ukat — io'e ip. — Juku wuyxat — io'e ip. — G̃a'a acekõn! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","— Oxat g̃u omucokcokcog̃―wara'at acã. Eyetaybit g̃u iboam — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","— Warara'acat xe'e ixat o'tojot cebe? — io'e ip jeweweju. ");
INSERT INTO myu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","— Eyju ma eycokcok eyxat kug̃ pima. Õn pit ocokcok omudocat bikuyap tag̃ weku am — io'e. — Omudocat kapikap o'g̃ũm owebe. Ocokcok oce wekapikap mu'ũm ãm — Jesus o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","— “Ebadipdip kaxi kap puje, wuyku beat'a yaop je'e,” i eyju ma e'em. “G̃axĩn ma yaop,” i õn pit e'em eywebe. Imẽnpuxim eyxe adeayũ ibu'u jemutabun am okay. “Ak'i epe'e iteyũ kay―ajẽmjẽmayũ kay,” i õn pit e'em — Jesus o'e. — “G̃axĩn ma ip itabun okay,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","— Kadaidaidada'ukat jekapikaptei bubum, jeku beat'a bubu'ukat tak. Icokcok e'em ip jeku beat'a kug̃ pima. Imẽnpuxim omuwẽnuwẽn'ukat icokcok je'e warara'acat pe itabut puje, warara'acat mutabunbun'ukat tak. Itabucayũ soat em itait jeedop ip webay xe kabi be — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","— Õn cuk eymuju omuwẽn ãm adeayũ be. Icẽmãn wuyju e'em “Wara'at taidadam. Wara'at pit yabubum,” i. Imẽnpuxim pũg̃pũg̃ayũ omuwẽnuwẽn. Warara'acayũ itabut'ũmayũ mutabunbun. Adeayũ epeg̃utabun g̃asũ cebe ip omuwẽn puje. Itabut je'e ip warara'acayũ kuy omuwẽn puye — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","G̃ebuje ag̃oka bewiayũ oajẽm cekay―Jesus kay. Oitabun ip cekay. Ade oitabun Samaria eipi watwat. Itabut ip o'e ayacat o'jewemuwẽn puye. — “Ikẽrẽat eg̃ujurũg̃rũg̃rũg̃,” i juk xeku o'e owebe — i juk ayacat o'e cebe ip. Itabut ip o'e cekay. — Ocexe juy eg̃uy — io'e ip Jesus pe. — Ha'a. Og̃uy — io'e. Xet. Xet. Xepxep xet osunuy ig̃o ka be. ");
INSERT INTO myu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Warara'acayũ Jesus kay itabut o'e cekawẽn co buje. Ade jĩjã itabut o'e cekay. ");
INSERT INTO myu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","— Koap ma ekawẽn oceya'ĩjojo. Imẽnpuye ocetabut cĩcã ixe kay — io'e ip ayacat pe. — Ixe ekawẽn oceya'ĩjojo g̃asũ bit. Ixe ipi dag̃acat taxijojo'ukat wuyxe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xepxep xet o'kap. Jesus waram o'ju Galiléia eipi kay. Ixe ka Galiléia eipi be o'sukadop―Nazaré ka. ");
INSERT INTO myu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","— Warara'acayũ xe Deus ekawẽn muwẽnuwẽn'ukat ya'õbuyxi. Jeka beacat xe bit ka'ũma — i juk o'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galiléia eipi watwat pit Jesus o'topabijurũg̃. Icokcok ip o'e. Jesus osunuy ya'õbuyxi cexe i Peta mug̃ẽg̃ẽm ip osodop Jerusalém ka be. Jerusalém ka be bima Jesus e'eap o'jojojo ip. Ja'õbacaap mõg̃mõg̃ap o'jojojo ip. Imẽnpuye icokcok ip o'e Jesus dopabijurũg̃ puje. ");
INSERT INTO myu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus o'jepit Caná ka kay―idibi o'timuwexat uva'abidim iat ka kay. Caná ka Galiléia eipi be o'sukadop. Ipi kukat ebekit ig̃oka be osunuy―Caná ka be. Ixe ipot iwãtaxipi jĩjã osunuy. Po'i osunuy ipot Cafarnaum ka be. Oe'ũ pin ipot jewãtaxipiap pibun. ");
INSERT INTO myu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","— Jesus oajẽm ijoce, adeayũ o'e ipi kukat ebekit pe. Oajẽm Judéia eipi bewi — io'e ip cebe. Ipi kukat ebekit o'ju Jesus kay. Jay. Oajẽm. — Ejot cuy oduk'a be — io'e. — Okpot eg̃u'ada! — io'e Jesus pe. — Oe'ũ pin okpot — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","— Deus ja'õbacaap mõg̃mõg̃ap coco'ũm puje, kuka eyetabut g̃u epe'e okay — io'e Jesus — wuywebe i'e ba'oreat mubapukpukap coco'ũm puje dak. ");
INSERT INTO myu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","— Kariwa — io'e. — Ejot cuy okpot e'ũ awap — io'e. ");
INSERT INTO myu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","— Ecepit cuy eduk'a be — io'e Jesus. — Ekpot kuy o'je'ada. Oe'ũ g̃u — io'e. Iwãtaxipi topibit ebay itabut o'e Jesus a'õ kay. Aripit. O'jepit jeduk'a kay. Jesus eju g̃u o'jepit―jag̃epũg̃ ma. ");
INSERT INTO myu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jeduk'a be kapikpik'ukayũ ixe o'topabijuk e dag̃―jeduk'a be yajẽm pima. — Ekpot oe'ũ g̃u — io'e ip. — O'je'ada jĩjã — io'e ip cebay be. ");
INSERT INTO myu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","— Poce kaxi bima o'je'ada? — io'e. — Wuyase bima o'je'ada kapusu — io'e. — Ipa'iat oi'ũm — io'e ip cebay be. ");
INSERT INTO myu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","— Wuyase bima ma Jesus o'jekawẽn oweju — io'e cebay. — “Ekpot kuy o'je'ada,” io'e owebe — io'e. Imẽneju itabut o'e Jesus kay. Tuk'a beacat tak itabut o'e ip cekay―soat ip. ");
INSERT INTO myu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Imẽn Jesus waram wuywebe i'e ba'oreat o'g̃ubapuk adeayũ etabutpe―Galiléia eipi beacat etabutpe. O'g̃ubapuk Judéia eipi bewi ijẽm puje. ");
INSERT INTO myu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","G̃uyjom Jesus waram o'ju Jerusalém ka kay. Oajẽm. Judeuyũ peta mug̃ẽg̃ẽm osodop ibo ka be. ");
INSERT INTO myu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalém ka be idibi'it'iti o'tinuy. Betesda i tibutet osunuy Judeuyũ a'õm. Ovelha muõmõmap exĩntabi xe o'tinuy ixedi―ag̃oka ekorara exĩntabi xe. Pũg̃põg̃bi iwãtaxipiat nuyap'a o'yadop idibi'it'iti akokoreren. ");
INSERT INTO myu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ade iwãtaxipipiayũ kapopo'i osodop joyũ'abeku. Ita'ũmayũ osodop ip, cexĩg̃xĩg̃ pa'oreayũ dak, ijebit e'ũayũ dak. Timukoruyap wiwim ip osodop iwãtaxipipiayũ. ");
INSERT INTO myu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Deus ekawẽn tojotjot'ukat ajẽmjẽm'uk osunuy ig̃odi be. Idibi mukoruy buje, iwãtaxipipiayũ kopkop'uk ip osodop idibi kay. Koap kopat acã o'je'ada. ");
INSERT INTO myu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jesus oajẽm ig̃odi xe. G̃ebuje Jesus ag̃okatkat o'jojojo ig̃odi xe. Ixe ag̃okatkat ade koato iwãtaxipi osunuy. 38 koato iwãtaxipi osunuy. ");
INSERT INTO myu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ade koato po'i osunuy jewãtaxipiap kug̃. Jesus itaybit o'e iboam. — Tapu, e'ada pin tu? i — io'e Jesus cebe. ");
INSERT INTO myu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","— Hm hm — io'e ag̃okatkat. — We'ada pin oce. Imẽnpit ka'ũmg̃u obure odujukop am idibi kay timukoruy buje — io'e. — Okop pa'ore. Okop pin pima, warara'acat ma kom. Ixe ma o'je'ada — io'e. — Õn pit ka'ũma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","— E'ãy — io'e Jesus. — Exexecaptup cuy etupu — io'e. — Xĩg̃xĩg̃ ece — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","O'je'ada g̃ebuje bit ag̃okatkat. Jexexecaptup o'tupu. Xĩg̃xĩg̃ o'e. Xipat o'e. Judeuyũ xe jebodoydoyap kabia osunuy. Sábado osunuy. ");
INSERT INTO myu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Imẽnpuye Judeuyũ kukayũ o'jekawẽn ag̃okatkat eju―ce'ada'ibit eju. — Jebodoydoy oceju ijop kabia. Cũg̃cũg̃ g̃u — io'e ip. — Ka'ũmg̃u wuyekapikap g̃asũ. Wuymutaybitbinap tag̃ g̃u ẽn e'em — io'e ip. — Cũg̃ g̃u ewebe exexecaptup tujowat am g̃asũ. Kapikpig̃ ẽn exexecaptup tujowatwan — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","— “Exexecaptup cuy etupu,” i juk o'e owebe omu'adaat — io'e. — “Xĩg̃xĩg̃ ece,” io'e owebe — io'e ce'ada'ibit. ");
INSERT INTO myu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","— Abu o'e ewebe “Exexecaptup cuy etupu,” i; “Xĩg̃xĩg̃ ece,” i dak? — io'e ip. — Apẽn ibutet? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Imẽnpit ce'ada'ibit itaybit g̃u o'e jemu'adaat puten. Imu'ada buje, Jesus dao ma o'jẽm adeayũ parakpewi. Imẽnpuye ce'ada'ibit itaybit g̃u o'e ibuten. ");
INSERT INTO myu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jesus ce'ada'ibit o'tobuxik g̃uyjom. Deus eju kawẽnwẽnap'a be o'tobuxik―yabo'gat'a be. — Kuy ece'ada — io'e. — Ikẽrẽat cuy eg̃ujurũg̃ g̃u waram ewãtaxipinap puxim — io'e Jesus imu'ada'ibit pe. — Hm hm. Ikẽrẽat og̃ujurũg̃ g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ce'ada'ibit o'jẽm. O'ju Judeuyũ kukukayũ kay. — Kuy bima wetaybit g̃u og̃uy abu omu'ada iam — io'e. — G̃asũ bit wetaybit oce ibuten — io'e. — Jesus i ibutet — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Imẽnpuye Judeuyũ kukukayũ Jesus kaykay o'e ip. Yaoka ojuy ip Jesus ag̃okatkat o'g̃u'ada jebodoydoyap kabia be buye. ");
INSERT INTO myu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Imẽneju Jesus o'jekawẽn cebe ip. — Webay soat kabia jekapikap kug̃ e'em. Imẽnpuxim õn tak wekapikap kug̃ e'em — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Imẽnpuye Jesus aoka ojuy ip Judeuyũ kukukayũ. — Jesus o'jekapik jebodoydoyap kabia be. Ag̃okatkat o'g̃u'ada — io'e ip. — Imẽn cũg g̃u Deus xe — i napa ma ip o'e. — Jesus o'e “Deus webay,” i — io'e ip. — “Deus webay” i'e'em pima, “Deus a'õbacaap co'i õn tak wa'õbaca,” i'e'em tak — io'e ip. — Imẽnpuye juy ayaoka — io'e ip. Imẽn o'jekawẽn ip jeweweju. ");
INSERT INTO myu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","G̃ebuje Jesus o'jekawẽn Judeuyũ kukukayũ eju. — Icẽmãn õn e'em eywebe — io'e. — Deus ipot õn. Wa'õbi g̃u õn e'em―webay a'õbi acã. Webay e'eap cocom õn. Webay e'eap tag̃ acã õn e'em, ixe ipot puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","— Webay xe okukpin cĩcã. Webay a'õbi iwãtaxipiat mu'ada'ada'uk og̃uy. Idip cĩcã o'e iwãtaxipiat mu'adaap. Iboap podi ma idipat g̃ubapuk webay — io'e Jesus. — Eyetabẽg̃bẽg̃ epe'e iboap cocom―webay e'eap cocom — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","— Webay ce'ũ'ũayũ mutaicin. Waram ip itait. Kabi kay ixeyũ muyuhum. Õn tak waram ce'ũ'ũayũ mutaicin. Obikuy bima waram imutaicin õn ixe ipot puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","— Deus g̃u e'em ijodiacat pe “Eykẽrẽ oxe,” i. Owebe ma webay e'em “Ẽn ma ece ‘Ikẽrẽat kug̃ eyju Deus xe,’ i ijodiacat pe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","— Imẽnpuye adeayũ je'e owebe “Ẽn Deus ipot,” i. “A'õbuyxi jĩjã ẽn,” i. “Deus tak ya'õbuyxi jĩjã,” i je'e ip. Warara'acayũ xe wa'õbuyxi'ũm pima, webay dak kuka o'e ya'õbuyxi g̃u. Omudocat tak kuka o'e ya'õbuyxi g̃u cexe ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","— Icẽmãn õn e'em eywebe — io'e. — Wa'õ kay kũyjobicayũ yag̃uyisum jekukum―omudocat kay itabucayũ — io'e. — Soat em Deus xe jeedop ip itait — io'e. — “Ikẽrẽat kug̃ eyju oxe,” i'ũmg̃u je'e Deus okay itabucayũ be. “Soat em ipiat osupi'ajoat eywebe,” i'ũmg̃u dak je'e cebe ip — io'e Jesus. — “Soat em ipiatpi'ajojoap pe juy epesop,” i'ũmg̃u je'e cebe ip― “Soat em oxe ma juy epesop,” i acã — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","— Icẽmãn õn e'em eywebe. Deus ipot õn. G̃axĩn ma ojẽm eyxewi. Oajẽm waram. Wajẽm puje, wa'õberen ocewãwã. Ce'ũ'ũayũ wa'ĩjojo. Waram g̃uto jetait ip wa'õberen wewãwã buje. ");
INSERT INTO myu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Warara'acat Deus mutaicin g̃u. Ja'õbi ma itabẽg̃ e'em. Wa'õbi ma õn tak wetait — io'e. — Õn tak webay jo'i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","— Soat wag̃o õn. Webay a'õbi acã õn e'em pũg̃pũg̃ayũ be “Eykẽrẽ g̃u Deus xe,” i. Ya'õbi acã “Eykẽrẽ Deus xe,” i õn e'em warara'acayũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","— Eyag̃uybabi'ũm g̃u juy epesop wekawẽn kay. G̃uyjom ma ce'ũ'ũayũ wa'ĩjojo — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","— Ce'ũ'ũayũ xewi jeu ip jedopap pewi. Xipacat mujurũg̃rũg̃'ukayũ jeu kabi kay. Soat em Deus xe jeedop ip. Ikẽrẽat mujurũg̃rũg̃'ukayũ dak jeu. “Eykẽrẽ oxe,” i je'e Deus cebe ip. Ixeyũ g̃uju ipiat'ajojoap pe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","— Wa'õbi g̃u õn kawẽnwẽn―pũg̃ em tak ka'ũma. Obikuyap tag̃ g̃u õn jekukum―omudocat bikuyap tag̃ acã. Kuy owebe Deus e'eap tag̃ acã õn kawẽnwẽn. Imẽneju cũg̃ ma owebe “Ikẽrẽat kug̃ eyju Deus xe” i'e am pũg̃pũg̃ayũ be; “Xipat eyju Deus xe” i'e am warara'acayũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Õn acã omuwẽnuwẽn pima, “Deus a'õbi õn e'em,” i'e'em pima, “Dapxi ẽn,” i kuka juk epe'e. Wa'õ kay eyetabut g̃u kuka epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","— Wara'acat tak omuwẽnuwẽn. Webay dak omuwẽnuwẽn. Ixe icẽmãn e'em. Wetaybit icẽmãn ixe omuwẽnuwẽn iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","— Eybureyũ juk epeg̃uju João Batista kay — io'e Judeuyũ kukukayũ be. — Ixe João icẽmãn omuwẽnuwẽn oeku. ");
INSERT INTO myu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Xipan cuy epe'e omuwẽnuwẽn,” i'ũmg̃u õn pit e'em warara'acayũ be. “João icẽmãn omuwẽnuwẽn oeku,” i õn e'em eywebe, eydaxijo ojuy õn puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","— Lamparina kug̃ pima wuyetaybit poma aju iam. João Batista lamparina buxim osunuy. João Deus ekawẽn muwẽnuwẽn oeku. Imẽnpuye eyetaybit cũg̃ ma jeku am Deus xe iam. Darem ma eycokcog̃ epesop ixe ekawẽn com — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","— João omuwẽnuwẽn oeku. Adeayũ okay itabut o'e. Webay a'õbi wa'õbacaap mõg̃mõg̃ ojeku eyetabutpe. Iboap tobuxik puje adeayũ e'em owebe “Ebay juk omudot ocekay,” i. ");
INSERT INTO myu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Webay omuwẽnuwẽn. Omudocat omuwẽnuwẽn. Eyju bit kũyjobit g̃u webay a'õ kay. Webay kay eyetabut g̃u dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","— Webay juk omudot ijodi. Webay a'õmupubutbun eyju bit, eybu'u jĩjã eyetabut am okay buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","— Eyju Deus ekawẽntup cocom cĩcã. “Deus ekawẽn tag̃ jekukum pima, cebekitkiyũm acesop,” i eyju e'em. “Soat em Deus xe acesop wuyetait,” i dak eyju e'em. Imẽnpit Deus ekawẽntup tak omuwẽnuwẽn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","— Inaka eybu'u jĩjã eyetabut am okay. Okay eyetabun pima, soat em epesop eyetait Deus xe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","— Wetaybit apẽn eyju jewag̃uyg̃uy iam. Wetaybit cĩcã eyju Deus kay g̃u jĩjã iam — io'e Jesus. — Imẽnpuye eywebe ibuyxim okukap kudadam g̃u õn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","— Webay a'õbi ojot. Imẽnpit eyju eyetabut g̃u jĩjã okay. Ja'õbi warara'acat tot puje bit, ixe kay kuka eyetabut epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","— Pũg̃ ma Deusat. Kaũmg̃u wara'at. Eyju bit Deus pe xipan eymuwẽnuwẽnap kudadam g̃u―wuyjuyũ be xipan eymuwẽnuwẽnap kudadam acã. Imẽneju eybu'u jĩjã eyetabut am okay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","— Eyju te'e ma e'em “Moisés emudupmubararaktup tag̃ oceju jekukum,” i. “Imẽnpuye oceju cũg̃ cĩcã Deus xe,” i eyju te'e ma e'em — io'e. — Moisés cuk adi omuwẽnuwẽn Deus ekawẽntup pe. Imẽnpuye Moisés a'õ kay eyju kũyjobit pima, wa'õ kay dak kuka juk kũyjobit epe'e. “Teyũku ikẽrẽ,” i'ũmg̃u õn pit e'em webay be. Deus acã je'e eywebe “Eykẽrẽ oxe, Moisés a'õ kay kũyjobit'ũm puye,” i. ");
INSERT INTO myu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moisés emudupmubararaktup kay eyetabut g̃u. Imẽnpuye wa'õ kay dak iba'ore eymutabut am — io'e Jesus Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ibocewi Jesus iodi o'timudek―Galiléia eipi beati. Tiberíades tibutet osunuy. ");
INSERT INTO myu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","G̃ebuje adeayũ o'ju Jesus kay. — Jesus juk adi iwãtaxipipiayũ o'g̃u'ada'ada. Wuywebe i'e ba'oreat o'g̃ubapukpuk — io'e ip. — Waram tak paxi iwãtaxipiat g̃u'ada? — io'e ip jewewebe. Imẽnpuye o'ju ip tomuju. ");
INSERT INTO myu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O'jeu Jesus co'apẽn pe. Jeweju etaybitbinayũ eju oabik―doze beayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judeuyũ epeta wap osodop ip―Páscoa epeta wap. ");
INSERT INTO myu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","G̃ebuje Jesus adeayũ o'jojojo. — Teyũku og̃ubeg̃beg̃ ixan — io'e jewebe ma. — Filipe du itabut adeayũ mubeg̃beg̃ put Jesus pe iap kay? — io'e Jesus jewebe ma. Imẽnpuye: — Apẽn xe'e juy pão'a aceyabu iteyũ xat'am―soat xat'am? — io'e Jesus Filipe be. ");
INSERT INTO myu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","— 6 kaxi be wuyekapikap teim pão'a bu buje, kuka o'e g̃u adeayũ xat'am — io'e Filipe. ");
INSERT INTO myu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wara'acat o'jekawẽn Jesus eju jeweju etaybin'ibiyũ'in. André o'jekawẽn ceweju. Simão Pedro wag̃o osunuy André. ");
INSERT INTO myu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","— Ak'i! — io'e André. — Yaypan'isuat otobuxik. Cinco be pão'a kug̃. Axima kug̃ tak xepxep — io'e. — Imẽnpit apẽg̃ãm kuka ajat cexewi? O'e g̃u kuka adeayũ xat'am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","— “Epabik cuy,” i juy epe'e adeayũ be — Jesus o'e jeweju etaybitbinayũ be. O'jekawẽn ip adeayũ be. Oabikbik ip adeayũ kapĩ'idip ceje, tip'ade o'tiptop puye. Ade jĩjã ip osodop. Cinco mil ag̃okatkayũ osodop aoyũ parakpe, bekitkiyũ parakpe dak. ");
INSERT INTO myu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","G̃ebuje Jesus pão'a o'yabu. O'jekawẽn Deus eju. — Bay, ẽn xipat — io'e cebe. — Ocexat'am eyamudot ocewebe — io'e. O'yaũm doze beayũ be pão'a. Yaũmũm pima o'yamu'aren cĩcã. Ya'ada jĩjã o'e. Doze beayũ pão'a o'yaũmũm kaxikxik'iayũ be. Axima dak o'g̃ũm doze beayũ be. Iũmũm pima o'g̃u'aren cĩcã. Doze beayũ o'g̃ũmg̃ũm cebe ip―kaxikxik'iayũ be. Kuy jemu'opinput o'jat ip. Ibeg̃beg̃ ip o'jekõn. ");
INSERT INTO myu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Soat ip ibeg̃beg̃ o'e Jesus ixat o'g̃u'aren cĩcã buye. — Ceaepoyat'a juy epeyabu — io'e Jesus doze beayũ be. — Epeyamuxipan — io'e. — Axima epoyat tak cuy epejat. Epeg̃uxipan cuy — io'e. — Epejat cuy ierepap puxim — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Soat cepayat ip o'jat. Pag̃eiro'a jo'iat'a be o'g̃uõm ip. O'yamuporan ip cepoyan. Doze be o'yamunopapũn pa'geiro'a jo'iat'a. ");
INSERT INTO myu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Imẽn Jesus wuywebe i'e ba'oreat o'g̃ubapuk soat etabutpe. Ixat o'g̃u'aren cĩcã. Imẽnpuye: — Ite ma Deus ekawẽn muwẽnuwẽn'ukat! — io'e ip jewewebe o'jojojo'iayũ. — Ade koato ma ixe ajẽmap wiwim ocesop — io'e ip jewewewbe ma. ");
INSERT INTO myu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus dakoy ojuy ip o'e. “En ma juy ocekukan ece” i'e ojuy ip cebe. — Odakoy ojuy ip jekukukan — io'e. — G̃asũ bit obu'u ixeyũ kukukan — io'e Jesus jewebe ma. Imẽneju o'jepit jenomukay ma. Jag̃epũg̃ ma o'ju co'a dag̃. ");
INSERT INTO myu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kabiog̃kabiog̃'i bima ceweju etaybitbinayũ o'kop iodi kay―doze beayũ. ");
INSERT INTO myu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Iodi mudek ojuy ip. — G̃a'a acepit Cafarnaum ka be — io'e ip jewewebe. Kobe be ip oõm. Kabiok o'e. Jesus oajẽm g̃u buk. ");
INSERT INTO myu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tipodoybog̃ cĩcã o'e kabidobog̃ puye. Daum cĩcã kobe tipodoy dag̃. ");
INSERT INTO myu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wũy jĩjã o'jekoykoy ip. 5 kilometro o'jekoykoy ip. Jesus o'jojojo ip. Xĩg̃xĩg̃ oeku idibi adopa dag̃ Jesus. Yakõmkẽm g̃u tipodoy dag̃. Xĩg̃xĩĩĩĩĩh. Ti'adopa dag̃ cũg̃cũg̃ ma oajẽm. Oajẽm pin kobe kay. Iparara jĩjã ip o'e ti'adopa dag̃at tobuxik puje―xĩg̃xĩg̃at tobuxik puje. — Ajo xe'e teku ti'adopa dag̃at? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","— Eypararam g̃u juy epesop — io'e. — Wara'at g̃u õn. Õn ma — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iparara g̃u ip o'e doze beayũ Jesus ekawẽn co buje. Icokcok cĩcã ip o'e. Imẽnpuye: — Eõm kobe be — io'e ip cebe. Kobe dak o'jemũg̃ wĩnãbu. Jejuap ojuy ka be o'jemũg̃. Mug̃. ");
INSERT INTO myu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kuyaje tomukudadaayũ Jesus o'tobuxik g̃u. — Apu Jesus? — io'e ip jewewebe. — Pũg̃ ma juk kobe ijoce osodop kapusu — io'e ip. — Jesus pit oõm g̃u ibo be kobe be — io'e ip. — Ceweju etaybitbinayũ acã juk oõm kobe be. Ixe bit ka'ũma — io'e ip. — Apoma o'ju? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kawẽnwẽn pima wĩnãbuayũ oajẽm jekobe dag̃. Tiberíades ka bewi ip oajẽm. O'jemũg̃ ip. Mug̃. Wuyjuyũ be pão'a o'oap pe o'jemũg̃ ip. Jebay eju kapusu wuykukukat Jesus o'jekawẽn iap pe o'jemũg̃ ip. ");
INSERT INTO myu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","— Jesus pit ijoce g̃u omuy — io'e ip―tomukudadaayũ o'e yajẽm'ibiyũ be. — Ceweju etaybitbinayũ dak ijoce g̃u omuy — io'e ip. — G̃a'a atimudek eyekobe dag̃ — io'e ip. — G̃a'a — io'e ip. Imẽnpuye ip oõm kobe be―Tiberíades ka bewiayũ ekobe be. Porog̃. Oõm ip soat. Toktek. O'timudek ip wĩnãbu. Cafarnaum ka ebikopap pe ip o'jemũg̃ Jesus kudadam. — G̃a'a Jesus ajokudada! — G̃a'a! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","O'tobuxik ip. Wĩnãbu ip o'tobuxik. — Ocemutaybitbin'ukat — io'e ip. — Puje ajẽm ijoce? — io'e ip. — Ekudadam oceku — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","G̃ebuje Jesus o'jekawẽn ceweju ip. — Icẽmãn õn e'em eywebe — io'e Jesus cebe ip. — Kapusu pão'a epeyabu oxewi. Eybeg̃beg̃ epesop oxewiat'am. G̃asũ epesot okudadam “Ẽn xipat cĩcã” i'e am g̃u―pão'a o pin puye acã — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","— Eyxat kay acã g̃u juy epeyeg̃ebu. Eybeg̃beg̃ eyxan ijodi bima acã — io'e. — Wara'at tak opop eyxat eyag̃uymuisusunap xat — io'e. — Ixe xat o buje, eyag̃uyisum epeku ijodi bima. Soat em epesop eyetait Deus xe eye'ũ buje dak — io'e. — Soat wag̃o õn. Deus webay. “Obikuyap tag̃ ẽn jekukum soat em,” i juk o'e Deus owebe — io'e. — “Imẽnpuye ẽn ma ibiat xat ũmũm'uk eg̃uy wuyjuyũ be,” i juk o'e owebe — io'e. — Eyju dak Deus bikuyap tag̃ cuy epekuku soat em ma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","— Apẽn xe'e oceku soat em Deus bikuyap tag̃? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","31","— Deus e'em “Wemumudot kay eyetabun cuy epesop,” i — io'e. — Õn ma Deus emumudot — io'e. — Okay eyetabut puje, Deus bikuyap tag̃ eyju jekukum — io'e Jesus. — Ocedobuyũ'ũm'ũm pão'a jo'iat'a o'o'uk ip osodop uk'a'ũmat tag̃ pima — io'e ip Jesus pe. — Imẽn e'em Deus ekawẽntup: Moisés pão'a mudodot'uk osunuy cekay ip―kabi bewiat'a, i — io'e ip. — Deus a'õbi Moisés ja'õbacaap mõg̃mõg̃'uk osunuy pão'a jo'iat'a mudodon — io'e ip. — Pãm ẽn? A'õbacaap cuy ejomõg̃ ocetabutpe — io'e ip. — Imõg̃ puje ocetabut oce'e ekay — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","— Icẽmãn õn e'em eywebe — io'e Jesus cebe ip. — Ja'õbi g̃u Moisés pão'a jo'iat'a mudodot'uk osunuy eydobuyũ'ũm'ũm pe―Deus a'õbi acã. Moisés Deus xewiatxat g̃u imudodot'uk osunuy cekay ip. Deus pit jexewiatxat mudodon eywebe―eyag̃uymuisusunap xat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","— Deus cuk omudot jexewi kuyje pão'a jo'iat'a mudocap co'i — io'e. — Õn kabi kadi wiatxat co'i ojot ijodiat ag̃uymuisun am — io'e. — Okay itabucayũ yag̃uyisum jeku — io'e. — Õn ijodiat ag̃uymuisusun'ukat — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","— Kariwa — io'e ip Jesus pe. — Ibiatxat cuy eg̃ũm ocexan. Soat em cuy eg̃ũmg̃ũm ocewebe. ");
INSERT INTO myu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","— Õn Deus xewiatxat — Jesus o'e. — Õn ma ijodiat ag̃uymuisusun — io'e. — Okay eyetabut puje, soat em eycokcog̃ epesop ibeg̃beg̃at co'i. Okay eyetabut puje soat em eycokcog̃ epesop ibipuruk'ũmat co'i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","— “Eybu'u eyetabut am okay,” i juk adi ocece eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","— Webay pũg̃pũg̃ayũ mutabunbun okay. Imẽnpuye itabut ip okay. “Eyetabun g̃u juy epesop okay,” i'ũmg̃u õn pit e'em cebe ip―itabun ojuyayũ be―pũg̃ pe dak ka'ũma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","— Kabi kadiwi juk oajẽm obikuyap tag̃ weku am g̃u. Omudocat bikuyap tag̃ weku am oajẽm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","— Soat em ag̃ õn okay itabucayũ kay. Imẽnpuye jetabucap epereperem g̃u ip―pũg̃ tak ka'ũma. Waram ixeyũ og̃uyu kabi kay ce'ũ'ũayũ muyuap kabia be. Og̃uyu ip omudocat bikuyap tag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","— Okay itabucayũ og̃uyu ce'ũ'ũayũ xewi, webay soat ce'ũ'ũayũ muyuap kabia be — io'e. — Soat ip jeedop itait Deus xe soat em―abu õn iam itaybicayũ. Imẽn webay ibikuy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Imẽneju Jesus ekawẽn kay g̃u ip o'e Judeuyũ kukayũ. Jewa'õxikxig̃ o'e ip jeweweju. — “Õn Deus xewiat,” i teku e'em — io'e ip. — “Kabi kadiwiat xat co'i õn,” i teku e'em — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","— Jesus ma teku! — io'e ip jewewebe. — José'ũm ipot teku — io'e ip te'e ma. — Wuyetaybit ixim, cebay'ũm tak. Apẽntak “Deus xewi ojot,” i teku e'em? Dapxi teku — io'e ip te'e ma. ");
INSERT INTO myu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","— Wa'õxikxig̃ g̃u juy epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","— Webay wuyjuyũ mutabunbun okay―omudocat — io'e. — Imutabun'ũm pima, kuka itabut g̃u ip o'e okay. Okay itabucayũ acã og̃uyu kabi kay. Webay soat ce'ũ'ũayũ muyuap kabia be ip og̃uyu. Soat em jeedop ip webay xe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","— Kuyje Deus ekawẽn muwẽnuwẽn'ukayũ o'tupmubararak. Imẽn ibararak opop tup pe: Deus soat wuyjuyũ g̃utaybin, i. Imẽn e'em ig̃odup pe — io'e. — Webay ekawẽn co buje, itabut ip okay ijodiacat, webay be imutaybin puje dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","— Pũg̃ ma webay o'jojojo. Warara'acat pit ka'ũma — io'e. — Õn acã webay ojojojo — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","— Icẽmãn õn e'em eywebe — io'e―Jesus o'e. — Okay eyetabut pima, soat em epesop eyetait Deus xe eye'ũ buje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","— Õn ma Deus xewiatxat — io'e. — Ijodiat ag̃uymuisusun õn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","— Wuydobuyũ'ũm'ũm mana'a o'o'uk osodop uk'a'ũmat pe bima. Inaka oe'ũ'ũ ip. ");
INSERT INTO myu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kabi bewiat kay eyetabut puje, Deus wi wũy g̃u epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","— Õn ma kabi bewiat — io'e. — Kabi bewi ojot ijodiat ag̃uymuisun am. Okay itabucayũ yag̃uyisum jeku ijodi bima. Soat em jeedop ip itait Deus xe ce'ũ buje. We'ũ buje, oẽn osuẽnũm ijodiat xatẽn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iboap co buje jewa'õxikxig̃ ip o'e Judeuyũ kukukayũ. — Apẽntak sute jeẽn iẽnũm wuywebe iẽn'o am? — io'e ip jewewebe. Jesus ekawẽn cekawẽn pa'arẽm osunuy ixeyũ xe―Judeuyũ kukayũ xe. (Oẽn'oat okay itabucat iape. Imẽnpit itaybit g̃u ip osodop iboam.) ");
INSERT INTO myu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","— Icẽmãn õn e'em eywebe — io'e Jesus. — Soat wag̃o õn. Oẽn'o'ũm pima Deus ebekitkin g̃u epe'e. Odoy kõn'ũm pima dak cebekitkin g̃u epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","— Oẽn'o buje bit, Deus ebekitkin epesop. Odoy kõn puje dak, cebekitkin epesop. Soat em epesop Deus xe eyetait — io'e. — Oẽn'oat og̃uyu kabi kay webay ce'ũ'ũayũ muyuap kabia be. Odoy kõnat og̃uyu ibo kabia be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","— Wuyjuyũ mutaicinatẽn oẽn. Odoy wuyjuyũ mutaicinatoy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","— Obiõg̃buk omuy oẽn'oat pe―odoykõnat pe — io'e. — Obiõg̃buk a'õbacaap kug̃ jekukum ip. Õn tak pũg̃ tag̃ ma jekukum ceweju ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","— Webay ja'õbi ma itabẽg̃ soat em ma. Ixe ma omudot. Õn tak wetabẽg̃ ijodi webay a'õbi — io'e. — Imẽnpuxim õn ma okay itabucayũ ag̃uymuisusun. Yag̃uyisum jekukum ip wa'õbi―oẽn'oayũ — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","— Imẽn ma kabi kadi wiatxat — io'e. — Pão'a jo'iat'a buxim g̃u―wuydobuyũ'ũm'ũm xat puxim g̃u. Wuydobuyũ'ũm'ũm pão'a jo'iat'a o'o'uk ip osodop — io'e. — Oe'ũ'ũ ip―ya'o'o'ukayũ'ũm'ũm ma. Kabi bewiat xat õn. Soat em jeedop ip itait Deus xe oẽn'o'oayũ — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus iboam o'e Judeuyũ e'aweroroap'a be―Deus eju kawẽnwẽnap'a be. Ig̃o'a beacat mutaybinbin osunuy Cafarnaum ka be. Oẽn'oat okay itabucat iape. Odoykõnat tak okay itabucat iape. Imẽnpit cekawẽn pa'arẽm osunuy ixeyũ xe. ");
INSERT INTO myu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Imẽneju: — Cekawẽn pa'arẽm cĩcã wuyxe — io'e ip jewewebe cekawẽn o'jojojo'iayũ. — Cekawẽn kay g̃u wuyju — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Warara'acayũ be jemukũyjo'ũm pima, Jesus itaybit o'e ixeyũ ekawẽn. Imẽnpuye o'jekawẽn ceweju ip. — Wekawẽn pa'arẽm tu eyxe? — io'e. — Eybu'u du eyetabut am okay wekawẽn kay'ũm puye? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","— Soat wag̃o õn. Wekawẽn pa'arẽm eyxe bima, eyetabut g̃u okay — io'e. — Kabi kay waram omuyuap tobuxik puje dak eyetabut g̃u kuka epe'e okay — io'e. — Oka kay wepicap co buje dak kuka eyetabut g̃u epe'e okay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","— Ijodiat ag̃uymuisusun oẽn o'o am g̃u — io'e. — Deus biõg̃buk acã ijodiat ag̃uymuisusun — io'e. — “Oẽn cuy epesuẽn'o,” i juk oce eywebe — io'e. — Imẽnpit okay eyetabun cuy epesop iam eymutaybin ojuy og̃uy — io'e. — Wekawẽn kay eyetabut pima, obikuyap tag̃ epeku―eyag̃uyisum epeku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","— Imẽnpit pũg̃pũg̃ ey'in itabut g̃u okay — io'e Jesus. (Jesus kuy itaybit o'e abuyũ ibu'u osodop itabut am okay iam. Itaybit o'e abu oũm okay itakomaayũ be iam tak. Kuy bima itaybit o'e iboam doze beayũ naẽ buje.) ");
INSERT INTO myu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","— Soat g̃u eyetabut okay — io'e. — Webay emumutabunbunyũ acã itabut je'e okay. Kuy iboap og̃uwẽn eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kuy bima ceweju oekuku'iayũ Jesus kay ip ibu'u o'e, cekawẽn kay'ũm puye. G̃ebuje oibu'un ip Jesus eju jeku am. ");
INSERT INTO myu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus o'jekawẽn doze beayũ eju―jeweju etaybitbinayũ eju. — Pãm eyju? — io'e. — Eyju dak tu eybu'un oweju? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","— Kariwa — io'e Simão Pedro. — Abu-eju kuka oceku? — io'e Jesus pe. — Ẽn acã apẽn itabucayũ yag̃uyisum jekukum iap ekawẽn muwẽnuwẽn ocewebe — io'e. — Ẽn acã Deus xe epesop iap ekawẽn muwẽnuwẽn ocewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","— Ekay acã ocetabut — io'e. — Ocexe ẽn acã Deus emumudot — io'e. — Ocexe ẽn acã xipacat — io'e. — Ẽn acã ikẽrẽat ejukuk g̃u — io'e―Simão Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","— Õn cuk eynaẽ — io'e Jesus. — Doze beayũ juk otaẽ — io'e. — Imẽnpit pũg̃ ey'in Satanás a'õkayan o'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus Judas o'g̃uwẽn―Simão Iscariotes ipot o'g̃uwẽn. Ixe Judas doze beayũ'in osunuy. Inaka Jesus ũm ojuy o'e cekay itakomaayũ be yaoka am. ");
INSERT INTO myu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ibocewi Jesus Galiléia eipi dag̃ oeku. Judeuyũ kukukayũ Judéia eipi be osodop ip. Ixeyũ Jesus aoka ojuy. Imẽnpuye Judéia eipi dag̃ o'ju g̃u Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judeuyũ epeta wap osunuy. Cepetabog̃ cĩcã osunuy. Xijap mõg̃mõg̃'uk ip osodop. Xijap pe dopdom osodop ip ig̃o epeta bima. ");
INSERT INTO myu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","G̃ebuje ikitpiyũ o'jekawẽn Jesus eju. — Ejẽm cuy ijocewi — io'e ip Jesus pe. — Judéia eipi kay juy eju — io'e ip. — A'õbacaap cuy ejomõg̃ a'õ kayayũ etabutpe ixeyũ be “Teku ya'õbaca jĩjã” i'e am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","— Iba'arẽm g̃u wuyju e'em xipan jewemuwẽn pin pima. Eju juy — io'e ip. — Ka'ũma buk ocejojojoiap cuy eg̃ubapuk — io'e ip. — Xipan jewemuwẽnat cuy soat pe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesus kitpityũ imẽn o'e itabut'ũm cekay buye. ");
INSERT INTO myu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","— Cũg̃ g̃u mabuk oju am peta kay — io'e Jesus. — Cũg̃ ma bit eyju am. Soat em cũg̃ ma eyju am. ");
INSERT INTO myu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Deus kay'ũmayũ eykay g̃u itakoma ip. Okay bit itakoma jĩjã ip “Ikẽrẽat mujurũg̃rũg̃ eyju,” i õn e'em cebe ip puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","— Eyju ma peta kay epeju — io'e jekitpiyũ be. — Õn pit oju g̃u ig̃o epeta kay. Cũg̃ g̃u mabuk oju am — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesus imẽn o'e jekitpitpiyũ be. O'jẽm ip ikitpitpiyũ. Jesus pit Galiléia eipi be osunuy pũg̃pũg̃ xet. ");
INSERT INTO myu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ebapũg̃ xet kap puje, Jesus o'ju peta kay. Soat eta'ũmpi ma o'ju. Iba'arẽm ma o'ju. ");
INSERT INTO myu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","13","G̃ebuje Jesus o'jokudada ip Judeuyũ kukukayũ. Petatam pima o'jokudada ip. — Apu Jesus? — io'e ip jewewebe. Adeayũ ibidadada ma jekawẽnwẽn osodop Judeuyũ kukukayũ be ja'õdobuxikap puxim. Jesus peam jewa'õxikxig̃ ip osodop. — Xipat cĩcã teku — io'e pũg̃pũg̃ ixeyũ'in. — Ka'ũma — io'e warara'acayũ bit. — Wuymug̃uykukuku'ukat teku — io'e ip napa ma. Adeayũ imẽn ibidadada ma jekawẽnwẽn ip o'e. ");
INSERT INTO myu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jesus o'ju Deus eju kawẽnwẽnap'a kay―yabog̃at'a kay. Peta mug̃ẽg̃ẽm pima o'ju. Ig̃o'a beacat mutaybitbin osunuy. ");
INSERT INTO myu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judeuyũ kukukayũ Jesus ekawẽn kay g̃u ip o'e. — Apẽnpuye dak sute itaybit? — io'e ip. — Wuymutaybitbin'ukat xe g̃u osunuy jemutaybinan. Cũg̃ g̃u cexe wuyjuyũ mutaybin am — io'e ip soat pe ig̃o'a beacat pe. ");
INSERT INTO myu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","— Wa'õbi g̃u õn adeayũ mutaybitbin―omudocat a'õbi acã — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","— Wa'õbi du eyxe õn eymutaybitbin? Pãm g̃uto Deus a'õbi? — io'e. — Deus bikuyap tag̃ jeku ojuyat itaybit je'e Deus a'õbi õn eymutaybitbin iam — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","— Pũg̃pũg̃ayũ Deus a'õbi g̃u ijodiat mutaybitbin―ja'õbi acã. Cũg̃ g̃u imutaybitbin ip. “Xipan omuwẽnuwẽn cuy epe'e,” i'e'em ip ya'ĩjojo'ibiyũ be. Warara'acayũ bit Deus a'õbi ijodiat mutaybitbin―jemudocat a'õbi. “Xipan Deus muwẽnuwẽn cuy epe'e,” i'e'em ip. Icẽmãn e'em ip. Napa g̃u ip e'em. ");
INSERT INTO myu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés Deus ekawẽn cuk adi o'g̃uwẽnuwẽn eydobuyũ'ũm'ũm pe kuyje. Imẽnpit soat eyju kũyjobit g̃u iboap ekawẽn kay. Abu ey'in iboap ekawẽn kay kũyjobit? Ka'ũma ma! Eyju dak waoka ojuy. Apẽnpuye? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Adeayũ Jesus ekawẽn o'ya'ĩjojo Deus eju kawẽnwẽnap'a beacayũ. — Akpidapi ẽn — io'e ip napa ma adeayũ Jesus pe. — Ka'ũma ma aoka ojuy — io'e ip Jesus pe. Itaybit g̃u ip osodop adeayũ Jesus aoka ojuy iam Jerusalém ka be powatwat. ");
INSERT INTO myu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","— Jebodoydoyap kabia be wa'õbacaap ojomõg̃ pũg̃ em ma — io'e Jesus. — “Cũg̃ g̃u teku e'em,” i juk adi epe'e iboap co buje. “Sábado be kapikpig̃ teku,” i juk adi epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","— “Wuydobuyũ'ũm'ũm ekawẽn tag̃ ag̃okatkat'it'it epetaypu'ag̃obixeedakat,” io'e Moisés kuyje. “Ikap'isuat epetaypu'ag̃obixeedakat teku Deus ebekit iap mubapuk am,” io'e Moisés kuyje. Jebodoydoyap kabia bima dak eyju ixeedakatkan Moisés ekawẽn mupubutbunap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","— Sábado bima eyju ixeedakatkan Moisés ekawẽn mupubutbunap puxim. Sábado bima owebe iwãtaxipiat mu'ada buje bit, eyetakoma juk adi epe'e okay! “Ẽn jebodoydoy g̃u! Kapikpig̃ ẽn,” i eyju e'em owebe. “Ẽn Moisés ekawẽn mupubutbun,” i eyju e'em owebe. “Ikẽrẽat mujurũg̃rũg̃ ẽn,” i eyju e'em owebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","— Dao g̃u “Ẽn ikẽrẽat mujurũg̃rũg̃,” i juy epe'e warara'acat pe — io'e. — Tũybe teku ikẽrẽat mujurũg̃rũg̃ iãn eyju e'em. Cekuku am eyetaybit'ũm pima, “Ẽn ikẽrẽat mujurũg̃rũg̃,” i'ũmg̃u juy epe'e'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","— Ite aoka ojuy g̃u du wuyka kukayũ? — io'e ip Jerusalém ka watwat jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","— Ak'i juy epe'e — io'e ip. — Ijoce ma omuy — io'e ip. — Soat etabutpe teku kawẽnwẽn — io'e ip. — Imẽnpit ka'ũma ma ibubum — io'e ip. — Wuyka kukayũ dak itabut xe'e Jesus Deus emunaẽ iap kay? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","— Teku Deus emunaẽ g̃u wuyxe — io'e ip Jerusalém ka watwat'in. — Deus emunaẽ ajẽm puje, abu xe'e itaybit je'e pomawi osodot iam? Ka'ũma ma! Imẽnpit wuyetaybit pomawi teku osodot iam — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus adeayũ mutaybitbin mabuk osunuy Deus eju kawẽnwẽnap'a be―yabog̃at'a be. — Eyetaybit g̃u abu õn iam — io'e Jesus. — Eyetaybit g̃u pomawi ojot iam. Wa'õbi g̃u ojot―omudocat a'õbi acã. Ixe icẽmãn e'em soat em. Eyetaybit g̃u abu ixe iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","— Õn pit wetaybit ixem — io'e. — Ojot cexewi. Ixe ma omudot ijoce — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Imẽneju itakomaayũ Jesus daomũn ojuy ip. Deus pit jewebe ma o'e: — Jesus daomũn g̃u buk ip — i. Imẽnpuye ka'ũma ma o'jat. ");
INSERT INTO myu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tak g̃u o'ya'ĩjojo'iayũ bit itabut o'e ip Jesus kay. Ade jĩjã itabut o'e. — “Deus emunaẽ ja'õbacaap jomõg̃,” i wuyju e'em — io'e ip. — Ite ag̃okatkat ja'õbacaap mõg̃mõg̃ cĩcã. Wuywebe i'e ba'oreat mubapukpug̃ ite ma. Imẽneju ite ma Deus emunaẽ ocexe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Imẽnpuye Jesus daomũn ojuy o'e ip Fariseuyũ. Adeayũ Jesus muwẽnuwẽn iam o'jekũyjo ip Fariseuyũ. Fariseuyũ eju paĩyũ kukukayũ Deus eju kawẽnwẽnap'a wiwi'ukayũ o'g̃uju Jesus daomũn ãm. ");
INSERT INTO myu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","— Darem ma buk õn eyxe — io'e Jesus adeayũ be. — G̃axĩn ma ocepit omudocat kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","— Okudadam epeku. Odobuxik g̃u eyju. Ojuap kay eyju ba'ore — io'e. ");
INSERT INTO myu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","— Apoma sute je'ju? — io'e Judeuyũ kukukayũ. — Poce iba'ore kuka wuywebe tobuxik am? — io'e ip. — Je'ju du sute Judeuyũ xe jenuy ãm Grécia eipi watwat xe jenuy ãm? — io'e ip. — Ipõg̃põg̃ayũ kay du sute je'ju Judeu'ũmayũ mutaybit am? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","— “Okudadam epeku,” i juk o'e ocewebe — io'e ip. — “Imẽnpit eyju odobuxik g̃u,” i juk o'e — io'e ip. — “Ojuap kay eyju ba'ore,” i juk o'e — io'e ip. — Cekawẽn pa'arẽm ocexe — io'e ip Fariseuyũ, paĩyũ kukukayũ dak. ");
INSERT INTO myu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Waram Jesus o'jekawẽn peta mug̃ẽg̃ẽayũ be. Peta epere buje o'jekawẽn cebe ip. Ibo kabia yobog̃ cĩcã osunuy Judeuyũ xe. — Wuybipuruk pima, idibi kay jĩjã wuyju — io'e. — Abu yag̃uyisum ceku pin cĩcã? — io'e Jesus ya'õberen. — Eyetabun cuy epesop okay! — io'e. — Okay eyetabut pima, eyag̃uyisum epeku — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","— Okay itabucayũ be idibi buxim jeenuy badi — io'e. — Imẽnpuye yag̃uyisum ip jeku — io'e. — Imẽn e'em Deus ekawẽntup — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Imẽn e buje Deus biõg̃buk o'g̃uwẽn Jesus. Deus biõg̃buk õmõm Jesus kay itabucayũ be. Jesus iboam o'e ipi kay Deus biõg̃buk ajẽm awap. Ixe oajẽm g̃u buk, Jesus jebay xe jenuy ãm o'jeu g̃u buk puye. ");
INSERT INTO myu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus ekawẽn co buje pũg̃ tag̃ g̃u o'jekawẽn ip adeayũ―wara'at tag̃tag̃tag̃ ma. — Teku Deus ekawẽn muwẽnuwẽn'ukat―ocemumuwiwiiat ma — io'e pũg̃pũg̃ ixeyũ'in. ");
INSERT INTO myu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","— Deus emunaẽ teku — io'e warara'acayũ. — Ka'ũma — io'e warara'acayũ bit. — Deus emunaẽ g̃u teku. Teku Galiléia eipi bewiat! — io'e ip. — Deus emunaẽ Galiléia eipi bewi g̃u jajẽm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","— Imẽn e'em Deus ekawẽntup: Davi naxeg̃ebit Deus emunaẽ, i. Belém ka be je'kap―Judéia eipi be, i. Davi osunuyiat ka be je'kap, i — io'e ip. — Imẽn e'em Deus ekawẽntup — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pũg̃ tag̃ g̃u ip o'jekawẽn adeayũ Jesus muwẽnuwẽn. Jewa'õdawunuwun ip osodop. ");
INSERT INTO myu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jesus daomũn ojuy ip yawiwi'ukayũ. Imẽnpit o'taomũn g̃u buk ip. ");
INSERT INTO myu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jesus kug̃ g̃u yawiwi'ukayũ o'jepit. Oajẽm ip kuy o'g̃uju'iayũ kay―paĩyũ kukukayũ kay, Fariseuyũ kay. — Apẽnpuye Jesus epetojot g̃u? — io'e ip yawiwi'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","— Ixe ekawẽn kawẽntip cĩcã ocexe! Abu-buxim ixe kawẽnwẽn? Ka'ũma buxim ã! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","— Eyju dak eymug̃uykuku du ixe? — io'e ip Fariseuyũ. ");
INSERT INTO myu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","— Ya'õbuyxiayũ itabut g̃u ip cekay―pũg̃ tak ka'ũma — io'e ip. — Oceju dak ocetabut g̃u cekay―pũg̃ tak ocetabut g̃u ma — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","— Adeayũ bit itaybit g̃u Moisés ekawẽn. Imẽnpuye Deus e'em cebe ip “Eykẽrẽ oxe,” i, “Ipiat osupi'ajoat eywebe,” i — io'e ip. — Iteyũ acã itabut cekay―Moisés ekawẽn itaybit'ũmayũ acã — io'e ip Fariseuyũ yawiwi'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemos pit o'jede Fariseuyũ be―jebureyũ be. Ixe Nicodemos ibimãmãmãayũ ekawẽn coco'ukat osunuy. Kuy bima o'ju Jesus kay jekawẽn ãm ceweju. ");
INSERT INTO myu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","— Jesus puk atujuajẽm g̃u wuykay cekawẽn co am, imuymuy'ukayũ ekawẽn co am tak — io'e Nicodemos. — Cekawẽn co'ũm pima, “Ite juy ayaokaat, ikẽrẽat kug̃ puye,” i'ũmg̃u juy ace'e. Imẽn Moisés cuk adi wuymutaybitbin — io'e Nicodemos. ");
INSERT INTO myu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","— Galiléia eipi bewiat co'i ẽn kawẽnwẽn. Deus ekawẽn itaybit'ũmat co'i ẽn kawẽnwẽn — io'e ip Nicodemos wayway. — Ite ag̃okatkat napa ma e'em “Deus ekawẽn muwẽnuwẽn'ukat õn,” i. Deus ekawẽntup cuy etupco! — io'e ip Nicodemos pe. — “Ka'ũmg̃u Deus ekawẽn muwẽnuwẽn'ukat Galiléia eipi beat,” i'e'em ibiatup — io'e ip Nicodemos pe. ");
INSERT INTO myu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Soat ip o'jepit jeduk'a be. ");
INSERT INTO myu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus pit o'ju co'a kay―Oliveira dip'a kay. ");
INSERT INTO myu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kabia isum Jesus waram o'jepit Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Adeayũ o'je'awero Jesus ekawẽn co pin puye. Ixe oabik. Adeayũ mutaybitbin o'e. ");
INSERT INTO myu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","G̃ebuje Fariseuyũ eju Moisés ekawẽn imutaybitbin'ukayũ ayacat o'tojot Jesus kay. Ayacat itoptep ma'g̃u osunuy. Inaka warara'acat itop kay itabiku osunuy. Warara'acat itop eju o'tobuxik ip Fariseuyũ. O'tojot ip Jesus kay. Adeayũ etabutpe ip o'tojot. ");
INSERT INTO myu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","— Kariwa — io'e ip Jesus pe. — Ite ayacat ocetobuxik wara'acat itop eju. Imẽnpuye ocetojot ekay — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","— Moisés o'e wuydobuyũ'ũm'ũm pe: “Wara'acat itop eju jepopomat cuy epeyabug̃bug̃ wita'am,” i. Imẽn Moisés ocemutaybitbin. Pãm ẽn? Apẽn ẽn ece'e? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Imẽn o'e ip Jesus pe. Tũybe cũg̃'ũma jede iãn o'e ip. “Cũg̃ g̃u ẽn e'em,” i'e ojuy ip Jesus pe. “Moisés ekawẽn tag̃ g̃u ẽn e'em,” i'e ojuy ip cebe. Jesus o'je'aetoro. Ipi mukorepkorem o'e jebum. Koreh. Yatoroh ipi mukorepkorem o'e. ");
INSERT INTO myu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","— Apẽn ẽn ece'e? — io'e ip waram. Kirik'ãy. O'ãy. — Ey'inat ikẽrẽat kug̃'ũm pima, ixe juy koam wita'a yamuju cekay ayacat abug̃ am — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Waram o'je'aetoro. Waram jebum ipi mukorepkorem. Koreh. ");
INSERT INTO myu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","O'jẽm ip cekawẽn co buje. Koap aypapayũ o'jẽm õn tak ikẽrẽat kug̃ iam itaybit puye. Warit. Xerewun. Wara'at. Xerewun. Wara'at. Xerewun. G̃uyjom warara'acayũ o'jẽm yaypan'isuayũ. Warit. Xerewun. Wara'at. Xerewun. Soat ip o'jẽm. Jesus acã o'jepoyat. Ayacat Jesus xe o'e cũg̃'i. ");
INSERT INTO myu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kirik'ãy. Jesus o'ãy. O'jeak ayacat kay. — Tũ'ũ — io'e. — Apõma o'ju ip “Ẽn ma ikẽrẽat kug̃ cĩcã Deus xe,” i'e ojuyayũ? “G̃a'a ayaoka wita'am,” i'e ojuyayũ? — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","— Kariwa — io'e. — Ka'ũmg̃u ip — io'e. — O'jẽm ip — io'e. — Weiwat xeyũku. — “Ikẽrẽat kug̃ cĩcã ẽn,” i'ũmg̃u õn tak e'em ewebe — io'e Jesus. — Eju juy — io'e. — Waram pit eg̃ujurũg̃ g̃u ikẽrẽat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Waram pima Jesus o'jekawẽn adeayũ eju. — Kabia buxim õn — io'e. — Deus ekawẽn eymutaybitbin õn cũg̃ ma eyeku am. Okay itabucayũ kabiok tag̃ jekuku'ukayũ buxim g̃u. Ikẽrẽat mujurũg̃rũg̃'uk g̃u ip. Cũg̃ ma ip jekukum kabia dag̃ jekuku'ukat puxim. Yag̃uyisum jekukum ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","— Ẽn acã xipan jewemuwẽnuwẽn — io'e Fariseuyũ. — Cũg̃ g̃u ẽn kawẽnwẽn — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","— Cũg̃ ma õn kawẽnwẽn — io'e Jesus. — Eyetaybit g̃u pomawi ojot iam, poma õn cum iam tak — io'e. — Õn pit wetaybit pomawi ojot iam, poma õn cum iam tak — io'e. — Cũg̃ ma õn kawẽnwẽn wetaybit puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","— Eyju e'em “Cũg̃ ma ẽn kawẽnwẽn,” i, eyxe warara'acat e'eap ibapuk'ũm ma'g̃u. Imẽn g̃u õn pit e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","— “Cũg̃ g̃u ẽn kawẽnwẽn,” i õn e'em pima bit, cũg̃ ma kuka oce. Cũg̃ ma kuka oce, omudocat tak imẽn e'em puye. Webay omudot. Pũg̃ tag̃ ma oceju e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","— Imẽn e'em Moisés ekawẽntup: Xepxepayũ pũg̃ tag̃ ma kawẽnwẽn pima, “Teyũku icẽmãn e'em,” i kuka o'e ip ya'ĩjojo'ibiyũ, i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","— Õn ma xipan jewemuwẽnuwẽn. Webay dak xipan omuwẽnuwẽn―omudocat. Pũg̃ tag̃ ma omuwẽnuwẽn oceju―õn, webay dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","— Poce omuy ebay? — io'e ip Jesus pe. — Etetaybit g̃u abu õn iam, abu webay iam tak — io'e. — Abu õn iam eyetaybit pima, abu webay iam tak kuka eyetaybit epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Imẽn Jesus o'e Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Adeayũ mutaybitbin osunuy. Dinheiro muõmõmap'a xe imutaybitbin osunuy. Cekay itakomaayũ Jesus daomũn ojuy. Imẽnpit o'taomũn g̃u ip taomũnap kabia g̃u buk puye. ");
INSERT INTO myu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","24","Waram Jesus o'jekawẽn Judeuyũ kukukayũ eju. — G̃axĩn ma ojẽm ijocewi — io'e Jesus. — Te'e ma epeku okudadam eydaxijoap ojuy. Epe'ũ Deus pe eywebewi ikẽrẽat uk'ũm pima. Ojuap kay eyju ba'ore — io'e. — “Epe'ũ Deus pe ikẽrẽat uk'ũm pima,” i kuy oce eywebe. Õn Deus xewiat iap kay eyetabut'ũm pima, epe'ũ Deus pe eyewebewi ikẽrẽat uk'ũm pima — io'e Jesus. — “Ojuap kay eyju ba'ore,” i teku e'em — io'e ip Judeuyũ kukayũ. — Jewaoka du sute? — io'e ip jewewebe. — Eyju ma ipi dag̃acat. Õn pit kabi bewiat — io'e Jesus. — Eyju ma jewag̃uyg̃uy ijodiat ag̃uy dag̃. Õn pit ka'ũma. ");
INSERT INTO myu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","— Abu ẽn? — io'e ip. — Iebikam piman ma juk ocewemuwẽn abu õn iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","— Adeat muwẽn pin mabuk õn eywebe. “Cũg̃ g̃u eyju kawẽnwẽn” i'e pin mabuk oce eywebe. Omudocat ekawẽn muwẽnuwẽn acã õn. Ixe icẽmãn e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus jemudocat muwẽn puje, jebay o'g̃uwẽn. Iboap ekawẽn pit Judeuyũ kukayũ itaybit g̃u. ");
INSERT INTO myu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","— Soat wag̃o õn — io'e Jesus. — Obamuapay epe'e we'ũ am korosa be. Obamupaya buje, “Icẽmãn xeku kabi bewiat,” i epe'e. “Ja'õbi g̃u xeku oeku―jebay a'õbi acã,” i epe'e — io'e. — “Wuyebay e'eap muwẽnuwẽn xeku oeku,” i epe'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","— Soat em omudocat bikuyap tag̃ õn jekukum. Imẽnpuye soat em ag̃ okay. Ixe opere g̃u — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Imẽneju ade oitabun Jesus kay―ya'ĩjojo'ukayũ'in. ");
INSERT INTO myu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesus waram o'jekawẽn Judeuyũ kukukayũ eju. Pũg̃pũg̃ ixeyũ'in o'e: — Teku icẽmãn e'em — i. — Wekawẽn kay kũyjobit pima, oweju etaybitbinayũm epesop — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","— Kawẽn icẽmat muwẽnuwẽn õn eywebe — io'e. — Kawẽn icẽmãn eyetaybit pima cekariwa be imudadaybotbot'ibiyũ buximayũm g̃u epesop — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","— Abu ocemudadaybotbot'uk osunuy? Ka'ũma ma! — io'e ip. — Abraão naxeg̃ebitbit oceju! — io'e ip. — Apẽnpuye ẽn e'em ocewebe “Cekariwa be imudadaybotbot'ibiyũ buximayũm g̃u epesop,” i? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","— Icẽmãn õn e'em eywebe — io'e Jesus. — Cekariwa be imudadaybotbot'ibiyũ be iba'ore jekariwa epere am. Imẽnpuxim ikẽrẽat mujurũg̃rũg̃'ukat pe iba'ore ikẽrẽat mujurũg̃rũg̃ap epere am, Satanás ixe ekariwa buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","— Cekariwa be imudadaybotbot'ibit ma soat em g̃u cekariwa duk'a be dopdom. Kariwa imujẽm pin pima, g̃ujẽm. Kariwa ipot pit, soat em jebay duk'a be dopdom. Cebay ixe g̃ujẽm g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","— Õn ma Deus ipot. Owebe eydaxijo buje, Satanás g̃u eykukukan jeenuy — io'e. — Imẽnpuye ikẽrẽat mujurũg̃rũg̃ap epere but epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","— Icẽmãn eyju Abraão naxeg̃ebitbit — io'e. — Inaka eyju oaoka ojuy wa'õ kay kũyjobit'ũm puye — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","— Webay be omutaybitbinap muwẽnuwẽn õn eywebe. Satanás ebekitkit eyju. Ixe ekukuap tag̃ eyju dak jekukum — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","— Ka'ũma! Ocedobu'ũm ekukuap co'i oceju jekukum―Abraão'ũm ekukuap co'i — io'e ip te'e ma. — Deus kawẽn icẽmat o'g̃uwẽn owebe — Jesus o'e. — Iboap ekawẽn acã og̃uwẽn eywebe. Inaka eyju ma oaoka ojuy kawẽn icẽmat kay'ũm puye — io'e. — Abraão bit kawẽn icẽmat kay kũyjobit cĩcã osunuy. Abraão naxeg̃ebitbit eyju. Ixe'ũm ekukuap co'i g̃u bit eyju jekukum — Jesus o'e. — Apẽnpuye dak? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","— Satanás ekukuap co'i eyju jekukum — io'e. — Satanás ekukuap co'i g̃u oceju jekukum―Deus ekawẽn tag̃ ma — io'e ip. — Deus acã ocebay — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","— Deus xewi ojot. Wa'õbi g̃u ojot. Ixe ma omudot — io'e Jesus. — Deus eyebay bima, kajuk okukpin eyxe og̃uy — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","— Wekawẽn kay jekũyjobin pin g̃u eyju. Imẽnpuye wekawẽn pa'arẽm eyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","— Ibiõg̃buk kẽrẽayũ kukat ebekitkiyũ eyju―Satanás ebekitkiyu — io'e―Jesus o'e. — Apẽn ixe ikẽrẽat mujurũg̃rũg̃ iap co'i eyju dak ikẽrẽat mujurũg̃rũg̃ — io'e. — Ixe warara'acat aokaka'uk osunuy ipi mujurũg̃ isum. G̃asũ dak wuyjuyũ muy'ũ'ũ'uk ixe — io'e. — Kawẽn icẽmat kay kũyjobit'ũm osunuy ixe — io'e. — Iba'ore ixe be kawẽn icẽmat kay kũyjobit am. Icẽm g̃u teku e'em. Napa ma e'em. Napa ma e'em pima, je'e pinap tag̃ e'em cexe. Dapxi teku — io'e. — Icẽm'ũmãn e'em ip ixe ebekitkiyũ. ");
INSERT INTO myu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Icẽmat õn pit e'em eywebe — io'e. — Inaka eyetabut g̃u wekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","— Ka'ũma ma icẽmãn e'em owebe “Ikẽrẽat mujurũg̃rũg̃ ẽn” i — io'e. — Icẽmãn wekawẽn. Apẽnpuye eyetabut g̃u wekawẽn kay? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","— Kũyjobit ip cekawẽn kay Deus ebekitkit. Eyju bit Deus ebekitkit g̃u. Imẽnpuye Deus ekawẽn kay g̃u eyju — io'e Jesus Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","— Icẽmãn oceju e'em ewebe “Ibiõg̃buk kẽrẽat a'õbi ẽn e'em” i, “Akpidapi ẽn,” i dak — io'e ip. — “Cũg̃'ũma ẽn jekukum Samaria eipi wat puxim,” i oceju e'em ewebe. Icẽmãn oceju e'em — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","— Icẽm g̃u eyju e'em — Jesus o'e. — Ibiõg̃buk kẽrẽat a'õbi g̃u õn e'em. Webay kug̃ õn ibuyxim. Eyju bit obuyxim g̃u okug̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","— Õn ma obuyxim okug̃ap kudadam g̃u — io'e. — Webay bit obuyxim okug̃. Ixe obuyxim g̃u okukat g̃uju ipiat'ajojoap pe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","— Icẽmãn õn e'em eywebe — io'e. — Wekawẽn tag̃ jekuku'ukat soat em g̃u jeedop ce'ũ'ũayũ xe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","— Ibiõg̃buk kẽrẽayũ kukat a'õbi ẽn kawẽnwẽn — i napa ma o'e ip Judeuyũ kukukayũ. — Abraão'ũm oe'ũ. Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm tak oe'ũ'ũ. “Wekawẽn tag̃ jekuku'ukat soat em g̃u jeedop ce'ũ'ũayũ xe,” i ẽn pit e'em — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","— Ocedobu'ũm oe'ũ―Abraão'ũm. Abraão bit toto osunuy ya'õbuyxiat. Ixe'ũm podi du a'õbuyxi? — io'e ip. — Deus ekawẽn muwẽnuwẽn'ukayũ'ũm'ũm tak oe'ũ'ũ. Ixeyũ'ũm'ũm pit toto osodop ya'õbuyxiayũ. Ixeyũ'ũm'ũm podi du a'õbuyxi? — io'e ip. — Abu dak ẽn? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","— Õn ma xipan jewemuwẽnuwẽn pima, abu kuka wa'õ kay o'e? Ka'ũma ma! — io'e. — Webay bit xipan omuwẽnuwẽn. “Ka'ũmg̃u okpot co'iat ya'õbuyxiat,” i'e'em ixe. “Ẽn acã ocekukukat,” i te'e ma eyju e'em webay be — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","— Eyju ma eyetaybit g̃u abu ixe iam. Õn pit wetaybit ixem. “Wetaybit g̃u ixem,” i õn e buje, napa ma kajuk oce. Eybuxim kajuk oce dapxi. Imẽnpit wetaybit cĩcã ixem. Kũyjobit õn cekawẽn kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","— Wuydobu'ũm Abraão'ũm itaybit o'e ipi kay teku jajẽm wuydaxijojo'ukan iam. Imẽnpuye icokcok o'e — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","— Aypa g̃u ẽn — io'e ip. — Cinquenta koato g̃u buk ẽn — io'e ip. — Abraão ejojojo g̃u! — io'e ip. — Icẽm g̃u ẽn e'em — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","— Icẽmãn õn e'em eywebe — io'e Jesus. — Abraão kap awap ma kuy wetabẽg̃ og̃uy — io'e. ");
INSERT INTO myu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","G̃ebuje wita'a o'yabu ip Jesus kay yamuju am Judeuyũ kukukayũ. Yaoka ojuy ip napa ma tũybe e'em iãn. Jesus pit o'jemunẽm adeayũ parakpe. Xerewun. O'jẽm Deus eju kawẽnwẽnap'a bewi―yabog̃at'a bewi. Akiju o'jẽm. ");
INSERT INTO myu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","G̃ebuje Jesus ita'ũmat o'jojojo doze beayũ eju cũg̃cũg̃ pima. Ikap puje ma ita'ũm osunuy. Dinheiro ojuyjuy'uk osunuy ita'ũm puye. ");
INSERT INTO myu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","— Ocemutaybitbin'ukat — io'e ceweju etaybitbinayũ. — Apẽnpuye ite ita'ũm o'kap? Ita'ũm o'kap ite ma ikẽrẽat mujurũg̃rũg̃ puye du? — io'e ip. — Pãm g̃uto cebay ikẽrẽat mujurũg̃rũg̃ puye du? Pãm g̃uto ixi ikẽrẽat mujurũg̃rũg̃ puye du? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","— Ita'ũm ma o'kap ikẽrẽat mujurũg̃rũg̃ puye g̃u, cebay ikẽrẽat mujurũg̃rũg̃ puye g̃u dak, ixi ikẽrẽat mujurũg̃rũg̃ puye g̃u dak — io'e Jesus. — Deus ja'õbacaap jomõg̃ wuyetabutpe jabeku. Imẽnpuye ita'ũm o'kap — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","— Apẽn kaxi wuymukabiaham iap puxim õn tak Deus ekawẽn ijodiat mutaybitbin ijodi bima cũg̃ ma ceku am ip. We'ũ buje kabiok je'e — io'e. — Deus omudot kapik am jewebeam ja'õbacaap mubapukpuk am. Deus peam cuy acejekapik wuyekapik put pima. G̃uyjom iba'ore je'e wuywebe wuyekapik am cebeam. ");
INSERT INTO myu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O'jexi ipi ju. Xih. A'a'a. Ka'wi o'g̃u'a'a jebidim. Wũnxik. Porog̃. Ka'wi'a'a o'yamuy ita'ũmat eta be imu'ada am. (14) Judeuyũ ebodoydoyap kabia be o'yamuy ita be imu'ada am. ");
INSERT INTO myu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","— Eju juy idibi'it'iti be―Siloédi be — io'e Jesus. — Ecewedopawuy juy idibim — io'e. (Siloé timudot'ibiti iape wuya'õm). Xĩg̃xĩg̃. O'ju jewedopawuy. Jay. Oajẽm idibi'it'iti kay. O'jewedopawuywuy. Boroboro'i. Itate o'e. O'jeu. Jecoatcoan o'e. ");
INSERT INTO myu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Imẽnpuye ita'ũm tũibit tuk'a etakobeayũ o'jekawẽn ip jeweweju, ita'ũm tũibit o'jojojo'iayũ dak. — Ijoce dinheiro ojuyjuy'uk osunuyiat g̃u du sute? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","— Ijoce osunuyiat teku — io'e ip pũg̃pũg̃pũg̃. — Ka'ũma. Ijoce osunuyiat g̃u teku — io'e warara'acayũ. — Ixe-buximat acã teku — io'e ip. — Õn ma ijoce dinheiro ojuyjuy'uk og̃uy — io'e ita'ũm tũibit. ");
INSERT INTO myu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","— Apẽn etate g̃asũ? — io'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","— Ag̃okatkat oajẽm okay — io'e ita'ũm tũibit. — Ibutet Jesus i — io'e. — Ka'wi o'g̃u'a'a. O'yamuy weta be weta mu'ada am. “Eju juy Siloédi be,” i juk o'e owebe — io'e. — “Ecewedopawuy juy,” i dak — io'e. — Imẽnpuye oju. Ocewedopawuy. Wetate oceu — io'e ita'ũm tũibit. — Wecoan put oce — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","— Poce omuy ixe Jesus? — io'e ip. — Iye. Wetaybit g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","G̃ebuje Fariseuyũ kay tuk'a etakobeayũ ita'ũm tũibit o'tujowat. ");
INSERT INTO myu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","16","— Apẽn ecewetada g̃asũ? — io'e ip Fariseuyũ ita'ũm tũibit pe. — Ka'wi'a'a o'yamuy weta be — io'e. — Ocewedopawuy. Wetate g̃asũ oce — io'e. — Itadaat o'jekapik jebodoydoyap kabia be―Sábado bima — io'e ip Fariseuyũ. — Moisés ekawẽn tag̃ g̃u ite jekukum. Deus a'õbi g̃u ite e'em — i napa ma o'e ixeyũ Fariseuyũ. — Ikẽrẽat mujurũg̃rũg̃'ukat g̃u itadaat! Apẽn kuka ikẽrẽat mujurũg̃rũg̃'ukat pe wuywebe i'e ba'oreat mubapuk put? — io'e warara'acayũ. Imẽneju pũg̃ tag̃ g̃u ip Jesus muwẽnuwẽn o'e Fariseuyũ. Wara'at tag̃tag̃tag̃ ma kawẽnwẽn ip o'e. ");
INSERT INTO myu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","— Pãm ẽn? — io'e ip ita'ũm tũibit pe. — Ixe etadaat. Abu ixe exe? — io'e ip. — Deus ekawẽn muwẽnuwẽn'ukat xeku — io'e ita'ũm tũibit. ");
INSERT INTO myu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judeuyũ kukuk'ukayũ ibu'u ip o'e jetabut am ita'ũm tũibit a'õ kay. — Ita'ũm g̃u teku osunuy — io'e ip itabut'ũm puye. Imẽnpuye ita'ũm tũibit ebay o'g̃udot ip, ixi dak. O'jekawẽn ip ceweju ip yajẽm puje. ");
INSERT INTO myu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","20","— Ekpot tu ig̃o? — io'e ip cebay be. — Hm hm. Okpot ig̃o — io'e cebay. — Ita'ũm tu o'kap? — io'e ip. — Hm hm, ita'ũm g̃oku o'kap. — Apẽn tak o'jewetada g̃asũ? — io'e ip cebayũ be. ");
INSERT INTO myu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","— Wetaybit g̃u bit apẽn xe'e o'jewetada iam — cebay o'e. — Wetaybit g̃u abu ixe o'g̃u'ada iam — io'e. — Ig̃o eju ma juy epeyekawẽn — io'e ip Judeuyũ kukukayũ be. — Ite ma jewetadaap g̃uwẽn eywebe. Bekit g̃u g̃oku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Imẽn o'jede ip, Judeuyũ kukukayũ buxim iparara buye. Judeuyũ kukukayũ juk o'e jebekitkit pe: — “Jesus Deus emunaẽ,” i eyju e'em pima, eymuõmat g̃u kuka oce'e Deus eju kawẽnwẽnap'a be — i. ");
INSERT INTO myu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Imẽnpuye iparara o'e ip Judeuyũ kukukayũ buxim. Imẽnpuye ixeyũ o'e: — Bekit g̃u g̃oku — i. — Je'adaap g̃uwẽn eywebe — i. — “Apẽn ece'ada?,” i juy epe'e cebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fariseuyũ waram ita'ũm tũibit o'tojocat jewekay. — Deus etabutpe wuyju nuynuy — io'e ip. — Imẽnpuye icẽmãn ma juy ece — io'e ip Fariseuyũ. — Etadaat ikẽrẽat mujurũg̃rũg̃'ukat — io'e ip napa ma. — Ocetaybit iboam — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","— Wetaybit g̃u ikẽrẽat kug̃ xe'e ixe iam — io'e ita'ũm tũibit. — Wetaybit wetate g̃u ojop iam. G̃asũ bit wetate ma oce — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","— Apẽn sute o'e ewebe? — io'e ip. — Apẽn etada? — i waram o'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","— Kuy juk iboap og̃uwẽnuwẽn eywebe — io'e. — Eyju bit eyetabut g̃u wa'õ kay. Apẽn eyju dak waram wa'ĩjo pin eyxe? — io'e ita'ũm tũibit. — Ixe ebekitkiyũm pin paxi eyju dak? — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","— Ap! Ixe ebekitkiyũm pin g̃u oceju! — io'e ip. — Ekawẽnkẽrẽ jĩjã ocexe! — io'e ip. Oitakomãn ip ita'ũm tũibit kay. O'g̃ukorẽm cĩcã ip. — Ẽn ma ite ebekit — io'e ip. — Oceju bit Moisés ebekitkit — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","— Ocetaybit Deus a'õbi Moisés e'e'uk osunuy iam. Ocetaybit g̃u abu a'õbi sute e'em iam — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","— “Abu-a'õbi sute e'em?” i eyju e'em — io'e. — “Deus a'õbi ite wetada,” i õn pit e'em — io'e. — Iboap iwaru jĩjã oxe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","— Wuyetaybit Deus ikẽrẽat mujurũg̃rũg̃'ukat ekawẽn a'ĩjojom g̃u ibuywat am iam. Jebikuyap tag̃ jekuku'ukat ekawẽn a'ĩjojom pit ibuywat am. Jebuyxim jekukat ekawẽn a'ĩjojom Deus. ");
INSERT INTO myu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka'ũma ma teku ita'ũm o'kap'iat o'sutada iap awẽg̃ o'yawẽg̃tobuxik. Kuyje dak iboap awẽg̃ o'yawẽg̃tobuxik g̃u — io'e. — G̃asũ bit Jesus wetada — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","— Deus a'õbi'ũm pima, iba'ore kajuk o'e cebe wetada am. Deus a'õbi ma ite wetada — io'e ita'ũm tũibit. ");
INSERT INTO myu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","— Warara'acat podi ma ikẽrẽat kug̃ ẽn! Eta'ũm ekap ikẽrẽat kug̃ cĩcã buye! — io'e ip napa ma. — Ẽn tu ocemutaybin pin? Ejẽm cuy ocexewi! — io'e ip. — Ejẽm cuy Deus eju kawẽnwẽnap'a bewi! — io'e ip. — Waram cuy eõm g̃u ijop'a be — io'e ip. O'g̃ujẽm ip itakoma ita'ũm tũibit kay buye. ");
INSERT INTO myu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","G̃ebuje Jesus ita'ũm tũibit o'tobuxik. O'tobuxik Fariseuyũ be ixe mujẽm iap awẽg̃ tobuxik puje. O'jekawẽn ceweju. — Tapu, ẽn pit tu etabut Deus ipot kay? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","— Abu sute, Kariwa? — io'e ita'ũm tũibit. — Ixe juy eg̃ubapuk omutabut am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","— Ixe jojom ẽn g̃asũ―eweju kawẽnwẽnat cocom — io'e. — Õn ma ixe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O'jẽg̃'aecõg̃cõg̃ Jesus wap Jesus ya'õbuyxi cexe buye. — Kariwa, wetabut oce ekay g̃asũ bit — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","— Pũg̃pũg̃ ipi dag̃ayũ'in cũg̃ ma Deus xe wedot puye. Okay itabucayũ cũg̃ ma cexe. Itateayũ buxim ip — io'e Jesus. — Warara'acayũ bit ikẽrẽ cexe. Itabut'ũmayũ ikẽrẽ cexe — io'e. — “Wetaybitsũ mabuk Deus ekawẽn. Imẽnpit wetaybin pin cĩcã,” i'e'em warara'acayũ. G̃uyjom ixeyũ itabut je'e okay — io'e Jesus. — Warara'acayũ bit te'e ma e'em “Wetaybit Deus ekawẽn,” i. Itabut g̃u je'e ip okay. Ita'ũmayũ buxim ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","— Te'e ma du oceju e'em “Ocetaybit Deus ekawẽn,” i? — io'e ip Jesus pe, pũg̃pũg̃ Fariseuyũ'in. ");
INSERT INTO myu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","— “Ocetaybitsũ ma Deus ekawẽn. Imẽnpit ocetaybin pin cĩcã,” i ey'e buje, ikẽrẽat kug̃ g̃u kajuk epe'e Deus xe. Imẽnpit te'e ma eyju e'em “Ocetaybit cĩcã Deus ekawẽn,” i. Imẽnpuye ikẽrẽat kug̃ eyju cexe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","G̃ebuje Jesus wuymutaybitbinap ekawẽn o'g̃uwẽn adeayũ be. Ovelha ekawẽn o'g̃uwẽn cebe ip. — Icẽmãn õn e'em eywebe — io'e. — Ovelha ekorara be iõm pinat, xĩntabi be g̃u õmõm pima. “Teku ovelha bu pin,” i wuyju e'em. “Teku ovelha dujupa'um'um'ukat,” i wuyju e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","— Ovelha kukuk'ukat pit korara exĩntabi be õmõm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","— Korara exĩntabi wiwi'ukat xĩntabi muywekweg̃ ovelha kukat õm ãm. Ovelha jekukat a'ĩjojom. Ikukat jeõhõ nomuwãwãm ibuten e'em. Jeõhõ mujẽmjẽm akiju korara exĩntabi be jekorara bewi — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","— Imujẽm puje cucum jeõhõyũ wap. Ovelha jekukat nomuju cucum jekukat a'õm itaybit ip puye. ");
INSERT INTO myu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wara'acat nomuju bit taobu'u ip cum. Itaybit g̃u ip wara'acat a'õm. Jekukat a'õm acã itaybit ip. Wara'acat puxim pit jenapõnpõn ip itaybit'ũm ya'õm puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ovelha ekawẽn o'g̃uwẽn Jesus. Xepxep pe o'jekawẽn. Ovelha muwẽnuwẽn pima, jekay itabucayũ dak o'g̃uwẽn. Imẽnpit cekawẽn pa'arẽm o'e cexe ip―adeayũ xe. ");
INSERT INTO myu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Waram Jesus o'jekawẽn cebe ip. — Icẽmãn õn e'em eywebe — io'e. — Xĩntabi dag̃ ovelha õmõm korara be. Korara be bima abu-be ixeyũ muy'ũ but? Ka'ũma be ma. Imẽnpuxim soat em ag̃ õn okay itabucayũ kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","— Ovelha itaybit g̃u dujupa'um'um'ukat a'õm. Imẽnpuxim okay itabucayũ itabut g̃u icẽm'ũma wuymutaybitbin'ukayũ ekawẽn kay. Wajẽm awap osodot'iayũ icẽm g̃u wuyjuyũ o'g̃utaybitbin — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","— Xĩntabi dag̃ ovelha õmõm korara be. Cẽmcẽm ip jexat kudadam. Korara be bima abu-be ixeyũ muy'ũ but? Ka'ũma be ma! Imẽnpuxim wuyjuyũ okay itabun puje soat em ag̃ õn ixeyũ kay. Abu-be ixeyũ muy'ũ but? Ka'ũma be ma! — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","— Tujupa'um'um'ukat ma ajẽmjẽm ovelha dujupa'um ãm, ixeyũ aoka am tak. Õn pit ojot ijodiat ag̃uymuisun am. Okay itabucayũ yag̃uyisum jekukum. Ojot ixeyũ mucokcok am — io'e. — Okay itabucayũ icokcok cĩcã — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","— Okay itabucayũ kug̃ õn xipan ikukat jeõhõ kug̃ xipan iap puxim — io'e. — Ovelha kukat puxim õn. Obu'u g̃u we'ũ ãm warara'acat pe okay itabucayũ aokaap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","— Ovelha kukukat a'õbuywatwat'ukat ikukukat g̃u. Dinheiro bu am acã kapikpig̃. Ovelha iwat g̃u―ibuywatwat'ukat acã. Ovelha iwatiwan kak ajẽm puje. Jenapõnpõn kak puxim iparara buye. Kak ovelha bubum. Ovelha muwatwan soat tag̃. ");
INSERT INTO myu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","— Ibuywatwat'ukat jenapõnpõn dinheiro bum acã kapikpig̃ puye. Ibu'u ovelha kug̃, cexe ikukpin'ũm puye. ");
INSERT INTO myu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ovelha kukukat puxim õn―xipacat puxim — Jesus o'e. — Wetaybit webay. Webay dak itaybit õn. Imẽnpuxim õn tak wetaybit okay itabucayũm. Ixeyũ dak itaybit õn — io'e. — Obu'u g̃u we'ũ ãm okay itabucayũ e'ũap puxim — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","— Soat g̃u ovelha pũg̃ ekorara be. Imẽnpuxim soat ka dag̃acat itabut je'e okay — io'e Jesus. — Wa'õ kay je'e ip kũyjobit. Pũg̃ tag̃ ma ip jeku — io'e. — Soat ixeyũ kukan og̃uy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","— Oje'ũ okay itabucayũ e'ũap puxim. Waram g̃uto õn pit ocetait we'ũ buje. Imẽneju webay xe okukpin cĩcã obu'u'ũm puye we'ũ ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","— Obu'u we'ũ ãm pima, iba'ore kajuk o'e warara'acat pe bit oaoka am. “Ece'ũ” i juk o'e webay owebe. “Waram g̃uto etait ece'e,” i dak. Wukpiwatpi ma oje'ũ, webay ukpiwatpi dak. Wukpiwatpi ma waram g̃uto wetait oce'e, webay ukpiwatpi dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Imẽneju pũg̃ tag̃ g̃u ip Jesus ekawẽn o'g̃uwẽn―wara'at tag̃tag̃tag̃ ma Judeuyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","— Ibiõg̃buk kẽrẽat kug̃ teku — io'e ip napa ma ade ixeyũ'in. — Imẽnpuye yukpidapi — io'e ip napa ma. — Apẽnpuye dak eyju ixe a'ĩjojom? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","— Ibiõg̃buk kẽrẽat kukat pit imẽn cekawẽn pa'ore! — io'e warara'acayũ bit. — Apẽn kuka ibiõg̃buk kẽrẽat kukat ita'ũmat o'sutada? — io'e ip Jesus pe jededem. — Iba'ore itada am ibiõg̃buk kẽrẽat kukat pe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","24","Waram pima Judeuyũ kukukayũ o'ju Jesus kay. Jerusalém ka beayũ peta mug̃ẽg̃ẽm ip osodop Judeuyũ. Peta mug̃ẽg̃ẽm ip osodop apẽn kuyjeayũ Deus eju kawẽnwẽnap'a o'yamudim iap kay g̃ebum am. Ihi bima peta mujurũg̃rũg̃'uk osodop ip. Jesus Deus eju kawẽnwẽnap'a etaybu dag̃ cũg̃cũg̃ o'e―Salomão emuamuy'a etaybu dag̃. Oajẽm ip Jesus kay Judeuyũ kukukayũ. O'jekawẽn ip Jesus eju. — Ẽn tu Cristo―Deus emunaẽ? — io'e ip. — Ibapug̃ cuy eg̃uwẽn ocewebe — io'e ip. — Ade kabia emuwẽnap wiwim ocesop — io'e ip. — Iba'arẽm acã ẽn kawẽnwẽn ocewebe. Ẽn Deus emunaẽ bima, Cristo bima, ibapug̃ cuy eg̃uwẽn ocewebe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","— Kuy juk adi ocewemuwẽnuwẽn eywebe―ade em ma — io'e Jesus. — Imẽnpit eyetabut g̃u wa'õ kay — io'e. — Webay a'õbi wa'õbacaap ojomõg̃mõg̃ eyetabutpe — io'e. — Teku Deus emunaẽ iap mubapukpug̃ og̃uy eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","— Imẽnpit eyetabut g̃u wa'õ kay, okay eyetabut'ũm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","— Okay itabucayũ kũyjobit wa'õ kay ovelha jekukat a'õ kayap puxim — io'e Jesus. — Wetaybit ixeyũ e'eam. Wekawẽn tag̃ jekukum ip ovelha jekukukat a'õm itaybicap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","— Ixeyũ ag̃uymuisusun õn. Warara'acayũ bit ixeyũ ju'uk g̃u obui bewi―pũg̃ tak ka'ũma. Soat em itait jeedop ip Deus xe je'ũ buje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","— Webay ixeyũ o'g̃utabun okay weõhõyũ buximayũm. Warara'acat podi ma ja'õbacaap kug̃ webay. Abu-be ixeyũ uk put webay bui bewi―weõhõyũ uk put? Ka'ũma be ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","— Jewa'õca jojo'i oceju webay eju — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iboap co buje, waram wita'a o'yabu ip Jesus abug̃ ojuy am Judeuyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","— Webay a'õbi juk adi wa'õbacaap ojomõg̃mõg̃ eyetabutpe―ade ma — io'e Jesus. — Apẽnpuye dak eyju wabug̃ ojuy wita'am? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","— “Ekẽrẽ Deus xe, juk adi a'õbacaap ejomõg̃mõg̃ puye,” i'ũmg̃u oceju e'em ewebe — io'e ip. — “Ekawẽnkẽrẽ Deus xe,” i acã oceju e'em ewebe — io'e ip. — Ẽn ijodiat acã. Imẽnpit “Oceju jewa'õca jojo'i ma webay eju,” i napa ma ẽn e'em — io'e ip jetakoma pibun. — Imẽneju abug̃ ojuy oceju — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","— Imẽn e'em Deus ekawẽntup: Eyju dak Deus a'õbiayũ — io'e Deus kuyje, i. Deus kuyje o'e “Deus a'õbiayũ eyju” i jekawẽn muwẽn ãm taẽhẽ'ibiyũ be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","— Deus ekawẽntup napa g̃u e'em―pũg̃ em tak ka'ũma. Icẽmãn e'em. Wuyetaybit iboam — io'e Jesus Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","— Õn ma Deus cuk onaẽ ijodiat taxijo am. Õn ma ixe omudot — io'e Jesus. — Apẽnpuye eyju napa ma e'em “Ekawẽnkẽrẽ Deus xe,” i, “Jewa'õca jojo'i oceju webay eju,” i õn e'em puye? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","— Webay a'õbi'ũm pima, eyetabun g̃u juy epesop okay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","— Wekawẽn coco am eyetabut'ũm pima, eyetabun cuy epesop wa'õbacaap mõg̃mõg̃ap coco am — io'e. — Eyetabun puje “Jesus ya'õbaca cebay a'õbacaap co'i,” i epe'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Imẽneju Jesus daomũn ojuy ma'g̃uto ip Judeuyũ kukukayũ. Jesus pit o'jenapõn jenaomũnap puxim. ");
INSERT INTO myu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wara'at ka kay o'ju Jesus. Toktek. Jordãodi waram o'timudek. Jay. Oajẽm João Batista be adeayũ mubatisasan osunuy iatka kay. Wĩnãbu osunuy. ");
INSERT INTO myu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","G̃ebuje ade ibo ka watwat o'tabun Jesus kay―Jordãodi wĩnãbuayũ. — João Batista ma wuywebe i'e ba'oreat o'g̃ubapukpuk g̃u — io'e ip adeayũ jewewebe. — Imẽnpit ixe ag̃okatkat muwẽnuwẽn'uk osunuy ocewebe. Icẽmãn João ixe o'g̃uwẽnuwẽn — io'e ip. Imẽnpuye Jesus kay itabut o'e ip adeayũ. ");
INSERT INTO myu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lázaro iwãtaxipi o'e. Maria kipit iwãtaxipi o'e―Betânia ka beat. Imẽnpuye iixĩyũ Lázaro wãtaxipiap awẽg̃ o'yawẽg̃muju Jesus kay. Betânia ka watwat osodop ip―Maria, Marta dak, Lázaro dak. ");
INSERT INTO myu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","G̃uyjom ixe Maria wuykukukat i o'suimude'on tide'oatim. Ixe o'suimupuruk jadam. Imẽn o'e jexe Jesus ikukpin cĩcã buye. Yawẽg̃tujowacat oajẽm Jesus kay. Jay. ");
INSERT INTO myu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","4","— Kariwa — io'e Jesus pe. — Lázaro iwãtaxipi jĩjã — io'e. — Exe ikukpinat iwãtaxipi o'e — io'e. — Kuy wetaybit — io'e Jesus. — Iwãtaxipi jĩjã opop — io'e. — Ce'ũ buje dak jeedop g̃u ce'ũ'ũayũ xe. G̃uyjom adeayũ je'e “Deus soat podi ma ya'õbaca; soat podi ma idip,” i — io'e. — “Deus ipot tak ya'õbaca―soat podi ma ya'õbaca,” i je'e ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus xe Marta ikukpin cĩcã osunuy. Maria dak ikukpin cĩcã osunuy, Lázaro dak. ");
INSERT INTO myu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Inaka Jesus xepxep xet osunuy jenuyap ka be iwãtaxipiat awẽg̃ tobuxik puje. O'ju g̃u buk Lázaro kay. Xet. Xet. ");
INSERT INTO myu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","G̃ebuje Jesus o'jekawẽn 12 beayũ eju―jeweju etaybitbinayũ eju. — G̃a'a bukto acepit Judéia eipi kay waram — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","— Ocemutaybitbin'ukat — io'e ip. — Iboceat abug̃ ojuy g̃axĩn ma wita'am―Judeuyũ kukukayũ. Waram tak tu iboce eju pin? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","— Hm hm — io'e. — Wekapik put mabuk owebe. Pũg̃ kabia be doze hora kabiaham wuyju — io'e. — Ixima be cũg̃cũg̃at kuka o'at kabiok puye. Kabia dag̃ cũg̃cũg̃at pit kuka o'at g̃u kaxi imukabiaham puye. Imẽnpuxim Deus bikuyap tag̃ jekuku'ukat je'ũ g̃u jekapikap mu'ũm'ũm pima. G̃a'a aju. Oaokam g̃u buk ip, we'ũap kabia oajẽm g̃u buk puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Waram Jesus o'jekawẽn ceweju ip―doze beayũ eju. — Wuybure, Lázaro opop ixet — io'e―Jesus o'e. — Õn pit cum ixe muwurũg̃ ãm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","— Kariwa — io'e ip. — Ixet pima, kuka o'je'ada — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus itaybit o'e Lázaro'ũm oe'ũ iam. Imẽnpit — Lázaro ixet — io'e cebe ip. Imenpuye tũybe Lázaro ixet iãn o'e ip 12 beayũ. ");
INSERT INTO myu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Imẽnpuye Jesus ibapug̃ o'jekawẽn cebe ip. — Lázaro'ũm oe'ũ — io'e. Imẽn o'e ixeyũ mutaybit am. ");
INSERT INTO myu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","— Oju g̃u cekay ce'ũ awap — io'e. — G̃asũ bit wa'õbacaap og̃ubapuk eywebe eymutabun am okay. Wa'õbacaap kay eyetabut cĩcã bima, ocokcok og̃uy. G̃a'a aju ixe'ũm kay g̃asũ bit — io'e doze beayũ be. ");
INSERT INTO myu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","— G̃a'a wuyju dak aju ceweju. Ãg̃ itakomaayũ wuyju dak wuyaoka Jesus aoka buje — io'e Tomé―jebureyũ be o'e, xepxem ikap'ibit. O'ju ip Lázaro'ũm com. ");
INSERT INTO myu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Jesusyũ oajẽm Betânia ka xe. Betânia ka Jerusalém ka etako o'sukadop. Ebapũg̃ kilometro o'sukadop Jerusalém ka bewi. Lázaro'ũm kay yajẽm awap oe'ũiap awẽg̃ o'yawẽg̃tobuxik Jesus. — Lázaro'ũm o'g̃uõm ip witabikũy be — io'e ip Jesus pe. — Ebadipdip xet omuy ikũy be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lázaro'ũm ixĩtyũ mudiu ip o'e―Marta, Maria dak. Ade ibureyũ ixeyũ mug̃uycũg̃ap mu'ũm ojuy ip o'e. ");
INSERT INTO myu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus omuyku iap awẽg̃ Marta o'yawẽg̃tobuxik. G̃ebuje Marta o'ju Jesus dopabe. Jesus e dag̃ mabuk oeku. Maria bit jeduk'a be osunuy. ");
INSERT INTO myu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jay. Oajẽm Jesus kay. — Kariwa — io'e Marta. — Ẽn ijoce bima, okipit'ũm kajuk oe'ũ g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","— Imẽnpit Deus emujoojuyjuy je'g̃ũm ewebe. Wetaybit iboam. Deus eju okipit'ũm peam ekawẽn puje, Deus jekawẽn a'ĩjojo — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","— Ekipit'ũm waram jeu ce'ũ'ũayũ xewi — io'e Jesus Marta be. ");
INSERT INTO myu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","— Wetaybit ixe'ũm waram jeu iam — io'e Marta. — Waram wuyeu buje, ixe'ũm tak jeu―wuyebay soat ce'ũ'ũayũ muyuap kabia be — io'e Marta. ");
INSERT INTO myu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","— Õn ma ce'ũ'ũayũ mutaicit'ukat — io'e Jesus. — Wa'õbi ce'ũ'ũayũ waram g̃uto jetait — io'e. — Okay itabucat e'ũ buje, waram g̃uto jetait. Soat em jeedop ip itait Deus xe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","— Okay itabucat ce'ũ'ũayũ xe g̃u jeenuy―Deus xe acã. Etabut tu iboap kay? — io'e Jesus Marta be. ");
INSERT INTO myu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","— Hm hm, wetabut, Kariwa — io'e. — Ẽn Deus emunaẽ oxe — io'e. — Deus ipot ẽn — io'e. — Ocemumuwiwi ẽn. Wetabut iboap kay — io'e Marta. ");
INSERT INTO myu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jesus eju jekawẽn epere buje, Marta o'jepit jekibit tomuwã ãm. Ya'õapĩn ma Maria o'tomuwã uk'a beacat pe ja'ĩjojoap puxim. — Tũ'ũ — io'e. — Ejot puk — io'e. — Wuyekariwa omuyku jexem — io'e. — E dag̃ omuyku — io'e. — Enomuwãwãm — io'e jekibit pe, Maria be. — Ejot puk — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria o'ju Jesus dopabe e dag̃at topabe. ");
INSERT INTO myu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus ag̃oka be oexe g̃u mabuk. Wũy mabuk oeku. E dag̃ mabuk oeku. Marta be jedopabijukap pe mabuk osunuy. ");
INSERT INTO myu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judeuyũ o'ju Maria nomuju―Lázaro'ũm duk'a beacat―iixĩt mug̃uycũg̃ap mu'ũm ojuyayũ. Ixeyũ etabixewi Maria o'jẽm jeduk'a bewi. Imẽnpuye o'jẽm ip ixe nomuju. Tũybe ite witabikũy be cum wa am iãn o'e ip. ");
INSERT INTO myu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jay. Maria oajẽm Jesus kay. O'jẽg̃'aecõg̃cõg̃ cewap. — Kariwa — io'e. — Ẽn ijoce bima, okipit'ũm kajuk oe'ũ g̃u — io'e Maria. ");
INSERT INTO myu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria o'tõn. Maria eju yajẽm'ibiyũ dak wawa osodop ip Lázaro'ũm cocom. Jesus ig̃uycũg̃ cĩcã o'e wawaayũ jojom. Tadaybotbot cĩcã ip cexe o'e wawaayũ. ");
INSERT INTO myu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","— Poce ixe'ũm epeg̃uõm? — io'e Jesus. — Kariwa, ejot puk — io'e ip. — Ejojo buk — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus o'tõn g̃ebuje bit. Ah. Wa. Imẽnpuye: ");
INSERT INTO myu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","— Ak'i cekay — io'e ip Judeuyũ. — Lázaro'ũm ikukpin cĩcã osunuy cexe — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","— Ita'ũm tũibit o'sutadada teku — io'e warara'acayũ ixeyũ'in. — Iba'ore g̃u du juk o'e cebe Lázaro mu'ada am ce'ũap puxim? — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","G̃ebuje Jesus o'ju witabikũy kay―Lázaro'ũm muõmapkũy kay. Ig̃uycũg̃ cĩcã o'e. O'ju Marta eju, Maria eju, Lázaro'ũm cocoayũ eju dak. Yabog̃at'a o'yanuy wita'a ikũy nomudip'am. Ikũynomudip cem osunuy. ");
INSERT INTO myu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","— Ikũynomudip'a juy epeyamuwede — io'e Jesus. — Kariwa, eyamuwedeat g̃u juy — io'e Marta. — Ig̃ẽm xeku opop. Ebadipdip xet opop witabikũy be — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","— “Okay etabut pima, Deus ja'õbacaap kuka o'jomõg̃ etabutpe,” i kuy oce ewebe — Jesus o'e. — Etabun cuy eg̃uy — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ikũynomudip'a o'yamuwede ip ikũy etako bewi. Jesus o'jekawẽn Deus eju. — Bay — io'e. — Soat em ẽn wa'ĩjojom — io'e. — Imẽnpuye “Ẽn xipat cĩcã,” i õn e'em ewebe — io'e Jesus jebay be. ");
INSERT INTO myu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","— Bay, soat em wekawẽn cocom ẽn — io'e. — Eweju õn kawẽnwẽn ijoceayũ be wa'ĩjo am―ixeyũ mutabut am teku Deus emumudot iap kay — io'e Jesus Deus pe, jebay be. ");
INSERT INTO myu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jebay eju jekawẽn epere buje, Jesus ya'õberen o'jewãwã Lázaro'ũm kay. — Lázaro, ejẽm cuy! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ce'ũ topibit o'jetait waram. O'jẽm witabikũy bewi. Soat tag̃ ijebit tag̃ imũnmũn mabuk oeku pag̃õm. Yamũnmũn mabuk oeku. — Eju'uk cuy pag̃o cebewi — io'e Jesus. O'ju'uk ip pag̃o. ");
INSERT INTO myu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Imẽneju oitabun ip Jesus kay Judeuyũ ma―Maria ejuacayũ ma―adeayũ―Jesus Lázaro'ũm o'g̃utait iap o'jojojo'iayũ ma. ");
INSERT INTO myu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Warara'acayũ bit o'ju Fariseuyũ kay. — Jesus Lázaro'ũm o'g̃utait waram — io'e ip Fariseuyũ be. ");
INSERT INTO myu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","G̃ebuje paĩyũ kukukayũ o'je'awero ip Fariseuyũ eju, jewãwẽwẽ'ukayũ eju dak. O'jewãwẽ ip jeweweju. — Apẽn kuka dak ace Jesus pe? — io'e ip jewewebe. — Wuywebe i'e ba'oreat mubapukpug̃ adeayũ etabutpe. Imẽnpuye ade itabut cekay — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","— Apẽn kuka dak ace cebe ja'õbacaap mõg̃ap puxim? — io'e ip jewewebe. — Apẽn kuka dak ace adeayũ be jetabucap puxim? — io'e ip. — Itabut puje ip Jesus pe jekukukan je'e ip. Jesus pe jekukukan pima, Roma ka kukat jebekitkit kuka o'g̃udot wuykay — io'e ip. — Wuyka kuka ip o'sukamu'ũm. Deus eju kawẽnwẽnap'a dak kuka ip o'yamu'ũm. Soat ka dag̃ kuka ip wuymuypõg̃põg̃põg̃. Wuydobuyũ'ũm'ũm ekawẽn tag̃ g̃u kuka ajeku — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifás o'jekawẽn warara'acat eju―jawẽwẽ'ukayũ eju. Ixe Caifás paĩyũ kukukat osunuy ixe koato be. — Eyetaybit'ũmãn! — io'e Caifás jeweju jewawẽwẽ'ukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","— Cũg̃ ma ixe ag̃okatkat e'ũ ãm. Xipat kuka o'e pũg̃ pe ag̃okatkat pe je'ũ ãm soat e'ũap tieg̃―wuye'ũap tieg̃ — io'e―Caifás o'e. ");
INSERT INTO myu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Deus ibikuy osunuy Jesus e'ũ ãm soat e'ũ'ũap puxim. Caifás pit itaybit g̃u osunuy imẽn Deus ibikuy iam. — Xipat kuka o'e pũg̃ pe ag̃okatkat pe je'ũ ãm soat e'ũap puxim―wuye'ũap tieg̃ — i juk o'e itaybit g̃u ma'g̃u. Caifás jag̃uy dag̃ g̃u imẽn o'e―Deus ag̃uy dag̃ acã. ");
INSERT INTO myu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ixe je'ũ Judeuyũ e'ũ'ũap tieg̃. Warara'acayũ e'ũ'ũap tieg̃ tak je'ũ. Je'ũ Deus ebekitkiyũ be pũg̃ tag̃ ma jeku am. ");
INSERT INTO myu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Imẽneju apẽn paxi Jesus aceyaoka iam jekawẽnwẽn oekuku ip jeweweju Judeuyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Imẽnpuye Jesus ibapug̃ g̃u oeku Judeuyũ kukukayũ etabun Judéia eipi dag̃. O'jẽm ibocewi. Wara'atka be o'ju―Efraim ka be. Ibo ka uk'a'ũmat xe o'sukadop. Iboka be osunuy doze beayũ eju―jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ade Judeuyũ o'ju Jerusalém ka kay. Peta mug̃ẽm ip o'ju. Ig̃o epeta bima apẽn Deus wuydobuyũ'ũm'ũm o'tujujẽm Egito eipi bewi iap kay g̃ebũm ip osodop. Soat ka dag̃wi o'ju ip Jerusalém ka kay. Peta mug̃ẽ awap o'ju ip jewemuisun am jebabi dag̃. — Jewemuisun puje, xipat acesop Deus xe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Paĩyũ kukukayũ o'jekawẽn peta mug̃ẽg̃ẽayũ eju―Fariseuyũ dak. — Poce Jesus nuyãm eyetaybit pima, epeg̃uwẽn cuy ocewebe — io'e ip. Iboam o'e ip Jesus daomũn ojuy buye. Imẽnpuye Jesus ajẽmap wiwim cĩcã osodop ip adeayũ. — Jesus omuyku du peta kay? — io'e ip jewewebe. — Omuyku g̃u xe'e? — io'e ip. Deus eju kawẽnwẽnap'a be o'jekawẽn ip jewewebe adeayũ―yabog̃at'a be. ");
INSERT INTO myu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesus waram o'ju Lázaro kay―waram g̃uto o'jetait'iat kay. Betânia ka be osunuy Lázaro. O'ju peta mug̃ẽ awap. Seis kabia kuka Páscoa epeta ip o'g̃uy'at. Oajẽm doze beayũ eju. ");
INSERT INTO myu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Marta puybit mõg̃mõg̃ o'e Jesus pe i'o am, doze beayũ be dak. Lázaro jekõnkõn o'e Jesusyũ eju. ");
INSERT INTO myu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","G̃ebuje Maria tide'oati o'tibu. Ti'ade o'tibu. Nardo i tibutet osunuy. Tiwekoykeyati g̃u o'tinuy―nardodi acã. Tideibog̃ cĩcãati o'tinuy. Puy. O'suiabi Jesus i. O'suisup jadam. Tide'okuati o'tinuy. Soat tag̃ o'e uk'a yabi de'o. De'ooooh. Imẽn o'e Maria ma. ");
INSERT INTO myu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariotes pit Maria o'g̃ukorẽm―Simão ipot. Ixe Judas doze beayũ'in osunuy. Ixe Judas Jesus o'g̃ũm cekay itakomaayũ be g̃uyjom Jesus aoka am cebe ip. Ixe bit Maria o'g̃ukorẽm. ");
INSERT INTO myu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","— Apẽnpuye ig̃odi o'tideida g̃u dinheiro bu am? — io'e―Judas o'e jebureyũ be. — 300 dinheiro isurũg̃at kuka tidei o'e! — io'e. — Tidei kajuk ag̃ũm ibubut'ũmayũ be — io'e Judas Iscariotes. (Pũg̃ dinheiro isurũg̃at pũg̃ kabia be wuyekapikaptei osodop). ");
INSERT INTO myu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas Iscariotes doze beayũ edinheiro mũn kug̃ oeku. Imũn pewi i'uk'uk'uk osunuy jewebe ma. — Apẽnpuye dak o'tideida g̃u? — io'e dinheiro kay pin puye. Itabotaidabotbot g̃u osunuy ibubut'ũmat kay. ");
INSERT INTO myu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","— Ãg̃ cuy Maria jeenuy kaba'ũm — io'e Jesus Judas pe. — Ijudi o'timuxipan we'ũ awap ojebit mude'onaptim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","— Soat em eybubut'ĩn iũm put epesop ibubut'ũmayũ be — io'e. — Owebe bit ka'ũma. Darem ma eyxe og̃uy — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","G̃ebuje ade Judeuyũ o'ju Jesus kay. Jesus Betânia ka be omuy iap awẽg̃ o'yawẽg̃coco ip. Imẽnpuye ip o'ju Jesus com. O'ju ip Lázaro jom tak―Jesus o'g̃utait'iat com―waram o'jetait'iat com. ");
INSERT INTO myu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ade Judeuyũ oibu'un paĩyũ kukukayũ a'õ kay kũyjobit am. Jesus a'õ kay acã kũyjobit o'e ip Lázaro'ũm waram o'g̃utait puye. Imẽnpuye o'jewawẽ ip paĩyũ kukukayũ. — G̃a'a Lázaro ayaoka! — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","19","O'jojojo'ibiyũ Jesus e'eap o'g̃uwẽnuwẽn warara'acayũ be―Jerusalém ka beayũ be. — Icẽmãn Jesus Lázaro'ũm o'tomuwã witabikũy bewi — io'e'e ip adeayũ be. — Icẽmãn Jesus waram Lázaro'ũm o'g̃utait — io'e'e ip. — Jesus ma ja'õbacaap mõg̃mõg̃ — io'e'e ip. Jerusalém ka be õm pasug̃ pima Jesus jumento'it'it o'tobuxik. Deus ekawẽn tag̃ e ojuy―kuyjeatup ekawẽn tag̃. Xik. Oabik jumento'it'it akpi jeje. Imẽn e'em Deus ekawẽntup―kuyjeatup: Jerusalém ka watwat, eyg̃uycũg̃cũg̃ g̃u juy epesop, i. Eykukukat omuyku jexem eykay, i. Jumento'it'it akpi jeje omuyku jexem, i. Imẽn e'em Deus ekawẽntup. Imẽnpuye Jerusalém ka be Jesus oajẽm jumento'it'it akpi jeje Deus ekawẽn tag̃. G̃ebuje Jesus kay o'ju Jerusalém ka beayũ. Ade ma ip o'ju, Jesus omuyku iap awẽg̃ o'yawẽg̃tobuxik puye. Kuy ip oajẽm Páscoa epeta mug̃ẽ ãm. O'ju ip Jesus dopabijug̃, Jesus wuywebe i'e ba'oreat mubapukpug̃ iap awẽg̃ o'yawẽg̃tobuxik puye. Namusudup o'tupupu ip. Jesus kay o'ju ip tup kukug̃. Imẽn Judeuyũ ya'õbuyxiat tobedede'uk ip osodop kuyje. — Deus xipat cĩcã! — io'e ip Jesus pe. — Ẽn ma omuyku ya'õbi! — io'e ip. — Ẽn ma ocekukukat―Israel naxeg̃ebitbit kukukat! Deus cuy xipacat je'g̃ũm ewebe! — io'e ip Jesus pe. Jumento'it'it akpi jeje Jesus oajẽm Jerusalém ka be Deus ekawẽntup pe ibararak iap puxim―kuyjeatup puxim. Iboap iba'arẽm osunuy doze beayũ xe Jesus õm puje. Waram kabi be Jesus eu buje bit o'jeg̃ebu ip ig̃odup peap ekawẽn kay. — Ig̃odup peap ekawẽn puxim Jesus jumento'it'it akpi jeje oajẽm Jerusalém ka be — io'e ip jewewebe. — Ixe juk ocemuju jumento'it'it tobuxik — io'e ip jewewebe. Fariseuyũ bit o'e jewewebe: — Ak'i juy epe'e! — io'e ip. — Soat ma cekay itabut — io'e ip. — Te'e ma wuyju e'em adeayũ be “Ixe kay eyetabun g̃u juy epesop,” i — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","G̃ebuje Gregoyũ Jesus co pin o'e―Grécia eipi watwat. Adeayũ eju kuy oajẽm ip Jerusalém ka be peta mug̃ẽ ãm. ");
INSERT INTO myu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","O'ju ip Filipe eju kawẽn ãm. Ixe Filipe Betsaida ka bewiat osunuy. Galiléia eipi bewiat osunuy. O'ju ip Filipe be. — Tapu — io'e ip Filipe be. — Jesus co pin oceju — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe o'ju André mukũyjo am. — Gregoyũ Jesus co pin — io'e Filipe André be. Xepxem ip o'ju Jesus mukũyjo am. Oajẽm ip cekay. — Gregoyũ ejo pin — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","G̃ebuje Jesus o'jekawẽn xepxepayũ be. Adeayũ etabutpe o'jekawẽn ceweju ip. — Soat wag̃o õn — io'e Jesus. — G̃axĩn ma oje'ũ. G̃uyjom pit waram g̃uto ocetait. “Soat podi ma a'õbuyxi!” i je'e adeayũ we'ũap puye, waram g̃uto wetaicap puye dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","— Kadaida taida buje, ipi be atamõg̃ — io'e. — Tamõg̃ puje, tae'ũata jo'i tadop ipi be ma. Pũg̃ta ma tadop ipi be. Kadai aypan puje bit, ta'ade tadop kadai dag̃ — io'e. Imẽn Jesus o'jekawẽn je'ũãm, waram jetaicam tak, g̃uyjom ade tiwatwat itabut je'e okay iam tak. ");
INSERT INTO myu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","— “Ocebu'u jĩjã ipiat'ajom,” i wuyju e'em pima, “Ocebu'u jĩjã oce'ũ ãm,” i dak, “Imẽnpuye ocekupinap tag̃ acã oceju,” i dak, ace'ũ. “Ocebu'u g̃u ipiat'ajom,” i wuyju e'em pima bit, “Ocebu'u g̃u oce'ũ ãm,” i dak, “Deus bikuyap tag̃ acã oceku,” i dak, wuyag̃uyisum aceku ijodi. Soat em Deus xe acesop wuye'ũ buje dak — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","— Obikuyap tag̃ jeku ojuyat kũyjobin cuy wa'õ kay. Obikuyap tag̃ jekuku'ukat oxe ma jeenuy. Webay dak je'e cebe “Ẽn xipat oxe,” i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","— Wag̃uybabi'ũm cĩcã oce — Jesus o'e jewebe ma. — “Bay, obuywan ece we'ũap puxim,” i du oce webay be? — io'e jewebe ma. — Ka'ũma! Imẽn g̃u juy oce cebe. We'ũ ãm ma ojot ijodi — io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","— Bay — io'e Deus pe. — Edipap cuy eg̃ubapuk soat pe ijodiat pe “Deus idip cĩcã” i'e am ip — io'e jebay be. Deus o'jekawẽn kabi kadiwi g̃ebuje bit. — Odipap kuy og̃ubapuk cebe ip — io'e jekpot pe―Jesus pe. — G̃asũ adeayũ e'em owebe “Soat podi ma edip,” i. Waram tak og̃ubapuk warara'acayũ be “Soat podi ma edip” i'e am owebe — io'e Deus. ");
INSERT INTO myu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Adeayũ kacũg̃cũg̃'i osodop iboce. Tũybe o'jexirikxirik iãn o'e ip pũg̃pũg̃ ixeyũ'in. Tũybe Deus ekawẽn tojotjot'ukat o'jekawẽn cebe iãn o'e ip warara'acat ixeyũ'in. ");
INSERT INTO myu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","G̃ebuje Jesus o'jekawẽn ijoceat eju. — Ixe o'jekawẽn kabi kadiwi omukũyjo am g̃u―eymukũyjo am acã — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","— G̃axĩn ma Deus je'e soat pe okay itabut'ũmayũ be: “Eyju ikẽrẽat kug̃ oxe,” i. G̃axĩn ma itabut'ũmayũ kukukat a'õbacaap o'gu'ũm. Abu-kukukan je'e? Ka'ũma ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","— Okay itakomaayũ omuyu korosa eju oaoka am — io'e. — Omuyu buje adeayũ itabut je'e okay — io'e Jesus ijoceat pe. ");
INSERT INTO myu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus iboam o'e imutaybin am ip osubamupaya ip korosa eju we'ũ ãm iam. ");
INSERT INTO myu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","— Moisés ekawẽntup e'em: Cristo je'ũ g̃u―Deus emunaẽ, i. Soat em itabẽg̃ e'em, i. Imẽn Moisés ekawẽntup e'em — io'e ip ya'ĩjojo'ibiyũ. — Ẽn pit e'em “Soat wag̃o õn,” i, “Soat wag̃o subamuyu ip ce'ũ ãm,” i dak. Deus emunaẽ du soat wag̃o? — io'e ip Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","— Õn kabiaap puxim — io'e. — Ojot ijodiat mutaybin am Deus ekawẽn — io'e. — Darem ma ijodi og̃uy eymutaybinbin. Okay eyetabun cuy epesop eyetabun put pima. Eyetabun cuy epesop ipiatpi'ajojoap pe eyjuap puxim. Kabiok tag̃ jekuku'ukayũ itaybit g̃u poma oceju iam. Imẽnpuxim itabut'ũmayũ itaybit g̃u ipiatpi'ajojoap kay oceju iam — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","— Õn eyxe bima, eyetabun cuy epesop okay — io'e. — Eyetabun puje webekitkiyũm epesop. Kabia dag̃ jekuku'ukayũ buximayũm epesop. Ikẽrẽat mujurũg̃rũg̃'ug̃ g̃u epesop. Eyag̃uyisum epeku — io'e. Jesus o'jẽm adeayũ xewi iboam e buje. ");
INSERT INTO myu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Soat em ma Jesus wuywebe i'e ba'oreat mubapukpuk'uk osunuy adeayũ etabun. Inaka ibu'u jĩjã ip osodop jetabut am cekay. ");
INSERT INTO myu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Imẽn cuk adi o'tupmubararak Isaías'ũm kuyje―Deus ekawẽn muwẽnuwẽn'ukat'ũm: Kariwa, kawẽn icẽmat muwẽnuwẽn ocekukuku adeayũ be, i. Imẽnpit itabut g̃u ip o'e ocekawẽn kay, i. Soat podi ma a'õbaca ẽn iap iba'arẽm o'e cexe ip, i. Imẽn ibararak opop tup pe. Itabut g̃u ip o'e Jesus kay apẽn kuyjeayũ Isaías'ũm ekawẽn kay itabut'ũmap puxim. ");
INSERT INTO myu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Judeuyũ kukukayũ ibu'u o'e jetabut am Jesus kay, Isaías'ũm emudupmubararaktup e'eap puxim o'jebapuk cebe ip puye. ");
INSERT INTO myu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Imẽn Isaías'ũm ekawẽn: Deus iteyũ adeayũ o'yag̃uymubabi'ũm, i. Imẽnpuye itabut g̃u osodop ip, Deus a'õbacaap co ma'g̃u ip, i. Itabut g̃u osodop ip Deus ekawẽn co ma'g̃u ip, i. Ikẽrẽat mujurũg̃rũg̃ap o'jepere g̃u ip, i. Itabut g̃u osodop ip Deus kay ixe be ikẽrẽat uk am cebewi ip, i. Imẽn Isaías'ũm ekawẽn. ");
INSERT INTO myu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías'ũm iboam o'e kuyje Jesus soat podi ma idip iam itaybit puye. Imẽnpuye Jesus o'g̃uwẽnuwẽn. ");
INSERT INTO myu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ade Judeuyũ kukukayũ oitabun ip Jesus kay. “Jesus kay ocetabut,” i'ũmg̃u bit e'em oekuku ip Fariseuyũ buxim jeparara pibun. Jetabucap muwẽnuwẽn g̃u ip oekuku Fariseuyũ be ixeyũ mujẽmap puxim Deus eju kawẽnwẽnap'a bewi. ");
INSERT INTO myu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Deus mucokcok pin g̃u ip osodop―ijodiat mucokcok pin acã. Fariseuyũ mucokcok pin ip osodop. ");
INSERT INTO myu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","G̃ebuje Jesus o'jekawẽn adeayũ be. — Okay itabucayũ omudocat kay dak itabut ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","— “Deus ipot teku” i'e'e'ukat “Deus o'g̃udot ijodi,” i'e'em tak. ");
INSERT INTO myu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ijodi juk ojot Deus ekawẽn eymutaybin am. Okay itabucayũ ikẽrẽat mujurũg̃rũg̃ g̃u. Yag̃uyisum jeku ip — io'e. — Kabiok tag̃ jekuku'ukayũ buxim g̃u ip―kabia dag̃ jekuku'ukayũ buxim acã — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","— Wa'ĩjo buje, kũyjobit'ũm wa'õ kay bima, “Ikẽrẽat kug̃ eyju Deus xe” i'ũmg̃u õn pit e'em eywebe. Ijodi ojot “Ikẽrẽat kug̃ eyju Deus xe” i'e am g̃u adeayũ be. Adeayũ daxijo am acã ojot — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","— “Ikẽrẽat kug̃ eyju Deus xe,” i õn g̃u e'em okay'ũmayũ be, wa'õ kay'ũmayũ be dak. Warara'acat pit imẽn je'e ixeyũ be webay soat ce'ũ'ũayũ muyuap kabia be — io'e. — Deus acã “Ikẽrẽat kug̃ eyju oxe,” i je'e ixeyũ be. Imẽn Deus je'e cebe ip wekawẽn tag̃ g̃u ip puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","— Wa'õbi g̃u juk adi ojekukuku — io'e. — Owebe webay e'eap acã juk adi og̃uwẽnuwẽn eywebe. Wara'acat g̃u og̃uwẽnuwẽn eywebe. Iboap acã og̃uwẽnuwẽn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","— Deus ekawẽn tag̃ eyeku buje, eyag̃uyisum epeku ijodi. Deus xe epesop eye'ũ buje dak. Wetaybit iboam — io'e. — Owebe webay o'e'e iap acã õn e'em — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jesus jebekitkiyũ kay jĩjã osunuy soat kabia ipi dag̃ pima. Jesus itaybit o'e g̃axĩn ma oje'ũ iam, g̃axĩn ma oceu webay kay iam tak. Eykukpin cĩcã oxe iap o'g̃ubapuk cĩcã jebekitkit pe je'ũ awap. Páscoa epeta ajẽm pima, ");
INSERT INTO myu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus jekõnkõn o'e doze beayũ eju. Judas Iscariotes Jesus ũm ojuy o'e cekay itakomaayũ be. Ixe Judas Simão Iscariotes ipot osunuy. Ibiõg̃buk kẽrẽayũ kukukat a'õbi Jesus ũm ojuy yaoka am. ");
INSERT INTO myu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Soat em Jesus itaybit osunuy webay soat ja'õbacaap o'jomõg̃ owebe iam. Deus xewi ojot iam tak itaybit osunuy. G̃axĩn ma ocepit Deus kay iam tak itaybit osunuy. ");
INSERT INTO myu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Je'ũap muwẽnuwẽn pima, kirik'ãy, o'ãy. Jesus o'ãy mesa xewi. Jeekabek o'ju'uk. Kuruk. Toaya o'jat. Mũn. O'jomũn jekpu dag̃. ");
INSERT INTO myu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jeweju etaybitbinayũ i wuy am o'ju. Wa'e co'iat'a be idibi o'timõg̃. O'suiwuy koapat i. O'suisup toayam. Pereh. Wara'acat o'suiwuy. O'suisup. Pereh. ");
INSERT INTO myu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Oajẽm Simão Pedro kay. Simão ibu'u o'e Jesus pe jeiwuy an. — Kariwa — io'e Simão. — Ẽn tu wuiwuy? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","— Hm hm. Etaybit g̃u buk apẽnpuye paxi ite wuiwuywuy iam — io'e Jesus Simão be. — G̃uyjom pit etaybit ece'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","— Ap! Wuiwuy g̃u juy ece―pũg̃ em tak ka'ũma! — io'e Simão bit. — Eiwuy'ũm pima, obuerm g̃u eg̃uy — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","— Kariwa — io'e. — Wuiat g̃u esuiwuy — io'e. — Wa'a dak eyawuy — io'e. — Oba dak — io'e Simão Pedro Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","— Oajok'iat iokok g̃u―iisu ma! — io'e. — Dao g̃u jajok waram. Jeiwuy acã — io'e. — Wuyjuyũ bewi Deus pe ikẽrẽat'uk puje, iisuat puxim ip. Deus kuy ikẽrẽat o'ju'uk eywebewi. Pũg̃ pewi bit ka'ũma. Ite ikẽrẽat kug̃ mabuk jewebe. Ixe iokokat puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus kuy itaybit o'e abu oũm ixeyũ'in okay itakomaayũ be iam. Imẽnpuye: — Pũg̃ pit ey'in ikẽrẽat kug̃ mabuk jewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ixeyũ i wuy buje, Jesus jeekabek o'g̃uõm waram. O'jepit ip mesa kay. Oabik ma'g̃uto jeweju etaybitbinayũ eju. — Eyetaybit g̃u du apẽnpuye õn eyeiwuywuy iam? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","— “Ẽn ocekukukat,” i eyju e'em owebe, “Ẽn ocemutaybitbin'ukat,” i dak. Cũg̃ ma eywebe iboam e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","— Õn eykukukat. Eymutaybitbin'ukat tak õn — Jesus o'e. — Inaka eyeiwuywuy oce warara'acat puywatwat'ukat co'i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","— Õn eyeiwuywuy, eykukukat ma'g̃u õn. Eyju dak obuxim eybu'um g̃u juy epesop warara'acat puywatwat am. ");
INSERT INTO myu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eykukukat warara'acat puywatwan pima, eyju dak eybu'um g̃u juy epesop warara'acat puywatwat am. Eymujuat warara'acat puywatwan pima, eyju dak eybu'um g̃u juy epesop warara'acat puywatwat am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","— Õn eykukukat. Inaka juk eyeiwuywuy oce. Jewebuywatwan cuy epesop obuxim. Jewebuywatwan pima, eycokcog̃ epesop. ");
INSERT INTO myu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Soat pe g̃u eywebe iboap muwẽnuwẽn õn. Wetaybit cĩcã wemunaẽyũ ekukuam. Pũg̃ ey'in oũm okay itakomaayũ be waoka am. Imẽn e'em Deus ekawẽntup: Obiwag̃odada'ukat ma ikẽrẽm cĩcã okuk, i. Imẽn ibararak opop Deus ekawẽntup pe. G̃axĩn ma je'bapuk owebe ig̃odup ekawẽn puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","— Iboap muwẽnuwẽn õn eywebe waoka awap — io'e. — Imẽg̃ap ebapuk puje ibodi ma eyetabun epesop soat em wa'õ dag̃ õn e'em iap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","— Icẽmãn õn e'em eywebe — io'e. — Wemumujuyũ kay itabucat okay dak itabut. Okay itabucat omudocat kay dak itabut — io'e Jesus doze beayũ be. ");
INSERT INTO myu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iboam buje, Jesus ig̃uycũg̃ cĩcã o'e. — Icẽmãn õn e'em eywebe — io'e jeweju etaybitbinayũ be. — Ey'inat oũm okay itakomaayũ be — io'e ibapug̃ ma. ");
INSERT INTO myu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","O'jeakakak ip jewewekay. — Abu paxi kuka o'g̃ũm cekay itakomaayũ be? — i'e'em ip jewewebe ma. ");
INSERT INTO myu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Doze beayũ'inat xik'i osunuy Jesus tẽg̃ ma―Jesus emumukukpinput. ");
INSERT INTO myu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simão Pedro jebum o'jewẽg̃wẽg̃ Jesus tẽg̃at pe. — “Abu eũm ekay itakomaayũ be?” i juy ece cebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jesus tẽg̃at wurũg̃'i o'ju Jesus kay iboap muwẽn ãm cebe. — Kariwa, abu sute? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","— Minka'o be pão'a oyamuakõm — io'e Jesus. — Pũg̃ pe oyaũm. Ixe ma oũm okay itakomaayũ be — io'e. Kuruko. O'yabu. O'yamuakõm. Wũntok. Yadirem pima, o'yaũm Judas pe―Simão Iscariotes ipot pe. ");
INSERT INTO myu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pão'a bu buje, Judas Jesus kay oibu'un. Satanás a'õkayan o'e. — Dao ma juy ece e'e pinap tag̃ — Jesus o'e Judas pe. ");
INSERT INTO myu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","29","Tũybe Judas o'ju Jesus a'õbi wuyxat pum peta be wuyemumu'om iãn o'e ip pũg̃pũg̃ mesa watwatyũ'in. Tũybe Judas o'ju wuyedinheiro'in iũm ãm ibubut'ũmayũ be iãn o'e ip warara'acayũ ixeyũ'in. Jesus ekawẽn pa'arẽm o'e mesa watwat pe. ");
INSERT INTO myu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pão'a o'yabu Judas. Kurukoh. O'jẽm g̃ebuje bit. Warara'acat xewi o'jẽm. Xerewun. Cũh. Kabiok tag̃ o'jẽm. ");
INSERT INTO myu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cẽm puje, Jesus o'jekawẽn onze beayũ eju. — Soat wag̃o õn — io'e. — G̃axĩn ma oje'ũ. Odipap g̃asũ webay g̃ubapuk. Soat je'e “Jesus idip cĩcã,” i. “Deus idip cĩcã,” i we'ũap puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","— Owebe “Deus idip cĩcã” i'e buje, Deus tak e'em “Okpot idip cĩcã,” i. G̃axĩn ma imẽn je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","— Bekitkit — io'e. — Ibun g̃u og̃uy eyxe. Okudadam epeku. “Ojuap kay eyju ba'ore epesop,” i kuy oce Judeuyũ kukukayũ be — io'e. — Imẽn eywebe dak õn e'em — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","— Wara'an ma õn jeymutaybin g̃asũ bit — io'e Jesus. — Eykukpin cĩcã juk adi epesop oxe. Imẽnpuxim cuy eyju dak eykukpin ma epeyewekuk — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","— Eykukpin jewewekug̃ pima, “Teyũku Jesus ebekitkiyũ,” i je'e soat ijodiayũ — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","— Kariwa — io'e Simão Pedro. — Poma ẽn cum? — io'e. — G̃asũ eyju ba'ore ojuap kay — io'e Jesus. — G̃uyjom pit epesot okay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","— Kariwa — io'e ma'g̃uto Simão. — Apẽnpuye oju ba'ore ejuap kay g̃asũ? Ekay jĩjã õn. Obu'u g̃u we'ũ ãm owebe epereap puxim. Warara'acayũ “Jesus eju ejeku bima, jaokam oce'e,” i'e'em pima dak, jeiwat g̃u õn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","— Ebu'u g̃u du e'ũ ãm ewebe opereap puxim? — io'e Jesus. — Icẽmãn õn e'em ewebe. Ebapũg̃ em “Jesus ejuat g̃u õn pit,” i napa ma ece'e. Sapokay ede awap imẽn ece'e — io'e. — G̃axĩn ma napa ma imẽn ece'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","— Eyag̃uykorereren g̃u juy epesop — Jesus o'e onze beayũ be. — Eyg̃uycũg̃cũg̃ g̃u juy epesop — io'e. — Kuy eyetabut Deus kay. Okay dak cuy eyetabun epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","— Ya'ade opop webay ka be uk'a―ijodiacat dopdop'am — io'e. — Cum õn eydopdopap'a muxipan am. Icẽmãn õn e'em eywebe. Icẽm'ũm pima, iboam kajuk oce g̃u eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","— Cum õn. Eydopdopap'a oyamuxipan eyajẽmjẽmap'am — io'e. — Eydakoy ocepit eydopdopap'a muxipan puje — io'e. — Onuyapka kay õn jeydujuxe. Onuyapka be epesop soat em — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","— Eyetaybit poma õn cum iam — io'e Jesus. — Eyetaybit tak apẽn iboce epeju iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","— Kariwa — io'e Tomé. — Poma eju? Ocetaybit g̃u. Apẽn tak ocetaybit oce'e enuyap ka kay oceju am? — io'e Tomé. ");
INSERT INTO myu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","— Okay itabucat mujujum õn webay nuyap ka be — io'e. — Okay itabucat mutaybitbin õn kawẽn icẽmãn―Deus ekawẽn. Okay itabucat yag̃uyisum jekukum wa'õbi — io'e. — Abuyũ je'ju webay kay? Okay itabucayũ acã! Õn ma okay itabucat og̃uju webay kay―warara'acat pit ka'ũma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","— Eyetaybit abu õn iam pima, eyetaybit kuka juk epesop abu webay iam — io'e. — G̃asũ bit kuy eyetaybit webay e'eam, apẽn cuk adi ocece iap epejojojo buye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","— Kariwa — io'e Filipe. — Ebay juy eg̃ubapuk ocewebe. Wuyebay juy ejojoat ocewebe. O'e kuka ocewebe ixe jo am — io'e Filipe. ");
INSERT INTO myu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","— Pũg̃ xet g̃u og̃uy eyxe — io'e Jesus. — Eyetaybit g̃u buk tu abu õn iam, Filipe? — io'e. — Abu õn iam itaybicat itaybit abu webay iam tak — io'e. — Apẽnpuye ẽn pit e'em “Ebay juy ejojoat ocewebe,” i? — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","— Pũg̃ tag̃ ma oceju jekukum―õn, webay dak — io'e. — Filipe, eyetabut g̃u du iboap kay? — io'e Jesus. — Wekawẽn muwẽnuwẽn'uk g̃u og̃uy eywebe―webay ekawẽn muwẽnuwẽn acã — io'e. — Pũg̃ tag̃ ma kawẽnwẽn oceju―õn, webay dak. Wa'õbi g̃u õn jekukum―webay a'õbi acã — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","— “Pũg̃ tag̃ ma oceju jekukum―õn, webay dak,” i õn e'em eywebe. Eyetabun cuy epesop wekawẽn kay. Wekawẽn kay eyetabut'ũm pima, eyetabun cuy epesop okay wa'õbacaap coco am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","— Icẽmãn õn e'em eywebe. Okay itabucayũ wekukuap puxim jeku. Owebe Ja'õbacaap mõg̃mõg̃ap podi ma wa'õbacaap jomõg̃ ip, webay kay oju buje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","— Eyju e'em owebe “Ebikuyap tag̃ cuy ece owebe,” i bima, eyemuojuyjuy og̃ũm eywebe―soat og̃ũm eywebe — io'e. — Imẽnpuye “Ka'ũmg̃u Deus co'iat xipacat,” i je'e soat ijodiacat. ");
INSERT INTO myu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Eyju e'em owebe “Ebikuyap tag̃ cuy ece owebe,” i bima, soat eyemuojuyjuy og̃ũm eywebe — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","— Eyxe okukpin pima, kũyjobin cuy epesop wa'õ kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","— Õn kawẽnwẽn webay eju. “Ibuywatwat'ukan cuy eg̃uju okay itabucayũ kay,” i oce webay be — io'e. — Ixe jebiõg̃buk g̃udot eykay eybuywatwat'ukan. Soat em ixe jeenuy eyxe. Icẽmãn eymutaybitbin jeenuy. ");
INSERT INTO myu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Itabut'ũmayũ be iba'ore ixe ekawẽn kay kũyjobit am. Ixe e'eap iba'arẽm cexe ip. Itaybit g̃u ip ixe e'eam. Eywebe bit ixe nuynuy. Imẽnpuye eyxe ixe e'eap ibapuk — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","— Jeypere g̃u õn. Ocepit eykay — io'e. — Eyag̃uyag̃epũg̃ g̃u epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","— G̃axĩn ma Deus kay'ũmayũ ojo g̃u. Eyju bit waram ojo. Eyag̃uyisum epeku, waram g̃uto wetait puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","— Pũg̃ tag̃ ma õn jekukum webay eju. Eyju dak pũg̃ tag̃ ma jekukum oceweju. Oceju dak pũg̃ tag̃ ma jekukum eyweju. Eykay eybuywatwat'ukat ajẽm puje, iboap iba'arẽm g̃u je'e eyxe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","— Wa'õ kay jĩjãayũ xe okukpin―wa'õ kay kũyjobicayũ xe. Webay xe dak ixeyũ ikukpin je'e. Oxe dak ikukpin cĩcã oce'e. Abu õn iam ixeyũ og̃utaybin. Itaybit cĩcã je'e ip abu õn iam — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","— Kariwa — io'e Judas — Apẽn tak ẽn iboam ocetaybin itabut'ũmayũ mutaybin'ũm pima? — io'e. (Iscariotes g̃u osunuy ixe Judas―wara'at Judas acã). ");
INSERT INTO myu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","— Wa'õ kay jeedop ip kũyjobin okayayũ — io'e. — Webay xe ixeyũ ikukpin je'e. Ojot ixeyũ kay webay eju. Soat em ixeyũ xe ocesop―õn, webay dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","— Okay'ũmayũ bit kũyjobit g̃u wa'õ kay. Wa'õbi g̃u õn iboap muwẽnuwẽn eywebe―webay a'õbi acã. Ixe juk omudot ijodi — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","— Iboap muwẽnuwẽn õn eywebe eyxe bima. ");
INSERT INTO myu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Webay jebiõg̃buk g̃udot eykay. Obikuyap tag̃ g̃udot. Ixe eybuywatwat'ukat. Ixe xipat cĩcãat. Soan ma eymutaybin jeenuy. Ade ma õn cuk adi eymutaybinbin og̃uy. Ixe eybuywatwan jeenuy wekawẽn kay eyag̃uyba'ũmap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","— Itabut'ũmayũ be eyag̃uymukorerenapmu'ũm pa'ore. Õn pit wag̃uykorereren g̃u. Imẽnpuye eyag̃uykorerenap og̃u'ũm. Eyag̃uykorereren g̃u juy epesop ojuap kay. Eyg̃uycũg̃cũg̃ g̃u juy epesop — io'e. — Eypararam g̃u juy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Cum õn,” i juk oce eywebe — io'e. — “Waram tak eykay ocepit,” i juk oce. Iboap kuy epeya'ĩjojo. Webay kay õn cum. Wa'õbuyxi. Webay bit obodi ma ya'õbuyxi. Imẽnpuye eycokcog̃ cuy epesop cekay ojuap kay. Eyxe okukpin pima, eycokcog̃ kuka epesop ojuap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","— Oju awap iboap muwẽnuwẽn õn eywebe. “Icẽmãn adi xeku o'e ocewebe,” i epe'e oju buje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","— G̃axĩn ma Deus kay'ũmayũ kukukat omuyku — io'e. — Imẽneju buk eyweju õn kawẽnwẽn darem. Ixe wa'õbacaap mu'ũm pin. Imẽnpit itaybit g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","— G̃a'a aju. Apẽn webay o'e owebe iap tag̃ õn jekukum, oxe ikukpin cĩcã buye. Itabut'ũmayũ og̃utaybin webay a'õ dag̃ õn jekukum iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","— Õn uvabune buxim — io'e Jesus. — Webay uvadip puxim. ");
INSERT INTO myu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Okay itabucayũ ibune'ĩcat puxim. Webay bikuyap tag̃ jekum ibu'u'uayũ ya'ũmatpune buxim. Ya'a'e'ũm pima ibune'ĩcat uk'ug̃ tip kukat. Imẽnpuxim webay jebikuyap tag̃ jekum ibu'u'uayũ mujẽmjẽm itabucayũ xewi. Kadaidip iokokatpune xikxig̃ ya'ade i'e am. Imẽnpuxim webay itabucayũ mukũyjojom ixeyũ be ikẽrẽat mujurũg̃ap puxim. Ixeyũ mukũyjojom big̃ ma jebikuyap tag̃ jeku am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","— Webay kuy ikẽrẽat o'ju'uk eybewi, wekawẽn kay kũyjobit puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","— Mũg̃'i juy epeku oweju — io'e. — Oweju jekukum pima, õn tak eyweju mũg̃'i ojeku. Ibune'ĩcatpune uvabune be'ũm pima, kuka o'yajẽm g̃u uva'a. Imẽnpuxim mũg̃'i oweju eyeku'ũm pima, webay bikuyap tag̃ g̃u epeku — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","— Uvabune buxim õn — i waram o'e Jesus. — Eyju ibune'ĩcatpune buxim. Obikuyap tag̃ jekukum pima, xipan ma epeku Deus xe. Mũg̃'i eyweju õn tak jekukum. Obikuyap tag̃ jekukum'ũm pima bit, ajo eye'e'eap xipat je'e Deus xe? Ka'ũma ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","— Mũg̃'i oweju jekum eybu'u bima, apẽn uvadip iwat ya'ũmatpune kukap puxim Deus tak jeykuk―ya'ũmatpune xikap puxim. Wũn. Ibune xik puje ibunekaraw e'em. Ibune e'ũatpune mu'awerorom uvadip kukat. Aweroh. Ibunemupikupig̃ daxa be. Wũn. Pik. Hog̃. ");
INSERT INTO myu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mũg̃'i juy epeku oweju! Wa'õ dak juy kũyjobin epesop! Oweju eyeku buje, Deus soat epejoojuyiat je'g̃ũm eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","— Deus bikuyap tag̃ eyju jekukum pima, soat ijodiat je'e webay be: “Ka'ũmg̃u ejo'iat xipacat,” i — io'e. — Itaybit je'e ip eyju webekitkiyũ iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","— Eyju eykukpin cĩcã oxe webay xe okukpinap co'i. Eycokcog̃ cuy epesop Jesus xe ocekukpin iap kay g̃ebum. ");
INSERT INTO myu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Webay a'õ kay õn kũyjobit. Imẽnpuye ocokcok soat em webay xe okukpin iap kay g̃ebum. Imẽnpuxim wa'õ kay kũyjobit pima, eycokcog̃ epesop Jesus xe ocekukpin iap kay g̃ebum — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","— Iboap og̃uwẽn eywebe eymucokcok am. Wa'õcokcok cĩcã. Obu'u eywebe eycokcoksũ ãm. Obikuy eywebe eycokcok cĩcã ãm wa'õcokcokap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","— “Oxe xipan eykukap puxim cuy xipan epeyewekuk,” i õn e'em eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","— Wuybureyũ e'ũap puxim wuye'ũ ãm wuybu'u'ũm pima, soat ijodiat je'e “Ak'i juy epe'e! Teyũxeku ibureyũ ikukpin cĩcã,” i. “Warara'acat podi ma ikukpin cexe ip,” i je'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","— Wa'õ kay kũyjobit pima, obureyũm epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","— “Eyju oweju kapikpik'ukayũ ã,” i'ũmg̃u õn e'em g̃asũ eywebe. Kapikpik'ukat itaybit g̃u jekariwa e'eam. Webay owebe ie'eap pit og̃uwẽn eywebe soat. Iboap og̃uwẽn eywebe eyju obureyũ buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","— Eyju ma onaẽ g̃u eykukan. Õn pit eynaẽ obureyũm. Õn cuk eymuju omuwẽn ãm warara'acayũ be imutabun am ip okay. Okay jetabucap jepere g̃u ip. Ibu'u g̃u ip je'e itabut am okay. Obikuyap tag̃ webay eju kawẽnwẽn pima, soat epejoojuyiat je'g̃ũm eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","— Imẽnpuye “Xipan cuy epeyewekuk,” i õn e'em eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","— Deus kay'ũmayũ itakoma eykay. Koap pit okay itakoma ip osodop. Iboap kay g̃ebum cuy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","— Eyju Deus kay'ũmayũ kadi bima, eykay kuka ip o'e. “Teyũdaku wuykadiacat,” i kuka ip o'e. Imẽnpit õn eymuwe'uk Deus kay'ũmayũ xewi. Deus kay'ũmayũ kadi g̃u eyju. Imẽnpuye itakoma jĩjã ip eykay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","— Kuy juk ocece eywebe iap kay g̃ebum cuy epesop. “Ikẽrẽm cĩcã ip wuyekariwa o'jukuk. Wuyju bit ikẽrẽm g̃u wuykuk ip,” i'ũmg̃u juy epe'e eyewewebe. Deus kay'ũmayũ ipiat o'supi'ajojoat owebe. Imẽnpuye eywebe dak ip jopi'ajoat. Yopĩt ma wa'õ kay ip osodop. Imẽnpuye dak eya'õ kay je'e ip yopĩt ma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","— Eywebe ipiat supi'ajoat ip, eyju webekitkit puye. Eywebe ipiat supi'ajoat ip, omudocat kay itabut'ũm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","— Ijodi oajẽm. Deus ekawẽn cuk adi og̃uwẽnuwẽn ixeyũ be. Wekawẽn kay g̃u bit ip o'e. Odot'ũm pima, “Ikẽrẽat kug̃ eyju oxe, wekawẽn kay'ũm puye ya'ĩjojom ma'g̃u,” i'ũmg̃u kajuk o'e Deus ixeyũ be. G̃asũ bit “Ikẽrẽat kug̃ g̃u oceju” i'e ba'ore cebe ip Deus pe. ");
INSERT INTO myu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Okay itakomaat webay kay dak itakoma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","— Wa'õbacaap mõg̃mõg̃ cuk adi ojekuku soat etabutpe. Soat a'õbacaap podi ma wa'õbacaap mõg̃mõg̃ ojekuku. Okay g̃u bit ip o'e. Imõg̃mõg̃'ũm pima, “Ikẽrẽat kug̃ eyju oxe, okay eyetabut'ũm puye, wa'õbacaap mõg̃ap cocom ma'g̃u eyju,” i'ũmg̃u kajuk o'e Deus ixeyũ be. G̃asũ bit ikẽrẽat kug̃ ip cexe. Inaka itakoma jĩjã ip okay, webay kay dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","— Ixeyũ muwẽnuwẽn Deus jekawẽntup pe―kuyatup pe: Ikẽrẽm'ũm a'g̃u ip ojukuk, i. Inaka ip oitakomãn okay, i. Itakoma ip okay ig̃odup ekawẽn puxim — Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","— “Ebiõg̃buk cuy eg̃uju okay itabucayũ kay,” i oce'e cebe―webay be — io'e Jesus. — Ixe g̃udot eybuywatwat'ukan. Ixe icẽmãn e'e'ukat. Ixe ma omuwẽn eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","— Eyju dak cuy epesop omuwẽnuwẽn ijodiayũ be. Õn ijodiat mutaybitbin pima, oweju juk adi epekuku. Imẽnpuye juy epesop omuwẽnuwẽn g̃asũ bit — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","— Imẽn õn e'em eywebe okay eyetabucap epereap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","— Eykay itakomaayũ jeymuõmat g̃u Deus eju kawẽnwẽnap'a be. Jeyaoka ip. Eyaoka buje, tũybe Deus bikuyap tag̃ wuyju jekukum iãn je'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","— Ikẽrẽm jeykuk ip abu õn iam itaybit'ũm puye, abu webay iam tak. ");
INSERT INTO myu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","G̃asũ iboap muwẽnuwẽn õn g̃uyjom eyeg̃ebu am apẽn õn eymukũyjojo iap kay — io'e. — Warẽmtag̃ eykuk puje, “Imẽn kuka ip wuykuk,” i juy epe'e eyewewebe — io'e Jesus jeweju etaybitbinayũ be. — Kuy bima a'g̃u eyxe ma og̃uy — io'e. — Imẽnpuye juk iboam g̃u õn eymukũyjo. ");
INSERT INTO myu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","G̃asũ bit ocepit omudocat kay. Ka'ũma ma ey'in pit e'em owebe “Poma ẽn cum?” i. ");
INSERT INTO myu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eyg̃uycũg̃cũg̃ cĩcã imẽn õn e'em puye. ");
INSERT INTO myu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wepit'ũm pima, xipat g̃u kuka o'e eywebe. Wepit pima bit, xipat je'e eywebe. Wepit'ũm pima kuka eybuywatwat'ukat osodot g̃u. Oju buje bit ixe og̃udot eykay. Imẽnpuye eycokcog̃ cuy epesop ojuap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","— Ixe dot puje, “Soat eyju ikẽrẽat kug̃ Deus xe,” i je'e soat pe ipi dag̃ayũ be. “Deus acã itaybit eymucũg̃ ãm,” i dak je'e. “Ipiat supi'ajoat Deus ikẽrẽat mujurũg̃rũg̃'ukayũ be,” i dak je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","— “Soat eyju ikẽrẽat kug̃ Deus xe,” i je'e, okay itabut'ũm ip puye — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","— Eyju ojo g̃u waram, Deus jewekay odujuu buye — io'e. — Imẽnpuye “Deus acã itaybit eymucũg̃ ãm,” i je'e Deus biõg̃buk — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","— Deus kuy o'e “Deus kay'ũmayũ kukukat soat em jeenuy ipiatpi'ajojoap pe―Satanás,” i. Imẽnpuye “Ipiat supi'ajoat ikẽrẽat mujurũg̃rũg̃'ukayũ be Deus,” i je'e Deus biõg̃buk — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","— Ade mabuk õn imuwẽn pin eywebe. G̃asũ bit iba'ore eywebe eyetaybin am wekawẽn, eyg̃uycũg̃cũg̃ cĩcã buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","— Ibiõg̃buk xipacat icẽmãn e'e'ukat. Ixe ajẽm puje soan kawẽn icẽmãn eymutaybin jeenuy. Ja'õbi g̃u ixe g̃uwẽn. Kuy o'ya'ĩjojoiap acã g̃uwẽn. G̃uyjom acejebapukiap tak g̃uwẽn eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","— Ixe obuyxim okuk. Itaybit wekawẽn je'e. Icẽmãn soat wekawẽn g̃uwẽn eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","— Webay e'eap tag̃ õn tak e'em. Imẽnpuye cuk adi ocece eywebe “Deus biõg̃buk wekawẽn g̃uwẽn eywebe,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","— G̃axĩn ma eyju ojo g̃u. G̃uyjom pitapit waram eyju ojo — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","— Apẽn ite e'em wuywebe? — io'e ip jewewebe jeweju etaybitbinayũ. — Ite e'em “G̃axĩn ma eyju ojo g̃u,” i. “G̃uyjom pitapit eyju waram ojo,” i — io'e ip. — “Imẽn je'bapuk webay kay oju buye,” i teku e'em wuywebe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","— Apẽnpuye ite e'em “G̃uyjom pitapit waram eyju ojo,” i? — io'e ip. — Cekawẽn pa'arẽm cĩcã wuyxe — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus itaybit o'e teyũku “Apẽn tak ẽn e'em ocewebe?” i'e ojuy owebe iam. Imẽnpuye waram o'jekawẽn ceweju ip. — “Apẽn ẽn ocemutaybin pin?” i du eyju e pin owebe? — io'e Jesus. — “G̃axĩn ma eyju ojo g̃u,” i juk oce eywebe — io'e. — “G̃uyjom pitapit waram eyju ojo,” i dak cuk oce — io'e. — Wekawẽn pa'arẽm tu eyxe? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","— Icẽmãn õn e'em eywebe. Wawa jĩjã juy epesop we'ũ buje — io'e. — Itabut'ũmayũ bit wa g̃u je'e. Darem ma eyg̃uycũg̃cũg̃ epesop. G̃uyjom pit eyg̃uycũg̃cũg̃ g̃u epesop―eycokcok ã — io'e. — Eyg̃uycũg̃ap i'ũm — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","— I'it kam pima, ayacat ig̃uycũg̃ e'em je'it pibun. Je'it kap puje bit, ipiat kay g̃ebum g̃u e'em. Icokcok e'em je'it kug̃ puye. ");
INSERT INTO myu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Imẽnpuxim eyju dak. G̃asũ eyg̃uycũg̃cũg̃ oju buye. G̃uyjom pit waram eyjojom oce. Eycokcok cĩcã ma epe'e g̃ebuje bit. Abu-be eycokcokap mu'ũm put ixe kabia be? Ka'ũma be ma! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","— Eybuywatwat'ukat ajẽm puje bit, ixe ma jeymutaybin — io'e. — Imẽnpuye “Ocemutaybin cuy ece,” i'ũmg̃u epe'e owebe ma — io'e. — “Ekawẽn pa'arẽm ocexe,” i'ũmg̃u dak epe'e owebe — io'e Jesus. — Icẽmãn õn e'em eywebe. Obikuyap tag̃ cexewi iojuyjuy bima, webay soat eyemuojuyjuy je'g̃ũm eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","— Obikuyap tag̃ epejoojuy g̃u buk. Pũg̃ em tak ka'ũma — io'e. — G̃asũ bit cuy epejoojuy cexewi! — io'e. — Eyemuojuyjuy epejat. Ibu buje, eycokcoksũ g̃u epesop―eycokcok cĩcã ma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","— Koap puk cuk adi ibapug̃ g̃u ocekawẽn eywebe — io'e. — Ijodiat mutaybitbinap ekawẽn acã og̃uwẽnuwẽn eywebe. G̃uyjom pit ibapug̃ ma webay ekawẽn og̃uwẽn eywebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","— Ibapug̃ owebe imuwẽn puje, obikuyap tag̃ cuy epejoojuy webay xewi. Õn acã g̃u webay xewi ojojuy eywebeam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","— Eyju dak cuy epejoojuy. Webay eyekawẽn ya'ĩjo, ixe xe eykukpin cĩcã buye. Webay xe eykukpin cĩcã, eyxe okukpin puye; “Icẽmãn Jesus osodot Deus xewi,” i eyju e'em puye dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","— Icẽmãn webay xewi juk ojot. Ipi kay juk ojot―ijodi. Oje'ũ. Ipi dag̃wi ojẽm g̃asũ. Webay kay juy ocepit — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","— G̃asũ bit ẽn iba'arẽm g̃u kawẽnwẽn ocewebe — io'e onze beayũ Jesus pe. — Ibapug̃ ma ẽn kawẽnwẽn g̃asũ bit — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","— Etaybit soan ma. Etaybit apẽn oceju jewag̃uyg̃uy iam. Ẽn ocemukũyjojom, “Apẽn ẽn e'em ocewebe,” i'ũmg̃u ma'g̃u oceju e'em — io'e ip. — Imẽnpuye “Deus xewi teku osodot,” i oceju e'em g̃asũ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","— Eyetabut tu epe'e okay? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","— G̃axĩn ma bit epewatwatwat eydukã dag̃. Opere eyju eyaokaap puxim. Wag̃epũg̃ ma og̃uy opere buje. Imẽnpit odadaybot g̃u og̃uy, webay soat em oxe buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","— Itabut'ũmayũ ma ipiat supi'ajoat eywebe. Õn pit kuy Deus kay'ũmayũ kukat a'õbacaap og̃u'ũm. Imẽnpuye eya'õcam cuy epesop! Imẽn õn e'em eywebe eypararaap puxim. Eyag̃uykorereren g̃u, mũg̃'i oweju buye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iboam e buje, Jesus o'je'apũn kabi beat kay―jebay kay. O'jekawẽn jebay eju. — Bay — io'e. — G̃axĩn ma oje'ũ. Õn ma ekpot. Odipap cuy eg̃ubapuk adeayũ be. Õn tak edipap cuy og̃ubapuk cebe ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","— Pũg̃pũg̃pũg̃ayũ juk eg̃utabun okay ipi dag̃ayũ'in. A'õbacaap cuk eg̃ũm owebe. Imẽnpuye okay itabucayũ yag̃uyisum jekukum wa'õbi — io'e jebay be. ");
INSERT INTO myu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","— Ẽn acã Deusat. Ka'ũmg̃u wara'at. Õn ma emumudot―Jesus Cristo. Ijodiat yag̃uyisum jeku okay itabun puje, ekay itabun puje dak — io'e. — Soat em exe ma jeedop ip ce'ũ buje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","— Wekapikap cuk adi eg̃ũm owebe. Ipi dag̃ pima abu ẽn iap cuk adi og̃uwẽnuwẽn edipap mubapukpug̃. G̃asũ wekapikap og̃u'ũm — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","— Bay — io'e Jesus. — Exe bima soat kabi beacat odipap mubapukpuk'uk ip osodop―ekawẽn tojotjot'ukayũ. Ipi mujurũg̃ awap odipap mubapukpuk'uk ip osodop. Waram cuy odipap mubapukpug̃ ip jeenuy, exe wajẽm puje — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jesus jekay itabucayũ o'g̃uwẽn jebay be g̃ebuje bit. — Pũg̃pũg̃ayũ juk eg̃utabun okay ipi dag̃ayũ'in — io'e. — Ebekitkiyũm osodop ip. Ixeyũ eg̃utabun okay. Ixeyũ itabucayũ be emuwẽnuwẽn ojekuku. Kũyjobit o'e ip a'õ kay — io'e Jesus jebay be. ");
INSERT INTO myu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","— Itaybit ip g̃asũ a'õbi acã õn emuwẽnuwẽn iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","— Apẽn cuk adi ecece iap ma og̃uwẽnuwẽn soat pe okay itabucayũ be. Wa'õ kay ip osodop. Itaybit o'e ip icẽmãn Deus xewi Jesus osodot iam. Itabut o'e ip Deus ma Jesus o'g̃udot iap kay — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","— Bay, ixeyũ beam ma õn kawẽnwẽn eweju―onze beayũ beam — io'e. — Itabut'ũmayũ beam g̃u õn kawẽnwẽn―okay emumutabunyũ beam acã — io'e. — Ebekitkiyũ ixeyũ. ");
INSERT INTO myu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Soat okay itabucayũ ebekitkiyũ. Imẽnpuye webekitkiyũ dak ip. Adeayũ odipap cocom webekitkiyũ cũg̃ ma jekukum puye — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","— Bay, soat podi ma a'õbaca. A'õbacaap cuk adi eg̃ũm owebe. A'õbacaap co'i wa'õbaca. G̃axĩn ma oajẽm ma'g̃uto ekay. Õn ma ipi dag̃ g̃u ojeku. Okay itabucayũ bit ipi dag̃ ip jeku. — Bay — io'e. — Pũg̃ em ikẽrẽat ejukuk g̃u. Imẽnpuxim ag̃ cuy eg̃uy ixeyũ kay cũg̃ ma ip ceku am wekuap co'i, ekuap co'i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","— A'õbacaap cuk adi eg̃ũm owebe. Õn ixeyũ xe bima, a'õbi ma juk adi ag̃ og̃uy cekay ip itabucap epereap puxim. Ka'ũma ma ixeyũ'in oibu'un okay. Pũg̃ acã oibu'un―jetabucap epereperemxi acã. Apẽn ixe jetabucap o'jepere iap ibararak opop Deus ekawẽntup pe. Ig̃odup ekawẽn tag̃ jetabucap jepere g̃asũ — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","— Bay, g̃axĩn ma'g̃uto ocepit ekay — io'e Jesus. — Ijoce bima bit õn kawẽnwẽn ewebe onze beayũ beam ixeyũ mucokcok am ocokcokap co'i. Obu'u icokcoksũ ãm ip. Obikuy icokcok cĩcã ãm ip ocokcokap co'i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","— Ekawẽn cuk adi og̃uwẽnuwẽn cebe ip. Ekay'ũmat ekukuap puxim g̃u õn jekukum. Ixeyũ dak ekay'ũmat ekukuap puxim g̃u jekukum. Imẽnpuye ixeyũ kay itakoma o'e ip itabut'ũmayũ, ekay'ũmayũ — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","— Bay, “Okay itabucayũ juy etujujẽm ipi dag̃wi,” i'ũmg̃u õn pit e'em ewebe. “Ixeyũ juy eg̃uxipan ikẽrẽat mujurũg̃rũg̃'ukayũ kukukat xewi,” i õn pit e'em ewebe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","— Itabut'ũmat ekukuap puxim g̃u õn jekukum. Imẽnpuxim itabut'ũmat ekukuap puxim g̃u jekukum ip okay itabucayũ — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","— Bay, ixeyũ juy eg̃uwexat soat em ebikuyap tag̃ jekuku'ukayũm. Ekawẽn cocoam cuy ip eg̃uwexat. Ekawẽn acã kawẽn icẽmat — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","— Ẽn cuk omudot ijodiat mutaybin am kawẽn icẽmãn. Imẽnpuxim ixeyũ og̃uju ijodiat mutaybin am kawẽn icẽmãn — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","— Og̃e'ũn'ũn g̃asũ, oxe ixeyũ ikukpin puye. Ebikuyap tag̃ oje'ũ ixeyũ dak ebikuyap tag̃ ceku am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","— Onze beayũ beam acã g̃u õn kawẽnwẽn eweju, Bay. Warara'acayũ itabut je'e okay, ixeyũ omuwẽnuwẽn puye. Ixeyũ beam tak õn kawẽnwẽn eweju―g̃uyjom itabunayũ beam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","— Bay, “Ixeyũ juy esubuywan pũg̃ tag̃ ma ip ceku am,” i õn e'em ewebe. Bay, pũg̃ tag̃ ma ẽn jekukum oweju. Õn tak pũg̃ tag̃ ma eweju jekukum. — Bay — io'e. — Obikuy wuyekukuap co'i ceku am ip. Wuyekukuap tag̃ jekukum pima, itabut'ũmayũ je'e “Deus Jesus emumudot,” i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","— Bay, a'õbacaap cuk adi ejomõg̃ owebe. “Ojo'i ẽn tak a'õbaca,” i juk adi ece owebe, Bay. Imẽnpuxim “Ojo'i eyju dak eya'õbaca,” i õn e'em okay itabucayũ be. Imẽn õn e'em cebe ip pũg̃ tag̃ ma ceku am ip wuyekukuap co'i — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","— Pũg̃ tag̃ ma õn jekukum ixeyũ eju. Ẽn tak oweju pũg̃ tag̃ ma jekukum. Imẽneju pũg̃ tag̃ ma jekukum ip wuyekukuap co'i. Wuyekukuap co'i jekukum pima, itabut'ũmayũ itabut je'e ẽn ma omudocat iap kay. Deus xe wuykukpin apẽn jekpot ikukpin cexe iap co'i iap kay dak itabut je'e ip — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","— Exe okukpin cuk adi og̃uy ipi mujurũg̃ puje. “Wa'õbacaap co'i ẽn tak a'õbaca,” i juk adi ecece owebe. — Bay — io'e. — Onze beayũ juk adi eg̃utabun okay. Obikuy wuydopap pe ixeyũ dop am okpot wa'õbacaap co'i ya'õbaca iap co am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","— Bay — io'e. — Soat em ẽn cũg̃ ma e'em. Ikẽrẽat ejukuk g̃u―pũg̃ em tak ka'ũma. Itabut'ũmayũ itaybit g̃u abu ẽn iam. Õn pit wetaybit cĩcã abu ẽn iam. Onze beayũ itabut cebay teku o'g̃udot ijodi iap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","— “Webay xe eykukpin cĩcã,” i juk adi ocece cebe ip. Iboap og̃uwẽn cebe ip cewemukukpin am ip exe okukpinap co'i. Iboap og̃uwẽn cebe ip pũg̃ tag̃ ma weku am ceweju ip — io'e Jesus. Imẽn Jesus o'jekawẽn cĩcã jebay eju. ");
INSERT INTO myu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jebay eju jekawẽn epere buje, Jesus o'jẽm Jerusalém ka bewi. Jeweju etaybitbinayũ eju o'jẽm. Kadidi dag̃wi o'ju ip―Cedromti dag̃wi. Kadaidip o'tiptop kadidi wĩnãbu. Jesus o'ju ibodip pe onze beayũ eju. Oajẽm ip kadaidip kay. ");
INSERT INTO myu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ade em Jesus cuk adi oekukuku ibodip tag̃ doze beayũ eju. Imẽnpuye Judas itaybit osunuy ibodim Cedromtim. Judas Jesus ũm ojuy cekay itakomaayũ be. ");
INSERT INTO myu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas o'ju Jesus kay. O'ju kadaidip pe. O'ju sorarayũ eju, Deus eju kawẽnwẽnap'a wiwi'ukayũ eju dak. O'ju ip paĩyũ kukukayũ a'õbi, Fariseuyũ a'õbi dak. O'ju ip lamparina'a kukug̃ jebui be, jeba'ip kukug̃ tak, wexiktak kukug̃ tak. Oajẽm ip cekay―Jesus kay. ");
INSERT INTO myu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus kuy itaybit o'e soan―apẽn owebe je'bapuk iam. O'ju ajẽmayũ dopabe―Judasyũ dopabe. O'jekawẽn ceweju ip. — Abu-kudadam epesot? — io'e―Jesus o'e. ");
INSERT INTO myu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","— Jesus kudadam oceju — io'e ip. — Nazaré ka bewiat kudadam oceju — io'e ip. — G̃ebujeat ma'g̃u õn — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“G̃ebujeat ma'g̃u õn” i'e buje, soat ip o'jewede cexewi ajẽm ojuyayũ. O'at ip ipi ju Jesus ekawẽn co buje. Waram Jesus o'e: — Abu-kudadam eyju? — i cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Waram ip o'e: — Jesus kudadam oceju — i. — Nazaré ka bewiat kudadam — i. ");
INSERT INTO myu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","— “G̃ebujeat ma'g̃u õn,” i kuy oce eywebe — Jesus o'e. — Õn ma eyju okudadam. Owejuayũ bit cuy epejat g̃u. Ãg̃ cuy je'jẽm ip — io'e. ( ");
INSERT INTO myu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","— Bay, juk eg̃utabun'iayũ jetabucap jepere g̃u―pũg̃ tak ka'ũma — i juk Jesus o'e. Imẽnpuye — Ãg̃ cuy je'jẽm ip — io'e Judasyũ be jeweju etaybitbinayũ daomũnap puxim, ixeyũ be ipiat supi'ajoacap puxim). ");
INSERT INTO myu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Iboap co buje, Simão Pedro jepaja o'ju'uk iyuk pewi. Kiririk. Paĩyũ kukukat puywatwat'ukat g̃uybu o'sug̃uybu'uk ig̃uybuikibi dag̃ pajam. Tẽg̃wũn. Iba'at kadiat g̃uybu o'sug̃uybu'uk. Ibuywatwat'ukat putet Malco i osunuy. ");
INSERT INTO myu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","— Odaxijom g̃u juy paja kug̃! Ipiat osupi'ajo webay bikuyap tag̃―kuyjeat ekawẽn tag̃ — io'e Simão Pedro be. ");
INSERT INTO myu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jesus o'jat ip Judasyũ, sorarayũ dak, sorarayũ kukukayũdak, Deus eju kawẽnwẽnap'a wiwi'ukayũ dak. O'subamukirik ip. ");
INSERT INTO myu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Koam Jesus o'tujowat ip Anás kay. Ixe Anás Caifás tadop osunuy. Caifás paĩyũ kukukat osunuy ixe koato. ");
INSERT INTO myu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","— Xipat wuywebe ite ag̃okatkat aoka am wuymuy'ũ'ũap puxim — i juk o'e ixe Caifás Judeuyũ kukukayũ be. (24) Anás Jesus o'g̃ujuat Caifás kay―paĩyũ kukukat kay. Ibõg̃bikirig̃ o'g̃ujuat. ");
INSERT INTO myu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro o'ju Jesus nomuju. Warara'acat tak o'ju ceweju. Ixe dak onze beayũ'in osunuy. Ixe wara'acat ma Jesus eju oõm paĩyũ kukukat tuk'a ekorara be. Oõm paĩyũ kukukat itaybit cĩcã ixem puye. ");
INSERT INTO myu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro bit uk'a ekorara exĩntabi xe osunuy. Oõm g̃u buk uk'a ekorara be. Warara'acat o'jepit korara exĩntabi be. O'jekawẽn xĩntabi wiwi'ukat pe―ayacat pe. — Ãg̃ jeõm obure — io'e ayacat pe. — Xipat — io'e cebe. — Eõm cuy — iwiwi'ukat o'e Pedro be. Oõm uk'a ekorara be. ");
INSERT INTO myu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","— Jesus eju etaybitbinat g̃u du ẽn? — ayacat o'e Simão Pedro be―xĩntabi wiwi'ukat o'e. — Ka'ũma — i napa ma o'e Simão Pedro. — Ceweju etaybitbinat g̃u õn — io'e napa ma jebuap puxim. ");
INSERT INTO myu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kajuk kug̃ osunuy. Paĩyũ kukukat puywatwat'ukayũ daxanabõẽ o'tabõẽmusop jeweweam. Daxa etako be kacũg̃cũg̃'i ip osodop daxae o'om jewewewem ibuywatwat'ukayũ, sorarayũ dak. Pedro dak o'ju daxa etako be. Jewewewem ip osodop. ");
INSERT INTO myu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","G̃ebuje paĩyũ kukukat o'jekawẽn Jesus eju. — Eweju etaybitbinat e'eap cuy eg̃uwẽn owebe — io'e Jesus pe. — Apẽg̃ap ekawẽn ixeyũ eg̃utaybitbitbin? — io'e cebe. ");
INSERT INTO myu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","— Apẽnpuye ẽn e'em owebe ma “Apẽg̃ap ekawẽn ixeyũ eg̃utaybitbitbin?” i? Soat em ibapug̃ ma ijoceat og̃utaybitbitbin — io'e Jesus. — Adeayũ etabutpe og̃utaybitbitbin Deus eju kawẽnwẽnap'a be, yabog̃at'a be dak — io'e. — Iba'arẽm g̃u og̃utaybitbitbin―pũg̃ em tak ka'ũma — io'e. — Wemumutaybitbinyũ be juy ecekawẽn. “Apẽn eymutaybin Jesus?” i juy epe'e cebe ip — io'e. — Itaybit ip — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Deus eju kawẽnwẽnap'a wiwi'ukat Jesus dopa o'topaokaka jebum cekawẽn co buje. — Imẽn tu ẽn kawẽnwẽn paĩyũ kukukat eju? — io'e. — Cedag̃ g̃u ẽn kawẽnwẽn! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","24","— Wekawẽn cũg̃'ũm pima, iboap cuy eg̃uwẽn soat pe, ijoceacat pe — io'e Jesus. — Wekawẽn cũg̃ ma bima bit, apẽnpuye dak ẽn odopaokaka? — io'e. Mũg̃ ma o'e. Jededem g̃u. ");
INSERT INTO myu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro jewewewem mabuk o'e daxa etakobe. Cũg̃'i osunuy warara'acayũ parakpe. — Ibakirikat eju etaybitbinat g̃u du ẽn? — io'e ip Pedro be. — Õn g̃u — io'e Pedro napa ma. — Ig̃o ejuat g̃u õn — i napa ma o'e. ");
INSERT INTO myu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Warara'acat o'jekawẽn Pedro be g̃ebuje bit. Ixe wara'acat paĩyũ kukukat puywatwat'ukat osunuy. Pedro emug̃uybu'uk badip osunuy. — Õn ma ejojo ig̃o eju kadaidip pe! — io'e wara'acat. ");
INSERT INTO myu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","— Õn g̃u―warara'acat acã — io'e Pedro napa ma. G̃ebuje isum ma sapokay o'jede. ");
INSERT INTO myu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesus o'tujujẽm ip Caifás tuk'a bewi ceweju jekawẽn epere buje. G̃ebuje Caifás Jesus o'tujowacat iecug̃ap tuk'a kay―Pilatos tuk'a kay. O'tujowat ip kabia isum. Judeuyũ oõm g̃u iecug̃ap tuk'a be Pilatos Judeu'ũm puye. Tuk'a akiju ma ip osodop. Cedag̃ g̃u kuka o'e õm ãm Judeu'ũmat tuk'a be Páscoa epeta muy'an pima. Õm pima: — Wuyisu g̃u Deus xe — i kajuk o'e ip. — Peta xat o ba'ore wuywebe — i kajuk o'e ip. Imẽneju oõm g̃u ip iecug̃ap tuk'a be―Pilatos tuk'a be. ");
INSERT INTO myu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Imẽnpuye Pilatos o'jẽm jeduk'a bewi. O'ju Judeuyũ kukukayũ eju jekawẽn ãm. — Jesus ikẽrẽat kug̃ tu eyxe? — io'e Pilatos Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","— Hm hm — io'e ip. — Ocexe ma ite ikẽrẽat cuk adi o'jukuk. Ocedobuyũ'ũm'ũm ekawẽn tag̃ g̃u teku jekukum. Ẽn cuy ite eyaokaat — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","— Eyju ma juy epetujujẽm oxewi — io'e Pilatos. — Eyju ma juy ipiat epesupi'ajoat cebe eydobuyũ'ũm'ũm ekawẽn tag̃ — io'e. — Ap! — io'e ip. — Oca'õbi g̃u oceju ibamupaya ojuy ce'ũ ãm―a'õbi acã — io'e ip Pilatos pe―iecug̃ap pe. ");
INSERT INTO myu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Jesus cuk adi o'e — Obamupaya ip we'ũ ãm — i. Itaybit'ũm pima Judeuyũ kukukayũ o'jekawẽn Pilatos pe kuy o'e'e iap co'i―Jesus pe o'e'e iap co'i). ");
INSERT INTO myu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos oõm ma'g̃uto jeduk'a be. Jesus o'g̃udocat jewekay. — Judeuyũ kukukat tu ẽn? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","— Ag̃uy dag̃ tu iboam ẽn e'em owebe? — io'e. — Warara'acat ag̃uy dag̃ g̃u xe'e? — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","— Wag̃uy dag̃ g̃u! — io'e―Pilatos o'e. — Judeu g̃u õn pit — io'e Pilatos. — Judeuyũ ma edojot okay. Apẽn ẽn tak ece ikẽrẽan? — io'e Jesus pe. — “Judeuyũ kukukat õn,” i du ẽn eẽm? — io'e Jesus pe. ");
INSERT INTO myu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","— Eybuxim g̃u õn ijodiacat kukukat — io'e. — Õn ijodiat puximan pima kuka adi webekitkit o'jewaokaka okay itakomaayũ eju. O'jewaokaka kuka adi ip Judeuyũ be obuap puxim. Imẽnpuye ijodiat a'õbi g̃u õn warara'acayũ kukukat — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","— Ijodiat kukukat tu ẽn? — io'e Pilatos. — Hm hm. Ikukukat õn — io'e. — Kawẽn icẽmat muwẽn ãm okop ijodi. Kawẽn icẽmat muwẽn ãm okap. Kawẽn icẽmat kay kũyjobicayũ wekawẽn kay dak kũyjobit — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","— Ka'ũmg̃u kawẽn icẽmat! — io'e Pilatos. G̃ebuje Pilatos Jesus eju jekawẽn o'jepere. O'jẽm ma'g̃uto jeduk'a bewi. O'jẽm jekawẽn ãm ma'g̃uto Judeuyũ kukukayũ eju. Akiju ip osodop. — Oxe ma ite ag̃okatkat ikẽrẽat o'jukuk g̃u. Pũg̃ em tak o'jukuk g̃u ma — Pilatos o'e cebe ip. — Cũg̃ g̃u kuka o'e wuywebe yaoka am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","— Páscoa epeta bima pũg̃ ma õn imujẽmjẽm'uk daomũnmũnap'a bewi jekpiwan ma ceku am. Eybikuy du owebe eykukukat mujẽm ãm jekpiwan ma ceku am―Jesus mujẽm ãm? — io'e Pilatos. ");
INSERT INTO myu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","— Ap! — io'e ip. — Ixe g̃u juy eg̃ujẽmat — io'e ip ya'õberen. — Barrabás pit eg̃ujẽmat — io'e ip. — Barrabás kay oceju! — io'e ip ya'õberen. (Ixe Barrabás jebureyũ aokakaxi osunuy). ");
INSERT INTO myu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","— Jesus cuy epeyukxabimupokupok wuyukxabimupokupokapxeem — io'e Pilatos sorarayũ be. O'yukxabimupokupok ip sorarayũ. ");
INSERT INTO myu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jesus waywayway pin ip osodop. Jesus ijodiat kukat iap waywayway pin osodop ip. Imẽnpuye widaohobune o'subunemuwakẽn ip yabeam. O'jomõg̃ ip ya be ijodiat kukat a beat mõg̃ap co'i. Iekabek o'g̃uõm ip Jesus pe ijodiat kukat ekabek co'iat. O'g̃uõm ip iberenat―iremrumg̃ug̃ũnat. O'g̃uõm ip iwaywayway am. ");
INSERT INTO myu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","— Ak'i! Teku Judeuyũ kukukat! — io'e ip Jesus waywayway am. Warara'acat ma ip o'topaokaka jebum. ");
INSERT INTO myu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatos waram o'ju jeduk'a ekorara be. Judeuyũ kukukayũ kay o'ju. — Ak'i! — io'e. — Waram ixe otojocat eyetabixe am — io'e. — “Oxe bit ite ikẽrẽat o'jukuk g̃u―pũg̃ em tak ka'ũma,” i õn e'em eywebe — io'e Pilatos. ");
INSERT INTO myu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Imẽnpuye ixe Jesus o'jẽm uk'a bewi. Xerwun. O'ju Pilatos xe. Oajẽm adeayũ wap. Yabeat kug̃ mabuk osunuy―widaohobune kug̃. Iekabek kug̃ mabuk osunuy―iremrumg̃ug̃ũnat kug̃. — Ak'i juy epe'e — io'e Pilatos adeayũ be. — Ijoce ma ag̃okatkat — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","— Ite ba juy esubamupayaat korosa be ce'ũ ãm — io'e ip ya'õberen paĩyũ kukukayũ, Deus eju kawẽnwẽnap'a wiwi'ukayũ dak. O'jewãwã ip. Imẽn o'e ip Jesus co buje. — Ite ba juy esubamupayaat korosa be ce'ũ ãm — io'e ip ya'õberen. — Eyju ma juy epejat — io'e Pilatos cebe ip. — Eyju ma juy epesubamupaya korosa be — io'e. — Oxe bit cũg̃ g̃u wuywebe yaoka am. Oxe ikẽrẽat o'jukuk g̃u―pũg̃ em tak ka'ũma — io'e. ");
INSERT INTO myu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","— Cũg̃ ma ocexe bit yaoka am cekawẽnkẽrẽ buye — io'e Judeuyũ kukukayũ. — “Deus ipot õn,” i juk adi o'e teku — io'e ip. — Imẽnpuye ocedobuyũ'ũm'ũm ekawẽn tag̃ oceju yaokam — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatos iparara jĩjã ma o'e “Deus ipot õn,” i teku e'em iap tobuxik puje. ");
INSERT INTO myu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Waram oõm jeduk'a be Jesus eju kawẽn ãm. — Apomawi ejot? — io'e Pilatos Jesus pe. Imẽnpit Jesus jededem g̃u. ");
INSERT INTO myu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","— Ede pin g̃u du owebe? — io'e Pilatos. — Wa'õbuyxi õn. “Iteba juy epesubamuwekap,” i õn e'em pima, jebamuwekap ip. Ekupinap tag̃ eceku — io'e Pilatos. — “Epesubamupaya korosa be ce'ũ ãm,” i õn e'em pima bit, jebamupaya ip e'ũ ãm — io'e―Jesus pe o'e. ");
INSERT INTO myu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","— A'õbuyxi ẽn Deus cuk a'õbuyxian emuy buye — io'e Jesus. — Emuy'ũm pima, apẽn kuka ece owebe? Ka'ũma ma! — io'e―Jesus o'e. — Ewebe oaokaan puje, ikẽrẽat kug̃ ece'e Deus xe. Ebodi ma bit ekay odojocat pit ikẽrẽat kug̃ je'e cexe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iboap co buje, Pilatos Jesus pa muwekap ojuy jĩjã o'e. — Jesus pa muwekap ojuy oce — io'e Pilatos jewebe ma. — Roma ka kukat itakoma soat kay― “Õn ma ijodiat kukat,” i'e'e'ukayũ kay — io'e Judeuyũ kukukayũ Pilatos pe. — César itakoma cekay ip — io'e ip. — Ewebe ibamuwekap puje, César kuka itakoma o'e ekay dak — io'e ip Pilatos pe. ");
INSERT INTO myu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatos waram Jesus o'tujowat jeduk'a eakiju. O'tujowat adeayũ wap iboap co buje. Pilatos oabik ibimãmãmãat ekawẽn coco'ukap pe. Gabatá i uk'a eakijuat putet osunuy. Gabatá wita'a mug̃ẽg̃ẽ iape wuya'õm. ");
INSERT INTO myu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sexta-feira kaxicug̃ osunuy. Sábado emap kabia Judeuyũ jekaxipanpan ip o'e peta muy'an―Páscoa epeta muy'an. — Ak'i juy epe'e — io'e. — Teku eykukukat — io'e Pilatos Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","— Ite g̃u ocekukukat! i o'jede paĩyũ kukukayũ. — Ite juy eyaokaat! — io'e ip ya'õberen. — Ite juy eyaokaat — io'e ip. — Esubamupayaat korosa be ce'ũ ãm — io'e ip jetakoma pibun. — Eykukukatpa du osubamupayaat korosa be? — io'e Pilatos. — Pũg̃ ma wuykukukat — io'e ip. — César acã wuykukukat — io'e ip paĩyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Imẽneju Pilatos jesorarayũ o'tomuwã. — Ite juy epejat — io'e cebe ip. — Epesubamupaya korosa be — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus o'jat ip. Ibocewi o'jẽm ip Pilatos duk'a bewi. G̃ebuje Jesus o'tujowat ip co'a kay. Wuyjuyũ'aririt'a i co'a butet osunuy. (Gólgota i co'a butet osunuy Judeuyũ a'õm). Korosa kug̃ o'ju Jesus. Jay. Oajẽm ip. ");
INSERT INTO myu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ig̃o'a be sorarayũ Jesus pa o'subamupaya ip korosa jeje ipiju. Tag̃tag̃tag̃'i tapoam o'e ip. Ibubida be tapoa o'jomuy ip. Cẽh. Korosa o'g̃u'ag̃obucẽg̃ ip ipikũykũy be. Bẽg̃. Warara'acayũ be dak o'subamupaya ip korosa eju xepxepayũba. Wara'acat ceje o'subamupaya ip korosa jeje. Pũg̃ korosa o'jomuy ip ipikũykũy be Jesus ba'at kadi. Wara'at o'jomuy ip iba'ũg̃at kadi. Jesus ixeyũ parakpe osunuy korosa eju. Toro'ih. ");
INSERT INTO myu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos tak taperadup o'tupmubararakat. O'tupmõg̃at korosa eju. Tupararakatup o'tupcoco ip kapkamayũ “Jesus teku,” io'e taperadup pe. “Nazaré ka bewiat―Judeuyũ kukukat” io'e taperadup pe. ");
INSERT INTO myu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iboaptup o'tupmubararak ip Judeuyũ a'õm, Romanoyũ a'õm tak, Gregoyũ a'õm tak. Jesus o'subamupayaiat ka Jerusalém ka tẽg̃ ma o'sukadop. Imẽneju iboaptup o'tupcoco Jerusalém ka be powatwatyũ. ");
INSERT INTO myu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Imẽneju paĩyũ kukukayũ o'jekawẽn Pilatos eju. — “Teku Judeuyũ kukukat osunuy” iaptup g̃u juy etupmubararak, “ ‘Õn Judeuyũ kukukat,’ i juk adi o'e teku” iaptup acã — io'e ip paĩyũ kukukayũ. ");
INSERT INTO myu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","— Ap! — io'e Pilatos. — Otupmuwarurun g̃u juy wemudupmubararaktup — io'e. ");
INSERT INTO myu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Korosa eju Jesus pa mupaya buje sorarayũ cesay mu'ẽ'ẽ ojuy ip jewewebe. Cesay osodop ebadipdip. Sorarayũ dak ebadipdip osodop. Ibinũnpeat pit pũg̃ ma imug̃ẽg̃ẽ osunuy pag̃õm. Iinũmnũm g̃u ikug̃ osunuy. Soat iinũmnũm'ũmat kay o'e ip sorarayũ. ");
INSERT INTO myu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","— Ibinũnpeat ag̃uwek g̃u juy — io'e ip jewewebe. — G̃a'a karatũg̃'a jo'iat'a ayaxik ipi ju. Ya'at puje pũg̃ ma je'jat. Ya'at puje wuyetaybit ace'e abu je'jat iam — io'e ip jewewebe. O'yaxik ip ipi ju. Deus ekawẽntup e'em―kuyjeatup: Wesay o'g̃u'ẽ'ẽ ip jewewebe, i. Karatũg̃'a jo'iat'a o'yaxik ip obinũnpeat pu am, i. Imẽn e'em Deus ekawẽntup. Sorarayũ be yaxik puje Jesus ekabek pu am, iboaptup ekawẽn tag̃ ip o'e. ");
INSERT INTO myu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","G̃ebuje Jesus jexi o'jojojo. Jesus xi korosa xe osunuy. Ixi kibit tak iboce osunuy. Maria Madalena dak iboce osunuy korosa xe. Wara'at Maria dak iboce osunuy―Clopas tayxi. ");
INSERT INTO myu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus jexi o'jojojo. Doze beayũ'inat ixi xe osunuy. Ixe Jesus emumukukpinput osunuy. Ixe dak Jesus cocom o'e. — Tũ'ũ — io'e. — Teku jekuk g̃asũ jexi kukap co'i — io'e. ");
INSERT INTO myu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","— Tapu — io'e jemumukukpinput pe. — Oxi juy ejukuk g̃asũ exi kukap co'i — io'e Jesus. Ixe ag̃okatkat Jesus xi o'g̃uõm jeduk'a be g̃ebuje bit. Jesus e'ũ buje jexi kukap co'i ma xipan o'jukuk. ");
INSERT INTO myu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus itaybit o'e soat wekapikap og̃u'ũm iam. — Obipuruk — io'e Jesus. Iboam o'e Deus ekawẽntup ekawẽn tag̃. ");
INSERT INTO myu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uva'abidi o'tinuy iboce wa'e jo'iat'a be―tideibog̃'ũmati. Iboceat tibubuap o'g̃uakõm ig̃odi be. O'jomuy ip ip'abi be hissopo'ip abi be. Bẽg̃'i. O'yopmuyu Jesus pe tikõn ãm. ");
INSERT INTO myu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","O'tikõn tibubuap pewi. Korotkorot'i. — Soat wekapikap og̃u'ũm — io'e Jesus. O'je'aetore. Jekpiwan ma oe'ũ. ");
INSERT INTO myu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","G̃ebuje Judeuyũ kukukayũ ibamupaya'ibit mukop ojuy korosa ejuwi. O'ju ip kawẽn ãm Pilatos eju―iecug̃ap eju. — Ocebu'u jĩjã jebodoydoyap kabia be korosa eju ce'ũ'ũayũ nuy ãm — io'e ip. — Ibamupaya'ibit tao juy etaodakacat dao ma ce'ũ ãm — io'e ip Pilatos pe. — Ixeyũ'ũm'ũm cuy eg̃ukopat Sábado ajẽm awap — io'e ip Pilatos pe. Imẽn o'e ip sexta-feira buye. Kuyaje Sábado―jebodoydoyap kabia. Judeuyũ xe petabog̃ cĩcã osunuy. Imẽneju ibu'u jĩjã ip osodop ixeyũ'ũm'ũm nuy ãm korosa eju Sábado bima―jebodoydoyap kabia bima. ");
INSERT INTO myu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Imẽneju sorarayũ o'ju korosa ejuayũ kay. Wẽg̃. Pa. Koapatao o'taodakat ip korosa ejuatao. Wẽg̃. Pa. Wara'acatao dak o'taodakat ip―Jesus eju ibamupaya'ibitao. ");
INSERT INTO myu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sorarayũ oajẽm Jesus'ũm kay. — Kuy oe'ũ — io'e ip jewewebe. Imẽnpuye Jesus'ũmtao o'taodakat g̃u ip. ");
INSERT INTO myu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","37","Imẽn e'em Deus ekawẽntup: Ixe dao taodakat g̃u ip―pũg̃tao dak ka'ũma, i. Tik. O'ya'õxamutik. Sorara Jesus'ũm o'ya'õxamutik obukaka'ukren. Wara'atup imẽn e'em―Deus ekawẽntup: Ya'õxamutik'ibit kay jeakak ip wuyjuyũ, i. Kuyjeatup ekawẽn tag̃ o'jebapuk Jesus e'ũ buje―Deus ekawẽntup ekawẽn tag̃. Jesus'ũm oe'ũiap o'jojojoiat ce'ũap o'g̃uwẽn ocewebe. Ocetaybit ixe icẽmãn e'em iam. Oceju dak Jesus'ũm e'ũap muwẽnuwẽn eywebe dak eyetabun cekay am. ");
INSERT INTO myu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","José o'ju Pilatos kay Jesus'ũm jebit mukopap ojuy korosa ejuwi. Arimatéia ka bewiat osunuy ixe. Jesus kay itabut osunuy. Ibapug̃ g̃u bit Jesus kay wetabut i'e'e'uk osunuy warara'acayũ be―iba'arẽm mabuk. Ibapug̃ g̃u i'e'e'uk osunuy Judeuyũ kukukayũ buxim jeparara buye. — Jesus'ũm jebit mukop ojuy õn pit korosa ejuwi — io'e José Pilatos pe. — Ha'a — io'e Pilatos. — Esujebitmukop — io'e. José o'ju Jesus'ũm kay―korosa ejuat'ũm kay. Ijebit o'g̃ukop korosa ejuwi. O'tujowat witabikũy kay. ");
INSERT INTO myu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemos o'ju José eju. Imude'o'onap kug̃ o'ju. Ade ikug̃ o'ju―45 kilo ikug̃. Iwekoykeyap osunuy imude'o'onap. Mirra'ip peati tiwekoykey o'e aloé'ip peati eju. Jesus'ũm jebit mude'o'on ojuy ig̃ẽmap puxim. Ixe Nicodemos kuy bima Jesus eju o'jekawẽn ixima be. ");
INSERT INTO myu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xepxepayũ Jesus'ũm jebit o'jat―José, Nicodemos tak. Imude'o'onap o'g̃uwedi ip pag̃o dag̃―xipacat tag̃. Ijebit o'jomũnmũn ip ixem pag̃õm. Pereh. Imẽn ma Judeuyũ wuyjuyũ'ũm'ũm muxipanpan'uk ip osodop witabikũy be imuõm ãm. ");
INSERT INTO myu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kadaidip o'tiptop Jesus pamupayaap pe. Ig̃odip pe witabikũy o'sukũynuy―wuyjuyũ'ũm'ũm muõmuõmapkũy. Ikũyisuatkũy o'sukũynuy. Ikũyisuatkũy be ce'ũat o'jomõg̃ g̃u buk ip. ");
INSERT INTO myu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sexta-feira osunuy. Sexta-feira bima jexat muxipanpan'uk ip osodop Judeuyũ Sábado bima i'o'ibin. Sábado bima jebodoydoy'uk ip osodop. Witabikũy ibamupayaap tẽg̃ ma o'sukũynuy. Imẽneju Jesus'ũm o'jomõg̃ ip ig̃okũy be. ");
INSERT INTO myu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo bima Maria Madalena o'ju witabikũy kay. Kabiakabia'i bima o'ju. Kabiok ma bima buk o'ju. Ikũynomudip'a o'yajojo wita'a. Yabog̃at'a o'yajojo. Tũybe wuyjuyũ o'tujupa'um ijebit iãn o'e Maria. Yawede o'yadobuxik tomudip'a. ");
INSERT INTO myu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O'jedau Pedroyũ kay. Oajẽm cekay ip. Pũg̃ ixeyũ'in Simão Pedro osunuy. Wara'acat Jesus emumukukpinput osunuy. Ixe dak Jesus eju etaybitbinat osunuy. — Wuykukukat'ũm o'tujupa'um ip witabikũy bewi — io'e Maria xepxepayũ be. — Poce xe'e ip ixe'ũm o'jomõg̃? Ocetaybit g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","O'jẽm Pedroyũ jeduk'a bewi. O'ju ip witabikũy kay. ");
INSERT INTO myu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xepxem ma o'ju ip daudaum. Warara'acat pit dao ma o'jedau. Koap oajẽm witabikũy be. Jay. ");
INSERT INTO myu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Atoroh. O'je'atoro ikũy kay. Etaburut. O'jetaburut. Pag̃o o'jojojo irucat. Ijebit mũnmũn o'jojojo. Imẽnpit oõm g̃u ikũy be. ");
INSERT INTO myu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kanomũm Simão Pedro oajẽm. Jay. Oõm witabikũy be Simão Pedro. Cereg̃. Bodiku pag̃o osodop irucat xipacat. Ibo o'jojojo. ");
INSERT INTO myu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wara'at pag̃o o'tobuxik―Jesus'ũm a dag̃ osodopiat. Yadag̃ osodopiat ijebit mũnmũnap epag̃o xe g̃u osodop. Wara'at pe ma osodop. Iekabek acã osodop ya'a o'yadopiat pe. Ka'ũmg̃u ijebit pit. ");
INSERT INTO myu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wara'acat tak oõm g̃asũ―Jesus eju etaybitbinat―Jesus emumukukpinput. Badi o'jeak. — Ak'i ece! Ka'ũmg̃u ijebit! — io'e jewebe ma. — Waram Jesus o'jetait! — io'e jewebe ma. ");
INSERT INTO myu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Deus ekawẽntup imẽn e'em: Deus ixe g̃uyu ce'ũ'ũayũ xewi, i. Kuy bima ibodup ekawẽn cekawẽn pa'arẽm osodop cexe ip. G̃asũ bit ibapuk o'e Jesus eju etaybitbinayũ xe. ");
INSERT INTO myu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Xepxepayũ ma o'jepit jeduk'a be. ");
INSERT INTO myu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Madalena bit waram o'ju witabikũy jom. Jay. Oajẽm. Ikũy jojom osunuy itabẽg̃ ikũy etakobe. Wa osunuy. O'je'atoro. Atoroh. Axih. Wa o'e. O'jetaburut ikũy be. ");
INSERT INTO myu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Deus ekawẽn tojotjot'ukayũ o'jojojo xepxepayũ―kabi kadiwiayũ. Cesay irucat kug̃ ip osodop. Kaxikxik'i osodop ip Jesus'ũm osodopiap pe. Pũg̃ ixeyũ'in ya'a o'yadopiap pe osunuy. Wara'acat ixeyũ'in sui o'suidopiap pe osunuy. ");
INSERT INTO myu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","— Tũ'ũ — io'e ip Maria be. — Abu-kay ẽn wa? — io'e ip. — Okukukat'ũm kay — io'e. — Okukukat'ũm o'tujupa'um ip — io'e. — Imẽnpuye õn wa. Wetaybit g̃u poce ip o'jomõg̃ iam — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","O'jekorepẽn imẽg̃ap e buje. Jesus cũg̃'i osunuy tõg̃pikadi. Jesus o'jojojo. Imẽnpit itaybit g̃u o'e ixem. O'jetabieba'arẽm ixem. Tũybe ija g̃u iãn o'e. ");
INSERT INTO myu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","— Tũ'ũ — io'e Jesus. — Abu-kay ẽn wa? — io'e cebe. — Abu-kudadam ẽn? — io'e. Tũybe sute kadaidip wiwi'ukat iãn o'e Maria cebe. — Okukukat'ũm kudadam õn — io'e. — Ẽn tu ixe'ũm etujujẽm? Poce ejomõg̃iap cuy eg̃uwẽn owebe! — io'e. — Õn ma oju ixe'ũm tujupit am — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","— Maria! — io'e. O'jekorepẽn Jesus kay. — Raboni — io'e ja'õm―Judeuyũ a'õm. (Raboni wekariwa iape). ");
INSERT INTO myu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","— Obaixig̃ g̃u ece — io'e. — Webay kay buk oceu g̃u — io'e Jesus. — Eju juy okitpiyũ kay―oweju etaybitbinayũ kay — io'e. — “Webay kay waram oceu―eyebay kay,” i juy ece cebe ip — io'e. — “Wuyebay Deus oxe, eyxe dak,” i juy ece cebe ip — io'e Jesus Maria be. — Hm hm — io'e―Maria o'e. ");
INSERT INTO myu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Madalena o'ju Jesus eju etaybitbinayũ kay. — Wuykukukat ojojojo! — io'e cebe ip. — Waram o'jetait! — io'e. Jewebe Jesus o'e'e iap o'g̃uwẽn cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kabiog̃ pima Jesus o'jebapuk jeweju etaybitbinayũ kay. Ixe Domingo bima o'jebapuk cekay ip. Awerom ip osodop uk'a be. Cem ma'g̃u tomudipdip osunuy xĩntabi, Judeuyũ kukukayũ buxim iparara buye. Inaka Jesus o'jebapuk cekay ip. — Kaba'ũm cuy epeyewekuk — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","O'jewebumupaya cekay ip. O'jewa'õxamubapuk cekay ip. Icokcok cĩcã ma ip o'e jekukukat tobuxik puje. ");
INSERT INTO myu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","— Kaba'ũm cuy epeyewekuk — io'e waram Jesus. — Webay juk omudot ijodi. Imẽnpuxim õn tak jeymuju omuwẽn ãm ijodiat pe — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jebido o'subidomuju cekay ip. Puw io'e. — Obiõg̃buk og̃uõm eywebe — io'e. — Xipacat og̃uõm eywebe — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","— “Deus ikẽrẽat ju'uk eywebewi” i ey'e buje, ikẽrẽat ju'uk ixeyũ bewi — io'e. — “Deus ikẽrẽat ju'uk g̃u eywebewi” i ey'e buje bit, ju'uk g̃u ikẽrẽat ixeyũ bewi — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","G̃ebuje Jesus o'ju Tomé kay―jeweju etaybitbinat kay. Ixe Tomé doze beayũ'in osunuy. Xepxem ikap'ibit i ixe butet osunuy wara'at ibutet. Warara'acayũ eju g̃u ixe Tomé osunuy ixeyũ kay Jesus ebapuk puje. Jesus o'jojojo g̃u buk waram cetait puje. ");
INSERT INTO myu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Imẽnpuye warara'acayũ o'jekawẽn Tomé eju―ceweju etaybitbinayũ. — Tapu, wuykukukat ma ocejojojo! — io'e ip. — Waram g̃uto o'jetait! — io'e ip. — Dapxi eyju! — io'e. — Wetabut g̃u oce waram ixe'ũm o'jetait iap kay — io'e. — Tapoa kũybut cocom'ũm pima, wetabut g̃u oce — io'e. — Tapoa kũybut pe osubumõg̃'ũm pima dak, wetabut g̃u oce — io'e. — Ya'õxatikat pe osubumõg̃'ũm pima, wetabut g̃u oce — io'e Tomé. ");
INSERT INTO myu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","7 xet kap puje Jesus eju etaybitbinayũ waram awerom osodop ip uk'a be. Tomé dak cexe ip o'e. Uk'a exĩntabi tomudipcẽm cĩcã osunuy. Jesus pit oõm ig̃o'a be. Onze beayũ kay waram o'jebapuk. — Kaba'ũm cuy epeyewekuk — io'e Jesus cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesus dao ma o'jeak Tomé kay. Ak'i o'e. O'jekawẽn ceweju―Tomé eju. — Ak ece obubida kay — io'e Tomé be. — Tapoa kũybut cuy ejojojo obubida be — io'e. — Tapoa kũybut pe juy ebu esubumuõm — io'e. — Wa'õxatikat pe juy ebu esubumuõm itikatkũybut pe icẽmãm poro iam — io'e Jesus. — “Ixe'ũm waram o'jetait g̃u,” i'ũmg̃u juy ece — io'e. — Etabun cuy eg̃uy! — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","— Kariwa, wetabut ekay — io'e Tomé. — “Ẽn ma Deusat,” i õn e'em — io'e―Tomé o'e. ");
INSERT INTO myu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","— Etabut ojojom ẽn puye — io'e Jesus. — Warara'acayũ bit ojojo g̃u. Inaka itabut je'e ip okay. Icokcok cĩcã ma ip je'e — io'e. ");
INSERT INTO myu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus ja'õbacaap o'jomõg̃mõg̃ jeweju etaybitbinayũ etabixe. Soat g̃u ya'õbacaap mõg̃mõg̃ap mubarararag̃ õn ijudup pe. ");
INSERT INTO myu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pũg̃pũg̃ ã õn imubarararag̃ ijudup pe Jesus pe o'g̃ubapukpukiap. Iboap og̃ubararak eymutabut am Jesus Deus emunaẽ iap kay, Jesus Deus ipot iap kay dak. Iboap kay eyetabun pima, ixe a'õbi eyag̃uyisum epeku ijodi; eyetait epesop cexe eye'ũ buje dak. ");
INSERT INTO myu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","G̃uyjom Jesus waram o'jebapuk jeweju etaybitbinayũ kay. Iodi xe o'jebapuk cekay ip. Iodi butet Tiberíades i osunuy. O'je'awero ip 7 beayũ ceweju etaybitbinayũ. Iodi xe o'je'awero ip. Pũg̃ em g̃u o'jebapuk ce'ũ'ũ'ibiyũ xewi jeu buje. ");
INSERT INTO myu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ibũrũ ma ibutet osodop ip: Simão Pedro i, Tomé i, Natanael i, Zebedeu ipotpoyũ xepxep, warara'acayũ dak xepxep. Xepxem ikap'ibit i Tomé butet osunuy wara'at ibutet. Natanael Caná ka bewiat osunuy―Galiléia eipi bewiat. Ibũrũ ma o'je'awero ip. ");
INSERT INTO myu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","— Cum puk õn axima bum — io'e Simão Pedro jebureyũ be. — Ha'a — io'e ip. — Oceju dak cum eweju ocexat pum — io'e ip. Ixima dag̃ axima bubum ojuy ip. Kobe be ip oõm axima bu pinayũ. Haham oeku ip. Imẽnpit o'jat g̃u ip. Te'e ma ip oeku. ");
INSERT INTO myu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jesus o'jebapuk iodi wãbu be kabia buje. Imẽnpit teku wuyekariwa iap iba'arẽm o'e 7 beayũ xe. Itaybit g̃u o'e ip teku wuyekariwa iam. Wĩnãbu wi o'jewãwã cebe ip. ");
INSERT INTO myu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","— Tapupuyũ — io'e Jesus cebe ip. — Peburũ axima epejat? — Ka'ũma ma — io'e ip. — Ocejat g̃u! Te'e ma oceku — io'e ip. — Eyba'at kadi ma ũrũ epeg̃uakõm — io'e Jesus. — G̃ebuje bit ade ma epejat — io'e. — Hm hm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tok. Ũrũ o'g̃uakõm ip jeba'at kadi. Ade o'jat ip axima. Ũrũ mupuxik pa'ore o'e cebe ip axima poxi pibun. ");
INSERT INTO myu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","— Ak'i juy g̃okayku! Wuykukukat ma g̃oku! — io'e Jesus emumukukpinput Simão Pedro be. Simão Pedro jeekabek o'g̃uõm jekukukat topabe jejuam. Jeekabek kug̃ g̃u kapikpik'uk osodop ip. Tip. O'jetip iodi be dao ma Jesus kay jajẽm ãm. ");
INSERT INTO myu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Warara'acayũ Jesus kay oajẽm kobe dag̃wi. Oajẽm ip ũrũ mupuxikpuxig̃ kobe ukpu bewi. Ade jĩjã osodop axima ũrũ be. Wũy g̃u ip osodop kapurũg̃ pewi―100 metros acã. ");
INSERT INTO myu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jay. Mug̃. Jesus o'jojojo ip. Axima yoyoy o'e daxa be. Pão'a kug̃ tak osunuy. ");
INSERT INTO myu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","— Axima'in epetojot―g̃asũ epejat'iat'in — io'e Jesus cebe ip. — Hm hm — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Oõm kobe be axima bum. Ũrũ o'g̃uwekap. O'tujuu kapurũg̃ kay. Jay. Axima o'tojot. Ade osodop ũrũ be axima yobog̃at. 153 osodop ip. Inaka ũrũ o'jewek g̃u. ");
INSERT INTO myu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","— G̃a'a acekõn — io'e jeweju etaybitbinayũ be. — G̃a'a — io'e ip. — Abu ẽn? — io'e g̃u ma cebe. Itaybit o'e ip wuykukukat teku iam―waram o'jetaitiat teku iam. ");
INSERT INTO myu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","14","Jesus pão'a o'yabu. Axima dak o'jat. O'g̃ũm cebe ip ixan. ");
INSERT INTO myu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","G̃ebuje Jesus o'jekawẽn Simão Pedro eju―João ipot eju. O'jekawẽn ceweju jekõn epere buje. — Simão — io'e Jesus. — Warara'acat kukpinap podi ma du okukpin exe? — io'e. — Hm hm, Kariwa — io'e Simão. — Etaybit ebure õn iam — io'e. — Wekawẽn cuy eg̃utaybin itabun'isuayũ — io'e Jesus. — Xipan cuy ixeyũ ejukuk apẽn ovelha kukat xipan jeõhõ'it'it kukap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","— Simão — io'e Jesus waram. — Okukpin tu exe? — Hm hm, wekariwa — io'e. — Etaybit ebure õn iam. — Wekawẽn cuy okay itabucayũ eg̃utaybin — io'e. — Xipan cuy ixeyũ ejukuk apẽn ovelha kukat jeõhõyũ kukap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","— Simão — io'e Jesus waram. — Ebure du õn? — io'e. Ebapũg̃ em imẽn o'jekawẽn Simão eju. Imẽnpuye Simão ig̃uycũg̃ o'e Jesus e'eap kay. — Kariwa — io'e. — Etaybit soan. Etaybit õn ebure iam. — Wekawẽn cuy itabucayũ eg̃utaybin — io'e Jesus. — Xipan cuy ixeyũ ejukuk apẽn ovelha kukat jeõhõyũ kukap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","— Simão, icẽmãn õn e'em ewebe. Jaypan'isum ekpiwat ma jekuku'uk eg̃uy. Esay muõm puje, ekupinap tag̃ acã jekuku'uk eg̃uy. Aypa bima bit ecejebaepacũg̃ warara'acat pe ebamũn ãm correntebum. Warara'acat jedujowat edaobu'unap tag̃ — io'e Jesus. ");
INSERT INTO myu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","24","Imẽn Jesus apẽn Pedro je'ũ iam o'g̃ukũyjo. Apẽn Pedro Deus dipap g̃ubapukpuk iam tak o'g̃ukũyjo. — Obikuyap tag̃ cuy ejeku — io'e Jesus Pedro be. Jekorepẽn puje Pedro Jesus emumukukpinput o'jojojo. Cemumukukpinput doze beayũ'in osunuy. Pedro nomuju o'e. — Kariwa — io'e. — Apẽn je'bapuk g̃uyjom g̃obeku? — io'e Simão Pedro Jesus emumukukpinat co buje. — “Apẽn je'bapuk g̃obeku g̃uyjom,” i'ũmg̃u juy ece owebe — io'e. — “Õn tu wekariwa bikuyap tag̃ jekukum?” i acã ece ewebe ma — io'e Jesus. — Obikuy bima bit kuka adi teku oe'ũ g̃u — io'e. — Obikuy bima, ijoce mabuk teku kuka adi osunuy waram wajẽmap com — io'e. — Imẽn obikuy bima, ak'adit ma'g̃u kuka eg̃uy iboap kay — io'e Jesus. Imẽneju itabucayũ o'Jekawẽn cĩcã jeweweju. Tũybe je'ũ g̃u iãn o'e ip. Imẽnpit: — Teku je'ũ g̃u — i'ũmg̃u o'e Jesus. — Obikuy bima kuka adi teku ijoce mabuk jeenuy waram wajẽmap com — i juk o'e Jesus. Jesus eju oekukuiat ma apẽn Jesus cuk adi o'e'e iap o'g̃uwẽn ocewebe―Jesus xe ikukpinat. Jesus tẽg̃ ma osunuy doze beayũ eju jekõnkõn pima Jesus e'ũ awap. — Kariwa, abu oce'in je'ũm ekay itakomaayũ be? — i juk o'e ce'ũ awap. Ixe ma Jesus o'e'eiap o'g̃uwẽn ocewebe. Wuyetaybit ixe icẽmãn e'em iam. Ixe ekawẽn mubarararag̃ õn ijudup pe―cartadup pe. ");
INSERT INTO myu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ade jĩjã ma osunuy Jesus e'eap. Soat g̃u ixe e'eap o'g̃ubararak cemudupmubararaktup pe―ijudup pe. Soat pit ixe o'e'e iap mubarararag̃ pima, apoce dak kuka atupmõg̃? Tup ade jĩjã ma kuka o'e ibiatup. O'e g̃u kuka ipi dag̃ wuywebe ibiatup mõg̃ ãm. Imẽn kuka o'e wuyxe. Ibũrũ ma.");
INSERT INTO myu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, kuy bima livrodup otupmubararak ewebeaptum. Apẽn ijodi bima Jesus cuk adi o'g̃utaybitbiniaptup otupmubararak, apẽn ixe juk adi o'e'eiaptup tak. Soat iboap og̃ubararak kuyatup pe ewebeaptup pe. ");
INSERT INTO myu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Kabi kay jeu awap Jesus doze be o'taẽ ag̃okatkayũ. O'taẽ jeweju itaybin'ibiyũm. Taẽ'ibiyũ o'g̃utaybin Deus biõg̃buk a'õbi jeu awap. ");
INSERT INTO myu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","40 kabia ijodi oeku waram jetait puje. Ade em o'jebapukpuk jeweju etaybitbinayũ kay. Itaybit cĩcã ip o'e Jesus waram o'jetait iam, ade em ixe o'jojojo buye. — Deus soat kukukan je'e — io'e ixe cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Awerom pima Jesus o'jekawẽn g̃uto ceweju ip. — Epewatwat g̃u juy Jerusalém ka bewi — Jesus o'e. — Ijop ka ma epesop. Ibiõg̃buk xipacat ajẽmap pit cuy epejowiwi. Webay ixe g̃udot eykay apẽn eywebe juk adi ocece iap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","— Kuy bima João ijodiat mubatisasan osunuy idibi be — io'e cebe ip. — G̃axĩn ma bit Deus biõg̃buk jajẽm eykay. Ibiõg̃buk xipacat jeõm eywebe — io'e Jesus. Jesus imẽn o'jekawẽn jeweju etaybitbinayũ eju. ");
INSERT INTO myu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Waram Jesus emumujuyũ o'je'awero ip. O'jekawẽn ip Jesus eju. — Kariwa — io'e ip. — G̃asũ du ocebadipyũ'in ecejomuy ocekukukan―Judeuyũ kukukan? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","— Eyetaybicap g̃u iboam — io'e Jesus. — Webay acã itaybit. Ixe ja'õbi ixeyũ'in eykukukan iap kabia o'g̃uweg̃ũn. ");
INSERT INTO myu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Imẽnpit eywebe Ibiõg̃buk xipacat õm puje, Deus a'õbacaap kug̃ epekuku. Eya'õcam omuwẽnuwẽn epekuku soat kaka dag̃. Omuwẽnuwẽn epekuku Jerusalém ka watwat pe, Judéia eipi watwat pe dak, Samaria eipi watwat pe dak, wũyatka watwat pe dak — io'e. ");
INSERT INTO myu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iboap muwẽn puje, Deus Jesus o'tujowat jewekay. Ceweju etaybitbinayũ etabutpe o'tujowat. Ag̃ ip o'e cekay. Ceuap o'jojojo ip. Pa'ũm. O'jepa'ũm kabikerereat pe Jesus. Iba'arẽm o'e. ");
INSERT INTO myu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kabi kay apũn pima ag̃okatkayũ oajẽm Jesus eju oekuku'iayũ kay―xepxepayũ―cesayrucayũ. ");
INSERT INTO myu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","— Tapupuyũ — io'e ip. — Apẽnpuye dak eyju jeapũnapũn kabi kay? — io'e ip Jesus emumujuyũ be―Galiléia eipi bewiayũ be. — Deus Jesus o'tujowat eyxewi. O'g̃uyu kabi kay. Ceuap epejojojo. Jeuap puxim waram je'pit — io'e ag̃okatkayũ. ");
INSERT INTO myu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jesus emumujuyũ o'jepit Jerusalém ka kay. O'jẽm ip co'a bewi―Oliveira dip'a bewi. Oliveira dip'a Jerusalém ka tẽg̃ ma o'yanuy―pũg̃ kilometro ma. ");
INSERT INTO myu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","O'jeawero ip uk'a be―umat'abi be―Jerusalém ka be―kuy bima osodop ip iat'a be. Ibũrũ ma ibutet osodop ip; Pedro i, João i, Tiago i, André i, Filipe i, Tomé i, Bartolomeu i, Mateus i, wara'at Tiago i, Simão i, Judas i. Tiago Alfeu ipot osunuy. Judas Tiago ipot osunuy. Simão jeipi kay jĩjãat osunuy. Ibũrũ ma awerom ip osodop umat'abi be. ");
INSERT INTO myu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pũg̃ tag̃ ma ip jewag̃uyg̃uy osodop. Soat em je'aweroro'uk osodop ip Deus eju kawẽn ãm. Aoyũ dak je'aweroro'uk ip osodop ceweju ip. Maria cexe ip osunuy―Jesus xi. Jesus kitpitpiyũ dak je'aweroro'uk ip osodop ceweju ip. ");
INSERT INTO myu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Awerom pima, Pedro o'ãy itabucayũ xewi. Ade jĩjã ip osodop Jesus kay itabucayũ. 120 osodop ip. Pedro o'jekawẽn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Okitpitpiyũ, eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. — Kuyje Davi apẽn Judas kuka o'e iap o'g̃uwẽn Deus biõg̃buk a'õbi. Ixe Davi ekawẽn ibararak opop Deus ekawẽn tup pe. Ixe Judas Jesus pu ojuyayũ o'tujowat cekay. G̃asũ o'jebapuk ibiat tup ekawẽn tag̃―kuyatup ekawẽn tag̃ — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","— Jesus ixe Judas o'taẽ kapik am oceweju — io'e. — Oceweju juk adi oekuku. ");
INSERT INTO myu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Imẽnpit ixe Judas Jesus o'g̃ũm itakomaayũ be. Dinheiro o'jat Jesus ũmap teim — io'e Pedro. — Ipi o'jat ixem dinheirom. Ig̃o eipi be o'jewag̃obua. Yabitorom o'at. O'je'ukedeg̃. O'tũnpujẽm ijebit pewi. Oe'ũ — io'e Pedro cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","— Soat Jerusalém ka watwat ce'ũap awẽg̃ o'yawẽg̃tobuxik ip. Imẽnpuye ibo eipi butet Aceldama i o'subuteta ip ja'õm. (Aceldama ag̃okatkat toy o'toyjẽmiap ka iape wuya'õm). ");
INSERT INTO myu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Imẽn e'em Salmo dup: Tuk'a juy yabibug̃, i. Ka'ũma ma juy je'e ya be, i. Wara'at tup imẽn e'em: Wara'at cuy jeenuy tũyap pe kapik am ixe dieg̃, i — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Imẽnpuye wara'at'in cuy ataẽ oceweju ceku am ixe'ũm tieg̃. Wara'at'in cuy ataẽ wuykukukat Jesus waram o'jetait iap muwẽn ãm soat pe — io'e. — Jesus ocexe bima oceweju juk adi oekuku'iayũ'in cuy ataẽ — io'e. — João'ũm imubatisasan pima oceweju juk adi oekuku'iayũ'in cuy ataẽ―Deus Jesus muyu buje kabi kay oceweju oekuku'iayũ'in — io'e. — Ibiat cuy ataẽ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","— José juy ataẽ — io'e pũg̃pũg̃ayũ. — Barsabás cuy ataẽ―cũg̃ cĩcãat — io'e warara'acayũ Pedro be. — Matias cuy ataẽ — io'e ip warara'acayũ bit. ");
INSERT INTO myu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","G̃ebuje o'jekawẽn ip Deus eju. — Bay — io'e ip. — Etaybit apẽn oceju jewag̃uyg̃uy iam. ");
INSERT INTO myu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas'ũm oibu'un oceweju jeku am — io'e ip. — Oibu'un ekpot eju am. Jekapikap o'suiwat jejuap ka kay jeju am — io'e ip. — Abu g̃u xe'e ocetaẽ oceweju jeku am Judas'ũm tieg̃? Barsabás tu ocetaẽ? Matias g̃u xe'e? — io'e ip Deus pe. Imẽn o'jekawẽn ip Deus eju. ");
INSERT INTO myu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","G̃ebuje yabararukat'a o'yaxik ip pũg̃'in ip taẽ ãm. Imẽn itaybit ip o'e abu Deus o'taẽ iam. Imẽn Matias o'taẽ ip jeweju ip jeku am Judas'ũm tieg̃. Ixe Matias onze beayũ eju oekuku g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Deus biõg̃buk o'kop Jesus eju etaybitbinayũ kay. Pentecostes bima o'kop. Pentecostes i kabia butet osodop. Pentecostes ajẽm puje pũg̃ pe ma ip osodop awerom itabucayũ―Jesus eju etaybitbinayũ dak―doze beayũ. Judeuyũ petata'uk osodop ip Pentecostes kabia be. ");
INSERT INTO myu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Deus biõg̃buk imẽn o'kop cekay ip. Kabi bewiata'õ o'ya'ĩjojo ip. Kabidoxixi a'õ buxim o'e kabi bewiat'a'õ. Kaxikxik'i osodop ip uk'a be. Soat ip o'ya'ĩjojo. ");
INSERT INTO myu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Daxae jo'iat o'jebapuk cekay ip. Daxae jo'iat o'kop ceparakpe ip―soat parakpe. Soat pe o'sueabik cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Deus biõg̃buk imẽn oõm soat pe cebe ip. G̃ebuje itabucayũ warara'acat'a'õm ma o'jekawẽn. Deus biõg̃buk a'õbi o'jekawẽn ip warara'acat a'õm. ");
INSERT INTO myu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ade powatwat Jerusalém ka be osodop ip―soat kaka dag̃wiayũ. Judeuyũ etabucap puxim itabut ip osodop Deus kay. ");
INSERT INTO myu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ixeyũ a'õm ekawẽn co buje, soat ip o'ju cekay ip ya'ĩjom powatwat. Yag̃uy'ũm ip o'e itabucayũ soat a'õm kawẽnwẽn puye. Soat ip ja'õ ma o'ya'ĩjojo. ");
INSERT INTO myu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Imẽnpuye yag̃uy'ũm ip o'e. — Eya'õpicũg̃cũg̃ cuy epesop — io'e ip. — Soat ijoyũ Galiléia eipi watwat ma — io'e ip. — Imẽnpit ja'õm g̃u kawẽnwẽn ip―wuya'õm acã — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","— Apẽntak soat wuyju wuya'ĩjojom―bekin pima wuyju kawẽnwẽnap a'ĩjojom? — io'e ip. — Wuya'õm ma ip kawẽnwẽn! — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","— Pártia eipi bewi ajot peta be, Média eipi bewi dak, Elão eipi bewi dak — io'e ip. — Mesopotâmia eipi bewi dak ajot, Judéia eipi bewi dak, Capadócia eipi bewi dak, Ponto eipi bewi dak, Ásia eipi bewi dak, ");
INSERT INTO myu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frígia eipi bewi dak, Panfília eipi bewi dak, Egito eipi bewi dak, Líbia eipi bewi dak, Cirene ka bewi dak, Roma ka bewi dak — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","— Pũg̃pũg̃ wuy'in Judeuyũ ma. Warara'acayũ ka'ũma. Ixeyũ etabucap co'i wuyju dak wuyetabut Deus kay — io'e ip. — Creta eipi bewi dak ajot, Arábia eipi bewi dak. “Deus soat podi ma ya'õbaca,” i'e'em ip itabucayũ wuywebe. “Soat podi ma xipat ixe,” i'e'em ip wuywebe. Wuya'õm ma kawẽnwẽn ip — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Imẽn o'e ip yag̃uy'ũm puye. Yag̃uybabi'ũm'ũm o'e ip. — Apẽnpuye wuya'õm ip kawẽnwẽn? Ajom Deus wuymukũyjo ojuy? — io'e pũg̃pũg̃ ce'in ip. ");
INSERT INTO myu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","— Ika'o'o ip — io'e ip napa ma warara'acayũ bit Jesus eju etaybitbinayũ waywayway am. ");
INSERT INTO myu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kirik'ãy. Pedro o'ãy jekawen am je'awero'ibiyũ be. O'ãy onze beayũ eju. O'jekawẽn ya'õberen adeayũ be. — Tapupuyũ Judeuyũ, Jerusalém ka wat, eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","— Oceka'o'o g̃u. Tũybe ip ika'o'o iãn eyju e'em. Kaxicug̃ mabuk 9 horas acã. Kabiam pit oceju uva'abidi kõnkõn g̃u. Õn jeymukũyjo apẽnpuye oceju eya'õm ma kawẽnwẽn iam — io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","— Apẽn Joel juk adi o'e'e iap tag̃ oceju eya'õm kawẽnwẽn g̃asũ. Soat a'õm kawẽnwẽn. Imẽn e'em Joel emudupmubararaktup―Deus ekawẽn muwẽnuwẽn'ukat emudupmubararaktup: ");
INSERT INTO myu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ipi'ũm awap obiõg̃buk og̃uju eykay,” i'e'em Deus, io'e Joel. “Soat pe og̃uõm,” i'e'em, io'e. “Enaxeg̃ebitbit wekawẽn g̃uwẽn,” i'e'em, io'e. “Ag̃okatkayũ og̃uyxeyxey wekawẽn,” i'e'em, io'e. “Aypapayũ dak og̃uyxeyxey,” i'e'em, io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","“Obiõg̃buk og̃uju obuywatwat'ukayũ kay―ag̃okatkayũ kay, aoyũ kay dak,” i'e'em Deus, io'e Joel. “Imẽnpuye wekawẽn g̃uwẽn ip,” i'e'em, io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","“I'e ba'oreat og̃ubapuk kabi be. Og̃ubapuk ipi juayũ ag̃uy mubabi'ũm ãm,” i'e'em, io'e. “Soat podi ma wa'õbaca iap og̃ubapuk adeayũ be,” i'e'em, io'e. “Doy jedoyebapuk. Daxa dak je'bapuk. Daxidig̃ tak jedig̃ebapuk,” i'e'em, io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kaxiepiat kabiok je'e. Kaxi ipakpuk je'e doy-buxim. Imẽn je'bapuk wuykukukat ajẽm awap, io'e Joel. Ixe ajẽmap kabia idip cĩcã je'e. Yajẽm puje ixe soat kukukan je'e―ipi juacayũ kukukan, io'e Joel. ");
INSERT INTO myu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","“Kariwa, odaxijom cuy ece” i'e'e'ukat ma Deus idaxijo, io'e Joel — io'e Pedro. — Imẽn Joel o'e Deus a'õbi — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","— Israel naxeg̃ebitbit — io'e. — Eya'õpicũg̃cũg̃ cuy wekawẽn kay — io'e. — Jesus cuy og̃uwẽn eywebe―Nazaré ka bewiat. Ixe Jesus Deus a'õbi wuywebe i'e ba'oreat mubapukpug̃ oeku. Wuymucoatcoanap mubapukpug̃ oeku. Deus a'õbacaap mubapukpug̃ oeku. Eyetaybit iboam eyetabutpe ixe oeku buye — io'e Pedro adeayũ be. ");
INSERT INTO myu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","— Ikẽrẽat mujurũg̃rũg̃'ukayũ Jesus o'jat. O'jat ip apẽn Deus ibikuy osunuy iap tag̃. Eyju ma ikẽrẽat mujurũg̃rũg̃'ukayũ be Jesus epesubamupayaat korosa be ce'ũ ãm―Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Deus pit Jesus o'g̃utait waram. Ce'ũ buje Jesus o'g̃uyu ce'ũap pewi ibun topap puxim — io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","— Deus a'õbi Davi Jesus o'g̃uwẽn wuydobuyũ'ũm'ũm pe kuyje — io'e. — Imẽn Davi o'e: Okukukat, oparara g̃u, soat em ẽn ag̃ okay ibuye, soat em ẽn obuywatwan ibuye dak, i. ");
INSERT INTO myu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ocokcok cĩcã ma õn e'em, io'e. Soat em “Deus, ẽn xipat cĩcã oxe” i õn e'em, i. Wetaybit soat em exe og̃uy iam, i. We'ũ buje dak a'g̃u og̃uy ewiwim, i. ");
INSERT INTO myu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Okukukat, obiõg̃buk esuiwat g̃u ce'ũ'ũayũ dopap pe, i. Wetabut cĩcã iboap kay, i. Ẽn ojebit iwan g̃u ierepap puxim, õn xipat exe buye―õn ekpot puye dak, i. ");
INSERT INTO myu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Okukukat, waram adi ẽn omutait, i. Ẽn ma'g̃u omukũyjo soat em wetabẽg̃ og̃uy exe iam, i. Omucokcokcog̃ ece'e soat em exe og̃uy buye, io'e―o'e Davi Deus a'õbi — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","— Tapupuyũ, ibapug̃ ma juy Davi og̃uwẽn eywebe — io'e Pedro jebadipyũ be. — Kuyje ma wuy'ajore'ũm oe'ũ―ya'õbuyxiat'ũm oe'ũ. O'jomõg̃ ip witabikũy be. G̃asũ dak puk ixe'ũm mõg̃apkũy omuy ma. ");
INSERT INTO myu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ixe Deus ekawẽn muwẽnuwẽn'ukat osunuy. “Enaxeg̃ebit wemunaẽm je'e,” io'e Deus cebe. “Wemunaẽ soat kukukan je'e―Israel eipi watwat kukukan,” io'e Deus cebe. Soat em Davi iboap ekawẽn kay g̃ebum osunuy. ");
INSERT INTO myu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Itaybit osunuy Deus jemunaẽ g̃utait ce'ũap tomukadi iam. Imẽn Cristo mutaicap o'g̃uwẽn imutait awap. Imẽn o'e: Deus jemunaẽ biõg̃buk o'suiwat g̃u ce'ũ'ũayũ dopap pe, i. Ijebit oierep g̃u, i — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","— Deus ixe Jesus waram o'g̃utait ce'ũap tomukadi — io'e Pedro. — Waram cetait puje ocejojojo. Imẽnpuye oceju iboap muwẽnuwẽn eywebe — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","— Deus Jesus o'g̃uyu kabi kay―jenuyap kay. Deus xe Jesus omuy g̃asũ. Soat kukukan Deus eju. Deus co'i ya'õbaca. “Obiõg̃buk og̃uõm itabucayũ be,” io'e Deus Jesus pe. G̃asũ Jesus Ibiõg̃buk xipacat o'g̃udot ijodi apẽn Deus cuk adi o'e'e iap tag̃ — io'e Pedro. — Ixe a'õbi oceju eya'õm ma kawẽnwẽn. Imẽnpuye eyju eya'ĩjojom g̃asũ — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","— Davi'ũm jebit g̃u o'jeu kabi kay ce'ũ buje. Imẽnpuye Davi o'e: “Oxe juy eg̃uy,” io'e Deus wuykukukat pe, i. ");
INSERT INTO myu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“G̃asũ bit ekay itakomaayũ a'õbacaap og̃u'ũm,” io'e, i. “Kũyjobin jedop ip a'õ kay,” io'e Deus, io'e Davi ajore wuydobuyũ'ũm'ũm pe — io'e Pedro. — Davi o'jewemuwẽn g̃u―Jesus acã o'g̃uwẽnuwẽn — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","— Wa'õ kay bit cuy eya'õpicũg̃cũg̃ epesop — io'e. — Eyju ma ocekukukat Jesus epesubamupayaat korosa be ce'ũ ãm, Israel naxeg̃ebitbit ma'g̃u eyju. Deus pit ixe o'jomuy wuykukukan. Deus ixe o'taẽ soat taxijo am―wuydaxijo am. Icẽmãn õn e'em eywebe — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iboap co buje ig̃uycũg̃cũg̃ cĩcã ip o'e. — Tapupuyũ, apẽn oce'e g̃asũ? — io'e ip Pedroyũ be―Jesus emumujuyũ be. ");
INSERT INTO myu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","— Eyg̃uycũg̃cũg̃ cuy epe'e ikẽrẽat kug̃ puye — io'e. — Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere — io'e Pedro. — Jewemubatisasaan cuy epesop “G̃asu bit Jesus Cristo ebekitkiyũ oceju” i'e am soat pe — io'e. — Imẽn cuy epe'e Deus pe ikẽrẽat'uk am eywebewi. Imẽn ey'e buje Ibiõg̃buk xipacat jeõm eywebe―Deus emumudot — io'e. ");
INSERT INTO myu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","— “Obiõg̃buk muõm pin õn eywebe,” io'e wuykukukat Deus kuy bima — io'e. — “Obiõg̃buk og̃uõm eywebe, eyebekitkiyũ be dak, eybadip'ũmayũ be dak―soat wemunomuwãyũ be,” io'e Deus — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro imẽn ip o'yawẽwẽ. — G̃asũacat ikẽrẽat mujurũg̃rũg̃ cĩcã — io'e. — Imẽnpuye Deus xe g̃u ip jeedop ce'ũ buje. Eyju bit ixeyũ ekukuap puxim g̃u juy epeku — io'e. — Wũy g̃u juy epesop Deus wi eye'ũ buje — io'e Pedro. Imẽn Pedro ip o'yawẽwẽ. ");
INSERT INTO myu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Imẽneju adeayũ itabut o'e Jesus kay, Pedro Jesus o'g̃uwẽn puye. Tak g̃u ip oitabun―3000 beayũ. O'jewemubatisasan ip. Jesus a'õkayayũ eju ip oekuku g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Itabun'isuayũ mutaybitbin'uk ip osodop Jesus a'õkayayũ. Jewemukũyjojo'uk ip osodop. Jeburerexi osodop ip itabucayũ. Jeweweju ip jekõnkõn'uk osodop. Jekawẽnwẽn'uk ip osodop Deus eju. Pão'a o'o'uk osodop ip Jesus e'ũap kay g̃ebum am. ");
INSERT INTO myu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesus emumujuyũ Deus a'õbacaap mubapukpug̃ oekukuku soat etabut pe. Wuymucoatcoanap mubapukpug̃ ip oekukuku. Imẽnpuye adeayũ itabẽg̃bẽg̃ o'e ip ijojom — Deus acã ya'õbaca — i'e'em. ");
INSERT INTO myu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Soat jeburerexi ip osodop Jesus kay itabucayũ. Jebubut mu'ẽ'ẽ'uk osodop ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ka'ũma ma tacup o'e jebure be. Jebubut taidada'uk ip osodop dinheiro bu am, jeipi dak. Ixe dinheiro ũmũm'uk ip osodop tadaybocayũ be―ibubut'ũmayũ be. ");
INSERT INTO myu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Soat kabia Deus eju kawẽnwẽnap'a be je'aweroro'uk ip osodop―yabog̃at'a be. Jeweweju ip jekõnkõn'uk osodop jeduk'a be. Awerom jekõnkõn'uk ip osodop jebureyũ eju. Imẽneju icokcok cĩcã ip osodop. Ka'ũma ma jewexe ya'õca osunuy. Jewekay g̃u g̃ebum osodop ip―jebure kay acã. ");
INSERT INTO myu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","— Ẽn xipat cĩcã ocewebe — i'e'e'uk ip osodop Deus pe. Soat itabut'ũmayũ xe cũg̃ ma ip oekukuku. Soat kabia Deus warara'acayũ o'g̃utabun Jesus kay. Ixeyũ dak wara'acayũ itabucayũ burem o'e. ");
INSERT INTO myu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro o'ju Deus eju kawẽnwẽnap'a be―yabog̃at'a be. João eju o'ju. Katpujesu ip o'ju. Ixe ehora bima Judeuyũ kawẽnwẽn'uk ip osodop Deus eju ig̃o'a be. ");
INSERT INTO myu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ag̃okatkat iboce osunuy―taojereat. Jekap'isum piap ma taojere osunuy. Soat kabia ibureyũ tujowatwat'uk ip osodop ig̃o'a exĩntabi be. Xĩntabi butet Idipat i osunuy. Xĩntabi be taojereat dinheiro ojuyjuy'uk osunuy ig̃o'a be õmõmayũ be. ");
INSERT INTO myu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ixe taojereat Pedroyũ o'jojojo. Ig̃o'a be õm pima o'jojojo ip. — Dinheiro'in — io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedroyũ o'jeak cĩcã cekay. — Ak'i juy ece ocekay — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Taojereat o'jeak cĩcã cekay ip. Tũybe dinheiro ũm ip owebe iãn o'e. ");
INSERT INTO myu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro o'jekawẽn cebe. — Dinheiro kug̃ g̃u õn — io'e. — Okukukat pit ja'õbacaap ũmũm owebe. Ixe a'õbi jemu'ada õn. Edaodip ece'e Jesus a'õbi―Nazaré ka bewiat a'õbi. E'ãy — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","G̃ebuje Pedro taojereat pu o'subuixik iba'at kadi. O'g̃u'ãy. Dao ma ikag̃obidip o'e. Sui dak suidip o'e. ");
INSERT INTO myu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ixe taojere osunuy'ibit o'jejoro. Icokcok o'e jedaodip puye. O'jexĩg̃xĩg̃. Oõm Deus eju kawẽnwẽnap'a be Pedroyũ eju. O'jecũg̃cũg̃ ig̃o'a be. Jejorojorom o'e jecokcokap pibun. — Ẽn xipat cĩcã — i'e'em Deus pe o'jejore. — Odaomudim ẽn — i'e'em. ");
INSERT INTO myu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Soat ig̃o'a beayũ taojere tũibit o'jojojo ip cũg̃cũg̃ pima. Deus pe “Ẽn xipat cĩcã” i'e'em pima, o'jojojo ip. O'jekawẽn ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","— Ixe bit mo a'g̃u taojere osunuy — io'e ip. — Ixe bit xik'i mo a'g̃u nuynuy ijop'a exĩntabi be―Idipat pe. Ixe bit mo a'g̃u dinheiro ojuyjuy'uk osunuy — io'e ip. — Apẽnpuye dak ixe xipat o'jexĩg̃xĩg̃? — io'e ip. Taojere tũibit mu'adaap tobuxik puje itabẽg̃bẽg̃ o'e ip ijojom. Taojere tũibit ibu'u jĩjã o'e Pedroyũ nomu eperem. ");
INSERT INTO myu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Soat ig̃o'a beayũ dak o'jedau ebapũg̃ayũ kay―Pedroyũ kay, taojere tũibit kay dak. — Ak'i! — io'e ip. — Pedroyũ taojereat o'taomudim — io'e ip jewewebe. Pedroyũ Deus eju kawẽnwẽnap'a ekorara be osodop ip―yabog̃at'a ekorara be. Ixe korara butet Salomão ekorara i osunuy. ");
INSERT INTO myu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Adeayũ jo buje, Pedro o'jekawẽn cebe ip, Israel naxeg̃ebitbiyũ be. — Tapupuyũ, wekawẽn kay eya'õpicũg̃cũg̃ cuy epesop — io'e. — Apẽnpuye eyju dak eyetabẽg̃bẽg̃ ocejojom? “Ite ag̃okatkat taojereat o'taomudim ya'õbaca jĩjã buye, cũg̃ ma Deus xe buye,” i te'e ma eyju e'em. Oca'õbi g̃u o'je'ada―Jesus a'õbi acã — io'e. ");
INSERT INTO myu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","— Ixe Jesus soat em ma kũyjobit Deus a'õ kay. “Ka'ũmg̃u ixe jo'iat xipacat” i'e'em Deus Jesus muwẽnuwẽn. Wuyetabut ixe Deus kay. Wuy'ajojoyũ'ũm'ũm tak itabut osodop ip cekay―Abraão'ũm, Isaque'ũm tak, Jacó'ũm tak. Eyju ma a'g̃u ixe Jesus epeg̃ũm cekay itakomaayũ be yaoka am. Pilatos ma o'e “Jesus oyaoka g̃u õn pit,” i. “Imujẽm õn eywebe yaokaap puxim,” io'e. Eyju bit “Ixe juy eg̃ujẽm g̃u,” i mo a'g̃u epe'e iecug̃ap pe―Pilatos pe. “Xipat g̃u teku,” i mo a'g̃u epe'e cebe. Jesus mo a'g̃u epejomuymuy jĩjã. ");
INSERT INTO myu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ixe Jesus Deus bikuyap tag̃ acã oekukuku. Ikẽrẽat kug̃ g̃u osunuy Deus xe. Eyxe bit ikẽrẽat kug̃. “Ixe juy eyaokaat,” i mo a'g̃u epe'e Pilatos pe. Wara'acat o'yaoka'iat mujẽm ojuy epesop daomũnmũnap'a bewi. ");
INSERT INTO myu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wuymutaicit'ukat pit mo a'g̃u epeyaokaat―wuymuisusun'ukat. Deus pit ixe o'g̃utait waram. Jesus ocejojojo waram cetait puje. Imẽnpuye oceju waram cetaicap muwẽnuwẽn eywebe. ");
INSERT INTO myu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ite taojere osunuyiat cocom eyju. Eyetaybit cĩcã ixem. Jesus a'õbi oceju ocetaomudim. Soat etabutpe ocetaomudim Jesus kay ocetabut puye — io'e. ");
INSERT INTO myu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","— Obadipyũ, wa'õ kay eya'õpicũg̃cũg̃ cuy epesop — io'e. — Eyju mo a'g̃u Jesus epeyaokaat eyetaybit'ũm puye. Wuyeipi kukukayũ dak itaybit g̃u osodop ip. Eyju mo a'g̃u eyetaybit g̃u ikẽrẽ jĩjã Jesus aokaam iam. Wetaybit iboam. ");
INSERT INTO myu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Imẽnpit kuyje “Deus emunaẽ juy ipiat supi'ajo,” io'e'e'e Deus ekawẽn muwẽnuwẽn'ukayũ. Imẽn cuk adi o'e ip Deus a'õbi itaybit g̃u ma'g̃u ip — io'e. — G̃asu bit kuy Jesus ipiat o'supi'ajo apẽn cuk adi o'e'e ip iap tag̃. ");
INSERT INTO myu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","G̃asũ bit eyg̃uycũg̃cũg̃ cuy epesop ikẽrẽat kug̃ puye. Ikẽrẽat mujurũg̃rũg̃ap cuy epeyepere Deus pe ikẽrẽat uk am eywebewi — Pedro o'e. — Eywebe ikẽrẽat mujurũg̃rũg̃ap epere buje, Deus ikẽrẽat ju'uk eywebewi. Ixe jeydaxijo. ");
INSERT INTO myu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wuybipuruk'ũmap puxim eycokcog̃ epesop Deus pe eydaxijo buje. G̃uyjom Deus waram Jesus g̃udot ijodi―jemunaẽ g̃udot―wuydaxijojo'ukat g̃udot. ");
INSERT INTO myu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Deus soat g̃uisun,” i juk adi o'e'e Deus ekawẽn muwẽnuwẽn'ukayũ kuyje―ikẽrẽat kug̃'ũmayũ. Deus soat g̃uisun. Imuisun'ũm pima Jesus kabi be mabuk jeenuy — io'e. ");
INSERT INTO myu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","— Kuyje Moisés imẽn o'e: Deus wuybadipyũ'in g̃uju eykay, i. Ixe Deus ekawẽn g̃uwẽn eywebe, i. Omudocap puxim ixe ag̃okatkat g̃udot, i. Eya'õpicũg̃cũg̃ cuy epesop soat cekawẽn kay, i. Ixe a'õ dag̃ cuy epeku, i. ");
INSERT INTO myu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Deus ipiat'supi'ajoat ixe a'õkay'ũmayũ be, i. Deus ebekitkiyũ wi wũy ma jeedop ip ce'ũ buje, i. Imẽn Moisés o'jekawẽn kuyje — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","— “Deus emunaẽ omuyku―ocebodi ma ya'õbuyxiat,” i juk adi o'e'e ip soat Deus ekawẽn muwẽnuwẽn'ukayũ. Samuel imẽn o'e'e tomujuayũ dak. ");
INSERT INTO myu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Deus o'e Abraão be “Xipacat og̃ũm soat ipi juacat pe, enaxeg̃ebitbit cũg̃ ma oxe buye,” i. Deus imẽn jekawẽn o'g̃uwẽn eydobuyũ'ũm'ũm pe ã g̃u―eywebe dak. Deus je'e eywebe apẽn cuk adi o'e'e jekawẽn muwẽnuwẽn'ukayũ be iap tag̃ — io'e. ");
INSERT INTO myu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","— G̃ebuje Deus jekpot o'g̃udot eykay―ja'õ kay kũyjobicat o'g̃udot. Ibikuy osunuy eywebe ikẽrẽat mujurũg̃rũg̃ap epere am. Ibikuy osunuy xipacat ũm ãm eywebe. Imẽneju jekpot o'g̃udot eykay — io'e. Pedro imẽn Israel naxeg̃ebitbit o'g̃ukũyjo. ");
INSERT INTO myu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Deus eju kawẽnwẽnap'a beayũ mukũyjojom pima, Judeuyũ epaĩyũ oajẽm Pedroyũ kay. Ig̃o'a wiwi'ukayũ kukat tak oajẽm cekay ip, Saduceuyũ dak. ");
INSERT INTO myu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedroyũ kawẽnwẽn mabuk o'e ig̃o'a beayũ be. — Wuye'ũ buje waram acejetait Jesus waram o'jetait je'ũap tomukadi buye — io'e ip cebe ip. Itakoma ip o'e Pedroyũ kay iboam ig̃o'a beayũ mukũyjojom puye. ");
INSERT INTO myu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Imẽnpuye o'jat ip. Daomũnmũnap'a be ip o'g̃uõm. Ixe exima be jeperem ojuy ip daomũnmũnap'a be, kuy katpuje jĩjã buye. ");
INSERT INTO myu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Cekawẽn cocoayũ dak itabut o'e ip Jesus kay. Ade jĩjã ip itabut o'e. 5000 be ag̃okatkayũ oitabun. ");
INSERT INTO myu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kuyaje o'je'awero ip Jerusalém ka be ya'õbuyxiayũ, Judeuyũ kukukayũ, Moisés ekawẽn imutaybitbin'ukayũ dak. Jewawẽwẽ'ukayũ yobog̃ayũ ip osodop. ");
INSERT INTO myu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ana tak oajẽm. Ixe Judeuyũ epaĩyũ kukukat osunuy. Caifás tak oajẽm, Alexandre dak, João dak. Warara'acayũ dak oajẽm paĩyũ kukukat badipyũ. Soat ip o'je'awero. ");
INSERT INTO myu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedroyũ o'tojocat ip jewekay. — Abu-a'õbi taojere tũibit epeg̃u'ada? — io'e ip Pedroyũ be. — Abu-a'õbacaam epeg̃u'ada? — io'e ip cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","G̃ebuje Pedro o'jede jewawẽwẽ'ukayũ yobog̃ayũ be. Deus biõg̃buk cebe jĩjã osunuy. Imẽnpuye ya'õbacam o'jede cebe ip―Judeuyũ kukukayũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","— Tapupuyũ — io'e. — “Abu-a'õbi taojere tũibit epeg̃u'ada?” i eyju e'em ocewebe, “Apẽntak ixe epeg̃u'ada?” i dak — io'e. ");
INSERT INTO myu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","— Eyetaybin cuy epesop Jesus Cristo a'õbi o'je'ada iam―Nazaré ka bewiat o'je'ada iam. Ixe xipat omuy eyetabutpe g̃asũ, Jesus Cristo a'õbi o'je'ada buye. Eyju ma juk ixe Jesus epesubamupayaat korosa be ce'ũ ãm. Deus pit ixe o'g̃utait waram. O'g̃uyu ce'ũ'ũayũ dopap pewi. Jesus a'õbi ma ite taojere tũibit xipat cũg̃'i ijoce g̃asũ. ");
INSERT INTO myu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Imẽn e'em Deus ekawẽntup pe: Uk'a muymuy'ukayũ ite'a kay g̃u osodop ip―wita'a kay g̃u, i. Ite'a bit uk'a muycemap'am o'e, i. Jesus muwẽnuwẽn ig̃odup — io'e Pedro. — Uk'a muymuy'ukayũ ite'a kay'ũmap puxim eyju dak Jesus kay g̃u — io'e. ");
INSERT INTO myu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","— Deus Jesus acã o'g̃udot wuydaxijo am. Ka'ũmg̃u wara'at wuydaxijojo'ukat soat kaka dag̃―Jesus acã — Pedro o'e. Pedro imẽn Judeuyũ kukukayũ o'g̃ukũyjojo―jewawẽwẽ'ukayũ yobog̃ayũ. ");
INSERT INTO myu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ja'õca o'jede ip Pedroyũ. Iparara g̃u ip o'e Judeuyũ kukukayũ buxim. Ya'õca o'e ip. Imẽnpuye Judeuyũ kukayũ itabẽg̃bẽg̃ o'e ip ijojom. — Apẽn tak iteyũ oitaybitbin? — io'e ip. — Itaybit g̃u ip apẽn Deus ekawẽntup e'em iam. Ya'õbuyxi g̃u ip. Apẽnpuye dak iteyũ xepxepayũ iparara g̃u wuybuxim? — io'e ip. Itaybit o'e ip Jesus eju oekuku ip iam. ");
INSERT INTO myu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Imẽntak taojere tũibit ceparakpe ip cũg̃'i osunuy. Imẽnpuye Pedroyũ imuymuy ba'ore o'e ip cebe. ");
INSERT INTO myu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pedroyũ o'g̃ujẽm ip jexewi. — Epejẽm cuy ijocewi g̃asũ bit — io'e ip Pedroyũ be. Imujẽm puje ip o'jewawẽ ip jeweweju. ");
INSERT INTO myu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Apẽntak ace'e iteyũ ag̃okatkayũ be? — io'e ip jewewebe. — Icẽmãn wuywebe i'e ba'oreat o'g̃ubapuk ip — io'e ip. — Soat Jerusalém ka watwat itaybit taojere tũibit o'g̃u'ada ip iam. “O'g̃u'ada g̃u ip” i'e ba'ore wuywebe. ");
INSERT INTO myu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jesus awẽg̃ jawẽg̃epõg̃põg̃põg̃ je'e soat ka dag̃ — io'e ip. — Apẽntak ace'e yawẽg̃mupõg̃põg̃'ũm ãm? — io'e ip jewewebe. — “Jesus cuy epeg̃uwẽn g̃u warara'acat pe,” i juy ace cebe ip wuya'õpurug̃ — io'e ip. — “Waram warara'acayũ be Jesus muwẽn puje, ipiat cuy ocesupi'ajoat eywebe,” i juy ace cebe ip — io'e ip jewewebe. ");
INSERT INTO myu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","G̃ebuje waram Pedroyũ o'tojocat ip jewekay. Ya'õpurug̃ o'jekawẽn ip ceweju ip. — Jesus cuy epeg̃uwẽn g̃u warara'acat pe — io'e ip. — Waram cuy epeg̃uwẽn g̃u cekawẽn — io'e ip Pedroyũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","— Apẽntak cedag̃ eyxe? — io'e Pedroyũ bit cebe ip. — Eya'õ kay du oce'e? Deus a'õ kay g̃u xe'e? Apẽn g̃u cedag̃ eyxe? — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","— Mũg̃ g̃u juy ocesop. Jesus cuy oceg̃uwẽn. Jesus ocejojojo ce'ũap tomukadi — io'e. — Jesus emumutaybitbinam cuk adi ocejekũyjojo — io'e. — Imẽnpuye cedag̃ g̃u ocewebe imuwẽn'ũm ãm warara'acat pe. Mũg̃ g̃u ocesop. Ixe juy ag̃uwẽn — io'e Pedroyũ. ");
INSERT INTO myu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Taojere tũibit ade koato osunuy―40 koato. Imẽnpuye jewawẽwẽ'ukayũ yobog̃ayũ ipiat o'supi'ajoat g̃u Pedroyũ be. — Ẽn xipat cĩcã — i'e'em o'e ip Deus pe adeayũ, taojere tũibit o'je'ada buye. Imẽnpuye: — Pedroyũ be ipiat'ajoan pima, kuka oitakomãn ocekay adeayũ — io'e ip jewewebe jewawẽwẽ'ukayũ yobog̃ayũ. Pedroyũ bit waram o'g̃ujẽm jexewi ip. — Jesus cuy epeg̃uwẽn g̃u warara'acat pe — io'e ip Pedroyũ be. — Jesus muwẽn puje, ipiat cuy ocesupi'ajoat eywebe — io'e ip waram Pedroyũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedroyũ o'ju jebureyũ kay―itabucayũ kay. Apẽn cuk ya'õpurug̃ paĩyũ kukukayũ o'jekawẽn cebe ip iap o'g̃uwẽn cebe ip, apẽn Judeuyũ kukukayũ o'jekawẽn cebe ip iap tak. ");
INSERT INTO myu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iboap co buje soat Jesus a'õkayayũ o'jekawẽn ip Deus eju. — Ocekukukat — io'e ip. — Soat mug̃ẽat ẽn. Kabi eg̃ug̃ẽ, ipi dak, idibi dak, tibog̃ cĩcãati dak — io'e ip. — Soat kaka dag̃at tak eg̃ug̃ẽ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","— A'õkay osunuy kuyje Davi ajore — io'e ip Deus pe. — A'õmuwẽnuwẽn'uk osunuy. Jekawẽnwẽn'uk osunuy Ibiõg̃buk xipacat a'õbi. Ixe imẽn o'e kuyje: Apẽnpuye dak Judeu'ũmayũ itakoma jĩjã o'e ip? i. Apẽnpuye dak te'e ma ixe aoka ojuy ip osodop? i. ");
INSERT INTO myu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ipi kukukayũ o'je'awero ip soat ka kukukayũ eju―ya'õbuyxiayũ eju, i. O'je'awero ip wuykukukat Cristo aoka am―emunaẽ aoka am, i. Imẽn Davi o'e kuyje — io'e ip Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","— Ibo dup ekawẽn tag̃ g̃asũ dak o'je'awero ip ijopka be — io'e ip. — Herodes o'je'awero Pôncio Pilatos eju, Judeu'ũmayũ dak, Judeuyũ dak — io'e ip Deus pe. — O'je'awero ip ekpot aoka am―Jesus aoka am―soat tag̃ iisuat aoka am―a'õ kay kũyjobicat aoka am―wuydaxijo am emunaẽ aoka am — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","— Ixeyũ Judeu'ũmayũ itaybit g̃u Moisés ekawẽn. Imẽnpit apẽn kuyje juk adi ecece iap tag̃ e'em ip — io'e ip Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","— Bay, ag̃ cuy eg̃uy ocekay — io'e ip Deus pe. — Jewawẽwẽ'ukayũ yobog̃ayũ itakoma jĩjã ocekay — io'e ip. — Ipiatpi'ajoat pin ip ocewebe — io'e ip. — Oceju ebekitkiyũ. Imẽnpuye ocebuywan cuy eg̃uy — io'e ip. — Oca'õmucanucan cuy eg̃uy oceparara'ũm ma kawẽn idipat muwẽn ãm soat ka dag̃ — io'e ip Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","— A'õbacaap cuy eg̃ũm ocewebe a'õbi iwataxipipiayũ mu'ada am — io'e ip. — A'õbacaap cuy eg̃ũm ocewebe i'e ba'oreat mubapuk am soat etabutpe Jesus a'õbi―ekpot a'õbi―soat tag̃ iisuat a'õbi―a'õ kay kũyjobicat a'õbi — io'e ip Deus pe. Imẽn o'jekawẽn ip Deus eju. ");
INSERT INTO myu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Je'aweroroap'a o'jeaexixi ceweju cekawẽn epere buje. Ibiõg̃buk xipacat osodot soat kay ip. Ixe Ibiõg̃buk xipacat oõm soat pe ixeyũ be. Imẽnpuye ip iparara'ũm cĩcã oekuku Deus ekawẽn muwẽnuwẽn soat itaybit'ũmayũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Soat Jesus kay itabucayũ xipan ip o'e jewewekug̃. Ade jĩjã ip osodop. Pũg̃ tag̃ ma ip jewag̃uyg̃uy osodop. — Ijop owebeam acã — i'ũmg̃u o'e ip. Tacup g̃u ip osodop jewewebe. Soat ip jebubut mu'ẽ'ẽ'ẽ'uk osodop. ");
INSERT INTO myu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Soat Jesus emumujuyũ “Ocekukukat Jesus waram o'jetait je'ũap tomukadi,” i'e'e'uk osodop soat pe. Deus xipacat o'g̃ũmg̃ũm soat pe ixeyũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ka'ũmg̃u tadaybocat o'e ceparakpe ip ka'ũmãn ma tacup puye. Ipi kukayũ jeipi o'teida dinheiro bu am. Jeduk'a dak o'teida ip dinheiro bu am. Teiũmũm'uk ip osodop Jesus emumujuyũ be―doze beayũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ixe dinheiro mu'ẽ'ẽ'ẽ'uk ip osodop tadaybotbocayũ be. ");
INSERT INTO myu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","G̃ebuje José dinheiro o'g̃ũm Jesus emumujuyũ be. José jeipi kug̃ osunuy. Jesus emumujuyũ wara'at o'jomõg̃ ibuten. Wara'at ibutet Barnabé i osunuy. Barnabé wuya'õmucanucan'ukat iape. Ixe Levi badip osunuy. Tip'aroro bewiat osunuy―Chipre eipi bewiat. Ixe jeipi kug̃ osunuy. ");
INSERT INTO myu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jeipi o'teida dinheiro bu am. José ma soat ixe edinheiro o'g̃ũm Jesus emumujuyũ be―Pedroyũ be. ");
INSERT INTO myu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananias pit te'e ma Deus mug̃uykuku ojuy o'e. Ixe Jesus kay itabut osunuy. Itayxi butet Safira i osunuy. Dinheiro o'jat. Ananias jeipi o'teida ixe dinheiro bu am. ");
INSERT INTO myu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","I'in o'g̃uxipan jewebeam. Itayxi itaybit o'e i'in o'g̃uxipan jewebeam iam. Soat g̃u jedinheiro o'tujowat Pedroyũ be iũm ãm. I'in ã o'tujowat. — Juku — io'e Pedroyũ be. — Weipi dei. Soat tei — i napa ma o'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","G̃ebuje Pedro ya'õpurug̃ o'jede cebe. — Ananias — io'e. Satanás a'õ kay ẽn g̃asũ — io'e. — Apẽnpuye Deus biõg̃buk mug̃uykuku ojuy ẽn? — io'e. — Apẽnpuye eipi dei'in eg̃uxipan ewebeam? — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","— Koap pit a'g̃u eipin ma osodop. Eipi dei ũmũm pima, xipat kuka o'e. Iũmũm'ũm pima dak xipat kuka o'e — io'e. — Ka'ũma ma o'e ewebe “Eipi juy eteida dinheiro bu am,” i — io'e. — Apẽnpuye dak ikẽrẽat eg̃ujurũg̃? Ocemug̃uykuku ojuy g̃u ẽn. Deus mug̃uykuku ojuy acã ẽn — io'e Pedro. — Ocewebe g̃u ẽn napa e'em―Deus pe acã — io'e Pedro. ");
INSERT INTO myu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias dao ma oe'ũ iboap co buje. Pog̃. Imẽnpuye ce'ũap awẽg̃ tobuxikayũ iparara jĩjã ip o'e Deus mug̃uykukuap puxim. ");
INSERT INTO myu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ag̃okatkayũ oajẽm yaypan'isuayũ. Ananias'ũm o'g̃uekabek ip pag̃õm. O'tujowat ip ibocewi. O'jomõg̃ ip witabikũy be jebabim. ");
INSERT INTO myu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ananias'ũm kot isum Safira oajẽm Pedro kay―ebapũg̃ ehora kap puje―Ananias'ũm tayxibuk. Itaybit g̃u mabuk osunuy jektop'ũm oe'ũ iam. ");
INSERT INTO myu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","— Bũrũnmaku du eipi dei osodop? — Pedro o'e Safira be. — Ektop o'e iat tei jo'i ma du ijop? — io'e. — Hm hm. Ibo jo'in ma ipi dei — io'e napa ma Safira. ");
INSERT INTO myu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","— Apẽnpuye dak mo a'g̃u ikẽrẽat epeg̃ujurũg̃? — Pedro o'e. — Apẽnpuye dak eyju te'e ma mo a'g̃u Deus biõg̃buk mug̃uykuku ojuy? Imẽn mo a'g̃u epeyewawẽ eyeweweju. Ak'i juy ece — io'e. — Witabikũy be ektop'ũm o'jomõg̃'iayũ omuyku ijoce — io'e. — Omuyku ip uk'a exĩntabi be — io'e. — G̃asũ ip jedujowat tak — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","G̃ebuje'isum ma Safira dak oe'ũ. Pog̃. Ce'ũ o'at Pedro i xe. G̃ebuje yaypan'isuayũ oajẽm waram. Ce'ũat o'jojojo ip. O'tujujẽm ip. O'jomõg̃ ip witabikũy be itop'ũm xe. ");
INSERT INTO myu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Soat Jesus kay itabucayũ o'jekũyjo Ananias'ũm e'ũãm, Safira'ũm e'ũãm tak. Warara'acayũ dak ixeyũ'ũm'ũm e'ũãm o'jekũyjo ip. Imẽnpuye iparara jĩjã ip o'e Deus xe ikẽrẽat mujurũg̃ap puxim. Ibu'u o'e ip ikẽrẽat mujurũg̃ ãm. ");
INSERT INTO myu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Soat Jesus emumujuyũ je'aweroro'uk ip osodop Deus eju kawẽnwẽnap'a ekorara be―yabog̃at'a ekorara be. Ijop ekorara butet Salomão ekorara i osunuy. Jesus ebekitkit cũg̃ ma oekuku ip soat xe. Ade jĩjã itabut o'e ip wuykukukat Jesus kay―ag̃okatkayũ, aoyũ dak. Warara'acayũ iparara o'e ip Jesus kay jetabut am. Imẽnpuye o'je'awero g̃u ip Jesus ebekitkit eju. Wuywebe i'e ba'oreat mubapukpug̃ ip oekuku Jesus emumujuyũ. Ajojojo g̃u buk iap mubapukpug̃ oekuku ip Deus a'õbi. Adeayũ etabutpe Deus a'õbacaap mubapukpug̃ ip oekuku. ");
INSERT INTO myu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","G̃ebuje ade iwãtaxipipiayũ o'tujowat ip uk'a ukpibubu dag̃. Iboce iwãtaxipipiayũ o'jomõg̃ ip jexexecap pe, jedipidup ceje dak. Jebureyũ iwãtaxipipiayũ o'jomõg̃ ip Pedro kapap pe. Iwãtaxipipiayũ o'jomõg̃ ip Pedro ekabicuk pe imu'ada am. ");
INSERT INTO myu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ade o'jẽm ip Jerusalém ka tẽg̃atka bewi. Iwãtaxipipiayũ o'tujowat ip Pedro kapap pe. Soat ip o'g̃u'ada'ada. Ibiõg̃buk kẽrẽat kukayũ dak o'tujowat ip. Ibiõg̃buk kẽrẽat o'g̃ujẽmjẽm. Xipat o'e ip―soat. ");
INSERT INTO myu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Judeuyũ epaĩyũ kukukat pit itabutkarey o'e Jesus emumujuyũ kay. Paĩyũ kukukat ejuayũ dak itabutkarey o'e ip cekay ip―Saduceuyũ. Jesus emumujuyũ o'taomũnat ip. ");
INSERT INTO myu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Daomũnmũnap'a be ip o'g̃uõmat. O'g̃uõmat ip ikẽrẽat mujurũg̃rũg̃'ukayũ eju ikẽrẽat mujurũg̃rũg̃ g̃u ma'g̃u ip. ");
INSERT INTO myu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ibocewi Deus ekawẽn tojotjot'ukat oajẽm daomũnmũnap'a be Jesus emumujuyũ kay. Ixima be oajẽm. Xĩntabi o'tomudip'uk―yobog̃at―ipoxiat. Jesus emumujuyũ o'tujujẽm ig̃o'a bewi. Tujujẽm puje o'jekawẽn ceweju ip. ");
INSERT INTO myu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Deus eju kawẽnwẽnap'a be juy epeju―yabog̃at'a be — io'e Jesus emumujuyũ be. — Jesus kayayũ yag̃uyisum jekukum iam cuy ig̃o'a beayũ epeg̃ukũyjo. Soat em Deus xe jeedop ip je'ũ buje iam cuy ip epeg̃ukũyjo. Soan cuy ip epeg̃ukũyjo — io'e cebe ip. — Imẽn cuy oce'e — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Deus tojotjot'ukat ekawẽn co buje Jesus emumujuyũ kawẽn idipat o'g̃uwẽn yabog̃at'a beayũ be. — Jesus kayayũ yag̃uyisum jekukum — io'e ip imukũyjojom. O'ju ip Deus eju kawẽnwẽnap'a be―yabog̃at'a be. Kabia'isum ip o'ju. Kawẽn idipan ip ig̃o'a beayũ o'g̃ukũyjojo. Iboam e'em pima jewawẽwẽ'ukayũ yobog̃ayũ te'e ma Jesus emumujuyũ o'g̃udocat jewekay daomũnmũnap'a bewi. Tũybe daomũnmũnap'a be ma ip opop iãn o'e ip. Paĩyũ kukukat o'je'awero jebureyũ eju. Judeuyũ kukukayũ o'tomuwã je'awero am―Israel naxeg̃ebitbit kukukayũ, aypapayũ dak. Ixeyũ ag̃okatkayũ jewawẽwẽ'ukayũ yobog̃ayũ ip osodop. — Jesus emumujuyũ juy epeg̃ujẽm daomũnmũnap'a bewi — io'e ip te'e ma Deus eju kawẽnwẽnap'a wiwi'ukayũ be. — Epetojot ip ocekay — io'e ip te'e ma. ");
INSERT INTO myu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Deus eju kawẽnwẽnap'a wiwi'ukayũ o'ju daomũnmũnap'a be. Jesus emumujuyũ o'tobuxik g̃u ip. O'jepit ip paĩyũ kukukat pe. Te'e ma o'ju ip Deus eju kawẽnwẽnap'a wiwi'ukayũ. ");
INSERT INTO myu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Daomũnmũnap'a be g̃u ip Jesus emumujuyũ — io'e ip. — Daomũnmũnap'a exĩntabi cem cĩcã ocetobuxik — io'e ip. — Yawiwim mabuk ip osodop yawiwi'ukayũ. Kacũg̃cũg̃'i osodop ip xĩntabixixi weg̃ũn. Ocetomudip'uk. Ka'ũma ma ocetobuxik badi. Jesus emumujuyũ ocetobuxik g̃u — io'e ip ika kukukayũ be―jewawẽwẽ'ukayũ yobog̃ayũ be. ");
INSERT INTO myu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iboap co buje yag̃uy'ũm o'e ip jewawẽwẽ'ukayũ yobog̃ayũ, paĩyũ kukukayũ dak, Deus eju kawẽnwẽnap'a wiwi'ukayũ kukukat tak, warara'acayũ dak paĩyũ yobog̃ayũ. — Apẽn o'jebapuk cebe ip? — io'e ip jewewebe. — Apẽntak ace'e g̃asũ? — io'e ip. — O'jẽm ip iap awẽg̃ jeawẽg̃epõg̃põg̃ soat ka dag̃ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ag̃okatkat tak oajẽm. — Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. — Epetaomũnmũn'iayũ Deus eju kawẽnwẽnap'a be―yabog̃at'a be opop ip. Ig̃o'a beayũ mutaybitbin ip — io'e jewawẽwẽ'ukayũ yobog̃ayũ be. ");
INSERT INTO myu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Deus eju kawẽnwẽnap'a wiwi'ukayũ kukukat o'ju Deus eju kawẽnwẽnap'a be Jesus emumujuyũ kay. O'ju jebekitkit eju―yawiwi'ukayũ eju. Waram g̃uto Jesus emumujuyũ o'taomũn ip. Imẽnpit iparara ip o'e adeayũ be jaokaap puxim. — Oceju warẽmtag̃ iteyũ kug̃ pima, adeayũ kuka ocabug̃bug̃ iteyũ kay jĩjã ip puye — io'e ip jewewebe. Imẽnpuye xipan ip o'jukuk taomũnmũn pima. ");
INSERT INTO myu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Waram Jesus emumujuyũ o'tujowat ip jewawẽwẽ'ukayũ yobog̃ayũ be. G̃ebuje paĩyũ kukukat o'jekawẽn Jesus emumujuyũ eju. ");
INSERT INTO myu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Kuy mo a'g̃u oca'õpurug̃ oce'e eywebe “Jesus cuy epeg̃uwẽn g̃u warara'acat pe,” i — io'e. — Eyju bit kũyjobit g̃u oca'õ kay — io'e. — Soat Jerusalém ka watwat mutaybitbin eyju. “Jewawẽwẽ'ukayũ yobog̃ayũ Jesus o'yaokaat,” i'e'em eyju napa ma — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","G̃ebuje Pedroyũ o'jede cebe ip. — Deus a'õ kay juy oceju kũyjobit — io'e. — Ocewebe iwarum ey'e buje eya'õ kay g̃u oce'e Deus a'õ kay acã — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","— Eyju ma Jesus epesubamupayaat korosa be. Eyju ma epeyaokaat — io'e. — Deus pit waram g̃uto ixe o'g̃utait ce'ũap tomukadi. Wuydobuyũ'ũm'ũm tak itabut osodop ip Deus kay — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","— Deus a'õbi ixe ya'õbuyxian o'e g̃asũ. Imẽnpuye Deus xe omuy g̃asũ. Wuykukukan o'e Deus a'õbi. Wuydaxijojo'ukan o'e Deus a'õbi. Deus ibikuy osunuy Israel naxeg̃ebitbit pe ig̃uycũg̃ i'e am ikẽrẽat kug̃ puye. Ibikuy osunuy ikẽrẽat mujurũg̃rũg̃ap epere am cebe ip. Ibikuy osunuy ikẽrẽat uk am cebewi ip. Imẽnpuye Jesus wuydaxijojo'ukan o'e Deus a'õbi. Oceju dak ocetaybit apẽn Deus cuk adi o'e'e iam — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","— Imẽnpuye oceju ixe e'eap muwẽnuwẽn eywebe. Ibiõg̃buk xipacat tak iboap muwẽnuwẽn. Deus jebiõg̃buk muõmõm ja'õkayayũ be — Pedro o'e. ");
INSERT INTO myu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iboap co buje jewawẽwẽ'ukayũ yobog̃ayũ itakoma jĩjã o'e ip Jesus emumujuyũ kay. Yaokaat ojuy ip. ");
INSERT INTO myu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","G̃ebuje ag̃okatkat o'ãy―jewawẽwẽ'ukat yobog̃at. O'jekawẽn jebureyũ eju. Ixe Fariseu osunuy. Moisés ekawẽn imutaybitbin'uk ip osodop Fariseuyũ. Ixe butet Gamaliel i osunuy. Ya'õbuyxi jĩjã osunuy soat xe jeka watwat xe. Imẽn o'jekawẽn jebureyũ be. — Taupuyũ — io'e. — Koam puk ip ag̃ujẽm — io'e. — G̃a'a acewawẽ — io'e. Jesus emumujuyũ o'g̃ujẽm ip jewewãwã ap'a bewi. ");
INSERT INTO myu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel jebureyũ o'yawẽ. — Israel naxeg̃ebitbiyũ — io'e. — Eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — io'e. — Eyday'em'um cuy epesop! Xipan cuy iteyũ ag̃okatkayũ epejukuk. Eyag̃uysan cuy epesop — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","— Kuy'ũm'ũm ma wara'at ag̃okatkat osunuy. Ibutet Teudas i osunuy. “Soat podi ma wa'õbuyxi,” i napa ma o'e'e warara'acat pe. Adeayũ ceweju oekuku ip―400 beayũ. Imẽnpit wara'acat ixe Teudas o'yaoka. O'jepõg̃põg̃põg̃ ixe a'õ kayayũ. Soat oi'ũm ixe ekapikap — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","— G̃ebuje wara'at ag̃okatkat tak osunuy. Ibutet Judas i osunuy. Galiléia eipi bewiat osunuy. Wuyeipi kukayũ jebekitkiyũ o'g̃uweg̃ũn ixeyũ kabia dag̃. Ade oeku ip ixe Judas eju. Ixe Judas'ũm tak oe'ũ. O'jepõg̃põg̃põg̃ ip ixe a'õ kayayũ. Soat oi'ũm ixe ekapikap — io'e. ");
INSERT INTO myu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","— G̃asũ dak imẽn ma. Ka'ũmã ma juy ace'e iteyũ ag̃okatkayũ be. Ijodiat a'õbi jekukum pima, soat iteyũ e'eap tak i'ũm. ");
INSERT INTO myu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Deus a'õbi jekukum pima bit, iteyũ e'eap mu'ũm pa'ore wuywebe — io'e. — Iteyũ e'eap mu'ũm pin pima, Deus eju kuka jewaokakam ace — io'e Gamaliel. Gamaliel ekawẽn kay o'e ip jewewãwã'ukayũ yobog̃ayũ. ");
INSERT INTO myu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Waram Jesus emumujuyũ o'g̃udocat ip. Sorarayũ be ip o'yukxabiokakaat ixee mug̃ẽg̃ẽm. — Jesus cuy epeg̃uwẽn g̃u warara'acat pe — io'e ip cebe ip. Waram o'g̃ujẽm ip jexewi. ");
INSERT INTO myu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ibocewi Jesus emumujuyũ o'jẽm jewewãwã'ukayũ yobog̃ayũ xewi. Icokcok cĩcã o'jẽm ip. — Deus xe ocekukpin cĩcã — io'e ip jewewebe. — Cedag̃ Deus xe ixeyũ ag̃okatkayũ be oce'ukxabiokakaan. Ipiat ocesupi'ajo Jesus kay ocetabut puye — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jesus o'g̃uwẽnuwẽn ip adeayũ be. “Jesus wuydaxijo am Deus emunaẽ,” i'e'e'uk osodop ip. Soat kabia Deus eju kawẽnwẽnap'a be imutaybitbin'uk osodop ip, jeduk'a be dak. ");
INSERT INTO myu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pũg̃pũg̃ itabucayũ'in o'jemãmãmã ip jebureyũ kay. Jesus kayayũ big̃ ma oiacog̃. Soat ip Judeuyũ osodop. Grego a'õm kawẽnwẽn'uk osodop ip pũg̃pũg̃ ixeyũ'in. Hebraico a'õm kawẽnwẽn'uk osodop ip warara'acayũ. Ixeyũ parakpe osodop ip itop'ũm e'ũ'ibiyũ tadaybotbocayũ. Imẽnpuye pũg̃pũg̃ itabucayũ'in o'jemãmãmã ip jebureyũ kay. — Ocexat ũmũm g̃u ip ocewebe — io'e ip aoyũ itop'ũm e'ũ'ibiyũ. — Jewewebe acã ip imu'ẽ'ẽ'ẽm — io'e ip. — Dapxi eyju! Eywebe dak oceju iũmũm! — io'e ip warara'acayũ bit. ");
INSERT INTO myu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Imẽnpuye Jesus emumujuyũ soat itabucayũ o'tomuwã je'awero am. O'je'awero ip. Doze beayũ o'jekawẽn warara'acayũ eju―Jesus kay itabucayũ eju. — Oceju Deus ekawẽn muwẽnuwẽn — io'e ip. — Ibo ma ocekapikap — io'e ip. — Xipat g̃u ocewebe Deus ekawẽn muwẽnap epere am itop'ũm e'ũ'ibiyũ xat mu'ẽ'ẽ ãm — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","— Imẽnpuye, tapupuyũ, 7 be ag̃okatkayũ'in ataẽ ixat mu'ẽ'ẽ ãm itop e'ũ'ibiyũ be — io'e ip. — Wuybadipyũ'in cuy ataẽ―itabut cĩcãayũ―itaybit cĩcãayũ―Deus biõg̃buk a'õkay jĩjãayũ — io'e. — Ibiayũ ma ataẽ — io'e. — Ijop ocekapikap oceg̃ũm taẽ'ibiyũ be. Ixeyũ ma itop e'ũ'ibiyũ xat g̃u'ẽ'ẽ'ẽ — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","— Oceju bit soat em Deus eju kawẽnwẽn'uk ocesop — io'e. — Soat em ixe ekawẽn imutaybitbin ocekuku — io'e ip. ");
INSERT INTO myu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Doze beayũ ekawẽn kay o'e ip soat itabucayũ. Cekawẽn tag̃ e ojuy ip. G̃ebuje Jesus kay itabucayũ 7 beayũ o'taẽ. Ibũrũ ma ibutet osodop ip―taẽ'ibiyũ butet: Estêvão i, Filipe i, Prócoro i, Nicanor i, Timom i, Pármenas i, Nicolau i. Estêvão Deus kay itabut cĩcãat osunuy. Deus biõg̃buk a'õ dag̃ jekuku'uk osunuy. Nicolau Antioquia ka bewiat osunuy. Judeu g̃u osunuy. Deus kay Judeuyũ etabucap puxim pit itabut osunuy. Ibũrũ ma ip osodop taẽ'ibiyũ. ");
INSERT INTO myu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jesus kay itabucayũ ixeyũ 7 beayũ o'tujowat Jesus emumujuyũ kay―doze beayũ kay. Jesus emumujuyũ o'jekawẽn Deus eju ixeyũ beam―7 beayũ beam. O'jewebumõg̃ ip yabi jeje. — Iteyũ juy ixat g̃u'ẽ'ẽ'ẽ itop e'ũ'ibiyũ be — io'e ip soat a'õpiju. ");
INSERT INTO myu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Imẽneju adeayũ oitabun ip Jesus kay. Deus a'õ kay oitabun ip. Deus ekawẽn tag̃ oekuku ip. Ade jĩjã Jerusalém ka beayũ itabut o'e ip Jesus kay, ade Judeuyũ epaĩyũ dak. ");
INSERT INTO myu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estêvão wuywebe i'e ba'oreat mubapukpug̃ oeku Deus a'õbi. Adeayũ o'g̃ucoatcoan Deus a'õbacaap kug̃ puye. Deus Estêvão buywatwan osunuy. ");
INSERT INTO myu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pũg̃pũg̃ayũ bit Estêvão o'jomuymuy jĩjã Judeuyũ'in. Ixeyũ Judeuyũ je'aweroro'uk ip osodop je'aweroroap'a be―Deus eju kawẽnwẽnap'a be. Ce'aweroroap'a butet jekupinap tag̃ jekuku'ukayũ e'aweroroap'a i osunuy. Cirene ka bewi osodop ip ixeyũ Judeuyũ, Alexandria ka bewi dak. Cilícia eipi bewi ip osodop, Ásia eipi bewi dak. Estêvão a'õxik o'e ip ig̃o'a be. ");
INSERT INTO myu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Deus biõg̃buk pit Estêvão mukũyjojom osunuy. Imẽnpuye ya'õxik pa'ore ip osodop. ");
INSERT INTO myu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Imẽnpuye ya'õxik ojuyayũ dinheiro o'g̃ũm warara'acat pe napaap muwẽg̃apteim―Estêvão awẽg̃ mukẽrẽrẽnapteim. — “Estêvão cũg̃'ũma wuybadipyũ mutaybitbin,” i juy epe'e napa ma — io'e. — “Estêvão Deus muymuy,” i juy epe'e napa ma — io'e ip cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Imẽnpuye ixeyũ napapa'ukayũ Estêvão awẽg̃ o'yawẽg̃mukẽrẽrẽn soat a'õpiju. Ya'õxik ojuyayũ adeayũ o'g̃utakomãn Estêvão kay. Judeuyũ kukukayũ o'g̃utakomãn ip, Moisés ekawẽn imutaybitbin'ukayũ dak. Soat ixeyũ o'ju Estêvão kay. Estêvão o'jat ip. O'tujowat ip jewawẽwẽ'ukayũ yobog̃ayũ etabutpe. ");
INSERT INTO myu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Napapa'ukayũ dak o'tujowat ip. Estêvão a'õ o'ya'õdada jĩjã ip. — Soat em teku Deus eju kawẽnwẽnap'a muymuy―ikẽrẽat kug̃ g̃u iat'a muymuy — io'e ip napa ma. — Soat em teku Moisés ekawẽn mupubutbun — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","— Cekawẽn cuk adi oceya'ĩjojo! “Jesus Deus eju kawẽnwẽnap'a g̃u'ũm yabog̃at'a. Nazaré ka bewiat ig̃o'a g̃u'ũm,” io'e ite napa ma — io'e ip napa ma. — “Moisés wuyawẽwẽap ekawẽn g̃uwarurun,” i juk adi o'e'e — io'e ip napa ma. Estêvão a'õ o'ya'õdada jĩjã ip. ");
INSERT INTO myu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jewawẽwẽ'ukayũ yobog̃ayũ o'jeak Estêvão kay g̃ebuje bit. Estêvão dopa Deus ekawẽn tojotjot'ukat topa jo'i o'e. Imẽn o'jojojo ip jewawẽwẽap'a beayũ. ");
INSERT INTO myu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","— Icẽm tu ixeyũ e'em? — io'e paĩyũ kukukat Estêvão be. ");
INSERT INTO myu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estêvão o'jekawẽn iboceayũ be. Apẽn Deus xipan je'ajojoyũ'ũm'ũm kukug̃ osunuy iap o'g̃uwẽn cebe ip. — Okotkotyũ, owag̃og̃oyũ, baybayũ, wa'õ kay juy epesop — io'e. — Deus soat podi ma ya'õbuyxi — io'e. — Soat podi ma idip — io'e. — Ixe o'jebapuk wuydobu'ũm kay―Abraão'ũm kay kuyje. O'jebapuk cekay Mesopotâmia eipi be bima. O'jebapuk cekay Hará ka be ajẽm awap. ");
INSERT INTO myu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Ejẽm cuy eka bewi, ebadipyũ xewi,” i mo a'g̃u o'e Abraão be Deus. “Ekam osukamubapuk'iat ka be juy eju,” i mo a'g̃u o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Imẽnpuye Abraão o'jẽm jeipi bewi―Mesopotâmia eipi bewi―Caldéia eipi bewi. Hará ka kay o'ju jenuy ãm — Estêvão o'e. — G̃uyjom Abraão ebay'ũm oe'ũ. Ce'ũ buje Deus Abraão o'g̃udot ijop ipi kay―wuyeipi kay. ");
INSERT INTO myu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Deus ipi o'g̃ũm g̃u Abraão be. Yopĩt tak o'g̃ũm g̃u ipi. Imẽnpit “Soat ijop ipi eipim je'e,” i mo a'g̃u o'e Deus Abraão be. “E'ũ buje enaxeg̃ebitbit eipim je'e,” io'e. Deus iboam o'e Abraão be ipotpet'ũm pima — io'e. ");
INSERT INTO myu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","— Deus imẽn o'jekawẽn Abraão eju. Deus o'e cebe: Obure, warara'acat eipi be jeedop ip enaxeg̃ebitbit, i. 400 koato jeedop ip iboce, i. Iboceayũ warẽmtag̃ cĩcã enaxeg̃ebitbit jukuk, i. Enaxeg̃ebitbit g̃udadaybotbon ip, i. ");
INSERT INTO myu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Enaxeg̃ebitbit g̃upokupok ip yaoka am, i. Imẽnpit ipiat osupi'ajoat warẽmtag̃ ixeyũ kukayũ be, i. G̃uyjom ibo eipi bewi je'jẽm ip enaxeg̃ebitbit, i. G̃ebuje ijoce ma “Ẽn xipat cĩcã,” i je'e ip owebe, i mo a'g̃u o'e Deus Abraão be — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","— Deus waram o'jekawẽn Abraão eju. — Ag̃okatkat'it'it epetaypu'ag̃obixeedakacat ikap'isum, i. Epetaypu'ag̃obixeedakacat “Oceju Deus ebekitkit” i'e am soat pe warara'acat pe, i mo a'g̃u o'e Deus Abraão be — io'e Estêvão. — G̃uyjom Isaque o'kap―Abraão ipot. 8 kabia bima ikap'isuat o'taypu'ag̃obixeedakat Deus a'õbi. Isaque yaypan puje o'jewebumũn. G̃uyjom ixe ipot o'kap. Ibutet Jacó i osunuy — io'e Estêvão adeayũ be. — Jacó ipotpoyũ ade osunuy. Doze be osodop ip ipotpoyũ. Ixeyũ doze beayũ Judeuyũ dobuyũ'ũm'ũm osodop ip. Wuyeipi kukukayũ osodop ip — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","— José Jacó ipotpoyũ'in osunuy. Iwag̃oyũ itabutkarey jĩjã o'e ip jekitpit kay―José kay. José o'teida ip Egito eipi kay cuayũ be dinheiro bu am — io'e. — Ibocewi José o'tujowat ip Egito eipi be teihem g̃u kapik am — io'e. — Teihem g̃u kapikpik'uk osunuy Egito eipi kukukat peam―Faraó beam. — Soat em Deus osunuy ag̃ José kay. ");
INSERT INTO myu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Deus José buywatwat'uk osunuy ipiatpi'ajojom ma a'g̃u. José itaybit cĩcãan o'e Faraó xe, Deus ixe o'g̃utaybitbin puye. Imẽnpuye Faraó José kay jĩjã o'e. “G̃asũ ẽn tak Egito eipi kukukan ecesũy oweju,” io'e Faraó José be. “Oduk'a kukukan tak ecesũy,” io'e cebe — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","— G̃uyjom Egito eipi dag̃ayũ jexat o'jokudada jĩjã, Canaã eipi dag̃ayũ dak. Ka'ũmg̃u ixat osodop Egito eipi dag̃, Canaã eipi dag̃ tak. Soat kaka dag̃ ire oekuku ip. Ixat tobuxik pa'ore o'e ip wuydobuyũ'ũm'ũm, oi'ũm puye — io'e. ");
INSERT INTO myu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","— Jacó o'jekũyjo tũmũntata kake Egito eipi be iam. Iboam jekũyjo buje jekpotpoyũ o'g̃uju iboce―wuydobuyũ'ũm'ũm o'g̃uju. Trigoda bu am ip o'g̃uju Egito eipi kay. Xepxep ekum o'ju ip trigoda bum. ");
INSERT INTO myu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","José o'jebapuk jewag̃oyũ kay xepxep em oeku ibima. “Õn eykitpit José,” io'e cebe ip. Faraó itaybit o'e ixeyũm―José wag̃oyũm — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","— Imẽneju José o'jewa'õmuju jebay be soat jewag̃oyũ badipyũ be dak. Ade osodop ip José badipyũ―75 be osodop ip. “Epesot cuy Egito eipi be soat eyju,” io'e José cebe ip — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","— Soat ip o'ju Egito eipi kay. José ebay o'ju, soat iwag̃oyũ dak. O'ju ip jebadipyũ eju. Iboce osodop ip. Jacó'ũm oe'ũ iboce. Soat Jacó'ũm ipotpoyũ'ũm'ũm tak oe'ũ'ũ iboce. Oe'ũ'ũ ip wuydobuyũ'ũm'ũm. ");
INSERT INTO myu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ibocewi jebayũ'ũm'ũm tao o'taodujowat ip jeka be taokot am ade koato kap puje. Wuydobubuyũ'ũm'ũm tao o'taodujowat ip Jacó ka be―Siquém ka be Canaã eipi be. Kuy bima Abraão ibo eipi o'jat. Emor ipotpoyũ xewi. Dinheiro o'g̃ũm isurũg̃at cebe ip ipi deim. Ibo ka be wuydobubuyũ'ũm'ũm tao o'taomõg̃ ip witabikũy be — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","— Egito eipi be bima wuydobubuyũ'ũm'ũm ade jĩjã ip osodop―Judeuyũ. Pũg̃ koato g̃u ip osodop Egito eipi be―ade koato. G̃axĩn ma je'jẽm ip Egito eipi bewi apẽn Deus o'e Abraão be iap tag̃. ");
INSERT INTO myu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wara'acat Egito eipi kukukan o'e. Ixe ipi kukukat itaybit g̃u o'e José'ũm, kuy ma ixe'ũm oe'ũ buye. Kuyjeayũ mudadaybotbon cĩcã o'e ip. ");
INSERT INTO myu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kuyjeayũ o'g̃ug̃uykukuku ip. Ipiat o'supi'ajojoat cĩcã cebe ip. “Soat ikap'isusuayũ epejomõg̃ akiju ce'ũ ãm eyipotpoyũ,” io'e kuyjeayũ be Egito eipi kukukat. Imẽn o'e wuydobuyũ acog̃ap puxim — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Moisés o'kap g̃ebuje. Idip cĩcã osunuy. Ebapũg̃ kaxi acã Moisés jexi xe osunuy. ");
INSERT INTO myu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bekicat o'g̃ujẽm ip jeduk'a bewi. Imẽnpit oe'ũ g̃u — io'e. — Imujẽm puje Faraó daxit Moisés o'tobuxik―Egito eipi kukukat taxit. O'tujoõm jeduk'a be. Moisés o'g̃uaypan je'it muaypanap puxim. ");
INSERT INTO myu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Imẽnpuye Moisés itaybit o'e soan. Egito eipi watwat o'g̃utaybitbitbin. Ya'õbacaan o'e. Itaybit cĩcãan o'e kawẽn ãm, soat mug̃ẽ ãm tak — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","— Moisés oajẽm jebadipyũ kay. Oajẽm jebadipyũ jo pin cĩcã buye―Israel eipi watwat co pin cĩcã buye. 40 koato osunuy. ");
INSERT INTO myu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","— Egito eipi wat warẽmtaksug̃ Israel eipi bewiat o'jukuk yukpiwat g̃u ma'g̃u. Moisés o'jojojo ip. Jebadip kay itabotaidabotbot o'e. Egito eipi wat'ũm o'yaoka jebadip kay jeweik pin puye. ");
INSERT INTO myu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Obadipyũ itaybit Deus omudot tujujẽm ãm ip Egito eipi bewi iam,” io'e Moisés jewebe ma. Imẽnpit ibadipyũ itaybit g̃u o'e iboam — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","— Kuyaje Moisés o'ju waram jebadipyũ jom. Xepxepayũ o'tobuxik jebadipyũ. Jewaokakam o'e ip. O'ju jewaokakaayũ mubu'un am. “Tapupuyũ, apẽnpuye dak eyju jewaokakam―ibadipyũ eyju!” io'e cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jebadip aokakaat pit Moisés o'g̃uwun. Ixe dak o'e Moisés pe: “Abu dak emudot ocekukukan?” i. “Abu dak emudot ‘Cũg̃ g̃u eyju jekukum’ i'e am ocewebe?” io'e Moisés pe. ");
INSERT INTO myu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“Kapusu Egito eipi wat eyaoka iat puxim tu ẽn oaoka ojuy?” io'e Moisés pe. ");
INSERT INTO myu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Imẽnpuye Moisés o'jenapõn Egito eipi bewi jaokaap puxim — io'e. — Midiã eipi kay o'ju. Osunuy. O'jewebumũn iboceat eju. Koapat o'kap ipot. G̃uyjom wara'at o'kap ipot. Moisés 40 koato osunuy Midiã eipi be — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","— G̃ebuje Deus ekawẽn tojotjot'ukat o'jebapuk Moisés kay. Uk'a'ũmat pe osunuy co'a xe. Co'a butet Sinai'a i osunuy. Moisés tip'aroro'it'it o'jojojo. Tipsop o'e. O'tipik g̃u bit. ");
INSERT INTO myu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Imẽnpuye Moisés itabẽg̃ o'e ijojom. “Ajo xe'e ijop?” io'e jewebe ma. O'ju cetẽg̃ ma xipan tip co am. Deus o'jekawẽn ceweju tip'aroro'it'it pewi. ");
INSERT INTO myu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Õn Deus,” io'e Moisés pe. “Edobuyũ'ũm'ũm itabut osodop ip okay―Abraão, Isaque dak, Jacó dak,” io'e Deus cebe. Moisés ikarabakbak o'e jeparara pibun. Ibu'u o'e ijom iparara buye. ");
INSERT INTO myu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Deus waram o'jekawẽn ceweju. “Eyuk eju'uk ei bewi wa'õbuyxi exe iap mubapuk am,” io'e Deus cebe. “Xipat cĩcãatka mucakucag̃ ẽn, õn ijoce buye,” io'e. ");
INSERT INTO myu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","“Egito eipi watwat ikẽrẽm cĩcã webekitkit kug̃,” io'e. “Ipiatpi'ajojom cĩcã ip. Imẽnpuye je'ũhũ'ũm cĩcã ip. Wetaybit iboam,” io'e Deus. “Õn ma okop Egito eipi watwat xewi ixeyũ dujujẽm ãm,” io'e. “G̃a'a aju,” io'e. “Õn jemuju webekitkit tujujẽm ãm Egito eipi watwat xewi,” io'e Deus Moisés pe. Imẽn Deus o'jekawẽn Moisés eju — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","— Deus Moisés o'g̃uypit Egito eipi be. Moisés o'g̃uypit ixe be jebekitkit tujujẽm ãm Egito eipi bewi―Judeuyũ dujujẽm ãm. Deus ixe o'g̃uypit jekawẽn tojotjot'ukat ebapuk puje cekay tip'aroro'it'it pewi. Deus ma ixe o'g̃uypit. Judeuyũ bit ixe a'õ kay g̃u ip osodop. Judeuyũ ma o'e Moisés pe: “Abu-dak emudot ocekukukan?” i. “Abu-dak emudot ‘Cũg̃ g̃u eyju jekukum’ i'e am ocewebe?” io'e ip Moisés pe. Deus pit ixe o'jomuy Judeuyũ kukukan, Egito eipi bewi Judeuyũ dujujẽmjẽm'ukan tak — io'e Estêvão. ");
INSERT INTO myu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","— G̃uyjom ixe Moisés wuywebe i'e ba'oreat o'g̃ubapukpuk Egito eipi be bima, tibog̃ cĩcãati mudeg̃ pima dak. Tibog cĩcãati butet Tipakpekati i osunuy. Ixe Moisés Judeuyũ o'tujujẽm Egito eipi bewi. Ade koato uk'a'ũmat tag̃ oekuku ip―40 koato. Wuywebe i'e ba'oreat o'g̃ubapukpuk iboce dak. ");
INSERT INTO myu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","— Ixe Moisés o'e Israel naxeg̃ebitbiyũ be: “Deus jekawẽn muwẽnuwẽn'ukat g̃udot eykay,” i. “Omudocap puxim ixe g̃udot,” i. “Eybadipyũ'in g̃udot,” i. ");
INSERT INTO myu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","— Ixe Moisés Israel naxeg̃ebitbiyũ xe osunuy uk'a'ũmat pe. Israel naxeg̃ebitbiyũ o'je'awero ip Sinai'a etakobe. Deus ekawẽn tojotjot'ukat o'jekawẽn Moisés eju ig̃o'a jeje — io'e. — Ig̃o'a be Moisés o'jekawẽn wuydobuyũ'ũm'ũm eju―Israel naxeg̃ebitbit'ũm'ũm eju. Deus ekawẽn o'g̃uwẽn cebe ip―wuyawẽwẽap ekawẽn. Moisés iboap ekawẽn o'g̃ubararak witadopa be topa'erũnat topa be g̃uyjom ocetaybit am iboam — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","— G̃uyjom wuydobuyũ'ũm'ũm oibu'un Moisés a'õ kay. Moisés kay'ũm cĩcã ip o'e. Egito eipi kay jepit ojuy o'e ip. ");
INSERT INTO myu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Imẽnpuye o'jekawẽn ip Arão eju. O'jekawẽn ip Moisés co'a jeje ibun pima. — “Wuyedeusyũm cuy eg̃ug̃ẽ,” io'e ip Arão be. “Ixeyũ je'ju wuywap Egito eipi kayate mubapuk am wuywebe,” io'e ip. “Poce paxi omuy Moisés―Egito eipi bewi wuydujujẽmat?” io'e ip. “Ocetaybit g̃u poma paxi o'ju iam,” io'e ip Arão be napa ma. ");
INSERT INTO myu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","— Imẽnpuye biopak'it'it co'iat o'g̃ug̃ẽ ip ourom. Ovelha o'yaoka ip imõg̃ ãm biopak'it'it co'iat wap “Teku Deus” i'e am. Petatam o'e ip jedeusbaro kug̃ puye, jemumug̃ẽ kug̃ puye. Icokcok ip o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Imẽnpuye Deus ibu'u o'e cekay ip itabut ip biopak'it'it co'iat kay buye. Tũybe biopak'it'it co'iat Deus iãn o'e ip. Tũybe kaxiepiat Deus iãn o'e ip, kaxiamat tak, kasoptayũ dak iãn o'e ip. Deus kay wuyetabucap puxim itabut o'e ip ixeyũ kay. Imẽn cedag̃'ũm cĩcã o'e Deus xe. Imẽn e'em Deus ekawẽn muwẽnuwẽn'ukayũ emudupmubararaktup: “Bekitkit, owebe g̃u ovelha ũmũm'uk epesop uk'a'ũmat pe bima―40 koato bima,” i'e'em Deus Israel naxeg̃ebitbit pe, i. “Eyedeusbaroyũ be acã iũmũm'uk epesop―eyemumug̃ẽ be acã,” i'e'em, i. ");
INSERT INTO myu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","“Ibiõg̃buk epeg̃ug̃ẽg̃ẽ,” i'e'em, i. “ ‘Ocexe eyju acã deus,’ i epe'e napa ma cebe ip,” i'e'em Deus, i. “ ‘Ocetabut eykay,’ i epe'e'e,” i'e'em Deus, i. “Tũybe Moloque eyedeus iãn epesop, Renfã dak,” i'e'em, i. “Moloque duk'a dujowatwan epekuku―torojo'a dujuwatwan―ya'ĩcat'a dujowatwan,” i'e'em, i. “Moloque biõg̃buk ig̃o'a be osunuy,” i. “Tũybe kasopta jo'iat tak deus iãn epesop,” i'e'em, i. “Renfã i kasopta jo'iat putet osunuy,” i'e'em, i. “Imẽnpuye ipiat osupi'ajoat eywebe,” i'e'em, i. “Wũyat eipi kay jeymuju õn,” i. “Õn jeymuju Babilônia eipi weg̃ũnat ka kay,” i. Imẽn e'em Deus ekawẽn muwẽnuwẽn'ukayũ emudupmubararaktup — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","— Uk'a'ũmat tag̃ jekukum pima wuydobuyũ'ũm'ũm Deus eju kawẽnwẽnap'a dujowatwan oekuku ip―ixee'a'a dujowatwan. Witadopa o'topadop ig̃o'a be―xepxeptopa―topaerũnatopa. Deus ekawẽn ibararak osodop ixe dopa be. Ig̃o'a o'yamug̃ẽ ip apẽn Deus o'e Moisés pe iap tag̃ — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","— Moisés'ũm e'ũ buje Josué wuydobuyũ'ũm'ũm kukukan o'e. Josuéyũ Deus eju kawẽnwẽnap'a o'yadujujẽm uk'a'ũmat pewi torojo'a―ixee mug̃ẽg̃ẽ'a. O'yadujuajẽm ip Canaã eipi be. Judeu'ũmayũ osodop ip iboce yajẽm puje ip. Deus ixeyũ Judeu'ũmayũ o'g̃ujẽm ibo ipi bewi wuydobuyũ'ũm'ũm top am. Deus eju kawẽnwẽnap'a o'yadujuajẽm ip jeweju Canaã eipi be — io'e adeayũ be. ");
INSERT INTO myu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","— G̃uyjom Davi o'e Deus pe: “Uk'a muy ojuy a'g̃u õn eweju kawẽnwẽnap'am,” i — io'e. — Canaã eipi be bima Davi wuydobuyũ'ũm'ũm kukukan o'e. Davi ikukpin cĩcã osunuy Deus xe. Deus soat em idipat o'g̃udotdot cekay. Davi o'e: “Deus, uk'a muy ojuy a'g̃u õn eweju kawẽnwẽnap'am,” i. “Jacó itabut osunuy ekay,” i. “Õn tak wetabut ekay,” i. “Imẽnpuye uk'a muy ojuy a'g̃u õn―ewebeap'am,” i. Imẽn Davi o'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Imẽnpit Deus o'yamuyat Davi be g̃u. Davi g̃u Deus eju kawẽnwẽnap'a o'yamuy―ipot acã. Salomão o'yamuy. ");
INSERT INTO myu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Deus pit uk'a be g̃u nuynuy―ijodiat emuamuy'a be g̃u. Ixe Deusat. Soat podi ma ya'õbacaat. Kabi be bit nuynuy. Deus imẽn o'e jekawẽn muwẽnuwẽn'ukayũ ekawẽn tag̃: ");
INSERT INTO myu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kabi wabikbikap puxim, i'e'em Deus. Ipi wuimõg̃mõg̃ap puxim, i'e'em. Soat kug̃ õn kabi beacat kug̃―ipi dag̃acat kug̃ tak, io'e. Apẽntak ijodiat emuamuy'a be og̃uy? i. ");
INSERT INTO myu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Õn ma soat og̃ug̃ẽ. Ipi og̃ug̃ẽ, ipi dag̃acat tak, kabi dak, kabi beacat tak, i. Imẽn Deus o'e ixeyũ ekawẽn tag̃ — Estêvão o'e. ");
INSERT INTO myu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","— Tapupuyũ, eya'õpicũg̃cũg̃ cuy epesop wa'õ kay — Estêvão o'e jebadipyũ be. — Kũyjobit'ũm cĩcã eyju! — io'e. — Eybu'u jĩjã Deus ekawẽn com. Deus kay itabut'ũm co'i eyju. Eybu'u jĩjã Deus a'õ dag̃ eyeku am. Eyebayũ ekukuap puxim eyju dak jekukum. ");
INSERT INTO myu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Warẽmtag̃ cĩcã Deus ekawẽn muwẽnuwẽn'ukayũ o'jukukuk ip eyebayũ. Ka'ũma ma ixeyũ'in xipan ip o'jukuk! Pũg̃ tak ka'ũma. “Cũg̃ cĩcãat omuyku,” io'e'e ip Deus ekawẽn muwẽnuwẽn'ukayũ. Imẽn o'e'e ip yajẽm awap. Imẽn e'e'ukayũ o'yaoka ip eyebayũ — io'e Estêvão. — G̃asũ ma ixe cũg̃ cĩcãat epeg̃ũm cekay itakomaayũ be. Jesus i ixe butet. Ixe epesubamupaya korosa eju. ");
INSERT INTO myu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kuy juk Deus ekawẽn epeya'ĩjojo Deus ekawẽn muwẽnuwẽn'ukat pi bewi. Imẽnpit ya'õkay'ũm cĩcã eyju — Estêvão o'e adeayũ be, jebadipyũ be. ");
INSERT INTO myu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ya'ĩjo'ibiyũ oitakomãn Estêvão kay. Cekawẽn co buje ip oitakomãn. Yaoka pin o'e ip jetakoma pibun. ");
INSERT INTO myu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estêvão bit Deus biõg̃buk kug̃ cĩcã osunuy. O'jeapũn kabi kay. Deus dipap o'jojojo. Jesus tak o'jojojo. Cũg̃'i osunuy kabi be Deus xe soat kukukan. Estêvão o'jekawẽn ixe jojom pima. ");
INSERT INTO myu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","— Ak'i juy epe'e — io'e. — Kabi ikoce õn ijojom — io'e. — Soat wag̃o jojom õn. Cũg̃'i Deus xe soat kukukan — io'e. ");
INSERT INTO myu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Iboap co buje, ya'ĩjo'ibiyũ big̃ ma oitakomãn cekay. O'jewãwã ip ya'õberen. — G̃a'a ayaoka — io'e ip ya'õberen. O'jewa'opinomudipdip ip waram ya'ĩjoap puxim. Adedem ip o'jedau cekay. ");
INSERT INTO myu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kururug̃ o'tujowat ip ikabog̃atka eakiju. Jeekabek ip o'ju'uk'uk. O'jomõg̃ ip Saulo be imuxipan am. Ixe Saulo yaypan'isuat osunuy. Estêvão o'yabug̃ ip wita'am. ");
INSERT INTO myu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yabug̃bug̃ pima Estêvão o'jekawẽn Jesus eju. — Okukukat Jesus, oje'ũ — io'e. — Ekay ojot — io'e. ");
INSERT INTO myu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","O'jẽg̃'aecõg̃cõg̃. Waram o'jewãwã ya'õberen. — Okukukat Jesus — io'e. — Ipiat cuy ecesupi'ajoat g̃u teyũbeku wabug̃bug̃apteim — io'e Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Oe'ũ. Saulo dak Estêvão aokaap ojuy. ");
INSERT INTO myu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xipat cĩcãayũ Estêvão'ũm jebit o'jomõg̃ witabikũy be―Jesus kay itabucayũ. I'ũmcocom cĩcã o'e ip. O'jepõg̃põg̃põg̃ ip soat ka dag̃ Jesus kay itabucayũ. Pũg̃pũg̃ ixeyũ'in o'jepõg̃põg̃põg̃ ip Judéia eipi dag̃. Warara'acayũ ixeyũ'in o'jepõg̃põg̃põg̃ ip Samaria eipi dag̃. Jesus emumujuyũ bit o'jepõg̃põg̃põg̃ g̃u―doze beayũ. Jerusalém ka be ip osodop. ");
INSERT INTO myu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo dak Jesus kay itabucayũ mu'ũm ojuy oekuku. Taomũn ãm õmõm'uk osunuy ixeyũ duk'a be. Ag̃okatkayũ o'taomũnmũn, aoyũ dak. Daomũnmũnap'a be ip o'g̃uõmõm. Saulo ipiat o'supi'ajoat cĩcã cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Imẽnpit Deus ekawẽn muwẽnuwẽn oekuku ip o'jepõg̃põg̃'iayũ―Jerusalém ka bewiayũ. Soat ka dag̃ ip oekuku Deus ekawẽn muwẽnuwẽn. ");
INSERT INTO myu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jesus kay itabucayũ Deus ekawẽn o'g̃uwẽnuwẽn Samaria eipi watwat pe. Filipe o'ju ikabog̃atka be Samaria eipi beatka be. Ixe o'jepõg̃põg̃põg̃'iayũ'in osunuy. Ibo ka be Deus ekawẽn o'g̃uwẽnuwẽn. — Deus Jesus o'taẽ soat taxijo am — io'e ibo ka watwat pe. ");
INSERT INTO myu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ibo ka watwat itabut cĩcã o'e ip Filipe a'õ kay―Deus a'õbacaan wuywebe i'e ba'oreat o'g̃ubapukpuk puye. ");
INSERT INTO myu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ibiõg̃buk kẽrẽat o'g̃ujẽmjẽm adeayũ bewi. Ya'õberen jewãwãwãm o'jẽm ip cebewi. Ade ijebit e'ũ topibiyũ dak o'g̃u'ada'ada. Ade taojere topibiyũ dak o'g̃u'ada'ada. ");
INSERT INTO myu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Imẽneju icokcok cĩcã ip o'e ibo ka watwat. Itabut o'e ip Jesus kay. ");
INSERT INTO myu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kuy bima Simão kay itabut cĩcã ip osodop ibo ka watwat. Ixe Simão ya'õbuyxiat osunuy adeayũ xe, wuywebe i'e ba'oreat mubapukpug̃ wamoat puxim puye. — Soat podi ma wa'õbacaap kug̃ õn — io'e soat pe napa ma. ");
INSERT INTO myu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Imẽnpuye tũybe teku ya'õbaca jĩjã iãn o'e ip. Soat Samaria eipi watwat itabut cĩcã o'e Simão kay―ya'õbuyxiayũ, tadaybotbocayũ dak. — Teku ya'õbaca jĩjã, Deus ja'õbacaap o'g̃ũm cebe buye — io'e ip napa ma. — Teku Deus a'õbi jekukum — io'e ip napa ma. ");
INSERT INTO myu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ade koato Simão wuywebe i'e ba'oreat mubapukpug̃ oekukuku ibo ka beayũ etabutpe. Imẽnpuye adeayũ itabut o'e ip cekay. ");
INSERT INTO myu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","G̃ebuje Filipe Deus ekawẽn o'g̃uwẽnuwẽn ibo ka watwat pe―Simão nuyapka watwat pe. — Deus soat kukukan je'e — io'e cebe ip. Jesus Cristo o'g̃uwẽnuwẽn cebe ip. Kawẽn idipat o'g̃uwẽnuwẽn. Imẽnpuye itabut o'e ip Jesus kay. O'jewemubatisanat ip―ag̃okatkayũ, aoyũ dak. ");
INSERT INTO myu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simão dak itabut o'e Jesus kay―wamo tũibit. O'jewemubatisanat. Filipe eju oeku. Filipe Deus a'õbacaan wuywebe i'e ba'oreat o'g̃ubapukpuk adeayũ etabutpe. Deus a'õbacaap o'g̃ubapukpuk cebe ip. Simão iboap o'jojojo. Itabẽg̃ cĩcã o'e Filipe jojom. ");
INSERT INTO myu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesus emumujuyũ Jerusalém ka be osodop ip. Samaria eipi watwat awẽg̃ o'yawẽg̃tobuxik ip. — Samaria eipi watwat itabut o'e Deus ekawẽn kay — io'e ip. Imẽnpuye ixeyũ Pedro o'g̃uju Samaria eipi kay. João dak ip o'g̃uju. ");
INSERT INTO myu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pedroyũ oajẽm Samaria eipi watwat kay―Jesus kay itabucayũ kay. O'jekawẽn ip Deus eju. — Ebiõg̃buk cuy eg̃uõm cebe ip — io'e Deus pe, ");
INSERT INTO myu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ibiõg̃buk oõm g̃u buk cebe ip puye. “Wuykukukat Jesus ebekit õn g̃asũ” i'e am o'jewemubatisasaan ip. Imẽnpit Deus biõg̃buk oõm g̃u buk cebe ip. ");
INSERT INTO myu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","G̃ebuje jebu o'subumõg̃ ip itabucayũ abi jeje. Deus biõg̃buk oõm cebe ip g̃ebuje bit. ");
INSERT INTO myu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pedroyũ ixeyũ abi jeje jebu mõg̃ puje Deus biõg̃buk oõm cebe ip iap o'jojojo Simão. Imẽnpuye ixe Simão dinheiro ũm ojuy o'e Pedro be ibubabi bu ojuy. ");
INSERT INTO myu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","— Ebubabi bu pin õn — Simão o'e Pedro be. — Juku. Edinheirom — io'e cebe ip. — A'õbacaap cuy eg̃ũm owebe dak imẽn e'e am — io'e. — Wetaybit pin Deus biõg̃buk muõm ãm wara'acat pe — io'e Pedro be. ");
INSERT INTO myu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro itakoma o'e Simão kay. Ya'õpurug̃ o'jede cebe. — Tũybe Deus emumuũm ojat wedinheirom iãn ẽn e'em — io'e Simão be. — Deus cuy jemuju ipiat'ajojoap kay edinheiro kug̃! — io'e ya'õpurug̃. ");
INSERT INTO myu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","— Iba'ore ewebe kapik am Deus beam oceweju. Ikẽrẽat kug̃ ẽn Deus xe. ");
INSERT INTO myu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eg̃uycũg̃ cuy eg̃uy, ikẽrẽat kug̃ puye — io'e cebe. — Ikẽrẽat mujurũg̃rũg̃ap cuy ecepere — io'e cebe. — “Ikẽrẽat mujurũg̃ ojuy õn,” i juy ece Deus pe. “Ikẽrẽat cuy eju'uk owebewi,” i juy ece cebe. Imẽn e'e buje Deus g̃ebum g̃u je'e apẽn cuk adi ikẽrẽat eg̃ujurũg̃rũg̃ iap kay. ");
INSERT INTO myu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ẽn pit etabutkarey jĩjã warara'acat kay. Ikẽrẽat kay acã ẽn — io'e Pedro ya'õpurug̃ Simão be. ");
INSERT INTO myu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simão iparara o'e Pedro ekawẽn co buje. — Owebeam cuy ecekawẽn Deus eju — Simão o'e. — Ecekawẽn cuy ceweju owebe apẽn cuk ece iap ebapukap puxim — io'e Pedroyũ be. — Ha'a. Ocekawẽn cuy — io'e. ");
INSERT INTO myu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedroyũ o'jepit Jerusalém ka kay. Deus ekawẽn muwẽnuwẽn oekuku ip Samaria eipi watwat pe jeka kay jexexem pima―Jerusalém ka kay. Wuykukukat o'e'e iap muwẽnuwẽn oekuku ip, apẽn cuk adi o'jebapuk cebe ip iap muwẽnuwẽn tak. Ade ka dag̃ ip oekuku Samaria eipi dag̃. Ade ka watwat pe Deus ekawẽn muwẽnuwẽn oekuku ip jexexem pima. ");
INSERT INTO myu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Deus ekawẽn tojotjot'ukat o'jekawẽn Filipe eju―kabi kadi wiat. — Ecewemuxipan cuy — io'e. — Kaxietajoreg̃at ka kayat e dag̃ cuy eju―Jerusalém ka bewiat e dag̃, Gaza ka kayat e dag̃. Ixe e uk'a'ũmat tag̃ opop — io'e Filipe be. — Hm hm — io'e. — Cum puk õn — io'e. ");
INSERT INTO myu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dao ma o'ju. Ixe e dag̃ o'ju. Etiópia eipi bewiat Deus ekawẽntup cocom oeku ixe e dag̃. Jepitpin o'e jeipi kay―Etiópia eipi kay. Ya'õbuyxi jĩjãat osunuy. Etiópia eipi kukukat buywatwat'ukat osunuy. Etiópia eipi kukukat ayacat osunuy. Ipi kukukat putet Candace i osunuy. Etiópia eipi kukukat edinheiro kukukat osunuy. Kuy bima o'ju Jerusalém ka be “Ẽn xipat cĩcã oxe” i'e am Deus pe. ");
INSERT INTO myu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jepitpin o'e Jerusalém ka bewi. Jeipi kay jepitpin o'e―Etiópia eipi kay. Cavalo emumupuxikpuxik tag̃ oeku. Xik'i osunuy jabikbikap pe Deus ekawẽntup cocom ya'õberen. Kuyjeatup cocom oeku Deus ekawẽn muwẽnuwẽn'ukat emudupmubararaktup cocom―Isaías emudupmubararaktup cocom. ");
INSERT INTO myu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","— Ixe ecarro juy etomuixik — Deus biõg̃buk o'e Filipe be. ");
INSERT INTO myu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe o'jedau carro nomuju. Ag̃okatkat a'õ o'ya'ĩjojo ya'õberen tupcocom puye. Isaías emudupmubararaktup cocom oeku. — Ibapuk tu exe ig̃odup ekawẽn? — io'e Filipe Etiópia eipi bewiat pe. ");
INSERT INTO myu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","— Ka'ũma. Cekawẽn pa'arẽm oxe — io'e. — Apẽntak kuka cekawẽn pabuk o'e oxe? — io'e. — Kaka g̃u omutaybinat ijoce — io'e. — Ejot cuy ijoma — io'e. — Eõm cuy wecarro be — io'e. — Xik'i abik oxe — io'e Filipe be. ");
INSERT INTO myu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jesus muwẽg̃aptup cocom oeku. Imẽn e'em ig̃o dup: Yaoka am tujowan pima, ovelha wa g̃u, i. Imẽnpuxim ixe dak o'tõn g̃u, i. Mũg̃ ma e'em cordeiro jexeedap'uk'ug̃ pima, i. Imẽnpuxim ixe dak mũg̃ ma osunuy ikẽrẽm cĩcã ip o'jukuk pima, i. ");
INSERT INTO myu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Warẽmtag̃ cĩcã ip o'jukuk, i. “Ikẽrẽat kug̃ teku” io'e ip napa ma, i. Ka'ũma ma o'e “Ikẽrẽat kug̃ g̃u” i. O'jomuymuy jĩjã ip, i. Ipotpet g̃u jeenuy, o'yaoka ip puye, i. Imẽn e'em ig̃o dup. Ig̃o dup cocom oeku ixe Etiópia eipi bewiat. ");
INSERT INTO myu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","— Apẽg̃ape ijop ibararakat ijudup pe? — io'e. — Abu-muwẽnuwẽn Deus ekawẽn muwẽnuwẽn'ukat ijudup pe? — io'e. — Jewemuwẽnuwẽn tu? Wara'acat muwẽnuwẽn g̃u xe'e? — io'e Filipe be. ");
INSERT INTO myu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipe o'g̃ukũyjo mẽg̃apeku tedupeku ibararak opop iam. Kawẽn idipat o'g̃uwẽn cebe. Jesus o'g̃uwẽn cebe. ");
INSERT INTO myu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","G̃ebuje idibi o'tidobuxik ip e dag̃ cucum pima. — Ak'i juy ece — io'e Etiópia eipi bewiat Filipe be. — Jodiku idibi! — io'e. — Cedag̃ tu ewebe omubatisaan? — io'e. ");
INSERT INTO myu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","— Jesus kay etabut pima, cedag̃ kuka o'e — io'e. — Wetabut Jesus Cristo Deus ipot iap kay — io'e. ");
INSERT INTO myu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Etiópia eipi bewiat jecarro o'g̃uycũ. O'kop Filipe eju. O'kop ip idibi be. Filipe Etiópia eipi bewiat o'g̃ubatisaan. ");
INSERT INTO myu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Idibi bewi ceu buje ip Deus biõg̃buk Filipe o'tujujẽm ibocewi. Imẽnpuye Etiópia eipi bewiat waram g̃u Filipe o'jojojo. Inaka o'ju ma'g̃uto e dag̃ jeka kay. Icokcok cĩcã osunuy. ");
INSERT INTO myu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipe o'jebapuk Azoto ka be. Ibocewi pug̃ ka dag̃ g̃u oeku―ade ka dag̃. Kawẽn idipat muwẽnuwẽn oekuku soat kaka dag̃. Cesaréia ka be o'ju ibocewi. ");
INSERT INTO myu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo o'ju Judeuyũ epaĩyũ kukukat kay, itakoma jĩjã wuykukukat Jesus a'õkayayũ kay buye. Warẽmtag̃ suykukukat Jesus a'õkayayũ kug̃ oekukuku. Taomũn ojuy ip oekukuku. Soat aokaka ojuy oekukuku. Imẽnpuye o'ju Judeuyũ epaĩyũ kukukat kay. O'jekawẽn ceweju. ");
INSERT INTO myu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","— Cum õn Damasco ka kay — io'e cebe. — Cartadup cuy etupũm owebe — io'e. — Damasco ka be bime otuptujowat Judeuyũ e'aweroroap'a kukayũ be―Deus eju kawẽnwẽnap'a kukayũ be. Ixeyũ aco'i Jesus a'õkayayũ g̃ubapuk owebe carta dup ũm puje — io'e. — Tobuxik puje otujupit ip ijoce Jerusalém ka be — io'e. — Ekay ip otujupit. Taomũnmũn ip otujupit―ag̃okatkayũ, aoyũ dak — Saulo o'e. — Ha'a — io'e. — Eyju juy — io'e. — Imẽn cuy ece — io'e. ");
INSERT INTO myu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco ka kay Saulo o'ju. E dag̃ pima Damasco ka tẽg̃ pima, dao ma kabi bewiat ekabia oikabia. Yakokoreren kabia jĩjã o'e. ");
INSERT INTO myu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akoh! O'jeako. O'at ipi ju jeakoat pibun. G̃ebuje wuykukukat o'jekawẽn Saulo eju. Saulo kabi kadiwiat a'õ o'ya'ĩjojo. — Saulo — io'e. — Apẽnpuye ẽn warẽmtag̃ okug̃? — io'e―kabi beat o'e. ");
INSERT INTO myu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","— Abu ẽn tak, Kariwa? — io'e. — Ekukukat Jesus õn — io'e. — Warẽmtag̃ ma ẽn okug̃ — io'e. — Ẽn ma juk adi ipiat esupi'ajojoat owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","— E'ãy — io'e Saulo be. — Ikabog̃atka be juy eõm. Iboka be bima, ag̃okatkat og̃udot ekay. Apẽn ẽn em iam cuy jemukũyjo — io'e wuykukukat. Imẽn kabi beat o'jekawẽn Saulo eju. ");
INSERT INTO myu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Imẽnpuye cewejuayũ o'jecũcũ jĩjã ip. O'jekõbidaekug̃ ip jeparara pibun. Mũg̃ ma ip o'e. Kabi kadiwiat a'õ o'ya'ĩjojo ip. Imẽnpit o'jojojo g̃u ma ip. ");
INSERT INTO myu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo o'ãy ipi juwi. Wedak. O'jetaewedakwedak. Imẽnpit ijojom g̃u. Imẽnpuye cewejuayũ iba com ma o'tujowat Damasco ka be. ");
INSERT INTO myu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ebapũg̃ kabia ibo ka be osunuy ijojom g̃u. Jekõnkõn g̃u osunuy, tikõnkõn g̃u dak. ");
INSERT INTO myu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wuykukukat o'jebapuk Ananias kay cexeybi. Ananias Damasco ka be osunuy. Jesus kay itabut osunuy. Wuykukukat o'jekawẽn cebe cexeybi. — Ananias — io'e. — Ajo, okukukat? — io'e. ");
INSERT INTO myu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","— Uk'a ukpibubu dag̃ cuy eju―cũg̃at ka ukpibubu dag̃ — io'e. — Ag̃okatkat cuy ejokudada iboce―Tarso ka bewiat — io'e. — Ibutet Saulo i — io'e. — Judas duk'a kay juy eju — io'e. — Saulo omuy ixe duk'a be. Kawẽnwẽn oweju. ");
INSERT INTO myu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ixe juk ag̃okatkat o'jojojo jexeybi. Ixe ag̃okatkat putet Ananias i osunuy cexeybi — io'e. — Ananias o'jewebumõg̃ yajeje itada am iap o'jojojo jexeybi — io'e. — Soat iboap o'jojojo jexeybi — wuykukukat o'e Ananias pe. ");
INSERT INTO myu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","— Okukukat, odaobu'u — io'e. — Oparara oce. Obureyũ kuy omukũyjo apẽn ixe ag̃okatkat e'em iam — io'e. — “Saulo juk adi ipiat o'supi'ajojoat Jesus a'õkayayũ be―Jerusalém ka watwat pe,” i juk o'e ip owebe — io'e. ");
INSERT INTO myu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","— “Ixe Paulo oajẽm ijoce paĩyũ kukukayũ a'õbi,” i'e'em ip owebe — io'e Ananias. — “Ixe oajẽm wuydaomũn ãm―Jesus eju kawẽnwẽn'ukayũ daomũn ãm,” i'e'em ip owebe — io'e Ananias. ");
INSERT INTO myu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","— Epararam g̃u juy eg̃uy — io'e. — Eju juy cekay — wuykukukat o'e. — Õn ma ixe Saulo otaẽ kapik am owebeam. G̃axin ma ixe omuwẽn adeayũ be―Judeu'ũmayũ be, ipi kukukayũ be dak, Judeuyũ be dak — io'e. ");
INSERT INTO myu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","— “Ẽn cuy ipiat ecesupi'ajo jĩjã ẽn wekawẽn muwẽnuwẽn puye,” i oce kuy cebe — wuykukukat o'e Ananias pe. ");
INSERT INTO myu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias o'ju Saulo kay. Judas duk'a be o'ju. Jay. Oajẽm. Cereg̃. Oõm. Jebu o'jebumõg̃ Saulo abi jeje. — Tapu — io'e. — Ẽn okitpit — io'e. — Wuykukukat a'õbi ojot ekay — io'e. — Jesus o'jebapuk ekay ijop ka kay ajẽm pima — io'e. — Ixe ma omudot ekay — io'e. — Waram etada am omudot. Deus biõg̃b