﻿USE sofia;
DROP TABLE IF EXISTS sofia.myk_vpl;
CREATE TABLE myk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES myk_vpl WRITE;
INSERT INTO myk_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Caŋa ɲii lemu ni Yawutuu pu wo fanha ki bye kiirikɔɔn pu keŋɛ ni ge, xuugo ka ya pa jé fiige ki ni lee caŋa ɲii li ni. A Bɛtilɛhɛmu shɛn ná wa di yìri ni wu shɔ ni wu jalaa shuun ni Zhude fiige ki ni, na shɛ tatɛɛngɛ sha Mowabu fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Wee ná wu mɛgɛ ki bye na Elimelɛki, wu shɔ wu mɛgɛ di ɲɛ na Nɔmi, ja wa mɛgɛ di ɲɛ na Makilɔn, wusama mɛgɛ di ɲɛ na Kilijɔn. Efirata shi shɛɛn pu bye pii na foro Zhude fiige ki ni Bɛtilɛhɛmu ni. Ba p’a nɔ Mowabu fiige ki ni wɛ, na diin wà. ");
INSERT INTO myk_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","A Nɔmi poo Elimelɛki wu ba xhu, na Nɔmi ni jalaa shuun wu yaha wà. ");
INSERT INTO myk_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","A pee jalaa p’i ba Mowabu shi wu wo pushaa shuun wa leŋɛ. Cee wa mɛgɛ ki bye na Ɔripa, wa mɛgɛ di ɲɛ na Wuruti. A p’i yèe kɛ shishiin pye wà. ");
INSERT INTO myk_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Lee kadugo na a Makilɔn ni Kilijɔn wu bɛ di ba xhu. Ayiwa, a Nɔmi di bɔɔn wu poo we, ni wu jalaa shuun wu ni. ");
INSERT INTO myk_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ayiwa, ba Nɔmi ya pa logo na Tɛhɛnɛ Baa Kilɛ ya wu shi shɛɛn pu tɛgɛ, na ɲɔlige kan pu mu na wu yaha Mowabu fiige ki ni wɛ, a wu ni jalaa cèe p’i gbegele na p’i yìri wà, p’a gaaŋi wu to fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Wee tuun wu ni, xuu wemu ni pu bi tiin ge, a wu yìri wee xuu wu ni. A jalaa cèe shuun wu bɛ di daha wu na. A p’i koo lɔ na guri na gaaŋi Zhuda fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Wee tuun wu ni a Nɔmi di wu jalaa cèe shuun wu pye: «Yi shuun wu bɛɛri pu kuri, wa bɛɛri w’a se wu nu puga. Y’a saama pye nɛ na, piimu p’a xu ge, na saama pye pee bɛ na. Tɛhɛnɛ Baa Kilɛ wu shɛ ɲɔ yi bɛ na mu lee ɲɔgana li na! ");
INSERT INTO myk_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Tɛhɛnɛ Baa Kilɛ wu shɛ ɲaɲiŋɛ kan yi bɛɛri nigin nigin wu mu yi namaa gbaya ni!» A wu xhɔ na ɲɔsɔɔnrɔ fò kan pu mu. A p’i sipyaa le na suu. ");
INSERT INTO myk_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","A p’i Nɔmi pye: «Ahayi! Wèe na daha ma na da gaaŋi fo ma shi shɛɛn pu wo fiige ki ni.» ");
INSERT INTO myk_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","A Nɔmi di pu pye: «Na nagoo, yi kuri! Ɲaha na y’a da binnɛ da se ni na ni wɛ? Jire n’a da ba gan sanha jalaa piitiilee mu pee pu ta ɲɛri yi namaa laa? ");
INSERT INTO myk_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yi kuri y’a se na nagoo! Y’a se! Nɛ lɛ toro gbajiire tàan. Ali ná ɲɛhɛ da ba bye nɛ mu niɲaa yɛ pyaa, na jo nɛ dà li na jo nɛ na ba funaŋaa kii se, ");
INSERT INTO myk_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ta yee bi da zhe shɛgɛ na gbaya ni, yi na yere fo pee ba lɛ, p’i na yi leŋɛ pye pu cèe gɛ? Ahayi, na nagoo! Kanhama pemu pu wa nɛ na ge, p’a soro fo xuuni na toro yee wo pu tàan, bani Tɛhɛnɛ Baa Kilɛ ya wu keŋɛ ki fanha digi nɛ na. ");
INSERT INTO myk_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","A p’i sipyaa kii su sanha. Lee kadugo na a Ɔripa di ɲɔsɔɔnrɔ fò kan wu yashɔ wu mu, na gari, ga a Wuruti di daha yaha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","A Nɔmi di ba Wuruti pye: «Ma cuun wu wii w’a kari wu puga shɛɛn ni wu pɛɛŋɛ yaŋmuyɔ yi yíri. Ma bɛ wu kuri m’a se wu fɛni.» ");
INSERT INTO myk_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ga a Wuruti di jo: «Ma ganha bu na kɔri, fo di laha ma na di guri ma fɛni wɛ! Bani xuu xuu ni m’a gaaŋi ge, wà nɛ bɛ w’a da se. Xuu xuu ni m’a da diin ge, wà nɛ bɛ w’a da diin. Piimu pu ɲɛ ma wo shi shɛɛn pu ge, pee na bye nɛ bɛ wo shi shɛɛn. Wemu wu ɲɛ ma wo Kilɛ wu ge, wee na bye nɛ bɛ wo Kilɛ we. ");
INSERT INTO myk_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Xuu bɛɛri ni m’a shɛ xhu ge, wà nɛ bɛ w’a da xhuu, p’i na le wà. Kaa latii bu nɛ waa laha mu na xu kadugo na, Tɛhɛnɛ Baa Kilɛ wu kanhama nigbɔ shan na ɲuŋɔ ni!» ");
INSERT INTO myk_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ba Nɔmi ya Wuruti ta w’a nɔrɔ yaha wu na lee nɔrɔgana li na wɛ, wu ya yaaga jo nige wɛ. ");
INSERT INTO myk_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Wee tuun wu ni a p’i gari mu shiizhan fo na shɛ nɔ Bɛtilɛhɛmu ni. Ba p’a nɔ jé wà wɛ, a lee di kulo li shɛɛn pu bɛɛri fo. A cèe p’i ganha na yu: «Nɔmi w’a sii tii pye we ya?» ");
INSERT INTO myk_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","A Nɔmi di pu ɲɔ shɔ na: «Yi ganha ba na pyi nige Nɔmi wɛ (Nɔmi kɔ́ri ɲɛ fɛrɛmɛ fɔɔ), ga y’a na pyi Mara (lee kɔ́ri ɲɛ kanhama fɔɔ), bani Se Bɛɛri Fɔɔ ya kanhama shan nɛ ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Tuun wemu ni nɛ foro naha na gaaŋi ge, nɛ bye yara fɔɔ, ga a Tɛhɛnɛ Baa Kilɛ di shɛ nɛ kewaya wo kuruŋɔ na pa leŋɛ. Ɲaha na yi na pyi sanha Nɔmi na Tɛhɛnɛ Baa Kilɛ yaha w’a ŋmahana ɲɛri nɛ fɛni wɛ? Se Bɛɛri Fɔɔ w’a bɔɔngɔ shan nɛ ɲuŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ayiwa, mu Nɔmi ni wu ja shɔ Mowabu shi shɛn Wuruti w’a kuri pa mu lee pagana li na na yìri Mowabu fiige ki ni. Ɔrijɛ shinma wu wo yalɔɔrɔ ti lɔduun ni p’a nɔ Bɛtilɛhɛmu ni. ");
INSERT INTO myk_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nɔmi poo wu puga shɛn wa bye wà. Ná baraga wo wu bye wii, na ɲɛ yara fɔɔ na foro Elimelɛki wo kpuun li na. Wee mɛgɛ ki bye na Bowazi. ");
INSERT INTO myk_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Caŋa ka a Mowabu shi shɛn Wuruti wu ba Nɔmi pye: «Na yaha di shɛ kɛrɛyɛ yi ni, wa bu shɛ ɲuŋɔ ɲaari na na, di da shinma furi weefɔɔ fɛni. A Nɔmi di wu pye: «Ta se na poro!» ");
INSERT INTO myk_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Wee tuun wu ni a wu gari tɛgɛ ka ni, na shɛ ganha na shinma wu furi faapyii pii fɛni. Li kaɲudanga a kee tɛgɛ k’i shɛ da Bowazi wogo, Elimelɛki wo kpuun shɛn wa. ");
INSERT INTO myk_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ayiwa, a Bowazi di ba yìri Bɛtilɛhɛmu ni na nɔ, na faapyii pu pye: «Yi faabye! Tɛhɛnɛ Baa Kilɛ wu pye ni yi ni!» A p’i wu ɲɔ shɔ na: «Uun faabye! Tɛhɛnɛ Baa Kilɛ wu duba ma mu!» ");
INSERT INTO myk_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Lee kadugo na a Bowazi di faapyii pu ɲahagbaa fɔɔ wu yiri na wu pye: «Le cebilere le di ɲɛ jɔgɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","A faapyii pu ɲahagbaa fɔɔ wu wu ɲɔ shɔ na: «Mowabu shi shɛn cee wemu w’a taha Nɔmi na na pa na yìri Mowabu fiige ki ni ge, wee wu wa. ");
INSERT INTO myk_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","W’a nɛ ɲɛɛri na nɛ wu wu yaha wu da furi shinmakɔɔn pu kadugo yíri kalapɔhɔɔ ki tɛ ni. Fo ɲisɔɔgɔ ki na w’a pa. Wu di pa ge, wu sanha ŋmɔ wɛ, fo nimɛ yɛ w’a shɛ ŋmɔ jɛri.» ");
INSERT INTO myk_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","A Bowazi di Wuruti pye: «Na poro, niwegee shan! Ma ganha bu shɛ shinma fugi nige tɛgɛ katii ni wɛ! Ma ganha bu laraga kɔn nahamɛ na wɛ! M’a gori naha ni na wo kapyebyezhaa pu ni! ");
INSERT INTO myk_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ta pu wii, pu ba xuu wemu kɔɔn, ma da furi wà pu fɛni! Nɛ yi jo na kapyebyii pu mu jo wa ganha bu nɔ ma na wɛ. Waga ba ma ta, m’a fulo kuzhɔyɔ yi na, m’a gba kapyebyii pu wo lokogo ki ni!» ");
INSERT INTO myk_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Wee tuun wu ni a Wuruti di nuguro sin Bowazi fɛɛ ni, na wu pye: «A nɛ bye dii na fɛrɛmɛ ta mu ɲaha tàan, fo mu ya ɲuŋɔ ɲaari nɛ na wɛ, nɛ wemu wu ɲɛ nabun ge?» ");
INSERT INTO myk_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","A Bowazi di jo: «Mu ya lemu bɛɛri pye ma yashɔ wu mu ma poo wu nixhugo na ge, ni mu ya laha ma to we ni ma nu wu tàan, na yìri laha ma fiige ki bɛ ni, na ba shi watii wo fiige ni, kee kemu ki ɲɛ mu bi sanha kee cɛ-ɛ ge, p’a yee bɛɛri ɲaha jo nɛ mu. ");
INSERT INTO myk_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Lemu m’a pye ge, Tɛhɛnɛ Baa Kilɛ wu ma saraa lee na! Tɛhɛnɛ Baa Kilɛ wu saraa ɲɔfaŋa wo kan ma mu, Izirayɛli wo Kilɛ we, wee wemu wo kapaŋa nɔhɔ ni m’a pa lara ge. ");
INSERT INTO myk_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","A Wuruti di wu pye: «Di fɛrɛmɛ ta ma ɲaha tàan na kafɔɔ! M’a ma kapyebyezhɔ wu luu ɲiŋɛ, na kafilasaama jo ni wu ni, na ta mu kapyebyezhaa pu d’a pɔrɔ bɛ nɛ na.» ");
INSERT INTO myk_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ba liduun w’a pa nɔ wɛ, a Bowazi di wu pye: «Fulo, ma da li, m’a ma buuri wu niŋɛ shiga ki ni ma li!» Wee tuun wu ni a Wuruti di diin shinmakɔɔn pu kabanugo. A Bowazi di shinmapya nigaaga ka kan wu mu. A Wuruti di li fo na din, na kisaŋa kɛmɛ yaha. ");
INSERT INTO myk_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ba w’a pa guri shinma wu ɲɔ kɔn na furi wɛ, a Bowazi di wu kapyebyii pu pye: «Yi wu yaha wu da furi shinmapɔhɔɔ ki bɛ tɛ ni, wa ganha bu yaaga jo ni wu ni wɛ! ");
INSERT INTO myk_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Y’a shinma kaya ya bɛ shaan ɲiŋɛ na kɔnhɔ wu da yee bɛ luu! Yi ganha ba wu zɔ yu wɛ! ");
INSERT INTO myk_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","A Wuruti di shinma wu fugi Bowazi wo tɛgɛ ki ni fo na shɛ caŋa ki xɔ. Wemu w’a fugi ta ge, a wu wee sa. A wee di bɛ ni kiloo kɛlɛɛ taanri (30) shishiin ni. ");
INSERT INTO myk_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","A wu ba ni wee shinma wu ni puga, na ba wu shɛ wu yashɔ wu na. A Wuruti di wu caŋa yalige kisaŋa bɛ yeege, na ki kan Nɔmi mu. ");
INSERT INTO myk_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","A Nɔmi di wu yege na: «Jɔgɔ wo tɛgɛ ni ma d’a we shinma we bɛɛri fugi niɲaa wɛ? Tɛgɛ kekɛ ni ma di bye wɛ? Sipya wemu w’a ɲuŋɔ ɲaari ma na ge, Tɛhɛnɛ Baa Kilɛ wu duba weefɔɔ mu!» Ayiwa, Wuruti ya labye wu pye na caŋa ki xɔ ná wemu kɛrɛyɛ ni ge, a wu yi bɛɛri ɲaha jo wu yashɔ wu mu, na wu pye na wee ná wu mɛgɛ ki bye na Bowazi. ");
INSERT INTO myk_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","A Nɔmi di wu ja shɔ wu pye: «Tɛhɛnɛ Baa Kilɛ wu duba wee ná wu mu! Bani w’a wu saama pu pyi wèe na ma na jo ba w’a pu pyi xuu pu bɛ na wɛ.» A wu jo sanha na: «Wèe cebooloo piimu p’a yaa na kasɛɛgɛ yaha wèe na, na wèe ɲuŋɔ wolo ge, wee wa wu ɲɛ Bowazi.» ");
INSERT INTO myk_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ayiwa, a Mowabu shi shɛn Wuruti wu jo sanha: «W’a nɛ pye sanha bɛ na: ‹Ta furi na wo shinma wu kɔnvɛɛ pu fɛni fo pu ba shɛ shinma wu bɛɛri kɔn xɔ.›» ");
INSERT INTO myk_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","A Nɔmi di Wuruti pye: «Lee kunni ya ɲɔ na poro, ta se m’a ma wo labye wu pyi ni wee wo kapyebyezhaa pu ni. Lee funŋɔ ni ma wa da zhɛ nige watii wo tɛgɛ ni, di zhɛ kanhama pa nɔ mayɛ na wɛ.» ");
INSERT INTO myk_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wee tuun wu ni a Wuruti di ganha na se na shinma wu furi ni Bowazi wo kapyebyezhaa pu ni fo na shɛ ɔrijɛ ni alikama yalɔɔrɔ ti pye t’a xɔ. A wu gori yaha wà wu yashɔ wu taan. ");
INSERT INTO myk_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Caŋa ka Wuruti yashɔ Nɔmi ya pa wu pye: «Na poro, n’a da xuu wa sha ma mu kɔnhɔ m’a fɛrɛmɛ ta. ");
INSERT INTO myk_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Bowazi wemu wo kapyebyezhaa ni m’a bi labye wu pinnɛ na byi ge, wèe ceboro wu ɲɛ wii. Wee w’a wu wo shinma shuu fuu niɲaa piige. ");
INSERT INTO myk_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Wee tuun wu ni yìri m’a wuu, m’a nudanga sìnmɛ pa tire, m’a ma fazaaya yi le, m’a shɛ shuu li na. Ga ma ganha bu mayɛ shɛ wu na na wu ta wu sanha li na gba wɛ. ");
INSERT INTO myk_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Wu ba sinnɛ tuun wemu ni, m’a wu tasinnɛgɛ ki kemɛ sɛɛri xuuni, m’a fulo wu na, m’a wu fatɔŋɔ ki laha wu tɔɔyɔ yi na, m’a sinnɛ wu tɔɔyɔ yi ni. M’a yaa na lemu pye lee kadugo na ge, wuyɛ pyaa na yee saya ɲaha jo ma mu.» ");
INSERT INTO myk_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","A Wuruti di wu ɲɔ shɔ na: «Keree kiimu bɛɛri m’a jo na mu ge, n’a da zhɛ ki bɛɛri pye.» ");
INSERT INTO myk_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","A Wuruti di gari shuu li na, wu yashɔ w’a keree kiimu bɛɛri jo wu mu ge, a wu shɛ kee bɛɛri pye. ");
INSERT INTO myk_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","A Bowazi di ba li, na gba a wu funŋɔ di sii taan xuuni, a wu gari na shɛ sinnɛ wu ɔrijɛ shinmapya wu tàan. A Wuruti di beele fulo wu na, na fatɔŋɔ ki laha wu tɔɔyɔ yi na, na sinnɛ wu tɔɔyɔ yi ni. ");
INSERT INTO myk_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ba ɲiŋɛ k’a pa ɲi wɛ, a Bowazi di ba gburogi yìri, na joŋɔ wii wu tɔɔyɔ ni wɛ, na cee wa nizinnɛgɛ ta wà. ");
INSERT INTO myk_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","A wu jo: «Jɔgɔ wi wɛ?» A cee wu jo: «Nɛ Wuruti wi, ma kapyebyezhɔ we! Ma fatɔŋɔ ki tɔ na na, bani wèe ceboro wemu w’a yaa na wèe ɲuŋɔ wolo ge, wee mu ɲɛ. ");
INSERT INTO myk_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","A Bowazi di wu pye: «Wuruti, Tɛhɛnɛ Baa Kilɛ wu duba ma mu! Le m’a pye mɛ nimɛ ge, lee ya li shɛɛ na m’a pye ɲɔmɛɛ fɔɔ ma yashɔ wu shizhaa na na ye taashiinɛ li bɛ na. Bani mu bi da zii daha lɛvɛɛ p’a nɔhɔ ni, pu kabyaa fɛɛ, kelee pu la baa fɛɛ. ");
INSERT INTO myk_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ayiwa nimɛ, ma ganha bu fya wɛ na poro. Ma bu kaa bɛɛri jo na mu, lee n’a da bye ma mu. Bani pu bɛɛri ya li cɛ na mu ya pye cee wemu ya tii ge. ");
INSERT INTO myk_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Can wu ɲɛ wii, nɛ kunni ɲɛ yee ceboro, wemu ya yaa na mu ɲuŋɔ wolo ge, ga yee ceboro wa ɲɛ wà, ɲuwuuro t’a wee tɛɛŋɛ na ye nɛ na. ");
INSERT INTO myk_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Shɔn naha! Di ba shɛ wee ná wu pɛrɛgi ɲiga ɲisɔɔgɔ na, wu bu da wu na da zɔɔ wu ma ɲuŋɔ wolo. Wu bu shɛ sɔɔ, wu na li pye. Wu bu shɛ li she, n’a da ɲɔmɛɛ lɔ ma mu, jo nɛ na ma ɲuŋɔ wolo Tɛhɛnɛ Baa Kilɛ ɲìi wo wu mɛgɛ na. Sinnɛ naha fo ɲiga ba shɛ mugi! ");
INSERT INTO myk_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Wee tuun wu ni a Wuruti di sinnɛ Bowazi tɔɔyɔ yi ni fo na shɛ kpɛɛngɛ pye ki na woni. A wu ba sɔɔ yìri na kpɛɛngɛ ki ta ki sanha nɔ wa wu wa cɛ wɛ. Bani Bowazi bi wu pye na wu ganha bu sipya wa shishiin yaha wu li cɛ na cee wa w’a pa shuu li na wɛ. ");
INSERT INTO myk_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ba w’a yìri na giin da gaaŋi wɛ, a Bowazi di wu pye: «Pa ni ma fadegbɔhɔ ki ni! M’a ki co xuuni!» A wu ki co xuuni, a Bowazi di ɔrijɛ shinma kiloo kɛ ni kaguro shishiin le ki ni, na wu tugo ki taan, na ganha na gaaŋi kanha ki ni. ");
INSERT INTO myk_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ba Wuruti ya shɛ nɔ wu yashɔ wu na wɛ, a wee di wu yege na: «Dii yi d’a shɛ da wɛ porofɔɔ we?» Lemu bɛɛri Bowazi ya pye wu mu ge, a wu lee bɛɛri paari wu yashɔ wu mu. ");
INSERT INTO myk_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","A wu wu yashɔ wu pye sanha: «Wee w’a we ɔrijɛ shinma kiloo kɛ ni kaguro we kan nɛ mu, bani w’a bi jo na nɛ kewaya wo ya yaa na kuri pa jé mu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wee tuun wu ni a Nɔmi di wu pye: «Porofɔɔ we, tiin naha fo kii keree kii ba shɔɔnri shɔɔnrigana lemu na, bani wu ya kii keree kii shɔɔnri niɲaa wɛ, wu ɲaha da ga ɲiŋɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","A Bowazi di gari kulo li tajege ki ɲɔ na, xuu wemu ni p’a ma keree ki shɔɔnri ge, a wu shɛ diin wà. Bowazi bi ná wemu kaa jo Wuruti mu na ɲuwuuro t’a wee tɛɛŋɛ xuuni ge, a wee di ba nɔ na doroo. A Bowazi di wu pye: «Ee! Shɛn wefɔɔ, gbara naha, m’a diin!» A ná wu fulo, na diin. ");
INSERT INTO myk_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Wee tuun wu ni a Bowazi di kulo li nɔhɔlɛɛ kɛ wa ɲaha bulo, na pee pye na pu bɛ pu pa diin. A pu bɛ di ba diin. ");
INSERT INTO myk_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ayiwa, ɲuwuuro t’a ná wemu tɛɛŋɛ xuuni ge, a wu wee pye: «Nɔmi kunni ya yìri Mowabu fiige ki ni na pa, m’a lee cɛ. W’a li shɛ na wee da wù ceboroná Elimelɛki wo tɛgɛ ki pɛrɛ. ");
INSERT INTO myk_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Nɛ jo di yi jo ma mu, jo ma ki shɔ kulo li nɔhɔlɛɛ pee, ni sipyii pusamaa bɛɛri ɲii na piimu bɛɛri pu wa naha ge. Ma bu da ma na da wu ɲuŋɔ wolo, m’a wu ɲuŋɔ wolo! Ma shiin bu da m’a da wu ɲuŋɔ wolo wɛ, m’a yee bɛ jo na ɲii na. Bani ɲuwuuro ti bu laha mu na, nɛ na t’a da nɔ.» A ná wu jo: «Uun, nɛ na wu ɲuŋɔ wolo.» ");
INSERT INTO myk_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","A Bowazi di jo sanha: «Ayiwa, ma bu tɛgɛ ki shɔ Nɔmi mu, wee tuun wu ni m’a yaa ma Mowabu shi shɛn Wuruti bɛ ɲuŋɔ wolo, kɔnhɔ shi di ba da wu poo wu nixhugo ki mu, wemu na ba bye wu cɛn wu lɔvɔɔ ge.» ");
INSERT INTO myk_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","A ná wu jo: «Wee tuun wu ni, ni li ɲɛ mu, n’a da já wu ɲuŋɔ wolo nige wɛ, bani nɛ bu lee pye, n’a da jaagi shan nayɛ pyaa wo cɛn wu na. Wu ɲuŋɔ wolo mayɛ mu, lee bɛ wɛ n’a da já wɛ. ");
INSERT INTO myk_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Taashiinɛ ni Izirayɛli ni, wa bu wa keŋɛ yaaga shɔ kelee na ma ɲuwuuro faa; kalɛɛ lemu li bi lee fiinŋɛ ge, lee li wa mɛ: Wa wu da wu wo tanhaŋa wolo, na ki kan wa mu. Lee ma li shɛ na lemu ɲɔ pu shuun wu bɛɛri ya wo ge, na p’a bɛ li ɲuŋɔ ni.) ");
INSERT INTO myk_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ná wemu na ɲuwuuro ti bi nɔ ge, a wee di Bowazi pye: «Wu ɲuŋɔ wolo!» A wu wu tanhaŋa wolo na kan wu mu. ");
INSERT INTO myk_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ayiwa, sipyii piimu pu bye wà na fara nɔhɔlɛɛ pu na ge, a Bowazi di pu bɛɛri pye: «Yee pu wa li sɛɛrɛɛ niɲaa na jo yaaga yaaga k’a bye Elimelɛki mu ge, ni yaaga yaaga k’a pye Kilijɔn ni Makilɔn mu ge, nɛ yee bɛɛri shɔ Nɔmi mu. ");
INSERT INTO myk_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Lee funŋɔ ni n’a da Mowabu shi shɛn Wuruti lɔ na pye na shɔ, Makilɔn ya xu na cee wemu yaha ge, kɔnhɔ shi di ba da wu nixhugo ki mu, na fara lee na, kɔnhɔ wu mɛgɛ ki ganha bu biin fɛɛfɛɛ wu cebooloo pu niŋɛ ni wu to kulo li ni wɛ. Yee pu wa lee wo sɛɛrɛɛ niɲaa.» ");
INSERT INTO myk_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ayiwa, nɔhɔlɛɛ pu fara sipyii pusamaa bɛɛri na piimu bɛɛri pu bye kulo li tajege ki ɲɔ na ge, a pu bɛɛri di jo: «Uun, wèe wa li sɛɛrɛɛ. Cee we w’a jin ma puga ki ni ge, Tɛhɛnɛ Baa Kilɛ wu wu pye ba Arashɛli ni Leya ɲɛ wɛ, pee piimu p’a Izirayɛli nagoo pu bɛɛri se ge. Kilɛ wu fanha kan ma mu Efirata shi wu ni, wu mɛgɛ nigbɔhɔ da ma mu Bɛtilɛhɛmu kulo li ni! ");
INSERT INTO myk_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Tɛhɛnɛ Baa Kilɛ wu nagoo niɲɛhɛmɛɛ da ma mu le cebilere le na, ma kpuun l’i bye Perɛzi wuu li tuugo, Tamari ya Perɛzi wemu se Zhuda mu ge.» ");
INSERT INTO myk_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ayiwa, a Bowazi di Wuruti leŋɛ. A Tɛhɛnɛ Baa Kilɛ di duba wu mu. A wu yere yacɛrɛ na, na funana se. ");
INSERT INTO myk_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","A Bɛtilɛhɛmu wo cèe p’i ganha na Nɔmi pyi: «Tɛhɛnɛ Baa Kilɛ w’a sɔni! Sipya wemu w’a da ba ma lɔ wu yere ni ma keree bɛɛri ni ge, w’a wee pye wee ya se niɲaa. Kilɛ wu mɛgɛ nigbɔhɔ da we pya we mu Izirayɛli fiige ki ni! ");
INSERT INTO myk_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","We pya we na ba ma luu ɲiŋɛ, na yere ni ma keree ni ma ni ma lɛgɛ ki bɛ ni. Ma ja shɔ we, w’a ye jalaa gbarashuun na, bani ma kaa l’a dan wu ni. Wee w’a ke ɲabige ke se ma mu. ");
INSERT INTO myk_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","A Nɔmi di pya wu co, na wu taha wu dodoŋɔ na. Wee shiin w’a wu lɔ, na ganha na wu biini. ");
INSERT INTO myk_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","A Nɔmi wo tiinɲii cèe p’i ganha na mujoŋɔɔ waa na yu: «Nɔmi ya ja ta!» Pu ni Nɔmi ni, a p’i pya wu mɛgɛ le na Obɛdi (lee kɔ́ri ɲɛ wemu w’a fungɔngɔ yɛri sipya na ge). Obɛdi w’a pye Izayi wo to we, Izayi di ɲɛ saannaa Dawuda to. ");
INSERT INTO myk_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Perɛzi wo kadugo ki sipyii pu mɛyɛ yi ye: Perɛzi w’a Ɛsirɔmu se. ");
INSERT INTO myk_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","A Ɛsirɔmu di Aramu se. A Aramu di Aminadabu se. ");
INSERT INTO myk_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","A Aminadabu di Nasɔn se. A Nasɔn di Salimɔ se. ");
INSERT INTO myk_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","A Salimɔ di Bowazi se. A Bowazi di Obɛdi se. ");
INSERT INTO myk_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","A Obɛdi di Izayi se. A Izayi di saannaa Dawuda se.");
INSERT INTO myk_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Caŋa ka Tɛhɛnɛ Baa Kilɛ ya Amitayi ja Zhonasi pye: ");
INSERT INTO myk_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","«Yìri, m’a shɛ Ninive kugbɔɔ li fɛni! M’a shɛ jo ni kulo li shɛɛn pu ni ni mujuugbɔɔ ni, bani pu kuumɔ p’a pɛlɛ ye nɛ ɲaha tàan.» ");
INSERT INTO myk_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ga a Zhonasi di yìri, na wu baa gbee Tɛhɛnɛ Baa Kilɛ ɲaha na. Lee funŋɔ ni a wu gari Zhopa suumɔ lɔhɔ ki kɔrɔyɔ yi tayerege ki ni, na shɛ kɔrɔgɔ ka ta wà kemu bi se Tarisisi ni ge. A wu jé jé pɛrɛmɛ pu kan, na jé tiin kɔrɔgɔ ki ni na gaaŋi ni pee ni Tarisi ni, kɔnhɔ wu laha Tɛhɛnɛ Baa Kilɛ tàan. ");
INSERT INTO myk_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ga a Tɛhɛnɛ Baa Kilɛ di kafɛɛgbɔhɔ ka yirige suumɔ lɔhɔ ki na. A kafɛɛgɛ k’i sii pɛlɛ fo kɔrɔgɔ ki na zhaa di gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","A kɔrɔgɔ ki kapyebyii p’i sii fya fo xuuni. A pu bɛɛri di ganha na pu kilɛlɛɛ ɲɛɛri. A p’i kɔrɔgɔ ki funŋɔ tuguro ti wolo wá lɔhɔ ki ni, kɔnhɔ kɔrɔgɔ k’i faha. Lee bi Zhonasi ta wee ya tigi kari fo kɔrɔgɔ ki maazaŋa ki ni, na shɛ sinnɛ ŋmunɔ tara wà. ");
INSERT INTO myk_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","A kɔrɔgɔ ki paavɔɔ wu gari Zhonasi fɛni, na shɛ wu pye: «Mu d’a sinnɛ yaha na ŋmunɔɔ do? Ma bɛ wu yìri m’a ma wo Kilɛ wu ɲɛɛri. La wa la ni wu na wu funŋɔ sha ni wù kaa ni, na wù ɲuŋɔ wolo, kɔnhɔ wù ganha bou gyɛɛgi wɛ.» ");
INSERT INTO myk_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ayiwa a kɔrɔgɔ ki kapyebyii p’i puyɛ pye: «Yi pa wù kagaanshaan pye, wemu wuu na ke bɔɔngɔ ke wa nɔni wù na ge, kɔnhɔ wù weefɔɔ cɛ.» A p’i kagaangaa ki shan, a Zhonasi wo kagaan l’i lɔ. ");
INSERT INTO myk_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","A p’i Zhonasi pye: «Lemu li wa ke bɔɔngɔ ke nɔni wèe na ge, lee jo wù mu. Mii mu d’a yìri wɛ? Labye wekɛ tuugo mu di wa byi wɛ? Fiige kekɛ shɛn mu di ɲɛ wɛ? Shi wekɛ shɛn mu di ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","A Zhonasi di pu ɲɔ shɔ na: «Heburu nɛ ɲɛ, Tɛhɛnɛ Baa Kilɛ nɛ bɛlɛ, Fugba Kilɛ we, wee wemu w’a suumɔ lɔhɔ ni ɲiŋɛ ki yàa ge.» ");
INSERT INTO myk_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","A wu pu pye sanha na Tɛhɛnɛ Baa Kilɛ ɲaha na wee ya fe na gbee. A p’i sii fya fo xuuni, na Zhonasi pye: «Ɲaha na ma d’a le pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","A suumɔ lɔhɔ ki lokuruyo y’i ganha na bɛlɛ na se ɲaha na, lee funŋɔ ni, a p’i Zhonasi pye: «Lekɛ wèe d’a yaa na pye mu na, kɔnhɔ lokuruyo y’i yere wɛ?» ");
INSERT INTO myk_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","A Zhonasi di pu pye: «Yi na lɔ wá suumɔ lɔhɔ ki ni, lokuruyo yi na yere, bani nɛ li cɛ jo nɛ wuu na ke kafɛɛgbɔhɔ ke wa yee taa.» ");
INSERT INTO myk_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","A kɔrɔgɔ ki kapyebyii p’i pu se bɛɛri pye, kɔnhɔ p’i kɔrɔgɔ ki paa fulo koɲɔ ki na, ga pu ya já wɛ, bani la li bi faraa lokuruyo yi bɛlɛ wu na. ");
INSERT INTO myk_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Wee tuun wu ni a p’i Tɛhɛnɛ Baa Kilɛ ɲɛɛri na: «Ee! Tɛhɛnɛ Baa Kilɛ ɲunŋɔ ɲaari wù na, ma ganha bu wù yaha wù kyɛɛgi we ná we wuu na wɛ. Ma ganha bu jaagi baa fɔɔ shishan foo yege wù na wɛ, bani lemu l’a taan mu mu ge, Tɛhɛnɛ Baa Kilɛ, lee mu ya pye.» ");
INSERT INTO myk_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Lee kadugo na a p’i Zhonasi co, na wu wá suumɔ lɔhɔ ki ni. Lee taapile li ni a lokuruyo ye ni kafɛɛgɛ ki bɛɛri di yere. ");
INSERT INTO myk_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ba lee ya pye wɛ, a kɔrɔgɔ ki kapyebyii p’i sii fya fo xuuni Tɛhɛnɛ Baa Kilɛ na. A p’i saraya wolo kan Tɛhɛnɛ Baa Kilɛ mu, na ɲɔyɔ bɛ faa wu mu. ");
INSERT INTO myk_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Wee tuun wu ni a Tɛhɛnɛ Baa Kilɛ di fyatabaaga ka pye k’a shɛ Zhonasi lɔ jɔ. A wu caya taanri ni nibiiye taanri pye kee fyatabaaga ki funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Na Zhonasi yaha fya wu funŋɔ ni, a wu wu Kafɔɔ Tɛhɛnɛ Baa Kilɛ wu ɲɛɛri na: ");
INSERT INTO myk_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","«Na nɛ yaha na kanhama pu ni, Tɛhɛnɛ Baa Kilɛ nɛ mu ɲɛɛri, a mu di nɛ ɲɔ shɔ. Na nɛ yaha xu wo nibiige ki ni, nɛ mɛɛ su mu fɛni, a mu di nɛ mɛɛ li logo. ");
INSERT INTO myk_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","M’a bi na wá suumɔ locogoŋɔ ki nɔhɔdaan. A lɔhɔ k’i na ɲuŋɔ jɔ. A suumɔ lokuruyo y’i fɔ toro na ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Nɛ bi yu jo m’a na kɔri laha mayɛ tàan. Ga nɛ na ba ma Fɛfɛɛrɛ Pɛɛŋɛ Pugbɔhɔ ki ɲa sanha. ");
INSERT INTO myk_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Suumɔ lɔhɔ k’a fɔ nɛ ɲuŋɔ jɔ fo nɛ na zhaa di xhuu. Suumɔ lɔhɔ k’a nɛ maha círi. Suumɔ lɔhɔ ki nɔhɔdaan ɲà k’a bi nɛ katige ki migile. ");
INSERT INTO myk_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nɛ bi tigi fo faaboboyo yi nɔhɔdaan. Ɲiŋɛ ki ɲɔ bi tɔ wá nɛ na ma xɔ fo badaa badaa. Ga a mu di nɛ ɲìi wo wu yeege wecogoŋɔ ki ni, Tɛhɛnɛ Baa Kilɛ, na Kafɔɔ we. ");
INSERT INTO myk_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Tuun wemu ni nɛ bi zhaa di xhuu ge, a nɛ funŋɔ di do ni mu Tɛhɛnɛ Baa Kilɛ kaa ni. A mu di nɛ ɲɛrɛgɛ ki logo na ma yaha ma Fɛfɛɛrɛ Pɛɛŋɛ Pugbɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Piimu p’a yapɛrɛɛ ki pɛlɛ ge, kee kiimu ki ɲɛ ɲuŋɔ baa ge pee ya pu wo ɲiɲaara takoro li yaha. ");
INSERT INTO myk_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ga nɛ wi ge, nɛ na ba ma masɔŋɔ yoyo cee, na saraya wolo kan ma mu. Nɛ ɲɔfaaya yemu faa ma mu ge, nɛ na ba yee bɛɛri wolo yi tɛhɛnɛ na, bani mu Tɛhɛnɛ Baa Kilɛ w’a sipya ɲuŋɔ wo.» ");
INSERT INTO myk_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Ayiwa a Tɛhɛnɛ Baa Kilɛ di jo ni fya wu ni, a wu shɛ Zhonasi tɛrɛŋɛ shan kogoŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","A Tɛhɛnɛ Baa Kilɛ di Zhonasi pye sanha wu tɔɔɲii shuun wuu ni na: ");
INSERT INTO myk_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","«Yìri, m’a shɛ Ninive kugbɔɔ li fɛni! Jomɔ pemu n’a jo ma mu ge, m’a shɛ pee yɛrɛ pye ni mujuugbɔɔ ni!» ");
INSERT INTO myk_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Wee tuun wu ni a Zhonasi di yìri, na gari Ninive kulo li ni ba Tɛhɛnɛ Baa Kilɛ ya yi jo wɛ. Kugbɔɔ li bi sii pye Ninive, ma bu jo m’a li ɲaari, cabyaa taanri ma da bye, ma na li círi. ");
INSERT INTO myk_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","A Zhonasi di caŋa nigin ɲara pye na na mujuu waa na yu: «Cabyaa kɛlɛɛ shishɛɛrɛ (40) niɲaa kadugo na Ninive w’a da gyɛɛgi.» ");
INSERT INTO myk_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","A Ninive shɛɛn di dà Kilɛ Kafila wu na. A p’i yi jo waha kulo li shɛɛn pu bɛɛri mu na pu suun le, na co nɔhɔpiire ti na, na shɛ nɔ sipyilɛyɛ yi na, a pu bɛɛri di bɔrɔyɔ fàya le. ");
INSERT INTO myk_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ba pee jomɔ p’a nɔ Ninive fanhafɔɔ wu na wɛ, a wu yìri laha wu saanra koro li na, na wu saannaa fadegbɔhɔ ki wolo yaha, na bɔrɔyɔ fàya le, na diin shɔɔnrɔ ni. ");
INSERT INTO myk_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","A saan wu ni wu fanhafɛɲii p’i we saliya we teŋɛ kan kulo li shɛɛn pu bɛɛri mu na: «Sipyii fara yapɔrɔyɔ yi na, niiyɛ fara yatɔɔpya wu na, ka shishiin ganha bu yaaga le ki ɲɔ ni wɛ. Ka shishiin ganha bu li wɛ, ka shishiin ganha bu lɔhɔ bɛ gba wɛ. ");
INSERT INTO myk_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Sipyii pu bɛɛri di bɔrɔyɔ fàya le, p’i ya le yapɔrɔyɔ yi bɛ na, pu da mɛhɛɛ suu Kilɛ fɛni, p’i daajeŋɛ jo pu kapyeguuŋɔɔ kee ni pu katiibaagaa ki na, p’i ki ɲɔ yaha. ");
INSERT INTO myk_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kilɛ bi giin wu ba bɔɔngɔ kemu nɔ wù na ge, la wa la ni wu na ba ɲuŋɔ ɲaari wù na, na wu fungɔngɔ ɲɛri, kɔnhɔ wù ganha bu gyɛɛgi wɛ.» ");
INSERT INTO myk_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ayiwa a Kilɛ di pu ɲa p’a daajeŋɛ jo, na pu kapyeguuŋɔɔ ki ɲɔ yaha. Wu bi bɔɔngɔ kemu gbegele pu kaa na ge, wu ya kee yaha nɔ pu na nige wɛ. ");
INSERT INTO myk_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ayiwa a lee di sii soro Zhonasi ni, a wu luu di sii yìri fo xuuni. ");
INSERT INTO myk_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","A wu Tɛhɛnɛ Baa Kilɛ ɲɛɛri na: «Tɛhɛnɛ Baa Kilɛ, ta ye bɛ nɛ bi jo ma na yaha na fiige ki ni wɛ? Go le na nɛ bi fe na se Tarisisi ni, bani nɛ li cɛ jo mu ɲɛ Kilɛ wemu w’a saama pyi, na ɲuŋɔ ɲaari ge. Mu luu ya yìri tɔvuyo na wɛ, ma taanɲɛɛgɛ ki bɛ d’a pɛlɛ. Mu bu bɔɔngɔ bɛ ɲaha tii wa na, kee bɛ daajeŋɛ na jé ma ni. ");
INSERT INTO myk_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ayiwa Tɛhɛnɛ Baa Kilɛ, na munaa li wolo nimɛ, bani xu ya pɔrɔ nɛ mu ɲiifɛɛrɛ ti na.» ");
INSERT INTO myk_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","A Tɛhɛnɛ Baa Kilɛ di wu pye: «Ta kaɲii wa mu mu mu wu ma luu yirige le na gɛ?» ");
INSERT INTO myk_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","A Zhonasi di foro Ninive kugbɔɔ li ni, na shɛ diin kulo li Kilɛ-nɔhɔ ki na. A wu gba wa yereŋɛ wà, na diin wee ɲimɛ ni, lemu na ba kulo li shɛɛn ta ge, na ganha na lee ɲaha wii. ");
INSERT INTO myk_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Wee tuun wu ni a Tɛhɛnɛ Baa Kilɛ di gbogo tirige ka pye k’a fin foro, na dɔ, na ɲimɛ tirige Zhonasi ɲuɲɔ na, kɔnhɔ wu funŋɔ di ɲiŋɛ wu kanhama pu na. A kee tirige ki kaa di sii taan Zhonasi ni. ");
INSERT INTO myk_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ga kee caŋa ki ɲimuguro, kpɛɛngɛ ki na ɲɔ kɔn na woni, a Kilɛ di fyɛngɛ pye k’a jé gbogo tirige ki ni, na ki li, a k’i waha. ");
INSERT INTO myk_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ba caŋa k’a pa foro wɛ, a Kilɛ di kafɛɛgɛ nivugo yaha pa na yìri Kilɛ-nɔhɔ ki na. A caŋa k’i dara Zhonasi ɲuŋɔ ki na fo wu na zhaa di jiregi. A wu xu ɲɛɛri Tɛhɛnɛ Baa Kilɛ mu, a wu jo: «Xu ya pɔrɔ nɛ mu ɲiifɛɛrɛ na.» ");
INSERT INTO myk_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","A Kilɛ di Zhonasi pye: «Ta kaɲii wa mu mu mu wu luu yirige ke gbogo tirige ke kaa na gɛ?» A Zhonasi di Kilɛ pye: «Uun! Kaɲii wa nɛ mu nɛ wu luu yirige fo na nɔ xu bɛ na.» ");
INSERT INTO myk_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","A Tɛhɛnɛ Baa Kilɛ di jo: «Mu ya ta labye wa shishiin bɛ pye ke tirige ke na kɔnhɔ k’i lɛ wɛ, ga ki ɲiɲaara d’a jé mu ni. Piige ka ni k’a fin, na xhu piige ka ni. ");
INSERT INTO myk_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Wee tuun wu ni ɲaha na mu di giin nɛ ganha bu ɲuŋɔ ɲaari Ninive kugbɔɔ li na-ɛ wɛ? Lee lemu sipyii p’a ɲɛhɛ sipyii kabɔfoŋɔɔ xhuu nigin ni kɛlɛɛ shuun (120.000) na ge, pee piimu pu ɲɛ wa ya wu kanige cɛ wolo wu kamɛnɛ ni-i ge, na fara yapɔrɔyɔ niɲɛhɛyɛ bɛ na.");
INSERT INTO myk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kirisa nɔhɔ tayirige sɛmɛ wʼa we. Yesu ya foro saannaa Dawuda shi ni, Dawuda dʼa foro Ibirayima shi ni. ");
INSERT INTO myk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibirayima wʼa Ishaaga se. Ishaaga di Yakuba se. Yakuba di Zhuda ni wu ceboronamaa se. ");
INSERT INTO myk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zhuda di Fɛrɛsi ni Zara se, pu nu wu bye Tamari. A Pɛrɛzi di Ɛsirɔmu se, Ɛsirɔmu di Arami se. ");
INSERT INTO myk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arami di Aminadabi se. Aminadabi di Nasɔn se. Nasɔn di Salimɔ se. ");
INSERT INTO myk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimɔ di Bowazi se, wu nu wu bye Araxabi. Bowazi di Obɛdi se, wu nu wu bye Wuruti. Obɛdi di Zhese se. ");
INSERT INTO myk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zhese di saannaa Dawuda se. Saannaa Dawuda di Solomani se, wee nu wu bi fɛnhɛ pye Uri shɔ. ");
INSERT INTO myk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomani di Orobowamu se. Orobowamu di Abiya se. Abiya di Azafu se. ");
INSERT INTO myk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azafu di Zhozafati se. Zhozafati di Zhoramu se. Zhoramu di Oziyazi se. ");
INSERT INTO myk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyazi di Zhowatamu se. Zhowatamu di Akazi se. Akazi di Ezekiyasi se. ");
INSERT INTO myk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiyasi di Manase se. Manase di Amɔ se. Amɔ di Zhoziyasi se. ");
INSERT INTO myk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zhoziyasi di Zhekoniya ni wu ceboronamaa se. Wee tuun wu ni a pʼi Izirayɛli sipyii pu co na kari Babilɔni ni. ");
INSERT INTO myk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pee sipyii pu na co xɔ na kari Babilɔni ni, a Zhekoniya di Salacɛli se. Salacɛli di Zorobabɛli se. ");
INSERT INTO myk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛli di Abiyudi se. Abiyudi di Eliyakimu se. Eliyakimu di Azɔri se. ");
INSERT INTO myk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔri di Sadɔki se. Sadɔki di Akimu se. Akimu di Eliyudi se. ");
INSERT INTO myk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudi di Eleyazari se. Eleyazari di Matan se. Matan di Yakuba se. ");
INSERT INTO myk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuba di Yusufu se. A Yusufu di bye Mariyama poo we. Yesu we wʼa yiri Kirisa ge, a Mariyama di wee se. ");
INSERT INTO myk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Shi wu segee kɛ ni shishɛɛrɛ wu ɲɛ Ibirayima ni Dawuda tɛ ni. Lee kadugo na a shi wu segee kɛ ni shishɛɛrɛ di bye Dawuda ni Izirayɛli shɛɛn coduun wu tɛ ni na kari Babilɔni ni. A shi wu segee kɛ ni shishɛɛrɛ di bye na lɔ wee tuun wu na na pa gbara Yesu seduun wu na. ");
INSERT INTO myk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kirisa segana li le. Wu nu Mariyama wu bi bye Yusufu curɔ. Ga na pu yaha pu sanha binnɛ ɲa wɛ, a Fɛfɛɛrɛ Munaa sefɛɛrɛ di digi Mariyama na, a wʼi yere yacɛrɛ na. ");
INSERT INTO myk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wu curɔ Yusufu wu bye sipyitiimɛ, wu funŋɔ bye wu Mariyama mɛgɛ kyɛɛgi wɛ. A wʼi li kɔn wuyɛ funŋɔ ni na wʼi tee curɔrɔ te kyɛɛgi ŋmɔhɔrɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na Yusufu yaha ni kee fungɔngɔ ki ni, a Kilɛ wo mɛlɛkɛ wa di ba wuyɛ shɛ wu na ŋmunɔgɔ ni, na yi jo wu mu na: «Dawuda ja Yusufu, ma ganha bu fya Mariyama leŋɛ na wɛ, bani Fɛfɛɛrɛ Munaa sefɛɛrɛ ni wʼa yere yacɛrɛ na. ");
INSERT INTO myk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wu na ba funana se, mʼa lee mɛgɛ le Yesu, bani wu na ba wu sipyii pu shɔ pu jurumu wu na.» ");
INSERT INTO myk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kee keree ki bɛɛri ya pye mu, kɔnhɔ Kafɔɔ Kilɛ bi yemu jo wu taatuunnɔ li wo Kilɛ tudunmɔ wu ɲɔ ni ge, yee ɲɔ di fa na: ");
INSERT INTO myk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Li wii, doɲiŋɛ fucɛri nacɛbaa na ba yere yacɛrɛ na, na funana se. Li mɛgɛ na le na ‹Emanuwɛli,›» lee kɔ́ri ɲɛ «Kilɛ ɲɛ wèe niŋɛ ni.» ");
INSERT INTO myk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ba Yusufu ya yìri ŋmunumɔ pu na wɛ, na li pye na bɛ ni Kafɔɔ wu mɛlɛkɛ wu wo kafilajo wu ni. A wu Mariyama furu pɔ. ");
INSERT INTO myk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ga pu ya pinnɛ ɲa wɛ, fo na shɛ Mariyama pye wʼa tigi wu funazhiire na. A Yusufu di pya wu mɛgɛ le Yesu. ");
INSERT INTO myk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ya se Zhude fiige ki ni, Bɛtilɛhɛmu ni, saannaa Hɛrɔdi caŋa ɲii ni. Wu nizexhɔgɔ ki na, a wɔrɔɔ cɛvɛɛ pii di ba na yìri Kilɛ-nɔhɔ na, na nɔ Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","A pʼi yegeŋɛ pye na: «Yawutuu wo saan we wʼa se nimɛ ge, mii wu wa wɛ? Wèe ya wu wɔrɔ ɲa, na wèe yaha Kilɛ-nɔhɔ ke na, na ba di ba wu pɛlɛ.» ");
INSERT INTO myk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ba saannaa Hɛrɔdi ya yee logo wɛ, a lʼi wu ɲaha wɔ fo xuuni, na fara Zheruzalɛmu shɛɛn bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A Hɛrɔdi di saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ pu bɛɛri pinnɛ, na pu yege na: «Kirisa wemu wu ɲɛ Saan ni Izirayɛli wo Shɔvɔɔ wu ge, mii wu dʼa yaa na se wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A pʼi wu ɲɔ shɔ na: «Zhude fiige ki ni Bɛtilɛhɛmu kulo li ni, bani Kilɛ tudunmɔ wʼa li ka na: ");
INSERT INTO myk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Mu Bɛtilɛhɛmu we wu wa Zhude fiige ki ni ge, mu wa Zhude fanha kulogoo ki bɛɛri nifɛnhɛfɛnhɛnɛ-ɛ dɛ, bani ɲuŋɔfɔgbɔ wa na ba foro mu ni, wee na ba wu shi Izirayɛli wu naha.›» ");
INSERT INTO myk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lee kadugo na a Hɛrɔdi di wɔrɔɔ cɛvɛɛ pu ŋmɔhɔ yiri, na pu yege xuuni, lee wɔrɔ li ɲaduun wu keree na. ");
INSERT INTO myk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na xhɔ na pu tun kari Bɛtilɛhɛmu ni, na jo: «Yi shɛ le pubinnɛ le sha xuuni. Yi bu shɛ li ɲa, yi ba yi jo na mu, kɔnhɔ na bɛ di shɛ li pɛlɛ.» ");
INSERT INTO myk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba wɔrɔɔ cɛvɛɛ pʼa saan wu jomɔ pu logo wɛ, na gari. Pʼa wɔrɔ lemu ɲa na pu yaha Kilɛ-nɔhɔ ki na ge, a lee wɔrɔ lʼi doro pu ɲaha na, fo na shɛ nɔ pubinnɛ li xuu wu ni, na yere wee xuu wu ɲuɲɔ na. ");
INSERT INTO myk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wɔrɔɔ cɛvɛɛ pʼa lee wɔrɔ li ɲa tuun wemu ni ge, na funŋɔ taan xuuni. ");
INSERT INTO myk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba pʼa jé puga ki ni wɛ, na pubinnɛ le, ni li nu Mariyama ɲa. A pʼi nuguro sin, na pubinnɛ li pɛlɛ, na pu yɛrɛyɛ ɲɔ mugi, na pubinnɛ li kan sanni, ni pɛrɛwa yaŋmuyɔ ya bɛ, yee ɲɛ nudanga yawurire, ni nudanga sìnmɛ pemu ɲɛ na mire ge. ");
INSERT INTO myk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lee kadugo na, a Kilɛ di pu kaala ŋmunɔgɔ ni na pu ganha bu guri zhɛ Hɛrɔdi yíri wɛ. A pʼi gari pu fiige ni koo latii ni. ");
INSERT INTO myk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wɔrɔɔ cɛvɛɛ pu nigaraga na a Kilɛ wo mɛlɛkɛ wa di wuyɛ shɛ Yusufu na ŋmunɔgɔ ni, na wu pye: «Yìri, mʼa baa kari ni pya wu ni wu nu wu ni Misira ni, mʼa shɛ diin wà fo di ba shɛ jo ni ma ni tuun wemu ni, bani Hɛrɔdi na ba pya wu shaa di gbo.» ");
INSERT INTO myk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A Yusufu di yìri kee piinuŋɔ ki ni, na baa ni pya wu ni wu nu wu ni, na kari Misira ni. ");
INSERT INTO myk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A pʼi shɛ diin wà fo na shɛ Hɛrɔdi pye wʼa xu. Kee keree kʼa pye, kɔnhɔ Kafɔɔ Kilɛ ya jomɔ pemu jo wu tudunmɔ wu ɲɔ ni ge, pee ɲɔ di fa na: «Nɛ na ja wu yiri yeege Misira fiige ki ni.» ");
INSERT INTO myk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛrɔdi ya li ɲa na wɔrɔɔ cɛvɛɛ pʼa wu ɲɔ faanna ge, a wu luu di yìri xuuni. A wu sipyii tun kari na pu Bɛtilɛhɛmu ni wu tàan kulogoo ki funabiire ti bɛɛri gbo, temu ti ɲɛ ti yee sanha doro shuun tàan wɛ ge, wɔrɔɔ cɛvɛɛ pʼa tuun wemu shɛ ge, na bɛ ni wee ni. ");
INSERT INTO myk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wee tuun wu ni Kilɛ tudunmɔɔ Zheremi bi yemu jo ge, a yee ɲɔ di fa. Wu bi jo na: ");
INSERT INTO myk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Sipyii ya mɛhɛɛ logo na foro Arama koomɔ pu ni: Xuguŋɔɔ ni sipyaa. Arasɛli wʼa wu nɔhɔpiire yamɛhɛɛ suu. Pu ya wu fɛhɛŋɛ ta kɔnhɔ wu luu di ɲiŋɛ wɛ, bani pʼa xu xɔ.» ");
INSERT INTO myk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɛrɔdi nixhugo na a Kilɛ wo mɛlɛkɛ wa di wuyɛ shɛ Yusufu na ŋmunɔgɔ ni, na wu yaha Misira fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A wee mɛlɛkɛ wu jo: «Yìri mʼa guri ni pya wu ni wu nu wu ni Izirayɛli fiige ki ni, bani piimu pu bi pya wu shaa di gbo ge, pee ya xu.» ");
INSERT INTO myk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A Yusufu di yìri, na guri ni pya wu ni wu nu wu ni Izirayɛli fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wʼa logo na Arikilasi wʼa tiin wu to Hɛrɔdi wu tatɛɛngɛ ki ni, na pye Zhude fiige ki saan ge, a Yusufu di fya wu ya sɔɔ na shɛ wà wɛ. A Kilɛ di wu funŋɔ to ŋmunɔgɔ ni, na wu shɛ Galile fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A wu shɛ diin kulo la ni wà lemu mɛgɛ ki ɲɛ na Nazarɛti ge, kɔnhɔ Kilɛ tudunmɔɔ pu bi yemu jo na Yesu na ba yiri Nazarɛti shɛn ge, yee ɲɔ di fa. ");
INSERT INTO myk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ayiwa, caŋa ka Yohana Batizelipye ya kari siwaga ki ni, Zhude fiige ki ni, na shɛ Kilɛ jomɔ pu yɛrɛ li ɲɔ kɔn wà. ");
INSERT INTO myk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wu bi sipyii pu yɛri na: «Yi daajeŋɛ jo yi jurumu wu na, bani Kilɛ saanra tʼa tɛɛŋɛ.» ");
INSERT INTO myk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana Batizelipye kaa Kilɛ tudunmɔɔ Ezayi bi byi na: «Mujuu lʼa fòro siwaga ki ni na: ‹Yi Kafɔɔ wu koo li yàa! Yi wu korogoo ki tii!›» ");
INSERT INTO myk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Fàya yemu yi bye Yohana na ge, yee bi yàa ni ɲɔhɔyɔ shiire ni, sɛɛgɛ di ɲɛ wu yapɔgɔ. Kabeeye ni wegeye funŋɔ sɛrɛ, yee yi bye wu ɲɔlige. ");
INSERT INTO myk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zheruzalɛmu shɛɛn, ni Zhude fiige ki bɛɛri, ni Zhurudɛn Gba wu kabanugo kulogoo ki bɛɛri bi se Yohana yíri, ");
INSERT INTO myk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na yeree pu jurumu wu na, na puyɛ kaan Yohana mu wu na batizeni Zhurudɛn Gba lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ba Yohana ya li ɲa na Farizhɛɛn, ni Sadushɛɛn niɲɛhɛmɛɛ pu bi ma na puyɛ kaan wu mu wu na batizeni wɛ, a wu pu pye: «Yee matɔn nagoo piiri, jɔgɔ wʼa yee kaala na yee pu paa Kilɛ wo loyire nibana li ɲaha na wɛ? ");
INSERT INTO myk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kapyegee kiimu kʼa li shɛɛ na yʼa daajeŋɛ jo yi jurumu wu na ge, yʼa kee pyi. ");
INSERT INTO myk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yi ganha ba yi funyɔ kɔɔn yɛ na Ibirayima wu ɲɛ yee to wɛ. Bani nʼa da yi jo yi mu, Kilɛ na já ye faakageeye ye ɲɛri na pye Ibirayima nagoo. ");
INSERT INTO myk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kacerege kʼa lɔ na xɔ, di da tiye yi niyɛ yi cere. Tige bɛɛri ki ɲɛ ki ya nagoo nizaamaa pyi-i ge, kee na ba gɔn, na ki wá na ni. ");
INSERT INTO myk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Nɛ kunni wʼa yee batizeni lɔhɔ yɛ ni. Lee wʼa li shɛɛ na yʼa daajeŋɛ jo yi jurumu wu na. Ga wa wʼa ma nɛ kadugo, wee fanha ya ɲɛhɛ nɛ wogo na. Ali na wu tanhaya ye yɛ pyaa bɛ wolo wu tɔɔyɔ na, nɛ yaa ni lee ni wɛ. Wee na ba yi batize Fɛfɛɛrɛ Munaa ni na ni. ");
INSERT INTO myk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wu shinma fɔ̀ fɔ̀ yaaga ki wa wu keŋɛ ni. Wu na ba sigiye yi fɔ̀ na wolo shinmapya wu ni. Wu na ba shinmapya wu kemɛ, na wu le wu kpɔɔn ni. Ga wu na ba sigiye yi sòrogo nafugibaaga ni.» ");
INSERT INTO myk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ayiwa, a Yesu di yìri Galile fiige ki ni na pa Zhurudɛn Gba wu ɲɔ na Yohana yíri, kɔnhɔ Yohana di ba wu bɛ batize. ");
INSERT INTO myk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A Yohana di ganha na li shege, na jo: «Mu wʼa yaa na nɛ batize goo, a mʼi dɛrɛɛ na ma nɛ mu ya?» ");
INSERT INTO myk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Yesu di wu pye: «Sɔɔ lee na, lee di bye mu nimɛ, bani lee pyegana li funŋɔ ni wʼà da Kilɛ wo ɲidaan wu pye.» A Yohana di sɔɔ, na wu batize. ");
INSERT INTO myk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ba Yesu ya batize na xɔ wɛ, na foro lɔhɔ ki ni. Taapile ni a fugba wu ɲɔ di mugi. A Yesu di Kilɛ Munaa li ɲa li na diri na ma wu mu ba gbegbe shazhira ɲɛ wɛ, na ba do wu na. ");
INSERT INTO myk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A mujuu la di foro fugba wu ni na: «Nɛ ɲidaan Ja wu ɲɛ we, wu kaa lʼa dan nɛ ni tɛhɛnɛ baa.» ");
INSERT INTO myk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lee kadugo na a Fɛfɛɛrɛ Munaa di Yesu ɲaha co na kari siwaga ni, kɔnhɔ Shitaanni di shɛ wu taanna wii. ");
INSERT INTO myk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A wʼi suun le na ta cabyaa kɛlɛɛ shishɛɛrɛ (40) ni nibiiye kɛlɛɛ shishɛɛrɛ. Lee kadugo na, a xuugo di wu ta. ");
INSERT INTO myk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A Shitaanni di fulo wu na, na wu pye: «Ma bi ɲɛ Kilɛ wo Ja we, ye faakageeye ye pye na yi ɲɛri buuri.» ");
INSERT INTO myk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A Yesu di wu ɲɔ shɔ na: «Lʼa ka Kilɛ Kafila wu ni na: ‹Ɲɔ yalige yɛ wa sipya ɲɔ shaa wɛ, ga fo jomɔ pemu bɛɛri Kilɛ ya yu ge.›» ");
INSERT INTO myk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lee kadugo na a Shitaanni di gari ni wu ni Fɛfɛɛrɛ Kulo li ni, na shɛ wu yaha Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲidii li ni, ");
INSERT INTO myk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na wu pye: «Ma bi ɲɛ Kilɛ wo Ja we, kɔn to ɲiŋɛ na. Bani lʼa ka Kilɛ Kafila wu ni na: ‹Kilɛ na ma kaa jo wu mɛlɛkɛɛ pu mu, pee na ma co pu keye ni, kɔnhɔ ma tɔɔgɔ ganha bu guu kagereŋɛ yafiin na wɛ.›» ");
INSERT INTO myk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A Yesu di wu pye: «Lʼa ka bɛ sanha Kilɛ Kafila wu ni na: ‹Ma ganha ma Kafɔɔ Kilɛ taanna wii wɛ.›» ");
INSERT INTO myk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lee kadugo na a Shitaanni di wu lɔ sanha na shɛ yaha faabobotɔɔngɔ ka fugba ni, na shɛ koŋɔ saanra ti bɛɛri, ni ti nɔɔrɔ wu bɛɛri shɛ wu na, ");
INSERT INTO myk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","na wu pye: «Ma bu nuguro sin nɛ fɛɛ ni, na nɛ pɛlɛ, nɛ na ye bɛɛri kan ma mu.» ");
INSERT INTO myk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wee tuun wu ni a Yesu di wu pye: «Shɛ wà dɛ, Shitaanni! Bani lʼa ka Kilɛ Kafila wu ni na: ‹Mʼa ma Kafɔɔ Kilɛ yɛ pɛlɛ, ma da labye pyi wee yɛ nigin mu.›» ");
INSERT INTO myk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ayiwa, a Shitaanni di laha wu tàan, na gari, a mɛlɛkɛɛ pii di fulo wu na, na wu keree yàa. ");
INSERT INTO myk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ba Yesu ya pa yi logo na Yohana ya le kaso ni wɛ, a wʼi yìri wee xuu wu ni, na gari Galile fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ga wu ya ta tiin Nazarɛti kulo li ni wɛ, a wu shɛ diin Kapɛrinɔmɔ kulo li ni. Lee bye Galile Gba wu ɲɔ ki na, Zabulɔn wo koomɔ pe ni Nɛfitali wo koomɔ pu ni. ");
INSERT INTO myk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lee ya pye mu, kɔnhɔ Kilɛ tudunmɔɔ Ezayi bi yemu jo ge, yee ɲɔ di fa na: ");
INSERT INTO myk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulɔn wo koomɔ pe ni Nɛfitali wo koomɔ pu ni, pee pemu pu ɲɛ Galile Gba wu ɲɔ koomɔ pe, Zhurudɛn Gba wu kadugo yíri ge, shi watii shɛɛn ya ɲɛhɛ Galile wemu wo koomɔ pu ni ge. ");
INSERT INTO myk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Sipyii piimu pu bi tiin nibiige ki ni ge, pee ya kpɛɛngɛ nigbɔhɔ ɲa. Piimu pu bi bye xu wo nibiige fiige ki ni ge, kpɛɛngɛ ya foro pee mu.» ");
INSERT INTO myk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wee tuun we ni Yesu ya Kilɛ Jozaama pu yɛrɛ li ɲɔ kɔn na byi. Wu bi yu na: «Yi daajeŋɛ jo yi jurumu wu na, bani fugba saanra tʼa tɛɛŋɛ.» ");
INSERT INTO myk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Caŋa ka, na Yesu yaha wu na ɲaari Galile Gba wu ɲɔ ki na, a wu fyashaa shuun ɲa, pʼi ɲɛ cebooloo: Simɔ, wee wemu pʼa byi na Pyɛɛri ge, ni wu ceborona Andire. Jɔ̀ pu bi waa gba lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A Yesu di pu pye: «Yi taha na fɛni, di yi pye sipyii shavɛɛ.» ");
INSERT INTO myk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Taapile ni a pʼi jɔlɔɔ pu yaha wà, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A wu shɛ ɲaha na, na ceboronamaa shuun wa bɛ ɲa. Pee bye Zebede wo jalaa shuun: Yakuba ni Yohana. Pu wo jɔlɔɔ pee di bi jooli pu kɔrɔgɔ funŋɔ ni, ni pu to Zebede wu ni. A Yesu di pee bɛ yiri. ");
INSERT INTO myk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Taapile ni a pee bɛ di pu wo kɔrɔgɔ ki yaha wà ni pu to wu ni, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu bi Galile fiige ki bɛɛri ɲaari, na kalaa kaan sipyii pu mu pu Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. Wu bi fugba saanra ti wo Jozaama pu yu, na yama tuuyo yi bɛɛri xuu, na sipyii shuu pu fanhaxhɔɔrɔ tuugo bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A Yesu mɛgɛ di Siiri fiige ki bɛɛri círi. A sipyii pʼi ganha na yama fɛɛ pu bɛɛri tugoo na ma wu mu. Gban tuuyo bɛɛri yi bye pee yama fɛɛ pii ni: Jinaa bye pii ni, pii di ɲɛ kirikirizaannaa fɛɛ, kabanuxuyo fɛɛ ɲɛ pu ni. A Yesu di pu bɛɛri cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A sipyiɲɛhɛmɛɛ di daha wu fɛni. Pee bi yìri Galile fiige ki ni, ni Dekapoli fiige ke, ni Zheruzalɛmu kulo le, ni Zhude fiige ke, ni Zhurudɛn Gba wu kadugo yíri. ");
INSERT INTO myk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ayiwa, ba Yesu ya sipyiire ti ɲa wɛ, na dugi tiin faaboboŋɔ ki ɲuŋɔ ni. A wu wo kalaapiire tʼi fulo wu na. ");
INSERT INTO myk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A wu ɲɔ kɔn na pu kalaa na: ");
INSERT INTO myk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Piimu pʼa li cɛ na funmɔ fɛɛ pee ɲɛ Kilɛ shizhaa na ge, pee ɲɛ duba nagoo, bani pee wuuro ti ɲɛ fugba saanra te. ");
INSERT INTO myk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Piimu wo zɔlɔɔ pʼa mɛhɛɛ suu ge, pee ɲɛ duba nagoo. Bani pee logoo na ba ɲiŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Piimu pu ɲɛ ni lotangaa ni ge, pee ɲɛ duba nagoo. Bani pee na ba ɲiŋɛ ki ta na pye cɛn. ");
INSERT INTO myk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Piimu pʼa tiimɛ la pyi ba yalige ni logbaga ɲɛ-ɛ ge, pee ɲɛ duba nagoo. Bani pee funyɔ na ba ɲiŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Piimu pʼa ɲuŋɔ ɲaari pusamaa na ge, pee ɲɛ duba nagoo. Bani Kilɛ na ba ɲuŋɔ ɲaari pee na. ");
INSERT INTO myk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Piimu wo zɔlɔɔ pu ɲɛ fɛɛfɛɛ ge, pee ɲɛ duba nagoo. Bani pee na ba Kilɛ ɲa. ");
INSERT INTO myk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Piimu pʼa ɲaɲiŋɛ shaa kʼi bye pu ni pu sipyiɲii tɛ ni ge, pee ɲɛ duba nagoo. Bani pee na ba yiri Kilɛ nagoo. ");
INSERT INTO myk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kanhama ya nɔni piimu na Kilɛ wo ɲidaan bye funŋɔ ni ge, pee ɲɛ duba nagoo. Bani pee wuuro ti ɲɛ fugba saanra te. ");
INSERT INTO myk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Sipyii ba yi shɛhɛlɛ, na yi kana, na kakuuŋɔɔ tuuyo bɛɛri wo kafinɛyɛ tɛri yi na nɛ mɛgɛ wuu na, wee tuun wu ni yi ɲɛ duba nagoo. ");
INSERT INTO myk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yi funyɔ yi taan fo xuuni, bani yi saraa wʼa pɛlɛ fugba wu ni. Kilɛ tudunmɔɔ piimu pʼa toro yee ɲaha na ge, mu pʼa pee bɛ kanha lee kanhagana li na. ");
INSERT INTO myk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Yee pu ɲɛ ke koŋɔ ke wo suumɔ. Ga suumɔ tipoomɔ bu foro pu ni, ɲaha na pu taan sanha wɛ? Pee suumɔ pe da já yaaga bɛ ɲɔ nige wɛ, fo na pu wá kpɛɛngɛ na sipyii tɔɔyɔ ni pʼa danhana. ");
INSERT INTO myk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yee pu ɲɛ ke koŋɔ ke wo kpɛɛngɛ. Kulo lemu lʼa teŋɛ faaboboŋɔ ɲuŋɔ ni ge, lee ya já ŋmɔhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wa shishiin ya sokinna leni mʼa yaaga shigile wu ɲuŋɔ ni wɛ. Ga yaaga ka ɲuŋɔ ni ma ma wu taha, kɔnhɔ wu da kpɛɛngɛ yeege puga ki jevɛɛ pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mu yee bɛ wo kpɛɛngɛ kʼa yaa na fòro lee forogana li na sipyii pu mu, kɔnhɔ pu da yi wo kapyegee nizaaŋaa ki ɲaa, pu da baraga tɛri yi fugba To Kilɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Yi ganha ba giin na nɛ pa di ba saliya we, kelee Kilɛ tudunmɔɔ pu wo jomɔ pu gbo wɛ. Nɛ ta pa di ba yee gbo wɛ, ga nɛ pa di ba yi ɲɔ fa. ");
INSERT INTO myk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Can na nʼa da yi jo yi mu, na fugba we ni ɲiŋɛ ke yaha, Kilɛ wo saliya wu kamapile nifɛnhɛfɛnhɛnɛ bɛ, kelee wu kamapile fuduunɔ nigin bɛ wa da zhɔ do wɛ, fo na shɛ keree ki bɛɛri nɔ ki tɛhɛnɛ na. ");
INSERT INTO myk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lee wuu na sipyaa sipya wʼa saliya wu ɲɔmɛɛ nifɛnhɛfɛnhɛnɛ nigin bɛ kyɛɛgi ge, na nugo na sipyii pu kalaa lee ni ge, weefɔɔ na ba bye fugba saanra ti wo sipyii pu bɛɛri wo nifɛnhɛfɛnhɛnɛ. Ga sipya wemu ba saliya wu koo ɲaari, na sipyii pu kalaa lee ni, weefɔɔ na ba bye fugba saanra ti wo sipyigbɔ wa. ");
INSERT INTO myk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nʼa da yi jo yi mu, yee bu bye yee di ya saliya karamɔgɔlɔɔ pee, ni Farizhɛɛn pu já tiimɛ ni wɛ, yee da ba jé bada fugba saanra ti ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yee ya yi logo na lʼa shɛ wèe sefɛlɛɛ pu na na: ‹Ma ganha ga sipya gbo wɛ.› Sipyaa sipya wʼa wu sipyiɲii gbo ge, kiiri wu da gɔn ma na. ");
INSERT INTO myk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ga nɛ kunni wʼa da yi jo yi mu jo sipyaa sipya wʼa luu yirige wu ceboro tàan ge, kiiri ya yaa na kɔn weefɔɔ na. Wemu bu wu ceboro pye na nahanaha wu ɲɛ wii, kiirikɔɔn kuruŋɔ kʼa yaa na kiiri kɔn weefɔɔ na. Wemu bu wu ceboro pye na wu sicere fɔɔ, weefɔɔ ya yaa na le Jahanɛmɛ wo na ki ni. ");
INSERT INTO myk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lee wuu na, ma bu yìri, na saraga lɔ, na ma da zhɛ ki wolo gan Kilɛ mu saraya yi tawologo ki ni. A ma funŋɔ di do li na na kabɛbaana la mʼa pye ma ceboro wa na. ");
INSERT INTO myk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ayiwa, mʼa yaa na saraga ki yaha saraya yi tawologo ki ni, mʼa guri, mʼa fɛnhɛ shɛ bɛ ni ma ceboro wu ni, mʼa na kuri pa ma saraga ki wolo ma kan Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sipya wa bu jaagi shan ma na kaa la na, na ma yiri kiirikɔɔn pu mu. La le mayɛ ni, mʼa bɛ ni wee kiiri kɔnɲii wu ni na yi yaha koo li na, kɔnhɔ wu ganha bu shɛ ma le kiirikɔɔn pu keŋɛ ni, pee di ma kan gɛdii pu mu pu le kaso ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Can na nʼa da yi jo ma mu, ma bu jé wee kaso wu ni, ma da ga foro wà ni wari pile nigin bɛ foo ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Yee ya yi logo na lʼa shɛ na: ‹Ma ganha ga dɔdɔɔrɔ pye wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ga nɛ kunni wʼa da yi jo yi mu jo sipyaa sipya wʼa cee wii, na wu la pye ge, weefɔɔ ya dɔdɔɔrɔ pye xɔ ni wee cee wu ni wu zɔ wu na. ");
INSERT INTO myk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ayiwa wee tuun wu ni, ma kanige ɲii le bu da lee na ɲɛ kaɲuŋɔ di ma le jurumu ni, li wɛhɛlɛ wolo, mʼa li wá taliige ni. Mʼa buun ma ceepuuro ti yatɛngɛ nigin yɛ ni, lee ya pɔrɔ ma mu ma ceepuuro ti bɛɛri ti jé Jahanɛmɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma kanige keŋɛ ke shiin bi ɲɛ kaɲuŋɔ di ma le jurumu ni, ki kɔn wá taliige ni. Mʼa buun ma ceepuuro ti yatɛngɛ nigin yɛ ni, lee ya pɔrɔ ma mu ma ceepuuro ti bɛɛri ti jé Jahanɛmɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Yʼa jo bɛ sanha na: ‹Ná wemu ba da wu shɔ gbaga xɔ, wufɔɔ wu gbaxɔɔrɔ sɛmɛ yàa kan wu mu.› ");
INSERT INTO myk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ga nɛ kunni wʼa da yi jo yi mu jo sipyaa sipya wʼa wu shɔ gbaga xɔ, dɔdɔɔrɔ di ya ta pye kee gbaga ke wo kaxɔɔ ɲuŋɔ-ɛ ge, dɔdɔɔrɔ ni weefɔɔ ya cee wu le. Ná wemu bɛ wʼa ceforogo ka leŋɛ ge, dɔdɔɔrɔ wee bɛ ya pye. ");
INSERT INTO myk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Yee ya yi logo sanha na lʼa shɛ wèe sefɛlɛɛ pu na na: ‹Ma ganha ga kaaga kàa, mʼa guri mʼa kee kyɛɛgi wɛ. Ga kaaga bɛɛri mʼa kàa Kafɔɔ ɲaha tàan ge, kee bɛɛri ɲɔ fa fo ki tɛhɛnɛ.› ");
INSERT INTO myk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ga nɛ kunni wʼa da yi jo yi mu jo yi ganha ba gari bada wɛ. Yi ganha ba gari fugba we na wɛ, bani wee ɲɛ Kilɛ wo saanra koro le. ");
INSERT INTO myk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yi ganha ba gari ɲiŋɛ ke na wɛ, bani kee ɲɛ Kilɛ wo tɔɔyɔ tatahaŋa. Yi ganha ba gari Zheruzalɛmu kulo li na wɛ, bani lee ɲɛ Saangbɔ wu wo kulo le. ");
INSERT INTO myk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma ganha ba gari mayɛ pyaa wo ɲuŋɔ ke bɛ na wɛ, bani ma da já ma ɲuzhige nigin we wa bɛ fiinŋɛ kelee di ki wɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yi sii jo yɛ ‹Uun› kelee ‹Ahayi›. Ya bu fara yee na, Shitaanni ni yee ya foro. ");
INSERT INTO myk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Yee ya yi logo na lʼa shɛ na: ‹Ɲii li ɲɛ ɲii wo tɛgɛ, gaan di ɲɛ gaan wo tɛgɛ.› ");
INSERT INTO myk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ga nɛ kunni wa da yi jo yi mu jo wa shishiin ganha ga kakuunɔ taga kakuunɔ la foo tɔ wɛ. Sipya wa bu kadaa ja ma kanige ɲibɛgɛ ni, ke ki bɛ tagi wu mu. ");
INSERT INTO myk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sipya wa ba giin wu ma yiri fanha mu, wu ma fadebire shɔ ma na, fadegbɔhɔ kiyɛ pyaa bɛ kan wu mu. ");
INSERT INTO myk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Fanhafɔɔ wa bu ma karamu na fo ma wu wo tuguro lɔ, mʼa kilo nigin ɲaari ni ti ni, ti lɔ wu mu, mʼa kiloo shuun ɲaari ni ti ni. ");
INSERT INTO myk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wa bu yaaga ka ɲɛɛri ma mu, wu kan. Wa ba foo shaa ma mu, ma ganha bu zhe lee ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Yee ya tee yi logo na lʼa shɛ na: ‹Ma ɲii wu taan ma mu,› mʼa ma pɛn kɔ. ");
INSERT INTO myk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ga nɛ kunni wʼa da yi jo yi mu, yi pɛɛn pu taan yi mu! Piimu pʼa taha yaha yi na na gana ge, yʼa Kilɛ ɲɛɛri pee mu. ");
INSERT INTO myk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yi To Kilɛ we wu wa fugba we ni ge, kɔnhɔ yi ba bye wee wo nagoo. Bani wee ya wu wo caŋa ki yeege sipyikuuŋɔ ni sipyisaama bɛɛri mu. Wʼa zanha shaan sipyitiimɛ ni sipyitiibaaga bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yee ya taan sipyii piimu mu ge, yee bu daan ni pee yɛ ni, kuduun wekɛ yʼi da da lee ni wɛ? Ali ta lee ninunɔ bɛ fanhafɛɛ wari shɔvɛɛ pu bɛ wa byi wɛ? ");
INSERT INTO myk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yee ba yi cebooloo pu yɛ nigin shaari, kagbɔɔ li wa lere ya? Ta lee ninunɔ bɛ Kilɛ cɛbaalaa pu bɛ wa byi wɛ? ");
INSERT INTO myk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yee kunni pu pye sipyii piimu ɲɔ ya fa ge, ma na jo ba yi fugba To Kilɛ wu ɲɔ ya fa fagana lemu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Yi kasɛɛgɛ yaha yiyɛ na, yi wo Kilɛ koo ɲara li ganha bu da bye na yiyɛ shɛɛ yɛ sipyii na wɛ. Yi ba lee pyi, yi da ba kuduun ta yi fugba To Kilɛ wu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ma ba da yaaga ka kan funmɔ fɛɛ mu, ma ganha ba maga wi mayɛ ɲahagbaa na wɛ. Lee shuun shuun jovɛɛ pu wa byi Kilɛ-pɛɛŋɛ piyɛyɛ ye, ni kakuutoroyo yi ni, kɔnhɔ pʼi da masɔŋɔ taa na yìri sipyii yíri. Can na nʼa da yi jo yi mu jo pee ya pu wo kuduun wu ta na xɔ. ");
INSERT INTO myk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ga ma ba da yaaga kan funmɔ fɛɛ mu, ma kanige keŋɛ ba kemu kaan, kamɛnɛ wogo ki ya yaa na kee cɛ wɛ, ");
INSERT INTO myk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kɔnhɔ kee yakanga ke di bye ŋmɔhɔrɔ wogo. Lee bu bye mu, ma To wu wʼa kaŋmɔhɔŋɔɔ ɲaa ge, wee na lee wo kuduun kan ma mu. ");
INSERT INTO myk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Yi ba Kilɛ ɲɛɛri, yi ganha bu da bye shuun shuun jovɛɛ pii shi wɛ. Pee wo ɲidaan wu ɲɛ mɛ na yeree na Kilɛ ɲɛɛri Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, ni kakuutoroyo yi ni, kɔnhɔ sipyii pu bɛɛri di da pu ɲaa. Can na nʼa da yi jo yi mu jo pee ya pu wo kuduun wu ta na xɔ. ");
INSERT INTO myk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ga ma ba da ɲɛrɛgɛ pye, jé ma puga, mʼa gbura ki tɔ wá mayɛ na, mʼa Kilɛ ɲɛɛri. Ma To we wʼa keree bɛɛri ɲaa ge, wee na lee wo kuduun kan ma mu. ");
INSERT INTO myk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yi ba da Kilɛ ɲɛɛri, yi ganha ba ɲuŋɔ baa jomɔ yu, yi da guroo pee ninumɔ na yʼa yu tɔɔɲii niɲɛhɛŋɛɛ ni, ba Kilɛ cɛbaalaa pii ya li pyi wɛ. Pee wa ma giin na pee bu jomɔ pe ɲɛhɛ, na pee jomɔ pe ɲɛhɛ funŋɔ ni Kilɛ wʼa da pee wo ɲɛrɛgɛ ki shɔ. ");
INSERT INTO myk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yi ganha bu da yiyɛ yaha pee shi wɛ! Bani yee mago wa yaŋmuyɔ yemu na ge, yee To wʼa yee cɛ na ta yee sanha yi ɲɛɛri wu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yʼa Kilɛ ɲɛɛri mumɛ: ‹Wèe To Kilɛ, mu wemu wu wa fugba we ni ge, Mu mɛgɛ ki pye fɛɛfɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma saanra ti pa. Ma ɲidaan wʼa byi ɲiŋɛ ke na, Ma na jo ba wʼa byi pyegana lemu na fugba we ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wù niɲaa ɲɔlige kan wù mu. ");
INSERT INTO myk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mʼa wù kakuuyo yi yafa wù mu, ba wèe bɛ ya wù sipyiɲii wo kakuuyo yi yafani pu mu wɛ; pʼa yemu pyi wù na ge. ");
INSERT INTO myk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma ganha bu wù yaha wù jé nɔwuuro ni wɛ, ga mʼa wù tanha Shitaanni na. Bani saanra te, ni sefɛɛrɛ te, ni nɔɔrɔ we, yee bɛɛri ɲɛ Mu woyo tɛhɛnɛ baa. Amiina.› ");
INSERT INTO myk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yi ba sipyii pusamaa wo kakuuyo yi yafani pu mu, yi fugba To wu na ba yi bɛ wo kakuuyo yi yafa yi mu. ");
INSERT INTO myk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ga yi bu bye yi ya sipyii pusamaa wo kakuuyo yi yafani pu mu wɛ, yi To Kilɛ wu da ba yi bɛ wo kakuuyo yi yafa yi mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Yi ba da suun le tuun wemu ni, yi ganha bu yi ɲahaya tanha, ba shuun shuun jovɛɛ pii ya li pyi pyegana lemu na wɛ. Pee wa ma pu wo ɲahaya yi tanha, kɔnhɔ wa bɛɛri bu pu ɲa, wufɔɔ di li cɛ na suun pʼa le. Can na nʼa da yi jo yi mu, pee ya pu wo kuduun wu ta na xɔ. ");
INSERT INTO myk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ga ma ba da suun le, ma ɲaha ki je, mʼa lasikoli fara ma ɲuŋɔ ki na, ");
INSERT INTO myk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kɔnhɔ sipyii ganha bu li cɛ na suun mʼa le wɛ, fo ma To Kilɛ wu yɛ, wee wemu wʼa ma funŋɔ cɛ ge. Ma To Kilɛ wu wʼa kaŋmɔhɔŋɔɔ ki ɲaa ge, wee na lee wo kuduun kan ma mu. ");
INSERT INTO myk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Yi ganha ba naafuu faari da yɛri naha yiyɛ mu ke koŋɔ ke na wɛ. Fyɛɛnrɛ ni tatɔn ya wu kyɛɛgi, nagaalaa bɛ di gburaya kyɛɛgi na jin, na yuli. ");
INSERT INTO myk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ga yʼa naafuu faari yʼa yɛri yiyɛ mu fugba wu ni. Fyɛɛnrɛ ni tatɔn wa wà di wu kyɛɛgi wɛ, nagaa bɛ di wa wà wu gbura kyɛɛgi jé, wu wu yu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bani xuu wemu ni ma naafuu wa ge, wà ma zɔ wu bɛ funzhaga wa. ");
INSERT INTO myk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Sipya ɲìi ki ɲɛ wu ceepuuro sokinna. Ma ɲìi ki bu ɲɔ, ma ceepuuro ti bɛɛri na ba bye kpɛɛngɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ga ma ɲìi ki bu bye ki ya ɲɔ wɛ, ma ceepuuro ti bɛɛri tʼa da bye nibiige ni. Ayiwa, kpɛɛngɛ ke ki ɲɛ mu ni ge, piige bu jé kee ni, kee na ɲɛri nibiicogoŋɔ dɛ! ");
INSERT INTO myk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Sipya wa shishiin da já da kapyeŋɛɛ pyi ɲuŋɔfɛɛ shuun mu wɛ. Bani wa na bɛn wu mu, wa na daan wu mu, kelee wu nɔrɔ wa na, wu laraga kɔn we wu na. Yee da já da kapyeŋɛɛ pyi Kilɛ mu, yi da ki pyi naafuu bɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Lee wuu na nʼa da yi jo yi mu, yi ganha ba yi funyɔ shaa ni yi ɲɔshaga ni na ɲaha yʼa da li, kelee ɲaha yʼa da gbuu wɛ. Yi ganha ba yi funyɔ shaa ni yi cére fàya ni, na ɲaha yʼa da leni wɛ. Ta munaa ya ye yalige na, ceepuuro bɛ dʼa ye cére fàya na wɛ? ");
INSERT INTO myk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yi shazhɛɛrɛ te wii fugba we ni. Ti wa yemɛ nuri wɛ, tʼi wa shinma kɔɔn wɛ, tʼi wa shinma kemɛɛ na yɛri kpɔngɔɔ ni wɛ. Ga yee fugba To wu ti ɲɔ shaa. Ta yee ya ye shazhɛɛrɛ na na kanha wɛ? ");
INSERT INTO myk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jɔgɔ wu wa yee ni, wemu na já ali jɛɛrɛ bɛ fara wuyɛ pyaa shi wu na ni funzhaga ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ɲaha na yʼi yi funyɔ shaa ni yi cére faleye kaa ni wɛ? Yi sige yaweye yi fyɛngana li wii, yʼa fyɛɛnrɛ nizaara temu pyi ge! Yi wa kapyeŋɛɛ pyi wɛ, yʼi wa fàya shin wɛ! ");
INSERT INTO myk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ga nʼa da yi jo yi mu, ali saannaa Solomani ni wu naafuu wu bɛɛri ni, wu fàŋa ka ya ke yawege ke ka fyɛnrɛ nigin bɛ xɔ saana ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɲà ke ki wa sige ki ni niɲaa, na ta na di da ba kee sòrogo ɲiga na ge. Ni Kilɛ ya kee nɔhɔ tɔni lee tɔgana li na, ta wu da ba yee nɔhɔ tɔ xuuni na ye kee na wɛ? Yee nʼa daa wʼa cɛ̀rɛ dɛ! ");
INSERT INTO myk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lee wuu na yi ganha ba yi funyɔ shaa na: ‹Ɲaha wèe da da li wɛ?› kelee ‹Ɲaha wèe da da gbuu wɛ?› kelee ‹Ɲaha wèe di da da leni wù fàya wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kilɛ cɛbaalaa pʼa ye yaŋmuyɔ ye bɛɛri shaa. Yee fugba To wu kunni ya li cɛ na yee mago wa ye yaŋmuyɔ ye na. ");
INSERT INTO myk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yi fɛnhɛ ya Kilɛ wo saanra te ni wu wo tiimɛ pe shaa. Lee kadugo na Kilɛ na ye yaŋmuyɔ ye bɛɛri kan yi mu, na la taha yi na. ");
INSERT INTO myk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yi ganha ba yi funyɔ shaa ni ɲiga kaa ni wɛ! Yi ɲiga keree yaha ɲiga keŋɛ ni! Caŋa bɛɛri ki ɲɛ ni ki ɲuŋɔ cɔnrɔmɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Yi ganha ba pusamaa jaagi wɛ! Kɔnhɔ yi bɛ ganha bu ba jaagi wɛ. ");
INSERT INTO myk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bani jaagigana lemu na yee wa sipyii pusamaa jaagi ge, lee jaagigana le na yee bɛ wa da ba jaagi. Yaaga kemu ni yee wa sipyii pu wo daanna wu pyi ge, kee yaaga ke ninuŋɔ ni yeeyɛ pyaa bɛ wo daanna wa da ba bye. ");
INSERT INTO myk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kagaanra le li wa mu ceboro wu ɲii ni ge, ɲaha na mu di lee wii, na ta puga tinbara di ɲɛ muyɛ pyaa ɲii ni, mu di ya lee ɲaa-i wɛ? ");
INSERT INTO myk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kelee dii mu di da já ma ceboro pye: ‹Yere di kagaanra le wolo ma ɲii li ni!› na ta puga tinbara di ɲɛ mu wuu li ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Shuun shuun jovɔɔ dɛ, fɛnhɛ puga tinbara le wolo mayɛ pyaa ɲii le ni. Lee bu bye ma na já ɲa xuuni, na kagaanra li wolo ma ceboro wu ɲii li ni. ");
INSERT INTO myk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Yi ganha ba fɛfɛɛrɛ yaŋmuyɔ waa puun mu wɛ! Kɔnhɔ pu ganha bu da ŋmahana ɲɛri yi fɛni pʼi yi shɛɛngi shɛɛngi wɛ. Yi ganha ba yi pɛɛwa kuun waa shaalaa mu wɛ! Kɔnhɔ pu ganha bu da wu tanhana tanhana wɛ. ");
INSERT INTO myk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Yʼa ɲɛɛri, yi na da daa. Yʼa zhaa, yi na da ɲaa. Yʼa gbura ki kuuni, gbura ki na da muri yi mu. ");
INSERT INTO myk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bani sipyaa sipya wʼa ɲɛrɛgɛ pyi ge, wee na da daa. Wemu wʼa zhaa ge, wee na da ɲaa. Wemu wʼa gbura ki kuuni ge, gbura ki na da muri weefɔɔ mu. ");
INSERT INTO myk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yee wa bɛɛri ja wʼa buuri ɲɛɛri wu mu ge, jɔgɔ wu wa yee ni wemu na kagereŋɛ kan wu ja wu mu buuri wu wege ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kelee ja wu bu fya ɲɛɛri wu mu, wʼi wɔ kan wu mu fya wu wege ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Wee tuun wu ni, yee piimu pʼa kolo ge, yee bi yasaaya kangana cɛ mu yi nagoo pu mu. Ayiwa, ta yee fugba To wu da ba yasaaya kan fo xuuni yi ɲɛɛrivɛɛ pu mu wɛ? ");
INSERT INTO myk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yi funŋɔ wa sipyii pʼa keree kiimu bɛɛri pyi yi mu ge, yʼa kee shi pyi pu bɛ mu, bani wee wu ɲɛ Kilɛ tudunmɔɔ Musa wo saliya we ni Kilɛ tudunmɔɔ pii wo kalaa we. ");
INSERT INTO myk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Yʼa jin kuɲɔɔ nifɛnhɛfɛnhɛnɛ li ni. Bani koo lemu lʼa kari kakara ti wo xuu wu ni ge, lee ya pɛlɛ, li tajege ki bɛ dʼa pɛlɛ. Sipyiɲɛhɛmɛɛ pʼa se lee koo le ni. ");
INSERT INTO myk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ga koo lemu lʼa kari ɲìi sicuumɔ pu ni ge, lee koo lʼa cɛ̀rɛ, li tajege ki bɛ dʼa cɛ̀rɛ. Sipyii piimu pʼa jin lee ni ge, pee ya ɲɛhɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Piimu pʼa puyɛ faanna na Kilɛ tudunmɔɔ pee ɲɛ ge, yʼa yiyɛ kasɛri pee na! Pu ma ma yee mu ba dubyaa ɲɛ wɛ, ga pʼi ɲɛ yacoyo. ");
INSERT INTO myk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pu kapyegee ki na yʼa da ba pu cɛ. Ta ɛrɛzɛn nilɛ ya daa mɛ xhuyo tige na? Kelee ta nitoroŋɔ na da xhutɔɔnyɔ tige na? ");
INSERT INTO myk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tige kemu ya ɲɔ ge, yasɛyɛ nizaaya kʼa byi; tikuuŋɔ bɛ di yasɛyɛ niguuyo pyi. ");
INSERT INTO myk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tisaaŋa da ga já yasɛyɛ niguuyo pye wɛ; tikuuŋɔ bɛ di wa da ga já yasɛyɛ nizaaya pye wɛ. ");
INSERT INTO myk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tige bɛɛri ki ɲɛ ki ya nagoo nizaamaa pyi-i ge, kee na ba gɔn, na ki wá na ni. ");
INSERT INTO myk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lee cɛgana li na yee da ba tudunmɔɔ kafinɛjuu pu cɛ pu kapyegee ki na. ");
INSERT INTO myk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Sipyii piimu bɛɛri pʼa nɛ pyi: ‹Kafɔɔ, Kafɔɔ› ge, pee bɛɛri wa da ba jé fugba saanra ti ni-i dɛ, fo piimu yɛ pʼa nɛ fugba To wu wo ɲidaan wu pyi ge. ");
INSERT INTO myk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kiiri wu cagɔngɔ sipyiɲɛhɛmɛɛ na ba yu na: ‹Kafɔɔ, Kafɔɔ, ta wèe ya keree nibaŋaa jo mu mɛgɛ na, na jinaa kɔri yeege yama fɛɛ ni, na kakanhaŋaa niɲɛhɛŋɛɛ pye mu mɛgɛ na wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wee tuun wu ni nɛ ma li shɛ pu na jo: ‹Nɛ yee cɛ bada wɛ. Yee kakuubyii piiri, yi laha na tàan dɛ!› ");
INSERT INTO myk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Lee wuu na, sipyaa sipya wʼa nɛ jomɔ pu nuri, na pu koo ɲaari ge, weefɔɔ ya foro ná fungɔngɔ fɔɔ wa fɛni, wemu ya wu puga yereŋɛ faaya ɲuŋɔ ni ge. ");
INSERT INTO myk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A zangbɔhɔ di ba ni kafɛɛgbɔhɔ ni, a gbalaa pʼi ɲi fo na golo wo. Ga lee la shishiin ya já ke puga ke shan wɛ, bani faaya na ki nɔhɔ ya teŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ga sipyaa sipya ba nɛ jomɔ pu nuri, wufɔɔ di ya pu koo ɲaari wɛ, weefɔɔ ya foro fungɔngɔ baa fɔɔ wa fɛni, wemu ya wu wo puga yereŋɛ gbazhɛnhɛ ɲuŋɔ ni ge. ");
INSERT INTO myk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A zangbɔhɔ di ba ni kafɛɛgbɔhɔ ni. A gbalaa pʼi ɲi fo na golo wo. A kee puga kʼi gurulo. A ki togana di golo.» ");
INSERT INTO myk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ayiwa, ba Yesu ya wee kalaa wu kan xɔ wɛ, a wu kalaa wu kangana lʼi sipyiire ti ɲaha wɔ xuuni, ");
INSERT INTO myk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","bani wu wo we, ni pu wo saliya karamɔgɔlɔɔ pu wo wu bye ninumɔ wɛ. Wu wo kalaa wu bi byi ni sefɛɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ayiwa, ba Yesu ya tigi faaboboŋɔ ki na wɛ, a sipyiire niɲɛhɛrɛ di daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wee tuun wu ni a togo fɔɔ wa di fulo wu na, na nuguro sin wu fɛɛ ni, na wu pye: «Kafɔɔ, mu bu sɔɔ, go mu na já nɛ cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A Yesu di wu keŋɛ yeege, na gbɔn wu na, na jo: «Nɛ sɔɔ mu wu cuuŋɔ!» Taapile ni a togo kʼi xhɔ, a wu bye fɛɛfɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lee kadugo na a Yesu di wu pye: «Kasɛɛgɛ yaha mayɛ na, ma ganha bu ye ɲaha jo wa shishiin bɛ mu wɛ. Ga shɛ mayɛ shɛ saraya ɲaha shɔɔnrivɔɔ wu na. Musa ya saraga kemu kaa jo ge, mʼa kee wolo. Kee na ba li shɛ na mʼa cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ayiwa, ba Yesu ya jé Kapɛrinɔmɔ kulo li ni wɛ, a sɔrɔsii ɲuŋɔfɔɔ wa di fulo wu na, na wu ɲɛɛri na: ");
INSERT INTO myk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Kafɔɔ, nɛ kapyebye wu nizinnɛgɛ ki ɲɛ puga. Wu kabanuyo shuun wu bɛɛri wʼa xu. Kanhama pu ɲɛ wu ɲuŋɔ ni fo pu nigbɔ.» ");
INSERT INTO myk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A Yesu di wu pye: «Nʼa da zhɛ wu cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ga, a wee sɔrɔsii ɲuŋɔfɔɔ wu jo: «Kafɔɔ, nɛ yaa mu wu jé nɛ puga wɛ. Ga ɲɔmɛɛ nigin yɛ jo, lee na nɛ wo kapyebye wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bani ɲuŋɔfɛɛ pii wo fanha nɔhɔ ni nɛ ɲɛ, sɔrɔsii pii di ɲɛ nɛ bɛ mu. Nɛ bu wee wa pye: ‹Shɛ!› Wʼa gari. Nɛ bu wa bɛ pye: ‹Pa!› Wee bɛ na ba. Nɛ bu na kapyebye wu pye: ‹Le pye!› Wʼa lee pye.» ");
INSERT INTO myk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ba Yesu ya pee jomɔ pu logo wɛ, a lee di wu fo. Sipyii piimu pʼa taha wu fɛni ge, a wu pee pye: «Can na nʼa da yi jo yi mu, nɛ sanha we wo nʼa daa wu tuugo ɲa sipya wa shishiin mu Izirayɛli fiige ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nʼa da yi jo yi mu sanha jo sipyiɲɛhɛmɛɛ na ba ba na yìri Kilɛ-nɔhɔ ni camutomɔ ni. Pee ni Ibirayima ni Ishaaga ni Yakuba yɛ na ba binnɛ diin, na li fugba saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ga fugba saanra ti mɛgɛ ya taha piimu na ge, pee na ba wá kpɛɛngɛ na nibiige ki ni. Pee na ba mɛhɛɛ suu wà, na ganhaa kuri.» ");
INSERT INTO myk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lee kadugo na a Yesu di sɔrɔsii ɲuŋɔfɔɔ wu pye: «Ta se puga! Lemu mʼa sha ge, lee li pye ma mu na saha ni ma nʼa daa wu ni.» A wu kapyebye wu juuŋɔ lee taapile li ni. ");
INSERT INTO myk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A Yesu di gari Pyɛɛri kaban, na shɛ Pyɛɛri yafezhɔ wu ta wʼa sinnɛ ceefuuro keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A Yesu di gbɔn wu keŋɛ na, a ceefuuro tʼi wu yaha. A wu yìri, na wu keree yàa. ");
INSERT INTO myk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ba yakoŋɔ kʼa pa nɔ wɛ, a sipyii pʼi ganha na ma Yesu mu ni sipyii niɲɛhɛmɛɛ ni, jinaa ɲɛ piimu ni ge. A wu pee jinaa pu kɔri yeege pee sipyii pii ni juu nigin na, na yama fɛɛ pu bɛɛri cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lee funŋɔ ni Kilɛ tudunmɔɔ Ezayi bi jomɔ pemu jo ge, a pee ɲɔ di fa na: «Wʼa ɲuŋɔ le wèe wo fanhaxhɔɔrɔ ti tàan, ni wèe wo yama pu ni.» ");
INSERT INTO myk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ba Yesu ya sipyiire ti ɲa tʼa pa wu kuuri wɛ, a wu wu kalaapiire ti pye: «Wù shɛ gba wu kadugo.» ");
INSERT INTO myk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A saliya karamɔgɔ wa di fulo Yesu na, na wu pye: «Wù karamɔgɔ, xuu bɛɛri ni mʼa se ge, nɛ na daha ma fɛni.» ");
INSERT INTO myk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A Yesu di wu pye: «Sige puun wa ni wejeye ni, fugba shazhɛɛrɛ di ɲɛ ni shiire ni. Ga tashɔngɔ wa Sipya Ja wu mu kemu ɲɛ wuyɛ pyaa wogo wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A wu kalaapire la bɛ di wu pye: «Kafɔɔ, na yaha di ba fɛnhɛ na to wu le.» ");
INSERT INTO myk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A Yesu di wee pye: «Xuu pu yaha sipyixuyo ye mu yee di da pee leni, mʼa daha na fɛni!» ");
INSERT INTO myk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lee kadugo na a Yesu ni wu kalaapiire tʼi jé kari kɔrɔgɔ ka ni. ");
INSERT INTO myk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Taapile ni a kafɛɛgbɔhɔ ka di yìri lɔhɔ ki ɲuŋɔ ni fo na lokuruyo pye yi na zhaa di kɔrɔgɔ ki tɔ. Lee bi Yesu ta wu na ŋmunɔɔ. ");
INSERT INTO myk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A wu kalaapiire tʼi fulo wu na, na wu ɲɛ, na wu pye: «Kafɔɔ, wù na da gori lɔhɔ ni, yìri mʼa wù ɲuŋɔ wolo!» ");
INSERT INTO myk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A Yesu di pu pye: «Ɲaha na yee di fyagi mɛ wɛ? Yee nʼa daa wʼa cɛ̀rɛ dɛ!» Wee tuun wu ni a wu yìri, na sɛlɛ kafɛɛgɛ ke ni lokuruyo yi na, a tunmɔ pu bɛɛri di yere. ");
INSERT INTO myk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A lee di bye pii sipyii pii mu kakanhana, a pʼi jo: «We ná we di ɲɛ sipya wekɛ tuugo, fo kafɛɛgɛ ni lɔhɔ bɛ na wu ɲɔmɛɛ coni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ayiwa, ba Yesu ya nɔ gba wu kadugo yíri, Gadara fiige ki ni wɛ, a namaa shuun wa di foro faya yi ni, na ba wu ɲuŋɔ círi. Jinaa pu bye pee ni. Pu bi sii kolo kolo fo na koo li pye sipya bɛ ya gbara wʼa doroo li ni nige wɛ. ");
INSERT INTO myk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A pʼi ɲɔ kɔn na xhuulo, na yu: «Ɲaha mu di zhaa wèe fɛni wɛ, Kilɛ Ja we? Kanhama mʼa pa di ba zhan wù ɲuŋɔ ni, na ta pu tuun di sanha nɔ-ɛ ya?» ");
INSERT INTO myk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lee bi shaagbaga nijeŋɛ ka ta ki na naha wà taliige ni. ");
INSERT INTO myk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A jinaa pʼi Yesu ɲɛɛri na: «Ma bu wù kɔri, ma di wù yaha wù shɛ jé pii shaalaa pii ni.» ");
INSERT INTO myk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A Yesu di jo: «Yʼa se!» A pʼi foro namaa shuun wu ni, na shɛ jé shaalaa pu ni. A kee shaagbaga ki bɛɛri di gburogi, na digi yaŋa gologoloyo yi ni, na shɛ jé gba lɔhɔ ki ni, na xhu wà. ");
INSERT INTO myk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A pee shaanahamaa pʼi baa kari kanha ki ni, na shɛ yi bɛɛri paari. Lemu lʼa bi pye pii jinaa sipyii shuun we na ge, a pʼi yee bɛ ɲaha jo. ");
INSERT INTO myk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wee tuun wu ni, a kulo li shɛɛn pu bɛɛri di foro, na shɛ Yesu ɲuŋɔ círi. Ba pʼa wu ɲa wɛ, na wu kemɛ ɲɛɛri na wu foro pu wo fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wee tuun wu ni a Yesu di kɔrɔgɔ ka lɔ, na guri gba wu kɔn sanha, na ba wuyɛ pyaa wo kulo li ni. ");
INSERT INTO myk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A sipyii pii di ba wu mu ni ná kabanuxuyo shuun fɔɔ wa ni yasinnɛgɛ ka na. Ba Yesu ya pee wo nʼa daa wu ɲa wɛ, na ná kabanuxuyo shuun fɔɔ wu pye: «Na ja, lowaa le mayɛ ni, ma jurumu wʼa yafa ma mu.» ");
INSERT INTO myk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wee tuun wu ni a saliya karamɔgɔlɔɔ pii di ganha na yu puyɛ funyɔ ni na: «Kilɛ mɛgɛ we ya gyɛɛgi mɛ.» ");
INSERT INTO myk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yemu pʼa bi yu puyɛ funyɔ ni ge, a Yesu di yee cɛ, na pu pye: «Ɲaha na ke fungɔnkuuŋɔ ke dʼa tigi yee funyɔ ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na jo: ‹Ma jurumu wʼa yafa ma mu.› kelee na jo: ‹Yìri, ma da ɲaari!› Lekɛ lʼa faha wɛ? ");
INSERT INTO myk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ga kɔnhɔ yʼi li cɛ na se wa Sipya Ja wu ni wʼa sipyii pu wo jurumu wu yafani pu mu ɲiŋɛ ki na.» A wu kabanuxuyo shuun fɔɔ wu pye: «Yìri, mʼa ma yasinnɛgɛ ki lɔ, ma da se puga!» ");
INSERT INTO myk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A wu yìri, na gari puga. ");
INSERT INTO myk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ba sipyiire tʼa lee ɲa wɛ, na fya. A pʼi baraga taha Kilɛ na tee sefɛɛrɛ ti tuugo gan wuu na sipyii mu. ");
INSERT INTO myk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A Yesu di laha wee xuu wu ni, na gari. Wu nigariwo, a wu ná wa nidɛɛngɛ ɲa fanhafɛɛ pu wari wu tashɔgɔ ki ni, wu mɛgɛ di ɲɛ na Macoo. A wu wee pye: «Taha na fɛni.» A Macoo di yìri, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Caŋa ka a Yesu di ba gari Macoo kaban. Na wu yaha wu na li. A fanhafɛɛ wari shɔvɛɛ ni jurumupyii niɲɛhɛmɛɛ piitiilee bɛ di shɛ binnɛ na li ni wu ni, na fara wu kalaapiire ti bɛ na. ");
INSERT INTO myk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ba Farizhɛɛn pʼa lee ɲa wɛ, na ganha na Yesu wo kalaapiire ti pyi: «Ɲaha na yee wo karamɔgɔ wʼi li ni fanhafɛɛ wari shɔvɛɛ, ni jurumupyii piitiilee bɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ba Yesu ya yee logo wɛ, na jo: «Sicuumɔ fɛɛ mago ɲɛ wɛrɛ fɔɔ na wɛ, fo yama fɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yi shɛ yi funyɔ sha ni pe jomɔ pe kɔri ni na: ‹Yʼa ɲuŋɔ ɲaari yiyɛ na, nɛ Kilɛ wa lee fɛni na toro saraya tàan.› Bani sipyii piimu pʼa tii ge, nɛ ta pa di ba pee yiri wɛ, fo jurumupyii.» ");
INSERT INTO myk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lee kadugo na a Yohana Batizelipye wo kalaapiire tʼi fulo Yesu na, na wu yege na: «Ɲaha na wèe ni Farizhɛɛn di suun leni, na ta mu wo kalaapiire tʼi ya leni-i wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A Yesu di pu ɲɔ shɔ na: «Cenabun poo kaafɛɛ na já ɲahaya tanha na pu ni cenabun poo wu yaha shiizhan ya? Bada! Ga caŋa ka wa ma, cenabun poo wu na ba shɔ pu na, pʼa ganha na suun leni wee tuun wu ni. ");
INSERT INTO myk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Sipya wa shishiin da ga favonɔ tara falɛgɛ na wɛ. Lee bu bye, favonɔ li na falɛgɛ ki kile zhɛɛngi, kee tashɛngɛŋɛ ki na bɛlɛ. ");
INSERT INTO myk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Duvɛn nivomɔ bɛ di ya leni foroyo nilɛyɛ ni wɛ. Lee bu bye bɛ, foroyo yi na zhɛɛngi, duvɛn wu na wo, foroyo yi bɛ na gyɛɛgi. Ga foroyo nivoyo ni duvɛn nivomɔ ya leni. Lee bu bye, ma da buun ka shishiin ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na Yesu yaha pee jomɔ pu na, a Yawutuu wo ɲahagbaa fɔɔ wa di ba nuguro sin wu fɛɛ ni, na wu pye: «Nɛ poro fucɛɛrɛ lʼa xu nimɛ nimɛ. Ga pa ma keŋɛ taha wu na, wu na ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A Yesu ni wu kalaapiire tʼi yìri, na binnɛ kari ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lee bi cee wa bɛ ta wʼa yee kɛ ni shuun ta shishan na woni wu fɛni. A wee cee wʼi ba Yesu kadugo yíri, na ba gbɔn wu fadegeŋɛ na. ");
INSERT INTO myk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wee cee wu bi yi yu wuyɛ funŋɔ ni na: «Nɛ bu sii já ta kpɔn yɛ wu fadeŋɛ ke na, nɛ na juuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A Yesu di ŋmahana ɲɛri, na wee cee wu ɲa, na wu pye: «Na poro, lowaa le mayɛ ni, ma nʼa daa wʼa ma cuuŋɔ.» Taapile ni a cee wu juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ba Yesu ya nɔ wee ɲahagbaa fɔɔ wu kaban na faanwii pu ɲa, na sipyiire ti bɛ ta tunmɔ pu na wɛ, ");
INSERT INTO myk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a wʼi jo: «Yi yìri foro, bani pya wu ya ta xu wɛ, ga wʼa ŋmunɔɔ.» A pʼi ganha na wu la wo. ");
INSERT INTO myk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba sipyiire tʼa foro wɛ, a Yesu di jé puga ki ni, na pya wu co wu keŋɛ ke na, a pya wʼi yìri. ");
INSERT INTO myk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A lee kaa lʼi jaaga na kee fiige ki bɛɛri círi. ");
INSERT INTO myk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A Yesu di yìri wee xuu wu ni, na gari. A fyɛnmɛɛ shuun wa di daha wu na, na sɛlɛ, na yu: «Dawuda Ja, ɲuŋɔ ɲaari wù na.» ");
INSERT INTO myk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ba wʼa nɔ puga wɛ, a fyɛnmɛɛ pʼi fulo wu na. A wu pu yege na: «Yee ya dà li na na nɛ na já yee ɲìi ki mugi ya?» A pʼi jo: «Uun, Kafɔɔ.» ");
INSERT INTO myk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wee tuun wu ni a Yesu di gbɔn pu ɲìi ki na, na pu pye: «Lemu yʼa zhaa ge, li pye yi mu na saha ni yi wo nʼa daa wu ni.» ");
INSERT INTO myk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A pu ɲìi kʼi mugi. A Yesu di yi jo waha pu mu na: «Yi ganha bu sipya wa shishiin yaha wu le cɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ga, a pʼi gari, na shɛ ganha na Yesu kaa yu kee fiige ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ba Yesu ya pa foro wà na gaaŋi wɛ, a sipyii pii di ba wu mu ni ná wa ni, jina wu bye wu ni. Wee bi wu pye bobo. ");
INSERT INTO myk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A Yesu di wee jina wu kɔri, a ná wu já na yu. A lʼi bye kakanhana sipyiire ti bɛɛri mu. A pʼi ganha na yu na: «Le kaa le la tuugo sanha bye ɲa Izirayɛli fiige ki ni bada wɛ!» ");
INSERT INTO myk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ga, a Farizhɛɛn pu kunni di ganha na yu na: «Jinaa ɲuŋɔfɔɔ fanha ni, wʼa jinaa pu kɔri.» ");
INSERT INTO myk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu bi ɲaari kulogoo ki bɛɛri ni: kugbɔhɔɔ fara kupiire na, na sipyiire ti kalaa pu Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. Wu bi fugba saanra ti Jozaama pu yɛrɛ li pyi, na sipyii pu wo yama tuuyo yi bɛɛri xuu, ni pu fanhaxhɔɔrɔ ti bɛɛri. ");
INSERT INTO myk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ba wʼa sipyiire ti ɲa wɛ, a pu ɲiɲaara di jé wu ni. Bani sipyiire ti bi sii kanha, samɔhɔrɔ bɛ di ɲɛ pu ni wɛ, ba nahavɔɔ baa dubyaa ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ayiwa, a wu wu kalaapiire ti pye: «Shinma nigɔnbaama wʼa ɲɛhɛ, ga kapyebyii pu dʼa cɛ̀rɛ. ");
INSERT INTO myk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lee wuu na, yi shinma wu kafɔɔ wu ɲɛɛri na wu kapyebyii pii bɛ tun sanha, pʼi shɛ wu shinma wu kɔn.» ");
INSERT INTO myk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lee kadugo na a Yesu di wu kalaapiire kɛ ni shuun wu yiri, na fanha kan pu mu pʼa jinaa kɔri pʼa yeege sipyii ni, pʼi da yama tuuyo bɛɛri xuu, ni fanhaxhɔɔrɔ ti bɛɛri. ");
INSERT INTO myk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pee Tudunmɔɔ kɛ ni shuun wu mɛyɛ yi wa ye: Nizhiimɛ wu ɲɛ Simɔ pʼi wu pyi na Pyɛɛri, ni wu ceborona Andire. Zebede jalaa shuun: Yakuba ni Yohana. ");
INSERT INTO myk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe ni Batelemi; Tomasi ni Macoo, wee wemu wu bi fɛnhɛ pye fanhafɛɛ wari shɔvɔɔ ge; Alife ja Yakuba ni Tade; ");
INSERT INTO myk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ wemu wu bi bye Zelɔtilee kuruŋɔ ki ni ge, ni Zhuda Isikariyɔti, wee wʼa pa Yesu le keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A Yesu di kalaapiire kɛ ni shuun wu tun, na pu pye: «Shi wemu ɲɛ Yawutuu wɛ, yi ganha bu shɛ wee yíri wɛ! Yi ganha bu da jé Samari shɛɛn wo kulo la shishiin bɛ ni wɛ! ");
INSERT INTO myk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Izirayɛli fiige ki sipyii piimu pʼa piin ba dubyaa ɲɛ-ɛ ge, yi shɛ pee yíri. ");
INSERT INTO myk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yi nigariwuu, yʼa sipyii pu yɛri, yi da yi yu pu mu na fugba saanra tʼa tɛɛŋɛ! ");
INSERT INTO myk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yʼa yama fɛɛ pu cuuŋɔ! Yi da xuu pu ɲɛni! Yʼa togo fɛɛ pu cuuŋɔ, yi da pu pyi fɛɛfɛɛ! Yi da jinaa pu kɔri yʼa yeege sipyii pu ni! Ma fuu na yʼa lee ta, yi bɛ pʼa li kaan ma fuu na. ");
INSERT INTO myk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yi ba gaaŋi, yi ganha bu sanni kelee warifyɛn lɔ wɛ! Yi ganha bu waripyaa bɛ lɔ le yiyɛ fɛni wɛ! ");
INSERT INTO myk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yi ganha bu kushɛyɛrɛyɛ, kelee fadeye shuun, kelee tanhaya, kelee pubiin lɔ wɛ! Bani kapyebye ya sii yaa ni wu ɲɔlige ni. ");
INSERT INTO myk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yi bu jé kulo bɛɛri ni, kugbɔɔ la, kupire la, yi see sipya sha wemu na zɔɔ wu yi tirige ge. Yʼi diin weefɔɔ mu fo yi kariduun ba shɛ nɔ. ");
INSERT INTO myk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yi ba da jé puga bɛɛri ni yʼi fɛnhɛ fò pye na: ‹Kilɛ wu ɲaɲiŋɛ kan yi mu!› ");
INSERT INTO myk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kee puga ki bu da kʼa yaa ni yi wo ɲaɲiŋɛ ki ni, kee na digi pu na. Ga kee puga ki ba da ki ya yaa ni yi wo ɲaɲiŋɛ ki ni wɛ, yi wo ɲaɲiŋɛ ki na guri na pa yi mu. ");
INSERT INTO myk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Puga bɛɛri kelee kulo bɛɛri lʼa she li da yi tirige wɛ, kelee pu ya yi jomɔ logo wɛ, yi ba fòro wee xuu wa ni, yʼi yi tɔɔyɔ gbazhɛnhɛ ɲahara wo wà. ");
INSERT INTO myk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Can na nʼa da yi jo yi mu jo Sodɔmu ni Gɔmɔɔri shɛɛn wo kanhama keree na ba bɔrɔ lee kulo li wogoo na kiiri wu cagɔngɔ.» ");
INSERT INTO myk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Li wii, nʼa yi tun na kari ba dubyaa ɲɛ mɛ yacoyo niŋɛ ni wɛ. Wee tuun wu ni, yi kasɛɛgɛ yaha yiyɛ na ba wɔlɔɔ ɲɛ wɛ! Yʼi bye sipyii piimu ya la yu ni wa ni wɛ, ba gbegbe shazhɛɛrɛ ɲɛ wɛ! ");
INSERT INTO myk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yʼa yiyɛ kasɛri sipyii pii na dɛ, bani pu na ba yi leni kiirikɔɔn kuruyo yi keŋɛ ni, na yi kpɔɔn ni kashɛngɛɛ ni pu wo Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. ");
INSERT INTO myk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pu na ba se ni yi ni gbafɛnɛɛrɛɛ ni saannaa mu nɛ mɛgɛ wuu na. Lee na ba bye kaɲuŋɔ yi na Kilɛ wo Jozaama pu jo pu mu, na pu jo shi wusama bɛ mu. ");
INSERT INTO myk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pu ba yi leni keye ni tuun wemu ni, yi nijoyo ni yi jogaŋaa ganha bu da bye yi mu funzhaga wɛ. Jomɔ pemu yʼa da ba jo ge, pee na ba digi yi funyɔ ni wee tuun wuyɛ pyaa ni. ");
INSERT INTO myk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bani yiyɛ pyaa wa da ba bye pee jomɔ pe jovɛɛ wɛ, ga yi To Kilɛ wu wo Munaa li lʼa da ba yu yi ɲɔyɔ na. ");
INSERT INTO myk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ceboro na ba wu ceboro le keŋɛ ni, kɔnhɔ pʼi wu gbo. To na ba lee tuugo pye wu pya na. Nagoo bɛ na ba yìri pu sefɛɛ fɛni, kɔnhɔ pʼi pu gbo. ");
INSERT INTO myk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sipyii bɛɛri na ba yi kɔ nɛ mɛgɛ wuu na, ga wemu bu já luu mara fo tɛhɛnɛ na, weefɔɔ na zhɔ. ");
INSERT INTO myk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pu ba yi kana kulo la ni, yi ma baa kari latii ni! Ga nʼa da yi jo yi mu jo yani yee pu Izirayɛli kulogoo ki bɛɛri ɲaari ge, Sipya Ja wu na guri ba. ");
INSERT INTO myk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Kalaapire ya pɛlɛ li kalaato na wɛ; kapyebye ya pɛlɛ wu ɲuŋɔfɔɔ na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kalaapire tɛhɛnɛ li wa na pye ba li kalaato wu ɲɛ wɛ. Kapyebye bɛ tɛhɛnɛ li ɲɛ na pye ba wu ɲuŋɔfɔɔ ɲɛ wɛ. Ni pʼi wa kpɔɔn fɔɔ wu mɛgɛ yiri na Belizebuli, mɛgɛ kemu na ba yiri kpɔɔn li sipyii pu na ge, ta kee da ba golo Belizebuli na wɛ? ");
INSERT INTO myk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Wee tuun wu ni yi ganha ba fyagi sipyii na wɛ! Bani yaaga ka shishiin niŋmɔhɔŋɔ wa kemu da ba foro kpɛɛngɛ na wɛ. Kaŋmɔhɔnɔ la shishiin wa lemu da ba jɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nʼa yemu yu yi mu nibiige ni ge, yʼa yee yu kpɛɛngɛ na! Yʼa kalɔhɔrɔ temu nuri ge, yʼa duri kataya na yi da yee caaga! ");
INSERT INTO myk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Piimu na já sipya gbo, na ta pʼi da já yafiin bɛ pye wu munaa na-ɛ ge, yi ganha ba fyagi pee na wɛ! Ga, wemu wu da já sipya gbo, na ma munaa bɛ le Jahanɛmɛ ni ge, yʼa fyagi wee na! ");
INSERT INTO myk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ta cɔnrilɔɔ shuun bɛ pʼa bɛrɛɛ wari pile wɛ? Ga lee bɛ na, ali wee wa nigin bɛ, wu ya dun ɲiŋɛ na yee To Kilɛ wu gaɲa ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ga yee kunni, Kilɛ ya ali yee ɲuzhiire teyɛ pyaa bɛɛri ɲɔ cɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lee wuu na yi ganha ba fyagi wɛ; yʼa ye cɔnrilɔɔ niɲɛhɛmɛɛ na! ");
INSERT INTO myk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Sipyaa sipya wʼa yere li na sipyii ɲaha tàan na nɛ wo wee ɲɛ ge, nɛ bɛ na ba yere li na na fugba To wu ɲaha tàan, na weefɔɔ ɲɛ nɛ wo. ");
INSERT INTO myk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ga wemu bu foro nɛ kaa tàan sipyii ɲaha tàan, nɛ bɛ na ba foro weefɔɔ kaa tàan na fugba To wu ɲaha tàan. ");
INSERT INTO myk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Yi ganha ba giin na ɲaɲiŋɛ ni nɛ pa ɲiŋɛ ke na-ɛ dɛ! Nɛ ta pa ni ɲaɲiŋɛ ni wɛ, fo ŋmɔpara. ");
INSERT INTO myk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nɛ pa na pa bɛganhara le ja ni wu to tɛ ni, porofɔɔ ni wu nu tɛ ni, ni ja shɔ ni wu yashɔ tɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sipya puga shɛɛn yɛ pyaa ki da ba bye wu pɛɛn. ");
INSERT INTO myk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sipyaa sipya to kelee wu nu kaa lʼa taan wu mu na toro nɛ tàan ge, weefɔɔ ya yaa ni nɛ ni wɛ. Sipyaa sipya ja kelee wu poro kaa lʼa taan wu mu na toro nɛ tàan ge, weefɔɔ ya yaa ni nɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sipya wemu ya wu korikoritige lɔ, na daha nɛ fɛni wɛ, weefɔɔ ya yaa ni nɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sipya wemu wʼa giin wu wu munaa mara niɲaa ge, wee na ba buun li ni ɲiga na. Ga wemu wʼa bɔnri wu munaa ni niɲaa nɛ wuu na ge, wee na ba wu munaa ɲuŋɔ wolo ɲiga na. ");
INSERT INTO myk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Sipya wemu bu yee co xuuni, nɛ wʼa co xuuni. Sipya wemu bu nɛ co xuuni, we wʼa nɛ tun ge, we wʼa co xuuni. ");
INSERT INTO myk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sipya wemu bu Kilɛ tudunmɔ wa co xuuni, na bani Kilɛ tudunmɔ wu ɲɛ wii, kuduun we wʼa yaa ni Kilɛ tudunmɔ ni ge, weefɔɔ na wee ta. Sipya wemu bu sipyitiimɛ co xuuni, na bani wʼa tii, kuduun wemu wʼa yaa ni sipyitiimɛ ni ge, wufɔɔ na wee ta. ");
INSERT INTO myk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Can na, nʼa da yi jo yi mu, sipyaa sipya wʼa cɛɛgbuu ɲii loɲiŋɛ nidiige yɛ pyaa bɛ kan we nɔhɔcɛrɛɛ we wa mu, na bani wu ɲɛ nɛ kalaapire ge, weefɔɔ da ga fɔ lee wo kuduun ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ayiwa, ba Yesu ya wee kalaa wu kan xɔ wu kalaapiire kɛ ni shuun wu mu wɛ, a wʼi yìri wee xuu wu ni, na shɛ ganha na sipyii pu kalaa, na Kilɛ Jozaama pu yɛrɛ li kaan pu mu kabanugo kulogoo ki ni. ");
INSERT INTO myk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lee bi Yohana Batizelipye ta wʼa Shɔvɔɔ wu kapyegee ki bɛɛri kaa logo na wu yaha kaso wu ni. Wee tuun wu ni a wʼi wu kalaapiire ta tun wu mu na pu shɛ wu yege na: ");
INSERT INTO myk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Pʼa Shɔvɔɔ wemu kaa jo na wu na ba ba ge, mu wu wa laa, ta wù watii ɲaha wii?» ");
INSERT INTO myk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A Yesu di pu ɲɔ shɔ na: «Yʼa lemu ɲaa, na yemu nuri ge, yi shɛ lee paari Yohana mu na: ");
INSERT INTO myk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fyɛnmɛɛ wa ɲaa, faannaa di ɲaari, togo fɛɛ di juuŋɔ, ɲudunnɔɔ di nuri, xuu di ɲɛni, Kilɛ Jozaama pʼi yu la baa fɛɛ mu. ");
INSERT INTO myk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sipya wemu ɲuŋɔ ya kyɛɛgi nɛ na wɛ, weefɔɔ ɲɛ duba pya.» ");
INSERT INTO myk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ba Yohana wo kalaapiire tʼa kari wɛ, a Yesu di ɲɔ kɔn na yu ni sipyiire ti ni Yohana shizhaa na na: «Ɲaha yee dʼa shɛ wii siwaga ki ni wɛ? Kafɛɛgɛ ya wahagaanra lemu ɲɛri ge, lere ya? ");
INSERT INTO myk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wee tuun wu ni yee dʼa shɛ ɲaha wii wɛ? Fazaaya fɔɔ gɛ? Ga piimu pʼa fazaaya leni ge, pee ya daa saannaa piyɛyɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yee dʼa shɛ ɲaha wii wɛ? Kilɛ tudunmɔ gɛ? Uun, nʼa da yi jo yi mu jo ali wʼa pɛlɛ Kilɛ tudunmɔ na. ");
INSERT INTO myk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bani lʼa ka Kilɛ Kafila wu ni wu shizhaa na na: ‹Li wii, nʼa na tudunmɔ we tun ma ɲahagbaa na wu ma koo li yàa yaha ma ɲaha na.› ");
INSERT INTO myk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Can na nʼa da yi jo yi mu jo sipya wa shishiin sanha se Adama nagoo ni wemu wʼa pɛlɛ Yohana Batizelipye na wɛ. Ga lee bɛ na fugba saanra ti wo sipyii pu bɛɛri wo nifɛnhɛfɛnhɛnɛ ya pɛlɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na co Yohana Batizelipye wo Kilɛ Jomɔ pu yɛrɛ li na, fo na pa nɔ nimɛ na, yatɛnwaya na fugba saanra tʼa daa. Piimu pʼa yatɛnyɛ waha ge, pee pʼa ti taa. ");
INSERT INTO myk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kilɛ tudunmɔɔ pu bɛɛri, na fara Kilɛ tudunmɔɔ Musa wo saliya wu na, pee bɛɛri ya fugba saanra ti kaa jo, fo na pa nɔ Yohana Batizelipye wo tuun wu na. ");
INSERT INTO myk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yi bu da yi na giin di yi ɲaha cɛ, Kilɛ tudunmɔɔ Eli wemu wo ba kaa lʼa fɛnhɛ jo ge, Yohana wu ɲɛ wee Eli we. ");
INSERT INTO myk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wemu na logo ge, wu logo. ");
INSERT INTO myk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Nɛ na já niɲaa wo sipyii pii taanna ni jɔgɔ yɛ ni wɛ? Pu ɲɛ ba nɔhɔpiire ta ɲɛ wɛ, temu ya tiin pinnɛrɛ kpɛɛngɛ na ge, na pu kaafɛɛ pyi: ");
INSERT INTO myk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Wèe ya faangaa wi yee mu, yee di ya ta xɔnhɔ wɛ. Lee kadugo na a wèe di yamɛhɛɛ su yee mu yee di ya ta yiyɛ ɲiɲaara yahana yaha wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bani Yohana ya pa, wu ya li wɛ, wʼi ya gbuu wɛ. A pʼi jo na: ‹Jina wu ɲɛ wu ni.› ");
INSERT INTO myk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Sipya Ja wu ba, na ganha na li na gbuu, a pʼi jo na: ‹Laɲɛhɛrɛ fɔɔ ni gba fɔɔ wu ɲɛ we ná we. Fanhafɛɛ wari shɔvɛɛ ni jurumupyii pii bɛ wo naɲii wu ɲɛ wii.› Ga kaɲii ya kan Kilɛ wo fungɔngɔ fɛɛrɛ ti mu wu kapyegee ki gbɔɔrɔ ni.» ");
INSERT INTO myk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ayiwa, Yesu ya wu kakanhaŋaa nigbɔhɔɔ ki fanha pye kulogoo kiimu ni ge, a wu ɲɔ kɔn na kee kaa yu. Bani kee kulogoo ki shɛɛn ya ta sɔɔ na daajeŋɛ jo pu wo jurumu wu na wɛ. A wʼi jo: ");
INSERT INTO myk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Bɔɔngɔ ki wa yee Korazɛn shɛɛn wogo! Bɔɔngɔ ki wa yee Bɛtisayida shɛɛn wogo! Bani kakanhaŋaa kiimu kʼa pye yee ni ge, kee da bi bye Tiiri ni Sidɔn kulogoo ki ni, nimɛ bi da pee ta pee ya daajeŋɛ jo, na pu jurumu wu yaha lʼa mɔ, na bɔrɔyɔ le puyɛ na, shɔɔnrɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lee wuu na, nʼa da yi jo yi mu jo Tiiri ni Sidɔn wo kanhama keree na ba bɔrɔ yee wogoo ki na kiiri wu cagɔngɔ. ");
INSERT INTO myk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mu do Kapɛrinɔmɔ? Go mu wa giin na mu na ba yirige fo fugba we ni ya? Ahayi dɛ! Mu da ba dirige fo Jahanɛmɛ we ni. Bani kakanhaŋaa kiimu kʼa pye mu ni ge, kee da ba bye Sodɔmu kulo li ni, nimɛ bi da li ta li na ɲɛ sanha. ");
INSERT INTO myk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lee wuu na, nʼa da yi jo yi mu jo Sodɔmu wo kanhama pu na ba bɔrɔ mu wo pu na kiiri wu cagɔngɔ.» ");
INSERT INTO myk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wee tuun wu ni a Yesu di jo: «Na To Kilɛ, fugba ni ɲiŋɛ ki Kafɔɔ, nʼa baraga taha ma na, bani mʼa kii keree kii ŋmɔhɔ fungɔnyɔ fɛɛ ni kalaagbɔ fɛɛ na, na ki shɛ nɔhɔpiire na. ");
INSERT INTO myk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Uun, na To Kilɛ, bani lee lʼa taan mu mu. ");
INSERT INTO myk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nɛ To wʼa keree ki bɛɛri le nɛ keŋɛ ni. Wa shishiin ya Kilɛ Ja wu cɛ wɛ, fo To Kilɛ wu yɛ nigin. Wa shishiin bɛ di ya To Kilɛ cɛ wɛ, fo wu Ja wu yɛ nigin, ni wu la ɲɛ wu To wu shɛ sipya wemu na ge. ");
INSERT INTO myk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yʼa ma na mu, yee piimu bɛɛri pʼa kanha, tuguro di ɲɛ yi ɲuyɔ ni ge; nɛ na ŋmɔnɔ kan yi mu. ");
INSERT INTO myk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yi na wo zhu wu taha yi katiye ni, yʼi yere nɛ di da yi kalaa, yi zɔlɔɔ pu na tifahama ta. Bani nɛ ɲuŋɔ kʼa peŋi, nɛ luu bɛ dʼa taan. ");
INSERT INTO myk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nɛ wo zhu wu ya dugo wɛ, fanha bɛ di ɲɛ nɛ wo tuguro ti ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Caŋa ka Yesu ni wu kalaapiire tʼa pa doroo shinma kɛrɛyɛ ya tɛ ni. Kee caŋa kʼi bi bye Yawutuu pu wo cadɛɛngɛ ka. Lee bi xuugo ta wu kalaapiire ti na, a pee di shinma sɛyɛ ya kɔn, na ganha na yee wo pya wu wo na guri. ");
INSERT INTO myk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ba Farizhɛɛn pʼa lee ɲa wɛ, na Yesu pye: «Li wii, kaa lemu ya yaa li pye cadɛɛngɛ ni-i ge, go lee mu wo kalaapiire tʼa byi mɛ!» ");
INSERT INTO myk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A Yesu di pu pye: «Tuun wemu ni xuugo ya pa saannaa Dawuda ni wu tahama-nɔhɔmɔɔ pu ta ge, wʼa lemu pye ge, yee sanha lee kalaa-i gɛ? ");
INSERT INTO myk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wʼa jé Kilɛ-pɛɛŋɛ puga ki ni, buuri we pʼa wo na gaan Kilɛ mu ge, na wee lɔ. A wu ni wu tahama-nɔhɔmɔɔ pʼi shɛ wee li. Na ta watii bi li wee buuri we ni, ni saraya ɲaha shɔɔnrivɛɛ pu yɛ bɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lʼa ka saliya wu ni na saraya ɲaha shɔɔnrivɛɛ pu ma kapyeŋɛɛ pyi Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni cadɛɛngɛ ni; lee di ɲɛ kakuunɔ wɛ. Ta yee sanha lee bɛ kalaa wɛ? ");
INSERT INTO myk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na ta wa di wa naha wemu ya ye Kilɛ-pɛɛŋɛ pugbɔhɔ ki na ge, di yee jo yi mu. ");
INSERT INTO myk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹Yʼa ɲuŋɔ ɲaari yiyɛ na, nɛ wa lee fɛni, na toro saraya tàan.› Yee da bi pee jomɔ pe kɔri cɛ dɛ, yee bi da jaagi shan pii sipyii pii na tawaga ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bani Sipya Ja wu ɲɛ cadɛɛngɛ ki bɛ Kafɔɔ.» ");
INSERT INTO myk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A Yesu di yìri wà, na gari na shɛ jé pu Kilɛ-pɛɛŋɛ puga ka ni. ");
INSERT INTO myk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lee bi ná wa ta wà wu keŋɛ ke na waha. A sipyii pʼi Yesu yege na: «Na sipya cuuŋɔ cadɛɛngɛ ni, ta lee ya saha?» Pʼa yee jo bani pu bi giin pʼi kaɲuŋɔ sha pʼi wu tɔɔgɔ le. ");
INSERT INTO myk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ga, a Yesu di pu pye: «Dubya nigin pe bu shɛ da wa mu yee ni, a wee dubya wʼi do wege ni cadɛɛngɛ ni, ta wufɔɔ da zhɛ wu wolo wɛ? ");
INSERT INTO myk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ta sipya ya ye fo na shɛ ganha dubya na wɛ? Lee wuu na do, na kasaana pye cadɛɛngɛ ni, lee ya ɲɔ.» ");
INSERT INTO myk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wee tuun wu ni a Yesu di ná wu pye: «Ma keŋɛ ki sanha!» A wu keŋɛ ki sanha, a kʼi juuŋɔ ba keki ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A Farizhɛɛn pʼi foro, na shɛ puyɛ ɲa, kɔnhɔ pʼi gbogana sha Yesu na. ");
INSERT INTO myk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ba Yesu ya lee cɛ wɛ, a wʼi yìri wee xuu wu ni. A sipyiɲɛhɛmɛɛ di daha wu fɛni. Piimu pu bye ni yama ni ge, a Yesu di pee bɛɛri cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ga, a wu yi jo na waha pu mu na wee ɲɛ sipya wemu ge, na pu ganha bu yee jo wa shishiin bɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lee ya pye mu kɔnhɔ Kilɛ bi yemu jo Kilɛ tudunmɔɔ Ezayi ɲɔ na ge, yee ɲɔ di fa na: ");
INSERT INTO myk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Na kapyebye wu we, nɛ wemu ɲaha bulo ge. Na ɲidaan wo we, wu kaa lʼa dan na ni fo xuuni. Nɛ na ba na Munaa li tirige wu na. Wu na ba shi wusama kalaa tiimɛ keree ni. ");
INSERT INTO myk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wʼa da ba nakaara pyi wɛ. Wʼa da ba nama kɔɔn wɛ. Sipya wa shishiin wa da ga wu mujuu logo kakuutoroyo ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wahagaan lemu ya kuri ge, wʼa da ga lee sana kɛgi wɛ. Sokinna wemu kpɛɛngɛ ya jin wà ge, wʼa da ga wee sama fugi wɛ. Mu wʼa da ba bye fo na shɛ tiimɛ pu pye pʼa se ta. ");
INSERT INTO myk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Shi we bɛɛri na ba wu pye pu tadaŋa.» ");
INSERT INTO myk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lee kadugo na a pʼi ba wu mu ni ná wa ni, jinaa pu bye wu ni, wee bye fyɛn, na nɔhɔ pye bobo. A Yesu di wu cuuŋɔ. A wu já na ɲaa, na yu bɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A lee di bye kakanhana sipyiire ti bɛɛri mu, a pʼi ganha na yu na: «Ta we ya sii mɛ saannaa Dawuda Ja wu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ga ba Farizhɛɛn pʼa yee logo wɛ, na jo: «Jinaa ɲuŋɔfɔɔ Belizebuli fanha ni we ná we ya jinaa pu kɔri.» ");
INSERT INTO myk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ga, a Yesu di pu fungɔnyɔ cɛ na jo: «Saanra bɛɛri tʼa yìri tiyɛ kaa na ge, tee na gyɛɛgi. Kulo bɛɛri, kelee puga bɛɛri, ki sipyii bu yìri puyɛ kaa na, kee na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Shitaanni di bu yìri na Shitaanni wa kɔri, li ɲɛ kanna Shitaanni wʼa yìri wuyɛ kaa na. Shitaanni di bu yìri wuyɛ kaa na, wu saanra ti na bye dii kyɛɛgi baa wɛ? ");
INSERT INTO myk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni yee wa yu na jinaa ɲuŋɔfɔɔ Belizebuli baraga ni nɛ jinaa pu kɔri, wee tuun wu ni yee wo sipyii piimu pʼa pu kɔri ge, pee di pu kɔri jɔgɔ baraga ni wɛ? Yee wo sipyii puyɛ pyaa ki da ba kiiri kɔn yee na. ");
INSERT INTO myk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ga nɛ bu da nɛ na jinaa pu kɔri Kilɛ Munaa li baraga ni, lee wʼa li shɛɛ na Kilɛ saanra tʼa nɔ yee na. ");
INSERT INTO myk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Wa na já pye dii na jé fanhaɲɛhɛŋɛ fɔɔ puga, di wu yaŋmuyɔ kuu na ta ma ya fɛnhɛ wu pɔ-ɛ wɛ? Ga ma bu fɛnhɛ wu pɔ, ma na já jé puga ki ni na yaŋmuyɔ yi kuu. ");
INSERT INTO myk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Sipya wemu ɲɛ nɛ ɲii wɛ, nɛ pɛn wu ɲɛ weefɔɔ. Sipya wemu ya nɛ tɛri na sipyii pu pinnɛɛ wɛ, weefɔɔ ya pu caaga. ");
INSERT INTO myk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lee wuu na, nʼa da yi jo yi mu jo sipyii ya jurumu wemu bɛɛri pyi, na fanhara temu bɛɛri pyi Kilɛ na ge, kee bɛɛri na já yafa pu mu. Ga wa bu Fɛfɛɛrɛ Munaa li fanha, wufɔɔ da lee wo yafa ta bada wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sipyaa sipya wʼa joguumɔ jo wá Sipya Ja na ge, lee na yafa wufɔɔ mu. Ga wemu bu Fɛfɛɛrɛ Munaa li mɛgɛ kyɛɛgi, weefɔɔ da lee wo yafa ta naha ke koŋɔ ke na wɛ, wʼi da li yafa ta laxhara bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Tige kemu bu ɲɔ, ki yasɛyɛ bɛ na ɲɔ. Tige kemu bu golo, ki yasɛyɛ bɛ na golo, bani ki yasɛyɛ fɛni pʼa tige cɛni. ");
INSERT INTO myk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yee piimu pʼa kolo ba mateŋɛɛ ɲɛ-ɛ ge, dii yee di da já kafila nizaama jo wɛ? Bani lemu lʼa sipya zɔ we ɲi ge, lee lʼa fòro wu ɲɔ ke ni. ");
INSERT INTO myk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sipyisaama wʼa yasaaya kilee na yeege wu yasaaya tayahaŋa ni; sipyikuuŋɔ di yakuuyo kilee na yeege ki yakuuyo tayahaŋa ni. ");
INSERT INTO myk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nʼa da yi jo yi mu jo sipyii ya joguumɔ pemu bɛɛri yu ge, pu na ba yege yee bɛɛri na kiiri wu cagɔngɔ. ");
INSERT INTO myk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kiiri na ba gɔn ma na, na kaɲii kan ma mu na saha ni ma ɲɔjomɔ pu ni, kelee na ma jaagi na saha ni ma ɲɔjomɔ pu ni.» ");
INSERT INTO myk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ayiwa, a saliya karamɔgɔlɔɔ pii, ni Farizhɛɛn pii di Yesu pye: «Karamɔgɔ, wèe funŋɔ ki wa mʼa ɲaha shɛshɛɛrɛ kakanhana la pye ma shɛ wù na.» ");
INSERT INTO myk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A Yesu di pu ɲɔ shɔ na: «Niɲaa sipyii pii pʼa kolo, na nɔhɔ pye ɲɔmɛɛ baa fɛɛ ge, pee pʼa ɲaha shɛshɛɛrɛ kakanhana shaa, ga la shishiin da zhɛɛ pu na wɛ, fo Kilɛ tudunmɔɔ Zhonasi wuu le. ");
INSERT INTO myk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ba Zhonasi ya ta caya taanri ni piiye taanri fya nagaŋa ki funŋɔ ni wɛ, mu Sipya Ja wu bɛ da ba da caya taanri ni piiye taanri ɲiŋɛ ke ni. ");
INSERT INTO myk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive shɛɛn na ba yìri na niɲaa wo sipyii pii jaagi kiiri wu cagɔngɔ caŋa, bani Ninive shɛɛn ya daajeŋɛ jo pu wo jurumu wu na Zhonasi wo Kilɛ jomɔ yɛrɛ li baraga ni. Na ta wa di ɲɛ naha wemu ya ye Zhonasi na ge. ");
INSERT INTO myk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kiiri wu cagɔngɔ, Seba fiige ki Saanzhɔ wu na ba yìri wu niɲaa sipyii pu jaagi, bani wee ya pa na yìri ɲiŋɛ ki tɛhɛnɛ na. Kɔnhɔ wu ba saannaa Solomani wo fungɔngɔ fɛɛrɛ jomɔ pu logo. Wa di wa naha wemu wʼa pɛlɛ Solomani na ge! ");
INSERT INTO myk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Jina bu foro sipya ni tuun wemu ni, tɛyɛ yemu yʼa waha waha ge, wʼa ganha na ɲaari yee ni na taŋmɔŋɔ shaa, ga wʼi da ki ta wɛ. ");
INSERT INTO myk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Wee tuun wu ni wʼa jo wuyɛ funŋɔ ni na: ‹Na puga kemu ni nɛ foro ge, nʼa da guri da se kee ni.› Wʼa guri kari, na shɛ kee puga ki niwaga ta pʼa ki pɔ fɛɛfɛɛ, na ki kemɛ xuuni. ");
INSERT INTO myk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Wee tuun wu ni wʼa gari na shɛ ba ni jinaa gbarashuun watii ni, piimu ya kolo wuyɛ pyaa ki na ge. Wu ni pee na ba jé kee puga ki ni, na diin wà. Lee funŋɔ ni wee sipya we wo taxɔgɔ na ba golo na toro taashiinɛ li bɛ tàan. Mu shiin lʼa da ba bye niɲaa wo sipyikuuyo ye bɛ wo shizhaa na.» ");
INSERT INTO myk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ayiwa, na Yesu yaha wu na yu ni sipyiire ti ni, a wu nu we, ni wu ceboronamaa pʼi nɔ, na yere kpɛɛngɛ ki na. Pu funŋɔ ki bye pʼi jo ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A sipya wa di Yesu pye: «Ma nu we ni ma ceboronamaa pu niyereye yi wa kpɛɛngɛ ke na, pu funŋɔ ki wa pʼi jo ni ma ni.» ");
INSERT INTO myk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A Yesu di wee ɲɔ shɔ na: «Jɔgɔ yɛ pu ɲɛ nɛ nu ni nɛ ceboronamaa pu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ba wʼa yee jo wɛ, na keŋɛ shɛ wu kalaapiire ti na, na jo: «Nɛ nu ni nɛ ceboronamaa pu piiri naha. ");
INSERT INTO myk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nɛ To we wu ɲɛ fugba wu ni ge, sipyaa sipya wʼa wee wo ɲidaan pyi ge, wee wu ɲɛ nɛ ceborona, ni nɛ ceboroshɔ, ni nɛ nu.» ");
INSERT INTO myk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kee caŋa kiyɛ pyaa a Yesu di foro puga ki ni, na gari na shɛ diin Galile Gba wu ɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A sipyiɲɛhɛmɛɛ di ba binnɛ, na wu maha fo wʼa jé tiin kɔrɔgɔ ka ni. A sipyiire ti bɛɛri di yere lɔhɔ ki ɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A wu ganha na keree niɲɛhɛŋɛɛ yu pu mu taleŋɛɛ ni. A wu jo: «Caŋa ka ná wa ya foro na kari wu tɛgɛ ni di zhɛ wu alikama shi wá fenɛ shi wagana na. ");
INSERT INTO myk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na wu yaha wu na wee nuguzhi wu waa, a wu nuguro ta di do koo ni tɛgɛ ki ɲɔ na. A shazhɛɛrɛ di ba tee jɔ. ");
INSERT INTO myk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A ta di do faaga ɲuŋɔ ni pogoo kii ni. A tee di wɛri fin, bani poɲɛhɛrɛ bye wà wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba caya yʼa pa yeree wɛ, a tʼi fanhaŋa, na waha, bani nire tatii bye ti na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A nuguro ta di do xhuyo niŋɛ ni. A xhuyo yʼi ganha na lɛgi, na ba ti co, na ti li. ");
INSERT INTO myk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A nuguro ta di do ɲijeŋɛ na. A tee di fin, na lɛ na pya le. Pile la ma pyaa xhuu nigin (100) pye, la ma kɛlɛɛ gbaara (60) pye, la ma kɛlɛɛ taanri (30) pye.» ");
INSERT INTO myk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ba wʼa yee jo xɔ wɛ, na jo: «Wemu na logo ge, wu logo.» ");
INSERT INTO myk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lee kadugo na a Yesu kalaapiire tʼi fulo wu na, na wu pye: «Ɲaha na mu di yu ni sipyiire ti ni taleŋɛɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A Yesu di pu pye: «Na fugba saanra ti wo ŋmɔhɔrɔ ti cɛ, yee mu lee ya kan. Ga ti jɛ wu ya ta kan pii mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bani la ɲɛ wemu mu ge, la na ba gan wee mu na fara lee na, lʼa ɲɛhɛ wu mu. Ga la ɲɛ wemu mu wɛ, ali nifɛnhɛfɛnhɛnɛ lemu bɛ li ɲɛ wu mu ge, li bɛ na zhɔ wu na. ");
INSERT INTO myk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lee wuu na nɛ yu ni pu ni taleŋɛɛ ni, bani pu wa na wii, pʼi ya yaaga ɲaa wɛ. Pʼa niwegee shaan, pʼi ya yi nuri wɛ, pʼi ya yi ɲaha bɛ cɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kilɛ tudunmɔɔ Ezayi ya yemu jo pu shizhaa na ge, yee ɲɔ ya fa na: ‹Yee na ba niwegee shan, na yi logo, ga yʼi wa da yi ɲaha cɛ wɛ. Yi na ba ɲìi taan, na wii, ga yʼi wa da yaaga bɛ ɲa wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bani pii sipyii pii niwegee kʼa waha. Pʼa pu niwegee tɔ, na pu ɲìi tɔ. Pu funŋɔ ya pye pʼi ɲa pu ɲìi ki ni wɛ, pʼi logo pu niwegee ki ni wɛ, pʼi yi ɲaha cɛ pu fungɔnyɔ yi na wɛ. Lee funŋɔ ni pu da ba nɛ mu, kɔnhɔ nɛ pu cuuŋɔ wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ga yee kunni, yee ɲɛ duba nagoo, bani yee ɲìi ki wa ɲaa, yi niwegee kʼi nuri. ");
INSERT INTO myk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Can na nʼa da yi jo yi mu, lemu yee wa ɲaa ge, Kilɛ tudunmɔɔ niɲɛhɛmɛɛ ni sipyitiimɛɛ niɲɛhɛmɛɛ pii funŋɔ ya pye na lee ɲa, ga pʼi ya li ɲa wɛ. Yemu yee wa nuri ge, pu funŋɔ ya pye na yee logo, ga pʼi ya yi logo wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ayiwa, yi niwegee shan ni nuguro ti wo talenɛ li kɔri wu ni. ");
INSERT INTO myk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Piimu pʼa fugba saanra ti jomɔ pu nuri, pʼi ya pu ɲaha cɛ-ɛ ge, pee ɲɛ ba koo ɲɔ nuguro ɲɛ wɛ. Shitaanni na ba pee jomɔ pe wolo pu funyɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Faaga wo nuguro ti ɲɛ piimu ge, pee na jomɔ pu logo, na pu co tɔvuyo na ni fundanga ni. ");
INSERT INTO myk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ga nire di ɲɛ pu na wɛ, pʼa bye pu da mɔ lee ni wɛ. Cɔnrɔmɔ bu wa ta, kelee sipyii bu daha wu fɛni na gana pee jomɔ pe wuu na, wu ɲuŋɔ na wakaraa kyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xhuyo niŋɛ wo nuguro ti ɲɛ piimu ge, pee na jomɔ pu logo, ga ke koŋɔ ke wo funzhakeree ni naafuu la piinŋɛ na pu cɔnri fo pu da nagoo pye wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɲijeŋɛ wo nuguro ti ɲɛ piimu ge, pee na pe jomɔ pe logo, na pu ɲaha cɛ. Pʼa nagoo niɲɛhɛmɛɛ pye. Pile la ma pyaa xhuu nigin (100) pye, la ma kɛlɛɛ gbaara (60) pye, la ma kɛlɛɛ taanri (30) pye.» ");
INSERT INTO myk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ayiwa, a Yesu di talenɛ la bɛ jo pu mu na: «Fugba saanra tʼa foro kaa lemu fɛni ge, lee li wa mɛ. Ná wa wʼa yashi nijemɛ wá wu tɛgɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A wee ná wu pɛn di ba yìri nibiige ka ni, na sipyii pu bɛɛri yaha pu na ŋmunɔɔ. Ɲà kemu kʼa foro alikama fɛni ge, na shɛ kee ɲakuuŋɔ ki wo pya wa wá alikama wu tɛ ni, na gari. ");
INSERT INTO myk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A alikama wu fin, na ba sɛyɛ pye. A ɲakuuŋɔ ki bɛ di foro yere. ");
INSERT INTO myk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A tɛgɛ ki kafɔɔ wu wo kapyebyii pʼi ba wu pye: ‹Wù kafɔɔ, ta yashi nijemɛ bɛ mu ya wá ma tɛgɛ ki ni wɛ? Ke ɲakuuŋɔ ke dʼa yìri mii wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A wu pu ɲɔ shɔ na: ‹Nɛ wo pɛn wa wʼa le pye.› A kapyebyii pʼi wu pye: ‹Ta ma funŋɔ ki wa wù shɛ kee ɲakuuŋɔ ke kɔɔngi?› ");
INSERT INTO myk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A wu jo: ‹Ahayi, nɛ fyagi jo yee bu shɛ kee kɔɔngi, yi ganha bu da alikama wu bɛ kɔɔngi wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yi yi bɛɛri yaha wà yʼi binnɛ lɛ. Yalɔɔrɔ ti lɔduun ba nɔ, wee tuun wu ni nɛ na ba yi jo yalɔɔrɔ ti lɔvɛɛ pu mu jo pu fɛnhɛ ɲakuuŋɔ ke kɔn fɔlɔ, pʼi ki pɔ, pʼi ki sòrogo, pu bu xhɔ pʼi alikama wu kemɛ le na kpɔɔn le ni.›» ");
INSERT INTO myk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Lee kadugo na a Yesu di talenɛ la bɛ jo pu mu sanha na: «Fugba saanra tʼa foro mutaridi pile fɛni. A ná wa di li lɔ nugi wu tɛgɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lʼa cɛ̀rɛ foro yashi wusama bɛɛri tàan, ga li bu fin tuun wemu ni, lʼa bɛlɛ na toro naxhoo wu tiye yi saya bɛɛri tàan. Lʼa ɲɛri tige fo shazhɛɛrɛ na ti shiire tɛri ki geye na.» ");
INSERT INTO myk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ayiwa, a Yesu di talenɛ la bɛ jo pu mu sanha na: «Fugba saanra ti ɲɛ ba buuri shizhɛnhɛrɛ ɲɛ wɛ. Cee wa ya tee le wu farani myɛ kiloo kɛlɛɛ shuun ni kaguro (25) ni na tɔnhɔ, a wu bɛɛri di yìri.» ");
INSERT INTO myk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A Yesu di pe jomɔ pe bɛɛri jo sipyiire ti mu taleŋɛɛ ni. Wu bi yu ni pu ni talenɛ baa wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wʼa lee pye kɔnhɔ Kilɛ tudunmɔ wʼa bi yemu jo ge, yee ɲɔ di fa na: «Nɛ na ba yu ni pu ni taleŋɛɛ ni. Keree kiimu kʼa bi ŋmɔhɔ fo koŋɔ ki yaaduun wu ni ge, nɛ na ba kee yu pu mu.» ");
INSERT INTO myk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ayiwa, a Yesu di sipyiire ti yaha wà, na gari puga. A wu kalaapiire tʼi fulo wu na, na wu pye: «Ɲakuuŋɔ ki kʼa foro tɛgɛ ki ni ge, lee talenɛ le kɔri jo wù mu.» ");
INSERT INTO myk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A Yesu di jo: «Wemu wʼa yashi nijemɛ wu wá ge, wee ɲɛ Sipya Ja. ");
INSERT INTO myk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tɛgɛ ke, kee ɲɛ koŋɔ ke yashi nijemɛ we, wee ɲɛ fugba saanra ti wo nagoo pee. Ɲakuuŋɔ ke, kee di ɲɛ Shitaanni wo nagoo pee. ");
INSERT INTO myk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pɛn wemu wʼa ɲakuuŋɔ ki pya wu wá ge, wee ɲɛ Shitaanni wuyɛ pyaa. Yalɔɔrɔ ti lɔduun we, wee ɲɛ koŋɔ ki taaxɔɔ le. Yalɔɔrɔ ti lɔvɛɛ pee, pee ɲɛ mɛlɛkɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ba sipya ma ɲakuuŋɔ kɔɔngi, na ki wá mɛ na ni wɛ, mu lʼa da ba bye koŋɔ ki taaxɔɔ li ni. ");
INSERT INTO myk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Piimu bɛɛri pʼa sipyii pu ɲuŋɔ kyɛɛgi nʼa daa wu na, ni piimu pʼa kakuuŋɔɔ pyi ge, Sipya Ja wu na ba wu mɛlɛkɛɛ pu tun pʼa shɛ pee sipyii pii bɛɛri niŋɛ wolo wu wo saanra ti ni, ");
INSERT INTO myk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na pu wá kanragaa na ki ni. Pʼa ganha na mɛhɛɛ suu wà, na ganhaa kuri. ");
INSERT INTO myk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ga piimu pʼa pye sipyitiimɛɛ Kilɛ mu ge, pee na ba ɲí pu To wu saanra ti ni ba caŋa ɲɛ wɛ. Wemu na ye logo ge, wu yi logo.» ");
INSERT INTO myk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A Yesu di jo sanha na: «Fugba saanra ti ɲɛ ba naafuu ɲɛ wɛ, naafuu wemu wʼa ŋmɔhɔ tɛgɛ ka ni ge. A ná wa di wu ɲa, na guri wu ŋmɔhɔ sanha. A wu fundanga wo di shɛ wu keŋɛ yaŋmuyɔ bɛɛri pɛrɛ, na ba kee tɛgɛ ki shɔ.» ");
INSERT INTO myk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A Yesu di jo sanha na: «Fugba saanra ti ɲɛ ba kuun pɛrɛvɔɔ ɲɛ wɛ, wemu ya kuun nizaama shaa ge. ");
INSERT INTO myk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ba wʼa kuun pɛɛwa wo wa ɲa wɛ, a wu wu keŋɛ yaŋmuyɔ bɛɛri pɛrɛ, na shɛ wee kuun wu shɔ.» ");
INSERT INTO myk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A Yesu di nugo jo sanha na: «Fugba saanra ti ɲɛ sanha bɛ ba jɔ̀ ɲɛ wɛ, sipyii ma wu wá gba lɔhɔ ni, na fyaa tuuyo bɛɛri co. ");
INSERT INTO myk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ba jɔ̀ wʼa ɲi wɛ, jɔwaa pu na wu yeege shan gba wu ɲɔ ki na. Pʼa diin, na fyaa pu shɔɔnri. Pʼa fyacemɛɛ pu le pu yɛrɛyɛ ni, na niguuyo yi wá. ");
INSERT INTO myk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mu lʼa da ba bye koŋɔ ki taaxɔɔ li ni. Mɛlɛkɛɛ pʼa da ba sipyisaamaa pu shɔɔnri na wolo sipyikuuyo yi ni. ");
INSERT INTO myk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pʼa sipyikuuyo yi wá kanragaa na ki ni. Pʼa ganha na mɛhɛɛ suu, na pu ganhaa kuri wà.» ");
INSERT INTO myk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lee kadugo na a Yesu di pu yege na: «Ta yee ya kii keree kii bɛɛri ɲaha cɛ?» A pʼi jo: «Uun.» ");
INSERT INTO myk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A wu pu pye sanha na: «Ayiwa, saliya karamɔgɔ wa bɛɛri wʼa kalaa fugba saanra ti keree ki ni ge, wee ya foro puga fɔɔ wa fɛni wemu ya kafoŋɔɔ ni kalɛgɛɛ taa na fòro wu naafuu tayahaŋa ni ge.» ");
INSERT INTO myk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ba Yesu ya taleŋɛɛ ki jo xɔ wɛ, na laha wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kulo lemu ni wʼa lɛ ge, a wu gari wà, na shɛ sipyiire ti ɲɔ kɔn na galaa Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. A lee di bye pu mu kakanhana, a pʼi ganha na yu na: «Mii wu dʼa te fungɔngɔ fɛɛrɛ te ta wɛ? Dii wu dʼa pye na jani kii kakanhaŋaa kii na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ta wu ɲɛ mɛ mɛnizhe ná wu ja wu wɛ? Ta wu nu bɛ wu ɲɛ mɛ Mariyama wɛ? Ta wu ceboronamaa bɛ pu ɲɛ mɛ Yakuba, Yusufu, Simɔ ni Zhude wɛ? ");
INSERT INTO myk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ta wu ceboroshaa pu bɛɛri bɛ pu ɲɛ naha wù niŋɛ ni wɛ? Wu dʼa yìri mii ni ke fanha ke bɛɛri ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A kee keree kii di pu pye pu ya dà Yesu na wɛ. A Yesu di pu pye: «Kilɛ tudunmɔ ya pɛɛŋɛ taa xuu bɛɛri ni, fo wuyɛ pyaa kulo le, ni wuyɛ pyaa puga ke.» ");
INSERT INTO myk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A wʼi bye wu ya kakanhaŋaa niɲɛhɛŋɛɛ pye wà wɛ, bani pu ya dà wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wee tuun we ni gbafɛnɛɛrɛɛ Hɛrɔdi Antipasi ya Yesu kaa logo. ");
INSERT INTO myk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A wu wu kapyebyii pu pye: «Yohana Batizelipye wu ɲɛ we ná we, wee wʼa sii wii. Wʼa ɲɛ na foro xu ni, lee lʼa wu pye wu na jani kii kakanhaŋaa kii na.» ");
INSERT INTO myk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ayiwa, Hɛrɔdi bi pu pye pʼa Yohana co, na shɔnhɔyɔ le wu na, na wu le kaso ni. Wu ceborona Filipe shɔ Hɛrɔjasi wuu na Hɛrɔdi bi lee pye. ");
INSERT INTO myk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bani Yohana bi li shɛɛ wu na na: «Li ya ta saha mu wu we cee we leŋɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛrɔdi funŋɔ ki bye na Yohana gbo, ga wu bi fyagi sipyiire ti na, bani pee bi Yohana jateni Kilɛ tudunmɔ. ");
INSERT INTO myk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lee bɛ na, a Hɛrɔdi wo cazege caŋa ki wo kalenɛ lʼi ba nɔ, a Hɛrɔjasi poro fucɛɛrɛ lʼi yìri na xhɔnhɔ sipyiyirilee pu ɲahagbaa na. A lee di sii taan Hɛrɔdi ni, ");
INSERT INTO myk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","fo wʼa kàa fucɛɛrɛ li mu na li bu yaaga bɛɛri ɲɛɛri wee mu, na wee na kee kan li mu. ");
INSERT INTO myk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Li nu wu wo ɲɔjomɔ funŋɔ ni, a fucɛɛrɛ lʼi Hɛrɔdi pye: «Yohana Batizelipye ɲuŋɔ taha yaaga ka na ma kan nahamɛ na mu!» ");
INSERT INTO myk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A lee di saan wu ɲaha tanha. Ga na wu yaha wʼa kàa na xɔ wu sipyiyirilee pu ɲii na, a wu ɲuŋmuu li ɲɔ yaha fucɛɛrɛ li mu. ");
INSERT INTO myk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A wu wa yaha kari wʼa shɛ Yohana ɲuŋɔ ki kɔn kaso wu ni. ");
INSERT INTO myk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A pʼi ba ni ki ni, na ki taha yaaga ka na, na pa gan fucɛɛrɛ li mu lʼa shɛ gan li nu wu mu. ");
INSERT INTO myk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A Yohana wo kalaapiire tʼi shɛ wu nixhugo ki lɔ na shɛ le, na xhɔ na shɛ yee ɲaha jo Yesu mu. ");
INSERT INTO myk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ba Yesu ya yee logo wɛ, a wu jé kɔrɔgɔ ka ni, na yìri wee xuu wu ni, na laha sipyiire ti tàan na kari sipoŋɔ ki xuu wa ni. Ga, a sipyiire tʼi wee xuu wu cɛ. A pʼi foro kanha ni ni, na gari tɔɔyɔ na Yesu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ba Yesu ya foro kɔrɔgɔ ki ni wɛ, na pee sipyiɲɛhɛmɛɛ pu ɲa, a pu ɲiɲaara di jé wu ni. A wu pu yama fɛɛ pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ba yakoŋɔ kʼa pa nɔ wɛ, a Yesu wo kalaapiire tʼi fulo wu na, na wu pye: «Caŋa kʼa xɔ toro, wèe di ɲɛ sipoŋɔ ni naha. Sipyiire ti yaha kɔnhɔ pʼi shɛ yaligee sha shɔ kulogoo ki ni.» ");
INSERT INTO myk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Yesu di pu pye: «Pu ya yaa na kari wɛ, yiyɛ pyaa ki yalige kan pu mu!» ");
INSERT INTO myk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ga, a pʼi wu pye: «Buuri ɲuyɔ kaguro ni fyaa shuun yɛ wu ɲɛ wèe mu naha.» ");
INSERT INTO myk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A Yesu di pu pye: «Yi pa ni yee ni naha!» ");
INSERT INTO myk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lee kadugo na a Yesu di sipyiire ti pye na pu tiin ɲapurege ki ni. A wu yee buuri ɲuyɔ kaguro ni fyaa shuun wu lɔ, na ɲaha ke yirige le fugba we ni, na baraga taha Kilɛ na. A wu xhɔ na yee buuri ɲuyɔ yi kɛgi kɛgi na kan wu kalaapiire ti mu, a pee di wu kan sipyiire ti mu. ");
INSERT INTO myk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A pu bɛɛri di li na din. Yalige kemu kʼa kori ge, a pʼi kee saŋa kemɛ fo na sagaŋaa kɛ ni shuun ɲi. ");
INSERT INTO myk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pee yalilimɛɛ pii bye sipyii namaa kabɔfoŋɔɔ kaguro (5.000) shi, cèe ni nɔhɔpiire niŋɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ba pʼa xɔ wɛ, taapile ni a Yesu di yi jo waha wu kalaapiire ti mu, na pu jé kɔrɔgɔ ki ni, pʼi gba wu kɔn wu ɲaha na, yani wu sipyiire ti yaha ge. ");
INSERT INTO myk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ba wʼa pu yaha xɔ wɛ, na dugi kari faaboboŋɔ ki na wu yɛ nigin, na shɛ Kilɛ ɲɛɛri. A piige kʼi ba wɔ na wu yaha wu yɛ wà. ");
INSERT INTO myk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kɔrɔgɔ ki bi lii na xɔ koɲɔ ki na. A lokuruyo di ganha na ki sani, bani kafɛɛgɛ ki bi jirini pu na. ");
INSERT INTO myk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xhupee mɛhɛɛ suduun wu ni, a Yesu di ganha na ɲaari lɔhɔ ki ɲuŋɔ ni na se wu kalaapiire ti yíri. ");
INSERT INTO myk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba kalaapiire tʼa wu ɲa wu na ɲaari lɔhɔ ki ɲuŋɔ ni wɛ, a pu jaalaa di yìri fo xuuni. A pʼi ganha na yu: «Yafugunɔ li ɲɛ le!» A pʼi fya fo na sipyaa waa. ");
INSERT INTO myk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ga taapile ni a Yesu di pu pye: «Yi yi logoo ki waha, nɛ wu wa, yi ganha bu da vya wɛ!» ");
INSERT INTO myk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A Pyɛɛri di jo: «Kafɔɔ, ni mu wu wʼa sii wii, na pye na bɛ di ɲaari shɛ ma yíri lɔhɔ ki fugba ni.» ");
INSERT INTO myk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A Yesu di wu pye: «Ta ma!» A Pyɛɛri di foro kɔrɔgɔ ki ni, na ganha na ɲaari na se Yesu yíri lɔhɔ ki fugba ni. ");
INSERT INTO myk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ga wʼa pa kafɛɛgɛ ki ta kʼa pɛlɛ ge, na fya. A wu ɲɔ kɔn na diri lɔhɔ ki ni, na sipile wá na: «Kafɔɔ, na shɔ!» ");
INSERT INTO myk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Taapile ni a Yesu di wu keŋɛ yeege na wu co, na wu pye: «Mu wo nʼa daa wʼa kanha cɛ̀rɛ ba! Ɲaha na ma dʼa mayɛ kaala wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A pu shuun wu bɛɛri di jé kɔrɔgɔ ki ni, a kafɛɛgɛ kʼi yere. ");
INSERT INTO myk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayiwa, piimu pʼa bye kɔrɔgɔ ki ni ge, a pee di nuguro sin Yesu fɛɛ ni, na wu pɛlɛ na wu pye: «Can na Kilɛ Ja mu ya sii!» ");
INSERT INTO myk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A Yesu ni wu kalaapiire tʼi gba wu kɔn, na nɔ Zhɛnɛzarɛti fiige ki ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A wee xuu wu wo sipyii pʼi Yesu cɛ. A pʼi wu kaa caaga taga wee xuu wu bɛɛri círi, fo sipyii pu na pu yama fɛɛ pu tugoo na ma. ");
INSERT INTO myk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A pʼi Yesu ɲɛɛri na wu yere pʼi gbɔn yɛ wu fadegeŋɛ ke na. Sipyii piimu bɛɛri pʼa kpɔn ki na ge, a pee bɛɛri di juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farizhɛɛn pʼa, ni saliya karamɔgɔlɔɔ pii bi yìri Zheruzalɛmu ni na pa Yesu yíri. A pee di ba wu yege na: ");
INSERT INTO myk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ɲaha na mu wo kalaapiire tʼi wèe sefɛlɛɛ pu wo kalɛgɛɛ ki kyɛɛgi wɛ? Pu ba da li, pu da pu keye je wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A Yesu di pu pye: «Yee do? Ɲaha na yee di Kilɛ wo ɲɔmɛhɛɛ ki kyɛɛgi yi wo kalɛgɛɛ ki fɛni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kilɛ ya jo: ‹Ta ma to ni ma nu pɛlɛ.› Wʼa jo sanha na: ‹Wa bu joguumɔ jo ni wu to kelee ni wu nu ni, na weefɔɔ ya yaa na wu gbo.› ");
INSERT INTO myk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ga yee kunni wa sipyii pu kalaa na sipya bɛɛri wʼa wu to kelee wu nu pye na: ‹Nɛ bi da já na naafuu wemu taga mu tɛgɛ ge, wee ya kan xɔ Kilɛ mu.› ");
INSERT INTO myk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na li ɲɛ nige fanha kaa weefɔɔ ɲuŋɔ ni wu wu to kelee wu nu wu tɛgɛ wɛ. Lee funŋɔ ni yee ya Kilɛ jomɔ pu pye ɲuŋɔ baa, na daha yiyɛ pyaa wo kalɛgɛɛ fɛni. ");
INSERT INTO myk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yee shuun shuun jovɛɛ piiri! Kilɛ tudunmɔɔ Ezayi ya kapaŋaa kiimu jo yee shizhaa na ge, kʼa saha fo xuuni. Wʼa bi jo: ");
INSERT INTO myk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Ɲɔyɔ yɛ ni pii sipyii pii ya nɛ pɛlɛ, ga pu zɔlɔɔ dʼa lii nɛ na fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tawaga ni pʼa nɛ pɛlɛ, pu wo kalaa wʼi ɲɛ sipyii wo ɲɔmɛhɛɛ yɛ.›» ");
INSERT INTO myk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A Yesu di sipyiire ti yiri, na pu pye: «Yi niwegee shan yʼi ye logo! ");
INSERT INTO myk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaaga kemu kʼa jin sipya ɲɔ ni, na se ma funŋɔ ke ni ge, kee ya sipya nɔrɔgɔ wɛ. Ga lemu lʼa fòro sipya ɲɔ ke ni ge, lee lʼa wu nɔrɔgɔ.» ");
INSERT INTO myk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A Yesu wo kalaapiire tʼi fulo wu na, na wu pye: «Go mʼa li cɛ na ma jomɔ pʼa waha Farizhɛɛn pu na gɛ?» ");
INSERT INTO myk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A wu pu pye: «Tige bɛɛri ki ɲɛ nɛ fugba To Kilɛ we ya ta ki nɔri-i ge, yee bɛɛri na ba gɔɔngi laha wà. ");
INSERT INTO myk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi pu yaha wà, fyɛnmɛɛ pu ɲɛ pii, na fyɛnmɛɛ pii wo kagaangaa co. Fyɛn wa bu fyɛn wa kagaan co, pu shuun wu bɛɛri na do wege ni.» ");
INSERT INTO myk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A Pyɛɛri di jo: «Lee talenɛ le kɔri jo wù mu.» ");
INSERT INTO myk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A Yesu di jo: «Yee bɛ sa! Yee sanha sii fungɔngɔ fɛɛrɛ ta-ɛ ya? ");
INSERT INTO myk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ta yee ya li cɛ na yaaga yaaga kʼa jin sipya ɲɔ ni ge, ma yacɛrɛ le ni kee ma jé, lee kadugo tàan na ba shɛ foro yaara tashɛgɛ ke ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ga lemu lʼa fòro sipya ɲɔ ke ni ge, wu zɔ we ni lee ya fòro. Lee lʼa sipya nɔrɔgɔ. ");
INSERT INTO myk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sipya zɔ we ni fungɔnkuuyo ye ya fòro ma na jo sipyigbuu, dɔdɔɔrɔ, ceshaara ni namazhaara, ni nagaara, ni kafinɛyɛ, ni mɛkyɛɛgɛrɛ. ");
INSERT INTO myk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kee keree kii kʼa sipya nɔrɔgɔ, ga na li ni kejebaaya ni, lee ya sipya nɔrɔgɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lee kadugo na a Yesu di yìri wee xuu wu ni, na gari Tiiri ni Sidɔn fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kana shɛn cee wa bye tiinnɛ na kee fiige ki ni. A wee di ba Yesu mu, na mujuugbɔɔ wá na: «Kafɔɔ, Dawuda Ja we, ɲuŋɔ ɲaari na na, jina wa wu ɲɛ nɛ poro fucɛɛrɛ li ni, wee ya wu kana fo xuuni.» ");
INSERT INTO myk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ga Yesu ya ta wu ɲɔ shɔ ali ni kafila kaŋa nigin bɛ ni wɛ. A wu kalaapiire tʼi fulo wu na, na wu ɲɛɛri na wu wee cee we le koo ni, kɔnhɔ wu ganha ba xhuulo da ɲaari pu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A Yesu di pu pye: «Nɛ ta tun piitiilee mu wɛ, fo Izirayɛli wo nagoo pu yɛ, pee piimu pʼa piin ba dubyaa ɲɛ-ɛ ge.» ");
INSERT INTO myk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A wee cee wu ba nuguro sin Yesu fɛɛ ni, na wu ɲɛɛri na: «Kafɔɔ, na tɛgɛ!» ");
INSERT INTO myk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A Yesu di wu pye: «Li ya ta saha pu nɔhɔpiire yalige lɔ wá pobiire mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A cee wu jo: «Yee wa can, Kafɔɔ. Ga yaliɲahara temu tʼa yìri pobiire ti kafɔɔ wu tabali wu fugba ni, na dun ɲiŋɛ na ge, pobiire ti wa tee li.» ");
INSERT INTO myk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A Yesu di wu pye: «Cee we, ma nʼa daa wʼa pɛlɛ. Kilɛ wu li pye ma mu na saha ni ma ɲidaan ni.» A cee wu poro fucɛɛrɛ lʼi juuŋɔ lee taapile li ni. ");
INSERT INTO myk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Lee kadugo na a Yesu di yìri wee xuu wu ni, na gari Galile Gba wu ɲɔ na. A wu dugi tiin faaboboŋɔ ka na. ");
INSERT INTO myk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A sipyiire tʼi ganha na ma wu mu ni yama fɛɛ tuuyo bɛɛri ni: tɔrɔɔ nigin nigin fɛɛ, fyɛnmɛɛ, taa fɛɛ, boboo ni yama fɛɛ niɲɛhɛmɛɛ piitiilee bɛ. A pʼi ba ni pee yama fɛɛ pu ni Yesu mu, a wu pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ba sipyiire tʼa boboo pu ɲaa pu na yu, taa fɛɛ pʼi juuŋɔ, tɔrɔɔ nigin nigin fɛɛ di ɲaari, fyɛnmɛɛ di ɲaa wɛ, a lee di bye pu mu kakanhana fo xuuni. A pʼi ganha na Izirayɛli wo Kilɛ wu sɔni. ");
INSERT INTO myk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ayiwa, a Yesu di wu kalaapiire ti yiri, na pu pye: «Pii sipyii pii ɲiɲaara ti wa nɛ ni, bani niɲaa ɲɛ pu caŋa taanri wogo nɛ yíri naha, ɲɔyalige ka shishiin di ɲɛ nige pu mu wɛ. Nɛ funŋɔ wa di pu kuugo wuu le koo ni, pu fanha ki pa shɛ xhɔ koo na wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A wu kalaapiire tʼi wu pye: «Mii wèe di da yalige ta naha ke sipoŋɔ ke ni di pii sipyii pii bɛɛri ɲɔ sha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A Yesu di pu yege na: «Buuri ɲuyɔ juu yi wa yee mu wɛ?» A pʼi wu ɲɔ shɔ na: «Buuri ɲuyɔ gbarashuun ni fyabigee kʼa.» ");
INSERT INTO myk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A wu sipyiire ti pye na pu tiin ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A wu xhɔ, na yee buuri ɲuyɔ gbarashuun we ni fyagaa ki lɔ, na baraga taha Kilɛ na, na yi kɛgi kɛgi na kan wu kalaapiire ti mu. A pee di yi kan sipyiire ti mu. ");
INSERT INTO myk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A pu bɛɛri di li na din. A kalaapiire tʼi sagaŋaa gbarashuun ɲi buuri ɲukoroyo yi saya na. ");
INSERT INTO myk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Piimu pʼa kee yalige ki li ge, pee bye namaa kabɔfoŋɔɔ shishɛɛrɛ (4.000), cèe ni nɔhɔpiire niŋɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A Yesu di sipyiire ti yaha kari. Lee kadugo na a wu jé kɔrɔgɔ ka ni na kari Magadan ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Caŋa ka Farizhɛɛn ni Sadushɛɛn pii ya pa fulo Yesu na kɔnhɔ pʼi wu taanna wii. A pʼi wu pye na wu ɲaha shɛshɛɛrɛ kakanhana la pye pee ɲii na lemu ya yìri fugba we ni ge. ");
INSERT INTO myk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A Yesu di pu pye: «Fugba we bu ɲaaŋa na foro caŋa dʼa to xɔ, yee na jo na: ‹Zanha da ba ɲiga na wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Fugba wu bu ɲaaŋa fo na wuu ɲimuguɲɔ na, yee na jo na: ‹Zanha ki da do niɲaa.› Fugba wu wo ɲɛɲaa le, yee ya lee keree cɛ na shɔɔnri kiyɛ ni. Ga yee di da já we tuun we wo ɲaha shɛshɛɛrɛ ti kɔri cɛ wɛ! ");
INSERT INTO myk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Niɲaa sipyii pii pʼa kolo, na nɔhɔ pye ɲɔmɛɛ baa fɛɛ ge, pee pʼa ɲaha shɛshɛɛrɛ kakanhana shaa, ga la shishiin da zhɛɛ pu na wɛ, fo Kilɛ tudunmɔɔ Zhonasi wuu le.» Lee kadugo tàan a Yesu di pu yaha wà, na gari. ");
INSERT INTO myk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tuun wemu ni Yesu kalaapiire ti bi gaaŋi gba wu kadugo yíri ge, a pu funŋɔ di wɔ pu ya ta buuri lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A Yesu di pu pye: «Yi fungɔnyɔ ta! Yʼa yiyɛ kasɛri Farizhɛɛn ni Sadushɛɛn wo buuri shizhɛnhɛrɛ ti na!» ");
INSERT INTO myk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A pʼi puyɛ pye na: «Wʼa ye yu, bani wèe ya ta buuri lɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yemu pu bi yu ge, a Yesu di yee cɛ na jo: «Yee nʼa daa wʼa kanha cɛ̀rɛ dɛ! Ɲaha na yee di yiyɛ pyi na buuri ɲɛ yee mu-i wɛ? ");
INSERT INTO myk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yee sanha sii ye ɲaha cɛ nimɛ bɛ-ɛ ya? Nɛ buuri ɲuyɔ kaguro wu kɛgi kɛgi sipyii kabɔfoŋɔɔ kaguro (5.000) wu na ge, buuri wemu wʼa kori ge, sagaŋaa juu wu dʼa ɲi wɛ? ");
INSERT INTO myk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nɛ buuri ɲuyɔ gbarashuun wu kɛgi kɛgi sipyii kabɔfoŋɔɔ shishɛɛrɛ (4.000) wu na ge, buuri wemu wʼa kori ge, sagaŋaa juu wu dʼa ɲi wɛ? ");
INSERT INTO myk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nɛ na yee pye: ‹Yʼa yiyɛ kasɛri Farizhɛɛn ni Sadushɛɛn wo buuri shizhɛnhɛrɛ te na.› A ɲaha di yee pye yee ya ta li cɛ nago kanna nɛ ta na buuri kaa yu yee mu-i wɛ? ");
INSERT INTO myk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ayiwa, a wu kalaapiire tʼi na li cɛ lee na, na wu bi ta pu pye na pʼa puyɛ kasɛri buuri shizhɛnhɛrɛ na wɛ, na ga pʼa puyɛ kasɛri Farizhɛɛn ni Sadushɛɛn wo kalaa wu na.» ");
INSERT INTO myk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A Yesu ni wu kalaapiire tʼi shɛ nɔ Sezare Filipe fiige ki ni. A wu wu kalaapiire ti pye: «Sipyii pu wa Sipya Ja wu pyi na jɔgɔ wu ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A pʼi wu ɲɔ shɔ na: «Pii wa yu na Yohana Batizelipye mu ɲɛ, pii di yu na Eli, pii bɛ di yu sanha na Zheremi, kelee Kilɛ tudunmɔ watii.» ");
INSERT INTO myk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A Yesu di pu yege na: «Ga yee do, yeeyɛ pyaa ki mu, nɛ di ɲɛ jɔgɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A Simɔ Pyɛɛri di wu pye: «Kirisa mu ɲɛ, wee wemu wu ɲɛ Saan, na nɔhɔ pye Izirayɛli wo Shɔvɔɔ wu ge, Kilɛ ɲìi wo wu wo Ja we.» ");
INSERT INTO myk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A Yesu di wu pye: «Zhonasi ja Simɔ, mu ɲɛ duba pya, bani wemu wʼa we can we shɛ mu na ge, weefɔɔ ɲɛ Adama pya wɛ. Ga nɛ To Kilɛ wemu wu ɲɛ fugba wu ni ge, wee wʼa wu shɛ mu na. ");
INSERT INTO myk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nʼa da li shɛ ma na jo Pyɛɛri ma ɲɛ, lee kɔri ɲɛ faaga. Nʼa da ba na Egilizi wu yereŋɛ kee faaga ki na. Adɛsi gburaya da já wu yereŋɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nʼa da ba fugba saanra ti kenikaangaa ki kan ma mu. Ma bu kaa lemu bɛɛri koro kan ɲiŋɛ ke na, lee koro na gan fugba we ni. Ma bu kaa lemu bɛɛri koro tɔ ɲiŋɛ ke na, lee koro na dɔ fugba wu ni.» ");
INSERT INTO myk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lee kadugo na a Yesu di yi jo waha wu kalaapiire ti mu na pu ganha bu yee jo wa shishiin bɛ mu na wee wu ɲɛ Kirisa wu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na co wee tuun wu na a Yesu di ɲɔ kɔn na yi fiinŋɛ na yu wu kalaapiire ti mu na: «Li waha lʼi waha, fo nɛ bu shɛ Zheruzalɛmu ni. Nɔhɔlɛɛ, ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ pu na ba nɛ kanha fo xuuni wà. Pu na ba nɛ gbo, ga nɛ na ba ɲɛ na foro xu ni na caxhugo caŋa taanri wogo ki na.» ");
INSERT INTO myk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A Pyɛɛri di gari ni wu ni kabanugo, na shɛ ɲɔ kɔn na yu ni wu ni na: «Ahayi Kafɔɔ, lee wa da ma ta wɛ! Kilɛ wu ma tanha lee na!» ");
INSERT INTO myk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ga, a Yesu di ŋmahana ɲɛri na Pyɛɛri pye: «Toro laha na tàan, mu Shitaanni we! Nɛ ɲuŋɔ mu wa zhaa da gyɛɛgi mɛ, bani mu fungɔngɔ ɲɛ Kilɛ keree na wɛ, fo sipyii wogoo.» ");
INSERT INTO myk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lee kadugo tàan a Yesu di wu kalaapiire ti pye: «Wa funŋɔ bi ɲɛ wu binnɛ ni na ni, wu she wuyɛ ni, wu wu korikoritige ki lɔ taha na fɛni. ");
INSERT INTO myk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bani sipya we wʼa giin wu wuyɛ pile munaa ɲuŋɔ wolo niɲaa ge, wee na ba buun wu munaa ni ɲiga na. Ga we wʼa bɔnri wu munaa ni niɲaa nɛ wuu na ge, wee wu da ba guri wuu munaa li ta ɲiga na. ");
INSERT INTO myk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Li na ba ɲaha ɲɔ sipya na wu koŋɔ yaŋmuyɔ bɛɛri ta, wu ba buun wuyɛ pile munaa ni wɛ? Yaaga kekɛ sipya di da ba já daga wu munaa ɲuŋɔ wolo wɛ? ");
INSERT INTO myk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ayiwa, Sipya Ja wu kuuni na ba ba ni wu mɛlɛkɛɛ pu ni, wu To wu nɔɔrɔ wu ni. Lee ba bye tuun wemu ni, wu na ba sipyii pu bɛɛri nigin nigin saraa na bɛ ni pu kapyegee ni. ");
INSERT INTO myk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Can na nʼa da yi jo yi mu, sipyii pii pu wa naha ge, pii wa da xhuu pu ni bada na ta pu ya Sipya Ja wu ɲa tapaga ni ba saan ɲɛ-ɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lee kadugo na ba cabyaa gbaara ya toro wɛ, a Yesu di gari ni Pyɛɛri, ni Yakuba, ni wu ceborona Yohana ni faabobotɔɔngɔ ka fugba ni. ");
INSERT INTO myk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A Yesu ɲɛwiinɛ lʼi shɛ ɲɛri pu ɲii na. A wu ɲaha kʼi ganha na ɲí ba caŋa ɲɛ wɛ, a wu fàya yi bɛ di fiinŋɛ ba kpɛɛngɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taapile ni a pʼi Musa ni Eli ɲa pee na yu ni Yesu ni. ");
INSERT INTO myk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lee na a Pyɛɛri di Yesu pye: «Kafɔɔ wèe bu gori naha, lee ya ɲɔ xuuni dɛ. Ma bu sɔɔ, nɛ na buguloo taanri yereŋɛ. Mu wo nigin, Musa wo nigin ni Eli wo nigin.» ");
INSERT INTO myk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na wu yaha pee jomɔ pu na, a ɲahaŋa ka di ɲí ɲí na pa, na ba pu tɔ. A mujuu la di foro kee ɲahaŋa ki ni na: «Nɛ ɲidaan Ja wu ɲɛ we. Wu kaa lʼa dan nɛ ni fo xuuni. Yʼa wu nijoyo nuri!» ");
INSERT INTO myk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ba kalaapiire tʼa pee jomɔ pu logo wɛ, a pʼi sii fya fo xuuni, fo pʼa buri buri, na pu ɲahaya ye buri ɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A Yesu di fulo na gbɔn gbɔn pu na, na jo: «Yi ganha bu fya wɛ! Yi yìri!» ");
INSERT INTO myk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A pʼi pu ɲahaya yi yirige, ga pu ya sipya watii ɲa nige wɛ, fo Yesu yɛ. ");
INSERT INTO myk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba pʼa diri faaboboŋɔ ki na wɛ, a Yesu di yi jo waha pu mu na: «Kaa lemu yʼa ɲa ge, yi ganha bu lee ɲaha jo sipya wa shishiin bɛ mu wɛ, fo Sipya Ja wu ba ɲɛ na foro xu ni tuun wemu ni.» ");
INSERT INTO myk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lee kadugo tàan a kalaapiire tʼi wu yege na: «Wee tuun wu ni ɲaha na saliya karamɔgɔlɔɔ pʼi yu na Eli wʼa yaa na fɛnhɛ pa wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A wu pu pye: «Uun, Eli wʼa yaa na pa, na ba keree ki bɛɛri gbegelevonɔ gbegele. ");
INSERT INTO myk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ga nʼa da yi jo yi mu, Eli ya pa xɔ, ga sipyii pʼi ya ta wu cɛ wɛ, na wu pye pu ɲidaan pyegana na. Lee kanhagana le ninunɔ na pʼa da ba Sipya Ja wu bɛ kanha.» ");
INSERT INTO myk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wee tuun wu ni a kalaapiire tʼi na li cɛ na Yohana Batizelipye kaa wu bi byi. ");
INSERT INTO myk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ba pʼa pa jé sipyiire ti ni wɛ, a ná wa di fulo Yesu na, na nuguro sin wu fɛɛ ni, ");
INSERT INTO myk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na jo: «Kafɔɔ, ɲuŋɔ ɲaari na ja wu na, bani ɲuzhanga ki wa wu na. Wʼa kanha fo xuuni. Tɛɛgɛɛ kii ni ɲuŋɔ ki ma wu shan na ni, kelee lɔhɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɛ pa ni wu ni ma kalaapiire ti mu, ga pʼi ya já wu cuuŋɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A Yesu di jo: «Ee! Yee kunni ɲɛ sipyikuuyo nʼa daa baa fɛɛ! Nɛ na gori yaha naha ni yee ni fo tuun wekɛ wɛ? Nɛ na yee keree xu fo tuun wekɛ wɛ? Pa ni ma pya wu ni naha!» ");
INSERT INTO myk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A Yesu di din jina wu na, a wʼi foro pya wu ni. A pya wu juuŋɔ lee taapile li ni. ");
INSERT INTO myk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A kalaapiire tʼi ba fulo Yesu na pu yɛ na, na wu yege na: «Ɲaha na wèe di ya já we jina we kɔri yeege pya wu ni-i wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A Yesu di pu pye: «Bani yee nʼa daa wʼa cɛ̀rɛ toro. Can na nʼa da yi jo yi mu, yee nʼa daa wu da bi ali mutaridi pilere bɛ xɔ pɛɛrɛ ni, yee bi da yi jo ke faaboboŋɔ ke mu na ki yìri naha, kʼi shɛ mɛ, kʼa gari. Kaa la shishiin bi da ga yee já wɛ.  ");
INSERT INTO myk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ga ke jina tuugo ke foromɔ ya taan wɛ, fo suun ni Kilɛ-ɲɛrɛgɛ.» ");
INSERT INTO myk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Caŋa ka, na Yesu ni wu kalaapiire ti yaha shiizhan Galile ni, a wu pu pye: «Pu na ba Sipya Ja wu le sipyii keye ni. ");
INSERT INTO myk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pu na ba wu gbo, ga wu caxhugo caŋa taanri wogo, wu na ba ɲɛ sanha.» A kalaapiire ti ɲahaya di danha fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ayiwa, ba Yesu ni wu kalaapiire tʼa nɔ Kapɛrinɔmɔ kulo li ni wɛ, a Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo wari wu shɔvɛɛ pʼi fulo Pyɛɛri na, na wu pye: «Yee wo karamɔgɔ wu ya gaan Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo wari wu ni-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A Pyɛɛri di jo: «Uun, wʼa gaan wu ni.» Ba Pyɛɛri ya jé puga ki ni wɛ, a Yesu di fɛnhɛ jomɔ pu lɔ, na jo: «Pyɛɛri, mu funŋɔ na jɔgɔ wu dʼa yaa na munaa pɛrɛmɛ, kelee katahaŋaa ki wo wari wu kaan ke koŋɔ ke wo saannaa pu mu wɛ? Saannaa pu wo nagoo laa piitiilee?» ");
INSERT INTO myk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A Pyɛɛri di wu pye: «piitiilee». A Yesu di jo: «Lee funŋɔ ni, ma cɛ kantiinlɛɛ niŋɛ wa lee ni-i sa! ");
INSERT INTO myk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ga lee bɛ na, kɔnhɔ wù ganha bu kawaa pye pii sipyii pii na wɛ, shɛ ŋmɛhɛnɛ la wá gba wu ni. Fyashiimɛ wemu wʼa da ma ŋmɛhɛnɛ li lɔ ge, mʼa wee ɲɔ mugi. Ma na wari tuuŋɔ ka ta wà, mʼa shɛ kee kan nɛ ni mu wo munahaa ki pɛrɛmɛ.» ");
INSERT INTO myk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A kalaapiire tʼi fulo Yesu na, na wu yege na: «Wekɛ wu ɲɛ pu bɛɛri wo ɲahagbaa fɔɔ fugba saanra ti ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A Yesu di nɔhɔcɛɛrɛ la yiri, na lee yereŋɛ pu niŋɛ ni, ");
INSERT INTO myk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na jo: «Can na nʼa da yi jo yi mu, yee bu bye yee di ya ɲɛri ba nɔhɔpiire ɲɛ-ɛ wɛ, yee da ga ba jé fugba saanra ti ni bada wɛ. ");
INSERT INTO myk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sipya wemu wʼa wuyɛ tirige na pye ba le nɔhɔcɛɛrɛ le ɲɛ-ɛ ge, weefɔɔ wu ɲɛ pusamaa bɛɛri wo ɲahagbaa fɔɔ fugba saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sipyaa sipya wʼa le nɔhɔcɛɛrɛ le la shi co xuuni nɛ wuu na ge, nɛ wʼa co xuuni. ");
INSERT INTO myk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Te nɔhɔpiire te tʼa dà nɛ na ge, sipyaa sipya wʼa le la ɲuŋɔ kyɛɛgi ge, li bi da bɔrɔ weefɔɔ mu na faatabaaga pɔ wu katige ni, na wu wá suumɔ lɔhɔ nɔhɔdaan. ");
INSERT INTO myk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bɔɔngɔ ki wa koŋɔ wogo sipyii pu wo ɲugyɛɛgɛrɛ ti wuu na. Ɲugyɛɛgɛrɛ kunni da ga já bye pyebaa wɛ. Ga bɔɔngɔ ki wa ti pyevɛɛ pu wogo. ");
INSERT INTO myk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ma keŋɛ kelee ma tɔɔgɔ bi ɲɛ kaɲuŋɔ di ma le jurumu ni, ki kɔn mʼa ki wá. Ma keŋɛ nigin wo, kelee ma tɔɔgɔ nigin wo na jé Alijinɛ ni, lee ya pɔrɔ ma mu ma keye shuun wo ni ma tɔɔyɔ shuun wo wu wá nafugibaaga ni. ");
INSERT INTO myk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma ɲii bi ɲɛ kaɲuŋɔ di ma le jurumu ni, li wɛhɛlɛ wolo, mʼa li wá. Ma ɲii nigin wo na jé Alijinɛ ni, lee ya pɔrɔ ma mu ma ɲìi shuun wo wu wá Jahanɛmɛ na ki ni. ");
INSERT INTO myk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Yʼa yiyɛ kasɛri dɛ! Yi ganha bu da le nɔhɔcɛɛrɛ le la shishiin cɛrɛŋɛ wɛ. Nʼa da yi jo yi mu jo pu mɛlɛkɛɛ pu niyereye yi wa tuun bɛɛri ni nɛ To wu ɲahagbaa na fugba we ni.  ");
INSERT INTO myk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bani piimu pʼa piin ge, Sipya Ja wʼa pa wu ba pee shɔ. ");
INSERT INTO myk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Dii yee di wa li wii wɛ? Dubyaa xhuu nigin (100) bu bye sipya wa mu, a wee wa nigin di ba biin. Ta wu da kɛlɛɛ gbarashɛɛrɛ ni gbarashɛɛrɛ (99) wu samaa yaha wà faaboboŋɔ ki na, na shɛ we wu nigin wu sha wɛ? ");
INSERT INTO myk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nʼa da yi jo yi mu jo wu bu shɛ wu ɲa, wu da funŋɔ taan fo xuuni wu ɲa wu wuu na na toro pusamaa kɛlɛɛ gbarashɛɛrɛ ni gbarashɛɛrɛ (99) wu tàan, pee piimu pu ɲɛ pu ya piin wɛ ge. ");
INSERT INTO myk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mu li wa. Yee fugba To wu bɛ ɲidaan ɲɛ le nɔhɔcɛɛrɛ le la li piin wɛ. ");
INSERT INTO myk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ma ceboro bu kakuunɔ pye ma na. Shɛ wu fɛni, mʼa shɛ yi jo wu mu yiyɛ shuun xuu ni. Wu bu yere li na ma mu, yi na bye sanha yiyɛ sipyii. ");
INSERT INTO myk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ga wu bu shɛ bye wu ya yi logo ma mu wɛ. Mʼa shɛn nigin kelee shɛɛn shuun wa fara yiyɛ na, kɔnhɔ jomɔ pu bɛɛri di shɛ bye sɛɛrɛɛ shuun kelee sɛɛrɛɛ taanri ɲii na. ");
INSERT INTO myk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wu bu shɛ li she wu da pee bɛ woyo yi logo wɛ, mʼa shɛ yi ɲaha jo egilizi wu mu. Wu bu li she wu da egilizi wu bɛ woyo yi logo wɛ, mʼa wu jate ba Kilɛ-cɛbaama ɲɛ wɛ, kelee ba fanhafɛɛ wari shɔvɔɔ wa ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Can na nʼa da yi jo yi mu jo yi bu kaa lemu bɛɛri she ɲiŋɛ ke na, Kilɛ bɛ na ba lee she fugba wu ni. Yi bu sɔɔ kaa lemu bɛɛri na ɲiŋɛ ke na, Kilɛ bɛ na ba sɔɔ lee na fugba wu ni. ");
INSERT INTO myk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nʼa da yi jo yi mu sanha jo yee shuun wa bu bɛ kaa bɛɛri na naha ɲiŋɛ ke na, na lee ɲɛɛri nɛ fugba To wu mu, wu na lee kan pu mu. ");
INSERT INTO myk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bani shɛɛn shuun taanri bu shɛ puyɛ pinnɛ ta xuu bɛɛri ni nɛ mɛgɛ na, nɛ wa pu niŋɛ ni.» ");
INSERT INTO myk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wee tuun wu ni a Pyɛɛri di fulo Yesu na, na wu pye: «Wù Kafɔɔ, nɛ ceborona ba kakuuŋɔɔ pyi nɛ na tuun bɛɛri ni, nɛ yaa na yafani wu mu fo na shɛ nɔ tɔɔɲii juu na wɛ? Fo tɔɔɲii gbarashuun gɛ?» ");
INSERT INTO myk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A Yesu di wu pye: «Nʼa da ma pye fo tɔɔɲii gbarashuun wɛ dɛ, ga fo tɔɔɲii gbarashuun yahaŋaa kɛlɛɛ gbarashuun (70). ");
INSERT INTO myk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lee wuu na, fugba saanra tʼa foro kaa lemu fɛni ge, lee li wa mɛ. Saan wa wʼa bi giin wu wu wari keree ɲaha wolo ni wu kapyebyii pu ni. ");
INSERT INTO myk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba wʼa li ɲɔ kɔn wɛ, a pʼi ba ni kapyebye wa ni wu mu. Saan wu wari miliyoo niɲɛhɛmɛɛ foo li bye wee na. ");
INSERT INTO myk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Se bye wu ni wu lee foo le tɔ wɛ. A saan wu jo na pu pu pɛrɛ taga foo li tɔ, wu ni wu shɔ, ni pu nagoo, ni pu keŋɛ yaŋmuyɔ yi bɛɛri. ");
INSERT INTO myk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A wee kapyebye wu shɛ nuguro sin wu kafɔɔ wu fɛɛ ni, na wu ɲɛɛri na: ‹Ma luu li gbo na tàan, nʼa da ba ma wari wu bɛɛri foo tɔ ma mu.› ");
INSERT INTO myk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A wu ɲiɲaara di jé wu kafɔɔ wu ni, a wu wu yaha, na yafa wu mu bɛ sanha foo li bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ba wee kapyebye wʼa foro wà wɛ, a wu ni wu kapyebyeɲii wa di jíri. Wu wari dɛɲɛɛ xhuu nigin foo di bi bye wee kapyebyeɲii we na. A wu wee co, na wu katige ŋmɔhɔri, na jo: ‹Na foo li tɔ!› ");
INSERT INTO myk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A wu kapyebyeɲii wu nuguro sin wu fɛɛ ni, na wu kemɛ ɲɛɛri na: ‹Ma luu li gbo na tàan, nʼa da ba ma wari wu bɛɛri foo tɔ ma mu.› ");
INSERT INTO myk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ga wu ya sɔɔ wɛ, na wu le kaso ni fo wu ga ba wee wo foo li tɔ. ");
INSERT INTO myk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ba kapyebyii pusamaa ya lee ɲa wɛ, a lee di waha pu na fo xuuni. A pʼi shɛ yi bɛɛri ɲaha jo pu kafɔɔ wu mu. ");
INSERT INTO myk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wee tuun wu ni, a kafɔɔ wu wee kapyebye wu yiri na wu pye: ‹Kapyebye niguumɔ mu ɲɛ! Nɛ mu wo foo li bɛɛri yaha mu na, bani mu ya nɛ ɲɛɛri saama na. ");
INSERT INTO myk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ta mu bɛ bi yaa na ɲuŋɔ ɲaari ma kapyebyeɲii wu na ba nɛ li pye mu na-ɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A Kafɔɔ wu luu di yìri fo xuuni. A wu wu le kaso ni kɔnhɔ wu da ɲaani wà, fo wu ba shɛ foo li saraa na xɔ tuun wemu ni. ");
INSERT INTO myk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mu li wa yee bɛ mu, yee bu bye yee di ya yafani yi cebooloo pu mu yi zɔlɔɔ pu bɛɛri na wɛ, lee pyegana le na nɛ wo fugba To wu bɛ wa da ba yee pye.» ");
INSERT INTO myk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ayiwa, ba Yesu ya wee kalaa wu kan xɔ sipyiire ti mu wɛ, a wu foro Galile fiige ki ni, na gari Zhude fiige ki ni, Zhurudɛn Gba wu kadugo yíri. ");
INSERT INTO myk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A sipyiɲɛhɛmɛɛ di daha wu fɛni wà. A wu pu yama fɛɛ pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A Farizhɛɛn pii di fulo wu na, kɔnhɔ pʼi wu pɛri wii. A pʼi wu pye: «Lʼa saha ná wu wu shɔ gbaga xɔ kaɲuŋɔ bɛɛri na ya?» ");
INSERT INTO myk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A Yesu di pu pye: «Ta yee ya li kalaa Kilɛ Kafila wu ni wɛ? Na: ‹Fo koŋɔ ki ɲɔkɔɔnrɔ na, koŋɔ ki yaavɔɔ wʼa pu yàa ná ni cee.› ");
INSERT INTO myk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na jo: ‹Lee wuu na ná na ba wu to ni wu nu yaha, na nɔrɔ wu shɔ na. Pu shuun wu na bye ceepuuro nigin.› ");
INSERT INTO myk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lee funŋɔ ni, pu ɲɛ nige shuun wɛ, ga fo nigin. Ayiwa Kilɛ ya lemu pye nigin ge, sipya ganha bu lee waagi wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ga Farizhɛɛn pʼi wu pye: «Wee tuun wu ni ɲaha na Musa dʼa jo na ná ba da wu shɔ yaha, na wu fɛnhɛ gbaxɔɔrɔ sɛmɛ yàa kan wu mu wu na wu yaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A Yesu di pu pye: «Yee niwegee kʼa waha, lee wuu na Musa ya gbaxɔɔrɔ ti koro kan yee mu. Ga fo taashiinɛ li ni, li bi byi mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nɛ kunni wʼa da yi jo yi mu jo sipyaa sipya wʼa wu shɔ gbaga xɔ ge, cee wu bu da wu ya dɔdɔɔrɔ pye, a lee di gbaga ki xɔ wɛ, ná wu bu wu yaha, na watii leŋɛ, dɔdɔɔrɔ wʼa pye.» ");
INSERT INTO myk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A wu kalaapiire tʼi wu pye: «Ke bi ɲɛ ná wo tayerege wu ni wu shɔ tɛ ni, wee tuun wu ni na mɛhɛ pye wà cee baa, lee ya pɔrɔ.» ");
INSERT INTO myk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A Yesu di pu pye: «Wee kalaa we se ɲɛ sipyii bɛɛri ni wɛ, fo piimu yɛ mu Kilɛ ya wu se kan ge. ");
INSERT INTO myk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaɲuyɔ ya ɲɛ wà yemu ya ná ɲaha kɔɔn wu da cee leŋɛ-ɛ ge. Pii ya seni pu ɲɛ namaa ni wɛ. Sipyii di pii wo namaa ni. Pii bɛ di wa li shaa pʼi bye mu fugba saanra ti kaa na. Wemu na já bye cee leŋɛ baa ge, wu pye cee leŋɛ baa.» ");
INSERT INTO myk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lee kadugo na a sipyii pii di ba ba Yesu mu ni nɔhɔpiire ta ni, kɔnhɔ wu wu keye taha ti na wu Kilɛ ɲɛɛri ti mu. Ga, a wu kalaapiire tʼi yogo jo ni pee sipyii pu ni. ");
INSERT INTO myk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A Yesu di pu pye: «Yi nɔhɔpiire ti yaha ti da ma na mu, yi ganha ba ti ɲaha kɔɔn wɛ! Bani pee shi tuugo wuuro ti ɲɛ fugba saanra te.» ");
INSERT INTO myk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A wu wu keye taha tee nɔhɔpiire ti na. Ba wʼa xɔ wɛ, na yìri wà na kari. ");
INSERT INTO myk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ayiwa, pu nigariwuu, a ná wa di fulo Yesu na, na wu yege na: «Karamɔgɔ, kasaana lekɛ tuugo nɛ dʼa yaa na pye kɔnhɔ di ba ɲìi sicuumɔ nixhɔbaama ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A Yesu di wu pye: «Ɲaha na mʼa na yegee kasaana fiin wɛ? Nigin yɛ pe wʼa ɲɔ. Ma funŋɔ bi ɲɛ mʼa ɲìi sicuumɔ ta, ta saliya wu ɲɔmɛhɛɛ ki koo ɲaari.» ");
INSERT INTO myk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A ná wu jo: «Kiikɛ wɛ?» A Yesu di wu pye: «Ma ganha bu sipya gbo wɛ! Ma ganha bu dɔdɔɔrɔ pye wɛ! Ma ganha bu nagaara pye wɛ! Ma ganha bu kafinɛyɛ taha ma sipyiɲii na wɛ! ");
INSERT INTO myk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma da ma nu ni ma to pɛlɛ! Ma sipyiɲii wu taan ma mu ba mayɛ pyaa ki ɲɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A wee lɛvɔɔ wu jo: «Nɛ kii bɛɛri koro ɲaari. Lekɛ dʼa fɔ sanha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A Yesu di wu pye: «Ma funŋɔ bi ɲɛ mʼa fa, shɛ ma keŋɛ yaŋmuyɔ yi pɛrɛ, mʼa wee wari wu kan la baa fɛɛ mu. Wee tuun wu ni ma na naafuu ta fugba we ni. Lee kadugo tàan mʼa ba daha na fɛni.» ");
INSERT INTO myk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ga ba lɛvɔɔ wʼa yee logo wɛ, na ɲaha tanha na gaaŋi, bani naafuugbɔ wu bye wu mu. ");
INSERT INTO myk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A Yesu di wu kalaapiire ti pye: «Can na nʼa da yi jo yi mu jo naafuugbɔ fɔɔ jemɛ pʼa pɛn fugba saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nʼa da ye bɛ jo yi mu sanha jo ɲɔhɔŋɔ jemɛ ya taan museni wii ni na toro naafuugbɔ fɔɔ jé na Kilɛ wo saanra ti ni.» ");
INSERT INTO myk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kalaapiire tʼa pee jomɔ pu logo ge, a lee di bye pu mu kakanhana fo pu na yu: «Aa! Wee tuun wu ni sipya wekɛ na já pa shɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Yesu di pu wii, na jo: «Sipyii mu, lee da já bye wɛ, ga kaa la shishiin ya Kilɛ jani wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wee tuun wu ni a Pyɛɛri di jomɔ pu lɔ, na jo: «Li wii, wèe ya kahari yaŋmuyɔ bɛɛri ni, na daha mu fɛni. Lekɛ di da ba bye wèe shizhaa na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A Yesu di pu pye: «Can na nʼa da yi jo yi mu jo Sipya Ja wu ba ba diin wu saanra koro nɔɔrɔ wuu li ni, koŋɔ nivoŋɔ ki ni tuun wemu ni, yee bɛ na ba diin saanra korogoo kɛ ni shuun ni, na kiiri kɔn Izirayɛli gbaweye kɛ ni shuun wu na. ");
INSERT INTO myk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sipya wemu bɛɛri wʼa kahari wu puga ni ge, kelee wu ceboronamaa, kelee wu ceboroshaa, kelee wu nu, kelee wu to, kelee wu nagoo, kelee wu kɛrɛyɛ, nɛ wuu na ge, weefɔɔ na ba yee yahaŋaa xhuu nigin (100) ta, na wu taa ta ɲìi sicuumɔ nixhɔbaama pu bɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ga ɲahagbaa wuu niɲɛhɛmɛɛ na ba bye kadugo yíri wuu, kadugo yíri wuu niɲɛhɛmɛɛ na bye ɲahagbaa wuu.» ");
INSERT INTO myk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ayiwa, a Yesu di jo na: «Fugba saanra tʼa foro kaa lemu fɛni ge, lee li wa mɛ. Kɛrɛyɛ fɔɔ wa ya sɔɔ foro ɲisɔɔgɔ ka tàan di zhɛ kapyebyii pii sha di zhɛ yaha wu ɛrɛzɛn tɛgɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Piimu wʼa shɛ da ge, a wu ni pee di jo bɛ wari dɛɲɛ nigin na, wa bɛɛri wo caŋa ɲii saraa. A wu pu yaha kari labye wu fɛni tiire tɛgɛ ki ni. ");
INSERT INTO myk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A caŋa kʼi ba dugi jɛri, a wu foro sanha, na saha ni sipyii pii niyereye ni kpɛɛngɛ ki na, pʼi bi la pyi wɛ. ");
INSERT INTO myk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A wu pu pye: ‹Yi bɛ pu shɛ caŋa ɲii li pye na ɛrɛzɛn tɛgɛ ki ni, saraa wemu wʼa yaa ni yi ni ge, nɛ na ba wee kan yi mu.› ");
INSERT INTO myk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A pee di gari tiire tɛgɛ ki ni. A caŋa kʼi ba nɔ ɲiŋɛ niŋɛ ni, a tɛgɛ ki fɔɔ wu foro sanha, na saha ni pii bɛ ni, na pee bɛ lɔ lee lɔgana li na. Na ba foro sanha yakoŋɔ caŋa ki bɛ ni, na saha ni pii bɛ ni, na pee bɛ lɔ lee lɔgana li na. ");
INSERT INTO myk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A wu ba guri foro sanha yakoŋɔ ki bɛ ni, na pii bɛ niyereye ta kpɛɛngɛ ki na, pu bɛ di ɲɛ la ni wɛ. A wu pu pye: ‹Ɲaha na yee dʼa caŋa ɲii li bɛɛri pye lapye baa wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","A pee di wu pye: ‹Sipya wa shishiin ya ta wèe sha wu wo labye na niɲaa wɛ.› A wu pu pye: ‹Yi bɛ pu shɛ na kɛrɛyɛ yi ni.› ");
INSERT INTO myk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Ba caŋa kʼa pa xhɔ baari wu tigiduun na nɔ wɛ, a tɛgɛ ki kafɔɔ wʼi wu kaɲahashɔɔnrimɔ wu pye: ‹Kapyebyii pu yiri, mʼa pu saraa na li ɲɔ kɔn kurogo wuu pu na, na se ɲaha wuu pu mu.› ");
INSERT INTO myk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Piimu pʼa pu wo labye wu ɲɔ kɔn yakoŋɔ ki ni ge, a pee di fɛnhɛ fulo, a pu bɛɛri di wari dɛɲɛɛ nigin nigin ta. ");
INSERT INTO myk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ba lʼa pa nɔ nizhiilee pu na wɛ, a pee di ganha na giin na pee wo wu na ɲɛhɛ wari dɛɲɛɛ nigin nigin na. Ga, a pʼi wari dɛɲɛɛ nigin nigin kan pu bɛ mu. ");
INSERT INTO myk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba wee wari wʼa kan pee mu wɛ, a pʼi ganha na tɛgɛ ki fɔɔ wu yɔgɔ puyɛ tàan, na yu: ");
INSERT INTO myk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Pii pʼa nɔ kurogo ki na ge, lɛɛri nigin yɛ wo labye pee ya pye. A mu di dɛrɛ wèe wo saraa wu pye nigin ni pee wo wu ni, wèe piimu pʼa caŋa ɲii li bɛɛri pye, na li kanhama soro, na ke cawaga ke bɛɛri lɔ ge.› ");
INSERT INTO myk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ga, a tɛgɛ ki kafɔɔ wu shɛn nigin wa pye pu ni: ‹Naɲii, nɛ ta to mu na wɛ! Ta wari dɛɲɛ nigin na bɛ nɛ ni mu ya bɛ mu wo caŋa ɲii li saraa wɛ? ");
INSERT INTO myk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ayiwa, ma wo saraa wu lɔ, ma da gaaŋi. Nɛ mu lʼa taan nago kanna nɛ wu saraa ninumɔ kan mu ni we mu, wee wemu wʼa pa tɛgɛ ki ni kurogo ge. ");
INSERT INTO myk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lemu bu nɛ taan, ta lee bɛ nɛ yaa na pye ni na wo wari wu ni wɛ? Kelee ta nɛ wo saama pu ɲɛpɛɛn yɛrɛ lʼa jé ma ni?›» ");
INSERT INTO myk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","A Yesu di jo sanha: «Piimu pu ɲɛ kadugo yíri wuu pu ge, le pyegana le na pee da ba bye ɲahagbaa wuu. Piimu pu ɲɛ ɲahagbaa wuu pu ge, pee na bye kadugo yíri wuu.» ");
INSERT INTO myk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ayiwa, Yesu ya pa yìri na gaaŋi Zheruzalɛmu ni. Pu nigariwuu, a wʼi wu kalaapiire kɛ ni shuun wu yɛ yiri, na pu pye: ");
INSERT INTO myk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Wù wii gaaŋi Zheruzalɛmu ni. Pu na zhɛ Sipya Ja wu le wà saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu keŋɛ ni. Pu na ba wu jaagi na wʼa yaa ni xu ni. ");
INSERT INTO myk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pʼa wu le shi watii keŋɛ ni, pee na zhɛhɛ wu na. Pu na ba wu kpɔn ni susɔlɔɔ ni, na wu kori tige na. Caŋa taanri wogo ki na wʼa ɲɛ na foro xu ni.» ");
INSERT INTO myk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ayiwa, a Zebede shɔ wu fulo Yesu na ni wu nagoo shuun wu ni. A wu nuguro sin Yesu fɛɛ ni, na wu ɲɛɛri, na wu ɲɔ wee na. ");
INSERT INTO myk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A Yesu di wu yege na: «Ɲaha kaa lʼi wa ma na wɛ?» A wu Yesu pye: «Ma ba ba diin ma saanra ti ni tuun wemu ni, ma di sɔɔ na mu, na nagoo shuun we di diin ma tàan. Nigin wa di diin ma kanige cɛ, wa di diin ma kamɛnɛ cɛ.» ");
INSERT INTO myk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A Yesu di wu pye: «Kaa lemu yee wa ɲɛɛri ge, yee wa li cɛ wɛ. Kanhama cɛɛgbuu lemu ni nʼa da ba gba ge, yee na já gba lee ni ya?» A pʼi jo: «Uun, wèe na já gba li ni.» ");
INSERT INTO myk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A Yesu di pu pye: «Uun, yi kunni na ba gba nɛ wo cɛɛgbuu li ni. Ga na tiin nɛ kanige cɛ, kelee nɛ kamɛnɛ cɛ, nɛ ɲɛ yee tatiinyɛ yi kanvɔɔ wɛ. Piimu kaa na nɛ To wʼa yee gbegele ge, pee mu yi da ba gan.» ");
INSERT INTO myk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ba kalaapiire kɛ wu samaa ya yee logo wɛ, a pu logoo di yìri pu ceboronamaa shuun wu tàan. ");
INSERT INTO myk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A Yesu di pu bɛɛri yiri, na jo: «Yee ya li cɛ na shi wemu ɲɛ Yawutuu wɛ, wee shi wu wo ɲuŋɔfɛɛ pʼa pu ɲuŋɔfɛɛrɛ pyi wu na. Pu sipyigbɔɔ pʼi pu fanha shɛɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ga li da ba bye mu yee tɛ ni wɛ. Yee wa funŋɔ bi ɲɛ wu bye sipyigbɔ, wufɔɔ wu pye pusamaa wo kapyebye. ");
INSERT INTO myk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yee wa funŋɔ bi ɲɛ wu bye ɲahagbaa fɔɔ, weefɔɔ wu pye pusamaa wo bulo. ");
INSERT INTO myk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mu li wa, Sipya Ja wu bɛ ya ta pa kɔnhɔ sipyii di ba kapyeŋɛɛ pyi wu mu wɛ. Ga wʼa pa, wu ba kapyeŋɛɛ pyi sipyii mu, wu ba wu munaa kan lʼi bye sipyiɲɛhɛmɛɛ wo ɲuwuuro saraa.» ");
INSERT INTO myk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ba pʼa pa foro Zheriko kulo li ni wɛ, a sipyiɲɛhɛmɛɛ di daha Yesu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lee bi fyɛnmɛɛ shuun wa nidɛɛngɛ ta koo li ɲɔ na. Ba pee ya logo na Yesu wʼa doroo wɛ, a pʼi xhuulo na: «Wù Kafɔɔ, Dawuda Ja we, ɲuŋɔ ɲaari wù na!» ");
INSERT INTO myk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sipyiire ti bi yogo yu ni pu ni na pu cari puyɛ na, ga, a pʼi la fara xhuulo wu na, na yu: «Wù Kafɔɔ, Dawuda Ja we, ɲuŋɔ ɲaari wù na!» ");
INSERT INTO myk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A Yesu di yere, na pu yiri, na pu pye: «Yi wa giin nɛ di lekɛ pye yi mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A pʼi jo: «Wù Kafɔɔ, wù pye wù da ɲaa.» ");
INSERT INTO myk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A pu ɲiɲaara di jé Yesu ni, a wu gbɔn pu ɲìi ki na. A pʼi ɲɔ kɔn na ɲaa lee taapile li ni. A pʼi daha Yesu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ba pʼa tɛɛŋɛ Zheruzalɛmu na wɛ, a pʼi nɔ Bɛtɛfajɛ shizhaa, Oliviye faaboboŋɔ ki kabanugo ki ni. A Yesu di wu kalaapiire shuun wa tun, ");
INSERT INTO myk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na pu pye: «Yi shɛ yi ɲahagbaa kulo li ni. Yi bu nɔ yɛ, yi na kafazhɔ wa nibɔgɔ ta wà, wu ni wu pya. Yi yee sanha pa na kan naha! ");
INSERT INTO myk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sipya wa bu jo ni yi ni, yʼi weefɔɔ pye na Kafɔɔ mago wu wa yi na. Lee bu bye pu na yi ɲɔ yaha yi mu, yʼi ba ni yi ni.» ");
INSERT INTO myk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lee ya pye kɔnhɔ Kilɛ tudunmɔ wʼa jomɔ pemu jo ge, pee ɲɔ di fa na: ");
INSERT INTO myk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Yi yi jo Siyɔn poro wu mu na: ‹Li wii, ma saan wʼa ma ma mu. Wʼa wuyɛ tirige, na dugi tiin kafabige na, kafazhɔ wa wo pya.›» ");
INSERT INTO myk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A kalaapiire tʼi gari, na shɛ li pye ba Yesu ya yi jo pu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A pʼi ba ni kafazhɔ wu ni wu pya wu ni, na ba pu fadegbɔyɔ ya taha yee na, a Yesu di dugi tiin wà. ");
INSERT INTO myk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A sipyiɲɛhɛmɛɛ di pu fadegbɔyɔ pii koo li ni. A pii bɛ di wɛburiye kɔn, na yee pii koo li ni. ");
INSERT INTO myk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ba pʼa gaaŋi wɛ, piimu pu ɲɛ Yesu ɲahagbaa na, ni piimu pu ɲɛ wu kadugo ge, pee bi xhuulo na yu: «Masɔŋɔ kʼa byi Dawuda Ja wu mu! Wemu wʼa ma mɛ Kafɔɔ mɛgɛ na ge, wee ɲɛ duba pya! Masɔŋɔ kʼa byi Kilɛ mu fugba lii lii we ni!» ");
INSERT INTO myk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ba Yesu ya jé Zheruzalɛmu ni wɛ, a tunmɔ pʼi kulo li bɛɛri círi. A pʼi ganha na yegee na: «We ná we di ɲɛ jɔgɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A sipyiire tʼi jo: «Kilɛ tudunmɔɔ Yesu wu ɲɛ wii, Galile Nazarɛti shɛn we.» ");
INSERT INTO myk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A Yesu di jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Sipyii piimu pu bi bɛrɛ ni zhɔ pyi wà ge, a wu pee bɛɛri kɔri yeege. A wu wari faavɛɛ pu wo tabalaa pee, ni gbegbe shazhɛɛrɛ pɛrɛvɛɛ pu wo yatiinyɛ yi ɲɛri buri, ");
INSERT INTO myk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","na pu pye: «Lʼa ka Kilɛ Kafila wu ni na: ‹Pu na ba nɛ puga ki pyi Kilɛ-ɲɛrɛgɛ puga.› Ga yee kunni ya ki pye nagaalaa talaraga.» ");
INSERT INTO myk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A fyɛnmɛɛ ni losixuyo fɛɛ pii di fulo Yesu na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. A wʼi pee cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesu ya kakanhaŋaa kiimu pye ge, ba saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pʼa kee ɲa wɛ, na nɔhɔpiire ti bɛ ɲaa ti na xhuulo na yu: «Masɔŋɔ kʼa byi Dawuda Ja wu mu wɛ!» A pu logoo di yìri. ");
INSERT INTO myk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wee tuun wu ni a pʼi Yesu pye: «Yemu pii wa yu mɛ ge, ta mu wa yi nuri mɛ?» A Yesu di pu pye: «Uun! Ta yee bɛ sanha li kalaa Kilɛ Kafila wu ni wɛ? Na: ‹Mu ya ma masɔŋɔ pye kʼa foro nɔhɔpiire ni pubinŋɛɛ ɲɔyɔ ni.›» ");
INSERT INTO myk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ba wʼa yee jo wɛ, na foro kulo li ni, na pu yaha wà, na gari na shɛ shɔn Bɛtani kulo li ni. ");
INSERT INTO myk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ayiwa, ɲimuguro ti ɲisɔɔgɔ ki na, Yesu na kuri na ma Zheruzalɛmu ni, a xuugo di wu ta. ");
INSERT INTO myk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A wu nitoodige ka ɲa koo li ɲɔ na, na fulo kee na. Ga wu ya yafiin bɛ ɲa ki na wɛyɛ yɛ kadugo na wɛ. Ayiwa, a wu kee nitoodige ki pye: «Mu da ga yasɛyɛ pye nige bada wɛ!» Taapile ni a kee nitoroŋɔ kʼi waha. ");
INSERT INTO myk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ba kalaapiire tʼa lee ɲa wɛ, a lee di bye pu mu kakanhana fo xuuni. A pʼi Yesu yege na: «A ke nitoroŋɔ ke di bye dii na waha mɛ taapile ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A Yesu di pu pye: «Can na nʼa da yi jo yi mu, nʼa daa bu bye yee mu, nakaara bye tʼi ɲɛ yee zɔlɔɔ pu ni bada wɛ, lemu nɛ pye ke nitoodige ke na ge, yee da ba da lee yɛ na-ɛ dɛ! Ga yee na ba ke faaboboŋɔ ke pye: ‹Yìri laha naha, mʼa shɛ mayɛ wá suumɔ lɔhɔ ni.› Lee na bye. ");
INSERT INTO myk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yi ba yaaga tuugo bɛɛri ɲɛɛri ni nʼa daa ni, yi na kee ta.» ");
INSERT INTO myk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ayiwa, a Yesu di shɛ jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na sipyii pu ɲɔ kɔn na galaa. Na wu yaha wu na wee kalaa wu kaan, a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni nɔhɔlɛɛ pʼi fulo wu na, na wu yege na: «Sefɛɛrɛ tekɛ gbɔɔrɔ ni mu wa kii keree kii pyi wɛ? Jɔgɔ wʼa kee fanha ki kan mu mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A Yesu di pu pye: «Nɛ bɛ wʼa da yee yege kaa nigin na. Yi bu na ɲɔ shɔ, wee tuun wu ni, sefɛɛrɛ temu gbɔɔrɔ ni nɛ bɛ ya kii keree kii pyi ge, nɛ bɛ na tee jo yi mu. ");
INSERT INTO myk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔgɔ wu dʼa Yohana tun na wʼa batizeli pyi wɛ? Kilɛ laa sipyii?» A pʼi puyɛ pye: «Wù bu jo: ‹Kilɛ wʼa wu tun›, wu na jo: ‹Wee tuun wu ni ɲaha na yee di ya ta dà wu na-ɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ga wù bu nɔhɔ jo: ‹Sipyii pʼa wu tun›, sipyiire ti na lemu pye wù na ge, lee wo fyaara wa wù ni, bani sipyiire ti bɛɛri wa Yohana wii Kilɛ tudunmɔ.» ");
INSERT INTO myk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lee na, a pʼi Yesu pye: «Wèe ya cɛ wɛ.» A Yesu bɛ di pu pye: «Ayiwa nɛ bɛ ya she, sefɛɛrɛ temu gbɔɔrɔ ni nɛ bɛ ya kii keree kii pyi ge, nɛ bɛ da tee jo yee mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A Yesu di jo sanha na: «Yee di wa lekɛ kɔɔn yiyɛ funyɔ ni kii keree kii shizhaa na wɛ? Jalaa shuun pu bye ná wa mu. A wu ba jashiimɛ wu pye: ‹Na ja, shɛ niɲaa wo caŋa ɲii li wo labye wu pye na ɛrɛzɛn tɛgɛ ki ni.› ");
INSERT INTO myk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A wee ja wu wu pye: ‹Nɛ se wà wɛ.› Ga ba jɛɛrɛ ya pye wɛ, yemu wʼa jo ge, a yee wo daajeŋɛ di jé wu ni. A wu gari tɛgɛ ki ni. ");
INSERT INTO myk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A to wu shɛ yee ninuyɔ jo ja shuun wo wu bɛ mu. A wee di wu pye: ‹Uun, nɛ na zhɛ.› Ga na dɛrɛ pye wu ya shɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pu shuun wu ni wekɛ dʼa tofɔɔ wu ɲidaan pye wɛ?» A pʼi jo: «Jashiimɛ we.» Wee tuun wu ni a Yesu di pu pye: «Can na nʼa da yi jo yi mu jo fanhafɛɛ wari shɔvɛɛ ni navarashaa pu na ba jé yee ɲaha na Kilɛ wo saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bani Yohana ya pa yee mu, koo lemu lʼa tii ge, na ba lee shɛ yee na. A yee di bye yee ya dà wu na wɛ. Ga, a fanhafɛɛ wari shɔvɛɛ ni navarashaa pʼi dà wu na. A yee di lee bɛ ɲa, ga lee bɛ na yee ya ta daajeŋɛ jo yi guri dà wu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A Yesu di pu pye sanha na: «Yi le talenɛ le bɛ logo: Kɛrɛyɛ fɔɔ wa wʼa bi ɛrɛzɛn tɛgɛ ka shan, na ki maha ni kasɔrɔgɔ ni. A wʼi wege ka wolo na pye ɛrɛzɛn wu lɔhɔ ki tawologo, na zangaso wa yàa shazhɔn wu kaa na. Lee kadugo na a wu ɛrɛzɛn tiire tɛgɛ ki kaa le ɛrɛzɛn faapyii pii keŋɛ ni, na gari fiige katii ni. ");
INSERT INTO myk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ba ɛrɛzɛn wu lɛduun ya pa dɛrɛŋɛ wɛ, a wu wu wo kapyebyii pii yaha kari pee ɛrɛzɛn faapyii pu mu, na pu shɛ ɛrɛzɛn nilɛ wu shɔ pa. ");
INSERT INTO myk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ga, a pʼi kapyebyii pu co, na wa kpɔn xuuni, na wa gbo, na taanri wo wu wá gbo ni kagereye ni. ");
INSERT INTO myk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","«Ayiwa, a ɛrɛzɛn wu kafɔɔ wu kapyebyii pii bɛ tun piimu ya ɲɛhɛ nizhiilee pu na ge. A pʼi pee bɛ pye ba pʼa nizhiilee pu pye wɛ. ");
INSERT INTO myk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lee bɛɛri kadugo tàan, a tɛgɛ ki kafɔɔ wʼi wuyɛ pyaa ja tun kari, na jo: ‹Nɛ ja we kunni, pu na zhɛ gbɔɔrɔ taha wee na.› ");
INSERT INTO myk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ga ba ɛrɛzɛn faapyii pu ɲii ya taha ɛrɛzɛn wu kafɔɔ wu ja wu na wɛ, a pʼi puyɛ pye: ‹Cɛn wu lɔvɔɔ wu wʼa we. Yi pa wù wu gbo, cɛn wu na bye wù wo.› ");
INSERT INTO myk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A pʼi jafɔɔ wu co, na gari ni wu ni ɛrɛzɛn tɛgɛ ki kadugo yíri, na shɛ wu gbo. ");
INSERT INTO myk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Wee tuun wu ni ɛrɛzɛn tɛgɛ ki kafɔɔ wu ba ba, wʼa ba lekɛ pye pii ɛrɛzɛn faapyii pii na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A pʼi wu pye: «Wu na ba yee sipyikuuyo yi gbo gbogaguunɔ na, na ɛrɛzɛn tɛgɛ ki kaa le piitiilee keŋɛ ni, piimu na da ɛrɛzɛn nilɛ wu kaan wu mu wu ɲidaan tuun ni ge.» ");
INSERT INTO myk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lee kadugo na a Yesu di pu pye: «Ta yee ya le kalaa Kilɛ Kafila wu ni wɛ? Na: ‹Puyirilee pʼa faakagereŋɛ kemu she ge, kee kʼa pye puga ki gunŋmii li faakagereŋɛ ki nijeŋɛ ke. Li wii, Kafɔɔ wʼa lee pye kakanhana li wa lii wù ɲaha tàan.›» ");
INSERT INTO myk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","A Yesu di jo sanha na: «Nʼa da yi jo yi mu jo lee lʼa Kilɛ saanra ti pye ti na da ba shɔ yee na, na ti kan shi watii mu, wemu na ba nagoo pyi ge.  ");
INSERT INTO myk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wemu bu do kee kagereŋɛ ke ɲuŋɔ ni, weefɔɔ na gɛgi gɛgi. Kee kagereŋɛ ki shiin bu do sipya bɛɛri ɲuŋɔ ni, weefɔɔ na dɔnhɔnɔ.» ");
INSERT INTO myk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ba saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pʼa Yesu talenɛ li logo wɛ, a pʼi li cɛ na pee kaa wʼa byi. ");
INSERT INTO myk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lee na a pʼi ganha na cogana shaa wu na, ga, a pʼi fya sipyiire ti na. Bani pee bi Yesu wii Kilɛ tudunmɔ. ");
INSERT INTO myk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ayiwa, a Yesu di talenɛ la bɛ jo sanha sipyiire ti mu na: ");
INSERT INTO myk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Fugba saanra tʼa foro kaa lemu fɛni ge, lee li wa mɛ: Saan wa ya ligbɔhɔ gbegele wu ja cekaanra ni. ");
INSERT INTO myk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pʼa sipyii piimu yiri cekaanra ti ni ge, a wu wu kapyebyii pu tun shɛ pee yiri yalige ki na. Ga pu ya sɔɔ na pa wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A wu kapyebyii piitiilee yaha kari, na pee pu shɛ pu pye: ‹Nɛ na yalige ki gbegele xɔ nimɛ. Nɛ na sìnmɛ niiyɛ ye, ni na sìnmɛ yapɔrɔyɔ yi gbo, keree ki bɛɛri ya gbegele xɔ. Yi pa cekaanra ti lige ki fɛni.› ");
INSERT INTO myk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ga sipyiyirilee pu ya ta lee la shishiin wii kaa wɛ. A pu bɛɛri di gari pu nibyegee fɛni. Wa ya kari wu kɛrɛyɛ ni, a wa di gari wu kegaaŋa tapyege ni. ");
INSERT INTO myk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A pusamaa di saan wu kapyebyii pu co, na pu kanha fo xuuni, na pu gbo. ");
INSERT INTO myk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A saan wu luu di yìri. A wʼi wu sɔrɔsii yaha kari pʼa shɛ pee sipyigbuu pu gbo, na pu kulo li sòrogo. ");
INSERT INTO myk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lee kadugo na a wu wu kapyebyii pu pye: ‹Cekaanra ti ligbɔhɔ ki kunni ya gbegele xɔ, ga sipyii piimu pʼa fɛnhɛ yiri ki na ge, pee niŋɛ wa nige ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yi shɛ kodoroyo yi ni, yi bu shɛ sipyii piimu bɛɛri ta wà, yʼi ba ni pee bɛɛri ni lige ki kaa na.› ");
INSERT INTO myk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A kapyebyii pʼi gari kakuutoroyo yi ni. Sipyii piimu bɛɛri pʼa shɛ da wà ge, nizaamaa fara niguumɔɔ na, a pʼi ba pee bɛɛri pinnɛ fo cekaanra ti puga kʼa ɲi lilii pu na. ");
INSERT INTO myk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ayiwa, a saan wu ba jé, na lilii pu wii, na ná wa ta pu ni, wemu ya ta cekaanra fàya yi le wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A wu jo: ‹Naɲii, dii mu dʼa pye na jé naha cekaanra fàya yi ba wɛ?› Ɲɔshɔɔrɔ ya ta wee ná wu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wee tuun wu ni a saan wu wu kapyebyii pu pye: ‹Yi wu tɔɔyɔ ye ni wu keye yi pɔ! Yi wu wà kpɛɛngɛ ki na nibiige ki ni! Mɛsuu ni gankunnɔ na ba bye wá.› ");
INSERT INTO myk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bani sipyiɲɛhɛmɛɛ kunni pu wa yiri, ga piimu ɲaha kʼa bulo ge, pee ya ɲɛhɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lee kadugo na a Farizhɛɛn pʼi shɛ puyɛ ɲa, na pʼi Yesu sha pɛri, pʼi wu co wuyɛ pyaa wo ɲɔ jomɔ fɛni. ");
INSERT INTO myk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A pʼi pu wo kalaapiire ta ni Hɛrɔdi wo sipyii pii tun na pu shɛ Yesu pye: «Karamɔgɔ, wèe ya li cɛ na jo can fɔɔ mu ɲɛ. Mʼa sipyii pu fiinŋɛ na galaa bɛ Kilɛ koro li ni. Mu ya fyagi sipya wa shishiin na wɛ, bani sipyii pu bɛɛri pu ɲɛ nigin mu mu. ");
INSERT INTO myk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ayiwa mu wo fungɔngɔ di wa kekɛ le kaa le ni wɛ? Lʼa saha pʼa munaa pɛrɛmɛ kaan Oromɛ saannaa Sezari mu laa, li ya saha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu bi pu funguuŋɔ ki cɛ, a wu pu pye: «Yee shuun shuun juu piiri, ɲaha na yʼi na ɲɔ yegee wɛ? ");
INSERT INTO myk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wari wemu ni yʼa munaa pɛrɛmɛ pu saraa ge, yi wu tuunɔ la shɛ na na.» A pʼi wari dɛɲɛ nigin wa shɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A Yesu di pu pye: «Jɔgɔ wo jaa ni wu kama pu wa we na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A pʼi jo: «Oromɛ saannaa Sezari.» Wee tuun wu ni a Yesu di pu pye: «Yʼa Sezari wuu li kaan Sezari mu, yi da Kilɛ bɛ wuu li kaan Kilɛ bɛ mu.» ");
INSERT INTO myk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ba pʼa tee ɲɔshɔɔrɔ ti logo wɛ, a lee di pu ɲaha wɔ fo xuuni. A pʼi wu yaha wà, na gari. ");
INSERT INTO myk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ayiwa kee canuŋɔ ke, a Sadushɛɛn pii bɛ di ba shɛ Yesu yíri. Pee bi yu na xuɲɛnɛ da ba bye ɲiga na wɛ. A pʼi Yesu pye: ");
INSERT INTO myk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Karamɔgɔ, Kilɛ tudunmɔɔ Musa ya jo na ná wa bu xhu, na ta wu ya pya ta wɛ, na wu ceborona wu wee naxhugoshɔ wu lɔ, kɔnhɔ wu nagoo ta di yaha wee ná wu nixhugo ki mu. ");
INSERT INTO myk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lee ya bi ceboronamaa gbarashuun wa ta wèe mu naha. A nizhiimɛ wu cee leŋɛ, na xhu pya ta baa. A cee wu gan wu cuun wu mu, wee ɲɛ ceborona shuun wo we. ");
INSERT INTO myk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A lʼi bye mu ceborona shuun wo we, ni taanri wo wu bɛ shizhaa na fo na shɛ pu gbarashuun wu bɛɛri xɔ. ");
INSERT INTO myk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lee kadugo na a cee wu bɛ di xhu. ");
INSERT INTO myk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wee tuun wu ni xuu pu caɲɛŋɛ ke, wee cee wʼi da ba bye shɛn nigin wekɛ wo pii cebooloo gbarashuun we ni wɛ? Bani pu bɛɛri ya wu leŋɛ toro.» ");
INSERT INTO myk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A Yesu di pu pye: «Yee ya piin, bani le lʼa ka Kilɛ Kafila wu ni ge, yee wa lee cɛ wɛ, yʼi wa Kilɛ wo sefɛɛrɛ ti bɛ cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Xuu pu caɲɛŋɛ, sipyii wa da cèe leŋɛ, kelee na gbaya je wɛ. Ga pu bɛɛri na ba bye ba fugba mɛlɛkɛɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kilɛ ya yemu jo xuɲɛnɛ li shizhaa na ge, ta yee ya yee kalaa wɛ? Wʼa jo: ");
INSERT INTO myk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Nɛ ɲɛ Ibirayima wo Kilɛ, ni Ishaaga wo Kilɛ, ni Yakuba wo Kilɛ.› Kilɛ ɲɛ xuu wo Kilɛ wɛ, wyii wo Kilɛ wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ba sipyiire tʼa yee logo wɛ, a wu kalaa wu bye pu mu kakanhana. ");
INSERT INTO myk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ba Farizhɛɛn pʼa logo na Yesu ya fɛhɛnɛ wá Sadushɛɛn pu na wɛ, a pee di guri shɛ puyɛ pinnɛ sanha. ");
INSERT INTO myk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Shɛn nigin wa ɲɛ pu ni, wee bye saliya karamɔgɔ. Wee funŋɔ ki bye na Yesu pɛri wii. A wee di jo: ");
INSERT INTO myk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Karamɔgɔ, ɲɔmɛɛ lekɛ li dʼa pɛlɛ saliya wu ɲɔmɛhɛɛ ki bɛɛri ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A Yesu di wu pye: «‹Ma Kafɔɔ Kilɛ wu taan ma mu ma zɔ wu bɛɛri na, ni ma munaa li bɛɛri, ni ma fungɔngɔ ki bɛɛri.› ");
INSERT INTO myk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lee li wa saliya wu ɲɔmɛhɛɛ ki bɛɛri nizhiinɛ, na ɲɛ ki bɛɛri nigbɔɔ bɛ sanha. ");
INSERT INTO myk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Li shuun wuu lemu lʼa foro li fɛni ge, lee li wa mɛ. ‹Ma sipyiɲii wu taan ma mu ba mayɛ pyaa ki ɲɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Saliya wu ɲɔmɛhɛɛ ki bɛɛri, ni Kilɛ tudunmɔɔ pu wo kalaa wu bɛɛri wʼa foro kii ɲɔmɛhɛɛ shuun we ni.» ");
INSERT INTO myk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na Farizhɛɛn pu nibinnɛyɛ ta, a Yesu di pu pye: ");
INSERT INTO myk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Lekɛ yee di wa gɔɔn yi funyɔ ni Shɔvɔɔ wu shizhaa na wɛ? Jɔgɔ wo ja wu ɲɛ wii wɛ?» A pʼi wu pye: «Dawuda Ja wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A Yesu di pu pye: «Wee tuun wu ni ɲaha na Dawuda di wu pyi Kafɔɔ, Fɛfɛɛrɛ Munaa fanha ni wɛ? Bani Dawuda ya jo: ");
INSERT INTO myk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Kafɔɔ Kilɛ ya yi jo nɛ Kafɔɔ mu na: Tiin saanra tatɛɛngɛ ki ni na kanige cɛ, fo di ba ma pɛɛn pu tirige na pa le ma tɔɔyɔ nɔhɔ ni.› ");
INSERT INTO myk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ni Dawuda ya Shɔvɔɔ wu pyi Kafɔɔ, wee tuun wu ni wʼi ɲɛ dii wu ja yɛ nigin wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wa shishiin ya já Yesu ɲɔ shɔ pu ni, ali ni ɲɔɲii nigin bɛ ni wɛ. Na co kee caŋa ki na, wa shishiin ya luu waha na wu yege nige kaa la shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lee kadugo na a Yesu di wu kalaapiire te ni sipyiire ti pye: ");
INSERT INTO myk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Saliya karamɔgɔlɔɔ ni Farizhɛɛn pu wo nibyii li ɲɛ na sipyii pu kalaa Musa wo saliya wu ni. ");
INSERT INTO myk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lee wuu na saliya wu keree kiimu bɛɛri ni pʼa yi kalaa ge, yʼa yaa na pu ɲɔmɛɛ co, na ganha na kee bɛɛri pyi! Ga keree kiimu puyɛ pyaa ya byi ge, yi ganha ba kee taanni pu fɛni wɛ, bani kalaa wemu pʼa gaan sipyii pu mu ge, puyɛ pyaa ki ya wee koo ɲaari wɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pu ma tuguro nigbɔɔrɔ pɔ na taha sipyii ɲuyɔ ni, ga pʼi da ga gbara pu ali kabee bɛ taga ti lɔvɛɛ tɛgɛ pʼi ti tugo wɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pʼa pu kapyegee ki bɛɛri pyi kɔnhɔ sipyii di da pu wii. Lee lʼa pu pye pu na pu gbahaa ki wo sɛmɛɛ pee, ni pu kabogoo ki wo sɛmɛɛ pu pɛlɛgi. Na pu fadeye ɲɔwaya ye tɔɔngi ni yalere ni. ");
INSERT INTO myk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yaliceŋɛɛ wo tatiinceye, ni Kilɛ-pɛɛŋɛ piyɛyɛ yi wo ɲahagbaa tatiinyɛ yʼa dan pu ni. ");
INSERT INTO myk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sipyii na pu shaari pinnɛrɛ kpɛɛnyɛ na, na pu pyi: ‹Karamɔgɔlɔɔ›, lee bɛ lʼa dan pu ni xuuni. ");
INSERT INTO myk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ga yee kunni, yi ganha bu sɔɔ pʼa yi pyi: ‹Karamɔgɔlɔɔ› wɛ. Bani Karamɔgɔ nigin pe yɛ wu ɲɛ yee mu. Yee bɛɛri pu ɲɛ cebooloo. ");
INSERT INTO myk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yi ganha bu da da wa shishiin pyi naha ke ɲiŋɛ ke na yi to wɛ. Bani To nigin pe yɛ wu ɲɛ yee mu. Wee ɲɛ fugba we ni. ");
INSERT INTO myk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yi ganha bu sɔɔ pʼa yi pyi ɲuŋɔfɛɛ wɛ. Bani Ɲuŋɔfɔɔ nigin pe yɛ wu ɲɛ yee mu. Wee ɲɛ Shɔvɔɔ we. ");
INSERT INTO myk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wemu wu ɲɛ sipyigbɔ yi bɛɛri tɛ ni ge, wee wu pye yi bɛɛri wo kapyebye. ");
INSERT INTO myk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sipya wemu wʼa wuyɛ durogo ge, wee na ba dirige. Sipya wemu wʼa wuyɛ tirige ge, wee na ba durogo. ");
INSERT INTO myk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Bani yee wa fugba saanra ti koo li tɔni sipyii pusamaa ɲaha na. Yiyɛ pyaa ki wa jin ti ni wɛ, piimu pʼa giin pʼi jé ge, a yʼi ganha na pee bɛ ɲaha kɔɔn.  ");
INSERT INTO myk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Bani yee wa naxhugoshaa keŋɛ yaŋmuyɔ bɛɛri ŋmahana na zhuu pu na, na mɔni Kilɛ-ɲɛrɛgɛ na, kɔnhɔ yʼi yiyɛ pye see sipyii. Lee na yee wo jaagi kanhama pu na ba golo fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Bani yee wa ɲiŋɛ ke ɲaari, na suumɔ lɔhɔ ke bɛ ɲaari, kɔnhɔ yi sii shɛn nigin yɛ ta yi pye Yawutu ba yee ɲɛ wɛ. Yee bu wee ta na xɔ, yee na wee pye wʼa yaa ni Jahanɛmɛ ni tɔɔɲii shuun na toro yiyɛ pyaa ki tàan. ");
INSERT INTO myk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Bɔɔngɔ ki wa yee wogo, yee fyɛnmɛɛ piimu pu ɲɛ fyɛnmɛɛ kagaancomɔɔ ge! Bani yee wa yu na sipya wemu wʼa kàa Kilɛ-pɛɛŋɛ pugbɔhɔ ki na ge, na kee kaaga ke ya jateni wɛ. Ga wufɔɔ bu gaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo sanni wu na, na kee kaaga ke kʼa jateni. ");
INSERT INTO myk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fungɔnyɔ baa fɛɛ fyɛnmɛɛ yee ɲɛ. Kekɛ ki dʼa ye kekɛ na ye shuun we ni wɛ? Sanni we laa, kelee Kilɛ-pɛɛŋɛ pugbɔhɔ ke, kee kemu kʼa sanni wu pye fɛɛfɛɛ ge? ");
INSERT INTO myk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yee wa yu sanha na sipya bu gaa saraya yi tawologo ki na, na kee kaaga ke ya jateni wɛ. Ga saraga kemu kʼa taha saraga yi tawologo ki na ge, na wufɔɔ bu gaa kee na, na kee kaaga ke kʼa jateni. ");
INSERT INTO myk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fyɛnmɛɛ yee ɲɛ. Kekɛ ki dʼa ye kekɛ na wɛ? Saraga ke laa, saraya yi tawologo ke, kee kemu kʼa saraga ki pye fɛɛfɛɛ ge? ");
INSERT INTO myk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wee tuun wu ni wemu bu gaa saraya yi tawologo ki na, saraya yi tawologo ke, ni yaŋmuyɔ yemu bɛɛri yi ɲɛ ki ɲuŋɔ ni ge, yee bɛɛri na mʼa kàa. ");
INSERT INTO myk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wemu bu gaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki na, Kilɛ-pɛɛŋɛ pugbɔhɔ ke ni Kilɛ na mʼa kàa, wee wemu wʼa dɛn ki ni ge. ");
INSERT INTO myk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wemu bu gaa fugba we na, Kilɛ wo saanra koo le, ni Kilɛ wemu wʼa tiin li ni ge, pee na mʼa kàa. ");
INSERT INTO myk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Bani yee wa loyɔ wu yapyiire nifɛnhɛfɛnhɛrɛ ti jagi wo: nanayi, ni wɛyɛ yemu bɛɛri yʼa leni shiga ni ge. Ɲɔmɛhɛɛ kiimu tayerege kʼa pɛlɛ saliya wu ni ge, a yee di kee yaha wà. Kee ɲɛ: tiimɛ, ɲiɲaara, ni ɲɔmɛɛ fɛɛrɛ. Yee bi yaa na kii kagbɔhɔɔ kii pyi, na te nibiire te fara kee na. ");
INSERT INTO myk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fyɛnmɛɛ yee ɲɛ piimu pʼa fyɛnmɛɛ pii wo kagaanya co ge. Yee ya yi logbaga suguri, na fɔnfɔɔnrɔ wo ki ni, ga na dɛrɛɛ na ɲɔhɔyɔ juuri. ");
INSERT INTO myk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Yee ma cɛɛgbuugoo ni golɛyɛ kaduyo jii na fiinni, na ta yi dʼa ɲi nagaara yaŋmuyɔ, ni yi lakuuŋɔ yaŋmuyɔ na. ");
INSERT INTO myk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizhɛn fyɛn, fɛnhɛ cɛɛgbuu le, ni golɛgɛ ki funŋɔ ki je, lee bu bye, yi kaduyo yi bɛ na bye fɛɛfɛɛ yi mu. ");
INSERT INTO myk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Yee ɲɛ ba faya ɲɛ wɛ pʼa yemu fiinŋɛ ge. Ma bu yi wii, mʼa yi ta yʼa ɲɔ kpɛɛngɛ ke na, ga yi funyɔ dʼa ɲi xuu kaciiye ni yaŋmufɔnyɔ tuuyo bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mu yee bɛ ɲɛ. Yee ma yiyɛ pye na tifire fɛɛ yee ɲɛ sipyii ɲaha tàan, ga yee zɔlɔɔ pu dʼa ɲi shuun shuun juuro ni kuumɔ na. ");
INSERT INTO myk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Bɔɔngɔ ki wa yee shuun shuun jovɛɛ pii wogo, yee saliya karamɔgɔlɔɔ fara yee Farizhɛɛn na! Yee wa Kilɛ tudunmɔɔ pu faya yi yari na ɲɔgi. Piimu pʼa Kilɛ ɲɔmɛɛ co ge, yee wa pee wo faya yari ni kacɛŋɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yee wa yu na yee da ba bye ni yi wo tii pu ni pu wo caŋa ɲii li ni, na yee bi da ga sɔɔ di pu tɛgɛ pu Kilɛ tudunmɔɔ pu gbo wɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lee funŋɔ ni yeeyɛ pyaa ya li shɛɛ na piimu pʼa Kilɛ tudunmɔɔ pu gbo ge, na pee wo nagoo yee ɲɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ayiwa, yi shɛ ɲaha na, yi sefɛɛ pʼa lemu ɲɔ kɔn ge, yi lee ɲɔ fa! ");
INSERT INTO myk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wɔlɔɔ yee ɲɛ, matɔn nagoo. Yee na já pye dii na yiyɛ tánha Jahanɛmɛ na wɛ? ");
INSERT INTO myk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lee wuu na nʼa da ba Kilɛ tudunmɔɔ, ni fungɔnyɔ fɛɛ, ni kalaa fɛɛ tun yi mu. Yee na ba pii gbo pee ni, na pii kori tiye na, na pii kpɔn ni susɔlɔɔ ni yi Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. Yi na ba daha pu fɛni, na pu kana kulo ni kulo. ");
INSERT INTO myk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sipyitiimɛɛ piimu wo shishan pʼa wo ɲiŋɛ na ge, kɔnhɔ pee di ba do yi ɲuŋɔ ni, na co tiimɛ fɛɛ Abɛli wo shishan pu na, fo na pa nɔ Baraki ja Zakari wo shishan pu na, wee wemu yee ya gbo Kilɛ-pɛɛŋɛ pugbɔhɔ ki saraya yi tawologo ke, ni fɛfɛɛrɛ xuu wu tɛ wu ni ge. ");
INSERT INTO myk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Can na nʼa da yi jo yi mu, tee gbuuro te bɛɛri wo footɔnɔ li kanhama na ba do niɲaa wo sipyii pii ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Zheruzalɛmu, Zheruzalɛmu, mu wemu wʼa Kilɛ tudunmɔɔ pu xuli ge, piimu pʼa dunni ma mu ge, na kagereye taga na pee bɛ waa na xhuli ge, nɛ funŋɔ ya pye tɛɛgɛɛ niɲɛhɛŋɛɛ ni di ma nagoo pu pinnɛ, ba xhuu ya wu nagoo pinnɛɛ mɛ wu kapaŋa nɔhɔ ni wɛ. Ga yee di ya ta sɔɔ lee na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ayiwa yi puga ki na ba yaha wà nimɛ fɛɛfɛɛ, ki niwaga. ");
INSERT INTO myk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bani nʼa da yi jo yi mu, na co nimɛ na, yʼa da na ɲa nige wɛ, fo yi ba shɛ yu tuun wemu ni na: ‹Wemu wʼa ma mɛ Kafɔɔ mɛgɛ na ge, wee ɲɛ duba pya.›» ");
INSERT INTO myk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A Yesu di foro Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni na gaaŋi. A wu kalaapiire tʼi fulo wu na, na ganha na Kilɛ-pɛɛŋɛ pugbɔhɔ ki yereŋɛgana li shɛɛ wu na, kʼa kemɛ yàa yaagana lemu na ge. ");
INSERT INTO myk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A Yesu di pu pye: «Yee ɲii wa yee bɛɛri ni gɛ? Can na nʼa da yi jo yi mu jo kagereŋɛ ka shishiin wa da ba gori naha ka ɲuŋɔ ni wɛ. Yi bɛɛri na ba do fɛɛfɛɛ.» ");
INSERT INTO myk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na Yesu nidɛɛngɛ yaha Oliviye faaboboŋɔ ki na, a wu kalaapiire tʼi fulo wu na pu yɛ na, na wu yege na: «Lee na ba bye tuun wemu ni ge, wee shɛ wù na! Ɲaha shɛshɛɛrɛ temu na ba li shɛ na ma paduun wʼa nɔ, koŋɔ ki taaxɔɔ li bɛ dʼa nɔ ge, mʼa tee bɛ shɛ wù na!» ");
INSERT INTO myk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A Yesu di pu pye: «Yʼa yiyɛ kasɛri! Yi ganha bu sipya wa shishiin yaha wu yi piinŋɛ wɛ! ");
INSERT INTO myk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bani sipyii niɲɛhɛmɛɛ na ba ma ni nɛ mɛgɛ ni, na yu: ‹Nɛ wu ɲɛ Shɔvɔɔ we.› Pu na ba sipyiɲɛhɛmɛɛ piinŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yi na ba kashɛn keree nuri, na kashɛn gbegemɛ keree nuri. Ayiwa yi funyɔ ganha da bɛn wɛ! Li waha lʼi waha kee keree kʼa yaa na pye, ga lee di wa da ba bye taaxɔɔ li wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Shi wa na ba yìri shi watii kaa na. Saanra ta na ba yìri saanra tatii kaa na. Xuugo nigbɔhɔ ni ɲiŋɛ cɛlɛŋɛ na ba byi tɛyɛ ya ni. ");
INSERT INTO myk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kee keree kii bɛɛri wa kanhama pu keree ɲɔkɔɔnrɔ yɛ, ba cee laa ma yìri mɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ayiwa, sipyii na ba yi leni keye ni, pʼa ganha na yi kana, na yi xuli. Shi wu bɛɛri na ba yi kɔ nɛ mɛgɛ wuu na. ");
INSERT INTO myk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wee tuun wu ni sipyiɲɛhɛmɛɛ na ba nʼa daa wu yaha. Pu na ba puyɛ nɔhɔ yɛri, na puyɛ kɔ. ");
INSERT INTO myk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tudunmɔɔ kafinɛjuu niɲɛhɛmɛɛ na ba foro yere. Pu na ba sipyiɲɛhɛmɛɛ piinŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kakuuŋɔɔ ki ɲɔ na ba ɲɛhɛ tapyege ni. Lee ma bye kaɲuŋɔ na sipyiɲɛhɛmɛɛ wo taanɲɛɛgɛ ki cɛrɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ga wemu bu já luu mara fo na shɛ nɔ li tɛhɛnɛ na, weefɔɔ na ba shɔ. ");
INSERT INTO myk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pe Jozaama pe pu wa Kilɛ saanra ti kaa yu ge, pee na ba jo koŋɔ ke kabaya ye bɛɛri na, kɔnhɔ shi wu bɛɛri di pu logo. Lee kadugo na taaxɔɔ lʼi na nɔ. ");
INSERT INTO myk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ayiwa yi ba gyɛɛgi pyevɔɔ wu ɲa tuun wemu ni Fɛfɛɛrɛ xuu wu ni, wee wemu kaa Kilɛ tudunmɔɔ Daɲɛli ya jo ge. (Wa bu yi kalaa, wu yi ɲaha cɛ.) ");
INSERT INTO myk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wee tuun wu ni, piimu na ba bye Zhude fiige ki ni ge, pee di ba fe pʼa se faaboboyo xuu ni. ");
INSERT INTO myk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lee ba wemu ta kataŋa ɲuŋɔ ni, wu ganha bu da digi di wu yɛrɛyɛ lɔ puga ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wemu ba da wu kɛrɛyɛ ni, weefɔɔ ganha bu da guri ba puga di ba wu fadeŋɛ lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bɔɔngɔ na ba bye lahaa fɛɛ ni puŋmaraya fɛɛ wogo yee caya yi na. ");
INSERT INTO myk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yʼa Kilɛ ɲɛɛri kɔnhɔ tee tafɛrɛ ti caŋa ganha ba saha ni wiire tuun ni, kelee ni cadɛɛngɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bani kanhama nigbɔ na ba bye wee tuun wu ni pemu tuugo sanha bye ɲa wɛ, na co koŋɔ ki yaaduun wu na, fo na pa nɔ niɲaa na. Pee kanhama pu tuugo di wa da bye bɛ nige bada wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kilɛ da bye wu ya ya wolo bɛ yee caya yi ni wɛ, sipya wa shishiin bi da ga shɔ wɛ. Ga sipyii piimu ɲaha wʼa bulo ge, pee wuu na wʼa la wolo yee caya yi ni. ");
INSERT INTO myk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Ayiwa, wa ba yi pye wee tuun we ni na: ‹Yi wii, Shɔvɔɔ wu wa naha!› kelee ‹Wu we mɛ.› Yi ganha bu dà yee na wɛ! ");
INSERT INTO myk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bani kafinɛjuu pii na ba yìri, na puyɛ pye shɔvɛɛ ni Kilɛ tudunmɔɔ. Pu na ba ɲaha shɛshɛɛrɛ kagbɔhɔɔ ni kakanhaŋaa pyi kɔnhɔ pʼi sipyiire ti piinŋɛ. Ali Kilɛ ya sipyii piimu ɲaha bulo ge, nago ba pu da já ba pee bɛ piinŋɛ wɛ, pu bi da ba pee bɛ piinŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Li wii, nɛ kii keree kii bɛɛri jo yaha yi mu.» ");
INSERT INTO myk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ayiwa sipya wa ba yi pye: ‹Li wii, sige ke ni Shɔvɔɔ wu ɲɛ!›, yi ganha bu shɛ wà wɛ. Kelee wa bu yi pye: ‹Li wii, maaŋa ke ni wu wa naha!›, yi ganha bu dà yee na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kilɛ bu ɲi Kilɛ-nɔhɔ na, kpɛɛngɛ ki ma nɔ camutomɔ ni nɔgana lemu na ge, lee pagana li na Sipya Ja wu bɛ wa da ba ba. ");
INSERT INTO myk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Xuu wemu ni yaxugo ɲɛ ge, wà tobinyɛ ya yiyɛ pinnɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Pee kanhagbɔ pu wo caya yi ba doro yɛ, taapile ni nibiige na ba jé caŋa ki ni; yeŋɛ wa da kpɛɛngɛ yeege wɛ. Wɔrɔɔ ki na ba yìri yìri fugba we ni na pa do. Fugba wu sefɛɛrɛ ti na ba jɛlɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wee tuun wu ni Sipya Ja wu wo ɲaha shɛshɛɛrɛ te, tee na ba ɲa fugba we ni. Shi wemu bɛɛri wu ɲɛ ɲiŋɛ ke na ge, wu bɛɛri na ba mɛhɛɛ suu. Wu na ba Sipya Ja wu nibawo ɲa fugba ɲahaya ye na ni sefɛɛrɛ ti bɛɛri, ni nɔɔrɔ nigbɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Maga nigbɔhɔ ki mɛɛ li na ba foro. Sipya Ja wʼa sipyii piimu ɲaha bulo ge, wu na ba mɛlɛkɛɛ tun pu pee pinnɛ, na yìri koŋɔ ki kabaya shishɛɛrɛ wu bɛɛri na, na ba pu pinnɛ xuu nigin ni, ma li ɲɔ kɔn koŋɔ ke kabaŋa ka na, na se koŋɔ ke kabaŋa ka mu. ");
INSERT INTO myk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ɲaha shɛshɛɛrɛ ta te nitoodige shizhaa na: Ki geye ye ba ɲɔ kɔn na funni tuun wemu ni, yee wa ma li cɛ na ki nagoo pyeduun wʼa tɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mu li wa, yi ba kii keree kii bɛɛri ɲaa ki na byi tuun wemu ni, yʼi li cɛ na Sipya Ja wʼa tɛɛŋɛ na xɔ, na wʼa nɔ xɔ kuɲɔɔ li ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Can na nʼa da yi jo yi mu jo sipyii piimu pu wa ɲìi na nimɛ ge, sani pee bɛɛri pu xu ge, kii keree kii bɛɛri ɲɔ na va. ");
INSERT INTO myk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Fugba we ni ɲiŋɛ ke na ba doro, ga nɛ jomɔ pe wa da doro bada wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ga sipya wa shishiin wa kee caŋa ke ni wee tuun we cɛ wɛ, ali fugba mɛlɛkɛɛ pu bɛ wɛ, Kilɛ Ja wu bɛ wɛ. To Kilɛ yɛ nigin pe wʼa kee caŋa ke ni wee tuun we cɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ba Nuxhun wo caŋa ɲii li keree kʼa pye wɛ, mu Sipya Ja wu bɛ cabaŋa kʼa da ba bye. ");
INSERT INTO myk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na logbɔhɔ ki ta ki sanha ba wɛ, sipyii pu bi li, na gbuu, na cèe leŋɛɛ, na pu nagoo kaan gbaya ni, fo na shɛ nɔ caŋa kemu Nuxhun ya jé kɔɔgbɔhɔ ki ni ge. ");
INSERT INTO myk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pu ya puyɛ kaala kaa la shishiin bɛ na wɛ, fo na shɛ logbɔhɔ ki pye kʼa pa, na pu bɛɛri ɲuŋɔ tugo. Mu lʼa da ba bye Sipya Ja wu bɛ cabaŋa. ");
INSERT INTO myk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wee tuun wu ni namaa shuun na ba bye pu kɛrɛyɛ ni, pʼa nigin wa lɔ, na wa yaha wà. ");
INSERT INTO myk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cèe shuun na ba tira tiree, wa na ba lɔ na wa yaha. ");
INSERT INTO myk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lee wuu na yi kori yaha ɲìi na bani caŋa kemu Kafɔɔ wʼa ma ge, yi wa kee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yi li cɛ na puga fɔɔ da ba li cɛ na we tuun we ni nagaa da ba ba nibiige ni, wu bi da gori yaha ɲìi na. Wu da ga gbara nagaa wu jé wu puga wɛ. ");
INSERT INTO myk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lee wuu na yi bɛ pu gbegele yaha, bani yee ya Sipya Ja wu soŋi tuun wemu ni wɛ, wee tuun weyɛ pyaa ni wu da ba. ");
INSERT INTO myk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Kapyebye ɲɔmɛɛ fɔɔ fungɔngɔ fɔɔ wemu wo kafɔɔ wʼa wu teŋɛ wu puga ki wo kapyebyii pusamaa ɲuŋɔ ni, na wu pye na wʼa pu yaligee keree ɲaha wo ki tuun ni ge, wee ɲɛ jɔgɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wee kapyebye wu kafɔɔ wu ba ba, na ba wu ta wu na li pyi li pyegana na, wee ɲɛ duba pya. ");
INSERT INTO myk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can na nʼa da yi jo yi mu, wee kapyebye wu kafɔɔ wu na ba wu teŋɛ wu keŋɛ yaŋmuyɔ yi bɛɛri ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ga wee kapyebye we bu da sipyikuuŋɔ, wu na li kɔn wuyɛ funŋɔ ni na wee kafɔɔ wʼa da zhɛ mɔ wà. ");
INSERT INTO myk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wʼa ɲɔ kɔn na wu kapyebyeɲii pu sani, na li, na gbuu ni yagbagbaa ni. ");
INSERT INTO myk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ayiwa, caŋa kemu ni tuun wemu wu ɲɛ kapyebye wu ya wu kafɔɔ wu soŋi-i ge, kee caŋa ke ni wee tuun we ni wu da ba. ");
INSERT INTO myk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wu na ba wee kapyebye we kɔri, na wu taa pinnɛ ni shuun shuun juu ni. Mɛsuu ni gankunnɔ na ba bye wà. ");
INSERT INTO myk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ayiwa, fugba saanra ti na ba foro doɲiŋɛ pushaa kɛ wa fɛni, piimu ya pu sokinnaa lɔ na se di zhɛ cenabun poo wu ɲuŋɔ círi ge. ");
INSERT INTO myk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pu kɛ wu ni, kaguro wa wu bye fungɔnyɔ baa fɛɛ, kaguro wa di ɲɛ fungɔnyɔ fɛɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A fungɔnyɔ baa fɛɛ pʼi pu wo sokinnaa pu lɔ, ga pʼi ya ta sìnmɛ patii lɔ na taha sokinnaa pu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A fungɔnyɔ fɛɛ pʼi pu wo sokinnaa pu lɔ, na sìnmɛ patii bɛ lɔ na taha pu wo sokinnaa pu na. ");
INSERT INTO myk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A cepoo wʼi mɔ, wu da ba wɛ. A ŋmunumɔ di pu bɛɛri ta, a pu bɛɛri di ŋmunɔ. ");
INSERT INTO myk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A mujuu la di ba foro ɲiɲiŋɛ ki na na: ‹Cenabun poo wu we! Yi foro shɛ wu círi!› ");
INSERT INTO myk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wee tuun wu ni a doɲiŋɛ pushaa kɛ wu bɛɛri di yìri, na pu sokinnaa pu yàa yàa. ");
INSERT INTO myk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A fungɔnyɔ baa fɛɛ pʼi fungɔnyɔ fɛɛ pu pye: ‹Wèe wo sokinnaa pʼa zhaa da furi, yi sìnmɛ dɔɔni wa kan wù mu.› ");
INSERT INTO myk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A fungɔnyɔ fɛɛ pʼi pu pye: ‹Ahayi! Sìnmɛ pemu pu ɲɛ wèe mu ge, pee wa da ga wèe ni yee yaa wɛ. Yi shɛ sinbɛrɛlɛɛ pu mu, yʼi shɛ pa shɔ yiyɛ mu!› ");
INSERT INTO myk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A fungɔnyɔ baa fɛɛ pʼi gari sìnmɛ pu fɛni, a cenabun poo wu ba na pu yaha wà. Pushaa kaguro wemu wʼa bi gbegele ge, a pee di jé ni cenabun poo wu ni cekaanra puga ki ni. A pʼi gbura ki shɔ̀hɔ. ");
INSERT INTO myk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lee kadugo tàan a pii pu bɛ di ba nɔ, na xhuulo na: ‹Kafɔɔ, kafɔɔ, gbura ki mugi wù mu!› ");
INSERT INTO myk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ga, a cenabun poo wu pu pye: ‹Can na nʼa da yi jo yi mu jo nɛ yee cɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lee wuu na yi kori yaha ɲìi na, bani yi wa kee caŋa ke ni wee tuun we cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Fugba saanra tʼa foro ná wa fɛni wee wemu ya gaaŋi kulo ni ge. A wʼi wu kapyebyii pu yiri, na wu keŋɛ yara li kaa le pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A wu wari talaan kaguro kan wa mu, na wari talaan shuun kan wa mu, na talan nigin kan taanri wo wu mu. Wee wari we ya kan pu mu na saha ni pu bɛɛri nigin nigin wu wo sefɛɛrɛ ɲuŋɔ kana ni. ");
INSERT INTO myk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kaguro wʼa kan wemu mu ge, a wee di wakaraa kegaaŋa ɲɔ kɔn ni wu wo wu ni. A wʼi wari talaan kaguro wa bɛtii ta na fara we wu kaguro wu na. ");
INSERT INTO myk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A shuun fɔɔ wu bɛ di kegaaŋa pye ni wu wo wu ni, na talaan shuun wa ta na fara wu na. ");
INSERT INTO myk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ga, a talan nigin fɔɔ wu shɛ wege tugi, na wu kafɔɔ wu wo wari wu ŋmɔhɔ wà. ");
INSERT INTO myk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","A kapyebyii pu kafɔɔ wu sii mɔ wà, na na pa ba. Ba wʼa pa ba wɛ, wu ni kapyebyii pu ni, a pʼi jate wu wolo. ");
INSERT INTO myk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A wari talaan kaguro fɔɔ wʼi fulo wu na ni we wu kaguro wu bɛ ni na jo: ‹Na Kafɔɔ, talaan kaguro mu ya kan nɛ mu, we kaguro we nɛ ta wu kuduun.› ");
INSERT INTO myk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A wu kafɔɔ wu wu pye: ‹Lʼa ɲɔ kapyebye nizaama ɲɔmɛɛ fɔɔ. Mʼa pye ɲɔmɛɛ fɔɔ kafɛnhɛfɛnhɛnɛ ni, lee wuu na nʼa da kagbɔhɔɔ kaa le ma keŋɛ ni. Pa wù binnɛ funŋɔ taan!› ");
INSERT INTO myk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","A talaan shuun fɔɔ wu bɛ di fulo wu na, na wu pye: ‹Na kafɔɔ, talaan shuun mu ya kan nɛ mu, we shuun we nɛ ta wu kuduun.› ");
INSERT INTO myk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A wu kafɔɔ wu jo: ‹Lʼa ɲɔ, kapyebye nizaama ɲɔmɛɛ fɔɔ. Mʼa pye ɲɔmɛɛ fɔɔ kafɛnhɛfɛnhɛnɛ ni, lee wuu na nʼa da kagbɔhɔɔ kaa le ma keŋɛ ni. Pa wù binnɛ funŋɔ taan!› ");
INSERT INTO myk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Lee kadugo na a wari talan nigin tavɔɔ wu bɛ di fulo na jo: ‹Na kafɔɔ, nɛ bi li cɛ jo mu keree kʼa waha. Mu ya xuu wemu nugi wɛ, wee xuu wu wo yalɔɔrɔ mu ya luu. Mu ya xuu wemu wo yashi wá wɛ, wee xuu wu wo yapyiire mu ya gɔɔn. ");
INSERT INTO myk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nɛ fya, na shɛ ma wari wu ŋmɔhɔ ɲiŋɛ ke ni. Wu we!› ");
INSERT INTO myk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A wu kafɔɔ wu wu pye: ‹Kapyebye niguumɔ saa fɔɔ mu ɲɛ. Mu ya li cɛ na nɛ ya xuu wemu nugi wɛ, na wà nɛ na wo yalɔɔrɔ ti luu, na na yapyiire ti kɔɔn xuu ni nɛ ta wemu wo yashi wa-ɛ ge, ");
INSERT INTO myk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","go mu bi yaa na shɛ na wari wu yaha baŋi na dɛ, kɔnhɔ di ba ba, di shɛ wu lɔ ni wu kuduun ni.› ");
INSERT INTO myk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Yi wu wo wari talan nigin wu shɔ wu na, yʼi wu kan talaan kɛ fɔɔ wu mu! ");
INSERT INTO myk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","La ɲɛ wemu mu ge, la na ba gan wee mu na fara wu wuu li na, la ɲɛhɛ wu mu. Ga la ɲɛ wemu mu wɛ, ali nifɛnhɛfɛnhɛnɛ lemu bɛ li ɲɛ wu mu ge, lee bɛ na ba shɔ wu na. ");
INSERT INTO myk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","We kapyebye niguumɔ we kunni, yi wu co wá kpɛɛngɛ ke na nibiige ki ni! Mɛsuu ni gankunnɔ na ba bye wà. ");
INSERT INTO myk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Sipya Ja wu ba ba wu nɔɔrɔ wu ni tuun wemu ni ni mɛlɛkɛɛ pu bɛɛri ni, wu na ba diin wu saanra koro nɔɔrɔ wuu li ni. ");
INSERT INTO myk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Shi we bɛɛri na ba binnɛ wu tàan. Wu na ba pu waa na laha pu yɛ na ba yatɔɔnahama ma wu dubyaa ni wu sikaa waa laha mɛ pu yɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wu na ba dubyaa pu yaha wu kanige cɛ, na sikaa pu yaha wu kamɛnɛ cɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Ayiwa, saan wu na ba wu kanige cɛ wuu pu pye: ‹Yi pa, na To wu wo duba nagoo pee. Saanra temu tʼa gbegele na yaha yee ɲaha na fo koŋɔ ki yaaduun wu ni ge, yi pa jé tee ni, yʼi ti pye yi wuuro. ");
INSERT INTO myk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bani xuugo ya nɛ ta, a yee di nɛ kan nɛ li. Waga ya nɛ ta, a yee di nɛ kan nɛ gba. Nɛ bi bye nabun, a yee di nɛ tirige yi kaban. ");
INSERT INTO myk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Fafunmɔ bye nɛ na, a yee di nɛ fafunmɔ pu xɔ. Nɛ bi bye yama fɔɔ, a yee di nɛ keree yàa. Nɛ bi bye kaso ni, a yee di shɛ foro nɛ na.› ");
INSERT INTO myk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ayiwa, pee sipyii piimu pʼa Kilɛ ɲɔmɛɛ co ge, pee na saan wu pye: ‹Kafɔɔ, tuun wekɛ ni wèe dʼa mu xuugo wo wu ɲa, na yalige kan mu mu wɛ? Kelee na mu waga wo ɲa, na mu kan mu ya gba wɛ? ");
INSERT INTO myk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tuun wekɛ ni wèe dʼa mu nabɔrɔ wo wu ɲa, na mu tirige wù puga, kelee na ma fafunmɔ wo ɲa, na pee fafunmɔ pu xɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tuun wekɛ ni wèe dʼa ma yama wo, kelee na ma kaso wo wu ɲa, na shɛ foro ma na wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Saan wu na pu pye: ‹Can na nʼa da yi jo yi mu jo tuun bɛɛri ni yee ya lee la pye ali nɛ cebooloo pu bɛɛri wo nifɛnhɛfɛnhɛnɛ nigin bɛ na ge, nɛ na yee ya li pye.› ");
INSERT INTO myk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Lee kadugo na saan wu na kamɛnɛ cɛ wuu pu pye: ‹Yi laha na tàan, yee laŋi fɛɛ piiri! Yi shɛ nafugibaaga ki ni, kee kemu kʼa gbegele na yaha Shitaanni ni wu wo mɛlɛkɛɛ pu kaa na ge. ");
INSERT INTO myk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bani xuugo bi bye nɛ na, yee di ya ta yalige kan nɛ mu wɛ. Waga bi bye nɛ na, yee di ya ta nɛ kan nɛ gba wɛ. ");
INSERT INTO myk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɛ bi bye nabun, yee di ya ta nɛ tirige yi puga wɛ. Nɛ bi bye fafunmɔ ni, ye di ya ta nɛ fafunmɔ pu xɔ wɛ. Nɛ yama wo bi bye, nɛ bi bye kaso ni, yee di ya ta shɛ foro nɛ na wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ayiwa, pee bɛ na wu pye: ‹Kafɔɔ, tuun wekɛ ni wèe dʼa mu xuugo wo wu ɲa, kelee ma waga wo, kelee ma nabɔrɔ wo, kelee ma fafunmɔ wo, kelee ma yama wo, kelee ma kaso wo, na li she wèe da ma tɛgɛ-ɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Saan wu na pu pye: ‹Can na nʼa da yi jo yi mu, yee bu bye yee di ya lee la pye ali nɛ cebooloo pu bɛɛri wo nifɛnhɛfɛnhɛnɛ nigin bɛ na wɛ, yee ya ta li pye nɛ na wɛ.› ");
INSERT INTO myk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pee na ba jé kanhama nixhɔbaama ni. Ga piimu pʼa tii ge, pee na ba jé ɲìi sicuumɔ nixhɔbaama ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ayiwa, ba Yesu ya pee jomɔ pu bɛɛri jo xɔ sipyiire ti mu wɛ, na wu kalaapiire ti pye: ");
INSERT INTO myk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Yʼa li cɛ na cabyaa shuun tɛ ni Ɲuwuuro ti wo Kalenɛ lʼa da nɔ. Sipya Ja wu na ba jé keye ni, pʼa wu kori tige na.» ");
INSERT INTO myk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Yawutuu nɔhɔlɛɛ pʼi shɛ puyɛ pinnɛ Kayifɛ kaban, wee ɲɛ saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we. ");
INSERT INTO myk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A pʼi bɛ yi na na pu Yesu peele co ŋmɔhɔrɔ ni, pʼi wu gbo. ");
INSERT INTO myk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ga, a pʼi jo: «Wù ganha bu wu co kalenɛ li ni wɛ, kɔnhɔ tunmɔ ganha bu yìri sipyiire ti tɛ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na Yesu yaha Bɛtani kulo li ni Simɔ kaban, togo kʼa fɛnhɛ wemu co toro ge, ");
INSERT INTO myk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a cee wa di fulo wu na ni lasikoli gboro la ni. Lee bi ɲi pɛɛwa lasikoli wa na. A wee cee wu Yesu yaha wu na li, na ba wee lasikoli wu wo wu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ba Yesu kalaapiire tʼa lee ɲa wɛ. A pu logoo di yìri, a pʼi jo: «Te kakara te wo ɲuŋɔ di ɲɛ lekɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","We lasikoli we bi da já bɛrɛ wari niɲɛhɛmɛ na, na wee kan funmɔ fɛɛ mu.» ");
INSERT INTO myk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ba Yesu ya lee cɛ wɛ, na jo: «Ɲaha na yʼi we cee we zɔ tɛnri wɛ? Go kasaana wʼa pye mɛ nɛ na. ");
INSERT INTO myk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Funmɔ fɛɛ na da daa yee tɛ ni tuun bɛɛri ni, ga nɛ kunni wa da ba bye yee tɛ ni tuun bɛɛri ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","We lasikoli we wʼa wo na na ge, wʼa wɛri na ceepuuro ti kemɛ yaha faŋa le kaa na. ");
INSERT INTO myk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Can na nʼa da yi jo yi mu jo xuu bɛɛri ni pe Kilɛ Jozaama pe ya jo ke koŋɔ ke na ge, le we cee we ya pye ge, li bɛ na baari wà, na sipyii pu funyɔ tirige ni wu kaa ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ayiwa, Yesu kalaapiire kɛ ni shuun wu wa nigin wa, wemu mɛgɛ ki bye na Zhuda Isikariyɔti ge, a wee di shɛ saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu mu, ");
INSERT INTO myk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na shɛ pu pye: «Nɛ bu Yesu le yee keŋɛ ni, juu yee di da gan nɛ mu wɛ?» A pʼi warifyɛn tuuŋɔɔ kɛlɛɛ taanri (30) tɔrɔ kan wu mu. ");
INSERT INTO myk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na co wee tuun wu na a Zhuda di ganha na pyegazaana shaa wu Yesu le pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Shizhɛnhɛrɛ Baa Buuri wu wo Kalenɛ li cazhiige ke, a Yesu kalaapiire tʼi fulo wu na, na wu pye: «Ma funŋɔ wa wù Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele xuu wekɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A Yesu di pu pye: «Yi shɛ kanha ki ni, yʼi shɛ shɛn wefɔɔ pye: ‹Karamɔgɔ wʼa jo na wee wo tuun wʼa nɔ, na mu kaban wee ni wu kalaapiire tʼa da ba Ɲuwuuro ti wo Kalenɛ li yalige ki li.›» ");
INSERT INTO myk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A kalaapiire tʼi li pye ba Yesu ya yi jo pu mu wɛ. A pʼi Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ba piige kʼa pa wɔ wɛ, a Yesu ni wu kalaapiire kɛ ni shuun wu diin na li. ");
INSERT INTO myk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na pu yaha pu na li, a Yesu di ba jo: «Can na nʼa da yi jo yi mu, wa na ba nɛ le keŋɛ ni yee ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A kalaapiire ti ɲahaya di sii tanha fo xuuni. A pu bɛɛri di ɲɔ kɔn na wu yegee nigin nigin na: «Nɛ wi ya, Kafɔɔ?» ");
INSERT INTO myk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A Yesu di pu pye: «Wemu wʼa wu keŋɛ ki le golɛgɛ ki ni ni nɛ ni ge, wee wʼa da ba nɛ le keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sipya Ja wu na ba xhu ma na jo ba lʼa ka wu shizhaa na wɛ. Ga wemu wʼa da ba Sipya Ja wu le keŋɛ ni ge, bɔɔngɔ ki ɲɛ weefɔɔ wogo. Ali wee ná wu da bye pu ya wu se bɛ wɛ, lee bi da bɔrɔ wu mu.» ");
INSERT INTO myk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zhudasi wemu wu bi da ba Yesu le keŋɛ ni ge, a wee bɛ di wu yege na: «Nɛ wi ya, Karamɔgɔ?» A Yesu di wu pye: «Mayɛ pyaa kʼa yi jo.» ");
INSERT INTO myk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na pu yaha lige ki na, a Yesu di buuri wa lɔ, na baraga taha Kilɛ na, na wu kɛgi kɛgi na kan wu kalaapiire ti mu, na pu pye: «Yi wa lɔ yi li, nɛ ceepuuro ti wa te!» ");
INSERT INTO myk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lee kadugo na a wu ɛrɛzɛn lɔhɔ cɛɛgbuu li lɔ, na baraga taha Kilɛ na, na li kan pu mu, na jo: «Yi bɛɛri pu ka gba ke ni, ");
INSERT INTO myk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","nɛ shishan pu ɲɛ pe, Kilɛ wo kariɲɛɛgɛ ɲɔmɛɛ li wo shishan pe. Sipyiɲɛhɛmɛɛ wuu na pʼa wo, na pu jurumu wu yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nʼa da yi jo yi mu, na co nimɛ na, nʼa da ke ɛrɛzɛn lɔhɔ ke ka gba nige wɛ, fo caŋa kemu nʼa da ba ki nivoŋɔ gba ni yee ni na To wu saanra ti ni ge.» ");
INSERT INTO myk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba pʼa li xhɔ wɛ, na Kilɛ masɔŋɔ yoyo cee. Lee kadugo tàan a pʼi foro kari Oliviye faaboboŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ayiwa, a Yesu di wu kalaapiire ti pye: «Yee bɛɛri na ba baa na nɛ yɛ nigin yaha niɲaa wo piige keyɛ pyaa ni, bani lʼa ka Kilɛ Kafila wu ni na: ‹Nɛ na ba yatɔɔnahama wu gbo, dubyagbaha ki dubyaa pu bɛɛri na baa caaga.› ");
INSERT INTO myk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ga nɛ ba ɲɛ na foro xu ni tuun wemu ni, nɛ na doro yi ɲaha na Galile fiige ki ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A Pyɛɛri di jo: «Ali pusamaa bɛɛri ɲɛhɛ baa na ma wá, nɛ wa da ga ma wá bada wɛ!» ");
INSERT INTO myk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A Yesu di wu pye: «Can na nʼa da yi jo ma mu, niɲaa wo piige keyɛ pyaa ni, yani xhuupoo wu pa mɛɛ su ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri.» ");
INSERT INTO myk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A Pyɛɛri di wu pye: «Ali li mɛhɛ yaha nɛ wu xu bɛ ni mu ni, nʼa da ga foro ma kaa tàan wɛ.» A kalaapiire tisara bɛɛri di yee ninuyɔ jo. ");
INSERT INTO myk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lee kadugo na a Yesu ni wu kalaapiire tʼi gari xuu wa ni, wemu mɛgɛ ki ɲɛ na Zhetisemanɛ ge. A wu pu pye: «Yi tiin naha, di shɛ Kilɛ ɲɛɛri mɛke.» ");
INSERT INTO myk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A wu gari wà ni Pyɛɛri ni Zebede jalaa shuun wu ni. A lʼi sii wu zɔ wu kanha fo xuuni, na wu ɲaha bɛ tanha. ");
INSERT INTO myk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A wu pu pye: «Nɛ zɔ we bɛɛri wʼa tanha fo nɛ na zhaa di xhuu. Yi tiin naha, yʼi gori yaha ɲìi na ni na ni!» ");
INSERT INTO myk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A wu shɛ ɲaha na jɛri, na buri ɲiŋɛ na, na Kilɛ ɲɛɛri na: «Na To le kanhama cɛɛgbuu le sanha lii na na, ni li na já bye. Ga lee bɛ na, nɛ wo ɲidaan ganha bu bye wɛ, fo mu wo ɲidaan.» ");
INSERT INTO myk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A Yesu di guri pa wu kalaapiire taanri wu yíri, na ba pu ta pʼa ŋmunɔ. A wu Pyɛɛri pye: «Yee ya já kori yaha ɲìi na ni nɛ ni na ali lɛɛri nigin bɛ pye-e ya? ");
INSERT INTO myk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yi kori yaha ɲìi na! Yi da Kilɛ ɲɛɛri, kɔnhɔ yi ganha bu jé nɔwuuro ni wɛ. Sipya munaa ya sɔɔ, ga wu ceepuuro fanha kʼa cɛ̀rɛ.» ");
INSERT INTO myk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A Yesu di laha pu tàan tɔɔɲii shuun wuu li ni, na shɛ Kilɛ ɲɛɛri na: «Na To, li bu da nago le kanhama cɛɛgbuu le sanha da já lii nɛ na wɛ, fo nɛ bu gba li ni, wee tuun wu ni mu wo ɲidaan wu pye.» ");
INSERT INTO myk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lee kadugo na a wu guri pa sanha wu kalaapiire ti yíri, na ba pu ta pʼa ŋmunɔ sanha, bani ŋmunumɔ pu bi shɔ pu ni. ");
INSERT INTO myk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A Yesu di pu yaha wà, na laha pu tàan sanha, na shɛ Kilɛ ɲɛɛri tɔɔɲii taanri wuu li ni, na guri pee jomɔ pe ninumɔ na sanha. ");
INSERT INTO myk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lee kadugo na a wu guri pa wu kalaapiire ti yíri, na ba pu pye: «Yee wa ŋmunɔɔ sanha na ŋmɔni gɛ? Tuun wʼa nɔ, Sipya Ja wu na ba jé jurumupyii pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yi yìri wù da se! Li wii, ná wemu wʼa da na le keŋɛ ni ge, wee ya nɔ.» ");
INSERT INTO myk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na Yesu yaha pee jomɔ pu na, a Zhudasi di nɔ, wee ɲɛ kalaapiire kɛ ni shuun wu wa nigin wa. A wu nɔ ni sipyiɲɛhɛmɛɛ pii ni. Ŋmɔparaa ni pubegee ki bye pee mu. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Yawutuu ɲahagbaa fɛɛ pu bi pee tun. ");
INSERT INTO myk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zhudasi wemu wu bi da ba Yesu le keŋɛ ni ge, wee bi ɲaha shɛshɛɛrɛ ta shɛ sipyiire ti na na: «Di ba shɛ ɲɔsɔɔnrɔ fò kan ná wemu mu, yʼi wee co, wee wu wa.» ");
INSERT INTO myk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A Zhudasi di dii Yesu na taapile ni, na wu pye: «Faabye Karamɔgɔ!» Na ɲɔsɔɔnrɔ fò kan wu mu. ");
INSERT INTO myk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A Yesu di wu pye: «Na naɲii, lemu na mʼa pa ge, lee pye.» Wee tuun wu ni a sipyii pusamaa di fulo Yesu na, na wu co. ");
INSERT INTO myk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A Yesu wo kalaapire la di li wo ŋmɔpara kɔɔngi li forogo ni, na saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kapyebye niwɛŋɛ paa laha. ");
INSERT INTO myk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A Yesu di lee kalaapire li pye: «Ma ŋmɔpara le le wà li forogo ki ni, bani piimu pʼa ŋmɔparaa luu ge, ŋmɔparaa ki da ba pee bɛ ɲuŋɔ tugo. ");
INSERT INTO myk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Go nɛ bi da já na To wu ɲɛɛri wʼa mɛlɛkɛɛ pii yaha na pa nimɛ nimɛ piimu ya ɲɛhɛ miliyo na ge, ta mu ya lee cɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ga lee da ba bye, Kilɛ Kafila wʼa yemu jo ge, yee ɲɔ na fa dii wɛ? Bani Kilɛ Kafila wʼa li shɛ na fo kii keree kii bu bye.» ");
INSERT INTO myk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lee kadugo na a Yesu di sipyiire ti pye: «A yee di ba ni ŋmɔparaa ni pubegee ni nɛ tacoŋɔ ni ma na jo kakuubye di ɲɛ ya? Nɛ bi dɛn caŋa bɛɛri Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na sipyii kalaa, yee di ya ta nɛ co wɛ. ");
INSERT INTO myk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ga kii keree kii bɛɛri ya pye kɔnhɔ Kilɛ tudunmɔɔ pʼa yemu bɛɛri ka Kilɛ Kafila wu ni ge, yee bɛɛri ɲɔ di fa.» Ayiwa, a wu kalaapiire ti bɛɛri di baa caaga na wu yaha wà. ");
INSERT INTO myk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Piimu pʼa Yesu co ge, a pee di gari ni wu ni Kayifɛ kaban, wee ɲɛ saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we. Saliya karamɔgɔlɔɔ ni Yawutuu ɲahagbaa fɛɛ pu nibinnɛgɛ ki bye wà. ");
INSERT INTO myk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A Pyɛɛri di laraga kɔn pu na, na daha pu fɛni, fo na shɛ jé saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kaaŋa ki ni. Ba wʼa jé kaaŋa ki ni wɛ, na diin gɛdii pu tàan kɔnhɔ wu ba le kaa le nɔhɔ ɲa. ");
INSERT INTO myk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu fara kiirikɔɔn kuruŋɔ ki na, pee bi can baa wo sɛɛri kaa la shaa Yesu fɛni kɔnhɔ pʼi wu gbo. ");
INSERT INTO myk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ga pu ya li ta wɛ, ali na li ta bɛ sipyiɲɛhɛmɛɛ bi ma na kafinɛyɛ leni Yesu na. A sipyii shuun wa bɛ di ba nɔ kurogo ki na, na pu woyo jo na: ");
INSERT INTO myk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«We ná we ya jo na wee na já Kilɛ-pɛɛŋɛ pugbɔhɔ ki ja, na ki yereŋɛ cabyaa taanri funŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu yìri yere, na Yesu pye: «Jomɔ pemu bɛɛri pii sipyii pii wa yu mu shizhaa na ge, mu wa da pu ɲɔ shɔ-ɛ gɛ?» ");
INSERT INTO myk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ga, a Yesu di cari wuyɛ na. A saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu jo: «Ma bi ɲɛ Shɔvɔɔ we, Kilɛ Ja we, nɛ li shaa ma mu Kilɛ ɲìi wo wu mɛgɛ na, jo ma yee jo wù mu.» ");
INSERT INTO myk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A Yesu di wu pye: «Mayɛ pyaa ki wa yi yu. Ga nʼa da yi jo yi mu jo na co nimɛ na, yi na ba Sipya Ja wu nidɛɛngɛ ɲa Se Bɛɛri Fɔɔ Kilɛ kanige cɛ. Yi na ba wu nibawo ɲa bɛ sanha fugba ɲahaya ye na.» ");
INSERT INTO myk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wuyɛ pyaa wo fadeŋɛ shɛɛngi, na jo: «Kilɛ mɛgɛ wʼa kyɛɛgi mɛ dɛ! Ɲaha fɛni wù ɲɛ sanha sɛɛrɛɛ pu mu wɛ? Yʼa wu Kilɛ mɛkyɛɛgɛrɛ jomɔ pu logo nimɛ. ");
INSERT INTO myk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yee di wa yekɛ yu wɛ?» A pʼi wu pye: «Wʼa yaa na wu gbo.» ");
INSERT INTO myk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ayiwa, a pʼi ɲɔlɔhɔ tugi na wà wu ɲaha ni, na wu kpɔn ni kaguruyo ni. A pii di kadahaa ja wu ɲibɛgɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","A pʼi jo: «Shɔvɔɔ we, ma bi sii Kilɛ tudunmɔ we, ma kpɔnvɔɔ wu mɛgɛ yiri wù mu!» ");
INSERT INTO myk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ayiwa, lee bi Pyɛɛri nidɛɛngɛ ta kpɛɛngɛ ki na kaaŋa ki ni, a kapyebyezhɔ wa di fulo wu na, na wu pye: «Go mu bɛ wu bye ni Galile shɛɛn Yesu ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ga, a Pyɛɛri di foro wu kaa tàan sipyii pu bɛɛri ɲii na. A wu jo: «Nɛ cɛ yekɛ mu wa yu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lee kadugo na a Pyɛɛri di gari kaaŋa ki tajege ki yíri. A kapyebyezhɔ wa bɛ di wu ɲa wà, na wee xuu wu wo sipyii pu pye: «We ná we bɛ wu bye ni Nazarɛti shɛɛn Yesu ni.» ");
INSERT INTO myk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A Pyɛɛri di foro wu kaa tàan sanha, na gaa. A wu jo: «Nɛ we ná we cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ba jɛri ya pye wɛ, piimu pu bi yere wà ge, a pee di fulo Pyɛɛri na, na wu pye: «Nakaara baa mu bɛ wu wa pu ni. Bani mu jogana li bɛ lʼa mu tayirige shɛɛ.» ");
INSERT INTO myk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ga, a Pyɛɛri di gaa, na wuyɛ laŋi. A wu jo: «Nɛ wee ná wu cɛ wɛ.» Taapile ni a xhupoo di mɛɛ su. ");
INSERT INTO myk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ayiwa, a Pyɛɛri funŋɔ di do ni Yesu jomɔ pu ni na: «Yani xhupoo wu pa mɛɛ su ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri na mu ya nɛ cɛ wɛ.» A Pyɛɛri di foro kari kpɛɛngɛ ki na, na shɛ mɛɛ su fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɲisɔɔgbɔhɔ ki na a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu bɛɛri ni nɔhɔlɛɛ pʼi bɛ yi na na Yesu ya yaa na wu gbo. ");
INSERT INTO myk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A pʼi wu pɔ, na shɛ wu le gbafɛnɛɛrɛɛ Pilate keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ayiwa, Zhudasi wemu wʼa Yesu le keŋɛ ni ge, ba wee ya li ɲa na pʼa Yesu kayuu li jo na yaha na pu wu gbo wɛ, a li daajeŋɛ di jé wu ni, a wu wari tuuŋɔɔ kɛlɛɛ taanri (30) wu lɔ, na wu shɛ ki tɛrɛŋɛ saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Yawutuu ɲahagbaa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A wu pu pye: «Kakuunɔ nɛ pye na jaagi baa fɔɔ ɲuŋɔ le xu ni.» Ga, a pee di wu pye: «Wèe wo ɲaha wa yee ni wɛ? Mu wo ɲuŋɔ wuu li wa lere!» ");
INSERT INTO myk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A Zhudasi di wari wu shan ɲiŋɛ na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na gari na shɛ wuyɛ pɔ gbo. ");
INSERT INTO myk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi wari wu lɔ, na jo: «Li ya saha wèe pu we wari we le Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo keshi wu ni wɛ. Bani shishan pɛrɛmɛ pu ɲɛ pii.» ");
INSERT INTO myk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A pʼi jo bɛ yi na, na wee wari we taga cogo faanrivɔɔ wu wo tɛgɛ ki shɔ, na kee pye pu nabuun faya. ");
INSERT INTO myk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lee wuu na pʼa kee tɛgɛ ke mɛgɛ yiri ali niɲaa we bɛ ni na shishan tɛgɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lee funŋɔ ni Kilɛ tudunmɔɔ Zheremi bi yemu jo ge, a yee ɲɔ di fa. Wu bi jo na: «Pʼa wari tuuŋɔɔ kɛlɛɛ taanri (30) wu lɔ, wee wemu wʼa pye wu pɛrɛmɛ pu ge. Kee ɲɔ ke na Izirayɛli nagoo pʼa bi bɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A pʼi wee wari wu lɔ na taga cogo faanrivɔɔ wu wo tɛgɛ ki shɔ. Kafɔɔ wʼa bi nɛ pye nɛ wu yee jo pu mu.» ");
INSERT INTO myk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ayiwa, a pʼi Yesu yereŋɛ Pilate ɲaha tàan. A wee di wu yege na: «Yawutuu wo saan mu ɲɛ ya?» A Yesu di wu pye: «Uun, ba ma wa yi yu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lee kadugo na, ba saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Yawutuu ɲahagbaa fɛɛ pʼa pa wu tɔɔgɔ leni wɛ, wu ya wa shishiin bɛ ɲɔ shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Wee tuun wu ni a Pilate di wu pye: «Keree kiimu bɛɛri na pʼa mu jaagi mɛ ge, mu wa ki nuri-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ga Yesu ya wu ɲɔ shɔ lee la shishiin na wɛ. A lee di gbafɛnɛɛri wu fo fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ayiwa, gbafɛnɛɛri wu bi tee na kaa la pyi. Lee ɲɛ, yee bɛɛri ba Yawutuu pu wo Bulooro Ɲuwuuro Kalenɛ lʼa nɔ wɛ, wʼa kasolemɛ nigin wa yaha, na saha ni sipyii puyɛ pyaa wo ɲidaan wu ni. ");
INSERT INTO myk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lee bi kasolemɛ wa ta wà wemu mɛgɛ ya foro ge. Wu mɛgɛ ki bye na Barabasi. ");
INSERT INTO myk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sipyiire ti bi pa binnɛ a Pilate di pu pye: «Barabasi ni Yesu wemu pʼa byi Shɔvɔɔ wu ge, pee shuun wu ni yi funŋɔ wa pu wekɛ yaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bani Pilate bi li cɛ na Yesu wo ɲɛpɛɛn na pʼa bi wu le wee keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na Pilate nidɛɛngɛ yaha kiiri wu takɔngɔ ki ni, a wu shɔ wʼi tuduro yaha pʼa pa jo wu mu na: «Ma ganha bu da ma tɔɔgɔ le we jaagi baa fɔɔ we wo keree ki ni wɛ, bani we keree kʼa nɛ kanha shɛn xuuni ŋmunɔgɔ ni piige ki ni.» ");
INSERT INTO myk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ga, a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Yawutuu ɲahagbaa fɛɛ pʼi sipyiire ti sɔn na pu Pilate ɲɛɛri na wu Barabasi yaha, wʼi Yesu gbo. ");
INSERT INTO myk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A gbafɛnɛɛri wu guri pu pye sanha: «Yi funŋɔ wa pu wekɛ yaha yi mu pii shuun we ni wɛ?» A pʼi wu pye: «Barabasi.» ");
INSERT INTO myk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A Pilate di pu pye: «Yesu wemu pʼa byi Shɔvɔɔ wu ge, di lekɛ pye wee na wɛ?» A pu bɛɛri di wu pye: «Wu kori tige na!» ");
INSERT INTO myk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A Pilate di pu yege na: «Kakuunɔ lekɛ wu dʼa pye wɛ?» Ga, a pʼi xhuulo xuuni na toro taashiinɛ li tàan na: «Wu kori tige na!» ");
INSERT INTO myk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A Pilate di ba li ta na wee wa da le já wɛ, bani la li bi faraa sipyiire ti kafugo na. A wʼi lɔhɔ ko, na wu keye je sipyiire ti bɛɛri ɲii na, na jo: «Nɛ tɔɔgɔ wa ni yi ni we jaagi baa fɔɔ we wo shishan pu wo na wɛ. Yeeyɛ pyaa wo keŋɛ woyo yi wa yere.» ");
INSERT INTO myk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A sipyiire ti bɛɛri di jo: «Wu shishan pu to wèe ni wù nagoo ɲuŋɔ ni!» ");
INSERT INTO myk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wee tuun wu ni a Pilate di Barabasi yaha, na Yesu kan pʼa kpɔn ni susɔlɔɔ ni, na wu le pu keŋɛ ni pu kori tige na. ");
INSERT INTO myk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ayiwa, a gbafɛnɛɛri wu sɔrɔsii pʼi gari ni Yesu ni gbafɛnɛɛri wu kaaŋa ki ni. A sɔrɔsii pu kuruŋɔ ki bɛɛri di foro pinnɛ wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A pʼi Yesu fàya yi wolo wu na, na fadeboroŋɔ niɲiga ka le wu na. ");
INSERT INTO myk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A pʼi xhuyo shin na pye saanra ɲudɔnɔ, na lee tɔ wu ɲuŋɔ ni, na wahagaan le wu kanige keŋɛ ke ni. A pʼi xhɔ na ganha na nuguro sinni wu fɛɛ ni, na wu la wo, na yu: «Ɲaabye Yawutuu saan we!» ");
INSERT INTO myk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A pʼi ganha na ɲɔlɔhɔ tugoo na woni wu na, na wahagaan li lɔ, na wu kpɔɔn ɲuŋɔ ke ni. ");
INSERT INTO myk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba pʼa wu la wolo xɔ mu wɛ, a pʼi fadeboroŋɔ niɲiga ki wolo wu na, na wuyɛ pyaa wo fàya yi le wu na, na gari ni wu ni di zhɛ gori. ");
INSERT INTO myk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ayiwa, ba pʼa foro kanha ki ni wɛ, na jíri Sirinɛ kulo li shɛn wa na, wee mɛgɛ ki bye na Simɔ. A pʼi wee karamu wʼa Yesu korikoritige ki lɔ. ");
INSERT INTO myk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A pʼi shɛ nɔ xuu wa ni, wee mɛgɛ ɲɛ na «Goligota», lee kɔri ɲɛ: «Ɲugɔrɔgɔ xuu». ");
INSERT INTO myk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A pʼi duvɛn suri durɔgi losorogo ka ni na kan wu mu wu gba. Ba wʼa yee ɲɛhɛ wɛ, wu ya sɔɔ na yi gba wɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba pʼa wu kori xɔ wɛ, a sɔrɔsii pʼi kagaanshaan pye, na wu fàya yi taa taa pu yɛ na na saha ni lee ni. ");
INSERT INTO myk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lee kadugo na, a pʼi diin na ganha na wu kasɛri. ");
INSERT INTO myk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pʼa Yesu jaagi lemu na ge, a pʼi yee ka kɔɔrɔ la na na kori wu ɲuɲɔ na na: ");
INSERT INTO myk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A pʼi nagaapelɛyɛ shuun wa kori tiye na ni Yesu ni. Nigin wa bye wu kanige cɛ, nigin wa di ɲɛ wu kamɛnɛ cɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kodoroloo pu bi pu ɲuyɔ kori, na wu shɛhɛlɛ, ");
INSERT INTO myk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na yu: «Mu wemu wʼa jo na mu na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ja, na ki yereŋɛ sanha cabyaa taanri funŋɔ ni ge, ma bi sii Kilɛ Ja we, mayɛ shɔ sa! Tigi laha tige ki na!» ");
INSERT INTO myk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ ni Yawutuu ɲahagbaa fɛɛ pu bɛ pu bi Yesu la wo, na yu: ");
INSERT INTO myk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Wʼa sipyii piitiilee shɔ, ga wʼa da já wuyɛ shɔ wɛ! GoIzirayɛli wo saan wu ɲɛ wii, na wu tigi laha nimɛ korikoritige ki na, wù na dà wu na! ");
INSERT INTO myk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‹Wʼa Kilɛ pye wu tadaŋa. Wu kaa bi dan Kilɛ ni, Kilɛ wu wu tirige sa!› Ta wu ya jo na Kilɛ Ja wee ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nagaapelɛyɛ yemu pʼa kori ni wu ni ge, mu yee bɛ bi wu fanri lee fanhagana li na. ");
INSERT INTO myk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na caŋa ki yaha ɲiŋɛ niŋɛ ni, a nibiige di jé fiige ki bɛɛri ni, fo na shɛ da lɛɛrɛɛ taanri. ");
INSERT INTO myk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yakoŋɔ wo tuunɔ ɲii taanri wu shizhaa na, a Yesu di ba mujuugbɔɔ wá na: «Eli, Eli, lama sabakatani?» Lee kɔ́ri ɲɛ: «Na Kilɛ, na Kilɛ, ɲaha na ma dʼa na yaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Piimu niyereye yi bye wà ge, ba pii ya lee mujuu li logo pee ni wɛ, na jo: «Kilɛ tudunmɔɔ Eli wʼa yiri.» ");
INSERT INTO myk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Taapile ni a shɛn nigin wa di baa kari pu ni, na shɛ yoro fyɛnmi vinɛgiri ni, na tee migile kagaantɔɔngɔ ka na, na shɛ gan Yesu mu wu sɔn. ");
INSERT INTO myk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ga, a pusamaa di jo: «Yere wù wu wii Eli bu da wu na da ba wu shɔ!» ");
INSERT INTO myk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A Yesu di mujuugbɔɔ la bɛ wá sanha, na xhu. ");
INSERT INTO myk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lee taapile li ni a Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲahaparaga fàŋa nigbilege kʼi daa shuun, na lɔ fugba wu na fo ɲiŋɛ ke. A ɲiŋɛ kʼi jɛlɛ, a faaboboyo ye di ja ja. ");
INSERT INTO myk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A faya yi ɲɔ di mugi mugi, Kilɛ wo sipyii piimu pʼa bi xu ge, a pee di ɲɛ. ");
INSERT INTO myk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A pʼi foro faya yi ni. Ba Yesu ya pa ɲɛ wɛ, a pʼi jé fɛfɛɛrɛ kulo li ni, na puyɛ shɛ sipyiɲɛhɛmɛɛ na. ");
INSERT INTO myk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sɔrɔsii ɲuŋɔfɔɔ we ni sɔrɔsii piimu samaa pu bi Yesu kasɛɛgɛ pyi ge, ba pee ya ɲiŋɛ cɛlɛŋɛ ke ni kee keree ki bɛɛri ɲa wɛ, a pʼi sii fya fo xuuni, na jo: «Can na Kilɛ Ja yɛ pyaa ki bye we ná we!» ");
INSERT INTO myk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cèe niɲɛhɛmɛɛ pii bɛ pu bi yere taliige ni na kii keree kii wii. Pee bi taha Yesu fɛni na yìri Galile ni, na baari pyi wu mu. ");
INSERT INTO myk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pii mɛyɛ yi wa ye pu ni: Magadala shɛɛn Mariyama, Yakuba ni Yusufu yɛ nu Mariyama, ni Zebede jalaa pu wo nu we. ");
INSERT INTO myk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ba yakoŋɔ kʼa pa nɔ wɛ, a Arimate shɛn naafuu fɔɔ wa di ba, wee mɛgɛ ki bye na Yusufu. Wee bɛ wu bye Yesu wo kalaapire la. ");
INSERT INTO myk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A wu gari, na shɛ Yesu nixhugo ki ɲɛɛri Pilate mu. A Pilate di jo na pu shɛ gbo wu kan wu mu. ");
INSERT INTO myk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A Yusufu di gbo wu lɔ, na fatɔvige nivoŋɔ ka migile wu na. Kee bi yàa ni lɛnfu* ni. ");
INSERT INTO myk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na shɛ wu le faŋa nivoŋɔ ka ni. Wu bi pu pye pʼa kee faŋa ke tugi na yaha wuyɛ kaa na faaya yi ni. A wu xhɔ na kageegbɔhɔ ka gologolo taga faŋa ki ɲɔ tɔ, na gari. ");
INSERT INTO myk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magadala shɛɛn Mariyama ni we wu Mariyama we, pee bi tiin na saha ni faŋa ki ni. ");
INSERT INTO myk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɲimuguro ti na, a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pii di shɛ gbafɛnɛɛrɛɛ Pilate mu. Kee caŋa kʼa pye cadɛɛngɛ ki wo gbegemɛ pu caŋa ki ɲimuguro. ");
INSERT INTO myk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","A pʼi ba wu pye: «Ɲuŋɔfɔɔ we, na we ɲugyɛɛgi sipya we yaha ɲìi na, wèe fungɔngɔ wa li na na wʼa bi jo na wee na ba ɲɛ na foro xu ni wu caxhugo caŋa taanri wogo na. ");
INSERT INTO myk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lee wuu na wèe funŋɔ wa ma di sɔrɔsii taha faŋa ki na, pee di da ki ɲuŋɔ sigee fo na shɛ cabyaa taanri wu torogo. Kɔnhɔ wu kalaapiire ti ganha bu da ba wu nixhugo ki yu pu da yi yu sipyii pu mu na wʼa ɲɛ na foro xu ni wɛ. Lee bu bye tee kurogo wo ɲugyɛɛgɛrɛ ti na golo taashiinɛ li bɛ wuuro ti na.» ");
INSERT INTO myk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A Pilate di pu pye: «Sɔrɔsii pu piiri! Lemu bɛɛri yʼa giin di bye, kɔnhɔ yʼi faŋa ki ɲuŋɔ sige xuuni ge, yi lee pye.» ");
INSERT INTO myk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A pʼi gari faŋa ki na, na shɛ ɲɔtɔŋɔ ki yàa, na fɛ yaha ki na, na sɔrɔsii pu taha ki na a pee di ganha na ki ɲuŋɔ sigee. ");
INSERT INTO myk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayiwa, ba cadɛɛngɛ kʼa toro wɛ, Dimazhi wu ɲisɔɔgɔ ki na, caŋa ki foroduun wu ni, a Magadala shɛɛn Mariyama ni we wu Mariyama wʼi gari di zhɛ faŋa ki wii. ");
INSERT INTO myk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Taapile ni a ɲiŋɛ cɛlɛŋɛ nigbɔhɔ di bye. A Kafɔɔ wo mɛlɛkɛ wa di digi na yìri fugba we ni, na ba kagereŋɛ ki gologolo laha faŋa ki ɲɔ na, na diin ki ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mɛlɛkɛ wu ɲaha ki bi ɲi ba Kilɛ-ɲinɛ ɲɛ wɛ, wu fàya ye di fiinŋɛ wɛlɛwɛlɛ ba xɔɔrɔ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sɔrɔsii piimu pʼa faŋa ki ɲuŋɔ sigee ge, a pee di fya fo na jɛlɛ, a pʼi bye kanna pʼa xu. ");
INSERT INTO myk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A mɛlɛkɛ wu cèe pu pye: «Yi ganha bu da vya wɛ! Nɛ li cɛ jo Yesu wemu pʼa kori tige na ge, wee yee wa zhaa. ");
INSERT INTO myk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wu wa naha wɛ, wʼa ɲɛ na foro xu ni ba wʼa bi yi jo wɛ. Pʼa bi wu sinniŋɛ xuu wemu ni ge, yi pa wee xuu wu wii. ");
INSERT INTO myk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ayiwa nimɛ yi fyaala shɛ yi jo wu kalaapiire ti mu na wʼa ɲɛ na foro xu ni, na wʼa gaaŋi yi ɲaha na Galile fiige ki ni, yi na zhɛ wu ɲa wà. Ye yʼa bye nɛ mu di jo yi mu.» ");
INSERT INTO myk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A cèe pʼi fyaala laha faŋa ki na, pu bi fya, ga pu zɔlɔɔ pu bɛ dʼa ɲi fundanga na. A pʼi ganha na fe na gaaŋi pʼi shɛ yee ɲaha jo kalaapiire ti mu. ");
INSERT INTO myk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taapile ni a Yesu di ba pu ɲuŋɔ círi na pu pye: «Yi faabye!» A cèe pʼi fulo Yesu na, na wu co tɔɔyɔ ye na, na pɛɛŋɛ taha wu na. ");
INSERT INTO myk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A Yesu di pu pye: «Yi ganha bu da vya wɛ! Yi shɛ yi jo na cebooloo pu mu na pʼa se Galile ni, na wà pʼa da zhɛ na ɲa.» ");
INSERT INTO myk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ayiwa, na cèe pu yaha koo na, sɔrɔsii piimu pu bi faŋa ki ɲuŋɔ sigee ge, a pii di gari pee ni, na shɛ kii keree kii bɛɛri ɲaha jo saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi shɛ puyɛ ɲa ni Yawutuu ɲahagbaa fɛɛ pu ni. A pʼi jo bɛ yi na, na wari niɲɛhɛmɛ wa kan sɔrɔsii pu mu, ");
INSERT INTO myk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na pu pye: «Yʼa yi yu na Yesu kalaapiire tʼa yee niŋmunuyɔ yaha, na ba gbo wu yu piige ki ni. ");
INSERT INTO myk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gbafɛnɛɛri wu bu yee logo, wèe na zhɛ yee ɲaha shɔɔnri ni wu ni na wù wo se pye, kɔnhɔ yaaga ganha bu yi ta wɛ.» ");
INSERT INTO myk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A sɔrɔsii pʼi wee wari wu lɔ, na shɛ li pye ba yʼa jo pu mu wɛ. A pee jomɔ pe di jaaga Yawutuu pu tɛ ni. Fo niɲaa we bɛ ni pee jomɔ pe ya yu. ");
INSERT INTO myk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ayiwa, a kalaapiire kɛ ni nigin wʼi gari Galile ni. Faaboboŋɔ kemu kaa Yesu bi jo pu mu ge, a pʼi gari wà. ");
INSERT INTO myk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba pʼa Yesu ɲa wɛ, a pʼi wu pɛlɛ. Ga, a nakaara di bye pii zɔlɔɔ ni pu ni. ");
INSERT INTO myk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A Yesu di fulo pu na, na pu pye: «Fanha ki bɛɛri kʼa kan nɛ mu fugba we, ni ɲiŋɛ ke na. ");
INSERT INTO myk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lee wuu na yi nɔ shi wu bɛɛri na, yʼi pu pye na kalaapiire! Yi pu batize To Kilɛ ni Ja ni Fɛfɛɛrɛ Munaa mɛgɛ na! ");
INSERT INTO myk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɲɔmɛhɛɛ kiimu nɛ jo yi mu ge, yi pu kalaa na pu taha kee fɛni! Li wii, nʼa da bye ni yi ni ɲiga bɛɛri fo na shɛ koŋɔ xɔ.»");
INSERT INTO myk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kilɛ Jozaama pe pu wa wu Ja Yesu Kirisa kaa yu ge, pu ɲɔkɔɔnrɔ ti wa te. ");
INSERT INTO myk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kilɛ tudunmɔɔ Ezayi ya li ka Yesu shizhaa na na: «Li wii, nʼa na tudunmɔ we tun ma ɲahagbaa na wu ma koo li yàa yaha.» ");
INSERT INTO myk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","«Wu mujuu lʼa fòro siwaga ki ni na: ‹Yi Kafɔɔ wu koo li yàa! Yi wu korogoo ki tii!›» ");
INSERT INTO myk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mu Yohana bye siwaga ki ni, na Kilɛ jomɔ pu yɛrɛ pyi sipyii pu mu na pu daajeŋɛ jo pu jurumu wu na pʼi batize, kɔnhɔ pu jurumu wʼi yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zhude fiige ki bɛɛri ni Zheruzalɛmu shɛɛn bɛɛri pu bi se Yohana yíri, na yeree pu jurumu wu na, na puyɛ kaan Yohana wu mu wu na batizeni Zhurudɛn Gba lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana yɛ pyaa, ɲɔhɔyɔ shiire fàya yi bye wu na, sɛɛgɛ di ɲɛ wu yapɔgɔ. Kabeeye ni wegeye funŋɔ sɛrɛ, yee yi bye wu ɲɔlige. ");
INSERT INTO myk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wʼa bi Kilɛ Kafila wu yu na: «We wʼa ma nɛ kadugo ge, wee fanha kʼa ɲɛhɛ nɛ wogo na. Na leele, na wu tanhaya mɛɛrɛ bɛ sanha, nɛ yaa ni lee ni wɛ: ");
INSERT INTO myk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nɛ yee batize lɔhɔ ni, ga wee na ba yi batize Fɛfɛɛrɛ Munaa ni.» ");
INSERT INTO myk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wee tuun wu ni a Yesu di ba na yìri Galile Nazarɛti ni. A Yohana di wu batize Zhurudɛn Gba lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu na foro lɔhɔ ki ni, taapile ni a wu fugba wu ɲɔ ɲa kʼa mugi, a Fɛfɛɛrɛ Munaa di digi wu na, ba gbegbe shazhira ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A mujuu la di foro fugba wu ni na: «Mu ɲɛ nɛ ɲidaan Ja, mu kaa ya dan nɛ ni tɛhɛnɛ baa.» ");
INSERT INTO myk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ba yee ya jo wɛ, a Fɛfɛɛrɛ Munaa lʼi gari ni Yesu ni siwaga ki ni. ");
INSERT INTO myk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A wu cabyaa kɛlɛɛ shishɛɛrɛ (40) pye siwaga ki ni, Shitaanni na wu taanna na wii. Wu bye yacoyo niŋɛ ni, mɛlɛkɛɛ di wu keree yari. ");
INSERT INTO myk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana na le xɔ kaso wu ni, Yesu ya kari Galile fiige ki ni, na shɛ Kilɛ wo Jozaama pe yu wà, ");
INSERT INTO myk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","na yu: «Tuun wʼa nɔ, Kilɛ saanra tʼa tɛɛŋɛ. Yi yere yi jurumu wu na, yʼi dà Kilɛ Jozaama pu na!» ");
INSERT INTO myk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Caŋa ka na Yesu yaha wu na doroo Galile Gba wu ɲɔ ki na, a wu fyashaa shuun ɲa: Simɔ ni wu ceborona Andire. Jɔ̀ pu bi waa gba lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A Yesu di pu pye: «Yi taha na fɛni, di yi pye sipyii shavɛɛ.» ");
INSERT INTO myk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Taapile ni a pʼi jɔlɔɔ pu yaha wà, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A wu shɛ ɲaha na jɛri, na Zebede wo jalaa shuun ɲa: Yakuba ni Yohana. Pu wo jɔlɔɔ pee di bi jooli pu kɔrɔgɔ funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Taapile ni a Yesu di pu yiri, a pʼi pu to Zebede ni kapyebyii pu yaha kɔrɔgɔ ki ni, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lee kadugo na a Yesu ni wu kalaapiire tʼi gari Kapɛrinɔmɔ kulo li ni. A Yesu di fɛnhɛ jé Kilɛ-pɛɛŋɛ puga ki ni cadɛɛngɛ ki na, na sipyii pu kalaa. ");
INSERT INTO myk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A Yesu wo kalaa wu kangana lʼi pu ɲaha wɔ xuuni, bani wu wo we, ni saliya karamɔgɔlɔɔ pu wo wu bye ninumɔ wɛ. Wu wo kalaa wu bi byi ni sefɛɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lee ya bi ná wa ta Kilɛ-pɛɛŋɛ puga ki ni, jina na ɲɛ wu ni. A wee di xhuulo na jo: ");
INSERT INTO myk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ɲaha mu di zhaa wèe fɛni wɛ, Yesu Nazarɛti shɛn? Mʼa pa ba wù kyɛɛgi gɛ? Nɛ mu shi cɛ, Kilɛ Fɛfɛɛrɛ wo mu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A Yesu di din jina wu na, na wu pye: «Cari mayɛ na, mʼa foro we ná we ni!» ");
INSERT INTO myk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A jina wu ná wu ɲahara saama na, na sipile wá, na foro wu ni. ");
INSERT INTO myk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A lʼi bye kakanhana sipyii pu bɛɛri mu; fo pu na puyɛ yegee na: «Le bɛ do? We ɲɛ kalaafomɔ dɛ! Fanha ni we ná we ya yu ni jinaa ni, pʼi wu ɲɔmɛɛ coni.» ");
INSERT INTO myk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A Yesu mɛgɛ di wakaraa Galile fiige ki bɛɛri círi. ");
INSERT INTO myk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ba Yesu ya foro yɛ Kilɛ-pɛɛŋɛ puga ki ni wɛ, a wu ni Yakuba ni Yohana di shɛ Simɔ ni Andire yɛ kaban. ");
INSERT INTO myk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lee di Simɔ yafezhɔ wu ta wʼa sinnɛ ceefuuro keŋɛ ni. Ba Yesu ya nɔ wà yɛ wɛ, a pʼi wee kaa jo wu mu. ");
INSERT INTO myk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A wu fulo wu na, na wu co wu keŋɛ na na yirige. A ceefuuro tʼi wu yaha. A wu yìri, na pu keree yàa. ");
INSERT INTO myk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ba caŋa kʼa to wɛ, a sipyii pʼi wá na ma wu mu ni yama fɛɛ tuuyo bɛɛri ni, ni jinaa wa piimu ni ge. ");
INSERT INTO myk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A kulo li shɛɛn bɛɛri di ba binnɛ kuɲɔɔ li ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Piimu pʼa bi kanha yama tuuyo niɲɛhɛyɛ keŋɛ ni ge, a Yesu di pee cuuŋɔ, na jinaa kɔri na yeege sipyiɲɛhɛmɛɛ ni. Wu ya ta sɔɔ jinaa pu mu pu jo wɛ, bani pee ya wu shi cɛ. ");
INSERT INTO myk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kee caŋa ki ɲimuguro ɲisɔɔgbɔhɔ ki na, na kpɛɛngɛ ki ta ki sanha wo wɛ, a Yesu di yìri, na gari sipoŋɔ ki xuu wa ni, na shɛ Kilɛ ɲɛɛri wà. ");
INSERT INTO myk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A Simɔ ni wu kaafɛɛ di ganha na wu shaa. ");
INSERT INTO myk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba pʼa shɛ wu ɲa wɛ, na wu pye: «Sipyii pu bɛɛri pʼa mu shaa.» ");
INSERT INTO myk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A wu pu ɲɔ shɔ na: «Wù shɛ xuu watii ni, wù tàan kulogoo kii ni, kɔnhɔ di shɛ Kilɛ Kafila wu jo kee bɛ ni. Bani lee wuu na nɛ pa.» ");
INSERT INTO myk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lee na wu bi Kilɛ Kafila wu yɛrɛ pyi Kilɛ-pɛɛŋɛ piyɛyɛ yi ni Galile fiige ki bɛɛri ni, na jinaa bɛ kɔri, na yeege sipyii ni. ");
INSERT INTO myk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Caŋa ka, togo fɔɔ wa ya shɛ nuguro sin wu fɛɛ ni, na wu ɲɛɛri, na jo: «Mu bu sɔɔ, go mu na já nɛ cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A wu ɲiɲaara di jé Yesu ni. A wu keŋɛ yeege, na gbɔn wu na, na jo: «Nɛ sɔɔ mu wu cuuŋɔ!» ");
INSERT INTO myk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taapile ni a togo kʼi wu yaha, a wu juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lee kadugo na a Yesu di wu yaha kari, na yi jo waha xuuni wu mu na: ");
INSERT INTO myk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Kasɛɛgɛ yaha mayɛ na, ma ganha yaaga jo sipya nigin bɛ mu wɛ. Ga shɛ mayɛ shɛ saraya ɲaha shɔɔnrivɔɔ wu na. Musa ya saraga kemu kaa jo ge, mʼa kee wolo ma sicuumɔ pu da wuu na. Kee na ba li shɛ na mʼa cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ga, a we ná we di foro na kaan ɲiini na doroo. A lee di Yesu pye wu ya já wuyɛ shɛ sipyii na, kulo la shishiin ni wɛ, wʼa yere sige ki ni, sipyii pʼi se wu mu, na yìri kabaya yi bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ba piiye ya ya toro wɛ, a Yesu di guri shɛ Kapɛrinɔmɔ ni. A sipyiire tʼi yi logo na puga wu wa. ");
INSERT INTO myk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A sipyiɲɛhɛmɛɛ di ba binnɛ, fo tayerege bɛ ya daa ali kuɲɔɔ li bɛ ɲɔ na wɛ. A Yesu di Kilɛ Kafila jo pu mu. ");
INSERT INTO myk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wee tuun wu ni a sipyii pii di ba ni ná kabanuxuyo shuun fɔɔ wa ni. Wee na ɲɛ namaa shishɛɛrɛ keye ni. ");
INSERT INTO myk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sipyii pu ɲɛhɛŋɛ keŋɛ ni pu ya já gbara Yesu na wɛ. Puga kemu ni wu ɲɛ ge, a pʼi kee wo kataŋa ki lahala wu ɲuɲɔ na, na ná wu ni wu yasinnɛgɛ ki tirige kee wege ki ni. ");
INSERT INTO myk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ba Yesu ya pee wo nʼa daa wu ɲa wɛ, na ná kabanuxuyo shuun fɔɔ wu pye: «Na ja, ma jurumu wʼa yafa ma mu.» ");
INSERT INTO myk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lee bi saliya karamɔgɔlɔɔ pii ta wà tiinnɛ na, a pee di ganha na yu puyɛ funyɔ ni na: ");
INSERT INTO myk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ɲaha na we ná we di yu le jogana le na wɛ? Kilɛ mɛgɛ we ya gyɛɛgi. Jɔgɔ wu dʼa já jurumu yafa sipya mu ni Kilɛ yɛ bɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Taapile ni a Yesu di pu fungɔnyɔ cɛ, na jo: «Ɲaha na ke fungɔngɔ ke tuugo dʼa tigi yee funyɔ ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na ná kabanuxuyo shuun fɔɔ wu pye: ‹Ma jurumu wʼa yafa ma mu.› kelee na wu pye: ‹Yìri mʼa ma yasinnɛgɛ ki lɔ, ma da ɲaari.› Lekɛ lʼa faha wɛ? ");
INSERT INTO myk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ga, kɔnhɔ yʼi li cɛ na Sipya Ja wu yaha ɲiŋɛ ki na, se wa wu ni wʼa sipyii pu wo jurumu wu yafani pu mu.» A wu ná kabanuxuyo shuun fɔɔ wu pye: ");
INSERT INTO myk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nɛ wʼa jo mu, Yìri, mʼa ma yasinnɛgɛ ki lɔ mʼa se puga!» ");
INSERT INTO myk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Taapile ni a wu yìri, na wu yasinnɛgɛ ki lɔ, na foro kari pu bɛɛri ɲii na. A lʼi bye kakanhana pu mu xuuni fo pu na baraga tɛri Kilɛ na, na yu: «Wèe sanha le ɲɔhɔ ɲa wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Lee kadugo na a Yesu di foro na kari sanha Galile Gba wu ɲɔ ki na. A sipyiɲɛhɛmɛɛ di gari wu yíri wà. A wu ganha na pu kalaa. ");
INSERT INTO myk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na wu nidorogo yaha, a wu Alife ja Levi nidɛɛngɛ ɲa fanhafɛɛ pu wari wu tashɔgɔ ki ni. A wu wu pye: «Taha na fɛni.» A Levi di yìri, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lee kadugo na a Levi di ba Yesu yiri caŋa ka, na yalige niɲɛhɛŋɛ yàa wu mu, a wu gari wà. Na wu yaha wu na li Levi kaban, a fanhafɛɛ wari shɔvɛɛ, ni jurumupyii niɲɛhɛmɛɛ piitiilee bɛ di ba diin na li ni Yesu, ni wu kalaapiire ti ni. Bani sipyiɲɛhɛmɛɛ pu bi taha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farizhɛɛn ni saliya karamɔgɔlɔɔ pʼa Yesu ɲa wu na li ni jurumupyii, ni fanhafɛɛ wari shɔvɛɛ pu ni ge, a pʼi ganha na wu kalaapiire ti pyi: «Ɲaha na we di li ni fanhafɛɛ wari shɔvɛɛ ni jurumupyii piitiilee bɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tuun wemu ni Yesu ya yee logo ge, a wu pu pye: «Sicuumɔ fɛɛ mago ɲɛ wɛrɛ fɔɔ na wɛ, fo yama fɛɛ. Sipyii piimu pʼa tii ge, nɛ ta pa di ba pee yiri wɛ, fo jurumupyii.» ");
INSERT INTO myk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tuun wa ni Yohana Batizelipye wo kalaapiire te, ni Farizhɛɛn wo kalaapiire ti bi suun leni na bɛ ni Yawutuu pu wo kalɛgɛɛ ki ni. Na pu yaha lee na a sipyii pii di ba Yesu yege caŋa ka na: «Yohana Batizelipye wo kalaapiire ti fara Farizhɛɛn pu na, pee ya suun leni, mu wo kalaapiire tʼi ya suun leni wɛ. Ɲaha na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Yesu di pu ɲɔ shɔ na: «Nɛ ɲɛ ba cenabun poo ɲɛ wɛ. Cekaanra tuun ni, cenabun poo kaafɛɛ na já suun le, na cenabun poo wu yaha ni pu ni shiizhan gɛ? Bada! Na pu ni cenabun poo wu yaha shiizhan, pu da já suun le wɛ. ");
INSERT INTO myk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Caya ya wa ma, cenabun poo wu na ba shɔ pu na. Yee caya yi ba nɔ, pu bɛ na da suun leni. ");
INSERT INTO myk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Wa shishiin da ga favonɔ tara falɛgɛ na wɛ. Lee bu bye, favonɔ li na nilɛgɛ ki kile zhɛɛngi, kee tashɛngɛŋɛ ki na bɛlɛ xuuni. ");
INSERT INTO myk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wa shishiin da ga duvɛnfomɔ le foroyo nilɛyɛ ni wɛ. Lee bu bye, duvɛn wu na foroyo yi shɛɛngi, duvɛn we ni foroyo yi bɛɛri na gyɛɛgi. Ga duvɛnfomɔ wʼa leni foroyo nivoyo ni.» ");
INSERT INTO myk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu ya pa doroo shinma kɛrɛyɛ ya tɛ ni cadɛɛngɛ ka na. A wu kalaapiire ti nidorowuu di koo li ɲɔ shinma sɛyɛ ya kɔn. ");
INSERT INTO myk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A Farizhɛɛn pʼi Yesu pye: «Li wii, kaa lemu ya yaa li pye cadɛɛngɛ ni wɛ, ɲaha na mu wo kalaapiire tʼi lee pyi wɛ?». ");
INSERT INTO myk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A Yesu di pu pye: «Tuun wemu ni xuugo ya pa saannaa Dawuda ni wu tahama-nɔhɔmɔɔ pu ta, na pu ta yalige ɲɛ pu mu-i ge, wʼa lemu pye ge, yee sanha lee kalaa ɲa bada-ɛ gɛ? ");
INSERT INTO myk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jegana lemu na wʼa jé Kilɛ-pɛɛŋɛ puga ki ni, saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɔɔ Abiyatari wo tuun wu ni ge, buuri we pʼa wo na gaan Kilɛ mu ge, na yee buuri ɲuyɔ ya lɔ na li, na ya kan wu tahama-nɔhɔmɔɔ pu bɛ mu. Na ta watii bi wee buuri we li wɛ, ni saraya ɲaha shɔɔnrivɛɛ yɛ bɛ wɛ. Ta yee sanha lee kalaa wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Lee kadugo na a Yesu di pu pye: «Sipya wuu na cadɛɛngɛ kʼa pye; sipya ya ta pye cadɛɛngɛ ki wuu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lee wuu na Sipya Ja wu ɲɛ cadɛɛngɛ ki bɛ Kafɔɔ.» ");
INSERT INTO myk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Caŋa ka, Yesu ya jé sanha Kilɛ-pɛɛŋɛ puga ka ni. Ná wa bɛ di ɲɛ wà wu keŋɛ ke na waha. ");
INSERT INTO myk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A pʼi ganha na Yesu kasɛri, na wu wii, wu bu da wu na da we ná we cuuŋɔ cadɛɛngɛ ni, kɔnhɔ pʼi kaɲuŋɔ ta di wu tɔɔgɔ le. ");
INSERT INTO myk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A Yesu di ná kewaga fɔɔ wu pye: «Yìri yere sipyii pu niŋɛ ni!» ");
INSERT INTO myk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lee kadugo na a wu pu pye: «Lʼa saha na kasaana pye cadɛɛngɛ ni laa, na kakuunɔ pye? Na sipya shɔ laa, na wu gbo? Lekɛ lʼa saha wɛ?» A pʼi fɛhɛ. ");
INSERT INTO myk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A Yesu loyire wo di ganha na pu wii. A pu niwewaa lʼi wu yatɛnyɛ gbo. A wu ná wu pye: «Ma keŋɛ ki sanha.» A wu ki sanha; a wu keŋɛ kʼi juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Taapile ni a Farizhɛɛn ni Hɛrɔdi wo sipyii pʼi foro na shɛ puyɛ ɲa, kɔnhɔ pʼi gbogana sha Yesu na. ");
INSERT INTO myk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lee kadugo na a Yesu ni wu kalaapiire tʼi yìri na kari Galile Gba wu ɲɔ ki na. A sipyiɲɛhɛmɛɛ di daha wu fɛni: pii ya yìri Galile fiige ki ni, ni Zhude fiige ke, ");
INSERT INTO myk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ni Zheruzalɛmu kulo le, ni Idumɔ fiige ke, ni Zhurudɛn Gba kadugo yíri sipyii pʼa, ni Tiiri ni Sidɔn kulogoo ni pu kabanuyo kulogoo. A sipyiɲɛhɛmɛɛ di Yesu kapyegee kaa logo, na shɛ wu yíri. ");
INSERT INTO myk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A Yesu di wu kalaapiire ti pye na pu kɔrɔgɔ ka yaha wu mu, kɔnhɔ sipyiire ti ganha wu cɔnri wɛ. ");
INSERT INTO myk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wʼa bi sipyiɲɛhɛmɛɛ cuuŋɔ. Lee na yama fɛɛ pu bɛɛri ya gburogi, kɔnhɔ pʼi gbɔn wu na. ");
INSERT INTO myk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ba jinaa pʼa wu ɲaa wɛ, na ganha na dun wu ɲahagbaa na, na xhuulo na yu: «Kilɛ Ja mu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A wu sii yi jo na waha pu mu xuuni, na wee ɲɛ sipya wemu ge, na pu ganha bu yee jo wa shishiin bɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lee kadugo na a Yesu di dugi faaboboŋɔ ka na, na wu ɲidaan sipyii yiri. A pʼi shɛ wu yíri. ");
INSERT INTO myk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A wu kɛ ni shuun ɲaha bulo na yaha wuyɛ mu, na pee pye wu Tudunmɔɔ, na pee tun na pu shɛ Kilɛ Kafila wu jo, ");
INSERT INTO myk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na fanha kan pu mu, pʼa jinaa kɔri pʼa yeege sipyii ni. ");
INSERT INTO myk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kɛ ni shuun wu ɲaha wʼa bulo ge, pee mɛyɛ yi wa ye: Simɔ (A Yesu di wee mɛgɛ ɲɛri «Pyɛɛri»), ");
INSERT INTO myk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ni Zebede jalaa shuun: Yakuba ni Yohana (A Yesu di pee mɛyɛ ɲɛri «Bonɛrijɛɛzi» lee kɔri ɲɛ «Pu ɲɛ ba Kilɛ-sɛlɛŋɛɛ ɲɛ wɛ»), ");
INSERT INTO myk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Andire, ni Filipe, ni Batelemi, ni Macoo, ni Tomasi, ni Alife ja Yakuba, ni Tade, ni Simɔ wemu wu bi bye Zelɔtilee kuruŋɔ ki ni ge, ");
INSERT INTO myk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Zhuda Isikariyɔti, wee wʼa pa Yesu le keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lee kadugo na a Yesu di ba puga. A sipyii pʼi guri puyɛ pinnɛ, fo wu ni wu kalaapiire ti ya já talige ta wɛ. ");
INSERT INTO myk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ba wu puga shɛɛn pii ya yee logo wɛ, na jo na: «Wu ɲuŋmuu ɲɛ wɛ.» Na gari wu fɛni di zhɛ jo. ");
INSERT INTO myk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Saliya karamɔgɔlɔɔ piimu pʼa yìri Zheruzalɛmu ni ge, a pee di jo: «Belizebuli wu ɲɛ wu ni. Jinaa ɲuŋɔfɔɔ fanha ni, wʼa jinaa pu kɔri.» ");
INSERT INTO myk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ba pʼa yee jo wɛ, a Yesu di pu yiri, na le talenɛ le jo pu mu na: «Dii Shitaanni wa di da já Shitaanni wa kɔri wɛ? ");
INSERT INTO myk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Saanra bɛɛri tʼa yìri tiyɛ kaa na ge, tee na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Puga bɛɛri sipyii pʼa yìri puyɛ kaa na ge, pee na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ga Shitaanni bu yìri wuyɛ kaa na, wu saanra tʼa taa, tee na gyɛɛgi. Wu saanra ti na xhɔ. ");
INSERT INTO myk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wa na já jé fanhaɲɛhɛŋɛ fɔɔ puga, di wu yaŋmuyɔ kuu, na ta ma ya fɛnhɛ wu pɔ-ɛ ya? Ga ma bu wu pɔ, ma na já puga ki yaŋmuyɔ yi kuu. ");
INSERT INTO myk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Can na, nʼa da yi jo yi mu, sipyii pu wo jurumu we, ni pu Kilɛ mɛkyɛɛgɛrɛ ti bɛɛri na já yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ga wa bu Fɛfɛɛrɛ Munaa li mɛgɛ kyɛɛgi, lee da yafa weefɔɔ mu wɛ. Weefɔɔ na gori yaha ni wee jurumu tɛhɛnɛ baa wo wu ni.» ");
INSERT INTO myk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ya yee jo, bani pʼa jo na: «Jina wu wa wu ni.» ");
INSERT INTO myk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na Yesu yaha kee puga ki ni, a wu nu ni wu ceboronamaa pʼi ba, na ba yere kadaan li na, na wa tun wu Yesu yiri. ");
INSERT INTO myk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sipyiɲɛhɛmɛɛ pu bi tiin na Yesu maha. A pʼi wu pye: «Ma nu we ni ma ceboronamaa pu wa kpɛɛngɛ ke na. Pʼa ma shaa.» ");
INSERT INTO myk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A Yesu di pu pye: «Jɔgɔ yɛ pu ɲɛ nɛ nu ni nɛ ceboronamaa pu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lee kadugo na a wu wu tàan sipyitiinyɛ yi wii na jo: «Nɛ nu ni nɛ ceboronamaa pu piiri naha. ");
INSERT INTO myk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sipyaa sipya wʼa Kilɛ ɲidaan pyi ge, wee wu ɲɛ nɛ ceborona, ni nɛ ceboroshɔ, ni nɛ nu.» ");
INSERT INTO myk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A Yesu di ba guri shɛ sanha Galile Gba wu ɲɔ ki na, a sipyii pʼi ganha na se na binnɛɛ, a wu pu ɲɔ kɔn na galaa. A sipyiɲɛhɛmɛɛ di ba binnɛ, na wu maha fo wʼa jé tiin kɔrɔgɔ ka ni. Kee kɔrɔgɔ kʼa bye lɔhɔ ki ni; sipyiire ti bɛɛri di ɲɛ kpɛɛngɛ ki na gba wu ɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wʼa bi pu kalaa kaɲɛhɛŋɛɛ ni, ni taleŋɛɛ ni. A wu yi jo pu mu wu kalaa wu ni na: ");
INSERT INTO myk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yi ye logo, caŋa ka ná wa ya foro na kari wu tɛgɛ ni di zhɛ wu alikama shi wá fenɛ shi wagana na. ");
INSERT INTO myk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na wu yaha wu na wee nuguzhi wu waa, a wu nuguro ta di do koo ni tɛgɛ ki ɲɔ na. A shazhɛɛrɛ di ba tee jɔ. ");
INSERT INTO myk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A ta di do faaga ɲuŋɔ ni pogoo kii ni. A tee di wɛri fin, bani poɲɛhɛrɛ bye wà wɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ba caya yʼa pa yeree wɛ, a tʼi fanhaŋa, na waha, bani nire tatii bye ti na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A nuguro ta di do xhuyo niŋɛ ni. A xhuyo yʼi ganha na lɛgi, na ba ti co, na ti li, a tʼi bye ti ya nagoo pye wɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A nuguro ta di do ɲijeŋɛ na. A tee di fin, na lɛ, na pya le. Pile la ma pyaa kɛlɛɛ taanri (30) pye; la ma kɛlɛɛ gbaara (60) pye, la ma xhuu nigin (100) pye.» ");
INSERT INTO myk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A Yesu di pu pye: «Wemu na logo ge, wu logo dɛ!» ");
INSERT INTO myk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tuun wemu ni Yesu ya pa laha sipyiɲɛhɛmɛɛ pu tàan ge, pii pʼa tee pye ni wu ni na fara wu kalaapiire kɛ ni shuun wu na ge, a pee di wu yege taleŋɛɛ ki kɔri na. ");
INSERT INTO myk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A wu pu pye: «Yee ya Kilɛ saanra niŋmɔhɔrɔ ti cɛmɛ pu bɛɛri ta. Ga sipyii pusamaa kunni, ti keree ki bɛɛri wʼa yu pu mu taleŋɛɛ ni, ");
INSERT INTO myk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kɔnhɔ: ‹Pʼi já wii xuuni, ga pʼi ganha bu yaaga ɲa wɛ. Pʼi já niwegee shan xuuni, ga pʼi ganha bu yi ɲaha cɛ wɛ. Lee kaa bɛ wɛ, pu na guri ba Kilɛ mu, wʼa pu jurumu wu yafa pu mu.›» ");
INSERT INTO myk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lee kadugo na a Yesu di pu pye: «Yee ya le talenɛ le cɛ-ɛ ya? Yee na ba taleŋɛɛ kisaŋaa bɛɛri cɛ dii wɛ? ");
INSERT INTO myk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuguzhi wavɔɔ we, Kilɛ jomɔ wʼa nuri. ");
INSERT INTO myk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sipyii pii di ɲɛ ba koo ɲɔ ɲɛ wɛ, jomɔ pa na nugi wee xuu we ni. Pee na pu logo, Shitaanni na ba taapile ni, na ba pee jomɔ pe ninugumɔ wolo pu funyɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wee cogo wu na faaga wo nuguro ti ɲɛ piimu ge, pee na jomɔ pu logo, na dà pu na tɔvuyo na ni fundanga ni. ");
INSERT INTO myk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ga nire di ɲɛ pu na wɛ, pu da mɔ wɛ. Lee wuu na cɔnrɔmɔ bu nɔ pu na, leeshin sipyii ba pu kana pee jomɔ pe wuu na, taapile ni pu ɲuyɔ na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Piimu pu ɲɛ ba xhuyo niŋɛ wuu pu ɲɛ-ɛ ge, pee na jomɔ pu logo, ");
INSERT INTO myk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ga ke koŋɔ ke wo funzhakeree, ni naafuu la piinŋɛ, ni keree kii bɛ wo la na pu cɔnri pu funyɔ ni, fo pu da nagoo pye wɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɲijeŋɛ wuu pu ɲɛ piimu ge, pee na pu logo, na pu co, na nagoo pye. Pile la ma bye kɛlɛɛ taanri (30), la ɲɛ kɛlɛɛ gbaara (60), la ɲɛ xhuu nigin (100).» ");
INSERT INTO myk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lee kadugo na a Yesu di pu pye: «Wa bu sokinna le, mʼa cɛrɛ shigile wu ɲuŋɔ ni laa, mʼa wu le karaga nɔhɔ ni? Ta yaaga ɲuŋɔ ni bɛ ma ma wu taha wɛ? ");
INSERT INTO myk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yaaga bɛɛri kʼa ŋmɔhɔ ge, ki na ba foro kpɛɛngɛ na, kaa kaa lʼa ŋmɔhɔ ge, sipyii bɛɛri na ba lee cɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wemu na logo ge, wu logo dɛ.» ");
INSERT INTO myk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A Yesu di guri li shɛ pu na na: «Ye yʼa nuri ge, yʼa yiyɛ kasɛri yee na. Yaaga kemu ni yee wa sipyii pu wo daanna wu pyi ge, kee yaaga ke ninuŋɔ ni yeeyɛ pyaa bɛ wo daanna wa da ba bye, na la fara yee mu. ");
INSERT INTO myk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","La ɲɛ wemu mu ge, la na gan wee mu. Ga la ɲɛ wemu mu wɛ, ali nifɛnhɛnɛ lemu bɛ li ɲɛ wu mu ge, li bɛ na zhɔ wu na.» ");
INSERT INTO myk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A Yesu di pu pye sanha: «Kilɛ wo saanra te ya foro kaa lemu fɛni ge, li le. Ná wa wʼa yemɛ nugi wu kɛrɛyɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wʼa ŋmunɔɔ piige la, wʼa yeree na caŋa xuu la, yemɛ pu na viin puyɛ mu, na lɛ, na ta wu ya yaaga cɛ pu keree ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pile li ma fin na foro ɲiŋɛ ki ni, na ba shiceŋɛ yeege, kee na ba sege pye. Sege ki na ba pya le xuuni. ");
INSERT INTO myk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ki ba lɛ, ná wu ma foro, na ki kɔn ni wu ŋmɔɔ ni, bani yalɔɔrɔ ti lɔduun wʼa nɔ.» ");
INSERT INTO myk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A Yesu di pu pye sanha: «Wèe na já Kilɛ saanra ti taanna ni ɲaha ni wɛ? Wù na talenɛ lekɛ taga ti kaa jo wɛ? ");
INSERT INTO myk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tʼa foro mutaridi pile fɛni. Ma ba da li nugi ɲiŋɛ na, lʼa cɛ̀rɛ foro ɲiŋɛ ke yashi we sama bɛɛri tàan. ");
INSERT INTO myk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ga li bu nugi xɔ, lʼa fin, na bɛlɛ na toro naxhoo wu tiye yi saya bɛɛri tàan. Lʼa gegbɔyɔ yeege, fo shazhɛɛrɛ na já shiire tagi yemu ɲimɛ ni ge.» ");
INSERT INTO myk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu bi sipyii pu kalaa, ni kii taleŋɛɛ kii tuuyo niɲɛhɛyɛ ni, pu na já kiimu logo, pʼi ki ɲaha cɛ ge. ");
INSERT INTO myk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wu bi yu ni pu ni talenɛ baa wɛ, ga wu ni wu kalaapiire ti bu bye puyɛ na, wʼa kee taleŋɛɛ ki bɛɛri kɔri jo pu mu. ");
INSERT INTO myk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kee canuŋɔ ki yakoŋɔ, a Yesu di wu kalaapiire ti pye: «Wù shɛ gba wu kadugo.» ");
INSERT INTO myk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A pʼi sipyiire ti yaha kari. Yesu bye kɔrɔgɔ kemu ni ge, a wu kalaapiire tʼi gari kee ni ni wu ni. A kɔrɔyɔ ya bɛ di binnɛ kari ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A kafɛɛgbɔhɔ ka di yìri, a lokuruyo yʼi ganha na dun kɔrɔgɔ ki funŋɔ ni, fo na zhaa di ki ɲi lɔhɔ na. ");
INSERT INTO myk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu bi bye na ŋmunɔɔ, kɔrɔgɔ ki kadugo yíri, na wu ɲuŋɔ taha ɲudahaŋa ka na. A wu kalaapiire tʼi wu ɲɛ, na wu pye: «Wù Karamɔgɔ, wù na da gori lɔhɔ ni, mu wa lee wii kaa-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A Yesu di ɲɛ, na sɛlɛ kafɛɛgɛ ke ni lokuruyo yi na, na jo: «Yi yere!» Taapile ni a kafɛɛgɛ ke ni lokuruyo yi bɛ di yere. A tunmɔ pu bɛɛri di yere. ");
INSERT INTO myk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lee kadugo na a Yesu di wu kalaapiire ti pye: «Ɲaha na yee di fyagi mɛ wɛ? Ɲaha na nʼa daa di sanha sii pye yee mu-i wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ga, a pʼi fya xuuni na ganha na puyɛ pyi: «We ná we dʼa sii jɔgɔ wɛ? Kafɛɛgɛ ni lɔhɔ bɛ na wu ɲɔmɛɛ coni.» ");
INSERT INTO myk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lee kadugo na a Yesu ni wu kalaapiire tʼi nɔ Galile Gba wu kadugo yíri Gerasa fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ba Yesu ya foro yɛ kɔrɔgɔ ki ni wɛ, taapile ni a ná wa di foro faxhuu wu ni, jinaa na ɲɛ wu ni, na ba wu ɲuŋɔ círi. ");
INSERT INTO myk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wee ná we tatɛɛngɛ ki bye faxhuu. Wa shishiin bɛ bi da já wu pɔ nige wɛ, ni tɔɔrɔ shɔnhɔyɔ bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pʼa shɔnhɔyɔ taga wu pɔ tɛɛgɛɛ niɲɛhɛŋɛɛ ni, na biriye le wu tɔɔyɔ na. Ga wʼa shɔnhɔyɔ yi kɔn, na biriye yi bɛ kɔn wolo tɔɔyɔ yi na. Wa shishiin bi da já wu yereŋɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Caŋa fara piige na, wu ma ɲaari gbee faxhuu we ni, ni yaya na, na xhuulo, na wuyɛ jɔgɔ ni faaya ni. ");
INSERT INTO myk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A wu Yesu ɲa, na wu yaha taliige ni, na baa na shɛ nuguro sin wu fɛɛ ni, ");
INSERT INTO myk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na jo ni mujuugbɔɔ ni na: «Ɲaha mʼa zhaa nɛ fɛni wɛ, Kilɛ-gbɔtabaaga Ja, Yesu? Nʼa ma ɲɛɛri, Kilɛ wuu na ma ganha bu na kyɛɛgi wɛ! ");
INSERT INTO myk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wʼa pee jo, bani Yesu ya jo na jina wu wu foro wee ná wu ni.» ");
INSERT INTO myk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wee tuun wu ni a Yesu di wu yege na: «Dii mu mɛgɛ di ɲɛ wɛ?» A wu wu ɲɔ shɔ na: «Nɛ mɛgɛ ɲɛ ‹Wèe Ya Ɲɛhɛ,›» bani jinaa niɲɛhɛmɛɛ pu bi jé wu ni. ");
INSERT INTO myk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A jinaa pʼi wu ɲɛɛri xuuni, na wu ganha da pee kɔri yeege fiige ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lee bi shaagbaga nijeŋɛ ka ta ki na naha yaŋa ki kabanugo. ");
INSERT INTO myk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wee tuun wu ni a jinaa pʼi Yesu ɲɛɛri na: «Wù yaha wù shɛ jé pii shaalaa pii ni.» ");
INSERT INTO myk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A wu sɔɔ, taapile ni a jinaa pʼi foro ná wu ni, na shɛ jé shaalaa pu ni. A shaagbaga kʼi gburogi, na digi yaŋa gologoloyo yi ni, na jé gba lɔhɔ ki ni, na xhu. Pee shaalaa pʼa bi shɛ kabɔfoŋɔɔ shuun (2.000) fɛni. ");
INSERT INTO myk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A pee shaanahamaa pʼi baa kari, na shɛ yee paari kanha ki ni, ni sitiinmɛɛ pu mu. A sipyii pʼi foro, na shɛ lee nibyii li wii. ");
INSERT INTO myk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pʼa nɔ Yesu na ge, a pʼi wee ná wu nidɛɛngɛ ɲa, jinaɲɛhɛmɛɛ pu bye wemu ni ge. Fàya yi bye wu na, wu dʼa cuuŋɔ. A pʼi fya. ");
INSERT INTO myk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Le lʼa pye jinaa sipya we, ni pii shaalaa pii shizhaa na ge, lee ya pye piimu ɲii na ge, a pee di lee paari pu mu. ");
INSERT INTO myk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wee tuun wu ni a pʼi ganha na Yesu ɲɛɛri na wu foro pu wo fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu nijewo kɔrɔgɔ ki ni, jinaa pu bye ná wemu ni ge, a wee di wu ɲɛɛri na wu bi da já binnɛ ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu ya ta sɔɔ wɛ, ga na li shɛ wu na na: «Ta se puga! Kafɔɔ Kilɛ ya ɲuŋɔ ɲaari ma na, na kagbɔhɔɔ kiimu bɛɛri pye ma mu ge, mʼa shɛ kee paari ma puga shɛɛn pu mu!» ");
INSERT INTO myk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A we ná we di gari. Yesu ya kagbɔhɔɔ kiimu bɛɛri pye wu mu ge, na shɛ kee paari Dekapoli fiige ki ni. A lʼi bye kakanhana ki logovɛɛ pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A Yesu di guri kɔrɔgɔ ki ni, na pa ke ki kabanugo ki na. Na wu yaha gba lɔhɔ ki ɲɔ na, a sipyiɲɛhɛmɛɛ di ba binnɛ wu fɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayiwa a Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ wa di ba, wee mɛgɛ ɲɛ Zhayirusi. Ba wʼa Yesu ɲa tuun wemu ni wɛ, na shɛ nuguro sin wu fɛɛ ni, ");
INSERT INTO myk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na wu ɲɛɛri saama na na: «Na poro fucɛɛrɛ lʼa taxuyo shaa. Nʼa ma ɲɛɛri, pa ma keŋɛ taha wu na, kɔnhɔ wu shɔ, wu bye ɲìi na.» ");
INSERT INTO myk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A Yesu di binnɛ kari ni wu ni. A sipyiɲɛhɛmɛɛ di daha wu fɛni, na wu cɔnri. ");
INSERT INTO myk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lee bi cee wa bɛ ta wà shishan na woni wu fɛni fo yee kɛ ni shuun. ");
INSERT INTO myk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wʼa bi kanha xuuni wɛbyii niɲɛhɛmɛɛ keŋɛ ni. Wu keŋɛ yara bɛɛri ya xɔ na yama pu ta pu sanha bɔrɔ wɛ, fo pusama na dɛnri. ");
INSERT INTO myk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A wu Yesu kaa logo, na ba sipyii pu tɛ ni Yesu kadugo yíri, na ba gbɔn wu fadeŋɛ na. ");
INSERT INTO myk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bani wu bi wu funŋɔ kɔɔn na: «Nɛ bu já ta kpɔn yɛ wu fadeŋɛ ke na, nɛ na juuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Taapile ni a wu shishan pʼi yere, a wu li cɛ wu cére ti na, na wee ya cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Taapile ni a Yesu di li cɛ wuyɛ ni na sefɛɛrɛ ta tʼa foro wee ni. A wu ŋmahana ɲɛri sipyii pu niŋɛ ni, na jo: «Jɔgɔ wʼa kpɔn nɛ fadeŋɛ ke na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A wu kalaapiire tʼi wu ɲɔ shɔ na: «Mu ɲaha ɲɛ sipyiire ti ni tʼa mu cɔnri, na yegee sanha na jɔgɔ wʼa kpɔn ma na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ga, a Yesu di ganha na wu tàan sipyii pu wii, kɔnhɔ wu lee pyevɔɔ ɲa. ");
INSERT INTO myk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kaa le lʼa pye wee cee wu na ge, wuyɛ pyaa bi lee cɛ. A wu fya na jɛlɛ, na ba nuguro sin Yesu fɛɛ ni, na yi bɛɛri fiinŋɛ jo wu mu. ");
INSERT INTO myk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ga, a Yesu di wu pye: «Na poro, ma nʼa daa wʼa ma shɔ. Ta se ɲaɲiŋɛ na! Mʼa shɔ ma kanhama pu na!» ");
INSERT INTO myk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na Yesu yaha pee jomɔ pu na, a sipyii pii di ba na yìri Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ wu kaban, na ba wu pye: «Ma poro fucɛɛrɛ lʼa xu. Ɲaha na ma sanha dʼa navunŋɔ pɛlɛ Karamɔgɔ wu na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ga Yesu ya ta ɲaha taga pee jomɔ pu yíri wɛ, a wu Zhayirusi pye: «Ma ganha da vya wɛ; dà yɛ nɛ na.» ");
INSERT INTO myk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wʼa ta sɔɔ wa shishiin bɛ wu pinnɛ ni wu ni wɛ, fo Pyɛɛri, ni Yakuba, ni wu ceborona Yohana. ");
INSERT INTO myk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A pʼi nɔ Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ wu kaban. A Yesu di tunmɔ pu ta pʼa pɛlɛ. Sipyiɲɛhɛmɛɛ pu bye wà, na mɛhɛɛ suu, na sipyaa waa. ");
INSERT INTO myk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A wu jé puga ki ni na pu pye: «Ɲaha na yee di mɛhɛɛ suu, na pe tunmɔ pe bɛɛri pyi wɛ? Pya wu ya ta xu wɛ, wʼa ŋmunɔɔ.» ");
INSERT INTO myk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A pʼi ganha na wu la wo. Wee tuun wu ni a wu pu bɛɛri yeege kpɛɛngɛ ki na. Porofɔɔ wu bye puga kemu ni ge, wu ni porofɔɔ wu to we, ni wu nu we, ni wu wo kalaapiire taanri we, a pee di binnɛ jé wà. ");
INSERT INTO myk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A wu fucɛɛrɛ li co li keŋɛ na na jo: «Talita kumi!» lee kɔri ɲɛ: «Fucɛɛrɛ, nɛ wʼa ma pye mu, yìri!» ");
INSERT INTO myk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Taapile ni a fucɛɛrɛ lʼi yìri na ɲaari. Li yee wa bye kɛ ni shuun. A lee di bye kakanhana pu mu fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ga, a Yesu di yi jo waha pu mu, kɔnhɔ wa shishiin ganha bu li cɛ wɛ. Lee kadugo na a wu pu pye na pu yalige kan li mu. ");
INSERT INTO myk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lee kadugo na a Yesu di foro wee xuu wu ni, kulo lemu ni wʼa lɛ ge, na shɛ wà. A wu kalaapiire tʼi binnɛ ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ba cadɛɛngɛ kʼa pa nɔ wɛ, a wu shɛ jé cadɛɛngɛ kʼa pa nɔ wɛ, a wu shɛ jé Kilɛ-pɛɛŋɛ puga ki ni, na ɲɔ co na sipyii pu kalaa. A sipyiɲɛhɛmɛɛ di wu kafila wu logo, a lʼi bye pu mu kakanhana. A pʼi ganha na yu na: «Mii we dʼa kii keree kii ta wɛ? Te fungɔngɔ fɛɛrɛ te tʼa kan wu mu ge, tee ɲɛ ɲaha wɛ? Kii kakanhaŋaa kii di wa byi wu mu dii wɛ? ");
INSERT INTO myk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ta wu ɲɛ mɛ Mariyama ja mɛnizhe wu wɛ? Go wu ceboronamaa pu wa Yakuba, ni Zhose, ni Zhude, ni Simɔ. Go wu ceboroshaa pu wa naha wèe mu.» Kii keree kii kʼa li pye, pu ya dà Yesu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ga, a Yesu di pu pye: «Kilɛ tudunmɔ ya pɛɛŋɛ taa xuu bɛɛri ni, fo wuyɛ pyaa kulo, ni wu cebooloo niŋɛ ni, ni wuyɛ pyaa puga.» ");
INSERT INTO myk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wu ya ta já kakanhana latii pye wà wɛ, fo na wu keŋɛ yɛ taha yama fɛɛ nigin nigin wa na, na pee cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pu na pye pu ya dà wu na wɛ, a lee di wu fo. Lee kadugo na a Yesu di gari na shɛ sipyii kalaa kabanugo kulogoo ki ni. ");
INSERT INTO myk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A wu wu kalaapiire kɛ ni shuun wu yiri, na pu tun shuun shuun, na fanha kan pu mu jinaa na. ");
INSERT INTO myk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A wu te tuduro te jo pu mu na: «Yi ba gaaŋi, yi ganha bu yaaga katii lɔ wɛ, fo pubiin yɛ. Yi ganha bu yalige lɔ wɛ, kelee kushɛyɛrɛyɛ wɛ, yi ganha bu waripyaa lɔ wɛ! ");
INSERT INTO myk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yʼi tanhaya le, ga yi ganha bu fadeye shuun le wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A wu pu pye: «Yi bu jé puga bɛɛri ni kulo lemu ni, yʼi diin wà fo yi kariduun bu shɛ nɔ. ");
INSERT INTO myk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Xuu wa shɛɛn bu zhe pu da yi tirige wɛ, kelee pu ya yi jomɔ logo wɛ, yi ba fòro yʼi yi tɔɔyɔ gbazhɛnhɛ ɲahara wo wà. Lee na ba bye sɛɛri kaa pu fɛni.» ");
INSERT INTO myk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A kalaapiire tʼi shɛ Kilɛ Kafila wu jo na sipyii pu daburajɛ jo pu jurumu wu na. ");
INSERT INTO myk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pʼa jinaɲɛhɛmɛɛ kɔri yeege sipyiire ti ni, na sìnmɛ tìre yama fɛɛ niɲɛhɛmɛɛ na, na pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Saannaa Hɛrɔdi ya Yesu kaa logo, bani wu mɛgɛ ki bi foro xuu wu bɛɛri ni. Pii bi yu na: «Yohana Batizelipye wʼa ɲɛ na foro xu ni. Lee lʼa wu pye wu na jani kii kakanhaŋaa kii na.» ");
INSERT INTO myk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pii bi yu na: «Kilɛ tudunmɔɔ Eli wu ɲɛ wii.» Pii bɛ di yu na: «Kilɛ tudunmɔ watii wu ɲɛ wii, ba taashiinɛ li wo Kilɛ tudunmɔɔ pu ɲɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ba Hɛrɔdi ya yee logo tuun wemu ni wɛ, na jo: «Yohana wu ɲɛ wii, nɛ pu pye pʼa wemu wo ɲuŋɔ kɔn ge. Wʼa ɲɛ na foro xu ni.» ");
INSERT INTO myk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yi li cɛ na Hɛrɔdi yɛ pyaa kʼa tuduro tun na pu Yohana co, pʼi shɔnhɔyɔ le wu na pu le kaso ni, wu ceborona Filipe shɔ Hɛrɔjasi wuu na. Lee bi wu ta wʼa wee cee wu leŋɛ ");
INSERT INTO myk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bani Yohana bi li shɛɛ wu na na: «Li ya ta saha mu wu ma ceborona shɔ leŋɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A Hɛrɔjasi luu di yìri xuuni Yohana tàan, na giin di wu gbo, ga Hɛrɔdi wuu na wu bi da já wu gbo wɛ. ");
INSERT INTO myk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɛrɔdi bi fyagi Yohana na, bani wʼa bi li cɛ na zɔsaama fɔɔ ni fɛfɛɛrɛ sipya wu ɲɛ wii. A wu wu mara xuuni. Yohana ba yu, wu jomɔ pu ma Hɛrɔdi zɔ wu wuregi, ga lee bɛ na, lʼa bi taan wu ni, wʼa wu jomɔ nuri. ");
INSERT INTO myk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ga Hɛrɔjasi ya pa cazaaŋa ka ta: Hɛrɔdi cazege caŋa ka shi na, saan wʼa yalige pye wu fanhagbɔhɔ ki sipyii, ni wu sɔrɔsii ɲuŋɔfɛɛ, ni Galile sipyigbɔɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A Hɛrɔjasi poro fucɛɛrɛ lʼi jé wà, na xhɔnhɔ. A lee di daan Hɛrɔdi ni wu sipyiyirilee pu ni. Lee wuu na a saan wu fucɛɛrɛ li pye: «Yaaga yaaga kaa li ɲɛ ma na ge, ki kaa jo na mu, di kee kan ma mu.» ");
INSERT INTO myk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A wu gaa na li pye: «Ma bu yaaga yaaga sha nɛ mu, nɛ na kee kan ma mu, ali na saanra te taaga ke bɛ.» ");
INSERT INTO myk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A fucɛɛrɛ lʼi foro, na shɛ li nu wu yege na: «Di ɲaha ɲɛɛri wɛ?» A nu wu li ɲɔ shɔ na: «Yohana Batizelipye ɲuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Taapile ni a fucɛɛrɛ lʼi gari tɔvuyo na saan wu yíri, na shɛ wu pye: «Nɛ funŋɔ ki wa, mʼa Yohana Batizelipye ɲuŋɔ taha yaaga ka na nimɛ, ma kan na mu.» ");
INSERT INTO myk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A lee di saan wu ɲaha tanha fo xuuni. Ga na wu yaha wʼa kàa na xɔ wu sipyiyirilee pu ɲii na, wu ya já li she wɛ. ");
INSERT INTO myk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Taapile ni a wu sɔrɔsi nigin wa tun, na wu shɛ ba ni Yohana ɲuŋmuu ni. A wee sɔrɔsi wu foro kari kaso gbaha ki ni, na shɛ Yohana ɲuŋɔ ki kɔn, ");
INSERT INTO myk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na ba ni ɲuŋɔ ki ni na ki taha yaaga ka na, na pa gan fucɛɛrɛ li mu, a lʼi shɛ ki kan li nu wu mu. ");
INSERT INTO myk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ba Yohana kalaapiire tʼa yee logo wɛ, a tʼi shɛ wu nixhugo ki lɔ na shɛ le faŋa ni. ");
INSERT INTO myk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ayiwa, Yesu bi Tudunmɔɔ piimu tun ge, a pee di guri pa wu yíri. Pʼa sipyii pu kalaa na keree kiimu pye ge, a pʼi ki bɛɛri paari wu mu. ");
INSERT INTO myk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sipyiɲɛhɛmɛɛ pu bi se Yesu yɛ yíri na ma, fo na wu ni wu kalaapiire ti pye tɛrɛ ya já ta pu mu pʼi li wɛ. Lee wuu na wʼa pu pye: «Yi pa wù shɛ sige ki ni xuu wa ni, wù yɛ na, kɔnhɔ yʼi ŋmɔ jɛri.» ");
INSERT INTO myk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A pʼi jé kɔrɔgɔ ka ni, na laha sipyiire ti tàan na kari sipoŋɔ ki xuu wa ni. ");
INSERT INTO myk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ga, a sipyiɲɛhɛmɛɛ di pu ɲa takaraga ni, na pu funyɔ kɔn pu ɲaha tatagaŋa na, na pu tashɛgɛ cɛ. A pʼi ganha na yìri kulogoo ki bɛɛri ni, na fe na gaaŋi tɔɔyɔ na wee xuu wu ni, na shɛ nɔ Yesu ni wu kalaapiire ti ɲaha na. ");
INSERT INTO myk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ba Yesu ya foro kɔrɔgɔ ki ni wɛ, na pee sipyiɲɛhɛmɛɛ pu ɲa, a pu ɲiɲaara di jé wu ni, bani pee sipyii pu bye ba nahavɔɔ baa dubyaa ɲɛ wɛ. A wu ɲɔ kɔn na pu kalaa kaɲɛhɛŋɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ba caŋa kʼa pa digi wɛ, a Yesu kalaapiire tʼi fulo wu na, na wu pye: «Caŋa kʼa xɔ, wèe di ɲɛ sipoŋɔ ni naha. ");
INSERT INTO myk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sipyii pu yaha pʼi shɛ kabanugo buguro ni kulogoo ki ni, kɔnhɔ pʼi shɛ yalige shɔ wà.» ");
INSERT INTO myk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A Yesu di pu pye: «Yiyɛ pyaa ki yalige kan pu mu.» A pʼi wu pye: «Muyɛ pyaa ya cɛ sipyiire tʼa ɲɛhɛ ɲɛhɛgana lemu na ge, ta wari dɛɲɛɛ xhuu shuun yalige bɛ na pii yaa ya?» ");
INSERT INTO myk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A Yesu di pu pye: «Buuri ɲuyɔ juu yʼi wa yee mu wɛ? Yi shɛ yi pɛrɛgi!» Pʼa shɛ yi pɛrɛgi ge, na wu pye: «Buuri ɲuyɔ kaguro ni fyaa shuun.» ");
INSERT INTO myk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Lee kadugo na a Yesu di wu kalaapiire ti pye, na pu sipyiire ti bɛɛri teŋɛ ɲapurege ki ɲuŋɔ ni kuruyo kuruyo. ");
INSERT INTO myk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A pʼi diin korogoo, xhuu nigin nigin (100), kɛlɛɛ kaguro kaguro (50). ");
INSERT INTO myk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Lee kadugo na a Yesu di yee buuri ɲuyɔ kaguro ni fyaa shuun wu lɔ, na ɲaha ke yirige le fugba we ni, na baraga taha Kilɛ na. A wu xhɔ na yee buuri ɲuyɔ yi kɛgi kɛgi na kan wu kalaapiire ti mu, na pu yee yereŋɛ sipyii pu tàan, na fyaa shuun wu bɛ taa taa pu bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A pu bɛɛri di li na din. ");
INSERT INTO myk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Buuri ɲukɛgɛyɛ ni fyaa piimu pʼa kori ge, a pʼi yee saya kemɛ fo na sagaŋaa kɛ ni shuun ɲi. ");
INSERT INTO myk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pʼa namaa kabɔfoŋɔɔ kaguro (5.000) tɔrɔ wee buuri wu livɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ba pʼa xɔ wɛ, taapile ni a Yesu di yi jo waha wu kalaapiire ti mu, na pu jé kɔrɔgɔ ki ni, pʼi gba wu kɔn wu ɲaha na, pʼa se Bɛtisayida ni, yani wu sipyiire ti yaha ge. ");
INSERT INTO myk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ba wʼa pu yaha wɛ, na dugi kari faaboboŋɔ ka na, na shɛ Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Piige kʼa pa wɔ, kɔrɔgɔ kʼi ɲɛ gba lɔhɔ ki niŋɛ ni, Yesu di ɲɛ wu yɛ ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A wu wu kalaapiire ti ɲa tʼa kanha kabiinŋɛ ki fɛni, bani kafɛɛgɛ ki bi jirini pu na. Ba xhupee mɛhɛɛ suduun ya nɔ wɛ, a Yesu di ganha na ɲaari lɔhɔ ki ɲuŋɔ ni na se wu kalaapiire ti yíri. Wu bi giin di doro pu tàan. ");
INSERT INTO myk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba pʼa wu ɲa wu na ɲaari lɔhɔ ki ɲuŋɔ ni wɛ, na ganha na giin na yafugunɔ li, na wá na xhuulo xuuni. ");
INSERT INTO myk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bani pu bɛɛri pu bi wu ɲaa. A pu jaalaa di yìri. Taapile ni a Yesu di jo ni pu ni, na pu pye: «Yi yi logoo ki waha, nɛ wu wa, yi ganha bu da vya wɛ!» ");
INSERT INTO myk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lee kadugo na a wu jé fara pu na kɔrɔgɔ ki ni, a kafɛɛgɛ kʼi yere. A lʼi bye kakanhana fo xuuni wu kalaapiire ti mu. ");
INSERT INTO myk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bani kakanhana lemu lʼa pye buuri ɲuyɔ yi shizhaa na ge, pu ya lee cɛ ta wɛ, pu fungɔnyɔ yi bi tɔ. ");
INSERT INTO myk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A Yesu ni wu kalaapiire tʼi gba wu kɔn, na nɔ Zhɛnɛzarɛti fiige ki ɲiŋɛ ki na, na pu kɔrɔgɔ ki pɔ wà koɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pʼa foro yɛ kɔrɔgɔ ki ni, taapile ni a sipyii pʼi Yesu cɛ. ");
INSERT INTO myk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A pʼi kee fiige ki bɛɛri paa. Pu bu logo na wu ɲɛ xuu bɛɛri ni, pʼa ganha na yama fɛɛ ni pu yasinnɛyɛ tugoo na se wà ke wu yíri. ");
INSERT INTO myk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Xuu bɛɛri ni Yesu ya shɛ ge: kugbɔhɔɔ la, kupiire la, sige buguro la, sipyii pu bi ma ni yama fɛɛ pu ni caanya yi na, na wu ɲɛɛri na wu yere pʼi gbɔn wu fadegeŋɛ ke yɛ na. Sipyii piimu bɛɛri pʼa bi gbɔɔn kee na ge, pee bɛɛri bi cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farizhɛɛn ni saliya karamɔgɔlɔɔ pii ya pa ba na yìri Zheruzalɛmu ni, na ba binnɛ Yesu tàan. ");
INSERT INTO myk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A pʼi li sɛɛri na wu wo kalaapiire ta tʼa li ni kenɔrɔyɔ ni, lee kɔri ɲɛ pu ya pu keye je wɛ. ");
INSERT INTO myk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farizhɛɛn ni Yawutuu pusamaa kunni bi li ni pu ya pu keye je xuuni, na bɛ ni pu sefɛlɛɛ pu wo kalɛgɛɛ ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pu bu guri pa na yìri caan na, pu ya li wuu baa wɛ. Pu bi kalɛgɛɛ niɲɛhɛŋɛɛ kii bɛ pyi sanha, ma na jo cɛɛgbuu jegana, ni shɔɔ, ni daɲaa yagbegeye jegana. ");
INSERT INTO myk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A Farizhɛɛn ni saliya karamɔgɔlɔɔ pʼi Yesu yege na: «Ɲaha na mu wo kalaapiire tʼi ya wèe sefɛlɛɛ pu wo kalɛgɛɛ ki koo ɲaari wɛ, fo na tɛrɛ na li ni pu kenɔrɔyɔ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A Yesu di pu pye: «Ezayi ya kapaŋaa kiimu jo yee shuun shuun jovɛɛ pii shizhaa na ge, kʼa saha fo xuuni. Wʼa li ka na: ‹Ɲɔyɔ yɛ ni pii sipyii pii ya nɛ pɛlɛ, ga pu zɔlɔɔ dʼa lii nɛ na fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tawaga ni pʼa nɛ pɛlɛ, pu wo kalaa wʼi ɲɛ sipyii wo ɲɔmɛhɛɛ yɛ.› ");
INSERT INTO myk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yee wa Kilɛ ɲɔmɛhɛɛ yɛri, na sipyii wo kalɛgɛɛ pyi.» ");
INSERT INTO myk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A Yesu di pu pye sanha: «Le shegana le na yee wa Kilɛ wo ɲɔmɛhɛɛ ki shege, kɔnhɔ yi da yi tii kalɛgɛɛ pyi. ");
INSERT INTO myk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kilɛ tudunmɔɔ Musa ya jo: ‹Ta ma to, ni ma nu pɛlɛ.› Na jo sanha: ‹Wa bu joguumɔ jo ni wu to, kelee ni wu nu ni, na weefɔɔ ya yaa na wu gbo.› ");
INSERT INTO myk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ga yee kunni wa sipyii pu kalaa na sipya bɛɛri wʼa wu to kelee wu nu pye na: ‹Nɛ bi da já na naafuu wemu taga mu tɛgɛ ge, wee ɲɛ Kɔriban.› (Lee kɔri ɲɛ wee ya kan xɔ Kilɛ mu.) ");
INSERT INTO myk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yee da ga weefɔɔ yaha wu wu to ni wu nu wu tɛgɛ nige wɛ. ");
INSERT INTO myk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lee funŋɔ ni yee ya Kilɛ jomɔ pu pye ɲuŋɔ baa ni yi wo kalɛgɛɛ ki ni. Yee wa kii shi keree niɲɛhɛŋɛɛ pyi.» ");
INSERT INTO myk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A Yesu di sipyiire ti yiri sanha, na pu pye: «Yi bɛɛri pu niwegee shan, yʼi ye logo! ");
INSERT INTO myk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yaaga yaaga kʼa jin sipya ɲɔ ni ge, kee da já wu nɔrɔgɔ wɛ. Ga lemu lʼa fòro sipya zɔ we ni ge, lee lʼa wu nɔrɔgɔ. ");
INSERT INTO myk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wemu na logo ge, wu logo dɛ!» ");
INSERT INTO myk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ba Yesu ya laha sipyii pu tàan na jé puga wɛ, a wu kalaapiire tʼi wu yege lee talenɛ li kɔri na. ");
INSERT INTO myk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A wu pu pye: «Yee bɛ, yee sanha fungɔnyɔ ta-ɛ ya? Ta yee ya li cɛ nago yaaga yaaga kʼa jin sipya ɲɔ ni ge, kee da já wu nɔrɔgɔ-ɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bani kee ya jin wu zɔ ni wɛ. Ga wu yacɛrɛ le ni kee ma jé. Lee kadugo na na ba foro yaara tashɛgɛ ke ni.» (Pee jomɔ pe funŋɔ ni Yesu ya li shɛ na yalige bɛɛri ki ɲɛ fɛɛfɛɛ.) ");
INSERT INTO myk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A Yesu di jo sanha na: «Le lʼa fòro sipya funŋɔ ni ge, lee lʼa ma nɔrɔgɔ. ");
INSERT INTO myk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sipya funŋɔ, lee kɔri ɲɛ wu zɔ we. Fungɔnkuuyo ye bɛɛri wa fòro wà, ni ceshaara ni namazhaara, ni nagaara, ni sipyigbuu, ");
INSERT INTO myk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ni dɔdɔɔrɔ, ni ɲɛgbɔɔ, ni kuumɔ, ni nafaanra, ni popama, ni ɲɛpɛɛn, ni mɛkyɛɛgɛrɛ, ni na mayɛ shɛɛ, ni fungɔngɔ baara. ");
INSERT INTO myk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kii kakuuŋɔɔ kii bɛɛri wa fòro sipya funŋɔ ni, kee kʼa sipya nɔrɔgɔ bɛ.» ");
INSERT INTO myk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lee kadugo na a Yesu di yìri kari Fenisi fiige ki ni Tiiri kulo li kabanugo na, na shɛ jé puga ka ni. Wu funŋɔ bye sipya bɛ wu wu sanha cɛ wà wɛ. Ga wu ya já ŋmɔhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A cee wa di wu kaa logo, jina di ɲɛ wee poro fucɛɛrɛ ni. A wee cee wu ba nuguro sin wu fɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wee cee wu bye Yawutu wɛ, Fenisi shɛn wu bye wii. A wu Yesu ɲɛɛri na wu jina wu kɔri yeege wu poro fucɛɛrɛ li ni. ");
INSERT INTO myk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ga, a Yesu di talenɛ la jo wee cee wu mu na: «Yere nɔhɔpiire tʼi fɛnhɛ li, tʼi din. Bani li ya ta saha pu nɔhɔpiire yalige lɔ wá pobiire mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A cee wu jo: «Yee wa can Kafɔɔ. Ga tabali wu nɔhɔ wo pobiire ti wa nɔhɔpiire ti yaliɲahara ti li.» ");
INSERT INTO myk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lee wuu na a Yesu di wu pye: «Pe jomɔ pe wuu na, kuri mʼa se puga! Jina wʼa foro ma poro fucɛɛrɛ li ni.» ");
INSERT INTO myk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A wu guri kari puga, na shɛ porofɔɔ wu nijuuŋɔ ta yasinnɛgɛ ki na. Jina wu bi foro wu ni. ");
INSERT INTO myk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ya pa foro Tiiri ni, na doro Sidɔn ni, na Dekapoli fiige ki kɔn ɲɛri, na nɔ Galile Gba wu ɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A sipyii pii di ba Yesu mu ni bobo wa ni, na wu ɲɛɛri na wu wu keŋɛ taha wee na. ");
INSERT INTO myk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wee tuun wu ni a Yesu di laha sipyii pu tàan ni wee ná wu yɛ ni, na shɛ wu kabɛhɛɛ le wee ná wu niwegee ni, na ɲɔlɔhɔ tugi, na gbɔn wu ɲile na. ");
INSERT INTO myk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lee kadugo na a Yesu di ɲaha ke yirige le fugba we ni, na ŋmɔgaŋa yeege, na wee ná wu pye: «Efata!» (Lee kɔri ɲɛ «Ɲɔ mugi!») ");
INSERT INTO myk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Taapile ni a ná wu niwegee kʼi mugi, a ɲile lʼi laha. A wu ganha na diini na yu. ");
INSERT INTO myk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A Yesu di yi jo waha pu bɛɛri mu na pu ganha yee jo wa shishiin bɛ mu wɛ. Ga ba wʼa yi yu na wari pu mu wɛ, a pʼi ganha na la faraa yi jaaga wu na. ");
INSERT INTO myk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A lʼi bye kakanhana sipyii pu mu xuuni, a pʼi ganha na yu na: «Can na wu kapyegee ki bɛɛri kʼa ɲɔ xuuni. Wʼa boboo bɛ pyi pu na nuri, na yu.» ");
INSERT INTO myk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yee caya yi na sipyiɲɛhɛmɛɛ bi pa binnɛ sanha, ɲɔyalige ka shishiin di ɲɛ pu mu wɛ. A Yesu di wu kalaapiire ti yiri, na pu pye: ");
INSERT INTO myk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Pii sipyii pii ɲiɲaara ti wa nɛ ni, bani niɲaa ɲɛ pu caŋa taanri wogo nɛ yíri naha, ɲɔyalige ka shishiin di ɲɛ nige pu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɛ bu pu yaha kari li baa, pu fanha na zhɛ xhɔ koo na, bani pii tayiriye yʼa lii pu ni xuuni.» ");
INSERT INTO myk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A wu kalaapiire tʼi wu pye: «Yalige na da mii di pii ɲɔ sha naha ke sipoŋɔ ke ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A Yesu di pu yege na: «Buuri ɲuyɔ juu yi wa yee mu wɛ?» A pʼi wu ɲɔ shɔ na: «Buuri ɲuyɔ gbarashuun.» ");
INSERT INTO myk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A wu sipyiire ti pye na pu tiin ɲiŋɛ ki na. A wu yee buuri ɲuyɔ gbarashuun wu lɔ, na baraga taha Kilɛ na, na yi kɛgi kɛgi na kan wu kalaapiire ti mu, na pu yee taa taa sipyii pu na. A kalaapiire tʼi yee taa taa sipyii pu na. ");
INSERT INTO myk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Fyagaa kii bɛ bye pu mu sanha, a Yesu di baraga taha Kilɛ na kee bɛ wuu na, na yi jo wu kalaapiire ti mu na pu kee bɛ taa taa pu na. ");
INSERT INTO myk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A sipyiire tʼi li na din. A kalaapiire tʼi sagaŋaa gbarashuun ɲi buuri ɲukoroyo yi saya na. ");
INSERT INTO myk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pee yalilimɛɛ pʼa bi sipyii kabɔfoŋɔɔ shishɛɛrɛ (4.000) xɔ. Lee kadugo na a Yesu di pu yaha kari. ");
INSERT INTO myk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Taapile ni a wu ni wu kalaapiire tʼi jé kɔrɔgɔ ka ni na kari Dalamanuta fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ba pʼa nɔ wà wɛ, a Farizhɛɛn di ba nɔ, na nakaara ɲɔ kɔn ni Yesu ni. A pʼi Yesu pye na wu ɲaha shɛshɛɛrɛ kakanhana la pye shɛ pee na, lemu ya yìri fugba we ni ge. Pʼa yee jo, kɔnhɔ pʼi wu taanna wii. ");
INSERT INTO myk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A Yesu di ŋmɔgaŋa yeege xuuni, na jo: «Ɲaha na niɲaa sipyii di ɲaha shɛshɛɛrɛ kakanhana shaa wɛ? Can na nʼa da yi jo yi mu, ɲaha shɛshɛɛrɛ kakanhana la shishiin da zhɛɛ pu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Lee kadugo na a wu laha pu tàan, na jé kɔrɔgɔ ki ni, na gari sanha gba wu kadugo. ");
INSERT INTO myk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kalaapiire ti funŋɔ bi wɔ, ti ya ta buuri lɔ wɛ, buuri bɛ di bye pu mu kɔrɔgɔ ki ni wɛ, fo buuri ɲuŋɔ nigin yɛ. ");
INSERT INTO myk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A Yesu di yi jo waha wu kalaapiire ti mu na: «Yʼa yiyɛ kasɛri Farizhɛɛn wo buuri shizhɛnhɛrɛ te, ni Hɛrɔdi wuuro te na dɛ!» ");
INSERT INTO myk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A pʼi puyɛ pye na: «Wʼa ye yu, bani buuri ɲɛ wèe mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yemu pu bi yu ge, a Yesu di yee cɛ na jo: «Ɲaha na yee di yu na buuri ɲɛ yee mu-i wɛ? Yee sanha sii ye ɲaha cɛ nimɛ bɛ-ɛ ya? Yee funyɔ yʼa tɔ gɛ? ");
INSERT INTO myk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɲìi ɲɛ yee mu; yʼi wa ɲaa-i gɛ? Niwegee ɲɛ yee mu; yʼi wa nuri-i gɛ? Yee funyɔ ya dun kaa na-ɛ gɛ? ");
INSERT INTO myk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɛ buuri ɲuyɔ kaguro wu kɛgi kɛgi, na kan sipyii kabɔfoŋɔɔ kaguro (5.000) wu mu tuun wemu ni ge, sagaŋaa juu yee dʼa ɲi yee buuri ɲukoroyo yi saya na wɛ?» A pʼi wu ɲɔ shɔ na: «Kɛ ni shuun.» ");
INSERT INTO myk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Nɛ buuri ɲuyɔ gbarashuun wu kɛgi kɛgi, na kan sipyii kabɔfoŋɔɔ shishɛɛrɛ (4.000) wu mu tuun wemu ni ge, sagaŋaa juu yee dʼa ɲi yee buuri ɲukoroyo yi saya na wɛ?» A pʼi wu ɲɔ shɔ na: «Gbarashuun.» ");
INSERT INTO myk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A Yesu di pu pye: «Yee di sanha sii yi ɲaha cɛ nimɛ bɛ-ɛ gɛ?» ");
INSERT INTO myk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba pʼa nɔ Bɛtisayida ni wɛ, wee xuu wu ni a sipyii pii di ba Yesu mu ni fyɛn wa ni, na wu ɲɛɛri na wu kpɔn wu na. ");
INSERT INTO myk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A Yesu di fyɛn wu co wu keŋɛ na, na gari ni wu ni kanha ki kadugo, na shɛ ɲɔlɔhɔ le wee ná wu ɲìi ni, na wu keŋɛ taha wu na, na wu yege na: «Mu wa yaaga ɲaa ya?» ");
INSERT INTO myk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A fyɛn wu wu ɲaha yirige na jo: «Nɛ wʼa sipyii pu ɲaa ba tiire wa wɛ; ga pʼi ɲaari.» ");
INSERT INTO myk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A Yesu di wu keye taha sanha wee ná wu ɲìi na. A wu wii xuuni, na juuŋɔ, na yaŋmuyɔ yi bɛɛri ɲa shɔɔnri. ");
INSERT INTO myk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A Yesu di wu yaha kari puga, na wu pye: «Ma ganha jé kulo li ni wɛ!» ");
INSERT INTO myk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ni wu kalaapiire tʼa pa gaaŋi Sezare Filipe tàan kulogoo ki ni. Na pu yaha koo na, a Yesu di wu kalaapiire ti yege na: «Sipyii pu wa yu na jɔgɔ nɛ ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A pʼi wu ɲɔ shɔ na: «Pii wa yu na Yohana Batizelipye, pii di yu na Kilɛ tudunmɔɔ Eli, pii bɛ di yu sanha na Kilɛ tudunmɔ wa.» ");
INSERT INTO myk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A Yesu di pu yege na: «Ga yee do, yeeyɛ pyaa ki mu nɛ di ɲɛ jɔgɔ wɛ?» A Pyɛɛri di wu pye: «Kirisa mu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A Yesu di yi jo waha pu mu na pu ganha yee jo wa shishiin bɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lee kadugo na a Yesu di kalaapiire ti ɲɔ kɔn na galaa, na yi jo pu mu na: «Li waha lʼi waha, fo Sipya Ja wu bu ganha xuuni. Nɔhɔlɛɛ, ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ na ba zhe wu ni. Pu na ba wu gbo; cabyaa taanri bu doro wu na ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A wu yi fiinŋɛ jo pu mu. A Pyɛɛri di gari ni wu ni kabanugo, na shɛ ɲɔ kɔn na yu ni wu ni. ");
INSERT INTO myk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ga, a Yesu di ŋmahana ɲɛri, na wu kalaapiire ti wii, na din Pyɛɛri na na jo: «Toro laha na tàan, mu Shitaanni we! Bani mu fungɔngɔ ɲɛ Kilɛ keree na wɛ, fo sipyii wogoo.» ");
INSERT INTO myk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lee kadugo na a Yesu di sipyii pee ni wu kalaapiire ti yiri, na pu pye: «Wa funŋɔ bi ɲɛ wu binnɛ ni na ni, wu she wuyɛ ni, wu wu korikoritige ki lɔ taha na fɛni. ");
INSERT INTO myk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bani sipya we wʼa giin wu wuyɛ pile munaa ɲuŋɔ wolo niɲaa ge, wee na ba buun wu munaa ni ɲiga na. Ga we wʼa bɔnri wu munaa ni niɲaa nɛ ni Jozaama pu wuu na ge, wee wu da ba wu munaa ɲuŋɔ wolo ɲiga na. ");
INSERT INTO myk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lʼa ɲaha ɲɔ sipya na wu koŋɔ yaŋmuyɔ bɛɛri ta, wu ba buun wuyɛ pile munaa ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yaaga kekɛ sipya di da já daga wu munaa ɲuŋɔ wolo wɛ? ");
INSERT INTO myk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Niɲaa wo sipyii pii ɲɛ jurumupyii, pʼi ya tii Kilɛ ɲaha tàan wɛ. Lee wuu na sipyaa sipya wʼa shiige le wuyɛ ni, na bye wu ya nɛ ni na jomɔ pu kaa yu sipyii mu-i ge, Sipya Ja wu bɛ na ba shiige le wuyɛ ni weefɔɔ shizhaa na, wu ba ba wu To Kilɛ wu wo nɔɔrɔ wu ni tuun wemu ni, ni wu fɛfɛɛrɛ mɛlɛkɛɛ pu ni.» ");
INSERT INTO myk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A Yesu di yi jo pu mu sanha na: «Can na nʼa da yi jo yi mu, sipyii pii pu wa naha ge, pii wa da xhuu pu ni bada na ta pu ya Kilɛ wo saanra te ɲa tapaga ni, ni fanha ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lee kadugo na ba cabyaa gbaara ya toro wɛ, a Yesu di gari ni Pyɛɛri, ni Yakuba, ni Yohana ni faabobotɔɔngɔ ka fugba ni pu yɛ na. A wu ɲɛwiinɛ lʼi shɛ ɲɛri pu ɲii na. ");
INSERT INTO myk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A wu fàya yʼi ganha na ɲí, na fiinŋɛ fiinŋɛgana la na, wa shishiin ɲɛ ɲiŋɛ na wemu na já yaaga fiinŋɛ di mu xɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A pʼi Eli ni Musa ɲa wu na yu ni Yesu ni. ");
INSERT INTO myk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lee na a Pyɛɛri di Yesu pye: «Wù Karamɔgɔ, wèe bu gori naha, lee ya ɲɔ xuuni dɛ. Wù buguloo taanri yereŋɛ, mu wo nigin, Musa wo nigin, Eli wo nigin.» ");
INSERT INTO myk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ye wu bi yaa wu jo ge, wu ya yee cɛ wɛ, bani pu bi fya xuuni. ");
INSERT INTO myk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A ɲahaŋa ka di ba pu tɔ, a mujuu la di foro kee ɲahaŋa ki ni na: «Nɛ ɲidaan Ja wu ɲɛ we. Wu kaa lʼa dan nɛ ni. Yʼa wu nijoyo nuri!» ");
INSERT INTO myk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taapile ni a pʼi pu tàan wu wii, ga pu ya sipya watii ɲa nige wɛ, fo Yesu yɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba pʼa diri faaboboŋɔ ki na wɛ, a Yesu di yi jo waha pu mu na kaa lemu pʼa ɲa ge, na pu ganha bu lee ɲaha jo sipya wa shishiin bɛ mu wɛ, fo Sipya Ja wu ba ɲɛ na foro xu ni tuun wemu ni. ");
INSERT INTO myk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A pee jomɔ pe di gori pu funyɔ ni. A pʼi puyɛ yege na: «Sipya Ja wu na ɲɛ na foro xu ni, lee kɔri ɲɛ dii wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A pʼi wu yege na: «Ɲaha na saliya karamɔgɔlɔɔ pʼi yu na Eli wʼa yaa na fɛnhɛ pa wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A wu pu ɲɔ shɔ na: «Uun, Eli wʼa yaa na fɛnhɛ pa, na ba keree ki bɛɛri gbegelevonɔ gbegele. Ga ɲaha na lʼa ka na Sipya Ja wu na ba ganha xuuni wɛ, na pu na ba zhe wu ni wɛ? ");
INSERT INTO myk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ga nʼa da yi jo yi mu, Eli ya pa xɔ, a sipyii pʼi wu pye pu ɲidaan pyegana na ma na jo ba lʼa ka wu shizhaa na wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba pʼa pa jé kalaapiire tisara ni wɛ, na sipyiɲɛhɛmɛɛ ta pʼa pu maha, saliya karamɔgɔlɔɔ pʼi ɲɛ na nakaara pyi ni kalaapiire ti ni. ");
INSERT INTO myk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sipyiire tʼa Yesu ɲa tuun wemu ni ge, a lʼi bye kakanhana pu mu. A pʼi baa kari, na shɛ wu shaari. ");
INSERT INTO myk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A Yesu di wu kalaapiire ti yege na: «Ɲaha wuu na yi wa nakaara pyi ni pu ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A ná wa di wu ɲɔ shɔ sipyiire ti tɛ ni na jo: «Wù Karamɔgɔ, nʼa pa ma mu ni na ja ni, bani jina bobo wu wa wu ni. ");
INSERT INTO myk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jina wu bu wu co xuu xuu ni, wʼa wu shan ɲiŋɛ na. Kakaya na ganha na fòro pya wu ɲɔ ni, wʼa ganha na ganhaa kii kuri, na waha. Nɛ yi jo ma kalaapiire ti mu, jo pu jina wu kɔri yeege wu ni, ga pʼi ya já wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A Yesu di jo: «Ee! Yee kunni ɲɛ nʼa daa baa fɛɛ! Nɛ na gori yaha naha ni yee ni fo tuun wekɛ wɛ? Nɛ na yee keree xu, fo tuun wekɛ ni wɛ? Pa ni ma pya wu ni!» ");
INSERT INTO myk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A pʼi gari ni wu ni wu yíri. Ba pya wʼa Yesu ɲa wɛ, taapile ni a jina wu wu ɲahara xuuni, a wu do ɲiŋɛ na, na gologolo. A kakaya di ganha na fòro wu ɲɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A Yesu di pya wu to wu yege na: «Fo tuun wekɛ ni le ya wu ta wɛ?» A wu wu ɲɔ shɔ na: «Fo wu nɔhɔpiire tuun ni. ");
INSERT INTO myk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tɛɛgɛɛ niɲɛhɛŋɛɛ ni jina wu ma wu shan na ni, ni lɔhɔ ni, kɔnhɔ wu xhu. Ma bi jani yaaga na, ɲuŋɔ ɲaari wù na, mʼa wù tɛgɛ!» ");
INSERT INTO myk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A Yesu di wu pye: «Ma bi jani! Keree bɛɛri kʼa já pye nʼa daa fɔɔ mu.» ");
INSERT INTO myk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Taapile ni a funana li to wu xhuulo na: «Nɛ dà ma na, pa na tɛgɛ mʼa nʼa daa baara ti wolo na funŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu ya li ɲa sipyiire tʼa gburogi na ma wu mu ge, a wu din jina wu na na: «Jina bobo ɲudunnɔ, nɛ wʼa ma pye mu, foro wu ni. Ma ganha jé wu ni nige bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A jina wu xhuulo, na funana li ɲahara xuuni, na foro li ni. A lʼi bye ma na jo li nixhugo ki ɲɛ, fo sipyiɲɛhɛmɛɛ bi yu na: «Wʼa xu.» ");
INSERT INTO myk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ga Yesu di funana li keŋɛ ki co, na li yirige. A lʼi yìri, na yere. ");
INSERT INTO myk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ba Yesu ya pa jé puga wɛ, na wu ni kalaapiire ti yaha pu yɛ na. A pʼi wu yege na: «Ɲaha na wèe di ya já we jina we kɔri yeege pya wu ni-i wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A Yesu di pu ɲɔ shɔ na: «Ke jina tuugo ke ya fòro forogana la shishiin na ni Kilɛ-ɲɛrɛgɛ bɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A pʼi yìri wà, na Galile fiige ki ja toro na gaaŋi. Yesu funŋɔ bye pu wu sanha cɛ wɛ, ");
INSERT INTO myk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bani wu bi wu kalaapiire ti kalaa. A wu pu pye: «Pu na ba Sipya Ja wu le sipyii keye ni. Pu na ba wu gbo, cabyaa taanri bu doro, wʼa ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ga pu bi pee jomɔ pu kɔri cɛ wɛ, na fya pu ya já wu yege pee keree na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A pʼi nɔ Kapɛrinɔmɔ ni. Yesu nijege na puga ki ni, a wu wu kalaapiire ti yege na: «Nakaara tekɛ na yi bye koo li na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga, a pʼi cari, bani pu bi puyɛ yegee koo li na na wekɛ wu ɲɛ pee bɛɛri wo ɲahagbaa fɔɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wee tuun wu ni a Yesu di diin, na wu kalaapiire kɛ ni shuun wu yiri, na pu pye: «Wa funŋɔ bi ɲɛ na pye ɲahagbaa fɔɔ, wʼa yaa na pye pu bɛɛri kadugo yíri wo, ni pu bɛɛri kapyebye.» ");
INSERT INTO myk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A wu nɔhɔcɛɛrɛ la lɔ, na lee yereŋɛ pu niŋɛ ni, na li co wu keye ni, na yi jo pu mu na: ");
INSERT INTO myk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Sipyaa sipya wʼa le nɔhɔcɛɛrɛ le la shi co xuuni nɛ wuu na ge, nɛ wʼa co xuuni. We wʼa nɛ co xuuni ge, wee ya nɛ co xuuni wɛ, ga nɛ tunvɔɔ we wʼa co xuuni.» ");
INSERT INTO myk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A Yohana di Yesu pye: «Wù Karamɔgɔ, wèe ya ná wa ɲa, wu na jinaa kɔri na yeege sipyii ni mu mɛgɛ na. A wèe di yi jo wu mu jo wu ganha ba lee pyi wɛ, bani wu ɲɛ wèe wa wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A Yesu di wu pye: «Yi ganha bu wu ɲaha kɔn wɛ, bani sipya wa shishiin da já kakanhana pye nɛ mɛgɛ na, lee kadugo na mʼa wakaraa mʼa nɛ joguumɔ yu wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bani sipya wemu ɲɛ wèe pɛn wɛ, wèe ɲii wu ɲɛ wii. ");
INSERT INTO myk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Can na nʼa da yi jo yi mu, sipyaa sipya wʼa cɛɛgbuu ɲii lɔhɔ kan yi mu yʼa gba na bani yi ɲɛ Kirisa wuu ge, weefɔɔ da ga fɔ lee wo kuduun ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Te nɔhɔpiire te tʼa dà nɛ na ge, sipyaa sipya wʼa le la ɲuŋɔ kyɛɛgi ge, li bi da bɔrɔ weefɔɔ mu, na faatabaaga pɔ wu katige ni, na wu wá suumɔ lɔhɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ma keŋɛ bi ɲɛ kaɲuŋɔ di ma le jurumu ni, ki kɔn. Ma keŋɛ nigin wo na jé Alijinɛ ni, lee ya pɔrɔ ma mu, ma keye shuun wo wu shɛ yaha Jahanɛmɛ ni nafugibaaga ni.  ");
INSERT INTO myk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wee xuu wu ni, wu fyɛnyɛ ya xhuli wɛ, kee na ki ya furi wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma tɔɔgɔ bi ɲɛ kaɲuŋɔ di ma le jurumu ni, ki kɔn. Ma tɔɔgɔ nigin wo na jé Alijinɛ ni, lee ya pɔrɔ ma mu, ma tɔɔyɔ shuun wo wu wá Jahanɛmɛ ni.  ");
INSERT INTO myk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wee xuu wu ni, wu fyɛnyɛ ya xhuli wɛ, kee na ki ya furi wɛ. ");
INSERT INTO myk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma ɲii bi ɲɛ kaɲuŋɔ di ma le jurumu ni, li wɛhɛlɛ wolo. Ma ɲii nigin wo na jé Kilɛ wo saanra ti ni, lee ya pɔrɔ ma mu, ma ɲìi shuun wo wu wá Jahanɛmɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‹Wee xuu wu ni, wu fyɛnyɛ ya xhuli wɛ, kee na ki ya furi wɛ.› ");
INSERT INTO myk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Bani ba lʼa saha na suumɔ le shiga ni wɛ, mu lʼa saha jurumupyii bɛ pu sorogo na ni. ");
INSERT INTO myk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Suumɔ ya ɲɔ, ga pu tipoomɔ bu foro pu ni, ɲaha ma da daga pu taan sanha wɛ? Suumɔ pu pye yiyɛ pyaa ni, ɲaɲiŋɛ di bye yi tɛ ni.» ");
INSERT INTO myk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A Yesu di yìri wà, na gari Zhude fiige ki ni, ni Zhurudɛn Gba wu kadugo yíri. A sipyiire tʼi ba binnɛ wu tàan sanha. A wu ganha na pu kalaa ma na jo, ba wʼa tee na li pyi pyegana lemu na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A Farizhɛɛn pii di fulo wu na, na wu pɛri. A pʼi wu pye: «Lʼa saha ná wu wu shɔ gbaga xɔ ya?» ");
INSERT INTO myk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A Yesu di pu ɲɔ shɔ na: «Ɲɔmɛɛ lekɛ Musa dʼa jo yee mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A pʼi jo: «Musa ya koro kan wèe mu na wa ba da wu shɔ yaha, na wufɔɔ wu fɛnhɛ gbaxɔɔrɔ sɛmɛ yàa kan wu mu wu na wu yaha.» ");
INSERT INTO myk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A Yesu di pu pye: «Yee niwegee kʼa waha, lee wuu na Musa ya le ɲɔmɛɛ le ka na kan yee mu. ");
INSERT INTO myk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ga fo koŋɔ ki ɲɔkɔɔnrɔ na, Kilɛ ya pu yàa ná ni cee. ");
INSERT INTO myk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Lee wuu na ná na ba wu to, ni wu nu yaha, na nɔrɔ wu shɔ na. ");
INSERT INTO myk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Pu shuun wu na bye ceepuuro nigin. Lee funŋɔ ni pu ɲɛ nige shuun wɛ, ga fo nigin. ");
INSERT INTO myk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ayiwa Kilɛ ya lemu pye nigin ge, sipya ganha bu lee waagi wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ba pʼa jé puga wɛ, a kalaapiire tʼi Yesu yege lee na sanha. ");
INSERT INTO myk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A wu yi jo pu mu na: «Sipyaa sipya wʼa wu shɔ gbaga xɔ, na watii leŋɛ ge, dɔdɔɔrɔ mʼa pye ma ceshiimɛ wu shizhaa na. ");
INSERT INTO myk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wee cogo wu na cee bɛ bu foro wu poo mu, na gbaga je ná watii mu, dɔdɔɔrɔ wʼa pye.» ");
INSERT INTO myk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lee kadugo na sipyii pii ya pa Yesu mu ni nɔhɔpiire ta ni, kɔnhɔ wu gbɔn ti na; ga, a kalaapiire tʼi yogo jo ni pu ni. ");
INSERT INTO myk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ya lee ɲa ge, a wu luu di yìri, a wu wu kalaapiire ti pye: «Yi nɔhɔpiire ti yaha ti da ma na mu, yi ganha ba ti ɲaha kɔɔn wɛ! Bani pee shi tuugo wuuro ti ɲɛ Kilɛ wo saanra te. ");
INSERT INTO myk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Can na nʼa da yi jo yi mu, sipya wemu ya Kilɛ wo saanra ti co ba nɔhɔcɛrɛɛ ɲɛ-ɛ wɛ, wee da ga ba jé ti ni bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lee kadugo na a wu nɔhɔpiire ti lɔ, na wu keye taha ti na, na duba ti mu. ");
INSERT INTO myk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lee kadugo na ba Yesu ya pa koo lɔ na gaaŋi wɛ, a ná wa di baa nɔ, na nuguro sin wu fɛɛ ni, na wu yege na: «Karamɔgɔsaama, ɲaha nɛ yaa na pye, kɔnhɔ di ba ɲìi sicuumɔ nixhɔbaama ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A Yesu di wu pye: «Ɲaha na mʼa na pyi nizaama wɛ? Nizaama wa shishiin wa wɛ, fo Kilɛ yɛ. ");
INSERT INTO myk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mʼa Kilɛ wo ɲɔmɛɛjogoo ki cɛ na: ‹Ma ganha bu sipya gbo wɛ! Ma ganha bu dɔdɔɔrɔ pye wɛ! Ma ganha bu nagaara pye wɛ! Ma ganha bu kafinɛyɛ taha ma sipyiɲii na wɛ! Ma ganha bu wa ŋmahana wɛ! Ma da ma nu ni ma to pɛlɛ!›» ");
INSERT INTO myk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A wee ná wu jo: «Karamɔgɔ, fo na nɔhɔpiire ti tuun wu ni nɛ ɲɔ kɔn na kii koro ɲaari.» ");
INSERT INTO myk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Yesu di wu wii ni taanɲɛɛgɛ ni, na wu pye: «Kaa nigin yɛ lʼa mu kuuŋɔ. Shɛ ma keŋɛ yaŋmuyɔ yi bɛɛri pɛrɛ, mʼa wee wari wu kan la baa fɛɛ mu! Wee tuun wu ni ma na naafuu ta fugba we ni. Lee kadugo tàan mʼa ba daha na fɛni!» ");
INSERT INTO myk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A pee jomɔ pʼi wu ɲaha tanha na gaaŋi, bani naafuugbɔ wu bye wu mu. ");
INSERT INTO myk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A Yesu di wu tàan wu wii, na wu kalaapiire ti pye: «Naafuugbɔ fɔɔ jemɛ pʼa pɛn Kilɛ wo saanra ti ni dɛ!» ");
INSERT INTO myk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A pee jomɔ pʼi bye kakanhana kalaapiire ti mu; ga, a Yesu di pu pye sanha na: «Na nagoo, Kilɛ wo saanra ti jemɛ pʼa pɛn dɛ!» ");
INSERT INTO myk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɲɔhɔŋɔ jemɛ ya taan museni wii ni na toro, naafuugbɔ fɔɔ jé na Kilɛ wo saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A lʼi bye tɛhɛnɛ baa kakanhana kalaapiire ti mu, a pʼi ganha na puyɛ pyi: «Aa! Wee tuun wu ni sipya wekɛ na já pa shɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A Yesu di pu wii, na jo: «Sipyii mu, lee da já bye wɛ, ga li na já bye Kilɛ mu, bani kaa la shishiin ya Kilɛ jani wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A Pyɛɛri di wu pye: «Li wii, wèe ya kahari yaŋmuyɔ bɛɛri ni, na daha mu fɛni.» ");
INSERT INTO myk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A Yesu di wu pye: «Can na nʼa da yi jo yi mu, sipyaa sipya wʼa kahari wu puga ni ge, kelee wu ceboronamaa, kelee wu ceboroshaa, kelee wu nu, kelee wu to, kelee wu nagoo, kelee wu kɛrɛyɛ, nɛ ni Jozaama pe wuu na ge, ");
INSERT INTO myk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","weefɔɔ na ba yee bɛɛri yahaŋaa xhuu nigin (100) ta ke koŋɔ ke na: piyɛyɛ, ni ceboronamaa, ni ceboroshaa, ni nii, ni nagoo, ni kɛrɛyɛ, na kanhama bɛ ta, na ba ɲìi sicuumɔ nixhɔbaama bɛ ta ɲiga na. ");
INSERT INTO myk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ga ɲahagbaa wuu niɲɛhɛmɛɛ na ba bye kadugo yíri wuu, kadugo yíri wuu niɲɛhɛmɛɛ na bye ɲahagbaa wuu.» ");
INSERT INTO myk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Koo na pu bye na gaaŋi Zheruzalɛmu ni, Yesu bye wu kalaapiire ti ɲahagbaa na. Kalaapiire ti hakilee pu bi kyɛɛgi. Sipyii pii pʼa taha pu fɛni ge, pee bi fya. A Yesu di gari sanha ni wu wuu kɛ ni shuun wu yɛ ni. Kaa le li da ba bye wu na ge, a wu lee ɲɔ kɔn na yu pu mu. ");
INSERT INTO myk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A wu pu pye: «Wù wii gaaŋi Zheruzalɛmu ni. Pu na zhɛ Sipya Ja wu le wà saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu keŋɛ ni. Pu na ba wu jaagi na wʼa yaa ni xu ni. Pʼa wu le shi watii keŋɛ ni, wemu ɲɛ Yawutuu shi wɛ. ");
INSERT INTO myk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wee na ba zhɛhɛ wu na, na ɲɔlɔhɔ tugi wu na, na wu kpɔn ni susɔlɔɔ ni, na wu gbo. Caŋa taanri wogo ki na wʼa ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Lee kadugo na Zebede jalaa Yakuba ni Yohana ya pa fulo Yesu na, na yi jo wu mu na: «Wù Karamɔgɔ, kaa le wù da ba ɲɛɛri ma mu ge, wù la ɲɛ mʼa lee pye wù mu.» ");
INSERT INTO myk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A Yesu di pu yege na: «Yi wa giin nɛ lekɛ pye yi mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A pʼi wu ɲɔ shɔ na: «Ma sɔɔ mʼa ɲahagbaa fɛɛrɛ tatiinyɛ yi kan wù mu: nigin wa di diin ma kanige cɛ, wa di diin ma kamɛnɛ cɛ, ma saanra nɔɔrɔ wuuro ti ni.» ");
INSERT INTO myk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga, a Yesu di pu pye: «Kaa lemu yee wa ɲɛɛri ge, yee wa li cɛ wɛ. Kanhama cɛɛgbuu lemu ni nʼa da ba gba ge, yee na já gba lee ni ya? Kelee nɛ na ba batize kanhama ni gbɛrigbɛri wemu ni ge, yee na já batize yee ni ya?» ");
INSERT INTO myk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A pʼi wu pye: «Uun, wèe na já.» A Yesu di pu pye: «Yi na ba gba nɛ wo cɛɛgbuu li ni. Nɛ na ba batize kanhama ni gbɛrigbɛri wemu ni ge, yi na ba batize yee bɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ga na tiin nɛ kanige cɛ, kelee nɛ kamɛnɛ cɛ, nɛ ɲɛ yee tatiinyɛ yi kanvɔɔ wɛ. Piimu kaa na Kilɛ ya yee gbegele ge, pee mu yi da ba gan.» ");
INSERT INTO myk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ba kalaapiire kɛ wu samaa ya yee logo wɛ, a pu logoo di yìri Yakuba ni Yohana tàan. ");
INSERT INTO myk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Lee na a Yesu di pu bɛɛri yiri na jo: «Yʼa li cɛ na shi wemu ɲɛ Yawutuu wɛ, pii pʼa wii ɲuŋɔfɛɛ wee shi wu ɲuŋɔ ni ge, pee ya pu ɲuŋɔfɛɛrɛ pyi wu na, pu sipyigbɔɔ pʼi pu fanha shɛɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ga li da ba bye mu yee tɛ ni wɛ. Yee wa funŋɔ bi ɲɛ wu bye sipyigbɔ, wufɔɔ wu pye pusamaa wo kapyebye. ");
INSERT INTO myk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yee wa funŋɔ bi ɲɛ wu bye ɲahagbaa fɔɔ, wu pye pusamaa bɛɛri wo bulo. ");
INSERT INTO myk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bani Sipya Ja wu ya ta pa kɔnhɔ sipyii di ba kapyeŋɛɛ pyi wu mu wɛ. Ga wʼa pa, wu ba kapyeŋɛɛ pyi sipyii mu, wu wu munaa kan lʼi bye sipyiɲɛhɛmɛɛ wo ɲuwuuro saraa.» ");
INSERT INTO myk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lee kadugo na a pʼi nɔ kulo la ni, lee mɛgɛ ɲɛ na Zheriko. Ba Yesu ni wu kalaapiire te ni sipyiɲɛhɛmɛɛ ya pa foro Zheriko ni wɛ, lee bi fyɛn wa nidɛɛngɛ ta koo li ɲɔ na, wee na saraya ɲɛɛri. Wee bye Timɛ ja Batimɛ. ");
INSERT INTO myk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wʼa logo na Nazarɛti shɛɛn Yesu wʼa wii ge, a wu mujuu wá na: «Dawuda Ja Yesu, ɲuŋɔ ɲaari na na!» ");
INSERT INTO myk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sipyiɲɛhɛmɛɛ ya jo ni wu ni na wu co wuyɛ na, ga, a wu sii la fara mujuu li na na yu: «Dawuda Ja, ɲuŋɔ ɲaari na na!» ");
INSERT INTO myk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A Yesu di yere na jo pu wu yiri. A pʼi fyɛn wu yiri, na wu pye: «Ma hakili wu teŋɛ, yìri! Wʼa ma yiri!» ");
INSERT INTO myk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A wu wu fadeŋɛ wá, na sira yìri, na fulo Yesu na. ");
INSERT INTO myk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A Yesu di wu yege na: «Mu wa giin nɛ lekɛ pye ma mu wɛ?» A fyɛn wu wu ɲɔ shɔ na: «Karamɔgɔ, di da ɲaa!» ");
INSERT INTO myk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A Yesu di wu pye: «Ta se, ma nʼa daa wʼa ma cuuŋɔ.» Taapile ni a wu ganha na ɲaa, na daha Yesu fɛni koo li na. ");
INSERT INTO myk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ba pʼa tɛɛŋɛ Zheruzalɛmu na wɛ, a pʼi nɔ Bɛtɛfajɛ ni Bɛtani shizhaa, Oliviye faaboboŋɔ ki kabanugo ki ni. A Yesu di wu kalaapiire shuun wa tun, ");
INSERT INTO myk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na pu pye: «Yi shɛ yi ɲahagbaa kulo li ni. Yi ba shɛ jin yɛ li ni, yi na kafabige ka nibɔgɔ ta wà, sipya sanha dugi ɲa kemu na wɛ, yʼi kee sanha yi pa naha! ");
INSERT INTO myk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sipya wa bu yi pye: ‹Ɲaha na yee di ke sanhana wɛ?› Yi weefɔɔ pye: ‹Wèe Kafɔɔ wu mago wu wa ki na, nimɛ wʼa da ki kuruŋɔ na pa ma kan.›» ");
INSERT INTO myk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A pʼi gari, na shɛ kafabige ka nibɔgɔ ta kakuutorogo ka ni, na ki sanha. ");
INSERT INTO myk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sipyii pii pu bye wà ge, a pii di pu yege na: «Yee di ke kafabige ke sanhana ɲaha na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A pʼi pu ɲɔ shɔ ba Yesu ya yi jo pu mu wɛ. A pee sipyii pʼi sɔɔ na pʼa gaaŋi ni ki ni. ");
INSERT INTO myk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba pʼa nɔ ni kafabige ki ni Yesu yíri wɛ, na pu fadegbɔyɔ ya taha ki na, a Yesu di dugi ki na. ");
INSERT INTO myk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A sipyiɲɛhɛmɛɛ di pu fadegbɔyɔ pii koo li ni. A pii bɛ di wɛburiye kɔn tɛyɛ ni, na yee pii koo li ni. ");
INSERT INTO myk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pu nigariwuu, pii pʼa ɲaari Yesu ɲahagbaa ni wu kadugo yíri ge, pee bi xhuulo na yu na: «Kilɛ wʼa sɔni! We wʼa ma Kafɔɔ mɛgɛ na ge, wee ɲɛ duba pya!» ");
INSERT INTO myk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","«Wù to Dawuda wo saanra te tʼa ma ge, Kilɛ wu duba ti mu. Masɔŋɔ kʼa byi Kilɛ mu fugba lii lii we ni.» ");
INSERT INTO myk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ba Yesu ya jé Zheruzalɛmu ni wɛ, na gari Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na shɛ ki kabaya yi bɛɛri wii. Lee kadugo na a wu ni wu kalaapiire kɛ ni shuun wu foro kari Bɛtani ni, bani piige ki bi zhaa da wuu. ");
INSERT INTO myk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kee caŋa ki ɲimuguro, pu na foro Bɛtani ni, a xuugo di Yesu ta. ");
INSERT INTO myk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na wu yaha taliige ni a wu nitoodige ka ɲa, wɛrɛ di ɲɛ ki na. A wu shɛ ki wii, wu bu garaa nagoo ta ki na. Ba wʼa nɔ ki na wɛ, wu ya yaaga ɲa wɛ, fo wɛyɛ yɛ. Bani nitoroŋɔ pyeduun bi sanha nɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ayiwa a wu nitoodige ki pye: «Sipya da ga mu pya li nige bada wɛ.» A wu kalaapiire tʼi yee logo. ");
INSERT INTO myk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pʼa nɔ Zheruzalɛmu ni tuun wemu ni ge, a Yesu di jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Sipyii piimu pu bi bɛrɛ ni zhɔ pyi wà ge, a wu ganha na pee kɔri na yeege. A wu wari faavɛɛ pu wo tabalaa pee, ni gbegbe shazhɛɛrɛ pɛrɛvɛɛ pu wo yatiinyɛ yi ɲɛri buri. ");
INSERT INTO myk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wʼa ta sɔɔ yaaga pɛrɛvɔɔ wa shishiin wu toro Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A wu sipyii pu kalaa na: «Ta li ya ka Kilɛ Kafila wu ni wɛ na: ‹Pu na ba nɛ puga ki pyi shi wu bɛɛri wo Kilɛ-ɲɛrɛgɛ puga wɛ?› Ga yee kunni ya ki pye nagaalaa talaraga.» ");
INSERT INTO myk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ba saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ pʼa yee logo wɛ, na ganha na wu shaa di gbo. A pʼi fya wu na, bani wu kalaa wu bi sipyii pu ɲuyɔ co xuuni. ");
INSERT INTO myk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ba yakoŋɔ kʼa nɔ wɛ, a Yesu ni wu kalaapiire tʼi foro kanha ki ni. ");
INSERT INTO myk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kee caŋa ki ɲimuguro ɲisɔɔgɔ ki na, na pu yaha pu na doroo koo li ni, a pʼi kee nitoodige ki ɲa kʼa waha fo ki niyɛ ye. ");
INSERT INTO myk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kaa le lʼa bi pye ge, a Pyɛɛri funŋɔ di do lee na, a wu Yesu pye: «Wù Karamɔgɔ, mʼa nitoodige kemu laŋi ge, kʼa waha!» ");
INSERT INTO myk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A Yesu di pu pye: «Yi dà Kilɛ na! ");
INSERT INTO myk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Can na nʼa da yi jo yi mu, sipyaa sipya wʼa ke faaboboŋɔ ke pye: ‹Yìri laha naha, mʼa shɛ mayɛ wá suumɔ lɔhɔ ni ge.› Nakaara bye tʼi ɲɛ wufɔɔ zɔ wu na wɛ, wu bi dà li na na ye wʼa jo ge, na lee na bye; li na bye wu mu. ");
INSERT INTO myk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lee wuu na nʼa da yi jo yi mu, yi ba yaaga tuugo bɛɛri ɲɛɛri, yi dà li na na yʼa kee ta na xɔ, kee na gan yi mu. ");
INSERT INTO myk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yi bu yere na Kilɛ ɲɛɛri, na wa ta wʼa kakuunɔ la pye yi na, yi lee yafa weefɔɔ mu, kɔnhɔ yi fugba To Kilɛ wu yi bɛ wo kakuuyo yi yafa yi mu. ");
INSERT INTO myk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yi bye yʼi ya pusamaa wo kakuuyo yi yafani pu mu wɛ, yi fugba To Kilɛ wu da ba yi bɛ wo kakuuyo yi yafa yi mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A pʼi gari Zheruzalɛmu ni sanha. Na Yesu yaha wu na ɲaari Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ, ni nɔhɔlɛɛ pʼi fulo wu na, ");
INSERT INTO myk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na wu yege na: «Sefɛɛrɛ tekɛ gbɔɔrɔ ni mu wa kii keree kii pyi wɛ? Jɔgɔ wʼa kee fanha ki kan mu mu na mu wʼa ki pyi wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A Yesu di pu pye: «Nʼa da yee yege kaa nigin wa na, yʼi na ɲɔ shɔ. Wee tuun wu ni, sefɛɛrɛ temu gbɔɔrɔ ni nɛ bɛ ya kii keree kii pyi ge, nɛ bɛ na tee jo yi mu. ");
INSERT INTO myk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jɔgɔ wu dʼa Yohana tun na wʼa batizeli pyi wɛ, Kilɛ laa sipyii? Yi na ɲɔ shɔ.» ");
INSERT INTO myk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A pʼi puyɛ pye: «Wù bu jo: ‹Kilɛ wʼa wu tun›, wu na jo: ‹Wee tuun wu ni ɲaha na yee di ya ta dà wu na-ɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga wù bu nɔhɔ jo: ‹Sipyii pʼa wu tun…›» (Pu bi fyagi sipyii pu na, bani sipyii pu bɛɛri bi Yohana wii can can na Kilɛ tudunmɔ.) ");
INSERT INTO myk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lee na a pʼi Yesu pye: «Wèe ya cɛ wɛ.» A Yesu bɛ di pu pye: «Ayiwa nɛ bɛ ya she, sefɛɛrɛ temu gbɔɔrɔ ni nɛ bɛ ya kii keree kii pyi ge, nɛ bɛ da tee jo yee mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lee kadugo na a Yesu di taleŋɛɛ ɲɔ kɔn na yu pu mu na: «Ná wa wʼa bi ɛrɛzɛn tɛgɛ ka shan, na ki maha ni kasɔrɔgɔ ni. A wʼi wege ka wolo na pye ɛrɛzɛn wu lɔhɔ ki tawologo, na zangaso wa yàa shazhɔn wu kaa na. Lee kadugo na a wu ɛrɛzɛn tiire tɛgɛ ki kaa le ɛrɛzɛn faapyii pii keŋɛ ni, na gari fiige katii ni. ");
INSERT INTO myk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ba ɛrɛzɛn wʼa pa lɛ wɛ, a wu kapyebye wa tun pee ɛrɛzɛn faapyii pu mu, na wu shɛ ɛrɛzɛn nilɛ wu shɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga, a pʼi kapyebye wu co, na wu kpɔn, na wu kewaya wo yaha kari. ");
INSERT INTO myk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lee kadugo na a tɛgɛ ki fɔɔ wu kapyebye watii tun kari. A pʼi wee ɲuŋɔ bana, na wu cogana kolo. ");
INSERT INTO myk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A wu nɔhɔ kapyebye wa bɛ tun kari sanha. A pʼi wee gbo. Lee kadugo na a wu kapyebyii niɲɛhɛmɛɛ pii bɛ tun. A pʼi pii kpɔn, na pii gbo. ");
INSERT INTO myk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Ja nigin yɛ di bye tɛgɛ ki fɔɔ wu mu, wee kaa bi dan wu ni xuuni. A wu wee tun pu mu pu bɛɛri kadugo yíri, na jo: ‹Nɛ ja we kunni pu na zhɛ gbɔɔrɔ taha wee na.› ");
INSERT INTO myk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ga, a ɛrɛzɛn faapyii pʼi puyɛ pye na: ‹Cɛn wu lɔvɔɔ wʼa we. Yi pa wù wu gbo, cɛn wu na bye wù wo.› ");
INSERT INTO myk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A pʼi jafɔɔ wu co na wu gbo, na wu wá tɛgɛ ki kadugo yíri. ");
INSERT INTO myk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Wee tuun wu ni tɛgɛ ki kafɔɔ wu da ba ɲaha pye wɛ? Wu na ba ba, na pee ɛrɛzɛn faapyii pu gbo, na ɛrɛzɛn tɛgɛ ki kaa le piitiilee keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ta yee ya le kalaa Kilɛ Kafila wu ni wɛ? na: ‹Puyirilee pʼa faakagereŋɛ kemu she ge, kee kʼa pye puga ki gunŋmii li faakagereŋɛ ki nijeŋɛ ke. ");
INSERT INTO myk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Li wii Kafɔɔ wʼa lee pye, kakanhana li wa lii wù ɲaha tàan.›» ");
INSERT INTO myk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A Yawutuu ɲuŋɔfɛɛ pʼi ganha na cogana shaa Yesu na, bani pʼa li cɛ na pee na Yesu ya talenɛ li jo wà. Ga, a pʼi fya sipyiire ti na, wee tuun wu ni a pʼi wu yaha wà, na gari. ");
INSERT INTO myk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lee kadugo na a pʼi Farizhɛɛn pii ni Hɛrɔdi wo sipyii pii tun Yesu mu, kɔnhɔ pʼi wu co wuyɛ pyaa ɲɔ jomɔ fɛni. ");
INSERT INTO myk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A pʼi ba na wu pye: «Wù Karamɔgɔ, wèe ya li cɛ na jo can fɔɔ mu ɲɛ. Mu ya fyagi sipya wa shishiin na wɛ, bani sipyii pu bɛɛri pu ɲɛ nigin mu mu. Mʼa sipyii pu fiinŋɛ na galaa bɛ Kilɛ koro li ni. Ayiwa lʼa saha pʼa munaa pɛrɛmɛ kaan Oromɛ saannaa Sezari mu laa, li ya saha wɛ? Wʼà yaa na pu kaan, laa wù ya yaa na pu kaan wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ga, a Yesu di pu shuun shuun juuro ti cɛ na pu pye: «Ɲaha na yʼi na ɲɔ yegee wɛ? Yi pa ni wari dɛɲɛ nigin wa ni, di wu wii.» ");
INSERT INTO myk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A pʼi nigin wa shɛ wu na. A Yesu di pu pye: «Jɔgɔ wo jaa ni wu kama pu wa we na wɛ?» A pʼi jo: «Oromɛ saannaa Sezari.» ");
INSERT INTO myk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wee tuun wu ni a Yesu di pu pye: «Yʼa Sezari wuu li kaan Sezari mu, yi da Kilɛ bɛ wuu li kaan Kilɛ bɛ mu.» A wu keree di pu ɲaha wɔ fo xuuni. ");
INSERT INTO myk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lee kadugo na, ɲuŋɔfɛɛ pii bye wà, pʼi ɲɛ Yawutuu, Sadushɛɛn pu bye pii. Pee bi yu na xuɲɛnɛ da ba bye ɲiga na wɛ. A pii di ba shɛ Yesu yíri, na shɛ wu pye: ");
INSERT INTO myk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Karamɔgɔ, Kilɛ tudunmɔɔ Musa ya le ɲɔmɛɛ le ka na kan wèe mu na: ‹Ná wa wo ceborona bu xhu, na ta wu ya pya ta wu shɔ na wɛ, na wu wee naxhugoshɔ wu lɔ, kɔnhɔ wu nagoo ta di yaha wee ná wu nixhugo ki mu.› ");
INSERT INTO myk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lee ya bi ceboronamaa gbarashuun wa ta wà. A nizhiimɛ wu cee leŋɛ, na xhu wu ya pya ta wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A shuun wo wu wee cee wu ninumɔ lɔ, na xhu wu ya pya ta wɛ. A taanri wo wu bɛ di bye mu. ");
INSERT INTO myk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A pu gbarashuun wu bɛɛri di wee cee wu leŋɛ toro, a pu bɛɛri di xhu wa shishiin ya pya ta wu na wɛ. Lee kadugo na a cee wu bɛ di xhu. ");
INSERT INTO myk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xuu pu caɲɛŋɛ ke, wee cee wʼi da ba bye pu shɛn nigin wekɛ wo wɛ? Bani pu gbarashuun wu bɛɛri ya wu leŋɛ toro.» ");
INSERT INTO myk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A Yesu di pu pye: «Le bɛ li wa yee piinŋɛ ki kaɲuŋɔ wɛ? Na jo le lʼa ka Kilɛ Kafila wu ni ge, yee wa lee cɛ wɛ, yʼi wa Kilɛ wo sefɛɛrɛ ti bɛ cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Xuu pu ba ɲɛ, sipyii wa da cèe leŋɛ, kelee na gbaya je wɛ. Ga pu na ba bye ba fugba mɛlɛkɛɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Xuɲɛnɛ li wo shizhaa na, xuu wemu ni na ki wo tire li kaa ya yu Kilɛ tudunmɔɔ Musa wo Kitabu wu ni ge, ta yee ya yee kalaa wɛ? na: ‹Nɛ ɲɛ Ibirayima wo Kilɛ, ni Ishaaga wo Kilɛ, ni Yakuba wo Kilɛ.› ");
INSERT INTO myk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kilɛ ɲɛ xuu wo Kilɛ wɛ, ga wyii wo Kilɛ wu ɲɛ wii. Yee ya piin xuuni.» ");
INSERT INTO myk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A saliya karamɔgɔ wa di pee nakaara jomɔ pu logo. A wu li ɲa na Yesu ya Sadushɛɛn pu ɲɔ shɔ na ɲɔ. A wu fulo wu na na wu yege na: «Lekɛ lʼi ɲɛ Kilɛ wo saliya wu ɲɔmɛhɛɛ ki bɛɛri nigbɔɔ li wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A Yesu di wu ɲɔ shɔ na: «Saliya wu ɲɔmɛhɛɛ ki bɛɛri nigbɔɔ li wa le na: ‹Izirayɛli shɛɛn yi logo: Wù Kafɔɔ Kilɛ we, Kafɔɔ nigin pe wu ɲɛ wii. ");
INSERT INTO myk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma Kafɔɔ Kilɛ wu taan ma mu ma zɔ wu bɛɛri na, ni ma munaa li bɛɛri, ni ma fungɔngɔ ki bɛɛri, ni ma fanha ki bɛɛri.› ");
INSERT INTO myk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Li shuun wuu li wa le: ‹Ma sipyiɲii wu taan ma mu ba mayɛ pyaa ki ɲɛ wɛ.› Kilɛ wo saliya wu ɲɔmɛɛ la shishiin wa ye kii shuun we na wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A wee saliya karamɔgɔ wu Yesu pye na: «See na, wù Karamɔgɔ, ye mʼa jo ge, kaɲii li wa. Bani Kilɛ yɛ nigin wu wa, Kilɛ wa shishiin wa nige wee kadugo na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kilɛ na taan ma mu ma zɔ wu bɛɛri na, ni ma fungɔngɔ ki bɛɛri, ni ma fanha ki bɛɛri. A ma sipyiɲii bɛ di daan ma mu ba mayɛ pyaa ki ɲɛ wɛ, lee ya pɛlɛ saraya nizogoyo ni saraya tuuyo ye bɛɛri na.» ");
INSERT INTO myk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A Yesu di li ɲa na wʼa wee ɲɔ shɔ ni fungɔngɔ fɛɛrɛ ni, na wu pye: «Mu ni Kilɛ saanra ti tɛ wʼa lii wɛ.» Na co wee tuun wu na, wa shishiin ya luu waha na wu yege nige kaa la shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na Yesu yaha wu na sipyii pu kalaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, a wu pu pye: «Ɲaha na saliya karamɔgɔlɔɔ pʼi yu na Shɔvɔɔ wu ya ta sii pye watii Dawuda ja yɛ kadugo na-ɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawuda yɛ pyaa ya jo Fɛfɛɛrɛ Munaa fanha ni na: ‹Kafɔɔ Kilɛ ya yi jo nɛ Kafɔɔ mu na: Tiin saanra tatɛɛngɛ ki ni na kanige cɛ, fo di ba ma pɛɛn pu tirige na pa le ma tɔɔyɔ nɔhɔ ni.› ");
INSERT INTO myk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawuda yɛ pyaa ya Shɔvɔɔ wu pyi Kafɔɔ, wee tuun wu ni, wʼa já pye dii wu ja yɛ nigin wɛ?» Yesu kafila wu logo bi dan sipyii pu bɛɛri ni xuuni. ");
INSERT INTO myk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A wu yi jo pu mu wu kalaa wu ni na: «Yʼa yiyɛ kasɛri saliya karamɔgɔlɔɔ pu na. Na fadedɔɔnyɔ leni na ɲaari, ni sipyii na gbɔɔrɔ fò kaan pu mu pinnɛrɛ kpɛɛnyɛ na, lee lʼa dan pu ni. ");
INSERT INTO myk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kilɛ-pɛɛŋɛ piyɛyɛ yi wo ɲahagbaa tatiinyɛ, ni yaliceŋɛɛ wo tatiinceye bɛ di dan pu ni. ");
INSERT INTO myk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pʼa naxhugoshaa keŋɛ yaŋmuyɔ bɛɛri shuu pu na. Lee kadugo na pʼa shɛ mɔ Kilɛ-ɲɛrɛgɛ na, kɔnhɔ pʼi puyɛ shɛ see sipyii. Pu jaagi kanhama na ba golo fo xuuni.» ");
INSERT INTO myk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A Yesu di diin Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na saha ni yakanya yi tayahaŋa keshi wu ni, na sipyii pu wari wu yahagana li wii. Naafuu fɛɛ niɲɛhɛmɛɛ bi wari niɲɛhɛmɛ leni wu ni. ");
INSERT INTO myk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A naxhugoshɔ la baa fɔɔ wa bɛ di ba, na wari tuuŋɔɔ nifɛnhɛfɛnhɛŋɛɛ shuun le wu ni. Wee wari wu bi laha tama nigin shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wee tuun wu ni a Yesu di wu kalaapiire ti yiri na yi jo pu mu na: «Can na nʼa da yi jo yi mu, we naxhugoshɔ la baa fɔɔ we ya lemu le keshi wu funŋɔ ni ge, lee ya ɲɛhɛ pusamaa bɛɛri wuu li na. ");
INSERT INTO myk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bani pu bɛɛri ya wolo wolo pu naafuu ni na kan. Ga wee kunni ni wu la baara ti ni, lemu bɛɛri li ɲɛ wu mu wu ɲɔshaga wuu ge, wʼa lee bɛɛri kan.» ");
INSERT INTO myk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu nivorowo Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, a wa di wu pye wu kalaapiire ti ni na: «Wù Karamɔgɔ, ye kageegbɔyɔ ye ni ye piyɛyɛ ye yereŋɛgana wii sa!» ");
INSERT INTO myk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A Yesu di wu pye: «Mu ɲii wa ye pugbɔyɔ ye bɛɛri ni gɛ? Kagereŋɛ ka shishiin wa da ba gori naha ka ɲuŋɔ ni wɛ. Yi bɛɛri na ba do fɛɛfɛɛ.» ");
INSERT INTO myk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na Yesu nidɛɛngɛ yaha Oliviye faaboboŋɔ ki na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲaha tii wu ni, a Pyɛɛri, ni Yakuba, ni Yohana, ni Andire yɛ di ba wu yege pu yɛ na na: ");
INSERT INTO myk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Kee keree kii na ba bye tuun wemu ni ge, wee shɛ wù na! Ɲaha shɛshɛɛrɛ tekɛ tʼi da ba li shɛ na kee keree kii pyeduun wʼa nɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wee tuun wu ni a Yesu di pu pye: «Yʼa yiyɛ kasɛri! Yi ganha bu sipya wa shishiin yaha wu yi piinŋɛ wɛ! ");
INSERT INTO myk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sipyii niɲɛhɛmɛɛ na ba ba ni nɛ mɛgɛ ni, na yu: ‹Nɛ wu ɲɛ wii›. Pu na ba sipyiɲɛhɛmɛɛ piinŋɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yi ba kashɛn keree nuri, na kashɛn gbegemɛ keree nuri tuun wemu ni, yi funyɔ ganha da bɛn wɛ. Li waha lʼi waha, kee keree kʼa yaa na pye, ga lee di wa da ba bye taaxɔɔ li wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shi wa na ba yìri shi watii kaa na. Saanra ta na ba yìri saanra tatii kaa na. Ɲiŋɛ cɛlɛŋɛ na ba byi tɛyɛ ya ni, na fara xuugbɔhɔ bɛ na. Kee wa kanhama pu keree ɲɔkɔɔnrɔ yɛ, ba cee laa ma yìri mɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ga yi da yiyɛ kasɛri, bani sipyii na ba yi leni kiirikɔɔn kuruyo yi keŋɛ ni. Pu na ba yi kpɔɔn xuuni Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. Pu na ba se ni yi ni gbafɛnɛɛrɛɛ ni saannaa mu nɛ mɛgɛ wuu na. Lee na ba bye kaɲuŋɔ yi na Kilɛ wo Jozaama pu jo pu mu. ");
INSERT INTO myk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yani kee keree kii ki pye ge, li waha lʼi waha, Jozaama pu yɛrɛ ya yaa na fɛnhɛ jo shi wu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pu ba yi coni, na yi leni keye ni tuun wemu ni, yi nijoyo ganha bu da bye yi mu funzhaga wɛ, ga jomɔ pe pu da ba digi yi funyɔ ni wee tuun wuyɛ pyaa ni ge, yi pee jo, bani yiyɛ pyaa wa da ba bye pu jovɛɛ wɛ, fo Fɛfɛɛrɛ Munaa. ");
INSERT INTO myk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Ceboro na ba wu ceboro le keŋɛ ni, kɔnhɔ pʼi wu gbo. To na ba lee tuugo pye wu pya na. Nagoo bɛ na ba yìri pu sefɛɛ fɛni, kɔnhɔ pʼi pu gbo. ");
INSERT INTO myk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sipyii bɛɛri na ba yi kɔ nɛ mɛgɛ wuu na, ga wemu bu já luu mara fo na shɛ nɔ li tɛhɛnɛ na, weefɔɔ na ba shɔ.» ");
INSERT INTO myk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ayiwa gyɛɛgi pyevɔɔ wu ya yaa wʼa ɲaa xuu wemu ni wɛ, yi ba wu niyerege ɲaa wee xuu wu ni. (Wa bi yi kalaa, wufɔɔ wu yi ɲaha cɛ!) Wee tuun wu ni, piimu na ba bye Zhude fiige ki ni ge, pee di ba fe pʼa se faaboboyo xuu ni. ");
INSERT INTO myk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lee ba wemu ta kataŋa ɲuŋɔ ni, wu ganha bu da digi jé wu puga ni di wu yɛrɛyɛ lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wemu ɲɛ kɛrɛyɛ ni ge, wee ganha bu guri di ba wu fadeŋɛ lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bɔɔngɔ na ba bye lahaa fɛɛ ni puŋmaraya fɛɛ wogo yee caya yi na. ");
INSERT INTO myk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yʼa Kilɛ ɲɛɛri kɔnhɔ kee keree ki ganha ba saha ni wiire tuun ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bani kanhama na ba bye yee caya yi na pemu tuugo sanha bye ɲa wɛ, na co fo Kilɛ ya koŋɔ sii tuun wemu ni ge, fo na pa nɔ niɲaa na. Pee kanhama pu tuugo di wa da bye bɛ nige bada wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kafɔɔ da bye wu ya wolo kee cabyaa ki ni wɛ, sipya wa shishiin bi da zhɔ wɛ. Ga sipyii piimu ɲaha wʼa bulo ge, pee wuu na wʼa kii wolo kee cabyaa ki ni. ");
INSERT INTO myk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ayiwa, wa ba yi pye wee tuun we ni na: ‹Yi wii, Shɔvɔɔ wu wa naha.› kelee ‹Yi wii mɛ, wu we mɛ.› Yi ganha bu dà yee na wɛ! ");
INSERT INTO myk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bani kafinɛjuu pii na ba yìri, na puyɛ pye shɔvɛɛ ni Kilɛ tudunmɔɔ. Pu na ba ɲaha shɛshɛɛrɛ keree ni kakanhaŋaa pyi kɔnhɔ pʼi sipyiire ti piinŋɛ. Kilɛ ya sipyii piimu ɲaha bulo ge, nago ba pu da já ba pee bɛ piinŋɛ wɛ, pu bi da ba pee bɛ piinŋɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yee kunni pʼa yiyɛ kasɛri dɛ! Nɛ kii keree kii bɛɛri jo yaha yi mu.» ");
INSERT INTO myk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Yee caya yi na, pee kanhama pu nidorogo na, ‹Nibiige na ba jé caŋa ki ni; yeŋɛ wa da kpɛɛngɛ yeege wɛ; ");
INSERT INTO myk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wɔrɔɔ ki na ba do na yìri fugba we ni; fugba wu sefɛɛrɛ ti na ba jɛlɛ.›» ");
INSERT INTO myk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Wee tuun wu ni sipyii na ba Sipya Ja nibawo ɲa fugba ɲahaya ye na ni sefɛɛrɛ ti bɛɛri, ni nɔɔrɔ nigbɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wʼa piimu ɲaha bulo ge, wu na ba mɛlɛkɛɛ tun pu pee pinnɛ, na yìri koŋɔ ki kabaya shishɛɛrɛ wu bɛɛri na, na li ɲɔ kɔn ɲiŋɛ ke tɛhɛnɛ le na, fo fugba we tɛhɛnɛ le.» ");
INSERT INTO myk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ɲaha shɛshɛɛrɛ ta te nitoodige shizhaa na. Ki geye ba ɲɔ kɔn na funni tuun wemu ni, yi wa ma li cɛ na ki nagoo pyeduun wʼa tɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mu li wa, yi ba kii keree kii ɲaa ki na byi tuun wemu ni, yʼi li cɛ na Sipya Ja wʼa tɛɛŋɛ na xɔ, na wʼa nɔ xɔ kuɲɔɔ li ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Can na nʼa da yi jo yi mu, sipyii pii pu wa ɲiifɛɛrɛ ni nimɛ ge, pee bɛɛri wa da xhuu wɛ, yani kii keree kii bɛɛri ɲɔ ki fa ge. ");
INSERT INTO myk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Fugba we ni ɲiŋɛ ke na ba doro, ga nɛ jomɔ pe wa da doro bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ga sipya wa shishiin wa kee caŋa ke ni wee tuun we cɛ wɛ, ali fugba mɛlɛkɛɛ pu bɛ wɛ, Kilɛ Ja wu bɛ wɛ. To Kilɛ yɛ nigin pe wʼa kee caŋa ke ni wee tuun we cɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yʼa yiyɛ kasɛri, yʼi diin yaha ɲìi na! Bani yi wa lee kaa li nɔduun cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Li na ba bye ma na jo ná wa nigaraga kulo ni, wee nivorogo ya wu yaŋmuyɔ bɛɛri kaa le wu kapyebyii keŋɛ ni, na pu bɛɛri nigin nigin wu nibyii shɛ pu na, na yi jo puga ki kuɲɔsigimɛ wu mu na wu tiin yaha ɲìi na. ");
INSERT INTO myk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Lee wuu na yi kori yaha ɲìi na, bani puga ki kafɔɔ wu na ba ba yakoŋɔ la, ɲiɲiŋɛ na la, xhupee mɛhɛɛ suduun ni la, ɲisɔɔgɔ na la, yi wa cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wu ganha ba yi fo, wu yi niŋmunuyɔ ta wɛ. ");
INSERT INTO myk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ye nʼa yu yi mu ge, yee nʼa yu sipyii pu bɛɛri mu: ‹Yi kori yaha ɲìi na!›» ");
INSERT INTO myk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cabyaa shuun yɛ wu bye pu ni Ɲuwuuro, ni Shizhɛnhɛrɛ Baa Buuri Kalenɛ li tɛ ni. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu bi cogana shaa Yesu na pʼi wu peele co ŋmɔhɔrɔ ni, pʼi wu gbo. ");
INSERT INTO myk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A pʼi jo: «Wù ganha bu wu co kalenɛ li ni wɛ, kɔnhɔ tunmɔ ganha bu yìri sipyiire ti tɛ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na Yesu yaha wu na li Bɛtani kulo li ni Simɔ kaban, togo kʼa fɛnhɛ wemu co toro ge, a cee wa di ba ni lasikoli gboro la ni. Lee bi ɲi pɛɛwa lasikoli wa na wemu mɛgɛ ki ɲɛ na naari ge. A cee wu lee lasikoli gboro li ɲɔ waa, na li funŋɔ lasikoli wu wo Yesu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sipyii pii pu bye wà ge, a pii logoo di yìri, na ganha na puyɛ pyi: «Te lasikoli kakara te wo ɲuŋɔ ɲɛ lekɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","We lasikoli we bi da já bɛrɛ na toro wari kabɔfoŋɔɔ kɛlɛɛ shishɛɛrɛ ni kaguro (w 45.000) shishiin tàan, na wee kan funmɔ fɛɛ mu.» A pʼi jo ni wee cee wu ni xuuni. ");
INSERT INTO myk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ga, a Yesu di jo: «Yi laha wu na! Ɲaha na yʼi we cee we zɔ tɛnri wɛ? Go kasaana wʼa pye mɛ nɛ na. ");
INSERT INTO myk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Funmɔ fɛɛ na da daa yee tɛ ni tuun bɛɛri ni. Tuun bɛɛri bu yee taan, yee na já kasaana pye pu na. Ga nɛ kunni wa da ba bye yee tɛ ni tuun bɛɛri ni wɛ. ");
INSERT INTO myk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wu se kaa wʼa pye. Na gbo wo lasikoli wʼa wo na na, yani di ba xhu ge. ");
INSERT INTO myk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Can na nʼa da yi jo yi mu jo xuu bɛɛri ni Kilɛ wo Jozaama pʼa jo ke koŋɔ ke na ge, le we cee we ya pye ge, li bɛ na baari wà, na sipyii pu funyɔ tirige ni wu kaa ni.» ");
INSERT INTO myk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zhuda Isikariyɔti we wu bye wu kalaapiire kɛ ni shuun wu wa nigin ge, wee ya shɛ saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu mu na wu da Yesu le pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pʼa wu jomɔ pu logo ge, a lee di daan pu ni xuuni. A pʼi ɲɔmɛɛ lɔ wu mu na pee na ba wari kan wu mu. A Zhudasi di ganha na pyegazaana shaa wu Yesu le pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Shizhɛnhɛrɛ Baa Buuri wu wo Kalenɛ li cazhiige ke, kemu na ɲuwuuro ti wo saraga dubyapige ki ma gbo ge, a Yesu kalaapiire tʼi wu yege na: «Ma funŋɔ wa wù shɛ Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele xuu wekɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A Yesu di shuun wa tun wu kalaapiire ti ni, na yi jo pu mu na: «Yi shɛ kanha ki ni. Yi na zhɛ saha ni ná wa ni wʼa lɔhɔ shɔɔ tugo, yʼi daha wee fɛni. ");
INSERT INTO myk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wu ba shɛ jé puga kemu ni, yʼi kee puga ki kafɔɔ pye: ‹Wù Karamɔgɔ wʼa jo na wu ni wu kalaapiire ti na ba Ɲuwuuro ti wo Kalenɛ li yalige ki li puga kemu ni ge, na mii ki wa wɛ?› ");
INSERT INTO myk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wu na pugbɔhɔ ka shɛ yi na zangaso wu ni. Yɛrɛyɛ wa ki ni, kʼa gbegele yaha. Yʼi Ɲuwuuro ti Kalenɛ li yalige ki gbegele wù mu wà.» ");
INSERT INTO myk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A kalaapiire tʼi yìri kari kanha ki ni, na shɛ keree ki ta ba Yesu ya yi jo pu mu wɛ. A pʼi Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ba piige kʼa pa wɔ wɛ, a Yesu ni wu kalaapiire kɛ ni shuun wu ba. ");
INSERT INTO myk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na pu yaha lige ki na, a Yesu di ba jo: «Can na, nʼa da yi jo yi mu, wa na ba nɛ le keŋɛ ni yee ni, wemu wʼa li ni nɛ ni ge.» ");
INSERT INTO myk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A kalaapiire ti ɲahaya di danha, na ganha na wu yegee nigin nigin, na: «Nɛ wi ya?» ");
INSERT INTO myk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A Yesu di pu ɲɔ shɔ na: «Yee kɛ ni shuun wu wa wu wa, wemu wʼa wu keŋɛ ki le golɛgɛ ki ni ni nɛ ni ge. ");
INSERT INTO myk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sipya Ja wu na ba xhu ma na jo ba lʼa ka wu shizhaa na wɛ. Ga wemu wʼa da ba Sipya Ja wu le keŋɛ ni ge, bɔɔngɔ ki ɲɛ weefɔɔ wogo. Ali wee ná wu da bye pu ya wu se bɛ wɛ, lee bi da bɔrɔ wu mu.» ");
INSERT INTO myk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na pu yaha lige ki na, a Yesu di buuri wa lɔ, na baraga taha Kilɛ na, na wu kɛgi kɛgi na kan wu kalaapiire ti mu, na pu pye: «Yi wu lɔ, nɛ ceepuuro ti wa te!» ");
INSERT INTO myk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lee kadugo na a wu ɛrɛzɛn lɔhɔ cɛɛgbuu li lɔ, na baraga taha Kilɛ na, na li kan pu mu. A pu bɛɛri di ka gba. ");
INSERT INTO myk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A Yesu di pu pye: «Nɛ shishan pu ɲɛ pe, Kilɛ wo kariɲɛɛgɛ ɲɔmɛɛ li wo shishan pe. Sipyiɲɛhɛmɛɛ wuu na pʼa wo. ");
INSERT INTO myk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Can na, nʼa da yi jo yi mu, nʼa da ɛrɛzɛn lɔhɔ gba nige wɛ, fo caŋa kemu nʼa da ba ki nivoŋɔ gba Kilɛ wo saanra te ni ge.» ");
INSERT INTO myk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba pʼa li xhɔ wɛ, na Kilɛ masɔŋɔ yoyo cee. Lee kadugo tàan a pʼi foro kari Oliviye faaboboŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A Yesu di wu kalaapiire ti pye: «Yee bɛɛri na ba baa na nɛ yɛ nigin yaha, bani lʼa ka Kilɛ Kafila wu ni na: ‹Nɛ na ba yatɔɔnahama wu gbo; dubyaa pu bɛɛri na baa caaga.› ");
INSERT INTO myk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ga nɛ ba ɲɛ na foro xu ni tuun wemu ni, nɛ na doro yi ɲaha na Galile fiige ki ni.» ");
INSERT INTO myk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A Pyɛɛri di wu pye: «Ali pusamaa bɛɛri ɲɛhɛ baa na ma wá, nʼa da ga ma wá wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A Yesu di wu pye: «Can na nʼa da yi jo ma mu, niɲaa wo piige ke ni yani xhupeshiilee ni shuun wuu pu pa mɛhɛɛ su ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri na mu ya nɛ cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ga, a Pyɛɛri di yi jo wu mu sanha na yi waha xuuni na: «Ali li mɛhɛ yaha nɛ wu xu bɛ ni mu ni, nʼa da ga foro ma kaa tàan wɛ.» A pusamaa bɛɛri di yee ninuyɔ jo mu. ");
INSERT INTO myk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lee kadugo na a pʼi gari xuu wa ni wemu mɛgɛ ki ɲɛ na Zhetisemanɛ ge, a Yesu di wu kalaapiire ti pye: «Yi tiin naha, di shɛ Kilɛ ɲɛɛri.» ");
INSERT INTO myk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A wu gari wà ni Pyɛɛri, ni Yakuba, ni Yohana ni. A lʼi sii wu funŋɔ cɔnri fo xuuni, na wu ɲaha bɛ tanha. ");
INSERT INTO myk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A wu pu pye: «Nɛ zɔ we bɛɛri wʼa tanha fo nɛ na zhaa di xhuu. Yi tiin naha, yʼi gori yaha ɲìi na!» ");
INSERT INTO myk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A wu shɛ ɲaha na jɛri na do ɲiŋɛ na, na Kilɛ ɲɛɛri na li bi da já bye, wee tuun wu wo kanhama pʼi doro wu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A wu jo: «Na To, kaa la shishiin ya mu jani wɛ, le kanhama cɛɛgbuu le sanha lii na na. Lee bɛ na, nɛ wo ɲidaan ganha bye wɛ, fo mu wo ɲidaan.» ");
INSERT INTO myk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A Yesu di guri pa wu kalaapiire taanri wu yíri, na ba pu ta pʼa ŋmunɔ. A wu Pyɛɛri pye: «Simɔ, mʼa ŋmunɔɔ gɛ? Mu ya já kori yaha ɲìi na na ali lɛɛri nigin bɛ pye-e ya? ");
INSERT INTO myk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yi tiin yaha ɲìi na yʼi da Kilɛ ɲɛɛri, kɔnhɔ Shitaanni ganha bu se ta yi na wɛ. Sipya munaa ya sɔɔ, ga wu ceepuuro fanha kʼa cɛ̀rɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A wu laha pu tàan sanha na Kilɛ ɲɛɛri, na guri pee jonumɔ pu na. ");
INSERT INTO myk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lee kadugo na a wu guri pa sanha wu kalaapiire ti yíri, na ba pu ta pʼa ŋmunɔ sanha, bani ŋmunumɔ pu bi shɔ pu ni. A pʼi bye pu ya cɛ dii pu da wu ɲɔ shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A wu ba tɔɔɲii taanri wuu li ni na pu pye: «Yee wa ŋmunɔɔ sanha na ŋmɔni gɛ? Lʼa yaa, tuun wʼa nɔ. Li wii, Sipya Ja wu na ba jé jurumupyii pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yi yìri wù da se! We wʼa da na le keŋɛ ni ge, wʼa nɔ.» ");
INSERT INTO myk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na Yesu yaha pee jomɔ pu na, taapile ni a Zhudasi di nɔ, wee ɲɛ kalaapiire kɛ ni shuun wu wa nigin wa. A wu nɔ ni sipyiɲɛhɛmɛɛ pii ni. Ŋmɔparaa ni pubegee ki bye pee mu. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ, ni nɔhɔlɛɛ pu bi pee tun. ");
INSERT INTO myk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zhudasi wemu wu bi da ba Yesu le keŋɛ ni ge, wee bi ɲaha shɛshɛɛrɛ ta shɛ sipyiire ti na na: «Di ba shɛ ɲɔsɔɔnrɔ fò kan ná wemu mu, yʼi wee co, wee wu wa. Yʼi kasɛɛgɛ yaha wu na xuuni, yi da gaaŋi ni wu ni.» ");
INSERT INTO myk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A Zhudasi di dii Yesu na taapile ni, na wu pye: «Karamɔgɔ!» Na ɲɔsɔɔnrɔ fò kan wu mu. ");
INSERT INTO myk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba lee ya pye wɛ, a pʼi fulo Yesu na, na wu co. ");
INSERT INTO myk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A Yesu wo sipya nigin wa di wu ŋmɔpara kɔɔngi, na saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kapyebye niwɛŋɛ paa laha. ");
INSERT INTO myk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A Yesu di pu pye: «A yee di ba ni ŋmɔparaa, ni pubegee ni nɛ tacoŋɔ ni, ma na jo kakuubye di ɲɛ ya? ");
INSERT INTO myk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nɛ bi bye ni yee ni caŋa bɛɛri, na sipyii kalaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, yee di ya nɛ co wɛ. Ga lʼa pye, kɔnhɔ Kilɛ Kafila wu ɲɔ di fa.» ");
INSERT INTO myk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A wu kalaapiire ti bɛɛri di baa, na wu yaha wà. ");
INSERT INTO myk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A lɛvɔɔ wa di daha Yesu fɛni, fatɔŋɔ yɛ ki bi mugile wu na. A shɛn nigin wa di wu co sipyii pu ni. ");
INSERT INTO myk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","A wu wu fatɔŋɔ ki yaha wee keŋɛ ni, na baa kari ni ceepile ni. ");
INSERT INTO myk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A pʼi gari ni Yesu ni saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu kaban. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni nɔhɔlɛɛ, ni saliya karamɔgɔlɔɔ pu bɛɛri di puyɛ pinnɛ wà. ");
INSERT INTO myk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A Pyɛɛri di laraga kɔn pu na, na daha pu fɛni, fo na shɛ jé saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kaaŋa ki ni, na diin gɛdii pu tàan na na wahani. ");
INSERT INTO myk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu fara kiirikɔɔn kuruŋɔ ki na, pee bi sɛɛri kaa la shaa Yesu fɛni kɔnhɔ pʼi wu gbo, ga pu ya li ta wɛ. ");
INSERT INTO myk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sipyiɲɛhɛmɛɛ ya kafinɛyɛ sɛɛri keree pye Yesu fɛni, ga pu jomɔ pu bi puyɛ kaala. ");
INSERT INTO myk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A sipyii pii di yìri na kafinɛyɛ taha Yesu na na: ");
INSERT INTO myk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Wʼa yi jo wèe ɲii na na: ‹Sipyii pʼa ke Kilɛ-pɛɛŋɛ pugbɔhɔ kemu yereŋɛ ge, nɛ na ba kee ja, na katii yereŋɛ cabyaa taanri funŋɔ ni, sipyii keye ya kemu yereŋɛ wɛ.›» ");
INSERT INTO myk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ga lee bɛ na, pu sɛɛri keree ki jomɔ pu ya pye nigin wɛ. ");
INSERT INTO myk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu yìri yere sipyii pu niŋɛ ni, na Yesu pye: «Jomɔ pemu bɛɛri pii sipyii pii wa yu mu shizhaa na ge, mu wa da pu ɲɔ shɔ-ɛ gɛ?» ");
INSERT INTO myk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ga, a Yesu di cari wuyɛ na, wu ya yaaga jo wɛ. A saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wu yege sanha na: «Ta mu wu ɲɛ Shɔvɔɔ we, duba fɔɔ Kilɛ Ja we?» ");
INSERT INTO myk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A Yesu di wu ɲɔ shɔ na: «Uun, were nɛ wa. Yi na ba Sipya Ja wu nidɛɛngɛ ɲa Se Bɛɛri Fɔɔ Kilɛ kanige cɛ. Yi na ba wu nibawo ɲa bɛ sanha fugba ɲahaya ye na.» ");
INSERT INTO myk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lee na a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wuyɛ pyaa wo fadeŋɛ shɛɛngi loyire keŋɛ ni, na jo: «Ɲaha fɛni wù ɲɛ sanha sɛɛrɛɛ pu mu wɛ? ");
INSERT INTO myk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yi niwegee wa wu Kilɛ mɛkyɛɛgɛrɛ jomɔ ni. Yee di wa yekɛ yu wɛ?» A pu bɛɛri di wu jaagi na wʼa yaa na wu gbo. ");
INSERT INTO myk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A pii di ɲɔlɔhɔ tugi wu na. A pʼi Yesu ɲaha pɔ, na wu kpɔɔn ni kaguruyo ni, na wu pye: «Ma kpɔnvɔɔ wu mɛgɛ yiri wù mu?» A gɛdii pu bɛ di Yesu kpɔn ni pu keye ni. ");
INSERT INTO myk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na Pyɛɛri yaha saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu kaaŋa ki ni, a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kapyebyezhɔ wa di yìri wà zangaso wu fugba ni, na tigi ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A wee di ba Pyɛɛri ɲa wu na na wahani, na wu wii xuuni na wu pye: «Mu bɛ wu bye ni Nazarɛti shɛɛn Yesu ni.» ");
INSERT INTO myk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ga, a wu foro wu kaa tàan na jo: «Ye mu wa yu ge, nɛ yi cɛ wɛ, nɛ yi ɲaha cɛ wɛ.» Lee kadugo na a wu foro kari kpaan li ni, a xhupeshiimɛ di mɛɛ su. ");
INSERT INTO myk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A kapyebyezhɔ wu wu ɲa sanha na yi jo wee xuu wu wo sipyii pu mu na: «We ná we bɛ wu wa pu ni.» ");
INSERT INTO myk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A Pyɛɛri di foro Yesu kaa tàan sanha. Ba jɛri ya pye wɛ, piimu pu bi yere Pyɛɛri tàan ge, a pee bɛ di wu pye: «Nakaara baa mu bɛ wu wa pu ni, bani Galile shɛn mu bɛ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ga, a Pyɛɛri di gaa na wuyɛ laŋi na jo: «Ná wemu kaa yi wa yu ge, nɛ wu cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Taapile ni a xhupoo di mɛɛ su xhupeshuun wuu na. A Pyɛɛri funŋɔ di do ni Yesu jomɔ pu ni na: «Yani xhupeshiilee ni shuun wuu pu pa mɛhɛɛ su ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri na mu ya nɛ cɛ wɛ.» A mɛɛ di shɔ wu na. ");
INSERT INTO myk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɲisɔɔgbɔhɔ ki na a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni nɔhɔlɛɛ, ni saliya karamɔgɔlɔɔ, ni kiirikɔɔn kuruŋɔ ki bɛɛri, a pee di puyɛ pinnɛ, na puyɛ ɲa. A pʼi Yesu pɔ, na shɛ wu le Pilate keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A Pilate di wu yege na: «Yawutuu wo saan mu ɲɛ ya?» A Yesu di wu ɲɔ shɔ na: «Uun, ba ma wa yi yu wɛ, wee nɛ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi wu tɔɔgɔ le ni jomɔ niɲɛhɛmɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A Pilate di wu pye sanha na: «Mu wa da ɲɔshɔɔrɔ ta shishiin pye-e ya? Pʼa keree kiimu taga na mu tɔɔgɔ leni ge, mu wa kee nuri-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ga Yesu ya wu ɲɔ shɔ wɛ, a lee di bye kakanhana Pilate mu. ");
INSERT INTO myk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ayiwa kaa la bi tee na byi Yawutuu pu mu, lee ɲɛ yee bɛɛri pu bu kasolemɛ wemu sha Pilate mu pu Bulooro Ɲuwuuro Kalenɛ li ni, wʼa wee yaha. ");
INSERT INTO myk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ná wemu mɛgɛ ki ɲɛ na Barabasi ge, wee ni wu nʼa she pyeɲii bi bye kaso ni wee tuun wu ni. Pee wa bi sipya wa gbo pu wo nʼa she wu funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A sipyiire tʼi gari Pilate yíri na shɛ wu ɲɛɛri na wʼa tee na kaa lemu pyi pu mu ge, na wu lee pye. ");
INSERT INTO myk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A Pilate di pu ɲɔ shɔ na: «Yi la ɲɛ di Yawutuu pu wo saan wu yaha yi mu ya?» ");
INSERT INTO myk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bani Pilate bi li cɛ na Yesu wo ɲɛpɛɛn na saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼa bi wu le wee keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ga, a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi sipyiire ti sɔn, na pu Pilate ɲɛɛri na wu Barabasi yaha. ");
INSERT INTO myk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A Pilate di pu pye sanha na: «Yawutuu pu wo saan wu wi ge, di lekɛ pye wu na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A pʼi xhuulo sanha na jo: «Wu kori tige na!» ");
INSERT INTO myk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A Pilate di pu yege na: «Kakuunɔ lekɛ wu dʼa pye wɛ?» Ga, a pʼi xhuulo xuuni na toro taashiinɛ li tàan na: «Wu kori tige na!» ");
INSERT INTO myk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate funŋɔ bye wu sipyiire ti wo ɲidaan pye. Lee wuu na wʼa Barabasi yaha, na Yesu kan pʼa kpɔn ni susɔlɔɔ ni, na wu le pu keŋɛ ni pu kori tige na. ");
INSERT INTO myk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A sɔrɔsii pʼi gari ni Yesu ni gbafɛnɛɛri wu kaaŋa ki ni, na pu kuruŋɔ ki sɔrɔsii pu bɛɛri pinnɛ wà. ");
INSERT INTO myk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A pʼi saanra fadeboroŋɔ niɲiga ka le wu na, na xhuyo shin na pye saanra ɲudɔnɔ, na lee tɔ wu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na fò kan wu mu na: «Ɲaabye, Yawutuu saan!» ");
INSERT INTO myk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A pʼi ganha na wu kpɔɔn ɲuŋɔ ke ni ni wahagaan ni, na ɲɔlɔhɔ tugoo na woni wu na, na leele wu fɛɛ ni, na li pye kanna pʼa wu pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pʼa wu la wolo xɔ ge, na kee fadeboroŋɔ niɲiga ki wolo wu na, na wuyɛ pyaa wo fàya yi le wu na, na foro ni wu ni kanha ki ni, pʼi shɛ wu kori korikoritige ki na. ");
INSERT INTO myk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ayiwa, na pu yaha pu na gaaŋi, a pʼi ná wa ɲa wʼa yìri wu kɛrɛyɛ ni na doroo, wee mɛgɛ ki bye na Simɔ. Sirinɛ kulo li shɛn wʼa bye wii. Alɛkisandire ni Urufusi yɛ to wu bye wii. A sɔrɔsii pʼi wee karamu wʼa Yesu korikoritige ki lɔ. ");
INSERT INTO myk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A pʼi gari ni Yesu ni xuu wa ni, wee mɛgɛ ɲɛ na «Goligota», lee kɔri ɲɛ «Ɲugɔrɔgɔ xuu.» ");
INSERT INTO myk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A pʼi duvɛn suri durɔgi losorogo ka ni na kan wu mu na wu yee gba, ga Yesu ya ta sɔɔ na yi gba wɛ. ");
INSERT INTO myk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A pʼi wu kori tige na, na wu fàya yi shan tahaa tahaa. A pu bɛɛri di kagaangaa lɔ, na kee pinnɛ kan wa mu wʼa shan shan fàya tahaa ki ɲuŋɔ ni. A pʼi yi lɔ, wa bɛɛri wʼa wu wo kagaan woyo lɔ. ");
INSERT INTO myk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pʼa wu kori tige ki na tuun wemu ni ge, lee ya pye ɲisɔɔgɔ tuunɔ ɲìi gbarashɛɛrɛ wu na. ");
INSERT INTO myk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pʼa wu jaagi lemu na ge, na lee ka na: ");
INSERT INTO myk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","A pʼi kakuubyii shuun kori tiye na Yesu tàan, nigin wa bye wu kanige cɛ, nigin wa di ɲɛ wu kamɛnɛ cɛ.  ");
INSERT INTO myk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Lee na Kilɛ Kafila wʼa yemu jo na pu na ba wu tɔrɔ le kakuubyii ni ge, yee ɲɔ ya fa. ");
INSERT INTO myk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kodoroloo pu bi pu ɲuyɔ kori, na wu shɛhɛlɛ, na yu: «Uun, mu wemu wʼa jo na mu na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ja, na ki yereŋɛ sanha cabyaa taanri funŋɔ ni ge. ");
INSERT INTO myk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mayɛ shɔ sa! Tigi laha tige ki na!» ");
INSERT INTO myk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu bɛ bi Yesu la wo puyɛ tɛ ni, na puyɛ pyi na: «Wʼa sipyii piitiilee shɔ, ga wʼa da já wuyɛ shɔ wɛ, ");
INSERT INTO myk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Shɔvɔɔ we wu ɲɛ Izirayɛli wo saan wu ge, wu tigi laha nimɛ korikoritige ki na, kɔnhɔ wù wu ɲa wù dà wu na.» Namaa shuun wemu pʼa kori ni wu ni ge, pee bɛ bi wu fanri. ");
INSERT INTO myk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ba caŋa kʼa pa nɔ midi na wɛ, a nibiige di jé fiige ki bɛɛri ni, fo na shɛ nɔ yakoŋɔ tuunɔ ɲìi taanri wu na. ");
INSERT INTO myk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ba yakoŋɔ ki wo tuunɔ ɲii taanri wʼa pa nɔ wɛ, a Yesu di ba mujuugbɔɔ wá na: «Eli, Eli, lama sabakatani?» Lee kɔ́ri ɲɛ: «Na Kilɛ, Na Kilɛ, ɲaha na ma dʼa na yaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Piimu niyereye yi bye wà ge, ba pii ya lee mujuu li logo pee ni wɛ, na jo: «Wii, Kilɛ tudunmɔɔ Eli wʼa yiri.» ");
INSERT INTO myk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A shɛn nigin wa di baa kari pu ni, na shɛ yoro fyɛnmi vinɛgiri ni, na tee migile kagaantɔɔngɔ ka na, na shɛ gan Yesu mu wu sɔn. A wee ná wu jo: «Yi yere wù wu wii Eli bu da wu na da ba wu tirige.» ");
INSERT INTO myk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ga, a Yesu di mujuugbɔɔ wá, na xhu. ");
INSERT INTO myk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Taapile ni a Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲahaparaga fàŋa nigbilege kʼi daa shuun, na lɔ fugba wu na fo ɲiŋɛ ke. ");
INSERT INTO myk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sɔrɔsii ɲuŋɔfɔɔ we niyerege ki bye na saha ni Yesu ni ge, wee ya wu ɲa wʼa sipile wá na xhu ge, a wu jo: «Can na, Kilɛ Ja yɛ pyaa ki bye we ná we.» ");
INSERT INTO myk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cèe pii bɛ bi yere taliige ni na kii keree kii wii. Pii mɛyɛ yi wa ye pu ni: Magadala shɛɛn Mariyama, ni Yakuba nibire ni Zhose yɛ nu Mariyama, ni Salomɛ. ");
INSERT INTO myk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pee cèe pu pʼa bi taha Yesu fɛni, na wu tɛgɛ wu labye wu na, na wu yaha Galile fiige ki ni. Cèe niɲɛhɛmɛɛ piitiilee bɛ bi taha wu fɛni na kari Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A yakoŋɔ kʼi nɔ, kee ɲɛ Pɔri caŋa. Kee caŋa ki shi na Yawutuu pu ma cadɛɛngɛ ki keree gbegele yaha, kee da nɔhɔ pye Yesu caxhugo caŋa. ");
INSERT INTO myk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","A Arimate shɛɛn Yusufu di ba. Kiirikɔɔn kuruŋɔ ki sipyigbɔ wa wu bye wii. Wee bɛ bi Kilɛ wo saanra ti sigee, a wu ɲuŋɔ waha na shɛ Pilate mu, na Yesu nixhugo ki ɲɛɛri wu mu. ");
INSERT INTO myk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A lee di Pilate fo wu na logo na Yesu ya xu tɔvuyo na mɛ. A wu sɔrɔsii ɲuŋɔfɔɔ wu yiri, na wu yege Yesu xuduun bu da wʼa mɔ. ");
INSERT INTO myk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wʼa ɲɔshɔɔrɔ ta na yìri sɔrɔsii ɲuŋɔfɔɔ wu yíri ge, a wu sɔɔ na Yusufu wu Yesu nixhugo ki lɔ. ");
INSERT INTO myk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A Yusufu di fatɔŋɔ ka shɔ, na Yesu tirige, na kee fatɔŋɔ ki migile wu na, na wu le faŋa ka ni, kee bi tugi yaha faaya yi ni. Na xhɔ na kageegbɔhɔ ka gologolo taga faŋa ki ɲɔ tɔ. ");
INSERT INTO myk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magadala shɛɛn Mariyama ni Zhose nu Mariyama, pee bye wà na Yesu nixhugo ki taleŋɛ ki wii. ");
INSERT INTO myk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba Yawutuu wo cadɛɛngɛ kʼa toro wɛ, a Magadala shɛɛn Mariyama, ni Yakuba nu Mariyama, ni Salomɛ yɛ di shɛ nudanga yaŋmuyɔ shɔ, na pʼi shɛ Yesu nixhugo ki tìre ni yee ni. ");
INSERT INTO myk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A pʼi gari faŋa ki na Dimazhi wu ɲisɔɔgɔ ki na, caŋa ki foroduun ni. ");
INSERT INTO myk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pu bi puyɛ pyi na: «Jɔgɔ wu dʼa zhɛ kageegbɔhɔ ki gologolo laha wèe mu faŋa ki ɲɔ na wɛ?» ");
INSERT INTO myk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A pʼi wii na kageegbɔhɔ ki ta kʼa gologolo laha faŋa ki ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","A pʼi jé faŋa ki ni, na ná wa ɲa wà, wu nidɛɛngɛ ki bye kanige cɛ we ni, fadedɔɔngɔ nivige di ɲɛ wu na. A lʼi bye pu fyaara wuu mu kakanhana xuuni. ");
INSERT INTO myk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A wee di pu pye: «Yi ganha fya wɛ. Nazarɛti shɛɛn Yesu we wʼa kori tige na ge, wee yʼa zhaa. Wu wa naha wɛ; wʼa ɲɛ. Pʼa wu sinniŋɛ xuu wemu ni ge, yi wee wii. ");
INSERT INTO myk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ga yi shɛ yi jo wu kalaapiire ti mu ni Pyɛɛri bɛ na: ‹Wʼa gaaŋi yi ɲaha na Galile fiige ki ni. Yi na zhɛ wu ɲa wà ma na jo, ba wʼa bi yi jo yi mu wɛ.›» ");
INSERT INTO myk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A cèe pʼi fya na jɛlɛ, na baa foro faŋa ki ni. Pu ya yaaga jo sipya wa shishiin bɛ mu wɛ, bani pu bi fya.  ");
INSERT INTO myk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu niɲɛŋɛ na foro xu ni, Dimazhi wu ɲisɔɔgɔ ki na, a wu wuyɛ shɛ Magadala shɛɛn Mariyama na ɲaha na. Jinaa gbarashuun wu bi kɔri yeege wee ni. ");
INSERT INTO myk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pii pu bi ɲaari ni Yesu ni ge, a Mariyama di shɛ yi jo pee mu. Pee ɲahaya yi bi tanha, mɛhɛɛ pu bi suu. ");
INSERT INTO myk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pʼa logo na Yesu wa ɲiifɛɛrɛ ni, na Mariyama wʼa wu ɲa ge, pu ya dà li na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lee kadugo na pu shuun wa di ba ganha na gaaŋi kulo la ni. Pu nigariwuu, a Yesu cogo ɲɛriwo di wuyɛ shɛ pu na. ");
INSERT INTO myk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba pʼa kuri pa wɛ, na ba yee jo kalaapiire tisara mu, pu ya dà yee bɛ na sanha wɛ. ");
INSERT INTO myk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lee kadugo na a Yesu di wuyɛ shɛ wu kalaapiire kɛ ni nigin wu na, na pu yaha pu na li. A wu jo ni pu ni pu nʼa daa baara, ni pu niwewaa li wuu na, bani pii pʼa wu ɲa wu dʼa ɲɛ xɔ ge, pu ya dà pee na wɛ. ");
INSERT INTO myk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A wu yi jo pu mu na: «Yi shɛ koŋɔ ke kabaya ye bɛɛri na, yʼi Kilɛ wo Jozaama pu yɛrɛ li pye sipyii pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sipya wemu bu dà li na na batize, wee na zhɔ, ga wemu ya dà wɛ, wee wo jaagi kanhama pu na ba golo. ");
INSERT INTO myk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Piimu bu dà, pee na ba kii kakanhaŋaa kii pyi: Pu na ba jinaa kɔri na yeege sipyii ni nɛ mɛgɛ na. Pu na ba shi watii jomɔ yu. ");
INSERT INTO myk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pu na ba wɔlɔɔ coni pu keye ni. Pu bu sipyigbɔ yaaga gba, kee wa da yaaga kyɛɛgi pu mu wɛ. Pu na ba pu keye taha yama fɛɛ na pʼa juuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kafɔɔ Yesu ya jo xɔ ni pu ni ge, a wu yìri, na dugi kari fugba we ni, na shɛ diin saanra tatɛɛngɛ ki ni Kilɛ kanige cɛ. ");
INSERT INTO myk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A pee kunni di gari, na shɛ Jozaama pu jo kabaya yi bɛɛri na. Kafɔɔ bye ni pu ni pu labye wu bɛɛri na, na kakanhaŋaa pyi kiimu ya li shɛɛ na kaɲii li wa pu jomɔ pu ge.");
INSERT INTO myk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Na ceborona Teyofili, Keree kii kʼa pye wù niŋɛ ni ge, sipyii ya ɲɔ kɔn na kee kafila kani. ");
INSERT INTO myk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kee keree kʼa pye piimu ɲii na, na co ki ɲɔ kɔnduun wu na, a tuduro di gan pu mu pʼa Kilɛ kafila wu yu ge, pee ya kii keree kii jomɔ jo wèe mu. A ki kavɛɛ di ki ka na bɛ ni ki ɲavɛɛ pu wo jogana li ni. ");
INSERT INTO myk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Keree kii bɛɛri kʼa pye, fo ki ɲɔ kɔnduun wu ni ge, nɛ bɛ ya kee suguri xuuni. Lee wuu na lʼa saha na nɛ yaa na kee keree kii ka, na ki sogi sogi kiyɛ na mu mu, Teyofili. ");
INSERT INTO myk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Keree kiimu ni mʼa kalaa ge, kɔnhɔ mʼa dà li na na can yɛ pile li wa kee keree kee. ");
INSERT INTO myk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na Hɛrɔdi yaha saanra ti na Zhude ɲuŋɔ ni, Yawutuu wo saraya ɲaha shɔɔnrivɔɔ wa bye wà, wu mɛgɛ di ɲɛ na Zakari. Abiya wo kuruŋɔ ki wo saraya ɲaha shɔɔnrivɔɔ wa wu bye wii. Wu shɔ bye saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ Arɔn poro wa; wee mɛgɛ ki bye na Elizabɛti. ");
INSERT INTO myk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pu shuun wu bɛɛri nidiiye yi bye Kilɛ ɲaha tàan. Zɔ wa shishiin bye pu na Kafɔɔ Kilɛ wo ɲɔmɛɛjogoo ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ga pya bɛ bye pu mu wɛ, bani Elizabɛti bye seganha. Pu shuun wu bɛɛri dʼa lɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Caŋa ka, na Zakari yaha saraya ɲaha shɔɔnrivɛɛrɛ ti ni Kilɛ ɲaha tàan, wu wo kuruŋɔ ki tuun wu ni. ");
INSERT INTO myk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A pʼi wu ɲaha bulo, na bɛ ni saraya ɲaha shɔɔnrivɔɔ pu wo kalɛɛ li ni, na wu jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, wu nudanga wusuna wu le. ");
INSERT INTO myk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sipyii pu bɛɛri bye Kilɛ-ɲɛrɛgɛ na kpɛɛngɛ ki na, wusuna wu leduun wu ni. ");
INSERT INTO myk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A Kilɛ wo mɛlɛkɛ wa di wuyɛ shɛ Zakari na, wee mɛlɛkɛ wu bye nudanga wusuna saraya yi tawologo ki kanige cɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari ya wee ɲa tuun wemu ni ge, a wu hakili di wuregi, a wu fya. ");
INSERT INTO myk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ga, a mɛlɛkɛ wu wu pye: «Zakari, ma ganha fya wɛ, bani ma Kilɛ-ɲɛrɛgɛ kʼa co. Ma shɔ Elizabɛti na ba ja se ma mu. Ma na ba wu mɛgɛ le Yohana. ");
INSERT INTO myk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma na ba fundanga pyi, ma funŋɔ na faha, sipyiɲɛhɛmɛɛ na ba fundanga pye wu ze wu wuu na. ");
INSERT INTO myk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wu na ba bye sipyigbɔ Kafɔɔ Kilɛ ɲaha tàan, wu da ba duvɛn kelee kafugo yagbaga ka shishiin gbuu wɛ. Wu na ba ɲi Fɛfɛɛrɛ Munaa na, fo wu tigiduun ni. ");
INSERT INTO myk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wu na ba Izirayɛli wo sipyii niɲɛhɛmɛɛ ɲɛri pu Kafɔɔ Kilɛ kabaŋa yíri. ");
INSERT INTO myk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Sefɛɛrɛ munaa le lʼa bye Kilɛ tudunmɔɔ Eli ni ge, lee ninunɔ na ba bye wu bɛ ni wʼa ɲaari Kilɛ ɲaha tàan, kɔnhɔ wu tii ni pu nagoo tɛ yàa, wu Kilɛ ɲɔmɛɛ cobaalaa ɲɛri fo pʼa sipyitiiye fungɔnyɔ tuuyo ta, kɔnhɔ wu shi wu gbegele, wu wu yaha Kafɔɔ ɲaha na.» ");
INSERT INTO myk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A Zakari di mɛlɛkɛ wu pye: «Nɛ na lee cɛ viinŋɛ dii wɛ? Nɛ lɛ, nɛ shɔ bɛ dʼa shiɲɛhɛmɛ ta.» ");
INSERT INTO myk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A mɛlɛkɛ wu wu ɲɔ shɔ na: «Nɛ ɲɛ Gaburiyɛli. Nɛ yeree Kilɛ ɲaha tàan. Nɛ tun na pa ba jo ni ma ni, di pe Jozaama pe jo ma mu. ");
INSERT INTO myk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Li wii, ma ɲɔ na ba bɔ, ma da já jo wɛ, fo kii keree kii ɲɔ ba fa caŋa kemu, bani nɛ jomɔ pe pu da ba fa pu tuun ni ge, mu ya dà pee na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sipyii pu bɛɛri bi Zakari sigee. Wu na mɔ Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, a lee di bye pu mu kakanhana. ");
INSERT INTO myk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wʼa foro tuun wemu ni ge, wu ya já jo ni pu ni wɛ. A pʼi li cɛ na kashɛɛ la wʼa ɲa na wu yaha Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Na wu yaha wu ya já jo wɛ, a wʼi ɲaha shɛshɛɛrɛ ta pye ni keye ni. ");
INSERT INTO myk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakari wo labye wu cabyaa ki ɲɔ ya pa fa ge, a wu guri kari wu puga. ");
INSERT INTO myk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A cabyaa kii di doro, a wu shɔ Elizabɛti di yere yacɛrɛ na, na ŋmɔhɔ yebyaa kaguro, na jo: ");
INSERT INTO myk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kafɔɔ Kilɛ wʼa li pye mu nɛ mu, wʼa wu ɲii taha nɛ na tuun wemu ni ge, na nɛ fanhara keree laha nɛ ɲuŋɔ ni sipyii tɛ ni.» ");
INSERT INTO myk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛti laa li yeŋɛ gbaara wogo ki na, a Kilɛ di mɛlɛkɛ Gaburiyɛli tun kari Galile kulo la ni; lee mɛgɛ ɲɛ Nazarɛti, ");
INSERT INTO myk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","na shɛ nacɛbaa doɲiŋɛ fucɛri wa mu. Ná wa wu bi wee co, wee mɛgɛ ɲɛ Yusufu; Dawuda shi wu ni wʼa foro. Nacɛbaa doɲiŋɛ fucɛri wu mɛgɛ ki bye Mariyama. ");
INSERT INTO myk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A mɛlɛkɛ wu jé wà wu yíri, na wu pye: «Fɛrɛmɛ bye, mu we wʼa ɲaɲiŋɛ ta ge, Kafɔɔ Kilɛ wa ni mu ni.» ");
INSERT INTO myk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A Mariyama hakili di wuregi pee jomɔ pe wuu na, wu bi wu funŋɔ shaa na, we fò we kɔri na já bye lekɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A mɛlɛkɛ wu wu pye: «Ma ganha fya wɛ Mariyama, bani mʼa fɛrɛmɛ ta Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Li wii, ma na ba yere yacɛrɛ na, na ja se, ma na ba wee mɛgɛ le Yesu. ");
INSERT INTO myk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wu na ba bye sipyigbɔ, wu na ba yiri Kilɛ-gbɔtabaaga Ja. Kafɔɔ Kilɛ na ba wu tolɛ Dawuda wo saanra koro li kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wu na ba bye saan Yakuba shi wu ɲuŋɔ ni gbee; wu saanra tʼa da ga xhɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A Mariyama di mɛlɛkɛ wu pye: «Lee na ba bye pyegana lekɛ na wɛ, bani nɛ sanha ná shi cɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A mɛlɛkɛ wu wu ɲɔ shɔ na: «Fɛfɛɛrɛ Munaa na ba digi ma na. Kilɛ-gbɔtabaaga sefɛɛrɛ ti ɲimɛ na ba ma tɔ. Lee wuu na Fɛfɛɛrɛ Ja we ma da ba se ge, wu na ba yiri Kilɛ Ja. ");
INSERT INTO myk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Li wii, ma ceboroshɔ Elizabɛti wemu wʼa lɛ ge, wee bɛ wʼa yere yacɛrɛ na, wu na ba ja se. Wee wemu wu bi yiri na seganha ge, ke yeŋɛ ke wa wu laa li yeŋɛ gbaara wogo. ");
INSERT INTO myk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bani yafiin ya Kilɛ jani wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wee tuun wu ni a Mariyama di jo: «Kafɔɔ Kilɛ bulozhɔ wu we nɛ, wu li pye na mu ba mʼa li jo wɛ.» Lee kadugo na a mɛlɛkɛ wu gari, na laha wu tàan. ");
INSERT INTO myk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wee tuun wu ni a Mariyama di yìri, na gari tɔvuyo na faaboboyo fiige ki ni, na shɛ nɔ Zhude kulo la ni, ");
INSERT INTO myk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","na jé Zakari kaban, na Elizabɛti shaari. ");
INSERT INTO myk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ba Elizabɛti ya Mariyama fò mujuu li logo wɛ, a pya wu ɲɛhɛ wu funŋɔ ni. A Elizabɛti di ɲi Fɛfɛɛrɛ Munaa na. ");
INSERT INTO myk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A wu mujuugbɔɔ wá na: «Mu ɲɛ duba pya na toro cèe pusamaa bɛɛri tàan! Pya we ma da ba se ge, wee bɛ ɲɛ duba pya! ");
INSERT INTO myk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jɔgɔ nɛ ɲɛ fo na Kafɔɔ bɛ nu wu na pa foro na na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Li wii nɛ mu fò mujuu li logo tuun wemu ni ge, a pya wu fundanga wo di ɲɛhɛ nɛ funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mariyama, mu ɲɛ duba pya, bani Kafɔɔ Kilɛ ya yemu jo mu mu ge, mu ya dà li na na yee ɲɔ na ba fa!» ");
INSERT INTO myk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A Mariyama di jo: «Nɛ Kafɔɔ Kilɛ pɛlɛ na zɔ wu na. ");
INSERT INTO myk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na funŋɔ nidanga wo wu ɲɛ na Shɔvɔɔ Kilɛ ni, ");
INSERT INTO myk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","bani wu bulozhɔ we wʼa wuyɛ tirige ge, wʼa wu ɲii taha wu na. Li wii, na co nimɛ na, shi we wʼa ma ge, wu bɛɛri na ba nɛ pyi duba pya, ");
INSERT INTO myk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bani Se Bɛɛri Fɔɔ Kilɛ ya kagbɔɔ pye nɛ mu, wu mɛgɛ ki ɲɛ fɛɛfɛɛ. ");
INSERT INTO myk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wʼa ɲuŋɔ ɲaari wu ɲìi fyaara sipyii na, fo na shɛ nɔ pu shi nibama wu bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wʼa sefɛɛrɛ keree pye ni wu keye ni, na tabaara fungɔnyɔ caaga. ");
INSERT INTO myk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wʼa fanhafɛɛ tirige na laha pu saanra korogoo na, pii pʼa tigi ge, na pee yirige. ");
INSERT INTO myk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wʼa xuugo fɛɛ tin yalijeŋɛɛ na, na lafɛɛ kewaya wuu yaha kari. ");
INSERT INTO myk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wʼa wu kapyebye Izirayɛli wu tɛgɛ. A wu funŋɔ di do ni wuyɛ pyaa ɲiɲaara keree ki ni ");
INSERT INTO myk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ibirayima ni wu kadugo ki shizhaa na fo gbee ma na jo, ba wʼa bi ɲɔmɛɛ li lɔ wù sefɛlɛɛ pu mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A Mariyama di gori Elizabɛti yíri, na yeye taanri shishiin pye. Lee kadugo na na guri kari wu puga. ");
INSERT INTO myk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabɛti tigiduun ya pa nɔ ge, a wu funana se. ");
INSERT INTO myk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ba wu tiinɲii ni wu cebooloo pʼa logo na Kafɔɔ Kilɛ ya wu ɲiɲaara ti pɛlɛ wu shizhaa na wɛ, na binnɛ funŋɔ tàan ni wu ni. ");
INSERT INTO myk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pya wu cazege caŋa gbarataanri wogo, a pʼi ba di ba wu cekɔɔnrɔ pye. Pu funŋɔ bye pʼi wu to Zakari mɛgɛ le wu na, ");
INSERT INTO myk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ga, a nufɔɔ wu jo na: «Ahayi, wu mɛgɛ ki da le Yohana.» ");
INSERT INTO myk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A pʼi wu pye na: «Ga mu sipya wa shishiin mɛgɛ di wa mu-i dɛ?» ");
INSERT INTO myk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A pʼi pya wu to wu yege ni ɲaha shɛshɛɛrɛ ni, na wu funŋɔ wa wu mɛgɛ kekɛ le pya wu na wɛ? ");
INSERT INTO myk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A Zakari di walaa sha pu mu, na yi ka wu na na: «Wu mɛgɛ ki wa Yohana.» A lʼi pu bɛɛri fo. ");
INSERT INTO myk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Taapile ni a Zakari ɲɔ kʼi mugi, a wu já na yu, na Kilɛ sɔ. ");
INSERT INTO myk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A pu tiinɲii pu bɛɛri di fya. Sipyii pu bi lee nibyii le yu Zhude faaboboyo fiige ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yi logovɛɛ bɛɛri bi pu funyɔ shaa ni kii keree kii ni, a pʼi jo: «We pya we na ba bye ɲaha wɛ?» Bani Kafɔɔ Kilɛ wo sefɛɛrɛ ti bye wu na. ");
INSERT INTO myk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wee tuun wu ni a pya wu to Zakari di ɲi Fɛfɛɛrɛ Munaa na. A wu kapaŋaa jo na: ");
INSERT INTO myk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Kafɔɔ Izirayɛli wo Kilɛ we wʼa sɔni, bani wʼa wu ɲii taha wu sipyii pu na, na pu ɲuŋɔ wolo. ");
INSERT INTO myk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wʼa Shɔvɔɔ baraga wo yirige wèe mu na foro wu kapyebye Dawuda shi wu ni. ");
INSERT INTO myk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wu bi wee kaa jo fo taatuunnɔ ni wu tudunmɔɔ fɛfɛɛrɛ wuu pu ɲɔ ni, ");
INSERT INTO myk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","na wu na ba wèe tánha wù pɛɛn na, na wù shɔ na wù wolo wù kɔvɛɛ bɛɛri keŋɛ ni, ");
INSERT INTO myk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","na wu ɲiɲaara keree ɲɔ fa wù sefɛlɛɛ pu shizhaa na, na wu fungɔngɔ yaha wu fɛfɛɛrɛ ɲɔmɛɛ li na. ");
INSERT INTO myk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wu bi kàa wù sefɛlɛ Ibirayima mu, ");
INSERT INTO myk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na wu na ba wù shɔ wù pɛɛn na, kɔnhɔ wù lowagaa wuu di da labye pyi wu mu, ");
INSERT INTO myk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wù bye fɛfɛɛrɛ wuu, nidiimɛɛ wu ɲaha tàan wù shi wu caŋa ɲɛhɛɛ ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mu bɛ na pya, ma na ba yiri Kilɛ-gbɔtabaaga tudunmɔ, bani ma na ba ɲaari Kafɔɔ ɲahagbaa na, na wu korogoo ki yari. ");
INSERT INTO myk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma na ba li shɛ wu sipyii pu na na wu na ba ɲuwuuro kan pu mu, bani pu jurumu wʼa yafa pu mu ");
INSERT INTO myk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","wèe wo Kilɛ wu wo ɲiɲaara te ni wu saama pu gbɔɔrɔ ni. Yee gbɔɔrɔ ni ɲimuguŋɔ ya nɔ wèe na na yìri fugba we ni. ");
INSERT INTO myk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Pii pʼa tiin piige ni ni xu ɲimɛ ni ge, wʼa kpɛɛngɛ yeege pee mu, na wèe tɔɔyɔ yaha ɲaɲiŋɛ koo ni.» ");
INSERT INTO myk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ayiwa, wee pya wu bi lɛgi, na se ɲaha na fungɔngɔ fɛɛrɛ ni. A wu gori siwaga ki ni, fo na shɛ wu shɛduun nɔ Izirayɛli na. ");
INSERT INTO myk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wee tuun wu ni Oromɛ saannaa Ogusiti bi tuduro kan na fiiye yi sipyii pu bɛɛri mɛyɛ yi ka. ");
INSERT INTO myk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pee kama pu nizhiimɛ ya Kirinusi ta wu ɲɛ Siiri fiige ki gbafɛnɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A sipyii pu bɛɛri di gari pu kulogoo ni, kɔnhɔ pu mɛyɛ di shɛ ga wà. ");
INSERT INTO myk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A Yusufu bɛ di foro Nazarɛti ni, lee ɲɛ Galile fiige ki kulo la. Na gari Bɛtilɛhɛmu kulo li ni Zhude fiige ki ni, lee ɲɛ saannaa Dawuda wo kulo le. Bani Dawuda shi shɛn wu ɲɛ wii. ");
INSERT INTO myk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A wu gari wà, kɔnhɔ wu ni wu curɔ Mariyama mɛyɛ di shɛ ga. Mariyama laa wo wu bye. ");
INSERT INTO myk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na pu yaha Bɛtilɛhɛmu ni, a Mariyama tigiduun di nɔ. ");
INSERT INTO myk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A wu wu funazhiire se, na fàya migile pya wu na, na wu sinniŋɛ shɔngɔ logbakɔrɔ ni, bani pu ya xuu ta nabuun tatigiŋɛ puga ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatɔɔnahamaa pii bye kee fiige ki ni, pee bi shuun ɲìi na sipoŋɔ ki ni, na pu yatɔɔyɔ kasɛri. ");
INSERT INTO myk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A Kilɛ wo mɛlɛkɛ wa di ba yere pu ɲɔ na. A Kafɔɔ Kilɛ wo nɔɔrɔ wu ɲí ɲí pu kabaya yi bɛɛri na. A pʼi fya xuuni. ");
INSERT INTO myk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ga, a mɛlɛkɛ wu pu pye: «Yi ganha fya wɛ, bani fundangbɔhɔ Jozaama nʼa da jo yi mu, pee na ba bye sipyii pu bɛɛri wo. ");
INSERT INTO myk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wii mɛ, Shɔvɔɔ wʼa se niɲaa yee mu Dawuda kulo li ni, wee wu ɲɛ Kirisa we, na nɔhɔ pye Kafɔɔ we. ");
INSERT INTO myk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Li ɲaha shɛshɛɛrɛ ti wa te, yi na ba pubinnɛ la ɲa, fàya na migile li na, na li sinniŋɛ shɔngɔ logbakɔrɔ ni.» ");
INSERT INTO myk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Taapile ni a mɛlɛkɛɛ kuruyo niɲɛhɛyɛ di ba binnɛ wee mɛlɛkɛ wu tàan, na yìri fugba we ni. Pu bi Kilɛ sɔni na yu: ");
INSERT INTO myk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Kilɛ wʼa sɔni fugba lii lii we ni! Ɲaɲiŋɛ ki pye ɲiŋɛ ke na wu ɲidaan sipyii niŋɛ ni!» ");
INSERT INTO myk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ba pee mɛlɛkɛɛ pʼa laha yatɔɔnahamaa pu tàan, na kari fugba we ni wɛ, a yatɔɔnahamaa pʼi yi jo puyɛ mu na: «Yi pa wù shɛ fo Bɛtilɛhɛmu ni. Le kapyexhɔɔ le kaa Kafɔɔ Kilɛ ya jo wù mu ge, wù shɛ li ɲa.» ");
INSERT INTO myk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A pʼi gari tɔvuyo na, na shɛ Mariyama ni Yusufu ta wà, ni pubinnɛ le; lee bi sinniŋɛ shɔngɔ logbakɔrɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ba pʼa pubinnɛ li ɲa wɛ, jomɔ pemu ya jo pu mu wee pya wu shizhaa na ge, a pʼi pee paari. ");
INSERT INTO myk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A lʼi bye kakanhana yatɔɔnahamaa pu jomɔ pu logovɛɛ pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A Mariyama di kii keree kii bɛɛri yaha wuyɛ funŋɔ ni, na wu funŋɔ kɔɔn ki na. ");
INSERT INTO myk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lee kadugo na a yatɔɔnahamaa pʼi guri, na ganha na Kilɛ pɛlɛ, na wu sɔni, na gaaŋi, pʼa keree kiimu logo, na kiimu ɲa ge, kee bɛɛri wuu na. Ki bɛɛri ya pye na bɛ ni mɛlɛkɛ wu wo jomɔ pu jogana li ni pu mu. ");
INSERT INTO myk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ba pubinnɛ li cabyaa gbarataanri wʼa fa wɛ, a pʼi wu cekɔɔnrɔ pye na wu mɛgɛ le Yesu. Mɛlɛkɛ wʼa bi kee mɛgɛ ke le wu na, na ta wu nu wu sanha yere wu yacɛrɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ba Mariyama sivɛɛrɛ ti cabyaa kʼa fa wɛ, na saha ni Kilɛ tudunmɔɔ Musa wo saliya wu ni, a Yusufu ni Mariyama di gari ni pya wu ni Zheruzalɛmu ni, na shɛ wu kan Kafɔɔ Kilɛ mu, ");
INSERT INTO myk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ma na jo ba lʼa ka Kafɔɔ Kilɛ wo saliya wu ni wɛ na: «Funazhiigee ki bɛɛri ki pye Kafɔɔ Kilɛ wogoo.» ");
INSERT INTO myk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kafɔɔ Kilɛ wo saliya wʼa bi fɛfɛɛrɛ saraga kemu kaa yu ge, a pʼi kee bɛ wolo: «Xobangaa shuun kelee gbegbe shazhibiye shuun.» ");
INSERT INTO myk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ná wa bye Zheruzalɛmu ni wu mɛgɛ ɲɛ na Simiɲɔ. Sipyitiimɛ, Kilɛ ɲìi fyaara sipya wu bye wii. Wu bi Izirayɛli wo Shɔvɔɔ wu sigee; Fɛfɛɛrɛ Munaa bye wu na. ");
INSERT INTO myk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lee bi li shɛ wu na na Kilɛ na ba Shɔvɔɔ wemu tun na pa ge, na Simiɲɔ da xhu ni wu ya wu ɲii taha wee na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Fɛfɛɛrɛ Munaa lʼi wu ɲaha co na kari Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Tuun wemu ni Yesu sefɛɛ pʼa jé ni wu ni saliya wu keree ki zhɔɔnri wuu na ge, ");
INSERT INTO myk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a Simiɲɔ di pubinnɛ li lɔ wu keye ni, na Kilɛ sɔ na jo: ");
INSERT INTO myk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kafɔɔ Kilɛ, nimɛ ma na já ma bulo wu yaha wʼa gaaŋi ɲaɲiŋɛ na, na bɛ ni ma jomɔ pu ni, ");
INSERT INTO myk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","bani na ɲii lʼa Shɔvɔɔ wu ɲa, ");
INSERT INTO myk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mʼa wemu gbegele sipyii pu bɛɛri mu ge. ");
INSERT INTO myk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wu na ba bye kpɛɛngɛ, na kpɛɛngɛ yeege shi wu bɛɛri mu, ali wemu bɛ ɲɛ Yawutuu wɛ, na nɔɔrɔ taha Izirayɛli, ma sipyii pu na.» ");
INSERT INTO myk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiɲɔ ya jomɔ pemu jo Yesu shizhaa na ge, a pee di bye kakanhana pya wu to ni wu nu wu mu. ");
INSERT INTO myk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","A Simiɲɔ di duba pye pu mu, na yi jo pya wu nu Mariyama mu na: «Li wii, we pya we ya pa Izirayɛli shɛɛn niɲɛhɛmɛɛ tuuro ni pu yirige wuu na. Wu na ba bye ɲaha shɛshɛɛrɛ, nakaara na ba byi temu keree na ge, ");
INSERT INTO myk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kɔnhɔ sipyiɲɛhɛmɛɛ fungɔnyɔ di foro kpɛɛngɛ na. Mu kunni Mariyama, nɛrɛ wa na ba mu kanha, kanna ŋmɔpara lʼa ma zɔ su.» ");
INSERT INTO myk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cee Kilɛ tudunmɔ wa bɛ bye wà, wee mɛgɛ bye Anɛ. Fanuwɛli poro wu bye wii, Azɛri shi wu ni wʼa foro. Wu bi shi niɲɛhɛmɛ ta. Wu doɲiŋɛ wo, nacɛbaa wo wʼa kan ná wa mu. A wu yee gbarashuun pye ni wee ná wu ni, lee kadugo na a ná wu xhu. ");
INSERT INTO myk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A wu gori mu. Wu shi wu bi yee kɛlɛɛ gbarataanri ni shɛshɛɛrɛ (84) xɔ. Wu bi foro Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni wɛ, ga wu bi Kilɛ pɛlɛ caŋa fara piige na, na suun leni na Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A wee di nɔ pu na wee tuun wuyɛ pyaa ni, na baraga taha Kilɛ na. A wu jo wee pya wu shizhaa na ɲuwuuro ti sigevɛɛ pu bɛɛri mu Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kafɔɔ Kilɛ ya ɲɔmɛhɛɛ kiimu jo saliya Kitabu wu ni pya gan na Kilɛ mu ge, ba Yesu sefɛɛ pʼa kee bɛɛri ɲɔ fa wɛ, na guri pa Galile fiige ki ni, na gari Nazarɛti ni. Lee ɲɛ puyɛ pyaa wo kulo le. ");
INSERT INTO myk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pya wu bi lɛgi, na baraga taa. Wu bi ɲi fungɔngɔ fɛɛrɛ na, Kilɛ wo fɛrɛmɛ pe bye wu na. ");
INSERT INTO myk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kilɛ ya Yawutuu ɲuŋɔ wolo bulooro ni Misira fiige ki ni. A tee Ɲuwuuro tʼi ɲɛri kalenɛ pu mu. Yee bɛɛri Yesu sefɛɛ pu na shɛ lee kalenɛ le gba Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ba Yesu ya yee kɛ ni shuun ta wɛ, a pʼi gari Zheruzalɛmu ni kalenɛ li ni, na bɛ ni pu wo kalɛɛ li ni. ");
INSERT INTO myk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba kalenɛ li cabyaa kʼa fa wɛ, a pʼi koo lɔ na se puga, ga, a Yesu nɔhɔcɛɛrɛ wo wu gori pu kadugo Zheruzalɛmu ni, wu sefɛɛ pu bi lee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A pʼi li yaha na Yesu na da ni pee ɲaariɲii pu ni. A pʼi caŋa nigin ɲara pye na wu shaa pu cebooloo, ni pu cɛvɛɛ pu tɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pu ya wu ɲa-ɛ ge, na guri pa wu sha Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cabyaa taanri nidorogo na, a pʼi shɛ wu ta Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, wu nidɛɛngɛ ki bye saliya karamɔgɔlɔɔ pu niŋɛ ni, na pee jomɔ nuri, na pu yegee. ");
INSERT INTO myk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pii pu bi wu jomɔ pu nuri ge, a wu fungɔngɔ fɛɛrɛ te, ni wu ɲɔshɔɔrɔ ti pyegana di bye pu bɛɛri mu kakanhana. ");
INSERT INTO myk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ba wu sefɛɛ pʼa wu ɲa wɛ, a lʼi bye pu mu kakanhana, a wu nu wu wu pye: «Pya, lekɛ na mʼa le pye wù na wɛ? Li wii! Nɛ ni ma to wu funjɔnrɔgɔ wuu pu bi mu shaa.» ");
INSERT INTO myk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A wu pu pye: «Ɲaha na yi bi na shaa wɛ? Ta yee ya li cɛ na nɛ yaa na ta na To Kilɛ wu puga ki ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ga jomɔ pe wʼa jo pu mu ge, pu ya pee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A Yesu di gari ni pu ni Nazarɛti ni, na guu pu mu. A wu nu wu kunni di kii keree kii bɛɛri yaha wuyɛ funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu bi lɛgi fungɔngɔ ni ceepuuro ni; a wu kaa di daan Kilɛ ni sipyii pu bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Oromɛ saannaa Tibɛri wo saanra ti yee kɛ ni kaguro wuu, lee wa bi Pɔnsi Pilate ta Zhude fiige ki gbafɛnɛɛri; Hɛrɔdi di bye Galile fiige ki ɲuŋɔ ni; wu ceborona Filipe di bye Iture ni Tirakoniti, yee fiiye yi ɲuŋɔ ni; Lisiɲasi di bye Abilɛni fiige ki ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anɛ ni Kayifɛ bi bye saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ. Wee tuun wu ninumɔ ni, a Kilɛ jomɔ pʼi nɔ Zakari ja Yohana na na wu yaha siwaga ki ni. ");
INSERT INTO myk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana bi Zhurudɛn Gba lɔhɔ ki kulogoo ki bɛɛri ɲaari, na Kilɛ jomɔ pu yɛrɛ pyi sipyii pu mu na pu daajeŋɛ jo pu jurumu wu na pʼi batize, kɔnhɔ pu jurumu wʼi yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ma na jo ba lʼa ka Kilɛ tudunmɔɔ Ezayi wo Kitabu wu ni wɛ na: «Mujuu lʼa fòro siwaga ki ni na: ‹Yi Kafɔɔ wu koo li yàa! Yi wu korogoo ki tii! ");
INSERT INTO myk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Loguuyo ye bɛɛri na ba ɲi daanna. Faaboboyo ni boboŋɔɔ ki bɛɛri na ba digi na daanna. Konahaya ye bɛɛri na ba dii. Takokaya ye bɛɛri ɲɔ na ba daanna. ");
INSERT INTO myk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kilɛ ya Adama nagoo shuu shɔgana lemu na ge, sipyii bɛɛri na ba lee ɲa.›» ");
INSERT INTO myk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sipyii pii pu bi ma na batizeni Yohana mu ge, wu bi yi yu pee mu na: «Yee matɔn nagoo piiri, jɔgɔ wʼa yee kaala na yee pu paa Kilɛ wo loyire nibana le ɲaha na wɛ? ");
INSERT INTO myk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kapyegee kiimu kʼa li shɛɛ na yʼa daajeŋɛ jo yi jurumu wu na ge, yʼa kee pyi. Yi ganha ba yu yiyɛ funyɔ ni na Ibirayima wu ɲɛ yee to wɛ. Bani nʼa da yi jo yi mu, Kilɛ na já ye faakageeye ye ɲɛri na pye Ibirayima nagoo. ");
INSERT INTO myk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ali nimɛ, kacerege kʼa lɔ na xɔ, di da tiye yi niyɛ yi cere. Tige bɛɛri ki ɲɛ ki ya nagoo nizaamaa pyi-i ge, kee na ba gɔn, na ki wá na ni.» ");
INSERT INTO myk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A sipyiire tʼi ganha na wu yegee na: «Wee tuun wu ni wèe ya yaa na lekɛ pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A wu pu ɲɔ shɔ na: «Fadeye shuun ɲɛ wemu mu ge, wu nigin kan funmɔ fɔɔ mu. Yalige yaaga ɲɛ wemu mu ge, wu bɛ wu li pye mu.» ");
INSERT INTO myk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A fanhafɛɛ wari shɔvɔɔ pii bɛ di ba, kɔnhɔ pʼi batize, a pee di wu pye na: «Karamɔgɔ, wèe ya yaa na lekɛ pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A wu pu ɲɔ shɔ na: «We kaa lʼa jo yi mu ge, yi ganha da yaaga shɔ di doro wee ɲuŋɔ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A sɔrɔsii pii bɛ di wu yege na: «Wèe do, wèe ya yaa na lekɛ pye wɛ?» A wu pu pye: «Yi ganha bu sipya wa shishiin wo wari shɔ wu na fanha na wɛ. Yi ganha kafinɛyɛ taga wa shishiin tɔɔgɔ le wɛ. Yʼi yiyɛ yaha yi saraa na.» ");
INSERT INTO myk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sipyii pu bi lee ɲibaŋa sigee, pu bɛɛri bi pu funyɔ kɔɔn Yohana shizhaa na, wu bu da wee ɲɛ Kirisa wu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A Yohana di pu bɛɛri ɲɔ shɔ na: «Nɛ kunni wa yee batizeni lɔhɔ yɛ ni. Ga wa wʼa ma, wee fanha ya ɲɛhɛ nɛ wogo na. Nɛ yaa ni wu tanhaya mɛɛrɛ bɛ zanha ni wɛ. Wee na ba yi batize Fɛfɛɛrɛ Munaa ni na ni. ");
INSERT INTO myk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wu shinma fɔ̀ fɔ̀ yaaga ki wa wu keŋɛ ni, wu na ba wu shinma saŋa ki foolo na wolo sigiye yi ni. Wu na ba shinma pya wu le wu kpɔɔn ni. Ga wu na ba sigiye yi sòrogo nafugibaaga ni.» ");
INSERT INTO myk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana bi jomɔ patii niɲɛhɛmɛ bɛ taga na sipyii pu yɛri, na Kilɛ wo Jozaama pe yu pu mu. ");
INSERT INTO myk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ga Yohana bi fiige ki ɲuŋɔfɔɔ Hɛrɔdi nahama shɛ wu na. Bani wee bi wu ceborona Filipe shɔ Hɛrɔjasi kɔn shɔ wu na. Na wu nahama jo wu na wu kakuuyo yi saya bɛɛri bɛ wuu na. ");
INSERT INTO myk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lee kadugo na a Hɛrɔdi di kakuunɔ la bɛ pye sanha na Yohana le kaso ni. ");
INSERT INTO myk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ba sipyii pu bɛɛri ya batize xɔ wɛ, a Yesu bɛ di batize. Na wu yaha Kilɛ-ɲɛrɛgɛ ki na, a fugba wu ɲɔ di mugi; ");
INSERT INTO myk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a Fɛfɛɛrɛ Munaa di digi wu na, ba gbegbe shazhira ɲɛ wɛ. A mujuu la di foro fugba wu ni na: «Mu ɲɛ nɛ ɲidaan Ja, mu kaa ya dan nɛ ni tɛhɛnɛ baa.» ");
INSERT INTO myk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ya wu labye wu ɲɔ kɔn tuun wemu ni ge, wu shi wu bi yee kɛlɛɛ taanri (30) shi xɔ. Sipyii fungɔngɔ na na Yusufu ja wu ɲɛ wii. Yusufu bi bye Heli ja. ");
INSERT INTO myk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ya foro Matati ni. Matati di foro Levi ni. Levi di foro Mɛliki ni. Mɛliki di foro Zhanayi ni. Zhanayi di foro Yusufu ni. ");
INSERT INTO myk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu di foro Matitiya ni. Matitiya di foro Amɔsi ni. Amɔsi di foro Naxhumi ni. Naxhumi di foro Esili ni. Esili di foro Nagayi ni. ");
INSERT INTO myk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi di foro Makati ni. Makati di foro Matitiya ni. Matitiya di foro Simeyi ni. Simeyi di foro Zhosɛki ni. Zhosɛki di foro Zhoda ni. ");
INSERT INTO myk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zhoda di foro Zhokana ni. Zhokana di foro Ɛrɛsa ni. Ɛrɛsa di foro Zorobabɛli ni. Zorobabɛli di foro Salacɛli ni. Salacɛli di foro Nɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛri di foro Mɛliki ni. Mɛliki di foro Adi ni. Adi di foro Kɔsamu ni. Kɔsamu di foro Elimada ni. Elimada di foro Eri ni. ");
INSERT INTO myk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri di foro Zhozuwe ni. Zhozuwe di foro Elizɛri ni. Elizɛri di foro Zhorimu ni. Zhorimu di foro Matati ni. Matati di foro Levi ni. ");
INSERT INTO myk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi di foro Simiɲɔ ni. Simiɲɔ di foro Zhuda ni. Zhuda di foro Yusufu ni. Yusufu di foro Zhɔnamu ni. Zhɔnamu di foro Eliyakimu ni. ");
INSERT INTO myk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu di foro Mɛlɛya ni. Mɛlɛya di foro Mɛna ni. Mɛna di foro Matata ni. Matata di foro Natan ni. Natan di foro Dawuda ni. ");
INSERT INTO myk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda di foro Zhese ni. Zhese di foro Obɛdi ni. Obɛdi di foro Bowazi ni. Bowazi di foro Salimɔ ni. Salimɔ di foro Nasɔn ni. ");
INSERT INTO myk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔn di foro Aminadabi ni. Aminadabi di foro Adamini ni. Adamini di foro Arini ni. Arini di foro Ɛsirɔmu ni. Ɛsirɔmu di foro Pɛrɛzi ni. Pɛrɛzi di foro Zhuda ni. ");
INSERT INTO myk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zhuda di foro Yakuba ni. Yakuba di foro Ishaaga ni. Ishaaga di foro Ibirayima ni. Ibirayima di foro Teraki ni. Teraki di foro Nakɔri ni. Nakɔri di foro Serugi ni. ");
INSERT INTO myk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serugi di foro Eregu ni. Eregu di foro Pɛlɛgi ni. Pɛlɛgi di foro Hɛbɛri ni. Hɛbɛri di foro Selaki ni. ");
INSERT INTO myk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selaki di foro Kayinamu ni. Kayinamu di foro Aripakisadi ni. Aripakisadi di foro Sɛmu ni. Sɛmu di foro Nuxhun ni. Nuxhun di foro Lɛmɛki ni. ");
INSERT INTO myk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lɛmɛki di foro Mɛtusela ni. Mɛtusela di foro Henɔki ni. Henɔki di foro Zhɛrɛdi ni. Zhɛrɛdi di foro Malelɛli ni. Malelɛli di foro Kena ni. ");
INSERT INTO myk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kena di foro Enɔsi ni. Enɔsi di foro Sɛti ni. Sɛti di foro Adama ni. Adama di foro Kilɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ba Yesu ya ɲi Fɛfɛɛrɛ Munaa li na wɛ, na guri yìri Zhurudɛn Gba wu ɲɔ ki na. A Fɛfɛɛrɛ Munaa di wu ɲaha co na kari siwaga ki ni. ");
INSERT INTO myk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A wu cabyaa kɛlɛɛ shɛshɛɛrɛ (40) pye Shitaanni na wu taanna na wii. Wu ya ta yalige ka shishiin li yee caya yi na wɛ. Yee caya yi na toro xɔ, a xuugo di wu ta. ");
INSERT INTO myk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wee tuun wu ni a Shitaanni di wu pye: «Ma bi ɲɛ Kilɛ wo Ja we, ke faakagereŋɛ ke pye na ki ɲɛri buuri.» ");
INSERT INTO myk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A Yesu di wu ɲɔ shɔ na: «Lʼa ka Kilɛ Kafila wu ni na: ‹Ɲɔ yalige yɛ wa sipya ɲɔ shaa wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lee kadugo na a Shitaanni di gari ni wu ni fugba ni, na shɛ koŋɔ saanra ti bɛɛri shɛ wu na taapile ni. ");
INSERT INTO myk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A Shitaanni di wu pye: «Nɛ na te ɲuŋɔ fɛɛrɛ te ni ti nɔɔrɔ wu bɛɛri kan ma mu, bani tʼa jé nɛ keŋɛ ni. Nʼa giin di ti kan wemu mu ge, di ti kan wee mu. ");
INSERT INTO myk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma bu nuguro sin nɛ fɛɛ ni, yee bɛɛri na bye ma woyo.» ");
INSERT INTO myk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A Yesu di wu ɲɔ shɔ na: «Lʼa ka Kilɛ Kafila wu ni na: ‹Mʼa ma Kafɔɔ Kilɛ yɛ pɛlɛ, ma da labye pyi wee yɛ nigin mu.›» ");
INSERT INTO myk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A Shitaanni di wu ɲaha co sanha, na kari Zheruzalɛmu ni, na wu yaha Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲidii li ni, na wu pye: «Ma bi ɲɛ Kilɛ wo Ja we, kɔn to ɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bani lʼa ka Kilɛ Kafila wu ni na: ‹Kilɛ na ma kaa jo wu mɛlɛkɛɛ pu mu na pʼa ma kasɛri. ");
INSERT INTO myk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pu na ma co pu keye ni, kɔnhɔ ma tɔɔgɔ ganha bu guu kagereŋɛ yafiin na wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A Yesu di wu ɲɔ shɔ na: «Lʼa ka Kilɛ Kafila wu ni na: ‹Ma ganha bu ma Kafɔɔ Kilɛ taanna wii wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ba Shitaanni ya xɔ tee nɔwuuro ti bɛɛri ni wɛ, na gari na wu yaha wà, fo wu ɲidaan tuun wa bɛtii. ");
INSERT INTO myk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A Yesu di guri shɛ Galile fiige ki ni Fɛfɛɛrɛ Munaa gbɔɔrɔ ni. Wu mɛgɛ ki bi foro fiige ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wʼa bi sipyii kalaa pu Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, sipyii pu bɛɛri di wu pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu ya nɔ Nazarɛti ni, xuu wemu ni wʼa bii ge, na jé Kilɛ-pɛɛŋɛ puga ki ni cadɛɛngɛ ki ni, na yìri yere, kɔnhɔ wu Kitabu wu kalaa. ");
INSERT INTO myk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A pʼi Kilɛ tudunmɔɔ Ezayi wo Kitabu wu kan wu mu. A wu wu ɲɔ mugi na xuu wa ta wà, lʼa ka wà na: ");
INSERT INTO myk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Kafɔɔ Munaa wa nɛ na, bani wʼa nɛ tìre, kɔnhɔ nɛ Kilɛ Jozaama jo la baa fɛɛ mu. Wʼa nɛ tun na nɛ wu buloo ni kasolemɛɛ faha, di fyɛnmɛɛ ɲɛmugunɔ yɛrɛ pye, di cɔnrɔmɔ fɛɛ wolo pu kanhama ni, ");
INSERT INTO myk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","di Kafɔɔ wo fɛrɛmɛ yee li yɛrɛ pye.» ");
INSERT INTO myk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lee kadugo na a Yesu di Kitabu wu ɲɔ tɔ, na wu kan kapyebye wu mu, na diin, kɔnhɔ wu da pu kalaa. A Kilɛ-pɛɛŋɛ puga ki sipyii pu bɛɛri di ɲahaya kɔ le wu ni. ");
INSERT INTO myk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wee tuun wu ni a Yesu di ɲɔ kɔn na yu pu mu na: «Pe Kitabu jomɔ pe yʼa logo niɲaa ge, pee ɲɔ ya fa.» ");
INSERT INTO myk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pu bɛɛri bi wu mɛsaaŋa yu. Jozaama pe wʼa jo ge, pee bye pu mu kakanhana. A pʼi ganha na yu na: «Ta we ɲɛ mɛ Yusufu ja wu wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A Yesu di pu pye: «Nakaara baa, yee na ba le talenɛ le jo na: ‹Wɛrɛ pyevɔɔ mayɛ cuuŋɔ.› Yee na ba jo na: ‹Keree kii mʼa pye Kapɛrinɔmɔ ni ge, wèe ya ki kaa logo, ki shi pye nahamɛ bɛ mayɛ pyaa kulo li ni.›» ");
INSERT INTO myk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A wu jo sanha na: «Can na nʼa da yi jo yi mu, Kilɛ tudunmɔ wa shishiin ya joni na ɲɔgi wuyɛ pyaa kulo ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ga nʼa da yi jo yi mu can na, naxhugoshaa niɲɛhɛmɛɛ bi bye Izirayɛli fiige ni Kilɛ tudunmɔɔ Eli caŋa ɲii ni, tuun wemu ni waga ya yere na ta yee taanri ni yeye gbaara ge. A xuugbɔhɔ di jé kee fiige ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lee bɛ na, Eli ya ta tun wa shishiin yíri pu ni wɛ, fo naxhugoshɔ wa, wee bye Sidɔn fiige kulo la ni, lee mɛgɛ ɲɛ Sarɛpita. ");
INSERT INTO myk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Togo fɛɛ niɲɛhɛmɛɛ bɛ di bi bye Izirayɛli fiige ki ni Kilɛ tudunmɔɔ Elize caŋa ɲii ni. Lee bɛ na wa shishiin ya cuuŋɔ pee ni wɛ, fo Siiri fiige sipya wa, wee mɛgɛ ki bye Nama.» ");
INSERT INTO myk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ba Kilɛ-pɛɛŋɛ puga ki funŋɔ sipyii pu bɛɛri ya pee jomɔ pu logo wɛ, a pu logoo di yìri xuuni. ");
INSERT INTO myk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A pʼi yìri, na Yesu kile yeege kulo li ni. Pu kulo li bi yereŋɛ boboŋɔ kemu na ge, a pʼi gari ni wu ni kee ɲuŋɔ ni, na pʼi wu ŋmunuŋɔ shan boboŋɔ ki wege ki ni. ");
INSERT INTO myk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ga, a Yesu kunni di doro pu niŋɛ ni, na gari. ");
INSERT INTO myk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A Yesu di gari Galile kulo la ni, lee mɛgɛ ɲɛ Kapɛrinɔmɔ. Wʼa bi sipyii pu kalaa cadɛɛnyɛ yi na wà. ");
INSERT INTO myk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A wu kalaa wu kangana lʼi pu ɲaha wɔ xuuni, bani wʼa bi yu ni sefɛɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ná wa bye Kilɛ-pɛɛŋɛ puga ki ni jina na ɲɛ wu ni, a wu xhuulo ni mujuugbɔɔ ni na: ");
INSERT INTO myk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Eyi! Ɲaha mu di zhaa wèe fɛni wɛ Yesu Nazarɛti shɛn? Mʼa pa ba wù kyɛɛgi gɛ? Nɛ mu shi cɛ, Kilɛ Fɛfɛɛrɛ wo mu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A Yesu di din jina wu na na: «Cari mayɛ na! Mʼa foro we ná we ni!» A jina wu wu shan ɲiŋɛ na pu bɛɛri niŋɛ ni, na foro wu ni, wu ya yaaga pye wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A lʼi bye kakanhana sipyii pu bɛɛri mu, fo pu na puyɛ yegee na: «Le kaa le bɛ do? Fanha ni sefɛɛrɛ ni we ya yu ni jinaa ni, pʼi foro sipyii ni!» ");
INSERT INTO myk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lee wuu na Yesu mɛgɛ ya fiige ki bɛɛri círi. ");
INSERT INTO myk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ba Yesu ya foro Kilɛ-pɛɛŋɛ puga ki ni wɛ, na gari Simɔ kaban. Lee di Simɔ yafezhɔ niganhaŋa ta ceefuuro keŋɛ ni, a pʼi Yesu ɲɛɛri na wu wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A Yesu di shɛ leele wu ɲuŋɔ ni, na jo ni fanha ni na ceefuuro ti ti foro wu ni. A ceefuuro tʼi wu yaha. Taapile ni a wu yìri, na labye ɲɔ kɔn, na pu keree yàa. ");
INSERT INTO myk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Caŋa ki na to xɔ, a sipyii di shɛ wu yíri ni pu yama fɛɛ bɛɛri ni. A wu wu keye taha pu bɛɛri nigin nigin na, na pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A jinaa bɛ di foro sipyiɲɛhɛmɛɛ ni, pʼa bi zɛlɛ na: «Mu ɲɛ Kilɛ Ja we.» Ga, a Yesu di din pu na. Wu ya ta sɔɔ pu jo wɛ, bani pee ya cɛ na wee wu wa Kirisa we. ");
INSERT INTO myk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ba ɲiga kʼa mugi wɛ, a Yesu di yìri kari sipoŋɔ ki xuu wa ni. Sipyii pu bi wu shaa. Ba pʼa shɛ nɔ wu tàan wɛ, na wu kuuri kɔnhɔ wu ganha gari di pu yaha wɛ. ");
INSERT INTO myk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ga, a wu pu pye na: «Fanha ki wa kii nɛ wu Kilɛ saanra ti Jozaama pu jo kulogoo kisaŋaa bɛ ni, bani lee wuu na nɛ tun.» ");
INSERT INTO myk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wʼa bi Kilɛ Kafila wu yɛrɛ pyi Yawutuu fiige ki Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. ");
INSERT INTO myk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Caŋa ka na Yesu yaha Zhɛnɛzarɛti Gba lɔhɔ ki ɲɔ na, sipyii pu bi wu cɔnri, kɔnhɔ pʼi Kilɛ jomɔ logo. ");
INSERT INTO myk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A wu kɔrɔyɔ shuun wa ɲa gba lɔhɔ ki ɲɔ na, fyashaa pu na foro yi ni. Pee bi pu jɔlɔɔ jii. ");
INSERT INTO myk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A wu jé kee kɔrɔgɔ ka ni, kee bye Simɔ wogo, na li sha Simɔ mu na wu kɔrɔgɔ ki nunuŋɔ koɲɔ ki na jɛri. Ba lee ya pye wɛ, a wu diin kɔrɔgɔ ki ni, na sipyii pu kalaa. ");
INSERT INTO myk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ba Yesu ya xɔ jomɔ pu ni wɛ, a wu Simɔ pye: «Kɔrɔgɔ ki fulo tacogoŋɔ ki ni, yʼi yi jɔlɔɔ pu wá lɔhɔ ki ni fyaa pu fɛni!» ");
INSERT INTO myk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A Simɔ di wu ɲɔ shɔ na: «Karamɔgɔ, wèe ya shɔn labye na, wèe ya ta yafiin bɛ co wɛ. Ga, ma jomɔ pu wuu na, nɛ na jɔ̀ wu wá lɔhɔ ki ni.» ");
INSERT INTO myk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba lee ya pye wɛ, a pʼi fyaɲɛhɛmɛɛ co, fo pu jɔ̀ wʼa ɲɔ kɔn na gɔɔn. ");
INSERT INTO myk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A pʼi ganha na pu kaafɛɛ pii kani ni keye ni kɔrɔgɔ katii ni, na pu pa pu tɛgɛ. A pee di ba. A pʼi kɔrɔyɔ shuun wu bɛɛri ɲi, fo kɔrɔyɔ yi na zhaa da minɛɛ lɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ba Simɔ Pyɛɛri ya lee ɲa wɛ, a wu nuguro sin Yesu fɛɛ ni, na jo: «Kafɔɔ, laha nɛ tàan, bani jurumupye nɛ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pu na pii fyaɲɛhɛmɛɛ pii co, a lʼi bye kakanhana pu ni pu kaafɛɛ pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebede jalaa, Yakuba ni Yohana we wʼa bye Simɔ kariɲii ge, pee bɛ bi li ta kakanhana. A Yesu di Simɔ pye na: «Ma ganha da vya wɛ. Ga nimɛ, ma na ba bye sipyii shavɔɔ.» ");
INSERT INTO myk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wee tuun wu ni a pʼi ba kɔrɔyɔ yi yereŋɛ koɲɔ ki na, na yi bɛɛri yaha wà, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na Yesu yaha kulo la ni, ná wa bye wà, togo bye wu cére ti bɛɛri na. Ba wʼa Yesu ɲa tuun wemu ni wɛ, a wu do na wu ɲaha buri ɲiŋɛ na, na wu ɲɛɛri, na jo: «Kafɔɔ, mu bu sɔɔ, go mu na já nɛ cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A Yesu di wu keŋɛ yeege, na gbɔn wu na, na jo: «Nɛ sɔɔ mu wu cuuŋɔ!» Taapile ni a togo kʼi xhɔ. ");
INSERT INTO myk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A Yesu di yi waha wu mu na: «Ma ganha bu ye ɲaha jo wa shishiin bɛ mu wɛ. Ga, shɛ mayɛ shɛ saraya ɲaha shɔɔnrivɔɔ wu na! Musa ya saraga kemu kaa jo ge, mʼa kee wolo ma sicuumɔ pu da wuu na. Kee na ba li shɛ na mʼa cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lee bɛ na, a Yesu mɛgɛ di ganha na foro na se ɲaha na, fo sipyiire tʼa pa tiyɛ pinnɛ wu yíri, kɔnhɔ pʼi wu jomɔ pu logo, pu yama pu bɛ di xhɔ. ");
INSERT INTO myk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ga Yesu bi se na Kilɛ ɲɛɛri wu yɛ nigin sipoŋɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Caŋa ka na Yesu yaha wu na sipyii pu kalaa, Farizhɛɛn ni saliya karamɔgɔlɔɔ pii nidɛɛnyɛ bye wà. Pʼa bi pa na yìri Galile ni Zhude kulogoo ki bɛɛri ni, ni Zheruzalɛmu ni. Kafɔɔ wo sefɛɛrɛ ti bye Yesu ni na yama fɛɛ pu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A sipyii pii di ba ni ná kabanuxuyo shuun fɔɔ wa ni yasinnɛgɛ ka na. A pʼi ganha na wu shaa pʼi wu leŋɛ puga ki ni pu sinniŋɛ Yesu ɲaha tàan. ");
INSERT INTO myk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sipyii pu ɲɛhɛŋɛ keŋɛ ni, pu ya já gbara Yesu na wɛ. A pʼi dugi puga ki ɲuŋɔ ni na kataŋa ki xuu wa lahala, na wee ná we ni wu yasinnɛgɛ ki tirige kee wege ki ni, Yesu ɲaha tàan sipyii pu niŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ba Yesu ya pee wo nʼa daa wu ɲa wɛ, na jo: «Ná we, ma jurumu wʼa yafa ma mu.» ");
INSERT INTO myk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A saliya karamɔgɔlɔɔ ni Farizhɛɛn pʼi ganha na yu puyɛ funyɔ ni na: «We ná we ɲɛ sipya wekɛ wɛ, fo wu na Kilɛ mɛgɛ kyɛɛgi wɛ? Jɔgɔ wu dʼa já jurumu yafa sipya mu, ni Kilɛ yɛ bɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A Yesu di pu fungɔnyɔ cɛ, na pu pye na: «Ɲaha na ke fungɔngɔ ke tuugo dʼa tigi yee funyɔ ni wɛ? ");
INSERT INTO myk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na jo: ‹Ma jurumu wʼa yafa ma mu.› kelee na jo: ‹Yìri mʼa ma yasinnɛgɛ ki lɔ, ma da ɲaari.› Lekɛ lʼa faha wɛ? ");
INSERT INTO myk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ga, kɔnhɔ yʼi li cɛ na Sipya Ja wu yaha ɲiŋɛ ki na, se wa wu ni wʼa sipyii pu wo jurumu wu yafani pu mu…» A wu ná kabanuxuyo shuun fɔɔ wu pye: «Nɛ wʼa jo mu: Yìri, mʼa ma yasinnɛgɛ ki lɔ mʼa se puga!» ");
INSERT INTO myk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Taapile ni a wu yìri pu bɛɛri ɲii na, na wu yasinnɛgɛ ki lɔ na gaaŋi puga, na baraga tɛri Kilɛ na. ");
INSERT INTO myk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A lʼi bye kakanhana pu mu, fo pu na baraga tɛri Kilɛ na. A pʼi fya xuuni na yu: «Wèe ya kakanhana ɲa niɲaa.» ");
INSERT INTO myk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kii keree kii na toro xɔ, A Yesu di foro wà, na fanhafɛɛ wari shɔvɔɔ wa ɲa, wee mɛgɛ ki bye Levi. Wee nidɛɛngɛ ki bye fanhafɛɛ pu wari wu tashɔgɔ ki ni. A Yesu di wu pye: «Taha na fɛni!» ");
INSERT INTO myk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A Levi di yaŋmuyɔ yi bɛɛri yaha wà, na yìri, na daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lee kadugo na a Levi di ba yaligee niɲɛhɛŋɛɛ yàa Yesu mu wu kaban. Fanhafɛɛ wari shɔvɛɛ niɲɛhɛmɛɛ ni sipyiɲɛhɛmɛɛ piitiilee bɛ pu bi pinnɛ na li ni pu ni. ");
INSERT INTO myk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A Farizhɛɛn ni saliya karamɔgɔlɔɔ di ganha na wu zɔ yu. A pʼi Yesu kalaapiire ti pye: «Ɲaha na yee di li, na gbuu ni fanhafɛɛ wari shɔvɛɛ, ni jurumupyii piitiilee bɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Yesu di pu ɲɔ shɔ na: «Sicuumɔ fɛɛ mago ɲɛ wɛrɛ fɔɔ na wɛ, fo yama fɛɛ. ");
INSERT INTO myk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sipyii piimu pʼa tii ge, nɛ ta pa di ba pee yiri wɛ, fo jurumupyii, na pu yere pu jurumu wu na.» ");
INSERT INTO myk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sipyii pii ya jo ni Yesu ni, na: «Yohana Batizelipye wo kalaapiire te, ni Farizhɛɛn pu wo kalaapiire te, pee ya suun leni tɛɛgɛɛ niɲɛhɛŋɛɛ ni, na Kilɛ ɲɛɛri, na ta mu wo kalaapiire tʼi li na gbuu.» ");
INSERT INTO myk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A Yesu di pu ɲɔ shɔ na: «Nɛ ɲɛ ba cenabun poo ɲɛ wɛ. Yee na já cenabun poo kaafɛɛ karamu pu suun le, na pu ni cenabun poo wu yaha shiizhan ya? ");
INSERT INTO myk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ga caya ya wa ma, cenabun poo wu na ba shɔ pu na. Yee caya yi ba nɔ pu bɛ na suun leni.» ");
INSERT INTO myk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A Yesu di le talenɛ le bɛ jo pu mu na: «Wa shishiin da ga faɲunɔ shɛɛngi favoŋɔ na, di dara falɛgɛ na wɛ. Lee bu bye, favoŋɔ ki nizhɛɛngɛŋɛ na gori, favonɔ li bɛ da ga bɛ falɛgɛ ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wa shishiin di wa da ga duvɛnfomɔ le foroyo nilɛyɛ ni wɛ. Lee bu bye, duvɛnfomɔ wu na foroyo yi shɛɛngi, duvɛn wu na wo, foroyo yi bɛ na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ga duvɛnfomɔ ya yaa na le forofoyo ni. ");
INSERT INTO myk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ayiwa, we wʼa duvɛn nilɛ gba ge, wee da ga sɔɔ duvɛnfomɔ na wɛ, bani wʼa ma jo na: ‹Nilɛ wu wʼa taan.›» ");
INSERT INTO myk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cadɛɛngɛ ka ni, Yesu bi doroo shinma kɛrɛyɛ ya tɛ ni. A wu kalaapiire ti shinma sɛyɛ ya kɔn, na yi tuugo pu kadahaa ni, na wee pya wu kun. ");
INSERT INTO myk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A Farizhɛɛn pii di pu pye na: «Kaa lemu ya yaa li pye cadɛɛngɛ ni wɛ, ɲaha na yee di lee pyi wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A Yesu di pu pye: «Tuun wemu ni xuugo ya pa saannaa Dawuda ni wu tahama-nɔhɔmɔɔ pu ta ge, wʼa lemu pye ge, yee sanha lee kalaa ɲa bada-ɛ gɛ? ");
INSERT INTO myk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wʼa jé Kilɛ-pɛɛŋɛ puga ki ni, buuri we pʼa wo na gaan Kilɛ mu ge, na yee buuri ɲuyɔ ya lɔ na li, na ya kan wu tahama-nɔhɔmɔɔ pu bɛ mu. Na ta watii bi wee buuri we li ni saraya ɲaha shɔɔnrivɔɔ pu yɛ bɛ wɛ. Ta yee sanha lee kalaa wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A Yesu di pu pye sanha: «Sipya Ja wu ɲɛ cadɛɛngɛ ki bɛ Kafɔɔ.» ");
INSERT INTO myk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cadɛɛngɛ ka bɛ ni Yesu ya jé Kilɛ-pɛɛŋɛ puga ka ni na sipyii kalaa. Ná wa bye wà wu kanige keŋɛ ke na waha. ");
INSERT INTO myk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A saliya karamɔgɔlɔɔ ni Farizhɛɛn pʼi ganha na Yesu kasɛri, na wu wii wu bu da wu na da wu cuuŋɔ cadɛɛngɛ ni, kɔnhɔ pʼi kaɲuŋɔ ta di wu tɔɔgɔ le. ");
INSERT INTO myk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ga Yesu bi pu fungɔnyɔ cɛ. Wee tuun wu ni a wu ná kewaga fɔɔ wu pye: «Yìri mʼa yere sipyii pu niŋɛ ni.» A wu yìri na yere. ");
INSERT INTO myk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A Yesu di pu pye: «Na yi yegee, lʼa saha na kasaana pye cadɛɛngɛ ni laa, na kakuunɔ pye? Na sipya shɔ laa, na wu gbo? Lekɛ lʼa saha wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A wu ɲaha ki le sipyii pu ni, na pu bɛɛri wii círi, lee kadugo na na wee ná wu pye: «Ma keŋɛ ki sanha!» A wu ki sanha, a wu keŋɛ kʼi juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A pu logoo di yìri xuuni. A pʼi ganha na puyɛ yegee lekɛ pu da bye Yesu na ge. ");
INSERT INTO myk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Caŋa ka, Yesu ya kari faaboboŋɔ ka na, di zhɛ Kilɛ ɲɛɛri. A wu shɔn Kilɛ-ɲɛrɛgɛ ki na. ");
INSERT INTO myk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ba ɲiga kʼa mugi wɛ, a wu wu kalaapiire ti yiri. Na kɛ ni shuun ɲaha bulo pu ni, na pye Tudunmɔɔ. ");
INSERT INTO myk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pee pu wa mɛ: Simɔ (a wu wee mɛgɛ le sanha Pyɛɛri), ni wu ceborona Andire, ni Yakuba, ni Yohana, ni Filipe, ni Batelemi, ");
INSERT INTO myk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Macoo, ni Tomasi, ni Alife ja Yakuba, ni Simɔ wemu wu bi bye Zelɔtilee kuruŋɔ ki ni ge, ");
INSERT INTO myk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Yakuba ja Zhude, ni Zhuda Isikariyɔti, wee wʼa Yesu le keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A Yesu ni wu tudunmɔɔ pʼi digi faaboboŋɔ ki na, na nɔ kpɛɛngbɔhɔ ka na. Wu kalaapiire ti niɲɛhɛrɛ ni sipyiɲɛhɛmɛɛ pu bi bye wà. Pee bi pa na yìri Zhude fiige ki bɛɛri ni, ni Zheruzalɛmu, ni suumɔ lɔhɔ ki ɲɔ fiige ki kugbɔhɔɔ, Tiiri ni Sidɔn ni. ");
INSERT INTO myk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pu bi pa, kɔnhɔ pu ba wu jomɔ logo, wu pu cuuŋɔ. Pii pʼa bi kanha jinaa keŋɛ ni ge, pee bɛ ya cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sipyii pu bɛɛri bi wu shaa pʼi gbɔn wu na, bani sefɛɛrɛ ti bi fòro wu ni, na pu bɛɛri cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wee tuun wu ni a Yesu di wu kalaapiire ti wii, na jo: «Yee pii pu ɲɛ la baa fɛɛ ge, yee ɲɛ duba nagoo, bani Kilɛ saanra ti ɲɛ yee wuuro. ");
INSERT INTO myk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xuugo wa yee piimu na nimɛ ge, yee ɲɛ duba nagoo, bani yee na ba din! Yee piimu pu wa mɛhɛɛ suu nimɛ ge, yee ɲɛ duba nagoo, bani yee na ba zhɛhɛ fundanga keŋɛ ni! ");
INSERT INTO myk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sipyii bu yi kɔ, na pu mago wo yi ni, na yi shɛhɛlɛ, na yi mɛkuuŋɔ yu na bani yi ɲɛ Sipya Ja wuu, wee tuun wu ni yi ɲɛ duba nagoo. ");
INSERT INTO myk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Kee caŋa ke, yi ɲahaya na ba daan xuuni, fo na sirani fundanga keŋɛ ni, bani yi saraa wʼa pɛlɛ fugba wu ni. Pu sefɛɛ pu bɛ ya Kilɛ tudunmɔɔ pu kanha mu. ");
INSERT INTO myk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Ga yee naafuugbɔ fɛɛ, bɔɔngɔ ki wa yee wogo, bani yee ya yi wo ɲaɲiŋɛ ki ta xɔ! ");
INSERT INTO myk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yee pii pʼa tin yalijeŋɛɛ na nimɛ ge, bɔɔngɔ ki wa yee wogo, bani xuugo na ba yee ta! Yee pii pʼa zhɛhɛni nimɛ ge, bɔɔngɔ ki wa yee wogo, bani yee ɲahaya na ba danha na mɛhɛɛ suu! ");
INSERT INTO myk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sipyii bɛɛri ba yi mɛsaaŋa yu tuun wemu ni, bɔɔngɔ ki wa yi mu, bani lee pɛlɛgana li na pu sefɛɛ ya tudunmɔɔ kafinɛjuu pu pɛlɛ!» ");
INSERT INTO myk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ga yee pii pu wa nɛ jomɔ pu nuri ge, nʼa da yi jo yi mu, yi pɛɛn pu taan yi mu! Yʼa kasaaŋaa pyi yi kɔvɛɛ na! ");
INSERT INTO myk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yʼa duba pyi yi laŋivɛɛ mu! Pii pʼa yi cogana kolo ge, yi da Kilɛ ɲɛɛri pee mu! ");
INSERT INTO myk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sipya wa bu kadaa ja ma ɲibɛgɛ nigin ni, ke ki bɛ tagi wu mu. Wa bu ma fadegbɔhɔ lɔ, ma ganha bu wu ɲaha kɔn ma fadebire bɛ lɔ na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sipyaa sipya wʼa yaaga ka ɲɛɛri ma mu ge, wu kan. Wa bu ma yaaga lɔ, ma ganha bu weefɔɔ pye wu ki tʼɛrɛŋɛ ma na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yi funŋɔ wa sipyii pʼa keree kiimu pyi yi mu ge, yʼa kee shi pyi pu bɛ mu. ");
INSERT INTO myk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Yee ya taan sipyii piimu mu ge, yee bu daan ni pee yɛ ni, masɔŋɔ kekɛ yʼi da da lee ni wɛ? Ali jurumupyii bɛ ya taan ni pu taanɲiinɛɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pii pʼa kasaaŋaa pyi yi na ge, yi ba kasaaŋaa pyi pee yɛ na, masɔŋɔ kekɛ yʼi da da lee ni wɛ? Ali lee jurumupyii bɛ wa byi. ");
INSERT INTO myk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tadaŋa wa yee na na yaaga ta piimu mu ge, yi ba fɔhɔɔ leni pee yɛ na, masɔŋɔ kekɛ yʼi da da lee ni wɛ? jurumupyii bɛ wa fɔhɔɔ leni pu kaafɛɛ na, kɔnhɔ pʼi pu wogoo ki shi ta sanha. ");
INSERT INTO myk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ga yi pɛɛn pu taan yi mu, yi da kasaaŋaa pyi pu na, yi da fɔhɔɔ leni pu na yi ganha bu yi funyɔ yaha yaaga da na pu mu wɛ! Yi na ba kuduun ta, yi na ba bye Kilɛ-gbɔtabaaga nagoo, bani wee ya ɲɔ java fɛɛ ni kakuubyii mu. ");
INSERT INTO myk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yi pye ɲuŋɔ ɲaarivɛɛ ma na jo, ba yi To Kilɛ wu ɲɛ ɲuŋɔ ɲaarivɔɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Yi ganha ba kiiri kɔɔn pusamaa na wɛ, kiiri da ba gɔn yi na wɛ. Yi ganha ba pusamaa jaagi wɛ, yi da ba jaagi wɛ. Yi da sipyii keree yafani pu mu, yi bɛ wogoo na ba yafa yi mu. ");
INSERT INTO myk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yʼa sipyii kaan, Kilɛ bɛ na da yi kaan. Pu na ba yataanga lɔ na yi wo daanna wu pye, na wu sereŋɛ sereŋɛ, na wu sɔgɔsɔgɔ, na la fara wu na fo wu na woni, na wee kaaŋa le yi fageŋɛ ni. Bani yaaga kemu ni yee wa sipyii pu wo daanna wu pyi ge, kee yaaga ke ninuŋɔ ni yeeyɛ pyaa bɛ wo daanna wa da ba bye.» ");
INSERT INTO myk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A Yesu di talenɛ bɛ jo pu mu na: «Fyɛn wa na já fyɛn wa kagaan co gɛ? Lee bu bye pu shuun wu bɛɛri na do wege ni. ");
INSERT INTO myk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kalaapire ya pɛlɛ li kalaato na wɛ, ga kalaapire bɛɛri lʼa kalaa xuuni ge, lee na ba bye ba li kalaato wu ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Kagaanra le li wa mu ceboro wu ɲii ni ge, ɲaha na mu di lee wii, na ta puga tinbara di ɲɛ muyɛ pyaa ɲii ni, mu di ya lee ɲaa-i wɛ? ");
INSERT INTO myk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dii mu da já ma ceboro pye: ‹Na ceboro, kagaanra le li wa ma ɲii li ni ge, yere di li wolo.› Na ta mu di ya puga tinbara le ɲaa mayɛ wuu li ni-i wɛ? Shuun shuun jovɔɔ dɛ, fɛnhɛ puga tinbara le wolo mayɛ pyaa ɲii le ni. Lee bu bye ma na já ɲa xuuni, na kagaanra li wolo ma ceboro wu ɲii li ni. ");
INSERT INTO myk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Tisaaŋa ya yasɛŋɛ niguuŋɔ pyi wɛ, tikuuŋɔ ya yasɛŋɛ nizaaŋa pyi wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tiye bɛɛri wa jɛni yi yasɛyɛ fɛni. Sipya da ga nitoroŋɔ kɔn xhuyo tige na wɛ; sipya di wa da ga ɛrɛzɛn kɔn xhutɔɔnyɔ tige na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sipyisaama wʼa yasaaya kilee na yeege wu yasaaya tayahaŋa ni; sipyikuuŋɔ di yakuuyo kilee na yeege ki yakuuyo tayahaŋa ni. Bani lemu lʼa sipya zɔ we ɲi ge, lee lʼa fòro wu ɲɔ ke ni. ");
INSERT INTO myk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ɲaha na yʼi na pyi ‹Kafɔɔ, Kafɔɔ› na ta le nʼa yu ge, yʼi wa lee pyi-i wɛ? ");
INSERT INTO myk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sipyaa sipya wʼa pa nɛ mu, na nɛ jomɔ pu nuri, na pu koo ɲaari ge; wèe na já weefɔɔ taanna ni kaa lemu ni ge, nʼa da lee shɛ yi na. ");
INSERT INTO myk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʼa foro piyɛyɛ kɔnvɔɔ wa fɛni, wemu ya ɲiŋɛ ki tugi na cogi fo na shɛ nɔ faaga na ge, na puga ki ɲidaa li teŋɛ faaya ɲuŋɔ ni, na puga ki yereŋɛ yee ɲuŋɔ ni. Ba lɔhɔ kʼa pa ɲɛhɛ wɛ, a gba wu ɲi, na sɛri. A lofomɔ pu ba guu puga ki na, ga pu ya já ki ɲɛhɛ wɛ, bani ki bi yereŋɛ ɲɔ. ");
INSERT INTO myk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ga wemu ba nɛ jomɔ pu nuri, wufɔɔ di ya pu koo ɲaari wɛ, weefɔɔ ya foro ná wa fɛni, wemu ya wu puga yereŋɛ ɲiŋɛ na, wu ya ɲidaa tugi ki na-ɛ ge. Gba lɔhɔ kʼa pa nɔ kee puga ki na tuun wemu ni ge, a kʼi gurulo taapile ni. A kee puga ki togana di golo.» ");
INSERT INTO myk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ba Yesu ya pee jomɔ pu bɛɛri jo xɔ sipyii pu mu wɛ, na jé Kapɛrinɔmɔ kulo li ni. ");
INSERT INTO myk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sɔrɔsii ɲuŋɔfɔɔ wa bye wà, wu kapyebye wemu kaa li bi dan wu ni xuuni ge, wee bi cuuŋɔ wɛ, wu bi zhaa di xhuu. ");
INSERT INTO myk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ba wee ɲuŋɔfɔɔ wʼa Yesu kaa logo wɛ, na Yawutuu nabelɛyɛ ya tun pu shɛ Yesu ɲɛɛri na wu pa wu kapyebye wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A pʼi nɔ Yesu yíri, na yi jo wu mu. Na guri na wu ɲɛɛri xuuni na: «Ma bu lee pye we ná we mu, wʼa yaa ni lee ni, ");
INSERT INTO myk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bani wèe shi wu kaa ya dan wu ni, wee wʼa wèe Kilɛ-pɛɛŋɛ puga ki yereŋɛ.» ");
INSERT INTO myk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A Yesu di gari ni pu ni. Ba wʼa tɛɛŋɛ sɔrɔsii ɲuŋɔfɔɔ wu puga ki na wɛ, a wee di wu naɲiinɛɛ pii tun pu shɛ wu pye: «Kafɔɔ, ma ganha da mayɛ kanha wɛ, bani nɛ yaa mu wu jé nɛ puga wɛ. ");
INSERT INTO myk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lee wuu na nɛ wu shɛ mu yíri, nɛ nayɛ ta nɛ cɛ̀rɛ lee bɛ ni. Ga ɲɔmɛɛ nigin yɛ jo, kɔnhɔ na kapyebye wu juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bani ɲuŋɔfɛɛ pii wo fanha nɔhɔ ni nɛ ɲɛ, sɔrɔsii pii di ɲɛ nɛ bɛ mu. Nɛ bu wee wa pye: ‹Shɛ!› Wʼa gari. Nɛ bu wa bɛ pye: ‹Pa!› Wee bɛ na ba. Nɛ bu na kapyebye wu pye: ‹Le pye!› Wʼa lee pye.» ");
INSERT INTO myk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ba pʼa shɛ tee tuduro ti jo Yesu mu tuun wemu ni wɛ, a lee di wu fo. Sipyiire ti tʼa bi taha wu fɛni ge, a wu ŋmahana ɲɛri pee shizhaa na pu pye: «Nʼa da yi jo yi mu, nɛ sanha we wo nʼa daa wu tuugo ɲa sipya wa shishiin mu wɛ, ali Izirayɛli fiige ki bɛ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ba tudunmɔɔ pʼa kuri kari pu ɲuŋɔfɔɔ wu puga wɛ, a pʼi shɛ kapyebye wu nijuuŋɔ ta wà. ");
INSERT INTO myk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lee nibyexhoo na a Yesu di gari kulo la ni lee mɛgɛ ɲɛ Nayini. A wu kalaapiire te, ni sipyiire tʼi gari ni wu ni. ");
INSERT INTO myk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ba pʼa tɛɛŋɛ kulo li tajege ki na wɛ, a pʼi jíri sipyii pii na, pu na gaaŋi ni ná wa nixhugo ni faya ni. Wee yɛ nigin wʼa bye wu nu mu. Wu nu wu bɛ di bye naxhugoshɔ. Kanha ki sipyii niɲɛhɛmɛɛ pu bi foro pinnɛ ni wee cee wu ni, na se gbo wu taleŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kafɔɔ ya wee cee wu ɲa tuun wemu ni ge, a wu ɲiɲaara di jé wu ni. A wu wu pye: «Ma ganha ba mɛɛ suu wɛ!» ");
INSERT INTO myk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A wu fulo pu na, na wu keŋɛ taha karaya yi na, a gbo wu lɔvɛɛ pʼi yere. A Yesu di jo: «Naɲi we, nɛ wʼa ma pye mu, yìri!» ");
INSERT INTO myk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A wu yìri tiin na jomɔ ɲɔ kɔn. A Yesu di wu kan wu nu wu mu. ");
INSERT INTO myk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A sipyii pu bɛɛri di fya, a pʼi ganha na Kilɛ sɔni na: «Kilɛ tudunmɔ nigbɔ wʼa wuyɛ shɛ wu niŋɛ ni. Kilɛ wʼa pa wu sipyii pu tɛgɛ.» ");
INSERT INTO myk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Le Yesu ya pye ge, a lee kaa di jaaga Yawutuu fiige ke, ni ki kabanugo kulogoo ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesu ya keree kiimu bɛɛri pye ge, a Yohana wo kalaapiire tʼi shɛ kee bɛɛri paari wu mu, a wu pu shuun wa yiri, ");
INSERT INTO myk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na pu tun shɛ Kafɔɔ mu, pu wu yege na: «Pʼa Shɔvɔɔ wemu kaa jo na wu na ba ba ge, mu wu wa laa, ta wù watii ɲaha wii?» ");
INSERT INTO myk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba pʼa nɔ Yesu yíri tuun wemu ni wɛ, na wu pye: «Yohana Batizelipye wʼa wèe tun pa na wèe pu pa ma yege na: ‹Pʼa Shɔvɔɔ wemu kaa jo na wu na ba ba ge, mu wu wa laa, ta wù watii ɲaha wii?›» ");
INSERT INTO myk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Taapile ni a Yesu di sipyiɲɛhɛmɛɛ yama ni pu kanhama keree xɔ, na jinaa kɔri yeege pii ni, na fyɛnmɛɛ niɲɛhɛmɛɛ ɲìi mugi. ");
INSERT INTO myk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lee kadugo na a wu Yohana wo tudunmɔɔ pu ɲɔ shɔ na: «Yʼa lemu ɲa, na lemu logo ge, yi shɛ lee paari Yohana mu na: Fyɛnmɛɛ wa ɲaa, faannaa di ɲaari, togo fɛɛ di juuŋɔ, ɲudunnɔɔ di nuri, xuu di ɲɛni, Kilɛ Jozaama pʼi yu la baa fɛɛ mu. ");
INSERT INTO myk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sipya wemu ɲuŋɔ ya kyɛɛgi nɛ na wɛ, weefɔɔ ɲɛ duba pya!» ");
INSERT INTO myk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ba Yohana wo tudunmɔɔ pʼa kari wɛ, a Yesu di ɲɔ kɔn na yu ni sipyiire ti ni Yohana shizhaa na na: «Ɲaha yee dʼa shɛ wii siwaga ki ni wɛ? Kafɛɛgɛ ya wahagaanra lemu ɲɛri ge, lere ya? ");
INSERT INTO myk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wee tuun wu ni yee dʼa shɛ ɲaha wii wɛ? Fazaaya fɔɔ gɛ? Ga piimu pʼa fazaaya leni, na yalijeŋɛɛ li ge, pee ya daa saannaa piyɛyɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yee dʼa shɛ ɲaha wii wɛ? Kilɛ tudunmɔ gɛ? Uun, nʼa da yi jo yi mu jo ali wʼa pɛlɛ Kilɛ tudunmɔ na. ");
INSERT INTO myk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bani lʼa ka Kilɛ Kafila wu ni wu shizhaa na na: ‹Li wii, nʼa na tudunmɔ we tun ma ɲahagbaa na wu ma koo li yàa yaha ma ɲaha na.› ");
INSERT INTO myk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nʼa da yi jo yi mu jo sipya wa shishiin sanha se Adama nagoo ni wemu wʼa pɛlɛ Yohana na wɛ, Ga lee bɛ na Kilɛ saanra ti wo sipyii pu bɛɛri wo nifɛnhɛfɛnhɛnɛ ya pɛlɛ wu na.» ");
INSERT INTO myk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sipyii pii pʼa wu jomɔ pu logo ge, ni fanhafɛɛ wari shɔvɛɛfanhafɛɛ wari shɔvɔɔ, a pee di li shɛ na fiinŋɛ na Kilɛ ya tii, pee bi batize Yohana mu. ");
INSERT INTO myk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ga Farizhɛɛn ni saliya karamɔgɔlɔɔ ya she Kilɛ wo ɲɔmɛɛ li ni puyɛ pyaa shizhaa na, pu ya ta sɔɔ na batize Yohana mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Yesu di jo sanha na: «Nɛ na já niɲaa wo sipyii pii taanna ni jɔgɔ yɛ ni wɛ? Jɔgɔ yɛ fɛni pu dʼa foro wɛ? ");
INSERT INTO myk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pʼa foro nɔhɔpiire ta fɛni temu tʼa tiin pinnɛgɛ kpɛɛngɛ na, na ti mujoŋɔɔ yaha nɔ tiyɛ na ge na: ‹Wèe ya faangaa wi yee mu yee di ya ta xɔnhɔ wɛ. Lee kadugo na a wèe di yamɛhɛɛ su yee mu yee di ya ta mɛhɛɛ su wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bani Yohana Batizelipye ya pa; wu bi yalijeŋɛɛ li wɛ, wu bi duvɛn gbuu wɛ, a yee di jo: ‹Jina wu ɲɛ wu ni.› ");
INSERT INTO myk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A Sipya Ja wu ba, na ganha na li na gbuu, a yee di jo na: ‹Laɲɛhɛrɛ fɔɔ ni gba fɔɔ wu ɲɛ we ná we. Fanhafɛɛ wari shɔvɛɛ ni jurumupyii pii bɛ wo naɲii wu ɲɛ wii.› ");
INSERT INTO myk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ga Kilɛ wo koo li ɲaarivɛɛ pu bɛɛri ya kaɲii kan Kilɛ wo fungɔngɔ fɛɛrɛ ti mu.» ");
INSERT INTO myk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Caŋa ka, Farizhɛn wa ya pa Yesu ɲɛɛri na wu shɛ li wu yíri. A Yesu di gari wee puga. A pʼi ba ɲɔ kɔn na li. ");
INSERT INTO myk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lee di dɔdɔshɔ wa ta lee kulo li ni. Ba wʼa yi logo tuun wemu ni na Yesu ya li wee ná wu puga wɛ, a wu gari wà ni lasikoli gboro la ni. ");
INSERT INTO myk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A wu mɛsuwo di ba doro Yesu kadugo yíri, na shɛ yere na saha ni wu tɔɔyɔ ye ni, na Yesu tɔɔyɔ yi fyɛnmi ni ɲɛsinmɛ ni, na wu ɲuzhiire taga pee jɔgɔ, na ganha na wu tɔɔyɔ yi taala taala ni taanɲɛɛgɛ ni, na lasikoli wu wo yi na. ");
INSERT INTO myk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farizhɛn we wʼa bi Yesu yiri yalige ki na ge, ba wee ya lee ɲa wɛ na jo wuyɛ funŋɔ ni na: «We ná we da bi bye Kilɛ tudunmɔ, we cee we wʼa kpɔn wu na ge, wu bi da li cɛ na dɔdɔshɔ wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wee tuun wu ni a Yesu di jomɔ pu lɔ na jo: «Simɔ, la wa nɛ mu na jo ma mu.» A Simɔ di wu ɲɔ shɔ na: «Karamɔgɔ, li jo.» ");
INSERT INTO myk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A Yesu di jo: «Foolemɛ wa fɔhɔɔ bye sipyii shuun na, wu wari kabɔfoŋɔɔ kɛlɛɛ gbarashuun ni kaguro (w 75.000) shishiin bye wa na, wu wari kabɔfoŋɔɔ gbarashuun di xhuu kaguro (w 7.500) shishiin di bye shuun wo wu na. ");
INSERT INTO myk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba ma na jo se bye pu ni pu wu ta kan wɛ, lee funŋɔ ni, a wu pu bɛshuun wu fɔhɔɔ ki yaha pu na. Nɛ jo, we ná we kaa na daan wekɛ ni xuuni pu shuun wu ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A Simɔ di wu ɲɔ shɔ na: «Nɛ giin jo wʼa niɲɛhɛmɛ wu yaha wekɛ na ge.» A Yesu di wu pye: «Mʼa can jo.» ");
INSERT INTO myk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lee kadugo na a Yesu di ŋmahana ɲɛri cee wu shizhaa na Simɔ pye: «Mʼa we cee we ɲaa gɛ? Nɛ jé mu puga, mu ya tɔɔyɔ je lɔhɔ kan nɛ mu wɛ, ga we ya nɛ tɔɔyɔ fyɛnmi ni ɲɛsinmɛ ni, na pee jɔgɔ ni wu ɲuzhiire ni. ");
INSERT INTO myk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mu ya ta nɛ shaari ni taanɲɛɛgɛ ni ba lʼa tee na byi ni ɲɔsɔɔnrɔ ni wɛ. Ga nɛ di jé naha ge, taanɲɛɛgɛ ni we cee we ya nɛ co, bani nɛ di jé ge, wu ɲɛ na nɛ tɔɔyɔ taala taala. ");
INSERT INTO myk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mu ya ta sìnmɛ wo nɛ ɲuŋɔ ni wɛ, ga wee ya pɛɛwa lasikoli wo nɛ tɔɔyɔ na. ");
INSERT INTO myk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lee na nʼa da yi jo yi mu, we cee we taanɲɛɛgɛ nigbɔhɔ kʼa li shɛɛ na wu jurumu wu ni wu ɲɛhɛ bɛɛri ya yafa wu mu. Ga yafa bu bye wu ya pye sipya wemu mu jurumu niɲɛhɛmɛ ɲuŋɔ tàan wɛ, weefɔɔ taanɲɛɛgɛ na jɛrɛ.» ");
INSERT INTO myk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wee tuun wu ni a Yesu di cee wu pye: «Ma jurumu wʼa yafa ma mu.» ");
INSERT INTO myk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A wu liɲii pʼi ɲɔ kɔn na yu puyɛ funyɔ ni na: «Jɔgɔ wu ɲɛ we, wʼi sipyii jurumu yafani pu mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A Yesu di wee cee wu pye: «Ma nʼa daa wʼa ma shɔ. Ta se ɲaɲiŋɛ na!» ");
INSERT INTO myk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kii keree kii kadugo na, Yesu bi kugbɔhɔɔ ni kupiire ɲaari, na Kilɛ saanra ti Jozaama pu yɛrɛ li pyi. Wu kalaapiire kɛ ni shuun wu bye ni wu ni, ");
INSERT INTO myk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ni cèe pii bɛ. Wu bi pee cèe pu cuuŋɔ, na jinaa bɛ kɔri yeege pii ni pu ni. Cee nigin wa mɛgɛ ki bye na Mariyama, pu bi wee yiri na Magadala shɛɛn Mariyama, jinaa gbarashuun wu bi foro wee ni. ");
INSERT INTO myk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wa mɛgɛ ɲɛ na Zhanɛ, wee bye Kuza wo shɔ. Kuza bi bye saannaa Hɛrɔdi wo koomɔ pu fanhafɔɔ wa. Suzani, ni cèe niɲɛhɛmɛɛ piitiilee bɛ bye wà. Pee bɛɛri bi Yesu ni wu kalaapiire ti tɛri ni pu keŋɛ yaaya ni. ");
INSERT INTO myk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sipyii pu bi yìri kulogoo ki bɛɛri ni na se Yesu yíri. Sipyiire tʼa pa binnɛ wu tàan tuun wemu ni ge, a Yesu di le talenɛ le jo pu mu na: ");
INSERT INTO myk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Caŋa ka ná wa ya foro na kari wu tɛgɛ ni di zhɛ wu alikama shi wá fenɛ shi wagana na. Na wu yaha wu na wee nuguzhi wu waa, a wu nuguro ta di do koo ni tɛgɛ ki ɲɔ na. A sipyii di tee tanhana tanhana, a shazhɛɛrɛ di tee jɔ. ");
INSERT INTO myk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A nuguro ta di do faaga ɲuŋɔ ni poɲɛhɛrɛ di bye wà wɛ. Ba tʼa fin xɔ wɛ, na waha, bani ɲimɛ bye wà wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A nuguro ta di do xhuyo niŋɛ ni. A ti ni xhuyo yʼi ganha na lɛgi; a yʼi ba ti co, na ti li. ");
INSERT INTO myk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A nuguro ta di do ɲijeŋɛ na. A tʼi fin, na lɛ, na pya le, na ti tɛhɛɛ xhuu nigin (100) pye.» Ba Yesu ya pee jomɔ pu jo wɛ, na sɛlɛ na: «Wemu na logo ge, wu logo dɛ!» ");
INSERT INTO myk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A wu kalaapiire tʼi wu yege na: «Le talenɛ le kɔri ɲɛ dii wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A wu pu pye: «Na Kilɛ saanra ti wo ŋmɔhɔrɔ ti cɛ, yee mu lee ya kan. Ga sipyii pusamaa kunni, ti keree ki bɛɛri wʼa yu pu mu taleŋɛɛ ni, kɔnhɔ: ‹Pu da wii, ga pʼi ganha ba yaaga ɲaa wɛ. Pʼi da niwegee shaan, pʼi ganha ba yi ɲaha cɛni wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Lee talenɛ li kɔri we: Nuguzhi we, wee ɲɛ Kilɛ jomɔ. ");
INSERT INTO myk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pii ɲɛ ba koo ɲɔ ɲɛ wɛ, ba pee ya pe jomɔ pe logo wɛ, Shitaanni na ba pu wolo pu funyɔ ni, kɔnhɔ pu ganha dà, pʼi shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Faaga wuu pu ɲɛ piimu pʼa jomɔ pu logo, na pu co ni fundanga ni ge. Ga nire di ɲɛ pu na wɛ, pʼa dà yɛ jɛɛrɛ yɛ funŋɔ ni. Nɔwuuro bu pu ta pʼa nʼa daa wu yaha. ");
INSERT INTO myk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xhuyo niŋɛ wuu pu ɲɛ piimu ge, pee na pe jomɔ pe logo. Ga ke koŋɔ ke wo funzhakeree, ni naafuu keree, ni xɔnhɔrɔ keree, na pu cɔnri, fo pu da lɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɲijeŋɛ wuu pu ɲɛ piimu ge, pee na pe jomɔ pe logo, na pu co see na ni zɔsaama ni, na gori yaha pee jomɔ pe na, fo na nagoo pye. ");
INSERT INTO myk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Wa shishiin ya sokinna leni wu yaaga shigile wu ɲuŋɔ ni, kelee wʼi wu le karaga nɔhɔ ni wɛ. Ga yaaga ɲuŋɔ ni wu da wu taha, kɔnhɔ wu da kpɛɛngɛ yeege puga ki jevɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bani kaŋmɔhɔnɔ la shishiin wa lemu da ba jɛ wɛ. Ŋmɔhɔrɔ ta shishiin wa temu da ba foro kpɛɛngɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lee wuu na yi kasɛɛgɛ ta yi kafila logogaŋaa na, bani la ɲɛ wemu mu ge, la na ba gan wee mu. Ga la ɲɛ wemu mu wɛ, wʼa giin na nifɛnhɛfɛnhɛnɛ lemu bɛ li ɲɛ wu mu ge, lee bɛ na zhɔ wu na.» ");
INSERT INTO myk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu nu ni wu ceboronamaa ya kari Yesu yíri, ga pu ya já gbara wu na sipyii pu keŋɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A wa di yi jo wu mu na: «Ma nu we ni ma ceboronamaa pu niyereye yi wa kpɛɛngɛ ke na, pu funŋɔ ki wa pʼi ma ɲa.» ");
INSERT INTO myk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ga, a Yesu di jo: «Pii pʼa Kilɛ jomɔ pu nuri, na pu koro ɲaari ge, pee pu ɲɛ nɛ nu ni nɛ ceboronamaa.» ");
INSERT INTO myk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Caŋa ka, Yesu ya wu kalaapiire ti pye: «Wù shɛ gba wu kadugo.» A pʼi jé kɔrɔgɔ ka ni na gaaŋi. ");
INSERT INTO myk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na pu yaha pu gaaŋi, a Yesu di ŋmunɔ. A kafɛɛgɛ ka di yìri lɔhɔ ki ɲuŋɔ ni. A kɔrɔgɔ kʼi ganha na zhaa di ɲii lɔhɔ na, fo pu na zhaa di mini. ");
INSERT INTO myk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wee tuun wu ni a wu kalaapiire tʼi fulo wu na na wu ɲɛ, na wu pye: «Karamɔgɔ, Karamɔgɔ, wù na da gori lɔhɔ ni!» A wu yìri, na sɛlɛ kafɛɛgɛ ke ni lokuruyo yi na; a kafɛɛgɛ ke ni lokuruyo yi bɛ di yere. A tunmɔ pʼi yere. ");
INSERT INTO myk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A wu wu kalaapiire ti pye: «Mii yee wo nʼa daa wu wa wɛ?» A lʼi bye pu fyaara wuu mu kakanhana, a pʼi ganha na puyɛ pyi: «We ná we dʼa sii jɔgɔ, fo wu na yu ni kafɛɛgɛ ni lɔhɔ ni, yʼi wu ɲɔmɛɛ coni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A Yesu ni wu kalaapiire tʼi nɔ Gerasa fiige ki ni, kabanugo kulo la ni. Kee ɲɛ gba wu kadugo na saha ni Galile fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ba Yesu ya foro kɔrɔgɔ ki ni wɛ, a ná wa di ba wu ɲuŋɔ círi, kulo li shɛn wa. Jinaa pu bye wu ni. Fo taatuunnɔ ni wu bi gbara wʼa fàya leni wɛ, wu bi goroo puga wɛ. Wu tatɛɛngɛ ki bye faxhuu we. ");
INSERT INTO myk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ba wʼa Yesu ɲa wɛ, na mujuugbɔɔ la wá, na nuguro sin Yesu fɛɛ ni, na jo ni mujuugbɔɔ ni na: «Ɲaha mʼa zhaa nɛ fɛni wɛ, Kilɛ-gbɔtabaaga Ja Yesu? Nʼa ma ɲɛɛri, ma ganha bu na kanha wɛ!» ");
INSERT INTO myk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wʼa yee jo, bani Yesu bi jina wu pye na wu foro wee ná wu ni. Jina wu bu yìri wu fɛni tuun wemu ni, sipyii na wu kemɛ pɔ ni tɔɔrɔ shɔnhɔyɔ ni, na biriye le wu tɔɔyɔ na, kɔnhɔ pu da wu kasɛri. Ga wʼa tee pɔɔrɔ ti bɛɛri kɔn. Jina wu bi ma wu kɔri kari sipoŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A Yesu di wu yege na: «Dii mu mɛgɛ di ɲɛ wɛ?» A wu jo: «Nɛ mɛgɛ ɲɛ ‹Wèe Ya Ɲɛhɛ,›» bani jinaa niɲɛhɛmɛɛ pu bi jé wu ni. ");
INSERT INTO myk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A pee jinaa pʼi Yesu ɲɛɛri xuuni na wu ganha bu pu yaha gari kakara wecogoŋɔ tɛhɛnɛ baa wogo ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lee bi shaagbaga nijeŋɛ ka ta ki na naha yaŋa ki kabanugo. A jinaa pʼi Yesu ɲɛɛri na wu sɔɔ pʼi shɛ jé pee shaalaa pu ni. A wu sɔɔ. ");
INSERT INTO myk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wee tuun wu ni a jinaa pʼi foro ná wu ni, na shɛ jé pee shaalaa pu ni. A shaagbaga kʼi gburogi, na digi yaŋa gologoloyo yi ni, na jé gba lɔhɔ ki ni, na xhu wà. ");
INSERT INTO myk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ba shaanahamaa pʼa lee ɲa tapyege ni wɛ, a pʼi baa kari na shɛ yee paari kanha ki ni, ni sitiinmɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A sipyii pʼi foro na shɛ lee nibyii li wii. Ba pʼa nɔ Yesu tàan wɛ, na wee ná wu ɲa, jinaa pu bi foro wu ni. Wu nidɛɛngɛ di ɲɛ Yesu fɛɛ ni, fàya yi bye wu na, wu dʼa cuuŋɔ. A pʼi fya. ");
INSERT INTO myk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ná jinaa wo wʼa cuuŋɔ piimu ɲii na ge, a pee di kii keree kii bɛɛri paari pu mu. ");
INSERT INTO myk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wee tuun wu ni a Gerasa shɛɛn pu bɛɛri di Yesu ɲɛɛri na wu laha pu wo ɲiŋɛ ki na, bani pu bi fya xuuni. A Yesu di jé kɔrɔgɔ ki ni, na laha pu wo ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yesu nigariwo jinaa pʼa foro ná wemu ni ge, a wee di wu ɲɛɛri na wu bi da já binnɛ ni wu ni. Ga, a Yesu di wu kuruŋɔ, na jo: ");
INSERT INTO myk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Kuri mʼa se puga, Kilɛ ya kagbɔhɔɔ kiimu bɛɛri pye ma mu ge, mʼa shɛ kee paari.» Yesu ya kagbɔhɔɔ kiimu bɛɛri pye wu mu ge, a wu gari na shɛ kee keree ki paari kulo li bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ba Yesu ya kuri pa na yìri gba wu kadugo wɛ, a wu ba wu daan sipyii pu bɛɛri ni, bani pu bɛɛri bi wu sigee. ");
INSERT INTO myk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lee bi ná wa ta wà, wu mɛgɛ ɲɛ na Zhayirusi, wee wu bye wee xuu wu wo Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ. A wee di ba nuguro sin Yesu fɛɛ ni, na wu ɲɛɛri xuuni na wu shɛ wu puga, ");
INSERT INTO myk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bani fucɛɛrɛ nigin yɛ li bye wu mu, li shi wu bye yee kɛ ni shuun. Lee li bi zhaa di xhuu. Ba Yesu ya gaaŋi wà wɛ, a sipyiire tʼi wu kuuri, na wu cɔnri. ");
INSERT INTO myk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lee bi cee wa bɛ ta wà shishan na woni wu fɛni fo yee kɛ ni shuun. Wu bi wu keŋɛ yara bɛɛri kan wɛbyii mu, ga wa shishiin ya já wu cuuŋɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A wu fulo Yesu na wu kadugo yíri, na ba gbɔn wu fadegeŋɛ na. Taapile ni a wu shishan pʼi yere. ");
INSERT INTO myk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A Yesu di jo: «Jɔgɔ wʼa kpɔn nɛ na wɛ?» Ba pu bɛɛri ya yu pee bɛ wɛ, a Pyɛɛri di jo: «Karamɔgɔ, sipyii pʼa mu cɔnri xuuni dɛ!» ");
INSERT INTO myk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ga, a Yesu di jo: «Sipya wa wʼa kpɔn nɛ na, bani nɛ li cɛ na sefɛɛrɛ ta tʼa foro na ni.» ");
INSERT INTO myk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ba wee cee wʼa li ɲa na li da já ŋmɔhɔ nige wɛ, a wu ganha na fuguri, na ba nuguro sin Yesu fɛɛ ni. Lemu lʼa wu pye wʼa kpɔn Yesu na, ni wʼa cuuŋɔ taapile ni cuuŋɔgana lemu na ge, a wu yee paari wu mu sipyii pu bɛɛri ɲii na. ");
INSERT INTO myk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A Yesu di wu pye: «Na poro, ma nʼa daa wʼa ma cuuŋɔ. Ta se ɲaɲiŋɛ na!» ");
INSERT INTO myk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na Yesu yaha pee jomɔ pu na, a tudunmɔ wa di ba na yìri Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ wu kaban, na ba wee pye na: «Ma poro fucɛɛrɛ lʼa xu. Ma ganha bu navunŋɔ pɛlɛ nige Karamɔgɔ wu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ga ba Yesu ya yee logo wɛ, na Zhayirusi pye: «Ma ganha bu fya wɛ; dà yɛ, ma poro wu na juuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ba Yesu ya shɛ nɔ Zhayirusi kaban wɛ, wu ya sɔɔ wa shishiin wu jé ni wu ni puga ki ni wɛ, fo Pyɛɛri, ni Yohana, ni Yakuba, ni pya wu nu ni wu to. ");
INSERT INTO myk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lee di sipyii pu bɛɛri ta pu na yamɛhɛɛ suu na xhuulo. A Yesu di jo: «Yi ganha ba mɛhɛɛ suu wɛ, bani pya wu ya ta xu wɛ, wʼa ŋmunɔɔ.» ");
INSERT INTO myk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A pʼi ganha na wu la wo, bani pu bi li cɛ na wʼa xu xɔ. ");
INSERT INTO myk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ga, a Yesu di wu co keŋɛ ke na, na jo ni mujuugbɔɔ ni na: «Pya we, yìri!» ");
INSERT INTO myk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A wu munaa lʼi guri pa wu mu. Taapile ni a wu yìri tiin. A Yesu di jo na pu yalige kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A lʼi bye kakanhana pya wu sefɛɛ pu mu fo xuuni. Ga, a Yesu di yi jo waha pu mu na pu ganha lee nibyii le jo wa shishiin mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ya wu kalaapiire kɛ ni shuun wu yiri, na sefɛɛrɛ ni fanha kan pu mu jinaa bɛɛri na, pu da yama bɛ xuu. ");
INSERT INTO myk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lee kadugo na a wu pu tun pu shɛ Kilɛ saanra ti yɛrɛ pye, pʼi yama fɛɛ cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A wu pu pye: «Yi nigariwuu ganha bu yaaga lɔ yi keŋɛ ni wɛ, kagaanga bɛ wɛ, kushɛyaaga bɛ wɛ, yalige yaaga bɛ wɛ, wari bɛ wɛ. Wa shishiin ganha da fadeye shuun lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yi bu jé puga bɛɛri ni, yʼi diin wà fo yi kariduun bu shɛ nɔ. ");
INSERT INTO myk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Xuu wa shɛɛn bu zhe pu da yi tirige wɛ, yi ba fòro lee kulo li ni, yʼi yi tɔɔyɔ gbazhɛnhɛ ɲahara wo wà, lee na ba bye sɛɛri kaa pu fɛni.» ");
INSERT INTO myk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A kalaapiire tʼi gari. A pʼi Kilɛ wo Jozaama pu jo toro kulogoo ki bɛɛri ni, na yama fɛɛ pu cuuŋɔ tɛyɛ yi bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ba gbafɛnɛɛrɛɛ Hɛrɔdi ya kii kapyegee kii bɛɛri kaa logo tuun wemu ni wɛ, a wu hakili di wuregi, bani sipyii pii ya jo na: «Yohana Batizelipye wʼa ɲɛ na foro xu ni.» ");
INSERT INTO myk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A pii di jo: «Kilɛ tudunmɔɔ Eli wʼa kuri pa.» A pii bɛ di jo: «Wa wʼa ɲɛ na foro xu ni taashiinɛ li wo Kilɛ tudunmɔɔ pu ni.» ");
INSERT INTO myk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ga, a Hɛrɔdi di jo: «Nɛ Yohana ɲuŋɔ kan pʼa kɔn. Ayiwa, di wa kii keree kii nuri wemu shizhaa na ge, wee ɲɛ jɔgɔ wɛ?» A wu ganha na li shaa wu Yesu ɲa. ");
INSERT INTO myk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A Tudunmɔɔ pʼi guri pa Yesu yíri, na ba pu kapyegee ki bɛɛri paari wu mu. A Yesu di gari ni pu ni pu yɛ na, na shɛ nɔ kulo la ɲɔ na, lee mɛgɛ ɲɛ na Bɛtisayida. ");
INSERT INTO myk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ba sipyiire tʼa pa li cɛ tuun wemu ni wɛ, na daha wu fɛni. A Yesu di pu co xuuni, na baari pu mu Kilɛ wo saanra ti keree na. Piimu mago bye sicuumɔ na ge, a wu pee cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ba caŋa kʼa ɲɔ kɔn na diri wɛ, a kalaapiire kɛ ni shuun wu fulo Yesu na, na wu pye: «Sipyiire ti yaha, kɔnhɔ pʼi shɛ wù tàan kulogoo ni sige buguro te na, pʼi shɛ yalige ni tashɔnyɔ sha wà, bani sipoŋɔ ni wèe ɲɛ naha.» ");
INSERT INTO myk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ga, a Yesu di pu pye: «Yiyɛ pyaa ki yalige kan pu mu.» A pʼi jo: «Yaaga ɲɛ wèe mu buuri ɲuyɔ kaguro ni fyaa shuun yɛ kadugo na wɛ, fo ma la bi ɲɛ wù shɛ yalige shɔ pii sipyii pii bɛɛri mu.» ");
INSERT INTO myk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pu bi namaa kabɔfoŋɔɔ kaguro (5.000) shi tɔrɔ pee ni. A Yesu di wu kalaapiire ti pye: «Yi pu teŋɛ kɛlɛɛ kaguro kaguro (50) shishiin.» ");
INSERT INTO myk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A pʼi li pye mu na sipyiire ti bɛɛri teŋɛ lee teŋɛgana li na. ");
INSERT INTO myk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A Yesu di yee buuri ɲuyɔ kaguro we ni fyaa shuun wu lɔ, na ɲaha ke yirige fugba we ni, na baraga taha Kilɛ na. A wu xhɔ na yi kɛgi kɛgi na kan kalaapiire ti mu, na pu yee yereŋɛ sipyii pu tàan. ");
INSERT INTO myk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A pu bɛɛri di li na din. Yalige kemu kʼa kori ge, a pʼi kee saŋa kemɛ fo na sagaŋaa kɛ ni shuun ɲi. ");
INSERT INTO myk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Caŋa ka, na Yesu yaha Kilɛ-ɲɛrɛgɛ na wu yɛ, wu kalaapiire ti bye wu kabanugo na. A Yesu di pu pye: «Sipyii pu wa yu na jɔgɔ nɛ ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A pʼi wu ɲɔ shɔ na: «Pii wa yu na Yohana Batizelipye, pii di yu na Kilɛ tudunmɔɔ Eli, pii bɛ di yu sanha na taashiinɛ li wo Kilɛ tudunmɔ wa wʼa ɲɛ na foro xu ni.» ");
INSERT INTO myk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A Yesu di pu yege na: «Ga yee do, yeeyɛ pyaa ki mu nɛ di ɲɛ jɔgɔ wɛ?» A Pyɛɛri di wu pye: «Kilɛ ya Kirisa wemu ɲaha bulo ge, wee mu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A Yesu di yi waha pu mu na pu ganha yee jo wa shishiin bɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A Yesu di jo sanha na: «Li waha lʼi waha, fo Sipya Ja bu ganha xuuni. Nɔhɔlɛɛ, ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ na ba zhe wu ni. Pu na ba wu gbo, wu caxhugo caŋa taanri wogo wu na ba ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lee kadugo na a wu yi jo pu bɛɛri mu na: «Wa funŋɔ bi ɲɛ wu binnɛ ni na ni, wu she wuyɛ ni, ɲiga bɛɛri wu wu korikoritige ki lɔ taha na fɛni. ");
INSERT INTO myk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bani sipya we wʼa giin wu wuyɛ pile munaa ɲuŋɔ wolo niɲaa ge, wee na ba buun wu munaa ni ɲiga na. Ga we wʼa bɔnri wu munaa ni niɲaa nɛ wuu na ge, wee wu da ba wu munaa ɲuŋɔ wolo ɲiga na. ");
INSERT INTO myk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lʼa ɲaha ɲɔ sipya na wu koŋɔ yaŋmuyɔ bɛɛri ta, wu ba buun wuyɛ pile munaa ni, wu gyɛɛgi wɛ? ");
INSERT INTO myk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lee wuu na sipyaa sipya wʼa shiige le wuyɛ ni, na bye wu ya nɛ ni na jomɔ pu kaa yu sipyii mu-i ge, Sipya Ja wu ba ba tuun wemu ni ni wuyɛ pyaa nɔɔrɔ wu ni, ni wu To Kilɛ wo we, ni fɛfɛɛrɛ mɛlɛkɛɛ pu wo we, wu bɛ na ba shiige le wuyɛ ni weefɔɔ shizhaa na. ");
INSERT INTO myk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Can na nʼa da yi jo yi mu, sipyii pii pu wa naha ge, pii wa da xhuu pu ni bada na ta pu ya Kilɛ wo saanra te ɲa wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pe jomɔ pe ya jo cabyaa gbarataanri shishiin, a Yesu di gari ni Pyɛɛri, ni Yohana, ni Yakuba ni faaboboŋɔ ka fugba ni, kɔnhɔ pʼi shɛ Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na wu yaha ɲɛrɛgɛ ki na, a wu ɲɛwiinɛ lʼi ɲɛri, a wu fàya yʼi fiinŋɛ, na ɲí. ");
INSERT INTO myk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Taapile ni a pʼi namaa shuun wa ɲa pee na yu ni Yesu ni, pee bye Musa ni Eli. ");
INSERT INTO myk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pʼa puyɛ shɛ ni nɔɔrɔgbɔ ni. Yesu na ba wu labye wu ɲɔ fa, na xhu xugana lemu na Zheruzalɛmu ni ge, pu bi yu ni wu ni kee keree kii na. ");
INSERT INTO myk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lee bi ŋmunɔgbɔ ta pʼa Pyɛɛri ni wu kaafɛɛ pu shan. Ga ba pʼa ɲɛ wɛ, na Yesu ni pee namaa shuun wu nɔɔrɔ wuu ɲa. ");
INSERT INTO myk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tuun wemu ni pee namaa pʼa laha Yesu tàan ge, a Pyɛɛri di wu pye: «Wù Karamɔgɔ, wèe bu gori naha, lee ya ɲɔ xuuni dɛ. Wù buguloo taanri yereŋɛ, mu wo nigin, Musa wo nigin ni Eli wo nigin.» Ye wu bi yu ge, wu ya yi cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na wu yaha pee jomɔ pu na, a ɲahaŋa ka di ba pu tɔ. Kalaapiire ti nijewuu kee ɲahaŋa ki ni, a pʼi fya. ");
INSERT INTO myk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A mujuu la di foro kee ɲahaŋa ki ni na: «Nɛ ɲidaan Ja wu ɲɛ we. Nɛ wʼa wu shɔɔnri lɔ. Yʼa wu nijoyo nuri!» ");
INSERT INTO myk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ba lee mujuu lʼa foro wɛ, a pʼi Yesu ta wu yɛ. A kalaapiire tʼi cari, pu ya pu kaɲagaa ki paari sipya wa shishiin mu wee tuun wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kee caŋa ki ɲimuguro, pu na tigi xɔ faaboboŋɔ ki na, a sipyiɲɛhɛmɛɛ di shɛ Yesu ɲuŋɔ círi. ");
INSERT INTO myk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A ná wa di mujuugbɔɔ la jo sipyiire ti tɛ ni na: «Karamɔgɔ, nʼa ma ɲɛɛri, ɲɔ mayɛ na mʼa na ja wu wii, we yɛ nigin pe wu ɲɛ na mu. ");
INSERT INTO myk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jina wa wu ɲɛ wu ni, wu bu wu co, taapile ni wʼa ganha na xhuulo. Jina wu na wu ɲahara, fo kakaya na fòro wu ɲɔ ni. Wee jina wu foromɔ pu ma bɛn wu ni, wu nivorogo, wʼa wu kanha xuuni. ");
INSERT INTO myk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɛ ma kalaapiire ti ɲɛɛri jo pu wu kɔri, ga pʼi ya já wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A Yesu di jo: «Ee! Yee kunni ɲɛ sipyikuuyo nʼa daa baa fɛɛ! Nɛ na gori yaha naha ni yee ni, na yee keree xu fo tuun wekɛ wɛ? Pa ni ma ja wu ni naha.» ");
INSERT INTO myk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ba pya wʼa fulo Yesu na wɛ, a jina wu wu shan ɲiŋɛ na, na wu ɲahara xuuni. Ga, a Yesu di din jina wu na, na pya wu cuuŋɔ, na wu kan wu to wu mu. ");
INSERT INTO myk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A Kilɛ wo sefɛɛrɛ nigbɔɔrɔ tʼi bye kakanhana sipyii pu bɛɛri mu. Na Yesu kapyegee ki yaha kʼa pye pu mu kakanhana, a Yesu di wu kalaapiire ti pye: ");
INSERT INTO myk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yi niwegee shan yʼi pe jomɔ pe logo: Pu na ba Sipya Ja wu le sipyii keye ni.» ");
INSERT INTO myk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ga pu bi pee jomɔ pu kɔri cɛ wɛ. Pee bi ŋmɔhɔ pu na, kɔnhɔ pu ganha bu pu kɔri cɛ wɛ. A pʼi fya pu ya já wu yege pee keree na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nakaara ya jé kalaapiire ti tɛ ni, na wekɛ wu ɲɛ pee bɛɛri wo ɲahagbaa fɔɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A Yesu di pu fungɔnyɔ cɛ, na nɔhɔcɛɛrɛ la lɔ, na lee yereŋɛ wuyɛ tàan, ");
INSERT INTO myk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na pu pye: «Sipyaa sipya wʼa le nɔhɔcɛɛrɛ le la shi co xuuni nɛ wuu na ge, nɛ wʼa co xuuni. We wʼa nɛ co xuuni ge, nɛ tunvɔɔ we wʼa co xuuni. We wu wa yee bɛɛri nifɛnhɛfɛnhɛnɛ ge, wee wu wa yee bɛɛri wo sipyigbɔ.» ");
INSERT INTO myk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A Yesu kalaapire Yohana di jomɔ pu lɔ na jo: «Karamɔgɔ, wèe ya ná wa ɲa, wu na jinaa kɔri na yeege sipyii ni mu mɛgɛ na. A wèe di wu ɲaha kɔn lee bye na, bani wu ɲɛ wèe wa wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A Yesu di wu pye: «Yi ganha bu wu ɲaha kɔn wɛ, bani sipya wemu ɲɛ yee pɛn wɛ, yee ɲii wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu bi yaa wu foro koŋɔ puga wʼa gaaŋi fugba wu ni tuun wemu ni ge, ba wee ya tɛɛŋɛ wɛ, a wu li yaha wuyɛ funŋɔ ni na fo wee bu jé Zheruzalɛmu ni, ");
INSERT INTO myk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","a wu tudunmɔɔ pii tun kari wuyɛ ɲaha na. A pee nigariwuu di jé Samari fiige ki kulo la ni, na pʼi shɛ tajege sha wà wu mu. ");
INSERT INTO myk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ga lee kulo li shɛɛn ya sɔɔ wu jé pu mu wɛ, bani Zheruzalɛmu ni wu bi gaaŋi. ");
INSERT INTO myk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ba wu kalaapiire, Yakuba ni Yohana ya lee ɲa wɛ, a pʼi jo: «Kafɔɔ, ma la ɲɛ wù jo na ki yìri fugba we ni, ki tigi pa pu kyɛɛgi ya?» ");
INSERT INTO myk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ga, a Yesu di ŋmahana ɲɛri pu shizhaa na, na din pu na xuuni. ");
INSERT INTO myk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lee kadugo na a pʼi gari kulo latii ni. ");
INSERT INTO myk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na pu yaha koo na pu na gaaŋi, a ná wa di Yesu pye: «Wù Kafɔɔ, xuu bɛɛri ni mʼa se ge, nɛ na daha ma fɛni.» ");
INSERT INTO myk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A Yesu di wu pye: «Sige puun wa ni wejeye ni, fugba shazhɛɛrɛ di ɲɛ ni shiire ni. Ga tashɔngɔ wa Sipya Ja wu mu kemu ɲɛ wuyɛ pyaa wogo wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A Yesu bɛ di wa pye: «Taha na fɛni!» Ga, a wee ná wu wu pye: «Kafɔɔ, na yaha di ba fɛnhɛ na to wu le.» ");
INSERT INTO myk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Yesu di wu ɲɔ shɔ na: «Xuu pu yaha sipyixuyo ye mu yee di da pee leni, mu kunni wu shɛ Kilɛ wo saanra te yɛrɛ pyi.» ");
INSERT INTO myk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ná watii bɛ di jo sanha na: «Kafɔɔ, nɛ na daha ma fɛni, ga ma di sɔɔ di fɛnhɛ zhɛ na puga shɛɛn funŋɔ to.» ");
INSERT INTO myk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A Yesu di wu ɲɔ shɔ na: «Sipyaa sipya wʼa niiyɛ tuugo coni, na gari na wii kadugo yíri ge, wee ya yaa ni Kilɛ wo saanra te ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kee keree kii kadugo na, a Yesu di sipyii kɛlɛɛ gbarashuun ni shuun (72) watii bɛ ɲaha bulo sanha. Wu bi yaa wu shɛ kulogoo ni tɛyɛ yemu bɛɛri ni ge, a wu pu tun kari shuun shuun wuyɛ ɲaha na yee tɛyɛ yi ni. ");
INSERT INTO myk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A wu pu pye: «Shinma nigɔnbaama wʼa ɲɛhɛ, ga kapyebyii pu dʼa cɛ̀rɛ. Lee wuu na, yi shinma wu kafɔɔ wu ɲɛɛri na wu kapyebyii pii bɛ tun sanha, pʼi shɛ wu shinma wu kɔn. ");
INSERT INTO myk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yʼa se! Nʼa yi tun na kari ba dubyapiye ɲɛ mɛ yacoyo niŋɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yi ganha bu wari tayahaŋa lɔ wɛ, kelee kushɛyɛrɛyɛ wɛ, kelee tanhaya yatii wɛ! Yi ganha bu yere koo na di wa shishiin shaari wɛ! ");
INSERT INTO myk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Yi bu jé puga bɛɛri ni yi fɛnhɛ jo: ‹Ɲaɲiŋɛ ki pye kee puga ki ni.› ");
INSERT INTO myk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɲaɲiŋɛ pya wa bu da wà yi wo ɲaɲiŋɛ ki na digi wee na, lee kaa bɛ wɛ ki na guri ba yi mu. ");
INSERT INTO myk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yʼi diin kee puga ki ni! Pu ba lemu kaan yi mu, yʼa lee li, yi da lee gbuu! Bani kapyebye ya sii yaa ni wu saraa ni. Yi ganha ba jin da mari piyɛyɛ yi ni wɛ! ");
INSERT INTO myk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Yi bu jé kulo bɛɛri ni, a pʼi yi co xuuni, yalige ke pu da gan yi mu ge, yi kee li. ");
INSERT INTO myk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yi yama fɛɛ pu cuuŋɔ wà, yʼi yi jo pu mu na Kilɛ saanra tʼa tɛɛŋɛ pu na. ");
INSERT INTO myk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ga yi bu jé kulo la ni, pee di ya sɔɔ na yi co wɛ, yʼi shɛ pu tatiinyɛ yi ni, yʼi jo: ");
INSERT INTO myk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Ali yee kulo li gbazhɛnhɛ ke bɛ kʼa mara wèe tɔɔyɔ yi na ge, wèe da ki pɔ pɔ yee fɛni. Lee bɛ na, yi li cɛ na Kilɛ saanra tʼa tɛɛŋɛ.› ");
INSERT INTO myk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nʼa da yi jo yi mu, Sodɔmu kanhama keree na ba bɔrɔ lee kulo li wogoo na kiiri wu cagɔngɔ.» ");
INSERT INTO myk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A Yesu di jo sanha na: «Bɔɔngɔ ki wa yee Korazɛn shɛɛn wogo! Bɔɔngɔ ki wa yee Bɛtisayida shɛɛn wogo! Bani kakanhaŋaa kiimu kʼa pye yee ni ge, kee da bi bye Tiiri ni Sidɔn kulogoo ki ni, nimɛ bi da pee ta pee ya daajeŋɛ jo, na pu jurumu wu yaha lʼa mɔ, na bɔrɔyɔ le puyɛ na, na diin shɔɔnrɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lee na Tiiri ni Sidɔn wo kanhama keree na ba bɔrɔ yee wogoo ki na kiiri wu cagɔngɔ. ");
INSERT INTO myk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mu do Kapɛrinɔmɔ? Go mu wa giin na mu na ba yirige fo fugba we ni ya? Ahayi dɛ! Mu da ba dirige fo Jahanɛmɛ we ni.» ");
INSERT INTO myk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A wu wu kalaapiire ti pye sanha na: «Wa bu yi jomɔ logo, nɛ jomɔ wʼa logo. Wa bu yi she, nɛ wʼa she. Wa bu nɛ she, we wʼa nɛ tun ge, we wʼa she.» ");
INSERT INTO myk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pee tudunmɔɔ kɛlɛɛ gbarashuun ni shuun (72) wu fundanga wuu ya kuri pa, na jo: «Kafɔɔ, ali jinaa bɛ ya kuu wèe mu mu mɛgɛ ki gbɔɔrɔ ni!» ");
INSERT INTO myk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A Yesu di pu pye: «Nɛ Shitaanni nidogo ɲa na yìri fugba we ni ba Kilɛ-ɲinɛ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Li wii, nʼa se kan yi mu yʼa ɲaari wɔlɔɔ ni namaa ɲuŋɔ ni, yʼi wù Pɛn wu wo sefɛɛrɛ ti bɛɛri tɔnhɔnɔ yi tɔɔyɔ ni, yaaga ka shishiin wa da já kakuunɔ pye yi na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ga lee bɛ na yi funyɔ ganha bu daan na jinaa ya kuu yi mu wɛ. Ga yi funyɔ yi taan, bani yi mɛyɛ wa ka fugba we ni.» ");
INSERT INTO myk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wee tuun wu ni a Yesu di ɲi fundanga na Fɛfɛɛrɛ Munaa li gbɔɔrɔ ni, na jo: «Na To Kilɛ, fugba ni ɲiŋɛ ki Kafɔɔ, nʼa baraga taha ma na, bani mʼa kii keree kii ŋmɔhɔ fungɔnyɔ fɛɛ ni kalaagbɔ fɛɛ na, na ki shɛ nɔhɔpiire na. Uun, na To Kilɛ, bani lee lʼa taan mu mu. ");
INSERT INTO myk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nɛ To wʼa keree ki bɛɛri le nɛ keŋɛ ni. Wa shishiin ya cɛ jɔgɔ wu ɲɛ Kilɛ Ja wu wɛ, fo To Kilɛ wu yɛ nigin. Wa shishiin bɛ di ya cɛ jɔgɔ wu ɲɛ To Kilɛ wu wɛ, fo wu Ja wu yɛ nigin, ni wu la ɲɛ wu To wu shɛ sipya wemu na ge.» ");
INSERT INTO myk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lee kadugo na a Yesu di ŋmahana ɲɛri wu kalaapiire ti yíri, na pee yɛ pye: «Ɲìi kii kʼa yee wo kaɲagaa kii ɲa ge, kee ɲɛ duba wogoo. ");
INSERT INTO myk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bani nʼa da yi jo yi mu na jo lemu yee wa ɲaa ge, Kilɛ tudunmɔɔ niɲɛhɛmɛɛ ni saannaa niɲɛhɛmɛɛ funŋɔ ya pye na lee ɲa, ga pʼi ya li ɲa wɛ. Yemu yee wa nuri ge, pu funŋɔ ya pye na yee logo, ga pʼi ya yi logo wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Caŋa ka, saliya karamɔgɔ wa ya pa yìri yere, na Yesu ɲɔ yege na: «Karamɔgɔ lekɛ nɛ yaa na pye, kɔnhɔ di ɲìi sicuumɔ nixhɔbaama ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Yesu di wu pye: «Karamɔgɔ, lekɛ lʼa ka, Kilɛ wo saliya wu ni wɛ? Lekɛ mu wa galaa wà wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A wee ná wu wu ɲɔ shɔ na: «‹Ma Kafɔɔ Kilɛ wu taan ma mu, ma zɔ wu bɛɛri na, ni ma munaa li bɛɛri, ni ma fanha ki bɛɛri, ni ma fungɔngɔ ki bɛɛri,› na fara lee na: ‹Ma sipyiɲii wu taan ma mu ba mayɛ pyaa ki ɲɛ wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A Yesu di wu pye: «Ma ɲɔshɔɔrɔ tʼa ɲɔ. Ta lee pyi ma na ba ɲìi sicuumɔ ta.» ");
INSERT INTO myk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ga wee saliya karamɔgɔ we funŋɔ bye wu kaɲii kan wuyɛ mu, a wu Yesu yege na: «Wekɛ di ɲɛ nɛ sipyiɲii wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A Yesu di wu ɲɔ shɔ ni talenɛ la ni na: «Ná wa wʼa yìri Zheruzalɛmu ni, na wu da digi Zheriko ni. A java fɛɛ di shɛ do wu na, na wu fàya wolo, na wu yu. Na wu kpɔn fo na wu bana xuuni, na gari na wu yaha wʼa ciregi. ");
INSERT INTO myk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wee tuun wu ni a saraya ɲaha shɔɔnrivɔɔ wa di doro lee koo li ni. Ba wʼa shɛ wee ná wu ɲa wɛ, na waa toro. ");
INSERT INTO myk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lee kadugo na a ná wa bɛ di nɔ wee xuu wu ni, wee ɲɛ Kilɛ-pɛɛŋɛ pugbɔhɔ ki kapyebye wa, na wu ɲa. A wee bɛ di waa toro. ");
INSERT INTO myk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ga, a Samari fiige shɛn wa kushɛwo di shɛ nɔ wu na, na wu ɲa, a wu ɲiɲaara di jé wu ni xuuni. ");
INSERT INTO myk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A wu fulo wu na, na sìnmɛ ni duvɛn le nɔɔyɔ yi ni, na yi pɔ. Na xhɔ na wu durogo wuyɛ pyaa kafaŋa na, na gari ni wu ni nabuun tatigiŋɛ xuu wa ni, na wu keree yari. ");
INSERT INTO myk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ɲimuguro ti na, a wu wari wa wolo kan xuu wu kafɔɔ wu mu, na wu pye: ‹Ta we ná we keree yari. Ma bu latii li wu ɲuŋɔ tàan na toro le tàan, na niguribawo na lee tʼɛrɛŋɛ ma na.›» ");
INSERT INTO myk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","A wu saliya karamɔgɔ wu pye: «Mu ɲii ni java fɛɛ pʼa to ná wemu na ge, pii taanri we ni, wekɛ wʼa pye wu sipyiɲii wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A saliya karamɔgɔ wu wu ɲɔ shɔ na: «We wʼa ɲuŋɔ ɲaari wu na ge.» A Yesu di wu pye: «Ma bɛ wu shɛ lee shi pye.» ");
INSERT INTO myk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na Yesu ni wu kalaapiire ti yaha koo na, a wu jé kulo la ni. A cee wa di wu leŋɛ wu puga wee mɛgɛ ɲɛ Marite; ");
INSERT INTO myk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","wu ceboroshɔ wa mɛgɛ ɲɛ Mariyama. A wee di diin Kafɔɔ tɔɔyɔ tàan, na wu jomɔ nuri. ");
INSERT INTO myk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ga lee di Marite hakili wu ta wʼa wuregi xuuni wu wo puga ki kapyeŋɛɛ ki ɲɛhɛ na. A wu gari na shɛ Yesu pye: «Kafɔɔ, nɛ ceboroshɔ wʼa nɛ yɛ nigin yaha kapyeŋɛɛ ki na, lee wa kaa mu ɲii ni-i gɛ? Yi jo wu mu na wu na tɛgɛ!» ");
INSERT INTO myk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Kafɔɔ di wu ɲɔ shɔ na: «Marite, Marite, mu wa mayɛ kana, na keree niɲɛhɛŋɛɛ taga mayɛ funŋɔ pɛn. ");
INSERT INTO myk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ga kaa nigin yɛ kaɲɔɔ di ɲɛ. Mariyama wʼa taa nizaana li shɔɔnri. Lee wa da ba shɔ wu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Caŋa ka, Yesu bi Kilɛ ɲɛɛri. Ba wʼa xɔ wɛ, a wu kalaapire la di wu pye: «Wù Kafɔɔ, wù taanni Kilɛ-ɲɛrɛgɛ ni, ba Yohana ya wu wo kalaapiire ti taanni taannigana lemu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A Yesu di pu pye: «Yi ba da Kilɛ ɲɛɛri yʼi jo: ‹Wèe To Kilɛ, mu mɛgɛ ki pye fɛɛfɛɛ, ma saanra ti pa. ");
INSERT INTO myk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wù caŋa bɛɛri wo ɲɔlige kan wù mu. ");
INSERT INTO myk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wù jurumu wu yafa wù mu, bani wèe bɛ ya wù sipyiɲii wo nahama pu yafani pu mu. Ma ganha bu wù yaha wù jé nɔwuuro ni wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A Yesu di pu pye sanha na: «Yee ni, jɔgɔ wu dʼa bye ni naɲii ni, ma bu shɛ wu yíri ɲiɲiŋɛ na na wu pye: ‹Na naɲii buuri ɲuyɔ taanri foo le na na, ");
INSERT INTO myk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bani nɛ naɲii wa wʼa pa nimɛ na yìri kulo la ni, yaaga di ɲɛ nɛ mu di gan wu mu wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wee bu diin puga ki funŋɔ ni na wu ɲɔ shɔ na: ‹Ma ganha bu na kanha wɛ. Gbura kʼa shɔ̀hɔ, nɛ ni na nagoo ya sinnɛ xɔ. Nʼa da já yìri di buuri kan ma mu wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A Yesu di jo: «Ayiwa, nʼa da yi jo yi mu, wu bye wu ya yìri na wu kan naɲɛɛgɛ ki wuu na wɛ, wu na yìri na wu ɲidaan yaŋmuyɔ bɛɛri kan wu mu wu navunŋɔ ki wuu na. ");
INSERT INTO myk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Nɛ kunni na yi jo yi mu, yʼa ɲɛɛri, yi na da daa. Yʼa zhaa, yi na da ɲaa. Yʼa gbura ki kuuni, gbura ki na da muri yi mu. ");
INSERT INTO myk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bani sipyaa sipya wʼa ɲɛrɛgɛ pyi ge, wee na da daa. Wemu wʼa zhaa ge, wee na da ɲaa. Wemu wʼa gbura ki kuuni ge, gbura ki na da muri weefɔɔ mu. ");
INSERT INTO myk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Pya to wekɛ wu wa yee ni wu ja wu fya ɲɛɛri wu mu, wu wɔ kan wu ja wu mu fya wu wege ni wɛ? ");
INSERT INTO myk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kelee yee wa pya bu xhucɛrɛ ɲɛɛri wu mu, wufɔɔ na zɔɔ di nà kan wu mu xhucɛrɛ li wege ni gɛ? ");
INSERT INTO myk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wee tuun wu ni, yee piimu pʼa kolo ge, yee bi yasaaya kangana cɛ mu yi nagoo pu mu. Ayiwa, ta yee fugba To wu da ba Fɛfɛɛrɛ Munaa li kan fo xuuni li ɲɛɛrivɛɛ pu mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu bi jina bobo wa kɔri yeege ná wa ni. Jina wu na foro xɔ, a wee ná wu já na yu. A lee di bye kakanhana sipyiire ti bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ga, a pii di jo pu ni na: «Jinaa ɲuŋɔfɔɔ Belizebuli fanha ni wʼa jinaa pu kɔri.» ");
INSERT INTO myk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Piitiilee bɛ funŋɔ bye pʼi wu taanna wii. A pee di ɲaha shɛshɛɛrɛ kakanhana la ɲɛɛri wu mu na yìri fugba we ni. ");
INSERT INTO myk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ga, a Yesu di pu fungɔnyɔ cɛ na jo: «Saanra bɛɛri tʼa yìri tiyɛ kaa na ge, tee na gyɛɛgi. Puga bɛɛri, ki sipyii bu yìri puyɛ kaa na, kee na gyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Shitaanni bɛ bu yìri wuyɛ kaa na, wu saanra ti na bye dii kyɛɛgi baa wɛ? Bani yee ya jo na Belizebuli gbɔɔrɔ ni nɛ jinaa kɔri na yeege sipyii ni. ");
INSERT INTO myk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɛ bi jinaa kɔri na yeege sipyii ni Belizebuli gbɔɔrɔ ni, yee wo nagoo pʼi wa pu kɔri jɔgɔ gbɔɔrɔ ni wɛ? Peeyɛ pyaa na ba kiiri kɔn yee na. ");
INSERT INTO myk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ga nɛ bu da nɛ na jinaa pu kɔri Kilɛ wo sefɛɛrɛ ti baraga ni, lee wʼa li shɛɛ na Kilɛ saanra tʼa nɔ yee na. ");
INSERT INTO myk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Fanhaɲɛhɛŋɛ fɔɔ wemu ɲɛ ni kashɛn yaŋmuyɔ nijeye ni ge, wee ba wu puga kasɛɛgɛ pyi; sipya wa shishiin da já wee keŋɛ yaŋmuŋɔ lɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ga ná wemu fanha kʼa ɲɛhɛ wu wogo na ge, wee ba ba se ta wu na, wu bi daa yagboyo yemu na ge, wu na yee bɛɛri shɔ wu na, na wu keŋɛ yaŋmuyɔ yi bɛɛri xuu, na yi taa taa wu kaafɛɛ na. ");
INSERT INTO myk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wemu ɲɛ nɛ ɲii wɛ, wee ɲɛ nɛ pɛn. Wemu ya nɛ tɛri na yaaŋa pyi wɛ, wee ɲɛ kakabye.» ");
INSERT INTO myk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Jina bu foro sipya ni tuun wemu ni, tɛyɛ yemu yʼa waha waha ge, wʼa ganha na ɲaari yee ni na taŋmɔŋɔ shaa. Wu bye wu ya kee ta wɛ, wʼa jo wuyɛ funŋɔ ni na: ‹Na puga kemu ni nɛ foro ge, nʼa da guri da se kee ni.› ");
INSERT INTO myk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wʼa guri kari, na shɛ kee puga ki ta pʼa ki pɔ fɛɛfɛɛ, na ki kemɛ xuuni. ");
INSERT INTO myk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wee tuun wu ni wʼa gari, na shɛ ba ni jinaa gbarashuun watii ni, piimu ya kolo wuyɛ pyaa ki na ge. Wu ni pee na ba jé kee puga ki ni, na diin wà. Lee funŋɔ ni wee sipya we wo taxɔgɔ na ba golo na toro taashiinɛ li bɛ tàan.» ");
INSERT INTO myk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na Yesu yaha pee jomɔ pu na, a cee wa di mujuugbɔɔ wá, na wu yaha sipyiire ti niŋɛ ni na: «Cee we wʼa yere mu yacɛrɛ na, na jire kan mu mu ge, wee ɲɛ duba pya.» ");
INSERT INTO myk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A Yesu di jo: «Uun, ga piimu pʼa Kilɛ jomɔ pu nuri na pu koro ɲaari ge, pee pu ɲɛ duba nagoo puyɛ pyaa!» ");
INSERT INTO myk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na sipyiire ti yaha tʼa Yesu maha fo na wu cɔnri, a wu jomɔ ɲɔ kɔn na: «Niɲaa sipyii pʼa kolo. Pʼa ɲaha shɛshɛɛrɛ kakanhana la shaa, ga la shishiin da zhɛɛ pu na wɛ, fo Kilɛ tudunmɔɔ Zhonasi wuu le. ");
INSERT INTO myk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Zhonasi ya pye ɲaha shɛshɛɛrɛ na shɛ Ninive shɛɛn na shɛgana lemu na ge, mu Sipya Ja bɛ na ba bye ɲaha shɛshɛɛrɛ na shɛ niɲaa sipyii na. ");
INSERT INTO myk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kiiri wu cagɔngɔ, Seba fiige ki Saanzhɔ wu na ba yìri wu niɲaa sipyii pu jaagi. Bani wee ya pa na yìri ɲiŋɛ ki tɛhɛnɛ na, kɔnhɔ wu ba saannaa Solomani wo fungɔngɔ fɛɛrɛ jomɔ pu logo. Wa di wa naha wemu wʼa pɛlɛ Solomani na ge! ");
INSERT INTO myk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kiiri wu cagɔngɔ, Ninive shɛɛn na ba yìri na niɲaa sipyii jaagi, bani Ninive shɛɛn ya yere pu jurumu wu na Zhonasi wo Kilɛ jomɔ yɛrɛ li funŋɔ ni. Wa di wa naha wemu wʼa pɛlɛ Zhonasi na ge! ");
INSERT INTO myk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Wa shishiin ya sokinna leni wu wu ŋmɔhɔ, kelee wu yaaga shigile wu ɲuŋɔ ni wɛ. Ga yaaga ɲuŋɔ ni wu da wu taha, kɔnhɔ puga ki jevɛɛ da wu kpɛɛngɛ ɲaa. ");
INSERT INTO myk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sipya ɲìi ki ɲɛ wu ceepuuro sokinna. Ma ɲìi ki bu ɲɔ, ma ceepuuro ti bɛɛri ti wa kpɛɛngɛ ni, ga ma ɲìi ki bu bye ki ya ɲɔ wɛ, ma ceepuuro ti bɛɛri ti wa piige ni. ");
INSERT INTO myk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ta mayɛ kasɛri, kɔnhɔ ma funŋɔ kpɛɛngɛ ki ganha bye nibiige wɛ. ");
INSERT INTO myk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lee na, ma ceepuuro ti bɛɛri bu bye kpɛɛngɛ ni, piige bu bye kʼi ɲɛ ti xuu wa shishiin ni wɛ, ti bɛɛri na kpɛɛngɛ yeege, ma na jo ba sokinna ya kpɛɛngɛ yeege yeegegana lemu na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na Yesu yaha pee jomɔ pu na, a Farizhɛn wa di wu ɲɛɛri na wu shɛ caŋa yalige li wee puga. A Yesu di jé puga ki ni, na diin na li. ");
INSERT INTO myk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ba wee ya Yesu ɲa wu na li wu keye jebaa wɛ, a lee di wu fo. ");
INSERT INTO myk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ga, a Kafɔɔ di wu pye: «Yee Farizhɛɛn kunni wa cɛɛgbuugoo ni golɛyɛ kaduyo jii na fiinni, na ta yee funyɔ dʼa ɲi nagaara keree ni kuumɔ tuugo bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fungɔnyɔ baa fɛɛ! Kilɛ wemu wʼa yaŋmuyɔ yi kaduyo yàa ge, ta wee bɛ wʼa yi funyɔ yi bɛ yàa wɛ? ");
INSERT INTO myk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ga yi golɛyɛ yi funŋɔ yasaaya yi kan la baa fɛɛ mu, lee na yi bɛɛri na bye fɛɛfɛɛ yi mu. ");
INSERT INTO myk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Bɔɔngɔ ki wa yee wogo Farizhɛɛn, bani yee wa nanayi, ni shiga yaŋmuyɔ ni loyɔ yaŋmuyɔ yi saya bɛɛri jagi wo. Ga yʼi da gbara yi taan ni Kilɛ ni, yʼi da tiimɛ keree pyi wɛ. Yee bi yaa na kii kagbɔhɔɔ kii pyi, na te nibiire te fara kee na. ");
INSERT INTO myk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Bɔɔngɔ ki wa yee wogo Farizhɛɛn, bani yee wo ɲidaan wu ɲɛ Kilɛ-pɛɛŋɛ piyɛyɛ yi wo ɲahagbaa tatiinyɛ, ni sipyii pʼa yi shaari pinnɛrɛ kpɛɛnyɛ na. ");
INSERT INTO myk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bɔɔngɔ ki wa yee wogo, bani yee ya foro faya fɛni yemu yʼa ŋmɔhɔ ge. Sipyii wa ɲaari yi na na ta pu ya yi cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A saliya karamɔgɔ wa di wu pye: «Karamɔgɔ, ba mu wa pe jomɔ pe yu wɛ, wèe bɛ mu wa fanri.» ");
INSERT INTO myk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A Yesu di wu ɲɔ shɔ na: «Bɔɔngɔ ki wa yee saliya karamɔgɔlɔɔ pu bɛ wogo, bani tuguro temu lɔmɔ pʼa pɛn ge, tee yee wa dɛri sipyii ɲuyɔ ni, yʼi da zɔɔ yi pu tɛgɛ ni yi kabee bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Bɔɔngɔ ki wa yee wogo, bani yee wa Kilɛ tudunmɔɔ pu faya yi yari na ɲɔgi, na ta yee sefɛlɛɛ dʼa pu gbo. ");
INSERT INTO myk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lee wa li shɛɛ na yee wa sɔɔ yi sefɛlɛɛ pu kapyegee ki na, bani pee pʼa Kilɛ tudunmɔɔ pu gbo, a yee kunni di pu faya yàa. ");
INSERT INTO myk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lee wuu na Kilɛ ya jo wu fungɔngɔ fɛɛrɛ ti ni na: ‹Nɛ na ba Kilɛ tudunmɔɔ ni tudunmɔɔ tun pu mu. Pu na ba pii gbo, na daha pii fɛni na gana.› ");
INSERT INTO myk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lee na ba bye, kɔnhɔ Kilɛ tudunmɔɔ piimu wo shishan pʼa wo fo koŋɔ ki ɲɔ kɔnduun wu ni ge, pee bɛɛri foo di ba yege niɲaa sipyii na. ");
INSERT INTO myk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Na ɲɔ kɔn Abɛli wo shishan pu na, fo na pa nɔ Zakari wo shishan pu na, wee wemu pʼa gbo saraya yi tawologo ke, ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki tɛ wu ni ge. Uun, nʼa da yi jo yi mu, pee shishan pu bɛɛri foo na ba yege niɲaa sipyii na. ");
INSERT INTO myk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Bɔɔngɔ ki wa yee wogo saliya karamɔgɔlɔɔ, bani yee ya Kilɛ saanra ti cɛmɛ pu kenikaan li wolo, yiyɛ pyaa ya jé wɛ. Piimu pʼa giin pʼi jé ti ni ge, a yee di pee bɛ ɲaha kɔn.» ");
INSERT INTO myk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ba Yesu ya yìri wee xuu wu ni wɛ, a saliya karamɔgɔlɔɔ ni Farizhɛɛn pʼi ɲɔ kɔn, na wu kana, na wu ɲɔ yegee yegegana bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pu bi wu kasɛri, kɔnhɔ pʼi wu tɔɔgɔ taleŋɛ ta ni wuyɛ pyaa ɲɔ kafila ni. ");
INSERT INTO myk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wee tuun wu ni sipyiire ti bi tiyɛ pinnɛ, pu bi sii ɲɛhɛ fo na doro. A pʼi jɔnri, fo na duri puyɛ tɔɔyɔ na. A Yesu di fɛnhɛ jomɔ ɲɔ kɔn ni wu wo kalaapiire ti ni na: «Yʼa yiyɛ kasɛri Farizhɛɛn wo buuri shizhɛnhɛrɛ ti na! Tee ɲɛ pu shuun shuun juuro te. ");
INSERT INTO myk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yaaga ka shishiin niŋmɔhɔŋɔ wa kemu da ba foro kpɛɛngɛ na wɛ. Kaŋmɔhɔnɔ la shishiin wa lemu da ba jɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lee wuu na yʼa yemu bɛɛri jo nibiige ni ge, yee na ba logo kpɛɛngɛ na. Yʼa yemu bɛɛri jo sipyii mu kalɔhɔrɔ ni maaya ni ge, pu na ba yee caaga kataya na.» ");
INSERT INTO myk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Na naɲiinɛɛ, nʼa da yi jo yi mu, piimu na já sipya gbo, na ta pʼi da já latii pye lee kadugo na-ɛ ge, yi ganha ba fyagi pee na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lemu na yʼa yaa na fyagi ge, nʼa da lee shɛ yi na. Se wa Kilɛ wemu ni na sipya munaa wolo, na xhɔ na li wá Jahanɛmɛ ni ge, yʼa fyagi wee na. Uun, nʼa da yi jo yi mu, yʼa fyagi wee na. ");
INSERT INTO myk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ta cɔnrilɔɔ kaguro bɛ pʼa bɛrɛɛ wari pyaa shuun wɛ? Lee bɛ na, ali wee wa nigin bɛ, Kilɛ funŋɔ ya wuu wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yee kunni Kilɛ ya ali yee ɲuzhiire teyɛ pyaa bɛɛri ɲɔ cɛ. Yi ganha ba fyagi wɛ; yʼa ye cɔnrilɔɔ niɲɛhɛmɛɛ na! ");
INSERT INTO myk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Nʼa da yi jo yi mu, sipyaa sipya wʼa yere li na sipyii ɲaha tàan na nɛ wo wee ɲɛ ge, Sipya Ja wu bɛ na ba yere li na Kilɛ wo mɛlɛkɛɛ pu ɲaha tàan na weefɔɔ ɲɛ wee wo. ");
INSERT INTO myk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ga wemu bu foro nɛ kaa tàan sipyii ɲaha tàan, Sipya Ja wu bɛ na ba foro weefɔɔ kaa tàan Kilɛ wo mɛlɛkɛɛ pu ɲaha tàan. ");
INSERT INTO myk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sipyaa sipya wʼa joguumɔ jo wá Sipya Ja na ge, lee na yafa wufɔɔ mu. Ga wemu bu Fɛfɛɛrɛ Munaa li mɛgɛ kyɛɛgi, weefɔɔ da lee wo yafa ta wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Sipyii ba se na kiiri kɔɔn yi na Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, ni kiirikɔɔn, ni fanhafɛɛ ɲaha tàan, yi ɲɔshɔɔrɔ ni yi nijoyo ganha bu da bye yi mu funzhaga wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bani jomɔ pemu yʼa yaa na jo ge, Fɛfɛɛrɛ Munaa na ba yi kalaa pu ni taapile ni.» ");
INSERT INTO myk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A ná wa di diin sipyiire ti tɛ ni na Yesu pye: «Karamɔgɔ, yi jo na ceborona wu mu na wu wù cɛn wu loolo wù na!» ");
INSERT INTO myk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ga, a Yesu di wu ɲɔ shɔ na: «Na naɲii, jɔgɔ wʼa nɛ teŋɛ na pye yee kiiri kɔnvɔɔ, kelee yi cɛn loolovɔɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lee kadugo na a wu yi jo pu bɛɛri mu na: «Yʼa yiyɛ kasɛri ɲɛgbɔɔ keree na, bani sipya naafuu ɲɛhɛ ɲɛhɛ ɲɛhɛgana bɛɛri na, wu ɲiifɛɛrɛ ya fòro wee ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wee tuun wu ni a wu le talenɛ le jo pu mu na: «Faa ya taan ná naafuu fɔɔ wa na xuuni. ");
INSERT INTO myk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A wu wu funŋɔ sha na: ‹Lekɛ nɛ da bye wɛ, bani na shinma wu bɛɛri tayahaŋa wa wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A wu jo: ‹Li wii, le nʼa da bye. Nʼa da na kpɔngɔɔ ki ja di kiitiigee yereŋɛ, di kee pɛlɛ nizhiigee ki na, di ba na shinma ni na keŋɛ yaŋmuyɔ bɛɛri pinnɛ le kee funyɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lee kadugo na, di nayɛ pye jo yaŋmuyɔ niɲɛhɛyɛ yʼa gbegele yaha nɛ mu yee niɲɛhɛŋɛɛ ɲaha na, nʼa da nayɛ ŋmɔ di da li, di da gbuu, di da kaleŋɛɛ pyi.› ");
INSERT INTO myk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ga, a Kilɛ di wu pye: ‹Mu nahanaha we! Niɲaa piige ke ni mu munaa da zhɔ mu na. Wee tuun wu ni, yaŋmuyɔ ye mʼa pinnɛ ge, yee ma bye jɔgɔ woyo wɛ?›» ");
INSERT INTO myk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ayiwa, lee funŋɔ ni a Yesu di jo: «Sipyaa sipya wʼa naafuu pinnɛɛ wuyɛ nigin wuu na ge, na ta wu ɲɛ naafuu fɔɔ Kilɛ kabaŋa na-ɛ ge, mumɛ weefɔɔ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wee tuun wu ni a Yesu di wu kalaapiire ti pye: «Lee wuu na nʼa da yi jo yi mu, yi ganha ba yi funyɔ shaa ni yi ɲɔshaga ni na ɲaha yʼa da li wɛ. Yi ganha ba yi funyɔ shaa ni yi cére fàya ni, na ɲaha yʼa da leni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bani sipya munaa ya ye yalige na, wu ceepuuro bɛ dʼa ye cére fàya na. ");
INSERT INTO myk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yi shazhɛɛyɛ kanraya ye wii. Yi wa yemɛ nuri wɛ, yʼi wa shinma kɔɔn wɛ. Yaŋmuyɔ tayahaŋa kelee kpɔɔn wa yi mu wɛ, lee bɛ na, Kilɛ di yi ɲɔ shaa. Ta yee ya ye shazhɛɛyɛ na na kanha wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jɔgɔ wu wa yee ni, wemu na já ali jɛɛrɛ bɛ fara wuyɛ pyaa shi wu na ni funzhaga ni wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lee wuu na, yee bye yee da já lee kapire le pye wɛ, ɲaha na yee di yi funyɔ shaa ni keree kisaŋaa ni wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Yi yaweye yi fyɛngana li wii, yʼa fyɛɛnrɛ nizaara temu pyi ge! Yi wa kapyeŋɛɛ pyi wɛ, yʼi wa fàya shin wɛ! Ga nʼa da yi jo yi mu, ali saannaa Solomani ni wu naafuu wu bɛɛri ni, wu fàŋa ka ya ke yawege ke ka fyɛnrɛ nigin bɛ xɔ saana ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɲà ke ki wa sige ki ni niɲaa, na ta na di da ba kee sòrogo ɲiga na ge. Ni Kilɛ ya kee nɔhɔ tɔni lee tɔgana li na, go wu na ba yee nɔhɔ tɔ xuuni na ye kee na dɛ! Yee nʼa daa wʼa cɛ̀rɛ dɛ! ");
INSERT INTO myk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yi na ba kemu li na kemu gba ge, yi ganha ba yi funyɔ shaa ni yee zha ni wɛ! Yi ganha ba yiyɛ kaala yee da na wɛ! ");
INSERT INTO myk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kilɛ cɛbaalaa pʼa ye yaŋmuyɔ ye bɛɛri shaa, ga yee To Kilɛ wʼa li cɛ na yee bɛ mago wa yee na. ");
INSERT INTO myk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yee kunni pʼa Kilɛ wo saanra te shaa. Lee kadugo na Kilɛ na ye yaŋmuyɔ ye kan yi mu, na la taha yi na.» ");
INSERT INTO myk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lee kadugo na a Yesu di wu kalaapiire ti pye sanha: «Yi ganha bu da vya wɛ, yee piimu pu ɲɛ ba yatɔɔgbara ɲɛ-ɛ ge, bani lʼa taan yee To Kilɛ ni na wu saanra ti kan yee mu. ");
INSERT INTO myk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yi yi keŋɛ yaŋmuyɔ pɛrɛ kan la baa fɛɛ mu. Yi wari tayahaya nilɛbaaya yàa yiyɛ mu, yʼi naafuu nixhɔbaama pinnɛ fugba wu ni, nagaa wa wà wɛ, fyɛɛnrɛ da já wu kyɛɛgi wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bani xuu wemu ni ma naafuu wa ge, wà ma zɔ wu bɛ funzhaga wa.» ");
INSERT INTO myk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yi yiyɛ pɔ xuuni ni kirimɛhɛɛ ni labye wu fɛni, yʼi yi sokinnaa pu ɲí yaha. ");
INSERT INTO myk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yʼi bye ma na giin kapyebyii piimu pʼa pu ɲuŋɔfɔɔ sigee ge, wu ba ma na yìri cekaanra tɛgɛ ni tuun wemu ni, kɔnhɔ wu bu ba kuɲɔɔ li kuu, pʼi kuɲɔɔ li mugi wu mu tɔvuyo na. ");
INSERT INTO myk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɲuŋɔfɔɔ wu ba kapyebyii piimu ta pu na wu ɲaha wii, pee ɲɛ duba nagoo. Can na nʼa da yi jo yi mu, wu na ba wuyɛ pɔ xuuni ni kirige ni wu pee teŋɛ yalige ki ɲuŋɔ ni, wu yalige ki taa taa pu na. ");
INSERT INTO myk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wu ba ba ɲiɲiŋɛ kelee ɲimuguɲɔ na, na ba pu ta ɲìi na, pee ɲɛ duba nagoo. ");
INSERT INTO myk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yi li cɛ na puga fɔɔ da ba li cɛ na we lɛɛri we na nagaa da ba ba nibiige ni, wu da ga gbara nagaa wu jé wu puga wɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yi bɛ pu gbegele yaha, bani yee ya Sipya Ja wu soŋi tuun wemu ni wɛ, wee tuun weyɛ pyaa ni wu da ba.» ");
INSERT INTO myk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A Pyɛɛri di wu pye: «Kafɔɔ, wèe yɛ wuu na mʼa le talenɛ le yu laa, ta sipyiire ti bɛɛri wuu na?» ");
INSERT INTO myk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Kafɔɔ di jo: «Kaɲahashɔɔnrimɔ ɲɔmɛɛ fɔɔ fungɔngɔ fɔɔ wemu wo kafɔɔ wʼi da ba wu teŋɛ wu kapyebyii pusamaa ɲuŋɔ ni, na wu pye na wʼa pu ɲɔlige keree ɲaha wo ki tuun ni ge, wee ɲɛ jɔgɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wee kapyebye wu kafɔɔ wu ba ba, na ba wu ta wu na li pyi li pyegana na, wee ɲɛ duba pya. ");
INSERT INTO myk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can na nʼa da yi jo yi mu, wee kapyebye wu kafɔɔ wu na ba wu teŋɛ wu keŋɛ yaŋmuyɔ yi bɛɛri ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ga wee kapyebye wu bu li yaha wuyɛ funŋɔ ni na wee kafɔɔ wʼa da zhɛ mɔ wu da ba wɛ. Wʼa ɲɔ kɔn na wu kapyebyeɲii namaa ni cèe pu sani, na li, na gbuu, na wuyɛ ɲini sinmɛ na. ");
INSERT INTO myk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ayiwa, caŋa kemu ni tuun wemu wu ɲɛ kapyebye wu ya wu kafɔɔ wu soŋi-i ge, kee caŋa ke ni wee tuun we ni wu da ba. Wu na ba wee kapyebye we kɔri, na wu taa pinnɛ ni Kilɛ cɛbaalaa wuu ni. ");
INSERT INTO myk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Kapyebye we wʼa wu ɲuŋɔfɔɔ ɲidaan cɛ ge, wu bye wu ya gbegemɛ pye, na kapyeŋɛɛ pye na bɛ ni wu ɲidaan wu ni wɛ, wee wo kpɔɔnrɔ ti fanha na bɛlɛ. ");
INSERT INTO myk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ga kapyebye wemu ya wu ɲuŋɔfɔɔ ɲidaan cɛ wɛ, wu bu keree kii pye kiimu kʼa wu kakpɔɔn xɔ ge, wee wo kpɔɔnrɔ ti fanha na jɛrɛ. Niɲɛhɛŋɛɛ ya kan wemu mu ge, niɲɛhɛŋɛɛ na ba zha wee mu. Niɲɛhɛŋɛɛ kaa ya le sipya wemu keŋɛ ni ge, pu na ba wee yege sanha niɲɛhɛŋɛɛ na.» ");
INSERT INTO myk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Na nɛ pa wá ɲiŋɛ ki na. Nimɛ da ba ki ta ki na ɲí na xɔ, lee bi da daan nɛ ni! ");
INSERT INTO myk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kanhama nigbɔ pa wa wà, nɛ yaa na jé pee ni. Ga na funjɔnrɔgɔ wo wʼa pee sigee. ");
INSERT INTO myk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yee wa giin na ɲaɲiŋɛ ni nɛ pa koŋɔ na ya? Ahayi dɛ, nʼa da yi jo yi mu, fo waagi. ");
INSERT INTO myk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Fo nimɛ sipyii kaguro na ba bye puga nigin ni, pu na ba daa. Sipyii taanri na ba yìri sipyii shuun fɛni; shuun wu bɛ na ba yìri taanri wu fɛni. ");
INSERT INTO myk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","To na ba yìri wu ja fɛni, ja bɛ na ba yìri wu to fɛni. Nu na ba yìri wu poro fucɛɛrɛ fɛni, poro fucɛɛrɛ bɛ na ba yìri li nu fɛni. Yashɔ na ba yìri wu ja shɔ fɛni, ja shɔ bɛ na ba yìri wu yashɔ fɛni.» ");
INSERT INTO myk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A Yesu di yi jo sipyiire ti mu sanha na: «Yee bu Kilɛ wu ɲa wʼa wɔ suumɔ lɔhɔ ki ɲuɲɔ na camutomɔ yíri tuun wemu ni, taapile ni yee na jo na zanha ki da do, li shiin na bye mu. ");
INSERT INTO myk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kafɛɛgɛ bu foro Kilɛ-parama yíri, yee na jo na kafugo ki da ba bye, li shiin na bye mu. ");
INSERT INTO myk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Shuun shuun jovɛɛ! Yee wa fugba we ni ɲiŋɛ ke keree cɛ na shɔɔnri kiyɛ ni, ɲaha dʼa li pye yee ya we tuun we keree cɛ na shɔɔnri-i wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ɲaha kʼa li pye yee ya ta kodiinɛ cɛ shɔɔnri yiyɛ ni-i wɛ? ");
INSERT INTO myk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na ma ni ma kiiri kɔnɲii wu yaha, yi na se kiiri wu takɔngɔ ki ni, la le yʼi bɛ yi na ma ni wu ni na yi yaha koo li na, lee bɛ wɛ, wu na zhɛ ni ma ni kiiri kɔnvɔɔ wu mu, wee na ma kan gɛdii pu mu pʼa le kaso ni. ");
INSERT INTO myk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nʼa da yi jo ma mu, ma bu jé wee kaso wu ni, ma da ga foro wà ni wari pile nigin bɛ foo ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wee tuun wu ni Pilate bi Galile shɛɛn pii gbo na pu yaha saraga yatɔɔgbuu li na, na pee wo shishan ni saraga yatɔɔyɔ yi shishan wuregi puyɛ ni. A sipyii pii di shɛ wee kafila wu jo Yesu mu. ");
INSERT INTO myk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Yesu di pu pye: «Yee wʼa giin na pii Galile shɛɛn pii wa jurumupyii na toro Galile shɛɛn pusamaa bɛɛri taan, na lee wuu na pʼa pu gbo le gbogana le na gɛ? ");
INSERT INTO myk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nʼa da yi jo yi mu jo ahayi dɛ. Ga yee bye yee yʼa daburajɛ jo yi jurumu wu na wɛ, yee bɛɛri na ba gyɛɛgi mu. ");
INSERT INTO myk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Silowɛ zangaso-tɔɔngɔ kʼa to sipyii kɛ ni gbarataanri (18) wemu ɲuŋɔ ni na gbo ge, yee wa giin na pee bye jurumupyii na toro Zheruzalɛmu shɛɛn pusamaa tàan ya? ");
INSERT INTO myk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nʼa da yi jo yi mu jo ahayi dɛ. Ga yee bye yee ya daburajɛ jo yi jurumu wu na wɛ, yee bɛɛri na ba gyɛɛgi mu.» ");
INSERT INTO myk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lee kadugo na a Yesu di le talenɛ le jo na: «Nitoodige ka bi nɔri ná wa ɛrɛzɛn tɛgɛ ni. A wu ganha na se na nitoroŋɔ shaa ki na, ga wu da ga nitoroŋɔ ta ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wee tuun wu ni a wu yi jo wu kapyebye wu mu na: ‹Nɛ yee taanri wuu li wa le na pya shaa ke nitoodige ke na nɛ da wu ta wɛ. Ki kɔn! Ɲaha na kʼi wa ɲiŋɛ ki na tawaga ni wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ga, a kapyebye wu wu ɲɔ shɔ na: ‹Na ɲuŋɔfɔɔ, ki yaha kʼi yee pye sanha. Di wege tugi daga ki maha di kaafugo le ki ni. ");
INSERT INTO myk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","La wa la ni ki na nagoo pye yee la, lee na bɔrɔ. Ga ki bye kʼi ya nagoo pye wɛ, mʼa ki kɔn.›» ");
INSERT INTO myk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cadɛɛngɛ ka ni, Yesu bi sipyii kalaa Kilɛ-pɛɛŋɛ puga ka ni. ");
INSERT INTO myk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lee di cee wa bɛ ta wà, jinaa yama bye wu ni fo yee kɛ ni gbarataanri (18). Pee bi wu kuri; wu bi já yìri tii wɛ. ");
INSERT INTO myk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ba Yesu ya wu ɲa wɛ, na wu yiri na wu pye: «Cee we, mʼa shɔ ma yama pu na niɲaa.» ");
INSERT INTO myk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A Yesu di wu keye taha wu na. Taapile ni, a wu yìri tii, na Kilɛ pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ga, a Kilɛ-pɛɛŋɛ puga ki ɲuŋɔfɔɔ wu luu di yìri, bani Yesu ya yama fɔɔ wa cuuŋɔ cadɛɛngɛ ni. A wu sipyii pu pye: «Cabyaa gbaara wu ɲɛ wà kapyeŋɛɛ ya yaa na byi kiimu funŋɔ ni ge. Yʼa ma yee caya yi na, kɔnhɔ yʼi juuŋɔ. Yi ganha ba ma cadɛɛnyɛ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Kafɔɔ di wu pye: «Yee shuun shuun jovɛɛ piiri! Ta yee bɛɛri nigin nigin ya yi niiyɛ, kelee yi kafaya sanhana cadɛɛnyɛ ni, na se na yi kaan yi na gbuu wɛ? ");
INSERT INTO myk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","We cee we wu ɲɛ Ibirayima wo pya wa ge, wu nibɔgɔ di ɲɛ Shitaanni mu fo yee kɛ ni gbarataanri (18) ge, ta tee pɔɔrɔ te ya yaa na sanha wu na cadɛɛngɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tuun wemu ni Yesu ya yee jo ge, a wu pɛɛn pu bɛɛri di zhiige, ga, a sipyii pu bɛɛri di fundanga ta wu kagbɔhɔɔ ki bɛɛri bye wuu na. ");
INSERT INTO myk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ayiwa a Yesu di pu pye: «Kilɛ saanra ti ni ɲaha kʼa foro yiyɛ fɛni wɛ? Ni ɲaha ni nʼa da ti taanna wɛ? ");
INSERT INTO myk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tʼa foro mutaridi pile fɛni. A ná wa di li lɔ nugi wu tɛgɛ ni. A lʼi bɛlɛ, na bye tigbɔhɔ. A shazhɛɛrɛ di ba ti shiire tagi ki geye na.» ");
INSERT INTO myk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu ya jo sanha na: «Ni ɲaha ni nʼa da Kilɛ wo saanra te taanna sanha wɛ? ");
INSERT INTO myk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ti ɲɛ ba buuri shizhɛnhɛrɛ ɲɛ wɛ. Cee wa ya tee le wu farani myɛ kiloo kɛlɛɛ shuun ni kaguro (25) ni na tɔnhɔ, a wu bɛɛri di yìri.» ");
INSERT INTO myk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu bi kugbɔhɔɔ ni kupiire ɲaari. Wʼa bi gaaŋi Zheruzalɛmu ni, wu nigariwo bi sipyii kalaa. ");
INSERT INTO myk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A wa di wu pye: «Kafɔɔ, sipyii pii pu da ba shɔ ge, pee ya cɛ̀rɛ ya?» A Yesu di pu bɛɛri pye: ");
INSERT INTO myk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yi la le yʼi jé kuɲɔɔ nifɛnhɛfɛnhɛnɛ li ni. Bani nʼa da yi jo yi mu, sipyiɲɛhɛmɛɛ na ba jegana shaa pʼi jé, ga pu da já wɛ. ");
INSERT INTO myk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kaaŋa ki fɔɔ wu ba yìri, na kuɲɔɔ li shɔ̀hɔ tuun wemu ni, na yee yaha kadaan li na, yee na ba ɲɔ kɔn na yeree kuɲɔɔ li ɲɔ na, na li kuuni na yu: ‹Kafɔɔ, gbura ki mugi wù mu!› Wu na ba yee ɲɔ shɔ na: ‹Nɛ yee tayirige cɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wee tuun wu ni yi na ba ɲɔ kɔn na wu pyi na: ‹Wèe ya li, na gba ma ɲii na, mʼa wèe kalaa wèe kulogoo ki kakuutoroyo yi ni.› ");
INSERT INTO myk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wee na ba yee ɲɔ shɔ na: ‹Nɛ yee tayirige cɛ wɛ, yi toro laha na tàan, yee kakuubyii bɛɛri!› ");
INSERT INTO myk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wee xuu wu ni yi ba Ibirayima, ni Ishaaga, ni Yakuba, ni Kilɛ tudunmɔɔ pu bɛɛri ɲa Kilɛ wo saanra te ni tuun wemu ni, yi na da mɛhɛɛ suu wà, na ganhaa kuri. Bani pʼa yee wá kpɛɛngɛ ki na. ");
INSERT INTO myk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sipyii pii na ba na yìri Kilɛ-nɔhɔ, ni camutomɔ, ni Kilɛ-parama kabaya shuun wu na, na diin na li Kilɛ wo saanra ti ni. ");
INSERT INTO myk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wee tuun wu ni, kadugo yíri wuu pii na ba bye ɲahagbaa wuu. Ɲahagbaa wuu pii na bye kadugo yíri wuu.» ");
INSERT INTO myk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wee tuun wuyɛ pyaa ni a Farizhɛɛn pʼi fulo Yesu na na wu pye: «Yìri laha naha, bani Hɛrɔdi funŋɔ wa wu ma gbo.» ");
INSERT INTO myk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A Yesu di pu ɲɔ shɔ na: «We naŋmahara fɔɔ we kanna sige poŋɔ ki, yi shɛ yi jo wu mu na: ‹Niɲaa ni ɲiga nʼa da jinaa kɔri yeege sipyii ni, di yama fɛɛ cuuŋɔ. Caŋa taanri wogo ki na nɛ na xhɔ lee ni.› ");
INSERT INTO myk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ga li waha lʼi waha nɛ yaa na pye koo li na, niɲaa, ni ɲiga, ni ɲigabudoro, bani li ya ta saha Kilɛ tudunmɔ wu gbo xuu watii ni ni Zheruzalɛmu ni bɛ wɛ! ");
INSERT INTO myk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Zheruzalɛmu, Zheruzalɛmu, mu wemu wʼa Kilɛ tudunmɔɔ pu xuli ge, piimu pʼa dunni ma mu ge, na kagereye taga na pee bɛ waa na xhuli ge, nɛ funŋɔ ya pye tɛɛgɛɛ niɲɛhɛŋɛɛ ni di ma nagoo pu pinnɛ, ba xhuu ya wu nagoo pinnɛɛ mɛ wu kapaŋa nɔhɔ ni wɛ. Ga yee di ya ta sɔɔ lee na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ayiwa yi puga ki na ba yaha wà nimɛ fɛɛfɛɛ, ki niwaga. Nʼa da yi jo yi mu, na co nimɛ na, yʼa da na ɲa nige wɛ, fo yi ba shɛ yu tuun wemu ni na: ‹Wemu wʼa ma mɛ Kafɔɔ mɛgɛ na ge, wee ɲɛ duba pya.›» ");
INSERT INTO myk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cadɛɛngɛ ka na, Yesu ya kari Farizhɛɛn pu wo sipyigbɔ wa puga, na li wà. Farizhɛɛn piimu pu bye wà ge, pee bi wu kasɛri. ");
INSERT INTO myk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ná wa bye wà tinmɛ gban na ɲɛ wu na. ");
INSERT INTO myk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A Yesu di jomɔ pu lɔ, na saliya karamɔgɔlɔɔ ni Farizhɛɛn pu yege na: «Na saha ni saliya wu ni, lʼa saha na yama fɔɔ cuuŋɔ cadɛɛngɛ ni laa, kelee li ya saha wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ga, a pʼi cari puyɛ na, wa ya jo wɛ. Wee tuun wu ni, a Yesu di wee yama fɔɔ we lɔ, na wu cuuŋɔ, na wu yaha kari. ");
INSERT INTO myk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lee kadugo na a wu pu pye: «Yee wa ja, kelee wu niiŋɛ na to keeŋɛ ni, ta yee da zhɛ wu wolo tɔvuyo na wɛ, ali ki pye cadɛɛngɛ ki bɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pee ya já wu ɲɔ shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sipyii piimu pʼa yiri yalige na ge, Yesu ya talenɛ jo pu mu, bani wʼa li sɛɛri na pu ma ɲahagbaa tatiinyɛ yi ɲaha buloo. A wu pu pye: ");
INSERT INTO myk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Wa bu ma yiri cekaanra yaligee na, ma ganha da zhɛ diin ɲahagbaa tatɛɛngɛ ni wɛ. Ma ya li cɛ ni wemu tayerege kʼa pɛlɛ ma wogo na ge, ni wee bɛ ya yiri wɛ. ");
INSERT INTO myk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wemu wʼa yi bɛshuun yiri ge, wee ba ma pye ma tatɛɛngɛ ki kan we ná we mu, wee tuun wu ni ma shiige wo na zhɛ diin kadugo yíri tatɛɛngɛ ka ni. ");
INSERT INTO myk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ga ba ma yiri wɛ, shɛ diin kadugo yíri tatɛɛngɛ ni, kɔnhɔ ma yirivɔɔ wu ba ba, wu ma pye: ‹Na naɲii, shɛ diin ɲahagbaa tatɛɛngɛ ki ni.› Wee tuun wu ni ma na pɛɛŋɛ ta ma liɲii pu ɲii na. ");
INSERT INTO myk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bani sipyaa sipya wʼa wuyɛ durogo ge, wee na ba dirige. Sipyaa sipya wʼa wuyɛ tirige ge, wee na ba durogo.» ");
INSERT INTO myk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wemu wʼa Yesu yiri yalige ki na ge, a wu wee bɛ pye: «Ma bu yaliɲɛhɛŋɛɛ pye caŋa ni kelee piige ni, ma ganha da ma naɲiinɛɛ yiri, kelee ma nu sii, kelee ma cebooloo, kelee ma tiinɲii naafuu fɛɛ wɛ. Pee bɛ na ba já ma yiri yalige na ma wo yire li footɔnɔ. ");
INSERT INTO myk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ga ma bu yaliye pye, mʼa la baa fɛɛ, ni taafɛɛ, ni faannaa, ni fyɛnmɛɛ yiri. ");
INSERT INTO myk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ma na duba ta, bani pee wa da já ma yiri li footɔnɔ na wɛ. Ma na ba lee footɔnɔ ta sipyitiimɛɛ pu nixhuyo yi caɲɛŋɛ.» ");
INSERT INTO myk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ba yalilimɛ wa ya pee jomɔ pu logo wɛ, na jo: «Wemu wu da ba li Kilɛ wo saanra te ni ge, wee ɲɛ duba pya.» ");
INSERT INTO myk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A Yesu di wu pye: «Ná wa bi yaliye pye piige yalige, na sipyiɲɛhɛmɛɛ yiri. ");
INSERT INTO myk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ba yaliye yi liduun ya nɔ wɛ, pʼa sipyii piimu yiri cekaanra ti ni ge, a wu wu kapyebye wu tun na wu pee pye: ‹Yi pa, bani yaŋmuyɔ yi bɛɛri ya kemɛ xɔ.› ");
INSERT INTO myk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ga, a pu bɛɛri nigin nigin di ganha na fɛnri na foro yire li tàan, na yu na wu kafari pee mu. A nizhiimɛ wu wu pye: ‹Tɛgɛ ka nɛ shɔ, nɛ yaa na shɛ kee wii. Nʼa ma ɲɛɛri, le yafa na mu.› ");
INSERT INTO myk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A wa bɛ di wu pye: ‹Nupɛhɛɛ kɛ nɛ shɔ, nʼa da zhɛ kee taanna. Nʼa ma ɲɛɛri, le yafa na mu.› ");
INSERT INTO myk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A wa bɛ di wu pye: ‹Nimɛ nɛ cee leŋɛ, lee lʼa li pye, nɛ da já zhɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","A kapyebye wu guri shɛ ɲuŋɔfɔɔ wu yíri, na kii keree kii bɛɛri paari wu mu. A kaaŋa ki fɔɔ wu luu di yìri, a wu wu kapyebye wu pye: ‹Fyaala shɛ kulo li pinnɛrɛ kpɛɛnyɛ, ni kakuutoroyo yi ni, mʼa la baa fɛɛ, ni taafɛɛ, ni fyɛnmɛɛ, ni faannaa yiri pa naha.› ");
INSERT INTO myk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ba wʼa shɛ pee yiri na pa wɛ, na ba wu ɲuŋɔfɔɔ wu pye: ‹Na ɲuŋɔfɔɔ, mʼa tuduro temu kan ge, nʼa ti pye, ga lee bɛ na puga ki sanha ɲi wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A ɲuŋɔfɔɔ wu kapyebye wu pye: ‹Shɛ kodoroyo yi ni, ni kobiire te, mʼa sipyii pu karamu pʼi ba, kɔnhɔ na puga kʼi ɲi. ");
INSERT INTO myk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bani sipyii pii nɛ fɛnhɛ yiri a pʼi li she ge, nʼa da yi jo yi mu, nɛ wo yalige ka ɲɛ wee wa shishiin ɲɔ ni wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Shɛnɲɛhɛmɛɛ bi taha Yesu fɛni. A wu ŋmahana ɲɛri pu shizhaa na na pu pye: ");
INSERT INTO myk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Wa bu daha nɛ fɛni, nɛ kaa bye lʼi ya dan weefɔɔ ni na toro wu to, ni wu nu, ni wu shɔ, ni wu nagoo, ni wu ceboronamaa, ni wu ceboroshaa, ni wuyɛ pyaa bɛ tàan wɛ, wee da já bye nɛ kalaapire wɛ. ");
INSERT INTO myk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wemu ya wu korikoritige lɔ, na daha nɛ fɛni wɛ, wee da já bye nɛ kalaapire wɛ. ");
INSERT INTO myk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Wa ba giin wu zangaso-tɔɔngɔ yereŋɛ yee ni, ta wu da vɛnhɛ diin na ki yereŋɛ yereŋɛ pɛrɛmɛ pu tɔrɔ, yaaga bu da na ɲɛ wu keŋɛ ni, di ki yereŋɛ xhɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wu ma fyagi wu bu ki nɔhɔ shan, wu bi da já ki saŋa xɔ, ni ki ɲavɛɛ ya pa ɲɔ kɔn na zhɛhɛni wu na wɛ, ");
INSERT INTO myk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","na wu la wo, na yu: ‹Wee ná we ya puga ki yereŋɛ ɲɔ kɔn, ga wu ya já ki xɔ wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kelee saan wa ba giin wu kashɛn kɔn saan wa na, ta wu da vɛnhɛ diin na wu funŋɔ sha, wu ni namaa kabɔfoŋɔɔ kɛ (10.000) bu da na da já saan wa ni namaa kabɔfoŋɔɔ kɛlɛɛ shuun (20.000) ɲuŋɔ círi wɛ? ");
INSERT INTO myk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wu bye wu da já wɛ, na wee saan wu yaha tatɔɔngɔ ni, wʼa tudunmɔ yaha kari wu shɛ taanɲɛɛgɛ sha. ");
INSERT INTO myk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lee pyegana li na, wemu ya kahari wu keŋɛ yaŋmuyɔ bɛɛri ni wɛ, wee da já bye nɛ kalaapire wɛ. ");
INSERT INTO myk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Suumɔ ya ɲɔ, ga pu tipoomɔ bu foro pu ni, ɲaha na pu taan sanha wɛ? ");
INSERT INTO myk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pu da yafiin bɛ ɲɔ ɲiŋɛ na wɛ, pu da já bye kaafugo ɲiŋɛ na wɛ, sipyii na pu wá kadaan na. Wemu na logo ge, wu logo dɛ!» ");
INSERT INTO myk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Fanhafɛɛ wari shɔvɔɔ ni jurumupyii pii bɛ ya fulo Yesu na, na wu jomɔ logo. ");
INSERT INTO myk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lee na a Farizhɛɛn ni saliya karamɔgɔlɔɔ pʼi ganha na kalɔhɔrɔ yu na: «We ná we ya jurumupyii coni na ɲɔgi, wʼa li ni pu ni shiizhan.» ");
INSERT INTO myk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A Yesu di le talenɛ le jo pu mu na: ");
INSERT INTO myk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Jɔgɔ wu wa yee ni, dubyaa xhuu nigin (100) bu bye wu mu, a nigin di biin, ta wu da kɛlɛɛ gbarashɛɛrɛ ni gbarashɛɛrɛ (99) wu samaa yaha wà sige ki ni, wu shɛ nibɛɛngɛ ki sha fo wu ki ɲa wɛ? ");
INSERT INTO myk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ba wʼa shɛ wu ɲa wɛ, wu fundanga wo na wu le wu katigoo ni. ");
INSERT INTO myk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ba wʼa nɔ puga wɛ, wʼa wu naɲiinɛɛ ni wu tiinɲii yiri, na pu pye: ‹Wù fundanga ta shiizhan, bani nɛ na dubyapɛɛngɛ ki ɲa.›» ");
INSERT INTO myk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A Yesu di jo: «Lee na nʼa da yi jo yi mu, jurumupye nigin bɛ bu yere wu jurumu na, fundanga na bye wee wuu na fugba we ni na toro sipyitiimɛɛ kɛlɛɛ gbarashɛɛrɛ ni gbarashɛɛrɛ (99) tàan, piimu mago ɲɛ nige jurumu yafa na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","A Yesu di jo sanha na: «Kelee cee wekɛ wu da bye ni warifyɛn tuuyo kɛ ni, nigin bu biin yi ni, ta wu da sokinna le wu puga ki pɔ wu ki sha xuuni fo wu ki ɲa wɛ? ");
INSERT INTO myk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wu bu ki ɲa tuun wemu ni, wʼa wu pushaɲiinɛɛ ni wu tiinɲii cèe yiri na pu pye: ‹Wù fundanga ta shiizhan, bani nɛ warifyɛn tuuŋɔ ke ki bi piin ge, nɛ ki ɲa.› ");
INSERT INTO myk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lee wuu na, nʼa da yi jo yi mu, fundanga ki wa kii mɛlɛkɛɛ pu mu jurumupye nigin na yere wu jurumu na.» ");
INSERT INTO myk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A Yesu di jo bɛ sanha na: «Jalaa shuun bye ná wa mu. ");
INSERT INTO myk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A kurogo ja wu tofɔɔ wu pye: ‹Na to, lemu na ba nɔ na na cɛn wu ni ge, lee kan na mu nimɛ!› Ba wʼa yee jo wɛ, a tofɔɔ wu sɔɔ na naafuu wu taa pu shuun wu na. ");
INSERT INTO myk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cabyaa kii nidorogo na, a kurogo ja wu wu taa wari wu bɛɛri wá wuyɛ na. Na gari taliige fiige ka ni, na shɛ wuyɛ yaha wà fungɔngɔ baa sipya. Na wari wu bɛɛri kyɛɛgi ɲuŋɔ baa keree ni. ");
INSERT INTO myk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ba wari wu bɛɛri ya xɔ wɛ, a xuugbɔhɔ di jé kee fiige ki ni. A kanhama di nɔ wu na. ");
INSERT INTO myk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A wu shɛ jé baari ni kee fiige ki sipya wa mu, a wee di wu yaha kari wu kɛrɛyɛ ni shaanahana na. ");
INSERT INTO myk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A xuugo di shɔ wu ni xuuni. Yaliye yemu pu bi gaan shaalaa pu mu ge, a wu funŋɔ di bye wu li yee ni, ga wa shishiin ya ya kan wu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Ba wʼa wu funŋɔ sha wɛ, na jo: ‹Kapyebyii niɲɛhɛmɛɛ pu wa nɛ to puga. Pu ma li, na yalige ki saŋa yaha, nɛ kunni di zhaa di xhuu naha xuugo keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nʼa da guri zhɛ na to wu puga ki ni, di shɛ wu pye: Na to, nʼa nahana Kilɛ mu, na nahana mu bɛ mu. ");
INSERT INTO myk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɛ yaa na yiri nige mu ja sanha wɛ. Na co ba ma kapyebye wa ɲɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A wu yìri kari puga. «Na wu yaha taliige ni, a wu to wu wu nibawo ɲa, a wu ɲiɲaara di jé wu ni. A wu baa kari na shɛ jafɔɔ wu shaari ni taanɲɛɛgɛ ni, na wu keye migile wu katige ni. ");
INSERT INTO myk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A ja wu to wu pye: ‹Na to, nɛ nahana Kilɛ mu, na nahana mu bɛ mu, nɛ yaa na yiri mu ja nige wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ga, a wu to wu yi jo kapyebyii pu mu na: ‹Yi fyaala pa ni fadeye yi bɛɛri nizaaŋa ki ni yi pa le wu na, yʼi kabelenɛ le wu kabee na, yʼi tanhaya le wu na. ");
INSERT INTO myk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yʼi ba ni nupepinŋɛ sìnmɛ wogo ni yi pa gbo. Wù li wù funŋɔ taan, ");
INSERT INTO myk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bani nɛ pya we wʼa ɲa ge, wu bi xu, wʼa kuri pye ɲiifɛɛrɛ ni. Wu bi piin, wʼa ɲa.› A pʼi kalenɛ ɲɔ co. ");
INSERT INTO myk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Lee bi wu jashiimɛ wu ta wee na ɲɛ tɛgɛ ki ni, ba wee ya tɛɛŋɛ puga na wɛ, a wu yatinyɛ yi tunmɔ ni xɔnhɔrɔ ti tunmɔ pu logo. ");
INSERT INTO myk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A wu kapyebye wa yiri na wu yege lee kalenɛ li ɲuŋɔ na. ");
INSERT INTO myk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A wee di wu ɲɔ shɔ na: ‹Mu cuun wu wʼa pa, a ma to wu nupepinŋɛ sìnmɛ wogo gbo wu mu, bani wu ja wʼa pa jé sicuumɔ na.› ");
INSERT INTO myk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A jashiimɛ wu luu di yìri, wu ya ta sɔɔ na jé puga wɛ. Ba wu to wʼa yee logo wɛ, na foro kari wu fɛni, na shɛ wu ɲɛɛri na wu ɲɔ wuyɛ na wu jé. ");
INSERT INTO myk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ga, a wu tofɔɔ wu pye: ‹Wii mɛ dɛ! Nɛ yee ya ɲɛhɛ na kapyeŋɛɛ pyi mu mu. Nɛ ta mu ɲɔmɛɛ yaha tuun wa yafiin ni wɛ. Lee bɛ na, ali mu ya ta sikapire nigin bɛ kan ɲa nɛ mu, kɔnhɔ nɛ ni na naɲiinɛɛ di fundanga pinnɛ pye shiizhan wɛ. ");
INSERT INTO myk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ga we wu wa mu ja wu ge, wʼa mu naafuu wu bɛɛri kyɛɛgi dɔdɔshaa ni. Ba wʼa pa wɛ, a mu nupepinŋɛ sìnmɛ wogo gbo wu mu!› ");
INSERT INTO myk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«A wu to wu wu ɲɔ shɔ na: ‹Na ja, tuun bɛɛri ni mu wa nɛ tàan naha, nɛ yaŋmuyɔ yi bɛɛri wa mu woyo. ");
INSERT INTO myk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ga wèe ya yaa na funŋɔ taan, na kalenɛ pye, bani ma cuun we wu wa we ge, wu nixhugo ki bye, ga wʼa ɲiifɛɛrɛ ta nimɛ. Wʼa bi piin, ga wʼa ɲa.›» ");
INSERT INTO myk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Yesu di yi jo sanha wu kalaapiire ti mu na: «Ná naafuu fɔɔ wa bye wà, kaɲahashɔɔnrimɔ wa di ɲɛ wu mu, a sipyii di wee tɔɔgɔ le na wʼa wu ɲuŋɔfɔɔ wu kabyaa ki kyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A ɲuŋɔfɔɔ wu wu yiri na wu pye: ‹Lekɛ nɛ di nuri mu shizhaa na wɛ? Wù keree ki ɲaha wolo, bani mu wa da já bye nige nɛ kaɲahashɔɔnrimɔ wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Wee tuun wu ni a wee kaɲahashɔɔnrimɔ wu yi jo wuyɛ funŋɔ ni na: ‹Lekɛ nɛ da ba byi wɛ? Na ɲuŋɔfɔɔ wʼa na lɛri wu kabyaa ki ɲuŋɔ ni. Faa fanha wa na ni wɛ; ɲɛrɛgɛ shiige di ɲɛ na na. ");
INSERT INTO myk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uun! Le nʼa da bye ge, nʼa lee cɛ, kɔnhɔ di ba laha kabyaa ki ɲuŋɔ ni, pii di na círi leŋɛ pu kaban.› ");
INSERT INTO myk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wee tuun wu ni pii pʼa fɔhɔɔ lɔ wu ɲuŋɔfɔɔ wu mu ge, a wu ganha na pee yiri nigin nigin. A wu nizhiimɛ wu pye: ‹Nɛ ɲuŋɔfɔɔ wu juu wu wa mu na wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A wee di wu ɲɔ shɔ na: ‹Sìnmɛ barigoo kɛlɛɛ shuun (20).› A wu wu pye: ‹Ma sɛmɛ wu lɔ, mʼa diin tɔvuyo na mʼa sìnmɛ barigoo kɛ ka.› ");
INSERT INTO myk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lee kadugo na a wu wa bɛ pye: ‹Mu do, juu di wa mu na wɛ?› A wee di wu ɲɔ shɔ na: ‹Shinma bɔrilɔɔ xhuu nigin (100).› A wu wee pye: ‹Ma sɛmɛ wu lɔ mʼa shinma bɔrilɔɔ kɛlɛɛ gbarataanri (80) ka.› ");
INSERT INTO myk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","A ɲuŋɔfɔɔ wu wee kaɲahashɔɔnrimɔ tifire baa fɔɔ we sɔ wu shizhiinmɛ pu na, bani ke koŋɔ ke sipyii wa keree pyi ni shizhiinmɛ ni puyɛ tɛ ni, na toro kpɛɛngɛ nagoo tàan.» ");
INSERT INTO myk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A Yesu di wu kalaapiire ti pye: «Yee bu ke koŋɔ ke wo naafuu wu lɔ na taga sipyii tɛgɛ, na naɲɛɛgɛ sha ni wee ni. Yee wo caŋa ɲii li ga ba xhɔ caŋa kemu ke koŋɔ puga ke ni, lee na ba bye kaɲuŋɔ na baraji kan yi mu Kilɛ yíri Alijinɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","We wu ɲɛ nʼa daa sipya kafɛnhɛfɛnhɛŋɛɛ ni ge, wee wu ɲɛ nʼa daa sipya kagbɔhɔɔ bɛ ni. We wu ɲɛ tifire baa fɔɔ kafɛnhɛfɛnhɛŋɛɛ ni ge, wee wu ɲɛ tifire baa fɔɔ kagbɔhɔɔ bɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lee wuu na, ke koŋɔ ke wo naafuu we wʼa sipyii faanna ge, yee bye yee di ya pye nʼa daa sipyii wee keree ni wɛ, ta naafuu can can wo wu kaa na ba le yee keŋɛ ni? ");
INSERT INTO myk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Naafuu we wu ɲɛ watii wo ge, yee bye yee di ya pye nʼa daa sipyii wee wo keree ni wɛ, ta yeeyɛ pyaa wo wu na ba gan yee mu? ");
INSERT INTO myk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kapyebye wa shishiin da já da kapyeŋɛɛ pyi ɲuŋɔfɛɛ shuun mu wɛ. Bani wa na bɛn wu mu, wa na daan wu mu, kelee wu nɔrɔ wa na, wu laraga kɔn we wu na. Yee da já da kapyeŋɛɛ pyi Kilɛ mu, yi da ki pyi naafuu bɛ mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizhɛɛn pii pu ɲɛ wari na dan pu ni ge, ba pee ya yee bɛɛri logo wɛ, na ganha na wu la wo. ");
INSERT INTO myk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A wu pu pye: «Pii pʼa puyɛ pyi sipyitiimɛɛ sipyii ɲii na ge, pee pu ɲɛ yere. Ga Kilɛ ya yee zɔlɔɔ pu cɛ, bani yaaga kemu sipyiyawyii ya bɛlɛ ge, kee ki ɲɛ makɔŋɔ yaaga Kilɛ ɲaha tàan. ");
INSERT INTO myk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Musa wo saliya we ni Kilɛ tudunmɔɔ Kitabuu pu bye wà, fo na shɛ nɔ Yohana Batizelipye wo tuun wu na. Na lɔ fo wee tuun wu na Kilɛ saanra ti wo Jozaama pʼa yu, a sipyii bɛɛri di yatɛnyɛ waha pʼi jé ti ni. ");
INSERT INTO myk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Fugba we ni ɲiŋɛ ke toromɔ na ba daan fo xuuni na toro Kilɛ wo saliya wu kamapile fuduunɔ nigin bɛ wo do na. ");
INSERT INTO myk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Sipyaa sipya wʼa wu shɔ gbaga xɔ na watii leŋɛ ge, dɔdɔɔrɔ mʼa pye. Wemu bu ná wa wo ceforomɔ leŋɛ, dɔdɔɔrɔ wʼa pye.» ");
INSERT INTO myk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ná naafuu fɔɔ wa bye wà na saannaa fàya leni, na fanhafɛɛ yaliye li ɲiga bɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ná la baa fɔɔ wa bɛ di bye wà, wee mɛgɛ ɲɛ na Lazari. Wu ceesɛɛgɛ ki bɛɛri ki bye nɔɔkuuyo. Pu bi shɛ wee sinniŋɛ wee naafuu fɔɔ wu kaaŋa ki kuɲɔɔ ɲɔ na, ");
INSERT INTO myk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yaliɲahara te ti bi wo na dun naafuu fɔɔ wu tabali wu nɔhɔ ni ge, wu funŋɔ bye wu da tee li. Na wu yaha wu ya tee bɛ ta li wɛ, a poŋɔɔ bɛ di nɔhɔ na ma na wu nɔɔyɔ yi laala sanha. ");
INSERT INTO myk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Caŋa ka, a wee la baa fɔɔ wu ba xhu, a mɛlɛkɛɛ di wu munaa lɔ na shɛ yaha tatiinceŋɛ ka ni Ibirayima kanige cɛ. A naafuu fɔɔ wu bɛ di ba xhu, a pʼi wu le. ");
INSERT INTO myk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na wu niganhaŋa yaha xuu kulo li ni, a wu wu ɲaha yirige, na Ibirayima ɲa taliige ni, na Lazari bɛ ɲa wu kanige cɛ. ");
INSERT INTO myk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wee tuun wu ni, a wu xhuulo na jo: ‹Na to Ibirayima, ɲuŋɔ ɲaari na na! Lazari yaha wu shɛ wu kabee le munaa le fyɛnmi lɔhɔ ni, wu ba na ɲile le ɲiŋɛ, bani na niganhaŋa ki wa xuuni ke na ke ni.› ");
INSERT INTO myk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","A Ibirayima di wu ɲɔ shɔ na: ‹Na ja, ma funŋɔ kɔn li na na mu ya ma kasaaŋaa ki bɛɛri ta na mu yaha koŋɔ na, a Lazari di kakuuŋɔɔ ta lee tagana le na. Nimɛ wee ɲaha wa ɲiŋɛ, ga mu kunni ɲaha dʼa wɛri. ");
INSERT INTO myk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na fara lee na, wecogoŋɔ nagaŋa ki ɲɛ wèe ni yee tɛ ni, kɔnhɔ piimu ba giin pʼi foro naha pʼa se yee yíri, pu ganha bu já wɛ. Piimu ba giin pʼi yìri yee bɛ yíri pʼa ma naha, pu bɛ ganha bu já wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Wee tuun wu ni a naafuu fɔɔ wu jo: ‹Na to, na ma ɲɛɛri, Lazari yaha shɛ na to puga ki ni. ");
INSERT INTO myk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bani nɛ ceboronamaa kaguro wu wa wà. Wu shɛ pu sɔnmi, kɔnhɔ pu ganha da ba we kanhama xuu we ni wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","A Ibirayima di wu ɲɔ shɔ na: ‹Musa ni Kilɛ tudunmɔɔ kafila wu wa pu keŋɛ ni, pu wee logo.› ");
INSERT INTO myk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ga, a wu jo: ‹Ahayi, na to Ibirayima, lee yɛ wa da yaa wɛ dɛ! Ga fo gbo nigin bɛ na ɲɛ na shɛ pu yíri wà; lee bu bye, pu na daburajɛ jo pu jurumu wu na.› ");
INSERT INTO myk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A Ibirayima di wu pye: ‹Pu bye pʼi ya Musa ni Kilɛ tudunmɔɔ pu wo kafila wu logo wɛ, ali gbo wa ɲɛhɛ ɲɛ foro pusamaa tɛ ni, pu da ga dà wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A Yesu di yi jo wu kalaapiire ti mu na: «Ɲugyɛɛgi keree da ga já bye pyebaa wɛ. Ga sipya wemu wu da kee pye ge, bɔɔngɔ ki wa weefɔɔ wogo. ");
INSERT INTO myk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wemu wu ɲɛ nɔhɔcɛrɛɛ nʼa daa koo ni ge, sipyaa sipya wʼa wee wa ɲuŋɔ kyɛɛgi ge, na faatabaaga pɔ wu katige ni, na wu wá suumɔ lɔhɔ ni, lee ya pɔrɔ wu mu li bye na. ");
INSERT INTO myk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yʼa yiyɛ kasɛri kee keree kii na. Ma ceboro bu jurumu pye, jo ni wu ni. Wu bu daburajɛ jo, mʼa lee yafa wu mu. ");
INSERT INTO myk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wu bu wɔrɔ ma ni tɔɔɲii gbarashuun caŋa ɲii ni, wu bu guri shɛ ma mu tɔɔɲii gbarashuun na ma pye kafari, mʼa kee bɛɛri yafa wu mu.» ");
INSERT INTO myk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Caŋa ka, tudunmɔɔ pʼa pa Kafɔɔ pye: «La fara wù nʼa daa wu na.» ");
INSERT INTO myk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A Kafɔɔ di jo: «Yee nʼa daa wu da bi ali mutaridi pilere bɛ xɔ pɛɛrɛ ni, yee bi da yi jo ke tigbɔhɔ ke mu na ki kɔɔngi kʼi shɛ nɔri suumɔ lɔhɔ ni, kʼa yee ɲɔmɛɛ co. ");
INSERT INTO myk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Kapyebye bu bye yee wa mu, wu bi faa pyi kelee na yatɔɔyɔ naha, wu bu yìri sige ni na pa tuun wemu ni, wu ma wee kapyebye wu pye wu pa diin yalige ɲuŋɔ ni ya? ");
INSERT INTO myk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta wu da wee kapyebye wu pye wu yalige shɔhɔ, wu bu xhɔ wu wu faleye yi faa, wu fɛnhɛ shɛ ki yereŋɛ wufɔɔ yɛ pyaa tàan, wufɔɔ di li fo wu din, wu gba bɛ wɛ? Lee kadugo na kapyebye wu bɛ di na li wɛ? Ta wufɔɔ ɲɛ ma li pye mu wɛ? ");
INSERT INTO myk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kapyebye we wʼa wu nijogoo ki pye ge, baaga kakaan ɲuŋɔ ɲɛ wee mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lee na yee bɛ, ye yʼa jo yee mu ge, yee bu yee bɛɛri pye, yʼa yaa yi jo na go kapyebyii yee ya sii, na yi nibyii yʼa pye. Yi kayahana ɲuŋɔ yɛ yʼa pye.» ");
INSERT INTO myk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na Yesu yaha koo na wu na se Zheruzalɛmu ni, a wu doro Samari fiige ke ni Galile fiige ki tɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wu nijewo kulo la ni, a togo fɛɛ namaa kɛ wa di ba wu ɲuŋɔ círi, ga, a pʼi yere na laara kɔn wu na, ");
INSERT INTO myk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na mujoŋɔɔ wá na: «Karamɔgɔ Yesu, ɲuŋɔ ɲaari wù na!» ");
INSERT INTO myk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ba wʼa pee ɲa wɛ, a wu pu pye: «Yi shɛ yiyɛ shɛ saraya ɲaha shɔɔnrivɔɔ pu na.» A pu nigariwuu di juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba shɛn nigin wa ya wuyɛ ɲa wʼa cuuŋɔ wɛ, na ŋmahana kuri, na ganha na Kilɛ sɔni na ma ni mujuugbɔɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ba wʼa pa nɔ Yesu na wɛ, na shɛ nuguro sin wu fɛɛ ni na wu ɲaha buri ɲiŋɛ ki na, na baraga taha wu na. Na ta wee di bi bye bɛ Samari shɛn. ");
INSERT INTO myk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A Yesu di jo: «Ta sipyii kɛ bɛ wʼa cuuŋɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pusamaa gbarashɛɛrɛ wu wa mii wɛ? Wa yafiin ya ta pa Kilɛ pɛlɛ nabunna we kadugo na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lee kadugo na a wu wu pye: «Yìri mʼa se! Ma nʼa daa wʼa ma cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Caŋa ka, Farizhɛɛn pʼa pa Yesu yege na: «Tuun wekɛ ni Kilɛ wo saanra tʼi da ba wɛ?» A wu pu ɲɔ shɔ na: «Kilɛ wo saanra ti da ba ba na saha ni sipyii kasɛɛgɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pu da ga ba jo bɛ: ‹Wu we naha,› kelee ‹Wu we mɛ wɛ,› bani Kilɛ wo saanra ti wa yee niŋɛ ni.» ");
INSERT INTO myk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lee kadugo na a wu wu kalaapiire ti pye: «Caya ya wa ma, li bi da daan yee ni na Sipya Ja caŋa ka ɲa, ga yee da kee ɲa wɛ. ");
INSERT INTO myk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sipyii na ba yee pyi na: ‹Wu wa naha,› kelee ‹Wu wa mɛ,› ga yi ganha da zhɛ wà wɛ, yi ganha da daha pu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sipya Ja cabaŋa, kee na ba bye ba Kilɛ-ɲiŋɛɛ ɲɛ wɛ, ma ɲí taapile ni, kpɛɛngɛ ki ma yìri fugba wu kabaŋa ka na, na nɔ ka na. ");
INSERT INTO myk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ga yani kee caŋa ke ki nɔ ge, li waha lʼi waha wu na ba ganha xuuni, niɲaa sipyii di zhe wu ni. ");
INSERT INTO myk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Ba Nuxhun wo caŋa ɲii li keree kʼa pye wɛ, mu lʼa da ba bye Sipya Ja wu bɛ cabaŋa. ");
INSERT INTO myk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sipyii bi li na gbuu, na cèe leŋɛɛ, kelee na pu nagoo kaan gbaya ni, fo na shɛ nɔ caŋa kemu Nuxhun ya jé kɔɔgbɔhɔ ki ni ge. Wee tuun wu ni a logbɔhɔ di ba pee bɛɛri kyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Keree kiimu kʼa pye Lɔti caŋa ɲii ni ge, kee tuugo na ba bye sanha. Lɔti caŋa ɲii ni, sipyii bi li na gbuu, na zhuu na bɛrɛɛ, na faa pyi, na piyɛyɛ yereŋɛ. ");
INSERT INTO myk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ga Lɔti ya foro Sodɔmu kulo li ni caŋa kemu ge, kee caŋa ke, na ni kirimu ya yìri fugba wu ni, na do ba zanha ɲɛ wɛ, na pu bɛɛri kyɛɛgi. ");
INSERT INTO myk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«Caŋa kemu Sipya Ja da ba wuyɛ shɛ ge, kii keree kii bɛɛri tuuyo na ba bye sanha. ");
INSERT INTO myk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kee caŋa ke wemu ɲɛ wu puga kataŋa na ge, wee ganha bu digi jé puga ki ni yaaga fɛni wɛ, mu wemu bɛ wu ɲɛ ma kɛrɛyɛ ni ge, mu bɛ ganha bu guri da ma puga wɛ. Ga wa bɛɛri di da wu ɲubile yɛ shaa. ");
INSERT INTO myk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yi funyɔ yi to Lɔti shɔ wu wuu li na! ");
INSERT INTO myk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wemu wʼa wu munaa ɲuŋɔ shaa di wolo niɲaa ge, wee na ba buun li ni ɲiga na. Wemu wʼa bɔnri wu munaa ni niɲaa ge, wee na ba wu munaa ɲuŋɔ wolo ɲiga na. ");
INSERT INTO myk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nʼa da yi jo yi mu, kee caŋa ke, shɛɛn shuun na ba bye yasinnɛnuŋɔ na piige ni, wa na ba lɔ na wa yaha. ");
INSERT INTO myk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cèe shuun na ba shinma tiree shiizhan, wa na ba lɔ na wa yaha.  ");
INSERT INTO myk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Namaa shuun na ba bye tɛgɛ ni, wa na ba lɔ na wa yaha.» ");
INSERT INTO myk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A kalaapiire tʼi wu yege na: «Kafɔɔ, xuu wekɛ ni lee da ba bye wɛ?» A wu pu ɲɔ shɔ na: «Xuu wemu ni yaxugo ɲɛ ge, wà tobinyɛ ya yiyɛ pinnɛɛ.» ");
INSERT INTO myk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu ya talenɛ jo pu mu na ɲaha tii ni Kilɛ-ɲɛrɛgɛ ni, na sipyii ya yaa pʼa Kilɛ ɲɛɛri tuun bɛɛri ni, pu ganha bu ganha wɛ. ");
INSERT INTO myk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wʼa jo: «Kiiri kɔnvɔɔ wa ya bye kulo la ni, wu bi fyagi Kilɛ na wɛ, wu mago bye sipya wa yafiin bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naxhugoshɔ wa bye lee kulo li ni, wee bi ma se wu yíri na wu pyi na wu wu pɛɛn kakuuyo footɔnɔ kan pu mu. ");
INSERT INTO myk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lʼa mɔ, kiiri kɔnvɔɔ wu bi sanha sɔɔ wɛ. Kadugo tàan a wu wuyɛ pye: ‹Ali nɛ ɲɛhɛ bye nɛ fyagi Kilɛ na wɛ, ali nɛ mago ɲɛhɛ bye wu ɲɛ sipya yafiin bɛ ni wɛ, ");
INSERT INTO myk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lee bɛ na we naxhugoshɔ we, wʼa nɛ kana, lee wuu na nʼa da wu pɛɛn pu kakuuyo footɔnɔ kan pu mu, kɔnhɔ wu ganha ba ma da na kana tuun bɛɛri ni wɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A Kafɔɔ di jo: «Kiiri kɔnvɔɔ tiibaama wʼa yemu jo ge, yi yee logo. ");
INSERT INTO myk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kilɛ ya piimu ɲaha bulo pee di mɛhɛɛ suu wu fɛni caŋa ni piige ge, ta wu da ba pee wo pɛɛn pu kakuuyo yi footɔnɔ kan pu mu wɛ, ali na ta wʼa luu gbo bɛ pu tàan wɛ? ");
INSERT INTO myk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nʼa da yi jo yi mu, kakuuyo ye pʼa byi yi na ge, wu na ba yee wo footɔnɔ kan tɔvuyo na. Ga Sipya Ja wu ba ba tuun wemu ni, ta wu na ba nʼa daa ta ɲiŋɛ ki na gɛ?» ");
INSERT INTO myk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sipyii piimu pʼa bi daa puyɛ na na pee ya tii ge, na ta pʼi ya bi pusamaa wii na pu ɲɛ yafiin bɛ wɛ ge, Yesu ya le talenɛ le jo pu shizhaa na na: ");
INSERT INTO myk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Namaa shuun wa ya shɛ Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni na shɛ Kilɛ ɲɛɛri: Nigin bye Farizhɛn, shuun wo wu ɲɛ fanhafɛɛ wari shɔvɔɔ.» ");
INSERT INTO myk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Farizhɛn wu yìri yere na Kilɛ ɲɛɛri wuyɛ tàan mumɛ, na: ‹Kilɛ, nʼa baraga taha ma na, bani nɛ ni sipyii pusamaa wa nigin wɛ: nagaalaa, ni kakuubyii, ni dɔdɔɔ, nɛ wa ba we fanhafɛɛ wari shɔvɔɔ we wa wɛ. ");
INSERT INTO myk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cewuu cewuu, nɛ ma suun le cabyaa shuun. Kuduun we nɛ daa ge, nɛ wee bɛɛri jagi wo.› ");
INSERT INTO myk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ga, a fanhafɛɛ wari shɔvɔɔ wu yere kabanugo na. Wu ya ta sɔɔ, ali na wu ɲaha yirige fugba wu ni wɛ, ga, a wu wu dodoŋɔ kpɔn kpɔn ɲatanhaŋa keŋɛ ni na jo: ‹Kilɛ, ɲuŋɔ ɲaari na na, jurumupye nɛ ɲɛ.› ");
INSERT INTO myk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","«Nʼa da yi jo yi mu, we ná we kaɲii da wo ya kari puga, ga Farizhɛn wu ya li ta wɛ, bani sipyaa sipya wʼa wuyɛ durogo ge, wee na ba dirige. Sipyaa sipya wʼa wuyɛ tirige ge, wee na ba durogo.» ");
INSERT INTO myk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Caŋa ka, sipyii pii ya pa Yesu mu ni nɔhɔpiire ta ni, kɔnhɔ wu gbɔn ti na. Ba wu kalaapiire tʼa lee ɲa wɛ, na yogo jo ni pu ni. ");
INSERT INTO myk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ga, a Yesu di tee nɔhɔpiire ti fulo wuyɛ na na jo: «Yi nɔhɔpiire ti yaha ti da ma na mu, yi ganha ba ti ɲaha kɔɔn wɛ! Bani pee shi tuugo wuuro ti ɲɛ Kilɛ wo saanra te. ");
INSERT INTO myk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Can na, nʼa da yi jo yi mu, sipya wemu ya Kilɛ wo saanra ti co ba nɔhɔcɛrɛɛ ɲɛ-ɛ wɛ, wee da ga ba jé ti ni bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yawutuu ɲuŋɔfɔɔ wa ya Yesu yege na: «Karamɔgɔsaama, ɲaha nɛ yaa na pye, kɔnhɔ di ɲìi sicuumɔ nixhɔbaama ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A Yesu di wu pye: «Ɲaha na mʼa na pyi nizaama wɛ? Nizaama wa shishiin wa wɛ, fo Kilɛ yɛ. ");
INSERT INTO myk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","«Mʼa Kilɛ wo saliya wu ɲɔmɛhɛɛ ki cɛ: ‹Ma ganha bu dɔdɔɔrɔ pye wɛ! Ma ganha bu sipya gbo wɛ! Ma ganha bu nagaara pye wɛ! Ma ganha bu kafinɛyɛ taha ma sipyiɲii na wɛ! Ma da ma nu ni ma to pɛlɛ!›» ");
INSERT INTO myk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A wee ná wu jo: «Fo na nɔhɔpiire ti tuun wu ni nɛ ɲɔ kɔn na kii koro ɲaari.» ");
INSERT INTO myk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ba Yesu ya yee logo wɛ, na wu pye: «Kaa nigin yɛ lʼa mu kuuŋɔ sanha! Shɛ ma keŋɛ yaŋmuyɔ yi bɛɛri pɛrɛ, mʼa wee wari wu kan la baa fɛɛ mu! Wee tuun wu ni, ma na naafuu ta fugba we ni. Lee kadugo tàan mʼa ba daha na fɛni.» ");
INSERT INTO myk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ga ba ná wʼa yee logo wɛ, a wu ɲaha di sii tanha xuuni, bani naafuugbɔ wʼa bye wu mu. ");
INSERT INTO myk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ba Yesu ya wu ɲaha ɲa kʼa tanha wɛ, na jo: «Naafuugbɔ fɔɔ jemɛ pʼa pɛn Kilɛ wo saanra ti ni dɛ! ");
INSERT INTO myk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɲɔhɔŋɔ jemɛ ya taan museni wii ni, na toro naafuugbɔ fɔɔ jé na Kilɛ wo saanra ti ni.» ");
INSERT INTO myk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A pee jomɔ pe logovɛɛ di jo: «Aa! Wee tuun wu ni sipya wekɛ na já pa shɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A Yesu di jo: «Le lʼa sipyii já ge, lee ya Kilɛ jani wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wee tuun wu ni a Pyɛɛri di jo: «Li wii, wèe ya kahari yaŋmuyɔ bɛɛri ni na daha mu fɛni.» ");
INSERT INTO myk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A Yesu di pu pye: «Can na nʼa da yi jo yi mu, sipyaa sipya wʼa kahari wu puga ni ge, kelee wu shɔ, kelee wu cebooloo, kelee wu sefɛɛ, kelee wu nagoo, Kilɛ wo saanra ti wuu na ge, ");
INSERT INTO myk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","weefɔɔ na ba yee bɛɛri yahaŋaa niɲɛhɛŋɛɛ ta na wu yaha koŋɔ na, na ba ɲìi sicuumɔ nixhɔbaama bɛ ta ɲiga na.» ");
INSERT INTO myk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A Yesu di wu kalaapiire kɛ ni shuun wu yɛ yiri, na pu pye: «Wù wii gaaŋi Zheruzalɛmu ni, Kilɛ tudunmɔɔ pʼa keree kiimu ka Sipya Ja wu shizhaa na ge, kee bɛɛri na ba bye na ki fa. ");
INSERT INTO myk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wu na ba jé shi watii keŋɛ ni, pee na ba zhɛhɛ wu na, na wu shɛhɛlɛ, na ɲɔlɔhɔ tugi wu na, ");
INSERT INTO myk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","na wu kpɔn ni susɔlɔɔ ni, na na wu gbo. Ga wu caxhugo caŋa taanri wogo ki na wʼa ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ga kalaapiire ti ya ta yafiin bɛ ɲaha cɛ kii keree kii ni wɛ. Bani pe jomɔ pe kɔri bi ŋmɔhɔ pu na. Ye yʼa jo pu mu ge, pu ya ta yafiin bɛ kɔri cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ba Yesu ya tɛɛŋɛ Zheriko na wɛ, lee ya bi fyɛn wa nidɛɛngɛ ta koo li ɲɔ na na saraya ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ba wee ya sipyiire ti nidorowuu tunmɔ logo wɛ, na yegeŋɛ pye na: «Le di ɲɛ ɲaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A pʼi wu pye: «Nazarɛti shɛɛn Yesu wʼa doroo.» ");
INSERT INTO myk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wee tuun wu ni a wu mujuu wá na: «Dawuda Ja Yesu, ɲuŋɔ ɲaari na na!» ");
INSERT INTO myk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pii pu bye sipyiire ti ɲahagbaa na ge, a pee di wu kaa jo na wu co wuyɛ na, ga, a wu sii la fara mujuu li na na yu: «Dawuda Ja, ɲuŋɔ ɲaari na na!» ");
INSERT INTO myk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A Yesu di yere, na jo na pu pa ni wu ni. Ba fyɛn wʼa fulo Yesu na wɛ, a Yesu di wu yege na: ");
INSERT INTO myk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Mʼa giin di ɲaha pye ma mu wɛ?» A wu wu ɲɔ shɔ na: «Kafɔɔ, di da ɲaa!» ");
INSERT INTO myk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Yesu di wu pye: «Ta ɲaa! Ma nʼa daa wʼa ma cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Taapile ni a wu ganha na ɲaa. A wu daha Yesu fɛni, na ganha na Kilɛ pɛlɛ. Tuun wemu ni sipyiire ti bɛɛri ya lee ɲa ge, a pu bɛ di ganha na Kilɛ sɔni. ");
INSERT INTO myk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Caŋa ka Yesu ya pa doroo Zheriko kulo li ni. ");
INSERT INTO myk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ná wa bye wà wu mɛgɛ ɲɛ Zangɛ. Wee bye fanhafɛɛ wari shɔvɔɔ ɲuŋɔfɔɔ, naafuu fɔɔ wʼa bye wii. ");
INSERT INTO myk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wu bi giin wu Yesu ɲa wu wu cɛ, ga sipyiire ti ɲɛhɛ wuu na wu ya ta já wu ɲa wɛ, bani wu bi gbere. ");
INSERT INTO myk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lee na a wu baa kari ɲahagbaa na, na shɛ dugi tige ka ni, kemu mɛgɛ ki ɲɛ na Sikomɔri ge, kɔnhɔ wu Yesu ɲa, bani wu na ba doro wà. ");
INSERT INTO myk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ba Yesu ya nɔ wee xuu wu ni wɛ, a wu wu ɲaha yirige na Zangɛ pye: «Zangɛ, tigi tɔvuyo na, bani mu puga nʼa da zhɛ digi niɲaa.» ");
INSERT INTO myk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A Zangɛ di digi tɔvuyo na, na wu ɲuŋɔ círi ni fundanga ni. ");
INSERT INTO myk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ba sipyii pʼa lee ɲa wɛ, a pu bɛɛri di ganha na ŋmunu-ŋmunɔ na yu: «Wʼa shɛ digi jurumupye wa mu.» ");
INSERT INTO myk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ga, a Zangɛ di yere Kafɔɔ ɲaha tàan, na wu pye: «Li wii, Kafɔɔ, nʼa da na naafuu wu taaga ki kan la baa fɛɛ mu. Li bu da na nɛ wa yaŋmuŋɔ ka ŋmahana, nɛ na ki tuuyo shishɛɛrɛ tɛrɛŋɛ weefɔɔ na.» ");
INSERT INTO myk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A Yesu di wu pye: «Ɲuwuuro ya jé niɲaa ke puga ke bɛ ni, bani we bɛ ɲɛ Ibirayima wo ja wa. ");
INSERT INTO myk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bani piimu pʼa piin ge, Sipya Ja ya pa pee sha wu pee shɔ. ");
INSERT INTO myk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na sipyii pu yaha pu na kii keree kii nuri, a Yesu di le talenɛ le jo pu mu, bani ba wʼa tɛɛŋɛ Zheruzalɛmu na wɛ, a pʼi ganha na giin na lee taapile li ni Kilɛ wo saanra tʼa da tiyɛ shɛ. ");
INSERT INTO myk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lee wuu na wʼa jo: «Ná wa ya se kpɔɔncenɛ la na, na gari fiitɔɔngɔ ka ni kɔnhɔ pʼi shɛ saanra kan wu mu, lee kadugo na wu guri pa. ");
INSERT INTO myk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na wu yaha wu sanha gari wɛ, a wʼi wu kapyebyii kɛ yiri, na pu bɛɛri kan warifyɛn tuuyo nigin nigin, na pu pye: ‹Yʼa yi keŋɛ kaaŋa ni we ni fo di ba shɛ ba.› ");
INSERT INTO myk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ga ba wʼa kari wɛ, a wu shi shɛɛn di wu kɔ, na tudunmɔɔ tun wu mu, na wu pye: ‹Wèe funŋɔ wa mu wu tiin wù ɲuŋɔ ni wɛ.› ");
INSERT INTO myk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ba wʼa kuri wɛ, saanra ti na kan xɔ wu mu wɛ, wʼa bi wari wu kan piimu mu ge, a wu pee yiri, kuduun wemu pʼa ta ge, kɔnhɔ wu wee cɛ. ");
INSERT INTO myk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A nizhiimɛ wu ba na jo: ‹Na ɲuŋɔfɔɔ, nʼa ma wari wu taga kapyeŋɛɛ pye, a wu wu shi kɛ ta.› ");
INSERT INTO myk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A wu wee pye: ‹Lʼa ɲɔ kapyebye nizaama, ba na jo mʼa pye ɲɔmɛɛ fɔɔ kapigee ni wɛ, nʼa da ma pye kugbɔhɔɔ kɛ gbafɛnɛɛri.› ");
INSERT INTO myk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A shuun wo wu ba na jo: ‹Na ɲuŋɔfɔɔ, nʼa ma wari wu taga kapyeŋɛɛ pye, a wu wu shi kaguro ta.› ");
INSERT INTO myk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A wu wee pye: ‹Mu bɛ wu pye kugbɔhɔɔ kaguro gbafɛnɛɛri.› ");
INSERT INTO myk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A wa bɛ di ba na jo: ‹Ɲuŋɔfɔɔ, ma warifyɛn wu we wu siimɛ na, nɛ bi wu migile sicogo ni na kemɛ yaha. ");
INSERT INTO myk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɛ fya mu na, bani nɛ bi li cɛ jo mu keree kʼa waha, mu ya kemu yaha wɛ, kee mu ya luu, mu ya kemu nugi wɛ, kee mu ya gɔɔn,› ");
INSERT INTO myk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A wu kafɔɔ wu wu pye: ‹Nʼa da ma kiiri kɔn na bɛ ni ma kafila wu ni, kapyebye niguumɔ, a mu ya li cɛ na nɛ keree kʼa waha ge, nɛ kemu yaha wɛ na kee luu, nɛ kemu nugi wɛ na kee kɔɔn ge. ");
INSERT INTO myk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ɲaha na mʼa ya ta nɛ wari wu yaha baŋi na, kɔnhɔ di ba wu lɔ ni wu kuduun ni na niguribawo wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Lee kadugo na piimu pʼa bye wà ge, a wu pee pye: ‹Yi wu wo wari wu shɔ wu na, yʼi wu kan kɛ fɔɔ wu mu.› ");
INSERT INTO myk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A pʼi wu pye: ‹Ɲuŋɔfɔɔ we! Go wu wo wu shi kɛ wu wa wu mu na xɔ!› ");
INSERT INTO myk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A wu pu pye: ‹Nʼa da yi jo yi mu, la ɲɛ wemu mu ge, la na ba gan wee mu na fara wu wuu li na. Ga la ɲɛ wemu mu wɛ, ali nifɛnhɛfɛnhɛnɛ lemu bɛ li ɲɛ wu mu ge, lee bɛ na ba shɔ wu na. ");
INSERT INTO myk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nɛ pɛɛn piimu ya ta sɔɔ nɛ wu pye pu ɲuŋɔfɔɔ wɛ ge, yi pa ni pee ni naha yʼi pee gbo na ɲii na.›» ");
INSERT INTO myk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ba Yesu ya yee jo xɔ wɛ, na doro sipyiire ti ɲahagbaa na, na se Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tuun wemu ni wʼa tɛɛŋɛ Bɛtɛfajɛ ni Bɛtani kulogoo ki na ge, faaboboŋɔ ki shizhaa na kemu mɛgɛ pʼa yiri Oliviye faaboboŋɔ ki ge, a wu wu kalaapiire shuun wa tun, na pu pye: ");
INSERT INTO myk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Yi shɛ yi ɲahagbaa kulo li ni, yi ba shɛ jin li ni, yi na kafabige ka nibɔgɔ ta wà sipya sanha dugi ɲa kemu na wɛ, yʼi kee sanha yi pa naha. ");
INSERT INTO myk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sipya wa bu yi pye: ‹Ɲaha na yee di ke sanhana wɛ?› Yi weefɔɔ pye: ‹Wèe Kafɔɔ wu mago wu wa ki na.›» ");
INSERT INTO myk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Piimu pu bye tudunmɔɔ pu ge, a pee di gari na shɛ yi ta ba Yesu ya yi jo pu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na pu yaha pu na kafabige ki sanhana, a ki kafɛɛ di pu yege na: «Ɲaha na yʼi wa ke kafabige ke sanhana wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A pʼi jo: «Wèe Kafɔɔ wu mago wu wa ki na.» ");
INSERT INTO myk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A pʼi ba ni ki ni Yesu yíri, na ba pu fadegbɔyɔ ya taha ki na, na Yesu durogo ki na. ");
INSERT INTO myk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ba wʼa gaaŋi wɛ, a sipyii pʼi ganha na pu fadegbɔyɔ piini koo li ni. ");
INSERT INTO myk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tuun wemu ni wu bi tɛɛŋɛ Zheruzalɛmu na ge, Oliviye faaboboŋɔ ki tatigiŋɛ ki shizhaa na ge, a kalaapiire ti pinnɛgɛ ki bɛɛri di ɲi fundanga na, na ganha na Kilɛ pɛlɛ ni mujoŋɔɔ nigbɔhɔɔ ni. Pʼa kakanhaŋaa kiimu bɛɛri ɲa ge, kee wuu na. ");
INSERT INTO myk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A pʼi jo: «Pye duba fɔɔ, saan, mu wemu wʼa ma Kafɔɔ Kilɛ mɛgɛ na ge!» «Ɲaɲiŋɛ ki pye fugba wu ni, nɔɔrɔ di daha Kilɛ mɛgɛ na fugba lii lii wu ni!» ");
INSERT INTO myk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farizhɛɛn piimu pu bye sipyiire ti niŋɛ ni ge, a pii di Yesu pye: «Karamɔgɔ, jo ni ma kalaapiire ti ni na pu co puyɛ na!» ");
INSERT INTO myk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A wu pu ɲɔ shɔ: «Nʼa da yi jo yi mu, ali pu bu jo puyɛ na bɛ, kagereye yʼa da sipyaa suu pu tɛgɛ!» ");
INSERT INTO myk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ba Yesu ya tɛɛŋɛ Zheruzalɛmu na wɛ, ba Yesu ya wu ɲa wɛ, na mɛɛ su wu wuu na, na jo: ");
INSERT INTO myk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Kaa le li da já ɲaɲiŋɛ kan mu mu niɲaa wo caŋa ɲii le ni ge, mu da bi lee ta cɛ! Ga nimɛ, lee ya ŋmɔhɔ mu na! ");
INSERT INTO myk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bani caya ya wa ma mu mu, ma pɛɛn na ba kasɔrɔgɔ yereŋɛ na taga ma maha, na ma kuuri, na do ma na. ");
INSERT INTO myk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pu na ba ma ni ma sipyii pu bɛɛri tɔnhɔnɔ, pu da ga kafaan pile la shishiin nidahaŋa yaha la ɲuŋɔ ni wɛ, bani Kilɛ ya pa mu dɛgɛ kaa na tuun wemu ni ge, mu ya ta lee cɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lee kadugo na a Yesu di jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Sipyii piimu pu bi bɛrɛ ni zhɔ pyi wà ge, a wu ganha na pee kɔri na yeege. ");
INSERT INTO myk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A wu pu pye: «Lʼa ka Kilɛ Kafila wu ni na: ‹Pu na ba nɛ puga ki pyi Kilɛ-ɲɛrɛgɛ puga,›» A Yesu di nɔhɔ jo sanha na: «Ga yee kunni ya ki pye nagaalaa talaraga.» ");
INSERT INTO myk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wʼa bi kalaa kaan caŋa bɛɛri Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ, ni sipyiire ti sipyigbɔɔ pʼi ganha na wu shaa di gbo. ");
INSERT INTO myk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ga pu ya cɛ dii pu da lee pye wɛ, bani sipyiire ti bi wu jomɔ pu nuri ni see ni. ");
INSERT INTO myk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Caŋa ka, na Yesu yaha wu na kalaa kaan Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na Kilɛ wo Jozaama pu yu, a saraya ɲaha shɔɔnrivɔɔ, ni saliya karamɔgɔlɔɔ pʼi nɔ na fara nɔhɔlɛɛ pu na, ");
INSERT INTO myk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na wu pye: «Sefɛɛrɛ tekɛ gbɔɔrɔ ni mu ya kii keree kii pyi ge, tee jo wù mu, kelee jɔgɔ wʼa tee sefɛɛrɛ ti kan mu mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A Yesu di pu pye: «Nɛ bɛ wʼa da yi yege. ");
INSERT INTO myk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔgɔ wʼa Yohana tun na wʼa batizeli pyi wɛ? Kilɛ laa sipyii?» ");
INSERT INTO myk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A pʼi puyɛ pye: «Wù bu jo: ‹Kilɛ wʼa wu tun,› wu na jo: ‹Ɲaha na yee di ya ta dà wu na-ɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wù bu nɔhɔ jo: ‹Sipyii pʼa wu tun,› sipyiire ti na wu wá gbo ni kagereye ni, bani pu bɛɛri ya dà li na na Kilɛ tudunmɔ wu bye Yohana.» ");
INSERT INTO myk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lee na a pʼi wu pye na pee ya cɛ jɔgɔ wʼa wu tun wɛ. ");
INSERT INTO myk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Yesu bɛ di pu pye: «Ayiwa nɛ bɛ ya she, sefɛɛrɛ temu tʼa nɛ pye nɛ na ki pyi ge, nɛ bɛ da tee jo yee mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lee kadugo na a Yesu di ganha na le talenɛ le yu pu mu na: «Ná wa wʼa bi ɛrɛzɛn tɛgɛ ka shan, na ki kaa le ɛrɛzɛn faapyii pii keŋɛ ni, na gari fiige katii ni, na shɛ mɔ wà. ");
INSERT INTO myk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ba ɛrɛzɛn wʼa pa lɛ wɛ, a wu kapyebye wa tun pee ɛrɛzɛn faapyii pu mu, kɔnhɔ pʼi ɛrɛzɛn wa yaha pa wu kan. Ga, a ɛrɛzɛn faapyii pʼi wee kpɔn, na wu kewaya wo yaha kari. ");
INSERT INTO myk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A wu nɔhɔ kapyebye wa bɛ tun kari, a pʼi wee bɛ kpɔn na wu cogana kolo, na wu bɛ kewaya wo yaha kari. ");
INSERT INTO myk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A wu taanri wo tun kari sanha, a pʼi wee bana, na wee kɔri wá. ");
INSERT INTO myk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«A tɛgɛ ki kafɔɔ di jo: ‹Lekɛ nʼa da bye wɛ? Na Ja nigin pe, na ɲidaan Ja we, wee nʼa da dun pu mu. La wa la ni pu na pɛɛŋɛ taha wee na.› ");
INSERT INTO myk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ga ba ɛrɛzɛn faapyii pʼa wee ɲa wɛ, na puyɛ pye: ‹Cɛn wu lɔvɔɔ wu ɲɛ we. Yi pa wù wu gbo, kɔnhɔ cɛn wu bye wù wo.› ");
INSERT INTO myk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A pʼi gari ni wu ni ɛrɛzɛn tɛgɛ ki kadugo yíri, na wu gbo. «Wee tuun wu ni tɛgɛ ki kafɔɔ wu da ba ɲaha pye pu na wɛ? ");
INSERT INTO myk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wu na ba ba, na pee ɛrɛzɛn faapyii pu gbo, na ɛrɛzɛn tɛgɛ ki kaa le piitiilee keŋɛ ni.» Ba pʼa yee logo wɛ, na jo: «Kilɛ wu wù tánha lee na!» ");
INSERT INTO myk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ga, a Yesu di pu wii na jo: «Wee tuun wu ni jomɔ pe pʼa ka Kilɛ wo Kitabu wu ni ge, na: ‹Puyirilee pʼa faakagereŋɛ kemu she ge, kee kʼa pye puga ki gunŋmii li faakagereŋɛ nijeŋɛ.› Pee jomɔ pu kɔri di ɲɛ dii wɛ? ");
INSERT INTO myk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sipyaa sipya wʼa to kee kagereŋɛ ke ɲuŋɔ ni ge, weefɔɔ na gɛgi gɛgi. Kee kagereŋɛ ki shiin bu do sipya bɛɛri ɲuŋɔ ni, weefɔɔ na dɔnhɔnɔ.» ");
INSERT INTO myk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lee taapile li ni a saliya karamɔgɔlɔɔ ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi ganha na cogana shaa Yesu na, bani pʼa li cɛ na pee na Yesu ya le talenɛ le jo wà. Ga, a pʼi fya sipyii pu na. ");
INSERT INTO myk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A pʼi diin na Yesu kasɛri, na ba kalɔhɔjuu pii tun, na pu puyɛ pye sipyitiimɛɛ, pu da kafila tifuuyo shaan Yesu tàan, pʼi kafila ta wu ɲɔ na, kɔnhɔ pʼi wu le fanhafɛɛ ni gbafɛnɛmɛ wu sipyii pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A pee di wu yege na: «Karamɔgɔ, wèe ya li cɛ na jo mu ya yu, na sipyii kalaa ni tiimɛ ni, mu ya sipya wa wo wa ni wɛ. Mʼa sipyii pu fiinŋɛ na galaa bɛ Kilɛ koro li ni. ");
INSERT INTO myk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ayiwa, lʼa saha wèe pʼa munaa pɛrɛmɛ kaan Oromɛ saannaa Sezari mu laa, li ya saha wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ba Yesu ya pee wo namari wu ɲa wɛ, na pu pye: «Yi wari dɛɲɛ wa shɛ na na.» ");
INSERT INTO myk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","A pʼi nigin wa shɛ wu na. A wu jo: «Jɔgɔ wo jaa ni wu kama pu wa we na wɛ?» A pʼi wu ɲɔ shɔ na: «Oromɛ saannaa Sezari.» ");
INSERT INTO myk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A Yesu di pu pye: «Wee tuun wu ni, yʼa Sezari wuu li kaan Sezari mu, yʼi da Kilɛ bɛ wuu li kaan Kilɛ bɛ mu.» ");
INSERT INTO myk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pu ya ta nahama ta Yesu jomɔ ni pemu pu da daga wu tɔɔgɔ le sipyii pu ɲaha tàan wɛ. Ga, a wu ɲɔshɔɔrɔ tʼi pu ɲaha wɔ, a pʼi fɛhɛ. ");
INSERT INTO myk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lee kadugo na, Yawutuu ɲuŋɔfɛɛ pii bye wà, Sadushɛɛn pu bye pii. Pee bi yu na xuɲɛnɛ da ba bye ɲiga na wɛ. A pii di ba shɛ Yesu yíri, na shɛ wu pye: ");
INSERT INTO myk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Karamɔgɔ, Kilɛ tudunmɔɔ Musa ya le ɲɔmɛɛ le ka na kan wèe mu na: ‹Ná wa wo ceborona bu xhu, na ta wu ya pya ta wu shɔ na wɛ, na wu wee naxhugoshɔ wu lɔ, kɔnhɔ wu nagoo ta di yaha wee ná wu nixhugo ki mu.› ");
INSERT INTO myk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","«Lee ya bi ceboronamaa gbarashuun wa ta wà. A nizhiimɛ wu cee leŋɛ, na xhu pya baa. ");
INSERT INTO myk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A shuun wo wu wee cee wu lɔ, na xhu pya baa, a taanri wo wu bɛ di wu lɔ na bye mu. ");
INSERT INTO myk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A pu gbarashuun wu bɛɛri di cee wu leŋɛ, a pu bɛɛri di xhu pu ya nɔhɔpiire ta wɛ. ");
INSERT INTO myk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lee kadugo na a cee wu bɛ di xhu. ");
INSERT INTO myk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wee tuun wu ni xuu pu caɲɛŋɛ ke, wee cee wʼi da ba bye pu shɛn nigin wekɛ wo wɛ? Bani pu gbarashuun wu bɛɛri ya wu leŋɛ toro.» ");
INSERT INTO myk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A Yesu di pu pye: «Ke koŋɔ ke sipyii ya cèe leŋɛɛ, na gbaya jii, ");
INSERT INTO myk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ga piimu pʼa yaa pu pa jé Kilɛ wo kobaŋa ki ni ge, pee ba ba xhu na ba ɲɛ na foro xu ni ɲiga na, pee wa da cèe leŋɛ, kelee na gbaya je wɛ. ");
INSERT INTO myk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pee da xhuu nige wɛ, bani pee na bye ba fugba mɛlɛkɛɛ pii wa wɛ. Pu na bye Kilɛ nagoo, bani pee ɲɛ xuɲɛnɛ li sipyii. ");
INSERT INTO myk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kilɛ tudunmɔɔ Musa yɛ pyaa ya li shɛ na xuɲɛnɛ na ba bye, bani xuu wemu ni na ki wo tire li kaa ya yu ge, wee xuu wu ni wʼa Kafɔɔ Kilɛ pyi: ‹Ibirayima wo Kilɛ, ni Ishaaga wo Kilɛ, ni Yakuba wo Kilɛ.› ");
INSERT INTO myk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pee jomɔ pe ya li shɛɛ na Kilɛ ɲɛ xuu wo Kilɛ wɛ, ga wyii wo Kilɛ wu ɲɛ wii. Bani wee mu pu bɛɛri wa ɲiifɛɛrɛ ni.» ");
INSERT INTO myk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A saliya karamɔgɔlɔɔ pii di kafila wu lɔ, na jo: «Karamɔgɔ, ma jomɔ pʼa ɲɔ.» ");
INSERT INTO myk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wa shishiin ya luu waha na wu yege nige kaa la shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wee tuun wu ni a Yesu bɛ di pu yege na: «Ɲaha na sipyii ya yu na Shɔvɔɔ wu ya ta sii pye watii Dawuda ja yɛ kadugo na-ɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bani Dawuda yɛ pyaa ya yi jo Zaburuu Kitabu wu ni na: ‹Kafɔɔ Kilɛ ya yi jo nɛ Kafɔɔ mu na: Tiin saanra tatɛɛngɛ ki ni na kanige cɛ, ");
INSERT INTO myk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fo di ba ma pɛɛn pye ma ɲidahaa tatahaŋa.› ");
INSERT INTO myk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda ya Shɔvɔɔ wu pyi Kafɔɔ, wee tuun wu ni wʼi ɲɛ dii wu ja yɛ nigin wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sipyiire ti bɛɛri ɲii na a Yesu di wu kalaapiire ti pye: ");
INSERT INTO myk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Yʼa yiyɛ kasɛri saliya karamɔgɔlɔɔ pu na. Na fadedɔɔnyɔ leni na ɲaari lee lʼa dan pu ni, ni sipyii na gbɔɔrɔ fò kaan pu mu pinnɛrɛ kpɛɛnyɛ na. Kilɛ-pɛɛŋɛ piyɛyɛ yi wo ɲahagbaa tatiinyɛ, ni yaliceŋɛɛ wo tatiinceye bɛ di dan pu ni. ");
INSERT INTO myk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pʼa naxhugoshaa keŋɛ yaŋmuyɔ bɛɛri ŋmahana na zhuu pu na, na mɔni Kilɛ-ɲɛrɛgɛ na, kɔnhɔ pʼi puyɛ pye see sipyii. Pu wo jaagi kanhama pu na ba golo fo xuuni.» ");
INSERT INTO myk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A Yesu di wu ɲuŋɔ yirige, na naafuu fɛɛ pu ɲa pu na Kilɛ wo taa li leni keshi wu ni. ");
INSERT INTO myk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A wu naxhugoshɔ la baa fɔɔ wa ɲa wu bɛ ya wari tuuŋɔɔ nifɛnhɛfɛnhɛŋɛɛ shuun le wu ni. ");
INSERT INTO myk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A wu jo: «Can na nʼa da yi jo yi mu, we naxhugoshɔ la baa fɔɔ we ya lemu le ge, lee ya ɲɛhɛ pusamaa bɛɛri wuu li na. ");
INSERT INTO myk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bani pusamaa bɛɛri ya wolo wolo pu naafuu ni na kan, ga wee kunni ni wu la baara ti ni, wʼa wu ɲɔshaga wuu li bɛɛri kan.» ");
INSERT INTO myk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lee kadugo na pii bi Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaa yu wu kalaapiire ti ni na kʼa sii ɲɔ ni ki faaya yi ni, ni sipyii pu wo Kilɛ yakanya yi bɛ. Ga, a Yesu di pu pye: ");
INSERT INTO myk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Yemu bɛɛri yee wa ɲaa naha ge, caŋa ka wa ma, kagereŋɛ ka shishiin wa da ba gori naha ka ɲuŋɔ ni wɛ. Yi bɛɛri na ba do fɛɛfɛɛ.» ");
INSERT INTO myk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A pʼi wu yege na: «Kee keree kii na ba bye tuun wemu ni ge, wee shɛ wù na! Ki ba da bye, ɲaha shɛshɛɛrɛ tekɛ tʼi da bye wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A Yesu di pu pye: «Yʼa yiyɛ kasɛri, kɔnhɔ yi ɲuyɔ ganha bu gyɛɛgi wɛ. Bani sipyii niɲɛhɛmɛɛ na ba ma ni nɛ mɛgɛ ni na yu: ‹Nɛ wu ɲɛ wii› kelee ‹Tuun wʼa nɔ.› Yi ganha bu daha pu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yi ba kashɛn ni nʼa she keree nuri tuun wemu ni, yi ganha da vya wɛ. Li waha lʼi waha kee keree kʼa yaa na fɛnhɛ pye, ga lee di wa nago wee tuun wuyɛ pyaa ni koŋɔ kʼa da xhɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lee kadugo na a wu pu pye: «Shi wa na ba yìri shi watii kaa na. Saanra ta na ba yìri saanra tatii kaa na. ");
INSERT INTO myk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɲiŋɛ cɛlɛŋɛ nigbɔhɔ na ba byi tɛyɛ ya ni, ni xuugbɔhɔ, ni banikuuyo. Fyaara kagbɔhɔɔ ni ɲaha shɛshɛɛrɛ nigbɔɔrɔ na ba ɲaa na yìri fugba we ni. ");
INSERT INTO myk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ga yani lee li pye ge, pu na ba yi coni, na yi ɲaani xuuni. Pu na ba se ni yi ni Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, na kiiri kɔɔn yi na, na yi leni kaso ni. Pu na ba se ni yi ni saannaa ni gbafɛnɛɛrɛɛ mu nɛ mɛgɛ wuu na. ");
INSERT INTO myk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lee na ba bye kaɲuŋɔ yi na Kilɛ wo Jozaama pu jo pu mu. ");
INSERT INTO myk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jomɔ pe yi da ba shɛ jo pee di yi ɲuŋɔ wolo ge, yi ganha ba pee shaa da yɛri yi funyɔ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bani nɛ na ba ɲɔ kan yi mu, na fungɔngɔ fɛɛrɛ kan yi mu, fo sipya bɛ da da yi pɛɛn pu ni, wemu na já yi ɲɔ shɔ, kelee di yi kafila kaala wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ali yi tii, ni yi nii, ni yi puga shɛɛn, ni yi cebooloo, ni yi naɲiinɛɛ bɛ na ba yi leni keye ni. Pu na ba pii gbuu yi ni. ");
INSERT INTO myk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sipyii bɛɛri na ba yi kɔ nɛ mɛgɛ wuu na. ");
INSERT INTO myk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ga, ali yi ɲuzhige nigin we wa bɛ da biin wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lee wuu na, yi la le yiyɛ ni, yʼi yi logoo mara, lee funŋɔ ni yʼa da yi munahaa ɲuŋɔ wolo. ");
INSERT INTO myk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Yi ba kashɛn keye ɲa yʼa Zheruzalɛmu maha tuun wemu ni, yʼi li cɛ na wu jaduun wʼa nɔ. ");
INSERT INTO myk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wee tuun wu ni, piimu na ba bye Zhude fiige ki ni ge, pee di ba fe pʼa se faaboboyo xuu ni. Piimu na ba bye Zheruzalɛmu kulo liyɛ pyaa funŋɔ ni ge, pee di ba fe pʼa fòro. Piimu na ba bye sige ni ge, pee ganha bu jé kanha ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kee cabyaa ki na ba bye Kilɛ wo kiiri cabyaa Zheruzalɛmu na, kɔnhɔ yemu bɛɛri Kilɛ tudunmɔɔ pʼa ka Kitabu wu ni ge, yi bɛɛri ɲɔ di fa. ");
INSERT INTO myk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bɔɔngɔ na ba bye lahaa fɛɛ ni puŋmaraya fɛɛ wogo yee caya yi na. Bani kanhama nigbɔ pu da ba bye fiige ki ni. Kilɛ na ba wu loyire li shɛ ki sipyii pu na. ");
INSERT INTO myk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ŋmɔparaa na ba pii gbo, pʼa pii co kari fiiye yatii ni na pye buloo. Shi wemu ɲɛ Yawutuu wɛ, wee na ba Zheruzalɛmu kana fo pu wo tuun wu ba shɛ doro. ");
INSERT INTO myk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Yi na ba ɲaha shɛshɛɛrɛ ɲaa caŋa, ni yeŋɛ, ni wɔrɔɔ kii ni. Lokuruyo nigbɔyɔ na ba sani na yìri suumɔ lɔhɔ ni ɲiŋɛ ke na, yi tunmɔ na ba bɛlɛ fo na fyaara ni funbɛɛnrɛ yaha ɲiŋɛ ki sipyii pu bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sipyii na ba jiregi na xhuli ɲiŋɛ ke wo kapegee fyaara ni ki ɲibaŋa funbɛɛnrɛ keŋɛ ni. Bani ali fugba wu sefɛɛrɛ ti na ba jɛlɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wee tuun wu ni pu na ba Sipya Ja nibawo ɲa fugba ɲahaya ye na ni sefɛɛrɛ ti bɛɛri, ni nɔɔrɔ nigbɔ ni. ");
INSERT INTO myk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yi ba kee keree kii ɲaa kʼa ɲɔ kɔn na byi tuun wemu ni, yʼi yìri tii, yʼi yi ɲuyɔ yirige, bani yi ɲuŋɔ woloduun wʼa tɛɛŋɛ.» ");
INSERT INTO myk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lee kadugo na a Yesu di le talenɛ le jo pu mu na: «Yi nitoodige ni tiye yi saya bɛɛri wii. ");
INSERT INTO myk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yee ba yi ɲaa yi na funni tuun wemu ni, yee wa ma li cɛ yiyɛ ni na ki nagoo pyeduun wʼa tɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mu li wa, yi ba kii keree kii ɲaa ki na byi tuun wemu ni, yʼi li cɛ na Kilɛ saanra tʼa tɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Can na nʼa da yi jo yi mu, niɲaa wo sipyii pii bɛɛri wa da xhuu kii keree kii di na pye wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Fugba we ni ɲiŋɛ ke na ba doro, ga nɛ jomɔ pe wa da doro bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Yi kasɛɛgɛ yaha yiyɛ na, yi ganha da gori ligbɔhɔ yɛ na, ni gba, yi da yi funyɔ shaa ni koŋɔ yaŋmuyɔ da ni, fo di zhɛ nɛ cabaŋa pye ki pa yi bɛ fo wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bani nɛ cabaŋa na ba ɲiŋɛ ki sipyii pu bɛɛri fo, ba jɔ̀ ma fyaa fo na pu tɔ wolo wɛ. ");
INSERT INTO myk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ga yi kori yaha ɲìi na, yi da Kilɛ ɲɛɛri tuun bɛɛri ni, kɔnhɔ yʼi fanha ta, yʼi ba shɔ kii keree nibaŋaa kii bɛɛri na, yʼi ba já yere Sipya Ja wu ɲahagbaa na.» ");
INSERT INTO myk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu bi ma sipyii pu kalaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni caŋa ni, ga piige bu wɔ, wʼa shɛ shɔn Oliviye faaboboŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yani ɲiga ki mugi ge, sipyii pu bɛɛri na shɛ wu ɲuŋɔ círi Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na wu jomɔ pu nuri. ");
INSERT INTO myk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Shizhɛnhɛrɛ Baa Buuri Kalenɛ lemu li ɲɛ na Ɲuwuuro ti wo Kalenɛ li ge, lee bi dɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu bi gbogana shaa Yesu na, ga na fyagi sipyii pu na. ");
INSERT INTO myk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wee tuun wu ni, Zhudasi we pʼa yiri na Isikariyɔti ge, a Shitaanni di ba jé wee ni. Kalaapiire kɛ ni shuun wu wa wʼa bye wii. ");
INSERT INTO myk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A Zhudasi di shɛ saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii ɲuŋɔfɛɛ pu mu. Wu na já Yesu le pu keŋɛ ni legana lemu na ge, a pʼi jo bɛ lee na. ");
INSERT INTO myk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A lee di daan pu ni xuuni. A pʼi bɛ yi na na pee na ba wari kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","A Zhudasi di sɔɔ pu mu na ganha na pyegazaana shaa wu Yesu le pu keŋɛ ni sipyiire ti kategee. ");
INSERT INTO myk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Shizhɛnhɛrɛ Baa Buuri Kalenɛ li caŋa kʼa nɔ ge, kee caŋa ke Ɲuwuuro ti wo Kalenɛ li saraga dubyapige ki ma yaa na gbo. ");
INSERT INTO myk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A Yesu di Pyɛɛri ni Yohana tun na pu pye: «Yi shɛ Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele, kɔnhɔ wù shɛ ki li.» ");
INSERT INTO myk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A pʼi wu pye: «Ma funŋɔ wa wù shɛ ki gbegele xuu wekɛ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A wu pu ɲɔ shɔ: «Wii, yi ba jin kanha ki ni, yi na zhɛ saha ni ná wa ni wʼa lɔhɔ shɔɔ tugo, yʼi daha wee fɛni. Wu ba shɛ jé puga kemu ni, yi bɛ di jé wà. ");
INSERT INTO myk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yʼi kee puga ki kafɔɔ pye: ‹Wù Karamɔgɔ wʼa jo na wee ni wu kalaapiire ti na ba Ɲuwuuro ti wo Kalenɛ li yalige ki li talige puga kemu ni ge, na mii ki wa wɛ?› ");
INSERT INTO myk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wu na pugbɔhɔ ka shɛ yi na zangaso wu ni, kee wa gbegele xuuni na yaha, yʼi kalenɛ li yalige ki gbegele wà.» ");
INSERT INTO myk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A pʼi gari na shɛ keree ki ta ba Yesu ya yi jo pu mu wɛ. A pʼi Ɲuwuuro ti wo Kalenɛ li yalige ki gbegele wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ba liduun wʼa pa nɔ wɛ, a Yesu ni wu tudunmɔɔ pʼi diin na li. ");
INSERT INTO myk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A wu pu pye: «Na le Ɲuwuuro Kalenɛ le wo yalige ki pinnɛ li ni yee ni, nɛ lee la pye fo xuuni, yani di ba ganha ge. ");
INSERT INTO myk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bani nʼa da yi jo yi mu, nʼa da kee ka shi li nige wɛ, fo caŋa kemu Kilɛ da ba ki yàa wu saanra ti ni ge.» ");
INSERT INTO myk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wee tuun wu ni a wu ɛrɛzɛn lɔhɔ cɛɛgbuu li lɔ, na baraga taha Kilɛ na na jo: «Yi ke co yʼi ki taa taa yiyɛ na. ");
INSERT INTO myk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bani nʼa da yi jo yi mu, nʼa da ɛrɛzɛn lɔhɔ gba nige wɛ, fo Kilɛ wo saanra ti ba ba.» ");
INSERT INTO myk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lee kadugo na a wu buuri wa lɔ, na baraga taha Kilɛ na, na wu kɛgi kɛgi na kan pu mu na jo: «Nɛ ceepuuro ti wa te, yee wuu na tʼa kan. Yʼa le pyi kɔnhɔ yi funyɔ di da dun ni na kaa ni.» ");
INSERT INTO myk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba pʼa li xɔ wɛ, a wu ɛrɛzɛn lɔhɔ cɛɛgbuu li bɛ lɔ kan pu mu, na jo: «Kilɛ ya kariɲɛɛgɛ ɲɔmɛɛ nivonɔ lemu lɔ sipyii mu nɛ shishan baraga ni ge, lee li wa mɛ ke ɛrɛzɛn lɔhɔ ke. Yee wuu na pee shishan pʼa wo. ");
INSERT INTO myk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ga, lee bɛ na we wʼa da nɛ le keŋɛ ni ge, wee we na li ni nɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sipya Ja wu kunni, wu na ba xhu ba Kilɛ ya li jo wu shizhaa na wɛ. Ga wemu wʼa da ba wu le keŋɛ ni ge, bɔɔngɔ ki ɲɛ weefɔɔ wogo.» ");
INSERT INTO myk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A pʼi ɲɔ kɔn na puyɛ yegee na wekɛ wu da ba le pye pee ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lee kadugo na a kalaapiire tʼi ba do nakaara na na byi. Pu bi puyɛ yegee na wekɛ wʼa yaa na pye pu bɛɛri ɲahagbaa fɔɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A Yesu di pu pye: «Shi wemu ɲɛ Yawutuu wɛ, wee shi wu wo saannaa ya pu ɲuŋɔfɛɛrɛ pyi wu na. Pii pu wa fanhafɛɛ pu ge, a pee funŋɔ di bye shi wu wʼa pu mɛyɛ yiri na: ‹Kasaaŋaa pyevɛɛ.› ");
INSERT INTO myk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ga, li ya yaa na pye mu yee mu wɛ, ga we wu wa yee bɛɛri ɲahagbaa fɔɔ ge, wee ya yaa na pye ba pu bɛɛri nɔhɔcɛrɛɛ ɲɛ wɛ. We wu ɲɛ ɲuŋɔfɔɔ ge, wee di bye ba kapyebye ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kapyebye we wʼa sori ge, ni wu ɲuŋɔfɔɔ we wu da ba diin yɛ wu li ge, wekɛ wʼa pɛlɛ pu shuun wu ni wɛ? We wu da ba diin yɛ wu li ge, ta wee bɛ wʼa pɛlɛ wɛ? Ga lee bɛ na nɛ ɲɛ yee niŋɛ ni ba kapyebye ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yee ya pye sipyii, pii pʼa pye ni nɛ ni na nɔwuuro ti keree ki ni ge. ");
INSERT INTO myk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lee wuu na nʼa da Kilɛ wo saanra ti ɲɔ yaha yee mu, ba na To wʼa ti ɲɔ yaha na mu wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yi na ba binnɛ li, na binnɛ gba ni na ni na saanra ti ni. Yi na ba diin saanra korogoo ni, na kiiri kɔn Izirayɛli gbaweye kɛ ni shuun wu na.» ");
INSERT INTO myk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lee kadugo na a Yesu di jo: «Simɔ, Simɔ, Shitaanni ya li sha na wu yee nɔhɔ wolo saama na, wu yee suguri ba pʼa shinma sani na wo wu kugun ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ga nɛ Kilɛ ɲɛɛri mu mu, kɔnhɔ ma nʼa daa wu ganha bu guuŋɔ wɛ. Ma ba daburajɛ jo tuun wemu ni, na guri pa na mu, mʼa ma cebooloo pusamaa logoo waha.» ");
INSERT INTO myk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A Pyɛɛri di wu pye: «Kafɔɔ, wʼa pye kaso la, wʼa pye xu la, nʼa gbegele xɔ di jé ni ma ni ki bɛɛri ni.» ");
INSERT INTO myk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A Yesu di wu pye: «Pyɛɛri nʼa da li shɛ ma na, yani xhupoo wu pa mɛɛ su niɲaa piige ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri na mu ya nɛ cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Lee kadugo na a Yesu di pu pye: «Tuun wemu ni nɛ yee tun kari na ta wari, ni kushɛyɛrɛyɛ, ni tanhaya bye yee mu-i ge, yaaga ya yee kuuŋɔ ya?» A pʼi wu ɲɔ shɔ na: «Yaaga bɛ ya wèe kuuŋɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","«Ga nimɛ, wari ɲɛ wemu mu ge, wu wu lɔ, kushɛyɛrɛyɛ ɲɛ wemu mu ge, wu yi lɔ, ŋmɔpara ɲɛ wemu mu wɛ, wee di wu fadeŋɛ pɛrɛ taga la shɔ. ");
INSERT INTO myk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bani nʼa da yi jo yi mu, lemu ya ka nɛ shizhaa na ge, li waha lʼi waha, lee ɲɔ ya yaa na fa. Lʼa ka Kitabu ni na: ‹Wʼa tɔrɔ le kakuubyii ni.› Lemu di ɲɛ nɛ shizhaa wuu li ge, lee ɲɔ na ba fa.» ");
INSERT INTO myk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A kalaapiire tʼi wu pye: «Kafɔɔ, li bu da lere, ŋmɔparaa shuun wu wa mɛ.» A Yesu di jo: «Kʼa yaa mu xuuni.» ");
INSERT INTO myk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lee kadugo na a Yesu di foro, na gari Oliviye faaboboŋɔ ki na, ma na jo ba wʼa tee na li pyi pyegana lemu na wɛ. A wu kalaapiire ti bɛ di daha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba pʼa nɔ wee xuu wu ni wɛ, a Yesu di pu pye: «Yi Kilɛ ɲɛɛri, kɔnhɔ yi ganha bu jé nɔwuuro ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ba wʼa yee jo wɛ, na laha pu tàan, na shɛ ɲaha na jɛri, na nuguro sin, na Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Na jo: «Na To Kilɛ, li bu da lʼa taan ma mu, le kanhama cɛɛgbuu le sanha lii na na. Ga nɛ wo ɲidaan ganha bu bye wɛ, fo mu wo ɲidaan.» ");
INSERT INTO myk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wee tuun wu ni a mɛlɛkɛ wa di ba foro wu mu na yìri fugba we ni, na lowaa kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu funŋɔ ki bi cɔnri fo xuuni. A wu la fara Kilɛ-ɲɛrɛgɛ ki na. A wu ba fun, a wu fun fun lɔhɔ kʼi ɲɛri ba shishan ɲɛ wɛ, na niŋɛɛ na dun ɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ba wʼa xɔ Kilɛ-ɲɛrɛgɛ ki na wɛ, na guri pa kalaapiire ti yìri, na ba pee ta pee ya ŋmunɔ ɲatanhaŋa kanhama keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A wu pu pye: «Ɲaha na yee di ŋmunɔɔ wɛ? Yi yìri yʼi Kilɛ ɲɛɛri, kɔnhɔ yi ganha bu jé nɔwuuro ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na Yesu yaha pee jomɔ pu na, a sipyiire ta di nɔ, Zhudasi wʼa bye pee ɲahagbaa na. Yesu wo kalaapiire kɛ ni shuun wu wa wʼa bye wii. A wu gbara Yesu na, kɔnhɔ wu shɛ ɲɔsɔɔnrɔ fò kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ga, a Yesu di wu pye: «Zhudasi, go ɲɔsɔɔnrɔ fò ni mu ya Sipya Ja wu le keŋɛ ni gɛ?» ");
INSERT INTO myk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pii pu bye ni Yesu ni ge, ba pee ya li cɛ na Yesu tacoŋɔ ni pʼa ma wɛ, a pʼi jo: «Kafɔɔ, wù ŋmɔparaa lɔ pu fɛni ya?» ");
INSERT INTO myk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A pu shɛn nigin wa di saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo kapyebye wu kanige cɛ niwɛŋɛ paa laha. ");
INSERT INTO myk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ga, a Yesu di pu pye: «Yi yere mɛ!» A wu gbɔn ná wu niwɛŋɛ ki na, na wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lee kadugo na, saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii ɲuŋɔfɛɛ, ni nɔhɔlɛɛ pii pʼa shɛ Yesu fɛni ge, a wu pu pye: «A yee di ba ni ŋmɔparaa ni pubegee ni nɛ tacoŋɔ ni ma na jo kakuubye di ɲɛ ya?» ");
INSERT INTO myk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na ta nɛ bi bye ni yee ni caŋa bɛɛri Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, yee di ya ta nɛ co wɛ. Ga nimɛ, yee wo tuun wu wʼa nɔ, ni nibiige fanha ki wo tuun we. ");
INSERT INTO myk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba pʼa Yesu co wɛ, na gari ni wu ni saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu kaban. A Pyɛɛri di laraga kɔn pu na, na daha pu fɛni, ");
INSERT INTO myk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","fo na shɛ jé kaaŋa ki ni. A sipyii pii di na gbɛri kaaŋa ki niŋɛ ni, na diin ki tàan na wahani. A Pyɛɛri bɛ di diin pu tɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ba kapyebyezhɔ wa ya pa Pyɛɛri ɲa na ki tàan wɛ, na wu wii xuuni na jo: «We bɛ wu wa Yesu wo sipya wa.» ");
INSERT INTO myk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ga, a Pyɛɛri di foro wu kaa tàan na jo: «Cee we, nɛ ta wu cɛ bɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A jɛɛrɛ di bye, a ná wa di wu ɲa, na wu pye: «Go mu bɛ wu wa pu ni!» A Pyɛɛri di wee ná wu bɛ pye: «Ee! Nɛ wa pu ni-i dɛ!» ");
INSERT INTO myk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A lɛɛri nigin shishiin di doro, a ná wa bɛ di ba wu ɲa. A wee di sii yi jo waha na: «Nakaara baa we ná we bɛ wu bye ni Yesu ni, bani Galile shɛn wu wa wu bɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ga, a Pyɛɛri di wu ɲɔ shɔ na: «Ná we, ye mu wa yu ge, ali nɛ yi shi cɛ wɛ.» Na Pyɛɛri yaha wu na yee yu, taapile ni a xhupoo di mɛɛ su. ");
INSERT INTO myk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Kafɔɔ di ŋmahana ɲɛri na Pyɛɛri wii wu ɲaha niŋɛ ni. A Pyɛɛri funŋɔ di do ni Kafɔɔ kafilajo wu ni na: «Yani xhupoo wu mɛɛ su niɲaa ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri na mu ya nɛ cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A Pyɛɛri di foro kpɛɛngɛ ki na na shɛ mɛɛ su fo xuuni. ");
INSERT INTO myk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu bi bye namaa piimu keŋɛ ni ge, pee bi wu la wo, na wu kpɔɔn. ");
INSERT INTO myk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A pʼi wu ɲaha pɔ, na ganha na wu yegee na: «Jɔgɔ wʼa mu kpɔn wɛ? Ma kpɔnvɔɔ wu mɛgɛ yiri gɛ!» ");
INSERT INTO myk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A pʼi wu shɛhɛlɛ, na joguumɔ niɲɛhɛmɛ pa bɛ jo ni wu ni. ");
INSERT INTO myk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ba ɲiga kʼa mugi wɛ, a nɔhɔlɛɛ, ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni saliya karamɔgɔlɔɔ di shɛ puyɛ ɲa, na shɛ ni Yesu ni pu wo kiirikɔɔn kuruŋɔ ki mu. ");
INSERT INTO myk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A pʼi wu pye: «Ma bu da ma na ɲɛ Shɔvɔɔ we, yi ɲaha jo wù mu.» A Yesu di pu ɲɔ shɔ: «Nɛ ɲɛhɛ yi ɲaha jo yee mu, yee wa da dà yi na wɛ; ");
INSERT INTO myk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","nɛ di bu yee yege, yi wa da na ɲɔ shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ga na da niɲaa na, Sipya Ja wu na zhɛ diin Se Bɛɛri Fɔɔ Kilɛ kanige cɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A pu bɛɛri di binnɛ jo na: «Wee tuun wu ni ta mu wu ɲɛ Kilɛ Ja we?» A Yesu di pu ɲɔ shɔ na: «Ba yee wa yi yu wɛ, uun, wee nɛ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wee tuun wu ni a pʼi jo: «Ɲaha wo sɛɛri kaa fɛni wù ɲɛ sanha wɛ? Wùyɛ pyaa ya yi logo wu ɲɔ na.» ");
INSERT INTO myk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lee kadugo na a sipyii pu bɛɛri di yìri, na gari ni Yesu ni Pilate mu. ");
INSERT INTO myk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba pʼa nɔ wà wɛ, na jaagi ɲɔ kɔn na dɛri wu na na: «Wèe ya we ná we sɛɛri na wu ta wu na wù fiige ki sipyii pu sɔɔn, na pu ɲuyɔ nari. Wʼa pu ɲaha kɔɔn na pu ganha ba munaa pɛrɛmɛ kaan Oromɛ saannaa ɲuŋɔfɔɔ wu mu wɛ. Na jo na wee wu ɲɛ Shɔvɔɔ we, na saan wee ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A Pilate di Yesu yege na: «Yawutuu wo saan mu ɲɛ ya?» A wu wu ɲɔ shɔ na: «Uun, ba ma wa yi yu wɛ, wee nɛ ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lee kadugo na a Pilate di saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni sipyiire ti pye: «Nɛ ta tanahaŋa ka shishiin ɲa we ná we na wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ga, a pʼi yi jo na waha Pilate mu na: «Wʼa sipyii pu ɲuyɔ nari ni wu wo kalaa wu ni Zhude fiige ki bɛɛri ni; na lɔ Galile fiige ki na, fo na pa nɔ naha.» ");
INSERT INTO myk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ba Pilate ya yee logo wɛ, na pu yege na ta Galile shɛn wu ɲɛ Yesu? ");
INSERT INTO myk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A pʼi wu pye na Galile shɛn wu ɲɛ wii. Lee di Hɛrɔdi ta wee na ɲɛ Galile fiige ki ɲuŋɔ ni; wu bɛ di bi bye Zheruzalɛmu ni wee tuun wu ni. A Pilate di jo na pu shɛ ni Yesu ni Hɛrɔdi mu. ");
INSERT INTO myk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ba Yesu ya nɔ Hɛrɔdi yíri wɛ, a lee di sii taan Hɛrɔdi ni fo xuuni; bani wu bi keree niɲɛhɛŋɛɛ nuri wu shizhaa na. A lʼi mɔ xuuni Hɛrɔdi funŋɔ na ɲɛ wu Yesu ɲa. Wu bi daa na Yesu na kakanhana la pye wee bɛ ɲii na, ");
INSERT INTO myk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lee wuu na wʼa Yesu yege keree niɲɛhɛŋɛɛ na, ga Yesu ya wu ɲɔ shɔ la shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Lee di saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni saliya karamɔgɔlɔɔ pu bɛ ta wà. A pee di ganha na nama kɔɔn, na joguumɔ tuugo bɛɛri taga na wu jaagi. ");
INSERT INTO myk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A Hɛrɔdi ni wu sɔrɔsii pʼi sii Yesu shɛhɛlɛ, na wu la wolo. A pʼi saannaa fadeŋɛ ka le wu na. Lee kadugo na a Hɛrɔdi di Yesu kuruŋɔ na pa gan Pilate mu sanha. ");
INSERT INTO myk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kee caŋa ke a Hɛrɔdi ni Pilate di bye naɲiinɛɛ, lee kaa bɛ wɛ, pɛɛn pu bye pii taashiinɛ ni. ");
INSERT INTO myk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ba Yesu ya nɔ Pilate na wɛ, a Pilate di saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, ni fanhafɛɛ, ni sipyii pu bɛɛri yiri. ");
INSERT INTO myk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na pu pye: «Yee ya pa ni we ná we ni nɛ mu, na jo na wʼa fiige ki sipyii pu ɲuyɔ nari. Nɛ kunni ya wu yege yiyɛ pyaa bɛ ɲii na. Ga yee ya keree kiimu bɛɛri jo nɛ mu wu shizhaa na ge, nɛ ta lee la shishiin wo zɔ ɲa wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛrɔdi bɛ di wa zɔ ta wu na wɛ, bani wu bɛ ya wu kuruŋɔ na pa wù kan. Yi ɲii wa wu ni, wu kapyegee ki bɛɛri ni, nɛ kaa ɲa lemu lʼa wu kagbuu xɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wee tuun wu ni nʼa da wu kan pʼi wu kpɔn, lee kadugo na di wu yaha.» ");
INSERT INTO myk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lee di Pilate ta yee bɛɛri ba Yawutuu wo bulooro ɲuwuuro ti kalenɛ lʼa nɔ wɛ, wu ma yaa na kasolemɛ nigin wa yaha. ");
INSERT INTO myk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A sipyiire ti bɛɛri di ganha na xhuulo na yu: «We ná we gbo mʼa Barabasi yaha!» ");
INSERT INTO myk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na ta wee Barabasi we di bi bye nʼa she fɔɔ. Caŋa ka wʼa pa tunmɔ yirige kulo li funŋɔ ni, na sipyiire ti lɔ suri tiyɛ ni fo na wa gbo. Lee na pʼa bi wu le kaso ni. ");
INSERT INTO myk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Lee di Pilate ta wu funŋɔ na ɲɛ wu Yesu yaha, a wu pu yege sanha. ");
INSERT INTO myk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ga, a pʼi xhuulo na: «Wu kori tige na! Wu kori tige na!» ");
INSERT INTO myk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A Pilate di pu pye tɔɔɲii taanri wuu li ni na: «Kakuunɔ lekɛ we ná we dʼa pye wɛ? Nɛ kunni ya kaa ɲa wu na lemu ya wu kagbuu xɔ wɛ. Lee wuu na nʼa da wu kan pʼi wu kpɔn, lee kadugo na di wu yaha.» ");
INSERT INTO myk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ga, a pʼi zhe na xhuulo na pu wu kori tige na. A pu mujoŋɔɔ kʼi ba se ta Pilate na. ");
INSERT INTO myk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wee tuun wu ni a Pilate di jo na pu wo fungaa li na voro. ");
INSERT INTO myk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wemu wu bi nʼa she ni gbuuro ti pye a pʼi wu le kaso ni ge; a Pilate di wee yaha, bani wee kaa pu bi yu na wu wee yaha. Ga we wu ɲɛ Yesu ge, a wu wee kan sɔrɔsii pu mu na pu sipyiire ti wo ɲidaan pye wu na. ");
INSERT INTO myk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ba pʼa gaaŋi ni Yesu ni wu takorogo ki ni wɛ, na shɛ saha ni ná wa ni wee ya yìri wu kɛrɛyɛ ni na doroo. Wee mɛgɛ ki bye na Simɔ; Sirinɛ shɛn wu bye wii. A sɔrɔsii pʼi wee karamu wʼa Yesu korikoritige ki lɔ na taha wu fɛni. ");
INSERT INTO myk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sipyiɲɛhɛmɛɛ pu bi taha pu na na gaaŋi. Cèe pii bɛ bye ni pu ni. Pee ɲahaya yi bi tanha fo pu na pu dodoyo kpɔɔn, na mɛhɛɛ suu xuuni Yesu kaa na. ");
INSERT INTO myk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Yesu di ba ŋmahana ɲɛri pu yíri na pu pye: «Zheruzalɛmu cèe, yi ganha ba mɛhɛɛ suu nɛ wuu na wɛ, ga yʼa mɛhɛɛ suu yiyɛ pyaa ni yi nagoo wuu na! ");
INSERT INTO myk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bani caya ya wa ma, yee caya yi na pu na ba jo na: ‹cèe pii pu ɲɛ seganhanaa ge, pii pu ɲɛ pu sanha pya se ɲa wɛ, pʼi sanha jire kan ɲa pya mu-i ge, pee ɲɛ duba nagoo.› ");
INSERT INTO myk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wee tuun wu ni sipyii na ba faaboboyo ye pyi na: ‹Yi to wù ɲuŋɔ ni.› Na boboyo ye pyi: ‹Yi wù ŋmɔhɔ.› ");
INSERT INTO myk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bani le bi ɲɛ tipurege wo pyegana, tiwaga di da ba bye dii wɛ?» ");
INSERT INTO myk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A pʼi gari ni kakuubyii shuun bɛ ni, pʼi shɛ pee bɛ pinnɛ gbo ni Yesu ni. ");
INSERT INTO myk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Xuu wemu mɛgɛ pʼa yiri na Ɲugɔrɔgɔ Xuu ge, ba pʼa shɛ nɔ wà wɛ, na Yesu kori tige na wee xuu wu ni. A pʼi kakuubyii shuun wu bɛ kori wu tàan. A pʼi nigin kori tige ka na wu kanige cɛ, na wusama kori tige ka na wu kamɛnɛ cɛ. ");
INSERT INTO myk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A Yesu di jo: «Na To Kilɛ, le yafa pu mu, bani le pu wa byi ge, pu ya li cɛ wɛ.» Lee kadugo na a sɔrɔsii pʼi kagaanshaan pye, na Yesu fàya yi taa taa puyɛ na na bɛ ni lee kagaanshaan li ni. ");
INSERT INTO myk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sipyii pu bye wà na yere na wii. A Yawutuu ɲuŋɔfɛɛ pʼi ganha na Yesu la wo na yu na: «Wʼa sipyii piitiilee shɔ, wu wuyɛ shɔ gɛ ni wʼa sii Shɔvɔɔ we, Kilɛ ya wemu ɲaha bulo na wu tun na pa ge!» ");
INSERT INTO myk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A sɔrɔsii pu bɛ di Yesu la wolo. A pʼi fulo wu na, na vinɛgiri kan wu mu, ");
INSERT INTO myk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na jo: «Ma bi sii Yawutuu wo saan we, mayɛ shɔ gɛ!» ");
INSERT INTO myk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A pʼi kɔɔrɔ la kori wu ɲuɲɔ na ni kama pa ni, pee ɲɛ na: ");
INSERT INTO myk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kakuubyii shuun we pʼa kori Yesu tàan ge, a wee wa bɛ di wu fanha na: «Ta mu bɛ wu wa Shɔvɔɔ wu wɛ? Mayɛ shɔ sa, ma ba wù bɛ shɔ!» ");
INSERT INTO myk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ga, a kakuubye shuun wo wu jo ni wee ni na wu pye: «Ali mu ya fyagi bɛ Kilɛ na wɛ! Kanhama pemu na wu ɲɛ ge, mu bɛ na ɲɛ pee ninumɔ na, na pe jomɔ pe tuugo yu. ");
INSERT INTO myk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nɛ ni mu ni kunni, wèe ya yaa ni pe kanhama pe ni, bani wèe wo kakuuŋɔɔ ki wo footɔsaraa wʼa we. Ga we ya kakuunɔ la shishiin pye wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lee kadugo na a wu Yesu pye: «Yesu, ma ba ba ma saanra ti ni tuun wemu ni, mʼa hakili yaha na na.» ");
INSERT INTO myk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A Yesu di wu ɲɔ shɔ na: «Can na nʼa da yi jo ma mu, niɲaa yɛ pyaa ma na ba jé ni nɛ ni Alijinɛ ni.» ");
INSERT INTO myk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ba caŋa kʼa pa nɔ ɲiŋɛ niŋɛ ni wɛ (12h00), a nibiige di jé fiige ki bɛɛri ni, fo na shɛ nɔ yakoŋɔ caŋa ki na (15h00). ");
INSERT INTO myk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bani caŋa ki bi tɔ fɛɛfɛɛ. Wee tuun we ni a Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲahaparaga fàŋa nigbilege kʼi lɔ niŋɛ ke ni, na daa taaya shuun. ");
INSERT INTO myk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A Yesu di sii mujuugbɔɔ wá na: «Na To, nʼa na munaa li kaa le ma keŋɛ ni.» Ba wʼa yee jo wɛ, na xhu. ");
INSERT INTO myk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sɔrɔsii ɲuŋɔfɔɔ we wu bye wà ge, ba wee ya kii keree kii ɲa tapyege ni wɛ, na jo: «Baraga ki taha Kilɛ na! Can na, we ná we kunni, sipyitiimɛ wu bye we.» ");
INSERT INTO myk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sipyii piimu bɛɛri pu bi pinnɛ wà na pu wii ge, ba pee bɛɛri ya kii keree kii ɲa tapyege ni wɛ, a pu ɲahaya di danha fo pu na pu dodoyo kpɔɔn. A pʼi guri na ma deeye ni. ");
INSERT INTO myk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu naɲiinɛɛ pu bɛɛri, ni cèe pii pʼa bi taha wu na na yìri Galile fiige ki ni ge, pee bɛɛri bi yere laraga ni na wii. ");
INSERT INTO myk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lee bi Yawutuu wo kiirikɔɔn kuruŋɔ ki sipya wa ta wà, wee mɛgɛ ɲɛ Yusufu. Wu bi tii wu zɔ wu bɛ dʼa ɲɔ. Arimate shɛn wu bi bye wii, Yawutuu fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kiirikɔɔn kuruŋɔ ki bi jo na bɛ keree kiimu na ge, ni pʼa kiimu pye ge, Yusufu bi ta wu tɔɔgɔ le lee la shishiin ni wɛ. Wu bɛ bi Kilɛ wo saanra ti sigee. ");
INSERT INTO myk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A wee ná wu shɛ Pilate mu na shɛ Yesu nixhugo ki ɲɛɛri wu mu. ");
INSERT INTO myk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A Pilate di sɔɔ. A Yusufu di shɛ Yesu nixhugo ki tirige, na fatɔŋɔ ka migile wu na, na shɛ wu le faŋa ka ni. Kee nidugiyahaŋa ki bye faaya yi ni. Sipya bɛ bi sanha le ɲa ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kee caŋa ki bye Pɔri caŋa, ɲiga na da mugi Yawutuu wo cadɛɛngɛ ke. ");
INSERT INTO myk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cèe pii pu bi taha Yesu na na yìri Galile ni ge, a pee bɛ di gari ni Yusufu ni faŋa ki na, na shɛ Yesu nixhugo ki sinniŋɛgana li wii. ");
INSERT INTO myk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lee kadugo na a pee cèe pʼi ba deeye ni, na ba nudanga yaŋmuyɔ ni nudanga sìnmɛ yàa Yesu nixhugo ki dire kaa na. Ga, a pʼi ŋmɔ cadɛɛngɛ ki ni, na bɛ ni Kilɛ wo ɲɔmɛɛ li ni. ");
INSERT INTO myk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dimazhi wu ɲisɔɔgbɔhɔ ki na, a cèe pʼi yiri. Pu bi nudanga sìnmɛ pemu yàa ge, a pʼi gari faŋa ki na ni pee ni. Kee caŋa ki bye Dimazhi caŋa. ");
INSERT INTO myk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba pʼa nɔ wà wɛ, kageegbɔhɔ ke ki bi taga faŋa ki ɲɔ tɔ ge, a pʼi kee ta kʼa gologolo laha faŋa ki ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A pʼi jé faŋa ki ni, ga pu ya ta Kafɔɔ Yesu nixhugo ki ɲa wɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A pu hakilee di wuregi. Na pu niyereye yaha, a namaa shuun fadeviire wuu pii di foro pu mu na pu fo. ");
INSERT INTO myk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A cèe pʼi fya, na pu ɲuyɔ sogi sogi. A pee namaa shuun wu pu pye: «Sipya we wu ɲɛ ɲìi na ge, ɲaha na yee dʼa pa wee shaa xuu tɛ ni wɛ? ");
INSERT INTO myk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wu wa naha nige wɛ. Wʼa ɲɛ na foro xu ni. Ye wu bi yu yi mu na wu yaha Galile fiige ki ni ge, yi yi funyɔ kɔn yee na. ");
INSERT INTO myk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wu bi yee pye na: ‹Li waha lʼi waha, Sipya Ja na ba jé kakuubyii keŋɛ ni, pʼa wu kori tige na. Wu caxhugo caŋa taanri wogo wʼa ɲɛ.›» ");
INSERT INTO myk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ba pʼa yee logo wɛ, a pu funŋɔ di ba do Yesu wo nijoyo yi na. ");
INSERT INTO myk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wee tuun wu ni a pʼi ba na yìri faŋa ki na. Na ba yee bɛɛri ɲaha jo tudunmɔɔ kɛ ni nigin wu mu, ni kalaapiire tisara bɛɛri. ");
INSERT INTO myk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cèe pii pʼa yìri faŋa ki na ge, pee bye: Magadala shɛɛn Mariyama, ni Zhanɛ, ni Yakuba nu Mariyama. Cèe piimu bɛ pu bye ni pu ni ge, a pee cèe pu bɛ di yee ninuyɔ jo tudunmɔɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ga, a pʼi cèe pu jomɔ pu ta ba giraya ɲɛ wɛ, na bye pu ya dà pu na wɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ga lee bɛ na, a Pyɛɛri kunni di yìri na baa kari faŋa ki na. Na shɛ nɔ, na jaari wii ki ni, na faviire ti yɛ ɲa wà. A lee di wu fo fo xuuni. A wu guri na ma puga. ");
INSERT INTO myk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lee kadugo na a wu kalaapiire shuun wa di ganha na gaaŋi kee caŋa kiyɛ pyaa kulo la ni. Lee mɛgɛ ɲɛ na Emayusi. Lee kulo le ni Zheruzalɛmu tɛ wu bye kiloo kɛ ni nigin shishiin. ");
INSERT INTO myk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Keree kiimu bɛɛri kʼa pye Zheruzalɛmu ni wee tuun wu ni ge, a pʼi ganha na kee paari puyɛ mu. ");
INSERT INTO myk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na pu yaha pu na yɔgɔ na yee ɲaha yu puyɛ mu, a Yesu yɛ pyaa di fulo pu na, na binnɛ na gaaŋi ni pu ni. ");
INSERT INTO myk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A pu kunni di ganha na wu ɲaa, ga na bye kanna kaa la lʼa pu pye pu ya wu cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A Yesu di pu pye: «Yee di wa ɲaari na keree kiikɛ paari yiyɛ mu wɛ?» Ba Yesu ya yee jo wɛ, a pʼi yere. Lee bi pu ɲahaya ta yʼa tanha xuuni. ");
INSERT INTO myk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wa mɛgɛ ki bye pu ni na Kilopasi, a wee di jo: «Ni mu yɛ nigin bɛ wɛ, kaa le lʼa sii pye Zheruzalɛmu ni kii cabyaa kii na ge; wa shishiin wa Zheruzalɛmu ni ni wu ya li cɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A Yesu di pu pye: «Lee ɲɛ lekɛ wɛ?» A pʼi wu ɲɔ shɔ na: «Kaa le lʼa pye Nazarɛti shɛɛn Yesu na ge gɛ! Yesu bi bye Kilɛ tudunmɔ baraga wo. Fanha bye wu kapyegee ni wu ɲɔ jomɔ ni Kilɛ ɲaha tàan ni sipyii pu bɛ ɲaha tàan. ");
INSERT INTO myk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wèe wo saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni wèe wo ɲahagbaa fɛɛ pʼa wu le shi watii keŋɛ ni, kɔnhɔ wu xhu. A pee di wu kori tige na. ");
INSERT INTO myk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wèe bi kanha na daa jo Kilɛ wʼa wu tun na pa wu ba Izirayɛli shɛɛn ɲuŋɔ wolo, ga wu nixhugo na, niɲaa ɲɛ wu caŋa taanri wogo. ");
INSERT INTO myk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lee bɛ na, cèe pii pu wa wèe ni ge, pii ya jomɔ pa jo wèe mu pemu ya wèe ɲaha wɔ fo xuuni ge. Pee ya soo shɛ ɲisɔɔgɔ ke na faŋa ki na. ");
INSERT INTO myk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Na ba jo na pee ya shɛ gbo wu ɲa faŋa ki ni wɛ, ga na mɛlɛkɛɛ pii ɲa wà. A pee mɛlɛkɛɛ pʼi pee pye na Yesu wa ɲìi na. ");
INSERT INTO myk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wèe kaafɛɛ pii bɛ ya shɛ faŋa ki na, na shɛ li ta ba cèe pʼa pa yi jo wèe mu wɛ, ga pu ya wuyɛ pyaa ɲa wɛ.» ");
INSERT INTO myk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wee tuun wu ni a Yesu di pu pye: «Yee kunni ɲɛ fungɔnyɔ baa fɛɛ. Kilɛ tudunmɔɔ pʼa yemu bɛɛri jo ge, ali yee ya daa yee bɛ na tɔvuyo na wɛ! ");
INSERT INTO myk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Go Shɔvɔɔ wu bi sii yaa na kanha le kanhagana le na Kilɛ di na pa wu nɔɔrɔ wu kan wu mu!» ");
INSERT INTO myk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lee kadugo na le lʼa ka wu shizhaa na ge, a wu yee bɛɛri paari pu mu. A wu yi ɲɔ kɔn Kilɛ tudunmɔɔ Musa wo nijoyo yi na, fo na shɛ nɔ Kilɛ tudunmɔɔ pusamaa bɛɛri wo nijoyo yi na. ");
INSERT INTO myk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kulo lemu ni kalaapiire tʼa se ge, a pʼi shɛ dɛɛŋɛ lee kulo li tajege ki na. A Yesu di wuyɛ pye kanna ɲahagbaa na wʼa doroo na se. ");
INSERT INTO myk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ga, a pʼi wu ɲɛɛri na: «Pinnɛ ni wù ni, bani caŋa kʼa xɔ, jɛri tapyege ni piige kʼa da wɔ.» A wu sɔɔ pu mu, a pʼi binnɛ jé kanha ki ni. ");
INSERT INTO myk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba liduun wʼa nɔ wɛ, a pʼi diin na da da li. A Yesu di buuri wu lɔ na baraga taha Kilɛ na, na wu kɛgi kɛgi na kan pu mu. ");
INSERT INTO myk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba Yesu ya buuri wu kan pu mu wɛ, a pu ɲìi di na pahala wu na. A pʼi na li cɛ na Yesu yɛ pyaa ki ɲɛ kii. Ga taapile ni, a pʼi wii fɔ wu ni. ");
INSERT INTO myk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A pʼi ganha na puyɛ pyi na: «Wʼa jo ni wèe ni, na ɲɔ kɔn na Kitabuu pu jomɔ pu ɲaha yu wèe mu koo li na tuun wemu ni ge, ta xɔnhɔrɔ na wèe funyɔ di bi taan?» ");
INSERT INTO myk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Taapile ni a pʼi guri na gaaŋi Zheruzalɛmu ni. Ba pʼa shɛ nɔ wà wɛ, na tudunmɔɔ kɛ ni nigin wu ni kalaapiire ti bɛɛri ta pʼa pinnɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A pee di shuun wu pye: «Can na, Kafɔɔ wʼa ɲɛ foro xu ni! Wʼa wuyɛ shɛ Simɔ na!» ");
INSERT INTO myk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Le lʼa pye pee shuun we bɛ na koo li na ge, a pu bɛ di guri na yee bɛɛri paari pu mu, fo na shɛ nɔ cɛgana lekɛ na pʼa Yesu ta cɛ buuri wu kɛgiduun wu ni ge. ");
INSERT INTO myk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na pu yaha pu na pee jomɔ pu yu, a Yesu di foro yere pu niŋɛ ni na pu pye: «Kilɛ wu ɲaɲiŋɛ kan yi mu!» ");
INSERT INTO myk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A pu jaalaa di yìri, a pʼi sii fya xuuni. Bani pu bi giin na yafugunɔ pee ya ɲa. ");
INSERT INTO myk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A Yesu di pu pye: «Ɲaha na yee dʼa yi hakilee pu yirige le yirigegana le na, na ke fungɔngɔ ke tuugo yaha yiyɛ mu wɛ? ");
INSERT INTO myk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yi na keye yi wii ni na tɔɔyɔ yi ni, nɛyɛ pyaa kʼa sii kii. Yi na wii yʼi ba gbɔn na na bɛ. Bani yafugunɔ ɲɛ ni ceexaara ni kaciiye ni wɛ, ga nɛ kunni di wa ni yi ni.» ");
INSERT INTO myk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ba wʼa yee jo wɛ, na wu keye ni wu tɔɔyɔ yi shɛ pu na. ");
INSERT INTO myk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A kalaapiire ti funyɔ di sii taan xuuni. Ga lʼa pu fo fogana lemu na ge, lee funŋɔ ni pu ya ta dà sanha wɛ. Wee tuun wu ni a Yesu di pu pye: «Yalige yaaga na da naha yee mu ya?» ");
INSERT INTO myk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Fyakaaya di bi bye pu mu, a pʼi kee ka kan wu mu. ");
INSERT INTO myk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A wu ki shɔ na ki xa pu bɛɛri ɲii na. ");
INSERT INTO myk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lee kadugo na a wu pu pye: «Tuun wemu ni nɛ bye ni yee ni ge, go ye nɛ bi jo yee mu. Nɛ bi yee pye jo yemu bɛɛri yʼa ka nɛ shizhaa na Musa wo saliya we, ni Kilɛ tudunmɔɔ pu wo Kitabuu pee, ni Zaburuu Kitabu wu ni ge; jo yee bɛɛri ɲɔ ya yaa na fa.» ");
INSERT INTO myk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wee tuun wu ni a Yesu di pu fungɔnyɔ mugi mu lee mugigana li na, kɔnhɔ pʼi Kilɛ wo Kitabu wu jomɔ pu cɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Lee kadugo na a wu pu pye: «Lʼa ka Kitabu ni na li waha lʼi waha, Shɔvɔɔ wu na ba ganha, na pu na ba wu gbo. Wu cagbogo caŋa taanri wogo, wʼa ɲɛ na foro xu ni. ");
INSERT INTO myk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wee mɛgɛ na le yɛrɛ le ya yaa na jo koŋɔ ke wo shi wu bɛɛri mu, na li ɲɔ kɔn Zheruzalɛmu na na: shi wu bɛɛri ya yaa na yere wu jurumu wu na, na sɔɔ Kilɛ na, kɔnhɔ wu pu jurumu wu yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yee pu wa lee wo sɛɛrɛɛ. ");
INSERT INTO myk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na To Kilɛ wʼa Fɛfɛɛrɛ Munaa lemu wo ɲɔmɛɛ lɔ yi mu ge, nɛ na ba lee tun na pa yi mu. Ga yi tiin Zheruzalɛmu ni fɔlɔ, fo tee sefɛɛrɛ te ba fɛnhɛ tigi yi na na yìri Kilɛ we ni.» ");
INSERT INTO myk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ba wʼa xɔ pee jomɔ pe na wɛ, na gari ni wu kalaapiire ti ni Bɛtani kulo li shizhaa. Ba pʼa nɔ wà wɛ, a wu wu keye tagi pu ɲuɲɔ na, na ganha na duba pyi pu mu. ");
INSERT INTO myk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na Yesu yaha wu na wee duba wu pyi, a wu yìri laha pu tàan, na dugi kari fugba we ni. ");
INSERT INTO myk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lee di kalaapiire ti ta tʼa nuguro sin, na wu pɛlɛ. Ba pʼa wu pɛlɛ xɔ mu wɛ, a pu fundanga wuu di guri na pa Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A pʼi bye tuun bɛɛri ni pʼa shɛ puyɛ pinnɛ Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na Kilɛ pɛlɛ.");
INSERT INTO myk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fo taashiinɛ li ni, na ta koŋɔ sanha yàa wɛ, wemu wʼa yiri Jomɔ ge, wee ya bye na xɔ. Pee Jomɔ pu ni Kilɛ wu bye shiizhan, pee Jomɔ pu ɲɛ Kilɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Fo taashiinɛ ni pee Jomɔ pe ni Kilɛ wu bye shiizhan. ");
INSERT INTO myk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pee gbɔɔrɔ ni Kilɛ ya yaŋmuyɔ yi bɛɛri yàa. Yaaga yaaga kʼa yàa ge, kee ka shishiin ya yàa pee kadugo na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pee ni ɲìi sicuumɔ ya daa. Pee ɲìi sicuumɔ pu bi kpɛɛngɛ yeege sipyii pu mu. ");
INSERT INTO myk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kee kpɛɛngɛ kʼa ɲí nibiige ki ni sipyii pu mu, ga nibiige ki sipyii pʼi ya ta sɔɔ ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A Kilɛ di ná wa tun, wee mɛgɛ ki bye na Yohana. ");
INSERT INTO myk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wee ya pa bye sɛɛri na kpɛɛngɛ ki kaa yu sipyii pu mu, kɔnhɔ pu bɛɛri di dà kee kpɛɛngɛ ki na, wee baraga ni. ");
INSERT INTO myk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Weeyɛ pyaa bi ta pye kpɛɛngɛ ki wɛ, ga wu kapana ɲuŋɔ kʼa pye na kpɛɛngɛ ki kaa yu sipyii pu mu, ");
INSERT INTO myk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pee jomɔ pʼa bye kpɛɛngɛ can can wogo. Pee ya pa koŋɔ na, na ba ganha na kpɛɛngɛ yeege sipyii pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pee bye koŋɔ na, pee shiin gbɔɔrɔ ni koŋɔ ya yàa. Ga koŋɔ sipyii di ya ta sɔɔ pee na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pʼa tigi puyɛ pyaa fiige shɛɛn mu, ga pee di ya ta sɔɔ pu na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ga lee bɛ na, shɛɛn nigin nigin ya sɔɔ pu na, na dà pu na; a Jomɔ pʼi fanha kan pee mu na pu pye Kilɛ nagoo. ");
INSERT INTO myk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pee ya ta se sipyii segana na wɛ, pʼi ya se sipyii wo daan na mu funŋɔ ni wɛ, pʼi ya se ná bɛ wo ɲidaan funŋɔ ni wɛ. Ga Kilɛ yɛ pyaa wo ɲidaan funŋɔ ni pʼa pye wu nagoo. ");
INSERT INTO myk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ayiwa, pee jomɔ pe, pʼa ɲɛri sipya, na ba diin wèe niŋɛ ni, a wèe di pu nɔɔrɔ wu wii, Ja nigin pe wu wʼa foro Kilɛ ni ge, na wu ta wee wo. Wee wʼa sii fɛrɛmɛ ni can wu Kafɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wee kaa Yohana bi yu, na mujuu waa na sipyiire ti pyi: «Ná wemu kaa nɛ jo, jo wʼa ma nɛ kadugo ge, wee bye nɛ ɲaha na; bani yani nɛ wu se ge, wee bye na xɔ. Wee wu ɲɛ we.» ");
INSERT INTO myk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wèe bɛɛri ya wù tahaa ta wu fɛrɛmɛ nigbɔ pu ni, na duba bɛ ta na fara duba na. ");
INSERT INTO myk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kilɛ tudunmɔɔ Musa baraga ni Kilɛ ya wu saliya ɲɔmɛhɛɛ ki kan wèe mu. Ga Yesu Kirisa baraga ni wèe ya fɛrɛmɛ ni can cɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sipya wa shishiin sanha Kilɛ ɲa bada wɛ. Ja nigin pe wu wu ɲɛ Kilɛ, na ɲɛ ni wu To Kilɛ ni shiizhan ge, wee wʼa wèe pye wèe ya To Kilɛ wu cɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pe pʼa pye Yohana Batizelipye wo Kilɛ jomɔ pe, tuun wemu ni Yawutuu ɲuŋɔfɛɛ pʼa pa saraya ɲaha shɔɔnrivɔɔ ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki kapyebyii pu tun wu mu ge. Tudunmɔɔ pʼa yìri Zheruzalɛmu ni na pa wu yíri na ba wu yege na: «Jɔgɔ mu di ɲɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana ya ta li pye ŋmɔhɔrɔ kaa wɛ, na yi tii jo pu mu na: «Nɛ ɲɛ Shɔvɔɔ wu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","A pʼi wu yege na: «Wee tuun wu ni mu di ɲɛ jɔgɔ wɛ? Kilɛ tudunmɔɔ Eli gɛ?» A wu jo: «Nɛ ɲɛ Eli wɛ.» A pʼi wu pye sanha na: «Pʼa Kilɛ tudunmɔ wemu kaa jo ge, mu wu wa gɛ?» A wu jo: «Ahayi.» ");
INSERT INTO myk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wee tuun wu ni a pʼi jo: «Mu dʼa sii jɔgɔ wɛ? Ya jo wù mu gɛ, kɔnhɔ wù bɛ di shɛ yee jo wù tunvɛɛ pu mu. Jɔgɔ yɛ pyaa mu dʼa sii wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Yohana di pu ɲɔ shɔ ni Kilɛ tudunmɔɔ Ezayi wo jomɔ pa ni na: «Sipya wa wʼa mujuu waa sipoŋɔ ki ni na: ‹Yi Kafɔɔ wu koo li tii!› Nɛ wu ɲɛ wee sipya we.» ");
INSERT INTO myk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Piimu pʼa bi tun Yohana mu ge, Farizhɛɛn pii bye pee ni. ");
INSERT INTO myk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A pee di wu yege sanha na: «Mu bye mu di ɲɛ Shɔvɔɔ wu wɛ, mu di ɲɛ Eli wɛ, Kilɛ tudunmɔ wemu kaa pʼa jo ge, mu di ɲɛ wee bɛ wɛ, wee tuun wu ni ɲaha na mu di batizeli pyi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A Yohana di pu ɲɔ shɔ na: «Nɛ wi ge, nɛ sipyii batizeni lɔhɔ yɛ ni, ga sipya watii wa wà yee niŋɛ ni na xɔ, yee di ya wee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wee wʼa ma nɛ kadugo, nɛ yaa ni wu tanhaya mɛɛrɛ bɛ zanha ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kii keree kii ya pye kulo lemu ni ge, lee mɛgɛ ɲɛ Bɛtani. Lee wa Zhurudɛn Gba wu Kilɛ-nɔhɔ ki na. Wee xuu wu ni Yohana bi sipyii pu batizeni. ");
INSERT INTO myk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kee caŋa ki ɲimuguro ti na, a Yohana di Yesu ɲa wu na ma wu mu, na jo: «Kilɛ wo Dubyapige ke ki da ba koŋɔ ki jurumu wu lɔ laha wà ge, kee ki wa mɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ná wemu kaa nɛ jo yee mu ge, jo: ‹We wʼa ma nɛ kadugo ge, wee bye wà fo taashiinɛ li ni. Wʼa pye wà na ta nɛ sanha se wɛ.› Wee wu ɲɛ we. ");
INSERT INTO myk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɛ kunni bi sanha wu cɛ wɛ, ga nɛ pa sipyii pu batizeni lɔhɔ ni, kɔnhɔ di wu shɛ Izirayɛli sipyii pu na.» ");
INSERT INTO myk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana ya Yesu kaa jo sipyii pu mu na: «Nɛ Kilɛ Munaa ɲa lʼa tigi na yìri fugba we ni, na ba diin wu na ba gbegbe shazhira ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nɛyɛ pyaa bi ta wu cɛ wɛ, ga Kilɛ wemu wʼa nɛ tun na nɛ wʼa sipyii pu batizeni lɔhɔ ki ni ge, wee ya jo na: ‹Ma ba Kilɛ Munaa ɲa lʼa tigi na pa diin ná wemu na, wee wʼa da ba batizeli wu pyi Fɛfɛɛrɛ Munaa ni.› ");
INSERT INTO myk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A nɛ shiin di li ɲa mu, na bye li sɛɛri, na pee jomɔ pe yu na Kilɛ Ja wu ɲɛ wee ná we.» ");
INSERT INTO myk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kee caŋa ki ɲimuguro ti na, Yohana ni wu kalaapiire shuun wa bi yere wà sanha. ");
INSERT INTO myk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","A wu Yesu ɲa wu na doroo, na ganha na wu wii, na ba jo: «Kilɛ wo Dubyapige ki ke!» ");
INSERT INTO myk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ba Yohana wo kalaapiire shuun wʼa wee kafila wu logo wɛ, na daha Yesu fɛni. ");
INSERT INTO myk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Yesu di ŋmahana ɲɛri, na pee ta pʼa taha wu fɛni, na pee yege na: «Ɲaha yee di zhaa wɛ?» A pee di wu pye: «Rabi, (Lee kɔri ɲɛ ‹Karamɔgɔgbɔ›.) mii mu dʼa tigi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A wu pu ɲɔ shɔ na: «Yi pa ki wii.» A pʼi binnɛ kari ni wu ni, na shɛ wu tatigiŋɛ ki ɲa. Lee bi caŋa ki ta kʼa tigi na nɔ lɛɛrɛɛ kɛ ni gbaara wu na (16h00), a pʼi caŋa ki saŋa xɔ wà. ");
INSERT INTO myk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kalaapiire shuun wemu wʼa Yohana kafila wu logo na daha Yesu fɛni ge, wa mɛgɛ bye Andire, wee ɲɛ Simɔ Pyɛɛri cuun. ");
INSERT INTO myk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A Andire di fɛnhɛ shɛ wu ɲahafɔɔ Simɔ yíri na shɛ wu pye: «Wèe ya Kirisa wu ɲa,» (lee kɔri ɲɛ «Kilɛ ya wemu shɔɔnri lɔ ge.») ");
INSERT INTO myk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lee kadugo na a Andire di gari ni Simɔ ni Yesu yíri. A Yesu di Simɔ wii na wu pye: «Yohana ja Simɔ wu ɲɛ mu. Mɛgɛ katii ki da le nimɛ mu na, kee ɲɛ Sefasi.» (Kee kɔri ɲɛ «Faakagereŋɛ.») ");
INSERT INTO myk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kee caŋa ki ɲimuguro ti na, a Yesu di jo na wee da zhɛ Galile fiige ki ni. A wu nigariwo di jíri Filipe na na wu pye: «Taha na fɛni.» ");
INSERT INTO myk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe bi bye Bɛtisayida kulo li shɛn wa, lee kulo le ninunɔ shɛɛn pu bye Andire ni Pyɛɛri bɛ. ");
INSERT INTO myk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lee kadugo na a Filipe di ba Nataɲɛli ɲa na wu pye: «Kilɛ tudunmɔɔ Musa ya sipya wemu kaa jo Kilɛ wo saliya Kitabu wu ni, a Kilɛ tudunmɔɔ pusamaa bɛ di wu kaa jo pu wo Kitabuu pu ni ge, wèe ya wee ɲa. Wee ɲɛ Yusufu ja Yesu na yìri Nazarɛti kulo li ni.» ");
INSERT INTO myk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A Nataɲɛli di wu pye: «Dii yasaaŋa di da já voro Nazarɛti ni wɛ?» A Filipe di wu ɲɔ shɔ na: «Pa wu wii.» ");
INSERT INTO myk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ba Yesu ya Nataɲɛli nibawo ɲa tuun wemu ni wɛ, na jo: «Izirayɛli see sipya wa we, naŋmahara ɲɛ wemu zɔ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A Nataɲɛli di wu yege na: «Mii mu dʼa nɛ ta cɛ wɛ?» A Yesu di wu ɲɔ shɔ na: «Nɛ ɲii bye mu ni na mu yaha nitoodige ki tàan, na ta Filipe sanha mu yiri wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","A Nataɲɛli di gaala, na jo: «Wù Karamɔgɔ, Kilɛ Ja mu ya sii, Izirayɛli wo saan we!» ");
INSERT INTO myk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","A Yesu di wu pye: «Nɛ mu pye jo nɛ ɲii bye mu ni na mu yaha nitoodige ki tàan ge, lee yɛ lʼa mu pye mu ya dà nɛ na ya? Ma na ba kagbɔhɔɔ kii bɛ ɲa kiimu kʼa ye le na ge!» ");
INSERT INTO myk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A wu jo sanha na: «Can can na, nʼa da yi jo yi mu jo yi na ba fugba wu ɲɔ ɲa kʼa mugi, na Kilɛ wo mɛlɛkɛɛ pii ɲaa pu na duri na diri Sipya Ja wu na.» ");
INSERT INTO myk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lee kadugo na, caŋa taanri wogo ki na, cekaanra bi bye kulo la ni, lee mɛgɛ ɲɛ na Kana. Lee bye Galile fiige ki kulo la. Yesu nu wu bye tee cekaanra ti ni. ");
INSERT INTO myk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pʼa bi Yesu ni wu kalaapiire ti bɛ yiri tee cekaanra ti ni. ");
INSERT INTO myk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ba duvɛn wʼa pa guuŋɔ wɛ, a Yesu nu wu fulo wu na na wu pye: «Pu duvɛn wʼa kuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ga, a Yesu di wu nu wu pye: «Nufɔɔ we, ma ganha bu da le yaha li ma cɔnri wɛ, nɛ wo tuun wʼa sanha nɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A Yesu nu wu kapyebyii pu pye: «Wu ba yemu bɛɛri jo yi mu, yi lee pye.» ");
INSERT INTO myk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yawutuu pu bi pɛyɛ gbaara wa tɛ na wolo faaya yi ni. Yee wo lɔhɔ pu bi gori na daga na puyɛ jii na bɛ ni pu fɛfɛɛrɛ kalɛgɛɛ ki ni. Lɔhɔ litirilee xhuu nigin (100) shishiin bi jin pɛgɛ ka bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A Yesu di kapyebyii pu pye: «Yi ye pɛyɛ ye ɲi ni lɔhɔ ni.» A pʼi yi ɲi fo yi ɲɔyɔ ye na. ");
INSERT INTO myk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A wu guri pu pye: «Yi ka ko shɛ gan yalige ki ɲaha shɔɔnrivɔɔ wu mu.» A pee di ka ko kari. ");
INSERT INTO myk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lɔhɔ ke kʼa ɲɛri na pye duvɛn wu ge, a yalige ki ɲaha shɔɔnrivɔɔ wu kee ɲɛhɛ. Ga wee bi wee duvɛn wu taforogo cɛ wɛ. Ga kapyebyii piimu pʼa bi lɔhɔ ki ko ge, pee kunni bi wu taforogo cɛ. A yalige ki ɲaha shɔɔnrivɔɔ wu cenabun poo wu yiri, ");
INSERT INTO myk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na wu pye: «Sipyii bɛɛri ma fɛnhɛ duvɛn nidan wu loolo. Pu bu wee niɲɛhɛmɛ gba, wemu ya taan xuuni wɛ, pʼa na wee loolo. Ga, a mu kunni di dɛrɛ ma wo duvɛn nidan wu yaha fo nimɛ.» ");
INSERT INTO myk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Le lʼa pye Yesu ɲaha shɛshɛɛrɛ kakanhaŋaa ki bɛɛri nizhiinɛ. Lee ya pye Kana ni, Galile fiige ki ni. Yesu ya wu sefɛɛrɛ shɛ. Ba kalaapiire tʼa lee ɲa wɛ, na dà wu na. ");
INSERT INTO myk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lee nibyexhoo na, a Yesu ni wu nu, ni wu ceboronamaa, ni wu kalaapiire tʼi gari Kapɛrinɔmɔ kulo li ni. A pʼi cabyaa kii pye wà. ");
INSERT INTO myk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ba Yawutuu Ɲuwuuro ti wo Kalenɛ lʼa tɛɛŋɛ wɛ, a Yesu di gari Zheruzalɛmu ni, ");
INSERT INTO myk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","na shɛ sipyii pii ta Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni, pu na niiyɛ, ni dubyaa, ni gbegbe shazhira pɛrɛɛ saraya wolovɛɛ pu mu. Wari faavɛɛ pu bɛ dʼa tiin wà pu tabalaa tàan, na saraya wolovɛɛ pu wari wu fari pu mu. ");
INSERT INTO myk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ba wʼa shɛ pu ta mu wɛ, na shɛ mɛɛrɛ pye susɔ, na pee bɛɛri kɔri yeege Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, ni pu niiyɛ ni pu dubyaa ni, na wari faavɛɛ pu wo tabalaa pu ɲɛri buri, na pu wari wu wo ɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A wu gbegbe shazhɛɛrɛ pɛrɛvɛɛ pu pye: «Yi te lɔ laha naha! Yi ganha da na To wu puga ki pye jagi tapyege wɛ!» ");
INSERT INTO myk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ba Yesu ya lee pye wɛ, a wu kalaapiire ti funŋɔ di do Kitabu jomɔ pa na na: «Mu puga ki kaa ya dan nɛ ni tɛhɛnɛ baa, nʼa na funŋɔ shaa ni ki ni xuuni.» ");
INSERT INTO myk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lee kadugo na a Yawutuu ɲuŋɔfɛɛ pʼi wu pye: «Ɲaha shɛshɛɛrɛ tekɛ mu di da já bye tee di li shɛ na kaɲii wa mu mu li bye na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A Yesu di pu ɲɔ shɔ na: «Yi ke Kilɛ-pɛɛŋɛ pugbɔhɔ ke ja, di ki yereŋɛ cabyaa taanri funŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A pʼi wu pye: «Go yee kɛlɛɛ shishɛɛrɛ ni gbaara (46) pʼa pye na ke Kilɛ-pɛɛŋɛ pugbɔhɔ ke yereŋɛ dɛ! Wee tuun wu ni mu di mayɛ wii jɔgɔ mu wu já kee yereŋɛvonɔ yereŋɛ cabyaa taanri funŋɔ ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ga Kilɛ-pɛɛŋɛ pugbɔhɔ kemu kaa Yesu bi yu ge, kee bye wuyɛ pyaa ceepuuro. ");
INSERT INTO myk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ba Yesu ya pa ɲɛ na foro xu ni wɛ, a wu kalaapiire ti funyɔ di do na wʼa yi jo. A pʼi dà Kilɛ Kafila wu na, Yesu bi yemu bɛɛri jo ge, na dà yee bɛ na. ");
INSERT INTO myk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na Yesu yaha Zheruzalɛmu ni Yawutuu Ɲuwuuro ti wo Kalenɛ li tuun wu ni, a sipyiɲɛhɛmɛɛ di wu ɲaha shɛshɛɛrɛ kakanhaŋaa ki ɲa na dà wu na. ");
INSERT INTO myk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ga Yesu ya ta wuyɛ yaha pu keŋɛ na wɛ, bani wʼa bi pu fungɔnyɔ keree bɛɛri cɛ. ");
INSERT INTO myk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wu mago bye li na nago sipya wa wu na sipya wa keree jo wu mu wɛ, bani wu bi sipyii bɛɛri fungɔnyɔ keree cɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farizhɛn wa bye wà, wu mɛgɛ bye Nikodɛmu. Yawutuu pu ɲuŋɔfɔɔ wa wu bye wii. ");
INSERT INTO myk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A wee di ba shɛ Yesu yíri caŋa ka piige ni, na wu pye: «Wù Karamɔgɔ, ɲaha shɛshɛɛrɛ kakanhaŋaa kii mu ya sii na byi ge, sipya wa shishiin da já da ki pyi ni Kilɛ ɲɛ ni ma ni wɛ. Lee wuu na wèe ya li cɛ, jo Kilɛ wʼa mu tun mu wu pa wèe kalaa.» ");
INSERT INTO myk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Yesu di wu pye: «Can can na, nʼa da yi jo ma mu, sipya wemu ya sevonɔ se wɛ, weefɔɔ da já jé Kilɛ wo saanra ti ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A Nikodɛmu di Yesu pye: «Sipya wemu ya lɛ xɔ ge, dii weefɔɔ di da já sevonɔ se wɛ? Wu kunni wa da já guri jé wu nu funŋɔ ni pu kuri se wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A Yesu di wu pye: «Sipya wemu ya se lɔhɔ ni Fɛfɛɛrɛ Munaa gbɔɔrɔ ni wɛ, weefɔɔ da já jé Kilɛ wo saanra ti ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bani sipyii ya piimu se ge, pee ɲɛ ceepuuro wuu. Piimu pʼa se Kilɛ wo Fɛfɛɛrɛ Munaa li gbɔɔrɔ ni ge, pee ya ɲaari lee wo ɲaarigana na. ");
INSERT INTO myk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nɛ na ma pye, li waha lʼi waha yʼa yaa na sevonɔ se, lee ganha bu da ma fo wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ki ɲidaan tashɛgɛ ni kafɛɛgɛ ya se mʼa ki tunmɔ logo, ga ma di wa da ki taforogo ni ki tashɛgɛ bɛ cɛ wɛ. Sipya wemu bɛɛri wʼa se Kilɛ Munaa li gbɔɔrɔ ni ge, mu li ɲɛ weefɔɔ shizhaa na.» ");
INSERT INTO myk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ayiwa, a Nikodɛmu di Yesu pye: «Kii keree kii bɛɛri di da já bye pyegana lekɛ na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Yesu di wu pye: «Mu na ɲɛ Izirayɛli karamɔgɔgbɔ, lee bɛ na mu di ya kii keree kii ɲaha cɛ-ɛ ya? ");
INSERT INTO myk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Can can na, nʼa da yi jo ma mu, le wèe ya cɛ ge, lee wèe ya yu; le wèe ya ɲa ge, lee wo sɛɛrɛɛ bɛ wèe ɲɛ. Ga yee wa giin yʼi sɔɔ wèe wo sɛɛri keree ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɛ na ɲiŋɛ ke wo keree ɲaha yu yee mu, yee di ya daa kee na wɛ, nɛ bu fugba we wo keree jo yee mu, yee na bye dii na dà kee na wɛ? ");
INSERT INTO myk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wa shishiin wa sanha dugi ɲa fugba we ni wɛ, fo Sipya Ja wu yɛ, wee wemu wʼa yìri fugba wu ni na tigi ge. ");
INSERT INTO myk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kilɛ tudunmɔɔ Musa wo tuun wu ni, na wu yaha sipoŋɔ ki ni, wʼa tɔɔrɔ daɲaa yàa na pye wɔ, na wu yirige suri tinnɛ la ni sipyii pu niŋɛ ni. Yirigegana lemu na wʼa wɔ wu yirige ge, li waha lʼi waha, mu Sipya Ja wu bɛ ya yàa na pa yirige lee yirigegana li na, ");
INSERT INTO myk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kɔnhɔ sipyaa sipya wʼa dà wu na ge, wee di ɲìi sicuumɔ nixhɔbaama ta.» ");
INSERT INTO myk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bani koŋɔ ya taan Kilɛ mu tɛhɛnɛ baa, fo wʼa sɔɔ na wu Ja nigin pe wu kan na pye saraga, kɔnhɔ sipyaa sipya wʼa dà wu na ge, wee ganha bu gyɛɛgi wɛ, ga wu ɲìi sicuumɔ nixhɔbaama ta. ");
INSERT INTO myk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kilɛ ya ta wu Ja wu tun na pa koŋɔ na, kɔnhɔ wu ba kiiri kɔn sipyii na wɛ, ga wʼa wu tun na pa, kɔnhɔ koŋɔ sipyii di shɔ wu baraga ni. ");
INSERT INTO myk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sipya wemu bu dà wu na, Kilɛ da ga ba kiiri kɔn weefɔɔ na wɛ. Ga wemu bu bye wu ya dà wu na wɛ, kiiri ya kɔn xɔ weefɔɔ na. Bani Ja nigin wemu wʼa foro Kilɛ ni ge, wu ya dà wee na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wee kiiri wu kakɔɔn le: Kilɛ wo kpɛɛngɛ kʼa pa koŋɔ na, ga, a sipyii jurumu wʼi pu pye pʼa piige pɔrɔŋɔ kee kpɛɛngɛ ki na. ");
INSERT INTO myk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bani sipya wemu wʼa kuumɔ pyi ge, Kilɛ wo kpɛɛngɛ ki ya dan wee ni wɛ. Wu ya sɔɔ bɛ wu foro kee kpɛɛngɛ ki na wɛ. Bani weefɔɔ ma fyagi, kɔnhɔ sipyii ganha bu wu kakuuyo cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ga sipya wemu wʼa can wu koo ɲaari ge, kpɛɛngɛ na weefɔɔ ma wu keree pyi, kɔnhɔ sipyii bɛɛri di ki ɲa, pʼi li cɛ na wee ya Kilɛ koo li ɲaari. ");
INSERT INTO myk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lee kadugo na a Yesu ni wu kalaapiire tʼi foro Zheruzalɛmu ni na kari Zhude fiige ki xuu wa bɛtii ni. A wu tuun wa pye wà ni pu ni na sipyiire ti batizeni. ");
INSERT INTO myk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lee bi Yohana bɛ ta wu na sipyii pii batizeni xuu wa ni wee mɛgɛ ɲɛ Enɔ, wee xuu wu ɲɛ Salimu kulo li kabanugo. Bani gba lɔhɔ niɲɛhɛŋɛ ki bye wee xuu wu ni. Sipyiire ti bi se wu yíri na wu pu batize. ");
INSERT INTO myk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lee ya pye na ta Yohana sanha le kaso wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Caŋa ka, nakaara ya jé Yohana wo kalaapiire ta, ni Yawutu wa tɛ ni, fɛfɛɛrɛ kalɛgɛɛ ki shizhaa na Yawutuu pu kabaŋa na. ");
INSERT INTO myk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tee nakaara ti wuu na a Yohana wo kalaapiire tʼi shɛ wu pye: «Wù Karamɔgɔ, ma ni ná wemu wu bye Zhurudɛn Gba wu kadugo ge, ni mu ya wu kaa jo ge, li wii wee ya sipyii batizeni nimɛ. Sipyii pu bɛɛri di se wee yíri.» ");
INSERT INTO myk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A Yohana di pu ɲɔ shɔ na: «Kilɛ ya lemu kan sipya wemu mu wɛ, ta wu na já lee ta? ");
INSERT INTO myk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yeeyɛ pyaa wa li fiin na nɛ yee pye jo Kilɛ ya Shɔvɔɔ wemu tun ge, wee wa nɛ wɛ, ga Kilɛ ya nɛ tun na pa wu ɲaha na yɛ.» ");
INSERT INTO myk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lee kadugo na a Yohana di talenɛ la jo na: «Cenabun poo wo wu ɲɛ wu cenabun. Cenabun poo wu naɲii wu kunni niyerege yɛ ki ma bye wu tàan. Wu bu cenabun poo wu mujuu logo, wʼa fundanga ta xuuni cenabun poo wu mujuu li wuu na. Kee fundanga ki tuugo ki ɲɛ nɛ wogo ke. Kee fundanga kʼa pɛlɛ fo na nɔ ki tɛhɛnɛ na. ");
INSERT INTO myk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Li waha lʼi waha, la ya yaa na faraa wee wo pɛɛŋɛ ki na nimɛ, la di da foro nɛ wo pɛɛŋɛ ki ni.» ");
INSERT INTO myk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A Yohana di jo sanha na: «Wemu wʼa foro Kilɛ ni ge, wee wu ɲɛ sipyii pu bɛɛri ɲuŋɔ ni. Ga wemu wʼa foro ɲiŋɛ ni ge, wee ɲɛ nɔhɔdaan wo, ɲiŋɛ keree wee ya yu. Wemu wʼa pa na yìri fugba wu ni ge, wee wu ɲɛ pu bɛɛri ɲuŋɔfɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wʼa yemu ɲa na yemu logo ge, yee wʼa yu. Ga wa shishiin ya ta sɔɔ wu nijoyo yi na wɛ, fo shɛɛn nigin nigin yɛ. ");
INSERT INTO myk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sipya wemu bɛɛri wʼa sɔɔ wu nijoyo yi na ge, wee ma li shɛɛ na fiinŋɛ na can ɲɛ Kilɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bani Kilɛ ya wemu tun ge, Kilɛ jomɔ wee ya yu. Kilɛ ya Fɛfɛɛrɛ Munaa taga wee ɲi. ");
INSERT INTO myk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","To Kilɛ Ja wu kaa ya dan wu ni, wʼa sefɛɛrɛ ti le wu keŋɛ ni yaŋmuyɔ bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wemu wʼa dà Kilɛ Ja wu na ge, ɲìi sicuumɔ nixhɔbaama wa weefɔɔ mu. Ga wemu ya dà Kilɛ Ja wu na wɛ, wee da ɲìi sicuumɔ pu ta wɛ. Ga Kilɛ wo loyire li na gori yaha weefɔɔ na.» ");
INSERT INTO myk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ayiwa, Farizhɛɛn pʼa pa yi logo na Yesu ya kalaapiire niɲɛhɛrɛ taa na toro Yohana tàan, na pu batizeni. ");
INSERT INTO myk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ga na ta Yesu yɛ pyaa bi ta na batizeli wu pyi wɛ, fo wu kalaapiire. ");
INSERT INTO myk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tuun wemu ni Yesu ya pa pee jomɔ pu logo ge, a wu foro Zhude fiige ki ni na kari Galile fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wu nigariwo bi yaa na Samari fiige ki ja toro. ");
INSERT INTO myk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A wu shɛ nɔ Samari kulo la ni, lee mɛgɛ ɲɛ na Sikari. Yakuba bi tɛgɛ kemu kan wu ja Yusufu mu fo lʼa mɔ ge, kee kabanugo Sikari bye. ");
INSERT INTO myk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Keeŋɛ ka ki bi bye Yakuba mu wà wee xuu wu ni. Ba Yesu ya kanha ɲara li tàan wɛ, na diin kee keeŋɛ ki ɲɔ na. Lee bi caŋa ki ta ɲiŋɛ niŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A Samari shɛn cee wa di ba wà lɔhɔ takogo ni. A Yesu di wu pye: «Na kan lɔhɔ di gba!» ");
INSERT INTO myk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Lee bi Yesu kalaapiire ti ta tʼa kari kanha ki ni yalige tashɔgɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A wee Samari shɛn cee wu Yesu pye: «Ee, mu wemu wu ɲɛ Yawutu ge, ɲaha na mu dʼa sɔɔ na logbaga ɲɛɛri nɛ mu na ta nɛ ɲɛ Samari shɛn wɛ?» Cee wʼa yee jo bani Yawutuu bi ta sɔɔ kaa la shishiin li pu ni Samari shɛɛn pinnɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Yesu di wu ɲɔ shɔ na: «Cee we, Kilɛ ya yaaga kemu kaan ma ni ge, mu da bi kee cɛ, sipya wemu wʼa logbaga ki ɲɛɛri mu mu ge, na wee bɛ cɛ, muyɛ pyaa ki bi da logbaga ɲɛɛri wu mu. Wu bi da lɔhɔ kan mu mu, kemu kʼa ɲìi sicuumɔ kaan sipyii bɛɛri mu ge.» ");
INSERT INTO myk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A cee wu wu pye: «Karamɔgɔna we, goŋɔ ɲɛ mu mu wɛ, keeŋɛ ki dʼa cogi, mii mu di da kee ɲìi sicuumɔ lɔhɔ ki ta di gan nɛ mu wɛ? ");
INSERT INTO myk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wèe tolɛ Yakuba wʼa ke keeŋɛ ke kan wèe mu. Wuyɛ pyaa, ni wu nagoo, ni wu yapɔrɔyɔ yi bi kee lɔhɔ gbuu. Ayiwa, mu wa giin na mu ya ye wèe tolɛ Yakuba na gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A Yesu di wu ɲɔ shɔ na: «Wa bɛɛri wʼa ke keeŋɛ ke lɔhɔ gba ge, waga na ba weefɔɔ ta sanha. ");
INSERT INTO myk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ga lɔhɔ ke nɛ gaan ge, wa bɛɛri wʼa kee gba ge, waga da ba weefɔɔ ta nige bada wɛ. Bani lɔhɔ ke nʼa da gan weefɔɔ mu ge, kee na ba bye lobulowii na buloo na foro wu funŋɔ ni, na ɲìi sicuumɔ nixhɔbaama kan wu mu.» ");
INSERT INTO myk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A cee wu Yesu pye: «Karamɔgɔna we, kee lɔhɔ ki kan na mu di gba, kɔnhɔ waga ganha bu na ta nige, di ba lɔhɔ shaa naha sanha wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A Yesu di wu pye: «Shɛ ma poo wu yiri pa naha.» ");
INSERT INTO myk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A wu Yesu pye: «Ná wa na mu wɛ.» A Yesu di wu pye: «Can mʼa jo na ná ɲɛ ma mu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bani mʼa jé xɔ namaa kaguro mu. Ná wemu bɛ wʼa jé ma mu nimɛ ge, wee bɛ wa ma poo wɛ. Can mʼa jo.» ");
INSERT INTO myk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A cee wu wu pye: «Karamɔgɔna we, nɛ mu sɛɛri na mu ta Kilɛ tudunmɔ. ");
INSERT INTO myk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wèe Samari shɛɛn, ke faaboboŋɔ ke na wèe sefɛlɛɛ ya Kilɛ pɛlɛ. Ga yee Yawutuu di yu na tapɛɛŋɛ katii wa Kilɛ na ni Zheruzalɛmu bɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A Yesu di wu ɲɔ shɔ na: «Dà na na! Caŋa ka wa ma, yʼa da ba To Kilɛ pɛlɛ ke faaboboŋɔ ke na wɛ, kelee Zheruzalɛmu bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wemu yee Samari shɛɛn ya bɛlɛ ge, yee ya wu cɛ wɛ, ga wemu wèe Yawutuu ya bɛlɛ ge, wèe ya wu cɛ, bani wèe Yawutuu ni Shɔvɔɔ wʼà foro. ");
INSERT INTO myk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ga caŋa ka wa ma, kee ya nɔ xɔ. Piimu pʼa To Kilɛ pɛlɛ see na ge, pee na ba wu pɛlɛ munaa baraga ni, lee lemu lʼa can wu shɛɛ ge. Bani piimu pʼa kee pɛɛŋɛ ki tuugo pyi ge, pee To Kilɛ ya zhaa. ");
INSERT INTO myk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kilɛ ɲɛ Munaa. Piimu pʼa wu pɛlɛ ge, li waha lʼi waha, pee ya yaa na wu pɛlɛ munaa baraga ni, lee lemu lʼa can wu shɛɛ ge.» ");
INSERT INTO myk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A cee wu wu pye: «Nɛ li cɛ jo Shɔvɔɔ wu na ba ba, (lee kɔ́ri ɲɛ ‹Kilɛ ya wemu shɔɔnri lɔ ge.›) Wee ba ba tuun wemu ni, wu na ba keree ki bɛɛri ɲaha jo wèe mu.» ");
INSERT INTO myk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A Yesu di cee wu pye: «Nɛ wemu wʼa yu ni mu ni ge, nɛ wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na Yesu ni cee wu yaha pee jomɔ pu na, a kalaapiire tʼi ba na yìri yalige ki tashɔgɔ ni. Ba pee ya pa Yesu ta wu na yu ni cee wu ni wɛ, a lʼi pu ɲaha wɔ. Ga wa shishiin ya sɔɔ na wu pye: «Ɲaha kaa mʼa yegee cee wu mu wɛ?» kelee «Ɲaha na mʼa yu ni wu ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A cee wu kunni di wu lokoyaaga ki yaha keeŋɛ ki na, na guri kari kanha ki funŋɔ ni, na shɛ sipyii pu pye: ");
INSERT INTO myk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yi pa ná wa wii, wʼa nɛ kapyelɛgɛɛ bɛɛri jo nɛ mu. Kɔnhɔ wee di ɲɛ Shɔvɔɔ we-e dɛ?» ");
INSERT INTO myk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A sipyii pʼi yìri kanha ki funŋɔ ni na pa Yesu yíri. ");
INSERT INTO myk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lee bi kalaapiire ti ta tʼa Yesu ɲɛɛri na: «Wù Karamɔgɔ, ɲɔ mayɛ na, mʼa ganha li ba.» ");
INSERT INTO myk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ga, a wu pu ɲɔ shɔ na: «Yalige ka wa nɛ mu na li, yee di wa kee cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A kalaapiire tʼi ganha na tiyɛ yegee na: «Ba kɔnhɔ wa wʼa pa yalige ka kan wu mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Yesu di pu pye: «We wʼa nɛ tun ge, nɛ na wee ɲidaan pyi; kapyeŋɛɛ kii wʼa kan nɛ mu ge, na kee bɛ ɲɔ fa, lee ɲɛ ɲɔ yalige yaaga nɛ mu.» ");
INSERT INTO myk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lee kadugo na a Yesu di pu pye: «Ta yee kunni ma yu we tuun we ni, na yeye shishɛɛrɛ wu ɲɛ wèe ni yalɔɔrɔ ti tɛ ni wɛ? Ga nʼa da yi jo yi mu, ‹Yi kɛrɛyɛ yi wii xuuni!› Shinma wʼa lɛ, wu kɔnduun wʼa nɔ xɔ. ");
INSERT INTO myk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wemu wʼa shinma wu kɔɔn ge, wee ya wu saraa taa na xɔ; wʼa shinma pya wu pinnɛ yaha ɲìi sicuumɔ nixhɔbaama pu wuu na. Lee pyegana li na, shinma nuguvɔɔ we ni wu kɔnvɔɔ we, pu shuun wu bɛɛri na fundanga ta shiizhan. ");
INSERT INTO myk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bani talenɛ lemu lʼa yu na: ‹Wa na ba yemɛ nugi, watii na ba wee shinma wu kɔn ge,› lee ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yee ya tɛgɛ kemu nugi wɛ, nɛ yee tun yee pu shɛ kee shinma kɔn. Piitiilee pʼa kee pye, a yee di kuduun ta pee wo kapyeŋɛɛ ki ni.» ");
INSERT INTO myk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A Samari shɛɛn niɲɛhɛmɛɛ di dà Yesu na le kulo le ni cee wu wo kafila wu wuu na. Bani cee wʼa pu pye: «Wʼa nɛ kapyelɛgɛɛ bɛɛri jo nɛ mu.» ");
INSERT INTO myk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lee wuu na a Samari shɛɛn pʼi yìri kanha ki funŋɔ ni na shɛ Yesu yíri. Ba pʼa nɔ wà wɛ, na Yesu ɲɛɛri na wu tiin pu yíri. A wu sɔɔ na cabyaa shuun pye pu yíri. ");
INSERT INTO myk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesu ya cabyaa shuun wemu pye lee kulo li ni ge, a sipyiɲɛhɛmɛɛ piitiilee di dà wu na sanha wu kafila wu wuu na. ");
INSERT INTO myk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A pee di cee wu pye: «Wèe ya ta dà wu na mu wo jomɔ pu yɛ wuu na-ɛ dɛ. Ga wèeyɛ pyaa ya wu jomɔ pu logo, a wèe di li cɛ can na na wee wu ɲɛ koŋɔ ki Shɔvɔɔ wuyɛ pyaa.» ");
INSERT INTO myk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ba kee cabyaa shuun wʼa toro wɛ, a Yesu ni wu kalaapiire tʼi foro Sikari kolo li ni na kari Galile fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu yɛ pyaa bi jo na: «Kilɛ tudunmɔ wa shishiin ya pɛɛŋɛ taa wu to kulo ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ga, ba pʼa nɔ Galile fiige ki ni wɛ, a Galile shɛɛn di pu ɲuŋɔ círi ni fundanga ni. Bani Yesu bi keree kiimu bɛɛri pye Zheruzalɛmu ni Yawutuu Ɲuwuuro ti wo Kalenɛ li ni ge, Galile shɛɛn pu bi kee bɛɛri ɲa, bani puyɛ pyaa bɛ bi shɛ lee kalenɛ li ni. ");
INSERT INTO myk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wee tuun wu ni a Yesu di guri pa sanha Kana kulo li ni, Galile fiige ki ni. Wee xuu wu ni wʼa bi lɔhɔ ki ɲɛri na pye duvɛn. Lee bi fiige ki sipyigbɔ wa ta Kapɛrinɔmɔ kulo li ni; wee ja bi cuuŋɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ba wee ná wʼa logo na Yesu ya yìri Zhude ni na pa Galile ni wɛ, a wu gari wu yíri, na shɛ wu ɲɛɛri na wu pa Kapɛrinɔmɔ ni, na wee ja wʼa taxuyo shaa, wu shɛ wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A Yesu di wee ná wu pye: «Ta le yahagana le na yee wa da yiyɛ yaha gɛ? Yee ya ɲaha shɛshɛɛrɛ kakanhaŋaa ni kagbɔhɔɔ ɲa wɛ, yee da ga dà bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ga, a wee ná wu Yesu pye: «Karamɔgɔna we, ɲɔ mayɛ na mʼa ba nimɛ, kɔnhɔ wù ja wu ganha bu xhu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wee tuun wu ni a Yesu di wu pye: «Kuri mʼa gaaŋi ma ja wʼa cuuŋɔ.» A wee ná wu dà Yesu kafila wu na, na guri kari. ");
INSERT INTO myk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ba wʼa kuri na gaaŋi wɛ, a wu kapyebyii pʼi shɛ wu ɲuŋɔ círi koo li na, na wu pye: «Ma ja wʼa cuuŋɔ.» ");
INSERT INTO myk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A wu pu yege na tuun wekɛ ni wu dʼa cuuŋɔ wɛ? A pʼi jo na taɲaa ceefuuro tʼa wu yaha na caŋa ki yaha kʼa fiin (13h00). ");
INSERT INTO myk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taapile ni a pya wu to wu li cɛ na wee tuun wu ninumɔ ni Yesu ya wee pye: «Ma ja wʼa cuuŋɔ.» A wee ná wu ni wu puga shɛɛn bɛɛri di dà Yesu na. ");
INSERT INTO myk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ayiwa, ba Yesu ya foro Zhude fiige ki ni na kuri Galile fiige ki ni wɛ, le lʼa pye wu ɲaha shɛshɛɛrɛ kakanhana shuun wuu. ");
INSERT INTO myk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ayiwa, lee kadugo na kalegbɔɔ la bye Yawutuu pu mu Zheruzalɛmu ni. A Yesu bɛ di shɛ lee ni. ");
INSERT INTO myk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zheruzalɛmu kulo li ni, kuɲɔɔ lemu ni dubyaa pu ma jin ge, lɔhɔ ka bye wà wege ka ni lee kabanugo. Pʼa bi kee wege ki mɛgɛ yiri Yawutuu jomɔ pu ni na Bɛtisayida. Gbalaa kaguro wu bi yereŋɛ kee wege ki kabanugo. ");
INSERT INTO myk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yama fɛɛ niɲɛhɛmɛɛ pu bi sinnɛ pee gbalaa pu nɔhɔ ni. Fyɛnmɛɛ, ni tɔɔgɛgɛyɛ fɛɛ, ni faannaa, pee bɛɛri bi ma lɔhɔ ki sigee, ki ba ɲɛhɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bani Kafɔɔ wo mɛlɛkɛ wa wu ma digi lɔhɔ ki ni tuun wa ni, na ki ɲɛhɛ. Ba wee ya lɔhɔ ki ɲɛhɛ xɔ wɛ, yama fɔɔ wemu bu fɛnhɛ tigi kee ni, yama tuugo kemu bɛɛri ki ɲɛ weefɔɔ na ge, pee na xhɔ. ");
INSERT INTO myk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ná wa bye wà wee bi yee kɛlɛɛ taanri ni gbarataanri (38) ta na yá. ");
INSERT INTO myk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ba Yesu ya wee ná wu ɲa wʼa sinnɛ wɛ, na li cɛ na wʼa mɔ wu yama pu na. A wu wu yege na: «Mu funŋɔ ki wa mʼa juuŋɔ gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A wu Yesu ɲɔ shɔ na: «Karamɔgɔna we, lɔhɔ ki ba ɲɛhɛ, sipya wa nɛ mu wemu na nɛ lɔ di dirige ki ni wɛ. Nɛ bu jo di yìri nayɛ mu, yani nɛ wu nɔ ge, watii na fyaala tigi nɛ ɲaha na.» ");
INSERT INTO myk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A Yesu di wee ná wu pye: «Yìri mʼa ma yasinnɛgɛ ki lɔ, ma da ɲaari.» ");
INSERT INTO myk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Taapile ni a wu juuŋɔ, a wu yìri na wu yasinnɛgɛ ki lɔ, na ganha na ɲaari. Lee ya pye Yawutuu cadɛɛngɛ ka na. ");
INSERT INTO myk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba Yawutuu ɲuŋɔfɛɛ pʼa wee ná wu ɲa wʼa cuuŋɔ wɛ, a pʼi wu pye: «Niɲaa ɲɛ cadɛɛngɛ dɛ! Na saha ni saliya wu ni, mu ya yaa mu wu ma yasinnɛgɛ ki lɔ mʼa ɲaari niɲaa wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A ná wu Yawutuu pu pye: «Wemu wʼa nɛ cuuŋɔ ge, wee wʼa jo na: ‹Ma yasinnɛgɛ ki lɔ, ma da ɲaari.›» ");
INSERT INTO myk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","A pʼi wu yege na: «Jɔgɔ yɛ pyaa ki dʼa mu pye mu wu ma yasinnɛgɛ ki lɔ, ma da ɲaari wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ga sipya nigin wemu wʼa bi ná wu cuuŋɔ ge, wu bi wee cɛ nige wɛ; bani sipyiire ti bi ɲɛhɛ. Lee bi Yesu ta wʼa foro xɔ sipyiire ti niŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lee kadugo na a Yesu di ba saha ni ná wu ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki funŋɔ ni na wu pye: «Wii, mʼa cuuŋɔ nimɛ, ma ganha bu da da jurumu pyi nige wɛ, kɔnhɔ kaa la bɛtii ganha ba ma ta lemu ya kolo le bɛ na ge wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A wee ná wu shɛ yi jo Yawutuu ɲuŋɔfɛɛ pu mu, na Yesu wʼa wee cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","A Yawutuu pʼi daha Yesu nɔhɔ ni na gana, na ɲaha na wʼa ná wu cuuŋɔ cadɛɛngɛ ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A Yesu di pu ɲɔ shɔ na: «Nɛ To wu wʼa kapyeŋɛɛ pyi tuun bɛɛri ni, lee wuu na nɛ bɛ ya yaa na kapyeŋɛɛ pyi.» ");
INSERT INTO myk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ba Yesu ya pee jomɔ pu jo wɛ, a la di fara Yawutuu ɲuŋɔfɛɛ pu loyire li na. A pʼi ganha na wu shaa di gbo na bani wu jate ya ta nɔ cadɛɛngɛ ki na wɛ; na nɔhɔ na Kilɛ pyi na wee To, na wuyɛ taanna ni Kilɛ ni lee jogana le funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, Ja wʼa da ga já yafiin pye wu yɛ ni, na ta wu ya li ɲa To wu mu wɛ. Le To wʼa byi ge, lee tuugo Ja wu bɛ ya byi. ");
INSERT INTO myk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja wu kaa ya taan To wu ni, lee wuu na wʼa keree kiimu bɛɛri pyi ge, wʼa kee bɛɛri shɛ Ja wu na. Wu na ba keree kii bɛ shɛ wu na sanha kiimu kʼa ye kii bɛ na ge, kɔnhɔ kee di bye yee mu kakanhaŋaa. ");
INSERT INTO myk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","To wʼa xuu ɲɛni na ɲiifɛɛrɛ kaan pu mu kangana lemu na ge, lee na Ja wu la ɲɛ wu ɲìi sicuumɔ kan piimu mu ge, pee mu wʼa da pu kan. ");
INSERT INTO myk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","To wu da kiiri kɔn sipya wa shishiin na wɛ, ga wʼa kiirikɔɔn li sefɛɛrɛ ti bɛɛri kan wu Ja wu mu, ");
INSERT INTO myk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kɔnhɔ sipyii bɛɛri di da Ja wu pɛlɛ, ba pʼa To wu pɛlɛ pɛlɛgana lemu na wɛ. Sipya wemu ya sɔɔ na Ja wu pɛlɛ wɛ, To we wʼa wu tun ge, wee wʼa she pɛɛŋɛ na.» ");
INSERT INTO myk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, sipya wemu bu nɛ jomɔ pu logo, na dà nɛ tunvɔɔ wu bɛ na, wee na ɲìi sicuumɔ nixhɔbaama ta. Kiiri da ba gɔn nige weefɔɔ na wɛ, weefɔɔ ya foro xu ni na jé ɲìi sicuumɔ ni.» ");
INSERT INTO myk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A Yesu di jo sanha na: «Can can na, nʼa da yi jo yi mu, caŋa ka na ba nɔ, kee ya nɔ xɔ bɛ yɛrɛ nimɛ; xuu na ba Kilɛ Ja wu mujuu logo, piimu bɛɛri ba li logo na sɔɔ wu na, pee bɛɛri na ba ɲìi sicuumɔ ta. ");
INSERT INTO myk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bani ba To Kilɛ ɲɛ ɲìi sicuumɔ fɔɔ wɛ, mu wʼa sefɛɛrɛ kan Ja wu bɛ mu wu pye ɲìi sicuumɔ fɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wʼa fanha kan wu Ja wu mu wʼa kiiri wu kɔɔn, bani wee wu ɲɛ Sipya Ja we. ");
INSERT INTO myk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Lee ganha bu da yi fo wɛ, bani tuun wa wʼa ma xuu bɛɛri na ba wu mujuu logo na ɲɛ ");
INSERT INTO myk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na foro faya ni. Piimu pʼa kasaaŋaa pye ge, pee na ba ɲɛ kɔnhɔ pʼi jé ɲìi sicuumɔ nixhɔbaama pu ni. Ga jurumupyii pu kunni na ba ɲɛ kɔnhɔ pʼi jé kiiri ni. ");
INSERT INTO myk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Nʼa da já kaa la shishiin pye nayɛ ni wɛ. Ye Kilɛ ya jo nɛ mu ge, yee ni nɛ kiiri wu kɔɔn na sahaŋi. Nɛ wo kiiri wʼa tii, bani nɛ wu kɔɔn na bɛ ni nayɛ pyaa ɲidaan ni wɛ. Ga, nɛ wu kɔɔn na bɛ ni na tunvɔɔ wu ɲidaan ni. ");
INSERT INTO myk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Li da bi da kanna nɛyɛ pyaa kʼa nayɛ pyaa wo sɛɛri keree yu, nɛ jomɔ pu da bi bye can wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ga watii wu ɲɛ nɛ sɛɛri. Nɛ li cɛ jo yemu wʼa yu nɛ shizhaa na ge, jo yee bɛ ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ayiwa, yee ya pii tun Yohana Batizelipye mu. Wʼa sɛɛri keree kiimu jo yee mu nɛ shizhaa na ge, kee ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nɛ yee yu, kɔnhɔ sipyii di da sɛɛri keree yu na shizhaa na yɛ nigin wɛ dɛ! Ga nɛ yi yu, kɔnhɔ yee di ɲuwuuro ta. ");
INSERT INTO myk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana bye ba sokinna kpɛɛngɛ ɲɛ wɛ, na kpɛɛngɛ yeege yee niŋɛ ni, a yee di sɔɔ na fundanga ta jɛri wu kpɛɛngɛ ki na. ");
INSERT INTO myk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ga nɛ wi ge, yaaga katii bɛ ki ɲɛ nɛ sɛɛri kemu ya ye Yohana wo sɛɛri keree ki na ge. Bani kapyeŋɛɛ kiimu To Kilɛ ya kan nɛ mu ge, nɛ kee bɛ pyi. Kee kapyeŋɛɛ ki bɛ ɲɛ nɛ sɛɛri. Lee ya li shɛɛ na To Kilɛ wʼa nɛ tun. ");
INSERT INTO myk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nɛ To Kilɛ wemu wʼa nɛ tun ge, weeyɛ pyaa ki wa yu nɛ shizhaa na, ga yee ya ta sɔɔ bada na wee ɲɔmɛɛ co wɛ. Le bɛ wʼa shɛ yee na ge, yee ya ta lee ɲaha cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yee ya ta sɔɔ wu jomɔ pu na yi zɔlɔɔ pu na wɛ. Bani wʼa wemu tun ge, yee ya ta dà wee na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Samɔhɔrɔ wa yee ni na Kilɛ Kafila kalaa xuuni, bani yee wʼa giin na lee lʼa da ba ɲìi sicuumɔ nixhɔbaama kan yee mu, na ta wee Kafila we bɛ di nɛ ninumɔ kaa yu. ");
INSERT INTO myk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lee bɛ na, yee funyɔ di ɲɛ yee pu pa nɛ mu, kɔnhɔ yʼi ɲìi sicuumɔ ta wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Nɛ sipyii wo pɛɛŋɛ ke shaa wɛ, bani yee ɲɛ sipyii piimu ge, nɛ yee cɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nɛ li cɛ bɛ jo Kilɛ taanɲɛɛgɛ wa yee funyɔ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nɛ pa na To Kilɛ mɛgɛ na, yee di ya ta sɔɔ nɛ na wɛ. Ga watii da bi ba wuyɛ pyaa mɛgɛ na, yee bi da zɔɔ wee na. ");
INSERT INTO myk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pɛɛŋɛ ke kʼa foro sipyii ni ge, kee kʼa dan yee ni tashaga ni; pɛɛŋɛ ke kʼa daa Kilɛ yɛ nigin ni ge, yee ya kee shaa wɛ. Yee ma já dà dii nɛ na na yee yaha pee yahama pu ni wɛ? ");
INSERT INTO myk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ga yi ganha ba giin na nɛ wʼa da ba yi jaagi To Kilɛ ɲaha tàan wɛ dɛ! Ahayi! Ga Kilɛ tudunmɔɔ Musa wemu wu wa yee tadaŋa ge dɛ, wee wu ɲɛ yee jaagivɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yee da bi dà wee na, yee bi da dà nɛ bɛ na, bani nɛ kaa Musa ya jo wu Kitabu wu ni. ");
INSERT INTO myk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jomɔ pemu Kilɛ tudunmɔɔ Musa ya ka nɛ shizhaa na ge, yee bye yee di ya dà pee na wɛ, yee na ba dà dagana lekɛ na nɛ jomɔ pu na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ayiwa, lee kadugo na Yesu ya kari Galile Gba wu kadugo. Wee gba we ninumɔ mɛgɛ ki ɲɛ na Tibɛrɛyade Gba. ");
INSERT INTO myk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sipyiire ti bi ma daha Yesu fɛni, bani pʼa bi wu ɲaa wu na yama fɛɛ cuuŋɔ na kakanhaŋaa pyi. ");
INSERT INTO myk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ba Yesu ni wu kalaapiire tʼa nɔ wà wɛ, na dugi tiin faaboboŋɔ ka na. ");
INSERT INTO myk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lee bi Yawutuu pu Ɲuwuuro ti wo Kalenɛ li ta lʼa tɛɛŋɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A Yesu di ba wu ɲuŋɔ yirige, na sii sipyii niɲɛhɛmɛɛ ɲa pu na ma wu yíri. A wu Filipe pye: «Mii wèe di wa da já yalige ta di zhɔ pii sipyii pii bɛɛri mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu ya yee jo kɔnhɔ wu logo yɛ Filipe ɲɔ na, lee bɛ wɛ, wʼa bi yaa na lemu pye ge, wu bi lee cɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A Filipe di wu ɲɔ shɔ na: «Wù funŋɔ bi ɲɛ nago kanna pu bɛɛri di pu ɲɔyɔ piri-para yɛ, ali wèe ɲɛhɛ wari dɛɲɛɛ xhuu shuun (200) bɛ taga yalige shɔ, kee da ga yafiin bɛ ɲɔ pii na wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na pu yaha pee jomɔ pu na, Yesu kalaapire lemu mɛgɛ ki ɲɛ na Andire ge, wʼi ɲɛ Pyɛɛri cuun ge, a wee di jo: ");
INSERT INTO myk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Funana la wa naha, buuri ɲuyɔ kaguro ni fyaa shuun wu wa li mu, ga ɲaha yee di wa da ɲɔ pii sipyiɲɛhɛmɛɛ pii na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A Yesu di wu kalaapiire ti pye: «Yi sipyiire ti teŋɛ ɲiŋɛ ki na.» Ɲagara niɲɛhɛrɛ ti bye wee xuu wu ni. A sipyiire tʼi diin diin. Pʼa bi namaa kabɔfoŋɔɔ kaguro (5.000) shi tɔrɔ pee sipyii pu ni. ");
INSERT INTO myk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A Yesu di wee buuri we lɔ na baraga taha Kilɛ na, na wu kan pʼa loolo pee sipyii pu na. A wu fyaa pu bɛ pye mu. A pu bɛɛri di li na din. ");
INSERT INTO myk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba sipyiire tʼa li xɔ wɛ, a Yesu di wu kalaapiire ti pye: «Yi buuri ɲukoroyo yi saya lɔ, kɔnhɔ yi ganha bu gyɛɛgi wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A pʼi yee buuri ɲukoroyo yi lɔ, na taga sagaŋaa kɛ ni shuun ɲi. Sipyiire tʼa li xɔ buuri ɲuyɔ kaguro wu ni, a wemu di gori ge, wee kaa lʼa jo mɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ba sipyii pʼa Yesu wo kakanhana li ɲa wɛ, na jo: «Can na Kilɛ tudunmɔ wemu kaa lʼa jo na wu na ba ba koŋɔ na ge, wee wʼa sii we.» ");
INSERT INTO myk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ba Yesu ya pa li cɛ na fanha bɛ na pʼa giin di wee co di bye saan wɛ, a wu laha pu tàan, na gari faaboboŋɔ katii na wu yɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ba caŋa kʼa pa do wɛ, a kalaapiire tʼi digi kari gba wu ɲɔ ki na. ");
INSERT INTO myk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lee di Yesu ta wu sanha shɛ pu yíri wɛ. A pʼi jé kɔrɔgɔ ka ni na se Kapɛrinɔmɔ ni. Lee bi piige ki ta kʼa wɔ xɔ. ");
INSERT INTO myk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na pu yaha lɔhɔ ki ɲuŋɔ ni, a kafɛɛgbɔhɔ ka di ba yìri, na ganha na lɔhɔ ki pyi ki na ɲɛri xuuni. ");
INSERT INTO myk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba pʼa kiloo kaguro kelee gbaara shishiin paa lɔhɔ ki ɲuŋɔ ni tuun wemu ni wɛ, a pʼi Yesu ɲa wu na ɲaari lɔhɔ ki ɲuŋɔ ni na se kɔrɔgɔ ki mu. A pu jaalaa di yìri xuuni. ");
INSERT INTO myk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","A Yesu di pu pye: «Nɛ wu wa, yi ganha bu da vya wɛ!» ");
INSERT INTO myk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kalaapiire ti funŋɔ ki bi bye wu jé ni pu ni kɔrɔgɔ ki ni, ga xuu wemu ni pu bi se ge, taapile ni a pʼi nɔ wee xuu wu kogoŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ba ɲiga kʼa mugi wɛ, sipyiire ti tʼa bye gba wu kadugo yíri ge, a pee di li sɛɛri, na kɔrɔgɔ nigin yɛ ta wà. A pʼi li cɛ na Yesu ya ta jé ni wu kalaapiire ti ni ke ki kɔrɔgɔ ki ni wɛ, ga na kalaapiire ti tʼa jé ti yɛ na kee kɔrɔgɔ ki ni na kari. ");
INSERT INTO myk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lee bi kɔrɔyɔ ya bɛ ta yʼa yìri Tibɛrɛyade kulo li ni na pa. Xuu wemu ni Kafɔɔ bi baraga taha Kilɛ na, na buuri wu kan pʼa loolo sipyiire ti na ge, a yee di ba yere wee xuu wu tàan. ");
INSERT INTO myk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sipyiire tʼa pa Yesu ta wu ɲɛ wà wɛ, wu kalaapiire ti bɛ di ɲɛ wà-ɛ ge, a pʼi jé yee kɔrɔyɔ yi ni na kari wu tashaga ni Kapɛrinɔmɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ba pʼa kari Yesu yìri gba wu kadugo wɛ, a pʼi wu pye: «Wù Karamɔgɔ, dii mu dʼa pye na ba naha wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A Yesu di pu ɲɔ shɔ na: «Can can na, nʼa da yi jo yi mu, yee ya kakanhaŋaa kiimu ɲa ge, yee wa nɛ shaa kee wuu na-ɛ dɛ! Ga yalige ke yee ya li na tin keki caŋa ge, kee ka wuu na yee wa nɛ shaa. ");
INSERT INTO myk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayiwa, yalige kemu ki da já gyɛɛgi ge, yi ganha ba kapyeŋɛɛ pyi kee wuu na wɛ. Ga yalige kemu ki ɲɛ ki ya gyɛɛgi wɛ, na ɲìi sicuumɔ bɛ kaan ge, yʼa kapyeŋɛɛ pyi kee wuu na. Kee yalige ke, Sipya Ja wu da ba kee kan yee mu. Bani wee na To Kilɛ ya wu fanha ki fɛ pu kpɔn.» ");
INSERT INTO myk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wee tuun wu ni a pʼi Yesu yege na: «Lekɛ wèe dʼa yaa na pye lee di bye Kilɛ ɲidaan wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A Yesu di pu ɲɔ shɔ na: «Lemu Kilɛ ya zhaa yee mu ge, lee li wa mɛ na wee ya sipya wemu tun yee mu ge, na yi dà wee na.» ");
INSERT INTO myk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A pʼi Yesu pye sanha na: «Ga ɲaha shɛshɛɛrɛ kakanhana lekɛ mu di da bye di zhɛɛ wèe na, lee di wèe pye wèe pʼa daa mu na wɛ? Kaa lekɛ mu di da bye di zhɛɛ wèe na wɛ? ");
INSERT INTO myk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Li wii, Kilɛ ya maanɛ kan wèe sefɛlɛɛ pu mu pʼa li sipoŋɔ ki ni ma na jo ba lʼa ka Kilɛ wo Kitabu wu ni wɛ na: ‹Wʼa buuri tirige fugba we ni, na kan pu mu pʼa li.›» ");
INSERT INTO myk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ga, a Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, yalige ke kʼa yìri fugba wu ni ge, kee ya pye Kilɛ tudunmɔɔ Musa wo niganga-ɛ dɛ! Nɛ To Kilɛ wu ɲɛ fugba yalijeŋɛ ki kanvɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bani Kilɛ ya yalige kemu kaan ge, kee ɲɛ wemu wʼa tigi na yìri fugba we ni ge. Wee shiin wʼa ɲiifɛɛrɛ kaan koŋɔ mu.» ");
INSERT INTO myk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ayiwa, a pʼi Yesu pye: «Karamɔgɔna we, ta kee yalige ki kaan tuun bɛɛri ni wù mu gɛ!» ");
INSERT INTO myk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A Yesu di pu pye: «Yalige kemu kʼa ɲìi sicuumɔ pu kaan ge, nɛyɛ pyaa ki ɲɛ kee yalige ke. Sipya wemu bu ba nɛ mu, xuugo da ga weefɔɔ ta sanha bada wɛ. Sipya wemu bu dà nɛ na, waga da ga weefɔɔ ta sanha bada wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ga nɛ yi jo xɔ yee mu; yee dʼa nɛ ɲa bɛ. Ali lee bɛ na, yee di ya dà nɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nɛ To Kilɛ ya piimu bɛɛri kan nɛ mu ge, pee bɛɛri na ba nɛ mu. Sipyaa sipya bu ba nɛ mu, nɛ da ga weefɔɔ kɔri bada wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nɛ ta yìri fugba we ni na pa nayɛ pyaa ɲidaan tapyege ni wɛ. Ga na tunvɔɔ ɲidaan nɛ pa di ba bye. ");
INSERT INTO myk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wemu wʼa nɛ tun ge, wee ɲidaan wu wa mɛ na, sipyaa sipya wʼa kan nɛ mu ge, na wee wa shishiin ganha da biin wɛ. Nɛ ba pee ɲɛ di yeege xu ni koŋɔ caxhɔgɔ bɛ na. ");
INSERT INTO myk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nɛ To wu ɲidaan wu wa mɛ na, sipyaa sipya wʼa wu Ja wu ɲa na dà wu na ge, wee di ɲìi sicuumɔ nixhɔbaama ta, bani nɛ na ba pee ɲɛ di yeege xu ni koŋɔ caxhɔgɔ.» ");
INSERT INTO myk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ba Yesu ya jo na yalige ke kʼa yìri fugba we ni ge, na wee wu ɲɛ kere wɛ, pee jomɔ pe ya ta taan Yawutuu pu ni wɛ. A pʼi ganha na ŋmunu-ŋmunɔ puyɛ tàan. ");
INSERT INTO myk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A pʼi jo: «Ɛɛn! Ta Yusufu ja Yesu bɛ wu ɲɛ we wɛ? Wèe ya wu to wu cɛ, na wu nu wu bɛ cɛ. Ɲaha na wu yu na fugba we ni wee ya yìri wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A Yesu di pu ɲɔ shɔ na: «Yee di ŋmunu-ŋmunɔ do! Yi ŋmunu-ŋmunumɔ pu bɛɛri ɲɔ yaha! ");
INSERT INTO myk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɛ To we wʼa nɛ tun ge, wa shishiin da já ba nɛ mu ni wee ya wufɔɔ yaha pa nɛ mu wɛ. Wa bɛɛri bu ba nɛ mu, nɛ na ba weefɔɔ ɲɛ na yeege xu ni, koŋɔ caxhɔgɔ. ");
INSERT INTO myk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ayiwa, ta Kilɛ wo tudunmɔ wa ya li ka na: ‹Kilɛ yɛ pyaa na ba pu bɛɛri kalaa wɛ?› Sipyaa sipya wʼa To Kilɛ Kafila nuri na sɔɔ wu kalaa wu na ge, pee bɛɛri na ba nɛ mu. ");
INSERT INTO myk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ga li wa nago sipya wa wʼa ɲii taha Kilɛ na wɛ. Wemu yɛ wʼa pa na yìri wu yíri ge, wee yɛ wʼa wu ɲa. ");
INSERT INTO myk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Can na wa bɛɛri bu dà nɛ na, weefɔɔ na ba ɲìi sicuumɔ nixhɔbaama ta. ");
INSERT INTO myk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yalige ke kʼa ɲìi sicuumɔ kaan sipyii mu ge, nɛ wu ɲɛ kere. ");
INSERT INTO myk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yalige ka ya fɛnhɛ yìri fugba we ni, na pa gan yee sefɛlɛɛ pu mu pʼa li sipoŋɔ ki ni, ga lee bɛ na, pu bɛɛri ya xu. ");
INSERT INTO myk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ga nimɛ, yalige ke ki ɲɛ naha ki dʼa yìri fugba we ni ge, wa bu kee li, weefɔɔ na ba ɲìi sicuumɔ ta pemu da xhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nɛ ɲɛ ɲìi sicuumɔ yalige kemu kʼa yìri fugba we ni ge, wa bu kee li, weefɔɔ na ɲìi sicuumɔ ta pemu da ga xhɔ wɛ. Yalige ke nɛ gaan ge, kee ɲɛ nɛyɛ pyaa ceepuuro te. Nɛ tee kan saraga kɔnhɔ di ba koŋɔ sipyii munahaa ɲuŋɔ wolo.» ");
INSERT INTO myk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pee jomɔ pu wuu na, a nakaagbɔɔrɔ di jé Yawutuu pu tɛ ni. A pʼi jo: «Kangana lekɛ na we ná we di da já wu ceepuuro kan wèe mu wèe pu li wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, yee bye yee di ya Sipya Ja wu ceepuuro ti li, na wu shishan pu bɛ gba wɛ, yee da ga ɲìi sicuumɔ ta wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wemu bu nɛ ceepuuro ti li, na nɛ shishan pu bɛ gba, weefɔɔ na ɲìi sicuumɔ ta pemu da ga xhɔ wɛ. Nɛ na ba weefɔɔ ɲɛ na yeege xu ni koŋɔ caxhɔgɔ. ");
INSERT INTO myk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bani nɛ ceepuuro ti ɲɛ yalige nijeŋɛ, nɛ shishan pu bɛ di ɲɛ yagbaga nijeŋɛ ");
INSERT INTO myk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sipya wemu bu nɛ ceepuuro ti li, na nɛ shishan pu bɛ gba, weefɔɔ na bye ni nɛ ni kariɲɛɛgɛ ni, nɛ bɛ di bye ni weefɔɔ ni kariɲɛɛgɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","To Kilɛ wemu wʼa nɛ tun ge, wee wa ɲìi na, wee gbɔɔrɔ ni nɛ bɛ wa ɲiifɛɛrɛ ni. Lee na wa bu nɛ ceepuuro ti li, weefɔɔ bɛ na bye ɲiifɛɛrɛ ni nɛ gbɔɔrɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yalige ke kʼa tigi na yìri fugba wu ni ge, kee ki wa ke. Yee sefɛlɛɛ piimu pʼa xu sipoŋɔ ki ni ge, pee ya yalige kemu li wà ge, kee ni ke wa nigin wɛ. Wemu bu ke yalige ke li, weefɔɔ na ɲìi sicuumɔ ta pemu da xhɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu ya pe jomɔ pe jo na pye kalaa sipyiire ti bɛɛri mu Kapɛrinɔmɔ kulo li ni, na wu yaha Kilɛ-pɛɛŋɛ puga ki ni. ");
INSERT INTO myk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ayiwa, ba Yesu ya pee jomɔ pu jo wɛ, a kalaapiire niɲɛhɛrɛ di jo: «Pe jomɔ pe ya waha dɛ! Ma jo sipya na gbara wu lee pye gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A Yesu di li cɛ wuyɛ ni na pee jomɔ pe pʼa pu pye pu na ŋmunu-ŋmunɔ. A wu pu pye: «Pe jomɔ pe ya digi yee na gɛ? ");
INSERT INTO myk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Xuu wemu ni Sipya Ja bye ge, yee ba wu ɲa wu na duri wà, yee di da ba yekɛ jo wɛ? ");
INSERT INTO myk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kilɛ Munaa lʼa ɲìi sicuumɔ kaan sipya mu. Lee bɛ wɛ, sipya yɛ pyaa fanha ɲɛ yafiin bɛ wɛ. Jomɔ pe nɛ yu yee mu ge, pee ɲɛ Kilɛ Munaa ni ɲìi sicuumɔ. ");
INSERT INTO myk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ga pii wa yee ni, pee ya dà li na wɛ.» Yesu ya yee jo bani fo ɲɔkɔɔnrɔ ti na, piimu pu bye pu ya dà wu na-ɛ ge, wʼa bi pee cɛ. Wemu bɛ wʼa bi da ba wu le keŋɛ ni ge, wʼa bi wee bɛ cɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A Yesu di la fara wu jomɔ pu na sanha na: «Lee wuu na nɛ yee pye jo wa shishiin da já ba nɛ mu, ni To Kilɛ ya lee wo sefɛɛrɛ kan weefɔɔ mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na lɔ wee tuun wu na, a wu kalaapiire niɲɛhɛrɛ di guri wu fɛni. Pee ya ta sɔɔ na taha nige wu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A Yesu di wu kalaapiire kɛ ni shuun wu yege na: «Yee do, yee bɛ funŋɔ ki wa yʼi guri na fɛni gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Simɔ Pyɛɛri di wu ɲɔ shɔ na: «Karamɔgɔ, jɔgɔ yíri wèe di wa da zhɛ sanha wɛ? Ɲìi sicuumɔ nixhɔbaama jomɔ pe, muyɛ nigin mu pu wa. ");
INSERT INTO myk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wèe ya dà mu na. Wèe ya li cɛ bɛ nimɛ jo Fɛfɛɛrɛ Ja we wʼa foro Kilɛ ni ge, jo mu wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A Yesu di pu ɲɔ shɔ na: «Ta nɛ bɛ wʼa yee sipyii kɛ ni shuun wu bɛɛri ɲaha bulo wɛ? Lee bɛ na shɛn nigin di ɲɛ yee ni wee na ɲɛ Shitaanni sipya.» ");
INSERT INTO myk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Zhudasi kaa Yesu bi byi, wee wemu wu ɲɛ Isikariyɔti shɛɛn Simɔ ja wu ge. Wee wu bi da ba Yesu le keŋɛ ni, wee di ɲɛ bɛ Yesu kalaapiire kɛ ni shuun wu wa nigin wa. ");
INSERT INTO myk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lee kadugo na Yesu bi ɲaari na mari Galile fiige ki ni. Wu funŋɔ bye wu shɛ Zhude fiige ki ni wɛ, bani Yawutuu ɲuŋɔfɛɛ pʼa bi wu shaa di gbo wà. ");
INSERT INTO myk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kalenɛ la bye Yawutuu pu mu, pʼa buguloo yàa. Ba lee ya tɛɛŋɛ wɛ, ");
INSERT INTO myk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a Yesu cebooloo pʼi ba wu fɛni na ba wu pye: «Foro naha, mʼa shɛ Zhude fiige ki ni, kɔnhɔ kakanhaŋaa kii mʼa byi ge, ma kalaapiire te ti wa wà ge, pee bɛ di shɛ kee ɲa. ");
INSERT INTO myk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bani sipya wemu funŋɔ ki wa sipyii di wu cɛ ge, wee ya keree ŋmɔhɔni na byi wɛ. Kakanhaŋaa kiimu mu ya byi ge, mʼa yaa na mayɛ shɛɛ, kɔnhɔ koŋɔ sipyii pu bɛɛri di ma cɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ali Yesu cebooloo puyɛ pyaa bi ta dà wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A Yesu di wu ciinnɛɛ pu ɲɔ shɔ na: «Lee pyeduun sanha nɔ nɛ mu wɛ. Lemu bu yee taan tuun wemu ni go lee yee ya byi. ");
INSERT INTO myk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Koŋɔ sipyii da já yee kɔ wɛ, ga, nɛ pʼa kɔ, bani kakuuyo yemu pu wa byi ge, nɛ yee bɛɛri yu kpɛɛngɛ na. ");
INSERT INTO myk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yee pu sii yʼa se kalenɛ li ni, ga, nɛ kunni wa da zhɛ nimɛ wɛ, bani nɛ shɛduun sanha nɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ba Yesu ya yee jo pu mu wɛ, na gori Galile ni. ");
INSERT INTO myk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ba Yesu cebooloo pʼa kari xɔ kalenɛ li ni wɛ, a wuyɛ pyaa di na kari. Wʼa kari sipyiire ti kategee, wu ya ta wuyɛ yaha wa shishiin ya ɲa wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lee bi Yawutuu ɲuŋɔfɛɛ pu ta pu na Yesu shaa kalenɛ li sipyii pu tɛ ni, na ganha na puyɛ yegee na: «Mii wu wa wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pii bi joɲɛhɛmɛ peele na yu sipyiire ti ni Yesu shizhaa na. A pii di jo: «Sipyisaama wu wa we ná we.» Pii bɛ di yu: «Kafinɛyɛ dɛ! Sipyii we ya biinŋɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pʼa bi pee jomɔ pe bɛɛri peele na yu, bani pu bi fyagi Yawutuu ɲuŋɔfɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba kalenɛ lʼa pa nɔ li niŋɛ ni tuun wemu ni wɛ, a Yesu di shɛ jé Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni, na ganha na sipyiire ti kalaa. ");
INSERT INTO myk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A wu kalaa wu Yawutuu pu ɲaha wɔ, a pʼi jo: «Mii we ná we dʼa pe cɛmɛ pe bɛɛri ta, na ta wʼi ya kalaa pye-e wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A Yesu di pu ɲɔ shɔ na: «Kalaa wemu nɛ gaan ge, wee ya ta foro nɛyɛ pyaa ni wɛ, ga nɛ tunvɔɔ Kilɛ ni wʼa foro. ");
INSERT INTO myk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wemu bi giin wu da Kilɛ ɲidaan pyi, weefɔɔ na ba li cɛ, nɛ kalaa wu bi foro Kilɛ ni, kelee wu bi foro nɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sipya wemu wʼa yu ni wuyɛ pyaa fanha ni ge, pɛɛŋɛ weefɔɔ ya zhaa wuyɛ ni. Ga wemu funŋɔ wa wu tunvɔɔ wu wʼa bɛlɛ ge, wee wu ɲɛ can fɔɔ we, naŋmahara ta shishiin ɲɛ weefɔɔ keree ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ta Kilɛ tudunmɔɔ Musa bɛ wʼa Kilɛ wo saliya wu kan yee mu wɛ? Ga yee wa shishiin ya se wu koo ni wɛ. Ɲaha na yee di nɛ shaa di gbo na nɛ saliya kyɛɛgi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A pʼi Yesu pye sipyiire ti niŋɛ ni na: «Jina wu wa mu ni. Jɔgɔ wʼa mu shaa di gbo wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Yesu di pu ɲɔ shɔ na: «Kakanhana nigin wemu nɛ pye ge, lee lʼa sipyiire ti bɛɛri ɲaha wɔ mɛ gɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kilɛ tudunmɔɔ Musa mu yee ya saliya ta na funaŋaa kʼa gɔɔn, ga lee bɛ na yi li cɛ na wee ya ta pye li nɔhɔ shanvɔɔ-i dɛ. Ga wèe wo sefɛlɛɛ pu pʼa li nɔhɔ shan. Lee lʼa li pye yee na funaŋaa ki kɔɔn ali cadɛɛngɛ ki bɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lemu lʼa yee pye yee na funaŋaa ki kɔɔn cadɛɛngɛ ni, kɔnhɔ yi ganha bu da Musa wo saliya wu kyɛɛgi-i ge, ɲaha dʼa li pye nɛ na sipyipomɔ cuuŋɔ cadɛɛngɛ ki na, a yee di logoo yirige nɛ tàan wɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yi ganha ba kiiri kɔɔn keree ɲɛɲaa fɛni wɛ, ga yʼa kiiri wu kɔɔn can ɲuŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na Yesu yaha wu na yu, a Zheruzalɛmu sipyii pii bɛ di ganha na yu: «Ná we pʼa zhaa di gbo ge, ta wee bɛ wu ɲɛ we wɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wu wii wu na yu ni sipyiire ti bɛɛri ni tafaga ni, pu dʼa tiin na wu wii. Kilɛ ya Shɔvɔɔ wemu ɲɔmɛɛ lɔ wèe mu ge, kɔnhɔ wèe ɲuŋɔfɛɛ pʼa giin na wee wu ɲɛ we-e dɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wèe kunni ya we ná we tayirige cɛ, ga na ta Shɔvɔɔ wu ba ba, wa shishiin da ba wu tayirige cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na Yesu yaha wu na sipyii pu kalaa Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni, a wu ba jo ni fanha ni na: «Yee ya jo na yee ya nɛ cɛ, na nɛ tayirige ki bɛ cɛ gɛ? Ga yi li cɛ bɛ na nɛ ta pa nayɛ ni wɛ, na nɛ tunvɔɔ wu ɲɛ bɛ can fɔɔ. Ga yee di ya wu cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nɛ kunni ya wu cɛ, bani wee ni nɛ foro. Wee wʼa nɛ tun bɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ba Yesu ya yee jo wɛ, a pʼi ganha na cogana shaa wu na. Ga wa shishiin ya ta já wu co wɛ, bani wu wo tuun wu ɲɔ bi sanha fa wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lee bɛ na shɛnɲɛhɛmɛɛ ya dà Yesu na. A pʼi ganha na yu: «Ali Shɔvɔɔ wu ɲɛhɛ ba ba, kakanhana lekɛ wʼi da bye lemu lʼa ye we ná we wuu le na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sipyiire ti bi yemu yu Yesu shizhaa na ge, ba Farizhɛɛn ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼa yee logo wɛ, a pʼi Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii pu tun na pu shɛ Yesu co. ");
INSERT INTO myk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ba pee ya nɔ Yesu yíri wɛ, a wu pu pye: «Nʼa da piiye ya bɛ pye ni yi ni sanha, lee kadugo na di na da se na tunvɔɔ wu yíri. ");
INSERT INTO myk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ga yee na ba nɛ sha ganha yee da nɛ ɲa wɛ; bani xuu wemu ni nʼa da ba bye ge, yee wa da já zhɛ wà wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A Yawutuu ɲuŋɔfɛɛ pʼi ganha na puyɛ pyi na: «Wee tuun wu ni mii we ná we di giin di zhɛ na yu na wèe da ga ba já wee ɲa-ɛ wɛ? Yawutuu pii pʼa caaga na shɛ diin Girɛkii pu yíri ge, kɔnhɔ pee yíri wʼa se, wu shɛ pee kalaa-i dɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jomɔ pe wʼa jo na: ‹Yee na ba nɛ sha ganha yee da nɛ ɲa wɛ.› ni ‹Nɛ na ba bye xuu wemu ni ge, yee da já zhɛ wee xuu wu ni-i ge,›» pee jomɔ pu kɔri ɲɛ dii wɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kalenɛ li cabisana li pʼa bi wii li cagbɔhɔ kiyɛ pyaa ge, ba lee ya nɔ wɛ, a Yesu di yere sipyii pu ɲahagbaa na na ganha na yu ni fanha ni na: «Waga bi ɲɛ wa na, wu pa na yíri wu ba gba. ");
INSERT INTO myk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wemu bu dà nɛ na, lɔhɔ kemu kʼa ɲìi sicuumɔ kaan ge, kee na ba fúu weefɔɔ zɔ wu ni ba gba lɔhɔ ɲɛ wɛ» ma na jo ba lʼa ka Kilɛ Kafila wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Fɛfɛɛrɛ Munaa kaa Yesu bi yu mu, wu nʼa daa fɛɛ pu mu na pee na ba lee ta. Wee tuun wu bi Fɛfɛɛrɛ Munaa li ta li sanha gan pu mu wɛ. Bani Yesu bi sanha guri shɛ jé wu nɔɔrɔ wu ni fugba wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ba sipyii pʼa Yesu jomɔ pu logo wɛ, a pii di ganha na yu pu ni na: «Nakaara baa Kilɛ tudunmɔ wemu kaa lʼa jo ge, wee wu ɲɛ we.» ");
INSERT INTO myk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pii bɛ di yu: «Kilɛ ya Shɔvɔɔ wemu ɲɔmɛɛ lɔ ge, wee wu ɲɛ wii.» Ga, a pii di jo: «Dii Shɔvɔɔ wu da já voro Galile fiige ki ni wɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kilɛ wo Kitabu wʼa yi jo na saannaa Dawuda shi ni Shɔvɔɔ wu da ba foro. Na wu na ba foro Bɛtilɛhɛmu ni, kulo lemu ni saannaa Dawuda ya wu wo caŋa ɲii li pye ge.» ");
INSERT INTO myk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A Yesu kaa di bɛganhara leŋɛ sipyiire ti tɛ ni, a tʼi daa taaya shuun. ");
INSERT INTO myk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pii funŋɔ bye pu Yesu co, ga wa shishiin ya ta já wu co wɛ. ");
INSERT INTO myk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii piimu pʼa bi shɛ Yesu fɛni ge, a pee di guri kari saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pu yíri. A pʼi pu yege na: «Ɲaha na yee di ya ta wu co na pa-ɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A pʼi pu ɲɔ shɔ na: «Wèe sanha we ná we wo jomɔ pe tuugo logo ɲa bada wɛ!» ");
INSERT INTO myk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A Farizhɛɛn pʼi pu pye: «Kɔnhɔ yee bɛ di ya yiyɛ yaha wʼa piinŋɛ-ɛ dɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mii yee dʼa li logo, kelee na li ɲa, na wèe ɲuŋɔfɔɔ wa, kelee Farizhɛn wa nigin bɛ ya dà we ná we na wɛ? ");
INSERT INTO myk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pii sipyii pii pʼa dà wu na ge, we wa shishiin ya Kilɛ tudunmɔɔ Musa wo saliya wu cɛ wɛ, pii bɛɛri na ba gyɛɛgi!» ");
INSERT INTO myk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farizhɛn wa bɛ bye wà wu mɛgɛ ɲɛ na Nikodɛmu. Wee bi kari Yesu yíri piige ka ni. A wee di jomɔ pu lɔ na Farizhɛɛn pu pye: ");
INSERT INTO myk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Na bɛ ni wèe wo saliya wu ni, ta lʼa saha na kiiri kɔn sipya wa na, na ta wèe ya fɛnhɛ wu yege na wu nibyii cɛ-ɛ ya?» ");
INSERT INTO myk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ga, a pʼi wee ɲɔ shɔ na: «Payi! Ta ma bɛ yɛrɛ wʼa ɲɛri Galile shɛn wa? Mayɛ pyaa ki bɛ ki Kilɛ Kafila wu kalaa, ma na li ɲa wà na Kilɛ tudunmɔ wa shishiin da ga ba foro Galile fiige ki ni wɛ.»  ");
INSERT INTO myk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ba pʼa pee jomɔ pu jo xɔ wɛ, a pu bɛɛri di yìri caaga na kari pu piyɛyɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A Yesu di gari Oliviye faaboboŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ayiwa, kee caŋa ki ɲimuguro ɲisɔɔgɔ ki na, a Yesu di soo kari sanha Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni. Sipyiire ti bɛɛri bi pinnɛ wu tàan. A wu diin na ganha na pu kalaa. ");
INSERT INTO myk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na Yesu yaha wu na sipyiire ti kalaa, a saliya karamɔgɔlɔɔ ni Farizhɛɛn pʼi ba ni cee wa ni wu yíri, na ba wu yereŋɛ sipyiire ti ɲahagbaa na. ");
INSERT INTO myk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A pʼi Yesu pye: «Karamɔgɔ, wèe ya we cee we co dɔdɔɔrɔ na ni ná watii ni. ");
INSERT INTO myk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na ta Kilɛ tudunmɔɔ Musa wo saliya wu ni lʼa ka na we cee we tuugo ya yaa ni yafiin bɛ ni, ni na kagereye taga wu wá gbo yɛ bɛ wɛ. Mu di wʼa yekɛ yu lee shizhaa na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kafila tufuuyo pu bi zhaan Yesu tàan kɔnhɔ wuyɛ pyaa ɲɔjomɔ di wu le keŋɛ ni. Ga, a Yesu di leele, na ganha na kama kani ɲiŋɛ ki na ni wu kabee ni. ");
INSERT INTO myk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba ma na jo saliya karamɔgɔlɔɔ ni Farizhɛɛn pʼa nɔrɔ yaha wu na na yegee wɛ, a Yesu di wu ɲuŋɔ yirige na pu pye: «Wemu wu wa yee ni wu sanha kakuunɔ pye ɲa bada-ɛ ge, wee wu kagereŋɛ nizhiige ki wá wu na.» ");
INSERT INTO myk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ba wʼa yee jo wɛ, na wu ɲuŋɔ sogi, na ganha na wu kama kani sanha ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Piimu pʼa shɛ ni cee wu ni ge, ba pee ya Yesu jomɔ pu logo wɛ, a pu zɔlɔɔ di pu jaagi; a pu bɛɛri di ganha na foro nigin nigin na gaaŋi, na lɔ nɔhɔlɛɛ pu na, fo na shɛ yaha Yesu ni cee wu yɛ Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni. ");
INSERT INTO myk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ba Yesu ya pa wu ɲuŋɔ yirige wɛ, wu ya ta sipya wa shishiin ɲa nige ni cee wu yɛ bɛ wɛ. A wu jo: «Mii ma jaagivɛɛ pʼi ɲɛ wɛ? Shɛn nigin bɛ ya ta ma ɲuŋɔ le nige-e ya?» ");
INSERT INTO myk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A cee wu Yesu ɲɔ shɔ na: «Wù Karamɔgɔ, shɛn nigin bɛ wɛ.» A Yesu di jo: «Ayiwa, nɛ bɛ da ma ɲuŋɔ le wɛ. Ta gaaŋi, ga mʼa jurumu wu ɲɔ yaha.» ");
INSERT INTO myk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Lee kadugo na a Yesu di ba jomɔ pu lɔ sanha na sipyiire ti pye: «Nɛ wu ɲɛ kpɛɛngɛ ke koŋɔ sipyii pu mu. Sipya wemu bu daha nɛ fɛni wee da ga ɲaari nibiige ni nige wɛ. Ga wee na ba kpɛɛngɛ ta kemu kʼa ɲìi sicuumɔ kaan ge.» ");
INSERT INTO myk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A Farizhɛɛn pʼi wu pye: «Muyɛ pyaa na tɛrɛ na mayɛ kaa yu ya? Can ɲɛ mu kaa li ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A Yesu di pu ɲɔ shɔ na: «Ali nɛyɛ pyaa ɲɛhɛ da nayɛ kaa yu bɛ, nɛ kafila wu ɲɛ can. Bani xuu wemu ni nɛ yìri ge, nɛ wee cɛ; na na tashɛgɛ bɛ cɛ sanha. Ga nɛ tayirige fara nɛ tashɛgɛ na, yee ya kee ka shishiin cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yee kunni wa kiiri kɔɔn sipyii na na bɛ ni yee sipyii wo kiiri kɔngana ni. Nɛ kunni da ga kiiri kɔn sipya wa shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ali nɛ ɲɛhɛ da nɛ na da wa kiiri kɔn, nɛ na wu kɔn na bɛ ni Kilɛ wo can wu ni. Bani nʼa da da kiiri wu kɔɔn na yɛ wɛ. Nɛ To Kilɛ wu wʼa nɛ tun ge, wee wa ni nɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ayiwa, ta li ya ka yee wo saliya wu ni na sipyii shuun bu bye kaa lemu wo sɛɛri, na lee ɲɛ can wɛ? ");
INSERT INTO myk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ayiwa, nɛ nayɛ kaa yu; nɛ To we wʼa nɛ tun ge, wee bɛ ya nɛ kaa yu.» ");
INSERT INTO myk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A pʼi Yesu pye: «Mii mu to wuyɛ pyaa di ɲɛ wɛ?» A Yesu di pu ɲɔ shɔ na: «Yee ya nɛyɛ pyaa cɛ di da nɔ nɛ To wu na wɛ. Yee da bi nɛ cɛ can na, yee bi da nɛ To wu bɛ cɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu ya pe jomɔ pe jo na wu yaha wu na kalaa kaan Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni, keshii piimu ni pʼa Kilɛ yakanya yi leni ge, pee tàan. Sipya wa shishiin di ya ta wu co wɛ, bani wu wo tuun wu bi sanha nɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ayiwa, a Yesu di pu pye sanha na: «Nɛ na ba gari, nɛ nigarixhɔgɔ na, yee na ba nɛ shaa. Ga yee kunni na ba xhu na yee yaha yi jurumu wu ni, bani xuu wemu ni nʼa da ba shɛ ge, yee wa da já zhɛ wà wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba wʼa yee jo wɛ, a Yawutuu ɲuŋɔfɛɛ pʼi jo: «Aa! Wee tuun wu ni wʼa giin wu wuyɛ gbo gɛ? Wʼa jo na wee na ba shɛ xuu wemu ni ge, na wèe da já zhɛ wà wɛ!» ");
INSERT INTO myk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A Yesu di pu pye: «Yee ɲɛ ɲiŋɛ ke wo sipyii, ga nɛ ɲɛ fugba we wo. Yee ɲɛ koŋɔ wuu, ga nɛ ɲɛ koŋɔ wo-e dɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lee wuu na nɛ yee pye jo yee na ba xhu yi jurumu wu ni. Nakaara baa, yi dà li na na: ‹Nɛ ɲɛ wemu nɛ ɲɛ ge.› Yee bye yee di ya dà lee na wɛ, yee na xhuu yi jurumu wu ni.» ");
INSERT INTO myk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","A pʼi Yesu pye: «Wee tuun wu ni jɔgɔ mu di ɲɛ wɛ?» A Yesu di jo: «Fo taashiinɛ li ni nɛ ɲɛ wemu ge, nɛ yee jo yee mu. ");
INSERT INTO myk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Keree niɲɛhɛŋɛɛ wa wà, nɛ na já ki jo yee mu, na kiiri kɔn yee na ki wuu na. Ga wemu wʼa nɛ tun ge, wee wu ɲɛ can we. Yemu nɛ logo wu mu ge, yee nɛ yu koŋɔ sipyii pu mu.» ");
INSERT INTO myk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yawutuu pu bi ta li cɛ na To Kilɛ kaa Yesu bi yu pu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lee wuu na a Yesu di pu pye: «Yee ba Sipya Ja yirige fugba we ni tuun wemu ni, yee na ba li cɛ wee tuun wu ni na ‹Nɛ ɲɛ wemu nɛ ɲɛ ge.› Nɛ kaa la shishiin pyi nayɛ ni wɛ, ga To Kilɛ ya nɛ kalaa lemu ni ge, lee nɛ yu. ");
INSERT INTO myk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","We wʼa nɛ tun ge, wee wa ni nɛ ni. Wu ya ta nɛ yaha na yɛ nigin wɛ, bani le lʼa dan wu ni ge, lee nɛ byi tuun bɛɛri ni.» ");
INSERT INTO myk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ba Yesu ya pee jomɔ pu jo wɛ, a shɛnɲɛhɛmɛɛ di dà wu na. ");
INSERT INTO myk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yawutuu piimu pʼa dà Yesu na ge, a Yesu di pee pye: «Jomɔ pe nʼa da jo yi mu ge, yi bu pee logo, na pu koro ɲaari, yi na ba bye nɛ kalaapiire can na. ");
INSERT INTO myk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Lee na yee da ba can cɛ. Wee can wu jɛ na ba yee shɔ bulooro na.» ");
INSERT INTO myk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A pʼi Yesu pye: «Ibirayima shi shɛɛn wèe ɲɛ, wèe ya ta bulooro pye ɲa sipya wa shishiin bɛ mu wɛ. Ɲaha na mu di yu na wèe na zhɔ bulooro na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A Yesu di pu ɲɔ shɔ na: «Can can na, nʼa da yi jo yi mu, sipyaa sipya wʼa jurumu pyi ge, wee ɲɛ jurumu wo bulo. ");
INSERT INTO myk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na ta bulo ɲɛ kpɔɔn lemu na ge, wu da ga já bye lee kpɔɔn li shɛn yɛ pyaa bada wɛ. Ga kpɔɔn fɔɔ ja wʼa sii kpɔɔn li shɛn yɛ pyaa gbee. ");
INSERT INTO myk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kilɛ Ja wu bu yee pye yiyɛ wuu, wee tuun wu ni yi na na bye yiyɛ wuu can can na. ");
INSERT INTO myk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɛ li cɛ yee ɲɛ Ibirayima shi shɛɛn, ga lee bɛ na yee di nɛ shaa di gbo, bani yee wa nɛ jomɔ pu fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nɛ lemu ɲa na To wu mu ge, lee nɛ yu; le yee bɛ ya ta yi to wu mu ge, lee yee bɛ ya byi.» ");
INSERT INTO myk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A Yawutuu pʼi wu ɲɔ shɔ na: «Ibirayima wu ɲɛ wèe to.» A Yesu di pu pye: «Ibirayima da bi bye yee to can can na, yee kapyegee ni Ibirayima wogo bi da bye nigin. ");
INSERT INTO myk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ga nimɛ, can we nɛ ta Kilɛ mu ge, wee nɛ yu yee mu, a yee di ganha na nɛ shaa di gbo. Ibirayima ya ta lee tuugo pye-e dɛ! ");
INSERT INTO myk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yee to wʼa keree kiimu pyi ge, kee tuugo yee bɛ ya byi.» A pʼi Yesu pye: «Wèe ya ta se dɔdɔɔrɔ ni-i dɛ! To nigin wu ɲɛ wèe mu wee ɲɛ Kilɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A Yesu di pu pye: «Kilɛ da bi ɲɛ yee to can na, nɛ kaa bi da da dan yee ni, bani wee ni nɛ foro. Nɛ ta pa nayɛ ni-i dɛ, ga wee wʼa nɛ tun. ");
INSERT INTO myk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Jomɔ pe nɛ yu yee mu ge, yee ya pu tashɛgɛ cɛ wɛ. Ɲaha na wɛ? Bani yʼa da gbara yi pu logo wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bani Shitaanni wu ɲɛ yee to. Le lʼa dan yee to Shitaanni ni ge, lee yee wa giin di bye. Fo taashiinɛ ni sipyii gbovɔɔ wu ɲɛ were. Wu sanha can jo ɲa wɛ, bani can nigin bɛ wa wu funŋɔ ni wɛ. Wu ba da kafinɛyɛ jo, wʼa yi jo na bɛ ni wuyɛ pyaa funŋɔ keree ni; bani kafinɛjo wu ɲɛ wii, na ɲɛ bɛ kafinɛyɛ wo to. ");
INSERT INTO myk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ga nɛ kunni di can yu. Lee shiin lʼa yee pye yee ya daa nɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jɔgɔ wu wa yee ni wemu na já li shɛ na nɛ jurumu wa pye wɛ? Nɛ bi can yu yee mu, ɲaha na yee di ya dà nɛ na-ɛ wɛ? ");
INSERT INTO myk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sipya wemu bu bye Kilɛ sipya, wee ya Kilɛ jomɔ nuri na gbara bɛ pu na. Ga yee ɲɛ Kilɛ sipyii wɛ. Lee wuu na yee ya sɔɔ na Kilɛ jomɔ nuri wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A Yawutuu pʼi Yesu pye: «Kaɲii wa wèe mu na jo Samari shɛn mu ɲɛ, na jinaa pu ɲɛ mu ni bɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Yesu di pu pye: «Jina wa nɛ ni-i dɛ, ga na To Kilɛ nʼa bɛlɛ. Yee kunni wa nɛ fanri. ");
INSERT INTO myk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nɛ ta na nayɛ pyaa pɛɛŋɛ shaa-i dɛ, ga wa wu wa ki shaa nɛ mu, wee shiin wu ɲɛ bɛ kiiri kɔnvɔɔ we. ");
INSERT INTO myk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can can na, nʼa da yi jo yi mu, wa bu nɛ jomɔ pu logo, na sɔɔ pu na, weefɔɔ da ga xhu bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A Yawutuu pʼi jo: «Nimɛ kunni wèe ya li cɛ nakaara baa jo jinaa pu wa mu ni. Ibirayima ya xu, Kilɛ tudunmɔɔ pusamaa bɛ dʼa xu, mu di yu na wemu bu mu jomɔ pu co, na weefɔɔ da ba xhu bada wɛ. ");
INSERT INTO myk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wee tuun wu ni mu wʼa ye wèe tolɛ Ibirayima na gɛ? Wee ya xu, a Kilɛ tudunmɔɔ pusamaa bɛ di xhu. Wee tuun wu ni mu di mayɛ wii jɔgɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A Yesu di pu ɲɔ shɔ na: «Nɛ da bi nayɛ pɛlɛ, kee pɛɛŋɛ ki bi da bye ɲuŋɔ baa wogo. Nɛ To Kilɛ wʼa nɛ pɛlɛ, wee wemu yee wa byi na yi Kilɛ ge; ");
INSERT INTO myk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","na ta yeeyɛ pyaa ya ta wu cɛ wɛ. Nɛ wʼa wu cɛ. Nɛ da bi jo nɛ wu cɛ wɛ, nɛ bɛ bi da bye yee tuugo kafinɛjo. Ga nɛ wu cɛ, na sɔɔ wu jomɔ pu na, na pu pyi. ");
INSERT INTO myk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yee to Ibirayima ya fundanga ta na wee na ba nɛ caŋa ɲii li ɲa. Ba wʼa li ɲa wɛ, a lʼi bye fundangbɔhɔ wu mu.» ");
INSERT INTO myk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A Yawutuu pʼi wu pye: «Ali mu sanha yee kɛlɛɛ kaguro (50) yɛ pyaa bɛ ta wɛ, mu di yu na mu ya Ibirayima ɲa ya?» ");
INSERT INTO myk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, yani Ibirayima wu se ge, nɛ ɲɛ wemu nɛ ɲɛ ge.» ");
INSERT INTO myk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pee jomɔ pu wuu na, a Yawutuu pʼi kagereye lɔ wu na na pʼi wu wá, ga, a Yesu di beele foro Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na gari. ");
INSERT INTO myk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na Yesu yaha wu na gaaŋi koo li ni, a wu fyɛnna wa ɲa, wu fyɛn wo na se. ");
INSERT INTO myk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A Yesu kalaapiire tʼi wu yege na: «Wù Karamɔgɔ, ɲaha na we ná we dʼa se fyɛn wɛ? Wu wo jurumu wʼa wu pye mu laa, wu sefɛɛ wo jurumu?» ");
INSERT INTO myk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Yesu di pu ɲɔ shɔ na: «Li wa wuyɛ pyaa wo jurumu wɛ, lʼi wa wu sefɛɛ bɛ wo jurumu wɛ; ga lʼa pye, kɔnhɔ Kilɛ wo sefɛɛrɛ tʼi tiyɛ shɛ we ná we wo keree ki funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wemu wʼa nɛ tun ge, li waha lʼi waha wèe ya yaa na wee wo kapyeŋɛɛ ki pyi na caŋa kpɛɛngɛ ki yaha, ni lee bɛ wɛ, piige ki wa ma, ki ba nɔ, wa shishiin da já kapyeŋɛɛ pye nige wɛ. ");
INSERT INTO myk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na nɛ yaha koŋɔ na naha, kpɛɛngɛ nɛ ɲɛ koŋɔ sipyii mu.» ");
INSERT INTO myk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ba Yesu ya yee jo wɛ, na wu ɲɔlɔhɔ wo ɲiŋɛ ki na, na kee taga pogoo kii yɔrɔŋɔ, na kee fara fyɛn wu ɲìi ki na. ");
INSERT INTO myk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na wu pye na wu shɛ wu ɲaha je Silowɛ lowege ki ni. (Silowɛ kɔri ɲɛ: «Tudunmɔ.») Ba ná wʼa shɛ wu ɲaha ki je wà wɛ, a wu ɲìi kʼi mugi, a wu guri kari. ");
INSERT INTO myk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ayiwa, yaŋmuyɔ we ná we bi ma ɲɛɛri. Wu tiinɲii ni wu cɛvɛɛ piimu pʼa bi wu ɲaa wu na ɲɛrɛgɛ ki pyi taashiinɛ li ni ge, a pee di jo: «Fyɛn we wu bi ma ɲɛrɛgɛ ki pyi ge, ta wee bɛ wu ɲɛ we wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","A pii di jo: «Wee wu wa.» A pii bɛ di jo: «Wu ɲɛ were wɛ, wʼa foro yɛ wee fɛni.» Ga, a ná wuyɛ pyaa di jo: «Nɛyɛ pyaa ki ɲɛ kii.» ");
INSERT INTO myk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","A pʼi wu pye: «Wee tuun wu ni a mu ɲìi kʼi bye dii na mugi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A wu pu ɲɔ shɔ na: «Ná wemu mɛgɛ ki ɲɛ Yesu ge, wee wʼa puuro fara nɛ ɲìi na, na nɛ pye na nɛ wu shɛ nayɛ je Silowɛ lowege ki ni. Ba nɛ shɛ na ɲaha ki je wà wɛ, a nɛ ɲìi kʼi mugi.» ");
INSERT INTO myk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","A pʼi wu yege na: «Mii wu wa wɛ?» A wu jo: «Nɛ cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Fyɛnna wu wʼa cuuŋɔ ge, pʼa kari ni wee ni Farizhɛɛn pu yíri. ");
INSERT INTO myk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu ya puuro ti fara fyɛn wu ɲìi ki na na wu cuuŋɔ caŋa kemu ge, kee bye Yawutuu pu wo cadɛɛngɛ. ");
INSERT INTO myk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lee wuu na Farizhɛɛn pʼa fyɛn wu nijuuŋɔ ki yiri, na wu yege na dii wu ɲìi kʼa pye na mugi wɛ. A wu pu ɲɔ shɔ na: «Puuro wʼa fara nɛ ɲìi ki na, a nɛ shɛ na ɲaha je, a nɛ ɲìi kʼi mugi.» ");
INSERT INTO myk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ba wʼa yee jo wɛ, a Farizhɛɛn pii di jo: «Ná wemu wʼa le pye ge, wee da já voro Kilɛ ni wɛ, bani wu ya wèe cadɛɛngɛ ki wii yafiin bɛ wɛ.» Ga, a pii bɛ di jo: «Jurumupye na já le kakanhana le la tuugo pye ya?» Yee nijoyo na, a nakaara di jé pu tɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fyɛn wu wʼa cuuŋɔ ge, a pʼi wu yege sanha na: «Ná we wʼa mu ɲìi ki mugi ge, yekɛ yi wá mu mu na yu wu shizhaa na wɛ?» A wu pu ɲɔ shɔ na: «Kilɛ wo tudunmɔ wa wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ga Yawutuu ɲuŋɔfɛɛ pu bi ta dà yi na na we ná we fyɛn wo wʼa se, a wu ɲìi di na pa mugi wɛ. Lee wuu na a pʼi wu sefɛɛ pu yiri pa, ");
INSERT INTO myk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na ba pu yege na: «Yee ja wu ɲɛ we ya? Yee na já yi jo can na na fyɛngɛrɛ ni wʼa se ya? Wu dʼa pye dii na ɲaa nimɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A wu sefɛɛ pʼi Yawutuu ɲuŋɔfɛɛ pu ɲɔ shɔ na: «Wèe kunni ya li cɛ jo wèe ja wu wu ɲɛ we, wu dʼa se bɛ fyɛn. ");
INSERT INTO myk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ga lemu lʼa wu pye wu na ɲaa nimɛ ge, wèe ya lee cɛ wɛ. Sipya wemu bɛ wʼa wu ɲìi ki bɛ mugi ge, wèe ya wee bɛ cɛ wɛ. Yi wuyɛ pyaa ki yege, wu wa nige nɔhɔcɛrɛɛ wɛ, wuyɛ pyaa ki na yi ɲaha jo yi mu.» ");
INSERT INTO myk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yawutuu ɲuŋɔfɛɛ pu ɲìi fyaara wuu na ná wu sefɛɛ pʼa ye jo, bani pʼa bi bɛ yi na na sipyaa sipya wʼa yere li na na Shɔvɔɔ wu ɲɛ Yesu ge, pʼi weefɔɔ tɔɔgɔ wolo pu Kilɛ-pɛɛŋɛ puga ki keree ki ni fɛɛfɛɛ. ");
INSERT INTO myk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lee wuu na ná wu sefɛɛ pʼa jo na: «Wu wa nige nɔhɔcɛrɛɛ wɛ, yi wuyɛ pyaa ki yege.» ");
INSERT INTO myk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ayiwa, ná wu fyɛngɛrɛ ti tʼa xɔ ge, a pʼi nɔhɔ wu yiri sanha tɔɔɲii shuun wuu li ni na wu pye: «Can jo Kilɛ ɲii na, ná wemu wʼa mu ɲìi ki mugi ge, wèe ya li cɛ na jo jurumupye wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A wu pu ɲɔ shɔ na: «Jurumupye wu ɲɛ la, wu ɲɛ jurumupye-e la, nɛ cɛ wɛ; ga kaa nigin kunni nɛ cɛ, lee ɲɛ: Nɛ kunni bye fyɛn, ga nimɛ nɛ wʼa ɲaa, lee nɛ cɛ.» ");
INSERT INTO myk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A pʼi wu pye: «Ɲaha wu dʼa pye mu na wɛ? Dii wu dʼa mu ɲìi ki mugi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A ná wu pu ɲɔ shɔ na: «Nɛ yee jo xɔ yee mu, ga yee ya ta dà yee na wɛ. Ɲaha na yee di giin yʼi yee logo sanha wɛ? Yee bɛ funyɔ yi wa yʼi bye wu kalaapiire gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ayiwa, a pʼi ganha na wu shɛhɛlɛ na yu: «Mu wu ɲɛ we ná we wo kalaapire; wèe kunni di ɲɛ Kilɛ tudunmɔɔ Musa wo kalaapiire. ");
INSERT INTO myk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bani wèe ya li cɛ jo Kilɛ ya jo ni Kilɛ tudunmɔɔ Musa ni. Ga we ná we kunni wèe ya we tayirige cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Fyɛn wu wʼa cuuŋɔ ge, a wee di Yawutuu ɲuŋɔfɛɛ pu ɲɔ shɔ na: «Le ɲɛ kakanhana dɛ, yee na yu na yee ya we tayirige cɛ wɛ, na ta wu dʼa nɛ ɲìi mugi. ");
INSERT INTO myk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wèe ya li cɛ jo Kilɛ ya jurumupye nijoyo nuri wɛ, ga fo wemu bu bye Kilɛ ɲìi fyaara sipya, na wu ɲidaan pyi, weefɔɔ nijoyo wʼa nuri. ");
INSERT INTO myk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fo taashiinɛ li ni koŋɔ ɲɔkɔɔnrɔ na, wa shishiin sanha logo na wa ya se fyɛn, a wa di wu ɲìi mugi wɛ. ");
INSERT INTO myk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We ná we da bye wu ya foro Kilɛ ni wɛ, wu bi da já yafiin bɛ pye wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A pʼi wu ɲɔ shɔ na: «Jurumupye mu ya sii tii se, mu di giin da wèe kalaa nimɛ gɛ?» Ba pʼa yee jo wɛ, na ná wu kɔri yeege Kilɛ-pɛɛŋɛ puga ki ni. ");
INSERT INTO myk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ayiwa, Yesu ya logo na Farizhɛɛn pʼa ná wu kɔri ge; ba wʼa shɛ jíri wu na wɛ, na jo: «Ta mu ya dà Sipya Ja wu na?» ");
INSERT INTO myk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A ná wu wu ɲɔ shɔ na: «Karamɔgɔna we, jɔgɔ wu ɲɛ wii wɛ? Wu shɛ na na, kɔnhɔ di dà wu na.» ");
INSERT INTO myk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A Yesu di jo: «Weeyɛ pyaa mu wa ɲaa mɛ wu na yu ni ma ni.» ");
INSERT INTO myk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A ná wu jo: «Kafɔɔ, nɛ dà ma na.» A wu nuguro sin Yesu fɛɛ ni na wu pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A Yesu di jo sanha: «Kiiri kaa na nɛ pa koŋɔ na, kɔnhɔ piimu ya ɲaa wɛ, pee di da ɲaa; piimu pʼa ɲaa ge, pee di bye fyɛnmɛɛ.» ");
INSERT INTO myk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizhɛɛn piimu pu bye Yesu tàan ge, ba pee ya yee logo wɛ, na wu yege na: «Wèe bɛ pu ɲɛ fyɛnmɛɛ pʼa gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A Yesu di pu ɲɔ shɔ na: «Yee da bi bye fyɛnmɛɛ, yee bi da jaagi wɛ. Ga yee dʼa jo na yee wa ɲaa, lee lʼa yee wo jurumu wu pye wʼa kori yee ɲuŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ayiwa, a Yesu di pu pye: «Can can na, nʼa da yi jo yi mu, sipya wemu wʼa li she wu da jé yatɔɔgbaha ki kuɲɔɔ li ni wɛ, fo na sirani na duri kasɔrɔgɔ na na jin ge, wee ɲɛ nagaa, na nɔhɔ na dun sipyii na. ");
INSERT INTO myk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ga wemu wʼa jin kuɲɔɔ li ni ge, wee wu ɲɛ yatɔɔnahama wuyɛ pyaa. ");
INSERT INTO myk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yatɔɔgbaha ki kasɛɛgɛ pyevɔɔ wu na yìri na gbura ki mugi wee mu. Dubyaa pu ma wee ɲɔmɛɛ coni. Wee ma wu dubyaa pu bɛɛri nigin nigin yiri pu mɛyɛ na, na foro ni pu ni kpɛɛngɛ na. ");
INSERT INTO myk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wu bu foro ni pu ni kpɛɛngɛ na, wʼa doro pu ɲahagbaa na. Dubyaa pu bɛɛri nigin nigin bɛ na daha wu fɛni, bani pʼa wu mujuu li cɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ga dubyaa pu ya dɛri sipya watii fɛni wɛ, pʼa ganha na fe na gbee bɛ yɛrɛ weefɔɔ ɲaha na, bani pu ya sipya watii mujuu cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ya le talenɛ le jo sipyii pu mu, ga pu ya ta li kɔri cɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A Yesu di pu pye sanha na: «Can can na, nʼa da yi jo yi mu, nɛ wu ɲɛ yatɔɔgbaha ki kuɲɔɔ le. ");
INSERT INTO myk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Piimu bɛɛri pʼa pa nɛ ɲaha na ge, pee bɛɛri ɲɛ nagaalaa ni pii pʼa dun sipyii na ge. Dubyaa pu ya ta sɔɔ na pee jomɔ logo wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nɛ wu ɲɛ kuɲɔɔ le. Sipyaa sipya wʼa jé lee kuɲɔɔ li ni ge, wee na ba shɔ. Wee na da jin, na fòro ɲaɲiŋɛ na. Nɛ na da yalige bɛ kaan wu mu. ");
INSERT INTO myk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nagaa ya ma yafiin na, ni nagaara, ni gbuuro, ni kakara wuu na bɛ wɛ. Ga nɛ kunni ya pa, kɔnhɔ sipyii di ɲìi sicuumɔ nijemɛ ta, pʼi sii pu funŋɔ ɲiŋɛ wo ta.» ");
INSERT INTO myk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","A Yesu di jo sanha na: «Nɛ wu ɲɛ yatɔɔnaha-jemɛ we. Yatɔɔnaha-jemɛ ya wu munaa kaan wu dubyaa pu wuu na. ");
INSERT INTO myk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ga kapyebye we wʼa dubyaa pu kasɛɛgɛ pyi saraa na ge, wee ɲɛ pu nahavɔɔ wɛ. Dubyaa pu bɛ di ɲɛ wu wuu wɛ. Lee wuu na, ba wʼa yacoŋɔ ɲa ki na ma wɛ, wʼa baa na dubyaa pu yaha. Yacoŋɔ ki na dubyaa pii co, pusamaa na jaaga. ");
INSERT INTO myk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kapyebye wu ma baa na dubyaa pu yaha bani wari shavɔɔ wee ɲɛ. Dubyaa pu funzhaga ɲɛ ma bye wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nɛ kunni wu ɲɛ yatɔɔnaha-jemɛ we. ");
INSERT INTO myk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ba To Kilɛ ya nɛ cɛ cɛgana lemu na, a nɛ bɛ di wu cɛ cɛgana lemu na wɛ, mu nɛ bɛ ya na wo dubyaa pu cɛ, a nɛ wo dubyaa pu bɛ di nɛ cɛ mu. Nɛ na na munaa li kan na wo dubyaa pu wuu na. ");
INSERT INTO myk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dubyaa piitiilee bɛ pu wa nɛ mu piimu ɲɛ ke yatɔɔgbaha ke ni wɛ. Li waha lʼi waha, nɛ yaa na pee bɛ kɔri pa; pu na ba nɛ jomɔ nuri. Pu bɛɛri na ba binnɛ bye dubyagbaha nigin. Yatɔɔnahama nigin na ba bye pu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Lee wuu na nɛ kaa ya dan na To Kilɛ ni. Bani nɛ na na munaa kan na xhu, kɔnhɔ di guri ba li ta sanha. ");
INSERT INTO myk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sipya wa shishiin da ga já nɛ munaa karamu wolo wɛ. Nayɛ ni nʼa da li kan. Se wa nɛ ni na li kan, se wa nɛ ni na li shɔ bɛ sanha. Yee nɛ To Kilɛ ya jo nɛ mu.» ");
INSERT INTO myk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A Yawutuu pʼi daa sanha Yesu jomɔ pu wuu na. ");
INSERT INTO myk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A pu niɲɛhɛmɛɛ di jo: «Jina wu wa wu ni, lee lʼa wu ɲuŋmuu yirige. Ɲaha na yee di wu jomɔ nuri wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A pii bɛ di jo: «Eyi! Pe ɲɛ ɲuŋmoyiri-jomɔ wɛ dɛ! Dii ɲuŋmoyirinɛ fɔɔ di da já fyɛn ɲìi mugi wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ayiwa, Yawutuu pu wo Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo kalenɛ lemu lʼa byi, pʼi li pyi na Kilɛ-pɛɛŋɛ pugbɔhɔ ki wo Dedikasi wu ge, a lee di ba nɔ Zheruzalɛmu ni. Lee bi byi yee bɛɛri wiire see see wuuro tiyɛ pyaa tuun ni. ");
INSERT INTO myk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu bi ɲaari ɲaari Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni gba wa nɔhɔ ni. Pʼa bi wee gba wu pyi na saannaa Solomani gba. ");
INSERT INTO myk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A Yawutuu pʼi ba binnɛ Yesu tàan na wu pye: «Tuun wekɛ ni mu di da ga ba nakaara wolo wèe zɔlɔɔ pu ni wɛ? Ma bi sii Shɔvɔɔ we, yi tii jo wù mu.» ");
INSERT INTO myk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A Yesu di pu ɲɔ shɔ na: «Nɛ yi jo xɔ yee mu, ga yee ya dà yi na wɛ. Kapyegee kiimu nɛ pye na To Kilɛ mɛgɛ na ge, kee wa li shɛɛ na ye nɛ yu yee mu ge, na yee ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lee bɛ na yee kunni ya giin di dà nɛ na wɛ, bani yee ɲɛ nɛ wo dubyaa pu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nɛ wo dubyaa pʼa nɛ jomɔ nuri. Nɛ pu cɛ, pʼi dɛri bɛ nɛ fɛni. ");
INSERT INTO myk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɛ pee shɔ na ɲìi sicuumɔ kan pu mu, ɲìi sicuumɔ pemu da xhɔ wɛ. Pee da ga gyɛɛgi bada wɛ, wa shishiin di wa da já pu shɔ nɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nɛ To Kilɛ wemu wʼa pu kan nɛ mu ge, wee wo sefɛɛrɛ tʼa ye yaŋmuyɔ yi bɛɛri wuuro na. Wa shishiin da já pu shɔ nɛ To Kilɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nɛ ni na To Kilɛ wu ɲɛ nigin.» ");
INSERT INTO myk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ba Yesu ya lee ɲɔmɛɛ li jo wɛ, a Yawutuu pʼi nɔhɔ kagereye lɔ na pʼi wu wá gbo. ");
INSERT INTO myk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A Yesu di pu pye: «Nɛ kasaaŋaa niɲɛhɛŋɛɛ pye yee ɲii na kiimu nɛ ta na To Kilɛ mu ge. Kee kapyegee ki ni, nigin wekɛ wuu na yee di wa giin di nɛ wá gbo ni kagereye ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A pʼi Yesu pye: «Wèe ya giin di mu wá ni kagereye ni ma kasaaŋaa ki wuu na-ɛ dɛ. Ga Kilɛ mɛkyɛɛgɛrɛ jomɔ pemu mʼa jo ge, pee wuu na wèe ya giin di ma wá. Mu sipyitiire, mu di mayɛ taanna ni Kilɛ ni.» ");
INSERT INTO myk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A Yesu di pu pye: «Ta li ya ka Kilɛ Kafila wu ni xuu wà ni wɛ na Kilɛ ya jo: ‹Yee ɲɛ kilɛlɛɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na ta wèe dʼa li cɛ na lemu lʼa ka Kilɛ Kafila wu ni ge, lee wa da já ɲɛri wɛ. Ayiwa, Kilɛ ya wu jomɔ pu kan piimu mu ge, ni wʼa pee yiri kilɛlɛɛ, ");
INSERT INTO myk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","wee tuun wu ni Kilɛ ya wemu ɲaha bulo na wu tun koŋɔ mu ge, wee na jo na Kilɛ Ja wee ɲɛ, ɲaha na yee di yu na Kilɛ mɛgɛ wʼa gyɛɛgi wɛ? ");
INSERT INTO myk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɛ bu da nɛ na To Kilɛ kapyegee pyi wɛ, wee tuun wu ni, yi ganha bu dà na na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ga nɛ kapyegee ki bye ki dʼa saha ni na To Kilɛ wu ɲidaan ni, ali yi ɲɛhɛ bye yi ya daa na na wɛ, yee ya yaa na dà li na na Kilɛ ni kii kapyegee kii ya foro; kɔnhɔ yʼi li cɛ fiinŋɛ na nɛ To Kilɛ wu ɲɛ nɛ ni, nɛ bɛ di ɲɛ na To Kilɛ wu ni.» ");
INSERT INTO myk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A sipyii pʼi ganha na wu shaa di joo sanha pee jomɔ pe wuu na, ga, a wu shɔ pu na. ");
INSERT INTO myk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yohana Batizelipye bi sipyii pu batizeni xuu wemu ni taashiinɛ li ni Zhurudɛn Gba wu kadugo ge, A Yesu di shɛ diin wà. ");
INSERT INTO myk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A shɛnɲɛhɛmɛɛ di gari wu fɛni wà. Pee sipyii pʼa bi puyɛ pyi na: «Yohana Batizelipye ya ta kakanhana la shishiin pye wèe mu wɛ. Ga yemu bɛɛri wʼa jo we ná we shizhaa na ge, yee bɛɛri yʼa pye can.» ");
INSERT INTO myk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A shɛnɲɛhɛmɛɛ di dà Yesu na wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ayiwa, ná wa bye Bɛtani kulo li ni ni yama pa ni, wu mɛgɛ ɲɛ na Lazari. Wu ni wu ceboroshaa shuun wu bye: Marite ni Mariyama. ");
INSERT INTO myk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Wee Mariyama we wu bi lasikoli wu wo Kafɔɔ Yesu tɔɔyɔ na, na wu ɲuzhiire taga yi jɔgɔ. Wee wo ceborona Lazari wu wʼa bye ni yama pu ni. ");
INSERT INTO myk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A pee ceboroshaa shuun wu tuduro yaha pʼa shɛ jo Yesu mu na: «Wu Kafɔɔ, ma naɲii wu ya cuuŋɔ wɛ dɛ!» ");
INSERT INTO myk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ba tee tuduro tʼa nɔ Yesu na wɛ, a wu jo: «Pe yama pe ya ta ɲɔ wolo pʼi Lazari tii gbo wɛ, ga pɛɛŋɛ pu da ba daha Kilɛ mɛgɛ na. Pu na ba bye kaɲuŋɔ na pɛɛŋɛ taha Kilɛ Ja wu mɛgɛ ki na.» ");
INSERT INTO myk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marite ni Mariyama ni Lazari ni, lee bi pee taanri wu bɛɛri kaa ta li na dan Yesu ni fo xuuni. ");
INSERT INTO myk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ba Yesu ya Lazari sicuubaara ti kaa logo mu wɛ, xuu wemu ni wu bye ge, a wu sanha di diin wà fo na ta cabyaa shuun. ");
INSERT INTO myk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lee kadugo na a wu ba wu kalaapiire ti pye: «Yi pa wu guri shɛ Zhude fiige ki ni.» ");
INSERT INTO myk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A kalaapiire tʼi wu pye: «Wù Karamɔgɔ, Yawutuu pu na bi mu shaa wee xuu wu ni pʼi mu wá gbo ni kagereye ni li sanha mɔ wɛ, mu sanha di giin mʼa guri mʼa se wà ya?» ");
INSERT INTO myk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A Yesu di pu pye: «Ta lɛɛrɛɛ kɛ ni shuun bɛ wu ɲɛ caŋa ɲii funŋɔ ni wɛ? Sipya ba ɲaari caŋa kpɛɛngɛ na wu da da guruŋɔ wɛ, bani wu ma ɲaa xuuni. ");
INSERT INTO myk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ga sipya ba ɲaari nibiige ni, wʼa ganha na guruŋɔ, bani kpɛɛngɛ ɲɛ ma bye wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lee kadugo na a wu pu pye: «Wèe naɲii Lazari wʼa ŋmunɔɔ, ga nʼa da zhɛ di shɛ wu ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A kalaapiire tʼi wu pye: «Wù Kafɔɔ, wu bi ta wu na ŋmunɔɔ yɛ, go wu na ba juuŋɔ gɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu jomɔ pu bi li shɛɛ na Lazari ya xu. Ga, a wu kalaapiire tʼi ganha na giin na ŋmunumɔ nidiimɛ kaa wʼa byi. ");
INSERT INTO myk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wee tuun wu ni a Yesu di na yi fiinŋɛ jo pu mu na: «Lazari ya xu. ");
INSERT INTO myk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ga nɛ pye nɛ shɛ wà wɛ a wu xhu ge, lee ya taan nɛ ni yee wuu na. Bani lee kaa le na ba bye kaɲuŋɔ, na yee pye yee ya dà nɛ na fo xuuni. Yi yìri wù shɛ wu yíri!» ");
INSERT INTO myk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kalaapire la mɛgɛ ki bye na Tomasi, pʼi wu pyi na «Ŋmami.» A wee di wu kaafɛɛ pusamaa pye: «Wee tuun wu ni wù bɛ pu pinnɛ wʼà se ni wu ni, wù na zhɛ xhu ni wu ni wà shiizhan.» ");
INSERT INTO myk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ayiwa, tuun wemu ni Yesu ya nɔ Bɛtani kulo li ni ge, lee bi Lazari ta pʼa wu le fo wu nixhugo kʼa cabyaa shishɛɛrɛ ta xɔ faŋa ni. ");
INSERT INTO myk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani kulo li bi lii Zheruzalɛmu kulo li na wɛ, laraga ki bi kiloo taanri xɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A Yawutuu niɲɛhɛmɛɛ di ba na pa diin Marite ni Mariyama tàan, na ganha na sɛɛgɛ tan pu na pu ceborona wu xhu wu na. ");
INSERT INTO myk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ba Marite ya pa Yesu kaa logo na wʼa ma wɛ, a wu yíri kari di zhɛ jíri wu na. Ga, a Mariyama di diin deeye ni. ");
INSERT INTO myk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ba wʼa shɛ jíri wu na wɛ, na wu pye: «Wù Kafɔɔ, mu da bi bye naha, nɛ ceborona wu bi da xhuu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ga, ali nimɛ we bɛ ni, nɛ li cɛ sanha jo mu bu yaaga bɛɛri ɲɛɛri Kilɛ mu, wu na kee kan mu mu.» ");
INSERT INTO myk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A Yesu di wu pye: «Marite, ma ceborona wu na ba ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A Marite di wu pye: «Nɛ li cɛ jo nɛ ceborona wu na ba ɲɛ xuu pu ɲɛduun wu ni koŋɔ ki caxhɔgɔ ki na.» ");
INSERT INTO myk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Yesu di wu pye: «Nɛ wʼa xuu pu ɲɛni, na ɲìi sicuumɔ pu bɛ kaan. Sipyaa sipya wʼa daa nɛ na ge, ali wufɔɔ ɲɛhɛ xhu bɛ, nɛ na ɲìi sicuumɔ nivomɔ kan wu mu. ");
INSERT INTO myk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wemu di bu ɲìi sicuumɔ nivomɔ pu ta, na daa nɛ na, weefɔɔ da xhuu bada wɛ. Mu wa daa yee na gɛ, Marite?» ");
INSERT INTO myk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A Marite di jo: «Uun, wù Kafɔɔ, nɛ dà li na jo mu wʼa sii pye Shɔvɔɔ we, Kilɛ Ja we, wemu wu bi yaa wu pa koŋɔ ki na ge, mu wu ɲɛ wii.» ");
INSERT INTO myk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ayiwa, Marite ya yee jo mu ge, na guri pa deeye ni, na ba wu cuun Mariyama peele yiri, na wu pye: «Wèe Karamɔgɔ wʼa pa, wʼa ma yiri na ma shɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ba Mariyama ya yee logo wɛ, a wu gɔn yìri, na gari tɔvuyo na Yesu yíri. ");
INSERT INTO myk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Lee bi Yesu ta wu sanha jé kanha ki ni wɛ. Marite ya shɛ wu ɲuŋɔ círi xuu wemu ni ge, wee xuu wu ni wu bye sanha. ");
INSERT INTO myk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yawutuu piimu pu bi pa diin na sɛɛgɛ tan Mariyama na puga ki ni ge, ba pee ya wu ɲa wʼa yìri foro mu tɔvuyo na wɛ, a pu bɛ di yìri taha wu fɛni. Pu bi giin na wʼa gaaŋi di zhɛ mɛɛ suu faŋa ki na. ");
INSERT INTO myk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Xuu wemu ni Yesu ɲɛ ge, a Mariyama di shɛ nɔ wà. Ba wʼa Yesu ɲa wɛ, na shɛ nuguro sin wu fɛɛ ni na wu pye: «Wù Kafɔɔ, mu da bi bye naha, nɛ ceborona wu bi da xhuu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ba Yesu ya Mariyama ɲa wu na mɛɛ suu wɛ, Yawutuu piimu pʼa taha wu fɛni ge, pu bɛ di mɛhɛɛ suu wɛ, a lee di waha wu na fo xuuni, a wu hakili di wuregi. ");
INSERT INTO myk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A Yesu di pu pye: «Mii yʼa wu le wɛ?» A pʼi wu ɲɔ shɔ na: «Kafɔɔ, pa ma na zhɛ xuu wu ɲa.» ");
INSERT INTO myk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A mɛɛ di shɔ Yesu yɛ pyaa bɛ na. ");
INSERT INTO myk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yawutuu piimu pʼa wu ɲa wu na mɛɛ li suu ge, a pee di jo: «Yi wii! we ná we kaa bi dan wu ni dɛ!» ");
INSERT INTO myk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ga, a pii di jo pu ni na: «Wee wemu wʼa fyɛn wu ɲìi mugi ge, ta wu bi já Lazari bɛ ɲaha kɔn wu ganha bu xhu wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","A pee jomɔ pe bɛ di nɔhɔ waha Yesu na fo na doro. A pʼi gari faŋa ki na. Faaga wege ki bye faŋa ke, a pʼi kageegbɔhɔ ka taga ki ɲɔ tɔ. ");
INSERT INTO myk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ba pʼa shɛ nɔ ki na wɛ, a Yesu di pu pye: «Yi kagereŋɛ ki laha faŋa ki ɲɔ na!» Gbo wu ceboroshɔ wemu bɛ wu bye ni pu ni na Marite ge, a wee di Yesu pye: «Wù Kafɔɔ, wu nugo ya karaa yaa ki ta ki na foro dɛ, bani niɲaa ɲɛ wu caŋa shishɛɛrɛ wogo faŋa ki ni.» ");
INSERT INTO myk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A Yesu di wu pye: «Marite, ta nɛ mu pye jo mu bu da mu na daa nɛ na jo nimɛ ma da Kilɛ wo sefɛɛrɛ ti ɲa wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wee tuun wu ni a pʼi kagereŋɛ ki laha faŋa ki ɲɔ na. A Yesu di wu ɲaha yirige fugba we ni na Kilɛ ɲɛɛri na: «Na To Kilɛ, mʼa na ɲɛrɛgɛ ki shɔ, nʼa baraga taha ma na lee wuu na. ");
INSERT INTO myk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɛ sii li cɛ jo tuun bɛɛri ni mu ya nɛ ɲɛrɛgɛ shuu. Ga sipyii pii pʼa nɛ maha mɛ ge, pee wuu na nɛ ye jo, kɔnhɔ pʼi dà li na na muyɛ pyaa kʼa nɛ tun.» ");
INSERT INTO myk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ba Yesu ya yee jo wɛ, na mujuu wá na: «Lazari, foro naha kpɛɛngɛ ke na!» ");
INSERT INTO myk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A Lazari di ɲɛ na foro faŋa ki ni. Fasicoro li bi taga keye ye ni tɔɔyɔ ye pɔ wu mu, na faxuugo ka taga ɲaha ke migile. A Yesu di pu pye: «Yi fàya yi sanha laha wu na, yʼi wu yaha wu da se!» ");
INSERT INTO myk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yawutuu piimu pʼa bi pa na pa diin Mariyama yɛ tàan kpɔn pu ni ge, le Yesu ya pye ge, ba pʼa lee ɲa wɛ, a pu niɲɛhɛmɛɛ di dà Yesu na. ");
INSERT INTO myk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ga, a pii di gari pu ni, na shɛ kii keree kii paari Farizhɛɛn pu mu. ");
INSERT INTO myk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pʼi kiirikɔɔn kuruŋɔ ki yiri na jo: «Lekɛ wèe di da bye nimɛ wɛ? Bani we ná we, kakanhaŋaa niɲɛhɛŋɛɛ wʼa byi lʼa toro! ");
INSERT INTO myk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wèe di bu sii we yaha wu na kii pyi le pyegana le na, sipyii pu bɛɛri pu da ba dà wu na. Lee di bu bye bɛ, Oromɛ sɔrɔsii pu na ba wù Kilɛ-pɛɛŋɛ pugbɔhɔ ki ja, na ki kyɛɛgi, na wù shi wu bɛ kyɛɛgi!» ");
INSERT INTO myk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ná wa bye pu ni wee mɛgɛ ɲɛ na Kayifɛ, wee wu bye saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we lee yee le. A wee di pu pye: «Yee kunni ya keree ɲaha cɛni wɛ! ");
INSERT INTO myk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ta yee ya li cɛ na jo lʼa pɔrɔ yee mu na shɛn nigin wu xu sipyii pu bɛɛri wuu na, kɔnhɔ wèe shi wu bɛɛri di shɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ayiwa, Kayifɛ bi ta pe jomɔ pe ta wuyɛ ni na jo wɛ. Ga ma na jo wʼa pye lee yee le saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu ge, lee funŋɔ ni Kilɛ ya pe jomɔ pe tirige wu funŋɔ ni wʼa jo mɛ na Yesu wʼa yaa wu xu Izirayɛli shɛɛn pu bɛɛri wuu na. ");
INSERT INTO myk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ga wu bi da ba xhu Izirayɛli shɛɛn yɛ nigin wuu na wɛ. Kilɛ wo sipyii piimu bɛɛri pʼa caaga koŋɔ ke bɛɛri na ge, wu na ba xhu kɔnhɔ wu pee bɛɛri pinnɛ wu pu pye nigin. ");
INSERT INTO myk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A Yawutuu ɲuŋɔfɛɛ pʼi li shɛ kee caŋa kiyɛ pyaa na pʼa yaa na Yesu gbo. ");
INSERT INTO myk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","A Yesu di bye wu ya sɔɔ wʼa ɲaari nige Yawutuu pu tɛ ni ni sipyiire ti ni wɛ. A wu yìri wee xuu wu ni, na gari kulo la ni sipoŋɔ ki kabanugo ki na. Lee kulo li mɛgɛ ki bye na Efirayimu. A wu ni wu kalaapiire tʼi shɛ diin wà. ");
INSERT INTO myk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lee bi Yawutuu pu wo Ɲuwuuro ti wo Kalenɛ li ta lʼa tɛɛŋɛ. A fiige ki sipyii niɲɛhɛmɛɛ di digi na pa Zheruzalɛmu ni na ta kalenɛ li sanha nɔ wɛ, kɔnhɔ pʼi ba puyɛ pye fɛɛfɛɛ na bɛ ni pu wo kalɛgɛɛ ki ni. ");
INSERT INTO myk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A sipyii pʼi ganha na Yesu shaa. A pʼi shɛ puyɛ pinnɛ Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki ni, na ganha na puyɛ yegee na: «Ɛɛ, yʼi wa dii wɛ? Wu wʼa ma kalenɛ li ni-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lee bi saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pu ta pʼa yi jo sipyii pu mu na wa bɛɛri ba Yesu sanha cɛ, na wu shɛ yi jo pee mu, kɔnhɔ pʼi shɛ wu co. ");
INSERT INTO myk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ayiwa, cabyaa gbaara wu bi kori Yawutuu wo Ɲuwuuro ti wo Kalenɛ lʼi nɔ, a Yesu di gari Bɛtani ni. Lazari wemu nixhugo Yesu bi ɲɛ ge, wee wu bye lee kulo li ni. ");
INSERT INTO myk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A pʼi yalige ka yàa wà lee kulo li ni Yesu mu. Marite wu bi kee yalige ki keree shɔɔnri. Sipyii piimu pu bye na li ni Yesu ni ge, Lazari bɛ di ɲɛ pee ni. ");
INSERT INTO myk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wee tuun wu ni a Mariyama di pu yaha pu na li, na shɛ lasikoli gbuu la lɔ, lemu mɛgɛ ki ɲɛ na naari ge, li pɛrɛmɛ bɛ dʼa waha. A wu ba wee lasikoli wu wo Yesu tɔɔyɔ na; na xhɔ na wu ɲuzhiire taga tɔɔyɔ yi tuu tuu. Wee lasikoli wu bi litiri taaga xɔ. A wu nugo kʼi puga ki bɛɛri círi. ");
INSERT INTO myk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu kalaapire la mɛgɛ ki bye na Zhuda Isikariyɔti, wee wu bi da ba Yesu le keŋɛ ni, a wee di jo: ");
INSERT INTO myk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ɲaha na we lasikoli we di ya ta pɛrɛ kabɔfoŋɔɔ kɛlɛɛ shishɛɛrɛ ni kaguro (w 45.000) shishiin, na wee kan funmɔ fɛɛ mu-i wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zhudasi bi ta ye jo funmɔ fɛɛ wo ɲiɲaara wuu na-ɛ dɛ, ga nagaa wu bye wii. Wee mu wari keshi wu bye. Wari we pu bi leni wu ni ge, wu bi ma wee wo. ");
INSERT INTO myk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ga, a Yesu di wu pye: «Yi laha wu na! Caŋa ke pʼa da ba na le faŋa ni ge, kee caŋa ke wuu na wu wa ni we lasikoli we ni. ");
INSERT INTO myk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bani funmɔ fɛɛ na ba bye ni yee ni tuun bɛɛri ni, ga nɛ wa da ba bye ni yee ni tuun bɛɛri ni naha wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayiwa, ba Yawutuu pʼa pa logo na Yesu wa Bɛtani ni wɛ, a pu niɲɛhɛmɛɛ di gari wà. Pu bi gaaŋi wà Yesu yɛ nigin wuu na wɛ, ga wʼa Lazari wemu ɲɛ na yeege xu ni ge, wee bɛ taɲaga ni pʼa bi se. ");
INSERT INTO myk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ba Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼa yee logo wɛ, na jo na ni li wa mu, na pee da Lazari bɛ gbo. ");
INSERT INTO myk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bani Yawutuu niɲɛhɛmɛɛ pu bi guroo pu fɛni na ma na daa Yesu na Lazari wuu na. ");
INSERT INTO myk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ayiwa, kee caŋa ki ɲimuguro, sipyiɲɛhɛnɛ lemu li bi pa Zheruzalɛmu ni Ɲuwuuro Kalenɛ li ni ge, a pee di yi logo na Yesu wa koo na na se Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","A pʼi fɛnhɛgeye kɔn, na foro na gaaŋi di zhɛ Yesu círi ni yee ni. A pʼi ganha na xhuulo na yu na: «Hosana! Wʼà Kilɛ sɔni! We wʼa ma mɛ Kafɔɔ mɛgɛ na ge, Izirayɛli wo saan wu ɲɛ wii, duba wʼa byi wee mu!» ");
INSERT INTO myk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lee bi Yesu ta wʼa kafabige ka ta na dugi kee na ma na jo ba lʼa ka Kilɛ wo Kitabu wu ni wɛ na: ");
INSERT INTO myk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Siyɔn kulo, ma ganha bu fya wɛ! Wii, ma saan wu wa ma; kafabige na wʼa dugi tiin.» ");
INSERT INTO myk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kalaapiire ti bi ta kii keree kii ɲaha cɛ wee tuun wuyɛ pyaa ni wɛ. Ga ba Yesu ya pa ɲɛ na foro xu ni, na jé Kilɛ wo nɔɔrɔ wu ni wɛ, a pu funyɔ di na to na Yesu shizhaa jomɔ pu bye Kilɛ Kafila we, lee shiin pʼi bi pye bɛ wu na. ");
INSERT INTO myk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sipyii piimu bɛɛri pu bye ni Yesu ni a wu Lazari yiri yeege faŋa ki ni, na wu ɲɛ na yeege xu ni ge, pee bi kii keree kii ɲaha yu sipyii pu mu. ");
INSERT INTO myk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesu ya le kakanhana le pye, a sipyii pʼi li kaa logo, lee wuu na bɛ pʼa bi foro na shɛ wu ɲuŋɔ círi. ");
INSERT INTO myk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wee tuun wu ni a Farizhɛɛn pʼi ganha na puyɛ pyi: «Go yiyɛ pyaa ɲii wa li ni gɛ, yee da já yafiin bɛ na wɛ; bani sipyii pu bɛɛri pʼa taha wu na.» ");
INSERT INTO myk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sipyii piimu pu bi pa kalenɛ li ni Zheruzalɛmu ni di ba Kilɛ pɛlɛ ge, Girɛkii piimu pu bi jé Yawutuu pu wo koo li ni ge, pee pʼa bɛ bye pii sipyii pii ni. ");
INSERT INTO myk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A pee Girɛkii pʼi fulo Filipe na, na jo ni wee ni. Filipe bi bye Bɛtisayida shɛn, Galile fiige ki ni. A pʼi wu pye: «Naɲii, wù funŋɔ ki wa wù Yesu ɲa, wù jo ni wu ni.» ");
INSERT INTO myk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A Filipe di gari na shɛ yee ɲaha jo Andire mu, a pu shuun wu bɛɛri di na pinnɛ kari na shɛ yi jo Yesu mu. ");
INSERT INTO myk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A Yesu di pu pye: «Kilɛ na ba pɛɛŋɛ taha Sipya Ja wu na tuun wemu ni ge, wee tuun wu wʼa nɔ nimɛ. ");
INSERT INTO myk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Can can na, nʼa da yi jo yi mu, shinma pile bye lʼi ya le ɲiŋɛ ni lʼi fɔnhɔ wɛ, li yɛ li da gori, ga li bu le ɲiŋɛ ni na fɔnhɔ, wee tuun wu ni lʼa fin, na nagoo niɲɛhɛmɛɛ pye. ");
INSERT INTO myk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sipya wemu munaa kaa lʼa dan wu ni ke koŋɔ ke na ge, wee na ba buun li ni ɲiga na. Ga sipya wemu munaa kaa lʼa pɛn wu mu ke koŋɔ ke na ge, weefɔɔ wʼa li gbegele yaha ɲìi sicuumɔ nixhɔbaama kaa na. ");
INSERT INTO myk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sipyaa sipya wʼa giin wu da kapyeŋɛɛ pyi nɛ mu ge, wʼa yaa wu taha na fɛni. Bani xuu wemu ni nɛ ɲɛ ge, nɛ kapyebye wu bɛ na ba bye wà. Sipya wemu ba kapyeŋɛɛ pyi nɛ mu, nɛ To Kilɛ na ba weefɔɔ pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Nimɛ we ni, nɛ zɔ we bɛɛri wʼa wuregi. Dii nʼa da jo wɛ? Di jo Kilɛ wu na tanha we tuun we wo kanhama pu na laa? Nʼa da já yee jo wɛ, bani we tuun we wo kanhama pu wuu na nɛ pa koŋɔ na.» ");
INSERT INTO myk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A Yesu di jo sanha na: «Na To Kilɛ, ma mɛgɛ ki pɛlɛ!» Ba wʼa yee jo wɛ, a mujuu la di foro fugba we ni na: «Nɛ ki pɛlɛ na xɔ, di wa da ba la fara sanha ki pɛɛŋɛ ki na.» ");
INSERT INTO myk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sipyiire te ti bye wà na le mujuu le logo ge, a pee di jo: «Kilɛ wʼa tin mɛ!» A pii bɛ di jo: «Mɛlɛkɛ wa wʼa pa jo ni wu ni!» ");
INSERT INTO myk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ga, a Yesu di pu pye: «Le mujuu le ya ta foro nɛ wuu na wɛ, ga yee wuu na lʼa foro. ");
INSERT INTO myk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nimɛ kiiri wʼa da ba gɔn ke koŋɔ ke wo sefɛɛrɛ ti na. Nimɛ ke koŋɔ ke wo ɲuŋɔfɔɔ wu wa da ba gɔri wá. ");
INSERT INTO myk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sipyii pu ba nɛ yirige na laha ɲiŋɛ ke na tuun wemu ni, nɛ na ba sipyii bɛɛri yiri na pa nayɛ mu.» ");
INSERT INTO myk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Xugana lemu na Yesu bi da ba xhu ge, lee xugana le wʼa zhɛɛ pe jomɔ pe funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A sipyiire tʼi wu ɲɔ shɔ na: «Lʼa ka Kilɛ wo saliya wu ni na Shɔvɔɔ wu da ba xhu bada wɛ. Mu di yu dii na li waha lʼi waha, na sipyii na ba Sipya Ja wu yirige na laha ɲiŋɛ ke na wɛ? Wee tuun wu ni, wekɛ di ɲɛ wee Sipya Ja wu wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A Yesu di pu ɲɔ shɔ na: «Kpɛɛngɛ ki wa sanha yee tɛ ni, ga jɛri yɛ kʼa da bye. Na kpɛɛngɛ ki yaha yi tɛ ni, yʼa ɲaari ki na kɔnhɔ nibiige ki ganha bu ba yi fo di joo wɛ; bani sipya wemu ba ɲaari nibiige ni, wee ya wu tashɛgɛ cɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na kpɛɛngɛ ki yaha yi tɛ ni, yʼa daa ki na kɔnhɔ yiyɛ pyaa bɛ di ba bye kpɛɛngɛ nagoo.» Ba Yesu ya pee jo wɛ, na laha pu tàan, na shɛ lara xuu wa ni. ");
INSERT INTO myk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ayiwa, na Yesu yaha wʼa sii kakanhaŋaa niɲɛhɛŋɛɛ pye Yawutuu pu ɲii na. Ali pu ya dà wu na lee bɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Lee ya pye mu kɔnhɔ Kilɛ tudunmɔɔ Ezayi bi jomɔ pemu jo ge, pee ɲɔ di fa na: «Kafɔɔ, wèe ya kafila wemu wo yɛrɛ pye ge, wekɛ wu dʼa dà wee na wɛ? Wekɛ wu dʼa Kafɔɔ wo sefɛɛrɛ ti cɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lemu bɛ lʼa bi pu pye pu bi da ga já dà Yesu na sanha wɛ ge, lee li wa mɛ na jo Kilɛ tudunmɔɔ Ezayi ya jo sanha na: ");
INSERT INTO myk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Kilɛ ya pu pye fyɛnmɛɛ na pu fungɔnyɔ tɔ, kɔnhɔ pu ɲìi ki ganha ba ɲaa wɛ, pu fungɔnyɔ ganha bu yi cɛ wɛ. Lee funŋɔ ni pu da ba nɛ mu, kɔnhɔ nɛ pu cuuŋɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kilɛ tudunmɔɔ Ezayi ya yee jo bani Yesu wo nɔɔrɔ wu bi shɛ wu na, a wu ye jo wu shizhaa na. ");
INSERT INTO myk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ali lee bɛ na Yawutuu ɲuŋɔfɛɛ pu niɲɛhɛmɛɛ pu bi dà Yesu na, ga Farizhɛɛn pu wuu na, pu ya sɔɔ na puyɛ yeege kpɛɛngɛ na wɛ, kɔnhɔ pu ganha bu pu niŋɛ kɔn wolo Kilɛ-pɛɛŋɛ puga ki wo sipyii pu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bani sipyii na pu pɛlɛ, lee li bi dan pu ni na toro Kilɛ wʼa pu pɛlɛ na. ");
INSERT INTO myk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Caŋa ka Yesu ya pa sii jo fanha na na: «Sipya wemu bu dà nɛ na, wu ya ta dà nɛ yɛ nigin na wɛ, ga wemu wʼa nɛ tun ge, wee bɛ na wʼa dà. ");
INSERT INTO myk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sipya wemu bu nɛ ɲa, we wʼa nɛ tun ge, wee bɛ wʼa ɲa. ");
INSERT INTO myk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nɛ ɲɛ ba kpɛɛngɛ ɲɛ wɛ, nɛ pa koŋɔ puga ni, kɔnhɔ sipyaa sipya wʼa dà nɛ na ge, weefɔɔ ganha ba ɲaari nibiige ni nige wɛ? ");
INSERT INTO myk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wa bu nɛ jomɔ logo, wu ya pu koro ɲaari wɛ, nʼa da kiiri kɔn wufɔɔ na wɛ. Bani nɛ ta pa di ba kiiri kɔn koŋɔ sipyii na wɛ, ga nɛ pa di ba pu ɲuŋɔ wolo. ");
INSERT INTO myk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sipya wemu bu zhe nɛ ni, wʼi ya sɔɔ na nɛ jomɔ logo wɛ, weefɔɔ ya kiiri kɔnvɔɔ ta xɔ wuyɛ na. Nɛ jomɔ pemu jo ge, pee pu da ba kiiri kɔn wufɔɔ na koŋɔ caxhɔgɔ. ");
INSERT INTO myk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bani nɛ ta pe jomɔ pe ta nayɛ ni na jo wɛ. Ga nɛ To Kilɛ wu wʼa nɛ tun ge, wee wʼa nɛ wo nijoyo yi bɛɛri shɛ nɛ na. ");
INSERT INTO myk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɛ dʼa li cɛ bɛ na jo jomɔ pe wʼa yu ge, pee pu wa ɲìi sicuumɔ nixhɔbaama kaan sipya mu. Ba To Kilɛ ya pu shɛ na da nɛ na wɛ, mu nɛ wʼa pu yu na dani.» ");
INSERT INTO myk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ayiwa, caŋa nigin wu bi kori Yawutuu wo Ɲuwuuro ti wo Kalenɛ lʼi nɔ. Yesu bi li cɛ na wee foroduun wʼa nɔ xɔ koŋɔ puga na se wu To Kilɛ yíri. Sipyii pii pu bi dà wu na ge, pee kaa bi dan wu ni; a pu kaa di sii taan wu ni fo na doro. ");
INSERT INTO myk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ni wu kalaapiire ti bye na pu piige yalige li, lee bi Shitaanni ta wʼa shɛ fungɔngɔ ka tirige Zhuda Isikariyɔti zɔ na, Simɔ ja we, na wu Yesu le keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu bi li cɛ bɛ na Kilɛ ya sefɛɛrɛ ti bɛɛri kan wee mu. Wu bi li cɛ na Kilɛ ni wee ya foro, wee di wa da ba guri gari bɛ Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ayiwa, a Yesu di yìri yalige ki ɲuŋɔ ni na wu fadegbɔhɔ wolo yaha, na fàŋa ka lɔ na kee taga wuyɛ pɔ niŋɛ ke ni. ");
INSERT INTO myk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lee kadugo na a wu lɔhɔ le yaaga ka ni, na ganha na wu kalaapiire ti tɔɔyɔ jii nigin nigin na; fàŋa ke wʼa taga wuyɛ pɔ ge, na kee taga na yi turi. ");
INSERT INTO myk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A wu ba shɛ nɔ Simɔ Pyɛɛri na, a Pyɛɛri di wu pye: «Wù Kafɔɔ, mu wʼa da na nɛ tɔɔyɔ je ya?» ");
INSERT INTO myk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Yesu di wu pye: «Le nɛ byi mɛ ge, mu wa da li kɔri cɛ nimɛ wɛ, ga kadugo yíri ma na ba li kɔri cɛ.» ");
INSERT INTO myk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A Pyɛɛri di wu pye: «Nɛ kunni wa da gbara mu wu na tɔɔyɔ je bada wɛ.» A Yesu di wu pye: «Mu bye mu di ya yere nɛ ma tɔɔyɔ je wɛ, mu niŋɛ wa da bye ni nɛ ni kaa la shishiin ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A Pyɛɛri di jo: «Wee tuun wu ni Kafɔɔ, ma ganha bu da na tɔɔyɔ ye yɛ na wɛ, ga na keye ye ni na ɲuŋɔ ke bɛ je.» ");
INSERT INTO myk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Yesu di wu pye: «Sipya wemu wʼa wuu ge, wee kawuunɔ ɲuŋɔ ɲɛ nige wee tuun we ninumɔ ni wɛ, bani wu bɛɛri wu ma bye fɛɛfɛɛ; ga wu kunni na já wu tɔɔyɔ je. Yee bɛ pu wa fɛɛfɛɛ, ga yee bɛɛri bɛ wɛ dɛ!» ");
INSERT INTO myk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kalaapire le li bi da ba Yesu le keŋɛ ni ge, wu bi lee cɛ, lee wuu na wʼa jo na pu bɛɛri ya ta pye fɛɛfɛɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ba Yesu ya pu tɔɔyɔ yi je xɔ wɛ, na wu fadegbɔhɔ ki lɔ le, na shɛ diin wu tatɛɛngɛ ni. A wu wu kalaapiire ti pye: «Kaa le nɛ pye mɛ yee na ge, yee ya li kɔri cɛ ya? ");
INSERT INTO myk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yee wa nɛ pyi: ‹Wù Karamɔgɔ› kelee ‹Wù Kafɔɔ.› Lʼa saha, bani wee nɛ ɲɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ayiwa, nɛ wemu wu ɲɛ yee Karamɔgɔ ni yee Kafɔɔ ge, nɛ bi yee tɔɔyɔ je, wee tuun wu ni yee bɛ ya yaa na yiyɛ tɔɔyɔ jii lee jegana li na. ");
INSERT INTO myk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nɛ le pye na shɛ yee na. Nɛ li pye pyegana lemu na ge, yi bɛ di da li pyi yiyɛ na lee pyegana li na. ");
INSERT INTO myk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Can can na, nʼa da yi jo yi mu, kapyebye ya pɛlɛ wu ɲuŋɔfɔɔ na wɛ; tudunmɔ bɛ di ya pɛlɛ wu tunvɔɔ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yi wa li ɲaha cɛ nimɛ, yi ba li pyi, yi na ba bye duba nagoo. ");
INSERT INTO myk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Di wa ta na yi bɛɛri kaa pyi-i dɛ, nɛ piimu shɔɔnri ge, nɛ wʼa pee cɛ. Ga Kilɛ tudunmɔɔ pʼa yemu jo Kitabu wu ni ge, fo yee ɲɔ bu fa na: ‹Wemu wu wa li ni nɛ ni ge, wee wʼa nɛ pye wu pɛn.› ");
INSERT INTO myk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nʼa yi yu na yɛri yi mu nimɛ, yani li pyeduun wu pa nɔ ge, kɔnhɔ li ba ba bye, yʼi li cɛ na: ‹Nɛ ɲɛ wemu nɛ ge.› ");
INSERT INTO myk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can can na, nʼa da yi jo yi mu, sipyaa sipya wʼa nɛ tudunmɔ wa bɛɛri co na ɲɔ ge, nɛyɛ pyaa mʼa co na ɲɔ; wemu di bu nɛ co na ɲɔ, we wʼa nɛ tun ge, weefɔɔ mʼa co na ɲɔ.» ");
INSERT INTO myk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ba Yesu ya yee jo xɔ wɛ, a wu hakili wu wuregi fo xuuni. A wu yi fiinŋɛ jo pu mu na: «Can na nʼa da yi jo yi mu, wa na ba nɛ le keŋɛ ni yee ni.» ");
INSERT INTO myk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ba wʼa yee jo wɛ, a wu kalaapiire tʼi ganha na puyɛ wii, pu ya cɛ shɛn nigin wekɛ kaa wʼa byi pu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu kalaapire la bye wà, lee kaa bi dan wù ni fo xuuni, lee bi tiin na sogi wu na. ");
INSERT INTO myk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","A Simɔ Pyɛɛri di keŋɛ ka lee kalaapire li mu na wu Yesu yege wee sipya we keree na. ");
INSERT INTO myk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A wee di wu ɲaha ɲɛri Yesu yíri, na fulo wu na, na wu pye: «Wù Kafɔɔ, wee ɲɛ wekɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Yesu di wu pye: «Wemu mu nʼa da ba buuri we niŋɛ di gan ge, wee wu wa.» A wu buuri wa lɔ na wu niŋɛ na kan Simɔ Isikariyɔti ja Zhudasi mu. ");
INSERT INTO myk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Buuri wʼa kan yɛ Zhudasi mu, a Shitaanni di ba diin wu zɔ na. A Yesu di wu pye: «Le mʼa giin di bye ge, fyaala li pye.» ");
INSERT INTO myk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ga sipyii piimu bɛɛri pu bi li ni Yesu ni ge, wa shishiin ya cɛ pu ni lekɛ na wʼa yee jo ni Zhudasi ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zhudasi wu bi bye pu wari yahavɔɔ, a pii di ganha na giin na Yesu wʼa wu pyi na wu shɛ yaŋmuyɔ ya shɔ, wu ba Ɲuwuuro Kalenɛ li yalige ki gbegele ni yee ni; kelee na wu shɛ funmɔ fɛɛ pii kan. ");
INSERT INTO myk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ba Zhudasi ya buuri wu li yɛ wɛ, na yìri foro kpɛɛngɛ ki na. Lee bi piige ki ta kʼa wɔ. ");
INSERT INTO myk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ayiwa ba Zhuda Isikariyɔti ya foro wɛ, a Yesu di wu kalaapiire ti pye: «Nimɛ kunni, sipyii pu bɛɛri pʼa da ba Sipya Ja wu wo sefɛɛrɛ ti cɛ. Wee wʼa da ba sipyii pu bɛɛri pye pʼa Kilɛ bɛ wo sefɛɛrɛ ti cɛ.  ");
INSERT INTO myk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ba ni wee na ba sipyii bɛɛri pye pʼa Kilɛ wo sefɛɛrɛ ti cɛ, Kilɛ yɛ pyaa bɛ na ba sipyii pye pʼa Sipya Ja wu wo sefɛɛrɛ ti cɛ, lee wʼa da mɔ lʼi bye wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na nagoo, nʼa da já gori yaha ni yee ni di mɔ nige wɛ. Yee na ba nɛ xuu shaa, ga nɛ yemu jo Yawutuu ɲuŋɔfɛɛ pu mu ge, yee ninuyɔ nʼa da jo yi bɛ mu jo nɛ na ba shɛ xuu wemu ni ge, yee wa da já zhɛ wà wɛ. ");
INSERT INTO myk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lee wuu na ɲɔmɛɛ nivonɔ nʼa da jo yi mu, yi taan yiyɛ mu. Yee ya taan nɛ mu taangana lemu na ge, yʼa yaa yi taan yiyɛ mu lee taangana li na. ");
INSERT INTO myk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Taanɲɛɛgɛ bu bye yee tɛ ni, sipyii bɛɛri na ba li cɛ lee na na yee ɲɛ nɛ wo kalaapiire.» ");
INSERT INTO myk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A Simɔ Pyɛɛri di Yesu yege na: «Wù Kafɔɔ, wee tuun wu ni mu di wa se mii wɛ.» A Yesu di wu pye: «Xuu wemu ni nɛ se ge, mu wa da já binnɛ zhɛ wà ni nɛ ni nimɛ wɛ; ga caŋa ka wa ma, ma na ba shɛ nɛ yíri.» ");
INSERT INTO myk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","A Pyɛɛri di wu pye: «Wù Kafɔɔ, ɲaha na nɛ da já binnɛ ni mu ni-i wɛ? Ali nɛ na zɔɔ na na munaa li kan, na xhu bɛ mu wuu na.» ");
INSERT INTO myk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A Yesu di wu pye: «Can na mu na zɔɔ na ma munaa li kan, na xhu nɛ wuu na ya? Can can na, nʼa da yi jo ma mu, yani xhupoo wu pa mɛɛ su ge, mu na ba foro nɛ kaa tàan tɔɔɲii taanri.» ");
INSERT INTO myk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Lee kadugo na a Yesu di pu pye: «Yi funyɔ ganha bu da bɛn wɛ. Yʼa daa Kilɛ na, yi da daa nɛ bɛ na. ");
INSERT INTO myk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tatiinyɛ niɲɛhɛyɛ yi wa nɛ To Kilɛ mu, yee da bye yi ɲɛ can wɛ, nɛ bi da ga yee pye jo nʼa da zhɛ tatiinyɛ yàa yi mu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɛ ba shɛ tatiinyɛ yi yàa xɔ tuun wemu ni, nʼa da guri ba na ba yee lɔ, nɛ wa xuu wemu ni ge, kɔnhɔ yi bɛ di shɛ bye wà. ");
INSERT INTO myk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xuu wemu ni nɛ wʼa gaaŋi ge, yee wa lee koo li cɛ xɔ.» ");
INSERT INTO myk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","A Tomasi di wu pye: «Wù Kafɔɔ, xuu wemu ni mu wa se ge, wèe ya wee xuu wuyɛ pyaa cɛ wɛ, wèe na bye dii na lee koo li cɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Yesu di wu pye: «Nɛ wu ɲɛ koo le, ni can we, ni ɲìi sicuumɔ fɔɔ we. Sipyaa sipya wu ɲɛ wu ya toro nɛ yìri wɛ ge, weefɔɔ da nɔ To Kilɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yee bi ta yee ya nɛ cɛ, yee na ba nɛ To Kilɛ wu bɛ cɛ; yee dʼa wu cɛ xɔ nimɛ do, na wu ɲa bɛ.» ");
INSERT INTO myk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A Filipe di wu pye: «Wù Kafɔɔ, To Kilɛ wu shɛ wù na, lee na wèe yaa.» ");
INSERT INTO myk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A Yesu di wu pye: «Filipe, niɲaa shi kaa ya nɛ yaha ni yee ni shiizhan wɛ, mu di sanha nɛ cɛ-ɛ ya Filipe? Sipya wemu wʼa nɛ ɲa ge, To Kilɛ wʼa ɲa. Mu di yu dii na nɛ wu To Kilɛ shɛ yi na wɛ? ");
INSERT INTO myk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wee tuun wu ni mu ya dà li na na nɛ wu ɲɛ ni To Kilɛ ni nigin; To Kilɛ bɛ di ɲɛ ni nɛ ni nigin wɛ gɛ? Jomɔ pe nɛ yu mɛ yee mu ge, nɛ pu taa nayɛ ni wɛ; ga nɛ To Kilɛ we wu wa ni nɛ ni ge, wee wʼa wu ɲidaan keree pyi. ");
INSERT INTO myk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yi dà na na! Nɛ ni na To wu bɛɛri wu ɲɛ nigin; nɛ To wu bɛ ni nɛ ni, wèe bɛɛri pu ɲɛ nigin. Lee bu bye lʼi wa yi yaa wɛ, kapyegee kiimu nʼa byi yi ɲii na ge, yi dà na na kee wuu na. ");
INSERT INTO myk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Can can na, nʼa da yi jo yi mu, sipya wemu bu dà nɛ na, keree kiimu bɛɛri nɛ byi ge, wu na ba kee tuugo pyi. Wufɔɔ na ba keree kii pyi bɛ kiimu ya pɛlɛ nɛ wogoo ki na ge, bani nɛ wa gaaŋi na To Kilɛ wu yíri. ");
INSERT INTO myk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yi ba yaaga tuugo bɛɛri ɲɛɛri Kilɛ mu wee tuun wu ni nɛ mɛgɛ na, nɛ na kee kan yi mu; kɔnhɔ Jafɔɔ wu To Kilɛ wu wo sefɛɛrɛ ti shɛ. ");
INSERT INTO myk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yi bu yaaga tuugo bɛɛri ɲɛɛri nɛ mɛgɛ na, nɛ na kee kan yi mu.» ");
INSERT INTO myk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Nɛ bu da nɛ kaa ya dan yi ni can can na, nɛ ɲɔmɛhɛɛ kiimu jo yi mu ge, yi na da ki koro ɲaari. ");
INSERT INTO myk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɛ na ba na To Kilɛ wu ɲɛɛri wu Tɛgɛvɔɔ watii kan yi mu, kɔnhɔ wee di ba bye ni yi ni gbee. ");
INSERT INTO myk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wee ɲɛ Fɛfɛɛrɛ Munaa lemu lʼa Kilɛ wo can wu shɛɛ sipyii pu na ge. Koŋɔ ke sipyii wa da já wee ta wɛ, bani pu wa wu ɲaa wɛ, pʼi wa wu cɛ bɛ wɛ. Ga yee kunni dʼa wu cɛ, bani wu wa ni yee ni, wu na ba bye yee zɔlɔɔ pu na. ");
INSERT INTO myk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nʼa da ga yi yaha ba cirimɛɛ ɲɛ wɛ. Nɛ na ba shɛ guri ba yi mu sanha. ");
INSERT INTO myk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jɛri bu bye ke koŋɔ ke sipyii na wii vɔɔ nɛ ni. Ga yee kunni na ba nɛ ɲa, bani nɛ ɲɛ ɲiifɛɛrɛ ni, lee wuu na yee bɛ na ba bye ɲiifɛɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kee caŋa ki ba nɔ, yee na ba li cɛ na nɛ ni na To wu ni, na wèe bɛɛri pu ɲɛ nigin; yee ni nɛ bɛ di ɲɛ nigin, nɛ bɛ ni yee bɛɛri bɛ di ɲɛ nigin. ");
INSERT INTO myk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sipya wemu ba nɛ jomɔ nuri na pu koro ɲaari, weefɔɔ ni nɛ kaa ya dan can can na. Nɛ kaa ba dan sipya wemu ni, weefɔɔ kaa na da dan To Kilɛ bɛ ni; wu kaa na da dan nɛ bɛ ni, nɛ na ganha na nayɛ shɛɛ wu na.» ");
INSERT INTO myk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu kalaapire la bɛ mɛgɛ ki bye na Zhuda, (wee ni Zhuda Isikariyɔti wa nigin wɛ.) A wee di wu yege na: «Wù Kafɔɔ, ɲaha na mu di da ba mayɛ shɛ wèe na, mu di da mayɛ shɛ koŋɔ ki sipyii pusamaa na-ɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Yesu di wu pye: «Nɛ ba dan sipya wemu ni, jomɔ pemu nɛ jo ge, wufɔɔ na da pee koro ɲaari. Lee funŋɔ ni, weefɔɔ na da dan nɛ To Kilɛ bɛ ni. Nɛ ni na To Kilɛ na ba ba weefɔɔ mu na ba bye ni wu ni. ");
INSERT INTO myk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nɛ bu bye nɛ ya dan sipya wemu ni wɛ, wee da da nɛ jomɔ pu bɛ koro ɲaari wɛ. Jomɔ pe nɛ di wa yu yee mu ge, pee ya foro nɛyɛ pyaa ni wɛ, ga nɛ tunvɔɔ To Kilɛ ni pʼa yìri. ");
INSERT INTO myk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Na nɛ yaha ni yee ni shiizhan nimɛ, nɛ ye bɛɛri jo yee mu. ");
INSERT INTO myk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","To Kilɛ na ba Fɛfɛɛrɛ Munaa lemu kan yee mu nɛ mɛgɛ na lʼi bye yee Tɛgɛvɔɔ ge, lee na ba yee kalaa keree bɛɛri ni. Nɛ keree kiimu bɛɛri jo yee mu ge, li na ba yi funyɔ tirige kee bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nʼa da loɲinɛ kan yi mu. Loɲinɛ le li wa nɛ ni ge, lee tuugo nʼa da ba gan yi mu. Ga nʼa da li kan ke koŋɔ ke wuu li kangana na wɛ. Yi ganha bu fyaara yaha yi zɔlɔɔ pu na wɛ, yi ganha bu yi hakilee pu bɛ yirige wɛ. ");
INSERT INTO myk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nɛ yi jo xɔ yi mu jo: ‹Nɛ gaaŋi, ga nʼa da zhɛ guri ba yi mu sanha.› Nɛ bu da nɛ na dan yee ni, nɛ na se To Kilɛ yíri, lee ya yaa li pye yee mu fundanga. Bani To Kilɛ ya pɛlɛ nɛ na. ");
INSERT INTO myk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ayiwa, nɛ kii keree kii jo yi mu nimɛ, yani ki pyeduun wu pa nɔ ge, kɔnhɔ ki pyeduun ba nɔ, yʼi dà na jomɔ pu na. ");
INSERT INTO myk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nʼa da já jo di mɔ nige ni yi ni wɛ, bani ke koŋɔ ke wo ɲuŋɔfɔɔ wu wʼa ma. Wu se wa nɛ na kaa la shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ga koŋɔ sipyii bɛɛri ya yaa pu li cɛ na nɛ To Kilɛ ya dan nɛ ni, keree kii wʼa yu nɛ mu ge, nɛ di kee bɛ pyi.» Ba Yesu ya yee jo xɔ wɛ, na jo: «Yi yìri wù da se, wù laha naha!» ");
INSERT INTO myk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ayiwa Yesu ya jo na: «Nɛ ɲɛ ɛrɛzɛn tige can can wogo, nɛ To Kilɛ di ɲɛ ki faapyevɔɔ. ");
INSERT INTO myk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Geŋɛ bɛɛri kʼa foro nɛ na, kʼi ya nagoo pyi wɛ, wu na kee kɔn. Ga geŋɛ bɛɛri kʼa foro nɛ na na nagoo pyi ge, wu na ba kee yiile, kɔnhɔ ki da nagoo niɲɛhɛmɛɛ pyi na toro taashiinɛ li tàan. ");
INSERT INTO myk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nɛ kalaa wemu kan na xɔ yee mu ge, wee kalaa wʼa yee pye fɛɛfɛɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yi kori yaha nɛ wo kariɲɛɛgɛ ki ni, nɛ bɛ na gori yaha ni yi ni kariɲɛɛgɛ ni. Ba ɛrɛzɛn geŋɛ ɲɛ mɛ wɛ, ki da já nagoo pye kiyɛ mu ni ki ya kori yaha tige ki ceefuu li na wɛ, mu yee bɛ ɲɛ. Yee bye yee di ya kori yaha nɛ wo kariɲɛɛgɛ ki ni wɛ, yee da já nagoo pye piimu kaa na daan Kilɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Nɛ wu ɲɛ ɛrɛzɛn tige ke, yee di ɲɛ geye ye. Sipya wemu wʼa kori yaha nɛ wo kariɲɛɛgɛ ki ni, a nɛ bɛ di gori yaha kariɲɛɛgɛ ni ni wufɔɔ ni ge, weefɔɔ wu da já nagoo niɲɛhɛmɛɛ pye. Bani nɛ bye nɛ ɲɛ ni yee ni wɛ, yee da já yafiin bɛ pye Kilɛ mu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sipya wemu bu bye wu ya sɔɔ na gori yaha nɛ wo kariɲɛɛgɛ ki ni wɛ, wee na ba wá kpɛɛngɛ na. Wu na ba bye ba ɛrɛzɛn geŋɛ ɲɛ wɛ, pʼa kemu kɔn na laha tige ki na ge, kʼa waha. Yee gewaya yi na ba binnɛ na yi le na ni, yʼa sogi. ");
INSERT INTO myk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yi bu gori yaha nɛ wo kariɲɛɛgɛ ki ni, a nɛ jomɔ bɛ di gori yaha yi funyɔ ni, yaaga bɛɛri kaa li ɲɛ yi na ge, yi ki ɲɛɛri, kee na gan yi mu. ");
INSERT INTO myk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yee bu nagoo niɲɛhɛmɛɛ pye, lee lʼa li shɛɛ na yee ɲɛ nɛ wo kalaapiire, lee shiin lʼi wa Kilɛ mɛgɛ pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nɛ taan na To Kilɛ mu taangana lemu na ge, lee taangana le ninunɔ na yee bɛ ya taan nɛ mu. Lee na nimɛ, yi kori yaha nɛ wo taanɲɛɛgɛ ki ni. ");
INSERT INTO myk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yi ba nɛ wo ɲɔmɛɛjogoo ki coni, yi na ba gori yaha nɛ wo taanɲɛɛgɛ ki ni. Ba nɛ ya na To Kilɛ wo ɲɔmɛɛjogoo ki koro ɲaari, na gori yaha wu wo taanɲɛɛgɛ ki bɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Nɛ kii keree kii bɛɛri jo yee mu, kɔnhɔ nɛ wo fundanga ki já pye yi ni, kɔnhɔ yi wo fundanga ki ɲɔ di fa. ");
INSERT INTO myk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ɲɔmɛɛ le nʼa da jo yi mu ge, lee li wa mɛ. Yee ya taan nɛ mu taangana lemu na ge, yi taan yiyɛ mu lee taangana li na. ");
INSERT INTO myk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na ma munaa kan na xhu ma naɲiinɛɛ wuu na, taanɲɛɛgɛ ka shishiin ya pɛlɛ kee na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Keree kiimu nɛ yu yee mu ge, yi ba kee pyi, wee tuun wu ni yʼa ɲɛri na naɲiinɛɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nɛ da da yee pyi nige kapyebyii wɛ, bani kapyebye ya wu ɲuŋɔfɔɔ kapyegee bɛɛri cɛni wɛ. Ga nɛ yee pye na naɲiinɛɛ, bani kaa lemu bɛɛri nɛ ta na To Kilɛ mu ge, nɛ yee kalaa kee bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yi ganha ba giin na yee pu wa nɛ ɲaha bulo wɛ dɛ! Ga nɛ wu wa yee ɲaha bulo, na yee pye na tudunmɔɔ. Yʼa kapyegee nizaaŋaa pyi, kiimu wo kuduun wu da gori yaha ge; kɔnhɔ yi ba yaaga bɛɛri ɲɛɛri To Kilɛ mu nɛ mɛgɛ na, wu kee kan yi mu. ");
INSERT INTO myk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Le nʼa zhaa yi mu ge, lee li wa mɛ jo yi taan ni yiyɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Koŋɔ sipyii bu yi kɔ, yʼa yaa yi fɛnhɛ li cɛ na nɛ koŋɔ ya fɛnhɛ kɔ yee ɲaha na. ");
INSERT INTO myk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yee da bi bye ni koŋɔ ke wo sipyii ni nigin, yee bi da da dan koŋɔ ke ni, bani yee bi da bye koŋɔ wuu. Ga yee ɲɛ ke koŋɔ ke wuu wɛ, bani nɛ yee ɲaha bulo, na yee niŋɛ wolo ke koŋɔ ke ni. Lee wuu na koŋɔ kʼa tɔnbɛɛnrɛ shan yee na. ");
INSERT INTO myk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɛ fɛnhɛ jomɔ pemu jo yi mu ge, yi pee yaha yiyɛ funyɔ ni na jo: ‹Kapyebye ya pɛlɛ wu ɲuŋɔfɔɔ na wɛ.› Pu bi ta pʼa nɛ kanha, pu na ba yee bɛ kanha mu. Pu bi ta pʼa nɛ jomɔ pu co, pu na ba yee bɛ wo jomɔ pu co. ");
INSERT INTO myk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ga pu na ba kee keree ki bɛɛri pye yee na nɛ wuu na, bani wemu wʼa nɛ tun ge, pu ya wee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nɛ da bye nɛ pa na ba jo ni pu ni wɛ, pu bi da ba jaagi pu jurumu wu na wɛ. Ga nimɛ, kaɲii tagana wa pu mu pu jurumu wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sipya wemu bu nɛ kɔ, nɛ To Kilɛ wu bɛ ma wʼa kɔ. ");
INSERT INTO myk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kakanhaŋaa kii ki ɲɛ sipya wa shishiin sanha ki pye ɲa-ɛ ge, nɛ da bye nɛ kee pye pu niŋɛ ni wɛ, pu bi da ba jaagi pu jurumu wu na wɛ. Ga nimɛ kunni pʼa kee bɛɛri ɲa pu ɲii na, na nɔhɔ nɛ ni na To Kilɛ wu kɔ. ");
INSERT INTO myk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ga kee bɛɛri ya pye mu, kɔnhɔ yemu yʼa ka pu wo saliya wu ni ge, yee ɲɔ di fa na: ‹Pʼa na kɔ tawaga ni.› ");
INSERT INTO myk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Ayiwa, Tɛgɛvɔɔ we nʼa da ba dun na pa yi mu na yìri To Kilɛ yíri ge, wee ɲɛ Fɛfɛɛrɛ Munaa, lemu lʼa can wu shɛɛ sipyii pu na ge. Lee ba ba, lee na ba nɛ kaa yu. ");
INSERT INTO myk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yi bɛ di ba na kaa yu sipyii pu mu, bani nɛ ni yee pu bye shiizhan fo nɛ keree ki ɲɔ kɔnduun wu ni. ");
INSERT INTO myk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Nɛ kii keree kii bɛɛri jo yi mu, kɔnhɔ kaa la shishiin ganha bu yi yeege nʼa daa wu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pu na ba yi niŋɛ kɔɔn na wo Kilɛ-pɛɛŋɛ piyɛyɛ sipyii ni. Caŋa ka yɛrɛ wa ma, wa ba yee wa gbo, wufɔɔ na wuyɛ ta na pɛɛŋɛ kaa wee ya pye Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pu na ba kee keree ki bɛɛri pyi yi na, bani pu ya nɛ To Kilɛ cɛ wɛ, pʼi wa nɛyɛ pyaa ki bɛ cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nɛ kii keree kii bɛɛri yu yi mu, kɔnhɔ ki pyeduun ba nɔ, yi funyɔ di do li na na nɛ ki bɛɛri jo toro yi mu. «Nɛ ta ye ɲaha jo yee mu fo taashiinɛ li ni wɛ, bani nɛyɛ pyaa ki bi bye ni yee ni. ");
INSERT INTO myk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ga we wʼa nɛ tun ge, wee yíri nʼa da guri da gaaŋi nimɛ; sipya bɛ di wa ta yee ni na nɛ pye: ‹Mii mʼa se wɛ?› ");
INSERT INTO myk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nɛ pe jomɔ pe jo yee mu ge, lee lʼa yee ɲahaya pye yʼa tanha. ");
INSERT INTO myk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ga lee bɛ na can nʼa yu mɛ yi mu, nɛ na kari, lee lʼa pɔrɔ yee mu, bani nɛ bu bye nɛ ya kari wɛ, Tɛgɛvɔɔ wu da ba yee mu wɛ. Ga nɛ bu gari nɛ na zhɛ wu tun ba yi mu. ");
INSERT INTO myk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ga wee Tɛgɛvɔɔ wu ba ba, wu na ba li shɛ koŋɔ sipyii na, na puyɛ pu wa faanna jurumu shizhaa na, na puyɛ faanna Kilɛ wo tiimɛ pu keree shizhaa na, na puyɛ faanna Kilɛ wo kiiri wu keree shizhaa na. ");
INSERT INTO myk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Puyɛ pu wa faanna jurumu shizhaa na, bani pu ya dà nɛ na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Puyɛ pu wa faanna Kilɛ wo tiimɛ keree ki shizhaa na, bani nɛ gaaŋi na To Kilɛ yíri; lee funŋɔ ni yi wa da ba na ɲa nige wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Puyɛ pu wa faanna Kilɛ wo kiiri wu keree shizhaa na, bani kiiri ya kɔn xɔ ke koŋɔ ke wo ɲuŋɔfɔɔ wu na. ");
INSERT INTO myk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Keree niɲɛhɛŋɛɛ wa nɛ mu na jo yee mu sanha, ga lʼa waha yee mu yee pu já kee ɲaha cɛ nimɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Can Munaa lemu lʼa can wu shɛɛ ge, lee ba ba tuun wemu ni, lee na ba yi ɲaha co, na can wu bɛɛri shɛɛ yi na. Bani jomɔ pe lʼa da ba yu yi mu ge, lʼa da ba pee yu liyɛ pyaa wo sefɛɛrɛ ni wɛ. Ga jomɔ pemu lʼa da ba nuri Kilɛ ɲɔ na ge, li na ba pee yu yi mu. Li na ba keree nibaŋaa bɛ yu yi mu. ");
INSERT INTO myk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Li na ba nɛ mɛgɛ ki pɛlɛ, bani jomɔ pe pu wa nɛ mu ge, li na ba pee luu na yu yi mu. ");
INSERT INTO myk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yaaga tuugo bɛɛri ki ɲɛ To Kilɛ mu ge, yee bɛɛri ɲɛ nɛ woyo. Lee wuu na nɛ yu jo Kilɛ Munaa lʼa da ba nɛ wo kafila wu luu na yu yee mu.» ");
INSERT INTO myk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Lee kadugo na a Yesu di wu kalaapiire ti pye: «Jɛri tapyege ni yʼa da wii vɔɔ na ni; ga jɛri wa bɛ bu bye sanha lee kadugo na, yi na nɔhɔ na ɲa.» ");
INSERT INTO myk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ba Yesu ya yee jo wɛ, a wu kalaapiire ta di ganha na puyɛ yegee na: «Aa, ye wʼa jo mɛ ge, yee kɔri di wa dii wɛ? Wʼa jo na: ‹Jɛri tapyege ni yʼa da wii vɔɔ na ni, ga jɛri wa bɛ bu bye sanha lee kadugo na, yi na nɔhɔ na ɲa.› Na jo sanha na: ‹Nɛ gaaŋi To Kilɛ yíri.› ");
INSERT INTO myk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wee ‹Jɛri› we kaa wʼa yu ge, wee kɔri ɲɛ dii wɛ? Ye wʼa yu ge, wèe kunni ya yee ɲa wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A Yesu di li cɛ na kalaapiire ti funŋɔ ki bye tʼi wu yege, a wu pu pye: «Nɛ yee pye jo: ‹Jɛri tapyege ni yʼa da wii vɔɔ na ni, ga jɛri wa bɛ bu bye sanha lee kadugo na, yi na nɔhɔ na ɲa ge,› pee jomɔ pe na bɛ yee wa yiyɛ yegee wɛ? ");
INSERT INTO myk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Can can na, nʼa da yi jo yi mu, yee kunni na ba sii mɛhɛɛ su xuuni, na tataara jomɔ yu; lee di ke koŋɔ ke sipyii ta pee na fundanga pyi. Yee ɲahaya na ba danha, ga yi ɲatanhaŋa ki na ba ɲɛri yi mu fundanga. ");
INSERT INTO myk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cee yacɛrɛ bu yìri, wu ɲaha ki ma danha fo xuuni, bani wu tigiduun wu ma nɔ. Ga wu bu digi xɔ, pya wemu na wʼa tigi ge, wee pya wu wo ɲɛɲaa wo fundanga funŋɔ ni, wu funŋɔ na wɔ wu kanhama pu bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mu li wa yee bɛ mu, yee ɲahaya kunni wa tanha nimɛ. Ga nɛ na ba guri yee ɲa sanha, yee zɔlɔɔ pu na ɲi fundanga na. Kee fundanga ke, wa shishiin wa da já ba kee shɔ yi na wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kee caŋa ki ba jo kʼa nɔ ge, yee wa da nɛ yege nige kaa la shishiin na wɛ. Can can na, nʼa da yi jo yi mu, yaaga tuugo bɛɛri yʼa da ba ɲɛɛri To Kilɛ mu nɛ mɛgɛ na ge, wu na kee kan yi mu. ");
INSERT INTO myk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ali nimɛ bɛ ni yee sanha yaaga ɲɛɛri To Kilɛ mu nɛ mɛgɛ na wɛ. Yʼa Kilɛ ɲɛɛri, wu na da yi kaan, kɔnhɔ yi fundanga ki ɲɔ di fa.» ");
INSERT INTO myk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","A Yesu di jo sanha na: «Ayiwa, nɛ kunni wa kafila taleŋɛɛ taga yee kalaa kii keree kii bɛɛri ni. Ga caŋa ka na ba nɔ, nʼa da ba yee kalaa nige ni kafila taleŋɛɛ ni wɛ; nʼa da ba To Kilɛ wo keree ki fiinŋɛ da yu yi mu. ");
INSERT INTO myk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kee caŋa ki ba nɔ, yi na ba yi ɲidaan ɲɛɛri To Kilɛ mu nɛ mɛgɛ na. Ɲuŋɔ wa da ba bye lee na kanna nɛ wu na pa To Kilɛ ɲɛɛri yee mu, wu na yee wo ɲɛrɛgɛ ki co wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bani yee ya dan To Kilɛ yɛ pyaa ki ni. Yee ya dan wu ni, bani nɛ bɛ ya dan yee ni, yee dʼa nɔhɔ dà bɛ li na na Kilɛ ni nɛ foro. ");
INSERT INTO myk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Can wu ɲɛ wii To Kilɛ yíri nɛ yìri na pa koŋɔ puga; nimɛ nʼa da voro koŋɔ puga di guri da se To Kilɛ yíri.» ");
INSERT INTO myk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A wu kalaapiire tʼi wu pye: «Nimɛ kunni, mʼa yi fiinŋɛ na yu wù mu, nimɛ woyo yi wa kafila taleŋɛɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nimɛ kunni, wʼà li cɛ na mʼa keree bɛɛri cɛ, yegeye yemu bɛ yi da ba bye mu na ge, mu ya yee bɛ cɛ na ta pu sanha yi pye mu na wɛ. Lee na wèe ya dà li na na Kilɛ ni mu ya foro.» ");
INSERT INTO myk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A Yesu di pu pye: «Yʼa jo na yee wa daa nɛ na nimɛ gɛ? ");
INSERT INTO myk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ayiwa, caŋa ka wa ma, kʼa nɔ xɔ bɛ, yee bɛɛri na ba baa jaaga na nɛ yɛ nigin yaha wà, wa bɛɛri wʼa ganha na gaaŋi wu kaban. Ga nɛ wa da ba bye na yɛ nigin wɛ dɛ, bani na To Kilɛ wu wa ni na ni. ");
INSERT INTO myk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nɛ kii keree kii bɛɛri jo yi mu, kɔnhɔ yʼi loɲinɛ ta nɛ wo kariɲɛɛgɛ ki ni. Kanhama nigbɔ na ba nɔ yi na ke koŋɔ ke na, ga yi la le yiyɛ ni! Nɛ kunni ya se ta na xɔ koŋɔ na.» ");
INSERT INTO myk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ba Yesu ya yee jo mu wɛ, na wu ɲuŋɔ yirige fugba we ni na Kilɛ ɲɛɛri na: «To Kilɛ, tuun wʼa nɔ nimɛ. Pɛɛŋɛ taha ma Ja wu na, kɔnhɔ ma Ja wu bɛ di pɛɛŋɛ taha ma na. ");
INSERT INTO myk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bani mʼa sefɛɛrɛ kan wu mu, na wu teŋɛ koŋɔ ke sipyii pu bɛɛri ɲuŋɔ ni, sipyii piimu bɛɛri mʼa yiri pa wu mu ge, kɔnhɔ wu ɲìi sicuumɔ nixhɔbaama kan pee mu. ");
INSERT INTO myk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ɲìi sicuumɔ nixhɔbaama pe, pee ɲɛ na mu Kilɛ cɛ, mu wemu wu ɲɛ nigin pe na ɲɛ can can wo ge. Yesu Kirisa wemu bɛ mʼa tun na pa ge, pʼi wee bɛ cɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nɛ mu pɛlɛ ɲiŋɛ ki na; kapyeŋɛɛ kii ma bi kan na mu di bye ge, nɛ kee bɛɛri pye na ki ɲɔ fa. ");
INSERT INTO myk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nɔɔrɔ taha na na nimɛ To Kilɛ, di binnɛ bye ni ma ni. Nɔɔrɔ we wu bi fɛnhɛ pye nɛ na na koŋɔ ta ki sanha ɲɔ kɔn wɛ ge, wee nɔɔrɔ we taha na na.» ");
INSERT INTO myk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Sipyii piimu mʼa lɔ koŋɔ sipyii pu ni na kan nɛ mu ge, nɛ mu kaa jo pu mu, kɔnhɔ pʼi ma cɛ. Mu wuu pu bye pii, a mu di pu kan nɛ mu. A pu bɛ di sɔɔ na ma jomɔ pu co. ");
INSERT INTO myk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nimɛ kunni, pʼa li cɛ na lemu bɛɛri mu ya kan nɛ mu ge, na lee bɛɛri ya foro muyɛ pyaa ki ni. ");
INSERT INTO myk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bani jomɔ pemu mu ya kan nɛ mu ge, pee jomɔ pe nɛ kan pu mu, a pʼi sɔɔ pu na. Pʼa li cɛ can can na na mu ni nɛ foro, na dà bɛ li na na mu wʼa nɛ tun. ");
INSERT INTO myk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pee wuu na nɛ mu ɲɛɛri. Nɛ ta na ma ɲɛɛri koŋɔ ke wo sipyii pii wuu na-ɛ dɛ, ga piimu mʼa kan nɛ mu ge, pee wuu na, bani mu wuu pu ɲɛ pii. ");
INSERT INTO myk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaaga kemu bɛɛri ki ɲɛ nɛ wogo ge, mu wogo ki ɲɛ kii, yaaga kemu bɛɛri ki ɲɛ mu bɛ wogo ge, nɛ bɛ wogo ki ɲɛ kii. Pɛɛŋɛ ke ki wa nɛ na ge, Kalaapiire ti tʼa kee pɛɛŋɛ ki shɛɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nɛ na ba foro koŋɔ puga ni, ga pee kunni na gori naha ke koŋɔ ke na. Nɛ na ba shɛ ma yíri. To Kilɛ, mu wemu wu wa fɛɛfɛɛ ge, pu mara ma mɛgɛ ki sefɛɛrɛ ti gbɔɔrɔ ni, tee sefɛɛrɛ temu mʼa kan na mu ge; kɔnhɔ pʼi binnɛ, pʼi bye nigin ba nɛ ni mu wa nigin mɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɛ bye ni pu ni koŋɔ na tuun wemu ni ge, nɛ bi pu mara ni mu wo sefɛɛrɛ ti ni, mʼa bi tee sefɛɛrɛ temu kan nɛ mu ge. Nɛ pu bɛɛri mara, nigin bɛ ya ta buun wu munaa ni wɛ, fo wemu wu bi yaa wu buun wu munaa ni, kɔnhɔ yemu yʼa ka Kilɛ wo Kitabu wu ni ge, yee ɲɔ di fa ge, fo wee yɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Ga mu yíri nʼa da zhɛ nimɛ. Nɛ ye bɛɛri yu na na yaha naha sanha koŋɔ ke na, kɔnhɔ fundanga ke ki ɲɛ nɛ ni, ki ɲɔ na fa ge, kee di bye pu bɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nɛ mu wo jomɔ pu kan pu mu, a koŋɔ sipyii di pu kɔ; bani pu ɲɛ ke koŋɔ ke wuu wɛ, ma na jo ba nɛ bɛ wa mɛ nɛ ɲɛ ke koŋɔ ke wo wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Di wʼa ma ɲɛɛri na go ma pu lɔ yeege ke koŋɔ puga ke ni wɛ, ga nʼa ma ɲɛɛri jo ma pu mara, mʼa pu tanha Shitaanni na. ");
INSERT INTO myk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Pu ɲɛ ke koŋɔ ke wuu wɛ, ma na jo ba nɛ bɛ wa mɛ nɛ ɲɛ ke koŋɔ ke wo wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ma wo can wu taga pu pye fɛɛfɛɛ. Mu wo kafila wu wu ɲɛ can we. ");
INSERT INTO myk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tungana lemu na mʼa na tun na pa koŋɔ puga ge, lee tungana le na nɛ bɛ ya pu tun shɛ koŋɔ ki na. ");
INSERT INTO myk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nɛ nayɛ waa yaha fɛfɛɛrɛ ni mu mu pee wuu na, kɔnhɔ pu bɛ di puyɛ waa yaha pʼi bye fɛɛfɛɛ can wu ni. ");
INSERT INTO myk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Nɛ ta na ma ɲɛɛri pii yɛ wuu na-ɛ dɛ, ga piimu bɛ pu da ba dà nɛ na pu jomɔ pu funŋɔ ni ge, pee bɛ wuu na nʼa ma ɲɛɛri, ");
INSERT INTO myk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","kɔnhɔ pu bɛɛri di binnɛ, pʼi bye nigin, ba mu To Kilɛ ɲɛ mɛ ni nɛ ni, nɛ bɛ di ɲɛ mu ni mu ni wɛ. Pʼi binnɛ, pʼi bye nigin ni wèe bɛ ni, kɔnhɔ koŋɔ sipyii di dà li na na mu wʼa nɛ tun. ");
INSERT INTO myk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pɛɛŋɛ ke mu ya kan nɛ mu ge, kee pɛɛŋɛ ke nɛ kan pu bɛ mu, kɔnhɔ pʼi binnɛ pʼi bye nigin ba nɛ ni mu ɲɛ mɛ nigin wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nɛ pinnɛ ni pee ni na pye nigin, mu bɛ dʼa pinnɛ ni nɛ ni na pye nigin; kɔnhɔ pu bɛ di já pinnɛ pʼi bye nigin can can na. Lee bu bye, koŋɔ sipyii na li cɛ na mu wʼa nɛ tun, na pee bɛ ya taan mu mu ba nɛ taan mu mu wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Na To Kilɛ, piimu mʼa kan nɛ mu ge, nɛ na ba shɛ bye xuu wemu ni ge, na funŋɔ ki wa pu bɛ di ba shɛ bye wà ni na ni. Nɔɔrɔ we mʼa kan na mu ge, kɔnhɔ pʼi wee nɔɔrɔ we ɲa, bani nɛ taan mu mu na ta koŋɔ sanha nɔhɔ shan wɛ. ");
INSERT INTO myk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","To Kilɛ, mu wemu wʼa tii ge, koŋɔ ya ta mu cɛ wɛ; ga nɛ kunni dʼa mu cɛ. Piimu mʼa kan nɛ mu ge, pee bɛ ya li cɛ na mu wʼa nɛ tun. ");
INSERT INTO myk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɛ pu pye pʼa mu cɛ, nɛ sanha di wa da da pu pyi pʼa ma cɛni. Nʼa taan ma mu taangana lemu na ge, kɔnhɔ kee taanɲɛɛgɛ ke tuugo di já pye pu tɛ ni, nɛ bɛ di binnɛ bye ni pu ni nigin.» ");
INSERT INTO myk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ayiwa, ba Yesu ya yee jo xɔ wɛ, a wu ni wu kalaapiire tʼi yìri kari Sedɔrɔn dugo ki kadugo yíri. Tiire kɛrɛyɛ ya yi bye wee xuu wu ni, a pʼi shɛ jé yee ni. ");
INSERT INTO myk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zhudasi we wu bi da ba Yesu nɔhɔ yaha ge, lee bi wee ta wee bɛ ya yee tiire kɛrɛyɛ yi sanha cɛ. Bani Yesu bi tee na se wà ni wu kalaapiire ti ni. ");
INSERT INTO myk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Na Yesu ni wu kalaapiire ti yaha wee xuu wu ni, a Zhudasi di nɔ. Wu ni sɔrɔsii ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii pii pu bye. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Farizhɛɛn pu bi pee pinnɛ ni Zhudasi ni. Namuuyɔ ni sokinnaa ni pu bye, yagboyo bɛ di ɲɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Keree kiimu bɛɛri ki bi da ba bye Yesu na ge, wu bi kee bɛɛri cɛ xɔ. A wu fulo pii sipyii pii na na pu yege na: «Jɔgɔ yee di zhaa wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","A pʼi jo: «Nazarɛti shɛɛn Yesu.» A Yesu di pu pye: «Nɛ wu ɲɛ wii!» Zhudasi we wu bi Yesu nɔhɔ yaha ge, lee bi wee bɛ ta ni pu ni. ");
INSERT INTO myk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ba Yesu ya pu pye: «Nɛ wu ɲɛ wii!» wɛ, a pʼi guri guri kaduma, na laha laha to ɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","A Yesu di guri pu yege sanha na: «Jɔgɔ yee di zhaa wɛ?» A pʼi wu ɲɔ shɔ na: «Nazarɛti shɛɛn Yesu.» ");
INSERT INTO myk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","A Yesu di pu pye: «Go nɛ yee pye jo nɛ wu ɲɛ wii. Yee bu da yee na nɛ shaa, yi pii samaa yaha pee di da gaaŋi.» ");
INSERT INTO myk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lee funŋɔ ni jomɔ pemu Yesu bi jo ge, a pee di bye can, na: «Na To Kilɛ, piimu bɛɛri mʼa kan nɛ mu ge, nigin bɛ ya piin nɛ mu pu ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lee bi ŋmɔpara la ta Simɔ Pyɛɛri mu, a wee di lee kɔ li forogo ni, na saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo bulo kanige cɛ niwɛŋɛ paa laha. Wee kapyebye we mɛgɛ ki bye na Malikusi. ");
INSERT INTO myk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A Yesu di Pyɛɛri pye: «Ma ŋmɔpara le le wà li forogo ki ni! Wee tuun wu ni, nɛ To Kilɛ wʼa kanhama pemu gbegele yaha nɛ ɲaha na ge, mu funŋɔ wa nɛ wu jé pee ni-i gɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ayiwa, ba Yesu ya yee jo wɛ, a sɔrɔsii ni pu wo ɲuŋɔfɔɔ we, ni Yawutuu gɛdii pʼi Yesu co na wu keye ye pɔ. ");
INSERT INTO myk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A pʼi fɛnhɛ shɛ ni wu ni Anɛ mu, wee bye Kayifɛ wo yafena; Kayifɛ di bi bye saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we lee yee le. ");
INSERT INTO myk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wee Kayifɛ wu wʼa bi pe jomɔ pe taga Yawutuu ɲuŋɔfɛɛ pu yɛri na: «Ta yee ya li cɛ na jo lʼa pɔrɔ yee mu na shɛn nigin wu xu sipyii pu bɛɛri wuu na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ayiwa, ba pʼa gaaŋi ni Yesu ni wɛ, a Simɔ Pyɛɛri ni kalaapire la bɛ di daha pu fɛni na gaaŋi. Macɛŋɛ ki bye lee kalaapire le ni saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu tɛ ni; lee lʼa pye kaɲuŋɔ a lee kalaapire lʼi jé ni pu ni saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu kaaŋa ki ni. ");
INSERT INTO myk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","A Pyɛɛri di ba yere kpɛɛngɛ ki na, kuɲɔɔ li ɲɔ na. Lee kalaapire lemu lʼa pye saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu cɛvɔɔ ge, a lee di guri foro kpɛɛngɛ ki na. Cee wemu wu bi kuɲɔɔ li ɲɔ sigee ge, a wu ba jo ni wee ni, na Pyɛɛri leŋɛ kaaŋa ki ni. ");
INSERT INTO myk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ayiwa, ba Pyɛɛri ya jin kaaŋa ki ni wɛ, cee we wʼa kuɲɔɔ li sigee ge, a wee di wu pye: «Ta mu bɛ bɛ wu wa we ná we wo kalaapiire ti ni wɛ?» A Pyɛɛri di wu ɲɔ shɔ na: «Ahayi, nɛ wa pu ni-i dɛ!» ");
INSERT INTO myk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wiire tuun wu bye wii, a kapyebyii pu ni sɔrɔsii pʼi na gbɛri na wahani. A Pyɛɛri bɛ di ba yere pu tàan na ganha na wahani. ");
INSERT INTO myk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ayiwa, a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu Yesu yege wu kalaapiire te ni wu kalaa wu keree na. ");
INSERT INTO myk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Yesu di wu pye: «Nɛ kunni, kpɛɛngɛ na nɛ bi ma yu sipyii pu bɛɛri ɲii na. Nɛ bi sipyii pu kalaa Kilɛ-pɛɛŋɛ piyɛyɛ ye, ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Wee xuu wu ni bɛ Yawutuu pu bɛɛri bi ma puyɛ pinnɛ. Nɛ ta na jomɔ pa shishiin jo ŋmɔhɔrɔ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ɲaha na ma di na yegee wɛ? Piimu pʼa na jomɔ pu logo ge, pee yege na dii nɛ dʼa pu kalaa wɛ. Nɛ yemu jo ge, pʼa yi cɛ can can na.» ");
INSERT INTO myk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ba Yesu ya yee jo wɛ, lee di Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdi wa ta wu tàan. A wee di kadaa ja wu ɲibɛgɛ ni, na wu pye: «Saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo ɲɔ shɔgana li wa le mu mu ya?» ");
INSERT INTO myk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A Yesu di wu pye: «Nɛ bu da nɛ kafilakuumɔ jo, lemu lʼa wu kolo ge, lee jo. Ga ye nɛ jo ge, yee bu da yʼa tii tajogo ni, ɲaha na ma dʼa na kpɔn wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A Anɛ di pɔɔrɔ ti yaha wà Yesu na, na wu yaha shɛ gan Kayifɛ mu, saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we. ");
INSERT INTO myk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lee bi Simɔ Pyɛɛri ta sanha na ki tàan na wahani. A sipyii pii di wu yege na: «Ta mu bɛ bɛ wu wa we ná we wo kalaapiire ti ni wɛ?» Ga, a Pyɛɛri di foro wu kaa tàan na jo: «Ahayi, nɛ wa pu ni-i dɛ!» ");
INSERT INTO myk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ná wemu wo niwɛŋɛ Pyɛɛri ya paa laha ge, wee wo ceborona wa bɛ wu bye saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu kapyebye wa. A wee di Pyɛɛri pye: «Wee tuun wu ni, ta nɛyɛ pyaa ya mu ɲa ni wu ni shiizhan tiire kɛrɛyɛ yi ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ga, a Pyɛɛri di guri jo sanha na yi ɲɛ can wɛ, a xhupoo di mɛɛ su taapile ni. ");
INSERT INTO myk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lee kadugo na a pʼi foro ni Yesu ni Kayifɛ kaban, na gari ni wu ni Oromɛ gbafɛnɛɛri wu kaaŋa ki ni. Lee ya pye ɲimuguɲɔ wu na. Yawutuu ɲuŋɔfɛɛ pu ya ta sɔɔ na jé kaaŋa ki ni wɛ, kɔnhɔ pʼi gori yaha fɛɛfɛɛ na bɛ ni pu wo kalɛgɛɛ ki ni, kɔnhɔ pu bɛ di ba já Ɲuwuuro ti wo Kalenɛ li yalige ki li. ");
INSERT INTO myk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lee lʼa Pilate pye wʼa foro pa pu yíri kpɛɛngɛ ki na, na ba pu yege na: «Lekɛ we ná we dʼa pye yʼi wu jaagi lee na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A pʼi Pilate pye: «We ná we da bye wu ɲɛ kakuubye wɛ, wèe bi da ga ba ni wu ni mu mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","A Pilate di pu pye: «Yʼa se ni wu ni yiyɛ pyaa di shɛ kiiri kɔn wu na na bɛ ni yi wo saliya wu ni.» A pʼi Pilate pye: «Li ya saha wèe pu sipya wa shishiin gbo wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Lee ya pye mu, kɔnhɔ Yesu bi jomɔ pemu jo na wee na ba xhu xugana lemu na ge, pee ɲɔ di fa. ");
INSERT INTO myk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wee tuun wu ni a Pilate di guri jé gbafɛnɛɛri wu kaaŋa ki ni, na Yesu yiri na wu yege na: «Yawutuu wo saan mu ɲɛ ya?» ");
INSERT INTO myk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Yesu di Pilate pye: «Muyɛ pyaa kʼa ye kɔn mayɛ funŋɔ ni na jo laa, ta watii wʼa yi jo mu ɲii na?» ");
INSERT INTO myk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","A Pilate di wu pye: «Wee tuun wu ni, ma na ɲa Yawutu gɛ? Muyɛ pyaa shishiin ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ, pee pʼa pa ni ma ni nɛ mu, na nɛ wu kiiri kɔn ma na. Lekɛ ma dʼa pye pu na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","A Yesu di wu pye: «Nɛ wo saanra ti wa naha ke koŋɔ ke na wɛ. Nɛ wo saanra ti da bi bye naha ke koŋɔ ke na, nɛ wo sipyii pu bi da kashɛn ŋmɔ nɛ kaa na, kɔnhɔ Yawutuu ɲuŋɔfɛɛ pu ganha bu já nɛ co wɛ. Ga nɛ wo saanra ti ɲɛ naha ke koŋɔ ke na wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A Pilate di Yesu pye: «Wee tuun wu ni saan mu ɲɛ gɛ?» A Yesu di wu pye: «Mayɛ pyaa ki wa yi yu na saan nɛ ɲɛ; can wu ɲɛ wii. Ga lemu na nɛ se koŋɔ ke na ge, lee li wa mɛ, na can wu shɛɛ sipyii pu na. Sipya wemu funŋɔ ki ɲɛ wu da ɲaari can ni ge, weefɔɔ wu da da nɛ jomɔ nuri.» ");
INSERT INTO myk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","A Pilate di wu pye: «Ɲaha ki ɲɛ can wɛ?» Ba Pilate ya yee jo wɛ, na foro kari sanha Yawutuu pu yíri na shɛ pu pye: «Nɛ mu kunni, nɛ kaa la shishiin ɲa we ná we na lemu lʼa wu kagbuu xɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ayiwa, ma na jo lee wa wù mu kalɛɛ, na jo yee bɛɛri, ba Ɲuwuuro ti wo Kalenɛ lʼa nɔ wɛ, di ma kasolemɛ wa yaha yi mu. Lee funŋɔ ni yi la ɲɛ di Yawutuu pu wo saan wu yaha ya?» ");
INSERT INTO myk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A pʼi ganha na sɛlɛ na yu: «Ahayi dɛ! ma ganha bu wee yaha wɛ, Barabasi yaha!» Na ta wee Barabasi we di bi dun sipyii na. ");
INSERT INTO myk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ayiwa, Pilate ya li ta mu ge, a wu jo na pu Yesu kpɔn ni susɔlɔɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A sɔrɔsii pʼi xhuyo shin na pye saanra ɲudɔnɔ, na lee tɔ wu ɲuŋɔ ni. Na saannaa fadegbɔhɔ niɲiga ka le wu na. ");
INSERT INTO myk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A pʼi ganha na fuloo wu na na yu: «Ɲaabye Yawutuu saan!» Na ganha na kadawahaa leni wu ni. ");
INSERT INTO myk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A Pilate di guri foro sanha kpɛɛngɛ ki na na shɛ sipyiire ti pye: «Nʼa da pu pye pʼi foro naha ni wu ni kpɛɛngɛ ki na, kɔnhɔ yʼi li cɛ na jo nɛ ta kaa la shishiin ɲa we ná we na lemu lʼa wu kagbuu xɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","A pʼi foro ni Yesu ni, xhuyo ɲudɔnɔ li na ɲɛ wu na, saannaa fadegbɔhɔ niɲiga ki bɛ di ɲɛ wu na. A Pilate di sipyiire ti pye: «Ayiwa, ná wu we!» ");
INSERT INTO myk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ba saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii pʼa Yesu ɲa wɛ, na ganha na xhuulo, na yu: «Yi wu kori tige na! Yi wu kori tige na!» A Pilate di pu pye: «Yiyɛ pyaa ki pa wu co shɛ gori tige ki na, bani nɛ kunni wa kaa la shishiin ɲa we ná we na lemu ya wu kagbuu xɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A Yawutuu ɲuŋɔfɛɛ pʼi Pilate pye: «Saliya wa wu ɲɛ wee mu, na saha ni wee saliya wu ni, wʼa yaa na gbo; bani wʼa wuyɛ yaha na Kilɛ ja wee ɲɛ.» ");
INSERT INTO myk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ba Pilate ya pee jomɔ pu logo wɛ, a wusama di fya. ");
INSERT INTO myk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A wu guri jé ni Yesu ni gbafɛnɛɛri wu kaaŋa ki ni sanha, na shɛ wu yege na: «Mii mu dʼa yìri wɛ?» Ga Yesu ya ta wu ɲɔ shɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Pilate di Yesu pye: «Go nɛ na mʼa fɛhɛ gɛ? Ta mu ya li cɛ na jo se wa nɛ ni nɛ wu mu yaha wɛ? Se dʼa nɔhɔ pye bɛ nɛ ni sanha nɛ wu mu kori tige na wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A Yesu di wu pye: «Kilɛ wʼa wee se wu kan mu mu niɲaa, lee bɛ wɛ muyɛ pyaa wo se bi da ga já bye nɛ na kaa la shishiin na wɛ. Lee funŋɔ ni, wemu wʼa nɛ co na pa gan mu mu ge, lee lʼa wee wo jurumu wu pye wʼa ɲɛhɛ mu wo wu na.» ");
INSERT INTO myk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ba Yesu ya yee jo wɛ, a Pilate di ganha na yahagana shaa wee tuun wuyɛ pyaa ni Yesu na. Ga, a Yawutuu pʼi ganha na sɛlɛ na yu: «Ma bu sii we ná we yaha, ma ɲɛ nige Oromɛ saannaa ɲuŋɔfɔɔ Sezari naɲii wɛ. Sipyaa sipya wʼa jo na saan wee ɲɛ ge, weefɔɔ ya ɲɛri Oromɛ saannaa ɲuŋɔfɔɔ wu pɛn.» ");
INSERT INTO myk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ba Pilate ya yee logo wɛ, na Yesu yeege sanha kpɛɛngɛ ki na. Pu bi xuu wa yaa wà nɔhɔdaan wu ni ni kagereye ni kaaŋa ki ni. Wee xuu wu mɛgɛ ki bye Yawutuu jomɔ pu ni na: «Gabata.» A Pilate di ba diin wu kiirikɔɔn koro li ni wee tuun wu ni. ");
INSERT INTO myk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kee caŋa ki ɲimuguro ti bi da bye Yawutuu wo Ɲuwuuro ti wo Kalenɛ le. Na caŋa ki ta kʼa nɔ ɲiŋɛ niŋɛ ni, a Pilate di Yawutuu ɲuŋɔfɛɛ pu pye: «Yi saan wu we.» ");
INSERT INTO myk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","A pʼi ganha na xhuulo na yu: «Yi wu yeege naha! Yi wu yeege naha! Yi wu kori tige na!» A Pilate di pu pye: «Nɛ wu da yee wo saan wu kori tige na ya?» A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi wu pye: «Saan watii ɲɛ nige wèe mu Oromɛ saannaa ɲuŋɔfɔɔ Sezari kadugo na wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wee tuun wu ni a Pilate di Yesu ɲɔ yaha pu mu, na pu shɛ wu kori tige na. A sɔrɔsii pʼi Yesu co, na foro ni wu ni kanha ki ni, ");
INSERT INTO myk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","na wuyɛ pyaa wo korikoritige ki taha wu ɲuŋɔ ni. A pʼi ganha na gaaŋi xuu wà ni, wee mɛgɛ ɲɛ na: «Ɲugɔrɔgɔ xuu» pʼi wu yiri Yawutuu jomɔ pu ni na «Goligota.» ");
INSERT INTO myk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A pʼi shɛ wu kori tige na wà. A pʼi sipyii shuun wa bɛ pinnɛ kori ni wu ni. Wa ɲɛ wu kanige cɛ; wa ɲɛ wu kamɛnɛ cɛ. A Yesu yɛ pyaa di bye pu niŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A Pilate di pu pye pʼa kama pa ka kɔɔrɔ la na, na lee kori korikoritige ki na wu ɲuɲɔ na. Pee kama pu pe na: ");
INSERT INTO myk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yawutuu niɲɛhɛmɛɛ pu bi pee kama pu kalaa, bani pʼa bi Yesu kori xuu wemu ni ge, wee xuu wu bi lii kanha ki na wɛ. Pee kama pu bɛ di bi ka Yawutuu jomɔ pu ni, na pu ka Oromɛ shɛɛn jomɔ pu ni, na pu ka Girɛkii jomɔ pu bɛ ni. ");
INSERT INTO myk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼi shɛ Pilate pye: «Mu bi yaa mu yi ka na ‹Yawutuu saan wɛ,› ga mu bi yaa mu yi ka na: ‹We ná we ya jo na Yawutuu saan wee ɲɛ.›» ");
INSERT INTO myk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A Pilate di pu pye: «Nɛ yemu ka na xɔ ge, yee yʼa da bye wà.» ");
INSERT INTO myk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ayiwa, ba sɔrɔsii pʼa Yesu kori xɔ tige ki na wɛ, na wu fàya yi shan tahaa shishɛɛrɛ, wa bɛɛri wʼa taa la lɔ. A pʼi wu fadegbɔhɔ ki bɛ lɔ, kee fadegbɔhɔ ke di bye fàŋa nigin, joomɔ baa. Na lɔ fugba wu na, na digi nɔhɔdaan, tajɔɔgɔ bye ki na xuu wa shishiin ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","A sɔrɔsii pʼi puyɛ pye: «Wù ganha bu da wu fadegbɔhɔ ki shɛɛngi wɛ, wù kagaanshaan pye ki na, ki na nɔ wemu na ge, kɔnhɔ wù wee cɛ.» Ba lee ya pye mu wɛ, yemu yʼa ka Kilɛ Kafila wu ni ge, a yee ɲɔ di fa na: «Pʼa na fàya yi taa taa puyɛ na, na kagaanshaan pye na fadegbɔhɔ ki wuu na.» Lee sɔrɔsii pʼa pye. ");
INSERT INTO myk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lee bi Yesu nu Mariyama, ni wu nu wu ceboroshɔ, ni Kilopasi shɔ Mariyama, ni Magadala shɛɛn Mariyama yɛ ta pee ya yere Yesu korikoritige ki tàan. ");
INSERT INTO myk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ba Yesu ya wu nu wu ɲa wɛ, kalaapire lemu kaa li bi dan wu ni ge, na lee bɛ ɲa nufɔɔ wu tàan wɛ, a wu wu nu wu pye: «Nufɔɔ we, ma ja wu we.» ");
INSERT INTO myk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Lee kadugo na a wu lee kalaapire li bɛ pye: «Ma nu wu we.» Na co kee caŋa ki na, a lee kalaapire lʼi gari ni Yesu nu wu ni wu kaban, na wu co xuuni. ");
INSERT INTO myk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lee kadugo na ba Yesu ya li cɛ na keree ki bɛɛri ɲɔ ya fani fo na pa nɔ we tuun we na wɛ, a wu jo: «Waga ki wa nɛ na.» Wʼa yee jo, yemu yʼa ka Kilɛ Kafila wu ni ge, kɔnhɔ yee bɛ ɲɔ di fa. ");
INSERT INTO myk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lee bi shɔɔ la ta wà lee ya ɲi vinɛgiri na. A pʼi yoro ta lɔ fyɛnmi wee vinɛgiri wu ni, na tee migile kagaanga ka na na taha Yesu ɲɔ na. Tige kemu wo geŋɛ kʼa bye kagaanga ki ge, kee mɛgɛ ki ɲɛ na «Izopu.» ");
INSERT INTO myk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ba wʼa tee yoro ti sɔn sɔn wɛ, na jo: «Keree ki bɛɛri ɲɔ ya fa nimɛ.» Ba wʼa yee jo wɛ, na wu ɲuŋɔ sogi, na wu munaa li kan Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ayiwa, kee caŋa ki bye Yawutuu wo cadɛɛngɛ ki cadanga. Sipyii piimu pʼa kori tiye yi na ge, Yawutuu ɲuŋɔfɛɛ pu funŋɔ bye pee pu cadɛɛngɛ ki ta wà wɛ. Bani kee cadɛɛngɛ ki bi kiyɛ waa cadɛɛnyɛ yi saya na. Lee wuu na pʼa shɛ Pilate ɲɛɛri, sipyii piimu pʼa kori kori ge, na wu pee yaha pʼi shɛ pee tɔɔyɔ kɛgi kɛgi pʼi xhu tɔvuyo na, kɔnhɔ pʼi pu tirige laha tiye yi na. ");
INSERT INTO myk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A sɔrɔsii pʼi gari, sipyii shuun wemu pʼa pinnɛ kori ni Yesu ni ge, a pʼi shɛ nɔ na nizhiimɛ wu tɔɔyɔ kɛgi kɛgi, na ɲɛri shuun wo wu yíri, na wee bɛ tɔɔyɔ kɛgi kɛgi. ");
INSERT INTO myk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba pʼa nɔ Yesu na wɛ, na wee ta wee ya xu xɔ, na bye pu ya wee wo tɔɔyɔ yi kɛgi kɛgi wɛ. ");
INSERT INTO myk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ga, a sɔrɔsi nigin wa di wu canmi taga Yesu firi wu kabanugo na. Taapile ni, a shishan ni lɔhɔ di foro tafirige ki ni. ");
INSERT INTO myk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sipya wemu wʼa pe jomɔ pe paari mɛ ge, weefɔɔ yɛ pyaa kʼa le ɲa ɲii na. Wu ɲii kaɲagaa ki bɛ di ɲɛ can. Wuyɛ pyaa ki bɛ wa dà li na na wee ɲii kaɲagaa ki ɲɛ can. Wʼa kii keree kii paari, kɔnhɔ yee bɛ di dà ki na. ");
INSERT INTO myk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ayiwa, kii keree kii bɛɛri ya pye mu ge, yemu yʼa ka Kilɛ Kafila wu ni ge, a yee ɲɔ di fa na: «Wu kaciige ka shishiin wa da ba gɛgi wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lʼa ka sanha xuu wa bɛ ni Kilɛ Kafila wu ni na: «Sipya wemu pʼa firi ge, wee pʼa da ba wii.» ");
INSERT INTO myk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lee kadugo na a Arimate shɛɛn Yusufu di shɛ Pilate ɲɛɛri na wu sɔɔ pee mu, pʼi shɛ Yesu nixhugo ki tirige laha tige ki na. A Pilate di sɔɔ pu mu. Yusufu bɛ bi bye Yesu wo kalaapire la, ga Yawutuu pu wo ɲìi fyaara ti bi wu pye wu na ŋmɔhɔni. A wu gari na shɛ Yesu nixhugo ki tirige. ");
INSERT INTO myk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ayiwa, Nikodɛmu wemu wu bi shɛ Yesu yíri caŋa ka piige ge, a wee bɛ di ba ni nudanga yaŋmuyɔ tɛhɛɛ shuun wa ni, na yi suri yiyɛ ni. Nigin wa mɛgɛ ɲɛ na Izopu, nigin wusama mɛgɛ di ɲɛ na alowɛsi. Yi bɛɛri bi yaa yi kiloo kɛlɛɛ taanri (30) xɔ. ");
INSERT INTO myk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A pee shuun wu Yesu nixhugo ki lɔ, na nudanga yaŋmuyɔ yi le fatɔŋɔ ka ni, na kee migile wu na, na bɛ ni Yawutuu pu wo xuu legana li ni. ");
INSERT INTO myk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tiire tɛgɛ ka bye wà kee bi lii Yesu takorogo ki na wɛ. Faŋa ka nidugiyahaŋa di bye kee tɛgɛ ki wo faaya yi ni, sipya bi sanha le ɲa kee ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ba ma na jo kee caŋa ki bye Yawutuu pu wo cadɛɛngɛ ki cadanga ge, a pʼi fyaala shɛ Yesu le kee faŋa ki ni, bani faŋa ki bɛ bi lii wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ayiwa, Dimazhi wu ɲisɔɔgbɔhɔ ki na, na kpɛɛngɛ ta ki sanha wo wɛ, a Magadala shɛɛn Mariyama di gari faŋa ki na. Kageegbɔhɔ ke pu bi gologolo taga faŋa ki ɲɔ tɔ ge, a wu shɛ kee ta kʼa laha faŋa ki ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kalaapire lemu kaa li bi dan Yesu ni ge, a wu baa kari Pyɛɛri ni lee yíri, na shɛ pee pye: «Pʼa Kafɔɔ nixhugo ki lɔ yeege faŋa ki ni, wèe di ya cɛ mii pʼa wu yaha wɛ!» ");
INSERT INTO myk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ba Pyɛɛri ni lee kalaapire lʼa pee jomɔ pu logo wɛ, a pʼi foro, na gari faŋa ki na. ");
INSERT INTO myk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pu shuun wu bɛɛri wu bi fe na gaaŋi faŋa ki na. Ga, a lee kalaapire li tɔrɔ di wɛri Pyɛɛri na, a lee di baa toro Pyɛɛri tàan, na shɛ nɔ wu ɲaha na faŋa ki na. ");
INSERT INTO myk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ba wee ya nɔ faŋa ki na wɛ, na jaari wii ki funŋɔ ni; faviire te pu bi taga Yesu migile ge, a wu tee faviire ti ɲa wà ɲiŋɛ ki na. Ga wu kunni di ya jé faŋa ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A jɛri di bye, a Simɔ Pyɛɛri di nɔ. Ba wee ya nɔ wɛ, na jé faŋa ki ni, na faviire ti ɲa wà ɲiŋɛ ki na. ");
INSERT INTO myk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fàŋa kemu ki bi taga Yesu ɲuŋɔ ki migile ge, a wu kee ta pʼa kee kurulo, na ki yaha ki yɛ xuu ni. Kee bi ta pinnɛ ni te ti faviire ti ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wee tuun wu ni, kalaapire lemu lʼa fɛnhɛ nɔ faŋa ki na ɲaha na ge, a lee bɛ di na jé faŋa ki ni. A wee bɛ di li ɲa mu, na dà li na na Yesu ya ɲɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jomɔ pemu pu bi ka Kilɛ Kafila wu ni ge, na li waha lʼi waha, Yesu ya yaa na ɲɛ na foro xu ni ge, kalaapiire ti bi sanha pee cɛ ta wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wee tuun wu ni a kalaapiire tʼi guri na ma deeye ni. ");
INSERT INTO myk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ayiwa, lee di Mariyama ta wʼa shɛ yere faŋa ki ɲɔ na, na ganha na mɛɛ suu. A wu mɛsuwo wu ba leele, na jaari wii faŋa ki funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na mɛlɛkɛɛ shuun wa ɲa wà, faviire di ɲɛ pu na. Xuu wemu ni pu bi Yesu sinniŋɛ ge, wee xuu wu ni pu bi tiin. Nigin wa wu bye ɲuŋɔ ke xuu we ni, wusama di ɲɛ tɔɔyɔ ye xuu we ni. ");
INSERT INTO myk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A pee mɛlɛkɛɛ pʼi Mariyama pye: «Cee we, ɲaha na mu di wa mɛɛ suu wɛ?» A wu jo: «Nɛ Kafɔɔ wu nixhugo pʼa lɔ, nɛ di ya cɛ mii pʼa wu yaha wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ba wʼa pee jomɔ pu yu wɛ, na ba ŋmahana ɲɛri, na Yesu niyerege ɲa wà; ga wu bi ta li cɛ na jo Yesu wu ɲɛ wii wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A Yesu di wu yege na: «Cee we, ɲaha na mu di wa mɛɛ suu wɛ? Jɔgɔ mu di wa zhaa wɛ?» Ayiwa, a Mariyama di ganha na giin na tiire tɛgɛ ki kafɔɔ wu wi, na wu pye: «Yesu nʼa zhaa, ma bi ta mʼa wu lɔ, wu sanha shɛ na na di shɛ wu lɔ da gaaŋi.» ");
INSERT INTO myk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A Yesu di wu pye: «Mariyama!» A Mariyama di ŋmahana ɲɛri wu yíri na wu pye Yawutuu jomɔ pu ni na: «Rabuni!» (Lee kɔri ɲɛ «Karamɔgɔ.») ");
INSERT INTO myk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A Yesu di wu pye: «Ma ganha bu da gbɔn na na wɛ, bani nɛ sanha dugi fɔlɔ na kari na To wu yíri wɛ. Shɛ yi jo na cebooloo pu mu na nɛ wʼa duri na gaaŋi na To wu yíri, yee bɛ wo To we; wee wemu wu ɲɛ nɛ Kilɛ, na ɲɛ yee bɛ wo Kilɛ ge.» ");
INSERT INTO myk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A Magadala shɛɛn Mariyama di shɛ kalaapiire ti pye na wee ya Kafɔɔ ɲa. Yesu ya yemu jo wu mu ge, a wu yee jo pu mu. ");
INSERT INTO myk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wee Dimazhi wuyɛ pyaa yakoŋɔ, kalaapiire ti bye puga ka ni. Pu bi kee gburaya yi shɔ̀hɔ wá puyɛ na Yawutuu ɲuŋɔfɛɛ pu ɲìi fyaara wuu na. A kalaapiire tʼi ba binnɛ Yesu fo ɲa wʼa yere pu niŋɛ ni. A wu pu pye: «Kilɛ wu ɲaɲiŋɛ kan yi mu.» ");
INSERT INTO myk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ba wʼa yee jo wɛ, na wu keye ni wu kabanugo ki shɛ pu na. Ba kalaapiire tʼa Kafɔɔ wu ɲa wɛ, a pu funyɔ di sii taan xuuni. ");
INSERT INTO myk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A Yesu di pu pye sanha na: «Kilɛ wu ɲaɲiŋɛ kan yi mu. Na To Kilɛ wʼa na tun tungana lemu na ge, lee tungana le ninunɔ na nɛ bɛ wʼa da yi tun.» ");
INSERT INTO myk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ba wʼa yee jo wɛ, na ɲɔ kafɛɛgɛ fɔ̀ wá pu na, na pu pye: «Yi Fɛfɛɛrɛ Munaa li shɔ. ");
INSERT INTO myk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yi bu sipya bɛɛri wo jurumu yafa wu mu, weefɔɔ wo jurumu wu na yafa wu mu. Ga yee bye yee di ya sipya wemu wo jurumu wu yafa wu mu wɛ, weefɔɔ wo jurumu wu da yafa wu mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu ya wuyɛ shɛ wu kalaapiire ti na caŋa kemu ge, kalaapire lemu mɛgɛ ki ɲɛ na Tomasi, pʼi wu pyi sanha na «Ŋmami» ge, wee bye ni pusamaa ni kee caŋa wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A Kalaapiire tisara di ba wee pye: «Wèe ya Kafɔɔ ɲa!» A Tomasi di pu pye: «Nɛ kunni bye nɛ tɔɔrɔ ti fɛ pu ɲa wu keye yi na, na na kabee taha tee tɔɔrɔ te wɔ fɛ pu na, na na keŋɛ bɛ taha ŋmaga ki wo fɛ pu bɛ na wu kabanugo ki na wɛ, nɛ da ga dà yi na bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ayiwa, a cewuu nigin di doro, a kalaapiire tʼi ba shɛ tiyɛ pinnɛ sanha puga ki ni. Tomasi bɛ di bi bye ni pu ni kee caŋa. A pʼi gburaya yi shɔ̀hɔ. A pʼi ba binnɛ Yesu fo ɲa puyɛ niŋɛ ni. A wu pu pye: «Kilɛ wu ɲaɲiŋɛ kan yi mu.» ");
INSERT INTO myk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lee kadugo na a wu Tomasi pye: «Tomasi, fulo naha, mʼa ma keŋɛ ki taha na keye yi na ma wii; ma bu xhɔ mʼa ki taha na kabanugo ki bɛ na wii. Nʼa daa baara ti yaha, mʼa da daa na na.» ");
INSERT INTO myk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A Tomasi di wu pye: «Ebe! Mu wu ɲɛ nɛ Kafɔɔ ni nɛ Kilɛ!» ");
INSERT INTO myk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A Yesu di wu pye: «Mu ya nɛ ɲa ge, lee bɛ lʼa mu pye mu ya dà nɛ na wɛ! Piimu pu ɲɛ pu ya nɛ ɲa wɛ, na dà nɛ na ge, pee ɲɛ duba nagoo.» ");
INSERT INTO myk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ya kakanhaŋaa niɲɛhɛŋɛɛ kii bɛ pye wu kalaapiire ti ɲii na, kee ya ta ka naha we Kitabu we ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ga kiimu kʼa ka ge, kee wo kakana ɲuŋɔ ki wa kɔnhɔ yʼi li cɛ, yʼi dà bɛ li na na Yesu wu wa Shɔvɔɔ we, na wee wu ɲɛ Kilɛ Ja we. Yʼi nɔhɔ ɲìi sicuumɔ ta wee nʼa daa we funŋɔ ni wu mɛgɛ ki fanha ni. ");
INSERT INTO myk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ayiwa, kii keree kii kadugo na, Yesu ya wuyɛ shɛ sanha wu kalaapiire ti na Tibɛrɛyade Gba wu ɲɔ na. Le shɛgana le na wʼa wuyɛ shɛ. ");
INSERT INTO myk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ Pyɛɛri, ni Tomasi wemu pʼa byi sanha na «Ŋmami» ge, ni Nataɲɛli wemu wʼa yìri Kana kulo li ni, Galile fiige ki ni ge, ni Zebede jalaa shuun, ni kalaapiire shuun wa bɛ, lee bi pee ta pee bɛɛri na ɲɛ shiizhan. ");
INSERT INTO myk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A Simɔ Pyɛɛri di pu pye: «Nʼa da zhɛ fyaa sha.» A kalaapiire tisara bɛ di jo: «Wèe bɛ pu wa da zhɛ ni ma ni.» A pʼi foro kari, na shɛ jé kɔrɔgɔ ka ni, na pu jɔlɔɔ pu ɲɔ kɔn na waa. Ga pu ya fyara bɛ ta kee caŋa ki wo piige ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ɲimuguɲɔ wu na, a kalaapiire tʼi Yesu niyerege ɲa gba wu ɲɔ na; ga pu bi ta wu cɛ na jo Yesu wu ɲɛ wii wɛ. ");
INSERT INTO myk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A Yesu di pu pye: «Na naɲiinɛɛ, ta yee ya fyaa pii ta?» A pʼi wu ɲɔ shɔ na: «Wèe ya ta yaaga bɛ ta wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A Yesu di pu pye: «Yi jɔ̀ wu wá kɔrɔgɔ ki kanige cɛ wu ni, yi na fyaa ta. Ba pʼa jɔ̀ wu wá wà wɛ, fyaa pu ɲɛhɛŋɛ keŋɛ ni, pu ya já jɔ̀ wu kile yeege lɔhɔ ki ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kalaapire lemu kaa li bi dan Yesu ni ge, a lee di Pyɛɛri pye: «Pyɛɛri, go Kafɔɔ wʼa wii!» Ba Pyɛɛri ya logo na Kafɔɔ wʼa wii wɛ, na wu fadeŋɛ lɔ le, bani wu fadeŋɛ baa wo wu bye. Na do lɔhɔ ki ni, na ganha na gaaŋi Yesu fɛni. ");
INSERT INTO myk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A kalaapiire tisara di ganha na ma ni kɔrɔgɔ ki ni, na jɔ̀ wu bɛ kilee na ma ni fyaa pu ni. Bani pu bi lii kogoŋɔ ki na wɛ. Pu ni kogoŋɔ ki bye mɛtɛrɛlɛɛ xhuu nigin (100) shi. ");
INSERT INTO myk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba pʼa nɔ kogoŋɔ ki na wɛ, na naganhaa ɲa wà, fyaa dʼa taha ki ɲuŋɔ ni, na buuri bɛ ɲa wà. ");
INSERT INTO myk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A Yesu di pu pye: «Fyaa piimu yʼa co ge, yi pa ni pii ni naha.» ");
INSERT INTO myk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A Simɔ Pyɛɛri di jé kɔrɔgɔ ki ni, na jɔ̀ wu kile yeege, na foro ni wu ni kpɛɛngɛ ki na, wu bɛɛri ya sii ɲi fya nagaya na fo yi xhuu nigin ni kɛlɛɛ kaguro ni taanri (153). Ga fyaa pu ni pu ɲɛhɛŋɛ ni, jɔ̀ wu ya kɔn wɛ. ");
INSERT INTO myk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A Yesu di pu pye: «Yi pa yʼi ba li!» Sipya ya ta kalaapiire ti ni wemu ya sɔɔ na wu yege na jo: «Mu di ɲɛ jɔgɔ wɛ?» Bani pu bɛɛri bi li cɛ na Kafɔɔ wu ɲɛ wii. ");
INSERT INTO myk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","A Yesu di fulo na buuri wu lɔ kan pu mu, na fyaa pu bɛ lɔ kan pu mu. ");
INSERT INTO myk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na co fo Yesu ɲɛduun wu na, wu tɔɔɲii taanri wuu lʼa pye lere na wuyɛ shɛɛ wu kalaapiire ti na. ");
INSERT INTO myk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba pʼa li xɔ wɛ, a Yesu di Simɔ Pyɛɛri pye: «Yohana ja Simɔ, ta nɛ kaa ya dan mu ni xuuni na toro pii samaa tàan?» A Pyɛɛri di jo: «Uun gɛ, Kafɔɔ! Muyɛ pyaa ki bɛ ya li cɛ na mu kaa ya dan nɛ ni.» A Yesu di wu pye: «Ta na dubyapiye yi ɲɔ shaa.» ");
INSERT INTO myk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A Yesu di wu pye sanha tɔɔɲii shuun wuu li ni na: «Yohana ja Simɔ, ta nɛ kaa ya dan mu ni xuuni?» A Pyɛɛri di jo: «Uun gɛ, Kafɔɔ! Muyɛ pyaa ki bɛ ya li cɛ na mu kaa ya dan nɛ ni.» A Yesu di wu pye: «Ta na dubyaa pu naha.» ");
INSERT INTO myk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A Yesu di wu yege taanri wuu li ni na: «Yohana ja Simɔ, ta nɛ kaa ya dan mu ni?» A Pyɛɛri ɲaha di danha, bani Yesu ya wu yege fo tɔɔɲii taanri na: «Ta nɛ kaa ya dan mu ni?» Lee na a wu Yesu pye: «Kafɔɔ, mu ya keree bɛɛri cɛ. Muyɛ pyaa kʼa li cɛ na mu kaa ya dan nɛ ni.» A Yesu di wu pye: «Ta na dubyaa pu ɲɔ shaa!» ");
INSERT INTO myk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A Yesu di Simɔ pye sanha na: «Can can na, nʼa da yi jo ma mu, ma lɛvɛɛrɛ ti tuun wu ni, mu bi ma ma kirige taga mayɛ pɔ. Xuu wemu wʼa ma taan ge, mʼa ganha na se wà. Ga mu ba ba lɛ, ma na ba ma keye yirige, sipya watii na kirige ki pɔ ma na. Pʼa ganha na se ni ma ni xuu wa ni ma funŋɔ ɲɛ ma shɛ wemu ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pyɛɛri bi da ba xhu xugana lekɛ na lee di baraga taha Kilɛ mɛgɛ na ge, lee xugana le Yesu ya shɛ ni le kafila talenɛ le ni. Lee kadugo na a wu Pyɛɛri pye: «Ta ma na fɛni!» ");
INSERT INTO myk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ba Pyɛɛri ya kara wii wɛ, kalaapire lemu kaa li bi dan Yesu ni ge, a wu lee ɲa li na ma pu kadugo yíri. Lee kalaapire le li bi shɛ diin Yesu tàan na pu yaha pu na li caŋa ka piige, na wu yege na: «Wù Kafɔɔ, sipya wekɛ wu wa da ba mu nɔhɔ yaha wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ayiwa, ba Pyɛɛri ya lee kalaapire li ɲa wɛ, na jo: «Wù Kafɔɔ, we do, lekɛ di da ba we ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Yesu di wu pye: «Li ɲɛhɛ daan nɛ mu nago kanna wu gori yaha ɲiifɛɛrɛ na fo di zhɛ nɛ caguribaŋa pye kʼa nɔ, mu ɲaha wa yee ni wɛ? Mu kunni wʼa ma nɛ fɛni yɛ sa!» ");
INSERT INTO myk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A kalaapiire tʼi pee jomɔ pe caaga na xuu wu bɛɛri círi na lee kalaapire le da ga xhu wɛ. Na ta Yesu di ya ta Pyɛɛri pye na jo wu da xhuu wɛ, ga Yesu ya jo na: «Li ɲɛhɛ daan nɛ mu nago kanna wu gori yaha ɲiifɛɛrɛ na fo di zhɛ nɛ caguribaŋa pye kʼa nɔ, mu ɲaha wa yee ni wɛ?» ");
INSERT INTO myk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Lee kalaapire le ninunɔ li wa pe jomɔ pe ɲaha yu. Wee shiin wu dʼa pe jomɔ pe ka bɛ. Wèe bɛ ya li cɛ na can wu ɲɛ wu jomɔ pe. ");
INSERT INTO myk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ayiwa, Yesu ya keree niɲɛhɛŋɛɛ kiitiigee bɛ pye. Pu da bi jo pʼi kee bɛɛri nigin nigin ka, nɛ giin jo pee Kitabuu pu bɛɛri bi da já jé koŋɔ puga ni wɛ.");
INSERT INTO myk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Na ceborona Teyofili, Yesu ya keree kiimu bɛɛri pye, na kalaa wemu bɛɛri kan sipyii pu mu ge; nɛ kee bɛɛri ɲaha jo na Kitabu nizhiimɛ wu ni, na lɔ ki ɲɔ kɔnduun wu na, ");
INSERT INTO myk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","fo na shɛ nɔ caŋa kemu na wʼa dugi fugba wu ni ge. Wʼa bi kalaapiire ta shɔɔnri na pye wu tudunmɔɔ. Na wu ta wu sanha dugi fugba wu ni wɛ, pee tudunmɔɔ pʼa yaa pʼa keree kiimu bɛɛri pyi ge, a wu kee bɛɛri ɲaha jo pu mu Fɛfɛɛrɛ Munaa fanha ni. ");
INSERT INTO myk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na co Yesu kanhama keree ki na fo wu xuduun we, ba kee keree kʼa toro wɛ, a Yesu di ganha na wuyɛ shɛɛ wu kalaapiire ti na, na keree pyi kiimu ya li shɛɛ can na na wu wa ɲii na ge. Wu bi wuyɛ shɛɛ pu na, na pu kalaa Kilɛ wo saanra ti keree ni fo na shɛ nɔ cabyaa kɛlɛɛ shishɛɛrɛ (40) na. ");
INSERT INTO myk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A caŋa ka di ba nɔ, na wu yaha ni pu ni shiizhan, a wu yi jo waha pu mu na: «Yi ganha da voro Zheruzalɛmu ni wɛ. Na To wʼa lemu wo ɲɔmɛɛ lɔ yi mu ge, yi lee sige. Nɛyɛ pyaa ya tee yi jo toro yee mu jo, ");
INSERT INTO myk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","lɔhɔ ni Yohana bi sipyii pu batizeni, ga Kilɛ na ba Fɛfɛɛrɛ Munaa tirige yi na cabyaa dama dama tatorogo ni, yi na batize lee Munaa le ni.» ");
INSERT INTO myk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ayiwa, na Yesu ni wu kalaapiire ti nibinnɛgɛ yaha, a pʼi wu yege na: «Wù Kafɔɔ, ta nimɛ ma da Izirayɛli wo saanra ti teŋɛvonɔ li teŋɛ?» ");
INSERT INTO myk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A Yesu di pu ɲɔ shɔ na: «Nɛ To Kilɛ wʼa kii tɛɛgɛɛ kii gbegele wuyɛ pyaa wo sefɛɛrɛ ti funŋɔ ni. Li wa yee wo nibyii nago yi kee sha cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ga, sefɛɛrɛ ta tʼa da ba digi yee na, Fɛfɛɛrɛ Munaa wo sefɛɛrɛ. Wee tuun wu ni yee na bye nɛ wo sɛɛrɛɛ, na nɛ keree yu Zheruzalɛmu ni, ni Zhude fiige ki ni, ni Samari fiige ki bɛ ni, fo na shɛ nɔ koŋɔ ke kabaya ye bɛɛri na.» ");
INSERT INTO myk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ba Yesu ya pee jomɔ pu jo xɔ wɛ, na dugi kari fugba wu ni pu ɲii na. A ɲahaŋa ka di ba wu tɔ, a pʼi bye pu ya wu ɲaa nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na pu yaha pu na wu wii takaraga ni fugba wu ni, taapile ni a namaa shuun faviire wuu pʼa di ba yere pu tàan. ");
INSERT INTO myk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","A pee di pu pye: «Galile shɛɛn, ɲaha na yee dʼa yere yaha naha na wii fugba wu ni wɛ? Yesu ya yìri yee tàan na kari fugba wu ni. Ba yʼa wu ɲa wʼa kari karigana lemu na fugba wu ni wɛ, mu wʼa da ba shɛ guri ba sanha.» ");
INSERT INTO myk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wee tuun wu ni a kalaapiire tʼi laha faaboboŋɔ ki na na ma Zheruzalɛmu ni. Faaboboŋɔ ke ki wa na Oliviye faaboboŋɔ ge, kere ni Zheruzalɛmu tɛ wu ɲɛ kilo nigin shishiin. ");
INSERT INTO myk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba pʼa nɔ Zheruzalɛmu ni wɛ, na shɛ jé puga ka ni zangaso wa ni. Kee puga ki ni pʼa tee na puyɛ pinnɛɛ. Pee bye: Pyɛɛri, ni Yohana, ni Yakuba, ni Andire, ni Filipe, ni Tomasi, ni Batelemi, ni Macoo, ni Alife ja Yakuba, ni Simɔ we wu ɲɛ Zelɔtilee kuruŋɔ ki ni ge, ni Yakuba ja Zhude. ");
INSERT INTO myk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pii bɛɛri bi puyɛ pinnɛ ni zɔ nigin ni, na Kilɛ ɲɛɛri. Cèe pii bɛ bye ni pu ni, ni Yesu nu Mariyama, ni Yesu ceboronamaa. ");
INSERT INTO myk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A caŋa ka di ba nɔ, a nʼa daa fɛɛ pʼi ba binnɛ. Pu bi xhuu nigin ni kɛlɛɛ shuun (120) xɔ kee caŋa. A Pyɛɛri di yìri yere pu niŋɛ ni na jo: ");
INSERT INTO myk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Na cebooloo, yemu yʼa ka Kilɛ Kafila wu ni ge, fo yee ɲɔ bu fa. Bani Dawuda ya fɛnhɛ Zhudasi kaa jo Fɛfɛɛrɛ Munaa fanha ni. Wee Zhudasi we wʼa toro Yesu covɛɛ pu ɲahagbaa na, na Yesu le pu keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wee Zhudasi wʼi bi bye ni wèe ni, na wu taa tuduro pyi ba wèe ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Wari we wʼa ta wu wo kakuunɔ li footɔsaraa ge, a wu shɛ wee taga tɛgɛ ka shɔ. Lee kadugo na a wu ba shɛ wuyɛ gbo kee tɛgɛ ki ni. A wu ba wuyɛ yaha, na ba ɲuŋɔ ke sin ɲiŋɛ na na jɛnri. A wu laara ti bɛɛri di jaaga. ");
INSERT INTO myk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zheruzalɛmu shɛɛn bɛɛri ya lee cɛ. Lee wuu na pʼa kee tɛgɛ ki mɛgɛ le pu wo jomɔ pu ni na ‹Akɛlidama›, lee kɔri ɲɛ na ‹Shishan tɛgɛ.› ");
INSERT INTO myk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na ta li dʼa ka Zaburuu Kitabu wu ni na: ‹Wu puga ki ɲɛri kataha, sipya bɛ ganha bye ki ni wɛ.› A Zaburuu Kitabu wu nɔhɔ jo sanha na: ‹Watii wu wu labye wu lɔ wu tɛgɛ.› ");
INSERT INTO myk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Lee wuu na Kafɔɔ Yesu ya tuun wemu bɛɛri pye na ɲaari ni wèe ni ge, sipyii piimu pu bi bye ni wèe ni wee tuun wu bɛɛri ni ge; ");
INSERT INTO myk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yohana ya wu batize caŋa kemu ge, na co kee caŋa ki na, na pa nɔ fo caŋa kemu wʼa dugi fugba wu ni ge. Wee sipya wa wʼa yaa na pinnɛ ni wèe ni, wu bɛ di bye sɛɛri, na Yesu ya ɲɛ na foro xu ni.» ");
INSERT INTO myk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wee tuun wu ni a pʼi sipyii shuun wa shɛ: Yusufu ni Macasi. Yusufu mɛgɛ ka bɛ ki bye na Barisabasi, pii bɛ di wu pyi na Zhutusi. ");
INSERT INTO myk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lee kadugo na a nʼa daa fɛɛ pu bɛɛri di binnɛ na Kilɛ ɲɛɛri na: «Wù Kafɔɔ, mu wemu wʼa sipyii bɛɛri zɔlɔɔ cɛ ge, pii sipyii shuun we ni wemu ɲaha mʼa bulo ge, wee shɛ wù na, ");
INSERT INTO myk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kɔnhɔ wu bɛ di bye tudunmɔ wa. Labye we Zhudasi ya yaha ge, wu wee lɔ Zhudasi tɛgɛ. Zhudasi ya we labye we yaha na shɛ wuyɛ pyaa ɲidaan tashɛgɛ ni.» ");
INSERT INTO myk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba pʼa ɲɛrɛgɛ ki pye xɔ wɛ, na kagaangaa shan, wemu ɲaha Kafɔɔ ya bulo ge, kɔnhɔ pʼi wee cɛ. A Macasi wo kagaan lʼi lɔ, a wee di fara tudunmɔɔ kɛ ni nigin wu na. ");
INSERT INTO myk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pantekɔti wu caŋa, Yesu wo nʼa daa fɛɛ pu bɛɛri bi shɛ binnɛ puga ka ni. ");
INSERT INTO myk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Taapile ni a tunmɔ nigbɔ pa di ba yìri fugba we ni. Pee ɲɛ ba kafɛɛgbɔhɔ tunmɔ ɲɛ wɛ. Puga kemu ni pʼa tiin ge, a tunmɔ pʼi ba kee puga ki ɲi. ");
INSERT INTO myk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","A pʼi ɲilee kii ɲa ba na wogoo ɲɛ wɛ. A kee di waagi waagi, na ba daha daha pu bɛɛri nigin nigin wu ɲuŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A pu bɛɛri di ɲi Fɛfɛɛrɛ Munaa na, na ganha na shi watii jomɔ yu. Fɛfɛɛrɛ Munaa li bu shi wemu wo jomɔ kan wemu mu, wee na ganha na pee yu. ");
INSERT INTO myk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wee tuun wu bi Kilɛ ɲìi fyaara sipyii pii ta wà Zheruzalɛmu ni, piimu ya jé Yawutuu pu wo koo li ni ge, pee bi yìri koŋɔ ke fiiye ye bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ba pee ya pee tunmɔ pu logo wɛ, na baa kari, na shɛ binnɛ wà. Ba pʼa nɔ wà wɛ, a lʼi bye pu bɛɛri mu kakanhana, bani pu bɛɛri nigin nigin wu bi pu shi jomɔ nuri nʼa daa fɛɛ pu ɲɔ na pu na yu. ");
INSERT INTO myk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A lee di pu bɛɛri fo xuuni, a pʼi li ta kakanhana na ganha na yu na: «Sipyii pii pʼa yu mɛ ge, ta pu bɛɛri ɲɛ Galile shɛɛn wɛ? ");
INSERT INTO myk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Li dʼa pye dii wèe bɛɛri nigin nigin wu wù wo shi jomɔ pu nuri pu ɲɔ na wɛ? ");
INSERT INTO myk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wèe pii pu wa naha ge, pii ya yìri Pariti fiige ki ni, ni Medi fiige ki ni, ni Elamu fiige ki ni, ni Mezopotami fiige ki ni, ni Zhude fiige ki ni, ni Kapadɔsi fiige ki ni, ni Pɔn fiige ki ni, ni Azi fiige ki ni, ");
INSERT INTO myk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ni Firizi fiige ki ni, ni Panfili fiige ki ni, ni Misira fiige ki ni. Libi fiige ki kulogoo kii ki wa Sirinɛ kulo li kabanugo ge, a pii di yìri wà, a pii di yìri Oromɛ kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","A pii di yìri Kirɛti fiige ki ni, a pii di yìri Arabuu fiige ki ni. Wèe bɛɛri ni, pii ya sii pye Yawutuu yɛ pyaa, pii dʼa jé Yawutuu pu wo koo li ni. Wèe bɛɛri nigin nigin wu ɲɛ na Kilɛ wo kagbɔhɔɔ ki nuri pu ɲɔ na wù wo shi jomɔ pu ni.» ");
INSERT INTO myk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A lʼi bye kakanhana pii sipyii pii mu, fo pu ya cɛ yekɛ pu da da yu wɛ. A pʼi ganha na puyɛ yegee na: «Ɲaha wuu li ɲɛ le wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ga, a pii di ganha na nʼa daa fɛɛ pu la wo pii sipyii pii ni na yu na: «Duvɛn pʼa gba tin.» ");
INSERT INTO myk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wee tuun wu ni a Pyɛɛri di yìri yere ni tudunmɔɔ kɛ ni nigin wu samaa ni, na wu mujuu ɲuŋɔ yirige, na sipyii pu pye: «Yee piimu pu wa Yawutuu ni yee piimu samaa bɛɛri pu wa Zheruzalɛmu ni ge, yi niwegee shan. Ye nʼa da jo yi mu ge, yʼi yi logo, yʼi yi ɲaha cɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pii sipyii pii ya ta gba wɛ, ma na jo ba yee wa yi funyɔ kɔɔn kɔngana lemu na wɛ. Bani ke ɲisɔɔgɔ ke tuunɔ ɲii gbarashɛɛrɛ wu na, ɲiga sanha mugi wa wu toro gba ma tin wɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ga Kilɛ tudunmɔɔ Zhowɛli bi keree kiimu jo fo taatuunnɔ ni ge, kee ki wa byi mɛ nimɛ. Wʼa bi jo na: ");
INSERT INTO myk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Kilɛ ya jo na: Koŋɔ ki taaxɔɔ li ba nɔ, nʼa da na Munaa li tirige sipyii pu bɛɛri na na ɲɛhɛ. Wee tuun wu ni yi jalaa ni yi pushaa na ba keree nibaŋaa nuri Kilɛ mu na yu. Yi lɛvɛɛ pu na ba kashɛgɛɛ ɲaa; yi nɔhɔlɛɛ pu na ganha na nɛ wo keree ki ɲaa ŋmunuyɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oo dɛ, yee caya yi na kunni, nɛ na ba na Munaa li tirige na kapyebyii pu na na ɲɛhɛ: namaa fara cèe na, pʼa ganha na keree nibaŋaa yu nɛ mɛgɛ na. ");
INSERT INTO myk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɛ na ba kakanhaŋaa kii pye fugba we ni, na ɲaha shɛshɛɛrɛ ta pye ɲiŋɛ ke na: shishan, ni na, ni kakunnuŋɔ wurege wogo. ");
INSERT INTO myk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nibiige na ba jé caŋa ki ni, yeŋɛ ki na ba ɲaaŋa ba shishan ɲɛ wɛ. Lee kadugo na Kafɔɔ wo caŋa ki na na nɔ. Kee caŋa ki na ba bye cagbɔhɔ, kemu nɔɔrɔ ya pɛlɛ ge. ");
INSERT INTO myk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wee tuun wu ni sipya bɛɛri wu da ba Kafɔɔ mɛgɛ yiri ge, weefɔɔ na ba shɔ.›» ");
INSERT INTO myk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","A Pyɛɛri di shɛ ɲaha na sanha na jo: «Izirayɛli shɛɛn yi niwegee shan, yʼi na jomɔ pu logo. Nazarɛti shɛɛn Yesu bye sipya wemu ge, Kilɛ ya wu shɛ yi na. Wʼa kagbɔhɔɔ pye yi niŋɛ ni, na kakanhaŋaa pye, na ɲaha shɛshɛɛrɛ pye Kilɛ fanha ni; yiyɛ pyaa ki bɛ wa lee cɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pʼa we ná we le yee keŋɛ ni, a yee di wu kan Kilɛ-cɛbaalaa mu pʼa kori tige na na gbo. Kilɛ bi lee cɛ yaha, ni lee wu bi sii gbegele wu kaa na. ");
INSERT INTO myk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ga Kilɛ ya wu ɲɛ, na wu yeege xu ni. Kee fanha ki bi bye bɛ xu mu wu já Yesu mara wɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bani ye saannaa Dawuda ya jo wu shizhaa na ge, yee yi wa mɛ na: ‹Nɛ bi Kafɔɔ ɲaa tuun bɛɛri ni na ɲahagbaa na, bani wu bi ma bye tuun bɛɛri ni nɛ kanige cɛ, kɔnhɔ yafiin ganha da na ɲɛhɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lee wuu na nɛ zɔ we ya ɲi fundanga na, a nɛ jomɔ bɛɛri di bye fundanga jomɔ. Ali faŋa bɛ ni, nɛ dà li na jo na ceepuuro ti na ba ŋmɔ ɲaɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bani mu wa da ga gbara nɛ munaa li kori Adɛsi ni wɛ. Ma di wa da gbara ma Fɛfɛɛrɛ Sipya wu ceepuuro ti fɔnhɔ faŋa ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mʼa ɲìi sicuumɔ nivomɔ pu korogoo ki shɛ na na. Na mu yaha ni nɛ ni, mu na da nɛ zɔ wu ɲini fundanga na.›» ");
INSERT INTO myk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","A Pyɛɛri di shɛ ɲaha na sanha na jo: «Na ceboronamaa, yi yere di wu tolɛ Dawuda keree fiinŋɛ jo yi mu. Wèe tolɛ Dawuda ya xu, a pʼi wu le. Ali niɲaa we bɛ ni wu faŋa ki wa naha wù mu, wu kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ga Kilɛ tudunmɔ wu bye Dawuda. Ni wu bi li cɛ bɛ sanha na Kilɛ wʼa ɲɔmɛɛ lɔ wee mu, na kaaga bɛ kàa na taha li na na wee Kilɛ na ba Dawuda wo Ja wa teŋɛ caŋa ka wu kadugo yíri, wu saanra koro li ni. ");
INSERT INTO myk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wee tuun wu ni, Shɔvɔɔ wu bi yaa wu pa ɲɛ foro xu ni ɲɛgana lemu na ge, Kilɛ ya fɛnhɛ lee shɛ Dawuda na. Lee wuu na wʼa jo na: ‹Wu da ba gori xu nibiige ni wɛ, wu ceepuuro tʼa da ba fɔnhɔ faŋa ni wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Shɔvɔɔ wemu kaa pu wa byi ge, Yesu wu wa wii. Wee Kilɛ ya ɲɛ na yeege xu ni, wèe bɛɛri wa lee wo ɲavɛɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ba wʼa dugi kari fugba wu ni wɛ, na shɛ diin saanra tatɛɛngɛ ki ni Kilɛ kanige cɛ. Wu bi Fɛfɛɛrɛ Munaa lemu wo ɲɔmɛɛ lɔ wèe mu ge, a Kilɛ di lee kan wu mu. A wu bɛ di lee tirige wèe na, ma na jo ba yi wa li ɲaa ɲagana lemu na, na li nuri logogana lemu na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda yɛ pyaa ya ta dugi kari fugba wu ni wɛ. Ga wʼa li shɛ na: ‹Kafɔɔ Kilɛ ya yi jo nɛ Kafɔɔ mu na: Tiin saanra tatɛɛngɛ ki ni na kanige cɛ, ");
INSERT INTO myk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","fo di ba ma pɛɛn pye ma ɲidahaa tatahaŋa.› ");
INSERT INTO myk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Izirayɛli shɛɛn bɛɛri ya yaa na li cɛ na fiinŋɛ na jo Yesu wemu yee ya kori tige na ge, Kilɛ ya wu pye Kafɔɔ, na wu pye Shɔvɔɔ.» ");
INSERT INTO myk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ba pʼa pee jomɔ pu logo wɛ, a pu zɔlɔɔ di pu kaala xuuni. A pʼi Pyɛɛri ni tudunmɔɔ pusamaa yege na: «Wù cebooloo, kaa lekɛ wèe dʼa yaa na pye nimɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A Pyɛɛri di pu ɲɔ shɔ na: «Yee ya yaa yee pu daburajɛ jo yi jurumu wu na. Yee bɛɛri nigin nigin wa yaa na batize Yesu Kirisa mɛgɛ na, kɔnhɔ yi wo jurumu wu yafa yi mu. Lee bu bye Kilɛ na Fɛfɛɛrɛ Munaa li tirige yi na. ");
INSERT INTO myk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bani le Fɛfɛɛrɛ Munaa ɲɔmɛɛ le, yee mu wʼa li lɔ. Yi nagoo pii pʼa ma yi kadugo ge, na li lɔ pee bɛ mu, na li lɔ taliige shɛɛn bɛ mu. Kafɔɔ Kilɛ na ba sipyii piimu bɛ bɛɛri yiri ge, wʼa li lɔ pee bɛɛri mu.» ");
INSERT INTO myk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A Pyɛɛri di pee sipyii pu yɛri na fiinŋɛ, na yi jo waha pu mu na: «Niɲaa wo sipyii pii pu ɲɛ sipyitiibaaya ge, yi kuri pee fɛni, kɔnhɔ yʼi ɲuwuuro ta.» ");
INSERT INTO myk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Piimu bɛɛri pʼa dà Pyɛɛri wo kafilajo wu na ge, a pee bɛɛri di batize lɔhɔ ni. Kee caŋa kiyɛ pyaa a sipyii kabɔfoŋɔɔ taanri (3.000) shishiin di da na fara nʼa daa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na co kee caŋa ki na, a pii sipyii pii di ganha na puyɛ pinnɛɛ, na gori yaha tudunmɔɔ pu wo kalaa wu na. A pʼi bye wà nʼa daa fɛɛ pu wo kariɲɛɛgɛ ki ni. Pu bi buuri wu kɛgɛɛ kɛgɛɛ puyɛ tɛ ni na xhaa, na puyɛ funyɔ tun Kafɔɔ wo jomɔ pu na. Na ɲɛrɛgɛ pinnɛɛ na byi shiizhan. ");
INSERT INTO myk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kilɛ ɲìi fyaara bye sipyii pu bɛɛri ni, bani tudunmɔɔ pu bi ɲaha shɛshɛɛrɛ ni kakanhaŋaa niɲɛhɛŋɛɛ pyi. ");
INSERT INTO myk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nʼa daa fɛɛ pu bɛɛri pu bi pinnɛ ɲɔmɛɛ na, le li ɲɛ pu mu ge, na lee bɛɛri pinnɛɛ na daga na pu keree yari. ");
INSERT INTO myk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pu bi pu kɛrɛyɛ ni pu keŋɛ yaŋmuyɔ pɛrɛɛ, na wee wari we pinnɛɛ, na wee taani taani puyɛ na, na bɛ ni pu bɛɛri nigin nigin wu cɔnrɔmɔ keree ɲuŋɔ kana ni. ");
INSERT INTO myk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pu bi puyɛ pinnɛɛ caŋa caŋa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni ni fungɔngɔ nigin ni, na Kilɛ pɛlɛ. Pu bɛɛri bi puyɛ pinnɛɛ pu kabanya ni, na buuri wu kɛgɛɛ kɛgɛɛ puyɛ na na xhaa, na puyɛ funyɔ tirige Kafɔɔ wo jomɔ pu na. Pu bi pu yaligee pinnɛɛ na li shiizhan ni fundanga, ni funvige ni. ");
INSERT INTO myk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pu bi Kilɛ sɔni tuun bɛɛri ni. Pu kaa bi dan kulo li shɛɛn pu bɛɛri ni. Piimu bɛɛri pu bi da ba shɔ ge, caŋa caŋa Kafɔɔ bi pee yiri na faraa nʼa daa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Caŋa ka Pyɛɛri ni Yohana yɛ bi gaaŋi yakoŋɔ Kilɛ ɲɛrɛgɛ na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni tuunɔ ɲìi taanri wu na. ");
INSERT INTO myk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lee di ná wa ta wà lee kulo li ni wʼa faan fo wu seduun ni. Caŋa caŋa pʼa wee faan wu lɔ na shɛ yaha Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki kuɲɔɔ la ɲɔ na, kɔnhɔ wu da yaŋmuyɔ ɲɛɛri Kilɛ-pɛɛŋɛ pugbɔhɔ ki jevɛɛ pu mu. Lee kuɲɔɔ le mɛgɛ ki bye na «Kuɲɔɔsaana». ");
INSERT INTO myk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ba wee faan wʼa Pyɛɛri ni Yohana yɛ ɲa pu na ma ba jé lee kuɲɔɔ li ni wɛ, na pu ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A Pyɛɛri ni Yohana bɛshuun di ɲahaya kɔ le wu ni na wii. A Pyɛɛri di wu pye: «Ta wù wii!» ");
INSERT INTO myk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A we ná we di pii kemɛ wii, bani wu bi giin na yaaga ka pu da gan wee mu. ");
INSERT INTO myk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wee tuun wu ni a Pyɛɛri di wu pye: «Wari kunni wa nɛ mu nɛ wu kan ma mu wɛ, sanni bɛ di wa nɛ mu wɛ; ga le li wa na mu ge, nʼa da lee kan ma mu: Yìri mʼa da ɲaari Nazarɛti shɛɛn Yesu Kirisa mɛgɛ ki fanha ni!» ");
INSERT INTO myk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ba wʼa yee jo wɛ, na ná wu co wu kanige keŋɛ ke na, na wu yirige. Taapile ni a ná wu tɔɔyɔ ni wu ɲidakuruyo yi bɛɛri di juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A wu sira yìri na yere, na ganha na ɲaari. A wu jé ni Pyɛɛri ni Yohana ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na ganha na ɲaari ɲaari, na sirani, na Kilɛ sɔni. ");
INSERT INTO myk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A sipyiire ti bɛɛri di wu ɲa taɲaraga ni wu na ɲaari na Kilɛ sɔni. ");
INSERT INTO myk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","A pʼi wu sɛɛri cɛ na faan we wu bi ma dɛn Kilɛ-pɛɛŋɛ pugbɔhɔ ki kuɲɔɔsaana li ɲɔ na na yaŋmuyɔ yi ɲɛɛri ge, na wee wu ɲɛ wii. Wʼa cuuŋɔ cuuŋɔgana lemu na ge, a lee di pu bɛɛri fo fo na pu ɲaha wɔ. ");
INSERT INTO myk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A wee ná wu daha yaha Pyɛɛri ni Yohana na. Wu juuŋɔ wʼa sipyii pu fo fogana lemu na ge, a pu funjɔnrɔgɔ wuu di baa kari na shɛ binnɛ Yohana ni Pyɛɛri tàan Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki xuu wa ni. Wee xuu wu mɛgɛ ki bye na saannaa Solomani gba. ");
INSERT INTO myk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ba Pyɛɛri ya lee ɲa wɛ, na sipyiire ti pye: «Izirayɛli shɛɛn, ɲaha na le kaa le dʼa yee fo wɛ? Ɲaha na yee dʼa tiin na wèe wii mɛ wɛ? Ma na zhɛ yee ta yee na giin, nɛ ni Yohana ni, na wèe wo ɲɔmɛɛ fɛɛrɛ, kelee wèeyɛ pyaa wo sefɛɛrɛ tʼa we ná we cuuŋɔ. Bada! ");
INSERT INTO myk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ibirayima, ni Ishaaga, ni Yakuba yɛ wo Kilɛ we, wù sefɛlɛɛ pu wo wu kunni, wee wʼa pɛɛŋɛ taha wu kapyebye Yesu mɛgɛ ki na. Yeeyɛ pyaa kʼa wu le fanha keŋɛ ni pu gbo. Yee ya she wu ni Pilate ɲaha tàan, na wee ta wee na bi giin di wu yaha bɛ. ");
INSERT INTO myk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sipya we wu bi tii, na bye fɛɛfɛɛ ge, yee ya foro wu kaa tàan; we wʼa sipya gbo ge, na Pilate ɲɛɛri na wu wee yaha wu faara. ");
INSERT INTO myk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lee gbogana li na yee ya ɲìi sicuumɔ pu Kafɔɔ wu gbo. Ga Kilɛ ya wu ɲɛ na yeege xu ni, wèe wa lee wo ɲavɛɛ. ");
INSERT INTO myk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na dà Yesu mɛgɛ na, lee wo funŋɔ ni Yesu mɛgɛ kiyɛ pyaa ya fanha kan we ná we mu; ná we yi wa ɲaa mɛ, yi bɛɛri dʼa wu cɛ bɛ ge. Na dà Yesu na lee lʼa we ná we cuuŋɔ yi bɛɛri ɲii na mɛ. ");
INSERT INTO myk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ga nimɛ, na cebooloo, nɛ li cɛ jo li ɲaha cɛbaara tʼa yee ni yi ɲuŋɔfɛɛ pu wá lee kaa le na tapyege ni. ");
INSERT INTO myk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ga Kilɛ ya lemu jo toro fo taatuunnɔ ni wu Kilɛ tudunmɔɔ pu bɛɛri ɲɔ na ge, le wo bye funŋɔ ni wʼa lee ɲɔ fa. Wu bi jo na Shɔvɔɔ wemu ɲɔmɛɛ wee ya lɔ ge, na wu na ba ɲaa. ");
INSERT INTO myk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lee wuu na nimɛ, yee ya yaa yee pu daburajɛ jo yi jurumu wu na, yʼi sɔɔ Kilɛ na, kɔnhɔ wu yi wo jurumu wu jɔgɔ laha wà. ");
INSERT INTO myk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Lee bu bye Kafɔɔ Kilɛ na kafɛɛwama yaha ba yi mu. Wʼa Shɔvɔɔ wemu bɛ ɲaha bulo yi mu ge, wu na ba wu yaha ba yi mu caŋa ka, wee ɲɛ Yesu. ");
INSERT INTO myk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ga nimɛ Yesu ya yaa wu tiin fugba wu ni, fo keree ki bɛɛri ɲɛrivonɔ ba ɲɛri. Yee Kilɛ bi jo fdo taatuunnɔ ni wu Kilɛ tudunmɔɔ fɛfɛɛrɛ wuu pu ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kilɛ tudunmɔɔ Musa ya fɛnhɛ yi jo na: ‹Wù Kafɔɔ Kilɛ ya nɛ tun tungana lemu na ge, mu wʼa da ba Kilɛ tudunmɔ wa bɛ yirige na foro yee shi wu ni. Wee ba kaa bɛɛri jo yi mu, yʼi yere lee na. ");
INSERT INTO myk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wee Kilɛ tudunmɔ wu ba ba, sipyaa sipya wu ɲɛ wu ya wu ɲɔmɛɛ co-e ge, weefɔɔ na ba gyɛɛgi fɛɛfɛɛ na foro Kilɛ wo nagoo pu ni.› ");
INSERT INTO myk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Lee kadugo na na co Kilɛ tudunmɔɔ Samuwɛli na, na ba nɔ fo Kilɛ tudunmɔɔ piimu bɛɛri pʼa pa wee kadugo yíri ge, pee bɛɛri ya le caŋa ɲii le keree jomɔ jo. ");
INSERT INTO myk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","«Ayiwa, Kilɛ ya keree kiimu bɛɛri shɛ Kilɛ tudunmɔɔ pu na ge, kee bɛɛri ya jo yee mu. Kilɛ ya kariɲɛɛgɛ ɲɔmɛɛ lemu lɔ ni wèe tii pu ni ge, yee bɛ pu wa lee ni. Yee Kilɛ bi jo Ibirayima mu na: ‹Koŋɔ ke shi we bɛɛri na ba duba ta na foro ma kadugo ki ni.› ");
INSERT INTO myk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Lee wuu na ba Kilɛ ya wu kapyebye wu ɲaha bulo wɛ, na fɛnhɛ wu tun na pa yee mu; kɔnhɔ wu fɛrɛmɛ tirige yi na, wu yi bɛɛri nigin nigin wu tɔɔgɔ wolo yi kapyegee niguuŋɔɔ ni.» ");
INSERT INTO myk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ayiwa, na Pyɛɛri ni Yohana yaha pu na yu ni sipyii pu ni, a saraya ɲaha shɔɔnrivɔɔ ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲuŋɔfɔɔ, ni Sadushɛɛn di nɔ pu na. ");
INSERT INTO myk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","A pʼi Pyɛɛri ni Yohana ɲa pu na sipyii pu kalaa, na yi yu pu mu na Yesu ya ɲɛ ɲɛgana lemu na na foro xu ni ge, na mu xuu pu bɛɛri da ba ɲɛ. A lee di sii pɛn pu ni. ");
INSERT INTO myk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A pʼi Pyɛɛri ni Yohana co, na shɛ pu tɔ kaso ni fo ɲimuguro ti na, bani piige ki bi wɔ na xɔ. ");
INSERT INTO myk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ga lee bɛ na piimu pʼa Pyɛɛri ni Yohana jomɔ pu logo ge, a pu niɲɛhɛmɛɛ di dà Yesu na. Pee na fara nʼa daa fɛɛ pusamaa na, a pu bɛɛri di shɛ namaa kabɔfoŋɔɔ kaguro (5.000) fɛni. ");
INSERT INTO myk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kee caŋa ki ɲimuguro, Yawutuu ɲahagbaa fɛɛ, ni pu nɔhɔlɛɛ, ni saliya karamɔgɔlɔɔ pu bɛɛri di shɛ puyɛ pinnɛ Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Saraya ɲaha shɔɔnrivɛɛ pu wo ɲuŋɔfɔgbɔ wu bye wà na Anɛ, ni Kayifɛ, ni Yohana, ni Alɛkisandire, ni saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu wo puga shɛɛn pu bɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A pʼi shɛ Pyɛɛri ni Yohana yeege kaso wu ni, na ba pu yereŋɛ puyɛ niŋɛ ni, na pu yege na: «Sefɛɛrɛ tekɛ funŋɔ ni yee dʼa we ná we cuuŋɔ wɛ? Jɔgɔ mɛgɛ na yee dʼa lee pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wee tuun wu ni a Pyɛɛri di ɲi Fɛfɛɛrɛ Munaa na, na pu pye: «Wù fiige ki ɲahagbaa fɛɛ, ni ki nɔhɔlɛɛ, ");
INSERT INTO myk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wèe ya kasaana pye faan wa na, niɲaa a pʼi ganha na wèe yegee na dii wee ná wu dʼa pye na juuŋɔ wɛ. Nʼa da yee ɲaha jo yi mu. ");
INSERT INTO myk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ayiwa, yee fara Izirayɛli shɛɛn pu bɛɛri na, yee bɛɛri ya yaa na li cɛ na jo Nazarɛti shɛɛn Yesu Kirisa mɛgɛ fanha ni we ná we ya cuuŋɔ. Yee ya wu kori tige na na gbo, ga, a Kilɛ di wu ɲɛ na yeege xu ni. Wee wo mɛgɛ ki fanha ni we ná we nijuuŋɔ wʼa yere mɛ yee tàan. ");
INSERT INTO myk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kilɛ Kafila wʼa li shɛ na: ‹Yee puyirilee ya she faakagereŋɛ kemu ni na ki ya ɲɔ-ɛ ge, kee kʼa pye puga ki gunŋmii li faakagereŋɛ nijeŋɛ.› Kee faakagereŋɛ ke, kee ɲɛ Yesu.» ");
INSERT INTO myk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A Pyɛɛri di pu pye sanha na: «Watii ɲɛ wà nige wemu na já sipya shɔ Yesu kadugo na wɛ, bani Kilɛ ya ta watii kan sipyii mu nige, wemu na já wèe shɔ ke ɲiŋɛ ke na Yesu kadugo na wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pyɛɛri ni Yohana na yu na ta fyaara bɛ ɲɛ pu zɔlɔɔ na wɛ, a lee di bye kakanhana Yawutuu ɲahagbaa fɛɛ, ni pu nɔhɔlɛɛ pu mu; bani pu bi li cɛ na sipyitiilee pu ɲɛ Pyɛɛri ni Yohana, na kalaacemɛ ɲɛ pu ɲuŋɔ ni wɛ. A pʼi li sɛɛri na li cɛ na pu bɛ pu bye ni Yesu ni. ");
INSERT INTO myk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ga na pu ɲii yaha ná wu nijuuŋɔ ni Pyɛɛri ni Yohana tàan, pu ya já yaaga jo wɛ. ");
INSERT INTO myk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ayiwa, ba pʼa li ta mu wɛ, na Pyɛɛri ni Yohana yeege kiiri puga ki ni. Ba pee ya foro wɛ, a pʼi ganha na puyɛ pyi na: ");
INSERT INTO myk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Wèe di da lekɛ pye pii sipyii pii na wɛ? Bani Zheruzalɛmu shɛɛn bɛɛri ya li cɛ na fiinŋɛ na kagbɔɔ pii sipyii pii ya pye. Wèe bɛ di wa da já yi kaala wɛ. ");
INSERT INTO myk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ga le kapyexhɔɔ le kaa ya yaa li caaga di fiige ki bɛɛri círi wɛ. Wù pu yiri wù pu fuguri xuuni, wù yi jo waha pu mu jo pu ganha bu da Yesu kaa jo nige wa shishiin bɛ mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lee kadugo na a pʼi Pyɛɛri ni Yohana yiri leŋɛ, na yi jo waha pu mu na pu ganha bu Yesu kaa jo sipya wa shishiin ɲii na wɛ, pu ganha bu wa shishiin kalaa Yesu mɛgɛ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ga Pyɛɛri ni Yohana di pu pye: «Na yee ɲɔmɛɛ co kelee na Kilɛ ɲɔmɛɛ co, lekɛ lʼa tii Kilɛ mu ge, yi lee shɛ wù na. ");
INSERT INTO myk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wèe ya lemu ɲa Yesu mu, na lemu logo wu mu ge, wèe kunni da já bye yee jo baa wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A pʼi nɔhɔ pu fuguri sanha xuuni, na na pu yaha kari. Pu ya já kakuunɔ pye pu na wɛ. Pu bi fyagi sipyii pu na, bani kagbɔɔ lemu lʼa bi pye ge, sipyii pu bɛɛri bi Kilɛ sɔni lee wuu na. ");
INSERT INTO myk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Le kakanhana cuuŋɔgana le ya pye ná faan wemu na ge, lee bi wee ta wu yee wa bi ɲɛhɛ kɛlɛɛ shishɛɛrɛ (40) na. ");
INSERT INTO myk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba pʼa Pyɛɛri ni Yohana yaha wɛ, a pʼi gari pu kaafɛɛ nʼa daa fɛɛ pu yíri. Saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni nɔhɔlɛɛ pʼa yemu bɛɛri jo ni pu ni ge, a pʼi yee bɛɛri ɲaha jo pu mu. ");
INSERT INTO myk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba nʼa daa fɛɛ pʼa yee logo wɛ, a pu bɛɛri di binnɛ na pu zɔlɔɔ pu pye nigin, na Kilɛ ɲɛɛri na: «Wù Kafɔɔ, mu wemu wʼa fugba, ni ɲiŋɛ, ni suumɔ lɔhɔ, ni yi funŋɔ yaŋmuyɔ bɛɛri yàa ge. ");
INSERT INTO myk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wù tolɛ Dawuda we wu ɲɛ ma kapyebye ge, mu wʼa yi jo le wee ɲɔ ni Fɛfɛɛrɛ Munaa fanha ni na: ‹Ɲaha wuu na shi wu dʼa yìri na pe tunmɔ pe bɛɛri pyi wɛ? Ɲaha wuu na shi wu dʼa yìri na ɲuŋɔ baa woni pyi wɛ? ");
INSERT INTO myk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Koŋɔ ke wo saannaa pu wa na kashɛn yɛrɛyɛ luu; ɲuŋɔfɛɛ di puyɛ pinnɛɛ woni na Kafɔɔ Kilɛ kaa na, ni wʼa wemu ɲaha bulo na pye Shɔvɔɔ wu ge, ni wee bɛ kaa na.› ");
INSERT INTO myk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Can wu ɲɛ wii, saannaa Hɛrɔdi ni gbafɛnɛɛrɛɛ Pɔnsi Pilate, ni Izirayɛli shi we, ni shi wu sama, pee ya wɔ le kulo le ni. Ma fɛfɛɛrɛ kapyebye Yesu wemu ɲaha mʼa bulo ge, a pʼi yìri wee kaa na. ");
INSERT INTO myk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Lee funŋɔ ni, mu bi keree kiimu bɛɛri gbegele yaha ma fungɔngɔ fɛɛrɛ ni ma sefɛɛrɛ ti funŋɔ ni ge, a pʼi kee bɛɛri pye. ");
INSERT INTO myk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nimɛ do Kafɔɔ, pʼa wù fuguri fugurigana lemu na ge, mʼa lee ɲa. Wee tuun wu ni fanha kan ma kapyebyii pu mu, kɔnhɔ wù sii já wʼà ma kafila wu yu ni lowaa ni. ");
INSERT INTO myk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ma sefɛɛrɛ ti kan wù mu, kɔnhɔ wù já da yama fɛɛ cuuŋɔ, wù da ɲaha shɛshɛɛrɛ keree pyi, wù da kakanhaŋaa pyi ma fɛfɛɛrɛ kapyebye Yesu wu mɛgɛ na.» ");
INSERT INTO myk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba pʼa ɲɛrɛgɛ ki pye xɔ wɛ, xuu wemu ni pʼa pinnɛ ge, a wee xuu wu wo ɲiŋɛ kʼi jɛlɛ. A pu bɛɛri di ɲi Fɛfɛɛrɛ Munaa na. Na co wee tuun wu na, a pʼi fanha ta na ganha na Kilɛ jomɔ pu yu ni lowaa ni. ");
INSERT INTO myk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nʼa daa fɛɛ pu bɛɛri bi bɛ nigin na. Pu bi pu zɔlɔɔ pu pinnɛ, na pu fungɔnyɔ bɛɛri pinnɛ. Wa shishiin bi wu yaŋmuŋɔ pyi wuyɛ nigin wogo wɛ, ga pu yaŋmuyɔ bɛɛri yi bye fooba. ");
INSERT INTO myk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sefɛɛrɛ nigbɔɔrɔ ti bye tudunmɔɔ pu mu na yi yu sipyii pu mu na Yesu Kirisa ya ɲɛ na foro xu ni. A Kilɛ di fɛrɛmɛ tirige pu bɛɛri nigin nigin na xuuni. ");
INSERT INTO myk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yaaga bi wa shishiin kuuŋɔ pu ni wɛ, bani kɛrɛyɛ ni piyɛyɛ bye piimu mu ge, pee bi yee ya pɛrɛɛ. ");
INSERT INTO myk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Pu bu yemu pɛrɛ, pʼa ba wee wari we kan tudunmɔɔ pu mu. Pʼa wee wari we taa taa nʼa daa fɛɛ pu bɛɛri na, na bɛ ni pu bɛɛri nigin nigin wu cɔnrɔmɔ ɲuŋɔ kana ni. ");
INSERT INTO myk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lee funŋɔ ni ná wa bye wà, wee mɛgɛ ɲɛ na Yusufu. Levi wo kpɔɔn li shɛn wu bye wii, wu dʼa yìri Sipɛrɛ fiige ki ni. Tudunmɔɔ pʼi bi wu pyi na Barinabasi, (lee kɔri ɲɛ na wemu ya sipyii yɛri, na samɔhɔrɔ leni pu ni ge.) ");
INSERT INTO myk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tɛgɛ ka bye wee mu, a wu ba kee pɛrɛ, na ba wee wari we kan tudunmɔɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ayiwa, lee di ná wa bɛ ta wà, wee mɛgɛ ɲɛ na Anaɲasi. Wu shɔ mɛgɛ di ɲɛ na Safira. A pee bɛ di pu wo tɛgɛ ka pɛrɛ. ");
INSERT INTO myk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ga, a pu shuun wu jo bɛ, na wari wu taa, na taaga ka ŋmɔhɔ. A Anaɲasi di taaga ki saŋa lɔ na shɛ gan tudunmɔɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wee tuun wu ni a Pyɛɛri di wu pye: «Anaɲasi, ɲaha na mu dʼa Shitaanni yaha wʼa jé ma zɔ wu ni, na wu ɲi ni ke funguuŋɔ ke ni wɛ? Mu ya ma tɛgɛ ki pɛrɛmɛ pu taa na ŋmɔhɔ, na ba na pa kafinɛyɛ jo Fɛfɛɛrɛ Munaa li mu. ");
INSERT INTO myk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mu bye mu sanha ma tɛgɛ ki pɛrɛ-ɛ ge, ta ki bye mu kacɛ na wɛ? Mu ya ki pɛrɛ bɛ goo, ta mu bi da já ki pɛrɛmɛ pu bɛɛri pye ma ɲidaan pyegana na wɛ? Ɲaha na mu dʼa sɔɔ na le kakuunɔ le tuugo yaha lʼa tigi ma funŋɔ ni wɛ? Ma ganha ba giin nago sipyii mu mʼa kafinɛyɛ jo-e dɛ! Kilɛ mu mʼa yi jo.» ");
INSERT INTO myk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ba Anaɲasi ya yee logo wɛ, na do ɲiŋɛ na na xhu. Sipyii piimu bɛɛri pʼa yee logo ge, a fyaara di jé pee bɛɛri ni xuuni. ");
INSERT INTO myk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A lɛvɛɛ pʼi yìri na Anaɲasi nixhugo ki lɔ le gbo fatɔŋɔ ni, na shɛ le faŋa ni. ");
INSERT INTO myk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ba lɛɛrɛɛ taanri ya toro wɛ, a Anaɲasi shɔ wu bɛ di nɔ jé. Le lʼa pye wu poo wu na ge, lee di wu ta wu ya lee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A Pyɛɛri di wu yiri na wu pye: «Safira, can jo na ɲii na, mu ni ma poo wu ni ke wari ɲɔ ke na yee ya yi wo tɛgɛ ki pɛrɛ ya?» A Safira di jo: «Uun, ke wari ɲɔ ke na kʼa pɛrɛ.» ");
INSERT INTO myk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A Pyɛɛri di wu pye: «Wee tuun wu ni yi dʼa ta dii a yee shuun wu jo bɛ yi na na yʼi Kafɔɔ wo Fɛfɛɛrɛ Munaa li nɔhɔ wolo wɛ? Ayiwa, pii pʼa shɛ mu poo wu nixhugo ki le ge, pee wa kuɲɔɔ le ɲɔ na. Pʼa da zhɛ ni mu bɛ ni.» ");
INSERT INTO myk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Taapile ni a cee wu bɛ di do ɲiŋɛ na Pyɛɛri tɔɔyɔ ni, na xhu. Ba lɛvɛɛ pʼa jé wɛ, na wu bɛ nixhugo ta. A pʼi wu bɛ lɔ na shɛ le faŋa ni wu poo wu tàan. ");
INSERT INTO myk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A le kaa le di sii fyaara le nʼa daa fɛɛ pu bɛɛri zɔlɔɔ ni fo xuuni. Sipyii piimu bɛɛri pʼa yi logo ge, a pee bɛ di sii fya xuuni. ");
INSERT INTO myk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tudunmɔɔ pu bi kakanhaŋaa niɲɛhɛŋɛɛ ni ɲaha shɛshɛɛrɛ keree niɲɛhɛŋɛɛ pyi sipyii pu niŋɛ ni. Kilɛ-pɛɛŋɛ pugbɔhɔ ki kaaŋa ki xuu wemu wu wa na saannaa Solomani gba ge, wà nʼa daa fɛɛ pu bɛɛri bi puyɛ pinnɛɛ ni fungɔngɔ nigin ni. ");
INSERT INTO myk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sipyii pusamaa ni, wa shishiin bi gbara wu shɛ jé nʼa daa fɛɛ pu ni wɛ. Ga lee bɛ na sipyii pu bi pu sɔni xuuni. ");
INSERT INTO myk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A sipyii pʼi ganha na daa Kafɔɔ na na ɲɛhɛŋi, cèe fara namaa na. A pee bɛɛri di ganha na faraa nʼa daa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A lisana di ba ɲɛri fo sipyii pu na yama fɛɛ pu tugoo na ma na yɛri kodoroyo ni, karaya ni fuuyo na; kɔnhɔ Pyɛɛri nidorowo, ali wu ɲɛhɛ bye wu ya takpɔngɔ ta pu na wɛ, wu jaa we yɛ di já to pii na pee di juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sipyiɲɛhɛmɛɛ bɛ bi yìri kabanugo kulogoo ki ni na se Zheruzalɛmu ni ni yama fɛɛ niɲɛhɛmɛɛ, ni jinaa sipyii ni tudunmɔɔ pu mu. Pu bɛɛri bi juuŋɔ. ");
INSERT INTO myk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lee funŋɔ ni, saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we ni wu kaafɛɛ, pee ɲɛ Sadushɛɛn pu wo kuruŋɔ ke, a tudunmɔɔ pu wo ɲɛpɛɛn di jé pee ni. ");
INSERT INTO myk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","A pʼi yìri na tudunmɔɔ pu co, na shɛ pu le kasogbagbɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ga, a Kafɔɔ wo mɛlɛkɛ wa di ba kasogbaha ki mugi piige ki ni, na tudunmɔɔ pu yeege na pu pye: ");
INSERT INTO myk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Yʼa se yʼi shɛ diin Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Yʼi da pe ɲìi sicuumɔ nivomɔ pe keree yu sipyii pu bɛɛri mu.» ");
INSERT INTO myk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","A tudunmɔɔ pʼi wee mɛlɛkɛ wu ɲɔmɛɛ co. Ba ɲiga kʼa mugi yɛ wɛ, a pʼi sɔɔ kari Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na shɛ sipyii pu ɲɔ kɔn na galaa. Wee tuun wu ni a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu bɛ di ba nɔ ni wu kaafɛɛ pu ni, a pʼi kiirikɔɔn kuruŋɔ ke ni Izirayɛli nɔhɔlɛɛ pu bɛɛri yiri pinnɛ. A pʼi sɔrɔsii pii tun, na pu shɛ kasogbaha ki ni, pʼi shɛ tudunmɔɔ pu co pa. ");
INSERT INTO myk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ga ba sɔrɔsii pʼa nɔ kasogbaha ki ni wɛ, pu ya tudunmɔɔ pu ta wà wɛ. A pʼi guri pa na ba kiirikɔɔn kuruŋɔ ki pye: ");
INSERT INTO myk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Wèe ya shɛ kasogbaha ki ta kʼa shɔ̀hɔ ki shɔhɔgana na, gɛdii pu bɛ niyereye di ɲɛ kuɲɔgɔɔ ki ɲɔ na. Ga ba wèe ya ki mugi wɛ, wèe ya sipya bɛ ta ki funŋɔ ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ba Kilɛ-pɛɛŋɛ pugbɔhɔ ki gɛdii ɲuŋɔfɔɔ we ni saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pʼa yee logo wɛ, a tudunmɔɔ pu keree di pu ɲaha wɔ fo xuuni. A pʼi ganha na puyɛ pyi na: «Lekɛ di da ba bye wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na pu yaha yee na, a sipya wa di nɔ na pu pye: «Yee ya sipyii piimu tɔ kaso wu ni ge, pu wa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni na sipyii pu kalaa.» ");
INSERT INTO myk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wee tuun wu ni a gɛdii ɲuŋɔfɔɔ wu gari ni gɛdii ni. A pʼi shɛ tudunmɔɔ pu co na pa, ga pu ya ta mafɛ nɔ pu na wɛ. Bani pu bi fyagi na sipyii pu ɲuŋɔ ganha da nari pʼi pee wá ni kagereye ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ba pʼa pa nɔ ni tudunmɔɔ pu ni kiiri wu takɔngɔ ki ni wɛ, a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu pu yege na: ");
INSERT INTO myk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ta wèe ya yi jo na yi waha yee mu jo yi ganha bu da sipya wa shishiin kalaa nige we ná we mɛgɛ na-ɛ wɛ? Ga yee ya Zheruzalɛmu kulo li bɛɛri ɲi ni yi wo kalaa wu ni. Yee kunni ya sii na giin fo we ná we wo shishan pu ɲama di ba do wèe ɲuŋɔ ni.» ");
INSERT INTO myk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A Pyɛɛri ni tudunmɔɔ pusamaa di pu ɲɔ shɔ na: «Li waha lʼi waha, wèe ya yaa wèe pu Kilɛ ɲɔmɛɛ co na toro sipyii wuu na! ");
INSERT INTO myk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yee ya Yesu kori tige na na gbo, a wèe wo sefɛlɛɛ pu wo Kilɛ wu wu ɲɛ na yeege xu ni. ");
INSERT INTO myk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kilɛ ya wu durogo, na wu teŋɛ wuyɛ kanige cɛ, na wu pye Saan ni Shɔvɔɔ, kɔnhɔ Izirayɛli shɛɛn di já daburajɛ jo, pu jurumu wu yafa pu mu. ");
INSERT INTO myk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wèe pʼa pye kee keree ki wo sɛɛrɛɛ, wère ni Fɛfɛɛrɛ Munaa lemu Kilɛ ya gaan wu ɲɔmɛɛ covɛɛ pu mu ge.» ");
INSERT INTO myk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ba kiirikɔɔn kuruŋɔ kʼa pee jomɔ pu logo wɛ, a pu logoo di yìri xuuni, fo pu na tudunmɔɔ pu shaa di gbo. ");
INSERT INTO myk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ga Farizhɛn wa bye pu ni, wee mɛgɛ ɲɛ na Gamaliyɛli. Saliya karamɔgɔ wa wu bye wii, sipyii bɛɛri di bi baraga tɛri wu na. A wee di yìri yere kiirikɔɔn kuruŋɔ ki niŋɛ ni, na pu pye na pu tudunmɔɔ pu yeege kpɛɛngɛ ki na fɔlɔ jɛri. ");
INSERT INTO myk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ba tudunmɔɔ pʼa foro wɛ, a wu kiirikɔɔn kuruŋɔ ki pye: «Na cebooloo, Izirayɛli shɛɛn, kaa le yʼa giin di bye pii sipyii pii na ge, yi yi funŋɔ sha ni li ni xuuni dɛ! ");
INSERT INTO myk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bani li sanha mɔ toro wɛ, ná wa ya foro naha wu mɛgɛ ɲɛ na Tudasi. Wee ya yìri na wuyɛ pye sipyigbɔ kaɲahacɛmɛ wee ɲɛ, fo sipyii xhuu shishɛɛrɛ (400) shishiin ya taha wu fɛni. Ga pʼa pa wu gbo, a wu sipyii pu bɛɛri di jaaga. A kee keree kʼi da wà wee xuu wu ni. ");
INSERT INTO myk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lee kadugo na a wa bɛ di ba yìri sanha, wee bye Galile shɛn, wu mɛgɛ ki bye na Zhudasi. Tuun wemu ni pu bi fiige ki sipyii pu mɛyɛ yi kani ge, wee tuun wu ni wee ya yìri. Wee bɛ bi sipyiɲɛhɛmɛɛ ta na taha wuyɛ fɛni. Ga, a pʼi wee bɛ gbo, a wee bɛ wo sipyii pu bɛɛri di jaaga. ");
INSERT INTO myk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lee funŋɔ ni do, nʼa da kaa nigin jo yi mu: Yi ganha ba yiyɛ leni nige pii sipyii pii ni wɛ, yi pu yaha pu da gaaŋi. Pu fungɔnyɔ ye ni pu kapyegee ki bu da ki na yìri sipyii yíri, ki na ba xhɔ kiyɛ ni caŋa ka. ");
INSERT INTO myk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ga ki shiin bu shɛ da kʼa sii yìri Kilɛ yɛ pyaa ni, yʼa da já ki koo tɔ wɛ. Yi kasɛɛgɛ yaha yiyɛ na, yi ganha da yiyɛ yaha yi pa bye Kilɛ yokɔnɲii-i dɛ!» ");
INSERT INTO myk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ayiwa, a kiirikɔɔn kuruŋɔ kʼi sɔɔ Gamaliyɛli wo nijoyo yi na. A pʼi tudunmɔɔ pu yiri leŋɛ, na pu kpɔn ni susɔlɔɔ ni, na yi jo waha pu mu na pu ganha da Yesu kaa jo wa shishiin bɛ mu wɛ. Lee kadugo na na pu yaha kari. ");
INSERT INTO myk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A tudunmɔɔ pʼi laha kiirikɔɔn kuruŋɔ ki tàan na kari. A pu funyɔ di sii taan xuuni, bani shiige kaa le lʼa bi pu ta Yesu mɛgɛ ki wuu na ge, pʼa bi lee jate puyɛ mu gbɔɔrɔ kaa. ");
INSERT INTO myk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A pʼi ganha na sipyii pu kalaa ɲiga bɛɛri Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, ni pu kabanya ni, na yi yu pu mu na Yesu wu ɲɛ Shɔvɔɔ we. ");
INSERT INTO myk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ayiwa, nʼa daa fɛɛ pu bi ɲɛhɛŋi xuuni yee caya yi na. A Helenisitilee pʼi ba ganha na fiige ki wo Yawutuu pu zɔlɔɔ yu na pee ya li sɛɛri na li cɛ pu na, na pu ya pee wo naxhugoshaa pu jateni caŋa bɛɛri wo yaliye looloduun ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ba tudunmɔɔ kɛ ni shuun wʼa yee logo wɛ, na nʼa daa fɛɛ pu bɛɛri yiri na pu pye: «Wèe ya yaa wèe pu Kilɛ wo Jozaama pu jo wu yaha wù na wʼà yaliye keree ɲaha shɔɔnri wɛ. ");
INSERT INTO myk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lee wuu na wù cebooloo, yi namaa gbarashuun shɔɔnri yiyɛ ni, sipyii bɛɛri ya piimu mɛsaaŋa yu, pu dʼa ɲi Fɛfɛɛrɛ Munaa na, fungɔngɔ fɛɛrɛ bɛ di ɲɛ pu ni ge. Wù na yaliye yi keree ki ɲaha zhɔɔnri wu le pee keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wèe kunni wèe wa da zii wùyɛ pɔ ɲɛrɛgɛ ke ni Kilɛ wo Jozaama pu jo wu na.» ");
INSERT INTO myk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A pee jomɔ pe di daan sipyii pu bɛɛri ni. A pʼi sipyii gbarashuun wa ɲaha bulo. Pee pu wa mɛ: Ecɛni, wee bi fanha ta nʼa daa ni na nɔhɔ ɲi Fɛfɛɛrɛ Munaa bɛ na; Filipe, ni Porokɔrɛ, ni Nikanɔri, ni Timɔ, ni Parimenasi, ni Nikolasi, wee bye Ancɔsi shɛn. Wee bi fɛnhɛ jé Yawutuu wo koo li ni fɔlɔ na na pa bye nʼa daa fɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A pʼi shɛ ni pu ni tudunmɔɔ pu mu, a tudunmɔɔ pʼi pu keye taha pu na, na Kilɛ ɲɛɛri pu mu. ");
INSERT INTO myk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A Kilɛ jomɔ pʼi ganha na jaaga na se ɲaha na. A nʼa daa fɛɛ pʼi ganha na ɲɛhɛŋi Zheruzalɛmu kulo li ni. A Yawutuu saraya ɲaha shɔɔnrivɔɔ niɲɛhɛmɛɛ bɛ di dà Yesu na. ");
INSERT INTO myk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ecɛni bi ɲi Kilɛ wo niimɛ we ni wu sefɛɛrɛ ti na, fo wu na kakanhaŋaa nigbɔhɔɔ ni ɲaha shɛshɛɛrɛ keree pyi sipyii pu tɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ga, a sipyii pii di ganha na Ecɛni kaala, pee bi yìri Sirinɛ kulo li ni, ni Alɛkizandiri kulo le, ni Silisi fiige ke, ni Azi fiige ki ni. A pʼi nakaara ɲɔ kɔn na byi ni Ecɛni ni. Buloo piimu pʼa ɲuwuuro ta ge, pee wo Kilɛ-pɛɛŋɛ puga ki Yawutuu pu bye pii. ");
INSERT INTO myk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ga pu ya já can ta Ecɛni na wɛ, bani Fɛfɛɛrɛ Munaa li bi fungɔngɔ fɛɛrɛ kaan wu mu wu na yu. ");
INSERT INTO myk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wee tuun wu ni a pʼi sipyii pii saraa na pee sɔn wá Ecɛni na. A pee di ganha na yu na: «Wèe ya we ɲa wu na Kilɛ tudunmɔɔ Musa ni Kilɛ wo fanhara jomɔ yu.» ");
INSERT INTO myk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","A pʼi sipyii pee, ni nɔhɔlɛɛ pee, ni saraya ɲaha shɔɔnrivɔɔ pu sɔn mu lee sɔngana li na. A pʼi yìri kari Ecɛni fɛni, na shɛ wu co, na gari ni wu ni kiirikɔɔn kuruŋɔ ki mu. ");
INSERT INTO myk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","A kafinɛjuu pii bɛ di binnɛ ni pu ni, na shɛ kafinɛyɛ taha Ecɛni na na: «We ná we, tuun bɛɛri ni we ɲɛ na kafilakuumɔ yu na waa Kilɛ-pɛɛŋɛ pugbɔhɔ fɛfɛɛrɛ wogo ki na ni Kilɛ tudunmɔɔ Musa wo saliya wu na. ");
INSERT INTO myk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bani wèe ya wu ɲa wu na yu na Nazarɛti shɛɛn Yesu na ba Kilɛ-pɛɛŋɛ pugbɔhɔ ki ja; Musa ya kalɛgɛɛ kiimu kan wèe mu ge, na kee bɛɛri ɲɛri.» ");
INSERT INTO myk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A kiirikɔɔn kuruŋɔ ki sipyii pu bɛɛri di pu ɲahaya kɔ le Ecɛni ni na wii. A pʼi wu ɲaha ki ta kʼa ɲɛri ba mɛlɛkɛ wogo ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɔɔ wu Ecɛni yege na: «Jomɔ pe sipyii pu wa yu mɛ mu shizhaa na ge, can wʼa wii ya?» ");
INSERT INTO myk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A Ecɛni di wu ɲɔ shɔ na: «Na tii ni na ɲahafɛɛ, yi ye logo. Nɔɔrɔ fɔɔ Kilɛ ya wuyɛ shɛ wù tolɛ Ibirayima na na wu yaha Mezopotami fiige ki ni, na wu ta wu sanha yìri di zhɛ diin Karan kulo li ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na wu pye: ‹Ibirayima, foro ma fiige ki ni, mʼa yìri laha ma kpɔɔn li na. Fiige ke nʼa da zhɛɛ ma na ge, mʼa shɛ diin kee ni.› ");
INSERT INTO myk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Wee tuun wu ni a Ibirayima di yìri Kalide fiige ki ni na shɛ diin Karan kulo li ni. Lee kadugo na a Ibirayima to wu ba xhu. Fiige kemu ni yee wa mɛ niɲaa ge, a Kilɛ di wu ɲaha co na pa diin kee fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kilɛ bi ta xuu wa shishiin kan wu mu ke fiige ke ni wu ta wɛ, ali tɔɔgɔ tashanga bɛ wɛ. Ga Kilɛ bi ɲɔmɛɛ lɔ wu mu na wu na ba ke fiige ke kan wu mu, na ki kan wu kadugo ki bɛ mu wu kadugo na. Lee bi Ibirayima ta pya nigin bɛ ɲɛ wu mu wee tuun we ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kilɛ bi li shɛ na Ibirayima kadugo nagoo pu na ba shɛ diin nadadɛɛnrɛ na fiige katii ni. Kee fiige ki sipyii na ba pu ɲɛri buloo, na sii na kanhama nɔri pu na xuuni fo yee xhuu shishɛɛrɛ (400). ");
INSERT INTO myk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ga, a Kilɛ di guri jo sanha na fiige kemu wo sipyii pu da ba Ibirayima nagoo pu pye buloo ge, na weeyɛ pyaa na ba kiiri kɔn pee na. Lee kadugo na na Ibirayima kadugo ki na ba foro kee fiige ki ni, na ba ganha na wee pɛlɛ naha we xuu weyɛ pyaa ni. ");
INSERT INTO myk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lee kadugo na a Kilɛ ni Ibirayima di kariɲɛɛgɛ ɲɔmɛɛ lɔ puyɛ mu, na cekɔɔnrɔ pye lee wo ɲaha shɛshɛɛrɛ. Lee lʼa Ibirayima pye, wʼa pa Ishaaga se ge, na wu kɔn wu cazege caŋa gbarataanri wogo ki na. A Ishaaga bɛ di ba Yakuba se, a wu bɛ di wee kɔn. A Yakuba bɛ di wù sefɛlɛɛ kɛ ni shuun wu se, a wu bɛ di pee kɔn. ");
INSERT INTO myk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Wù sefɛlɛ wa bye wà wee mɛgɛ ɲɛ na Yusufu. Wee wo ɲɛpɛɛn ya pa jé wù sefɛlɛɛ pusamaa ni, fo pʼa wu co pɛrɛ Misira fiige ki shɛvɛɛ pii mu. ");
INSERT INTO myk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ga, a Kilɛ di bye ni wu ni, na wu yeege wu kanhama keree ki bɛɛri ni, na fungɔngɔ fɛɛrɛ kan wu mu, na wu kaa taan Farawɔn ni, Misira saan we. A Farawɔn di Misira fiige ki ɲuŋɔ fɛɛrɛ ti bɛɛri kan wu mu, na saanra puga ki bɛ wo ɲahagbaa fɛɛrɛ ti kan wu mu. ");
INSERT INTO myk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wee tuun wu ni a xuugbɔhɔ ka di ba jé Misira fiige ki bɛɛri, ni Kana fiige ki bɛɛri ni. A kanhama pʼi sii pɛlɛ fo xuuni. A wù sefɛlɛɛ pʼi bye pu ya ɲɔlige bɛ taa nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ba Yakuba ya pa logo na shinma wa Misira fiige ki ni wɛ, a wu wù sefɛlɛɛ pu tun pu tɔɔɲishiinɛ li ni pʼa shɛ shinma wa shɔ wà na pa. ");
INSERT INTO myk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba Yakuba, ya pa pu tun tɔɔɲii shuun wuu li ni wɛ, a Yusufu di shɛ wuyɛ shɛ wu cebooloo pu na. Wee tuun wu ni a Farawɔn bɛ di na Yusufu nɔhɔ tayirige cɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lee kadugo na a Yusufu di pu pye pʼa shɛ ba ni wu to wu ni wu puga shɛɛn pu bɛɛri ni. Pu bɛɛri bye sipyii kɛlɛɛ gbarashuun ni kaguro (75). ");
INSERT INTO myk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","A Yakuba di gari mu Misira ni, a wu ni wù sefɛlɛɛ pu bɛɛri di ba xhu wà. ");
INSERT INTO myk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba pʼa xu wà wɛ, a pʼi pu nixhuyo yi tugo na pa Sisɛmu kulo li ni. Ibirayima bi xuu taleŋɛ kemu shɔ Hamɔri nagoo pu mu Sisɛmu ni ge, a pʼi ba pu nixhuyo yi le wà. ");
INSERT INTO myk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ayiwa, Kilɛ bi ɲɔmɛɛ lemu lɔ Ibirayima mu ge, ba lee ɲɔ faduun ya dɛɛŋɛ wɛ, a Izirayɛli shɛɛn pʼi sii se na ɲɛhɛ Misira fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Lee kadugo na a fanha kʼi ba nɔ saan wa na, wee bi ta yaaga cɛ Yusufu keree ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A wee saan wu ganha na wèe shi wu kana ni shizhiinmɛ ni. Wu bi wèe sefɛɛ pu karamu na pu cogana kolo fo pʼa pu nagoo yɛri kpɛɛngɛ na, kɔnhɔ pu da xhuli. ");
INSERT INTO myk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wee tuun wu ni Kilɛ tudunmɔɔ Musa ya se. Wu pubinnɛ wo wu bi sii ɲɔ xuuni. A wu nu wu wu ŋmɔhɔ tofɔɔ wu kaban, na jire kan wu mu fo na nɔ yeboyo taanri na. ");
INSERT INTO myk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","A pʼi shɛ wu bɛ yaha kpɛɛngɛ ki na. A Farawɔn poro fucɛɛrɛ di wu lɔ, na wu bii ba wuyɛ pyaa ja ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A Musa di bye mu na sii kalaa Misira shɛɛn wo fungɔngɔ fɛɛrɛ keree ki bɛɛri ni. A baraga di bye wu ɲɔ jomɔ ni wu kapyegee ki bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ba Musa shi wʼa pa nɔ yee kɛlɛɛ shishɛɛrɛ (40) na wɛ, a wu yìri na wu shɛ wu cebooloo Izirayɛli shɛɛn pu pɛrɛgi. ");
INSERT INTO myk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tuun wemu ni Musa ya nɔ pu na ge, na Misira shɛn wa ɲa wu na kakuunɔ pyi wu ceborona wa na. A wu fara wu ceborona wu na, na wee kpɔn gbo, kɔnhɔ wu wu ceboro wu luu ɲiŋɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa bi giin na wee cebooloo pu na ba li cɛ lee funŋɔ ni na Kilɛ na ba pu ɲuŋɔ wolo bulooro ti ni, na pu yeege Misira fiige ki ni wee Musa keŋɛ kurogo. Ga wu cebooloo pu ya lee cɛ ta wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kee caŋa ki ɲimuguro a Musa di gari wu cebooloo pu yíri sanha. A wu shɛ wu cebooloo shuun wa ta pu na dunni, na pee susuro tɛgɛ na pu pye: ‹Yee ya cɛ nago cebooloo yee ɲɛ-ɛ gɛ? Ɲaha fɛni yee di dunni wɛ?› ");
INSERT INTO myk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ga wemu wu bi wu ceboro wu sani ge, a wee di Musa ŋmunuŋɔ na wu pye: ‹Jɔgɔ wʼa mu teŋɛ wèe ɲuŋɔ ni, na mu pye wèe kiiri kɔnvɔɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kɔnhɔ mu di wa giin mʼa nɛ bɛ gbo, ba mʼa Misira shɛn we gbo mɛ taɲaa wɛ?› ");
INSERT INTO myk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wee kafila wu wuu na a Musa di baa kari Madiyan fiige ki ni, na shɛ diin wà, na jalaa shuun ta wà. ");
INSERT INTO myk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ba yee kɛlɛɛ shishɛɛrɛ (40) ya toro wɛ, a mɛlɛkɛ wa di wuyɛ shɛ Musa na naɲiŋɛ ka ni tahara la funŋɔ ni, Sinayi faaboboŋɔ ki tàan, sige ki funŋɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ba Musa ya lee ɲa wɛ, a lee di wu fo fo xuuni. A wu ganha na fuloo li na, kɔnhɔ wu li kemɛ wii, ga, a Kafɔɔ Kilɛ di jo ni wu ni na wu pye: ");
INSERT INTO myk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Nɛ wu ɲɛ ma sefɛlɛɛ pu wo Kilɛ we, Ibirayima wo Kilɛ we, Ishaaga wo Kilɛ we, ni Yakuba wo Kilɛ we.› A Musa di fya fo na fuguri, wu ya sɔɔ na wu ɲuŋɔ yirige di wu wii nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lee kadugo na a Kafɔɔ di Musa pye: ‹Tanhaya yi wolo ma tɔɔyɔ yi na, bani xuu wemu ni mʼa yere ge, fɛfɛɛrɛ xuu wu ɲɛ wii. ");
INSERT INTO myk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nɛ wa na sipyii pu kanhagana li ɲaa Misira fiige ki ni, nɛ wa pu shiinnɛ li bɛ nuri. Nɛ tigi na pa di ba pu ɲuŋɔ wolo bulooro ti ni. Pa di ma tun zhɛ Misira ni.› ");
INSERT INTO myk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Ayiwa, wee Musa we ninumɔ Izirayɛli shɛɛn bi she ge, na jo: ‹Jɔgɔ wʼa mu teŋɛ wèe ɲuŋɔ ni, na mu pye wèe kiiri kɔnvɔɔ wɛ?› Wee Musa we Kilɛ ya pa dun wʼa shɛ bye pu ɲuŋɔfɔɔ. A wee di pu ɲuŋɔ wolo Misira bulooro ti ni Mɛlɛkɛ wu gbɔɔrɔ ni, wemu wʼa wuyɛ shɛ wu na, tahara li ni ge. ");
INSERT INTO myk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wee Musa we wʼa pu yeege Misira bulooro ti ni, na ɲaha shɛshɛɛrɛ keree ni kakanhaŋaa pye Misira fiige ki ni, ni pu nidorowuu Suumɔ Loɲiga ki ni, ni sipoŋɔ ki bɛ ni fo na nɔ yee kɛlɛɛ shishɛɛrɛ (40) na. ");
INSERT INTO myk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wee Musa wu wʼa Izirayɛli shɛɛn pye: ‹Kilɛ na ba Kilɛ tudunmɔ wa bɛ yaha na pa yi mu ba nɛ ɲɛ wɛ. Wee bɛ na ba bye yi ceboro wa.› ");
INSERT INTO myk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tuun wemu ni sipyii pu bi pa binnɛ sipoŋɔ ki ni ge, Musa bye ni pu ni. Mɛlɛkɛ we wu bye Sinayi faaboboŋɔ ki na ge, Musa wu bi nuri wee ɲɔ na na dorogo wù sefɛlɛɛ pu mu. Mu Musa bi Kilɛ wo baraga jomɔ nixhɔbaama pu taa, na pu kaan wèe mu. ");
INSERT INTO myk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Ga wù sefɛlɛɛ pu ya ta sɔɔ Musa wo jomɔ pu na wɛ. A pʼi zhe wu ni, na pu fungɔnyɔ caanna ɲɛri Misira yíri. ");
INSERT INTO myk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A pʼi Arɔn pye: ‹Pɛɛŋɛ yaŋmuyɔ ya yàa wù mu, yemu wù da da ɲaa ge, wù da ɲaari ni yee ni, bani Musa we wʼa wèe yeege Misira fiige ki ni ge, wèe ya wu ɲaa wɛ. Dii wʼa ɲɛri bɛ ge, wèe ya cɛ wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A pʼi nupige tuugo yàa yee caya yi na, na saraga wolo lee yapɛrɛ li mu, na funŋɔ tàan puyɛ pyaa wo keye wo labye wu na. ");
INSERT INTO myk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","«Wee tuun wu ni, a Kilɛ di wu kadugo le pu ni, na pu yaha fugba wɔrɔɔ kii bɛlɛ wu na, ma na jo ba lʼa ka Kilɛ tudunmɔɔ pu mu kafila wu ni kagana lemu na wɛ na: ‹Izirayɛli shɛɛn, yee ya yapɔrɔyɔ gbo, na saraya wolo nɛ mu sipoŋɔ ki ni yee kɛlɛɛ shishɛɛrɛ (40) funŋɔ ni ya? ");
INSERT INTO myk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yee ya ye saraya ye wolo nɛ mu-i dɛ, ga yee yapɛrɛ lemu mɛgɛ ki wa na Mɔlɔki ge, lee wo fàya bugu yee wa lɔ. Ni wɔrɔ lemu li ɲɛ na Aranfan ge, yee tuuyo yee wa yàa, na yee pɛlɛ. Lee wuu na nʼa da ba yee kuu na kari fo Babilɔni kadugo yíri.›» ");
INSERT INTO myk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","A Ecɛni di jo sanha na: «Na wèe sefɛlɛɛ pu yaha ɲara li na sige ki funŋɔ ni, fàya bugu wu bye pu mu. Wee funŋɔ ni Kilɛ bi yu ni pu ni. Kilɛ bi fàya bugu wa shɛ Musa na, ba wʼa wee wo yaagana li ɲa wɛ, na wu yàa mu. ");
INSERT INTO myk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lee kadugo na a wù sefɛlɛɛ pu ba wee fàya bugu wu kan pu nagoo mu. Zhozuwe wu bye pu ɲahagbaa fɔɔ wee tuun wu ni. A Kilɛ di pu tɛgɛ, na fiige ka wo sipyii kɔri pu mu. A pʼi gari ni fàya bugu wu ni kee fiige ki ni, a wu shɛ gori wà fo na pa nɔ saannaa Dawuda wo caŋa ɲii li na. ");
INSERT INTO myk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Saannaa Dawuda, wee bi sii fɛrɛmɛ ta Kilɛ mu. A wu Kilɛ ɲɛɛri na wu sɔɔ wee mu wee di pɛɛŋɛ puga ka yereŋɛ Yakuba wo Kilɛ wu mu. ");
INSERT INTO myk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ga wu ja Solomani, wee wʼa pa bye kee pɛɛŋɛ puga ki yereŋɛvɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ga wʼà li cɛ nago Kilɛ-gbɔtabaaga tatɛɛngɛ ɲɛ sipya wo puga niyaaga ni wɛ; ma na jo ba Kilɛ tudunmɔ wʼa yi jo wɛ, na Kafɔɔ Kilɛ ya jo na: ");
INSERT INTO myk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Fugba we, wee ɲɛ na saanra koro, ɲiŋɛ ke, kee ɲɛ na tɔɔyɔ tatahaŋa. Yee di da puga kekɛ yàa nɛ mu wɛ? Xuu wekɛ wu ɲɛ wà sanha wemu na já bye nɛ taŋmɔŋɔ wɛ? ");
INSERT INTO myk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta nɛ bɛ wʼa yee bɛɛri yàa na wo sefɛɛrɛ ti funŋɔ ni wɛ? Nɛ Kafɔɔ wʼa jo mu.› ");
INSERT INTO myk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Yee ɲuŋmogoo kʼa waha. Yee zɔlɔɔ ni yee niwegee ki ya ta cekɔɔnrɔ pye wɛ. Yee ya Fɛfɛɛrɛ Munaa li kaala tuun bɛɛri ni. Yee ni yi sefɛlɛɛ pu bɛɛri ya pye nigin. ");
INSERT INTO myk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kilɛ tudunmɔ wekɛ wu dʼa pye wà ni yee sefɛlɛɛ pu ya wu kanha-i wɛ? Pii pʼa Kilɛ wo sipyitiimɛ wu ba jomɔ pu jo ge, pʼa pee gbo. Nimɛ a yee di wee sipyitiimɛ wu bɛ nɔhɔ yaha, na wu gbo. ");
INSERT INTO myk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yee pʼa bi Kilɛ wo saliya wu keree ki ta mɛlɛkɛɛ gbɔɔrɔ ni, ga yee di ya sɔɔ na taha wee saliya we ɲaarigana fɛni wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ba kiirikɔɔn kuruŋɔ ki sipyii pʼa pee jomɔ pu logo wɛ, a pu logoo di sii yìri, fo pu na pu ganhaa kuri Ecɛni fɛni. ");
INSERT INTO myk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lee di Ecɛni ta wʼa ɲi Fɛfɛɛrɛ Munaa na. A wu fugba wu wii, na Kilɛ wo nɔɔrɔ wu ɲa, na Yesu niyerege ɲa Kilɛ kanige cɛ. ");
INSERT INTO myk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A wu jo: «Wii! Nɛ ɲii wa fugba we ni wʼa mugi, Sipya Ja we, na wee niyerege ɲaa Kilɛ kanige cɛ.» ");
INSERT INTO myk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ba Ecɛni ya yee jo wɛ, a pʼi sii sipyaa wá, na pu niwegee tɔ. A pu bɛɛri di gburogi na ba dɔ Ecɛni na. ");
INSERT INTO myk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na wu co, na wu kile na yeege kanha ki kadugo yíri, na shɛ wu wá ni kagereye ni fo na wu gbo. Pii pʼa wu gbo ge, pee bi pu fadeye wolo, na yee yaha lɛvɔɔ wa tàan, wee mɛgɛ ɲɛ na Sɔli. ");
INSERT INTO myk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na pu yaha pu na Ecɛni waa ni kagereye ni, a wu Kilɛ ɲɛɛri na: «Kafɔɔ Yesu! Na munaa li co!» ");
INSERT INTO myk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lee kadugo na a wu nuguro sin na sii mujuu wá na: «Kafɔɔ, ma ganha bu we jurumu we kaa taga pu co wɛ.» Ba wʼa yee jo wɛ, na xhu. ");
INSERT INTO myk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔli bɛ bi sɔɔ Ecɛni wo gbo wu na. Kee caŋa ke, a kanhama nigbɔ di sii nɔ nʼa daa fɛɛ pu bɛɛri na Zheruzalɛmu ni. Pee kanhama pu funŋɔ ni a nʼa daa fɛɛ pu bɛɛri di jaaga na kari Zhude fiige ke, ni Samari fiige ki ni. A tudunmɔɔ pu yɛ nigin di gori Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A Kilɛ wo ɲìi fyaara sipyii pʼa di Ecɛni nixhugo ki lɔ, na shɛ wu le. A pʼi sii mɛhɛɛ su wu nixhugo ki na xuuni. ");
INSERT INTO myk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ga Sɔli kunni, wee bi sii na giin fo wu nʼa daa fɛɛ pu xɔ fɛɛfɛɛ. Wu bi jin pu fɛni piyɛyɛ bɛ ni, wu bu nʼa daa fɛɛ piimu bɛɛri ta wà, cee la ná la, wʼa pu bɛɛri co fanha na na shɛ le kaso ni. ");
INSERT INTO myk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nʼa daa fɛɛ piimu pu bi paa foro Zheruzalɛmu ni ge, pee bi ɲaari na Kilɛ wo Jozaama pu yɛrɛ li pyi na mari xuu wu bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nʼa daa fɔɔ wa bye wà na Filipe, a wee di gari Samari kulo li ni, na shɛ ganha na Shɔvɔɔ wu kaa yu lee kulo li shɛɛn mu. ");
INSERT INTO myk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Filipe bi kakanhaŋaa kiimu pyi ge, ba kulo li shɛɛn pʼa kee kaa nuri, pii di ki ɲaa bɛ wɛ, a sipyiɲɛhɛmɛɛ di ba binnɛ, na niwegee shan ni Filipe jomɔ pu ni, na pu kemɛ logo. ");
INSERT INTO myk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bani Filipe bi jinaa kɔri na yeege sipyii ni. Pee jinaa pu bi sipyaa waa na fòro. Wu bi faannaa ni tɔɔyɔ nigin nigin fɛɛ cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A lee di bye fundanga kaa fo li nigbɔɔ le kulo le shɛɛn mu. ");
INSERT INTO myk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lee di ná wa ta wà lee kulo li ni wu mɛgɛ ɲɛ na Simɔ. Wʼa bi cɛmɛ keree niɲɛhɛŋɛɛ pyi fo kiimu ya Samari shɛɛn ɲaha wɔ xuuni ge, na wuyɛ pye sipyigbɔ wee ɲɛ. ");
INSERT INTO myk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sipyitiilee fara sipyigbɔɔ na, sipyii bɛɛri pu bi wu jateni, na yu na: «Kilɛ wo sefɛɛrɛ ti tʼa sii te, sefɛɛrɛ nigbɔɔrɔ te.» ");
INSERT INTO myk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pu bɛɛri bi wu jomɔ pu nuri xuuni, bani wʼa mɔ na cɛmɛ pu taga na kakanhaŋaa pyi kiimu ya pu ɲaha wɔ xuuni ge. ");
INSERT INTO myk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ga, a Filipe di Yesu Kirisa ni Kilɛ saanra ti wo Jozaama pu jo pu mu, a pʼi dà pu na. Namaa fara cèe na, a pu bɛɛri di ba batize. ");
INSERT INTO myk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Simɔ yɛ pyaa bɛ di dà Kilɛ wo jomɔ pu na na batize. A wu daha Filipe na. Filipe bi kakanhaŋaa ni ɲaha shɛshɛɛrɛ keree kiimu pyi ge, a kee di Simɔ ɲaha wɔ fo xuuni. ");
INSERT INTO myk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ayiwa, a tudunmɔɔ pʼi diin Zheruzalɛmu ni na logo na Samari shɛɛn pii ya dà Kilɛ Kafila wu na. A pʼi Pyɛɛri ni Yohana tun shɛ pu mu.» ");
INSERT INTO myk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba Pyɛɛri ni Yohana ya nɔ Samari ni wɛ, na Kilɛ ɲɛɛri Samari nʼa daa fɛɛ pu mu, kɔnhɔ Fɛfɛɛrɛ Munaa di digi pu na. ");
INSERT INTO myk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bani pee sipyii pu bi batize yɛ Yesu mɛgɛ na, ga Fɛfɛɛrɛ Munaa bi sanha digi wa shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wee tuun wu ni a Pyɛɛri ni Yohana di pu keye taha taha pu na, a Fɛfɛɛrɛ Munaa di digi pu na. ");
INSERT INTO myk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ayiwa, ba Simɔ ya Fɛfɛɛrɛ Munaa li ɲa lʼa tigi nʼa daa fɛɛ pu na tudunmɔɔ pu wo keye daha wu funŋɔ ni wɛ, a wu wari wolo na gaan tudunmɔɔ pu mu, ");
INSERT INTO myk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na pu pye: «Yi ke fanha ɲuŋɔ ke kan na bɛ mu, kɔnhɔ na bɛ ba na keŋɛ taha sipyaa sipya na, Fɛfɛɛrɛ Munaa di digi weefɔɔ na.» ");
INSERT INTO myk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A Pyɛɛri di Simɔ pye: «Ma ni ma wari wu ni, yi bɛɛri pu pinnɛ kyɛɛgi! Bani mu wa giin na kaa lemu Kilɛ ya gaan ma ni ge, na mu na já lee shɔ ni wari ni. ");
INSERT INTO myk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mu niŋɛ wa le kaa le ni wɛ, ma taa bɛ di wa li ni wɛ, bani mu zɔ wu ya tii Kilɛ ɲaha tàan wɛ. ");
INSERT INTO myk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fo ma bu daburajɛ jo ma fungɔnkuuŋɔ ki na, na Kafɔɔ ɲɛɛri, li bi da já bye wu ma zɔ wu wo katiibaagaa ki yafa ma mu. ");
INSERT INTO myk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bani nɛ mu zɔ wu ɲaa wʼa ɲi ɲɛpɛɛn ni jurumu na fo na mu pye jurumu wo bulo.» ");
INSERT INTO myk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ba Simɔ ya yee logo wɛ, na tudunmɔɔ pu ɲɔ shɔ na: «Yiyɛ pyaa ki Kafɔɔ ɲɛɛri na mu, kɔnhɔ yʼa yemu jo ge, Kilɛ di na tanha yee bɛɛri na.» ");
INSERT INTO myk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ba Pyɛɛri ni Yohana ya Kilɛ ni Kafɔɔ wo Jozaama pu jo xɔ sipyii pu mu wɛ, na guri kari Zheruzalɛmu ni. Pu nigariwuu a pʼi ganha na Kilɛ wo Jozaama pu yu Samari kulogoo niɲɛhɛŋɛɛ kiitiigee ni na gaaŋi. ");
INSERT INTO myk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kafɔɔ wo mɛlɛkɛ wa ya pa jo ni Filipe ni na wu pye: «Yìri mʼa shɛ Kilɛ-parama pe ni. Koo le lʼa yìri Zheruzalɛmu ni na kari Gaza ni ge, mʼa lee koo li lɔ. Sipoŋɔ koo li wa lii.» ");
INSERT INTO myk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A Filipe di yìri na koo li lɔ na gaaŋi. Na wu nigaraga yaha, a wu Ecopi shɛn ná wa ɲa. Ecopi fiige ki saanzhɔ wemu mɛgɛ ki wa na Kandasi ge, wee saanzhɔ wu wo ɲuŋɔfɔɔ nigbɔ wu bye wee ná we. Wee wu bye cee wu naafuu keree bɛɛri ɲaha shɔɔnrivɔɔ. Wee ná wu bi kari Zheruzalɛmu ni na shɛ Kilɛ pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wu niguribawo wu bye na tiin wu wotori funŋɔ ni, na xuu wa kalaa Kilɛ tudunmɔɔ Ezayi wo Kitabu wu ni. ");
INSERT INTO myk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Fɛfɛɛrɛ Munaa di Filipe pye: «Gbara wotori wu na, mʼa binnɛ ni wu ni!» ");
INSERT INTO myk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A Filipe di baa fulo wotori wu na, na wee Ecopi shɛn wu ta wu na xuu wa kalaa Kilɛ tudunmɔɔ Ezayi wo Kitabu wu ni, na wu yege na: «Xuu wemu mu wa galaa mɛ ge, mʼa wu kɔri cɛ gɛ?» ");
INSERT INTO myk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A ná wu Filipe pye: «Dii nʼa da wu kɔ́ri cɛ na ta wa ya wu kɔ́ri shɛ na na-ɛ wɛ?» A wu Filipe ɲɛɛri na wu jé tiin wee tàan wotori wu ni. ");
INSERT INTO myk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Xuu we wu bi galaa ge, wee wu wa mɛ we na: «Wu bye ba dubya ɲɛ wɛ, pʼa wemu co na gaaŋi tagbogo ni ge. Ma na jo dubya wemu wu ɲɛ wu ya yaaga yu wu shiire kɔnvɛɛ keŋɛ ni-i ge. Wu ya yaaga jo wɛ. ");
INSERT INTO myk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wu bi wuyɛ tirige, pʼi ya ta sɔɔ na kaɲii kan wu mu wɛ. Jɔgɔ wu dʼa já wu shi nibama wu kaa jo wɛ? Sipya bɛ wɛ! Bani pʼa wu gbo na wu shi wu piinŋɛ koŋɔ puga ni.» ");
INSERT INTO myk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ayiwa, a ɲuŋɔfɔɔ wu Filipe pye: «Nʼa ma ɲɛɛri, sipya wemu kaa Kilɛ tudunmɔ wʼa byi ge, wufɔɔ shɛ na na. Wuyɛ kaa wʼa byi laa watii?» ");
INSERT INTO myk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wee tuun wu ni a Filipe di jomɔ pu lɔ, na pu ɲɔ kɔn pe Kitabu jomɔ peyɛ pyaa na, na Yesu kaa jo wee na wu mu. ");
INSERT INTO myk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na pu yaha pu na gaaŋi, a pʼi ba shɛ nɔ lɔhɔ ka na. A ɲuŋɔfɔɔ wu Filipe pye: «Lɔhɔ ki wa mɛ, ɲaha kʼi da nɛ ɲaha kɔn batizeli na wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","A Filipe di wu pye: «Ma bi dà Yesu na ni ma zɔ wu bɛɛri ni, ma na já batize.» A ná wu wu ɲɔ shɔ na: «Nɛ dà li na nago Yesu Kirisa ɲɛ Kilɛ Ja.» ");
INSERT INTO myk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ba wʼa yee jo wɛ, na jo na pu wotori wu yereŋɛ. A pu shuun wu bɛɛri di digi lɔhɔ ki ni. A Filipe di wu batize. ");
INSERT INTO myk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba pʼa foro lɔhɔ ki ni wɛ, a Kafɔɔ wo Munaa lʼi Filipe ɲaha co, na gari ni wu ni. Ɲuŋɔfɔɔ wu ya Filipe ɲa nige wɛ, ga, a wu fundanga wo kunni di koo li lɔ na gaaŋi. ");
INSERT INTO myk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A Filipe di shɛ wuyɛ ta fo Azɔti kulo li ni. Ba wʼa yìri wà wɛ, na gari Sezare kulo li ni. Wu nigariwo ya toro kulo lemu bɛɛri ni ge, a wu Kilɛ wo Jozaama pu jo toro kee bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na Sɔli yaha wu na dahaziire tɛri Kafɔɔ kalaapiire ti mu, a wu shɛ saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu mu, ");
INSERT INTO myk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na wu ɲɛɛri na wu sɛmɛ wa yàa kan wu mu wu shɛ gan Damasi kulo li wo Kilɛ-pɛɛŋɛ piyɛyɛ yi sipyii pu mu. Kɔnhɔ wu bu shɛ Kafɔɔ wo koro li ɲaarivɛɛ pii ta wà, cee fara ná na, wu pee co, wu pu pɔ wʼa se Zheruzalɛmu ni, ");
INSERT INTO myk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","na wu nigariwo yaha koo li na ni wee sɛmɛ wu ni, ba wʼa shɛ dɛɛŋɛ Damasi kulo li na wɛ, taapile ni a kpɛɛngbɔhɔ ka di yìri fugba we ni na ɲí jé wu ɲaha ni, na wu maha. ");
INSERT INTO myk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kee kpɛɛngɛ ki bɛlɛ funŋɔ ni, a Sɔli di wolo to ɲiŋɛ na. A mujuu la di wu pye: «Sɔli, Sɔli, ɲaha na mʼa na kana mɛ wɛ? Lʼa waha mu mu mu wu kuruŋɔ tɔɔrɔ ŋmaa na dɛ!» ");
INSERT INTO myk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A Sɔli di fya, na ganha na jɛlɛ. A wu yegeŋɛ pye na: «Kafɔɔ, mʼi ɲɛ jɔgɔ wɛ?» A mujuu lʼi wu pye sanha: «Nɛ ɲɛ Yesu, nɛ mu wa gana mɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nimɛ, yìri mʼa jé kulo li ni; lemu mʼa yaa na pye ge, pu na lee jo ma mu.» ");
INSERT INTO myk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A Sɔli ɲaariɲii pu bɛɛri jaalaa di yìri. A pʼi yere yaha, pu ya já yaaga jo wɛ. Pu kunni bi mujuu le nuri, ga pʼi ya sipya ɲa wɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A Sɔli di yìri yere na wu ɲìi mugi, ga wu ya yaaga ɲaa ki ni wɛ. A pʼi wu co keŋɛ na na jé Damasi puuro ti ni. ");
INSERT INTO myk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A Sɔli di cabyaa taanri pye wu ya ɲaa wɛ, wu ya li wɛ, wʼi ya lɔhɔ bɛ gba wɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wee tuun wu ni Yesu wo kalaapire la bye Damasi kulo li ni na Anaɲasi. A Kafɔɔ di wuyɛ shɛ wee na na wu pye: «Anaɲasi!» A wu jo: «Ooyi, di we Kafɔɔ.» ");
INSERT INTO myk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","A Kafɔɔ di wu pye: «Yìri tɔvuyo na, koo lemu pʼa byi na ‹Kozinnɛ› ge, mʼa lee lɔ mʼa se Zhudasi kaban. Ma bu shɛ nɔ wà, Tarisi shɛn ná wa ɲɛ wà na Sɔli, mʼa wee kaa yege. Kilɛ-ɲɛrɛgɛ na wu wa. ");
INSERT INTO myk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ga le nɛ Kilɛ ya shɛ Sɔli na wu wo ɲɛrɛgɛ ki funŋɔ ni ge, lee li wa mɛ. Wʼa ná wa ɲa wu mɛgɛ na ɲɛ Anaɲasi, wee ya jé wu fɛni na wu keye taha wu na, kɔnhɔ wu guri wʼa ɲaa sanha.» ");
INSERT INTO myk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A Anaɲasi di jo: «Ee, Kafɔɔ! We ná we ya kanhama nigbɔ pemu taha mu kalaapiire ti na Zheruzalɛmu ni ge, sipyiɲɛhɛmɛɛ ya yee jo nɛ mu. ");
INSERT INTO myk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sɛmɛ wa ni wʼa pa naha bɛ na yìri saraya ɲaha shɔɔnrivɛɛ pu keŋɛ ni Zheruzalɛmu ni. Na wu ba sipyaa sipya ta wu na mu mɛgɛ ki yiri naha, wu weefɔɔ co, wu wu pɔ wʼa gaaŋi.» ");
INSERT INTO myk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ga, a Kafɔɔ di Anaɲasi pye: «Shɛ, bani nɛ we na we ɲaha bulo, kɔnhɔ wu da kapyeŋɛɛ pyi na mu, wu na mɛgɛ ki shɛ shi wusama na, wu ki shɛ pu saannaa pu na, wu ki shɛ Izirayɛli shɛɛn pu bɛ na. ");
INSERT INTO myk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kanhama pemu bɛ pu da ba nɔ wu na nɛ wuu na ge, di pee bɛ shɛ wu na.» ");
INSERT INTO myk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ayiwa, a Anaɲasi di yìri kari. Ba wʼa shɛ nɔ puga ki ni wɛ, na wu keye taha Sɔli na na wu pye: «Na ceborona Sɔli, Kafɔɔ Yesu we wʼa wuyɛ shɛ ma na koo li na, na ma yaha ma na ma naha ge, wee wʼa nɛ tun ma mu, kɔnhɔ mʼa já mʼa ɲaa, mʼa nɔhɔ ɲi Fɛfɛɛrɛ Munaa na.» ");
INSERT INTO myk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Taapile ni a kɔɔrɔ ta di wolo wolo to Sɔli ɲìi ni ba fyakɔɔrɔ ɲɛ wɛ. A wu ɲìi kʼi mugi; a wu yìri; a pʼi wu batize. ");
INSERT INTO myk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Lee kadugo na a wu li, a fanha di jé wu ni. A Sɔli di gori Damasi ni na cabyaa dama dama pye ni Yesu kalaapiire ti ni. ");
INSERT INTO myk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A Sɔli di Kilɛ jomɔ yɛrɛ ɲɔ kɔn wee tuun wuyɛ pyaa ni na yu Damasi ni, Yawutuu wo Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, na pu pyi na: «Kilɛ Ja wu ɲɛ Yesu.» ");
INSERT INTO myk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sipyii piimu bɛɛri pu bi wu jomɔ pu nuri ge, a lʼi pu bɛɛri fo xuuni, a pʼi ganha na yu na: «Ta we ná weyɛ pyaa bɛ ki bi Yesu mɛgɛ ki yirivɛɛ pu kana Zheruzalɛmu ni wɛ? Go wu kapana ɲuŋɔ ki wa mɛ naha, pii pʼa Yesu mɛgɛ ki yiri ge, kɔnhɔ wu ba pee co, wu pu pɔ wu shɛ gan saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ pu mu Zheruzalɛmu ni.» ");
INSERT INTO myk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ga, a la di ganha na faraa Sɔli wo fanha ki na nʼa daa wu shizhaa na caŋa bɛɛri. Wu bi Kilɛ jomɔ pu yɛrɛ pyi, na li shɛɛ pu na na Shɔvɔɔ wu ɲɛ Yesu, a wu keree di Damasi wo Yawutuu pu ɲaha wɔ, fo pu ya cɛ yekɛ pu da yu wɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ayiwa, ba piiye ya ya toro wɛ, a pee di puyɛ ɲa, na bɛ yi na na pʼi Sɔli gbo. ");
INSERT INTO myk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ga, a Sɔli di foro pu woni wu fiin. Pu bi kulo li tajeye yi bɛɛri shazhɔn sigee caŋa ni piige, kɔnhɔ pʼi sii Sɔli ta pu gbo. ");
INSERT INTO myk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ga, a Yesu wo kalaapiire tʼi ba Sɔli le sagana funŋɔ ni caŋa ka piige, na mɛɛrɛ taga wu torogo ɲɛri kanha kadugo. ");
INSERT INTO myk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lee kadugo na a Sɔli di gari Zheruzalɛmu ni. Ba wʼa nɔ wà wɛ, na ganha na giin wu binnɛ ni kalaapiire ti ni. Ga pu bɛɛri bi fyagi wu na, bani pu bi dà li na can na na Sɔli bɛ wu ɲɛ Yesu wo kalaapire la wɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ga kalaapire lemu li bye na Barinabasi ge, a wee di gari ni Sɔli ni tudunmɔɔ pu yíri. Ba pʼa nɔ wà wɛ, Sɔli ya Kafɔɔ ɲa ɲagana lemu na Damasi koo li na, a Kafɔɔ bɛ di jo ni wu ni jogana lemu na ge, na fara lee na Sɔli ya Yesu kaa jo na fiinŋɛ ni lowaa ni Damasi kulo li sipyii pu bɛɛri mu jogana lemu na ge, a Barinabasi di yee bɛɛri paari tudunmɔɔ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Na lɔ wee tuun wu na a Sɔli di binnɛ ni pu ni. A pʼi ganha na ɲaari Zheruzalɛmu bɛɛri ni. Wu bi Kilɛ wo Jozaama pu yu ni lowaa ni Kafɔɔ mɛgɛ na. ");
INSERT INTO myk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sɔli bi yu ni Helenisitilee pu ni, na nakaara pyi ni pu ni Yesu keree na. Ga pee bɛ bi wu shaa di gbo. ");
INSERT INTO myk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ba cebooloo pʼa lee cɛ wɛ, na gari ni Sɔli ni Sezare ni. Lee kadugo na na wu yaha kari Tarisi kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ayiwa, wee tuun wu ni nʼa daa fɛɛ piimu bɛɛri pu bye Zhude, ni Galile, ni Samari fiiye yi ni ge, ɲaɲiŋɛ bye pee bɛɛri na. Pu bɛɛri bi ɲaari Kafɔɔ ɲìi fyaara ni, lee li bi pu baraga pye ki na bɛlɛ nʼa daa wu ni. Caŋa caŋa pii bi faraa pu na Fɛfɛɛrɛ Munaa li wo yɛri wu fanha ni. ");
INSERT INTO myk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pyɛɛri bi ɲaari, na nʼa daa fɛɛ pu pɛrɛgi fiige ki bɛɛri ni. Caŋa ka a wu ba gari nʼa daa fɛɛ pii yíri kulo la ni lee mɛgɛ ɲɛ na Lida. ");
INSERT INTO myk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A wu shɛ ná wa ta wu kabanuyo shuun wu bɛɛri ya xu, a wu sinnɛ fo yee gbarataanri (8), wu mɛgɛ di ɲɛ na Ene. ");
INSERT INTO myk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A Pyɛɛri di wu pye: «Ene, Yesu Kirisa wʼa da ma cuuŋɔ nimɛ. Yìri mʼa ma yasinnɛgɛ ki yàa mayɛ ni.» Taapile ni a Ene di yìri. ");
INSERT INTO myk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ba Lida kulo li shɛɛn pu bɛɛri ni Sarɔn kulo li shɛɛn pu bɛɛri ya lee ɲa wɛ, na sɔɔ Kafɔɔ na. ");
INSERT INTO myk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ayiwa, cee wa bye Zhope ni, nʼa daa fɔɔ wu bye wii, wu mɛgɛ di ɲɛ na Tabita. Kee mɛgɛ ke ɲɛ Girɛkii wo jomɔ pu ni na Dorikasi. Wee cee wu bi kasaaŋaa niɲɛhɛŋɛɛ pyi, na funmɔ fɛɛ tɛri. ");
INSERT INTO myk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wee tuun wu ni a Tabita di ba bana, na xhu. A pʼi wu nixhugo ki wuu na wu lɔ shɛ sinniŋɛ puga ka ni zangaso wu ni. ");
INSERT INTO myk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lee di Pyɛɛri ta Lida ni. Lida ni Zhope di ya lii wɛ. A Zhope kulo li kalaapiire tʼi logo na Pyɛɛri wa Lida ni. A pʼi sipyii shuun yaha kari pu shɛ Pyɛɛri ɲɛɛri na wu pa pu yíri nimɛ. ");
INSERT INTO myk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ayiwa, ba pʼa nɔ na tuduro ti jo Pyɛɛri mu wɛ, taapile ni a Pyɛɛri di yìri na binnɛ kari ni pu ni. Ba wʼa nɔ wɛ, a pʼi gari ni wu ni kee puga ki ni zangaso wu ni. A naxhugoshaa pʼi ba na ba Pyɛɛri maha, na ganha na mɛhɛɛ suu. Na Tabita yaha ɲìi na, wu bi fadepiire ni fadegbɔyɔ yemu yari ge, a pʼi yee bɛɛri shɛ Pyɛɛri na. ");
INSERT INTO myk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wee tuun wu ni a Pyɛɛri di sipyii pu bɛɛri yeege kpɛɛngɛ ki na, na nuguro sin na Kilɛ ɲɛɛri. Na xhɔ na ŋmahana ɲɛri gbo wu yíri, na wu pye: «Tabita, yìri!» A gbo wu wu ɲìi mugi, ba wʼa Pyɛɛri ɲa wɛ, na yìri tiin. ");
INSERT INTO myk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","A Pyɛɛri di wu co wu keŋɛ na, na wu tɛgɛ, na wu yirige. Lee kadugo na a Pyɛɛri di nʼa daa fɛɛ pee ni naxhugoshaa pu yiri, na Tabita ɲìi wo wu shɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A Zhope kulo li sipyii pu bɛɛri di yee logo, a sipyiɲɛhɛmɛɛ di ganha na daa Kafɔɔ na. ");
INSERT INTO myk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A Pyɛɛri di gori Zhope ni, na mɔ wà ná wa kaban, wee mɛgɛ ɲɛ na Simɔ. Sɛɛyɛ wee Simɔ wu bi gbuu. ");
INSERT INTO myk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ná wa bye Sezare kulo li ni na Kɔrinɛyi. Oromɛ fiige ki sɔrɔsii ɲuŋɔfɔɔ wa wu bye wii. Sɔrɔsii kuruŋɔ kemu ɲuŋɔ ni wu bye ge, kee ɲɛ na «Itali sɔrɔsii kuruŋɔ.» ");
INSERT INTO myk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wee ná wu bi Kilɛ pɛlɛ wu ni wu puga shɛɛn bɛɛri ni. Pu bi fyagi Kilɛ na. Wu bi Yawutuu funmɔ fɛɛ pu tɛri. Wu bi ganri bɛ Kilɛ-ɲɛrɛgɛ tàan wɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ayiwa, caŋa ka yakoŋɔ tuunɔ ɲii taanri wu na, Kilɛ wo mɛlɛkɛ wa ya pa jé Kɔrinɛyi kaban, na wuyɛ shɛ wu na; a wu sii wu tii ɲa; a mɛlɛkɛ wu wu yiri na: «Kɔrinɛyi!» ");
INSERT INTO myk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ba wʼa wu ɲa wɛ, na fya na jo: «Ɲaha wɛ Kafɔɔ?» A mɛlɛkɛ wu wu pye: «Ma Kilɛ-ɲɛrɛgɛ ke ni ma funmɔ fɛɛ pu dɛgɛ wu kaa ya taan Kilɛ ni, wu ya ta funŋɔ wɔ ma na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sipyii pii tun shɛ nimɛ Zhope kulo li ni. Ná wa wu wa wà na Simɔ, pʼi wu pyi Pyɛɛri. Pʼi shɛ wee yiri pa. ");
INSERT INTO myk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ná sɛɛyɛ gbovɔɔ wa ɲuŋɔ ni wʼa tigi, wee bɛ mɛgɛ ki wa na Simɔ wa. Wu puga ki wa suumɔ lɔhɔ ki ɲɔ na.» ");
INSERT INTO myk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ba mɛlɛkɛ wʼa jo xɔ ni wu ni wɛ, na gari. Wee tuun wu ni a Kɔrinɛyi di wu kapyebyii shuun, ni wu sɔrɔsi nigin wa yiri. Wee sɔrɔsi we bye wuyɛ pyaa wo shazhɔnsigimɛ. Kilɛ ɲìi fyaara sipya wu bye wii. ");
INSERT INTO myk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mɛlɛkɛ wʼa yemu jo wu mu ge, a wu yee bɛɛri paari pu mu, na pu tun kari Zhope ni. ");
INSERT INTO myk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kee caŋa ki ɲimuguro a tudunmɔɔ pʼi dɛɛŋɛ Zhope kulo li na. Lee di caŋa ki ta ɲiŋɛ niŋɛ ni, a Pyɛɛri di dugi kataŋa na na Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A xuugo di ba wu ta pʼi sanha shɔhɔ xɔ wɛ. Na pu yaha pu na yalige ki sori Pyɛɛri mu, a Kilɛ di kaa la shɛ wu na. ");
INSERT INTO myk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A wu fugba wu ɲɔ ɲa kʼa mugi, na yaaga ka ɲa wà kemu ya foro fatɔgbɔhɔ fɛni ge. Ki geye shishɛɛrɛ we bi co pɔ, kʼi diri na ma ɲiŋɛ mu. ");
INSERT INTO myk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A Pyɛɛri di tɔɔyɔ shishɛɛrɛ yaŋmuyɔ ye bɛɛri, ni ɲiŋɛ yakokaara bɛɛri, ni shazhɛɛrɛ tuuyo bɛɛri ɲa kee fatɔbɔgɔ ke funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A mujuu la di Pyɛɛri pye: «Pyɛɛri yìri, mʼa ya gbo ma xa!» ");
INSERT INTO myk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A Pyɛɛri di jo: «Ahayi, Kafɔɔ! Yaaga kemu bɛɛri kʼa nɔhɔ, kelee ki na ɲɛ yafunŋɔ ge, nɛ sanha kee ka shi li ɲa wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A mujuu lʼi foro sanha na Pyɛɛri pye: «Kilɛ ya yaaga kemu pye fɛɛfɛɛ ge, ma ganha ba kee wii sanha yaŋmunɔrɔgɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A pee jomɔ pʼi jo fo tɔɔɲii taanri, taapile ni a fatɔbɔgɔ kʼi dugi kari fugba wu ni. ");
INSERT INTO myk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A Pyɛɛri hakili di wuregi, le wʼa ɲa ge, a wu ganha na wuyɛ yegee lee kɔri na. Na wu yaha lee na, Kɔrinɛyi ya sipyii piimu tun ge, a pee di nɔ Zhope kulo li ni. A pʼi Simɔ kaban kaa yege, a pʼi xuu wu sanha shɛ pu na, a pʼi shɛ yere kuɲɔɔ li ɲɔ na. ");
INSERT INTO myk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na yiri pye na jo: «Simɔ we pʼa bi na Pyɛɛri ge, naha wʼa tigi ya?» ");
INSERT INTO myk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lee di Pyɛɛri ta wu na wu funŋɔ kɔɔn sanha wu kaɲaa li na. A Kilɛ Munaa di wu pye: «Pyɛɛri, wii! Sipyii taanri wu wa na mu kaa yegee kpɛɛngɛ ke na. ");
INSERT INTO myk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yìri, mʼa binnɛ mʼa gaaŋi ni pu ni, ma ganha bu fyaara yaha ma zɔ wu na wɛ, bani nɛ wʼa pu tun ma mu.» ");
INSERT INTO myk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A Pyɛɛri di digi pa, na ba pu pye: «Sipya wemu xuu yi wa zhaa ge, nɛ wu wa wii. Lekɛ lʼi wa yi kapana ɲuŋɔ wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A pʼi Pyɛɛri ɲɔ shɔ na: «Sɔrɔsii ɲuŋɔfɔɔ we wu wa na Kɔrinɛyi ge, wee wʼa wèe tun. Sipyitiimɛ wu wa, na fyagi bɛ Kilɛ na, Yawutuu pu bɛɛri wa wu mɛsaaŋa yu. Kilɛ wo mɛlɛkɛ wa wʼa wuyɛ shɛ wu na, na wu pye na wu tudunmɔ yaha pa mu yíri, mʼi shɛ wu kaban. Na kafila wa wu wa mu mu, mu wu jo wu mu.» ");
INSERT INTO myk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ba Pyɛɛri ya yee logo wɛ, na jé ni pu ni puga. A pʼi shɔn wà. Ba ɲiga kʼa mugi wɛ, a wu binnɛ kari ni pu ni. A Zhope nʼa daa fɛɛ pii bɛ di binnɛ kari ni pu ni. ");
INSERT INTO myk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kee caŋa ki ɲimuguro a pʼi nɔ Sezare ni, na Kɔrinɛyi ta wu bi pu sigee. Wu bi wu puga shɛɛn ni wu see see naɲiinɛɛ yiri pinnɛ wu puga na Pyɛɛri sigee. ");
INSERT INTO myk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ba Pyɛɛri ya nɔ wà wɛ, a Kɔrinɛyi di ba wu ɲuŋɔ círi, na nuguro sin wu fɛɛ ni, na wu pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ga, a Pyɛɛri di wu co yirige, na wu pye: «Yìri, nɛ bɛ wu ɲɛ sipyiyawyii la ba mu ɲɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na Pyɛɛri ni Kɔrinɛyi yaha pee jomɔ pu na, a pʼi binnɛ jé puga ki ni na sii sipyiɲɛhɛmɛɛ ta pʼa pinnɛ wà. ");
INSERT INTO myk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wee tuun wu ni a Pyɛɛri di wu pye: «Na saha ni wèe wo saliya wu ni, yʼa li cɛ, Yawutu wa shishiin ya yaa na gari ni shi watii sipyii ni piimu ɲɛ Yawutuu wɛ, kelee na jé wufɔɔ puga wɛ. Ga Kilɛ ya li shɛ nɛ na, na nɛ ganha da sipya wa shishiin wii na wu ɲɛ fɛɛfɛɛ wɛ, kelee wʼa nɔhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lee wuu na ba yee tudunmɔɔ pʼa nɔ nɛ na wɛ, nɛ ta nakaara pye wɛ. Nimɛ nɛ funŋɔ wa yʼi na kayire li ɲuŋɔ jo na mu.» ");
INSERT INTO myk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Kɔrinɛyi di Pyɛɛri ɲɔ shɔ na: «Niɲaa ɲɛ li caŋa shishɛɛrɛ wogo, na nɛ yaha Kilɛ-ɲɛrɛgɛ na na puga ki ni yakoŋɔ ni we tuun we shi ni, a nɛ ná wa niyerege ɲa na ɲahagbaa na fadevige na ɲɛ wu na, ki bɛɛri di ɲí. A wu nɛ pye: ");
INSERT INTO myk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹Kɔrinɛyi, ma Kilɛ-ɲɛrɛgɛ kʼa co. Tɛgɛgana lemu na mʼa funmɔ fɛɛ pu tɛgɛ ge, Kilɛ funŋɔ ya ta wɔ lee la yafiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuduro yaha shɛ Zhope ni, na Simɔ wu pa, pʼa wu pyi na Pyɛɛri ge. Wʼa tigi ná wa kaban, wee bɛ mɛgɛ ɲɛ na Simɔ, sɛɛyɛ wʼa gbuu. Wu kaban ki wa suumɔ lɔhɔ ki ɲɔ na.› ");
INSERT INTO myk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Taapile ni a nɛ tuduro tun jo pu ma yiri; ma pama ya ɲɔ. Ayiwa, wèe bɛɛri ya pinnɛ wee Kilɛ ɲaha tàan, Kafɔɔ ya kiimu bɛɛri shɛ ma na ge, wèe funŋɔ ɲɛ wu kee logo.» ");
INSERT INTO myk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Wee tuun wu ni, a Pyɛɛri di jomɔ pu lɔ na jo: «Can na, nɛ li cɛ nimɛ jo Kilɛ ya zhɔnrɔgɔ pyi wɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ga shi bɛɛri sipya wʼa ta wemu ya fyagi Kilɛ na ge, na tiimɛ koro ɲaari ge, weefɔɔ kaa lʼa dan Kilɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kilɛ ya wu jomɔ jo Izirayɛli sipyii mu na ɲaɲiŋɛ Jozaama pu jo pu mu Yesu Kirisa baraga ni. Wee ɲɛ sipyii bɛɛri Kafɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yesu keree ki bi doroo torogana lemu na, na co Galile fiige ki ni na pa nɔ Zhude fiige ki bɛɛri ni ge, yee wa kee fiin. Kee ya pye Yohana wo Kilɛ kafila yɛrɛ li kadugo na, batizeli wu keree na. ");
INSERT INTO myk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kilɛ ya Nazarɛti shɛɛn Yesu tìre, na wu ɲi Fɛfɛɛrɛ Munaa na, na sefɛɛrɛ kan wu mu kangana lemu na ge, yee wa lee fiin. Wʼa bi ɲaari na kasaaŋaa pyi sipyii na. Piimu bɛɛri pʼa bye Shitaanni wo ɲaa wu ni ge, wʼa bi pee bɛɛri cuuŋɔ, bani Kilɛ bi bye ni wu ni. ");
INSERT INTO myk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Yesu ya keree kiimu bɛɛri pye Yawutuu fiige ki ni, ni Zheruzalɛmu kulo liyɛ pyaa ni ge, wèe pu ɲɛ kee keree ki wo sɛɛrɛɛ. Pʼa wu co na wu kori tige na, na wu gbo. ");
INSERT INTO myk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ga caŋa taanri wogo ki na, a Kilɛ di wu ɲɛ na yeege xu ni, na wu yaha, kɔnhɔ sipyii di ba wu ɲaa. ");
INSERT INTO myk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ga sipyii bɛɛri ya ta wu ɲa wɛ, fo Kilɛ ya fɛnhɛ wèe piimu ɲaha bulo na pye wu sɛɛrɛɛ ge, wee pʼa wu ɲa. Wee piimu pʼa li, na gba ni wu ni, wu niɲɛŋɛ na na foro xu ni ge, wèe pʼa wu ɲa. ");
INSERT INTO myk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Lee wuu na wʼa tuduro kan wèe mu, na wèe pu Kilɛ jomɔ pu yɛrɛ pye sipyii pu bɛɛri mu. Na wù yi jo fiinŋɛ pu mu na Yesu Kilɛ ya teŋɛ na pye xuu ni wyii bɛɛri wo kiiri kɔnvɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kilɛ tudunmɔɔ pu bɛɛri ya jo na sipyaa sipya wʼa dà Yesu na ge, na weefɔɔ wo jurumu wu na yafa wu mu wu mɛgɛ ki gbɔɔrɔ ni.» ");
INSERT INTO myk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na Pyɛɛri yaha jomɔ pu na, a Fɛfɛɛrɛ Munaa di digi wu jomɔ pu logovɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yawutuu nʼa daa fɛɛ piimu pʼa Pyɛɛri torogo kari ge, a lʼi bye kakanhana pee mu, na Kilɛ ya Fɛfɛɛrɛ Munaa li loolo kan shi watii sipyii bɛ mu na ɲɛhɛ. ");
INSERT INTO myk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bani pʼa bi pee sipyii pu ɲaa pu na yu shi watii jomɔ ni Fɛfɛɛrɛ Munaa li gbɔɔrɔ ni, na Kilɛ mɛgɛ pɛlɛ. Wee tuun wu ni a Pyɛɛri di jo: ");
INSERT INTO myk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ta wèe na já pii sipyii pii ɲaha kɔn sanha na pu ganha bu batize lɔhɔ ni-i ya? Bani pu bɛ ya Fɛfɛɛrɛ Munaa li ta ba wèe ya li ta wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lee kadugo na a Pyɛɛri di jo ni sipyiire ti ni, na pu batize Yesu Kirisa mɛgɛ na. Ba pʼa batize xɔ wɛ, a pʼi Pyɛɛri ɲɛɛri na wu cabyaa pye ni pu ni. ");
INSERT INTO myk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tudunmɔɔ ni nʼa daa fɛɛ piimu bye Zhude ni ge, a pee di yi logo na shi watii sipyii bɛ ya sɔɔ Kilɛ jomɔ pu na. ");
INSERT INTO myk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lee wuu na tuun wemu ni Pyɛɛri ya kuri shɛ Zheruzalɛmu ni ge, a Yawutuu pʼi wu jaagi ");
INSERT INTO myk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","A pʼi jo na ɲaha wuu na wu dʼa shɛ binnɛ ni cekɔnbaalaa ni, fo na li ni pu ni wɛ? ");
INSERT INTO myk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pyegana lemu na lʼa pye ge, a Pyɛɛri di yee bɛɛri paari pu mu nigin nigin. ");
INSERT INTO myk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","A wu jo: «Tuun wemu ni nɛ bye Zhope kulo li ni ge, caŋa ka, na nɛ yaha Kilɛ-ɲɛrɛgɛ na, a Kilɛ di kashɛɛ la shɛ nɛ na. A nɛ yaaga ka ɲa kee bye ba fatɔgbɔhɔ ɲɛ wɛ. Ki geye shishɛɛrɛ wu bɛɛri dʼa pɔ, kʼi diri na yìri fugba we ni fo na pa nɔ nɛ tàan. ");
INSERT INTO myk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A nɛ ki funŋɔ yaŋmuyɔ yi wii xuuni: yapɔrɔyɔ, ni sige xaara, ni ɲiŋɛ yakokaara, ni shazhɛɛrɛ, yee bɛɛri yi bye fatɔgbɔhɔ ki funŋɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","A nɛ mujuu la logo, lee na nɛ pyi: ‹Pyɛɛri, yìri, mʼa ya gbo ma xa!› ");
INSERT INTO myk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","A nɛ jo: ‹Ahayi, Kafɔɔ! Bani Yawutuu ya yaaga kemu bɛɛri wii na ki ya yaa kʼa li-i ge, na yemu bɛɛri wii na yi ɲɛ fɛɛfɛɛ wɛ ge, nɛ sanha kee ka li ɲa wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ga, a mujuu lʼi nɔhɔ foro sanha fugba wu ni na: ‹Kilɛ ya yaaga kemu pye fɛɛfɛɛ ge, ma ganha ba kee wii sanha yaŋmunɔrɔgɔ wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A lʼi bye mu fo tɔɔɲii taanri. Lee kadugo na a kee fatɔgbɔhɔ ki ni ki funŋɔ yaŋmuyɔ yi bɛɛri di yìri kari fugba wu ni. ");
INSERT INTO myk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Wee tuun wu ninumɔ ni, nɛ bye puga kemu ni ge, a sipyii taanri di ba yere kee ni. Pu bi pu tun nɛ mu na yìri Sezare ni.» ");
INSERT INTO myk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A Fɛfɛɛrɛ Munaa di nɛ pye na nɛ wu pinnɛ ni pee sipyii pu ni, na nɛ ganha ba nayɛ kaala wɛ. Nɛ ni ceboronamaa gbaara we wʼa pinnɛ shɛ Sezare ni, na shɛ jé Kɔrinɛyi puga ki ni ge, pee pu wa piiri. ");
INSERT INTO myk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wʼa mɛlɛkɛ wu niyerege ɲa ɲagana lemu na ge, a wu yee paari wèe mu. Na mɛlɛkɛ wʼa bi wu pye wu tuduro tun Zhope ni, wu Simɔ yiri, Simɔ we pʼa byi sanha na Pyɛɛri ge. ");
INSERT INTO myk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Na wee ni wu kpɔɔn li sipyii na ba shɔ shɔgana lemu na ge, na nɛ wʼa da ba lee koo li shɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Ba nɛ jomɔ pu ɲɔ kɔn yɛ wɛ, a Fɛfɛɛrɛ Munaa di digi pu na, ba lʼa bi tigi wèe na tigigana lemu na taashiinɛ li ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wee tuun wu ni, Kafɔɔ ya jomɔ pemu jo ge, a nɛ funŋɔ di na to pee na na: ‹Yohana ya sipyii batize lɔhɔ ni, ga yee na ba batize Fɛfɛɛrɛ Munaa ni.› ");
INSERT INTO myk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wèe piimu pʼa dà Kafɔɔ Yesu na ge, Kilɛ ya ma taa lemu kan wèe mu ge, wu bu shɛ lee kan pii bɛtiilee mu, jɔgɔ nɛ di ɲɛ fo nɛ wʼa Kilɛ ɲidaan shege wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ba kalaapiire tisara ya Pyɛɛri jomɔ pu logo tuun wemu ni wɛ, a pee di pu logoo ɲiŋɛ. A pʼi Kilɛ sɔ na: «Can na Kilɛ ya sɔɔ shi wusama wu daburajɛ jo wu jurumu wu na, kɔnhɔ pʼi ɲìi sicuumɔ see wo ta.» ");
INSERT INTO myk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tuun wemu ni pʼa Ecɛni gbo ge, wee tuun wu ni pʼa ɲɔ kɔn na nʼa daa fɛɛ pu kana. A pʼi jaaga. A pii di gari Fenisi ni Sipɛrɛ fiiye yi ni, a pii di gori Ancɔsi kulo li ni. Ga Yawutuu puyɛ mu pee bi pu wo Kilɛ Kafila wu yu. ");
INSERT INTO myk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lee bɛ na Sipɛrɛ shɛɛn ni Sirinɛ shɛɛn pii bɛ bye pu ni. Pee bi yìri na pa Ancɔsi ni, shi wemu ɲɛ Yawutuu wɛ ge, a pʼi Kafɔɔ Yesu wo Jozaama pu jo pee mu. ");
INSERT INTO myk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A Kafɔɔ di pee nʼa daa fɛɛ pu tɛgɛ wee labye wu na, fo sipyiɲɛhɛmɛɛ ya dà Kafɔɔ na. ");
INSERT INTO myk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ba kee kapyegee kʼa nɔ Zheruzalɛmu nʼa daa fɛɛ pu na wɛ, a pʼi Barinabasi yaha kari Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ba wʼa nɔ wà wɛ, na Kilɛ wo labye wu pyegana ɲa nʼa daa fɛɛ pu niŋɛ ni wɛ; a lee di wu luu ɲiŋɛ. A wu pu yɛri na pu la le pʼi diin Kafɔɔ koo li ni ni loɲinɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinabasi bye sipyisaama. Wu bi fanha ta nʼa daa ni na nɔhɔ ɲi Fɛfɛɛrɛ Munaa bɛ na. Sipyiɲɛhɛmɛɛ bɛ bi sɔɔ Kafɔɔ na. ");
INSERT INTO myk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lee kadugo na a Barinabasi di doro kari Tarisi ni na shɛ Sɔli sha. ");
INSERT INTO myk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ba wʼa Sɔli ɲa wɛ, na gari ni wu ni Ancɔsi ni. A pʼi yee nigin maha wà ni nʼa daa fɛɛ pu ni shiizhan; na sipyiɲɛhɛmɛɛ kalaa Kafɔɔ wo koo li ni. Na nʼa daa fɛɛ yiri Kiricɛɛn, lee nizhiinɛ ya pye Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wee tuun wu ni a Kilɛ tudunmɔɔ pii di foro Zheruzalɛmu ni na kari Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pee Kilɛ tudunmɔɔ pu ni, wa mɛgɛ bye na Agabusi, a wee di yìri na jo Fɛfɛɛrɛ Munaa fanha ni na xuugbɔhɔ ki da ba bye koŋɔ ke bɛɛri na. A pee jomɔ pu ba bye can. Kee xuugbɔhɔ kʼa pye Oromɛ saannaa pu bɛɛri wo saan Kulodi caŋa ɲii ni. ");
INSERT INTO myk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ba lʼa pye mu wɛ, a Ancɔsi kalaapiire tʼi jo na pu keye wá yiyɛ na; lemu se ɲɛ wemu ni ge, a pu bɛɛri nigin nigin wu lee kan. A pʼi yee taga pu cebooloo nʼa daa fɛɛ pu tɛgɛ piimu pu ɲɛ Zhude fiige ki ni ge. ");
INSERT INTO myk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","A pʼi yee kan Barinabasi ni Sɔli mu, na pu shɛ yee kan Zhude nʼa daa fɛɛ pu nɔhɔlɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wee tuun wu ni a saannaa Hɛrɔdi di do Egilizi nʼa daa fɛɛ pu na na gana. ");
INSERT INTO myk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A wu Yohana ceborona Yakuba gbo ni ŋmɔpara ni. ");
INSERT INTO myk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ba wʼa lee ɲa lʼa taan Yawutuu pu ni wɛ, a wu Pyɛɛri bɛ co le kaso ni. Shizhɛnhɛrɛ Baa Buuri Kalenɛ li tuun wu bye wii. ");
INSERT INTO myk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wʼa Pyɛɛri co le kaso wu ni, na sɔrɔsii kuluŋɔɔ shishɛɛrɛ yaha kee na wu kasɛri sipyii shishɛɛrɛ shɛɛrɛ. Hɛrɔdi bi giin wu shɛ ni wu ni Shizhɛnhɛrɛ Baa Buuri wu Kalenɛ li nidorogo na, wu shɛ wu kiiri kɔn sipyii pu bɛɛri ɲii na. ");
INSERT INTO myk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na Pyɛɛri yaha kaso wu ni, a egilizi sipyii pʼi la le Kilɛ-ɲɛrɛgɛ ni wu mu. ");
INSERT INTO myk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɲiga na da mugi Hɛrɔdi di Pyɛɛri kiiri wu kɔn, ke nibiige ki ni, sɔrɔsii shuun tɛ ni Pyɛɛri bi bye na ŋmunɔɔ wu nibɔgɔ ni tɔɔrɔ shɔnhɔyɔ shuun ni, sɔrɔsii pii dʼa yere yere kuɲɔɔ li ɲɔ na na kasogbaha ki kasɛri. ");
INSERT INTO myk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wee tuun wuyɛ pyaa ni, a Kafɔɔ wo mɛlɛkɛ wa di jé kasogbaha ki ni. A kpɛɛngɛ di kasogbaha ki ɲi. A mɛlɛkɛ wu Pyɛɛri kpɔn kpɔn wu kabanugo na, na wu ɲɛ, na wu pye: «Yìri tɔvuyo na!» Taapile ni a shɔnhɔyɔ yʼi baha wolo Pyɛɛri keye yi na na to ɲiŋɛ ki na. A Pyɛɛri di yìri. ");
INSERT INTO myk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","A mɛlɛkɛ wu jo: «Yìri mʼa mayɛ pɔ, mʼa ma tanhaya yi le!» A Pyɛɛri di li pye mu. A mɛlɛkɛ wu wu pye sanha: «Ma fadegbɔhɔ ki le mʼa daha na fɛni!» ");
INSERT INTO myk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","A Pyɛɛri di yìri taha mɛlɛkɛ wu fɛni. Mɛlɛkɛ wʼa lemu pye ge, Pyɛɛri bi sanha dà lee na wɛ. Ga, a wu li ta ba ŋmunɔgɔ ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A pʼi shɛ nɔ kaso wu kasɛɛgɛ pyevɛɛ pu wo kuruŋɔ nizhiige ki na, na doro kee tàan. Na shɛ nɔ kuruŋɔ shuun wogo ki na, na doro kee bɛ tàan. Na shɛ nɔ kuɲɔgbɔhɔ ki na. Tɔɔrɔ gbura ki bye kee na na ɲaha tii kulo li funŋɔ ki na. Ba pʼa nɔ wà wɛ, a gbura kʼi mugi kiyɛ mu. A mɛlɛkɛ wu binnɛ foro ni Pyɛɛri ni na koo co. Na pu yaha pu na gaaŋi shiizhan, taapile ni a mɛlɛkɛ wu gari na Pyɛɛri yaha. ");
INSERT INTO myk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ba mɛlɛkɛ wʼa kari wɛ, a Pyɛɛri hakili di diin. A wu jo: «Nɛ li cɛ jo Kafɔɔ wʼa wu mɛlɛkɛ wa tun wʼa pa nɛ shɔ Hɛrɔdi wo fanha ki na, ni Yawutuu pu wo kanhama pe, pʼa bi puyɛ yaha pʼi ba pemu taha nɛ na ge. ");
INSERT INTO myk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ba Pyɛɛri ya wu funŋɔ sha wɛ, na gari Mariyama yíri. Yohana wemu pʼa bi Marika ge, wee wo nu wu ɲɛ wii. Nʼa daa fɛɛ niɲɛhɛmɛɛ pu bi pinnɛ wà na Kilɛ ɲɛɛri Pyɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ba Pyɛɛri ya nɔ kaaŋa ki ɲɔ na wɛ, na gbura ki kuu. Kapyebyezhɔ wa bye wà, wee mɛgɛ ki bye na Orode. A wee di ba kuɲɔɔ li wii. ");
INSERT INTO myk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ba wʼa pa Pyɛɛri mujuu li cɛ tuun wemu ni wɛ, wu ya já kuɲɔɔ li mugi nige fundanga keŋɛ ni wɛ. A wu baa kari na shɛ yi jo pusamaa mu, na Pyɛɛri niyerege ki wa kuɲɔɔ li ɲɔ na kpɛɛngɛ ki na. ");
INSERT INTO myk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A pʼi wu pye: «Mu ɲuŋmuu wa wɛ!» Ga, a Orode di yi jo waha pu mu na can wʼa wii. A pʼi jo: «Wu jaa wʼa wii.» ");
INSERT INTO myk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A Pyɛɛri di ganha na gbura ki kuuni. Ba pʼa pa gbura ki mugi, na wu ta Pyɛɛri yɛ pyaa wɛ, a lʼi pu fo fo xuuni. ");
INSERT INTO myk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A Pyɛɛri di wu keŋɛ yirige, na pu pye na pu co puyɛ na. Yeegegana lemu na Kafɔɔ ya wu yeege kaso wu ni ge, a wu yee ɲaha jo pu mu. Na pu pye pu yi ɲaha jo Yakuba ni wu ceboronamaa pusamaa bɛɛri mu. Lee kadugo na a wu yìri wà na kari xuu watii ni. ");
INSERT INTO myk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ba ɲiga kʼa pa mugi wɛ, a sɔrɔsii pu funbɛnwuu di ganha na puyɛ yegee na: «Dii Pyɛɛri dʼa pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Li ya ta mɔ wɛ, a Hɛrɔdi di wa yaha kari na pu Pyɛɛri yaha shɛ wee yíri. Pyɛɛri ya ta ɲa-ɛ ge, a wu sɔrɔsii pu yiri na pu yege, na jo na pu pu gbo. Lee kadugo na a Hɛrɔdi di foro Zhude fiige ki ni, na gari Sezare ni, na shɛ jɛri pye wà. ");
INSERT INTO myk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hɛrɔdi luu li bi yìri bɛ sanha Tiiri shɛɛn ni Sidɔn shɛɛn bɛ tàan xuuni. Ba pee ya lee cɛ wɛ, na puyɛ ɲa na pʼi shɛ Hɛrɔdi mu. A pʼi naɲɛɛgɛ leŋɛ ni saan wu tashɔngɔ ki ɲuŋɔfɔɔ wu ni. Wee mɛgɛ ɲɛ na Bilatusi. Lee kadugo na a pʼi shɛ Hɛrɔdi mu na wu susuro ta wu yogo ki yaha kʼi xhɔ. Bani wee wo fiige ki ni pee ɲɔlige ya fòro. ");
INSERT INTO myk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ba cadagaŋa kʼa pa nɔ wɛ, a Hɛrɔdi di wu saanra fadegbɔhɔ le, na diin wu saanra koro li ni, na ganha na kafilagbɔ yu pu mu. ");
INSERT INTO myk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A sipyii pu bɛɛri di ganha na xhuulo na: «Le ɲɛ sipya mujuu wɛ, kilɛ yɛ pyaa mujuu li ɲɛ le!» ");
INSERT INTO myk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ga taapile ni, a Kafɔɔ wo mɛlɛkɛ wa di yama wá Hɛrɔdi na, bani wu ya ta Kilɛ pɛlɛ wɛ. A fyɛɛnrɛ di jé wu ni; a wu xhu. ");
INSERT INTO myk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lee bɛ na, Kilɛ jomɔ pu bi se ɲaha na kabaya yi bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barinabasi ni Sɔli ya pa Zheruzalɛmu ni tuduro temu na ge, ba tee ya shɔɔnri wɛ, a pʼi guri kari Ancɔsi ni. A pu nigariwuu di gari ni Yohana ni, wee pʼa bi sanha na Marika. ");
INSERT INTO myk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kilɛ tudunmɔɔ ni karamɔgɔlɔɔ pii bye Ancɔsi egilizi wu ni. Pee mɛyɛ ye: Barinabasi, ni Simɔ wemu pʼa bi Niwɔ ge, ni Lusisi, wee bi yìri Sirinɛ kulo li ni, ni Manayɛni, ni Sɔli. Manayɛni ni saannaa Hɛrɔdi, punuŋɔ ni pee ya bii. ");
INSERT INTO myk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Caŋa ka nʼa daa fɛɛ pʼa suun le, na Kafɔɔ pɛlɛ. A Fɛfɛɛrɛ Munaa lʼi pu pye: «Nɛ Barinabasi ni Sɔli yiri labye wemu kaa na ge, yi pu yaha na yahama ni, kɔnhɔ pu da wee pyi.» ");
INSERT INTO myk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ba nʼa daa fɛɛ pʼa yee logo wɛ, a pʼi tuun wa lɔ sanha na suun le, na Kilɛ ɲɛɛri, na pu keye taha Barinabasi ni Sɔli na, na pu yaha kari Kilɛ wo labye wu na. ");
INSERT INTO myk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ba Fɛfɛɛrɛ Munaa lʼa Barinabasi ni Sɔli tun wɛ, a pʼi gari Silisi ni. A pʼi shɛ jé wà kɔɔgbɔhɔ ka ni na kari Sipɛrɛ fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A pʼi nɔ Salaminɛ ni, na Kilɛ Kafila jo Yawutuu pu mu Kilɛ-pɛɛŋɛ piyɛyɛ yi ni. Yohana wemu pʼa bi Marika ge, wee bi pu tɛgɛ labye wu na. ");
INSERT INTO myk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A pʼi Sipɛrɛ fiige ki kɔn ɲɛri na shɛ nɔ kulo la ni, lee mɛgɛ ɲɛ na Panfɔsi. Ba pʼa nɔ wà wɛ, na Yawutu ná wa ta wà, wee mɛgɛ ɲɛ Bariyesu. Wu bi siganma pyi, na kafinɛyɛ yu na Kilɛ tudunmɔ wee ɲɛ. ");
INSERT INTO myk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wee sigaanfɔɔ wʼa bye gbafɛnɛɛrɛɛ Sirigusi Polusi kaban. Wee gbafɛnɛɛri wu bye ná xakiligbɔ fɔɔ. A wu Barinabasi ni Sɔli yiri, bani pu bi giin pʼi Kilɛ Kafila logo. ");
INSERT INTO myk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ga sigaanfɔɔ wemu mɛgɛ ki ɲɛ Bariyesu, pʼi wu pyi Girɛkii jomɔ pu ni na Elimasi ge, a wee di Barinabasi ni Sɔli kaala. Wʼa bi li shaa wu gbafɛnɛɛri wu ɲaha kɔn, kɔnhɔ wu ganha bu dà Yesu na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Wee tuun wu ni Sɔli we pʼa bi na Pɔli ge, a wee di ɲi Fɛfɛɛrɛ Munaa na, a wu sigaanfɔɔ wu wii xuuni na jo: ");
INSERT INTO myk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Shitaanni sipya mu ɲɛ, mu ya ɲi shizhiinmɛ ni naŋmahara tuuyo bɛɛri na. Tiimɛ bɛɛri pɛn. Mu wa da Kafɔɔ wo kodiinɛ li ɲɛri wu ɲɔ yaha-i ya? ");
INSERT INTO myk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kafɔɔ ya wu keŋɛ taha mu na nimɛ. Ma na ba bye fyɛn. Ma na ba tuun wa pye, ma da yafiin bɛ ɲa wɛ.» Taapile ni a piige di jé Elimasi ɲaha ni; a wu ɲɛri fyɛn, na ganha na daala wu bu garaa sipya wa ta, wee di wu keŋɛ co, wu koo shɛ wu na. ");
INSERT INTO myk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ba gbafɛnɛɛri wʼa lee ɲa wɛ, na dà Yesu na. Kalaa we wʼa pye Kafɔɔ shizhaa na ge, a wee di bye wu mu kakanhana. ");
INSERT INTO myk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Lee kadugo na a Pɔli ni wu tahama-nɔhɔmɔɔ di jé kɔrɔgɔ ka ni Panfɔsi ni, na gari Pɛrizhe kulo li ni Panfili fiige ki ni. Yohana wemu mɛgɛ pʼa yiri na Marika ge, wee xuu wu ni wee ya kuri pu fɛni, na gari Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ga, a pusamaa di yìri Pɛrizhe ni, na gari kulo la ni lemu mɛgɛ ki ɲɛ Ancɔsi nibire ge, lee ɲɛ Pisidi wo fiige ki kabanugo. Ba Yawutuu wo cadɛɛngɛ kʼa nɔ wɛ, a pu bɛ di jé Kilɛ-pɛɛŋɛ puga ki ni na diin. ");
INSERT INTO myk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ba pʼa saliya we ni Kilɛ tudunmɔɔ pu wo Kitabuu pu kalaa xɔ wɛ, a Kilɛ-pɛɛŋɛ puga ki ɲuŋɔfɔɔ wu tuduro tun Pɔli ni Barinabasi mu na: «Na cebooloo, Kilɛ Kafila yɛrɛ la bye lʼi wa yi mu, yi na já li pye.» ");
INSERT INTO myk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A Pɔli di yìri, na wu keŋɛ yirige, na sipyii pu pye: «Izirayɛli shɛɛn, ni yee piimu pʼa fyagi Kilɛ na ge, yi niwegee shan! ");
INSERT INTO myk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izirayɛli shɛɛn wo Kilɛ wʼa wù sefɛlɛɛ pu ɲaha bulo. Tuun wemu ni pu bye nadadiinmɛɛ Misira ni ge, wʼa pu nagoo ɲɛhɛ. Lee kadugo na a wu wu wo sefɛɛrɛ ti taga pu yeege kee fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A wu pu keree xu, na pu ɲɔ sha fo na nɔ yee kɛlɛɛ shishɛɛrɛ na. ");
INSERT INTO myk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lee kadugo na wʼa shi tɛhɛɛ gbarashuun kyɛɛgi, na wee kɔri yeege Kana fiige ki ni, na fiige ki kan wù sefɛlɛɛ pu mu, ");
INSERT INTO myk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","fo na nɔ yee xhuu shishɛɛrɛ ni kɛlɛɛ kaguro na (450). Lee kadugo na, a wu kiirikɔɔn kan wù sefɛlɛɛ pu mu fo na shɛ nɔ Kilɛ tudunmɔɔ Samuwɛli wo caŋa ɲii li na. ");
INSERT INTO myk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Wee tuun wu ni a pʼi li sha Kilɛ mu na wu wa pye saan pu ɲuŋɔ ni. A Kilɛ di Kisi ja Sɔli kan pu mu wee wu pye pu saan. A wee di yee kɛlɛɛ shishɛɛrɛ (40) ta pu ɲuŋɔ ni. Wee bi foro Bɛnzhamɛ wo shi wu ni. ");
INSERT INTO myk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ba Kilɛ ya Sɔli laha saanra ti na wɛ, na Dawuda kan pu mu wʼa pye pu saan. A wee kaa di daan Kilɛ ni, a Kilɛ di jo: ‹Sipya wemu nɛ zhaa ge, wee wu ɲɛ we, Zhese ja Dawuda we. Wee na ba bye nɛ ɲidaan keree ki bɛɛri pyevɔɔ.› ");
INSERT INTO myk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","A Kilɛ di ba Shɔvɔɔ kan Izirayɛli mu, na foro Dawuda shi wu ni, ba wʼa bi yi jo jogana lemu na wɛ, wee ɲɛ Yesu. ");
INSERT INTO myk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na ta wee sanha ba wɛ, Yohana wʼa bi Kilɛ Kafila wu yɛrɛ pyi Izirayɛli sipyii pu bɛɛri mu, na pu daajeŋɛ jo pu jurumu wu na, pʼi batize. ");
INSERT INTO myk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ba Yohana wo labye wu taaxɔɔ ya tɛɛŋɛ wɛ, a wu ganha na yu na: ‹Yee ya giin na jɔgɔ nɛ wa wɛ? Shɔvɔɔ wemu ɲaha yee wa wii ge, nɛ wa were-e dɛ! Ga we wʼa ma nɛ kadugo ge, wee wu wa. Nɛ cɛ̀rɛ nɛ wu pye wu bulo, ali na wu tanhaya mɛɛrɛ bɛ sanha, nɛ yaa ni lee ni wɛ.›» ");
INSERT INTO myk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Lee kadugo na a Pɔli di jo: «Na cebooloo, yee piimu pu ɲɛ Ibirayima yaseye ge, ni yee pii pʼa fyagi Kilɛ na ge, pe ɲuwuuro jomɔ pe ya jo yi bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bani Yawutuu pii pʼa bye Zheruzalɛmu ni ge, pere ni ɲuŋɔfɛɛ pu bi ta li cɛ na Shɔvɔɔ wu ɲɛ Yesu wɛ. Kilɛ tudunmɔɔ pu jomɔ pemu bɛ pu bi galaa cadɛɛngɛ bɛɛri ge, pu ya pee bɛ cɛ wɛ; bani pʼa Yesu jaagi, na wu gbo. Ga lee funŋɔ ni a pʼi pee jomɔ pe ɲɔ fa puyɛ kategee. ");
INSERT INTO myk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ali na ta pu ya kaa la shishiin ta wu na le lʼa wu kagbuu xɔ wɛ. Lee bɛ na, a pʼi Pilate pye na wu sɔɔ pʼi wu gbo. ");
INSERT INTO myk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lee na keree kiimu kʼa ka Kilɛ tudunmɔɔ Kitabuu pu ni Yesu shizhaa na ge, pee jomɔ pu bɛɛri ya pye can. Lee kadugo na a pʼi wu tirige korikoritige ki na, na shɛ le faŋa ni. ");
INSERT INTO myk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ga, a Kilɛ di wu ɲɛ na yeege xu ni. ");
INSERT INTO myk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ba wʼa ɲɛ foro xu ni wɛ, pii pʼa wu torogo na yìri Galile ni na pa Zheruzalɛmu ni ge, a wu cabyaa niɲɛhɛŋɛɛ pye na wuyɛ shɛɛ pee na. Pee sipyii pu pʼa pye wu sɛɛrɛɛ, na wu jomɔ yu Izirayɛli sipyii pu mu. ");
INSERT INTO myk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kilɛ bi Jozaama pemu wo ɲɔmɛɛ lɔ wù sefɛlɛɛ pu mu ge, wèeyɛ pyaa ki bɛ wo kapana ɲuŋɔ ki ɲɛ, na pee ɲaha jo. ");
INSERT INTO myk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ɲɔmɛɛ le Kilɛ ya lɔ wèe sefɛlɛɛ pu mu ge, wʼa lee fa pu kadugo shɛɛn mu. Kilɛ ya Yesu ɲɛ na yeege xu ni. Lee lʼa ka Zaburuu Kitabu koogoo shuun wu ni Yesu shizhaa na na: ‹Mu ɲɛ nɛ Ja; niɲaa nʼa ma se.› ");
INSERT INTO myk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ba Kilɛ ya Yesu ɲɛ na yeege xu ni wɛ, na jo na wu da ga xhu nige bada wɛ. Lee Kilɛ Kafila wʼa shɛ na: ‹Fɛfɛɛrɛ ɲɔmɛɛ le nɛ lɔ Dawuda mu ge, nɛ na ba lee ɲɔ fa nakaara baa ni duba ni yi mu.› ");
INSERT INTO myk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lee wuu na Kilɛ Kafila wʼa li shɛ xuu wa bɛ ni sanha na: ‹Mu da ga sɔɔ ma Fɛfɛɛrɛ Sipya wu wu fɔnhɔ faŋa ni wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ga Dawuda we wʼa pe jomɔ pe jo ge, ba wee ya Kilɛ ɲidaan keree pye xɔ wu wo tuun wu ni wɛ na xhu. A pʼi wu le na fara wu sefɛlɛɛ pu nixhuyo na. A wu fɔnhɔ. ");
INSERT INTO myk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ga Kilɛ ya Yesu wemu ɲɛ na yeege xu ni ge, wee ya ta fɔnhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Lee na, na cebooloo, wèe ya yaa na li cɛ na Yesu gbɔɔrɔ ni wù jurumu wʼa da yafa wù mu. ");
INSERT INTO myk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kakuuŋɔɔ kiimu ki ɲɛ yee ya já shɔ ki na Kilɛ tudunmɔɔ Musa wo saliya wu nɔhɔ ni-i ge, wemu bu dà Yesu na, weefɔɔ na zhɔ kee kakuuŋɔɔ ki bɛ na, na kaɲii ta Kilɛ ɲaha tàan Yesu gbɔɔrɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lee wuu na yʼa yiyɛ kasɛri, kɔnhɔ Kilɛ tudunmɔɔ pʼa yemu jo ge, yee ganha da yi ta wɛ. Pʼa jo: ");
INSERT INTO myk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Kilɛ keree la wuuvɛɛ, yi wii, li na bye kakanhana yee mu, lee kadugo na yee na gyɛɛgi. Bani nʼa da ba kaa la pye yee wo tuun wu ni. Ali wa na ba li paari yee mu, yee da ga dà li na wɛ.›» ");
INSERT INTO myk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ba Pɔli ni Barinabasi ya pa foro Kilɛ-pɛɛŋɛ puga ki ni wɛ, a sipyiire tʼi pu pye na cadɛɛngɛ ki kʼa ma ge, na pu pa jo le kaa le ninunɔ na pee mu sanha. ");
INSERT INTO myk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ba sipyiire tʼa ɲɔ kɔn na jaaga wɛ, Yawutuu niɲɛhɛmɛɛ ni Kilɛ ɲìi fyaara sipyii piimu ya jé Yawutuu koo li ni ge, a pee di daha Pɔli ni Barinabasi fɛni. A pee di ganha na pu logoo wari na pu taha Kilɛ wo niimɛ wu fɛni ni ɲɔmɛɛ fɛɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ba cadɛɛngɛ kʼa pa nɔ wɛ, a kulo li sipyii pu bɛɛri di ba binnɛ pʼi Kafɔɔ jomɔ logo. ");
INSERT INTO myk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ba Yawutuu pʼa sipyiire ti ɲa tʼa pinnɛ wɛ, a lee wo ɲɛpɛɛn di jé pu ni. A pʼi ganha na Pɔli kafila wu kaala na wu shɛhɛlɛ. ");
INSERT INTO myk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A Pɔli ni Barinabasi di yi fiinŋɛ jo pu mu na: «Yee Yawutuu mu Kilɛ Kafila wu bi yaa na fɛnhɛ jo. Ga ma na jo yee ya she wu ni, na li yaha na yee ya yaa ni ɲìi sicuumɔ nixhɔbaama ni wɛ. Ayiwa nimɛ a wu gari shi watii yíri. ");
INSERT INTO myk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bani ye Kafɔɔ Kilɛ ya jo wu Kafila wu ni na: ‹Nɛ Kilɛ wʼa ma teŋɛ na pye kpɛɛngɛ shi wusama mu, kɔnhɔ mʼa ɲuwuuro ti jomɔ pu yaha pʼi nɔ koŋɔ ki kabaya shishɛɛrɛ wu bɛɛri na.›» ");
INSERT INTO myk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Shi wemu ɲɛ Yawutuu-i ge, ba pee ya pee jomɔ pu logo wɛ, a pu bɛɛri fundanga wuu di ganha na Kafɔɔ jomɔ pu sɔni. Piimu bɛɛri pu bi puyɛ gbegele pʼi sɔɔ ɲìi sicuumɔ nixhɔbaama pu na ge, a pee bɛɛri di dà Kafɔɔ Yesu na. ");
INSERT INTO myk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lee caagagana li na Kafɔɔ jomɔ pu bi jaaga wee xuu wu bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kulo li mɛgbɔhɔ cèe ni kulo li sipyigbɔɔ piimu pu bye Yawutuu koo li ni ge, a Yawutuu pʼi pee sɔn wá Pɔli ni Barinabasi na, a pʼi pu kanha, na pu kɔri na yeege pu wo fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ga, a Pɔli ni Barinabasi nivorowuu di pu tɔɔyɔ gbazhɛnhɛ ɲahara wo wà, na lee pye sɛɛri kaa pu fɛni. A pʼi gari Ikonɛ kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ga lee bɛ na, a pee nʼa daa fɛɛ nivomɔɔ pu kunni di ɲi fundanga ni Fɛfɛɛrɛ Munaa na Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ba Pɔli ni Barinabasi ya nɔ Ikonɛ ni wɛ, na jé wà bɛ Yawutuu Kilɛ-pɛɛŋɛ puga ki ni. A pʼi jomɔ jo fo Yawutuu niɲɛhɛmɛɛ ni Girɛkii niɲɛhɛmɛɛ ya pye Yesu nʼa daa fɛɛ. ");
INSERT INTO myk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ga, Yawutuu piimu pʼa she pu da dà Yesu na-ɛ ge, a pee di shɛ ganha na shi wusama sɔɔn na waa nʼa daa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ga lee bɛ na, a Pɔli ni Barinabasi di mɔ lee kulo li ni. Pʼa bi Kafɔɔ kaa yu, pu bi fyagi wa shishiin na wɛ. Kafɔɔ bi sefɛɛrɛ kaan pu mu pʼa kakanhaŋaa ni ɲaha shɛshɛɛrɛ pyi. Kee bi li shɛɛ na Kafɔɔ wo Fɛrɛmɛ jomɔ pu ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A kulo li shɛɛn pʼi daa taaya shuun. A taaga ka di bye ni Yawutuu pu ni, a ke kʼi bye ni tudunmɔɔ pu ni. ");
INSERT INTO myk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","A Yawutuu pee ni shi wusama ni pu ɲuŋɔfɛɛ di bɛ nigin na, na pʼi Pɔli ni Barinabasi kanha. Pu funŋɔ bye pʼi pu wá gbo ni kagereye ni. ");
INSERT INTO myk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ba Pɔli ni Barinabasi ya pa li cɛ na pu funŋɔ ki wa pʼi pee gbo wɛ, a pʼi baa kari Likawuni fiige ki ni. Kee fiige ki ni Lisitiri ni Dɛribɛ kulogoo kʼa bye. ");
INSERT INTO myk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","A pʼi Jozaama pu jo wee xuu wu bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ná wa bye Lisitiri ni wʼa bi faan fo wu taasii ni. Wu bi sanha ɲaari ɲa bada wɛ. ");
INSERT INTO myk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wee ná wu bi Pɔli jomɔ pu nuri. A Pɔli di wu ɲaha kɔ le wu ni na wii, na wu ta na nʼa daa wa wu zɔ wu ni, na wu cuuŋɔ. ");
INSERT INTO myk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","A Pɔli di jo ni fanha ni, na ná wu pye: «Yìri yere ma tɔɔyɔ yi na!» A na wu yìri, na yere wu tɔɔyɔ yi na, na ganha na ɲaari. ");
INSERT INTO myk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ba sipyiire tʼa lee ɲa wɛ, na jo Likawuni shɛɛn jomɔ pu ni na: «Kakanhana dɛ! Wù kilɛlɛɛ pʼa puyɛ ɲɛri sipyii, na digi na pa naha.» ");
INSERT INTO myk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Girɛkii kilɛ wemu mɛgɛ ki bye Zesi ge, a pʼi wee mɛgɛ le Barinabasi na. Shuun wo wu mɛgɛ ki bye Hɛrimɛsi ge, a pʼi wee mɛgɛ le Pɔli na. Bani Pɔli wʼa bye jomɔ pu jovɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zesi tapɛɛŋɛ puga ki bye kulo li tajege ki ni. A wu saraya ɲaha shɔɔnrivɔɔ wu shɛ wee xuu wu ni ni nupɛhɛɛ ni, na ki to ni tige fyɛɛnrɛ ni. Wu ni sipyiire ti bi giin pʼi saraga wolo Barinabasi ni Pɔli mu. ");
INSERT INTO myk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ga ba Pɔli ni Barinabasi ya lee ɲa wɛ, a pu loyire wuu di pu fadeye shɛɛngi, na baa kari sipyiire ti fɛni, na ganha na sɛlɛ na: ");
INSERT INTO myk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Wu naɲiinɛɛ ɲaha na yee di le pyi wɛ? Wèe bɛ pu ɲɛ sipyii ba yee wa wɛ. Wèe ya pa Kilɛ Jozaama jo yee mu, jo yi ke ɲuŋɔ baa pɛɛŋɛ ke ɲɔ yaha, yʼi dà Kilɛ ɲìi wo wu na. Yʼi da wu pɛlɛ, wee wemu wʼa fugba, ni ɲiŋɛ, ni suumɔ lɔhɔ, ni ki funŋɔ yaŋmuyɔ yi bɛɛri yàa ge. ");
INSERT INTO myk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Taashiinɛ li ni Kilɛ bi shi wu bɛɛri yaha wu na wuyɛ ɲidaan koro ɲaari, ");
INSERT INTO myk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ga lee bɛ na Kilɛ bi wuyɛ shɛɛ pu na ni kasaaŋaa niɲɛhɛŋɛɛ ni. Wʼa zanha shaan yee mu na yìri fugba we ni, na yee shinma ɲɔgi wu tuun ni, na ɲɔlige niɲɛhɛŋɛ kaan yee mu, na fundanga kaan yee mu.» ");
INSERT INTO myk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pɔli ya yee bɛɛri jo, ga jɛɛrɛ yɛ li bi fɔ pʼi sipyiire ti ɲaha kɔn kanha niiyɛ yi gbo wu na. ");
INSERT INTO myk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na pu yaha lee na, a Yawutuu pʼi di yìri Ancɔsi nibire ni Ikonɛ ni na pa. A pʼi sipyiire ti faanna fo pʼa kagereye taga Pɔli wá shan, na pʼi wu gbo. Lee kadugo na a pʼi wu fuulo na shɛ wá kulo li kadugo yíri, bani pu bi giin na wʼa xu xɔ. ");
INSERT INTO myk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ga ba nʼa daa fɛɛ pʼa shɛ wu kuuri wɛ, a wu yìri jé kanha ki ni. Kee caŋa ki ɲimuguro na a Pɔli ni Barinabasi di yìri wà na kari Dɛribɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔli ni Barinabasi ya Kilɛ Jozaama pu jo Dɛribɛ kulo li ni. A sipyiɲɛhɛmɛɛ di dà Yesu na. Lee kadugo na a pʼi guri kari Lisitiri ni, ni Ikonɛ, ni Ancɔsi nibire ni. ");
INSERT INTO myk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pʼa bi Yesu nʼa daa fɛɛ pu logoo wari, na pu yɛri na pu kori yaha nʼa daa wu ni pu da se ɲaha na. Bani pʼa bi pu pyi na: «Li waha lʼi waha, wèe na vɛnhɛ kanhama niɲɛhɛmɛ ɲa, yani wù pa jé Kilɛ wo saanra ti ni ge.» ");
INSERT INTO myk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔli ni Barinabasi ya pii ɲaha bulo na pye ɲahagbaa fɛɛ egilizii pu bɛɛri nigin nigin ni. Lee kadugo na a pʼi suun le, na Kilɛ ɲɛɛri pee sipyii pu mu. Kafɔɔ wemu na pʼa dà ge, a pʼi pu kaa le wee keŋɛ ni, kɔnhɔ wu bye pu tɛgɛvɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Lee kadugo na a Pɔli ni Barinabasi di Pisidi kɔn ɲɛri, na gari Panfili fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A pʼi Kilɛ Kafila jo Pɛrizhe kulo li ni na na kari kulo la ni lee mɛgɛ ɲɛ Atali. ");
INSERT INTO myk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A pʼi jé kɔɔgbɔhɔ ka ni na kari Ancɔsi nigbɔ wu ni Siiri fiige ki ni. Wee xuu wu ni nʼa daa fɛɛ pʼa bi pu kaa le Kilɛ keŋɛ ni. Labye wemu na pʼa xɔ mɛ ge, a pʼi na yìri wà lee kulo li ni na ma wee labye wu fɛni. ");
INSERT INTO myk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba pʼa nɔ Ancɔsi ni tuun wemu ni wɛ, keree kiimu bɛɛri pʼa pye Kilɛ baraga ni ge, a pʼi nʼa daa fɛɛ pu pinnɛ, na kee bɛɛri paari pu mu. Shi wemu ɲɛ Yawutuu wɛ, mugigana lemu na Kilɛ ya kuɲɔɔ mugi wee bɛ mu, kɔnhɔ pu bɛ di dà Yesu na ge, a pʼi yee bɛ paari. ");
INSERT INTO myk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A Pɔli ni Barinabasi di taatuunnɔ pye Ancɔsi nʼa daa fɛɛ pu yíri. ");
INSERT INTO myk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ayiwa, a namaa pii di ba yìri Zhude fiige ki ni na pa Ancɔsi ni. A pʼi ba ganha na kalaa watii kaan cebooloo nʼa daa fɛɛ pu mu na: «Na saha ni Kilɛ tudunmɔɔ Musa wo saliya wu ni, yee ya cekɔɔnrɔ pye wɛ, yee da zhɔ wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔli ni Barinabasi ya ta sɔɔ pee jomɔ pu na wɛ. A lʼi bye nakaagbɔɔrɔ pu tɛ ni, fo Ancɔsi nʼa daa fɛɛ pʼa nʼa daa fɛɛ pii fara Pɔli ni Barinabasi na, pʼi shɛ li tiinnɛ tiin Zheruzalɛmu ni, pu ni tudunmɔɔ pee ni nɔhɔlɛɛ pu ni. ");
INSERT INTO myk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A egilizi wu pu tun kari, a pu nigariwuu di doro Fenisi fiige ni Samari fiige ki ni. Shi wemu ɲɛ Yawutuu-i ge, wee ya sɔɔ Kilɛ jomɔ pu na sɔɔgana lemu na ge, a pʼi yee paari wee xuu wu nʼa daa fɛɛ pu mu. A pee jomɔ pʼi daan pu cebooloo pu ni xuuni. ");
INSERT INTO myk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba Pɔli ni Barinabasi ya nɔ Zheruzalɛmu ni wɛ, a nʼa daa fɛɛ pʼi pu ɲuŋɔ círi cirigazaana na. Tudunmɔɔ pee ni nɔhɔlɛɛ pu bɛɛri bi bye wà. Pʼa já keree kiimu bɛɛri pye Kilɛ baraga ni ge, a pʼi kee bɛɛri paari Zheruzalɛmu nʼa daa fɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Farizhɛɛn piimu pʼa dà Yesu na ge, a pii di yìri pu ni na jo: «Shi wemu ɲɛ Yawutuu wɛ, piimu pʼa dà Yesu na wee shi wu ni ge, pee wo cekɔɔnrɔ bye ɲɛ fanha. Na fara lee na, pʼa yaa na ɲaari na sahaŋi ni Musa wo saliya wu ni.» ");
INSERT INTO myk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lee wuu na, a tudunmɔɔ pee ni nɔhɔlɛɛ pʼi puyɛ ɲa na binnɛ tiin, kɔnhɔ pʼi yee suguri shiizhan. ");
INSERT INTO myk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba jomɔ pʼa pa ɲɛri nakaagbɔɔrɔ pu tɛ ni wɛ, a Pyɛɛri di ba yìri yere na jo: «Na cebooloo, yeeyɛ pyaa wa li fiin na Kilɛ ya nɛ ɲaha bulo fo taatuunnɔ ni, kɔnhɔ nɛ Kilɛ Jozaama pu jo shi wusama bɛ mu wemu ɲɛ Yawutuu wɛ, kɔnhɔ pʼi Kilɛ jomɔ logo pʼi dà Yesu na. ");
INSERT INTO myk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kilɛ wemu wʼa sipyii bɛɛri zɔlɔɔ cɛ ge, wèe ya li cɛ na wee ya sɔɔ pu na. Lee wuu na Fɛfɛɛrɛ Munaa lʼa tigi pu na ba lʼa tigi wèe na tigigana lemu na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Lee ya ta zhɔnrɔgɔ pye wɛ. Lʼa pu zɔlɔɔ fiinŋɛ, bani pʼa dà Yesu na. ");
INSERT INTO myk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ni li wa mu, ɲaha na yee di wa giin yʼi Kilɛ taanna di wii wɛ? Wèe sefɛlɛɛ ni wèeyɛ pyaa ya ta já tuguro temu na-ɛ ge, ɲaha na yʼi wa giin yʼi tee taha nʼa daa fɛɛ pu ɲuŋɔ ni wɛ? ");
INSERT INTO myk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dagana lemu na yee ya dà na yee ya shɔ Kafɔɔ Yesu wo niimɛ wu gbɔɔrɔ ni ge, mu li wa pii bɛ shizhaa na.» ");
INSERT INTO myk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A sipyii pu bɛɛri di cari cari puyɛ na, na Pɔli ni Barinabasi yɛ bɛ wo nijoyo logo. Kilɛ ya kakanhaŋaa ni ɲaha shɛshɛɛrɛ temu pye pu mu shi wu niŋɛ ni wemu ɲɛ Yawutuu wɛ ge, a pʼi yee bɛɛri paari sipyiire ti mu. ");
INSERT INTO myk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba Pɔli ni Barinabasi ya jo xɔ wɛ, a Yakuba di jomɔ pu lɔ na jo: «Na cebooloo, yi niwegee shan, yʼi na kafila wu logo! ");
INSERT INTO myk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shi wemu ɲɛ Yawutuu-i ge, yahagana lemu na Kilɛ ya wu kasɛɛgɛ yaha wee shi wu na fo taashiinɛ li ni ge, na pii ɲaha bulo pu ni na pye wuyɛ pyaa wuu ge, Simɔ ya yee bɛɛri paari na xɔ yee mu. ");
INSERT INTO myk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Simɔ wo jomɔ pe ni Kilɛ tudunmɔɔ pu wo pu bɛɛri ɲɛ ninumɔ, bani lʼa ka Kitabu wu ni na Kafɔɔ ya jo na: ");
INSERT INTO myk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Lee kadugo na, nʼa da ba guri ba. Dawuda puga ke kʼa to ge, nʼa da ba kee yereŋɛvonɔ yereŋɛ. Nʼa da ba ki kataha ki bɛɛri yirige, di ki tii. ");
INSERT INTO myk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kɔnhɔ sipyiire tisara bɛɛri di Kafɔɔ sha ni shi wu bɛɛri nʼa yiri na pye nayɛ wo ge. ");
INSERT INTO myk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yee Kafɔɔ ya jo. Wee wʼa kii keree kii shɛ fo taatuunnɔ ni.›» ");
INSERT INTO myk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Lee kadugo na a Yakuba di jo: «Lee wuu na, shi wemu ɲɛ Yawutuu wɛ, wu dʼa sɔɔ Kilɛ Kafila wu na ge, nɛ funŋɔ na, wèe ya yaa na waha watii taha wu na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ga yi yere wù sɛmɛ tun pu mu, na saraya yatɔɔyɔ yemu pʼa gbuu yapɛrɛɛ na ge, pu ganha ba yee xaara xaa wɛ. Na pu ganha ba dɔdɔɔrɔ pyi wɛ, na pu ganha ba yaxuyo, kelee shishan xaa wɛ. ");
INSERT INTO myk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bani na lɔ fo taatuunnɔ li ni, kulogoo ki bɛɛri ni, Kilɛ-pɛɛŋɛ piyɛyɛ yi ni, lee yɛrɛ li lʼa gaan na saha ni Musa wo saliya wu ni cadɛɛngɛ bɛɛri na.» ");
INSERT INTO myk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yakuba jomɔ pʼa bi bɛ tudunmɔɔ ni nɔhɔlɛɛ, ni nʼa daa fɛɛ pu mu. A pu pii pinnɛ ni Pɔli ni Barinabasi ni, na pee tun kari Ancɔsi ni. A pʼi ɲahagbaa fɛɛ shuun wa ɲaha bulo nʼa daa fɛɛ pu ni. Wa mɛgɛ ɲɛ na Zhude, pʼi wu pyi na Barisabasi, shuun wo wu mɛgɛ ɲɛ na Silasi. ");
INSERT INTO myk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","A pʼi sɛmɛ wu le pu keŋɛ ni. Lʼa bi ka wee sɛmɛ wu ni na: «Wèe piimu pu ɲɛ tudunmɔɔ pu ge, wèe ni egilizi nɔhɔlɛɛ ni nʼa daa fɛɛ pu pʼa we sɛmɛ we tun wù cebooloo nʼa daa fɛɛ pu mu piimu ɲɛ Yawutuu wɛ, na ɲɛ Ancɔsi kulo le, ni Siiri fiige ke, ni Silisi fiige ki ni ge: Wèe ya yi shaari. ");
INSERT INTO myk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wèe ya logo na sipyii pii ya yìri wèe yíri naha, na shɛ kafila wa taga yee hakilee pu wuregi, fo lʼa pye yee mu funzhaga; na ta wèe di ya pu tun wɛ. ");
INSERT INTO myk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lee wuu na wèe ya wùyɛ ɲa, na bɛ nigin na, na li ta lʼa pɔrɔ na sipyii pii fara wù taanɲiinɛɛ Pɔli ni Barinabasi na, wù pee tun yi mu. ");
INSERT INTO myk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pii namaa shuun we ya puyɛ kan Kafɔɔ Yesu wo labye wu mu, fo na li pye jɛɛrɛ yɛ lʼa fɔ pʼi xhu kanhama keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Lee wuu na wèe ya Zhude ni Silasi pinnɛ ni pu ni, kɔnhɔ jomɔ pemu wèe ya ka sɛmɛ wu ni ge, pʼi pee jo yi mu ɲɔ ni ɲɔ. ");
INSERT INTO myk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Lʼa taan Fɛfɛɛrɛ Munaa ni wèe bɛ ni, nago wù ganha da tuguro tatii taha yi na, kii keree kii kadugo na wɛ. Kee keree ki kaa wèe ya jo waha mɛ yi mu. ");
INSERT INTO myk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yi ganha ba yapɛrɛɛ xaara, kelee shishan, kelee yaxuyo xaa wɛ; yʼi dɔdɔɔrɔ yaha. Yi bu já yiyɛ tanha kii keree kii na, lee ya ɲɔ. Kilɛ wu tuun wa shɛ wu na.» ");
INSERT INTO myk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","A pʼi Pɔli, Barinabasi, Zhude ni Silasi yɛ yaha kari Ancɔsi ni. Ba pee ya nɔ wà wɛ, na nʼa daa fɛɛ pu bɛɛri yiri pinnɛ, na sɛmɛ wu kan pu mu. ");
INSERT INTO myk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba pʼa wee sɛmɛ wu kalaa wɛ, a lee yɛrɛ lʼi pu funŋɔ taan xuuni. ");
INSERT INTO myk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zhude ni Silasi yɛ bɛ di bye Kilɛ tudunmɔɔ, a pʼi yɛrɛ kan nʼa daa fɛɛ pu mu, na pu logoo waha, na samɔhɔrɔ le pu ni. ");
INSERT INTO myk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A pʼi cabyaa kii pye ni pu ni Ancɔsi ni. Lee kadugo na a pʼi koo sha. A pʼi li kan pu mu, na pu pye na Kilɛ wu pu naha shɛ pu tunvɛɛ pu yíri, na pu shɛ kanha ta ɲaɲiŋɛ na. ");
INSERT INTO myk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ga lee bɛ na, a lʼi daan Silasi ni wee wu kori Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A Pɔli ni Barinabasi di gori Ancɔsi ni. Pee ni sipyii piitiilee bi nʼa daa fɛɛ pu kalaa, na Kafɔɔ wo Jozaama pu bɛ yɛrɛ pyi. ");
INSERT INTO myk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Caŋa ka Pɔli ya pa Barinabasi pye: «Barinabasi, kulogoo kiimu ni wèe ya toro, na Kilɛ Kafila jo wà ge, wù kuri wù doro kee ni, wù ki nʼa daa fɛɛ pu pɛrɛgi pu bi se ɲaha na nʼa daa wu ni.» ");
INSERT INTO myk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pu nigariwuu, Barinabasi funŋɔ bye, Yohana wemu pʼa bi Marika ge, wee bɛ wu pinnɛ ni pu ni. ");
INSERT INTO myk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ga Pɔli ya ta sɔɔ Yohana wu pinnɛ ni pu ni wɛ. Bani na pu yaha Panfili fiige ki ni wʼa pa guri pu fɛni na labye wu ta wu sanha xhɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A lʼi bye gilege Pɔli ni Barinabasi tɛ ni, fo na pu pye pʼa waagi. A Barinabasi di gari ni Marika ni. A pu shuun wu jé kɔrɔgɔ ka ni na kari Sipɛrɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A Pɔli di Silasi ɲaha bulo. A nʼa daa fɛɛ pʼi pu kaa le Kafɔɔ keŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","A pʼi Siiri ni Silisi fiiye yi bɛɛri ɲaari, na samɔhɔrɔ le nʼa daa fɛɛ pu ni. ");
INSERT INTO myk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A Pɔli ni Silasi di gari Dɛribɛ ni, a pʼi foro wà, na gari Lisitiri kulo li ni. Na shɛ nʼa daa fɔɔ lɛvɔɔ wa ta wà, wee mɛgɛ ɲɛ na Timote. Wu nu bye Yawutuu nʼa daa fɔɔ wa, ga wu to wʼi ɲɛ Girɛki. ");
INSERT INTO myk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nʼa daa fɛɛ piimu pu bye Lisitiri ni Ikonɛ ni ge, pee bɛɛri bi Timote mɛsaaŋa yu. ");
INSERT INTO myk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Lee wuu na Pɔli ya li sha na Timote wu pye wu kapyebyeɲii. Yawutuu pu wuu na wʼa Timote kɔn, bani pu bɛɛri bi li cɛ na Girɛki wu ɲɛ wu to we. ");
INSERT INTO myk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pu nigariwuu ya toro kulogoo kiimu bɛɛri ni ge, tudunmɔɔ pee ni Zheruzalɛmu nɔhɔlɛɛ pʼa keree kiimu teŋɛ ge, a Pɔli di kee bɛɛri paari pu mu, na pʼa kee pyi. ");
INSERT INTO myk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Lee lʼa bi nʼa daa fɛɛ pu pye pu na se ɲaha na nʼa daa wu ni, egilizii pu ni. A la di ganha na faraa pu na caŋa bɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A Kilɛ Munaa lʼi pu ɲaha kɔn Kilɛ Kafila wu jo na Azi fiige ki ni. A pʼi Firizi ni Galasi fiiye yi ja toro. ");
INSERT INTO myk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ba pʼa tɛɛŋɛ Misi fiige ki na wɛ, a pʼi ganha na giin pʼi jé Bitini ni, ga Yesu Munaa li ya ta sɔɔ pu jé wà wɛ. ");
INSERT INTO myk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","A pʼi doro Misi kabanugo na kari Torowasi ni. ");
INSERT INTO myk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kee caŋa ki piige Pɔli ya kashɛɛ la ɲa. A wu Masedɔni shɛn ná wa niyerege ɲa wu na wu ɲɛɛri na yu: «Pɔli, ɲɔ mayɛ na, mʼa ba Masedɔni ni, mʼa ba wù tɛgɛ.» ");
INSERT INTO myk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ba Pɔli ya lee ɲa wɛ, taapile ni a wu gbegele, na shɛ Masedɔni fiige ki ni. A wèe di li cɛ nakaara baa jo Kilɛ yɛ pyaa kʼa jo na wèe pu shɛ Kilɛ Jozaama pu jo pii sipyii pii mu. ");
INSERT INTO myk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","A wèe di jé kɔrɔgɔ ka ni Torowasi ni, na nɔ Samoturasi ni. Tee ɲimuguro ti na wèe ya nɔ Nerapolisi kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","A wèe di foro wà, na gari Filipi ni. Lee ɲɛ Masedɔni fiige ki kugbɔɔ le, na ɲɛ Oromɛ fanha ki tatɛɛngɛ ka. A wèe di cabyaa pye lee kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ba cadɛɛngɛ kʼa pa nɔ wɛ, a wèe di shɛ kanha ki kadugo. Bani wèe bi giin na xuu wa wa wà pu mu dugo ki ɲɔ na, wee ɲɛ pu Kilɛ-ɲɛrɛgɛ tapyege. Ba wèe ya nɔ wà wɛ, na cèe pii ta pʼa puyɛ pinnɛ wà, a wèe di Kilɛ Kafila jo pee mu. ");
INSERT INTO myk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Cee nigin wa bye pee ni, wee bi jé Yawutuu pu wo Kilɛ koro li ni, wee mɛgɛ ɲɛ Lidi. Wu kulo mɛgɛ di ɲɛ Tiyatiiri. Faɲɛɛyɛ wu bi bɛrɛɛ, yemu pɛrɛmɛ ya waha ge. Wu bi Kilɛ pɛlɛ A wu ganha na we kafila we nuri, a Kafɔɔ di fungɔngɔ fɛɛrɛ kan wu mu wʼa Pɔli kafila wu ɲaha cɛ. ");
INSERT INTO myk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A wu ni wu puga shɛɛn pu bɛɛri di batize. A wu Pɔli ni wu kaafɛɛ pu ɲɛɛri na: «Yee bi dà li na na nɛ dà see na Kafɔɔ na, yi pa digi na puga.» A wu wèe karamu fo wèe ya sɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Caŋa ka wèe ya kari Kilɛ taɲɛrɛgɛ ni, a bulozhɔ wa di wèe ɲuŋɔ círi. Jina wa wu bye wee ni, wee baraga ni wu bi celɔrɔ pyi. Tee celɔrɔ ti ni wʼa bi wari niɲɛhɛmɛ taa na gaan wu Kafɔɔ mu. ");
INSERT INTO myk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A wee cee jinaa wo wu daha yaha wèe fɛni, na sɛlɛ, na yu: «Kilɛ-gbɔtabaaga wo kapyebyii pu ɲɛ pii namaa piiri. Ɲuwuuro ya daa koo lemu ni ge, lee kaa pʼa yu yee mu.» ");
INSERT INTO myk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wee cee wu bi taha yaha Pɔli yɛ fɛni caŋa bɛɛri na yee yu. Caŋa ka, a Pɔli di ba ganha na ŋmahana ɲɛri, na jina wu pye: «Yesu Kirisa mɛgɛ na, jina, foro cee wu ni!» Taapile ni a jina wu foro cee wu ni. ");
INSERT INTO myk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ba wee bulozhɔ wu kafɛɛ ya pu wari ta koro li ɲa lʼa tɔ wɛ, a pʼi Pɔli ni Silasi co kari kiiri kɔɔn kuruŋɔ ki mu. ");
INSERT INTO myk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba pʼa nɔ wà wɛ, na Oromɛ fanhafɛɛ pu pye: «Pii namaa pii ya wèe kulo li wuregi, Yawutuu pu ɲɛ pii. ");
INSERT INTO myk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pʼa sipyii pu kalaa keree kii ni na ta wèe Oromɛ shɛɛn wo saliya wu ya gbara kee na wɛ, wèe di ya yaa wʼa kee keree ki pyi bɛ wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ba sipyiire tʼa pee jomɔ pu logo wɛ, a pʼi yìri Pɔli ni Silasi fɛni. A fanhafɛɛ pʼi jo na pu pu fadeye wolo pu na, pʼi pu kpɔn ni susɔlɔɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba pʼa pu deele kpɔn wɛ, na pu le kaso ni. A fanhafɛɛ pʼi yi jo kaso gbaha ki kasɛɛgɛ pyevɔɔ wu mu na pʼa pu kasɛri xuuni. ");
INSERT INTO myk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ba kaso gbaha ki kasɛɛgɛ pyevɔɔ wʼa yee logo wɛ, a wu shɛ Pɔli ni Silasi yaha kaso gbaha ki funŋɔ pura la ni, na pu tɔɔyɔ le tige ka ni na pɔ. ");
INSERT INTO myk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ba ɲiŋɛ kʼa pa ɲi wɛ, a Pɔli ni Silasi di ganha na Kilɛ ɲɛɛri, na Kilɛ masɔŋɔ yoyo cee. Kasolemɛɛ pusamaa bɛɛri bi yee nuri. ");
INSERT INTO myk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Na pu yaha lee na, a ɲiŋɛ kʼi wakaraa cɛlɛ xuuni, na kaso gbaha ki ɲahara fo na ki gburaya yi bɛɛri pye yʼa mugi yiyɛ ni. A kasolemɛɛ pu bɛɛri wo tɔɔrɔ shɔnhɔyɔ yʼi bahala wolo. ");
INSERT INTO myk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ba kaso gbaha ki kasɛɛgɛ pyevɔɔ wʼa ɲɛ, na gburaya yi bɛɛri ta yʼa mugi wɛ, a wu wu ŋmɔpara kɔɔngi li kɔrɔgɔ ni di daga wuyɛ gbo, bani wu bi giin na kasolemɛɛ pu bɛɛri ya paa. ");
INSERT INTO myk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","A Pɔli di mujuugbɔɔ wá na: «Ma ganha da kakuunɔ pye mayɛ na wɛ, wèe bɛɛri wa naha.» ");
INSERT INTO myk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A kaso gbaha ki kasɛɛgɛ pyevɔɔ wu jo na pu sokinna le pa. A wu gburogi jé kaso gbapire li ni. Wʼa bi fya fo na fuguri, a lee di wu pye wʼa shɛ do Pɔli ni Silasi tɔɔyɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Lee kadugo na a wu Pɔli ni Silasi yeege kpɛɛngɛ ki na, na pu pye: «Na ɲahafɛɛ, lekɛ nɛ dʼa yaa na pye, kɔnhɔ di ɲuwuuro ta wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","A pʼi wu ɲɔ shɔ na: «Dà Kafɔɔ Yesu na, ma na zhɔ ma ni ma puga shɛɛn pu bɛɛri.» ");
INSERT INTO myk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lee kadugo na a Pɔli ni Silasi di Kafɔɔ jomɔ pu jo wu ni wu puga shɛɛn pu bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kee ɲiɲiŋɛ kiyɛ pyaa na, a kasogbaha ki kasɛɛgɛ pyevɔɔ wu Pɔli ni Silasi yɛ nɔɔyɔ yi wɛrɛ pye. A wu ni wu puga shɛɛn pu bɛɛri di batize. ");
INSERT INTO myk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Lee bɛɛri kadugo na a wu gari ni pu ni wu kaban, na shɛ yalige kan pu mu. A we na we ni wu puga shɛɛn bɛɛri di fundanga pye xuuni, bani pʼa dà Kilɛ na. ");
INSERT INTO myk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ba ɲiga kʼa mugi wɛ, a Oromɛ fanha ki ɲuŋɔfɛɛ pʼi fanhafɛɛ pii tun kasogbaha ki kasɛɛgɛ pyevɔɔ wu mu na wu Pɔli ni Silasi yaha. ");
INSERT INTO myk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A kasogbaha ki kasɛɛgɛ pyevɔɔ wu pee jomɔ pu jo Pɔli ni Silasi mu na: «Oromɛ fanha ki ɲuŋɔfɛɛ pʼa tuduro yaha pa, na pu yi yaha. Yi foro, yi da gaaŋi ɲaɲiŋɛ na.» ");
INSERT INTO myk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A Pɔli di pee fanhafɛɛ pu pye: «Pʼa wèe kpɔn sipyii pu bɛɛri ɲii na kiiri kɔnbaa wèe na, na ta wèe bɛ di ɲɛ Oromɛ kulo li sipyii. Lee kadugo na na ba wèe le kaso ni. Pʼi giin pʼi wèe peele yeege nimɛ kaso wu ni gɛ? Tapyege wa lee na bada wɛ; na puyɛ pyaa ki pa wù yeege kaso wu ni naha!» ");
INSERT INTO myk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A pee di guri na shɛ pee jomɔ pu jo Oromɛ fanha ki ɲuŋɔfɛɛ pu mu. Ba pʼa logo na Pɔli ni Silasi bɛ ɲɛ Oromɛ shɛɛn wɛ, a pʼi fya. ");
INSERT INTO myk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Lee na a pʼi ba kafari sha Pɔli ni Silasi mu. A pʼi pu yaha na pu ɲɛɛri na pu ɲɔ puyɛ na pʼi foro kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ba Pɔli ni Silasi ya foro kasogbaha ki ni wɛ, a pʼi gari Lidi kaban, na shɛ cebooloo pii ta wà. A pʼi pee yɛri na samɔhɔrɔ le pu ni, na na kari. ");
INSERT INTO myk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔli ni Silasi ya foro Anfipolisi kulo li ni, na shɛ doro Apoloni kulo li bɛ ni. A pʼi shɛ nɔ kulo la ni lee mɛgɛ ɲɛ na Tesaloniki. Yawutuu Kilɛ-pɛɛŋɛ puga ka bye wà. ");
INSERT INTO myk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A Pɔli di jé kee Kilɛ-pɛɛŋɛ puga ki ni ba wʼa tee na li pyi wɛ. A wu cadɛɛnyɛ taanri pye na taha yiyɛ na na se na Yawutuu pu ɲuŋɔ cirini, na Kilɛ Kafila wu ɲaha yu pu mu. ");
INSERT INTO myk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pɔli bi Kilɛ Kafila wu ɲaha shɛɛ pu na na fiinŋɛ, na yi yu pu mu na saha ni wee Kafila wu ni na Kilɛ ya wemu ɲaha bulo na pye Shɔvɔɔ ge, na wee na vɛnhɛ ganha na na xu. Lee bɛɛri kadugo na, wu na ba ɲɛ na foro xu ni. A wu pu pye: «Yesu wemu kaa wèe ya yu yee mu ge, wee Kilɛ ya pye Shɔvɔɔ we. ");
INSERT INTO myk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","A Yawutuu pii di wee kafila wu ta can, a pee di ba dà Yesu na, na fara Pɔli ni Silasi na. A Girɛkii Kilɛ ɲìi fyaara sipyii niɲɛhɛmɛɛ pii bɛ di dà Yesu na ni mɛgbɔhɔ cèe niɲɛhɛmɛɛ pii bɛ. ");
INSERT INTO myk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ga, a lee di ɲiizhaga yirige Yawutuu pusamaa mu. A pee di lapyebaalaa sipyiŋmuyɔ ya faanna pinnɛ, na pee sɔn wá Pɔli ni Silasi na. A pee di tunmɔ taga kulo li bɛɛri wuregi. A pʼi puyɛ faari kari Pɔli ni Silasi tacoŋɔ ni ná wa puga, wee mɛgɛ ɲɛ Zhasɔn. ");
INSERT INTO myk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba pʼa shɛ fɔ Pɔli ni Silasi ni wɛ, a pʼi Zhasɔn ni nʼa daa fɛɛ pii bɛ co, na pee fuulo kari fanhafɛɛ pu yíri. A pʼi ganha na sɛlɛ na: «Yi li wii, sipyii pii pʼa fiige ki bɛɛri wuregi ge, pee pʼa nɔ wèe bɛ mu naha, ");
INSERT INTO myk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a Zhasɔn di pu tirige wu puga. Keree kii pʼa byi ge, kee ya bɛ ni Oromɛ saannaa pu bɛɛri ɲuŋɔfɔɔ Sezari wo saliya wu ni wɛ, bani pʼa yu na saan wa bɛtii wu ɲɛ, wee mɛgɛ ɲɛ Yesu.» ");
INSERT INTO myk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ba kulo li sipyii ni fanhafɛɛ pʼa pee jomɔ pu logo wɛ, a pee jomɔ pʼi pu fungɔnyɔ wuregi. ");
INSERT INTO myk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mʼa Zhasɔn ni nʼa daa fɛɛ pu ɲa pʼa yaha ge, ɲɔmɛɛ pʼa kan fanhafɛɛ pu mu. ");
INSERT INTO myk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ba fanhafɛɛ pʼa nʼa daa fɛɛ pu yaha wɛ, kee caŋa ki piige kiyɛ pyaa ni pʼa Pɔli ni Silasi yaha kari Bere ni. Ba pʼa nɔ wà wɛ, na shɛ jé Yawutuu Kilɛ-pɛɛŋɛ puga ki ni, na Kilɛ Kafila jo sipyii pu mu. ");
INSERT INTO myk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pee bi pɔrɔ Tesaloniki shɛɛn na, a pʼi sɔɔ Kilɛ Kafila wu na ni fundanga ni, na Kitabu wu suguri caŋa bɛɛri kee keree ki bi ɲɛ can. ");
INSERT INTO myk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A Yawutuu niɲɛhɛmɛɛ di dà Yesu na. A mɛgbɔhɔ cèe niɲɛhɛmɛɛ di dà Yesu na Girɛkii pu bɛ ni, na fara namaa niɲɛhɛmɛɛ pii bɛ na. ");
INSERT INTO myk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ga ba Tesaloniki kulo li Yawutuu pʼa pa yi logo na Pɔli ya Kilɛ Kafila wu yu Bere bɛ ni wɛ, a pʼi yìri, na shɛ Bere shɛɛn pu sɔn wá pu na. ");
INSERT INTO myk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ba lee ya pye wɛ, taapile ni a nʼa daa fɛɛ pʼi gari ni Pɔli ni suumɔ lɔhɔ ki ɲɔ na, na wu le kɔrɔgɔ ka ni. ");
INSERT INTO myk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A pii di binnɛ ni wu ni fo na shɛ nɔ Atɛni kulo li ni. A Silasi ni Timote di gori Bere kulo li ni. Ba Pɔli torogovɛɛ pu kuriduun ya nɔ wɛ, a wu pu tun na pu pa Timote ni Silasi pye, na pʼa se tɔvuyo na wee fɛni Atɛni ni. ");
INSERT INTO myk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na Pɔli yaha Atɛni ni wu na Timote ni Silasi yɛ sigee, a wu ba li sɛɛri na li ta Atɛni kulo lʼa ɲi yapɛrɛɛ na. A lee di bye wu mu funzhaga. ");
INSERT INTO myk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lee wuu na wu bi se Kilɛ-pɛɛŋɛ puga ki ni na yu ni Yawutuu pu ni, ni Girɛkii piimu bi fyagi Kilɛ na ge. Wʼa bi se pinnɛrɛ kpɛɛnyɛ na caŋa bɛɛri, wu bu wemu ta wà, wʼa ganha na yu ni weefɔɔ ni. ");
INSERT INTO myk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Fungɔngɔ fɛɛ kuruyo yemu pʼa bi byi na Epikurɛ ni Sitoyiki ge, a yee wo sipyii pii di ba ganha na yu ni Pɔli ni. A pii di jo pu ni na: «Kaɲuŋɔ baa jomɔ pekɛ we di wa yu wɛ?» A pii bɛ di jo: «Li ɲɛ ma na giin kilɛlɛɛ piitiilee kaa wʼa yu wèe ya piimu cɛ wɛ.» Pʼa yee jo bani Pɔli bi Yesu wo Jozaama pu yɛrɛ pyi, na xuɲɛnɛ li bɛ kaa yu. ");
INSERT INTO myk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","A pʼi gari ni Pɔli ni kulo li pinnɛrɛ kpɛɛngɛ ka na, kee mɛgɛ ɲɛ na Ayeropazi. Ba pʼa nɔ wà wɛ, na Pɔli yege na: «Kalaafomɔ wemu ni mʼa pa ge, ta wèe na já wu logo? ");
INSERT INTO myk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yemu bɛɛri wèe ya nuri mu ɲɔ na ge, yee bɛɛri ɲɛ wèe mu nivoyo. Lee wuu na wèe ya giin mʼa yee ɲaha jo wù mu.»  ");
INSERT INTO myk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛni shɛɛn ni pu nadadiinmɛɛ bi ma pu tuun bɛɛri torogo kafilafomɔ jo ni wu logo na. ");
INSERT INTO myk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","A Pɔli di yìri yere kee kpɛɛngɛ ki na na jo: «Atɛni shɛɛn, nɛ yee kasɛri na yee ta yee na ɲɛ Kilɛ shavɛɛ see wuu. ");
INSERT INTO myk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na nɛ yaha nɛ na ɲaari yee kulo li ni, nɛ yee Kilɛ tashaya saraya yi tawoloyo niɲɛhɛyɛ ɲa. Nɛ nigin ɲa yee pɛɛŋɛ yaŋmuyɔ yi ni lʼa ka kee na na: ‹Yaaga kemu kʼa bɛlɛ ki tuugo di ya cɛ-ɛ ge, kee saraya yi tawologo.› Lee na yaaga kemu yee ya bɛlɛ, yee di ya ki cɛ-ɛ ge, kee kaa nɛ yu yee mu. ");
INSERT INTO myk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Wee ɲɛ Kilɛ, wemu wʼa koŋɔ ni ki funŋɔ yaŋmuyɔ bɛɛri yàa ge. Wee wu ɲɛ fugba ni ɲiŋɛ yaavɔɔ wu bɛ. Wee ya dɛn sipya keŋɛ puyaaga funŋɔ ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wee Kilɛ wu mago ɲɛ sipya keŋɛ labye na na wee Kilɛ wʼa dɛri wɛ. Bani wee wʼa ɲiifɛɛrɛ ti kaan sipyii mu; kafɛɛgɛ kemu sipyii ya ŋmɔni ge, na kee bɛ kaan, ni yaŋmuyɔ yi saya bɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sipya nigin ni wʼa shi wu bɛɛri yeege, na wee yaha ɲiŋɛ ki kabaya yi bɛɛri na. Na tɛhɛnɛ yaha pu tɛɛgɛɛ ni pu tatiinyɛ na. ");
INSERT INTO myk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wʼa kii keree kii bɛɛri pye, kɔnhɔ sipyii di wee Kilɛ kabaŋa sha pʼi fulo wee na. Kɔnhɔ pu daalapye wuu di wee Kilɛ ta, bani Kilɛ sanha ya lii wa shishiin na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bani ‹Wee wʼa wèe yàa, na ɲiifɛɛrɛ kan wèe mu, na sefɛɛrɛ bɛ kan wèe mu wù já wʼà ɲɛri.› Mu yee wo yoceelee pii bɛ ya jo na: ‹Kilɛ ni wèe ya foro.› ");
INSERT INTO myk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Kilɛ ni wèe ya foro. Lee na wèe bi foro Kilɛ ni, wèe ya yaa na li cɛ na sipyii keye yʼa pɛɛŋɛ yaŋmuyɔ yemu yàa ni sanni, kelee warifyɛn, kelee kagereye ni ge, na Kilɛ ɲɛ ba yee pɛɛŋɛ yaŋmuyɔ yi ɲɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Lee kadugo na a Pɔli di jo: «Kilɛ ya taatorogoo keree ki wii nige wɛ, bani ki cɛbaara tʼa bi yee pye yee na ki pyi. Ga nimɛ, Kilɛ funŋɔ wa sipyii bɛɛri pu kee keree ki yaha pʼi daburajɛ jo xuu wu bɛɛri ni, pu da wee Kilɛ pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bani Kilɛ ya caŋa ka teŋɛ, kee na wu da ba kiiri kɔn koŋɔ ki bɛɛri na ni tiimɛ ni. Kilɛ yɛ pyaa ya ná wemu ɲaha bulo ge, wee wu da bye kiiri wu kɔnvɔɔ. Kilɛ ya ɲaha shɛshɛɛrɛ temu shɛ sipyii na wee shizhaa na ge, tee ɲɛ na wee ɲɛ na yeege xu ni.» ");
INSERT INTO myk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ba pʼa xuɲɛnɛ li kaa logo wɛ, a pʼi ganha na wu la wo. A pii di jo: «Caŋa katii wèe da ba yi saya logo ma mu.» ");
INSERT INTO myk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A Pɔli di foro pu niŋɛ ni na kari. ");
INSERT INTO myk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lee bɛ na, a pii di fara Pɔli na, na bye Yesu nʼa daa fɛɛ. Pee nʼa daa fɛɛ pu ni, kulo li kiirikɔɔn kuruŋɔ ki sipya wa bye pu ni wee mɛgɛ ɲɛ Denisi, na fara cee wa bɛ na wee mɛgɛ ɲɛ Damarisi, ni sipyii pii bɛ. ");
INSERT INTO myk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lee kadugo na a Pɔli di yìri Atɛni ni, na gari Korɛnte ni. ");
INSERT INTO myk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ba wʼa nɔ wà wɛ, na ná wa ɲa wà wee mɛgɛ ɲɛ na Akilasi. Yawutu wu bye wii wu dʼa se Pɔn fiige ki ni. Pee nibavomɔɔ pu bye, wu ni wu shɔ Pirisili na yìri Itali fiige ki ni, bani saannaa Kulodi bi jo na Yawutuu pu bɛɛri pu foro Oromɛ ni. Lee lʼa Akilasi ni wu shɔ wu pye pʼa yìri Itali fiige ki ni na pa. A Pɔli di shɛ foro pu na. ");
INSERT INTO myk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A wu kariɲɛɛgɛ leŋɛ ni pu ni, na diin pu yíri bani pu shuun wu bɛɛri bi labyenumɔ pyi. Fàya piyɛyɛ pu bi yari. ");
INSERT INTO myk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ga cadɛɛngɛ bɛɛri Pɔli na gari Kilɛ-pɛɛŋɛ puga ki ni, na shɛ ganha na yu ni Yawutuu ni Girɛkii pu ni. Wʼa bi giin wu pu ɲɛri, pʼi sɔɔ Kafɔɔ na. ");
INSERT INTO myk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ga ba Silasi ni Timote ya yìri Masedɔni ni na pa wɛ, Pɔli ya ta latii pye nige ni Kilɛ Jozaama pu yɛrɛ li yɛ bɛ wɛ. Wʼa bi yi yu na wari Yawutuu pu mu na Kilɛ wʼa Yesu ɲaha bulo na pye Shɔvɔɔ. ");
INSERT INTO myk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ga Yawutuu pu ya ta sɔɔ pee jomɔ pu na wɛ, a pʼi ganha na Pɔli fanri, na joguumɔ yu na waa wu na. Lee na a Pɔli di wu fadeŋɛ ɲahara na lee na ba bye sɛɛri kaa na pʼa she Kilɛ jomɔ ni. Lee kadugo na a Pɔli di jo: «Yee Yawutuu bye yee di ya ɲuwuuro ta ɲiga na wɛ, yee pʼa lee pye nɛ bɛ wɛ. Nimɛ shi watii mu nʼa da zhɛ Kilɛ kafila wu jo.» ");
INSERT INTO myk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ba Pɔli ya pee jomɔ pu jo wɛ, a wu yìri pee sipyii pu tàan na kari ná wa puga, wee mɛgɛ ɲɛ Tite Zhutusi. Kilɛ ɲìi fyaara sipya wu bye wii. Wu kaaŋa ki bi sogi Kilɛ-pɛɛŋɛ puga ki na. ");
INSERT INTO myk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A Kilɛ-pɛɛŋɛ puga ki ɲuŋɔfɔɔ ni wu puga shɛɛn di ba dà Kafɔɔ na, wee mɛgɛ ki bye Kiripusi. Korɛnte shɛɛn piimu bɛ pʼa Pɔli jomɔ pu logo ge, a pee niɲɛhɛmɛɛ bɛ di dà Kafɔɔ Yesu na. A pʼi pee batize. ");
INSERT INTO myk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Caŋa ka piige ni Kafɔɔ ya pa yi jo Pɔli mu kashɛɛ la ni na: «Ma ganha da vya sipya wa shishiin bɛ na wɛ! Ta yu, ma ganha da joo mayɛ na wɛ! ");
INSERT INTO myk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bani nɛ wa ni ma ni. Sipya wa shishiin da ga já ma co wu kakuunɔ pye ma na wɛ, bani nɛ sipyii ya ɲɛhɛ le kulo le ni.» ");
INSERT INTO myk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Lee na, a Pɔli di gori yaha Korɛnte ni, na sipyii kalaa Kilɛ Kafila ni fo yee nigin ni yeye gbaara. ");
INSERT INTO myk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tuun wemu ni Galiyɔn bi bye gbafɛnɛɛri Akayi fiige ki ni ge, a Yawutuu pʼi puyɛ pinnɛ na yìri Pɔli fɛni, na wu co kari kiirikɔɔn kuruŋɔ ki mu. ");
INSERT INTO myk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na jo: «We ná we ya sipyii pu ɲuyɔ kyɛɛgi na pʼa Kilɛ pɛlɛ pɛlɛgana lemu na ge, lee ya saha ni wèe wo saliya wu ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ga Galiyɔn ya ta Pɔli yaha wʼa tajogo ta wɛ, a wuyɛ pyaa di jomɔ pu lɔ na Yawutuu pu pye: «Nago kakuunɔ la we ná we ya pye kelee kapyebaana, nɛ bi da zɔɔ na yi jomɔ logo. ");
INSERT INTO myk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ga ma na jo li wa lee la wɛ, fo yee ni sipyiire tisara ni yi wo saliya wu wo nakaara keree yɛ, yiyɛ pyaa ki yee ɲaha shɔɔnri. Nɛ kunni tɔɔgɔ wa wee kiiri wu gɔn ni bada wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ba wʼa yee jo wɛ, na pu kɔri yeege kiiri wu takɔngɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ba lʼa pye mu wɛ, a pee Yawutuu pʼi wɔ Kilɛ-pɛɛŋɛ puga ɲuŋɔfɔɔ wu na. Wu mɛgɛ ki bye na Sositɛnɛ. A pʼi wu deele kpɔn. A Galiyɔn di wuyɛ pye kanna wu ya pu ɲaa bɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔli ya mɔ xuuni Korɛnte ni. Lee kadugo na a wu koo sha nʼa daa fɛɛ pu mu. A wu ni Pirisili ni Akilasi di jé kɔrɔgɔ ka ni na gaaŋi shiizhan Siiri fiige ki ni. Pɔli bi ɲɔmɛɛ lɔ Kilɛ mu, lee lʼa wu pye, ba wʼa nɔ Sankere ni wɛ, na wu ɲuŋɔ kuu wà, na na toro. ");
INSERT INTO myk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba pʼa nɔ Efese kulo li ni wɛ, a pʼi digi wà, na jé kanha ki ni. A Pirisili ni Akilasi di gori wà. A Pɔli di shɛ jé Kilɛ-pɛɛŋɛ puga ki ni, na jo ni Yawutuu pu ni. ");
INSERT INTO myk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","A pee di li sha wu mu na wu jɛri pye pu mu; ga Pɔli ya sɔɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A wu koo sha pu mu, na pu pye na Kilɛ bu sɔɔ na wee na ba guri ba sanha pu mu. Lee kadugo na a wu shɛ jé kɔrɔgɔ ki ni na gaaŋi. ");
INSERT INTO myk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ba kɔrɔgɔ kʼa shɛ nɔ Sezare kulo li ni wɛ, a wu foro, na gari Zheruzalɛmu ni, na shɛ nʼa daa fɛɛ pu shaari. A wu yìri wà, na gari Ancɔsi ni. ");
INSERT INTO myk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A wu jɛri pye Ancɔsi ni. Lee kadugo na a wu gari Galasi ni Firizi fiiye yi ni. A wu yee fiiye yi wo kulogoo ki bɛɛri ɲaari na nʼa daa fɛɛ pu kalaa, kɔnhɔ pu niyɛ di juri nʼa daa wu ni. ");
INSERT INTO myk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yawutu wa bi pa Efese ni, wee mɛgɛ ɲɛ na Apɔlɔsi. Alɛkizandiri shɛn wu bye wii. Wee ná wu bi jomɔ cɛ lʼa toro. Wʼa bi Kilɛ Kafila wu bɛ cɛ xuuni. ");
INSERT INTO myk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sipya wa wʼa bi Kafɔɔ Yesu kaa jo wu mu. Ga wu wo nijɛyɛ yi tɛhɛnɛ li bi bye Yohana Batizelipye wo kalaa wu yɛ. Ga lee bɛ na wʼa bi la le na Yesu kaa yu na ɲɔgi sipyiire ti bɛɛri mu ni wu zɔ wu bɛɛri ni. ");
INSERT INTO myk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Caŋa ka wʼa pa yìri, na yu ni lowaa ni sipyiire ti bɛɛri ɲii na Kilɛ-pɛɛŋɛ puga ki ni. Ba Pirisili ni Akilasi ya wu kalaa wu logo wɛ, a pee di wu yiri kari pu puga, na shɛ Yesu koo li ɲaha jo na ɲɔ wu mu. ");
INSERT INTO myk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Lee kadugo na, caŋa ka Apɔlɔsi funŋɔ bi bye wu shɛ Akayi fiige ki ni. A nʼa daa fɛɛ pʼi wu luu waha, na sɛmɛ tun Akayi nʼa daa fɛɛ pu mu, na wu bu nɔ wà, na pʼi wu co ɲɔ. Ba wʼa nɔ wà wɛ, piimu pu ɲɛ Yesu nʼa daa fɛɛ Kilɛ wo niimɛ wu gbɔɔrɔ ni ge, a wu kalaa wu la fara pee wo nʼa daa wu na, na ɲahagbaashɛɛrɛ kan pu mu xuuni. ");
INSERT INTO myk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bani wu kafila wu bi tajogo fɔ Yawutuu pu na sipyii pu bɛɛri ɲii na. A wu li shɛ na foro Kilɛ Kafila wu ni na Yesu wu ɲɛ Kirisa we. ");
INSERT INTO myk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na Apɔlɔsi yaha Korɛnte ni, a Pɔli di Azi boboyo fiige ki kɔn ɲɛri, na nɔ Efese ni, na nʼa daa fɛɛ pii ta wà. ");
INSERT INTO myk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","A Pɔli di pee nʼa daa fɛɛ pu yege na: «Tuun wemu ni yee ya dà Yesu na ge, yee ya Fɛfɛɛrɛ Munaa li ta wee tuun wu ni ya?» A pʼi Pɔli ɲɔ shɔ na: «Wèe ya cɛ na yaaga ka bɛ mɛgɛ ki ɲɛ Fɛfɛɛrɛ Munaa wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A Pɔli di pu yege sanha na: «Batizeli wekɛ yee dʼa pye wɛ.» A pʼi wu ɲɔ shɔ na: «Yohana Batizelipye wo we.» ");
INSERT INTO myk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A Pɔli di pu pye: «Batizeli wemu Yohana bi byi ge, wee bi li shɛɛ na sipyii ya daburajɛ jo pu jurumu wu na. A wu Izirayɛli sipyii pu pye na wemu wʼa ma wee kadugo ge, na pu dà wee na. Wee mɛgɛ ɲɛ Yesu.» ");
INSERT INTO myk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ba pee sipyii pʼa pee jomɔ pu logo wɛ, na ganha na puyɛ kaan nimɛ pu na batizeni Kafɔɔ Yesu mɛgɛ na. ");
INSERT INTO myk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Lee kadugo na a Pɔli di wu keŋɛ taha pu na, na Kilɛ ɲɛɛri pu mu. A pu bɛɛri di Fɛfɛɛrɛ Munaa ta na ganha na shi watii jomɔ yu, na ganha na kapaŋaa yu. ");
INSERT INTO myk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pii sipyii pii bi namaa kɛ ni shuun shi xɔ. ");
INSERT INTO myk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na Pɔli yaha wà Efese ni, wu bi se Kilɛ-pɛɛŋɛ puga ki ni, na Kilɛ saanra ti Jozaama pu yu sipyiire ti bɛɛri mu na fiinŋɛ, na li shaa wu jomɔ pu logovɛɛ pu bɛɛri mu na pu jé tee saanra ti ni. Wʼa bi lee pyi fo na shɛ nɔ yeye taanri na. ");
INSERT INTO myk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Sipyii pii funŋɔ bye pu dà Yesu na wɛ, pee bi Pɔli kafila wu she, na joguumɔ taga Yesu koo li mɛgɛ kyɛɛgi. Lee wuu na Pɔli ya nʼa daa fɛɛ pu yiri laha pee tàan, na gari ni pu ni Tiranusi wo kalaa tapyege ki ni. A wu ganha na pu yɛri ni Kilɛ Kafila ni wee xuu wu ni caŋa bɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","A Pɔli di li pye mu fo yee shuun. Sipyii piimu bye Azi fiige ki ni ge, Yawutuu fara Girɛkii na, pee bɛɛri ya Kilɛ Kafila wu logo. ");
INSERT INTO myk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pɔli ya kakanhaŋaa niɲɛhɛŋɛɛ pye Kilɛ baraga ni sipyii sanha kiimu tuugo ɲa ɲa wɛ, ");
INSERT INTO myk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ali fàya kelee faɲuŋɔɔ kiimu bɛɛri bi gbɔɔn Pɔli cére ti na ge, pu bi kee luu na dɛri yama fɛɛ na pʼi juuŋɔ. Jinaa ɲɛ piimu ni ge, na ki tɛri pee bɛ na jinaa pʼi foro pu ni. ");
INSERT INTO myk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yawutuu pii bi ɲaari na giin da jinaa kɔri da yeege sipyii ni. Caŋa ka pʼa pa yìri na pʼi shɛ jinaa kɔri yeege wa ni Yesu mɛgɛ na. Jomɔ pemu ni pee bi giin da jinaa pu kɔri ge, pee pu wa mɛ: «Pɔli ya Yesu wemu wo Jozaama yɛrɛ pyi ge, yi foro we ni wee Yesu wu wo mɛgɛ na!» ");
INSERT INTO myk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yawutuu wo saraya ɲaha shɔɔnrivɔɔ wemu mɛgɛ ki ɲɛ na Seva ge, wee wo jalaa gbarashuun wʼa we labye we pye. ");
INSERT INTO myk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ba pʼa yee jo ni jinaa sipya wu ni wɛ, a jina wu pu ɲɔ shɔ na: «Nɛ Yesu cɛ, na Pɔli bɛ cɛ, ga yee di ɲɛ jɔgɔ yɛ wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","A wee ná jinaa wo wu do pu na, a wu fanha di ɲɛhɛ pu na, a wu pu kpɔn na bana bana, na pu fàya bɛ wolo pu na. A pu ceepilegee wuu di baa foro puga ki ni. ");
INSERT INTO myk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A lee kaa lʼi Efese shɛɛn pu bɛɛri círi, Yawutuu fara Girɛkii na, a pu bɛɛri di fya. Lee wuu na a sipyiire tʼi ganha na Kafɔɔ Yesu mɛgɛ ki pɛlɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Lee na piimu pu bi dà Yesu na ge, a pee niɲɛhɛmɛɛ di ba daburajɛ jo pu kakuuyo yi na, na yi paari sipyiire ti bɛɛri ɲii na. ");
INSERT INTO myk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Piimu pu bi siganma pyi ge, a pee niɲɛhɛmɛɛ di ba ni pu siganma sɛmɛɛ ni, na ba pu sorogo sipyiire ti bɛɛri ɲii na. A pʼi pee sɛmɛɛ pu wari ɲɔyɔ wá wá yiyɛ na, a yʼi bɛ ni warifyɛn tuuŋɔɔ kabɔfoŋɔɔ kɛ (10.000) shi ni. ");
INSERT INTO myk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lee funŋɔ ni a Kafɔɔ wo kafila wu ganha na se taa na se ɲaha na, fo na sipyiɲɛhɛmɛɛ pye pʼa fara nʼa daa fɛɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lee bɛɛri kadugo na a Pɔli di li shɛ na wee na doro Masedɔni fiige ke ni Akayi fiige ki ni wʼa se Zheruzalɛmu ni. A wu li shɛ na wee bu nɔ wee xuu wu ni, na wee na zhɛ Oromɛ bɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","A wu wu tɛgɛvɛɛ shuun yaha kari wuyɛ ɲaha na Masedɔni ni. Pee ɲɛ Timote ni Erasiti. A wuyɛ pyaa di gori Azi fiige ki ni, na jɛri pye wà. ");
INSERT INTO myk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wee tuun wu ni a tunmɔ di din Yesu koo li wuu na. ");
INSERT INTO myk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tudunna wa bye wà wee mɛgɛ ɲɛ Demecusi. Efese shɛɛn yapɛrɛ lemu li ɲɛ yapɛrɛzhɔ pʼi li mɛgɛ yiri na Aritemisi ge, wʼa bi lee wo puga ki tuugo nifɛnhɛfɛnhɛŋɛɛ yari ni warifyɛn ni na bɛrɛɛ sipyii mu wari niɲɛhɛmɛ na. ");
INSERT INTO myk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Caŋa ka, a wee ná wu ba wu kapyebyii ni wu tudunɲii pii yiri na pu pye: «Yʼa li cɛ na we labye we ni wèe ɲɔlige ya fòro. ");
INSERT INTO myk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ga nimɛ le Pɔli ya byi ge, yeeyɛ pyaa ya lee logo, na li ɲa bɛ. Le kaa le wa Efese kulo li yɛ ɲuŋɔ kaa wɛ dɛ! Ga lʼa giin di bye nimɛ Azi fiige ki bɛɛri ɲuŋɔ wuu. Wee Pɔli wu wʼa yu na sipyii ya pɛɛŋɛ yaŋmuyɔ yemu yari ni pu keye ni ge, na yee ɲɛ see yaŋmuyɔ wɛ. Pee jomɔ pʼa sipyii niɲɛhɛmɛɛ ɲuyɔ kyɛɛgi xɔ. ");
INSERT INTO myk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lemu lʼa wù funyɔ shaa ge, le ganha bu da wù lada koro tɔ wɛ. Ga lee yɛ bɛ wɛ. Li bu shɛ ɲaha na, wèe yapɛrɛzhɔ wemu mɛgɛ ki ɲɛ Aritemisi ge, sipyii pu na ba kadugo le wee ni. Pɛɛŋɛ ke wʼa daa ge, kee na ba gɔn wu na, na ta Azi fiige ki shɛɛn ni fiiye yi saya bɛɛri wo sipyii di wu pɛlɛ.» ");
INSERT INTO myk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ba Demecusi ya pee jomɔ pu jo le sipyii pu niwegee ni wɛ, a pu logoo di yìri. A pʼi ganha na sɛlɛ na yu: «Efese shɛɛn yapɛrɛzhɔ wemu mɛgɛ ki ɲɛ Aritemisi ge, wʼa pɛlɛ, wu ɲɔhɔ ɲɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A pee tunmɔ pʼi kulo li bɛɛri wuregi. Lee bi Pɔli tahama-nɔhɔmɔɔ pii ta wà, pee mɛyɛ ɲɛ, Gayusi ni Arisitaaki. Pee bye Masedɔni shɛɛn, a sipyiire ti gburogi kari na shɛ pee co, na pu fuulo na kari pinnɛrɛ kpɛɛngɛ ki na. ");
INSERT INTO myk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","A Pɔli yɛ pyaa di ganha na giin wu shɛ sipyiire ti fɛni, ga nʼa daa fɛɛ pu ya ta sɔɔ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azi fiige ki sipyigbɔɔ pii bɛ bye wà, pee bye Pɔli naɲiinɛɛ. A pee bɛ di tuduro tun Pɔli mu, na wu ganha da zhɛ sipyii pu tapinnɛgɛ ki ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tunmɔ pʼa pa bɛlɛ sipyii pu tapinnɛgɛ ki ni, wa nijoyo ni wa woyo ɲɛ nigin wɛ. Sipyiire tiyɛ pyaa bɛ bi tiyɛ kapinnɛnɛ ɲuŋɔ cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yawutu ná wa bye wà wee mɛgɛ ɲɛ na Alɛkisandire. A sipya wa di kii keree kii ɲaha jo wu mu. A Yawutuu pusamaa di wee ŋmunuŋɔ na wu shɛ ɲahagbaa li na wu jo. A wee di wu keŋɛ yirige na jomɔ wa wee mu. Wʼa bi giin wu li shɛ sipyiire ti na na Yawutuu pu ya ta kakuunɔ la shishiin pye wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ga ba sipyiire tʼa li cɛ na Yawutu wu ɲɛ wɛ, a pu bɛɛri di ganha na zɛlɛ fo lɛɛrɛɛ shuun shishiin na yu: «Efese shɛɛn wo yapɛrɛzhɔ Aritemisi wʼa pɛlɛ, wu ɲɔhɔ ɲɛ wɛ!» ");
INSERT INTO myk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Li ya ta ɲɔ wɛ, fo kulo li fɛkama wuyɛ pyaa ya la le na tunmɔ pu yereŋɛ. A wu pu pye: «Efese shɛɛn, koŋɔ ke bɛɛri ya li cɛ na yapɛrɛzhɔ Aritemisi we wʼa yìri fugba we ni na pa do ge, na Efese kulo li lʼa wee ni wu gbaha ki kasɛɛgɛ pyi. ");
INSERT INTO myk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Wa shishiin da já yee kaala wɛ. Lee na yi loxulo ta, yi ganha ba keree pyi yiyɛ ɲuŋɔ fɛni mu wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bani yee ya baha pii namaa shuun we na na co na pa naha, na ta pee di ya yaaga yu yapɛrɛgbaha ki ni wɛ, pʼi wa joguumɔ bɛ jo na wá wèe yapɛrɛzhɔ nigbɔhɔŋɔ ki na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ga wa bu la pye Demecusi ni wu kapyebyeɲii pu na lemu ya bɛ wɛ, kiiri cagɔngɔ wa, fanhafɛɛ pu bɛ di wa. Pu shɛ ni lee kaa li ni pee mu. ");
INSERT INTO myk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kelee kaa latii bi ɲɛ, yi na já ba wù cabinnɛgɛ caŋa ke. ");
INSERT INTO myk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ni lee kunni bɛ wɛ, tunmɔ pemu wèe ya yirige niɲaa ge, pu na já wèe jaagi pee wuu na na wèe pʼa giin wù sipyiire ti ɲuyɔ kyɛɛgi. Bani pu bu wù yege, wù wa da já sipyiire ti kapinnɛnɛ ɲuŋɔ jo sipya wa shishiin mu wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ba wʼa yee jo xɔ wɛ, na sipyiire ti bɛɛri pye na tʼa gaaŋi piyɛyɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ayiwa, ba tunmɔ pu kafugo ya pa wo wɛ, a Pɔli di nʼa daa fɛɛ pu yiri pinnɛ; na jo ni pu ni, na pu yɛri, na pu logoo waha, na na koo sha pu mu, na gaaŋi Masedɔni fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pɔli nidorowo kee fiige ki ni, a wu kafila wa taga lowagaa kan wee xuu wu nʼa daa fɛɛ pu mu, na na toro na gaaŋi Girɛkii fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A wu yeye taanri pye wà, na ba gbegele caŋa ka na wu kɔɔgbɔhɔ ka lɔ wʼa se Siiri fiige ki ni. Ga, a wu ba logo na Yawutuu pii pʼa woni pye wu mɛgɛ na. A wu kɔɔgbɔhɔ ki wo zhɛ wu fiin, na guri pa doro Masedɔni ni na kari wà tɔɔyɔ na. ");
INSERT INTO myk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sipyii piimu pu bi pinnɛ ni Pɔli ni wu ɲaagoo li na ge, pee pu wa mɛ: Bere shɛɛn Pirusi ja Sopatɛri, ni Tesaloniki shɛɛn shuun: Arisitaaki ni Sekundusi, ni Dɛribɛ shɛɛn Gayusi, na fara Timote na, ni Azi fiige shɛɛn shuun: Tishiki ni Torofimɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","A pee di doro wèe ɲaha na, na shɛ wèe sige Torowasi kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ba Shizhɛnhɛrɛ Baa Buuri Kalenɛ lʼa toro wɛ, a wèe di jé kɔɔgbɔhɔ ka ni Filipe kulo li ni, na cabyaa kaguro pye na na nɔ Torowasi ni, na shɛ pu ta wà. Ba wèe ya nɔ wà wɛ, na cewuu nigin pye wà. ");
INSERT INTO myk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pɔri ɲimuguro nibiige ki ni, a wèe bɛɛri di shɛ binnɛ, kɔnhɔ wù Kafɔɔ wo yalige ki li shiizhan. A Pɔli di nʼa daa fɛɛ pu yɛri. Wu funŋɔ bi bye wu ba lɔ wʼa gaaŋi kee caŋa ki ɲimuguro. A wu sii mɔ jomɔ pu na nʼa daa fɛɛ pu mu fo na shɛ ɲiŋɛ ki ɲi. ");
INSERT INTO myk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wèe bɛɛri pu bye wà na pinnɛ zangaso wa ni. A pʼi sokinnaa niɲɛhɛmɛɛ le le na yaha puga ki ni. ");
INSERT INTO myk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lɛvɔɔ wa bye ni wèe ni, wu mɛgɛ ɲɛ na Utikusi; Wee nidɛɛngɛ di bye puga ki fenɛtiri wu ɲɔ na. A wee di bye wà na ba ŋmunɔ, fo na funŋɔ wɔ wuyɛ na. Na Pɔli yaha wu na yu, a ŋmunumɔ pʼi ba wu figi. A wu yìri wà fo zangaso wu puga taanri wogo ki ɲuŋɔ ni, na ba do ɲiŋɛ na. Ba pʼa pa di ba wu lɔ wɛ, na ba wu ta wʼa xu. ");
INSERT INTO myk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","A Pɔli di digi, na shɛ leele wu ɲuŋɔ ni, na wu co wu keye ni, na wèe pye: «Yi ganha da yi fungɔnyɔ yi kyɛɛgi wɛ! Wu wa ɲìi na.» ");
INSERT INTO myk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lee kadugo na a Pɔli di dugi zangaso wu ni sanha, a wu ni nʼa daa fɛɛ pʼi shɛ puyɛ pinnɛ wà sanha. A pʼi binnɛ li shiizhan Kafɔɔ mɛgɛ na. Lee kadugo na a Pɔli di jo na mɔ ni pu ni sanha, fo na shɛ ɲiga ki pye kʼa mugi, na na kari. ");
INSERT INTO myk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A Utikusi puga shɛɛn di gari ni wu ɲìi wo wu ni puga. A lee kaa lʼi sii nʼa daa fɛɛ pu bɛɛri logoo ɲiŋɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Lee kadugo na a wèe di jé kɔɔgbɔhɔ ka ni na doro Pɔli ɲaha na na gaaŋi Asɔsi kulo li ni. Bani wu bi jo na tɔɔyɔ na wee da da gaaŋi Asɔsi ni, na wèe di shɛ wu lɔ wà. ");
INSERT INTO myk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ba wèe ya shɛ wùyɛ ɲuŋɔ círi Asɔsi ni lee cirigana li na ni Pɔli ni wɛ, a wu bɛ di jé kɔɔgbɔhɔ ki ni. A wèe di gari kulo la ni lee mɛgɛ ɲɛ na Mitilɛni. ");
INSERT INTO myk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Caŋa kemu wèe ya foro wee xuu wu ni ge, kee caŋa ki ɲimuguro a wèe di nɔ Kiyɔsi kulo li shizhaa na. Ki ɲimuguro shuun wuuro, a wèe di nɔ Samɔsi kulo li ni. Ki ɲimuguro taanri wuuro, a wèe di nɔ Milɛti kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔli funŋɔ bye wu yere Efese kulo li ni wɛ, kɔnhɔ wu ganha da mɔ doro Azi fiige ki ni wɛ. Wu bi sige kanha wu nɔ Zheruzalɛmu ni, kɔnhɔ wu bu já nɔ wà, wu shɛ Pantekɔti wu caŋa ki ɲuŋɔ círi wà. ");
INSERT INTO myk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lee wuu na Pɔli ya tiin Milɛti kulo li ni, na pii tun na pu shɛ Efese kulo li nʼa daa fɛɛ nɔhɔlɛɛ pu yiri pa. ");
INSERT INTO myk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba pʼa pa nɔ wɛ, a wu pu pye: «Na cebooloo, fo caŋa kemu tɛhɛnɛ na nɛ na tɔɔgɔ shan Azi fiige ki ni ge, fo na pa nɔ niɲaa na, yee wa nɛ ɲaarigana ni nɛ kapyegee ki bɛɛri cɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nɛ nayɛ tirige tuun bɛɛri ni na kapyeŋɛɛ pyi Kafɔɔ mu, na ɲaa soro, na ɲɛsinmɛ wo. Yawutuu bɛ ya woni pye nɛ kaa na tɔɔɲii niɲɛhɛŋɛɛ ni, na sii kanhama nigbɔ nɔ nɛ na xuuni. ");
INSERT INTO myk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Lee bɛ na, yee kuduun ɲɛ kaa lemu ni ge, nɛ lee la shishiin ŋmɔhɔ yee na wɛ. Nɛ yee kalaa Kilɛ Kafila wu ni sipyii bɛɛri ɲii na, na yi kalaa yiyɛ pyaa piyɛyɛ bɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Na yi jo na waha sipyii pu bɛɛri mu, Yawutuu fara Girɛkii na, jo pu daburajɛ jo pu jurumu wu na, pʼi sɔɔ Kilɛ na, pʼi dà wu Kafɔɔ Yesu na. ");
INSERT INTO myk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ayiwa nimɛ, Zheruzalɛmu ni di wa gaaŋi. Kilɛ Munaa lʼa na ɲaha co na se wà. Le lʼa da zhɛ na ta wà ge, di wa lee cɛ wɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ga kulo bɛɛri ni kunni nʼa toro ge, Fɛfɛɛrɛ Munaa na li shɛ na na, na kasolenɛ ni kanhama pu wa na ɲaha na wà. ");
INSERT INTO myk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lee bɛ na nɛ na munaa li wii yaaga wɛ. Le lʼa dan nɛ ni ge, lee li wa mɛ. Tuduro te tʼa kan nɛ mu ge, na tee shɔɔnri fo ti tɛhɛnɛ. Kafɔɔ Yesu ya labye wemu bɛɛri kaa le nɛ keŋɛ ni ge, nɛ funŋɔ wa di wee bɛɛri pye di wu xɔ. Wee labye wu wu wa mɛ, na Kilɛ wo niimɛ we wo Jozaama pu jo sipyii pu mu. ");
INSERT INTO myk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ayiwa, nɛ toro yee piimu niŋɛ ni, na Kilɛ saanra ti wo kafila wu jo ge, nɛ li cɛ jo nɛ ni yee wa da wùyɛ ɲa nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lee lʼa li pye nʼa yi fiinŋɛ jo yi mu, sipya wa shishiin wo shishan foo wa nɛ na nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Bani nɛ Kilɛ ɲidaan bɛɛri shɛ yee na, nɛ yafiin ŋmɔhɔ yi na wɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ayiwa, yi kasɛɛgɛ yaha yiyɛ na dɛ! Fɛfɛɛrɛ Munaa lʼa yi teŋɛ dubyagbaha kemu ɲuŋɔ ni ge, yi kee co xuuni ba dubyanaha-jemɛɛ ɲɛ wɛ. Kilɛ ya nʼa daa fɛɛ piimu shɔ wu Ja wu wo shishan pu baraga ni ge, yi kasɛɛgɛ yaha pee na, yʼi pu comɔ cɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nɛyɛ pyaa ya li cɛ jo nɛ nigarixhɔgɔ na yacoyo na ba jé yee niŋɛ ni, na do dubyaa pu na. ");
INSERT INTO myk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ali yeeyɛ pyaa kii bɛ ni naha, pii na ba foro yee ni, na kafinɛyɛ taga nʼa daa fɛɛ pii ɲuyɔ kyɛɛgi, na pye puyɛ pyaa wo kalaapiire. ");
INSERT INTO myk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lee wuu na, yi kasɛɛgɛ yaha yiyɛ na. Yi yi funyɔ tirige li na na yee taanri nɛ pye naha yee niŋɛ ni na yee bɛɛri nigin nigin wu kalaa caŋa fara piige na, fo na ɲɛsinmɛ wo yee kaa na. ");
INSERT INTO myk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ayiwa, nimɛ nʼa da yi kaa le Kilɛ ni wu niimɛ jomɔ pu keŋɛ ni. Kilɛ ya sipyii piimu pye fɛɛfɛɛ ge, yee bɛ pu wa pee ni. Wu na ba fanha kan yi mu nʼa daa wu ni, loolodaa lemu bɛ wʼa kemɛ yaha ge, na lee bɛ kan yi mu. ");
INSERT INTO myk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nɛ ta ɲii yeege wa shishiin wo wari, kelee wu sanni, kelee wu fàya fɛni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yee ya li cɛ na jo nɛyɛ pyaa keye yi wo labye wʼa nɛ keree bɛɛri yàa, na na ɲaariɲii pu bɛɛri wogoo yàa. ");
INSERT INTO myk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nɛ li shɛ yee na shɛgana bɛɛri na jo mu wèe ya yaa na kapyeŋɛɛ pyi na la baa fɛɛ pu tɛri, na wù funyɔ tirige ni Kafɔɔ Yesu yɛ pyaa wo jomɔ pu ni na: ‹Duba ya daa gan funŋɔ ni na toro da na.›» ");
INSERT INTO myk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ayiwa, ba Pɔli ya xɔ pee jomɔ pu na wɛ, na nuguro sin, a wu ni nʼa daa fɛɛ pu bɛɛri di binnɛ Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","A nʼa daa fɛɛ pu bɛɛri di sii mɛhɛɛ su xuuni Pɔli gari wuu na. A pʼi wu shaari ni taanɲɛɛgɛ fo ni. ");
INSERT INTO myk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lee kadugo na a pʼi Pɔli torogo na pa kɔrɔgɔ ki ɲɔ na. Pɔli ya jomɔ pemu jo na niɲaa tɛhɛnɛ na na pu da ɲii taha wee na nige-e ge, pee jomɔ pe bi pu ɲahaya tanha xuuni. ");
INSERT INTO myk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ayiwa, wee tuun wu ni a wèe di fò wu kan wùyɛ mu ni nʼa daa fɛɛ pu ni, na jé kɔɔgbɔhɔ ki ni na kari Kɔsi ni. Kee caŋa ki ɲimuguro, a wèe di nɔ Orode ni, na yìri wà, na gari Patara ni. ");
INSERT INTO myk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ba wèe ya nɔ wà wɛ, na kɔɔgbɔhɔ ka ta ki na se Fenisi fiige ki ni. A wèe di jé kee ni na kari. ");
INSERT INTO myk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ba wèe ya shɛ nɔ Sipɛrɛ fiige ki shizhaa na wɛ, ma ɲɛhɛ yere kɔɔgbɔhɔ ki ni ma na da kee ɲaa. A wèe di kee yaha mɛ kamɛnɛ cɛ wu ni, na doro kari Siiri fiige ki ni. A kɔɔgbɔhɔ ki shɛ yere Tiiri kulo li ni, bani lee kulo li ni tuguro ti bi yaa na tirige. ");
INSERT INTO myk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","A wèe di foro kɔɔgbɔhɔ ki ni, na jé kanha ki ni, na shɛ nʼa daa fɛɛ pii ta wà Tiiri ni. A wèe di cewuu nigin pinnɛ pye ni pee ni wà. Pɔli bi da zhɛ kanhama pemu ɲa Zheruzalɛmu ni ge, Fɛfɛɛrɛ Munaa bi pee kaa jo pee nʼa daa fɛɛ pu mu. A pee di Pɔli pye: «Ma ganha bu shɛ Zheruzalɛmu ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ga ba wèe cagaraga kʼa pa nɔ wɛ, nʼa daa fɛɛ pu fara pu cèe na, na fara pu nɔhɔpiire na, a pu bɛɛri di foro di zhɛ wèe torogo. A pʼi foro ni wèe ni kanha ki ni na kari fo kɔrɔgɔ ki ɲɔ ki na. A wèe bɛɛri di shɛ binnɛ nuguro sin wà lɔhɔ ki ɲɔ ki na, na Kilɛ ɲɛɛri. ");
INSERT INTO myk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Lee kadugo na a wèe di fò wu kan wùyɛ mu, na jé kɔɔgbɔhɔ ki ni, a pee kunni di guri na gaaŋi pu kabanya ni. ");
INSERT INTO myk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ayiwa, ba kɔɔgbɔhɔ kʼa yìri ni wèe ni Tiiri kulo li ni wɛ, a wèe di shɛ digi kulo la ni lee mɛgɛ ɲɛ na Potolomasi; Wà wèe ya kɔrɔgɔ ki wo ɲara li ɲɔ yaha. A wèe di foro kɔɔgbɔhɔ ki ni, na jé kanha ki ni, na shɛ nʼa daa fɛɛ pu shaari, na lee caŋa ɲii le pinnɛ pye ni pu ni shiizhan. ");
INSERT INTO myk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kee caŋa ki ɲimuguro, a wèe di ɲaari kari Sezare kulo li ni, na shɛ digi Filipe ɲuŋɔ ni. Nʼa daa fɛɛ pu bi sipyii gbarashuun wemu ɲaha bulo na pee pu tudunmɔɔ pu tɛgɛ labye wu na ge, wee Filipe we bɛ wʼa bye pee gbarashuun we ni. Kafɔɔ Yesu wo Jozaama pu jovɔɔ wa wu bye wii. ");
INSERT INTO myk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Doɲiŋɛ pushaa nacɛbaalaa shishɛɛrɛ wu bye Filipe mu. Kilɛ bi jomɔ yu pee bɛɛri mu pu na dorogo sipyii mu. ");
INSERT INTO myk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","A wèe di diin Filipe kaban na cabyaa niɲɛhɛŋɛɛ pye wà. Na wèe yaha Filipe kaban, a Kilɛ tudunmɔ wa di ba ba caŋa ka na yìri Zhude fiige ki ni. Wee mɛgɛ ki bye na Agabusi. ");
INSERT INTO myk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A wee ná wu nɔ wèe na, na Pɔli wo kirimɛɛ lɔ, na lee taga wuyɛ pyaa keye ni wu tɔɔyɔ pɔ, na jo: «Fɛfɛɛrɛ Munaa lʼa jo na Yawutuu pu da ba shɛ le kirimɛɛ le kafɔɔ co Zheruzalɛmu ni, na wu pɔ le pɔgana le na, na wu le shi watii keŋɛ ni wemu ɲɛ Yawutuu wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ba wèe ya pee jomɔ pu logo wɛ, a wèe ni wee xuu wu shɛɛn di binnɛ Pɔli ɲɛɛri jo wu ganha bu shɛ Zheruzalɛmu ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","A Pɔli di jo: «Ɲaha wo mɛhɛɛ yee di suu mɛ wɛ? Yʼa giin yʼi na ɲaha tanha gɛ? Nɛ gbegele xɔ xu ka na Zheruzalɛmu ni Yesu Kirisa mɛgɛ wuu na pu da jo pɔɔrɔ.» ");
INSERT INTO myk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wèe ya pa li ɲa nago Pɔli ya go wu wu hakili laha Zheruzalɛmu shɛɛ li na-ɛ ge, a wèe di cari, na jo: «Le li wa Kilɛ ɲidaan ge, lee li pye.» ");
INSERT INTO myk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","A cabyaa dama dama di doro, a wèe di gbegele na gari Zheruzalɛmu ni. ");
INSERT INTO myk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","A Sezare kulo li wo nʼa daa fɛɛ pii di binnɛ kari ni wèe ni. Ba wèe ya nɔ Zheruzalɛmu ni wɛ, wèe bi yaa wèe pu tigi ná wemu ɲuŋɔ ni ge, a pee nʼa daa fɛɛ pʼi gari ni wèe ni wee kaban. Wee ná wu mɛgɛ ki bye na Minasɔn, Sipɛrɛ shɛn wu bye wii. Wee bi dà na xɔ Yesu na lʼa mɔ. ");
INSERT INTO myk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ba wèe ya nɔ Zheruzalɛmu ni wɛ, a wèe cebooloo nʼa daa fɛɛ pʼi wèe ɲuŋɔ círi ni fundanga ni. ");
INSERT INTO myk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kee caŋa ki ɲimuguro a Pɔli di gari ni wèe ni Yakuba kaban. Nʼa daa fɛɛ nɔhɔlɛɛ pu bɛɛri bɛ pu bi pinnɛ wà. ");
INSERT INTO myk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ba fò wʼa pye xɔ wɛ, a Pɔli di jomɔ pu lɔ. Shi wemu ɲɛ Yawutuu-i ge, Kilɛ ya kaa lemu pye wee shi wu bɛ tɛ ni Pɔli wo Kilɛ jomɔ yɛrɛ li funŋɔ ni ge, a wu ɲɔ le kee ni, na kee bɛɛri paari pu mu nigin nigin na. ");
INSERT INTO myk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba pʼa yee logo wɛ, a pu bɛɛri di Kilɛ sɔ, na baraga taha wu na. Lee kadugo na a pʼi Pɔli pye: «Wù ceborona, mʼa ɲaa wɛ, Yawutuu xhuu niɲɛhɛmɛɛ pʼa dà Yesu na naha, ga, ali niɲaa we bɛ ni, pu bɛɛri ya taha yaha Kilɛ tudunmɔɔ Musa wo saliya wu fɛni. ");
INSERT INTO myk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Sipyii pii dʼa pa yi jo pu mu na Yawutuu piimu pu wa shi wusama tɛ ni ge, na mu wu wa yi yu pee Yawutuu pu mu na pu Kilɛ tudunmɔɔ Musa wo saliya wu keree ki yaha; na pu ganha ba pu nɔhɔpiire kɔɔn nige wɛ, pʼi ganha ba kalɛgɛɛ kii shishiin bɛ pyi wɛ. ");
INSERT INTO myk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ayiwa, wèe na lee kaa le co cogana lekɛ na wɛ? Li pye pyegana bɛɛri na pu na ba li cɛ na mu ya pa. ");
INSERT INTO myk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lee funŋɔ ni, le wʼà da jo ma mu nimɛ ge, mʼa yaa ma lee pye. Ayiwa, namaa shishɛɛrɛ ɲɛ naha wèe mu, pee bi ɲɔmɛhɛɛ lɔ Kilɛ mu. ");
INSERT INTO myk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ma da jé ni pu ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, mʼa mayɛ pye fɛɛfɛɛ, mʼa pu bɛ pye fɛɛfɛɛ na bɛ ni saliya wu ni. Mʼa pu bɛɛri wo ɲuguupɛrɛmɛ wolo, kɔnhɔ pʼi pu bɛɛri ɲuyɔ kuu. Lee bu bye Yawutuu pu na ba li cɛ na sipyii pʼa keree kiimu bɛɛri jo mu shizhaa na ge, na lee la shishiin wa can wɛ. Pu na ba li ɲa bɛ sanha na muyɛ pyaa ki bɛ kʼa ɲaari na sahaŋi ni Musa wo saliya wu ni. ");
INSERT INTO myk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Shi wemu ɲɛ Yawutuu wɛ, wu bɛ dʼa dà Yesu na ge, wèe ya sɛmɛ tun xɔ pee bɛ mu, na wù fungɔnyɔ shɛ pu na; wèe ya li shɛ pu na jo xaara bɛɛri pʼa gbo yapɛrɛ na ge, pu ganha ba tee xaa wɛ, pu ganha ba shishan xaa wɛ, pu ganha ba yaxuyo xaa wɛ, pʼi ganha ba dɔdɔɔrɔ pyi wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ayiwa, a Pɔli di fara pee namaa shishɛɛrɛ wu na, tee ɲimuguro ti na a wu wuyɛ pye fɛɛfɛɛ na pee bɛ pye fɛɛfɛɛ. Lee kadugo na a pʼi gari Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni shiizhan. Pu fɛfɛɛrɛ cabyaa ki ɲɔ na ba fa caŋa kemu, ni pu bɛɛri nigin nigin wu saraya na ba wolo caŋa kemu ge, a Pɔli di yee caya yi shɛ pu na. ");
INSERT INTO myk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lee bi Azi fiige ki wo Yawutuu pii ta pee ya Pɔli ɲa Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. Ba cabyaa gbarashuun wu ɲɔ ya giin di va wɛ, a pʼi ba na sii tunmɔ pu pɛlɛ, na sipyii pu sɔn, a pʼi Pɔli co. ");
INSERT INTO myk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na ganha na xhuulo na: «Izirayɛli shɛɛn, yʼa ma yoo, yʼa ma! Ná we wʼa ɲaari na sipyii pu kalaa tɛyɛ yi bɛɛri ni na wèe wo shi wu ɲɛ xuuni-i ge, wee wu ɲɛ we. Wee wʼa yu bɛ sanha na wèe wo saliya we ni wèe wo Kilɛ-pɛɛŋɛ pugbɔhɔ ki ɲɛ xuuni wɛ. Lee bɛɛri kadugo na, Girɛkii bɛ ni wʼa pa na pa jé fo Kilɛ-pɛɛŋɛ pugbɔhɔ kiyɛ pyaa ni, na wèe wo fɛfɛɛrɛ xuu wu nɔrɔgɔ wèe mu.» ");
INSERT INTO myk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pʼa yee jo bani pʼa bi Efese shɛɛn Torofimɛ ɲa ni Pɔli ni kanha ki funŋɔ ni, na ganha na giin na wʼa jé ni wee bɛ ni Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ba lʼa pye mu wɛ, a kanha ki funŋɔ ki bɛɛri di wuregi. A sipyii pʼi ganha na fòro kabaya yi bɛɛri na, na fe na ma. A pʼi Pɔli co, na wu fuulo yeege Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, na gburaya yi tɔ taapile ni. ");
INSERT INTO myk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Na pu yaha pu na Pɔli shaa di gbo, a pii di baa kari na shɛ yi jo sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu mu na Zheruzalɛmu kulo li bɛɛri lʼa wuregi. ");
INSERT INTO myk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ba sɔrɔsii pu wo ɲuŋɔfɔgbɔ wʼa yee logo wɛ, taapile ni a wu sɔrɔsii pii lɔ na fara sɔrɔsii ɲuŋɔfɛɛ pii na, a pʼi baa jé kanha ki ni. Ba Yawutuu pʼa sɔrɔsii wo ɲuŋɔfɔgbɔ wu ɲa ni wu sɔrɔsii pu ni wɛ, a pʼi Pɔli wo kpɔɔnrɔ ti ɲɔ yereŋɛ. ");
INSERT INTO myk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu ba Pɔli co. A wu sɔrɔsii pu pye na pu tɔɔrɔ shɔnhɔyɔ shuun le wu na. Ba pʼa Pɔli pɔ na xɔ wɛ, a wu yegeŋɛ pye na: «We ná we di ɲɛ jɔgɔ wɛ? Ɲaha wu dʼa pye wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","A sipyii pu bɛɛri di ganha na xhuulo puyɛ taan, wa shishiin nijoyo ni wa woyo ɲɛ nigin wɛ. A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu ba li ta na wee wa da jomɔ pa shishiin ta logo tunmɔ pu keŋɛ ni wɛ, a wu sɔrɔsii pu pye na pʼa se ni Pɔli ni sɔrɔsii pu wo pugbɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ba pʼa shɛ nɔ tajege ki ni wɛ, a sipyii pʼi sii tunmɔ pu pɛlɛ fo sɔrɔsii pʼa na Pɔli lɔ. ");
INSERT INTO myk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bani sipyiɲɛhɛmɛɛ pu bi taha wu fɛni, na xhuulo na yu na: «Yi wu gbo laha wà! Yi wu gbo laha wà!» ");
INSERT INTO myk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pɔli nijewo pugbɔhɔ ki ni, a wu sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu pye: «Ta nɛ na já jo ni ma ni?» A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu jo: «A lʼi bye kanna mu wʼa Girɛkii jomɔ pu nuri gɛ? ");
INSERT INTO myk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Wee tuun wu ni, Misira shɛn ná we wʼa nʼa she le wuyɛ ni kurogo ke na, fo wʼa kari ni namaa kabɔfoŋɔɔ shishɛɛrɛ (4.000) ni sipoŋɔ ki ni gbuuro ti kaa na ge, mu wa were wɛ gɛ?» ");
INSERT INTO myk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","A Pɔli di wu ɲɔ shɔ na: «Yawutu nɛ ɲɛ, Tarisi kulo li ni nɛ yìri, Silisi fiige ki ni. Kulo lemu shɛn nɛ ɲɛ ge, lʼa pɛlɛ. Ɲɔ mayɛ na mʼa na yaha di jo ni sipyii pu ni.» ");
INSERT INTO myk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu kafila wu kan Pɔli mu na wu jo ni sipyii pu ni. A Pɔli di yere wà kuɲɔɔ li ni, na wu keŋɛ yirige sipyii pu mu, na wʼa giin di jo ni pu ni. Ba sipyii pʼa cari puyɛ na wɛ, a Pɔli di ɲɔ kɔn na yu ni pu ni Yawutuu jomɔ pu ni. A wu pu pye: ");
INSERT INTO myk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Na tii ni na cebooloo, yi logo na ɲɔ na. Nʼa da ba jo nimɛ na li shɛ yee na jo nɛ ta kakuunɔ la shishiin pye wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ba sipyii pʼa Pɔli ɲa wu na yu puyɛ pyaa wo jomɔ pu ni wɛ, a pʼi nɔhɔdaan jomɔ pu bɛɛri ɲɔ yaha, na fɛhɛ kpan. A Pɔli di jo: ");
INSERT INTO myk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Yawutu nɛ ɲɛ. Nɛ se Tarisi kulo li ni, Silisi fiige ki ni. Ga Zheruzalɛmu ni nɛ lɛ naha. Nɛ kalaa to wu bye Gamaliyɛli. Wee wʼa nɛ kemɛ kalaa na bɛ ni wù sefɛlɛɛ pu wo saliya wu keree ni. Kafugo bye nɛ bɛ ni fo xuuni Kilɛ-shaa li funŋɔ ni ba yee bɛ wa mɛ niɲaa wɛ. ");
INSERT INTO myk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nɛ bɛ wu bi Yesu koo li wo sipyii pu kana, fo na pii gbuu pu ni. Nɛ bi le koo le ɲaarivɛɛ coni cèe fara namaa na, na pu puu na leni kaso ni. ");
INSERT INTO myk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ we, ni nɔhɔlɛɛ ɲahagbaa fɛɛ wo kuruŋɔ ke, pee wa na sɛɛrɛɛ le kaa le na. Nɛ bi sɛmɛ ta bɛ pu mu, na gaaŋi di zhɛ gan Damasi kulo li wo Yawutuu pu mu, kɔnhɔ di bu shɛ Damasi ni, na shɛ nʼa daa fɛɛ pii ta wà, di pee bɛ co di pu pɔ, di ba ni pu ni Zheruzalɛmu ni, kɔnhɔ kanhama di ba nɔ pu na.» ");
INSERT INTO myk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ayiwa, na nɛ yaha nɛ na gaaŋi koo li ni, na ba shɛ dɛɛŋɛ Damasi na cafugo ki na. Taapile ni a kpɛɛngbɔhɔ ka di yìri fugba we ni, na ba ɲí na nɛ maha. ");
INSERT INTO myk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A nɛ wolo to ɲiŋɛ na, na mujuu la logo na: ‹Sɔli, Sɔli, ɲaha na mʼa na kana mɛ wɛ?› ");
INSERT INTO myk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","A nɛ yegeŋɛ pye jo: ‹Mʼi ɲɛ jɔgɔ wɛ, Kafɔɔ?› A wu nɛ pye: ‹Nɛ ɲɛ Nazarɛti shɛɛn Yesu, nɛ mu wa gana mɛ.› ");
INSERT INTO myk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ayiwa, sipyii piimu pu bye ni nɛ ni ge, pee kunni ya kpɛɛngbɔhɔ ki ɲa, ga we wu bi yu ni nɛ ni ge pu ya ta weefɔɔ wo mujuu li logo wɛ. ");
INSERT INTO myk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","A nɛ yegeŋɛ pye jo: ‹Kafɔɔ, lekɛ nɛ dʼa yaa na pye wɛ?› A Kafɔɔ di nɛ pye: ‹Yìri mʼa jé Damasi kanha ki ni, Kilɛ funŋɔ wa ma lemu pye ge, lee na zhɛ jo ma mu.› ");
INSERT INTO myk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kpɛɛngɛ ki bi pɛlɛ pɛlɛgana lemu na ge, a nɛ bye nɛ ɲaa nige wɛ. Sipyii piimu pu bye ni nɛ ni ge, a pee di na nɛ co keŋɛ na na jé kanha ki ni. ");
INSERT INTO myk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Lee bi ná wa ta Damasi ni wee mɛgɛ ɲɛ na Anaɲasi. Kilɛ ɲìi faara sipya wu bye wii fo xuuni, na ɲaari na sahaŋi ni Musa wo saliya wu keree ki bɛɛri ni. Damasi kulo li Yawutuu pu bɛɛri bi wu mɛsaaŋa yu, ");
INSERT INTO myk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A wee di ba nɛ fɛni, na ba yere nɛ taan, na jo: ‹Na ceborona Sɔli, ma ɲìi ki mugi mʼa wii!› Taapile ni, a nɛ ɲìi kʼi mugi, a nɛ wii na wu niyerege ɲa. ");
INSERT INTO myk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","A wu nɛ pye: ‹Wèe sefɛlɛɛ pu wo Kilɛ wu wʼa mu ɲaha bulo, kɔnhɔ mʼa wu ɲidaan cɛ. Wemu wʼa tii ge, mʼa wee ɲa, mʼa wu ɲɔ jomɔ bɛ logo. ");
INSERT INTO myk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bani ma na ba bye wu sɛɛri. Mʼa keree kiimu ɲa na kiimu logo ge, ma na ba kee wo yɛrɛ pyi sipyii pusamaa bɛɛri mu. ");
INSERT INTO myk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wee tuun wu ni nimɛ, ma ganha bu diin na kaa latii ma da da sigee wɛ. Yìri mʼa batize, ma wo jurumu wu yafa ma mu Yesu mɛgɛ ki gbɔɔrɔ ni.› ");
INSERT INTO myk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«A nɛ guri pa Zheruzalɛmu ni. Na nɛ yaha Kilɛ-ɲɛrɛgɛ na Kilɛ-pɛɛŋɛ pugbɔhɔ ki ni, a Kilɛ di kashɛɛ la shɛ nɛ na. ");
INSERT INTO myk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A nɛ Kafɔɔ ɲa, a wu nɛ pye: ‹Tɔgaaya lɔ, mʼa foro Zheruzalɛmu ni, bani jomɔ bɛɛri ma da ba jo naha nɛ shizhaa na ge, sipya wa shishiin wa da gbara pu na ma mu wɛ.› ");
INSERT INTO myk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","A nɛ wu pye: ‹Kafɔɔ, puyɛ pyaa wa li cɛ na nɛ wu bi ma ɲaari na Kilɛ-pɛɛŋɛ piyɛyɛ yi sahaŋi, na nʼa daa fɛɛ pu coni na pu sani, na pu leni kaso ni. ");
INSERT INTO myk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ali Ecɛni we wu bi mu jomɔ pu yu ge, pu bi wee gbuu tuun wemu ni ge, nɛyɛ pyaa ki bɛ bye wà. Nɛ bi sɔɔ li na jo pu Ecɛni gbo. Nɛyɛ pyaa kʼa bi Ecɛni gbovɛɛ pu fadeye yi co pu mu.› ");
INSERT INTO myk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Wee tuun wu ni a Kafɔɔ di nɛ pye: ‹Yìri, di ma tun shi watii mu taliige ni.›» ");
INSERT INTO myk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sipyii pu bɛɛri bi niwegee shan na Pɔli kafila wu nuri, fo na shɛ nɔ pe jomɔ pe na. Ga ba wʼa pa ɲɔ le yɛ pee jomɔ pu ni wɛ, a sipyii pʼi ganha na xhuulo na yu: «Ke sipyituugo ke ya yaa na ki gbo! We ya yaa pu wu yaha ɲìi na bada wɛ!» ");
INSERT INTO myk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","A pʼi ganha na sɛlɛ, na pu fadeye wolo na yee figi fugba we ni, na gbazhɛnhɛ kori na waa fugba wu ni. ");
INSERT INTO myk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ba sɔrɔsii pu wo ɲuŋɔfɔgbɔ wʼa lee ɲa mu wɛ, a wu sɔrɔsii pu pye na pu jé ni Pɔli ni sɔrɔsii pu wo pugbɔhɔ ki ni. Wʼa lemu pye sipyii pʼi sɛlɛ mɛ wu na ge, pʼi wu kpɔn ni susɔlɔɔ ni fo wu bu shɛ lee jo, ");
INSERT INTO myk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ga tuun wemu ni pu bi Pɔli puu pʼi wu kpɔn ge, sɔrɔsii ɲuŋɔfɔɔ we wu bye wu tàan ge, a Pɔli di wee pye: «Na bɛ ni saliya wu ni, lʼa saha nago yee pu Oromɛ shɛn kpɔn ni susɔlɔɔ ni wu kiiri kɔnbaa gɛ?» ");
INSERT INTO myk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ba sɔrɔsii ɲuŋɔfɔɔ wʼa yee logo wɛ, a wu gari sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu yíri na shɛ wu pye: «Ɲaha mʼa giin di bye mɛ wɛ? We ná we, Oromɛ shɛn wu ɲɛ wii!» ");
INSERT INTO myk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wuyɛ pyaa di shɛ Pɔli yege na: «Oromɛ shɛn yɛ pyaa mu ɲɛ ya?» A Pɔli di wu ɲɔ shɔ na: «Uun.» ");
INSERT INTO myk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu jo: «Wari niɲɛhɛmɛ nɛ saraa na na já pye Oromɛ shɛn.» A Pɔli di wu pye: «Nɛ dʼa sii se Oromɛ shɛn do!» ");
INSERT INTO myk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ba Pɔli ya pee jomɔ pu jo wɛ, piimu pu bi da wu kpɔn, pʼi wu karamu fo wu jo ge, a pee bɛɛri di jaaga laha wu tàan. A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu bɛ di fya, bani wee wu bi jo na pu Pɔli pɔ na ta Pɔli di ɲɛ Oromɛ shɛn cii yɛ pyaa. ");
INSERT INTO myk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ayiwa, kaa lekɛ na Yawutuu pʼa bi Pɔli jaagi ge, sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu funŋɔ bye wu lee tii cɛ. Lee wuu na wʼa tuduro yaha shɛ kee caŋa ki ɲimuguro, na pu saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni kiirikɔɔn kuruŋɔ ki sipyii pu bɛɛri yiri pinnɛ. Lee kadugo na a pʼi pɔɔrɔ ti sanha Pɔli na, na gari ni wu ni, na shɛ wu yereŋɛ pu niŋɛ ni. ");
INSERT INTO myk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","A Pɔli di ɲaha ki le kiirikɔɔn kuruŋɔ ki sipyii pu ni na jo: «Na cebooloo, nɛ na torogana li saha ni Kilɛ ɲidaan ni, fo na pa nɔ niɲaa na, fyaara bɛ ya pye nɛ zɔ wu ni li koro ni wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Jomɔ pe Pɔli ya jo ge, a pee di bye pu ya bɛ saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ Anaɲasi mu wɛ. Pii pu bye Pɔli tàan ge, a wu pee pye na pu Pɔli kpɔn wu ɲɔ ke na. ");
INSERT INTO myk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Wee tuun wu ni a Pɔli di wu pye: «Mu nivige ke kanna kasɔrɔgɔ kadugo ki! Kilɛ bɛ na ba mu kpɔn! Yatɛɛngɛ mu ya shan na tiin na nɛ kiiri ma da gɔn na saha ni saliya wu ni, mu ninumɔ di nɔhɔ mʼa yu sanha na pu nɛ kpɔn, na ta saliya wʼi ya yee jo wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sipyii pii pu bye Pɔli tàan ge, a pee di wu pye: «Go Kilɛ wo saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu mu wa zhɛhɛlɛ mɛ gɛ!» ");
INSERT INTO myk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A Pɔli di pu pye: «Na cebooloo, nɛ li cɛ nago saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ wu ɲɛ wii wɛ, sa lee ni wɛ nɛ bi da ye jo ni wu ni wɛ. Bani lʼa ka Kilɛ Kafila wu ni na: ‹Ma ganha da kafilakuumɔ jo wá ma ɲahagbaa fɔɔ na wɛ.›» ");
INSERT INTO myk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ayiwa, Pɔli bi li cɛ na kiirikɔɔn kuruŋɔ ki taaga ka ki ɲɛ Sadushɛɛn, taaga ki saŋa di ɲɛ Farizhɛɛn. Lee wuu na wʼa mujuu wá pu niŋɛ ni na pu pye: «Na cebooloo, Farizhɛn nɛ ɲɛ. Nɛ sefɛɛ ɲɛ Farizhɛɛn. Nɛ dà li na jo xuɲɛnɛ na ba bye ɲiga na ge, kee tadaŋa ke wuu na kiiri wʼa gɔɔn mɛ nɛ na niɲaa.» ");
INSERT INTO myk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ba Pɔli ya pee jomɔ pu jo yɛ wɛ, a nakaara di jé Farizhɛɛn ni Sadushɛɛn pu tɛ ni. A sipyii pʼi daa taaya shuun. ");
INSERT INTO myk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bani Sadushɛɛn, pee wa yu na xuɲɛnɛ da ba bye ɲiga na wɛ, na mɛlɛkɛɛ ɲɛ wɛ, na munahaa kiitiigee bɛ di ɲɛ wɛ. Na ta Farizhɛɛn, pee dʼa dà kii keree kii bɛɛri na. ");
INSERT INTO myk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A tunmɔ pʼi ganha na bɛlɛ fo xuuni. A saliya karamɔgɔlɔɔ pii di yìri Farizhɛɛn pu wo kuruŋɔ ki ni, na kafugo le puyɛ ni na jo: «Wèe kunni ya ta kakuunɔ la shishiin ɲa we ná we na wɛ. Ma na zhɛ li ta mɛlɛkɛ wa, kelee munaa la lʼa yu ni wu ni.» ");
INSERT INTO myk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A nakaara tʼi ba sii pɛlɛ fo sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu funŋɔ ya pɛn na pu ganha ba Pɔli kile gbo puyɛ tɛ ni wɛ. Lee wuu na wʼa sɔrɔsii pii tun na pu tigi, pʼi ba Pɔli shɔ sipyii pu na, pʼi shɛ ni wu ni sɔrɔsii pu wo pugbɔhɔ ki ni. ");
INSERT INTO myk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kee caŋa ki ɲimuguro nibiige, a Kafɔɔ di ba wuyɛ shɛ Pɔli na na wu pye: «La le mayɛ ni mʼa ma luu waha. Ba mʼa pye nɛ sɛɛri na nɛ kaa jo Zheruzalɛmu kulo li ni wɛ, mu ma da zhɛ bye nɛ sɛɛri, na nɛ kaa jo Oromɛ kulo li bɛ ni.» ");
INSERT INTO myk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kee caŋa ki ɲimuguro ɲisɔɔgɔ na, a Yawutuu pii di binnɛ na woni pye Pɔli kaa na. A pʼi gaa puyɛ mu na pee wa da li wɛ, pee di wa da lɔhɔ gba wɛ, fo pee bu shɛ Pɔli gbo. ");
INSERT INTO myk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Piimu pʼa bi wee woni wu pye ge, pee bi ɲɛhɛ namaa kɛlɛɛ shishɛɛrɛ (40) na. ");
INSERT INTO myk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","A pʼi gari saraya ɲaha shɔɔnrivɛɛ ɲuŋɔfɛɛ ni nɔhɔlɛɛ pu fɛni, na shɛ pee pye: «Wèe ya wùyɛ pinnɛ na gaa Kilɛ na, jo wèe da li wɛ, wèe di wa da lɔhɔ gba wɛ, fo wèe bu shɛ Pɔli gbo tuun wemu ni. ");
INSERT INTO myk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lee wuu na, yi ni kiirikɔɔn kuruŋɔ ki sipyii pusamaa bɛɛri, yi bɛ yi na yʼi shɛ sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu ɲɛɛri na wu pa ni Pɔli ni yi mu. Yʼi yiyɛ pye kanna yʼa giin yʼi ba wu keree ki deele yi ki suguri saama na. Wèe kunni wa gbegele xɔ na wu sige, wù ba wu gbo koo li na, na wu ta wu sanha nɔ nahamɛ yi na wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ga, a Pɔli yalɔ di we woni we kafila wu bɛɛri logo. A wu baa kari sɔrɔsii pu wo pugbɔhɔ ki ni, na shɛ yee ɲaha jo Pɔli mu. ");
INSERT INTO myk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wee tuun wu ni a Pɔli di sɔrɔsii ɲuŋɔfɔɔ wa yiri na wu pye: «Shɛ ni we lɛvɔɔ we ni sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu mu, jomɔ pa pu wa wu mu na jo wu mu.» ");
INSERT INTO myk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","A wee sɔrɔsii ɲuŋɔfɔɔ wu gari ni lɛvɔɔ wu ni sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu mu, na shɛ wu pye: «Kasolemɛɛ Pɔli wʼa nɛ yiri, na nɛ pye na nɛ wu pa ni we lɛvɔɔ we ni mu mu na jomɔ pa pu wa wu mu na jo ma mu.» ");
INSERT INTO myk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu lɛvɔɔ wu co wu keŋɛ na, na fulo ni wu ni kabanugo na, na wu yege na: «Jomɔ pekɛ pʼi wa mu mu na jo nɛ mu wɛ?» ");
INSERT INTO myk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A lɛvɔɔ wu wu pye: «Yawutuu pʼa jo na bɛ yi na na pee da ba mu ɲɛɛri ɲiga na, na mʼa Pɔli yaha shɛ kiirikɔɔn kuruŋɔ ki mu; na pʼa giin pʼi shɛ wu keree ki kemɛ suguri. ");
INSERT INTO myk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ga ma ganha bu dà yee na wɛ! Bani pu wo sipyii pii pʼa da ba lara na Pɔli sige koo na, pee ya ɲɛhɛ sipyii kɛlɛɛ shishɛɛrɛ (40) na. Pʼa bɛ yi na, na gaa Kilɛ na na pee wa da li wɛ, pee di wa da lɔhɔ gba wɛ, fo pee bu shɛ Pɔli gbo tuun wemu ni. Pʼa gbegele xɔ bɛ. Mu ɲɔ yíri pu wa wii, mu ba sɔɔ na lee pye pu mu.» ");
INSERT INTO myk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","A sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu lɛvɔɔ wu yaha kari. Ga na yi jo na waha wu mu na ye wʼa jo wee mu ge, na wu ganha bu yee jo sipya watii mu nige wɛ. ");
INSERT INTO myk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lee kadugo na a sɔrɔsii pu wo ɲuŋɔfɔgbɔ wu sɔrɔsii ɲuŋɔfɛɛ shuun wa yiri na pu pye: «Yi sɔrɔsii xhuu shuun wá puyɛ na, ni shɔnduguloo kɛlɛɛ gbarashuun, ni namaa tanmaa fɛɛ xhuu shuun. Pu bɛɛri di gbegele, piige ba wɔ na nɔ tuunɔ ɲìi gbarashɛɛrɛ na, pʼi da se Sezare kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Yi shɔngɔ ka gbegele Pɔli bɛ mu, kɔnhɔ wu nijemɛ di nɔ gbafɛnɛɛrɛɛ Felikisi na yaaga ganha bu wu ta wɛ.» ");
INSERT INTO myk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Lee kadugo na a wu sɛmɛ yàa na wee tun Felikisi mu. Wee sɛmɛ wu jomɔ pu wa mɛ: ");
INSERT INTO myk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Nɛ sɔrɔsii wo ɲuŋɔfɔgbɔ Kulodi Lisiyasi wʼa we sɛmɛ we yàa na tun na ɲuŋɔfɔɔ gbafɛnɛɛrɛɛ Felikisi mu. Nʼa ma shaari. ");
INSERT INTO myk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","«Yawutuu pu bi we ná we co, na ganha na giin pʼi wu gbo. Ba nɛ pa logo na Oromɛ shɛn wu ɲɛ wii wɛ, a nɛ na wo sɔrɔsii pii tun kari pʼa shɛ wu shɔ pu na. ");
INSERT INTO myk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kaa lemu wʼa bi pye a Yawutuu pʼi ganha na wu jaagi lee wuu na ge, nɛ funŋɔ ki bye di lee cɛ. Lee wuu na, a nɛ shɛ ni wu ni pu wo kiirikɔɔn kuruŋɔ ki mu. ");
INSERT INTO myk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ga, a nɛ ba li kasɛri, na li ta jo pu wo saliya wu wo keree na pʼa wu jaagi. Ga wu ya ta kakuunɔ la shishiin pye lemu na xu nɔ wu na, kelee na wu le kaso ni wɛ. ");
INSERT INTO myk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Lee kadugo na a pʼi ba nɛ pye na Yawutuu pʼa woni pye wu kaa na, lee wuu na nɛ mɛhɛ wu yaha shɛ ma yíri, na yi jo Yawutuu pu mu jo pʼa jaagi wu tɛri wu na kaa lemu na ge, jo pu shɛ lee jo muyɛ pyaa ki mu. Ye yʼa bye nɛ mu di jo ma mu. Kilɛ wu tuun wa shɛ wù na.» ");
INSERT INTO myk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Yemu yʼa jo sɔrɔsii pu mu ge, a pʼi lee pye; a pʼi Pɔli lɔ kee piinuŋɔ ki ni, na gari ni wu ni fo Antipatirisi kulo li ni. ");
INSERT INTO myk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ɲimuguro ti na, sɔrɔsii piimu pu bye tɔɔyɔ na ge, a pee di guri na pa pu wo pugbɔhɔ ki ni; a shɔnduguloo pʼi ganha na gaaŋi ni Pɔli ni. ");
INSERT INTO myk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ba pʼa shɛ nɔ Sezare ni wɛ, a pʼi sɛmɛ wu kan gbafɛnɛɛri wu mu, na Pɔli bɛ shɛ wu na. ");
INSERT INTO myk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","A gbafɛnɛɛri wu sɛmɛ wu kalaa na Pɔli yege na: «Fiige kekɛ ni mu dʼa yìri wɛ?» A Pɔli di wu pye na wee ya yìri Silisi fiige ki ni. ");
INSERT INTO myk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","A gbafɛnɛɛri wu wu pye: «Ma jaagivɛɛ pu ba nɔ naha tuun wemu ni, nɛ na logo ma ɲɔ na wee tuun wu ni.» A wu jo na pu Pɔli yaha saannaa Hɛrɔdi wo kaaŋa ki ni, pu da wu kasɛri. ");
INSERT INTO myk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ayiwa, a cabyaa kaguro di doro, a saraya ɲaha shɔɔnrivɛɛ wo ɲuŋɔfɔgbɔ Anaɲasi di ba Sezare kulo li ni, wu ni nɔhɔlɛɛ pʼa, ni ná wa, wemu ya kafila cɛ xuuni ge, wee wu bi da ba wu kafilacɛnɛ taga Pɔli tɔɔgɔ le. Wee mɛgɛ ki bye na Tɛritule. A pʼi ba jaagi shan Pɔli na gbafɛnɛ ɛrɛɛ Felikisi mu. ");
INSERT INTO myk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","A pʼi shɛ Pɔli yiri na pa. Keree kiimu na pʼa wu jaagi ge, a Tɛritule di kee ɲɔ kɔn na baari gbafɛn