﻿USE sofia;
DROP TABLE IF EXISTS sofia.myajvb_vpl;
CREATE TABLE myajvb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES myajvb_vpl WRITE;
INSERT INTO myajvb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","အစ အဦး၌ ဘုရားသခင် သည် ကောင်းကင် နှင့် မြေကြီး ကို ဖန်ဆင်း တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","မြေကြီး သည်အဆင်း သဏ္ဍာန်မရှိ၊ လွတ်လပ် လဟာဖြစ်၏။ နက်နဲ ရာအရပ် ကို မှောင်မိုက် ဖုံးလွှမ်း ၍ ဘုရားသခင် ၏ ဝိညာဉ် တော်သည် ရေ မျက်နှာပြင် ပေါ် မှာ လှုပ်ရှား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ဘုရား သခင်ကလည်း အလင်း ဖြစ်စေ ဟု အမိန့် တော်ရှိ၍ အလင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ထို အလင်း ကောင်း သည်ကို ဘုရား သခင်မြင် ၍ ၊ အလင်း နှင့် မှောင်မိုက် ကိုပိုင်းခြား ခွဲထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","အလင်း ကို နေ့ဟူသောအမည်ဖြင့်၎င်း ၊ မှောင်မိုက် ကို ညဉ့် ဟူသောအမည်ဖြင့်၎င်း ၊ ခေါ်ဝေါ် သမုတ် တော်မူ၍ ည ဦးနှင့် နံနက် သည် ပဌမ နေ့ရက် ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","တဖန် ဘုရားသခင် က ရေ အလယ် ၌ မိုဃ်း မျက်နှာကြက်ဖြစ် စေ၊ ရေ နှင့် ရေ ချင်း ခြားနား စေဟု အမိန့် တော်ရှိသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","မိုဃ်း မျက်နှာကြက်ကို ဘုရား သခင်ဖန်ဆင်း တော်မူ၍ ၊ မိုဃ်း မျက်နှာကြက်အောက် ၌ ရှိသောရေ နှင့်၊ မိုဃ်း မျက်နှာကြက်အပေါ် ၌ ရှိသောရေ ကို ပိုင်းခြား တော်မူသည်အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","မိုဃ်း မျက်နှာကြက်ကိုလည်း မိုဃ်းကောင်းကင် ဟူသောအမည်ဖြင့် ဘုရား သခင်ခေါ်ဝေါ် သမုတ်တော်မူ ၍ ၊ ည ဦးနှင့် နံနက် သည် ဒုတိယ နေ့ ရက်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","တဖန် ဘုရား သခင်က မိုဃ်း ကောင်းကင်အောက် ၌ ရှိသောရေ စုဝေး စေ၊ ကုန်း ပေါ် စေဟု အမိန့် တော် ရှိသည်အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ကုန်း ကိုမြေ ဟူသောအမည်ဖြင့်၎င်း၊ ရေ စုဝေး ရာကို ပင်လယ် ဟူသောအမည် ဖြင့်၎င်း ၊ ဘုရား သခင်ခေါ်ဝေါ် သမုတ်တော်မူ၍ ထို အမှုအရာကောင်း သည်ကို ဘုရား သခင်မြင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","တဖန် ဘုရား သခင်က၊ မြေ သည် မြက် ပင်ကို၎င်း၊ စပါး သီးကို ဖြစ်စေသော စပါး ပင် ကို၎င်း၊ မြေ ပေါ် မှာ မျိုးစေ့ ပါလျက် သစ်သီး မျိုးကို ဖြစ် စေသော သစ်ပင်ကို၎င်း၊ ပေါက် စေဟု အမိန့် တော်ရှိသည် အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","မြေ သည်မြက် ပင်ကို၎င်း စပါး သီးမျိုးကို ဖြစ်စေသော စပါး ပင်ကို၎င်း၊ မိမိ ၌ မျိုးစေ့ ပါလျက် သစ်သီး မျိုး ကို ဖြစ်စေ သော သစ်ပင် ကို၎င်း ပေါက် စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ထို အမှုအရာကောင်း သည်ကို ဘုရား သခင်မြင် တော်မူ၍ ၊ ည ဦးနှင့် နံနက် သည် တတိယ နေ့ရက် ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","တဖန် ဘုရား သခင်က၊ နေ့ နှင့် ညဉ့် ကို ပိုင်းခြား စေခြင်းငှါ မိုဃ်းကောင်းကင် မျက်နှာကြက် ၌ အလင်း အိမ် တည် စေ၊ နိမိတ် လက္ခဏာ၊ ချိန်းချက် သောအချိန်၊ နေ့ ရက်အပိုင်းအခြား၊ နှစ် အပိုင်းအခြားဘို့ ဖြစ် စေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","မိုဃ်းကောင်းကင် မျက်နှာကြက် ၌ တည်၍ မြေကြီး လင်း စရာ အလင်း အိမ်ဖြစ် စေဟု အမိန့်တော်ရှိ သည့်အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ထိုသို့ ဘုရား သခင်သည် အလင်း အိမ်ကြီး နှစ် လုံးတည်းဟူသောနေ့ ကိုအုပ်စိုး ရသောအကြီး တလုံး၊ ညဉ့် ကို အုပ်စိုး ရသောအငယ် တလုံးနှင့်တကွ ကြယ် များတို့ကို ဖန်ဆင်း တော်မူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","မြေကြီး ၌ လင်း စေခြင်းငှာ၎င်း၊ နေ့ နှင့် ညဉ့် ကို အုပ်စိုး ၍ အလင်း နှင့် မှောင်မိုက် ကို ပိုင်းခြား စေခြင်းငှာ၎င်း ၊ မိုဃ်းကောင်းကင် မျက်နှာကြက် ၌ ဘုရား သခင်ထား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ထို အမှုအရာ ကောင်း သည်ကို ဘုရား သခင် မြင် တော်မူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ည ဦးနှင့် နံနက် သည် စတုတ္ထ နေ့ ရက်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","တဖန် ဘုရား သခင်က အသက် ရှင်၍ လှုပ်ရှားတတ်သော တိရစ္ဆာန် တို့ကို ရေ သည်များပြား စွာ မွေးဘွားစေ။ ငှက် တို့လည်း မြေ ပေါ် မိုဃ်းကောင်းကင် မျက်နှာကြက် ပြင် ဝယ်ပျံ စေဟု အမိန့်တော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ထိုသို့လျှင် ရေသည် တိရစ္ဆာန်အမျိုး အလိုက် များပြား စွာ မွေးဘွား၍၊ ငါးကြီး အစ ရှိသော အသက်ရှင် ၍ လှုပ်ရှား တတ်သော တိရစ္ဆာန် အပေါင်း တို့ကို၎င်း၊ ပျံ တတ်သော ငှက် မျိုးအပေါင်း တို့ကို၎င်း ဘုရား သခင်ဖန်ဆင်း ၍၊ ထို အမူအရာကောင်း သည်ကို မြင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ဘုရား သခင်ကလည်း များပြား စွာ မွေးဘွား ကြလော့။ ပင်လယ် ရေ များကို ပြည့် စေကြလော့။ ငှက် တို့ လည်း မြေ ပေါ်၌ များပြား စေသတည်းဟု ထို တိရစ္ဆာန်တို့ကို ကောင်းကြီး ပေးတော်မူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ည ဦးနှင့် နံနက် သည် ပဉ္စမ နေ့ ရက်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","တဖန် ဘုရား သခင်က၊ မြေ သည် အသက်ရှင် သောသတ္တဝါ မျိုးတည်းဟူသောသားယဉ်တို့ကို၎င်း၊ တွား တတ်သော တိရစ္ဆာန် တို့ကို၎င်း ၊ သားရဲ မျိုး တို့ကို၎င်း ၊ မွေးဘွား စေဟုအမိန့် တော်ရှိသည်အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ထို သို့ ဘုရား သခင်သည် သားရဲ မျိုး၊ သားယဉ်မျိုး၊ မြေ ပေါ်မှာ တွား တတ်သော တိရစ္ဆာန် မျိုး အပေါင်းတို့ကို ဖန်ဆင်း ၍ ၊ ထို အမှုအရာကောင်း သည်ကို မြင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","တဖန် ဘုရား သခင်က ငါ တို့ပုံသဏ္ဍာန်နှင့်အညီတသဏ္ဍန်တည်း လူ ကို ဖန်ဆင်း ကြစို့။ သူသည် ပင်လယ် ငါး တို့ကို၎င်း ၊ မိုဃ်းကောင်းကင် ငှက် တို့ကို၎င်း ၊ သား ယဉ်တို့ကို၎င်း ၊ မြေ တပြင်လုံး နှင့်တကွ၊ မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန် အပေါင်း တို့ကို၎င်း ၊ အုပ်စိုး စေဟု အမိန့်တော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ထိုသို့ ဘုရား သခင်သည် မိမိ ပုံသဏ္ဍန် နှင့်အညီ လူ ကိုဖန်ဆင်း တော်မူ၏။ ဘုရား သခင်၏ ပုံ သဏ္ဍာန် တော်နှင့်အညီ လူယောက်ျား ၊ လူမိန်းမ ကိုဖန်ဆင်း ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","အချင်းတို့ များပြား စွာမွေးဘွား ကြလော့။ မြေကြီး ကို ပြည့် စေ၍ နိုင် ကြလော့။ ပင်လယ် ငါး တို့ကို၎င်း၊ မိုဃ်းကောင်းကင် ငှက် တို့ကို၎င်း၊ အသက် ရှင်၍ မြေ ပေါ် မှာ လှုပ်ရှား တတ်သော တိရစ္ဆာန်အပေါင်း တို့ကို၎င်းအုပ်စိုး ကြလော့ဟုမိန့် တော်မူ၍ ၊ သူ တို့ကိုကောင်းကြီး ပေးတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ဘုရား သခင်ကလည်း ကြည့်ရှု လော့။ မြေ တပြင်လုံး ၌ စပါး သီးကို ဖြစ်စေသော စပါး ပင် အမျိုးမျိုး တို့ကို၎င်း၊ မျိုးစေ့ ကိုဖြစ်စေသော အသီး နှင့်ပြည့်စုံသော သစ်ပင် အမျိုးမျိုး တို့ကို၎င်း၊ သင် တို့စားစရာ ဘို့ ငါပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","မြေ သား၊ မိုဃ်းကောင်းကင် ငှက် ၊ အသက် ရှင်၍ မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန်မျိုးအပေါင်း တို့ စားစရာ ဘို့ ၊ မြက် ပင် အမျိုးမျိုး တို့ကို ငါပေးမည်ဟု မိန့်တော်မူသည်အတိုင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ဘုရား သခင်သည် မိမိဖန်ဆင်း သမျှ သောအရာတို့ကို ကြည့်ရှု လျှင် ၊ အလွန် ကောင်း သည်ကို မြင် တော်မူ၍ ၊ ည ဦးနှင့် နံနက် သည် ဆဌမ နေ့ ရက်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ထိုသို့ ကောင်းကင် မြေကြီး နှင့်တကွ ခပ်သိမ်း သော တန်ဆာ တို့သည် ပြီးစီး လျက်ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","သတ္တမ နေ့ ရက်ရောက်လျှင်၊ ဘုရား သခင်သည် ဖန်ဆင်း သောအမှု ကို လက်စသတ် တော်မူခဲ့ပြီးသည် ဖြစ်၍ ၊ ဖန်ဆင်း သမျှ သောအမူ အရာတို့သည် ပြီးစီးပြီးမှ၊ ထို သတ္တမ နေ့ ၌ ငြိမ်ဝပ် စွာနေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ထို သတ္တမ နေ့ ကို ဘုရား သခင်သည် ကောင်းကြီး ပေး၍ သန့်ရှင်း စေတော်မူ၏။ အကြောင်းမူကား ၊ ဖန်ဆင်း ပြုပြင်တော်မူသောထိုအမှု အရာအလုံးစုံ တို့သည် ပြီးစီးသောကြောင့်ထိုနေ့ရက်၌ ငြိမ်ဝပ် စွာနေ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ဤ အကြောင်းအရာကား၊ ထာဝရ အရှင်ဘုရား သခင်သည် ကောင်းကင် နှင့် မြေကြီး ကို ဖန်ဆင်း တော်မူသောနေ့ ၊ ဖန်ဆင်း ရာကာလ ၌ ကောင်းကင် နှင့် မြေကြီး ၏ မူလ အတ္ထုပတ္တိပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","မြေ ၌ လယ် ယာပျိုး ပင်မ ပေါက်မှီ၊ လယ် ယာ၌ စပါးပင်မ ကြီးပွားမှီ၊ အပင် ရှိ သမျှတို့ကိုဖန်ဆင်း တော်မူ၏။ ထိုအခါ ထာဝရ အရှင်ဘုရား သခင်သည် မြေ ပေါ် ၌ မိုဃ်းကိုရွာ စေတော်မ မူသေး။ မြေ ၌လုပ် သော လူ လည်း မ ရှိသေးသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","မြေ မှ အခိုး အငွေ့ထွက် သဖြင့် မြေ တပြင်လုံးကို စို စေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ထိုနောက် ၊ ထာဝရ အရှင်ဘုရား သခင်သည် မြေ မှုန့်ဖြင့် လူ ကို ဖန်ဆင်း ၍၊ သူ ၏နှာခေါင်း ထဲသို့ ဇီဝ အသက် ကို မှုတ် တော်မူလျှင် ၊ လူ သည် အသက်ရှင် သော သတ္တဝါ ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ထာဝရ အရှင် ဘုရား သခင်သည်လည်း အရှေ့ မျက်နှာ၊ ဧဒင် အရပ်၌ ဥယျာဉ် ကို စိုက်ပျိုး ပြီးလျှင်၊ ဖန်ဆင်း တော်မူသောလူ ကို ထို ဥယျာဉ်၌ နေရာ ချတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ထို မြေ ထဲက အဆင်း လှ၍၊ စားဘွယ် ကောင်း သော အပင် အမျိုးမျိုး ကို ထာဝရ အရှင်ဘုရား သခင်ပေါက် စေတော်မူ၏။ ထိုဥယျာဉ် အလယ် ၌ အသက် ပင် လည်း ရှိ၏။ ကောင်း မ ကောင်းကို သိကျွမ်း ရာအပင် လည်း ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ထို ဥယျာဉ်ကို စို စေလိုသော ငှာ မြစ် တမြစ်သည် ဧဒင် အရပ်ထဲက စီးထွက် သဖြင့် ၊ ဥယျာဉ် ပြင်မှာ လေးဖြာကွဲ ၍ မြစ်မ လေး သွယ်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ပဌမ မြစ်ကား ဖိရုန် အမည် ရှိ၏။ ထို မြစ်သည် ရွှေ ရှိသော ဟာဝိလ ပြည် နား တရှောက်လုံး ကို စီးသွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ထို ပြည် မှဖြစ်သောရွှေ သည် ကောင်း လှ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ဗဓေလသစ်စေး နှင့် ရှဟံ ကျောက် လည်းရှိ၏။ ဒုတိယ မြစ်ကား ဂိဟုန် အမည် ရှိ၏။ ထိုမြစ် သည် ကုရှ ပြည် နား တရှောက်လုံး ကို စီးသွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","တတိယ မြစ် ကား ဟိဒကေလ အမည် ရှိ၏။ ထို မြစ်သည် အာရှုရိ တိုင်း အရှေ့ သို့ စီးသွား လေ၏။ စတုတ္ထ မြစ် ကား ဥဖရတ် အမည်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ထိုအခါ ထာဝရ အရှင်ဘုရား သခင်သည် လူ ကိုယူ ၍ ဧဒင် ဥယျာဉ် ကို ပြုစုစောင့်ရှောက် စေခြင်းငှါထား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ထာဝရ အရှင်ဘုရား သခင်ကလည်း ၊ ကောင်း မ ကောင်းကို သိကျွမ်း ရာအပင်မှတပါး၊ ထိုဥယျာဉ် ၌ ရှိသမျှ သော အပင် တို့၏အသီးကို သင်သည် စား ရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ထို အပင် ၏ အသီးကိုကား မ စား ရ။ စား သောနေ့ တွင် ဧကန်အမှန်သေ ရမည်ဟု လူ ကို ပညတ် ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ထာဝရ အရှင်ဘုရား သခင်ကလည်း ၊ ယောက်ျား သည် တ ယောက်တည်းမ နေ ကောင်း ၊ သူ နှင့်တော် သော အထောက် အမကို သူ ဘို့ ငါလုပ် ဦးမည်ဟု အကြံ ရှိတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ထာဝရ အရှင်ဘုရား သခင်သည် မြေ တိရစ္ဆာန် တို့နှင့်၊ မိုဃ်းကောင်းကင် ငှက် အပေါင်း တို့ကို မြေ ဖြင့်ဖန်ဆင်း တော်မူပြီးလျှင်၊ လူသည် အဘယ်သို့ ခေါ်ဝေါ် သမုတ်မည်ကို သိ ခြင်းငှာ ၊ လူ ရှိရာသို့ ဆောင် ခဲ့တော်မူ၏။ လူ သည် လည်း အသက်ရှင် သော သတ္တဝါ အပေါင်း တို့ကို ခေါ်ဝေါ် သမုတ်သည့်အတိုင်း ၊ နာမည် အသီးအသီးရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ထိုသို့ လူ သည် သားယဉ် အပေါင်း တို့ကို ၎င်း ၊ မိုဃ်းကောင်းကင် ငှက် အပေါင်းတို့ကို ၎င်း ၊ သားရဲ အပေါင်း တို့ကို ၎င်း၊ အမည်ပေး ၍မှည့်လေ၏။ သို့သော်လည်း လူ နှင့် တော် သော အထောက် အမ မ ပေါ် မရှိသေး၊ ");
INSERT INTO myajvb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ထိုအခါ ထာဝရ အရှင်ဘုရား သခင်သည် လူ ကို ကြီး သောအိပ်ခြင်းဖြင့် အိပ်စေတော်မူ၍၊ လူ သည် အိပ်ပျော် စဉ် ၊ နံရိုး တ ချောင်းကို ဘုရားသခင်ထုတ် ပြီးလျှင်၊ ထို အရိုးအစား အသား ကို စေ့စပ် စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ထာဝရ အရှင်ဘုရား သခင်သည် လူ ထဲက ထုတ် သော နံရိုး ဖြင့် လူမိန်းမ ကိုဖန်ဆင်း၍ လူ ရှိရာသို့ ဆောင် ခဲ့ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","လူ ကလည်း ၊ ယခု ဤ သူသည်ငါ့ အရိုး ထဲက အရိုး ၊ ငါ့ အသား ထဲက အသား ဖြစ်၏။ လူ ထဲက ထုတ် သောကြောင့် သူ့ ကိုလူမိန်းမ ဟု ခေါ်ဝေါ် အပ်သည်ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ထို အကြောင်းကြောင့် ယောက်ျား သည် ကိုယ် မိဘ ကို စွန့် ၍ ၊ ကိုယ့် ခင်ပွန်း ၌မှီဝဲ သဖြင့် ၊ ထိုသူတို့သည် တသား တကိုယ်တည်း ဖြစ် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ထို သူလင်မယား နှစ် ဦးတို့သည် အဝတ် မဝတ်ဘဲ နေ၍၊ ရှက်ကြောက် ခြင်းနှင့် ကင်းလွတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","မြွေ သည် ထာဝရ အရှင်ဘုရား သခင် ဖန်ဆင်း တော်မူ သောမြေ တိရစ္ဆာန် တကာ တို့ထက် လိမ္မာ သည် ဖြစ် ၍ ၊ မိန်းမ အား သင်တို့သည် ဥယျာဉ် ၌ ရှိသမျှ သောအပင် တို့၏ အသီးကိုမ စား ရဟု ဧကန် စင်စစ် ဘုရား သခင် မိန့် တော်မူသလောဟု မေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","မိန်းမ ကလည်း ၊ ငါတို့သည် ဥယျာဉ် ရှိ သောအပင် တို့၏ အသီး ကိုစား ရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ဥယျာဉ် အလယ် ၌ ရှိသောအပင် ၏အသီး ကိုကား၊ သင်တို့သည် မ ကိုင် မ စား ပဲ နေကြလော့၊ သို့မဟုတ် သေ မည်ဟု ဘုရား သခင်အမိန့် တော်ရှိသည်ဟု မြွေ အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","မြွေ ကလည်း သင်တို့သည် ဧကန်အမှန်သေ ရမည်မ ဟုတ်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","အကြောင်းမူကား ၊ ထို အသီးကိုစား သောနေ့ ၌ သင်တို့ သည် မျက်စိ ပွင့် လင်းလျက် ကောင်း မကောင်း ကို သိ ၍ ၊ ဘုရား သခင်ကဲ့သို့ ဖြစ် ကြ လတံ့သည်ကို၊ ဘုရား သခင်သိ တော်မူသည်ဟု မိန်းမ အားဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ထို အပင် သည် စားဘွယ် ကောင်း ခြင်း၊ အဆင်း လည်း လှခြင်း၊ ပညာ တိုးပွားစေလိုသောငှါ ၊ နှစ်သက် ဖွယ်သော အပင် ဖြစ်ခြင်းကို မိန်းမ သည် မြင်လျှင် ၊ အသီး ကို ယူ ၍ စား ၏။ မိမိ ခင်ပွန်း အား လည်း ပေး ၍ သူ သည်လည်း စား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ထိုသူနှစ် ယောက်တို့သည် မျက်စိ ပွင့် လင်း၍ မိမိ တို့၌ အဝတ် အချည်းစည်းရှိသည်ကို သိ မြင်လျှင် ၊ မိမိ တို့ ဝတ် ရန်ဖို့ သင်္ဘော သဖန်းပင်အရွက် တို့ကို ချုပ် စပ်၍ ခါးစည်းကိုလုပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","နေဧသောအချိန် တွင် ၊ ထိုဥယျာဉ် ၌ ထာဝရ အရှင်ဘုရား သခင်ကြွ တော်မူသောအသံ ကို လုလင်မယားတို့သည် ကြား လျှင် ၊ အထံတော်မှ လွတ်ခြင်းငှါ၊ ဥယျာဉ် အပင် တို့တွင် ပုန်း ကွယ်လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ထာဝရ အရှင် ဘုရား သခင်ကလည်း ၊ သင် သည် အဘယ် မှာရှိသနည်းဟု၊ လူ ကိုခေါ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","လူကလည်း ဥယျာဉ် ၌ ကိုယ်တော် ၏ အသံ ကို ကျွန်တော်ကြား လျှင်၊ အဝတ် အချည်းစည်းရှိသောကြောင့် ၊ ကြောက် ၍ ပုန်း လျက် နေပါသည်ဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ဘုရားသခင်ကလည်း၊ သင် ၌ အဝတ် အချည်းစည်းရှိသည်ကို သင် အား အဘယ်သူ ပြော သနည်း။ မ စား ရဟု ငါပညတ် သော အပင် ၏အသီးကို စား ပြီလောဟု မေး တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","လူ ကလည်း ကျွန်တော် ၌ အပ်ပေး တော်မူသောမိန်းမ သည် ထိုအပင် ၏အသီးကိုပေး ၍ ကျွန်တော်စား မိပါသည်ဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ထာဝရ အရှင်ဘုရား သခင်ကလည်း ၊ သင်သည် အဘယ်သို့ ပြု ပြီးသနည်းဟု မိန်းမအားမေး တော်မူလျှင် ၊ မိန်းမ က မြွေ သည် ကျွန်တော်မ ကို လှည့်စား ၍ ၊ ကျွန်တော်မသည်စား မိပါပြီဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ထာဝရ အရှင်ဘုရား သခင်သည် မြွေ ကိုခေါ် ၍ သင်သည် ဤ အမှုကို ပြု သောကြောင့် သားယဉ် သားရဲ အပေါင်း တို့ထက် ကျိန် ခြင်းကို ခံရ၏။ သင် သည် ဝမ်း ဖြင့် သွား ၍ မြေမှုန့် ကို တသက်လုံး စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","သင် နှင့် မိန်းမ ကို၎င်း ၊ သင် ၏အမျိုးအနွယ် နှင့် မိန်းမ ၏ အမျိုးအနွယ် ကို၎င်း ၊ ငါသည်ရန်ငြိုး ဖွဲ့ စေမည်။ သူသည် သင် ၏ခေါင်း ကို ကြိတ် လိမ့်မည်၊ သင်သည် သူ ၏ဖနောင့် ကို ကြိတ် လိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","မိန်းမ ကို လည်း၊ သင် ၌ ကိုယ်ဝန်ဆောင် ခြင်း ဝေဒနာ ကို ငါအလွန် များပြား စေရမည်။ ပင်ပန်းစွာ ဝေဒနာ ကို ခံ ၍ သား ဘွား ရမည်။ ကိုယ် ခင်ပွန်း ၏ အလို သို့ လိုက်၍ သူ ၏အုပ်စိုး ခြင်းကိုလည်း ခံရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ယောက်ျား ကို လည်း ၊ ထို အပင်၏အသီးကို မ စား ရဟု ငါပညတ် သော်လည်း၊ သင်သည်မယား ၏ စကား ကို နားထောင် ၍ စား မိသောကြောင့် ၊ မြေ သည် သင် ၏အတွက် ကျိန် ခြင်းကိုခံ လျက်ရှိ၏။ မြေ၏အသီးကို တသက် ပတ်လုံးပင်ပန်း စွာ စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ဆူး ပင်အမျိုးမျိုးတို့ကိုလည်း သင် အဖို့ မြေပေါက် စေမည်။ လယ် ၌ ဖြစ်သော ဟင်းသီးဟင်းရွက် တို့ကို သင် စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","သင် ထွက် ရာမြေ သို့ မပြန် မှီတိုင်အောင် ၊ သင် ၏ မျက်နှာ မှချွေး ထွက်လျက် အစာ ကိုစား ရမည်။ အကြောင်းမူကား ၊ သင် သည် မြေမှုန့် ဖြစ်၍မြေမှုန့် သို့ ပြန် ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ထိုအခါ လူ သည် မိမိ မယား ကို ဧဝ အမည် ဖြင့် မှည့် လေ၏။ အကြောင်းမူကား ၊ သူ သည် အသက်ရှင် သော သူအပေါင်း တို့၏ အမိ ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ထာဝရ အရှင် ဘုရား သခင်သည်လည်း လူ လင်မယား တို့ သားရေ ဖြင့် ဝတ်လုံ ကိုလုပ် ၍ ဝတ် ခြုံစေတော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ထာဝရ အရှင်ဘုရား သခင်ကလည်း ၊ လူ သည် ငါ တို့တွင် တပါးပါး ကဲ့သို့ ဖြစ် ၍၊ ကောင်း မကောင်း သိ တတ်၏။ ယခု မှာ သူသည် ထာဝရ အသက် ကို ရခြင်းငှါ၊ လက် ကိုဆန့် လျက် အသက် ပင် ၏အသီးကို ယူ ၍ မ စား သင့်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","လူ သည် မိမိထွက် သော မြေ ၌ လုပ် ရမည်အကြောင်း ၊ ထာဝရ အရှင်ဘုရား သခင်သည် ဧဒင် ဥယျာဉ် ထဲက လွှတ် လိုက်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ထိုသို့ လူ ကို နှင်ထုတ် ပြီးလျှင်၊ အသက် ပင် လမ်း ကို စောင့်ရှောက် စေခြင်းငှါ ၊ မီး စင်လက်နက်နှင့်တကွ ခေရုဗိမ် တို့ကို ဥယျာဉ် အရှေ့ ဘက်၌ ထား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ထိုနောက်၊ လူ အာဒံသည် မယား ဧဝ နှင့်ဆက်ဆံ သဖြင့် ၊ ဧဝသည် ပဋိသန္ဓေ စွဲယူ၍ ၊ ကာဣန ကို ဘွားမြင် လျှင် ၊ ထာဝရ ဘုရား၏ လူ ကို ငါရ ပြီဟုဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","တဖန် သူ့ ညီ အာဗေလ ကို ဘွားမြင် လေ၏။ အာဗေလ ကား သိုး ထိန်း ဖြစ် ၏။ ကာဣန ကားလယ် လုပ် သောသူဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","အချိန် စေ့ သောအခါ ၊ ကာဣန သည် ထာဝရဘုရား ထံ ပူဇော်သက္ကာ ဘို့၊ မြေ အသီး ကို ဆောင် ခဲ့၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","အာဗေလ သည်လည်း မိမိ သိုး စုတွင် အဦး ဘွားသော သားအချို့နှင့်၊ သိုး ဆီ ဥကိုဆောင် ခဲ့၏။ ထာဝရဘုရား သည် အာဗေလ နှင့် သူ ၏ပူဇော်သက္ကာ ကို ပမာဏ ပြုတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ကာဣန နှင့် သူ ၏ ပူဇော်သက္ကာ ကို ပမာဏ ပြုတော်မ မူ၊ ထိုကြောင့် ကာဣန သည် အလွန် စိတ်ဆိုး ၍ မျက်နှာ ပျက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ထာဝရဘုရား ကလည်း သင် သည် အဘယ်ကြောင့် စိတ်ဆိုး သနည်း။ အဘယ်ကြောင့် မျက်နှာ ပျက် သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","သင်သည် ကောင်းမွန် စွာ ပြုလုပ်အခွင့် မ ရလော။ ကောင်းမွန် စွာ မ ပြုလျှင် ၊ အပြစ် ဖြေသော ယဇ်ကောင် သည်တံခါး နား မှာ ဝပ် လျက်ရှိ၏။ သူ သည် သင် ၏ အလို သို့လိုက်၍၊ သင် သည် သူ့ ကို အုပ်စိုး ရ၏ဟု ကာဣန ကို မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ကာဣန ကလည်း လယ်သို့ သွားကြကုန်အံ့ဟု ညီ အာဗေလ ကို ခေါ် ၍ ၊ လယ် သို့ ရောက်သောအခါ၊ ညီ အာဗေလ ကိုရန် ဘက်ပြု၍ သတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ထာဝရဘုရား ကလည်း သင့် ညီ အာဗေလ သည် အဘယ်မှာ ရှိသနည်းဟု ကာဣန ကို မေး တော်မူလျှင် အကျွန်ုပ်မ သိ ပါ။ အကျွန်ုပ် သည် ညီ ကို စောင့် ရသောသူ ဖြစ် ပါသလောဟု လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ဘုရားသခင်ကလည်း၊ သင်သည် အဘယ်သို့ ပြု ပြီးသနည်း။ သင် ညီ အသွေး ၏အသံ သည် မြေ ထဲက ငါ့ ကို အော်ဟစ် လျက်ရှိသည်တကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","သို့ဖြစ်၍ သင့် ညီ ၏ အသွေး ကိုခံယူ ခြင်းငှါ ၊ မိမိ ပစပ် ကိုဖွင့် သော မြေကြီး ၏ ကျိန် ခြင်းကို သင် သည် ခံရသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ယခုမှစ၍မြေ ၌လုပ် သောအခါ ပကတိ အတိုင်း အသီးအနှံ ကို မ ရရ။ မြေကြီး ပေါ် မှ ပြေးရသောသူ၊ အရပ်ရပ်လည် ရသောသူဖြစ် ရလိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ကာဣန ကလည်း အကျွန်ုပ် အပြစ် သည် မဖြေ နိုင်အောင် ကြီး ပါသလော။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","အကျွန်ုပ် ကို မြေကြီး ပြင် မှယနေ့ နှင်ထုတ် တော်မူပြီ၊ မျက်နှာ တော်ကိုလည်း မမြင် ရ။ မြေကြီး ပေါ် မှာ ပြေးရသောသူ၊ အရပ်ရပ်လည်ရသောသူဖြစ် ပါရမည်။ တွေ့ သမျှ သောသူတို့ သည် အကျွန်ုပ် ကိုသတ် ပါလိမ့်မည် ဟု ထာဝရဘုရား ကို လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ထာဝရဘုရား ကလည်း သို့ဖြစ်၍ ကာဣန ကို သတ် သောသူမည်သည်ကား၊ ခုနစ် ဆသောအပြစ် ဒဏ်ကိုခံ ရလိမ့်မည်ဟု မိန့် တော်မူပြီးလျှင်၊ ကာဣန ကိုတွေ့ သောသူ တစုံတယောက် မျှ မ သတ် စေခြင်းငှါ၊ ထာဝရဘုရား သည် သူ ၌ အမှတ် ပေး တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ကာဣန သည် ထာဝရဘုရား ထံ တော်မှ ထွက်သွား ၍ ၊ ဧဒင် ပြည် အရှေ့ ၊ နောဒ ပြည် တွင် နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ထိုအခါ ကာဣန သည် မိမိ မယား နှင့် ဆက်ဆံ သဖြင့်၊ သူ သည် ပဋိသန္ဓေစွဲယူ၍ ၊ သားဧနောက် ကို ဘွားမြင် လေ၏။ ကာဣန သည်လည်း မြို့ ကိုတည် ၍ မိမိ သား ၏ အမည် အလိုက် ၊ ထိုမြို့ ကို ဧနောက် မြို့ဟု သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ဧနောက် သားကား၊ ဣရဒ် ၊ ဣရဒ် သားကား၊ မဟုယေလ ၊ မဟုယေလ သားကား၊ မသုရှလ ၊ မသုရှလ သားကား၊ လာမက် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","လာမက် သည်၊ အာဒ နှင့် ဇိလ အမည် ရှိသောမိန်းမ နှစ် ယောက်နှင့် အိမ်ထောင် ဘက်ပြု၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","အာဒံ သည် သားယာဗလ ကိုဘွား မြင်လေ၏။ ထိုသားကား၊ တဲ ၌နေ သောသူ ၊ သိုး နွားစသည်တို့ကို မွေးသောသူတို့ ၏ အဘ ဆရာ ဖြစ် လေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ယုဗလ အမည် ရှိသောညီ မူကား၊ စောင်း မျိုး၊ နှဲခရာ မျိုးတို့ကို တီးမှုတ် တတ်သောသူ အပေါင်း တို့၏ အဘ ဆရာဖြစ် လေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ဇိလ သည်လည်း ၊ သားတုဗလကာဣန ကို ဘွားမြင် လေ၏။ သူသည် ပန်းတဉ်း သမား၊ ပန်းပဲ သမား အပေါင်း တို့၏ဆရာ ဖြစ်လေ၏။ တုဗလကာဣန ၏နှမ ကား၊ နေမ အမည်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","လာမက် ကလည်း အာဒံ နှင့် ဇိလ ၊ ငါ ပြော သံကို မှတ် ကြလော့။ လာမက် မယား တို့၊ ငါ့ စကား ကို နားထောင် ကြလော့။ ငါ့ ကိုထိခိုက် သော လူ တယောက်တည်းဟူသော ၊ ငါ့ ကိုညှဉ်းဆဲ သောလူပျို တယောက်ကို ငါသတ် ခဲ့ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ကာဣန သည် ခုနစ် ဆသောတရား ကိုရလျှင်၊ အကယ်၍ လာမက် သည်၊ အဆခုနှစ် ဆယ် ခုနစ် ဆသော တရားကို ရလိမ့်မည်ဟု မိမိမယားတို့ကိုပြောဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","အာဒံ သည်လည်း မိမိ မယား နှင့် တဖန် ဆက်ဆံ ပြန်လျှင်၊ မယားသည် သား ကို ဘွားမြင် ၍ ရှေသ ဟူသောအမည် ဖြင့် မှည့် လေ၏။ အကြောင်းမူကား ၊ ကာဣန သတ် သော အာဗေလ ကိုယ်စား တပါး သောအနွယ် ကို အကျွန်ုပ် အဘို့ ဘုရား သခင်၌ ခန့်ထားတော်မူပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ရှေသ သည်လည်း သား ကိုရ ၍ ဧနုတ် ဟူသောအမည် ဖြင့် မှည့် လေ၏။ ထိုကာလ၌ ထာဝရဘုရား ၏ နာမတော် ကို အမှီပြု၍ ကိုးကွယ်စ ပြုကြလေ၏၊ ");
INSERT INTO myajvb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","အာဒံ ၏သားစဉ်မြေးစက် စာရင်း ဟူမူကား၊ လူ ကို ဖန်ဆင်း တော်မူသောကာလ ၌ ၊ မိမိ ပုံသဏ္ဍာန် နှင့်အညီ၊ ဘုရား သခင်ဖန်ဆင်း တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","လူယောက်ျား လူမိန်းမ ကို ဖန်ဆင်း ၍ ၊ ကောင်းကြီး ပေးတော်မူ၏။ ဖန်ဆင်း သောနေ့ ၌ လည်း သူ တို့ကို အာဒံ အမည် ဖြင့် မှည့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","အာဒံ သည် အသက် တရာ့ သုံး ဆယ်ရှိသော်၊ မိမိ ပုံသဏ္ဍာန် နှင့်အညီသဏ္ဍာန် တည်းသားကိုမြင် ရ၍ ရှေသ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ရှေသ ကို ဘွားမြင် သောနောက် အာဒံ သည် အနှစ် ရှစ် ရာ အသက်ရှင်၍၊ သား သမီး များကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","အာဒံ သည် အသက် နှစ် ပေါင်း ကိုး ရာ သုံး ဆယ် စေ့သော် သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ရှေသ သည် အသက် တရာ ငါး နှစ် ရှိသော်၊ သားဧနုတ် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ဧနုတ် ဘွားမြင် သောနောက် ၊ ရှေသ သည် အနှစ် ရှစ် ရာ ခုနှစ် နှစ် အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ရှေလ သည် အသက် နှစ် ပေါင်းကိုး ရာ တဆယ် နှစ် နှစ် စေ့သော် သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ဧနုတ် သည် အသက် ကိုး ဆယ်ရှိသော်၊ သား ကာဣနန် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ကာဣနန် ဘွားမြင် သောနောက် ၊ ဧနုတ် သည် အနှစ် ရှစ် ရာ တဆယ် ငါး နှစ် အသက် ရှင်၍ သား သမီး များ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ဧနုတ် သည် အသက် နှစ် ပေါင်းကိုး ရာ ငါး နှစ် စေ့ သော်သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ကာဣနန် သည် အသက် ခုနစ် ဆယ်ရှိသော်၊ သားမဟာလေလ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","မဟာလေလ ဘွား မြင်သောနောက် ၊ ကာဣနန် သည် အနှစ် ရှစ် ရာ လေး ဆယ်အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ကာဣနန် သည် အသက် နှစ် ပေါင်းကိုး ရာ တဆယ့် စေ့ သော် သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","မဟာလေလ သည် အသက် ခြောက် ဆယ့်ငါး နှစ် ရှိသော် ၊ သားယာရက် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ယာရက် ဘွားမြင် သောနောက် မဟာလေလ သည် အနှစ် ရှစ် ရာ သုံး ဆယ်အသက် ရှင်၍ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","မဟာလေလ သည် အသက် နှစ် ပေါင်းရှစ် ရာ ကိုး ဆယ့်ငါး နှစ် စေ့ သော် သေ လေ၏၊ ");
INSERT INTO myajvb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ယာရက် သည် အသက် တ ရာခြောက် ဆယ်နှစ် နှစ် ရှိသော်သားဧနောက် ကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ဧနောက် ဘွားမြင် သောနောက် ယာရက် သည် အနှစ် ရှစ် ရာ အသက် ရှင်၍ ၊ သား သမီး များကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ယာရက် သည် အသက် နှစ် ပေါင်းကိုး ရာ ခြောက်ဆယ် နှစ် နှစ် စေ့ သော် သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ဧနောက် သည် အသက်ခြောက်ဆယ် ငါး နှစ် ရှိသော်သားမသုရှလ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","မသုရှလ ဘွားမြင် သောနောက် ဧနောက် သည် အနှစ် သုံး ရာ ပတ်လုံးဘုရား သခင်နှင့်အတူ သွား လာ၍ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ဧနောက် အသက် နှစ် ပေါင်းသုံး ရာ ခြောက် ဆယ်ငါး နှစ် တည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ဧနောက် သည် ဘုရား သခင်နှင့်အတူ သွား လာ၏။ နောက် တဖန် သူ သည်မ ရှိ အကြောင်းမူကား ၊ ဘုရား သခင် သိမ်းယူ တော်မူသောကြောင့် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","မသုရှလ သည် အသက် တရာ့ ရှစ် ဆယ်ခုနစ် နှစ် ရှိသော်၊ သား လာမက် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","လာမက် ဘွားမြင် သောနောက် ၊ မသုရှလ သည် အနှစ် ခုနှစ် ရာ ရှစ် ဆယ်နှစ် နှစ် အသက် ရှင်၍ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","မသုရှလ သည် အသက် နှစ် ပေါင်းကိုး ရာ ခြောက် ဆယ် ကိုး နှစ် စေ့ သော် သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","လာမက် သည် အသက် တ ရာရှစ် ဆယ်နှစ် နှစ် ရှိသော်သား ကို မြင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ဤ သူသည်ကား၊ ထာဝရဘုရား ကျိန် တော်မူသောမြေ ၌ လုပ် ၍ ပင်ပန်း စွာ ခံရသောငါ တို့အား သက်သာ စေသောသူဖြစ်လိမ့်မည်ဟူ၍ သူ့ကိုနောဧ ဟူသောအမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","နောဧ ဘွားမြင် သောနောက် ၊ လာမက် သည် အနှစ် ငါး ရာ ကိုး ဆယ်ငါး နှစ် အသက် ရှင်၍ သား သမီး များ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","လာမက် သည် အသက် နှစ် ပေါင်း ခုနှစ် ရာ ခုနစ် ဆယ် ခုနစ် နှစ် စေ့ သော်သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","နောဧ သည် အသက် ငါး ရာ ရှိ ၏။ နောဧ သား ကား၊ ရှေမ ၊ ဟာမ ၊ ယာဖက် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","မြေကြီး မျက်နှာ ပေါ် မှာလူ တို့သည် များပြား ၍ သမီး များကိုလည်း ရ ကြသောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ဘုရား သခင်၏သား တို့သည် လူ သမီး တို့ လှ ကြောင်း ကိုမြင် ၍ ၊ ကိုယ် စိတ် ရှိသည်အတိုင်း စုံဘက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ထာဝရဘုရား ကလည်း ငါ့ ဝိညာဉ် သည် လူ တို့တွင် အစဉ် မ ဆုံး မရ။ အကြောင်းမူကား လူ တို့သည် အသား ဖြစ်၏။ သူ ၏အသက် တန်းသည် လည်း၊ အနှစ် တရာ နှစ် ဆယ်ဖြစ် စေဟုမိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ထို ကာလ ၌ ၊ မြေကြီး ပေါ် မှာ ကိုယ် ကြီးမားသော သူအချို့ရှိ ကြ၏။ ထိုနောက် ၌လည်း ၊ ဘုရား သခင်၏ သား တို့သည်၊ လူ သမီး တို့နှင့် ဆက်ဆံ၍ ရ သောသားတို့သည်၊ အား ကြီးသောသူ၊ ရှေး ကာလမှစ၍ ၊ ကျော်စော သောသူ ဖြစ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","မြေကြီး ပေါ် မှာ လူ အပြစ် ကြီး ၍ ၊ သူ ၏ စိတ်နှလုံး အကြံအစည် ရှိသမျှ တို့သည် အစဉ်မပြတ် ဆိုးညစ် ခြင်းသက်သက် ရှိကြောင်းကို၊ ဘုရား သခင်သိမြင် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","မြေကြီး ပေါ် မှာ လူ ကို ဖန်ဆင်း တော်မူသည်ကို နောင်တရ ၍၊ နှလုံး တော်ပူပန် လျက် ရှိတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ထာဝရဘုရား ကလည်း ၊ ငါဖန်ဆင်း သော လူ ကို၎င်း၊ လူ မှစ၍ သားများ၊ တွား တတ်သော တိရစ္ဆာန် များ၊ မိုဃ်းကောင်းကင် ငှက် များတို့ကို၎င်းမြေကြီး မျက်နှာ မှာ ငါသုတ်သင် ပယ်ရှင်းမည်။ သူ တို့ကို ဖန်ဆင်း သောကြောင့် ငါနောင်တရ သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","နောဧ မူကား ၊ ထာဝရဘုရား စိတ်တော်နှင့် တွေ့ သောသူဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","နောဧ အတ္ထုပ္ပတ္တိ ဟူမူကား ၊ နောဧ သည် ဖြောင့်မတ် သောသူ ၊ မိမိ အမျိုး ၌ စုံလင် သောသူဖြစ် ၏။ ဘုရား သခင်နှင့်အတူ သွား လာ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","နောဧ သည် ရှေမ ၊ ဟာမ ၊ ယာဖက် တည်း ဟူသော သား သုံး ယောက်ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ထိုအခါ မြေကြီး သည် ဘုရား သခင့်ရှေ့ မှာ ပုပ်စပ် လျက်ရှိ၏။ မြေကြီး သည် အဓမ္မ အမှုနှင့် ပြည့်စုံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ဘုရား သခင်သည် မြေကြီး ကိုကြည့်ရှု သောအခါ ၊ ပုပ်စပ် လျက်ရှိသည်ကို မြင် တော်မူ၏။ အကြောင်းမူကား မြေကြီး ပေါ် မှာ လူ အပေါင်း တို့သည် ဖေါက်ပြန် ခြင်းသို့ ရောက်ကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ထိုအခါ ဘုရား သခင်သည်၊ နောဧ အား မိန့် တော်မူသည်ကား၊ သတ္တဝါ အပေါင်း တို့၏ အဆုံး သည် ငါ့ မျက်မှောက် တွင် ပေါ် လာပြီ။ သူ တို့ကြောင့် မြေကြီး သည် အဓမ္မ အမှုနှင့်ပြည့်စုံ လေ၏။ အကယ်စင်စစ်မြေကြီး နှင့်တကွ သူ တို့ကို ငါ ဖျက်ဆီး မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ဂေါဖရ သစ်သား ဖြင့် သင်္ဘော ကို ကိုယ် ဘို့ တည်လုပ် လော့။ အထဲ၌ လည်း အခန်း များကို လုပ် လော့။ အတွင်း ၊ ပြင် ၊ ပတ်လည်ကို ထင်းရူးစေး နှင့် သုတ် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","လုပ် ရမည်ပုံ ဟူမူကား၊ သင်္ဘော အလျား အတောင် သုံး ရာ ၊ အနံ အတောင် ငါး ဆယ်၊ အမြင့် အတောင် သုံး ဆယ်ရှိစေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","အပေါ် ၌ လည်းအမိုး ကိုလုပ် ရမည်။ ထိုအမိုး အပေါ်အလယ်ချက်၌၊ ထိပ်အုပ်အနံတတောင် အကျယ် ရှိ စေရမည်။ သင်္ဘော နံ တစ်ဖက်၌ လည်း တံခါး ကို လုပ်ရမည်။ အောက် ဆင့်၊ အလယ် ဆင့်၊ အပေါ်ဆင့်ဟူ၍၊ သုံး ဆင့်ကိုလည်း ရှိ စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","အသက် ရှင် သော သတ္တဝါ အပေါင်း တို့ကို၊ ကောင်းကင် အောက် မှ ငါ့ ကိုယ်တိုင်ပယ်ရှင်း ခြင်းငှါ ၊ မြေကြီး ကို ရေ လွှမ်းမိုး စေသဖြင့် ၊ မြေ ပေါ် မှာ ရှိသမျှ တို့သည် သေ ကြရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","သင် ၌ မူကား ၊ ငါ့ ပဋိညာဉ် ကို ငါတည် စေမည်။ သင် သည် သား ၊ မယား ၊ ချွေးမ များနှင့်တကွ ၊ သင်္ဘော ထဲ သို့ ဝင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","အသက် ရှင်သော တိရစ္ဆာန် အမျိုးမျိုး ထဲက ၊ အထီး အမ ၊ အစုံ တို့ကိုယူ၍၊ သင် နှင့်အတူ အသက် ချမ်းသာစေခြင်းငှါ ၊ သင်္ဘော ထဲ သို့ သွင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ငှက် လည်းအမျိုး အလိုက် ၊ သားလည်း အမျိုး အလိုက် ၊ တွား တက်သော တိရစ္ဆာန်အပေါင်း လည်း အမျိုး အလိုက် ၊ အထီးအမ၊ အစုံ တို့သည် အသက် ချမ်းသာစေခြင်းငှါ ၊ သင့် ထံသို့ လာ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ကိုယ် စားစရာအဘို့ ၊ တိရစ္ဆာန် တို့စားစရာ အဘို့ ၊ စား အပ်သော အစာ အမျိုးမျိုး ကို ယူ ၍ သို ထားရမည်ဟု၊ ဘုရားသခင်မှာထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","မှာ ထားတော်မူသည်အတိုင်း လည်း နောဧ ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ထိုနောက် ၊ ထာဝရဘုရား သခင်သည် နောဧ ကို တဖန် မိန့် တော်မူပြန်သည်ကား၊ ဤ ကာလ အမျိုးတွင် သင် သည် ငါ့ ရှေ့ ၌ ဖြောင့်မတ် ကြောင်းကို ငါသိမြင် သည် ဖြစ်၍၊ သင် ၏အိမ်သူ အိမ်သားအပေါင်း တို့နှင့်တကွ ၊ သင်္ဘော ထဲ သို့ ဝင် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","မြေကြီး ပေါ် မှာ တိရစ္ဆာန်အမျိုး မပျက်ဆက်နွယ်စေခြင်းငှါ ၊ စင်ကြယ် သော သား မျိုး၊ တမျိုးတမျိုးတွင် အထီး အမ ခုနစ် စုံစီ၊ မ စင်ကြယ် သော သား မျိုး၊ တမျိုး တမျိုးတွင်လည်း အထီး အမ နှစ် စုံစီ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","မိုဃ်းကောင်းကင် ငှက် ၊ တမျိုးမျိုးတွင်လည်း အထီး အမ ခုနစ် စုံစီ၊ အသီးသီး တို့ကို သိမ်းယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","အကြောင်းမူကား ၊ ယနေ့ မှစ၍ ခုနစ်ရက်စေ့လျှင်၊ အရက် လေးဆယ် ပတ်လုံးမြေကြီး ပေါ် သို့ မိုဃ်း ရွာ စေမည်။ ငါဖန်ဆင်း သော သတ္တဝါ အပေါင်း တို့ကို၊ မြေကြီး မျက်နှာ ပေါ် မှ ငါပယ်ရှင်း မည်ဟု၊ ထာဝရဘုရား မှာထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","မှာ ထားတော်မူသည်အတိုင်း လည်း နောဧ ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","မြေကြီး ကို ရေ လွှမ်းမိုး သောအခါ နောဧ သည် အသက် ခြောက် ရာ ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ရေ လွှမ်းမိုး ခြင်းဘေးကြောင့် ၊ နောဧ သည် မိမိ သား ၊ မယား ၊ ချွေးမ များနှင့်တကွ ၊ သင်္ဘော ထဲသို့ ဝင် ၍ ");
INSERT INTO myajvb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ဘုရား သခင်မှာ ထားတော်မူသည့်အတိုင်း စင်ကြယ် သောသား ၊ မ စင်ကြယ် သောသား ၊ ငှက် များနှင့် မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန်များအထဲ က၊ ");
INSERT INTO myajvb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","အထီး အမ အစုံ တို့သည်၊ နောဧ နှင့်အတူသင်္ဘော ထဲသို့ ဝင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ခုနစ် ရက် စေ့သောအခါ ၊ လွှမ်းမိုး အပ်သော ရေ သည် မြေ ပေါ် ၌ ပေါ် လာ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","နောဧ အသက် ခြောက် ရာ စေ့သောနှစ် ၊ ဒုတိယ လ ၊ ဆယ် ခုနစ် ရက် နေ့တွင် ၊ ကြီးစွာ သော နက်နဲ ရာ ရေ ပေါက်ရေတွင်းတို့၏ အဆီး အတားရှိသမျှ ကို ပယ်ရှင်း၍၊ မိုဃ်း ကောင်းကင်ပြွန်ဝ များကို ဖွင့် သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","အရက်လေး ဆယ်ပတ်လုံးမြေကြီး ပေါ် မှာ မိုဃ်း ရွာ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ထို နေ့ ရက်တွင် ၊ နောဧ နှင့် မိမိ မယား မှစ၍ ရှေမ ၊ ဟာမ ၊ ယာဖက် တည်းဟူသောနောဧ သား သုံးယောက်၊ ချွေးမ သုံး ယောက်တို့သည် သင်္ဘော ထဲ သို့ ဝင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","သားရဲ မျိုး ၊ သားယဉ် မျိုး ၊ မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန် မျိုး ၊ ပျံ တတ်သော ကြက် ငှက် မျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","အသက် ရှင်သော တိရစ္ဆာန် အမျိုးအမျိုးအပေါင်း တို့အထဲက ၊ အထီးအမအစုံ တို့သည်၊ နောဧ နှင့်အတူသင်္ဘော ထဲသို့ ဝင် ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ထိုသို့နောဧကို ဘုရား သခင်မှာ ထားတော်မူသည်အတိုင်း ဝင် သောတိရစ္ဆာန်တို့သည်၊ ခပ်သိမ်း သော တိရစ္ဆာန် တို့အထဲက ၊ အထီး အမ စုံလျက်ဝင် ကြ၏။ ထာဝရဘုရား သည်လည်း နောဧ ကို အထဲမှာ ပိတ် ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ရေ လွှမ်းမိုးခြင်းသည် အရက် လေး ဆယ်ပတ်လုံးမြေကြီး ပေါ် မှာ အစဉ်အတိုင်းတိုးတက် ၍ သင်္ဘော ကို မြေ မှ ခွါ လျက် ဆောင်ယူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","တဖန် ရေ သည်အားကြီး၍ မြေကြီး ပေါ် မှာ အလွန် တိုးတက် သဖြင့် ၊ သင်္ဘော သည် ရေ မျက်နှာ ပေါ် ၌ မျော လျက်နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","နောက်တဖန်ရေ သည် မြေကြီး ပေါ် မှာ အလွန် အားကြီး သဖြင့် မိုဃ်း ကောင်းကင်အောက် ၌ ရှိသမျှ သော တောင် ကြီး အပေါင်း တို့သည် မြုပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ရေမြုပ်သောတောင် တို့ အထက် ၌ လွှမ်း တတ်သော ရေ သည် ဆယ့် ငါး တောင် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","မြေ ပေါ် မှာ လှုပ်ရှားတတ်သော တိရစ္ဆာန် မျိုးတည်းဟူသောငှက် ၊ သားယဉ် ၊ သားရဲ ၊ မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန်အပေါင်း တို့နှင့် လူ အပေါင်း တို့သည် သေ ကြကုန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","အသက် ရှု လျက် ကုန်း ပေါ် မှာ ရှိလေသမျှ တို့သည် သေ ကြကုန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","မြေ မျက်နှာ ပေါ် ၌ ရှိသောလူ ဖြစ်စေ ၊ သား ဖြစ်စေ တွား တတ်သော အရာဖြစ်စေ ၊ မိုဃ်း ကောင်းကင်ငှက် ဖြစ်စေ၊ အသက် ရှင်သော အရာရှိ ရှိသမျှတို့ကို မြေကြီး ပေါ်က ပယ်ရှင်း တော်မူ၍ ၊ ပျက်စီး ကွယ်ပျောက်ခြင်းသို့ ရောက်ကြကုန်၏။ နောဧ မှစ၍ နောဧနှင့်အတူ သင်္ဘော ထဲ ၌ရှိသော သူတို့ သာ ကျန် ကြွင်းကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ရေ သည်လည်း မြေကြီး ပေါ် မှာ ရက် ပေါင်း တရာ့ ငါး ဆယ်ပတ်လုံးအား ကြီးစွာတည်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ဘုရား သခင်သည်၊ နောဧ မှစ၍ အသက် ရှင်သမျှ သောသတ္တဝါ၊ နောဧ နှင့်အတူ သင်္ဘော ထဲ ၌ရှိသောတိရစ္ဆာန် အပေါင်း တို့ကို အောက်မေ့ ၍ ၊ မြေကြီး ပေါ် မှာ လေ လာစေတော်မူသဖြင့် ရေ ငြိမ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","နက်နဲ ရေပေါက် ရေတွင်းများ မိုဃ်းကောင်းကင် ပြွန်ဝ များကို ဆို့ပိတ် ၍ မိုဃ်း ကို စဲ စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ရေ သည်လည်း မြေ ပေါ် မှာ အစဉ် အတိုင်းစီး သွား၍ ၊ အရက် တရာ့ ငါး ဆယ်စေ့ သောအခါ ယုတ် လျော့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","သတ္တမ လ ၊ ဆယ် ခုနစ် ရက် နေ့တွင် သင်္ဘော သည် အာရရတ် အမည်ရှိသောတောင် ပေါ် မှာ တင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ဒသမ လ တိုင်အောင် ရေ သည် အစဉ် မပြတ်ယုတ် လျော့၍ ၊ ထိုလဆန်း တရက် နေ့တွင် တောင် ထိပ် တို့သည် ပေါ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ထို အရက် လေး ဆယ်ကြာ လျှင်၊ နောဧ သည် သင်္ဘော ထဲ၌ လုပ် ခဲ့သော ပြတင်းပေါက် ကိုဖွင့် ၍ ၊ ကျီး တကောင်ကို လွှတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ထိုကျီးအသည် မြေ ပေါ် မှာ ရေ မခန်း မခြောက် မှီတိုင်အောင် ၊ သွား လာလျက် နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","တဖန် မြေ မျက်နှာ ပေါ် မှာ ရေ ကုန်သည် မကုန် သည်ကို သိ ခြင်းငှါ ၊ ချိုး တကောင်ကို လွှတ် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","မြေ တပြင်လုံး ၌ ရေ ရှိသေးသောကြောင့် ၊ ချိုး သည် ခြေ ဖြင့်နင်း၍ အမော ဖြေစရာကို မ တွေ့ သဖြင့် ၊ နောဧ ရှိရာ သင်္ဘော သို့ ပြန် လာလေ၏။ နောဧ သည်လည်း လက် ကိုဆန့် ၍ ၊ ချိုး ကိုကိုင် ယူပြီးလျှင် ၊ မိမိ နေရာ သင်္ဘော ထဲသို့ သွင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","တဖန် ခုနစ် ရက် နေ ပြီးမှထိုချိုး ကို သင်္ဘော ထဲက လွှတ် ပြန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ညဦး အချိန် ၌ ချိုး သည် နောဧ ထံသို့ ပြန်လာ ၍ ၊ မိမိဆိတ်ယူသော သံလွင် ရွက် ကို မိမိ နှုတ် သီးဖြင့် ဆောင် ခဲ့ သောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","မြေကြီး ပေါ် မှာ ရေ ကုန် ကြောင်း ကို နောဧ သိ လေ၏။ တဖန် ခုနစ် ရက် နေ ပြီးမှထိုချိုး ကို လွှတ် ပြန်၏။ နောက် တဖန်ချိုး သည် မ ပြန် မလာနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","အနှစ် ခြောက် ရာ တခု ပဌမ လ ဆန်းတရက် နေ့တွင် ၊ မြေကြီး ပေါ် မှာ ရေ ခန်း ခြောက်သည်ရှိသော်၊ နောဧ သည် သင်္ဘော မိုး ကို ပယ်ဖျက် ၍ ကြည့်ရှု သောအခါ ၊ မြေ မျက်နှာ သွေ့ ခြောက်စရှိသည်ကို မြင် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ဒုတိယ လ ၊ နှစ် ဆယ်ခုနစ် ရက် နေ့တွင် မြေကြီး သွေ့ ခြောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ဘုရား သခင်ကလည်း သင် သည် သား မယား ၊ ချွေးမ တို့နှင့်တကွ ၊ သင်္ဘော ထဲက ထွက် ဆင်းလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","သင် ထံမှာ အသက် ရှင်သော တိရစ္ဆာန် ၊ ငှက် များ၊ သား များ မြေ ပေါ် ၌ တွား တတ်သောတိရစ္ဆာန်များ တို့သည်၊ မြေ ပေါ် မှာသားကိုမွေး ၍ အလွန် တိုးပွား များပြား မည်အကြောင်း ၊ ထိုတိရစ္ဆာန်ရှိသမျှ တို့ကို ကိုယ် နှင့်အတူ ထုတ် ဆောင်လော့ဟု၊ နောဧ ကို မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ထိုအခါ နောဧ မှစ၍ သား ၊ မယား ၊ ချွေးမ တို့သည် ထွက် ဆင်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","သား များ၊ တွား တတ်သော တိရစ္ဆာန်များ၊ ငှက် များ၊ မြေ ပေါ် မှာ လှုပ်ရှား တတ်သမျှ သောအမျိုးမျိုး အပေါင်းတို့သည်လည်း၊ သင်္ဘော ထဲက ထွက် ဆင်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","နောဧ သည်လည်း ၊ ထာဝရဘုရား အဘို့ ယဇ် ပလ္လင်ကို တည် ပြီးမှ စင်ကြယ် သောသား ၊ စင်ကြယ် သော ငှက် အမျိုးမျိုး ထဲက ယူ ၍ ၊ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့သော ယဇ် ကို ပူဇော်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ထာဝရဘုရား သည်လည်း မွှေးကြိုင် သော အနံ့ ကို ခံယူ ၍ ၊ ငါသည် နောက်တဖန် လူတို့အတွက် မြေကြီး ကို မ ကျိန်။ အကြောင်းမူကား ၊ လူ တို့သည် ငယ် သောအရွယ်မှစ၍ ၊ စိတ် နှလုံးအကြံအစည် ဆိုး ကြ၏။ ငါသည် ယခုတခါ ပြု ပြီးသကဲ့သို့ ၊ အသက် ရှင်သောအရာရှိသမျှ တို့ကို နောက် တဖန်ဒဏ် မ ခတ်။ ");
INSERT INTO myajvb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","မြေကြီး မကုန်မှီတိုင်အောင်မျိုးစေ့ ကြဲရသောကာလ၊ အသီးအနှံ ကို သိမ်းရသောကာလ၊ ချမ်း သောကာလ၊ ပူ သောကာလ၊ နွေ ကာလ၊ ဆောင်း ကာလ မ ပြတ် ရဟု အမိန့် တော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ဘုရား သခင်သည်လည်း ၊ နောဧ နှင့် သူ ၏သား တို့ကိုကောင်းကြီး ပေးတော်မူ၍ ၊ သင်တို့သည်များပြား စွာ မွေးဘွား လျက် မြေကြီး ပြည့် စေကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","မြေ တိရစ္ဆာန် ၊ မိုဃ်းကောင်းကင် ငှက် အစ ရှိသော၊ မြေ ပေါ်မှာ လှုပ်ရှား တတ်သမျှ နှင့် ၊ ပင်လယ် ငါး အပေါင်း တို့သည်၊ သင် တို့ရှေ့မှာကြောက်ရွံ့ တုန်လှုပ် ခြင်းသဘောရှိ ကြလိမ့်မည်။ ထိုတိရိစ္ဆာန်တို့ကို သင် တို့လက် ၌ ငါ အပ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","အသက် ရှင်၍ လှုပ်ရှား တတ်သမျှ သည်၊ အသီး အရွက်ကဲ့သို့ ၊ သင် တို့စားစရာ ဘို့ ဖြစ် ရမည်။ ခပ်သိမ်း သောအရာတို့ကို သင် တို့၌ ငါအပ်ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","သို့သော်လည်း အသက် တည်းဟူသောအသွေးနှင့်တကွ အသား ကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","အကယ်၍ သင် တို့အသက် တည်းဟူသော၊ သင် တို့အသွေး ကို ငါတောင်း မည်။ လူ ၊ တိရစ္ဆာန် အပေါင်း တို့၌ ငါတောင်း မည်။ ခပ်သိမ်းသော လူ တို့၏ ညီအစ်ကို ၌ လူ ၏အသက် ကို ငါတောင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","အကြင်သူသည် လူ ၏အသွေး ကိုသွန်း ၏။ ထိုသူ ၏အသွေး ကို လူ လက်ဖြင့် သွန်း ရမည်။ အကြောင်းမူကား ဘုရား သခင်သည် မိမိပုံသဏ္ဍာန် နှင့်အညီ လူ ကို ဖန်ဆင်း တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","သင် တို့သည် သားကိုဘွား ၍ များပြား ကြလော့။ မြေ ပေါ် မှာ အလွန်မွေးဘွား ၍ များပြား ကြလော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","တဖန် ဘုရား သခင်သည်၊ နောဧ နှင့် သူ ၏သား တို့ကို မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","သင် တို့နှင့် ၎င်း၊ နောက် ဖြစ်လတံ့သော အမျိုး အနွယ်နှင့်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","သင် တို့ထံမှာ အသက် ရှင်သော တိရစ္ဆာန် တည်းဟူသော ငှက် ၊ သားယဉ် ၊ သားရဲ ရှိသမျှ သင်္ဘော ထဲက ထွက် ဆင်းသမျှ မှစ၍ ၊ မြေ တိရစ္ဆာန် အပေါင်း တို့နှင့် ၎င်း၊ ငါ သည်ကိုယ်တိုင်ပဋိညာဉ် ပြု ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","သင် တို့နှင့် ငါ ပြု သော ပိဋိညာဉ် ဟူမူကား ၊ ရေ လွှမ်းမိုး ခြင်းအားဖြင့် ၊ ခပ်သိမ်း သော သတ္တဝါ တို့သည် နောက် တဖန်မ ဆုံး ရကြ။ မြေကြီး ကို ဖျက်ဆီး ဘို့ ရာနောက် တဖန်ရေ လွှမ်းမိုးခြင်း မ ရှိ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ထိုမှတပါး ငါ တဘက်၊ သင် တို့နှင့် သင် တို့ထံမှာ အသက် ရှင်သမျှ သောတိရစ္ဆာန် တို့ တစ်ဖက်၌ သား မြေး အစဉ် အဆက်မပြတ်၊ ငါ ပြု သော ပဋိညာဉ် ၏ လက္ခဏာ သက်သေဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ငါ ၏ သက်တံ့ ကို မိုဃ်း တိမ်၌ ငါထား ၏။ ထိုသက်တံ့သည် မြေကြီး နှင့် ငါ ပြုသော ပဋိညာဉ် ၏ သက်သေ ဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ငါ သည် မိုဃ်း ကို အုံ့စေသောအခါ ၊ မိုဃ်းတိမ် ၌ သက်တံ့ သည် ထင်ရှား လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ထိုအခါငါ တဘက်၊ သင် တို့မှစ၍ ၊ အသက် ရှင်သောသတ္တဝါ ၊ တိရစ္ဆာန်ရှိသမျှ တို့ တစ်ဖက်၌ရှိသော ၊ ငါ ၏ ပဋိညာဉ် ကိုငါ အောက်မေ့ သဖြင့် ခပ်သိမ်း သော သတ္တဝါ တို့ကို ဖျက်ဆီး ခြင်းငှါ နောက် တဖန်ရေ လွှမ်းမိုးခြင်းမ ရှိ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","မိုဃ်းတိမ် ၌ သက်တံ့ ရှိ သည်ကို ငါကြည့်ရှု သဖြင့် ၊ ဘုရား သခင်နှင့် မြေကြီး ပေါ် မှာ အသက် ရှင်သော သတ္တဝါ တိရစ္ဆာန်အပေါင်း တို့ စပ်ကြား မှာရှိသော ထာဝရ ပဋိညာဉ် ကို ငါအောက်မေ့ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ဤ သည်ကား ငါ နှင့် မြေကြီး ပေါ် မှာရှိသော သတ္တဝါ အပေါင်း တို့၏ စပ်ကြား မှာ၊ ငါအမြဲဖွဲ့ သော ပဋိညာဉ် ၏ လက္ခဏာ သက်သေဖြစ်သတည်းဟု နောဧ ကို ဘုရား သခင်မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","သင်္ဘော ထဲက ထွက် ဆင်းသော နောဧ သား တို့၏အမည်ကား ရှေမ ၊ ဟာမ ၊ ယာဖက် တည်း၊ ဟာမ သည် ခါနာန် ၏ အဘ ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ဤ သူတို့သည် နောဧ ၏ သား သုံး ယောက်ဖြစ်၍ မြေကြီး တပြင်လုံး ၌ နှံ့ပြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","နောဧ သည် လယ် လုပ်သောအတတ်ကို ပြုစု ၍ ၊ စပျစ် ဥယျာဉ်ကို စိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","စပျစ် ရည်ကိုလည်း သောက် ၍ ယစ်မူး သဖြင့် ၊ မိမိ ထဲ ၌ အဝတ် မခြုံဘဲနေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ခါနာန် ၏ အဘ ဟာမ သည်၊ မိမိ အဘ ၌ အဝတ်အချည်းစည်း ရှိသည်ကိုမြင် လျှင် ပြင် မှာ ရှိသော အစ်ကို နှစ် ယောက်ကို ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ရှေမ နှင့် ယာဖက် တို့သည် အဝတ် ကိုယူ ၍ ပခုံး ပေါ် မှာ တင် ပြီးလျှင် ၊ နောက် သို့ဆုတ်သွား ၍ မိမိ အဘ ၌၊ အဝတ်အချည်းစည်း ရှိသည်ကို ဖုံး ကြ၏။ သူ တို့သည် အပြင်သို့မျက်နှာ ပြုသောကြောင့် ၊ မိမိ အဘ ၌ အဝတ် အချည်းစည်း ရှိသည်ကို မ မြင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","နောဧ သည် ယစ်မူးခြင်းပျောက်၍ နိုး သောအခါ ၊ မိမိ ၌သား ငယ် ပြု သည်ကို သိ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ခါနာန် သည် ကျိန် ခြင်းကိုခံ ပါစေ။ အစ်ကို တို့၏ကျွန် တို့၌ ကျွန် ဖြစ် ပါစေဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","တဖန် ရှေမ ၏ ဘုရား သခင်ထာဝရဘုရား သည် မင်္ဂလာ ရှိတော်မူစေသတည်း။ ခါနာန် သည် ရှေမ ၏ကျွန် ဖြစ် ပါစေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ဘုရား သခင်သည် ယာဖက် ကို ကျယ် စေတော်မူသဖြင့် ၊ ရှေမ ၏ တဲ တို့တွင် နေ ပါစေ။ ခါနာန် မူကား ၊ သူ ၏ကျွန် ဖြစ် ပါစေဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","နောဧ သည် ရေ လွှမ်းမိုးသောနောက် ၊ အနှစ် သုံး ရာ ငါး ဆယ် အသက် ရှင်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","အသက် ပေါင်း ကိုး ရာ ငါး ဆယ်စေ့ သော် အနိစ္စ ရောက်လေ၏ ");
INSERT INTO myajvb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ရေ လွှမ်းမိုးသောနောက် ၊ နောဧ သား ရှေမ ၊ ဟာမ ၊ ယာဖက် တို့မှ ဆင်းသက် သော သားစဉ် မြေးဆက်တို့ကို ဆိုပေအံ့။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ယာဖက် ၏သား ကား ဂေါမာ ၊ မာဂေါဂ ၊ မာဒဲ ၊ ယာဝန် ၊ တုဗလ ၊ မေရှက် ၊ ထိုက် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ဂေါမ သား ကား၊ အာရှကေနတ် ၊ ရိဖတ် တော်ဂမ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ယာဝန် သား ကား၊ ဧလိရှာ ၊ တာရှု ၊ ကိတ္တိမ် ၊ ဒေါဒနိမ် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ဤ သူတို့သည် လူ အမျိုးမျိုးတကျွန်း တနိုင်ငံမြေ နယ်တို့ကို ဘာသာ အသီးအသီး ၊ အမျိုးအနွယ် အသီးသီးရှိသည့်အတိုင်း ၊ အချင်းချင်းခွဲ ဝေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ဟာမ သား ကား၊ ကုရှ ၊ မိဇရိမ် ၊ ဖုတ ၊ ခါနာန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ကုရှ သား ကား၊ သေဘ ၊ ဟာဝိလ ၊ သာဘတ ၊ ရာဂမ ၊ သတ္တေခါ တည်း။ ရာဂမ သား ကား၊ ရှေဘ ၊ ဒေဒန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ကုရှ သည် သား နိမ်ရောဒ ကိုလည်း ရသေး၏။ ထို သားသည် မြေကြီး ပေါ် မှာ အဦး စွမ်း နိုင်သောသူဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ထာဝရဘုရား ရှေ့ မှာ အားကြီး သော မုဆိုး ဖြစ်၏။ ထိုကြောင့်စကားပုံ၌ကား၊ ဘုရား ရှေ့ နိမ်ရောဒ ၊ အား ကြီးမုဆိုး ၊ ပြု လုပ်သည်လိုဟု စပ် ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","သူ ၏ နိုင်ငံ အဦး ကား၊ ရှိနာ ပြည် ၌ ဗာဗုလုန် မြို့၊ ဧရက် မြို့၊ အက္က မြို့ကာလနေ မြို့တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ထို ပြည် မှာအာရှရိ ပြည်သို့ သွား၍ နိနေဝေ မြို့၊ ရဟောဘုတ် မြို့ ကာလ မြို့ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","နိနေဝေ မြို့နှင့် ၊ ကာလ မြို့စပ်ကြား မှာ ကြီး စွာသော မြို့ တည်းဟူသောရေသင် မြို့ကို၎င်းတည်ဆောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","မိဇရိမ် သား ကား၊ လုဒိမ် လူ၊ အာနမိမ် လူ၊ လဟာဗိမ် လူ၊ နတ္တုဟိမ် လူ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ပါသရူသိမ် လူ၊ ကာသလုဟိမ် လူ၊ ကတ္တောရိမ် လူတည်း။ ကာသလုဟိမ်အမျိုးထဲက ဖိလိတ္တိ လူဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ခါနာန် သား အကြီး ကား၊ ဇိဒုန်။ ထိုနောက် ဟေသ။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ထိုနောက် ယေဗုသိ လူ၊ အာမောရိ လူ။ ဂိရဂါရှိ လူ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ဟိဝိ လူ၊ အာကိ လူ၊ သိနိ လူ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","အာဝဒိ လူ၊ ဇေမရိ လူ၊ ဟာမသိ လူတည်း။ ထိုနောက် ခါနာန် အမျိုးသားအသီးသီး တို့သည် နှံ့ပြား ကြ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ခါနာန် အမျိုးသားနေရာ ပြည်နယ်သည် ဇိဒုန် မြို့မှ ဂေရာ မြို့၊ ဂါဇ မြို့တိုင်အောင် ၎င်း တဖန်သောဒုံ မြို့၊ ဂေါမောရ မြို့၊ အာဒမာ မြို့ ဇောဘိုင် မြို့ကိုလွန်၍ လာရှ မြို့ တိုင်အောင် ၎င်း ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ဤ သူတို့သည် သီးခြားသော အမျိုး အနွယ်၊ သီးခြားသော ဘာသာ အလိုက် ၊ အပြည် အပြည်အတိုင်း တိုင်း၌ နေသောဟာမ သား များ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ယာဖက် ညီ၊ ဟေဗြဲ လူအပေါင်း တို့၏ အဘ ၊ ရှေမ သည်လည်း သား များကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ရှေမ သား ကား၊ ဧလံ ၊ အာရှရ ၊ အာဖါဇဒ် ၊ လုဒ ၊ အာရံ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","အာရံ သား ကား၊ ဥဇ ၊ ဟုလ ၊ ဂေသာ ၊ မာရှ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","အာဖာဇဒ် သား ရှာလ ၊ ရှာလ သား ဟေဗာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ဟေဗာ သည်လည်း သား နှစ် ယောက်ကို မြင် လေ၏။ သား တယောက်ကား၊ ဖာလက် အမည် ရှိ၏။ အကြောင်း မူကား၊ သူ့ လက်ထက် ၌ မြေကြီး ကို ခွဲဝေ ကြ၏။ သူ ၏ညီ ကား၊ ယုတ္တန် အမည် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ယုတ္တန် သား ကား၊ အာလမောဒဒ် ၊ ရှေလပ် ၊ ဟာဇာမာဝက် ၊ ယေရ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ဟဒေါရံ ၊ ဥဇလ ၊ ဒိကလ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ဩဗလ အဘိမေလ ၊ ရှေဘ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ဩဖိရ ဟဝိလ ၊ ယောဗပ် ၊ ဤ သူအပေါင်း တို့ သည် ယုတ္တန် သား ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","သူ တို့နေရာ မူကား၊ မေရှ မြို့မှ သည် အရှေ့ မျက်နှာ၌သေဖာ တောင် တိုင်အောင် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ဤ သူ တို့သည် သီးခြားသော အမျိုးအနွယ် ၊ သီးခြားသော ဘာသာ အလိုက် ၊ အပြည် ပြည်အတိုင်းတိုင်း တို့၌ နေသောရှေမ သား များဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ဤ ရွှေ့ကား မိမိတို့အမျိုးအနွယ် အသီးသီးအလိုက်မှတ်သားထားသော နောဧ သား ဆွေစဉ်မျိုးဆက် စာရင်းပေသတည်း။ ထိုသူ တို့သည် ရေ လွှမ်းမိုးသောနောက် ၊ မြေကြီး ပေါ် မှာ သီးခြား သော တိုင်းပြည် တို့ကိုတည်ထောင်ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","မြေကြီး သားအပေါင်း တို့သည် ဘာသာ တ မျိုးတည်း။ စကား တ မျိုးတည်းရှိ ကြသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","အရှေ့ မျက်နှာမှ ခရီး သွားသဖြင့် ၊ ရှိနာ ပြည် ၌ မြေညီ ရာအရပ် ကိုတွေ့ ၍ နေရာ ချကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","သူတို့ကလည်း လာ ကြ။ အုတ် လုပ် ၍ ခိုင်မာစွာ ဖုတ် ကြကုန်အံ့ဟု၊ တ ယောက်ကို တယောက် ပြော ကြ၏။ ထိုသို့ ကျောက် အရာ ၌ အုတ် ကို ၎င်း ၊ သရွတ် အရာ ၌ ရေညှိ တမျိုးကို၎င်း ရပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","လာ ကြ၊ မြေကြီး တပြင်လုံး ၌ အရပ်ရပ် ကွဲပြား မည်ကို စိုးရိမ် ၍၊ မြို့ ကို ၎င်း ၊ မိုဃ်းကောင်းကင် သို့ မှီရသော ရဲတိုက် ကို၎င်း တည် လုပ်သဖြင့် ၊ ကျော်စော ကိတ္တိရှိစေခြင်းငှါ ပြု ကြကုန်အံ့ဟု ပြောဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ထိုသို့ လူ သား တို့တည် လုပ်သော မြို့ နှင့် ရဲတိုက် ကို ကြည့်ရှု ခြင်းငှါ ၊ ထာဝရဘုရား သည် ဆင်းသက် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ထာဝရဘုရား က ကြည့်ရှု လော့။ လူ တ မျိုးတည်း ၊ စကား တ မျိုးတည်း ရှိသည်ဖြစ်၍၊ သူ တို့သည် ဤ အမှုကို အဦး ပြု ကြ၏။ ယခု ကြံစည် သမျှ တို့ကို အဆီး အတားမ ရှိ၊ သူ တို့ပြု ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","လာ ကြ၊ ဆင်းသက် ကြကုန်အံ့။ သူတို့သည် အချင်းချင်း နား မ လည်စေခြင်းငှါ၊ သူ တို့စကား ကို ရှုပ်ထွေး ကြကုန်အံ့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ထိုသို့ ထာဝရဘုရား သည် သူ တို့ကို မြေကြီး တပြင်လုံး ၌ အရပ်ရပ်ကွဲပြား စေတော်မူသဖြင့် ၊ သူတို့သည် မြို့ ကိုမ တည်ပဲ နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","သို့ဖြစ်၍ ထိုမြို့၌ ထာဝရဘုရား သည် မြေကြီး သားအပေါင်း တို့၏ စကား ကိုရှုပ် ထွေး၍ ၊ သူ တို့ကို မြေကြီး တပြင်လုံး ၌ အရပ်ရပ် ကွဲပြား စေတော်မူသောကြောင့် ထို မြို့ သည် ဗာဗုလုန် မြို့ဟူ၍တွင် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ရှေမ ၏ သားစဉ်မြေးဆက်ဟူမူကား ၊ ရှေမ သည် အသက် တ ရာရှိ၍ ၊ ရေ လွှမ်းမိုးသောနောက် နှစ် နှစ်ကြာ သော်၊ သားအာဖာဇဒ် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","အာဖာဇဒ် ဘွားမြင် သောနောက် ၊ ရှေမ သည် အနှစ် ငါး ရာ အသက် ရှင်၍ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","အာဖာဇဒ် သည် အသက် သုံး ဆယ်ငါး နှစ်ရှိ သော်၊ သားရှာလ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ရှာလ ဘွားမြင် သောနောက် ၊ အာဖာဇဒ် သည် အနှစ် လေး ရာ သုံး နှစ် အသက်ရှင် ၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ရှာလ သည် အသက် သုံး ဆယ်ရှိ သော်၊ သားဟေဗာ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ဟေဗာ ဘွားမြင် သောနောက် ၊ ရှာလ သည် အနှစ် လေး ရာ သုံး နှစ် အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ဟေဗာ သည် အသက်သုံး ဆယ့်လေး နှစ် ရှိ သော်၊ သားဖာလက် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ဖာလက် ဘွားမြင် သောနောက် ၊ ဟေဗာ သည် အနှစ် လေး ရာ သုံး ဆယ်အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ဖာလက် သည် အသက် သုံး ဆယ်ရှိ သော်၊ သားရာဂေါ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ရာဂေါ ဘွားမြင် သောနောက် ၊ ဖာလက် သည် အနှစ် နှစ် ရာကိုး နှစ် အသက် ရှင်၍ ၊ သား သမီး များကို ဘွားမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ရာဂေါ သည် အသက် သုံး ဆယ်နှစ် နှစ်ရှိ သော်၊ သားစေရောက် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","စေရောက် ဘွားမြင် သောနောက် ၊ ရာဂေါ သည် အနှစ် နှစ် ရာခုနစ် နှစ် အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","စေရောက် သည်အသက် သုံး ဆယ်ရှိ သော်၊ သားနာခေါ် ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","နာခေါ် ဘွားမြင် သောနောက် ၊ စေရောက် သည် အနှစ် နှစ် ရာအသက် ရှင်၍ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","နာခေါ် သည် အသက် နှစ် ဆယ်ကိုး နှစ်ရှိ သော်၊ သားတေရ ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","တေရ ဘွားမြင် သောနောက် ၊ နာခေါ် သည် အနှစ် တ ရာတဆယ် ကိုး နှစ် အသက် ရှင်၍ ၊ သား သမီး များကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","တေရ သည် အသက် ခုနစ် ဆယ်ရှိ သော်၊ သားအာဗြံ ၊ နာခေါ် ၊ ခါရန် တို့ကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","တေရ ၏ သားစဉ် မြေးဆက်ဟူမူကား ၊ တေရ သည် အာဗြံ ၊ နာခေါ် ၊ ခါရန် တို့ကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ခါရန် သည်လည်း လောတ ကိုမြင် လေ၏။ ခါရန် သည်၊ အဘ တေရ မ သေမှီ၊ မိမိ ဘွား ရာအရပ် ၊ ခါလဒဲ ပြည်သားတို့နေသောဥရ မြို့၌ သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","အာဗြံ နှင့် နာခေါ် သည် မယား ကို ယူ ၍ ၊ အာဗြံ ၏ မယား ကား၊ စာရဲ အမည် ရှိ၏။ နာခေါ် ၏ မယား ကား၊ ခါရန် ၏သမီး မိလခါ အမည် ရှိ၏။ ခါရန်သည် မိလခါ နှင့် ဣသခ ၏အဘ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","စာရဲ မူကား မြုံ သော မိန်းမဖြစ် ၍ သားသမီး မ ရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","တေရ သည်သား အာဗြံ ကို၎င်း ၊ ခါရန် ၏သား ဖြစ်သောမြေး လောတ ကို၎င်း ၊ သားအာဗြံ ၏မယား ဖြစ် သော မိမိ ချွေးမ စာရဲ ကို၎င်း ခေါ်၍၊ သူတို့သည် ခါနာန် ပြည် သို့ သွား ခြင်းငှါ ၊ ခါလဒဲ ပြည်သားတို့နေသောဥရ မြို့မှ ထွက် သဖြင့်၊ ခါရန် မြို့သို့ ရောက် ၍ နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","တေရ သည် အသက် နှစ် ပေါင်းနှစ် ရာငါး နှစ် ရှိ သော်၊ ခါရန် မြို့၌ သေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ထာဝရဘုရား သည်လည်း အာဗြံ ကို ခေါ် တော်မူ၍၊ သင် ၏ပြည် နှင့်တကွ အမျိုးသား ချင်းပေါက်ဘော် များထဲက ထွက် ပြီးလျှင် ၊ ငါပြ လတံ့သော ပြည် သို့ သွားလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ငါသည် သင့် ကို လူမျိုး ကြီး ဖြစ် စေမည်။ ငါ ကောင်းကြီး ပေး၍ သင် ၏နာမ ကို ကြီးမြတ် စေမည်။ သင် သည် ကောင်းကြီး ခံရသောသူဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","သင့် ကို ကောင်းကြီး ပေးသောသူကို ငါကောင်းကြီး ပေးမည်။ သင့် ကို ကျိန်ဆဲ သောသူကို ငါကျိန်ဆဲ မည်။ သင် အားဖြင့် လည်း လူမျိုး အပေါင်း တို့သည် ကောင်းကြီး မင်္ဂလာကို ခံရကြလိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ထိုသို့ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ အာဗြံ ထွက်သွား ၍ လောတ လည်းလိုက် လေ၏။ အာဗြံ သည် ခါရန် မြို့မှ ထွက်သွား သောအခါ အသက် ခုနစ် ဆယ်ငါး နှစ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","အာဗြံ သည် မယား စာရဲ ၊ အစ်ကို သား လောတ နှင့် ၊ ဥစ္စာ ရ တတ်သမျှ ကို ၎င်း ၊ ခါရန် မြို့၌ ရ သောလူ တို့ကို၎င်း ၊ ယူပြီးလျှင် ခါနာန် ပြည် သို့ ရောက် ခြင်းငှါ ၊ ထွက်သွား ၍ ၊ ထိုပြည် သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","အာဗြံ သည် ထိုပြည် ကို ရှောင်သွား ၍ ရှိခင် အရပ် ၊ မောရေ သပိတ် ပင်သို့ ရောက်လေ၏။ ထိုအခါ ၊ ခါနာန် အမျိုးသားတို့သည် ထိုပြည် ၌ ရှိကြရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ထာဝရဘုရား သည် အာဗြံ အား ထင်ရှား ၍ ၊ ဤ ပြည် ကို သင် ၏အမျိုး အနွယ်အား ငါပေး မည်ဟု မိန့် တော်မူ၏။ ထိုသို့ ထင်ရှား တော်မူသောထာဝရဘုရား ဘို့ ၊ ထို အရပ်၌၊ ယဇ် ပလ္လင်ကို တည် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ထို အရပ်မှ သွား ပြန်၍ ၊ ဗေသလ မြို့အရှေ့ ၌ ရှိသောတောင် သို့ ပြောင်းသဖြင့်၊ ဗေသလ မြို့အရှေ့၊ အာဣ မြို့ အနောက် စပ်ကြားမှာ တဲ ကိုဆောက် ၍ ၊ ထာဝရဘုရား သို့ ယဇ် ပလ္လင်ကို တည် ပြီးလျှင် ၊ ထာဝရဘုရား ၏ နာမ တော်ကို ပဌာန ပြု၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","အာဗြံ သည် ခရီး သွားလျက် ၊ ပြောင်း လျက် ၊ တောင် မျက်နှာသို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ထို့နောက် ၊ ခါနာန်ပြည် ၌ အစားခေါင်းပါး ခြင်းဖြစ် ၏။ အလွန် အစား ခေါင်းပါးသောကြောင့် ၊ အာဗြံ သည် အဲဂုတ္တ ပြည်၌ တည်းခို ခြင်းငှါ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","အဲဂုတ္တု ပြည်နှင့် နီး သောအခါ၊ မိမိ မယား စာရဲ ကို ၊ သင် သည် အဆင်း လှ သော မိန်းမ ဖြစ်သည်ကို ငါသိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","အဲဂုတ္တု လူတို့သည် သင့် ကိုမြင် သောအခါ ၊ ဤ မိန်းမသည် သူ ၏မယား ဖြစ်၏ဟုဆို လျက် ၊ ငါ့ ကိုသတ် ၍ သင့် ကို အသက် ချမ်းသာပေးလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","သို့ဖြစ်၍ သင် သည် ငါ့ နှမ ဖြစ်ကြောင်းကို ပြော ပါလော့။ သို့ ပြောလျှင် သင့်အတွက် ငါ ကောင်းစား လိမ့်မည်။ သင် ၏ကျေးဇူးအားဖြင့် ငါ အသက် ချမ်းသာ ရလိမ့်မည်ဟု ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","အာဗြံ သည် အဲဂုတ္တ ပြည်သို့ ရောက် သောအခါ ၊ သူ၏မယား သည် အလွန် အဆင်း လှသည်ကို အဲဂုတ္တု လူတို့သည် မြင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ဖါရော ဘုရင်၏မှူး တော်မတ်တို့လည်း မြင် ၍ ၊ ရှေ့တော်၌ ချီးမွမ်း ပြီးလျှင် ၊ နန်း တော်သို့ သွင်း ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ဖာရောဘုရင်သည် ထိုမိန်းမ အတွက် အာဗြံ ၌ ကျေးဇူး ပြုသဖြင့် ၊ သူ သည် သိုး ၊ နွား ၊ မြည်းထီး ၊ မြည်း မ၊ ကျွန် ယောက်ျား၊ ကျွန် မိန်းမ၊ ကုလားအုပ် များနှင့် ကြွယ်ဝ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ထာဝရဘုရား သည် အာဗြံ ၏ မယား စာရဲ အတွက် ကြောင့်၊ ဖါရော ဘုရင်မှစ၍ နန်းတော် သားတို့ကို ကြီး သော ဘေးဒဏ် ဖြင့် ဆုံးမ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ဖါရော ဘုရင်သည်လည်း အာဗြံ ကို ခေါ် ၍ ၊ သင်သည်ငါ ၌ ပြု သောအမှု ကား အဘယ်သို့ နည်း။ သူ သည် သင် ၏မယား ဖြစ်ကြောင်း ကို ၊ ငါ အား အဘယ်ကြောင့် မ ပြော သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ငါ သည် သူ့ ကို သိမ်းပိုက် စေ ခြင်းငှါ၊ သူ သည် ငါ့ နှမ ဖြစ်သည်ဟု အဘယ်ကြောင့် ဆို သနည်း။ သင် ၏ မယား ကို ယခု ယူ ၍ သွား လော့ဟု အမိန့် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ထိုသို့အာဗြံအမှုကို စီရင်၍၊ မိမိလူ တို့အား မှာ ထားသဖြင့်၊ သူတို့သည် အာဗြံ ၌ ရှိသမျှ သော ဥစ္စာနှင့်တကွ ၊ သမီး မောင်နှံတို့ကို လွှတ်လိုက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","အာဗြံ သမီး မောင်နှံတို့သည်လည်း ၊ လောတ နှင့်တကွ မိမိ တို့၌ ရှိသမျှ သော ဥစ္စာကိုယူ၍၊ အဲဂုတ္တု ပြည်မှ ထွက်သွား သဖြင့် ၊ ခါနာန်ပြည်တောင် ပိုင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ထိုအခါ အာဗြံ သည်၊ သိုး ၊ နွားစသည်တို့ကို၎င်း၊ ရွှေ ငွေ ကို ၎င်း အလွန် ရ တတ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","တဖန် တောင် ပိုင်းမှ ခရီး သွား ၍ ၊ ဗေသလ နယ် အတွင်း ၊ ဗေသလ မြို့၊ အာဣ မြို့စပ်ကြား ၌ ၊ အထက် က တဲ ကိုဆောက်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ယဇ် ပလ္လင်ကိုတည် ခဲ့ဘူးသော အရပ် သို့ ရောက်ပြန်လျှင်၊ ထို အရပ်တွင် ထာဝရဘုရား ၏ နာမ တော်ကို ပဌနာ ပြု၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","အာဗြံ နှင့်အတူ လိုက် လာသောလောတ သည်လည်း သိုး ၊ နွား များနှင့် တဲ အများရှိ သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ထိုလူနှစ်ဦးတို့သည် အတူ နေ ခြင်းငှါ ထိုမြေ မ ဆံ့ နိုင်။ ဥစ္စာ များ လွန်း၍ ၊ သူ တို့သည် တ ရပ်တည်း မ နေ နိုင် ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","အာဗြံ ၏ နွား ကျောင်းသား၊ လောတ ၏ နွား ကျောင်းသားတို့သည်လည်း ခိုက်ရန် ပြုကြ၏။ ထိုအခါ ၊ ခါနာန် အမျိုးသား၊ ဖေရဇိ အမျိုးသားတို့သည် ထိုပြည် ၌ နေ ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","အာဗြံ ကလည်း ၊ ငါ တို့သည် ညီအစ်ကို ချင်းဖြစ်လျက်၊ ငါ နှင့် သင် ၌ ၎င်း၊ ငါ့ နွား ကျောင်းသားတို့နှင့် ၊ သင့် နွား ကျောင်းသားတို့၌ ၎င်း၊ ခိုက်ရန် မ ရှိ ပါစေနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","မြေ တပြင်လုံး သည် သင့် ရှေ့ မှာရှိသည် မ ဟုတ်လော့။ ငါ နှင့် ခွာ ၍နေပါလော့။ သင်သည် လက်ဝဲ ဘက်သို့ သွားလျှင် ၊ ငါသည် လက်ျာ ဘက်သို့သွားမည်။ သင်သည် လက်ျာ ဘက်သို့ သွားလျှင် ၊ ငါသည် လက်ဝဲ ဘက်သို့ သွားမည်ဟု ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ထိုကာလအခါ၊ သောဒုံ မြို့နှင့် ဂေါမောရ မြို့ကို ထာဝရဘုရား ဖျက်ဆီး တော်မ မူမှီ၊ ဇောရ မြို့သို့ သွား သောလမ်း၊ ယော်ဒန် မြစ် ပတ်ဝန်းကျင် အရပ်ရပ် ၌ ရေ များ၍ ထာဝရဘုရား ၏ ဥယျာဉ် တော်ကဲ့သို့ ၎င်း အဲဂုတ္တု ပြည် ကဲ့သို့ ၎င်း ဖြစ်သည်ကို၊ လောတ မြော် ကြည့် ၍ မြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ယော်ဒန် ချိုင့် တရှောက်လုံး ကို ရွေးချယ် ၍ ၊ အရှေ့ သို့ ပြောင်း သွားသဖြင့် ၊ အချင်းချင်း တ ဦးနှင့် တဦးကွဲပြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","အာဗြံ သည် ခါနာန် ပြည် ၌ နေ လေ၏။ လောတ မူကား ၊ မြစ် ပတ်ဝန်းကျင်မြို့ တို့တွင် နေ ၍ ၊ သောဒုံ မြို့ နား မှာ တဲ ကို ဆောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","သောဒုံ မြို့သား တို့သည် ဆိုး သောသူ၊ ထာဝရဘုရား ရှေ့ ၌၊ အလွန် အပြစ် များသောသူဖြစ် ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","လောတ သည် အာဗြံ နှင့် ခွါ ၍ သွားပြီးမှ ၊ ထာဝရဘုရား သည် အာဗြံကိုခေါ်၍၊ သင် ရှိသော အရပ် က၊ တောင် ၊ မြောက် ၊ အရှေ့ ၊ အနောက် သို့ မြော် ကြည့် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","သင် မြင် သော မြေ တပြင်လုံး ကို၊ သင် နှင့် သင် ၏ အမျိုး အနွယ်အား ၊ ငါသည်ကာလ အစဉ်အမြဲပေး မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","သင် ၏အမျိုး အနွယ်ကို မြေ မှုန့် ကဲ့သို့ ငါများပြားစေမည်။ သို့ဖြစ်၍ လူ သည်မြေ မှုန့် ကို ရေတွက် နိုင် လျှင် ၊ သင် ၏ အမျိုး အနွယ်ကို ရေတွက် နိုင်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","သင်ထ ၍မြေ ကို အလျား အားဖြင့် ၎င်း ၊ အနံ အားဖြင့် ၎င်း ရှောက် သွားလော့။ သင် အား ငါပေး မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","တဖန် အာဗြံ သည် တဲ ကိုပြောင်း၍ ၊ ဟေဗြုန် မြို့၊ မံရေ သပိတ်တော သို့ ရောက် မှ နေရာ ကျ၍ ထာဝရဘုရား အဘို့ ယဇ် ပလ္လင်ကို တည် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ထို ရောအခါ၊ ရှိနာ မင်းကြီး အံရဖေလ ၊ ဧလာသာ မင်းကြီး အာရုတ် ၊ ဧလံ မင်းကြီး ခေဒေါရလောမာ ၊ ဂေါအိမ် မင်းကြီး တိဒလ တို့သည်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","သောဒုံ မင်းကြီး ဗေရ ၊ ဂေါမောရ မင်းကြီး ဗိရရှ ၊ အာဓမာ မင်းကြီး ရှိနပ် ၊ ဇေဘိုင် မင်းကြီး ရှေမဘာ ၊ ဗေလာ မင်းကြီး တို့နှင့် စစ် တိုက် ကြ၏။ ဗေလပြည်ကား ၊ ဇောရ အမည်လည်းရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ထို ပြည်ရှိသမျှ တို့သည်၊ သောဒုံ အိုင် ဖြစ် သော စိဒ္ဒိမ် ချိုင့် တွင် နီးစပ် လျက်ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","တဆယ် နှစ် နှစ် ပတ်လုံးခေဒေါရလောမာ မင်းကြီးထံ ကျွန် ခံပြီးလျှင် ၊ တဆယ် သုံး နှစ် မြောက်သောအခါ ပုန်ကန် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","တဆယ် လေး နှစ် မြောက်လျှင် ၊ ခေဒေါရလောမာ မင်းသည်၊ မိမိ ဘက်ကနေသော မင်းကြီး တို့နှင့်တကွ လာ ၍ ၊ အာရှတရုတ်ကာနိမ် မြို့၌ ၊ ရေဖိမ် လူများကို၎င်း ၊ ဟာမ မြို့၌ ဇူဇိမ် လူများကို၎င်း ၊ ကိရယသိမ် ချိုင့်၌ ဧမိမ် လူများကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","စိရ တောင် ပေါ် မှာဟောရိ လူများကို၎င်း လုပ်ကြံ၍၊ တော နား မှာရှိသော ဧလပါရန် မြို့တိုင်အောင် လိုက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","တဖန် ပြန် လာ၍ ၊ ကာဒေရှ ပြည်၊ အင်မိရှပတ် မြို့သို့ ရောက် ပြီးလျှင်၊ အာမလက် ပြည် ရှိသမျှ ကို၎င်း ၊ ဟာဇဇုန္တာမာ မြို့၌ နေ သောအာမောရိ လူများကို၎င်း လုပ်ကြံ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ထိုအခါ သောဒုံ မင်းကြီး ၊ ဂေါမောရ မင်းကြီး ၊ အာဓမာ မင်းကြီး ၊ ဇေဘိုင် မင်းကြီး ၊ ဇောရ တည်း ဟူသော ဗေလာ မင်းကြီး တို့သည် ချီ ထွက်၍ စိဒ္ဒိမ် ချိုင့် ၌ စစ် ပြိုင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ထိုသို့ ဧလံ မင်းကြီး ခေဒေါရလောမာ ၊ ဂေါအိမ် မင်းကြီး တိဒလ ၊ ရှိနာ မင်းကြီး အံရဖေလ ၊ ဧလာသာ မင်းကြီး အာရုတ် တည်း ဟူသော၊ မင်းကြီး လေး ပါးနှင့်၊ မင်းကြီးငါး ပါးတို့သည် စစ်ပြိုင်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","စိဒ္ဒိမ် ချိုင့် ၌ ရေညှိ အကျိအချွဲနှင့် ပြည့်သော တွင်း များ ရှိ၏။ သောဒုံ မင်းကြီး ၊ ဂေါမောရ မင်းကြီးတို့သည် ပြေး ၍ ထို တွင်းများ၌ ကျ လေ၏။ ကြွင်း သောသူတို့သည် တောင် သို့ ပြေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","အောင်သောမင်းတို့သည်၊ သောဒုံ မြို့နှင့် ဂေါမောရ မြို့၌ ရှိသမျှ သော ဥစ္စာ နှင့် မြို့ရိက္ခါ ရှိသမျှ တို့ကို ယူ ၍ သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","သောဒုံ မြို့၌ နေ သောအာဗြံ အစ်ကို သား လောတ နှင့် သူ ၏ဥစ္စာ တို့ကိုလည်း သိမ်းယူ ၍ သွား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ထိုဘေးမှ လွတ် ၍ ပြေးသော သူတယောက်သည်၊ ဟေဗြဲ လူ အာဗြံ နှင့် မိဿဟာယ ဖွဲ့ သောသူ၊ ဧရှကောလ နှင့် အာနေရ ၏အစ်ကို အာမောရိ လူမံရေ ၏ သပိတ်တော နား မှာ နေ သောအာဗြံ ထံသို့ ရောက် ၍ ၊ သိတင်းကြား ပြောလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","အာဗြံ သည် မိမိ အစ်ကို သားကို ဘမ်း သွား ကြောင်း ကိုကြား လျှင် ၊ မိမိ အိမ် ၌ ဘွား ၍ သွန်သင် သော လူသုံး ရာ တဆယ် ရှစ် ယောက်တို့ကို စီရင် ၍ ၊ ဒန် မြို့ တိုင်အောင် လိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ညဉ့် အခါ၊ မိမိ လူ တို့ကိုခွဲ ၍ တိုက် စေသဖြင့် ၊ လုပ်ကြံ ပြီးလျှင် ၊ ဒမာသက် မြို့မြောက် ဘက် ဟောဘ မြို့ တိုင်အောင် လိုက် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ရန်သူတို့သိမ်း သွားသော ဥစ္စာ ရှိသမျှ ကို၎င်း ၊ မိမိ အစ်ကို သား လောတ နှင့် သူ ၏ဥစ္စာ ကို၎င်း ၊ မိန်းမ များ နှင့် လူ များကို၎င်း၊ တဖန် ဆောင် ယူခဲ့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ခေဒေါရလောမာ နှင့် ၊ သူ့ဘက်ကနေသောမင်းကြီး တို့ကို လုပ်ကြံ ရာမှ အာဗြံပြန် လာသောအခါ ၊ သောဒုံ မင်းကြီး သည် ခရီးဦးကြို ပြုခြင်းငှါ ရှာဝေ ချိုင့် တည်းဟူသောမင်းကြီး ချိုင့် သို့ ထွက်သွား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","အမြင့်ဆုံး သော ဘုရား သခင်၏ ယဇ် ပုရောဟိတ်ဖြစ်သော၊ ရှာလင် မင်းကြီး မေလခိဇေဒက် သည်လည်း ၊ မုန့် နှင့် စပျစ်ရည် ကို ဆောင် ခဲ့ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ကောင်းကင် မြေကြီး ရှင် ၊ အမြင့်ဆုံး သော ဘုရား သခင်သည် အာဗြံ အား ကောင်းကြီး ပေးတော်မူပါစေသောဟု၊ အာဗြံ ကို ကောင်းကြီး ပေး၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","သင် ၏ ရန်သူ တို့ကို သင် ၏လက် ၌ အပ်နှံ တော်မူသော အမြင့်ဆုံး သော ဘုရား သခင်လည်း မင်္ဂလာ ရှိတော်မူစေသတည်းဟု မြွက်ဆို ၏။ အာဗြံသည်လည်း ဥစ္စာ ရှိသမျှတို့ကို၊ ထိုမင်း အား ဆယ် ဘို့တဘို့ လှူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","သောဒုံ မင်းကြီး ကလည်း ၊ လူ တို့ကို ကျွန်ုပ် အား ပြန်ပေး ပါ၊ ဥစ္စာ တို့ကိုကား၊ ကိုယ်တိုင် ယူ ပါလော့ဟု အာဗြံ အား ပြော လိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","အာဗြံက၊မင်းကြီးသည်အာဗြံ ကိုငါ ရတတ် စေပြီဟုပြော စရာမ ရှိစေခြင်းငှါ ");
INSERT INTO myajvb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ကျွန်ုပ်နှင့်အတူလိုက်လာသောသူ၊အာနေရ၊ဧရှကောလ၊မံရေ တို့သည်မိမိ တို့အဘို့ ကိုယူ စေခြင်းငှါအခွင့်ပေးသဖြင်သူတို့ယူသောအဘို့ ကို၎င်း၊ထား၍၊မင်းကြီး၏ဥစ္စာ၊အပ်ခြည်တမျှင်ဖြစ်စေခြေနင်း ကြိုး တပင်ဖြစ်စေ၊တစုံတခု ကိုငါမ ယူ ဟု ");
INSERT INTO myajvb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ကောင်းကင် မြေကြီး ရှင်၊အမြင့်ဆုံး သောဘုရား သခင်ထာဝရဘုရား ရှေ့တော်၌၊ကျွန်ုပ် သည်လက် ကိုချီ ၍အဓိဌာန်ပြုပါပြီဟု၊သောဒုံ မင်းကြီး အား ပြောဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ထိုနောက်မှဗျာဒိတ်တော်အားဖြင့်၊ ထာဝရဘုရား ၏ နှုတ်ကပတ် တော်သည် အာဗြံ သို့ ရောက် ၍၊ အချင်းအာဗြံ ၊ မ စိုးရိမ် နှင့်။ ငါ သည် သင် ၏ အကွယ် အကာဖြစ်၏။ သင် ၏အကျိုး သည် အလွန် ကြီး လှ၏ဟု မိန့် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","အာဗြံ က၊ အရှင် ထာဝရဘုရား ၊ အကျွန်ုပ် သည် သား မရှိဘဲ သွား ရပါ၏။ ဤဒမာသက် မြို့သား ဧလျာဇာ သည် အကျွန်ုပ် ၏ အမွေခံ ဖြစ်ရပါ၏။ သို့ဖြစ်၍ အဘယ် ကျေးဇူးကို ပြု တော်မူပါမည်နည်းဟု လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","တဖန် အာဗြံ က အကျွန်ုပ် အား အမျိုး အနွယ်ကိုပေး တော်မ မူပါ။ အကျွန်ုပ် ၏ အိမ် ၌ ဘွား သောသူသည် အကျွန်ုပ် ၏ အမွေခံ ဖြစ်ရပါသည်တကားဟု လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","တဖန် ထာဝရဘုရား ၏ နှုတ်ကပတ် တော် ရောက်လာသည်ကား၊ ဤသူ သည် သင် ၏အမွေခံ မ ဖြစ်ရ။ သင် ၏ ကိုယ် ထဲက ထွက် သောသူသည် သင် ၏ အမွေခံ ဖြစ်လိမ့်မည်ဟု မိန့် တော်မူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","အာဗြံ ကိုပြင် သို့ ထုတ် ဆောင်တော်မူ၍ ၊ မိုဃ်းကောင်းကင် ကို မြော်ကြည့် လော့။ ကြယ် များကို ရေတွက် နိုင် လျှင် ရေတွက် လော့။ သင် ၏အမျိုး အနွယ်သည်ထိုသို့ ဖြစ် လိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","အာဗြံသည် ထာဝရဘုရား ကို ယုံကြည် သည် ဖြစ်၍ ၊ သူ ၏ယုံကြည်ခြင်းကို ဖြောင့်မတ် ခြင်းကဲ့သို့မှတ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","တဖန် ၊ ငါ သည် ဤ ပြည် ကို သင်အမွေခံ စရာဘို့ ၊ သင် အား ပေး လို သောငှါ၊ ခါလဒဲ ပြည်သားတို့နေသောဥရ မြို့မှ သင့် ကို ထုတ် ဆောင်သော ထာဝရဘုရား ဖြစ်သည်ဟု မိန့် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","အရှင် ထာဝရဘုရား ၊ ဤပြည်ကို အကျွန်ုပ် အမွေ ခံရမည်ကို အဘယ်သို့ သိ ရပါအံ့နည်းဟု မေးလျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ထာဝရဘုရားကလည်း၊ သုံး နှစ်အသက်ရှိသောနွား မတကောင်၊ သုံး နှစ်အသက်ရှိသောဆိတ် တကောင်၊ သုံး နှစ်အသက်ရှိသောသိုး ထီးတကောင်၊ ချိုး တကောင်၊ ခို သငယ်တကောင်တို့ကို ငါ ဘို့ ယူ လော့ဟု မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ထို တိရစ္ဆာန်အပေါင်း တို့ကို ယူ ၍ ၊ တကောင် တကောင်ကို ထက်ဝက် စီ ခွဲပြီးလျှင် ၊ ခွဲ သောအသားတို့ကို အဘက် တချက်၌ ထား လေ၏။ ငှက် ကောင်တို့ကို မ ခွဲ။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ငှက် ရဲတို့သည် အသေ ကောင်တို့ အပေါ် သို့ ဆင်း လာသောအခါ ၊ အာဗြံ သည် နှင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","နေ ဝင် သောအခါ ၊ အာဗြံ သည် ကြီး သော အိပ် ခြင်းဖြင့် အိပ်ပျော် လျက်၊ ထူသောမှောင်မိုက် နှင့် တွေ့ ၍၊ ထိတ်လန့် ခြင်းသို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ထာဝရဘုရားကလည်း၊ သင် ၏ အမျိုး အနွယ်သည်၊ သူတပါးပိုင်သောပြည် ၌ ဧည့်သည် ဖြစ် ကြသဖြင့် ၊ သူတပါး တို့၌ ကျွန် ခံခြင်း၊ နှိပ်စက် ညှဉ်းဆဲခြင်းကို အနှစ် လေး ရာ ပတ်လုံးခံရကြလိမ့်မည်ကို အမှန်သိမှတ်လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","သူတို့ကို စေခိုင်း သော လူမျိုး ကိုလည်း ငါ စီရင် မည်။ ထိုနောက်မှ ၊ သူတို့သည် များစွာ သောဥစ္စာ နှင့် ထွက် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","သင်သည်ဘိုးဘေး တို့ထံ သို့ငြိမ်ဝပ် စွာ သွား ရလိမ့်မည်။ အသက် ကြီးရင့်လျက် သင်္ဂြိုဟ် ခြင်းကိုခံရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","လူမျိုး လေး ဆက်လွန်သောအခါ ၊ သူတို့သည် ဤ ပြည်သို့ ပြန် လာကြလိမ့်မည်။ အာမောရိ အမျိုးသားတို့၏ ဒုစရိုက် အပြစ်သည် မ စုံလင် သေးဟု အာဗြံ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","တဖန် နေ ဝင် ၍ မိုက် သောအခါ ၊ ခွဲ ထားသော အသားအလယ်၌၊ မီးခိုး ထွက်သောမီးဖို ၊ မီး ထွန်းလင်းသော မီးခွက် သည် ထင်ရှားစွာ ရှောက်သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ထို နေ့ ၌ ထာဝရဘုရား သည် အာဗြံ နှင့် ပဋိညာဉ် ပြု တော်မူလျက်၊ အဲဂုတ္တု မြစ် မှစ၍ မြစ် ကြီး တည်းဟူသော၊ ဥဖရတ် မြစ် တိုင်အောင်၊ ဤ ပြည် ကို၎င်း၊. ");
INSERT INTO myajvb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ကေနိ လူ၊ ကေနဇိ လူ၊ ကာဒမောနိ လူ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ဟိတ္တိ လူ၊ ဖေရဇိ လူ၊ ရေဖိမ် လူ၊ အာမောရိ လူ၊ ခါနနိ လူ၊ ဂိရဂါရှိ လူ၊ ယေဗုသိ လူတို့ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","သင် ၏ အမျိုးအနွယ် အား ငါအပ်ပေး ပြီဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","အာဗြံ ၏ မယား စာရဲ ၌ သားဘွား ခြင်းမ ရှိသဖြင့် ၊ အဲဂုတ္တု ပြည်သူဟာဂရ အမည် ရှိသောကျွန် မတယောက် ရှိသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","စာရဲ က၊ အကျွန်ုပ် အား သားဘွား ရသောအခွင့်ကို ထာဝရဘုရား ပေးတော်မမူ။ အကျွန်ုပ် ၏ ကျွန် မထံသို့ ဝင် ပါလော့။ သူ့ အားဖြင့် အကျွန်ုပ်သည် တည်ဆောက် ခြင်း ရှိကောင်းရှိပါလိမ့်မည်ဟု အာဗြံ အား ပြောဆို ၍ ၊ အာဗြံ သည် စာရဲ ၏စကား ကို နားထောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ထိုသို့ အာဗြံ သည် ခါနာန် ပြည် ၌ ဆယ် နှစ် နေ ပြီးမှ၊ အာဗြံ ၏မယား စာရဲ သည် မိမိ ကျွန် မအဲဂုတ္တ ပြည်သူဟာဂရ ကိုယူ ၍၊ မိမိ ခင်ပွန်း အာဗြံ သိမ်းပိုက် စေဘို့ အပ်နှင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","အာဗြံသည်လည်း ဟာဂရ ထံသို့ ဝင် ၍ ၊ ဟာဂရသည် ပဋိသန္ဓေ စွဲလေ၏။ ဟာဂရသည် မိမိတွင် ပဋိသန္ဓေ စွဲနေကြောင်း ကို သိ လျှင်၊ မိမိ သခင် မကို မထီမဲ့မြင် ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","စာရဲ ကလည်း အကျွန်ုပ် ခံရ သောအပြစ်သည် ကိုယ်တော် ခေါင်းပေါ် ၌ တည်ရှိပါစေ။ အကျွန်ုပ် ၏ ကျွန် မကို ကိုယ်တော် ရင်ခွင် ၌ အကျွန်ုပ် အပ်နှင်း ပါပြီ။ သူသည် ကိုယ်၌ပဋိသန္ဓေ စွဲနေကြောင်း ကို သိ လျှင်၊ အကျွန်ုပ်ကို မထီမဲ့မြင် ပြုပါသည်တကား။ ထာဝရဘုရား သည် အကျွန်ုပ် နှင့် ကိုယ်တော် အမှု ကို စီရင် တော်မူပါစေ သောဟု၊ အာဗြံ အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","အာဗြံ ကလည်း ၊ သင် ၏ ကျွန် မသည် သင် ၏လက် ၌ ရှိ၏။ သူ ၌ ပြု ချင်သမျှပြု ပါလော့ဟု စာရဲ အား ပြန်ပြော လျှင်၊ စာရဲ သည် ကျွန် မကို ညှဉ်းဆဲ သဖြင့် ၊ ကျွန်မသည် သခင် မထံမှ ထွက် ပြေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် ရှုရ မြို့သို့သွားရာတော လမ်း ၌ရှိသောစမ်း ရေ တွင်း နား မှာ ဟာဂရ ကိုတွေ့ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","စာရဲ ကျွန် မဟာဂရ ၊ အဘယ် က လာ သနည်း။ အဘယ် အရပ်သို့ သွား မည်နည်းဟုမေးသော်၊ ကျွန်မ သည် သခင် မစာရဲ ထံမှ ပြေး လာပါသည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ထာဝရဘုရား ၏ ကောင်းကင် တမန်ကလည်း ၊ သင် ၏ သခင် မထံသို့ ပြန် ၍ ၊ သူ ၏အုပ်စိုး ခြင်းကိုခံ လော့ဟု အမိန့် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","တဖန် ထာဝရဘုရား ၏ ကောင်းကင် တမန်က၊ သင် ၏ အမျိုးအနွယ် ကို မ ရေတွက် နိုင်အောင်၊ ငါအလွန် များပြား စေမည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","သင် သည် ကိုယ်ဝန် ဆောင်သည်ဖြစ်၍ ၊ သား ယောက်ျားကို ဘွားမြင် လိမ့်မည်။ ထို သားကို ဣရှမေလ အမည် ဖြင့် မှည့် ရမည်။ အကြောင်းမူကား ၊ ထာဝရဘုရား သည် သင် ၏ ဆင်းရဲ ဒုက္ခကို ကြား သိတော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","သူ သည်လူ ရိုင်း ဖြစ် လိမ့်မည်။ လူ အပေါင်းတို့ကို ရန်ဘက်ပြုလိမ့်မည်။ သူ့ ကိုလည်း လူအပေါင်း တို့သည် ရန်ဘက်ပြုကြလိမ့်မည်။ မိမိ ညီအစ်ကို အပေါင်း တို့၏ အပါး ၌ နေ ရလိမ့်မည်ဟူ၍၎င်း မြွက်ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ထိုသို့ မိန့် မြွက်တော်မူသောထာဝရဘုရား ကို၊ အာတောဧလရော ဟူသောအမည် ဖြင့် ခေါ်ဝေါ် ၍၊ ငါ့ ကိုမြင် တော်မူသောသူကို ဤ အရပ်၌ပင် ငါဖူး မြင်ရသည်တကားဟု ဟာဂရဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ထို အကြောင်းကိုအစွဲပြု၍၊ ထို ရေတွင်းကို ဗေရလဟဲရော ဟု သမုတ် ကြ၏။ ကာဒေရှ မြို့နှင့် ဗေရက် မြို့၏စပ်ကြား မှာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ထိုနောက် ဟာဂရ သည် အာဗြံ အား သား ကို ဘွားမြင် ၏။ အာဗြံ လည်း ဟာဂရ တွင် မြင် သော သား ကို ဣရှမေလ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","အာဗြံ သည် သား ဣရှမေလ ကို ဟာဂရ ဘွားမြင် သောအခါ ၊ အသက် ရှစ် ဆယ်ခြောက် နှစ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ထိုနောက် ၊ အာဗြံ သည် အသက် ကိုး ဆယ်ကိုး နှစ် ရှိ သောအခါ ၊ ထာဝရဘုရား သည် အာဗြံ အား ထင်ရှား တော်မူ၍ ၊ ငါ သည် အနန္တ တန်ခိုးရှင် ဘုရား သခင်ဖြစ်၏။ ငါ့ ရှေ့ မှာ သွား လာ၍ စုံလင် ခြင်းရှိ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ငါ ၏ ပဋိညာဉ် ကို သင် နှင့် ငါပြု မည်။ သင့် ကို ငါအလွန် များပြား စေမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","အာဗြံ သည်လည်း ပြပ်ဝပ် လျင် ၊ ဘုရား သခင်က၊ ");
INSERT INTO myajvb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","ငါ ပြုသော ပဋိညာဉ် သည် သင် ၌ ရှိ၏။ သင်သည် လူမျိုး အများ တို့၏ အဘ ဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","နောက်တဖန် သင် ၏ အမည် ကို အာဗြံ ဟုမ ခေါ် ရ။ သင် ၏အမည် ကို အာဗြံဟံ ဟုခေါ်ရ၏။ အကြောင်းမူကား ၊ ငါသည် သင့် ကို များ စွာသော လူ အမျိုးတို့၏ အဘ အရာ၌ ခန့်ထား ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ငါသည် သင့် ကို အလွန် ပွား များစေမည်။ သင် အားဖြင့်လူအမျိုးမျိုးတို့ကို ဖြစ် စေမည်။ သင် ၏ အမျိုးအနွှယ် ၌ လည်း ရှင်ဘုရင် ဖြစ် ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ငါသည်သင်၏ဘုရား၊ သင့် နောက် ၌ သင့် အမျိုးအနွယ် ၏ ဘုရား ဖြစ်မည်ဟု၊ သင် နှင့် သင် ၏ အမျိုးအနွှယ် အစဉ် အဆက်တို့၌ ၊ ငါ့ ပဋိညာဉ် ကို ထာဝရ ပဋိညာဉ် ဖြစ် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","သင် သည် ယခုဧည့်သည် ဖြစ်၍နေသောပြည် တည်းဟူသော၊ ခါနာန် ပြည် တရှောက်လုံး ကို၊ သင် အား ၎င်း ၊ သင့် နောက် ၌သင် ၏အမျိုးအနွယ် အား ၎င်း ၊ အစဉ်အမြဲ အပိုင် ပေး မည်။ သူ တို့၏ ဘုရား လည်း ငါဖြစ် မည်ဟု မိန့်မြွက်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","တဖန် ဘုရား သခင်က၊ သို့ဖြစ်၍ သင် နှင့်တကွ သင့် နောက် ၌ သင် ၏အမျိုးအနွယ် အစဉ် အဆက်တို့သည်၊ ငါ ၏ပဋိညာဉ် ကို စောင့်ရှောက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","သင် နှင့်တကွ သင့် နောက် ၌ သင် ၏အမျိုးအနွယ် သည်၊ ငါ့ ရှေ့မှာ စောင့်ရှောက် ရသောငါ ၏ ပဋိညာဉ် ဟူမူကား ၊ သင် တို့တွင် သား ယောက်ျားတိုင်း အရေဖျား လှီးမင်္ဂလာကို ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","အရေဖျား လှီးမင်္ဂလာသည်၊ ငါ နှင့် သင် တို့ပြုသောပဋိညာဉ် ၏ လက္ခဏာ သက်သေဖြစ် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","သင် တို့အမျိုး အစဉ်အဆက်တို့၌ သား ယောက်ျားတိုင်း ၊ ကိုယ်အိမ် ၌ဘွား သောသူဖြစ်စေ၊ ကိုယ့် အမျိုး မ ဟုတ်။ တပါး အမျိုးသား၌ ငွေ နှင့်ဝယ် သောသူ ဖြစ်စေ ၊ အသက်ရှစ် ရက် မြောက်လျှင် ၊ အရေဖျား လှီး မင်္ဂလာကို ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ကိုယ် အိမ် ၌ ဘွား သောသူ၊ ကိုယ် ငွေ နှင့်ဝယ် သောသူသည်၊ အရေဖျား လှီးမင်္ဂလာကို ခံရမည်။ ငါ့ ပဋိညာဉ် လည်း သင် တို့၏အသား ၌ ထာဝရ ပဋိညာဉ် ဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","အရေဖျား မလှီး၊ အရေဖျား လှီးမင်္ဂလာကို မ ခံသောသား ယောက်ျားကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရ၏။ ထို သူ သည် ငါ့ ပဋိညာဉ် ကို ဖျက် လေပြီဟု အာဗြံဟံ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","တဖန် ဘုရား သခင်က၊ သင် ၏မယား စာရဲ ကို မူကား၊ စာရဲ ဟူသောအမည် ဖြင့်မ ခေါ် ရ၊ စာရာ ဟူသောအမည် ဖြင့်ခေါ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","သူ့ ကိုငါကောင်းကြီး ပေး၍ ၊ သူ့ အားဖြင့် လည်း သင် အား သား ကိုပေး မည်။ အကယ်စင်စစ်သူ့ ကို ကောင်းကြီး ပေး၍ ၊ သူသည် လူအမျိုးမျိုးဖြစ်လိမ့်မည်။ သူ ၏အမျိုးအနွယ် ၌ လည်း အပြည် ပြည်သော ရှင်ဘုရင် ဖြစ် ကြ လိမ့်မည်ဟု၊ အာဗြဟံ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ထိုအခါ အာဗြဟံ သည် ပြပ်ဝပ် လျက် အသက် တ ရာရှိသောသူသည် သား ကို ရ လိမ့်မည်လော။ အသက် ကိုး ဆယ်ရှိသောစာရာ သည် သား ကိုဘွား လိမ့်မည်လော ဟု ရယ် လျက် ၊ စိတ် နှလုံးထဲမှာ အောက်မေ့ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ဣရှမေလ သည် ရှေ့ တော်၌ အသက်ရှင် ပါစေသောဟု၊ ဘုရား သခင်ကို လျှောက် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ဘုရား သခင်က၊ သင် ၏မယား စာရာ သည် သင် အား သား ကိုဘွား လိမ့်မည်။ ထို သားကိုလည်း ဣဇာက် အမည် ဖြင့် မှည့် ရမည်။ သူ ၌ ၎င်း သူ့ နောက်မှ သူ ၏ အမျိုးအနွယ် ၌ ၎င်း ငါ ၏ပဋိညာဉ် ကို ထာဝရ ပဋိညာဉ် ဖြစ်စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ဣရှမေလ အမှု၌ ကား ၊ သင် ၏စကားကို ငါနားထောင် ၏။ သူ့ ကို ငါကောင်းကြီး ပေး၏။ သူ့ အနွှယ်ကို တိုးပွား စေ၍ သူ့ ကို အလွန် များပြား စေမည်။ သူသည် မင်း သားဆယ် နှစ် ပါးတို့၏အဘ ဖြစ်လိမ့်မည်။ ကြီး သော လူမျိုး ဖြစ် စေခြင်းငှါလည်း ငါပြု မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","သို့သော်လည်း ၊ နောင် နှစ် ၊ ချိန်းချက် သောအချိန်တွင်၊ စာရာ သည် သင် အား ဘွား လတံ့သော သားဣဇာက် ၌ ၊ ငါ ၏ပဋိညာဉ် ကို ငါတည် စေမည်ဟု မိန့် တော်မူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","မိန့် မြွက်တော်မူသံငြိမ်း ၍ ဘုရား သခင်သည် အာဗြံဟံ မှ တက် ကြွတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","အာဗြဟံ သည်လည်း ၊ သား ဣမေလ မှစ၍ ၊ ကိုယ် အိမ် ၌ ဘွား သော သူအပေါင်း ၊ ကိုယ် ငွေ နှင့် ဝယ် သော သူအပေါင်း တည်းဟူသော ၊ အာဗြဟံ အိမ် နှင့်ဆိုင်သော ယောက်ျား အပေါင်း တို့ကို ယူ၍၊ ဘုရား သခင်မိန့် တော်မူသည် အတိုင်း ၊ တ နေ့ခြင်းတွင် အရေဖျား လှီးမင်္ဂလာကို ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","အာဗြဟံ သည် ကိုယ်တိုင် အရေဖျား လှီးမင်္ဂလာကို ခံသောအခါ ၊ အသက် ကိုး ဆယ်ကိုး နှစ်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","သား ဣရှမေလ သည် အရေဖျား လှီး မင်္ဂလာကို ခံသောအခါ ၊ အသက် တ ဆယ်သုံး နှစ်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","တ နေ့ခြင်းတွင် အာဗြဟံ နှင့် သား ဣရှမေလ သည် အရေဖျား လှီးမင်္ဂလာကို ခံလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","သူ ၏အိမ် ၌ ဘွား သော သူတပါး အမျိုးသား၌ သူ၏ငွေ နှင့် ဝယ် သောသူ၊ သူ၏အိမ် နှင့်ဆိုင်သော ယောက်ျား အပေါင်း တို့သည်၊ သူ နှင့်အတူ အရေဖျား လှီး မင်္ဂလာကို ခံကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ထာဝရဘုရား သည် မံရေ သပိတ် တောနား မှာ၊ အာဗြဟံ အား ထင်ရှား တော်မူသည် အကြောင်းအရာဟူမူကား ၊ နေ ပူ သောအချိန်တွင် အာဗြဟံသည် တဲ တံခါးဝ ၌ ထိုင် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","မြော် ကြည့် ၍ ၊ မိမိ ရှေ့ မှာ လူ သုံး ယောက် ရပ် နေကြသည်ကို မြင် သောအခါ ၊ ခရီးဦးကြိုပြု ခြင်းငှါ တဲ တံခါးဝ မှ ပြေး ၍ မြေ သို့ ဦးညွတ် ချလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","အကျွန်ုပ်သခင် ၊ ရှေ့ တော်၌ အကျွန်ုပ်သည် မျက်နှာ ရလျှင် ကိုယ်တော် ကျွန် မှ လွန် ၍ မ သွားပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ရေ အနည်းငယ် ကို ယူ ခဲ့ပါရစေ။ ခြေ ကို ဆေး ပြီးလျှင် သစ်ပင် အောက် ၌ လျောင်း နေကြပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","မုန့် အနည်းငယ် ကိုလည်း ယူ ခဲ့ပါမည်။ အမောအပန်း ပြေသောအခါ သွား ကြပါလော့။ ထိုသို့ သော ကျေးဇူးတော်ကိုခံ စေခြင်းငှါ၊ ကိုယ်တော် ကျွန် ရှိရာသို့ ရောက် ပါပြီဟုဆို၏။ ထိုသူတို့ကလည်း ၊ ပြော သည်အတိုင်း ပြု ပါလော့ဟုဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","အာဗြဟံ သည်လည်း ၊ တဲ အတွင်း ၌ရှိသောစာရာ ဆီသို့ အလျင်အမြန် ဝင်ပြီးလျှင် ၊ ဂျုံမုန့်ညက် သုံး စလယ် ကို အသော့ ပြင်၍နယ် ပါ။ ပေါင်မုန့် ကို လုပ် ပါဟုဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","တဖန် နွား စုသို့ ပြေး ၍ နုထွား ကောင်းမွန်သော နွားသငယ် ကို ယူခဲ့၍၊ လုလင် ၌ အပ် သဖြင့် မြန်မြန် ပြင်ဆင် စေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ထိုနောက် နို့ နှင့် နို့ဓမ်း ကို၎င်း၊ ပြင်ဆင် သော နွား သငယ် ကို၎င်း ယူ ၍၊ ထိုသူ တို့ရှေ့ ၌ ထည့် ပြီးလျှင် ၊ သစ်ပင် အောက် ၊ သူ တို့အနား မှာရပ် နေ၍ ၊ သူတို့သည် စား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ပြီး သောအခါ၊ သင် ၏ မယား စာရာ သည် အဘယ် မှာရှိသနည်းဟုမေး ကြလျှင်၊ တဲ အတွင်း ၌ ရှိပါသည်ဟု ပြန် ပြော၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ထိုသူတို့တွင် တပါးကလည်း၊ ဘွားချိန်စေ့သောအခါ၊ ငါသည် သင့် ဆီသို့ ဆက်ဆက်ပြန်လာ ဦးမည်။ ထိုအခါ သင် ၏မယား စာရာ သည် သား ကို ရလိမ့်မည်ဟု ပြောဆို၏။ ထိုသို့ဆိုသောသူ ၏နောက် ၌ တံခါးဝ အနား မှာ၊ စာရာရှိသောကြောင့်ထိုစကားကိုကြား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ထိုအခါ အာဗြဟံ နှင့် စာရာ သည် အသက် အရွယ် ကြီးရင့်လှပြီ။ စာရာ သည် မိန်းမ တို့၌ ဥတုရောက် မြဲ ရှိသည့်အတိုင်း မ ရောက်ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ထိုကြောင့် စာရာ က၊ ငါ လည်းအို ပြီ၊ ငါ့ သခင် လည်း အို ပြီ၊ သို့ဖြစ်၍ငါ သည် ပျော်မွေ့ ခြင်းရှိလိမ့်မည် လောဟု ဆိုလျှက်၊ တိတ်ဆိတ်စွာ ရယ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","သင်၏မယားစာရာ က၊ အကယ်၍ငါ သည် အို ပြီး မှ၊ သားကို ဘွား လိမ့်မည်လောဟုဆို လျက် ၊ အဘယ်ကြောင့် ရယ် သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ထာဝရဘုရား မ တတ်နိုင်သောအမှု တစုံတခု ရှိသလော။ ချိန်းချက်သော ဘွားချိန် စေ့သောအခါ ၊ သင့် ဆီသို့ ငါပြန် လာ၍၊ စာရာ သည် သား ကို ရလိမ့်မည်ဟု ထာဝရဘုရား သည် အာဗြဟံ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","စာရာ ကလည်း ကျွန်မမ ရယ် ပါဟု၊ ကြောက် ၍ ငြင်း လေ၏။ မဟုတ် ဘူး။ သင်ရယ် ပြီဟုမိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ထိုလူ တို့သည် ထို အရပ်က ထ ၍ သောဒုံ မြို့သို့ မျက်နှာ ပြုလျက် သွားကြ၏။ အာဗြဟံ သည်လည်း သူ တို့ ကို ပို့ ခြင်းငှါ လိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ထာဝရဘုရား ကလည်း ၊ ငါ ပြု မည်အမှုကို အာဗြဟံ အား မဘော်မပြဘဲ ဝှက် ထားရမည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","အာဗြဟံ သည် ကြီးမြတ် ၍ ၊ တန်ခိုး နှင့်ပြည့်စုံသော လူမျိုး ဖြစ် လိမ့်မည်။ လူမျိုး အပေါင်း တို့သည် သူ့ အားဖြင့် ကောင်းကြီး မင်္ဂလာကို ခံရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","အကြောင်းမူကား ၊ သူ သည် မိမိ နောက် ၌ ဖြစ်သော သား များ၊ အိမ်သူ များတို့အား ပညတ် မည့်အရာကို ငါသိ၏။ သူတို့သည်လည်း ထာဝရဘုရား ၏ တရား လမ်းသို့ လိုက် ၍ ဟုတ်မှန် ဖြောင့်မတ် ကျင့် ကြ လိမ့်မည်။ သို့ဖြစ်၍ ဂတိတော် ရှိသည့်အတိုင်း ၊ ထာဝရဘုရား သည် အာဗြဟံ ၌ ပြုရသော အခွင့်ရှိလိမ့်မည်ဟု အကြံတော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","တဖန် ထာဝရဘုရား က၊ သောဒုံ မြို့၊ ဂေါမောရ မြို့၌ ကြွေးကြော် သော အသံသည်ကြီး၍၊ အလွန် အပြစ် လေးသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ယခု ငါသွား ၍ ငါ့ ရှေ့သို့ရောက် ခဲ့ပြီးသော ကြွေးကြော် ခြင်းရှိသည်အတိုင်း ၊ သူတို့သည် အမှန်ပြုသည် မ ပြုသည်ကို ငါကြည့်ရှု မည်။ မ ပြု လျှင် မပြုကြောင်း ကို ငါသိ မည် ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ထိုသူတို့သည် ထို အရပ်မှ မျက်နှာလှည့် ၍ သောဒုံ မြို့သို့ သွား ကြ၏။ အာဗြံဟံ မူကား ၊ ထာဝရဘုရား ရှေ့တော်၌ ရပ် နေလျက်ရှိ သေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ထိုအခါ အာဗြဟံ ချဉ်းကပ် ၍ ၊ ကိုယ်တော်သည် ဖြောင့်မတ် သောသူတို့ ကို၊ မတရား သောသူတို့ နှင့်တကွ ဖျက်ဆီး တော်မူမည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ထိုမြို့ တွင် ဖြောင့်မတ် သောသူငါး ဆယ်ရှိ လျှင် ၊ ဖျက်ဆီး တော်မူမည်လော။ ဖြောင့်မတ် သောသူ ငါး ဆယ်ပါသောမြို့ကို သူ တို့အတွက် မ နှမြော ဘဲ ဖျက်ဆီးတော်မူ မည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ထိုသို့ ပြု ၍ ဖြောင့်မတ် သောသူတို့ ကို မတရား သောသူတို့ နှင့်တကွ ကွပ်မျက် ခြင်းအမှုသည် ကိုယ်တော် နှင့် ဝေး ပါစေသတည်း။ ဖြောင့်မတ် သောသူတို့ ကို မတရား သောသူတို့ကဲ့သို့ ခံ စေသောအမှု သည် ကိုယ်တော် နှင့် ဝေး ပါစေသတည်း၊ မြေကြီး လုံး ကို စီရင် တော်မူသောသခင်သည်၊ တရား သဖြင့် ပြု တော်မူမည် မ ဟုတ်လောဟု လျောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ထာဝရဘုရား ကလည်း ၊ သောဒုံ မြို့၌ ဖြောင့်မတ် သောသူငါး ဆယ်ကို ငါတွေ့ လျှင် ၊ သူ တို့အတွက် ထိုအရပ် လုံး ကို ငါနှမြော မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","တဖန် အာဗြဟံ က၊ အကျွန်ုပ် သည် မြေ မှုန့်နှင့် ပြာ သက်သက်ဖြစ်သော်လည်း ၊ ဘုရား ရှင်ကို ယခု လျှောက် မည်ဟု အားထုတ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ဖြောင့်မတ် သောသူ ငါး ဆယ်တို့တွင် ငါး ယောက်မ ပြည့်လျှင် ၊ ထိုငါး ယောက်မပြည့်သော အတွက်ကြောင့်၊ ထိုမြို့ လုံး ကို ဖျက်ဆီး တော်မူမည်လောဟု မေးလျှောက်ပြန်သော်၊ ထို မြို့၌ လေး ဆယ့်ငါး ယောက်ကို ငါတွေ့ လျှင် ၊ ငါမ ဖျက်ဆီး ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","တဖန် တုံ၊ ထိုမြို့၌ လေး ဆယ်ကိုတွေ့ကောင်းတွေ့ တော်မူလိမ့်မည်ဟု လျှောက် ဆိုပြန်လျှင် ၊ ထိုလေး ဆယ်အတွက် ငါမ ပြု ဘဲနေမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","တဖန် တုံ၊ အိုဘုရား ရှင်၊ စိတ် ရှိတော်မ မူပါနှင့်၊ အကျွန်ုပ် လျှောက် ပါရစေ။ ထို မြို့၌သုံး ဆယ်ကို တွေ့ ကောင်းတွေ့ တော်မူလိမ့်မည်ဟု လျှောက် ဆိုပြန်လျှင် ၊ ထို မြို့၌ သုံး ဆယ်ကိုငါတွေ့ လျှင် ၊ ငါမ ပြု ဟုမိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","တဖန်တုံ ၊ အကျွန်ုပ်သည် ထာဝရ ဘုရားကို ယခု လျှောက် မည်ဟု အားထုတ် ပါ၏။ ထို မြို့၌ နှစ် ဆယ်ကို တွေ့ကောင်းတွေ့ တော်မူလိမ့်မည်ဟု လျှောက် ဆိုပြန်လျှင် ၊ နှစ် ဆယ်အတွက် ငါမ ဖျက်ဆီး ဘဲနေမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","အိုဘုရား ရှင်၊ စိတ် ရှိတော်မ မူပါနှင့်။ သည် တကြိမ် အကျွန်ုပ်လျှောက် ပါရစေဦး။ ထို မြို့၌ တ ဆယ်ကို တွေ့ကောင်းတွေ့ တော်မူလိမ့်မည်ဟု လျှောက် ဆိုပြန်လျှင် ၊ တ ဆယ်အတွက် ငါမ ဖျက်ဆီး ဘဲနေမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ထာဝရဘုရား သည် အာဗြံဟံ နှင့် နှုတ်ဆက် ခြင်း အမှုကုန်စင် ပြီးမှကြွ သွားတော်မူ၏။ အာဗြံဟံ သည် လည်း မိမိ နေရာ အရပ်သို့ ပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ကောင်းကင် တမန်နှစ် ပါးတို့သည် ညဦး အချိန်၌ သောဒုံ မြို့သို့ ရောက် လာ၏။ လောတ သည် မြို့ တံခါးဝ ၌ ထိုင် လျက် သူ တို့ကိုမြင် လျှင် ၊ ခရီးဦးကြိုပြု ခြင်းငှါ ထ ၍ မြေ ၌ ဦးညွှတ် ချလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","အကျွန်ုပ် သခင် တို့၊ ကိုယ်တော် တို့ ကျွန် ၏အိမ် သို့ ဝင် ၍ တညဉ့် လုံးနေကြပါ။ ခြေ ကိုဆေး ကြပါ။ နံနက်စောစော ထ၍ ကြွ သွားကြပါလော့ဟု ဆို လေ၏။ ကောင်းကင်တမန်တို့က၊ ငါတို့သည်မဝင်၊ တညဉ့် လုံးလမ်း ၌ နေတော့မည်ဟု ဆို သော်လည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ကျပ်ကျပ် သွေးဆောင် သောကြောင့် တဖန် လောတနေရာသို့ လှည့်၍ သူ ၏အိမ် သို့ ဝင် ကြ၏။ လောတ လည်း သူ တို့အဘို့ ပွဲ လုပ်၍ တဆေးမပါသော မုန့် ကို ပေါင်း ပြီးမှသူတို့သည်စား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ထိုသူတို့သည် မ အိပ် မှီ သောဒုံ မြို့ သား ယောက်ျား အကြီးအငယ်၊ အရပ်ရပ်ကလာသော သူ အပေါင်း တို့သည် အိမ် ကို ဝိုင်း ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","လောတ ကို ဟစ် ခေါ်လျက် ယနေ့ည မှာ သင့် အိမ်သို့ ဝင် သော လူ တို့သည် အဘယ် မှာရှိသနည်း။ ထိုသူ တို့နှင့်ငါတို့သည် ဆက်ဆံ လိုသည် ဖြစ်၍ ငါ တို့ထံသို့ ထွက် စေလော့ဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","လောတ သည်လည်း၊ တံခါး ပြင် မှာ သူ တို့ထံသို့ ထွက် ၍ ၊ မိမိ နောက် ၌ တံခါးကို ပိတ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ညီအစ်ကို တို့၊ အဓမ္မ အမှုကို ဤ မျှလောက်မ ပြုကြပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","အကျွန်ုပ် ၌ ယောက်ျား နှင့် မ ဆက်ဆံ သော သမီး နှစ် ယောက်ရှိပါ၏။ သူ တို့ကို သင် တို့ထံသို့ ထုတ် ရသောအခွင့်ကိုပေးကြပါလော့။ သူ တို့၌ ပြု ချင် သမျှပြုကြပါလော့။ ဤလူ တို့ ၌ အလျှင်မ ပြု ကြပါနှင့်။ အကြောင်းမူကား၊ သူ တို့သည် အကျွန်ုပ် အိမ် မိုးအရိပ် ကို ခို နေပါ၏ဟု တောင်းပန်သော်လည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","သူတို့က ဆုတ် လော့ဟုဆို ကြ၏။ တဖန် ကား၊ သင်သည် တည်းခို ခြင်းငှာ သာရောက် လာသည်နှင့် တရားသူကြီး လုပ်ရမည်လော။ ယခု မှာ ထို သူတို့၌ ပြု သည်ထက် ၊ သင် ၌ သာ၍ဆိုးသောအမှုကိုပြုမည်ဟုဆိုလျက်၊ လောတ ကို ကျပ်ကျပ် ဖိ ၍ တံခါး ကိုလည်း ပေါက် ခွဲချိုးဖဲ့ ခြင်းငှါ ချဉ်း လာကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ထိုအခါ ကောင်းကင်တမန်တို့သည် လက် ကိုဆန့် ၍ လောတ ကို မိမိ တို့နေရာအိမ် အတွင်း သို့ ဆွဲ သွင်း ပြီးလျှင် တံခါး ကို ပိတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","အိမ် တံခါး နားမှာ ရှိသောသူ အကြီး အငယ် တို့ကို မျက်စိ ကန်းစေခြင်းငှါ ဒဏ်ခတ် သဖြင့် သူတို့သည် တံခါး ကိုရှာ ၍ ပင်ပန်း ခြင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ကောင်းကင်တမန်တို့ကလည်း၊ ဤ အရပ်၌ သင် နှင့် ဆိုင်သောသူ ရှိ သေးသလော။ သားသမီး ၊ သမက် ၊ မြို့ ထဲမှာ သင် ၌ ရှိသမျှ ကို ဤအရပ် က ထုတ် ဆောင် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ဤ အရပ် ကို ငါ တို့သည် ဖျက်ဆီး ရမည်။ အကြောင်းမူကား ၊ အရပ်သားတို့သည် ထာဝရဘုရား ရှေ့ တော်မှာ အလွန် ကြွေးကြော် ခြင်းရှိသည်ဖြစ်၍ ၊ ဖျက်ဆီး စေခြင်းငှါ ထာဝရဘုရား သည် ငါ တို့ကို စေလွှတ် တော်မူပြီဟု လောတ အား ပြော ဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","လောတ ထွက် ၍ သမီး နှင့်စုံဘက် သောသူ၊ မိမိ သမက် တို့အား ထကြ ၊ ဤ အရပ် မှ ထွက်သွား ကြ၊ ဤ မြို့ကို ထာဝရဘုရား ဖျက်ဆီး တော်မူမည်ဟုဆို သော်လည်း ၊ ကျီစား ဟန် သည်ဟု သမက် တို့ ထင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","မိုဃ်းသောက် သောအခါ ၊ ကောင်းကင် တမန် တို့သည် လောတ ကို ဆော် လျက် ၊ သင် သည်ထ ၍ ဤအရပ်၌ရှိသောမယား နှင့် သမီး နှစ် ယောက်တို့ကို ယူ သွားလော့။ သို့မဟုတ် ၊ မြို့ ၏အပြစ် ၌ ဆုံး ခြင်းသို့ ရောက် လိမ့်မည်ဟု ဆိုသော်လည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","သူသည်ဖင့်နွှဲ သောအခါ ထာဝရဘုရား သနား တော်မူသောကြောင့် ကောင်းကင်တမန်တို့သည် သူ နှင့် သူ ၏ မယား ၊ သူ ၏သမီး နှစ် ယောက်တို့ကို လက် ဆွဲ ၍ မြို့ ပြင် သို့ ထုတ် ဆောင်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ပြင် သို့ ရောက် သောအခါ၊ သင် သည် အသက် ချမ်းသာ ရခြင်းငှါ ပြေးလော့။ နောက် သို့လှည့်၍ မ ကြည့် နှင့် မြေညီသောအရပ် ၌ အလျှင်း မ နေ နှင့်။ တောင် ပေါ်သို့ ပြေး လော့။ သို့မဟုတ် ဆုံး လိမ့်မည်ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","လောတ ကလည်း ၊ အကျွန်ုပ် သခင် ထိုသို့မ ဆိုပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ယခု မှာ ကိုယ်တော် ကျွန် သည် ရှေ့ တော်၌ မျက်နှာ ရပါပြီ။ အကျွန်ုပ် အသက် ချမ်းသာစေ သဖြင့်၊ အကျွန်ုပ်၌ ပြု တော်မူသောကရုဏာ ကျေးဇူးများပြား လှပါ၏။ ဘေးလွတ်၍ တောင် ပေါ် သို့ မ ပြေး နိုင်ပါ။ ဘေး တစုံတခု တွေ့ ၍ သေ မည်ကို စိုးရိမ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ကြည့် ပါ။ ထို မြို့ နီး ပါ၏၊ပြေး သာပါ၏။ ငယ် သောမြို့လည်း ဖြစ်ပါ၏။ ဘေးလွတ်၍ ထို အရပ်သို့ ပြေး ပါရစေ။ ထို မြို့သည် ငယ် သောမြို့မ ဟုတ်လော။ သို့ပြေးလျှင် အသက် ချမ်းသာရပါမည်ဟု လျှောက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ထိုသူ ကလည်း ၊ ကြည့် ပါ။ ဤ အမူအရာ၌လည်း သင်၏ စကား ကို ငါနား ထောင်စေခြင်းငှါ ထိုမြို့ အတွက် တောင်းပန် သောကြောင့် ငါမ ဖျက်ဆီး။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ဘေးလွတ်ခြင်းငှါထို မြို့သို့ အလျင်အမြန် ပြေး လော့။ ထို မြို့သို့ မ ရောက် မှီ ငါသည် အဘယ်အမှု ကိုမျှ မ ပြု နိုင်ဟုဆို လေ၏။ ထိုကြောင့် ထိုမြို့ ကို ဇောရ မြို့ဟု သမုတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","လောတ သည် ဇောရ မြို့သို့ ဝင် သောအခါ ၊ မြေကြီး ပေါ် မှာ နေ ထွက် ချိန်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ထိုအခါ ထာဝရဘုရား သည် ကောင်းကင် ထက် ၊ အထံတော်မှ သောဒုံ မြို့နှင့် ဂေါမောရ မြို့အပေါ် သို့ ကန့် နှင့် မီး မိုဃ်း ကို ရွာစေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ထို မြို့ တို့ကို၎င်း ၊ ချိုင့်အရပ် တရှောက်လုံး ကို၎င်း၊ မြို့ သား အပေါင်း တို့ကို၎င်းမြေ ၌ ပေါက် သမျှကို၎င်း၊ မှောက် လဲတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","လောတ ၏ မယား မူကား နောက် သို့ လှည့်ကြည့် ၍ ဆား တိုင် ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","နံနက် စောစောအာဗြဟံ သည် ထ ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ရပ် နေသောအရပ် သို့ သွားပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","သောဒုံ မြို့နှင့် ဂေါမောရ မြို့မှစသော ချိုင့် အရပ် တရှောက်လုံး ကို ကြည့်ရှု ၍ ၊ မီးဖို ၌ အခိုး ကဲ့သို့ ၊ တပြည် လုံးအခိုး တက် သည်ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ထိုသို့ ဘုရား သခင်သည် ချိုင့်ထဲမှာ ရှိ သောမြို့ တို့ကို ဖျက်ဆီး သောအခါ အာဗြံဟံ ကို အောက်မေ့ တော်မူ ၏။ လောတ နေ သောမြို့ တို့ကို မှောက် လှဲသောအခါ မှောက် လှဲရာထဲက လောတ ကို လွှတ် လိုက်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","လောတ သည် ဇောရ မြို့မှ ထွက် ၍ ၊ သမီး နှစ် ယောက်နှင့်တကွ တောင် ပေါ် မှာနေ ၏။ ဇောရ မြို့၌ မ နေ ဝံ့၍ ၊ သမီး နှစ် ယောက်နှင့်တကွ ဥမှင် ၌ နေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","သမီးအကြီး က၊ ငါ တို့အဘ အို ပြီး မြေကြီး သား အပေါင်း တို့၏ ဘာသာအတိုင်း ငါ တို့ထံသို့ဝင်ရသောယောက်ျား တယောက် မျှ မြေပေါ်မှာ မရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","လာကြ။ ငါ တို့အဘ ကိုစပျစ်ရည် တိုက် ကြစို့။ ငါ တို့အဘ ၏ အမျိုးအနွယ် ကို စောင့် မ၍ သူ နှင့် အိပ် ကြ စို့ဟု ညီမ ကို ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ထို နေ့ညမှာ သူ တို့သည် အဘ ကို စပျစ်ရည် တိုက် ပြီးလျှင် ၊ သမီးအကြီး သည် ဝင် ၍ အဘ နှင့် အိပ် လေ ၏။ သူ အိပ် ကြောင်းကို၎င်း ၊ ထ ကြောင်းကို၎င်း အဘ မ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","နက်ဖြန် နေ့တွင် အကြီး ကလည်း မနေ့ ညမှာ ငါသည် အဘ နှင့် အိပ် လေပြီ။ ယနေ့ည တဖန် သူ့ ကို စပျစ်ရည် တိုက် ကြစို့။ သင်သည်ဝင် ၍ အဘ ၏အမျိုးအနွယ် ကို စောင့် မခြင်းငှါ ၊ သူ နှင့် အိပ် လော့ဟု ညီမ ကို ပြော ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ထို နေ့ည၌လည်း သူ တို့သည် အဘ ကို စပျစ်ရည် တိုက် ပြီးလျှင်၊ အငယ် သည်ဝင် ၍ အဘ နှင့် အိပ် လေ၏။ အိပ် ကြောင်းကို၎င်း ၊ ထ ကြောင်းကို၎င်း အဘမ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ထိုသို့ လောတ ၏ သမီး နှစ် ယောက်တို့သည်၊ မိမိ အဘ အားဖြင့် ပဋိသန္ဓေ စွဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","သမီးအကြီး သည် သား ကို ဘွား ၍ မောဘ အမည် ဖြင့် မှည့် လေ၏။ ထိုသူ သည် ယနေ့ တိုင်အောင်ရှိသောမောဘ အမျိုးသားတို့၏ အဘ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","သမီးအငယ် သည်လည်း သား ကိုဘွား ၍ ဗေနမ္မိ အမည် ဖြင့် မှည့် လေ၏။ ထိုသူ သည် ယနေ့ တိုင်အောင်ရှိသောအမ္မုန် အမျိုးသား တို့၏ အဘ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","တဖန် အာဗြဟံ သည် တောင် ပြည် သို့ ခရီးသွား သဖြင့် ၊ ကာဒေရှ မြို့နှင့် ရှုရ မြို့စပ်ကြား မှာနေ ၍ ၊ ဂေရာ မြို့ သို့ တည်းခို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ထိုအခါ မိမိ မယား စာရာ သည် မိမိ နှမ ဖြစ်သည် ဟု၊ သူတပါးတို့အား အာဗြဟံ ဆို သောကြောင့် ၊ ဂေရာ မင်းကြီး အဘိမလက် သည် မိမိလူကို စေလွှတ် ၍ ၊ စာရာ ကို ယူ စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ညဉ့် အချိန်တွင် အိပ်မက် အားဖြင့် ဘုရားသခင် သည် အဘိမလက် ဆီသို့ ကြွလာ ၍ ၊ သင် သည် လူ သေ ဖြစ်၏။ အကြောင်း မူကား၊ သင်ယူ သော မိန်းမ သည် သူ့ မယားဖြစ်၏ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","အဘိမလက် သည်၊ ထိုမိန်းမ နှင့် မ ပေါင်းဘော် သေးသည်ဖြစ်၍ ၊ အိုဘုရား ရှင်၊ ဖြောင့်မတ် သော လူမျိုး ကို ကွပ်မျက် တော်မူမည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","သူ သည် ငါ နှမ ဖြစ်၏ဟု အကျွန်ုပ် အား ယောက်ျား ဆို သည် မဟုတ် ပါလော။ အကျွန်ုပ်အား သူ သည်ငါ့ မောင် ဖြစ်၏ဟု မိန်းမလည်း ဆိုသည် မဟုတ် ပါလော။ ဖြောင့်မတ် သော သဘော ရှိ၍ သန့်ရှင်း သော လက် နှင့် ဤ အမှုကို အကျွန်ုပ် ပြု ပါပြီဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ထိုအိပ်မက် ၌ ဘုရားသခင် ကလည်း ၊ မှန် ပေ၏။ သင် သည် ဖြောင့်မတ် သောသဘော နှင့် ပြု သည်ကို ငါသိ ၏။ သင် သည်ငါ့ ကို မပြစ်မှား စေခြင်းငှါ၊ သင့် ကို ငါ ဆီးတား ပြီး။ သို့ဖြစ်၍ ထိုမိန်းမ နှင့် ပေါင်းဘော် ရသောအခွင့်ကို ငါမ ပေး။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ယခု မှာ သူ ၏မယား ကို သူ့အားပြန် ပေးလော့။ သူ သည် ပရောဖက် ဖြစ်၏။ သင့် အဘို့ ဆုတောင်း လျက် ၊ သင်သည် အသက် ချမ်းသာရလိမ့်မည်။ ပြန် ၍ မ ပေးဘဲ နေလျှင် သင် မှစ၍ သင် နှင့်ဆိုင် သော သူအပေါင်း တို့ သည် ဧကန် အမှန်သေ မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","နံနက် စောစောအဘိမလက် သည် ထ ၍ ၊ မိမိ ကျွန် အပေါင်း တို့ကိုခေါ် ပြီးမှ အမှု အရာအလုံးစုံ ကို ပြော သဖြင့် ၊ ထို သူတို့သည် အလွန် ကြောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","အာဗြဟံ ကို လည်း အဘိမလက် ခေါ် ၍ ၊ သင် သည် ငါ တို့၌ အဘယ်သို့ ပြု သနည်း။ သင့် ကို ငါတို့သည် အဘယ်သို့ ပြစ်မှား သောကြောင့် ၊ သင်သည် ငါ ၌ ၎င်း ငါ့ နိုင်ငံ ၌ ၎င်း၊ ကြီးစွာ သော အပြစ် ကိုရောက် စေသနည်း။ သင်သည် မ ပြု အပ်သောအမှု ကို ငါ ၌ ပြု ပါသည်တကားဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","တဖန် အဘိမလက် က၊ သင်သည် အဘယ် အမှုကို မြင် ၍ ဤ သို့ပြု သနည်းဟု အာဗြဟံ ကိုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","အာဗြဟံ က၊ ဤ အရပ် သားတို့သည် ဘုရားသခင် ကို မ ကြောက် ၊ အကျွန်ုပ် ၏မယား အတွက် အကျွန်ုပ် ကို သတ် ကြလိမ့်မည်ဟု အကျွန်ုပ်ထင်သောကြောင့်၊ ထိုသို့ပြုမိ ပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","သို့သော်လည်း သူ သည်အကျွန်ုပ် နှမ မှန် ပါ ၏။ အကျွန်ုပ် အဘ ၏သမီး ဖြစ်၏။ အမိ ၏သမီး မ ဟုတ်။ အကျွန်ုပ် မယား လည်း ဖြစ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ဘုရားသခင် သည် အကျွန်ုပ် ကိုအဘ ၏ အိမ် မှ ခေါ်၍ လည် စေတော်မူသောအခါ ၊ အကျွန်ုပ် က၊ သင် သည် ငါ ၌ ပြု ရသောကျေးဇူး ဟူမူကား ၊ ငါသည် သင်၏မောင် ဖြစ် ကြောင်းကို ရောက်လေရာရာ ၌ ပြော ရမည်ဟု၊ မယား ကို မှာ ထားပါသည်ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ထိုအခါ အဘိမလက် သည်၊ သိုး ၊ နွား ၊ ကျွန် ယောက်ျား၊ ကျွန် မိန်းမတို့ကိုယူ ၍ အာဗြဟံ အား ပေး လေ ၏။ မယား စာရာ ကို လည်း ပြန် ပေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","အဘိမလက် ကလည်း ၊ ငါ့ မြေ သည် သင့် ရှေ့ မှာ ရှိ၏။ အလို ရှိသည်အတိုင်း နေ ပါဟု အမိန့် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","စာရာ ကို လည်း သင် နှင့် သင့်အပေါင်း အဘော်တို့ အဘို့ မျက်နှာ ဖုံး များကို ဝယ်စရာဖို့ သင် ၏မောင် အား ငွေ တထောင် ကို ငါပေး ပြီဟု အမိန့် ရှိသဖြင့် သူသည် လည်း အရာရာ ၌ အဆုံး အမခံရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","အာဗြဟံ သည်လည်း၊ ဘုရားသခင် ကို ဆုတောင်း ၍ ၊ ဘုရားသခင် သည် အဘိမလက် နှင့် သူ ၏ မယား ၊ သူ ၏ကျွန် မတို့ကို အနာ ပျောက်စေတော်မူသဖြင့် ၊ သူတို့သည် သား ကိုဘွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","အထက်က အာဗြံဟံ ၏ မယား စာရာ ကြောင့် ထာဝရဘုရား သည် အဘိမလက် ၏အိမ်သူ ၊ မိန်းမတယောက် မျှ ပဋိသန္ဓေ မယူစေခြင်းငှါ စီရင် တော်မူသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ထာဝရဘုရား သည်၊ အမိန့်တော်ရှိသည်အတိုင်း ၊ စာရာ ကို အကြည့် အရှုကြွတော်မူ၍ ၊ ဂတိတော် ရှိသည်နှင့် လျော်စွာ သူ ၌ ပြု တော်မူသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","စာရာ သည် ပဋိသန္ဓေစွဲ ယူ၍ ၊ ဘုရားသခင် အမိန့် တော်နှင့် ချိန်းချက် သောအချိန်၌ ၊ အာဗြဟံ အသက်ကြီး သောအခါ၊ သူ့ အားသား ကို ဘွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","အာဗြဟံ သည်လည်း ၊ မိမိ ရ သောသားတည်းဟူသော၊ စာရာ ဘွား သောသား ကို ဣဇာက် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ဘုရားသခင် မှာ ထားတော်မူသည်အတိုင်း ၊ အာဗြဟံ သည်ရှစ် ရက် မြောက်သောနေ့၌ ၊ သား ဣဇာက် ကို အရေဖျား လှီးမင်္ဂလာပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","သား ဣဇာက် ကို မြင် ရသောအခါ အာဗြဟံ သည် အသက် တ ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","စာရာ ကလည်း ၊ ငါ ရယ် ရသောအခွင့်ကို ဘုရားသခင် ပေး တော်မူပြီ။ ဤသိတင်းကို ကြား သောသူ အပေါင်း တို့သည်လည်း၊ ငါ နှင့်အတူ ရယ် ကြလိမ့်မည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","စာရာ သည် သား ကို နို့တိုက် လိမ့်မည်ဟု အာဗြဟံ အား အဘယ်သူ ပြော နှင့်ရသနည်း။ သူ သည် အသက် ကြီးသောအခါ၊ ငါသည် သား ကို ဘွား ပြီးဟူ၍ ၎င်း ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ထိုသူငယ် ဣဇာတ် သည် ကြီးပွား ၍ နို့ နှင့် ကွာလေ၏။ နို့ ကွာသောနေ့ ၌ အာဗြံဟံ သည် ပွဲ ကြီး လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","အဲဂုတ္တ အမျိုးသားဟာဂရ တွင် အာဗြဟံ ရ သော သား သည် ဆဲရေး သည်ကို စာရာ သိ မြင်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ဤ ကျွန်မ ၏သား သည် အကျွန်ုပ် ၏သား ဣဇာက် နှင့်အတူ အမွေ မ ခံရဟု အာဗြံဟံ အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","အာဗြဟံ လည်း ၊ မိမိ သား ဖြစ် သောကြောင့် ၊ ထိုအမှု အလွန် ခက် သည်ဟု ထင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","သို့ရာတွင် ဘုရားသခင် က၊ ထိုသူငယ် နှင့် သင် ၏ ကျွန်မ ကြောင့် ၊ ဤအမှုခက် သည်ဟု မ ထင် နှင့်။ စာရာ ပြော လေရာရာ ၌ သူ ၏စကား ကို နားထောင် လော့။ အကြောင်းမူကား ၊ ဣဇာက် ၌ သာ သင် ၏ အမျိုး တည် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ကျွန်မ ၏သား သည် သင် ၏အမျိုး ဖြစ်သောကြောင့် ၊ သူ့ ကိုလည်း လူမျိုး ဖြစ် စေမည်ဟု အာဗြံဟံ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","အာဗြဟံ သည် နံနက် စောစောထ ၍ ၊ မုန့် နှင့် ရေ ဘူး ကိုယူ သဖြင့် ၊ ဟာဂရ ပခုံး ၌ တင် ပြီးလျှင် ၊ သူငယ် ကို အပ် ၍ ကျွန်မ ကို လွှတ် လိုက်လေ၏။ သူသည်လည်း သွား ၍ ဗေရရှေဘ တော ၌ လှည့်လည် လျက် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ဘူး ၌ ရေ ကုန် သောအခါ ၊ သူငယ် ကို ချုံဖုတ် အောက် ၌ ထား ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ငါသည်သူငယ်သေ သည်ကို မ မြင် လိုဟုဆို လျက် ၊ ခပ်ဝေးဝေး လေး တ ပစ်ခန့် လောက် သွားပြီးလျှင်၊ သူ ငယ်ရှေ့ မှာ ထိုင် ၍ နေလေ၏။ ထို သို့ထိုင် ၍ နေစဉ် သူ သည်အသံ ကို လွှင့် ၍ ငိုကြွေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ဘုရားသခင် သည် လုလင် ၏အသံ ကို ကြား တော်မူ ၍ ဘုရားသခင် ၏၊ ကောင်းကင် တမန်က၊ ဟာဂရ ၊ သင် ၌ အဘယ် အမှုရှိသနည်း။ မ စိုးရိမ် နှင့်။ လုလင် နေ သောအရပ်ထဲက သူ ၏အသံ ကို ဘုရားသခင် ကြား တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ထ လော့။ လုလင် ကိုကြွ ၍ လက် နှင့်မ လော့။ ငါသည်သူ့ ကို လူမျိုး ကြီး ဖြစ် စေမည်ဟု ကောင်းကင် ထဲက ခေါ် ၍ ဟာဂရ အား မြွက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ထိုအခါ ဘုရားသခင် သည် ဟာဂရ ၏ မျက်စိ ကို ဖွင့် တော်မူသဖြင့် ၊ သူသည်ရေ တွင်း ကို မြင် လေသော် ၊ သွား ၍ ဘူး ကို ရေ ဖြည့်ပြီးလျှင် ၊ လုလင် အား ရေ ကို တိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ထိုလုလင် ဘက် ၌လည်း ၊ ဘုရားသခင် ရှိ တော်မူ ၏။ သူသည် ကြီးပွား ၍ တော ၌ နေ သဖြင့် ၊ လေး သမား ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ပါရန် တော ၌ နေ သည်ဖြစ်၍ သူ့ အမိ သည် အဲဂုတ္တု ပြည် မှ မိန်းမ တယောက်ကိုခေါ်၍ သူ နှင့် စုံဘက် စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ထို ရောအခါ၊ အဘိမလက် မင်းနှင့် ဗိုလ်ချုပ် မင်းဖိကောလ တို့သည် အာဗြဟံ ကို ခေါ်၍၊ သင်သည် ပြု လေရာရာ ၌ သင့် ဘက် မှာ ဘုရားသခင် ရှိ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","သို့ဖြစ်၍ သင်သည်ငါ့ ကို၎င်း၊ ငါ့ သား ကို၎င်း ၊ ငါ့ မြေး ကို၎င်း ၊ မ လှည့်စား၊ ငါသည် သင် ၌ ကျေးဇူးပြု သကဲ့သို့ ငါ ၌ ၎င်း ၊ သင်တည်း နေရာ ငါ့ပြည် ၌ ၎င်း၊ ကျေးဇူး ပြုမည်ဟု ဘုရားသခင် ကို တိုင်တည်၍ ငါ့ အား ကျိန် ဆိုပါလော့ဟုပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","အာဗြဟံ ကလည်း ၊ ထိုအတိုင်းငါ ကျိန် ဆိုပါမည်ဟု ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","အဘိမလက် မင်း၏ ကျွန် တို့သည် အနိုင် အထက်လုယူသော ရေ တွင်း အကြောင်းကြောင့် ၊ အာဗြဟံ သည် လည်း အဘိမလက် မင်းကို အပြစ်တင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","အဘိမလက် မင်းကလည်း ၊ ဤ အမှု ကို အဘယ်သူ ပြု သည်ကို ငါမ သိ။ သင် သည်ငါ့ ကို မ ပြော။ ငါ လည်း ယနေ့ တိုင်အောင် မ ကြား ရဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","အာဗြဟံ သည်လည်း သိုး ၊ နွား တို့ကို ယူ ပြီးလျှင် ၊ အဘိမလက် အား ပေး ၍ ထို နှစ် ပါးတို့သည် ပဋိညာဉ် ပြု ကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","အာဗြဟံ သည်လည်း သိုးသငယ် မ ခုနစ် ကောင် တို့ကို သိုး စုနှင့်ခွဲ ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","အဘိမလက် ကလည်း ၊ ခွဲ ထားသော ဤ သိုးသငယ် မခုနစ် ကောင်တို့သည်၊ အဘယ်သို့ နည်းဟုမေး သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","အာဗြဟံ က၊ ဤ ရေ တွင်းကို ငါတူး ပြီးဟု ဤသိုးသငယ် မခုနစ် ကောင်တို့သည် ငါ့ ဘက် ၌ သက်သေ ဖြစ် မည် အကြောင်း သူတို့ကို သင်သည်ငါ့ လက် မှ ခံ ယူရမည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","သို့ဖြစ်၍ ထို အရပ်၌ ထို နှစ် ပါးတို့သည် ကျိန်ဆို သောကြောင့် ၊ ထို အရပ် ကို ဗေရရှေဘ ဟု တွင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ထိုသို့ ဗေရရှေဘ အရပ်၌ ပဋိညာဉ် ပြု ကြ၏။ အဘိမလက် နှင့် ဗိုလ်ချုပ် မင်း ဖိကောလ တို့သည်ထ ၍ ဖိလိတ္တိ ပြည် သို့ ပြန် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","အာဗြဟံ သည် ဗေရရှေဘ အရပ်၌ မန်ကျည်း ပင်ကိုစိုက် ၍ ၊ အစဉ် အမြဲတည်တော်မူသောဘုရား သခင်တည်းဟူသော၊ ထာဝရဘုရား ၏ နာမတော် ကို ပဌနာ ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ဖိလိတ္တ ပြည် မှာ ကာလ ရှည် ကြာစွာ တည်း နေ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ထိုနောက်မှ ဘုရားသခင် သည်၊ အာဗြဟံ ကို စုံစမ်း ခြင်းငှါ၊ အာဗြဟံ ဟု ခေါ် တော်မူ၍ အာဗြဟံ က၊ အကျွန်ုပ် ရှိ ပါ၏ဟု လျှောက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","သင်သည် အလွန်ချစ် သော တ ယောက်တည်း သော သား ဣဇာတ် ကိုယူ ၍ မောရိ ပြည် သို့ သွား လော့။ ငါပြ လတံ့သော တောင် ပေါ် မှာ သူ့ ကိုမီးရှို့ ရာ ယဇ်ပြု၍ ပူဇော် လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","အာဗြဟံ သည် နံနက် စောစော ထ၍ ၊ မြည်း ကို ကုန်းနှီး တင်ပြီးလျှင် ၊ မိမိ သား ဣဇာက် နှင့် ငယ်သား နှစ် ယောက်ကိုခေါ် ၍ ယဇ် ရှို့စရာ ထင်း ကိုခွဲ ပြီးမှ ၊ ဘုရားသခင် မိန့် တော်မူသောအရပ် သို့ ထ သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","သုံး ရက်မြောက် သောနေ့၌ မြော် ကြည့်၍၊ ထိုအရပ် ကို အဝေး က မြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ငယ်သား နှစ်ယောက်တို့အား ၊ သင် တို့သည် ဤ အရပ်၌မြည်း နှင့်အတူ နေ ရစ်ကြလော့။ ငါ သည် သားနှင့်အတူထိုအရပ် သို့သွား ၍ ၊ ကိုးကွယ် ခြင်းကိုပြုအံ့။ ထိုအမှုပြီးမှ ၊ သင် တို့ဆီသို့ ပြန် လာဦးမည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ထိုအခါ ယဇ် ရှို့စရာထင်း ကိုယူ ၍ သား ဣဇာတ် အပေါ် မှာ တင် ပြီးလျှင် ၊ မီး နှင့် ထား ကို မိမိ လက် ၌ ကိုင် လျက် ၊ နှစ် ယောက်အတူ သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","သွားကြစဉ်တွင်၊ ဣဇာက် သည် အဘ အာဗြဟံ ကို အဘ ဟုခေါ် လျှင် ၊ ငါ့ သား ၊ ငါ ရှိ ၏ဟု ထူး လေ၏။ ဣဇာက်ကလည်း မီး ပါ၏၊ ထင်း လည်းပါ၏။ ယဇ် ရှို့စရာဘို့ သိုးသငယ် သည် အဘယ်မှာ ရှိသနည်းဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","အာဗြဟံ က ငါ့ သား ၊ ယဇ် ရှို့စရာဘို့ သိုးသငယ် ကို ဘုရားသခင် သည် မိမိ အဘို့ ပြင်ဆင် တော်မူလိမ့်မည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ထိုသို့ နှစ် ယောက်အတူ သွား ၍ ၊ ဘုရားသခင် မိန့် တော်မူသောအရပ် သို့ ရောက် ကြသောအခါ ၊ အာဗြဟံ သည် ယဇ် ပလ္လင်ကိုတည် ၍ ထင်း ကိုခင်း ပြီးလျှင် ၊ သား ဣဇာက် ကိုချည်နှောင် ၍ ၊ ယဇ် ပလ္လင်၌ ထင်း ပေါ် မှာ တင် ထား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","မိမိ လက် ကို ဆန့် ၍ သား ကိုသတ် ခြင်းငှါ ၊ ထား ကို ကိုင် ယူလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ထိုအခါ ၊ ထာဝရဘုရား ၏ ကောင်းကင် တမန်က၊ အာဗြဟံ ၊ အာဗြဟံ ဟု ကောင်းကင် ပေါ်က ခေါ် လေ၏။ အာဗြဟံ က၊ အကျွန်ုပ် ရှိ ပါ၏ဟု လျှောက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ထိုလုလင် ကို မ ထိ မခိုက်နှင့်။ အလျှင်း မ ပြု နှင့်။ သင် သည် ဘုရားသခင် ကို ကြောက်ရွံ့ သည်ဟု ယခု ငါသိ ၏။ အကြောင်းမူကား ၊ သင် ၏သား သင် ၌တ ယောက် တည်းသောသားကိုငါတောင်း၍ သင် သည် ငါ့ ကိုမ ငြင်း ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ထိုအခါ အာဗြဟံ သည် မြော် ကြည့် ၍ မိမိ နောက်မှ ချုံဖုတ် ၌ ချို ညိ လျက် ရှိသောသိုး ကိုမြင် လေ၏။ ထိုသိုး ကိုသွား ၍ ယူ ပြီးလျှင် မိမိ သား ကိုယ်စား မီးရှို့ ယဇ် ပြု၍ ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ထို အရပ် ကို ယေဟောဝါ ယိရဟု အာဗြဟံ သမုတ် လေ၏။ ထိုသို့ နှင့်အညီတောင် ပေါ် မှာ ထာဝရဘုရား ပြင်ဆင် တော်မူမည်ဟု ယနေ့ တိုင်အောင်ဆို လေ့ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","တဖန် ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် ကောင်းကင် ပေါ်က အာဗြဟံ ကို ခေါ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","သင်သည် ဤ အမှု ကိုပြု ၍ ၊ သင် ၏သား သင်၌ တ ယောက်တည်းသောသားကို၊ ငါ့အား မ ငြင်း သောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ငါသည် သင့် အား အစဉ်အမြဲကောင်းကြီး ပေးမည်။ သင် ၏အမျိုးအနွှယ် ကိုလည်း ကောင်းကင် ကြယ် ကဲ့သို့ ၎င်း ၊ သမုဒ္ဒရာ သဲ လုံးကဲ့သို့ ၎င်း၊ အစဉ်အမြဲပွား များစေမည်။ သင် ၏အမျိုးအနွယ် သည် ရန်သူ တို့၏ မြို့တံခါး များကို အစိုး ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","သင် ၏အမျိုးအနွယ် အားဖြင့် ၊ လူမျိုး ပေါင်း တို့သည် ကောင်းကြီး မင်္ဂလာကို ခံရကြလိမ့်မည်ဟု ငါ ၏ စကား ကို သင်နားထောင် သော ကြောင့် ၊ ငါသည်ကိုယ်ကိုကိုယ် တိုင်တည်၍ ကျိန်ဆို ၏ဟု ထာဝရ ဘုရား၏ အမိန့် တော်ကို ဆင့် ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ထိုအခါ အာဗြဟံ သည် ငယ်သား တို့ ရှိရာသို့ ပြန် ၏။ သူတို့သည် ထ ပြီးလျှင် ဗေရာရဗတ အရပ်သို့ လိုက်သွား ကြ၏။ ထို အရပ်၌ အာဗြဟံ နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ထိုနောက်မှ ၊ အာဗြဟံ ကြား သော သိတင်းစကား ဟူမူကား ၊ သင် ၏အစ်ကို နာခေါ် မယားမိလခါ သည် သား ကို ဘွား မြင်လေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","သား အကြီးဟုဇ ၊ သူ့ ညီ ဗုဇ ၊ အာရံ အဘ ကေမွေလ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ခေသက် ၊ ဟာဇော ၊ ပိလဒါရှ ၊ ယိဒလပ် ၊ ဗေသွေလ တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","သားရှစ် ယောက်တို့ကို၊ အာဗြဟံ အစ်ကို နာခေါ် ၏ မယားမိလခါ ဘွား မြင်လေ၏။ ဗေသွေလ ကား ၊ ရေဗက္က အဘ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ရုမာ အမည် ရှိသောနာခေါ် ၏ မယား ငယ်သည်လည်း တေဘ ဂါဟံ ၊ သဟာရှ မာခါ တို့ကို ဘွား မြင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","စာရာ သည် အသက် တရာ နှစ် ဆယ်ခုနစ် နှစ် ရှိ ၏။ ထိုမျှလောက်အသက်ကြီးသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ခါနာန် ပြည်၊ ဟေဗြုန် မြို့တည်းဟူသော၊ ကိရယသာဘ မြို့၌ သေ လေ၏။ အာဗြဟံ သည်လည်း စာရာ ကြောင့် ညည်းတွားငိုကြွေး ခြင်းငှါ လာ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","အာဗြဟံ သည် မိမိမယားအသေ ကောင်ရှေ့ က ထ ၍ ၊ ဟေသ အမျိုးသား တို့အား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ငါ သည် သင် တို့ထံမှာဧည့်သည် အာဂန္တုဖြစ်ပါ ၏။ ငါ၏မယားအသေ ကောင်ကို မျက်ကွယ် မြှုပ်မည် အကြောင်း ၊ သင် တို့တွင် သင်္ချိုင်း ကို ငါ့ အား အခွင့် ပေး ပါ လော့ဟု ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ဟေသ အမျိုးသား တို့က၊ အကျွန်ုပ် တို့သခင် ၊ နားထောင် ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ကိုယ်တော်သည်၊ အကျွန်ုပ်တို့တွင်၊ ဘုရား သခင်နှင့်ဆိုင်သောမင်း ဖြစ်ပါ၏။ အကျွန်ုပ် တို့၏သင်္ချိုင်း များ တွင် ရွေး ၍ ၊ ကိုယ်တော် ၏မယား အသေ ကောင်ကို သင်္ဂြိုဟ် ပါလော့။ ကိုယ်တော် ၏မယားအသေ ကောင်ကို မ သင်္ဂြိုဟ် စေခြင်းငှါ၊ အကျွန်ုပ် တို့တွင် အဘယ်သူမျှမိမိ သင်္ချိုင်း ကို မပေးဘဲမနေပါဟု၊ အာဗြဟံ အား ပြန် ပြောကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","အာဗြဟံ သည် ထ ၍ ၊ ထိုပြည် သား တည်းဟူသောဟေသ အမျိုးသား များရှေ့ မှာ ဦးညွှတ် ချလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ငါသည် ငါ ၏မယားအသေ ကောင်ကို မျက်ကွယ် မြှုပ်စေခြင်းငှါ သင် တို့အလိုရှိ လျှင် ၊ ငါ့ စကားကို နားထောင် ကြပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","သင်တို့တွင် ငါပိုင် ထိုက်သောသင်္ချိုင်း ရှိစေခြင်းငှါ၊ ဇောဟာ သား ဧဖရုန် သည်၊ မိမိ လယ်ပြင် အစွန်း ၌ ရှိသောမပ္ပေလ မြေတွင်း ကို၊ အဘိုး ထိုက် သမျှ ငွေနှင့်ငါ့ အား ရောင်း စေခြင်းငှါ၊ ငါ့ အတွက် သူ့ကို တောင်းပန်ကြပါလော့ ဟု နှုတ်ဆက်၍ ပြောဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ထိုအခါ ဧဖရုန် သည်၊ ဟေသ အမျိုးသား တို့တွင် ထိုင် လျက်ရှိ၏။ သို့ဖြစ်၍ မြို့ တံခါး သို့ ဝင် သောသူ အပေါင်း တည်းဟူသောဟေသ အမျိုးသား ပရိတ်သတ် ၌ ၊ ဟိတ္တိ အမျိုးသားဧဖရုန် က၊ ထိုသို့မဟုတ်ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","အကျွန်ုပ် သခင် ၊ အကျွန်ုပ် စကားကို နားထောင် ပါ။ ထိုလယ်ပြင် ကို၎င်း၊ ကိုယ်တော် အား အကျွန်ုပ်ပေး ပါ၏။ အကျွန်ုပ် အမျိုးသား များ ရှေ့ ၌၊ ကိုယ်တော် အား အကျွန်ုပ်ပေး ပါ၏။ ကိုယ်တော် ၏ မယားအသေ ကောင်ကို သင်္ဂြိုဟ် ပါဟု၊ အာဗြဟံ အား ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","အာဗြဟံ သည်လည်း ၊ ထိုပြည် သား များ ရှေ့မှာ ဦးညွှတ် ချလျက်၊ အကယ်၍ငါ့စကားကို နားထောင်ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ထိုလယ်ပြင် အဘိုး ငွေကို ငါပေး မည်။ ငွေကိုယူ ပါ၊ သို့ဖြစ်လျှင် ၊ ထို အရပ်၌ ငါ ၏မယားအသေ ကောင်ကို ငါသင်္ဂြိုဟ် ပါမည်ဟု ပြည် သား ပရိသတ် တို့ရှေ့ မှာ၊ ဧဖရုန် အား ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ဧဖရုန် ကလည်း ၊ အကျွန်ုပ် သခင် ၊ နားထောင် ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","ထိုမြေ သည် ငွေ လေး ပိဿာ အဘိုးထိုက်ပါ၏။ ကိုယ်တော် နှင့် အကျွန်ုပ် ၌ အဘယ် အတွက်ရှိသနည်း။ ကိုယ်တော် ၏မယား အသေ ကောင်ကို သင်္ဂြိုဟ် ပါလော့ဟု၊ အာဗြဟံ အား ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","အာဗြဟံ သည်လည်း ၊ ဧဖရုန် စကားကို နားထောင် သည်ဖြစ်၍ ၊ ကုန်သည် သုံးတတ်သော ငွေမျိုး၊ ဟေသ အမျိုးသား ပရိသတ် ရှေ့ ၊ ဧဖရုန် အဘိုး ပြတ် သည် အတိုင်း ၊ ငွေ လေး ပိဿာ ကို ချိန် ၍ ၊ သူ့အားပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ထိုသို့ မံရေ မြို့ရှေ့ မှာ၊ မပ္ပေလ အရပ်၌ ရှိသောဧဖရုန် ၏လယ်ပြင် ကို၎င်း ၊ လယ်ပြင် ၌ ရှိသောမြေတွင်း နှင့် သစ်ပင် များ၊ ပတ်ဝန်းကျင် သစ်ပင်များကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ဟေသ အမျိုးသား ပရိတ်သတ် ၌ ၊ မြို့ တံခါး သို့ ဝင် သောသူအပေါင်း တို့ရှေ့ မှာ၊ အာဗြဟံ ဥစ္စာ ဘို့ လုံခြုံစွာ အပ်ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ထိုနောက်မှ အာဗြဟံ သည်၊ မံရေ မြို့ရှေ့ မှာ၊ မပ္ပေလ လယ်ပြင် မြေတွင်း ၌ မယား စာရာ ကို သင်္ဂြိုဟ် ရလေ ၏။ ထိုအရပ် ကား၊ ခါနာန် ပြည် ဟေဗြုန် အရပ် ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ထိုလယ်ပြင် နှင့် မြေတွင်း ကို၊ အာဗြဟံ ပိုင် ထိုက် သော သင်္ချိုင်း ဖြစ်စေခြင်းငှါ၊ ဟေသ အမျိုးသား တို့သည် လုံခြုံစွာ အပ်ပေးကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","အာဗြဟံ သည်အို ၍ ၊ အသက် အရွယ်ကြီးရင့် လှပြီ။ ထာဝရဘုရား သည်၊ အရာရာ ၌ သူ့ ကို ကောင်းကြီး ပေးတော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","အာဗြဟံ သည်၊ မိမိ အိမ်သား တို့တွင် အသက် ကြီး၍ ဘဏ္ဍာစိုး လုပ်သောသူကို ခေါ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","သင် သည်၊ ငါ နေ သောခါနာန် အမျိုးသမီး တို့ တွင်၊ ငါ့ သား ဘို့ မယား ကို မ ရွေး မယူဘဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ငါ့ ပြည် ငါ့ အမျိုးသား ချင်းတို့ထံသို့ သွား ၍ ၊ ငါ့ သား ဣဇာက် အဘို့ မယား ကို ယူ ရမည်ဟု၊ သင် ၏လက် ကို ငါ့ ပေါင် အောက် ၌ထား ပြီးမှ၊ ကောင်းကင် မြေကြီး အရှင် ဘုရားသခင် ၊ ထာဝရဘုရား ကို တိုင်တည်၍၊ ငါကျိန် ဆိုစေ ပါမည်ဟုဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ကျွန် ကလည်း ၊ မိန်းမ သည်ဤ ပြည် သို့ ကိုယ်တော် ၏သား ကို တဖန်ကျွန်တော်ခေါ် သွားရပါမည်လောဟု မေး လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","အာဗြဟံ က၊ ထို ပြည်သို့ ငါ့ သား ကိုခေါ် ၍ မ သွား နှင့်။ သတိပြု လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ငါ့ အဘ ၏အိမ် မှ ၎င်း၊ ငါ့ အမျိုးသား နေရာပြည် မှ ၎င်း ငါ့ ကိုခေါ် ၍၊ သင် ၏အမျိုးအနွယ် အား ဤ ပြည် ကို ငါပေး မည်ဟု၊ ငါ့ အား ဗျာဒိတ် တော်ပေး၍ ကျိန်ဆို တော်မူသော ကောင်းကင် ဘုံရှင် ဘုရားသခင် ထာဝရဘုရား သည်၊ မိမိ ကောင်းကင်တမန် ကို သင့် ရှေ့ ၌ စေလွှတ် တော်မူသဖြင့် ၊ သင်သည်ထို ပြည်မှ ငါ့ သား ဘို့ မယား ကို ယူ ရလိမ့် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","မိန်းမ သည်သင် နှင့်အတူ မ လိုက် လို လျှင် ၊ သင် သည်၊ ယခုငါ ပေးသောကျိန်ဆို ခြင်းနှင့် ကင်းလွတ် စေ။ ငါ့ သား ကို ထို ပြည်သို့ ခေါ် ၍ မ သွားနှင့်ဟုဆိုပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ကျွန် သည် သခင် အာဗြဟံ ၏ ပေါင် အောက် ၌ လက် ကိုထား ၍ ထို အမှု ၌ ကျိန်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ထိုကျွန် သည်လည်း ၊ မိမိ သခင်၏ဥစ္စာ ရှိသမျှ ကို စီရင် သော သူဖြစ်၍၊ သခင် ၏ကုလားအုပ် စုထဲက ၊ ကုလားအုပ် ဆယ် စီးကိုယူ ၍ထ သွား သဖြင့် ၊ မေသောပေါဘာမိ တိုင်း၊ နာခေါ် မြို့ သို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","မိန်းမများရေခပ် သော ညဦး ယံအချိန် ၌ ၊ မြို့ ပြင် ရေတွင်း နား မှာ ကုလားအုပ် တို့ကို ဝပ် စေပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","အကျွန်ုပ် ၏သခင် ၊ အာဗြဟံ ၏ ဘုရားသခင် ထာဝရဘုရား ယနေ့ အကျွန်ုပ် အကြံကို ထမြောက် စေ၍ ၊ အကျွန်ုပ် ၏သခင် အာဗြဟံ ၌ ကျေးဇူး ပြု တော်မူပါဟု၊ အကျွန်ုပ်ဆုတောင်း ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","အကျွန်ုပ် သည်၊ ဤရေတွင်း နား မှာ ရပ်နေ ၍ ၊ ထိုမြို့ သူ သတို့သမီး တို့သည်၊ ရေ ခပ် ခြင်းငှါ လာ ကြသည် တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","အကြင်သတို့သမီးကို၊ ကျွန်ုပ်သောက် ခြင်းငှါသင် ရေ ဘူးကို ချ ပါဟုဆို သော်၊ သောက် ပါ၊ သင် ၏ကုလားအုပ် တို့ကိုလည်း ရေ တိုက်ပါမည်ဟု၊ ပြန် ဆိုသော သမီး သည်၊ ကိုယ်တော် ၏ကျွန် ဣဇာက် ဘို့ ခန့်ထားတော်မူ သောသူဖြစ် ပါစေသော။ ထိုသို့အားဖြင့်၊ အကျွန်ုပ် ၏ သခင် ၌ ကျေးဇူး ပြု တော်မူကြောင်း ကို၊ အကျွန်ုပ်သိ ရပါ မည်ဟု လျှောက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ထိုသို့လျှောက်ဆို၍မ ပြီး မှီ၊ အာဗြဟံ အစ်ကို နာခေါ် မယား မိလခါ သား ၊ ဗေသွေလ ၏ သမီး ရေဗက္က သည်၊ ရေ ဘူးကိုထမ်း လျက် ထွက် လာသည်ကိုမြင် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ထို သတို့သမီး သည်၊ အလွန် အဆင်း လှ ၍၊ ယောက်ျား နှင့် မ ဆက်ဆံ သေးသော ကညာ ဖြစ်၏။ ရေတွင်း သို့ ဆင်း ၍ ၊ ရေဘူး ကို ရေနှင့်ဖြည့် ပြီးမှ တက် လာ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ကျွန် သည်လည်း၊ ထိုမိန်းမ နှင့် တွေ့ ခြင်းငှါ ပြေး ၍ ၊ သင် ၏ရေ ဘူး၌ ရေ အနည်းငယ် ကို သောက် ပါရစေဟု ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","မိန်းမက၊ သောက် ပါလောအရှင် ဟုဆို သဖြင့် ၊ မိမိ လက် ပေါ်မှာ၊ အလျင် အမြန်ရေ ဘူးကို ချ ၍ ၊ ရေကို ပေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ရေကို ပေး ပြီးလျှင် ၊ သင် ၏ကုလားအုပ် တို့သည် လည်း ၊ ဝစွာ သောက် စရာဘို့ ရေခပ် ပါမည်ဟု ဆို သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","အလျင် အမြန်ဘူး၌ရှိသောရေကိုရေ တိုက်ခွက် ထဲ၌ လောင်း ပြီးလျှင် ၊ တဖန် ခပ် ခြင်းငှါ ရေတွင်း သို့ ပြေး ၍ ၊ ကုလားအုပ် အဘို့ ရေခပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ယောက်ျား သည် ထိုမိန်းမ ကို အံ့ဩ ၍ ၊ မိမိ ရောက် လာသောအမှုကို ထာဝရဘုရား ပြုစု တော်မူသည်၊ မ မူသည်ကို သိ လို၍ ၊ တိတ်ဆိတ် စွာ နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ကုလားအုပ် များကို ရေသောက် စေပြီး သော နောက်၊ ယောက်ျား သည်၊ အချိန် ငါး မူးရှိသောရွှေ နှာဆွဲ ၊ အကျပ်တ ဆယ်အချိန် ရှိသောရွှေ လက်ကောက် တရံ ကို ထုတ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","သင် သည် အဘယ်သူ ၏သမီး ဖြစ်သနည်း။ ကျွန်ုပ် ကို ပြော ပါ။ သင် ၏အဘ အိမ် ၌ ကျွန်ုပ်တို့ တည်းခို စရာ အရပ် ရှိ သလောဟု မေး လေသော် ");
INSERT INTO myajvb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","မိန်းမက၊ ကျွန်ုပ် သည် နာခေါ် ၏မယားမိလခါ ဘွား မြင်သော၊ ဗေသွေလ ၏သမီး ဖြစ်သည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ကျွန်ုပ် တို့၌ မြက် ခြောက်များ၊ စားဘွယ် သောက်ဘွယ်များနှင့် တည်းခို စရာ အရပ် လည်း ရှိသည်ဟူ၍၎င်း ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ထိုအခါ ယောက်ျား သည် ဦးညွှတ် ချ၍ ထာဝရဘုရား ကို ကိုးကွယ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ကရုဏာ ၊ သစ္စာ တော်ကို အကျွန်ုပ် သခင် မှ ရုပ်သိမ်း တော်မ မူသော၊ အကျွန်ုပ် သခင် အာဗြဟံ ၏ ဘုရားသခင် ထာဝရဘုရား သည် မင်္ဂလာ ရှိတော်မူစေ သတည်း။ လမ်း မှာ သွားလျက်ရှိသောအကျွန်ုပ် ကို ထာဝရဘုရား သည် အကျွန်ုပ် သခင် ၏ညီအစ်ကို တို့အိမ် သို့ ပို့ဆောင် တော်မူပါသည်တကားဟု မြွက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","သတို့သမီး သည်လည်း ပြေး ၍ အမိ ၏အိမ် ၌ ဤ အရာ များကို ကြား ပြောလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ရေဗက္က ၌ လာဗန် အမည် ရှိသောမောင် တယောက်ရှိ၏။ လာဗန် သည် ယောက်ျား ရှိရာ ရေတွင်း သို့ ပြေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","သူ သည်နှာဆွဲ ကို၎င်း ၊ နှမ လက် ၌ လက်ကောက် ကို၎င်း မြင် ၍ ၊ ထိုယောက်ျား သည်ကျွန်ုပ် ကို ဤသို့ ပြော သည်ဟု၊ နှမ ရေဗက္က ဆိုသော စကား ကို ကြား သောအခါ ၊ ရေတွင်း ၌ ကုလားအုပ် အနား မှာရပ် နေသောယောက်ျား ထံသို့ ရောက် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ထာဝရဘုရား ကောင်းကြီး ပေးတော်မူသောသူ၊ ကျွန်ုပ်အိမ်သို့ ဝင် ပါလော့။ ပြင် ၌အဘယ်ကြောင့် ရပ် နေသနည်း။ အိမ် ကို၎င်း၊ ကုလားအုပ် များနေရာ အရပ်ကို၎င်း ၊ ကျွန်ုပ် ပြင် ပါပြီဟုဆို သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ယောက်ျား ကိုအိမ် သို့ သွင်း ၍ ကုလားအုပ် တို့ တန်ဆာကို ချွတ် ပြီးမှ ၊ သူတို့အားမြက် ခြောက်နှင့် စားစရာ ကိုပေး ၏။ ယောက်ျား ခြေ ၊ လိုက်သောသူ တို့ ခြေ ဆေး ဘို့ ရေ ကိုလည်း ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","သူ့ ရှေ့ မှာ စား စရာကို ထည့် သောအခါ ၊ သူက၊ ကျွန်ုပ်သည် ကိုယ် အမှု ကိုမပြော မှီ မ စား လိုပါဟုဆို လျှင် ၊ ပြော ပါဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ယောက်ျားကလည်း၊ ကျွန်ုပ် ကားအာဗြဟံ ၏ ကျွန် ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ထာဝရဘုရား သည် ကျွန်ုပ် ၏သခင် ကို အလွန် ကောင်းကြီး ပေးတော်မူသဖြင့် ၊ သူသည်ကြီးမြတ် ခြင်းသို့ ရောက်လေပြီ။ သိုးစု ၊ နွားစု ၊ ရွှေ ၊ ငွေ ၊ ကျွန် ယောက်ျား၊ ကျွန် မိန်းမ၊ ကုလားအုပ် နှင့် မြည်း များတို့ကိုပေး တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ကျွန်ုပ် သခင် ၏မယား စာရာ သည်၊ သခင် အသက် အိုသောအခါ ၊ သူ့အားသား ကို ဘွားမြင် သဖြင့် ၊ ထို သားအား ဥစ္စာရှိသမျှ ကိုသခင်သည် အပ်ပေး ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ကျွန်ုပ် ၏သခင် ကလည်း ၊ သင်သည်ငါ နေ သောခါနာန် အမျိုးသမီး တို့တွင် ၊ ငါ့ သား ဘို့ မယား ကို မ ရွေး ဘဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ငါ့ အဘ ၏အိမ် ၊ ငါ့ အမျိုးသား ချင်းတို့ထံသို့ သွား ၍ ၊ ငါ့ သား ဘို့ မယား ကို ယူ ရမည်ဟု အကျွန်ုပ် ကို ကျိန်ဆို စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","အကျွန်ုပ် ကလည်း၊ မိန်းမ သည်မ လိုက် လိုလျှင် အဘယ်သို့ နည်းဟု သခင် ကို မေး လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","သခင်က၊ အကြင်ထာဝရဘုရား သခင်ရှေ့ တော် ၌ ငါသွား လာ၏၊ ထိုဘုရားသည် မိမိ ကောင်းကင်တမန် ကို သင် နှင့်အတူ စေလွှတ် ၍ ၊ သင် သွား သောအမှုကို ပြုစု တော်မူသဖြင့် ၊ ငါ့ အမျိုးသား ချင်း၊ ငါ့ အဘ ၏အိမ် ထဲက ငါ့ သား ဘို့ မယား ကိုယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ငါ့ အမျိုးသား ချင်းတို့ထံသို့ ရောက် သောအခါ ၊ သင်သည် ငါ ပေးသော ကျိန်ဆို ခြင်းနှင့် ကင်းလွတ် စေ။ ထိုသူတို့သည်မိန်းမကိုမ ပေး သော်လည်း ၊ သင် သည် ငါ ပေးသော ကျိန်ဆို ခြင်းနှင့် ကင်းလွတ် စေ မည်ဟု ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ကျွန်ုပ်သည်ယနေ့ ရေတွင်း သို့ ရောက် ပြီးလျှင် ၊ ကျွန်ုပ် သခင် အာဗြဟံ ၏ဘုရားသခင် ထာဝရဘုရား ၊ အကျွန်ုပ် ရောက် လာသောအမှုကို ယခု ပြုစု တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","အကျွန်ုပ် သည် ရေတွင်း နား မှာရပ် နေ၍၊ ရေခပ် ခြင်းငှါ လာ သောအကြင်သမီး ကညာကို၊ ကျွန်ုပ် သောက် ဘို့ သင် ၏ရေဘူး ၌ ရေ အနည်းငယ် ကိုပေး ပါဟုတောင်း သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","သောက် ပါ။ သင် ၏ကုလားအုပ် တို့ဘို့ လည်း ရေခပ် ပါမည်ဟု ပြန်ဆိုသောသမီးကညာသည်၊ ကိုယ်တော် ကျွန် ၏သား ဘို့ ၊ ခန့်ထား တော်မူသောမိန်းမ ဖြစ်ပါစေ သောဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ထိုသို့စိတ်နှလုံး ၌ လျှောက်ဆို ၍ မ ပြီး မှီ၊ ရေဗက္က သည် ရေဘူး ကို ထမ်း လျက် ထွက် လာသဖြင့် ၊ ရေတွင်း သို့ ဆင်း ၍ ရေခပ် သည်ကို ကျွန်ုပ် မြင် လျှင်၊ ရေ သောက်ပါရ စေဟု သူ့ ကို တောင်း လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","သူသည်အလျင် အမြန်ပခုံးပေါ် က ရေဘူး ကို ချ လျက် ၊ သောက် ပါလော့။ သင် ၏ ကုလားအုပ် တို့ကိုလည်း ၊ ရေ တိုက်ပါမည်ဟုဆို သည်အတိုင်း ၊ ကျွန်ုပ်သောက် ရ၏။ ကုလားအုပ် တို့ကိုလည်း ရေတိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ကျွန်ုပ်ကလည်း၊ သင် သည် အဘယ်သူ ၏ သမီး ဖြစ်သနည်းဟုမေး သော်၊ သူက၊ ကျွန်ုပ်သည် မိလခါ ဘွားမြင် သော နာခေါ် သား ဗေသွေလ ၏သမီး ဖြစ်သည် ဟုပြော ဆို၏။ ကျွန်ုပ်သည် မိလခါဘွားမြင်သော နာခေါ်သားဗေသွေလ၏သမီးဖြစ်သည်ဟုပြောဆို၏။ ကျွန်ုပ် သည်လည်း၊ သူ ၏ မျက်နှာ ၌ နှာဆွဲ ကို၎င်း၊ သူ ၏လက် ၌ လက်ကောက် တို့ကို၎င်းထည့် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ဦးညွှတ် ချ၍ ၊ ကျွန်ုပ် သခင် အစ်ကို ၏ မြေး ကို သခင် ၏သား ဘို့ ယူ စေခြင်းငှါ ၊ မှန် သောလမ်း ဖြင့် ပို့ဆောင် တော်မူသောကျွန်ုပ် သခင် အာဗြဟံ ၏ ဘုရားသခင် ထာဝရဘုရား ကို ကောင်းကြီး ပေး၍ ကိုးကွယ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ယခု တွင်သင် တို့သည်၊ ကျွန်ုပ် သခင် ၌ သစ္စာ နှင့် ကျေးဇူး ပြုမည်၊ မ ပြုမည်ကို ပြော ပါ။ ကျွန်ုပ် သည်လည်း ၊ လက်ျာ လမ်းဖြစ်စေ ၊ လက်ဝဲ လမ်းဖြစ်စေ၊ တလမ်းလမ်းသို့ လိုက်သွားပါမည်ဟု ပြောဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","လာဗန် နှင့် ဗေသွေလ တို့ကလည်း ၊ ဤအမှုသည် ထာဝရဘုရား စီရင်တော်မူသောအမှုဖြစ်၏။ အကျွန်ုပ်တို့ သည်၊ သင့် အား ကောင်း မကောင်း ကို မ ပြော နိုင် ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ရေဗက္က သည် သင့် ရှေ့ ၌ရှိပါ၏။ ယူ သွားပါ လော့။ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ သင် ၏ သခင် သား ၏ မယား ဖြစ် စေဟုပြန် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ထိုစကားကိုကြား လျှင် ၊ အာဗြဟံ ကျွန် သည် ဦးညွှတ်ချ၍၊ ထာဝရဘုရား ကို ကိုးကွယ် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ငွေ ဖလား ၊ ရွှေ ဖလား ၊ အဝတ် တန်ဆာများကို ထုတ် ၍ ရေဗက္က အား ပေး ၏။ သူ ၏အမိ ၊ မောင် အား လည်း၊ အဘိုးထိုက်သော လက်ဆောင် ကိုပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","သူ နှင့် သူ ၏အဘော်အပေါင်းတို့သည်၊ စားသောက် ၍ ညဉ့် ကို လွန်စေပြီးမှ ၊ နံနက် ယံ၌ ထ လျက် ၊ ကျွန်ုပ် သည်၊ သခင် ထံသို့ ပြန် ပါရစေဟု ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","မောင် နှင့် အမိ က၊ မိန်းမ ကလေးသည်၊ ကျွန်ုပ် တို့ ထံမှာ ၊ ဆယ် ရက် ခန့် လောက်နေ ပါစေဦး။ နောက်မှ ၊ သူ့ကို သွားပါစေမည်ဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ထို သူကလည်း ၊ ကျွန်ုပ် ကို မ ဆီးတား ပါနှင့်။ ထာဝရဘုရား သည်၊ ကျွန်ုပ် ရောက် လာသောအမှုကို ပြုစု တော်မူပြီ။ ကျွန်ုပ် သည် သခင် ထံသို့ သွား ရသောအခွင့် ကိုပေး ပါလော့ဟုဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","သူတို့က၊ မိန်းကလေး ကို ခေါ် ၍ ၊ သူ့ အလို ကို မေး ပါဦးမည်ဟု ဆို သည်နှင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ရေဗက္က ကို ခေါ် ၍ သင်သည်ဤ လူ နှင့်အတူ ယခုလိုက် မည်လောဟု မေး သောအခါ ၊ ကျွန်ုပ်လိုက် ပါမည် ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","သို့ဖြစ်၍ ၊ မိမိ နှမ ရေဗက္က နှင့် သူ ၏အထိန်း ကို၎င်း ၊ အာဗြဟံ ကျွန် နှင့် သူ ၏လူ တို့ကို၎င်းလွှတ် လိုက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ရေဗက္က ကိုလည်း ၊ သင် သည် ကျွန်ုပ် တို့၏နှမ ဖြစ်၏။ အသောင်း အသိန်းတို့၏အမိဖြစ်ပါစေသော။ သင် ၏အမျိုးအနွယ် သည် ရန်သူ တို့၏ တံခါး များကို အစိုး ရပါစေသောဟု ကောင်းကြီး ပေးကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ရေဗက္က နှင့် သူ ၏မိန်းမငယ် တို့သည်ထ ၍ ၊ ကုလားအုပ် ကိုစီး လျက် ၊ ထိုယောက်ျား နှင့်အတူ လိုက် ကြ ၏။ ထိုသို့ အာဗြဟံကျွန် သည် ရေဗက္က ကို ဆောင်ယူ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ထိုအခါ တောင် ပြည် အတွင်း ၌ နေ သောဣဇာက် သည်၊ ဗေရလဟဲရော လမ်းဖြင့် ရောက် လာသည် ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ညဦး အချိန်၌ ဆင်ခြင် လိုသောငှါ ၊ တော အရပ် သို့ ထွက်သွား ၍ ၊ မြော် ကြည့် လျှင် ၊ ကုလားအုပ် များ လာ သည်ကို မြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ရေဗက္က သည်လည်း ၊ မြော် ကြည့် ၍ ဣဇာက် ကို မြင် သောအခါ ၊ ကုလားအုပ် အပေါ် မှ ဆင်း ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ကျွန်ုပ် တို့ကို ကြိုဆို ခြင်းငှါ ၊ တော ၌ လာ သောထိုသူကား၊ အဘယ်သူ နည်းဟု ကျွန် ကို မေး လေသော် ၊ ကျွန်က၊ ထိုသူ သည် ကျွန်ုပ် သခင် ဖြစ်ပါ၏ဟု ပြောဆို သောစကားကိုကြားလျှင်၊ ရေဗက္ကသည် မျက်နှာဖုံး ကို ယူ ၍ ဖုံး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ကျွန် သည်လည်း၊ မိမိပြု လေသမျှ တို့ကို ဣဇာက် အား ကြား ပြောပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ဣဇာက် သည် မိမိ အမိ စာရာ ၏ တဲ သို့ ရေဗက္က ကို ဆောင်ယူ ၍ စုံဘက် လေ၏။ ရေဗက္က ကိုချစ် နှစ်မြို့သဖြင့် ၊ အမိ သေသောအမှု၌ သက်သာ ခြင်းသို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","တဖန် အာဗြဟံ သည်၊ ကေတုရ အမည် ရှိသောမိန်းမ နှင့် စုံဘက် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ထိုမိန်းမ သည် ဇိမရံ ၊ ယုတ်ရှန် ၊ မေဒန် ၊ မိဒျန် ၊ ဣရှဗက် ၊ ရှုအာ တို့ကို ဘွားမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ယုတ်ရှန် သား ကား ၊ ရှေဘ နှင့် ဒေဒန် တည်း။ ဒေဒန် သား ကား ၊ အာရှုရိမ် လူ၊ လေတုရှိမ် လူ၊ လုမ်မိမ် လူတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","မိဒျိန် သား ကား ၊ ဧဖါ ၊ ဧဖေရ ၊ ဟာနုတ် ၊ အဘိဒ ၊ ဧလဒါ တည်း။ ထို သူအပေါင်း တို့ကား ကေတုရ အနွယ် ဖြစ်ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","အာဗြဟံ သည်၊ မိမိ ဥစ္စာရှိသမျှ ကို ဣဇာက် အား ပေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","မယားငယ် တို့၌ ရသောသား တို့အား လည်း ၊ မိမိ အသက် ရှင်စဉ်တွင်ဆုလပ် များကိုဝေပေး ၍ ၊ သား ဣဇာတ် ထံမှ အရှေ့ ပြည် သို့ လွှတ် လိုက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ထိုနောက် အာဗြဟံ သည် အသက် ကြီးရင့်၍ ၊ အိုမင်း ခြင်း၊ နေ့ရက် ကာလပြည့်စုံ ခြင်းနှင့်တကွ ၊ အသက် ပေါင်း တရာ ခုနစ် ဆယ်ငါး နှစ် ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","အသက်ချုပ် ၍ အနိစ္စ ဖြစ်သဖြင့် ၊ မိမိ လူမျိုး စည်းဝေး ရာသို့ ရောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","သား ဣဇာက် နှင့် ဣရှမေလ တို့သည်၊ မံရေ မြို့ ရှေ့မှာ ၊ ဟိတ္တိ အမျိုးသား၊ ဇောရ သား ဧဖရုန် ၏လယ်ပြင် တွင် ၊ မပ္ပေလ မြေတွင်း ၌ အဘကို သင်္ဂြိုဟ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ဟေသ အမျိုးသား တို့အား အဘိုးပေး၍ အာဗြဟံ ဝယ် သောလယ်ပြင် ၌ ၊ အာဗြဟံ နှင့် မယား စာရာ တို့ကို သင်္ဂြိုဟ် ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","အာဗြဟံ သေ သောနောက် ၊ သား ဣဇာက် ကို ဘုရားသခင် ကောင်းကြီး ပေးတော်မူ၏။ ဣဇာက် သည် ဗေရလဟဲရော မြို့မှာ နေ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","စာရာ ၏ကျွန်မ ၊ အဲဂုတ္တု ၊ အမျိုးသားဟာဂရ ဘွားမြင် သော အာဗြဟံ သား ဣရှမေလ ၏ သားစဉ်မြေးဆက် တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","မိမိ အမျိုးအနွယ် အလိုက် ၊ ဣရှမေလ သား များအမည် ဟူမူကား ၊ သား အကြီး နဗာယုတ်။ ထိုနောက် ကေဒါ ၊ အာဒဗေလ ၊ မိဗသံ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","မိရှမ ၊ ဒုမာ ၊ မာစ ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ဟာဒဒ် ၊ တေမ ၊ ယေတုရ ၊ နာဖိရှ ၊ ကေဒမာ တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ဣရှမေလ သား တည်း။ ထို သို့အမည် ရှိသောသူ တို့ သည်၊ မိမိ မြို့ ၊ မိမိ ရဲတိုက် အလိုက် ၊ အမျိုးမျိုး သော မင်း ဆယ် နှစ် ပါးဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ဣရှမေလ သည် အသက် တရာ သုံး ဆယ်ခုနစ် နှစ် ရှိသော်၊ အသက် ချုပ်၍ သေ သဖြင့် ၊ မိမိ လူမျိုး စည်းဝေး ရာသို့ ရောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","သူတို့သည်လည်း၊ အာရှုရိ ပြည်သို့ သွား ရာလမ်း အရှေ့၊ ရှုရ မြို့ တိုင်အောင် နေ ကြ၏။ ထိုသို့ ဣရှမေလ၏ နေရာသည်၊ မိမိ ညီအစ်ကို အပေါင်း အနား ၌ ကျ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","အာဗြဟံ သား ဣဇာက် ၏အဆက်အနွှယ် ဟူမူကား ၊ အာဗြဟံ သား ကား ဣဇာက် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ဣဇာက် သည်၊ အသက် လေးဆယ် ရှိ သောအခါ၊ ပါဒနာရံ အရပ်သူ၊ ရှုရိ အမျိုးဗေသွေလ ၏သမီး ၊ ရှုရိ လူ လာဗန် ၏ နှမ ရေဗက္က နှင့် အိမ်ထောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ဣဇာက် သည်၊ မိမိ မယား ရေဗက္က မြုံ သောကြောင့် ၊ ထာဝရဘုရား ကို တောင်းပန် ၍ ၊ ထာဝရဘုရား နားထောင် တော်မူသဖြင့် ၊ သူ ၏မယား သည် ပဋိသန္ဓေ စွဲယူလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ဝမ်းအတွင်း ၌ တည်သောသူငယ် တို့သည်၊ အချင်းချင်းတိုက်ခိုက် ကြ၏။ အမိကလည်း၊ ထိုသို့ ဖြစ်၍ငါ ၌အဘယ် အမှုရောက်ပါလိမ့်မည်နည်းဟု ဆို သဖြင့် ၊ ထာဝရဘုရား ကို မေးလျှောက် ခြင်းငှါ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ထာဝရဘုရား ကလည်း ၊ သင် ၏ ဝမ်းအတွင်း ၌ လူမျိုး နှစ် မျိုးရှိ၏။ သင် ၏ဝမ်း ထဲက ခြားနား သော လူစု နှစ် စုကို ဘွားရလိမ့်မည်။ လူ တမျိုးသည် တမျိုး ထက် အားကြီး လိမ့်မည်။ အကြီး သည်အငယ် ၌ ကျွန် ခံရလိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ဘွား ချိန် စေ့ သောအခါ ၊ သူ ၏ဝမ်း ၌ သား အမွှာ ရှိ သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","အဦး ဘွား သောသားသည်၊ အမွေး ပါသောအဝတ် ကဲ့သို့ ဖြစ်၍ ၊ တကိုယ်လုံး အဆင်းနီ ၏။ သူ့ ကို ဧသော ဟူသောအမည် ဖြင့် မှည့် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ထိုနောက်မှ သူ့ ညီ သည်၊ အစ်ကိုဧသော ၏ ဖနှောင့် ကို ကိုင် လျက် ဘွား လာ၏။ သူ့ ကိုကား၊ ယာကုပ် အမည် ဖြင့် မှည့် ကြ၏။ ထို သားနှစ်ယောက်ကို ဘွား သောအခါ ၊ ဣဇာက် သည် အသက် ခြောက် ဆယ်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","သူငယ် တို့သည် ကြီးပွား ၍ ၊ ဧသော ကား လိမ္မာ သော တော သား မုဆိုး ဖြစ် လေ၏။ ယာကုပ် ကားတဲ ၌ နေ တတ်၍ စိတ်ကောင်း သောသူ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ဣဇာက် သည်၊ ဧသော ပေးသောအမဲသား ကို စားလေ့ရှိသောကြောင့် သူ့ ကိုချစ် ၏။ ရေဗက္က မူကား ယာကုပ် ကို ချစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","တနေ့သ၌၊ ယာကုပ် သည် စားစရာကို ချက်ပြုတ်စဉ်တွင် ၊ ဧသော သည် တော မှ လာ ၍ မော သောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ယာကုပ် အား ၊ ထို နီ သောစားစရာနှင့် ငါ့ ကို ကျွေး ပါလော့၊ ငါ မော ပါသည်ဟုဆို လေ၏။ ထိုကြောင့် သူ ၏နာမည် ကို ဧဒုံ ဟုတွင် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ယာကုပ် ကလည်း ၊ ယနေ့ ပင် သင် ၏သားဦး အရာကို၊ ငါ့ အား ရောင်း ပါဟုဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ဧသော က၊ ငါ သေ လုပြီ။ သားဦး အရာအားဖြင့် အဘယ် အကျိုး ရှိပါလိမ့်မည်နည်းဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ယာကုပ် ကလည်း ၊ ယနေ့ပင် ငါ့ အား ကျိန်ဆို ခြင်းကို ပြုပါဟုဆိုသော် ၊ သူသည်ကျိန်ဆို သဖြင့် ၊ ယာကုပ် အား မိမိ သားဦး အရာကို ရောင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ထိုအခါ ယာကုပ် သည်၊ မုန့် နှင့် ပဲဟင်း ကို ဧသော အား ပေး သဖြင့်၊ သူသည် စားသောက် ပြီးမှ ထ ၍ သွား လေ ၏။ ထိုသို့ ဧသော သည်၊ မိမိနှင့် ဆိုင်သောသားဦး အရာကို မထီမဲ့မြင် ပြုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","အာဗြဟံ လက်ထက် ထိုပြည် ၌ ဖြစ် ဘူးသော အစာခေါင်းပါး ခြင်းမှတပါး ၊ နောက်တဖန်အစာခေါင်းပါး ခြင်း ရှိပြန်သည်ဖြစ်၍ ၊ ဣဇာက် သည် ဖိလိတ္တိ မင်းကြီးအဘိမလက် နေရာဂေရာ မြို့သို့ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ထာဝရဘုရား သည်လည်း သူ့ အား ထင်ရှား ၍ ၊ သင်သည် အဲဂုတ္တု ပြည်သို့ မ သွား နှင့်၊ ငါပြော လတံ့သော ပြည် ၌ နေ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ယခု ဤပြည် ၌ တည်းခို ၍နေလော့။ သင့် ဘက် မှာ ငါနေ ၍ ကောင်းကြီး ပေးမည်။ အကြောင်းမူကား ၊ သင် နှင့် သင် ၏အမျိုးအနွယ် အား ဤ ပြည် ရှိသမျှ တို့ကို ငါပေး မည်။ သင် ၏အဘ အာဗြဟံ အား ငါကျိန်ဆို သော စကားရှိသည်အတိုင်း ငါပြု မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","သင် ၏အမျိုးအနွယ် ကို ကောင်းကင် ကြယ် ကဲ့သို့ များပြား စေမည်။ သင် ၏အမျိုးအနွယ် အား လည်း ၊ ဤ ပြည် ရှိသမျှ တို့ကို ငါပေး မည်။ သင် ၏အမျိုးအနွယ် အားဖြင့် လည်း ၊ လူမျိုး အပေါင်း တို့သည် ကောင်းကြီး မင်္ဂလာကို ခံရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","အကြောင်းမူကား ၊ အာဗြဟံ သည် ငါ့ စကား ကို နားထောင် ၍ ၊ ငါ စီရင် မှာထားသော ပညတ် တရား အမျိုးမျိုးတို့ကို စောင့်ရှောက် သတည်းဟုမိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ဣဇာက် သည် ဂေရာ မြို့၌ နေ စဉ်တွင် ၊ - မြို့သားတို့သည် သူ၏မယားအကြောင်းကို မေးသောအခါ၊ ရေဗက္ကသည် လှသောအဆင်းအရောင်ရှိသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ဤပြည် သားယောက်ျား တို့သည် သူ့ အကြောင်းကြောင့် ငါ့ ကိုသတ် မည်ဟုစိုးရိမ် ၍၊ သူသည် ငါ့ မယား ဖြစ်သည်ဟု မ ပြော မဆိုဝံ့၊ ငါ့ နှမ ဖြစ်သည် ဟု ပြော ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ထို မြို့၌ ကာလအတန်ကြာ နေပြီးမှ ၊ တနေ့သ၌၊ ဣဇာက် သည် မိမိ မယား ရေဗက္က နှင့် ကစား သည်။ ဖိလိတ္တိ မင်းကြီး အဘိမလက် သည် ပြတင်းပေါက် ဝက ကြည့် မြင်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ဣဇာက် ကို ခေါ် ၍ ၊ ထို မိန်းမသည်၊ အကယ်စင်စစ် သင် ၏မယား ဖြစ်၏။ သို့ရာတွင် ၊ သူသည် ငါ့ နှမ ဖြစ်၏ဟု အဘယ် ကြောင့်သင်ပြော ရ သနည်းဟုမေး သော်၊ ဣဇာက် က၊ သူ့ အတွက် ကြောင့် ကျွန်ုပ်သေ မည်ကို စိုးရိမ်ပါသည်ဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","အဘိမလက် မင်းကလည်း ၊ ငါ တို့၌ သင်ပြု သောအမှု ကား အဘယ်သို့ နည်း။ တစုံတယောက် သောသူသည်၊ သင် ၏မယား နှင့် အမှတ်တမဲ့ သင့် နေလျှင်၊ ငါ တို့ ခေါင်းပေါ် မှာ သင်သည် အပြစ် ရောက် စေလိမ့်မည် တကားဟု ဆိုပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ဤ လင် မယားကို ပြစ်မှား သောသူသည် ဆက်ဆက်အသေ ခံရမည်ဟု မိမိလူ အပေါင်း တို့ကို မှာ ထားသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ထို ပြည် ၌ ဣဇာက် သည် မျိုးစေ့ကိုကြဲ ၍ ၊ တနှစ် ခြင်းတွင် အဆ တရာ သော အသီးအနှံ ကို ရလေ၏။ ထာဝရဘုရား သည်လည်း ၊ ကောင်းကြီး ပေးတော်မူသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","သူ သည်ကြီးပွါး ၍ ၊ အလွန် စည်းစိမ် ကြီး သည် တိုင်အောင် တိုးတက် လျက် ၊ စီးပွါးဥစ္စာများပြားစွာ ဖြစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","သိုးစု ၊ နွားစု များ၊ ကျွန် များ နှင့် ပြည့်စုံ ကြွယ်ဝ၏။ ထိုကြောင့် ၊ ဖိလိတ္တိ လူတို့သည် သူ့ ကိုငြူစူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","အဘ အာဗြဟံ လက်ထက် ၌ ၊ အဘ ၏ကျွန် တို့ တူး သော ရေတွင်း ရှိသမျှ တို့ကို မြေ နှင့် ဖို့ ပိတ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","အဘိမလက် မင်းကလည်း ၊ သင်သည် ငါ့ တို့ထက် တန်ခိုး ကြီး၏။ ငါ တို့ထံမှ ထွက် သွားလော့ဟု၊ ဣဇာက် ကို အမိန့် ရှိသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ဣဇာက် သည် ထို မြို့မှ ထွက်သွား ပြီးလျှင် ၊ ဂေရာ ချိုင့် ၌ တဲ ကို ဆောက်၍ နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ထိုအခါ ဣဇာက် သည်၊ အဘ အာဗြဟံ ကျွန်တို့ တူး ၍ ၊ အဘသေ သောနောက် ၊ ဖိလိတ္တိ လူတို့ဖို့သော ရေ တွင်း တို့ကို တူး ဘော်ပြန်၍ ၊ အထက်က အဘ သမုတ် သော အမည် ဖြင့် သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ဣဇာက် ကျွန် တို့လည်း ၊ ချိုင့် ထဲ၌ တူး ၍ စမ်း ရေ တွင်း ကို တွေ့ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ဂေရာ အမျိုးသားနွား ကျောင်းတို့ကလည်း ၊ ဤရေ သည် ငါ တို့ရေဖြစ်၏ဟု၊ ဣဇာက် ၏နွား ကျောင်းတို့ နှင့် လုယက် ပြော ဆိုကြ၏။ ထိုသို့ အချင်းချင်းလုယက် ကြသောကြောင့် ၊ ထိုရေတွင်း ကို ဧသက် အမည် ဖြင့်မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","နောက် တဖန် အခြား သောရေတွင်း ကို တူး ပြန် ကြ၏။ ထို ရေတွင်းကို လည်း တဖန် လု ကြသောကြောင့် ၊ သိတန အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ထို အရပ်မှ နေရာ ပြောင်း၍ ၊ အခြား သော ရေတွင်း ကို တူး ကြ၏။ ထို ရေတွင်းကို အဘယ်သူမျှမ လုယက် သောကြောင့် ၊ ငါတို့ နေစရာအခွင့်ကို ယခု ထာဝရဘုရား ပေး တော်မူပြီ ဖြစ်၍ ၊ ဤပြည် ၌ ငါ တို့သည် စီးပွါး များကြလိမ့်မည်ဟုဆို လျက် ၊ ထို ရေတွင်းကို ရဟောဘုတ် အမည် ဖြင့် မှည့် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","တဖန် ထို အရပ်မှ ဗေရရှေဘ အရပ်သို့ ပြောင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ထို နေ့ည မှာ ထာဝရဘုရား သည် ထင်ရှား ၍ ၊ ငါ သည် သင် ၏အဘ အာဗြဟံ ၏ ဘုရား ဖြစ်၏။ မ စိုးရိမ် နှင့်။ ငါ သည်သင့် ဘက် မှာရှိ၏။ ငါသည်ကောင်းကြီး ပေး မည်။ ငါ ၏ကျွန် အာဗြဟံ အတွက် ၊ သင် ၏အမျိုးအနွယ် ကို ငါများပြား စေမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ထို အရပ်၌ ယဇ် ပုလ္လင်ကို တည် ၍ ၊ ထာဝရ ဘုရား ၏ နာမတော် ကို ပဌနာ ပြု၏။ တဲ ကိုလည်း တည်ဆောက် ၍ ၊ ကျွန် တို့သည် ရေတွင်း ကို တူး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ထိုအခါ အဘိမလက် မင်းသည်၊ အဆွေ တော် အဟုဇာတ် နှင့် ဗိုလ်ချုပ် မင်းဖိကောလ တို့ကို ခေါ်၍၊ ဂေရာ မြို့မှ ဣဇာက် ရှိရာသို့ သွား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ဣဇာက် ကလည်း ၊ သင် တို့သည် ငါ့ ကို မြင်ပျင်း ၍ နှင်ထုတ် ပြီးမှ ၊ အဘယ်ကြောင့် လာ ကြသနည်းဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ထိုသူတို့က၊ ထာဝရဘုရား သည် သင့် ဘက် မှာ ရှိ တော်မူကြောင်း ကို၊ ငါ တို့အမှန် သိမြင် သည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ငါ တို့သည် သင့် ကိုမ ထိ မခိုက်၊ ကျေးဇူး ကိုသာ ပြု ၍ ၊ ငြိမ်ဝပ် စွာလွှတ် လိုက်သည်နည်းတူ ၊ သင် သည်ငါတို့ကို အပြစ် မ ပြုရဟု၊ ငါ တို့တစ်ဖက် ၊ သင့် တစ်ဖက် ၊ နှစ်ဘက်သား တို့သည်၊ သစ္စာ ဂတိထား၍ မိဿဟာယ ဖွဲ့ ကြစို့။ သင် သည် ထာဝရဘုရား ကောင်းကြီး ပေးတော်မူသောသူဖြစ် ပါ၏ဟု ဆိုကြလေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ဣဇာက်သည်၊ သူ တို့အဘို့ စားသောက်ပွဲ ကို လုပ် ၍ ၊ အတူစား သောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","နံနက် စောစော ထ၍ ၊ အချင်းချင်း တ ဦးနှင့် တဦးသစ္စာ ပြုလိုက်ပြီးမှ ၊ ဣဇာက် သည် သူ့ တို့ကို လွှတ် လိုက်၍ ၊ သူတို့သည် ငြိမ်ဝပ် စွာသွား ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ထိုနေ့ ၌ ပင် ဣဇာက် ကျွန် တို့သည် လာ ၍ ၊ မိမိတို့ တူး သောတွင်း ၌ ရေ တွေ့ ကြောင်းကို ပြော ဆိုကြလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ထို ရေတွင်းကို ရှေဘ အမည် ဖြင့် မှည့် လေ၏။ ထိုကြောင့် ထိုအရပ်၌ တည်သောမြို့ ကို ဗေရရှေဘ မြို့ဟု ယနေ့ တိုင်အောင် တွင်လေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ဧသော သည် အသက် လေးဆယ် ရှိ သောအခါ ၊ ဟိတ္တိ အမျိုးသားဗေရိ ၏သမီး ယုဒိတ် ၊ ဟိတ္တိ အမျိုးသားဧလုန် ၏သမီး ဗာရှမတ် တို့နှင့် အိမ်ထောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ထိုမိန်းမတို့သည် ဣဇာက် နှင့် ရေဗက္က ၌ စိတ် နှလုံး ပူပန် စရာအကြောင်း ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ထိုနောက်ဣဇာက် သည် အို ၍ မျက်စိ မှုန် သဖြင့် မမြင် နိုင်သောအခါ ၊ သား အကြီး ဧသော ကို၊ ငါ့ သား ဟု ခေါ် လျှင် ၊ အကျွန်ုပ် ရှိ ပါ၏ဟု ထူး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","အဘကလည်း၊ ယခု ငါအို လှပြီ။ အဘယ်သောအခါ သေ ရမည်ကို ငါမ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","မ သေ မှီ ငါ့ ဝိညာဉ် သည် သင့် ကို ကောင်းကြီး ပေးမည်အကြောင်း ၊ သင် ၏လက်နက် တည်းဟူသောလေး နှင့် မြှား တောင့်ကို ဆောင်ယူ လျက် တော သို့ သွား၍ ၊ ငါစားစရာ ဘို့ အမဲ ကောင်ကို ရအောင်ရှာပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ငါမြိန်ရှက် တတ်သော အမဲဟင်း လျာကို ချက် ၍ ငါ့ ထံသို့ ယူ ခဲ့ပါလော့ဟု ပြောဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ထိုသို့ ဣဇာက် သည် သား ဧသော အား ပြောဆို သောစကားကို၊ ရေဗက္က ကြား သည်ဖြစ်၍ ၊ ဧသော သည် အမဲသား ကို ရအောင်တော သို့ အရှာသွား စဉ်တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ရေဗက္က သည် သား ယာကုပ် ကို ခေါ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","သင် ၏အဘ က၊ ငါ မ သေ မှီ ထာဝရ ဘုရား၏ ရှေ့ တော်မှာ သင့် ကို ငါကောင်းကြီး ပေးမည်အကြောင်း ၊ ငါစား စရာဘို့ အမဲသား ကို ယူ ခဲ့၍၊ အမဲဟင်း လျာကို ချက် ပါဟု သင် ၏အစ်ကို ဧသော အား ပြော သည်ကို ငါကြား ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","သို့ဖြစ်၍ ငါ့ သား ၊ ငါ မှာ ထားသမျှသော စကား ကို နားထောင် ပါ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ယခု ဆိတ် စုရှိရာသို့ သွား ၍၊ ကောင်းသော ဆိတ် သငယ် နှစ် ကောင်ကို ငါ့ ထံသို့ ယူ ခဲ့ပါလော့။ သင် ၏အဘ မြိန်ရှက် တတ်သော အမဲဟင်းလျာကို ငါချက် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","သင် ၏အဘ မ သေ မှီ သင့် ကို ကောင်းကြီး ပေး မည်အကြောင်း ၊ ထိုအစာကို အဘ စား စေခြင်းငှါသင် သည် အဘထံသို့ ပို့ဆောင် ရမည်ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ယာကုပ် ကလည်း ၊ ကျွန်ုပ် အစ်ကို ဧသော ကား အမွေး ရှိသောသူ ၊ ကျွန်ုပ် ကားချောမွှတ် သောသူ ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ကျွန်ုပ် အဘ သည် ကျွန်ုပ် ကို စမ်းသပ်ကောင်း စမ်းသပ် လိမ့်မည်။ သို့ဖြစ်လျှင် ကျွန်ုပ်ကိုလှည့်စား သော သူဟူ၍ ထင် သဖြင့်၊ ကျွန်ုပ် သည် မင်္ဂလာ ကိုမ ရဘဲ ကျိန်ခြင်း အမင်္ဂလာကိုသာ ခံရ လိမ့်မည်ဟု အမိ ကိုဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","အမိ ရေဗက္ကလည်း၊ ငါ့ သား ၊ သင် ခံရသောကျိန်ခြင်း အမင်္ဂလာသည် ငါ ၌ သင့်ရောက်ပါစေ။ ငါ့ စကား ကို နားထောင် ၍ ဆိတ်သငယ်တို့ကိုသာ ယူ ခဲ့ပါဟု ဆိုသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","သူသည် သွား ၍ ဆိတ်သငယ်တို့ကို အမိ ထံသို့ ယူ ခဲ့သဖြင့် ၊ အမိ သည်လည်း အဘ မြိန်ရှက် တတ်သော အမဲဟင်းလျာကိုချက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ထိုအခါ ရေဗက္က သည် အိမ် တွင် မိမိ လက် ၌ ရှိသောသား ကြီး ဧသော ၏အဝတ် ၊ ကောင်းမွန် သော အဝတ်ကိုယူ ၍၊ သား ငယ် ယာကုပ် ကို ဝတ် စေလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ဆိတ် သငယ် ၏ သားရေ ကိုလည်း ယူ၍ သူ ၏ လက် ၌၎င်း ၊ လည်ပင်း ချော သော ဘက်၌ ၎င်း ဆင် ယင်ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","မိမိချက် သော အမဲဟင်း နှင့် မုန့် ကိုသား ယာကုပ် လက် ၌ အပ်ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ယာကုပ်လည်း အဘ ထံ သို့ သွား ၍ ၊ အဘ ဟု ခေါ် လေ၏။ အဘကလည်း၊ ငါ ရှိ ၏ငါ့ သား။ သင် သည် အဘယ် သူနည်းဟုမေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ယာကုပ် ကလည်း ၊ အကျွန်ုပ် ကား သား အကြီး ဧသော ဖြစ်ပါ၏။ အဘမှာ ထားသည်အတိုင်း ပြု ပါပြီ။ ထ ၍ထိုင် ပါ။ အဘ၏ဝိညာဉ် သည် အကျွန်ုပ် ကို ကောင်းကြီး ပေးမည်အကြောင်း ၊ အကျွန်ုပ် ၏အမဲသား ကို စား ပါလော့ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","အဘဣဇာက် ကလည်း ၊ ငါ့ သား ၊ ဤ မျှလောက်လျင်မြန်စွာတွေ့ရသောအကြောင်းကား၊ အဘယ်သို့ နည်း ဟု သား အား မေး လျှင်၊ အဘ၏ ဘုရားသခင် ထာဝရဘုရား သည် အကျွန်ုပ် ရှိရာသို့ ဆောင် ခဲ့တော်မူသောကြောင့် ၊ လျင်မြန် စွာတွေ့ ရပါသည်ဟု ပြန်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ဣဇာက် ကလည်း ၊ ငါ့ သား ၊ သင် သည် ငါ့ သား ဧသော မှန် သည် မ မှန်သည်ကိုသိလို၍၊ သင့် ကို ငါစမ်းသပ် စေခြင်းငှါ၊ ငါ့ထံပါးသို့ချဉ်းကပ် ပါလော့ဟုဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ယာကုပ် သည် အဘထံပါးသို့ချဉ်းကပ် ၍ ၊ အဘသည် စမ်းသပ် လျက် ၊ အသံ ကား ယာကုပ် ၏အသံ ၊ လက် တို့ကား ဧသော ၏လက် ဖြစ်ပေသည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ထိုသို့သူ ၏ လက် တို့သည် ဧသော ၏လက် ကဲ့သို့ အမွေး ပါသောကြောင့် ၊ ယာကုပ်ဖြစ်မှန်းကို အဘ မ ရိပ်မိ သဖြင့် ၊ ကောင်းကြီး ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","သို့ရာတွင် တဖန်ကား၊ သင်သည် ငါ့ သား ဧသော စင်စစ် အမှန်ပင် ဖြစ်သလောဟုမေး ပြန်လျင်၊ မှန်ပါသည် ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","အဘကလည်း၊ ငါ့ ထံ ပါးသို့ သွင်း ခဲ့ပါ။ ငါ့ ဝိညာဉ် သည် သင့် ကို ကောင်းကြီး ပေးမည်အကြောင်း ၊ ငါ့ သား ၏ အမဲသား ကို ငါစား အံ့ဟုဆိုလျှင် ၊ ယာကုပ်သည် အဘ ထံ ပါးသို့ သွင်း ၍ ၊ အဘစား လေ၏။ စပျစ်ရည် ကိုလည်း ပေး ၍ အဘသောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ထိုနောက် အဘက၊ ငါ့ သား ချဉ်းကပ် ၍ ငါ့ ကို နမ်း ပါလော့ဟု ဆိုလျှင်၊ ယာကုပ်သည် ချဉ်းကပ် ၍ အဘ ကို နမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","အဘ ဣဇာက် ကလည်း၊ သူ့ အဝတ် ၏ အနံ့ ကိုခံ ၍ ကြည့် ပါ။ ငါ့ သား ၏အနံ့ သည်၊ ထာဝရဘုရား ကောင်းကြီး ပေးတော်မူသောလယ် ၏အမွှေး အကြိုင်နှင့် တူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ထိုကြောင့် ဘုရားသခင် ပင် မိုယ်းကောင်းကင် ၏နှင်း ကို ၎င်း ၊ မြေကြီး ၏ဆီဥ ကို ၎င်း ၊ များစွာ သော ဆန် စပါး၊ စပျစ်ရည် ကို၎င်း ၊ သင့် အား ပေး တော်မူစေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","သူ တပါးတို့သည် သင် ၌ကျွန် ခံ၍ ၊ အပြည်ပြည်တို့သည် သင့် ရှေ့ မှာ ဦးညွှတ် ကြရစေသတည်း။ သင်သည် သင် ၏ညီအစ်ကို တို့၌ အရှင် ဖြစ်၍ ၊ သင့် အမိ သား တို့သည် သင့် ရှေ့ မှာ ဦးညွှတ် ရကြစေသတည်း။ သင့် ကို ကျိန်ဆဲ သောသူအပေါင်းတို့သည် ကျိန်ဆဲ ခြင်းကိုခံရကြစေ သတည်း။ သင့် ကို ကောင်းကြီး ပေးသောသူအပေါင်းတို့ သည် ကောင်းကြီး ကိုခံရကြစေသတည်းဟု ကောင်းကြီးပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ယာကုပ် သည်၊ အဘ ဣဇာက် ပေးသော ကောင်းကြီး မင်္ဂလာကို ခံ၍၊ အဘထံ မှ ထွက်သွား သော ခဏခြင်း တွင်၊ အစ်ကို ဧသော သည် မုဆိုး ပြုရာမှ ရောက် လာ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","သူ သည်လည်း အမဲဟင်း လျာကို ချက် ၍ အဘ ထံ သို့ဆောင် ခဲ့ပြီးလျှင် ၊ အကျွန်ုပ် အဘ ၏ဝိညာဉ် သည်၊ အကျွန်ုပ် ကိုကောင်းကြီး ပေးမည်အကြောင်း ၊ သား ၏ အမဲသား ကို ထ ၍ စား ပါလော့ဟုဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","အဘ ဣဇာက် ကလည်း ၊ သင် သည် အဘယ်သူ နည်းဟုမေး လျှင်၊ အကျွန်ုပ် ကား သား အကြီး ဧသော ဖြစ်ပါ၏ဟု ဆို လေသော် ၊ အဘဣဇာက်သည် အလွန် တုန်လှုပ်၍ အဘယ်သူနည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","အမဲသား ကိုရ၍၊ ငါ့ ထံ သို့ဆောင် ခဲ့ပြီးသောသူ သည် အဘယ် မှာရှိသနည်း။ သင်မ ရောက် မှီ ငါသည် အကုန်အစင် စား ပြီး၍ ၊ သူ့ ကို ကောင်းကြီး ပေးမိပြီ။ သူ သည် ကောင်းကြီး မင်္ဂလာကို ဧကန် အမှန်ခံရလိမ့်မည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","အဘ ဆိုသော စကား ကိုဧသော ကြား လျှင် ၊ အလွန် ပြင်း သောအသံနှင့် သည်းထန် စွာ ငိုကြွေး လျက် ၊ အိုအဘ ၊ အကျွန်ုပ် ကိုလည်း ကောင်းကြီး ပေးပါလော့၊ ပေးပါလော့ဟုဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","အဘက၊ သင့် ညီ သည် လိမ္မာ စွာလာ ၍ ၊ သင် ၏ ကောင်းကြီး မင်္ဂလာကို ယူ သွားပြီဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ဧသောကလည်း၊ သူ့ ကို ယာကုပ် ဟူသောအမည် ဖြင့် လျောက်ပတ် စွာ မှည့် ပါပြီ မဟုတ်လော။ အကျွန်ုပ် ကို နှစ် ကြိမ်လှည့်စား ၍ နိုင်ပါပြီ။ သားဦး အရိပ် အရာကို အရင်ယူ သွားပါပြီ။ ယခု လည်း တဖန် အကျွန်ုပ် ၏ကောင်းကြီး မင်္ဂလာကို ယူ သွားပါပြီဟူ၍၎င်း ၊ အကျွန်ုပ် အဘို့ ကောင်းကြီး မင်္ဂလာတပါးကိုမျှ မ ခြွင်း ပါသလောဟူ၍၎င်း ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ဣဇာက် ကလည်း ၊ သူ့ ကို သင် ၏အရှင် ဖြစ် စေပြီ။ ညီအစ်ကို အပေါင်း တို့ကို သူ ၌ ကျွန် ခံ စေပြီ။ ဆန် စပါး၊ စပျစ်ရည် နှင့် သူ့ ကိုထောက် မပြီး။ သို့ဖြစ်၍ ငါ့ သား ၊ သင် ၌ အဘယ်သို့ ပြု နိုင်တော့အံ့နည်းဟု၊ ဧသော အား ပြန် ပြောလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ဧသော က၊ အိုအဘ ၊ ကောင်းကြီး မင်္ဂလာ တစုံတခု မျှ မရှိပါသလော၊ အိုအဘ၊ အကျွန်ုပ် ကိုလည်း ကောင်းကြီး ပေးပါလော့၊ ပေးပါလောဟု အဘ အား ပြော ဆိုလျက် ၊ တဖန် အသံ ကိုလွှင့် ၍ ငိုကြွေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","အဘ ဣဇာက် ကလည်း ၊ ကြည့်ရှု ပါ။ သင် ၏ နေရာ သည် မြေကြီး ၏ဆီဥ နှင့် ၎င်း ၊ အထက် မိုယ်း ကောင်းကင် ၏နှင်း နှင့် ၎င်း ပြည့်စုံ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ထား ဖြင့် အသက် ကိုမွေးရလိမ့်မည်။ ညီ ၌ ကျွန် ခံရလိမ့်မည်။ နောက် တဖန် အစိုးရ သောအခါ ၊ သူ တင် သောထမ်းဘိုး ကို သင် ၏လည်ပင်း မှ ချိုး ပယ်လိမ့်မည်ဟု ပြန် ၍ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","အဘ သည် ယာကုပ် အားပေး သော ကောင်းကြီး မင်္ဂလာကြောင့် ၊ ဧသော သည် ယာကုပ်ကို အငြိုး ထား၍ ၊ ငါ့ အဘ ကြောင့် ညည်းတွား ရသော နေ့ရက် ကာလ အချိန် နီး ပြီ။ ထိုအခါ ငါ့ ညီ ယာကုပ် ကို ငါသတ် မည်ဟု၊ အကြံ နှင့် ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ထိုသို့သား ကြီး ဧသော ပြောသောစကား ကို အမိ ရေဗက္က ကြား လျှင် ၊ သား ငယ် ယာကုပ် ကိုခေါ် ၍ ၊ သင် ၏ အစ်ကို ဧသော သည် သင့် ကို သတ် သဖြင့် ၊ သင့် အမှု၌ စိတ် ပြေလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ထိုကြောင့် ၊ ငါ့ သား ၊ ငါ့ စကား ကို နားထောင် ပါ။ ငါ့ မောင် လာဗန် နေရာခါရန် မြို့သို့ ထ ၍ ပြေး သွား ပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","သင် ၏အစ်ကို စိတ် ပြေ သည်တိုင်အောင် ၊ သူ့ ထံမှာ ခဏရှောင်၍ နေ ပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","သင် ၏အစ်ကို စိတ် ပြေ ၍၊ သင် သည် သူ ၌ ပြု သောအမှု ကိုသူမေ့လျော့ သောအခါ ၊ ငါမှာ လိုက်၍ ၊ ထို အရပ်မှ သင့် ကို ဆောင် ခဲ့စေမည်။ ငါ့သားနှစ် ယောက် လုံးကို တ နေ့ ခြင်းတွင် အဘယ်ကြောင့် ငါရှုံး ရမည်နည်း ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","တဖန် ရေဗက္က သည် ဣဇာက် ထံ သို့သွား၍၊ ကျွန်မ သည် ဟေသ အမျိုးသမီး တို့ ကြောင့်၊ ကိုယ်အသက် ကို ငြီးငွေ့ လှ၏။ ဤ ပြည် သူသမီး ကဲ့သို့ သောသူ၊ ဟေသ အမျိုးသမီး နှင့် ယာကုပ်အိမ်ထောင် ဘက်ပြု လျှင် ၊ ကျွန်မ အသက်ရှင် ၍ အဘယ် ကျေးဇူးရှိပါလိမ့်မည်နည်းဟု ပြောဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ထိုအခါ ဣဇာက် သည် ယာကုပ် ကို ခေါ် ၍ ၊ သင်သည် ခါနာန် အမျိုးသမီး နှင့် အိမ်ထောင် ဘက်မ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","အမိ ၏အဘ ဗေသွေလ အမျိုးသားနေရာ ပါဒနာရံ အရပ်သို့ ထ ၍ သွား လော့။ သင့် ဦးရီး လာဗန် ၏ သမီး တစုံတယောက်နှင့် အိမ်ထောင် ဘက်ပြု လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","အနန္တ တန်ခိုးရှင် ဘုရား သခင်သည် ကောင်းကြီး ပေး၍ တိုးပွား စေသဖြင့်၊ သင်သည် အမျိုး ကြီး ဖြစ် မည် အကြောင်း နှင့် များပြား စေတော်မူစေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","အထက်က အာဗြဟံ အား ပေး တော်မူ၍ ၊ သင် ယခု ဧည့်သည် ဖြစ်လျက်နေသောဤပြည် ကို၊ သင် အမွေ ခံရမည်အကြောင်း ၊ သင့် အား၎င်း၊ သင် ၏အမျိုးအနွယ် အား ၎င်း ၊ အာဗြဟံ ၏ ကောင်းကြီး မင်္ဂလာကို ပေး တော်မူ စေသတည်းဟု ကောင်းကြီး ပေးလျက် မှာ ထား၍ လွှတ် လိုက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ထိုသို့ ယာကုပ် နှင့် ဧသော ၏ အမိ ၊ ရေဗက္က ၏ မောင် ၊ ရှုရိ လူဗေသွေလ သား လာဗန် နေရာ ပါဒနာရံ ပြည် သို့ ယာကုပ် သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ထိုသို့ ဣဇာက် သည် ယာကုပ် ကို ကောင်းကြီး ပေး၍ ၊ ပါဒနာရံ ပြည်၌ အိမ်ထောင် ဘက်ပြု စေခြင်းငှါ လွှတ် လိုက်သောအကြောင်းကို၎င်း၊ ခါနာန် အမျိုးသမီး နှင့် အိမ်ထောင် ဘက်မ ပြု ရဟု၊ ကောင်းကြီး ပေးသောအခါ မှာ ထားကြောင်းကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ယာကုပ် သည် မိဘ စကားကို နားထောင် ၍ ၊ ပါဒနာရံ ပြည်သို့ သွား ကြောင်း ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ခါနာန် အမျိုးသမီး တို့ကို အဘ ဣဇာက် မ နှစ်သက်ကြောင်း ကို၎င်း၊ ဧသော သိ မြင်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ဣရှမေလ ထံ သို့သွား ၍ အထက် မယား တို့မှတပါး၊ အာဗြဟံ သား ဣရှမေလ သမီး ၊ နဗာယုတ် နှမ ၊ မဟာလတ် နှင့် တဖန် အိမ်ထောင် ဘက် ပြုပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ယာကုပ် သည် ဗေရရှေဘ ရွာမှ ထွက် ၍ ၊ ခါရန် ပြည်သို့ ခရီးသွား စဉ်တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","တစုံတခုသောအရပ် သို့ ရောက် ၍ ၊ မိုဃ်းချုပ် သောကြောင့် ၊ ညဉ့် ကို လွန်စေမည်အကြံရှိသည်နှင့်၊ ထိုအရပ် ၌ ကျောက် ကိုယူ ၍ ခေါင်းအုံး ဘို့ ထား ပြီးလျှင် အိပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","မြင် ရသောအိပ်မက် ဟူမူကား ၊ မြေကြီး ပေါ် ၌ လှေကား ထောင် လျက် အဖျား သည် မိုဃ်းကောင်းကင် တိုင်အောင် မှီ ၏။ ဘုရားသခင် ၏ ကောင်းကင် တမန်တို့ သည်၊ ထို လှေကားဖြင့် ဆင်း လျက် တက် လျက် ရှိ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ထာဝရဘုရား သည် လှေကားထက် ၌ ရပ် တော်မူလျက် ၊ ငါ သည် သင် ၏အဘ အာဗြဟံ ဘုရား ၊ ဣဇာက် ၏ ဘုရား တည်းဟူသော ထာဝရဘုရား ဖြစ်၏။ သင် အိပ် သော မြေ ကို သင် နှင့် သင် ၏ အမျိုးအနွယ် အား ငါပေး မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","သင် ၏အမျိုးအနွယ် သည် မြေမှုန့် ကဲ့သို့ များပြားလိမ့်မည်။ အရှေ့ ၊ အနောက် ၊ တောင် ၊ မြောက် ၊ လေးမျက်နှာအရပ် တို့သို့ နှံ့ပြား ကြလိမ့်မည်။ သင်နှင့်သင် ၏အမျိုးအနွယ် အားဖြင့် လူမျိုး အပေါင်း တို့သည် ကောင်းကြီး မင်္ဂလာကို ခံကြရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ငါ သည် သင့် ဘက် မှာရှိ၏။ သင်သွား လေရာရာ ၌ ငါစောင့် မမည်။ ဤပြည် သို့ တဖန် ဆောင် ခဲ့ဦးမည်။ ဂတိ ထားသည်အတိုင်း မပြည့်စုံမှီ၊ သင့် ကိုငါမ စွန့် ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ယာကုပ် သည်အိပ်ပျော် ရာမှ နိုး လျင် ၊ အကယ်စင်စစ် ထာဝရဘုရား သည် ဤအရပ် ၌ ရှိ တော်မူ၏။ ရှိ တော်မူကြောင်းကို ငါ မ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ဤအရပ်ကား၊ အဘယ်မျှလောက်ကြောက်မက်ဘွယ်ဖြစ်သည်တကား။ ဤအရပ်ကား၊ အခြားမဟုတ်၊ ဘုရားသခင် ၏ ဘုံ ဗိမာန်၊ ကောင်းကင် တံခါး ဝ ဖြစ်သည် တကားဟု၊ ကြောက်ရွံ့ ခြင်းသို့ ရောက်၍ ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","နံနက် စောစော ယာကုပ် သည်ထ၍ ၊ ခေါင်းအုံး သော ကျောက် ကို ယူ သဖြင့် ၊ မှတ် တိုင်ဖြစ် စေလျက် ထူ ထောင်ပြီးလျှင်၊ ကျောက် ထိပ် ဖျားအပေါ် ၌ ဆီ ကို လောင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ထို အရပ် ကိုလည်း၊ ဗေသလ အမည် ဖြင့် မှည့် လေ၏။ ထိုမြို့ ၏ အမည် ဟောင်း ကား၊ ဥလံလုဇ ဟူ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ထိုအခါ ယာကုပ် က၊ ဘုရားသခင် သည် ငါ့ ဘက် ၌ ရှိ လျက် ၊ ငါ ယခု သွားရာလမ်း မှာ ၊ ငါ့ ကို စောင့်မ ၍ စား စရာ အစား ၊ ဝတ် စရာ အဝတ် ကိုပေး သနားတော်မူလျှင် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ငါသည် တဖန် အဘ ၏အိမ် သို့ ငြိမ်ဝပ် စွာ ပြန် ရောက်၍ ၊ ထာဝရဘုရား သည်ငါ ၏ ဘုရား ဖြစ် တော်မူလျှင် ၎င်း၊ မှတ် တိုင်ပြု၍ ငါထူထောင် သော ဤ ကျောက် သည်လည်း ၊ ဘုရားသခင် ၏ ဗိမာန် ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ပေး သနားတော်မူသမျှ တို့ကို ဆယ်ဘို့ တဘို့ပူဇော် ပါမည်ဟူ၍သစ္စာ ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","တဖန် ယာကုပ် သည် ခရီးသွား ၍ ၊ အရှေ့ ပြည်သား တို့နေရာ အရပ်သို့ ရောက်ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","မြော် ကြည့်၍ တော စ၌ ရေတွင်း တခုကို မြင် ၏။ ထိုတွင်း ရေ ဖြင့် သိုးစု များကို တိုက်တတ်သည်ဖြစ်၍၊ တွင်းနား မှာ သိုးစု သုံး စု အိပ် လျက်ရှိ၏။ ရေတွင်း ဝ ပေါ် မှာ ကြီးစွာ သော ကျောက် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","သိုး ထိန်းအပေါင်း တို့သည် ထို အရပ်၌ စုဝေး သောအခါ ၊ ရေတွင်း ဝ ၌ ဖုံးအုပ်သော ကျောက် ကို လှိမ့် လှန်၍ ၊ သိုး များကို ရေ တိုက်ပြီးလျှင် ၊ ထိုကျောက် ကို မိမိ နေရာ ရေတွင်း ဝ ပေါ် မှာ တဖန် တင်ထားလေ့ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ယာကုပ် ကလည်း ၊ ငါ့ ညီအစ်ကို တို့၊ သင် တို့သည် အဘယ် အရပ်က လာကြသနည်းဟုမေး လျှင်၊ ငါ တို့သည် ခါရန် မြို့က လာကြသည်ဟုပြော ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","တဖန် ယာကုပ်က၊ နာခေါ် သား လာဗန် ကို သိ သလောဟု မေး လျှင်၊ သိ ၏ဟု ပြန် ဆိုသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","သူသည်မာ ပါ၏လောဟု တဖန် မေး ပြန်လျှင် ၊ မာ ပါ၏။ သူ ၏သမီး ရာခေလ သည် သိုး များနှင့်တကွ လာ လိမ့်မည်ဟု ဆို ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ယာကုပ်ကလည်း၊ နေ့ အချိန် အလွန်များ စွာရှိသေး၏။ သိုး တို့ကို စုဝေး ရာအချိန် မ ဟုတ်သေး။ ရေတိုက် ပြီးလျှင်၊ သွား ၍ ထိန်း ကြဦးလော့ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","သူတို့ကလည်း၊ သိုး ထိန်းအပေါင်း စုဝေး ၍ ၊ ရေတွင်း ဝ ၌ ဖုံးအုပ်သော ကျောက် ကို လှိမ့် လှန်ပြီးမှ သာ၊ သိုး တို့ကို ရေတိုက် ရ၏။ သို့မဟုတ်၊ မ တိုက်ရဟု ပြန် ဆိုကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ထိုသို့ တဦးနှင့်တဦးနှုတ်ဆက် ကြစဉ်တွင် ၊ ရာခေလ သည်၊ မိမိ အဘ ၏သိုး တို့ကို ထိန်းရသည် ဖြစ်၍ ၊ သိုး တို့ကို ဆောင် လျက်လာ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ယာကုပ် သည်၊ မိမိ ဦးရီး လာဗန် ၏သမီး ရာခေလ နှင့် ဦးရီး လာဗန် ၏သိုး တို့ကို မြင် သောအခါ ၊ အနီးသို့ချဉ်း ၍ ၊ ရေတွင်း ၌ ဖုံးအုပ်သော ကျောက် ကို လှိမ့် လှန်ပြီးလျှင် ၊ ဦးရီး လာဗန် ၏ သိုး တို့ကို ရေတိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ထိုနောက် ၊ ယာကုပ် သည် ရာခေလ ကို နမ်း ၍ ၊ ကျယ် သော အသံ နှင့် ငို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","မိမိသည် ရာခေလ အဘ ၏ တူ၊ ရေဗက္က ၏သား ဖြစ်ကြောင်း ကို ကြားပြော လျှင် ၊ ရာခေလ သည်ပြေး ၍ မိမိ အဘ အား ပြန် ကြားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","လာဗန် သည် မိမိ တူ ယာကုပ် ၏ သိတင်း စကား ကို ကြား သောအခါ ၊ ကြိုဆို ခြင်းငှါ အလျင်အမြန် သွား၍ ၊ ပိုက် ဘက်နမ်းရှုတ် လျက် ၊ မိမိ အိမ် သို့ ဆောင် သွားလေ၏။ ယာကုပ်သည်လည်း မိမိ အမှုအရာ ရှိသမျှ ကို ကြား ပြောလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","လာဗန် က၊ အကယ်စင်စစ် သင် သည် ငါ့ အရိုး အသား ပင်ဖြစ်၏ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ယာကုပ် သည် တ လခန့်မျှ နေ ပြီးမှ၊ လာဗန် က၊ သင် သည် ငါ့ တူ ဖြစ်သောကြောင့် ၊ အကျိုး မဲ့ကျွန် ခံရပါ မည် လော။ ခံလိုသောအခ ကို ငါ့ အား ပြော လော့ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ထိုအခါ လာဗန် ၌ သမီး နှစ် ယောက်ရှိ၏။ အကြီး ကား၊ လေအာ အမည် ရှိ၏။ အငယ် ကား၊ ရာခေလ အမည် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","လေအာ ကား၊ မျက်စိ နုညံ့ ၏။ ရာခေလ ကား၊ ပုံ ပြင်ယဉ်ကျေး ၍ အသွေး အဆင်းလည်းလှ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ယာကုပ် သည် ရာခေလ ကို ချစ် သောကြောင့်၊ လာဗန်အား၊ ဦးမင်းသမီး အငယ် ရာခေလ ကိုရခြင်းငှါ၊ ခုနစ် နှစ် အစေ ခံပါမည်ဟု ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","လာဗန် က၊ အခြား သောသူ အား ပေးစား သည် ထက် ၊ သင့် အား ပေးစား သော် သာ၍ကောင်း ၏။ ငါ နှင့်အတူ နေ လော့ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ယာကုပ် သည်လည်း ၊ ရာခေလ ကို ရခြင်းငှါခုနစ် နှစ် အစေခံ လေ၏။ ရာခေလ ကိုချစ် သောကြောင့် ၊ ခုနစ်နှစ်ကို နည်း သောနေ့ရက် ကဲ့သို့ ထင် မှတ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ယာကုပ် ကလည်း ၊ ချိန်းချက်သော အချိန် စေ့ ပါပြီ။ ကျွန်ုပ် သည် မယား နှင့် ဆက်ဆံ ဘို့ရာ ပေးစား ပါဟု လာဗန် အား ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","လာဗန် သည် ထိုအရပ် ၌နေသောသူ အပေါင်း တို့ကို စည်းဝေး စေ၍ ပွဲ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ည ဦးအချိန်ရောက် မှ၊ ဇိလပအမည်ရှိသောကျွန်မကို သမီး လေအာ ၌ လက်ဖွဲ့ လျက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ထိုသမီး ကို ဆောင် သွင်း၍ ၊ ယာကုပ်သည် သူ နှင့် ဆက်ဆံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","နံနက် အချိန်ရောက် မှ ယာကုပ်သည် ကြည့်ရှုသောအခါ၊ လေအာ ဖြစ် ကြောင်းကို သိမြင် လျှင် ၊ လာဗန် ထံသို့ သွား၍ ကျွန်ုပ် ၌ ပြု သောအမှုကား၊ အဘယ်သို့ နည်း။ ကျွန်ုပ်သည် ရာခေလ ကိုရခြင်းငှါ အစေခံ ရပြီ မ ဟုတ်လော။ ကျွန်ုပ် ကို အဘယ်ကြောင့် လှည့်စား ရသနည်းဟု ဆို သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","လာဗန် က၊ ငါ တို့ပြည် ၌ သမီး အကြီးကို မ ပေးစား မှီ၊ အငယ် ကို မပေးစားရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ခုနစ် ရက်စေ့ အောင် ငံ့ဦးလော့။ နောက် တဖန် ခုနစ် နှစ် အစေခံ ရသည်အတွက် ၊ ရာခေလကိုလည်း သင့် အား ပေးစား ဦးမည်ဟု ဆိုသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ယာကုပ် ဝန်ခံ ၍ ခုနစ် ရက်စေ့ ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","လာဗန် သည် ဗိလဟာ အမည်ရှိသောကျွန် မကို လက်ဖွဲ့ လျက် ၊ သမီး ရာခေလ ကို ပေးစား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ယာကုပ်သည် ရာခေလ နှင့် ဆက်ဆံ ၍ ၊ လေအာ ကို ချစ်သည်ထက် သာ၍ချစ် ၏။ လာဗန်ထံမှာတဖန် ခုနစ် နှစ် အစေခံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","လေအာ သည် အမုန်း ခံရသည်ကို ထာဝရဘုရား သိမြင် ၍ ၊ သား ဘွားရသောအခွင့် ကိုပေး တော်မူ၏။ ရာခေလ မူကား မြုံ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","လေအာ သည် ပဋိသန္ဓေ ယူသဖြင့် ၊ သား ကို ဘွားမြင် ၍ ရုဗင် အမည် ဖြင့် မှည့် လေ၏။ အကြောင်း မူကား၊ ထာဝရဘုရား သည် ငါ ၏ဆင်းရဲ ခံခြင်းကို အမှန် ကြည့် မြင်တော်မူပြီ။ သို့ဖြစ်၍ယခု ငါ့ လင် သည် ငါ့ ကိုချစ် လိမ့်မည်ဟု ဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","တဖန် ပဋိသန္ဓေ ယူပြန်၍ သား ကိုဘွားမြင် သော် ၊ ငါ သည် အမုန်း ခံရကြောင်းကို ထာဝရဘုရား ကြား သောကြောင့် ၊ ဤ သားကိုလည်း ပေး သနားတော်မူပြီဟု ဆို ပြီးလျှင် ၊ ထို သားကို ရှိမောင် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","တဖန် ပဋိသန္ဓေ ယူပြန်၍ သား ကိုဘွားမြင် သော် ၊ ငါ့ လင် အား သား သုံး ယောက်ကို ငါဘွားမြင် သောကြောင့် ၊ ယခုတခါသူသည် ငါ နှင့်ပေါင်းဘော် လိမ့်မည်ဟု ဆို ၍ ၊ ထို သားကို လေဝိ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","တဖန် ပဋိသန္ဓေ ယူပြန်၍ သား ကို ဘွားမြင် သော် ၊ ထာဝရဘုရား ကို ယခုငါချီးမွမ်း မည်ဟု ဆို သည် ဖြစ်၍ ၊ ထို သားကို ယုဒ အမည် ဖြင့် မှည့် လေ၏။ ထိုနောက် ၊ သား ပြတ်၍ မဘွားဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ရာခေလ သည် ယာကုပ် အား သား မ ဘွား ကြောင်း ကို မိမိသိမြင် သောအခါ ၊ အစ်မ ကို ငြူစူ သောစိတ် ရှိ၍ ၊ ငါ့ အား သား ကိုပေး ပါ။ သို့မဟုတ် ငါ သေ တော့ အံ့ဟု ယာကုပ် ကို ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ယာကုပ် ကလည်း ၊ ငါ သည် သင့် အား သား ဘွားသောအခွင့်ကိုပေး တော်မမူသော ဘုရားသခင် ကိုယ်စား တော်ဖြစ်သလောဟု၊ ရာခေလ ကို အမျက် ထွက် ၍ ပြန်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ရာခေလကလည်း၊ အကျွန်ုပ် ၌ ကျွန် မဗိလဟာ ရှိ ပါ၏။ သူ့ ထံသို့ ဝင် ပါ။ သူသည် အကျွန်ုပ် ဒူး ပေါ် မှာ သားဘွား ၍ ၊ သူ့ အားဖြင့် အကျွန်ုပ် သည် တည်ဆောက် ခြင်းရှိပါလိမ့်မည်ဟု ဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ကျွန် မဗိလဟာ ကို ယာကုပ် ၏ မယား ဖြစ် စေခြင်းငှါအပ် ၍ ၊ သူ့ ထံ သို့ယာကုပ် ဝင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ဗိလဟာ သည် ပဋိသန္ဓေ ယူ၍ ၊ ယာကုပ် အား သား ကို ဘွားမြင် သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ရာခေလ က၊ ဘုရားသခင် သည် ငါ့ ဘက်၌ တရားစီရင် တော်မူပြီ။ ငါ့ စကား ကို ကြား ၍ သား ကို ပေး သနားတော်မူပြီဟု ဆို သည်နှင့်အညီ ၊ ထို သားကို ဒန် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","တဖန် ရာခေလ ၏ကျွန်မ ဗိလဟာ သည် ပဋိသန္ဓေ ယူပြန်၍ ၊ ယာကုပ် အား နှစ် ကြိမ်မြောက်သော သား ကိုဘွား မြင်သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ရာခေလ က၊ ငါသည် ငါ့ အစ်မ နှင့် ကျပ်ကျပ် လုံးထွေး၍ နိုင် ခဲ့ပြီဟု ဆို ၍ ၊ ထို သားကို နဿလိ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","လေအာ သည် သား ပြတ်၍ မဘွားဘဲနေ ကြောင်းကို မိမိသိမြင် သောအခါ ၊ မိမိ ကျွန် မ ဇိလပ ကို ယူ ၍ ၊ ယာကုပ် ၏မယား ဖြစ် စေခြင်းငှါအပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","လေအာ ၏ ကျွန် မဇိလပ သည်လည်း ယာကုပ် အား သား ကိုဘွား မြင်သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","လေအာ က၊ ကောင်းကျိုး လာသည်ဟု ဆို ၍ ၊ ထို သားကို ဂဒ် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","တဖန် လေအာ ၏ ကျွန် မဇိလပ သည် ယာကုပ် အား နှစ် ကြိမ်မြောက်သောသား ကို ဘွားမြင် သည် ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","လေအာ က၊ ငါ ၌ မင်္ဂလာ ရှိ၏။ လူ သမီးတို့သည် ငါ့ ကိုမင်္ဂလာ ရှိသောသူဟူ၍ ခေါ်ကြလိမ့်မည်ဟု ဆို သဖြင့် ၊ ထို သားကို အာရှာ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ထိုနောက် ၊ ဂျုံ စပါးကို စုသိမ်း သော အချိန် ကာလ ၌ ၊ ရုဗင် သည် လယ်ပြင် သို့ ထွက်သွား ပြီးလျှင် ၊ အနုဆေးသီး ကိုတွေ့ ၍ ၊ မိမိ အမိ လေအာ ထံ သို့ ဆောင် ခဲ့လေ ၏။ ရာခေလ ကလည်း ၊ သင် ၏သား ရခဲ့သော အနုဆေးသီး အချို့ကိုပေး ပါလော့ဟု၊ လေအာ ကို တောင်း လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","လေအာက၊ သင်သည် ငါ့ လင် ကိုယူ ၍ အတွက် မရှိထင်သလော။ ငါ့ သား ၏ အနုဆေးသီး ကိုလည်း ယူ ချင် သေးသည်တကားဟု ဆို လေသော် ၊ ရာခေလ က၊ သို့ဖြစ်လျှင် ၊ သင့် သား ၏ အနုဆေးသီး အတွက် ၊ လင်သည် ယနေ့ညဉ့်တွင် သင် နှင့် အိပ်ရမည်ဟု ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ညဦး အချိန်၌ ၊ လယ်ပြင် မှ ယာကုပ် လာ သောအခါ ၊ လေအာ သည် ခရီးဦးကြိုပြု ခြင်းငှါ သွား ၍ ၊ သင် သည် အကျွန်ုပ် ထံသို့ ဝင် ရမည်။ အကျွန်ုပ် ၏သား ရခဲ့ သော အနုဆေးသီး နှင့် သင့် ကို အကျွန်ုပ်ငှါး သည် မှန်ပါ ၏ဟုဆို သဖြင့် ၊ ထို နေ့ညဉ့် တွင် သူ နှင့် အိပ် ရလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","လေအာ စကားကို ဘုရားသခင် နားထောင် တော်မူသဖြင့် ၊ သူသည် ပဋိသန္ဓေ ယူ၍ ၊ ယာကုပ် အား ပဉ္စမ သား ကို ဘွားမြင် လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ငါ့ ကျွန် မကို ငါ့ လင် အား ပေး သောကြောင့် ၊ ဘုရားသခင် သည် ငါ့ အား အခ ကို ပေး တော်မူပြီဟုဆို ၍ ၊ ထို သားကို ဣသခါ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","တဖန် လေအာ သည် ပဋိသန္ဓေ ယူပြန် ၍ ၊ ယာကုပ် အား ဆဌမ သား ကို ဘွားမြင် လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ဘုရားသခင် သည် ကောင်း သောလက် ဖွဲ့ကိုပေး သနားတော်မူပြီ။ ငါ့ လင် အား သား ခြောက် ယောက်ကို ဘွားမြင် သောကြောင့် ၊ ယခု ငါ နှင့် အမြဲ နေလိမ့်မည်ဟု ဆို ၍ ၊ ထို သားကို ဇာဗုလုန် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ထိုနောက်မှ သမီး ကိုဘွား ၍ ၊ ဒိန အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ထိုအခါ ဘုရားသခင် သည် ရာခေလ ကို အောက်မေ့ တော်မူ၏။ သူ ၏စကားကို နားထောင် ၍ ၊ သား ဘွားသောအခွင့် ကိုပေး တော်မူသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","သူသည် ပဋိသန္ဓေ ယူ၍ သား ကိုဘွားမြင် လျှင် ၊ ငါ ခံရသောကဲ့ရဲ့ ခြင်းအကြောင်းကို ဘုရားသခင် သည် ပယ် တော်မူပြီဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ထာဝရဘုရား သည် အခြား သောသား ကို ထပ် ၍ပေးတော်မူပါစေသောဟူ၍၎င်း ဆိုလျက်၊ ထို သားကို ယောသပ် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ရာခေလ သည် ယောသပ် ကို ဘွားမြင် ပြီး သော နောက်၊ ယာကုပ် က၊ အကျွန်ုပ် သည် ကိုယ် နေရင်း ပြည် သို့ သွား မည်အကြောင်း အကျွန်ုပ် ကို လွှတ် ပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ကျွန်ုပ် သည် အစေခံ ၍ရသော မယား နှင့် သား တို့ကို ဆောင်ယူ၍၊ သွား ရသောအခွင့် ကိုပေး ပါလော့။ ကျွန်ုပ် အစေခံ သည်အကြောင်း ကို အဘ သိ ပါသည်ဟု လာဗန် အား ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","လာဗန် က၊ သင် ၏စိတ် နှင့် တွေ့ ပါစေ။ ထာဝရဘုရား သည် သင် ၏အကြောင်း ကြောင့် ငါ့ အား ကောင်းကြီး ပေးတော်မူသည်ကို ငါရိပ်မိ ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ငါ ပေးရမည့်အခ ကို ပြော ပါ၊ ငါပေး မည်ဟု ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ကျွန်ုပ်သည် အဘ၌ အဘယ်သို့ အစေခံ သည် ကို၎င်း အဘ၏တိရစ္ဆာန် တို့သည် ကျွန်ုပ် ၌ အဘယ်သို့ ရှိ နေသည်ကို၎င်းအဘ သိ ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","အထက် က အဘ ၏ ဥစ္စာနည်း လှ၏။ ယခု တိုးပွါး ၍ များပြား လျက်ရှိ၏။ ကျွန်ုပ် သွား လာလုပ် ကိုင်သောအားဖြင့်၊ ထာဝရဘုရား သည် အဘ အား ကောင်းကြီး ပေးတော်မူပြီ။ ယခုမှာ၊ ကျွန်ုပ် သည် ကိုယ် အိမ်သူအိမ်သား တို့ကို အဘယ် သောအခါ ကျွန်ုပ်ပြု စု ရပါအံ့နည်းဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","လာဗန်ကလည်း၊ အဘယ် အခကို ပေး ရ မည်နည်းဟုမေး ပြန်လျှင် ၊ ယာကုပ် က၊ ဘာကိုမျှ မ ပေး ပါနှင့်၊ ကျွန်ုပ် ၌ ကျေးဇူးတခု ပြု လိုလျှင် ၊ အဘ၏သိုး စု၊ ဆိတ်စုကို တဖန် ကျွေးမွေးစောင့်ထိန်း ပါဦးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ယနေ့ သိုးစု၊ ဆိတ်စုတရှောက်လုံး ကို ကျွန်ုပ် သွား ၍ ၊ ပြောက် ကျား သောဆိတ် များ ညို သော သိုး များ၊ ရှိသမျှ တို့ကိုရွေးနှုတ် ခွဲထားပါမည်။ နောက်မှပြောက်ကျားသောဆိတ်၊ ညိုသောသိုး တို့သည် ကျွန်ုပ် ၏ အခ ဖြစ် စေလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","သို့ဖြစ်၍ ၊ နောင် ကာလ ၌ ကျွန်ုပ် ၏အခ သည်၊ အဘရှေ့ သို့ ရောက် သောအခါ ၊ ကျွန်ုပ် ၏ဖြောင့်မတ် ခြင်း သည် ကျွန်ုပ် ကို စောင့်ရှောက် ပါလိမ့်မည်။ မ ပြောက် မကျားသော ဆိတ် ၊ မညို သောသိုး ရှိသမျှ တို့ကို ၊ ကျွန်ုပ် ခိုး သော အကောင်ဟူ၍မှတ်စေလော့ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","လာဗန် ကလည်း၊ သင် ပြော တိုင်း ဖြစ် လော့ဟု ဝန်ခံ ၍ ၊ ထိုနေ့ ၌ ပင်၊ ပြောက် ကျားသော ဆိတ် ထီး၊ ပြောက် ကျားသောဆိတ် မ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","အဖြူ ပါသော ဆိတ်ရှိသမျှ တို့နှင့် ၊ အဆင်းညို သော သိုးရှိသမျှ တို့ကိုရွေး ၍ ၊ မိမိ သား တို့လက် သို့ အပ် ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ကိုယ် နေရာ အရပ်နှင့် ၊ ယာကုပ် နေရာအရပ်ကို သုံး ရက် ခရီး ကွာ စေခြင်းငှါ စီရင် သေး၏။ ယာကုပ် သည် ကြွင်း သော လာဗန် ၏သိုး ဆိတ်များကို ထိန်း လျက် နေရ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ထိုအခါ ယာကုပ် သည်၊ စိမ်း သောလိဗနာ ပင်၊ လုဇ ပင်၊ အာရမုန် ပင်တို့၏ အခက် တံဖျားများကိုယူ ၍၊ အဖြူ ၊ အစိမ်း၊ အတန့်တန့်ပေါ် အောင်အခွံ ကို လှီး ခွာ ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ရေသောက် လာ သောသိုး ၊ ဆိတ်အထီးအမ ရှက်တင် စေမည်အကြံရှိ၍၊ ရေသောက် လာ သောအခါ ၊ အခွံ ခွာပြီးသော တံဖျား တို့ကို ရေ သောက်ကျင်း၊ သောက် ခွက်တို့၌ သိုး ဆိတ်တို့ ရှေ့ မှာစိုက်ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","သိုး ဆိတ်တို့သည် တံဖျာ များရှေ့ မှာ ရှက်တင် ၍ ၊ အပြောက် အကျား စသည်တို့ကို ဘွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ယာကုပ် သည် သိုး ၊ ဆိတ်သငယ်တို့ကိုလည်း ခွဲ ထား၍ ၊ လာဗန် ၏သိုး စု၊ ဆိတ်စုတွင် အဆင်း ပြောက် ကျားသော အကောင်၊ အဆင်း ညိုသော အကောင်ရှိသမျှ တို့ ရှေ့မှာ သိုး ဆိတ်များကိုမျက်နှာ ပြု စေ၏။ မိမိတိရစ္ဆာန် များနှင့်လာဗန် ၏ တိရစ္ဆာန် များကိုလည်း မ ရော မနှော စေဘဲ၊ တစုစီခွဲထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","အားကြီး သောအကောင်တို့သည် ရှက်တင် သောအခါ ၊ တံဖျာ တို့တွင် ရှက်တင် စေခြင်းငှါ ၊ ယာကုပ် သည် တံဖျာများကို ရေကျင်း၌၊ သူတို့ မျက်မှောက် တွင် ထား တတ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","အားနည်း သောအကောင် တို့ရှေ့ မှာ တံဖျာ တို့ကို မ ပြ မထား။ ထိုကြောင့် အားနည်း သောအကောင်တို့သည် လာဗန် ၏ ဥစ္စာဖြစ်လေ၏။ အားကြီး သော အကောင်တို့မူကား၊ ယာကုပ် ၏ ဥစ္စာဖြစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ထိုသို့ ယာကုပ် ၌ စည်းစိမ်တိုးပွား ၍ ၊ သိုး ၊ ဆိတ်၊ ကျွန် ယောက်ျား၊ ကျွန် မိန်းမ၊ ကုလားအုပ် ၊ မြည်း အများ ရှိ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ထိုအခါ လာဗန် သား တို့က၊ ငါ တို့သခင် ၏ဥစ္စာရှိသမျှ ကို ယာကုပ် သည် ယူ သွားလေပြီတကား၊ ငါ တို့အဘ ၏ဥစ္စာအားဖြင့် ၊ သူ၌ဤ မည်သော စည်းစိမ် ရှိသမျှ သည် ဖြစ် လေပြီဟု၊ ဆို ကြသည်ကို ယာကုပ်ကြား ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","လာဗန် ၏ မျက်နှာ ကို ကြည့် သောအခါ ၊ ရှေ့ က ကဲ့သို့ မဟုတ် ၊ ခြားနားသည်ကို သိ မြင်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ထာဝရဘုရား ကလည်း ၊ သင် ၏ဘိုး ဘနေသောပြည် ၊ သင် ၏အမျိုးသား ချင်းထံ သို့ပြန် သွားလော့။ ငါသည် သင့် ဘက် ၌ရှိ နေမည်ဟု ယာကုပ် အား မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ယာကုပ် သည် လူကိုစေလွှတ် ၍ ၊ ရာခေလ နှင့် လေအာ ကို ၊ သိုး စုရှိရာတော သို့ ခေါ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","သင် တို့အဘ ၏ မျက်နှာ သည် ငါ ၌ ရှေ့ ကကဲ့သို့ မ ဟုတ်၊ ခြားနားသည်ကို ငါ သိ မြင်၏။ သို့သော်လည်း ၊ ငါ့ အဘ ၏ဘုရားသခင် သည်၊ ငါ့ ဘက် ၌ ရှိ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","သင် တို့အဘ ၏အမှုကို၊ ငါ တတ် နိုင်သမျှ အတိုင်း၊ ငါစောင့် သည်ကို သင် တို့သိ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","သင် တို့အဘ သည်လည်း ငါ့ ကိုလှည့်စား ၍ ၊ ငါ ရထိုက်သော အခ ကိုဆယ် ကြိမ် လဲ ခဲ့ပြီ။ သို့သော်လည်း ၊ ငါ့ ကိုညှဉ်းဆဲ စေခြင်းငှါ ၊ ဘုရားသခင် အခွင့် ပေးတော်မ မူ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","သူက၊ ပြောက် သောအကောင်တို့သည်၊ သင် ၏ အခ ဖြစ်စေ ဟုဆို လျှင် ၊ သိုး ၊ ဆိတ်ရှိသမျှ တို့သည် ပြောက် သောအကောင်တို့ကို မွေး ကြ၏။ ကျား သော အကောင်တို့ သည်၊ သင် ၏အခ ဖြစ်စေ ဟုဆို လျှင် ၊ သိုး ၊ ဆိတ် ရှိသမျှ တို့ သည် ကျား သောအကောင်တို့ကို မွေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ထိုသို့ ဘုရားသခင် သည်၊ သင် တို့အဘ ၏ တိရစ္ဆာန် တို့ကို နှုတ် ၍ ငါ့ အား ပေး တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ထိုတိရစ္ဆာန် များတို့သည်၊ ရှက်တင် ကြသောအခါ ၊ ငါ မြော် ကြည့် ၍ ၊ တိရစ္ဆာန်မတို့နှင့် ပေါင်းဘော် သော တိရစ္ဆာန်အထီး ရှိသမျှတို့သည်၊ အပြောက် အကျားမှစ၍ ၊ အထွေထွေသော အဆင်းရှိကြောင်းကို အိပ်မက် ၌ ငါမြင် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ဘုရားသခင် ၏ကောင်းကင် တမန်ကလည်း ၊ ယာကုပ် ဟု အိပ်မက် ၌ ငါ့ ကို ခေါ် လျှင် ၊ ကျွန်ုပ် ရှိ ပါ၏ဟု ငါထူး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","သူ ကလည်း မြော် ၍ကြည့် လော့။ တိရစ္ဆာန် မနှင့် ပေါင်းဘော် သော တိရစ္ဆာန်အထီး ရှိသမျှ တို့သည်၊ အပြောက် အကျားမှစ၍ ၊ အထွေထွေသော အဆင်းရှိကြ ၏။ အကြောင်း မူကား၊ သင် ၌ လာဗန် ပြု သမျှ တို့ကို ငါမြင် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ငါ ကား၊ သင်သည် မှတ် တိုင်ကိုဆီ လောင်း၍၊ ငါ ၌ သစ္စာ ပြုရာ ဗေသလ အရပ်၏ဘုရား ဖြစ်၏။ ယခု ထ ၍ ဤ အရပ်မှ ထွက် သဖြင့်၊ အမျိုးသား ချင်းတို့နေသောပြည် သို့ ပြန် သွားလော့ဟု ငါ့အားမိန့်တော်မူ၏ဟု ယာကုပ်သည် ကြားပြောပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ရာခေလ နှင့် လေအာ တို့က၊ အကျွန်ုပ် တို့သည် ကိုယ်အဘ ၏အိမ် နှင့် အဘယ်သို့ဆိုင်သနည်း။ အဘယ်သို့ အမွေခံ ရသေး သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","သူ သည် ကျွန်ုပ်တို့ကို တကျွန်း တနိုင်ငံသားကဲ့သို့ မှတ် တတ်သည်မ ဟုတ်လော။ ကျွန်ုပ် တို့ကို ရောင်း စား ခဲ့ပြီ တကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ကျွန်ုပ် တို့အဘ မှ ဘုရားသခင် ရုပ်သိမ်း တော်မူသော စည်းစိမ် ရှိသမျှ သည် ငါ တို့ဥစ္စာ၊ ငါ တို့ သားသမီး များ ဥစ္စာဖြစ် ၏။ သို့ဖြစ်၍ ဘုရားသခင် မှာ ထားတော်မူသည် အတိုင်း ယခု တွင် ပြု ပါလော့ဟုပြန်ပြော ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ထိုအခါ ယာကုပ် သည်ထ ၍ ၊ မိမိ သား မယား တို့ကို ကုလားအုပ် ပေါ် မှာ စီး စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","မိမိ တိရစ္ဆာန် တည်းဟူသော၊ ပါဒနာရံ အရပ်၌ ရ သော တိရစ္ဆာန် ရှိသမျှ တို့နှင့်၊ ရ တတ်သမျှ သောဥစ္စာ တို့ကို ဆောင် ယူ၍ ၊ အဘ ဣဇာက် နေရာ ခါနာန် ပြည်သို့ ခရီးသွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","လာဗန် သည် သိုးမွေး ကို ညှပ်ခြင်းငှါ ၊ အခြား တပါးသို့ သွား ခိုက် တွင်၊ ရာခေလ သည်၊ သူ ၏တေရပ် ရုပ်တု တို့ကို ခိုး ယူလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ယာကုပ် သည် မိမိ ပြေး မည်အကြောင်း ကို မ ကြား မပြောဘဲနေ၍ ၊ ရှုရိ လူဖြစ်သော လာဗန် ကို ပရိယာယ် အားဖြင့် နိုင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ထိုသို့ မိမိ ဥစ္စာရှိသမျှ ပါ လျက် ပြေး သွား၍ ၊ မြစ် တစ်ဖက်သို့ အလျင်အမြန်ကူး ပြီးလျှင် ၊ ဂိလဒ် တောင် ကို ရှေ့ရှု ပြုလျက် ခရီး သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ယာကုပ် ပြေး ကြောင်း ကို၊ သုံး ရက်မြောက် သောနေ့ ၌ လာဗန် ကြား သိလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ညီအစ်ကို တို့ကိုခေါ် ၍ ၊ ခုနစ် ရက် ခရီး လိုက် သဖြင့် ၊ ဂိလဒ် တောင် ပေါ် မှာ မှီ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ဘုရားသခင် သည် ရှုရိ လူလာဗန် ဆီသို့ ညဉ့် အချိန်တွင် အိပ်မက် ၌ ကြွ တော်မူ၍ ၊ သင်သည် ယာကုပ် အား ကောင်း မကောင်း ကို မ ပြော နှင့်၊ သတိ ပြုလော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ထိုအခါ ယာကုပ် သည် မိမိ တဲ ကို ဂိလဒ် တောင် ပေါ် မှာ ဆောက် နှင့်ပြီ။ လာဗန် သည် လိုက်၍မှီ သောအခါ ၊ မိမိ ညီအစ်ကို တို့နှင့်တကွ ၊ ထိုတောင် ပေါ် မှာတဲ ကို ဆောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","လာဗန် ကလည်း ၊ သင်သည် အဘယ်သို့ ပြု သနည်း။ စစ်တိုက် ရာ၌ ဘမ်းမိ သောသူတို့ကို သိမ်းသွား သကဲ့သို့ ၊ ငါ့ ကိုလှည့်စား၍၊ ငါ့ သမီး တို့ကို သိမ်း သွား လေပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ငါ့ ကို လှည့်စား ၍ ၊ အဘယ်ကြောင့် တိတ်ဆိတ် စွာ ထွက် ပြေးသနည်း။ ငါသည် ပျော်မွေ့ ခြင်းကိုပြု၍ သီချင်း ဆိုလျက် ၊ ပတ်သာ နှင့် စောင်း တီးလျက်၊ သင့် ကို လွှတ် လိုက်စေခြင်းငှါ ၊ အဘယ်ကြောင့်ငါ့ ကို မ ကြား မပြောဘဲ နေသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ငါ့ သားသမီး တို့ကို ငါ နမ်း စေခြင်းငှါ ၊ အဘယ်ကြောင့် အခွင့် မ ပေးသနည်း။ သင်သည် မိုက် စွာ ပြု လေ ပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ယခုသင့် ကို ငါ ညှဉ်းဆဲ နိုင်၏။ သို့သော်လည်း၊ မနေ့ ညမှာ သင် ၏အဘ ကိုးကွယ်သော ဘုရားသခင် သည် ကြွလာ၍၊ ယာကုပ် အား ကောင်း မကောင်း ကို မ ပြော နှင့်။ သတိပြု လော့ဟု ငါ့ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ယခု မှာ၊ သင် သည် မိဘ အိမ် ကို အလွန် အောက်မေ့ သောကြောင့် ၊ သွား ရသည် ဟုတ်စေတော့။ ငါ ၏ ဘုရား တို့ကို အဘယ်ကြောင့် ခိုးယူ ခဲ့ရသနည်းဟု ယာကုပ် ကို ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ယာကုပ် ကလည်း ၊ သင် သည်ကိုယ်သမီး တို့ကို အနိုင်သိမ်း ယူကောင်းသိမ်းယူလိမ့်မည်ဟု ကျွန်ုပ်စိုးရိမ် သောကြောင့် ထွက်ပြေးရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","သင် ၏ဘုရား တို့ကိုမူကား၊ အကြင်သူ ၌ တွေ့ လျှင်၊ ထိုသူကို သေ စေလော့။ ကျွန်ုပ် တို့ ညီအစ်ကို များ ရှေ့ တွင်၊ သင်၏ဥစ္စာကိုပြညွှန်၍ ယူ ပါလော့ဟု၊ လာဗန် အား ပြန်ပြော ၏။ ရာခေလ ခိုး ကြောင်း ကို ယာကုပ် မ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","လာဗန် သည် ယာကုပ် တဲ ၊ လေအာ တဲ ၊ ကျွန် မနှစ် ယောက်တို့၏ တဲ သို့ ဝင် ၍ ရှာသော်လည်း မ တွေ့ လျှင် ၊ လေအာ တဲ ထဲမှ ထွက် ၍ ၊ ရာခေလ တဲ သို့ ဝင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ရာခေလ သည်၊ ထိုရုပ်တု တို့ကိုယူ ၍ ကုလားအုပ် ကုန်းနှီး တန်ဆာထဲ သို့ သွင်း ထားပြီးလျှင် ၊ ထိုတန်ဆာ ပေါ် မှာ ထိုင် လျက်နေ၏။ လာဗန် သည် တတဲလုံး ကို ရှာဖွေ ၍ မ တွေ့ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ရာခေလက၊ သခင် ရှေ့ မှာ ကျွန်မမ ထ နိုင် သည် ဖြစ်၍၊ စိတ် ရှိတော်မ မူပါနှင့်။ မိန်းမ တို့၌ ဖြစ်မြဲရှိသည် အတိုင်း၊ ကျွန်မ ၌ ဖြစ်ပါသည်ဟု အဘ အား ဆို လေ၏။ ထိုသို့ လာဗန်သည် ရှာဖွေ ၍ ရုပ်တု တို့ကိုမ တွေ့ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ထိုအခါ ယာကုပ် သည် စိတ်ဆိုး ၍ လာဗန် ကို ဆုံးမ သည်ကား၊ ကျွန်ုပ် သည် အဘယ်သို့ ပြစ်မှား ၍၊ အဘယ် အပြစ် ရှိသောကြောင့်၊ ကျွန်ုပ် ကို ဤမျှလောက်ပြင်းထန်စွာ လိုက် ရသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ကျွန်ုပ် ဥစ္စာ ရှိသမျှ ကို ရှာဖွေ သည်ဖြစ်၍၊ သင် ၏ ဥစ္စာ ပရိကံ တစုံ တခုကို တွေ့ မိလျှင်၊ သင် ၏ညီအစ်ကို ၊ ကျွန်ုပ် ညီအစ်ကို တို့ ရှေ့ တွင်၊ ဤ အရပ်၌ထား ပါ။ သူတို့ သည်၊ ငါ တို့နှစ် ယောက်စပ်ကြား မှာ စီရင် ပါစေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ကျွန်ုပ် သည် သင့် ထံ၌ အနှစ် နှစ်ဆယ် ပတ်လုံးနေရာတွင်၊ သင် ၏သိုးမ ၊ ဆိတ်မ တို့သည် ဝမ်း ပိုးမ ပျက်။ ဆိတ် ထီး၊ သိုး ထီးတို့ကို ကျွန်ုပ်မ စား။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","သားရဲ ကိုက်သတ်သော အကောင်ကိုသင့် ထံ သို့ကျွန်ုပ်မ ဆောင် ခဲ့၊ ကိုယ် အရှုံး ခံရ၏။ နေ့ မှာ ခိုး သည် ဖြစ်စေ ၊ ည မှာခိုး သည်ဖြစ်စေ၊ သင်သည် ကျွန်ုပ် တွင် အစားတောင်း လေ့ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","နေ့ အချိန်၌ လည်း နေပူ ကို၎င်း၊ ညဉ့် အချိန်၌ လည်း နှင်းခဲ ကို၎င်း ခံရပြီ။ အအိပ် ပျက်ခြင်းကိုလည်း ခံရပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ထိုသို့ ၊ ကျွန်ုပ် သည် အနှစ် နှစ်ဆယ် ပတ်လုံးသင် ၏အိမ် ၌ နေ၍၊ သင် ၏သားသမီး နှစ် ယောက် အတွက် ကြောင့် ဆယ် လေး နှစ် ၊ သိုး ဆိတ်တို့အတွက် ကြောင့် ခြောက် နှစ် အစေ ခံရပြီ။ သို့ရာတွင် သင်သည်၊ ကျွန်ုပ် အခ ကို ဆယ် ကြိမ် လဲ ပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ယခုလည်း ကျွန်ုပ် အဘ ၏ ဘုရားသခင် ၊ အာဗြဟံ ၏ဘုရားသခင် ၊ ဣဇာက် ၏ကြောက်ရွံ့ ရာ ဘုရား သည် ကျွန်ုပ် ဘက် ၌မ ရှိ လျှင်၊ သင်သည် ကျွန်ုပ် ကို ဧကန် အမှန်လက်ချည်း လွှတ် လိုက်လိမ့်မည်တကား။ အကယ်စင်စစ်ကျွန်ုပ် ဆင်းရဲ ခံရခြင်း၊ ပင်ပန်းစွာ လုပ်ကိုင် ရခြင်းကို ဘုရားသခင် မြင် ၍ ၊ မနေ့ ညမှာ သင့်ကို ဆုံးမ တော်မူပြီဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","လာဗန် ကလည်း ၊ ဤသမီး တို့သည် ငါ့ သမီး ဖြစ်ကြ၏။ ဤသူငယ် တို့သည်၊ ငါ့ သား ဖြစ်ကြ၏။ ဤတိရစ္ဆာန် တို့လည်း၊ ငါ့ တိရစ္ဆာန် ဖြစ်ကြ၏။ မြင် သမျှ သော ဥစ္စာသည် ငါ့ ဥစ္စာဖြစ်၏။ ငါ့ သမီး တို့၌၎င်း၊ သူတို့ ဘွားမြင် သော ငါ့သူငယ် တို့၌၎င်း ၊ အဘယ်သို့ ငါပြု နိုင် သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","သို့ဖြစ်၍ ၊ ယခုသင် နှင့် ငါ စပ်ကြား ၌ သက်သေ ဖြစ်စေ ၍ ၊ ငါ တို့နှစ်ယောက်သည် ပဋိညာဉ် ပြု ကြစို့ဟု ယာကုပ် အား ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ယာကုပ် သည်လည်း ကျောက် ကိုယူ ၍ ၊ မှတ်တိုင် ဘို့ စိုက် ထူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ကျောက် များကို စု ထားကြပါဟု ညီအစ်ကို တို့ အား ဆိုသည်အတိုင်း၊ သူတို့သည် ကျောက်များကိုယူ ၍ ၊ ကျောက် ပုံ ကို တည် လုပ်ပြီးမှ ၊ ထို ကျောက် ပုံအပေါ် ၌ စားသောက် ခြင်းကို ပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ထို ကျောက်ပုံကို လာဗန် သည် ယေဂါသဟာဒုသ ဟူ၍၎င်း၊ ယာကုပ် သည် ဂိလဒ် ဟူ၍၎င်း၊ သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","လာဗန် ကလည်း ၊ ယနေ့ ဤ ကျောက် ပုံသည် ငါ နှင့် သင် ၏စပ်ကြား ၌ သက်သေ ဖြစ်သည်ဟုဆို ၏။ ထိုကြောင့် ဂိလဒ် ဟူ၍သမုတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","မိဇပါ ဟူ၍သမုတ်ကြသေး၏။ အကြောင်း မူကား၊ လာဗန်က၊ ငါတို့သည် တ ယောက်နှင့်တယောက် ခွါ သွားကြသော နောက်၊ ထာဝရဘုရား သည် ငါ နှင့် သင် ၏ စပ်ကြား ၌စောင့် တော်မူစေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","သင်သည် ငါ့ သမီး တို့ကို ညှဉ်းဆဲ သည်ဖြစ်စေ ၊ ငါ့ သမီး တို့မှတပါး အခြားသော မိန်းမ နှင့် စုံဘက် သည် ဖြစ်စေ ၊ ငါ တို့၌ လူ သက်သေမရှိ၊ ဘုရားသခင် သည် ငါ နှင့် သင် ၏ စပ်ကြား ၌သက်သေ မ ရှိ၊ ဘုရားသခင် သည် ငါနှင့်သင်၏စပ်ကြား၌ သက်သေဖြစ်စေတော်မူသတည်း ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","တဖန် လည်း၊ ငါ နှင့် သင် ၏စပ်ကြား ၌ သင်သည် တည်လုပ် ခဲ့ပြီးသော ဤ ကျောက် ပုံနှင့် ဤ မှတ်တိုင် ကို ကြည့် ပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ငါ သည် သင့် ကိုခိုက် ရန်ပြုခြင်းငှါ ၊ ဤ ကျောက် ပုံ၊ ဤမှတ်တိုင်ကို မ ကျော် ရ၊ သင် သည် ငါ့ ကိုခိုက်ရန်ပြု ခြင်းငှါ၊ ဤ ကျောက် ပုံ၊ ဤ မှတ် တိုင်ကို မ ကျော် ရဟု ဤ ကျောက် ပုံနှင့် ဤ မှတ်တိုင် သည် သက်သေဖြစ်စေသတည်း ။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","အာဗြဟံ ၏ ဘုရားသခင် ၊ နာခေါ် ၏ ဘုရားသခင် ၊ သင့်အဘ ၏ဘုရားသခင် သည် ငါ တို့စပ်ကြား ၌ စီရင် တော်မူစေသတည်းဟူ၍၎င်း၊ ယာကုပ် အား ဆို ၏။ ယာကုပ် သည်လည်း၊ မိမိ အဘ ကြောက်ရွံ့ ရာ ဘုရားကို တိုင်တည် ၍ ကျိန်ဆိုခြင်းကို ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ထိုအခါ ယာကုပ် သည် တောင် ပေါ် မှာ ယဇ် ပူဇော်၍၊ ညီအစ်ကို များကို အစာ စား စေခြင်းငှါ ခေါ်ဘိတ် သဖြင့် ၊ သူတို့သည် စားသောက် ၍ ၊ တောင် ပေါ် မှာ ညဉ့် ကို လွန်စေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","နံနက် စောစောလာဗန် ထ ၍ မိမိ သားသမီး များ ကို နမ်း လျက် ကောင်းကြီး ပေးပြီးမှ ၊ မိမိ နေရာ ပြည်သို့ ပြန် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ယာကုပ် သည် ခရီး သွားပြန် ၍ ၊ ဘုရားသခင် ၏ ကောင်းကင် တမန်တို့သည် ကြိုဆို ခြင်းငှါ လာကြသည်ကို၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ယာကုပ် မြင် လျှင် ဘုရားသခင် ၏ တပ် တော်ဖြစ် သည်ဟု ဆို ၍ ၊ ထို အရပ် ကို မဟာနိမ် အမည် ဖြင့် မှည့် လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ထိုအခါ ယာကုပ် သည်၊ အစ်ကို ဧသော နေရာ ဧဒုံ ပြည် တည်းဟူသောစိရ ပြည် သို့ ၊ တမန် တို့ကို မိမိ ရှေ့ မှာ စေလွှတ် ၍ မှာလိုက်သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ကိုယ်တော် ၏ကျွန် ယာကုပ် က၊ ကျွန်တော်သည် လာဗန် ထံ မှာတည်းခို ၍ ၊ ယခု တိုင်အောင် နေ ပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ကျွန်တော် ၌ နွား ၊ မြည်း ၊ သိုး ၊ ဆိတ်၊ ကျွန် ယောက်ျား မိန်းမ များ ရှိ ကြပါ၏။ ကျွန်တော် သည် သခင် ၏ စိတ် တော်နှင့် တွေ့ စေခြင်းငှါ ၊ လျှောက်ကြားလိုက်ပါသည် ဟု၊ ငါ့ သခင် ဧသော ကို လျှောက် ကြဟု မှာ လိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","တမန် တို့လည်း ယာကုပ် ထံ သို့ပြန်လာ ၍ ၊ ကျွန်တော်တို့သည်၊ ကိုယ်တော် ၏အစ်ကို ဧသော ထံ သို့ ရောက် ခဲ့ပါပြီ။ သူ သည်ကိုယ်တော် ကို တွေ့ ခြင်းငှါ ၊ လူ လေး ရာ နှင့် ချီ လာပါသည်ဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ထိုအခါ ယာကုပ် သည်၊ အလွန် ကြောက် ၍ စိတ် ပူပန်လျှင်၊ မိမိ တွင်ပါ သော လူ စု၊ သိုး ဆိတ်စု၊ နွား စု၊ ကုလားအုပ် များတို့ကို နှစ် စု ခွဲ ၍ ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","အကြောင်း မူကား၊ တ စု ကို ဧသော တွေ့၍ လုပ်ကြံ လျှင် ၊ ကြွင်း သော တစု လွတ် လိမ့်မည်ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","တဖန် ယာကုပ် က၊ အကျွန်ုပ် အဘ အာဗြဟံ ၏ ဘုရားသခင် ၊ အကျွန်ုပ် အဘ ဣဇာက် ၏ဘုရားသခင် ၊ ထာဝရဘုရား ကိုယ်တော်က၊ သင် ၏ပြည် သင် ၏ အမျိုးသား ချင်းတို့ ထံ သို့ပြန် လော့။ ငါသည် သင် ၌ ကျေးဇူး ပြုမည် ဟု မိန့် တော်မူပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ကိုယ်တော် ကျွန် ၌ ပြ တော်မူသောကရုဏာ သစ္စာ တော်အငယ်ဆုံးကို မျှ အကျွန်ုပ်မ ခံထိုက်ပါ။ အကျွန်ုပ်သည် အထက်က၊ ဤ ယော်ဒန် မြစ်ကို လက်စွဲတောင်ဝေး နှင့် သာ ကူး ပါ၏။ ယခု မူကား ၊ အပေါင်းအသင်း နှစ် စုဖြစ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","သို့ဖြစ်၍ ၊ အကျွန်ုပ် ကို အစ်ကို ဧသော လက် မှ ကယ်လွှတ် တော်မူမည်အကြောင်း ဆုတောင်းပါ၏။ သူသည် လာ ၍ အကျွန်ုပ် ကို၎င်း ၊ သား မယား တို့ကို၎င်းသတ် မည်ဟု အလွန်စိုးရိမ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ကိုယ်တော်က၊ ငါသည်သင် ၌ အမှတ်ကျေးဇူး ပြု၍ ၊ မ ရေတွက် နိုင်အောင် များပြား သော သမုဒ္ဒရာ သဲ လုံး နှင့်အမျှ သင် ၏အမျိုးအနွယ် ကို ငါဖြစ် စေမည်ဟု မိန့် တော်မူပါပြီဟု တောင်းလျောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ထို အရပ်၌ တညဉ့် ပတ်လုံး နေ ပြီးမှ ၊ မိမိ လက် ရှိ ဥစ္စာ စုထဲက အစ်ကို ဧသော အား လက်ဆောင် ဆက်စရာ ဘို့၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ဆိတ် မနှစ် ရာ၊ ဆိတ် ထီးနှစ် ဆယ်၊ သိုး မနှစ် ရာ၊ သိုး ထီးနှစ် ဆယ်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","နို့စို့သား ငယ်နှင့်တကွ ၊ နို့ညှစ်ကုလားအုပ် မ သုံး ဆယ်၊ နွား မလေး ဆယ်၊ နွား ထီးတ ဆယ်၊ မြည်း မ နှစ် ဆယ်နှင့် မြည်း ကလေးတ ဆယ်တို့ကို ယူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","အသီးအသီးတစု တခြားစီ ခွဲသန့်လျက်၊ ကျွန် တို့ လက် သို့ အပ် ပြီးလျှင် ၊ သင်တို့သည် ငါ့ ရှေ့ မှာကူး သွား၍ ၊ တစု နှင့် တစု ကို ခရီးကွာ စေလော့ဟု၊ ကျွန် တို့အား မှာ ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ရှေ့ဦးစွာ သွားသောသူကိုလည်း၊ ငါ့ အစ်ကို ဧသော သည် သင့် ကိုတွေ့ ၍ ၊ သင် ကား၊ အဘယ်သူ ၏ လူဖြစ်သနည်း၊ အဘယ် အရပ်သို့ သွား သနည်း။ သင့် ရှေ့ မှာရှိသော တရိစ္ဆာန် များကား အဘယ်သူ ၏ ဥစ္စာ ဖြစ်သနည်းဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ကိုယ်တော် ကျွန် ယာကုပ် ၏ဥစ္စာဖြစ်ပါ၏။ သခင် ဧသော အား ဆက်သ လိုက်သော လက်ဆောင် ဖြစ်ပါ၏။ သူ သည်လည်း နောက် မှာ ရှိပါ၏ဟု၊ လျှောက် ရမည်ဟု မှာ ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ထိုနည်းတူ ၊ ဒုတိယ သူ၊ တတိယ သူမှစ၍ ၊ အစုစု တို့နှင့် လိုက် သောသူအပေါင်း ကိုလည်း ၊ သင် တို့သည် ဧသော နှင့် တွေ့ လျှင် ၊ ဤ သို့လျှောက် ရမည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ကိုယ်တော် ကျွန် ယာကုပ် သည်လည်း နောက် မှာ ရှိပါ၏ဟု၊ ကြား လျှောက်ရမည်ဟူ၍ ၎င်း မှာထားလေ၏။ ယာကုပ်က၊ ယခု ငါ့ ရှေ့ တွင် ထွက်သွား သော လက်ဆောင် ဖြင့် ၊ သူ၏စိတ်ကို ငါဖြေ မည်။ နောက်မှ မျက်နှာချင်းဆိုင် တွေ့ သောအခါ၊ ငါ့ ကိုလက်ခံ ကောင်း လက်ခံလိမ့်မည်ဟု အကြံ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ထိုသို့ ယာကုပ် ရှေ့မှာ လက်ဆောင် သည် အရင် ကူး သွား၍ ၊ သူ ကိုယ်တိုင်ထို ညဉ့် ၌ လူ အစုအဝေးနှင့်အတူ အိပ် ၍ နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ညဉ့် မကုန်မှီထ ၍ မယား နှစ် ယောက်၊ ကျွန် မနှစ် ယောက်၊ သား တဆယ် နှင့် တ ယောက်တို့ကို ဆောင်ယူ ၍ ၊ ယဗ္ဗုတ် ချောင်းရေတိမ်ရာအရပ် ကိုကူး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ထိုသို့ သူ တို့ကိုယူ ၍ မိမိ ဥစ္စာရှိသမျှနှင့်တကွချောင်း တစ် ဖက်သို့ ကူး စေပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ယာကုပ် သည် တယောက် တည်းနေရစ် ၍ ၊ လူ တဦးသည် မိုဃ်းလင်း သည်တိုင်အောင် သူ နှင့် လုံး ထွေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ထိုသူသည် မိမိ မ နိုင် မှန်းကို သိ လျှင် ၊ ယာကုပ် ပေါင် ချန် ကို ထိုး ၍ ၊ လုံးထွေး စဉ် တွင်ပေါင် ဆစ် ပြုတ် လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ထိုသူကလည်း၊ ငါ့ ကိုလွှတ် ပါ၊ မိုဃ်းလင်း ဆဲရှိ ပြီ ဟုဆို လျှင် ၊ ယာကုပ်က၊ ကိုယ်တော် သည် အကျွန်ုပ် ကို ကောင်းကြီး မ ပေးလျှင် ၊ မ သွား ရဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ထိုသူ က လည်း ၊ သင် ၏အမည် ကား အဘယ်သို့ နည်းဟုမေး လျှင် ၊ ယာကုပ် ဖြစ်ပါသည်ဟု ပြန်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","နောင် ၌ သင် ၏အမည် ကို ယာကုပ် ဟူ၍မ ခေါ် ရ၊ ဣသရေလ ဟူ၍ခေါ်ရမည်။ အကြောင်း မူကား၊ သင်သည် ဘုရားသခင် နှင့် ၎င်း ၊ လူ နှင့် ၎င်း ၊ မင်းကဲ့သို့ပြိုင် ၍ နိုင် လေပြီဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ယာကုပ် ကလည်း ၊ နာမ တော်ကား အဘယ်သို့နည်း။ အကျွန်ုပ်အား ဘော်ပြ တော်မူပါဟု မေးလျှောက် လျှင် ၊ ငါ့ နာမ ကို အဘယ်ကြောင့် မေး သနည်းဟု ဆို ၍ ၊ ထို အရပ်၌ ကောင်းကြီး ပေးတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ထိုအရပ် ကို ပေညေလ ဟူ၍၊ ယာကုပ် သည် သမုတ် လေ၏။ အကြောင်း မူကား၊ ငါသည် ဘုရားသခင် ကို မျက်နှာချင်းဆိုင် ၍ ဖူးမြင် ရသော်လည်း၊ အသက် ချမ်းသာ ပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ပေနွေလ အရပ်ကို ယာကုပ်လွန် သွားသောအခါ ၊ နေ ထွက် ချိန်ရှိ၍ ၊ သူ သည် ထော့နဲ့ သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ထိုသို့ ယာကုပ် ၏ပေါင်ချန် အကြောကြီးကို ထိုး တော်မူသောကြောင့် ၊ ဣသရေလ အမျိုးသား တို့သည်၊ ပေါင်ချန် ၌ ရှိသောအကြော ကြီးကို ယနေ့ တိုင်အောင် မ စား ရှောင်လေ့ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ထိုအခါ ယာကုပ် သည် မြော် ကြည့် ၍ ၊ အစ်ကိုဧသော သည် လူ လေး ရာ ပါလျက် ချီ လာသည်ကိုမြင် လျှင် ၊ လေအာ ၊ ရာခေလ ၊ ကျွန် မနှစ် ယောက်တို့တွင် သား များ တို့ကို ဝေ ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ကျွန် မနှစ်ယောက်ကိုကား၊ သူ တို့သား များနှင့် ရှေ့ ကနေစေ၍ ၊ လေအာ နှင့် သူ ၏သား တို့ကို အလယ်၌ ၎င်း၊ ရာခေလ နှင့် ယောသပ် ကို နောက် ၌၎င်း ထား လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","သူ တို့ရှေ့ မှာ ကိုယ်တိုင် လွန် သွား၍ ၊ ခုနစ် ကြိမ် တိုင်အောင် ဦးညွှတ် ပြပ်ဝပ်လျက် ၊ အစ်ကို အနီးသို့ ချဉ်းကပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ထိုအခါ ဧသော သည် ကြိုဆိုခြင်း ငှါ ပြေး လာ၍ ၊ လည် ချင်း ရှက် လျက် ၊ ပိုက်ဘက် နမ်းရှုတ် ခြင်းကိုပြု၍၊ နှစ်ယောက်စလုံးတို့သည် ငိုကြွေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ထိုနောက် ၊ မြော် ကြည့် ၍ ၊ မိန်းမ များ၊ သူငယ် များကို မြင် လျှင် ၊ သင် ၌ပါ သောဤ သူတို့သည်၊ အဘယ် သူနည်းဟုမေး သော်၊ ကိုယ်တော် ၏ ကျွန် အား ၊ ဘုရားသခင် ပေး သနားတော်မူသောသူငယ် ဖြစ်ကြပါ၏ဟု ပြန်ပြော ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ကျွန် မတို့သည်၊ မိမိ တို့သား များနှင့် ချဉ်းကပ် ၍ ဦးညွှတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ထိုနောက် ၊ လေအာ သည် သူ ၏သား များနှင့် ချဉ်းကပ် ၍ ဦးညွှတ် ကြ၏။ ထိုနောက် ၊ ယောသပ် နှင့် ရာခေလ သည် ချဉ်းကပ် ၍ ဦးညွှတ် ခြင်းကို ပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ဧသောကလည်း၊ ကျွန်ုပ်တွေ့ သော တိရစ္ဆာန် စု အပေါင်း တို့သည်၊ အဘယ်သို့ သောအရာနည်းဟုမေး လျှင်၊ သခင် ၏စိတ် တော်နှင့် တွေ့ စေခြင်းငှါ ဖြစ်ပါသည် ဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ဧသော ကလည်း၊ ငါ့ ညီ ၊ ငါ ၌ လုံလောက် အောင် ရှိ ၏။ သင် ၏ ဥစ္စာတို့ကို ယူ ထားဦးလော့ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ယာကုပ် ကလည်း ၊ ထိုသို့မဆိုပါနှင့်။ စိတ်တော် နှင့် တွေ့ သည်မှန်လျှင် ၊ ကျွန်တော် ဆက် သော လက်ဆောင် ကို ခံယူ တော်မူပါ။ ဘုရားသခင် ၏ မျက်နှာ တော် ကို ဖူးမြင် ရသကဲ့သို့ ၊ ကိုယ်တော် ၏ မျက်နှာ ကို ဖူးမြင် ရပါ၏။ စိတ် တော်သည်လည်းနူးညွတ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ကိုယ်တော် ထံ သို့ရောက် သော ကျွန်တော် ၏ မင်္ဂလာ ကိုခံယူ တော်မူပါ။ ဘုရားသခင် သည်၊ ကျွန်တော် ၌ များစွာသောကျေးဇူး ကို ပြုတော်မူပြီ။ ကျွန်တော် ၌ လုံလောက် အောင်ရှိ ပါ၏ဟူ၍ တိုက်တွန်း သောကြောင့် ခံယူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ဧသောကလည်း၊ ခရီး သွားကြစို့၊ သင့် ရှေ့ မှာ ကျွန်ုပ်သွား မည်ဟုဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ယာကုပ်က၊ သခင် သိ သည်အတိုင်း၊ ဤသူငယ် တို့သည် နုငယ် ပါ၏။ သား ငယ်ပါသောသိုး ၊ ဆိတ်၊ နွားမ တို့သည် ကျွန်တော် ၌ပါပါ၏။ တနေ့ ခြင်းတွင် အနှင် လွန် လျှင် ၊ ရှိသမျှ တို့သည် သေ ကြပါလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ထိုကြောင့်သခင် သည်၊ ကိုယ်တော် ၏ ကျွန် ရှေ့ မှာကြွ နှင့်တော်မူပါ။ ကျွန်တော်မူကား၊ ကျွန်တော်ဆောင် ခဲ့သော တိရစ္ဆာန်များ၊ သူငယ် များ၊ တတ်နိုင်သမျှအတိုင်း ၊ သခင် နေရာ စိရ ပြည်သို့ ရောက် အောင်၊ တဖြည်းဖြည်း ပို့ဆောင် ပါမည်ဟု လျှောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ဧသော ကလည်း ၊ သို့ဖြစ်လျှင်အကျွန်ုပ် ၌ ပါ သောသူ အချို့တို့ကို ညီ၌ထား ခဲ့ပါရစေဟုဆိုလျှင် ၊ ယာကုပ်က၊ အဘယ် အကြောင်းရှိပါသနည်း။ သခင် ၏ စိတ် တော်နှင့်တွေ့ ပါစေဟု ပြန် ဆိုသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ဧသော သည် ထိုနေ့ ခြင်းတွင် စိရ ပြည်သို့ ခရီး သွား၍ ပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ယာကုပ် လည်း ၊ သုကုတ် အရပ်သို့ ခရီး သွား၍ ၊ ကိုယ် နေဘို့ အိမ် ကို၎င်း ၊ တိရစ္ဆာန် များနေဘို့ တင်းကုပ် တို့ကို၎င်း၊ ဆောက် လေ၏။ ထို့ကြောင့် ထိုအရပ် ကို၊ သုကုတ် ဟူ၍တွင် လေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ထိုနောက်မှ ၊ ရှေခင် မြို့ သို့ ဘေးမဲ့ ရောက် လေ၏။ ပါဒနာရံ ပြည်မှ ပြန်လာ၍၊ ခါနာန် ပြည် သို့ ရောက် သော လမ်းခရီးတွင် ၊ ထိုမြို့ရှိသတည်း။ ထိုမြို့ ရှေ့ မှာတဲ ကို ဆောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","တဲ ဆောက် ရာမြေ အကွက် ကို ရှေခင် ၏အဘ ၊ ဟာမော် ၏သား တို့တွင်၊ ငွေ တပိဿာ အဘိုးပေး၍ ဝယ် ရသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ထို အရပ်၌လည်း ယဇ် ပလ္လင်ကို တည် ပြီးလျှင် ၊ ဧလေလောဣသရေလ ဟူ၍ သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ယာကုပ် ၏မယား၊ လေအာ ဘွားမြင် သောသမီး ဒိန သည်၊ ထိုပြည် ၏ အမျိုးသမီး တို့ကို အကြည့်အရှု သွားရာ တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ထိုပြည် ကို အစိုးရ သောဟိဝိ အမျိုး၊ ဟာမော် မင်း ၏သား ရှေခင် သည် ဒိန ကိုမြင် လျှင် ၊ ယူ သွား၍ အိပ် ဘော်ပြုလျက် ၊ သူ့ အသရေကို ရှုတ်ချ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","နောက်မှသူ့ကိုချစ်သောစိတ် မကုန်၊ အမြဲ ချစ် ၍ ၊ မေတ္တာစကားနှင့်ဖြားယောင်းလျက် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ခမည်း တော်ဟာမော် ထံသို့ လည်း ဝင်၍၊ ဤ မိန်းမ ကို အကျွန်ုပ် ကြင်ဘက် ဖြစ်စေခြင်းငှါ ၊ တောင်း၍ ပေးတော်မူပါဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ယာကုပ် သည် မိမိ သမီး ဒိန ကို၊ ရှေခင်မင်းသားရှုတ်ချ ကြောင်း ကို ကြား သိသော် လည်း၊ မိမိ သား တို့သည် တော အရပ်မှာ တိရစ္ဆာန် တို့နှင့်အတူ ရှိ သည်ဖြစ်၍ ၊ သူတို့ ကို ငံ့လင့်လျက် တိတ်ဆိတ် စွာနေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ထိုနောက် ၊ ရှေခင် အဘ ဟာမော် မင်းသည် ယာကုပ် နှင့် နှုတ်ဆက် ခြင်းငှါ လာ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ယာကုပ် ၏သား တို့လည်း သိတင်း ကြားသောအခါ၊ တော အရပ်မှ ပြန်ရောက် ကြ၏။ ထိုမင်းသားသည် ယာကုပ် ၏သမီး နှင့် အိပ် မိ၍၊ ဣသရေလ အမျိုး၌ မိုက် သောအမှု၊ မ ပြု အပ်သော အရာကို ပြု မိသောကြောင့် ၊ သူတို့သည် စိတ်နာ ၍ အလွန် အမျက်ထွက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ဟာမော် မင်းလည်း သူတို့နှင့်နှုတ်ဆက်လျက်၊ ငါ့ သား ရှေခင် သည်၊ သင် တို့သမီး ကို အလွန် ချစ်အားကြီးပါ၏။ ထိမ်းမြားပေးစား ကြပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","သင် တို့သည် ငါ တို့နှင့်အချင်းချင်း ထိမ်းမြားခြင်း ကို ပြုလျက်၊ သင် တို့သမီး ကို ပေးစား ကြလော့။ ငါ တို့သမီး နှင့် လည်း စုံဘက် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","သင်တို့သည် ငါ တို့နှင့်အတူ နေ ၍ ၊ ဤပြည် ၌ အဆီးအတားမရှိ၊ နေရာ ချလျက် ၊ ဖေါက် ကားရောင်းဝယ် ခြင်းကို ပြု၍ ၊ အပိုင်ယူ ကြလော့ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ရှေခင် ကလည်း ၊ သင် တို့စိတ် နှင့်တွေ့ ကြပါစေ။ တောင်း သမျှ ကို ပေး ပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ကန်တော့ ဥစ္စာဖြစ်စေ ၊ လက်ဆောင် ပဏ္ဏာဖြစ်စေ ၊ နည်းများမဆို၊ တောင်း သည့်အတိုင်း ပေး ပါမည်။ ဤမိန်းမ ကိုသာ ငါ့ အား ထိမ်းမြားပေးစား ကြပါဟု၊ မိန်းမ ၏အဘ နှင့် မောင် တို့အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ယာကုပ် ၏ သား တို့သည်၊ နှမ ဒိန ကို ရှေခင် မင်းသားရှုတ်ချ သောအကြောင်း ကို ဆင်ခြင် ၍ ၊ မင်းသား နှင့်အဘ ဟာမော် ကို ပရိယာယ် ဖြင့် ပြန် ပြောသည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ကျွန်ုပ်တို့ နှမ ကို အရေဖျား လှီးမင်္ဂလာကို မခံ သော သူ အား မ ပေးစား နိုင် ပါ။ ပေးစားလျှင်၊ ကဲ့ရဲ့ ဘွယ် သောအကြောင်းဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","သင် တို့သည် ကျွန်ုပ် တို့ ဘာသာအတိုင်း ပြု ၍ ၊ ယောက်ျား တိုင်း အရေဖျား လှီးမင်္ဂလာကို ခံလျှင် ၊ ကျွန်ုပ်တို့သည် ဝန်ခံ ကြပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","သို့ပြုလျှင် ၊ ကျွန်ုပ် တို့သမီး ကို သင် တို့အား ပေးစား ၍ ၊ သင် တို့၏သမီး နှင့် လည်း စုံဘက် ကြသဖြင့် ၊ သင် တို့နှင့်အတူ နေထိုင် ၍ ၊ တမျိုး တည်းဖြစ် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","သို့မဟုတ် ကျွန်ုပ် တို့စကားကို နား မ ထောင်၊ အရေဖျား လှီးမင်္ဂလာကိုမခံလျှင် ၊ ကျွန်ုပ် တို့ သမီး ကိုယူ ၍ သွား မည်ဟုဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ထို စကား ကို ဟာမော် မင်းနှင့် သား တော်ရှေခင် သည် နှစ်သက် ၍၊၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ထိုမင်းသား သည်၊ ယာကုပ် ၏သမီး ကို ချစ် အားကြီး သောကြောင့် ၎င်း၊ အဘ ၏ အမျိုးသား ချင်းအပေါင်း တို့ထက် အသရေ ရှိသောကြောင့် ၎င်း၊ ချက်ခြင်းဝန်ခံလေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ထိုအခါ ၊ ဟာမော် မင်းနှင့် သား တော် ရှေခင် သည်၊ မိမိ မြို့ တံခါး သို့ သွား ၍ ၊ မြို့ သား တို့နှင့် နှုတ်ဆက်လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","အချင်းတို့၊ ဤ သူ တို့သည် ငါ တို့နှင့် သင့်တင့် ကြပြီ။ ငါတို့ပြည် ၌ နေ ၍ ဖေါက်ကား ရောင်းဝယ်မှုကို ပြုကြပါစေ။ ငါတို့ပြည် သည် သူ တို့နေသာအောင် ကျယ် ပေ၏။ သူ တို့သမီး များနှင့် အိမ်ထောင် ဘက် ပြု ကြ စို့။ ငါ တို့သမီး များကိုလည်း သူ တို့အား ထိမ်းမြား ပေးစားကြစို့။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","သို့ရာတွင်သူ တို့သည် အရေဖျား လှီးမင်္ဂလာ ကိုခံသကဲ့သို့ ၊ ငါ တို့တွင် ယောက်ျား တိုင်း အရေဖျား လှီး မင်္ဂလာကို ခံမှ သာ၊ ထိုလူ တို့သည် ငါ တို့တွင် နေ ၍ တမျိုး တည်း ဖြစ်စေ ခြင်းငှါ ဝန်ခံ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","သူ တို့၏သိုး နွားမှစ၍ တိရစ္ဆာန် များ၊ ဥစ္စာ များတို့ သည် ငါတို့ဥစ္စာ ဖြစ်ကြလိမ့်မည် မဟုတ်လော။ သူတို့ အလိုသို့လိုက်ကြစို့။ သို့ပြုလျှင် သူ တို့သည် ငါ တို့တွင် နေ ကြလိမ့်မည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ဟာမော် မင်းနှင့် သား တော်ရှေခင် ပြောသော စကားကို၊ မြို့ တံခါး မှ ထွက် သောသူအပေါင်း တို့သည် နားထောင် ၍ ယောက်ျား ရှိသမျှ တို့သည် အရေဖျား လှီး မင်္ဂလာကိုခံကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ထိုသို့ခံ ၍ သုံး ရက်မြောက်သောနေ့ ၌ ၊ အလွန် နာကြသောအခါ ၊ ယာကုပ် သား ၊ ဒိန ၏မောင် ရှိမောင် နှင့် လေဝိ ညီနောင်နှစ် ယောက်တို့သည်၊ ထား လက်နက်တယောက်တစင်းစီ စွဲကိုင်လျက်၊ သတိ မရှိသော ထိုမြို့ ကို တိုက် ၍ ၊ ယောက်ျား အပေါင်း တို့ကိုသတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ဟာမော် မင်းနှင့် သား တော်ရှေခင် ကိုလည်း ထား လက်နက် ဖြင့် သတ် ပြီးလျှင်၊ ဒိန ကို ရှေခင် အိမ် မှ နှုတ် ယူ၍ ပြန် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","မိမိ တို့နှမ ရှုတ်ချ ခြင်းကို ခံရသောကြောင့် ၊ တဖန်ယာကုပ် သား တို့သည် အသေ သတ်ပြီးသောသူတို့ ဆီသို့ သွား ပြန်၍၊ မြို့ ကိုလုယက် ဖျက်ဆီးသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","သူ တို့ သိုး ၊ ဆိတ်၊ နွား ၊ မြည်း မှစ၍ ၊ မြို့ ၌ ရှိသမျှ ၊ လယ် ၌ ရှိသမျှ သော ဥစ္စာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","သူ တို့သားမယား သူငယ် အပေါင်း ကို၎င်းသိမ်းယူ ၍ ၊ အိမ် တို့၌ ရှိသမျှ ကိုလည်း လုယက် ဖျက်ဆီးကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ထိုအခါ ယာကုပ် က၊ သင်တို့သည် ငါ့ကို ညှဉ်းဆဲကြပြီတကား။ ခါနနိ လူ၊ ဖေရဇိ လူတည်းဟူသော၊ ဤပြည် သား တို့သည် ငါ့ ကို ရွံရှာ အောင် ပြုကြပြီတကား။ ငါ တို့၌ လူ အရေ အတွက် အားနည်းသောကြောင့်၊ သူတို့သည် စုဝေး ၍ ငါ့ ကိုတိုက် သတ်သဖြင့် ၊ ငါ နှင့် ငါ့ အိမ်သူ အိမ်သားတို့ကို ဖျက်ဆီး ကြလိမ့်မည်ဟု ၊ ရှိမောင် နှင့် လေဝိ တို့အား ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","သူတို့က၊ ငါ တို့နှမ ကို ပြည်တန်ဆာ ကဲ့သို့ မှတ်၍ ပြု ရမည်လောဟု ပြန် ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ထိုနောက် ဘုရားသခင် က၊ သင်ထ ၍ ဗေသလ အရပ်သို့ သွားနေ လော့။ သင် သည် အစ်ကို ဧသော ထံ မှ ပြေး သောအခါ ၊ သင့် အား ထင်ရှား သော ဘုရား သခင်အဘို့ ၊ ထို အရပ်၌ ယဇ် ပလ္လင်ကို တည် လော့ဟု၊ ယာကုပ် အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ထိုအခါ ယာကုပ် သည် အိမ်သူ အိမ်သားများနှင့် ၊ မိမိ ၌ ရှိသောသူ အပေါင်း တို့ကို ခေါ် ၍၊ သင် တို့တွင် ပါ သော၊ တပါး အမျိုးသားတို့၏ ဘုရား တို့ကို ပယ် ပစ် ကြလော့။ အဝတ် ကို လဲ ၍ သန့်ရှင်း ခြင်း ရှိစေကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ယခုထ ၍ ဗေသလ အရပ်သို့သွား ကြစို့။ ငါသည် ဆင်းရဲ ခံရသောကာလ ငါ့ ကိုထူး ၍၊ ငါသွား သော လမ်း ၌ ကြွတော်မူသောဘုရား သခင်အဘို့ ထို အရပ်၌ ယဇ် ပလ္လင်ကို ငါတည် မည်ဟု ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","သူတို့သည်လည်း၊ မိမိ တို့၌ ပါ သောတပါး အမျိုးသားတို့၏ ဘုရား အပေါင်း တို့နှင့်၊ နား ၌ ပန်သော နား ပန်တန်ဆာရှိသမျှတို့ကို၊ ယာကုပ် အား ပေး ၍ ၊ ယာကုပ် လည်း၊ ရှေခင် မြို့နား တွင် ရှိသော သပိတ် ပင် အောက် ၌ မြှုပ် ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","သူတို့ပြောင်း သွား ကြသောအခါ ၊ ပတ်ဝန်းကျင် မြို့ သားတို့သည်၊ ဘုရားသခင် ကို ကြောက်ရွံ့ ၍ ၊ ယာကုပ် သား တို့ကို မ လိုက် ဝံ့ဘဲနေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ယာကုပ် သည် မိမိ ၌ ပါသောသူ အပေါင်း နှင့်တကွ ၊ ခါနာန် ပြည် လုဇ မြို့တည်းဟူသော၊ ဗေသလ အရပ်သို့ ရောက် ကြသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ယဇ် ပလ္လင်ကိုတည် ၍ ၊ ထိုအရပ် ကို ဗေသလ အမည်ဖြင့် တဖန် သမုတ် ပြန်လေ၏။ အကြောင်း မူကား၊ အစ်ကို ထံ မှ ပြေး သောအခါ ၊ ထို အရပ်၌ ဘုရားသခင် ထင်ရှား တော်မူသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ရေဗက္က ၏အထိန်း ဒေဗောရ သေ ၍ ၊ ဗေသလ အရပ်၌ သပိတ် ပင်အောက် တွင် သင်္ဂြိုဟ် ခြင်းကို ခံရလေ ၏။ ထို အပင်ကို အာလုမ္ဘာကုတ် ဟူ၍တွင် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ယာကုပ် သည် ပါဒနာရံ အရပ်မှ ပြန် လာသောနောက် ၊ တဖန်ဘုရားသခင် ထင်ရှား ၍ ကောင်းကြီး ပေး တော်မူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","သင် သည် ယခု ယာကုပ် အမည် ရှိ၏။ နောင်၌ သင် ၏အမည် ကို ယာကုပ် ဟူ၍မ ခေါ် ရ။ ဣသရေလ ဟူ၍ခေါ်ရမည်ဟု မိန့် တော်မူလျက် ဣသရေလ အမည် ဖြင့် သမုတ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","တဖန် ဘုရားသခင် က၊ ငါ သည် အနန္တ တန်ခိုးရှင်ဘုရား သခင်ဖြစ်၏။ တိုးပွါး များပြားလော့။ လူ တမျိုး မက၊ အမျိုးမျိုးတို့သည် သင် ၌ ဖြစ် ကြလိမ့်မည်။ ရှင် ဘုရင်တို့သည် သင် ၏ အမျိုးအနွယ်၌ ဖြစ် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","အာဗြဟံ နှင့် ဣဇာက် အား ငါပေး သော မြေ ကို သင် နှင့် သင် ၏ အမျိုးအနွယ် အား ငါပေး မည်ဟု မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ထိုသို့ ယာကုပ် နှင့် နှုတ်ဆက်၍ မိန့် မြွက်တော်မူရာအရပ် မှ ၊ ဘုရားသခင် တက် ကြွတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ဘုရားသခင်နှုတ်ဆက်၍ မိန့် မြွက်တော်မူရာ အရပ် ၌ ၊ ယာကုပ် သည် ကျောက်တိုင် ကို စိုက် ၍ ၊ ကျောက်ဖျာ ပေါ် ၌ သွန်းလောင်း ရာ ပူဇော် သက္ကာကို၎င်း၊ ဆီ ကို ၎င်း လောင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ဗျာဒိတ် တော်ကို ခံရသောထိုအရပ် ကိုလည်း၊ ဗေသလ ဟူ၍တဖန် သမုတ် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ထိုနောက် တဖန် ဗေသလ အရပ်မှ ခရီး သွားပြန်၍ ၊ ဧဖရတ် မြို့နှင့် နီးသောအခါ၊ ရာခေလ သည် သားဘွား အံ့သောအချိန် ရောက်၍၊ ပြင်းစွာသော ဝေဒနာကို ခံရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ထိုသို့ ပြင်းစွာခံနေရစဉ်တွင်၊ ဝမ်းဆွဲ က၊ မ စိုးရိမ် နှင့်၊ သား ယောက်ျားကို ရပြီဟုဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ရာခေလ သည် သေ အံ့ဆဲဆဲရှိ၍ ၊ နံ ဝိညာဉ် ထွက် စဉ် အခါ၊ ထို သားကို ဗေနောနိ အမည် ဖြင့် မှည့် လေ ၏။ အဘ မူကား ဗင်္ယာမိန် အမည် ဖြင့် မှည့်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ရာခေလ သေ ၍ ၊ ဗက်လင် အမည်ရှိသောဧဖရတ် မြို့သို့ သွား သော လမ်းခရီးတွင်၊ သင်္ဂြိုဟ် ခြင်းကိုခံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ယာကုပ် လည်း သင်္ချိုင်း အပေါ် မှာ မှတ်တိုင် ကို စိုက် လေ၏။ ထို မှတ်တိုင် ကား၊ ယနေ့ တိုင်အောင် ရာခေလ ၏ သင်္ချိုင်း မှတ်တိုင်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ဣသရေလ သည် တဖန် ခရီး သွားပြန်၍ ၊ ဧဒါလင့်စင် ကို လွန် ပြီးမှတဲ ကိုဆောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ထိုအရပ် ၌ နေ သောအခါ ၊ ရုဗင် သည်သွား ၍ အဘ ၏မယားငယ် ၊ ဗိလဟာ နှင့် အိပ် လေ၏။ ထို သတင်း ကို ဣသရေလ ကြား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ယာကုပ် သား တကျိပ် နှစ် ပါးရှိ ၏။ လေအာ တွင် မြင်သော သား ကား၊ ယာကုပ် ၏သားဦး ရုဗင် ၊ အစရှိ သော ရှိမောင် ၊ လေဝိ ၊ ယုဒ ၊ ဣသခါ ၊ ဇာဗုလုန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ရာခေလ သား ကား၊ ယောသပ် နှင့် ဗင်္ယာမိန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ရာခေလ ၏ ကျွန်မ ဗိလဟာ သား ကား၊ ဒန် နှင့် နဿလိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","လေအာ ၏ ကျွန်မ ဇိလပ သား ကား၊ ဂဒ် နှင့် အာရှာ တည်း။ ဤ သူတို့ကား၊ ပါဒနာရံ ပြည်၌ ဘွားမြင် သော ယာကုပ် ၏သား များတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ထိုနောက် ယာကုပ် သည် အာဗြဟံ နှင့် ဣဇာက် တည်းခို ရာ၊ မံရေ အရပ်၊ ဟေဗြုန် မြို့တည်းဟူသော ကိရယသာဘ မြို့၌နေ သော၊ အဘ ဣဇာက် ထံ သို့ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ဣဇာက် အသက် သည် အနှစ် တရာ ရှစ်ဆယ် နှင့် ပြည့်စုံ သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","အသက် ကြီးရင့်ရာ၊ ကာလ ပြည့်စုံ ရာ၌ အသက်ချုပ် ၍ အနိစ္စ ဖြစ်သဖြင့် ၊ မိမိ လူမျိုး စည်းဝေး ရာသို့ ရောက် လေ၏။ သား ဧသော နှင့် ယာကုပ် တို့သည် သင်္ဂြိုဟ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ဧဒုံ အမည်ရှိ သောဧသော အမျိုးအနွယ်၏ အတ္ထုပ္ပတ္တိ များဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","2ဧသော သည် ဟိတ္တိ အမျိုးဧလုန် ၏သမီး အာဒ တယောက်၊ ဟိဝိ အမျိုးဇိဘောင် သား အာန ၏ သမီး အဟောလိဗာမ တယောက်၊ ခါနာန် အမျိုးသမီး နှစ်ယောက်နှင့်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","3ဣရှမေလ သမီး တည်းဟူသောနဗာယုတ် နှမ ဗာရှမတ် တယောက်နှင့် ၎င်း အိမ် ထောင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ဧသော မယား အာဒ ဘွား သော သားကား၊ ဧလိဖတ် ၊ ဗာရှမတ် ဘွား သောသားရွေလ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","အဟောလိဗာမ ဘွား သော သားကား၊ ယုရှ ၊ ယာလံ ၊ ကောရ တည်း။ ဤ သူတို့ကား၊ ခါနာန် ပြည် ၌ ဧသော မြင် သောသားတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ဧသော သည် မယား သား သမီး နှင့်တကွ ၊ အိမ်သူ အိမ်သားအပေါင်း တို့ကို၎င်း၊ သိုး နွား စသည်တို့နှင့် တိရစ္ဆာန် ရှိသမျှ တို့ကို၎င်း၊ ခါနာန် ပြည် ၌ ရ တတ်သော ဥစ္စာ ရှိသမျှ တို့ကို၎င်းယူ ၍ ၊ ညီ ယာကုပ် ထံ မှ ပြောင်းသွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","အကြောင်း မူကား၊ ထို သူနှစ်ပါးတို့သည် ဥစ္စာ များ လွန်းသောကြောင့်တရပ် တည်းမ နေ နိုင်ကြ။ သူ တို့ နေရာမြေ သည်၊ သူ တို့တိရစ္ဆာန် များကြောင့် မဆံ့ နိုင်ရာ။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","သို့ဖြစ်၍ ဧဒုံ အမည်ရှိသောဧသော သည် စိရ တောင် ပေါ်မှာ နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","စိရ တောင် ပေါ်မှာ ဧဒုံ အမျိုးသားတို့၏ အဘ ဧသော ၏ သားစဉ် မြေးဆက်တို့ကို ဆိုပေအံ့။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ဧသော ၏ သား တို့အမည် ကား၊ မယား အာဒ ဘွားသောသား ဧလိဖတ် ၊ မယား ဗာရှမတ် ဘွားသော သား ရွေလ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ဧလိဖတ် သား ကား၊ တေမန် ၊ ဩမရ ၊ ဇေဖေါ ၊ ဂါတံ ၊ ကေနတ် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ဧသော သား ဧလိဖတ် ၏ မယားငယ် ၊ တိမန ဘွား သောသားကား၊ အာမလက် တည်း။ ဤ သူတို့သည် ဧသော မယား အာဒ ၏အနွှယ် ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ရွေလ သား ကား၊ နာဟတ် ၊ ဇေရ ၊ ရှမ္မ ၊ မိဇ္ဇ တည်း။ ဤ သူတို့သည် ဧသော မယား ဗာရှမတ် ၏အနွှယ် ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ဇိဘောင် သား အာန ၏သမီး ၊ ဧသော မယား အဟောလိဗာမ ဘွား သောသား ကား၊ ယုရှ ၊ ယာလံ ၊ ကောရ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ဧသော သား တို့တွင် ဗိုလ် လုပ်သောသူဟူမူကား ၊ သားဦး ဧလိဖတ် ၏သား ဗိုလ် တေမန် ၊ ဗိုလ် ဩမရ ၊ ဗိုလ် ဇေဖေါ ၊ ဗိုလ် ကေနတ်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ဗိုလ် ဂါတံ ၊ ဗိုလ် အာမလက် တည်း။ ဤ ဗိုလ် တို့ သည် အာဒ ၏အနွှယ် ၊ ဧဒုံ ပြည် ၌ ဧလိဖတ် ရသောသားဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ဧသော သား ရွေလ ၏ သား ကား၊ ဗိုလ် နာဟတ် ၊ ဗိုလ် ဇေရ ၊ ဗိုလ် ရှမ္မ ၊ ဗိုလ် မိဇ္ဇ တည်း။ ဤ ဗိုလ် တို့သည် ဧသော မယား ဗာရှမတ် ၏အနွှယ် ၊ ဧဒုံ ပြည် ၌ ရွေလ ရသောသားဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ဧသော မယား အဟောလိဗာမ ၏ သား ကား၊ ဗိုလ် ယုရှ ၊ ဗိုလ် ယာလံ ၊ ဗိုလ် ကောရ တည်း။ ဤ ဗိုလ် တို့သည် အာန ၏သမီး ၊ ဧသော မယား အဟောလိဗာမ သား ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ဧဒုံ အမည်ရှိသောဧသော ၏ သား မြေးများ၊ သူ တို့တွင် ဗိုလ် လုပ်သောသူများ၊ ဤ သို့တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ထိုပြည် ၌နေ သောဟောရိ အမျိုး၊ စိရ ၏သား ကား၊ လောတန် ၊ ရှောဗလ ၊ ဇိဘောင် ၊ အာန၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ဒိရှုန် ၊ ဧဇာ ၊ ဒိရှန် တည်း။ ဤ သူတို့သည် ဧဒုံ ပြည် ၌ ဟောရိ အမျိုး၊ စိရ ၏သား တို့တွင် ဗိုလ် လုပ်သောသူဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","လောတန် သား ကား၊ ဟောရိ နှင့် ဟေမံ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ရှောဗလ သား ကား၊ အာလဝန် ၊ မနာဟတ် ၊ ဧဗလ ၊ ရှေဖေါ ၊ ဩနံ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ဇိဘောင် သား ကား၊ အာယ နှင့် အာန တည်း။ ထို အာန ကား ၊ အဘ ဇိဘောင် ၏ မြည်း တို့ကို ထိန်း သောအခါ ၊ တော ၌ နွေး သော စမ်းရေတွင်းတို့ကို တွေ့ သောသူ ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","အာန သား ကား၊ ဒိရှုန် နှင့် သမီး အဟောလိဗာမ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ဒိရှုန် သား ကား၊ ဟင်္ဒန် ၊ ဧရှဗန် ၊ ဣသရန် ၊ ခေရန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ဧဇာ သား ကား၊ ဗိလဟန် ၊ ဇာဝန် ၊ အာကန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ဒိရှန် သား ကား၊ ဥဇ နှင့် အာရန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ဟောရိ အမျိုးဗိုလ် များကား ၊ ဗိုလ် လောတန် ၊ ဗိုလ် ရှောဗလ ၊ ဗိုလ် ဇိဘောင် ၊ ဗိုလ် အာန၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ဗိုလ် ဒိရှုန် ၊ ဗိုလ် ဧဇာ ၊ ဗိုလ် ဒိရှန် တည်း။ ဤ သူတို့ သည် စိရ ပြည် ၌ ဗိုလ် လုပ်သောသူ တို့ တွင်၊ ဟောရိ အမျိုး ဗိုလ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ဣသရေလ အမျိုး ၌ အစိုး ရသောမင်း ကြီး မ ရှိမှီ၊ ဧဒုံ ပြည် ၌ အစိုး ရသောမင်းကြီး ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ဗောရ သား ဗေလာ သည် ဧဒုံ ပြည်၌ မင်း ပြု၏။ မြို့ တော်ကား၊ ဒိန္နာဗာ မြို့တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ဗေလာ မင်းသေ ၍ သူ ၏အရာ ၌ ဗောဇရ အရပ် သား၊ ဇေရ ၏သား ယောဗပ် သည် မင်း ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ယောဗပ် မင်းသေ ၍ ၊ သူ ၏အရာ ၌ တေမနိ အရပ် သား ဟုရှံ သည် မင်း ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ဟုရှံ မင်းသေ ၍ ၊ မောဘ လွင်ပြင် ၌ မိဒျန် လူတို့ ကို လုပ်ကြံ သောသူ၊ ဗေဒဒ် သား ဟာဒဒ် သည်၊ ဟုရှံ အရာ ၌ မင်း ပြုလေ၏။ မြို့ တော်ကား၊ အာဝိတ် မြို့တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ဟာဒဒ် မင်းသေ ၍ ၊ သူ ၏အရာ ၌ မာသရက် အရပ်သားစာမလ သည် မင်း ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","စာမလ မင်းသေ ၍ ၊ သူ ၏အရာ ၌ မြစ် နားမှာ နေသောရဟောဘုတ် အရပ်သားရှောလ သည် မင်း ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ရှောလ မင်းသေ ၍ သူ ၏အရာ ၌၊ အာခဗော် သား ဗာလဟာနန် သည် မင်း ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","အာခဗော် သား ဗာလဟာနန် မင်းသေ ၍ သူ ၏ အရာ ၌ဟာဒါ သည် မင်း ပြုလေ၏။ မြို့ တော်ကား၊ ပေါ မြို့ တည်း။ မျောက်သားတော်ကား၊ မေဇဟပ် သမီး မာတရက် ၏သမီး မဟေတဗေလ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ဧသော မှ ဆင်းသက်၍ မိမိ အမျိုး အနွယ်၊ နေရာ အရပ်၊ ခံရသောဘွဲ့ နာမအလိုက် ၊ ဗိုလ် လုပ်သောသူ ဟူမူကား ၊ ဗိုလ် တိမနာ ၊ ဗိုလ် အာလဝ ၊ ဗိုလ် ယေသက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ဗိုလ် အဟောလိဗာမ ၊ ဗိုလ် ဧလာ ၊ ဗိုလ် ပိနုန်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ဗိုလ် ကေနတ် ၊ ဗိုလ် တေမန် ၊ ဗိုလ် မိဗဇာ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ဗိုလ် မာဂဒျေလ ၊ ဗိုလ် ဣရံ တည်း။ ဤ သူတို့သည် မိမိ နေရာ အရပ်၊ မိမိ ပိုင် သော ပြည် ၌ ၊ ဧဒုံ ဗိုလ် များ ဖြစ်သတည်း။ ဧသော သည် ဧဒုံ အမျိုးသားတို့၏ အဘ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ယာကုပ် သည် မိမိ အဘ တည်းခို ရာခါနာန် ပြည် ၌ နေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ယာကုပ် အမျိုးအနွယ်၏ အတ္ထုပ္ပတ္တိ များ ဟူမူကား ၊ ယောသပ် သည် အသက် တဆယ် ခုနစ် နှစ်ရှိ ၍၊ အစ်ကို တို့နှင့်အတူ သိုး ဆိတ်များကို ထိန်း လေ၏။ အဘ ၏မယား ဗိလဟာ နှင့် ဇိလပ ၏သား တို့နှင့်အတူ နေ၍၊ သူ တို့အပြစ် ကို အဘ အား ကြား ပြောတတ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ဣသရေလ သည် အသက် ကြီးစဉ်အခါသား ယောသပ်ကို ရသောကြောင့် ၊ အခြားသော သား အပေါင်း တို့ကို ချစ် သည်ထက် ယောသပ် ကို သာ၍ချစ်၏။ အဆင်း အရောင်ထူးခြားသော အင်္ကျီ ကို ချုပ် ၍ ပေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","အဘ သည် မိမိသားအပေါင်းတို့တွင်၊ ယောသပ် ကိုသာ၍ ချစ် ကြောင်းကို၊ အစ်ကို တို့သည် သိမြင် သောအခါ ၊ သူ့ ကိုမုန်း ၍ မေတ္တာ စကားကို သူ့ အား မ ပြော နိုင်ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ယောသပ် သည် အိပ်မက် ကို မြင် ၍ ၊ အစ်ကို တို့ အား ပြန်ပြော သဖြင့် ၊ သူတို့သည် သာ၍ မုန်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","အိပ်မက်ကို အဘယ်သို့ပြန်ပြောသနည်းဟူမူကား၊ ကျွန်ုပ်မြင် ရသောအိပ်မက် ကို နားထောင် ကြပါ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ကျွန်ုပ် တို့သည် လယ် ၌ ကောက်လှိုင်း ကို စည်း ၍ နေကြစဉ်တွင်၊ ကျွန်ုပ် ကောက်လှိုင်း သည် ထ ၍ မတ်တတ်နေသဖြင့်၊ သင် တို့၏ ကောက်လှိုင်း တို့သည် ဝိုင်း ၍ ရပ် လျက် ၊ ကျွန်ုပ် ကောက်လှိုင်း ကို ရှိခိုး ကြသည်ဟု ပြောဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","အစ်ကို တို့ကလည်း၊ သင်သည် ငါ တို့၌ မင်း ပြု ရလိမ့်မည်လော၊ ငါ တို့ကို အစိုး ရလိမ့်မည်လောဟု ပြန် ဆို ၍ ၊ သူ ၏အိပ်မက် နှင့် သူ ၏စကား အကြောင်း ကြောင့် သာ၍ မုန်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","တဖန် အိပ်မက် ကိုမြင် ပြန်၍ အစ်ကို တို့အား ၊ အခြားသော အိပ်မက် ကို ကျွန်ုပ်မြင် ရပြီ။ နေ ၊ လ နှင့်တကွ ၊ ကြယ် ဆယ့် တလုံး တို့သည်၊ ကျွန်ုပ် ကို ရှိခိုး ကြ၏ဟု ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ထိုသို့အဘ နှင့် အစ်ကို တို့အား ကြားပြော သောအခါ ၊ အဘ က ၊ သင်မြင် သောအိပ်မက် သည် အဘယ်သို့ နည်း။ ငါ နှင့် သင် ၏အမိ ၊ သင် ၏ အစ်ကို တို့သည် သင့် ထံ သို့ စင်စစ် လာ ၍ ဦးညွှတ် ချရမည်လောဟူ၍၊ သူ့ ကို ဆုံးမ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","အစ်ကို တို့သည် သူ့ ကို ငြူစူ ကြ၏။ အဘ သည် ထိုအရာ ကို မှတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","အစ်ကို တို့သည် အဘ ၏သိုး ဆိတ်များကို ရှေခင် မြို့မှာ ထိန်း ခြင်းငှါ သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ဣသရေလ သည် ယောသပ် ကို ခေါ် ၍ ၊ သင် ၏ အစ်ကို တို့သည် သိုးဆိတ်များကို ရှေခင် မြို့မှာ ထိန်း ကြသည်မ ဟုတ်လော။ လာ ပါ။ သင့် ကို သူ တို့ရှိရာသို့ ငါ စေလွှတ် မည်ဟုခေါ်လျှင်၊ ကျွန်ုပ် ရှိ ပါသည်ဟုဆို သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","အဘ က သွား ပါ၊ အစ်ကို တို့သည် ချမ်းသာ သလော၊ သိုး ဆိတ်တို့လည်း ကောင်းမွန် စွာရှိသလောဟူ၍ကြည့်ရှု ပြီးလျှင် ၊ ငါ့ အားသိတင်း ကြားပြော ပါဟု မှာ လိုက်လျက်၊ ဟေဗြုန် ချိုင့် မှ စေလွှတ် သဖြင့် ၊ သူသည် ရှေခင် မြို့သို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","တော ၌ လှည့်လည် စဉ်တွင်၊ တစုံတယောက် သောသူနှင့် တွေ့ ၍ ထိုသူ က၊ သင်သည် ဘာ ကိုရှာ သနည်း ဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","အစ်ကို များကို ရှာ ၏။ အဘယ် မှာထိန်း ကြသည် ကို ပြော ပါဟုဆိုသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ထိုသူ က၊ ဤ အရပ်မှ ထွက် သွားပြီ။ ဒေါသန် မြို့သို့ သွား ကြစို့ဟု သူတို့ပြော သံကို ကျွန်ုပ်ကြား ခဲ့ပြီဟုဆို ၏။ ယောသပ် သည်လည်း ၊ အစ်ကို တို့ကို လိုက် ရှာ၍ ဒေါသန် မြို့မှာ တွေ့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","အနီးသို့မ ရောက် မှီ အဝေး ၌ ရှိစဉ်ပင်၊ အစ်ကိုတို့ သည်မြင် လျှင် ၊ သတ် ခြင်းငှါ တိုင်ပင် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ကြည့် လော့။ အိပ်မက် ဆရာ လာ ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ကိုင်ကြ။ သူ့ ကိုသတ် ၍ တစုံတခု သောတွင်း ထဲ သို့ ချ ပစ်ကြစို့။ ဆိုး သောသားရဲ တစုံတခုကိုက်စား ပြီဟု ပြော ကြစို့။ ထိုသို့ပြုလျှင်၊ သူ ၏ အိပ်မက် တို့သည် အဘယ်သို့ နေရာ ကျမည်ကို ကြည့် ကြစို့ဟု အချင်းချင်းပြောဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ထိုစကားကို ရုဗင် ကြား လျှင် ၊ သူ့ကို မ သတ် ဘဲ နေကြစို့ဟုဆို လျက် ၊ သူ တို့လက် မှ ယောသပ် ကို နှုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","တဖန် ရုဗင် က၊ သူ ၏အသွေး ကို မ သွန်း ကြနှင့်။ ကိုယ်လက် နှင့် မ ပြု ဘဲ၊ တော ၌ ဤ မည်သောတွင်း ထဲ သို့ ချ ကြစို့ဟု သူ တို့လက် မှ ယောသပ် ကို နှုတ် ယူ၍၊ အဘ ၌ တဖန် အပ် မည်အကြံရှိသည်နှင့်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ယောသပ် သည် အစ်ကို တို့ထံ သို့ရောက် သောအခါ ၊ သူ ဝတ်သောအင်္ကျီ ၊ အဆင်း ထူးခြားသောအင်္ကျီ ကို ချွတ် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","သူ့ ကိုကိုင် ယူ၍ တွင်း ထဲ သို့ ချ ကြ၏။ ထိုတွင်း ၌ ရေ မရှိ၊ သွေ့ခြောက် သောတွင်း ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ထိုနောက် အစာ စား ခြင်းငှါ ထိုင် ကြစဉ် မြော် ကြည့် ၍ ၊ ဣရှမေလ အမျိုးသားအစုအဝေးသည် ဂိလဒ် ပြည်မှ လာ ၍ နံ့သာ မျိုး၊ ဗာလစံစေး ၊ မုရန်စေး များ ကို ကုလားအုပ် ပေါ်၌ တင် ဆောင်လျက်၊ အဲဂုတ္တု ပြည်သို့ ခရီးသွား ကြသည်ကို မြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ယုဒ က၊ ငါတို့သည် ညီ ကိုသတ် ၍ သေ ကြောင်းကို ဖွက် ထားလျှင် အဘယ် ကျေးဇူး ရှိသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ကိုင်ကြ။ ကိုယ်တိုင် မ ညှဉ်းဆဲဘဲ၊ ဣရှမေလ လူတို့အား ရောင်း လိုက်ကြစို့။ သူသည် တို့ ညီ ၊ တို့ အမျိုး ဖြစ်၏ဟု အစ်ကိုတို့အားဆိုသည်ရှိသော်၊ ညီအစ် ကိုတို့ သည် ဝန်ခံ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ထိုအခါ၊ မိဒျန် အမျိုးသား ကုန်သည် တို့သည် ခရီးသွား ကြစဉ်တွင် ၊ အစ်ကိုတို့သည် ယောသပ် ကို တွင်း ထဲက ဆွဲ တင် ပြီးလျင် ၊ ငွေ အကျပ်နှစ်ဆယ် အဘိုး နှင့် ဣရှမေလ လူတို့အား ရောင်း ၍၊ ထိုသူတို့သည် ယောသပ် ကိုအဲဂုတ္တု ပြည်သို့ ဆောင်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ရုဗင် သည်လည်း တွင်း သို့ သွား ၍ ၊ တွင်း ထဲမှာ ယောသပ် မ ရှိသည်ကို မြင် လျင်၊ မိမိ အဝတ် ကို ဆွဲဆုတ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ညီ တို့ရှိရာသို့ သွား ၍ ၊ သူငယ် မ ရှိပါတကား။ ငါ သည် အဘယ်သို့ သွား ရပါ မည်နည်းဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","သူတို့သည်လည်း၊ ယောသပ် အင်္ကျီ ကိုယူ ၍ ၊ ဆိတ် သငယ် ကိုသတ် ပြီးမှ ၊ အင်္ကျီ ကိုအသွေး ၌ နှစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ထိုနောက်မှ ၊ အဆင်း ထူးခြားသော ထိုအင်္ကျီ ကို ပေး လိုက်၍၊ အချို့တို့သည် အဘ ထံ သို့ဆောင် ခဲ့လျက် ၊ ဤ အင်္ကျီကို အကျွန်ုပ်တို့ တွေ့ ပါပြီ။ သား ၏အင်္ကျီ ဟုတ် သည် မဟုတ်သည်ကို ကြည့် ပါဟုဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ထို အင်္ကျီကို အဘမှတ်မိ ၍ ၊ ငါ့ သား ၏ အင်္ကျီ မှန်၏။ သူ့ ကိုဆိုး သော သားရဲ ကိုက်စား ပြီ။ အကယ်၍ယောသပ် ကိုအပိုင်းပိုင်းကိုက်ဖြတ် ပါပြီတကားဟုဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","မိမိ အဝတ် ကို ဆွဲဆုတ် ၍ ၊ လျှော်တေ အဝတ်ကို ပတ်စည်း သဖြင့် ၊ အင်တန် ကာလပတ်လုံး၊ သား ကြောင့် စိတ် မသာ ညည်းတွားလျက် နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","သား သမီး အပေါင်း တို့သည်၊ အဘ ကို နှစ်သိမ့် စေခြင်းငှါ ကြိုးစားသော်လည်း ၊ သူသည် နှစ်သိမ့် စေသော စကားကို နား မထောင်ဘဲ၊ ငါ့ သား ရှိ ရာ မရဏာ နိုင်ငံသို့ စိတ် မသာညည်းတွားလျက် ဆင်းသက် တော့မည်ဟု ဆို လေ၏။ ထိုသို့ယောသပ်အဘသည် သား ကြောင့် ငိုကြွေး မြည်တမ်းလျက် နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ယောသပ် ကိုကား၊ မိဒျန် လူတို့သည် အဲဂုတ္တု ပြည် သို့ ဆောင်သွား၍၊ ဖါရော ဘုရင်၏ အမတ် ဖြစ်သော ကိုယ်ရံတော် မှူး၊ ပေါတိဖါ ထံ မှာ ရောင်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ထို ကာလအခါ ယုဒ သည် ညီအစ်ကို နေရာမှ သွား ၍ ၊ ဟိရ အမည် ရှိသော၊ အဒုလံ အမျိုးသား ထံ သို့ဝင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ထို အရပ်၌ ရှုအာ အမည် ရှိသော၊ ခါနာန် အမျိုးသား ၏သမီး ကို တွေ့ မြင်၍ ၊ အိမ်ထောင် ဘက် ပြုလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ထိုမိန်းမသည် ပဋိသန္ဓေ ယူ၍ သား ကို ဘွားမြင် ၏။ ထို သားကို ဧရ အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","တဖန် ပဋိသန္ဓေ ယူပြန်၍ ဘွားမြင် သောသား ကို ဩနန် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","တဖန် ပဋိသန္ဓေယူပြန်၍ ဘွားမြင် သောသား ကို ရှေလ အမည် ဖြင့် မှည့် လေ၏။ ရှေလဘွားသောအခါ၊ အဘသည် ခေဇိပ် မြို့မှာ ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ထိုနောက်မှ ယုဒ သည် မိမိ သားဦး ဧရ ကို တာမာ အမည် ရှိသောသတို့သမီး နှင့် စုံဘက် စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ယုဒ ၏သားဦး ဧရ သည် ထာဝရဘုရား ရှေ့ ၌ ဆိုး သောသူဖြစ် ၍ ၊ သူ့ ကိုထာဝရဘုရား ကွပ်မျက် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ထိုအခါ ယုဒ သည် ဩနန် ကို ခေါ်ပြီးလျှင်၊ သင် ၏အစ်ကို မယား ထံသို့ ဝင် ၍ သူ နှင့် အိမ်ထောင် ဘက် ပြုသဖြင့်၊ အစ်ကို အမျိုး ကို ဆက်နွှယ် လော့ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ဩနန် သည် သားကိုရလျှင်မူကား၊ မိမိ သား မမှတ်ရဟုသိ၍ အစ်ကိုအား သားကိုမ ပေး လိုဘဲ၊ အစ်ကို မယား ထံ သို့ဝင် သောအခါ ၊ သုတ်ရည်ကိုထုတ်၍ စွန့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ထိုအမှုကို ထာဝရဘုရား နှစ်သက်တော်မမူ သောကြောင့်၊ ဩနန် ကိုလည်း ကွပ်မျက် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","သားငယ်ရှေလသည် အစ်ကို တို့သေသကဲ့သို့ သေ မည်ဟုယုဒ သည် စိုးရိမ် ၍ ၊ မိမိ ချွေးမ တာမာ ကို ခေါ်ပြီးလျင်၊ ငါ့ သား ရှေလ မ ကြီး မှီ သင်သည် သင့် အဘ အိမ် ၌ မုတ်ဆိုးမ ပြု၍ နေ ပါဟုဆိုသည်အတိုင်း၊ တာမာ သွား ၍ မိမိ အဘ ၏အိမ် ၌နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ကာလ အတန်ကြာ သော် ၊ ရှုအာ သမီး ဖြစ်သော ယုဒ မယား လည်း သေ လေ၏။ ယုဒ သည်နှစ်သိမ့် ပြီးမှ ၊ မိမိ သိုးမွေး ညှပ်သောသူတို့ရှိ ရာ တိမနတ် မြို့သို့ မိမိ အဆွေ အဒုလံ အမျိုး ဟိရ နှင့်အတူ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","မိမိ ယောက္ခမ သည် သိုးမွေး ကိုညှပ် ခြင်းငှါ ၊ တိမနတ် မြို့သို့ သွား ကြောင်းကို၊ တာမာ ကြား လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","မုတ်ဆိုးမ အဝတ် ကို ချွတ် ၍ မျက်နှာဖုံး နှင့် မျက်နှာ ကိုဖုံး လျက် ၊ ကိုယ်ကိုလည်းခြုံရုံလျက်၊ တိမနတ် မြို့ သို့ သွားသောလမ်း အနား ၊ ဧနိမ် မြို့တံခါး ဝ၌ ထိုင် နေလေ ၏။ အကြောင်း မူကား၊ ရှေလ ကြီးသော်လည်း ၊ မိမိ နှင့် အိမ်ထောင် ဘက်မ ပြု ရဟု သိမြင် သောကြောင့် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ယုဒ သည် ထိုမိန်းမ ကိုမြင် သောအခါ ၊ သူသည် မိမိ မျက်နှာ ကိုဖုံး ၍ နေသောကြောင့် ၊ ပြည်တန်ဆာ ဖြစ်သည်ဟု ထင်မှတ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","လမ်း ကိုလွှဲ ၍ အနားသို့ ချဉ်းပြီးလျှင် ၊ သင့် ထံ သို့ငါဝင် ရသောအခွင့်ကိုပေးပါလော့ဟု ဆို လေသော်၊ မိန်းမက၊ သင်သည် ကျွန်မ ထံ သို့ဝင် လိုသောငှါအဘယ် ဆုကို ပေး မည်နည်းဟုမေးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ယုဒက၊ ဆိတ် သငယ် ကိုပေး လိုက်မည်ဟု ဆို လေ ၏။ မိန်းမကလည်း၊ မ ပေး လိုက်မှီ တစုံတခုသောအရာကို ပေါင် ထားမည်လောဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ယုဒက အဘယ် အရာကို ပေါင် စေချင်သနည်း ဟု ပြန်၍မေး လေသော် ၊ မိန်းမက၊ သင် ၏တံဆိပ် ၊ စလွယ် ၊ လက်စွဲ တောင်ဝေး တို့ကို ပေါင်တော့ဟု ဆိုသည်အတိုင်း၊ ထိုဥစ္စာကိုအပ် ၍ မိန်းမ ထံ သို့ဝင် သဖြင့် ၊ သူသည် ပဋိသန္ဓေစွဲ ယူလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ထိုနောက်မှ ၊ မိန်းမသည် ထ သွား ၍ မျက်နှာဖုံး ကို ချွတ် ပြီးလျှင် ၊ မုတ်ဆိုးမ အဝတ် ကို ဝတ်မြဲဝတ် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ယုဒ သည် မိန်းမ ၌ပေါင် သောဥစ္စာကို ရွေး ယူ ခြင်းငှါ ၊ မိမိ အဆွေ အဒုလံ အမျိုးသားတွင် ဆိတ် သငယ် ကိုပေး လိုက်၏။ အဒုလံအမျိုးသားသည် ထိုမိန်းမ ကို မ တွေ့ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ဧနိမ် မြို့လမ်း နား မှာ ထိုင်နေသောပြည်တန်ဆာမ သည် အဘယ် မှာရှိသနည်းဟု ထိုအရပ်သား တို့ကို မေး လေသော်၊ အရပ်သားတို့က ဤ အရပ်၌ ပြည်တန်ဆာမ မ ရှိ ဟုဆို ကြလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ယုဒ ထံ သို့ ပြန် ၍ ၊ ကျွန်ုပ်သည် ထိုမိန်းမ ကို ရှာ၍မ တွေ့။ အရပ် သား တို့ကလည်း ၊ ဤ အရပ်၌ ပြည်တန်ဆာမ မ ရှိ ဟု ဆိုကြောင်းကို ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ယုဒ ကလည်း ၊ အရှက် မကွဲမည်အကြောင်း ၊ ယူ ပါ လေစ။ ကြည့် ပါ။ ဤ ဆိတ် သငယ်ကို ကျွန်ုပ်ပေး လိုက်၍ သင်သည် မိန်းမ ကိုရှာ၍ မ တွေ့ ပါတကားဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ထိုနောက် သုံး လ ခန့် လွန်သည်ရှိ သော်၊ သူတပါး က၊ သင် ၏ချွေးမ တာမာ သည် ပြည်တန်ဆာ လုပ်၍ မ တရားသောမေထုန် ပြုသဖြင့် ကိုယ်ဝန် ဆောင်လျက် နေပြီတကားဟု ယုဒ အား ပြောဆို လျှင်၊ ယုဒ က သူ့ ကို ထုတ် ၍ မီးရှို့ စေဟု စီရင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ထုတ် သောအခါ ၊ တာမာ သည် တံဆိပ် ၊ စလွယ် ၊ တောင်ဝေး တို့ကို ယောက္ခမ ထံ သို့ ပို့ စေ၍၊ ဤ ဥစ္စာကို ပိုင်သောသူအားဖြင့် ကျွန်မ သည် ပဋိသန္ဓေ ယူပြီ။ ဤ ဥစ္စာတို့သည် အဘယ်သူ ၏ ဥစ္စာဖြစ်သည်ကို ကြည့် ပါလော့ဟု မှာ လိုက်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ထိုဥစ္စာ ကိုယုဒ မှတ်မိ ၍ သူ အပြစ်ထက် ငါ့ အပြစ်သာ၍ ကြီးပေ၏။ သူ့ အား ငါ့ သား ရှေလ ကို ငါမ ပေးစား ဘဲနေမိပြီဟု ပြောဆို ၏။ နောက်တဖန် သူ့ ကို မ ချဉ်းကပ် ဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ထိုနောက် တာမာ သည် သားဘွား ချိန် ရောက် လျှင် ၊ ဝမ်း ထဲ တွင် သား နှစ်ယောက်ရှိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ဘွား စဉ်တွင် သားတယောက်သည် လက် ကို ထုတ် ဆန့်၍ ၊ ဝမ်းဆွဲ က ဤ သူငယ်သည် အရင် ဘွား လိမ့်မည် ဟုဆို လျက် လက် ကိုကိုင် ၍ နီ သောကြိုးနှင့် စည်း လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","သို့သော်လည်း ထိုသူသည်မိမိ လက် ကိုရုပ် ပြန်၍ သူ့ အစ်ကို ဘွား သည်ကို ဝမ်းဆွဲက၊ သင်သည် အဘယ်ကြောင့် အနိုင် အထက်ပြုရသနည်း။ အနိုင်အထက် ပြုသော ဤအမှုသည် သင်၌စွဲစေဟုဆိုလျက် သူ့ ကိုဖါရက် အမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ထိုနောက်မှ လက် ၌ ကြိုးနီ စည်းသောညီ ဘွား ၍၊ သူ့ ကိုဇာရ အမည် ဖြင့် မှည့် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ဣရှမေလ လူတို့သည် ယောသပ် ကို ဆောင်သွား ၍ အဲဂုတ္တု ပြည်သို့ ရောက် သောအခါ ၊ အဲဂုတ္တု အမျိုးသား ဖါရော ဘုရင်၏အမတ် ဖြစ်သော ကိုယ်ရံတော် မှူး ပေါတိဖါ ထံ မှာ ရောင်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ထာဝရဘုရား သည် ယောသပ် ဘက် ၌ ရှိ တော်မူသဖြင့် သူ သည် အကြံ ထမြောက်တတ်၏။ အဲဂုတ္တု အမျိုးသားမိမိ သခင် ၏အိမ် ၌ နေ ရလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","သူ့ ဘက် ၌ ထာဝရဘုရား သည် ရှိတော်မူ၍၊ သူ ပြု လေရာရာ ၌ အောင် စေတော်မူကြောင်းကို သခင် လည်း သိမြင် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ထိုကြောင့် ယောသပ် သည် သခင် ရှေ့ ၌ မျက်နှာ ရ၍ ခစား လျက် နေရ၏။ သခင်သည်လည်း မိမိ အိမ်တွင် အိမ် အုပ် အရာနှင့် ခန့် ထား၍ ဥစ္စာရှိသမျှ ကို အပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ထိုသို့ အိမ် နှင့် ဥစ္စာရှိသမျှ ကို အုပ်စိုး စေသည် ကာလ မှစ၍ ထာဝရဘုရား သည် ယောသပ် အတွက် ထိုအဲဂုတ္တု သား၏အိမ် ကို ကောင်းကြီး ပေးတော်မူသဖြင့်၊ ပေးတော်မူသောကောင်းကြီး မင်္ဂလာသည် အတွင်း ၊ ပြင် ၊ ဥစ္စာရှိရှိသမျှ အပေါ် မှာလည်း သက်ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","သခင် သည် မိမိ ၌ ရှိသမျှ ကို ယောသပ် လက် သို့ အပ် ၍ ၊ မိမိ စား သော အစာ မှတပါး အခြား သော ဥစ္စာ ရှိမှန်းကိုမျှ မ သိ မမှတ်ဘဲနေ၏။ ယောသပ် သည် ပုံပြင် ယဉ်ကျေး ၍ အသွေး အဆင်းလည်း လှ သောသူဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ထိုနောက်မှ သခင် ၏မယား သည် ယောသပ် ကို တပ် သောစိတ်ရှိ၍ ငါ နှင့်အတူ အိပ် ပါဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ယောသပ်ကလည်း၊ ကျွန်တော် သခင် သည် အိမ် တော်၌ ရှိသမျှ သော ဥစ္စာတို့ကို ကျွန်တော် လက် သို့ အပ် ပါပြီ။ ကျွန်တော်၌ အဘယ် ဥစ္စာရှိမှန်းကိုမျှ မ သိ မမှတ်ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ဤ အိမ် တွင် လည်း ကျွန်တော် ထက် သာ၍ကြီး သောသူမ ရှိပါ။ ကိုယ် မယား ဖြစ်သော သခင်မ မှတပါး အဘယ် အရာကိုမျှ ကျွန်တော် အား မ မြစ်တား ပါ။ သို့ဖြစ်လျှင် အပြစ် ကြီး သောဤ အမှုကို ကျွန်တော်ပြု ၍ ဘုရားသခင် ကို အဘယ်သို့ ပြစ်မှား နိုင်သနည်းဟု သခင် ၏မယား ကို ငြင်း ၍ ပြန်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ထိုသို့ သခင်မသည် နေ့ တိုင်းသွေးဆောင်သော်လည်း ၊ ယောသပ် သည် သူ ၏စကား ကို နား မ ထောင်၊ သူ နှင့်အတူ အိပ် ခြင်း၊ နေခြင်းအမှုကို ရှောင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","တနေ့သ၌ ယောသပ် သည် အမှု ဆောင် ခြင်းငှါ အိမ် ထဲသို့ ဝင် ၍ အိမ် သားယောက်ျား တယောက် မျှ မ ရှိ သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","သခင်မက ငါ နှင့်အတူ အိပ် ပါဟုဆို လျက် ၊ ယောသပ် အဝတ် ကို ကိုင် ဆွဲလျှင်၊ ယောသပ်သည် မိမိ အဝတ် ကိုစွန့် ၍ ပြင် သို့ ထွက် ပြေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ထိုသို့ သခင်မ လက် ၌ မိမိ အဝတ် ကိုစွန့် ၍ ပြင် သို့ ထွက်ပြေး သည်ကို သခင်မ သိမြင် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","အိမ်သား ယောက်ျား တို့ကို ခေါ် ၍ ၊ သင် တို့ကြည့် ကြ။ ငါ တို့၌ မ ရိုမသေပြုစေခြင်းငှါ ဤဟေဗြဲ လူ ကို သခင်သွင်း ထားပြီတကား။ သူသည် ငါ နှင့်အတူ အိပ် ခြင်းငှါ ဝင်လာ ၍ ငါသည် ကျယ် သောအသံ နှင့် အော်ဟစ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ကျယ်ကျယ်အော်ဟစ် သံ ကို ကြား လျှင် ၊ သူသည် မိမိ အဝတ် ကိုစွန့် ၍ ပြင် သို့ ထွက် ပြေး သည်ဟုဆို ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","သခင် ရောက် သည်တိုင်အောင် ထိုအဝတ် ကို မိမိ ၌ ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","သခင်ရောက်သောအခါ၊ ကိုယ်တော်သွင်း ထား သော ဟေဗြဲ ကျွန် သည် ကျွန်ုပ် ကို မ ရိုမသေပြုခြင်းငှါ ဝင် လာပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ကျွန်ုပ် သည် ကျယ် သောအသံ နှင့် အော်ဟစ် သောအခါ ၊ သူသည် မိမိ အဝတ် ကို စွန့် ၍ ပြင် သို့ ထွက်ပြေး ပါသည်ဟူသော စကား ဖြင့် ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ကိုယ်တော် ၏ကျွန် သည် ကျွန်ုပ် ၌ ဤ သို့ပြု ခဲ့ပြီဟု မယား ပြောသောစကား ကို သခင် ကြား လျှင် ၊ ယောသပ် ကို အမျက်ထွက် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ခေါ် ပြီးမှ ၊ ရှင်ဘုရင် ချုပ် ထားသောသူတို့ နေရာ ထောင် ထဲ မှာ လှောင် ထားသဖြင့် ၊ ယောသပ်သည် ထောင် ထဲ မှာ နေ ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","သို့သော်လည်း ထာဝရဘုရား သည် သူ့ ဘက် ၌ ရှိ၍ ကယ်မသနား တော်မူသဖြင့် ၊ ထောင် မှူး ထံ မျက်နှာ ရစေ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","သို့ဖြစ်၍ ထောင် မှူး သည် ထောင်၌ ချုပ် ထားသော သူအပေါင်း တို့ကို ယောသပ် လက် သို့ အပ်၍၊ ထောင် ထဲ တွင် ပြု သမျှ သောအမှုကို ယောသပ်စီရင် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ထိုနောက်ထောင် မှူး သည် ထောင်အမှုကို ကိုယ်တိုင်ပြန်၍ မ ကြည့် မရှုရ။ အကြောင်း မူကား၊ ထာဝရဘုရား သည် ယောသပ် ဘက် မှာရှိ၍ သူ ပြု လေရာရာ ၌ အောင် စေတော်မူသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ထို နောက်မှအဲဂုတ္တု ရှင်ဘုရင် ထံ ဖလား တော် ဝန်နှင့် စား တော်ဝန်တို့သည် မိမိ တို့အရှင် အဲဂုတ္တု ရှင်ဘုရင် ကို ပြစ်မှား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ဖါရော ဘုရင်သည် ထို အမတ် နှစ် ယောက်တည်းဟူသောဖလား တော်ဝန်နှင့် စား တော်ဝန်တို့ကို အမျက်ထွက် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ယောသပ် အချုပ် ခံရာ ထောင် တည်းဟူသော ကိုယ်ရံတော် မှူး၏အိမ် ၌ ချုပ် ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ကိုယ်ရံတော် မှူးသည် သူ တို့ကို ယောသပ် ၌ အပ်၍၊ ယောသပ်သည် ပြု စုရ၏။ သူတို့လည်း အင်တန် ကာလ အချုပ် ခံလျက် နေ ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ထိုသို့ထောင် ထဲ မှာ အချုပ် ခံလျက်နေရသော အဲဂုတ္တု ရှင် ဘုရင်၏ ဖလား တော်ဝန်နှင့် စား တော်ဝန် နှစ် ယောက်တို့သည်၊ အသီးအသီး မိမိ တို့ ကိုယ်စီဆိုင်သော အနက် နှင့်ပြည့်စုံသော အိပ်မက် ကို တညဉ့် ခြင်း တွင် တယောက်တနည်းစီ မြင် မက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","နံနက် အချိန်ရောက် မှ ယောသပ် သည် သူ တို့ ထံ သို့ဝင် ၍ ကြည့်ရှု သောအခါ ၊ သူ တို့မျက်နှာ ညှိုးငယ်လျက် ရှိသည်ကိုမြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","သင် တို့သည် ယနေ့ အဘယ်ကြောင့် မျက်နှာ ညှိုးငယ် သနည်းဟု မိမိ သခင် အိမ် ၌ မိမိ နှင့်အတူ အချုပ် ခံ နေရသော ဖါရော မင်း၏ အမတ် တို့အား မေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","သူတို့ကလည်း၊ ငါတို့သည် အိပ်မက်ကိုမြင်ရပြီ။ အနက်ကို ဘတ်နိုင်သောသူ မရှိဟုဆိုကြသော်၊ ယောသပ် က၊ အိပ်မက်အနက်များကို ဘုရားသခင် ဆိုင်တော်မူသည် မ ဟုတ်လော။ သို့ဖြစ်၍သင်တို့အိပ်မက်ကို ကျွန်ုပ် အား ကြား ပြောကြပါဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ထိုအခါ ဖလား တော်ဝန်သည် မိမိ အိပ်မက် ကို ယောသပ် အား ကြား ပြောသည်ကား၊ ငါ မြင်မက်သော အိပ်မက် တွင် ၊ ငါ့ ရှေ့ မှာ စပျစ် နွယ်ပင် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ထိုစပျစ် နွယ်ပင်၌ အလက် သုံး လက်ရှိ၏။ ထိုအလက်တို့၌ ပန်း ငုံကဲ့သို့ရှိ၏။ အပွင့် လည်း ပွင့်၏။ အသီး ပြွတ် တို့လည်း မှည့် သောစပျစ် သီး ဖြစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ဖါရော မင်း၏ ဖလား တော်ကို ငါ ကိုင် လျက် ၊ ထိုစပျစ် သီးကိုယူ ၍ ဖလား တော်၌ ညှစ် ပြီးမှ လက် တော် တွင် ဆက်သည်ဟုပြောဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ယောသပ် ကလည်း သင် ၏အိပ်မက် အနက် ဟူမူကား ၊ စပျစ်နွယ်သုံး လက် တို့သည် သုံး ရက် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","သုံး ရက် လွန်မှ ဖါရော မင်းသည် သင် ၏ဦးခေါင်း ကို ချီးမြှောက် ၍ သင် ၏အရာ ကို ပြန် ပေးတော်မူသဖြင့် ၊ သင်သည်အထက် က ဖလား တော်ဝန်ဖြစ် ၍ပြုဘူးသည် နည်းတူ ၊ တဖန်ဖလား တော်ကို ဖါရော မင်း၏လက် တွင် ဆက်မြဲ ဆက် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","သင်သည် ချမ်းသာရသောအခါ ကျွန်ုပ် ကို အောက်မေ့ ၍ ကျေးဇူး ပြုပါလော့။ ဖါရော ဘုရင်ကိုလျှောက်၍ ကျွန်ုပ် ကို ဤ အိမ် မှ နှုတ် ယူပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","အကယ်စင်စစ် ကျွန်ုပ်ကို ဟေဗြဲ ပြည် မှ ခိုး ယူခဲ့ ကြ၏။ ဤ ပြည်မှာလည်း ကျွန်ုပ် ၌ အပြစ် မ ရှိဘဲ ထောင်ထဲမှာ လှောင် ထားကြသည်ဟုဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ထိုအိပ်မက်အနက် ကောင်း သည်ကို စား တော် ဝန် သိ မြင်လျှင် ၊ ငါ သည်လည်း ဖြူသောတောင်း သုံး လုံးကို ကိုယ်တိုင် ရွက် နေသည်ကို မြင် မက်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","အပေါ် တောင်း တွင် ဖါရော မင်းစားတော်ခေါ် ဘို့ ချက် ပြီးသော ခဲဘွယ် စားဘွယ်အမျိုးမျိုး ရှိ၍၊ ငှက် တို့သည်လည်း ငါ ရွက် သော တောင်း ထဲ ကနှုတ်၍ စား ကြသည်ဟု ယောသပ် အား ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ယောသပ် ကလည်း ၊ သင်၏အိပ်မက်အနက် ဟူမူကား ၊ တောင်း သုံး လုံးသည် သုံး ရက် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","သုံး ရက် လွန်မှ ဖါရော မင်းသည် သင် ၏ဦးခေါင်း ကို ကိုယ်နှင့်ခွါ မြှောက်လျှက် သစ်ပင် ၌ ဆွဲ ထားတော်မူ၍၊ ငှက် တို့သည် သင် ၏အသား ကို နှုတ်၍စား ကြလိမ့်မည်ဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ထိုနောက် သုံး ရက် လွန်သောအခါ၊ ဖါရော မင်း ဘွား သောနေ့ရက် ၌ နှစ်စဉ်ပွဲ ကိုခံ ၍ ကျွန်တော် မျိုး အပေါင်း တို့ကို ကျွေးမွေးတော်မူစဉ်တွင်၊ ဖလား တော်ဝန် ၏ဦးခေါင်း နှင့် စား တော်ဝန်၏ဦးခေါင်း ကို ကျွန်တော် မျိုး တို့တွင် ဖေါ် တော်မူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","အိပ်မက် အနက်ကို ယောသပ် ဘတ် သည် အတိုင်း ၊ ဖလား တော်ဝန်ကို အထက် အရာ၌ တဖန် ခန့်ထား တော်မူသဖြင့် ၊ သူ သည်ဖလား တော်ကို ဖါရော မင်း၏လက် တွင် ဆက် မြဲဆက်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","စား တော်ဝန်ကိုမူကား ၊ ဆွဲ ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","သို့သော်လည်း ဖလား တော်ဝန်သည် ယောသပ် ကို မ အောက်မေ့ ဘဲ မေ့လျော့ ၍နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ထိုနောက် နှစ် နှစ်လွန် သောအခါ ၊ ဖါရော မင်း သည် အိပ်မက် ကို မြင်မက်သည်ကား၊ မိမိသည် မြစ် နား ၌ ရပ် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","အဆင်း လှ ၍ ဝ သော နွား ခုနစ် ကောင်တို့သည် မြစ် ထဲ ကထွက်၍ မြစ်နားမှာပေါက်သော မြက်ပင် ကို စား လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ထိုနွားတို့နောက်မှ အဆင်း မ လှ၊ ပိန်သော နွား ခုနစ် ကောင်တို့သည် မြစ် ထဲ ကထွက် ၍ အရင်နွား တို့ အနား ၌ ကမ်း ပေါ် မှာ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","အဆင်း မ လှ ပိန် သောနွား တို့သည်၊ အဆင်း လှ ၍ ဝ သောနွား ခုနစ် ကောင်တို့ကို ကိုက်စား ကြ၏။ ဖါရော မင်းလည်း နိုး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","တဖန် အိပ် ပြန်၍ အိပ်မက် ကို မြင်မက်ပြန်သည် ကား၊ အလုံး ကြီး ၍ ကောင်း သော စပါးခုနစ် နှံတို့သည် စပါး တပင် တည်း၌ ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ထိုနောက်မှ အလုံး သေး၍ အရှေ့ လေဖြင့် ပျက် သော စပါး ခုနစ် နှံတို့သည် ပေါက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","အလုံး သေးသော စပါး ခုနစ် နှံတို့သည် အလုံး ကြီး၍ ကောင်း သော စပါး ခုနစ်နှံတို့ကို စား ကြ၏။ ဖါရော မင်းလည်း နိုး ၍ အိပ်မက် ဖြစ်သည်ကို သိ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","နံနက် အချိန် ရောက် သောအခါ ၊ ဖါရော မင်း သည် စိတ် ပူပန် ၍ ၊ အဲဂုတ္တု ဗေဒင် တတ် ပညာရှိအပေါင်း တို့ကို ခေါ် ၍ အိပ်မက် တော်ကို ပြန်ကြား တော်မူ၏။ သို့သော်လည်း ရှေ့ တော်၌အနက် ကို ဘတ်နိုင်သောသူ တယောက် မျှမရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ထိုအခါ ဖလား တော်ဝန်က ၊ ကျွန်တော် သည် ကိုယ် အပြစ် ကို ယနေ့ အောက်မေ့ ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ဖါရော ဘုရင်သည် ကျွန်တော် နှင့် စား တော်ဝန် ကို အမျက်ထွက် ၍ ကိုယ်ရံတော် မှူးအိမ် ၌ ချုပ် ထားတော်မူ သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ကျွန်တော် တို့နှစ်ယောက်သည် အသီးအသီး မိမိတို့ ကိုယ်စီဆိုင်သော အနက် နှင့်ပြည့်စုံသော အိပ်မက် ကို တညဉ့် ခြင်း တွင် မြင် မက်ကြပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ကျွန်တော် တို့၌ ကိုယ်ရံတော် မှူး၏ကျွန် ဟေဗြဲ လုလင် တယောက်ရှိ၏။ ထိုသူ အား ကျွန်တော်တို့သည် ကြားပြော ၍ သူ သည် အိပ်မက် ၏အနက် ကို ဘတ်ပါ၏။ တ ယောက်စီမြင် မက်သည်အတိုင်း ဘတ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ဘတ် သည်အတိုင်း လည်း မှန် ပါ၏။ ကျွန်တော် သည်အရင်အရာ ကိုရ ပြန်၍၊ စား တော်ဝန်မူကား ၊ ဆွဲ ထား ခြင်းကိုခံရပါသည်ဟု လျှောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ထိုအခါ ဖါရော မင်းသည် လူကိုစေလွှတ် ၍ ယောသပ် ကို ခေါ် တော်မူ၏။ ယောသပ်သည် ထောင် ထဲ က အလျင် အမြန်ထွက်ရ၍ ၊ မုတ်ဆိတ် ညှပ်ခြင်း၊ အဝတ် လဲ ခြင်းကို ပြုပြီး မှ အထံ တော်သို့ ဝင် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ဖါရော မင်းကလည်း ၊ ငါသည်အိပ်မက် ကို မြင် မက်ပြီ။ အနက်ကို အဘယ် သူမျှမဘတ် နိုင်။ သင် သည် အိပ်မက် ကို နားလည် သော ဉာဏ်နှင့် အနက် ဘတ်နိုင် သည်ကို ငါကြား ရပြီဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ယောသပ် ကလည်း ၊ ကျွန်တော် သည် အလို အလျောက်မ တတ်နိုင်ပါ။ ဘုရားသခင် သည် မင်္ဂလာ အဖြေ စကားကို ဖါရော ဘုရင်အား ပေး တော်မူပါစေသော ဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ဖါရော မင်းကလည်း ၊ ငါ မြင် မက်သည်မှာ ၊ မြစ် နား ၌ ငါ ရပ် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","အဆင်း လှ ၍ ဝ သော နွား ခုနစ် ကောင်တို့သည် မြစ် ထဲ ကထွက် ၍ ၊ မြစ်နားမှာပေါက်သော မြက်ပင် ကို စား လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ထိုနွားတို့နောက်မှ၊ အဆင်း မ လှ ပိန် ကြုံသော နွား ခုနစ် ကောင်တို့သည် ထွက် လာကြ၏။ ထိုမျှလောက် အရုပ် ဆိုးသော နွားတို့ကို အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် တခါမျှ မမြင် ရစဖူး။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","အဆင်းမ လှ ပိန် သောနွား တို့သည်၊ ဝ သော အရင် နွား ခုနစ် ကောင်တို့ကို ကိုက်စား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","စားပြီးသောနောက်၊ စား မှန်းကို အဘယ်သူမျှမ သိ ရ။ အရင် ကဲ့သို့ အရုပ် ဆိုး သေး၏။ ငါလည်း နိုး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","တဖန် ငါ မြင် မက် ပြန်သည် ကား၊ အလုံး ကြီး၍ ကောင်း သော စပါး ခုနစ် နှံတို့သည် စပါးတပင် တည်း၌ ဖြစ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ထိုနောက်မှ ညှိုးနွမ်း လျက် အလုံး သေး၍ အရှေ့ လေဖြင့် ပျက် သော စပါး ခုနစ် နှံတို့သည် ပေါက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","အလုံး သေးသော စပါး နှံတို့သည် ကောင်း သော စပါး ခုနစ် နှံတို့ကို စား ကြ၏။ ထိုအိပ်မက်ကို ဗေဒင် တတ် တို့အား ငါကြား ပြော၍ အနက်ကို အဘယ်သူ မျှမဘတ် နိုင်ဟု ယောသပ်အား ပြောဆိုတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ယောသပ် ကလည်း၊ ဖါရော ဘုရင် မြင်မက်တော်မူ သောအိပ်မက် ကား တပါးတည်း ဖြစ်ပါ၏။ ဘုရားသခင် ပြု လတံ့သောအမှု ကို ဖါရော ဘုရင်အား ပြ တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ကောင်း သော နွား ခုနစ် ကောင်တို့သည် ခုနစ် နှစ် ဖြစ်ပါ၏။ ကောင်း သောစပါး ခုနစ် နှံတို့သည်လည်း ခုနစ် နှစ် ဖြစ်ပါ၏။ အိပ်မက် တော်ကား တပါး တည်း ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ထိုနွားတို့နောက် ထွက် လာသောနွား၊ ပိန် ၍ အရုပ် ဆိုးသော နွား ခုနစ် ကောင်တို့သည် ခုနစ် နှစ် ဖြစ်ပါ ၏။ အရှေ့ လေဖြင့်ပျက် သော စပါး ဖျင်း ခုနစ် နှံတို့သည် လည်း၊ အစာခေါင်းပါး သော ခုနစ် နှစ် ဖြစ် ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ဖါရော ဘုရင်အား ကျွန်တော်လျှောက် လိုသော အရာ ဟူမူကား ၊ ဘုရားသခင် ပြု လတံ့သော အမှုကိုဖါရော ဘုရင်အား ပြ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် ဝ ပြောသောနှစ် ခုနစ် နှစ် ရှိ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ထိုနောက်မှ အစာခေါင်းပါး သောနှစ် ခုနစ် နှစ် ပေါ် လာ၍ ၊ အဲဂုတ္တု ပြည် ၌ အလုံးစုံ သော ဝ ပြောခြင်းသည် တိမ်မြုပ် လျက် အစာခေါင်းပါး ခြင်းအားဖြင့်တပြည် လုံးပျက်စီး လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","အစာခေါင်းပါး ခြင်းသည် အလွန် အားကြီး သောကြောင့် ၊ အရင် ဝပြောခြင်း၏ လက္ခဏာမ ထင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ဖါရော ဘုရင်သည် ထပ်၍ အိပ်မက် မြင်ရသည် အရာမှာ၊ ထိုအမှု ကို ဘုရားသခင် မြဲမြံ ခိုင်ခံ့စေ၍ အလျင်အမြန် စီရင် တော်မူလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","သို့ဖြစ်၍ ဖါရော ဘုရင်သည် ဉာဏ် ပညာနှင့် ပြည့်စုံ သောသူ ကို ရွေးချယ် ၍ အဲဂုတ္တု ပြည် ကို အုပ်စိုး စေတော်မူပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ခန့်ထားတော်မူသောသူသည်လည်း တပြည် လုံး၌ အကြီး အကြပ်တို့ကို ခန့် ထား၍ ၊ ဝပြော သောနှစ် ခုနစ် နှစ် ပတ်လုံး တပြည် လုံးတွင် ငါး ဘို့တဘို့ကောက်ယူကြ ပါစေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ထို သူတို့သည်ဖြစ် လတံ့သော မင်္ဂလာ နှစ် တို့တွင် ရိက္ခါ ရှိသမျှ ကို စုရုံး ၍ ဖါရော ဘုရင်ထံ တော်၌ စပါး များ ကို ဆည်းဘူး ကြပါစေ။ မြို့ များ၌ လည်း ရိက္ခါ ကို သို ထား ကြပါစေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","သို့ဖြစ်၍ အဲဂုတ္တု ပြည် ၌ အစာခေါင်းပါး သောနှစ် ခုနစ် နှစ်ရောက် သောအခါ ၊ ပြည် သူပြည်သားစားစရာ ဘို့ သို ထားလျက် ရှိ နှင့်၍ အစာခေါင်းပါး သော ကာလတွင် ပြည် တော်မ ပျက် ရဟု ဖါရောမင်းအား လျှောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ထိုသို့ ယောသပ်လျှောက်သောစကား ကို ဖါရော မင်းအစရှိသော ကျွန် တော်မျိုးအပေါင်း တို့သည် နှစ်သက် ကြ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ဖါရော မင်းက ၊ ဘုရားသခင် ၏ ဝိညာဉ် တော်ကို ရ၍ ဤ ကဲ့သို့ သောသူ ကို အဘယ်မှာ ရှာ ၍ တွေ့မည်နည်း ဟု ကျွန် တော်မျိုးတို့အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ယောသပ် အား လည်း ၊ ဘုရားသခင် သည် ဤအမှု အလုံးစုံ တို့ကို သင့် အား ပြု တော်မူသည်ဖြစ်၍သင် ကဲ့သို့ ဉာဏ် ပညာနှင့် ပြည့်စုံ သောသူ မရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","သင် သည် နန်းတော် အုပ် ဖြစ် ရမည်။ သင် ၏ စကား အတိုင်း ငါ ၏ပြည်သား အပေါင်း တို့ကို ငါစီရင် စေမည်။ ရာဇ ပလ္လင်အားဖြင့်သာ ငါသည် သင့် ထက် ကြီးမြတ် မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","တဖန် ကြည့် ပါ၊ အဲဂုတ္တု ပြည် တပြည်လုံး ကို သင် အုပ်စိုး စေခြင်းငှါ ငါခန့် ထားပြီဟု ယောသပ် အား မိန့် တော်မူလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","လက်စွပ် တော်ကိုချွတ် ၍ ယောသပ် လက် ၌ စွပ် စေတော်မူ၏။ ပိတ်ချော အဝတ် ကိုလည်း ဝတ် စေ၍ ၊ လည်ပင်း ၌ ရွှေ စလွယ် ကိုဆွဲ ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ဒုတိယ ရထား တော်ကို စီး စေတော်မူ၏။ ပြပ်ဝပ် ၍ နေကြဟု သူ့ ရှေ့ မှာ ဟစ် ကြ၏။ ထိုသို့လျှင် အဲဂုတ္တု ပြည် တပြည်လုံး ကို အုပ်စိုး စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ဖါရော မင်းကလည်း၊ ငါ သည် ဖါရော ဘုရင် မှန်၏။ သို့ဖြစ်၍ သင် ၏အခွင့် မရှိလျှင် အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် အဘယ်သူမျှမိမိ လက် ခြေ ကိုမ ကြွ ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ဖါရောမင်းသည်လည်း၊ ဇာဖဏာသဖါဏ တည်း ဟူသောဘွဲ့ နာမနှင့်ယောသပ် ကို ချီးမြှောက် ၍ ဩန မြို့၏ ယဇ်ပုရောဟိတ် ပေါတိဖေရ ၏သမီး အာသနတ် နှင့် စုံဘက် စေတော်မူ၏။ ထိုသို့ယောသပ် သည် အဲဂုတ္တု နိုင်ငံ အုပ်အရာနှင့် အထံ တော်ကထွက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ယောသပ် သည် အဲဂုတ္တု ရှင်ဘုရင် ဖါရော မင်း ထံ ၌ အခွင့် ရသောအခါ ၊ အသက် အနှစ်သုံးဆယ် ရှိသတည်း။ အထံတော်ကထွက် ၍ အဲဂုတ္တု ပြည် တရှောက်လုံး သို့ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ဝပြော နှစ် ခုနစ် နှစ်ပတ်လုံးမြေ အသီးအနှံတို့ သည် အလွန် များပြားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ခုနစ်နှစ်ပတ်လုံးအဲဂုတ္တု ပြည် တွင် ရှိသမျှ သော ရိက္ခါ ကိုစုရုံး ၍ မြို့ တို့၌ သို ထားလေ၏။ မြို့ ပတ်ဝန်းကျင် လယ်တို့၌ရသောရိက္ခါကိုမြို့အသီးအသီးတို့တွင် သိုထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","စပါး ကိုကား သမုဒ္ဒရာ သဲ လုံးနှင့်အမျှ အလွန် များ စွာစု ထား၍ မ ရေတွက် နိုင်အောင် များသောကြောင့် မ ရေတွက် ဘဲနေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","အစာခေါင်းပါး သောနှစ် မ ရောက် မှီ၊ ယောသပ် သည် ဩန မြို့၏ယဇ် ပုရောဟိတ်ပေါတိဖေရ ၏သမီး အာသနတ် တွင် သား နှစ် ယောက်တို့ကို မြင် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","သား ဦးကိုကား မနာရှေ အမည် ဖြင့် မှည့် လေ၏။ အကြောင်း မူကား၊ ငါ ခံရသမျှ သော ပင်ပန်း ခြင်းနှင့် ငါ့ အဘ ၏ အိမ်သား အပေါင်း တို့ကို ငါ မေ့ စေခြင်းငှါ ဘုရားသခင် ပြုတော်မူပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","နောက် ရသောသားကိုကား၊ ဧဖရိမ် အမည် ဖြင့် မှည့် လေ၏။ အကြောင်း မူကား၊ ဘုရားသခင် သည် ငါ ဆင်းရဲ ခံရသောပြည် ၌ ငါ့ ကိုပွါး များ စေတော်မူပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ထိုနောက် အဲဂုတ္တု ပြည် ၌ ဝပြော သောနှစ် ခုနစ် နှစ် ကုန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ယောသပ် ပြော သည်အတိုင်း အစာခေါင်းပါး သော နှစ် တို့သည် ရောက် စ ရှိ၏။ ထိုအခါ ခပ်သိမ်း သော ပြည် တို့၌ အစာခေါင်းပါး ခြင်းရှိ သော်လည်း အဲဂုတ္တု ပြည် ၌ ဆန် စပါးရှိ သေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","နောက်တဖန် အဲဂုတ္တု ပြည် သူပြည်သားအပေါင်း တို့သည် မွတ်သိပ် သောအခါ စား စရာကိုရပါ မည်အကြောင်း ဖါရော မင်းထံ ၌ ကြွေးကြော် ကြ၏။ ဖါရော မင်းကလည်း ၊ ယောသပ် ထံ သို့သွား ကြ၊ သူစီရင် သည်အတိုင်း ပြု ကြဟု အဲဂုတ္တု ပြည်သူ ပြည်သားအပေါင်း တို့ကို မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","မြေပြင် တရှောက်လုံး ၌ အစာခေါင်းပါး သောအခါ ၊ ယောသပ် သည် စပါးကျီရှိသမျှ တို့ကို ဖွင့် ၍ အဲဂုတ္တု လူတို့အား ရောင်း လေ၏။ ထိုအခါ အဲဂုတ္တု ပြည် ၌ အစဉ်အတိုင်း အစာခေါင်းပါး သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ခပ်သိမ်းသော ပြည် တို့၌ လည်း အလွန်အစာ ခေါင်းပါး သောကြောင့် ၊ အသီးသီး သောပြည် သားတို့သည် စပါးကိုဝယ် ခြင်းငှါ အဲဂုတ္တု ပြည် ယောသပ် ထံ သို့လာ ရောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","အဲဂုတ္တု ပြည်၌ စပါး ရှိ ကြောင်း ကို ယာကုပ် ကြား သိလျှင် ၊ သင်တို့သည် အဘယ်ကြောင့် တယောက်ကို တယောက် ကြည့်ရှု ၍ နေကြသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","အဲဂုတ္တု ပြည်၌ စပါး ရှိ ကြောင်း ကို ငါကြား ရပြီ။ ငါတို့သည်မ သေ အသက်ရှင် မည်အကြောင်း ၊ ထို ပြည်သို့ သွား ၍ ငါ တို့အဘို့ ကို ဝယ် ကြလော့ဟု မိမိ သား တို့အား ဆို သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ယောသပ် ၏ အစ်ကို တကျိပ် တို့သည် စပါး ကို ဝယ် ခြင်းငှါ အဲဂုတ္တု ပြည်သို့ သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ယောသပ် ၏ညီ ဗင်္ယာမိန် ကိုကား အစ်ကို တို့နှင့်အတူ ယာကုပ် သည်မ စေ မလွှတ်။ အကြောင်း မူကား၊ သူ ၌ ဘေး ရောက် ကောင်းရောက်လိမ့်မည်ဟု စိုးရိမ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ထိုအခါ ခါနာန် ပြည် ၌ အစာခေါင်းပါး သောကြောင့် ၊ အဲဂုတ္တုပြည်သို့ရောက်လာ သောသူတို့ တွင်၊ ဣသရေလ သား တို့သည် စပါးကိုဝယ် ခြင်းငှါ လာ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ယောသပ် သည် နိုင်ငံ အုပ်ဖြစ်၍ပြည်သား အပေါင်း တို့အား ရောင်း သောအမှုကို စီရင်လေ၏။ ယောသပ် အစ်ကို တို့သည်လာ ၍ သူ့ ရှေ့ မှာ ဦးညွှတ် ချကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ယောသပ် သည် အစ်ကို တို့ကိုမြင် လျှင် သိ ၏။ သို့သော်လည်း မ သိဟန်ဆောင်၍ ကြမ်းတမ်း စွာ ပြော လျက် ၊ သင်တို့သည် အဘယ် က လာ ကြသနည်းဟုမေး ၏။ သူတို့ကလည်း၊ အစာ ကိုဝယ် ခြင်းငှါ ခါနာန် ပြည် က လာကြပါသည် ဟုလျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ယောသပ် သည် အစ်ကို တို့ကိုသိ သော်လည်း ၊ သူ တို့သည် ယောသပ် ကို မ သိ ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ယောသပ် သည် သူ တို့အကြောင်း နှင့် မြင် ရသောအိပ်မက် တို့ကို အောက်မေ့ လျက် ၊ သင် တို့သည် သူလျှို ဖြစ်ကြ၏။ ပြည် တော်၌ အားနည်း သောအရပ်ကို ကြည့်ရှု ခြင်းငှါ လာ ကြပြီဟုဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","သူ တို့က၊ မဟုတ် ပါသခင်။ ကိုယ်တော် ၏ကျွန် တို့ သည် အစာ ကို ဝယ် ခြင်းငှါ သာ လာ ကြပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ကျွန်တော် တို့သည် တယောက် တည်းသောသူ ၏ သား ဖြစ်ကြပါ၏။ ဖြောင့်မတ် သောသူလည်း ဖြစ်ကြပါ၏။ ကိုယ်တော် ၏ကျွန် တို့သည် သူလျှို မ ဟုတ်ပါဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ယောသပ်ကလည်း၊ မ ဟုတ်ဘူး။ ပြည် တော်၌ အားနည်း သော အရပ်ကိုကြည့်ရှု ခြင်းငှါ လာ ကြပြီဟု ဆို ပြန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","သူတို့ကလည်း၊ ကိုယ်တော် ကျွန် တို့သည် ခါနာန် ပြည် ၌ တ ယောက်တည်းသောသူ ၏သား ၊ ညီအစ်ကို တကျိပ် နှစ် ယောက် ဖြစ်ကြပါ၏။ အငယ်ဆုံး သောသူကား အဘ နှင့်အတူ ယခု ရှိရစ်ပါ၏။ တ ယောက်ကားမ ရှိပါဟု လျှောက် ပြန်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ယောသပ် က၊ သင် တို့သည် သူလျှို ဖြစ်ကြ၏ဟု ငါဆိုသည် အရာ မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","သင်တို့ကို အဘယ်သို့စုံစမ်း ရမည်နည်းဟူမူကား ၊ အငယ် ဆုံးသောညီ မ လာ လျှင်၊ ဖါရော ဘုရင် အသက် ရှင်တော်မူသည်အတိုင်း သင်တို့သည် ဤ အရပ်မှ မ ထွက် မသွားရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","သင် တို့စကား မှန် သည်မမှန်သည်ကို စုံစမ်း ၍ သိစေခြင်းငှါ သင် တို့တွင် တ ယောက်သောသူကို စေလွှတ် ၍ ညီ ကိုဆောင် ခဲ့စေ။ ကြွင်းသောသူတို့ကို ထောင် ထဲမှာ ချထားမည်။ သို့မဟုတ် ဖါရော ဘုရင် အသက် ရှင်တော်မူ သည်အတိုင်း၊ အကယ်စင်စစ်သင် တို့သည် သူလျှို ဖြစ်ကြ၏ဟုဆိုပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","အစ်ကို အပေါင်းတို့ကို သုံး ရက် ချုပ် ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","သုံး ရက်မြောက်သောနေ့ ၌ ယောသပ် သည် သူ တို့ကိုခေါ် ၍ ၊ ငါ သည် ဘုရားသခင် ကို ကြောက်ရွံ့ သောသူဖြစ် ၏။ သို့ဖြစ်၍သင်တို့သည် အသက် ချမ်းသာစေခြင်းငှါပြု ရသောအမှုဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","သင် တို့သည် ဖြောင့်မတ် သောသူမှန်လျှင် ၊ သင် တို့ညီအစ်ကို တို့တွင် တစုံတယောက် ကို ထောင် အိမ် ၌ အချုပ် ခံလျက်နေစေပြီးလျှင်၊ ကြွင်းသောသူတို့ မူကား သွား ကြလော့။ အိမ်သူ အိမ်သားတို့၌ အစာ ခေါင်းပါးသောကြောင့်စပါး ကိုယူ ၍ သွားကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","အငယ်ဆုံး သောညီကို ငါ့ ထံ သို့ဆောင် ခဲ့ကြလော့။ သို့ပြုလျှင် သင် တို့စကား မှန် လိမ့်မည်။ သင်တို့အသက်လည်း ချမ်းသာ ရလိမ့်မည်ဟုဆိုသည်အတိုင်း သူတို့သည်ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ထိုအခါ သူတို့အချင်းချင်း ဆို ကြသည်ကား၊ အကယ်စင်စစ်ငါ တို့ သည် ညီ ၏အမှု၌ အပြစ် ကြီးကြ၏။ သူ သည် ငါ တို့ကိုတောင်းပန် သောအခါ ၊ သူ့ စိတ် ဆင်းရဲ ခြင်းကို ငါတို့သည် မြင် လျက်နှင့် နား မ ထောင်ဘဲနေကြ ၏။ ထိုကြောင့် ဤအမှုသည် ငါ တို့အပေါ် မှာ ယခု ရောက် လာပြီဟု တယောက်ကိုတယောက် ပြောဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ရုဗင် ကလည်း၊ သူငယ် ကို မ ပြစ် မှားပါနှင့်ဟု ကျွန်ုပ်ဆို သည်မ ဟုတ် လော။ သင်တို့သည် နား မ ထောင်ဘဲ နေကြသောကြောင့် သူ ၏အသွေး အတွက် ယခု အစစ် ခံရကြသည်ဟု ပြန် ၍ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ထိုသို့ မိမိတို့ ပြောဆိုကြသောစကားကို ယောသပ် နားလည် သည်ဟု သူ တို့မ ထင် ကြ။ အကြောင်း မူကား၊ ယောသပ်သည် စကားပြန် နှင့် သူ တို့ကို ပြောတတ်သောကြောင့် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ထိုအခါ ယောသပ်သည် သူ တို့ထံ မှခဏ ခွါ၍ ငို လေ၏။ တဖန် လာ ပြန်၍ နှုတ်ဆက် ပြီးလျှင် ၊ ရှိမောင် ကို သူ တို့အစုထဲ ကယူ ၍ သူ တို့ရှေ့ တွင် ချည်နှောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ထိုနောက် သူ တို့အိတ် များကို စပါး နှင့် ပြည့် စေ၍ ၊ သူ တို့ငွေ ကိုလည်း အသီးအသီး အိတ် တို့တွင် ပြန်ထည့် စေခြင်းငှါ ၎င်း၊ လမ်းခရီး ၌ စား စရိတ်ကို ပေး စေခြင်းငှါ ၎င်း စီရင်၍ ထိုသို့လျှင် သူ တို့၌ ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","သူတို့သည်လည်း မြည်း များအပေါ် ၌ စပါး ကို တင် ၍ ထွက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","စားခန်း သို့ ရောက် သောအခါ ၊ တယောက်သောသူသည် မြည်း ကို အစာ ကျွေးခြင်းငှါ မိမိ အိတ် ကိုဖွင့် လျှင် ၊ အိတ် ဝ တွင် ရှိသောငွေ ကိုမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ညီအစ်ကို တို့အား လည်း ကျွန်ုပ် ငွေ ကို ပြန် ထား ပြီ။ ကြည့် ပါ အိတ် ထဲ မှာရှိသည်ဟုဆိုသော်၊ သူ တို့သည် စိတ် နှလုံးလျော့ ၍ ကြောက်လန့် လျက် ၊ ငါ တို့၌ ဘုရားသခင် ပြု တော်မူသောဤ အမှုသည် အဘယ် အမှုဖြစ် ပါလိမ့်မည်နည်းဟု တ ယောက်ကိုတယောက်ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ခါနာန် ပြည် အဘ ယာကုပ် ထံ သို့ရောက် လျှင် ၊ မိမိ တို့၌ ဖြစ် လေသမျှ တို့ကို ကြား ပြောသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ထိုပြည် ကိုအုပ်စိုး သောသူ သည် ကြမ်းတမ်း စွာ ပြော လျက် ၊ ကျွန်ုပ် တို့ကို ထိုပြည် ၌ သူလျှို လုပ်သူဟူ၍ မှတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ကျွန်ုပ် တို့ကလည်း ၊ ကျွန်တော် တို့သည် ဖြောင့်မတ် သောသူဖြစ် ကြပါ၏။ သူလျှို မ ဟုတ်ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","တဘ တည်းသား ၊ ညီအစ်ကို ချင်း တကျိပ် နှစ် ယောက်ဖြစ်ကြပါ၏။ တ ယောက်ကားမ ရှိပါ။ အငယ်ဆုံး သောသူကား ခါနာန် ပြည် ၌ အဘ နှင့်အတူ ယခု ရှိရစ် ပါသည်ဟု လျှောက်သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ထိုပြည် ကို အုပ်စိုး သောသခင်က၊ သင် တို့သည် ဖြောင့်မတ် သောသူမှန် သည်ကို အဘယ်သို့ငါသိ နိုင်မည်နည်း ဆိုသော်၊ သင် တို့ညီအစ်ကို တို့ တွင် တစုံတယောက် ကို ငါ့ ထံ ၌ထား ရစ်ကြလော့။ သင် တို့အိမ်သူ အိမ်သားတို့၌ အစာ ခေါင်းပါးသောကြောင့် အစာကိုယူ ၍ သွား ကြလော့၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","အငယ်ဆုံး သောညီ ကို ငါ့ ထံ သို့ဆောင် ခဲ့ကြလော့။ သို့ပြုလျှင်သင် တို့သည် သူလျှို မ ဟုတ် ဖြောင့်မတ် သောသူဖြစ်သည်ကို ငါသိ လိမ့်မည်။ သင် တို့ညီအစ်ကို ကို လည်း ငါပြန် ၍အပ်မည်။ သင်တို့သည် ပြည် တော်၌ ဖေါက် ကားရောင်းဝယ်ရကြမည်ဟု ဆိုကြောင်းကို ကြားပြောကြပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","မိမိ တို့အိတ် များအထဲက စပါးကို ထုတ် သောအခါ ၊ အသီးအသီး ဆိုင်သော ငွေ ထုပ် တို့သည် မိမိ တို့အိတ် ၌ ရှိ ကြ၏။ ငွေ ထုပ် များကို သူ တို့နှင့် အဘ သည် မြင် သောအခါ ကြောက်လန့် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","အဘ ယာကုပ် ကလည်း၊ သင်တို့သည် ငါ့သား တို့ကို လု ယူကြပြီ။ ယောသပ် မ ရှိ၊ ရှိမောင် မ ရှိ၊ ဗင်္ယာမိန် ကိုလည်း ယူ သွားချင်သည်တကား။ ဤ အမှုအလုံးစုံ တို့ သည် ငါ နှင့်ဆန့်ကျင် ဘက်ဖြစ်သည်တကားဟု သူ တို့အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ရုဗင် ကလည်း ၊ ကျွန်ုပ်သည် ဗင်္ယာမိန် ကို အဘ ထံ သို့ပြန်၍ မ ဆောင် ခဲ့လျှင် ၊ ကျွန်ုပ် သား နှစ် ယောက်တို့ကိုသတ် ပါလော့။ သူ့ ကိုကျွန်ုပ် လက် ၌ အပ် ပါ။ ကျွန်ုပ်တဖန် အဘ ထံ သို့ပြန် ၍ ဆောင်ခဲ့ပါမည်ဟု အဘ အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","အဘကလည်း၊ သင် တို့နှင့်အတူ ငါ့ သား မ သွား ရ။ သူ ၏အစ်ကို သေ ပြီ။ သူ သည် တယောက် တည်း ကျန်ရစ် ၏။ သင်တို့သွား ရာလမ်း ခရီးတွင် သူ ၌ ဘေး ရောက် လျှင် ၊ သင်တို့သည် ငါ့ ဆံပင် ဖြူကို ဝမ်းနည်း ခြင်းနှင့်တကွ မရဏာ နိုင်ငံသို့ သက်ရောက် စေကြလိမ့်မည်ဟု ဆို လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ခါနာန်ပြည် ၌ အလွန် အစာခေါင်းပါး သည် ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","အဲဂုတ္တု ပြည်မှ ဆောင် ခဲ့သောစပါး ကို စား ကုန် ပြီးမှ၊ အဘ က၊ တဖန်သွား ၍ ငါ တို့စား စရာအနည်း ငယ်ကို ဝယ် ကြပါဦးဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ယုဒ ကလည်း၊ ထိုသူ သည် ကျွန်ုပ် တို့ကို ကျပ်ကျပ်ခြိမ်းချောက် လျက်၊ သင် တို့ညီ မ ပါ လျှင် ငါ့ မျက်နှာ ကို မ မြင် ရဟု ပြော ထားပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ကျွန်ုပ် တို့ညီ ကို ထည့် လျှင် သွား ၍ အဘ စား ဘို့ရာ ဝယ် ပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ညီကို မ ထည့် လျှင် မသွား ပါ၊ အကြောင်း မူကား၊ ထိုသူ က သင် တို့ညီ မ ပါ လျှင် ငါ့ မျက်နှာ ကို မ မြင် ရဟု ပြော ထားပြီဟု အဘအား ပြန်ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ဣသရေလ ကလည်း ၊ သင် တို့၌ ညီ ရှိမှန်းကို ထိုသူ အား ပြော ၍ အဘယ်ကြောင့် ငါ့ ကို ညှဉ်းဆဲ ကြ သနည်းဟုဆိုသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","သူတို့က၊ ထိုသူ သည် ကျွန်ုပ် တို့၏အကြောင်း အရာ အမျိုးအနွယ် တို့ကို ကျပ်ကျပ်မေး လျက် ၊ သင် တို့အဘ အသက် ရှင်သေး သလော၊ ညီ ရှိ သေးသလောဟုမေးသောအခါ၊ ကျွန်ုပ်တို့သည် သူ ၏စကား သဘောသို့ လိုက်၍ ပြန် ပြောရပါ၏။ သင် တို့ညီ ကို ဆောင် ခဲ့ကြဟု သူပြော မည် ကို ကျွန်ုပ်တို့သည် အမှန်သိ နိုင်ပါသလောဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ယုဒ ကလည်း၊ သူငယ် ကို ကျွန်ုပ် နှင့်အတူ လွှတ် ပါ။ သို့ပြုလျှင်အဘမှစ၍ကျွန်ုပ် တို့နှင့် သူငယ် များတို့ သည် မ သေ ၊ အသက် ရှင်မည်အကြောင်း ၊ ကျွန်ုပ်တို့ ထ ၍ သွား ကြပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ကျွန်ုပ်သည် သူ ၏အာမခံ ဖြစ်ပါမည်။ ကျွန်ုပ် တွင် သူ့ ကို တောင်း ပါ။ သူ့ ကိုပြန်၍မ ဆောင် အဘ ရှေ့ မှာ မထား လျှင် ၊ အစဉ် မပြတ်အပြစ် ကိုခံ ပါစေ။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ဤမျှလောက်မ ဖင့်နွှဲ့ လျှင်၊ အကယ်၍ ဒုတိယ အကြိမ်တွင် ပြန် ရောက်ပါပြီဟု အဘ ဣသရေလ အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","အဘ ဣသရေလ ကလည်း၊ သို့ဖြစ်လျှင် ဤသို့ ပြု ကြလော့။ ထိုသူ အား ဆက် စရာဘို့ သင် တို့အိတ် ဝတို့တွင် ခါနာန်ပြည် ၏ အသီးမျိုးအကောင်းဆုံး တည်းဟူသောဗလစံစေး အနည်းငယ် ၊ ပျားရည် အနည်းငယ် ၊ နံ့သာ မျိုး၊ မုရန်စေး ၊ သစ်အယ်သီး ၊ ဗာတံသီး တို့ကို ယူ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","သင် တို့လက် ၌ ငွေ နှစ်ဆ ကိုလည်း ယူ ကြလော့။ အိတ် ဝ တွင် ဆောင် ခဲ့သောငွေ ကို တဖန်လက် ၌ ဆောင် သွား ကြဦးလော့။ ထို အမှုသည် သတိ လစ်သောအမှု ဖြစ် ဟန်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","သင် တို့ညီ ကိုလည်း ယူ ၍ တဖန် ထိုသူ ထံ သို့ ထ သွား ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ထိုသူသည် သင် တို့အစ်ကိုတယောက်နှင့် ဗင်္ယာမိန် ကို လွှတ် လိုက်မည်အကြောင်း ၊ သင်တို့သည် သူ့စိတ်နှင့်တွေ့ရသောအခွင့်ကို အနန္တ တန်ခိုးရှင်ဘုရား သခင် ပေး တော်မူပါစေသော။ သို့ရာတွင် ငါ သည် သား ဆုံးခြင်းကိုခံရလျှင် ခံရတော့မည်ဟု သားတို့အား ဆိုသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","သူ တို့သည် ထိုလက်ဆောင် ကို၎င်း၊ မိမိ လက် ၌ ငွေ နှစ် ဆကို၎င်း ၊ ဗင်္ယာမိန် ကို၎င်း ၊ ယူ ၍ထ ပြီးလျှင် ၊ အဲဂုတ္တု ပြည်သို့သွား ၍ ယောသပ် ရှေ့မှာ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","သူ တို့နှင့်အတူ ဗင်္ယာမိန် ပါလာသည်ကို ယောသပ် မြင် လျှင် ၊ ဝန် စာရေးကိုခေါ် ၍ ၊ ဤသူ တို့ကို အိမ် သို့ ခေါ် သွားလော့။ အကောင် များကိုသတ် ၍ စားစရာကို ပြင်ဆင် လော့။ သူတို့သည် ငါ နှင့်အတူ မွန်းတည့် စာကို စား ရကြလိမ့်မည်ဟု မှာ ထားသည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ဝန် စာရေးပြု ၍ ၊ သူ တို့ကို ယောသပ် အိမ် သို့ ခေါ် သွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ယောသပ် အိမ် သို့ ခေါ်သွား သောအခါ ၊ သူတို့ သည် ငါ တို့အိတ် ၌ ယမန် ပြန်ပေး သောငွေ ကြောင့် ခေါ်သွင်းပြီ။ သူသည်အမှုရှာလိမ့်မည်။ ငါတို့ကို အပြစ်ပြု သဖြင့် ကျွန်ခံ စေ၍ ၊ မြည်း တို့ကို သိမ်း လိမ့်မည်ဟု ဆို ကြပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ယောသပ် ၏ ဝန်စာရေး အနီးသို့ ချဉ်းကပ် ၍ အိမ် တံခါး နားမှာ နှုတ်ဆက် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","သခင် ၊ ယမန် က အကျွန်ုပ် တို့သည် အစာ ကို ဝယ် ခြင်းငှါ အမှန်လာ ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","စားခန်း သို့ ရောက် ၍ အိတ် များကိုဖွင့် သောအခါ ၊ လူ တိုင်းဆိုင်သောငွေ သည် အလျှင်းမလျော့ဘဲ အိတ် ဝ တွင် ရှိပါ၏။ ထို ငွေ ကို တဖန် ဆောင် ခဲ့ကြပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ယခုလည်းအစာ ကို ဝယ် ခြင်းငှါ အခြား သော ငွေ ကို ကိုယ် ၌ ဆောင် ခဲ့ကြပါ၏။ ထိုငွေ ကို အကျွန်ုပ် တို့ အိတ် များ၌ အဘယ်သူ ထား သည်ကို မ သိ နိုင်ပါဟု ဆို ကြသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ဝန်စာရေးက၊ ချမ်းသာ ပါစေ၊ မ စိုးရိမ် ကြနှင့်။ သင် တို့ဘုရားသခင် ၊ သင် တို့၏အဘ ဘုရားသခင် သည် သင် တို့အိတ် များ၌ ဘဏ္ဍာ ကိုသနား တော်မူပြီ။ သင် တို့ငွေ ကို ငါ ခံရ ပြီဟုဆို သဖြင့် ၊ ရှိမောင် ကိုထုတ် ၍ အပ်လိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ယောသပ် အိမ် သို့ သွင်းပြီးမှ ၊ ဝန်စာရေးသည် ရေ ကို ပေး ၍ ခြေ ဆေး စေ၏။ မြည်း တို့ကိုလည်း ကျွေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","မွန်းတည့် ချိန်၌ ယောသပ် လာ လိမ့်မည်ဟု သူတို့သည် မြော်လင့်၍ လက်ဆောင် ကို ပြင် နှင့်ကြ၏။ ထိုအိမ်၌ သူတို့သည် အစာ ကိုစား ရလိမ့်မည်ဟု သူတို့ သည် ကြား လေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ယောသပ် သည် အိမ် သို့ ရောက် သောအခါ ၊ သူတို့သည် ကိုယ် ၌ ပါ သောလက်ဆောင် ကို အိမ် ထဲ ယောသပ် ထံ သို့သွင်း ၍ သူ့ရှေ့ မှာဦးညွှတ် ချလျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ယောသပ်သည် နှုတ်ဆက်ပြီးလျှင်၊ သင် တို့အဘ တည်းဟူသောသင်တို့အရင်ပြော သော အသက်ကြီး သူ သည် ကျန်းမာ ပါ၏လော။ အသက် ရှင်သေး၏လောဟု မေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","သူတို့က၊ ကိုယ်တော် ကျွန် ၊ ကျွန်တော် တို့အဘ သည် ကျန်းမာ ပါ၏၊ အသက် ရှင်ပါသေး၏ဟု လျှောက် လျက်၊ ဦးညွှတ် ချ၍ ရှိခိုးလျက် နေကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ထိုအခါ ယောသပ် သည် မြော် ကြည့် ၍ မိမိ အမိ ၏သား ၊ မိမိ ညီ ရင်းဗင်္ယာမိန် ကိုမြင် လျှင် ၊ ဤ သူကား သင်တို့အရင်ပြော သော သင် တို့ညီ ဖြစ်သလောဟုမေး လျက်၊ သင့် ကို ဘုရားသခင် ကယ် မသနားတော်မူပါစေသော ငါ့ သား ဟု ဆို ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ညီ ရင်းကိုမြင်ရ၍ ကြင်နာ သောစိတ် ရှိသောကြောင့် အလျင်အမြန် ထသွား လေ၏။ ငို ရာအရပ်ကို ရှာ သဖြင့် ၊ အိပ် ခန်းထဲ သို့ဝင် ၍ ငို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","တဖန် မျက်နှာ ကိုသစ် ၍ ဣန္ဒြေချုပ်တည်း လျက် ပြင်သို့ထွက် ပြီးလျှင် ၊ စားပွဲ ကို ပြင် ကြဟု အမိန့် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ယောသပ်ဘို့တပွဲ၊ အစ်ကိုတို့ဘို့တပွဲ၊ ယောသပ် နှင့် စား သော အဲဂုတ္တု လူတို့ ဘို့တပွဲ အသီးအသီးတို့ကို ပြင် ကြ၏။ အဲဂုတ္တု လူတို့သည် ဟေဗြဲ လူတို့နှင့်အတူ မ စား ရ၊ ထို အမှုကို အဲဂုတ္တု လူတို့သည် ရွံ့ တတ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ညီအစ်ကိုတို့သည် အကြီး မှစ၍ အငယ် တိုင်အောင်အရွယ် အလိုက် ယောသပ် ရှေ့ မှာ ထိုင် နေကြ၏။ သူတို့သည် အချင်းချင်း ကြည့်ရှု၍ အံ့ဩ ခြင်းရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ယောသပ်သည်လည်း သူ တို့စားရန်အဘို့ အသီးအသီး တို့ကို မိမိ ထံ မှပေး လိုက်၏။ ဗင်္ယာမိန် ရသောအဘို့ သည် အစ်ကို တို့ရသောအဘို့ ထက် ငါး ဆ များ သတည်း။ သူတို့သည်သောက် ၍ ပျော်မွေ့ ခြင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ယောသပ်သည်လည်း ဝန်စာရေး ကို ခေါ် ၍ ထိုသူ တို့အိတ် များ၌ ရိက္ခါ ပါနိုင် သမျှ အပြည့် ထည့် လော့။ လူတိုင်း ဆိုင်သောငွေ ကို မိမိ တို့အိတ် ဝ တွင် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","စပါးအဘိုးငွေ နှင့် ငါ ငွေဖလား ကို၊ အငယ်ဆုံး သောသူ ၏အိတ် ဝ တွင် ၎င်း ထည့် ထားလော့ဟု မှာ သည် အတိုင်း ဝန်စာရေးပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","နံနက် မိုဃ်းလင်း သောအခါ ၊ ထိုသူ တို့ကို မြည်း များနှင့်တကွ လွှတ် လိုက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","မြို့ ပြင်သို့ရောက် ၍ မ ဝေး သေးသောအခါ ၊ ယောသပ် သည် ဝန်စာရေး ကို ခေါ် ၍၊ ထိုသူ တို့ကို မြန်မြန်လိုက် လော့။ မှီ သောအခါ သင်တို့သည် ကျေးဇူး ကို မကောင်း သောအမှုနှင့် အဘယ်ကြောင့် ဆပ် ကြသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ငါ့ သခင် သောက် သော ဖလား မ ဟုတ်လော။ ထူးဆန်းသော ဉာဏ်ကိုဖြစ်စေတတ်သော ဖလားမဟုတ် လော။ သင်တို့ပြု သောဤအမှု သည် မ ကောင်းပါတကား ဟု ပြောဆိုလော့ဟု မှာသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ဝန်စာရေးလိုက်၍ မှီ သောအခါ ပြော ဆိုလေ၏။ သူ တို့က လည်း ဤ စကား ကို သခင် သည် အဘယ်ကြောင့် ပြော ပါသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ကိုယ်တော် ကျွန် တို့နှင့် ထို သို့သော အမှု ဝေး ပါ စေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ယမန်ကအိတ် ဝ တွင် တွေ့ သောငွေ ကို၊ ခါနာန် ပြည် မှ ကိုယ်တော် ထံ သို့တဖန်ဆောင် ခဲ့ပါပြီ။ သို့ဖြစ်လျှင်ကိုယ်တော် ၏သခင် အိမ် ၌ ရွှေ ငွေ ကို အဘယ်ကြောင့် ခိုး ရပါအံ့နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ကိုယ်တော် ၏ကျွန် တို့တွင် မည် သူ၌ တွေ့ လျှင်၊ ထိုသူကိုသေ စေ။ ကျွန်တော် တို့သည်လည်း သခင် ၏ကျွန် ခံ ကြပါမည်ဟု ဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ဝန်စာရေးကလည်း၊ သင် တို့စကား အတိုင်း ဖြစ်စေ။ သို့သော်လည်းမည် သူ၌ တွေ့ လျှင်၊ ထိုသူ သည် ငါ့ ကျွန် ဖြစ်စေ။ သင် တို့မူကား အပြစ် လွှတ်ကြ စေဟု ဆိုသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ထိုသူအပေါင်းတို့သည် အသီးအသီး မိမိ တို့အိတ် များကို မြေ ၌ ချ ၍ ဖွင့် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ဝန်စာရေးသည်လည်၊ အကြီး မှ စ ၍ အငယ် တိုင်အောင် ရှာ သဖြင့် ဗင်္ယာမိန် အိတ် ၌ ဖလား ကိုတွေ့ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ထိုအခါ သူတို့သည် မိမိ အဝတ် ကိုဆုတ် ၍ လူ တိုင်းမိမိ မြည်း ပေါ် မှာ ဝန် ကို တင်ပြန်သဖြင့် မြို့ သို့ ပြန် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ယုဒ နှင့် ညီအစ်ကို တို့သည် ယောသပ် အိမ် သို့ ရောက် ၍ ၊ သူ သည်အိမ် ၌ရှိ သေးသဖြင့် ၊ သူ့ ရှေ့ မှာ ပြပ်ဝပ် လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ယောသပ် ကလည်း၊ သင်တို့သည် အဘယ်သို့ ပြု ပြီးသနည်း။ ငါ ကဲ့သို့ သောယောက်ျား သည် ထူးဆန်း သောဉာဏ်ရှိကြောင်း ကို သင်တို့မ သိ ကြသလောဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ယုဒ ကလည်း ၊ ကျွန်တော် တို့သည် သခင် အား အဘယ် စကားဖြင့် လျှောက် ရပါအံ့နည်း။ အဘယ်သို့ ပြော ရပါအံ့နည်း။ ဤအမှုနှင့် အဘယ်သို့ လွတ် နိုင်ပါအံ့နည်း။ ကိုယ်တော် ကျွန် တို့၏အပြစ် ကို ဘုရားသခင် စစ်၍ တွေ့ တော်မူပြီ။ အကြင်သူ ၌ ဖလား တော်ကိုတွေ့ ၏။ ထို သူမှစ၍ ကျွန်တော် တို့ ရှိသမျှသည် သခင် ၏ ကျွန် ဖြစ်ကြပါ၏ဟု လျှောက် လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ထိုသို့ငါမပြုရ။ အကြင်သူ ၏လက် ၌ ငါ့ဖလား ကို တွေ့ ၏။ ထိုသူ သည် ငါ့ ကျွန် ဖြစ်စေ။ သင် တို့မူကား အဘ ထံ သို့ငြိမ်ဝပ် စွာသွား ကြလောဟု စီရင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ထိုအခါ ယုဒ သည်ချဉ်းကပ်လျက်၊ သခင် ဘုရား၊ ကိုယ်တော် ကျွန် သည် စကား တခွန်းဖြင့် နား တော်လျှောက် ရသောအခွင့်ကိုပေး တော်မူပါ။ ကိုယ်တော် ကျွန် ၌ အမျက် ထွက် တော်မ မူပါနှင့်။ ကိုယ်တော် သည် ဖါရော ဘုရင်ကဲ့သို့ ဖြစ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","သခင် က၊ သင် တို့သည် အဘ ရှိသလော။ ညီ ရှိ သလောဟု ကျွန်တော် တို့အား မေး တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ကျွန်တော်တို့က၊ ကျွန်တော် တို့အဘ အသက် ကြီး သောသူရှိပါ၏။ အဘအသက် ကြီးစဉ်အခါ ရသောသား ငယ် တယောက်ရှိ ပါ၏။ သူ ၏အစ်ကို သေ ပါပြီ။ သူ့ အမိ ဘွားသောသားတို့တွင် သူတယောက်တည်း ကျန်ရစ် ပါ၏။ ထိုကြောင့်သူ ၏အဘ သည် သူ့ ကို ချစ် ပါ၏ဟု သခင် အား ပြန်လျှောက် လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ကိုယ်တော်က၊ ထိုသူ ကို ငါ ကြည့်ရှု ရ အောင် ငါ့ ထံ သို့ခေါ် ခဲ့ကြဟု ကိုယ်တော် ကျွန် တို့အား မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ကျွန်တော် တို့က ထိုသူငယ် ကို အဘ နှင့်မ ခွါ နိုင် ပါ။ အဘ နှင့်ခွါ လျှင် အဘသေ ပါလိမ့်မည်ဟု သခင် အား လျှောက် လေသော်လည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ကိုယ်တော်က၊ သင် တို့ညီ မ ပါ လျှင် သင်တို့သည် ငါ့ မျက်နှာ ကိုနောက် တဖန်မ မြင် ရဟု ကိုယ်တော် ကျွန် တို့ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ထိုနောက် ကျွန်တော်တို့သည် ကိုယ်တော် ကျွန် တည်းဟူသောကျွန်တော် တို့ အဘ ထံ သို့ပြန်၍ ရောက် သောအခါ ၊ သခင် စကား တော်ကို အဘ အား ပြန် ကြားပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ကျွန်တော် တို့အဘ ကလည်း ၊ တဖန်သွား ၍ ငါ တို့ စားစရာ အနည်းငယ် ကို ဝယ် ကြပါဟုဆို သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ကျွန်တော်တို့က၊ အကျွန်ုပ်တို့သည် မ သွား နိုင် ပါ။ ညီ ပါ လျှင် သွား နိုင်ပါ၏။ ညီ မ ပါ လျှင် ထိုသူ ၏ မျက်နှာ ကိုမ မြင် ရ ပါဟု ပြန်ပြော ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ကိုယ်တော် ကျွန် ၊ ကျွန်တော် အဘ ကလည်း ၊ သင် တို့သိ သည့်အတိုင်း ငါ့ မယား သည် ငါ့ အား သား နှစ် ယောက်ကို ဘွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","တ ယောက်ကား ငါ့ ထံ မှ ထွက်သွား ၏။ အကယ် စင်စစ်သူသည် အပိုင်းအပိုင်း ကိုက် ဖြတ်ခြင်းကိုခံရပါပြီ တကားဟု ငါဆို ရ၏။ ထိုကာလမှစ၍သူ့ ကိုငါမ မြင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ဤ သူကိုလည်း ငါ့ ထံ မှယူ သွား၍ သူ ၌ဘေး ရောက် လျှင် ၊ သင်တို့သည် ငါ့ ဆံပင် ဖြူကို ဝမ်းနည်း ခြင်း နှင့်တကွ မရဏာ နိုင်ငံသို့ သက်ရောက် စေကြလိမ့်မည်ဟု ကျွန်တော် တို့အား ဆို ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","သို့ဖြစ်၍ ကျွန်တော်သည် ကိုယ်တော် ကျွန် ၊ ကျွန်တော် အဘ ထံ သို့ရောက် သောအခါ ၊ သူငယ် မ ပါ လျှင် အဘ ၏အသက် သည် သူငယ် ၏အသက် ၌ မှီ လျက်ရှိသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","သူငယ် မ ရှိသည်ကို မြင် သောအခါ အဘသေ ပါလိမ့်မည်။ ကိုယ်တော် ကျွန် တို့သည်၊ ကိုယ်တော် ကျွန် တည်းဟူသောကျွန်တော် တို့အဘ ဆံပင် ဖြူကို ဝမ်းနည်း ခြင်းနှင့်တကွ မရဏာ နိုင်ငံသို့ သက်ရောက် စေကြပါ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ကိုယ်တော် ကျွန် က၊ အကျွန်ုပ် သည် တဖန် သူငယ် ကို အဘ ထံ သို့ ပြန်၍မ ဆောင် ခဲ့လျှင် ၊ အစဉ်မပြတ် အဘ ရှေ့ မှာ အပြစ် ကိုခံပါစေဟုဆို သဖြင့် ၊ အဘ ထံ မှာ သူငယ် ၏အာမခံ ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","သို့ဖြစ်၍ ကိုယ်တော် ကျွန် သည် သူငယ် အတွက် နေရစ် ၍ သခင် ထံ ကျွန် ခံရသောအခွင့်၊ သူငယ် ကိုကား အစ်ကို တို့နှင့်အတူ သွား ရသောအခွင့်ကိုပေး တော်မူပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","သူငယ် သည် ကျွန်တော် တို့၌ မ ပါလျှင်၊ ကျွန်တော် အဘ ထံ သို့ အဘယ်သို့ ကျွန်တော်သွား နိုင်ပါမည်နည်း။ သို့ပြုလျှင် ကျွန်တော် အဘ ၌ ရောက် လတံ့သော ဘေးဥပဒ် ကို ကျွန်တော်မြင် ရပါလိမ့်မည်တကားဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ထိုအခါ ယောသပ် သည် မိမိ ထံ ၌ရှိ သောသူအပေါင်း တို့ရှေ့ တွင်၊ ဣန္ဒြေကို မ ချုပ်တည်း နိုင် သောကြောင့် ၊ လူ အပေါင်း တို့ငါ့ ထံ မှ ထွက် သွားကြဟု ဟစ် ၍ မိမိဇာတိ အဖြစ်ကို အစ်ကို တို့အား ပြသောအခါ ၊ အခြား သော သူတယောက်မျှ မ ရှိရ။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","သူ သည်လည်း ကျယ် သောအသံ နှင့် ငိုကြွေး ၏။ အဲဂုတ္တု လူတို့သည် နန်းတော် တိုင်အောင်ကြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","အစ်ကို တို့အား လည်း ၊ ကျွန်ုပ် ယောသပ် ဖြစ်၏။ ကျွန်ုပ် အဘ သည် အသက် ရှင်သေး သလောဟုဆို ၏။ အစ်ကို တို့သည် စကားတုံ့ပြန်၍ မ ပြော နိုင် အောင် သူ့ ရှေ့ မှာ မိန်းမော တွေဝေလျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ယောသပ် ကလည်း ၊ ကျွန်ုပ် အနီးအပါးသို့ လာ ကြ ပါလော့ဟု အစ်ကိုတို့အားဆိုလျှင်၊ သူတို့သည် အနီးအပါး သို့ ချဉ်း လာကြ၏။ သူ ကလည်း ကျွန်ုပ် သည် အဲဂုတ္တု ပြည် သို့ ရောင်း လိုက်သော သင် တို့ညီ ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","သို့ရာတွင် သင် တို့သည် ကျွန်ုပ် ကို ဤ အရပ်သို့ ရောင်း လိုက်မိသောကြောင့် စိတ် မ ညှိုးငယ်ကြနှင့်။ ကိုယ်ကိုအမျက် မ ထွက်ကြနှင့်။ အကြောင်း မူကား၊ ဘုရားသခင် သည် လူတို့အသက် ကို စောင့်မစေခြင်းငှါ သင် တို့ရှေ့ မှာ ကျွန်ုပ် ကိုစေလွှတ် တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","မြေ ပေါ် မှာ နှစ် နှစ်အစာခေါင်းပါး ခဲ့ပြီ။ လယ်လုပ် ခြင်း၊ စပါး ရိတ်ခြင်းကို မ ပြုရသောနှစ် ငါး နှစ် ရှိ သေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ဘုရားသခင် သည် သင် တို့ကို မြေကြီး ပေါ် မှာ ကျန်ကြွင်း စေခြင်းငှါ ၎င်း၊ ကြီး စွာသော ကယ်တင် ခြင်း အားဖြင့် သင် တို့အသက် ကို ချမ်းသာစေခြင်းငှါ ၎င်း၊ သင် တို့ရှေ့ မှာ ကျွန်ုပ် ကို စေလွှတ် တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","သို့ဖြစ်၍ သင် တို့သည် ကျွန်ုပ် ကိုဤ အရပ်သို့ စေလွှတ် သည်မ ဟုတ်၊ ဘုရားသခင် စေလွှတ်တော်မူသတည်း။ ကျွန်ုပ် ကို ဖါရော ဘုရင်၏ အဘ အရာ၌ ၎င်း၊ နန်းတော် အုပ် အရာ၌ ၎င်း၊ အဲဂုတ္တု ပြည် လုံး ကို အုပ်စိုး သောသခင် အရာ၌၎င်း ခန့် ထားတော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","အလျင်အမြန် ထ၍ အဘ ထံ သို့ သွား ကြလော့။ အဘ အား လည်း ၊ သား ယောသပ် က၊ ဘုရားသခင် သည် ကျွန်ုပ် ကို အဲဂုတ္တု ပြည်လုံး သခင် ဖြစ် စေတော်မူပြီ။ ကျွန်ုပ် ထံ သို့လာ ပါ၊ မ ဆိုင်း ပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","အဘသည် ဂေါရှင် အရပ် ၌ နေ ရမည်။ ကျွန်ုပ် အနား မှာ ရှိ ရမည်။ အဘ မှစ၍ သား မြေး ၊ သိုး ၊ နွား နှင့်တကွ ရှိသမျှ ပါရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ထို အရပ်၌ ကျွန်ုပ်ကျွေးမွေး ပါမည်။ သို့မဟုတ်အဘ မှစ၍ အိမ်သူ အိမ်သားနှင့်တကွ ရှိသမျှ တို့ သည် ဆင်းရဲခြင်း သို့ ရောက်ကြလိမ့်မည်။ အစာ ခေါင်းပါး သောနှစ် ငါး နှစ်ရှိ သေးသည်ဟု ပြောကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ကျွန်ုပ် သည် ကိုယ်တိုင်သင် တို့နှင့် နှုတ်ဆက် သည်ကို ၊ သင် တို့မျက်စိ ၊ ကျွန်ုပ် ညီ ဗင်ယာမိန် မျက်စိ အမြင် သားဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","အဲဂုတ္တု ပြည်၌ ကျွန်ုပ် ရသောဘုန်း စည်းစိမ်းမှစ၍ သင်မြင် သမျှ တို့ကို အဘ အား ပြော ရမည်။ အလျင်အမြန် ပြု၍ အဘ ကို ဤ ပြည်သို့ ဆောင် ခဲ့ရမည်ဟု ဆိုပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ညီ ဗင်္ယာမိန် လည်ပင်း ကို ဘက် ၍ ငို လေ၏။ ဗင်္ယာမိန် သည်လည်း သူ ၏လည်ပင်း ၌ ငို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","တဖန် အစ်ကို ရှိသမျှ တို့ကို နမ်း ၍ သူ တို့နှင့် ငို သော နောက် အချင်းချင်း နှုတ်ဆက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ယောသပ် အစ်ကို တို့သည် ရောက် လာကြပြီဟု နန်းတော် ၌ သိတင်း ကြား ၍ ၊ ဖာရော ဘုရင် အစ ရှိသော ကျွန် တော်မျိုးတို့သည် နှစ်သက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ဖါရော ဘုရင်သည်လည်း ယောသပ် ကိုခေါ် ၍၊ သင် ၏အစ်ကို တို့အား အဘယ်သို့ပြော ရမည်နည်းဟူမူကား၊ သင်တို့သည် ဤသို့ ပြု ကြလော့။ မြည်း တို့ကို ဝန် တင်၍ ခါနာန် ပြည် သို့ ပြန် သွား သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","သင် တို့အဘ နှင့် အိမ်သူ အိမ်သားတို့ကိုယူ ၍ ကျွန်ုပ် ထံ သို့လာ ကြလော့။ အဲဂုတ္တု ပြည် ၏စည်းစိမ်း ကို ငါပေး ၍ ၊ သင် တို့သည် မြေဩဇာ ကိုသာ စား ရကြ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","အမိန့် တော်ရှိသည်ဖြစ်၍ ဤသို့ ပြု ကြလော့။ သင် တို့မိန်းမ များ၊ သူငယ် များဘို့ ၊ အဲဂုတ္တု ပြည် ထဲ က လှည်း တို့ကို ယူ ပြီးလျှင် အဘ ကိုဆောင် ၍ လာ ခဲ့ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","သင် တို့ဥစ္စာများကို မ နှမြော ကြနှင့်။ အဲဂုတ္တု ပြည် ၏ စည်းစိမ် ရှိသမျှ သည် သင် တို့ဥစ္စာ ဖြစ်၏ဟု အမိန့် တော်ရှိသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ဣသရေလ ၏ သား တို့သည်ပြု ၍ ၊ ယောသပ် သည် လှည်း တို့ကို၎င်း၊ လမ်း ခရီး၌ စားစရိတ် များကို၎င်း ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","အစ်ကို ရှိသမျှ တို့အား လည်း အဝတ် လဲ စရာဘို့ ပေး ၏။ ဗင်္ယာမိန် အား လည်း ၊ ငွေ အကျပ်သုံး ရာ နှင့် အဝတ် လဲစရာဘို့ အဝတ် ငါး စုံ ကို ထပ်၍ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","အဘ အား လည်း အဲဂုတ္တု ပြည်၏ ကောင်း သောအရာတို့ကို ဆောင် သော မြည်း တဆယ် ၊ လမ်း ခရီး၌ အဘ စားစရာ ဘို့ စပါး ၊ မုန့် ၊ ခဲဘွယ်စားဘွယ်များကို ဆောင် သောမြည်း တဆယ် ကိုပေး လိုက်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","သင်တို့သည် လမ်း ၌ ရန် မ တွေ့ကြနှင့်ဟု မှာ ထားလျက် အစ်ကို တို့ကို လွှတ် လိုက်၍ သူတို့သည် သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ထိုသို့ အဲဂုတ္တု ပြည်မှ ထွက်သွား ၍ ၊ ခါနာန် ပြည် အဘ ယာကုပ် ထံ သို့ရောက် ကြလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ယောသပ် သည် အသက် ရှင်သေး ၏။ အဲဂုတ္တု ပြည် လုံး ကို အုပ်စိုး ရ၏ဟု ကြား ပြောကြသည်ရှိသော် ၊ ယာကုပ် သည် စိတ် နှလုံးလျော့ ၏။ သူ တို့စကားကို မ ယုံ နိုင်။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","သူ တို့သည်လည်း ယောသပ် ပြော သမျှ သော စကား တို့ကို ပြန် ပြောကြ၏။ အဘ ယာကုပ် သည် မိမိ စီး စရာဘို့ ယောသပ် ပေး လိုက်သော လှည်း တို့ကို မြင် သောအခါ စိတ် နှလုံးအားဖြည့် ပြန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ဣသရေလ ကလည်း ၊ တန် တော့။ ငါ့ သား ယောသပ် အသက် ရှင်သေး ၏။ ငါမ သေ မှီ သူ့ ကိုသွား ၍ ကြည့် မည်ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ထိုအခါ ဣသရေလ သည် မိမိ ဥစ္စာရှိသမျှ နှင့်တကွ ခရီး သွား၍ ဗေရရှေဘ အရပ်သို့ ရောက် လျှင် ၊ မိမိ အဘ ဣဇာက် ၏ ဘုရား သခင်အား ယဇ် ပူဇော် ခြင်းကို ပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ညဉ့် အခါ ဗျာဒိတ် တော်အားဖြင့် ဘုရား သခင်က၊ ယာကုပ် ၊ ယာကုပ် ဟုခေါ် တော်မူလျှင် ၊ ယာကုပ်က အကျွန်ုပ် ရှိ ပါသည်ဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ထာဝရဘုရားကလည်း၊ ငါ သည် ဘုရား သခင်ဖြစ်၏။ သင့် အဘ ၏ ဘုရား သခင်ဖြစ်၏။ အဲဂုတ္တု ပြည်သို့ သွား ရမည်အခွင့်ကို မ စိုးရိမ် နှင့်။ ငါသည် ထို ပြည်၌ သင့် ကို လူမျိုး ကြီး ဖြစ် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","အဲဂုတ္တု ပြည်သို့ သင် နှင့်အတူ ငါ သွား မည်။ တဖန် ငါ ဆောင် ခဲ့ဦးမည်။ ယောသပ် သည် မိမိ လက် ကို သင် ၏မျက်စိ ပေါ် မှာ တင် ရလိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","တဖန် ယာကုပ် သည် ဗေရရှေဘ အရပ်မှ ထွက် ၍ ၊ သူ စီး စရာဘို့ ဖါရော မင်းပေး လိုက်သော လှည်း တို့ဖြင့် ဣသရေလ ၏သား တို့သည် အဘ မှစ၍ မိန်းမ များနှင့် သူငယ် များတို့ကို ဆောင် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ခါနာန် ပြည် ၌ ရ သောတိရစ္ဆာန် များနှင့် ဥစ္စာ များကို လည်း ယူ ၍ အဲဂုတ္တု ပြည်သို့ သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ယာကုပ် သည် ကိုယ်တိုင်မှစ၍သားသမီးမြေးတည်းဟူသောအမျိုးအနွယ် အပေါင်း တို့ကို အဲဂုတ္တု ပြည် သို့ ဆောင် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","အဲဂုတ္တု ပြည်သို့ ရောက် သော ဣသရေလ သား တို့၏အမည် ကား ၊ ယာကုပ် နှင့် သူ ၏သား များ။ သား ဦးရုဗင်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ရုဗင် သား။ ဟာနုတ် ၊ ဖါလု ၊ ဟေဇရုံ ၊ ကာမိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ရှိမောင် သား။ ယေမွေလ ၊ ယာမိန် ၊ ဩဟဒ် ၊ ယာခိန် ၊ ဇောဟာ ၊ ခါနာန် အမျိုး မိန်းမ၏သား ရှောလ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","လေဝိ သား။ ဂေရရှုံ ၊ ကောဟတ် ၊ မေရာရိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ယုဒ သား။ ဧရ ၊ ဩနန် ၊ ရှေလ ၊ ဖါရက် ၊ ဇာရ။ ထိုသူ တို့တွင် ဧရ နှင့် ဩနန် သည် ခါနာန် ပြည် ၌ သေ သတည်း။ ဖါရက် သား ၊ ဟေဇရုံ နှင့် ဟာမုလ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ဣသခါ သား။ တောလ ၊ ဖုဝါ ၊ ယောဘ ၊ ရှိမရုန်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ဇာဗုလုန် သား။ သရက် ၊ ဧလုန် ၊ ယာလေလ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ဤသူတို့ကား၊ ယာကုပ် မယားလေအာ သည် ပါဒနာရံ အရပ်၌ ဘွား သော သား တည်း။ သမီး ဒိန နှင့်တကွ ၊ သား သမီး ပေါင်း သုံးဆယ် သုံး။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ဂဒ် သား။ ဇိဖျန် ၊ ဟဂ္ဂိ ၊ ရှုနိ ၊ ဧဇဗုန် ၊ ဧရီ ၊ အရောဒိ ၊ အရေလိ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","အာရှာ သား။ ယိမန။ ဣရွာ ၊ ဣရွှိ ၊ ဗေရိယ ၊ နှမ စေရ တည်း။ ဗေရိယ သား ၊ ဟေဗာ နှင့် မာလချေလ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ဤ သူတို့ကား၊ လာဗန် သည် သမီး လေအာ အား ၊ လက်ဖွဲ့ သော ယာကုပ် မယား ဇိလပ ဘွား သော သား တည်း။ ပေါင်းတဆယ် ခြောက်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ယာကုပ် မယား ရာခေလ သား။ ယောသပ် နှင့် ဗင်္ယာမိန်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","အဲဂုတ္တု ပြည် ၌ ဩန မြို့၏ ယဇ် ပုရောဟိတ်ပေါတိဖေရ သမီး အာသနတ် တွင် ယောသပ် နှင့် ရ သောသား၊ မနာရှေ နှင့် ဧဖရိမ်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ဗင်္ယာမိန် သား။ ဗေလ ၊ ဗေခါ ၊ အာရှဗေလ ၊ ဂေရ ၊ နေမန် ၊ ဧဟိ ၊ ရောရှ ၊ မုပိမ် ၊ ဟုပိမ် ၊ အာရဒ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ဤသူတို့ကား၊ ယာကုပ် မယား ရာခေလ ဘွား သောသား တည်း။ ပေါင်း တဆယ် လေး။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ဒန် သား။ ဟုရှိမ်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","နဿလိ သား။ ယာဇေလ ၊ ဂုနိ ၊ ယေဇာ ၊ ရှိလင်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ဤသူတို့ကား၊ လာဗန် သည် သမီး ရာခေလ အား လက်ဖွဲ့ သော ယာကုပ် မယား ဗိလဟာ ဘွား သော သား တည်း။ ပေါင်း ခုနစ် ");
INSERT INTO myajvb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ယာကုပ် ချွေးမ များကို မ ဆိုဘဲ၊ ယာကုပ် မှ ဆင်း သက်၍၊ သူနှင့်အတူအဲဂုတ္တု ပြည်သို့ သွား သော လူ ပေါင်း ကား၊ ခြောက်ဆယ် ခြောက် ယောက်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","အဲဂုတ္တု ပြည်၌ ယောသပ် ရ နှင့်သော သား နှစ် ယောက်ရှိ၏။ သို့ဖြစ်၍အဲဂုတ္တု ပြည်သို့ ရောက် သော ယာကုပ် ၏အမျိုးသား အပေါင်း ကား ခုနစ် ဆယ်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ယောသပ် ထံ သို့ဂေါရှင် ပြည်ကို သွားစေခြင်းငှါ ယုဒ ကို အရင်စေလွှတ် ပြီးမှ ဂေါရှင် ပြည် သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ယောသပ် သည် ရထား ကိုပြင် ၍ အဘ ဣသရေလ ကို ခရီးဦးကြိုပြု ခြင်းငှါ ဂေါရှင် ပြည်သို့ သွား ၍ အဘ ရှေ့သို့ရောက် သော် ၊ အဘ ၏လည်ပင်း ကို ဘက် လျက် ကြာကြာ ငို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ဣသရေလ ကလည်း ၊ ယခု ငါသေ ပါစေသော။ သင် ၏မျက်နှာ ကို ငါ မြင် ရပြီ။ သင် သည် အသက် ရှင်သေး ၏ဟု ယောသပ် အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ယောသပ် ကလည်း၊ ဖါရော မင်းထံ သို့ကျွန်ုပ် သွား ဦးမည်။ ခါနာန် ပြည် ၌ နေသော ကျွန်တော် အစ်ကို များ၊ ကျွန်တော် အဘ ၏ အိမ်သား များတို့သည် ကျွန်တော် ထံ သို့ရောက် ကြပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ထိုသူ တို့သည် သိုး ထိန်း ဖြစ်ပါ၏။ သိုး နွားတို့ကို မွေး သောသူဖြစ် ပါ၏။ သူတို့သိုး နွား မှစ၍ ရှိသမျှ တို့ကို ဆောင် ခဲ့ကြပါပြီဟု လျှောက် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","နောက် တခါ သင် တို့ကို ဖါရော မင်းခေါ် ၍ သင် တို့သည် အဘယ်သို့ လုပ်ဆောင် တတ်သနည်းဟုမေး တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ကိုယ်တော် ကျွန် တော်တို့သည် ဘိုးဘေး နှင့်တကွ ၊ ငယ် သော အရွယ်မှစ၍ ယခု တိုင်အောင် သိုး နွားတို့ကို မွေး သောသူဖြစ် ကြပါ၏ဟု လျှောက် ရမည်။ သို့ဖြစ်၍ ဂေါရှင် ပြည် မှာ နေ သောအခွင့်ကို ရကြလိမ့်မည်။ သိုး ထိန်း ဖြစ်သောသူကို အဲဂုတ္တု လူတို့သည် ရွံရှာ တတ်ကြ၏ ဟု အစ်ကို များ အဘ ၏အိမ်သား များတို့ကို ပြော ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ထိုစကားအတိုင်း ယောသပ် သည် ဖါရော မင်းထံ သို့သွား ၍ ၊ ကျွန်တော် အဘ နှင့် အစ်ကို တို့သည် သိုး နွား၊ ဥစ္စာရှိသမျှ ကို ဆောင်လျက် ခါနာန် ပြည် ကရောက် လာ၍ ၊ ဂေါရှင် ပြည် ၌ ရှိကြပါသည်ဟု လျှောက် သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","အစ်ကို စု ထဲက ရွေး ၍ ငါး ယောက်တို့ကို အထံ တော်သို့သွင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ဖာရော မင်းကလည်း ၊ သင် တို့သည် အဘယ်သို့ လုပ်ဆောင် လေ့ရှိကြသနည်းဟုမေး လျှင်၊ သူတို့က၊ ကိုယ်တော် ကျွန် တို့သည် ဘိုးဘေး နှင့်တကွ သိုး ထိန်း ဖြစ်ကြပါ၏ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ခါနာန် ပြည် ၌ အလွန် အစာခေါင်းပါး ၍ သိုး နွား ကျက်စား ရာမ ရှိသောကြောင့် ၊ ကိုယ်တော် ကျွန် တို့သည် ပြည် တော်၌ တည်းခို ခြင်းငှါ လာ ကြပါ၏။ သို့ဖြစ်၍ ကိုယ်တော် ကျွန် တို့သည် ဂေါရှင် ပြည် ၌ နေ ရမည် အကြောင်းအခွင့်ပေးတော်မူပါဟူ၍၎င်း လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ဖါရော မင်းကလည်း ၊ သင် ၏အဘ နှင့် အစ်ကို တို့ သည် သင့် ထံ သို့ရောက် လာကြသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","အဲဂုတ္တု ပြည် သည် သင့် ရှေ့ မှာ ရှိ၏။ သင် ၏ အဘ နှင့် သင် ၏အစ်ကို တို့ကို အကောင်း ဆုံးသော အရပ် ဂေါရှင် ပြည် ၌ နေရာ ချလော့။ သူ တို့တွင် အစွမ်း သတ္တိ ရှိသောသူ အချို့တို့ကို တွေ့ လျှင် ငါ ၏သိုး နွားအုပ်အရာ ၌ ခန့်ထား လော့ဟု ယောသပ်အား မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ယောသပ် သည် အဘ ယာကုပ် ကို သွင်း ၍ ဖါရော မင်းရှေ့ မှာထား သဖြင့် ၊ ယာကုပ် သည် ဖါရော မင်း ကို ကောင်းကြီး ပေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ဖါရော မင်းက၊ သင် သည် အသက် အဘယ် မျှလောက် ရှိပြီနည်းဟု ယာကုပ် အား မေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ကျွန်တော် သည် ဧည့်သည် အာဂန္တုဖြစ်၍ လွန် သော အသက် သည် အနှစ်တရာ သုံး ဆယ်ရှိ ပါပြီ။ ကျွန်တော် အသက် ရှင် သော နှစ် ပေါင်းနည်း ၍ ဆိုး ပါ၏။ ဧည့်သည် အာဂန္တုဖြစ်သော ဘိုးဘေး တို့၏ အသက် တန်း ကို မ မှီ ပါဟု လျှောက် ဆိုပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ဖါရော မင်းကို ကောင်းကြီး ပေး၍ အထံ တော်က ထွက်သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ဖါရော မင်းအမိန့် တော်ရှိသည့်အတိုင်း ၊ ယောသပ် သည် အဘ နှင့် အစ်ကို တို့ကို နေရာ ချ၍ အဲဂုတ္တု ပြည် ၌ အကောင်း ဆုံးသောအရပ် ရာမသက် မြေ ကို အပိုင် ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","အဘ နှင့် အစ်ကို များ၊ အဘ ၏အိမ်သား ရှိသမျှ တို့ ကို အနည်း အများအလိုက် ကျွေးမွေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","အလွန် အစာခေါင်းပါး ၍ တပြည် လုံး စားစရာ မ ရှိသောကြောင့် ၊ အဲဂုတ္တု ပြည် နှင့် ခါနာန် ပြည် သည် အားလျော့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ပြည်သားဝယ် သော စပါး အဘိုး ၊ အဲဂုတ္တု ပြည် ၊ ခါနာန် ပြည် ၌ တွေ့ သမျှ သောငွေ ကိုယောသပ် စုသိမ်း ၍ နန်းတော် သို့ သွင်း ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","အဲဂုတ္တု ပြည် ၊ ခါနာန် ပြည် ၌ ငွေ ကုန် သောအခါ ၊ အဲဂုတ္တု လူအပေါင်း တို့သည် ယောသပ် ထံ သို့လာ ၍ စားစရာ ဘို့ ပေး သနားတော်မူပါ။ ကျွန်တော်တို့သည် ငွေ ကုန် သော်လည်း ရှေ့ တော်၌ အဘယ်ကြောင့် သေ ရပါအံ့နည်းဟု လျှောက်ကြသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ယောသပ် က၊ ငွေ ကုန် လျှင် တိရစ္ဆာန် များကိုပေး ကြ။ တိရစ္ဆာန် အတွက် စပါးကိုပေး မည်ဟုဆို သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","သူတို့သည် တိရစ္ဆာန် တို့ကိုယူ ခဲ့၍ ၊ ယောသပ် သည် မြင်း ၊ သိုး ၊ နွား ၊ မြည်း တို့အတွက် စပါးကိုပေး သဖြင့် ထို နှစ် တွင် တိရစ္ဆာန် ရှိသမျှ တို့အတွက် ပြည်သား များကို ကျွေးမွေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ထို နှစ် ကုန် ပြီးမှ ဒုတိယ နှစ် တွင် လာ ကြလျှင် ၊ ကျွန်တော်တို့ ငွေ ကုန် ကြောင်း ကို သခင် ရှေ့ မှာ မ ထိမ်ဝှက် ပါ။ ကျွန်တော်တို့ တိရစ္ဆာန် များကိုလည်း သခင် ရပါပြီ။ သခင် ရှေ့မှာ ကျွန်တော် တို့ကိုယ် နှင့် မြေ မှတပါး အဘယ် အရာမျှ မ ကျန် ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ရှေ့ တော်၌ အဘယ်ကြောင့် သေ၍ ပြည် တော် ပျက် ရပါအံ့နည်း။ အစာ ကို ပေး၍ကျွန်တော် တို့နှင့် ကျွန်တော် တို့မြေ ကို ဝယ် ပါ။ ကျွန်တော် တို့သည် မြေ နှင့်တကွ ဖါရော ဘုရင်၏ ကျွန် ခံ ပါမည်။ ကျွန်တော်တို့သည် မ သေ ၊ အသက် ရှင်စေခြင်းငှါ၎င်း၊ ပြည် တော်သည် လူမ ဆိတ်ညံ စေခြင်းငှါ၎င်း၊ မျိုးစေ့ ကိုပေး ပါဟု လျှောက်ကြသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ယောသပ် သည် အဲဂုတ္တု မြေ ရှိသမျှ ကို ဖါရော မင်းဘို့ ဝယ် လေ၏။ အစာခေါင်းပါး ၍ အဲဂုတ္တု လူတို့သည် မတတ်နိုင်သောကြောင့်၊ အသီးအသီး ပိုင်သော မြေ အကွက်တို့ကို ရောင်း ကြသဖြင့် မြေ သည် ဘဏ္ဍာ တော် ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","လူ တို့ကိုကား ၊ အဲဂုတ္တု ပြည် တစွန်း မှ သည် တစွန်း တိုင်အောင်မြို့ တို့သို့ ပြောင်း စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ယဇ်ပုရောဟိတ် တို့ ပိုင်သောမြေ ကိုကားမ ဝယ်။ သူတို့သည် ဖါရော မင်းကျွေးမွေး သည်အတိုင်း ကျွေးမွေး သော အစာ ကိုစား ရကြ၏။ ထိုကြောင့် မိမိ တို့မြေ ကို မ ရောင်း ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ယောသပ် ကလည်း ၊ သင် တို့နှင့် သင် တို့မြေ ကို ဖါရော မင်းဘို့ ယနေ့ ငါဝယ် ပြီ။ မျိုးစေ့ ကို ယူ၍ လယ် လုပ် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","အသီး အနှံကို ရ သောအခါ ၊ ငါး ဘို့တွင်တဘို့ကို ဖါရော မင်းအား ဆက် ရကြမည်။ လေး ဘို့ကိုကား သင် တို့ယူ ၍ နောက်တဖန်မျိုးစေ့ ကို ကြဲကြလော့။ သင် တို့စား ၍ အိမ် သားများ၊ သူငယ် များတို့ကို ကျွေး ကြလော့ဟု ပြည်သား တို့အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","သူတို့ကလည်း၊ ကိုယ်တော်သည် ကျွန်တော် တို့ အသက်ကို ကယ် ပါပြီ။ သနားသောစိတ် နှင့် ကြည့်ရှု တော်မူ ပါ။ ကျွန်တော်တို့သည် ဖာရော ဘုရင်၏ ကျွန် ခံ ရပါမည် ဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ထိုကြောင့်ဖါရော မင်းမ ပိုင်သော ယဇ်ပုရောဟိတ် တို့ မြေ ကိုထား၍၊ ဖါရော မင်းသည် ငါး ဘို့တွင် တဘို့ကိုပိုင်တော်မူစေဟု ယနေ့ တိုင်အောင်အဲဂုတ္တု ပြည် ၌တည်သော ဓမ္မသတ် ကို ယောသပ် စီရင် ၍ ထား သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ဣသရေလ သားတို့သည်၊ အဲဂုတ္တု ပြည် ဂေါရှင် အရပ် ၌ နေ သဖြင့် ၊ ဥစ္စာ ရတတ်၍ တိုး ပွါးများပြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ယာကုပ် သည် အဲဂုတ္တု ပြည် ၌ ဆယ် ခုနစ် နှစ် အသက် ရှင်၍ အသက် နှစ် ပေါင်း တရာ လေးဆယ် ခုနစ် နှစ် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ဣသရေလ သည် သေ ရသောအချိန် နီး သော် ၊ သား ယောသပ် ကို ခေါ် ၍ ငါ့ကိုသနားလျှင် သင် ၏ လက် ကို ငါ့ ပေါင် အောက် ၌ ထားပါလော့။ ကရုဏာ သစ္စာ နှင့်အညီ ငါ ၌ ပြု ပါ။ အဲဂုတ္တု ပြည်၌ ငါ့ ကိုမ သင်္ဂြိုဟ် ပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ငါ သည်ဘိုးဘေး နှင့်အတူ အိပ် ချင်ပါ၏။ အဲဂုတ္တု ပြည်မှ ငါ့ ကို ဆောင်သွား ၍ သူ တို့သင်္ချိုင်း ၌ သင်္ဂြိုဟ် ရမည်ဟုဆို၏။ ယောသပ်ကလည်း၊ အဘ ဆို သည် အတိုင်း အကျွန်ုပ်ပြု ပါမည်ဟု ဝန်ခံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ငါ့ အား ကျိန်ဆို ခြင်းကို ပြုပါဟု ဆို ပြန်လျှင် ၊ ကျိန်ဆို ခြင်းကို ပြု၏။ ဣသရေလ သည်လည်း ခုတင် ခေါင်း ရင်းပေါ် မှာ ကိုးကွယ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","နောက်တဖန်ယောသပ် သည် အဘ နာ ကြောင်းကို ကြား သဖြင့် ၊ သား နှစ် ယောက်မနာရှေ နှင့် ဧဖရိမ် ကို ယူ ၍သွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","သား ယောသပ် လာ ကြောင်း ကို ယာကုပ် သည် ကြား လျှင် ၊ အားထုတ် ၍ ခုတင် ပေါ် မှာထိုင် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ထိုအခါ ယာကုပ် က၊ အနန္တ တန်ခိုးရှင်ဘုရား သခင် သည်၊ ခါနာန် ပြည် လုဇ မြို့၌ ငါ့ အား ထင်ရှား ၍ ကောင်းကြီး ပေးတော်မူလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ငါ သည်သင့် ကို တိုး ပွါးများပြား စေမည်။ သင့် ကို များစွာ သော လူ ဖြစ်စေ မည်။ သင် ၏အမျိုးအနွယ် သည် သင့် နောက်မှ ဤ ပြည် ကို အစဉ် အမြဲပိုင် စေခြင်းငှါ ငါပေး မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","သင်နေသောအဲဂုတ္တု ပြည် သို့ ငါ မ ရောက် မှီ၊ အဲဂုတ္တု ပြည်၌ သင်ရ နှင့်သော သား နှစ် ယောက်၊ ဧဖရိမ် နှင့် မနာရှေ တို့သည် ငါ့ သားဖြစ်ရမည်။ ရုဗင် နှင့် ရှိမောင် ကဲ့သို့ ငါ့ သားဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","နောက်မှ သင်ရ သောသား တို့သည် သင် ၏သား ဖြစ်၍မိမိ အမွေ ခံရာတွင် မိမိအစ်ကို တို့အမည် ဖြင့် သမုတ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ငါ သည်ပါဒနာရံ အရပ်မှ လာ သည်ကာလ ၊ ခါနာန် ပြည် ၌ ခရီး သွား၍၊ ဧဖရတ် မြို့နှင့်နီး သောအခါ ၊ သင့်အမိရာခေလ သည် ငါ့ အနား မှာ သေ ရှာ၏။ သေ သောအရပ် ဗက်လင် အမည်ရှိသောဧဖရတ် မြို့သို့ သွား သောလမ်း ၌ သင်္ဂြိုဟ် လေသည်ဟု ယောသပ်အားဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","တဖန် ဣသရေလ သည် ယောသပ် ၏သား တို့ကို ကြည့်ရှု ၍ ၊ ဤ သူတို့ကား အဘယ် သူနည်းမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ယောသပ် က ၊ ဤ ပြည်၌ အကျွန်ုပ် အား ဘုရားသခင် ပေး သနားတော်မူသောအကျွန်ုပ် ၏ သား ဖြစ်ပါသည် ဟု အဘ အားဆိုသော် ၊ အဘက၊ ငါ့ ထံ သို့လာ ပါစေလော့။ သူ တို့ကို ငါကောင်းကြီး ပေးမည်ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ဣသရေလ သည် အသက် ကြီး၍ မျက်စိ မှုန် သဖြင့်၊ မ မြင် နိုင် သောကြောင့် ၊ သား တို့ကို အနီးသို့ ချဉ်းကပ် စေ၍ ပိုက် ဘက်နမ်းရှုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ဣသရေလ ကလည်း ၊ ငါသည် သင် ၏မျက်နှာ ကို မြင် ရမည်ဟု ငါမ ထင်။ ယခုတွင်သင် ၏သား တို့ကိုပင် ဘုရားသခင် ပြ တော်မူပြီဟု ယောသပ် အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ယောသပ် သည်လည်း ၊ သား တို့ကို အဘ ၏ဒူး ကြားမှ ထုတ် ၍ အဘ ရှေ့ ၌ဦးညွှတ် ချစေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","တဖန် ယောသပ် သည် သား တို့ကိုယူ ၍ ဧဖရိမ် ကို လက်ျာ လက်နှင့် ကိုင်လျက်၊ ဣသရေလ လက်ဝဲ လက်သို့၎င်း၊ မနာရှေ ကို လက်ဝဲ လက်နှင့် ကိုင်လျက်၊ ဣသရေလ လက်ျာ လက်သို့၎င်း ချဉ်းကပ် စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","မနာရှေ သည်သားဦး ဖြစ်သော်လည်း ၊ ဣသရေလ သည် မိမိ လက် တို့ကို ဆန့် ၍ လိမ္မာစွာ ပဲ့ပြင်လျက် ၊ အသက် ငယ်သောသူ ဧဖရိမ် ၏ခေါင်း ပေါ် မှာ လက်ျာ လက်ကို တင် ပြီးလျှင်၊ လက် ဝဲလက်ကို မနာရှေ ၏ ခေါင်း ပေါ် မှာ တင်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ယောသပ် ကို ကောင်းကြီး ပေးလျက် ၊ ငါ့ အဘ အာဗြဟံ နှင့် ဣဇာက် ကိုးကွယ်သော ဘုရားသခင် ၊ ငါ့ ကို တသက်လုံး ယနေ့ တိုင်အောင် ကျွေးမွေး တော်မူသောဘုရားသခင် တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ငါ့ ကိုခပ်သိမ်း သော ဘေးဒဏ် အထဲ က ကယ်နှုတ် တော်မူသောကောင်းကင် တမန်သည်၊ ဤသူငယ် တို့ကို ကောင်းကြီး ပေးတော်မူပါစေသော။ သူ တို့ကို ငါ့ အမည် ဖြင့်၎င်း ၊ ငါ့ အဘ အာဗြဟံ နှင့် ဣဇာက် ၏အမည် ဖြင့်၎င်း၊ ထပ်၍မှည့် ပါစေသော။ သူတို့သည် မြေကြီး ပေါ် မှာ အလွန်တိုး ပွါးများပြား ပါစေသောဟု မြွက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","အဘ သည်လက်ျာ လက် ကို ဧဖရိမ် ၏ခေါင်း ပေါ် မှာ တင် သည်ကို ယောသပ် မြင် လျှင် ၊ အား မရ သည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","မ ဟုတ်ပါအဘ။ ဤ သူသည် သားဦး ဖြစ်ပါ၏။ သူ ၏ခေါင်း ပေါ် မှာ လက်ျာ လက်ကိုတင် ပါဟု ဆို လျက် အဘ ၏ လက် ကိုဧဖရိမ် ခေါင်း ပေါ် က မနာရှေ ခေါင်း ပေါ် သို့ ပြောင်း ခြင်းငှါ ချီ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","အဘ သည်ငြင်း ၍ ၊ ငါသိ ၏ငါ သား ၊ ငါသိ ၏။ သူသည် ကြီးစွာ သော လူ စုဖြစ် လိမ့်မည်။ သို့သော်လည်း ၊ သူ့ ညီ သည် သူ့ ထက် သာ၍ ကြီးသဖြင့် ၊ သူ ၏ အမျိုး အနွှယ်သည် များစွာ သော လူ အစုစုဖြစ် လိမ့်မည်ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","တဖန် ဘုရားသခင် သည် သင့် ကို ဧဖရိမ် ကဲ့သို့ ၎င်း ၊ မနာရှေ ကဲ့သို့ ၎င်း ဖြစ်စေ တော်မူပါစေသောဟူ၍ ဣသရေလ အမျိုးသားတို့ သည်သင် အားဖြင့် ကောင်းကြီး ပေးကြလိမ့်မည်ဟု ထိုနေ့ ၌ သူ တို့ကိုကောင်းကြီး ပေးလေ၏။ ထိုသို့ မနာရှေ ရှေ့ မှာ ဧဖရိမ် ကိုနေရာ ချသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ဣသရေလ ကလည်း ၊ ငါ သေ တော့မည်။ သို့သော်လည်း ၊ ဘုရားသခင် သည် သင် တို့ဘက် ၌ရှိ ၍ ၊ သင် တို့ကို ဘိုးဘေး နေရာ ပြည် သို့ တဖန် ဆောင် တော်မူလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ထိုမှတပါး သင် ၏အစ်ကို တို့အား ပေး သည်ထက် သင့် အားသာ၍ပေးသောအရာဟူမူကား၊ ငါ့ ထား ၊ ငါ့ လေး ဖြင့် အာမောရိ အမျိုးသားလက် မှ နှုတ်ယူ သောအရာ ကို သင့်အား ငါပေးသည်ဟု ယောသပ် ကို ပြော ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ထို ရောအခါ၊ ယာကုပ် သည် မိမိ သား တို့ကို ခေါ် ၍ ၊ သင် တို့သည် စည်းဝေး ကြလော့။ နောင် ကာလ အခါ၊ သင် တို့၌ ဖြစ် လတံ့သော အမှု အရာများကို ငါဟောပြော မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ယာကုပ် ၏သား တို့၊ စည်းဝေး ၍ ကြား ကြလော့။ အဘ ဣသရေလ ၏စကားကို နားထောင် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","အိုရုဗင် ၊ သင် သည် ငါ့ သားဦး ၊ ငါ့ အစွမ်း သတ္တိ၊ ငါ ခွန်အား အစ အဦး၊ ဘုန်း အထွဋ် ၊ တန်ခိုး အထွဋ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","သို့သော်လည်းရေ ကဲ့သို့ ပွက်ထ သော သဘောရှိသည်ဖြစ်၍၊ ထူးမြတ် ခြင်းသို့ မ ရောက်ရ။ အကြောင်း မူကား၊ သင် သည် အဘ ၏အိပ်ရာ ကို တက် ၍ ညစ်ညူး စေ၏။ ငါ့ ခုတင် ထက်သို့တက် လေပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ရှိမောင် နှင့် လေဝိ သည် ညီအစ်ကို ဖြစ်၏။ အဓမ္မ အမှုကို ကြံသည်အတိုင်း ပြီးစီးကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ငါ့ ဝိညာဉ် သည် သူ တို့လျှို့ဝှက် ခြင်း အမှုထဲ သို့မ ဝင် ရ။ ငါ့ ဘုန်း သည် သူ တို့စည်းဝေး ရာနှင့် အသင်း မ ဖွဲ့ရ။ သူတို့သည် အမျက် ထွက်၍ လူ အသက်ကိုသတ် ကြပြီ။ ကိုယ် အလို သို့လိုက်၍ မြို့ ကိုဖြို ဖျက်ကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","သူ တို့ပြင်းစွာ ထွက်သောအမျက် ၊ ကြမ်းတမ်း စွာသော ဒေါသ သည် ကျိန်ခြင်း ကိုခံ ပါစေသော။ ယာကုပ် အမျိုး၊ ဣသရေလ အနွယ်သားတို့တွင် သူ တို့ကို ငါကွဲပြား ပြန့်လွင့်စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","အိုယုဒ ၊ သင် သည်ညီအစ်ကို တို့ ချီးမွမ်း ရသောသူဖြစ် ၏။ သင် ၏လက် သည် သင် ၏ရန်သူ လည်ပင်း ပေါ် မှာ ရှိလိမ့်မည်။ အဘ ၏သား တို့သည် သင့် ရှေ့ မှာ ဦးညွှတ် ချကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ယုဒ သည် ခြင်္သေ့ ပျို ဖြစ်၏။ ငါ့ သား ၊ သင်သည် ဘမ်း ယူကိုက်စားရာမှ တက် လာတတ်၏။ ဝပ် လျက် နေ၏။ ခြင်္သေ့ ကဲ့သို့ ၎င်း ၊ ခြင်္သေ့ မကဲ့သို့ ၎င်း ဝပ် တွားတတ် ၏။ အဘယ်သူ နှိုးဆော် ဝံ့မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ရှိလောမရောက် မှီတိုင်အောင် ၊ ရာဇလှံတံ သည် ယုဒ ထံ မှ၎င်း၊ မင်း အာဏာသည် သူ၏အမျိုးအနွယ် ထံ မှ၎င်း မ ရွေ့ ရ။ ရှိလော ၌ လူမျိုး တို့သည် ဆည်းကပ် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","မိမိ မြည်း ကို စပျစ် နွယ်ပင်၌ ၎င်း ၊ မြည်း ကလေး ကို အမြတ် ဆုံးသော စပျစ်နွှယ်ပင်၌ ၎င်း ချည်နှောင် ၍၊ မိမိ အဝတ် ပုဆိုးများကို စပျစ်သီး အသွေး တည်းဟူသော စပျစ်ရည် ဖြင့် လျှော် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","သူ၏မျက်စိ သည် စပျစ်ရည် နှင့် နီ လိမ့်မည်။ သွား သည်လည်း နို့ နှင့် ဖြူ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ဇာဗုလုန် သည် ကမ်း နား မှာ နေ ၍ ၊ သင်္ဘော ဆိပ် ဖြစ် လိမ့်မည်။ သူ ၏နယ် သည် ဇိဒုန် မြို့တိုင်အောင် ကျယ်ဝန်းလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ဣသခါ သည် တောင် ကြား မှာ ဝပ် လျက် အား ကြီးသောမြည်း ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ငြိမ်ဝပ် ရာအရပ်ကောင်း ၍ မြေ သာယာ သည်ကို မြင် သဖြင့် ၊ မိမိ ပခုံး ပေါ် မှာ ထမ်းပိုးကို တင်ထမ်း ၍၊ အခွန်ပေးသော ကျွန် ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ဒန် သည် ဣသရေလ အနွှယ် တစုံ တပါးကဲ့သို့ ၊ မိမိ လူ တို့ကို စီရင် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ဒန် သည် လမ်း ၌ နေသောမြွေ ဖြစ် လိမ့်မည်။ မြင်းစီး သောသူ ကို နောက် သို့ လဲ စေခြင်းငှါ လမ်းကြား မှာ နေ ၍၊ မြင်း ခြေ ကို ကိုက် တတ်သော မြွေဆိုး ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","အိုထာဝရဘုရား ၊ ကယ်တင် တော်မူခြင်းကျေးဇူးကို အကျွန်ုပ်မြော်လင့် လျက်နေပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ဂဒ် မူကား၊ စစ်သူရဲ တို့သည် သူ တို့တိုက် ကြ၍ ၊ သူ သည် ပြန်တိုက် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","အာရှာ ၌ဖြစ်သော အစာ သည် အရသာနှင့် ပြည့်စုံ ၍ ၊ မင်း ၏ ခဲဘွယ် စားဘွယ်တို့ကို ထုတ်ပေး လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","နဿလိ သည် လှ သောအခက်အလက်နှင့် ပြည့်စုံ၍၊ ကျယ်ဝန်း သော သပိတ်ပင်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ယောသပ် သည် သန် သောပျိုး ပင်၊ ရေတွင်း နား မှာ သန် သော ပျိုး ပင်ဖြစ်၏။ အခက် အလက်တို့သည် အုတ် ရိုးပေါ် မှာ ကျော် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","လေး သမား တို့သည် သူ့ ကို အငြိုးထား ၍ ၊ အလွန်ညှဉ်းဆဲ ပစ်ခတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","သို့သော်လည်း သူ ၏လေး သည် အား မလျော့။ သူ ကိုင် သော လက်နက်တို့သည်၊ ယာကုပ် အမျိုး၌ တန်ခိုး ကြီးသော ဘုရား၏လက် ဖြင့်၎င်း၊ သိုးထိန်း တည်းဟူသောဣသရေလ အမျိုး၏ကျောက် ဖြင့်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","သင့် ကိုမစ တော်မူသောသင့် အဘ ၏ ဘုရား သခင် အားဖြင့် ၎င်း၊ သင့် ကိုကောင်းကြီး ပေးတော်မူသောအနန္တ တန်ခိုးရှင်အားဖြင့် ၎င်း ခိုင်မာလျက်ရှိ၏။ ထိုဘုရားသည် အထက် မိုဃ်းကောင်းကင် ၏ မင်္ဂလာ ၊ အောက် နက်နဲ သောအရပ်၏မင်္ဂလာ ၊ သားမြတ် နှင့်ဆိုင်သောမင်္ဂလာ ၊ ဝမ်း နှင့်ဆိုင်သောမင်္ဂလာတို့ဖြင့် သင့်ကို ကောင်းကြီးပေးတော်မူမူပါစေသော။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","သင် ၏အဘ ပေးသော ကောင်းကြီး မင်္ဂလာသည်၊ ထာဝရ တောင် တို့၌ဖြစ်သော ကောင်းကြီး မင်္ဂလာ၊ ထာဝရ ကုန်း တို့၌ နှစ်သက်ဘွယ်သောအရာတို့ထက် သာ၍မြတ်၏။ ထိုမင်္ဂလာသည် ယောသပ် ခေါင်း ပေါ် ၊ မိမိ အစ်ကို တို့တွင် အကြီးအကဲဖြစ်သောသူ၏ ခေါင်းထိပ်ပေါ်မှာ သက်ရောက် ပါစေသော။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ဗင်္ယာမိန် သည် လုယူကိုက် စားတတ်သော တော ခွေးဖြစ်လိမ့်မည်။ ဘမ်း ရသောအရာကိုနံနက် အချိန်၌ ကိုက် စား၍ ၊ လုယူ သောအရာကိုလည်း ည အချိန်၌ ဝေဖန် လိမ့်မည်ဟုမြွက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ဤ သူတို့ကား၊ ဣသရေလ အမျိုး ဆယ် နှစ် မျိုး ဖြစ်၏။ ဤ စကားသည်လည်း သူ တို့အဘ မြွက်ဆို ၍ ၊ သူ တို့ အသီးသီး ခံရသောမင်္ဂလာ ရှိသည်အတိုင်း၊ ကောင်းကြီးပေးသော စကားပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","တဖန် တုံ၊ ငါ့ လူမျိုး စည်းဝေး ရာသို့ ငါသွားရမည်။ ဟိတ္တိ အမျိုးသား၊ ဧဖရှန် ၏လယ်ပြင် တွင် ရှိသောမြေတွင်း ၌ ၊ ငါ့ အဘ တို့နှင့်အတူ ငါ့ ကို သင်္ဂြိုဟ် ကြပါ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ခါနာန် ပြည် မံရေ မြို့ရှေ့ မှာ ၊ မပ္ပေလ လယ်ပြင် ၌ ရှိသောထို မြေတွင်း ကို ၊ အာဗြဟံ သည် ကိုယ်ပိုင် သော သင်္ချိုင်း ဘို့ လယ်ပြင် နှင့်တကွဟိတ္တိ အမျိုးသားဧဖရုန် ၌ ဝယ် လေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ထို မြေတွင်း၌ အာဗြဟံ နှင့် မယား စာရာ ကို သင်္ဂြိုဟ် ကြပြီ။ ဣဇာက် နှင့် မယား ရေဗက္က ကိုလည်း သင်္ဂြိုဟ် ကြပြီ။ လေအာ ကိုလည်း ငါသင်္ဂြိုဟ် ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ထို မြေတွင်း ရှိသောထိုလယ်ပြင် ကို၊ ဟေသ အမျိုးသား ရှေ့ မှာ ဝယ် သတည်းဟု မှာထား၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ထိုသို့ ယာကုပ် သည် မိမိ သား တို့ကို အကုန်အစင်မှာ ထားပြီးလျှင် ၊ မိမိ ခြေ တို့ကို ခုတင် ပေါ် မှာ ရုပ်သိမ်း သဖြင့် ၊ အသက် ချုပ်၍ မိမိ လူမျိုး စည်းဝေး ရာသို့ ရောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ထိုအခါ ယောသပ် သည် အဘ ၏မျက်နှာ ပေါ် မှာ ငုံ့ ၍ ၊ ငို လျက် နမ်း လျက်နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","အဘ ၏အလောင်း ကို နံ့သာမျိုးနှင့် ပြင်ဆင်စေခြင်းငှါ ၊ မိမိ ကျွန် ဆေးသမား တို့ကို အမိန့် ရှိ၍ ၊ သူတို့သည် နံ့သာမျိုးနှင့် ပြင်ဆင်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","နံ့သာမျိုး နှင့်ပြင်ဆင်သော အလောင်းကို၊ ထုံးစံ ရှိသည်အတိုင်း ထား၍၊ အရက် လေးဆယ် လွန်လျှင်၊ အဲဂုတ္တု လူတို့သည် ယာကုပ် ကြောင့်၊ အရက် ခုနစ် ဆယ် ပတ်လုံးငိုကြွေး မြည်တမ်းခြင်းကိုပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ငိုကြွေး မြည်တမ်းသောနေ့ရက် လွန် သောအခါ ၊ ယောသပ် သည် နန်းတော် သား အချို့တို့ကိုခေါ် ၍ ၊ သင် တို့ သည် ကျွန်ုပ်ကိုစေတနာ စိတ်ရှိ လျှင် ၊ ဖာရော ဘုရင် ထံ တော်သို့သွား၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ကျွန်တော် အဘ က၊ ငါ သေ တော့မည်။ ခါနာန် ပြည် ၌ ကိုယ် ဘို့ ငါတူး ဘူးသော သင်္ချိုင်း တွင်း၌ ၊ ငါ့ ကို သင်္ဂြိုဟ် ရမည်ဟူ၍ကျွန်တော် ကို ကျိန်ဆို စေပါပြီ။ ထိုကြောင့်ကျွန်တော်သွား ၍ ၊ အဘ ကို သင်္ဂြိုဟ် ပြီးမှ ပြန် လာပါမည် အကြောင်းကို အသနားတော်ခံပါသည်ဟု နားတော် လျှောက်ကြပါလော့ဟုဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ဖာရော မင်းကလည်း ၊ သင် ၏အဘ ကျိန်ဆို စေသည်အတိုင်း သွား ၍ ၊ သင်္ဂြိုဟ် လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ယောသပ် သည် အဘ ကိုသင်္ဂြိုဟ် ခြင်းငှါ ထွက်သွား ၍ ၊ ဖာရော မင်း၏ ကျွန် များတည်းဟူသောနန်းတော် အရာရှိ ၊ အဲဂုတ္တု ပြည် အရာရှိ အပေါင်း တို့နှင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ယောသပ် အိမ်သား၊ အစ်ကို တို့ အိမ်သား ၊ အဘ အိမ်သား ရှိသမျှ တို့ သည်လိုက်ကြ၏။ သူငယ် တို့နှင့် သိုး နွား များကိုသာ ၊ ဂေါရှင် ပြည် ၌ ကျန်ရစ် စေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ထိုသို့လျှင် ရထား များ၊ မြင်းစီးသူရဲ များတည်းဟူသောအလွန် များစွာသော အလုံး အရင်းတို့သည် ယောသပ် နှင့်တကွ လိုက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ယော်ဒန် မြစ်နား မှာ အာတဒ် ကောက်နယ်တလင်းသို့ ရောက် သောအခါ ၊ အလွန် ကြီးစွာ သော ငိုကြွေး မြည်တမ်းခြင်းကို ပြု ကြပြန်၏။ ယောသပ်သည် မိမိ အဘ ကြောင့် ခုနစ် ရက်ပတ်လုံးငိုကြွေး မြည်တမ်း ခြင်း ကိုပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ထိုသို့အာတဒ် ကောက်နယ်တလင်း၌ ပြုသောငိုကြွေးမြည်တမ်းခြင်းကို၊ ထို ပြည်သား ခါနာန် လူတို့သည် မြင် လျှင် ၊ အဲဂုတ္တု လူတို့သည် ပြင်းစွာ ငိုကြွေး မြည်တမ်းပါသည်တကားဟုဆို ကြ၏။ ထိုကြောင့် ယော်ဒန် မြစ်နား မှာ ရှိသော ထို အရပ်ကို၊ အဗေလမိဇရိမ် ဟူ၍သမုတ် ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ယာကုပ် သား တို့သည်၊ အဘမှာ ထားသည် အတိုင်း ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ခါနာန် ပြည် သို့ ဆောင်သွား ၍ ၊ အာဗြဟံ သည် ကိုယ်ပိုင် သောသင်္ချိုင်း ဘို့၊ ဟိတ္တိ အမျိုးသားဧဖရုန် ၌ ဝယ် သော မံရေ မြို့ရှေ့ ၊ မပ္ပေလ လယ်ပြင် တွင်ရှိသောမြေတွင်း ၌ သင်္ဂြိုဟ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ယောသပ် သည် အဘ ကိုသင်္ဂြိုဟ် ပြီးလျှင် ၊ အစ်ကို များမှစ၍ မသာလိုက် လာသောသူအပေါင်း တို့နှင့်တကွ ၊ အဲဂုတ္တု ပြည်သို့ ပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ယောသပ် အစ်ကို တို့သည် အဘ သေ သည်ကို သိမြင် လျှင် ၊ ငါ တို့ကို ယောသပ် သည် အငြိုး ထားကောင်း ထားလိမ့်မည်။ ငါ တို့သည် အထက်က သူ့ ကို ညှဉ်းဆဲ သောကြောင့် ၊ ငါ တို့အား ဧကန်အမှန်ပြန် ၍ ညှဉ်းဆဲလိမ့်မည်ဟု စိုးရိမ်လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","သူ့ ထံ သို့တမန်ကိုစေလွှတ် ၍ ၊ ကိုယ်တော် အစ်ကို တို့သည် မကောင်း သောအမှုကို ကိုယ်တော်အား ပြု မိ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ကိုယ်တော် ကို ပြစ်မှား သောအပြစ် ကို လွှတ်တော်မူပါဟု၊ ကိုယ်တော်အား ကြား လျှောက်ရမည် အကြောင်း၊ ခမည်း တော်မသေမှီ ကျွန်တော်တို့ကို မှာ ထားခဲ့သည်ဖြစ်၍၊ ယခု တွင် ခမည်း တော်၏ ဘုရားသခင် ကျွန် တို့၏ အပြစ် ကို လွှတ် တော်မူပါဟု လျှောက်ကြ၏။ ထိုသို့ လျှောက် ကြသောအခါ ၊ ယောသပ် သည် မျက်ရည် ကျလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","အစ်ကို တို့သည်လည်း ဝင် ၍ ယောသပ် ရှေ့ မှာ ပြပ်ဝပ် လျက် ၊ ကျွန်တော် တို့သည် ကိုယ်တော် ၏ ကျွန် ဖြစ်ကြပါသည်ဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ယောသပ် ကလည်း ၊ မ စိုးရိမ် ကြနှင့်။ ကျွန်ုပ် သည် ဘုရားသခင် ကိုယ်စား ဖြစ်သလော။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","သင် တို့သည် ကျွန်ုပ် ကို ညှဉ်းဆဲ မည်ကြံ ကြသော်လည်း ၊ ဘုရားသခင် သည် ယနေ့ ဖြစ်သည်အတိုင်း ၊ လူ များ အသက် ချမ်းသာစေခြင်းငှါ ကျေးဇူး ပြု မည် ကြံ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ထိုကြောင့် ၊ မ စိုးရိမ် ကြနှင့်။ သင် တို့နှင့် သူငယ် များကို ကျွန်ုပ် ကျွေးမွေး မည်ဟုဆိုလျက်၊ သူ တို့ကို နှစ်သိမ့် စေ၍ မေတ္တာ စကားကို ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ထိုသို့ ယောသပ် သည် မိမိ အဘ ၏ အမျိုးသား တို့နှင့် အဲဂုတ္တု ပြည်၌ နေ ၍ ၊ အသက် တရာ တဆယ် ကိုမှီ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ဧဖရိမ် ၏မြေး ကို မြင် ရ၏။ မနာရှေ ၏သား ၊ မာခိရ ၏သားသမီး တို့ကိုလည်း မိမိ ဒူး ပေါ် မှာ မွေးစား ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ယောသပ် ကလည်း ၊ ကျွန်ုပ် သေ တော့မည်။ အကယ် စင်စစ်ဘုရားသခင် သည် သင် တို့ကို အကြည့် အရှု ကြွလာတော်မူမည်။ အာဗြဟံ ၊ ဣဇာက် ၊ ယာကုပ် တို့အား ကျိန်ဆို တော်မူသော ပြည် သို့ ၊ ဤ ပြည် မှ ဆောင်သွား တော်မူမည်ဟု အစ်ကို တို့အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","တဖန် တုံ၊ အကယ်စင်စစ်ဘုရားသခင် သည် သင် တို့ကို အကြည့် အရှုကြွလာတော်မူမည်။ ကျွန်ုပ် အရိုး တို့ကို ဤ အရပ်မှ ယူ သွားရမည်ဟူ၍ဣသရေလ အမျိုးသား တို့ကို ကျိန်ဆို စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ထိုသို့ ယောသပ် သည် အသက် တရာ တဆယ် ရှိသော်အနိစ္စ ရောက်လေ၏။ အလောင်း ကိုကား၊ နံ့သာမျိုး နှင့် ပြင်ဆင်ပြီးလျှင် အဲဂုတ္တု ပြည်၌ တလား နှင့် ထား ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","မိမိ တို့ အိမ်သူအိမ်သား ပါ လျက်၊ အဘယာကုပ် နှင့်အတူ အဲဂုတ္တု ပြည်သို့ ရောက် လာသောဣသရေလ သား တို့၏အမည် ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ရုဗင် ၊ ရှိမောင် ၊ လေဝိ ၊ ယုဒ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ဣသခါ ၊ ဇာဗုလုန် ၊ ဗင်္ယာမိန်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ဒန် ၊ နဿလိ ၊ ဂဒ် ၊ အာရှာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ယာကုပ် အမျိုးသား ပေါင်း ကား၊ ခုနစ်ဆယ် တည်း။ ယောသပ် သည် အဲဂုတ္တု ပြည်၌ ရှိ နှင့်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ယောသပ် နှင့် အစ်ကို များမှစ၍ ၊ ထို ကာလ အမျိုးသားအပေါင်း တို့သည် သေ ကြကုန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ဣသရေလ အမျိုးသား တို့သည် သားကိုဘွား ၍ အလွန်တိုး ပွား များပြား သဖြင့် ၊ အလွန် အားကြီး၍ တပြည် လုံး၌ နှံ့ပြား ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ထိုနောက် မှအဲဂုတ္တု ပြည်၌ ယောသပ် ကို မ သိ သော ရှင်ဘုရင် သစ် ပေါ် လာ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ထိုရှင်ဘုရင်ကလည်း၊ ဣသရေလ အမျိုးသား တို့သည် ငါ တို့ထက် သာ၍များ ကြ၏။ သာ၍အားကြီး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","လာ ကြ၊ သူ တို့ကို လိမ္မာစွာ ပြုကြစို့။ သို့မဟုတ် သူတို့သည် များပြား ကြလိမ့်မည်။ နောက်တခါ စစ်မှု ရောက် လျှင် ငါ တို့ရန်သူ ဘက်သို့ ဝင်စား ၍ ငါ တို့ကို တိုက် သဖြင့် ၊ ပြည် တော်ထဲက ထွက်သွား ကြလိမ့်မည်ဟု မိမိ လူ တို့အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ထို့ကြောင့် အဲဂုတ္တုမင်းတို့သည်၊ ကျပ်တည်းစွာ နှိပ်စက် ညှဉ်းဆဲစေခြင်းငှါ အအုပ်အချုပ် ခန့်ထား ကြ၏။ ဣသရေလလူတို့သည်၊ ဘဏ္ဍာတော်သို ထားဘို့ ၊ ပိသုံ မြို့ နှင့် ရာမသက် မြို့ကို တည်ဆောက် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","သို့သော်လည်း ၊ နှိပ်စက် ခြင်းကိုခံရသည်အတိုင်း ၊ တိုးပွား များပြား လျက် ရှိကြ၏။ သူ တို့ကြောင့် အဲဂုတ္တု လူတို့သည် စိတ်ညစ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","အလွန် ကြမ်းတမ်းစွာညှဉ်းဆဲ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","သရွတ် နှင့် အုတ် လုပ် သောအမှု၊ လယ် လုပ်သောအမှုအမျိုးမျိုး ၌ ခဲယဉ်းစွာစေခိုင်း ၍ အလွန်ဆင်းရဲ ပင်ပန်းစေကြ၏။ စေခိုင်းလေရာရာ၌ လည်း ခဲယဉ်း စွာ စေခိုင်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ရှိဖရ နှင့် ပုအာ အမည် ရှိသောဟေဗြဲ ဝမ်းဆွဲမတို့ကို ၊ အဲဂုတ္တု ရှင်ဘုရင် က၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","သင် တို့သည် ဟေဗြဲ မိန်းမတို့အား ဝမ်းဆွဲ လုပ်၍ မွေးရာ အရပ်၌ စောင့် နေသောအခါ ၊ ယောက်ျား ဖြစ်လျှင် သေ စေ၊ မိန်းမ ဖြစ်လျှင် အသက်ရှင် စေဟု အမိန့် တော် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ဝမ်းဆွဲ မတို့သည် ဘုရားသခင် ကိုကြောက်ရွံ ၍ ၊ အဲဂုတ္တု ရှင်ဘုရင် မိန့် တော်မူသည်အတိုင်း မ ပြု ၊ ယောက်ျား တို့ကို အသက်ချမ်းသာ ပေးကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","အဲဂုတ္တု ရှင်ဘုရင် သည်လည်း ၊ ဝမ်းဆွဲမ တို့ကို ခေါ် ၍ သင်တို့သည် အဘယ်ကြောင့် ဤသို့ ပြု သနည်း။ ယောက်ျား တို့ကိုအဘယ်ကြောင့်အသက် ချမ်းသာပေးသနည်းဟုမေး စစ်သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ဝမ်းဆွဲမ တို့က၊ ဟေဗြဲ မိန်းမတို့သည်၊ အဲဂုတ္တု ၊ မိန်းမ ကဲ့သို့ မဟုတ် ၊ သန်စွမ်း သောကြောင့် ၊ ဝမ်းဆွဲမ မ ရောက် မှီ သား ကိုဘွားတတ်ကြ၏ဟု ပြန်လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ထိုကြောင့် ဘုရားသခင် သည် ဝမ်းဆွဲမ တို့ကို ကျေးဇူးပြု တော်မူ၏။ ထိုလူ အမျိုးသည်လည်း များပြား ၍ အလွန် အားကြီး ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ဝမ်းဆွဲမ တို့သည် ဘုရားသခင် ကို ကြောက်ရွံ့ သောကြောင့် ၊ သူ တို့အိမ်သူအိမ်သား များကို ပြုစု တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ဖာရော ဘုရင်ကလည်း ၊ ဣသရေလအမျိုးသားတို့တွင်၊ ဘွားမြင် သောသူငယ် ယောက်ျား အပေါင်းတို့ကို မြစ် ထဲသို့ ချပစ် စေ။ မိန်းမ ကိုမူကား အသက်ရှင် စေဟု မိမိ လူ အပေါင်း တို့ကို မှာ ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ထို ကာလ၌ လေဝိ အမျိုးသား တယောက်သည်၊ လေဝိ အမျိုးသမီး နှင့် အိမ်ထောင် ဘက်ပြု၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","မိန်းမ သည် ပဋိသန္ဓေ ယူသဖြင့် သား ယောက်ျားကို ဘွားမြင် လေ၏။ ထိုသား သည် အဆင်းလှ ကြောင်း ကို အမိမြင် လျှင် ၊ သုံး လ ပတ်လုံးဖွက် ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","နောက်တဖန် ဖွက် ၍မ ထား နိုင်သောအခါ ၊ ဂမာကိုင်း ပင်ဖြင့် ရက်သောပုခက် ကိုယူ ၍ ရေညှိ နှင့် သစ်စေး ဖြင့် လူး ပြီးလျှင် ၊ ပုခက် ထဲတွင် သူငယ် ကိုထည့် ၍ မြစ် ကမ်း နား ကိုင်း တော၌ ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","သူငယ် အစ်မ လည်း အဘယ်သို့ ဖြစ် မည်ကို သိမြင် ခြင်းငှါ အဝေး ၌ ရပ် နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ဖာရော ဘုရင်၏သမီး တော်သည် ရေချိုး ခြင်းငှါ ဆင်း လာ၍ ၊ ကျွန်မ တို့နှင့် မြစ် ကမ်းနား ၌ လှည့်လည် စဉ်၊ ကိုင်း တော၌ ပုခက် ကိုမြင် ၍ ဆောင်ယူ စေခြင်းငှါ ကျွန်မ တယောက်ကို စေလွှတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ပုခက်ဖုံးကို ဖွင့် သောအခါ ၊ ငို လျက်နေသောသူငယ် ကိုမြင် ၍ ၊ သနား သောစိတ်ရှိလျှင် ၊ ဤ သူငယ်သည် ဟေဗြဲ အမျိုး ဖြစ်လိမ့်မည်ဟု ဆို ပြီး သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","သူငယ် ၏အစ်မ က၊ ကိုယ်တော် အတွက် သူငယ် ကို ထိန်း ရသောဟေဗြဲ အထိန်း ကို ကျွန်မသွား ၍ ခေါ် ရပါမည် လောဟု ဖာရော ဘုရင်၏ သမီး တော်အား မေးလျှောက် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","မင်းသမီး ကသွား လော့ဟု အခွင့်ပေး လျှင် ၊ မိန်းမ ငယ်သွား၍ သူငယ် ၏အမိ ကိုခေါ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ဖာရော ဘုရင်၏သမီး တော်က၊ ဤ သူငယ် ကို ယူသွား ၍ ငါ့ ဘို့ ထိန်း လော။ အခ ကို ငါ ပေး မည်ဟု မှာ ထားသည်အတိုင်း၊ ထိုမိန်းမ သည် သူငယ် ကို ယူသွား ၍ ထိန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","သူငယ် ကြီးပွား သောအခါ ၊ ဖာရော ဘုရင်၏ သမီး တော်ထံသို့ ပို့ဆောင် ၍ မင်းသမီး သည် သား အရာ၌ ခန့်ထား လျက် ၊ မောရှေ အမည် ဖြင့် မှည့် ၏။ အကြောင်းမူကား ၊ ရေ ထဲက ငါနှုတ်ယူ သည်ဟု ဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","မောရှေ သည် ကြီး သောအခါ ၊ မိမိ အမျိုးသား ချင်းတို့ရှိရာသို့ သွား ၍ သူ တို့အမှုထမ်း ရသောအခြင်း အရာတို့ကို ကြည့်ရှု လေ၏။ မိမိ အမျိုးသား ဟေဗြဲ လူ တယောက်ကို၊ အဲဂုတ္တု လူ ရိုက် သည်ကိုမြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ပတ်လည်ကြည့်ရှု ၍ အဘယ်သူ မျှမရှိ သည်ကို သိ သောအခါ၊ အဲဂုတ္တု လူကိုသတ် ၍ သဲ ထဲ ၌ မြှုပ် ထားလေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","နက်ဖြန် နေ့ ၌ ထွက် ပြန်သော် ၊ ဟေဗြဲ လူ နှစ် ယောက်တို့သည် အချင်းချင်းသတ် ကြသည်ကို မြင် လျှင် ၊ သင်သည် သင် ၏အပေါင်းအဘော် ကို အဘယ်ကြောင့် ရိုက် သနည်းဟု ညှဉ်းဆဲ သောသူအား မေး သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ထိုသူက၊ အဘယ်သူ သည် သင့် ကို ငါ တို့အပေါ် မှာ အကဲအမှူး တရားသူကြီး အရာ၌ ခန့်ထား သနည်း။ အဲဂုတ္တု လူကို သတ် သကဲ့သို့ ငါ့ ကို သတ် လို သလောဟု ပြန်ဆို ၏။ ထိုအခါ မောရှေ သည် မိမိပြုသောအမှု ထင်ရှား ပြီဟု သိ ၍ ကြောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ထို သိတင်း ကို ဖါရော ဘုရင်ကြား သောအခါ ၊ မောရှေ ကို သတ် ခြင်းငှါ ရှာကြံ လေ၏။ မောရှေ သည် ဖါရော ဘုရင်ထံမှ ထွက်ပြေး ၍၊ မိဒျန် ပြည် သို့ ရောက် လျှင် ၊ ရေတွင်း နား မှာ ထိုင် ၍နားနေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ထိုအခါ မိဒျန် ယဇ်ပုရောဟိတ် ၏ သမီး ညီအစ်မခုနစ် ယောက်တို့သည်၊ မိမိ တို့အဘ ၏ သိုး ဆိတ်များကို ရေတိုက် ခြင်းငှါ လာ ၍ ရေခပ် ပြီးလျှင် ၊ ရေသောက်ခွက်တို့၌ လောင်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","သိုးထိန်း အချို့တို့လည်း လာ ၍ သိုး ဆိတ်များကို မောင်း ကြ၏။ ထိုအခါ မောရှေ သည်ထ ၍ ထို မိန်းမတို့ဘက်၌နေလျက်၊ သိုး ဆိတ်များကို ရေတိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ထိုမိန်းမတို့သည် အဘ ရွေလ ထံသို့ ရောက် ကြသော် ၊ အဘက အဘယ်ကြောင့် ယနေ့ အလျင်အမြန် ရောက် လာရကြသနည်းဟုမေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","သူတို့ကလည်း၊ အဲဂုတ္တု လူ တယောက်သည် အကျွန်ုပ် တို့ကို သိုးထိန်း တို့လက် မှ ကယ်နှုတ် ၍ ၊ ရေ လိုသမျှကို ခပ် သဖြင့် ၊ သိုး ဆိတ်များကို ရေတိုက် ပါသည်ဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","အဘကလည်း၊ ထိုသူ သည် အဘယ်မှာ ရှိသနည်း။ အဘယ်ကြောင့် သူ့ ကိုပစ် ထားခဲ့သနည်း။ အစာ စား စေခြင်းငှါ သူ့ ကို ခေါ် ချေကြဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","မောရှေ သည် ထိုသူထံမှာ နေ ၍ ပျော်မွေ့ သဖြင့် ၊ သမီး ဇိပေါရ ကို မောရှေ အား ထိမ်းမြားပေးစား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ထိုမိန်းမဘွား သောသား ကို ဂေရရှုံ အမည် ဖြင့် မှည့် ၏။ အကြောင်းမူကား ၊ ငါသည်တကျွန်းတနိုင်ငံ ၌ ဧည့်သည် အာဂန္တုဖြစ် ရပြီဟုဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ကာလ အင်တန်ကြာ ပြီးမှ၊ အဲဂုတ္တု ရှင်ဘုရင် အနိစ္စရောက် လေ၏။ ဣသရေလ အမျိုးသား တို့လည်း အစေ ကျွန်ခံရသောကြောင့်ညည်းတွား ငိုကြွေးကြ၏။ ထိုသို့ အစေ ကျွန်ခံ၍ငိုကြွေး သော အသံသည် ဘုရား သခင် ထံတော်သို့ တက် ရောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","သူ တို့ ညည်းတွား မြည်တမ်းခြင်း အသံကို ဘုရား သခင်ကြား တော်မူလျှင် ၊ အာဗြဟံ ၊ ဣဇာက် ၊ ယာကုပ် နှင့် ပြုခဲ့ဘူးသောပဋိညာဉ် ကို အောက်မေ့ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ဘုရား သခင်သည်လည်း ၊ ဣသရေလ အမျိုးသား တို့ကို ကြည့်ရှု ၍ သူတို့အမှုကို ဆင်ခြင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","မောရှေ သည်၊ မိမိ ယောက္ခမ မိဒျန် ယဇ်ပုရောဟိတ် ယေသရော ၏သိုး ဆိတ်များကို ထိန်း စဉ် ၊ တော နောက်ဘက်သို့ ဆောင်သွား ၍ ၊ ဟောရပ် အမည်ရှိသောဘုရား သခင်၏တောင် သို့ ရောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ထိုအခါ ဘုရား သခင်၏ ကောင်းကင်တမန် သည် ချုံ ထဲ က ထွက်သော မီးလျှံ ၌ ထင်ရှား ၏။ မောရှေသည် ကြည့် သောအခါ ၊ မီး လောင် ၍ ချုံ မ ကျွမ်း ဘဲ ရှိသည်ကို မြင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","အဘယ်ကြောင့် ချုံ မ ကျွမ်း ဘဲရှိသနည်း။ ဤ ထူးဆန်း သောရူပါရုံ ကို ငါသွား ၍ ကြည့်ရှု မည်ဟုဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","မောရှေသွား ၍ ကြည့်ရှု ကြောင်း ကို ထာဝရဘုရား မြင် တော်မူလျှင် ၊ မောရှေ ၊ မောရှေ ဟု ချုံ ထဲ က ခေါ် တော်မူ၏။ မောရှေကလည်း၊ အကျွန်ုပ် ရှိ ပါ၏ဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ဘုရားသခင်ကလည်း၊ မ ချဉ်း နှင့်။ သင် ၏ခြေနင်း ကို ချွတ် လော့။ သင် နင်း သော အရပ် ကား သန့်ရှင်း သော မြေ ဖြစ်သည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ငါ သည်သင့် အဘ ၏ဘုရား ၊ အာဗြဟံ ၏ဘုရား ၊ ဣဇာက် ၏ဘုရား ၊ ယာကုပ် ၏ဘုရား ဖြစ်သည်ဟူ၍၎င်း မိန့် တော်မူ၏။ မောရှေ သည် ဘုရား သခင်ကို မ ကြည့် ဝံ့၊ မိမိ မျက်နှာ ကို ဖုံး လျက်နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ထာဝရဘုရား ကလည်း၊ အဲဂုတ္တု ပြည်၌ ရှိသောငါ ၏လူ တို့ခံရသောညှဉ်းဆဲ ခြင်းကို ငါစေ့စေ့မြင် ခဲ့ပြီ။ သူ တို့ကို စေခိုင်း သော သခင်တို့ကြောင့် သူ တို့မြည်တမ်း သောအသံကိုလည်း ငါကြား ခဲ့ပြီ။ သူ တို့နာကြည်း ခြင်း ဝေဒနာကို ငါသိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","သူ တို့ကို အဲဂုတ္တုပြည်၊ အဲဂုတ္တု လူတို့လက် မှ ကယ်နှုတ် ၍ ၊ ခါနနိ လူ၊ ဟိတ္တိ လူ၊ အာမောရိ လူ၊ ဖေရဇိ လူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့နေရာ ၊ နို့ နှင့် ပျားရည် စီး တတ်သော ပြည် သို့ ပို့ဆောင် ခြင်းငှါ ငါဆင်း လာပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ယခု တွင်လည်း ဣသရေလ အမျိုးသား တို့ ငိုကြွေးသောအသံ သည် ငါ့ ထံ သို့တက်ရောက် ၍ ၊ သူ တို့ကို အဲဂုတ္တု လူတို့သည် ညှဉ်းဆဲ ခြင်းအမှုကိုလည်း ငါမြင် ရပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ထိုကြောင့် ယခု သွား လော့။ သင်သည် ငါ ၏လူ ဣသရေလ အမျိုးသား တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ် ဆောင် မည်အကြောင်း ၊ သင့် ကိုဖါရော ဘုရင်ထံ သို့ငါစေလွှတ် မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","မောရှေ ကလည်း ၊ အကျွန်ုပ် သည် အဘယ်သို့ သောသူဖြစ်၍၊ ဖါရော ဘုရင်ထံ သို့ဝင် သဖြင့် ၊ ဣသရေလ အမျိုးသား တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ် ဆောင်ရပါမည်နည်းဟု ဘုရား သခင်အား လျှောက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ဘုရားသခင်က၊ အကယ်စင်စစ် ငါသည် သင့် ဘက် ၌ရှိ လိမ့်မည်။ ငါ သည် သင့် ကိုစေလွှတ် ခြင်း လက္ခဏာ သက်သေဟူမူကား၊ သင် သည်ထို လူ တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ် ဆောင်ပြီးလျှင်၊ ဤ တောင် ပေါ် မှာ ဘုရား သခင်အား ဝတ်ပြု ရကြလိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","မောရှေ ကလည်း ၊ အကျွန်ုပ် သည် ဣသရေလ အမျိုးသား တို့ ရှိရာသို့ ရောက် ၍ ၊ သင် တို့ဘိုးဘေး များ၏ ဘုရား သခင်သည် ငါ့ ကိုသင် တို့ ရှိရာသို့ စေလွှတ် တော်မူပြီဟု အကျွန်ုပ်ဆို လျှင်၊ သူတို့က၊ ထိုဘုရား သခင်၏ နာမ တော်ကား အဘယ်သို့ နည်းဟု အကျွန်ုပ် ကို ပြန်၍ မေး သောအခါ ၊ အဘယ်သို့ ပြန်ပြော ရပါမည်နည်းဟု ဘုရား သခင်အား မေး လျှောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ဘုရား သခင်ကလည်း ၊ ငါဖြစ် သည်အတိုင်း ငါဖြစ် ၏ဟူ၍၎င်း ၊ ငါဖြစ် သည်ဟု အမည်ရှိသောသူသည်၊ ငါ့ ကိုသင် တို့ရှိရာသို့ စေလွှတ် တော်မူပြီဟု ဣသရေလ အမျိုးသား တို့အား ပြန်ပြော လော့ဟူ၍၎င်း၊ မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","တဖန် ဘုရား သခင်က၊ သင် တို့ဘိုးဘေး များ၏ ဘုရား သခင်၊ အာဗြဟံ ၏ဘုရား ၊ ဣဇာက် ၏ဘုရား ၊ ယာကုပ် ၏ဘုရား တည်းဟူသောထာဝရဘုရား သည်၊ ငါ့ ကို သင် တို့ရှိရာသို့ စေလွှတ် တော်မူပြီဟု ဣသရေလ အမျိုးသား တို့အား ပြော ရမည်။ ထို အမည်သည် အစဉ် ငါ့ အမည် ဖြစ်၏။ လူမျိုး အစဉ်အဆက် မပြတ် ငါ့ ဘွဲ့ နာမ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","သွား ၍ ဣသရေလ အမျိုးအသက်ကြီး သူတို့ကို စုဝေး စေပြီးလျှင် ၊ သင် တို့ဘိုးဘေး များ၏ ဘုရား သခင်၊ အာဗြဟံ ၏ဘုရား ၊ ဣဇာက် ၏ဘုရား၊ ယာကုပ် ၏ဘုရားတည်းဟူသောထာဝရဘုရား သည် ငါ့ အား ထင်ရှား တော်မူလျက်၊ အကယ်စင်စစ်သင် တို့ကို ငါအကြည့်အရှု လာ၍၊ အဲဂုတ္တု ပြည်၌ သင် တို့အား ပြု သောအမှုကိုငါမြင်ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","အဲဂုတ္တု ပြည်၌ ခံရသောဒုက္ခ ထဲက သင် တို့ကို ငါနှုတ်၍၊ ခါနနိ လူ၊ ဟိတ္တ လူ၊ အာမောရိ လူ၊ ဖေရဇိ လူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့နေရာ ၊ နို့ နှင့် ပျားရည် စီး တတ်သော ပြည် သို့ ပို့ဆောင် မည် ငါဂတိ ရှိသည်ဟု မိန့် တော်မူပြီဟု သူ တို့အား ပြော လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","သူတို့သည် သင် ၏စကား ကို နားထောင် ၍ ၊ သင် သည် ဣသရေလ အမျိုးသားအသက်ကြီး သူများပါလျက်၊ အဲဂုတ္တု ရှင်ဘုရင် ထံ သို့ဝင် သဖြင့် ၊ ဟေဗြဲ လူတို့၏ ဘုရား သခင်ထာဝရဘုရား သည် အကျွန်ုပ် တို့နှင့် တွေ့ တော်မူပြီ။ အကျွန်ုပ် တို့၏ဘုရား သခင်ထာဝရဘုရား အား ယဇ်ပူဇော် ခြင်းငှါတော သို့ သုံး ရက် ခရီး သွား ရသောအခွင့်ကိုပေး တော်မူပါဟု လျှောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","အဲဂုတ္တု ရှင်ဘုရင် သည် ကြီးစွာ သောတန်ခိုး ကို မ တွေ့မမြင်လျှင် ၊ သွား ရသောအခွင့်ကို သင် တို့အား မ ပေး ကြောင်းကို ငါ သိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ငါ သည်လည်း လက် ကိုဆန့် ၍ ၊ အဲဂုတ္တု ပြည်ထဲ ၌ ငါပြု လတံ့သော ငါ ၏အံ့ဘွယ် သောအမှုရှိသမျှ တို့နှင့် ထို ပြည်ကို ဒဏ်ခတ် မည်။ ထိုနောက် အဲဂုတ္တုရှင်ဘုရင်သည် သင် တို့ကို လွှတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ထို လူမျိုး သည် အဲဂုတ္တု လူတို့ထံ၌ မျက်နှာရ သော အခွင့်ကို ငါပေး ၍ ၊ သင်တို့သည် ထွက် သွားသောအခါ လက်ချည်း မ သွား ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","အကြောင်းမူကား၊ မိန်းမ တိုင်းမိမိ အိမ်နီးချင်း ၊ မိမိ အိမ် မှာ တည်း သောသူ၌ ငွေ တန်ဆာ ၊ ရွှေ တန်ဆာ နှင့် အဝတ် တန်ဆာများကို တောင်း ၍ ၊ သင် တို့သား သမီး များကို တန်ဆာဆင် စေသဖြင့် ၊ အဲဂုတ္တု လူတို့၏ဥစ္စာကို လုယူ ကြလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","မောရှေ ကလည်း ၊ ထိုသူတို့သည် အကျွန်ုပ် ကို မ ယုံ ၊ အကျွန်ုပ် စကား ကို နား မ ထောင်ဘဲနေ၍ ၊ ထာဝရဘုရား သည် သင့် အား ထင်ရှား တော်မ မူဟု ဆို ကြပါ လိမ့်မည်ဟု ပြန်လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ထာဝရဘုရား ကလည်း ၊ သင် ၏လက် ၌ အဘယ် အရာရှိသနည်းဟုမေး တော်မူလျှင်၊ လှံတံ ရှိပါ၏ဟု လျှောက် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","မြေ ပေါ် မှာပစ်ချ လော့ဟု မိန့် တော်မူသည်အတိုင်း ပစ်ချ သဖြင့် ၊ လှံတံသည် မြွေ ဖြစ် ၍ ၊ မောရှေ သည် သူ့ ရှေ့ မှ ပြေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ထာဝရဘုရား ကလည်း ၊ သင့် လက် ကိုဆန့် ၍ သူ့ အမြီး ကို ကိုင် ဘမ်းလော့ဟု မိန့်တော်မူသည်အတိုင်း ၊ မောရှေသည် လက် ကိုဆန့် ၍ ဘမ်း မိသဖြင့် ၊ သူ ၏လက် ၌ လှံတံ ဖြစ် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","သို့ပြုလျှင် သူ တို့ဘိုးဘေး များ၏ ဘုရား သခင်၊ အာဗြဟံ ၏ဘုရား ၊ ဣဇာက် ၏ဘုရား ၊ ယာကုပ် ၏ဘုရား တည်းဟူသောထာဝရဘုရား သည် သင့် အား ထင်ရှား တော်မူကြောင်း ကို ထိုသူတို့သည် ယုံ ကြလိမ့်မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","တဖန် ထာဝရဘုရား က၊ သင် ၏လက် ကိုသင် ၏ ရင်ခွင် သို့ သွင်း လော့ဟု မိန့် တော်မူသည်အတိုင်း ၊ လက် ကို ရင်ခွင် သို့ သွင်း ၍ ထုတ် ပြန်သောအခါ ၊ လက် သည် မိုဃ်းပွင့် အဆင်းကဲ့သို့ နူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","တဖန် သင် ၏လက် ကို သင့် ရင်ခွင် သို့ သွင်း ဦးလော့ဟု မိန့် တော်မူသည်အတိုင်း ၊ တဖန် လက် ကို ရင်ခွင် သို့ သွင်း၍ ထုတ် ပြန်သောအခါ ၊ ပကတိအသား ဖြစ် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ထိုသူတို့သည် သင့် ကို မ ယုံ ၊ ပဌမ နိမိတ် သက်သေကို နား မ ထောင်လျှင် ၊ နောက် ဖြစ်သော နိမိတ် သက်သေကို ယုံ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","သို့မဟုတ် ထို နိမိတ် နှစ် ပါးကို မ ယုံ ၊ သင် ၏ စကား ကို နား မ ထောင်လျှင် ၊ သင်သည် မြစ် ရေ အချို့ကို ယူ ၍ ကုန်း ပေါ်မှာသွန်း လော့။ ထိုသို့ မြစ် ထဲက ယူ သော ရေ သည် ကုန်း ပေါ်မှာ အသွေး ဖြစ် လိမ့်မည်ဟု မိန့်တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","မောရှေ ကလည်း ၊ အို ဘုရား ရှင်၊ အကျွန်ုပ် သည် နှုတ် သတ္တိမ ရှိပါ။ အထက် ကလည်း မရှိပါ။ ကိုယ်တော် ကျွန် အား မိန့် တော်မူသောအခါ၌ပင် မရှိပါ။ နှုတ် လေး သောသူ၊ စကား နှေးနှေး ပြောတတ်သောသူဖြစ် ပါ၏ဟု ထာဝရဘုရား အား လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ထာဝရဘုရား ကလည်း၊ လူ ၏နှုတ် ကို အဘယ်သူ ဖန်ဆင်း သနည်း။ စကားအ သောသူ၊ နားပင်း သောသူ၊ မျက်စိမြင် သောသူ၊ မမြင် သောသူတို့ကို အဘယ်သူ ဖန်ဆင်း သနည်း။ ငါ ထာဝရဘုရား ဖန်ဆင်းသည် မဟုတ် လော။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","သို့ဖြစ်၍ ယခု သွားလော့။ သင် ၏ နှုတ် ၌ ငါ ရှိ ၍ ၊ သင် သည် အဘယ်သို့ ပြော ရမည်ကို သွန်သင် မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","မောရှေကလည်း၊ အို ဘုရား ရှင်၊ အလိုတော်ရှိသောသူ၏လက်တွင် ပေး လိုက်တော်မူပါဟု လျှောက် သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ထာဝရဘုရား သည် မောရှေ အား အမျက် တော်ထွက်၍ ၊ လေဝိ လူ အာရုန် သည် သင် ၏အစ်ကို ဖြစ်သည် မဟုတ် လော။ သူ သည် ကောင်းမွန် စွာပြောတတ်သည်ကို ငါသိ ၏။ သူ သည်လည်း သင့် ကိုခရီးဦးကြို ပြုခြင်းငှါ ယခုလာ ၏။ တွေ့ မြင်သောအခါ ဝမ်းမြောက် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","သင်သည် သူ နှင့် စကားပြော ၍ ၊ သူ ပြောစရာစကား ကိုပေး ရမည်။ သင် ၏နှုတ် ၌ ၎င်း ၊ သူ ၏နှုတ် ၌ ၎င်း ငါ ရှိ ၍ ၊ သင် တို့သည် အဘယ်သို့ ပြု ရမည်ကို သွန်သင် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","သူ သည်လည်း လူ တို့ရှေ့မှာ သင် ၏ စကားပြန် လုပ်၍ ၊ သင် ၏ နှုတ် ကိုယ်စားဖြစ် လိမ့်မည်။ သင် သည် လည်း သူ ၏ဘုရား သခင်ကိုယ်စားဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","သင်သည် နိမိတ် သက်သေတို့ကို ပြ လတံ့သော ဤ လှံတံ ကိုလည်း၊ သင် ၏လက် ၌ ကိုင် ရမည်ဟု မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","မောရှေ သည်လည်း ယောက္ခမ ယေသရော ထံသို့ ပြန် သွား၍ ၊ အဲဂုတ္တု ပြည်၌ ရှိသောကျွန်ုပ် အမျိုးသား ချင်းတို့သည် အသက်ရှင် သေးသလောဟုကြည့်ရှု ခြင်းငှါ၊ သူတို့ရှိရာသို့ ကျွန်ုပ်သွား ရသောအခွင့်ကိုပေး ပါလော့ဟု ဆို သော်၊ ယေသရော က၊ ငြိမ်ဝပ် စွာ သွား လော့ဟု ပြန်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ထာဝရဘုရား ကလည်း၊ အဲဂုတ္တု ပြည်သို့ ပြန် သွားလော့။ သင် ၏အသက် ကို ရှာ သောသူ အပေါင်း တို့သည် သေ ကြပြီဟု မိဒျန် ပြည်၌ မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ထိုအခါ ၊ မောရှေ သည် မယား နှင့် သား နှစ်ယောက်တို့ကို ယူ ၍ မြည်း ကိုစီး စေသဖြင့် ၊ ဘုရား သခင်၏ လှံတံ တော်ကိုလက် စွဲ လျက် ၊ အဲဂုတ္တု ပြည် သို့ ပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ထာဝရဘုရား ကလည်း ၊ သင် သည် အဲဂုတ္တု ပြည်သို့ သွား ၍ ရောက် လျှင် ၊ သင် ၌ ငါအပ် သော အံ့ဘွယ် သော အမှုအလုံးစုံ တို့ကို ဖါရော ဘုရင်ရှေ့ မှာ ပြ လော့။ ထိုသို့ပြသော်လည်းသူ ၏နှလုံး ကို ငါ ခိုင်မာ စေ၍၊ သူသည် ဣသရေလလူ တို့ကို မ လွှတ် ဘဲ နေလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ဖါရော ဘုရင်ကို လည်း ထာဝရဘုရား က ဣသရေလ သည် ငါ့ သား ဖြစ်၏။ ငါ့ သားဦး ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ငါ့ သား သည် ငါ့ အားဝတ်ပြု သောအခွင့် ရှိစေခြင်းငှါ လွှတ် လော့။ မလွှတ်ဘူးဟု ငြင်း လျှင်၊ သင် ၏သား ၊ သင် ၏သားဦး ကိုပင် ငါ ကွပ်မျက် မည်ဟု မိန့် တော်မူကြောင်းကို ဆင့်ဆို လော့ဟု မောရှေ အား မှာ ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ခရီး သွား စဉ်တွင် ၊ စားခန်း စရပ်၌ ထာဝရဘုရား သည် မောရှေ ကိုတွေ့ ၍ ကွပ်မျက် ခြင်းငှါရှာကြံ တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ထိုအခါ ၊ ဇိပေါရ သည် ထား ကိုယူ ၍ သား ၏ အရေဖျား ကို လှီးဖြတ် ပြီးမှ ၊ လင် ၏ခြေ ရင်း၌ ပြပ်ဝပ်လျက် ၊ အကယ် စင်စစ်သင် သည် အကျွန်ုပ် ၌ အသွေး နှင့်ယှဉ်သော လင် ဖြစ်သည်ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ထိုအခါ မောရှေ ကို လွှတ် တော်မူ၏။ မယားကလည်း ၊ အရေဖျား လှီးမင်္ဂလာကြောင့် ၊ သင်သည် အကျွန်ုပ်၌ အသွေး နှင့်ယှဉ်သောလင် ဖြစ်၏ဟု ဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ထာဝရဘုရား ကလည်း ၊ မောရှေ ကို ခရီးဦးကြိုပြု ခြင်းငှါ တော သို့သွား လော့ဟု အာရုန် အား မိန့် တော်မူသည် အတိုင်း ၊ အာရုန်သည်သွား လျှင် ၊ ဘုရား သခင်၏ တောင် ပေါ်၌ မောရှေ ကို တွေ့ ၍ နမ်း ခြင်းကို ပြု၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","မောရှေ သည်လည်း ၊ မိမိ ကိုစေလွှတ် တော်မူသော ထာဝရဘုရား ၏စကား တော်အလုံးစုံ တို့ကို၎င်း ၊ မှာ ထားတော်မူသမျှသော နိမိတ် သက်သေတို့ကို၎င်း၊ အာရုန် အား ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ထို သူညီနောင်နှစ်ပါးတို့သည် သွား ၍ ဣသရေလ အမျိုးသား အသက်ကြီး သူတို့ကို စုဝေး စေပြီးလျင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","အာရုန် သည် မောရှေ အား ထာဝရဘုရား မိန့် တော်မူသော စကား တော်အလုံးစုံ တို့ကို ပြန်ပြော ၍ ၊ လူ တို့ရှေ့ မှာ နိမိတ် သက်သေတို့ကိုပြ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ထိုလူ များတို့သည် ယုံ ကြ၏။ ထာဝရဘုရား သည် ဣသရေလ အမျိုးသား တို့ကို အကြည့် အရှုကြွတော်မူသည် ကို ၎င်း ၊ သူ တို့ခံရသောဆင်းရဲ ခြင်းကို မှတ် တော်မူသည်ကို ၎င်းကြား သောအခါ ၊ ဦးညွှတ် ချ၍ ကိုးကွယ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ထိုနောက်မှ ၊ မောရှေ နှင့် အာရုန် သည် ဖါရော ဘုရင်ထံသို့ ဝင် ၍ ၊ ဣသရေလ အမျိုး၏ ဘုရား သခင်ထာဝရဘုရား က၊ ငါ ၏လူ တို့သည် တော ၌ ငါ့ အဘို့ ပွဲခံ စေခြင်းငှါ လွှတ် ရမည်ဟု မိန့် တော်မူကြောင်းကို လျှောက် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ဖါရော မင်းကလည်း ၊ ထာဝရဘုရား ၏စကား ကို နားထောင် ၍ ၊ ဣသရေလ အမျိုးသားတို့ကို ငါလွှတ် စေ ခြင်းငှါ ထိုဘုရားကား အဘယ်သူနည်း။ ထာဝရဘုရား ကို ငါမ သိ ၊ ဣသရေလ အမျိုးသားတို့ကို ငါမ လွှတ် ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","သူတို့ကလည်း၊ ဟေဗြဲ လူတို့၏ ဘုရား သခင်သည် ကျွန်တော် တို့နှင့် တွေ့ တော်မူပြီ။ တော သို့ သုံး ရက် ခရီး သွား ၍ ၊ ကျွန်တော် တို့ ဘုရား သခင်ထာဝရဘုရား အား ယဇ်ပူဇော် ရသောအခွင့်ကိုပေး တော်မူပါ။ သို့မဟုတ် ကာလနာ ဘေး၊ ထား ဘေးတစုံတခုဖြင့် ကျွန်တော် တို့ကို ဒဏ်ခတ် တော်မူလိမ့်မည်ဟု လျှောက် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","အဲဂုတ္တု ရှင်ဘုရင် ကလည်း ၊ မောရှေ နှင့် အာရုန် ၊ သင်တို့သည် ဤလူ များတို့ကို အဘယ်ကြောင့် အလုပ် ပြတ် စေသနည်း။ အမှု တော်ကို သွား ၍ ဆောင်ရွက်ကြဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","တဖန် လည်း ပြည် တော်၌ ထိုလူ တို့သည် ယခု များ ကြ၏။ အမှု မထမ်း စေခြင်းငှါသင်တို့သည် အခွင့်ပေး ကြသည်တကားဟု ဖါရော ဘုရင်ဆို ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ထိုနေ့ ခြင်းတွင် အအုပ်အချုပ် ၊ အကြပ်အဆော်တို့ကို ခေါ်ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","အုတ် လုပ် စရာဘို့ ကောက်ရိုး ကို လူ တို့အား အရင် ပေးသကဲ့သို့ မ ပေး နှင့်။ သူ တို့သည် ကောက်ရိုး ကို ကိုယ် ဘို့ ရှာ ယူကြစေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","အုတ် ကိုကား၊ အရေအတွက် အားဖြင့်အရင် ကဲ့သို့လုပ် စေရမည်၊ အလျှင်းမ လျော့ စေနှင့်။ သူ တို့သည် ပျင်းရိ ကြ၏။ ထိုကြောင့် သွား ၍ငါ တို့ ဘုရား သခင်အား ယဇ်ပူဇော် ကြစို့ဟု ကြွေးကြော် တတ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","သို့ဖြစ်၍စည်းကြပ်လျက် လုပ် စေကြ။ ပင်ပန်း စေကြ။ လူမိုက် စကား ကို နား မ ထောင်စေနှင့်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","အအုပ်အချုပ် အကြပ်အဆော် တို့သည် ထွက် ၍ ၊ ဖါရော ဘုရင်က ကောက်ရိုး ကိုငါ မ ပေး။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ကောက်ရိုး ကို တွေ့ နိုင်ရာအရပ် ၌ ရှာ ကြ။ သို့သော်လည်း လုပ်ရသောအလုပ် အလျှင်းမ လျော့ ရဟု အမိန့် တော်ရှိသည်ဟု လူ တို့အား ပြန်ကြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","သို့ဖြစ်၍ လူ တို့သည် ကောက်ရိုး အတွက် အမှိုက် ကို ရှာ ယူခြင်းငှါ အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် အရပ်ရပ်ကွဲပြား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","အုပ်ချုပ် သောသူတို့ ကလည်း ၊ ကောက်ရိုး ကို ရ သည်ကာလ၌ နေ့ တိုင်းလုပ် ရသည်အတိုင်း ၊ ပြီး အောင် လုပ်ကြဟု သူတို့ကိုနှိုးဆော် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ဖါရော မင်း၏ အအုပ်အချုပ် တို့သည် ခန့် ထားသော ဣသရေလ အမျိုး အကြပ်အဆော် တို့ကို သင်တို့သည် အရင် ကလုပ်သည်အတိုင်း ၊ ယနေ့ နှင့်မနေ့ ၌ အုတ် လုပ်ရသောအမှု ကို အဘယ်ကြောင့် မ ပြီးစီး စေကြ သနည်းဟု စစ်၍ရိုက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ထိုအခါ၊ ဣသရေလ အမျိုး အကြပ်အဆော် တို့သည်၊ ဖါရော မင်းထံသို့ သွား ၍ ၊ ကိုယ်တော်သည် ကိုယ်တော် ကျွန် တို့ကို အဘယ်ကြောင့် ဤသို့ စီရင် တော်မူသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ကိုယ်တော် ကျွန် တို့အား ၊ ကောက်ရိုး ကိုမ ပေး ၊ အုပ်ချုပ်သောသူတို့ ကလည်း၊ အုတ် ကိုလုပ် ကြဟု ဆို သဖြင့်၊ ကျွန်တော်တို့သည် အရိုက် ခံရကြပါ၏။ ကိုယ်တော် လူ တို့၌သာ အပြစ် ရှိပါသည်ဟု အော်ဟစ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ဖါရောဘုရင်ကလည်း ၊ သင် တို့သည် ပျင်းရိ သည်၊ ပျင်းရိ သည်။ ထိုကြောင့် ငါတို့သည်သွား ၍ ထာဝရဘုရား အား ယဇ်ပူဇော် ကြစို့ဟု သင် တို့ဆို တတ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","သို့သောကြောင့် ယခု သွား ၍လုပ် ကြ။ ကောက်ရိုး ကိုမ ပေး ရ။ သို့သော်လည်းအုတ် ကိုပေးမြဲပေး ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ထိုသို့ နေ့ တိုင်းလုပ်ရသောအုတ် အရေအတွက်၌ အလျှင်းမ လျော့ ရဟု အမိန့်တော်ရှိသည်ဖြစ်၍၊ ဣသရေလ အမျိုး အကြပ်အဆော် တို့သည် မိမိ တို့၌ အမှုကြီးရောက်ကြောင်းကို သိမြင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ဖါရော မင်းထံ မှ ထွက်သွား ကြစဉ် ၊ လမ်း၌ စောင့် လျက်နေသောမောရှေ နှင့် အာရုန် ကို တွေ့ လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ထာဝရဘုရား သည် သင် တို့ကို ကြည့်ရှု ၍ စီရင် တော်မူပါစေသော။ အကြောင်းမူကား၊ ဖါရော မင်းနှင့် အမှု တော်ထမ်းအပေါင်းတို့သည် ငါ တို့ကို ရွံရှာ စေခြင်းငှါ ၎င်း၊ ငါ တို့ကိုသတ် ရသောအခွင့်ရှိစေခြင်းငှါ ၎င်း၊ သင်တို့သည် ပြုကြပြီတကားဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","မောရှေ သည်လည်း ၊ ထာဝရဘုရား ထံ တော်သို့သွား ၍ ၊ အိုဘုရား ရှင်၊ ကိုယ်တော်သည် ဤ လူမျိုး ကို အဘယ်ကြောင့် ညှဉ်းဆဲ တော်မူသနည်း။ အကျွန်ုပ် ကို အဘယ်ကြောင့် စေလွှတ် တော်မူသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","အကျွန်ုပ်သည် ကိုယ်တော်အခွင့် နှင့် ပြော ခြင်းငှာ ၊ ဖါရော မင်း ထံ သို့ဝင် သည်နေ့မှစ၍ ၊ သူသည် ဤ လူမျိုး ကို ညှဉ်းဆဲ ပါပြီ။ ကိုယ်တော်သည် ကိုယ်တော် ၏ လူ တို့ကို အလျှင်းကယ်လွှတ် တော်မ မူပါဟု လျှောက် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ထာဝရဘုရား ကလည်း ၊ ငါသည် ဖါရော မင်း၌ အဘယ်သို့ ပြု မည်ကို သင်သည် ယခု သိ လိမ့်မည်။ သူသည် ကြီးစွာ သောတန်ခိုး ကို တွေ့မြင်၍၊ ငါ၏လူ တို့ကို လွှတ် ရလိမ့်မည်။ ကြီးစွာ သော တန်ခိုး ကို တွေ့မြင်၍ သူ တို့ကို မိမိ ပြည် မှ နှင် ရလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","တဖန် ဘုရား သခင်သည် မောရှေ ၌ ဗျာဒိတ် ထားတော်မူသည်ကား၊ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ငါသည် အာဗြဟံ ၊ ဣဇာက် ၊ ယာကုပ် တို့အား ၊ အနန္တ တန်ခိုးရှင်၊ ဘုရား သခင်နာမနှင့် ထင်ရှား သော်လည်း ၊ ထာဝရဘုရား နာမ အားဖြင့်သူ တို့သည် ငါ့ကို မ သိ ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","သူ တို့သည် အရပ်ရပ်လည် ၍၊ ဧည့်သည်နေရာပြည် ၊ ခါနာန် ပြည် ကို သူ တို့အား ပေး ခြင်းငှါ ၊ သူ တို့နှင့် ငါ ပြုသောပဋိညာဉ် ကို ငါတည် စေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","အဲဂုတ္တု လူတို့သည် အစေ ကျွန်ခံစေသော ဣသရေလ အမျိုးသားတို့၏ ညဉ်းတွား မြည်တမ်းခြင်းအသံကို ငါ ကြား ရပြီ။ ငါ ပဋိညာဉ် ကိုလည်း ငါအောက်မေ့ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ထိုကြောင့်ဣသရေလ အမျိုးသားတို့အား ပြောရသောစကားဟူမူကား၊ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ငါသည်လည်း သင်တို့ကို အဲဂုတ္တု လူတို့လက် မှ လွှတ် ၍ ၊ သူ တို့၏ ညှဉ်းဆဲ ခြင်းထဲက နှုတ်ယူ မည်။ လက် ဆန့် ခြင်း၊ ကြီးစွာ သော ဒဏ်ခတ် ခြင်းအားဖြင့် သင် တို့ကို ငါရွေး မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ငါ ၏လူမျိုး ဖြစ်စေခြင်းငှါ ၊ သင် တို့ကို ငါသိမ်းယူ မည်။ ငါသည်လည်း သင် တို့၏ ဘုရား သခင်ဖြစ် မည်။ ငါ သည်သင် တို့ကို အဲဂုတ္တု လူတို့လက် မှ လွှတ် သော သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်ကြောင်းကို သင်တို့သိ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ငါသည်လည်း ၊ အာဗြဟံ ၊ ဣဇာက် ၊ ယာကုပ် တို့ အား ပေး မည်ဟု ကျိန်ဆိုသောပြည် သို့ ငါပို့ဆောင် ၍ ၊ အမွေ ခံစရာဘို့ ပေး မည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ထိုသို့မောရှေ သည် ဣသရေလ အမျိုးသားတို့အား ဆင့်ဆို သော်လည်း ၊ သူတို့သည် အလွန်စိတ် ပင်ပန်း ၍ ကြမ်းတမ်း စွာ ညှဉ်းဆဲခြင်း ကို ခံရသောကြောင့် ၊ မောရှေ စကားကို နား မ ထောင်ဘဲနေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ထာဝရဘုရား ကလည်း ၊ အဲဂုတ္တု ရှင်ဘုရင် ဖါရော မင်းထံ သို့ဝင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","သူသည် ဣသရေလ အမျိုးသားတို့ကို မိမိ ပြည် မှ လွှတ် ရမည်အကြောင်း ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","မောရှေ ကလည်း ၊ ဣသရေလ အမျိုးသားတို့သည် အကျွန်ုပ် ပြောသောစကားကို နား မ ထောင်ဘဲ နေသည်ဖြစ်၍ ၊ အရေဖျား လှီးခြင်းကို မခံသောနှုတ် နှင့် ပြောတတ်သော အကျွန်ုပ် ၏စကားကို ဖါရော မင်းသည် အဘယ်သို့ နားထောင် ပါမည်နည်းဟု ထာဝရဘုရား ရှေ့မှာ လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","သို့ရာတွင်မောရှေ နှင့် အာရုန် သည် ဣသရေလ အမျိုးသားတို့ကိုအဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် ရမည် အကြောင်း၊ ထာဝရဘုရား သည် သူတို့ကိုခေါ်၍ ဣသရေလ အမျိုးသားတို့ထံသို့ ၎င်း၊ အဲဂုတ္တု ရှင်ဘုရင် ဖါရော မင်းထံသို့ ၎င်း စေခိုင်း မှာ ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ဣသရေလ အဆွေအမျိုး သူကြီး တို့၏ အမည်ဟူမူကား၊ ဣသရေလ သားဦး ရုဗင် ၏သား ကား၊ ဟာနုတ် ၊ ဖါလု ၊ ဟေဇရုံ ၊ ကာမိ တည်း။ ဤ သူတို့သည် ရုဗင် အမျိုးအနွယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ရှိမောင် ၏သား ကား၊ ယမွေလ ၊ ယာမိန် ၊ ဩဟဒ် ၊ ယာခိန် ၊ ဇောဟာ ၊ ခါနာန် အမျိုးသမီးမိန်းမ၏သား ရှောလ တည်း။ ဤ သူတို့သည် ရှိမောင် အမျိုးအနွယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","လေဝိ သား အဆွေအမျိုး အလိုက်ဟူမူကား ၊ ဂေရရှုံ ၊ ကောဟတ် ၊ မေရာရိ တည်း။ လေဝိ အသက် သည် အနှစ် တရာ သုံးဆယ် ခုနစ် နှစ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ဂေရရှုံ သား အဆွေအမျိုး အလိုက် ဟူမူကား၊ လိဗနိ နှင့် ရှိမိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ကောဟတ် သား ကား၊ အာမရံ ၊ ဣဇဟာ ၊ ဟေဗြုန် ၊ ဩဇေလ တည်း။ ကောဟတ် အသက် သည် အနှစ် တရာ သုံးဆယ် သုံး နှစ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","မေရာရိ သား ကား၊ မဟာလိ နှင့် မုရှိ တည်း။ ဤ သူတို့သည် လေဝိ အဆွေအမျိုး အသီးအသီးဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","အာမရံ သည် မိမိ အရီး ယောခေဗက် နှင့် စုံဘက် ၍ ၊ သူ သည် အာရုန် နှင့် မောရှေ ကို၎င်း၊ သူတို့အစ်မမိရိအံကို၎င်းဘွား လေ၏။ အာမရံ အသက် သည် အနှစ် တရာ သုံးဆယ် ခုနစ် နှစ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ဣဇဟာ သား ကား၊ ကောရ ၊ နေဖက် ၊ ဇိခရိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ဩဇေလ သား ကား၊ မိရှေလ ၊ ဧလဇာဖန် ၊ သိသရိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","အာရုန် သည် အမိနဒပ် သမီး ၊ နာရှုန် နှမ ဧလိရှဘ နှင့် စုံဘက် ၍ ၊ သူသည်နာဒပ် ၊ အဘိဟု ၊ ဧလဇာ ၊ ဣသမာ တို့ကို ဘွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ကောရ သား ကား၊ အဿိရ ၊ ဧလကာန ၊ အဗျာသပ် တည်း။ ဤ သူတို့သည် ကောရ အဆွေအမျိုး ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","အာရုန် သား ဧလဇာ သည် ပုတျေလ သမီး တယောက်နှင့်စုံဘက် ၍ ၊ သူသည် ဖိနဟတ် ကိုဘွား လေ၏။ ဤ သူတို့သည် လေဝိ အမျိုး၊ အသီးအသီးတို့၏ အဆွေအမျိုး သူကြီး ဖြစ်ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ထာဝရဘုရား က ဣသရေလ အမျိုးသား ဗိုလ်ပါတို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် လော့ဟု မိန့် တော်မူသောစကားကိုခံ သောသူ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ဣသရေလ အမျိုးသား တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် ခြင်းငှါ ၊ အဲဂုတ္တု ရှင်ဘုရင် ဖါရော မင်းထံ ၌ လျှောက် ရသောသူ တို့သည်၊ ထို အာရုန် နှင့် မောရှေ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","အဲဂုတ္တု ပြည် မှာ ထာဝရဘုရား သည်၊ မောရှေ အား ဗျာဒိတ် ထားတော်မူသောနေ့ရက် ၌ လည်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ငါ မှာ လိုက်သမျှတို့ကို ၊ အဲဂုတ္တု ရှင်ဘုရင် ဖါရော မင်းအား ပြန်ပြော ရမည်ဟု မောရှ အား ထာဝရဘုရား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","မောရှေ ကလည်း ၊ အကျွန်ုပ် သည် အရေဖျား လှီးခြင်းကို မခံသောနှုတ် ရှိသည်ဖြစ်၍ ၊ ဖါရော ဘုရင်သည် အကျွန်ုပ် စကားကို အဘယ်သို့ နားထောင် ပါလိမ့်မည်နည်းဟု ထာဝရဘုရား ရှေ့ မှာ လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ထာဝရဘုရား ကလည်း၊ သို့ဖြစ်၍ သင့် ကိုဖါရော ဘုရင်၏ ဘုရား အရာ၌ ငါခန့် ထား၏။ သင် ၏အစ်ကို အာရုန် သည်၊ သင် ၏ပရောဖက် ဖြစ် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ငါမိန့် တော်မူသမျှ တို့ကို သင် သည် ပြန်ပြော ရမည်။ ဖါရောဘုရင်သည် ဣသရေလ အမျိုးသား တို့ကို မိမိ ပြည် မှ လွှတ် လိုက်ရမည်အကြောင်း ကို၊ သင် ၏အစ်ကို အာရုန် သည် သူ့ ထံ၌ လျှောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ငါ သည်လည်း ဖါရော မင်း၏ နှလုံး ကို ခိုင်မာ စေ၍ ၊ အဲဂုတ္တု ပြည် ၌ ငါ ၏နိမိတ် လက္ခဏာ အံ့ဘွယ် သော အမှုတို့ကို များပြား စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","သို့သော်လည်း ဖါရော မင်းသည် သင် တို့စကားကို နား မ ထောင်ဘဲနေလိမ့်မည်။ ငါသည်လည်း ငါ့ လက် ကို အဲဂုတ္တု ပြည်အပေါ် မှာတင် ၍ ကြီးစွာ သောဒဏ်ခတ် ခြင်းအားဖြင့် ငါ ၏ဗိုလ်ပါ များ၊ ငါ ၏လူ ဣသရလ အမျိုးသား တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ထိုသို့ အဲဂုတ္တု ပြည်အပေါ် မှာ ငါ့ လက် ကိုဆန့် ၍ ၊ ဣသရေလ အမျိုးသား တို့ကို သူ တို့အထဲ မှ နှုတ်ဆောင် သောအခါ ၊ ငါ သည် ထာဝရဘုရား ဖြစ်ကြောင်းကို အဲဂုတ္တု လူတို့သည် သိ ကြလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","မောရှေ နှင့် အာရုန် တို့သည် ထာဝရဘုရား မိန့် တော်မူသမျှ အတိုင်း ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ဖါရော ဘုရင်ထံ ၌ လျှောက် ကြသောအခါ ၊ မောရှေ ၏အသက် သည် အနှစ် ရှစ်ဆယ် ရှိ၏။ အာရုန် ၏ အသက် သည် အနှစ် ရှစ်ဆယ် သုံး နှစ်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် တို့အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ဖါရော ဘုရင်က၊ သင် တို့အတွက် ထူးဆန်း သော တန်ခိုးကို ပြ လော့ဟုဆို လျှင် ၊ သင် ၏ လှံတံ ကိုယူ ၍ ရှေ့တော်၌ချ လော့ဟု အာရုန် အား ပြော လော့။ လှံတံသည်လည်း မြွေ ဖြစ် လိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","မောရှေ နှင့် အာရုန် သည် ဖါရော ဘုရင်ထံ သို့ဝင် ၍ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ပြု သဖြင့်၊ အာရုန် သည် ဖါရော ဘုရင်ရှေ့၊ သူ ၏ကျွန် များရှေ့ မှာ လှံတံ ကိုချ ၍ မြွေ ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ထိုအခါ ဖါရော ဘုရင်သည် ပညာရှိ များ၊ ပြုစား တတ်သောသူများတို့ကိုခေါ် ၍ ၊ အဲဂုတ္တု အမျိုး ဝိဇ္ဇာဆရာ တို့သည်၊ ဝိဇ္ဇာအတတ် အားဖြင့် ထိုအတူ ပြု ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","မိမိ တို့ကိုင်သော လှံတံ များကိုချ ၍ မြွေ ဖြစ် ကြလေ၏။ သို့သော်လည်း အာရုန် ၏လှံတံ သည် သူ တို့၏ လှံတံ များကို မျို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ ဖါရော ဘုရင်သည် နှလုံး ခိုင်မာ ၍ သူ တို့၏စကားကို နား မ ထောင်ဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ဖါရော ဘုရင်သည် နှလုံး ခိုင်မာ ၍ ဣသရေလလူ တို့ကို မ လွှတ်ဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","နံနက် အချိန်၌ ဖါရော ဘုရင်ထံ သို့သွား လော့။ သူသည် ရေ ဆိပ်သို့ သွား လိမ့်မည်။ သူမရောက်မှီ သင် သည် မြစ် ကမ်းနား မှာ ရပ် နေလော့။ မြွေ ဖြစ် သော လှံတံ ကိုလည်း လက် တွင် ကိုင် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ဟေဗြဲ အမျိုးသားတို့၏ ဘုရား သခင်ထာဝရဘုရား က၊ ငါ့ လူ တို့သည်တော ၌ ငါ့ အား ဝတ်ပြု မည် အကြောင်း ၊ သူတို့ကိုလွှတ် လော့ဟု အမိန့်တော်ပါသောကျွန်ုပ် ကို ကိုယ်တော် ထံ သို့စေလွှတ် တော်မူပြီ။ ကိုယ်တော်သည် ယခု တိုင်အောင် နား မ ထောင်ဘဲနေပါသည် တကား။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ထာဝရဘုရား က ၊ ငါ သည် ထာဝရဘုရား ဖြစ်ကြောင်းကို သင်သည်အဘယ်သို့သိ ရမည်နည်းဟူမူကား ၊ ငါ ကိုင် သောလှံတံ နှင့် မြစ် ရေကို ရိုက် ၍ ထိုရေ သည် အသွေး ဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","မြစ် ၌ ရှိသောငါး တို့သည်သေ ကြလိမ့်မည်။ မြစ် ရေလည်း နံ လိမ့်မည်၊ အဲဂုတ္တု လူတို့သည်လည်း မြစ် ရေ ကို ရွံ ကြလိမ့်မည် အကြောင်းကို ပြန်ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","တဖန် ထာဝရဘုရား သည် မောရှေ ကို မိန့်တော်မူပြန်သည်ကား၊ အာရုန် အား သင် ၏လှံတံ ကိုယူ ၍ အဲဂုတ္တု ပြည်၌ရှိသောချောင်း ရေ၊ မြစ် ရေ၊ အိုင် အင်းရေ၊ ကန် ရေ၊ တွင်းရေ ရှိသမျှအပေါ် မှာ လက် ကိုဆန့် လော့။ ထို ရေ ရှိသမျှ တို့သည် အသွေး ဖြစ် လိမ့်မည်။ အဲဂုတ္တု ပြည် တရှောက်လုံး ၊ သစ် ခွက်၊ ကျောက် အိုး၌ မျှ မကြွင်း အသွေး ရှိ လိမ့်မည်အကြောင်းကို ပြော လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","မောရှေ နှင့် အာရုန် သည် ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ပြု ၍ ၊ အာရုန်သည် ဖါရော ဘုရင် ရှေ့ ၊ သူ ၏ကျွန် များရှေ့ မှာ လှံတံ ကိုချီ ၍ မြစ် ရေ ကို ရိုက် သဖြင့် ၊ မြစ် ရေ ရှိသမျှ သည် အသွေး ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","မြစ် ၌ ရှိသောငါး တို့သည်လည်း သေ ကြ၍ ၊ မြစ် ရေနံ သောကြောင့် ၊ အဲဂုတ္တု လူတို့သည် မြစ် ရေ ကို မ သောက် နိုင် ကြ။ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ အသွေး နှံ့ပြားလျက် ရှိ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","အဲဂုတ္တု အမျိုးသားဝိဇ္ဇာဆရာ တို့လည်း ဝိဇ္ဇာအတတ် အားဖြင့် ထိုအတူ ပြု ကြ၏။ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ ဖါရော ဘုရင်သည် နှလုံး ခိုင်မာ ၍ သူ တို့၏စကားကို နား မ ထောင်ဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","နန်းတော် သို့ လှည့်လည် ပြန် သွား၍ ထို အမှုကို နှလုံး မ သွင်း ဘဲ နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ထိုအခါ အဲဂုတ္တု လူတို့သည် မြစ် ရေ ကို မ သောက် နိုင် သောကြောင့် ၊ သောက် ရေ ကိုရခြင်းငှါ မြစ် နား မှာ တွင်းတူး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ထာဝရဘုရား သည်မြစ် ကိုဒဏ်ခတ် ၍ ခုနစ် ရက် ကိုလွန် စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ထာဝရဘုရား ကလည်း ၊ သင်သည် ဖါရော ဘုရင်ထံ သို့ဝင် ၍ ငါ ၏လူ တို့သည် ငါ့ အားဝတ်ပြု မည်အကြောင်း ၊ သူတို့ကိုလွှတ် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","မလွှတ် ဘူးဟုငြင်း လျှင် ၊ သင် ၏ပြည် တရှောက်လုံး ကို ဘား တို့ဖြင့် ဒဏ်ခတ် ဦးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","မြစ် သည်လည်း များစွာ သော ဘား တို့ကိုဘွား၍၊ သူတို့သည် သင် ၏အိမ် ၌၎င်း ၊ အိပ် ခန်း ၌ ၎င်း ၊ အိပ်ရာ ပေါ် ၌၎င်း ၊ သင် ၏ကျွန် တို့ အိမ် ၌ ၎င်း ၊ သင် ၏လူ တို့အပေါ် ၌၎င်း ၊ သင် ၏မီးဖို ၌ ၎င်း ၊ မုန့် နယ်သော ခွက်၌ ၎င်း တက် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","သင် မှစ၍ သင် ၏လူ ၊ သင် ၏ကျွန် ရှိသမျှ တို့ အပေါ် ၌ တက် ကြလိမ့်မည်ဟု ထာဝရဘုရား မိန့် တော်မူသည် အကြောင်းကို ကြားပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့်တော်မူပြန်သည်ကား၊ အာရုန် သည် ချောင်း ရေ၊ မြစ် ရေ၊ အိုင် အင်းရေတို့အပေါ်၌ လှံတံ ကို ကိုင်လျက်၊ လက် ကို ဆန့် ၍ အဲဂုတ္တု ပြည် အပေါ်သို့ ဘား များကို တက် စေ ခြင်းငှါ ပြော လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","အာရုန် သည် အဲဂုတ္တု ပြည်၌ရှိသောရေ အပေါ် မှာ လက် ကိုဆန့် သဖြင့် ၊ ဘား တို့သည်တက် ၍ အဲဂုတ္တု ပြည် တရှောက်လုံးကို ဖုံးလွှမ်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ဝိဇ္ဇာဆရာ တို့သည်လည်း ဝိဇ္ဇာအတတ် အားဖြင့် ထိုအတူ ပြု ၍ ဘား တို့ကို အဲဂုတ္တု ပြည် အပေါ် သို့ ဆောင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ထိုအခါ ဖါရော မင်းသည်၊ မောရှေ နှင့် အာရုန် ကို ခေါ် ၍ ၊ ထာဝရဘုရား သည် ဘား တို့ကိုငါ နှင့် ငါ့ လူ တို့ ထံမှ ပယ်ရှား တော်မူမည်အကြောင်း တောင်းပန် လော့။ ဣသရေလလူ တို့သည် ထာဝရဘုရား အား ယဇ်ပူဇော် ရသောအခွင့် ကို ငါပေးမည်ဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","မောရှေ ကလည်း ၊ ကိုယ်တော် နှင့် ကိုယ်တော် အိမ် များမှ ဘား တို့ကို ပယ်ရှင်း ဖျက်ဆီး၍၊ မြစ် ၌ သာ နေ စေ ခြင်းငှါ၊ ကိုယ်တော် နှင့် ကိုယ်တော် ကျွန် များ၊ လူ များအဘို့ အကျွန်ုပ်တောင်းပန် ရသောအချိန် ကို ချိန်းချက် တော်မူပါဟု လျှောက် သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","နက်ဖြန် နေ့ တောင်းပန်လော့ဟု မိန့် တော်မူသည်ဖြစ်၍ ၊ မောရှေက၊ အကျွန်ုပ် တို့ဘုရား သခင်ထာဝရဘုရား နှင့်တူ သော ဘုရားမရှိ ကြောင်းကို ကိုယ်တော်သိ စေခြင်းငှါ အမိန့် တော်အတိုင်း ဖြစ်၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ဘား တို့သည်ကိုယ်တော် နှင့် ကိုယ်တော် အိမ် များ၊ ကျွန် များ၊ လူ များထံမှ ထွက် သွား၍ မြစ် ၌ သာ နေ ကြလိမ့်မည်ဟု မောရှေလျှောက် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","အာရုန် နှင့်အတူ အထံတော်မှ ထွက်သွား ၍ ၊ ဖါရော ဘုရင်အပေါ် သို့ ထာဝရဘုရား ဆောင် တော်မူ သောဘား တို့အကြောင်း ကြောင့် ၊ မောရှေ သည် ဆုတောင်း ပဌနာပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ထာဝရဘုရား သည် မောရှေ တောင်း လျှောက်သော စကားအတိုင်း ပြု တော်မူသဖြင့် ၊ ဘား တို့သည် အိမ် များ၊ ရွာ များ၊ လယ်ပြင် များတို့တွင် သေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","အသေကောင် တို့ကို စုပုံ ၍ထားသဖြင့် တပြည် လုံး နံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ဖါရော မင်းလည်း၊ သက်သာ ရကြောင်းကို သိမြင် သောအခါ ၊ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ နှလုံး ခိုင်မာ ၍ သူ တို့စကားကို နား မ ထောင်ဘဲ နေပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ ရှိသောမြေမှုန့်သည် ခြင် ကောင်ဖြစ် စေခြင်းငှါ ၊ အာရုန် သည် လှံတံ ကိုကိုင်လျက် လက်ကိုဆန့် ၍၊ မြေမှုန့် ကို ရိုက် စေ ခြင်းငှါ ပြော လော့ဟု မိန့်တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","အာရုန် သည် လှံတံ ကိုကိုင်လျက် လက် ကိုဆန့် ၍ မြေမှုန့် ကို ရိုက် လေ၏။ မြေမှုန့်သည်လည်း လူ ၌ ၎င်း ၊ တိရစ္ဆာန် ၌ ၎င်း ခြင် ကောင်ဖြစ် လေ၏။ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ မြေမှုန့် ရှိသမျှ သည် ခြင် ကောင်ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ဝိဇ္ဇာဆရာ ကိုလည်း ၊ ခြင် ကောင်တို့ကို ဖြစ် စေ ခြင်းငှါ ဝိဇ္ဇာအတတ် အားဖြင့် ထိုအတူ ပြု ၍ မ တတ် နိုင် ကြ။ သို့ဖြစ်၍ လူ တို့နှင့် တိရစ္ဆာန် တို့၌ ခြင် ကောင်တို့သည် ရှိ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ထိုအခါ ဝိဇ္ဇာဆရာ တို့က၊ ဤ အမှုသည် ဘုရား သခင် ၏ တန်ခိုး ကြောင့်ဖြစ်သည်ဟု ဖါရော ဘုရင်အား လျှောက် ကြားကြ၏။ သို့သော်လည်း ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ ဖာရော ဘုရင်သည် နှလုံး ခိုင်မာ ၍ သူ တို့စကားကို နား မ ထောင်ဘဲနေပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ထာဝရဘုရား ကလည်း ၊ သင်သည် နံနက် စောစော ထလော့။ ရေ ဆိပ်သို့ ထွက်သွား သော ဖါရော ဘုရင်ရှေ့မှာ ရပ် ၍ ထာဝရဘုရား က၊ ငါ ၏လူ တို့သည် ငါ့ အား ဝတ်ပြု မည်အကြောင်း ၊ သူတို့ကိုလွှတ် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","မ လွှတ် ဘဲနေလျှင် သင် နှင့် သင် ၏ကျွန် များ၊ လူ များ၊ အိမ် များထဲသို့ ယင်ရဲ တို့ကို ငါ စေလွှတ် သဖြင့် အဲဂုတ္တု လူတို့နေသောအိမ် ၊ ရပ်သောမြေ သည် ယင်ရဲ နှင့်အပြည့် ရှိရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ငါ သည် မြေကြီး အလယ် ၌ ထာဝရဘုရား ဖြစ်ကြောင်းကို သင်သိ စေခြင်းငှါ ငါ ၏လူ တို့နေရာ ဂေါရှင် ပြည် ကို ထို နေ့ ၌ ငါခြားနား စေ၍၊ ထို ပြည်၌ ယင်ရဲ မ ရှိ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ထိုသို့ ငါ ၏လူ တို့နှင့် သင် ၏လူ တို့ကို ငါခြားနား စေ မည်။ နက်ဖြန် နေ့၌ ထို နိမိတ် ထင်ရှား လိမ့်မည်ဟု မိန့် တော်မူကြောင်းကို ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ထိုသို့ ထာဝရဘုရား ပြု တော်မူသဖြင့် ၊ အလွန် ကြမ်းတမ်း သော ယင်ရဲ တို့သည်၊ ဖါရော ဘုရင်အိမ် အစရှိသော သူ ၏ကျွန် တို့အိမ် ၊ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ ရောက် လာ၍၊ ထိုယင်ရဲ တို့ကြောင့် အဲဂုတ္တုပြည် ပျက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ထိုအခါ ၊ ဖါရော ဘုရင်သည် မောရှေ နှင့် အာရုန် ကို ခေါ် ပြီးလျှင် ၊ သင်တို့သည် ဤပြည် ၌ သင် တို့၏ ဘုရား သခင် အား ယဇ်ပူဇော် သွား ကြလော့ဟု မိန့် တော်မူသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","မောရှေ က ထိုသို့ မ ပြု သင့်။ ပြုလျှင်အဲဂုတ္တု လူ တို့၏ ရွံရှာ ဘွယ်သောအရာကို အကျွန်ုပ် တို့ဘုရား သခင်ထာဝရဘုရား အား ယဇ် ပူဇော်ရပါမည်။ အဲဂုတ္တု လူတို့၏ ရွံရှာဘွယ် သောအရာကို သူ တို့မျက်မှောက် ၌ ယဇ်ပူဇော် လျှင် ၊ သူတို့သည် အကျွန်ုပ် တို့ကိုခဲနှင့်ပစ် ကြပါလိမ့်မည်မဟုတ် လော။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","သို့ဖြစ်၍တော ၌ သုံး ရက် ခရီး သွား ၍ အကျွန်ုပ် တို့ဘုရား သခင်ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ယဇ်ပူဇော် ကြပါမည်ဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ဖါရော ဘုရင်ကလည်း ၊ သင် တို့၏ဘုရား သခင်ထာဝရဘုရား အား ၊ တော ၌ ယဇ် ပူဇော်မည်အကြောင်း ၊ သွားရသောအခွင့် ကို ငါ ပေးမည်။ သို့ရာတွင် ဝေး ဝေး မ သွား ရကြ။ ငါ့ အဘို့ တောင်းပန် လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","မောရှေ ကလည်း ၊ အကျွန်ုပ် သည် ကိုယ်တော် ထံ မှ ထွက်သွား ၍ ယင်ရဲ တို့သည် ဖါရော ဘုရင်နှင့် သူ ၏ ကျွန် များ၊ လူ များထံမှ ၊ နက်ဖြန် နေ့သွား မည်အကြောင်း ထာဝရဘုရား ကို တောင်းပန် ပါမည်။ သို့ရာတွင် ဣသရေလ လူ တို့သည် ထာဝရဘုရား အား ယဇ် မပူဇော်ရမည် အကြောင်း ၊ နောက်တဖန် ဆီးတား ၍ လှည့်စား တော် မ မူပါနှင့်ဟု လျှောက် ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ဖါရော ဘုရင်ထံ မှ ထွက် သွား၍ ထာဝရဘုရား ကို တောင်းပန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ထာဝရဘုရား သည်လည်း ၊ မောရှေ စကား ကို နားထောင် ၍ ယင်ရဲ တို့ကို ဖါရော ဘုရင်နှင့်သူ ၏ကျွန် များ၊ လူ များထံမှာ တကောင် မျှ မ ကျန် စေခြင်းငှါ ပယ်ရှား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ထို အခါ ၌ လည်း ၊ ဖါရော ဘုရင်သည် နှလုံး ခိုင်မာ ပြန်၍ ၊ ဣသရေလလူ တို့ကို မ လွှတ် ဘဲနေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ထာဝရဘုရား ကလည်း ၊ သင်သည် ဖါရော ဘုရင် ထံသို့ ဝင် ၍ ငါ ၏လူ တို့သည် ငါ့ အား ဝတ်ပြု မည် အကြောင်း ၊ သူတို့ကို လွှတ် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","မလွှတ်ဘူးဟုငြင်း ၍ ဆီးတား သေး လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ထာဝရဘုရား ၏လက် တော်သည် လယ်ပြင် ၌ ရှိသောတိရစ္ဆာန် ၊ မြင်း ၊ မြည်း ၊ ကုလားအုပ် ၊ သိုး ၊ နွား တို့အပေါ် ၌ ရောက် ၍ အလွန် ပြင်းစွာ သော ရောဂါ စွဲလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ထာဝရဘုရား သည်၊ ဣသရေလ လူတို့၏ တိရစ္ဆာန် နှင့် အဲဂုတ္တု လူတို့၏ တိရစ္ဆာန် ကို ခြားနား စေသဖြင့် ၊ ဣသရေလ အမျိုးသား ပိုင်သော တိရစ္ဆာန် တကောင် မျှမ သေ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","နက်ဖြန် နေ့၊ အဲဂုတ္တုပြည် ၌ ထို အမှု ကို ထာဝရဘုရား ပြု တော်မူမည်ဟု မှန်သောအချိန် ကို ချိန်းချက် တော်မူပြီဟု ဟေဗြဲ လူတို့၏ ဘုရား သခင်ထာဝရဘုရား မိန့် တော်မူသည် အကြောင်းကိုပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","နက်ဖြန် နေ့၌ ထို အမှု ကိုပြု တော်မူသဖြင့် ၊ အဲဂုတ္တု လူတို့၏ တိရစ္ဆာန် အမျိုးမျိုး သေ ကြ၏။ ဣသရေလ လူ တို့၏ တိရစ္ဆာန် တကောင် မျှမ သေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ဖါရော ဘုရင်သည် လူကိုစေလွှတ် ၍ ၊ ဣသရေလ အမျိုးသားတို့၏ တိရစ္ဆာန် တ ကောင်မျှ မ သေ ကြောင်းကို သိ ရ၏။ သို့သော်လည်း နှလုံး ခိုင်မာ ပြန်၍ ၊ ဣသရေလလူ တို့ကို မ လွှတ် ဘဲနေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ထာဝရဘုရား ကလည်း ၊ မီးဖို ထဲကပြာ ကို လက် နှင့်ယူ ၍ မောရှေ သည် ဖါရော ဘုရင်ရှေ့ ၌ မိုဃ်းကောင်းကင် သို့ ပစ် လွှင့်စေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ထိုပြာသည် အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ နှံ့ပြားသော အမှုန့် ဖြစ် ၍ ၊ ပြည် တရှောက်လုံး တွင် လူ နှင့် တိရစ္ဆာန် တို့၌ အခဲအကျိတ် ပြည့် သော အနာဆိုး ဖြစ် လိမ့်မည် ဟု မောရှေ နှင့် အာရုန် တို့အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","သူတို့သည် မီးဖို ထဲကပြာ ကိုယူ ၍ ၊ ဖါရော ဘုရင် ရှေ့ မှာရပ် လျက် ၊ မောရှေ သည် မိုဃ်းကောင်းကင် သို့ ပစ် လွှင့်သဖြင့် ၊ ထိုပြာသည် လူ နှင့် တိရစ္ဆာန် တို့၌ အခဲအကျိတ် ပြည့် သော အနာဆိုး ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ဝိဇ္ဇာဆရာ တို့သည် အနာဆိုး ကြောင့် ၊ မောရှေ ရှေ့ ၌မ ရပ် မနေနိုင်။ ထိုအနာဆိုး သည် ဝိဇ္ဇာဆရာ တို့၌ ၎င်း ၊ အဲဂုတ္တု လူအပေါင်း တို့၌ ၎င်း စွဲ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ထာဝရဘုရား သည် ဖါရော ဘုရင်၏နှလုံး ကို ခိုင်မာ စေတော်မူသည်ဖြစ်၍ ၊ မောရှေ အား မိန့် တော်မူသည် အတိုင်း ၊ သူ တို့စကားကို နား မ ထောင်ဘဲ နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","တဖန် ထာဝရဘုရား က၊ နံနက် စောစော ထ၍ ၊ ဖါရော ဘုရင်ရှေ့ မှာရပ် လျက် ၊ ဟေဗြဲ လူတို့၏ ဘုရား သခင် ထာဝရဘုရား က၊ ငါ ၏လူ တို့သည် ငါ့ အား ဝတ်ပြု မည်အကြောင်း ၊ သွားရသောအခွင့် ကိုပေးလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","သို့မဟုတ် ယခု ကာလ အခါ သင် ၏နှလုံး ၌ ၎င်း ၊ သင် ၏ကျွန် များ၊ လူ များ၌ ၎င်း ၊ ငါ ၏ဘေးဒဏ် အလုံးစုံ တို့ကို သင့် ရောက်စေမည်။ မြေကြီး တရှောက်လုံး ၌ ငါ ကဲ့သို့ သောသူ မရှိ ကြောင်းကို သင်သည် သိ ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ငါ့ လက် ကို ငါဆန့် ၍ သင် နှင့် သင် ၏လူ တို့ကို ကာလနာ ဖြင့် ဒဏ်ခတ် မည်။ သင့်ကိုလည်း မြေကြီး ပေါ် က သုတ်သင် ပယ်ရှင်းမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","အကယ်စင်စစ်ငါ့ တန်ခိုး ကို သင် ၌ ငါပြ ခြင်းငှါ ၎င်း၊ ငါ့ နာမ ကို မြေကြီး တပြင်လုံး တွင် ကျော်စော စေ ခြင်းငှါ ၎င်း၊ သင့် ကို ငါချီးမြှောက် ခဲ့ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","သင် သည် ငါ ၏လူ တို့ကိုမ လွှတ် ဘဲ၊ သူ တို့ကို စော်ကား သေး သလော။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ကြည့်ရှု လော့။ အဲဂုတ္တု ပြည် တည် သည်ကာလ မှ စ၍ယခု တိုင်အောင် မ ရွာ ဘူးသော အလွန် ကြီးစွာ သော မိုဃ်းသီး ရွာခြင်းကို နက်ဖြန် နေ့ ဤအချိန် ၌ ငါ ဖြစ် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ထိုကြောင့် ယခု စေလွှတ် ၍ ၊ လယ်ပြင် ၌ ရှိသောတိရစ္ဆာန် များနှင့် ရှိလေသမျှ တို့ကို သိမ်း ယူလော့။ အိမ် သို့ မ ဆောင် လျင်၊ လယ်ပြင် ၌ တွေ့ သမျှ သောလူ နှင့် တိရစ္ဆာန် တို့အပေါ် မှာ မိုဃ်းသီး ကျ ၍ ၊ သူတို့သည် သေ ကြလိမ့်မည်အကြောင်းကို ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ထာဝရဘုရား ၏ နှုတ်ကပတ် တော်ကို ကြောက်ရွံ့ သော ဖာရော ဘုရင်၏ ကျွန် တို့သည်၊ မိမိ ကျွန် နှင့် မိမိ တိရစ္ဆာန် တို့ကို အိမ် သို့ ပြေး စေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ထာဝရဘုရား ၏ နှုတ်ကပတ် တော်ကို ပမာဏ မ ပြုသောသူတို့သည်၊ မိမိ ကျွန် ၊ မိမိ တိရစ္ဆာန် တို့ကို လယ်ပြင် ၌ ထား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ထာဝရဘုရား ကလည်း ၊ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ လူ တို့အပေါ်မှာ ၎င်း ၊ တိရစ္ဆာန် တို့အပေါ် မှာ၎င်း ၊ လယ်ပြင် ၌ ရှိလေသမျှ သော အပင် များအပေါ် မှာ၎င်း၊ မိုဃ်းသီး ရွာ စေခြင်းငှာ ၊ သင် ၏လက် ကို မိုဃ်းကောင်းကင် သို့ ဆန့် လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","မောရှေ သည် မိမိ လှံတံ ကို မိုဃ်းကောင်းကင် သို့ ဆန့် ၍ ၊ ထာဝရဘုရား သည် မိုဃ်းကြိုး နှင့် မိုဃ်းသီး ကို လွှတ် တော်မူ၏။ မီး သည်လည်း မြေ ပေါ် မှာပြေး လေ၏။ ထိုသို့ ထာဝရဘုရား သည်၊ အဲဂုတ္တု ပြည် ၌ မိုဃ်းသီး ရွာ စေတော်မူသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","အဲဂုတ္တု ပြည် တည်ထောင် သည်ကာလမှစ၍ တခါမျှ မဖြစ် ဘူးသော မိုဃ်းသီး ၊ မီး နှင့်ရော၍ အလွန် ပြင်းထန် စွာသော မိုဃ်းသီး ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ ၊ လယ်ပြင် မှာ ရှိသမျှ သော လူ နှင့် တိရစ္ဆာန် များ၊ မြက်ပင် များ၊ သစ်ပင် များ တို့ကို မိုဃ်းသီး ထိ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","သို့ရာတွင် ဣသရေလ အမျိုးသား နေရာ ဂေါရှင် ပြည် ၌ မိုဃ်းသီး မ ကျ မရွာ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ထိုအခါ ဖါရော ဘုရင်သည် လူကိုစေလွှတ် ၍ ၊ မောရှေ နှင့် အာရုန် ကို ခေါ် ပြီးလျှင် ၊ ဤအမှု၌ ငါပြစ်မှား ပြီ။ ထာဝရဘုရား သည် ဖြောင့်မတ် တော်မူ၏။ ငါ နှင့် ငါ ၏လူ တို့သည် အပြစ် များပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","တန် ပါပြီ။ အားကြီး သော မိုဃ်းကြိုး နှင့် မိုဃ်းသီး စဲမည်အကြောင်း၊ ထာဝရဘုရား ကို တောင်းပန် ပါ။ သင် တို့ကို ငါမ ဆီးမတား အလျင်အမြန်လွှတ် မည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","မောရှေ ကလည်း ၊ မြို့ ထဲက ကျွန်ုပ် ထွက် သွားသောအခါ ၊ ထာဝရဘုရား ရှေ့တော်၌ ကျွန်ုပ် လက်ဝါး တို့ကို ဖြန့် ပါမည်။ ထာဝရဘုရား သည် မြေကြီး ကို အစိုးရတော်မူကြောင်းကို ကိုယ်တော်သိ စေခြင်းငှာ မိုဃ်းကြိုး စဲ လိမ့်မည်။ မိုဃ်းသီး လည်း မ ကျ မရွာရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","သို့သော်လည်း ကိုယ်တော် နှင့် ကိုယ်တော် ၏ကျွန် တို့သည်၊ ထာဝရ အရှင်ဘုရား သခင်ကို မ ကြောက် သေး ကြောင်းကို အကျွန်ုပ်သိ ပါသည်ဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ပိုက်ဆန် ပင်၊ မုယော ပင်ကို မိုဃ်းသီးထိ ၏။ မုယော ပင်သည် အသီး အနှံနှင့်ပြည့်စုံပြီ။ ပိုက်ဆန် ပင်လည်း အသီးမှည့် ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ဂ ျုံ စပါး၊ ကောက် စပါးပင်ကိုကား မ ထိ။ ထို အပင်တို့သည် မ ပေါက်ကြသေး။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","မောရှေ သည် ဖာရော ဘုရင်ထံမှ ထွက် ၍ မြို့ ပြင်သို့သွားပြီးလျှင် ၊ ထာဝရဘုရား ရှေ့တော်၌ လက်ဝါး တို့ကို ဖြန့် သဖြင့် ၊ မိုဃ်းကြိုး နှင့် မိုဃ်းသီး စဲ လေ၏။ မြေ ပေါ်၌ လည်း မိုဃ်း မ ရွာ။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ထိုသို့ မိုဃ်း မရွာ၍ မိုဃ်းသီး နှင့် မိုဃ်းကြိုး စဲ သည်ကို ဖာရော ဘုရင်မြင် လျှင် ၊ တဖန် ပြစ်မှား ၍ ၊ ကျွန် များနှင့်တကွ နှလုံး ခိုင်မာ လျက်နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ထိုသို့ ဖာရောဘုရင်သည် နှလုံး ခိုင်မာ သည်ဖြစ်၍ ၊ မောရှေ ၌ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့ကို မ လွှတ် ဘဲနေပြန်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","တဖန် ထာဝရဘုရား က၊ သင်သည် ဖာရော ဘုရင်ထံ သို့ဝင် လော့။ ငါသည် ဤ နိမိတ် တို့ကို သူ ရှေ့ ၌ ပြ ခြင်းငှာ ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","အဲဂုတ္တုပြည်၌ ငါပြုသောအမှု၊ အဲဂုတ္တု လူတို့တွင် ငါပြ သောနိမိတ် တို့ကို၊ သင် ၏သား မြေးတို့အား ကြား ပြောသဖြင့် ၊ ငါ သည် ထာဝရဘုရား ဖြစ်ကြောင်းကို သင်တို့သိ စေခြင်းငှာ ၎င်း၊ သူ ၏နှလုံး ၊ သူ ၏ကျွန် တို့နှလုံး ကို ငါ ခိုင်မာ စေပြီဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","မောရှေ နှင့် အာရုန် တို့သည်၊ ဖာရော ဘုရင်ထံ သို့ဝင် ပြီးလျှင် ၊ ဟေဗြဲ လူတို့၏ ဘုရား သခင်ထာဝရဘုရား က၊ သင်သည် ငါ့ ရှေ့မှာ ကိုယ်ကိုကိုယ်မ နှိမ့်ချ ဘဲ အဘယ်မျှ ကာလ ပတ်လုံးနေလိမ့်မည်နည်း။ ငါ ၏လူ တို့ သည် ငါ့ အား ဝတ်ပြု မည်အကြောင်း ၊ သွားရသောအခွင့် ကိုပေး လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","သို့မဟုတ် ငါ ၏လူ တို့ကို မ လွှတ် ဘဲနေလျှင် ၊ ကြည့်ရှု လော့။ ကျိုင်းကောင် တို့ကို သင် ၏ပြည် သို့ နက်ဖြန် ငါ ဆောင် ခဲ့မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","မြေ မ ထင်ပေါ် နိုင် အောင် သူတို့သည် မြေ မျက်နှာ ကို ဖုံးလွှမ်း ကြလိမ့်မည်။ မိုဃ်းသီး မဖျက်၊ သင် တို့၌ ကျန် ကြွင်း သေးသမျှကို၎င်း၊ သင် တို့အဘို့ မြေ ၌ ပေါက် သမျှသော အပင် တို့ကို၎င်းစား ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","သင် ၏ဘိုးဘေး တို့သည် မြေ ပေါ် မှာဖြစ် သည် ကာလ မှစ၍ ၊ ယနေ့ တိုင်အောင် မ မြင် ဘူးသကဲ့သို့၊ သင် ၏အိမ် များ၊ သင် ၏ကျွန် တို့အိမ် များ၊ အဲဂုတ္တု လူအပေါင်း တို့၏ အိမ် များတို့ကို ဖြည့် ကြလိမ့်မည်ဟု ဆို ပြီးလျှင် ၊ လှည့် ၍ ဖာရော ဘုရင်ထံမှ ထွက် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ဖာရော ဘုရင်၏ ကျွန် တို့ကလည်း ၊ ဤ လူသည် ငါ တို့ကို အဘယ်မျှ ကာလ ပတ်လုံးနှောင့်ရှက် ပါလိမ့်မည်နည်း။ ထိုသူတို့သည် သူ တို့၏ဘုရား သခင်ထာဝရဘုရား အား ဝတ်ပြု မည်အကြောင်း အခွင့် ပေးတော်မူပါ။ အဲဂုတ္တု ပြည်ပျက် ကြောင်း ကို သိ တော်မ မူသေးသလောဟုလျှောက် ကြလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","မောရှေ နှင့် အာရုန် ကို တဖန် ဖာရော ဘုရင်ထံ သို့သွင်း ပြန်၍ ၊ သင် တို့၏ဘုရား သခင်ထာဝရ ဘုရားအား ဝတ်ပြု ခြင်းငှာသွား ကြလော့။ သို့ရာတွင် သွား ရသောသူတို့သည် အဘယ်သူ နည်းဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","မောရှေ က၊ အကျွန်ုပ်တို့သည် သူငယ် ၊ သူအို၊ သားသမီး ၊ သိုး ၊ နွား ပါလျက် သွား ပါမည်။ အကြောင်းမူကား ၊ ထာဝရဘုရား ရှေ့တော်၌ ပွဲ ခံရပါမည်ဟု ပြန်ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ဖာရောမင်းက၊ သင် တို့နှင့် သူငယ် များကို ငါလွှတ် သည်အတိုင်း ၊ ထာဝရဘုရား သည် သင် တို့၌ ရှိစေသော။ သတိပြု ၊ မကောင်း သောအကြံကို ကြံကြသည်တကား။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ထိုသို့ မ ဖြစ်ရာ။ အရင်တောင်း လျှောက်သည်အတိုင်း၊ ယောက်ျား ဖြစ်သောသူတို့သာသွား ၍ ထာဝရ ဘုရားအား ဝတ်ပြု ကြဟု မိန့် တော်မူသဖြင့်၊ သူ တို့ကို အထံ တော်မှ နှင် ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ထာဝရဘုရား ကလည်း ၊ ကျိုင်း တို့သည် အဲဂုတ္တု ပြည် သို့ ရောက် လာ၍ မိုဃ်းသီး မဖျက်၊ မြေ ပေါ်မှာ ကျန်ရစ် သောအပင် ရှိသမျှ တို့ကို စား စေခြင်းငှာ ၊ အဲဂုတ္တု ပြည် အပေါ် မှာ လက် ကိုဆန့် လော့ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","မောရှေ သည် မိမိ လှံတံ ကို အဲဂုတ္တု ပြည် အပေါ် မှာ ဆန့် သဖြင့် ၊ ထို နေ့ နှင့် ထိုညဉ့် ပတ်လုံး ၊ အရှေ့ လေ ကို မြေ ပေါ် မှာထာဝရဘုရား လာ စေတော်မူ၍၊ နံနက် ရောက် မှ အရှေ့ လေ သည် ကျိုင်း တို့ကို ဆောင် ခဲ့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ထိုကျိုင်း တို့သည် အဲဂုတ္တု ပြည် လုံး ကို လွှမ်းမိုး ၍ ၊ ပြည် နယ်နိမိတ် ရှိသမျှ အပေါ် မှာ နား သဖြင့် အလွန် များပြား ကြ၏။ ထိုသို့ သော ကျိုင်း တို့သည် ရှေး ကမ ဖြစ် စဖူး၊ နောက် ၌လည်း မ ဖြစ် ရလတံ့။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","မြေ မည်း သည်တိုင်အောင်မြေ တပြင်လုံး ကို ဖုံးအုပ် ၍ တပြည် လုံးတွင် မြက်ပင် ရှိသမျှ မိုဃ်းသီး နှင့် လွတ် သောသစ်သီး ရှိသမျှ ကို စား ကြသဖြင့် ၊ အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် သစ်ပင် မြက်ပင် တို့၌ စိမ်း သောအရာ တစုံတခုမျှ မ ကျန်ရစ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ထိုအခါ ဖာရော ဘုရင်သည် မောရှေ နှင့် အာရုန် ကို အလျင်အမြန် ခေါ် ၍ ၊ သင် တို့၏ ဘုရား သခင် ထာဝရဘုရား ကို၎င်း ၊ သင် တို့ကို၎င်း ငါပြစ်မှား ပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","သို့ဖြစ်၍ သည်တခါ ငါ့ အပြစ် ကို သည်းခံ ပါလော့။ သင် တို့၏ဘုရား သခင်ထာဝရဘုရား သည်၊ ဤ သေဘေး တခုကိုသာ ငါ မှ ပယ်ရှား ပါမည်အကြောင်း တောင်းပန် ပါဟု ဆို သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","မောရှေသည် အထံ တော်မှ ထွက် ၍ ၊ ထာဝရဘုရား ကို တောင်းပန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ထာဝရဘုရား သည် အားကြီး သော အနောက် လေ ကို လွှတ် တော်မူသဖြင့် ၊ ထိုလေသည် ကျိုင်း တို့ကို ဆောင်သွား ၍ ဧဒုံ ပင်လယ် ၌ ချ ပစ်လေ၏။ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ ကျိုင်း တကောင် မျှ မ ကျန်ရစ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","သို့သော်လည်း ၊ ထာဝရဘုရား သည် ဖာရော ဘုရင်၏နှလုံး ကို ခိုင်မာ စေတော်မူသဖြင့် ၊ သူသည် ဣသရေလ အမျိုးသား တို့ကို မ လွှတ် ဘဲနေပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","တဖန် ထာဝရဘုရား က၊ အဲဂုတ္တု ပြည် တရှောက်လုံး၌ မှောင်မိုက် သာမညမဟုတ်၊ စမ်းသပ် ၍ တွေ့ရသောမှောင်မိုက် ဖြစ် စေခြင်းငှာ ၊ သင် ၏လက် ကို မိုဃ်းကောင်းကင် သို့ ဆန့် လော့ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","မောရှေ သည် မိမိ လက် ကို မိုဃ်းကောင်းကင် သို့ ဆန့် ၍ ၊ အဲဂုတ္တု ပြည် တရှောက်လုံး ၌ ထူထပ် သော မှောင်မိုက် သည် သုံး ရက် ပတ်လုံးဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ထိုအခါ တယောက်ကိုတယောက်မ မြင် နိုင်ကြ။ သုံး ရက် ပတ်လုံးအဘယ်သူမျှ မိမိ နေရာ မှ မ ထ ရကြ။ သို့ရာတွင် ဣသရေလ အမျိုးသား အပေါင်း တို့သည်၊ မိမိ တို့နေရာ ၌ အလင်း ကို ရ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ထိုအခါ ဖာရော ဘုရင်သည် မောရှေ နှင့် အာရုန်ကို ခေါ် ၍ ထာဝရ ဘုရားအား ဝတ်ပြု ခြင်းငှာသွား ကြလော့။ သို့ရာတွင်သိုး နွား များကို ထား ခဲ့ကြစေ။ သူငယ် များကို ခေါ် ကြစေဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","မောရှေ ကလည်း ၊ ကျွန်ုပ် တို့ဘုရား သခင်ထာဝရဘုရား အား ယဇ်ပူဇော် စရာဘို့ ယဇ်ကောင် များ၊ မီးရှို့ ရာပူဇော်သက္ကာများကို ကိုယ်တော် ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ကျွန်ုပ် တို့သည် တိရစ္ဆာန် များကို ဆောင်သွား ရမည်။ တကောင်မျှ မ ကျန်ရစ် ရ။ အကြောင်းမူကား ၊ သူ တို့အထဲက ကျွန်ုပ် တို့ဘုရား သခင်ထာဝရဘုရား အား ဝတ်ပြု စရာဘို့ ရွေး ယူရမည်။ ထာဝရ ဘုရားအား အဘယ် မည်သောအကောင်နှင့် ဝတ်ပြု ရမည်ကို ထို အရပ်သို့ မ ရောက် မှီ မ သိ ပါဟု ဆို လေသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ထာဝရဘုရား သည် ဖာရော ဘုရင်၏ နှလုံး ကို ခိုင်မာ စေတော်မူသဖြင့် ၊ သူသည် ဣသရေလ အမျိုးသားတို့ကို မ လွှတ် ။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","မောရှေ ကို လည်း ၊ ငါ့ ထံမှ ထွက် သွားလော့။ နောက် တဖန် ငါ့ မျက်နှာ ကို မ မြင် အောင် သတိပြု လော့။ ငါ့ မျက်နှာ ကို မြင် သောနေ့ ၌ သေ မည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","မောရှေ ကလည်း ၊ မိန့် တော်မူချက်သည် လျောက်ပတ် ပါ၏။ မျက်နှာ တော်ကို နောက် တဖန်မ မြင် ပါဟု လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ထိုအခါ ထာဝရဘုရား က၊ ဖာရော ဘုရင်နှင့် အဲဂုတ္တု ပြည်အပေါ် မှာ ဘေး တပါး ကို ငါရောက် စေဦး မည်။ ထိုနောက် သင် တို့ကို လွှတ် လိမ့်မည်။ လွှတ် သောအခါ ၌လည်း၊ အကယ်၍သင် တို့ကို တပြိုင်နက် နှင် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ဣသရေလလူယောက်ျားသည်၊ အိမ်နီးချင်း ယောက်ျား ၌ ၎င်း၊ မိန်းမသည် အိမ်နီးချင်း မိန်းမ ၌ ၎င်း ၊ ငွေ တန်ဆာ ၊ ရွှေ တန်ဆာ ၊ အဝတ်တန်ဆာတို့ကို တောင်း စေခြင်းငှာ ၊ လူ များတို့အား ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","သူတို့တောင်းသည်အတိုင်း၊ အဲဂုတ္တု လူတို့သည် ပေးချင်သောစေတနာ စိတ်ကို ထာဝရဘုရား ဖြစ် စေ တော်မူ၏။ မောရှေ သည်လည်း ၊ အဲဂုတ္တု ပြည် တွင် ဖာရော ဘုရင်၏ ကျွန် များ၊ လူ များရှေ့ ၌ ကြီးစွာ သော အသရေ ရှိလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ထိုအခါ မောရှေ က၊ ထာဝရဘုရား မိန့် တော်မူသည်ကား၊ သန်းခေါင် အချိန်၌ အဲဂုတ္တု ပြည်အလယ် သို့ ငါ ထွက်သွား မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","နန်း ထိုင် သော ဖာရော ဘုရင်၏ သားဦး မှစ၍ ၊ ကြိတ်ဆုံ နောက်၌ ထိုင်သော ကျွန်မ ၏သားဦး တိုင်အောင် ၊ အဲဂုတ္တု ပြည် ၌ ရှိသမျှ သော သားဦး တို့နှင့် တိရစ္ဆာန် တို့၏ သားဦး ရှိသမျှ တို့သည် သေ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","အဲဂုတ္တု ပြည် တရှောက်လုံး တွင် ၊ ရှေးကာလ၌ မ ဖြစ် စဖူး၊ နောင်ကာလ၌လည်း မ ဖြစ် လတံ့သော ကြီးစွာ သော ငိုကြွေး ခြင်း ဖြစ် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","သို့ရာတွင် ထာဝရဘုရား သည်၊ အဲဂုတ္တု လူတို့နှင့် ဣသရေလ လူတို့ကို ခြားနား စေတော်မူကြောင်း ကို သင်တို့သိ စေခြင်းငှာ ၊ ဣသရေလ လူ တစုံတယောက်ကို ခွေး တကောင်မျှ မ ဟိန်း ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ကိုယ်တော် ၏ ကျွန် ဖြစ်သော ဤ လူအပေါင်း တို့သည်လည်း ကျွန်ုပ် ထံ သို့လာ ၍ ပြပ်ဝပ် လျက် ထွက်သွားပါ။ ကိုယ်တော် နှင့် ကိုယ်တော် နောက် ၌ လိုက်သော လူ အပေါင်း တို့ ထွက်သွား ကြပါဟု ပြောဆို ပြီးမှ ကျွန်ုပ်ထွက်သွား ပါမည်ဟု လျှောက်ဆိုသဖြင့် ၊ အမျက် ထွက်၍ ဖာရော ဘုရင်ထံမှ ထွက်သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ထာဝရဘုရား ကလည်း ၊ အံ့ဘွယ် သော အမှုတော်တို့သည် အဲဂုတ္တု ပြည် ၌ များပြား မည်အကြောင်း ၊ ဖာရော ဘုရင်သည် သင် တို့၏စကားကို နား မ ထောင်ဘဲနေလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","မောရှေ နှင့် အာရုန် တို့သည် ဖာရော ဘုရင်ရှေ့မှာ ဤ အံ့ဘွယ် သော အမှုအလုံးစုံ တို့ကို ပြု သော်လည်း ၊ ထာဝရဘုရား သည် ဖာရော ဘုရင်၏ နှလုံး ကို ခိုင်မာ စေတော်မူသဖြင့် ၊ ဣသရေလ အမျိုးသား တို့ကို ပြည် တော်မှ ထွက်သွားရသောအခွင့် ကို မ ပေးဘဲ နေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ထာဝရဘုရား သည် အဲဂုတ္တု ပြည် ၌ မောရှေ နှင့် အာရုန် တို့အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","ဤ လ သည် သင် တို့၌ လဦး တည်းဟူသောနှစ် စဉ်တွင် ပဌမ လ ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","သင်တို့သည် ဣသရေလ အမျိုး ပရိသတ် အပေါင်း တို့ကို မှာ ထားရသောစကားဟူမူကား၊ ဤ လ ဆယ် ရက် နေ့၌ သင်တို့ရှိသမျှသည်၊ မိမိအိမ်ထောင် အသီးအသီး အတိုင်း တအိမ်ထောင် လျှင် သိုးသငယ် တကောင်စီ ယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","အိမ်ထောင် ငယ် ၍ သိုးသငယ်တကောင်နှင့် မတန်လျှင် ၊ နီးစပ် သော အိမ်နီးချင်း နှင့် စပ်ဘက် ၍ လူ မည်မျှရှိသည်ဟု ရေတွက် ပြီးလျှင်၊ တကောင်ကို စား လောက်သော သူများကိုထောက် ၍ သိုးသငယ် တကောင်ကို ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","သိုး သငယ်ဖြစ်စေ ၊ ဆိတ် သငယ်ဖြစ်စေ၊ သင်တို့ယူ သော အကောင်သည် အပြစ် မပါ၊ အခါ မလည်သော အထီး ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ထိုသိုးသငယ်တို့ကို၊ ထို လ ဆယ် လေး ရက် တိုင်အောင် စောင့် ထားပြီးမှ ၊ ညဦး အချိန်၌ ဣသရေလ အမျိုး အစည်းအဝေး ပရိသတ် အပေါင်း တို့သည် သတ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","သိုးသငယ် ၏အသားကို စား ရသောအိမ် ၏ တံခါးထုပ် နှင့် တံခါးတိုင် နှစ် ဘက်၌ ၊ သိုးသငယ်၏အသွေး ကို ယူ ၍ ထိုး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","အသား ကို မီး နှင့်ကင် ပြီးမှ ၊ ထို ညဉ့် ခြင်းတွင် တဆေးမပါသောမုန့် ၊ ခါး သော ဟင်းသီးဟင်းရွက်နှင့် စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","အသားစိမ်း သည်ဖြစ်စေ ၊ ရေ နှင့် ပြုတ် သည်ဖြစ်စေမ စား ရ။ ခေါင်း ၊ ခြေထောက် ၊ အသည်း ၊ နှလုံး စသည်တို့နှင့်တကွ ၊ မီး ကင် ပြီးမှစားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","နံနက် တိုင်အောင် ထိုအသား ကို မ ကြွင်း စေရ။ အနည်းငယ်ကြွင်း လျှင် မီး နှင့် ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","အဘယ်သို့စား ရမည်နည်းဟူမူကား၊ ခါးစည်း ကို စည်း လျက်၊ ခြေနင်း ကို စီး လျက် ၊ တောင်ဝေး ကို ကိုင် လျက် အလျင်အမြန် စား ရမည်။ ထာဝရဘုရား ၏ ပသခါ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","အကြောင်းမူကား၊ ယနေ့ညဉ့် တွင် အဲဂုတ္တု ပြည် ကို ငါသည် ထုတ်ချင်းခပ်သွား ၍ ၊ အဲဂုတ္တု ပြည် ၌ ရှိသောလူ တို့၏ သားဦး များနှင့် တိရစ္ဆာန် တို့၏ သားဦးများအပေါင်း တို့ကို ဒဏ်ခတ် ၍ ၊ အဲဂုတ္တု ပြည်၏ ဘုရား တို့ကို တရားစီရင် မည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","သိုးသငယ်၏ အသွေး သည် သင် တို့နေရာ အိမ် ၌ သင် တို့၏ လက္ခဏာ သက်သေဖြစ် ၍ ၊ ထို အသွေး ကို ငါမြင် သောအခါ ၊ သင် တို့ကို ငါလွန် သွားမည်။ ထိုသို့ အဲဂုတ္တု ပြည် ကို ငါ သည် ဒဏ်ခတ် သောအခါ ၊ ဖျက်ဆီး ခြင်း ဘေးဥပဒ် သည် သင် တို့ကို မ သင့် မရောက်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ဤ နေ့ရက် သည်လည်း သင် တို့အောက်မေ့ စရာဘို့ ဖြစ် ၍ ၊ သင် တို့၏အမျိုး အစဉ်အဆက်မပြတ် ဤနေ့ရက်၌ ထာဝရဘုရား အား ပွဲခံ ရကြမည်။ ပညတ် တော်ရှိသည်ဖြစ်၍ ၊ ထိုပွဲ ကို အစဉ် အမြဲခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ခုနစ် ရက် ပတ်လုံးတဆေး မပါသောမုန့်ကို စား ရမည်။ ပဌမ နေ့ရက် ၌ တဆေး ကို အိမ် များမှ ပယ် ရမည်။ ပဌမ နေ့ မှစ၍ ခုနစ် ရက် နေ့တိုင်အောင် ၊ တဆေး ပါသောမုန့်ကို စား သောသူ မည်သည်ကား၊ ဣသရေလ အမျိုးမှ ပယ်ရှင်း ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ပဌမ နေ့ ၌ ၎င်း ၊ ခုနစ် ရက် နေ့၌ ၎င်း၊ ဓမ္မ စည်းဝေး ခြင်းကို ပြုရမည်။ ထို နေ့ရက်၌ လူ တိုင်း စား ခြင်းကိစ္စနှင့်ဆိုင်သော အလုပ်အဆောင်မှတပါး အခြားသောအလုပ် ကို မ လုပ် မဆောင်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ထိုအဇုမ ပွဲကိုခံရ သောအကြောင်းဟူမူကား၊ထို နေ့ ရက်၌ သင် တို့ဗိုလ်ခြေ များကို၊ အဲဂုတ္တု ပြည် ထဲက ငါနှုတ်ဆောင် သည်ဖြစ်၍ ၊ ထိုအကြောင်းကြောင့် ပညတ် တော်ရှိသည်အတိုင်း၊ သင် တို့၏အမျိုး အစဉ် အဆက်မပြတ်ထို နေ့ရက် ကို အမြဲစောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ပဌမ လ ဆယ် လေး ရက် နေ့ညဦး မှစ၍နှစ်ဆယ် တ ရက်နေ့ ညဦး တိုင်အောင် ၊ သင်တို့သည် တဆေး မပါသောမုန့်ကို စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ခုနစ် ရက် ပတ်လုံးသင် တို့အိမ် များ၌ တဆေး မ ရှိ ရ။ တဆေး ပါသောမုန့်ကို စား သောသူ မည်သည်ကား၊ တကျွန်းတနိုင်ငံ သားဖြစ်စေ ၊ ပြည် သား ဖြစ်စေ၊ ဣသရေလ အမျိုး ပရိသတ် မှ ပယ်ရှင်း ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","သင် တို့နေရာ အရပ်ရပ် တို့၌ တဆေး ပါသောမုန့်ကို မ စား ရ။ တဆေး မပါသောမုန့်ကိုသာ စား ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ထိုအခါ မောရှေ သည် ဣသရေလ အမျိုး အသက်ကြီး သူအပေါင်း တို့ကိုခေါ် ၍ ၊ သင် တို့သည် အိမ်ထောင် များ အသီးအသီးကိုယ်စီကိုယ်စီသိုးသငယ် တို့ကို ယူ ၍ ပသခါ ပွဲဘို့ သတ် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ဟုဿုပ် ပင်ညွန့်တစည်း ကို ယူ ၍ အင်တုံ ၌ ထည့်သော အသွေး ထဲမှာ နှစ် ပြီးလျှင် ၊ တံခါးထုပ် တံခါးတိုင် နှစ် ဘက်တို့ကို ထိုးသုတ် ကြလော့။ ထိုနောက်မှ နံနက် တိုင်အောင် အဘယ်သူမျှ မိမိ အိမ် တံခါး ပြင်သို့ မ ထွက် မသွားရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","အကြောင်းမူကား၊ ထာဝရဘုရား သည် အဲဂုတ္တု လူတို့ကို ဒဏ်ခတ် ခြင်းငှာ ထုတ်ချင်းခတ်သွား တော်မူမည်။ တံခါးထုပ် နှင့် တံခါးတိုင် နှစ် ဘက်၌ ရှိသောအသွေး ကို မြင် သောအခါ ၊ ထာဝရဘုရား သည် တံခါး ကို လွန် သွားတော်မူမည်။ ဖျက်ဆီး သောသူသည် သင်တို့ကို ဒဏ်ခတ် ခြင်းငှာ ၊ အိမ် ထဲ သို့ဝင် ရသောအခွင့် ကိုပေး တော်မ မူ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","သင် တို့နှင့် သင် တို့၏သား များ၌ ပညတ် တော်ရှိသည်ဖြစ်၍၊ ဤ အမှု ကို အစဉ်အမြဲ စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ဂတိ တော်ရှိသည်အတိုင်း ၊ ထာဝရဘုရား ပေး တော်မူလတံ့သော ပြည် သို့ သင်တို့သည် ရောက် ကြသောအခါ ဤ ဝတ် ကို ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","သင် တို့၏ သား မြေးတို့က၊ ဤ ဝတ် ကိုပြု၍ အဘယ်သို့ ဆိုလိုသနည်းဟု မေးမြန်း ကြလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ထာဝရဘုရားသည် အဲဂုတ္တု လူတို့ကို ဒဏ်ခတ် ၍ ၊ ငါ တို့အိမ် များကို ချမ်းသာ ပေးတော်မူသောအခါ ၊ အဲဂုတ္တု ပြည်၌ ဣသရေလ အမျိုးသား တို့၏အိမ် များကို လွန် သွားတော်မူသောထာဝရဘုရား ၏ ပသခါ ယဇ် ဖြစ်သတည်းဟု ပြန်ပြော ရကြမည်ဟု မောရှေဆို ပြီးလျှင် ၊ ထိုသူ တို့သည် ဦးညွတ်ချ ၍ ကိုးကွယ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ထိုသို့ မောရှေ နှင့် အာရုန် တို့ကို ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့ သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","သန်းခေါင် အချိန်၌ ၊ ထာဝရဘုရား သည် နန်း ထိုင် သော ဖာရော ဘုရင်၏ သားဦး မှစ၍ ထောင် ထဲမှာ အချုပ် ခံရသောသူ ၏သားဦး တိုင်အောင် ၊ အဲဂုတ္တု ပြည် ၌ သားဦး ရှိသမျှ ကို၎င်း ၊ တိရစ္ဆာန် တို့၏ သားဦး ရှိသမျှ ကို ၎င်း ဒဏ်ခတ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ထိုညဉ့် တွင်၊ ဖာရော ဘုရင်နှင့် သူ ၏ကျွန် များ၊ အဲဂုတ္တု လူများတို့သည် ထ ကြ၍၊ အသေကောင် ကင်း သောအိမ် တအိမ်မျှ မရှိ သောကြောင့် ၊ အဲဂုတ္တု ပြည်၌ ကြီးစွာ သော ငိုကြွေး ခြင်း ဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ထိုညဉ့် ခြင်းတွင် မောရှေ နှင့် အာရုန် ကို ခေါ် တော်မူလျှင် ၊ သင် တို့မှစ၍ ဣသရေလ အမျိုးသား တို့၊ ထ ၍ ငါ့ လူ စုထဲက ထွက်သွား ကြလော့။ သင် တို့တောင်း သည်အတိုင်း ထာဝရဘုရား အား သွား ၍ ဝတ်ပြု ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","သင်တို့တောင်း သည်အတိုင်း သိုး နွား များကို ယူ ၍ သွား ကြလော့။ ငါ့ ကိုလည်း ကောင်းကြီး ပေးကြလော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","အဲဂုတ္တု လူတို့ကလည်း ၊ ငါ တို့ရှိသမျှ သည် အသေကောင် ဖြစ်ကြပြီဟုဆို လျက်၊ ဣသရေလလူ တို့ကို အဲဂုတ္တုပြည် ထဲက အလျင်အမြန် လွှတ် ခြင်းငှာ ကျပ်ကျပ်နှိုးဆော် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ထိုလူ တို့သည် တဆေး မ ရောသေးသော မုန့်စိမ်း ကိုယူ ၍ မုန့် နယ်သောခွက်တို့ကိုလည်း အဝတ် နှင့်တကွ ထုပ် ၍ ထမ်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","မောရှေ စီရင် သည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့သည် ငွေ တန်ဆာ ၊ ရွှေ တန်ဆာ ၊ အဝတ် တန်ဆာများကို အဲဂုတ္တု လူတို့၌ တောင်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","တောင်း သည်အတိုင်းလည်း၊ ပေးချင်သောစေတနာ စိတ်ကို အဲဂုတ္တု လူတို့အား ထာဝရဘုရား ပေး တော်မူသဖြင့် ၊ အဲဂုတ္တု လူတို့၏ ဥစ္စာများကို လုယူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ဣသရေလ အမျိုးသား မိန်းမနှင့် သူငယ် ကို မ ဆိုဘဲ၊ ယောက်ျား အရေအတွက်အားဖြင့်ခြောက် သိန်းခန့်မျှ ရှိသောသူတို့သည်၊ ရာမသက် မြို့မှ ထွက်၍ သုကုတ် အရပ်သို့ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","အမျိုးမျိုးသော လူ အများ တို့သည်လည်း ၊ သိုး နွား အစရှိသော များစွာ သောတိရစ္ဆာန် တို့နှင့်တကွ လိုက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","တဆေး မ ရောဘဲ အဲဂုတ္တု ပြည်မှ ဆောင် ခဲ့သော မုန့်စိမ်း ကိုယူ၍၊ တဆေး မပါသောမုန့် ကို ဖုတ် ရကြ၏။ အကြောင်း မူကား၊ အဲဂုတ္တု ပြည်၌ မနွှဲမဖင့် အနှင် ခံရသောကြောင့် ၊ ကိုယ် စားစရာ ကို မ ပြင် ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ဣသရေလ အမျိုးသား တို့သည် အဲဂုတ္တု ပြည်၌ ဧည့်သည်ဖြစ်၍၊ တည် နေကြသော ကာလ နှစ် ပေါင်း လေး ရာ သုံးဆယ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","အနှစ် လေး ရာ သုံးဆယ် စေ့ သောနေ့ ခြင်းတွင် ၊ ထာဝရဘုရား ၏ ဗိုလ်ခြေ အပေါင်း တို့သည်၊ အဲဂုတ္တု ပြည် မှ ထွက် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်တော်မူသောအတွက်ကြောင့်၊ ထို နေ့ညဉ့် ကို အထူးသဖြင့်ထာဝရဘုရား ၌ စောင့် စရာကောင်း၏။ ဣသရေလ အမျိုးသား တို့၏ အမျိုး အစဉ် အဆက်မပြတ်စောင့် ရသောထာဝရဘုရား ၏ ညဉ့်ကား၊ ဤ သည် ညဉ့် ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ပသခါ ပွဲတရား ဟူမူကား ၊ တပါး အမျိုးသားမ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","သို့ရာတွင် ငွေ နှင့် ဝယ် သော ကျွန် သည် အရေဖျား လှီးမင်္ဂလာကို ခံပြီးလျှင် စား ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","တကျွန်း တနိုင်ငံသားဖြစ်စေ ၊ အခစား သောကျွန်ဖြစ်စေ၊ မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","တအိမ် တည်း၌ တကောင်ကိုစား ရ၏။ အသား ကို အိမ် ပြင် သို့ ယူ မ သွားရ။ အရိုး ကိုလည်း မ ချိုး ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ဣသရေလ အမျိုးသားပရိသတ် အပေါင်း တို့သည် ထိုပွဲ ကို ခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","သင် တို့ထံမှာ တည်းခို သော တပါး အမျိုးသားသည် ထာဝရဘုရား အဘို့ ပသခါပွဲ ကို ခံခြင်းငှာအလို ရှိလျှင် ၊ သူ ၌ ရှိသောယောက်ျား အပေါင်း တို့သည် အရေဖျား လှီးမင်္ဂလာကို ခံကြစေ။ သို့ပြီးမှ ထိုသူသည် ပြည် သား ကဲ့သို့ ဖြစ် သောကြောင့်၊ ချဉ်း၍ ထိုပွဲ သို့ ဝင် စေ။ အရေဖျား လှီးမင်္ဂလာကို မခံသောသူမည်သည်ကား၊ ထိုပွဲ၌ ဝင်၍ မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","အမျိုးသား ချင်းဖြစ်သောသူ၊ သင် တို့တွင် တည်းခို သော တပါး အမျိုးသားဖြစ်သောသူတို့သည်၊ တပါး တည်းသောတရား နှင့် ဆိုင် ကြ၏ဟု ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် ၌ ပညတ် ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ထိုသို့ မောရှေ နှင့် အာရုန် ၌ ထာဝရဘုရား ပညတ် ထားတော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား အပေါင်း တို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ထို နေ့ ခြင်းတွင် ထာဝရဘုရား သည်၊ ဣသရေလ အမျိုးသား ဗိုလ်ခြေ တို့ကို အဲဂုတ္တု ပြည် မှ ဆောင်သွား တော်မူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","မောရှေ ကို ခေါ်၍ ဣသရေလ အမျိုးသား တို့တွင် အဦးဘွားသောသူ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ ၊ သားဦး အပေါင်း တို့ကို ငါ့ အဘို့ သန့်ရှင်း စေလော့။ ငါ့ ဥစ္စာဖြစ်ကြသည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","မောရှေ ကလည်း ၊ သင်တို့သည် ကျွန် ခံနေရာ အဲဂုတ္တု ပြည်မှ ထွက် သွားသော ဤ နေ့ ရက်ကို အောက်မေ့ ကြလော့။ ထာဝရဘုရား သည် အားကြီး သောလက် တော်ဖြင့် သင် တို့ကို ထို ပြည်မှ နှုတ် ဆောင်တော်မူပြီ။ တဆေး ပါသောမုန့်ကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","အဗိဗ လ ၊ ယနေ့ ၌ ပင် သင် တို့သည် ထွက် လာကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","သင် တို့အား ပေး ခြင်းငှာ ဘိုးဘေး များ၌ ထာဝရဘုရားကျိန်ဆို တော်မူသော ပြည်၊ ခါနနိ လူ၊ ဟိတ္တိ လူ၊ အာမောရိ လူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့နေရာ တည်းဟူသောနို့ နှင့် ပျားရည် စီး သောပြည် သို့ ပို့ဆောင် တော်မူပြီးမှ ၊ ယခု လ တွင် သင်တို့သည် ဤ ဝတ် ကိုပြု ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ခုနစ် ရက် ပတ်လုံးတဆေး မပါသောမုန့်ကို စား ပြီးမှ ၊ ခုနစ် ရက်မြောက်သောနေ့ တွင် ၊ ထာဝရဘုရား အဘို့ ပွဲ ခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","တဆေး မပါသောမုန့်ကို စား ရသောခုနစ် ရက် ပတ်လုံးသင် တို့၌ တဆေး ကို မ တွေ့ မမြင်ရ။ သင် တို့နေ သောအရပ်ရပ် တို့၌ လည်း မ တွေ့ မမြင်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ငါ တို့သည် အဲဂုတ္တု ပြည်မှ ထွက် သောကာလ ၊ ထာဝရဘုရား ပြု တော်မူသောကျေးဇူး တော်ကြောင့် ဤသို့ပြုရ၏ဟု ထို နေ့ ၌ သား မြေးတို့အား ကြား ပြောရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ထာဝရဘုရား ၏ တရား သည်၊ သင် ၏နှုတ် ၌ တည် မည်အကြောင်း ၊ ဤအရာသည် သင် ၏လက် ၌ လက္ခဏာ သက်သေ၊ သင် ၏မျက်စိ ကြား မှာ အောက်မေ့ ဘို့ရာဖြစ် ရမည်။ အားကြီး သောလက် တော်ဖြင့် ထာဝရဘုရား သည်၊ သင့် ကို အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ထို့ကြောင့် စီရင်တော်မူသောဤ ထုံးစံ ကို၊ မိမိ အချိန် ၌ နှစ် စဉ်အတိုင်း စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","သင် တို့၌ ၎င်း ၊ ဘိုးဘေး ၌ ၎င်း၊ ကျိန်ဆို တော်မူသည်အတိုင်း ၊ ထာဝရဘုရား သည် သင် တို့ကို ပို့ဆောင် ၍ ၊ ထိုပြည်ကိုပေး သနားတော်မူသောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","သင်တို့၌ အဦး ဘွား သောသားအပေါင်း တို့နှင့် သင်တို့၌ရှိသောတိရစ္ဆာန် တို့၏ သားဦး အပေါင်း တို့ကို၊ ထာဝရဘုရား အဘို့ အသီးအခြားခွဲ ထားရကြမည်။ အထီး ရှိသမျှတို့သည်၊ ထာဝရဘုရား ၏ ဥစ္စာဖြစ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","မြည်း မ၌ အဦး ဘွားသော မြည်းသငယ်ကို၊ သိုးသငယ် နှင့် ရွေး ရမည်။ မ ရွေး လိုလျှင် ၊ မြည်း သငယ် လည်ပင်း ကို ချိုးရမည်။ လူသား တို့တွင် သားဦး အပေါင်း ကို ရွေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","နောင်ကာလ၌ သင် ၏သား ကလည်း၊ အဘယ်သို့ နည်းဟု မေးမြန်း လျှင်၊ သင်ကလည်း ကျွန် ခံနေရာ အဲဂုတ္တု ပြည်မှ ၊ ထာဝရဘုရား သည် အားကြီး သော လက် တော်ဖြင့် ငါ တို့ကို နှုတ်ဆောင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ဖာရော ဘုရင်သည်၊ ငါ တို့ကို အလွယ်တကူမ လွှတ် ဘဲနေသောအခါ ၊ အဲဂုတ္တု ပြည် ၌ လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ၊ သားဦး အပေါင်း တို့ကို ထာဝရဘုရား ကွပ်မျက် တော်မူ၏။ ထိုကြောင့် အဦး ဘွားသော တိရစ္ဆာန် အထီး ရှိသမျှ တို့ကို ထာဝရဘုရား အား ယဇ်ပူဇော် ရမည်။ ကိုယ် သား တို့တွင် သားဦး ကို ရွေး ရမည်ဟု ပြန်ဆို ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ဤအရာသည်လည်း၊ သင် ၏လက္ခဏာ သက်သေ၊ သင် ၏မျက်စိ ကြား မှာ သင်းကျပ် ဖြစ် ရမည်။ အကြောင်းမူကား ၊ ထာဝရဘုရား သည် အားကြီး သောလက် တော်ဖြင့် ငါ တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူပြီဟု လူ များတို့အား ပြောဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ဣသရေလလူ တို့ကို ဖာရော ဘုရင်လွှတ် သောနောက် ၊ ဖိလိတ္တိ ပြည် ကို ရှောက်သောလမ်း သည် ဖြောင့် သော်လည်း ၊ ထို လမ်းဖြင့် ဘုရား သခင်ဆောင် တော်မ မူ။ အကြောင်းမူကား ၊ သူ တို့သည် စစ်မှု ကို တွေ့မြင် သောအခါ စိတ်ပျက် ၍ ၊ အဲဂုတ္တု ပြည်သို့ ပြန်ကောင်းပြန် ကြလိမ့်မည်ဟု သိ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ထိုကြောင့် ဘုရား သခင်သည်၊ သူ တို့ကို ဧဒုံ ပင်လယ် နားတော လမ်း ဖြင့် ဝိုင်း၍ ဆောင် တော်မူ၏။ ဣသရေလ အမျိုးသား တို့သည်၊ ခင်းကျင်းသော တပ် အစဉ်အတိုင်းအဲဂုတ္တု ပြည် မှ ထွက် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","အထက်ကာလ၌ ယောသပ်က၊ အကယ်စင်စစ်ဘုရား သခင်သည် သင် တို့ကို အကြည့်အရှု ကြွလာ တော်မူမည်။ ကျွန်ုပ် အရိုး တို့ကို ဤ အရပ်မှ ယူ သွားရမည်ဟူ၍ဣသရေလ အမျိုးသား တို့ကို ကျပ်ကျပ်ကျိန်ဆို စေသောကြောင့် ၊ သူ ၏အရိုး တို့ကို မောရှေ သည် မိမိ ၌ ယူဆောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","တဖန် သူတို့သည် သုကုတ် အရပ်မှ ထွက် သွား၍ တော အနား ၊ ဧသံ မြို့၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","သူ တို့သည် နေ့ ည သွား နိုင် အောင် ထာဝရဘုရား သည် နေ့ ၌ကား၊ လမ်း ပြ ဘို့ မိုဃ်းတိမ် တိုင် အားဖြင့် ၎င်း ၊ ညဉ့် ၌ကား၊ အလင်း ပေးဘို့ မီး တိုင် အားဖြင့် ၎င်း၊ သူ တို့ရှေ့ က ကြွ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","နေ့ အချိန်၌ မိုဃ်းတိမ် တိုင် ၊ ညဉ့် အချိန်၌ မီး တိုင် ကို သူ တို့ရှေ့ မှ ရုပ်သိမ်း တော်မ မူ။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ထာဝရဘုရား ကလည်း ၊ ဣသရေလ အမျိုးသား တို့သည် လည် ၍ ၊ ပိဟဟိရုတ် မြို့နား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","မိဂဒေါလ မြို့နှင့် ပင်လယ် စပ်ကြား ၊ ဗာလဇေဖုန် မြို့ရှေ့ မှာ တပ်ချ စေခြင်းငှာ မှာ လိုက်လော့။ ထိုမြို့ရှေ့၊ ပင်လယ် ကမ်းနားမှာ တပ်ချ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","အကြောင်းမူကား၊ ဖာရော ဘုရင်က၊ ဣသရေလ အမျိုးသား တို့သည် ကျဉ်းကျုပ် ရာသို့ ရောက် ကြပြီ။ တော လမ်းပိတ် လျက်ရှိ၏ဟု ဆို လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ငါသည်လည်း ၊ ဖာရော ဘုရင်၏ နှလုံး ကို ခိုင်မာ စေ၍ ၊ သူသည် ဣသရေလ တို့ကို လိုက် လိမ့်မည်။ ငါ သည် ထာဝရဘုရား ဖြစ်ကြောင်းကို အဲဂုတ္တု လူတို့သည် သိ စေခြင်းငှာ၊ ထိုမင်း နှင့် သူ ၏စစ်သူရဲ အလုံးအရင်း အားဖြင့် ငါ့ဘုန်းပွင့် လိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း ၊ ထိုသူတို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ထိုလူ တို့ထွက်ပြေး ကြောင်း ကို၊ အဲဂုတ္တု ရှင်ဘုရင် အား ကြား ရှောက်သဖြင့် ၊ သူ မှစ၍ ကျွန် များတို့သည် မနာလိုသောစိတ် ဖောက်ပြန် လျှင်၊ ငါတို့သည် ဤ သို့ပြု ၍ ဣသရေလ လူတို့ကို ငါ တို့စေခိုင်း ရာမှ အဘယ်ကြောင့် လွှတ် ရသနည်းဟု ပြောဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ထိုအခါ ဖာရောဘုရင်သည်၊ ရထား တော်ကို ပြင် ၍ ၊ မိမိ လူ အပေါင်းတို့ကို ခေါ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ရွေး သော ရထား ခြောက် ရာ ၊ အဲဂုတ္တု မြင်းစီးသူရဲ အပေါင်း နှင့်တကွ ၊ ဗိုလ် မင်းအသီးအသီး တို့ကို ခေါ်ယူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ထာဝရဘုရား သည်၊ ဖာရော ဘုရင် ၏ နှလုံး ကို ခိုင်မာ စေတော်မူသဖြင့် ၊ သူသည် ဣသရေလ အမျိုးသား တို့ကို လိုက် လေ၏။ သို့သော်လည်း၊ ဣသရေလ လူ တို့သည် ဝါကြွား သောအခြင်းအရာနှင့် ထွက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ထိုသို့ ဖာရော ဘုရင်၏ မြင်း တော်၊ ရထား တော်၊ မြင်းစီးသူရဲ ဗိုလ်ပါ ၊ အဲဂုတ္တု လူအပေါင်းတို့သည် လိုက် ၍ ပိဟဟိရုတ် မြို့နား ၊ ဗာလဇေဖုန် မြို့ရှေ့ ၌ ပင်လယ် ကမ်းနားမှာ တပ်ချ လျက်နေသောဣသရေလ လူတို့ကို မှီ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ဖာရော ဘုရင်သည် ချဉ်း လာသောအခါ ၊ ဣသရေလ အမျိုးသား တို့သည် မြော် ကြည့်၍ ၊ အဲဂုတ္တု လူတို့ စစ်ချီ လာကြောင်းကို မြင် လျှင် ၊ အလွန် ကြောက်လန့် ၍ ထာဝရဘုရား အား အော်ဟစ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","မောရှေ ကို လည်း ၊ အဲဂုတ္တု ပြည်၌ သင်္ချိုင်း မ ရှိသောကြောင့် ၊ ဤတော ၌ သေ စေခြင်းငှာ ငါ တို့ကို ဆောင် ခဲ့သလော။ ငါ တို့ကို ဤ သို့ပြု ၍၊ အဲဂုတ္တု ပြည်မှ အဘယ်ကြောင့် ဆောင် ခဲ့သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ငါ တို့သည် အဲဂုတ္တု လူတို့ထံ၌ အစေ ကျွန်ခံနေလျက် ရှိ ကြပါစေဟု အဲဂုတ္တု ပြည်၌ ငါတို့ပြော ရာတွင်၊ ဤ အမှု ကို ရည်ဆောင်၍ ပြော သည်မဟုတ် လော။ ငါ တို့သည် ဤတော ၌ သေ ရသည်ထက် ၊ အဲဂုတ္တု လူတို့ထံ၌ အစေ ကျွန်ခံလျှင် သာ၍ ကောင်းသည်ဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","မောရှေ ကလည်း မ စိုးရိမ် ကြနှင့်။ ငြိမ်ဝပ်စွာရပ် နေကြ။ ထာဝရဘုရား သည်၊ ယနေ့ ပြ တော်မူသော ကယ်တင် ခြင်းကို ကြည့်ရှု ကြလော့။ သင်တို့သည် ယနေ့ မြင် သော အဲဂုတ္တု လူတို့ကို၊ နောက်တဖန် အလျှင်းမ မြင် ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","သင် တို့ဘက် ၌ ထာဝရဘုရား သည် စစ်တိုက် တော်မူလိမ့်မည်။ သင် တို့သည် ငြိမ်ဝပ် စွာနေရကြမည်ဟု လူ များတို့အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ထာဝရဘုရား ကလည်း ၊ အဘယ်ကြောင့် ငါ့ ကို အော်ဟစ် သနည်း။ ဣသရေလ အမျိုးသား တို့သည် တက်သွား စေခြင်းငှာ မှာ လိုက်လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","သင် မူကား ၊ လှံတံ ကို ချီ ပြီးလျှင် ၊ ပင်လယ် ပေါ် မှာ လက် ကိုဆန့် ၍ ပင်လယ် ရေကို ခွဲ လော့။ ဣသရေလ အမျိုးသား တို့သည် ပင်လယ် အလယ်၌ မြေ ပေါ် မှာ ရှောက်သွား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ငါ သည်လည်း အဲဂုတ္တု လူတို့၏ နှလုံး ကို ခိုင်မာ စေသဖြင့် ၊ သူတို့သည် လိုက် ကြလိမ့်မည်။ ဖာရော ဘုရင်နှင့် သူ ၏ဗိုလ်ခြေ ၊ ရထား ၊ မြင်းစီးသူရဲ များအားဖြင့် ငါ့ဘုန်းပွင့် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ထိုသို့ ဖာရော ဘုရင်နှင့် သူ ၏ရထား များ၊ မြင်းစီးသူရဲ များအားဖြင့် ငါ့ ဘုန်းပွင့် သောအခါ ၊ ငါ သည် ထာဝရဘုရား ဖြစ်ကြောင်းကို ၊ အဲဂုတ္တု လူတို့သည် သိရ ကြလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ထိုအခါ ဣသရေလ တပ် ရှေ့မှာ သွား သော ဘုရား သခင်၏ ကောင်းကင်တမန် သည် နောက်၌ လိုက် သဖြင့်၊ မိုဃ်းတိမ် တိုင် သည် သူ တို့ရှေ့ က ရွှေ့ ၍ နောက်၌ ရပ် နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ထိုသို့ အဲဂုတ္တု တပ် နှင့် ဣသရေလ တပ် စပ်ကြား သို့ ရောက် လျှင် ၊ အဲဂုတ္တုလူတို့၌ မိုက် သော မိုဃ်းတိမ် ဖြစ်၍၊ ဣသရေလလူတို့အား အလင်း ကိုပေး လျက်နေသဖြင့် ၊ တညဉ့် လုံး တပ်တဦး နှင့်တဦးမ ချဉ်း နိုင်ရာ။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","မောရှေ သည် ပင်လယ် ပေါ် မှာ လက် ကိုဆန့် ၍ ၊ ထာဝရဘုရား သည် တညဉ့် လုံး ၌ အားကြီး သော အရှေ့ လေ အားဖြင့် ပင်လယ် ရေကို လှန် ပြန်၍ ၊ မြေ ကို ပေါ်စေတော်မူသည်နှင့် ၊ ရေ သည် ကွဲပြတ် လျက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ဣသရေလ အမျိုးသား တို့သည် ပင်လယ် အလယ် ၌ မြေ ပေါ် မှာ ရှောက်သွား ကြ၍ ၊ ရေ သည် သူ တို့ လက်ျာ ဘက်၊ လက်ဝဲ ဘက်မှာ ကျောက်ထရံ ကဲ့သို့ရှိနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","အဲဂုတ္တု လူများ၊ ဖာရော ဘုရင်၌ပါသောမြင်း ၊ ရထား ၊ မြင်းစီးသူရဲ အပေါင်း တို့သည်၊ ပင်လယ် အလယ် သို့ လိုက် ဝင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","နံနက် ယံ ၌ ထာဝရဘုရား သည် မီး မိုဃ်းတိမ် တိုင် အားဖြင့် အဲဂုတ္တု တပ် ကို ကြည့်ရှု ၍ နှောင့်ရှက် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","သူ တို့ရထား အသွား ခက် စေခြင်းငှာ ရထားဘီး များကို ချို့တဲ့ စေတော်မူ၏။ အဲဂုတ္တု လူတို့ကလည်း ၊ ဣသရေလ လူတို့ထံမှ ပြေး ကြစို့။ ထာဝရဘုရား သည် သူ တို့ဘက်၊ အဲဂုတ္တု လူတို့တဘက်၌ စစ်တိုက် သည်ဟု ပြောဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ထာဝရဘုရား ကလည်း ၊ ပင်လယ်ရေ သည် အဲဂုတ္တု လူများ၊ ရထား များ၊ မြင်းစီးသူရဲ များတို့အပေါ် သို့ ပြန် စေခြင်းငှာ ၊ ပင်လယ် အပေါ် မှာ လက် ကိုဆန့် လော့ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","မိုဃ်းလင်း သောအခါ ၊ မောရှေ သည် လက် ကို ပင်လယ် ပေါ် မှာ ဆန့် သဖြင့် ၊ ပင်လယ် ရေသည် အားကြီး၍ ပြန် လာသည်ကို၊ အဲဂုတ္တု လူတို့သည် ပြေး ကြသော်လည်း၊ ထာဝရဘုရား သည် သူ တို့ကို ပင်လယ် အလယ် ၌ လှဲ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ထိုသို့ ပင်လယ်ရေ သည် ပြန်လာ ၍ ၊ ပင်လယ် ထဲသို့ လိုက် ဝင်သော ဖာရော ဘုရင်၏ ရထား ၊ မြင်းစီးသူရဲ ၊ ဗိုလ်ခြေ အပေါင်း တို့ကို လွှမ်းမိုး သဖြင့်၊ တစုံတယောက် မျှ မ ကျန်ရစ် ရ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ဣသရေလ အမျိုးသား တို့မူကား ၊ ပင်လယ် အလယ် ၌ မြေ ပေါ်မှာ ရှောက်သွား ၍ ၊ ရေ သည် သူ တို့လက်ျာ ဘက်၊ လက်ဝဲ ဘက်မှာ ကျောက်ထရံ ကဲ့သို့ရှိနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ထိုသို့ ထာဝရဘုရား သည် ထိုနေ့ ၌ ဣသရေလ လူတို့ကို ၊ အဲဂုတ္တု လူတို့လက် မှ ကယ်လွှတ် တော်မူသဖြင့် ၊ ပင်လယ် ကမ်းနား မှာ အဲဂုတ္တု လူ အသေ ကောင်တို့ကို မြင် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ထိုသို့ အဲဂုတ္တု လူတို့၌ ထာဝရဘုရား ပြု တော်မူသော အမှု ကြီး ကို၊ ဣသရေလ လူတို့သည် မြင် ၍ ၊ ထာဝရဘုရား ကို ကြောက်ရွံ့ ကြ၏။ ထာဝရဘုရား နှင့် ကိုယ်တော် ၏ ကျွန် မောရှေ ကို ယုံကြည် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ထိုအခါ မောရှေ နှင့် ဣသရေလ အမျိုးသား တို့သည်၊ ထာဝရဘုရား အား သီချင်း ဆို သော စကား ဟူမူကား ၊ ထာဝရဘုရားသည် ဘုန်းပွင့် လျက် အောင်ပွဲ ခံတော်မူသည်ဖြစ်၍ ၊ ကိုယ်တော် အား သီချင်း ဆိုပါအံ့။ မြင်း နှင့် မြင်းစီး သူရဲကို ပင်လယ် ထဲသို့ လှဲချ တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ထာဝရ ဘုရားသည် ငါ့ အစွမ်း သတ္တိ၊ ငါသီချင်း ဆိုကြောင်း၊ ငါ့ ကို ကယ်တင် သော အရှင်ဖြစ် တော်မူ၏။ ထို ဘုရား သည် ငါကိုးကွယ်သော ဘုရားသခင်ဖြစ်တော်မူ၍၊ ထောမနာ ပြုပါမည်။ ငါ့ ဘိုးဘေး တို့၏ ဘုရား သခင်ဖြစ်တော်မူ၍ ၊ ငါချီးမြှောက် ပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ထာဝရဘုရား သည် စစ်သူရဲ ဖြစ်တော်မူ၏။ ထာဝရ ဘုရားတည်းဟူသောနာမ တော်ရှိတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ဖာရော ဘုရင်၏ ရထား နှင့် ဗိုလ်ခြေ တို့ကို ပင်လယ် ထဲသို့ လှဲချ တော်မူပြီ။ ရွေး သော ဗိုလ် မင်းတို့သည်၊ ဧဒုံ ပင်လယ် ထဲ၌ မြုပ် လျက်ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","နက် စွာသောအရပ်၌ လွှမ်းမိုး လျက်ရှိကြ၏။ ကျောက် ကဲ့သို့ အောက် သို့ ဆင်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","အို ထာဝရဘုရား ၊ လက်ျာ လက်တော်သည် တန်ခိုး အားဖြင့် ဘုန်းကြီး တော်မူ၏။ အို ထာဝရဘုရား ၊ လက်ျာ လက်တော်သည် ရန်သူ တို့ကို ချိုးဖဲ့ ဖျက်ဆီးတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ကိုယ်တော် တဘက်၌ ထ သောသူတို့ကို၊ ဘုန်း တန်ခိုးအာနုဘော်တော်တို့နှင့် လှဲ တော်မူ၏။ အမျက် တော်ကို လွှတ် ၍၊ သူ တို့ကို အမှိုက် ကဲ့သို့ မီးလောင် စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","နှာခေါင်း တော်လေ အားဖြင့် ရေ သည် စုဝေး ၍ ၊ စီး သောရေသည် ပုံ့ပုံ့ကြွ ၍၊ ပင်လယ် ၏အထဲ ၌ ပင် နက် သောရေသည် တောင့်မာ လျက်နေရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ရန်သူ က၊ ငါလိုက် မည်။ သူတို့ကို မှီ လိမ့်မည်။ လုယူသောဥစ္စာ ကို ဝေ ၍ သူ တို့၌ ငါ ချင်ရဲပြေ လိမ့်မည်။ ထား ကို အိမ်မှ ထုတ် ၍ သူ တို့ကို ငါ့ လက် နှင့် ဖျက်ဆီး မည်ဟု ဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ကိုယ်တော် သည် လေ ကို မှုတ် တော်မူသဖြင့် ၊ ပင်လယ် သည် သူ တို့ကို လွှမ်းမိုး ၍ သူတို့သည် အားကြီး သောရေ ထဲ မှာ ခဲ ကဲ့သို့ ဆင်း ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","အို ထာဝရဘုရား ၊ ဘုရား များတို့တွင် အဘယ်မည် သော ဘုရားသည် ကိုယ်တော် နှင့်တူ ပါသနည်း။ သန့်ရှင်း ခြင်းအားဖြင့် ဘုန်းကြီး တော်မူထသော၊ ချီးမွမ်းခြင်းကိုခံ စဉ်တွင်၊ ကြောက်မက် ဘွယ် ဖြစ်တော်မူထသော၊ အံ့ဘွယ် သောအမှုတို့ကို ပြု တော်မူသော၊ ကိုယ်တော် နှင့် အဘယ် ဘုရား တူ ပါသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","လက်ျာ လက်တော်ကို ဆန့် တော်မူသဖြင့်၊ သူ တို့ကို မြေ မြှုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ရွေး တော်မူသော လူ မျိုးကို ကရုဏာ တော်အားဖြင့် ပို့ဆောင် တော်မူ၏။ သန့်ရှင်း သော နေ တော်မူရာသို့ တန်ခိုး တော်အားဖြင့် လမ်းပြ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","လူမျိုး တို့သည် သိတင်းကြား ၍ ကြောက်လန့် ကြလိမ့်မည်။ ပါလေတ္တိန ပြည်သူ ပြည်သားတို့သည် ပူပန် ခြင်းသို့ ရောက် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ဧဒုံ ဗိုလ် တို့သည် မိန်းမော တွေဝေခြင်း၊ မောဘ သူရဲ တို့သည် တုန်လှုပ် ခြင်း၊ ခါနာန် ပြည်သား အပေါင်း တို့ သည် စိတ်ပျက် ခြင်းသို့ ရောက် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","အို ထာဝရဘုရား ၊ ကိုယ်တော် ၏လူ တို့သည် လွန် သွားသောအခါ ၊ ရွေး တော်မူသော ကိုယ်တော်၏လူ တို့ သည် လွန်သွား သောအခါ ၊ ထိုလူအမျိုးမျိုးတို့သည် ကြောက်သောစိတ်၊ ထိတ်လန့်သောစိတ်အားကြီး၍ လက်ရုံး တော်တန်ခိုး ကြောင့် ၊ သူတို့သည် ကျောက် ကဲ့သို့ ငြိမ်ငြိမ် နေကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","အို ထာဝရ ဘုရား၊ အမွေခံ တော်မူရာ တောင် တည်းဟူသောကျိန်းဝပ် တော်မူရာ ဘို့ ဖန်ဆင်း တော်မူသော အရပ်ထဲသို့ ကိုယ်တော်၏လူ တို့ကို သွင်း တော်မူလိမ့်မည်။ အို ထာဝရဘုရား ၊ လက် တော်နှင့် တည် တော်မူသော သန့်ရှင်း ရာဌာနတော်၌ နေရာချတော်မူလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ထာဝရဘုရား သည် ကာလ အစဉ်အမြဲ စိုးစံ တော်မူစေသတည်းဟု သီချင်းဆို ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","အကြောင်းမူကား၊ ဖာရော ဘုရင်၏ မြင်း များ၊ ရထား များ၊ မြင်းစီးသူရဲ များတို့သည် ပင်လယ် ထဲသို့ ဝင် ၍ ၊ ထာဝရဘုရား သည် သူ တို့အပေါ် မှာ ပင်လယ် ရေ ကို လွှမ်းမိုး စေတော်မူ၏။ ဣသရေလ အမျိုးသား တို့မူကား ၊ ပင်လယ် အလယ် ၌ မြေ ပေါ် မှာ ရှောက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","အာရုန် ၏ အစ်မ ဖြစ်သော ပရောဖက်မ မိရိအံ သည် ပတ်သာ ကို ကိုင် ၍ ၊ မိန်းမ အပေါင်း တို့သည် ပတ်သာ တီးလျက် က လျက် လိုက် သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","မိရိအံ ကလည်း ၊ ထာဝရဘုရားသည် ဘုန်းပွင့် လျက် အောင်ပွဲ ကို ခံတော်မူသည်ဖြစ်၍ ၊ ကိုယ်တော် အား သီချင်း ဆိုကြလော့။ မြင်း နှင့် မြင်းစီး သူရဲကို ပင်လယ် ထဲသို့ လှဲချ တော်မူပြီဟု သူ တို့နှင့် အသံပြိုင်၍ ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ထိုနောက် မောရှေ သည် ဣသရေလ လူတို့ကို၊ ဧဒုံ ပင်လယ် မှ ဆောင်သွား ၍ ၊ သူတို့သည် ရှုရ တော သို့ ရောက် ကြ၏။ ထိုတော ၌ သုံး ရက် ခရီးသွား ၍ ရေ ကို မ တွေ့ မရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","မာရ အရပ်သို့ ရောက် သောအခါ ၊ မာရ ရေ သည် ခါး သောကြောင့် မ သောက် နိုင် ကြ။ ထိုကြောင့် ထိုအရပ်ကို မာရ ဟု သမုတ် ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","လူ များတို့သည် မောရှေ ကို အပြစ်တင် ၍ မြည်တမ်းလျက်၊ အဘယ်သို့ သောက် ရပါမည်နည်းဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","မောရှေသည် ထာဝရဘုရား အား အော်ဟစ် ၍ ထာဝရဘုရား သည် သစ်ပင် တပင်ကို ပြ တော်မူ၏။ ထိုအပင်ကို ရေ ထဲသို့ ချ ပြီးလျှင် ၊ ရေ သည် ချို လေ၏။ ထို အရပ်၌ သူ တို့ကို စုံစမ်း ၍ စီရင် ထုံးဖွဲ့ တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","သင်တို့သည် သင်တို့၏ ဘုရား သခင်ထာဝရဘုရား ၏ စကား ကို စေ့စေ့နားထောင် ၍ နှစ်သက် တော်မူသောအကျင့်ကို ကျင့် လျှင်၎င်း၊ ပညတ် တရားတော်အလိုသို့ လိုက် ၍ စီရင် တော်မူချက်တို့ကို စောင့်ရှောက် လျှင် ၎င်း၊ ငါသည် အဲဂုတ္တု လူတို့၌ စွဲ စေသော ရောဂါ တစုံ တခုကိုမျှ သင် တို့၌ မ စွဲ စေ။ ငါ သည် သင် တို့၏ ရောဂါ ကို ငြိမ်းစေသော ထာဝရဘုရား ဖြစ်သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ထိုနောက်မှ ရေတွင်း ဆယ် နှစ် တွင်း၊ စွန်ပလွံ ပင် ခုနစ်ဆယ် နှင့် ပြည့်စုံရာ ဧလိမ် ရွာသို့ ရောက် ၍ ၊ ထို အရပ်တွင် ရေ ရှိရာအနား မှာ တပ်ချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","တဖန် ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့သည်၊ ဧလိမ် အရပ်မှ ထွက်၍ ခရီးသွား ကြ၏။ အဲဂုတ္တု ပြည် မှ ထွက်သွား သောနောက်၊ ဒုတိယ လ ဆယ် ငါး ရက် နေ့တွင် ၊ ဧလိမ် အရပ်နှင့် သိနာ တောင် စပ်ကြား မှာ သိန် တော သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ထိုတော ၌ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့က၊ ");
INSERT INTO myajvb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ငါတို့သည် အဲဂုတ္တု ပြည် ၌ အမဲသား ချက်သော အိုး ကင်းနား မှာ ထိုင် ၍ ဝ စွာစား ရသောအခါ ၊ ထာဝရဘုရား ၏ လက် တော်ဖြင့် သေ လျှင် သာ၍ကောင်း၏။ ယခု မူကား၊ ဤ စည်းဝေး လျက်ရှိသောလူအပေါင်း တို့ကို ငတ်မွတ် ခြင်းအားဖြင့် သတ် လိုသောငှာ ၊ ဤ တော အရပ်သို့ ဆောင် ခဲ့ပြီတကားဟု မောရှေ နှင့် အာရုန် ကို အပြစ်တင် ၍ မြည်တမ်းလျက်ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ထိုအခါ ထာဝရဘုရား က ကြည့်ရှု လော့။ ငါ သည် သင် တို့အဘို့ မိုဃ်းကောင်းကင် က မုန့် မိုဃ်း ကို ရွာစေမည်။ လူ တို့သည် နေ့တိုင်းထွက် ၍ တနေ့ စားလောက်အောင် သိမ်း ယူရကြမည်။ ငါ ၏တရား အတိုင်း ကျင့် မည်လော၊ မ ကျင့်လောဟု ထို သို့သောအားဖြင့် သူ တို့ကို ငါစုံစမ်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","နေ့ တိုင်းသိမ်းယူ သော အရာ ထက် ၊ ခြောက် ရက်မြောက်သောနေ့ ၌ နှစ်ဆ ကို သိမ်းယူ ၍ ပြင် ရကြမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","မောရှေ နှင့် အာရုန် တို့ကလည်း ၊ ထာဝရဘုရား သည် သင် တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် တော်မူသည် ဟု ယနေ့ညဦး ယံ၌ သင်တို့သိ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","နံနက် ယံ၌ လည်း ၊ ထာဝရဘုရား ၏ ဘုန်း တော်ကို မြင် ရကြလိမ့်မည်။ ထာဝရဘုရား ကို အပြစ်တင်လျက် မြည်တမ်း ကြသောအသံကိုကြား တော်မူပြီ။ ငါ တို့ကို အပြစ်တင်လျက် မြည်တမ်း စေခြင်းငှာ ၊ ငါ တို့သည် အဘယ်သို့ သောသူဖြစ် သနည်းဟု ဣသရေလ အမျိုးသား အပေါင်း တို့အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","တဖန် လည်းမောရှေ က၊ ထာဝရဘုရား သည် ညဦး ယံ၌ သင် တို့စား စရာအမဲသား ကို၎င်း ၊ နံနက် ယံ၌ ဝ လောက်အောင် မုန့် ကို၎င်းပေး တော်မူသောအခါ ၊ ဤစကားပြည့်စုံလိမ့်မည်။ သင် တို့သည် အပြစ်တင်လျက် မြည်တမ်း ကြသော အသံကို ထာဝရဘုရား ကြား တော်မူပြီ။ ငါ တို့သည် အဘယ်သို့ သောသူဖြစ် သနည်း။ သင် တို့သည် အပြစ်တင်လျက် မြည်တမ်း ကြသော စကားသည်၊ ငါ တို့ကို မ ထိ မခိုက်၊ ထာဝရဘုရား ကို ထိခိုက် သည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","တဖန် သင် တို့သည် အပြစ်တင်လျက်၊ မြည်တမ်း သောအသံကို ထာဝရဘုရား ကြား တော်မူသည် ဖြစ်၍ ၊ အထံ တော်သို့ ချဉ်းကပ် ကြလော့ဟု ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့အား ဆင့်ဆို လော့ဟု အာရုန် ကို မှာ ထားသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","အာရုန် သည် ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့အား ဆင့်ဆို သောအခါ၊ သူတို့သည် တော သို့ မြော် ကြည့်၍ ၊ မိုဃ်းတိမ် ၌ ထင်ရှား သော ထာဝရဘုရား ၏ ဘုန်း တော်ကို မြင် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ထာဝရဘုရား ကလည်း ၊ ဣသရေလ အမျိုးသား တို့သည် အပြစ်တင်လျက် မြည်တမ်း သောအသံကို ငါကြား ရပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","ညဦး ယံ၌ သင်တို့သည် အမဲသား ကို စား ရကြလိမ့်မည်။ နံနက် ယံ၌ လည်း မုန့် နှင့် ဝ ရကြလိမ့်မည်။ ငါ သည် သင် တို့၏ဘုရား သခင်ထာဝရဘုရား ဖြစ်ကြောင်းကို သိ ကြလိမ့်မည်ဟု သူ တို့ကို ပြော လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ညဦး ယံ၌ ငုံး ငှက်တို့သည် တပ် ကိုအနှံ့အပြားတက် လာကြ၏။ နံနက် ယံ၌ လည်း တပ် ပတ်လည် အရပ်ရပ်တွင် နှင်း ကျ လျက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","နှင်း တက် ပြီးသောအခါ ၊ နှင်းခဲ ကဲ့သို့ သေးသေး လုံးလုံး အရာသည် မြေ မျက်နှာပေါ် မှာ ရှိရစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ထို အရာကို ဣသရေလ အမျိုးသား တို့သည် မြင် သောအခါ ၊ အဘယ် အရာနည်းဟု မ သိ သောကြောင့် ၊ တ ယောက်ကို တယောက်မေး ကြ၏။ မောရှေ ကလည်း ၊ ဤ အရာသည်သင် တို့စားစရာ ဘို့ ထာဝရဘုရား ပေး သနားတော်မူသော မုန့် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","လူတိုင်း မိမိ တဲ ၌ ရှိသော သူ အရေအတွက် နှင့်အညီ၊ လူအသီးအသီး စား လောက်အောင် တယောက်တဩမဲ စီ သိမ်းယူ ကြလော့ဟု ထာဝရဘုရား မိန့် တော်မူကြောင်းကို ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ဣသရေလ အမျိုးသား တို့သည် ထိုသို့ ပြု ၍ ၊ အနည်း အများ အလိုက် သိမ်းယူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ဩမဲ တောင်းနှင့် ခြင် ကြသောအခါ ၊ များ များရသောသူမ ပို ၊ နည်းနည်း ရသောသူ မ လို ၊ အသီးအသီး တို့သည် စား လောက်အောင် သိမ်း ယူကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","မောရှေ ကလည်း ၊ နံနက် တိုင်အောင် အဘယ်သူမျှ မ ကျန် စေနှင့်ဟု ဆို သော်လည်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","အချို့တို့သည် မောရှေ စကားကို နား မ ထောင်ဘဲ၊ နံနက် တိုင်အောင် ကျန် စေသဖြင့် ၊ ပိုး ဖြစ် ၍ နံ လေသော် ၊ မောရှေ သည် အမျက် ထွက်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ထိုသူ အသီးအသီးတို့သည် နေ့ တိုင်း မိမိ တို့စား လောက် သမျှကို သိမ်းယူ ကြ၏။ နေ ပူ သောအခါ အရေ ဖြစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ခြောက် ရက်မြောက်သောနေ့ ၌ ၊ မုန့် နှစ်ဆ တည်းဟူသောတယောက်နှစ် ဩမဲ စီ သိမ်း ရကြ၏။ ထိုအကြောင်းကို ပရိသတ် အုပ် အပေါင်း တို့သည် မောရှေ အား ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","သူကလည်း၊ နက်ဖြန် နေ့သည် ထာဝရဘုရား ရှေ့ ၌ သန့်ရှင်း သောဥပုသ် နေ့၊ ငြိမ်ဝပ် စွာနေရသောနေ့ဖြစ်၏။ မုန့်ကို ပေါင်း ချင်သည်အတိုင်း ပေါင်း ကြလော့။ ပြုတ် ချင်သည်အတိုင်း ပြုတ် ကြလော့။ ကျန် သောအရာ ကို နံနက် တိုင်အောင် စောင့် ၍ သို ထားကြလော့ဟု ထာဝရဘုရား မိန့် တော်မူကြောင်းကို ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","မောရှေ မှာ ထားသည်အတိုင်း ၊ နံနက် တိုင်အောင် သို ထားကြ၏။ နံ ခြင်းနှင့် ကင်းလွတ် ၏။ ပိုး လည်း မ ရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","မောရှေ ကလည်း ၊ ကျန်သောအရာကို ယနေ့ စား ကြလော့။ ယနေ့ သည် ထာဝရဘုရား ၏ ဥပုသ် နေ့ဖြစ်၏။ ယနေ့ တွင် ထိုအရာကို တော ၌ မ တွေ့ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ခြောက် ရက် ပတ်လုံးသိမ်းယူ ရကြ၏။ ဥပုသ် နေ့တည်းဟူသောခုနစ် ရက်မြောက်သောနေ့ တွင် မ ရှိ မတွေ့ရဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ခုနစ် ရက်မြောက်သောနေ့ ၌ ၊ အချို့ တို့သည် သိမ်းယူ ခြင်းငှာ ထွက်သွား ရာတွင်၊ ရှာ၍ မ တွေ့ ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ထာဝရဘုရား ကလည်း၊သင်တို့သည်ငါ့ ပညတ် တရား များတို့ကိုအဘယ် မျှကာလ ပတ်လုံးငြင်းပယ် ကြလိမ့်မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ထာဝရဘုရား သည် ဥပုသ် နေ့ကို သင် တို့အား ပေး တော်မူပြီ။ ထိုကြောင့် ခြောက် ရက်မြောက်သောနေ့ ၌ နှစ်ရက် အတွက်မုန့် ကိုပေး တော်မူ၏။ လူ တိုင်းမိမိ နေရာ ၌နေ စေ၊ ခုနစ် ရက်မြောက်သောနေ့ ၌ မိမိ နေရာ မှ အဘယ်သူမျှ မ သွား စေနှင့်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ထိုကြောင့် လူ များတို့သည်ခုနစ် ရက်မြောက်သောနေ့ ၌ ငြိမ်ဝပ် စွာနေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ဣသရေလ အမျိုးသား တို့သည် ထို စားစရာကို မန္န ဟုခေါ်ဝေါ် ကြ၏။ နံနံ စေ့ ကဲ့သို့ ဖြစ်၍ ဖြူ သောအဆင်းရှိ၏။ ပျားရည် နှင့် ရောသောမုန့်ကြွပ် နှင့် အရသာ တူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","မောရှေ ကလည်း ၊ သင် တို့ကိုအဲဂုတ္တု ပြည် မှ ငါ နှုတ်ဆောင် သောအခါ ၊ တော ၌ သင် တို့အား ကျွေး သော မုန့် ကို၊ သင် တို့အမျိုး အစဉ်အဆက်တို့သည်မြင် စေခြင်းငှာ ၊ သူတို့အဘို့သို ထားရသောဩမဲ တဩမဲကိုဖြည့် ကြလော့ဟု ထာဝရဘုရား မိန့် တော်မူကြောင်းကို ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","တဖန် အာရုန် ကို လည်း၊ အိုး တလုံး ကိုယူ ၍ မန္န တဩမဲ ကိုအပြည့် ထည့် ပြီးလျှင်၊ သင် တို့လူမျိုး အစဉ်အဆက်ဘို့ စောင့် စေခြင်းငှာ ၊ ထာဝရ ဘုရားရှေ့တော်၌ သို ထားလော့ဟုဆို ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","မောရှေ ကို ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ ထိုမန္နကိုအာရုန် စောင့် စေခြင်းငှာ ၊ သက်သေ တော်ရှေ့ မှာသို ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ဣသရေလ အမျိုးသား တို့သည်၊ လူနေ ရာပြည် သို့ မ ရောက် မှီတိုင်အောင်၊ အနှစ် လေးဆယ် ပတ်လုံးမန္န ကိုစား ကြ၏။ ခါနာန် ပြည် နယ်နိမိတ် သို့ မ ရောက် မှီတိုင်အောင် မန္န ကိုစား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ဩမဲ မူကား ၊ ဧဖာ ဆယ်စု တစုဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့သည်၊ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ သိန် တော ထဲက ထွက်၍ ခရီး သွား သဖြင့် ၊ ရေဖိဒိမ် အရပ်၌ စားခန်းချ ကြ၏။ ထိုအရပ်၌ လူ များသောက် ဘို့ ရာရေ မ ရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ထိုကြောင့် လူ များတို့က၊ သောက် ဘို့ရေ ပေး ပါဟု ဆို ၍ မောရှေ ကို ရန်တွေ့ ကြ၏။ မောရှေ ကလည်း ၊ ငါ့ ကို အဘယ်ကြောင့် ရန်တွေ့ ကြသနည်း။ ထာဝရဘုရား ကို အဘယ်ကြောင့် စုံစမ်း ကြသနည်းဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","လူ များတို့သည် ရေ ငတ် ၍ မောရှေ ကို အပြစ်တင်မြည်တမ်း လျက်၊ ငါ တို့မှစ၍ သားသမီး တိရစ္ဆာန် တို့ကို အငတ် ထား၍ သတ် ခြင်းအလိုငှာ ၊ အဲဂုတ္တု ပြည်မှ အဘယ်ကြောင့် ဆောင် ခဲ့သနည်းဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ထိုအခါ မောရှေ သည်ထာဝရဘုရား အား အော်ဟစ် ၍၊ ဤ လူ တို့အား အကျွန်ုပ်သည်အဘယ်သို့ ပြု ရပါမည်နည်း။ အကျွန်ုပ် ကိုခဲနှင့်ပစ် လု ကြပါပြီဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ထာဝရဘုရား ကလည်း ၊ လူ များရှေ့ သို့သွား ၍ ဣသရေလ အမျိုးအသက် ကြီးသူတို့ကိုခေါ် လော့။ မြစ် ကိုရိုက် သော သင် ၏လှံတံ ကိုကိုင် လျက် ၊ ဟောရပ်အရပ်သို့သွား လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ထို အရပ်၌ ရှိသောကျောက် ပေါ် တွင် သင့် ရှေ့ မှာငါ ရပ် နေမည်။ သင်သည် ထိုကျောက် ကိုရိုက် ရမည်။ လူများသောက် ဘို့ ထို ကျောက်ထဲက ရေ ထွက် လိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ မောရှေ သည်လည်း ဣသရေလ အမျိုးအသက်ကြီး သူတို့ရှေ့ မှာ ထို သို့ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ဣသရေလ အမျိုးသား တို့က၊ ထာဝရဘုရား သည် ငါ တို့တွင် ရှိ သလော မရှိ လောဟု ထာဝရဘုရား ကို စုံစမ်း ၍ ရန်တွေ့ သောအကြောင်းကြောင့် ၊ ထိုအရပ် ကို မဿာ နှင့် မေရိဘ ဟု သမုတ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ထိုအခါ အာမလက် လူတို့သည် လာ ၍ ၊ ရေဖိဒိမ် အရပ်၌ ဣသရေလ လူတို့ကို စစ်တိုက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","မောရှေ ကလည်း ၊ လူ တို့ကိုရွေး ၍ အာမလက် လူတို့ကို စစ် တိုက်ခြင်းငှာ ထွက် လော့။ နက်ဖြန် နေ့၌ ဘုရား သခင်၏လှံတံ ကိုကိုင် လျက်၊ တောင် ထိပ် ပေါ် မှာ ငါ ရပ် နေမည်ဟု ယောရှု အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","မောရှေ မှာ လိုက်သည်အတိုင်း ယောရှု ပြု ၍ ၊ အာမလက် လူတို့ကို စစ် တိုက်လေ၏။ မောရှေ ၊ အာရုန် ၊ ဟုရ တို့သည် တောင် ထိပ် ပေါ်သို့တက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","မောရှေ သည် လက် ကိုချီ သောအခါ ၊ ဣသရေလ လူတို့သည် နိုင် ကြ၏။ လက် ကိုချ သောအခါ ၊ အာမလက် လူတို့သည် နိုင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","သို့ရာတွင် မောရှေ ၏လက် သည်ညောင်း သောကြောင့် ၊ သူတို့သည် ကျောက် ကိုယူ ၍ မောရှေကိုထိုင် စေပြီးလျှင် ၊ အာရုန် နှင့် ဟုရ တို့သည် တယောက် တဘက်နေ၍ သူ ၏လက် ကိုမ ကြ၏။ သို့ဖြစ်၍ နေ ဝင် သည်တိုင်အောင် သူ ၏လက် တို့သည် အမြဲနေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ယောရှု သည်လည်း အာမလက် မင်းနှင့် လူ များတို့ကို ထား လက်နက် ဖြင့် လုပ်ကြံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ထာဝရဘုရား ကလည်း ၊ ဤ အမှုကိုအောက်မေ့ စရာဘို့စာရေး ထား၍ ယောရှု အား ဘတ်ရွတ် လော့။ အကြောင်း မူကား၊ ကောင်းကင် အောက် ၌ အာမလက် ၏အမှတ် ရှိသမျှကို ငါပယ်ရှင်း မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","မောရှေ သည်လည်း ယဇ် ပလ္လင်ကို တည် ၍ ၊ ယေဟောဝါ နိဿိ ဟု သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","အကြောင်းမူကား၊ အာမလက်လူမျိုး၏လက် သည် ထာဝရ ဘုရား၏ရာဇပလ္လင် တော်၏ရန်ဘက်ဖြစ်သောကြောင့် ၊ ထာဝရဘုရား သည် ကာလအစဉ်အဆက် အာမလက် အမျိုး ကို စစ် တိုက်တော်မူလိမ့်မည်ဟု ဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ဘုရား သခင်သည် မောရှေ မှစ၍ ကိုယ်တော် ၏လူ ဣသရေလ အမျိုးအဘို့ ပြု တော်မူသမျှ ကို ၎င်း၊ ထာဝရဘုရား သည် ဣသရေလ အမျိုးကို အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူကြောင်းကို၎င်း၊ မိဒျန် ယဇ် ပုရောဟိတ်ဖြစ်သောမောရှေ ၏ယောက္ခမ ယေသရော ကြား သည်ရှိသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","မောရှေလွှတ်ခဲ့သောမယားနှင့် ");
INSERT INTO myajvb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","သူ ၏သား နှစ် ယောက်ကို ယူ၍ သွားလေ၏။ သားတယောက် ကား၊ ဂေရရှုံ အမည် ရှိ၏။ အကြောင်းမူကား ၊ ငါသည် တကျွန်း တနိုင်ငံ၌ ဧည့်သည် အာဂန္တုဖြစ် ရပြီဟု အဘဆို သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","သားတယောက်ကား၊ ဧလျေဇာ အမည် ရှိ၏။ အကြောင်း မူကား၊ ငါ့ ဘိုးဘေး တို့၏ ဘုရားသခင် သည် ငါ့ ကို မစ ၍ ဖာရော ဘုရင်၏ ထား မှ ကယ်လွှတ် တော်မူပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","မောရှေ ၏ ယောက္ခမ ယေသရော သည် မောရှေ မယား နှင့် သား တို့ကို ယူ၍၊ တော ၌ ဘုရား သခင်၏ တောင် တော်နား၊ မောရှေ တပ်ချ ရာအရပ်သို့ ရောက် လာလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ကိုယ်တော် ၏ယောက္ခမ ယေသရော နှင့် ကိုယ်တော် ၏ မယား ၊ သား နှစ် ယောက်တို့သည် ကိုယ်တော် ထံ သို့ရောက် လာပါပြီဟု မောရှေ အား ကြား ပြောသော် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","မောရှေ သည် ယောက္ခမ ကို ခရီးဦးကြိုပြု ခြင်းငှာ ထွက် ၍ ဦးချ နမ်း ရှုပ်လျက် ၊ ကျန်းမာ ကြောင်း ကို တ ယောက်နှင့်တယောက် မေးမြန်း လျက် တဲ သို့ ဝင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ထာဝရဘုရား သည် ဣသရေလ အမျိုးအတွက် ဖာရော ဘုရင်နှင့် အဲဂုတ္တု လူတို့၌ ပြု တော်မူသမျှ ကို ၎င်း၊ လမ်းခရီး တွင် ခံ ရသောဆင်းရဲ ဒုက္ခအလုံးစုံ ကို၎င်း၊ ထိုဆင်းရဲဒုက္ခမှ ထာဝရဘုရား ကယ်လွှတ် တော်မူကြောင်းကို၎င်း၊ မောရှေ သည် ယောက္ခမ အား ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ထာဝရဘုရား သည် ဣသရေလ အမျိုးကို အဲဂုတ္တု လူတို့လက် မှ ကယ်နှုတ် ၍၊ ပြု တော်မူသောကျေးဇူး ကြောင့် ယေသရော သည် ဝမ်းမြောက် လျက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","အဲဂုတ္တု လူတို့လက် မှ၎င်း ၊ ဖာရော ဘုရင်လက် မှ ၎င်း၊ သင့် ကို ကယ်နှုတ် တော်မူထသော ၊ လူ များတို့ကို အဲဂုတ္တု လူတို့လက် မှ ကယ်နှုတ် တော်မူသော ထာဝရဘုရား သည် မင်္ဂလာ ရှိတော်မူစေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ထာဝရဘုရားသည် အခြားသောဘုရား ရှိသမျှ တို့ထက် သာ၍ကြီးမြတ် တော်မူကြောင်းကို ယခု ငါသိ ၏။ အကြောင်း မူကား၊ လူတို့သည် မာန ထောင်လွှားသော အမှု အရာတွင်၊ ထာဝရဘုရားနိုင်တော်မူ၏ဟု ဆိုပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","မောရှေ ၏ ယောက္ခမ ယေသရော သည်၊ မီးရှို့ စရာယဇ်နှင့် ဘုရား သခင်အဘို့ ယဇ် များကို ဆောင် ခဲ့၍ ၊ အာရုန် နှင့် ဣသရေလ အမျိုး အသက်ကြီး သူအပေါင်း တို့သည်၊ မောရှေ ၏ ယောက္ခမ နှင့် အတူဘုရား သခင့်ရှေ့ တော်၌ အစာ စား ခြင်းငှာ လာ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","နက်ဖြန် နေ့၌ မောရှေ သည်၊ လူ များကို တရား စီရင်ခြင်းငှာ ထိုင် လေ၏။ နံနက် မှစ၍ ညဦး တိုင်အောင် ၊ လူ များတို့သည် မောရှေ ရှေ့ မှာ နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","မောရှေ သည် လူ များတို့အား ပြု သမျှ ကို ယောက္ခမ မြင် လျှင် ၊ ဤ လူ များတို့အား ပြု သောအမှု အဘယ် သို့နည်း။ သင် သည် တယောက်တည်းထိုင် လျက် ၊ လူ အပေါင်း တို့သည် နံနက် မှစ၍ ညဦး တိုင်အောင် သင့် ရှေ့ မှာ အဘယ် ကြောင့်နေ ရကြသနည်းဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","မောရှေ ကလည်း ၊ ဤသူတို့သည် ဘုရား သခင်၏ အယူ တော်ကိုခံ လို၍ ကျွန်ုပ် ထံ သို့လာ သောကြောင့် ဤသို့ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","သူ တို့သည် အမှု ရှိ လျှင် အကျွန်ုပ် ထံ သို့လာ ၍ သူတို့၏အမှုကို ကျွန်ုပ်ဆုံးဖြတ် ရ၏။ ဘုရား သခင်၏ ပညတ် တရား များကို သင် ချရ၏ဟု ယောက္ခမ အား ပြော လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ယောက္ခမ က၊ သင် ပြု သော အမှု သည် မ တော် မသင့်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","သင် မှစ၍ သင် ၌ ပါသော ဤ လူ များတို့သည် အမှန် အားလျော့ ကြလိမ့်မည်။ ဤအမှုသည် သင်၌ အလွန် လေး၏။ တယောက်တည်း မ တတ် နိုင်သောအမှု ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ငါ့ စကား ကို နားထောင် လော့။ ငါအကြံ ပေးမည်။ ဘုရား သခင်သည်လည်း သင့် ဘက်၌ ရှိ တော်မူလိမ့်မည်။ သင် သည် ဘုရား သခင်နှင့်ဆိုင် သော အမှု ၌ လူများတို့၏ အမှုကို စောင့်လျက် ဘုရား သခင်အထံ တော်သို့ ဝင်၍ လျှောက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","သူ တို့အားလည်း ပညတ် တရား တော်များကို သင် ချရမည်။ သူ တို့သွား ရာလမ်း ၊ ပြု ရသော အမှု ကိုလည်း ပြ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ထိုမှတပါး ဘုရား သခင်ကို ကြောက်ရွံ့ လျက်၊ သစ္စာ နှင့်ပြည့်စုံလျက်၊ လောဘ ကို ရွံရှာ လျက် ၊ တတ်စွမ်း နိုင်သောသူ တို့ကို လူ အပေါင်း တို့အထဲ က ရွေးကောက် ၍၊ တထောင် အုပ် ၊ တရာ အုပ် ၊ ငါးဆယ် အုပ် ၊ တဆယ် အုပ် အရာ၌ ခန့် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ထိုသူတို့သည် ခပ်သိမ်း သောအချိန် ၌ လူ များတို့ကို တရား စီရင်ကြစေ။ ကြီး သောအမှု ၌ သင် ၏အယူ ကို ခံကြစေ။ ငယ် သောအမှု ကို အလိုလို စီရင် ကြစေ။ သို့ဖြစ်လျှင် သူတို့သည် ဝိုင်းညီ၍ အမှုထမ်း သဖြင့် သင် သည် သက်သာ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ထိုသို့ ဘုရား သခင်အခွင့် နှင့် ပြု လျှင် သင်သည် ခိုင်ခံ့ လိမ့်မည်။ ဤ လူ အပေါင်း တို့သည် မိမိ နေရာ ပြည် သို့ ငြိမ်ဝပ် စွာ သွား ကြလိမ့်မည်ဟု ပြော ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","မောရှေ သည်လည်း ယောက္ခမ ၏စကား ကို နားထောင် ၍ စကား ရှိသည်အတိုင်း ပြု လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","တတ်စွမ်း နိုင်သောသူ တို့ကို ဣသရေလ အမျိုးထဲက ရွေးကောက် ၍ လူတထောင် အုပ် ၊ တရာ အုပ် ၊ ငါးဆယ် အုပ် ၊ တဆယ် အုပ် အသီးအသီးခေါင်း အရာ၌ ခန့် ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ထိုသူတို့သည် ခပ်သိမ်း သောအချိန် ၌ လူ တို့ကို တရား စီရင်ကြ၏။ ခက် သောအမှု ၌ မောရှေ ၏အယူ ကို ခံကြ၏။ လွယ် သောအမှု ကို အလိုလို စီရင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ထိုနောက် မောရှေ သည် ယောက္ခမ သွားရသောအခွင့် ကိုပေး ၍ ၊ သူသည် မိမိ နေရာ သို့ သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ဣသရေလ အမျိုးသား တို့သည် အဲဂုတ္တု ပြည် မှ ထွက်သွား သောနောက်၊ တတိယ လ တရက်နေ့ ၌ သိနာ တော သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ရေဖိဒိမ် အရပ်က ထွက်သွား ပြီးမှ သိနာ တော သို့ ရောက် ၍ ၊ ထိုတော ၌ တောင် ရှေ့ မှာ တပ်ချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","မောရှေ သည် ဘုရား သခင့်ထံ တော်သို့ တက် သွားလျှင် ၊ ထာဝရဘုရား သည် တောင် ပေါ်က ခေါ် တော်မူ၍၊ သင်သည် ယာကုပ် အမျိုး ၊ ဣသရေလ သား တို့အား ပြန်ပြော ရသော အမိန့် တော်ဟူမူကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ငါသည် အဲဂုတ္တု လူတို့၌ ပြု သော အကြောင်း၊ သင် တို့ကို ရွှေလင်းတ အတောင် ဖြင့် ထမ်း ၍ ကိုယ် ဘို့ သိမ်းယူ သောအကြောင်းကို သင် တို့သည် သိ မြင်ရကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ထိုကြောင့် ယခု တွင် သင်တို့သည် ငါ့ စကား ကို အမှန်နားထောင် ၍ ငါ့ ပဋိညာဉ် ကို စောင့်ရှောက် လျှင် အခြားသောလူမျိုး တကာ တို့ထက် သင်တို့သည် ငါ ပိုင်ထိုက်သော ဘဏ္ဍာ တော်ဖြစ် ရကြလိမ့်မည်။ မြေကြီး ရှိသမျှ သည် ငါ ၏ ဥစ္စာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","သင် တို့သည်လည်း မင်း စည်းစိမ်ရှိသောယဇ်ပုရောဟိတ် မျိုး၊ သန့်ရှင်း သောလူမျိုး ဖြစ် ရကြလိမ့်မည် ဟူသောအမိန့် တော်ကို ဣသရေလ အမျိုးသားတို့အား ဆင့်ဆို လော့ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","မောရှေ သည် ပြန်လာ ၍ လူ တို့တွင် အသက်ကြီး သူတို့ကို ခေါ် ပြီးလျှင် ၊ ထာဝရဘုရား မှာ ထားတော်မူသော စကား အလုံးစုံ တို့ကို ပြန်ပြောလေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","လူ အပေါင်း တို့ကလည်း ထာဝရဘုရား မိန့် တော်မူသမျှ တို့ကို အကျွန်ုပ်တို့သည် ပြု ပါမည်ဟု တညီ တညွတ်တည်း ပြန် ပြောကြ၏။ မောရှေ သည်လည်း သူ တို့၏စကား ကို ထာဝရဘုရား အား ပြန်လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ထာဝရဘုရား ကလည်း ကြည့်ရှု လော့။ သင် နှင့် ငါ ပြော သောအခါ လူ များတို့သည် ကြား ၍ အစဉ်အမြဲ သင့် ကို ယုံ မည်အကြောင်း ၊ မိုဃ်းတိမ် တိုက် ၌ သင့် ဆီ သို့ ငါ လာ မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ မောရှေ သည်လည်း ထာဝရဘုရား ၏ စကား တော်ကို လူ များတို့အား ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ထာဝရဘုရား ကလည်း လူ တို့ရှိရာသို့ သွား ၍ ၊ ယနေ့ နှင့် နက်ဖြန် ၌ သူ တို့ကို သန့်ရှင်း စေလော့။ သူ တို့အဝတ် ကို လျှော် စေ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","သုံး ရက်မြောက်သောနေ့ ၌ အသင့် ရှိ နေစေလော့။ အကြောင်း မူကား၊ သုံး ရက်မြောက်သောနေ့ ၌ ထာဝရဘုရား သည် လူ အပေါင်း တို့ရှေ့ ၊ သိနာ တောင် ပေါ် သို့ ဆင်းသက် တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","လူတို့မကျော်ရသောအဆီးအကာတို့ကို တောင်ပတ်လည် ၌ စီရင် ၍၊ သင်တို့သည် တောင် ပေါ်သို့ မတက် ၊ တောင် ခြေရင်း ကို မထိ ရအောင် သတိပြု ကြဟု ပြော လော့။ တောင် ကို ထိမိ သောသူ မည်သည်ကား၊ ဧကန်အမှန် အသေ ခံစေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ထိုသူ ကို လက် နှင့်မ ထိ ရ။ အကယ်စင်စစ်ကျောက်ခဲနှင့်ပစ် ရမည်။ သို့မဟုတ် လှံနှင့်ထိုး ရမည်။ လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ ၊ အသက် မ ရှင်ရ။ တံပိုး သည် ကြာကြာမြည် သောအခါ ၊ လူ များတို့သည် တောင် သို့ လာ ရ ကြမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","မောရှေ သည် တောင် ပေါ်မှ လူ တို့ရှိရာသို့ ဆင်းသက် ၍ ၊ သူ တို့ကို သန့်ရှင်း စေ၏။ သူတို့သည် မိမိ အဝတ် များကို လျှော် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","မောရှေကလည်း၊ သုံး ရက်မြောက်သောနေ့ ၌ အသင့် ရှိ စေကြလော့။ မယား ကို မ ချဉ်း ကြနှင့်ဟု လူ တို့အား ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","သုံး ရက်မြောက်သောနေ့ ၊ နံနက် အချိန်၌ တောင် ပေါ် မှာ မိုဃ်းချုန်း ခြင်း၊ လျပ်ပြက် ခြင်းနှင့်တကွ မိုဃ်းတိမ် တိုက် လွှမ်းမိုး ၍ ကြီး သောအသံနှင့် တံပိုး မြည် သဖြင့် ၊ တပ် ၌ ရှိသော လူ အပေါင်း တို့သည် တုန်လှုပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","မောရှေ သည်လည်း ဘုရား သခင်နှင့် တွေ့ စေခြင်းငှာ ၊ လူ များတို့ကို တပ် ထဲက ဆောင် ခဲ့သဖြင့် ၊ သူတို့သည် တောင် ခြေ ရင်းအောက်၌ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ထာဝရဘုရား သည် မီး ဖြင့် လွှမ်းလျက်၊ သိနာ တောင်ပေါ် သို့ ဆင်းသက် တော်မူသောကြောင့် ၊ တတောင်လုံး မီးခိုး ထွက်လေ၏။ မီးခိုး သည်လည်း မီးဖို ၏မီးခိုး ကဲ့သို့ တက် ၍ တတောင် လုံး ပြင်းစွာ လှုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","တံပိုး မြည် သံသည် ကြာကြာမြည် လျက် ၊ အသံတိုး ၍ ကြီး သောအခါ၊ မောရှေ သည် ခေါ် ၍ ၊ ဘုရား သခင်သည် စကား သံနှင့် ထူး တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ထာဝရဘုရား သည်လည်း သိနာ တောင် ထိပ် ပေါ် သို့ ဆင်းသက် ၍ ၊ မောရှေ ကို တောင် ထိပ် ပေါ် သို့ ခေါ် တော်မူလျှင် ၊ မောရှေ သည် တက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ထာဝရဘုရား ကလည်း ၊ လူ တို့သည် ကြည့်ရှု ခြင်းငှာ ထာဝရဘုရား ထံ သို့ကျော် ဝင်၍ ၊ အများ တို့သည် သေ ကြလိမ့်မည်ဟု စိုးရိမ်စရာရှိသောကြောင့်ဆင်း ၍ သတိပေး လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ထာဝရဘုရား ထံသို့ ချဉ်းကပ် သော ယဇ် ပုရောဟိတ်တို့သည်လည်း ၊ ကိုယ်ကိုကိုယ်သန့်ရှင်း စေရမည်။ သို့မဟုတ် ထာဝရဘုရား သည် ဒဏ်ခတ် တော်မူမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","မောရှေ ကလည်း ၊ လူ တို့သည် သိနာ တောင် သို့ မ တက် နိုင် ကြပါ။ အကြောင်း မူကား၊ မကျော်ရသောအဆီး အကာတို့ကို တောင် ပတ်လည်၌ စီရင်၍ ၊ သန့်ရှင်း စေလော့ဟု မှာ ထားတော်မူပြီဟု ထာဝရဘုရား အား ပြန်လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ထာဝရဘုရား ကလည်း ၊ ဆင်း သွားလော့။ သင် နှင့် အာရုန် သာလျှင် တက် ရမည်။ ယဇ် ပုရောဟိတ်များ၊ လူ များတို့သည် ထာဝရဘုရား ထံ သို့တက် ခြင်းငှာ မ ကျော် မဝင်စေနှင့်။ သို့မဟုတ်သူ တို့ကို ဒဏ်ခတ် တော်မူမည် ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","မောရှေ သည်လည်း လူ များတို့ရှိရာသို့ ဆင်း ၍ ကြားပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ထိုအခါ ဘုရား သခင်မိန့်တော်မူသောစကား များဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","ငါ သည် သင့် ကို ကျွန် ခံနေရာ အဲဂုတ္တု ပြည် မှ ကယ်နှုတ် ဆောင်ယူခဲ့ပြီးသော သင် ၏ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ငါ မှတပါး အခြား သောဘုရား ကို မ ကိုးကွယ် နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","အထက် မိုဃ်း ကောင်းကင်၌ ၎င်း ၊ အောက် အရပ် မြေကြီး ပေါ်၌ ၎င်း၊ မြေကြီးအောက် ရေ ထဲ ၌၎င်း ရှိသောအရာနှင့် ပုံသဏ္ဌာန် တူအောင်၊ ရုပ်တု ဆင်းတုကို ကိုယ် အဘို့ မ လုပ် နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ဦး မ ချဝတ် မ ပြုနှင့်။ အကြောင်း မူကား၊ သင် ၏ဘုရား သခင်ငါ ထာဝရဘုရား သည်၊ သင်၌အပြစ် ရှိသည် ဟု ယုံလွယ်သောဘုရား ၊ ငါ့ ကို မုန်း သောသူတို့၏ အမျိုးအစဉ်အဆက်၊ တတိယ အဆက်၊ စတုတ္ထ အဆက် တိုင်အောင်၊ အဘ တို့၏ အပြစ် ကို သား တို့၌ ဆပ်ပေး စီရင်သောဘုရား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ငါ့ ကို ချစ် ၍ ငါ့ ပညတ် တို့ကို ကျင့် သောသူတို့၏ အမျိုးအစဉ်အဆက် အထောင် အသောင်းတိုင်အောင် ၊ ကရုဏာ ကို ပြ သော ဘုရားဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","သင် ၏ဘုရား သခင်ထာဝရဘုရား ၏ နာမ တော်ကို မုသာ နှင့်ဆိုင်၍ မ မြွက် မဆိုနှင့်။ အကြောင်း မူကား၊ နာမ တော်ကို မုသာ နှင့်ဆိုင်၍ မြွက်ဆို သောသူ ကို အပြစ် မရှိဟု ထာဝရဘုရား မှတ်တော်မ မူ။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ဥပုသ် နေ့ကို သန့်ရှင်း စေခြင်းငှာ ၊ ထိုနေ့ရက် ကို အောက်မေ့ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ခြောက် ရက် ပတ်လုံးအလုပ် မျိုးကို ကြိုးစား ၍ လုပ်ဆောင် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","သတ္တမ နေ့ရက် သည် သင် ၏ဘုရား သခင်ထာဝရဘုရား ၏ ဥပုသ် နေ့ဖြစ်၏။ ထိုနေ့၌ သင် မှစ၍ သင် ၏သား သမီး ၊ ကျွန် ယောက်ျား မိန်းမ၊ တိရစ္ဆာန် ၊ သင် ၏ တံခါး အတွင်း၌ နေသော ဧည့်သည် အာဂန္တုသည် အလုပ် မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","အကြောင်း မူကား၊ ထာဝရဘုရား သည် မိုဃ်းကောင်းကင် ၊ မြေကြီး ၊ သမုဒ္ဒရာ ၊ အရပ်ရပ် ၌ ရှိသမျှ တို့ကို ခြောက် ရက် တွင် ဖန်ဆင်း ၍ သတ္တမ နေ့ရက် ၌ ငြိမ်ဝပ် စွာနေတော်မူ၏။ ထိုကြောင့် ထာဝရဘုရား သည် သတ္တမ နေ့ ရက်ကို ကောင်းကြီး ပေး၍ သန့်ရှင်း စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","သင် ၏ဘုရား သခင်ထာဝရဘုရား ပေး သနားတော်မူသော ပြည် ၌ သင် ၏အသက် တာရှည် မည် အကြောင်း ၊ သင် ၏မိဘ ကို ရိုသေ စွာပြုလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","လူအသက် ကို မ သတ်နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","သူ့မယားကို မ ပြစ်မှား နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","သူ့ဥစ္စာကို မ ခိုး နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ကိုယ် နှင့်စပ်ဆိုင်သောသူတဘက် ၌ မမှန် သောသက်သေ ကို မ ခံ နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ကိုယ် နှင့်စပ်ဆိုင်သောသူ၏ အိမ် ကို တပ်မက် လိုချင်သောစိတ်မရှိ စေနှင့်။ ကိုယ် နှင့်စပ်ဆိုင်သောသူ၏ မယား ၊ သူ ၏ကျွန် ယောက်ျား မိန်းမ ၊ နွား ၊ မြည်း မှစ၍ ကိုယ် နှင့်စပ်ဆိုင်သောသူ၏ ဥစ္စာ တစုံတခု ကိုမျှ တပ်မက် လိုချင်သောစိတ် မရှိ စေနှင့်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","လူ အပေါင်း တို့သည် မိုဃ်းချုန်း ခြင်း၊ လျှပ်ပြက် ခြင်း၊ တံပိုး သံ မြည်ခြင်း၊ တောင် ထဲကမီးခိုး ထွက်ခြင်း အကြောင်းအရာတို့ကို မြင် သောအခါ ၊ ကြောက် သောကြောင့် ရွှေ့၍ အဝေး ၌ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","မောရှေ ကို လည်း ၊ အကျွန်ုပ် တို့အား ကိုယ်တော် မိန့် တော်မူပါ၊ အကျွန်ုပ်တို့သည် နားထောင် ပါမည်။ အကျွန်ုပ် တို့အား ဘုရား သခင်မိန့် တော်မ မူပါစေနှင့်။ အကျွန်ုပ်တို့သည် သေ မည်ကို စိုးရိမ်ပါသည်ဟု လျှောက် ဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","မောရှေ ကလည်း ၊ မ စိုးရိမ် ကြနှင့်။ သင် တို့ကို စုံစမ်း ခြင်းငှာ ၎င်း၊ သင်တို့သည် ပြစ်မှား ခြင်းနှင့် လွတ် မည်အကြောင်း ကိုယ်တော် ကို ကြောက် စေ ခြင်းငှာ ၎င်း၊ ဘုရား သခင်ကြွ လာတော်မူပြီဟု လူ များတို့အား ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","လူ များတို့သည်လည်း အဝေး ၌ ရပ် နေကြ၏။ မောရှေ မူကား ၊ ဘုရား သခင်ရှိတော်မူရာ ထူထပ် သော မှောင်မိုက်သို့ ချဉ်းကပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ထာဝရဘုရား ကလည်း ၊ ဣသရေလ အမျိုးသား တို့အား ပြန်ပြော ရသော စကားဟူမူကား၊ ငါသည် ကောင်းကင် ဘုံမှ သင် တို့နှင့် နှုတ်ဆက် ကြောင်းကို သင် တို့သည် သိ မြင်ကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ငါ့ ကို ကိုးကွယ်သောအမှု၌ ကိုယ်သုံးဘို့ ငွေ ဘုရား ၊ ရွှေ ဘုရား ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ငါ့ အဘို့ မြေ ယဇ် ပလ္လင်ကို တည် ရမည်။ ထိုပလ္လင် ပေါ် မှာ သင် ၏မီးရှို့ သောယဇ်၊ မိဿဟာယ ယဇ် တည်းဟူသောသင် ၏သိုး နွား တို့ကို ယဇ် ပူဇော်ရမည်။ ငါ့အခွင့်ရှိ၍၊ ငါ့ နာမ ကို ကိုးကွယ် ရာ အရပ် ခပ်သိမ်း တို့၌ ၊ သင့် ဆီ သို့ ငါကြွ လာ၍ ကောင်းကြီး ပေးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","သင်သည် ကျောက် ယဇ် ပလ္လင်ကို ငါ့ အဘို့ တည် လျှင် ၊ ဆစ် သောကျောက်ကို မ တည် ရ။ သံတန်ဆာ ပါ၍ တည်သောယဇ်ပလ္လင်သည် ညစ်ညူး ခြင်းရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","သင် ၌ ရှက်စရာ အကြောင်းမ ထင် မပေါ်စေခြင်းငှာ ၊ ယဇ်ပလ္လင် ပေါ် သို့ လှေကား ဖြင့် မ တက် ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ထာဝရဘုရားကလည်း၊ သင်သည် ဣသရေလ အမျိုးသားတို့၌ စီရင် ရသော ဓမ္မသတ် ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ဟေဗြဲ အမျိုးဖြစ်သောကျွန် ကို ဝယ် လျှင် ၊ ခြောက် နှစ် သာ အစေ ကျွန်ခံစေရမည်။ သတ္တမ နှစ်ရောက် သော်၊ ကိုယ်ဘိုးကို မ တောင်းဘဲ လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ကျွန်ခံစက တယောက် တည်းခံလျှင် ၊ တယောက် တည်းထွက် ရမည်။ လင် မယား နှစ်ယောက်ခံလျှင် ၊ မယား နှင့်တကွ ထွက် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","သို့မဟုတ်သခင် ပေးစား သောမယား ရှိ၍ ထိုမယားသည် သား သမီး ကို ဘွားမြင် လျှင် ၊ မယား နှင့် သားသမီး တို့ကို သခင် ပိုင် ရမည်။ ကျွန်မူကား၊ တ ယောက်တည်းထွက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","သို့မဟုတ် ကျွန် က၊ ကျွန်တော် သခင် နှင့် မယား သားသမီး တို့ကို ကျွန်တော်ချစ် ပါ၏။ မ ထွက် မသွားလိုပါ ဟု အတည့်အလင်းပြောဆို လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","သခင် သည် ဘုရား သခင်ရှေ့ တော်သို့၎င်း၊ အိမ်တံခါး တိုင် သို့ ၎င်း ဆောင် ယူ၍ ၊ နားရွက် ကို စူး ဖြင့် ဖောက် ပြီးမှ ၊ ထိုကျွန်သည် အစဉ် အမြဲကျွန် ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","အဘ သည် သမီး ကို ကျွန် ခံစေခြင်းငှာ ရောင်း လျှင် ထိုမိန်းမသည် ကျွန် ယောက်ျားကဲ့သို့ လွတ် ရသည် မဟုတ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","သခင် သည် ထိုမိန်းမ ကို သိမ်းယူ၍ မကြိုက် လျှင် ၊ ရွေး စေခြင်းငှာ အခွင့်ပေးရမည်။ သူ့ ကို လှည့်ဖြား မိ သောကြောင့် ၊ တပါးအမျိုးသား တို့သို့ ရောင်း ချပိုင်သောအခွင့် မရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","မိမိ သား ၌ ပေးစား လျှင် မူကား ၊ သမီး ကဲ့သို့ ပြုစု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","အခြား မိန်းမကို သိမ်း ပြန်လျှင် ၊ အရင်သိမ်းသော မိန်းမ ၏ အဝတ် အစား နှင့် မယား ဝတ်ကို မ လျှော့ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ထို သုံး ပါးကို မ ပြု လျှင် ၊ ကိုယ်ဘိုး ကို မ တောင်းဘဲ လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","လူ ကို အသေ သတ် သောသူသည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","အသေသတ်မည် အကြံ မ ရှိဘဲ၊ သူ ၏လက် ၌ လူအသက်ကို ဘုရား သခင်အပ် တော်မူလျှင်၊ ပြေး ရသောအရပ် ကို ငါခန့် ထားမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","အိမ်နီးချင်း ကိုသတ် မည် အကြံ ရှိ၍ အနိုင်တိုက်သောသူ ကိုကား ၊ ငါ့ ယဇ် ပလ္လင်၌ ခိုလှုံသော်လည်း၊ ဆွဲယူ ၍ သတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","မိ ဘ ကို အသေသတ် သောသူသည်၊ အသေသတ် ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","လူကို ခိုး သောသူသည်၊ ရောင်း သည်ဖြစ်စေ ၊ သူ ၏လက် ၌ ရှိသည်ဖြစ်စေ၊ အသေသတ် ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","မိ ဘ ကို ကျိန်ဆဲ သောသူသည် အသေသတ် ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","လူ ချင်းခိုက်ရန် ပြု၍ တယောက် သည် ကျောက်ခဲ နှင့် ထု သည်ဖြစ်စေ၊ လက်သီး နှင့် ထိုးသည်ဖြစ်စေ၊ အရိုက်ခံရသောသူသည် မ သေ သော်လည်း ၊ အိပ်ရာ ၌ တုံးလုံးနေ ရလျှင်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","တဖန်ထ ၍ တောင်ဝေး နှင့် သွား လျှင် ၎င်း၊ ရိုက်သောသူကို အပြစ် လွှတ် ရမည်။ သို့ရာတွင် နာသောသူသည် အလုပ်ပျက်ရသည်အတွက်၊ အနာ ပျောက်စေခြင်းငှါ ကုသ ရသည်အတွက်၊ ငွေကို လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","သခင်သည် ကျွန် ယောက်ျားကျွန် မိန်းမကို ဒုတ် နှင့် ရိုက် ၍ ထိုကျွန်သေ လျှင် ၊ သခင်သည် လေးသော ဒဏ် ကိုခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","သို့ရာတွင် ကျွန်သည် တရက် နှစ်ရက် နာ၍ မသေဘဲနေ လျှင် ၊ သခင်သည် ထိုကျွန်ကို ပိုင် သောကြောင့် ဒဏ် နှင့် လွတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","လူ ချင်းခိုက်ရန် ပြုကြ၍ ၊ ကိုယ်ဝန် ဆောင်သော မိန်းမ ကို ထိခိုက် သဖြင့် ကိုယ်ဝန် ပျက်၍ အခြားသော အနာ မ ဖြစ် လျှင် ၊ မိန်းမ လင် စီရင် သည်အတိုင်း ဒဏ် ခံရမည်။ မင်း စီရင်သည်အတိုင်းလည်း ငွေကို လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","အခြားသော အနာ ဖြစ်လျှင် ၊ အသက် အတွက် အသက် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","မျက်စိ အတွက် မျက်စိ ကို၎င်း၊ သွား အတွက် သွား ကို၎င်း၊ လက် အတွက် လက် ကို၎င်း၊ ခြေ အတွက် ခြေ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","မီး လောင်ခြင်းအတွက် မီး လောင်ခြင်းကို၎င်း၊ ရှန ခြင်းအတွက် ရှန ခြင်းကို၎င်း၊ ဒဏ်ချက် ရာအတွက် ဒဏ်ချက် ရာကို၎င်း ခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","သခင် သည် ကျွန် ယောက်ျား ကျွန် မိန်းမ၏ မျက်စိ ကို ပျက် အောင်ရိုက် လျှင် ၊ မျက်စိ ပျက်သည်အတွက် လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ထိုအတူ ကျွန် ယောက်ျား ကျွန် မိန်းမ၏ သွား ကို ကျိုး အောင်ရိုက်လျှင်၊ သွား ကျိုးသည်အတွက် လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","နွား သည် လူယောက်ျား မိန်းမ ကို ခွေ့ ၍ လူသေ လျှင် ၊ စင်စစ်ထိုနွား ကို ကျောက်ခဲနှင့် ပစ် ၍ သတ်ရမည်။ အသား ကိုလည်း မ စား ရ။ နွား ရှင် ကိုကား ၊ အပြစ်လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","၎င်းနည်း နွား သည် အထက် က ခွေ့ ဘူး၍ ၊ ခွေ့ကြောင်းကို နွားရှင် ကြား သိလျက် မ ချည် မနှောင် အလွတ်ထား၍၊ နွားသည် ယောက်ျား မိန်းမ ကို သတ် မိလျှင် ၊ ထိုနွား ကို ကျောက်ခဲနှင့် ပစ် သတ်ရမည်။ နွား ရှင် ကိုလည်း အသေ သတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","သို့မဟုတ်ငွေ လျော်စေဟု စီရင် လျှင် ၊ စီရင် သည်အတိုင်း မိမိ အသက် ရွေး ရန် အဘိုးကို လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","သူတပါး၏ သား သမီး ကို ခွေ့ လျှင် ၊ စီရင် သည်အတိုင်း ခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ကျွန် ယောက်ျားကျွန် မိန်းမကို ခွေ့ လျှင် မူကား၊ နွားရှင်သည် ကျွန် ရှင် အား ငွေ အကျပ် သုံးဆယ် ကို လျော် ရမည်။ နွား ကိုလည်း ကျောက်ခဲနှင့် ပစ် သတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","လူ သည် တွင်း ကို ဖွင့် ၍ ထားသည်ဖြစ်စေ ၊ တွင်း ကိုတူး ၍ မ ပိတ် ဘဲ ထားသည်ဖြစ်စေ၊ သူတပါး၏ မြင်း ၊ နွား သည် ထို တွင်း၌ ကျ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","တွင်း ရှင် သည် မြင်း၊ နွားအဘိုး ကို လျော် ၍ အသေ ကောင်ကို ယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","အကြင် သူ၏ နွား သည်၊ သူတပါး ၏ နွား ကို အသေ ခွေ့လျှင်၊ နွားရှင်နှစ်ဦးတို့သည်၊ အသက်ရှင် သော နွား ကို ရောင်း ၍ အဘိုး ကို ဝေ ယူရမည်။ သေ သောနွားကိုလည်း ဝေ ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","၎င်း နည်းနွားသည် အထက် က ခွေ့ ဘူးကြောင်းကို ၊ နွား ရှင် သိ လျက်နှင့် မ ချည် မနှောင် အလွတ် ထားလျှင်၊ နွားသေ ကောင်ကို ကိုယ်တိုင် ယူ ရမည်။ ထိုနွား တကောင်အတွက် တ ကောင်ကို အမှန်လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","လူ သည် သိုး နွား ကိုခိုး ၍ သတ် သည်ဖြစ်စေ ၊ ရောင်း သည်ဖြစ်စေ၊ နွား တကောင်အတွက် နွား ငါး ကောင် ကို၎င်း၊ သိုး တကောင်အတွက် သိုး လေး ကောင်ကို၎င်းပြန်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","သူခိုး သည် အိမ်ကိုထွင်း ဖောက်စဉ်၊ သူတပါးတွေ့ ၍ သေ အောင် သတ် သော်လည်း၊ သေစား မ သေ စေရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","သို့သော်လည်းနေ ထွက် လျှင် သေ စားသေစေရမည်။ အကြောင်းမူကား၊ ပြန်ပေးစရာအကြောင်းရှိ၏။ ဥစ္စာအလျှင်းမရှိလျှင်၊ ခိုးသည်ဥစ္စာအတွက် ကိုယ်ကိုရောင်းရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","သူခိုးလက်၌ ခိုး သောနွား ၊ သိုး ကို အသက်ရှင် လျှက် အမှန်တွေ့ လျှင်၊ နှစ်ဆ ပြန်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","သူ့လယ် ၊ သူ့စပျစ် ဥယျာဉ်ကို စား စေသော်၎င်း၊ မိမိ တိရိစ္ဆာန် ကို သူ့ လယ် ၌ ထိန်း ကျောင်းသော်၎င်း ၊ မိမိ လယ် ၊ မိမိ စပျစ် ဥယျာဉ်ထဲကအကောင်း ဆုံးကို ထုတ်၍ ပြန်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","မီးရှို့ သောအခါမြက်ပင် ကြောင့် အစဉ်အတိုင်းရှောက် ၍ လောင်လျက်၊ ကောက် လှိုင်း၊ စပါး ပင်၊ လယ် ၌ရှိသောအရာတို့ကို လောင် လျှင် ၊ မီးရှို့ သောသူသည် အမှန်လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","လူ တဦးသည် အိမ်နီးချင်း တဦး၌ ရွှေငွေ အစရှိသော ဥစ္စာ တစုံတခုကို အပ်နှံ ၍ ၊ အပ်နှံခံသောသူ ၏အိမ် မှ သူခိုးခိုး သွားလျှင် ၊ သူခိုး ကို တွေ့ မိသောအခါ နှစ်ဆ လျော် စေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","သူခိုး ကို မ တွေ့ လျှင် ၊ အိမ် ရှင် သည် မိမိ အိမ်နီးချင်း ဥစ္စာ ကို ယူ သလောမ ယူလောဟု ဘုရား သခင့်ရှေ့တော်၌ အစစ် ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","သူ့ဥစ္စာကို ပြစ်မှားသည် အမှု မှာ ၊ နွား ၊ မြည်း ၊ သိုး ၊ အဝတ် အစ ရှိသောပျောက်သော ဥစ္စာ တစုံတခု ကို တွေ့၍၊ ဤ ဥစ္စာကား၊ ငါ၏ဥစ္ဇာဖြစ်သည်ဟု တစုံတယောက်ဆို လျှင်၊ အမှု သည် နှစ်ဦး တို့သည် ဘုရား သခင်ရှေ့ တော်၌အစစ်ခံရ၍၊ တရား ရှုံးသော သူသည် နှစ်ဆ လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","လူ သည် အိမ်နီးချင်းလယ်၌ မြည်း ၊ နွား ၊ သိုး အစရှိသော တိရစ္ဆာန် တစုံတခု ကို အပ်နှံ ၍ ၊ ထိုတိရစ္ဆာန် သေ သော်၎င်း ၊ ထိခိုက် ၍နာသော်၎င်း ၊ သက်သေ မရှိ ဘဲ သူတပါးမောင်း ၍သွားသော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","အပ်နှံခံသောသူသည် ငါ့အိမ်နီးချင်း ၏ဥစ္စာ ကို ငါမ ယူ ဟု နှစ်ဦး သဘောတူလျက်၊ ထာဝရဘုရား ရှေ့မှာ အကျိန် ခံရလျှင်၊ ဥစ္စာ ရှင် သည် ဝန်ခံ ရမည်။ အပ်နှံခံသူလည်း မ လျော် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","သို့ရာတွင် သူတပါးခိုး သွားလျှင် ၊ အပ်နှံခံသူသည် ဥစ္စာ ရှင် အား ပြန်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","သားရဲကိုက် လျှင် သက်သေ ဘို့ အသေ ကောင်ကိုပြ စေ။ ပြနိုင်လျှင် အလျော် မ ခံရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","လူ သည် အိမ်နီးချင်း ၌ တစုံတခုကို ငှါး ၍ ဥစ္စာရှင် မ ပါ ဘဲ သေ သော်၎င်း၊ ထိခိုက် ၍ နာသော်၎င်း၊ အမှန်လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ဥစ္စာရှင် ပါ လျှင် ၊ ငှါးသောသူသည် မ လျော် ရ။ အခ နှင့် ငှါးလျှင် မူကား၊ ဥစ္စာရှင်သည် အခ ကိုသာ တောင်းရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","မ ပေးစား လိုသော အပျို ကို၊ အကြင်ယောက်ျား သည် ချော့မော့ ၍ သင့်နေလျှင် ၊ ကန်တော့ ဥစ္စာကို ပေး ၍ ထိုမိန်းမကို မယား အရာ၌ မြှောက်ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","မိန်းမ ၏အဘ သဘော မတူမပေးစား လိုလျှင် ၊ ကန်တော့ ရသည်နှင့်အမျှ ငွေ ကို လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","စုန်းမ ကို အသက် ရှင်စေခြင်းငှါ အခွင့်မ ပေးရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","တိရစ္ဆာန် နှင့် သင့် နေသောသူသည် အသေ သတ် ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ထာဝရဘုရား မှတပါး အခြားသော ဘုရား ရှေ့ မှာ ယဇ် ပူဇော်သောသူကို ရှင်းရှင်းဖျက်ဆီး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","တပြည်တနိုင်ငံသားဖြစ်သော ဧည့်သည် ကို မ နှောင့်ရှက် မ ညှဉ်းဆဲ ရ။ သင်တို့သည် အဲဂုတ္တု ပြည် ၌ ဧည့်သည် ဖြစ် ကြဘူးပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","မိဘ မရှိသောသူငယ်နှင့် မုတ်ဆိုးမ ကို သင်တို့သည် မ နှောင့်ရှက် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","နှောင့်ရှက် ခြင်းတစုံတခုကို ပြု၍ သူတို့သည် ငါ့ အား အနည်းငယ်အော်ဟစ် လျှင် ၊ ငါသည် ထိုအသံ ကို အမှန်ကြား ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ငါ အမျက် ပြင်းစွာထွက် လျှက် သင် တို့ကို ထား ဘေးဖြင့် ကွပ်မျက် မည်။ သင် တို့မယား များသည်လည်း မုတ်ဆိုးမ ဖြစ်၍ ၊ သားသမီး များသည်လည်း မိဘ မရှိသော သူငယ်ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ငါ့ လူ ဖြစ်သော ဆင်းရဲသား အိမ်နီးချင်းအား သင်သည် ငွေ ကို ချေး လျှင် ၊ အတိုး စားသော သူကဲ့သို့ သူ ၌ မ ပြု ၊ အတိုး ကို မ တောင်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","အိမ်နီးချင်း သည် မိမိစောင် ကို သင် ၌ ပေါင် ထားလျှင် ၊ မိုဃ်းမချုပ်မှီ ပြန် ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","အကြောင်း မူကား၊ အခြားသောခြုံ စရာမရှိ။ ကိုယ် ခြုံ ဘို့ ဖြစ်၏။ သူသည် အဘယ်သို့ အိပ် နိုင်သနည်း။ ငါ့ အား အော်ဟစ် လျှင် ငါကြား မည်။ ငါ သည် သနား သော သဘောရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ဘုရား သခင်ကို လွန်ကျူး ၍ မ ပြောရ။ သင် ၏အမျိုး ကို အုပ်စိုး သော မင်း ကို မ ကျိန်ဆဲ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","အဦးမှည့် သောအသီး၊ အဦးညှစ် သောအရည်ကို မ ထိမ် မဝှက်ဘဲ ဆက်ကပ်ရမည်။ အဦး ဘွားသော သား ယောက်ျားကိုလည်း ငါ့ အား ဆက်ကပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ထိုနည်းတူ သိုး နွား တို့ကို ပြု ရမည်။ ခုနစ် ရက် ပတ်လုံးသိုးနွားသငယ်ကို အမိ နှင့် အတူ နေ စေ၍၊ အဋ္ဌမ နေ့ ရောက်မှ ငါ့ အား ဆက်ကပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","သင်တို့သည် ငါ့ ထံ ၌ သန့်ရှင်း သောသူ ဖြစ် ရကြမည်။ တော ၌ သားရဲ ကိုက်သော အမဲသား ကို မ စား ရ။ ခွေး တို့အား ပစ် ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","သင်သည် မှား သော သိတင်း စကားကို မ ကြား မပြောရ။ မတရား သောသူတို့နှင့် ဝိုင်းညီ၍ မ မှန်သော သက်သေ ကို မ ခံ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","လူများ နောက် သို့ လိုက် ၍ မတရား သဖြင့် မ ပြုရ။ တရား တွေ့သည်အမှုမှာ ကြီး သောသူဘက် ၌ နေ၍၊ တရားလမ်းမှ လွဲ စေခြင်းငှါ မ ပြော ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ဆင်းရဲ သောသူဘက်၌လည်း မ ငဲ့ကွက် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","သင် သည် ရန်သူ ၏မြင်း နွား လမ်း လွဲသည်ကို တွေ့မြင် လျှင် ၊ အမှန်ပြန်ပို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","သင့် ကို မုန်း သောသူ ၏မြည်း သည်၊ မိမိ ဆောင်ရွက်သော ဝန် အောက် မှာ လဲ နေသည်ကို တွေ့မြင် လျှင် ၊ မ မစဘဲ နေနိုင်သလော။ အမှန်ဝိုင်းညီ၍ မစ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","သင် ၌ ဆင်းရဲ သောသူသည် တရား တွေ့သောအခါ ၊ သူ့ကို မတရား သဖြင့် မ စီရင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","မ ဟုတ်မမှန်သော အမှု ကို ရှောင် ရမည်။ အပြစ် မရှိသောသူ၊ ဖြောင့်မတ် သောသူကို မ ကွပ်မျက် ရ။ အကြောင်း မူကား၊ ငါသည် မတရား သောသူကို အပြစ်မ လွှတ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","သင်သည် တံစိုး မ စား ရ။ တံစိုး သည် ပညာရှိ တို့၏မျက်စိကို ကွယ် စေ၍ ၊ ဖြောင့်မတ် သောသူတို့၏ စကား ကို လွဲ စေတတ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","တကျွန်းတနိုင်ငံသားဖြစ်သော ဧည့်သည် ကို မ ညှဉ်းဆဲ ရ။ သင်တို့သည် အဲဂုတ္တု ပြည် ၌ ဧည့်သည် ဖြစ် ခဲ့ ဘူးသောကြောင့် ၊ ဧည့်သည် ၏စိတ် သဘောကို သိ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ခြောက် နှစ် ပတ်လုံးလယ် လုပ် ၍ အသီး ကို သိမ်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","သတ္တမ နှစ်တွင် လယ် ကို မလုပ် ဘဲ အလွတ် ထားရမည်။ သို့ပြုလျှင် ဆင်းရဲ သောအမျိုးသား ချင်းတို့သည်၊ စား ရသောအခွင့် ရှိလိမ့်မည်။ ကြွင်း သောအရာကိုလည်း ၊ မြေ တိရစ္ဆာန် တို့သည် စား ရကြလိမ့်မည်။ ထိုနည်းတူ ၊ စပျစ် ဥယျာဉ်၊ သံလွင် ဥယျာဉ်ကိုလည်း ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ခြောက် ရက် ပတ်လုံးအလုပ် လုပ် ရမည်။ သတ္တမ နေ့ ရက်၌ ငြိမ်ဝပ် စွာနေရမည်။ သို့ပြုလျှင် သင် ၏နွား မြည်း တို့သည် ငြိမ်ဝပ် စွာ နေရသောအခွင့် ရှိလိမ့်မည်။ သင် ၏ ငယ်သား များ၊ ဧည့်သည် များတို့လည်း သက်သာ ရ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ငါပညတ် သမျှ တို့၌ သတိပြု ကြလော့။ အခြား သောဘုရား ၏ နာမ ကို မ မြွက် မဆိုနှင့်။ သင် ၏နှုတ် ထဲက မြွက်သံကို သူတပါးမ ကြား စေနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","တနှစ် တွင် သုံး ကြိမ် ငါ့ အဘို့ ပွဲခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ငါမှာ ထားခဲ့ပြီးသည်အတိုင်း ၊ အဗိဗ လ ချိန်းချက် သော နေ့ရက်အချိန်၌ အဇုမ ပွဲကိုခံ ၍၊ ခုနစ် ရက် ပတ်လုံးတဆေး မဲ့သော မုန့်ကို စား ရမည်။ အကြောင်း မူကား၊ ထို လတွင် သင်သည် အဲဂုတ္တု ပြည်က ထွက် လာသတည်း။ ထိုပွဲကို ခံစဉ် ငါ့ ထံသို့ အဘယ်သူမျှလက်ချည်း မ ပေါ် မလာရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","လယ်လုပ်၍ အသီးအနှံ ကို သိမ်းစရှိသည်ကာလ၊ သိမ်း ပွဲ ကို၎င်း၊ လယ် လုပ် ၍ အသီးအနှံ ကို သိုထား သည်ကာလ၊ နှစ် လဲ သောအခါ ၊ သိုထား ပွဲ ကို၎င်း ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","သင် တို့တွင် ယောက်ျား အပေါင်း တို့သည်၊ တနှစ် လျှင် သုံး ကြိမ် ထာဝရ အရှင်ဘုရားသခင့် ရှေ့ တော်၌ မျက်နှာ ပြရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ငါ့ ယဇ်ကောင် ၏ အသွေး ကို၊ တဆေး ပါသောမုန့်နှင့် ရော၍ မ ပူဇော် ရ။ ငါ့ ယဇ်ကောင် ဆီဥ ကို နံနက် တိုင်အောင် မ ကြွင်း စေရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","သင် ၏မြေ ၌ အဦး သီးသော အသီးအနှံအကောင်း ဆုံးကို၊ သင် ၏ဘုရား သခင်ထာဝရ ဘုရား၏ အိမ် တော်ထဲသို့ ဆောင် သွင်းရမည်။ ဆိတ် သငယ်ကို အမိ နို့ ရည်နှင့် မ ချက် မပြုတ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ကြည့်ရှု လော့။ လမ်း ခရီး၌ သင့် ကို စောင့်ရှောက် ၍ ၊ ငါပြင်ဆင် နှင့်သော အရပ် သို့ ပို့ စေခြင်းငှာ ၊ ကောင်းကင်တမန် ကို သင့် ရှေ့ ၌ ငါ စေလွှတ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ထိုတမန် ကို ရိုသေ စွာပြုလော့။ စကား တော်ကို နားထောင် လော့။ အာဏာတော်ကို မ ဆန် နှင့်။ သင် တို့ပြစ်မှားသောအပြစ် ကို သူသည် မ လွှတ်။ ငါ့ နာမ သည် သူ ၌ တည်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","အကယ်စင်စစ်သင်သည် သူ့ စကား ကို နားထောင် ၍ ငါပညတ် သမျှ အတိုင်း ပြု လျှင် ၊ သင် ၏ ရန်သူ တို့ကို ငါသည် ရန်ဘက် ပြုမည်။ သင့် ကို ဆီးတား သောသူတို့ကိုလည်း ငါဆီးတား မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ငါ့ တမန် သည် သင့် ရှေ့ ၌သွား ၍ သင့် ကို အာမောရိ လူ၊ ဟိတ္တိ လူ၊ ဖေရဇိ လူ၊ ခါနနိ လူ၊ ဂိရဂါရှိလူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့ရှိရာသို့ ဆောင် သွင်း၍ ၊ သူ တို့ကို ပယ်ရှင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","သူ တို့ဘုရား များကို ဦး မ ချဝတ် မ ပြုရ။ သူ တို့ဘာသာ အတိုင်း မ ကျင့် ရ။ သူ တို့ကို အကုန်အစင်မှောက် လှဲ၍ ၊ ရုပ်တု ဆင်းတုများကိုလည်း ရှင်းရှင်းဖြိုဖျက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","သင် တို့၏ဘုရား သခင်ထာဝရဘုရား ကို ဝတ်ပြု ရမည်။ သင် ၏မုန့် ကို၎င်း ၊ ရေ ကို၎င်း၊ ကောင်းကြီး ပေး တော်မူမည်။ အနာရောဂါ ကိုလည်း သင် ၏အထဲ က နှုတ်ယူ ပယ်ရှားတော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","သင် ၏ပြည် တွင် ကိုယ်ဝန် ပျက်သော သတ္တဝါ၊ မြုံ သောသတ္တဝါနှင့် ကင်းလွတ် လိမ့်မည်။ သင် ၏အသက် တန်း ကို ငါစုံလင် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ငါ့ ကိုကြောက် တတ်သော သဘောကို သင့် ရှေ့ သို့ ငါစေလွှတ် ၍ ၊ သင်ရောက်လေရာရာအရပ်၌ ခပ်သိမ်း သောလူမျိုး ကို ငါဖျက်ဆီး မည်။ သင် ၏ရန်သူ အပေါင်း တို့ကို နောက် သို့ လှည့်စေ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ပျားတူ များကိုလည်း သင့် ရှေ့ သို့ ငါစေလွှတ် ၍ ၊ သူတို့သည် ဟိဝိ လူ၊ ခါနနိ လူ၊ ဟိတ္တိ လူတို့ကို သင့် ရှေ့ မှာ နှင်ထုတ် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ထိုလူများကို တ နှစ်ခြင်းတွင် သင့် ရှေ့ မှာ ငါမ နှင်ထုတ်။ သို့ပြုလျှင်ပြည် သည် လူဆိတ်ညံ ၍ သားရဲ သည် သင့် တဘက်၌ များပြား လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","သင်သည် တိုးပွား ၍ တပြည် လုံးကို ဝင်စား သည်တိုင်အောင် ၊ သူ တို့ကို သင့် ရှေ့ မှာ ဖြည်းဖြည်း ငါနှင်ထုတ် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","သင့် နေရာ နယ် အပိုင်းအခြားကို၊ ဧဒုံ ပင်လယ် မှ သည် ဖိလိတ္တိ ပင်လယ် တိုင်အောင် ၎င်း ၊ တော မှ သည် မြစ် တိုင်အောင် ၎င်း ငါမှတ်သား မည်။ ထိုအရပ် သား များကို သင့် လက် သို့ ငါအပ် ၍၊ သင်သည် နှင်ထုတ် ရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","သူ တို့နှင့် ၎င်း၊ သူ တို့ဘုရား များနှင့်၎င်း၊ သင် သည် မိဿဟာယ မ ဖွဲ့ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","သင် သည် ငါ့ ကို ပြစ်မှား စေခြင်းငှာ၊ သူတို့သည် ပြုမည်ကို စိုးရိမ်စရာရှိသောကြောင့်၊ သူတို့သည် သင့် ပြည် ၌ မ နေ ရကြ။ သင်သည် သူ တို့ဘုရား ကို ဝတ်ပြု လျှင် ၊ ထိမိ ၍ လဲစရာအကြောင်းအမှန် ဖြစ် လိမ့်မည်ဟု မောရှေအား မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","တဖန် ထာဝရဘုရားက၊ သင်သည် အာရုန် ၊ နာဒပ် ၊ အဘိဟု အစရှိသော ဣသရေလ အမျိုး အသက်ကြီး သူ ခုနစ်ကျိပ် နှင့်တကွ၊ ထာဝရဘုရား ထံ တော်သို့ တက် ၍ ၊ သူတို့သည် ဝေးဝေး ကိုးကွယ် ကြစေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","သင်တ ယောက်တည်းသာ ထာဝရဘုရား ထံ တော်သို့ ချဉ်းကပ် ရမည်။ အခြားသောသူ မချဉ်း မ ကပ်ရ။ လူ များတို့သည် သင် နှင့်အတူ မ တက် ရကြဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","မောရှေ သည်လည်း လူ များတို့ရှိရာသို့ လာ ၍ ၊ ထာဝရဘုရား ၏ စကား တော်အလုံးစုံ ကို၎င်း၊ စီရင် တော်မူချက်အလုံးစုံ ကို၎င်း ပြန်ကြား ၍၊ လူ များအပေါင်း ကလည်း ၊ ထာဝရဘုရား မိန့် တော်မူသမျှ အတိုင်း အကျွန်ုပ်တို့ ပြု ပါမည်ဟု တ သံ တည်းပြန် ပြောကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","မောရှေ သည်ထာဝရဘုရား ၏ စကား တော်အလုံးစုံ တို့ကို ရေးထား ပြီးမှ ၊ နံနက် စောစောထ ၍ ၊ တောင် ခြေရင်း ၌ ယဇ် ပလ္လင်ကို၎င်း၊ ဣသရေလ အမျိုး တဆယ် နှစ် မျိုးနှင့်အမျှ ကျောက် တိုင်တဆယ် နှစ် တိုင်ကို၎င်း တည် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ဣသရေလ အမျိုးသား လူပျို တို့ကို စေခိုင်း သည်အတိုင်း ၊ သူတို့သည် နွားများကိုယူ၍ ထာဝရဘုရား ရှေ့ မှာ မီးရှို့ သောယဇ်၊ မိဿဟာယ ယဇ် ကို ပူဇော် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","မောရှေ သည်လည်း ၊ အသွေး တဝက် ကို အင်တုံ ၌ ထည့် ၍ ၊ တဝက် ကို ယဇ်ပလ္လင် ပေါ် မှာ ဖြန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ပဋိညာဉ် စာ ကိုလည်း ယူ ၍ ၊ ပရိသတ် များရှေ့ မှာ ဘတ် ပြီးလျှင် ၊ သူတို့ကလည်း၊ ထာဝရဘုရား မိန့် တော်မူသမျှ အတိုင်း အကျွန်ုပ်တို့ပြု ပါမည်၊ နားထောင် ပါမည်ဟု ပြောဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","မောရှေ သည်လည်း ၊ အသွေး ကို ယူ ၍ လူ များအပေါ် မှာ ဖြန်း လျက် ၊ ဤအသွေးကား ဤအမှုအရာ တို့တွင် သင် တို့၌ ထာဝရဘုရား ဝန်ခံ တော်မူသော ပဋိညာဉ် ၏အသွေး ဖြစ်သည်ဟု ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ထိုအခါ မောရှေ ၊ အာရုန် ၊ နာဒပ် ၊ အဘိဟု အစရှိသော ဣသရေလ အမျိုး အသက်ကြီး သူ ခုနစ်ကျိပ် တို့ သည် တက် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ဣသရေလ အမျိုး၏ ဘုရား သခင်ကို မြင် ကြ၏။ ခြေ တော်အောက် ၌ နီလာ ကျောက် ဖြင့်ပြီးသောကျောက် ခင်းကဲ့သို့ ၎င်း၊ ကြည်လင် သော ကောင်းကင် မျက်နှာကဲ့သို့ ၎င်း ထင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ဣသရေလ အမျိုးသား မှူးမတ် တို့ကို အပြစ် ပေးတော်မ မူ။ သူတို့သည် ဘုရား သခင်ကို မြင် ရသော်လည်း ၊ စား သောက် လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ထာဝရဘုရား ကလည်း ၊ ငါ ရှိရာတောင် ပေါ် သို့ တက် ၍ နေ လော့။ လူ များတို့အား သွန်သင် ဘို့ရာ ကျောက် ပြား ပေါ်မှာ ငါရေး ထားသော ပညတ် တရား များကို သင် ၌ ငါအပ် ပေးမည်ဟု မောရှေ အား မိန့် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","မောရှေ သည် မိမိ လက်ထောက် ယောရှု နှင့်အတူ ထ ၍ ဘုရား သခင်၏ တောင် တော်ပေါ် သို့ တက် သွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","အသက်ကြီး သူတို့အား လည်း ၊ ငါတို့မ လာ မှီတိုင်အောင်ဤ အရပ်၌ ငံ့ နေကြလော့။ အာရုန် နှင့် ဟုရ သည် သင် တို့၌ ရှိသည်ဖြစ်၍၊ မည်သည့်သူမဆို အမှုအခင်း ရှိလျှင်၊ သူ တို့ထံသို့ သွား စေဟု မှာ ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","မောရှေ သည် တောင် တော်ပေါ် သို့တက် ၍ ၊ မိုဃ်းတိမ် သည် တောင် တော်ကို လွှမ်းမိုး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ထာဝရဘုရား ၏ ဘုန်း တော်သည် သိနာ တောင် ပေါ် မှာထိ ၍ ၊ မိုဃ်းတိမ် သည် ခြောက် ရက် ပတ်လုံးလွှမ်းမိုး ၏။ သတ္တမ နေ့ရက် ၌ မိုဃ်းတိမ် အထဲ က အသံတော်ထွက်၍၊ မောရှေ ကို ခေါ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ထာဝရဘုရား ၏ ဘုန်း တော်သည် တောင် ထိပ် ပေါ် မှာလောင် သော မီး ကဲ့သို့ ထင် ၍ ၊ ဣသရေလ အမျိုးသား တို့သည် မြင် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","မောရှေ သည် မိုဃ်းတိမ် အထဲသို့ ဝင် သဖြင့် တောင် ပေါ် သို့ရောက် ၍ အရက် လေးဆယ် ပတ်လုံးတောင် ပေါ် မှာ နေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ထာဝရဘုရား ကလည်း ၊ ဣသရေလအမျိုးသားတို့သည် ");
INSERT INTO myajvb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","ငါ့ အား လက်ဆောင် ပဏ္ဏာကိုဆောင် ခဲ့ရမည်အကြောင်း ဆင့်ဆို လော့။ ကြည်ညိုသောစေတနာစိတ် နှင့် ငါ့ အားလှူ သမျှ သော သူတို့၌ သင်သည် အလှူ ကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ခံ ရသော အလှူ ဟူမူကား ၊ ရွှေ ၊ ငွေ ၊ ကြေးဝါ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ၊ ဆိတ် မွေး။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","အနီ ဆိုးသောသိုး ရေ ၊ တဟာရှ သားရေ ၊ အကာရှ သစ်သား။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","လိမ်း ရန်ဆီ ဘော်ဘို့ ၊ မီးရှို့ရာ နံ့သာ ပေါင်းမွှေး ဘော်ဘို့ရာ၊ နံ့သာ မျိုး၊ မီးထွန်း စရာ ဆီ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ရှဟံ ကျောက် ၊ ယဇ်ပုရောဟိတ်သင်တိုင်း နှင့် ရင်ဖွဲ့ ၌ စီစရာ ကျောက် မြတ် တည်းဟူသောအလှူကို ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ငါသည် သင် တို့တွင် ကျိန်းဝပ် ရာဘို့ သန့်ရှင်း ရာဌာနကို လုပ် ကြစေ။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ငါ ပြ သမျှ သော တဲ တော်ပုံ ၊ တဲ တော်တန်ဆာ ပုံ နှင့် အညီ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","အလျား နှစ် တောင်ထွာ၊ အနံ တ တောင်ထွာ၊ စောက် တ တောင်ထွာရှိသော သေတ္တာ ကို၊ အကာရှ သား နှင့်လုပ် ၍ ၊ သေတ္တာအတွင်း အပြင် ကို ရွှေ စင် နှင့် မွမ်းမံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","သေတ္တာ အပေါ်နားပတ်လည် ၌ ကွပ် သော ရွှေ တန်ဆာကိုလည်း လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ရွှေ လေး ကွင်း ကို သွန်း ၍ ၊ သေတ္တာ လေး ထောင့်၌ တ မျက်နှာ နှစ် ကွင်း စီ တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","အကာရှ သား ထမ်းဘိုး ကို လုပ် ၍ ရွှေ နှင့်မွမ်းမံ ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","သေတ္တာ ထမ်း စရာဘို့ တဘက် တချက် ရွှေကွင်း ထဲသို့ လျှို ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ထိုထမ်းဘိုး ကိုလည်း သေတ္တာ ရွှေကွင်း ထဲ က မ နှုတ် အစဉ် ရှိ စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ငါပေး သော သက်သေခံချက် ကို၊ ထိုသေတ္တာ ထဲမှာ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","အလျား နှစ် တောင်ထွာ၊ အနံ တ တောင်ထွာရှိသော သေတ္တာအဖုံးကိုလည်း ရွှေ နှင့်လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ရွှေ ခေရုဗိမ် နှစ်ပါး ကိုလည်း သေတ္တာအဖုံး တွင် အလျားတဘက် တချက်၌ ထု လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ထို ခေရုဗိမ် နှစ်ပါး ကို သေတ္တာဖုံး ကိုယ်ထဲကထုတ်၍၊ သေတ္တာဖုံးအပေါ်၌ တဘက် တပါး စီ လုပ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ခေရုဗိမ်နှစ်ပါးတို့သည် မျက်နှာ ချင်းဆိုင် ၍၊ သေတ္တာဖုံး ကို ရှု လျက်၊ မိမိ အတောင် ကို ဖြန့် ၍ သေတ္တာဖုံး ကို မိုး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","သေတ္တာအဖုံး ကို သေတ္တာ ပေါ် မှာ တင် ရမည်။ ငါပေး သော သက်သေခံချက် ကိုလည်း သေတ္တာ ထဲမှာ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ထို အရပ်၌ ငါသည် သင် နှင့် တွေ့ ၍ ၊ သက်သေခံ ချက်ထားသော သေတ္တာ ဖုံး အပေါ် ၊ ခေရုဗိမ် နှစ်ပါး စပ်ကြား မှာ သင် နှင့် နှုတ်ဆက် သဖြင့်၊ ဣသရေလ အမျိုးသား တို့၌ ဆင့်ဆို ရာသမျှ တို့ကို စီရင်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","အလျား နှစ်တောင် ၊ အနံ တတောင် ၊ အမြင့် တ တောင်ထွာရှိသော စားပွဲ ကိုလည်း အကာရှ သား နှင့် လုပ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ရွှေ စင် နှင့် မွမ်းမံ ရမည်။ စားပွဲအပေါ်နားပတ်လည် ၌ ကွပ် သော ရွှေ တန်ဆာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","အနံ လက် တဝါးရှိသောခါးပန်း ကို၎င်း၊ ခါးပန်းအပေါ်နားပတ်လည် ၌ ကွပ် သော ရွှေ တန်ဆာ ကို၎င်း လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ရွှေ လေး ကွင်း ကိုလည်း လုပ် ၍ ၊ ခြေထောက် လေး ခု အထက်စားပွဲလေး ထောင့် ၌ တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ထိုရွှေကွင်း တို့သည် ခါးပန်း ပေါ်မှာရှိ၍၊ စားပွဲ ထမ်း စရာ ထမ်းဘိုး နေရာ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","စားပွဲ ထမ်း စရာ အကာရှ သား ထမ်းဘိုး ကို လုပ် ၍ ရွှေ နှင့်မွမ်းမံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","စားပွဲနှင့်ဆိုင်သော လင်ပန်း ၊ ဇွန်း ၊ အင်တုံ ၊ လောင်း စရာဖလား များကိုလည်း ရွှေ စင် နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ငါ့ ရှေ့ ၊ စားပွဲ ပေါ် မှာ ရှေ့ တော်မုန့် ကို အစဉ် တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","မီးခုံ ကိုလည်း ရွှေ စင် နှင့်လုပ်၍၊ မီးခုံ တိုင် အစရှိသော အလက် များ၊ ခွက် များ၊ ဘူးသီး များ၊ ကြာပွင့် များတို့ကို တစပ်တည်းထု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","မီးခုံတိုင် တဘက် တချက်သုံး လက် စီထွက် ၍၊ အလက် ခြောက် လက်ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","မီးခုံ တိုင်ထဲက ထွက်သော အလက် သုံး လက်တွင်၊ တလက် တလက်၌ ဘူး ကြာပွင့် နှင့်တကွ ၊ ဗာတံ သီးနှင့် ပုံတူသော ခွက် သုံး ခွက် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","မီးခုံ တိုင်၌ လည်း ဘူး ကြာပွင့် နှင့်တကွ ၊ ဗာတံ သီးနှင့်ပုံတူသော ခွက် လေး ခွက် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","မီးခုံ တိုင်ထဲက ထွက် သော အလက် ခြောက် လက်ရှိသည်အတိုင်း ၊ အလက် နှစ်ဘက် အောက် ၌လည်း ဘူး သီးတလုံးစီ ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ဘူး များ၊ အလက် များတို့ကို တကိုယ် တစပ်တည်းဖြစ်စေ ၍၊ မီးခုံတကိုယ်လုံးကို ရွှေ စင် နှင့် ထုလုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","မီးခွက် ခုနစ် လုံးကိုလည်း လုပ် ရမည်။ စားပွဲ ကို လင်း စေခြင်းငှာ ထိုမီးခွက် ကို ထွန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","မီးညှပ် နှင့် မီးညှပ်ခံစရာခွက် တို့သည်လည်း ရွှေ စင် ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","မီးခုံ နှင့် မီးခုံ တန်ဆာ ရှိသမျှ တို့ကို၊ ရွှေ စင် အခွက် တဆယ်နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","တောင် ပေါ်မှာ သင့် အား ပြ ခဲ့ပြီးသော ပုံ နှင့် ညီလျော် စွာ လုပ် ခြင်းငှာ သတိပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","တနည်းကား၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်ဖြင့် ပြီး သော ခေရုဗိမ် အရုပ်နှင့် ချယ် လှယ်သော၊ ပိတ် ချောကုလားကာ ဆယ် ထည်ဖြင့် တဲ တော်ကို လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ကုလားကာ သည် အလျား နှစ်ဆယ် ရှစ် တောင်၊ အနံ လေး တောင် ရှိ၍၊ ကုလားကာ ချင်း အလျား အနံ တူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ကုလားကာ ငါး ထည်စီ တစပ်တည်းချုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ကုလားကာတထည်ပြင်ဘက်မှာ၊ ကုလားကာ နား ချင်း ဆက်မှီရာ၌ ကွင်း များကို ပြာ သောအထည်နှင့် လုပ် ရမည်။ အခြား သော ကုလားကာပြင်ဘက်မှာ၊ ကုလားကာ နား ချင်း ဆက်မှီရာ၌ လည်း ထိုအတူ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ကုလားကာ တထည်၌ ကွင်း ငါးဆယ် ကို၎င်း၊ အခြား သောကုလားကာ အနား ဆက်မှီရာ၌ ကွင်း ငါးဆယ် ကို ၎င်း၊ ကွင်း ချင်း ဆိုင် မိအောင် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ရွှေ ချောင်း ငါးဆယ် ကိုလည်း လုပ် ၍ ၊ ထိုရွှေချောင်း ဖြင့် ကုလားကာ များကို ပူးတွဲ သဖြင့် ၊ တဲ တော် တဆောင် တည်း ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","တဲ တော်ဖုံးအုပ် ဘို့ အခြားသော ကုလားကာ ဆယ် တ ထည်ကို ဆိတ် မွေးနှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ကုလားကာ သည် အလျား အတောင် သုံးဆယ် ၊ အနံ လေး တောင် ရှိ၍၊ ကုလားကာ ဆယ် တ ထည်တို့သည် အလျား အနံချင်း တူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ကုလားကာ ငါး ထည် တစပ် ၊ ခြောက် ထည် တစပ် တည်း ချုပ် ၍ ၊ ဆဌမ ကုလားကာ ကို တဲ တော်ဦး ၌ ခေါက် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ကုလားကာများ ဆက် မှီရာ ၌၊ ပြင် ဘက်ကနေသောကုလားကာ တထည် အနား မှာ ၊ ကွင်း ငါးဆယ် ကို၎င်း၊ ဆက် မှီသော အခြား ကုလားကာ အနား မှာ ၊ ကွင်း ငါးဆယ် ကို၎င်းလုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ကြေးဝါ ချောင်း ငါးဆယ် ကိုလည်း လုပ် ၍ ၊ ကွင်း တို့၌ လျှို ပြီးလျှင်၊ အပေါ်တဲတပိုင်းနှင့် တပိုင်း ပူးတွဲ သဖြင့် ၊ တဲ တဆောင် တည်း ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ထိုအပေါ်တဲ ၌ ပို သော ကုလားကာ တဝက် ကိုကား၊ တဲ တော်နောက်ဖေး မှာ တွဲလွဲ ဆွဲ ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","အပေါ်တဲ၌ ပို သော ကုလားကာ အလျား နှစ်တောင်တွင်၊ တဲ တော်ဖုံးအုပ် ဘို့ တဘက်တချက် တတောင် စီ တွဲလွဲဆွဲ ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","အပေါ်တဲ ဖုံးအုပ် ဘို့ အနီ ဆိုးသောသိုး ရေ ကို၎င်း၊ ထိုသိုးရေအပေါ် ၌ တဟာရှ သားရေ ကို၎င်း လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","တဲ တော်ကာရန် ထောင် ထားရသောအကာရှ ပျဉ်ပြားတို့ကိုလည်း လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ပျဉ်ပြား သည် အလျား ဆယ် တောင် ၊ အနံ တတောင် ထွာ ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ထိုပျဉ်ပြား ရှိသမျှ တို့၌ ခြေထောက် နှစ် ခုစီ တတန်း တည်းရှိစေခြင်းငှာ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","တဲ တော်တောင် ဘက် ၌ ကာရန်ပျဉ်ပြား နှစ်ဆယ် ကို လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ထိုပျဉ်ပြား နှစ်ဆယ် တွင် ၊ တပြားတပြားအောက် ၌ ခြေထောက် နှစ် ခုစီ စွပ်စရာဘို့ ငွေ ခြေစွပ် လေးဆယ် ကို လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ထိုအတူ တဲ တော်မြောက် ဘက် ၌ ကာရန်ပျဉ်ပြား နှစ်ဆယ် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ထိုပျဉ်ပြား ၌ လည်း ငွေ ခြေစွပ် လေးဆယ် ၊ တပြားနှစ် ခုစီ ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","တဲ တော်အနောက် ဘက်၌ ကာရန် ပျဉ်ပြား ခြောက် ပြားကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ထောင့် တဘက် တချက်၌ ကာရန် ပျဉ်ပြား နှစ် ပြားကို၎င်းလုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","အထက် ၌ ၎င်း ၊ အောက် ၌၎င်း၊ ကွင်း ကိုတပ်၍ စေ့စပ်လျက် ထောင့် နှစ်ခုကို ပြီး စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ပျဉ်ပြား ရှစ် ပြား၊ ငွေ ခြေစွပ် ဆယ် ခြောက် ခု၊ တပြားနှစ် ခုစီ ရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","တဲတော်၌ ကာရသော ပျဉ်ပြား ကို လျှိုစရာဘို့ အကာရှ သား ကန့်လန့်ကျင် တို့ကို တဘက် ငါး ချောင်းစီ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","တဲ တော်နောက် ဖေး၌ ကာရသော ပျဉ်ပြား ကို လျှိုစရာဘို့ ကန့်လန့်ကျင် ငါး ချောင်းကိုလည်း လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","အလယ် ကန့်လန့်ကျင် ကို၊ ထောင့်တဘက် တချက်၌ ဆုံး စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ပျဉ်ပြား တို့ကို ရွှေ နှင့်မွမ်းမံ ရမည်။ ကန့်လန့်ကျင် လျှို ဘို့ ရာ ရွှေ ကွင်း ကိုလည်း လုပ် ၍ ၊ ကန့်လန့်ကျင် တို့ကို ရွှေ နှင့်မွမ်းမံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","တောင် ပေါ် မှာ သင့်အားပြ သော ပုံ နှင့်အညီ ၊ တဲ တော်ကို တည်ဆောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","တနည်းကား၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ဖြင့်ပြီး ၍၊ ခေရုဗိမ် အရုပ်နှင့် ချယ်လှယ် သော ကုလားကာ တထည်ကို ချုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ရွှေ ချ သော အကာရှ သား တိုင် လေး တိုင်အပေါ် မှာ၊ ထိုကုလားကာ ကို ဆွဲ ထားရမည်။ ထိုတိုင် တို့သည် ရွှေ တံစို့ နှင့်၎င်း၊ ငွေ ခြေစွပ် လေး ခုနှင့်၎င်း ပြည့်စုံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","သက်သေခံ ချက်ထားသော သေတ္တာ ကို၊ ကုလားကာ အတွင်း သို့ သွင်း စရာဘို့ ထိုကုလားကာ ကို ရွှေချောင်း ဖြင့် ဆွဲကာ ၍ ၊ ဟဂျာ အရပ်၊ ဟဂျာဟဂျုံ အရပ် နှစ်ပါးစပ်ကြား ၌ အပိုင်း အခြား ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ဟဂျာဟဂျုံ အရပ်၌ သက်သေခံ ချက်သေတ္တာ အပေါ် မှာ၊ သေတ္တာအဖုံး ကို တင် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ကုလားကာ ပြင် မှာ စားပွဲ ကို ထားရမည်။ တဲ တော်တောင် ဘက်နား မှာ မီးခုံ ကို၎င်း ၊ မြောက် ဘက်နား မှာ စားပွဲ ကို၎င်း၊ တဘက်နှင့်တဘက် ဆိုင်မိအောင် ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","တဲ တော်တံခါးဝ ၌ ကာရန်၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ဖြင့် ပြီး ၍၊ ချယ်လှယ် သော ကုလားကာ တထည်ကို လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ထိုကုလားကာ ဘို့ ရွှေ တံစို့ နှင့်ပြည့်စုံသော အကာရှ တိုင် ငါး တိုင်ကို လုပ် ၍ ရွှေနှင့်မွမ်းမံ ရမည်။ ကြေးဝါ ခြေစွပ် ငါး ခုကိုလည်း သွန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","တနည်းကား၊ အလျား ငါး တောင် ၊ အနံ ငါး တောင် ရှိ၍ စတုရန်း လေးထောင့်ဖြစ်သော ယဇ် ပလ္လင်ကို၊ အကာရှ သား နှင့်လုပ် ရမည်။ အမြင့် လည်း သုံး တောင် ရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ယဇ်ပလ္လင် လေး ထောင့် အပေါ် မှာ၊ ဦးချို လေးချောင်းကို အကာရှသားနှင့်လုပ် ၍ ကြေးဝါ နှင့် မွမ်းမံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ခံ စရာအိုး နှင့်တကွ တူးရွင်း ပြား၊ အင်တုံ ၊ အမဲသား ချိတ်၊ လင်ပန်း အစရှိသော ယဇ်ပလ္လင်နှင့် ဆိုင်သော တန်ဆာ ရှိသမျှ တို့ကို ကြေးဝါ နှင့် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ကြေးဝါ ဆန်ခါ ကို၎င်း ၊ ဆန်ခါ လေး ထောင့် အပေါ် မှာ ကြေးဝါ လေး ကွင်း ကို၎င်းလုပ် ပြီးလျှင် ၊ 5ယဇ်ပလ္လင် ခါးပန်း အောက် ၊ အလယ် ၌ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ယဇ်ပလ္လင် ထမ်း စရာ အကာရှ သား ထမ်းဘိုး တို့ကို လုပ် ၍ ကြေးဝါ နှင့် မွမ်းမံ ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ယဇ် ပလ္လင်ကို ထမ်း စရာဘို့ တဘက် တချက် ကွင်း များ၌ လျှို ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","တောင် ပေါ် မှာ သင့် အား ပြ သည်အတိုင်း ၊ ထိုယဇ်ပလ္လင်ကို အပေါ်အောက် ဟင်းလင်း ဖြစ်စေခြင်းငှာ၊ ပျဉ်ပြား နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","တဲ တော်ဝင်း ကာရန်မူကား၊ အလျားအတောင် တရာ ရှိသော ပိတ်ချော နှင့် တောင် ဘက် ၌ ကုလားကာ ကို လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ထိုကုလားကာဘို့ တိုင် နှစ်ဆယ် ၊ တိုင်ခြေစွပ် နှစ်ဆယ် ကို ကြေးဝါ နှင့်လုပ်၍ တိုင် တံစို့ ၊ တိုင်တန်း တို့ကို ငွေ ဖြင့် ပြီးစေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ထိုနည်းတူ ၊ မြောက် ဘက် ၌ ကာရန် အလျား အတောင်တရာ ရှိသော ကုလားကာနှင့်တကွ ငွေတံစို့ ၊ ငွေ တန်း ပါသောကြေးဝါတိုင် နှစ်ဆယ်၊ ကြေးဝါ ခြေစွပ် နှစ်ဆယ် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ဝင်း အနောက် ဘက် အနံ၌ ကာရန်၊ အလျားအတောင် ငါးဆယ် ရှိသောကုလားကာနှင့်တကွတိုင်တဆယ် ၊ ခြေစွပ် တဆယ် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ဝင်း အရှေ့ ဘက်၌ လည်း အနံ အတောင် ငါးဆယ် ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","တံခါးဝတဘက်တချက်၌ ကာရန်၊ အလျားဆယ် ငါး တောင် ရှိသောကုလားကာ နှင့်တကွ တိုင် သုံး တိုင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ခြေစွပ် သုံး ခုရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ဝင်း တံခါးဝ ၌ ကာရန် ၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ဖြင့်ပြီး ၍၊ ချယ်လှယ် သော ကုလားကာ အတောင် နှစ်ဆယ် နှင့်တကွတိုင် လေး တိုင် ခြေစွပ် လေး ခုရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ဝင်း ပတ်လည် ၌ တိုင် ရှိသမျှ တို့သည် ငွေ တံစို့ ၊ ငွေ တန်း၊ ကြေးဝါ ခြေစွပ် နှင့် ပြည့်စုံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ဝင်း သည် အလျား အတောင် တရာ ၊ အနံ ငါးဆယ် ၊ အမြင့် ငါး တောင် ရှိ၍၊ ပိတ်ချော နှင့်ကြေးဝါ ခြေစွပ် ဖြင့် ပြီး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","အမှု တော်ထမ်းဘို့ တဲ တော်အသုံးအဆောင် ရှိသမျှ ကို၎င်း၊ တဲ တော်တံသင် ၊ ဝင်း နှင့်ဆိုင်သော တံသင် ရှိသမျှ ကို၎င်း ကြေးဝါ နှင့်လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ပရိသတ်စည်းဝေးရာ တဲတော်တွင်၊ သက်သေခံချက်ထားရာအရပ်ကို ကာသော ကုလားကာပြင်မှာ၊ မီးခုံ၌ အစဉ် မပြတ်မီး ထွန်း စရာဘို့ ၊ သံလွင်သီးကို ထောင်း ၍ယူသော သံလွင် ဆီ စစ် ကို၊ ဣသရေလ အမျိုးသား တို့သည် ဆောင် ခဲ့ရကြမည်အကြောင်း ဆင့်ဆို လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","အာရုန် နှင့် သူ ၏သား တို့သည်၊ ညဦး မှသည် နံနက် တိုင်အောင် ၊ ထာဝရဘုရား ရှေ့ တော်၌ ထိုအမှု ကို စီရင် ရမည်။ ဣသရေလ အမျိုး တို့သည်၊ သား အစဉ် အဆက်စောင့်ရသောပညတ် တော် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","သင် ၏ အစ်ကို အာရုန် သည်၊ ငါ့ ရှေ့မှာ ယဇ်ပုရောဟိတ်အမှုကို ဆောင် ရမည်အကြောင်း ၊ သူ နှင့် သူ ၏ သား တည်းဟူသောနာဒပ် ၊ အဘိဟု ၊ ဧလာဇာ ၊ ဣသမာ တို့ကို၊ ဣသရေလ အမျိုးသား တို့အထဲ က ရွေးချယ်၍ သင့် အောက်၌ ခန့် ထားလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","သင် ၏အစ်ကို အာရုန် ၌ ဘုန်း အသရေထင်ပေါ်စေခြင်းငှာ ၊ သန့်ရှင်း သော အဝတ် ကို လုပ် ၍ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","အာရုန်သည် ငါ့ ရှေ့ မှာ ယဇ်ပုရောဟိတ်အမှုကို ဆောင်ရွက် ရသောအခွင့်ရှိ၍၊ သူ့ ကို သန့်ရှင်း စေခြင်းငှါ ၊ ငါပေး သော ဉာဏ် ကိုရသော ပညာရှိ အပေါင်း တို့သည် ထိုအဝတ် ကို လုပ် ရမည် အကြောင်း မှာ ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","လုပ် ရသော အဝတ် ဟူမူကား၊ ရင်ဖုံး ၊ သင်တိုင်း ၊ ဝတ်လုံ ၊ ချယ်လှယ်သောအင်္ကျီ ၊ ဗေါင်း ၊ ခါးပန်း တည်း ဟူသောသင် ၏အစ်ကို အာရုန် နှင့် သူ ၏သား တို့သည်၊ ငါ့ ရှေ့ မှာ ယဇ်ပုရောဟိတ်အမှုကို ဆောင်ရွက် ရမည်အကြောင်း ၊ သန့်ရှင်း သောအဝတ် ကို လုပ် ခြင်းငှါ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ရွှေ နှင့် ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော တို့ကို ယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ထိုရွှေ အစရှိသည်တို့နှင့် သင်တိုင်း ကို ထူးဆန်း စွာ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","သိုင်းကြိုး နှစ် ပင်ရှိ ၍၊ သင်တိုင်း အပေါ်နားချင်းတွဲ မိစေခြင်းငှာ ၊ တဘက် တချက်ကို ဆွဲချုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","သင်တိုင်းအပေါ်နား၌ ထူးဆန်းသော ရင်စည်း ကိုလည်း ၊ သင်တိုင်းကိုယ်ကဲ့သို့ ရွှေ နှင့်၎င်း၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော တို့ကို၎င်းလုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ရှဟံ ကျောက် နှစ် လုံးကိုယူ ၍ ၊ ဣသရေလ အမျိုး တဆယ်နှစ်မျိုးကို၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","အသက်အကြီးအငယ် အလိုက် ၊ ကျောက် နှစ်လုံးပေါ် မှာ အမျိုးနာမည် ခြောက် ခုစီ အက္ခရာ တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","တံဆိပ် ပေါ်မှာ အက္ခရာတင် သကဲ့သို့၊ ကျောက် လုပ် သော အလုပ် နှင့်တကွ၊ ဣသရေလ အမျိုး ၏ နာမည် တို့ကို ထိုကျောက် နှစ် လုံးအပေါ်မှာ အက္ခရာ တင်၍ ရွှေ ကျောက်အိုး ၌ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ဣသရေလအမျိုးသား တို့ကို အောက်မေ့ စေခြင်းငှါ ၊ ထိုကျောက် နှစ် လုံးကို သင်တိုင်း သိုင်းကြိုး ပေါ် မှာ တပ် ရမည်။ ထိုသို့ ဣသရေလအမျိုးသားတို့ကို အောက်မေ့ စေခြင်းငှါ ၊ သူ တို့နာမည် များကို အာရုန် သည် ထာဝရဘုရား ရှေ့ တော်၌ မိမိ ပခုံး ပေါ် မှာ ဆောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ကျောက် အိုးတို့ကို ရွှေ နှင့်လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","အဆုံး၌တပ်ရသောကြိုး နှစ် ပင်တို့ကို ရွှေ စင် နှင့်ကျစ် ၍ လုပ် ပြီးမှကျောက်အိုး ၌ တွဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ရွှေ နှင့်၎င်း၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော နှင့်၎င်း၊ သင်တိုင်း ကို လုပ် သည်နည်းတူ ၊ ဗျာဒိတ် ရင်ဖုံး ကို ထူးဆန်း စွာ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","နှစ်ထပ်ခေါက် လျက်၊ အလျား တထွာ၊ အနံ တထွာ၊ စတုရန်း လေးထောင့် ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ထိုရင်ဖုံး ၌ ကျောက် မြတ်ကို လေး တန်း စီ ရမည်။ ပဌမ အတန်း ကား၊ ကျောက်နီ ၊ ဥဿဖရား ၊ ပတ္တမြား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ဒုတိယ အတန်း ကား ၊ မြ ၊ နီလာ ၊ စိန် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","တတိယ အတန်း ကား ၊ ဝှါကိန္တု ၊ မဟူရာ ၊ ဂေါ်မိတ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","စတုတ္ထ အတန်း ကား ၊ မျက်ရွဲ ၊ ကြောင် ၊ နဂါးသွဲ့ ဖြစ်၍ ၊ အသီးအသီး တို့ကို ရွှေ အိုး၌ စီ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ဣသရေလ အမျိုး တဆယ် နှစ် မျိုး ရှိ သည်အတိုင်း၊ တံဆိပ် ပေါ်မှာ အက္ခရာ တင်သကဲ့သို့ထိုကျောက် တို့၌၊ ထို တဆယ့်နှစ်ပါးသော နာမည် အသီးသီးတို့ကို တင်လျက်၊ ကျောက်တ လုံးလျှင်နာမည် တပါးစီပါ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ရင်ဖုံး အပေါ်ထောင့် နှစ် ခု၌ ရွှေ နှစ် ကွင်း ကို၎င်း၊ ကျစ် သောရွှေ ကြိုး နှစ်ပင်ကို၎င်း လုပ် ပြီးမှ၊ ထိုရွှေကွင်း ၌တပ် ၍၊ သင်တိုင်း သိုင်းကြိုး ပေါ်မှာ ရှိသောကျောက်အိုးတို့၌ တွဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","တဖန် ရွှေ နှစ် ကွင်း ကိုလုပ် ၍ သင်တိုင်း အောက်နား မှာ ရှိသော ရင်ဖုံး အောက် ထောင့် နှစ် ခု၌ တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","အခြားသော ရွှေ နှစ် ကွင်း ကိုလည်း လုပ် ၍ ၊ သင်တိုင်း ရှေ့ ဘက်အောက် နား၌ ထူးဆန်းသော ရင်စည်း အပေါ် နားဆက်မှီ ရာတွင် ၊ သင်တိုင်း ကိုယ် တဘက် တချက်၌ တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ရင်ဖုံးရွှေနှစ်ကွင်းကို သင်တိုင်း ရွှေနှစ်ကွင်း နှင့်တွဲ၍၊ ပြာ သောကြိုး ဖြင့် ပြီးစေရမည်။ ထိုသို့ ရင်ဖုံး ကို ထူးဆန်းသော ရင်စည်း အပေါ်နားမှာ ဆွဲ ၍၊ သင်တိုင်း နှင့်မ ကွာ အမြဲရှိစေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","အာရုန် သည်လည်း ၊ သန့်ရှင်း ရာအရပ်ဌာနတော်ထဲသို့ ဝင် သောအခါ ၊ ဣသရေလ အမျိုးသား တို့ကို ထာဝရဘုရား အစဉ် အောက်မေ့ တော်မူစေခြင်းငှါ ၊ ဗျာဒိတ် ရင်ဖုံး ၌ ပါသောသူတို့ နာမည် များကို မိမိ နှလုံး ပေါ် မှာ ဆောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ဗျာဒိတ် ရင်ဖုံး အထဲ ၌ ဥရိမ် နှင့် သုမိမ် ကို သွင်း ထားရမည်။ အာရုန် သည် ထာဝရဘုရား ရှေ့ တော်သို့ ဝင် သောအခါ ၊ မိမိနှလုံး အပေါ် မှာ ဥရိမ်နှင့် သုမိမ်ပါ သည်ဖြစ်၍ ၊ ဣသရေလ အမျိုးသား တို့အမှု၌ စီရင် တော်မူချက်ကို ထာဝရဘုရား ရှေ့ ၊ မိမိ နှလုံး ပေါ် မှာ ဆောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","သင်တိုင်း နှင့်ဆိုင်သော ဝတ်လုံ ကို၊ ပြာ သောအထည်နှင့်သာ လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ဝတ်လုံ ၌ လည်စွပ်ပါ ၍ လည်စွပ် ကို မ စုပ် စေခြင်းငှါ ၊ သံချပ်လည်စွပ်ကွပ်သကဲ့သို့ ၊ ရက် သောအထည် နှင့် ကွပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်နှင့် လုပ်သော သလဲ သီးများကို၎င်း ၊ ရွှေ ဆည်းလည်း များကို၎င်း၊ ဝတ်လုံ အောက်စွန်းနားပတ်လည် ၌ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","သလဲ သီးတလုံး၊ ရွှေ ဆည်းလည်း တလုံးစီခြားလျက်၊ အစဉ်အတိုင်းဆွဲထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","အာရုန် သည် အမှု တော်ကို ဆောင်၍ ၊ သန့်ရှင်း ရာအရပ် ဌာနတော်ထဲမှာ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ထွက် ဝင် သောအခါ ၊ သေ ဘေးနှင့် ကင်းလွတ် မည်အကြောင်း ၊ ထိုဝတ်လုံကို ဝတ်၍ သူ၏ အသံ ကို ကြား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ရွှေ စင် သင်းကျစ် ကိုလည်း လုပ် ၍ ၊ တံဆိပ် ပေါ် မှာ အက္ခရာတင် သကဲ့သို့၊ ထာဝရဘုရား အား သန့်ရှင်း ခြင်းဟု အက္ခရာတင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ပြာ သောကြိုး နှင့်ဗေါင်း ရှေ့ ၌ ချည် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","အာရုန် သည် ထိုသင်းကျစ်ကို နဖူး ၌ ဆင် သဖြင့် ၊ ဣသရေလ အမျိုးသား တို့၏ သန့်ရှင်း သော အလှူ ဒါနနှင့်ဆိုင်၍၊ သန့်ရှင်း စေသမျှသော အရာ တို့၌ ပါသောအပြစ် ကို ဆောင် ရမည်။ သူ တို့သည် ထာဝရဘုရား ၏ စိတ် တော်နှင့် တွေ့ခြင်းငှါ ၊ အာရုန် ၏ နဖူး ၌ အစဉ် ဆင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ပိတ်ချော အင်္ကျီ ကိုလည်း လုပ် ၍ ချယ်လှယ်ရမည်။ ဗေါင်း ကိုလည်း ပိတ်ချော နှင့်လုပ် ရမည်။ ခါးပန်း ကိုလည်း ချယ်လှယ် သော အလုပ် နှင့် ပြီး စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","အာရုန် ၏သား တို့ ဘုန်း အသရေ ကို ထင်ပေါ်စေခြင်းငှါ ၊ အင်္ကျီ ၊ ခါးပန်း ၊ ဦးထုပ် များကို လုပ် ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ထိုသို့ သင် ၏ အစ်ကို အာရုန် နှင့် သူ ၏သား တို့ကို ဝတ်ဆင် စေပြီးမှ ၊ သူ တို့သည် ငါ့ ရှေ့ မှာ ယဇ်ပုရောဟိတ် အမှုကို ဆောင်ရွက်မည်အကြောင်း ၊ သူ တို့ကို ဆီ နှင့်လိမ်းသဖြင့် အရာ၌ ခန့်ထား၍ သန့်ရှင်း စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","သူ တို့၌ ရှက် စရာအကြောင်း၊ မ ထင်မပေါ်စေခြင်းငှါ ၊ ခါး မှ ပေါင် သို့အထိ ပိတ် ပေါင်းဘီ ကို ချုပ် ၍ ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","အာရုန် နှင့် သူ ၏သား တို့သည်၊ ပရိတ်သတ်စည်းဝေး ရာ တဲ တော်ထဲသို့ ဝင် သော် ၎င်း၊ သန့်ရှင်း ရာအရပ် ဌာန၌ ယဇ် ပလ္လင်အနားသို့ ချည်းကပ် သော် ၎င်း ၊ အပြစ် ရောက် ၍ မ သေ စေခြင်းငှါ ထိုသို့ ဝတ် ရမည်။ အာရုန် မှစ၍ သူ ၏အမျိုး အစဉ်အဆက်တို့သည် စောင့်ရသောပညတ် တော် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","သူ တို့သည် ငါ့ရှေ့၌ ယဇ်ပုရောဟိတ်အမှုကို ဆောင်ရွက် မည်အကြောင်း ၊ အဘယ်သို့သန့်ရှင်း စေရမည် နည်းဟူမူကား၊ အပြစ်မပါသော နွား သငယ် အထီးနှင့် သိုး နှစ် ကောင်တို့ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","တဆေး မပါသော ဂျုံမုန့် ၊ တဆေး မပါဘဲ ဆီ နှင့် လုပ် သော ဂျုံမုန့်ပြား ၊ တဆေး မပါဘဲ ဆီ နှင့် လူး သော ဂျုံမုန့်ကြွပ် တို့ကို၎င်းယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ထိုမုန့် များကို တောင်း တလုံးထဲ ၌ထည့် ပြီးမှ ၊ နွား တကောင်၊ သိုး နှစ် ကောင်နှင့်တကွ ဆောင်ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","အာရုန် နှင့် သူ ၏သား တို့ကို၊ ပရိသတ် စည်းဝေး ရာ တံခါး နားသို့ ခေါ် ခဲ့၍ ရေချိုး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","အဝတ်တန်ဆာ များကိုယူ ၍၊ အင်္ကျီ ၊ ဝတ်လုံ ၊ သင်တိုင်း ၊ ရင်ဖုံး နှင့် အာရုန် ကို ဝတ် စေ၍၊ ထူးဆန်းသောသင်တိုင်း ရင်စည်း နှင့် စည်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","သူ ၏ ခေါင်း ပေါ် မှာ ဗေါင်း ကိုတင် ၍ ၊ ဗေါင်း ၌ သန့်ရှင်း သော သင်းကျစ် ကို တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ထိုအခါ လိမ်း စရာ ဆီ ကိုယူ ၍ သူ ၏ ခေါင်း ပေါ် ၌ လောင်း သဖြင့် သူ့ ကိုလိမ်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","သူ ၏သား တို့ကိုလည်း ခေါ် ခဲ့၍ အင်္ကျီ ဝတ် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ခါးပန်း ကိုလည်း စည်း ၍ ၊ ဦးထုပ် ကိုလည်း ဆောင်း စေပြီးလျှင်။ သူ တို့သည် ထာဝရပညတ်တော် အတိုင်း ယဇ်ပုရောဟိတ်အရာကို ဆိုင် ရမည်။ ထိုသို့ အာရုန် နှင့် သူ ၏သား တို့ကို၊ ယဇ်ပုရောဟိတ် အရာ၌ ခန့် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ထိုနောက်၊ နွားထီး တကောင်ကို ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ သို့ ဆောင် ခဲ့၍ ၊ အာရုန် နှင့် သူ ၏ သား တို့သည်၊ မိမိ တို့ လက် ကို နွား ခေါင်း ပေါ် မှာ တင်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နားမှာ ထာဝရဘုရား ရှေ့ တော်၌ ထိုနွား ကိုသတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","အသွေး ကို ယူ ၍ ယဇ်ပလ္လင် ဦးချို တို့၌ လက်ညှိုး နှင့် ထည့် ပြီးမှ ၊ ကြွင်း သောအသွေး ကို ယဇ်ပလ္လင် ခြေရင်း နား၌ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","အအူ ကို ဖုံး သောဆီဥ ရှိသမျှ ၊ အသည်း ပေါ် ၌ ရှိသောအမြှေး ၊ ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ကိုယူ ၍ ယဇ်ပလ္လင် ပေါ် မှာ မီးရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","နွား ၏အသား ၊ အရေ ၊ ချေးနု ကိုကား ၊ တပ် ပြင် မှာ မီးရှို့ ရမည်။ အပြစ် ဖြေရာယဇ် ဖြစ်၏ ");
INSERT INTO myajvb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","သိုးထီး တကောင်ကိုလည်း ယူ ၍ ၊ အာရုန် နှင့် သူ ၏သား တို့သည်၊ မိမိ တို့လက် ကို သိုး ခေါင်း ပေါ် မှာ တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ထိုသိုး ကိုသတ် ပြီးလျှင် အသွေး ကိုယူ ၍ ယဇ်ပလ္လင် အပေါ် နား ပတ်လည် ၌ ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","သိုး ကိုလည်း အပိုင်းပိုင်း ဖြတ် ၍ ဝမ်းထဲ ၌ရှိသောအရာနှင့် ခြေ တို့ကို ဆေးကြော ပြီးလျှင် ၊ ခေါင်း နှင့် သားတစ်များကို စု ထား၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","သိုး တကောင်လုံး ကို ယဇ်ပလ္လင် ပေါ် မှာ မီးရှို့ ရမည်။ ထာဝရဘုရား အား မီးရှို့ သောယဇ်ဖြစ်၏။ ထာဝရဘုရားအား မီးဖြင့် ဆက်ကပ်၍၊ မွှေးကြိုင် သော ပူဇော် သက္ကာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","အခြား သော သိုး ကိုလည်း ယူ ၍ ၊ အာရုန် နှင့် သူ ၏သား တို့သည် မိမိ တို့လက် ကို သိုး ခေါင်း ပေါ် မှာ တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ထိုသိုး ကိုသတ် ပြီးလျင် အသွေး ကိုယူ ၍ အာရုန် ၏ လက်ျာနားပျဉ်း ၌ ၎င်း၊ သူ ၏သား တို့၏ လက်ျာ နားပျဉ်း ၌ ၎င်း။ သူ တို့၏ လက်ျာ လက်မ ၌ ၎င်း၊ လက်ျာ ခြေမ ၌ ၎င်း ထည့် ၍ ၊ ယဇ်ပလ္လင် အပေါ် ပတ်လည် ၌ ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ယဇ်ပလ္လင် ပေါ် မှာရှိသော အသွေး နှင့် လိမ်း စရာဆီ ကိုယူ ၍ အာရုန် နှင့် သူ ၏ အဝတ် ၌ ၎င်း ၊ သူ ၏ သား တို့နှင့် သူ တို့ အဝတ် ၌ ၎င်း၊ ဖြန်း သဖြင့် ၊ အာရုန် မှစ၍ သား များ၊ အဝတ် များတို့သည် သန့်ရှင်း ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ထိုသိုးသည် အရာ၌ ခန့်ထားရာသိုး ဖြစ်သောကြောင့်၊ ဆီဥ ၊ အမြီး ၊ အအူ ကို ဖုံး သောဆီဥ ၊ အသည်း ပေါ်၌ ရှိသောအမြှေး ၊ ကျောက်ကပ် နှစ်ခု နှင့် ကျောက်ကပ်ကိုဖုံးသော ဆီဥ ၊ လက်ျာ ပခုံး ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ထာဝရဘုရား ရှေ့ တော၌ထား သော တဆေး မဲ့ မုန့်တောင်း ထဲက မုန် တလုံး၊ ဆီ နှင့် လုပ်သော မုန့် ပြားတပြား၊ မုန့် ကြွပ်တချပ်ကို ယူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","အာရုန် လက် ၊ သူ ၏ သား တို့လက် ၌ ထိုအရာတို့ကို ထား ပြီးလျှင် ၊ ထာဝရဘုရား ရှေ့တော်၌ ချီလွှဲ ၍၊ ချီလွှဲသော ပူဇော် သက္ကာ ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ထို အရာတို့ကို သူ တို့လက် မှ ခံယူ ၍ ၊ ထာဝရဘုရား ရှေ့တော်တွင် မွှေးကြိုင် သောအနံ့ ဖြစ်စေခြင်းငှါ ၊ ယဇ်ပလ္လင် ၌ မီးရှို့ ရာ ယဇ်အပေါ် မှာ ရှို့ ရမည်။ ထာဝရဘုရား အား မီး ဖြင့် ပြုသောပူဇော်သက္ကာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","အာရုန် ၏အရာ ၌ ခန့်ထားရာ သိုး ၏ရင်ပတ် ကို ယူ ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲသဖြင့်၊ ချီလွှဲသော ပူဇော် သက္ကာပြုပြီးမှ ၊ သိုး၏ ရင်ပတ်သည် သင် ၏ အဘို့ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ထိုသို့ အာရုန် နှင့် သား တို့၏ အရာ ၌ ခန့်ထားသော သိုး ထဲက ၊ ချီလွှဲသော ပူဇော်သက္ကာပြု၍၊ ချီလွှဲ သော ရင်ပတ် ကို၎င်း၊ ချီ မြှောက်သော ပူဇော်သက္ကာပြု၍ ၊ ချီမြှောက်သော ပခုံး ကို၎င်းသန့်ရှင်း စေ ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ထိုရင်ပတ်၊ ပခုံးတို့သည် ထာဝရ ပညတ်တော်အတိုင်း၊ ဣသရေလ အမျိုးသား လှူ သော အာရုန် ၏ အဘို့၊ သူ့ သား တို့၏အဘို့ ဖြစ် ရမည်။ ဣသရေလ အမျိုးသား ပြုသောမိဿဟာယ ယဇ်ထဲက ၊ ထာဝရဘုရား ရှေ့တော်၌ ချီးမြှောက် ၍၊ ချီးမြှောက်ရာ ပူဇော် သက္ကာ ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","အာရုန် ၏ သန့်ရှင်း သော အဝတ် တန်ဆာကို၊ သူ ၏သား တို့သည် အမွေခံ သဖြင့်၊ ဆီလိမ်း ခြင်း မင်္ဂလာနှင့် ယဇ်ပုရောဟိတ်အရာ၌ ခန့် ထားသောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","အာရုန် ကိုယ်စား ယဇ် ပုရောဟိတ်လုပ်သော သား သည်၊ သန့်ရှင်း ရာဌာန၌ အမှုတော် ကို ဆောင်ခြင်းငှါ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ ဝင် သောအခါ ခုနစ် ရက် ပတ်လုံးဝတ်ဆင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","အရာ ၌ခန့်ထားရာ သိုး ၏အသား ကို ယူ ၍ ၊ သန့်ရှင်း ရာဌာန ၌ ပြုတ် ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","အာရုန် နှင့် သူ ၏သား တို့သည် ထိုအသား ကို၎င်း ၊ တောင်း ထဲ၌ ရှိသော မုန့် ကို၎င်း၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နားမှာ စားရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","သူတို့ကို သန့်ရှင်းစေ၍၊ အရာ၌ ခန့်ထား စေခြင်းငှါ ၊ အပြစ် ဖြေရာ မင်္ဂလာပြုခြင်းနှင့် ဆိုင်သော အရာတို့ကို၊ သူတို့သည် စား ရကြမည်။ ထို အရာတို့သည် သန့်ရှင်း သောကြောင့် ၊ မဆိုင် သောသူ မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","အရာ ၌ ခန့်ထားရာနှင့် ဆိုင်သောအမဲသား ဖြစ်စေ ၊ မုန့် ဖြစ်စေ၊ နံနက် တိုင်အောင် ကျန် ကြွင်းလျှင် ၊ ထိုအကြွင်း ကို မီးရှို့ ရမည်။ သန့်ရှင်း သောကြောင့် ၊ အဘယ်သူမျှမ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ထိုသို့ ငါပညတ် သမျှ အတိုင်း အာရုန် နှင့် သူ ၏ သား တို့ အား ပြု ၍၊ ယဇ်ပုရောဟိတ်အရာ၌ ခန့်ထား ခြင်း မင်္ဂလာကို၊ ခုနစ် ရက် ပတ်လုံးဆောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ထိုမှတပါး၊ အပြစ် ဖြေခြင်းအလိုငှါ ၊ နေ့ တိုင်း နွားထီး တကောင်ကို ပူဇော် ၍၊ အပြစ် ဖြေရာယဇ် ပြုရမည်။ ထိုသို့ ယဇ်ပလ္လင်ဘို့ အပြစ် ဖြေခြင်းကို ပြုပြီးမှ ၊ ပလ္လင် ကို စင်ကြယ် စေရမည်။ ထို့နောက် သန့်ရှင်း စေခြင်းငှါ ဆီ နှင့် လိမ်းရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ခုနစ် ရက် ပတ်လုံးယဇ်ပလ္လင် ဘို့ အပြစ် ဖြေခြင်းကို ပြု၍ သန့်ရှင်း စေပြီးမှ ၊ အလွန်သန့်ရှင်း သော ယဇ်ပလ္လင် ဖြစ် ၍၊ ထိုပလ္လင် နှင့် တွေ့ သမျှ သောအရာတို့သည် သန့်ရှင်း သောအရာ ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ယဇ်ပလ္လင် ပေါ် မှာ ပူဇော် ရသော အရာ ဟူမူကား ၊ အခါ မလည်သော သိုးသငယ် နှစ် ကောင်ကို ယူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","နေ့ တိုင်း အစဉ်မပြတ် နံနက် ယံ၌ တ ကောင်၊ ညဦး ယံ၌ တ ကောင်ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","သိုးသငယ်တကောင်ကို ပူဇော်သောအခါ၊ သံလွင်သီးကိုထောင်း ၍၊ ရသောသံလွင်ဆီ သုံးလောဃ နှင့် ရော သော မုန့်ညက် တဩမဲကို၎င်း၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာဘို့ စပျစ်ရည် သုံးလောဃ ကို ၎င်း၊ သိုးသငယ် နှင့် အတူ ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","အခြား သော သိုးသငယ် ကို ညဦး ယံ၌ ပူဇော် သောအခါ၊ နံနက်ယံ ၌ ဘောဇဉ်ပူဇော်သက္ကာ ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာပါသည်နည်းတူ ပါလျက်၊ ထာဝရဘုရား အား မီး ဖြင့် ဆက်ကပ်၍၊ မွှေးကြိုင် သော ပူဇော် သက္ကာပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ထိုသို့ သင် တို့သား စဉ်မြေးဆက်တို့သည် သင် နှင့် ငါတွေ့ ၍ နှုတ်ဆက်ရာအရပ် ၊ ထာဝရဘုရား ရှေ့ တော် ၌၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နားမှာ အစဉ်မပြတ် မီးရှို့ သောယဇ်ကို ပူဇော်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ထို အရပ်၌ ဣသရေလ အမျိုးသား တို့နှင့် ငါတွေ့ ၍ ၊ ငါ့ ဘုန်း တော်အားဖြင့် သူတို့ကို သန့်ရှင်း စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ငါ့ ရှေ့ ၌ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်စေ ခြင်းငှါ ၊ အာရုန် နှင့် သူ ၏သား တို့ကို၎င်း၊ ပရိသတ် စည်းဝေး ရာ တဲ တော်ကို၎င်း ၊ ယဇ်ပလ္လင် ကို၎င်း ၊ ငါသန့်ရှင်း စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ဣသရေလ အမျိုးသား တို့တွင် ငါနေ ၍ ၊ သူ တို့၏ ဘုရား ဖြစ် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ငါ သည် သူတို့တွင် နေ ခြင်းငှါ ၊ သူ တို့ကို အဲဂုတ္တု ပြည် ထဲက ကယ်နှုတ် ဆောင်ယူခဲ့သော သူ တို့ ၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်ကြောင်းကို သူတို့ သိ ကြလိမ့်မည်။ ငါ သည် သူ တို့ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏ဟု မောရှေအား မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","တနည်းကား၊ နံ့သာ ပေါင်းကို မီးရှို့ စရာ ယဇ်ပလ္လင် ကို အကာရှ သား နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ထိုပလ္လင်သည် အလျား တတောင် ၊ အနံ တတောင် ၊ စတုရန်း လေးထောင့်ဖြစ်၍ ၊ အမြင့် နှစ်တောင် ရှိ ရမည်။ ဦးချို တို့ကိုလည်း အကာရှသား ဖြင့် ပြီး စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ပလ္လင်ထိပ် ၊ နံရံ ၊ ဦးချို တို့ကို ရွှေ စင် နှင့် မွမ်းမံ ၍ ၊ အပေါ်နားပတ်လည် ၌ ကွပ်သော ရွှေ တန်ဆာ ကိုလည်း လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ရွှေတန်ဆာ အောက်၊ ပလ္လင် တဘက် တချက်ထောင့်၌ ရွှေ ကွင်း နှစ် ကွင်းကို လုပ် ၍၊ ပလ္လင် ထမ်း စရာ ထမ်းဘိုး နေရာ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ထမ်းဘိုး တို့ကို အကာရှ သား နှင့် လုပ် ၍ ရွှေ နှင့်မွမ်းမံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ငါသည် သင် နှင့် တွေ့ ရာအရပ် ၊ သက်သေခံ ချက် ထားသောသေတ္တာ ကို၊ ကာသော ကုလားကာ ရှေ့ ၌ ထိုပလ္လင် ကို ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","အာရုန် သည် နံနက် တိုင်း မီးခွက် တို့ကို ပြင်သောအခါ၊ ထိုပလ္လင်ပေါ်မှာ မွှေး သော နံ့သာ ပေါင်းကို ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ညဦး ယံ၌ လည်း မီးခွက် တို့ကို ထွန်း သောအခါ ၊ ထိုပလ္လင်ပေါ်မှာ နံ့သာ ပေါင်းကို ရှို့ ရမည်။ ထိုသို့ သင် တို့သား စဉ်မြေးဆက်တို့သည် ထာဝရဘုရား ရှေ့ တော်၌ အစဉ်အမြဲ ပြုရသော နံ့သာပေါင်းရှို့ခြင်း ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ထိုပလ္လင် ပေါ် မှာ ထူးခြား သော နံ့သာ ပေါင်းကို မရှို့ရ။ မီးရှို့ သော ယဇ်ကို မပြုရ။ ဘောဇဉ်ပူဇော်သက္ကာ ကိုလည်း မပြုရ။ သွန်းလောင်း ရာ ပူဇော်သက္ကာကိုလည်း မ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","အာရုန် သည် တနှစ် တခါ အပြစ် ဖြေ ရာယဇ် ကောင်အသွေး ကိုယူ၍၊ ထိုပလ္လင် ၏ ဦးချို တို့၌ အပြစ် ဖြေခြင်း မင်္ဂလာကို ပြုရမည်။ သင် တို့သား စဉ်မြေးဆက်တို့သည် တနှစ် တခါ ထိုသို့ ပြုရ ကြမည်။ ထာဝရဘုရား အား အလွန်သန့်ရှင်း သော ယဇ်ပလ္လင်ဖြစ်သည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","ဣသရေလ အမျိုးသား တို့ကို ရေတွက် ၍ စာရင်းယူသောအခါ ၊ ဘေး လွတ် မည်အကြောင်းရှိသမျှတို့ သည် အသီးအသီးမိမိ အသက် ရွေးရန် အဘိုး ကို ထာဝရဘုရား အား ဆက်ကပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ရေတွက် ၍ စာရင်းဝင် သော သူအပေါင်း တို့သည် အကျပ် တော်အလိုက် ၊ ငွေအကျပ် တဝက် စီ ထာဝရဘုရား အား ဆက်ကပ် ရမည်။ အကျပ်ကား၊ ဂေရ နှစ်ဆယ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","အသက် နှစ်ဆယ် မှစ၍ ၊ ပိုလွန် သောသူ အပေါင်း တို့သည် စာရင်း ဝင်၍၊ ထိုသို့သော ပူဇော် သက္ကာကို ထာဝရဘုရား အားပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ကိုယ် အသက် ကို ရွေး ခြင်းငှါ ၊ ထာဝရဘုရား အား ပူဇော် သက္ကာကို ပြု သောအခါ၊ ငွေ ရတတ်သောသူတို့ သည် မ ပို ၊ ဆင်းရဲ သောသူတို့ သည် မ လျှော့ ဘဲ၊ လူတိုင်း အကျပ် တဝက် စီ ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ဣသရေလ အမျိုးသား တို့၏ အရွေး ငွေ ကို ယူ ၍ သူ တို့အသက် ကို ရွေး ခြင်းငှာ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ဣသရေလ အမျိုးသား တို့၏ သက်သေ ဖြစ် ရမည်အကြောင်း၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်စရိတ် အဘို့ အလိုငှာ ထား ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","အာရုန်နှင့် သူ၏သားတို့ လက်ခြေဆေး စရာဘို့ ကြေးဝါ ခြေထောက် ပါသောကြေးဝါ အင်တုံ ကို လုပ် ၍ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်နှင့် ယဇ်ပလ္လင် စပ်ကြား ၌ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","သူ တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ ဝင် သော် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","အမှုတော် ကို ထမ်း၍ ထာဝရဘုရား အား မီးရှို့ သောယဇ်ကို ပူဇော် ခြင်းငှာ ၊ ယဇ်ပလ္လင် အနားသို့ ချဉ်းကပ် သော် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","သေ ဘေးနှင့် ကင်းလွတ် မည်အကြောင်း ၊ မိမိတို့လက်ခြေကို ဆေး ရမည်။ ထိုသို့သူတို့နှင့် သူတို့အမျိုးအနွယ် အစဉ်အဆက်တို့သည် စောင့်ရသောပညတ်တော်ဖြစ်သတည်းဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူပြန်သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","သင် သည် မြတ်သောနံ့သာ မျိုးကို အကျပ်တော်နှင့်ချိန်လျက်၊ စင်ကြယ် သော မုရန် စေး အကျပ်ငါးရာ ၊ မွှေး သော သစ်ကြံပိုး နှစ်ရာ ငါးဆယ် ၊ မွှေး သောကြံ နှစ်ရာ ငါးဆယ် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","သစ်ကြံပိုး တမျိုးငါးရာ ၊ သံလွင် ဆီ တဟိန် ကို ယူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ဆေးသမားအတတ် နှင့် ဖယောင်း ဆီကို ဘော်တတ်သည်အတိုင်း၊ လိမ်း ရန်ဆီ တည်းဟူသောသန့်ရှင်း သော နံ့သာ ဆီကို ဘော် ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ပရိသတ်စည်းဝေး ရာ တဲ တော်နှင့် သက်သေခံ ချက်သေတ္တာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","စားပွဲ နှင့် စားပွဲတန်ဆာ ရှိသမျှ ကို၎င်း၊ မီးခုံ နှင့် မီးခုံတန်ဆာ ကို၎င်း ၊ နံ့သာ ပေါင်းရှို့သောပလ္လင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","မီးရှို့ ရာ ယဇ်ပူဇော်သောပလ္လင် နှင့် ပလ္လင်တန်ဆာ ရှိသမျှ ကို၎င်း ၊ အင်တုံ နှင့် အင်တုံခြေထောက် ကို၎င်း၊ ထိုနံ့သာ ဆီနှင့် လိမ်း သဖြင့် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ထို အရာတို့ကို အလွန်သန့်ရှင်း စေ ခြင်းငှာ ၊ ထိုသို့ သန့်ရှင်း စေရမည်။ ထို အရာတို့နှင့် တွေ့ သမျှသော အရာသည် သန့်ရှင်း သောအရာဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","အာရုန် နှင့် သူ ၏သား တို့ကို လိမ်း ၍ ၊ သူ တို့သည် ငါ့ ရှေ့ ၌ ယဇ်ပုရောဟိတ် အမှုကို ဆောင်စေခြင်းငှာ ၊ ယဇ်ပုရောဟိတ်အရာ၌ ခန့်ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင် တို့သား စဉ်မြေးဆက်အပေါင်းတို့၌ ဤဆီ သည်၊ ငါ့ အဘို့ သန့်ရှင်း သော လိမ်း ရန်ဆီ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","လူ ၏ကိုယ် ပေါ် မှာ မ လောင်း ရ။ ထိုဆီကို ဘော်သည်နည်းတူ ၊ အခြားသောဆီကို မ ဘော် ရ။ သန့်ရှင်းသည်ဖြစ်၍၊ သန့်ရှင်းသည်ဟု သင်တို့သည် မှတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ထိုဆီနှင့်တူ အောင် ဘော် သော သူ ၊ မ ဆိုင်သောလူ၌ လိမ်း သောသူ မည်သည်ကား၊ မိမိ အမျိုး မှ ပယ်ရှင်း ခြင်းကိုခံ ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့်တော်မူသည်ကား၊ မွှေးသော နံ့သာမျိုးတည်းဟူသောနတပ်စေး ၊ မွှေး သော ငါးခွံ ၊ ဂါလဗန် စေး၊ စင် သော လောဗန် စေးတို့ကို အညီအမျှ ချိန် ယူ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ဆေးသမားအတတ် နှင့် နှာဆေးကို ဘော်တတ်သည်နည်းတူရောနှော၍၊ သန့်ရှင်း စင်ကြယ် သော နံ့သာ ပေါင်းကို ဘော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","အချို့ ကိုလည်း ညက်ညက်ထောင်း ပြီးမှ ၊ ငါသည် သင် နှင့် တွေ့ ရာအရပ် ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်၌ သက်သေခံ ချက်ရှေ့ မှာ ထား ရမည်။ သင် တို့တွင် အလွန်သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ထိုသို့ သောနံ့သာ ပေါင်းကို ဘော် သည်နည်းတူ၊ အခြားသော နံ့သာပေါင်းကို ကိုယ် သုံးဘို့ မ ဘော် ရ။ သင် တို့တွင် ထာဝရဘုရား အဘို့ သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","အကြင် သူ သည် မိမိရှူ စရာဘို့ ထိုနံ့သာပေါင်း နှင့် တူ အောင်ဘော် ၏။ ထိုသူသည် မိမိ အမျိုး မှ ပယ်ရှင်း ခြင်းကိုခံ ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူပြန်သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","နားထောင် လော့၊ ငါသည် ယုဒ အမျိုးသား ဟုရ ၏သား ဖြစ်သော ဥရိ ၏သား ဗေဇလေလ ကို အမည် ဖြင့် ခန့် ထား၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","သူသည် ရွှေ ငွေ ကြေးဝါ ကိုလုပ် သောအတတ် ၊ ကျောက် ကိုသွေး ၍စီ သောအတတ်၊ သစ်သား ကိုထုလုပ် သောအတတ်နှင့် အမျိုးမျိုး သောအလုပ် ကို ထူးဆန်းစွာလုပ် တတ်မည် အကြောင်း၊ ဉာဏ်ပညာ နှင့်တကွ သိပ္ပံအတတ် အမျိုးမျိုး တို့ကို ငါပေး၍ ဘုရားသခင် ၏ဝိညာဉ် တော်နှင့် ပြည့်စုံ စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","သူနှင့်အတူ ဒန် အမျိုးသား အဟိသမက် ၏သား ၊ အဟောလျဘ ကိုလည်း ငါခန့် ထား၏။ ငါသည် သင့် အား မှာ ထားသမျှ တို့ကို လိမ္မာသောသူအပေါင်းတို့သည် လုပ် တတ်မည်အကြောင်း ၊ သူတို့နှလုံး ထဲသို့ ဉာဏ် ပညာကို ငါသွင်း ထားပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ထိုသူတို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်၊ သက်သေခံ ချက်သေတ္တာ ၊ သေတ္တာ အပေါ် မှာ တင်သော သေတ္တာအဖုံး ၊ တဲ တော်တန်ဆာ ရှိသမျှ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","စားပွဲ နှင့် စားပွဲတန်ဆာ ကို၎င်း ၊ စင်ကြယ် သော မီးခုံ နှင့် မီးခုံတန်ဆာ ရှိသမျှ ကို၎င်း၊ နံ့သာ ပေါင်း ရှို့သော ပလ္လင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","မီးရှို့ ရာယဇ်ပူဇော်သော ပလ္လင် တန်ဆာ ရှိသမျှ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","အမှုတော်ကို ထမ်းစရာအဝတ်၊ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်သောအခါ၊ ယဇ်ပုရောဟိတ် အာရုန် နှင့် သူ ၏သား ဝတ် ဘို့ သန့်ရှင်း သောအဝတ် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","လိမ်း စရာဆီ နှင့် သန့်ရှင်း ရာဌာန၌ သုံးဘို့ နံ့သာ ပေါင်းမွှေး ကို၎င်း၊ ငါမှာ ထားသမျှ အတိုင်း လုပ် ရကြမည် ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","တဖန် ထာဝရဘုရား က၊ သင် သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ငါ သည် သင် တို့ကို သန့်ရှင်း စေသော ထာဝရဘုရား ဖြစ်ကြောင်းကို သင်တို့သိ စေခြင်းငှါ ၊ ငါနှင့်သင် တို့၏ သား စဉ်မြေးဆက် စပ်ကြား ၌ လက္ခဏာ သက်သေဖြစ်ဘို့ ရာ၊ ငါ့ ဥပုသ် နေ့ကို စင်စစ် စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ဥပုသ် နေ့သည် သင် တို့အား သန့်ရှင်း သောကြောင့် ထိုနေ့ကို စောင့် ရကြမည်။ ဥပုသ် နေ့ကို ဖျက် သောသူတိုင်း အသေခံ ရမည်။ ထိုနေ့ ၌ အလုပ်လုပ် သော သူမည်သည်ကား၊ မိမိ အမျိုး မှ ပယ်ရှင်း ခြင်းကိုခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ခြောက် ရက် ပတ်လုံးအလုပ် လုပ် ရမည်။ သတ္တမ နေ့ သည် ထာဝရဘုရား အား သန့်ရှင်း ၍ ငြိမ် ရသောဥပုသ် နေ့ဖြစ်၏။ ဥပုသ် နေ့ ၌ အလုပ် လုပ် သောသူမည်သည်ကား၊ ဧကန်အမှန် အသေ ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","သို့ဖြစ်၍ ဣသရေလ အမျိုးသား အစဉ် အဆက်တို့သည်၊ ထာဝရ ပဋိညာဉ် ဖြစ်စေခြင်းငှါ ၊ ဥပုသ် နေ့ရက်အစဉ်အတိုင်းဥပုသ် စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ထိုသို့ စောင့်လျှင်၊ ငါ နှင့် ဣသရေလ အမျိုးသား စပ်ကြား ၌ ထာဝရ လက္ခဏာ သက်သေဖြစ်လိမ့်မည်။ အကြောင်း မူကား၊ ထာဝရဘုရား သည် မိုဃ်းကောင်းကင် နှင့် မြေကြီး ကို၊ ခြောက် ရက် တွင် ဖန်ဆင်း ၍ ၊ သတ္တမ နေ့ရက် ၌ ငြိမ်ဝပ် စွာ နေလျက် အားဖြည့်တော်မူသည်ဟု မောရှေအား မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ထိုသို့ ဘုရားသခင် သည် သိနာ တောင် ပေါ်မှာ မောရှေနှင့် နှုတ်ဆက်တော်မူသည်အဆုံး ၌၊ လက်ညှိုး တော်နှင့် အက္ခရာတင် သော သက်သေခံ ချက်၊ ကျောက် ပြား နှစ် ပြားကိုပေး တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","မောရှေ သည် တောင် ပေါ်မှာ ကြာမြင့် စွာ ရှိနေကြောင်းကို လူ များတို့သည် သိမြင် သောအခါ ၊ အာရုန် ထံသို့စည်းဝေး ကြ၍ ၊ ထ ပါ။ ငါ တို့ရှေ့ မှာ သွား ရသော ဘုရား တို့ကို ငါ တို့အဘို့ လုပ် ပါ။ ငါ တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်သော ထို မောရှေ ၌ အဘယ်သို့ ဖြစ် သည်ကို ငါတို့မ သိ ပါဟု ပြော ဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","အာရုန် ကလည်း ၊ သင် တို့မယား သား သမီး များ၏ နား ၌ ဆင်သော ရွှေ နားတောင်း များကို ချွတ် ၍ ၊ ငါ့ ထံသို့ ဆောင် ခဲ့ကြဟုဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","လူ အပေါင်း တို့သည် မိမိ တို့နား ၌ ဆင်သော ရွှေ နားတောင်း များကို ချွတ် ၍ ၊ အာရုန် ထံသို့ ဆောင် ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","အာရုန်သည်လည်း လက်ခံ ၍ ၊ နွား သငယ်ရုပ်ပုံသဏ္ဌာန်ကို ကညစ် နှင့် ရေးသား ပြီးလျှင် သွန်း လေ၏။ လူများတို့ကလည်း အို ဣသရေလ အမျိုး၊ ဤ ဘုရားသည် သင့်ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်သောသင် ၏ ဘုရား ဖြစ်တော်မူသည်ဟု ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","အာရုန် သည် ထိုအမှုကို သိမြင် လျှင် ၊ ရုပ်တု ရှေ့ မှာ ယဇ်ပလ္လင် ကို တည် ၍ ၊ နက်ဖြန် နေ့သည် ထာဝရဘုရား အဘို့ ပွဲခံ ရသောနေ့ဖြစ်သည်ဟု တပ်ကိုလည်၍ ကြော်ငြာ စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","နက်ဖြန် နံနက်စောစော လူ တို့သည် ထ၍ ၊ မီးရှို့ ရာယဇ်၊ မိဿဟာယ ယဇ်တို့ကို ပူဇော် ပြီးမှ ၊ စား သောက် လျက် ထိုင် နေကြ၏။ နောက်တဖန် ကခုန် မြူးထူးခြင်းငှါ ထ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ထာဝရဘုရား က၊ သင်သည် ဆင်း သွား လော့။ အဲဂုတ္တု ပြည် မှ သင်နှုတ် ဆောင်ခဲ့သော သင် ၏ လူ တို့သည် ဖေါက်ပြန် ကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ငါမှာ ထားသော လမ်း မှ အလျင်အမြန် လွှဲ သွား၍၊ နွားသငယ် ရုပ် ကို သွန်း ပြီးလျှင် ၊ အို ဣသရေလ အမျိုး၊ ဤ ဘုရားသည် သင့် ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်ခဲ့သော ဘုရား ဖြစ်တော်မူ၏ဟု ဆို လျက် ၊ ရုပ်တု ရှေ့ မှာ ယဇ်ပူဇော် ကိုးကွယ် ကြပြီဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ဤ လူမျိုး ကို ငါကြည့် မြင်ပြီ။ လည်ပင်း ခိုင်မာ သောအမျိုး ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","သို့ဖြစ်၍ ငါ့ ကို ရှိ စေတော့။ ငါသည် အမျက် ပြင်းစွာထွက်၍ သူ တို့ကို ဖျက်ဆီး မည်။ သင့် ကိုကား ကြီး သော အမျိုး ဖြစ် စေမည်ဟူ၍၎င်း၊ မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","မောရှေ ကလည်း ၊ အို ထာဝရဘုရား ၊ ကိုယ်တော်သည် မဟာ တန်ခိုး အားကြီး သော လက် နှင့် အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်ခဲ့သော ကိုယ်တော် ၏ လူ တို့ကို ၊ အဘယ် ကြောင့်အမျက် ပြင်းစွာထွက်တော်မူသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","အဲဂုတ္တု လူတို့ကလည်း၊ ဘုရားသခင် သည် မကောင်း သော အကြံရှိသဖြင့်၊ သူ တို့ကို တောတောင် များ၌ သတ် ၍ မြေကြီး ပေါ် က သုတ်သင် ပယ်ရှင်းခြင်း အလိုငှါ သာ၊ နှုတ် ဆောင်လေသည်ဟု အဘယ်ကြောင့် ဆို ဘွယ်အကြောင်းရှိရပါမည်နည်း။ ပြင်းစွာ သော အမျက် တော်ကို ပယ် တော်မူပါ။ ကိုယ်တော် ၏ လူ တို့၌ ဤသို့အပြစ် ပေးမည်အကြံကို နောင်တရ တော်မူပါ။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ကိုယ်တော်က သင် တို့အမျိုးအနွယ် ကို ကောင်းကင် ကြယ် ကဲ့သို့ ငါများပြား စေမည်။ ငါပြော ခဲ့သော ဤ မြေ ရှိသမျှ ကို သင် တို့အမျိုးအနွယ် အား ငါပေး သဖြင့် ၊ သူတို့သည် အစဉ်အမြဲ အမွေခံ ရကြလိမ့်မည်ဟု ကိုယ် ကို ကိုယ်တိုင်တည် ၍ ကျိန်ဆို တော်မူသောစကားကိုခံ ခဲ့ပြီးသော ကိုယ်တော် ၏ ကျွန် အာဗြဟံ ၊ ဣဇာက် ၊ ဣသရေလ တို့ကို အောက်မေ့ တော်မူပါဟု မိမိ ဘုရား သခင် ထာဝရဘုရား ရှေ့ တော်၌ တောင်းပန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ထာဝရဘုရား သည် မိမိ လူ တို့အား အပြစ် ပေးမည်အကြံကို နောင်တရ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","မောရှေ သည် သက်သေခံ ချက် ကျောက် ပြားနှစ် ပြားကို ကိုင် ယူလျက်၊ လှည့် ၍ တောင် ပေါ်က ဆင်း သွားလေ၏။ ထို ကျောက်ပြားနှစ် မျက်နှာ ၌ အက္ခရာတင် လျက် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ထိုကျောက်ပြားတို့သည် ဘုရား သခင် ဖန်ဆင်း တော်မူသောကျောက် ပြား၊ စာ သည်လည်း ဘုရား သခင်အက္ခရာ တင်တော်မူသောစာဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","လူ များ ကြွေးကြော် သံ ကို ယောရှု သည်ကြား လျှင် ၊ တပ် ၌ စစ်တိုက် သံ ကို ကြားပါသည်ဟု မောရှေ အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","မောရှေကလည်း၊ ငါ ကြား သော အသံသည် အောင် ၍ ကြွေးကြော် သံ မဟုတ် ၊ ရှုံး ၍ ငိုကြွေး သံ လည်း မဟုတ် ၊ သီချင်းဆို သံ ဖြစ်သတည်းဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","တပ် အနီးသို့ ရောက် သောအခါ ၊ နွား သငယ်ကို၎င်း ၊ ကခုန် ခြင်းကို၎င်းမြင် လျှင် ၊ မောရှေ သည် အမျက် ထွက် သဖြင့် ကျောက် ပြားတို့ကို ချ ၍ တောင် ခြေရင်း ၌ ချိုးဖဲ့ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","သူတို့လုပ် သော နွား သငယ်ကိုလည်း ယူ ၍ အရည်ကျို ၏။ ညက်ညက်ခြေ ပြီးမှ ရေ ပေါ် မှာ ဖြူး ၍ ဣသရေလ အမျိုးသား တို့ကို သောက် စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","အာရုန် ကို လည်း ခေါ်၍၊ သင်သည် သူတို့၌ ဤမျှလောက်ကြီး သော အပြစ် ကို ရောက် စေခြင်းငှါ သူ တို့သည် သင် ၌ အဘယ်သို့ ပြု သနည်းဟုမေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","အာရုန် က၊ သခင် ၊ အမျက် မ ထွက် ပါနှင့်။ ဤလူ တို့သည် မကောင်း သော အကြံရှိကြောင်းကို ကိုယ်တော်သိ ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","သူတို့ကလည်း ၊ ငါ တို့ရှေ့ မှာ သွား ရသော ဘုရား တို့ကို ငါ တို့အဘို့ လုပ် ပါ။ ငါ တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်ခဲ့သောသူ ၊ ထို မောရှေ ၌ အဘယ်သို့ ဖြစ် သည်ကို ငါတို့မ သိ ပါဟု အကျွန်ုပ် အား ပြော ဆိုကြလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","အကျွန်ုပ်က၊ ရွှေ ရှိသောသူ သည် ချွတ် စေဟုဆို သည်နှင့် အညီ၊ သူတို့ပေးသော ရွှေ ကို အကျွန်ုပ်သည် မီး ထဲ၌ ထည့် လျှင် ၊ ဤ နွား သငယ်ထွက် လာပါသည်ဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ထိုသို့ အာရုန် သည် လူ များကို ရန်သူတို့ ရှေ့မှောက်၌ အဝတ်တန်ဆာကို ချွတ် စေသည်ဖြစ်၍ ၊ အဝတ်တန်ဆာအချည်းစည်း ရှိကြကြောင်း ကို မောရှေ မြင် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","တပ် တံခါးဝ မှာ ရပ် လျက် ၊ ထာဝရဘုရား ဘက် ၌ အဘယ်သူ နေသနည်း။ ငါ့ ထံသို့ လာစေဟုဆို လျှင် ၊ လေဝိ အမျိုးသား အပေါင်း တို့သည် သူ့ ထံ ၌ စည်းဝေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","မောရှေကလည်း၊ လူတိုင်း ထား လွယ် လျက် တပ် တမျက်နှာတံခါးမှ တမျက်နှာတံခါးတိုင်အောင်ထုတ်ချင်းခပ်သွား ၍ ၊ အသီးအသီး မိမိ ညီအစ်ကို ၊ မိမိ အပေါင်း အဘော်၊ မိမိ အိမ်နီးချင်း ကိုသတ် စေဟု ဣသရေလ အမျိုး၏ ဘုရား သခင်ထာဝရဘုရား အမိန့် ရှိတော်မူသည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","မောရှေ စီရင် သည်အတိုင်း ၊ လေဝိ အမျိုးသား တို့သည် ပြု ၍ ၊ ထိုနေ့ ၌ လူ သုံး ထောင် လောက် သေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","တဖန် မောရှေ က၊ ထာဝရဘုရား သည် ယနေ့ ကောင်းကြီး ပေး တော်မူစေခြင်းငှါ ၊ သင်တို့သည် အသီးအသီး ကိုယ်သား ၊ ကိုယ် ညီအစ်ကို ကို ထိခိုက်သောအားဖြင့်၊ သင်တို့ သည် ယနေ့ ကိုယ်ကို ချီးမြှောက် ကြ ပြီးဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","နက်ဖြန် နေ့၌ လည်း ၊ သင် တို့ပြစ်မှား သော အပြစ် ကြီး လှ၏။ ယခု မှာ ထာဝရဘုရား အထံ တော်သို့ ငါတက် သွား၍၊ သင်တို့ အပြစ် ဖြေ နိုင်လျှင် ဖြေစေခြင်းငှါ ပြုမည်ဟု မောရှေ သည် လူ များတို့အား ဆို ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ထာဝရဘုရား အထံ တော်သို့ ပြန် သွား၍ ၊ အို ဘုရားသခင်၊ ဤ လူ တို့သည် ပြစ်မှား သော အပြစ် ကြီး လှပါ၏။ မိမိ တို့အဘို့ ရွှေ ဘုရား ကို လုပ် ပါပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","သို့ သော်လည်းသူ တို့အပြစ် ကို လွှတ်ခြင်းငှါအလို တော်ရှိလျှင် လွှတ် တော်မူပါ။ သို့မဟုတ် ၊ ကိုယ်တော် စီရင် တော်မူသော စာရင်း ၌ အကျွန်ုပ် နာမကို ချေ တော်မူပါ။ အကျွန်ုပ် တောင်းပန်ပါ၏ဟု လျှောက်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ထာဝရဘုရား က၊ အကြင်သူ သည် ငါ့ ကို ပြစ်မှား ၏၊ ထိုသူ ၏ နာမကို ငါ့ စာရင်း ၌ ငါချေ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","သို့ဖြစ်၍ငါမှာ ထားသောအရပ် သို့ သူ တို့ကို ယခု သွား ၍ ပို့ဆောင် လော့။ ငါ့ တမန် သည် သင့် ရှေ့ မှာ သွား လိမ့်မည်။ သို့ သော်လည်းငါ သည် အကြည့် အရှုကြွလာသောအခါ ၊ သူ တို့၌ အပြစ် ပေးလျက် ကြွလာမည်ကို မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","အာရုန် နှင့် လူများ တို့သည် နွားသငယ် ကို လုပ် ကြသောကြောင့် သူ တို့ကို ဒဏ်ခတ်တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","တဖန် ထာဝရဘုရား က၊ သင် မှစ၍ အဲဂုတ္တု ပြည် မှ သင်နှုတ် ဆောင်ခဲ့သော လူ တို့၊ ဤ အရပ်မှ ထွက် ၍ သင် ၏ အမျိုးအနွယ် အား ငါပေး မည်ဟု အာဗြဟံ ၊ ဣဇာက် ၊ ယာကုပ် ၌ ငါကျိန်ဆို သော ပြည် သို့ သွား ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ကောင်းကင်တမန် ကိုလည်း သင် တို့ရှေ့ သို့ ငါစေလွှတ် ၍ ၊ သူသည်ခါနနိ လူ၊ အာမောရိ လူ၊ ဟိတ္တိ လူ၊ ဖေရဇိ လူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့ကို နှင်ထုတ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","နို့ နှင့် ပျားရည် စီး သော ပြည် သို့ သင်တို့ကို ပို့ဆောင်လိမ့်မည်။ သင်တို့နှင့်အတူ ငါကိုယ်တိုင် မ သွား။ သင် တို့သည် လည်ပင်း ခိုင်မာ သောလူမျိုး ဖြစ်သောကြောင့် ၊ လမ်း ၌ သွားစဉ် သင် တို့ကို ငါဖျက်ဆီး မည် စိုးရိမ် စရာရှိသည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ထို မကောင်း သော သိတင်း ကို လူ များတို့သည်ကြား သောအခါ ၊ ငိုကြွေး မြည်တမ်းလျက် ၊ အဘယ်သူမျှ တန်ဆာ မ ဆင် ဘဲနေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","အကြောင်း မူကား၊ ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား ကို ဆင့်ဆို ရမည်မှာ၊ သင် တို့သည် လည်ပင်း ခိုင်မာ သော အမျိုး ဖြစ်ကြ၏။ သင်တို့အလယ် ၌ ချက်ချင်း ငါပေါ်လာ ၍ ဖျက်ဆီး မည်။ ထို့ကြောင့်သင် တို့၌ အဘယ်သို့ ငါပြု ရမည်ကို ငါသိ ခြင်းငှါ၊ သင် တို့တန်ဆာ များကို ချွတ် ကြလော့ဟု မောရှေ အား မိန့် တော်မူနှင့်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ဣသရေလ အမျိုးသား တို့သည် ဟောရပ် တောင် ခြေရင်း၌ မိမိ တို့တန်ဆာ များကိုချွတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","မောရှေ သည် တဲ တော်ကို ယူ ၍ တပ် ပြင် ၌ ခပ်ဝေး ဝေးဆောက် ပြီးလျှင် ၊ ပရိသတ် စည်းဝေး ရာတဲ ဟူ၍ ခေါ် ဝေါ်၏။ ထာဝရဘုရား ကို ရှာ သောသူ အပေါင်း တို့သည် တပ် ပြင် ၌ ရှိသော ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ ထွက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","မောရှေ သည် တဲ တော်သို့ ထွက်သွား သောအခါ ၊ လူ အပေါင်း တို့သည် ထ ၍ အသီးအသီး မိမိ တို့တဲ တံခါး ဝ၌ ရပ် လျက် တဲ တော်အထဲ သို့ မောရှေ ဝင် သည် တိုင်အောင် ကြည့် ရှုလျက်နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","မောရှေ သည်တဲ တော်အထဲသို့ ဝင်ပြီးမှ၊ မိုဃ်းတိမ် တိုင် ဆင်းသက် ၍ တဲ တော်တံခါးဝ ၌ ရပ် သဖြင့် ၊ ထာဝရဘုရားသည် မောရှေ နှင့် နှုတ်ဆက် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","တဲ တော်တံခါးဝ ၌ မိုဃ်းတိမ် တိုင် ရပ် နေသည်ကို မြင် လျှင် ၊ လူ အပေါင်း တို့သည် ထ ၍ အသီးအသီး မိမိ တို့တဲ တံခါးဝ ၌ ကိုးကွယ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ထာဝရဘုရား သည် အဆွေ ခင်ပွန်းချင်းကို နှုတ်ဆက် တတ်သည် နည်းတူ ၊ မောရှေနှင့် မျက်နှာ ချင်းဆိုင် ၍ နှုတ်ဆက် တော်မူ၏။ မောရှေ သည် တပ် ထဲသို့ ပြန်ဝင် သောအခါ သူ ၏လက်ထောက် နုန် ၏သား ယောရှု မည်သော လုလင် သည်၊ တဲ တော်မှ မ ထွက် ဘဲ နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","မောရှေ ကလည်း ၊ ဤ လူ တို့ကို ပို့ဆောင် လော့ဟု ကိုယ်တော် မိန့် တော်မူသည်တွင်၊ အကျွန်ုပ် နှင့်အတူ အဘယ်သူ ကို စေလွှတ် တော်မူသည်ကို အကျွန်ုပ် မ သိ ရ။ သို့သော် လည်းကိုယ်တော် က သင့် ကို သင်၏နာမ ဖြင့် ငါသိ ၏။ သင်သည် ငါ့ ရှေ့ ၌ မျက်နှာ ရပြီဟု အကျွန်ုပ်အား မိန့် တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","သို့ဖြစ်၍ အကျွန်ုပ်သည် ရှေ့ တော်၌ မျက်နှာ ရ လျှင် ၊ မျက်နှာ ရကြောင်းကို အကျွန်ုပ်သိ ပါမည် အကြောင်း ၊ ကိုယ်တော် ၏လမ်း ကိုပြ တော်မူပါ။ ဤ လူမျိုး သည် ကိုယ်တော် ၏လူ ဖြစ်ကြောင်း ကို ဆင်ခြင် တော်မူ ပါ၊ အကျွန်ုပ်တောင်းပန်ပါ၏ဟု ထာဝရဘုရား အား လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ငါကိုယ်တိုင်သွား ၍ ငြိမ်ဝပ် ခြင်းချမ်းသာကို ပေးမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","တဖန် မောရှေ က၊ ကိုယ်တော် တိုင် မ သွား လျှင် အကျွန်ုပ် တို့ကို ဤ အရပ်မှ ပို့ တော်မ မူပါနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","အကျွန်ုပ် နှင့် ကိုယ်တော် ၏လူ တို့သည် ရှေ့ တော်၌ မျက်နှာ ရသောအကြောင်း သည် အဘယ် သို့ထင်ရှား ပါမည်နည်း။ အကျွန်ုပ် တို့နှင့် ကြွ သွားတော်မူသောအားဖြင့် သာ ထင်ရှားပါမည် မဟုတ် လော။ ထိုသို့ အကျွန်ုပ် နှင့် ကိုယ်တော် ၏လူ တို့သည် မြေကြီး ပေါ် မှာ ရှိသမျှ သော လူ တို့နှင့် ခြားနား ရပါမည်ဟု လျှောက်ဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ထာဝရဘုရား က၊ သင်လျှောက် သည်အတိုင်း ငါပြု မည်။ သင်သည် ငါ့ ရှေ့ ၌ မျက်နှာ ရပြီ။ သင့် ကို သင်၏နာမ ဖြင့် ငါသိ ၏ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","တဖန် တုံ၊ ကိုယ်တော် ၏ ဘုန်း ကိုအကျွန်ုပ် အား ပြ တော်မူပါ၏။ အကျွန်ုပ်တောင်းပန်ပါ၏ဟု လျှောက် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ထာဝရဘုရားက ငါ ၏ကောင်းမွန် ခြင်းရှိသမျှ ကို သင့် ရှေ့ ၌ ငါ ရှောက် သွားစေမည်။ ထာဝရဘုရား ၏နာမ တော်ကိုလည်း၊ သင့် ရှေ့ ၌ ငါကြွေးကြော် မည်။ ငါသည် ကျေးဇူး ပြုလိုသောသူ ကို ကျေးဇူး ပြုမည်။ သနား လိုသောသူ ကိုလည်း သနား မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","သို့ရာတွင်သင်သည် ငါ့ မျက်နှာ ကို မ မြင် နိုင် ရာ။ ငါ့မျက်နှာကို မြင် လျှင် အသက်ရှင် ရသောလူ တစုံ တယောက်မျှမရှိ ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ငါ့ အနား မှာ နေရာ တခုရှိ၏။ သင်သည်ကျောက် ပေါ် မှာ ရပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ငါ့ ဘုန်း ရှောက် သွားသောအခါ ၊ သင့် ကို ကျောက် ကြား ၌ ငါသွင်း ထား၍ ငါ ကြွ သွားသည်အခိုက်၊ သင့် ကို ငါ့ လက် နှင့် ဖုံးအုပ် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ငါ လက် ကို သိမ်း ရုပ်သောအခါ ၊ ငါ့ ကျော ကိုသာ မြင် ရမည်၊ ငါ့ မျက်နှာ ကိုမ မြင် ရဟူ၍၎င်း မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","တဖန် ထာဝရဘုရား က၊ အရင် ကျောက်ပြားနှစ်ပြားနှင့်တူ အောင် ကျောက် ပြားနှစ် ပြားကို ခုတ် လော့။ သင်ချိုးဖဲ့ သော အရင် ကျောက် ပြား၌ စကား ပါ သည်အတိုင်း နောက်ကျောက် ပြားပေါ် မှာ ငါရေး ထားမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","နက်ဖြန်နံနက် သင်သည် အသင့် နေလျက်၊ သိနာ တောင် ပေါ် သို့ တက် ၍ တောင် ထိပ် ၌ ငါ့ ရှေ့ မှာကိုယ်ကို ပြ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","သင် နှင့်အတူ အဘယ်သူမျှမ တက် ရ။ တောင် တပြင်လုံး ၌ လူ ကို မ ထင်ရှား စေနှင့်။ တောင် ခြေရင်း ၌ သိုး နွား တို့ကို ကျက်စား ရာမ ပြုစေနှင့်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ အရင် ကျောက် ပြားနှင့်တူ အောင် ကျောက်ပြားနှစ် ပြားကို ခုတ် ပြီးမှ ၊ မောရှေ သည် နံနက် စောစောထ ၍ ထိုကျောက် ပြားနှစ် ပြားကို ကိုင် လျက် ၊ သိနာ တောင် ပေါ် သို့ တက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ထာဝရဘုရား သည် မိုဃ်းတိမ် ဖြင့် ဆင်းသက် ၍ ၊ ထို အရပ်၌ မောရှေ အနား မှာရပ် လျက်၊ ထာဝရဘုရား ၏နာမ တော်ကို ကြွေးကြော် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ထာဝရဘုရား သည် မောရှေ ရှေ့ ၌ ကြွ သွားတော်မူလျက် ၊ ထာဝရဘုရား ၊ ထာဝရဘုရား ၊ ချစ် သနားခြင်း မေတ္တာ ကရုဏာနှင့်ပြည့်စုံ၍ စိတ်ရှည် ခြင်း၊ ကျေးဇူး ပြုခြင်း၊ သစ္စာ စောင့်ခြင်းနှင့် ကြွယ်ဝ တော်မူထသော၊ ");
INSERT INTO myajvb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","အထောင် အသောင်းများသောသူတို့အား သနားခြင်းကျေးဇူး တရားကို စောင့် တော်မူထသော၊ အဓမ္မ ကျင့်ခြင်း၊ တရားတော်ကို လွန်ကျူး ခြင်း၊ ပြစ်မှားခြင်းအပြစ် တို့ကို ဖြေလွှတ် သော်လည်း ၊ အချည်းနှီးသက်သက်ဖြေလွှတ် တော်မ မူထသော၊ သားစဉ်မြေးဆက်၊ တတိယအဆက်၊ စတုတ္ထအဆက်တိုင်အောင်၊ အဘ တို့၏ အပြစ် ကိုသား တို့၌ ဆပ်ပေး စီရင်တော်မူသောဘုရား သခင်ဟု ကြွေးကြော် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","မောရှေ သည် အလျင်အမြန် ဦး ညွှတ်ချ၍ ကိုးကွယ် လျက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","အိုဘုရားရှင် ၊ အကျွန်ုပ်သည် ရှေ့ တော်၌ မျက်နှာ ရ လျှင် ၊ အကျွန်ုပ်အရှင် သည် အကျွန်ုပ် တို့နှင့်အတူ ကြွ တော်မူပါစေသော၊ အကျွန်ုပ်တောင်းပန် ပါ၏။ ဤ လူမျိုးသည် လည်ပင်း ခိုင်မာ သော အမျိုး ဖြစ်သော်လည်း ၊ အကျွန်ုပ် တို့ပြစ်မှားမိသော ဒုစရိုက် အပြစ် များကို လွှတ် ၍ အကျွန်ုပ် တို့ကို ကိုယ်တော်အမွေ ဥစ္စာဘို့ သိမ်းယူတော်မူပါဟုလျှောက် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ထာဝရဘုရားက၊ ကြည့်ရှု လော့။ ငါ ပဋိညာဉ် ပြု ၏။ မြေကြီး ပေါ်မှာ လူမျိုး ၌ မ ပြု စဖူးသော အံ့ဘွယ် သောအမှုတို့ကို သင် ၏လူမျိုး ရှေ့ မှာ ငါပြု မည်။ သင် တို့အဘို့ ငါ ထာဝရဘုရား ပြု ရသော အမှုသည် ကြောက်မက် ဘွယ်သောအမှု ဖြစ်ကြောင်း ကို သင် ပေါင်းဘော် သော လူ အပေါင်း တို့သည် မြင် ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ယနေ့ ငါ မှာ ထားသော စကားကို မှတ် လော့။ သင့် ရှေ့ မှာ အာမောရိ လူ၊ ခါနနိ လူ၊ ဟိတ္တိ လူ၊ ဖေရဇိ လူ၊ ဟိဝိ လူ၊ ယေဗုသိ လူတို့ကို ငါ နှင်ထုတ် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","သင် သည် ယခုသွားသော ပြည်သူ ပြည်သားတို့နှင့် မိဿဟာယ ဖွဲ့ သဖြင့်၊ သင့် အလယ်၌ တိုက်မိ၍ လဲစရာ အကြောင်းမ ဖြစ် စေခြင်းငှာ ၊ ကိုယ်ကိုကိုယ်သတိ ပြုလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","သူ တို့ယဇ်ပလ္လင် များကို ဖျက်ဆီး ရမည်။ သူ တို့ရုပ်တု ဆင်းတုများကို ချိုးဖဲ့ ရမည်။ သူ တို့ အာရှရ ပင် များကို ခုတ် လှဲရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","အခြား သောဘုရား ကို သင်သည် မ ကိုးကွယ် ရ။ အပြစ် ရှိယုံလွယ်အမည် ရှိသောထာဝရဘုရား သည် အပြစ်ရှိသည်ဟု ယုံ လွယ်သော ဘုရား သခင်ဖြစ်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","သင်သည် ထိုပြည်သူ ပြည်သားတို့နှင့် မိဿ ဟာယဖွဲ့ သဖြင့်၊ သူတို့သည် မိမိ တို့ဘုရား နှင့် မှားယွင်း ခြင်းကို ပြု၍ ၊ ထိုဘုရား တို့အား ယဇ် ပူဇော်သောအခါ၊ သင့် ကို ခေါ် ၍ သင်သည် ထိုယဇ် ကောင်ကို စား မည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","သင်သည် သူ တို့ သမီး များကိုယူ ၍၊ ကိုယ် သား တို့နှင့် ထိမ်းမြားပေးစားသဖြင့်၊ ထိုသမီး တို့သည် မိမိ တို့ ဘုရား နှင့် မှားယွင်း ခြင်းကို ပြု၍ သင် ၏သား တို့ကို ထိုဘုရား တို့နှင့် မှားယွင်း စေမည်ဟူ၍၎င်း စိုးရိမ်စရာ ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","သင်သည် ကိုယ် အဘို့ သွန်း သော ဘုရား တို့ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","သင်သည် အဗိဗ လ ၌ အဲဂုတ္တု ပြည်မှ ထွက် သောကြောင့် ၊ ငါပညတ် သည်အတိုင်း ၊ အဗိဗ လ တွင် ခုနစ် ရက် ပတ်လုံးတဆေး မဲ့မုန့်ကို စား ၍ အဇုမ ပွဲကို ခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","သားဦး အပေါင်း တို့သည် ငါ့ ဥစ္စာဖြစ်ကြ၏။ သင် ၏တိရစ္ဆာန် တို့တွင်လည်း ၊ နွား ဖြစ်စေ ၊ သိုး ဖြစ်စေ၊ သားဦး အပေါင်း တို့သည် ငါ့ဥစ္စာဖြစ်ကြ၏။ သို့ရာတွင် ၊ မြည်း သားဦး ကို သိုး သငယ်နှင့် ရွေး ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","မ ရွေး လိုလျှင် ၊ မြည်း သငယ်၏လည်ပင်းကို ချိုး ရမည်။ သင် ၏သားဦး အပေါင်း တို့ကို ရွေး ရမည်။ ငါ့ ထံသို့ အဘယ်သူမျှလက်ချည်း မ ပေါ် မလာရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ခြောက် ရက် ပတ်လုံးအလုပ်လုပ် ရမည်။ သတ္တမ နေ့ရက် ၌ ငြိမ်ဝပ် စွာ နေရမည်။ လယ် လုပ်ရာ ကာလ၊ အသီးအနှံ သိမ်းရာကာလဖြစ်သော်လည်း၊ သတ္တမနေ့ရက်၌ ငြိမ်ဝပ် စွာ နေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ဂျုံ စပါးကို သိမ်း စရှိသည်ကာလခုနစ်သိတင်း ပွဲ ကို၎င်း၊ နှစ် လဲ သောအခါ သိုထား ပွဲ ကို၎င်း ခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","သင် တို့အမျိုးသား ယောက်ျားအပေါင်း တို့သည်၊ ဣသရေလ အမျိုး၏ ဘုရား သခင်တည်းဟူသောထာဝရ အရှင်ဘုရား သခင့် ရှေ့ တော်၌ တနှစ် လျှင် သုံး ကြိမ် မျက်နှာပြ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","တပါးအမျိုးသား များကို သင် တို့ရှေ့ က ငါနှင်ထုတ် ၍ ၊ သင် တို့နေရာနယ် ကို ငါ ကျယ် စေမည်။ သင် ၏ ဘုရား သခင်ထာဝရဘုရား ရှေ့ တော်၌ တနှစ် တွင် သုံး ကြိမ် မျက်နှာပြ သွား သောအခါ ၊ သင် ၏မြေ ကို အဘယ်သူ မျှမ တပ်မက် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ငါ့ ယဇ်ကောင် အသွေး ကို တဆေး နှင့် ရော၍ မ ပူဇော် ရ။ ပသခါ ပွဲ ယဇ်ကောင် ကို၊ နံနက် တိုင်အောင် မ ကြွင်း စေရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","သင် ၏မြေ ၌ အဦး သီးသော အသီးအနှံအကောင်းဆုံး ကို သင် ၏ ဘုရား သခင်ထာဝရဘုရား ၏ အိမ် တော်ထဲသို့ ဆောင် သွင်းရမည်။ ဆိတ် သငယ်ကို အမိ နို့ ရည်နှင့် မ ပြုတ် မချက်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ဤ စကား များကို ရေး ထားလော့။ ဤ စကား များလာသည် အတိုင်း သင် မှစ၍ ဣသရေလ အမျိုးနှင့် ငါပဋိညာဉ် ပြု သည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ထို အရပ်မှာ မောရှေသည် အစာ ကို မ စား ၊ ရေ ကို မ သောက် ဘဲ ၊ အရက် လေးဆယ် ပတ်လုံးထာဝရဘုရား အထံတော်၌ နေ လေ၏။ ကျောက် ပြားပေါ် မှာ ပဋိညာဉ် စကား ၊ ပညတ် တော်ဆယ် ပါးကို ရေး ထားတော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","မောရှေ သည် သက်သေခံ ချက် ကျောက် ပြားနှစ် ပြားကို ကိုင် လျက်၊ သိနာ တောင် ပေါ်မှ ဆင်းသက် သောအခါ ၊ မိမိ နှင့် ဘုရား သခင်နှုတ်ဆက် တော်မူသောကြောင့် ၊ မိမိ မျက်နှာ အရေ ထွန်းပ ကြောင်း ကို မိမိမ သိ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","အာရုန် နှင့် ဣသရေလ အမျိုးသား အပေါင်း တို့သည်၊ မောရှေ ကို မြင် သောအခါ ၊ သူ ၏မျက်နှာ အရေ ထွန်းပ သောကြောင့် ၊ သူတို့သည် မချဉ်း မ ကပ်ဝံ့ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","မောရှေ သည် သူ တို့ကို ခေါ် ၍ ၊ အာရုန် နှင့် ပရိသတ် သူကြီး တို့သည် ချဉ်းကပ် ကြလျှင် ၊ မောရှေ သည် နှုတ်ဆက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ထိုနောက် ဣသရေလ အမျိုးသား အပေါင်း တို့သည် ချဉ်းကပ် ကြလျှင် ၊ သိနာ တောင် ပေါ် မှာ ထာဝရဘုရား မိန့် တော်မူသမျှ တို့ကို သူ တို့အား ဆင့်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","မောရှေ သည် သူ တို့အား ဟောပြော ၍ မပြီး မှီ မိမိ မျက်နှာ ကို ဖုံးအုပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ထာဝရဘုရား ရှေ့ တော်သို့ ဝင် ၍လျှောက်သောအခါ ၊ မ ထွက် မှီတိုင်အောင်မျက်နှာဖုံး ကို ချွတ် ထား၏။ တဖန် ထွက် ၍ အမိန့် တော်ကို ဣသရေလ အမျိုးသားတို့အား ဆင့်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","သူ ၏မျက်နှာ အရေ ထွန်းပ ကြောင်း ကို ဣသရေလ အမျိုးသား တို့သည် မြင် ကြလျှင် ၊ တဖန် အထဲသို့ ဝင်၍ မ လျှောက် မှီတိုင်အောင်မိမိ မျက်နှာ ကို ဖုံးအုပ် ပြန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","မောရှေ သည်၊ ဣသရေလ အမျိုး ပရိသတ် အပေါင်း ကို စည်းဝေး စေ၍ ၊ ထာဝရဘုရား မိန့် တော်မူသော သင်တို့ကျင့်ဝတ်တရားဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ခြောက် ရက် ပတ်လုံးအလုပ် လုပ် ရမည်။ သတ္တမ နေ့ ရက်သည် သင် တို့၌ သန့်ရှင်း သောနေ့၊ ထာဝရဘုရား အဘို့ ငြိမ်ဝပ် စွာ နေရသော ဥပုသ် နေ့ဖြစ် ၏။ ထိုနေ့ ၌ အလုပ် လုပ် သော သူ မည်သည်ကား အသေ ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","သင် တို့နေရာ အရပ်၌ ဥပုသ် နေ့ မှာ မီး ကို မ မွေး ရဟု ဆင့်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","တဖန် မောရှေ သည်၊ ဣသရေလ အမျိုးသား ပရိသတ် အလယ်၌ ထာဝရဘုရား ၏အမိန့် တော်ကို ဆင့်ဆို သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","သင် တို့တွင် ထာဝရဘုရား အား လှူသော အလှူ ကို ပြင်ဆင် ကြလော့။ ကြည်ညို သော စေတနာစိတ် ရှိသမျှ သောသူတို့ သည်၊ ရွှေ ၊ ငွေ ၊ ကြေးဝါ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ပြာ သော အထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ၊ ဆိတ် မွေး၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","အနီ ဆိုးသောသိုး ရေ ၊ တဟာရှ သားရေ ၊ အကာရှ သစ် သား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","လိမ်း ရန် ဆီ ဘော်ဘို့ ၊ မီးရှို့ရာနံ့သာ ပေါင်း မွှေး ဘော်ဘို့ ရာနံ့သာ မျိုး၊ မီး ထွန်းစရာဆီ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ရှဟံ ကျောက် ၊ ယဇ်ပုရောဟိတ်သင်တိုင်း နှင့် ရင်ဖွဲ့ ၌ စီ စရာကျောက် မြတ်တည်းဟူသောထာဝရဘုရား အား လှူ သောအလှူကို ဆောင် ခဲ့ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","သင် တို့တွင် လိမ္မာ သောသူ ရှိသမျှ တို့သည်လာ ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","တဲ တော်နှင့် အပေါ်တဲ ၊ အပေါ်တဲအဖုံး ၊ ရွှေချောင်း ၊ ပျဉ်ပြား ၊ ကန့်လန့်ကျင် ၊ တိုင် ၊ ခြေစွပ် တို့ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","သေတ္တာ နှင့် သူ ၏ထမ်းဘိုး ၊ သေတ္တာအဖုံး ၊ ကာ ရသော ကုလားကာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","စားပွဲ နှင့် သူ ၏ထမ်းဘိုး ၊ သူ ၏တန်ဆာ ရှိသမျှ နှင့် ရှေ့ တော်မုန့် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","မီး ထွန်းစရာဘို့ မီးခုံ နှင့် သူ ၏တန်ဆာ ၊ မီးခွက် များ၊ မီး ထွန်းစရာဆီ ကို၎င်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","နံ့သာ ပေါင်းရှို့သော ပလ္လင် နှင့် သူ ၏ထမ်းဘိုး ၊ လိမ်း ရန်ဆီ ၊ မွှေး သော နံ့သာ ပေါင်း၊ တဲ တော်တံခါး ဝ ကာရန် ကုလားကာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","မီးရှို့ ရာယဇ်ပူဇော်သော ပလ္လင် နှင့် ကြေးဝါ ဆန်ခါ ၊ ထမ်းဘိုး ၊ တန်ဆာ ရှိသမျှ ၊ အင်တုံ နှင့် ခြေထောက် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","တဲတော်ဝင်း ကုလားကာ ၊ တိုင် ၊ ခြေစွပ် ၊ ဝင်း တံခါးဝ ကာစရာ ကုလားကာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","တဲ တော်တံသင် ၊ ဝင်း တံသင် ကြိုး များကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","သန့်ရှင်း ရာဌာန၌ အမှုတော်ကို ထမ်း စရာအဝတ် ၊ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်သောအခါ၊ ယဇ်ပုရောဟိတ် အာရုန် နှင့် သူ ၏သား ဝတ်၍ သန့်ရှင်း သော အဝတ် ကို၎င်း၊ ထာဝရဘုရား မှာ ထားတော်မူသမျှ အတိုင်း လုပ် ရကြမည်ဟု ဆင့်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့သည်၊ မောရှေ ထံ မှ ထွက်သွား ကြ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","မိမိ စိတ်နှလုံး နှိုးဆော် သော သူ ၊ ကြည်ညိုသောစေတနာစိတ် သဘောရှိသော သူ အပေါင်း တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်လုပ် ဘို့ ၎င်း ၊ အမှု တော်ထမ်းစရာဘို့ ၎င်း၊ သန့်ရှင်း သောအဝတ် ကို၎င်း၊ ထာဝရဘုရား အား လှူသောအလှူ ကို ဆောင် လျက် လာကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ကြည်ညိုသော စေတနာ စိတ် ရှိသောယောက်ျား မိန်းမ တို့သည်၊ လက်ကောက် ၊ နားတောင်း ၊ လက်စွပ် ၊ နှာခေါင်းဘူး၊ ရွှေ တန်ဆာ ရှိသမျှ ကို ဆောင် ခဲ့သဖြင့် ၊ လှူ သောသူ အသီးအသီး တို့သည်၊ ထာဝရဘုရား အား ရွှေ ကို လှူကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ၊ ဆိတ် မွေး၊ အနီ ဆိုးသောသိုး ရေ ၊ တဟာရှ သားရေ ရှိ သော သူ တိုင်း ဆောင် ခဲ့၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ငွေ နှင့် ကြေးဝါ ကို လှူ သောသူတိုင်း ထာဝရဘုရား အား လှူ လေ၏။ အမှုတော်နှင့်ယှဉ်သော အလုပ် လုပ်စရာဘို့ အကာရှ သစ် သားရှိ သော သူတိုင်း လည်း ဆောင် ခဲ့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ရက်ကန်းတတ် သော မိန်းမ အပေါင်း တို့လည်း ၊ ကိုယ် လက် နှင့် ရက် ၍ ၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ရက် သမျှကို ဆောင် ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","မိမိ ဉာဏ် နှိုးဆော် သော မိန်းမ အပေါင်း တို့သည် ဆိတ် မွေးကို ရက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","သူကြီး တို့သည်လည်း ၊ ရှဟံ ကျောက် ၊ ယဇ်ပုရောဟိတ်သင်တိုင်း နှင့် ရင်ဖွဲ့ ၌ စီ စရာကျောက် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","မီး ထွန်းစရာဘို့ လိမ်း ရန် ဆီ ဘော်ဘို့ မီးရှို့ရာ နံ့သာ ပေါင်းမွှေး ဘော်ဘို့ ရာနံ့သာ မျိုးနှင့် ဆီ ကို၎င်း ဆောင်ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ထိုသို့ ထာဝရဘုရား သည် မောရှေ အားဖြင့် မှာ ထားတော်မူသော အလုပ် အမျိုးမျိုး ရှိသမျှအဘို့ ၊ ဣသရေလ အမျိုးသား တို့တွင် ကြည်ညိုသော စေတနာစိတ် နှိုးဆော် သော ယောက်ျား မိန်းမ အပေါင်း တို့သည်၊ ထာဝရဘုရား အား ကြည်ညို သောစိတ် နှင့် လှူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","တဖန် မောရှေ က၊ နားထောင် ကြလော့။ ထာဝရဘုရား သည် ယုဒ အမျိုးသား ဟုရ ၏သား ဖြစ်သော ဥရိ ၏သား ဗေဇလေလ ကို အမည် ဖြင့် ခန့် ထားတော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","သူသည် ရွှေ ငွေ ကြေးဝါ ကိုလုပ် သောအတတ် ၊ ကျောက် ကိုသွေး ၍စီ သောအတတ်၊ သစ်သား ကိုထုလုပ် သောအတတ်နှင့်အမျိုးမျိုး သောအလုပ်ကို ထူးဆန်းစွာလုပ်တတ်မည်အကြောင်း၊ ဉာဏ်ပညာ နှင့်တကွသိပ္ပံ အတတ်အမျိုးမျိုး ကိုပေး၍၊ ဘုရားသခင် ၏ဝိညာဉ် တော်နှင့်ပြည့်စုံ စေတော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","သူ နှင့် ဒန် အမျိုးသား အဟိသမက် ၏သား အဟောလျဘ သည်၊ သူတပါးအား အတတ်သင် ပေးနိုင် မည်အကြောင်း ၊ ဉာဏ် ကိုပေး တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ထိုသူ တို့သည် ထုလုပ်တတ်သောသူ၏ အလုပ်၊ ဆန်းပြားသောလက်သမား၏ အလုပ်၊ ပြာ သော အထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ကို ချယ်လှယ် တတ်သောသူ ၏အလုပ်၊ ရက် တတ်သောသူ၏အလုပ်၊ အနည်းနည်းလုပ်တတ်သောသူ၏အလုပ် ၊ ထူးဆန်းစွာကြံစည်တတ်သောသူ၏အလုပ်အမျိုးမျိုးရှိသမျှ တို့ကို လုပ် တတ်မည် အကြောင်း ၊ ဉာဏ် ပညာနှင့် ပြည့်စုံ တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ထိုသို့ ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ သန့်ရှင်း ရာဌာန၌ အမှု တော်ဆောင် စရာဘို့ ၊ အမျိုးမျိုး သောအလုပ်ကို လုပ်တတ်သော ဉာဏ် ပညာကို ထာဝရဘုရား ပေး သွင်းတော်မူသောပညာရှိ အပေါင်း တို့နှင့်တကွ ၊ ဗေဇလေလ ၊ အဟောလျဘ တို့သည် အလုပ်လုပ် ကြလိမ့်မည်ဟု ဣသရေလအမျိုးသားတို့အား ဆင့်ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","တဖန် မောရှေ သည်၊ ဗေဇလေလ ၊ အဟောလျဘ ကို၎င်း ၊ ထာဝရဘုရား ပေး တော်မူသော ဉာဏ် သဘောကို ရ၍၊ အလုပ် လုပ် ချင်သော စေတနာစိတ် ရှိသော ပညာရှိ အပေါင်း တို့ကို ၎င်းခေါ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","သန့်ရှင်း ရာဌာနနှင့် အမှုတော်ထမ်းရန် တန်ဆာတို့ကို လုပ်ကိုင် စေခြင်းငှာ ၊ ဣသရေလ အမျိုးသား တို့ ဆောင် ခဲ့သော အလှူ ရှိသမျှ ကို ထိုသူတို့သည် မောရှေ လက်မှ ခံ ကြ၏။ ကြည်ညိုသောစိတ်နှင့် လှူသောအလှူ ကို နံနက် တိုင်း ထပ်၍ဆောင် ခဲ့ကြသေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ထိုအခါ သန့်ရှင်း ရာဌာနတော်အလုပ် ကို လုပ်ကိုင် သော ပညာရှိ အပေါင်း တို့သည်၊ အသီးအသီး မိမိ လုပ် ရာမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","မောရှေ ထံသို့ လာ၍ ထာဝရဘုရား မှာ ထားတော်မူသော အလုပ် ပြီးလောက်ရုံမျှမက ၊ ပို ၍ ဆောင် ခဲ့ကြ ပါပြီဟု ကြား ပြောလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","မောရှေ က၊ သန့်ရှင်း ရာဌာနတော်အဘို့ လှူ ခြင်းငှာ အဘယ်ယောက်ျား မိန်းမ မျှ ထပ်မံ ၍ မ လုပ် စေနှင့် ဟု စီရင်၍၊ တတပ် လုံး၌ ကြော်ငြာ စေသဖြင့် ၊ လူ များအလှူဆောင် ခြင်းအမှုကို ဆီးတား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ရခဲ့သောဥစ္စာ သည် လုပ် ရှိသမျှ ကို ပြီးစီးလောက် ရုံမျှမက ပို လျက်ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","သန့်ရှင်း ရာဌာနတော်အလုပ် ကို လုပ်ကိုင် သောသူတို့ တွင် ၊ ပညာရှိ သောသူသည် ပိတ်ချော၊ ပြာ သော အထည်၊ မောင်း သောအထည်၊ နီ သောအထည်ဖြင့် ပြီး သော ခေရုဗိမ် အရုပ်နှင့် ချယ်လှယ် သော ပိတ်ချော ကုလားကာ ဆယ် ထည်ကို လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ကုလားကာ သည် အလျား နှစ်ဆယ် ရှစ် တောင် ၊ အနံ လေး တောင် ရှိ၍၊ ကုလားကာ ချင်း အလျား အနံတူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ကုလားကာ ငါး ထည်စီ တစပ်တည်းချုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ကုလားကာတထည် ပြင် ဘက်ကုလားကာ နား ချင်းဆက်မှီရာ၌ ကွင်း များကို ပြာ သောအထည်နှင့် လုပ် ၍၊ အခြား သော ကုလားကာပြင် ဘက် ကုလားကာ နား ချင်းဆက်မှီရာ၌ လည်း ထိုအတူ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ကုလားကာ တထည်၌ ကွင်း ငါးဆယ် ကို၎င်း၊ အခြားသော ကုလားကာ အနား ဆက်မှီရာ၌ ကွင်း ငါးဆယ် ကို၎င်း လုပ် သဖြင့်၊ ကွင်း ချင်း ဆိုင် မိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ရွှေ ချောင်း ငါးဆယ် ကိုလည်း လုပ် ၍ ၊ ထိုရွှေချောင်း ဖြင့် ကုလားကာ များကို ပူးတွဲ သဖြင့် တဲ တော် တ ဆောင်တည်းဖြစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","တဲ တော်ဖုံးအုပ် ဘို့ အခြားသော ကုလားကာ ဆယ် တ ထည်ကို ဆိတ် မွေးနှင့် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ကုလားကာ သည် အလျား အတောင် သုံးဆယ် ၊ အနံ လေး တောင် ရှိ၍ ကုလားကာ ဆယ် တထည် တို့သည် အလျား အနံချင်း တူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ကုလားကာ ငါး ထည်တစပ်၊ ခြောက် ထည်တစပ်တည်း ချုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ကုလားကာများဆက်မှီ ရာ၌၊ ပြင် ဘက်ကနေသောကုလားကာ တထည်အနား မှာ ကွင်း ငါးဆယ် ကို၎င်း၊ ဆက်မှီ သော အခြား ကုလားကာ အနား မှာ ကွင်း ငါးဆယ် ကို၎င်းလုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ကြေးဝါ ချောင်း ငါးဆယ် ကိုလည်း လုပ် ၍ အပေါ်တဲ တပိုင်းနှင့် တပိုင်းကို ပူးတွဲ သဖြင့်၊ တဲတဆောင် တည်းဖြစ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","အပေါ်တဲ ဖုံးအုပ် ဘို့ အနီ ဆိုးသော သိုး ရေ ကို၎င်း၊ ထိုသိုးရေအပေါ် ၌ တဟာရှ သားရေ ကို၎င်း လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","တဲ တော်ကာရန်ထောင် ထားသော အကာရှ ပျဉ်ပြား တို့ကိုလည်း လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ပျဉ်ပြား သည် အလျား ဆယ် တောင် ၊ အနံ တတောင် ထွာ ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ထိုပျဉ်ပြား ရှိသမျှ တို့၌ ခြေထောက်နှစ်ခုစီ တတန်း တည်းရှိစေခြင်းငှာ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","တဲ တော်တောင် ဘက် ၌ ကာရန် ပျဉ်ပြား နှစ်ဆယ် ကို လုပ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ထိုပျဉ်ပြား နှစ်ဆယ် တွင်၊ တပြားတပြားအောက် ၌ ခြေထောက် နှစ် ခုစီ စွပ်စရာဘို့ ငွေ ခြေစွပ် လေးဆယ် ကို လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ထိုအတူ တဲ တော်မြောက် ဘက် ၌ ကာရန် ပျဉ်ပြား နှစ်ဆယ် ကို လုပ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ထိုပျဉ်ပြား ၌လည်း ငွေ ခြေစွပ် လေးဆယ် ၊ တပြား နှစ် ခုစီ လုပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","တဲ တော်အနောက် ဘက်၌ ကာရန် ပျဉ်ပြား ခြောက် ပြားကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ထောင့် တဘက် တချက်၌ ကာရန် ပျဉ်ပြား နှစ် ပြားကို၎င်းလုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","အထက် ၌ ၎င်း၊ အောက် ၌၎င်း ၊ ကွင်း ကိုတပ် ၍ စေ့စပ်လျက် ထောင့် နှစ် ခုပြီး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ပျဉ်ပြား ရှစ် ပြား၊ ငွေ ခြေစွပ် ဆယ် ခြောက် ခု၊ တပြား နှစ် ခုစီ ရှိ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","တဲ တော်၌ ကာရသော ပျဉ်ပြား ကို လျှိုစရာဘို့ အကာရှ သား ကန့်လန့်ကျင် တို့ကို၊ တဘက် ငါး ချောင်းစီ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","တဲ တော်နောက်ဖေး ၌ ကာရသော ပျဉ်ပြား ကို လျှိုစရာဘို့ ၊ ကန့်လန့်ကျင် ငါး ချောင်းကိုလည်း လုပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","အလယ် ကန့်လန့်ကျင် ကို ထောင့်တဘက်တချက် ၌ ဆုံး စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ပျဉ်ပြား တို့ကို ရွှေ နှင့်မွမ်းမံ လေ၏။ ကန့်လန့်ကျင် လျှို ဘို့ရာ ရွှေ ကွင်း ကိုလည်း လုပ် ၍ ကန့်လန့်ကျင် တို့ကို ရွှေ နှင့်မွမ်းမံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","တနည်းကား၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ဖြင့် ပြီး ၍၊ ခေရုဗိမ် အရုပ်နှင့်၊ ချယ်လှယ် သော ကုလားကာ တထည်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ထိုကုလားကာဘို့ ရွှေ ချ သော အကာရှ သားတိုင် လေး တိုင်ကို၎င်းလုပ် လေ၏။ ထိုတိုင် တို့သည် ရွှေ တံစို့ နှင့် ပြည့်စုံ၍၊ ငွေ ခြေစွပ် လေး ခုကိုလည်း သွန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","တဲ တော်တံခါး ဝ၌ ကာရန်၊ ပြာ သောအထည်၊ မောင်း သော အထည်၊ နီ သော အထည် ပိတ်ချော ဖြင့် ပြီး ၍ ချယ်လှယ် သော ကုလားကာ တထည်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ထိုကုလားကာ ဘို့ တံစို့ နှင့် ပြည့်စုံသော တိုင် ငါး တိုင်ကို၎င်းလုပ်၍၊ တိုင် ထိပ် နှင့်တိုင် တန်း တို့ကို ရွှေ နှင့် မွမ်းမံ လေ၏။ ကြေးဝါ ခြေစွပ် ငါးခု လည်း ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","တဖန် ဗေဇလေလ သည်၊ အလျား နှစ်တောင် ထွာ ၊ အနံ တတောင် ထွာ၊ စောက် တတောင် ထွာ ရှိသောသေတ္တာ ကို အကာရှ သား နှင့်လုပ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","သေတ္တာအတွင်း အပြင် ကို ရွှေ စင် နှင့်မွမ်းမံ လေ၏။ သေတ္တာပေါ်နားပတ်လည် ၌ကွပ် သောရွှေ တန်ဆာကိုလည်း လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ရွှေ လေး ကွင်း ကို သွန်း ၍၊ သေတ္တာ လေး ထောင့်၌ တ မျက်နှာ နှစ် ကွင်း စီတပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","အကာရှ သား ထမ်းဘိုး ကို လုပ် ၍ ရွှေ နှင့်မွမ်းမံ ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","သေတ္တာ ထမ်း စရာဘို့ တဘက်တချက် ရွှေကွင်း ၌ လျှိုထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","အလျား နှစ်တောင် ထွာ ၊ အနံ တတောင် ထွာ ရှိသောသေတ္တာအဖုံး ကိုလည်း ၊ ရွှေ စင် နှင့်လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ရွှေ ခေရုဗိမ် နှစ် ပါးကိုလည်း ၊ သေတ္တာအဖုံး တွင် အလျားတဘက်တချက် ၌ ထု လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ထိုသို့ ခေရုဗိမ် နှစ် ပါးကို၊ သေတ္တာဖုံး ကိုယ်ထဲက ထုတ်၍၊ သေတ္တာဖုံးအပေါ်၌ တဘက်တပါးစီ လုပ် ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ခေရုဗိမ်နှစ်ပါးတို့သည် မျက်နှာ ချင်း ဆိုင် ၍၊ သေတ္တာဖုံး ကို ရှု လျက်၊ မိမိ အတောင် ကို ဖြန့် ၍ သေတ္တာဖုံး ကို မိုး လျက် ရှိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","အလျား နှစ်တောင် ၊ အနံ တတောင် ၊ အမြင့် တတောင် ထွာ ရှိသော စားပွဲ ကိုလည်း ၊ အကာရှ သား နှင့် လုပ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ရွှေ စင် နှင့် မွမ်းမံ လေ၏။ စားပွဲအပေါ်နားပတ်လည် ၌ ကွပ် သော ရွှေ တန်ဆာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","အနံ တလက်ဝါး ရှိသောခါးပန်း ကို၎င်း၊ ခါးပန်း အပေါ်နားပတ်လည်၌ ကွပ် သော ရွှေ တန်ဆာကို၎င်း လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ရွှေ လေး ကွင်း ကိုလည်း သွန်း ၍ ခြေထောက် လေး ခုအထက်၊ စားပွဲလေး ထောင့် ၌ တပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ထိုရွှေကွင်း တို့သည် ခါးပန်း ပေါ်မှာရှိ၍၊ စားပွဲ ထမ်း စရာ ထမ်းဘိုး နေရာ ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","စားပွဲ ထမ်း စရာ အကာရှ သား ထမ်းဘိုး ကို လုပ် ၍ ရွှေ နှင့် မွမ်းမံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","စားပွဲ တန်ဆာ တည်းဟူသောလင်ပန်း ၊ ဇွန်း ၊ အင်တုံ ၊ လောင်း စရာ ဖလား များကိုလည်း ရွှေ စင် နှင့် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","မီးခုံ ကိုလည်း ရွှေ စင် နှင့်လုပ် ၍၊ မီးခုံ တိုင်အစရှိသော အလက် များ၊ ခွက် များ၊ ဘူးသီး များ၊ ကြာပွင့် များတို့ကို တစပ်တည်းထု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","မီးခုံ တိုင် တဘက် တချက် သုံး လက်စီ ထွက် ၍၊ အလက် ခြောက် လက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","မီးခုံ တိုင်ထဲက ထွက် သော အလက် သုံးလက်တွင်၊ တလက်တလက်၌ဘူး ၊ ကြာပွင့် နှင့်တကွ ဗာတံ သီးနှင့် ပုံတူသော ခွက် သုံး ခွက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","မီးခုံ တိုင်၌ လည်း ဘူး ၊ ကြာပွင့် နှင့်တကွ ဗာတံ သီးနှင့်ပုံတူသော ခွက် လေး ခွက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","မီးခုံ တိုင်ထဲက ထွက် သော အလက် ခြောက် လက်ရှိသည်အတိုင်း ၊ အလက် နှစ်ဘက် အောက် ၌လည်း ဘူးသီး တလုံးစီရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ဘူး များ၊ အလက် များတို့ကို တကိုယ်တစပ်တည်း ဖြစ် စေ၍ မီးခုံ တကိုယ် လုံးကို ရွှေ စင် နှင့် ထု လုပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","မီးခွက် ခုနစ် လုံး၊ မီးညှပ် နှင့် မီးညှပ်ခံစရာခွက် များကိုလည်း ရွှေ စင် နှင့် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","မီးခုံနှင့် မီးခုံတန်ဆာ ရှိသမျှ တို့ကို ရွှေ စင် အခွက် တဆယ်နှင့် လုပ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","တနည်းကား၊ နံ့သာ ပေါင်းကို မီးရှို့စရာ ယဇ် ပလ္လင်ကို အကာရှ သားနှင့် လုပ် လေ၏။ ထိုပလ္လင်သည် အလျား တတောင် ၊ အနံ တတောင် ၊ စတုရန်း လေးထောင့်ဖြစ်၍အမြင့် နှစ်တောင် ရှိလေ၏။ ဦးချို တို့ကိုလည်း အကာရှ သားဖြင့် ပြီး စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ပလ္လင်ထိပ်၊ နံရံ၊ ဦးချို တို့ကို ရွှေ စင် နှင့် မွမ်းမံ ၍၊ အပေါ် နားပတ်လည် ၌ကွပ် သော ရွှေ တန်ဆာကို လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ရွှေတန်ဆာအောက် ပလ္လင်တဘက် တချက်ထောင့်၌ ရွှေ ကွင်း နှစ် ကွင်းကိုလုပ် ၍ ပလ္လင် ထမ်း စာရာ ထမ်းဘိုး နေရာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ထမ်းဘိုး တို့ကို အကာရှ သား နှင့်လုပ် ၍ ရွှေ နှင့်မွမ်းမံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ဆေးသမားအတတ် နှင့်ဆေးပေါင်းကိုဘော် တတ်သည်အတိုင်း၊ သန့်ရှင်း သော လိမ်း ရန်နံ့သာဆီ ကို ၎င်း၊ နံ့သာ မျိုးနှင့်ဘော်သော မီးရှို့ရာနံ့သာ ပေါင်းစင် ကို၎င်းလုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","တနည်းကား၊ အလျား ငါး တောင် ၊ အနံ ငါး တောင် ရှိ၍ စတုရန်း လေးထောင့်ဖြစ်သော မီးရှို့ ရာ ယဇ်ပလ္လင် ကို အကာရှ သား နှင့်လုပ် လေ၏။ အမြင့် လည်း သုံး တောင် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ယဇ်ပလ္လင် လေး ထောင့် အပေါ် မှာ ဦးချို လေးချောင်းကို အကာရှ သားနှင့်လုပ် ၍ ကြေးဝါ နှင့် မွမ်းမံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","အိုး နှင့်တကွ တူးရွင်း ပြား၊ အင်တုံ ၊ အမဲသား ချိတ်၊ လင်ပန်း အစရှိသော ယဇ်ပလ္လင် နှင့် ဆိုင်သောတန်ဆာ ရှိသမျှ တို့ကို ကြေးဝါ နှင့်လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ကြေးဝါ ဆန်ခါ ကို လုပ် ၍ ယဇ်ပလ္လင် ခါးပန်း အောက် အလယ် ၌ထား၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ထမ်းဘိုး ထား ရာ ဆန်ခါ လေး ထောင့် ၌ တပ်ရသောကြေးဝါ လေး ကွင်း ကို သွန်း ");
INSERT INTO myajvb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","အကာရှ သား ထမ်းဘိုး တို့ကို လုပ် ၍ ကြေးဝါ နှင့် မွမ်းမံ ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ယဇ်ပလ္လင် ကို ထမ်း စရာဘို့ တဘက် တချက်ကွင်း များ၌ လျှိုထား လေ၏။ ထိုယဇ်ပလ္လင်ကို အပေါ်အောက် ဟင်းလင်း ဖြစ်စေခြင်းငှာ၊ ပျဉ်ပြား နှင့် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့မှာ စည်းဝေး တတ်သော မိန်းမ တို့၏ ကြေးဝါ မှန် များကို ယူ၍ ကြေးဝါ အင်တုံ နှင့် ကြေးဝါ ခြေထောက် ကို လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","တဲတော်ဝင်း ကာရန်မူကား၊ အလျားအတောင် တရာ ရှိသော ပိတ်ချော နှင့် တောင် ဘက်၌ ကုလားကာ ကို လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ထိုကုလားကာ ဘို့ တိုင် နှစ်ဆယ် ၊ တိုင် ခြေစွပ် နှစ်ဆယ် ကို ကြေးဝါ နှင့်လုပ်၍ တိုင် တံစို့ ၊ တိုင်တန်း တို့ကို ငွေ ဖြင့်ပြီး စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ထိုနည်းတူမြောက် ဘက် ၌ ကာရန်အလျားအတောင် တရာ ရှိသော ကုလားကာနှင့်တကွ ငွေတံစို့ ၊ ငွေ တန်း ပါသောကြေးဝါ တိုင် နှစ်ဆယ် ၊ ကြေးဝါ ခြေစွပ် နှစ်ဆယ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","အနောက် ဘက် ၌ ကာရန် အလျားအတောင် ငါးဆယ် ရှိသောကုလားကာ နှင့်တကွ တိုင် တဆယ် ၊ ခြေစွပ် တဆယ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","အရှေ့ ဘက် ၌လည်း အတောင် ငါးဆယ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","တံခါး ဝ တဘက် တချက်၌ ကာရန် အလျားဆယ် ငါး တောင် ရှိသောကုလားကာ နှင့်တကွ တိုင် သုံး တိုင်၊ ခြေစွပ် သုံး ခုရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ဝင်း ပတ်လည် ၌ကာသော ကုလားကာ ရှိသမျှ တို့သည် ပိတ်ချော ဖြင့်ပြီး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","တိုင် တို့သည် ကြေးဝါ ခြေစွပ် ၊ ငွေတံစို့ ၊ ငွေ တန်း နှင့်ပြည့်စုံ၍ တိုင် ထိပ် များကိုလည်း ငွေ နှင့် မွမ်းမံ လေ၏။ ဝင်း တိုင် တန်း ရှိသမျှ တို့သည် ငွေ တန်းဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ဝင်း တံခါး ဝ၌ ကာရန် ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ဖြင့်ပြီး ၍ ချယ်လှယ် သော ကုလားကာ ၊ အလျား အတောင် နှစ်ဆယ် ၊ အမြင့် ငါး တောင် ရှိ၍၊ ဝင်း ကာသော ကုလားကာ နှင့် တညီတည်း ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ဝင်း တံခါးဝတိုင် လေး ခုရှိ၍၊ ကြေးဝါ ခြေစွပ် လေး ခု၊ ငွေ တံစို့ ၊ ငွေ တန်း များ၊ ငွေနှင့်မွမ်းမံ သော ထိပ် များနှင့် ပြည့်စုံကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","တဲ တော်တံသင်ဝင်း ပတ်လည် ၌ စိုက်သော တံသင် ရှိသမျှ တို့သည် ကြေးဝါ တံသင်ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ဤ ရွေ့ကား၊ မောရှေ စီရင် သည်အတိုင်း၊ ယဇ်ပုရောဟိတ် အာရုန် ၏သား ဣသမာ သည်၊ လေဝိ လူများ အမှု တော်ဆောင်စရာ တဲ တော်ကို ရေတွက်မှတ်သား သော သက်သေခံ ချက် တဲ တော်စာရင်း ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","မောရှေ အား ထာဝရဘုရား မှာ ထားတော်မူသမျှတို့ ကို ၊ ယုဒ အမျိုးသား ဟုရ ၏သား ဖြစ်သော၊ ဥရိ ၏ သား ဗေဇလေလ သည် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ထိုမှတပါး ၊ ထုလုပ်တတ်သောသူ၏ အလုပ်၊ ဆန်းပြား သော လက်သမား အလုပ်၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော ကို ချယ်လှယ် တတ်သောသူ၏ အလုပ်ကို လုပ်တတ်သော ဒန် အမျိုးသား အဟိသမက် ၏သား အဟောလျဘ လည်းရှိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","သန့်ရှင်း ရာ ဌာနတော်ပြီး အောင် လှူ ၍ လုပ်သော ရွှေ ချိန်ပေါင်း ကား အကျပ်တော်အတိုင်း အခွက် နှစ်ရာ ကိုးဆယ် ခုနစ် ပိဿာ သုံးဆယ် ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","စာရင်း ဝင်သော ပရိသတ် များပေးသော ငွေ ချိန်ပေါင်းကား၊ အကျပ် တော်အတိုင်း အခွက် တထောင် နှင့် တဆယ် ခုနစ် ပိဿာခုနစ်ဆယ် ငါး ကျပ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","အသက် နှစ်ဆယ် မှစ၍ ပိုလွန် သမျှသောသူ စာရင်း ဝင်သည်အတိုင်း၊ လူခြောက် သိန်းသုံး ထောင် ငါး ရာ ငါးဆယ် တို့သည်၊ အကျပ် တော်အလိုက် ငွေချိန်အကျပ် တဝက် စီ ပေးရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ခြေစွပ် တခု၌ ငွေအခွက် တဆယ် စီဝင်သည်ဖြစ်၍၊ ငွေ အခွက် တထောင် နှင့် တဲ တော် ခြေစွပ် ၊ အတွင်းကုလားကာ ခြေစွပ် တည်းဟူသောခြေစွပ် တရာ ကို သွန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ကျန်သောငွေအခွက်တဆယ် ခုနစ် ပိဿာခုနစ်ဆယ် ငါး ကျပ်နှင့် တိုင် တံစို့ နှင့် တိုင်တန်းတို့ကို လုပ် ၍ တိုင် ထိပ် များကို မွမ်းမံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","လှူ သော ကြေးဝါ ပေါင်းကား အခွက် ခုနစ်ရာ နှစ်ဆယ် နှင့် လေး ပိဿာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ထိုကြေးဝါ နှင့် ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ဝခြေစွပ် ၊ ကြေးဝါ ယဇ် ပလ္လင်၊ ကြေးဝါ ဆန်ခါ ၊ ယဇ် ပလ္လင်တန်ဆာ ရှိသမျှ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ကာသောဝင်း ခြေစွပ် ၊ ဝင်း တံခါး ဝခြေစွပ် ၊ တဲ တော်တံသင် ၊ ဝင်း ပတ်လည် ၌ စိုက်သော တံသင် ရှိသမျှ ကို ၎င်းလုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","သန့်ရှင်း ရာဌာန၌ အမှုတော်ကို ဆောင် သောအခါ ၊ ဝတ် ရသောအဝတ် ကို၎င်း၊ အာရုန် ဝတ်ဘို့ သန့်ရှင်း သော အဝတ် ကို၎င်း၊ ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်နှင့် လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော နှင့် ယဇ်ပုရောဟိတ်သင်တိုင်း ကို လုပ်ရာတွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ရွှေ ကို အပြား ခတ် ၍ ရွှေ ကြိုးကို လှီး ပြီးမှ၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော တို့ကို ထူးဆန်း စွာ အပြောက်ထိုးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","သိုင်းကြိုး နှစ်ပင်ကို လုပ် ၍ သင်တိုင်းအပေါ်နားချင်းတွဲမိ စေခြင်းငှာ ၊ တဘက် တချက်ကို ဆွဲချုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ၊ သင်တိုင်း အပေါ် နား၌ ထူးဆန်းသော ရင်စည်း ကိုလည်း သင်တိုင်း ကိုယ်ကဲ့သို့ ရွှေ နှင့်၎င်း၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော တို့နှင့်၎င်း လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ရှဟံ ကျောက် နှစ်လုံးကို သွေး ၍ တံဆိပ် ပေါ်မှာ အက္ခရာတင် သကဲ့သို့ဣသရေလ အမျိုး ၏ နာမ တို့ကို အက္ခရာတင် ပြီးမှ၊ ရွှေ ကျောက်အိုး ၌ ထည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့ကို အောက်မေ့ ဘို့ရာ ၊ ထိုကျောက် နှစ်လုံးကို သင်တိုင်း သိုင်းကြိုး အပေါ် မှာ တပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ရွှေနှင့်၎င်း၊ ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချော နှင့်၎င်း၊ သင်တိုင်း ကို လုပ် သည်နည်းတူ ၊ ရင်ဖုံး ကို ထူးဆန်း စွာ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ရင်ဖုံး နှစ်ထပ်ခေါက် လျက်၊ အလျား တထွာ ၊ အနံ တထွာ ၊ စတုရန်း လေးထောင့်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ထိုရင်ဖုံး ၌ ကျောက် မြတ်ကို လေး တန်း စီ လေ၏။ ပဌမ အတန်း ကား ကျောက်နီ ၊ ဥဿဖရား ၊ ပတ္တမြား။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ဒုတိယ အတန်း ကား မြ ၊ နီလာ ၊ စိန်။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","တတိယ အတန်း ကား ဝှါကိန္တု ၊ မဟူရာ ၊ ဂေါမိတ်။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","စတုတ္ထ အတန်း ကား မျက်ရွဲ ၊ ကြောင် ၊ နဂါးသွဲ့ ဖြစ်၍၊ အသီးအသီး တို့ကို ရွှေ အိုး ၌ စီ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ဣသရေလ အမျိုး တဆယ် နှစ် မျိုးရှိသည်အတိုင်း တံဆိပ် ပေါ်မှာ အက္ခရာတင် သကဲ့သို့၊ ထိုကျောက် တို့၌ ထိုတဆယ် နှစ်ပါး သော နာမည် အသီးအသီးတို့ကို တင်လျက် ကျောက်တလုံးလျှင် နာမည် တပါးစီ ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ရင်ဖုံး အပေါ်ထောင့် နှစ် ခု၌ ၊ ရွှေနှစ် ကွင်း ကို၎င်း၊ ရွှေကျောက်အိုး နှစ်လုံးကို၎င်းကျစ် သော ရွှေ ကြိုး နှစ် ပင်ကို၎င်းလုပ် ပြီးမှ ၊ ထိုရွှေ ကွင်း ၌ တပ် ၍ သင်တိုင်း သိုင်းကြိုး အပေါ်မှာရှိသော ကျောက်အိုးတို့၌ တွဲ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","တဖန် ရွှေ နှစ် ကွင်း ကို လုပ် ၍ သင်တိုင်း အောက်နား မှာ ရှိသော ရင်ဖုံး အောက်ထောင့် နှစ် ခု၌ တပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","အခြားသောရွှေ နှစ် ကွင်း ကိုလည်း လုပ် ၍ သင်တိုင်း အရှေ့ ဘက်အောက် နား နှင့် ထူးဆန်းသော ရင်စည်း အပေါ် နားဆက်မှီ ရာတွင် သင်တိုင်းကို တဘက်တချက်၌ တပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ရင်ဖုံး ရွှေနှစ်ကွင်း ကို၊ သင်တိုင်း ရွှေနှစ်ကွင်း နှင့် တွဲ၍၊ ပြာ သောကြိုး ဖြင့် ပြီးစေ၏။ ထိုသို့ ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ၊ ရင်ဖုံး သည် ထူးဆန်းသော ရင်စည်း အပေါ်မှာ ဆွဲ ၍ သင်တိုင်း နှင့် မ ကွာ ဘဲ ");
INSERT INTO myajvb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ထိုမှတပါး ၊ ပြာ သောအထည်ကို ရက် ပြီးမှ၊ သင်တိုင်း နှင့်ဆိုင်သော ဝတ်လုံ ကို ထိုအထည်နှင့်သာ လုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ဝတ်လုံ ၌ လည်စွပ်ပါ၍ လည်စွပ် ကို မ စုတ် စေခြင်းငှာ၊ သံချပ်လည်စွပ် ကွပ်သကဲ့သို့ ကွပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ပြာ သောအထည်၊ မောင်း သောအထည်၊ နီ သောအထည်၊ ပိတ်ချောနှင့်လုပ် သော သလဲ သီးများကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ရွှေ စင် ဆည်းလည်း များကို၎င်း၊ ဝတ်လုံ အောက်စွန်းနားပတ်လည် ၌ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","သလဲ သီးတလုံး၊ ဆည်းလည်း တလုံးစီခြားလျက် အစဉ်အတိုင်းဆွဲထားသဖြင့်၊ ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ၊ အမှုတော်ကို ဆောင် ရသောဝတ်လုံ ကို လုပ် ၍ပြီးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","တဖန် ထာဝရဘုရားသည် မောရှေအား မှာထားတော်မူသည်အတိုင်း၊ အာရုန် နှင့် သူ ၏သား တို့အဘို့ ရက် သော ပိတ်ချော အင်္ကျီ များကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ပိတ်ချော ဗေါင်း ကို၎င်း၊ တင့်တယ်သောပိတ်ချော ဦးထုပ် များကို၎င်း ၊ ပိတ်ချော ပေါင်းဘီ များကို၎င်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ချယ်လှယ် သော ပိတ်ချော၊ အထည်ပြာ ၊ အထည်မောင်း ၊ အထည်နီ ဖြင့်ပြီး သော ခါးပန်း ကို၎င်းလုပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","မောရှေ အား ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ သန့်ရှင်း သော သင်းကျစ် ပြားကိုလည်း ရွှေ စင် နှင့်လုပ်၍ တံဆိပ် ပေါ်မှာ အက္ခရာတင်သကဲ့သို့၊ ထာဝရဘုရား အား သန့်ရှင်း ခြင်းဟု အက္ခရာတင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ပြာ သောကြိုး နှင့် ဗေါင်း အပေါ် နား၌ ချည် ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ထိုသို့ မောရှေ အား ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့သည် ပြု ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်အလုပ် ရှိသမျှ ကို ပြီးစီး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ထိုအခါ ဣသရေလအမျိုးသားတို့သည်၊ တဲ တော်နှင့် အပေါ်တဲ မှစ၍ ၊ ရွှေချောင်း ၊ ပျဉ်ပြား ၊ ကန့်လန့်ကျင် ၊ တိုင် ၊ ခြေစွပ် တည်းဟူသောတဲ တော်တန်ဆာ ရှိသမျှ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","အနီ ဆိုးသော သိုး ရေ အမိုး ၊ တဟာရှ သားရေ အမိုး ၊ ကွယ်ကာ ရာအတွင်းကုလားကာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","သက်သေခံ ချက်သေတ္တာ နှင့် သူ ၏ထမ်းဘိုး ၊ သူ၏အဖုံး ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","စားပွဲ မှစ၍စားပွဲတန်ဆာ နှင့် ရှေ့ တော်မုန့် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","စင်ကြယ် သော မီးခုံ မှစ၍၊ ပြင်ဆင်ရသောမီးခွက် များ၊ မီးခုံ တန်ဆာ ရှိသမျှ နှင့် မီးထွန်း စရာ ဆီ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ရွှေ ယဇ်ပလ္လင် ၊ လိမ်း ရန်ဆီ ၊ မီးရှို့ရာနံ့သာ ပေါင်းမွှေး ၊ တဲ တော်တံခါး ဝ ကာစရာ ကုလားကာ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ကြေးဝါ ယဇ် ပလ္လင်၊ ကြေးဝါ ဆန်ခါ ၊ ပလ္လင် ထမ်းဘိုး အစရှိ သော တန်ဆာ ရှိသမျှ ကို၎င်း၊ အင်တုံ နှင့် သူ ၏ခြေထောက် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ဝင်း ကုလားကာ ၊ ဝင်း တိုင် ၊ ခြေစွပ် ၊ ဝင်း တံခါး ဝကာစရာ ကုလားကာ ကြိုး များ၊ တံသင် များကို၎င်း၊ တဲ တော်အတွင်း၌ အမှုတော်ကို ဆောင် စရာတန်ဆာ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တန်ဆာ ရှိသမျှ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","သန့်ရှင်း ရာဌာန၌ အမှုတော်ကို ဆောင် သောအခါ ဝတ် ရသောအဝတ် ၊ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်သောအခါ၊ ယဇ်ပုရောဟိတ် အာရုန် ဝတ်ဘို့ သန့်ရှင်း သော အဝတ် ၊ သူ ၏သား ဝတ်ရသောအဝတ် ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည်အတိုင်း ပြီးစီးအောင် လုပ် ပြီးမှမောရှေထံသို့ ဆောင်ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ အလုပ် ရှိသမျှ ကို ပြီးစီးစေခြင်းငှါ၊ လုပ် ကြောင်းကို မောရှေ သိမြင် သောအခါ ၊ သူ တို့ကို ကောင်းကြီး ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","သင်သည် ပဌမ လ ၊ ပဌမ နေ့ ၌ ပရိသတ်စည်းဝေး ရာ တဲ တော်ကို ဆောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","တဲတော်အထဲ၌၊ သက်သေခံ ချက် သေတ္တာ ကို သွင်း ထား၍ ၊ အတွင်းကုလားကာ ဖြင့် ကွယ်ကာ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","စားပွဲ ကိုလည်း သွင်း ၍ ၊ စားပွဲ ပေါ်မှာ ပြင်ဆင်ရသမျှတို့ကို ပြင်ဆင် ရမည်။ မီးခုံ ကိုလည်း သွင်း ၍၊ မီးခွက် တို့ကို ထွန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","နံ့သာ ပေါင်းရှို့ရာ ရွှေ ပလ္လင် ကို သက်သေခံ ချက် သေတ္တာ ရှေ့ ၌ တည် ထား၍ ၊ တဲ တော်တံခါး ဝကာသော ကုလားကာ ကို ဆွဲ ကာရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ယဇ်ကောင်ရှို့ ရာ ပလ္လင် ကိုလည်း ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့ ၌ တည် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","အင်တုံ ကိုလည်း ပရိသတ် စည်းဝေး ရာ တဲ တော်နှင့် ယဇ် ပလ္လင်စပ်ကြား မှာ တည် ထား၍ ၊ အင်တုံ၌ ရေ ကို ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","တဲတော်ပတ်လည် ဝင်း ကို ထူ၍၊ ဝင်း တံခါး ဝကာသော ကုလားကာ ကို ဆွဲ ကာရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","လိမ်း ရန် ဆီ ကို ယူ ၍ ၊ တဲ တော်နှင့် တဲတော်၌ ရှိသမျှ တို့ကို လိမ်း သဖြင့် တဲတော်နှင့် တဲတော်တန်ဆာရှိသမျှ တို့ကို သန့်ရှင်း စေရမည်။ ထိုသို့ တဲတော်သည် သန့်ရှင်း ရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ယဇ်ကောင်ရှို့ ရာပလ္လင် နှင့် တန်ဆာ ရှိသမျှ တို့ကို လိမ်း ၍ သန့်ရှင်း စေသဖြင့်၊ ထိုပလ္လင် သည် အလွန် သန့်ရှင်း သော ပလ္လင် ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","အင်တုံ နှင့် ခြေထောက် ကိုလည်း လိမ်း ၍ သန့်ရှင်း စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","အာရုန် နှင့် သူ ၏သား တို့ကို၊ ပရိသတ်စည်းဝေး ရာ တံခါး နားသို့ ခေါ် ခဲ့၍ ရေချိုး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","အာရုန် သည် ငါ့ ရှေ့၌၊ ယဇ်ပုရောဟိတ် အမှုကို ဆောင်ရွက်မည်အကြောင်း ၊ သန့်ရှင်း သောအဝတ် နှင့် ဝတ် စေ၍ ဆီလိမ်း သဖြင့် သန့်ရှင်း စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","သူ ၏သား တို့သည်လည်း ငါ့ ရှေ့၌ ယဇ်ပုရောဟိတ် အမှုကို ဆောင်ရွက်မည်အကြောင်း ၊ သူ တို့ကို ခေါ် ခဲ့၍ အင်္ကျီ ဝတ် စေလျက် ၊ သူတို့အဘ ကို ဆီလိမ်း သကဲ့သို့ ၊ သူ တို့ကို ဆီ လိမ်းရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","အကယ်စင်စစ်သူ တို့ ဆီလိမ်းခြင်း ဘိသိက် သည် သား စဉ်မြေးဆက်ပတ်လုံး၊ ထာဝရ ယဇ် ပုရောဟိတ်အရာဖြစ်သတည်းဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ထာဝရဘုရား မိန့် တော်မူသမျှ အတိုင်း မောရှေ ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","သက္ကရာဇ် နှစ်ခု ၊ ပဌမ လ ၊ ပဌမ နေ့၌ မောရှေသည် တဲ တော်ကို ဆောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ ခြေစွပ် များကို နေရာချ ၍၊ ပျဉ်ပြား များကို ထောင် ပြီးလျှင် ၊ ကန့်လန့်ကျင် များကို လျှို ၍ ၊ တိုင် တို့ကို ထူ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","တဲ တော်အပေါ် မှာ တဲ ကို ဖြန့် မိုး၍ ထိုတဲအပေါ် မှာ လည်း အထပ်ထပ်မိုး ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ထာဝရဘုရား မှာထားတော်မူသည်အတိုင်း၊ သက်သေခံချက်ကို သေတ္တာထဲမှာ သွင်းထား၍၊ သေတ္တာ ကွင်းတို့၌ ထမ်းဘိုးကို လျှို၍၊ သေတ္တာပေါ်မဖုံးကိုတင်ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","သေတ္တာကို တဲတော်၌ သွင်း၍ ကွယ်ကာရာ အတွင်းကုလားကာကို ကာထားသဖြင့်၊ သက်သေခံချက် သေတ္တာကို ကွယ်ကာလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ထာဝရဘုရားမှာထားတော်မူသည်အတိုင်း၊ စားပွဲကိုလည်း ပရိသတ်စည်းဝေးရာ တဲတော်အတွင်း မြောက်ဘက်နား ကုလားကာပြင်မှာထား ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","စားပွဲပေါ်မှာ ထာဝရဘုရားရှေ့တော်၌ မုန့်ကို ပြင်ဆင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ထာဝရဘုရား မှာထားတော်မူသည်အတိုင်း၊ မီးခုံ ကိုလည်း ပရိသတ် စည်းဝေး ရာ တဲ တော်အတွင်း ၊ တောင်ဘက်နား စားပွဲ ဆိုင်ရာတွင် ထား ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ထာဝရဘုရား ရှေ့ တော်၌ မီးခွက် များကို ထွန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ ရွှေ ပလ္လင် ကိုလည်း ပရိသတ်စည်းဝေး ရာ တဲ တော်အတွင်း ၊ ကုလားကာ ပြင် မှာ ထား ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ထိုပလ္လင် ပေါ် ၌ မွှေး သော နံ့သာ ပေါင်းကို မီးရှို့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","တဲ တော်တံခါး ဝ၌လည်း၊ ကုလားကာ ကို ဆွဲကာ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ မီးရှို့ရာ ယဇ်ပလ္လင်ကိုလည်း၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့မှာထား ၍ ၊ ထိုပလ္လင်ပေါ်၌ မီးရှို့ ရာ ယဇ်ကို၎င်း ၊ ဘောဇဉ်ပူဇော်သက္ကာ ကို၎င်း ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","အင်တုံ ကိုလည်း ပရိသတ်စည်းဝေး ရာတဲ နှင့် ယဇ် ပလ္လင်စပ်ကြား မှာထား ၍ ၊ ဆေး စရာ ရေ ကို အင်တုံ၌ ထည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ မောရှေ နှင့် အာရုန် မှစ၍ သူ ၏သား တို့သည် ပရိသတ် စည်းဝေး ရာ တဲ တော်အထဲသို့ ဝင် သော် ၎င်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ယဇ် ပလ္လင်အနီးသို့ ချဉ်းကပ် သော် ၎င်း၊ လက် ခြေ တို့ကို ဆေး ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","တဲ တော်နှင့် ယဇ် ပလ္လင်ပတ်လည် ဝင်း ကိုထူ ၍ ၊ ဝင်း တံခါးဝ ၌ ကာသော ကုလားကာ ကို ဆွဲ လေ၏။ ထိုသို့ မောရှေ သည် အလုပ် ကို ပြီးစီး စေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ထိုအခါ မိုဃ်းတိမ် သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ကို လွှမ်းမိုး ၍ ၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် တဲ တော်ကို ဖြည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ထိုသို့ မိုဃ်းတိမ်သည် ပရိသတ်စည်းဝေးရာ တဲ တော်အပေါ် ၌ နေ သောကြောင့် ၊ မောရှေ သည် အထဲသို့ မ ဝင် ရ။ ထာဝရဘုရား ၏ ဘုန်း တော်သည် တဲ တော်ကို ဖြည့် လျက်နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ဣသရေလ အမျိုးသား တို့သည် ခရီး သွားလေရာရာ တွင် ၊ မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှ ကွာ မြောက်သောအခါ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","မိုဃ်းတိမ် မ ကွာ မမြောက်လျှင် ၊ မကွာ မ မြောက်မှီနေ့ တိုင်အောင်၊ ခရီးမ သွား ဘဲ နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ခရီး သွားလေရာရာ တွင် ဣသရေလ အမျိုးသား အပေါင်း တို့ရှေ့မှောက် ၌ ထာဝရဘုရား ၏ မိုဃ်းတိမ် သည် နေ့အခါ တဲ တော်အပေါ် မှာ တည်နေ၏။ ညဉ့် အခါ မီးလျှံ ဖြစ် လျက် တည်နေလေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ထာဝရဘုရား သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ထဲက အသံကို လွင့်လျက် မောရှေ ကို ခေါ် တော်မူ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့ကို ဆင့်ဆို ရမည်မှာ၊ သင် တို့တွင် တစုံ တယောက်သောသူသည် ထာဝရဘုရား အား ပူဇော် သက္ကာကို ပြုလိုလျှင် ၊ ယဉ်သောတိရစ္ဆာန် တည်းဟူသောနွား ၊ သိုး ၊ ဆိတ်ကို ဆောင် ခဲ့၍ ဆက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","နွား ကို မီးရှို့ ရာယဇ် ပြုလိုလျှင်၊ အပြစ် မပါသော အထီး ကို ဆောင်ခဲ့၍၊ ထာဝရဘုရား စိတ် တော်နှင့် တွေ့ခြင်းငှါ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး အနားမှာ ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ပူဇော် သော နွား၏ခေါင်း ပေါ် မှာ မိမိ လက် ကို တင် ရသဖြင့် ၊ သူ ၏အပြစ် ကို ဖြေမည်အကြောင်း လက်ခံ တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ထာဝရဘုရား ရှေ့ တော်၌ ထိုနွား ကိုသတ် ပြီးလျှင် ၊ အာရုန် ၏သား ယဇ် ပုရောဟိတ်တို့သည် အသွေး ကိုယူ ၍၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး အနားယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ပူဇော် သောသူသည် ထိုအကောင်၏ အရေ ကို ချွတ်၍ အပိုင်းပိုင်း ဖြတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","အာရုန် ၏သား ၊ ယဇ် ပုရောဟိတ်တို့သည်၊ ယဇ် ပလ္လင်ပေါ် မှာ မီး ကိုထည့် ၍ မီး ပေါ် မှာ ထင်း ကိုခင်း ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ထင်း ပေါ် မှာ ခေါင်း ၊ ဆီဥ ၊ သား တစ်များကို တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ခြေထောက် နှင့် အအူ အစရှိသည်တို့ကို ရေ နှင့် အရင်ဆေး ရမည်။ ယဇ် ပုရောဟိတ်သည်၊ ထိုယဇ် တကောင်လုံး ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ ရမည်။ မီးရှို့ရာယဇ် ဖြစ်သတည်း။ ထာဝရဘုရား အား မီးဖြင့် ဆက်ကပ်၍ မွှေးကြိုင် သော ပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","သိုး ၊ ဆိတ် ကို မီး ရှို့ရာယဇ်ပြုလိုလျှင်၊ အပြစ် မပါသော အထီး ကို ဆောင် ခဲ့၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ထာဝရဘုရား ရှေ့ တော်၌ ယဇ် ပလ္လင်မြောက် ဘက်နား မှာ သတ် ပြီးလျှင် ၊ အာရုန် ၏သား ယဇ် ပုရောဟိတ်တို့သည်၊ အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ပူဇော်သောသူသည် အပိုင်း ပိုင်းဖြတ် ၍ ခေါင်း နှင့် ဆီဥ ကို စုထားပြီးလျှင်ယဇ် ပုရောဟိတ်သည်၊ ယဇ် ပလ္လင်ပေါ် ၌ ရှိသော ထင်း မီး အပေါ် မှာ ခင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ခြေထောက် နှင့် အအူ အစရှိသည်တို့ကို ရေ နှင့် အရင် ဆေး ရမည်။ ယဇ် ပုရောဟိတ်သည် တကောင်လုံး ကို ဆောင် ခဲ့၍ ၊ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ မီး ရှို့သော ယဇ်ဖြစ်သတည်း။ ထာဝရဘုရား အား မီး ဖြင့်ဆက်ကပ်၍ မွှေးကြိုင် သော ပူဇော်သက္ကာဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ထာဝရဘုရား အား ငှက် ကို မီး ရှို့ရာယဇ်ပြုလိုလျှင် ၊ ခို ဖြစ်စေ ၊ ချိုး ကလေး ဖြစ်စေဆောင်ခဲ့၍ ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ယဇ် ပုရောဟိတ်သည်၊ ယဇ် ပလ္လင်သို့ ဆောင် ခဲ့၍ ၊ ခေါင်း ကို လိမ် ဖြတ်ပြီးလျှင် ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ အသွေး ကို ယဇ် ပလ္လင်နား မှာ ညှစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","စာလုတ် မှစ၍စာလုတ်၌ ရှိသောအရာကို ချွတ် ပြီးလျှင် ၊ ပြာ စုထားရာအရပ် ၊ ယဇ် ပလ္လင်အရှေ့ ဘက်နား ၌ ပစ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","အတောင် ပါလျက် ငှက်ကောင်ကိုခွဲ ဖွင့်၍ ၊ ယဇ် ပုရောဟိတ်သည်၊ ယဇ် ပလ္လင်ပေါ် ၌ရှိသောထင်း မီး အပေါ် မှာ မီး ရှို့ရမည်။ မီး ရှို့သောယဇ် ဖြစ်သတည်း။ ထာဝရဘုရား အား မီး ဖြင့် ဆက်ကပ်၍ မွှေးကြိုင် သော ပူဇော်သက္ကာဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ထာဝရဘုရား အား ဘောဇဉ်ပူဇော်သက္ကာ ပြုလိုလျှင် ၊ မုန့်ညက် ကို ဆက် ရမည်။ မုန့်ညက် အပေါ် မှာ ဆီ ကိုလောင်း ၍ ၊ လောဗန် ကိုလည်း ထည့် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","အာရုန် ၏သား ယဇ်ပုရောဟိတ် ထံ သို့ဆောင် ခဲ့၍ ၊ ယဇ် ပုရောဟိတ်သည် မုန့်ညက် တလက် ဆွန်း၊ ဆီ အချို့၊ လောဗန် ရှိသမျှ ကို ယူ ၍ ၊ ထိုအတွက် အတာကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထာဝရဘုရား အား မီး ဖြင့် ဆက်ကပ်၍၊ မွှေးကြိုင် သော ပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ကျန် ကြွင်းသော ဘောဇဉ်ပူဇော်သက္ကာ မူကား ၊ အာရုန် နှင့် သူ ၏သား တို့အဘို့ ဖြစ်ရမည်။ ထာဝရဘုရား အား မီး ဖြင့် ပြုသောပူဇော်သက္ကာထဲက အလွန်သန့်ရှင်း သော အရာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","မီးဖို ၌ ဖုတ် သောမုန့်ကို ဘောဇဉ်ပူဇော်သက္ကာ ပြု လိုလျှင် ၊ ဆီ နှင့် မုန့်ညက် ဖြင့် လုပ်သော တဆေး မဲ့ မုန့် ပြားသော်၎င်း၊ ဆီ လူး သော တဆေး မဲ့ မုန့် ကြွပ်သော်၎င်းဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","သံ ပြားပူနှင့်လုပ်သောမုန့်ကို ဘောဇဉ်ပူဇော်သက္ကာ ပြုလိုလျှင် ၊ ဆီ ရော ၍ တဆေး မပါသော မုန့်ညက် နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ထိုမုန့် ကို ချိုးဖဲ့ ၍ ဆီ ကို လောင်း ရမည်။ ဘောဇဉ်ပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","အိုး ကင်းနှင့် ကြော်သောမုန့်ကို ဘောဇဉ်ပူဇော်သက္ကာ ပြုလိုလျှင် ၊ ဆီ ရောသော မုန့်ညက် နှင့် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ထို ဘောဇဉ်ပူဇော်သက္ကာ အမျိုးမျိုးတို့ကို၊ ထာဝရဘုရား အထံ တော်သို့ ဆောင် ခဲ့၍ ၊ ယဇ်ပုရောဟိတ် အား ဆက် ပြီးမှ ၊ သူသည် ယဇ် ပလ္လင်သို့ ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ထိုဘောဇဉ်ပူဇော်သက္ကာ ထဲက အတွက်အတာကို နှိုက်ယူ ၍ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထာဝရဘုရား အား မီး ဖြင့် ဆက်ကပ်၍ မွှေးကြိုင် သော ပူဇော်သက္ကာဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ကျန် ကြွင်းသော ဘောဇဉ်ပူဇော်သက္ကာ မူကား ၊ အာရုန် နှင့် သူ ၏သား တို့အဘို့ ဖြစ်ရမည်။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာထဲက အလွန်သန့်ရှင်း သော အရာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ထာဝရဘုရား အား ဆက် သော ဘောဇဉ်ပူဇော်သက္ကာ ၌ တဆေး မ ပါ ရ။ ထာဝရဘုရား အား မီး ဖြင့် ပူဇော်သက္ကာပြုသောအခါ၊ တဆေးကို မီး မ ရှို့ရ။ ပျားရည် ကိုလည်း မရှို့ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","အဦး သီးသော အသီးအနှံကို ပူဇော် သော အမှုမှာ၊ တဆေးနှင့် ပျားရည်ကို၊ ထာဝရဘုရား အား ပူဇော် ရသော်လည်း ၊ မွှေးကြိုင် ရာဘို့ ယဇ် ပလ္လင်ပေါ် မှာ မီး မ ရှို့ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ဘောဇဉ်ပူဇော်သက္ကာ ပြုလေ ရာရာ၌ ဆား ခပ်ရမည်။ သင် ပြုသောဘောဇဉ်ပူဇော်သက္ကာ ၌ ၊ သင် ၏ ဘုရား သခင်ပဋိညာဉ် ဆား ကို မ ခပ်ဘဲမနေရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","အဦး သီးသော အသီးအနှံကို၊ ထာဝရဘုရား အား ဘောဇဉ်ပူဇော်သက္ကာ ပြု လိုလျှင် ၊ စပါးနှံကို အရည်စစ် အောင် မီး နားမှာ ထား ၍၊ စပါးစေ့ကို ပွတ်ယူပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ဆီ ကိုလောင်း ၍ ၊ လောဗန် ကိုတင် လျက် ၊ ပူဇော်သက္ကာကို ပြုရမည်။ ဘောဇဉ်ပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ပွတ်ယူသော စပါး စေ့အချို့၊ ဆီ အချို့၊ လောဗန် ရှိသမျှ တည်းဟူသောထိုဘောဇဉ်ပူဇော်သက္ကာအတွက် အတာကို၊ ယဇ် ပုရောဟိတ်သည် မီး ရှို့ရမည်။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","နွား ကို မိဿဟာယ ယဇ်ပြုလိုလျှင် ၊ အပြစ် မပါသော အထီး အမ တကောင်ကောင်ကို၊ ထာဝရဘုရား ရှေ့ တော်၌ ဆက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ပူဇော် သော နွား၏ ခေါင်း ပေါ် မှာ မိမိ လက် ကို တင် ၍ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နားမှာ သတ် ပြီးလျှင် ၊ အာရုန် ၏သား ယဇ် ပုရောဟိတ်တို့သည်၊ အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","အအူ ကိုဖုံး သောဆီဥ ၊ အအူ နှင့်ဆိုင်သမျှ သောဆီဥ ၊ ခါး အတွင်းနား ၌ရှိသော ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ၊ ကျောက်ကပ် နှင့်တကွ အသည်း ပေါ်၌ ရှိသောအမြှေး တို့ကို၊ မိဿဟာယ ယဇ်ကောင် ထဲက ယူ ၍ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာဘို့ဆက်ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","အာရုန် ၏ သား တို့သည် ယဇ် ပလ္လင်အပေါ် ၌ရှိသောထင်း မီး ပေါ် မှာ တင်သော ယဇ် ကောင်နှင့်အတူ မီး ရှို့ရမည်။ ထာဝရဘုရား အား မီး ဖြင့် ဆက်ကပ်၍၊ မွှေးကြိုင် သော ပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ထာဝရဘုရား အား သိုး ၊ ဆိတ်ကို၊ မိဿဟာယ ယဇ်ပြုလိုလျှင် ၊ အပြစ် မပါသော အထီး အမ တကောင် ကောင်ကို ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","သိုးသငယ် ကို ပူဇော် လိုလျှင်၊ ထာဝရဘုရား ရှေ့ တော်၌ ဆက် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ပူဇော် သော သိုး၏ ခေါင်း ပေါ် မှာ မိမိ လက် ကို တင် ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ မှာ သတ် ပြီးလျှင် ၊ အာရုန် ၏ သား တို့သည် အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","အကောင်ဆီဥ ၊ ကျောရိုး ကတိတိဖြတ် သော အမြီး ရှိသမျှ ၊ အအူ ကို ဖုံး သော အဆီဥ ၊ အအူ နှင့် ဆိုင်သမျှ သောအဆီဥ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ခါး အတွင်းနား ၌ ရှိသော ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ၊ ကျောက်ကပ် နှင့်တကွ အသည်း ပေါ် ၌ရှိသောအမြှေး တို့ကို၊ မိဿဟာယ ယဇ်ကောင်ထဲက ယူ၍ ထာဝရဘုရား အား မီး ဖြင့် ပြုသောပူဇော်သက္ကာဘို့ ဆက် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ယဇ် ပုရောဟိတ်သည် ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာ အစာ အာဟာရ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ဆိတ် ကို ပူဇော် လိုလျှင် ၊ ထာဝရဘုရား ရှေ့ တော်၌ ဆက် ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ဆိတ် ခေါင်း ပေါ် မှာ မိမိ လက် ကိုတင် ၍ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ မှာ သတ် ပြီးလျှင် ၊ အာရုန် ၏ သား တို့သည် အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","အအူ ကို ဖုံး သော ဆီဥ ၊ အအူ နှင့်ဆိုင်သမျှ သောဆီဥ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ခါး အတွင်းနား ၌ရှိသော ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ၊ ကျောက်ကပ် နှင့်တကွ အသည်း ပေါ် ၌ရှိသောအမြှေး တို့ကို၊ မိမိ ပူဇော် သက္ကာထဲ တွင် ယူ၍ ထာဝရဘုရား အား မီး ဖြင့် ပြုသောပူဇော်သက္ကာဘို့ ဆက် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ယဇ် ပုရောဟိတ်သည် ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ မွှေးကြိုင် ရာဘို့ မီး ဖြင့် ပြုသောပူဇော်သက္ကာ အစာ အာဟာရ ဖြစ်သတည်း။ ဆီဥ ရှိသမျှ ကို ထာဝရဘုရား ဆိုင်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","သင် တို့အမျိုး အစဉ်အဆက်တို့သည်၊ နေ လေ ရာရာ၌ ဆီဥ ကိုမ စား ရ၊ အသွေး ကို မစားရဟု ထာဝရ ပညတ် တော် ဖြစ်သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","သင်သည်ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊တရားကိုမသိ၊ထာဝရဘုရား ၏ပညတ် တော်ကိုလွန်ကျူးပြစ်မှား၍မပြုအပ်သောအမှုကိုပြုမိသည်အရာတွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ဘိသိက် ခံသော ယဇ် ပုရောဟိတ်သည် လူ များကို အပြစ် ထဲ သို့ သွေးဆောင်၍ ကိုယ်တိုင်ပြစ်မှား လျှင် ၊ ထို အပြစ် အတွက် အပြစ် ဖြေရာယဇ်ဘို့ အပြစ် မပါ၊ အသက်ပျို သော နွား ထီးကို၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး နား ၊ ထာဝရဘုရား ရှေ့ တော် သို့ ဆောင် ခဲ့၍ ၊ ထာဝရဘုရား အား ဆက် ရမည်။ ထိုအခါ နွား ၏ခေါင်း ပေါ်မှာ မိမိ လက် ကို တင် ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ နွား ကို သတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ဘိသိက် ခံသော ယဇ် ပုရောဟိတ်သည်၊ နွား ၏ အသွေး ကို ယူ ၍ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ ဆောင် ခဲ့ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","မိမိ လက်ညှိုး ကို အသွေး ၌ နှစ် ၍ သန့်ရှင်း ရာဌာနတော် ကုလားကာ ရှေ့ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ခုနစ် ကြိမ် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","တဖန် ယဇ် ပုရောဟိတ်သည်၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အတွင်း ၊ ထာဝရဘုရား ရှေ့ တော်မှာ ရှိသောနံ့သာ ပေါင်းမွှေးကို မီးရှို့ရာ ပလ္လင် ဦးချို တို့၌ နွားအသွေး ကို ထည့် ၍ ၊ ကြွင်းသော အသွေး ကို၊ ပရိသတ် စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့၌ရှိသော မီး ရှို့ရာ ယဇ်ပလ္လင်ခြေရင်း နားမှာ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","မိဿဟာယ ယဇ် ပြုသောနွား ၏ဆီဥကိုယူ သကဲ့သို့ ၊ အပြစ် ဖြေရာ ယဇ်ပြုသောနွားအအူ ကို ဖုံး သော ဆီဥ ၊ အအူ နှင့် ဆိုင်သမျှ သောဆီဥ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ခါး အတွင်းနား ၌ရှိသော ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ၊ ကျောက်ကပ် နှင့်တကွ အသည်း ပေါ် ၌ရှိသောအမြှေး တည်းဟူသော၊ နွား ဆီဥ ရှိသမျှ ကို ယူ၍၊ မီးရှို့ရာယဇ် ပလ္လင် ပေါ်မှာ ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","နွား ၏ခေါင်း ၊ ခြေထောက် ၊ အအူ ၊ ချေးနု နှင့်တကွအရေ ၊ အသား ရှိသမျှ တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","နွား တကောင်လုံး ကို၊ တပ် ပြင် မှာ ပြာ သွန် ထားရာ ရှင်းလင်း သော အရပ် သို့ ယူ သွား၍ ထင်း အပေါ် ၌ မီး ရှို့ရမည်။ ပြာ သွန် ၍ ထားရာအရပ်၌ မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ဣသရေလ အမျိုးသားပရိသတ် အပေါင်း တို့သည် တရားကိုမသိ၊ အကျိုးအပြစ်ကို မရိပ်မိဘဲ၊ ထာဝရဘုရား ၏ ပညတ် တော်ကို လွန်ကျူး ပြစ်မှား၍ မ ပြု အပ်သောအမူကို ပြု မိသဖြင့် အပြစ်ရောက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ထိုသို့ ပြစ်မှား မိသော အပြစ် ကိုသိ သောအခါ ၊ ထိုအပြစ် အတွက် ပရိသတ် တို့သည် အသက်ပျို သော နွား ထီးကို၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ သို့ ဆောင် ခဲ့၍ ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ပရိသတ် တွင် အသက် ကြီးသောသူတို့ သည်၊ ထာဝရဘုရား ရှေ့ တော်၌ မိမိ တို့လက် ကို နွား ခေါင်း ပေါ် မှာ တင် ၍ ၊ ထိုနွား ကို ရှေ့ တော်၌ သတ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ဘိသိက် ခံသော ယဇ် ပုရောဟိတ်သည် နွား အသွေး ကို ပရိသတ် စည်းဝေး ရာ တဲ တော်သို့ ဆောင် ခဲ့ ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","မိမိ လက်ညှိုး ကို အသွေး ၌ နှစ် ၍ ၊ ကုလားကာ ရှေ့ ထာဝရဘုရား ရှေ့ တော်၌ ခုနစ် ကြိမ် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","တဖန် ယဇ်ပုရောဟိတ်သည်၊ ပရိတ်သတ်စည်းဝေး ရာ တဲ တော်အတွင်း ၊ ထာဝရဘုရား ရှေ့ တော်မှာ ရှိသောပလ္လင် ဦးချို တို့၌ အသွေး ကို ထည့် ၍ ၊ ကြွင်းသောအသွေး ကို၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့၌ရှိသော မီး ရှို့ရာယဇ်ပလ္လင်ခြေရင်း နားမှာ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","နွားဆီဥ ရှိသမျှ ကို ယူ ၍ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","အပြစ် ဖြေရာ ယဇ်ပြုသောနွား ကို ပြု သကဲ့သို့ ၊ ထိုနည်းတူဤနွား ကို ပြု သဖြင့် ၊ ယဇ် ပုရောဟိတ်သည် လူ များတို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ သူ တို့အပြစ် လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ထိုနောက်မှနွား ကို တပ် ပြင် သို့ ဆောင် သွား၍ ၊ အရင် နွား ကို မီး ရှို့သကဲ့သို့ ရှို့ ရမည်။ ပရိသတ် အဘို့ အပြစ် ဖြေစရာ ယဇ်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","မင်း သည်လည်း တရားကိုမသိ၊ မိမိ ဘုရား သခင် ထာဝရဘုရား ၏ ပညတ် တော်ကို လွန်ကျူး ပြစ်မှား၍ မ ပြု အပ်သော အမှုကို ပြု မိသဖြင့် အပြစ် ရောက်လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","မိမိ ပြစ်မှား မိသော အပြစ် ကို သိ သောအခါ ၊ အပြစ် မပါသော ဆိတ် သငယ် အထီး ကို ပူဇော် သက္ကာဘို့ ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ဆိတ် ခေါင်း ပေါ် မှာ မိမိ လက် ကိုတင် ၍ ထာဝရဘုရား ရှေ့ တော်၌ မီး ရှို့ရာယဇ်ကောင်သတ် ရာအရပ် တွင် သတ် ရမည်။ အပြစ် ဖြေရာ ယဇ်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ယဇ် ပုရောဟိတ်သည် ထိုအပြစ် ဖြေရာယဇ်၏ အသွေး ကို လက်ညှိုး နှင့် ယူ ၍ မီး ရှို့ရာ ယဇ်ပလ္လင်ဦးချို တို့၌ ထည့် ပြီးမှ ၊ ကြွင်းသော အသွေး ကို ထိုပလ္လင် ခြေရင်း နား၌ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","မိဿဟာယ ယဇ်ကောင်ဆီဥ ကို ပြုသကဲ့သို့ ဆီဥ ရှိသမျှ ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထိုသို့ ယဇ် ပုရောဟိတ်သည် မင်း ၏ အပြစ် အတွက် အပြစ် ဖြေခြင်းကိုပြုလျှင် ၊ သူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ဆင်းရဲသားတစုံတယောက်သည် တရားကို မသိ၊ ထာဝရဘုရား ၏ ပညတ် တော်ကို လွန်ကျူး ပြစ်မှား ၍ ၊ မပြု အပ်သော အမှုကို ပြု မိသဖြင့် အပြစ် ရောက်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","မိမိ ပြစ်မှား မိသော အပြစ် ကို သိ သောအခါ ၊ ထိုအပြစ် အတွက် ပူဇော် သက္ကာဘို့ အပြစ် မပါသော ဆိတ် သငယ် အမ ကို ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","အပြစ် ဖြေရာ ယဇ်ပြုသောဆိတ်ခေါင်း ပေါ် မှာ မိမိ လက် ကိုတင် ၍ မီး ရှို့ရာယဇ်ကောင်ကိုသတ် ရာအရပ် ၌ ထိုဆိတ်ကိုသတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ယဇ် ပုရောဟိတ်သည် အသွေး ကို လက်ညှိုး နှင့် ယူ ၍ မီး ရှို့ရာ ယဇ်ပလ္လင်ဦးချို တို့၌ ထည့် ပြီးမှ ၊ ကြွင်းသော အသွေး ကို ယဇ် ပလ္လင်ခြေရင်း နား၌ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","မိဿဟာယ ယဇ် ကောင်ဆီဥ ကို ယူ သကဲ့သို့ ၊ ဆီဥ ရှိသမျှ ကို ယူ ၍ ထာဝရဘုရား အား မွှေးကြိုင် စရာ ဘို့ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထိုသို့ ယဇ် ပုရောဟိတ်သည် ထိုသူ အဘို့ အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ သူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","သိုးသငယ် ကို အပြစ် ဖြေရာယဇ် ပြုလိုလျှင် ၊ အပြစ် မပါသော အမ ကို ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","အပြစ် ဖြေရာ ယဇ်ပြုသောသိုးခေါင်း ပေါ် မှာ မိမိ လက် ကို တင် ၍ မီး ရှို့ရာယဇ်ကောင်ကိုသတ် ရာအရပ် ၌ အပြစ် ဖြေရာယဇ်ဖြစ်စေခြင်းငှါသတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ယဇ် ပုရောဟိတ်သည်၊ ထိုယဇ် ကောင် အသွေး ကို လက်ညှိုး နှင့် ယူ ၍ မီး ရှို့ရာ ယဇ်ပလ္လင်ဦးချို တို့၌ ထည့် ပြီးမှ ဖြန်းသော အသွေး ကို ထိုပလ္လင် ခြေရင်း နား၌ သွန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","မိဿဟာယ ယဇ် ကောင် သိုးသငယ် ဆီဥ ကို ပြုသကဲ့သို့ ၊ ဆီဥ ရှိသမျှ ကို ယူ၍ ၊ ထာဝရဘုရား အား မီး ဖြင့် ပူဇော်သက္ကာနှင့်အတူယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ထိုသို့ ယဇ် ပုရောဟိတ်သည် ထိုသူ ပြစ်မှား မိသော အပြစ် အတွက် အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ သူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","တစုံ တယောက်သောသူသည် အမှုကို မြင် သည်ဖြစ်စေ ၊ သိ သည်ဖြစ်စေ ၊ ကျိန်ဆို စေသော စကား ကို ကြား ၍ ၊ သက်သေ ဖြစ်လျက်နှင့် ပြန်မ ပြော ဘဲနေသဖြင့် ပြစ်မှား ၍ ၊ မိမိ ဒုစရိုက် အပြစ်ကို ခံရ သော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","တစုံ တယောက်သောသူ သည် မ စင်ကြယ်သော သားရဲ ၊ သားယဉ်၊ တွား တတ်သော တိရစ္ဆာန်၏ အသေ ကောင် အစရှိသော မ စင်ကြယ်သော အရာ တစုံ တခုကို အမှတ်တမဲ့ထိမိ သဖြင့် ၊ မ စင်ကြယ်ရာသို့ ရောက်၍ အပြစ် ရှိသော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","လူ ၌ ကပ်သော မ စင်ကြယ်သော အရာတစုံတခုကို လည်း မသိဘဲ ထိမိ ၍ နောက်တဖန် သိလျှင်၊ အပြစ်ရှိရာသို့ ရောက်သော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","တစုံ တယောက်သောသူသည် ကောင်း သောအမှု၊ မ ကောင်းသောအမှုကို ပြုမည်ဟု အကျိုးအပြစ် ကို မသိဘဲ ကျိန်ဆို လျက် သစ္စာပြု၍ နောက်တဖန်သိလျှင် ၊ အရင်ကျိန်ဆိုလျက် သစ္စာ ပြုလေရာရာ၌ အပြစ် တစုံ တခုရောက်သော်၎င်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ထိုသို့သောအပြစ် တစုံ တခုရောက်လျှင် ၊ ထိုအပြစ် ကို ဘော်ပြ တောင်းပန်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ပြစ်မှား မိသော အပြစ် အတွက် အပြစ် ဖြေရာ ယဇ်ဖြစ်စေခြင်းငှါသိုးသငယ် ဖြစ်စေ ၊ ဆိတ် သငယ် ဖြစ်စေ၊ အမ တကောင်ကောင်တည်းဟူသောဒုစရိုက် ဖြေရာယဇ်ကို ထာဝရဘုရား အထံ တော်သို့ ဆောင် ခဲ့ပြီးလျှင် ၊ ယဇ် ပုရောဟိတ်သည် ထိုသူ ၏ အပြစ် အတွက် အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","သိုးသငယ် ကို မ တတ် နိုင်လျှင် ၊ ပြစ်မှား မိသော အပြစ်အတွက် အပြစ် ဖြေရာယဇ်ဘို့ တကောင်၊ မီး ရှို့ရာယဇ်ဘို့ တကောင် ၊ ခို နှစ် ကောင်၊ သို့မဟုတ် ချိုး ကလေး နှစ် ကောင်ကို ထာဝရဘုရား အထံတော်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ယဇ်ပုရောဟိတ် ရှေ့ သို့ ဆောင် ခဲ့ရမည်။ ယဇ်ပုရောဟိတ်သည် အပြစ် ဖြေရာ ယဇ်ကောင်ကို အရင် ပူဇော် လျက် ၊ ခေါင်း ကိုလိမ် ၍ ဖြတ်ရမည်။ ကိုယ်ကို ရှင်းရှင်းမ ခွဲ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ထိုအပြစ် ဖြေရာ ယဇ်ကောင်အသွေး ကို ယဇ် ပလ္လင်နံရံ ၌ ဖြန်း ၍ ၊ ကြွင်း သော အသွေး ကို ယဇ် ပလ္လင်ခြေရင်း နားမှာ ညှစ် ရမည်။ အပြစ် ဖြေရာယဇ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ဒုတိယ ငှက်ကောင်ကို၊ ပညတ် တရားအတိုင်း မီး ရှို့ရာ ယဇ်ပူဇော် ရမည်။ ထိုသို့ ယဇ် ပုရောဟိတ်သည်၊ ထိုသူ ပြစ်မှား မိသော အပြစ် အတွက် အပြစ် ဖြေခြင်းကိုပြုလျှင် ၊ သူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ခို နှစ် ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ် ကောင်ဖြစ်စေ၊ တခုခုကို မ တတ် နိုင်လျှင် ၊ ပြစ်မှား သော သူ သည် အပြစ် ဖြေရာယဇ် အရာ၌ မုန့်ညက် တဩမဲကို ဆောင် ခဲ့၍ ဆက်ရမည်။ အပြစ်ဖြေရာယဇ် ဖြစ်သောကြောင့် ဆီ ကို မ လောင်း ရ။ လောဗန် ကို မ တင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ယဇ်ပုရောဟိတ် ထံ သို့ဆောင် ခဲ့ပြီးလျှင် ၊ ယဇ် ပုရောဟိတ်သည် မုန့်ညက်တလက် ဆွန်းတည်းဟူသောပူဇော်သက္ကာအတွက် အတာကိုယူ ၍ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာနှင့်အတူယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ အပြစ် ဖြေရာယဇ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ထိုသို့ ယဇ် ပုရောဟိတ်သည်၊ ထိုသူ ပြစ်မှား မိသော အပြစ် တစုံ တခုအတွက် အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ သူ ၏ အပြစ်လွှတ် လိမ့်မည်။ ကြွင်းသောအရာသည် ဘောဇဉ်ပူဇော်သက္ကာ ကဲ့သို့ ၊ ယဇ်ပုရောဟိတ် အဘို့ ဖြစ် သည်ဟု မောရှေအား မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","တစုံတယောက် သောသူသည် တရားကိုမသိ၊ ထာဝရဘုရား နှင့်ဆိုင်သောအရာတို့၌ လွန်ကျူး ပြစ်မှား မိလျှင်၊ ထိုပြစ်မှား ခြင်းအတွက် ဒုစရိုက်ဖြေရာယဇ် တည်းဟူသောအပြစ် မပါသော သိုးထီး ကို၎င်း၊ အကျပ် တော်အလိုက် ချင့်တွက် ၍ ချိန်သော အလျော်ငွေကို၎င်း၊ ထာဝရဘုရား အထံ တော်သို့ ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ထိုသို့ ဘုရား နှင့်ဆိုင်သော အရာ၌ ပြစ်မှား မိရာကို ပြုပြင် ပြီးလျှင် ၊ ငါး စုတစုကိုလည်း ထပ် ၍ယဇ်ပုရောဟိတ် အား ပေး ရမည်။ ယဇ် ပုရောဟိတ်သည်လည်း ၊ ဒုစရိုက် ဖြေရာယဇ်ဖြစ်သော သိုး အားဖြင့် ၊ ထိုသူ အဘို့ အပြစ် ဖြေခြင်းကို ပြုလျှင်၊ သူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","တစုံ တယောက်သောသူသည်၊ ထာဝရဘုရား ပညတ် တော်မူသောအမှုတစုံ တခုကို ပြု ၍ ပြစ်မှား မိလျှင် ၊ ကိုယ်ပြစ်မှားမှန်းကို မ သိ သော်လည်း အပြစ် ရောက်၍ ထိုအပြစ် ကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ဒုစရိုက် ဖြေရာယဇ်ကိုပြုခြင်းငှါ ချင့်တွက်သော အလျော်ငွေ နှင့်တကွ၊ အပြစ် မပါသော သိုး ထီးကို ဆောင် ခဲ့ရမည်။ တရားကိုမသိ ပြစ်မှား မိသော်လည်း ၊ ကိုယ်ပြစ်မှားမှန်းကို မ သိ သောသူ အဘို့ ယဇ် ပုရောဟိတ်သည် အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ ထိုသူ ၏ အပြစ်လွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ဒုစရိုက် ဖြေသောယဇ် ဖြစ်သတည်း။ အကယ်စင်စစ်ထိုသူ သည် ထာဝရဘုရား ကို ပြစ်မှား ရာ ရောက်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","တစုံ တယောက်သောသူသည် သူတပါး အပ်နှံ သော ဥစ္စာအတွက် ပေါင် ထားသော ဥစ္စာအတွက် ၊ မိမိနှင့် စပ်ဆိုင်သောသူအား မုသား စကားကို ပြောသော်၎င်း ၊ သူဥစ္စာကို အနိုင် အထက်ယူသော်၎င်း၊ မိမိ နှင့် စပ်ဆိုင် သောသူကို လှည့်စား သော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ပျောက်သောဥစ္စာ ကို တွေ့ သောအခါ ၊ မုသာ စကားကိုပြော၍ မ ဟုတ်မမှန်ဘဲ ကျိန်ဆို သော်၎င်း ၊ ထိုသို့သော ဒုစရိုက်တစုံ တခုကို ပြု ၍ ထာဝရဘုရားကို ပြစ်မှားမိလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ထိုသူသည် ပြစ်မှား ၍ အပြစ် ရောက်သောကြောင့် ၊ အနိုင် အထက်ယူသော ဥစ္စာ ၊ လှည့်စား ၍ ရသော ဥစ္စာ ၊ သူတပါး အပ်နှံ သော ဥစ္စာ၊ ပျောက် ၍တွေ့ သော ဥစ္စာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","မ ဟုတ်မမှန်ဘဲ ကျိန်ဆို ၍ ရသောဥစ္စာ အဘိုးနှင့်တကွ၊ ငါး စုတစုကို ထပ် ၍ဒုစရိုက် ဖြေသော ယဇ်ပူဇော်သောနေ့ ၌ ဥစ္စာရှင်အား ပြန်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ဒုစရိုက် ဖြေရာယဇ်ကို ပြုခြင်းငှါ ချင့်တွက်သော အလျော်ငွေနှင့်တကွ၊ ဒုစရိုက် ဖြေရာယဇ်တည်းဟူသော အပြစ် မပါသော သိုး ထီးကို၊ ထာဝရဘုရား ထံ တော်၊ ယဇ်ပုရောဟိတ် ရှေ့သို့ ဆောင်ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ယဇ် ပုရောဟိတ်သည် ထိုသူ အဘို့ ထာဝရဘုရား ရှေ့ တော်၌ အပြစ် ဖြေခြင်းကို ပြုလျှင် ၊ သူပြစ်မှားသမျှ သောအပြစ် လွတ် လိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","သင်သည် အာရုန် နှင့် သူ ၏သား တို့အား ဆင့်ဆို ရသော မီး ရှို့ရာ ယဇ်ပူဇော်ခြင်းတရား ဟူမူကား ၊ ယဇ်ကောင်ကိုယဇ် ပလ္လင်ထင်းမီးပေါ် မှာ တညဉ့်လုံး နံနက် တိုင်အောင် ရှိစေ၍၊ ယဇ် ပလ္လင်မီး သည် အစဉ်လောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ယဇ် ပုရောဟိတ်သည် ပိတ် အင်္ကျီ ၊ ပိတ် ပေါင်းဘီ ကို ဝတ် လျက် ၊ ယဇ် ပလ္လင်ပေါ် မှာ ကျွမ်းလောင် သော မီးရှို့ ရာ ယဇ်ပြာ ကို ကျုံး ၍ ပလ္လင် အနား မှာထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","တဖန် အဝတ် ကိုလဲ ၍ ၊ ထိုပြာ ကို တပ် ပြင် ၌ ရှင်းလင်း သောအရပ် သို့ ယူ သွားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ယဇ် ပလ္လင်မီး သည် မ သေ ဘဲ အစဉ်လောင် ရမည်။ ယဇ် ပုရောဟိတ်သည် နံနက် တိုင်း ထင်း မီးထည့်၍၊ ထင်းပေါ် မှာ မီး ရှို့ရာယဇ်ကို ခင်း ရမည်။ ထိုပလ္လင်ပေါ် မှာလည်း ၊ မိဿဟာယ ယဇ်ဆီဥ ကို မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ယဇ် ပလ္လင်မီး သည် အလျှင်းမ သေ ဘဲ၊ အစဉ် မပြတ်လောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ဘောဇဉ်ပူဇော်သက္ကာ တရား ဟူမူကား ၊ အာရုန် ၏သား တို့သည် ထိုပူဇော်သက္ကာကို ထာဝရဘုရား ထံ တော်၊ ယဇ် ပလ္လင်ရှေ့ မှာ ပူဇော် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ဘောဇဉ်ပူဇော်သက္ကာ မုန့်ညက် တလက်ဆွန်း၊ ဆီ အချို့၊ လောဗန် ရှိသမျှ တည်းဟူသော ပူဇော် သက္ကာ အတွက်အတာကိုယူ ၍ ထာဝရဘုရား အား မွှေးကြိုင် စရာဘို့ ယဇ် ပလ္လင်ပေါ်မှာ မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ကြွင်း သောအရာတို့ကို၊ အာရုန် နှင့် သူ ၏သား တို့သည်၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ဝင်း အတွင်း တွင် ၊ သန့်ရှင်း ရာဌာန ၌ တဆေး မပါဘဲ စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ထိုမုန့်ညက်ကို တဆေး ထည့်၍ မုန့်မ လုပ် ရ။ မီး ဖြင့် ငါ့ အား ပြုသောပူဇော်သက္ကာထဲက ထိုမုန့်ညက်ကို သူ တို့အဘို့ ဖြစ်စေခြင်းငှါငါပေး ပြီ။ အပြစ် ဖြေရာယဇ်၊ ဒုစရိုက် ဖြေရာယဇ်ကဲ့သို့ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","အာရုန် ၏ သား ယောက်ျား အပေါင်း တို့သည် စား ရကြမည်။ မီး ဖြင့် ထာဝရဘုရား အား ပြုသောပူဇော်သက္ကာကို ကိုင် သောသူအပေါင်း တို့သည် သန့်ရှင်း ရကြမည်ဟု သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် တော် ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","တဖန် ထာဝရဘုရား သည်၊ မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","အာရုန် နှင့် သူ ၏သား တို့သည် ဘိသိက် ခံသောနေ့ မှစ၍ ထာဝရ ဘောဇဉ်ပူဇော်သက္ကာ ဖြစ်စေခြင်းငှါ၊ မုန့်ညက် တဩမဲကို၊ နံနက် တဝက် ၊ ည တဝက် ထာဝရဘုရား အား ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ထိုမုန့်ညက်ကို ဆီထည့်၍ သံပြား ပူနှင့် မုန့်လုပ် ပြီးမှ၊ ဆောင် ခဲ့၍ ချိုးဖဲ့ သဖြင့် ဘောဇဉ်ပူဇော်သက္ကာ အကျိုး အပဲ့တို့ကို ထာဝရဘုရား အား မွှေးကြိုင် စရာဘို့ ပူဇော် ");
INSERT INTO myajvb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","အာရုန် အရာ ၌ ဘိသိက် ခံသော သား သည်လည်း၊ ထိုပူဇော်သက္ကာကို ပြု ရမည်။ ထာဝရဘုရား အဘို့ ထာဝရ ပညတ် တော် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ယဇ်ပုရောဟိတ် အတွက် ပြုသောဘောဇဉ်ပူဇော်သက္ကာ ရှိသမျှ ကို အကုန် အစဉ် မီး ရှို့ရမည်။ အလျှင်း မ စား ရဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","တဖန် မောရှေ အား ထာဝရဘုရား မိန့် တော်မူသည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","သင်သည် အာရုန် နှင့် သူ ၏သား တို့အား ဆင့်ဆို ရသော အပြစ် ဖြေရာယဇ် ပူဇော်ခြင်းတရား ဟူမူကား ၊ မီး ရှို့ရာယဇ်ကောင်သတ် ရာအရပ် ၌ ထာဝရဘုရား ရှေ့ တော်မှာ အပြစ် ဖြေရာယဇ်ကိုသတ် ရမည်။ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","အပြစ် ဖြေဘို့ ပူဇော်သော ယဇ် ပုရောဟိတ်သည်၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ဝင်း အတွင်းတွင် သန့်ရှင်း ရာဌာန ၌ စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ထိုအသား ကို ထိ သမျှ သည် သန့်ရှင်း ၏။ အသွေး ဖြန်း သမျှသောအဝတ် တို့ကို သန့်ရှင်း ရာဌာန ၌ လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ထိုအသားပြုတ် သော မြေ အိုး ကို ခွဲ ရမည်။ ကြေးဝါ အိုး ဖြစ်လျှင် ပွတ် ၍ ရေ နှင့် ဆေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ယဇ် ပုရောဟိတ်ယောက်ျား အပေါင်း တို့သည် စား ရကြမည်။ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","အပြစ် ဖြေရာယဇ် အသွေး ကို သန့်ရှင်း ရာဌာန၌ အပြစ် ဖြေခြင်းငှါ ၊ ပရိတ်သတ်စည်းဝေး ရာ တဲ တော်အတွင်း သို့ ဆောင် ခဲ့လျှင် ၊ ထိုယဇ်အသားကို မ စား ရ။ မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ဒုစရိုက် ဖြေသော ယဇ်ပူဇော်ခြင်းတရား ဟူမူကား ၊ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","မီး ရှို့ရာယဇ်ကောင်ကိုသတ် ရာအရပ် ၌ ဒုစရိုက် ဖြေသော ယဇ်ကောင်ကိုသတ် ၍ အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","အမြီး နှင့်တကွ အအူ ကို ဖုံး သောဆီဥ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ခါး အတွင်းနား ၌ ရှိသော ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ၊ ကျောက်ကပ် နှင့်တကွ အသည်း ပေါ် ၌ရှိသောအမြှေး တည်းဟူသောဆီဥ ရှိသမျှ ကိုယူ ၍ ဆက် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ယဇ် ပုရောဟိတ်သည် ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့၍ ထာဝရဘုရား အား မီး ဖြင့် ပူဇော်သက္ကာပြုရမည်။ ဒုစရိုက် ဖြေရာယဇ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","အသားကို ယဇ် ပုရောဟိတ်ယောက်ျား အပေါင်း တို့သည်၊ သန့်ရှင်း ရာဌာန ၌ စား ရကြမည်။ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","အပြစ် ဖြေရာယဇ်၊ ဒုစရိုက် ဖြေရာယဇ်၏ တရား တပါး တည်းဖြစ်၍၊ ဒုစရိုက် အပြစ် ဖြေခြင်းကို ပြုသော ယဇ် ပုရောဟိတ်သည် ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","လူ တစုံတယောက်ပြုသောမီး ရှို့ရာယဇ်ကို ပူဇော် သော ယဇ် ပုရောဟိတ်သည်၊ မိမိပူဇော် သော ယဇ် ကောင်အရေ ကိုယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","မီးဖို ၌ ဖုတ် သော ဘောဇဉ်ပူဇော်သက္ကာ ၊ အိုး ကင်း၊ သံပြား ပူနှင့် လုပ် သော အရာရှိသမျှ ကို ပူဇော် သော ယဇ် ပုရောဟိတ်သည် ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ဆီ ထည့် သည်ဖြစ်စေ ၊ မ ထည့်သည်ဖြစ်စေ၊ ဘောဇဉ်ပူဇော်သက္ကာ ရှိသမျှ ကို အာရုန် ၏ သား အပေါင်း တို့သည် အညီအမျှ ယူရကြရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","ထာဝရဘုရား အား ပြုရသော မိဿဟာယ ယဇ် ပူဇော်ခြင်းတရား ဟူမူကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ကျေးဇူး တော်ဝန်ခံဘို့ ရာပူဇော် လျှင် ၊ ကျေးဇူး တော် ဝန်ခံရာယဇ်နှင့်တကွ ဆီ ရော သော တဆေး မဲ့ မုန့်ပြား ၊ ဆီ နှင့် လုပ် သော တဆေး မဲ့မုန့်ကြွပ် ၊ ဆီ ရော သော မုန့်ညက် နှင့် လုပ်၍ ကြော် သော မုန့်ပြား တို့ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ထိုမုန့်ပြားမှတပါး၊ မိဿဟာယ ပူဇော်သက္ကာနှင့်ဆိုင်သော ကျေးဇူး တော်ဝန်ခံရာယဇ်နှင့်တကွ ၊ တဆေး ပါသောမုန့် ကိုလည်း ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ပူဇော် သက္ကာရှိသမျှ အထဲ က မုန့်တလုံး ကို ထာဝရဘုရား အား ချီမြှောက်သော ပူဇော် သက္ကာပြု၍ ထိုမုန့်ကို မိဿဟာယ ယဇ် အသွေး ဖြန်း သောယဇ် ပုရောဟိတ် ယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ကျေးဇူး တော်ဝန်ခံဘို့ရာပူဇော်သော မိဿဟာယ ယဇ်အသား ကို၊ ပူဇော် သောနေ့ ခြင်းတွင် စား ရမည်။ နံနက် တိုင်အောင် မ ကြွင်း စေရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","သို့မဟုတ် သစ္စာ ပြု၍ ယဇ် ပူဇော် သည်ဖြစ်စေ ၊ ကိုယ် အလိုအလျောက်ပူဇော်သည်ဖြစ်စေ၊ ပူဇော် သောနေ့ ခြင်းတွင် ၊ ယဇ် အသားကို စား ၍ အကြွင်း ကိုလည်း နက်ဖြန် နေ့စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ကြွင်း သေးသော အသား ကိုလည်း သန်ဘက် နေ့ ၌ မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","မိဿဟာယ ယဇ် အသား အနည်းငယ်ကို၊ သန်ဘက် နေ့ ၌ စား မိလျှင် စိတ် တော်နှင့်မ တွေ့။ ပူဇော် သောသူ သည် အကျိုး ကိုမ ရ။ ရွံရှာ ဘွယ် ဖြစ် လိမ့်မည်။ စား သောသူ သည် ကိုယ် အပြစ် ကိုခံရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","မ စင်ကြယ်သောအရာနှင့် ထိမိ သော ယဇ်သား ကို မ စား ရ။ မီး ရှို့ ရမည်။ စင်ကြယ် သောသူ တို့ သာလျှင် ထိုယဇ်သား ကို စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ထာဝရဘုရား နှင့် ဆိုင်သော မိဿဟာယ ယဇ်သား ကို အကြင် သူသည် မ စင်ကြယ်သော အပြစ်ရှိ လျက်နှင့် စား မိ၏။ ထို သူ ကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","အကြင်သူသည်လည်း၊ လူ ၌ မ စင်ကြယ်သော အရာ၊ မ စင်ကြယ်သောသား ၊ မ စင်ကြယ်သော ပိုးရွ အစ ရှိသော မ စင်ကြယ်သောအရာ တစုံ တခုကို ထိမိ ၍ ၊ ထာဝရဘုရား နှင့် ဆိုင်သော မိဿဟာယ ယဇ်သား ကို စား ၏။ ထို သူ ကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင်တို့သည် သိုး ၊ ဆိတ် ၊ နွား ဆီဥ ကို အလျှင်း မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","အလိုလို သေသော တိရစ္ဆာန်ဆီဥ ၊ သားရဲ ကိုက်၍ သေသော တိရစ္ဆာန်ဆီဥ ကို အခြားသို့ သုံး ရသော်လည်း၊ အလျှင်းမ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","အကြင်သူသည် ထာဝရဘုရား အား မီး ဖြင့် ပူဇော်သက္ကာပြု သော တိရစ္ဆာန် ဆီဥ ကို စား ၏။ ထိုသူ ကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","သင် တို့သည် နေ လေ ရာရာ၌ ငှက် သွေး၊ သား သွေးမှစ၍ အသွေး မည်မျှကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","အကြင် သူသည် တစုံ တခုသောအသွေး ကို စား ၏။ ထို သူ ကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ထာဝရဘုရား အား မိဿဟာယ ယဇ် ကို ပူဇော် သောသူသည်၊ မိမိ ပူဇော် သော ယဇ်အထဲ က၊ ထာဝရဘုရား အား ဆက် ဘို့ရာဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ထာဝရဘုရား ရှေ့ တော်၌ ရင်ပတ် ကိုချီလွှဲ ၍၊ ချီလွှဲ သော ပူဇော်သက္ကာ ပြုစေခြင်းငှါ ၊ ရင်ပတ် နှင့် ဆီဥ တည်းဟူသောမီး ဖြင့် ထာဝရဘုရား အား ပူဇော်သောအရာကို ကိုယ်တိုင် ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ယဇ် ပုရောဟိတ်သည်၊ ဆီဥ ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့၍ ၊ ရင်ပတ် ကို အာရုန် နှင့် သူ ၏သား တို့သည် ယူရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","မိဿဟာယ ယဇ်ထဲက လက်ျာ ပခုံး ကို ချီမြှောက်သော ပူဇော် သက္ကာဘို့ ယဇ်ပုရောဟိတ် အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","မိဿဟာယ ယဇ် အသွေး နှင့် ဆီဥ ကို၊ အာရုန် ၏သား တို့တွင် ပူဇော် သောသူသည်၊ လက်ျာ ပခုံး ကို မိမိ အဘို့ ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ဣသရေလ အမျိုးသား တို့ပြုသောမိဿဟာယ ယဇ်များထဲက ချီလွှဲ သော ရင်ပတ် ၊ ချီမြှောက်သော ပခုံး ကို ငါနှုတ် ယူ၍ ဣသရေလ အမျိုးသား တို့တွင် ယဇ်ပုရောဟိတ် အာရုန် နှင့် သူ ၏သား တို့အား ထာဝရ ပညတ် တော်အားဖြင့် ငါပေး ပြီဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ထိုသို့ အာရုန် နှင့် သူ ၏သား တို့သည်၊ ထာဝရဘုရား ရှေ့တော်မှာ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်ရွက် မည်အကြောင်း၊ သူတို့ကို ခန့် ထားသောနေ့ ၌ ၊ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာများထဲက ၊ သူတို့ခံရသောအဘို့ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ဣသရေလ အမျိုးသား တို့လက်မှ ထိုသို့သောအဘို့ကိုခံရမည်အကြောင်း၊ သူ တို့ကို ဘိသိက် ပေးတော်မူသောနေ့ ၌ ၊ ထာဝရဘုရား မှာ ထားတော်မူ၏။ သူ တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ဤ ရွေ့ကား၊ ဣသရေလ အမျိုးသား တို့သည်၊ သိနာ တော ၌ ထာဝရဘုရား အား ပူဇော် သက္ကာပြုရမည် အကြောင်းမှာ ထားတော်မူသောနေ့ ၌ သိနာ တောင် ပေါ် မှာ ထာဝရဘုရား သည် မောရှေ အား ပေးတော်မူသောမီး ရှို့ရာယဇ်တရား ၊ ဘောဇဉ်ပူဇော်သက္ကာ တရား၊ အပြစ် ဖြေရာယဇ်တရား၊ ဒုစရိုက် ဖြေရာ ယဇ်တရား၊ အရာ ၌ ခန့်ထားရာ ယဇ်တရား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","မိဿဟာယ ယဇ်တရား ဖြစ်သတည်းဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","တဖန် ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","သင်သည် အာရုန် နှင့် သူ ၏သား များ၊ အဝတ် များ၊ လိမ်း ရန်ဆီ ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ နွား ထီး၊ သိုး ထီးနှစ် ကောင်၊ တဆေး မဲ့ မုန့်တတောင်း ကိုယူ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့သို့ ပရိသတ် အပေါင်း ကို စည်ဝေး စေလော့ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","မောရှေ ပြု ၍ ၊ ပရိသတ် တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့မှာ စည်းဝေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","မောရှေ ကလည်း ၊ ဤသို့ ထာဝရဘုရား မှာ ထား တော်မူပြီဟု ပရိသတ် တို့အား ပြောဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ အာရုန် နှင့် သူ ၏သား တို့ကို ခေါ် ခဲ့၍ ရေချိုး ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","အာရုန်ကို အင်္ကျီ ဝတ် စေ၍ ၊ ခါးပန်း ကို စည်း စေလေ၏။ ဝတ်လုံ နှင့် သင်တိုင်း ကိုလည်း ခြုံ စေ၍ ၊ ထူးဆန်းသောသင်တိုင်း ခါးစည်း ဖြင့် စည်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ရင်ဖုံး ကိုလည်း ဆင်စေ၍ ၊ ရင်ဖုံး အထဲ ၌ ဥရိမ် နှင့် သုမိမ် ကို သွင်း ထားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","သူ ၏ခေါင်း ပေါ် မှာ ဗေါင်း ကိုတင် ၍ ၊ သန့်ရှင်း သော ရွှေ သင်းကျစ် ပြား ကို ဗေါင်း ရှေ့ ၌ တပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ မောရှေ သည် လိမ်း ရန်ဆီ ကိုယူ ၍ ၊ တဲ တော်နှင့် တဲတော် တန်ဆာရှိသမျှ ကို လိမ်း သဖြင့် သန့်ရှင်း စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ထိုဆီကို ယဇ် ပလ္လင်ပေါ် မှာ ခုနစ် ကြိမ် ဖြန်း ၍ ၊ ယဇ် ပလ္လင်တန်ဆာ ရှိသမျှ ကို၎င်း ၊ အင်တုံ နှင့် ခြေထောက် ကို၎င်း ၊ သန့်ရှင်း စေခြင်းငှါ လိမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","လိမ်း ရန်ဆီ ကို အာရုန် ခေါင်း ပေါ် မှာ လောင်း ၍ သူ့ ကိုသန့်ရှင်း စေခြင်းငှါ လိမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","အာရုန် ၏သား တို့ကိုလည်း အင်္ကျီ ဝတ် စေ၍ ၊ ခါးပန်း ကို စည်း စေလျက် ၊ ဦးထုပ် ကို ဆောင်း စေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ထာဝရဘုရား မှာ ထား တော်မူသည်အတိုင်း ၊ အပြစ် ဖြေရာယဇ်ဘို့ နွား ထီးကို ဆောင် ခဲ့၍ ၊ အာရုန် နှင့် သူ ၏သား တို့သည်၊ မိမိ တို့လက် ကို နွား ခေါင်း ပေါ် မှာ တင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","နွားကိုသတ် ၍ ၊ မောရှေ သည် ယဇ် ပလ္လင်ပတ်လည် ဦးချို တို့၌ အသွေး ကို လက်ညှိုး နှင့် ယူ ၍ ထည့် သဖြင့် ၊ ယဇ် ပလ္လင်ကို စင်ကြယ် စေပြီးမှ ၊ ကြွင်းသော အသွေး ကို ယဇ် ပလ္လင်ခြေရင်း နား၌ သွန် ၍ ၊ ထိုယဇ်ပလ္လင်ပေါ်မှာ အပြစ် ဖြေခြင်းကို ပြုမည်အကြောင်း သန့်ရှင်း စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","အအူ ကိုဖုံး သော ဆီဥ ရှိသမျှ ၊ အသည်း ပေါ်၌ရှိသောအမြှေး ၊ ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ်ဆီဥ ကိုယူ ၍ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","အရေ ၊ အသား ၊ ချေးနု နှင့်တကွ နွား ကောင်ကို၊ တပ် ပြင် မှာ ရှို့ ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ မီး ရှို့ရာယဇ်ပြုသောသိုး ထီးကိုလည်း ဆောင် ခဲ့၍ ၊ အာရုန် နှင့် သူ ၏သား တို့သည်၊ မိမိ တို့လက် ကို သိုး ခေါင်း ပေါ် မှာ တင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","သိုးကိုသတ် ပြီးလျှင် ၊ မောရှေ သည် အသွေး ကို ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","သိုး ကိုလည်း အပိုင်း ပိုင်းဖြတ် ပြီးလျှင် ၊ ခေါင်း မှစ၍သားတစ် များနှင့် ဆီဥ ကို မီး ရှို့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ဝမ်းထဲ ၌ရှိသောအရာနှင့် ခြေ တို့ကို ဆေးကြော ၍ ၊ သိုး တကောင်လုံး ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့လေ၏။ မွှေးကြိုင် ရာဘို့ မီး ရှို့သော ယဇ်ဖြစ်သတည်း။ မီး ဖြင့် ထာဝရဘုရား အား ပြုသောပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ အခြား သောသိုး ၊ အရာ ၌ ခန့်ထားရာ သိုး ကိုဆောင် ခဲ့၍ ၊ အာရုန် နှင့် သူ ၏သား တို့သည် မိမိ တို့လက် ကို သိုး ခေါင်း ပေါ် မှာ တင် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","သိုးကိုသတ် ပြီးမှ ၊ မောရှေ သည် အသွေး ကိုယူ ၍ ၊ အာရုန် ၏ လက်ျာ နား ပျဉ်း ၌ ၎င်း၊ လက်ျာ လက်မ ၌ ၎င်း ၊ လက်ျာ ခြေမ ၌ ၎င်း ၊ ထည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","အာရုန် ၏ သား တို့ကိုလည်း ခေါ် ခဲ့၍ ၊ သူ တို့လက်ျာ နား ပျဉ်း ၊ လက်ျာ လက်မ ၊ လက်ျာ ခြေမ တို့၌ အသွေး ကိုထည့် ပြီးမှ ၊ ယဇ် ပလ္လင်အပေါ် ၌ ပတ်လည် ဖြန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ဆီဥ ၊ အမြီး ၊ အအူ ကို ဖုံး သော ဆီဥ ၊ အသည်း ပေါ်၌ ရှိသောအမြှေး ၊ ကျောက်ကပ် နှစ် ခုနှင့် ကျောက်ကပ် ကိုဖုံးသော ဆီဥ ၊ လက်ျာ ပခုံး ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ထာဝရဘုရား ရှေ့ တော်၌ ထားသော တဆေး မဲ့ မုန့်တောင်း ထဲက တဆေး မဲ့ မုန့်တလုံး ၊ ဆီ နှင့် လုပ်သော မုန့်ပြား တပြား ၊ မုန့်ကြွပ် တချပ် ကိုယူ ၍ ၊ မုန့်များကို ဆီဥ နှင့် လက်ျာ ပခုံး ပေါ် မှာ ထည့် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","အာရုန် ၏လက် ၊ သူ ၏သား တို့လက် ၌ ထိုအရာတို့ကို ထား ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ၊ ချီလွှဲ သဖြင့် ၊ ချီလွှဲ သော ပူဇော်သက္ကာပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ထိုအရာတို့ကို သူ တို့လက် မှ ခံယူ ၍ ၊ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရာယဇ်နှင့်အတူ ရှို့ လေ၏။ မွှေးကြိုင် သော အနံ့ရှိ၍ အရာ ၌ ခန့်ထားရာ ယဇ်ဖြစ်သတည်း။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ထိုနောက် မောရှေ သည် ရင်ပတ် ကို ယူ ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ သဖြင့်၊ ချီလွှဲ သော ပူဇော်သက္ကာပြုလေ၏။ အရာ ၌ ခန့်ထားရာ သိုး ၏ ရင်ပတ်သည် မောရှေ ၏အဘို့ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","တဖန် ယဇ် ပလ္လင်ပေါ် မှာရှိသော အသွေး နှင့် လိမ်း ရန်ဆီ ကိုယူ ၍ အာရုန် နှင့် သူ ၏ အဝတ် ၌ ၎င်း၊ သူ ၏သား တို့နှင့် သူတို့အဝတ် ၌ ၎င်း၊ ဖြန်း သဖြင့်၊ အာရုန် မှစ၍သား များ၊ အဝတ် များတို့ကို သန့်ရှင်း စေ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","မောရှေ သည်၊ အာရုန် နှင့် သူ ၏သား တို့အား လည်း ၊ ထိုသိုး၏ အသား ကို ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး နားမှာ ပြုတ် ကြလော့။ ထာဝရဘုရားက၊ အာရုန် နှင့် သူ ၏သား တို့သည် ထိုအသားကို စား ရကြမည် ဟု ငါ့အား မှာ ထားတော်မူသည်အတိုင်း ၊ ထိုအသားကို၎င်း၊ အရာ ၌ ခန့်ထားရာ မုန့်တောင်း ၌ ရှိသော မုန့် ကို၎င်း၊ ထို အရပ်၌ စား ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ကျန် ကြွင်းသော အသား နှင့် မုန့် ကိုမီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","သင် တို့ကို အရာ ၌ ခန့်ထားရာ ကာလ ခုနစ် ရက် မ စေ့မှီ ပရိတ်သတ်စည်းဝေး ရာ တဲ တော်တံခါး ပြင် သို့ မ ထွက် ရကြ။ ခုနစ် ရက် ပတ်လုံးအရာ၌ ခန့်ထားခြင်း မင်္ဂလာကို ဆောင်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ယနေ့ ပြု သည်အတိုင်း သင် တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုမည်အကြောင်း ထာဝရဘုရား မှာ ထား တော်မူပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ထိုကြောင့် သင်တို့သည် သေ ဘေးနှင့် ကင်း လွတ်ခြင်းငှါ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား မှာ၊ ခုနစ် ရက် ပတ်လုံးနေ့ ညဉ့်မပြတ်နေ ၍ ၊ ထာဝရဘုရား အမှု တော်ကို စောင့်ရကြမည်။ ထိုသို့ ငါ့အားမှာ ထားတော်မူပြီဟု ဆင့်ဆိုသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","မောရှေ အားဖြင့် ထာဝရဘုရား မှာ ထားတော်မူသမျှ အတိုင်း ၊ အာရုန် နှင့် သူ ၏သား တို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","အဋ္ဌမ နေ့ ၌ မောရှေ သည် အာရုန် နှင့် သူ ၏သား များ၊ ဣသရေလ အမျိုးအသက် ကြီးသူများတို့ကို ခေါ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","အာရုန် အား ၊ သင် သည် အပြစ် ဖြေရာယဇ်ဘို့ အပြစ်မပါသော နွား သငယ် တကောင်၊ မီးရှို့ ရာ ယဇ်ဘို့ အပြစ် မပါသော သိုး ထီးတကောင်ကိုယူ ၍ ထာဝရဘုရား ရှေ့ တော်၌ ပူဇော် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ဣသရေလ အမျိုးသား တို့အား လည်း သင်တို့သည် အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် သငယ် တကောင်၊ မီး ရှို့ရာယဇ်ဘို့ အပြစ် မပါ အခါ မလည်သော နွား သငယ်တကောင်၊ သိုး သငယ်တကောင် ");
INSERT INTO myajvb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ထာဝရဘုရား ရှေ့ တော်၌ ပူဇော် သော မိဿဟာယ ယဇ်ဘို့ နွား ထီးတကောင်၊ သိုး ထီးတကောင်၊ ဆီ နှင့် ရော သော ဘောဇဉ်ပူဇော်သက္ကာ ကို ယူ ကြလော့။ ယနေ့ ထာဝရဘုရား သည် သင် တို့အား ထင်ရှား တော်မူမည်ကို ပြော လော့ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","မောရှေ မှာ ထားသောအရာတို့ကို ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ သို့ ဆောင် ခဲ့ပြီးမှ ၊ ပရိသတ် အပေါင်း တို့သည် ချဉ်းကပ် ၍ ထာဝရဘုရား ရှေ့ တော်၌ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","မောရှေ ကလည်း ၊ သင်တို့သည် ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ဤသို့ ပြု ကြ၍ ၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် သင် တို့အား ထင်ရှား မည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","အာရုန် အား လည်း ၊ သင်သည် ယဇ် ပလ္လင်သို့ သွား ၍ ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း ၊ သင် ၏ အပြစ် ဖြေရာယဇ်၊ မီး ရှို့ရာယဇ်ကို ပူဇော် သဖြင့် ၊ သင် နှင့် လူ များအတွက် အပြစ် ဖြေခြင်းကို ပြုလော့။ လူ များ ဆောင်ယူခဲ့သော ပူဇော် သက္ကာကိုလည်း ပူဇော် ၍ ၊ သူ တို့အတွက် အပြစ် ဖြေခြင်းကို ပြုလော့ဟူ၍၎င်း ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","အာရုန် သည်လည်း ၊ ယဇ် ပလ္လင်သို့ သွား ၍ မိမိ နှင့် ဆိုင်သော အပြစ် ဖြေရာယဇ် နွား သငယ်ကိုသတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","သူ၏ သား တို့လည်း အသွေး ကို ယူဆောင် ခဲ့သဖြင့် ၊ အာရုန်သည် မိမိ လက်ညှိုး ကို အသွေး ၌ နှစ် ၍ ယဇ် ပလ္လင်ဦးချို တို့၌ ထည့် ပြီးမှ ၊ ကြွင်းသောအသွေး ကို ယဇ် ပလ္လင်ခြေရင်း နား၌ သွန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","အပြစ် ဖြေရာ ယဇ်ကောင်ဆီဥ ၊ ကျောက်ကပ် ၊ အသည်း ပေါ် ၌ရှိသောအမြှေး ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့လေ၏။ ထိုသို့ ထာဝရဘုရား သည် မောရှေ အားမှာ ထား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","အသား နှင့် အရေ ကို တပ် ပြင် မှာ မီး ရှို့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","မီး ရှို့ရာယဇ်ကောင်ကိုလည်း သတ် ၍ ၊ သူ၏သား တို့သည် အသွေး ကို ဆက် ပြီးလျှင် ၊ သူသည် ယဇ် ပလ္လင်အပေါ် ပတ်လည် ၌ ဖြန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","သူတို့သည် မီး ရှို့ရာယဇ်ကောင်သားတစ် များနှင့် ခေါင်း ကိုဆက် ၍ ၊ သူသည် ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ဝမ်းထဲ ၌ရှိသောအရာများနှင့် ခြေ တို့ကို ဆေးကြော ၍ ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရာယဇ်နှင့်အတူ ရှို့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","လူ များ ပူဇော် သက္ကာကိုလည်း ဆောင် ခဲ့၍ ၊ လူ များအပြစ် ဖြေရာယဇ်ဖြစ်သော ဆိတ် ကိုယူ သတ် ပြီးလျှင် ၊ ရှေ့ နည်းအတူအပြစ် အတွက် ပူဇော်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","မီး ရှို့ရာ ယဇ်ကောင်ကိုလည်း ဆောင် ခဲ့၍ ၊ ထိုနည်းတူပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ဘောဇဉ်ပူဇော်သက္ကာ ကိုလည်း ဆောင် ခဲ့ပြီးလျှင် ၊ တလက်ဆွန်းကိုယူ၍ ယဇ် ပလ္လင်၌ နံနက် မီး ရှို့ရာယဇ်နားမှာ မီး ရှို့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","လူ များအတွက် မိဿဟာယ ယဇ် နွား ထီး၊ သိုး ထီးကိုလည်း သတ် ၍ ၊ သူ၏ သား တို့သည် အသွေး ကို ဆက် ပြီးလျှင် ၊ သူသည် ယဇ် ပလ္လင်အပေါ် ပတ်လည် ၌ ဖြန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","အမြီး နှင့်တကွ အအူကိုဖုံး သော ဆီဥ၊ ကျောက်ကပ် ၊ အသည်း အမြှေး တည်းဟူသောသိုး နွား ဆီဥ ကို၊ ");
INSERT INTO myajvb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ရင်ပတ် ပေါ် မှာ တင် ၍ ယဇ် ပလ္လင်၌ မီး ရှို့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ရင်ပတ် နှင့် လက်ျာ ပခုံး ကို ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ၍၊ ချီလွှဲ သော ပူဇော်သက္ကာကို ပြုလေ၏။ ထိုသို့ ပြုရမည်ဟု မောရှေ မှာ ထားသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","အာရုန် သည် မိမိ လက် ကို လူ များရှေ့ သို့ ချီ လျက် ၊ ကောင်းကြီး ပေး၍ ၊ အပြစ် ဖြေရာယဇ်၊ မီး ရှို့ရာယဇ်၊ မိဿဟာယ ယဇ်ကို ပူဇော်ရာမှ ဆင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","တဖန် မောရှေ နှင့် အာရုန် တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ထဲ သို့ ဝင် ၍ ထွက် ပြီးမှ ၊ လူ များကို ကောင်းကြီး ပေးသဖြင့် ၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် လူ များတို့အား ထင်ရှား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ထာဝရဘုရား ထံ တော်မှ မီး ထွက် ၍ ယဇ် ပလ္လင်ပေါ် မှာရှိသော မီး ရှို့ရာယဇ်နှင့်ဆီဥ ကို လောင် လေ၏။ ထိုအကြောင်းအရာကို လူ များတို့သည် မြင် သောအခါ ကြွေးကြော် ၍ ပြပ်ဝပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","အာရုန် ၏သား နာဒပ် နှင့် အဘိဟု တို့သည်၊ ကိုယ်စီဆိုင်သော လင်ပန်း တို့ကို ယူ လျက် မီး ကိုထည့် ၍ လောဗန် ကို တင် ပြီးလျှင် ၊ ထာဝရဘုရား မှာ ထားတော်မူသောမီးမ ဟုတ်၊ ထူးခြား သော မီး ကို ရှေ့ တော်၌ ပူဇော် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ထိုအခါ ထာဝရဘုရား ထံ တော်မှ မီး ထွက် ၍ ၊ သူ တို့ကို လောင် သဖြင့် ရှေ့ တော်၌ သေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ထိုအခါ မောရှေ သည် အာရုန် ကို ခေါ်၍၊ ထာဝရဘုရား က၊ ငါသည် သန့်ရှင်း ခြင်းရှိသည်ဟု ငါ့ ထံသို့ ချဉ်းကပ် သောသူတို့သည် မှတ်ရမည်။ လူ အပေါင်း တို့သည် ငါ့ဘုန်း ကို ချီးမြှင့်ရကြမည်ဟု မိန့် တော်မူရာ၌၊ ထိုသို့သော အမှုကို ရည်ဆောင်၍ မိန့်တော်မူသည်ဟု ဆိုလျှင်၊ အာရုန် သည် တိတ်ဆိတ် စွာ နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","မောရှေ သည် အာရုန် ၏ ဘထွေး ဩဇေလ သား မိရှေလ နှင့် ဧလဇာဖန် ကို ခေါ် ၍ ၊ လာ ကြ။ သင် တို့ပေါက်ဘော် တို့ကို သန့်ရှင်း ရာ ဌာနတော်က ၊ တပ် ပြင် သို့ ယူ သွားကြလော့ဟု ဆို သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","သူတို့သည် လာ ၍ အင်္ကျီ ဝတ်လျက်ရှိသောအသေကောင်ကို တပ် ပြင် သို့ ယူ သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","မောရှေ သည် အာရုန် နှင့် သူ ၏သား ဧလာဇာ နှင့် ဣသမာ တို့ကိုခေါ်၍၊ သင်တို့လည်းသေမည်။ လူ အပေါင်း တို့အပေါ် မှာ အမျက် တော်သင့်ရောက်မည်ကို စိုးရိမ်သည်ဖြစ်၍၊ သင်တို့ဦးထုပ်ကို မချွတ်နှင့်။ အဝတ် ကို မ ဆုတ် နှင့်။ သင် တို့ညီအစ်ကို ဣသရေလ အမျိုးသားရှိသမျှ တို့သည် ထာဝရဘုရား ပြု တော်မူသော မီးလောင် ခြင်းကိုသာ ငိုကြွေး မြည်တမ်းကြစေ။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","သင်တို့သေ မည်ကိုစိုးရိမ်သည်ဖြစ်၍ ၊ ပရိသတ်စည်းဝေး ရာ တံခါး ပြင်သို့ မ ထွက် နှင့်။ ထာဝရဘုရား ၏ ဘိသိက် ဆီသည် သင် တို့အပေါ် ၌ရှိသည်ဟု ဆိုသည်အတိုင်း သူတို့ပြု ကြ၏။8တဖန် အာရုန် အား ထာဝရဘုရား က ");
INSERT INTO myajvb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","သင် နှင့် သင် ၏သား တို့သည် သေဘေး နှင့်ကင်းလွတ်ခြင်းငှါ၎င်း ၊ သန့်ရှင်း သောအရာ၊ မသန့်ရှင်း သောအရာ၊ စင်ကြယ် သောအရာ၊ မစင်ကြယ် သောအရာတို့ကိုပိုင်းခြား တတ်ခြင်းငှါ ၎င်း၊ ထာဝရဘုရား သည် မောရှေ အားဖြင့် မှာထား သမျှ သောပညတ် တို့ကို ဣသရေလ အမျိုးသား တို့၌ သွန်သင် တတ်ခြင်းငှါ ၎င်း ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်သို့ ဝင် သောအခါ ၊ စပျစ်ရည် အစရှိသောယစ်မျိုး ကိုမ သောက် နှင့်။ သင် တို့အမျိုး အစဉ်အဆက်စောင့် ရသောပညတ်ဖြစ်သတည်းဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","မောရှေ သည်လည်း ၊ အာရုန် နှင့် ကြွင်း သော သား ဧလာဇာ ၊ ဣသမာ တို့ကို ခေါ်၍၊ သင်တို့သည် ထာဝရဘုရား အား မီး ဖြင့်ပြုသောဘောဇဉ်ပူဇော်သက္ကာ အကြွင်း ကိုယူ ၍ တဆေး မပါဘဲ ယဇ် ပလ္လင်နား မှာ စား ကြလော့။ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ထိုအကြွင်းသည် ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာထဲက သင် နှင့် သင် ၏ သား တို့ ခံထိုက်သောအဘို့ ဖြစ်၍၊ သန့်ရှင်း ရာဌာန တော်၌ စား ရကြမည်။ ထိုပညတ် တော်ကို ငါခံရပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ချီလွှဲ သောရင်ပတ် ၊ ချီမြှောက်သော ပခုံး ကိုကား၊ သင် နှင့်တကွ သင် ၏ သား သမီး တို့သည် စင်ကြယ် သောအရပ် ၌ စား ရကြမည်။ ဣသရေလ အမျိုးသား တို့သည် ပူဇော်သော မိဿဟာယ ယဇ်ထဲက ၊ သင် နှင့် သင် ၏သား တို့သည် ခံထိုက်သောအဘို့ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","မီး ဖြင့် ပူဇော်သော ယဇ်ကောင်ဆီဥ နှင့်တကွ ၊ ချီမြှောက်ရာပခုံး ၊ ချီလွှဲ ရာရင်ပတ် ကို ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ၍ ၊ ချီလွှဲ သော ပူဇော်သက္ကာကို ပြုခြင်းငှါ ဆောင် ခဲ့ရကြ၍ ၊ ထာဝရ ပညတ် တော် အတိုင်း ၊ သင် နှင့် သင် ၏ သား တို့သည် ကိုယ်အဘို့ယူရကြမည်။ ထိုသို့ ထာဝရဘုရား မှာ ထားတော်မူပြီ ဟုဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","တဖန် မောရှေ သည် အပြစ် ဖြေရာ ယဇ်ပြုသောဆိတ် ကို ကြိုးစား၍ ရှာ သော်လည်း မတွေ့။ မီး ရှို့နှင့်ပြီ။ ထိုကြောင့် ကြွင်း သော အာရုန် သား ဧလာဇာ ၊ ဣသမာ တို့ကို အမျက် ထွက်လျက် ဆို သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","အပြစ် ဖြေရာယဇ်သားသည် အလွန်သန့်ရှင်း ၏။ သင် တို့သည် ပရိသတ် တို့ အပြစ် ကိုခံ ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ သူ တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုစေခြင်းငှါ ထိုယဇ်သားကိုပေး တော်မူသည်ဖြစ်၍၊ သန့်ရှင်း ရာ ဌာန တော်၌ အဘယ်ကြောင့် မ စား သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ထိုယဇ်သား အသွေး ကိုလည်း သန့်ရှင်း ရာဌာနထဲ သို့ မ သွင်း ပါတကား။ အကယ်၍ငါမှာ ထားခဲ့သည် အတိုင်း ၊ ထိုယဇ်သားကို သန့်ရှင်း ရာဌာနတော်၌ စား ရမည်ဟုဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","အာရုန် က၊ ယနေ့ သူတို့သည် လူများတို့ အပြစ် ဖြေရာယဇ်၊ မီး ရှို့ရာယဇ်ကို ပူဇော် ပါပြီ။ အကျွန်ုပ် ၌ ထိုသို့ သော အမှုရောက် သည်တွင်၊ ယနေ့ အပြစ် ဖြေရာ ယဇ်သားကို စား မိလျှင် ၊ ထာဝရဘုရား နှစ်သက် တော်မူပါမည်လောဟု မောရှေ ကို ပြောဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","မောရှေ သည် ထိုစကားကို ကြား လျှင် ဝန်ခံ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် တို့ကို ခေါ်တော်မူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","သင်တို့သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ ၊ မြေကြီး ပေါ် မှာရှိသော သား တကာ တို့ တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ခွါ ကွဲပြား ၍ စားမြုံ့ပြန် သော သား များကို သင်တို့သည် စား ရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","သို့သော်လည်း ၊ စားမြုံ့ပြန် သောသား၊ ခွါ ကွဲပြား သော သားတို့တွင် မ စား ရသောသားဟူမူကား ၊ ကုလားအုပ် သည် စားမြုံ့ပြန် သော်လည်း ခွါ မ ကွဲပြား သောကြောင့် သင် တို့၌ မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ရှာဖန် သည် စားမြုံ့ပြန် သော်လည်း ၊ ခွါ မ ကွဲပြား သောကြောင့် သင် တို့၌ မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","အာရနဘက် သည် စားမြုံ့ပြန် သော်လည်း ခွါ မ ကွဲပြား သောကြောင့် သင် တို့၌ မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ဝက် သည် ခွါ ကွဲပြား သော်လည်း ၊ စားမြုံ့ မ ပြန် သောကြောင့် သင် တို့၌ မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ထိုသို့သော တိရစ္ဆာန်အသား ကို မ စား ရ။ အသေ ကောင်ကိုလည်း မ ထိ ရ။ မ စင်ကြယ်ဟု သင် တို့မှတ်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ပင်လယ် ရေ ၊ မြစ် ရေ အစရှိသော ရေ ၌ နေသော တိရစ္ဆာန်တကာ တို့တွင် ၊ အယပ် နှင့် အကြေး ရှိသော တိရစ္ဆာန်ကိုသာစား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","အယပ် နှင့် အကြေး မ ရှိ၊ ပင်လယ် ရေ၊ မြစ် ရေအစရှိသော ရေ ၌ လှုပ်ရှား လျက် အသက် ရှင်လျက် နေသောတိရစ္ဆာန် ရှိသမျှ တို့သည် သင် တို့၌ ရွံရှာ ဘွယ် ဖြစ်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","အယပ် အကြေး နှင့် မပြည့်စုံသော ရေတိရစ္ဆာန်အသား ကို သင်တို့သည် မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","သူ တို့ အသေ ကောင်ကိုလည်း ရွံ့ရှာ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","သင်တို့သည် ရွံ့ရှာ ဘွယ်မှတ်၍ မ စား ရသောငှက် မျိုးဟူမူကား ၊ ရွှေလင်းတ ၊ ပင်လယ် လင်းတ၊ လင်းယုန်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ဒါဟ ၊ စွန် မျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ကျီး မျိုး ရှိသမျှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ကုလားအုပ်ငှက် ၊ ငှက်ဆိုး ၊ ဥဗျိုင်း ၊ သိမ်း မျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ဇီးကွက် ၊ ကြိုးကြာ ၊ ဣဗိတ်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ငှက်ကျား ၊ ဝံပို ၊ ဝံလို၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","တောငန်း ၊ ဒုံးစပ် မျိုး ၊ ဒုံးကုလား ၊ လင်းနို့ မှစ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","အတောင် ရှိလျက် ခြေလေး ချောင်းနှင့် တွား တတ်သော တိရစ္ဆာန်မျိုးရှိသမျှ တို့သည် သင် တို့၌ ရွံရှာ ဘွယ်ဖြစ်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","သို့ရာတွင် အတောင် ရှိလျက် ခြေလေး ချောင်းနှင့် တွား တတ်၍၊ မြေ ပေါ် မှာ ခုန် စရာဘို့ အခြားခြေ ထက် ရှည်သော ခြေထောက် ရှိသောတိရစ္ဆာန်တို့တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","အာရာဘ ကျိုင်းမျိုး ၊ သလောင် ကျိုင်းမျိုး ၊ ခရဂလ ကျိုင်းမျိုး ၊ ခါဂပ် ကျိုင်းမျိုး ကို စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","အတောင် ရှိ၍ ခြေ လေး ချောင်းနှင့် တွား တတ်သော အခြားတိရစ္ဆာန်တို့သည် သင် တို့၌ ရွံရှာ ဘွယ် ဖြစ်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ထို တိရစ္ဆာန်အားဖြင့် သင်တို့စင်ကြယ် ခြင်း ပျက်တတ်၏။ သူ တို့အသေ ကောင်ကို ထိ သောသူသည်၊ ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ထိုအသေ ကောင်ကို ဆောင် သွားသောသူသည် မိမိ အဝတ် ကိုလျှော် ရမည်။ ညဦး တိုင်အောင် လည်း မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ခွါ မ ကွဲပြား သော တိရစ္ဆာန်၊ စားမြုံ့ မ ပြန် သော တိရစ္ဆာန် ရှိသမျှ တို့သည် သင် တို့၌ မ စင်ကြယ်။ သူ တို့ အသေကောင်ကို ထိ သမျှ သောသူတို့ သည် မ စင်ကြယ်ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ခွါမရှိသောသားအမျိုးမျိုးတို့သည် သင် တို့၌ မ စင်ကြယ်ကြ။ သူ တို့အသေ ကောင်ကို ထိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","သူ တို့ အသေ ကောင်ကို ဆောင် သွားသောသူသည် မိမိ အဝတ် ကို လျော် ရမည်။ ညဦး တိုင်အောင် လည်း မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန်တို့တွင် ပွေး ၊ ကြွက် ၊ အိမ်မျှောင် မျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","တောက်တဲ့ ၊ မြွေပါ ၊ သင်းချော၊ ပုတတ်၊ ပုတ်သင် တို့သည် သင်တို့၌ မစင်ကြယ်ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","သူ တို့အသေကောင်ကို ထိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ထိုအသေကောင်သည် သစ်ခွက် ၊ အဝတ် ၊ အရေ ၊ အမွှေး၊ အိတ် အစရှိသော အသုံး အဆောင်တစုံ တခု ပေါ် သို့ကျ လျှင် ထိုအသုံးအဆောင်မ စင်ကြယ်။ ရေ ၌ နှစ်ရမည်။ ညဦး တိုင်အောင် လည်း မ စင်ကြယ်။ ထိုနောက် စင်ကြယ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","မြေ ခွက် တစုံ တခုပေါ်သို့ အသေကောင်ကျ လျှင် ထိုမြေခွက် မ စင်ကြယ်သောကြောင့် ခွဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ထိုမြေခွက်ရေသည်၊ စားစရာအမဲသားပေါ်သို့ ကျလျှင်၊ အမဲသားမစင်ကြယ်။ ထိုမြေခွက်၌ သောက် စရာရေ လည်း မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","အကြင်အရာအပေါ်၌ ထိုအသေ ကောင်ကျ ၏။ ထိုအရာသည် မီးဖို ဖြစ်စေ ၊ ခုံလောက် ဖြစ်စေ၊ မ စင်ကြယ်ရာသို့ ရောက်၍ သင် တို့၌ မ စင်ကြယ်သောကြောင့် ဖြိုဖျက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","သို့ရာတွင် ရေ စုဝေး ရာ စမ်း ရေတွင်း၊ တူးသော ရေတွင်း သည် မ စင်ကြယ်ရာသို့ မရောက်။ အသေ ကောင်ကို ထိမိ သော အရာသာ မ စင်ကြယ်ရာသို့ရောက်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ကြဲစရာ မျိုးစေ့ အပေါ် ၌ ထိုအသေ ကောင်ကျ လျှင် ၊ မျိုးစေ့သည် မ စင်ကြယ်ရာသို့မရောက်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ရေ ၌စိမ်ထားပြီးသော မျိုးစေ့ အပေါ် ၌ ထိုအသေ ကောင်ကျ လျှင် ၊ မျိုးစေ့သည် သင် တို့၌ မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","သင် တို့စား အပ်သော တိရစ္ဆာန် သေ လျှင် ၊ အသေ ကောင်ကို ထိမိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ထိုအသေ ကောင်ကို စား သောသူသည်၊ မိမိ အဝတ် ကို လျှော် ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်။ ထိုအသေ ကောင်ကို ဆောင် သွားသောသူသည်လည်း မိမိ အဝတ် ကို လျှော် ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန် ရှိသမျှ တို့သည် ရွံရှာ ဘွယ်ဖြစ်၍သင်တို့မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ခြေမရှိ၊ ဝမ်း ဖြင့် သွား သည်ဖြစ်စေ၊ ခြေလေး ချောင်းဖြင့် သွား သည်ဖြစ်စေ၊ ခြေလေးချောင်းမက များ သော ခြေ ဖြင့်သွားသည်ဖြစ်စေ၊ မြေ ပေါ် တွား တတ်သော တိရစ္ဆာန် တစုံ တခုကို မျှ မ စား ရ။ ရွံရှာ ဘွယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","တွား တတ်သော တိရစ္ဆာန် တစုံ တခုအားဖြင့် သင် တို့သည် ကိုယ် ကို ရွံ့ရှာ ဘွယ် မ ဖြစ်စေရ။ ထိုသို့ အားဖြင့် ကိုယ်ညစ်ညူး အောင် ကိုယ်၌မ စင်ကြယ်သည်ကို မ ပြုရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ငါ သည် သင် တို့ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ငါ သည် သန့်ရှင်း သောကြောင့် ၊ သင်တို့သည်လည်း ကိုယ့်ကိုကိုယ် သန့်ရှင်း စေ၍ သန့်ရှင်း ခြင်းရှိ ရကြမည်။ မြေ ပေါ် မှာ တွား တတ်သော တိရစ္ဆာန် တစုံ တခုအားဖြင့် မျှ သင် တို့သည် ကိုယ် ကိုကိုယ်မ ညစ်ညူး စေရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ငါ သည် သင်တို့၏ ဘုရား သခင်ဖြစ်ခြင်းငှါ ၊ သင် တို့ကို အဲဂုတ္တု ပြည် မှ ကယ် နုတ်သော ထာဝရဘုရား ဖြစ်၏။ ငါ သည် သန့်ရှင်း သောကြောင့် ၊ သင်တို့သည်သန့်ရှင်း ခြင်းရှိ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ဤရွေ့ကား ၊ စင်ကြယ် ၊ မစင်ကြယ် ၊ စား အပ်၊ မ စား အပ်သောတိရစ္ဆာန် တို့ကိုပိုင်းခြား စေခြင်းငှါ၊ သား ၊ ငှက် ၊ ရေ ၌သွား ၍အသက်ရှင် သောတိရစ္ဆာန် ၊ မြေ ပေါ်မှာ တွား တတ်သောတိရစ္ဆာန် ရှိသမျှ နှင့်ဆိုင်သောတရား ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","မိန်းမ သည် ပဋိသန္ဓေယူ၍ သား ယောက်ျားကို ဘွားမြင် ပြီးလျှင် ၊ ဥတုရောက်၍ ခုနစ် ရက် မ စင်ကြယ်သကဲ့သို့ ခုနစ်ရက် မစင်ကြယ်နေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","အဋ္ဌမ နေ့ ၌ သားယောက်ျားအား အရေဖျား လှီးခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ထိုနောက် အမိသည် စင်ကြယ် စေခြင်းနှင့် ဆိုင်သော အသွေး ရှိ၍၊ အရက် သုံး ဆယ်သုံး ရက် ပတ်လုံးနေ ရမည်။ စင်ကြယ် စေခြင်းနေ့ ရက်မ စေ့ မှီတိုင်အောင်သန့်ရှင်း သောအရာကို မ ကိုင် ရ။ သန့်ရှင်း ရာ ဌာနတော်သို့ မ သွား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","သားမိန်းမ ကို ဘွားမြင် လျှင် ၊ ဥတုရောက်သကဲ့သို့ တဆယ် လေးရက်ပတ်လုံးမ စင်ကြယ်နေရမည်။ စင်ကြယ် စေခြင်းနှင့် ဆိုင်သောအသွေး ရှိ၍၊ အရက် ခြောက် ဆယ်ခြောက် ရက် ပတ်လုံးနေ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","သား ယောက်ျားဖြစ်စေ ၊ မိန်းမ ဖြစ်စေ၊ စင်ကြယ် စေခြင်းနေ့ ရက်ကာလစေ့ သောအခါ ၊ မီး ရှို့ရာယဇ် ဘို့ အခါ မလည်သော သိုးသငယ် တကောင်၊ အပြစ် ဖြေရာယဇ်ဘို့ ချိုး ကလေး တကောင်၊ သို့မဟုတ်ခို တကောင်ကို၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့၊ ယဇ်ပုရောဟိတ် ထံ သို့ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ယဇ်ပုရောဟိတ်သည် ထာဝရဘုရား ရှေ့ တော်၌ ပူဇော် ၍ ၊ ထိုမိန်းမ အဘို့ အပြစ် ဖြေခြင်းကို ပြုသဖြင့် ၊ သူသည် အသွေး သွန် ခြင်းအပြစ်မှ သန့်ရှင်း ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","သိုးသငယ် ကို မ တတ် နိုင်လျှင် ၊ ခို နှစ် ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ် ကောင်ဖြစ်စေ၊ မီး ရှို့ရာယဇ်ဘို့ တကောင် ၊ အပြစ် ဖြေရာယဇ်ဘို့ တကောင် ကို ဆောင် ခဲ့၍ ၊ ယဇ် ပုရောဟိတ်သည် သူ့ အဘို့ အပြစ် ဖြေခြင်းကို ပြုသဖြင့် ၊ သူသည် သန့်ရှင်း ရလိမ့်မည်။ ဤ ရွေ့ကား၊ သား ယောက်ျား၊ သားမိန်းမ ကို ဘွားမြင် သော အမိနှင့် ဆိုင်သောတရား ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","တဖန် ထာဝရဘုရား သည်၊ မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","လူ သည် ကိုယ် အရေ ၌ အဖူး ဖြစ်စေ ၊ ယားနာ ဖြစ်စေ ၊ နူကွက် ဖြစ်စေ၊ နူ သောလက္ခဏာပေါ် လျှင် ၊ ထိုသူကို ယဇ်ပုရောဟိတ် အာရုန် ထံ သို့ဖြစ်စေ ၊ သူ ၏သား ယဇ်ပုရောဟိတ် တစုံ တယောက်ထံ သို့ဖြစ်စေခေါ် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ယဇ် ပုရောဟိတ်သည်၊ ထိုသူ၏ အရေ ၌ ပေါ်သော အနာ ကို ကြည့်ရှုသောအခါ၊ အနာ ၌ ရှိသောအမွေး သည် ဖြူ လျှင် ၎င်း၊ အနာ သည် အရေ အောက်၌ စွဲဟန် ရှိလျှင်၎င်း နူနာ မှန်၏။ ယဇ် ပုရောဟိတ်သည် ထိုသူ ကို ကြည့်ရှု ပြီးမှ ၊ မ စင်ကြယ်ဟု စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ကိုယ် အရေ ၌ ရှိသောနူကွက် သည် ဖြူ လျှင် ၎င်း၊ အရေ အောက်၌ စွဲဟန် မ ရှိ၊ အမွေး မ ဖြူ လျှင်၎င်း၊ ယဇ် ပုရောဟိတ်သည်၊ အနာ ရှိသောသူကို ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","သတ္တမ နေ့ ၌ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ ၊ အနာ သည် အရေ ၌ မ တိုးမလျော့နေလျှင် ၊ တဖန် ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","တဖန် သတ္တမ နေ့ ၌ ကြည့်ရှု ၍ အနာ သည် အရေ ၌ မ တိုးပွား ၊ ခပ်မည်းမည်း ဖြစ်လျှင် ၊ ထိုသူ သည် စင်ကြယ် ၏ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ ယားနာသက်သက် ဖြစ်၏။ မိမိ အဝတ် ကို လျှော် ၍ စင်ကြယ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","စင်ကြယ် စေခြင်းငှါ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ပြီးမှ ၊ နောက်တဖန် ယားနာ တိုးပွား ပြန်လျှင် ၊ ယဇ် ပုရောဟိတ် ကြည့်ရှု ပြန်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ယားနာ တိုးပွား သည်ကိုမြင် သောအခါ ၊ ထိုသူ သည် မ စင်ကြယ်ဟု စီရင်ရမည်။ နူနာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","နူနာ စွဲသောသူ ကို ယဇ်ပုရောဟိတ် ထံ သို့ခေါ် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ယဇ်ပုရောဟိတ် ကြည့်ရှု ၍ ၊ အရေ ၌ ထ သော အဖူးနှင့်တကွ အမွေး သည် ဖြူ လျှင် ၎င်း၊ အဖူး ၌ အသား စို ရှိလျှင်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ကိုယ် အရေ ၌ ဟောင်း သော နူနာ ဖြစ်၏။ ထိုသူသည် မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်၍ ချုပ် ထားသဖြင့် ၊ သူ သည် မ စင်ကြယ်ဘဲနေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","နူနာ သည် အရေ ၌ တိုးပွား ၍ အနာ စွဲသော သူတကိုယ်လုံး ၊ ခေါင်း ထိပ်မှ သည် ခြေဘဝါး တိုင်အောင် ၊ ယဇ်ပုရောဟိတ် ကြည့်ရှု လေရာရာ ၌ နူနာ နှံ့ပြား လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ထိုသို့ တကိုယ်လုံး အနာ နှံ့ပြား သောသူ သည် စင်ကြယ် ၏ဟု ယဇ်ပုရောဟိတ် ဆင်ခြင် ၍ စီရင်ရမည်။ တကိုယ်လုံး ဖြူ သည်ဖြစ်၍စင်ကြယ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","သို့မဟုတ် အသား စို ပေါ် လျှင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ယဇ် ပုရောဟိတ်သည် အသား စို ကို ကြည့်ရှု ၍ ထိုသူ သည် မ စင်ကြယ်ဟု စီရင်ရမည်။ အသား စို သည် မ စင်ကြယ်။ နူနာ အမှန်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","အသား စို သည် ခြားနား ၍ ဖြူ ပြန်လျှင် ၊ ယဇ်ပုရောဟိတ် ထံ သို့တဖန် လာ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ ၊ အနာ ဖြူ ပြန်သည်ကိုမြင် လျှင် ၊ ထိုအနာ ရှိသောသူ စင်ကြယ် ၏ဟု ယဇ်ပုရောဟိတ် စီရင်ရသဖြင့် သူ သည် စင်ကြယ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ကိုယ် အရေ ၌ အနာစိမ်း ဖြစ် ၍ ပျောက် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","အနာ ရွတ်၌ ဖြူ သောအဖူး ဖြစ်စေ ၊ ဖြူ နီ သော အနူ ကွက်ဖြစ်စေ၊ ပေါ် လာသည်ကို ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","အရေ အောက်၌ စွဲဟန် ရှိ၍ အမွေး ဖြူ လျှင် ၊ ထိုသူ သည် မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ အနာစိမ်း ထဲက ထွက်သော နူနာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု သောအခါ ၊ ဖြူ သောအမွေး မ ရှိ၊ အရေ အောက်၌ မ စွဲ၊ ခပ်မည်းမည်း ဖြစ်လျှင် ၊ ယဇ် ပုရောဟိတ်သည် ထိုသူ ကို ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","အရေ ၌ တိုးပွား လျှင် ၊ ထိုသူ သည် မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ နူနာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","သို့မဟုတ် နူကွက် မ ရွေ့၊ မ တိုးပွား လျှင် အနာစိမ်း ရွတ် ဖြစ်၏။ ထိုသူ စင်ကြယ် ၏ဟု စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","အရေ အသား ၌ မီး လောင် နာရှိ ၍ ၊ မီးလောင်နာ အသားစို၌ ဖြူ နီ သော နူကွက် ရှိ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ရမည်။ နူကွက် အမွေး ဖြူ ၍ အရေ အောက်၌ စွဲဟန် ရှိလျှင် ၊ မီး လောင်နာ ထဲက ထွက် သော နူနာ ဖြစ်၏။ ထိုသူ သည် မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ နူနာ မှန်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု သောအခါ ၊ နူကွက် ၌ ဖြူ သော အမွေး မ ရှိ၊ အရေ အောက်၌ မ စွဲ၊ ခပ်မည်းမည်း ဖြစ်လျှင် ၊ ယဇ် ပုရောဟိတ်သည် ထိုသူ ကို ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","သတ္တမ နေ့ ၌ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ နူကွက်သည် အရေ ၌ တိုးပွား လျှင် ၊ ထိုသူ သည် မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ နူနာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","သို့မဟုတ် နူကွက် မ ရွေ့ အရေ ၌ မ တိုးပွား ခပ်မည်းမည်း ဖြစ်လျှင် ၊ မီ လောင်နာ အဖူး ဖြစ်၏။ ထိုသူ သည် စင်ကြယ် ၏ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ မီး လောင်သော အနာရွတ် သက်သက်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ယောက်ျား မိန်းမ သည်လည်း ၊ ခေါင်း ၌ ဖြစ်စေ ၊ မေး ၌ ဖြစ်စေ၊ အနာ ပေါက်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု သောအခါ ၊ အရေ အောက်၌ စွဲဟန် နှင့်တကွ အမွေး ဝါဝါ ပါးပါး ရှိလျှင် ၊ ထိုသူ မ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ ခေါင်း ၌ဖြစ်စေ ၊ မေး ၌ဖြစ်စေ၊ ဗောက်နူနာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ထိုအနာ ကို ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု သောအခါ ၊ အရေ အောက်၌ စွဲဟန် မ ရှိ၊ နက် သော အမွေး လည်း မ ရှိလျှင် ၊ ထိုအနာ ပေါက်သောသူကို၊ ယဇ် ပုရောဟိတ်သည် ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","သတ္တမ နေ့ ၌ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ အနာ မ တိုးပွား ၊ ပါးသောအမွှေး မ ရှိ ၊ အရေ အောက်၌ စွဲဟန် လည်း မ ရှိလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ထိုသူ၏ အမွေးကိုရိတ် ရမည်။ အနာ အမွေးကိုကား မ ရိတ် ရ။ တဖန် ခုနစ် ရက် ပတ်လုံးချုပ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","သတ္တမ နေ့ ၌ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ အရေ ၌ အနာ မ တိုးပွါး ၊ အရေ အောက်၌ မ စွဲလျှင် ၊ ထိုသူ သည် စင်ကြယ် ၏ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ မိမိ အဝတ် ကို လျှော် ၍ စင်ကြယ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","စင်ကြယ် စေပြီးမှ ၊ နောက်တဖန် ဗောက်နူနာ တိုးပွါး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ပြန်၍ အနာ တိုးပွါး သည်မှန်လျှင် ၊ ယဇ် ပုရောဟိတ်သည် ဝါ သောအမွေး ကို မ ရှာ ရ။ ထိုသူ သည် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","သို့မဟုတ် ဗောက်နူနာ သည် ရပ် နေဟန်ရှိ၍ နက် သော အမွေး ပေါက် လျှင် ၊ အနာ ပျောက် ၍ ထိုသူ သည် စင်ကြယ် သောကြောင့် ၊ ယဇ် ပုရောဟိတ်က ထိုသူ သည် စင်ကြယ် ၏ဟု စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ယောက်ျား မိန်းမ သည်လည်း ၊ ကိုယ် အရေ ၌ ဖြူ သောနူကွက် ရှိ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု သောအခါ မွဲ သောအဆင်းရှိလျှင်၊ အရေ ၌ ပေါက် သော ညှင်း ဖြစ်၏။ ထိုသူ သည် စင်ကြယ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ဆံပင် ကျွတ် သောသူ သည်၊ ခေါင်းပြောင် သော်လည်း စင်ကြယ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","နဖူး ဆံ ကျွတ် သောသူ သည် နဖူးပြောင် သော်လည်းစင်ကြယ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ပြောင် သောခေါင်း၌ ဖြစ်စေ ၊ ပြောင် သောနဖူး၌ ဖြစ်စေ၊ ဖြူ နီ သောအနာ ပေါက် လျှင် ၊ ထိုပြောင်ရာ၌ ပေါက်သော နူနာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ထိုအခါ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ ၊ ကိုယ် အရေ ၌ နူနာ ထင် သကဲ့သို့ ၊ ပြောင် ရာ၌ ပေါက်သော အနာ ၏အဖူး ဖြူ နီ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ထိုသူ သည် မ စင်ကြယ်။ လူ နူ ဖြစ်၏။ ခေါင်း ၌ အနာ ပေါက်သောကြောင့်၊ အလျှင်းမ စင်ကြယ်ဟု ယဇ်ပုရောဟိတ် စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","နူနာ စွဲသောသူသည် စုတ် သော အဝတ် ကို ဝတ် ရမည်။ ခေါင်း ကို မ ဖုံး၊ အထက် နှုတ်ခမ်းကို ဖုံး လျက် ၊ မ စင်ကြယ်၊ မ စင်ကြယ်ဟု ဟစ်ကြော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ထိုအနာ စွဲသည် ကာလ ပတ်လုံး ၊ သူသည် ညစ်ညူး ၏ မ စင်ကြယ်သည်ဖြစ်၍တယောက် တည်းနေ ရမည်။ သူ့ နေရာ သည် တပ် ပြင် မှာ ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","၎င်း နည်းနူနာ စွဲသော အဝတ် သည်၊ ပိတ် အဝတ် ဖြစ်စေ ၊ သိုးမွေး အဝတ်ဖြစ်စေ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ရက်ကန်း ပင်ဖြစ်စေ ၊ ရက်ကန်း သားဖြစ်စေ၊ သားရေ ဖြစ်စေ၊ သားရေ နှင့်လုပ် သော အသုံးအဆောင် ဖြစ်စေ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","အဝတ် ၌ စွဲသောအနာသည် ခပ်စိမ်းစိမ်း ၊ ခပ်နီနီ ရှိလျှင်၊ နူနာ ဖြစ် ၏။ ယဇ်ပုရောဟိတ် အား ပြ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ယဇ် ပုရောဟိတ်သည် အနာ စွဲသော အဝတ်ကို ကြည့်ရှု ၍ ခုနစ် ရက် ပတ်လုံးလုံခြုံ စွာ ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","သတ္တမ နေ့ ၌ တဖန်ကြည့်ရှု ၍ အဝတ် ၌ အနာ တိုးပွါး လျှင် ၊ ရက်ကန်း ပင်ဖြစ်စေ ၊ ရက်ကန်း သားဖြစ်စေ၊ သားရေ ဖြစ်စေ ၊ သားရေနှင့် လုပ် သော အရာ ဖြစ်စေ၊ မ စင်ကြယ်။ စားတတ်သော နူနာ စွဲပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ထိုအဝတ် ကို မီး ရှို့ရမည်။ စားတတ်သော နူနာ စွဲသော ရက်ကန်း ပင်၊ ရက်ကန်း သား၊ ပိတ် အဝတ်၊ သိုးမွေး အဝတ်၊ သားရေ အသုံး အဆောင်ကို မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ ၊ ရက်ကန်း ပင်၊ ရက်ကန်း သားအဝတ် ၊ သားရေ အသုံး အဆောင်၌ အနာ မ တိုးပွါး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","အနာ စွဲသောအရာကို ဆေး လျော်စေမည်အကြောင်း ၊ ယဇ်ပုရောဟိတ် စီရင် ၍ တဖန် ခုနစ် ရက် ပတ်လုံး လုံခြုံ စွာ ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ဆေး လျှော် ပြီးမှ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ပြန်၍ ၊ အနာ မ တိုးပွါး သော်လည်း ၊ အဆင်း မ ခြားနား လျှင် ၊ မ စင်ကြယ်။ မီး ရှို့ ရမည်။ အတွင်း ၌ ဖြစ်စေ ၊ ပြင် ၌ ဖြစ်စေ၊ ဆွေးမြေ့ခြင်းရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ဆေး လျှော်ပြီးမှ ၊ ယဇ် ပုရောဟိတ်သည် ကြည့်ရှု ၍ အနာ သည် ခပ်မည်းမည်း ဖြစ်လျှင် ၊ အဝတ် ၊ သားရေ ၊ ရက်ကန်း ပင်၊ ရက်ကန်း သားထဲက အနာကွက်ကို ဆုတ် ဖဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","နောက် တဖန် ထိုရက်ကန်း ပင်၊ ရက်ကန်း သားအဝတ် ၊ သားရေ အသုံး အဆောင်၌ အနာပေါ် ပြန်လျှင် ၊ တိုးပွား တတ်သောအနာ ဖြစ်၏။ ထိုသို့အနာ စွဲသောဥစ္စာကို မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ရက်ကန်း ပင်၊ ရက်ကန်း သားအဝတ် ၊ သားရေ အသုံး အဆောင်ဟူသမျှ ကို ဆေး လျှော်၍ အနာ ပျောက် လျှင် ၊ ဒုတိယ အကြိမ် ဆေး လျှော်၍ စင်ကြယ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ဤရွေ့ကား ၊ စင်ကြယ် သည်၊ မ စင်ကြယ်သည်ကို စီရင်စေခြင်းငှါ ၊ နူနာ စွဲသော ပိတ် အဝတ်၊ သိုးမွေး အဝတ် ၊ ရက်ကန်း ပင်၊ ရက်ကန်း သား၊ သားရေ အသုံး အဆောင်တို့နှင့်ဆိုင်သောတရား ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","နူနာ စွဲသောသူသည် စင်ကြယ် စေသောနေ့ ၌ ကျင့်ရသောတရား ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ထိုသူကို ယဇ်ပုရောဟိတ် ထံ သို့ခေါ် ခဲ့ပြီးမှ ယဇ် ပုရောဟိတ်သည်၊ တပ် ပြင် သို့ ထွက် ၍ ကြည့်ရှု သောအခါ ၊ နူနာ ပျောက် သည်မှန်လျှင် ");
INSERT INTO myajvb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","စင်ကြယ် စေခြင်းကို ခံရသောထိုသူအဘို့ ၊ အသက် ရှင်၍ စင်ကြယ် သော ငှက် နှစ် ကောင်၊ အာရဇ် သစ်သား ၊ နီမောင်း သောကြိုး ၊ ဟုဿုပ် ပင်ညွန့်တို့ကို မှာ လိုက်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","စီး သောရေ ကိုထည့်သော မြေ အိုး ထဲ ၌ငှက် တကောင် ကိုသတ် စေပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","အာရဇ် သစ်သား ၊ နီမောင်း သောကြိုး ၊ ဟုဿုပ် ပင်ညွန့်နှင့်တကွ ၊ အသက် ရှင်သော ငှက် ကိုယူ ၍ ၊ ငှက် သွေး ရောပြီးသော ရေ ၌ နှစ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","နူနာစင်ကြယ် စေရသော လူအပေါ် မှာ ခုနစ် ကြိမ် တိုင်အောင်ဖြန်း ၍ ၊ ထိုသူ သည် စင်ကြယ် သည်ဟု စီရင်ရမည်။ ထိုနောက် အသက် ရှင်သော ငှက် ကို ဟင်းလင်း သော အရပ် ၌ လွှတ် လိုက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","စင်ကြယ် စေရသောသူသည် မိမိ အဝတ် ကို လျှော် ၍ ၊ မိမိ ဆံပင် ကို အကုန် အစင်ရိတ် ပြီးမှ ၊ စင်ကြယ် စေခြင်းငှါ ရေချိုး ရမည်။ ထိုနောက် ၊ တပ် ထဲ သို့ ဝင် ၍ ၊ မိမိ တဲ ပြင် ၌ ခုနစ် ရက် နေ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","သတ္တမ နေ့ ၌ မိမိ ဆံပင် ၊ မုတ်ဆိတ် ၊ မျက်ခုန်းမွေး အစရှိသော ကိုယ်မွေး ရှိသမျှ ကို ရိတ် ၍၊ မိမိ အဝတ် ကို လျှော် ပြီးမှ ၊ ရေချိုး ၍ စင်ကြယ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","အဋ္ဌမ နေ့ ၌ လည်း ၊ အပြစ် မရှိ၊ အခါ မလည်သော သိုးသငယ် အထီးနှစ် ကောင်၊ အမ တကောင် ကို၎င်း ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့၊ ဆီ ရော သော မုန့်ညက် သုံး ဩမဲနှင့် ဆီ တ လောဃ ကို၎င်း ယူ ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","စင်ကြယ် စေသော ယဇ် ပုရောဟိတ်သည်၊ စင်ကြယ် စေအပ်သော လူ ကို၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၊ ထာဝရဘုရား ရှေ့ တော်၌ ထိုပူဇော်သက္ကာနှင့်တကွ ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","သိုးသငယ် အထီးတကောင် ကို ယူ ပြီးလျှင် ဒုစရိုက် ဖြေရာယဇ်ဘို့ ပူဇော် ၍ ၊ ထာဝရဘုရား ရှေ့ တော် ၌ ချီလွှဲ သော ပူဇော်သက္ကာဘို့ ဆီ တလောဃ နှင့်တကွ ချီလွှဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ထိုသိုးသငယ် ကို အပြစ် ဖြေရာ ယဇ်ကောင်၊ မီး ရှို့ရာယဇ်ကောင်ကိုသတ် ရာအရပ် ၊ သန့်ရှင်း ရာဌာန ၌ သတ် ရမည်။ အကြောင်း မူကား၊ အပြစ် ဖြေရာ ယဇ်ကောင်ကို၊ ယဇ်ပုရောဟိတ် ယူပိုင်သကဲ့သို့ ဒုစရိုက် ဖြေရာယဇ်ကောင်ကို ယူပိုင်၏။ အလွန်သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ယဇ် ပုရောဟိတ်သည် ဒုစရိုက် အပြစ်ဖြေရာ ယဇ်ကောင်အသွေး ကိုယူ ၍ စင်ကြယ် စေရသောသူ၏ လက်ျာ နား ပျဉ်း ၌ ၎င်း၊ လက်ျာ လက်မ ၊ လက်ျာ ခြေမ ၌ ၎င်း ၊ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ဆီအချို့ကိုလည်း ယူ၍၊ မိမိလက်ဝဲလက်ဝါး၌ လောင်းပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ထို ဆီ ကို မိမိ လက်ျာ လက်ညှိုး နှင့် တို့ယူ၍ ထာဝရဘုရား ရှေ့ တော်၌ ခုနစ် ကြိမ် တိုင်အောင်ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","မိမိ လက် ၌ ကြွင်း သောဆီ ကို စင်ကြယ် စေရသောသူ ၏ လက်ျာ နား ပျဉ်း ၌ ၎င်း၊ လက်ျာ လက်မ ၊ လက်ျာ ခြေမ ၌ ၎င်း ရှိသောဒုစရိုက် ဖြေရာ ယဇ်ကောင်အသွေး အပေါ် မှာ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","မိမိလက် ၌ ကြွင်း သေးသောဆီ ကို၊ စင်ကြယ် စေရသောသူ ၏ခေါင်း ပေါ် မှာ လောင်း ၍ ထိုသူ အဘို့ အပြစ် ဖြေခြင်းကို ထာဝရဘုရား ရှေ့ တော်၌ ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ထိုမှတပါး၊ စင်ကြယ် စေရသော သူအဘို့ အပြစ် ဖြေခြင်းငှါ ၊ အပြစ် ဖြေရာယဇ်ကို ပူဇော် ၍ ၊ နောက် တဖန် မီး ရှို့ရာယဇ်ကောင်ကိုသတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","မီး ရှို့ရာယဇ်ကောင်နှင့် ဘောဇဉ်ပူဇော်သက္ကာ ကို ယဇ် ပလ္လင်ပေါ် မှာ ပူဇော် သဖြင့် ထိုလူအဘို့ အပြစ် ဖြေခြင်းကို ပြု၍ ၊ သူသည်သန့်ရှင်း ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ထိုသူ သည် ဆင်းရဲ ၍ ဤမျှလောက်မ တတ် နိုင်လျှင် ၊ ချီလွှဲ ၍ မိမိ အပြစ် ဖြေခြင်းကို ပြုစရာဘို့ ၊ ဒုစရိုက် ဖြေရာယဇ် သိုးငယ် တကောင် ကို၎င်း၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ဆီ ရော သော မုန့်ညက် တဩမဲနှင့် ဆီ တလောဃ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","တတ်နိုင် သမျှအတိုင်း ၊ ခို နှစ် ကောင်၊ သို့မဟုတ် ချိုး ကလေး နှစ် ကောင်၊ အပြစ် ဖြေရာ ယဇ်ဘို့တကောင် ၊ မီး ရှို့ရာယဇ်ဘို့တကောင် ကို၎င်းယူ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","မိမိ စင်ကြယ် ခြင်းအလိုငှါ ၊ ထာဝရဘုရား ရှေ့ တော်တွင် ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၊ ယဇ်ပုရောဟိတ် ထံ သို့၊ အဋ္ဌမ နေ့ ၌ ဆောင် ခဲ့ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ယဇ် ပုရောဟိတ်သည် ဒုစရိုက် အပြစ်ဖြေရာ ယဇ်သိုးသငယ် နှင့် ဆီ တလောဃ ကို ယူ ၍ ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ရာပူဇော်သက္ကာဘို့ ချီလွှဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ထိုသိုးသငယ် ကိုသတ် ပြီးလျှင် ၊ အသွေး ကိုယူ ၍ စင်ကြယ် စေရသောသူ၏ လက်ျာ နား ပျဉ်း ၌ ၎င်း၊ လက်ျာ လက်မ ၊ လက်ျာ ခြေမ ၌ ၎င်း ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ဆီ အချို့ကိုလည်း မိမိလက်ဝဲ လက်ဝါး ၌ လောင်း ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ထို ဆီ ကို မိမိ လက်ျာ လက်ညှိုး နှင့် ထာဝရဘုရား ရှေ့ တော်၌ ခုနစ် ကြိမ် တိုင်အောင်ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","မိမိ လက် ၌ ကြွင်းသောဆီ ကို စင်ကြယ် စေရသောသူ၏ လက်ျာ နား ပျဉ်း ၌ ၎င်း၊ လက်ျာ လက်မ ၊ လက်ျာ ခြေမ ၌ ၎င်း ရှိသောဒုစရိုက် ဖြေရာ ယဇ်ကောင်အသွေး ပေါ် မှာထည့် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","မိမိ၌ ကြွင်း သေးသော ဆီ ကို ထိုလူခေါင်း အပေါ် မှာ လောင်း ၍၊ သူ့ အဘို့ အပြစ် ဖြေခြင်းကို ထာဝရဘုရား ရှေ့ တော်၌ ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ထိုသူသည် တတ် နိုင်သမျှအတိုင်း ခို နှစ်ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ်ကောင်ဖြစ်စေ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","အပြစ် ဖြေရာယဇ်ဘို့ တကောင် ၊ ဘောဇဉ်ပူဇော်သက္ကာ နှင့်တကွ မီး ရှို့ရာယဇ်ဘို့တကောင် ကို ဆောင်ခဲ့၍၊ ယဇ် ပုရောဟိတ်သည် ပူဇော်လျက်၊ ထိုသူအဘို့ အပြစ် ဖြေခြင်းကို ထာဝရဘုရား ရှေ့ တော်၌ ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ဤ ရွေ့ကား၊ နူနာ စွဲ၍ မိမိ စင်ကြယ် စေ ခြင်းငှါ မ တတ် နိုင်အောင် ဆင်းရဲသောသူနှင့် ဆိုင်သော တရား ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","သင် တို့ပိုင် ထိုက်ရာ၊ ငါ ပေး သော ခါနာန် ပြည် သို့ သင်တို့ရောက် သောအခါ ၊ သင် တို့နေရာ ထိုပြည် တွင် အိမ် တစုံတခု၌ နူနာ ကို ငါစွဲစေလျှင် ၎င်း ");
INSERT INTO myajvb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","အိမ်ရှင်သည် ယဇ်ပုရောဟိတ် ထံ သို့သွား ၍ ၊ အကျွန်ုပ် အိမ် ကို နူနာ စွဲဟန် ရှိပါ၏ဟု ပြောဆို လျှင် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ထို အိမ် ၌ ရှိသမျှ တို့သည်၊ မ စင်ကြယ် ရာသို့ ရောက်မည်ကို စိုးရိမ်၍၊ ယဇ် ပုရောဟိတ်သည် နူနာ ကို အကြည့် အရှုမ ဝင်မှီ၊ ရှိသမျှကို ထုတ် စေခြင်းငှါ စီရင် ရမည်။ ထိုနောက် ယဇ် ပုရောဟိတ်သည် ထိုအိမ် ကို အကြည့် အရှုဝင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","အနာ ကို ကြည့်ရှု သောအခါ ၊ ကျောက်ထရံ ချိုင့်ရာတို့၌ ခပ်စိမ်းစိမ်း ၊ ခပ်နီနီ ဖြစ်၍၊ ကျောက်ထရံ ထဲ ၌အနာစွဲဟန် ရှိလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","အိမ် တံခါး ပြင်သို့ ထွက် ၍ ၊ ထိုအိမ် ကို ခုနစ် ရက် ပတ်လုံးပိတ် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","သတ္တမ နေ့ ၌ ယဇ် ပုရောဟိတ်သည် အကြည့် အရှုလာ ၍ ၊ ကျောက်ထရံ ၌ အနာ တိုးပွား လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","အနာ စွဲသော ကျောက် တို့ကို နှုတ် ပယ်၍ ၊ မြို့ ပြင် မ စင်ကြယ်သော အရပ် ၌ ပစ် ထားစေခြင်းငှါ ယဇ် ပုရောဟိတ် စီရင် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ထိုအိမ် ကို အတွင်း ပတ်လည်၌ ခြစ် စေရမည်။ ခြစ် ၍ကျသော အမှုန့် ကိုလည်း မြို့ ပြင် မ စင်ကြယ်သောအရပ် ၌ သွန် ပစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","အရင်ကျောက် အစား ၌ အခြား သော ကျောက် ကိုယူ ၍ ထည့်ပြီးလျှင် ၊ အသစ် သော အင်္ဂတေနှင့် မွမ်းမံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ထိုသို့ ကျောက် ကို နှုတ် ပယ်၍ အိမ် ကိုခြစ် ခြင်း၊ အသစ်မွမ်းမံ ခြင်းကို ပြုပြီးမှ ၊ တဖန် အနာစွဲ ပြန်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ယဇ်ပုရောဟိတ် လည်း အကြည့် အရှုလာ ၍ ထိုအိမ် ၌ အနာ တိုးပွါး သည် မှန်လျှင်၊ စားတတ်သော နူနာ ဖြစ်၏။ ထိုအိမ် သည် မစင်ကြယ် သောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ကျောက် ၊ သစ်သား ၊ အင်္ဂတေ ရှိသမျှ ကို ဖြိုဖျက် ၍ ၊ မြို့ ပြင် မ စင်ကြယ်သော အရပ် သို့ ယူ သွားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ထိုမှတပါး၊ ထိုအိမ်ကို ပိတ် ထားသည် ကာလ ပတ်လုံး ၊ အထဲ သို့ ဝင် မိသောသူသည်၊ ညဦး တိုင်အောင် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ထိုအိမ် ၌ အိပ် သောသူ၊ စား သောက်သောသူသည်၊ မိမိ အဝတ် ကို လျှော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ယဇ် ပုရောဟိတ်သည် အကြည့် အရှုလာ သောအခါ ၊ အိမ် ကို အသစ်မွမ်းမံ ပြီးမှ အနာ မ တိုးပွါး လျှင် ၊ အနာ ပျောက် သောကြောင့် ထိုအိမ် သည် စင်ကြယ် ၏ဟု စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ထိုအိမ် ကို စင်ကြယ် စေခြင်းငှါ ငှက် နှစ် ကောင်၊ အာရဇ် သစ်သား ၊ နီမောင်း သောကြိုး ၊ ဟုဿုပ် ပင်ညွန့် တို့ကိုယူ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","စီး သောရေ ကို ထည့်သောမြေ အိုး ထဲ ၌ငှက် တကောင် ကိုသတ် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","အာရဇ် သစ်သား ၊ ဟုဿုပ် ပင်ညွှန့်၊ နီ သောကြိုး ၊ အသက် ရှင်သော ငှက် ကို ယူ ၍ ငှက် သွေး ရောသော ရေ ၌ နှစ် ပြီးလျှင် ၊ ထိုအိမ် ကို ခုနစ် ကြိမ် တိုင်အောင်ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ထိုသို့ ငှက် သွေး အစရှိသည်တို့နှင့် ထိုအိမ် ကို စင်ကြယ် စေပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","အသက် ရှင်သော ငှက် ကို မြို့ ပြင် ဟင်းလင်း သောအရပ် ၌ လွှတ် လိုက်၍ ၊ ထိုအိမ် အဘို့ ၊ အပြစ် ဖြေ ခြင်းကို ပြုလျှင် ၊ စင်ကြယ် ခြင်း ရှိလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ဤ ရွေ့ကား၊ စင်ကြယ် သည်၊ မ စင်ကြယ်သည်ကို ပိုင်းခြား ၍ သိစေခြင်းငှါ၊ ဗောက်နူနာ အစရှိသော နူနာ အမျိုးမျိုး ၊ အဝတ် ၌ စွဲသောနူနာ ၊ အိမ် ၌ စွဲသောနူနာ၊ အဖူး ၊ ယားနာ ၊ နူကွက် နှင့်ဆိုင်သော နူနာ တရား ဖြစ်သတည်းဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","တဖန် မောရှေ နှင့် အာရုန် အား ထာဝရဘုရား က၊2သင်တို့သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ရိနာ စွဲသော ယောက်ျား သည် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","အစဉ်ယို သည်ဖြစ်စေ ၊ တခါတလေရပ် သည်ဖြစ်စေ၊ ထိုသူ သည် မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","အိပ် သမျှ ထိုင် သမျှ သော အိပ် ရာထိုင်ရာတို့သည်လည်း မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","သူ ၏အိပ်ရာ ကို ထိ သော သူ ၊ သူ့ထိုင်ရာ အပေါ်မှာ ထိုင် သောသူ၊ သူ၏ကိုယ် ကို ထိ သောသူ၊ သူ၏တံထွေး ထိမိသောသူသည်၊ မိမိ အဝတ် ကိုလျှော် ၍ကိုယ်ကိုရေချိုး ရမည်။ ညဦး တိုင်အောင် မစင်ကြယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ရိနာ စွဲသော သူစီး သော ကုန်းနှီး လည်း မ စင်ကြယ်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","သူ့ အောက် ၌ရှိ သော အရာ ကို ထိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်။ ထိုအရာ တစုံတခုကို ဆောင် သောသူသည်၊ မိမိ အဝတ် ကို လျှော် ၍ ကိုယ်ကို ရေချိုး ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ရိနာ စွဲသောသူသည်၊ လက် မ ဆေး ဘဲ သူတပါး ကို လက်နှင့်ထိ လျှင် ၊ ထိုသူသည် မိမိ အဝတ် ကို လျှော် ၍ ကိုယ်ကို ရေချိုး ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ရိနာ စွဲသောသူ ထိ သော မြေ တန်ဆာ ကို ခွဲ ရမည်။ သစ်သား တန်ဆာ ကို ရေ နှင့် ဆေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","ရိနာ စွဲသောသူသည် အနာ ပျောက်သောအခါ ၊ ပျောက်သောနေ့က စ၍၊ ခုနစ် ရက် လွန်မှ မိမိ အဝတ် ကို လျှော် ၍ ၊ စီး သောရေ နှင့် ကိုယ် ကိုချိုး သဖြင့် စင်ကြယ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","အဋ္ဌမ နေ့ ၌ လည်း ၊ ခို နှစ် ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ် ကောင်ဖြစ်စေ၊ တခုခုကို ထာဝရဘုရား ရှေ့ တော်၌ ပရိသတ်စည်းဝေး ရာ တံခါး နားသို့ ဆောင် ခဲ့၍ ၊ ယဇ်ပုရောဟိတ် အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ယဇ် ပုရောဟိတ်သည် အပြစ် ဖြေရာယဇ်ဘို့တကောင် ၊ မီး ရှို့ရာယဇ်ဘို့တကောင် ကို ပူဇော် ၍ ၊ ရိနာစွဲသော သူ အဘို့ ထာဝရဘုရား ရှေ့ တော်၌ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ယောက်ျား သည် သုတ် ရည်ထွက် လျှင် တကိုယ်လုံး ရေချိုး ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","သုတ် ရည်ထိသောအဝတ် ၊ သားရေ ရှိသမျှ တို့ကို ရေ နှင့် လျှော် ရမည်။ ညဦး တိုင်အောင် မစင်ကြယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ယောက်ျား သည် မိန်းမ နှင့် သံဝါသ ပြုလျှင် ၊ နှစ်ယောက်စလုံးတို့သည် ရေချိုး ရမည်။ ညဦး တိုင်အောင် မစင်ကြယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","မိန်းမ သည် ဥတု ရောက် လျှင် ၊ ခုနစ် ရက် ပတ်လုံးဥတု မစင်ကြယ်ရာ၌ နေရမည်။ သူ့ ကို ထိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ဥတု မစင်ကြယ်လျက် အိပ် သမျှ ၊ ထိုင် သမျှ တို့သည် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","သူ ၏အိပ်ရာ ၊ သူ၏ထိုင် ရာကို ထိ သောသူသည်၊ မိမိ အဝတ် ကိုလျှော် ၍ ကိုယ်ကို ရေချိုး ရမည်။ ညဦး တိုင်အောင် မစင်ကြယ် ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","သူ၏နေရာ ထိုင် ရာစွန်းလျှင် ၊ ထိုနေရာထိုင်ရာကို ထိ သောသူသည် ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ဥတု ရောက် သော မိန်းမ နှင့် သံဝါသ ပြုသောသူသည် ခုနှစ် ရက် ပတ်လုံးမ စင်ကြယ်၊ အိပ်ရာ ရှိသမျှ လည်း မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ဥတု မစင်ကြယ်ရာ ကာလလွန် မှ၊ သွေးယိုနာမပျောက်လျှင်၊ အနာမပျောက်မှီတိုင်အောင်ဥတု မစင်ကြယ်လျက် နေရသကဲ့သို့ မ စင်ကြယ်ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","အနာမပျောက်မှီတိုင်အောင်သူ၏အိပ်ရာ သည် ဥတု မစင်ကြယ်သော အိပ်ရာ ကဲ့သို့ ၎င်း၊ ထိုင် ရာသည်လည်း ထိုကဲ့သို့ ၎င်း မစင်ကြယ် ဖြစ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ထိုအရာတို့ကို ထိ သောသူသည်လည်း မ စင်ကြယ်သောကြောင့် ၊ မိမိ အဝတ် ကို လျှော် ၍ ကိုယ်ကို ရေချိုး ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ထိုမိန်းမသည် သွေးယိုနာ ပျောက် ၍ ခုနစ် ရက် လွန် လျှင် စင်ကြယ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","အဋ္ဌမ နေ့ ၌ ခို နှစ် ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ် ကောင်ဖြစ်စေ၊ တခုခုကို ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၊ ယဇ်ပုရောဟိတ် ထံ သို့ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ယဇ် ပုရောဟိတ်သည် အပြစ် ဖြေရာယဇ်ဘို့တကောင် ၊ မီး ရှို့ရာယဇ်ဘို့တကောင် ကို ပူဇော် ၍ ၊ ဥတုမ စင်ကြယ်သော မိန်းမ အဘို့ ထာဝရဘုရား ရှေ့ တော်၌ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ထိုသို့ ဣသရေလ အမျိုးသား တို့သည် မိမိ တို့တွင် ရှိသောငါ့ တဲ တော်ကို ညစ်ညူး စေ၍ ၊ မိမိ တို့ မ စင်ကြယ်ရာ၌ မ သေ စေခြင်းငှါ ၊ သူ တို့ကို မ စင်ကြယ်ခြင်းနှင့် ကင်းစင် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ဤ ရွေ့ကား၊ ရိနာ စွဲသောသူ၊ သုတ်ရည် ထွက် ၍ညစ်ညူး သောသူ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ဥတု ရောက်သော မိန်းမ ၊ သံဝါသပြုသော ယောက်ျား မိန်းမ ၊ မ စင်ကြယ်သောမိန်းမနှင့် သံဝါသ ပြုသော ယောက်ျား စောင့်ရသောတရား ဖြစ်သတည်းဟု မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","အာရုန် ၏ သား နှစ် ယောက်တို့သည်၊ ထာဝရဘုရား ရှေ့ တော်၌ ပူဇော် ၍ သေ သောနောက် ၊ ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","သင် ၏အစ်ကို အာရုန် သည် သေ ဘေးနှင့်ကင်းလွတ် မည်အကြောင်း ၊ သန့်ရှင်း ရာဌာနတော်အထဲ ၊ သေတ္တာ အပေါ် မှာ တင်သော အဖုံး ကို ကွယ်ကာသော ကုလားကာ အတွင်းသို့ အခါခပ်သိမ်းမ ဝင် စေ ခြင်းငှါ ဆင့်ဆို လော့။ ငါသည် သေတ္တာအဖုံး အပေါ် ၊ မိုဃ်းတိမ် ၌ ထင်ရှား မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","အာရုန် သည် သန့်ရှင်း ရာဌာနတော်အထဲ သို့ အဘယ်သို့ဝင် ရမည်နည်းဟူမူကား၊ အပြစ် ဖြေရာယဇ် ဘို့ အသက်ပျို သော နွား ထီးတကောင်၊ မီး ရှို့ရာယဇ်ဘို့ သိုး ထီးတကောင်ပါရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","သန့်ရှင်း သော ပိတ်ချော အင်္ကျီ ၊ ပိတ်ချော ပေါင်းဘီ ကို ဝတ် ၍ ၊ ပိတ်ချော ခါးပန်း ကို စည်း ရမည်။ ပိတ်ချော ဗေါင်း ကိုလည်း ဆောင်း ရမည်။ ထိုအဝတ် တန်ဆာတို့သည် သန့်ရှင်း သောကြောင့်၊ ကိုယ်ကို ရေချိုး ပြီးမှ ဝတ်ဆင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် သငယ်နှစ် ကောင်၊ မီး ရှို့ရာယဇ်ဘို့ သိုး တကောင် ကို၊ ဣသရေလ အမျိုးသား ပရိသတ် လက်မှ ခံယူ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","အာရုန် သည် မိမိ နှင့်ဆိုင်သော မိမိအပြစ် ဖြေရာယဇ်နွား ကို ပူဇော် ၍ ၊ မိမိ အဘို့ နှင့် မိမိ အိမ်သူ များ အဘို့ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ဆိတ် နှစ် ကောင်ကိုလည်း ယူ ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၊ ထာဝရဘုရား ရှေ့ တော်၌ ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","အာရုန် သည် ထိုဆိတ် နှစ် ကောင်ကို ထာဝရဘုရား အဘို့ စာရေးတံ တ တံ၊ လွတ်လပ် လဟာအဘို့ တ တံ၊ စာရေးတံ နှစ်တံချ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ထာဝရဘုရား အဘို့ စာရေးတံ ကျ သော ဆိတ် ကို ဆောင် ခဲ့၍ အပြစ် ဖြေရာယဇ်ဘို့ ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","လွတ်လပ် လဟာအဘို့ စာရေးတံ ကျ သော ဆိတ် ကို၊ အသက် ရှင်လျက် ထာဝရဘုရား ရှေ့ တော်၌ ဆက် ၍၊ သူ့ အပေါ် မှာ အပြစ် ဖြေခြင်းကို ပြုပြီးလျှင်၊ တော ၌ လွတ်လပ် လဟာသို့ လွှတ် လိုက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","အာရုန် သည် မိမိ နှင့် ဆိုင်သော အပြစ် ဖြေရာယဇ်နွား ကို ဆောင် ခဲ့ပြီးလျှင် ၊ မိမိ အဘို့ နှင့် မိမိ အိမ်သူ အိမ်သားများအဘို့ အပြစ် ဖြေခြင်းကို ပြု၍ ၊ မိမိ နှင့် ဆိုင်သော အပြစ် ဖြေရာယဇ်နွား ကိုသတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ထာဝရဘုရား ရှေ့ တော် ယဇ် ပလ္လင်မီးခဲ နှင့် ပြည့် သောလင်ပန်း ကို ကိုင် လျက် ၊ ညက်စွာသော နံ့သာ ပေါင်းမွှေးအမှုန့်ကို မိမိ လက် ၌ အပြည့် ယူ၍၊ ကုလားကာ အတွင်း သို့ ဆောင် သွားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ထိုအခါ သူသည်သေ ဘေးနှင့် ကင်းလွတ် မည်အကြောင်း ၊ နံ့သာပေါင်းအခိုးအငွေ့သည် သက်သေခံ ချက် အပေါ် မှာရှိသော သေတ္တာအဖုံး ကို မွှန်း စေခြင်းငှါ ၊ ထာဝရဘုရား ရှေ့ တော်၌ နံ့သာ ပေါင်းကို မီး ပေါ် မှာ တင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","နွား အသွေး အချို့ကိုလည်းယူ ၍ ၊ အရှေ့ မျက်နှာဘက် သေတ္တာဖုံး အပေါ် ၌ လက်ညှိုး နှင့် ဖြန်း ရမည်။ သေတ္တာဖုံး ရှေ့ ၌ လည်း ခုနှစ် ကြိမ် တိုင်အောင်လက်ညှိုး နှင့် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ထိုနောက် လူ များနှင့်ဆိုင်သော အပြစ် ဖြေရာယဇ်ဆိတ် ကိုသတ် ၍ ၊ အသွေး ကို ကုလားကာ အတွင်း သို့ ဆောင် ခဲ့ပြီးလျှင် ၊ နွား အသွေး ကို ဖြန်း သကဲ့သို့ ၊ သေတ္တာဖုံး အပေါ် ၌၎င်း၊ ရှေ့ ၌ ၎င်း ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ဣသရေလ အမျိုးသား တို့၏ မ စင်ကြယ်သော အပြစ်ကြောင့် ၎င်း ၊ ပြစ်မှား သော အပြစ် အမျိုးမျိုး တို့ ကြောင့် ၎င်း ၊ သန့်ရှင်း ရာ ဌာနတော်အဘို့ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ထိုသို့ ဣသရေလအမျိုးသားတို့၏ မ စင်ကြယ်သော အပြစ်ထဲ မှာ နေ ရသော ပရိသတ်စည်းဝေး ရာ တဲ တော်အဘို့ ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","သန့်ရှင်း ရာဌာနတော်၌ အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှါ ဝင် သောအခါ ၊ မိမိ အဘို့ ၊ မိမိ အိမ်သူ အိမ်သားများအဘို့ ၊ ဣသရေလ ပရိသတ် အပေါင်း တို့အဘို့ အပြစ် ဖြေခြင်းကိုပြု၍ မထွက် မှီတိုင်အောင် ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ထဲ မှာ အဘယ်သူ မျှမ နေ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","နောက် တဖန် ထာဝရဘုရား ရှေ့ တော် ယဇ် ပလ္လင်သို့ ထွက် လာ၍ ၊ ထိုပလ္လင် အဘို့ အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှါ၊ နွား အသွေး ၊ ဆိတ် အသွေး ကိုယူ ၍ ယဇ် ပလ္လင်ပတ်လည် ဦးချို တို့၌ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ယဇ်ပလ္လင် အပေါ် ၌လည်း ၊ ထိုအသွေး ကို လက်ညှိုး နှင့် ခုနှစ် ကြိမ် တိုင်အောင်ဖြန်း ၍ ဣသရေလ အမျိုးသား တို့၏ မ စင်ကြယ်သောအပြစ်မှ စင်ကြယ် သန့်ရှင်း စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ထိုသို့ သန့်ရှင်း ရာ ဌာနတော်အဘို့၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အဘို့၊ ယဇ် ပလ္လင်အဘို့ အပြစ် ဖြေခြင်းကို ပြီးစီး ပြီးမှ ၊ အသက် ရှင်သော ဆိတ် ကို ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","အာရုန် သည် အသက် ရှင်သော ဆိတ် ခေါင်း ပေါ် မှာ လက် နှစ် ဘက်ကို တင် လျက် ၊ ဣသရေလ အမျိုးသား တို့၏ ဒုစရိုက် မှစ၍ ပြစ်မှား သောအပြစ် အမျိုးမျိုး ရှိသမျှ တို့ကို ဘော်ပြ ၍ ၊ ဆိတ် ခေါင်း ပေါ် မှာ တင် ထားပြီးလျှင် ၊ တော်လျော် သော လူ တွင် တော သို့ စေလွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","သူ တို့အပြစ် ရှိသမျှ ကို၊ လူမ နေသောအရပ် သို့ ဆောင် သွားသော ထိုဆိတ် ကို တော ၌ လွှတ် လိုက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","တဖန် အာရုန် သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ထဲ သို့ဝင် ၍ ၊ သန့်ရှင်း ရာဌာနတော်ထဲ သို့ အရင် ဝင် သောအခါ ၊ ဝတ် သော ပိတ်ချော အဝတ် ကို ချွတ် ၍ ထို အရပ်၌ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","သန့်ရှင်း ရာ ဌာန ၌ ကိုယ် ကို ရေချိုး ၍ ၊ မိမိ အဝတ် ကို ဝတ် ပြီးမှ တဖန် ထွက် လာ၍ ၊ မိမိ မီး ရှို့ရာယဇ်၊ လူ များမီး ရှို့ရာယဇ်ကို ပူဇော် သဖြင့် ၊ မိမိ အဘို့ နှင့် လူ များအဘို့ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","အပြစ် ဖြေရာ ယဇ်ကောင်ဆီဥ ကို ယဇ် ပလ္လင်ပေါ် မှာ မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","လွတ်လပ် လဟာသို့ ဆိတ် ကို လွှတ် လိုက်သောသူသည်လည်း မိမိ အဝတ် ကို လျှော် ၍ ကိုယ် ကို ရေချိုး ရမည်။ ထို နောက်မှတပ် ထဲ သို့ ဝင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","သန့်ရှင်း ရာဌာနတော်၌ အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှါ ဆောင် သွင်းသော အသွေး နှင့်ဆိုင်သော အပြစ် ဖြေရာယဇ်နွား ကို၎င်း ၊ အပြစ် ဖြေရာယဇ် ဆိတ် ကို၎င်း ၊ တပ် ပြင် သို့ ယူ သွား၍ အရေ ၊ အသား ၊ ချေးနု ကို မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","မီး ရှို့သောသူသည်လည်း မိမိ အဝတ် ကို လျော် ၍ ကိုယ် ကို ရေချိုး ရမည်။ ထို နောက်မှတပ် ထဲ သို့ ဝင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","သင် တို့သည် အစဉ် စောင့်ရသောပညတ် တော်ဟူမူကား၊ အမျိုးသား ချင်းဖြစ်စေ ၊ သင် တို့တွင် တည်း နေသော တပါး အမျိုးသားဖြစ်စေ၊ သတ္တမ လ ဆယ် ရက်နေ့၌ အလုပ် ကို အလျှင်း မ လုပ် ၊ ခြိုးခြံ စွာကျင့် လျက် နေ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","အကြောင်း မူကား၊ သင်တို့သည် ထာဝရဘုရား ရှေ့ တော်၌ အပြစ် ရှိသမျှ တို့နှင့် ကင်းစင် မည်အကြောင်း၊ ထို နေ့ ရက်၌ ယဇ်ပုရောဟိတ်သည် သင် တို့ကို စင်ကြယ် စေခြင်းငှါ ၊ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ထိုနေ့ရက်သည် ထာဝရ ပညတ် တော်အတိုင်း၊ သင် တို့ငြိမ်ဝပ် ရာ ဥပုသ် နေ့၊ ခြိုးခြံ စွာကျင့်ရသောနေ့ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","အဘ အရာ ၌ ယဇ် ပုရောဟိတ်အမှုကို ဆောင်စေခြင်းငှါ ၊ အရင်ယဇ် ပုရောဟိတ်လက် မှ ဘိသိက် နှင့်တကွ ယဇ်ပုရောဟိတ်အရာကို ခံသောသူသည်၊ ထိုအပြစ် ဖြေခြင်းကို ပြုရမည်။ ထိုယဇ်ပုရောဟိတ်သည် သန့်ရှင်း သော ပိတ်ချော အဝတ် ကို ဝတ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","သန့်ရှင်း ရာဌာနတော်အဘို့၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အဘို့၊ ယဇ် ပလ္လင်အဘို့၊ ယဇ် ပုရောဟိတ်များအဘို့၊ ပရိသတ် အပေါင်း တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ဤ ရွေ့ကား၊ ဣသရေလ အမျိုးသား တို့၏ အပြစ် ရှိသမျှ တို့ကြောင့် တနှစ် တခါ အပြစ် ဖြေခြင်းကို ပြုမည်အကြောင်း ၊ သင် တို့သည် အစဉ် စောင့်ရသောပညတ် တော်ဖြစ် သတည်းဟု မောရှေ အား ထာဝရဘုရား မှာ ထားတော်မူသည်အတိုင်း အာရုန်ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","သင်သည် အာရုန် နှင့် သူ ၏သား ၊ ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ဣသရေလ အမျိုးသားတစုံ တယောက်သည် သိုး ၊ ဆိတ် ၊ နွား ကို တပ် ထဲ မှာ သတ် သည်ဖြစ်စေ ၊ တပ် ပြင် မှာ သတ် သည်ဖြစ်စေ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ထာဝရဘုရား ၏ တဲ တော်ရှေ့ တွင် ထာဝရဘုရား အား ပူဇော် သက္ကာ ပြု ခြင်းငှါ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး သို့ မ ဆောင် ခဲ့လျှင် ၊ ထို သူ သည် အသက်သတ်သော အပြစ်ရှိသည်ဟု မှတ် ရမည်။ အသက်သတ်သော ထို သူ ကို သူ ၏အမျိုး မှ ပယ်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ဣသရေလ အမျိုးသား တို့သည် တော ၌ ပူဇော် သောယဇ် တို့ကို၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့တွင် ထာဝရဘုရား ထံ တော်မှာ ယဇ်ပုရောဟိတ် ရှေ့ သို့ ဆောင် ခဲ့၍ ၊ ထာဝရဘုရား အား မိဿဟာယ ယဇ် ပူဇော် စေခြင်းငှါ ထိုသို့ စီရင်ရသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ယဇ် ပုရောဟိတ်သည်၊ ထိုယဇ်ကောင်အသွေး ကို ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၌ရှိသောထာဝရဘုရား ၏ ယဇ် ပလ္လင်ပေါ် မှာ ဖြန်း ၍ ၊ ဆီဥ ကိုလည်း ထာဝရဘုရား အား မွှေးကြိုင် ရာဘို့ မီး ရှို့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","သူ တို့သည် အထက်က မှားယွင်း သကဲ့သို့ နောက် တဖန် နတ်ဆိုး တို့အား ယဇ် မ ပူဇော်ရ။ ဤ ပညတ် သည် သူ တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် တော် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ဣသရေလ အမျိုးသားချင်း ဖြစ်စေ ၊ သင် တို့တွင် တည်း နေသော တပါး အမျိုးသားဖြစ်စေ၊ မီး ရှို့ရာ ယဇ် အစရှိသော အခြားသောယဇ် တစုံတခုကို ပူဇော် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ထာဝရဘုရား အား ပူဇော်သက္ကာပြု ခြင်းငှါ ၊ ပရိသတ်စည်းဝေး ရာ တံခါး သို့ မ ဆောင် ခဲ့လျှင် ၊ ထို သူ ကို သူ ၏အမျိုး မှ ပယ်ရှင်း ရမည်ဟု သူ တို့အား ဆင့်ဆို ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ဣသရေလ အမျိုးသားမှစ၍ ၊ သင် တို့တွင် တည်း နေသောတပါး အမျိုးသားတစုံ တယောက်သည်၊ အသွေး တမျိုးမျိုး ကို စား လျှင် ၊ ထိုသူကို ငါသည် မျက်နှာ ထား ၍ သူ ၏ အမျိုး မှ ပယ်ရှင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","အကြောင်း မူကား၊ ကိုယ်ခန္ဓါ အသက် သည် အသွေး ၌ တည်၏။ သင် တို့ပြုသောအပြစ် ကို ဖြေစေခြင်းငှါ ၊ ထိုအသွေးကို သင် တို့အား ယဇ် ပလ္လင်ပေါ် မှာ ငါ ပေး ပြီ။ လူအပြစ် ကို ဖြေသောအရာကား၊ အသွေး ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ထိုကြောင့် သင် တို့၌ အဘယ်သူ မျှအသွေး ကို မ စား ရ။ သင် တို့တွင် တည်း နေသောတပါး အမျိုးသား လည်း အသွေး ကို မ စား ရဟု ဣသရေလ အမျိုးသား တို့အား ငါ့အမိန့် တော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ဣသရေလ အမျိုးသား မှစ၍ သင် တို့တွင် တည်း နေသောတပါး အမျိုးသားတစုံ တယောက်သည်၊ မုဆိုး လုပ်၍ စားစရာဘို့ သား ၊ ငှက် ကို ဘမ်း မိလျှင် ၊ အသွေး ကို သွန် ၍ မြေ နှင့် ဖုံး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","အသွေး သည် ခပ်သိမ်း သော ကိုယ်ခန္ဓါ အသက် ရှင်ရာအကြောင်းဖြစ်၏။ ထိုကြောင့် သင်တို့သည် တစုံ တခုသောကိုယ်ခန္ဓါ ၏ အသွေး ကို မ စား ရဟု ဣသရေလ အမျိုးသား တို့အား ငါ့အမိန့် တော်ရှိ၏။ ခပ်သိမ်း သော ကိုယ်ခန္ဓါ အသက် သည် အသွေး ၌ တည်သောကြောင့်၊ အသွေးကို စား သောသူ မည်သည်ကား၊ ပယ်ရှင်း ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","အလိုလို သေသောအကောင်၊ သားရဲ ကိုက်၍သေသော အကောင်၏အသားကို စား သော ကိုယ် အမျိုးသား ၊ တပါး အမျိုးသားမည်သည်ကား၊ စားလျှင် မိမိ အဝတ် ကိုလျှော် ၍ ကိုယ်ကို ရေချိုး ရမည်။ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်၏။ ထိုနောက် စင်ကြယ် ခြင်းရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","အဝတ်ကို မ လျှော် ရေ မ ချိုးလျှင် ၊ ကိုယ် အပြစ် ကို ကိုယ်ခံရ မည်ဟု ထာဝရဘုရား သည် ပညတ် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ ၊ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","သင်တို့နေ ဘူးသော အဲဂုတ္တု ပြည် ၏ အကျင့် ကို၎င်း၊ သင် တို့ကို ငါ ပို့ဆောင် လတံ့သော ခါနာန် ပြည် ၏ အကျင့် ကို၎င်း၊ သင်တို့သည် မ ကျင့် ၊ သူ တို့ တရား လမ်းသို့ မ လိုက် ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ငါ စီရင် ချက်ရှိသည်အတိုင်း ကျင့်၍၊ ငါ့ ပညတ် တရားလမ်းသို့ လိုက် ခြင်းငှါ စောင့်ရှောက် ရကြမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ထိုကြောင့် ငါ့ စီရင် ထုံးဖွဲ့ချက်တို့ကို စောင့်ရှောက် ရကြမည်။ ထိုအကျင့် ကို ကျင့် သောသူ သည် ထိုအကျင့်အားဖြင့် အသက် ရှင်လိမ့်မည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","သင်တို့တွင် အဘယ်သူ မျှကိုယ် ပေါက်ဘော်တော်သောသူ ကို ချဉ်း ၍ သံဝါသ မ ပြုရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","သင် ၏ အဘ နှင့်သာဆိုင်သောသင် ၏ အမိ ကို မချဉ်းရ။ ကိုယ် အမိ ဖြစ်သောကြောင့်သံဝါသ မ ပြုရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ကိုယ် အဘ ၏ မယား မည်သည်ကို မ ချဉ်း ရ။ အဘနှင့်သာဆိုင်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","တအိမ် တည်း၌ မွေးဘွား သည်ဖြစ်စေ ၊ အခြား သော အရပ်၌ မွေးဘွား သည်ဖြစ်စေ၊ သင် ၏ နှမ ကို မ ချဉ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ကိုယ်ရင်သွေးဖြစ်သောသင် ၏မြေးကို မ ချဉ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","အမိခြားသော်လည်းတဘတည်းဖြစ်သော နှမ ကို မ ချဉ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","သင့် အဘ ၏ ပေါက်ဘော် ရင်းဖြစ်သော အဘ ၏ နှမ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","သင့် အမိ ၏ ပေါက်ဘော် ရင်းဖြစ်သော အမိ ၏ ညီအစ်မ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","အဘ ၏ ညီအစ်ကို နှင့်သာဆိုင်သော မိကြီး မိထွေးဖြစ်သော အဘ၏ ညီအစ်ကိုမယား ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","သား ၏မယား တည်းဟူသောချွေးမ ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ညီအစ်ကို နှင့်သာဆိုင်သော ညီအစ်ကို ၏ မယား ကို၎င်း မ ချဉ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ကိုယ်မယား၏ ပေါက်ဘော်ရင်းဖြစ်သော မယား၏သမီး၊ မယား၏ မြေးကို မချဉ်းရ။ မတရားသောအမှုဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ကိုယ်မယားကို နှောင့်ရှက် ခြင်းငှါ သူ အသက် ရှင်စဉ် တွင်သူ ၏ ညီအစ်မ ကို မ သိမ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ဥတု ရောက်၍ မ စင်ကြယ်သော မိန်းမ ကို လည်း မ ချဉ်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ကိုယ်ကို ညစ်ညူး စေလျက် ၊ သူ့ မယား ကို မ ပြစ်မှား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","သင် ၏ သား သမီးတို့ကို၊ မောလုတ် ဘုရားအား မီးဖြင့်မ ပူဇော် ရ။ သင် ၏ ဘုရား သခင်နာမ တော်ကို မ ရှုတ် မချရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","မိန်းမ နှင့် ပေါင်းဘော် သကဲ့သို့ယောက်ျား ချင်း မ ပေါင်းဘော် ရ။ ရွံရှာ ဘွယ်အမှုဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ကိုယ့်ကိုကိုယ် ညစ်ညူး စေ၍ တိရစ္ဆာန် နှင့် မ ပေါင်းဘော် ရ။ မိန်းမ သည်လည်း မိမိ နှင့် တိရစ္ဆာန် ၏ ပေါင်းဘော် ခြင်းကို မ ခံရ။ ရွံရှာဘွယ်သော ရောနှောခြင်းဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ထိုသို့ သော အမှုအားဖြင့် ကိုယ်ကို ကိုယ် မ ညစ်ညူး စေရ။ သင် တို့ရှေ့ မှာ ငါ နှင်ထုတ် သော လူ အမျိုးမျိုး တို့သည်၊ ထိုသို့ သောအမှုကို ပြု၍ ညစ်ညူး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","သူတို့ ပြည် သည်လည်း ညစ်ညူး ၏။ ညစ်ညူးသော အပြစ် ကြောင့် ငါဆုံးမ ၍ ၊ ထိုပြည် သည် မိမိ သား တို့ကို အော့အန် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","သင် တို့မူကား ၊ ငါ့ စီရင်ထုံးဖွဲ့ ချက်တို့ကို စောင့်ရှောက် ရကြမည်။ ထိုပြည် သည်သင် တို့ရှေ့ ၌ရှိသော လူအမျိုးမျိုး တို့ကို အော့အန် သကဲ့သို့ တဖန်ညစ်ညူး ခြင်းကိုခံ၍ ၊ သင် တို့ကို မ အော့အန် စေခြင်းငှါ ၊ ကိုယ်အမျိုးသား ဖြစ်စေ ၊ သင် တို့တွင် တည်းနေ သောတပါးအမျိုးသား ဖြစ်စေ၊ ထိုသို့သော ရွံ့ရှာဘွယ် အမှုတို့ကိုမ ပြု ရ။ သင် တို့ရှေ့ ၌ ရှိသော ပြည်သား တို့သည်၊ ထိုသို့သော ရွံ့ရှာဘွယ် အမှုတို့ကိုပြု သောအားဖြင့် သူတို့ပြည် သည်ညစ်ညူး ခြင်းရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ထိုသို့ သော ရွံ့ရှာ ဘွယ်အမှုတို့ကို ပြု သော သူ မည်သည် ကား၊ သူ ၏အမျိုး မှ ပယ်ရှင်း ခြင်း ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","သို့ဖြစ်၍ သင် တို့ရှေ့ ၌ ပြု ဘူးသော ထိုရွံ့ရှာ ဘွယ် ထုံးစံ ဓလေ့သို့ သင်တို့သည် လိုက် ၍ ၊ ကိုယ့်ကိုကိုယ် မ ညစ်ညူး စေခြင်းငှါ၊ ငါ့ ပညတ် တရားကို စောင့်ရှောက် ရကြမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","သင်သည် ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့အား ဆင့်ဆို ရမည်မှာ ၊ သင် တို့၏ ဘုရား သခင်ငါ ထာဝရဘုရား သည် သန့်ရှင်း သောကြောင့် ၊ သင်တို့လည်း သန့်ရှင်း ခြင်းရှိ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","လူတိုင်း ကိုယ် မိဘ ကို ရိုသေ ရမည်။ ငါ့ ဥပုသ် နေ့တို့ကိုလည်း စောင့် ရမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ရုပ်တု ဆင်းတုကိုလည်း မ ချဉ်း မကပ်ရ။ ကိုယ် အဘို့ သွန်း သော ဘုရား တို့ကို မ လုပ် ရ။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","မိဿဟာယ ယဇ်ကို ထာဝရဘုရား အား ပူဇော် လျှင် ၊ စိတ် တော်နှင့်တွေ့အောင် ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ပူဇော် သောနေ့ နှင့် နက်ဖြန် နေ့၌ စား ရမည်။ သန်ဘက် နေ့ တိုင်အောင် ကျန် ကြွင်းလျှင် မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","သန်ဘက် နေ့ ၌ အနည်းငယ်ကိုမျှစား လျှင် ရွံရှာ ဘွယ်ဖြစ်၏။ စိတ် တော်နှင့်မ တွေ့။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","စား သောသူသည် ထာဝရဘုရား ၏ သန့်ရှင်း သောအရာကို ရှုတ်ချ သောကြောင့် မိမိ အပြစ် ကိုခံရ မည်။ ထို သူ ကို သူ ၏အမျိုး မှ ပယ်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ကိုယ် မြေ ၌ဖြစ်သော စပါးကိုရိတ် သောအခါ ၊ လယ် ထောင့် တို့ကို အကုန် အစင်မ ရိတ် ရ။ သိမ်းရာတွင် ကျန်ကြွင်းသော အရာကို ပြန်၍ မကောက်မသိမ်းရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ကိုယ် စပျစ်သီး ကိုလည်း အကုန်အစင်မ သိမ်း ရ။ ကျန်ကြွင်းသော အသီးကို ပြန်၍ မ ဆွတ် ရ။ ထိုအသီးကို ဆင်းရဲ သောသူ ဧည့်သည် အာဂန္တုအဘို့ ချန်ခြွင်းရမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","သူ့ဥစ္စာကို မ ခိုး ရ။ သူတပါး ကို မ လှည့်စား ရ။ တယောက်ကိုတယောက်မုသာ စကားမ ပြောရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ငါ့ နာမ ကို တိုင်တည်၍ မ ဟုတ်မမှန်ဘဲ ကျိန်ဆို ခြင်းကို မ ပြုရ။ သင် ၏ ဘုရား သခင်နာမ ကို မရှုတ် မချရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ကိုယ် နှင့်စပ်ဆိုင်သောသူ ၏ဥစ္စာကို မ တရားသဖြင့် မ သိမ်းရ။ အနိုင် အထက်ပြု၍ မ ယူရ။ သူငှါး ခံ ထိုက်သော အခ ကို တညဉ့်လုံးနံနက် တိုင်အောင် မ ထား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","နားပင်း သောသူကို မ ကျိန်ဆဲ ရ။ မျက်စိ မမြင်သောသူရှေ့ မှာ ထိမိ ၍ လဲစရာကို မ ထား ရ။ သင် ၏ ဘုရား သခင်ကို ကြောက်ရွံ့ ရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","တရား တွေ့သည်အမှုမှာ မ တရားသဖြင့် မ စီရင် ရ။ ဆင်းရဲ သောသူဘက် ၌ မ ငဲ့ကွက် ၊ ကြီး သောသူ၏ မျက်နှာ ကို မ ထောက် ဘဲ၊ ကိုယ်အမျိုးသားချင်းကို တရား သဖြင့် စီရင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","သူ့အသရေ ပျက်သော သိတင်းကို ကြားပြောခြင်းငှါ၊ ကိုယ် အမျိုးသား ချင်းတို့တွင် မ လှည့်လည် ရ။ ကိုယ် နှင့်စပ်ဆိုင်သောသူကို သေစေခြင်းငှါ မကြံစည်ရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","သင် ၏ ညီအစ်ကို ကို စိတ်အခုအခံမရှိရ။ ကိုယ် နှင့် စပ်ဆိုင်သောသူ ၌ရှိသောအပြစ် ကို တတ်တိုင်း မရှိစေဘဲ၊ သူ့ကို အမှန်ဆုံးမ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","သင့် အမျိုးသား ချင်းသည် သင့်ကို ပြစ်မှားလျှင်၊ ကိုယ်တိုင်အပြစ်ပြန်၍ မ တုံ့ ရ။ အငြိုး မ ထားရ။ ကိုယ် နှင့်စပ်ဆိုင်သောသူကို ကိုယ် နှင့် အမျှ ချစ် ရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","ငါ ၏ ပညတ် တရားကို သင်တို့သည် စောင့် ရကြမည်။ အမျိုး ခြားသော တိရစ္ဆာန် အထီးအမတို့ကို မ ရှက် မတင်စေရ။ ခြားနား သော မျိုးစေ့ကို ရောနှော၍ လယ် ၌ မ ကြဲ ရ။ ဝါ နှင့်သိုးမွေးရော၍ ရက်သောအဝတ် ကို မ ဝတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ထိမ်းမြား ဆောင်နှင်းလျက်၊ မ ရွေး မ လွှတ် သေးသော ကျွန် မိန်းမ နှင့် သင့် နေသောသူသည် ရိုက်နှက် ခြင်းကိုခံရ မည်။ ထိုမိန်းမသည် သူ့ကျွန်ဖြစ်သောကြောင့်သေ ပြစ်နှင့် လွတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ယောက်ျားသည်လည်း၊ ဒုစရိုက် ဖြေရာယဇ်ဘို့ သိုး ထီးတကောင်ကို ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး နား ထာဝရဘုရား ထံ တော်သို့ ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ထိုယောက်ျားပြု မိသော အပြစ် ကို ဖြေခြင်းငှါ၊ ဒုစရိုက် ဖြေရာယဇ် သိုး ကို၊ ယဇ် ပုရောဟိတ်သည် ထာဝရဘုရား ရှေ့ မှာ ပူဇော်ရမည်။ ထိုယောက်ျားသည် အပြစ် လွတ်ခြင်းသို့ ရောက်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","သင်တို့သည် ငါပေးသောပြည် သို့ ရောက် ၍ ၊ စားအပ်သော အပင် အမျိုးမျိုး ကို စိုက် ပြီးမှ ၊ သုံး နှစ် ပတ်လုံး သီးသော အသီး ကို၊ အရေဖျား လှီးခြင်းကို မခံသော အသီးဟူ၍မှတ်ရမည်။ ထိုအသီးကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","စတုတ္ထ နှစ် တွင် သီးသောအသီး ရှိသမျှ သည် သန့်ရှင်း ၍ ၊ ထာဝရ ဘုရား၏ ကျေးဇူး တော်ကို ချီးမွမ်းဘို့ရာဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ပဉ္စမ နှစ် တွင် သီးသောအသီး ကို စား ရမည်။ ထိုသို့ပြုလျှင် အပင်တို့သည် သာ၍ သီးကြလိမ့်မည်။ ငါ သည် သင် တို့၏ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","အသွေး ပါသောအသေကောင်ကို မ စား ရ။ မကောင်းသော အတတ်ကို မပြုစုရ။ ကာလဗေဒင်ကို မကြည့်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ဦးခေါင်း အနား ပတ်လည်၌ ဆံပင်ကိုဝန်း၍ မ ရိတ် ရ။ ပါးမုန်း ကိုလည်း မ ရိတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","သေ သောသူအတွက် ကိုယ် အသား ကို မ ခုတ် မရှရ။ သံပူ မ ထိုး ရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ကိုယ် သမီး ကို ပြည်တန်ဆာ ဖြစ်စေခြင်းငှါ မ ရှုတ် မချရ။ သို့ပြုလျှင် တပြည်လုံး သည် မ တရားသောမေထုန် သို့လိုက်၍ အဓမ္မ အမှုနှင့် ပြည့် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ငါ့ ဥပုသ် နေ့တို့ကို စောင့် ၍ ၊ ငါ့ သန့်ရှင်း ရာဌာနတော်ကို ရိုသေ ရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ကိုယ်ကိုကိုယ်ညစ်ညူး စေခြင်းငှါ ၊ နတ်ဝင် သူကို မ မှီဝဲ ရ။ စုန်း လုပ်သူကိုလည်း မ ရှာဖွေ ရ။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","ဆံပင် ဖြူသောသူရှေ့ မှာ ထ ရမည်။ အသက် ကြီးသောသူ၏ မျက်နှာ ကို ရိုသေ ရမည်။ သင် ၏ ဘုရား သခင်ကို ကြောက်ရွံ ရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","သင် ၏ ပြည် ၌ တည်း နေသောဧည့်သည် ကို မ ညှဉ်းဆဲ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","သင် နှင့်အတူ နေ သောဧည့်သည် ကို ကိုယ် အမျိုးသား ချင်းကဲ့သို့ မှတ် ရမည်။ ကိုယ် နှင့် အမျှ ချစ် ရမည်။ သင်တို့သည် အဲဂုတ္တု ပြည် ၌ ဧည့်သည် ဖြစ် ကြဘူးပြီ။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","တိုင်းထွာ သောအမှု၊ ချိန်တွယ် သောအမှု၊ ခြင်တွက် သောအမှု၌ မ တရားစွာ မ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","မှန် သောချိန်ခွင် ၊ မှန် သောအလေး ၊ မှန် သောဧဖာ ၊ မှန် သောဟိန် တို့ကို သုံး ရမည်။ ငါသည်သင် တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် သော သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","သင်တို့သည် ငါ့ စီရင် ထုံးဖွဲ့ချက် အလုံးစုံ တို့ကို စောင့်ရှောက် ရကြမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ဣသရေလ အမျိုးသား ဖြစ်စေ ၊ ဣသရေလ အမျိုး၌ တည်း နေသောတပါး အမျိုးသားဖြစ်စေ၊ မိမိ သား ကို မောလုတ် ဘုရားအား ဆက်ကပ် သော သူသည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ပြည် သား တို့လည်း ခဲ နှင့် ပစ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ငါ့ သန့်ရှင်း ရာဌာနတော်ကို ညစ်ညူး စေလျက် ၊ ငါ့ သန့်ရှင်း သော နာမ တော်ကို ရှုတ်ချ လျက် ၊ မိမိ သား ကို မောလုတ် ဘုရားအား ဆက်ကပ် သောသူကို၊ ငါ သည် မျက်နှာ ထား ၍ သူ ၏ အမျိုး မှ ပယ်ရှင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","မိမိ သား ကို မောလုတ် ဘုရားအား ဆက်ကပ် သောသူကို၊ ပြည် သား တို့သည် အမှုမထား မ သတ် ဘဲ နေလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ထိုသို့ နေသောသူ နှင့် သူ ၏ အိမ်သူ အိမ်သားတို့ကို ၊ ငါ သည် မျက်နှာ ထား ၍ ၊ ထိုသူ ကို၎င်း ၊ သူ နှင့်အတူ မောလုတ် ဘုရားထံ ၌ မှားယွင်း သောသူကို၎င်း ၊ သူ တို့အမျိုး မှ ပယ်ရှင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","လမ်းလွဲ၍ နတ်ဝင် သူ၊ စုန်း လုပ်သူနောက်သို့ လိုက်လျက်၊ မှားယွင်း သောသူကို ငါသည် မျက်နှာ ထား ၍ သူ ၏ အမျိုး မှ ပယ်ရှင်း မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","သင် တို့၏ ဘုရား သခင်ငါ ထာဝရဘုရား သည် သန့်ရှင်းသောကြောင့် ၊ သင်တို့သည် ကိုယ်ကိုသန့်ရှင်း စေ၍ ၊ သန့်ရှင်း ခြင်းရှိ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ငါ့ နည်း နိဿယတို့ကို ကျင့်ဆောင် ရကြမည်။ ငါ သည် သင် တို့ကို သန့်ရှင်း စေသော ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","မိဘ ကို ကျိန်ဆဲ သော သူ တိုင်း အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ မိဘ ကို ကျိန်ဆဲ သောကြောင့်သေထိုက်သော အပြစ်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","သူ့ မယား ကို ပြစ်မှား သောသူသည်၊ မှားယွင်း သော မိန်းမနှင့်တကွ အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ကိုယ် အဘ ၏ မယား နှင့် သင့် နေသော သူ သည် အဘနှင့်သာဆိုင်သောအရာကို ပြစ်မှားသောကြောင့်၊ ထိုမိန်းမနှင့်တကွအသေ သတ်ခြင်းကို အမှန်ခံရမည်။ သေထိုက်သော အပြစ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ယောက်ျား သည် ကိုယ် ချွေးမ နှင့် သင့် နေလျှင် ၊ ထိုသူနှစ်ယောက်တို့သည် ရွံရှာဘွယ်သော ရောနှော ခြင်း ကို ပြု သောကြောင့်အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ သေထိုက်သော အပြစ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","မိန်းမ နှင့်ပေါင်းဘော် သကဲ့သို့ယောက်ျား ခြင်းပေါင်းဘော် လျှင် ထို သူနှစ် ယောက်တို့သည်၊ ရွံရှာ ဘွယ် သောအမှုကို ပြု သောကြောင့်၊ အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ သေထိုက်သော အပြစ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ယောက်ျား သည် သမီး နှင့် အမိ ကို မယား ပြုလျှင် ၊ မ တရားသောအမှုဖြစ်၏။ သင် တို့တွင် မ တရားသော အမှုမ ရှိ စေခြင်းငှါ ၊ ထိုသူ သုံးယောက်တို့ကို မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ယောက်ျား သည် တိရစ္ဆာန် နှင့် ပေါင်းဘော် လျှင် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ထိုတိရစ္ဆာန် ကိုလည်း သတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","မိန်းမ သည်လည်း ၊ မိမိ နှင့် တိရစ္ဆာန် ၏ ပေါင်းဘော် ခြင်းကိုခံလျှင် ၊ ထိုမိန်းမ နှင့် တိရစ္ဆာန် သည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ သေထိုက်သော အပြစ် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ယောက်ျား သည် အဘ ၏သမီး ၊ အမိ ၏သမီး ဖြစ်သော မိမိ နှမ နှင့်သင့် နေလျှင် ၊ မတရားသော အမှုဖြစ်၏။ ထိုသူတို့သည် အမျိုးသား ချင်းတို့ ရှေ့မှောက် ၌ ပယ်ရှင်း ခြင်းကိုခံရကြမည်။ ထိုယောက်ျား သည် နှမ နှင့်သင့်နေသောကြောင့်၊ မိမိ အပြစ် ကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ယောက်ျား သည် ဥတု ရောက်လျက်ရှိသောမိန်းမ နှင့် သင့် နေလျှင် ၊ ထိုသူတို့သည် သဘောတူ၍၊ သွေးသွန် အနာကို ထင်ရှား စေသောကြောင့်၊ သူ တို့အမျိုး မှ ပယ်ရှင်း ခြင်းကိုခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","အဘ ၏နှမ ၊ အမိ ၏ညီမ နှင့်မသင့်မနေရ။ ထိုသို့သော ပေါက်ဘော် ရင်းနှင့် သင့်နေသောသူတို့သည် မိမိ အပြစ် ကိုခံရ ကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","အဘ ၏ ညီအစ်ကို မယားနှင့် သင့် နေလျှင်၊ အဘ ၏ ညီအစ်ကိုနှင့်သာဆိုင်သော အရာကို ပြစ်မှားသောကြောင့်၊ ထိုသူတို့သည် မိမိ အပြစ် ကိုခံရ သဖြင့်၊ တသက်လုံးသား မရဘဲ နေရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ညီအစ်ကို ၏ မယား နှင့် သင့် နေလျှင် ညစ်ညူး သောအမှုဖြစ်၏။ ညီအစ်ကို နှင့်သာ ဆိုင်သောအရာ ကိုပြစ်မှားသောကြောင့်ထိုသူတို့သည် သား မရဘဲနေ ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","သင် တို့ကို ငါ ပို့ဆောင် ၍ နေရာ ချသော ပြည် သည် မ အော့အန် စေခြင်းငှါ ၊ သင်တို့သည် ငါ စီရင် ထုံးဖွဲ့သမျှ တို့ကို ကျင့်ဆောင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","သင် တို့ရှေ့ မှ ငါ နှင်ထုတ် သော လူ အမျိုးမျိုးတို့၏ ဘာသာဓလေ့ သို့ မ လိုက် ရ။ သူတို့သည် ထိုသို့ သော အမှုခပ်သိမ်း တို့ကို ပြု သောကြောင့် ငါရွံရှာ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","သူ တို့ပြည် တည်းဟူသောနို့ နှင့် ပျားရည် စီး သောပြည် ကို သင် တို့သည် အမွေခံ စေခြင်းငှါ ငါ အပိုင်ပေး မည်ဟု ငါ့အမိန့် တော်ရှိပြီ။ ငါသည် သင် တို့ကို အခြားသော အမျိုး နှင့် ခွဲ ထားသော သင် တို့ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ထိုအကြောင်းကြောင့်၊ စင်ကြယ် သောသား ၊ မ စင်ကြယ်သောသား၊ စင်ကြယ် သောငှက် ၊ မ စင်ကြယ်သောငှက်တို့ကို ပိုင်းခြား ရမည်။ ငါခွဲ ထားသည်အတိုင်း ၊ မ စင်ကြယ်သောသား ၊ ငှက် ၊ မြေ ပေါ်မှာ တွား တတ်သော တိရစ္ဆာန်တစုံ တခုအားဖြင့် ကိုယ် ကိုကိုယ်ရွံရှာ ဘွယ် မ ဖြစ်စေရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ငါ ထာဝရဘုရား သန့်ရှင်း သည်ဖြစ်၍ ၊ သင်တို့ကို ငါအလိုရှိသဖြင့်၊ အခြားသော အမျိုး နှင့် ခွဲ ထားသောကြောင့် ၊ ငါ့ အဘို့ သန့်ရှင်း ခြင်းရှိ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ယောက်ျား ဖြစ်စေ ၊ မိန်းမ ဖြစ်စေ၊ နတ်ဝင် သောသူ၊ စုန်း လုပ်သောသူသည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ထိုသို့သောသူကို ခဲ နှင့် ပစ် ရကြမည်။ သူ ၌ သေထိုက်သော အပြစ် ရှိသည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် အာရုန် ၏သား ၊ ယဇ်ပုရောဟိတ် တို့အား ဆင့်ဆို ရမည်မှာ၊ အမျိုးသားချင်း သေသောအတွက် သင်တို့တွင် အဘယ်သူမျှညစ်ညူး ခြင်းမ ရှိရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","သို့ရာတွင်ပေါက်ဘော် ရင်းတည်းဟူသောမိဘ ၊ သား သမီး ၊ ညီအစ်ကို၊ ");
INSERT INTO myajvb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","လင် မနေသောကညာနှမ ရင်းအတွက် ညစ်ညူး ခြင်းကို ခံရသောအခွင့်ရှိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","အမျိုးသား ချင်း သူကြီး အတွက်၊ ကိုယ်ကိုကိုယ်ရှုတ်ချ ၍ ညစ်ညူး ခြင်းမ ရှိရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ယဇ်ပုရောဟိတ်သည် ဆံပင်ကို မ ရိတ် ရ။ ပါးမုန်း ကို မ ရိတ် ရ။ အသား ၌ ခုတ်ရှ ခြင်းကို မ ပြုရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","သူသည် မိမိ ဘုရား သခင်အဘို့ သန့်ရှင်း ရမည်။ မိမိ ဘုရား သခင်၏ နာမ တော်ကို မ ရှုတ် မချရ။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာ၊ မိမိ ဘုရား သခင်၏ အစာအာဟာရကို ပူဇော် သောကြောင့် သန့်ရှင်း ခြင်းရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","သူသည် ပြည်တန်ဆာ မိန်းမ ၊ သီလပျက်သောမိန်းမ၊ လင် နှင့် ကွာ သောမိန်းမ နှင့် မ စုံဘက် ရ။ မိမိ ဘုရား သခင်အဘို့ သန့်ရှင်း ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","သင် ၏ ဘုရား သခင်ပွဲတော် ကို ဆက် သောကြောင့် ၊ သူ့ ကို သန့်ရှင်း စေ၍ ၊ သူသည် သင့် အဘို့ သန့်ရှင်း ရမည်။ သင် တို့ကို သန့်ရှင်း စေသော ငါ ထာဝရဘုရား သန့်ရှင်း ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ယဇ်ပုရောဟိတ် သမီး သည်၊ ပြည်တန်ဆာ လုပ်၍ ကိုယ့်ကိုကိုယ်ရှုတ်ချ လျှင် ၊ မိမိ အဘ ကို ရှုတ်ချ ရာ ရောက်၏။ ထိုသူကို မီး ရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","မိမိ အမျိုးသား ချင်းတို့တွင် ၊ အဝတ်တန်ဆာဆင်လျက်၊ အရာ၌ ခန့်ထား၍ မိမိ ခေါင်း ပေါ် မှာ ဆီ လောင်း ခြင်း ဘိသိက်ကိုခံသော ယဇ်ပုရောဟိတ် မင်း သည်၊ မိမိ ခေါင်း ၌ တန်ဆာ ကို မ ချွတ် ရ။ မိမိ အဝတ် ကို မ ဆုတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","အသေ ကောင်ကို မ ချဉ်း ရ။ မိဘ အတွက် ညစ်ညူး ခြင်းကို မ ခံရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","သန့်ရှင်း ရာဌာနတော်ထဲက မ ထွက် ရ။ မိမိ ဘုရား သခင်၏ သန့်ရှင်း ရာဌာနတော်ကို မ ရှုတ် မချရ။ အကြောင်း မူကား၊ မိမိ ဘုရား သခင်၏ ဘိသိက် ဆီ နှင့်ဆိုင်သော သင်းကျစ် ကို ဆောင်းရသောသူဖြစ် ၏။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ယဇ် ပုရောဟိတ်မင်းသည်၊ အပျို ကညာနှင့် သာစုံဘက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","မုတ်ဆိုးမ ၊ လင်နှင့်ကွာ သောမိန်းမ၊ သီလ ပျက်သောမိန်းမ၊ ပြည်တန်ဆာ မိန်းမနှင့် မ စုံဘက် ရ။ မိမိ အမျိုးသား ချင်း အပျို ကညာနှင့် သာ စုံဘက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","မိမိ သား ကို၊ အမျိုးသား ချင်းတို့တွင် မ ရှုတ် မချရ။ ငါ ထာဝရဘုရား သည်၊ ယဇ် ပုရောဟိတ်မင်းကို သန့်ရှင်း စေသည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","သင်သည် အာရုန် အား ဆင့်ဆို ရမည်မှာ၊ သင် ၏ အမျိုး အစဉ် အဆက်တွင် ကိုယ် ၌ အပြစ် ရှိ သော သူသည်၊ မိမိ ဘုရား သခင်၏ ပွဲတော် ကို ဆက်ကပ် အံ့သောငှါ မ ချဉ်း မကပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","မျက်စိ ကန်းသောသူ ၊ ခြေဆွံ့ သောသူ၊ နှာခေါင်း ပိသောသူ၊ အင်္ဂါ ပိုလွန်သောသူ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","လက် ကျိုး သောသူ၊ ခြေ ကျိုး သောသူ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ကျော ကုန်းသောသူ၊ ပု သောသူ၊ မျက်စိ နာ သောသူ၊ ဝဲ စွဲသောသူ၊ ယားနာ စွဲသောသူ၊ ဝှေးစေ့ ပျက် သောသူသည် မ ချဉ်း မကပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ယဇ်ပုရောဟိတ် အာရုန် အမျိုး တွင် ၊ ကိုယ် ၌ အပြစ် ပါသော သူ တစုံ တယောက်မျှ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာကို ဆက်ကပ် အံ့သောငှါ မ ချဉ်း မကပ်ရ။ ကိုယ် ၌ အပြစ် ပါသောကြောင့်၊ မိမိ ဘုရား သခင်၏ မုန့် တော်ကို ဆက်ကပ် အံ့သောငှါ မ ချဉ်း မကပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","သန့်ရှင်း သော မုန့်ဖြစ်စေ ၊ အလွန်သန့်ရှင်း သော မုန့်ဖြစ်စေ၊ မိမိ ဘုရား သခင်၏ မုန့် တော်ကို စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ကိုယ် ၌ အပြစ် ပါသောကြောင့် ၊ ငါ့ သန့်ရှင်း ရာ ဌာနအရပ်တို့ကို ရှုတ်ချ မည်ကို စိုးရိမ်၍ ၊ ကုလားကာ အတွင်း သို့ မ ဝင် ရ။ ယဇ် ပလ္လင်သို့ မ ချဉ်း မကပ်ရ။ ငါ ထာဝရဘုရား သည် ထိုအရပ်တို့ကို သန့်ရှင်း စေ သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","မောရှေ သည် အာရုန် နှင့် သူ ၏သား ဣသရေလ အမျိုးသား အပေါင်း တို့အား ဆင့်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","အာရုန် နှင့် သူ ၏သား တို့သည် ငါ့ အဘို့ သန့်ရှင်း စေသောအရာအားဖြင့်၊ သန့်ရှင်း သော ငါ ၏ နာမ တော်ကို မ ရှုတ် မချဘဲ၊ ဣသရေလ အမျိုးသား တို့၏ သန့်ရှင်း သော အရာများနှင့် ကိုယ်ကိုကိုယ်ကွာ စေရမည် အကြောင်း ဆင့်ဆို လော့။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ထာဝရဘုရား အဘို့ ဣသရေလ အမျိုးသား သန့်ရှင်း စေသဖြင့် ၊ သန့်ရှင်း ခြင်းရှိသောအရာတို့ကို ၊ ကိုယ် မ စင်ကြယ်လျက် နှင့် ချဉ်းကပ် သော ယဇ်ပုရောဟိတ်အမျိုးသား မည်သည်ကား၊ ငါ့ ထံ မှ ပယ်ရှင်း ခြင်းကိုခံရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","နူနာ ၊ ရိနာ စွဲသော အာရုန် ၏ အမျိုးသား မည်သည်ကား၊ မစင်ကြယ် မှီတိုင်အောင် သန့်ရှင်း သော အရာကို မ စား ရ။ အသေ ကောင်နှင့်ဆိုင်၍ မ သန့်ရှင်းသောအရာကို ထိ သောသူ၊ သုတ် ရည်ထွက် သော သူ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ညစ်ညူး စေ၍ တွား တတ်သော တိရစ္ဆာန်ကိုထိ သော သူ ၊ ညစ်ညူး ခြင်းတစုံ တခုစွဲ၍ ညစ်ညူး သော သူ ၊ ထိုသို့သောသူ ကို ထိ သမျှသော သူ တို့သည်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ကိုယ် ကို ရေ မချိုးဘဲနေလျှင် ၊ သန့်ရှင်း သောအရာကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","နေ ဝင် သောနောက်မှသန့်ရှင်း ခြင်းသို့ ရောက်သည်ဖြစ်၍၊ သန့်ရှင်း သောအရာသည် သူ တို့ စားစရာ ဖြစ်သောကြောင့် ၊ ထို နောက်မှစား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","အလိုလို သေသောအကောင်၊ သားရဲ ကိုက်၍ သေသောအကောင်အားဖြင့် ကိုယ်ကိုညစ်ညူး စေ၍ မ စား ရ။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ယဇ်ပုရောဟိတ်တို့သည် ငါ့ ပညတ် တော်ကို ဖျက် သဖြင့် ၊ ကိုယ် အပြစ် ကိုခံ လျက် မ သေ ရမည်အကြောင်း ငါ့ပညတ်တရားကို စောက်ရှောက် ရကြမည်။ ငါ ထာဝရဘုရား သည် သူ တို့ကို သန့်ရှင်း စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","တပါး အမျိုးသားသည် သန့်ရှင်း သောအရာကို မ စား ရ။ ယဇ်ပုရောဟိတ် ၌ တည်းနေသောဧည့်သည် မစားရ။ သူငှါး လည်း မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ယဇ် ပုရောဟိတ်သည် ကိုယ် ငွေ နှင့် ဝယ် သောသူ၊ သူ ၏ အိမ် ၌မွေး သောသူသည် သူ ၏အစာ ကို စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ယဇ်ပုရောဟိတ် သမီး သည် တပါး အမျိုးသား၏ မယားဖြစ် လျှင် ၊ သန့်ရှင်း သော ပူဇော် သက္ကာအရာကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","သို့ရာတွင် လင် သေသော်၎င်း ၊ လင်နှင့်ကွာ သော်၎င်း၊ သား မ ရှိဘဲ မိမိ အဘ အိမ် သို့ ပြန် ၍ ငယ်စဉ် အခါနေသကဲ့သို့ နေပြန်လျှင်၊ အဘ ၏အစာ ကို စား ရမည်။ တပါး အမျိုးသားမ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","လူ သည် သန့်ရှင်း သောအရာကို မ သိဘဲ စား မိလျှင် ၊ စားမိသောအရာ၏ အဘိုးနှင့်တကွငါး စုတစု ကိုထပ် ၍ ယဇ်ပုရောဟိတ် အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ဣသရေလ အမျိုးသား တို့သည် ထာဝရဘုရား အား ပူဇော် ၍ ၊ သန့်ရှင်း သောအရာတို့ကို မ ရှုတ် မချရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ထိုအရာတို့ကို စား မိ၍ ပြစ်မှားသောအပြစ် ကို မခံ စေရ။ ငါ ထာဝရဘုရား သည် သူ တို့ကို သန့်ရှင်း စေ သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","တဖန် မောရှေ အား ထာဝရဘုရား က သင်သည် အာရုန် နှင့် သူ ၏သား ဣသရေလ အမျိုးသား အပေါင်း တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ဣသရေလ အမျိုးသားဖြစ်စေ ၊ ဣသရေလ အမျိုး၌ တည်းနေသောတပါး အမျိုးသားဖြစ်စေ၊ သစ္စာ ဂတိ ရှိ၍ ပြုသောပူဇော် သက္ကာ၊ အလိုလို ပြုသော ပူဇော်သက္ကာတည်းဟူသောမီး ရှို့ရာယဇ်ကို ထာဝရဘုရား အား ပူဇော် လိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","စိတ် တော်နှင့်တွေ့ခြင်းငှါ ၊ အပြစ် မပါသောသိုး ၊ ဆိတ် ၊ နွား အထီး ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","အပြစ် ပါသောအကောင်ကို မ ပူဇော် ရ။ ပူဇော်လျှင် စိတ် တော်နှင့်မ တွေ့။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","သစ္စာ ဂတိရှိ၍ ပြုသောပူဇော်သက္ကာ၊ အလိုလို ပြုသော ပူဇော်သက္ကာ သိုး ၊ ဆိတ်၊ နွား ကို ထာဝရဘုရား အား ယဇ် ပူဇော် လိုလျှင် ၊ စိတ် တော်နှင့် တွေ့ခြင်းငှါ စုံလင် ရမည်။ အပြစ်တစုံတခုမျှ မရှိရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","မျက်စိ ကန်းသောအပြစ်၊ အရိုးကျိုး သောအပြစ်၊ အင်္ဂါချို့တဲ့ သောအပြစ်၊ မြင်းဖု ရှိသောအပြစ်၊ ဝဲနာ ၊ ယားနာ စွဲသောအပြစ်၊ တစုံတခုရှိလျှင်၊ ထာဝရဘုရား အား မ ပူဇော် ရ။ ယဇ် ပလ္လင်ပေါ် မှာ ထာဝရဘုရား အား မီး ဖြင့် ပူဇော်သက္ကာမ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","သို့ရာတွင် အင်္ဂါ ပိုခြင်း၊ ချို့တဲ့ ခြင်း အပြစ်ရှိသောသိုး ၊ ဆိတ်၊ နွား ကို အလိုလို ပူဇော်သက္ကာဘို့ ပူဇော် ရမည်။ သစ္စာ ဂတိနှင့်ဆိုင်၍ ပူဇော်လျှင် စိတ် တော်နှင့်မ တွေ့။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ကြိတ် နယ် စုတ် ပြတ် ရာ အနာရှိသော အထီးကို ထာဝရဘုရား အား မ ပူဇော် ရ။ သင် တို့ပြည် ၌ ထိုသို့သောအကောင်ကို ပူဇော်သက္ကာမ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ထိုသို့သောအကောင်ကို တပါး အမျိုးသားဆက် သော်လည်း ပျက် သောအပြစ် ပါသောကြောင့် ၊ သင် တို့၏ ဘုရား သခင့်ပွဲတော် ဘို့ မ ပူဇော် ရ။ ပူဇော်လျှင် စိတ် တော်နှင့်မ တွေ့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","သိုး ၊ ဆိတ် ၊ နွား တို့သည် မွေးဘွား သောအခါ ခုနစ် ရက် အတွင်းတွင် သားငယ်ကို အမိ နှင့် မကွာစေရ။ အဋ္ဌမ နေ့ မှစ၍ ထာဝရဘုရား အား မီး ဖြင့် ပူဇော် သက္ကာဘို့ တော်သင့် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","နွား ဖြစ်စေ ၊ သိုး ဆိတ်ဖြစ်စေ၊ သား အမိနှစ်ကောင်ကို တ နေ့ခြင်းတွင် မ သတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ကျေးဇူး တော်ဝန်ခံရာယဇ် ကို ထာဝရဘုရား အား ပူဇော် လိုလျှင် ၊ စိတ် တော်နှင့်တွေ့ခြင်းငှါ ပူဇော် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","တနေ့ ခြင်းတွင် စား ရမည်။ နက်ဖြန်နေ့ တိုင်အောင် မ ကြွင်း စေရ။ ငါ သည်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","သင်တို့သည် ငါ့ ပညတ် တို့ကိုကျင့်စောင့် ရကြမည်။ ငါ သည်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","သန့်ရှင်း သောငါ ၏နာမ တော်ကို မ ရှုတ် မချရ။ ထာဝရဘုရားသန့်ရှင်း တော်မူသည်ဟု ဣသရေလ အမျိုးသား တို့သည် ထင်မှတ်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ငါ သည် သင် တို့၏ ဘုရားသခင် ဖြစ် ခြင်းငှါ ၊ သင် တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် ၍၊ သန့်ရှင်း စေသောထာဝရဘုရား ဖြစ်၏။ ငါ သည်ထာဝရဘုရား ဖြစ်သည်ဟုမိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင်တို့သည် စီရင် ရသောဓမ္မစည်းဝေး ခြင်းတည်းဟူသောငါ ထာဝရဘုရား ၏ ပွဲတော် များဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ခြောက် ရက် ပတ်လုံးအလုပ် လုပ် ရမည်။ သတ္တမ နေ့ ရက်သည် ငြိမ်ဝပ် စွာနေရသော ဥပုသ် နေ့၊ ဓမ္မ စည်းဝေး ခြင်းကို ပြုရသောနေ့ဖြစ်၏။ ထို နေ့၌ သင်တို့သည် အလုပ် မ လုပ် ရကြ။ သင် တို့နေရာ အရပ် ရပ်၌ ထာဝရဘုရား ၏ ဥပုသ်နေ့ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","အချိန် တန်မှ သင်တို့ကြော်ငြာ ရသော ဓမ္မစည်းဝေး ခြင်းတည်းဟူသောထာဝရဘုရား ၏ ပွဲတော် များ ဟူမူကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ပဌမ လ ဆယ် လေး ရက်နေ့ ညဦး ယံ၌ ၊ ထာဝရဘုရား ၏ ပသခါ ပွဲဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","၎င်း လ ဆယ် ငါး ရက် နေ့၌ ထာဝရဘုရား အဘို့ အဇုမပွဲကို ခံရကြမည်။ ခုနစ် ရက် ပတ်လုံးတဆေး မဲ့မုန့် ကို စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ပဌမ နေ့ ၌ ဓမ္မစည်းဝေး ခြင်းကို ပြု ရမည်။ လောကီအလုပ် ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ခုနှစ် ရက် ပတ်လုံးထာဝရဘုရား အား မီး ဖြင့်ပူဇော်သက္ကာကို ပြု ရမည်။ သတ္တမ နေ့ ၌ လည်း ဓမ္မစည်းဝေး ခြင်းကို ပြုရမည်။ လောကီအလုပ် ကို မ လုပ် ရဟု မိန့် တော်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","တဖန် မောရှေ အား ထာဝရဘုရား မိန့် တော်မူသည်ကား၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","သင်တို့သည် ငါ ပေး သော ပြည် သို့ ရောက် ၍ စပါးကိုရိတ် သောအခါ ၊ အဦး ရိတ် သော ကောက်လှိုင်း တစည်းကို ယဇ်ပုရောဟိတ် ထံ သို့ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","သင် တို့သည် စိတ် တော်နှင့် တွေ့ခြင်းငှါ ယဇ် ပုရောဟိတ်သည် ဥပုသ် နေ့လွန်မှ၊ နက်ဖြန် နေ့တွင် ထိုကောက်လှိုင်း ကို ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ကောက်လှိုင်း ကို ချီလွှဲ သောနေ့ ၌ အခါ မလည်အပြစ် မပါသော သိုးသငယ် အထီးကို ထာဝရဘုရား အဘို့ မီး ရှို့ရာယဇ်ပြု၍ ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ထိုယဇ်နှင့်ဆိုင်သောဘောဇဉ်ပူဇော်သက္ကာ ကား၊ ထာဝရဘုရား အား မွှေးကြိုင် ရာဘို့ မီး ဖြင့်ပြုသောပူဇော်သက္ကာတည်းဟူသောဆီ နှင့် ရော သော မုန့်ညက် နှစ် ဩမဲဖြစ်ရမည်။ သွန်း လောင်းရာ ပူဇော်သက္ကာကား၊ စပျစ်ရည် သုံးလောဃ ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","သင် တို့၏ ဘုရား သခင်ထံတော်သို့ ပူဇော် သက္ကာကို ဆောင် ခဲ့သောနေ့မ ရောက်မှီ၌၊ မုန့် ၊ ဆန် လှော်၊ စိမ်း သောအသီးအနှံကို မ စား ရ။ သင် တို့နေရာ အရပ်ရပ် ၌ သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသော ပညတ် တော်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ချီလွှဲ ရာ ပူဇော်သက္ကာကောက်လှိုင်း ကို ဆောင် ခဲ့သောနေ့ ၊ ဥပုသ် နေ့အလွန် နက်ဖြန် နေ့က စ၍သီတင်းခုနစ် သီတင်းစေ့ အောင် ရေတွက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","သတ္တမ ဥပုသ် နေ့အလွန် နက်ဖြန် နေ့အထိ အရက် ငါး ဆယ်တိုင်တိုင်ရေတွက် ပြီးလျှင် ၊ ထာဝရဘုရား အား ဘောဇဉ်ပူဇော်သက္ကာ အသစ် ကို ဆက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ထာဝရဘုရား အဘို့ အဦး သီးသော အသီး၊ တဆေး ဖြင့် ဖောင်းကြွသော မုန့်ညက် နှစ် ဩမဲနှင့် လုပ်သော ချီလွှဲ ရာမုန့် နှစ် လုံးကို သင် တို့အိမ် မှ ထုတ် ဆောင်ခဲ့၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ထိုမုန့် နှင့်တကွ အခါ မလည် အပြစ် မပါသော သိုးသငယ် ခုနစ် ကောင်၊ နွား သငယ် အထီးတကောင်၊ ဆိတ် နှစ် ကောင်ကို ဆက် ၍၊ ဘောဇဉ်ပူဇော်သက္ကာ ၊ သွန်း လောင်းရာ ပူဇော်သက္ကာနှင့်တကွ ၊ ထာဝရဘုရား အား မွှေးကြိုင် ရာဘို့ မီး ဖြင့်ပြုသောပူဇော်သက္ကာ တည်းဟူသောမီး ရှို့ရာယဇ်ကို ထာဝရဘုရား အား ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် သငယ် တကောင် ကို၎င်း၊ မိဿဟာယ ယဇ်ဘို့ အခါ မလည်သော သိုးသငယ် နှစ် ကောင်ကို၎င်း ပူဇော် ၍ ");
INSERT INTO myajvb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ယဇ် ပုရောဟိတ်သည် အဦး သီးသော အသီးမုန့် နှင့်တကွ ချီလွှဲ သဖြင့် ၊ သိုး သငယ်နှစ် ကောင်ပါ လျက်၊ ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ရာ ပူဇော်သက္ကာ ပြုရမည်။ ထိုအရာတို့သည်လည်း၊ ယဇ်ပုရောဟိတ် အဘို့ ထာဝရဘုရား ရှေ့ မှာ သန့်ရှင်း သော အရာဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ထို နေ့ ၌ လည်း ဓမ္မစည်းဝေး ခြင်းကို စီရင် ရကြမည်။ လောကီအလုပ် ကို မ လုပ် ရ။ သင် တို့နေရာ အရပ်ရပ် ၌ သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ကိုယ် မြေ ၌ ဖြစ်သောစပါးကိုရိတ် သောအခါ ၊ လယ် ထောင့် တို့ကို အကုန်အစင်မ ရိတ် ရ။ သိမ်း ရာတွင် ကျန်ကြွင်းသောအရာကို ပြန်၍ မ ကောက် မသိမ်းရ။ ထိုအရာကို ဆင်းရဲ သောသူ ဧည့်သည် အာဂန္တု အဘို့ ချန် ခြွင်းရမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင်တို့သည် သတ္တမ လ ၊ ပဌမ နေ့ရက်၌ တံပိုးမှုတ် ပွဲ၊ ဓမ္မစည်းဝေး ခြင်းကို ပြုရသော ဥပုသ် နေ့ကို စောင့်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","လောကီအလုပ် ကို မ လုပ် ရ။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာကို ဆက် ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","သတ္တမ လ ၊ ဒသမ နေ့သည်လည်း အပြစ် ဖြေရာနေ့ ၊ ဓမ္မ စည်းဝေးခြင်းကို ပြုသောနေ့ဖြစ်၏။ ခြိုးခြံ စွာကျင့် ရမည်။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာကို ဆက်ကပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ထို နေ့ ၌ အဘယ် အလုပ် ကိုမျှ မ လုပ် ရ။ သင် တို့ဘုရား သခင်ထာဝရဘုရား ရှေ့ တော်၌ ကိုယ်အပြစ် ဖြေခြင်းကို ပြုရသောနေ့ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ထို နေ့ ၌ ခြိုးခြံ စွာ မ ကျင့်သောသူ မည်သည် ကား၊ မိမိ အမျိုး မှ ပယ်ရှင်း ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ထို နေ့ ၌ အလုပ် တစုံ တခုကို လုပ် သော သူ မည်သည်ကို၊ သူ ၏အမျိုး မှ ငါပယ်ရှား ဖျက်ဆီးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","အဘယ် အလုပ် ကိုမျှ မ လုပ် ရ။ သင် တို့နေရာ အရပ်ရပ် ၌ သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် တော်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ထို နေ့သည် ငြိမ်ဝပ် စွာ နေရသောနေ့၊ ခြိုးခြံ စွာကျင့်ရသောနေ့ဖြစ်၏။ နဝမ နေ့ ညဦး မှစ၍ နက်ဖြန်ညဦး တိုင်အောင် ဥပုသ် စောင့် ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","သင်တို့သည် သတ္တမ လ ၊ ဆယ် ငါး ရက် နေ့မှစ၍ခုနှစ် ရက် ပတ်လုံးထာဝရဘုရား အဘို့ သကေနေ ပွဲ ကိုခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ပဌမ နေ့ ၌ ဓမ္မစည်းဝေး ခြင်းကို ပြုရမည်။ အလုပ် ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ခုနစ် ရက် ပတ်လုံးထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာကို ဆက်ကပ် ရမည်။ အဋ္ဌမ နေ့ ၌ လည်း၊ ဓမ္မစည်းဝေး ခြင်းကို ပြု ၍ ၊ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာကို ဆက်ကပ် ရမည်။ထူးဆန်းသောစည်းဝေး ခြင်းဖြစ်၍ လောကီ အလုပ်ကိုမ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ဤရွေ့ကား ၊ ထာဝရဘုရား ၏ဥပုသ် နေ့၊ ထာဝရဘုရား အား ဆက်ကပ် ရသော အလှူဒါန၊ သစ္စာဂတိ နှင့်ဆိုင်သောပူဇော်သက္ကာ ၊ အလိုလို ပြုသောပူဇော်သက္ကာမှတပါး၊ နေ့ရက်အသီးသီးတို့၌ထာဝရဘုရားအား မီး ဖြင့်ပြုသောပူဇော်သက္ကာ၊ မီးရှို့ ရာယဇ်၊ ဘောဇဉ်ပူဇော်သက္ကာ ၊ ယဇ် ပူဇော်ခြင်း၊ သွန်းလောင်း ရာပူဇော်သက္ကာကိုပြုစေခြင်းငှါစီရင်ရသောဓမ္မ စည်းဝေးခြင်း၊ ထာဝရဘုရား ၏ပွဲ တော်များဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ထိုမှတပါး၊ သင် တို့သည် မြေ အသီး အနှံကို သိမ်းယူ သောနောက် ၊ သတ္တမ လ ဆယ် ငါး ရက် နေ့မှစ၍ခုနှစ် ရက် ပတ်လုံးထာဝရဘုရား အား ပွဲ ခံကြရမည်။ ပဌမ နေ့ နှင့် အဋ္ဌမ နေ့ ၌ ဥပုသ် စောင့်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ပဌမ နေ့ ၌ ကောင်းမွန် သော သစ်သီး ၊ စွန်ပလွံ ခက် ၊ မိုဃ်းမခ ပင် အစရှိသော အရွက်များ သော အပင် ၏ အကိုင်း အခက်တို့ကိုယူ ၍ ၊ သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ရှေ့ တော်၌ ခုနစ် ရက် ပတ်လုံးရွှင်လန်း ခြင်းကို ပြုရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ထိုပွဲတော် ကို တနှစ် တနှစ်လျှင် ခုနစ် ရက် ပတ်လုံးထာဝရဘုရား အဘို့ ခံရ ကြမည်။ သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် တော်ဖြစ်သတည်း။ ထိုပွဲတော်ကို သတ္တမ လ ၌ ခံရ ကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ဣသရေလ အမျိုးသား တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","သစ်ခက်တဲ ၌ နေ စေကြောင်းကို သင် တို့အမျိုး အစဉ်အဆက်တို့သည် သိမှတ် မည်အကြောင်း ၊ ဣသရေလ အမျိုးသား အပေါင်း တို့သည် သစ်ခက်တဲ ၌ ခုနှစ် ရက် ပတ်လုံးနေ ရကြမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်သည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","မောရှေ သည်လည်း ၊ ထာဝရဘုရား ၏ ပွဲတော် များကို ဣသရေလ အမျိုးသား တို့အား ပြန်ကြား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ပရိသတ်စည်းဝေး ရာ တဲ တော်တွင် သက်သေခံ ချက် ကုလားကာ ပြင် မှာ မီးခုံ ၌ အစဉ် မပြတ်မီး ထွန်းရာဘို့ ၊ သံလွင်သီးကို ထောင်း ၍ ယူသော သံလွင် ဆီ စစ် ကို၊ ဣသရေလ အမျိုးသား တို့သည် သင့် ထံ သို့ဆောင် ခဲ့ရမည်အကြောင်း ဆင့်ဆို လော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","အာရုန် သည်လည်း၊ ညဦး မှ သည် နံနက် တိုင်အောင် ထာဝရဘုရား ရှေ့ တော်၌ ထိုအမှုကို စီရင် ရမည်။ သင် တို့အမျိုး အစဉ် အဆက် စောင့်ရသောပညတ် တော်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","စင်ကြယ် သော မီးခုံ ၌ မီးခွက် များကို၊ အာရုန်သည် ထာဝရဘုရား ရှေ့ တော်မှာ အစဉ် အမြဲပြင်ဆင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","သင်သည် မုန့်ညက် ကိုယူ ၍ ၊ မုန့် တလုံး လျှင် နှစ်ဩမဲစီ၊ မုန့်ဆယ် နှစ် လုံးကို လုပ် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ထာဝရဘုရား ရှေ့ စင်ကြယ် သော စားပွဲ ပေါ် မှာ မုန့်တလုံးပေါ်၌ တလုံးကို ထပ်ဆင့်၍၊ တပုံခြောက် လုံးစီ၊ နှစ် ပုံပုံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာတည်းဟူသောအောက်မေ့ တော်မူဘို့ ရာ ဖြစ်စေ ခြင်းငှါ ထိုမုန့်နှစ်ပုံပေါ် မှာ စင်ကြယ် သော လောဗန် ကို တင် ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ထာဝရဘုရား၏ပဠိညာဉ်နှင့်အညီ၊ ဣသရေလ အမျိုးသား တို့ လက်မှ ခံယူသောထိုမုန့်ကို၊ အာရုန်သည် ထာဝရဘုရား ရှေ့ တော်၌ ဥပုဃ် နေ့ တိုင်းအစဉ် အမြဲပြင်ဆင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ထိုမုန့်ကို အာရုန် နှင့် သူ ၏သား တို့သည် ပိုင်၍၊ သန့်ရှင်း ရာ ဌာန တော်၌ စား ရကြမည်။ ထာဝရဘုရား အား မီး ဖြင့်ပြုသောပူဇော်သက္ကာထဲက ထိုမုန့်သည်၊ ထာဝရ ပညတ် တော်အတိုင်း၊ အာရုန် အဘို့ အလွန်သန့်ရှင်း သော အရာဖြစ် သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","အဲဂုတ္တု လူ နှင့် ဣသရေလ မိန်းမ ရ၍ ဣသရေလ အမျိုးသား တို့နှင့်အတူ လိုက်လာ သောသား တယောက်သည်၊ တပ် ထဲ မှာ ဣသရေလ လူ နှင့် ရန်တွေ့ သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","နာမ တော်ကို ပြစ်မှား လျက် ကျိန်ဆဲ လေ၏။ ထိုသူ ၏ အမိ ကား၊ ဒန် အမျိုး ၊ ဒိဗရိ သမီး ရှေလောမိတ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ပြစ်မှားသောသူကို မောရှေ ထံ သို့ ဆောင် ယူခဲ့၍ ၊ ထာဝရဘုရား ၏ အလို တော်ကို မသိမှီတိုင်အောင်ချုပ် ထား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ထာဝရဘုရား ကလည်း ၊ ကျိန်ဆဲ သောသူကို တပ် ပြင် သို့ ဆောင် သွား၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","သူ၏စကားကို ကြား သော သူအပေါင်း တို့သည် သူ ၏ခေါင်း ပေါ် မှာ လက် ကိုတင် ပြီးမှ ၊ ပရိသတ် အပေါင်း တို့သည် ကျောက်ခဲ နှင့် ပစ်ကြစေ။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ ၊ မိမိ ဘုရား သခင်ကို ကျိန်ဆဲ သောသူသည် မိမိ အပြစ် ကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ထာဝရဘုရား ၏ နာမ တော်ကို ပြစ်မှား သောသူသည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ပရိသတ် အပေါင်း တို့သည်၊ ထိုသူ ကို အမှန် ကျောက်ခဲ နှင့် ပစ်ရကြမည်။ အမျိုးသား ချင်းဖြစ်စေ ၊ တပါး အမျိုးသားဖြစ်စေ၊ နာမ တော်ကို ပြစ်မှား လျှင် အသေ သတ်ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","လူ အသက် ကိုသတ် သောသူ သည်လည်း အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","တိရစ္ဆာန် အသက် ကိုသတ် သောသူသည်လည်း ဥစ္စာရှင်အား တကောင် အတွက် တကောင် ကို လျော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","လူ သည် အိမ်နီးချင်း ကို နာ အောင်ပြု လျှင် ၊ သူ့ ကို ပြု သည်အတိုင်း ကိုယ်ခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","အရိုးကို ချိုး သည်အတွက် အရိုးချိုး ခြင်းကို၎င်း၊ မျက်စိ ကိုဖျက်သည့်အတွက် ၊ မျက်စိ ဖျက်ခြင်းကို၎င်း၊ သွား ကိုချိုးသည်အတွက် ၊ သွား ချိုးခြင်းကို၎င်း၊ သူ့ကို နာကျင် စွာပြု သည်အတိုင်း ၊ ကိုယ်တိုင် နာကျင် စွာ ခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","တိရစ္ဆာန် အသက်ကိုသတ် သောသူသည်၊ တကောင်အတွက် တကောင်ကို ပြန်ပေး ရမည်။ လူ အသက် ကိုသတ် သောသူသည် အသေ သတ်ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ကိုယ်အမျိုးသား ဖြစ်စေ၊ သူတပါး အမျိုးသားဖြစ်စေ၊ တပါး တည်းသောတရား နှင့်သာ စီရင်ခြင်းကိုခံရမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်သည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ဣသရေလ အမျိုးသား တို့သည်၊ ကျိန်ဆဲ သောသူကို တပ် ပြင် သို့ ဆောင် သွား၍ ၊ ကျောက်ခဲ နှင့် ပစ်ရမည် အကြောင်း မောရှေဆင့်ဆိုသည်ဖြစ်၍၊ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူသည် အတိုင်း သူတို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","တဖန် သိနာ တောင် ပေါ် မှာ၊ မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင်တို့သည် ငါ ပေး သော ပြည် သို့ ရောက် သောအခါ ၊ ထိုပြည် သည် ထာဝရဘုရား အဘို့ ဥပုသ် စောင့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ခြောက် နှစ် ပတ်လုံးလယ် လုပ်လျက်၊ စပျစ် ဥယျာဉ်ကို သုတ်သင် ၍ အသီး ကို သိမ်း လျက် နေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","သတ္တမ နှစ် သည်၊ ထာဝရဘုရား အဘို့ ဥပုသ် နှစ်၊ တပြည်လုံး ငြိမ်ဝပ် စွာနေ၍ ဥပုသ် စောင့်ရသောနှစ်ဖြစ်၏။ လယ် မ လုပ် ရ။ စပျစ် ဥယျာဉ်ကို မ သုတ်သင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","လယ်၌ အလိုလို ပေါက်သော အသီး အနှံကိုမျှ မ ရိတ် ရ။ မ သုတ်သင်သော စပျစ်ဥယျာဉ် အသီး ကိုမျှ မ ဆွတ် ရ။ တပြည်လုံး ငြိမ်ဝပ် စွာ နေရသော နှစ် ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ပြည် ဥပုသ် တည်းဟူသောအလိုလို ဖြစ်ပွားသော အရာရှိသမျှသည်၊ သင်ကိုယ်မှစ၍သင် ၏ ကျွန် ၊ ကျွန် မ၊ သူငှါး ၊ ဧည့်သည် စားစရာ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","သင် ၏ ပြည် ၌ ရှိသော သားယဉ် သားရဲ စားစရာဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ဥပုသ် နှစ် ခုနစ် နှစ်ကို ရေတွက် ၍ ၊ ခုနှစ် နှစ် ခုနှစ် လီ တည်းဟူသောလေး ဆယ်ကိုး နှစ် စေ့ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","သတ္တမ လ ဆယ် ရက်နေ့၊ အပြစ် ဖြေခြင်းပြုရာနေ့ ၌ ၊ ယုဘိလတံပိုး ကို တပြည်လုံး မှုတ် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ငါး ဆယ်မြောက်သောနှစ် ကို သန့်ရှင်း စေသဖြင့် ၊ တပြည်လုံး ၌ ပြည်သား အပေါင်း တို့အား ၊ လွတ် ရာ အခွင့်ကို ကြွေးကြော် ရမည်။ ယုဘိလ နှစ်ဖြစ်၍၊ လူတိုင်း မိမိ ပိုင် သောမြေ၊ မိမိ အဆွေ အမျိုးထံ သို့ပြန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ငါး ဆယ်မြောက်သောနှစ် သည် ယုဘိလ နှစ် ဖြစ် သောကြောင့် လယ် မ လုပ်ရ။ အလိုလို ပေါက်သော အပင်ကိုမျှ မ ရိတ် ရ။ မ သုတ်သင်သော စပျစ်ဥယျာဉ်အသီးကိုမျှ မ ဆွတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ယုဘိလ နှစ်သည် သန့်ရှင်း သော နှစ်ဖြစ်သောကြောင့် ၊ လယ် ၌ ရသောအသီး အနှံကိုသာ စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ယုဘိလ နှစ် တွင် လူ တိုင်း မိမိ ပိုင် သော မြေသို့ ပြန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","သင်တို့သည် အချင်းချင်း ရောင်း ဝယ် မှုကို ပြုလျှင် ၊ တယောက် ကို တယောက်မ ညှဉ်းဆဲ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ယုဘိလ နှစ်လွန် ၍ လိုသေးသော နှစ် ပေါင်း၊ အသီး အနှံသီးလတံ့သော နှစ် ပေါင်းကို ရေတွက်၍ ရောင်း ဝယ်မှုကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ထိုသို့ အသီးသီးရသောနှစ်များကို လိုက်၍ ရောင်းသောကြောင့်၊ နှစ်ပေါင်း အနည်းအများအလိုက် အဘိုး လျော့ လျက်၊ တိုး လျက် ရောင်း ဝယ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","သင်တို့သည် တယောက် ကိုတယောက်မ ညှဉ်းဆဲ ရ။ သင် တို့၏ ဘုရား သခင်ကို ကြောက်ရွံ့ ရမည်။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","သင်တို့သည် ငါ့ စီရင် ထုံးဖွဲ့ချက်တို့ကို ကျင့် စောင့်လျှင်၊ ထိုပြည် ၌ ဘေး လွတ်လျက် နေ ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","မြေ သည်လည်း မိမိ အသီး အနှံကိုပေး သဖြင့် ၊ သင်တို့သည် ဝ စွာစား ၍ ဘေး လွတ်လျက် နေ ရကြ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","သင်တို့ကလည်း၊ သတ္တမ နှစ် တွင် ငါတို့သည် အဘယ် သို့စား ရမည်နည်း။ လယ် မ လုပ်ရ။ အသီး အနှံကို မ သိမ်း ရပါတကားဟု ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ဆဌမ နှစ် တွင် သင် တို့ကို ငါ ကောင်းကြီး ပေး၍ ၊ ထိုနှစ်တွင် သုံး နှစ် အဘို့ အသီး အနှံကို ဖြစ် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","သင်တို့သည် အဋ္ဌမ နှစ် တွင် လယ် လုပ်၍ နဝမ နှစ် တွင် အသီး အနှံကို သိမ်းရာ ကာလတိုင်အောင် ဟောင်း သော အသီး အနှံကို စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","မြေ ကို သူတပါး အစဉ် ပိုင်စေခြင်းငှါမ ရောင်း ရ။ မြေ သည် ငါ့ ဥစ္စာဖြစ်၏။ သင် တို့သည် ငါ ၌ တည်းသော ဧည့်သည် အာဂန္တုဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","သင် တို့သည် မြေ ကို ပိုင် လေရာရာ ၌ ရွေးနှုတ် ရသောအခွင့်ကိုပေး ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","သင် ၏ အမျိုးသား ချင်းသည် ဆင်းရဲ ၍၊ မိမိ ပိုင် သောမြေကို ရောင်း လျှင် ၎င်း ၊ သူ ၏ပေါက်ဘော် တစုံတယောက်သည် ဝယ်ခြင်းငှါလာ လျှင် ၎င်း၊ မိမိ ပေါက်ဘော် ရောင်း သောဥစ္စာကို ရွေးနှုတ် ရသောအခွင့်ရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ထိုမြေကို ရွေးနှုတ်သောသူတယောက်မျှ မပေါ်မရှိ၍၊ မြေရှင်ဟောင်းသည် ကိုယ်တိုင်ရွေးနှုတ်နိုင်လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","မိမိ မြေ သို့ ပြန် အံ့သောငှါ ၊ ရောင်း ၍လွန်သော နှစ် ပေါင်းကို ရေတွက် ပြီးမှ ၊ လိုသေးသော အဘိုးကို အထက်က ရောင်း ခဲ့သော သူ အား ပြန် ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ပြန်၍မ ပေး နိုင်လျှင် ရောင်း ခဲ့သောဥစ္စာကို ယုဘိလ နှစ် တိုင်အောင် ဝယ် သောသူလက် ၌ ရှိ စေရမည်။ ယုဘိလ နှစ်တွင် လက်လွှတ် ၍ အရှင်ဟောင်းလက်သို့ ရောက် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","မြို့ ထဲ၌ရှိသောအိမ် ကို အိမ်ရှင်ရောင်း လျှင် ၊ တနှစ် အတွင်းတွင် ရွေးနှုတ် သော အခွင့်ရှိ စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","တနှစ် အတွင်းတွင် မ ရွေးနှုတ် လျှင် ၊ ထို အိမ် ကို ဝယ် သောသူမှစ၍သားစဉ် မြေးဆက်တို့သည် အမြဲ ပိုင်ရကြမည်။ ယုဘိလ နှစ်ရောက်သော်လည်းလက်မ လွှတ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","မြို့ရိုး မ ရှိ၊ ရွာ ၌ရှိသောအိမ် ကို လယ်ယာ ကဲ့သို့မှတ် ၍ ရွေးနှုတ် ရသောအခွင့်ရှိ ၏။ ယုဘိလ နှစ်ရောက်သောအခါ လက်လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","သို့ရာတွင် လေဝိ သားပိုင်သော မြို့ နှင့်မြို့ အိမ် တို့ကို၊ အဘယ် ကာလအချိန်မဆိုဘဲ ရွေးနှုတ် ရသောအခွင့်ရှိ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","လေဝိ သားပိုင် သော မြို့ ကို၎င်း၊ အိမ် ကို၎င်း၊ သူတပါးဝယ်လျှင်၊ ယုဘိလ နှစ်ရောက်သောအခါ လက်လွှတ် ရမည်။ အကြောင်း မူကား၊ ဣသရေလ လူအမျိုးသားတို့တွင် လေဝိ သားတို့သည်၊ ကိုယ် နေရာ မြို့ အိမ် မှတပါး အခြားသော ဥစ္စာမရှိ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","သို့ ဆိုသော်လည်း၊ လေဝိ သားမြို့ နယ် ၌ရှိသောလယ်ယာ တို့ကို မ ရောင်း ရ။ အစဉ် အမြဲပိုင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","သင် ၏ အမျိုးသား ချင်းသည် ဆင်းရဲ ၍ လက် အားလျော့ သဖြင့် တပါး အမျိုးသားဧည့်သည် အာဂန္တု ကဲ့သို့ဖြစ်လျှင်၊ သင့် ထံ မှာနေ စေခြင်းငှါ သူ့ ကို မစ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","သူ၌ အတိုး အပွားကို မ ယူ ရ။ သင် ၏ အမျိုးသား ချင်းသည် သင့် ထံ မှာနေ စေခြင်းငှါ ၊ သင် ၏ ဘုရား သခင်ကို ကြောက်ရွံ့ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","အတိုး အပွါး ကို မြော်လင့်၍ ငွေ ကို၎င်း၊ စားစရာ ကို၎င်း၊ သူ ၌ မ ချေး မငှါးရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ငါသည် ခါနာန် ပြည် ကို သင် တို့အား ပေး ၍ ၊ သင် တို့၏ ဘုရား သခင်ဖြစ် အံ့သောငှါ ၊ သင် တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ် ဆောင်သော သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","သင် ၏ အမျိုးသား ချင်းသည် ဆင်းရဲ ၍ သင် ၌ အရောင်း ခံလျှင် ၊ အစေခံ ကျွန်ကိုပြု သကဲ့သို့သူ့ ကို အနိုင်မ ပြု ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","သူသည် သူငှါး ကဲ့သို့ ၎င်း၊ ဧည့်သည် ကဲ့သို့ ၎င်း၊ သင့် ထံ မှာနေ ၍ ယုဘိလ နှစ် တိုင်အောင် အစေခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ထိုအခါ သူ သည် သား သမီးနှင့်တကွ ထွက် ၍ ၊ မိမိ အဆွေ အမျိုး၊ မိမိ ဘိုး ဘပိုင် သောမြေသို့ ပြန် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","အကြောင်း မူကား၊ သူ တို့သည် အဲဂုတ္တု ပြည် မှ ငါနှုတ် ဆောင်သော ငါ ၏ အမှုထမ်း ဖြစ်၍၊ အစေခံ ကျွန်ဖြစ်စေခြင်းငှါ၊ မ ရောင်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","သူ့ ကို ကြမ်းတမ်း စွာ မ စီရင် ရ။ သင် ၏ ဘုရား သခင်ကို ကြောက်ရွံ့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","သင် သည် စေခိုင်းသောကျွန် ၊ ကျွန် မတို့ကို၊ သင့် ပတ်လည် ဝန်းကျင်တို့၌ နေသော သာသနာပ လူတို့ တွင် ဝယ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ထိုမှတပါး၊ သင် တို့တွင် တည်း နေသောတကျွန်း တနိုင်ငံသားတို့ကို၎င်း၊ သင် တို့ပြည် ၌ သူတို့ရ သော သား သမီးများကို ၎င်းဝယ် ၍ ပိုင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","သူတို့သည် ကျွန်သားပေါက်ဖြစ်၍၊ သင် တို့နှင့် သင် တို့သား သမီးတို့သည် အမွေ ခံ၍ ပိုင် ရမည်။ ကိုယ် အမျိုးသား ချင်းတည်းဟူသောဣသရေလ အမျိုးသား ဖြစ်လျှင်၊ တယောက် ကိုတယောက်ကြမ်းတမ်း စွာ မ စီရင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","သင့် အနား မှာတည်းနေသောတကျွန်း တနိုင်ငံသားသည် ငွေရတတ် ၍ သူ ၏အနား မှာနေသောသင် ၏ အမျိုးသားချင်း ဆင်းရဲ သဖြင့် ၊ သင့် အနား မှာ တည်းနေသောတကျွန်း တနိုင်ငံသား၌ ၎င်း၊ သူ၏ သား မြေး၌ ၎င်း၊ ကိုယ်ကိုရောင်းချ လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ရောင်း ပြီးမှ ရွေးနှုတ် သော အခွင့်ရှိ စေရမည်။ မိမိ အမျိုးသား တစုံ တယောက်သည် ရွေးနှုတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ဘကြီး ၊ ဘထွေး၊ ညီအစ်ကို တော်မှစ၍အဆွေ အမျိုးပေါက်ဘော် ရင်း တစုံတယောက်သည် ရွေးနှုတ် ရမည်။ ကိုယ်တိုင်တတ်နိုင် လျှင်လည်း ကိုယ်ကိုရွေးနှုတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","သခင်နှင့် ကျွန်တို့သည်၊ ရောင်း ဝယ်သော နှစ် မှစ၍ ယုဘိလ နှစ် တိုင်အောင် နှစ်ပေါင်းကို ရေတွက် ပြီးလျှင် ၊ နှစ်ပေါင်းအနည်းအများကိုထောက်၍၎င်း၊ သူငှါး လုပ် ရသည် ကာလ ကို ထောက်၍၎င်း၊ ကိုယ် အဘိုး ကို စီရင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ယုဘိလ နှစ် မ ရောက်မှီ၊ အစေခံရသောနှစ် ပေါင်း အနည်း အများကို ရေတွက် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","လိုသေးသော နှစ် ပေါင်း အနည်းအများ အလိုက် ရွေးရန်အဘိုးကို၊ ဝယ် ရင်းငွေ ထဲက နှုတ် ၍ ပြန် ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ထိုသူသည် တနှစ် နောက်တနှစ်၊ သူငှါး ကဲ့သို့ နေ ရမည်။ သင့် မျက်မှောက် ၌ ညှဉ်းဆဲ ခြင်းကို မ ခံရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ထိုသို့သောနည်းဖြင့် မ ရွေး မနှုတ်လျှင် ၊ ယုဘိလ နှစ် ရောက်သောအခါ ၊ သူ့ ကို သား မယားနှင့်တကွ သခင်လက်မှ လွှတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","အကြောင်း မူကား၊ ဣသရေလ အမျိုးသား တို့သည်၊ ငါ ၏ အမှုထမ်း ဖြစ်ကြ၏။ အဲဂုတ္တု ပြည် မှ ငါနှုတ် ဆောင်ခဲ့သော ငါ၏ အမှုထမ်းဖြစ်ကြ၏။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","သင် တို့သည် ကိုယ် အဘို့ ထုလုပ် သော ရုပ်တု ဆင်းတု ကို မ ရှိစေရ။ သင် တို့ပြည် ၌ ကိုးကွယ် စရာ မှတ်တိုင် ကို မ စိုက် ရ။ ထုသောကျောက် ကို ထောင်၍မ ထား ရ။ ငါ သည် သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ငါ့ ဥပုသ် နေ့တို့ကိုစောင့် ၍ ၊ ငါ့ သန့်ရှင်း ရာဌာနတော်ကို ရိုသေ ရမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","သင်တို့သည်၊ ငါ့ ထုံးဖွဲ့ ရာလမ်းသို့ လိုက် ၍၊ ငါ ပညတ် တို့ကို ကျင့် စောင့် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","အချိန် တန်မှ ငါသည် သင် တို့အဘို့ မိုဃ်း ရွာစေ သဖြင့် ၊ မြေ သည် မိမိ ဘဏ္ဍာ ကိုပေး ၍ ၊ ဥယျာဉ် အပင် တို့သည် အသီး သီး ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","စပါးနင်း နယ်သော အမှုသည်၊ စပျစ်သီး ညှစ်ရာ ကာလတိုင်အောင်၎င်း၊ စပျစ်သီး ညှစ်သောအမှုသည်၊ မျိုးစေ့ ကြဲရာ ကာလတိုင်အောင်၎င်း မှီ သဖြင့် ၊ သင်တို့သည် ဝ စွာစား ၍ ၊ ကိုယ် ပြည် ၌ ဘေး လွတ်လျက် နေ ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","သင်တို့ပြည် ၌ စစ်မှုကို ငါငြိမ်း စေ၍ ၊ ခြိမ်းချောက် သောသူ မ ရှိဘဲ သင်တို့သည် အိပ် ရကြလိမ့်မည်။ ဆိုး သော သားရဲ တို့ကိုလည်း ငါပယ်ရှား မည်။ တပြည်လုံး သည် ထား ဘေးနှင့် ကင်းလွတ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","သင်တို့သည် ရန်သူ များကို လိုက် ၍ ထား လက်နက်ဖြင့် အောင်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","သင် တို့တွင် လူငါး ယောက်သည်၊ ရန်သူတရာ ကို လိုက် လိမ့်မည်။ လူတရာ သည် ရန်သူ တ သောင်းကို ပြေး စေ၍ ၊ ထား လက်နက်ဖြင့် အောင် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","သင် တို့ကို ငါစောင့်မ သဖြင့် တိုးပွား များပြားစေ၍ ၊ သင် တို့နှင့် ငါ ပြုသော ပဋိညာဉ် ကို ငါမြဲမြံ စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","သိုထားသော စပါးဟောင်း ကို စား ၍ မကုန်မှီ၊ စပါးသစ် ပေါ်သောကြောင့် ၊ အဟောင်း ကို ထုတ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ငါသည် စက်ဆုပ် ရွံရှာခြင်းမ ရှိဘဲ သင် တို့တွင် တဲ တော်ကို တည် မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","သင် တို့တွင် လည်း လှည့်လည် ၍ သင် တို့၏ ဘုရား သခင်ဖြစ် မည်။ သင် တို့သည်လည်း ငါ ၏ လူ ဖြစ် ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","အဲဂုတ္တု ပြည် ၌ အစေ ကျွန်ခံရ သော သင် တို့ကို ငါလွှတ်၍ နှုတ် ဆောင်သော သင် တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ သင် တို့၏ ထမ်းဘိုး ကြိုးကို ငါဖြတ် ၍ သင် တို့ကို တည့်မတ် စေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","သင်တို့သည် ငါ့ စကားကို နား မထောင်၊ ဤ ပညတ် အလုံးစုံ ကို မ စောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ငါ့ စီရင် ထုံးဖွဲ့ချက်များကို ရွံရှာ ၍ ၊ မထီမဲ့မြင် ပြုလျက် ၊ ငါ့ ပညတ် တရားကိုမ ကျင့် ၊ ငါ့ ပဋိညာဉ် သစ္စာကို ဖျက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","သင် တို့၌ ငါ ပြု လတံ့သောအမှုဟူမူကား ၊ သင် တို့၌ မျက်စိ ပျက် လျက် ၊ စိတ်ပူပန် လျက် ရှိစေခြင်းငှါ၊ ထိတ်လန့် သော သဘော၊ တူလာ ၊ ဖျားနာ တို့ကို သင်တို့အပေါ်မှာ ငါခန့် ထားမည်။ သင် တို့သည် မျိုးစေ့ ကို ကြဲ သော်လည်းအကျိုး မရှိ။ ရန်သူ တို့သည် အသီးအနှံကို စား ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","သင် တို့ကို ငါ မျက်နှာ ထား ၍ ၊ ရန်သူ ရှေ့ မှာ ဆုံး စေမည်။ သင် တို့သည် ရန်သူ ၏ အုပ်စိုး ခြင်းကို ခံရ၍ ၊ အဘယ်သူမျှမ လိုက် သော်လည်း ၊ ပြေး ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ထိုမျှလောက် ခံရသော်လည်း၊ ငါ့ စကားကို နား မ ထောင်ဘဲ နေသေးလျှင် ၊ သင် တို့အပြစ် ကြောင့် ခုနစ် ဆသော ဒဏ် ကို ငါပေးဦးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","သင် တို့မာန အစွယ်ကို ငါချိုး မည်။ မိုဃ်းကောင်းကင် ကို သံ ကဲ့သို့ ၎င်း၊ မြေကြီး ကို ကြေးဝါ ကဲ့သို့ ၎င်း၊ ငါဖြစ် စေသဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","သင် တို့သည် အချည်းနှီး ကြိုးစား အားထုတ် ကြလိမ့်မည်။ သင် တို့မြေ သည် မိမိ ဘဏ္ဍာ ကို မ ပေး။ ဥယျာဉ် အပင် တို့သည် အသီး မ သီး ကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","သင်တို့သည် ငါ့ စကားကို နား မ ထောင်၊ ငါ့ ကို ဆန့်ကျင်ဘက် ပြုလျှင် ၊ သင် တို့အပြစ် အလျောက် ခုနစ် ဆ သောဘေး ကြီးကို ငါသက်ရောက်စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","သင် တို့၏ သား သမီးများကို ချီသွား၍ ၊ သင် တို့၏ တိရစ္ဆာန် များကို ဖျက်ဆီး လျက် ၊ သင် တို့ကို နည်း စေ ခြင်းငှါ ၊ သားရဲ များကို ငါစေလွှတ် သဖြင့် ၊ သင် တို့သွားရာ လမ်းမ တို့သည် လူဆိတ်ညံ ရာ ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ထိုသို့ ခံရသော်လည်း၊ သင်တို့သည် သတိမရ၊ ငါ့ ကို ဆန့်ကျင် ဘက် ပြုသေးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ငါ သည်လည်း သင် တို့ကို ဆန့်ကျင် ဘက်ပြု၍ ၊ သင် တို့အပြစ် ကြောင့် ခုနစ် ဆသော ဒဏ် ကိုပေး ဦးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ငါ့ပဋိညာဉ် ဘက်၌ နေ၍၊ တရားစီရင် ရသောထား ဘေးကိုသင် တို့အပေါ် မှာ ငါသက်ရောက် စေမည်။ သင် တို့သည် မြို့ ထဲ ၌ စုဝေး သောအခါ ၊ ကာလနာ ဘေးကို ငါစေလွတ် ၍ ၊ ရန်သူ လက် သို့ ရောက် စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","သင် တို့၏ အစာ အာဟာရ အထောက် အပင့်ကို ငါ ပယ်ရှား သောအခါ ၊ မိန်းမ တကျိပ် တို့သည် သင် တို့၏ မုန့် ကို မီးဖို တဖို၌ ဖုတ် ပြီးမှ ၊ ထိုမုန့် ကို ချိန် ပေးသဖြင့် သင်တို့သည် ဝ စွာမ စား ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ထိုမျှလောက် ခံရသော်လည်း၊ ငါ့ စကားကို နား မ ထောင်၊ ငါ့ ကို ဆန့်ကျင် ဘက် ပြုသေးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ငါသည်လည်း အမျက် ထွက်၍ သင် တို့ကို ဆန့်ကျင် ဘက်ပြုသဖြင့် ၊ သင် တို့အပြစ် ကြောင့် ခုနစ် ဆ သော ဒဏ် ကိုပေး ဦးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","သင်တို့သည် ကိုယ် သား သမီး တို့၏ အသား ကို စား ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","သင် တို့မြင့် သော အရပ်များကို ငါဖြိုဖျက် ၍ ၊ ရုပ်တု ဆင်းတုများကို ခုတ်လှဲ မည်။ သင် တို့အသေ ကောင် များကို၊ ရုပ်တု ဆင်းတုအသေ ကောင်အပေါ် မှာ ပစ်ချ ၍ ၊ သင် တို့ကို စက်ဆုပ် ရွံရှာမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","သင် တို့မြို့ များကို ငါဖျက်ဆီး ၍ ၊ သန့်ရှင်း ရာဌာနတော်ကို သုတ်သင် ပယ်ရှင်းသဖြင့် ၊ သင် တို့နံ့သာပေါင်း အမွှေး အကြိုင်ကို ငါမ နမ်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","တပြည်လုံး ကို ငါ သုတ်သင် ပယ်ရှင်းသော အမှုကို၊ ထိုပြည်၌ နေ သော သင် တို့၏ ရန်သူ တို့သည် မြင်၍ မိန်းမော တွေဝေကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","သာသနာပ လူတို့တွင် သင် တို့ကို အရပ်ရပ်ငါကွဲပြား စေ၍ ၊ ထား မိုးလျက် လိုက်မည်။ သင် တို့ပြည် သည်လည်း လူဆိတ်ညံ လျက် ၊ မြို့ သည်လည်း ပျက်စီး လျက်ရှိ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ထိုသို့ သင် တို့သည် ရန်သူ ပြည် ၌ နေ၍၊ ကိုယ်ပြည် သည် လူဆိတ်ညံ လျက်နေသောကာလ ပတ်လုံး ငြိမ်ဝပ် စွာနေ၍ ၊ မိမိ ဥပုသ် နေ့တို့၌ မွေ့လျော် ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","လူဆိတ်ညံ လျက်နေရသော ကာလ ပတ်လုံး ငြိမ်ဝပ် လိမ့်မည်။ သင် တို့ရှိနေ သောအခါ ၊ ဥပုသ် နေ့တို့၌ ပြည်သည် မ ငြိမ် မဝပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ရန်သူ ပြည် မှာ ကျန် ကြွင်းသော သင် တို့စိတ် နှလုံးထဲ သို့၊ ထိတ်လန့် သော သဘောကို ငါပေးသွင်း သဖြင့် ၊ သစ်ရွက် လှုပ်သံ ကြောင့် သင်တို့သည် ကြောက်၍၊ ထား ဘေးမှ ပြေး သကဲ့သို့ပြေးကြလိမ့်မည်။ အဘယ်သူမျှ မ လိုက် သော်လည်းလဲ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","အဘယ်သူမျှမ လိုက် ဘဲ ထား ဘေးမှ ပြေးသောသူကဲ့သို့ တယောက် အပေါ် မှာ တယောက် လဲ ကြလိမ့်မည်။ ရန်သူ ရှေ့ မှာ ရပ် နိုင်သော တန်ခိုးမ ရှိ ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ရန်သူ ပြည် သည် သင် တို့ကို မျိုစား ၍ ၊ သာသနာပ လူတို့တွင် ဆုံးရှုံး ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ကျန် ကြွင်းသော သင် တို့သည်၊ ရန်သူ ပြည် ၌ ကိုယ် အပြစ် ၊ ဘိုးဘ တို့အပြစ် ကိုခံ လျက်၊ ဘိုးဘနှင့်တကွ အားလျော့ ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","သို့ရာတွင် သူတို့သည် ငါ့ ကို ပြစ်မှား ၍ ၊ ငါ့ ကို ဆန့်ကျင် ဘက်ပြုသောကြောင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ငါ သည် သူ တို့ကို ဆန့်ကျင် ဘက်ပြု၍ ရန်သူ ပြည် သို့ ပို့ဆောင် သော အကြောင်းများနှင့်တကွ၊ ကိုယ် အပြစ် ၊ ဘိုးဘ တို့ အပြစ် များကို ဘော်ပြ တောင်းပန်လျှင်၎င်း၊ အရေဖျား လှီးခြင်းကို မခံသော မိမိ တို့ နှလုံး ကို နှိမ့်ချ ၍ ၊ မိမိ တို့အပြစ် ကြောင့် ခံရသောဒဏ်ကို ဝန်ခံလျှင်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ငါသည် ယာကုပ် နှင့်ပြုသောပဋိညာဉ် ၊ ဣဇာက် နှင့်ပြုသောပဋိညာဉ် ၊ အာဗြဟံ နှင့်ပြုသောပဋိညာဉ် ကို၎င်း၊ ထိုပြည် ကို၎င်းငါအောက်မေ့ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ထိုပြည် သည် သူ တို့ လက်မှ လွတ် ၍၊ သူ တို့မရှိဘဲ လူဆိတ်ညံ လျက်နေစဉ် တွင် မိမိ ဥပုသ် နေ့တို့၌ မွေ့လျော် လိမ့်မည်။ သူတို့သည် ငါ့ စီရင် ထုံးဖွဲ့ချက်များကို ရွံရှာ ၍ မထီမဲ့မြင် ပြုသော အပြစ် ကြောင့်၊ ခံရသောဒဏ်ကို ဝန်ခံရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","သို့ရာတွင် ရန်သူ ပြည် ၌ နေ ကြသောအခါ ၊ သူ တို့ကို ရှင်းရှင်းဖျက်ဆီး ၍ ၊ သူ တို့နှင့် ငါပြုသော ပဋိညာဉ် ကို ပယ် သည်တိုင်အောင် သူ တို့ကို ငါမ စွန့်ပစ် မ ရွံရှာ။ ငါ သည် သူ တို့၏ ဘုရား သခင်ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ငါသည် သူ တို့၏ ဘုရား သခင်ဖြစ် အံ့သောငှါ သာသနာပ လူတို့ မျက်မှောက် ၌ ၊ အဲဂုတ္တု ပြည် မှ ငါနှုတ် ဆောင်သော သူ တို့ ဘိုးဘေး နှင့် ငါပြုသော ပဋိညာဉ် ကို သူ တို့အတွက် ငါအောက်မေ့ မည်၊ ငါ သည် ထာဝရဘုရား ဖြစ်သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ဤ ရွေ့ကား ထာဝရဘုရား သည်၊ သိနာ တောင် ပေါ် မှာ ဣသရေလ အမျိုးသား တို့အဘို့ မောရှေ လက် တွင် ထား တော်မူသော စီရင် ထုံးဖွဲ့ချက် ပညတ် တရား ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ လူ သည် သစ္စာ ဂတိပြု ၍ ပူဇော်လျှင်၊ ပူဇော်အပ်သောသူသည်၊ သင် အဘိုး ပြတ်သည်အတိုင်း ထာဝရဘုရား ၏ ဘဏ္ဍာတော် ဖြစ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","သင် သည် အဘယ်မျှ အဘိုး ပြတ်ရမည်နည်းဟူမူကား၊ ယောက်ျား ကို အသက် နှစ် ဆယ်မှသည် ခြောက် ဆယ်တိုင်အောင် ၊ အကျပ် တော်အလိုက် ငွေ အကျပ် ငါး ဆယ်နှင့် အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","မိန်းမ ဖြစ်လျှင် ၊ ငွေအကျပ် သုံး ဆယ်နှင့် အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","အသက် ငါး နှစ်မှ သည် ဆယ်နှစ်တိုင်အောင် ၊ ယောက်ျား ကို အကျပ် နှစ် ဆယ်၊ မိန်းမ ကို အကျပ် တဆယ် နှင့် အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","အသက်တလ မှ သည် ငါး နှစ် တိုင်အောင် ၊ ယောက်ျား ကို ငွေ ငါး ကျပ် ၊ မိန်းမ ကို သုံး ကျပ် နှင့် အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","အသက် ခြောက် ဆယ်လွန် လျှင် ၊ ယောက်ျား ကို ဆယ် ငါး ကျပ် ၊ မိန်းမ ကို တဆယ် နှင့် အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","သင် အဘိုး ပြတ်သည်အတိုင်း၊ မ တတ်နိုင်လျှင် ၊ ယဇ်ပုရောဟိတ် ထံ သို့ချဉ်းကပ် ၍ ၊ ယဇ် ပုရောဟိတ်သည် သစ္စာ ဂတိပြုသောသူ တတ်နိုင် သမျှအတိုင်း အဘိုး ပြတ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","လူသည် တိရစ္ဆာန် ကို ထာဝရဘုရား အား ပူဇော် လျှင်၊ ပူဇော် သမျှ သည် သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ကောင်း သည်ဖြစ်စေ ၊ ညံ့ သည်ဖြစ်စေ၊ တကောင်အတွက် တကောင်ကို မ လဲ ရ။ လဲ လိုလျှင် ၊ နှစ်ကောင် စလုံး သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ထာဝရဘုရား အား မ ပူဇော် အပ်၊ မ စင်ကြယ်သော တိရစ္ဆာန် ဖြစ်လျှင် ၊ ယဇ်ပုရောဟိတ် အား ပြ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ကောင်း မ ကောင်းရှိသည်အလျောက် ၊ ယဇ်ပုရောဟိတ် အဘိုး ပြတ်ရမည်။ ယဇ်ပုရောဟိတ် ပြတ်သည်အတိုင်း အဘိုးရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ပူဇော်သောသူသည် ရွေး လိုလျှင် ၊ အဘိုး ရင်းနှင့် ငါး စုတစုကို ထပ် ၍ ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","လူ သည် မိမိ အိမ် ကို ထာဝရဘုရား အဘို့ သန့်ရှင်း စေလျှင် ၊ ကောင်း မ ကောင်းရှိသည်အလျောက် ၊ ယဇ်ပုရောဟိတ် အဘိုး ပြတ်ရမည်။ ယဇ်ပုရောဟိတ် ပြတ်သည်အတိုင်း အဘိုး ရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ထိုအိမ် ကို သန့်ရှင်း စေသောသူ ရွေး လိုလျှင် ၊ ပြတ်သောအဘိုး ရင်းနှင့် ငါး စုတစုကို ပေး ၍ အိမ်ကို ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","လူ သည် ကိုယ် ပိုင် သော လယ်ယာ ကို ထာဝရဘုရား အဘို့ သန့်ရှင်း စေလျှင် ၊ မုယောမျိုးစေ့ ကြဲရသည် အတိုင်း အဘိုး ပြတ်ရမည်။ မျိုးစေ့ တဩမဲကြဲရသော လယ်ကို၊ ငွေ အကျပ် ငါး ဆယ်နှင့် အဘိုးပြတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ယုဘိလ နှစ် မှစ၍မိမိ လယ် ကို သန့်ရှင်း စေလျှင် ၊ ပြတ်သည်အတိုင်း အဘိုး ရှိ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ယုဘိလ နှစ်လွန် မှ မိမိ လယ် ကို သန့်ရှင်း စေလျှင် ၊ နောင် ယုဘိလ နှစ် မှီ အောင် လိုသေးသော နှစ် ပေါင်းကို၊ ယဇ်ပုရောဟိတ် ရေတွက် ၍ ပြတ်သော အဘိုး ရင်းငွေကို လျှော့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","မိမိ လယ် ကို သန့်ရှင်း စေသောသူသည် ရွေး လိုလျှင် ၊ ပြတ်သော အဘိုး ရင်းနှင့် ငါး စုတစုကို ပေး ၍ လယ်ကို အပိုင်ယူရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","သို့မဟုတ် လယ် ကိုမ ရွေး လို၊ အခြား သောသူအား ရောင်း မိလျှင် ၊ နောက် တဖန် မ ရွေး ရ။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ယုဘိလ နှစ်တွင် ထိုလယ် သည် အမှုလွတ် သောအခါ ၊ ကျိန်ဆို သောလယ် ကဲ့သို့ ၊ ထာဝရဘုရား အား သန့်ရှင်း ၍ ယဇ်ပုရောဟိတ် ၏ ဥစ္စာ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","လူသည် ကိုယ်ပိုင် ရင်းမ ဟုတ်၊ ဝယ် သော လယ်ယာ ကို ထာဝရဘုရား အဘို့ သန့်ရှင်း စေလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ယုဘိလ နှစ် တိုင်အောင် ပြတ်သောအဘိုး ကို၊ ယဇ်ပုရောဟိတ် ရေတွက် ၍ ၊ ထာဝရဘုရား အဘို့ သန့်ရှင်း စေသော နေ့ ၌ အဘိုးပြတ်သောငွေ ကို ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ယုဘိလ နှစ် ရောက်သောအခါ ၊ ထိုလယ် ကို အရင်ပိုင် ၍ ရောင်းသောသူ လက်သို့ ပြန် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","အဘိုး ပြတ်လေရာရာ ၌ အကျပ် တော်အလိုက် ပြတ်ရမည်။ အကျပ် ကား၊ ဂေရ နှစ် ဆယ်ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","ထာဝရဘုရား ပိုင်ထိုက်သော တိရစ္ဆာန် သားဦး ကို၊ အဘယ် သူမျှမ သန့်ရှင်း စေရ။ နွား ဖြစ်စေ ၊ သိုး ဆိတ် ဖြစ်စေ ၊ ထာဝရဘုရား ဥစ္စာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","မ စင်ကြယ်သော တိရစ္ဆာန် ဖြစ်လျှင် ၊ အဘိုးပြတ်သည်အတိုင်း ရွေး ၍ ၊ ငါး စုတစုကို ထပ် ၍ ပေးရမည်။ မ ရွေး လိုလျှင် ၊ အဘိုး ပြတ်သည်အတိုင်း ရောင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","သို့ရာတွင် လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ၊ ကိုယ်ပိုင် ရင်းလယ် ဖြစ်စေ ၊ ထာဝရဘုရား အား ကျိန်ဆို ၍ ပူဇော် သမျှ ကို မ ရောင်း မ ရွေး ရ။ ကျိန်ဆို ၍ ပူဇော်သမျှ တို့သည် ထာဝရဘုရား အား အလွန်သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","လူ ကိုပင် ကျိန်ဆို ၍ ပူဇော် လျှင်၊ နောက်တဖန် မ ရွေး ရ၊ သတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","စပါး ဖြစ်စေ၊ သစ်သီး ဖြစ်စေ၊ မြေ ကဖြစ်သမျှ သောအသီးအနှံဆယ် စုတစုသည် ထာဝရဘုရား ၏ ဘဏ္ဍာတော် ဖြစ်၏။ ထာဝရဘုရား အဘို့ သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ဆယ် စုတစုကို ရွေး လိုလျှင် ၊ အဘိုးရင်းနှင့်ငါး စုတစုကို ထပ် ၍ပေးရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","နွား ဖြစ်စေ ၊ သိုး ဆိတ်ဖြစ်စေ၊ ကြိမ်လုံး အောက် ၌ သွား သမျှ သော အကောင်ဆယ် စုတစုသည်၊ ထာဝရဘုရား အဘို့ သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ကောင်း သလော၊ ညံ့ သလောဟုမ မေးမစစ် ရ။ တကောင်အတွက် တကောင်ကို မ လဲ ရ။ လဲ လိုလျှင် နှစ်ကောင်စလုံး သန့်ရှင်း ရမည်။ အလျှင်းမ ရွေး ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ဤ ရွေ့ကား ထာဝရဘုရား သည်၊ သိနာ တောင် ပေါ် မှာ ဣသရေလ အမျိုးသား တို့အဘို့ မောရှေ ၌ ထား တော်မူသော ပညတ် တော်များ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ဣသရေလအမျိုးသားတို့သည်၊ အဲဂုတ္တု ပြည် မှ ထွက် ၍ ဒုတိယ နှစ် ၊ ဒုတိယ လ ၊ ပဌမ နေ့၌ သိနာ တော တွင် ပရိသတ်စည်းဝေး ရာ တဲ တော်မှာ ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","သင် နှင့် အာရုန် သည် ဣသရေလ အမျိုးသား ပရိသတ် တို့တွင်၊ အသက် နှစ်ဆယ် လွန် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","စစ်တိုက် နိုင်သောယောက်ျား အပေါင်း တို့ကို သူ တို့အဆွေအမျိုး အသီးသီးအလိုက် စာရင်း ယူ လျက်၊ တပ်ခင်းကျင်း ၍ရေတွက် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","အမျိုးအနွယ် အသီးသီးတမျိုးတယောက်စီ မိမိတို့ အဆွေအမျိုး၌ သူကြီး ဖြစ်သော လူတို့သည် သင် တို့နှင့်အတူ ကူညီ၍ ထိုအမှုကိုဆောင်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","သင်တို့နှင့်အတူကူညီ၍ အမှုကိုဆောင်ရသောသူဟူမူကား၊ ရုဗင် အမျိုး၊ ရှေဒုရ သား ဧလိဇုရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ရှိမောင် အမျိုး၊ ဇုရိရှဒ္ဒဲ သား ရှေလုမျေလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ယုဒ အမျိုး၊ အမိနဒပ် သား နာရှုန်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ဣသခါ အမျိုး၊ ဇုအာ သား နာသနေလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ဇာဗုလုန် အမျိုး၊ ဟေလုန် သား ဧလျာဘ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ယောသပ် သား တွင်၊ ဧဖရိမ် အမျိုး၊ အမိဟုဒ် သား ဧလိရှမာ ၊ မနာရှေ အမျိုး၊ ပေဒါဇုရ သား ဂါမလျလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ဗင်္ယာမိန် အမျိုး၊ ဂိဒေါနိ သား အဘိဒန်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ဒန် အမျိုး၊ အမိရှဒဲ သား အဟေဇာ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","အာရှာ အမျိုး၊ ဩကရန် သား ပါဂျေလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ဂဒ် အမျိုး၊ ဒွေလ သား ဧလျာသပ်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","နဿလိ အမျိုး၊ ဧနန် သား အဟိရ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ဤသူ တို့သည် ပရိသတ် တွင် ကျော်စော သောသူ၊ အဆွေအမျိုး သူကြီး မင်းဖြစ်၍၊ဣသရေလ အမျိုး ၌ လူတထောင်စီအုပ်ရသောသူဖြစ် ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ထိုသို့နာမည် ဖြင့် ရွေး တော်မူသော ထို သူ တို့ကို၊ မောရှေ နှင့် အာရုန် သည်ခေါ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ဒုတိယ လ ၊ ပဌမ နေ့၌ ပရိသတ် အပေါင်း ကို စည်းဝေး စေပြီးမှ ၊ အဆွေအမျိုး စာရင်းကို ဘော်ပြ ၍၊ အနှစ် နှစ်ဆယ် အလွန် သောသူတို့၏ နာမည် ပေါင်း ကို မှတ်သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ထာဝရဘုရား သည် မောရှေ အား မှာ ထားတော်မူ သည်အတိုင်း ၊ သိနာ တော ၌ ဣသရေလအမျိုးသားတို့ ကို ရေတွက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ဣသရေလ ၏သားဦး ၊ ရုဗင် ၏အမျိုးသား တို့တွင်၊ အဆွေအမျိုး အသီးအသီးလိုက်၍ နာမည် များကို စာရင်း ၌ မှတ်သားသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက်နိုင်သော ယောက်ျားပေါင်း လေးသောင်း ခြောက်ထောင်ငါး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ရှိမောင် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီး လိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျား ပေါင်း ငါးသောင်း ကိုးထောင်သုံး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ဂဒ် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီးလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း လေးသောင်း ငါးထောင်ခြောက် ရာ ငါးဆယ် ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ယုဒ အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီးလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သောယောက်ျားပေါင်း ခုနစ်သောင်း ၊ လေးထောင်ခြောက် ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ဣသခါ အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီး ကိုလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း ငါးသောင်း လေးထောင်လေး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ဇာဗုလုန် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီး လိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း ငါးသောင်း နှစ်ထောင်လေး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ယောသပ် မှ ဆင်းသက်သော ဧဖရိမ် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီးလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း လေးသောင်း ငါး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","မနာရှေ အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီး လိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း သုံးသောင်း နှစ်ထောင်နှစ်ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ဗင်္ယာမိန် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးသီး လိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း သုံးသောင်း ငါးထောင်လေး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ဒန် အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီးလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း ခြောက်သောင်း နှစ်ထောင်ခုနစ် ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","အာရှာ အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီးလိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း လေးသောင်း တထောင်ငါး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","နဿလိ အမျိုးသား တို့တွင် အဆွေအမျိုး အသီးအသီး လိုက် ၍ နာမည် များကို စာရင်း ၌ မှတ်သား သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ယောက်ျားပေါင်း ငါးသောင်း သုံးထောင်လေး ရာ ရှိကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ထိုသို့ မောရှေ နှင့် အာရုန် အစရှိသော ဣသရေလ အမျိုး၌ အဆွေအမျိုး သူကြီးဖြစ်သော မင်း ဆယ် နှစ် ပါးတို့သည် ");
INSERT INTO myajvb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ဣသရေလ အမျိုးသား အပေါင်း တို့ကို အဆွေအမျိုး အလိုက် ရေတွက် ၍ စာရင်းယူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော လူပေါင်း ကား ခြောက် သိန်းသုံး ထောင်ငါး ရာ ငါး ဆယ်ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","လေဝိ သားတို့သည်၊ ဘိုးဘ အမျိုး အလိုက် စာရင်း မ ဝင်ရသည် အမှုမှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","လေဝိ သား တို့ကို၊ ဣသရေလ အမျိုးသား တို့နှင့် ရောနှော၍ မ ရေတွက် ရ။ စာရင်း ထဲ၌မ သွင်း ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","လေဝိ သားတို့အား သက်သေခံ ချက် တဲ တော်ကို၎င်း၊ တဲတော်တန်ဆာ ရှိသမျှ ကို ၎င်း၊ တဲ တော်နှင့်ဆိုင်သမျှ တို့ကို၎င်းအပ် ၍၊ သူတို့သည် တဲ တော်နှင့် တဲ တော်တန်ဆာ အလုံးစုံ ကို ဆောင်ရွက် ရကြမည်။ တဲ တော်မှုကိုလည်း ထမ်း ရကြမည်။ တပ်ချသောအခါ၊ တဲ တော်ပတ်လည် ၌ မိမိတို့နေရာ ချရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","တဲ တော်ကို ယူသွား ချိန် ရောက်သောအခါ ၊ လေဝိ သားတို့သည် ရုပ်သိမ်း ရမည်။ နေရာ ချချိန်ရောက်သောအခါ ၊ ထူထောင် ပြန်ရမည်။ လေဝိ အမျိုးသားမှတပါး အခြား သော အမျိုးသားသည် ချဉ်းကပ် လျှင်၊ အသေ သတ်ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ဣသရေလ အမျိုးသား တို့သည် တပ်ချ သောအခါ ၊ အလုံးအရင်း တရှောက်လုံး၊ လူတိုင်း မိမိ ဆိုင်သော တပ် တွင် မိမိ ဆိုင်သော အလံ နားမှာ မိမိတဲကို ဆောက်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ဣသရေလ အမျိုးသား စည်းဝေးရာ၊ ပရိသတ် အပေါ် မှာ အမျက် တော်မ သက်ရောက် စေခြင်းငှါ ၊ လေဝိ သားတို့သည် သက်သေခံ ချက် တဲ တော်ပတ်လည် ၌ နေရာ ချ၍ ၊ သက်သေခံ ချက်တဲ တော်ကို စောင့်ရှောက် ရမည် ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","မောရှေ အား ထာဝရဘုရား မှာ ထားတော်မူသည် အတိုင်း ဣသရေလ အမျိုးသား တို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ဣသရေလ အမျိုးသား အသီးအသီးတို့သည်၊ မိမိ တပ်နှင့်ဆိုင်သောအလံ၊ မိမိ အဆွေအမျိုး နှင့် ဆိုင်သော အလံ အနား မှာ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ကို ရှေ့ရှုပြု၍ နေရာ ချရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","နေ ထွက်ရာ အရှေ့ မျက်နှာ၌ ၊ ယုဒ တပ် အလံ နှင့် ဆိုင်သော အလုံးအရင်း သည် နေရာ ကျ၍ ၊ အမိနဒပ် သား နာရှုန် သည်၊ ယုဒ အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ခုနစ်သောင်း လေးထောင်ခြောက် ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ယုဒတပ်အနား မှာ၊ ဣသခါ တပ်ချ ၍ ၊ ဇုအာ သား နာသနေလ သည်၊ ဣသခါ အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ငါးသောင်း လေးထောင်လေး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ထိုနောက်၊ ဇာဗုလုန် တပ်ချ၍၊ ဟေလုန် သား ဧလျာဘ သည်၊ ဇာဗုလုန် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ငါးသောင်း ခုနစ်ထောင်လေး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ယုဒ တပ် နှင့်ဆိုင်သော အလုံးအရင်း အရေအတွက် ကား၊ တသိန်း ရှစ်သောင်း ခြောက် ထောင် လေး ရာ ရှိသတည်း။ ဤသူတို့သည်၊ တပ် ဦး အရာ၌ ချီ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","တောင် မျက်နှာ၌ ၊ ရုဗင် တပ် အလုံးအရင်း သည်၊ ရုဗင်အလံ ကိုထူ၍၊ ရှေဒုရ သား ဧလိဇုရ သည်၊ ရုဗင် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ လေးသောင်း ခြောက်ထောင်ငါး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ရုဗင်တပ်အနား မှာ ရှိမောင် တပ်ချ ၍ ၊ ဇုရိရှဒ္ဒဲ သား ရှေလုမျေလ သည်၊ ရှိမောင် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ငါးသောင်း ကိုးထောင်သုံး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ထိုနောက် ဂဒ် တပ်ချ၍၊ ဒွေလ သား ဧလျာသပ် သည်၊ ဂဒ် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ လေးသောင်း ငါးထောင်ခြောက် ရာ ငါးဆယ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ရုဗင် တပ် နှင့်ဆိုင်သော အလုံးအရင်း အရေအတွက် ကား၊ တသိန်း ငါးသောင်း တထောင်လေး ရာ ငါးဆယ် ရှိသတည်း။ ဤသူတို့သည် ဒုတိယ တပ် အရာ၌ ချီ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ထိုအခါ ၊ တပ်မ အလယ် ၌ ပရိသတ်စည်းဝေး ရာ တဲ တော်နှင့်တကွ၊ လေဝိ တပ် ချီ ရမည်။ တပ်ချ သည် အတိုင်း ၊ လူအသီးသီး တို့သည်၊ မိမိ နေရာ ၌ မိမိ ဆိုင်သော အလံ နှင့်အတူလိုက်လျက်ချီ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","အနောက် မျက်နှာ၌ ဧဖရိမ်တပ် အလုံးအရင်း သည်၊ ဧဖရိမ် အလံ ကိုထူ၍၊ အမိဟုဒ် သား ဧလိရှမာ သည်၊ ဧဖရိမ် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ လေးသောင်း ငါး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ဧဖရိမ်တပ်အနား မှာ မနာရှေ တပ်ချ၍၊ ပေဒါဇုရ သား ဂါမလေလျလ သည်၊ မနာရှေ အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ သုံးသောင်း နှစ်ထောင်နှစ်ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ထိုနောက် ဗင်္ယာမိန် တပ်ချ၍၊ ဂိဒေါနိ သား အဘိဒန် သည်၊ ဗင်္ယာမိန် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ သုံးသောင်း ငါးထောင်လေး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ဧဖရိမ် တပ် နှင့်ဆိုင်သော အလုံးအရင်း အရေအတွက် ကား၊ တသိန်း ရှစ်ထောင် တရာ ရှိသတည်း။ ဤသူတို့သည် တတိယ တပ် အရာ၌ ချီ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","တပ်များ မြောက် မျက်နှာ၌ ၊ ဒန်တပ်အလုံးအရင်း သည်၊ ဒန် အလံ ကိုထူ၍၊ အမိရှဒ္ဒဲ သား အဟေဇာ သည်၊ ဒန် အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ခြောက်သောင်း နှစ်ထောင်ခုနှစ် ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ဒန်တပ်အနား မှာ၊ အာရှာ တပ်ချ၍၊ ဩကရန် သား ပါဂျေလ သည်၊ အာရှာ အမျိုးသား တို့တွင် ဗိုလ် လုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ လေးသောင်း တထောင်ငါး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ထိုနောက် ၊ နဿလိ တပ်ချ၍၊ ဧနန် သား အဟိရ သည်၊ နဿလိ အမျိုးသား တို့တွင် ဗိုလ် လုပ်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","သူ အုပ်ရသောအလုံးအရင်း အရေအတွက် ကား၊ ငါးသောင်း သုံးထောင်လေး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ဒန် တပ် နှင့်ဆိုင်သော အလုံးအရင်း အရေအတွက် ကား၊ တသိန်း ငါးသောင်း ခုနစ်ထောင်ခြောက် ရာ ရှိသတည်း။ ဤသူတို့သည်၊ မိမိ တို့အလံ ပါလျက် နောက်ဆုံး တပ်အရာ၌ ချီ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ထိုသို့နှင့်အညီ၊ အဆွေအမျိုး အလိုက် ရေတွက် သော ဣသရေလ အမျိုးသား တပ် အလုံးအရင်း လူပေါင်း ကား၊ ခြောက် သိန်းသုံးထောင် ငါးရာ ငါးဆယ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ထာဝရဘုရား သည်၊ မောရှ အား မှာ ထားတော်မူသည်အတိုင်း ၊ လေဝိ သားတို့ကို၊ ဣသရေလ အမျိုးသား တို့ နှင့် ရောနှော၍ မ ရေတွက် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ထာဝရဘုရား သည်၊ မောရှေ အား မှာ ထား တော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား အသီးသီး တို့သည်၊ မိမိ အလံ အနားမှာ မိမိနေရာချ ခြင်းကို၎င်း၊ မိမိ ဘိုး ဘ အမျိုး အလိုက် ချီ ခြင်းကို၎င်းပြု ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ထာဝရဘုရား သည်၊ သိနာ တောင် ပေါ် မှာ မောရှ အား ဗျာဒိတ် ပေးတော်မူသောအခါ၊ အာရုန် နှင့် မောရှေ အမျိုးအနွယ်၏ အတ္ထုပ္ပတ္တိ များကို မှတ်သားသည်တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","အာရုန် ၏သား ဟူမူကား၊ သားဦး နာဒပ် ၊ ညီအဘိဟု ၊ ဧလာဇာ ၊ ဣသမာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ဤ သူတို့ကား၊ အဘသည် ယဇ်ပုရောဟိတ် အမှုကို ဆောင်စေခြင်းငှါ ဆီလောင်းခြင်းဘိသိက်ကိုပေး ၍ အရာ၌ခန့်ထားသော အာရုန် ၏ သား ဖြစ်ကြသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","နာဒပ် နှင့် အဘိဟု သည်၊ သိနာ တော တွင် ထာဝရဘုရား ရှေ့ တော်၌၊ ထူးခြား သောမီး ကို ပူဇော် သောအခါ ၊ ထာဝရဘုရား ရှေ့ တော်၌ သေ ကြ၏။ သူတို့၌ သား မ ရှိ သည်ဖြစ်၍၊ ဧလာဇာ နှင့် ဣသမာ သည်၊ အဘ အာရုန် ရှေ့ မှာ ယဇ်ပုရောဟိတ် အမှုကို ဆောင်ရွက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","သင်သည် လေဝိ အမျိုးသား တို့ကို ခေါ် ခဲ့၍ ယဇ်ပုရောဟိတ် အာရုန် အမှု ကို ဆောင်စေခြင်းငှါ၊ အာရုန်ထံ၌နေရာ ချလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","သူတို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ မှာ၊ အာရုန်နှင့် ပရိသတ် အပေါင်း တို့ ဆောင် ရသောအမှု တည်းဟူသောတဲ တော်အမှု ကို ဆောင်ရွက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","သူတို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော် တန်ဆာ ရှိသမျှ တို့ကို ကြည့်ရှု ပြုစု၍ ၊ ဣသရေလ အမျိုးသား ဆောင်ရသောတဲ တော်အမှု ကို ဆောင် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","လေဝိ သားတို့ကို၊ အာရုန် နှင့် သူ ၏သား တို့၌ အပ် ရမည်။ ဣသရေလ အမျိုး ထဲက သူ တို့ကိုရွေး၍ ငါ့အား အပိုင်ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","အာရုန် နှင့် သူ ၏သား တို့ကိုလည်း ခန့်ထား ၍၊ သူတို့သည် ယဇ်ပုရောဟိတ် အမှုကို စောင့် ရကြမည်။ သူ၏အမျိုးမှတပါး၊ အခြား သောသူသည် ချဉ်းကပ် လျှင်၊ အသေ သတ်ခြင်းကိုခံရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","ဣသရေလ အမျိုး တွင် အဦး ဘွားမြင်သော သားဦး များအတွက်၊ လေဝိ သားတို့ကို ငါ ရွေး ယူသောကြောင့်၊ လေဝိ သားတို့သည် အထူးသဖြင့်ငါ ၏လူဖြစ် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","အကြောင်းမူကား ၊ အဲဂုတ္တု ပြည် ၌ သားဦး အပေါင်း တို့ကို ငါ သည် ဒဏ်ခတ် သောအခါ ၊ ဣသရေလ အမျိုးတွင် လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ၊ သားဦး အပေါင်း တို့ကို ငါ့ အဖို့ ငါသန့်ရှင်း စေသောကြောင့်၊ သားဦး အပေါင်း တို့ကို အထူးသဖြင့်ငါ ပိုင် ရ၏။ ငါ သည် ထာဝရဘုရား ဖြစ်သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","တဖန် ထာဝရဘုရား သည်၊ သိနာ တော ၌ မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","လေဝိ သား တို့တွင် အသက်တလ ကျော် ရှိသောယောက်ျား အပေါင်း တို့ကို အဆွေအမျိုး အလိုက် ရေတွက် လော့ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ သည် လေဝိ သားတို့ကို ရေတွက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","လေဝိ သား တို့၏ နာမည် ဟူမူကား ၊ ဂေရရှုန် ၊ ကောဟတ် ၊ မေရာရိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","မိမိ အဆွေအမျိုး အလိုက် ဂေရရှုန် သား တို့၏ အမည် ကား၊ လိဗနိ နှင့် ရှိမိ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","မိမိ အဆွေအမျိုး အလိုက် ကောဟတ် သား တို့၏ နာမည်ကား၊ အာမရံ ၊ ဣဇဟာ ၊ ဟေဗြုန် ၊ ဩဇေလ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","မိမိ အဆွေအမျိုး အလိုက် မေရာရိ သား တို့၏ နာမည်ကား၊ မဟာလိ နှင့် မုရှိ တည်း။ ဤ သူ တို့သည်၊ မိမိ ဘိုးဘ အမျိုး အလိုက် ရေတွက်သော လေဝိ အမျိုးအနွယ် ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ဂေရရှုန် မှဆင်းသက်လာသောလိဗနိ အဆွေအမျိုး ၊ ရှိမိ အဆွေအမျိုး တို့သည်၊ ဂေရရှုန် အမျိုးအနွယ် ဖြစ်ကြ၏၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ထိုအဆွေအမျိုးတို့ကို ရေတွက် ၍ အသက် တလ ကျော် ရှိသောယောက်ျား ပေါင်း ကား၊ ခုနစ် ထောင် ငါး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ဂေရရှုန် အဆွေအမျိုး တို့သည်၊ တဲ တော်အနောက် မျက်နှာ၌ နေရာ ချရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ဂေရရှုန် အဆွေအမျိုး သူကြီး ကား၊ လေလ သား ဧလျာသပ် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ဂေရရှုန် သား တို့ အငန်းအတာ ဟူမူကား၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်၊ အပေါ်တဲ ၊ အပေါ်တဲ အဖုံး ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်တံခါးဝ ၌ ကာသော ကုလားကာ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","တဲ တော်နှင့် ယဇ်ပလ္လင် ပတ်လည် ဝင်း ကုလားကာ ၊ ဝင်း တံခါးဝ ၌ ကာသောကုလားကာ ၊ ကြိုး များ အစရှိသည်တို့ကို ကြည့်ရှုပြုစုရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ကောဟတ် မှဆင်းသက်သော အာမရံ အဆွေအမျိုး ၊ ဣဇဟာ အဆွေအမျိုး ၊ ဟေဗြုန် အဆွေအမျိုး ၊ ဩဇေလ အဆွေအမျိုး တို့သည်၊ ကောဟတ် အမျိုးအနွယ် ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","တဲ တော်ကို စောင့် သောသူ၊ ထိုအဆွေအမျိုးတို့ကို ရေတွက်၍ အသက်တလ ကျော် ရှိသောယောက်ျား ပေါင်း ကား၊ ရှစ် သောင်း ခြောက် ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ကောဟတ် အဆွေအမျိုး တို့သည်၊ တဲ တော် တောင် မျက်နှာ၌ နေရာ ချရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ကောဟတ် အဆွေအမျိုး သူကြီး ကား၊ ဩဇေလ သား ဧလိဇာဖန် တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","သူ တို့အငန်းအတာ ဟူမူကား၊ သေတ္တာ ၊ စားပွဲ ၊ ယဇ်ပလ္လင် များ၊ အမှု တော်ထမ်းစရာ တဲ တော်တန်ဆာ များ၊ အတွင်းကုလားကာ အစရှိသည်တို့ကို ကြည့်ရှုပြုစုရကြ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ယဇ်ပုရောဟိတ် အာရုန် သား ဧလာဇာ သည်၊ လေဝိ အဆွေအမျိုးသူကြီး တို့ကို အုပ်၍၊ တဲ တော်စောင့် သောသူတို့ ကို ကြည့်ရှု စီရင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","မေရာရိ မှ ဆင်းသက်သော မဟာလိ အဆွေအမျိုး ၊ မုရှိ အဆွေအမျိုး တို့သည်၊ မေရာရိ အမျိုးအနွယ် ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ထိုအဆွေအမျိုးတို့ကို ရေတွက် ၍ အသက်တလ ကျော် ရှိသောယောက်ျား ပေါင်း ကား၊ ခြောက် ထောင် ခုနစ် ရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","မေရာရိ အဆွေအမျိုး သူကြီး ကား၊ အဘိဟဲလ သား ဇုရေလ တည်း။ ဤသူတို့သည် တဲ တော်မြောက် မျက်နှာ၌ နေရာ ချရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","မေရာရိ သား တို့ အငန်းအတာ ဟူမူကား၊ တဲ တော်ပျဉ်ပြား များ၊ ကန့်လန့်ကျင် များ၊ တိုင် များ၊ ခြေစွပ် များ၊ ထိုအရာနှင့်ဆိုင်သော တန်ဆာ များ အစရှိသည်တို့ကို၎င်း၊ ဝင်း တိုင် များ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ခြေစွပ် များ၊ တံသင် များ၊ ကြိုး များတို့ကို၎င်းကြည့်ရှု ပြုစုရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","မောရှေ နှင့် အာရုန် မှစ၍၊အာရုန် ၏ သား တို့ သည်၊ ဣသရေလ အမျိုးသား တို့အဘို့ ၊ သန့်ရှင်း ရာဌာန တော်ကို စောင့် လျက်၊ ပရိသတ်စည်းဝေး ရာတဲ တော် အရှေ့ မျက်နှာ၌ နေရာ ချရမည်။ သူတို့အမျိုးမှတပါး၊ အခြား သောသူသည် ချဉ်းကပ် လျှင် အသေ သတ်ခြင်းကိုခံရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ သည် လေဝိ သားတို့ကို အဆွေအမျိုး အလိုက် ရေတွက် ၍၊ အသက်တလ ကျော် ရှိသောယောက်ျား အပေါင်း ကား၊ နှစ်သောင်း နှစ်ထောင်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ဣသရေလ အမျိုးသား တို့တွင်၊ အသက် တလ ကျော် ရှိသောသားဦး ယောက်ျား အပေါင်း တို့ကို ရေတွက် ၍ စာရင်း ယူလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ဣသရေလ အမျိုး သားဦး အပေါင်း တို့အတွက် လေဝိ သားတို့ကို၎င်း ၊ ဣသရေလ အမျိုးသား တို့၌ တိရစ္ဆာန် သားဦး အပေါင်း တို့အတွက် လေဝိ သား တို့၌ ရှိသောတိရစ္ဆာန် များကို၎င်း၊ ငါ့ အဘို့ ယူ လော့။ ငါ သည် ထာဝရဘုရား ဖြစ်သည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ သည် ဣသရေလ အမျိုး သားဦး အပေါင်း တို့ကို ရေတွက် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","အသက်တလ ကျော် ရှိသောသားဦး ယောက်ျား နာမည် ပေါင်း ကား၊ နှစ်သောင်း နှစ်ထောင်နှစ်ရာ ခုနစ်ဆယ် သုံး ယောက် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","ဣသရေလ အမျိုး သားဦး အပေါင်း တို့အတွက် လေဝိ သားတို့ကို၎င်း ၊ ဣသရေလ အမျိုးသားတို့၌ တိရစ္ဆာန် များအတွက် လေဝိ သားတို့၌ရှိသောတိရစ္ဆာန် များကို၎င်းယူ လော့။ လေဝိ သားတို့သည် ငါ ၏ လူဖြစ် ရကြမည်။ ငါ သည် ထာဝရဘုရား ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","လေဝိ သားတို့ထက် ပို သော ဣသရေလ အမျိုး သားဦး နှစ်ရာ ခုနစ်ဆယ် သုံး ယောက်တို့ကို ရွေး ရမည်အမှု မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","အကျပ် တော်အလိုက် လူတကိုယ်လျှင် ငါး ကျပ် စီ ခံယူ ရမည်။ အကျပ် ကား၊ ဂေရ နှစ်ဆယ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ပို သောသူတို့ပေးရသောအရွေး ငွေကို၊ အာရုန် နှင့် သူ ၏သား တို့အား ပေး ရမည်ဟု မိန့် တော်မူသည် အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","လေဝိ သားတို့နှင့် ဣသရေလ အမျိုး သားဦး တို့ကိုရွေး ၍၊ ပို သေးသော သားဦးတို့၏ အရွေး ငွေ ကို၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","မောရှေ သည် အကျပ် တော်နှင့်ချိန်လျက်၊ အခွက် တဆယ်သုံး ပိဿာခြောက်ဆယ်ငါးကျပ်ကိုယူ ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ထာဝရဘုရား မှာထား တော်မူသောစကား တော်အတိုင်း ၊ ထိုအရွေး ငွေ ကို အာရုန် နှင့် သူ ၏သား တို့အား ပေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","လေဝိ အမျိုး ၊ ကောဟတ် အနွယ်သား တို့တွင်၊ အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မ မှီ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှု ကိုဆောင် ခြင်းငှါ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","အလုံးအရင်း ဝင် သောသူအပေါင်း တို့ကို၊ ဘိုး ဘအဆွေအမျိုး အလိုက် စာရင်းယူ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","အလွန် သန့်ရှင်းသော အရာတို့နှင့်ဆိုင်၍ ပရိသတ်စည်းဝေး ရာတဲ တော်၌ ကောဟတ် သား များ စောင့်ရှောက်ရသောအမှု ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","တပ် ချီ ချိန် ရောက်သောအခါ ၊ အာရုန် နှင့် သူ ၏သား တို့သည် လာ ၍ ၊ အတွင်းကုလားကာ ကို ချ ပြီးလျှင် ၊ သက်သေခံ ချက် သေတ္တာ ကို အုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ကုလားကာ အပေါ် မှာ တဟာရှ သားရေ နှင့် အုပ် ပြန်၍၊ သားရေအပေါ် မှာလည်း ပြာ သောအထည် ကို ခင်း ပြီးမှ ၊ ထမ်းဘိုး တို့ကို လျှို ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ရှေ့ တော်မုန့်စားပွဲ ပေါ်မှာ ပြာ သောအထည် ကို ခင်း ၍ ၊ လင်ပန်း ၊ ဇွန်း ၊ လောင်း စရာဖလား များနှင့်တကွ ၊ အမြဲ ထည့် ရသောမုန့် ကို တင် ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ထိုအရာတို့ကို၊ နီ သောအထည် နှင့် အုပ် ရမည်။ တဖန် တဟာရှ သားရေ နှင့် အုပ် ပြန်၍ ၊ ထမ်းဘိုး တို့ကို လျှို ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","မီး ထွန်းရာ မီးခုံ ၊ မီးခွက် ၊ မီးညှပ် ၊ မီးညှပ်ခံရာ ခွက် ၊ ဆီ အိုး အစရှိသည်တို့ကို၊ ပြာ သောအထည် နှင့် အုပ် ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ထိုတန်ဆာ ရှိသမျှ တို့ကို၊ တဟာရှ သားရေ အိတ် ထဲ၌ သွင်း ထား၍ ၊ ထမ်းဘိုး ကို တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ရွှေ ယဇ်ပလ္လင် ပေါ်မှာ ၊ ပြာ သောအထည် ကို ခင်း ၍ ၊ တဟာရှ သားရေ နှင့် အုပ် ပြီးလျှင် ၊ ထမ်းဘိုး တို့ကို လျှိုထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","သန့်ရှင်း ရာဌာန၌ အမှု တော်ကို ဆောင်ရွက်ရန် တန်ဆာ ရှိသမျှ တို့ကို၊ ပြာ သောအထည် အိတ်ထဲ၌ သွင်း ထား၍ ၊ တဟာရှ သားရေ ဖြင့် အုပ် ပြီးမှ၊ထမ်းဘိုး ကို တပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ယဇ်ပလ္လင် မှ ပြာ ကိုပယ်ရှင်း၍ ၊ ပလ္လင် ပေါ်မှာ မောင်း သောအထည် ကို ခင်း ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ထိုပလ္လင်နှင့်ဆိုင်သော အမှု တော်ထမ်းရန် တန်ဆာ တည်းဟူသောလင်ပန်း ၊ အမဲသား ချိတ်၊ တူးရွင်းပြား ၊ အင်တုံ အစရှိသော ယဇ်ပလ္လင် တန်ဆာ ရှိသမျှ တို့ကို တင် ၍ ၊ တဟာရှ သားရေ နှင့် အုပ် ပြီးမှ၊ထမ်းဘိုး တို့ကို လျှို ထားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ထိုသို့ တပ် ချီ ချိန်ရောက်သောအခါ ၊ အာရုန် နှင့် သူ ၏သား တို့သည်၊ သန့်ရှင်း ရာဌာနတော်နှင့် သန့်ရှင်း သော တန်ဆာ ရှိသမျှ တို့ကို ဖုံးအုပ် သောနောက် ၊ ကောဟတ် သား တို့သည် ထမ်း ခြင်းငှါ ချဉ်းကပ် ရကြမည်။ သို့ရာတွင် သူတို့သည် သေ ဘေးနှင့် လွတ်မည်အကြောင်း၊သန့်ရှင်း သောအရာကို မ ကိုင် ရ၊ ဤရွေ့ကား ပရိသတ် စည်းဝေး ရာ တဲ တော်၌ ကောဟတ် သား များ ဆောင်ရွက် ရသောအမှုပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ယဇ်ပုရောဟိတ် အာရုန် သား ဧလာဇာ ၏ အရာနှင့်ဆိုင်သော အမှုဟူမူကား၊ မီး ထွန်းစရာ ဆီ၊ မီးရှို့ရာ နံ့သာပေါင်း မွှေး၊ နေ့ရက် အစဉ်အတိုင်းဆက်ကပ်ရသောဘောဇဉ်ပူဇော်သက္ကာ ၊ လိမ်း ရန်ဆီ အစရှိသော တဲ တော် နှင့် တဲ တော်တန်ဆာရှိသမျှ တို့ကို၎င်း၊ သန့်ရှင်း ရာဌာနတော်နှင့် သန့်ရှင်းသောတန်ဆာ ရှိသမျှတို့ကို၎င်း ကြည့်ရှု ပြုစုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","ကောဟတ် အဆွေအမျိုး အနွယ်သား တို့ကို၊ လေဝိ သားစုထဲက မ ပယ် မဖြတ်နှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","သူတို့သည် အလွန် သန့်ရှင်းသောအရာတို့ကို ချဉ်းကပ် သောအခါ ၊ သေ ဘေးလွတ် ၍ အသက်ရှင် မည်ကြောင်း ၊ အာရုန် နှင့် သူ ၏သား တို့သည် အရင်ဝင် ၍ ၊ လူ အသီးသီး စောင့်ရသောအမှု ၊ ထမ်း ရသောဝန်တို့ကို ခွဲခန့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","သို့ရာတွင် သန့်ရှင်း သောအရာတို့ကို ဖုံးအုပ် စဉ်အခါ၊ ကောဟိတ် သားတို့သည် သေ ဘေးနှင့် လွတ်မည်အကြောင်း၊ အထဲ သို့ဝင် ၍ မ ကြည့် ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ဂေရရှုန် အနွယ်သား တို့တွင်၊ အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မ မှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကိုဆောင် ခြင်းငှါ အလုံးအရင်းဝင် သောသူအပေါင်း တို့ကို၊ ဘိုးဘေး အဆွေအမျိုး အလိုက် စာရင်း ယူ လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ဂေရရှုန် အဆွေအမျိုး တို့သည် စောင့်ရသောအမှု ၊ ထမ်း ရသောဝန်ဟူမူကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","အတွင်းတဲ တော် ကုလားကာ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်ကုလားကာ၊ အပေါ်တဲ ၊ တဟာရှ သားရေအဖုံး ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါးဝ ၌ ကာသောကုလားကာ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","တဲ တော်နှင့် ယဇ်ပလ္လင် ပတ်လည် ဝင်း ကုလားကာ ၊ ဝင်း တံခါးဝ ၌ကာသော ကုလားကာ ၊ ကြိုး များအစရှိ သည်တို့ကို၎င်း၊ ထိုအရာများနှင့် ဆိုင်၍ အမှု တော်ထမ်း ရန် တန်ဆာ ရှိသမျှ တို့ကို၎င်းထမ်းရွက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ဂေရရှုန် သား များ အမှု စောင့်လေရာရာ ၊ ဝန်ထမ်း လေရာရာ ၌၊ အာရုန် နှင့် သူ ၏သား တို့ ခွဲခန့် စီရင် သည်အတိုင်း ဆောင်ရွက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ဤရွေ့ကား ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်၌ ၊ ဂေရရှုန် အဆွေအမျိုး သား များ ဆောင်ရွက်ရသောအမှု ပေတည်း။ ယဇ်ပုရောဟိတ် အာရုန် ၏ သား ဣသမာ သည် သူ တို့ကိုအုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","မေရာရိ သား တို့တွင်လည်း၊ အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မ မှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကို ဆောင် ခြင်းငှါ ၊ အလုံးအရင်းဝင် သောသူအပေါင်း တို့ကို ဘိုးဘ အဆွေအမျိုး အလိုက် စာရင်း ယူလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","သူတို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်၌ စောင့်ရသောအမှု ၊ ထမ်း ရသောဝန် ဟူမူကား ၊ တဲ တော် ပျဉ်ပြား ၊ ကန့်လန့်ကျင် ၊ တိုင် ၊ ခြေစွပ် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ဝင်း တိုင် ၊ ခြေစွပ် ၊ တံသင် ၊ ကြိုး များတို့ကို၎င်းထိုအရာများနှင့်ဆိုင်၍ အမှု တော်ထမ်းရန် တန်ဆာ ရှိသမျှ တို့ကို၎င်းထမ်းရွက်ကြရမည်။ သူ တို့ထမ်းရွက် ရသော တန်ဆာ တို့ကို အမည် မှတ်၍ ရေတွက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ဤရွေ့ကား ၊ ယဇ်ပုရောဟိတ် အာရုန် ၏ သား ဣသမာ အုပ်၍၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်၌ မေရာရိ အဆွေအမျိုး သား များ ဆောင်ရွက်ရသောအမှု ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","မောရှေ နှင့် အာရုန် အစရှိသော ပရိသတ် သူကြီး တို့သည်၊ ကောဟတ် သား တို့တွင် အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မမှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကို ဆောင် ခြင်းငှါ ၊ အလုံးအရင်းဝင် သောသူအပေါင်း တို့ကို၊ ဘိုးဘ အဆွေအမျိုး အလိုက် ရေတွက် ၍ စာရင်းသွင်း သောလူပေါင်းကား၊ နှစ် ထောင်ခုနစ် ရာ ငါးဆယ် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ဤ သူတို့သည်၊ မောရှေ ၌ ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ နှင့် အာရုန် သည် ရေတွက် ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှုကို ဆောင်ရွက် ရသော ကောဟတ် အဆွေအမျိုး သားပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ဂေရရှုန် သား တို့တွင် အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မမှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကို ဆောင် ခြင်းငှါ ၊ အလုံးအရင်းဝင် သောသူအပေါင်း တို့ကို၊ ဘိုးဘ အဆွေအမျိုး အလိုက် ရေတွက် ၍ စာရင်းသွင်း သောလူပေါင်းကား၊ နှစ် ထောင်ခြောက် ရာ သုံးဆယ် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ဤ သူတို့သည်၊ ထာဝရဘုရား မှာထား တော်မူသည် အတိုင်း ၊ မောရှေ နှင့် အာရုန် သည် ရေတွက် ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှုကို ဆောင်ရွက် နေရ သော ဂေရရှုန် အဆွေအမျိုး သား ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","မေရာရိ သား တို့တွင် အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မမှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကို ဆောင် ခြင်းငှါ ၊ အလုံးအရင်းဝင် သောသူအပေါင်း တို့ကို၊ ဘိုးဘ အဆွေအမျိုး အလိုက် ရေတွက် ၍ စာရင်းသွင်း သောလူပေါင်းကား၊ သုံး ထောင် နှစ် ရာရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ဤ သူတို့သည်၊ မောရှေ ၌ ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ နှင့် အာရုန် သည် ရေတွက် သော မေရာရိ အဆွေအမျိုး သား ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ထိုသို့နှင့်အညီ၊ လေဝိ သားတို့တွင်အသက် သုံးဆယ် လွန် ၍ ငါးဆယ် မမှီ၊ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု တော်ကိုစောင့် ၍ ဝန်များကိုထမ်း ခြင်းငှါ ဝင် သောသူအပေါင်း တို့ကို၊ ဘိုးဘေး အဆွေအမျိုး အလိုက် မောရှေ နှင့် အာရုန် အစရှိသောဣသရေလ အမျိုးသူကြီး တို့သည် ရေတွက် ၍စာရင်းသွင်း သောလူပေါင်းကား၊ ရှစ် ထောင် ငါး ရာ ရှစ်ဆယ် ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","မောရှေ ၌ ထာဝရဘုရား ထား တော်မူသောပညတ်တော်အတိုင်း ၊ လူ အသီးသီး စောင့်ရသောအမှု ၊ အသီးအသီး ထမ်း ရသောဝန်တို့ကိုထောက်၍မောရှေရေတွက် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","ငါ နေ သော တပ် ကို မ ညစ်ညူး စေခြင်းငှါ၊ ဣသရေလ အမျိုးသား တို့သည်၊ နူ သောသူ၊ ရိနာစွဲ သောသူ၊ အသေကောင် ထိ၍ မစင်ကြယ် သောသူယောက်ျား မိန်းမ အပေါင်း တို့ကို၊ တပ် ပြင် မှာ နေရာ ချထားရမည်အကြောင်း ဆင့်ဆို လော့ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","မောရှေ အား မိန့် တော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","လူ ပြုတတ်သော ဒုစရိုက် ကိုပြု ၍၊ ထာဝရဘုရား ကို ပြစ်မှား သဖြင့် အပြစ် ရောက်သော ယောက်ျား မိန်းမ သည်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ထို အပြစ် ကို ဘော်ပြ ၍ တောင်းပန်ရမည်။ ပြစ်မှား သောအတွက်၊ ငါးစုတစု ကိုထပ်၍ ပြစ်မှား ခံသောသူ အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ထိုအပြစ်အတွက် ပေးသောဥစ္စာကိုခံထိုက်သော အမျိုးသား ချင်းမ ရှိလျှင် ၊ ယဇ်ပုရောဟိတ် အဘို့ ထာဝရဘုရား အား ပူဇော် ရမည်။ ထိုမှတပါး၊ အပြစ် ဖြေစေခြင်းငှါ၊ အပြစ် ဖြေရာယဇ်ဘို့၊ သိုး တကောင်ကို ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ယဇ်ပုရောဟိတ် အား ဣသရေလ အမျိုးသား ပူဇော်၍ သန့်ရှင်း သောအရာရှိသမျှ တို့သည်၊ ယဇ်ပုရောဟိတ် ၏ဥစ္စာ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","လူ တိုင်းသန့်ရှင်း စေ၍ ယဇ်ပုရောဟိတ် အား လှူ သမျှတို့သည်လည်း၊ ယဇ်ပုရောဟိတ် ၏ ဥစ္စာဖြစ် ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","လင်ရှိသောမိန်းမ သည် အခြားတပါးသော ယောက်ျား နှင့် မှားယွင်း ၍ လင် ကို ပြစ်မှား လျှင် ၎င်း ၊ မှားယွင်း စဉ်တွင်သူတပါးမ တွေ့ မိ၊ သက်သေ မ ရှိ၊ သီလပျက် သော်လည်း ၊ ထိုအမှုကိုဝှက် ထား၍ လင် မသိ လျှင်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","သီလ ပျက်သည်ဖြစ်စေ၊ မပျက်သည်ဖြစ်စေ၊ လင်သည် မယား ကိုမ ယုံလျှင် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ထိုမိန်းမ ပြုရသော ပူဇော်သက္ကာ ဘို့မုယော မုန့်တဩမဲ ပါလျက်၊ သူ့ကိုယဇ်ပုရောဟိတ် ထံသို့ ခေါ် သွားရမည်။ မုန့်ညက်ပေါ်မှာ ဆီ ကိုမ လောင်း ရ။ လောဗန် ကိုမ တင် ရ။ မယားကိုမ ယုံခြင်းပူဇော်သက္ကာ ၊ အပြစ် ကိုဖေါ် တင်ရာပူဇော်သက္ကာ ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ယဇ်ပုရောဟိတ် သည်၊ ထိုပူဇော်သက္ကာကို ယူ ၍ ထာဝရဘုရား ရှေ့ တော်၌ ထား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ယဇ်ပုရောဟိတ် သည် သန့်ရှင်း သော ရေ ကို မြေ အိုး ၌ လောင်း ပြီးလျှင် ၊ တဲ တော်၌ရှိသောမြေမှုန့် ကို ယူ ၍ ရေ ထဲမှာ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ထိုမိန်းမ ကို ထာဝရဘုရား ရှေ့ တော်မှာထား ပြီးလျှင် ၊ ခေါင်း ၌ အချည်းစည်း ရှိစေ၍၊ မယားကိုမ ယုံခြင်းပူဇော်သက္ကာ တည်းဟူသော သတိပေး ရာပူဇော်သက္ကာကို မိန်းမ လက် ၌ ထည့် ရမည်။ ကျိန် ခြင်းဘေးကိုဖြစ်စေသော ရေ ခါး ကို၊ ယဇ်ပုရောဟိတ် ကိုယ်တိုင်ကိုင် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ထိုအခါ ယဇ်ပုရောဟိတ် သည်၊ ထိုမိန်းမ ကို အကျိန် တိုက်လျက်၊ သင်သည် ကိုယ် ခင်ပွန်း မှတပါး အခြားသောယောက်ျား နှင့် မှားယွင်း ခြင်း၊ ညစ်ညူး ခြင်းမ ရှိလျှင် ၊ ကျိန် ခြင်းဘေးကိုဖြစ်စေသော၊ ဤရေ ခါး နှင့် ကင်းလွတ် စေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ကိုယ် ခင်ပွန်း မှတပါး အခြားသော ယောက်ျား နှင့် မှားယွင်း ၍ ညစ်ညူး ခြင်းရှိလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ထာဝရဘုရား သည်၊ သင် ၏ပေါင် ကို ပိန် စေ၍ ဝမ်း ကိုလည်း ရောင် စေသဖြင့်၊ သင့် ကိုကျိန် အပ်သောသူ၊ အထိမ်းအမှတ်ပြု၍ လူ များကျိန်ဆို ခြင်းကို ခံရသောသူဖြစ် စေခြင်းငှါစီရင်တော်မူစေသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ကျိန် ခြင်းဘေး ဖြစ်စေသော ဤ ရေ သည်သင် ၏ ဝမ်း ထဲသို့ ဝင် ၍ ဝမ်း ရောင် ခြင်း၊ ပေါင် ပိန် ခြင်းကိုဖြစ်စေ သတည်းဟု ယဇ်ပုရောဟိတ် သည် ကျိန် ခြင်းအကျိန် တိုက် လျှင် ၊ မိန်းမ က၊ အာမင် ၊ အာမင် ဟု ဝန်ခံ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","ယဇ်ပုရောဟိတ် သည်လည်း၊ ထို အကျိန် တို့ကို ရေးမှတ် ၍ ၊ တဖန် ရေ ခါး နှင့်ချေ ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ကျိန် ခြင်းဘေးဖြစ်စေသောရေ ခါး ကို မိန်းမ အား တိုက် ရမည်။ ထိုရေ သည် မိန်းမ ထဲသို့ ဝင် ၍ ခါး လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ထိုအခါ ယဇ်ပုရောဟိတ် သည်၊ မယားကို မ ယုံ ခြင်းပူဇော်သက္ကာကို မိန်းမ လက် မှ ယူ ၍ ၊ ထာဝရဘုရား ရှေ့ တော်၌ ချီ လွှဲလျက် ယဇ်ပလ္လင် ပေါ်မှာ ဆက် ပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","မုန့်ညက်တလက်ဆွန်း တည်းဟူသောပူဇော်သက္ကာ အတွက်အတာ ကို ယဇ်ပလ္လင် ပေါ်မှာ မီး ရှို့၍ ၊ ထိုနောက် အကျိန်ရေ ကို မိန်းမ သောက် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ထိုမိန်းမသည် လင် ကိုပြစ်မှား ၍ ညစ်ညူး ခြင်း ရှိလျှင် ၊ ကျိန်ခြင်းဘေးဖြစ်စေသော ရေ ကိုသောက် ပြီးမှ ၊ သူ့ အထဲ၌ ရေ ဝင် ၍ ခါး သဖြင့် ၊ ဝမ်း ရောင် ခြင်း၊ ပေါင် ပိန် ခြင်းသို့ရောက်၍ ထိုမိန်းမ သည် မိမိ အမျိုး ၌ ကျိန် အပ် သောသူဖြစ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","သို့မဟုတ် ထိုမိန်းမ သည် မ ညစ်ညူး ၊ စင်ကြယ် ခြင်းရှိလျှင် ၊ ဘေးနှင့်လွတ် ၍ ပဋိသန္ဓေ ယူသော အခွင့် ရှိလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ဤရွေ့ကား ၊ မိန်းမ သည် ကိုယ် ခင်ပွန်း မှတပါး အခြားသော ယောက်ျားနှင့် မှားယွင်း ၍ ညစ်ညူး ခြင်း ရှိသော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ယောက်ျား သည် မယားကို မ ယုံသောသဘော စွဲလမ်းသော်၎င်း၊ စောင့်ရသောတရား ပေတည်း။ ယောက်ျားသည် မယား ကိုမ ယုံ၊ ထာဝရဘုရား ရှေ့ တော်၌ ထား သောအခါ ၊ ယဇ်ပုရောဟိတ် သည် ဤ တရား အတိုင်း စီရင် သဖြင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ယောက်ျား သည် အပြစ် နှင့် ကင်းလွတ် ၍ မိန်းမ သည် မိမိ အပြစ် ကိုခံရ မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ယောက်ျား ဖြစ်စေ ၊ မိန်းမ ဖြစ်စေ၊ ထာဝရဘုရား အဘို့ မိမိကိုခြားနား စေ၍ နာဇရိ သစ္စာ ပြုခြင်းငှါ ၊ မိမိကို မိမိခွဲထားသောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","စပျစ်ရည် နှင့် ယစ် မျိုးကို ရှောင် ရမည်။ စပျစ်ရည် ချဉ် နှင့် ယစ် မျိုးချဉ် ကိုလည်း မ သောက် ရ။ စပျစ်သီး ဖြင့် လုပ်သောအရည် ကိုအလျှင်း မ သောက် ရ။ စပျစ်သီး အစိမ်း အခြောက် ကိုလည်း မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ခြားနား လျက်နေသောကာလ ပတ်လုံး ၊ စပျစ်သီးအဆန် ၊ စပျစ်သီးအခွံ မှစ၍စပျစ်ပင် က ဖြစ် သမျှ ကို မ စား ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ခြားနား ခြင်းသစ္စာ စောင့်သော ကာလ ပတ်လုံး ဦးဆံ ကို မ ရိတ် ရ။ ထာဝရဘုရား အဘို့ မိမိကို ခြားနား စေ သော ကာလ မ စေ့ မှီတိုင်အောင်၊ သူသည် သန့်ရှင်း ရ သဖြင့်၊ မိမိ ဆံပင် ကို အလိုအလျောက်တိုးပွား စေမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ထာဝရဘုရား အဘို့ မိမိ ကိုခြားနား စေသော ကာလ ပတ်လုံး ၊ အသေကောင် ကို မ ချဉ်း မကပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","သူ ၏ဘုရားသခင် အဘို့ သူ ၏ခေါင်း ကို ခြားနား စေသောကြောင့် ၊ မိ ဘ ၊ ညီအစ်ကို ၊ နှမ သေ သော်လည်း ၊ ညစ်ညူး ခြင်းကိုမ ခံရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ခြားနား လျက်နေသောကာလ ပတ်လုံး ၊ ထာဝရဘုရား အဘို့ သန့်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","သူ့ အနား မှာ တစုံတယောက်သောသူသည် ချက်ခြင်း သေ ၍ ၊ သူသည် ခြားနား စေသောခေါင်း ကို ညစ်ညူး စေလျှင် ၊ စင်ကြယ် စေသောနေ့ တည်းဟူသောသတ္တမ နေ့ ၌ ဦးဆံ ကိုရိတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","အဌမ နေ့ ၌ ခို နှစ် ကောင်ဖြစ်စေ ၊ ချိုး ကလေး နှစ် ကောင်ဖြစ်စေ၊ တခုခုကို ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့ ၊ ယဇ်ပုရောဟိတ် ထံသို့ ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ယဇ်ပုရောဟိတ် သည်လည်း ၊ အပြစ် ဖြေရာယဇ် ဘို့ တ ကောင်၊ မီးရှို့ ရာယဇ်ဘို့ တ ကောင်ကို ပူဇော် ၍ ၊ ထိုသူ ၌ အသေကောင် အားဖြင့် ရောက်သော အပြစ် ဖြေခြင်းကို ပြုပြီးမှ ၊ ထိုနေ့ခြင်း တွင် သူ ၏ခေါင်း ကို သန့်ရှင်း စေ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","အရင်ခြားနား စေသော ကာလ ကို ထာဝရဘုရား အဘို့ တဖန် ခြားနား စေ၍၊ အခါမလည် သော သိုးသငယ် တကောင်ကို ဒုစရိုက် ဖြေရာ ယဇ်ပြု၍ ပူဇော် ရမည်။ အရင်ခြားနား ခြင်းပျက် သောကြောင့် ၊ လွန် သောကာလ ပျောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ခြားနား ၍ နေသောကာလ စေ့ ပြီးမှ၊ နာဇရိ လူ စောင့်ရသောတရား ဟူမူကား ၊ သူသည် ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့သို့ လာ ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","မီးရှို့ ရာယဇ်ဘို့ အခါမလည် ၊ အပြစ် မပါသော သိုးသငယ် အထီးတ ကောင်၊ အပြစ် ဖြေရာယဇ်ဘို့ အခါမလည် ၊ အပြစ် မပါသော သိုးသငယ် အမတ ကောင်၊ မိဿဟာယ ယဇ်ဘို့ အပြစ် မပါသောဆိတ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ဆီ ရော သောမုန့်ညက် နှင့်လုပ်သော မုန့်ပြား ၊ ဆီ လူး သော တဆေးမဲ့ မုန့်ကြွပ် တည်းဟူသောတဆေးမဲ့ မုန့်တတောင်း ၊ ဘောဇဉ်ပူဇော်သက္ကာ ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို ထာဝရဘုရား အား ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ထိုပူဇော်သက္ကာများကို၊ ယဇ်ပုရောဟိတ် သည် ထာဝရဘုရား ထံ တော်သို့သွင်း ၍ ၊ အပြစ် ဖြေရာ ယဇ်၊ မီးရှို့ ရာယဇ်ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","တဆေးမဲ့ မုန့်တတောင်း နှင့်တကွ ၊ မိဿဟာယ ယဇ်ဆိတ် ကို၎င်း ၊ ဘောဇဉ်ပူဇော်သက္ကာ ၊ သွန်းလောင်း ရာပူဇော်သက္ကာကို၎င်း၊ ထာဝရဘုရား အား ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","နာဇရိ လူသည်၊ ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး နားမှာ၊ မိမိ ခြားနား သော ဦးဆံ ကိုရိတ် ၍ ၊ ထိုဆံ ကို မိဿဟာယ ယဇ်အောက် ၌ရှိသောမီး ထဲမှာ ထည့် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ခြားနား သော ဦးဆံကိုရိတ် ပြီးမှ ၊ ယဇ်ပုရောဟိတ် သည် ပြုတ် သော ဆိတ် ပခုံး တဘက်၊ တောင်း ထဲက တဆေးမဲ့ မုန့်ပြား တ ပြား၊ တဆေးမဲ့ မုန့်ကြွပ် တ ချပ်ကို ယူ ၍၊ နာဇရိ လူလက် ၌ ထည့် ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ထာဝရဘုရား ရှေ့ တော်၌ ချီလွှဲ ရာပူဇော်သက္ကာဘို့ ချီလွှဲ ရမည်။ ထိုအရာတို့သည်၊ ချီလွှဲ ရာရင်ပတ် ၊ ချီလွှဲရာ ပခုံး နှင့်တကွ၊ ယဇ်ပုရောဟိတ် အဘို့ သန့်ရှင်း ရမည်။ ထိုနောက်မှ ၊ နာဇရိ လူသည် စပျစ်ရည် ကို သောက် ရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ဤရွေ့ကား ၊ သစ္စာ ပြုသော နာဇရိ လူသည်၊ အလိုအလျောက်တတ်နိုင် သမျှ မှတပါး၊ မိမိ ခြားနား ခြင်းအတွက် ၊ ထာဝရဘုရား အား ဆက်ရသောပူဇော်သက္ကာ နှင့် ဆိုင် သော တရား ပေတည်း။ သစ္စာ ပြုသည်အတိုင်း ၊ ခြားနား ခြင်းတရား နှင့်အညီ ပြု ရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","သင်သည် အာရုန် နှင့် သူ ၏သား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင်တို့သည်၊ ဣသရေလ အမျိုးသား တို့အား ကောင်းကြီး ပေး၍ မြွက် ရသောစကားဟူမူကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ထာဝရဘုရား သည်၊ သင့် ကို ကောင်းကြီး ပေး၍ စောင့်မ တော်မူပါစေသော။ ");
INSERT INTO myajvb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ထာဝရဘုရား သည်သင် ၌ မျက်နှာ တော်အလင်း ကို လွှတ်၍ ကရုဏာ ကျေးဇူးပြုတော်မူပါစေသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ထာဝရဘုရား သည် သင့် ကို မြော်ကြည့် ၍ ချမ်းသာ ပေး တော်မူပါစေသောဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ဣသရေလ အမျိုးသား တို့ အပေါ် မှာ ငါ့ နာမ ကို မြွက်ဆို၍ တင် လျှင် ၊ ငါ သည်ထိုသူ တို့ကို ကောင်းကြီး မင်္ဂလာပေးမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","မောရှေ သည် တဲ တော်ကို ထူထောင် ၍၊ တဲတော် နှင့် တဲ တော်တန်ဆာ ရှိသမျှ တို့ကို၎င်း၊ ယဇ်ပလ္လင် နှင့် ယဇ်ပလ္လင် တန်ဆာ ရှိသမျှ တို့ကို၎င်း ဆီ လူး၍ ၊ သန့်ရှင်း စေခြင်း အမှုကို လက်စသတ် သောနေ့ ၌ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","စာရင်း ဝင်သောသူတို့ကို အုပ် ၍ ဣသရေလ အမျိုးအနွယ်အသီးသီးတို့၌ မင်း ဖြစ်သောသူ၊ အဆွေအမျိုး သူကြီးမင်း တို့သည်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","မင်းတပါးနွားထီး တကောင်စီ ၊ မင်း နှစ် ပါးအမိုး ပါသောရထား တခုစီ၊ ရထား ခြောက် ခု၊ နွား ဆယ် နှစ် ကောင်တို့ကို တဲ တော်ရှေ့သို့ ဆောင် ခဲ့၍ ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ထာဝရဘုရား ကလည်း ၊ သင်သည် ပရိသတ် စည်းဝေး ရာ တဲ တော်အမှု ဆောင်ရွက် စရာဘို့ ခံယူ ၍ အမှု ကို ဆောင်ရွက်ရသည့်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","လေဝိ သား အသီးသီး တို့ အား ပေး လော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","မောရှေ သည်ရထား နှင့် နွား တို့ကိုခံယူ ၍ လေဝိ သားတို့အား ပေး သဖြင့် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","အမှု ဆောင်ရွက်စရာရှိသည်အတိုင်း ၊ ယဇ်ပုရောဟိတ် အာရုန် ၏သား ဣသမာ အုပ်သော ဂေရရှုန် သား တို့ အား ရထား နှစ် ခုနှင့် နွား လေး ကောင်တို့ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","မေရာရိ သား တို့အား ရထား လေး ခုနှင့် နွား ရှစ် ကောင်တို့ကို၎င်းပေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","သန်ရှင်း ရာဌာနတော်အမှု ကို စောင့်ရသောကောဟတ် သား တို့သည်၊ မိမိ တို့ ပခုံး ၌ ထမ်းရွက် ရသောကြောင့် ၊ သူတို့အား ရထားနှင့် နွားတို့ကိုမ ပေး။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ယဇ်ပလ္လင် ကို ဆီ လူးသောနေ့ ၌ အနုမောဒနာ ပြုစရာဘို့ ယဇ်ပလ္လင် ရှေ့မှာ အခြားသော ပူဇော်သက္ကာ ကို ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ထာဝရဘုရား ကလည်း ၊ ယဇ်ပလ္လင် ကို အနုမောဒနာ ပြုစရာဘို့ ၊ မင်း အသီးအသီး တို့သည် နေ့ ရက်အစဉ်အတိုင်းမိမိ ပူဇော်သက္ကာ ကိုပြု ရကြမည်ဟု မောရှေ အား မိန့် တော်မူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ထိုသို့နှင့်အညီ၊ ပဌမ နေ့ ၌ ယုဒ အမျိုး ၊ အမိနဒပ် သား နာရှုန် သည် ဆက် သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့်ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို အမိနဒပ် သား နာရှုန် သည် ပူဇော် လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ဒုတိယ နေ့ ၌ ဣသခါ အမျိုးတွင် မင်း ဖြစ်သော ဇုအာ သား နာသနေလ ဆက် သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","မီးရှို့ရာနံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","မီးရှို့ ရာ ယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ် သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ဇုအာ သား နာသနေလ သည် ပူဇော် လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","တတိယ နေ့ ၌ ဇာဗုလုန် အမျိုး တွင် မင်း ဖြစ် သော ဟေလုန် သား ဧလျာဘ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တကောင် ၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင် တို့ကို၊ ဟေလုန် သား ဧလျာဘ သည်ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","စတုတ္ထ နေ့ ၌ ရုဗင် အမျိုး တွင်မင်း ဖြစ်သော ရှေဒုရ သား ဧလိဇုရ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ရှေဒုရ သား ဧလိဇုရ သည်ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ပဉ္စမ နေ့ ၌ ရှိမောင် အမျိုး တွင် မင်း ဖြစ်သော ဇုရိရှဒ္ဒဲ သား ၊ ရှေလုမျေလ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ် တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ဇုရိရှဒ္ဒဲ သား ရှေလုမျေလ သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ဆဌမ နေ့ ၌ ဂဒ် အမျိုး တွင် မင်း ဖြစ်သော ဒွေလ သား ဧလျာသပ် ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","မီးရှို့ရာနံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ဒွေလ သား ဧလျာသပ် သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","သတ္တမ နေ့ ၌ ဧဖရိမ် အမျိုး တွင် မင်း ဖြစ်သော အမိဟုဒ် သား ဧလိရှမာ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သောမုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ်သငယ် တ ကောင် ");
INSERT INTO myajvb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ အမိဟုဒ် သား ဧလိရှမာ သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","အဋ္ဌမ နေ့ ၌ မနာရှေ အမျိုး တွင်မင်း ဖြစ်သော ပေဒါဇုရ သား ဂါမလျေလ ဆက်သောပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ပေဒါဇုရ သား ဂါမလျေလ သည် ပူဇော် လေ၏၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","နဝမ နေ့ ၌ ဗင်္ယာမိန် အမျိုး တွင် မင်း ဖြစ်သော ဂိဒေါနိ သား အဘိဒန် ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန်ရှိသော ငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့်ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သောသိုးသငယ် ငါး ကောင်တို့ကို၊ ဂိဒေါနိ သား အဘိဒန် သည် ပူဇော် လေ၏၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ဒသမ နေ့ ၌ ဒန် အမျိုး တွင် မင်း ဖြစ်သော အမိရှဒ္ဒဲ သား အဟေဇာ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့်ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ အမိရှဒ္ဒဲ သား အဟေဇာ သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ဧကာဒသမ နေ့ ၌ အာရှာ အမျိုး တွင် မင်း ဖြစ် သော ဩကရန် သား ပါဂျေလ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့် ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ဩကရန် သား ပါဂျေလ သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ဒွါဒသမ နေ့ ၌ နဿလိ အမျိုး တွင် မင်း ဖြစ်သော ဧနန် သား အဟိရ ဆက်သော ပူဇော်သက္ကာ ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","အကျပ် တော်အလိုက် တပိဿာ သုံးဆယ်အချိန် ရှိသောငွေ အင်တုံ ၊ ခုနစ်ဆယ် အချိန်ရှိသောငွေ ဖလား ၊ ဘောဇဉ်ပူဇော်သက္ကာ ဘို့ ထိုအင်တုံ၊ ဖလား၌ ဆီ နှင့်ရော ၍ အပြည့် ထည့်သော မုန့်ညက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် ၍ အကျပ်တဆယ် အချိန်ရှိသောရွှေ ဇွန်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","မိဿဟာယ ယဇ်ဘို့ နွား နှစ် ကောင်၊ သိုး ငါး ကောင်၊ ဆိတ် ငါး ကောင်၊ အခါမလည် သော သိုးသငယ် ငါး ကောင်တို့ကို၊ ဧနန် သား အဟိရ သည် ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ထိုသို့ ဣသရေလ အမျိုးတို့၌ မင်း ဖြစ်သောသူတို့ သည်၊ ယဇ်ပလ္လင် ကို ဆီ လူးသောနေ့ ၌ အနုမောဒနာ ပြုစရာဘို့ ဆက်သော ငွေ အင်တုံ ပေါင်းဆယ် နှစ် လုံး၊ ငွေ ဖလား ပေါင်းဆယ် နှစ် လုံး၊ ရွှေ ဇွန်း ပေါင်း ဆယ် နှစ် စင်း တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ငွေ အင်တုံ အချိန်ကား၊ တလုံးလျှင် တပိဿာ သုံးဆယ်စီ ၊ ငွေ ဖလား အချိန်ကား၊ တလုံးလျှင် ခုနစ်ဆယ် စီ ရှိ၍ ငွေချိန်ပေါင်းကား၊ အကျပ် တော်အလိုက် ၊ အခွက် နှစ်ဆယ်လေးပိဿာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","မီးရှို့ရာ နံ့သာပေါင်း နှင့်ပြည့် သော ရွှေ ဇွန်း ဆယ် နှစ် စင်း အချိန်ကား၊ အကျပ် တော်အလိုက် ဆယ် ကျပ်စီရှိ၍၊ ရွှေ ချိန်ပေါင်း ကား တပိဿာ နှစ်ဆယ်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","မီးရှို့ ရာယဇ်ဘို့ ဘောဇဉ်ပူဇော်သက္ကာ နှင့်တကွ နွား ပေါင်းဆယ် နှစ် ကောင်၊ သိုးထီး ဆယ် နှစ် ကောင်၊ အခါမလည် သောသိုးသငယ် ဆယ် နှစ် ကောင်၊ အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ်သငယ် ပေါင်း ဆယ် နှစ် ကောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","မိဿဟာယ ယဇ်ဘို့ နွား ပေါင်း ၊ နှစ်ဆယ် လေး ကောင်၊ သိုးထီး ခြောက်ဆယ် ၊ ဆိတ်ထီး ခြောက်ဆယ် ၊ အခါမလည် သော သိုးသငယ် ခြောက်ဆယ် ရှိသတည်း။ ဤရွေ့ကား ၊ ယဇ်ပလ္လင် ဆီ လူးသောနောက် ၊ အနုမောဒနာ ပြုဘို့ ဆက်သော ပူဇော်သက္ကာပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","မောရှေ သည် ဘုရားသခင် ကို လျှောက် ခြင်းငှါ ပရိသတ်စည်းဝေး ရာ တဲ တော်ထဲသို့ ဝင် သောအခါ ၊ ခေရုဗိမ် နှစ် ပါးကြားမှာ ၊ သက်သေခံ ချက်သေတ္တာ အပေါ် ၌ တင်သောအဖုံး ထက် က ၊ ဘုရားသခင်ခေါ် တော်မူသံ ကို မောရှေသည်ကြား ၍ ထူး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ထာဝရဘုရား ကလည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","သင်သည်အာရုန် အား ဆင့်ဆို ရမည်မှာ၊ မီးခွက် များကို ထွန်း သောအခါ ၊ မီးခွက် ခုနစ် လုံး တို့သည် မီးခုံ တဘက်တချက် ၌ ထွန်းလင်း ရမည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","မောရှေ အား မှာထား တော်မူသည်အတိုင်း ၊ အာရုန် ပြု ၍ မီးခုံ တဘက်တချက် ၌ မီးခွက် များကို ထွန်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","မီးခုံမူကား၊ ထာဝရဘုရား သည် မောရှေ အား ပြ တော်မူသောပုံ နှင့်အညီ ၊ မီးခုံ တိုင် မှစ၍ ကြာပွင့် တိုင်အောင် ရွှေ ဖြင့် တစပ်တည်းထု လုပ်သော မီးခုံ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","လေဝိ သားတို့ကို၊ ဣသရေလ အမျိုးသား တို့ အထဲ က ရွေးကောက် ၍ စင်ကြယ် စေလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","စင်ကြယ် စေခြင်းငှါ ပြု ရမည်အမှုဟူမူကား ၊ စင်ကြယ် ခြင်း မင်္ဂလာရေ ကို သူ တို့အပေါ် မှာဖြန်း ၍၊ သူ တို့ သည် တကိုယ်လုံး ကို အမွေး ရိတ်ခြင်း၊ အဝတ် လျှော် ခြင်း ကို ပြုသဖြင့် စင်ကြယ် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ဆီ ရော သော မုန့်ညက် တည်းဟူသောဘောဇဉ်ပူဇော်သက္ကာ နှင့်တကွ ၊ အသက်ပျို သော နွားထီး တကောင်၊ အပြစ် ဖြေရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တကောင်ကို ယူ ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","လေဝိ သားတို့ကို ပရိသတ်စည်းဝေး ရာ တဲ တော် ရှေ့သို့ ခေါ် ခဲ့၍ ၊ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ကို စည်းဝေး စေပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","လေဝိ သားတို့ကို ထာဝရဘုရား ရှေ့ တော်သို့ ဆောင် ခဲ့၍ ၊ သူ တို့ခေါင်းပေါ်မှာ ဣသရေလ အမျိုးသား တို့သည် လက် ကိုတင် သဖြင့် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","သူတို့သည် ထာဝရဘုရား ၏ အမှု တော်ကို ထမ်း စေခြင်းငှါ ၊ ဣသရေလ အမျိုးသား တို့ပြုသောပူဇော်သက္ကာတည်းဟူသောလေဝိ သားတို့ကို အာရုန် သည် ထာဝရဘုရား အား ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","လေဝိ သားတို့သည်လည်း ၊ နွား ခေါင်း ပေါ်မှာ မိမိ တို့ လက် ကို တင် ၍ ၊ သူ တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုလိုသောငှါ ၊ ထာဝရဘုရား ရှေ့မှာ နွားတ ကောင်ကို အပြစ် ဖြေရာယဇ်၊ တ ကောင်ကို မီးရှို့ ရာ ယဇ်ပြု ၍ ပူဇော်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","လေဝိ သားတို့ကို၊ အာရုန် နှင့် သူ ၏ သား တို့ရှေ့မှာ ထား ၍ ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ထိုသို့ လေဝိ သားတို့ကို ဣသရေလ အမျိုးသား တို့ နှင့် တခြားစီ ခွဲထား၍ ၊ သူတို့သည် အထူးသဖြင့်ငါ့ လူဖြစ် ရကြ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ထိုနောက်မှ လေဝိ သားတို့သည်၊ ပရိသတ် စည်းဝေး ရာ တဲ တော်အမှုကို ဆောင်ရွက် ခြင်းငှါ ဝင် ရကြ လိမ့်မည်။ သူ တို့ကို စင်ကြယ် စေ၍၊ ပူဇော်သက္ကာ ပြု ရ သော အကြောင်းဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ဣသရေလ အမျိုး ထဲက သူ တို့ကို ရွေးကောက် ၍၊ ငါ့ အား အပိုင်ပေးရမည်။ ဣသရေလ အမျိုး တွင် အဦး ဘွားမြင်သော သားဦး များအတွက် သူတို့ကို ငါသိမ်းယူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","အဲဂုတ္တု ပြည် ၌ သားဦး အပေါင်း တို့ကို ငါသည် ဒဏ်ခတ် သောအခါ၊ ဣသရေလ အမျိုး တွင် လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ၊ သားဦး အပေါင်း တို့ကို ကိုယ် အဘို့ သန့်ရှင်း စေသောကြောင့် ၊ သားဦးအပေါင်းတို့ကို အထူးသဖြင့် ငါ ပိုင်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","တဖန် ဣသရေလ အမျိုး သားဦး အပေါင်း တို့ အတွက်၊ လေဝိ သားတို့ကို ငါယူ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","သူတို့သည်လည်း ပရိသတ်စည်းဝေး ရာ တဲ တော် ၌ ၊ ဣသရေလ အမျိုးသား ဆောင်ရွက်ရသောအမှု ကို ဆောင်ရွက် စေခြင်းငှါ ၎င်း ၊ ဣသရေလ အမျိုးသား တို့သည် သန့်ရှင်း ရာ ဌာနတော်သို့ ချဉ်းကပ် သောအခါ ၊ ဘေးဒဏ် နှင့် လွတ် မည်အကြောင်း ၊ အပြစ် ဖြေခြင်းကို ပြုစေခြင်းငှာ ၎င်း၊ ဣသရေလ အမျိုး ထဲ က လေဝိ သားတို့ကို၊ အာရုန် နှင့် သူ ၏သား တို့အား စွန့်ကြဲ ပေးကမ်းသည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","လေဝိ သားအမှု၌၊ ထာဝရဘုရား သည် မောရှေ အား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ နှင့် အာရုန် အစရှိသော ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ သည် လေဝိ သားတို့ကို ပြု ကြလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","သူတို့သည် စင်ကြယ် ခြင်းသို့ရောက်၍ မိမိ တို့ အဝတ် ကို လျှော် ကြ၏။ အာရုန် သည်လည်း ၊ သူ တို့ကို ထာဝရဘုရား အား ဆက်ကပ် ၍ သူ တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုသဖြင့် စင်ကြယ် စေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ထိုနောက်မှ လေဝိ သားတို့သည် အာရုန် နှင့် သူ ၏ သား တို့ရှေ့၌ ပရိသတ်စည်းဝေး ရာတဲ တော်အမှု ကို ဆောင်ရွက် ခြင်းငှါ ဝင် ကြ၏။ လေဝိ သားတို့အမှု၌ ထာဝရဘုရား သည် မောရှေ အားမှာထား တော်မူသည် အတိုင်း ၊ လူအပေါင်းတို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","လေဝိ သားတို့သည် အသက် နှစ်ဆယ် ငါး နှစ် လွန် မှ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှု ကို ဆောင်ရွက် ခြင်းငှါ ဝင် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","အသက် ငါးဆယ် လွန်မှ အမှု လွတ် ၍ နောက်တဖန် မ ဆောင်ရွက် ဘဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ပရိသတ်စည်းဝေး ရာတဲ တော်၌ မိမိ ညီအစ်ကို တို့နှင်အတူကူညီ ၍ အလှည့်လှည့်စောင့် ရကြမည်။ ထိုသို့လေဝိ သားများစောင့် ရသောအမှုကို စီရင် ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","အဲဂုတ္တု ပြည် မှ ထွက် ၍ ဒုတိယ နှစ် ၊ ပဌမ လ ၌ သိန တော တွင် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူ သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ဣသရေလ အမျိုးသား တို့သည်၊ ချိန်းချက် သော ကာလအချိန်၌ ပသခါ ပွဲကို ခံရ ကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","စီရင် ထုံးဖွဲ့သမျှ သောထုံးစံ အတိုင်း ၊ ချိန်းချက် သော ကာလအချိန်တည်းဟူသောယခု လ တဆယ် လေး ရက် နေ့ ညဦးယံ ၌ စောင့် ရကြမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ဣသရေလ အမျိုးသား တို့သည် ပသခါ ပွဲကို ခံရ မည်အကြောင်း၊ မောရှေ ဆင့်ဆို သည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","သိန တော တွင် ပဌမ လ တဆယ် လေး ရက် နေ့ ညဦးယံ ၌ ပသခါ ပွဲကိုခံရ ကြ၏။ မောရှေ အား ထာဝရဘုရား မှာထား တော်မူသမျှ အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့သည် ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ထို နေ့ ၌ ပသခါ ပွဲကိုမ ခံရ မည်အကြောင်း၊ လူ အသေကောင် အားဖြင့် ညစ်ညူး ခြင်းသို့ ရောက် သော လူ အချို့တို့သည်၊ ထို နေ့ ၌ မောရှေ နှင့် အာရုန် ထံသို့ ချဉ်းကပ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","အကျွန်ုပ် တို့သည် လူ အသေကောင် အားဖြင့် ညစ်ညူး ခြင်း ရှိပါ၏။ ချိန်းချက် သောအချိန်၌ ဣသရေလ အမျိုးသား တို့နှင့်အတူ ၊ ထာဝရဘုရား အား ပူဇော်သက္ကာ ကို မ ပြု စေခြင်းငှါ၊ အကျွန်ုပ်တို့ကို ဆီးတား ပါမည်လောဟု မေးလျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","မောရှေ ကလည်း ၊ နေ ကြဦးလော့။ သင် တို့အမှု၌ ထာဝရဘုရား မိန့် တော်မူသော စကားကို ငါနားထောင် ဦးမည်ဟု ပြန်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ထိုအခါ မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","သင်သည်ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ သင် တို့အမျိုးသား သည် အသေကောင် အားဖြင့် ညစ်ညူး ခြင်းရှိ သော်၎င်း ၊ ဝေး သောအရပ်သို့ ခရီး သွားသော်၎င်း၊ ထာဝရဘုရား အဘို့ ပသခါ ပွဲကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ဒုတိယ လ တဆယ် လေး ရက် နေ့ညဦးယံ ၌ ပွဲ ခံ၍၊ သိုးသငယ်အသားကို တဆေး မပါသော မုန့်၊ ခါး သော ဟင်းသီးဟင်းရွက်နှင့် စား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ထိုအသားကို နံနက် တိုင်အောင် မ ကြွင်း စေရ။ အရိုး ကိုလည်း မ ချိုး ရ။ ပသခါ ပွဲနှင့်ဆိုင်သောအထုံးအဖွဲ့ရှိသမျှ တို့ ကို လိုက်၍ ပွဲ ခံရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ညစ်ညူး ခြင်းမရှိ၊ အခြားတပါးသို့ ခရီး မ သွား သောသူသည် ပသခါ ပွဲကို မ ခံ ပဲနေလျှင်၊ ထို သူ ကို သူ ၏ အမျိုး မှ ပယ်ရှင်း ရမည်။ ချိန်းချက် သော အချိန်၌ ထိုသူသည်၊ ထာဝရဘုရား အဘို့ ပူဇော်သက္ကာ ကို မ ဆောင် ခဲ့ သောကြောင့်မိမိ အပြစ် ကိုခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","သင် တို့ထံမှာတည်းခို သော တပါး အမျိုးသားသည်၊ ထာဝရဘုရား အဘို့ ပသခါ ပွဲကို ခံ ခြင်းငှါအလိုရှိလျှင် ၊ စီရင် ထုံးဖွဲ့၍ ခံရသောထုံးစံ အတိုင်း ပွဲ ခံရ မည်။ သင်တို့တွင် တည်းခိုသော တပါး အမျိုးသားဖြစ်သောသူ၊ အမျိုးသား ချင်းဖြစ်သောသူတို့သည် ထုံးစံ တပါးတည်း သာ ရှိ ရကြမည်ဟုမိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","တဲ တော်ကို ထူထောင် သောနေ့ ၌ ၊ မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှာ တည်၍၊ သက်သေခံ ချက် တဲ တော်ကို ဖုံးအုပ် လေ၏။ ညဦး မှစ၍ နံနက် တိုင်အောင် တဲ တော်ပေါ်မှာ မီး ကဲ့သို့ ထင်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ထိုသို့ အစဉ် ဖြစ် ၍နေ့အချိန်၌မိုဃ်းတိမ် ဖုံးအုပ် လျက် ၊ ည အချိန်၌မီး ကဲ့သို့ထင်လျက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှ ကွာ မြောက်သောအခါ ၊ ဣသရေလ အမျိုးသား တို့သည် ခရီးသွား ကြ၏။ မိုဃ်းတိမ် တည် လေရာရာ ၌ လည်း ၊ တဲ များကို ဆောက်ပြန်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့သည် ခရီးသွား ကြ၏။ ထာဝရဘုရား မိန့် တော်မူသည် အတိုင်း လည်း တဲ များကို ဆောက်ကြ၏။ မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှာ တည် နေသမျှသော ကာလ ပတ်လုံး သူတို့သည် တဲ ၌နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှာ နေ့ ရက်ကြာမြင့် စွာတည် နေသောအခါ ၊ ဣသရေလ အမျိုးသား တို့ သည် ခရီး မ သွားဘဲ ထာဝရဘုရား ထံတော်၌ စောင့် နေကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှာ နေ့ ရက်အနည်းငယ် မျှ တည် နေသောအခါ ၊ ထာဝရဘုရား အမိန့် တော်အတိုင်း ၊ သူတို့သည် တဲ ၌ နေကြ၏။ ထာဝရဘုရား အမိန့် တော်အတိုင်း လည်း၊ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ညဦးယံ မှစ၍ နံနက် အချိန်တိုင်အောင် မိုဃ်းတိမ် တည် နေ၍၊ နံနက် အချိန်၌ မြောက် သောအခါ ခရီးသွား ကြ၏။ နေ့ ဖြစ်စေ ၊ ည ဖြစ်စေ၊ မိုဃ်းတိမ် မြောက် သောအခါ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","နှစ်ရက် ဖြစ်စေ ၊ တလ ဖြစ်စေ ၊ တနှစ် ဖြစ်စေ ၊ မိုဃ်းတိမ် သည် တဲ တော်ပေါ်မှာ တည် နေသမျှသော ကာလပတ်လုံး ဣသရေလ အမျိုးသား တို့သည် ခရီး မ သွားဘဲ တဲ ၌နေကြ၏။ တဖန် မိုဃ်းတိမ်မြောက် ပြန် သောအခါ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ထာဝရဘုရား အမိန့် တော်အတိုင်း တဲ ၌ နေကြ ၏။ထာဝရဘုရား အမိန့် တော်အတိုင်း လည်း ခရီးသွား ကြ၏။ ထာဝရဘုရားသည် မောရှေ အားဖြင့် မိန့် တော်မူသည် အတိုင်း ထာဝရဘုရား အထံတော်၌ စောင့် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","သင်သည် ပရိသတ် စည်းဝေး စေခြင်းငှါ ၎င်း ၊ တပ် တို့ကို ချီ စေခြင်းငှါ ၎င်း၊ မှုတ်ရသောငွေ တံပိုး နှစ် လုံး ကို၊ တလုံးလျှင် ငွေတတုံးစီဖြင့်မဆက်ဘဲလုပ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","တံပိုးမှုတ် သောအခါ ၊ ပရိသတ် အပေါင်း တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး ရှေ့ ၊ သင့် ထံ၌ စည်းဝေး ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","တံပိုးတလုံးတည်း ကို မှုတ် လျှင် ၊ ဣသရေလ အမျိုး၌ လူတထောင် ကို အုပ် သောမင်း တို့သည် သင့် ထံ၌ စည်းဝေး ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","နှိုးဆော် သံနှင့်မှုတ် သောအခါ ၊ အရှေ့ တပ် တို့ သည် ချီ သွားရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ဒုတိယ အကြိမ်နှိုးဆော် သံနှင့် မှုတ် သောအခါ ၊ တောင် တပ် တို့ သည် ချီ သွားရကြမည်။ တတိယအကြိမ် နှိုးဆော်သံနှင့် မှုတ်သောအခါ၊ အနောက်တပ်တို့သည် ချီသွားရကြမည်။ စတုတ္ထအကြိမ်နှိုးဆော်သံနှင့် မှုတ်သောအခါ၊ မြောက်တပ်တို့သည် ချီသွားရကြမည်။ အစဉ်အတိုင်းချီ သွားစေခြင်းငှာ နှိုးဆော် သံနှင့်မှုတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ပရိသတ် စည်းဝေး စေခြင်းငှါနှိုးဆော် သံကိုမ ပြု ဘဲ တံပိုးမှုတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","အာရုန် ၏ သား ၊ ယဇ်ပုရောဟိတ် တို့သည် ထိုတံပိုး ကို မှုတ် ရကြမည်။ သင် တို့အမျိုး အစဉ်အဆက် စောင့်ရသောပညတ် ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","သင်တို့သည် ကိုယ် ပြည် ၌ နေသောအခါ၊ တိုက် လာသောရန်သူ တို့ကို စစ် ချီ လျှင် ၊ နှိုးဆော် သံနှင့် တံပိုး မှုတ်ရမည်။ ထိုအခါ သင် တို့၏ ဘုရားသခင် ထာဝရဘုရား သည် သင်တို့ကို အောက်မေ့ ၍ ၊ ရန်သူ လက်မှ ကယ်တင် တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","သင် တို့သည် ရွှင်လန်း ခြင်းကို ပြုသောနေ့ ၊ ပွဲသဘင် နေ့၊ လဆန်း နေ့တို့၌ ၊ သင် တို့ဘုရားသခင် အောက်မေ့ တော်မူဘို့ရာ၊ သင် တို့မီးရှို့ ရာယဇ်၊ မိဿဟာယ ယဇ် ပူဇော်သက္ကာ များအပေါ် မှာ တံပိုး မှုတ် ရကြမည်။ ငါ သည် သင် တို့၏ဘုရားသခင် ထာဝရဘုရား ဖြစ်သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ဒုတိယ နှစ် ၊ ဒုတိယ လ အရက်နှစ်ဆယ် မြောက် သော နေ့ရက်၌၊ မိုဃ်းတိမ် သည် သက်သေခံ ချက်တဲ တော် မှ ကွာ မြောက်သည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ဣသရေလ အမျိုးသား တို့သည် သိနာ တောင် မှ ခရီးသွား ကြ၏။ နောက် တဖန် မိုဃ်းတိမ် သည် ပါရန် တော ၌ တည် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ထိုသို့ ထာဝရဘုရား သည် မောရှေ အားဖြင့် မိန့် တော်မူသည်အတိုင်း ၊ ပဌမ ခရီး သွားခြင်းကို ပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ယုဒ တပ် အစဉ်အတိုင်းအလုံးအရင်း တို့သည်၊ အလံ နှင့်တကွရှေ့ဦးစွာ ချီ သွားကြ၏။ ယုဒတပ်ကို၊ အမိနဒပ် သား နာရှုန် အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ဣသခါ တပ် ကို၊ ဇုအာ သား နာသနေလ အုပ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ဇာဗုလုန် တပ် ကို၊ ဟေလုန် သား ဧလျာဘ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","တဲ တော်ကိုဖြုတ် ချ၍ ဂေရရှုန် သား ၊ မေရာရိ သား တို့သည် တဲ တော်ကို ထမ်း လျက်ချီ သွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ရုဗင် တပ် အစဉ်အတိုင်း အလုံးအရင်း တို့သည် အလံ နှင့်တကွချီ သွားကြ၏။ ရုဗင် တပ် ကို ရှေဒုရ သား ဧလိဇုရ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ရှိမောင် တပ် ကို ဇုရိရှဒ္ဒဲ သား ရှေလုမျေလ အုပ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ဂဒ် တပ် ကို ဒွေလ သား ဧလျာသပ် အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ကောဟတ် သားတို့သည် သန့်ရှင်း ရာဌာန တန်ဆာတို့ကို ထမ်း လျက် ချီ သွားကြ၏။ သူ တို့မ ရောက် မှီ အရင်သွားသောသူတို့ သည် တဲ တော်ကို ထူထောင် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ဧဖရိမ် တပ် အစဉ်အတိုင်းအလုံးအရင်း တို့သည် အလံ နှင့်တကွချီ သွားကြ၏။ ဧဖရိမ် တပ် ကို အမိဟုဒ် သား ဧလိရှမာ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","မနာရှေ တပ် ကို ပေဒါဇုရ သား ဂါမလျေလ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ဗင်္ယာမိန် တပ် ကို ဂိဒေါနိ သား အဘိဒန် အုပ် ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","နောက်ဆုံးတပ်တည်းဟူသောဒန် တပ် အစဉ်အတိုင်း အလုံးအရင်း တို့သည် အလံ နှင့်တကွချီ သွားကြ ၏။ ဒန်တပ်ကို အမိရှဒ္ဒဲ သား အဟေဇာ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","အာရှာ တပ်ကို ဩကရန် သား ပါဂျေလ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","နဿလိ တပ် ကိုဧနန် သား အဟိရ အုပ်ရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ထိုသို့ ဣသရေလ အမျိုးသား တို့သည်ချီသွားသောအခါ၊ တပ် များအစဉ်အတိုင်း ချီ ၍ ခရီးသွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","မောရှေ ကလည်း ၊ ထာဝရဘုရား ၏ ဂတိတော် အတိုင်း ငါတို့အားပေး တော်မူမည်အရပ် သို့ ငါ တို့ သည် ယခုခရီးသွား ကြ၏။ ငါ တို့နှင်အတူ လိုက်၍လာ ပါ။ ငါတို့သည် ကျေးဇူး ပြုပါမည်။ ထာဝရဘုရား သည် ဣသရေလ အမျိုးသားတို့၌ ကျေးဇူး ပြုတော်မူမည် ဂတိ ရှိပါ၏ဟု မိမိယောက္ခမ မိဒျန် အမျိုး၊ ရွေလ သား ဟောဗပ် အား ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ဟောဗပ်ကငါမ လိုက် မသွားပါ၊ ငါ့ နေရင်းပြည် ၊ ငါ့ အဆွေအမျိုး ရှိရာသို့ ပြန်သွား ပါမည်ဟု မောရှေ အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","မောရှေကလည်း၊ ငါ တို့ကို စွန့်ပစ် ၍ မ သွားပါ နှင့်။ သင်သိ သည်အတိုင်း ငါ တို့သည်တော ၌ စားခန်းချ ရမည်။ သင်သည် ငါ တို့မျက်စိ ဖြစ် ရပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ငါ တို့နှင့်အတူ လိုက် လျှင် ထာဝရဘုရား ပြု တော်မူ သောကျေးဇူး တော်ကို ငါ တို့သည် ခံရသည်အတိုင်း၊ သင် ၌ ကျေးဇူး ပြုပါမည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ဣသရေလအမျိုးသားတို့သည် ထာဝရဘုရား ၏ တောင် တော်မှ ထွက် ၍၊ သုံး ရက် ကွာသော ခရီး ကို သွားကြ ၏။ ထိုသုံး ရက် ကွာသော ခရီး ကိုသွားကြစဉ်၊ ထာဝရဘုရား ၏ ပဋိညာဉ် သေတ္တာ သည် သူ တို့အဘို့ စားခန်းချ ရာအရပ်ကို ရှာ ၍ သူ တို့ရှေ့ ကသွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","သူတို့သည် နေ့ အချိန်၌ တပ် ချီ ၍ သွားသောအခါ ၊ ထာဝရဘုရား ၏ မိုဃ်းတိမ် သည် သူ တို့အပေါ် မှာ ရှိလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","သေတ္တာ တော်သွား သောအခါ ၊ မောရှေ က၊ အိုထာဝရဘုရား ၊ ထ တော်မူပါ၊ ကိုယ်တော် ၏ ရန်သူ တို့ သည် လွင့် ကြပါစေသော။ ကိုယ်တော် ကို မုန်း သောသူတို့ သည် ရှေ့ တော်မှ ပြေး ကြပါစေသောဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","သေတ္တာတော်မသွားဘဲ ရပ် နေသောအခါ ၊ အိုထာဝရဘုရား၊ ဣသရေလ အမျိုးသားအထောင် ၊ အသောင်းရှိရာသို့ ပြန်လာ တော်မူပါဟူ၍၎င်း လျှောက်ဆို လေ့ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","တဖန် လူ များတို့သည် အလို တော်မရှိသော မြည်တမ်း ခြင်းကို ပြုကြသဖြင့်၊ ထာဝရဘုရား သည် သူတို့ စကားကိုကြား ၍ အမျက် ထွက်တော်မူ၏။ ရှို့တော်မူသောမီး သည် သူ တို့တွင် လောင် ၍ တပ် အစွန် အနား၌ ရှိသောသူအချို့တို့ကို သေ စေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","လူ များတို့သည် မောရှေ အား အော်ဟစ် ၍ ၊ မောရှေ သည် ထာဝရဘုရား ကို ဆုတောင်း သဖြင့် မီး ငြိမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ထာဝရဘုရား ၏ မီး သည် သူ တို့တွင် လောင် သောကြောင့် ၊ ထို အရပ် ကို တဗေရ ဟူသောအမည် ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ဣသရေလအမျိုးသားတို့နှင့် ရောနှော လျက် ပါသောတပါးအမျိုးသားတို့သည် တောင့်တ သောစိတ် စွဲလမ်း ကြ၏။ ဣသရေလ အမျိုးသား တို့သည်လည်း တဖန် ငိုကြွေး လျက် ငါ တို့စား စရာဘို့ အမဲသား ကို အဘယ်သူ ပေးလိမ့်မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","အဲဂုတ္တု ပြည်၌ အလိုအလျောက် စား ရသော ငါး သား၊ သခွါးသီး ၊ ဖရဲသီး ၊ ကြက်သွန် အနီ၊ အဖြူ ၊ အရိုင်းအမျိုးမျိုးတို့ကို အောက်မေ့ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ယခု မှာ ငါ တို့အသက် သည် အားလျော့ ပြီ။ ဤ မန္န မှတပါး တစုံတခု ကိုမျှ မ မြင် ရဟုဆိုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","မန္န သည် နံနံ စေ့ နှင့်တူ ၍ ဗဓေလ သစ်စေ့ကဲ့သို့ အဆင်း ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","လူ များတို့သည်လှည့်လည် လျက် မန္နကိုစုသိမ်း ၍ ဆုံ ၌ ကြိတ် ခြင်း၊ ထောင်း ခြင်းကိုပြုပြီးမှ အိုး နှင့် ပြုတ် ကြ၏။ မုန့်ပြား ကိုလည်း လုပ် ကြ၏။ အရသာ သည် မုန့်ဆီကြော် အရသာ နှင့် တူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","စားခန်းချ ရာအရပ်၌ ညဉ့် အခါနှင်း နှင့်အတူ မန္န ကျ တတ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ထိုအခါ လူ များအသီးအသီးတို့သည် မိမိ တဲ တံခါးဝ ၌ မိမိ အိမ်ထောင် နှင့်တကွငိုကြွေး ကြသည်ကို မောရှေ ကြား ရ၏။ ထာဝရဘုရား သည် ပြင်းစွာ အမျက် ထွက်တော်မူ၏။ အပြစ် ရှိသည်ကို မောရှေ သိမြင် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ဤ လူ အပေါင်း တို့ကို ထမ်းစေဟု သူတို့ကို ကိုယ်တော် ကျွန် အပေါ် မှာ တင် ၍ အဘယ်ကြောင့် အကျွန်ုပ် ကို ညှဉ်းဆဲ တော်မူပါသနည်း။ အဘယ်ကြောင့် ရှေ့ တော်၌ မျက်နှာ မ ရဘဲ နေရပါသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","သူ တို့ဘိုးဘေး များ၌ ကျိန်ဆို တော်မူသော ပြည် သို့ သွား၍၊ အထိန်း သည် နို့စို့ သူငယ်ကိုဆောင် သကဲ့သို့ ၊ ဤလူတို့ကို ပိုက်ချီ လျက်ဆောင်လော့ဟု အကျွန်ုပ် အား မိန့် တော်မူမည်အကြောင်း ၊ ဤ လူ အပေါင်း တို့ကို အကျွန်ုပ် သည် ကိုယ်ဝန်ဆောင် ပါသလော။ ဘွားမြင် ပါသလော။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ဤ လူ အပေါင်း တို့အား ကျွေး စရာဘို့ အမဲသား ကို အကျွန်ုပ် သည် အဘယ်မှာ ရနိုင်ပါအံ့နည်း။ သူတို့က အကျွန်ုပ် တို့ စား စရာဘို့ အမဲသား ကိုပေး ပါဟု ငိုကြွေး လျက် အကျွန်ုပ် ကို တောင်း ကြပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ဤ လူ အပေါင်း တို့ကို အကျွန်ုပ် တယောက်တည်း သာ မ ဆောင်ရွက် နိုင် ပါ။ ဆောင်ရွက်ရသောဝန်လည်း လေး လွန်းပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ထိုသို့ အကျွန်ုပ် ၌ ပြု တော်မူလျှင် ၎င်း၊ စိတ် တွေ့တော်မူလျှင် ၎င်း၊ အကျွန်ုပ် ကိုအလျင်အမြန်သေ စေတော်မူပါ။ ကိုယ် ဆင်းရဲ ကို ကိုယ်မ သိ မမြင်ပါစေနှင့်ဟု ဘုရား အား လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ထာဝရဘုရား ကလည်း ၊ သင်ကျွမ်းကျင် သော ဣသရေလ အမျိုးသား အသက်ကြီး ခုနစ်ကျိပ် တို့ကို ငါ့ ရှေ့မှာ စုဝေး စေပြီးလျှင်၊ ပရိသတ်စည်းဝေး ရာ တဲ တော် သို့ ခေါ် ခဲ့၍ သင် နှင့်အတူ ရပ် နေကြစေလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ငါသည်လည်း ထို အရပ်သို့ ဆင်းသက် ၍ သင် နှင့် နှုတ်ဆက် မည်။ သင့် အပေါ် မှာ ကျိန်းဝပ်သော ဝိညာဉ် အချို့ကို ငါယူ ၍ သူ တို့အပေါ် မှာ တင် မည်။ ဤလူတို့ ကို သင် တယောက်တည်း သာ ဆောင်ရွက် ရမည် မ ဟုတ်၊ ထိုအသက်ကြီးသူတို့သည် ဝိုင်းညီ၍ ဆောင်ရွက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","သင်သည်လည်း လူ များတို့အား ဆင့်ဆို ရမည်မှာ၊ နက်ဖြန် နေ့အဘို့ ကိုယ်ကိုကိုယ်သန့်ရှင်း စင်ကြယ်လော့။ အမဲသား ကိုစား ရကြမည်။ သင်တို့က အဘယ်သူသည် ငါ တို့ အား အမဲသား ကိုပေး လိမ့်မည်နည်း။ အဲဂုတ္တု ပြည်၌ နေစဉ်၊ ငါ တို့သည် ချမ်းသာ စွာနေကြ၏ဟု ငိုကြွေး လျက် ပြောဆို သံကို ထာဝရဘုရား ကြား သောကြောင့်၊ အမဲသား ကိုပေး တော်မူသဖြင့် သင်တို့သည် စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","တ ရက် ၊ နှစ်ရက် ၊ ငါး ရက် ၊ ဆယ် ရက် ၊ အရက် နှစ်ဆယ် သာ စား ရကြမည်မ ဟုတ်။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","သင် တို့နှာခေါင်း ထဲက အမဲသားထွက် ၍ ရွံ စရာ ဖြစ် သည်တိုင်အောင် တလ ပတ်လုံးစားရကြမည်။ အကြောင်းမူကား ၊ သင် တို့တွင် ရှိတော်မူသောထာဝရဘုရား ကို၊ သင်တို့သည် မထီမဲ့မြင်ပြု လျက်၊ ငါတို့သည် အဲဂုတ္တု ပြည်မှ အဘယ်ကြောင့် ထွက်လာ ရကြသနည်းဟု ရှေ့ တော်၌ ငိုကြွေး လျက် ပြောဆို ကြပြီ တကားဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","မောရှေ ကလည်း ၊ အကျွန်ုပ် နှင့် ဆိုင်သော လူ ယောက်ျားအပေါင်းခြောက် သိန်းရှိကြသည်ဖြစ်၍ကိုယ်တော်က တ လစား စရာဘို့ သူ တို့အား အမဲသား ကို ငါပေး မည်ဟု မိန့် တော်မူပါသည်တကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","သူ တို့ကို ဝ စွာကျွေးခြင်းငှါ၊ သိုး ဆိတ်နွား စုတို့ကိုသတ် ရပါမည်လော။ သို့မဟုတ်ဝ စွာကျွေးခြင်းငှါ၊ ပင်လယ် ငါး ရှိသမျှ တို့ ကိုစုဝေး ရပါမည်လောဟု လျှောက် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ထာဝရဘုရား က၊ ထာဝရဘုရား လက် တို သလော။ ငါ့ စကား တည် မည် မ တည်မည်ကို သင်သိ လိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","မောရှေ သည် ထွက် ၍ ထာဝရဘုရား ၏ စကား တော်ကို လူ များတို့အား ဆင့်ဆို ပြီးလျှင် ၊ အမျိုးသား အသက်ကြီး သူခုနစ်ကျိပ် တို့ကို စုဝေး စေ၍ ၊ ပရိသတ် စည်းဝေးရာ တဲ တော်ပတ်လည် ၌ ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ထာဝရဘုရား သည် မိုဃ်းတိမ် ဖြင့် ဆင်းသက် ၍ မောရှေ နှင့် နှုတ်ဆက် တော်မူ၏။ မောရှေ အပေါ် မှာ ကျိန်းဝပ်သော ဝိညာဉ် အချို့ ကို ယူ ၍ အသက်ကြီး သူ ခုနစ်ကျိပ် တို့အပေါ် မှာ တင် တော်မူသဖြင့် ၊ ထိုဝိညာဉ် သည် သူ တို့အပေါ် မှာ ကျိန်းဝပ် သောအခါ ၊ သူတို့သည် ပရောဖက်ပြု ၍ မပြတ်မစဲ ဟောကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ထိုလူ စု၌ ပါသောသူ ဧလဒဒ် နှင့် မေဒဒ် တို့သည် စာရင်း ဝင်သော်လည်း ၊ တဲ တော်သို့ မ သွား ဘဲ တပ် ထဲမှာ နေရစ် စဉ်တွင်သူ တို့အပေါ် မှာ ထိုဝိညာဉ် ကျိန်းဝပ် သဖြင့် သူတို့သည်လည်း ပရောဖက်ပြု ၍ တပ် ထဲမှာ ဟောကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","လုလင် တယောက်သည်လည်း မောရှေ ထံသို့ ပြေး ၍ ၊ ဧလဒဒ် နှင့် မေဒဒ် တို့သည် တပ် ထဲမှာ ပရောဖက်ပြု ၍ဟောပါ၏ဟု လျှောက် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","မောရှေ ၏ လက်ထောက် ဖြစ်သော လုလင်နုန် သား ယောရှု က၊ သခင် မောရှေ ၊ သူ တို့ကို ဆီးတား တော်မူပါဟုဆို သော်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","မောရှေ က၊ သင် သည် ငါ့ အတွက် ငြူစူ သောစိတ် ရှိသလော။ ထာဝရဘုရား ၏ လူ အပေါင်း တို့သည် ပရောဖက် ဖြစ် ကြပါစေသော။ ထာဝရဘုရား သည် ဝိညာဉ် တော်ကို သူ တို့အပေါ် မှာ တင် တော်မူပါစေသောဟု ဆို ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ဣသရေလ အမျိုးသားအသက်ကြီး သူတို့နှင့်အတူ တပ် ထဲသို့ ပြန် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ထိုအခါ ထာဝရဘုရား သည် လေ ကိုစေလွှတ် ၍ ၊ ငုံး များကို ပင်လယ် မှ ဆောင် ခဲ့သဖြင့် ၊ တပ် ပတ်လည်တရက် ခရီး စီတိုင်တိုင်ကွာသော အရပ်တို့၌၊ မြေ ပေါ်မှာ ဒုနှစ်တောင် ခန့် မျှ ဆင်း စေတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","လူ များတို့သည် တနေ့လုံး ၊ တညဉ့်လုံး ၊ နက်ဖြန် လည်း တနေ့လုံး ထ ၍ ငုံး များကို စုသိမ်း ကြ၏။ နည်းနည်း သိမ်းသောသူသည် ဆယ် ဟောမဲ ကို သိမ်း ရ၏။ တပ် ပတ်လည် အရပ်ရပ်၌ ဖြန့် ထားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","သို့ရာတွင်ငုံးသား ကို ကိုက် ၍ မ ဝါး မှီ၊ ထာဝရဘုရား သည် သူတို့ကို အမျက် တော်ထွက်၍ အလွန် ပြင်း သော ဘေး နှင့်ဒဏ်ခတ် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","တောင့်တ သောသူ တို့ကို သင်္ဂြိုဟ် ရာထို အရပ် ကို ကိဗြုတ်ဟတ္တဝါ ဟူသောအမည်ဖြင့် မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","လူ များတို့သည် ကိဗြုတ်ဟတ္တဝါ အရပ်မှ ထွက် ပြီးလျှင်၊ ဟာဇရုတ် အရပ်သို့ ရောက်၍နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","မောရှေသည် ကုရှ အမျိုးသားမိန်းမ နှင့် စုံဘက် သည်ဖြစ်၍ ၊ ထိုမိန်းမကြောင့် မိရိအံ နှင့် အာရုန် သည် မောရှေ ကို အပြစ်တင် လျက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","အကယ်၍ ထာဝရဘုရား သည်၊ မောရှေ အားဖြင့် သာ ဗျာဒိတ် ပေးတော်မူသလော။ ငါ တို့အားဖြင့် လည်း ပေး တော်မ မူလောဟု ဆို ကြ၏။ ထိုစကားကို ထာဝရဘုရား ကြား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","မောရှေ သည် မြေကြီး ပေါ်မှာ ရှိနေသောသူ အပေါင်း တို့ထက် သာ၍နူးညံ့ သိမ်မွေ့သော သဘောရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ထာဝရဘုရား ကလည်း ၊ သင် တို့သုံး ယောက် သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ ထွက်သွား ကြလော့ ဟု မောရှေ ၊ အာရုန် ၊ မိရိအံ တို့အား ချက်ခြင်း မိန့် တော်မူ၍ သူတို့သည် ထွက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ထာဝရဘုရား သည် မိုဃ်းတိမ် တိုင် ဖြင့် ဆင်းသက် ၍ ၊ ပရိသတ်စည်းဝေးရာ တဲ တော်တံခါးဝ ၌ ရပ် လျက်၊ အာရုန် နှင့် မိရိအံ ကို ခေါ် တော်မူ၍ ၊ သူတို့သည် ချဉ်းကပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ထာဝရဘုရားကလည်း၊ ငါ့ စကား ကို နားထောင် ကြလော့။ သင် တို့တွင် ပရောဖက် ရှိ လျှင် ၊ ငါထာဝရဘုရား သည် ထိုသူ ၌ ထူးဆန်းသော ရူပါရုံ အားဖြင့် ကိုယ်ကိုပြ မည်။ သို့မဟုတ်အိပ်မက် အားဖြင့် ဗျာဒိတ် ပေးမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","အိမ် တော်တအိမ်လုံး၌ သစ္စာ စောင့်သော ငါ့ ကျွန် မောရှေ သည် ထိုသို့ မ ဟုတ်။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","သူ ၌ ဗျာဒိတ် ပေးသောအခါ ၊ နက်နဲ သောစကား အားဖြင့် မ ပေး၊ ကိုယ်တိုင် ကိုယ်ကြပ်ထင်ရှား စွာ ဗျာဒိတ် ပေးမည်။ သူသည် ထာဝရဘုရား ၏ ပုံသဏ္ဌာန် ကိုလည်း မြင် ရမည်။ သို့ဖြစ်၍ သင်တို့သည် ငါ့ ကျွန် မောရှေ ကို အဘယ့်ကြောင့် အပြစ်တင် ဝံ့ သနည်းဟု မိန့် တော်မူလျက် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","အမျက် တော်ထွက် ၍ ထာဝရဘုရား ကြွ သွား တော်မူသဖြင့် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","မိုဃ်းတိမ် သည် တဲ တော်အပေါ် မှ ကွာ သွား၏။ မိရိအံ သည်လည်း ၊ နူနာ စွဲ၍ မိုဃ်းပွင့် ကဲ့သို့ ဖြူလေ၏။ အာရုန် ကြည့် ၍ မိရိအံ နူ သည်ကိုမြင် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","အို အကျွန်ုပ် သခင် ၊ အကျွန်ုပ်တို့သည် မိုက် သောအမှုကို ပြုမိ၍ ပြစ်မှား သောအပြစ် ကို အကျွန်ုပ် တို့အပေါ် မှာ တင် တော်မ မူပါနှင့်၊ အကျွန်ုပ် တောင်းပန်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ဘွား စက ပင် ကိုယ် အသား တဝက် ပျက် သောအသေကောင် ကဲ့သို့ သူသည် မ ဖြစ် ပါစေနှင့်ဟု တောင်းပန် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","မောရှေ က၊ အို ဘုရားသခင် ၊ သူ ၏အနာကို ပျောက် စေတော်မူပါ၊ အကျွန်ုပ် တောင်းပန်ပါ၏ဟု ထာဝရဘုရား အား အော်ဟစ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ထာဝရဘုရား ကလည်း ၊ သူ ၏ အဘ သည် သူ ၏ မျက်နှာ ကို တံထွေး နှင့် ထွေးရုံမျှသာပြုလျှင်၊ သူသည် ခုနစ် ရက် ပတ်လုံးအရှက် ကွဲခြင်းကိုခံရမည် မ ဟုတ်လော။ ယခုတွင် သူ့ကိုနှင်ထုတ်၍ ခုနစ် ရက် ပတ်လုံးတပ် ပြင် မှာ နေစေ။ ထို့နောက်မှ တပ်ထဲသို့ တဖန် ဝင်စေဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","မိရိအံ ကို နှင်ထုတ် ၍ သူသည် ခုနစ် ရက် ပတ်လုံးတပ် ပြင် မှာ နေရ၏။ မိရိအံ အနာမ ပျောက်မှီတိုင်အောင်လူ များတို့သည် ခရီးမ သွား ဘဲ နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ထို့နောက် ဟာဇရုတ် အရပ်မှ ပြောင်း ၍ ပါရန် တော ၌ တဲ ဆောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","ဣသရေလ အမျိုးသား တို့အား ငါ ပေး သော ခါနာန် ပြည် ကို စူးစမ်း စေခြင်းငှါ၊ အမျိုးအနွယ် အသီးအသီး ထဲက အဆွေအမျိုး သူကြီး ဖြစ်သောသူ တမျိုး တယောက်စီ ရွေးကောက်၍ စေလွှတ် လော့ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း၊ မောရှေ သည် လူ တို့ကို ပါရန် တော က စေလွှတ် လေ၏။ စေလွှတ်သောသူအပေါင်း တို့သည် ဣသရေလ အမျိုး ၌ အကဲအမှူး ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","သူ တို့အမည် ကား၊ ရုဗင် အမျိုး ၊ ဇက္ကုရ သား ရှမွာ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ရှိမောင် အမျိုး ၊ ဟောရိ သား ၊ ရှာဖတ်။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ယုဒ အမျိုး ၊ ယေဖုန္န သား ကာလက်။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ဣသခါ အမျိုး ၊ ယောသပ် သား ဣဂါလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ဧဖရိမ် အမျိုး ၊ နုန် သား ဩရှေ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ဗင်္ယာမိန် အမျိုး ၊ ရာဖု သား ပါလတိ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ဇာဗုလုန် အမျိုး ၊ သောဒိ သား ဂါဒျေလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ယောသပ် သား တွင် မနာရှေ အမျိုး ၊ သုသိ သား ဂဒ္ဒိ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ဒန် အမျိုး ၊ ဂေမလ္လိ သား အမျေလ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","အာရှာ အမျိုး ၊ မိက္ခေလ သား သေသုရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","နဿလိ အမျိုး ၊ ဝါဖသိ သား နာဘိ။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ဂဒ် အမျိုး မာခိ သား ဂွေလ တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ခါနာန်ပြည် ကို စူးစမ်း စေခြင်းငှါ မောရှေ စေလွှတ် သောသူတို့ ၏အမည် တည်း။ နုန် ၏သား ဩရှေ ကို ယောရှု ဟူသောအမည်ဖြင့် မောရှေ မှည့် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ခါနာန် ပြည် ကို စူးစမ်း စေခြင်းငှါ မောရှေ စေလွှတ် လျက် ၊ သင်တို့သည် တောင် မျက်နှာလမ်းဖြင့် သွား ၍ တောင်ရိုး ပေါ်သို့တက် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ထိုပြည် သည် အဘယ်သို့ သော ပြည်ဖြစ် သနည်း။ ပြည်သား တို့သည် အားကြီး သလော၊ အားနည်း သလော။ များ သလော၊ နည်း သလော။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","သူ တို့နေ သောပြည် သည် ကောင်း သလော၊ မကောင်း လော။ သူ တို့နေ သော မြို့ ရွာတို့သည် အဘယ်သို့ နည်း။ တဲ နှင့် နေကြသလော။ ခိုင်ခံ့ သော မြို့နှင့် နေကြသလော။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ထိုမြေ သည် ကောင်း သလော၊ မကောင်း လော။ တော များသလော၊ နည်း သလောဟုကြည့်ရှုကြလော့။ ရဲရင့် သောစိတ်ရှိကြလော့။ သစ်သီး အချို့ ကိုလည်း ယူ ခဲ့ ကြလော့ဟု မှာလိုက်လေ၏။ ထိုကာလ သည် စပျစ်သီး မှည့် စကာလ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ထိုသူတို့သည် ဇိန တော မှ သွား ၍ ဟာမတ် မြို့သို့ ရောက်သော လမ်းနား၊ ရဟောဘ မြို့တိုင်အောင် ခါနာန် ပြည် ကို စူးစမ်း ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","တောင် မျက်နှာ၌ ရှောက်သွား ၍ အာနက အမျိုးသား အဟိမန် ၊ ရှေရှဲ ၊ တာလမဲ နေသောဟေဗြုန် မြို့သို့ ရောက် ကြ၏။ ဟေဗြုန် မြို့ကား၊ အဲဂုတ္တု ပြည်၌ ဇောန မြို့ မ တည်မှီ ခုနစ် နှစ် ကတည် သော မြို့ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ဧရှကောလ ချိုင့် သို့ ရောက် လျှင် ၊ အသီး တ ပြွတ် ပါသောစပျစ်နွယ်ပင်အခက် တခက်ကို ခုတ် ၍ လူ နှစ် ယောက်တို့သည် ထမ်းဘိုး နှင့်ထမ်း ကြ၏။ သလဲသီး ၊ သင်္ဘောသဖန်းသီး များကိုလည်း ဆောင်ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ဣသရေလ အမျိုးသား ခုတ် ယူသော စပျစ်သီး ပြွတ်ကိုထောက်၍ ၊ ထို ချိုင့် ကို ဧရှကောလ ချိုင့် ဟူသောအမည်ဖြင့် မှည့် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","အရက် လေးဆယ် လွန် မှ ခါနာန်ပြည် ကို စူးစမ်း သော အမှုပြီး၍ ပြန် လာကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","မောရှေ နှင့် အာရုန် မှစ၍ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့နေရာ ပါရန် တော ၊ ကာဒေရှ အရပ်သို့ ရောက် သောအခါ ၊ ပရိသတ် အပေါင်း တို့အား သိတင်း ကြားပြော၍ ၊ ထိုပြည် ၌ သီးသော အသီး ကို ပြ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","မောရှေ အား လည်း ၊ အကျွန်ုပ်တို့သည်ကိုယ်တော်စေလွှတ် သော ပြည် သို့ ရောက် ခဲ့ပါပြီ။ အကယ်စင်စစ် ထိုပြည်သည် နို့ နှင့် ပျားရည် စီး သော ပြည်ဖြစ်ပါ၏။ ဤ အသီးတို့ ကား ထိုပြည်၌သီးသော အသီး ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","သို့ရာတွင် ပြည်သူ ပြည်သားတို့သည် အားကြီး ပါ၏။ ခိုင်ခံ့ သော မြို့ ကြီး နှင့်နေကြပါ၏။ ထိုမျှမက ၊ အာနက အမျိုးသား တို့ကိုလည်း မြင် ရပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","အာမလက် အမျိုးသားတို့သည် တောင် ဘက် ၌၎င်း၊ ဟိတ္တိ လူ၊ ယေဗုသိ လူ၊ အာမောရိ လူတို့သည် တောင်ရိုး ပေါ်၌ ၎င်း၊ ခါနာနိ လူတို့သည် ပင်လယ် နား ယော်ဒန် မြစ်နား၌၎င်း၊ နေ ကြပါသည်ဟု လျှောက်ဆို ကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ကာလက် ကလည်း ချက်ခြင်းချီ သွား၍ ထိုပြည် ကို သိမ်းယူ ကြစို့။ အောင်နိုင် ကောင်းသည်ဟု ဆို ၍ မောရှေ ရှေ့မှာ လူ များတို့ကို ငြိမ်း စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","သူ နှင့်အတူ လိုက် သွားသော သူ တို့က၊ ထိုပြည်သား တို့ကို ငါတို့ မ တိုက် နိုင်။ သူ တို့သည် ငါ တို့ထက် သာ၍အားကြီး ကြသည်ဟူ၍၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ငါတို့သွား ၍ စူးစမ်း သော ပြည် သည် မိမိ သား တို့ကို ဖျက်ဆီး တတ်၏။ ငါတို့တွေ့မြင် သော ပြည်သား အပေါင်း တို့သည် အလွန် အရပ်မြင့်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ကိုယ် ကြီးသောလူအမျိုးအနွယ်၊ အာနက အမျိုးအနွယ် ဖြစ်၍၊ အလွန် ကြီးမားသောသူတို့ ကိုလည်း မြင် ခဲ့ ကြပြီ။ သူတို့ရှေ့မှာငါတို့သည် ကိုယ် အထင် အတိုင်း နှံကောင် ကဲ့သို့ ဖြစ် ကြ၏။ သူ တို့အထင် အတိုင်း လည်း ထိုသို့ ဖြစ် ကြသည်ဟူ၍၎င်း၊ မိမိတို့စူးစမ်း သော ပြည် ကို ဣသရေလ အမျိုးသား တို့အား မကောင်း သော သိတင်းကို ကြားပြော ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ထိုအခါ ပရိသတ် အပေါင်း တို့သည် အသံ ကို လွှင့် ၍ မြည်တမ်းသဖြင့် ၊ တညဉ့်လုံး ငိုကြွေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ သည်၊ မောရှေ နှင့် အာရုန် ကို အပြစ်တင် သော စကားနှင့် မြည်တမ်းလျက် ၊ ငါတို့သည် အဲဂုတ္တု ပြည် ၌ မသေ ပါလေ။ ဤ တော ၌ မသေ ပါလေ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ငါတို့သည် ထား ဖြင့် သေ ၍ သား မယား တို့သည် ရန်သူ လက်သို့ ရောက်စေခြင်းငှါ၊ ထာဝရဘုရား သည် အဘယ်ကြောင့် ငါ တို့ကို ဤ အရပ် သို့ ဆောင် ခဲ့တော်မူသနည်း။ အဲဂုတ္တု ပြည်သို့ ပြန် ကောင်း သည်မ ဟုတ်လော ဟု မောရှေနှင့် အာရုန်အားဆို ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","တဖန် လူတစုံတယောက်ကိုချီးမြှောက် ၍ ၊ အဲဂုတ္တု ပြည်သို့ ပြန် ကြစို့ဟု တယောက် ကို တယောက်ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","မောရှေ နှင့် အာရုန် တို့သည်၊ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ရှေ့မှာ ပြပ်ဝပ် လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ခါနာန်ပြည် ကို စူးစမ်း သောလူစုထဲက နုန် ၏ သား ယောရှု ၊ ယေဖုန္နာ ၏သား ကာလတ် တို့သည် မိမိ တို့အဝတ် ကို ဆုတ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ဣသရေလ အမျိုးသား အပေါင်း တို့အား ခေါ် လျက်၊ ငါတို့ရှောက်သွား ၍စူးစမ်း သော ပြည် သည် အလွန်တရာ ကောင်း သော ပြည် ဖြစ်ပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ထာဝရဘုရား သည် ငါ တို့ကိုနှစ်သက် လျှင် ၊ နို့ နှင့် ပျားရည် စီး သော ထိုပြည် သို့ ငါ တို့ကို ဆောင် သွင်း၍ အပိုင်ပေး တော်မူလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ထာဝရဘုရား ကို မ ပုန်ကန် ကြပါနှင့်။ ထိုပြည်သူ ပြည်သားတို့ကို မ ကြောက် ကြနှင့်။ သူ တို့သည် ငါ တို့ စားစရာ ဘို့ဖြစ်ကြ၏။ သူ တို့၌ အမှီတကဲ မ ရှိ။ ထာဝရဘုရား သည် ငါ တို့ဘက်၌ ရှိတော်မူ၏။ သို့ဖြစ်၍သူ တို့ကို မ ကြောက် ကြနှင့်ဟု ပြောဆို ကြလေသော်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ပရိသတ် အပေါင်း တို့သည်၊ ထိုသူ နှစ်ယောက်ကို ကျောက်ခဲ နှင့် ပစ် စေခြင်းငှါ စီရင် ကြ၏။ ထိုအခါ ထာဝရ ဘုရား ၏ဘုန်း တော်သည် ဣသရေလ အမျိုးသား အပေါင်း တို့ ရှေ့မှာ ပရိသတ်စည်းဝေး ရာ တဲ တော်၌ ထင်ရှား လေ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ထာဝရဘုရား ကလည်း ၊ ဤ လူမျိုး သည် အဘယ်မျှ ကာလပတ်လုံးငါ့ ကို မရိုမသေ ပြုကြလိမ့်မည်နည်း။ သူ တို့၌ ငါပြ ခဲ့ပြီးသမျှ သော နိမိတ် လက္ခဏာတို့ကို မြင်ရ သော်လည်းအဘယ်မျှ ကာလပတ်လုံးငါ့ ကို မ ယုံ ဘဲနေကြလိမ့်မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","သူ တို့ကိုကာလနာ ဘေးဖြင့် ငါသည် ဒဏ်ခတ် ၍ သား၏ အရာကိုနှုတ် မည်။ သူ တို့ထက် သင့် ကိုသာ၍စည်ပင် သောအမျိုး ၊ သာ၍တန်ခိုးကြီး သောအမျိုး ဖြစ် စေမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","မောရှေ ကလည်း ၊ ကိုယ်တော်သည် ဤ လူမျိုး ကို တန်ခိုး တော်အားဖြင့် အဲဂုတ္တု လူတို့ထဲက နှုတ်ဆောင် ခဲ့ တော်မူသည်ဖြစ်၍ ၊ နောက်တဖန် ဤသိတင်းကို အဲဂုတ္တု လူတို့သည် ကြား ပြန်လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ဤ ပြည် ၌ နေ သောသူတို့အား သိတင်းပြော ကြ လိမ့်မည်။ ထာဝရဘုရား ၊ ကိုယ်တော် သည် ဤ လူမျိုး ၌ ရှိတော်မူကြောင်းကို၎င်း၊ ထာဝရဘုရား ၊ ကိုယ်တော် သည် ထင်ရှား တော်မူကြောင်းကို၎င်း၊ မိုဃ်းတိမ် တော်သည် သူ တို့ကို လွှမ်းမိုး ကြောင်းကို၎င်း၊ ကိုယ်တော် သည် နေ့ အချိန်၌ မိုဃ်းတိမ် တိုင် ၊ ညဉ့် အချိန်၌ မီး တိုင် ဖြင့် သူ တို့ ရှေ့က ကြွ တော်မူကြောင်းကို၎င်းကြား ရကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ယခုမှာ၊ ဤ လူမျိုး ကို လူ တ ယောက်ကဲ့သို့ မှတ်၍ သုတ်သင် ပယ်ရှင်းတော်မူလျှင် ၊ သိတင်း တော်ကို ကြား ဘူး သော လူ အမျိုးမျိုးတို့က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ထာဝရဘုရား သည် ထိုလူ တို့အား ဤမည်သော ပြည်ကို ငါပေးမည်ဟု ကျိန်ဆို သော်လည်း၊ ထို ပြည် သို့ သူတို့ကို ဆောင် သွင်းခြင်းငှါ မ တတ်နိုင် သောကြောင့် ၊ တော ၌ သုတ်သင် ပယ်ရှင်းပြီဟု ပြောဆို ကြပါလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ကိုယ်တော်က၊ ထာဝရဘုရား သည်သည်းခံ သောသဘော၊ သနား သောသဘောနှင့်ပြည့်စုံတော်မူထသော၊ အဓမ္မ ကျင့်ခြင်း၊ တရားတော်ကို လွန်ကျူးခြင်း အပြစ် တို့ကို ဖြေလွှတ် သော်လည်း ၊ အချည်းနှီးသက်သက်ဖြေလွှတ် တော်မ မူထသော၊ လူအစဉ်အဆက်၊ တတိယ အဆက်၊ စတုတ္တ အဆက်တိုင်အောင် ၊ အဘ တို့၏အပြစ် ကိုသား တို့၌ ဆပ်ပေး စီရင်တော်မူသော ဘုရားသခင်ဖြစ်၏ဟု မိန့် တော်မူသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","အကျွန်ုပ် တို့၏ဘုရားရှင် တန်ခိုး တော်သည်ကြီး ပါစေသော။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","အဲဂုတ္တု ပြည်ကထွက်သောနေ့ မှစ၍ ယခု တိုင်အောင် ဤ လူမျိုး ၏အပြစ်ကို လွှတ် တော်မူသည်နည်းတူ ၊ ကရုဏာ တော်များပြား သည်နှင့်အညီ ၊ ယခု လည်း လွှတ် တော်မူပါ၊ အကျွန်ုပ်တောင်းပန်ပါ၏ဟု ထာဝရဘုရား အား လျှောက်ဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ထာဝရဘုရား က၊ သင် တောင်းပန် သည်အတိုင်း ငါလွှတ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ငါ အသက် ရှင်သည်ဖြစ်၍ ၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် မြေ တပြင်လုံး ၌ နှံ့ပြား လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ငါ့ ဘုန်း တော်ကို၎င်း ၊ အဲဂုတ္တု ပြည်မှစ၍ ဤ တော ၌ ထူးဆန်း သော တန်ခိုးတော်ကို၎င်းမြင် ရသောလူ အပေါင်း တို့သည်၊ ငါ့ စကား ကိုနား မ ထောင်၊ဆယ် ကြိမ် တိုင်အောင်ငါ့ ကိုစုံစမ်း သောကြောင့် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","သူ တို့ဘိုးဘေး တို့အား ငါကျိန်ဆို သော ပြည် ကို အကယ်စင်စစ်သူတို့သည်မ မြင် ရကြ။ ငါ့ ကိုမရိုမသေ ပြု သော သူတစုံတယောက် မျှ မ မြင် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ငါ့ ကျွန် ကာလက် မူကား ထူးခြား သော သဘော ရှိ ၍ ၊ ငါ့ နောက်သို့ လုံးလုံး လိုက်သောကြောင့် ၊ သူသွား ခဲ့ပြီးသော ပြည် သို့ သူ့ ကို ငါဆောင် သွင်းသဖြင့် ၊ သူ ၏သား မြေးတို့သည် အမွေ ခံရကြ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","အာမလက် အမျိုးသားနှင့် ခါနာန် အမျိုးသားတို့သည် ချိုင့် မှာ နေ ကြသည်ဖြစ်၍ ၊ သင် တို့သည် နက်ဖြန် နေ့ ၌လှည့်လည် ၍ ဧဒုံ ပင်လယ် လမ်း ဖြင့် တော သို့သွား ကြလော့ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ငါ့ ကို အပြစ်တင် ၍ မြည်တမ်း သောဤ ပရိသတ် ဆိုး တို့ကို အဘယ်မျှ ကာလပတ်လုံးငါသည် သည်းခံရအံ့နည်း။ ဣသရေလ အမျိုးသား တို့သည် ငါ့ ကိုအပြစ်တင် ၍ မြည်တမ်းသော စကားတို့ကို ငါကြား ရပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","သင်သည် သူ တို့အား ဆင့်ဆို ရမည်မှာ၊ ထာဝရဘုရား က၊ ငါ အသက် ရှင်သည်ဖြစ်၍၊ သင်တို့သည် ငါ့ ကို ကြား စေခြင်းငှါပြော ကြသော စကားအတိုင်း သင် တို့ကို ငါပြု မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","သင် တို့ကို ရေတွက် ၍ စာရင်း ယူသည်အတိုင်း၊ အသက် နှစ်ဆယ် လွန် သောသူ၊ ငါ့ ကို အပြစ်တင် ၍ မြည်တမ်း သောသူအပေါင်း တို့သည် သေ ၍ ဤ တော ၌ အသေကောင် ဖြစ်လျက် နေရစ်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ငါသည် ဤမည်သောပြည် ၌ သင် တို့ကို နေရာ ချမည်ဟု ငါကျိန်ဆို ၏။ ထို ပြည် သို့ ယေဖုန္နာ ၏သား ကာလက် ၊ နုန် ၏သား ယောရှု မှတပါး အဘယ်သူ မျှမရောက် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ရန်သူလုယူ ရာ ဖြစ် လိမ့်မည်ဟု သင်တို့ဆို သော သူငယ် တို့ကို ငါဆောင် သွင်း၍ သင်တို့ပယ် သော ပြည် ကို သူတို့သည်သိ ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","သင် တို့မူကား ၊ ဤ တော ၌ သေ ၍ အသေကောင် ဖြစ်လျက်၊ နေရစ်ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ဤတော ၌ သင် တို့အသေကောင် များ ပျောက်ပျက် သည်တိုင်အောင် ၊ ကိုယ် သားသမီး တို့သည် မိဘ မှားယွင်း ခြင်းအပြစ်များကို ဆောင် ၍၊ ဤတော ၌ အနှစ် လေးဆယ် ပတ်လုံးလှည့်လည် ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ထိုပြည် ကို စူးစမ်း ရာ နေ့ ရက်ပေါင်း အရက် လေးဆယ် နှင့်အညီ၊ တရက် ကို တနှစ် ထား၍၊ အနှစ် လေးဆယ် ပတ်လုံးကိုယ် အပြစ် ကိုဆောင် လျက်၊ ငါ့ စွန့်ပစ် ခြင်းကို သိ ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","အကယ်စင်စစ် ငါ တဘက် ၌ စည်းဝေး သော ဤ ပရိသတ် ဆိုး အပေါင်း တို့ကို ထိုသို့ငါပြု ၍ သူတို့သည် ဤ တော ၌ သေကြေ ပျောက်ပျက် ကြ လိမ့်မည်ဟု ငါ ထာဝရ ဘုရား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","မောရှေ စေလွှတ် သော အခွင့်နှင့် ခါနာန်ပြည် ကို စူးစမ်း ၍ ပြန်လာ သောအခါ ၊ ထိုပြည် ကို ကဲ့ရဲ့ သဖြင့် ပရိသတ် အပေါင်း မြည်တမ်း စေခြင်းငှါတိုက်တွန်းသောသူ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ခါနာန်ပြည် ကို မကောင်း သောသိတင်း ကြားပြောသောသူ တို့ သည်၊ ထာဝရဘုရား ရှေ့ တော်၌ ကာလနာ ဘေးနှင့် သေ ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ထိုပြည် ကို စူးစမ်း ၍ သွား သောလူတို့တွင် နုန် ၏ သား ယောရှု နှင့် ယေဖုန္န ၏သား ကာလက် တို့သာ အသက် ချမ်းသာရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","မောရှေ သည် ဣသရေလ အမျိုးသား အပေါင်း တို့ အား စကား တော်များကို ဆင့်ဆို သောအခါ ၊ လူ များတို့ သည် အလွန် ညည်းတွား လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","နံနက် စောစောထ ၍ တောင် ထိပ် ပေါ်သို့ တက် ပြီးလျှင် ၊ ငါတို့သည် ပြစ်မှား ပြီ။ သို့သော်လည်း ယခုအသင့် ရှိပါ၏။ ထာဝရဘုရား ဂတိ ထားတော်မူသော ပြည် သို့ သွား ပါမည်ဟုဆို ကြသော်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","မောရှေ က၊ ထာဝရဘုရား ၏ အမိန့် တော်ကို အဘယ်ကြောင့် လွန်ကျူး ကြသနည်း။ သင်တို့အကြံ မ ထမြောက်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","မ သွား ကြနှင့်၊ ထာဝရဘုရား သည် သင် တို့ဘက်၌ ရှိတော်မ မူ။ သွားလျှင် ရန်သူ ရှေ့မှာ ရှုံး ရကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","အာမလက် အမျိုးသားနှင့် ခါနာန် အမျိုးသားတို့ သည် သင် တို့မ ရောက်မှီရောက်နှင့်သည်ဖြစ်၍၊ သင်တို့သည် ထား ဖြင့် ဆုံး ကြလိမ့်မည်။ ထာဝရဘုရား ထံ တော်မှ လွှဲသွား သောကြောင့် ၊ ထာဝရဘုရား သည် သင် တို့ဘက်၌ နေ တော်မ မူဟုဆို သော်လည်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","သူတို့သည်ခိုင်ခံ့ သောစိတ်နှင့် တောင် ထိပ် ထက် သို့ တဖန်တက် ကြ၏။ သို့ရာတွင် ၊ ထာဝရဘုရား ၏ ပဋိညာဉ် သေတ္တာ တော်နှင့်တကွ ၊ မောရှေ သည် တပ် ပြင် သို့ မ ထွက် မသွားဘဲ နေလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ထိုအခါ တောင် ပေါ်မှာရှိ နှင့်သော အာမလက် အမျိုးသားနှင့် ခါနာန် အမျိုးသားတို့သည် ဆင်းလာ လျက် ၊ ဣသရေလအမျိုးသားတို့ကို တိုက် ၍ အောင်သဖြင့်၊ ဟောမာ မြို့တိုင်အောင် လိုက် ကြလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့ကို ဆင့်ဆို ရမည်မှာ၊ သင် တို့နေရာ ဖြစ်သော ငါ ပေး သော ပြည် သို့ ရောက် ၍ နေကြသောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","သစ္စာ ဂတိရှိ၍ ပူဇော် သော်၎င်း ၊ အလိုလို ပူဇော်သော်၎င်း ၊ ပွဲ သဘင်ခံ၍ ပူဇော်သော်၎င်း ၊ မီးရှို့ ရာယဇ် အစရှိသော အခြားသောယဇ်ကို မီး ဖြင့်ပူဇော်၍၊ သိုး နွား အားဖြင့်ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ ကို ပြု ခြင်းငှါ အလိုရှိလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ထာဝရဘုရား အား ပူဇော်သက္ကာ ကိုပြု သောသူသည်၊ သိုးသငယ် ကိုပူဇော်လျှင်၊ မီးရှို့ရာယဇ် ဖြစ်စေ ၊ အခြားသောယဇ် ဖြစ်စေ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ယဇ်နှင့်တကွ ဘောဇဉ် ပူဇော်သက္ကာကို ဆီ သုံး လောဃရော သောမုန့်ညက် တဩမဲ ကို၎င်း၊ သွန်းလောင်း ရာပူဇော်သက္ကာဘို့ စပျစ်ရည် သုံး လောဃကို၎င်း၊ ပြင်ဆင် ၍ဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","သိုး ကိုပူဇော်လျှင်၊ ထာဝရဘုရား အဘို့မွှေးကြိုင် သောအနံ့ ရှိစေခြင်းငှါ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ဘောဇဉ် ပူဇော်သက္ကာဘို့ ဆီ လေး လောဃရော သောမုန့်ညက် နှစ် ဩမဲကိုပြင်ဆင် ၍ သွန်းလောင်း ရာပူဇော်သက္ကာဘို့ စပျစ်ရည် လေး လောဃကိုပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ထာဝရဘုရား အား မီးရှို့ ရာယဇ်၊ သစ္စာ ဂတိရှိ၍ ပူဇော်သောယဇ် ၊ မိဿဟာယ ယဇ်ဘို့ နွား ကို ပြင်ဆင် လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","မီး ဖြင့်ပူဇော်၍ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ ရှိစေခြင်းငှါ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","နွား နှင့်တကွဘောဇဉ် ပူဇော်သက္ကာဘို့ ဆီ ခြောက် လောဃရော သောမုန့်ညက် သုံး ဩမဲကို၎င်း၊ သွန်းလောင်း ရာပူဇော်သက္ကာဘို့ စပျစ်ရည် ခြောက် လောဃကို၎င်းဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","နွား တ ကောင်၊ သိုး တ ကောင်၊ သိုးသငယ် တကောင်၊ ဆိတ်သငယ် တကောင်ကို ယဇ်ပူဇော်သောအခါထိုသို့ ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ပြင်ဆင် သော သိုး နွားအရေအတွက် သို့ လိုက်၍၊ တကောင်တကောင် ကို ထိုသို့ ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ပြည်သား အပေါင်း တို့သည် မီး ဖြင့် ပူဇော် ၍ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ ရှိစေခြင်းငှါ၊ ထိုသို့ နှင့်အညီပြု ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","သင် တို့တွင် တည်းခို သော တပါး အမျိုးသားဖြစ်စေ ၊ အခြား တပါးသောသူဖြစ်စေ၊ မီး ဖြင့် ပူဇော် ၍ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ ရှိစေခြင်းငှါအလိုရှိ လျှင်၊ သင်တို့ပြု သည်နည်းတူ သူသည်လည်း ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ပရိသတ် အဝင်ဖြစ်သောသူ၊ သင် တို့တွင် တည်းခို သော တပါး အမျိုးသားဖြစ်သောသူတို့သည်၊ သင် တို့အမျိုး အစဉ်အဆက် စောင့်ရသောတပါးတည်းသော ထုံးစံ ရှိ၍၊ ထာဝရဘုရား ရှေ့ တော်၌ သင် တို့သည် ဖြစ် သည်နည်းတူ သူသည်လည်း ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","သင် တို့ကိုယ်တိုင်မှစ၍ သင် တို့တွင် တည်းခို သော တပါး အမျိုးသားတို့သည် တပါးတည်း သော တရား ၊ တပါးတည်း သော ထုံးစံ ရှိ ရကြမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ငါ ပို့ဆောင် သော ပြည် သို့ သင် တို့သည် ရောက် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ထိုပြည် ၌ဖြစ်သော မုန့် ကို စား ကြသောအခါ ၊ ထာဝရဘုရား အား ချီမြှောက် ရာ ပူဇော်သက္ကာကို ဆက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","အဦး နယ်သော မုန့်စိမ်း ဖြင့် လုပ်သော မုန့်ပြား ကို ချီမြှောက် ရာ ပူဇော်သက္ကာပြု၍၊ ကောက်နယ် တလင်း ထဲက ချီမြှောက် ရာ ပူဇော်သက္ကာကို ပြုသကဲ့သို့ ချီမြှောက် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","သင် တို့အမျိုး အစဉ်အဆက်တို့သည်၊ အဦး နယ် သော မုန့်စိမ်း ထဲက ချီမြှောက် ရာ ပူဇော်သက္ကာကိုထာဝရ ဘုရား အား ဆက် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ထာဝရဘုရား သည် မောရှေ ကို မှာထား သော နေ့ မှစ၍ ၊ မောရှေ အားဖြင့် သင် တို့၌ ထား တော်မူသောပညတ်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","သင် တို့အမျိုး အစဉ်အဆက်၌ ထားတော်မူလတံ့သောပညတ် အလုံးစုံ တို့ကို သင်တို့သည် မ စောင့် မှားယွင်း ခြင်းသို့ရောက်ကြသည်အမှုမှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ပရိသတ် အပေါင်းတို့သည် မသိဘဲ သတိလစ် ၍ မှားယွင်း ခြင်းသို့ရောက် လျှင် ၊ ပရိသတ် အပေါင်း တို့သည် ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ ရှိစေခြင်းငှါ၊ ထုံးဖွဲ့ သော ထုံးစံရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာနှင့်တကွ၊ အသက်ပျို သော နွားထီး ဖြင့် မီးရှို့ ရာယဇ်ကို၎င်း ၊ ဆိတ် ဖြင့် အပြစ် ဖြေရာ ယဇ်ကို၎င်းပူဇော် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ယဇ်ပုရောဟိတ် သည်၊ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုရသဖြင့် ၊ သူတို့သည် သတိလစ် ၍ ပြစ်မှားသောကြောင့် ၊ ထိုအပြစ် ကို လွှတ်ရလိမ့်မည်။ သူ တို့သည်လည်း သတိလစ် သော အပြစ်ကြောင့် ၊ အပြစ် ဖြေရာယဇ်နှင့်တကွ၊ မီး ဖြင့်ပြုသောပူဇော်သက္ကာ ကို ထာဝရဘုရား ထံ တော်သို့ ဆောင် ခဲ့ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ထိုသို့ပြုလျှင် ၊ လူ အပေါင်း တို့သည် ပြစ်မှားသော်လည်း၊ သတိလစ် ၍ ပြစ်မှားသောကြောင့် ၊ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း ကို၎င်း ၊ သူ တို့ထံမှာ တည်းခို သော တပါး အမျိုးသားကို၎င်းထိုအပြစ် မှ လွှတ်ရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","လူတစုံတယောက် သည် သတိလစ် ၍ ပြစ်မှား လျှင် ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ အခါမလည် သော ဆိတ်မ တကောင်ကိုဆောင် ခဲ့ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ထာဝရဘုရား ရှေ့ တော်၌ သတိလစ် ၍ ပြစ်မှား မိသော ထိုသူအဘို့ ယဇ်ပုရောဟိတ် သည် အပြစ် ဖြေခြင်း ကို ပြုရသဖြင့် ထိုအပြစ် ကို လွှတ်ရလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ဣသရေလ အမျိုးသား ဖြစ်သောသူ၊ တည်းခို သော တပါး အမျိုးသားဖြစ်သောသူတို့သည် သတိလစ် ၍ ပြစ်မှား သောအခါ၊ တပါးတည်း သော တရား ကို စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","ဣသရေလ အမျိုးသားဖြစ်စေ ၊ တပါး အမျိုးသားဖြစ်စေ ၊ ရဲရင့် စွာပြစ်မှား လျှင် ၊ ထာဝရဘုရား ကို မ ရိုသေရာသို့ ရောက်သည်ဖြစ်၍၊ ထို သူကို သူ ၏အမျိုး မှ ပယ်ရှင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ထာဝရဘုရား ၏စကား တော်ကို မထီမဲ့မြင်ပြု ၍ ပညတ် တော်ကို လွန်ကျူး သောကြောင့် ၊ ထိုသူကို ရှင်းရှင်းပယ်ရှား ရမည်။ မိမိ အပြစ် ကို မိမိခံရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ဣသရေလ အမျိုးသား တို့သည် တော ၌ ရှိ ကြ သောအခါ ၊ တနေ့သောဥပုသ် နေ့ ၌ ထင်းခွေ သောသူ တယောက်ကို တွေ့ လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","တွေ့ သောသူတို့သည်၊ ထိုသူ ကို မောရှေ ၊ အာရုန် ၊ ပရိသတ် အပေါင်း တို့ ရှေ့သို့ ခေါ် ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","သူ ၏အမှုကို စီရင် ရာလမ်းမ ထင်ရှား သေးသောကြောင့် ချုပ် ထားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ထာဝရဘုရား ကလည်း ၊ ထိုသူသည် အသေ သတ်ခြင်းကို အမှန်ခံရမည်။ ပရိသတ် အပေါင်း တို့သည် တပ် ပြင် မှာ သူ့ ကို ကျောက်ခဲ နှင့် ပစ် ရကြမည်ဟု မောရှေ အား မိန့် တော်မူ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ထိုအမိန့် တော်အတိုင်း ပရိသတ် အပေါင်း တို့ သည် ထိုသူကို တပ် ပြင် သို့ ဆောင် သွား၍ ၊ ကျောက်ခဲ နှင့် ပစ် ကြသဖြင့် သူသည် အသေ ခံရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင် သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","သူ တို့အမျိုး အစဉ်အဆက်တို့သည်၊ အဝတ် စွန်း တို့၌ ဆွဲစရာဘို့ ပန်းပွား တို့ကို လုပ် ၍ ၊ ပြာ သော ကြိုး နှင့် ချည် တွဲရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ထိုပန်းပွား တို့ကို သင်တို့သည် ကြည့် မြင်သောအခါ ၊ ထာဝရဘုရား ပညတ် တော်မူသမျှ တို့ကို အောက်မေ့ ၍ ကျင့် ကြမည်အကြောင်း၊ အထက်က ကိုယ် အလို သို့ လိုက်လျက်၊ ကိုယ် ဉာဏ် ကို မှီဝဲလျက် မှားယွင်း သကဲ့သို့မ လိုက် မမှီဝဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ငါ ပညတ် သမျှ တို့ကို အောက်မေ့ ၍ ကျင့် သဖြင့် ၊ သင် တို့ဘုရားသခင် အဘို့ သန့်ရှင်း မည်အကြောင်းထိုသို့ ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ငါသည် သင် တို့၏ ဘုရားသခင် ဖြစ် ခြင်းငှါ ၊ သင် တို့ကို အဲဂုတ္တု ပြည် မှ နှုတ်ဆောင် ခဲ့သော သင် တို့၏ ဘုရားသခင် ထာဝရဘုရား ဖြစ်၏။ ငါ သည် သင် တို့၏ ဘုရားသခင် ထာဝရဘုရား ဖြစ်သည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","လေဝိ အမျိုး ၊ ကောဟတ် သား ဣဇဟာ ၏ သား ကောရ သည်၊ ရုဗင် အမျိုး ဧလျာဘ ၏သား ဒါသန် နှင့် အဘိရံ ၊ ပေလက် ၏သား ဩန တို့ကို ခေါ် ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ပရိသတ် ၌ ကျော်စော ၍ ဂုဏ် အသရေရှိသောသူ၊ အစည်းအဝေး ၌ မင်း ပြုသောသူ၊ ဣသရေလ အမျိုးသား နှစ်ရာ ငါးဆယ် နှင့်တကွ၊ မောရှေ ကို ပုန်ကန် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","မောရှေ နှင့် အာရုန် တဘက် ၌ စုဝေး လျက် ၊ သင်တို့သည် အမှုတော်ကို စောင့်လွန်း၏။ ပရိသတ် ရှိသမျှ အပေါင်း တို့သည် သန့်ရှင်း ကြ၏။ ထာဝရဘုရား သည် သူ တို့တွင် ရှိတော်မူ၏။ သို့ဖြစ်၍ သင်တို့သည် ထာဝရဘုရား ၏ပရိသတ် အပေါ် မှာ အဘယ်ကြောင့် ကိုယ်ကိုကိုယ်ချီးမြှောက် ရသနည်းဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ထိုစကားကို မောရှေ ကြား လျှင် ပြပ်ဝပ် လျက် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","တဖန် မောရှေက၊ အဘယ်သူ သည် ထာဝရ ဘုရား ၏လူဖြစ်သည်ကို၎င်း၊ အဘယ်သူသန့်ရှင်း သည်ကို၎င်း၊ အဘယ်သူကို ချဉ်းကပ် စေမည်ကို၎င်း၊ နက်ဖြန် နေ့၌ ထာဝရဘုရား ပြ တော်မူမည်။ ရွေးကောက် တော်မူသောသူ ကိုလည်း အနီးအပါးသို့ ချဉ်းကပ် စေတော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","အိုကောရ နှင့် ကောရ၏အပေါင်းအသင်း ရှိသမျှ တို့၊ သင် တို့ပြု ရမည်အမှုဟူမူကား၊ လင်ပန်း တို့ကို ယူ ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","နက်ဖြန် နေ့၊ ထာဝရဘုရား ရှေ့ တော်၌ မီး နှင့် လောဗန် ကို တင် ကြလော့။ ထိုအခါ ထာဝရဘုရား ရွေးကောက် တော်မူသော သူသည်၊ သန့်ရှင်း သောသူ ဖြစ် စေ။ အိုလေဝိ သား တို့၊ သင်တို့သည် အမှုတော်ကို စောင့်လွန်းကြသည်ဟု ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","တဖန် မောရှေ က၊ အိုလေဝိ သား တို့၊ နားထောင် ကြပါလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","သင်တို့သည် ထာဝရဘုရား ၏ တဲ တော်အမှု ကို ဆောင်ရွက် ၍၊ ပရိသတ် ရှေ့မှာ ရပ် လျက်၊ သူ တို့အမှု ကို လည်း စောင့်စေမည်အကြံရှိတော်မူသည်နှင့်၊ ဣသရေလ အမျိုး၏ဘုရားသခင် သည်၊ သင် တို့ကို အနီးအပါး သို့ ခေါ်၍ နေရာချခြင်းငှါ၊ ဣသရေလ အမျိုး ပရိသတ် နှင့် ခွဲ ထား၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","သင့် ကို၎င်း ၊ သင့် ညီအစ်ကို လေဝိ သား အပေါင်း တို့ကို၎င်း၊ အနီးအပါး ၌ နေရာချတော်မူသောကျေးဇူးတော်ကို မထီမဲ့မြင်ပြု၍၊ ယဇ်ပုရောဟိတ် အရာကိုလည်း ရှာ ကြသည်တကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ထိုကြောင့် သင် နှင့် သင် ၏အပေါင်းအသင်း ရှိသမျှ တို့ သည် ထာဝရဘုရား တဘက် ၌ စုဝေး ကြပြီ တကား။ အာရုန် ကို အပြစ်တင် ၍ မြည်တမ်းရမည် အကြောင်း ၊ သူ သည်အဘယ်သို့ သောသူဖြစ်သနည်းဟု ကောရ အား ဆို ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ဧလျာဘ သား ဒါသန် နှင့် အဘိရံ တို့ကို ခေါ် ခြင်းငှါ စေလွှတ် လေ၏။ သူတို့ကလည်း ငါတို့မ လာ။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","သင်သည် ဤတော ၌ ငါ တို့ကိုသတ် လို၍ နို့ နှင့် ပျားရည် စီး သော ပြည် မှ ဆောင် ခဲ့သော်လည်း၊ ငါ တို့ အပေါ် ၌ လုံးလုံးမင်း မပြုရလျှင်၊ စိတ်မပြေသေးသည် တကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ထိုမှတပါး နို့ နှင့် ပျားရည် စီး သော ပြည် သို့ ငါ တို့ကို မ ဆောင် ၊ လယ်ယာ များ၊ စပျစ် ဥယျာဉ်များကို မပေး ဘဲ၊ ဤ လူ တို့၏မျက်စိ ကို ဖောက် ချင်သလော။ ငါတို့သည် သင့်ထံသို့မ လာ ဟု ပြန်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","မောရှေ သည် အလွန် အမျက် ထွက်၍ ၊ ဤသူ တို့ ပူဇော်သက္ကာကို ပမာဏ ပြုတော်မ မူပါနှင့်။ သူတို့ဥစ္စာ မြည်း တ ကောင်ကိုမျှ အကျွန်ုပ်မ သိမ်း ပါ။ သူ တို့တွင် တယောက် ကိုမျှ မ ညှဉ်းဆဲ ပါဟု ထာဝရဘုရား အား လျှောက် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ကောရ အား လည်း၊ အာရုန် နှင့် သင် အစရှိသောသင် ၏အပေါင်းအသင်း ရှိသမျှ တို့သည်၊ နက်ဖြန် နေ့ ထာဝရဘုရား ရှေ့ တော်၌ ရှိ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","လူအသီးအသီး တို့သည် မိမိ တို့ လင်ပန်း များကို ယူ ၍ လောဗန် ကို တင် ပြီးမှ ၊ သင် နှင့် အာရုန် သည်လည်း မိမိ တို့ လင်ပန်း ပါလျက်၊ လူအပေါင်းတို့သည် လင်ပန်း နှစ်ရာ ငါးဆယ် တို့ကို ထာဝရဘုရား ရှေ့ တော်သို့ ဆောင် ခဲ့ ကြလော့ဟု ဆို သည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ထိုသူအသီးအသီး တို့သည် မိမိ တို့ လင်ပန်း များ ကို ယူ ၍ မီး နှင့် လောဗန် ကို တင် ပြီးမှ ၊ မောရှေ ၊ အာရုန် နှင့်အတူ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါးဝ ၌ ရပ် နေကြ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ကောရ သည်လည်း၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါးဝ ၌ ပရိသတ် အပေါင်း တို့ကို မောရှေနှင့် အာရုန်တဘက် ၌ စုဝေး စေပြီးမှ ၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် ပရိသတ် အပေါင်း တို့၌ ထင်ရှား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ထာဝရဘုရား ကလည်း ၊ ဤ ပရိသတ် တို့နှင့် ခွာ၍ တခြားစီ နေလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","ငါသည် သူ တို့ကိုချက်ခြင်း ဖျက်ဆီး မည်ဟု မောရှေ နှင့် အာရုန် အားမိန့် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","သူတို့က ပြပ်ဝပ် လျက် ၊ အိုဘုရားသခင် ၊ ခပ်သိမ်း သော သတ္တဝါ တို့၏ အသက် ဝိညာဉ်များကို အစိုးရတော်မူသောဘုရားသခင် ၊ လူ တစ် ယောက်ပြစ်မှား သောအပြစ်ကြောင့် ပရိသတ် အပေါင်း တို့ကို အမျက် ထွက်တော်မူမည်လောဟု လျှောက်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ထာဝရဘုရား ကလည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","ကောရ ၊ ဒါသန် ၊ အဘိရံ တို့၏ တဲ များကို ရှောင် ၍ နေစေခြင်းငှါ၊ ပရိသတ် တို့အား ဆင့်ဆို လော့ဟုမောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","မောရှေ ထ ၍ ဣသရေလ အမျိုး အသက်ကြီး သူတို့ နှင့်တကွ၊ ဒါသန် ၊ အဘိရံ နေရာသို့ သွား ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ဤ လူဆိုး တို့၏နေရာ တဲ များကို ရှောင် ၍ နေကြ ပါလော့။ သူ တို့၏ဥစ္စာတစုံတခု ကိုမျှမ ထိ ကြပါနှင့်။ သို့မဟုတ် သူတို့နှင့်အတူ၊ သူ တို့အပြစ် ကြောင့် ပျက်စီး ခြင်းသို့ ရောက်ကြလိမ့်မည်ဟု ပရိသတ် တို့အား ဆင့်ဆို လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","လူများတို့သည် ကောရ ၊ ဒါသန် ၊ အဘိရံ တဲ ပတ်ဝန်းကျင် ၌မနေဘဲ ရှောင် လွှဲ၍ သွားကြသဖြင့် ၊ ဒါသန် ၊ အဘိရံ သည်၊ သား မယား ကလေး များနှင့်တကွ ထွက် ၍ မိမိ တို့တဲ တံခါးဝ ၌ ရပ် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","မောရှေ ကလည်း ၊ ဤ အမှု အလုံးစုံ တို့ကို ငါသည် အလိုလို မ ပြု၊ ထာဝရဘုရား စေခိုင်း တော်မူ၍ ငါပြု သည် အကြောင်း ကို သင်တို့သည် အဘယ်သို့သိ ရမည်နည်းဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ခပ်သိမ်း သော လူ သတ္တဝါတို့ခံရသောသေ ခြင်း၊ ခပ်သိမ်း သော လူ သတ္တဝါတို့ ခံရသောဆုံးမ ခြင်းကိုသာ ဤလူတို့ ခံရလျှင်၊ ထာဝရဘုရား သည် ငါ့ ကို စေလွှတ် တော်မ မူ။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","သို့မဟုတ် ထာဝရဘုရား သည် အသစ် ဖန်ဆင်း တော်မူသဖြင့် ၊ မြေကြီး ကွဲ ပွင့်လျက် ဤလူတို့ကို၎င်း၊ သူ တို့ နှင့်ဆိုင်သမျှ ကို၎င်း မျို ၍၊ သူတို့သည် အသက်ရှင် လျက် သေမင်း နိုင်ငံသို့ ဆင်း သွားလျှင် ၊ ထာဝရဘုရား ၌ ပြစ်မှား ကြောင်း ကို သင်တို့သည် သိ နားလည်ကြရလိမ့်မည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ပြောဆို ပြီး သည်အဆုံး၌၊ သူတို့နင်းရာ မြေကြီး သည် ကွဲ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","မိမိ ခံတွင်း ကို ဖွင့် သဖြင့် ၊ သူ တို့နှင့် သူ တို့အိမ် များကို၎င်း ၊ ကောရ နှင့် ဆိုင်သမျှ သောသူ တို့ နှင့် သူတို့ ဥစ္စာ ရှိသမျှ ကို၎င်း မျို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ထိုသူ တို့သည် ကိုယ်တိုင်မှစ၍၊ ဆိုင်သမျှ သောသူတို့ နှင့်တကွ ၊ အသက်ရှင် လျက် သေမင်း နိုင်ငံသို့ ဆင်းသက် ၍ ၊ သူ တို့အပေါ် မှာ မြေ စေ့ ပြန်သဖြင့် ၊ သူတို့သည် ပရိသတ် မှ ပယ်ရှင်း ခြင်းကိုခံရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","သူ တို့အော်ဟစ် သံကို ပတ်ဝန်းကျင် ၌ရှိသောဣသရေလ အမျိုးသားတို့သည် ကြားလျှင်၊ ငါ တို့ကိုလည်း မြေ မျို ကောင်းမျိုလိမ့်မည်ဟု စိုးရိမ်လျက် ပြေး ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","နံ့သာပေါင်း ကို မီးရှို့၍ ပူဇော် သောသူ နှစ်ရာ ငါးဆယ် တို့ကိုလည်း၊ ထာဝရဘုရား ထံ တော်က မီး ထွက် ၍ လောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ထာဝရဘုရား ကလည်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","ထိုသန့်ရှင်း သော လင်ပန်း တို့ကို မီးလောင် ရာထဲက ကောက်ယူ ၍မီး ကို ပစ်ချ ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ကိုယ် အသက် ကို သေစေခြင်းငှါပြစ်မှား သောသူတို့ ၏ လင်ပန်း တို့ဖြင့် ယဇ်ပလ္လင် ကို ဖုံးအုပ် စရာ ကြေးဝါ ပြားတို့ကို လုပ် ရမည်အကြောင်း၊ ယဇ်ပုရောဟိတ် အာရုန် ၏သား ဧလာဇာ ကို ဆင့်ဆို လော့။ ထာဝရဘုရား ရှေ့ တော်၌ ပူဇော် သောကြောင့် ၊ ထိုလင်ပန်းတို့သည် သန့်ရှင်း သည်ဖြစ်၍ ၊ ဣသရေလ အမျိုးသား တို့အား နိမိတ် ဖြစ် ရကြမည်ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ယဇ်ပုရောဟိတ် ဧလာဇာ သည်၊ မီးလောင် ခြင်း ကို ခံရသောသူတို့ ပူဇော် သော လင်ပန်း များကို ယူ ၍ ယဇ်ပလ္လင် ကို ဖုံးအုပ် စရာ ကြေးဝါပြားတို့ကို လုပ်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ထိုသို့ အာရုန် အမျိုး မ ဟုတ် အခြား တပါးသော အမျိုးသား သည်၊ ထာဝရဘုရား ရှေ့ တော်၌ နံ့သာပေါင်း ကို မီးရှို့ ၍ ပူဇော်သောအားဖြင့်၊ ကောရ နှင့် သူ ၏ အပေါင်းအသင်း ကဲ့သို့ မ ဖြစ် စေမည်အကြောင်း၊ ထာဝရဘုရား သည် မောရှေ အားဖြင့် မှာထား တော်မူသည် အတိုင်း ၊ ထိုလင်ပန်းတို့သည် ဣသရေလ အမျိုးသား တို့ အား သတိပေး ရာနိမိတ်ဖြစ်ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","နက်ဖြန် နေ့၌ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့က၊ သင်တို့သည် ထာဝရဘုရား ၏လူ တို့ကိုသတ် ကြပြီဟုဆို လျက်၊ မောရှေ နှင့် အာရုန် တို့ကို အပြစ်တင် ၍ မြည်တမ်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ပရိသတ် အပေါင်းတို့သည် မောရှေ နှင့် အာရုန် တဘက် ၌ စုဝေး ကြသောအခါ ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်သို့ မြော်ကြည့် ၍ ၊ မိုဃ်းတိမ် သည် တဲ တော်ကို လွှမ်းမိုး ၍ ၊ ထာဝရဘုရား ၏ဘုန်း တော်သည် ထင်ရှား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","မောရှေ နှင့် အာရုန် တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ သို့ ချဉ်းကပ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ထာဝရဘုရား ကလည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","ဤ ပရိသတ် တို့ကိုရှောင် ၍ နေကြလော့။ ငါသည် သူ တို့ကို ချက်ခြင်း ဖျက်ဆီး မည်ဟု မောရှေ အား မိန့် တော်မူလျှင် ၊ သူတို့သည် ပြပ်ဝပ် လျက် နေကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","မောရှေ ကလည်း ၊ သင်သည် လင်ပန်း ကို ကိုင် ၍ ယဇ်ပလ္လင် ပေါ် က မီး ကို ယူထည့် ပြီးလျှင် ၊ လောဗန် ကိုလည်း တင် လျက် ၊ ပရိသတ် ရှိရာသို့ အလျင်အမြန် သွား ၍ အပြစ် ဖြေခြင်းကို ပြုလော့။ ထာဝရဘုရား ထံ တော်က အမျက် တော်ထွက် ၍ ဘေးဥပဒ် ရောက် လျက် ရှိပြီဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","အာရုန် အား မှာထား သည်အတိုင်း ၊ အာရုန် သည် ယူ ၍ ပရိသတ် ထဲသို့ ပြေး လေ၏။ ထိုအခါ လူ တို့ ၌ ဘေးဥပဒ် ရောက်စ ရှိသည်ဖြစ်၍၊ လောဗန် ကို တင် သဖြင့် လူ များတို့အဘို့ အပြစ် ဖြေခြင်းကို ပြု၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","အသက် ရှင်သောသူ၊ သေ သောသူ စပ်ကြား မှာ ရပ် နေ၍၊ ဘေးဥပဒ် ငြိမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ကောရ အမှု ကြောင့် သေ သောသူတို့ကို ထား၍ ထိုဘေးဥပဒ် ဖြင့် သေ သော လူပေါင်းကား၊ တသောင်း လေးထောင်ခုနစ်ရာရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ထိုဘေးဥပဒ် ငြိမ်း ပြီးမှ ၊ အာရုန် သည် ပရိသတ် စည်းဝေး ရာ တဲ တော်တံခါးဝ ၊ မောရှေ ထံသို့ ပြန်လာ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ အား မိန့် တော်မူသည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ပြီးမှ ၊ ဘိုး ဘအဆွေအမျိုး အလိုက် ဣသရေလဆယ်နှစ် မျိုး၌ မင်း ပြုသောသူအသီးအသီး ပေးရသောလှံတံ ဆယ် နှစ် ချောင်းတို့ကို ယူ၍၊ လူတိုင်းအမည် ကို သူ့ လှံတံ ပေါ်မှာ ရေး ထားလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","လေဝိ အမျိုး၏လှံတံ ပေါ်မှာ အာရုန် အမည် ကို ရေး ထားလော့။ ဘိုး ဘအဆွေအမျိုး သူကြီး တဦးလျှင် လှံတံ တ ချောင်းစီရှိရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ထိုလှံတံတို့ကို ငါဗျာဒိတ် ပေးရာအရပ် ၊ ပရိသတ် စည်းဝေး ရာ တဲ တော်အတွင်း ၊ သက်သေခံ ချက်ရှေ့မှာ တင် ထားလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ငါရွေးကောက် သောသူ ၏ လှံတံ သည် အပွင့် ပွင့် လိမ့်မည်။ ထိုသို့ပြုမှ ဣသရေလ အမျိုးသား တို့သည် သင် ၌ အပြစ်တင် ၍ မြည်တမ်းခြင်းကို နောက်တဖန်ငါနား မငြီးရာဟု မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","မောရှေ သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ၍ ၊ မင်း အပေါင်း တို့သည် ဘိုးဘ အဆွေအမျိုး အလိုက်၊ မင်း တ ဦးလျှင် လှံတံ တချောင်းစီ လှံတံ ဆယ် နှစ် ချောင်းတို့ကိုပေး ကြ၏။ အာရုန် ၏လှံတံ သည် လှံတံ များ ၌ ပါသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","မောရှေ သည် ထိုလှံတံ တို့ကို သက်သေခံ ချက် တဲ တော်အတွင်း ၊ ထာဝရဘုရား ရှေ့ တော်၌ တင် ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","နက်ဖြန် နေ့၌ သက်သေခံ ချက်တဲ တော်အတွင်း သို့ မောရှေ ဝင် သောအခါ ၊ လေဝိ အမျိုးနှင့်ဆိုင်သော အာရုန် ၏လှံတံ သည် အရွက်ထွက် လျက်၊ ငုံ လျက်၊ ပွင့် လျက်၊ ဗာတံ သီးကို သီး လျက်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","မောရှေ သည် လှံတံ ရှိသမျှ တို့ကို ထာဝရဘုရား ထံ တော်က ဣသရေလ အမျိုးသား တို့ ရှေ့သို့ ထုတ်ဆောင် သဖြင့် ၊ သူတို့သည် ကြည့်ရှု ၍ ၊ လူ တိုင်း မိမိ လှံတံ ကို ယူ ပြန် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ထာဝရဘုရား ကလည်း ၊ ပုန်ကန် သောသူတို့ တဘက်၌ သက်သေ ဖြစ်စေခြင်းငှါ၊ အာရုန် ၏ လှံတံ ကို သက်သေခံ ချက်ရှေ့၌ ပြန် ထား၍ အမြဲရှိ စေလော့။ ထိုသို့ သူတို့သည် သေ ဘေးနှင့် လွတ် မည်အကြောင်း ၊ သူ တို့ အပြစ်တင် ၍ မြည်တမ်းခြင်းကို ငါနား မငြီးရာဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","မောရှေ အား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ သည် ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ဣသရေလ အမျိုးသား တို့ကလည်း ၊ အကျွန်ုပ်တို့ သည် သေကြေ ပျက်စီး ကြပါ၏။ တယောက် မျှမကြွင်း ပျက်စီး ရကြပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ထာဝရဘုရား ၏ တဲ တော်ကို ချဉ်းကပ် သောသူ တိုင်း သေ ပါလိမ့်မည်။ အကျွန်ုပ်တို့ ရှိသမျှသည် သေ ဘေးသင့်၍ ဆုံးရှုံး ခြင်းသို့ ရောက်ရကြပါဦးမည်လော ဟု မောရှေ အား လျှောက်ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","တဖန် ထာဝရဘုရား သည် အာရုန် အား မိန့် တော်မူသည်ကား၊ သင် နှင့် သင် ၏သား မြေးအဆွေအမျိုး တို့သည်၊ သန့်ရှင်း ရာဌာနတော်နှင့်ဆိုင်သောအပြစ် ၊ သင် တို့ယဇ်ပုရောဟိတ် အရာနှင့် ဆိုင်သော အပြစ် ကိုခံရ ကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","သင် ၏ ဘိုးဘ အဆွေအမျိုး ၊ လေဝိ အမျိုးသား ညီအစ်ကို ချင်းတို့သည်၊ သင် နှင့်အတူ ကူညီ ၍ အမှု တော်ကို ဆောင်ရွက်စေခြင်းငှါခေါ် ထားလော့။ သို့ရာတွင် သင် နှင့်တကွ သင် ၏သား တို့သည်၊ သက်သေခံ ချက် တဲ တော်ရှေ့မှာ အမှုတော်ကို ဆောင်ရွက်ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","လေဝိသားတို့သည် သင့် ကို၎င်း ၊ တဲ တော်ရှိသမျှ ကို ၎င်းစောင့် ရကြမည်။ သို့ရာတွင်သင် တို့နှင့် သူတို့ သည် သေ ဘေးလွတ် မည်အကြောင်း ၊ သူတို့သည် တဲ တော် တန်ဆာ ၊ ယဇ်ပလ္လင် တန်ဆာများကို မ ချဉ်းကပ် ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","သူတို့သည် သင် တို့နှင့်အတူ ကူညီ ၍ ၊ ပရိသတ် စည်းဝေး ရာ တဲ တော်ကို စောင့် လျက်၊ တဲ တော်အမှု ရှိသမျှ ကို ထမ်းရကြမည်။ မ ဆိုင်သောသူသည် သင် တို့အနီး သို့ မချဉ်းမ ကပ်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","နောက် တဖန် အမျက် တော်ထွက်၍ ဣသရေလ အမျိုးသား တို့အပေါ် သို့ မ ရောက် မည်အကြောင်း ၊ သင်တို့သည် သန့်ရှင်း ရာဌာနတော်နှင့် ယဇ်ပလ္လင် ကို စောင့် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ထိုသို့ သင် တို့၏ ညီအစ်ကို လေဝိ သားတို့ကို၊ ဣသရေလ အမျိုးသား တို့ထဲက ရွေးယူ ၍၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှု ကို ထမ်း စေခြင်းငှါ ၊ ထာဝရဘုရား အား ပြု သောပူဇော်သက္ကာ ကဲ့သို့သင် တို့အား ငါပေး၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ထိုကြောင့် သင် နှင့် သင် ၏သား တို့သည်၊ ယဇ်ပလ္လင် နှင့်ဆိုင်သောအမှု ၊ ကုလားကာ အတွင်း ၌ ဆောင်ရွက် စရာအမှုရှိသမျှ တို့ကို၊ ယဇ်ပုရောဟိတ် ပြု၍ ဆောင်ရွက် ရကြမည်။ သင်တို့အား ကျေးဇူးပြု၍ ယဇ်ပုရောဟိတ် အရာကို ငါပေး ပြီ။ မ ဆိုင်သောသူသည် အနီးအပါး သို့ ချဉ်းကပ်လျှင်၊ အသေ သတ်ခြင်းကိုခံရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","တဖန် ထာဝရဘုရား သည် အာရုန် အား မိန့် တော်မူသည်ကား၊ ဣသရေလ အမျိုးသား တို့သည် သန့်ရှင်း စေ၍ ဆက်ကပ်သမျှ သောပူဇော်သက္ကာတို့အထဲက၊ ငါ့ အား ချီးမြှောက်သော ပူဇော်သက္ကာ တို့ကို သင် ၌ အပ် ၍၊ သင် နှင့် သင် ၏သား တို့အဘို့ ဖြစ်စေခြင်းငှါ၊ ထာဝရ ပညတ် တရားအားဖြင့် ငါပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","မီး သို့မရောက်၊ သန့်ရှင်း သော အရာထဲက သင် တို့ ဆိုင်သောအရာဟူမူကား ၊ ဣသရေလအမျိုးသားလှူ သောဥစ္စာ၊ ဘောဇဉ် ပူဇော်သက္ကာ၊ အပြစ် ဖြေရာယဇ်၊ ဒုစရိုက် ဖြေရာယဇ်ပူဇော်လေသမျှ တို့သည် သင် နှင့် သင် ၏သား တို့အဘို့ သန့်ရှင်း ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","သန့်ရှင်း ရာဌာန၌ စား ရမည်။ ယောက်ျား အပေါင်း တို့သည် စား ရသောအခွင့်ရှိ၏။ သင် တို့အဘို့ သန့်ရှင်း ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ထိုမှတပါး ဣသရေလ အမျိုးသား တို့ ပူဇော်သော ချီမြှောက် ရာ ပူဇော်သက္ကာ၊ ချီလွှဲ ရာ ပူဇော်သက္ကာတို့ကို၊ သင် နှင့် သင် ၏သား သမီး တို့အား ထာဝရ ပညတ် တရားအားဖြင့်ငါပေး ပြီ။ သင့် အိမ် ၌ သန့်ရှင်း သောသူ အပေါင်း တို့သည် စား ရသောအခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ဣသရေလအမျိုးသားရွေး၍ ထာဝရဘုရား အား ပူဇော် သမျှ အကောင်းဆုံး သောဆီ ၊ အကောင်းဆုံး သော စပျစ်ရည် ၊ အကောင်းဆုံးသော ဂျုံ စပါးကို သင် တို့အား ငါပေး ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ထာဝရဘုရား ထံ တော်သို့ ဆောင် ခဲ့သမျှ အဦး မှည့်သော သစ်သီးကိုလည်း သင် ဆိုင် ရ မည်။ သင့် အိမ် ၌ သန့်ရှင်း သော သူအပေါင်း တို့သည် စား ရသောအခွင့် ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ဣသရေလ အမျိုး၌ ကျိန်ဆို ၍ ပူဇော်သမျှ တို့ကိုလည်း သင် ဆိုင် ရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","အဦး ဘွားသောသား၊ လူ ဖြစ်စေ ၊ တိရစ္ဆာန် ဖြစ်စေ၊ ထာဝရဘုရား ထံ တော်သို့ ဆောင် ခဲ့သမျှ တို့ကို သင် ဆိုင် ရ မည်။ သို့ရာတွင် လူ ၏သားဦး နှင့် မ စင်ကြယ်သော တိရစ္ဆာန် ၏သားဦး ကို အမှန်ရွေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ရွေး ရသောသား တို့ကို အသက်တလ လွန်မှ၊ သင်အဘိုး ပြတ်သည်အတိုင်း ဂေရ နှစ်ဆယ် နှင့်မျှသော အကျပ် တော်အလိုက် ငွေ ငါး ကျပ် နှင့် ရွေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","နွား သားဦး ၊ သိုး သားဦး ၊ ဆိတ် သားဦး သည် သန့်ရှင်း သောကြောင့်မ ရွေး ရ။ သူ ၏အသွေး ကို ယဇ်ပလ္လင် ပေါ်မှာ ဖြန်း ရမည်။ ဆီဥ ကိုလည်း ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ ရှိစေ၍၊ မီး ဖြင့် ပူဇော်သက္ကာပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","အသား မူကား ချီလွှဲ ရာပူဇော်သက္ကာ၏ရင်ပတ် နှင့် လက်ျာ ပခုံး ကဲ့သို့ သင့် အဘို့ ဖြစ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ဣသရေလ အမျိုးသား တို့သည် သန့်ရှင်း စေ၍ ထာဝရဘုရား အား ဆောင် ခဲ့သော ပူဇော်သက္ကာ ရှိသမျှ တို့ကို သင် နှင့် သင် ၏ သား သမီး တို့အား ထာဝရ ပညတ် တရားအားဖြင့် ငါပေး ပြီ။ သင် အစရှိသောသင် ၏အမျိုးအနွယ် နှင့်ဆို၍ ထာဝရဘုရား ရှေ့ တော်၌ ဆား နှင့်ယှဉ် သော ထာဝရ ပဋိညာဉ်ဖြစ်သတည်းဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","တဖန် ထာဝရဘုရား သည် အာရုန် အား မိန့် တော်မူသည်ကား၊ ဣသရေလ အမျိုးသားတို့ နေရာပြည် ၌ သင့်အမွေ ခံရာမြေ၊ သူတို့နှင့်ရော ၍ ပိုင်သောအဘို့ မ ရှိ ရ။ ငါ သည်ကား သူ တို့တွင် သင် ပိုင်သောအဘို့ သင့် အမွေ ဥစ္စာဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","လေဝိ သား တို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှု ကို ဆောင်ရွက် သောကြောင့်၊ သူ တို့အမွေခံ စရာ ဣသရေလ အမျိုးသားတို့၏ ဥစ္စာဆယ်ဘို့တဘို့ ကို ငါပေး ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ယခုမှစ၍ဣသရေလ အမျိုးသား တို့သည် ကိုယ်အပြစ် ကိုခံ ၍ သေ ဘေးနှင့် မတွေ့မည်အကြောင်း၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်အနီးအပါးသို့ မ ချဉ်း မကပ် ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","လေဝိ သားတို့သည် ပရိသတ်စည်းဝေး ရာ တဲ တော်အမှု ကို ဆောင်ရွက် ၍ ၊ ကိုယ် အပြစ် ကို ကိုယ်ခံရ ကြမည်။ သူတို့သည် ဣသရေလ အမျိုးသား တို့နှင့် ရော၍ အမွေ မ ခံရ ကြဟု သင် တို့အမျိုး အစဉ်အဆက် စောင့်ရသော ပညတ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ဣသရေလ အမျိုးသား တို့သည် ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြုသော ကိုယ်ဥစ္စာဆယ်ဘို့တဘို့ ကို၊ လေဝိ သားအမွေ ခံစရာဘို့ ငါပေး ပြီ။ ထို့ကြောင့် သူတို့ သည် ဣသရေလ အမျိုးသား တို့နှင့် ရော၍ အမွေ မ ခံရ ဟု ငါ့အမိန့် တော်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","တဖန် မောရှေ အား ထာဝရဘုရား က၊ သင် သည် လေဝိ သားတို့အား ဆင့်ဆို ရမည်မှာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","သင် တို့အမွေခံ စရာ ငါပေး သော ဣသရေလ အမျိုးသား တို့၏ ဥစ္စာဆယ်ဘို့တဘို့ ကို သင်တို့သည် ခံယူ သောအခါ ၊ ထိုအဘို့ကို ဆယ် ဘို့ဘို့ ပြန်၍ တဘို့ကို ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြု ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ထိုပူဇော်သက္ကာ ကို၊ ကောက်နယ် တလင်းထဲက ယူသော ဆန် စပါးကဲ့သို့ ၎င်း ၊ စပျစ်သီး နယ်ရာ ကျင်းထဲက ယူသောစပျစ်ရည်ကဲ့သို့ ၎င်း၊ သင် တို့အဘို့ မှတ် ရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ထိုသို့ သင်တို့သည် ဣသရေလ အမျိုးသား တို့မှ ခံယူ သော ဆယ်ဘို့တဘို့ ထဲက ၊ ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြု ရကြမည်။ ထိုပူဇော်သက္ကာကိုလည်း၊ ယဇ်ပုရောဟိတ် အာရုန် အား လှူ ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","သင် တို့ခံရသမျှ သော အလှူ တို့အထဲ က အကောင်းဆုံး သောအဘို့ သန့်ရှင်း သောအဘို့ကို နှုတ်ယူ၍ထာဝရဘုရား အား ပူဇော်သက္ကာ ပြု ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","သို့ဖြစ်၍ သူ တို့အား ဆင့်ဆို ရမည်မှာ၊ လေဝိ သား တို့သည် အကောင်းဆုံး သောအဘို့ကို နှုတ်ယူပူဇော် ပြီးမှ ၊ ကြွင်းသောအဘို့ကို ကောက်နယ် တလင်း၏ ကျေးဇူး ၊ စပျစ်သီး နယ်ရာကျင်း၏ ကျေးဇူး ကဲ့သို့ မိမိတို့အဘို့ မှတ် ရ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ထိုကြွင်းသောအဘို့ကို၊ ကိုယ်တိုင်မှစ၍အိမ်သူ အိမ်သားတို့သည် စားချင်သောအရပ်ရပ် ၌ စား ရသောအခွင့်ရှိ၏။ ပရိသတ်စည်းဝေး ရာတဲ တော်၌ အမှု စောင့် သောအတွက် ငါချသောဆု ဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","အကောင်းဆုံး သော အဘို့ကို နှုတ်ယူပူဇော် ပြီးမှ ၊ ကြွင်းသောအဘို့အားဖြင့်အပြစ် ရောက် စရာအကြောင်းမ ရှိ။ သေ ဘေးနှင့် မ တွေ့မည်အကြောင်း၊ ဣသရေလ အမျိုးသား တို့၏ သန့်ရှင်း သော အရာတို့ကို မ ညစ်ညူး စေ ရဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","တဖန် ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် တို့ကို ခေါ်၍၊ ထာဝရဘုရား စီရင် ထုံးဖွဲ့တော်မူသော ပညတ် တရားဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","အပြစ် မပါ၊ တခါမျှ ထမ်းဘိုး မတင် ၊ ကွက်ကျား ခြင်းမ ရှိ၊ အဆင်းနီ သော နွားမ ပျိုကို၊ ဣသရေလ အမျိုးသား တို့သည် ဆောင် ခဲ့မည်အကြောင်း ဆင့်ဆို လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ယဇ်ပုရောဟိတ် ဧလာဇာ ၌ အပ် ၍ တပ် ပြင် သို့ ဆောင် သွားပြီးမှ ၊ သူ့ ရှေ့၌ အခြားသူ သတ် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ယဇ်ပုရောဟိတ် ဧလာဇာ သည် အသွေး ကို လက် နှင့်ယူ ၍ ပရိသတ်စည်းဝေး ရာ တဲ တော်ရှေ့ စူးစူး၌ ခုနစ် ကြိမ် ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ယဇ်ပုရောဟိတ် ရှေ့မှာ ထိုနွားမ၏ အရေ ၊ အသား ၊ အသွေး ၊ ချေးနု နှင့်တကွတကောင်လုံးကို အခြား သူသည် မီးရှို့ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ယဇ်ပုရောဟိတ် သည်လည်း အကာရှ သစ်သား ၊ ဟုဿုပ် ပင်ညွန့်နှင့် နီမောင်း သော အထည်ကို ယူ၍၊ နွားမ မီးလောင် ရာထဲသို့ ပစ်ချ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ထိုနောက် မိမိ အဝတ် ကို လျှော် ၍ ကိုယ် ကိုလည်း ရေချိုး ပြီးမှ ၊ တပ် ထဲသို့ ဝင် ၍ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","မီးရှို့ သောသူသည် လည်း ၊ မိမိ အဝတ် ကို လျှော် ၍ ကိုယ် ကိုလည်း ရေချိုး ပြီးမှ ၊ ညဦး တိုင်အောင် မစင်ကြယ် ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","စင်ကြယ် သောသူ တစုံတယောက်သည် နွားမ ၏ ပြာ ကို စုသိမ်း ၍ ၊ တပ် ပြင် မှာ စင်ကြယ် သော အရပ် ၌ ထား ရမည်။ ဣသရေလ အမျိုး ပရိသတ် အဘို့ စင်ကြယ် စေသော ရေဘော် ဘို့၊ ထိုပြာကို သို ထားရမည်။ အပြစ် နှင့် ကင်းစင်စေစရာဘို့ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","နွားမ ၏ပြာ ကို စုသိမ်း သောသူသည်လည်း ၊ မိမိ အဝတ် ကိုလျှော် ၍ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ဤရွေ့ကား၊ ဣသရေလ အမျိုးသား ၊ တည်းခို သော တပါး အမျိုးသားတို့သည် အစဉ်အမြဲ စောင့်ရသောပညတ် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","လူသေကောင် ကို ထိ သောသူသည် ခုနစ် ရက် မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","သုံး ရက်မြောက်သောနေ့ ၌ ထိုပြာနှင့် ကိုယ် ကိုသန့်ရှင်း စေ၍ ၊ ခုနစ် ရက်မြောက်သောနေ့ ၌ စင်ကြယ် လိမ့်မည်။ သုံး ရက်မြောက်သောနေ့ ၌ ကိုယ်ကိုမ သန့်ရှင်း စေ လျှင် ၊ ခုနစ် ရက်မြောက်သောနေ့ တိုင်အောင် မ စင်ကြယ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","လူသေကောင် ကိုထိ ၍ ကိုယ်ကိုမ သန့်ရှင်း စေ သောသူသည်၊ ထာဝရဘုရား ၏ တဲ တော်ကို ညစ်ညူး စေ ၏။ ထိုသူ ကို ဣသရေလ အမျိုးမှ ပယ်ရှင်း ရမည်။ စင်ကြယ် စေသောရေ ဖြန်း ခြင်းကို မ ခံသောကြောင့် မ စင်ကြယ်ဖြစ်၏။ စင်ကြယ် ခြင်းသို့ မရောက်သေး။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","တဲ ၌ လူ သေ လျှင် စောင့်ရသောတရား ဟူမူကား ၊ တဲ သို့ ဝင် သောသူ၊ တဲ ၌ ရှိနေသောသူအပေါင်း တို့သည် ခုနစ် ရက် ပတ်လုံးမ စင်ကြယ်ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","မ ဖုံး ဘဲ ဖွင့် ထားသောအိုး ရှိသမျှ တို့သည်လည်း မ စင်ကြယ်ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","သတ်၍သေ သောသူ၊ နာ၍သေ သောသူ၊ လူ သေ အရိုး ၊ လူသင်္ချိုင်း ကို လယ်ပြင် ၌ တွေ့၍ထိ လျှင်၊ ခုနစ် ရက် ပတ်လုံးမ စင်ကြယ်ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","မ စင်ကြယ်သောသူဘို့ အပြစ် ကင်းစေရာ မီးရှို့ သောနွားမ၏ပြာ အချို့ ကို ယူ ၍ ၊ စီး သောရေ နှင့်အတူအိုး ၌ ထည့် ပြီးမှ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","စင်ကြယ် သောသူသည်၊ ဟုဿုပ် ပင်ညွန့်ကို ရေ ၌ နှစ် ၍ တဲ ပေါ်မှာ ၎င်း၊ တန်ဆာ များ၊ တဲ၌ရှိ သောလူ များပေါ်မှာ ၎င်း၊ လူသေအရိုး ၊ သတ် ၍သေသောသူ၊ နာ ၍သေသောသူ၊ လူသင်္ချိုင်း ကို ထိ သောသူပေါ်မှာ ၎င်း၊ ထိုရေကို ဖြန်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","စင်ကြယ် သောသူသည် မ စင်ကြယ်သောသူကို သုံး ရက်မြောက်သောနေ့ ၊ ခုနစ် ရက်မြောက်သောနေ့ ၌ ဖြန်း ရမည်။ ခုနစ် ရက်မြောက်သောနေ့ ၌ ကိုယ်ကိုသန့်ရှင်း စေ လျက် ၊ မိမိ အဝတ် ကို လျှော် ၍ ရေချိုး လျှင် ၊ ညဦး အချိန် တွင် စင်ကြယ် လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","မ စင်ကြယ်သော သူ သည် ကိုယ်ကိုသန့်ရှင်း စေခြင်းငှါမ ပြုလျှင် ၊ ထာဝရဘုရား ၏ သန့်ရှင်း ရာဌာန တော်ကို ညစ်ညူး စေသောကြောင့် ၊ ပရိသတ် မှ ပယ်ရှင်း ခြင်းကိုခံရမည်။ စင်ကြယ် စေသော ရေ ဖြန်း ခြင်းကို မ ခံသောကြောင့်၊ မ စင်ကြယ်ဘဲနေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","အစဉ်အမြဲ စောင့်ရသောပညတ် ဟူမူကား ၊ စင်ကြယ် သော ရေ ကို ဖြန်း သောသူသည် မိမိ အဝတ် ကို လျှော် ရမည်။ ထိုရေ ကို ထိ သောသူလည်း ၊ ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","မ စင်ကြယ်သောသူ ထိ သမျှ သော အရာသည် လည်း မ စင်ကြယ်ဖြစ်လိမ့်မည်။ ထိုအရာကို ထိ သောသူ လည်း ညဦး တိုင်အောင် မ စင်ကြယ်ဖြစ်လိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","သက္ကရာဇ်လေးဆယ်၊ ပဌမ လ ၌ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့သည်၊ ဇိန တော သို့ ရောက် ၍ ၊ ကာဒေရှ အရပ်၌ နေ ကြ၏။ ထို အရပ်၌ မိရိအံ သေ ၍ သင်္ဂြိုဟ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ပရိသတ် တို့သောက်စရာ ရေ မ ရှိ သောကြောင့် ၊ မောရှေ နှင့် အာရုန် တဘက် ၌ စုဝေး ကြလျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ထာဝရဘုရား ရှေ့မှာ ငါ တို့အစ်ကို များသေ သောအခါ ၊ ငါတို့လည်း မသေ ပါလေ။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ငါ တို့နှင့် ငါ တို့တိရစ္ဆာန် များကို သေ စေခြင်းငှါ ၊ ထာဝရဘုရား ၏ပရိသတ် ကို ဤ တော သို့ အဘယ်ကြောင့် ဆောင် ခဲ့သနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ငါ တို့ကို အဲဂုတ္တု ပြည်မှ ထွက် စေ၍၊ ဤ ဆိုး သော အရပ် သို့ အဘယ်ကြောင့် ဆောင် ခဲ့သနည်း။ ဤအရပ် သည် လယ် လုပ်စရာမ ကောင်း၊ သင်္ဘောသဖန်း ပင်၊ စပျစ်နွယ် ပင်၊ သလဲ ပင်စိုက်စရာမကောင်း။ သောက် စရာရေ မျှ မ ရှိဟု မောရှေ ကို အပြစ်တင် ၍ ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","မောရှေ နှင့် အာရုန် တို့သည် လူ အစုအဝေးမှ ထွက် ၍၊ ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါးဝ သို့ သွား သဖြင့် ၊ ပြပ်ဝပ် လျက် နေကြစဉ်၊ ထာဝရဘုရား ၏ ဘုန်း တော်သည် ထင်ရှား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ထာဝရဘုရား ကလည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","လှံတံတော် ကို ကိုင် ယူ၍ သင် ၏အစ်ကို အာရုန် ပါလျက်၊ ပရိသတ် များကို စုဝေး စေလော့။ သူ တို့ရှေ့မှာ ကျောက် ကိုမှာထား လော့။ ကျောက်သည် မိမိ ရေ ကိုပေး လိမ့်မည်။ ထိုသို့ သင်သည် ကျောက် ထဲက ရေ ကို ထွက် စေ၍ ၊ ပရိသတ် များနှင့် သူ တို့တိရစ္ဆာန် များတို့အား သောက် ဘို့ ရေကို ပေးရမည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","မောရှေ အား မိန့် တော်မူသည်အတိုင်း ၊ မောရှေ သည် လှံတံတော် ကို ထာဝရဘုရား ရှေ့ တော်က ယူ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","အာရုန် ပါလျက်၊ ပရိသတ် တို့ကို ကျောက် ရှေ့မှာ စုဝေး စေပြီးလျှင် ၊ အချင်းသူပုန် တို့၊ နားထောင် ကြလော့။ ငါတို့သည် သင် တို့အဘို့ ဤ ကျောက် ထဲက ရေ ကို ထွက် စေ ရမည်လောဟု ဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","မိမိ လက် ကို ဆန့် ၍ ကျောက် ကို လှံတံ နှင့် နှစ် ကြိမ်ရိုက် သဖြင့် ၊ ရေ သည် များစွာ ထွက် ၍ ၊ လူ ပရိသတ် တို့နှင့် တိရစ္ဆာန် တို့သည် သောက် ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ထာဝရဘုရား ကလည်း ၊ သင်တို့သည် ငါ့ ကို မ ယုံကြည် ၊ ဣသရေလ အမျိုးသား တို့ရှေ့မှာ ငါ့ ကိုမရိုမသေ ပြုသောကြောင့် ၊ ဤ ပရိသတ် တို့အား ငါပေး သော ပြည် သို့ သင်တို့သည် ပို့ဆောင် သောအခွင့်ကို မ ရကြဟု မောရှေ နှင့် အာရုန် တို့အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ဣသရေလ အမျိုးသား တို့သည် ထာဝရဘုရား ကို ဆန့်ကျင်ဘက် ပြုသော်လည်း ၊ သူ တို့တွင် ရိုသေ လေးမြတ်ခြင်းကိုခံ တော်မူသောကြောင့်၊ ထို ရေသည် မေရိဘ ရေ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","မောရှေ သည် ကာဒေရှ အရပ်မှ ဧဒုံ ရှင်ဘုရင် ထံသို့ သံတမန် တို့ကို စေလွှတ် ၍၊ ကိုယ်တော့် ညီ ဣသရေလ က၊ အကျွန်ုပ် တို့ တွေ့ ရသော အမှု အလုံးစုံ တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","အကျွန်ုပ် တို့ဘိုးဘေး သည် အဲဂုတ္တု ပြည်သို့ သွား ၍ အကျွန်ုပ်တို့ သည်အဲဂုတ္တု ပြည် မှာ ကာလ ကြာမြင့် စွာနေ သဖြင့် ၊ အဲဂုတ္တု လူတို့သည် အကျွန်ုပ် တို့နှင့် ဘိုးဘေး များကို ညှဉ်းဆဲ ကြောင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","အကျွန်ုပ်တို့သည် ထာဝရဘုရား ကို အော်ဟစ် သောအခါ ၊ ကောင်းကင်တမန် ကို စေလွှတ် ၍ ၊ အကျွန်ုပ် တို့ကို အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူကြောင်းကို ကိုယ်တော်သိ ပါ၏။ ယခု မှာ အကျွန်ုပ် တို့သည် ကိုယ်တော် ၏ နိုင်ငံ အစွန်အနား ၊ ကာဒေရှ အရပ်၌ ရှိကြပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ကိုယ်တော့် ပြည် အလယ် ၌ရှောက် ၍ သွားပါရစေ။ လယ်ယာ များ၊ စပျစ် ဥယျာဉ်များကို မ နင်း ပါ။ တွင်း ရေ ကိုလည်း မ သောက် ပါ။ ကိုယ်တော့် ပြည်နယ် ကို မ လွန် မှီတိုင်အောင်၊ လက်ျာ ဘက်၊ လက်ဝဲ ဘက်သို့ မ လွှဲ ၊ မင်း လမ်း သို့သာ ရှောက် လိုက်ပါမည်ဟု တောင်းပန်စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ဧဒုံ ကလည်း ၊ သင်သည် ငါ့ ပြည်အလယ် ၌ မ ရှောက် မသွားရ။ ရှောက်သွားလျှင်၊ ထား လက်နက်နှင့် ဆီးတား မည်ဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ဣသရေလ အမျိုးသား တို့ကလည်း ၊ မင်း လမ်းသို့ သာ ရှောက် လိုက်ပါမည်။ ကိုယ်တိုင် မှစ၍တိရစ္ဆာန် တို့ သည် ကိုယ်တော့် ရေ ကို သောက် လျှင် အဘိုး ကိုပေး ပါမည်။ အခြားသောအမှု ကို မ ပြုဘဲ၊ ခြေ ဖြင့် သွား ရုံမျှသာ ပြုပါမည်ဟု ဆို သော်လည်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ဧဒုံ က၊ သင်သည် ရှောက် ၍မ သွားရဟုဆို လျက် ၊ များစွာ သော ဗိုလ်ခြေ အလုံးအရင်း နှင့်တကွဆီးတား ခြင်းငှါ ထွက်လာ ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ထိုသို့ ဧဒုံ သည် သူ ၏ပြည် အလယ် ၌ရှောက်သွား သော အခွင့်ကို ဣသရေလ အား မ ပေး သောကြောင့် ၊ ဣသရေလ သည် လွှဲရှောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ သည် ကာဒေရှ အရပ်မှ ပြောင်း ၍ ဟောရ တောင် သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ဧဒုံ ပြည် စွန် နား၊ ဟောရ တောင် ပေါ်မှာ ထာဝရဘုရား သည် မောရှေ နှင့် အာရုန် တို့ကို ခေါ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","သင်တို့သည် မေရိဘ စမ်းရေ နားမှာ ငါ့ စကား ကို ဆန့်ကျင် သောကြောင့် ၊ ဣသရေလ အမျိုးသား တို့အား ငါပေး သော ပြည် သို့ အာရုန် သည် မ ဝင် ရ။ မိမိ လူမျိုး စည်းဝေး ရာသို့ သွားရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","သို့ဖြစ်၍အာရုန် နှင့် သူ ၏သား ဧလာဇာ ကို ခေါ် ၍ ဟောရ တောင် ပေါ်သို့ဆောင် သွားပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","အာရုန် ၏အဝတ် ကို ချွတ် ၍ သူ ၏သား ဧလာဇာ ကို ဝတ် စေပြီးမှ ၊ အာရုန် သည် ထို အရပ်၌သေ ၍ မိမိလူမျိုးစည်းဝေး ရာသို့ သွားရမည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","မိန့် တော်မူသည်အတိုင်း ၊ မောရှေ ပြု ၍ ၊ သူတို့ သည် ပရိသတ် အပေါင်း တို့ရှေ့မှာ ဟောရ တောင် ပေါ်သို့ တက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","မောရှေ သည် အာရုန် ၏အဝတ် ကို ချွတ် ၍ သား ဧလာဇာ ကို ဝတ် စေပြီးမှ ၊ အာရုန် သည် တောင် ထိပ် ၌ သေ လေ၏။ မောရှေ နှင့် ဧလာဇာ တို့သည် တောင် ပေါ်က ဆင်းလာ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","အာရုန် သည် အနိစ္စ ရောက်ကြောင်း ကို ပရိသတ် အပေါင်း တို့သည် သိမြင် သောအခါ ၊ ဣသရေလ အမျိုးသား ရှိသမျှ တို့သည်၊ အာရုန် အတွက် အရက် သုံးဆယ် ပတ်လုံး ငိုကြွေး မြည်တမ်းခြင်းကို ပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ဣသရေလ အမျိုးသည် အသရိမ် လမ်း ဖြင့် လာ ကြသည်သိတင်းကို တောင် မျက်နှာ၌နေ သောခါနာန် အမျိုး အာရဒ် မင်းကြီး ကြား လျှင် ၊ ဣသရေလ အမျိုးကို စစ်တိုက် ၍ လူအချို့ တို့ကို ဘမ်းဆီး သိမ်းသွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ဣသရေလ အမျိုးကလည်း ၊ ကိုယ်တော်သည် ဤ လူမျိုး ကို အကျွန်ုပ် တို့လက် သို့ အပ် တော်မူလျှင် ၊ သူ တို့ မြို့ များကို ရှင်းရှင်းဖျက်ဆီး ပါမည်ဟု ထာဝရဘုရား အား သစ္စာ ဂတိပြုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ထာဝရဘုရား သည်လည်း ၊ ဣသရေလ အမျိုး၏ စကား ကို နားထောင် ၍ ၊ ထိုခါနာန် အမျိုးသားတို့ကိုအပ် တော်မူ၏။ သူ တို့နှင့် သူ တို့မြို့ များကို ဣသရေလလူတို့သည် ရှင်းရှင်းဖျက်ဆီး ၍၊ ထိုအရပ် ကို ဟော်မာ အမည် ဖြင့် သမုတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ဟောရ တောင် မှ ထွက် ၍ ဧဒုံ ပြည် ကို ဝိုင်း ခြင်းငှါ ၊ ဧဒုံ ပင်လယ် လမ်း ဖြင့် ချီသွားကြစဉ်၊ အသွား ခက်သောကြောင့် ၊ လူ များတို့သည် စိတ် အားလျော့ ကြ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","သင်သည် ငါတို့ကို ဤတော ၌ သေ စေခြင်းငှါ ၊ အဲဂုတ္တု ပြည်မှ အဘယ်ကြောင့် ဆောင် ခဲ့သနည်း။ မုန့် မ ရှိ၊ ရေ လည်း မ ရှိ၊ ဤပေါ့ပျက် သောစားစရာ ကိုလည်း ငါ တို့သည် အလွန်ရွံရှာ ၏ဟု ဘုရားသခင် နှင့် မောရှေ ကို ဆန့်ကျင်ဘက် ပြု၍ ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ထိုအခါ ထာဝရဘုရား သည်၊ ဣသရေလအမျိုးသား တို့တွင် မီး မြွေ များကို စေလွှတ် တော်မူ၍ ၊ လူ အများ တို့သည် အကိုက် ခံရသဖြင့် သေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ထိုကြောင့် လူ များတို့သည် မောရှေ ထံသို့ လာ ၍ အကျွန်ုပ်တို့သည် ထာဝရဘုရား နှင့် ကိုယ်တော် ကို ဆန့်ကျင် လျက် ပြောဆို၍ ပြစ်မှား ပါပြီ။ ထာဝရဘုရားသည် မြွေ များကို အကျွန်ုပ် တို့မှ ပယ်ရှား တော်မူမည်အကြောင်းဆုတောင်း ပါဟု လျှောက်လျှင်၊ မောရှေ သည် လူ များအဘို့ ဆုတောင်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ထာဝရဘုရား ကလည်း ၊ မီးမြွေ ရုပ်ကိုလုပ် ၍ တိုင် ပေါ်မှာ မြှောက် ထားလော့။ အကိုက် ခံရသောသူ တိုင်း ကြည့်ရှု လျှင် အသက် ချမ်းသာရလိမ့်မည်ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","မောရှေ သည် ကြေးဝါ ဖြင့် မြွေ ကို လုပ် ၍ တိုင် ပေါ်မှာ မြှောက်ချီ ထားပြီးလျှင် ၊ မြွေ ကိုက် သောသူမည်သည်ကား၊ ကြေးဝါ မြွေ ကို ကြည့်ရှု သောအခါ အသက် ချမ်းသာရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","တဖန် ဣသရေလ အမျိုးသား တို့သည် နေရာ ပြောင်း၍ ဩဗုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ဩဗုတ် အရပ်မှ ပြောင်း ပြန်၍ ၊ နေ ထွက် ရာ ဘက် ၊ မောဘ ပြည်ရှေ့ တွင်ရှိသောတော မှာ ၊ ဣဇာဗာရိမ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ထို အရပ်မှ ပြောင်း ၍ ၊ ဇာရက် ချောင်း နား ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ထို အရပ်မှ တဖန်ပြောင်း ပြန်၍ ၊ အာမောရိ ပြည်နယ် နှင့် စပ်သော တော ၌ ရှိသောအာနုန် ချောင်းနား တဘက်တချက် ၌ စားခန်းချ ကြ၏။ အာနုန် ချောင်းကား၊ မောဘ ပြည်၊ အာမောရိ ပြည်စပ်ကြား အပိုင်းအခြား ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ထိုသို့နှင့်အညီ၊ ထာဝရဘုရား စစ်တိုက် စာ ၌ ကား၊ ဇာရက် အရပ်၊ သုပ အရပ်၊ အာနုန် ချောင်း တို့၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","အာရ ပြည်သို့ စီး ၍ မောဘ ပြည်အနား ၌ ရှောက်သွားသော ချောင်း အသွယ်သွယ်ဟု လာသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","အာနုန်ချောင်းမှ ဗေရ ရေတွင်းသို့ ခရီးသွားကြ၏။ ထိုရေတွင်းကား အခြားမဟုတ်၊ ထာဝရဘုရား က၊ လူ များကို စုဝေး စေလော့၊ ရေ ကို ငါပေး မည်ဟု မောရှေ အား မိန့် တော်မူရာ၌ ရည်ဆောင်သော ရေတွင်း ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ထိုအခါ ဣသရေလ အမျိုးက၊ အိုတွင်း ရေ၊ ထွက် လော့။ ထွက်အောင် သီချင်း ဆိုကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","တရားမင်းစီရင်သည်အတိုင်း၊ မှူးမတ် တို့သည် ရေတွင်း ကို တူး ကြပြီ။ လူ တို့တွင် အကဲအမှူး တို့သည် တောင်ဝေး တို့နှင့် ရေတွင်းကို တူး ကြပြီဟု သီချင်း ဆိုလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ထိုတော မှ မတ္တနာအရပ်သို့၎င်း၊ မတ္တနာ အရပ်မှ နဟာလျေလ အရပ်သို့၎င်း ၊ နဟာလျေလ အရပ်မှ ဗာမုတ် အရပ်သို့၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ဗာမုတ် အရပ်မှ မောဘ ချိုင့် သို့ ၎င်း၊ ယေရှိမုန် မြို့ကို မျက်နှာပြု သော ပိသဂါ တောင်ထိပ် သို့၎င်း ခရီးသွားကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ထိုအခါ ဣသရေလ အမျိုးသားတို့သည်၊ အာမောရိ ရှင်ဘုရင် ရှိဟုန် မင်းထံသို့ သံတမန် တို့ကို စေလွှတ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","အကျွန်ုပ်တို့သည် မင်းကြီးပြည် အလယ် ၌ ရှောက် ၍ သွားပါရစေ။ လယ်ယာ သို့ ၎င်း ၊ စပျစ် ဥယျာဉ် သို့ ၎င်း မ ဝင် ပါ။ တွင်း ရေ ကိုလည်း မ သောက် ပါ။ မင်းကြီးပြည် ကို မ လွန် မှီတိုင်အောင်၊ မင်း လမ်း သို့သာ ရှောက် လိုက်ပါမည်ဟု အခွင့်တောင်းကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ထိုပြည် အလယ် ၌ ရှောက်သွား ရသောအခွင့်ကို၊ ရှိဟုန် မင်းသည် ဣသရေလ အမျိုးသားတို့အား မ ပေး။ မိမိ လူ အပေါင်း တို့ကို စုဝေး စေ၍ ၊ ဣသရေလ အမျိုးသားတို့ကို ဆီးတား ခြင်းငှါ ၊ သူတို့ရှိရာတော သို့ ထွက် ၍ ယာဟတ် မြို့သို့ ရောက် ပြီးလျှင် စစ်တိုက် ");
INSERT INTO myajvb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ထိုမင်းကို၊ ဣသရေလ အမျိုးသားတို့သည် ထား နှင့် လုပ်ကြံ ၍၊ အာနုန် ချောင်းမှ သည် ယဗ္ဗုတ် ချောင်း တိုင်အောင် ၎င်း၊ အမ္မုန် အမျိုးသား နေရာတိုင်အောင် ၎င်း၊ ထိုမင်းပိုင်သော မြေ ကို သိမ်းယူ ကြ၏။ အမ္မုန် အမျိုးသား နေရာ နယ်စပ် ကား အားကြီး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ထိုသို့ ဣသရေလ အမျိုးသားတို့သည်၊ ဟေရှဘုန် မြို့မှစ၍အာမောရိ အမျိုးသားနေသောမြို့ ရွာ ရှိသမျှ တို့ကို သိမ်းယူ ၍ နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ဟေရှဘုန် မြို့ကား၊ မောဘ ပြည်ကို အစိုးရသောအရင် ရှင်ဘုရင် နှင့် စစ်တိုက် ၍ အာနုန် ချောင်းတိုင်အောင် ပြည် ကို လုယူ သော အာမောရိ ရှင်ဘုရင် ရှိဟုန် မင်းနေသောမြို့ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ထိုအကြောင်းကို ရည်ဆောင်၍ လင်္ကာ ဆရာတို့ က၊ ဟေရှဘုန် မြို့သို့ သွား ၍ တဖန်တည် ကြစို့။ ရှိဟုန် ဘုရင်နေသောမြို့ ကို ပြင်ဆင် ကြစို့။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ရှိဟုန်ဘုရင်နေရာ ဟေရှဘုန် မြို့မှ မီးလျှံ ထွက် ၍ မောဘ ပြည်အာရ မြို့နှင့်တကွ၊ အာနုန် ချောင်းနား၊ မြင့် သောအရပ်၌ အစိုးရ သောမင်းတို့ကို လောင် လေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","အိုမောဘ ပြည်၊ သင် သည် အမင်္ဂလာ ရှိ၏။ အိုခေမုရှ တပည့် တို့၊ သင်တို့သည် အကျိုး နည်းကြပြီ။ ပြေး ရသောမိမိ သား သမီး တို့ကို အာမောရိ ရှင်ဘုရင် ရှိဟုန် လက် သို့ ရောက်စေခြင်းငှါ၊ ထိုဘုရားသည် အခွင့်ပေး ပြီ တကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","တဖန် ငါတို့သည် အာမောရိသားတို့ကို တိုက် ပြန်သောကြောင့်၊ ဟေရှဘုန် ပြည်သည် ဒိဘုန် မြို့တိုင်အောင် ပျက် လေပြီ။ မေဒဘ မြို့နှင့် နီးစပ်သော နောဖာ မြို့တိုင်အောင် သူတို့ကို သုတ်သင် ပယ်ရှင်းကြပြီဟု ဆိုသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ထိုသို့ ဣသရေလ အမျိုးသားတို့သည် အာမောရိ ပြည် ၌ နေ ရကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","မောရှေ သည်လည်း ၊ ယာဇာ မြို့ကို စူးစမ်း ခြင်းငှါ လူကို စေလွှတ် ပြီးလျှင် ၊ ထိုမြို့ ရွာတို့ကို သိမ်းယူ ၍ ၊ အရင် နေသောအာမောရိ အမျိုးသားတို့ကို နှင်ထုတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","တဖန် ဣသရေလအမျိုးသားတို့သည် လှည့် ၍၊ ဗာရှန် ပြည်သို့ ခရီး သွား ကြ၏။ ဗာရှန် ရှင်ဘုရင် ဩဃ သည်၊ မိမိ လူ အပေါင်း တို့နှင့် ဧဒြိ အရပ်မှာ စစ်တိုက် ခြင်းငှါချီ သွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ထာဝရဘုရား ကလည်း ၊ သူ့ ကို မ ကြောက် နှင့်။ သူ နှင့်တကွ သူ ၏လူ အပေါင်း ကို၎င်း၊ သူ ၏မြေ ကို၎င်း၊ သင့် လက် ၌ ငါအပ်ပေး ပြီ။ ဟေရှဘုန် မြို့နေ အာမောရိ ရှင်ဘုရင် ရှိဟုန် ကို ပြု သကဲ့သို့ ၊ ဤမင်းကိုလည်း ပြု ရမည် ဟု မောရှေ အား မိန့် တော်မူသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ထိုမင်း နှင့် သား များ၊ လူ များအပေါင်း တို့ကို တယောက်မျှ မ ကြွင်း လုပ်ကြံ ၍ သူ ၏ပြည် ကို သိမ်းယူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","တဖန် ဣသရေလ အမျိုးသား တို့သည် ခရီးသွား ၍ မောဘ လွင်ပြင် ၊ ယော်ဒန် မြစ်နား ၊ ယေရိခေါ မြို့ တဘက် ၌ တဲ ဆောက်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","အာမောရိ အမျိုးသားတို့၌ ပြု ကြသော အမှုအလုံးစုံ ကို၊ ဇိဖေါ် သား ဗာလက် မင်းသိမြင် လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ဣသရေလ အမျိုးသား တို့သည် များပြား သောကြောင့် ၊ မောဘ ပြည်သားတို့သည် အလွန် ကြောက်ရွံ့ ကြ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","နွား သည် မြက်ပင် ကို လှမ်း ၍ စားသကဲ့သို့ ဤအလုံးအရင်း သည် ငါ တို့ပတ်လည် ၌ ရှိသမျှ ကို လှမ်း ၍ စားလိမ့်မည်ဟု ပူပန်သောစိတ်ရှိလျက်၊ မိဒျန် ပြည်သားအသက်ကြီး သူတို့အား ဆို ကြ၏။ ထို အခါ ဇိဖေါ် သား ဗာလက် သည်၊ မောဘ ရှင်ဘုရင် ဖြစ်သည်နှင့်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","အမ္မုန်ပြည်၌ စီးသောမြစ် ၏အနား မှာရှိသော ပေသော် မြို့နေ ဗောရ သား ဗာလမ် ကို ခေါ်ပင့် ခြင်းငှါ ၊ သံတမန် တို့ကို စေလွှတ် ၍၊ အဲဂုတ္တု ပြည်မှ ရောက်လာ သော လူ တမျိုးသည် မြေ မျက်နှာ ကို ဖုံးလွှမ်း လျက် ငါ့ အနား ၌ နေရာ ချကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","သို့ဖြစ်၍ ၊ ကြွလာ ပါ။ ဤ လူမျိုး သည် ငါ့ ထက် အားကြီး သောကြောင့် သူတို့ကို ငါ့ အဘို့ ကျိန်ဆဲ ပါ။ သို့ပြုလျှင် သူ တို့ကို ငါတိုက် ၍ ငါ့ပြည် မှ နှင်ထုတ် နိုင် ကောင်း နှင်ထုတ်နိုင်လိမ့်မည်။ ကိုယ်တော်ကောင်းကြီး ပေးသောသူ သည် ကောင်းကြီး မင်္ဂလာခံရသည်ကို၎င်း ၊ ကိုယ်တော်ကျိန်ဆဲ သောသူ သည် ကျိန်ဆဲ အပ်သောသူဖြစ်သည်ကို၎င်းငါသိ သည်ဟု မှာလိုက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","မောဘ ပြည်သားအသက်ကြီး သူတို့နှင့် မိဒျန် ပြည်သားအသက်ကြီး သူတို့သည် ပြုစား ခြင်းလက်ဆောင်ပါလျက်သွား ၍ ၊ ဗာလမ် ထံသို့ ရောက် သောအခါ ၊ ဗာလက် မင်းစကား ကို ကြားလျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ဗာလမ်က၊ ယနေ့ည မှာ ဤ အရပ်၌နေ ကြပါဦး။ ထာဝရဘုရား မိန့် တော်မူသည်အတိုင်း ငါပြန် ပြောမည်ဟု ဆို လျှင် ၊ မောဘ အရာရှိ တို့သည် ဗာလမ် ထံမှာ နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ဘုရားသခင် သည် ဗာလမ် ရှိရာသို့ လာ ၍ ၊ သင် ၌ ရှိသောဤ လူ တို့သည် အဘယ်သူ နည်းဟုမေး တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ဗာလမ် က၊ မောဘ ရှင်ဘုရင် ဇိဖေါ် သား ဗာလက် သည် အကျွန်ုပ် ဆီသို့ လူကို စေလွှတ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","အဲဂုတ္တု ပြည်မှ ရောက်လာ သောလူ အများ သည်၊ မြေ မျက်နှာ ကို ဖုံးလွှမ်း လျက်နေကြပြီ။ သို့ဖြစ်၍ကြွလာ ပါ။ ဤလူမျိုးကို ငါ့ အဘို့ ကျိန်ဆဲ ပါ။ သို့ပြုလျှင်၊ သူ တို့ကို ငါတိုက် ၍ နှင်ထုတ် နိုင် ကောင်းနှင်ထုတ်နိုင်လိမ့်မည် ဟု ခေါ်ပင့်ကြောင်းကို၊ ဘုရားသခင် အား လျှောက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ဘုရားသခင် ကလည်း၊ သင်သည် ဤလူ တို့နှင့်အတူ မ လိုက် မသွားရ။ ထိုလူမျိုး ကို မ ကျိန်ဆဲ ရ။ ကောင်းကြီး မင်္ဂလာကို ခံရသောလူမျိုးဖြစ်သည်ဟု ဗာလမ် အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","နံနက် ရောက်မှ၊ ဗာလမ် သည် ထ ၍ သင်တို့သည် ကိုယ် ပြည် သို့ ပြန်သွား ကြပါလော့။ သင် တို့နှင့်အတူ ငါလိုက်ရသောအခွင့် ကို ထာဝရဘုရား ပေးတော်မ မူဟု ဗာလက် မင်းစေလွှတ်သော အရာရှိ တို့အား ပြန်ပြော လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ထိုအခါ မောဘ ပြည်အရာရှိ တို့သည် ဗာလက် မင်းထံသို့ ပြန် သွား၍ ၊ ဗာလမ် သည် ကျွန်တော် တို့နှင့်အတူ မ လိုက် လိုပါဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","တဖန် ဗာလက် မင်းသည်၊ အရင်ထက် အရေအတွက်အားဖြင့်များ ၍ အရာအားဖြင့် ဘုန်းကြီး သော မှူးမတ် တို့ကို စေလွှတ် ပြန် သည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","သူတို့သည် ဗာလမ် ထံသို့ ရောက်လာ ၍ ဇိဖေါ် သား ဗာလက် မင်းက၊ ကိုယ်တော်သည် ငါ့ ထံသို့ မလာ မည် အကြောင်းအဘယ်အဆီးအတား မျှ မရှိပါစေနှင့်။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ငါသည် ကိုယ်တော် ကို အလွန် ချီးမြှောက် မည်။ ကိုယ်တော်တောင်း သမျှ ကို ပေး မည်။ သို့ဖြစ်၍ ကြွလာ ပါ။ ဤ လူမျိုး ကို ငါ့ အဘို့ ကျိန်ဆဲ ပါဟု မိန့် တော်မူကြောင်းကို ပြန်ပြော ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ဗာလမ် ကလည်း၊ ဗာလက် မင်းသည် ရွှေ ငွေ နှင့် ပြည့် သော မိမိ နန်း တော်ကိုပင် ပေး သော်လည်း ၊ ငါကိုးကွယ်သော ဘုရားသခင် ထာဝရဘုရား ၏ စကား တော်ကို လွန်ကျူး ၍ အမှုအကြီး အငယ် တစုံတခုကိုမျှ ငါမ ပြု နိုင်။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","သို့ရာတွင် ထာဝရဘုရား သည် အဘယ်သို့ ထပ်၍ မိန့် တော်မူမည်ကို ငါသိ မည်အကြောင်း၊ ယနေ့ည မှာ ဤ အရပ်၌ နေ ကြပါဦးဟု ဗာလက် မင်းကျွန် တို့အား ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ည အချိန်၌ ဘုရားသခင် သည် ဗာလမ် ရှိရာသို့ လာ ၍၊ ထိုလူ တို့သည် သင့် ကိုခေါ် ခြင်းငှါ လာ လျှင် ၊ သူ တို့ နှင့်အတူ ထ ၍ လိုက် လော့။ သို့ရာတွင် ငါမှာထား သမျှ အတိုင်းသာ ပြု ရမည်ဟု မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","နံနက် ရောက်မှ ဗာလမ် ထ ၍ မြည်း ကို ကုန်းနှီး တင်ပြီးလျှင် ၊ မောဘ အရာရှိ တို့နှင့်အတူ လိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ထိုသို့ လိုက်သောကြောင့်၊ ဘုရားသခင် အမျက် တော်ထွက် ၍၊ ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် သူ့ ကို ဆီးတား ခြင်းငှါလမ်း ၌ ရပ် နေ၏။ ထိုအခါ ဗာလမ် သည် မြည်း ကို စီး ၍ ငယ်သား နှစ် ယောက်နှင့် သွား စဉ်တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် ထား ကို မိုးလျက်၊ လမ်း ၌ ရပ် နေသည်ကို မြည်း သည် မြင် လျှင် ၊ လမ်းလွှဲ ၍ လယ် သို့ ဝင် လေ၏။ ဗာလမ် လည်း မြည်း ကို လမ်း သို့ ပြန် စေခြင်းငှါ ရိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည်၊ စပျစ် ဥယျာဉ်စောင်ရန်း နှစ်ဘက်စပ်ကြား လမ်း ၌ တဖန် ရပ် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ထာဝရဘုရား ၏ ကောင်းကင်တမန် ကို မြည်း သည် မြင် ပြန်သောအခါ ၊ စောင်ရန်း တဘက် ၌ တိုး ၍ ဗာလမ် ၏ခြေ ကို ဖိ လေ၏။ ဗာလမ်လည်း တဖန် ရိုက် ပြန်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် လွန် သွား၍ လမ်းတဘက်ဘက်မျှ မ လွှဲ နိုင်အောင်ကျဉ်းမြောင်း သော အရပ် ၌ ရပ် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","မြည်း သည်လည်း ထာဝရဘုရား ၏ကောင်းကင်တမန် ကို မြင် ပြန်သောအခါ ၊ ဗာလမ် အောက် ၌ ဝပ် လျက် နေ၏။ ဗာလမ် သည် အမျက် ထွက် ၍ တောင်ဝေး နှင့် မြည်း ကိုရိုက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ထိုအခါ ထာဝရဘုရား သည် မြည်း ၏နှုတ် ကို ဖွင့် တော်မူ၍ ၊ မြည်းက သင်သည် ငါ့ ကို သုံး ကြိမ် တိုင်အောင် ရိုက် ရမည်အကြောင်း ၊ ငါသည် သင် ၌ အဘယ်သို့ ပြု ဘိသနည်းဟု ဗာလမ် အား မေး လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ဗာလမ် က၊ သင်သည် ငါ့ ကို ကျီစား ပါသည် တကား။ ငါ၌ ထားရှိပါစေသော။ ထား ရှိ လျှင် သင့် ကို ယခု သတ် မည်ဟု မြည်း အား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","မြည်း ကလည်း ၊ ငါ သည် ယနေ့ တိုင်အောင် သင် ၏အစီး ကို အစဉ် ခံရသောသင် ၏ မြည်း ဖြစ်သည်မ ဟုတ် လော။ သင် ၌ တခါမျှ ဤသို့ ငါပြု ဘူး သလော ဟုဗာလမ် အား မေး လျှင် ၊ မ ပြုဘူးဟု ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ထိုအခါ ထာဝရဘုရား သည် ဗာလမ် မျက်စိ ကို ဖွင့် တော်မူ၍ ၊ ထာဝရဘုရား ၏ ကောင်းကင်တမန် သည် ထား ကိုမိုးလျက်၊ လမ်း ၌ ရပ် နေသည်ကို ဗာလမ်သည် မြင် သဖြင့် ဦးချ ၍ ပြပ်ဝပ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ထာဝရဘုရား ၏ကောင်းကင် တမန်ကလည်း ၊ သင် ၏မြည်း ကို သုံး ကြိမ် တိုင်အောင်အဘယ်ကြောင့် ရိုက် သနည်း။ သင်သွားသောလမ်း သည် ငါနှင့် ဆန့်ကျင်ဘက် ဖြစ်သောကြောင့် ၊ သင့်ကို ဆီးတား ခြင်းငှါ ငါထွက်လာ ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","မြည်း သည် ငါ့ ကို မြင် ၍ သုံး ကြိမ် ရှောင် ခဲ့ပြီ။ ထိုသို့ မရှောင် လျှင်၊ အကယ်စင်စစ် သင့် ကိုငါသတ် ၍ မြည်း ကို အသက် ချမ်းသာပေးလေပြီဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ဗာလမ် ကလည်း ၊ အကျွန်ုပ်ပြစ်မှား ပါပြီ။ ကိုယ်တော် သည် လမ်း ၌ ကန့်လန့် နေ တော်မူသည်ကို အကျွန်ုပ် မ သိ ပါ။ ယခု မှာ အလို တော်မရှိလျှင် အကျွန်ုပ်ပြန် သွားပါမည် ဟု ထာဝရဘုရား ၏ ကောင်းကင် တမန်အား ဆို လျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ထာဝရဘုရား ၏ကောင်းကင် တမန်က၊ သူ တို့နှင့်အတူ လိုက် လော့။ သို့ရာတွင် ငါမှာထား သော စကား ကိုသာ ဟောပြော ရမည်ဟု ဗာလမ် အား မိန့် တော်မူ သည်အတိုင်း ၊ သူသည် ဗာလက် မင်း၏ ကျွန် တို့နှင့်အတူ လိုက် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ဗာလမ် ရောက် သောသိတင်းကို ဗာလက် မင်း ကြား လျှင် ၊ ခရီးဦးကြိုပြု ခြင်းငှါ ၊ မောဘ ပြည် စွန်း အာနုန် ချောင်းနား မှာရှိသော မြို့တမြို့သို့ ထွက်သွား ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ဗာလက် မင်းကလည်း၊ ကိုယ်တော် ကို ခေါ်ပင့် စေခြင်းငှါ ငါသည် အထပ်ထပ်စေလွှတ် သည်မ ဟုတ် လော ။ အဘယ်ကြောင့် နှေး ပါသနည်း။ ကိုယ်တော် ကို ငါချီးမြှောက် နိုင် သည်မ ဟုတ်လော ဟု ဗာလမ် အား ဆို လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ဗာလမ် က၊ မင်းကြီး ထံသို့ ငါလာ ပါပြီ။ သို့ရာတွင်ငါသည် စကားတခွန်း ကိုမျှ ပြော ပိုင် သလော။ ငါ့ နှုတ် ၌ ဘုရားသခင် ထား တော်မူသော စကား ကိုသာ ငါပြော ပါ မည်ဟု ပြန်ပြော ပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ဗာလက် မင်းနှင့်အတူ လိုက်၍ ကိရယဿုဇုတ် မြို့သို့ ရောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ဗာလက် မင်းသည်လည်း ၊ သိုး နွား တို့ကို ပူဇော် ၍ ဗာလမ် နှင့် အရာရှိ တို့အား ပေး လိုက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","နက်ဖြန် နေ့၌ ဗာလက် မင်းသည် ဗာလမ် ကို ခေါ်၍ ဣသရေလအမျိုးသားအပေါင်းတို့ကို အကုန်အစင် ပြခြင်းငှါဗာလဘုရားနှင့်ဆိုင်သော ကုန်းရိုး ပေါ်သို့ပို့ဆောင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ထိုအခါ ဗာလမ် က၊ ဤ အရပ်၌ ငါ့ အဘို့ ယဇ်ပလ္လင် ခုနစ် ခုကို တည် လော့။ နွားထီး ခုနစ် ကောင်၊ သိုးထီး ခုနစ် ကောင်တို့ကို ပြင်ဆင် လော့ဟု ဗာလက် မင်း အား ဆို သည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ဗာလက် မင်းသည် ပြု ပြီးလျှင် ၊ ထိုသူနှစ်ပါးတို့ သည် ယဇ်ပလ္လင် တခုတခုအပေါ် မှာနွား တကောင်စီနှင့် သိုး တကောင်စီကို ပူဇော် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ဗာလမ် ကလည်း၊ မင်းကြီးပူဇော်သော မီးရှို့ ရာ ယဇ်နား မှာရပ် လော့။ ငါသည် အခြားတပါးသို့ သွား ပါမည်။ ထာဝရဘုရား သည် ငါ့ ကို ကြိုဆို ခြင်းငှါ ကြွလာ ကောင်းကြွလာတော်မူလိမ့်မည်။ ငါ့ အား ပြ တော်မူသမျှကို မင်းကြီးအား ငါကြားပြော ပါမည်ဟု ဗာလက် မင်းအား ဆို ပြီးမှ ကုန်း တခုပေါ်သို့ တက် သွား၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ဘုရားသခင် သည် ဗာလမ် ကို ကြိုဆို တော်မူလျှင် ၊ ဗာလမ်က အကျွန်ုပ် သည် ယဇ်ပလ္လင် ခုနစ် ခုကို ပြင်ဆင်၍ ပလ္လင် တခုတခုအပေါ် မှာ နွားထီး တကောင်စီနှင့် သိုးထီး တကောင်စီကို ပူဇော် ပါပြီဟု လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ထာဝရဘုရား သည် ဗာလမ် နှုတ် ၌ စကား ကို ထား လျက် ၊ သင်သည် ဗာလက် မင်းထံသို့ ပြန် ၍ ဤသို့ ပြော လော့ဟု မိန့် တော်မူသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ဗာလမ်ပြန် သောအခါ ၊ ဗာလက်မင်းသည် မောဘ မှူးမတ် အပေါင်း တို့နှင့်တကွ ၊ မိမိ ပူဇော်သော မီးရှို့ ရာယဇ်နား မှာ ရပ် နေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ထိုအခါ ဗာလမ်သည်၊ ပရောဖက် စကားအားဖြင့် မြွက်ဆို သည်ကား၊ မောဘ ရှင်ဘုရင် ဗာလက် က၊ လာ ပါ။ ငါ့ အဘို့ ယာကုပ် အမျိုးကို ကျိန်ဆဲ ပါ။ လာ ပါ။ ဣသရေလ အမျိုးကို ပျက်စီး ခြင်းသို့ အပ်လိုက်ပါဟု ခေါ်၍ ငါ့ ကို အာရံ ပြည်အရှေ့ တောင်ရိုး မှ ဆောင် ခဲ့ပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ဘုရားသခင် ကျိန်ဆဲ တော်မ မူသောသူကို အဘယ်သို့ ငါကျိန်ဆဲ နိုင်မည်နည်း။ ဘုရားသခင် သည် ပျက်စီး ခြင်းသို့ အပ်တော်မ မူသောသူကို အဘယ်သို့ ငါအပ် နိုင်မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ကျောက် ပေါ် က သူ့ ကို ငါမြင် ၏။ တောင် ပေါ်က သူ့ ကို ငါကြည့်ရှု ၏။ ထိုလူမျိုး သည် တမျိုးတည်း နေ၍ အခြား တပါးသော လူမျိုးတို့နှင့် မ ရောနှော ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ယာကုပ် အမျိုးမြေမှုန့် ကို အဘယ်သူ ရေတွက် နိုင်သနည်း။ ဣသရေလ အမျိုးလေးစုတစု ကိုမျှ အဘယ်သူ ရေတွက်နိုင်သနည်း။ ဖြောင့်မတ် သောသူသေ သကဲ့သို့ငါ သေ ပါစေသော။ ငါ့ အဆုံး သည် သူ ၏အဆုံးကဲ့သို့ ဖြစ် ပါစေသောဟု မြွက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ဗာလက် မင်းကလည်း ၊ သင်သည် ငါ၌ အဘယ်သို့ ပြု သနည်း။ ငါ ၏ရန်သူ တို့ကို ကျိန်ဆဲ စေခြင်းငှါ သင့် ကို ငါခေါ် ခဲ့ပြီ။ သို့သော်လည်း သင်သည် လုံးလုံးကောင်းကြီး ပေးလေပြီတကားဟု ဗာလမ် အား ဆို လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ဗာလမ်က၊ ထာဝရဘုရား သည် ငါ့ နှုတ် ၌ ထား တော်မူသောစကားကို ပြော ရအောင် ငါသတိမ ပြုရ သလော ဟုပြန် ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ဗာလက် မင်းကလည်း ၊ ဣသရေလအမျိုးသားအပေါင်း တို့ကို တပြိုင်နက်မ မြင် ရဘဲ တပိုင်း ကိုမျှသာ ကြည့်မြင် ရာ၊ အခြား သောအရပ် သို့ ငါ နှင့်အတူ လိုက် ပါ လော့။ ထို အရပ်၌ သူ တို့ကို ငါ့ အဘို့ ကျိန်ဆဲ ပါဟု ဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ပိသဂါ တောင်ပေါ် ၊ ဇောဖိမ် လယ်ပြင် သို့ ဆောင် သွား၍ ယဇ်ပလ္လင် ခုနစ် ခုကို တည်ပြီးမှ၊ ပလ္လင် တခု တခုအပေါ် မှာ နွား တကောင်စီနှင့် သိုး တကောင်စီကို ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ဗာလမ်ကလည်း၊ မင်းကြီးပူဇော်သော မီးရှို့ ရာ ယဇ်နား မှာ ရပ် လော့။ ငါ သည် ထာဝရဘုရားကို ခရီးဦးကြိုပြု ခြင်းငှါအခြားတပါးသို့ သွားပါမည်ဟု ဗာလက် မင်းအား ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ထာဝရဘုရား သည် ဗာလမ် ကို ကြိုဆို ၍ သူ ၏ နှုတ် ၌ စကား ကိုထား လျက်၊ သင်သည် ဗာလက် မင်းထံသို့ ပြန် ၍ ဤသို့ ပြော လော့ဟု မိန့် တော်မူသည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ဗာလမ်ပြန် သောအခါ ၊ ဗာလက်မင်းသည် မောဘ မှူးမတ် တို့နှင့်တကွ ၊ မိမိ ပူဇော်သော မီးရှို့ ရာယဇ် နား မှာ ရပ် နေလျက်၊ ထာဝရဘုရား သည် အဘယ်သို့ မိန့် တော်မူသနည်းဟုမေး လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ထိုအခါ ဗာလမ်သည်၊ ပရောဖက် စကားအားဖြင့် မြွက်ဆို သည်ကား၊ အိုဇိဖေါ် သား ဗာလက် မင်း၊ ထ လော့။ ငါ့ စကားကို စေ့စေ့နားထောင် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ဘုရားသခင် သည် မုသာ စကားကို ပြောအံ့သောငှါ လူ ဖြစ်တော်မူသည်မ ဟုတ်။ နောင်တရ အံ့သောငှါ လူ သား ဖြစ်တော်မူသည်မဟုတ်။ မိန့် တော်မူပြီးမှ ၊ စကားတော်အတိုင်း မ ပြု ဘဲ နေတော်မူမည်လော။ ဂတိ ထားတော်မူပြီးမှ ၊ ဂတိတော်မ တည် ဘဲနေတော်မူမည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ကောင်းကြီး ပေးရမည်အကြောင်း၊ အမိန့်တော် ကို ငါခံရ ပြီ။ ဘုရားသခင်ကောင်းကြီး ပေးတော်မူပြီ။ ထိုကောင်းကြီးကို ငါမ ဖျက် နိုင်။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ယာကုပ် အမျိုးကို ညှဉ်းဆဲ သောအမှု၊ ဣသရေလ အမျိုးတဘက်၌ ပြုသောနှောင့်ရှက် ခြင်းအမှုကို ဘုရားသခင် သည် ကြည့်ရှု ၍ နေတော်မ မူ။ သူ တို့ ဘုရားသခင် ထာဝရဘုရား သည် သူ တို့နှင့်အတူ ရှိတော်မူ၏။ ရှင်ဘုရင် ကြွေးကြော် ခြင်းအသံကို သူ တို့တွင် ကြားရ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ဘုရားသခင် သည် အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူသည်ဖြစ်၍၊ ဣသရေလအမျိုးသည် ကြံ့ အားကြီး သကဲ့သို့ အားကြီး၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","အကယ်စင်စစ် ယာကုပ် အမျိုးကို၊ ထူးဆန်း သော အတတ်အားဖြင့်မ နိုင်ရာ။ ဣသရေလ အမျိုးကို အဘယ်သူမျှမ ပြုစား ရာ။ ဘုရားသခင် သည် အဘယ်သို့ ပြု တော်မူပြီတကားဟု ယခု ကာလကို ထောက်၍ ယာကုပ် အမျိုး၊ ဣသရေလ အမျိုးကို ရည်ဆောင် လျက် ဆို လေ့ရှိ လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ဤလူမျိုး သည်၊ ခြင်္သေ့ ကဲ့သို့ ထ လိမ့်မည်။ ခြင်္သေ့ပျို ကဲ့သို့ ထွက် လိမ့်မည်။ ဘမ်းမိ သော အကောင်ကို မ စား မှီ၊ သတ် အပ်သော တိရစ္ဆာန်အသွေး ကို မသောက် မှီ တိုင်အောင်ငြိမ်ဝပ် စွာမ နေဟု မြွက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ဗာလက် မင်းကလည်း ၊ သူ တို့ကို အလျှင်း မ ကျိန်ဆဲ ပါနှင့်။ ကောင်းကြီး ကိုလည်း အလျှင်း မ ပေးပါနှင့်ဟု ဗာလမ် အား ဆို လျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ဗာလမ်က၊ ထာဝရဘုရား မိန့် တော်မူသမျှ အတိုင်း ငါပြု ရပါမည်ဟု မင်းကြီး အား အရင်ပြော နှင့်ပြီ မ ဟုတ်လော ဟု ဗာလက် မင်းအား ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","တဖန် ဗာလက် မင်းက၊ လာ ပါတော့။ အခြား သော အရပ် သို့ ဆောင် သွားပါမည်။ ထို အရပ်၌ သူ တို့ကို ငါ့ အဘို့ ကျိန်ဆဲ စေခြင်းငှါဘုရားသခင် အလို တော်ရှိကောင်းရှိတော်မူလိမ့်မည်ဟု ဗာလမ် အား ဆို လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ယေရှိမုန် မြို့ကို မျက်နှာပြု သော ပေဂုရ တောင်ထိပ် သို့ ဆောင် သွားလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ဗာလမ် ကလည်း ၊ ဤ အရပ်၌ ငါ့ အဘို့ ယဇ်ပလ္လင် ခုနစ် ခုကို တည် လော့။ နွားထီး ခုနစ် ကောင်၊ သိုးထီး ခုနစ် ကောင်တို့ကို ပြင်ဆင် လော့ဟု ဗာလက် မင်းအား ဆို သည်အတိုင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ဗာလက် မင်းသည်ပြု ၍ ၊ ယဇ်ပလ္လင် တခုတခုအပေါ် မှာ နွား တကောင်စီနှင့် သိုး တကောင်စီကို ပူဇော် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ထာဝရဘုရား သည်၊ ဣသရေလ အမျိုးကို ကောင်းကြီး ပေးခြင်းငှါ အလိုရှိ တော်မူကြောင်း ကို ဗာလမ် သိမြင် လျှင် ၊ ထူးဆန်း သော အတတ်ကို ရှာ ခြင်းငှါ အရင် သွားသကဲ့သို့ မ သွား ဘဲ၊ တော သို့ မျက်နှာပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","သို့ရာတွင် ၊ မြော်ကြည့် ၍ ဣသရေလ အမျိုးသားတို့သည် အမျိုးအနွယ် အလိုက် အသီးအသီးတပ်ချ လျက် နေကြသည်ကို မြင် သောအခါ ၊ ဘုရားသခင် ၏ ဝိညာဉ် တော်သည် သူ့ အပေါ် မှာ သက်ရောက် တော်မူလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","သူသည် ပရောဖက် စကားအားဖြင့်မြွက်ဆို လေသည်မှာ၊ မျက်စိ ပွင့် သောသူ၊ ဗောရ သား ဗာလမ် ၏ စကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ဘဝင် ဖြစ်၍ မျက်စိ ပွင့် လျက် အနန္တ တန်ခိုးရှင် ၏ ရူပါရုံ ကိုမြင် ၍၊ ဘုရားသခင် ၏ အမိန့် တော်ကို ကြား သောသူ၏ စကား ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","အိုယာကုပ် အမျိုး၊ သင် တို့၏တဲ များ၊ အိုဣသရေလ အမျိုး၊ သင် တို့၏ ဘုံဗိမာန် များတို့သည် အဘယ်မျှ လောက် တင့်တယ် ကြသည်တကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ကျယ်ဝန်း သော ချိုင့် များ၊ မြစ် နား မှာရှိသော ဥယျာဉ် များ၊ ထာဝရဘုရား စိုက် တော်မူသောအကျော် ပင်များ၊ ရေ နား မှာပေါက်သော အာရဇ် ပင်များကဲ့သို့ ဖြစ် ကြသည်တကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ထိုအမျိုး ၏ ရေပုံး တို့မှ ရေ စီး လိမ့်မည်။ ရေ ပေါ သော အရပ်၌ မျိုးစေ့ ကျလိမ့်မည်။ သူ ၏ ရှင်ဘုရင် သည် အာဂတ် မင်းထက် ဘုန်းကြီး၍၊ နိုင်ငံတော် သည် ချီးမြှောက် သော နိုင်ငံဖြစ်လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ဘုရားသခင် သည် အဲဂုတ္တု ပြည်မှ နှုတ်ဆောင် တော်မူသည်ဖြစ်၍၊ ဣသရေလအမျိုးသည်၊ ကြံ့ အားကြီး သကဲ့သို့ အားကြီး၏။ ရန်သူ ဖြစ်သော လူမျိုး တို့ကို ကိုက်ဝါး ၍ ၊ အရိုး တို့ကို ချိုးဖဲ့ လိမ့်မည်။ မြှား ဖြင့် ထုတ်ချင်းခပ် အောင် ခွင်းလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ဝပ် လျက်နေ၏။ ခြင်္သေ့ ကဲ့သို့ ၎င်း ၊ ခြင်္သေ့ မကဲ့သို့ ၎င်း ဝပ်တွား လေ၏။ အဘယ်သူ နှိုးဆော် ဝံ့မည်နည်း။ သင့် ကို ကောင်းကြီး ပေးသောသူသည် ကောင်းကြီး မင်္ဂလာရှိ၏။ သင့် ကို ကျိန်ဆဲ သောသူသည် ကျိန်ဆဲ ခြင်းကိုခံရသည်ဟု မြွက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ထိုအခါ ဗာလက် မင်းသည်၊ ဗာလမ် ကို အမျက် ထွက် ၍ လက်ခုပ်တီး လျက်၊ ငါ ၏ ရန်သူ တို့ကို ကျိန်ဆဲ စေခြင်းငှါ သင့် ကို ငါခေါ် ခဲ့၏။ သင်သည် သုံး ကြိမ် တိုင်အောင် အကြွင်းမဲ့ကောင်းကြီး ပေးလေပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ထိုကြောင့် သင့် နေရာ ပြည်သို့ ပြေး သွားလော့။ သင့် ကို ချီးမြှောက် မည်ဟု အထက်က ငါအကြံ ရှိ၏။ သို့ရာတွင် ထာဝရဘုရား သည် သင်၏ဘုန်း ကို မတိုးပွားစေခြင်းငှါဆီးတား လေပြီဟု ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ဗာလမ် ကလည်း ၊ ဗာလက် မင်းသည် ရွှေ ငွေ နှင့် ပြည့် သော မိမိ နန်း တော်ကိုပင် ပေး သော်လည်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ထာဝရဘုရား ၏ ပညတ် တော်ကို လွန်ကျူး ၍ ကောင်း သောအမှု၊ မကောင်း သောအမှုတစုံတခုကို ကိုယ် အလိုအလျောက်ငါမ ပြု နိုင်။ ထာဝရဘုရား မိန့် တော်မူသမျှ ကို ငါပြော ပါမည်ဟု မင်းကြီးစေလွှတ် သော သံတမန် တို့အား ငါပြော နှင့်ပြီ မ ဟုတ်လော။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ယခု မူကား ၊ ငါ့ အဆွေအမျိုး တို့ထံသို့ ငါ သွား တော့မည်။ နားထောင်ပါ။ နောင် ကာလ ၌ ဤ လူမျိုး သည် မင်းကြီး ၏လူမျိုး ၌ အဘယ်သို့ ပြု မည်အရာကို မင်းကြီး အား ကြားပြော ပါမည်ဟု ဗာလက်မင်းအား ပြန် ဆိုပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ပရောဖက် စကားအားဖြင့်မြွက်ဆို လေသည်မှာ၊ မျက်စိ ပွင့် သောသူ ဗောရ သား ဗာလမ် ၏စကား ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ဘဝင် ဖြစ်၍ မျက်စိ ပွင့် လျက်၊ အနန္တ တန်ခိုးရှင် ၏ ရူပါရုံ ကို မြင် ၍၊ အမြင့်ဆုံး သော ဘုရားပေးတော်မူသော ဉာဏ် ကို ရ ၍ ၊ ဘုရားသခင် ၏အမိန့် တော်ကို ကြား သောသူ၏စကား ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ထိုအရာကို ငါမြင် ၏။ သို့သော်လည်း ယခု မ ဖြစ်ရသေး။ ထိုအရာကို ငါရှု ၏။ သို့သော်လည်း ဖြစ် ရသောအချိန် မ နီး သေး။ ကြယ် တလုံးသည် ယာကုပ် အမျိုး၌ ပေါ်ထွန်း ၍ ၊ ရာဇလှံတံ သည် ဣသရေလ အမျိုး ၌ ထင်ရှားလိမ့်မည်။ မောဘ ပြည်စွန်း တိုင်အောင်ထိခိုက် ၍ မငြိမ်မဝပ် ရုန်းရင်းခပ်ပြုတတ်သော သူအပေါင်း တို့ကို ဖျက်ဆီး လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ဧဒုံ ပြည်ကိုလည်း သိမ်းယူ လိမ့်မည်။ စိရ တောင် သည်လည်း ရန်သူ လက် သို့ ရောက်လိမ့်မည်။ ဣသရေလ အမျိုးသည် ရဲရင့် စွာ ပြု လိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","အစိုးရ သောသူတပါးသည်၊ ယာကုပ် အမျိုးထဲက ထွက်၍၊ ကျန်ကြွင်း သောမြို့သူ မြို့သားတို့ကို ဖျက်ဆီး လိမ့်မည် ဟု မြွက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","တဖန် အာမလက် ပြည်ကို ကြည့်ရှု ၍ ပရောဖက် စကားအားဖြင့်မြွက်ဆို ပြန်သည်ကား၊ အာမလက် အမျိုး သည် လူမျိုးတကာတို့ထက် အထွဋ် ဖြစ်ဘူးသော်လည်း ၊ အဆုံး ၌ ရှင်းရှင်းပျက်စီးခြင်း သို့ ရောက်လိမ့်မည်ဟု မြွက်ဆို ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","တဖန် ကေနိ အမျိုးသားတို့ကို ကြည့်ရှု ၍ ပရောဖက် စကားအားဖြင့်မြွက်ဆို ပြန်သည်ကား၊ သင် တို့နေရာ သည် အားကြီး ၏။ ကျောက် ပေါ်မှာ အသိုက် ကို လုပ် ကြပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","သို့သော်လည်း အာရှုရိ မင်းသည် သိမ်းယူ ၍ မ သွားမှီတိုင်အောင်၊ ကေနိ အမျိုးသည် အမျက် ကိုခံရလိမ့်မည်ဟု မြွက်ဆို၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","တဖန် ပရောဖက် စကားအားဖြင့်မြွက်ဆို ပြန် သည်ကား၊ အလိုလေ့၊ ဤအမှုကို ဘုရားသခင် စီရင် တော်မူသောအခါ ၊ အဘယ်သူ သည် အသက် ချမ်းသာရလိမ့်မည်နည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","သင်္ဘော တို့သည်လည်း ခိတ္တိမ် ပြည် မှ လာ၍ အာရှုရိ ပြည်ကို၎င်း ၊ ဟေဗာ ပြည်ကို၎င်းနှောင့်ရှက် ကြ လိမ့်မည်။ သူ တို့သည်လည်း ရှင်းရှင်းပျက်စီး ကြလိမ့်မည် ဟု မြွက်ဆိုပြီးမှ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ဗာလမ် သည် ထ ၍ မိမိ နေရာ အရပ်သို့ ပြန် သွား၏။ ဗာလက် မင်းသည်လည်း သွား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ဣသရေလ အမျိုးသားတို့သည် ရှိတ္တိမ် အရပ်၌ နေ သောအခါ ၊ အချို့တို့သည် မောဘ မိန်းမ တို့နှင့် မတရား သောမေထုန် ကိုပြုကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ထိုမိန်းမတို့သည် မိမိ တို့ ဘုရား ရှေ့မှာ ယဇ်ပူဇော် ရာပွဲသို့ ဣသရေလလူ တို့ကို ခေါ် သွားသဖြင့် ၊ ယောက်ျားတို့ သည် ယဇ်သားကို စား ၍ ထိုဘုရား ရှေ့မှာ ဦးချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ထိုသို့ဣသရေလ အမျိုးသားတို့သည်၊ ဗာလပေဂုရ ဘုရားကို ဆည်းကပ် သောကြောင့် ၊ ထာဝရဘုရား သည် အမျက် ထွက် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ထာဝရဘုရား ကလည်း ၊ ငါသည်ပြင်းစွာ သော အမျက် တော်ကို ဣသရေလ အမျိုးမှ လွဲ စေခြင်းငှာ ၊ ဣသရေလမင်း အပေါင်း တို့ကို ခေါ် ၍ ၊ ပြစ်မှားသောသူတို့ ကို ဘုရား ရှေ့မှာ ထင်ရှား စွာ ဆွဲထား လော့ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","မောရှေ သည် ဣသရလ မင်း တို့ကို ခေါ်၍၊ ဗာလပေဂုရ ဘုရားကို ဆည်းကပ် သောသူတို့ ကို သင်တို့အသီးသီး ဆိုင်သည်အတိုင်း ကွပ်မျက် ကြလော့ဟု မှာထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ထိုအခါ ဣသရေလ အမျိုးသား တယောက်သည်၊ မောရှေ ရှေ့၌ ၎င်း ၊ ပရိသတ်စည်းဝေး ရာ တဲ တော် တံခါး နားမှာ ငိုကြွေး သော ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ရှေ့၌ ၎င်း၊ မိဒျန် မိန်းမကိုလည်း၊ မိမိ ညီအစ်ကို တို့ ထံသို့ ဆောင် ခဲ့လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ထိုအမှုကို ယဇ်ပုရောဟိတ် အာရုန် ၏သား ဧလာဇာ ၏သား ဖိနဟတ် သည် မြင် လျှင် ၊ ပရိသတ် ထဲမှာ ထ ၍ လှံ ကိုကိုင် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ထိုဣသရေလ လူ ကို တဲ အတွင်း သို့ လိုက် ပြီးမှ ၊ ယောက်ျား ကို ထုတ်ချင်းခပ်အောင်၎င်း၊ မိန်းမ ကို ဝမ်းပေါက်အောင်၎င်း ထိုး လေ၏။ ထိုသို့ပြုသောအားဖြင့် ဣသရေလ အမျိုးသား တို့တွင် ဘေး ငြိမ်း လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ထိုဘေး ဖြင့် သေ သောလူပေါင်းကား၊ နှစ်သောင်း လေးထောင်ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ထာဝရဘုရား ကလည်း ၊ ငါသည် အမျက် ထွက် ၍ ဣသရေလ အမျိုးသား တို့ကို မ ဖျက်ဆီး မည်အကြောင်း ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","ယဇ်ပုရောဟိတ် အာရုန် ၏သား ဧလာဇာ ၏ သား ၊ ဖိနဟတ် သည် သူ တို့တွင် ငါ့ဘက်၌ စိတ်အားကြီး၍ ငါ့အမျက်ကို သူတို့မှလွှဲပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","သို့ဖြစ်၍ သင်ပြော ရသည်ကား၊ ငါ ၏ချမ်းသာ ပဋိညာဉ် ကို သူ့ အား ငါ ပေး ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","သူသည် မိမိဘုရားသခင် ဘက်၌ စိတ်အားကြီး ၍ ဣသရေလ အမျိုးသား တို့အဘို့ အပြစ် ဖြေခြင်းကို ပြုသောကြောင့် ၊ သူ မှစ၍ သားစဉ်မြေးဆက် တို့သည် ထိုပဋိညာဉ်တည်းဟူသောထာဝရ ယဇ်ပုရောဟိတ် အရာနှင့်ဆိုင်သော ပဋိညာဉ် ကို ရပြီဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","မိဒျန် မိန်းမနှင့် အသေ သတ်ခြင်းကိုခံရသောဣသရေလ လူ ၏ အမည် ကား၊ ရှိမောင် အမျိုး၌ ထင်ရှားသော အဆွေအမျိုး တွင် အကဲအမှူး သာလု ၏သား ဇိမရိ ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","အသေ သတ်ခြင်းကိုခံရသောမိဒျန် မိန်းမ အမည် ကား၊ မိဒျန် အမျိုး၌ ထင်ရှားသော အဆွေအမျိုး တွင် အကဲအမှူး ဇုရ ၏ သမီး ကောဇဘိ ဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ထာဝရဘုရား ကလည်း ၊ မိဒျန် အမျိုးသားတို့ကို နှောင့်ရှက် ၍ လုပ်ကြံ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","အကြောင်းမူကား ၊ သူတို့သည် ပေဂုရ ဘုရား အမှု ၌ ၎င်း၊ ပေဂုရ ဘုရားကြောင့် ဘေး ရောက်သောနေ့ ၌ အသေ သတ်ခြင်းကို ခံရသောသူ တို့ နှမ မိဒျန် မင်း သမီး ကောဇဘိ အမှု ၌ ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","သင် တို့ကို ပရိယာယ် များ အားဖြင့် လှည့်စား နှောင့်ရှက် ကြပြီဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ထိုဘေး ငြိမ်းသောနောက် ၊ ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","အသက် နှစ်ဆယ် လွန် ၍ စစ်တိုက် နိုင်သော ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ကို၊ ဘိုးဘ အဆွေအမျိုး အလိုက် စာရင်းယူ ကြလော့ဟု မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ တို့အား မိန့် တော်မူသည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","သူတို့သည် မောဘ လွင်ပြင် ၊ ယော်ဒန် မြစ်နား ၊ ယေရိခေါ မြို့တဘက်၌၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","အသက် နှစ်ဆယ် လွန် သောသူတို့ကို စာရင်းယူရ မည်အကြောင်းဆင့်ဆို ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","အဲဂုတ္တု ပြည် မှ ထွက်လာ သောဣသရေလ အမျိုးသား တို့တွင်၊ ဣသရေလ ၏ သားဦး ရုဗင် ၏သား ဟူမူကား ဟာနုတ် မှဆင်းသက်သော ဟောနောခိ အဆွေအမျိုး ၊ ဖါလု မှ ဆင်းသက်သော ဖာလွိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ဟေဇရုံ မှ ဆင်းသက်သော ဟေဇရောနိ အဆွေအမျိုး ၊ ကာမိ မှ ဆင်းသက်သော ကာမိတ် အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ဤ သူတို့သည် ရုဗင် အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ လေးသောင်း သုံးထောင်ခုနစ်ရာသုံးဆယ်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ဖာလု ၏သား ဧလျာဘ ၊ ဧလျာဘ ၏သား နေမွေလ ၊ ဒါသန် ၊ အဘိရံ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ဤ ဒါသန် ၊ အဘိရံ တို့သည် အခြားမဟုတ်၊ ကောရ အပေါင်းအသင်း သည် ထာဝရဘုရား နှင့် ဆန့်ကျင်ဘက် ပြုသောအခါ ၊ ပရိသတ် ၌ ကျော်စော ၍ မောရှေ နှင့် အာရုန် ကို ဆန့်ကျင်ဘက် ပြုသော ဒါသန်၊ အဘိရံ ဖြစ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","မြေကြီး သည် မိမိ ခံတွင်း ကိုဖွင့် ၍ သူ တို့ကို၎င်း ၊ ကောရ ကို၎င်း မျို သဖြင့် ၊ ထိုအပေါင်းအသင်း ဝင်သူတို့ သည် သေ ကြ၏။ မီး သည် လည်း လူနှစ်ရာ ငါးဆယ် တို့ကို အသက် ဆုံးစေ၏။ ထိုသူတို့သည် သတိပေး သော သက်သေဖြစ် သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","သို့ရာတွင် ကောရ ၏ သားသမီး တို့သည် သေ ဘေးနှင့် လွတ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ဘိုးဘအဆွေအမျိုး အလိုက် ရှိမောင် ၏သား ဟူမူကား၊ ယေမွေလ မှ ဆင်းသက်သော ယေမွေလိ အဆွေအမျိုး ၊ ယာမိန် မှ ဆင်းသက်သော ယာမိနိ အဆွေအမျိုး ၊ ယာခိန် မှ ဆင်းသက်သော ယာခိနိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ဇေရ မှ ဆင်းသက်သောဇေရဟိ အဆွေအမျိုး ၊ ရှောလ မှ ဆင်းသက်သော ရှောလိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ဤ သူတို့သည် ရှိမောင် အဆွေအမျိုး ဖြစ်၍လူပေါင်းကား၊ နှစ်သောင်း နှစ်ထောင်နှစ်ရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ဘိုးဘအဆွေအမျိုး အလိုက် ဂဒ် ၏သား ဟူမူကား၊ ဇေဖုန် မှ ဆင်းသက်သော ဇေဖေါနိ အဆွေအမျိုး ၊ ဟဂ္ဂိ မှ ဆင်းသက်သော ဟဂ္ဂိတ် အဆွေအမျိုး ၊ ရှုနိ မှ ဆင်းသက်သော ရှုနိတ် အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ဩဇနိ မှ ဆင်းသက်သော ဩဇနိတ် အဆွေအမျိုး ၊ ဧရိ မှ ဆင်းသက်သော ဧရိတ် အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","အာရုဒ် မှ ဆင်းသက်သော အာရောဒိ အဆွေအမျိုး ၊ အရေလိ မှ ဆင်းသက်သော အရေလိတ် အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ဤ သူတို့သည်ဂဒ် အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင် သော လူပေါင်းကား၊ လေးသောင်း ငါး ရာ ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ယုဒ ၏သား ဟူမူကား၊ ခါနာန် ပြည် ၌ သေ သော ဧရ နှင့် ဩနန် အစရှိသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ဘိုးဘအဆွေအမျိုး အလိုက် ၊ ရှေလ မှ ဆင်းသက်သော ရှေလနိ အဆွေအမျိုး ၊ ဖါရဇ် မှ ဆင်းသက်သော ဖါရဇိ အဆွေအမျိုး ၊ ဇေရ မှ ဆင်းသက်သော ဇေရဟိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ဖါရဇ် ၏သား ၊ ဟေဇရုံ မှ ဆင်းသက်သော ဟေဇရောနိ အဆွေအမျိုး ၊ ဟာမုလ မှ ဆင်းသက်သော ဟာမုလိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ဤ သူတို့သည် ယုဒ အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ ခုနစ်သောင်း ခြောက်ထောင်ငါးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ဘိုးဘအဆွေအမျိုး အလိုက် ဣသခါ ၏သား ဟူမူကား၊ တောလ မှဆင်းသက်သော တောလိ အဆွေအမျိုး ၊ ဖုဝါ မှ ဆင်းသက်သော ဖုဝနိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ယာရှုပ် မှ ဆင်းသက်သော ယာရှုဘိ အဆွေအမျိုး ၊ ရှိမရုန် မှ ဆင်းသက်သော ရှိမရောနိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ဤ သူတို့သည် ဣသခါ အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ ခြောက်သောင်း လေးထောင်သုံးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ဘိုးဘအဆွေအမျိုး အလိုက် ဇာဗုလုန် ၏သား ဟူမူကား၊ သရက် မှ ဆင်းသက်သော သရဒိ အဆွေအမျိုး ၊ ဧလုန် မှ ဆင်းသက်သော ဧလောနိ အဆွေအမျိုး ၊ ယာလေလ မှဆင်းသက်သော ယာလေလိ အဆွေအမျိုးတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ဤ သူတို့သည် ဇာဗုလုန် အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ ခြောက်သောင်း ငါးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ဘိုးဘအဆွေအမျိုး အလိုက် ယောသပ် ၏သား မနာရှေ နှင့် ဧဖရိမ် တို့တွင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","မနာရှေ ၏သား ဟူမူကား၊ မာခိရ မှ ဆင်းသက်သော မာခိရိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ယေဇေရ မှဆင်းသက်သော ယေဇေရိ အဆွေအမျိုး ၊ ဟေလက် မှ ဆင်းသက်သော ဟေလကိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","အသရေလ မှဆင်းသက်သော အာသရေလိ အဆွေအမျိုး ၊ ရှေခင် မှ ဆင်းသက်သော ရှေခေမိ အဆွေအမျိုး၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ရှမိဒ မှ ဆင်းသက်သော ရှမိဒိ အဆွေအမျိုး ၊ ဟေဖါ မှဆင်းသက်သော ဟေဖေရိ အဆွေအမျိုး တည်း။ မာခိရ၏သားဂိလဒ်မှ ဆင်းသက်သော ဂိလဒိအဆွေအမျိုးတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ဟေဖါ ၏သား ဇလောဖဒ် ၌ကား၊ သား ယောက်ျားမ ရှိ ၊ သမီး သက်သက်သာ ရှိ၏။ ဇလောဖဒ် ၏ သမီး တို့ အမည် ကား၊ မာလာ ၊ နောအာ ၊ ဟောဂလာ ၊ မိလကာ ၊ တိရဇာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ဤ သူတို့သည် မနာရှေ အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ ငါးသောင်း နှစ်ထောင်ခုနစ်ရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ဘိုးဘအဆွေအမျိုး အလိုက် ဧဖရိမ် ၏သား ဟူမူကား ၊ ရှုသလ မှ ဆင်းသက်သော ရှုသလိ အဆွေအမျိုး ၊ ဗေခါ မှ ဆင်းသက်သော ဗေခရိ အဆွေအမျိုး ၊ တာဟန် မှ ဆင်းသက်သော တာဟနိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ရှုသေလ ၏သား ဧရန် မှ ဆင်းသက်သော ဧရနိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ဤ သူတို့သည် ဧဖရိမ် အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ သုံးသောင်း နှစ်ထောင်ငါးရာရှိသတည်း။ ဤ သူတို့သည် ဘိုးဘအဆွေအမျိုး အလိုက် ယောသပ် ၏သားစဉ်မြေးဆက် ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ဘိုးဘအဆွေအမျိုး အလိုက် ဗင်္ယာမိန် ၏သား ဟူမူကား၊ ဗေလ မှ ဆင်းသက်သော ဗေလိအဆွေအမျိုး၊ အာရှဗေလ မှ ဆင်းသက်သော အာရှဗေလိ အဆွေအမျိုး ၊ အဟိရံ မှ ဆင်းသက်သော အဟိရမိ အဆွေအမျိုး။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ရှုဖံ မှ ဆင်းသက်သော ရှုဖမိ အဆွေအမျိုး ၊ ဟုဖံ မှ ဆင်းသက်သော ဟုဖမိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ဗေလ သား အာရဒ မှဆင်းသက်သော အာရဒိ အဆွေအမျိုး ၊ နေမန် မှ ဆင်းသက်သော နေမနိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ဤ သူတို့သည် ဗင်္ယာမိန် အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား လေးသောင်း ငါးထောင်ခြောက်ရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ဘိုးဘအဆွေအမျိုး အလိုက် ဒန် ၏သား ဟူမူကား ၊ ရှုဟံ မှ ဆင်းသက်သောရှုဟမိ အဆွေအမျိုး တည်း။ ဤ သူတို့သည် ဒန် အဆွေအမျိုး ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","စာရင်း ဝင်သော ရှုဟမိ လူပေါင်း ကား၊ ခြောက်သောင်း လေးထောင်လေးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ဘိုးဘအဆွေအမျိုး အလိုက် အာရှာ ၏သား ဟူမူကား၊ ယိမန မှ ဆင်းသက်သော ယိမနိ အဆွေအမျိုး ၊ ယေသဝိ မှ ဆင်းသက်သော ယေသဝိတ် အဆွေအမျိုး ၊ ဗေရိ မှဆင်းသက်သော ဗေရိတ် အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ဗေရိ ၏သား ဟေဗေရ မှ ဆင်းသက်သော ဟေဗေရိ အဆွေအမျိုး ၊ မာလချေလ မှ ဆင်းသက်သော မာလချေလိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","အာရှာ ၏ သမီး အမည် ကား၊ စာရာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ဤ သူတို့သည် အာရှာ အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ ငါးသောင်း သုံးထောင်လေးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ဘိုးဘအဆွေအမျိုး အလိုက် နဿလိ ၏သား ဟူမူကား၊ ယာဇေလ မှ ဆင်းသက်သော ယာဇေလိ အဆွေအမျိုး ၊ ဂုနိ မှ ဆင်းသက်သော ဂုနိတ် အဆွေအမျိုး ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ယေဇေရ မှ ဆင်းသက်သော ယေဇေရိ အဆွေအမျိုး ၊ ရှိလ္လင် မှ ဆင်းသက်သော ရှိလ္လမိ အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ဤ သူတို့သည် နဿလိ အဆွေအမျိုး ဖြစ်၍၊ စာရင်း ဝင်သော လူပေါင်းကား၊ လေးသောင်း ငါးထောင်လေးရာရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ထိုသို့ ဣသရေလ အမျိုး ၊ စာရင်း ဝင်သူ လူပေါင်း ကား ခြောက်သိန်း တထောင်ခုနစ်ရာငါးဆယ်ရှိ သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ထာဝရဘုရား ကလည်း ၊ ဤ သူတို့အား အရေအတွက် ရှိသည်အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","ခါနန်ပြည် ကို ဝေ ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","လူများ လျှင်များ သော အမွေ မြေကို၎င်း၊ လူနည်း လျှင် နည်း သော အမွေ မြေကို၎င်း၊ အနည်း အများ အလိုက် အသီးသီး တို့အား အမွေ မြေကို ဝေပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","သို့ရာတွင် ထိုပြည် ကို စာရေးတံ ချ၍ ဝေ ရမည်။ ဘိုးဘ အမျိုးအနွယ် အလိုက် အမွေ ခံရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","စာရေးတံ ကျသည်အတိုင်း မြေ ကိုဝေ ၍ အနည်း အများ အလိုက် ပိုင်ရကြမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ဘိုးဘအဆွေအမျိုး အလိုက် စာရင်း ဝင်သော လေဝိ ၏သား ဟူမူကား ၊ ဂေရရှုန် မှ ဆင်းသက်သော ဂေရရှောနိ အဆွေအမျိုး ၊ ကောဟတ် မှ ဆင်းသက်သော ကောဟသိ အဆွေအမျိုး ၊ မေရာရိ မှ ဆင်းသက်သော မေရောရိတ် အဆွေအမျိုး တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ဤသည်လျှင် လေဝိ အဆွေအမျိုး ဖြစ်၍၊ လိဗနိ အဆွေအမျိုး ၊ ဟေဗြောနိ အဆွေအမျိုး ၊ မာလိ အဆွေအမျိုး ၊ မုရှိ အဆွေအမျိုး ၊ ကောရသိ အဆွေအမျိုး ပါသတည်း။ ကောဟတ် ၏ သားကား၊ အာမရံ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","အာမရံ ၏ မယား ကား၊ အဲဂုတ္တု ပြည်၌ လေဝိ မယား ဘွားမြင် သော လေဝိ ၏ သမီး ယောခေဗက် တည်း။ ထိုမိန်းမသည် အာမရံ ၏ မယားဖြစ်၍၊ အာရုန် ၊ မောရှေ ၊ နှမ မိရိအံ တို့ကို ဘွားမြင် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","အာရုန် ၏သားကား၊ နာဒပ် ၊ အဘိဟု ၊ ဧလာဇာ ၊ ဣသမာ တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","နာဒပ် နှင့် အဘိဟု တို့သည် ထာဝရဘုရား ရှေ့ တော်၌ ထူးခြား သောမီး ကို ပူဇော် သောအခါ သေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","အသက် တလ လွန် ၍ စာရင်း ဝင်သော လေဝိ သား ယောက်ျား ပေါင်း ကား၊ နှစ်သောင်း သုံးထောင်ရှိသတည်း။ သူတို့သည် ဣသရေလ အမျိုးသား တို့နှင့်အတူ အမွေ မ ခံရ သောကြောင့် ၊ ရောနှော၍ စာရင်း မ ဝင်ရကြ။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ဤရွေ့ကား ၊ မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ တို့သည်၊ မောဘ လွင်ပြင် ၊ ယော်ဒန် မြစ်နား ၊ ယေရိခေါ မြို့တဘက်၌ စာရင်း ယူသော ဣသရေလ အမျိုးသား ပေတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","မောရှေ နှင့် ယဇ်ပုရောဟိတ် အာရုန် တို့သည်၊ သိနာ တော ၌ ဣသရေလ အမျိုးသား တို့ကို စာရင်း ယူ၍၊ ထို စာရင်း၌ ဝင် သောသူ တယောက် မျှ မပါ။ ");
INSERT INTO myajvb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","အကြောင်းမူကား ၊ ထိုသူတို့သည်တော ၌ အမှန် သေ ရကြမည်ဟု ထာဝရဘုရား မိန့် တော်မူပြီ။ ယေဖုန္နာ ၏သား ကာလက် နှင့် နုန် ၏သား ယောရှု မှတပါး ၊ အရင်းလူတယောက် မျှ မကြွင်း မကျန်ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ထိုအခါ ယောသပ် ၏သား ၊ မနာရှေ အဆွေအမျိုး ၌ပါလျက်၊ မနာရှေ ၊ မာခိရ ၊ ဂိလဒ် ၊ ဟေဖေရ တို့မှ ဆင်းသက်သော ဇလောဖဒ် ၏သမီး မာလာ ၊ နောအာ ၊ ဟောဂလာ ၊ မိလကာ ၊ တိရဇာ တို့သည်လာ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ပရိသတ်စည်းဝေး ရာ တဲ တော်တံခါး နား၊ မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ ၊ မင်း များ၊ ပရိသတ် များအပေါင်း တို့ ရှေ့မှာ ရပ် လျက်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","အကျွန်ုပ် တို့၏အဘ သည် တော ၌ သေ ပါ၏။ ထာဝရဘုရား တဘက် ၌ စုဝေး သော အပေါင်းအသင်း ၊ ကောရ ၏အပေါင်းအသင်း ၌ မ ပါ။ မိမိ အပြစ် ကြောင့် သေ ပါ၏။ သူ ၌ သား ယောက်ျား မ ရှိ ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ထိုသို့ သား ယောက်ျားမ ရှိ သောကြောင့် ၊ အကျွန်ုပ် တို့အဘ ၏ အမည် သည် အကျွန်ုပ်တို့အဆွေအမျိုး ၌ ပျောက် ရပါမည်လော။ အကျွန်ုပ် တို့အဘ ၏ ညီအစ်ကို တို့နှင့်အတူ ၊ အကျွန်ုပ် တို့အား အမွေပေး ပါဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","သူ တို့အမှု ကို မောရှေ သည် ထာဝရဘုရား ရှေ့ တော်၌ ထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ထာဝရဘုရား ကလည်း ၊ ဇလောဖဒ် သမီး တို့၏ စကားသည် လျောက်ပတ် ပေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","အကယ်စင်စစ်သူ တို့အဘ ၏ ညီအစ်ကို တို့နှင့်အတူ အမွေ ခံရသောအခွင့်ကို သူ တို့အား ပေး ရမည်။ သူ တို့အဘ ၏အမွေ ဥစ္စာသည် သူ တို့လက်သို့ ရောက် စေရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ လူ သည် သား ယောက်ျားမ ရှိဘဲသေ လျှင် ၊ သူ ၏အမွေ ဥစ္စာကို သူ ၏သမီး လက်သို့ ရောက် စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","သမီး မ ရှိလျှင် ၊ သူ ၏ အမွေ ဥစ္စာကို သူ ၏ ညီအစ်ကို တို့အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ညီအစ်ကို မ ရှိလျှင် ၊ အမွေ ဥစ္စာကို ဘကြီး ဘထွေးတို့အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ဘကြီး ဘထွေးမ ရှိလျှင် ၊ သူ ၏အဆွေအမျိုး ၌ နီးစပ် ရင်းခြာသော ပေါက်ဘော် အား ပေး ၍ ၊ ထိုသူသည် ပိုင် ရမည်။ ဤရွေ့ကား၊ ထာဝရဘုရား သည် မောရှေ အား မှာထား တော်မူသည်အတိုင်း ၊ ဣသရေလ အမျိုးသား တို့၌ စီရင် ထုံးဖွဲ့ချက်ဖြစ် စေဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","တဖန် ထာဝရဘုရား က၊ သင်သည် ဤ အာဗရိမ် တောင် ပေါ်သို့ တက် လော့။ ဣသရေလ အမျိုးသား တို့ အား ငါပေး သောပြည် ကို ကြည့်ရှု လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","သို့ပြီးမှ ၊ သင် ၏အစ်ကို အာရုန် သည် မိမိ လူမျိုး စည်းဝေး ရာသို့ သွားသကဲ့သို့ ၊ သင် သည်လည်း သွား ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","အကြောင်းမူကား၊ ပရိသတ် တို့သည် ဇိန တော ၊ ကာဒေရှ အရပ်၊ မေရိဘ စမ်းရေ အနား၌ ရုန်းရင်းခတ် ပြု ကြသောအခါ ၊ သင်တို့သည် ငါ့စကား ကို ဆန့်ကျင်ဘက် ပြု၍၊ သူ တို့ရှေ့မှာ ငါ့ကို မရိုမသေ ပြုသော အပြစ်ရှိသည် ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","မောရှေ ကလည်း ၊ ထာဝရဘုရား ၏ ပရိသတ် တို့သည် အထိန်း မ ရှိသော သိုး ကဲ့သို့ မ ဖြစ် မည် အကြောင်း ၊ ခပ်သိမ်း သော သတ္တဝါ တို့၏ အသက် ဝိညာဉ် ကို အစိုးရတော်မူသောဘုရားသခင် ထာဝရဘုရား သည်၊ ဤပရိသတ် တို့ရှေ့၌ ထွက် ဝင် နိုင်သောသူ ၊ ပြင် သို့ ထုတ် ခြင်း၊ အတွင်း သို့ သွင်းခြင်းအမှုကို တတ်နိုင်သောသူ တစုံတယောက် ကို သူ တို့အပေါ် မှာ ခန့်ထား တော်မူပါစေသောဟု ထာဝရဘုရား အား လျှောက် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ထာဝရဘုရား ကလည်း ၊ ဝိညာဉ် တော်ကိုရသော နုန် ၏သား ယောရှု ကိုခေါ် ၍ ၊ သင် ၏လက် ကို သူ့ အပေါ် မှာတင် လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ယဇ်ပုရောဟိတ် ဧလာဇာ ရှေ့ ၊ ပရိသတ် အပေါင်း တို့ရှေ့၌ သူ့ ကိုထား ၍ မှာ ခဲ့လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ဣသရေလ အမျိုးသား အပေါင်း တို့သည်၊ သူ၏ စကားကို နားထောင် မည်အကြောင်း ၊ သင် ၏ ဘုန်း အသရေအချို့ ကို သူ့ အပေါ် ၌ တင် ထားလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ထိုသူသည်ယဇ်ပုရောဟိတ် ဧလာဇာ ရှေ့မှာ ရပ် သောအခါ ၊ ယဇ်ပုရောဟိတ်သည် ထာဝရဘုရား ရှေ့ တော်၌ ဥရိမ် စီရင် ဆုံးဖြတ်သော တရားအတိုင်း၊ သူ့ အတွက် မေးမြန်း ရမည်။ သူ စီရင် သည်အတိုင်း ၊ သူ နှင့်အတူ ဣသရေလ အမျိုးသား ပရိသတ် အပေါင်း တို့ သည် ထွက် ဝင် ရကြမည်ဟု ထာဝရဘုရား သည် မောရှေ အား မှာထား တော်မူသည်အတိုင်း မောရှေ ပြု လျက်၊ ယောရှု ကိုခေါ် ၍ ယဇ်ပုရောဟိတ် ဧလာဇာ ရှေ့ ၊ ပရိသတ် အပေါင်း တို့ရှေ့၌ ထား ပြီးလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","သူ့ အပေါ် မှာလက် ကိုတင် ၍ မှာ ခဲ့လေ၏။ ထိုသို့ ထာဝရဘုရား သည်မောရှေ အားဖြင့် ပညတ် ထားတော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","တဖန် မောရှေ အား ထာဝရဘုရား က၊ ");
INSERT INTO myajvb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","သင်သည် ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို ရမည်မှာ၊ ငါ ၏ပူဇော် သက္ကာကို၎င်း၊ ငါ့ အဘို့ မွှေးကြိုင် သောအနံ့ ရှိစေခြင်းငှာမီး ဖြင့်ပြုသောငါ ၏ အစာ အာဟာရကို၎င်း၊ အချိန်တန် မှ ငါ့ အား ပူဇော် ခြင်းငှာ သတိပြု ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","တဖန် ဆင့်ဆို ရမည်မှာ၊ နေ့ တိုင်းအစဉ်အမြဲ မီးရှို့ ရာယဇ်ဘို့၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် နှစ် ကောင်ကို ထာဝရဘုရား အား မီး ဖြင့်ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","နံနက်ယံ ၌ သိုးသငယ် တ ကောင်၊ ညဦးယံ ၌ တ ကောင်ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","သံလွင်သီးကို ထောင်း ၍ရသောသံလွင်ဆီ သုံး လောဃနှင့် ရော သော မုန့်ညက် တဩမဲကို လည်း ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ဤရွေ့ကား၊ သိနာ တောင် ပေါ်မှာ စီရင် တော်မူ သည်အတိုင်း၊ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ နှင့် မီး ဖြင့်ပြုသောပူဇော်သက္ကာ၊ အစဉ်အမြဲ ပြု ရသောမီးရှို့ ရာယဇ်ဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","သိုးသငယ် တ ကောင်နှင့်အတူ သွန်းလောင်း ရာ ပူဇော်သက္ကာဘို့၊ စပျစ်ရည် သုံး လောဃကို ပူဇော်၍၊ သန့်ရှင်း ရာဌာန၌ သွန်းလောင်း ရာ ပူဇော်သက္ကာဘို့၊ ထာဝရဘုရား အား သွန်းလောင်း ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","အခြား သော သိုးသငယ် ကို ညဦးယံ ၌ ပူဇော် သောအခါ ၊ နံနက်ယံ ၌ ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာပါသည်နည်းတူ ပါလျက်၊ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ နှင့် ပြည့်စုံ၍ မီး ဖြင့်ပူဇော်သော ယဇ်ကို ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","နေ့ တိုင်း အစဉ်ပူဇော်သော မီးရှို့ ရာယဇ်၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ဥပုသ် နေ့ ရက်၌ အခါမလည် အပြစ် မပါသော သိုးသငယ် နှစ် ကောင်ကို၎င်း၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာပါလျက်၊ ဘောဇဉ် ပူဇော်သက္ကာဘို့၊ ဆီ ရော သောမုန့်ညက် နှစ် ဩမဲကို၎င်း ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","လဆန်း တရက်နေ့၌ ၊ အသက်ပျို သော နွားထီး နှစ် ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် ၊ အပြစ် မပါသော သိုးသငယ်ခုနစ် ကောင်တို့ကို၊ ထာဝရဘုရား အား မီးရှို့ ရာယဇ်ပြု၍ ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","နွား တ ကောင်အဘို့၊ ဆီ ရော သော မုန့်ညက် သုံး ဩမဲ၊ သိုး တ ကောင်အဘို့၊ ဆီ ရော သော မုန့်ညက် နှစ် ဩမဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","သိုးသငယ် တ ကောင်အဘို့၊ ဆီ ရော သော မုန့်ညက် တ ဩမဲစီတည်းဟူသောဘောဇဉ် ပူဇော်သက္ကာနှင့်တကွ၊ ထာဝရဘုရား အား မီး ဖြင့်ပူဇော်၍ မီးရှို့ ရာ ယဇ်ကို ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","သွန်းလောင်း ရာ ပူဇော်သက္ကာဘို့ကား၊ နွား တကောင်နှင့် စပျစ်ရည်ခြောက် လောဃ၊ သိုး တကောင်နှင့် လေး လောဃ၊ သိုးသငယ် တကောင်နှင့် သုံး လောဃ ကို ပူဇော်ရမည်။ ထိုသို့ လ တိုင်း အစဉ်မပြတ်မီးရှို့ ရာ ယဇ်ကို ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","နေ့ တိုင်းအစဉ်ပူဇော်သော မီးရှို့ ရာယဇ်၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ ထာဝရဘုရား အား ဆိတ်သငယ် တ ကောင်ကိုလည်း ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ပဌမ လ တဆယ် လေး ရက် နေ့၌ ၊ ထာဝရဘုရား ၏ ပသခါ ပွဲဖြစ်၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","၎င်း လ တဆယ် ငါး ရက် နေ့၌ ပွဲ ကိုခံရမည်။ ခုနစ် ရက် ပတ်လုံးတဆေးမဲ့ မုန့်ကို စား ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ပဌမ နေ့ ၌ ဓမ္မ စည်းဝေးခြင်းကို ပြုရမည်။ လောကီ အလုပ်ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ထာဝရဘုရား အား မီး ဖြင့်ပြုသောယဇ်တည်းဟူသောအသက်ပျို သော နွားထီး နှစ် ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ခုနစ် ကောင်တို့ကို မီးရှို့ ရာယဇ်ပြု၍ ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","နွား တကောင်လျှင် ဆီ ရော သော မုန့်ညက် သုံး ဩမဲ၊ သိုး တကောင်လျှင် နှစ် ဩမဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","သိုးသငယ် ခုနစ် ကောင်စေ့အောင်၊ တ ကောင်လျှင် တ ဩမဲစီနှင့် ဘောဇဉ် ပူဇော်သက္ကာပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှာ ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ် တ ကောင်ကိုလည်း ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","နေ့ ရက်အစဉ် နံနက် တိုင်းပူဇော်သော မီးရှို့ ရာ ယဇ်မှတပါး ၊ ထို ယဇ်များကို ထပ်၍ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ထိုသို့ အစဉ်အမြဲ ပူဇော် သောမီးရှို့ ရာယဇ်၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ခုနစ် ရက် ပတ်လုံးတနေ့ တနေ့လျှင် ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ နှင့် မီး ဖြင့်ပြုသောပူဇော်သက္ကာအစာ အာဟာရကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","သတ္တမ နေ့ ၌ လည်း ၊ ဓမ္မ စည်းဝေးခြင်းကို ပြု ရ မည်။ လောကီ အလုပ်ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ထိုမှတပါး ၊ သိတင်း ခုနစ်သိတင်းစေ့ပြီးမှ၊ ဘောဇဉ် ပူဇော်သက္ကာအသစ် ကို ထာဝရဘုရား ထံ တော် သို့ ဆောင် ခဲ့သောနေ့၊ အဦး သီးသောအသီး နေ့ ရက်၌ ဓမ္မ စည်းဝေးခြင်းကို ပြု ရမည်။ လောကီ အလုပ်ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ နှင့် မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး နှစ် ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် သော သိုးသငယ် ခုနစ် ကောင်တို့ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","နွား တ ကောင်လျှင် ဆီ ရော သောမုန့်ညက် သုံး ဩမဲ၊ သိုး တ ကောင်လျှင် နှစ် ဩမဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","သိုးသငယ် ခုနစ် ကောင်စေ့အောင်၊ တ ကောင်လျှင် တ ဩမဲစီနှင့် ဘောဇဉ် ပူဇော်သက္ကာပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှါ ၊ ဆိတ်သငယ် တ ကောင်ကိုလည်း ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ထိုသို့ အစဉ်အမြဲ ပူဇော်သော မီးရှို့ ရာယဇ်၊ ဘောဇဉ် ပူဇော်သက္ကာမှတပါး ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာနှင့်တကွ ၊ အပြစ် မပါသော ယဇ်ကောင်များတို့ကို ထပ်၍ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","သတ္တမ လ ၊ ပဌမ နေ့ရက်၌ ဓမ္မ စည်းဝေးခြင်းကို ပြု ရမည်။ လောကီ အလုပ်ကို မ လုပ် ရ။ တံပိုးမှုတ် ခြင်းကို ပြုရသောနေ့ ဖြစ် ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ နှင့် မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ခုနစ် ကောင်တို့ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","နွား တကောင်လျှင် ဆီ ရော သောမုန့်ညက် သုံး ဩမဲ၊ သိုး တကောင်လျှင် နှစ် ဩမဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","သိုးသငယ် ခုနစ် ကောင်စေ့အောင်၊ တ ကောင်လျှင် တ ဩမဲစီနှင့်ဘောဇဉ် ပူဇော်သက္ကာပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","အပြစ် ဖြေခြင်းကို ပြုအံ့သောငှါ ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်ကိုလည်း ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ထိုသို့ ထုံးစံ ရှိသည့်အတိုင်း ၊ လဆန်း နေ့မီးရှို့ ရာ ယဇ်နှင့် သူ ၏ဘောဇဉ် ပူဇော်သက္ကာ၊ နေ့ တိုင်းပြုသောမီးရှို့ ရာယဇ်နှင့် သူ ၏ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ နှင့် မီး ဖြင့်ပြုသောယဇ်ပူဇော်သက္ကာကို ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","၎င်း လ ၊ ဒသမ နေ့ရက်၌ ဓမ္မ စည်းဝေးခြင်းကို ပြု ၍ ခြိုးခြံ စွာကျင့် ရမည်။ အဘယ် အလုပ် ကိုမျှ မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ထိုနေ့၌ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သောအနံ့ နှင့် မီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ခုနစ် ကောင်တို့ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","နွား တကောင်လျှင် ဆီ ရော သောမုန့်ညက် သုံး ဩမဲ၊ သိုး တ ကောင်လျှင်နှစ် ဩမဲ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","သိုးသငယ် ခုနစ် ကောင်စေ့အောင်၊ တ ကောင်လျှင် တ ဩမဲစီနှင့်ဘောဇဉ် ပူဇော်သက္ကာပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","အပြစ်ဖြေခြင်းကို ပြုအံ့သောငှါ၊ အပြစ် ဖြေရာ ယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်ကို ပူဇော်ရမည်။ ထိုသို့ အပြစ် ဖြေခြင်းငှါအပြစ် ဖြေရာယဇ်၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်၊ သူ ၏ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ထပ်၍ပြုရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","၎င်း လ တဆယ် ငါး ရက် နေ့၌ ဓမ္မ စည်းဝေးခြင်းကို ပြု ရမည်။ လောကီ အလုပ်ကို မ လုပ် ဘဲ ခုနစ် ရက် ပတ်လုံးထာဝရဘုရား အဘို့ ပွဲ ခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ပဌမနေ့၌ ထာဝရဘုရား အဘို့ မွှေးကြိုင် သော အနံ့ နှင့် မီး ဖြင့်ပြုသောမီးရှို့ ရာယဇ်ဘို့ အသက်ပျို သော နွားထီး ဆယ် သုံး ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်တို့ကို ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","နွား ဆယ် သုံး ကောင်စေ့အောင်၊ တ ကောင်လျှင် ဆီ ရော သောမုန့်ညက် သုံး ဩမဲစီ၊ သိုး နှစ် ကောင်စေ့ အောင်၊ တ ကောင်လျှင် နှစ် ဩမဲစီ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","သိုးသငယ် ဆယ် လေး ကောင်စေ့အောင်၊ တ ကောင်လျှင် တ ဩမဲစီနှင့် ဘောဇဉ် ပူဇော်သက္ကာပြုရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်ကို အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ဒုတိယ နေ့ ၌ ၊ အသက်ပျို သော နွားထီး ဆယ် နှစ် ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","တတိယ နေ့ ၌ ၊ နွားထီး ဆယ် တ ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","စတုတ္ထ နေ့ ၌ နွားထီး ဆယ် ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ပဉ္စမ နေ့ ၌ နွားထီး ကိုး ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ်သငယ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ဆဌမ နေ့ ၌ ၊ နွားထီး ရှစ် ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","သတ္တမ နေ့ ၌ နွားထီး ခုနစ် ကောင်၊ သိုးထီး နှစ် ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ဆယ် လေး ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော်ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","အဌမ နေ့ ၌ ဓမ္မစည်းဝေး ခြင်းကိုပြု ရမည်။ လောကီ အလုပ်ကို မ လုပ် ရ။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ထိုနေ့၌ ထာဝရဘုရား ဘို့ မွှေးကြိုင် သော အနံ့ နှင့် မီး ဖြင့်ပြုသော မီးရှို့ ရာယဇ်ဘို့ နွားထီး တ ကောင်၊ သိုးထီး တ ကောင်၊ အခါမလည် အပြစ် မပါသော သိုးသငယ် ခုနစ် ကောင်ကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","သိုး ၊ နွား ၊ သိုးသငယ် အနည်း အများအလိုက် ၊ ထုံးစံ ရှိသည်အတိုင်း ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာကို၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","အပြစ် ဖြေရာယဇ်ဘို့ ဆိတ် တ ကောင်ကို၎င်း၊ အစဉ်အမြဲ ပြုသော မီးရှို့ ရာယဇ်နှင့် ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာ ပူဇော်သက္ကာမှတပါး ၊ ထပ်၍ပူဇော် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","ထိုသို့ သစ္စာ ဂတိရှိ၍ ပြုသောပူဇော်သက္ကာ၊ အလိုလို ပြုသော ပူဇော်သက္ကာ၊ မီးရှို့ ရာပူဇော်သက္ကာ၊ ဘောဇဉ် ပူဇော်သက္ကာ၊ သွန်းလောင်း ရာပူဇော်သက္ကာ၊ မိဿဟာယ ပူဇော်သက္ကာမှတပါး၊ ချိန်းချက် သော ပွဲတို့၌ ထာဝရဘုရား အား ထပ်၍ပူဇော် ရမည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ထိုသို့ မောရှေ သည်၊ မိမိအား ထာဝရဘုရား မှာထား တော်မူသမျှ တို့ကို၊ ဣသရေလ အမျိုးသား တို့အား ဆင့်ဆို လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","တဖန် ထာဝရဘုရား မိန့် တော်မူသော စကား ကို မောရှေ သည်၊ ဣသရေလ အမျိုးသား တို့တွင် အမျိုးအနွယ် တို့၌ မင်း ဖြစ်သောသူတို့အား ဆင့်ဆို သည်ကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","လူ ယောက်ျားသည် ထာဝရဘုရား အား သစ္စာ ဂတိပြုသော်၎င်း ၊ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် ၍ ကျိန်ဆို ခြင်းကို ပြုသော်၎င်း၊ မိမိ ပြောသောစကား ကို မ ဖျက် ဘဲ၊ မိမိ နှုတ် ထွက် ရှိသည်အတိုင်း ပြု ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","မိန်းမ သည် အဘ အိမ် ၌ အသက် ငယ်စဉ်အခါ၊ ထာဝရဘုရား အား သစ္စာ ဂတိပြုသော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ထိုသစ္စာ စကား၊ ကိုယ် စိတ် ဝိညာဉ်၌ ချည်နှောင် သော စကားကို အဘ သည် ကြား လျက် တိတ်ဆိတ် စွာ နေလျှင် ထိုသစ္စာ စကားရှိသမျှ တို့နှင့် ကိုယ် စိတ် ဝိညာဉ်၌ ချည်နှောင် သော စကားဟူသမျှ တို့သည် တည် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","သို့မဟုတ် အဘ သည် ကြား သောနေ့ ၌ မြစ်တား လျှင်၊ ထိုသစ္စာ စကားမည်မျှ၊ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် သော စကား မည်မျှမ တည် ရ။ အဘ မြစ်တား သောကြောင့် ၊ ထာဝရဘုရား လွှတ် တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","မိန်းမသည် လင် ရှိ လျက်၊ သစ္စာဂတိ ပြု၍ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် ခြင်းငှာနှုတ် မြွက် သောအခါ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","လင် သည် ကြား လျှင် ၎င်း၊ ကြား သောနေ့ ၌ တိတ်ဆိတ် စွာနေလျှင်၎င်း၊ ထိုသစ္စာ စကား၊ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် သော စကား တည် ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","သို့မဟုတ် လင် သည် ကြား သောနေ့ ၌ မြစ်တား လျှင် ၊ ထိုသစ္စာ စကား၊ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် သော စကားကို လင်သည်ပယ် ၍ ၊ ထာဝရဘုရား လည်း လွှတ် တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","လင် သေသောမိန်းမ၊ လင်နှင့်ကွာ သော မိန်းမသည် ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် သော သစ္စာ ဂတိ အလုံးစုံ တို့သည် တည် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","လင် အိမ် ၌ ရှိစဉ်အခါ၊ သစ္စာ ဂတိပြုသော်၎င်း ၊ ကျိန်ဆို ခြင်းအားဖြင့် ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် သော်၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","လင် သည် ကြား သော်လည်း မ မြစ်တား တိတ်ဆိတ် စွာနေလျှင် ၊ ထိုသစ္စာ ဂတိရှိသမျှ ကိုယ်စိတ် ဝိညာဉ်၌ ချည်နှောင် ခြင်းရှိသမျှ တို့သည် တည် ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","သို့မဟုတ် လင် သည် ကြား သောနေ့ ၌ ရှင်းရှင်းပယ် ဘူးလျှင် ၊ သစ္စာ ဂတိနှင့်၎င်း ၊ စိတ် ဝိညာဉ်၌ ချည်နှောင် ခြင်းနှင့်၎င်း ဆိုင်သော စကား မည်မျှမ တည် ရ။ လင် သည် ပယ် သောကြောင့် ၊ ထာဝရဘုရား လည်း လွှတ် တော်မူမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ခပ်သိမ်း သောသစ္စာ ဂတိ၊ ခြိုးခြံ စွာကျင့် ခြင်းနှင့် ဆိုင်သမျှ သောအချည်အနှောင် ကျိန်ဆို ခြင်းတို့ကို၊ လင် သည် တည် စေပိုင်သောအခွင့်၊ ပယ် ပိုင်သော အခွင့်ရှိ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","လင် သည် တနေ့ ထက်တနေ့တိတ်ဆိတ် စွာနေ လျှင် ၊ မယား ပြုသောသစ္စာ ဂတိရှိသမျှ တို့နှင့် မယား ၌ ချည်နှောင် ခြင်း ရှိသမျှ တို့ကို တည် စေ၏။ ကြား သောနေ့ ၌ တိတ်ဆိတ် စွာ နေသောကြောင့် တည် စေပြီ။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ထိုစကားကို ကြား သောနေ့နောက်မှ ၊ လင်သည် ပယ် အံ့သောငှါပြုလျှင် ၊ မယား အပြစ် ကို ကိုယ်တိုင်ခံရ မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ဤရွေ့ကား ၊ မယား နှင့်လင် စပ်ကြား ၌၎င်း၊ အဘ အိမ် မှာ အသက် နုငယ်သောသမီး နှင့် အဘ စပ်ကြား ၌၎င်း၊ မောရှေ အားဖြင့်ထာဝရဘုရား ထား တော်မူသော ပညတ် တရားဖြစ်သတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","တဖန် ထာဝရဘုရား က၊ မိဒျန် အမျိုးသားတို့ သည် ဣသရေလ အမျိုးသား တို့ကို ပြစ်မှား သောအပြစ် အလျောက်ဣသရေလအမျိုးသားဘက်၌ နေ၍ တရား စီရင်လော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","သို့ပြီးမှ သင်သည် မိမိ လူမျိုး စည်းဝေး ရာသို့ သွားရမည်ဟု မောရှေ အား မိန့် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","မောရှေ သည်လည်း လူ များတို့ကိုခေါ်၍၊ အချို့တို့သည် လက်နက် ကို ကိုင်လျက်၊ မိဒျန် အမျိုးသားတို့သို့ စစ် ချီ ၍ ထာဝရဘုရား ဘက်၌ တရား စီရင်စေ။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ဣသရေလ အမျိုးအနွယ် တို့တွင် တမျိုးတမျိုးထဲက၊ လူတထောင် စီရွေး၍ စစ်ချီ စေဟု စီရင်သည် အတိုင်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ဣသရေလ အမျိုးသားအထောင် အသောင်းတို့ တွင် တမျိုးတမျိုးထဲက၊ စစ်တိုက် လက်နက် ပါသောသူ တထောင် စီ၊ လူပေါင်း တသောင်း နှစ်ထောင်ကို အပ် ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","မောရှေ သည်ထိုသူ တို့ကို၎င်း၊ သန့်ရှင်း သော လက်နက် နှင့်တကွ ၊ မှုတ် ရာတံပိုး တို့ကို ကိုင် သော ယဇ်ပုရောဟိတ် ဧလာဇာ သား ဖိနဟတ် ကို၎င်းစစ် ချီ စေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","မောရှေ အား ထာဝရဘုရား မှာထား တော်မူသည် အတိုင်း ၊ ထိုသူတို့သည် မိဒျန် အမျိုးသားတို့ကို တိုက် ၍ လူယောက်ျား အပေါင်း တို့ကိုသတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","အသေ သတ်ခြင်းကို ခံရသောသူတို့တွင် ဧဝိ ၊ ရေကင် ၊ ဇုရ ၊ ဟုရ ၊ ရေဘ တည်းဟူသောမိဒျန် မင်းကြီး ငါး ပါးပါကြ၏။ ဗောရ သား ဗာလမ် ကိုလည်း ထား နှင့် သတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ဣသရေလ အမျိုးသား တို့သည်၊ မိဒျန် မိန်းမ များ၊ သူငယ် များတို့ကို လက်ရ သိမ်းယူ၍ ၊ သိုး ၊ ဆိတ်၊ နွား အစရှိသော ဥစ္စာ အလုံးစုံ တို့ကို လုယူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","မိဒျန်အမျိုးသားတို့ နေသောမြို့ ရွာရှိသမျှ တို့ကို မီး ရှို့ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ဘမ်းရသောလူ ၊ တိရစ္ဆာန် နှင့်တကွ၊ လက်ရ ဥစ္စာ အလုံးစုံ တို့ကို သိမ်း သွား၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","မောဘ လွင်ပြင် ယော်ဒန် မြစ်နား ၊ ယေရိခေါ မြို့ တဘက်၌ တပ်ချ လျက်နေသောမောရှေ ၊ ယဇ်ပုရောဟိတ် ဧလာဇာ ၊ ဣသရေလ အမျိုးသား ပရိသတ် တို့ထံသို့ ဆောင် ခဲ့ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ မှစ၍ ပရိသတ် တို့၌ မင်း အပေါင်း တို့သည် ကြိုဆို ခြင်းငှာ တပ် ပြင် သို့ ထွက်သွား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","မောရှေ သည် စစ်တိုက် ရာမှ ပြန်လာ သောတပ်မှူး များ၊ ဗိုလ် မင်း များတို့ကို အမျက် ထွက်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","သင်တို့သည် မိန်းမ အပေါင်း တို့ကို အဘယ်ကြောင့်အသက်ရှင် စေကြသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ဣသရေလ အမျိုးသား တို့သည်၊ ပေဂုရ ဘုရားအမှု ၌ ထာဝရဘုရား ကို ပြစ်မှား စေခြင်းငှာ ၊ ဤမိန်းမတို့သည် ဗာလမ် ပေးသောအကြံ ကို လိုက်၍ ပြုကြသောကြောင့်၊ ထာဝရဘုရား ၏ ပရိသတ် ၌ ဘေး ရောက် လေသည် တကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ထိုကြောင့် ၊ သူငယ် ယောက်ျား အပေါင်း ကို၎င်း ၊ ယောက်ျား နှင့် ဆက်ဆံ ဘူးသော မိန်းမ အပေါင်း ကို၎င်း၊ သတ် ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ယောက်ျား နှင့် မ ဆက်ဆံ ဘူးသော မိန်းမငယ် အပေါင်း တို့ကို၊ မိမိ တို့အဘို့ အသက် ချမ်းသာပေးကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","သင် တို့သည် ခုနစ် ရက် ပတ်လုံးတပ် ပြင် မှာ နေ ရကြမည်။ လူကို သတ် သောသူ၊ အသေကောင် ကို ထိ သောသူ အပေါင်း တို့ ကိုယ်ကို၎င်း၊ သိမ်းယူ သောသူတို့ ကို၎င်း၊ တတိယ နေ့ ၊ သတ္တမ နေ့ ၌ စင်ကြယ် စေ ကြလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","သင်တို့အဝတ် နှင့် သားရေ တန်ဆာ ရှိသမျှ ၊ ဆိတ်မွေး ဖြင့် ရက်သောအရာ ၊ သစ်သား ဖြင့် လုပ်သောအရာ ရှိသမျှ တို့ ကို စင်ကြယ် စေကြလော့ဟု မှာထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ယဇ်ပုရောဟိတ် ဧလာဇာ သည်လည်း ၊ စစ်တိုက် သွား သော စစ်သူရဲ တို့ကိုခေါ်၍၊ မောရှေ ၌ ထာဝရဘုရား ထား တော်မူသော ပညတ် တရား ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ရွှေ ၊ ငွေ ၊ ကြေးဝါ ၊ သံ ၊ ကြေးဖြူ ၊ ခဲ အစရှိသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","မီး ကိုခံနိုင် သော အရာ ရှိသမျှ တို့ကို မီး အလယ် ၌ သွား စေ သဖြင့် စင်ကြယ် စေရမည်။ သို့ရာတွင် စင်ကြယ် စေသောရေ ဖြင့် လည်း စင်ကြယ် စေရမည်။ မီး မ ခံနိုင် သော အရာရှိသမျှ တို့ ကို ရေ အလယ် ၌ သွား စေရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","သတ္တမ နေ့ ၌ မိမိ အဝတ် ကို လျှော် ပြီးမှ ၊ စင်ကြယ် ခြင်းရှိ၍ ၊ တပ် ထဲသို့ ဝင် ရကြမည်ဟု မှာထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ထာဝရဘုရား ကလည်း ၊ သင် နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","ပရိသတ် အဆွေအမျိုး သူကြီး တို့သည်၊ ယခု လက်ရ သိမ်းယူ ခဲ့သော ဥစ္စာ၊ လူ ၊ တိရစ္ဆာန် အပေါင်းတို့ကို ယူ ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ထက်ဝက် ခွဲပြီးလျှင်တဝက်ကို စစ်မှုထမ်း ၍ အတိုက် သွားသောသူတို့ အား၎င်း၊ တဝက်ကို ပရိသတ် အပေါင်း တို့အား၎င်း ပေးဝေလော့။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","စစ်တိုက် သွား သော စစ်သူရဲ တို့သည်၊ ထာဝရဘုရား အား ပေး ရသောအခွန် ကို ခွဲ ၍ လူ ၊ နွား ၊ မြည်း ၊ သိုး အကောင်ငါး ရာ တွင် တ ကောင်ကို ကောက်ယူပြီးလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","သူ တို့ခံရသောထက်ဝက် အဘို့ထဲက နှုတ်၍၊ ထာဝရဘုရား ရှေ့တော်၌ ချီမြှောက် ရာ ပူဇော်သက္ကာပြု ဘို့ရာယဇ်ပုရောဟိတ် ဧလာဇာ အား ပေး ရမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ဣသရေလ အမျိုးသား ခံရသောထက်ဝက် အဘို့ထဲက လည်း လူ ၊ နွား ၊ မြည်း ၊ သိုး အစရှိသော တိရစ္ဆာန် မျိုး အကောင်ငါးဆယ် တို့တွင် တ ကောင်ကို ကောက်ယူ ၍ ထာဝရဘုရား ၏ တဲ တော်ကို စောင့် သော လေဝိ သားတို့အား ပေး ရမည်ဟု၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","မောရှေ အား ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ တို့ သည် ပြု လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","စစ်သူရဲ တို့သည် လက်ရ သိမ်းယူ ခဲ့၍ ကျန်ကြွင်း သော ဥစ္စာပေါင်းကား၊ သိုး ခြောက်သိန်း ခုနစ်သောင်း ငါးထောင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","နွား ခုနစ်သောင်း နှစ်ထောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","မြည်း ခြောက်သောင်း တထောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ယောက်ျား နှင့် မ ဆက်ဆံ ဘူးသောမိန်းမ သုံးသောင်း ခုနစ်ထောင်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","စစ်တိုက် သွား သောသူတို့ ခံရသောထက်ဝက် အဘို့ ကား၊ သိုး သုံးသိန်း သုံးသောင်း ခုနစ်ထောင် ငါးရာ ရှိသည်ဖြစ်၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ထာဝရဘုရား ခံရသောအခွန် ကား၊ သိုး ခြောက်ရာ ခုနစ်ဆယ်ငါးကောင်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","နွား သုံးသောင်း ခြောက်ထောင်ရှိသည်ဖြစ်၍၊ ထာဝရဘုရား ခံရသောအခွန် ကား၊ နွားခုနစ်ဆယ် ခုနစ် ကောင်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","မြည်း သုံးသောင်း ငါးရာရှိသည်ဖြစ်၍၊ ထာဝရဘုရား ခံရသောအခွန် ကား၊ မြည်းခြောက်ဆယ် တ ကောင်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","လူ တသောင်း ခြောက်ထောင်ရှိသည်ဖြစ်၍၊ ထာဝရဘုရား ခံရသောအခွန် ကား၊ လူ သုံးဆယ် နှစ် ယောက်တည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ထာဝရဘုရား မှာထား တော်မူသည်အတိုင်း ၊ မောရှေ သည် ရှေ့တော်၌ ချီမြှောက် ရာ ပူဇော်သက္ကာပြု ဘို့ရာအခွန် ကို ယဇ်ပုရောဟိတ် ဧလာဇာ အား အပ် ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","တဖန် စစ်တိုက် သောသူတို့လက်မှ မောရှေ ယူ ၍၊ ဣသရေလ အမျိုးသား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ပရိသတ် တို့ခံရသောထက်ဝက် အဘို့ကား၊ သိုး သုံးသိန်း သုံးသောင်းခုနစ်ထောင်ငါးရာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","နွား သုံးသောင်း ခြောက်ထောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","မြည်း သုံးသောင်း ငါးရာ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","လူ တသောင်း ခြောက်ထောင်ရှိသည်ဖြစ်၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ဣသရေလ အမျိုးသား ခံရသောထက်ဝက် အဘို့ လူ ၊ တိရစ္ဆာန် အကောင်ငါးဆယ် တို့တွင် တ ကောင်ကို မောရှေ ကောက်ယူ ၍ ထာဝရဘုရား ၏ တဲ တော်ကို စောင့် သော လေဝိ သားတို့အား ပေး ၏။ ထိုသို့ ထာဝရဘုရား မှာထား တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","လူတရာ ၊ တထောင် ကိုအုပ်သော တပ်မှူး များ၊ ဗိုလ် များတို့သည်လည်း ၊ မောရှေ ထံသို့ ချဉ်းကပ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ကိုယ်တော် ကျွန် တို့သည် အုပ်သောစစ်သူရဲ တို့ ကို စာရင်း ယူပြန်၍၊ လူတယောက်မျှ မ လျော့ ပါ။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ထိုကြောင့် ထာဝရဘုရား ရှေ့ တော်၌ အသက် အဘိုးကို ဖြေ ဘို့ ရာ လူ အသီးအသီးရ သော ရွှေ တန်ဆာ ၊ လည်ဆွဲ ၊ လက်ကောက် ၊ လက်စွပ် ၊ နားတောင်း ၊ နှာခေါင်းဆွဲ ဘူးတို့ကို ထာဝရဘုရား အား ပူဇော် လျက် ဆောင် ခဲ့ ပါပြီဟု လျှောက်ဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ တို့သည်၊ ထိုရွှေ တည်းဟူသောလုပ် ပြီးသောတန်ဆာ ရှိသမျှ တို့ကိုခံယူ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ထိုသို့ စစ်သူရဲ အသီးအသီး တို့သည် မိမိ တို့အဘို့ သိမ်းယူ ၍၊ ");
INSERT INTO myajvb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","တပ်မှူး များ၊ ဗိုလ် များတို့သည် ထာဝရဘုရား အား ပူဇော် သော ရွှေ ချိန်ပေါင်း ကား၊ တရာ ခြောက်ဆယ်ခုနှစ်ပိဿာနှင့် အကျပ်ငါးဆယ်ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","တပ်မှူး များ၊ ဗိုလ်များ ပူဇော်သောရွှေ ကို မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ တို့သည်ယူ ၍၊ ဣသရေလ အမျိုးသား တို့ကို ထာဝရဘုရား အောက်မေ့ တော်မူဘို့ရာ ပရိသတ်စည်းဝေး ရာတဲ တော်၌ သွင်းထား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ရုဗင် အမျိုးသား နှင့် ဂဒ် အမျိုးသား တို့သည် အလွန် များပြားသော တိရစ္ဆာန် တို့နှင့် ကြွယ်ဝ သည်ဖြစ်၍၊ ယာဇာ ပြည် ၊ ဂိလဒ် ပြည် တို့၌ တိရစ္ဆာန် ကျက်စားစရာဘို့ ကောင်းသည်ကို မြင် ကြလျှင် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","မောရှေ နှင့် ယဇ်ပုရောဟိတ် ဧလာဇာ အစရှိ သော ပရိသတ် တို့တွင် မင်း များတို့ထံသို့ လာ ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","အတရုတ် ၊ ဒိဘုန် ၊ ယာဇာ ၊ နိမရ ၊ ဟေရှဘုန် ၊ ဧလာလေ ၊ ရှေဘံ ၊ နေဗော ၊ ဗောန တည်းဟူသော၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ဣသရေလ ပရိသတ် ရှေ့မှာ ထာဝရဘုရား လုပ်ကြံ တော်မူသော ဤပြည် သည် တိရစ္ဆာန် နှင့် တော်လျော်ပါ၏။ ကိုယ်တော် ကျွန် တို့၌ လည်း တိရစ္ဆာန် များပြားပါ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","သို့ဖြစ်၍ ကျွန်တော်တို့သည် ရှေ့ တော်၌ မျက်နှာရ လျှင် ၊ ဤ ပြည် ကို ကိုယ်တော် ကျွန် တို့အား အပိုင်ပေး တော်မူပါ။ ကျွန်တော် တို့ကို ယော်ဒန် မြစ်တဘက်သို့ ပို့ဆောင် တော်မ မူပါနှင့်ဟု လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","မောရှေ ကလည်း ၊ သင်တို့သည် ဤ အရပ်၌ နေရစ် ၍၊ သင် တို့ညီအစ်ကို များတို့သည် စစ်တိုက် သွား ရမည်လော။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ထာဝရဘုရား ပေး တော်မူသော ပြည် သို့ ဣသရေလ အမျိုးသား တို့သည် မကူး မသွားမည် အကြောင်း၊ သူတို့စိတ် ကို အဘယ်ကြောင့် ဖျက် ကြသနည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ပြည် တော်ကို ကြည့်ရှု စေခြင်းငှါ ၊ သင် တို့အဘ တို့ကို ကာဒေရှဗာနာ အရပ်က ငါ စေလွှတ် သောအခါ ထိုသို့ ပြု ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ဧရှကောလ ချောင်း သို့ သွား ၍ ပြည် တော်ကို ကြည့် မြင်ပြီးမှ၊ ထာဝရဘုရား ပေး တော်မူသော ပြည် သို့ ဣသရေလ အမျိုးသား တို့သည် မ သွား မည်အကြောင်းသူတို့စိတ် ကို ဖျက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ထိုအခါ ထာဝရဘုရား သည် အမျက် တော်ထွက် လျက်၊ အကယ်စင်စစ်အာဗြဟံ ၊ ဣဇာတ် ၊ ယာကုပ် တို့ အား ငါကျိန်ဆို ၍ ပေးသောပြည် ကို၊ အဲဂုတ္တု ပြည်မှ ထွက်လာ သောသူတို့တွင် ကေနက် အမျိုး ယေဖုန္နာ ၏သား ကာလက် နှင့် နုန် ၏သား ယောရှု မှတပါး ၊ အဘယ်သူမျှငါ့ နောက်သို့ လုံးလုံးမ လိုက်သောကြောင့် ၊ အသက် နှစ်ဆယ် လွန် သောသူ တစုံတယောက်မျှ မ မြင် ရ။ ထိုသူ နှစ်ယောက်သာ ထာဝရဘုရား နောက်သို့ လုံးလုံးလိုက်ကြ ပြီဟု ကျိန်ဆို တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ထိုသို့ ထာဝရဘုရား ရှေ့ တော်၌ ဆိုး သောအမှု ကို ပြု သောလူအပေါင်း တို့သည် မ ပျက်စီး မှီတိုင်အောင်၊ ထာဝရဘုရား သည် ဣသရေလ အမျိုးသားတို့ကို အမျက် ထွက် ၍ အနှစ် လေးဆယ် ပတ်လုံးတော ၌ လှည့်လည် စေ တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ယခုမူကား၊ ထာဝရဘုရား သည် ဣသရေလ အမျိုးသားတို့ကို သာ၍ ပြင်းစွာ အမျက် တော်ထွက်စေမည် အကြောင်း၊ သာ၍ ဆိုး သောသူတည်းဟူသောသင်တို့သည် သင် တို့အဘ များကိုယ်စား ပေါ်ထ ကြပြီတကား။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","သင်တို့သည် နောက် တော်သို့မလိုက်ဘဲ လွှဲသွား ကြလျှင် ၊ တဖန် ဣသရေလအမျိုးသားတို့ကို တော ၌ စွန့်ပစ် တော်မူသဖြင့် ၊ သင်တို့သည် ဤ လူမျိုး အပေါင်း ကို ဖျက်ဆီး ကြလိမ့်မည်ဟု ဂဒ် အမျိုးသား ၊ ရုဗင် အမျိုးသား တို့ အား ပြန်ပြော ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ထိုသူတို့သည်၊ အနီးအပါးသို့ချဉ်းကပ် ၍၊ ကျွန်တော်တို့သည် ကျွန်တော် တို့ တိရစ္ဆာန် များအဘို့ ဤ အရပ်၌ သိုး ခြံတို့ကို၎င်း ၊ ကျွန်တော် တို့ သူငယ် များ အဘို့ မြို့ တို့ကို၎င်းတည် ပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","သို့ရာတွင် ဣသရေလအမျိုးသားတို့ကို သူ တို့ နေရာ အရပ်သို့ မ ပို့ မဆောင်မှီတိုင်အောင်၊ ကျွန်တော်တို့သည် လက်နက် ကိုင်လျက် သူတို့ရှေ့မှာ သွား ပါမည်။ ဤပြည် ၌ ကျန်ကြွင်း သေးသော လူတို့ကြောင့် ကျွန်တော် တို့သူငယ် များသည် ခိုင်ခံ့ သောမြို့ ၌ နေ ရပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ဣသရေလ အမျိုးသား အပေါင်းတို့သည် အမွေ ခံရသောမြေကို မ ဝင်စား မှီတိုင်အောင်ကျွန်တော်တို့သည် ကိုယ် အိမ် သို့ မ ပြန် မလာပါ။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ကျွန်တော်တို့သည် ယော်ဒန် မြစ်တဘက် ၌ သူ တို့ နှင့်အတူ အမွေ ကို မ တောင်းမခံပါ။ ကျွန်တော် တို့အမွေ ခံရာမြေသည် ယော်ဒန် မြစ်အရှေ့ ဘက်၌ ကျပါသည်ဟု လျှောက် ပြန်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","မောရှေ ကလည်း ၊ သို့ဖြစ်၍သင်တို့သည် ထာဝရဘုရား ရှေ့ တော်၌ လက်နက် ကိုင်လျက် စစ်တိုက် သွား လျှင် ၎င်း၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ထာဝရဘုရားသည် ရန်သူ တို့ကို ရှေ့ တော်မှ နှင်ထုတ် ၍ ထိုပြည် ကို အောင် တော်မ မူမှီတိုင်အောင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","သင် တို့ရှိသမျှ သည် လက်နက် ကိုင်လျက် ထာဝရဘုရား ရှေ့ တော်၌ ယော်ဒန် မြစ်တဘက်သို့ ကူး သွားလျှင် ၎င်း၊ ထိုနောက်မှ ထာဝရဘုရား ရှေ့၊ ဣသရေလ အမျိုးသားရှေ့၌အပြစ် ကင်းလွတ်လျက်၊ ဤ ပြည် သို့ ပြန်လာ ၍ ထာဝရဘုရား အခွင့်နှင့် အမွေ ခံရ ကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ထိုသို့မ ပြု လျှင် မူကား ၊ သင်တို့သည် ထာဝရဘုရား ကို ပြစ်မှား ခြင်းရှိသည်အတိုင်း ၊ ထိုအပြစ် သည် သင် တို့ကို လိုက် ၍ မှီလိမ့်မည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","သူငယ် များအဘို့ မြို့ တို့ကို၎င်း ၊ သိုး များအဘို့ သိုးခြံ တို့ကို၎င်း၊ တည် လုပ်ကြလော့။ ယခုပြော သမျှ အတိုင်း ပြု ကြလော့ဟုဆိုလျှင်၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ဂဒ် အမျိုးသား နှင့် ရုဗင် အမျိုး တို့က၊ ကိုယ်တော် ကျွန် တို့သည် သခင် မိန့် တော်မူသည်အတိုင်း ပြု ပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ကျွန်တော် တို့ မယား သားသူငယ် များနှင့် သိုး နွား အလုံးစုံ တို့သည် ဤ အရပ်၊ ဂိလဒ် မြို့ တို့၌ နေရစ် ရပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ကိုယ်တော် ကျွန် အပေါင်းတို့မူကား ၊ သခင် မိန့် တော်မူသည်အတိုင်း ၊ လက်နက် ကိုင်လျက် ထာဝရဘုရား ရှေ့ တော်၌ စစ်တိုက် ခြင်းငှါကူး သွားပါမည်ဟု လျှောက်ထား ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ထိုအမှုကြောင့်၊ မောရှေ သည် ယဇ်ပုရောဟိတ် ဧလာဇာ ၊ နုန် ၏သား ယောရှု အစရှိသော ဣသရေလ အမျိုးသား အဆွေအမျိုး သူကြီး များတို့ကို ခေါ် ၍ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ဂဒ် အမျိုးသား နှင့် ရုဗင် အမျိုးသား တို့သည် စစ်တိုက်ခြင်းငှါအသီးအသီးလက်နက် ကိုင်လျက် ထာဝရဘုရား ရှေ့ တော်၌ သင် တို့နှင့်အတူ ယော်ဒန် မြစ်တဘက် သို့ ကူး သွား၍၊ သင်တို့သည် ထိုပြည် ကို အောင် ပြီးလျှင် ၊ ထိုအမျိုးသား တို့အား ဂိလဒ် ပြည် ကို အပိုင် ပေး ရကြမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","သို့မဟုတ် သူတို့သည်လက်နက် ကိုင်လျက် သင် တို့နှင့်အတူ မ ကူး မသွားလျှင် ၊ ခါနာန် ပြည် ၌ သင် တို့တွင် ကိုယ်ပိုင်ရာမြေကို ခံယူ ရကြမည်ဟု မှာထား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ဂဒ် အမျိုးသား နှင့် ရုဗင် အမျိုးသား တို့ကလည်း၊ ထာဝရဘုရား သည် ကိုယ်တော် ကျွန် တို့အား မိန့် တော်မူသည် အတိုင်း ၊ ကျွန်တော်တို့သည် ပြု ကြပါမည်။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ယော်ဒန် မြစ်အရှေ့ ဘက်၌ အမွေ ခံရပါမည်အကြောင်း၊ ကျွန်တော် တို့သည် လက်နက် ကိုင်လျက် ထာဝရဘုရား ရှေ့ တော်၌ ခါနာန် ပြည် သို့ ကူး သွားပါမည် ဟု ပြန်လျှောက် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ထိုအခါ မောရှေ သည် အာမောရိ ရှင်ဘုရင် ရှိဟုန် ၏ နိုင်ငံ ဆိုင်သမျှ၊ ဗာရှန် ရှင်ဘုရင် ဩဃ ၏ နိုင်ငံ ဆိုင်သမျှသောနယ်မြေ မြို့ ရွာတို့ကို ဂဒ် အမျိုးသား ၊ ရုဗင် အမျိုးသား ၊ ယောသပ် ၏သား မနာရှေမှ ဆင်းသက်သော မနာရှေ အမျိုးသား တဝက် ၌ အပ် ပေးလေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ဂဒ် အမျိုးသား တို့သည် ဒိဗုန် ၊ အတရုတ် ၊ အာရော် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","အာတရုတ် ၊ ရှောဖန်၊ ယာဇာ ၊ ယုမ္ဘေဟ ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ဗက်နိမရာ ၊ ဗေသာရန် မြို့ များကို၎င်း ၊ သိုး ခြံများ ကို၎င်းတည် လုပ်ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ရုဗင် အမျိုးသား တို့သည် ဟေရှဘုန် ၊ ဧလာလေ ၊ ကိရယသိမ် ၊ ");
INSERT INTO myajvb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","နေဗော ၊ ဗာလမောန ၊ ရှိဗမ မြို့ များကို အသစ် သောအမည် ဖြင့် သမုတ် ၍ တည် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","မနာရှေ မှ ဆင်းသက်သော မာခိရ အမျိုးသား တို့သည်၊ ဂိလဒ် မြို့သို့ သွား ၍ သိမ်းယူ ပြီးလျှင် ၊ အရင် မြို့သား အာမောရိ လူတို့ကို နှင်ထုတ် ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","မောရှေ သည် ဂိလဒ် မြို့ကို မနာရှေ ၏သား မာခိရ အမျိုးသားတို့အား ပေး ၍ သူတို့သည် နေ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","မနာရှေ အမျိုးသား ယာဣရ သည်လည်း သွား ၍ ဂိလဒ်ရွာ များကို သိမ်းယူ ပြီးမှ ၊ ဟာဝုတ် ယာဣရ အမည် ဖြင့် သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","နောဗာ သည်လည်း သွား ၍ ကေနတ် မြို့ ရွာတို့ကို သိမ်းယူ ပြီးမှ ၊ မိမိ အမည် ဖြင့် နောဗာ မြို့ဟု သမုတ် လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","မောရှေ နှင့် အာရုန် စီရင်၍ အဲဂုတ္တု ပြည် မှ ထွက်လာ သောဣသရေလ အမျိုးသား အလုံးအရင်း တို့ သည် ခရီးသွား ခြင်း အကြောင်းအရာများကို၊ ");
INSERT INTO myajvb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ထာဝရဘုရား အမိန့် တော်အတိုင်း မောရှေ မှတ်သား ၍ ၊ ထို ခရီးသွား ခြင်း အကြောင်းအရာပါသော စာရင်း ဟူမူကား၊ ");
INSERT INTO myajvb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ပဌမ လ တဆယ် ငါး ရက် နေ့၌ ရာမသက် မြို့မှ ထွက်လာ ကြ၏။ ပသခါ ပွဲကို ခံပြီးသောနောက်၊ နက်ဖြန် နေ့၌ ဣသရေလ အမျိုးသား တို့သည် အဲဂုတ္တု လူအပေါင်း တို့ရှေ့မှာ ဝါကြွား သောအခြင်းအရာနှင့် ထွက်လာ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","အကြောင်းမူကား၊ ထာဝရဘုရား ဒဏ်ခတ် တော်မူသောသားဦး အပေါင်း တို့ကို အဲဂုတ္တု လူတို့သည် သင်္ဂြိုဟ် ရကြ၏။ သူ တို့၏ ဘုရား များကိုလည်း ၊ ထာဝရဘုရား သည် တရား စီရင် တော်မူ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ဣသရေလ အမျိုးသား တို့သည် ရာမသက် မြို့မှ ပြောင်း ၍ သုကုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","သုကုတ် အရပ်မှ ပြောင်း ၍ တော စပ် နား ၊ ဧသံ မြို့၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ဧသံ မြို့မှ ပြောင်း ၍ ဗာလဇေဖုန် မြို့ရှေ့မှာ ရှိ သော ပိဟဟိရုတ် မြို့သို့ တဖန် လည်၍ မိဂဒေါလ မြို့ရှေ့၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ပိဟဟိရုတ် မြို့မှ ပြောင်း ၍ ပင်လယ် အလယ် ၌ ရှောက်သွား သဖြင့် ဧသံ တော သို့ ရောက်၍၊ ထိုတော ထဲ၌ သုံး ရက် ခရီး သွား ပြီးလျှင် ၊ မာရ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","မာရ အရပ်မှ ပြောင်း ၍ ရေတွင်း ဆယ် နှစ် တွင်း နှင့် စွန်ပလွံ ပင် ခုနစ်ဆယ် ရှိသောဧလိမ် ရွာသို့ ရောက် ၍ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ဧလိမ် ရွာမှ ပြောင်း ၍ ဧဒုံ ပင်လယ် နားမှာ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ဧဒုံ ပင်လယ် မှ ပြောင်း ၍ သိန် တော ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","သိန် တော မှ ပြောင်း ၍ ဒေါဖကာ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ဒေါဖကာ အရပ်မှ ပြောင်း ၍ အာလုရှ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","အာလုရှ အရပ်မှ ပြောင်း ၍ လူ များသောက် စရာရေ မ ရှိ သော ရေဖိဒိမ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ရေဖိဒိမ် အရပ်မှ ပြောင်း ၍ သိနာ တော ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","သိနာ တော မှ ပြောင်း ၍ ကိဗြုတ်ဟတ္တဝါ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ကိဗြုတ်ဟတ္တဝါ အရပ်မှ ပြောင်း ၍ ဟာဇရုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ဟာဇရုတ် အရပ်မှ ပြောင်း ၍ ရိသမ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ရိသမ အရပ်မှ ပြောင်း ၍ ရိမ္မုန်ဖါရက် ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ရိမ္မုန်ဖါရက် အရပ်မှ ပြောင်း ၍ လိဗန ရွာ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","လိဗန ရွာမှ ပြောင်း ၍ ရိဿ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ရိဿ အရပ်မှ ပြောင်း ၍ ကေဟလာသ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ကေဟလာသ အရပ်မှ ပြောင်း ၍ ရှာဖါ တောင် ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ရှာဖါ တောင် မှ ပြောင်း ၍ ဟာရဒ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ဟာရဒ အရပ်မှ ပြောင်း ၍ မက္ကလုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","မက္ကလုတ် အရပ်မှ ပြောင်း ၍ တာဟတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","တာဟတ် အရပ်မှ ပြောင်း ၍ တာရ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","တာရ အရပ်မှ ပြောင်း ၍ မိသကာ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","မိသကာ အရပ်မှ ပြောင်း ၍ ဟာရှမောန အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ဟာရှမောန အရပ်မှ ပြောင်း ၍ မောသရုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","မောသရုတ် အရပ်မှ ပြောင်း ၍ ဗင်္ယာကန် အရပ် ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ဗင်္ယာကန် အရပ်မှ ပြောင်း ၍ ဟောရဂိဒ်ဂဒ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ဟောရဂိဒ်ဂဒ် အရပ်မှ ပြောင်း ၍ ယုပ္ဘာသ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ယုပ္ဘာသ အရပ်မှ ပြောင်း ၍ ဧဗြောန အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ဧဗြောန အရပ်မှ ပြောင်း ၍ ဧဇယုန်ဂါဗာ အရပ် ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ဧဇယုန်ဂါဗာ အရပ်မှ ပြောင်း ၍ ဇိန တော ၊ ကာဒေရှ အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ကာဒေရှ အရပ်မှ ပြောင်း ၍ ဧဒုံ ပြည် အနား မှာ ဟောရ တောင် ၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ဣသရေလ အမျိုးသား တို့သည် အဲဂုတ္တု ပြည် မှ ထွက် သောနောက်၊ သက္ကရာဇ် လေးဆယ် ၊ ပဉ္စမ လ ပဌမ နေ့ရက်၌ ထာဝရဘုရား အမိန့်တော်ရှိသည်တိုင်း၊ ယဇ်ပုရောဟိတ် အာရုန် သည် ဟောရ တောင် ပေါ်သို့ တက် ၍ အနိစ္စ ရောက်လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","အာရုန် သည် ဟောရ တောင် ပေါ်မှာ အနိစ္စ ရောက်သောအခါ ၊ အသက် တရာ နှစ်ဆယ် သုံး နှစ် ရှိသတည်း။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ခါနာန် ပြည် တောင် ပိုင်း၌ နေ သောခါနနိ ရှင်ဘုရင် အာရဒ် သည် ဣသရေလ အမျိုးသား ရောက် ကြောင်းကို ကြား လေ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","သူတို့သည် ဟောရ တောင် မှ ပြောင်း ၍ ၊ ဇာလမောန အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ဇာလမောန အရပ်မှ ပြောင်း ၍ ပုနုန် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ပုနုန် အရပ်မှ ပြောင်း ၍ ဩဗုတ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ဩဗုတ် အရပ်မှ ပြောင်း ၍ ဣဇာဗာရိမ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ဣဇာဗာရိမ်အရပ်မှ ပြောင်း ၍ ဒိဗုန် ဂဒ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ဒိဗုန် ဂဒ် အရပ်မှ ပြောင်း ၍ အာလမုန်ဒိဗလသိမ် အရပ်၌ စားခန်းချ ကြ၏။ ");
INSERT INTO myajvb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","အာလမုန်ဒိဗလသိမ် အရပ်မှ ပြောင်း ၍ နေဗော တောင်ရှေ့တွင် အ