﻿USE sofia;
DROP TABLE IF EXISTS sofia.mxv_vpl;
CREATE TABLE mxv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mxv_vpl WRITE;
INSERT INTO mxv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ña yoꞌo ku iin tutu nuu ndakondiaꞌvi na xikuu xii xikua Jesucristo, seꞌe xikua ra David, xiꞌin ra Abraham. ");
INSERT INTO mxv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ra suꞌva ke iyoo ña: seꞌe ra Abraham xikuu ra Isaac, ra seꞌe ra Isaac xikuu ra Jacob, ra seꞌe ra Jacob xikuu ra Judá xiꞌin na ñani ra Judá. ");
INSERT INTO mxv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ra seꞌe ra Judá xiꞌin ña Tamar, xikuu ra Fares xiꞌin ra Zara, ra seꞌe ra Fares xikuu ra Esrom, ra seꞌe ra Esrom xikuu ra Aram. ");
INSERT INTO mxv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ra seꞌe ra Aram xikuu ra Aminadab, ra seꞌe ra Aminadab xikuu ra Naasón, ra seꞌe ra Naasón xikuu ra Salmón. ");
INSERT INTO mxv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ra seꞌe ra Salmón xiꞌin ña Rahab yasiꞌi ra xikuu ra Booz, ra seꞌe ra Booz xiꞌin ña Rut yasiꞌi ra xikuu ra Obed, ra seꞌe ra Obed xikuu ra Isaí. ");
INSERT INTO mxv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ra seꞌe ra Isaí xikuu ra rey David, ra seꞌe ra rey David ra kaku xiꞌin ñaꞌa ña xikuu yasiꞌi ra Urías, kuvi ra Salomón va. ");
INSERT INTO mxv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ra seꞌe ra Salomón xikuu ra Roboam, ra seꞌe ra Roboam xikuu ra Abías, ra seꞌe ra Abías xikuu ra Asa. ");
INSERT INTO mxv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ra seꞌe ra Asa xikuu ra Josafat, ra seꞌe ra Josafat xikuu ra Joram, ra seꞌe ra Joram xikuu ra Uzías. ");
INSERT INTO mxv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ra seꞌe ra Uzías xikuu ra Jotam, ra seꞌe ra Jotam xikuu ra Acaz, ra seꞌe ra Acaz xikuu ra Ezequías. ");
INSERT INTO mxv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ra seꞌe ra Ezequías xikuu ra Manasés, ra seꞌe ra Manasés xikuu ra Amón, ra seꞌe ra Amón xikuu ra Josías. ");
INSERT INTO mxv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ra seꞌe ra Josías xikuu ra Jeconías, ra saa tu na ñani ra Jeconías va. Ra tiempo te xindee na yoꞌo ke tiin uꞌvi na Babilonia na Israel ndixaꞌan na xachiñu na. ");
INSERT INTO mxv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ra seꞌe ra Jeconías xikuu ra Salatiel, ra kaku te xa iyoo na ñuu Babilonia ndoꞌo na, ra seꞌe ra Salatiel xikuu ra Zorobabel. ");
INSERT INTO mxv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ra seꞌe ra Zorobabel xikuu ra Abiud, ra seꞌe ra Abiud xikuu ra Eliaquim, ra seꞌe ra Eliaquim xikuu ra Azor. ");
INSERT INTO mxv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ra seꞌe ra Azor xikuu ra Sodoc, ra seꞌe ra Sodoc xikuu ra Aquim, ra seꞌe ra Aquim xikuu ra Eliud. ");
INSERT INTO mxv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ra seꞌe ra Eliud xikuu ra Eleazar, ra seꞌe ra Eleazar xikuu ra Matán, ra seꞌe ra Matán xikuu ra Jacob; ");
INSERT INTO mxv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ra seꞌe ra Jacob xikuu ra José, ra ndixiyo ìi̱ ña María, ra ña María yoꞌo kuvi ña sakaku Jesús, ra nani Cristo va. ");
INSERT INTO mxv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ra na kundaa ini yo, saa chi xa uxi kumi va ichi ke ndakuiña na ndiseꞌe ra Abraham, saa vi ke kaku ra David, ra xa uxi kumi ichi ke ndakuiña tu na ndiseꞌe ra David, ra saa ke tiin uꞌvi na na, ña kuaꞌan na chi Babilonia, ra xa inka tuku va uxi kumi ichi ke ndakuiña na, te xa nandiko na ndaxaa na ñuu na, ra saa vi ke kaku Jesús ra kuu seꞌe Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ra suꞌva ke kuu te kaku Jesucristo: Ña María siꞌi ra, ra ña kuaan va kuvi ña, ra ña sakan chitaꞌan tuꞌun va kuvi ña xiꞌin ra José ña tandaꞌa ña xiꞌin ra. Ra te kuni ka tiandiaa kii ña tandaꞌa na, ra tuꞌva ndikee va seꞌe ña xiꞌin ndiee Tachi Yii Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ra ra José ra tandaꞌa ña xiꞌin, ra vaꞌa ni tiaa kuvi ra, xaꞌa ña kan ke ndixïin ra ña na kundaa ini takundiꞌi yuvi xaꞌa ña ña ñuꞌu seꞌe ña, ña kan ke vaꞌa ka yayaa na ndakoo va ra ña, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ra saa ndakanduꞌu ra kusun ra, ra xaꞌa ra ndakani ini ra ña ndakoo ra ña ^káꞌán ra, ra saa kixi va iin ra tatun Ndioxi ña saxani ra ra, ra ndikaꞌan ra kachi ra saa xiꞌin ra: ―José, seꞌe xikua ra David, kuayüꞌvi ini kun ña ndakiꞌin kun ña María koo ña yasiꞌi kun, saa chi seꞌe ña, ra xiꞌin ndiee Tachi Yii Ndioxi va ke ndikee ña. ");
INSERT INTO mxv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ra tiaa loꞌo kuu seꞌe ña ra kaku, ra JESÚS ke chinduꞌu kun kivi ra, ra saa ke kunani ra, saa chi ra yoꞌo kuvi ra sakaku na ñuu ra xaꞌa kuachi na ―*kachi ra tatun Ndioxi kan xiꞌin ra José. ");
INSERT INTO mxv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ra takundiꞌi ña yoꞌo ke kuu, ña ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan ra xiꞌin iin ra ndikaꞌan tuꞌun yuꞌu ra xinaꞌa xaꞌa ña kuu ta kachi ra suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Iin ñaꞌa ña kuaan ra kee seꞌe ña, ra tiaa ke kuu seꞌe ña kaku, ra Emanuel ke chinduꞌu na kivi ra. Ra tuꞌun Emanuel yoꞌo, ra Ndioxi kuvi ra iyoo xiꞌin yo ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ra te ndoto ra José ra saa ndakoo ra ndixaꞌan ra ndakiꞌin ra ña María nduu ña yasiꞌi ra, ra iin ta kuꞌva kachi ra tatun Ndioxi kan ña saxani ra ra, ke xa ndixa va ra. ");
INSERT INTO mxv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ndi su ndikïxi na xiꞌin taꞌan na iin saa ndia ta ndixaa kii ña kaku seꞌe ña Maria, ra kuu seꞌe nuu ña ra chinduꞌu ra José kivi ra ña kunani ra JESÚS. ");
INSERT INTO mxv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ra ñuu Belén ña ndikun ndiaa chi Judea kuvi nuu kaku Jesús, ra suvi kuiya kan ke kuu ra Herodes rey ña ^xaꞌndia ra chiñu nuu takundiꞌi ñuu ña ndoꞌni chi kan; ra saa ndixaa sava ndia ndichi ñuu Jerusalén. Ra ndia ndichi kan, ra xika ni kee ndia, saa chi ndia chi nuu kanata ñuꞌu vi ke kee ndia; ra ndia sakuaꞌa xaꞌa takundiꞌi ñaꞌa ña ndee nuu ndivi kuvi ndia, ta kuu kimi xiꞌin ndia ndia ka ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ra saa ndixaa ndia ndindakatuꞌun ndia kachi ndia saa: ―¿Ndia ke ^kanduꞌu ra loꞌo, ra kuu rey na Judío ra sakan kaku? Chi xini ndi kanata kimi ri kaꞌan xaꞌa ra ña kaku ra chi nuu kanata ñuꞌu, ña kan ke vaxi ndi ndasakaꞌnu ndi ra ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ra te kundaa ini ra rey Herodes ña yoꞌo, ra ndiee ni nindiꞌi ini ra, ra iin sana suꞌva ini ra, ra iin saa ndoꞌo takundiꞌi tu na ñuu Jerasalén kan va. ");
INSERT INTO mxv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Saa ndakana ra takundiꞌi ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ra nindakatuꞌun ra ndia, ndia ku ñuu nuu kaku Cristo, ra tiꞌvi Ndioxi xaa sakaku na ñuu yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ra saa ndakuiin ndia kachi ndia saa: ―Ñuu Belén ña ndikun ndiaa Judea yoꞌo kuvi nuu kaku ra; chi saa iyoo tuꞌun ña tiaa iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa. Ra suꞌva ke kachi ña: ");
INSERT INTO mxv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yoꞌo, ñuu loꞌo Belén, ña ndikun ndiaa Judá, ra ñuu chee vaꞌa va kuu kun, xiꞌin ñuu naꞌnu ña ndoꞌni Judá; saa chi ñaa ku nuu kaku iin ra kuchee kaꞌndia chiñu nuu na ñuu yu Israel, ra kunuu ra nuu na, ra kiꞌin ra kuenda xiꞌin na, kachi Ndioxi ndikaꞌan ra, xiꞌin ra ndikaꞌan ndoso tuꞌun ra xinaꞌa ―*kachi ndia xiꞌin ra Herodes. ");
INSERT INTO mxv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Saa ndakana seꞌe ra Herodes ndia ndichi ndia ndixaa kan, ra ndindakatuꞌun ra ndia, ra saa kundaa kaxi ini ra nuu ndia, ndia mii kii kuvi ña xini ndia kanata kimi kan. ");
INSERT INTO mxv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ra te ndiꞌi kundaa ini ra, ra saa tiꞌvi ra ndia kuaꞌan ndia ñuu Belén, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kuaꞌan ndo ra nanduku vaꞌa ndo ra loꞌo kan, ra te xa na ndaniꞌi ndo ra, ra saa sa ndo ña mani ña na ndatuꞌun ndo loꞌo xiꞌin yu, ra kuꞌun tu yuꞌu va ña ndasakaꞌnu yu ra ―*kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ra te ndiꞌi xini soꞌo ndia ña ndikaꞌan ra rey Herodes xiꞌin ndia, ra saa ndakiꞌin ndia kuaꞌan ndia. Ra kimi ri xini ndia kanata ta kee ndia ñuu ndia vaxi ndia, ra ndakunuu tuku va ri nuu ndia kuaꞌan ri xiꞌin ndia, iin saa ndiakua ndixaa ri xikutuvi ri ndia nuu kanduꞌu ra loꞌo kaku kan. ");
INSERT INTO mxv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ra te xini ndia nuu ndixikutuvi kimi kan, ra ndiee ka vi kusii ini ndia. ");
INSERT INTO mxv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ra saa ndixaa ndia ndikiꞌvi ndia ini veꞌe, ra xini ndia ra loꞌo kan xiꞌin ña María, siꞌi ra ndee na, saa ra ndikun xikusiti ndia nuu ra, ña ndasakaꞌnu ndia ra; ra ndakuiña ndia xatun tu ndixaa xiꞌin ndia nuu ñuꞌu oro, xiꞌin xuxa vaꞌa ña yaꞌvi ni, xiꞌin ndutia xaꞌan tami tia nani “mirra” ra ñaꞌa yoꞌo ke ndisoko ndia nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ra te nandiko na kuanuꞌu ndia, ra nindandïko ka ndia chi ñuu Jerusalén ña ndatuꞌun ndia xiꞌin ra rey Herodes, chi xa inka va ichi nandiko ndia kuaꞌan ndia, saa chin saa kachi Ndioxi xiꞌin ndia ña saxani ra ndia ñuu. ");
INSERT INTO mxv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ra te xa ndakiꞌin na ndichi kan kuanuꞌu ndia, ra saa kixi iin ra tatun Ndioxi saxani ra ra José, ra kachi ra saa xiꞌin ra: ―^Ndakoo, ra ndakiꞌin kun ra loꞌo yoꞌo xiꞌin siꞌi ra, ra kunu kuaꞌan xiꞌin na chi ñuu Egipto, ra ikan koo kun xiꞌin na, ra ndia te na kaꞌan tuku yu xiꞌin kun saa nandiko kun, chi kaka nduku ra rey Herodes ra loꞌo yoꞌo ña kaꞌni ñaꞌa ra ―*kachi ra tatun Ndioxi xiꞌin ra José. ");
INSERT INTO mxv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Saa ra ndikun ndakoo va ra José, ra ñuu saa ndakiꞌin ra ra loꞌo kan xiꞌin siꞌi ra, ra ndakiꞌin ra na kuaꞌan na xiꞌin ra chi ñuu Egipto va. ");
INSERT INTO mxv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ra ikan xindee na ndia te nditiandiaa kii ña ndixiꞌi ra rey Herodes va. Ra suꞌva ke kuu, ña ndixinu nuu tuꞌun, ña ndikaꞌan Ndioxi xinaꞌa, xiꞌin iin tiaa ra ndikaꞌan tuꞌun yuꞌu ra, ra suꞌva ke kachi ra: “Chi ñuu Egipto ke ndixaꞌan seꞌe yu ndixiyo ra, ra ndia mii kan ke ndakana yu ra ña na kanata va ra ñuu kan”, kachi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ra te kundaa ini ra Herodes ña sandaꞌvi na ndichi kan ra, saa ra ndiee ni ndisaa ini ra, ra saa xaꞌndia ra chiñu nuu ndia soldado, ra ndixaꞌan ndia xaꞌni ndia takundiꞌi na kuachi vali, na sakan kaku, iin saa ndia na uvi kuiya, na iyoo ñuu Belén xiꞌin takundiꞌi ñuu ña ndoꞌni yachin xiꞌin ña; chi kuꞌva saa ke tava mii ra Herodes kan tiempo xiꞌin tuꞌun ña ndikaꞌan ndia ndichi kan xiꞌin ra, ña kaku Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ra suꞌva ke kuu ña ndixinu nuu tuꞌun Ndioxi ña tiaa ra Jeremías, ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa, ña kachi suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Iin niniꞌi ^kuu tiaku xaku na ñuu Ramá, ra iin siso siso ndaꞌyu na. Ra ña Raquel va kuvi ña xaku ni xaꞌa seꞌe ña, ra xïin ña kaꞌan ndia nii yuvi xiꞌin ña, saa chi seꞌe ña ra xa na ndixiꞌi va kuvi na, kachi Ndioxi ndikaꞌan ra, kachi ra Jeremías. ");
INSERT INTO mxv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ra te xa ndixiꞌi ra rey Herodes, saa ndixaꞌan iin ra tatun Ndioxi saxani ra ra José chi ñuu Egipto, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ndakoo, ra ndakiꞌin kun ra loꞌo yoꞌo xiꞌin siꞌi ra, ra nandiko kun xiꞌin na chi ñuu Israel, chi xa ndixiꞌi va na xika nduku kaꞌni ra loꞌo yoꞌo ―kachi ra tatun Ndioxi xiꞌin ra José. ");
INSERT INTO mxv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ra saa ndakoo ra, ra ndakiꞌin ra ña Maria xiꞌin ra loꞌo kan, ra nandiko na kuanuꞌu na chi Israel. ");
INSERT INTO mxv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ra te kundaa ini ra José xaꞌa ra Arquelao ña xa ndakiꞌin ra xaꞌndia ra chiñu nuu na ñuu Judea ña ndakundichi ra nuu ra Herodes, iva ra, saa ra ndiyuꞌvi va ra ña kuꞌun ra chi kan; ra saa taxi Ndioxi xani nuu ra, ndia chi ke kuꞌun ra, ra saa ndakiꞌin ra kuaꞌan ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ra te ndixaa na ikan, ra saa ndakiꞌin na kuaꞌan na koo na ñuu Nazaret, ra yoꞌo ke ndixinu nuu tuꞌun ña ndikaꞌan ndia ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa: Ña kaꞌan na ña kuu Jesús ra ñuu Nazaret. ");
INSERT INTO mxv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ra saa kuu ndiyaꞌa kuiya ña xa xaꞌnu Jesús, ra ndixaa iin tiaa ra nani Juan ra sakuchi yuvi iku yuu ña ndikaa yachin nuu chi Judea, ra saa xaꞌa ra kaꞌan ndoso ra tuꞌun Ndioxi, ");
INSERT INTO mxv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ra kachi ra saa: ―Nandiko ini ndo xaꞌa kuachi ndo, ra ndakiꞌin ndo ichi Ndioxi, chi xa kuyachin ni ña kaꞌndia Ndioxi chiñu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ra xaꞌa ra Juan yoꞌo ke ndikaꞌan ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, te ndikaꞌan ra kachi ra saa: ^Tiaku kaꞌan ndoso iin tiaa iku yuu ra kachi ra saa: “Ndasavii ndo ichi nuu kixi Tata yo, ra ndasandaku ndo ichi ndo nuu ra”, kachi ra kundikaa iku yuu kan, kachi ra Isaías. ");
INSERT INTO mxv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ra xiꞌin ixi kiti ri nani camello ke kuvaꞌa tikoto ña xindixi ra Juan yoꞌo, ra ñii kiti ke xinuꞌni tu toko va ra, ra ñaꞌa ña xixi ra xitiaku ra xikuu tika ndixaꞌan xiꞌin ñuñu ña iyoo iku. ");
INSERT INTO mxv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ra na ñuu Jerusalén xiꞌin takundiꞌi na ndikun ndiaa Judea, xiꞌin na ndee yachin yuꞌu itia Jordán, kuvi na ndixaꞌan nuu ndixiin ra Juan ña xini soꞌo na ña ndikaꞌan ndoso ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ra na ^nandiko ini, ra ^ndinaꞌma na kuachi na, ra sakuchi ra na itia Jordán. ");
INSERT INTO mxv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ra te xini ra Juan ña kuaꞌa ka vi na fariseo xiꞌin na saduceo ndixa̱a̱ nuu íin ra, ña kuni na ña na sakuchi ra na, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¡Ndoꞌo yuvi ñaꞌa! ¿A xaꞌa ña ndakuchi ndo ke kuchuun ndo kaku ndo xaꞌa kuachi ndo, nuu tundoꞌo ndiee ña vaxi, tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ndi su ña xiniñuꞌu sa ndo ke, na ndañaꞌa ndo mii ndo ña xa nandiko ini ndo xaꞌa kuachi ndo, ra na sa ndo niña ña vaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ra ndakäni ini ndo ña kachi ndo saa xiꞌin mii ndo: “Koo kaꞌnu va ini Ndioxi xaꞌa kuachi yo, chi seꞌe xikua ra Abraham va kuvi yo”, na kachi ndo, ña kutiaa ini ndo xiꞌin mii ndo. Saa chi köo yaꞌvi ndiaa vi ña kan nuu Ndioxi, chi ndia yuu ña ndee yoꞌo ra kuvi va nduu ña yuvi sa Ndioxi, ra nduu na seꞌe ra Abraham va. ");
INSERT INTO mxv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Saa chi Ndioxi ra xa iyoo nduvi va ra xiꞌin yacha ña kaꞌndia ra xaꞌa takundiꞌi itun kuii, ra saa ke koo tu itun tu täxi kuiꞌi ña vaꞌa va, chi kaꞌndia ra nuu, ra koko va nu. ");
INSERT INTO mxv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ra ña ndixa ke yuꞌu, ra xiꞌin tiakuii va ^sakuchi yu ndoꞌo, ña na nandiko ini ndo xaꞌa kuachi ndo, ndi su chi sata vaxi inka ra chee vaꞌa ka nuu yuꞌu, ra ra kan, ra xiꞌin Tachi Yii Ndioxi xiꞌin ñuꞌu va ke sakuchi ra ndoꞌo; ra yuꞌu, ra nii chiñu loꞌo ke köo yaꞌvi ndiaa yu sa yu nuu vi ra, saa chi ndia nii ña kaniꞌi yu ndixan vi ra ke köo ndiayu yu, saa chi ra kaꞌnu ni kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ra xa ra iyoo tuꞌva va kuvi ra yoꞌo ña vaxi ra, chi xa niꞌi va ra pala, ña ndativi ra nuni trigo, ra ndakiꞌin ra nuni vaꞌa ra ndachi vaꞌa ra ña ini yaka, ra yaa nuni yoꞌo kiꞌin ra koꞌni ra nuu xixi ñuꞌu ña tüꞌva ndaꞌva ra koko va ña ―kachi ra Juan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saa kuu iin kii ra kee Jesús chi Galilea ra ndixaa ra ndia yuꞌu itia Jordán, ña na sakuchi ra Juan ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ndi su ra Juan, ra ndixïin ra ña sakuchi ra Jesús, chi suꞌva va kachi ra: ―Yuꞌu va kuvi ra xiniñuꞌu kuchi sa yoꞌo, ndi su yoꞌo, ra nuu yuꞌu va tu vaxi kun; ra väꞌa ñaꞌa ña saa ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ra saa ndakuiin Jesús kachi ra saa: ―Xiniñuꞌu na sakuchi va kun yuꞌu vichin, ra saa ke na saxinu yo nuu takundiꞌi chiñu ña xaꞌndia Ndioxi ―kachi Jesús xiꞌin ra. Ra saa vi ke sakuchi ra ra. ");
INSERT INTO mxv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ra te ndakundichi suꞌva Jesús ña ndikita ra ini tiakuii kan ña chichi ra, ra saa ndanuña ndivi, ra xini ra nduxinu Tachi Yii Ndioxi sata ra; ra ta kaa iin paloma saa kaa ña. ");
INSERT INTO mxv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ra tiaku ndikaꞌan Ndioxi ndia ndivi ninu, kachi ra saa: ―Ra yoꞌo kuvi seꞌe yu, ra kuꞌvi ni ini yu xini yu ra, ra kusii ni ini yu xiꞌin ra ―kachi Ndioxi xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Saa kuu ra ndakiꞌin Tachi Yii Ndioxi Jesús kuaꞌan ra xiꞌin ña chi iku yuu, ra ikan ixtondoso timiaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ra te ndixinu uvi xiko kaꞌñu, xiꞌin uvi xiko ñuu ña ndixiyo suꞌun Jesús, ña ndixïxi ra, ra saa xaꞌa ndikaꞌun ini ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Saa ra kuyachin va timiaꞌa nuu ra ña ixtondoso ri ra, ra ndikaꞌan ri xiꞌin ra kachi ri saa: ―Tu ndixa seꞌe Ndioxi kuvi kun, ra kaꞌan xiꞌin yuu yoꞌo ra na nduu ña ixta kuxi kun ―kachi ri xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ri: ―Tuꞌun Ndioxi ra suꞌva va ke kachi ña: “Süvi ndiakua ixta vi ke kuvi kutiaku yuvi xiꞌin, chi kutiaku tu na ña kandixa na takundiꞌi tuꞌun ña kaꞌan Ndioxi va” ―kachi ra xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Saa ndakiꞌin timiaꞌa kan Jesús kuaꞌan ra xiꞌin ri ñuu yii Jerusalén, ra sandaa ri ra ndia xini veꞌe ñuꞌu nuu sukun vaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ra ndikaꞌan ri xiꞌin ra kachi ri saa: ―Tu ndixa seꞌe Ndioxi kuvi kun ra sandakava mii kun yoꞌo vichin, chi saa kachi tuꞌun Ndioxi: Chi tiꞌvi va ra na tatun ra kixi na ña kondiaa na yoꞌo, ra nuu ndaꞌa va ná ndakava kun, ra täxi na takueꞌe xaꞌa kun sa yuu ―kachi ri xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Saa ndakuiin Jesús kachi ra saa xiꞌin ri: ―Ra kaꞌan tu tuꞌun Ndioxi kachi ña suꞌva va: “Na köto ndoso yuvi Ndioxi” ―kachi ña, kachi ra xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ra saa ndakiꞌin tuku timiaꞌa kan Jesús kuaꞌan ra xiꞌin ri iin koꞌndo sukun vaꞌa, ra ikan ndiñaꞌa ri takundiꞌi ñuu ña iyoo nuu ña yuuvi yoꞌo, xiꞌin takundiꞌi ña kuika nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ra ndikaꞌan ri xiꞌin ra kachi ri saa: ―Ndaꞌa yoꞌo taxi yu takundiꞌi ña yoꞌo, tu na ndakusiti kun nuu yu, ra ndasakaꞌnu kun yuꞌu ―kachi ri xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ra saa ndikaꞌan Jesús xiꞌin ri kachi ra saa: ―Timiaꞌa, kuatiaꞌa nuu yu, saa chi xiniñuꞌu kandixa va yu tuꞌun Tata yu Ndioxi ña kaꞌan ña xiniñuꞌu ndasakaꞌnu yu indaa mituꞌun saa ra kan, ra indaa ra kan tu kandixa va yu, ^kachi ña ―*kachi ra xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndia saa ra ndakoo ri Jesús ra ndakiꞌin ri kuaꞌan va ri, ra saa xaa na tatun Ndioxi ña chindiee taꞌan na xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ra te kundaa ini Jesús ña tiin na ra Juan chikaa na veꞌe kàà, saa ra nandiko ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndi su nindöo ra koo ra ñuu Nazaret, saa chi chi ñuu Capernaum va ndiyaꞌa ra ndixaꞌan ra ndixiyo ra. Ra ñuu kan, ra yachin yuꞌu mini va ke ndikaa ña, ra ikan kuvi nuu iyoo na seꞌe xikua ra Zabulón, xiꞌin ra Neftalí. ");
INSERT INTO mxv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ra suꞌva ke kuu ña ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan ra Isaías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ta kachi ra suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuu nuu iyoo na seꞌe xikua ra Zabulón xiꞌin ra Neftalí, ña ndikaa chi inka xiyo yuꞌu itia Jordán, yachin yuꞌu tiañuꞌu chi Galilea, nuu iyoo kuaꞌa ni na xïni tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yuvi na xika nuu ñaa, ra xini na ndayeꞌe iin ñùꞌù chee; ra na ndee nuu ñaa, na xa ndiatu ini kuvi, ra xini na ndatuun iin ñùꞌù ra ndayeꞌe ña nuu na, kachi ra Isaías. ");
INSERT INTO mxv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ra kii kan xaꞌa Jesús kaꞌan ndoso ra tuꞌun Ndioxi nuu yuvi, kachi ra saa: ―Nandiko ini ndo xaꞌa kuachi ndo ra ndakiꞌin ndo ichi Ndioxi, chi xa kuyachin va ra ña kaꞌndia ra chiñu nuu ndo ―*kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Saa kuu iin kii, ra kee Jesús kuaꞌan ra chi yuꞌu tiañuꞌu ra ndikaa Galilea, ra ikan xini ra uvi tiaa ndia tava tiaka ra koꞌni ndia inu ndia ini tiañuꞌu kan xika ndia; ra ñani va ndia, ra iin ra nani Simón ra kaꞌan tu na Pedro va xiꞌin ra, ra inka ra nani Andrés, ra niña ndia tava tiaka kuvi va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Naꞌa ndo na kuꞌun yo xiꞌin yu, ra sañaꞌa yu ndoꞌo ndia kuꞌva ke ndatuꞌun ndo xiꞌin yuvi ra ndakundikun na yuꞌu ―*kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ndia saa ra ndikun ndakoo ndia inu ndia ña tava ndia tiaka ra ndakundikun ndia kuaꞌan ndia xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ra iin viviꞌi loꞌo ndixaꞌan Jesús, ra saa xini ra inka uvi tuku va ndia, ra ñani tu ndia kan va; ra iin ra nani Jacobo ra inka ra nani Juan, ra ini barca ke ndoꞌni ndia xiꞌin iva ndia ra nani Zebedeo ña ndakaꞌma ndia inu ndia ña tiin ndia tiaka. Ra saa ndikaꞌan Jesús xiꞌin ndia, ña ná kundikun ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Saa ra ndikun ndakoo ndia chiñu ña xa ndia ra nindiayu taꞌan ndia xiꞌin Iva ndia, ra ndakundikun ndia kuaꞌan ndia xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ra iinii kuvi chi Galilea ^xika Jesús sañaꞌa ra yuvi ta veꞌe ñuꞌu ta veꞌe ñuꞌu, ra ^kaꞌan ndoso ra tuꞌun Ndioxi nuu na, ña ^sañaꞌa ra na xaꞌa ichi nuu xaꞌndia chiñu Ndioxi, ra sandaꞌa ra takundiꞌi yuvi na xiꞌi, ndia ndia ka mii nuu kueꞌe va. ");
INSERT INTO mxv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ra iin takundiꞌi ñuu ña ndikun ndiaa ñuu Siria, ndindutia ndoso tuꞌun xaꞌa Jesús, ña kuaꞌa ni ña xituꞌun xa ra, ra iin takundiꞌi na xiꞌi, ra vaxi na xiꞌin na nuu ra. Ra ndia ndia ka mii nuu kueꞌe ke ndoꞌo va na, takuu sava na tiin tachi ndivaꞌa, xiꞌin na kueꞌe na küvi kaka, xiꞌin na xiꞌi yiꞌi, ra yo̱o̱ ka mii kuvi va na, chi iin nduvaꞌa yaa va na xa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ra kuaꞌa ka vi yuvi ndikun kuaꞌan xiꞌin Jesús, na kee chi Galilea, xiꞌin na kee ñuu Decápolis, xiꞌin na kee ñuu Jerusalén, xiꞌin na kee chi Judea, ra saa tu na ndee chi inka xiyo yuꞌu itia Jordán va. ");
INSERT INTO mxv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ra te xini Jesús ña kuaꞌa ni yuvi xaa, ra saa nandaa ra iin koꞌndo ndakunduꞌu ra, ra kuyachin ndia itaꞌan xiꞌin ra nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ra saa xaꞌa ra sañaꞌa ra na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Vaꞌa ni kee ndoꞌo, na nda̱ꞌví, na xini ñuꞌu ndiee Ndioxi nuu vichin, chi kuenda ndoꞌo va ke kuu ndivi nuu xanꞌdia ra chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ra vaꞌa ni kee ndoꞌo, na xáku vichin, chi vaxi kii ra ndoꞌo kuvi ndo kusii ni ini sa Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ra vaꞌa ni kee tu ndoꞌo, na vita ni ini vichin, chi ndoꞌo kuvi na ndakiꞌin ñuꞌú ña ndikaꞌan Ndioxi taxi ra. ");
INSERT INTO mxv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ra vaꞌa ni kee tu ndoꞌo, na kaꞌun ini nima vichin, ra ndachi ini ndo ña kuni ndo kuni soꞌo ndo ña kaꞌan Ndioxi, chi vaxi kii ra kuni va soꞌo ndo tuꞌun ra. ");
INSERT INTO mxv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ra vaꞌa ni kee ndoꞌo, na ndaꞌvi ni ini vichin, chi ndoꞌo kuvi ndo kundaꞌvi ni ini Ndioxi kuni ra. ");
INSERT INTO mxv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ra vaꞌa ni kee ndoꞌo, na ndakú nima, chi ndoꞌo kuvi ndo kuni nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ra vaꞌa ni kee tu ndoꞌo, na ndachutaꞌan mani yuvi na kanitaꞌan va, saa chi ndoꞌo kuvi ndo kunani seꞌe Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ra vaꞌa ni kee tu ndoꞌo, na kundivaꞌa na xiꞌin xaꞌa ña xa ndo ña vaꞌa ña kuni Ndioxi, chi ndoꞌo kuvi ndo niꞌi taꞌvi koo xiꞌin Ndioxi nuu xaꞌndia ra chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ra vaꞌa ni kee ndo, te kañaꞌa na xiꞌin ndo, ra kani taꞌan na xiꞌin ndo, ra xavaꞌa ini na tuꞌun chiꞌña xaꞌa ndo, xaꞌa ña ndikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ra te xá na suꞌva xiꞌin ndo, ra na kusii ni ini ndo, chi ndivi ninu iyoo iin ña chee ni niꞌi ndo sa Ndioxi; ra na kuayüꞌvi ndo, chi saa xa tu na xiꞌin na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndoꞌo kuvi ndo iyoo ta kuꞌva iyoo ñi̱i̱ ña xa uꞌva ña yuuvi yoꞌo, ra tu ná ndiꞌi xaꞌa ñi̱i̱, ra üꞌva ka koo ña. Saa ra, ¿ndixaa ka ke koo ña ña nduu uꞌva tuku ña, tuvi ndo? Ra na kundaa ini ndo, chi köo ka mii chuun kuu ka vi ña, chi ndia ña kutia va kuvi ña ra kuañu yuvi va ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndoꞌo kuvi ndo iyoo ta kuꞌva iyoo ñùꞌù ña tuun nuu na yuuvi yoꞌo, ra ta kuꞌva iyoo iin ñuu ña nduꞌu xini iin koꞌndo, ra ^xini takundiꞌi va yuvi ña, ra küvi ka koo seꞌé ña, ra saa ke iyoo tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ra xa kundaa va ini ndo chi köo na ndatuun ñùꞌù, ra te ndiꞌi tu nandasi na xikoꞌo nuu ña, chi nuu sukun va chinduꞌu na ña, ra saa ke vaꞌa ^tuun ña nuu takundiꞌi va na ndee veꞌe kan. ");
INSERT INTO mxv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ra saa ke na koo tu ndoꞌo va, ña kuyeꞌe ndo nuu na yuuvi yoꞌo, ra kuni na takundiꞌi ña vaꞌa ña xa ndo, ra ndasakaꞌnu na Tata yo Ndioxi ra iyoo ndivi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndoꞌo, na ndee yoꞌo, ra ndakäni ini ndo, ña xaa yu sandiꞌi yu xaꞌa ndiayu Ndioxi ña tiaa ra Moisés, ra nii ña ^sañaꞌa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa växi yu sandiꞌi yu xaꞌa; chi ña xaa yu saxinu yu nuu va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, ra na kundaa ini ndo: chi ndia nii tuꞌun loꞌo xiꞌin ndia nii letra loꞌo ña kuu ndiayu Ndioxi ña tiaa ra Moisés xinaꞌa, ra ndïꞌi xaꞌa ña, ra nii na ndiꞌi va xaꞌa ña yuuvi yoꞌo, ndi su xiniñuꞌu xinu ndiꞌi va ña kaꞌan tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ra ndia ndia ka yuvi na xïin kandixa sava chiñu loꞌo ña xaꞌndia ndiayu Ndioxi nuu na, ra nii sañäꞌa tu na inka yuvi ña na kandixa na ña kaꞌan ña, ra na xa ña yoꞌo ra na loꞌo vaꞌa va kuu na nuu xaꞌndia Ndioxi chiñu. Ndi su yuvi na kandixa takundiꞌi chiñu ña xaꞌndia ndiayu Ndioxi, ra sañaꞌa tu na inka yuvi ña na kandixa na ña, ra na kan kuvi na kuu na kunaꞌnu vaꞌa ka va nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ña kan ke kaꞌan yu xiꞌin ndoꞌo vichin, ra na kundaa vaꞌa ini ndo, chi küvi kiꞌvi ndo ndivi nuu xaꞌndia Ndioxi chiñu, tu na kandïxa ndinuni vaꞌa ka ndo Ndioxi nuu na maestro na sañaꞌa ndiayu Ndioxi xiꞌin na fariseo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ra xa kundaa va ini ndo, chi na xii xikua yo na xindee xinaꞌa, ra suꞌva va ke kachi ndiayu Ndioxi ña ndakoo ra Moisés ndaꞌa na: “Käꞌni kun yuvi”, saa chi tu na kaꞌni kun, saa ra chaꞌvi tu yoꞌo va xaꞌa kuachi kun nuu Ndioxi, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ndi su yuꞌu tu kaꞌan xiꞌin ndo vichin, chi ndia ndia ka yuvi na sáa̱ ini xini ñani taꞌan, ra kixi va tundoꞌo sata na kan; ra saa tu yuvi na kandivaꞌa xiꞌin taꞌan va, chi ku̱ꞌu̱n tu na kan va nuu na chiñu naꞌnu ña kundaku kuachi xiꞌin na; ra yuvi na kaꞌan, “na kiꞌvi” xiꞌin ñani taꞌan, ra ndia ndiaya nuu xixi ñuꞌu ke ku̱ꞌu̱n na kan kuꞌun na xaꞌa tuꞌun kan. ");
INSERT INTO mxv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ra ña kan ke kaꞌan yu xiꞌin ndo vichin, chi tu kuaꞌan ndo ña soko ndo ñaꞌa nuu Ndioxi ra te ndixaa ndo nuu arta yii veꞌe ñuꞌu kaꞌnu kan, ra ikan na ndakaꞌan ndo ña väꞌa iyoo ini iin ñani ndo xini na ndoꞌo, ");
INSERT INTO mxv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","saa ra, vaꞌa ka va na ndakoo ñaꞌa ndo, ñaꞌa ña niꞌi ndo kuaꞌan ndo nuu arta yii kan, ra xiꞌna ka va na kuꞌun ndo ña ndakaꞌan mani ndo xiꞌin na, ña na koo kaꞌnu ini na xaꞌa ndo, ra saa vi ke kuvi nandiko ndo kuꞌun ndo ña soko ndo ñaꞌa ña kuaꞌan xiꞌin ndo nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ra tu ndia na taxi kuachi xaꞌa ndo nuu na chiñu, ra vaꞌa ka va yachi na ndakaꞌan mani ndo xiꞌin na, ña vaꞌa na küꞌun ndo veꞌe chiñu, chi tu na kuꞌun ndo nuu ra juez ña sandaku ra kuachi xiꞌin ndo, saa ra ndataxi va ra kan ndoꞌo ndaꞌa ndia kumisio, ra chikaa va ndia ndoꞌo veꞌe kàà. ");
INSERT INTO mxv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi këe yachi vi ndo veꞌe kàà tu na taan ndia ndoꞌo, chi xiniñuꞌu ndiakua chaꞌvi ndiꞌi va ndo xuꞌun ña nduku ra juez nuu ndo, ra saa vi kee ndo veꞌe kàà ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ra xa kundaa va ini ndo ña kaꞌan ndiayu Ndioxi ña tiaa ra Moisés xinaꞌa ña kachi suꞌva: “Kïꞌvi kun xiꞌin yasiꞌi inka tiaa.” ");
INSERT INTO mxv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ndi su yuꞌu tu kaꞌan xiꞌin ndo vichin: tu ndia iin tiaa ra ixtoꞌni ra nuu iin ñaꞌa, ra ndikun kuni ra kusun ra xiꞌin ña, saa ra xa kuachi va ke xa nima ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ña kan ke tu iin xiyo nduchi nuu kuaꞌa kun, ra kuni ña sandakava ña yoꞌo, ña sa kun kuachi, saa ra vaꞌa ka va na tava kun ña, ra sakana kun ña; chi vaꞌa ka va ke na sandiꞌi kun xaꞌa iin xiyo nduchi nuu kun, nuu ña kuꞌun iinii saa kun ndiaya. ");
INSERT INTO mxv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ra tu ndaꞌa kuaꞌa kun ke kuni sandakava yoꞌo ña sa kun kuachi, saa ra vaꞌa ka va ke na kaꞌndia kun ña, ra sakana kun ña, chi vaꞌa ka va ke na sandoñuꞌu kun iin xiyo iki kuñu kun, nuu ña kuꞌun iinii saa kun ndiaya ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ra xa kundaa va ini ndo chi suꞌva ke kachi ndiayu Ndioxi ña tiaa ra Moisés xinaꞌa xaꞌa na ndakoo taꞌan: Tiaa ra kuni ndakoo yasiꞌi, ra xiniñuꞌu na taxi ra iin tutu ndaꞌa ña, ña ndakuiin ña xaꞌa ña, ña ndixa ke xa ndakoo ra ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ndi su yuꞌu tu kaꞌan xiꞌin ndo vichin: ra tu ndia iin tiaa ra na ndakoo ra yasiꞌi ra, ra ndi su süvi xaꞌa ña ña xika ña xiꞌin inka tiaa ke ndakoo ra ña, chi ña kuni mii va ra ke sa ra saa, saa ra, kuachi ra kan va ke tu na ndakiꞌin ña inka tiaa, saa chi taꞌan kuachi ña xa na ndiaka taꞌan ke xa tu ña kan va. Ra tiaa ra tandaꞌa tu xiꞌin iin ñaꞌa ña nindoo nuu yii, ra iin kuvi va kuachi ra kan xiꞌin na ndiaka taꞌan, na kanduu ndiayu Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Ra xa kundaa va ini ndo ni ke kachi ndiayu Ndioxi ña tiaa ra Moisés taxi ra ndaꞌa na xii xikua yo na xindee xinaꞌa, ña kachi suꞌva: “Na käꞌnu kun ña kindoo kun sa kun nuu Ndioxi, saa chi tu kindoo kun sa kun iin chiñu nuu ra, ra na saxinu va kun ña”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ndi su yuꞌu tu kaꞌan xiꞌin ndo vichin, ndia nii ñaꞌa chunäꞌa ndo, ni ndivi ninu küvi chunaꞌa ndo, chi ikan kuu nuu nduꞌu Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ra nii ñuꞌu yoꞌo küvi chunaꞌa ndo, chi nuu xañu Ndioxi va kuvi ña; ra nii ñuu Jerusalén küvi chunaꞌa ndo chi ñuu Ndioxi, ra kuu rey ra kaꞌnu, va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ra nii xini tu ndo küvi chunaꞌa ndo, chi ndia nii ixi loꞌo xini ndo ra küvi ndanama ndo ña, ña nduu ña, ña yaa a ña ndiaa. ");
INSERT INTO mxv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ña kan ke te kaꞌan ndo ndia ndia ka va ña, ra tu kuvi sa ndo ña, ra “kuvi”, kachi va ndo, ra tu küvi sa ndo ña, ra “küvi”, kachi va ndo. Chi takundiꞌi ka tuꞌun ña ndakunuu kaꞌan ndo, ra xa kuenda ña väꞌa va kuvi ña kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Ra xa kundaa va ini ndo chi suꞌva ke kachi ndiayu Ndioxi: “Tu na sataxin na nduchi nuu ndo, ra na sataxin tu ndoꞌo nduchi nuu na kan va; ra tu kani na yuꞌu ndo ra kita nùꞌù ndo, saa ra na tava tu ndoꞌo nùꞌù na kan va”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ndi su yuꞌu kaꞌan tu xiꞌin ndoꞌo vichin: Tu ndia na ^xa ña väꞌa xiꞌin ndo, ra na sä ndoꞌo ña väꞌa xiꞌin na, ra tu ndia na xakin xaꞌndia iin xiyo nuu ndo, ra na taxi ndo inka xiyo nuu ndo na kani va na. ");
INSERT INTO mxv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ra tu ndia na xakin kuachi xiꞌin ndo ña kuni na kindiaa na tikachi ña niꞌnu ndo, ra na taxi ndo ña ndaꞌa va na, ra ndia koto ña ndixi va ndo na taxi ndo kuꞌun xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ra tu ndia na xa nduxa xiꞌin ndo ña kuiso ndo ñaꞌa xiꞌin na, iin mil metro, saa ra ndia uvi mil metro va na kuꞌun ndiaka ndo ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ra na nduku ñaꞌa nuu ndo, ra taxi ndo ña ndaꞌa va na, ra na tatu ñaꞌa nuu ndo, ra na kuxïꞌndia ndo ña nuu na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Saa ndikaꞌan ka ra kachi ra saa: ―Xa kundaa va ini ndo chi na xii xikua yo ra suꞌva va ke kachi na: “Kuꞌvi ini kun kuni kun na itaꞌan xiꞌin kun, ra na sáa̱̱ va ini kun kuni kun na sáa̱̱ ini xini yoꞌo”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ndi su yuꞌu tu kachi saa xiꞌin ndo vichin: Kuꞌvi ini ndo kuni ndo na sáa̱̱ ini xini ndoꞌo, ra na kaꞌan tu ndo xiꞌin Ndioxi xaꞌa na kanitaꞌan xiꞌin va ndo. ");
INSERT INTO mxv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ra saa ke ndañaꞌa ndo mii ndo ña ndixa ke kuu ndo seꞌe Ndioxi ra iyoo ndivi, chi ra kan kuvi ra ^taxi kanata ñuꞌu ra tuun ña sata na vaꞌa xiꞌin na väꞌa va, ra ^taxi tu ra kuun savi sata na vaꞌa xiꞌin na väꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ra tu kuꞌvi ini ndo xini ndo takua na kuꞌvi ini xini ndoꞌo va, saa ra köo yaꞌvi ndiaa vi ña nuu Ndioxi, chi saa xa tu na yuvi na kuëe kandixa Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ra tu xatoꞌo ndo takua na ndikun Ndioxi xiꞌin va ndo, saa ra köo yaꞌvi ndiaa vi ña nuu Ndioxi, chi saa xa tu yuvi na xïni ichi Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ña kan ke ndakú ni na koo nima ndo, ra ndia ta kuꞌva iyoo mii Tata yo Ndioxi ra nduꞌu ndiví ninu va ke, na koo ndo; chi ra kan ra vaꞌa ni ra; ra niña ña ndakú va ^xa ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ra te kuni ndo sa ndo iin ña vaꞌa xiꞌin na ndaꞌvi, ra na küni ndia nii yuvi ña sa ndo ña xiꞌin na, chi tu na kuni na, ña saniꞌi ndo ñaꞌa na ndaꞌvi, saa ra xaꞌa na satoꞌo na ndoꞌo xaꞌa chiñu ña xa va ndo; ra tu ña kuni ndo satoꞌo na ndoꞌo va ke xa ndo ña, saa ra köo ña vaꞌa saniꞌi vi Tata yo Ndioxi ra iyoo ndivi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ña kan ke te taxi ndo ñaꞌa ndaꞌa na ndaꞌvi, ra na käꞌan ndoso ndo xaꞌa ña xiꞌin takundiꞌi yuvi ña na kundaa ini na, chi saa ke ^xa inka yuvi na chiꞌña tuꞌun va, chi na kan ra iin kunani na xika na ña ndatuꞌun na xiꞌin takundiꞌi na veꞌe ñuꞌu, ra xika tu na iin takundiꞌi yaꞌya va ña ndatuꞌun na xiꞌin yuvi, ña kuni na ña vaꞌa ni na kaꞌan yuvi xaꞌa na; ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi na xa saa, ra xa ña kan ke niniꞌi va na, chi köo ka ñaꞌa taxi vi Ndioxi ndaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ña kan ke te chindiee taꞌan ndoꞌo xiꞌin na ndaꞌvi na kumani ñaꞌa nuu, ra ndatüꞌun ndo xiꞌin ndia nii yuvi, ra na kundäa ini ndaꞌa ichin ndo xaꞌa chiñu ña xa ndaꞌa kuaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ra ña vaꞌa ña xa ndo xiꞌin na ndaꞌvi na kumani nuu, ra ña seꞌe va na kuu ña, ra saa ke niꞌi ndo ña vaꞌa nuu Tata yo Ndioxi ra iyoo ndiví ra ^kundaa ini xaꞌa takundiꞌi chiñu ña iyoo seꞌe ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Te kaꞌan ndo xiꞌin Ndioxi, ra xä ndo ta xa na chiꞌña tuꞌun, chi na kan ra kutoo ni na kundita na ini veꞌe ñuꞌu nuu tuvi, ra xini sii ni tu na ña kundita na tutun yaꞌya va ña kaꞌan na xiꞌin Ndioxi, ña vaꞌa na kuni yuvi na, ra kaꞌan toꞌo ni na xaꞌa na kuni na. Ra ña ndixa kaꞌan yu xiꞌin ndo, chi na kan, ra köo ka ñaꞌa taxi Ndioxi ndaꞌa vi na, chi xa ña kan ku yaꞌvi va na. ");
INSERT INTO mxv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ndi su ndoꞌo, ra te kaꞌan ndo xiꞌin Ndioxi ra suꞌva va ke na sa ndo: chi ini veꞌe va ndo ke na ndee ndo; ra ndakasi ndo yeꞌe ndo, ra ikan va na kaꞌan seꞌe ndo xiꞌin Tata ndo Ndioxi, ra saa ke niꞌi ndo ña vaꞌa nuu ra, chi ra kan, ra kundaa va ini ra xaꞌa ña kaꞌan seꞌe ndo xiꞌin ra, ra taxi va ra ña vaꞌa ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ra te kaꞌan ndo xiꞌin Ndioxi, ra xä ndo ta xa yuvi na xïni ichi Ndioxi, chi na kan ra te kaꞌan na xiꞌin Ndioxi, ra iin tuku, tuku nandiko na kaꞌan na indaa tuꞌun ña köo yaꞌvi ndiaa, chi xiꞌin ña kan va ke kundaꞌvi ini Ndioxi kuni ra na, ra ndakuiin ra yuꞌu na, tuvi na. ");
INSERT INTO mxv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ndi su ndoꞌo, ra xä ndo ta xa na kan, chi Iva yo Ndioxi ra xa kundaa va ini ra ni ñaꞌa ke kumani nuu ndo, te kuni ka nduku ndo ña nuu vi ra. ");
INSERT INTO mxv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ña kan ke te kaꞌan ndoꞌo xiꞌin Ndioxi ra suꞌva va na kachi ndo xiꞌin ra: Tata ndi, ra iyoo ndiví, ña yii ni na kuu kivi kun. ");
INSERT INTO mxv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ra na kixi kun kaꞌndia kun chiñu nuu ña yuuvi yoꞌo. Ra ta xa kun ndivi ke, na sa kun nuu ñuꞌu yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ra iin ndisaa kii ke ná taxi kun ña xiniñuꞌu nuu ndi kuxi ndi; ra na kumäni ña nuu ndi. ");
INSERT INTO mxv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ra na sakaꞌnu ini kun xaꞌa kuáchi ndi, Ta kuꞌva xa ndi ña ^xakaꞌnu ini ndi xaꞌa kuachi yuvi, na xa ña väꞌa xiꞌin ndi. ");
INSERT INTO mxv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ra täxi kun koyo ndi ndaꞌa ña väꞌa; Chi na ndakiꞌin va kun nduꞌu ndaꞌa ña. Chi yoꞌo kuvi ra kaꞌnu xaꞌndia chiñu, ra kuu mii kun ndiee, ra xaꞌndia kun xaꞌa takundiꞌi va ñaꞌa, ndia ndikaa ndikuꞌun. Amén. ");
INSERT INTO mxv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ra na kundaa ini ndo, saa chi tu xakaꞌnu ini ndo xaꞌa kuachi ña xa inka yuvi xiꞌin ndo, saa ra koo kaꞌnu tu ini Tata yo Ndioxi ra iyoo ndivi xaꞌa kuachi tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ndi su tu na köo kaꞌnu ini ndo xaꞌa kuachi ña xa inka yuvi xiꞌin ndo, saa ra nii Tata yo Ndioxi ra iyoo ndivi köo kaꞌnu ini tu xaꞌa kuachi ndoꞌo va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Te iyoo suꞌun ndo ña xïxi ndo, ra na ndañäꞌa ndo mii ndo ña kuvita ini ndo ta kuꞌva xa na chiꞌña tuꞌun, chi na kan, ra iin ndanama chuun na nuu na, ña kuni na kuni yuvi ña iyoo suꞌun na ña xïxi na. Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi na xa saa kan, ra xa ña kan kuvi yaꞌvi va na, ra köo ka ñaꞌa taxi Ndioxi ndaꞌa vi na. ");
INSERT INTO mxv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ña kan ke ndoꞌo, ra te iyoo suꞌun ndo ña xïxi ndo, ra na ndakatia va ndo nuu ndo, ra vivii va na ndasa ndo xiꞌin mii ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ra saa ke na kundäa ini yuvi ña iyoo suꞌun ndo, ra takua Tata ndo Ndioxi ra xini ña xa seꞌe va ndo kuvi ra na kundaa ini, ra saa ke niꞌi ndo ña vaꞌa nuu Tata yo Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ra saa ndikaꞌan ka Jesús xiꞌin na, kachi ra saa: ―Chiväꞌa ndo ña kuika nuu ña yuuvi yoꞌo, chi yoꞌo ra ^kíꞌvi va tikixin ña, ra kuxi va tu ña, saa ra ndiꞌi xaꞌa va ña, ra ^kíꞌvi tu na kuiꞌna va sakuiꞌna na ña. ");
INSERT INTO mxv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ña kan ke kaꞌan yu xiꞌin ndo, ña na chivaꞌa ndo ña kuika chi ndivi nuu ^kïꞌvi tikixin, ra nii küxi ña, ra nii ndïꞌi tu xaꞌa va ña, ra nii na kuiꞌna kïꞌvi ña sakuiꞌna na ña. ");
INSERT INTO mxv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Saa chi nuu ^chivaꞌa ndo ña kuika ña kuu mii ndo, ra ikan ke koo tu nima va ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Nduchi nuu yo, ra ñùꞌù ña ^tuun nuu iinii saa iki kuñu va yo kuvi ña; ra tu vaꞌa nduchi nuu ndo, saa ra vaꞌa tu iyoo iinii saa mii va ndo, saa chi nuu iyoo ñuꞌu va iyoo ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ndi su tu ña kueꞌe va kuvi nduchi nuu ndo, saa ra nuu ñaa va iyoo iki kuñu ndo, ra tu ñùꞌù yeꞌe ña kuu mii ndo ra ña ñaa va kuvi ña, saa ra nuu ñaa tu iyoo iinii saa va ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Ra kuni yu na kundaa ini ndo, chi ndia nii yuvi ra küvi sachiñu na nuu uvi tiaa ndia xaꞌndia chiñu, saa chi na xachiñu nuu uvi tiaa, ra küvi kindoo vaꞌa na xiꞌin uvi saa ndia. Saa chi tu vaꞌa na kitaꞌan na xiꞌin iin ra, ra inka tu ra sáa̱ na xiꞌin va. Xaꞌa ña kan ke küvi sachiñu ndo nuu Ndioxi ra sachiñu tu ndo nuu xuꞌun ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ra saa ndikaꞌan ka Jesús kachi ra saa xiꞌin na: ―Ra vichin ke kaꞌan yu xiꞌin ndo, ña na ndïꞌi ni ini ndo xaꞌa ña kuxi ndo, xiꞌin xaꞌa ña koꞌo ndo, ña vaꞌa kutiaku ndo, ra nii na ndïꞌi ni tu ini ndo xaꞌa tikoto ña kundixi va ndo; saa chi ndiaa yaꞌvi ni ka va ña tiaku ndo nuu ña xíxi ndo, ra ndiaa yaꞌvi ni ka va tu iki kuñu ndo nuu tikoto ña ndixi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ra na kutoꞌni ndo ndia kuꞌva ke iyoo saa vali, ri ndachi xika ndivi, chi nii chïꞌi ri, ra nii sakëe ri, ra nii yaka nuu chivaꞌa ri ñaꞌa kuxi ri köo vi, ndi su Tata ndo Ndioxi ra iyoo ndivi va kuvi ra kiꞌin kuenda xiꞌin ri ña xixi ri. Ra saa ke sa tu ra xiꞌin ndoꞌo va, saa chi ndiaa yaꞌvi ni ka va ndoꞌo nuu saa vali kan. ");
INSERT INTO mxv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ña kan ke na kundïꞌi ni ini ndo xaꞌa ña tiaku ndo vichin, saa chi vaꞌa ni ndiꞌi ni va ini ndo, ra tu na kachi Ndioxi kuvi ndo, saa ra kuvi va ndo, ra ndia nii hora loꞌo ka ke kuchüun vi ndo kutiaku ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Ra nichuun ke ndiꞌi ni tu ini ndo xaꞌa ña kundixi ndo? Kutoꞌni ndo ndia kuꞌva ke iyoo ita vali ña iyoo iku, saa chi ña kan ra nii xachïñu ña, ra nii xaväꞌa ña tikoto ña kundixa ña, ndi su nduvi ni va ña. ");
INSERT INTO mxv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi ndia nii ra rey Salomón ra vaꞌa ni kuika ni va ndixiyo ra, ndi su ndikuchüun vi ra ña sa̱ví ni koo tikoto ra ta kuꞌva iyoo ita vali kan. ");
INSERT INTO mxv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ra tu nduvi ni sakundixi Ndioxi ita vali ña iyoo iku, ra vichin iyoo ña, ra tiaan xa ndachi va ña, saa ra ndakaya na ña ra xaꞌmi va na ña, ra kachi ka vi tu ndoꞌo, ¿a täxi ra ñaꞌa ña kumani nuu ndo ndaꞌa ndo tuvi ndo? ¿Nichuun ndiee ni ini ndo ña xïin ndo kandixa ndo Ndioxi? ");
INSERT INTO mxv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ña kan ke na ndïꞌi ni ka ini ndo ña kachi ndo saa: “¿Ni ke kuxi yo vichin, ra ni ndutia kuvi ra koꞌo yo, ra ndia mii kee tu tikoto ña kundixi yo?”, na kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Saa chi xaꞌa takundiꞌi ñaꞌa yoꞌo kuvi ña ndiꞌi ni ini yuvi na xïni ichi Ndioxi va. Ndi su ndoꞌo, ra na kundïꞌi ni ka ini ndo xaꞌa ña yoꞌo, saa chi Tata ndo Ndioxi ra xa xini mii va ra kan ni ñaꞌa ke xamani nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ña kan ke, ndoꞌo, ra xiꞌna ka va chiñu ña xaꞌndia Ndioxi ke ná ndanduku ndo, ra sa ndo ña, ra saa ke taxi ra takundiꞌi ñaꞌa ña xíniñuꞌu nuu ndo ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ra na kundïꞌi ni ini ndo xaꞌa tundoꞌo ña kuu kii ña vaxi, saa chi kundiëe ndo ña kundiꞌi ini ndo xaꞌa tundoꞌo ña ^kuu kii vichin, ra kundiꞌi tu ini ndo xaꞌa tundoꞌo ña kuu kii ña vaxi. Chi ta iin, ta iin kii, ra xa iyoo, xa iyoo va tundoꞌo vaxi xiꞌin ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ra saa ndikaꞌan ka Jesús kachi ra saa xiꞌin na: ―Käꞌan ndo xaꞌa kuachi inka yuvi, ra saa ke käꞌan Ndioxi xaꞌa kuachi tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi ta kuꞌva xa ndo ña kaꞌan ndo xaꞌa kuachi inka yuvi ña väꞌa xa na, ra saa ke sa tu Ndioxi xiꞌin ndoꞌo va ña sayukun ra kuachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nichuun vaꞌa ndiꞌi ini kun xaꞌa miꞌi loꞌo ña ndikaa nuu ñani kun, ra ndïꞌi tu ini kun xaꞌa itun chee tun ndikaa nuu mii kun? ");
INSERT INTO mxv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ra tu xïni kun itun chee tu ndikaa nuu mii kun, saa ra, ¿ni ke sa kun ña vaꞌa kaꞌan kun xiꞌin ñani kun: “Ñani, naꞌa ra na tava yu miꞌi loꞌo ña ndikaa nuu kun”, na kachi kun xiꞌin ra? ");
INSERT INTO mxv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Saa ra ra chiꞌña tuꞌun va kuvi kun, chi xiꞌna ka va itun chee tu ndikaa nuu mii kun kuvi nu, na tava kun. Ra saa ke vaꞌa ndatuvi nuu kun, ra vaꞌa tava kun miꞌi loꞌo ña ndikaa nuu ñani kun. ");
INSERT INTO mxv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ra na täxi ndo ña yii ndaꞌa tina, chi koto ndikokuiin ri ra kaxi ri ndoꞌo; ra nii nuu kini na chikäa ndo ña vaꞌa, ña yaꞌvi ni, ña iyoo nuu ndo; chi koto kuꞌní xaꞌa ri ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Nduku ndo ñaꞌa ña kumani nuu ndo nuu Ndioxi, ra taxi ra ña ndaꞌa ndo; na ndanduku ndo ñá, ra ndaniꞌi ndo ña; na kani ndaꞌa ndo yeꞌe, ra ndakuiña ra nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Saa chi takundiꞌi yuvi na nduku ñaꞌa kumani nuu na nuu Ndioxi ra taxi va ra ña nduku na ndaꞌa na, ra na ndanduku ñaꞌa ña kuni na, ra ndaniꞌi va na ña. Ra na kani ndaꞌa yeꞌe, ra ndakuiña va ra nuu na. ");
INSERT INTO mxv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ra tu ndiaa ndoꞌo, na iyoo seꞌe, ra tu na nduku seꞌe ndo ixta nuu ndo kuxi na, ¿ra ama taxi ndo yuu ndaꞌa na kaxi na? ");
INSERT INTO mxv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ra tu tiaka, tu na nduku na nuu ndo kaxi na, ¿ra ama tiin tu ndo iin koo, ra taxi ndo ri ndaꞌa na kaxi na? ");
INSERT INTO mxv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Saa chi ndoꞌo, ra vaꞌa ni na yuvi kuachi kuvi va ndo, ndi su xini va ndo ña taxi ndo ña vaꞌa ndaꞌa seꞌe ndo. Ra saa tu Tata ndo Ndioxi ra iyoo ndiví va, chi viꞌi ni ka va ña vaꞌa taxi ra kan ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ra tu kuni tu ndo ña sa yuvi ña vaꞌa xiꞌin ndo, saa ra, ña vaꞌa na sa tu ndoꞌo xiꞌin va na, saa chi tuꞌun ña kaꞌan yu xiꞌin ndo yoꞌo, ra iin kuvi va ña xiꞌin ndiayu Ndioxi ña tiaa ra Moisés, xiꞌin ña tiaa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Yeꞌe tiañu va ke na kiꞌvi ndo, chi iyoo tu inka yeꞌe ña ndika ni va, ra iyoo tu iin ichi ña ndika ni va, ndi su ndiaya va ke kuaꞌan ña kan, ra kuaꞌa ni va kuvi yuvi na kuaꞌan chi kan. ");
INSERT INTO mxv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ndi su ichi ña kuaꞌan ndiví nuu iyoo Ndioxi, ra tiañu ni va ña kan, ra tiañu ni tu yeꞌe va, ra loꞌo ni va kuvi yuvi na ndaniꞌi ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ra saa ndikaꞌan ka Jesús kachi ra saa xiꞌin na: ―Ra na kondiaa ni ndo mii ndo nuu yuvi na chiꞌña tuꞌun, na xá kaꞌan ndoso tuꞌun Ndioxi ta vaxi na nuu ndo, chi toꞌo ni va ñaꞌa na, ndi su süvi na ndixa kaꞌan tuꞌun yuꞌu Ndioxi kuvi na. Chi na kan ra ta iyoo ndivaꞌyu kuiꞌna va ke iyoo na. ");
INSERT INTO mxv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ra kuvi va ndakuni ndo na, chi xiꞌin chiñu ña xa va na ke ndañaꞌa na mii na. Ta kuꞌva iyoo itun kuiꞌi tun vaꞌa, xiꞌin itun ñaꞌa, chi küvi kuun uva ndaꞌa itun ìñu̱, ra nii küvi kuun tu koxi ndaꞌa itun ìñu̱ ndiava va, chi itun ñaꞌa va kuvi nu. ");
INSERT INTO mxv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ra saa ke iyoo tu ña yoꞌo va, chi takundiꞌi itun vaꞌa, ra kuiꞌi ña vaꞌa ke kuun ndaꞌa va nu, ra itun väꞌa, ra kuiꞌi ña väꞌa ke kuun ndaꞌa va nu. ");
INSERT INTO mxv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chi itun kuiꞌi, tu vaꞌa, ra küvi kuun kuiꞌi ñàꞌa ndaꞌa nu, ra nii itun väꞌa, ra küvi kuun kuiꞌi ña vaꞌa ndaꞌa nu. ");
INSERT INTO mxv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ra takundiꞌi itun tu köo kuiꞌi ña vaꞌa kuun ndaꞌa, ra tiaꞌndia va nu, ra ndakaya nu, ra koko va nu. ");
INSERT INTO mxv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ra saa ke iyoo tu ña yoꞌo va, saa chi xiꞌin chiñu ña xa va na ke ndakuni ndo na ndia yuvi kuvi na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin na: ―Ra süvi takundiꞌi na kaꞌan, “Tata, Tata”, xiꞌin yu kuvi na kuchuun kiꞌvi koo ndivi nuu xaꞌndia Tata yu Ndioxi chiñu, chi takua na kandixa ña kaꞌan ra, ra xanduvi na ña, ra na kan va kuvi na kuchuun kiꞌvi koo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ra te na xaa kii ña sandaku Ndioxi kuachi xiꞌin na ñuu yuuvi yoꞌo, ra kuaꞌa ni va na kaꞌan xiꞌin yu kii kan kachi na saa: “Tata, Tata, ¿nichuun ndaküꞌun nuu kun nduꞌu?, chi nduꞌu, ra xiꞌin kivi kun ndikaꞌan ndoso ndi tuꞌun Ndioxi nuu yuvi, ra xiꞌin kivi kun tava tu ndi tachi ndivaꞌa va, ra kuaꞌa ni tu ña xituꞌun va xa ndi xiꞌin kivi kun”, kachi na xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ra saa ndakuiin yu yuꞌu na kachi yu saa xiꞌin na: “Xïni yu yoo kuvi ndoꞌo; kuatiaꞌa ndo nuu yu, chi süvi na vaꞌa kuvi ndo, chi na ñaꞌa va kuvi ndoꞌo”, kachi yu xiꞌin na kii kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ra saa ndikaꞌan ka ra xiꞌin yuvi kan kachi ra saa: ―Yuvi na xini soꞌo tuꞌun ña kaꞌan yu, ra xa na ña. Ra ta kuꞌva iyoo iin tiaa ra ndichi ni xini, ra xavaꞌa ra veꞌe ra sata kava saa iyoo na. ");
INSERT INTO mxv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ra ta kuun savi, ra nduxinu tiañuꞌu kaꞌnu, ra kixi tu tachi ñaꞌa, ra ndiee ka vi kani ndiaa ña veꞌe kan, ndi su ndikuchüun ña sanduva ña veꞌe kan, saa chi ndia sata kava vi ke kaku xaꞌa ña, ra ña kan va ke tuun ni ndichi ña. ");
INSERT INTO mxv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ra na kaꞌan tu yu xiꞌin ndo xaꞌa yuvi na ^xini soꞌo tuꞌun ña kaꞌan yu, ra xä na ña. Ra na kan, ra ta kuꞌva iyoo iin tiaa kiꞌvi ni, ra xavaꞌa ra veꞌe ra nuu yuti va, saa iyoo na. ");
INSERT INTO mxv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chi ta kuun savi, ra nduxinu tiañuꞌu kaꞌnu, ra kixi tu tachi ñaꞌa va, ra ndiee ni kani ndiaa ña veꞌe kan, ra sanduva va ña ña, ra ndiꞌi yaa va xaꞌa veꞌe kan, saa chi nuu yuti va kuvaꞌa ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ra te sandiꞌi ra ndikaꞌan ra takundiꞌi ña yoꞌo xiꞌin na, saa ra ndakanda ka vi ini na xini na ra, saa chi ndichi ni ^sañaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Saa chi iin ta sañaꞌá na kuu mii ndiayu, xaꞌndia chiñu, saa sañaꞌá ra na, chi ndïxa ra ta kuꞌva xa ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés. ");
INSERT INTO mxv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ra saa te nandiko Jesús vaxi nuu ra iku kan, ra iin tiꞌvi chee yuvi ndikun sata ra vaxi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Saa ra ndixaa va iin ra xiꞌi kueꞌe tiaꞌyu, ra xikusiti ra nuu Jesús, ra xaꞌa ra xaku ndaꞌvi ra, ^kachi ra saa: ―Tata, tu na kuiin kun ra kuvi va sanduvaꞌa kun yuꞌu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ra saa nditiandiaa ndaꞌa Jesús tiaa kan, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kuni va yu sandaꞌa yu yoꞌo, ra na nduvaꞌa kun vichin ―kachi Jesús xiꞌin ra. Saa ra ndikun nindoñuꞌu va kueꞌe tiaꞌyu kan sata ra, ra nduvaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Kuaꞌan, ra ndia nii na ndatüꞌun kun xiꞌin, ra takua nuu ra sutu va ke na kuꞌun kun ñaꞌa kun mii kun, ña xa nduvaꞌa kun xa Ndioxi, ra kaniꞌi kun ñaꞌa ña soko kun nuu Ndioxi, ta kuꞌva iyoo chiñu ña xaꞌndia ndiayu Ndioxi ña ndakoo ra Moisés. Ra na kundaa ini ndia ña xa nduvaꞌa va kun xa Ndioxi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ra te sakan ndixaa Jesús ñuu Capernaum, saa ra ndixaa va iin soldado ra kuchee xaꞌndia chiñu nuu iin ciento na soldado ñuu Roma, ra xaꞌa ra xakundaꞌvi ra nuu Jesús, ");
INSERT INTO mxv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kachi ra saa: ―Tata, ndiee ni ndoꞌo iin ra xachiñu nuu yu kanduꞌu ra veꞌe, ra ndia nii nuu kanda ka ra ke küvi, chi iin xavita ni va ña ra, ra ndoꞌo ni ra, Tata ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Vaꞌa va, na kuꞌun yu xiꞌin kun ra sandaꞌa yu ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ra saa ndakuiin ra soldado kan kachi ra saa xiꞌin Jesús: ―Tata, köo ichi vi yu ña kiꞌvi kun veꞌe yu, chi ra kaꞌnu ni ka va kuvi yoꞌo; ra mii nuu íin kun yoꞌo vichin va, na kaꞌndia kun chiñu nuu kueꞌe kan, saa ra, saña va ña ra, ra nduvaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi xini va yu, saa chi iyoo tu na xaꞌndia chiñu nuu yuꞌu va, ra kandixa va yu na; ra yuꞌu tu, xaꞌndia chiñu nuu ndia soldado ra kandixa va ndia yuꞌu: “Kuaꞌan ndo”, ^kachi yu xiꞌin ndia, ra kuaꞌan va ndia; “naꞌa ndo”, ^kachi yu, ra vaxi va ndia. Ra saa tu ra xachiñu nuu va yu, chi xaꞌndia yu chiñu nuu ra, ra kandixa va ra ña kaꞌan yu xiꞌin ra ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ra ta xini soꞌo Jesús ña ndikaꞌan ra soldado kan, saa ra ndakanda ni ini ra xiꞌin tuꞌun ña ndikaꞌan ra, ra saa ndikaꞌan ra xiꞌin na ndikun sata ra, kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi täan ndaniꞌi yu ndia nii na ñuu Israel na kandixa yuꞌu, ta kuꞌva kandixa ra yoꞌo yuꞌu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Saa ndikaꞌan ka ra kachi ra saa: ―Tiaa soꞌo ndo ña kaꞌan yu xiꞌin ndo yoꞌo. Chi iinii kuvi ña yuuvi ke ke̱e̱ yuvi, na ke̱e̱ chi nuu kanata ñuꞌù xiꞌin chi nuu kita ñuꞌù, ra kuꞌun na ndakundee na nuu mesa ña kuxi na xiꞌin ra Abraham, xiꞌin ra Isaac xiꞌin ra Jacob, ndivi nuu ^xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ndi su mii na ñuu ra, na kana ra koo xiꞌin ra ndivi nuu xanꞌdia ra chiñu, ra xaꞌa ña xïin na kandixa na ra, ra chi keꞌe va tava ra na, ra nuu ñáa̱ va ku̱ꞌu̱n na, ra ikan kuu nuu kuaku ni na, ra iin ndiakua ndakaxi nùꞌù na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ra te ndiꞌi saa ndikaꞌan Jesús xiꞌin ra soldado kan kachi ra saa: ―Kuanuꞌu veꞌe kun, chi ra xachiñu nuu kun, ra xa nduvaꞌa va ra, chi ta kuꞌva ^kandixa kun saa kuu va ―kachi Jesús xiꞌin ra. Saa ra ndikun mii hora kan nduvaꞌa ndixa va ra xachiñu nuu ra soldado kan. ");
INSERT INTO mxv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ra te ndixaa Jesús veꞌe ra Pedro, ra saa xini ra ña ndiee ka vi ndoꞌo ña siso ra Pedro kan kanduꞌu ña nuu ixto xiꞌin kaꞌni, ra iin ndiakua ndatuvi ña xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Saa nditiandiaa ndaꞌa Jesús ña, ra ndikun nduvaꞌa va ña, chi ke̱e va kaꞌni kan, saa ra ndakoo ña, ra xaꞌa ña ^xavii ña kuxi va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Saa kuu ra kuaa va kii kan, ra ndixaa yuvi kan nuu Jesús, ra ndiaka na kuaꞌa ni na xiꞌi, xiꞌin na tiin tachi ndivaꞌa ña kuni na ña na sandaꞌa ra na. Saa ra takua tuꞌun va ndikaꞌan ra xiꞌin tachi ndivaꞌa kan ña xaꞌndia ra chiñu nuu ña, ña na kee ña kuꞌun ña, saa ra ndikun saña va ña na, ra kee ña kuaꞌan va ña, ra sandaꞌa ra takundiꞌi va na xiꞌi kan. ");
INSERT INTO mxv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ra suꞌva ke kuu ña ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ña kachi suꞌva: “Mii Ndioxi kuvi ra kindiaa takundiꞌi kueꞌe ña xiꞌi yo, ra sandiꞌi tu ra xaꞌa ña kuꞌvi va yo”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ra saa ixtoꞌni Jesús ña ndukuaꞌa ni yuvi, saa ra xaꞌndia ra chiñu nuu ndia itaꞌan xiꞌin ra ña xa na koo nduvi ndia xiꞌin iin barca ña ndayaꞌa ndia chi inka xiyo yuꞌu tiañuꞌu kan kuꞌun ndia. ");
INSERT INTO mxv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ra saa ndixaa iin ra maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, ra ndikaꞌan ra xiꞌin Jesús kachi ra saa: ―Tata Maestro, ndia ndia ka mii nuu na kuꞌun va kun, ra kuꞌun yu xiꞌin va kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Yukuii, ra iyoo va yavi nuu kixi ri, ra saa tu iyoo saa va, chi iyoo tu chiꞌyo nuu kixi ri kan va. Ndi su, yuꞌu, ra xaa yoꞌo vichin, ra ndia nii nuu kusun yu ke köo vi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ra saa ndikaꞌan tu iin mii ra itaꞌan xiꞌin mii Jesús va kachi ra saa xiꞌin ra: ―Tata, kundiatu ñaꞌa yuꞌu, ra na kuꞌun yu nduxin yu iva yu, saa ndakundikun yu yoꞌo kuꞌun yu xiꞌin kun ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Kundikun yuꞌu, ra na koꞌo xiꞌin yu, ra ndakoo na ndii na nduxin taꞌan mii va na ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Saa nandaa Jesús ini barca kan xiꞌin ndia itaꞌan xiꞌin ra, ra ndakiꞌin ndia kuaꞌan va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ra sakan saa kuu ndia kuaꞌan va ndia, saa ra tuꞌva ndiee ka vi xaꞌa xika tachi kuiꞌna nuu tiañuꞌu kan, ra iin ndakundichi ndakundichi nuu ra xa ña, ra xaꞌa iin kuni ndakava barca kan xiꞌin ndia kaꞌa tiañuꞌu kan, ndi su Jesús ra yaa yaa ndisaꞌvi ini ra kanduꞌu ra kixi va ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ra saa kuyachin ndia itaꞌan xiꞌin ra, ra sandoto ndia ra, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―¡Tata, ndakoo ra sakaku kun nduꞌu chi kuaꞌan saꞌvi va barca yoꞌo xiꞌin yo! ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Nichuun ndiee ni iyuꞌvi ndo? ¿Ra nichuun loꞌo ni ndiaa ini ndo yuꞌu? ―kachi ra xiꞌin ndia. Ra saa ndakoo ra, ra ndikaꞌan ra xiꞌin tachi ra ndikaꞌan tu ra xiꞌin tiakuii va, saa ra ndikun xikoyaa va ña, saa ra iin kuu taxin va. ");
INSERT INTO mxv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Saa ra ndakanda ka vi ini ndia, ra kachi ndia saa xaꞌa Jesús: ―¿Ni tiaa kuvi ra yoꞌo, ra ndia tachi xiꞌin tiañuꞌu yoꞌo ra kandixa va ra ña kaꞌan ra? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ra te ndixaa Jesús chi inka xiyo yuꞌu tiañuꞌu nuu ndikaa ñuu na Gadareno, ra saa ndakoyo uvi tiaa ndia tiin tachi ndivaꞌa, ndia ndoꞌni ini yavi ndii, ra ndixaa ndia niniꞌi taꞌan ndia xiꞌin Jesús, ra tiaa kan, ra yavi ndii ke kuu veꞌe va ndia, ra tiaa ni ndiee sana ndia, chi kani taꞌan ndiꞌi va ndia xiꞌin yuvi. Ña kan ke mii na ñuu kan ra ndiküvi vaꞌa ka vi kaka na ichi nuu xindoꞌni ndia. ");
INSERT INTO mxv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ra saa te kuyachin ndia nuu Jesús, ra iin kokoꞌo xaꞌa ndia ndaꞌyu ndia, ra kachi ndia saa: ―¿Ni ke kuni kun xiꞌin ndi ña vaxi kun sataꞌan kun nduꞌu Jesús seꞌe Ndioxi? Chi kuni ka va, saa xaa tiempo ña sandoꞌo kun nduꞌu ―kachi ndia ndaꞌyu ndia. Ndi su tachi ndivaꞌa ña ndoꞌni ini va ndia ke ndikaꞌan. ");
INSERT INTO mxv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ra yachin kan xika iin tiaꞌndia chee kini xaxaꞌan ri. ");
INSERT INTO mxv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ra saa xakundaꞌvi ni tachi ndivaꞌa kan nuu Jesús kachi ña saa: ―Tu tava kun nduꞌu, saa ra, taxi ndiayu ndaꞌa ndi ña na kuꞌun ndi ndee ndi ini kini kaa va ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Kuaꞌan ndo ―kachi ra xiꞌin ña, ña taxi ra ndiayu ndaꞌa ña. Ra saa ndakoyo tachi ndivaꞌa kan ini uvi saa tiaa kan, ra ndixaꞌan ña nandee ña ini kini ri xika kan, ra iin sasána ndiꞌi ña ri, ra saa xanindiee ndiꞌi ri kuaꞌan ri chi yuꞌu iin taꞌvi kan, ra ikan koꞌni ndiꞌi ri mii ri ini mini kan, ra ndikaandiaa ndiꞌi ri ndixiꞌi ri. ");
INSERT INTO mxv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ra saa kee na ndiaa kini kan xinu na ndixaꞌan na ñuu kan ndatuꞌun na xiꞌin yuvi xaꞌa takundiꞌi ña xini na kuu kan, ra saa tu xaꞌa ña xini na ndoꞌo ndia xindoꞌni tachi ndivaꞌa ini kan va. ");
INSERT INTO mxv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ra saa ndakoyo takundiꞌi na ñuu kan ndixaa na nuu iin Jesús, ra te xini na ra, saa ra, xaꞌa na xakundaꞌvi na nuu ra, ña na sa ra ña mani kanata ra ñuu kan, ra kuꞌun ra inka xiyo va kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Saa nandaa Jesús ini barca, ra nandiko ra chi inka xiyo yuꞌu tiakuii kan, ra ndaxaa ra ñuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ra saa kuu, ra ndixaa va sava na xiꞌin iin ra kueꞌe küvi kaka, ra kanduꞌu ra nuu ixto ndixaa ra xiꞌin na nuu Jesús. Ra te xini Jesús ña ndinuni ni ndiaa ini na ra, ña kuchuun ra sanduvaꞌa ra ra nduchiꞌña kan, ra saa ndikaꞌan ra xiꞌin ra nduchiꞌña kan kachi ra saa: ―Kusüchi ini kun seꞌe, chi xa xa kaꞌnu va ini yu xaꞌa kuachi kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ra ikan ndee sava na maestro sañaꞌa ndiayu Ndioxi ixtoꞌni na, ra saa ndakani ini na kaꞌan na saa: “Chee ni kuachi ke xa ra yoꞌo chi ndaa yuꞌu ra Ndioxi ña kachi ra saa”, kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ndi su kundaa va ini Jesús ña ndakani ini na, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¿Nichuun kiꞌvi ni ndakani ini ndo? ");
INSERT INTO mxv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ni ke vaꞌa kachi yu xiꞌin ra nduchiꞌña yoꞌo tuvi ndo, a vaꞌa tu na kaꞌan yu xiꞌin ra kachi yu saa: “Xa xa kaꞌnu va ini yu xaꞌa kuachi kun”, kachi yu, ra a vaꞌa ka tu na kaꞌan yu xiꞌin ra: “Ndakundichi ra kaka kun kuꞌun kun”, na kachi yu? ");
INSERT INTO mxv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ra nuu ndo saa na sandaꞌa yu ra, ra saa ke kundaa ini ndo chi yuꞌu, ra xaa yoꞌo, ra kuu mii yu ndiayu ña sakaꞌnu ini yu xaꞌa kuachi yuvi na ndee nuu ñuꞌu yoꞌo ―kachi Jesús xiꞌin na. Ra saa ndikaꞌan ra xiꞌin ra nduchiꞌña küvi kaka kan kachi ra saa: ―Ndakoo, ra ndakiꞌin kun ixto kun ra kunuꞌu kun veꞌe kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Saa ra ndikun ndakoo ra nduchiꞌña küvi kaka kan ra ndakiꞌin ra kuanuꞌu ra veꞌe va ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ra te xini takundiꞌi yuvi kan ña kuu, saa ra ndakanda ka vi ini na, ra ndasakaꞌnu ka vi na Ndioxi, xaꞌa ña taxi ra ndiee ra ndaꞌa na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ra te ndiꞌi saa ndakiꞌin Jesús kuaꞌan ra, ra xini ra iin ra nani Mateo, ra ndiso chiñu kaya xuꞌun ndaꞌa na ñuu ña kuaꞌan ndaꞌa gobierno ñuu Roma. Ña nduꞌu ra nuu mesa nuu ndakiꞌin ra xuꞌun ndaꞌa yuvi, ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Naꞌa, na koꞌo xiꞌin yu ―kachi ra xiꞌin ra. Saa ra ndikun ndakundichi ra Mateo, ra ndakundikun ra sata Jesús kuaꞌan ra xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ra saa kuu iin kii nduꞌu Jesús nuu mesa xixi ra veꞌe ra Mateo xiꞌin ndia ndikun sata ra, ra saa ndixaa kuaꞌa ni ka tu na kaya xuꞌun ña kuaꞌan ndaꞌa gobierno ñuu Roma va, ra ndixaa tu na nduꞌu tuꞌun kiꞌvi xaꞌa va, ra ndakundee na nuu mesa nuu nduꞌu Jesús xixi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ra te xini na fariseo ña nduꞌu Jesús xixi ra xiꞌin yuvi kuachi kan, ra saa ndikaꞌan na xiꞌin ndia ndikun sata ra kachi na saa: ―¿Nichuun nduꞌu ra Tata Maestro ndo xixi ra xiꞌin na kaya xuꞌun, xiꞌin yuvi kuachi kaa? ―kachi na xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ra ta xini soꞌo Jesús ña ndikaꞌan na, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Yuvi na iyoo vaꞌa ini ra xiniñüꞌu vi na kan na xa tatan, chi na xiꞌi va kuvi na xiniñuꞌu na xa tatan ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Kuaꞌan ndo ra ndakiꞌin xini ndo ni ke kuni kachi tuꞌun yoꞌo: “Chi ña kuni yu ke na kuꞌvi ni ini ndo kuni ndo na taꞌan va ndo, ra küni yu ña na soko ndo ñaꞌa nuu yu”, chi na xa vaꞌa ni ndee tuvi na, ra växi yu xaꞌa na kan, chi na iyoo kuachi va kuvi na vaxi yu xaꞌa, ña na nandiko ini na xaꞌa kuachi na, ra ndakiꞌin na ichi Ndioxi ra kaku na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Saa kuu ra ndixaa ndia itaꞌan xiꞌin ra Juan ra sakuchi yuvi nuu íin Jesús, ra nindakatuꞌun ndia ra kachi ndia saa: ―Tata, ¿nichuun kuëe iyoo suꞌun ndia itaꞌan xiꞌin kun, ra nduꞌu xiꞌin na fariseo, ra kuaꞌa ni va ichi iyoo suꞌun ndi, ña xïxi ndi? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A vaꞌa tu na kundee suchi ini na kuaꞌan nuu iyoo viko tandaꞌa, tuvi ndo? ¿Su väꞌa kita ña, chi tan íin ka va ra tandaꞌa kan xiꞌin na? Ndi su te na xaa kii ña ndakiꞌin na ra tandaꞌa kan kuꞌun ra, ra ndia saa vi ke ndoo na itaꞌan xiꞌin ra, ña koo suꞌun na, küxi na. ");
INSERT INTO mxv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ra ndia nii yuvi ra ndakäꞌma na tikoto yata xiꞌin tikoto xaa, chi tu saa na sa na, saa ra nandii va tikoto xaa, ra nandata vaꞌa ka va ña tikoto yata kan. ");
INSERT INTO mxv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ra ndia nii tu na täân vino xaa ini ñii yata, chi tu saa na sa na, saa ra ndata va ñii yata sa ra, ra kuitia ndiꞌi va ra, ra ndiꞌi tu xaꞌa mii va ñii kan, ña kan ke vino xaa, ra ini ñii xaa ke xiniñuꞌu kundoꞌni ra, ra saa ke na kuïtia ra, ra nii ñii kan ndïꞌi xaꞌa ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ra sakan saa kuu Jesús ndatuꞌun ra xiꞌin na ndichi ra, ra tuꞌva ndixaa va iin ra kuchee nuu na Judío, ra nani Jairo, ra xikusiti ra nuu Jesús ra ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Tata, ña sakan ndixiꞌi va kuvi ña loꞌo seꞌe yu, ndi su tu na kuꞌun kun xiꞌin yu, ra chinduꞌu kun ndaꞌa kun sata ña, saa ra ndatiaku va ña ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ra saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ra Jairo, ra kuaꞌan tu ndia itaꞌan xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ra te saa kuu na ndoꞌni na ichi kan kuaꞌan na, saa ra tuꞌva kanata va iin ñaꞌá, ña xatia ni ña nii, ra xa uxi uvi kuiya ke ndoꞌo ña saa, ra saa kuyachin ña chi sata Jesús ra nditiandiaa ndaꞌa ña yuꞌu tikoto ña ndixi ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chi ndakani ini ña káꞌan ña saa: “Tu na tiandiaa loꞌo ndaꞌa va yo yuꞌu tikoto ña ndixi ra, saa ra ndikun nduvaꞌa va yo”, kaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ra saa ndikokuiin Jesús, ra ndakotoꞌni ra nuu ña, ra ndikaꞌan ra xiꞌin ña kachi ra saa: ―Kuayüꞌvi kun seꞌe, chi xa nduvaꞌa va kun, xaꞌa ña ndiaa ini kun yuꞌu ―kachi ra xiꞌin ña. Saa ra ndikun mii hora kan ke nduvaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ra te ndixaa Jesús ndikiꞌvi ra veꞌe ra Jairo, ra kuchee nuu na Judío kan, ra xini ra ndee na miska tivi na, ña xa xandúvi na, ña nduxin na ña loꞌo kan, ra na kuaꞌa kan ra iin kaña kaña xaku na xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ra saa ndikaꞌan ra xiꞌin na, kachi ra saa: ―Kee ndo chi keꞌe, chi süvi ña ndixiꞌi kuvi ña loꞌo yoꞌo, chi ña kixi va kuvi ña ―kachi ra xiꞌin na. Saa ra ndixaku ndiaa va na ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ra te kee ndiꞌi na chi keꞌe xa ra, saa ra ndikiꞌvi ra veꞌe nuu kanduꞌu ña loꞌo kan, ra te tiin ra ndaꞌa ña, saa ra ndakoo va ña, chi ndatiaku ndixa va ña xa ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Saa ra ndikun kundaa ini takundiꞌi va yuvi, na ndee ñuu ña ndoꞌni kan xaꞌa ña xa Jesús, ña sandatiaku ra ña loꞌo kan. ");
INSERT INTO mxv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ra te kanata Jesús veꞌe kan, ra ndakiꞌin ra kuaꞌan ra, ra saa taxi ndikun uvi ndia kuaa sata ra, ra iin ko koꞌo kana ndia kachi ndia saa: ―Jesús, seꞌe ra David, kundaꞌvi ini kuni nduꞌu ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ra te ndixaa Jesús ndikiꞌvi ra iin veꞌe, ra saa kuyachin ndia kuaa kan nuu ra, ra nindakatuꞌun ra ndia kachi ra saa: ―¿A kandixa ndo ña kuchuun yu sandaꞌa yu ndoꞌo tuvi ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Kuchuun va kun, Tata ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Saa chinduꞌu Jesús ndaꞌa ra nuu ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Xaꞌa ña kandixa ndo yuꞌu, ña kuchuun yu sanduvaꞌa yu ndoꞌo ke, na nduvaꞌa va ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Saa ra ndikun ndanuña ndixa va nuu ndia, ra vaꞌa ka vi ndakotoꞌni ndia, ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ndia nii yuvi ndatüꞌun ndo xiꞌin xaꞌa ña sandaꞌa yu ndoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ndi su te ndakoyo ndia kuaꞌan ndia, saa ra ndikun xaꞌa va ndia ndatuꞌun ndia xiꞌin yuvi na ndee, iin nii kuvi ñuu xaꞌa ña xa Jesús xiꞌin ndia, ña sandaꞌa ra nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ra te sakan kee ndia kuaa ndia nduvaꞌa nuu kan kuaꞌan ndia, saa ra ndixaa ka tuku va yuvi nuu Jesús xiꞌin iin ra miꞌmi ra ndikaa tachi ndivaꞌa ini. ");
INSERT INTO mxv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ra te tava Jesús tachi ndivaꞌa ini tiaa ra miꞌmi kan, saa ra ndikun vaꞌa ndakaꞌan va ra. Saa ra ndakanda ni ini yuvi kan ra kachi na saa: ―Ndia nii ñuu ña ndikun ndiaa Israel yoꞌo, ra täan kuni yo ña ^kuu yoꞌo vichin ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ndi su ndia fariseo, ra suꞌva va, kachi ndia xaꞌa Jesús: ―Ndiee kiti ndivaꞌa, mii ri kuchee vaꞌa nuu takundiꞌi ña ndivaꞌa va ke iyoo xiꞌin ra; ña kan ke vaꞌa tava ra tachi ndivaꞌa ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ra iinii kuvi ñuu naꞌnu, xiꞌin ñuu vali ke ^xinuꞌni Jesús kuaꞌan ra, ña sañaꞌa ra yuvi xaꞌa ichi nuu xaꞌndia Ndioxi chiñu, ra kaꞌan ndoso ra tuꞌun Ndioxi nuu na, ra ta veꞌe ñuꞌu ta veꞌe ñuꞌu ke yaꞌa ra kuaꞌan ra; ra sandaꞌa ra takundiꞌi na xiꞌi ndia ndia ka kueꞌe, xiꞌin na ndiee ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ra te xini ra takundiꞌi yuvi na ndikun kuaꞌan sata ra, saa ra kundaꞌvi ka vi ini ra xini ra na, saa chi ndaꞌvi ka vi íin na ndee na, chi kuenda ke kuu na yuvi xika va na, ra köo mii na kiꞌin kuenda xiꞌin vi na, ra ta íin ndikachi vali ri köo ixtoꞌo va, saa íin na. ");
INSERT INTO mxv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ña ndixa ke, chi itu ña xiniñuꞌu sakee yo, ra kuaꞌa ni va kuvi ña, ndi su na sakee, ra loꞌo ni va kuvi na. ");
INSERT INTO mxv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ña kan ke xiniñuꞌu ni na kaꞌan ndo xiꞌin ra kuu xitoꞌo ña, ra na tiꞌvi ka ra na sakee kixi na, ña sakee na ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ra saa ndakana Jesús uxi uvi saa ndia itaꞌan xiꞌin ra, ra taxi ra ndiee ndaꞌa ndia ña tava ndia tachi ndivaꞌa, ra sandaꞌa tu ndia na xiꞌi ndia ndia ka mii kueꞌe va, xiꞌin na ndiee ni ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ra suꞌva ke nani uxi uvi saa ndia xitaꞌan tuun xiꞌin Jesús: Iin ra nani Simón, ra ndasama Jesús kivi ra ndakunani Pedro, iin ra nani Andrés, ñani suvi ra Pedro, iin ra nani Jacobo, iin ra nani Juan, ñani suvi ra Jacobo, ndia seꞌe ra Zebedeo; ");
INSERT INTO mxv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ra iin ra nani Felipe, iin ra nani Bartolomé, iin ra nani Tomás, iin ra nani Mateo, ra kaya xuꞌun ndaꞌa na ñuu ña kuaꞌan ndaꞌa Gobierno ñuu Roma; iin ra nani Jacobo, seꞌe ra Alfeo, iin ra nani Lebeo, ra kaꞌan tu na ña nani ra Tadeo va. ");
INSERT INTO mxv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Iin ra nani Simón ra ndixika xiꞌin na partido Zelote, iin ra nani Judas Iscariote, ra ndixiko Jesús te ndiꞌi. ");
INSERT INTO mxv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ra saa tiꞌvi Jesús uxi uvi saa ndia itaꞌan xiꞌin ra kuaꞌan ndia, ña kaꞌan ndoso ndia tuꞌun Ndioxi, ra xaꞌndia ra chiñu nuu ndia kachi ra saa: ―Xäꞌan ndo ñuu na küu judío, ra nii ñuu na Samaria kïꞌvi ndo, ");
INSERT INTO mxv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","chi sata ndikachi vali ri xinuꞌni xika sana, ri kuu ndiseꞌe ñuu Israel va ke na kuꞌun ndo. ");
INSERT INTO mxv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ra kuaꞌan ndo vichin ra kaꞌan ndoso ndo tuꞌun Ndioxi ra kachi ndo saa: “Xa kuyachin ni va kii ña kaꞌndia Ndioxi chiñu nuu yo”, kachi ndo xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ra na sandaꞌa ndo na xiꞌi, ra sandatiaku tu ndo na xa ndixiꞌi va, ra na sanduvaꞌa tu ndo na ndoꞌo kueꞌe tiaꞌyu koyo kuñu, ra na tava tu ndo tachi ndivaꞌa ini na ñuꞌu ña ini va. Ra kïꞌin ndo xuꞌun ndaꞌa na xaꞌa chiñu ña sa ndo, saa chi ña niniꞌi uun va ndo kuvi ndiee yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ra na küꞌun ndia nii loꞌo xuꞌun xiꞌin ndo, ");
INSERT INTO mxv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ra nii leka na küꞌun xiꞌin ndo ichi nuu kuꞌun ndo. Ra nii tikoto ña ndasama ndo na küꞌun xiꞌin ndo, ra nii ndixan tu ndo ke na küꞌun xiꞌin va ndo, ra saa tu itun tu katuvi va ndo, saa chi takundiꞌi na xachiñu tatu ra xiniñuꞌu kuxi va na nuu xachiñu na. ");
INSERT INTO mxv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ra te xa na xaa ndo iin ñuu chee, a iin ñuu loꞌo, ra na nanduku ndo yuvi na tiayu na kuvi kundiaa ini ndo, ra mii veꞌe na kan ke na kundee va ndo ndia te na xaa kii ña kee ndo kuꞌun ndo inka ñuu va. ");
INSERT INTO mxv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ra te xa na xaa ndo iin veꞌe, ra xiꞌna ka va ná kaꞌan ndo xiꞌin Ndioxi ña taxi ra ña vaꞌa kutaꞌvi na xiꞌin veꞌe kan. ");
INSERT INTO mxv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ra tu na ndakiꞌin mani na xiꞌin veꞌe kan ndoꞌo, saa ra ña vaꞌa ña taxi Ndioxi kutaꞌvi na, ra ndakiꞌin va na ña. Ndi su tu na kuïin na xiꞌin veꞌe kan ña ndakiꞌin mani na ndoꞌo, saa ra ña vaꞌa ña ^taxi Ndioxi kutaꞌvi na ra ndakïꞌin vi na ña. ");
INSERT INTO mxv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ra tu na kuïin yuvi kan ña ndakiꞌin mani na ndoꞌo, ra nii na kuïin tu na ña tiaa soꞌo na ña kaꞌan ndo, saa ra kee ndo ñuu na, a veꞌe na, ra na kuun ndo xaꞌa ndo ña na koyo yaka ñuu na xaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi te na xaa kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo, ra chee ni ka tundoꞌo taxi Ndioxi ndaꞌa na yoꞌo, nuu na ñuu Sodoma xiꞌin na ñuu Gomorra na sandiꞌi Ndioxi xaꞌa xinaꞌa ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ra saa ndikaꞌan ka Jesús kachi ra saa xiꞌin ndia: ―¡Ra na kundaa ini ndo! Chi yuꞌu kuvi ra tiꞌvi ndoꞌo kuꞌun ndo, ra ta iyoo ndikachi vali ri kuaꞌan tiañu ndivaꞌyu ke iyoo ndo. Ña kan ke ndichi ni na koo ndo iin ta kuꞌva iyoo ko̱o̱ ke, na koo ndo; ra vita ni tu na koo ini va ndo, iin ta kuꞌva iyoo paloma ke, na koo ndo. ");
INSERT INTO mxv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ra kuenda ni na koo ndo, chi tiin na ndoꞌo ra ndataxi na ndoꞌo ndaꞌa na chiñu, ra kani ni na ndoꞌo nuu ndakutaꞌan na yeꞌe chiñu a yeꞌe veꞌe ñuꞌu va tu. ");
INSERT INTO mxv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ra ndia nuu na chiñu naꞌnu na kuu gobierno xiꞌin na kuu rey va ke kuꞌun na xiꞌin ndo, ña taxi na kuachi xaꞌa ndo xaꞌa ña ndikun ndo yuꞌu; ra saa ke kuvi ndatuꞌun ndo xiꞌin na chiñu xaꞌa yu, ra saa ke kuvi tu ndatuꞌun ndo xiꞌin na xïni tuꞌun va yu. ");
INSERT INTO mxv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ra te na tiin na ndoꞌo kuꞌun ndo nuu na chiñu, ra na kundïꞌi ini ndo xaꞌa tuꞌun ña kaꞌan ndo xiꞌin na, ra nii na ndakäni ini ndo ni ke kachi ndo, saa chi ta xa na kaꞌan ndo xiꞌin na, ra mii va Ndioxi taxi tuꞌun ña kaꞌan ndo. ");
INSERT INTO mxv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Saa chi süvi mii ndo kuvi ndo kaꞌan, chi Tachi Yii Tata yo Ndioxi ña iyoo xiꞌin va ndo kuvi ña kaꞌan nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ra suꞌva ke kuu kii ña vaxi, na iyoo ñani, ra ndataxi na ñani na ña kuvi na xaꞌa tuꞌun Ndioxi; ra na iyoo seꞌe ra ndataxi tu na kan va seꞌe na ña kuvi na xaꞌa tuꞌun Ndioxi; ra sa tu na iyoo iva siꞌi va chi ndataxi tu na kan va iva siꞌi na ña kuvi na xaꞌa tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ra iin takundiꞌi yuvi ra kundasi ni na ndoꞌo xaꞌa ña ndikun ndo yuꞌu; ndi su na kuchuun sa ndiee ini ndia kii ndiꞌi, kuvi na kaku va. ");
INSERT INTO mxv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ra te na kanitaꞌan na xiꞌin ndo iin ñuu, ra na kee ndo kuꞌun ndo inka ñuu nuu va na, ra ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi ndia nii këe xiyo vi ndo ñuu Israel ña kaka ndo kaꞌan ndoso tuꞌun Ndioxi, saa ra xa nandiko tuku va yu. ");
INSERT INTO mxv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ra ndia nii na sakan sakuaꞌa ra küvi kachi na ña xini ka na nuu maestro na, ra saa tu iin na xachiñu tatu va chi küvi kachi na ña chee ka na nuu ra kuu xitoꞌo na. ");
INSERT INTO mxv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ra na sakan sakuaꞌa ra xiniñuꞌu na xaa na koo na ta kuꞌva iyoo maestro va na, ra saa tu iin na xachiñu tatu va chi xiniñuꞌu xaa tu na kan va ña kuu na ta kuꞌva iyoo xitoꞌo na. Ra kuni yu na kundaa ini ndo ña yoꞌo: chi tu yuꞌu, ra xaa yoꞌo, ra “ra ndivaꞌa” va kachi na xiꞌin yu, saa ra ndiee ni ka va kaꞌan na xaꞌa ndoꞌo, na ndikun sata yu ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ra saa ndikaꞌan ka ra kachi ra saa xiꞌin ndia: ―Xaꞌa ña kan ke, kuayüꞌvi ndo nuu yuvi yoꞌo. Saa chi takundiꞌi ñaꞌa ña kundäa ini na, ra kundaa ndiꞌi va ini na xaꞌa ña, ra ña iyoo seꞌe ra ndatuvi ndiꞌi tu xaꞌa ña kan va. ");
INSERT INTO mxv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ña kan ke, tuꞌun ña kaꞌan seꞌe yu xiꞌin ndo, ra na kaꞌan tuvi va ndo ña xiꞌin na, ra na kundaa ini na xaꞌa ña; ra tuꞌun ña kaꞌan yaa tu yu xaꞌa soꞌo ndo, ra na ndaa ndo ndia chi xini veꞌe kundita ndo ra kaꞌan ndoso ndo ña, ra na kuni soꞌo takundiꞌi va yuvi. ");
INSERT INTO mxv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ra kuayüꞌvi ndo kuni ndo na xaꞌni ndii, chi takua iki kuñu va ndo ke kuchuun na sandiꞌi na xaꞌa, ndi su kuchüun vi na ña sandiꞌi na xaꞌa nima ndo, ra ña xiniñuꞌu sa ndo ke, na yuꞌvi ndo kuni ndo Ndioxi va, chi ra kan kuvi ra kuu mii ndiayu ña sandiꞌi ra xaꞌa ndo xiꞌin nima ndo ra chikaa ra ña ndiaya. ");
INSERT INTO mxv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ra xa kundaa va ini ndo chi saa vali, ra núú ni va ixiko na ri, chi uvi ri ra iin xuꞌun loꞌo va kiꞌin na xaꞌa ri, ndi su nuu Ndioxi ra ndiaa yaꞌvi ni va ri, chi ndia nii ri näa ini ra xaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ndi su ndoꞌo, ra ndia ixi xini va ndo ke ndiaꞌvi nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Xaꞌa ña kan ke kuayüꞌvi ndo: chi ndoꞌo ra ndiaa yaꞌvi ni ka va ndo nuu iin tiꞌvi saa vali ―*kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Saa ndikaꞌan ka Jesús kachi ra saa: ―Ndia ndia ka yuvi na ndatuꞌun xiꞌin inka yuvi ña ndikun na yuꞌu, ra saa sa tu yuꞌu va, chi ndakuiin va yu xaꞌa na nuu Tata yu ra iyoo ndivi. ");
INSERT INTO mxv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ndi su na kukaꞌan nuu ndatuꞌun na xaꞌa yu ña ndikun na yuꞌu xiꞌin inka yuvi, saa ra saa sa tu yuꞌu va, chi sa xïni tu yuꞌu va na nuu Tata yu ra iyoo ndivi ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ra saa ndikaꞌan ka ra kachi ra saa: ―Ndakäni ini ndo ña xaa yu ña yuuvi yoꞌo ña ndachindee vaꞌa yu ndoꞌo, chi ra xaa ndataꞌvi va kuvi yu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Saa chi xaꞌa yuꞌu ke ndukuiin iin tiaa ña kanitaꞌan ra xiꞌin iva ra, ra saa tu iin ñaꞌa va, chi ndukuiin ña, ra kanitaꞌan ña xiꞌin siꞌi ña, ra saa tu iin ña ixanu va, chi ndukuiin tu ña kan va, ña kanitaꞌan ña xiꞌin ña siso ña. ");
INSERT INTO mxv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ra mii na veꞌe va ndo kuvi na ndukuiin kanitaꞌan xiꞌin ndo xaꞌa ña ndikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ra na kuꞌvi ni ka ini xini iva xiꞌin siꞌi, nuu yuꞌu, ra küvi vi kundikun na kan yuꞌu, ra saa tu na kuꞌvi ni ini xini seꞌe tiaa a seꞌe ñaꞌa va tu, nuu yuꞌu, saa ra küvi tu kundikun na kan va yuꞌu; ");
INSERT INTO mxv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ra yuvi na xïin ndoꞌo ta kuꞌva ndoꞌo yuvi na kasoko cruz, ra ndia xiꞌi va na xaꞌa ña ndikun na yuꞌu, saa ra küvi vi kuu na kuenda yu. ");
INSERT INTO mxv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ra yuvi na kuni sakaku mii, ra na ndiee ka ndoñuꞌu va kuvi na, ra na kuni sandoñuꞌu mii xaꞌa yuꞌu, kuvi na kuchuun kaku va ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ra saa ndikaꞌan ka ra kachi ra saa: ―Yuvi na ndakiꞌin mani ndoꞌo, ra yuꞌu va kuvi ra ndakiꞌin mani na; ra na ndakiꞌin mani yuꞌu, ra Tata yu Ndioxi ra tiꞌvi yuꞌu vaxi va yu kuvi ra ndakiꞌin mani na. ");
INSERT INTO mxv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ra yuvi na ndakiꞌin mani iin na kaꞌan tuꞌun yuꞌu Ndioxi, ra taꞌan ñaꞌa, ña niꞌi na kaꞌan tuꞌun yuꞌu Ndioxi kan ke niꞌi tu na kan va, ra na ndakiꞌin mani tu iin na vaꞌa na köo kuachi nuu Ndioxi, saa ra taꞌan ñaꞌa, ña niꞌi na vaꞌa kan nuu Ndioxi, ke niꞌi tu na kan va. ");
INSERT INTO mxv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ra ña ndixa kaꞌan yu xiꞌin ndo, chi ndia ndia ka iin na na taxi iin yaxin loꞌo tiakuii koꞌo iin na kuvali, na ndikun yuꞌu, ra ndïꞌi uun xaꞌa ña mani ña sa na kan nuu Ndioxi, chi ndakiꞌin va na yaꞌvi na ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ra te sandiꞌi Jesús ndataxi ra nuu uxi uvi saa ndia itaꞌan xiꞌin ra xaꞌa takundiꞌi ña yoꞌo, ra saa ndakiꞌin ra kuaꞌan ra ñuu ña ndoꞌni kan ña sañaꞌa ra yuvi, ra kaꞌan ndoso ra tuꞌun Ndioxi nuu na. ");
INSERT INTO mxv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ra ra Juan, ra sakuchi yuvi, ra veꞌe kàà va ke ndikaa ra, ra te kundaa ini ra xaꞌa ña vaꞌa ña ^xa Jesús xiꞌin yuvi, ra saa tiꞌvi ra uvi ndia itaꞌan xiꞌin ra kuaꞌan ndia nuu Jesús ");
INSERT INTO mxv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ña ndakatuꞌun ndia ra. Ra te ndixaa ndia nuu Jesús ra saa ndikaꞌan ndia kachi ndia saa xiꞌin ra: ―¿A ndixa yoꞌo kuvi ra xa iyoo tuꞌun xaꞌa kixi ña sakaku kun na yuuvi yoꞌo? ¿A xiniñuꞌu kundiatu ndi inka va ra? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ra ndatuꞌun ndo xiꞌin ra Juan xaꞌa ña ^xini ndo xiꞌin ña ^xini soꞌo ndo ra na kundaa ini ra. ");
INSERT INTO mxv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Chi na kuaa, ra ^ndakotoꞌni va na, ra na küvi kaka, ra ^ndakaka va na, ra na ndoꞌo kueꞌe tiaꞌyu; ra ^nduvaꞌa va na, ra na soꞌo, ra ^ndakuni va soꞌo na, ra na ndii, ra ^ndatiaku va na. Ra ^ndakani tu yu tuꞌun Ndioxi nuu na ndaꞌvi ña vaꞌa na kaku va na. ");
INSERT INTO mxv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ra vaꞌa ni kee yuvi na ndikun yuꞌu, ra xä uvi ini na xaꞌa tuꞌun ña kaꞌan yu xiꞌin na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ra ta ndakiꞌin ndia tiꞌvi ra Juan kuaꞌan ndia, saa xaꞌa Jesús kaꞌan ra xaꞌa ra Juan xiꞌin na ndee kan kachi ra saa: ―¿Ndixaa kaa tiaa ra ndixaꞌan ndo xini ndo iku yuu kan? ¿A xini ndo iin tiaa ra kisi ña, ta kuꞌva ndoꞌo iin ndoo ñuꞌu ta xika tachi? ");
INSERT INTO mxv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ra tu süvi saa kaa ra, ¿ra ndixaa ke kaa tiaa ra ndixaa ndo xini ndo? ¿A xini ndo iin tiaa ra ndixi tikoto vaꞌa ña yaꞌvi? Ra xa kundaa va ini ndo chi na ndixi tikoto vaꞌa, ña savi, ra vaꞌa ni va iyoo na kan, chi veꞌe vaꞌa nuu ndee na rey va ndee na. ");
INSERT INTO mxv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ra tu süvi saa kaa ra ndixini ndo, saa ra, ¿ndixaa va ke kaa ra? ¿A xini ndo iin ra kaꞌan tuꞌun yuꞌu Ndioxi va? Ndixa va, chi suvi kuvi va ra; ra chee ka va chiñu ña xa ra Juan nuu takundiꞌi na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ra xaꞌa ra Juan yoꞌo ke kaꞌan ña tiaa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ña kachi suꞌva: Yoꞌo tiꞌvi yu iin tiaa ra kuꞌun chiñu nuu yu ra kunuu ra kuꞌun ra, ña ndasavii ra ichi kun, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ra ña ndixa kaꞌan yu xiꞌin ndo, ra na kundaa ini ndo chi ra Juan ra sakuchi yuvi kuvi ra chee ka nuu takundiꞌi va na ndikaꞌan ndoso tuꞌun Ndioxi xinaꞌa. Ndi su na kuëe xiniñuꞌu vaꞌa vichin nuu xaꞌndia Ndioxi chiñu, kuvi na nduchee ka tu nuu ra Juan va. ");
INSERT INTO mxv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ndia kii te xaꞌa ra Juan, ra sakuchi yuvi kaꞌan ndoso ra tuꞌun Ndioxi, iin saa ndia vichin, ra xika nduku ña ndivaꞌa ña sandiꞌi ña xaꞌa ichi nuu xaꞌndia Ndioxi chiñu, ra takua yuvi na ndaku ini va kuvi na kuchuun kiꞌvi koo nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ra takundiꞌi na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, xiꞌin ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin ra Juan, kuvi na ndiñaꞌa ndia kuꞌva ke kuu ta xa na kaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ra na kandixa ndo ña kaꞌan yu xiꞌin ndo, chi ta iyoo ra Elías ra ndikaꞌan Ndioxi xaꞌa kixi, saa ke iyoo tu ra Juan va. Chi xaꞌa ra Juan ke ndikaꞌan va Ndioxi ña kachi ra saa. ");
INSERT INTO mxv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ra ndoꞌo na xini soꞌo, ra ná kuni ka soꞌo va ndo ña kaꞌan yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―¿Yoo kuvi na chinuu yu xiꞌin na ndee vichin? Ra na kundaa ini ndo chi ta iyoo na vali na ndakaya sasiki nuu yaꞌvi, ra kana taꞌan na kachi na saa: ");
INSERT INTO mxv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“*Tivi ndi yaa sii ini xiꞌin tiyoo ra ndixïin ndo taxaꞌa ndo; ra xita tu ndi yaa suchi ini ra ndixïin tu ndo kuaku va ndo”, ^kachi na xiꞌin taꞌan na, ra kuꞌva saa va ke xa na yuvi yoꞌo vichin. ");
INSERT INTO mxv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Saa chi kixi ra Juan ra sakuchi yuvi, ra ndixïxi ni ra, ra nii vino ndixïꞌi ra, ra tachi ndivaꞌa va iyoo xiꞌin ra kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ra vichin xa̱a tu yuꞌu, ra tiꞌvi Ndioxi; ra xíxi yu, ra xiꞌi yu vino, ra kaꞌan ndo xaꞌa yu: ña kini ni xixi yu, ra kini ni xiꞌi yu vino, ra itaꞌan tu yu xiꞌin yuvi kuachi, xiꞌin na kaya xuꞌun kuaꞌan ndaꞌa gobierno ñuu Roma va, kachi ndo xaꞌa yu. Ndi su na ndakiꞌin ña vaꞌa, ña ndichi ña táxi Ndioxi kuvi yuvi na ndañaꞌa mii ña kúu na seꞌe va ra, chi xiin va na kandixa na ña sañaꞌa ra Juan, ra saa tu ña ^sañaꞌa yuꞌu va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ra saa xaꞌa Jesús kaꞌan ra xaꞌa ña ndikindöo ini ra xiꞌin chiñu ña ^xa na ñuu nuu xa ra kuaꞌa ni ña xituꞌun, saa chi ndiee ni ini na, chi ndixïin na ña nandiko ini na xaꞌa kuachi na, ra ndakiꞌin na ichi Ndioxi, ña kan ke ndikaꞌan Jesús xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ndaꞌvi ni ndoꞌo, na ñuu Corazín, xiꞌin ndoꞌo, na ñuu Betsaida! Chi tu ta ñuu na Tiro xiꞌin na Sidón, ndixa yu taꞌan ña xituꞌun ña xa yu ñuu ndo yoꞌo, saa ra xa yachi vi nandiko ini na kan ra ndakiꞌin va na ichi Ndioxi; ra xa ndakundixi ndaꞌvi va na iin tikoto ña tumi, ña kueꞌe ni, ra xa ndakundee tu na nuu yaa nuꞌu va, ña ndañaꞌa na mii na ña xa̱ ndandiko ini na xaꞌa kuachi na. ");
INSERT INTO mxv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ra xaꞌa ña kan ke ndoꞌo ni ka va ndoꞌo na ñuu Corazín, xiꞌin na ñuu Betsaida, nuu na ñuu Tiro, xiꞌin na ñuu Sidón, kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ra ndoꞌo, na ñuu Capernaum, ra xa ndivi va ke ndee ndo tuvi ndo, ndi su ndia kaꞌa yavi nuu ñuꞌu na ndii va ke saxinu Ndioxi ndoꞌo, saa chi ndixïin ndo ña kandixa ndo. Ra tu taꞌan ñuu Sodoma ndixa yu ña xituꞌun ña xa yu ñuu ndo yoꞌo, saa ra kandixa va na ñuu kan, ra ndïꞌi vi xaꞌa na, ra ndee na ndia vichin va. ");
INSERT INTO mxv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ña kan ke kaꞌan yu xiꞌin ndo vichin, chi te na xaa kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo, ra ndiee ni ka va kaa tundoꞌo ña taxi Ndioxi ndaꞌa ndoꞌo na ñuu Capernaum nuu na ñuu Sodoma ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saa kuu iin kii ra ndikaꞌan Jesús xiꞌin Ndioxi kachi ra saa: ―Ndasakaꞌnu yu yoꞌo, Tata, chi yoꞌo kuvi ra xaꞌndia chiñu ndivi ra saa tu nuu ñuꞌu yoꞌo va, saa chi chikaa seꞌe va kun ña vaꞌa yoꞌo nuu na ndichi xiꞌin nuu na kundaa ni ini, ra ndañaꞌa kun ña nuu na ndaꞌvi, na kundäa ini, na iyoo ta kuꞌva iyoo na kuachi vali. ");
INSERT INTO mxv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ra saa xa kun, Tata, chi saa kuni mii kun koo va ―kachi Jesús xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ra saa ndikaꞌan ka Jesús xiꞌin na ndee kan kachi ra saa: ―Tata yu kuvi ra ndataxi takundiꞌi ñáꞌa ndaꞌa yu. Ra ndia nii na xïni yuꞌu; chi indaa mituꞌun Tata yu Ndioxi va kuvi ra xini yuꞌu. Ra ndia nii tu na xïni Tata va yu, chi indaa yuꞌu, ra kuu seꞌe va ra kuvi ra xini ndia kuꞌva ke iyoo ra, ra saa tu yuvi na ndañaꞌa yu ra nuu va. ");
INSERT INTO mxv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ra takundiꞌi ndoꞌo, na kuñaa xachiñu, xiꞌin ndoꞌo, na kuñaa ndiso, ra naꞌa ndo nuu yu ra yuꞌu kuvi ra taxi ndakindiee ndo. ");
INSERT INTO mxv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ra na kandixa ndo chiñu ña taxi yu ndaꞌa ndo, ña kaꞌan yu kuu iin íku yu, ra na sakuaꞌa ndo nuu yu, chi yuꞌu ra kaꞌnu ni va ini yu, ra ndaꞌvi ni tu ini va yu; ra saa ke kuvi niꞌi ndo ña ndakindiee nima ndo. ");
INSERT INTO mxv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Saa chi chiñu ña taxi yu ndaꞌa ndo ra üꞌvi ña, ra nii ñaꞌa ña taxi yu kuiso ndo ra vëe ña. Chi ta iyoo iin íku tu kama ni va, saa iyoo ña chi üꞌvi ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saa kuu iin kii sábado, kii yii, ra ndiyaꞌa Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra iin nuu iyoo itu trigo, ra saa xaꞌa ndikaꞌun ini ndia itaꞌan xiꞌin ra, ra xaꞌa ndia xaꞌnu ndia yoko itu trigo kan, ra ^sakoyo ndia nuni vali sata ña ^xaxi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ra ta xini ndia fariseo, ra saa ndikaꞌan ndia xiꞌin Jesús kachi na saa: ―Kutoꞌni, nichuun xa ndia itaꞌan xiꞌin kun saa: chi köo ndiayu ndaꞌa yo ña sa yo saa kii yii sábado, chi kii ndakindiee va yo ke ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A täan va kaꞌvi ndo tuꞌun Ndioxi ña ndakani xaꞌa ra rey David, ña xa ra te ndikaꞌun ini ra xiꞌin ndia kuaꞌan xiꞌin ra? ");
INSERT INTO mxv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ra na kundaa ini ndo chi suꞌva va ke kachi tuꞌun Ndioxi ndakani ña. Ra rey David, ra ndikiꞌvi va ra ini veꞌe ñuꞌu Ndioxi ra kiꞌin ra ixtavaꞌa yii, ña soko na, ña iyoo ini veꞌe ñuꞌu kan xixi ra xiꞌin ndia kuaꞌan xiꞌin ra, ra köo ndiayu ra ña kuxi ra ña, chi takua na sutu va kuvi na iyoo ndiayu kuxi ña. ");
INSERT INTO mxv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ra a täan kaꞌvi tu ndo ndiayu Ndioxi ña ndakoo ra Moisés, ña kaꞌan ña na sachïñu ndia nii yuvi kii yii sábado, ndi su ndia sutu ra xa va ndia kan chiñu ini veꞌe ñuꞌu kaꞌnu, ra köo vi tu na kaꞌan kuachi xaꞌa ña xa ndia kan? ");
INSERT INTO mxv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ra na kaꞌan yu xiꞌin ndo ra kundaa ini ndo, chi kaꞌnu ni ka va yuꞌu ra íin xiꞌin ndo yoꞌo vichin nuu veꞌe ñuꞌu kaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ndi su ndoꞌo, ra na täan kundaa ini va kuvi ndo ni ke kuni kachi tuꞌun Ndioxi ña kaꞌan kachi suꞌva: “Küni yu ña na kaꞌni ndo kiti ra soko ndo ri nuu yu, chi ña kuni yu ke na kuꞌvi ni ini ndo kuni taꞌan va ndo”, kachi ña. Ra tu ndikundaa ini ndo xiꞌin tuꞌun yoꞌo, saa ra käꞌndia vi ndo chiñu ña na sandoꞌo na yuvi ndaꞌvi na köo kuachi. ");
INSERT INTO mxv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ndi su, yuꞌu ra xaa yoꞌo vichin, kuvi ra iyoo ni ka ndiayu ndaꞌa xaꞌa kii yii sábado, ndia ña ke kuvi sa yo, ra ndia ña ke küvi sa yo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Saa ndakiꞌin Jesús kuaꞌan ra, ra ndixaa ra ndikiꞌvi ra iin veꞌe ñuꞌu nuu ndakutaꞌan na ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ra ini veꞌe ñuꞌu kan nduꞌu iin tiaa ra ndachi iin xiyo ndaꞌa; ra ndia fariseo ra xika nduku ni ndia ndixaa sa ndia, ña vaꞌa kuchuun ndia taxi ndiaa kuachi xaꞌa Jesús, ra saa nindakatuꞌun ndia ra kachi ndia saa: ―¿A kuvi sandaꞌa yo iin na xiꞌi kii ndakindiee? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Tu ndia iin ndo iyoo iin ndikachi loꞌo sana, ra na ndakava ri ini iin yavi kii yii, ¿ra a küꞌun ndo tava ndo ri? ¿Su kuꞌun va ndo tava ndo ri ini yavi kan? ");
INSERT INTO mxv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ra na kundaa ini ndo, chi ndiaa yaꞌvi ni ka va iin yuvi nuu iin ndikachi loꞌo; ra xaꞌa ña kan ke kuvi va sa yo ña vaꞌa kii yii sábado ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ra saa ndikaꞌan Jesús xiꞌin tiaa ra ndachi ndaꞌa kan kachi ra saa: ―Sandakaa ndaꞌa kun ―kachi ra xiꞌin ra. Ra saa sandakaa tiaa kan ndaꞌa ra, saa ra ndikun nduvaꞌa va ña, ra nduu ña ta kaa inka ña vaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ra te kee ndia fariseo kan chi keꞌe, ra saa ndikataꞌan ndia ndixaa sa ndia, ña kuvi kaꞌni na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ra ta kundaa ini Jesús xaꞌa ña kuni ndia sa ndia xiꞌin ra, ra saa kanata ra ini veꞌe ñuꞌu kan ra ndakiꞌin ra kuaꞌan ra inka xiyo va, ra kuaꞌa ka vi yuvi ndakundikun sata ra kuaꞌan na xiꞌin ra. Ra sandaꞌa ra takundiꞌi va na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ra saa xaꞌndia ra chiñu nuu na ña na ndatüꞌun na xiꞌin ndia nii yuvi xaꞌa ra, ña sandaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ra suꞌva ke kuu ña ndixinu nuu tuꞌun Ndioxi, ña ndikaꞌan ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ña kachi suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Koto ndo, chi ra yoꞌo kuvi ra xachiñu nuu yu, ra ndikaxin yu; ra kuꞌvi ni ini yu xini yu ra, ra kusii ni ini yu xiꞌin ra. Ra taxi yu Tachi Yii yu koo ña xiꞌin ra, ra kaꞌan ndoso ra tuꞌun yu nuu takundiꞌi na yuuvi, ra kundaa ini na ña sandaku yu kuachi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ra ndatüꞌun kuachi ra xiꞌin ndia nii yuvi, ra nii kañäꞌa tu ra xiꞌin va na; ra ndia nii tu na küni soꞌo ña kana ra kaka ra yaꞌya va. ");
INSERT INTO mxv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ra yuvi na xa takueꞌe, na ndoꞌo, ta kuꞌva ndoꞌo iin ndoo ñuꞌu tun xa nditaꞌnu, ra satakuëꞌe ka ra na; ra nii iꞌva loꞌo ña sakan ndixikun, ndäꞌva ra, ra saa ke ^sa va ra ndia te xaa kii ña ndakiꞌin ra kaꞌndia ra chiñu xiꞌin ña ndaa va. ");
INSERT INTO mxv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ra takundiꞌi na yuuvi yoꞌo, ra indaa ra yoꞌo va kuvi ra kundiaa ini na, kachi Ndioxi ndikaꞌan ra, kachi ra Isaías. ");
INSERT INTO mxv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ra saa ndixaa sava na nuu Jesús xiꞌin iin tiaa ra küvi kaꞌan, ra kuaa va tu ra, saa chi tachi ndivaꞌa va ke tiin ñaꞌa, ra saa sandaꞌa Jesús tiaa kan ra vaꞌa ka vi ndakutoꞌni ra, ra vaꞌa tu ndakaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Saa ra takundiꞌi yuvi na xini ña kuu kan, ra ndakanda ka vi ini na, ra iin ndakatuꞌun taꞌan na kachi na saa: ―¿A ra yoꞌo kuvi ra kuu ndiseꞌe ra David, ra tiꞌvi Ndioxi kixi sakaku yoo? ―kachi na xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ndi su te xini soꞌo ndia fariseo, ña kachi yuvi kan saa xaꞌa Jesús, saa ra ndikaꞌan ndia kachi ndia saa: ―Ndiee ti Beelzebú mii ti kuchee vaꞌa nuu takundiꞌi ña ndivaꞌa va ke iyoo xiꞌin ra, ña kan ke vaꞌa tava ra tachi ndivaꞌa ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ra kundaa va ini Jesús ña ndakani ini ndia, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Takundiꞌi ñuu naꞌnu ña kanitaꞌan xiꞌin taꞌan mii, ra kuchüun vi ña koo ña, chi ndiꞌi va xaꞌa ña; ra saa tu iin ñuu va, a iin veꞌe va tu, saa chi tu na xaꞌa na kanitaꞌan na xiꞌin taꞌan mii na, saa ra kuchüun na koo vi na chi ndiꞌi va xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ra saa tu kiti ndivaꞌa va, chi tu na ndukuiin ri kanitaꞌan ri xiꞌin taꞌan mii ri; saa ra kuchüun vi ri koo ri, chi ndiꞌi xaꞌa va ri. ");
INSERT INTO mxv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ra kachi yu suꞌva xiꞌin ndo, saa chi kaꞌan ndo, ña tava yu tachi ndivaꞌa xiꞌin ndiee ti Beelzebú, ri kuchee nuu takundiꞌi ri ndivaꞌa; ra tu saa iyoo ña, saa ra, ¿yoo ku ra taxi ndiee ndaꞌa na ndikun sata ndo ña vaꞌa tava na tachi ndivaꞌa tu saa? Ra na kundaa ini ndo chi süvi xiꞌin ndiee ri ndivaꞌa ke tava na ña. Ña kan ke kundaa vaꞌa va ini na ña väꞌa iyoo ndo. ");
INSERT INTO mxv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ra ña tava yu tachi ndivaꞌa vichin xiꞌin ndiee Tachi Yii Ndioxi, ra ña yoꞌo kuni kachi ña saa, ña xa xaa Ndioxi xaꞌndia ra chiñu nuu va ndo. ");
INSERT INTO mxv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ra na kundaa ini ndo vichin: ¿Ndixaa sa iin yuvi ña vaꞌa kiꞌvi na veꞌe iin tiaa ra ndaku ni ña sakuiꞌna na ñaꞌa ra, tu na chikätun na ra, tuvi ndo? Su xiꞌna ka va xiniñuꞌu katun na ra, ra saa vi ke kuvi kiꞌvi na veꞌe ra ña sakuiꞌna na. ");
INSERT INTO mxv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ra yuvi na kuäꞌan ndiee yu, ra na kanitaꞌan xiꞌin va yu kuvi na, ra na xïin tu sachiñu xiꞌin yu, ra na sandiꞌi xaꞌa chiñu va yu kuvi na. ");
INSERT INTO mxv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ña kan ke kaꞌan yu xiꞌin ndo ra na kundaa ini ndo, chi Ndioxi ra koo kaꞌnu va ini ra xaꞌa takundiꞌi kuachi ña xa yuvi, xiꞌin ña kañaꞌa na xaꞌa ra, ndi su na kañaꞌa xaꞌa Tachi Yii Ndioxi, ra köo kaꞌnu ini ra xaꞌa vi na kan. ");
INSERT INTO mxv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ra takundiꞌi yuvi na kañaꞌa xaꞌa yuꞌu ra xaa yoꞌo, ra koo kaꞌnu va ini Ndioxi xaꞌa na kan, ndi su na kañaꞌa xaꞌa Tachi Yii Ndioxi, ra köo kaꞌnu ini ra xaꞌa vi na kan kii ña ndee yo vichin, ra nii kii ña vaxi köo kaꞌnu tu ini ra xaꞌa vi na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Takundiꞌi itun kuiꞌi tu vaꞌa, ra kuiꞌi ña vaꞌa ke kuun ndaꞌa va nu; ra itun kuiꞌi tu väꞌa, ra kuiꞌi ña väꞌa ke kuun ndaꞌa va nu; ña kan ke xiꞌin kuiꞌi ña kuun ndaꞌa va itun ke ndakuni yo nu. ");
INSERT INTO mxv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ndi su ndoꞌo, ra yuvi ñàꞌa va kuvi ndo, chi ña sañaꞌa ndo, ra ta iyoo ndutia xatu ra kee yuꞌu ko̱o̱ va iyoo ña. Ra ña kuu ndo yuvi ñaꞌa, saa ra küvi vi kaꞌan ndo tuꞌun vaꞌa. Ra na kundaa ini ndo, chi takundiꞌi tuꞌun ña iyoo nima yuvi ke kaꞌan va na. ");
INSERT INTO mxv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yuvi vaꞌa, ra tuꞌun vaꞌa ke kaꞌan va na, saa chi ña vaꞌa ke iyoo nima va na, ra yuvi ñàꞌa, ra tuꞌun ñàꞌa ke kaꞌan va na, saa chi nima na, ra ña väꞌa ke iyoo va. ");
INSERT INTO mxv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ña kan ke kaꞌan yu xiꞌin ndo, ra na kundaa ini ndo, chi takundiꞌi tuꞌun kiꞌvi ña kaꞌan ndo, ra sandaku va Ndioxi kuachi xiꞌin ndo xaꞌa ña, te na xaa kii ña sandaku ra kuachi xiꞌin takundiꞌi na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Saa chi xiꞌin mii tuꞌun ña kaꞌan ndo ke sandaku Ndioxi kuachi xiꞌin va ndo: tu ña vaꞌa ndikaꞌan ndo, saa ra kaku va ndo, ra tu ña väꞌa va tu ndikaꞌan ndo, saa ra niꞌi ndo tundoꞌo va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Saa ndikaꞌan sava ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia fariseo, kachi ndia saa xiꞌin Jesús: ―Tata Maestro, kuni ndi na sa kun iin ña xituꞌun ña täan kuni ndi, ña vaꞌa na kundaa ini ndi ña ndixa Ndioxi kuvi ra tiꞌvi yoꞌo xaa kun ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Yuvi ñàꞌa na xïin kandixa Ndioxi na ndee tiempo vichin, ra kuni na ña na sa yu iin ña xituꞌun kuni na, ndi su ndia nii ña xituꞌun sä yu kuni na, chi ndia taꞌan ña ndoꞌo ra Jonás, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va ke sa yu kuni na. ");
INSERT INTO mxv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Saa chi ta kuꞌva ndoꞌo ra Jonás, ña xindikaa ra ini iin tiaka chee uni kaꞌñu xiꞌin uni ñuu, ra saa ke kuu tu xiꞌin yuꞌu ra xaa yoꞌo va, chi uni kaꞌñu xiꞌin uni ñuu ke kundikaa tu yuꞌu va tixi ñuꞌú. ");
INSERT INTO mxv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ra te na sandaku Ndioxi kuachi xiꞌin na yuuvi yoꞌo, ra na ñuu Nínive, ra ndakuita va na ra taxi na kuachi xaꞌa yuvi na ndee tiempo vichin, ra kaꞌan na xiꞌin Ndioxi ña na sandoꞌo ra na, saa chi na ñuu Nínive, ra nandiko va ini na te xini soꞌo na tuꞌun Ndioxi ña ndikaꞌan ndoso ra Jonás nuu na. Ra na kundaa ini ndo chi kaꞌnu ni ka va yuꞌu, ra iin yoꞌo vichin nuu ra Jonás. ");
INSERT INTO mxv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ra saa tu ña reina ña kee chi ninu nuu kaꞌan na kuu sur, ra ndakundichi tu ña kan va, ña taxi ña kuachi xaꞌa na yuvi na ndee tiempo vichin, ra kaꞌan ña ña na sandoꞌo Ndioxi na, kachi ña, kii te na sandaku Ndioxi kuachi xiꞌin na, saa chi ña kan ra kani ni kee ña, ña kixi ña xini soꞌo ña tuꞌun ndichi ña ndikaꞌan ra rey Salomón. Ra na kundaa ini ndo chi kaꞌnu ka va yuꞌu, ra iin yoꞌo vichin nuu ra rey Salomón ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ra saa ndikaꞌan ka Jesús xiꞌin ndia, kachi ra saa: ―Ta kee tachi ndivaꞌa ini iin yuvi ra suꞌva va ke xa ña: ^kee ña ra ndakiꞌin ña kuaꞌan ña iinii kuvi iku yuu, chi nuu köo ndia nii ñaꞌa, nuu ichi ní, ña xika nduku ña nuu koo ña ndakindiee ña, ndi su ndanïꞌi ka ña nuu koo ña. ");
INSERT INTO mxv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Saa ra kaꞌan ña xiꞌin mii ña kachi ña saa: “Vaꞌa ka va na nandiko yo veꞌe chi nuu kee yo”, kachi ña. Ra saa te nandiko ña ndaxaa ña nuu ndixiyo ña, ra ndia nii ka ñaꞌa köo veꞌe kan, ra vaꞌa ka vi ndatiꞌvi na, ra vii ka vi nduu veꞌe kan xa na. ");
INSERT INTO mxv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ra saa ^ndakiꞌin tuku tachi ndivaꞌa kan kuaꞌan ña, ra ^nanduku ña inka uxa nuu tachi ndivaꞌa, ña kini ni ka nuu mii ña ^xaa xiꞌin ña, ra saa ^nandee takundiꞌi ña ini veꞌe kan, ña koo ña. Saa ra yuvi na ndoꞌo saa ña xindikaa tachi ndivaꞌa ini na, ra na ndiee ka ndasa va kuvi na, nuu ña ndixiyo na ta yachi. Ra suꞌva ke ndoꞌo tu yuvi ndivaꞌa, na ndee tiempo vichin va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ra saa kuu Jesús ndatuꞌun ka ra xiꞌin yuvi kan, saa ra ndixaa va siꞌi ra xiꞌin na ñani ra, ra xikundita na chi keꞌe ña ndiatu na ra, chi kuni na kaꞌan na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Saa ndikaꞌan iin na ndee kan xiꞌin ra kachi na saa: ―Tata, chi keꞌe íin siꞌi kun xiꞌin na ñani kun, ra kuni na kaꞌan na xiꞌin kun ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ra saa ndakuiin Jesús kachi ra saa: ―¿Yoo kuvi na kuu siꞌi yu, ra yoo kuvi na kuu tu ñani yu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ra saa sañaꞌa ndaꞌa ra na xika xiꞌin ra, ra ndikaꞌan ra kachi ra saa: ―Na yoꞌo va kuvi siꞌi yu xiꞌin ñani yu. ");
INSERT INTO mxv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Saa chi takundiꞌi yuvi na xanduvi ña kaꞌan Tata yu, ra nduꞌu ndivi va, kuvi na kuu ñani yu, xiꞌin kuꞌva yu, xiꞌin siꞌi yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ra suvi mii kii kan kee Jesús veꞌe nuu íin ra, ra ndakiꞌin ra kuaꞌan ra chi yuꞌu tiañuꞌu, ra ikan ndixaa ra xikunduꞌu va ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ra kuaꞌa ka vi yuvi ndakaya xaa nuu nduꞌu ra, ra saa nandaa ra ini iin barca loꞌo ndakunduꞌu ra, ra takundiꞌi yuvi kan xikundita yuꞌu tiañuꞌu kan va. ");
INSERT INTO mxv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Saa ra kuaꞌa ka vi ña xaꞌa ra sañaꞌa ra na, ra niña xiꞌin tuꞌun ndichi ke sakuaꞌa ra na, ra saa ndikaꞌan ra iin tuꞌun ndichi xiꞌin na kachi ra saa: ―Saa kuu, ra kee iin ra chiꞌi kuaꞌan ra chiꞌi ra itu trigo ñuꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ra saa kuu ra xatia yava ra nuni vali kan kuaꞌan ra, ra sava ña ndikoyo yachin yuꞌu ichi, ra ^xaa sàà, ra ndakiꞌin ri ña xaxi va ri. ");
INSERT INTO mxv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ra sava tu ña ndikoyo nuu iyoo yuu, nuu köo kuaꞌa ñuꞌú, ra kama ni va nindutia ña, saa chi yaxin ni va nduꞌu ñuꞌú. ");
INSERT INTO mxv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Saa ra te kanata ñuꞌù, ra xii va ña, saa chi kuëe kunu ndoꞌni tioꞌo ña, ña kan ke ndachi va ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ra sava tu ña ndikoyo nuu iyoo ndikin ìñu̱, ra nindutia va ña, ndi ndiküvi kuaꞌnu ña, saa chi ìñu̱ kan va sanduxin ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ra sava tu ña ndikoyo nuu ñuꞌu xaꞌan, ra tiaa ni va vaꞌa xaꞌnu ña, chi indaa tata loꞌo, ra ndia iin ciento nuni, xiꞌin ndia uni xiko nuni, xiꞌin ndia oko uxi nuni vali taxi, ta iin ta iin yoko itu trigo kan ―kachi Jesús xiꞌin na ");
INSERT INTO mxv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndóꞌo̱, na xini soꞌo ña kaꞌan yu xiꞌin ndo yoꞌo, ra na ndakiꞌin xini ndo xiꞌin ña, ni ke kuni kachi ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Saa kuyachin ndia itaꞌan xiꞌin Jesús, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, ¿nichuun niña xiꞌin tuꞌun ndichi ke sakuaꞌa kun yuvi kan? ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Ndoꞌo, ra xa mii va Ndioxi kuvi ra ^taxi ndiayu ña na kundaa ini ndo xaꞌa ichi ra nuu xaꞌndia ra chiñu, ña iyoo seꞌé, ndi su na kan, ra täxi ra ña ndaꞌa na ña kundaa ini na. ");
INSERT INTO mxv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Saa chi yuvi na xiin kuni soꞌo ña sañaꞌa yu, ra kundaa ni ka va ini na, ra koo ni ka tu ña xini tuni va na; ra na xïin kuni soꞌo ña sañaꞌa yu, ra ndia ña loꞌo ña xa kundaa ini na ke nundiaa ndaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xaꞌa ña kan ke xiꞌin tuꞌun ndichi va kaꞌan yu xiꞌin na; ra vaꞌa ni ixtoꞌni tieꞌe va na, ndi su küni na, ra vaꞌa ni tiaa soꞌo va na ña kaꞌan yu xiꞌin na, ndi su küni soꞌo na, ra nii kundäa tu ini va na ni ke kaꞌan yu xaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ra xiꞌin ña yoꞌo ke xinu nuu tuꞌun Ndioxi ña ndikaꞌan ra Isaías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ta kachi ra suꞌva: Nii na tiaa ni va soꞌo na, ra xa saa kundäa ini vi na ni ke kuni kachi tuꞌun ña xini soꞌo na, ra vaꞌa ni ixtoꞌni tieꞌe va tu na, ra xa saa küni vi na. ");
INSERT INTO mxv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Saa chi yuvi yoꞌo: ra ña xinuꞌni va ke xinituni na, saa chi ^ndasi na soꞌo na, ra ^ndasi tu na nuu va na, ña na küni na, ra nii na küni tu soꞌo va na, ra na ndasäma na mii na, saa ra kundäa ini na xiꞌin ña xini na, ra küni tu soꞌo va na ña kaꞌan yu xiꞌin na, ra nii na nandïko na nuu yu, ña sandaꞌa yu na, kachi Ndioxi, kachi ra Isaías. ");
INSERT INTO mxv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ndi su ndoꞌo ra vaꞌa ni va ^kee ndo, saa chi xini va ndo chiñu ña xa yu, ra xini tu soꞌo ndo tuꞌun ña kaꞌan va yu. ");
INSERT INTO mxv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ra na kundaa ini ndo, chi ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi tiaa ni kuaꞌa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, xiꞌin yuvi toꞌo na xindikun Ndioxi, ra kuni ni na kuni na taꞌan ña ^xini ndo yoꞌo vichin, ndi su ndixïni na ña; ra kuni ni tu na kuni soꞌo na taꞌan ña ^xini soꞌo ndo yoꞌo vichin va, ndi su ndixïni soꞌo na ña ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Tiaa soꞌo ndo ña ndatuꞌun yu xiꞌin ndo xaꞌa tuꞌun ndichi xaꞌa ra chiꞌi, ni ke kuni kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yuvi na xini soꞌo tuꞌun ña kaꞌan xaꞌa ichi nuu xaꞌndia Ndioxi chiñu, ra kundäa ini na ni ke kuni kachi ña, saa ra xaa ti ndivaꞌa tava ri ña nima va na, ra naa ini va na xaꞌa ña. Ra na yoꞌo kuvi na iyoo ta kuꞌva iyoo nuni vali ña ndikoyo yachin yuꞌu ichi. ");
INSERT INTO mxv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ra nuni vali ña ndikoyo nuu iyoo yuu, kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ra ndikun ndakiꞌin va na ña, ra kusii ka vi ini na xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ndi su kuëe kunu ndoꞌni tioꞌo ña nima na, ra loꞌo ni va kii kandixa na, saa ra te xaꞌa tixuꞌvi na, a te vaxi tundoꞌo nuu na xaꞌa ña ^ndíku̱n na ichi Ndioxi, saa ra ndikun ndiko ini va na. ");
INSERT INTO mxv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ra nuni vali ña ndikoyo tiañu ìñu̱ kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ndi su xaꞌa ndakundiꞌi ini na xaꞌa ñaꞌa ña iyoo nuu ña yuuvi yoꞌo va, ra xaꞌa ndakundiꞌi tu ini na xaꞌa ña kuika va. Saa ra kuee kuee naa ini va na xaꞌa ichi Ndioxi, saa ra ta kuꞌva iyoo tata ña köo ñaꞌa taxi vi iyoo na. ");
INSERT INTO mxv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ra nuni vali ña ndikoyo nuu ñuꞌu xaꞌan kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ra kundaa ini na xiꞌin ña, ra na yoꞌo kuvi na iyoo ta kuꞌva iyoo tata ña vaꞌa ni xaꞌnu, ra vaꞌa ka vi kuchuun ña, ra ndia iin ciento, ndia uni xiko, xiꞌin ndia oko uxi va nuni vali taxi ta iin ta iin yoko itu trigo kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Saa ndikaꞌan ka Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo iin tiaa ra ndixaꞌan chiꞌi nuni trigo ña vaꞌa iin nuu ñuꞌu ke iyoo ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ra te ndiꞌi, saa ra kuñuu va, ra te xa ndikixi takundiꞌi na, ra saa xaa iin ra sáa̱̱ ini, ra chiꞌi ra ndikin iku ñàꞌa tiañu tata trigo kan, ra ndakiꞌin ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ra te ndixinu itu trigo kan ña xa kuyoko ña, ra saa ndixinu tu iku ñàꞌa kan va, ra saa xini va ndia xachiñu nuu ra kuu ixtoꞌo ñuꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ra saa ndakiꞌin ndia ndixaꞌan ndia, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: “Tata, ¿a su niña nuni trigo, ña vaꞌa va kuvi ña chiꞌi kun nuu ñuꞌu kun? ¿Ra nichuun tu nindutia iku ñaꞌa xiꞌin ña?”, kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Saa ndikaꞌan ra ixtoꞌo ñuꞌu kan kachi ra saa xiꞌin ndia: “Iin ra sáa̱̱ ini xini yuꞌu va kuvi ra ndixaꞌan chiꞌi iku ñàꞌa kan”, kachi ra. Ra saa ndikaꞌan ndia xachiñu nuu ra kachi ndia saa xiꞌin ra: “Tata, ¿a kuni kun, tu na kuꞌun ndi ra tuꞌun ndi iku ñàꞌa kan?”, kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ra saa ndikaꞌan ra kachi ra saa xiꞌin ndia: “Küvi, saa chi tu köo, ra iyo ni tuꞌun ndo itu trigo xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ra vaꞌa ka na koo va ña, ra inuu na kuaꞌnu uvi saa va ña, ra ndia te na xaa kii ndakaya ña, ra saa kaꞌndia yu chiñu nuu na sakee, ña ndakaya na xiꞌna ka iku ñàꞌa kan, ra katun na ña ta numi ta numi, ra kaꞌmi na ña; ra te xa na ndiꞌi, saa ndakiꞌin na trigo, ra chivaꞌa na ña ini yaka yu”, kachi ra xiꞌin ndia xachiñu nuu ra ―kachi Jesús xiꞌin yuvi ndee xini soꞌo kan. ");
INSERT INTO mxv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Saa ndikaꞌan Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo iin ndikin loꞌo ña nani mostaza ña ndixaꞌan iin tiaa chiꞌi ra nuu ñuꞌu va ra ke, iyoo ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ra xa kundaa va ini ndo, chi ndikin itun mostaza kan ke loꞌo nuu takundiꞌi va ndikin ña iyoo nuu ña yuuvi yoꞌo; ra vaꞌa ni loꞌo ni va ña, ndi su te ndutia ña ra xaꞌa ña xaꞌnu va ña, ra tiaa ni ka va chee xaꞌnu itun ña kan nuu takundiꞌi ka itun tu iyoo xiꞌin ña; ra naꞌnu ka vi xaꞌnu itun ndaꞌa ña, ra ndia sàà va xáá ^xavaꞌa chiꞌyo ndaꞌa itun ña. Ra kuꞌva saa ke iyoo tu ichi ña kuaꞌan nuu ^xaꞌndia Ndioxi chiñu va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ra saa ndikaꞌan ka Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo loꞌo ixan iyá ña kavanuu iin ñaꞌa xiꞌin kuaꞌa ni ixan ixtavaꞌa va ke, iyoo ña. Chi vaꞌa ni loꞌo ni va kuvi ixan iyá ña chikaa ña xiꞌin ña, ra kuchuun va ña, ña sandanañu ña ña, ra kuaꞌa ka vi nduu ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ra takundiꞌi ña sañaꞌa Jesús na, ra niña xiꞌin tuꞌun ndichi taꞌan ña yoꞌo va ke xiniñuꞌu ra ña sañaꞌa ra na. Ra ndia nii ichi ndisañäꞌa ra na ña iin saa koo sañaꞌa ra na, chi niña xiꞌin tuꞌun ndichi va ke sañaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ra suꞌva ke kuu ña vaꞌa ndixinu nuu tuꞌun ña ndikaꞌan iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ta kachi ra suꞌva: Niña xiꞌin tuꞌun ndichi ke kaꞌan yu xiꞌin yuvi, ra ndatuꞌun yu xiꞌin na xaꞌa ñaꞌa ña iyoo seꞌé, ndia te kivi chituni Ndioxi ña yuuvi, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ra saa te ndiꞌi ndatiꞌvi Jesús yuvi kan kuanuꞌu na, ra saa nandiꞌvi ra ini veꞌe, ra saa kuyachin ndia itaꞌan xiꞌin ra, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, ndatuꞌun xiꞌin ndi ra na kundaa ini ndi, ni ke kuni kachi tuꞌun ndichi ña ndikaꞌan kun xaꞌa iku ñàꞌa ña kana tiañu itu trigo ña iyoo nuu ñuꞌu kan ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Suꞌva va ke kuni kachi ña: ra chiꞌi nuni trigo kan ku yuꞌu ra xaa yoꞌo va; ");
INSERT INTO mxv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ra ñuꞌu nuu ndikee ña kan kuvi ña yuuvi yoꞌo va, ra nuni trigo kan kuvi yuvi na kuu kuenda Ndioxi, ra iku ñàꞌa kan kuvi yuvi na kuu kuenda ra ndivaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ra ra sáa̱̱ ini, ra ndixaꞌan chiꞌi iku ñàꞌa kan kuvi ra kuu timiaꞌa va. Ra tiempo ña sakee na ke kuu kii ña ndiꞌi xaꞌa ña yuuvi yoꞌo va; ra yuvi na sakee kan kuvi na tatun Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ra ta kuꞌva ^xa na xiꞌin iku ñàꞌa, ña ^ndakaya na ña, ra ^taan na ña nuu ñùꞌù xixi ña, ra saa ke kuu tu xiꞌin na yuuvi yoꞌo va, te na xaa kii ña sandaku Ndioxi kuachi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ra yuꞌu, ra xaa yoꞌo, ra tiꞌvi yu na tatun yu ña ndakaya na takundiꞌi yuvi na ^xa kuachi, ra saa tu na sakuni inka yuvi ña na sa na ña väꞌa va, ra tava na na nuu xaꞌndia yu chiñu, ");
INSERT INTO mxv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ra taan na na xitun nuu xixi ñùꞌù, ra ikan ku nuu kuaku ni na, ra ndiakua ndakaxi nuꞌu na. ");
INSERT INTO mxv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ra na kandixa Ndioxi, ra ndayeꞌe va na kan ndia ta kuꞌva yeꞌe ñuꞌù, ra koo na xiꞌin Ndioxi nuu xaꞌndia ra chiñu va. Ra ndoꞌo, na xini soꞌo, ra na ndakiꞌin xini ndo ni ke kuni kachi tuꞌun yoꞌo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ra saa ndikaꞌan Jesús inka tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo iin ñaꞌa ña ndiaa yaꞌvi ni ña ndikaa seꞌe iin iku va ke, iyoo ña. Ra te ^ndaniꞌi iin tiaa ña, ra saa ndatiseꞌe tuku va ra ña nuu ndaniꞌi ra ña; ra kusii ka vi ini ra, ra saa ndakiꞌin ra kuanuꞌu ra, ra xaꞌa ra ixiko ra takundiꞌi ñaꞌa ña iyoo nuu ra, ra saa ndasata ra iku kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ra saa ndikaꞌan Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo iin tiaa ra xika ndaxiko, ra nanduku ra iin yuu ña yaꞌvi ni, saa iyoo ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ra te ^ndaniꞌi ra yuu ña yaꞌvi ni kan, ra saa ndakiꞌin ra kuanuꞌu ra, ra xaꞌa ra ixiko ra takundiꞌi ñaꞌa ña iyoo nuu ra, ra saa ndasata ra yuu ña yaꞌvi ni kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ra saa ndikaꞌan Jesús inka tuꞌun ndichi xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra ta kuꞌva iyoo ñunu ña chikaa na ini mini ra sakakuꞌun ña takundiꞌi va nuu tiaka, saa iyoo ña. ");
INSERT INTO mxv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ra te chitu ñunu kan xiꞌin ri, ra saa ndatava na kachiꞌi kan ña chi yuꞌu mini, ra ikan ndakundee na ña ndakaxin na ri; ra ri vaꞌa ndataan na ini tuká, ra ri väꞌa xatia va na. ");
INSERT INTO mxv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ra mii saa ke kuu tu te xa na ndiꞌi xaꞌa ña yuuvi yoꞌo va; saa chi kixi na tatun Ndioxi ra ndakaxin na na väꞌa ña ndatava na na tiañu na vaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ra taan na na xitun nuu xixi ñùꞌù. Ra ikan kuu nuu ndoꞌo ni na, ra kuaku ni na, ra iin ndiakua ndakaxi nùꞌù na ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Saa nindakatuꞌun Jesús ndia itaꞌan xiꞌin ra kachi ra saa: ―¿A kundaa ini ndo xiꞌin takundiꞌi ña ndikaꞌan yu xiꞌin ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Kundaa va ini ndi xiꞌin ña, Tata ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Takundiꞌi na maestro na sañaꞌa ndiayu Ndioxi, ra ta xa kutuꞌva na xaꞌa ichi nuu xaꞌndia Ndioxi chiñu, saa ra ta kuꞌva iyoo iin tiaa ra iyoo iin veꞌe, ra taxi vaꞌa ra ñaꞌa ña yaꞌvi ni ini veꞌe kan, ra saa xaꞌa ra xiniñuꞌu ra ña xaa xiꞌin ña yata, ña taxi vaꞌa ra kan, ra kuꞌva saa va ke iyoo na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ra saa te sandiꞌi Jesús ndikaꞌan ra tuꞌun ndichi yoꞌo, ra saa ndakiꞌin ra kuanuꞌu va ra, ");
INSERT INTO mxv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ra saa ndixaa ra ñuu nuu xaꞌnu ra. Ra ndikiꞌvi ra ini veꞌe ñuꞌu ñuu kan ra saa xaꞌa ra sañaꞌa ra na, ra ndakanda ka vi ini yuvi na ndee kan, ra kachi na saa: ―¿Ndia ndixaꞌan kiꞌin tiaa yoꞌo takundiꞌi ña ndichi yoꞌo, xiꞌin ndiee ña xa ra ña xituꞌun yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿A su seꞌe ra José ra kuxi itun va kuvi ra, ra siꞌi tu ra kuvi ña María va, ra ñani tu ra kuvi ra Jacobo, xiꞌin ra José, xiꞌin ra Simón, xiꞌin ra Judas va? ");
INSERT INTO mxv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ra a su ñuu yoꞌo ndee tu na siꞌi kuꞌva va ra xiꞌin yo? ¿Ra ndia mii ke ndixaꞌan ra yoꞌo ña sakuaꞌa ra takundiꞌi ña yoꞌo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ra ndikandïxa vaꞌa vi na Jesús ñuu ra, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Takundiꞌi ñuu ra ^xa toꞌo va na iin na kaꞌan tuꞌun yuꞌu Ndioxi, ndi su ñuu na nuu kaku na, xiꞌin nuu ndee na taꞌan na, ra xä toꞌo vi na na ikan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ra xaꞌa ña ndiee ni ini na ñuu kan ke kuëe ndixa Jesús kuaꞌa ni ña xituꞌun. ");
INSERT INTO mxv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ra suvi mii tiempo ña ndixaꞌan Jesús ñuu ra ke kundaa ini ra rey Herodes, ra xaꞌndia chiñu chi Galilea xaꞌa Jesús, ña ^xa ra kuaꞌa ni ña xituꞌun. ");
INSERT INTO mxv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ra saa ndikaꞌan ra xiꞌin ndia xachiñu nuu ra kachi ra saa: ―Ra kaꞌan na kuu Jesús kan ra süvi vi ra, chi ra Juan ra sakuchi yuvi va kuvi ra ndatiaku. Ña kan ke vaꞌa iyoo ni ndiee ra, ña xa ra ña xituꞌun ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Saa chi mii ra rey Herodes kan kuvi ra xaꞌndia chiñu ña ndixaꞌan ndia tiin ndia ra Juan, ra kuꞌni ndia ra xiꞌin yoꞌo kàà, ra chikaa ndia ra veꞌe kàà, saa chi ndikaꞌan ra xaꞌa kuachi ña ^xa ra Herodes xiꞌin ña Herodías xanu ra, ña yasiꞌi ra Felipe, ñani ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Saa chi xa ta yachi vi ke ndikaꞌan ra Juan kan, xiꞌin ra Herodes xaꞌa ña väꞌa ndixa ra, saa chi ndakiꞌin ra ña Herodías, yasiꞌi ra Felipe, ñani ra, ra nduu ña yasiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ra xaꞌa ña kan ke kuni ra Herodes kan ña kaꞌni ra ra Juan, ndi su ndiyuꞌvi va ra nuu na ñuu; saa chi ^kandixa takundiꞌi va na ra Juan kan, ña kuu ra ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ndi su ndixaa iin kii ña ndatava na viko ra rey Herodes ña ndaxinu ra kuiya, saa ra ndixaa va ña loꞌo kuáa̱n seꞌe ña Herodías kan nditaxaꞌa ña nuu takundiꞌi ndia ndee ndatava viko kan, saa ra kusii ka vi ini ra Herodes xiꞌin ña, ");
INSERT INTO mxv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ra saa kindoo ra, ña taxi ra ndia ndia ka ñaꞌa ña nduku ña nuu ra ndaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ra te kundaa ini siꞌi ña loꞌo kuaan kan, ra saa chikaa yuꞌu ña ñá, ra saa ndikaꞌan ña loꞌo kuaan kan xiꞌin ra Herodes kachi ña saa: ―Kuni yu ña na kundikaa xini ra Juan ra sakuchi yuvi ini iin koꞌo ra taxi kun ña ndaꞌa yu ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ra te xini soꞌo ra rey Herodes tuꞌun kan, saa ra kusuchi ni ini ra, saa chi xini takundiꞌi va ndia ndee kan ña kindoo ra taxi ra ndia ndia ka mii ñaꞌa ña nduku ña loꞌo kan nuu ra ndaꞌa ña, ra xaꞌa ña kan ke ndinïꞌi ka ra ni ke sa ra, ndia saa ra xaꞌndia ra chiñu nuu ndia xachiñu nuu ra, ña na ndataxi ndia xini ra Juan ndaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ra saa ndixaꞌan ndia xachiñu nuu ra Herodes ini veꞌe kàà nuu ndikaa ra Juan kan, ra xaꞌndia ndia sukun ra, ta kuꞌva kachi mii ra Herodes xiꞌin va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ra saa chikaa ndia xini ra Juan ini iin koꞌo, ra niꞌi ndia ña xaa ndia ndataxi ndia ndaꞌa ña loꞌo kuaan kan, ra saa ndixaꞌan ña ndataxi ña xini ra Juan ndaꞌa siꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ra saa ndixaꞌan ndia xitaꞌan xiꞌin ra Juan, ra ndakiꞌin ndia iki kuñu ra ninduxin va ndia. Ra te ndiꞌi saa ndixaꞌan ndia ndatuꞌun ndia xiꞌin Jesús xaꞌa ña kuu kan. ");
INSERT INTO mxv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ra ta kundaa ini Jesús ña ndixiꞌi ra Juan, ra saa nandaa ra ini iin barca loꞌo ra ndakiꞌin ra kuaꞌan ra iin iku nuu köo yuvi. Ndi su ta kundaa ini yuvi kan chi nuu kuaꞌan ra, ra saa kee na ñuu na ra taxi ndikun na kuaꞌan xaꞌa na sata va ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ra te nuu Jesús barca loꞌo kan, ra xa iin ndandaa va kaa xiꞌin yuvi xini ra, ra saa kundaꞌvi ka vi ini ra xini ra na, ra sandaꞌa ra kuaꞌa ni na xiꞌi na ndixaa xiꞌin yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ra te xa kuaꞌan kuaa, ra saa kuyachin ndia itaꞌan xiꞌin Jesús, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, ndiayu taꞌan xiꞌin yuvi yoꞌo ra na kuꞌun na ndia ndia ka mii ñuu vali ña ndoꞌni yachin yoꞌo, ra na sata na ñaꞌa kuxi na, chi yoꞌo, ra iku nuu köo yuvi va kuvi ña, ra xa kuaꞌan kuaa ni va ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Xiniñüꞌu kuꞌun na kan vi, chi na taxi ndoꞌo ña kuxi va na ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Saa ndakuiin ndia kachi ndia saa: ―Tata, köo kuaꞌa ñaꞌa niꞌi ndi, chi takua uꞌun va kuvi ixta, ra uvi kuvi tiaka va niꞌi ndi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Taxi ndo ña ndaꞌa yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ra saa xaꞌndia ra chiñu nuu yuvi kan ña na ndakundee vii na nuu itia kuii kan, ra saa kiꞌin ra uꞌun saa ixta kan, xiꞌin uvi saa tiaka kan, ra ndoniꞌi ra nuu ra ndivi, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra te ndiꞌi, saa taꞌvi ra ixta kan taxi ra ndaꞌa ndia itaꞌan xiꞌin ra, ra saa ndataꞌvi ndia kan ña xiꞌin yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ra xixi takundiꞌi va yuvi kan ndiakua nditiandiaa ini na. Ra te ndiꞌi xixi na, saa ndakaya ndia itaꞌan xiꞌin Jesús ñaꞌñu ña nindoo ndoso, ra uxi uvi ka tuká sakutu ndia xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ra yuvi na xixi kan, ra kuꞌva uꞌun mil kuvi niña tiaa va, ra ndiäꞌvi vi na siꞌi, xiꞌin na kuachi vali. ");
INSERT INTO mxv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te ndiꞌi kuu ña yoꞌo, saa xaꞌndia Jesús chiñu nuu ndia itaꞌan xiꞌin ra, ña na nandaa ndia ini itun loꞌo tu xika nuu mini, ra xa na kunuu va ndia kuꞌun ndia chi inka xiyo yuꞌu mini kan, ra nani saa na ndiayu taꞌan ra xiꞌin yuvi kan ra saa vi ke kundikun ra kuꞌun ra sata ndia, kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ra te ndiꞌi nindiayu taꞌan ra xiꞌin yuvi kan, ra saa ndaa mituꞌun saa ra iin iku ña kaꞌan ra xiꞌin Ndioxi, ra nani saa kuu ra saa ra kuu ñuu va. ");
INSERT INTO mxv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ra barca tu ñuꞌu ndia itaꞌan xiꞌin Jesús kuaꞌan ndia, ra xa nditaꞌvi sava va nuu kuaꞌan nu nuu tiañuꞌu kan, ra iin xiꞌin ña nduxa va kuaꞌan itu loꞌo kan xiꞌin ndia, saa chi tachi ra ndiee ni kani ña ra chi nuu ndia suꞌva va ke kani ña vaxi ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ra te xa kuaꞌan kuni tuvi, saa xika xaꞌa Jesús nuu tiañuꞌu kan vaxi ra nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ra te xini ndia itaꞌan xiꞌin Jesús ña xika xaꞌa ra vaxi ra nuu tiañuꞌu kan, saa ra tiaa ni ndiyuꞌvi ndia, ra iin kokoꞌo nindaꞌyu ndia, kachi ndia saa: ―¡Nima va ke vaxi kaa! ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Saa ra, ndikun ndikaꞌan va Jesús xiꞌin ndia kachi ra saa: ―¡Yayaa koo ndo! ra ¡Kuayüꞌvi ndo!, chi yuꞌu va kuvi ra ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Saa ndakuiin ra Pedro kachi ra saa xiꞌin Jesús: ―Tata, tu ndixa suvi yoꞌo kuvi ra, saa ra, taxi ndiayu ña na kaka xaꞌa yu nuu tiakuii yoꞌo, ra xaa yu niꞌi taꞌan yu xiꞌin kun ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ra saa ndikaꞌan Jesús xiꞌin ra Pedro kachi ra saa: ―Naꞌa ―kachi ra xiꞌin ra. Saa ra ndikun nuu ndixa va ra Pedro barca loꞌo kan, ra ndakiꞌin ra xika xaꞌa ra kuaꞌan nuu mini kan, ña ndakutaꞌan ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ndi su ta xini ra Pedro ña ndiee ni kani tachi, saa ra ndiyuꞌvi va ra; saa ra xaꞌa kuandee va ra kaꞌa mini kan, saa ra iin kokoꞌo nindaꞌyu ra kachi ra saa: ―¡Tata, sakaku yuꞌu! ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ra saa ndatiin Jesús ndaꞌa ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Loꞌo ni va kandixa kun yuꞌu, Pedro. ¿Nichuun ^xa uvi ini kun? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ra saa ta nandaa ndia ini barca loꞌo kan, saa ra ndikun ndixkuiin va tachi kan, ña kini ni kuu ña. ");
INSERT INTO mxv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Saa ra ndia ñuꞌu ini barca loꞌo kan, ra ndikun ndakusiti va ndia nuu Jesús, ra xaꞌa ndia ^ndasakaꞌnu ndia ra kachi ndia saa: ―Seꞌe Ndioxi ku ndixa va yoꞌo ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ra te ndakoyo ndia yuꞌu mini kan, ra saa ndixaa ndia ñuu Genesaret. ");
INSERT INTO mxv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ra te ndakuni na ñuu kan Jesús, ra saa tiꞌvi na chiñu ndixaꞌan iinii kuvi ñuu ña ndoꞌni kan, ña ndatuꞌun na xiꞌin na xaꞌa Jesús, ra saa xaꞌa na xaa na xiꞌin na xíꞌi̱ nuu ra, ");
INSERT INTO mxv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ra xakundaꞌvi ka vi yuvi kan nuu Jesús, ña na taxi ra tiandiaa loꞌo ndaꞌa na xíꞌi̱ kan yuꞌu tikoto ña ndixi ra; ra takundiꞌi na xíꞌi̱ na nditiandiaa ndaꞌa yuꞌu tikoto ra, ra nduvaꞌa ndixa va na. ");
INSERT INTO mxv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ra saa ndixaa sava ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia fariseo, ndia kee ñuu Jerusalén nuu íin Jesús, ra nindakatuꞌun ndia ra kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Nichuun xä toꞌo ndia itaꞌan xiꞌin kun costumbre ña ndakoo na xikuaꞌa, ña kaꞌan, ña xiꞌna ka xiniñuꞌu ndaꞌa yo, ra saa kuxi yo? ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―¿Nichuun xä toꞌo tu ndoꞌo ndiayu Ndioxi ña iyoo ndaꞌa ndo, ra iin ndakundiee va ndo ña ndikun ndo costumbre ña ndakoo na xii xikua ndo? ");
INSERT INTO mxv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ra na kundaa ini ndo, chi suꞌva va ke kachi Ndioxi xaꞌndia ra chiñu te yachi: “Na sa toꞌo kun iva kun, xiꞌin siꞌi kun”, ra “Na kaꞌan ñàꞌa xiꞌin iva, a xiꞌin siꞌi, ra ^ndikun na kuvi va na kan”, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ndi su ndoꞌo ra siin va tu kachi ndo. Saa chi kaꞌan ndo ña kuvi va kaꞌan iin tiaa xiꞌin iva ra, a xiꞌin siꞌi ra, ña kachi ra saa: “Küvi chindiee taꞌan yu xiꞌin ndo, chi takundiꞌi ña xani ini yu chindiee taꞌan yu xiꞌin ndo, ra xa ta iyoo ña ndisoko yu nuu Ndioxi va iyoo ña”, kachi ra, saa ra xavaꞌa va, kachi ndo; ");
INSERT INTO mxv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ra ndia ndia ka na kaꞌan taꞌan tuꞌun yoꞌo, saa ra xiniñüꞌu ka vi ña chindiee taꞌan na kan xiꞌin iva na, a xiꞌin siꞌi na, kachi ndo. Ra suꞌva va ke xa ndo, ña sandiꞌi ndo xaꞌa ndiayu ña xaꞌndia Ndioxi ña ndakoo ra ndaꞌa ndo, ra ^ndakundikun ndo costumbre ña ^sandaku mii va ndo. ");
INSERT INTO mxv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Saa chi ¡na chiꞌña tuꞌun va kuvi ndoꞌo! Ra ña ndixa ni va ke ndikaꞌan Ndioxi xiꞌin ra Isaías ra ndikaꞌan tuꞌun yuꞌu ra xinaꞌa xaꞌa ndo, te ndikaꞌan ra, kachi ra suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yuvi yoꞌo, ra takua iin tuꞌun ninu va ke kaꞌan na, ña kañuꞌu na yuꞌu, saa chi nima na, ra xika ni va iyoo ña nuu yu. ");
INSERT INTO mxv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ra ña uun va ke kaꞌan na ña kañuꞌu na yuꞌu, saa chi süvi ichi yuꞌu ke sañaꞌa na yuvi, chi ichi ña ndaku ini mii va na ke sañaꞌa taꞌan na, kachi Ndioxi xaꞌa ndo, ^kachi ña tiaa ra Isaías te yachi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ra saa ndakana Jesús takundiꞌi yuvi kan, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Tiaa ni soꞌo ndo ña kaꞌan yu xiꞌin ndo yoꞌo, ra ndakiꞌin xini ndo xiꞌin ña: ");
INSERT INTO mxv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Takundiꞌi ñaꞌa ña xaxi na, a ña xixi na, ra xa yäkua ña kan na, chi tuꞌun ña kee yuꞌu va na ke kuyakua na xiꞌin ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Saa ra kuyachin va ndia itaꞌan xiꞌin Jesús, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, ¿a kundaa ini kun ña väꞌa vi ndikuni ndia fariseo, te xini soꞌo ndia tuꞌun ña ndikaꞌan kun? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Takundiꞌi itun tu nindatäan Tata yu ra iyoo ndivi, ra kana ndiꞌi va nu kan, ra ndia tioꞌo va nu kee kana ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Ndäa ndo ña kuu vi ndia; saa chi na kuaa na niꞌi ichi nuu inka na kuaa va kuvi na, ra tu iin ra kuaa na kunuu ichi nuu inka ra kuaa, saa ra koyo uvi saa va ndia iin yavi ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ra saa ndikaꞌan ra Pedro xiꞌin Jesús kachi ra saa: ―Tata, ndatuꞌun xiꞌin ndi ra na kundaa ini ndi ni ke kuni kachi tuꞌun ndichi ña ndikaꞌan kun xiꞌin ndia fariseo ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿Ra ndikundäa ini tu ndoꞌo va xiꞌin tuꞌun ña ndikaꞌan yu tu saa? ");
INSERT INTO mxv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A kundäa ini ndo, su takundiꞌi ñaꞌa ña xixi yo, a ña xaxi yo, ra chi ini siti va yo ke kuaꞌan ña, ra te ndiꞌi, saa ra kee ña kuaꞌan ña xitia va ña? ");
INSERT INTO mxv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ndi su tuꞌun ña kee yuꞌu na, ña vaxi nima va na ke, kuyakua na xiꞌin. ");
INSERT INTO mxv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Saa chi nima va na ke kaku takundiꞌi ña väꞌa, ña vaxi xini na kuni na sa na, ña kuni na kaꞌni na ndìì, xiꞌin ña kutoo na koo kuaꞌa ni tani na, saa chi nii na siꞌi kuvi na xä toꞌo na yii na, ra nii tiaa kuvi ndia, ra xä toꞌo ndia yasiꞌi ndia, xiꞌin ña kutoo ni na sa na takundiꞌi nuu chiñu yakua xiꞌin taꞌan na, xiꞌin ña kuni na sakuiꞌna na, xiꞌin ña ndatuꞌun na tuꞌun chiꞌña xaꞌa taꞌan na, xiꞌin ña kañaꞌa kini na xiꞌin taꞌan na, ");
INSERT INTO mxv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ra takundiꞌi ña yoꞌo kuvi ña kuyakua yuvi xiꞌin, ndi su ña ndäꞌa na kuxi na, ra kuyäkua vi na xiꞌin ña kan ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ra saa kee Jesús ñuu kan, ra ndakiꞌin ra kuaꞌan ra chi ñuu Tiro xiꞌin ñuu Sidón va. ");
INSERT INTO mxv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ra te ndixaa Jesús ñuu kan, ra ikan kanduꞌu iin ñaꞌá ña kuu ndiseꞌe na xindee iin ñuu ña xinani Canaán, ra saa ndixaa ña nuu Jesús, ra iin kokoꞌo ndaꞌyu ña kachi ña saa: ―¡Tata, Seꞌe xikua ra David, kundaꞌvi ini kuni yuꞌu ra chindiee taꞌan kun xiꞌin yu! Saa chi ña loꞌo seꞌe yu, ra tachi ndivaꞌa ke ndikaa ñaꞌa, ra ndiee ni xa ña xiꞌin ña ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ndi su nindäa Jesús ña kuu yuꞌu vi ña. Ra saa kuyachin ndia itaꞌan xiꞌin ra, ra xakundaꞌvi ndia nuu ra kachi ndia saa: ―Tata, chindiee taꞌan xiꞌin ñaꞌa kaa, saa chi kaꞌan ni ña vaxi ña sata yo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ra saa ndakuiin Jesús kachi ra saa: ―Takua na ñuu Israel va kuvi na tiꞌvi Ndioxi yuꞌu vaxi yu xaꞌa, saa chi ta iyoo ndikachi vali ri nindoñuꞌu va ke iyoo na ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ra saa kuyachin ñaꞌa kan, ra ndakusiti ña nuu Jesús, ra ndikaꞌan ña xiꞌin ra kachi ña saa: ―¡Tata, chindiee taꞌan xiꞌin yu! ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Saa ndakuiin Jesús kachi ra saa xiꞌin ña: ―Väꞌa kita ña, ña kindiaa yu ixta yuꞌu na kuachi, ra taxi yu ña ndaꞌa tina kuxi ri ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Saa ndakuiin ñaꞌa kan, kachi ña saa xiꞌin ra: ―Ña ndixa kuvi va ña kaꞌan kun, Tata, ndi su tina, ra ndia ikin vali ña koyo yuꞌu ixtoꞌo ri chi tixi mesa va ndakaya ri xixi ri ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ra saa ndikaꞌan ra xiꞌin ña kachi ra saa: ―¡Tiaa ni ndinuni kandixa kun yuꞌu, Nana! Ra vaꞌa na koo ta kuꞌva kuni va kun ―kachi Jesús xiꞌin ña. Saa ra ndikun mii hora kan ke nduvaꞌa ndixa va ña loꞌo seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ra saa ndakiꞌin Jesús kuaꞌan ra, ra ndixaa ra chi yuꞌu tiañuꞌu ra ndikaa chi Galilea, ra saa ndaa ra xini iin iku ndakunduꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ra kuaꞌa ka vi yuvi ndakaya tuku ndixaa nuu nduꞌu ra, ra ndiaka na, na nduchiꞌña küvi kaka, na kuaa, na miꞌmi, na lundu, na köo ndaꞌa, na köo xaꞌa, ra kuaꞌa ni ka va na xíꞌi̱ ndiaka na ndixaa na, chindee na nuu íin Jesús, ra sandaꞌa ra takundiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ra te xini takundiꞌi yuvi kan ña kuu, saa ra ndakanda ka vi ini na, saa chi xini na, ndakaꞌan na miꞌmi, ra nduvaꞌa tu na lundu: na köo ndaꞌa, na köo xaꞌa va, ra vaꞌa ndakaka na küvi kaka, ra nduvaꞌa tu nuu na kuaa va. Ra saa xaꞌa yuvi kan ^ndasakaꞌnu ka vi na Ndioxi, ra nduꞌu ndivi, ra kuu Ndioxi na ñuu Israel. ");
INSERT INTO mxv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Saa ndakana Jesús ndia itaꞌan xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kundaꞌvi ni ini yu xini yu yuvi yoꞌo, saa chi xa kii uni va ke ndee na xiꞌin yu yoꞌo vichin, ra köo mii ñaꞌa niꞌi na kuxi vi na. Ra küni yu ña saa koo na xiꞌin soko ndatiꞌvi yu na kunuꞌu na veꞌe na, chi koto kuaꞌan na ichi saa kundiëe na, ra kuñaa nuu na ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ra saa ndakuiin ndia itaꞌan xiꞌin ra kachi ndia saa: ―Tata, ¿ndia mii kuꞌun kiꞌin ni yo ñaꞌa sakuxi yo yuvi yoꞌo, ra tiaa ni kuaꞌa kuvi na? Ra iku yuu nuu köo yuvi va kuvi ña yoꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ra saa nindakatuꞌun Jesús ndia kachi ra saa: ―¿Nisaa ku ixta niꞌi ndo? ―kachi ra xiꞌin ndia. Ra saa ndakuiin ndia kachi ndia saa xiꞌin ra: ―Takua uxa va ku ixta niꞌi ndi, xiꞌin iin tiꞌvi loꞌo tiaka vali va, Tata ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ra saa xaꞌndia ra chiñu, ña na ndakundee takundiꞌi yuvi kan, nuu ñuꞌú, ");
INSERT INTO mxv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Saa kiꞌin ra uxa saa ixta kan, xiꞌin iin tiꞌvi loꞌo tiaka kan, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra te ndiꞌi saa taꞌvi ra ña, ra taxi ra ña ndaꞌa ndia itaꞌan xiꞌin ra, ra ndia itaꞌan xiꞌin ra ndataꞌvi ña xiꞌin yuvi kan va. ");
INSERT INTO mxv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ra xixi takundiꞌi va na ndiakua nditiandiaa ini na. Ra nindoo ndoso kuaꞌa ka va ña, chi uxa ka vi tuká naꞌnu sakutu ndia xiꞌin ñaꞌñu ña nindoo ndoso kan. ");
INSERT INTO mxv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ra takundiꞌi yuvi na xixi xa Jesús, ra kuꞌva kumi mil kuvi niña tiaa va, ra ndiäꞌvi vi na siꞌi, xiꞌin na kuachi vali. ");
INSERT INTO mxv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ra te ndiꞌi, saa nindiayu taꞌan Jesús xiꞌin yuvi kan, ra saa nandaa ra ini iin itun loꞌo tu xika nuu tiañuꞌu, ra ndakiꞌin ra kuaꞌan ra chi ñuu ña nani Magdala va. ");
INSERT INTO mxv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ra saa ndixaa sava ndia fariseo xiꞌin ndia saduceo nuu Jesús, ña kuni ndia kotondoso ndia ra, ra saa ndikaꞌan ndia xiꞌin ra, ña na sa ra iin ña xituꞌun kuni ndia, ra saa ke kandixa ndia ra ña tiꞌvi Ndioxi ra xaa ra. ");
INSERT INTO mxv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ndi su suꞌva va tu kachi Jesús xiꞌin ndia: ―Ndoꞌo, ra vaꞌa va ndakuni ndo kii, saa chi te kuaa, ra suꞌva va kachi ndo: “Vaꞌa ni koo ñuu vichin chi vaꞌa ni kaa ndivi”, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ra chi ixtiaan tu kachi ndo saa: “Vichin ra ndiee ni kuun savi, saa chi tiaa ni ndikaa viko ndivi, ra iin ña ñaa kaa”, kachi ndo. ¡Ra na chiꞌña tuꞌun va kuvi ndo! Saa chi vaꞌa va ndakuni ndo kii, ¿ra nichuun küvi kundaa tu ini ndo xiꞌin ña ^xa Ndioxi nuu ña yuuvi yoꞌo tiempo vichin? ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Saa ndikaꞌan ka ra kachi ra saa: ―Yuvi ñaꞌa, na xïin kandixa Ndioxi ndee tiempo vichin, ra kuni na kuni na iin ña xituꞌun, ndi su ndia nii ña sä yu kuni na, chi ndia taꞌan ña ndoꞌo ra Jonás, ra ndikaꞌan ndoso tuꞌun Ndioxi xinaꞌa va ke sa yu kuni na ―kachi Jesús. Ndia saa ra ndakoo ra ndia, ra ndakiꞌin ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ra te ndixaa ndia itaꞌan xiꞌin Jesús, chi inka xiyo yuꞌu mini kan, ra saa ndakuꞌun ini ndia ña kuäꞌan ixta xiꞌin ndia kuxi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Kotoꞌni ndo, ra kuenda ni koo ndo xiꞌin ixan iyá ña kuu ndavi ndia fariseo, ra saa tu xiꞌin ndia saduceo va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Saa xaꞌa ndia ^ndakani ini ndia, ra kaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―Ña köo ixta niꞌi va yo ke, kachi ra saa xiꞌin yo ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ra kundaa va ini Jesús ña ^kaꞌan ndia xiꞌin taꞌan ndia, saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Nichuun kaꞌan ndo xiꞌin taꞌan ndo ña köo ixta niꞌi ndo? ¡Ra nichuun ndaku ni ini ndo, ña xïin ndo kandixa ndo! ");
INSERT INTO mxv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ra a nii loꞌo vi ke küvi kundaa ini ndo? ¿Ra a xa naa kuvi va ini ndo ña sakuxi yu uꞌun mil yuvi, xiꞌin uꞌun loꞌo ixta? ¿Ra ndixaa ka tuká sakutu ndo xiꞌin ña nindoo ndoso? ");
INSERT INTO mxv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ra a ndaküꞌun tu ini ndo ña sakuxi yu kumi mil yuvi, xiꞌin takua uxa loꞌo ixta? ¿Ra ndixaa ka tuká sakutu ndo xiꞌin ña nindoo ndoso? ");
INSERT INTO mxv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ra nichuun kundäa ni ini ndo ña kaꞌan yu xiꞌin ndo? Saa chi süvi xaꞌa ña köo ixta niꞌi ndo ke kaꞌan yu, chi xaꞌa ixan iyá ña kuu ndavi ndia fariseo xiꞌin ndia saduceo va ke kaꞌan yu, ña vaꞌa na kondiaa ndo mii ndo nuu chiñu kiꞌvi ña xa ndia ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ra saa vi ke kundaa ini ndia, ña süvi ndixa xaꞌa ixan iyá ña kuu ndavi ndia fariseo xiꞌin ndia saduceo, ña chikaa na xiꞌin ixan ixta vaꞌa ke ndikaꞌan Jesús xiꞌin ndia, chi xaꞌa ña ^sañaꞌa ndia xiꞌin xaꞌa chiñu ña xa inaꞌa ndia xa va ndia ke ndikaꞌan ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ra ta ndixaa Jesús chi ñuu Cesarea ña ndikun ndiaa ñuu Filipo, ra saa nindakatuꞌun ra ndia itaꞌan xiꞌin ra kachi ra saa: ―¿Yoo kuvi yuꞌu ra xaa yoꞌo, kachi yuvi xaꞌa yu? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ra saa ndakuiin ndia kachi ndia saa xiꞌin ra: ―Sava na kaꞌan kachi na saa, ña kuu kun ra Juan ra sakuchi yuvi; ra sava tu na kaꞌan ña kuu kun ra Elías va; ra inka tu na kaꞌan ña kuu kun ra Jeremías va; ra sava tu na kaꞌan ña kuu kun ndia iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ra saa nindakatuꞌun ra ndia kachi ra saa: ―Ra ndoꞌo tu, ¿yo kuvi yuꞌu, tuvi ndo? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ra saa ndakuiin ra Simón Pedro kachi ra saa: ―Tata, yoꞌo kuvi seꞌe Ndioxi ra tiaku, ra xa̱à kun ña sakaku na yuuvi yoꞌo ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Vaꞌa ni ^kee kun, Simón, seꞌe ra Jonás, saa chi süvi na yuuvi yoꞌo kuvi na nditaxi ña xinituni yoꞌo ndaꞌa kun, ña vaꞌa kundaa ini kun, chi Tata yu Ndioxi ra iyoo ndivi va kuvi ra taxi ña ndaꞌa kun. ");
INSERT INTO mxv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ra yuꞌu tu, kaꞌan xiꞌin kun vichin, ña ndakunani kun Pedro. Ra tuꞌun “Pedro” yoꞌo, ra “yuu” va ke kachi ña. Ra sata yoꞌo ke kata yu yuvi na ndikun yuꞌu, ra ndia nii ñaꞌa kuchüun sandiꞌi xaꞌa na, ra nii ña ndii ña xaꞌni yuvi kuchüun sa tiaa nuu na. ");
INSERT INTO mxv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ra ndaꞌa yoꞌo ke taxi yu yave, ña ndakuiña yeꞌe nuu xaꞌndia Ndioxi chiñu. Ra takundiꞌi ñaꞌa ña chikuꞌni kun nuu ña yuuvi yoꞌo, ra kunuꞌni tu ña ndivi va, ra takundiꞌi tu ñaꞌa ña ndaxi kun nuu ña yuuvi yoꞌo, ra ndaxi tu ña ndivi va ―kachi Jesús xiꞌin ra Pedro. ");
INSERT INTO mxv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ra saa xaꞌndia Jesús chiñu nuu ndia itaꞌan xiꞌin ra, ña na ndatüꞌun ndia xiꞌin ndia nii yuvi, ña kuu ra seꞌe Ndioxi, ra tiaku, ra ^xaa sakaku na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ra saa xaꞌa Jesús ndatuꞌun ra xiꞌin ndia itaꞌan xiꞌin ra, ña xiniñuꞌu kuꞌun ra ñuu Jerusalén, ra ndia xikuaꞌa, xiꞌin sutu ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ley Ndioxi, ra sandoꞌo ni ndia ra, ra kaꞌni ndia ra, ndi su kii uni ndatiaku va ra ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ra saa tava siin ra Pedro Jesús, ra xaꞌa ra kaꞌan ra xiꞌin ra kachi ra saa: ―Tata, ¡chikäa ini kun ña ñaa, chi ndia nii kii ndöꞌo kun saa! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Saa ndikokuiin Jesús, ra ndikaꞌan ra xiꞌin ra Pedro kachi ra saa: ―¡Kuatiaꞌa nuu yu, timiaꞌa!, chi ri kuni sandakava yuꞌu va kuvi kun, saa chi yoꞌo, ra süvi chiñu Ndioxi ke ndiꞌi ini kun xaꞌa sa kun, chi ña xa na yuuvi yoꞌo va ke ndakani ini kun xaꞌa ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Tu ndia ndo kuni kundikun yuꞌu, ra xiniñuꞌu ^kaꞌndia ini ndo xaꞌa mii ndo, ra ndakasoko ndo cruz ndo ra kundikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi takundiꞌi yuvi, na kuni sakaku mii nuu ña yuuvi yoꞌo, kuvi na ndiꞌi xaꞌa va, ra takundiꞌi tu na xiin ndataxi mii ña ndoꞌo na xaꞌa yuꞌu, kuvi na niꞌi kutiaku va. ");
INSERT INTO mxv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ra vaꞌa ni na koo takundiꞌi va ñaꞌa ña iyoo nuu ña yuuvi yoꞌo nuu yuvi, ndi su tu na sandoñuꞌu tu na nima na, saa ra köo vaꞌa yaꞌvi ndiaa vi ña. Ra ndia nii tu ñaꞌa küvi kuniñuꞌu na ña chaꞌvi na xaꞌa ña niꞌi na kutiaku nima va na. ");
INSERT INTO mxv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chi yuꞌu, ra xaa yoꞌo vichin, ra ndiko yu kixi yu xiꞌin ndiee Tata yu, xiꞌin na tatun ra, ra saa ke ndachaꞌvi yu ta iin ta iin na yuuvi yoꞌo xaꞌa chiñu ña ^xa na, ra ta kuꞌva iyoo mii chiñu ña ^xa na, saa ke koo tu yaꞌvi na sa va yu. ");
INSERT INTO mxv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ra ña ndixa ke kaꞌan yu xiꞌin ndoꞌo, ndia ndee yoꞌo vichin, chi saa kúú tiaku ka va ndo, ra kuni nuu va ndo ña xaꞌa yuꞌu, ra xaa yoꞌo ña kaꞌndia yu chiñu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ra saa kuu ndiyaꞌa i̱ñu̱ kii, saa ndakiꞌin Jesús ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan ñani suvi ra Jacobo, ndixaꞌan ndia xiꞌin ra iin xiki sukun. ");
INSERT INTO mxv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ra ikan ndanama ra xini ndia; ra nuu ra, ra iin taxa taxa nduu ña, iin ta kuꞌva taxa ñuꞌu, ra tikoto ña ndixi ra, ra iin yeyeꞌe nduu ña, iin ta kuꞌva ndii te kaꞌñu saa nduu ña. ");
INSERT INTO mxv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Saa ra tuꞌva ndituvi va ra Moisés, xiꞌin ra Elías, ra xaꞌa ndia ndatuꞌun ndia xiꞌin Jesús ndita ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ra saa ndikaꞌan ra Pedro xiꞌin Jesús kachi ra saa: ―Tata Maestro, tiaa ni vaꞌa ña ndee yo yoꞌo vichin. Tu kuni kun ra na savaꞌa ndi uni veꞌe tuvíxi̱n vali: iin ña koo veꞌe yoꞌo, ra iin ña koo veꞌe ra Moisés, ra iin ña koo veꞌe ra Elías ―*kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ra nani saa kuu ra Pedro kaꞌan ra xiꞌin Jesús, saa ra nduxinu va viko ña yeꞌe ni ra ndasi ña sata ndia; ra tiañu viko kan tiaku tachi Ndioxi ña ndikaꞌan ra kachi ra saa: ―Ra yoꞌo kuvi seꞌe yu, ra kuꞌvi ni ini yu xini yu ra, ra kusii ni ini yu xiꞌin ra, ra na kandixa ndo ña kaꞌan ra xiꞌin ndo ―kachi Ndioxi xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ra te xini soꞌo ndia itaꞌan xiꞌin Jesús tuꞌun yoꞌo, saa ra ndakusiti ndia, ra ndia nuu ñuꞌu nduxinu nuu ndia, saa chi ndiyuꞌvi ni ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ra saa kuyachi Jesús nuu ndee ndia, ra nditiandiaa ndaꞌa ra sata ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ndakuita ndo ra kuayüꞌvi ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ra te ndakundita ndia, ra ndia nii ka yuvi köo ndixini ndia, ra ndia sa indaa mituꞌun va Jesús ndichi xini ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ra saa te nandiko ndia vaxi nuu ndia iku kan, ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ndia nii na ndatüꞌun ndo xiꞌin xaꞌa ña xini ndo yoꞌo, chi ndia te na ndatiaku yuꞌu, ra xaa yoꞌo, vi ke kuvi ndatuꞌun ndo xiꞌin na xaꞌa ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ra saa nindakatuꞌun ndia itaꞌan xiꞌin ra ra kachi ndia saa: ―Tata, ¿nichuun kaꞌan ndia maestro ndia sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ña xiꞌna ka va ra Elías kuvi ra xiniñuꞌu kunuu kixi? ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ña ndixa ke, xiꞌna ka va ra Elías kuvi ra kunuu kixi, ra sanduvi ra takundiꞌi ña xiniñuꞌu kunduvi va. ");
INSERT INTO mxv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ra na kundaa ini ndo, chi ra Elías, ra xa kixi va ra, ndi su ndindaküni na ra, chi xa na ña kuni mii na xiꞌin va ra. Ra mii saa ke sa tu na xiꞌin yuꞌu ra xaa yoꞌo va, chi sandoꞌo ni tu na yuꞌu va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ra saa kundaa ini ndia itaꞌan xiꞌin Jesús, ña kaꞌan ra xaꞌa ra Juan ra sakuchi yuvi va. ");
INSERT INTO mxv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ra te xaa ndia nuu ndee yuvi kan, saa ra ndikun ndixaa iin tiaa xikusiti ra nuu Jesús, ra ndikaꞌan ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tata, kundaꞌvi ini kuni seꞌe loꞌo yu, chi ra xiꞌi yiꞌi kuvi ra, ra ndoꞌo ni ra xa ña; ra nii ndiäꞌvi ichi ^kita ra nuꞌu, ra saa tu nuu tiakuii va. ");
INSERT INTO mxv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ña kan ke ndiaka yu ra xaa ra xiꞌin yu nuu ndia itaꞌan xiꞌin kun, ndi su ndikuchüun ndia ña sandaꞌa ndia ra, Tata ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia itaꞌan xiꞌin ra: ―¿Nichuun ndaku ni ini ndo? ¿Ra ni va yuvi kuvi ndo ña xïin ndo kandixa ndo? ¿Ra a iin ndisaa kii va ke koo yu xiꞌin ndo tuvi ndo? Kundiëe ka ini yu nuu ndo. Naꞌa ndo xiꞌin ra loꞌo ñaa yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ra saa xaꞌndia Jesús chiñu nuu tachi ndivaꞌa kan, ña na ^saña ña ra loꞌo kan, saa ra saña ndixa va ña ra, ra ndikun nduvaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ra te ndiꞌi, saa nindakatuꞌun siin ndia itaꞌan xiꞌin Jesús, kachi ndia saa: ―Tata, ¿nichuun ndikuchüun ndi tava ndi tachi ndivaꞌa kan? ―*kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia. ―Xaꞌa ña kuëe kandixa ndo Ndioxi va ke ndikuchüun ndo tava ndo ña. Ra ña ndixa kaꞌan yu xiꞌin ndo, chi tu ña kandixa ndo ra na koo ña ta kuꞌva iyoo iin ndikin loꞌo itun mostaza, saa ra kuvi va kaꞌan ndo xiꞌin iku kaa, kachi ndo saa: “Sakutiaꞌa mii kun, ra kuaꞌan ndakundichi kun inka xiyo”, kachi ndo xiꞌin ña, saa ra, saa sa ndixa va ña. Saa chi köo ña uꞌvi tu na kandixa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ndi su tachi ndivaꞌa, ra kuëe saa koo kee ña, chi xiniñuꞌu kaꞌan ni ndo xiꞌin Ndioxi, ra koo suꞌun ndo ña küxi ndo, ra saa ke kuchuun ndo ña tava ndo ña ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ra saa kuu Jesús xika ra kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra chi Galilea, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Yuꞌu ra xaa yoꞌo, ra ndataxi na yuꞌu ndaꞌa na sáa̱̱ ini xini yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ra kaꞌni na yuꞌu, ndi su kii uni ndatiaku va yu ―kachi ra xiꞌin ndia. Ra ta kundaa ini ndia tuꞌun yoꞌo saa ra xaꞌa kusuchi ka vi ini ndia. ");
INSERT INTO mxv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ra te ndixaa Jesús ñuu Capernaum xiꞌin ndia itaꞌan xiꞌin ra, ra saa ndixaa ndia kaya xuꞌun ña kuaꞌan veꞌe ñuꞌu ra ndindakatuꞌun ndia ra Pedro kachi ndia saa: ―¿A chaꞌvi ra Tata Maestro kun xuꞌun ña kaya kuaꞌan veꞌe ñuꞌu? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Saa ndakuiin ra Pedro kachi ra saa xiꞌin ndia: ―Chaꞌvi va ra ña ―kachi ra. Ra te ndikiꞌvi ra Pedro veꞌe, ra xiꞌna ka va mii Jesús ndikaꞌan xiꞌin ra kachi ra saa: ―¿Ndixa tuvi yoꞌo, Pedro? ¿Yoo nuu ke kiꞌin na xaꞌndia chiñu nuu ña yuuvi yoꞌo xuꞌun: nuu na ñuu na, a nuu na kee inka ñuu va? ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Saa ndakuiin ra Pedro kachi ra saa: ―Nuu na inka ñuu va ke kiꞌin na ña ―kachi ra. Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Saa ra, mii na ñuu, na xiꞌin suvi, ra chäꞌvi vi na kan tu saa. ");
INSERT INTO mxv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ndi su ña na säa na xiꞌin yo, ra kuaꞌan yuꞌu mini kan ra tava kun tiaka, ra ri nuu vaꞌa tava kun xiꞌin kàà tiku kun kuvi ri kuña kun yuꞌu, ra ikan ndikaa iin xuꞌun kàà ndakiꞌin kun, ra ña kan ke chaꞌvi kun nuu yuꞌu xiꞌin nuu mii kun ―kachi Jesús xiꞌin ra Pedro. ");
INSERT INTO mxv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ra suvi mii kii kan kuyachin ndia itaꞌan xiꞌin Jesús, ra ndindakatuꞌun ndia ra kachi ndia saa: ―Tata, ichi nuu xaꞌndia Ndioxi chiñu, ¿ra yoo kuvi na kuu na chee vaꞌa ka nuu ndi? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ra saa kana Jesús iin ra loꞌo, ra xanindichi ra ra maꞌñu ndia. ");
INSERT INTO mxv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi tu na ^ndasäma ndo ña nduu ndo ta kuꞌva iyoo na kuachi vali, saa ra kuchüun ndo kiꞌvi ndo ndivi nuu iyoo Ndioxi ña koo ndo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Saa chi yuvi na xa ni̱nu̱ xiꞌin mii ta kuꞌva iyoo ra loꞌo yoꞌo, ra na kan kuvi na kuu na kunaꞌnu vaꞌa ka va nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ra ndia ndia ka yuvi na ndakiꞌin mani iin na vali taꞌan ra loꞌo yoꞌo xaꞌa ña ndikun na yuꞌu, ra yuꞌu va kuvi ra ndakiꞌin mani na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Ndia ndia ka yuvi na kuu mii kuachi, ña sakoyo na iin yuvi na xa ninu xiꞌin mii ña ndikun na yuꞌu, ra vaꞌa ka va ke yachi na kunuꞌni iin yuu katia chee sukun na, ra koꞌni na na ini mini. ");
INSERT INTO mxv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ra ña ndixa ke ndaꞌvi ni va na ndee nuu ña yuuvi yoꞌo, ña sandaꞌvi na yuvi, ra koyo na ndaꞌa kuachi, chi ña ndixa ke iyoo ni va ña väꞌa nuu ña yuuvi yoꞌo, ra ndia nii na kuchuun ndasi ña, ra ndi ndaꞌvi ni va iin tiaa ra sandaꞌvi yuvi ña sa na kuachi nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ña kan ke, tu ndaꞌa ndo, a xaꞌa tu ndo kuvi ña kuu mii kuachi ña sandakava ña ndoꞌo ña sa ndo kuachi, saa ra vaꞌa ka va ke na kaꞌndia ndo ña, ra sakana ndo ña, saa chi vaꞌa ka va ke na kiꞌvi ndo nuu kutiaku ndo iin ndisaa kii, xiꞌin iin xiyo ndaꞌa ndo, a xiꞌin iin xiyo xaꞌa tu ndo nuu ña kuꞌun ndo ndiaya nuu xixi ñùꞌù ñuu kaꞌñu, ra ndäꞌva ña, xiꞌin uvi saa ndaꞌa ndo, a xiꞌin uvi saa xaꞌa va tu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ra tu nduchi nuu tu ndo kuvi ña kuu mii kuachi ña sandakava ña ndoꞌo sa ndo kuachi, saa ra vaꞌa ka va ke na tava ndo ña, ra sakana ndo ña, saa chi vaꞌa ka va ke na niꞌi ndo kiꞌvi ndo xiꞌin iin xiyo nduchi nuu ndo nuu koo ndo iin ndisaa kii, nuu ña kuꞌun ndo xiꞌin uvi saa xiyo nduchi nuu ndo ndiaya nuu xixi ñùꞌù ñuu kaꞌñu, ra ndäꞌva ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Kuenda ni koo ndo, ra na kundäsi ndo ndia nii yuvi na xa ninu xiꞌin mii, saa chi na tatun Ndioxi na kiꞌin kuenda xiꞌin na iin takundiꞌi kii, ra yachin ni va ndee na xiꞌin Tata yu Ndioxi ndivi ninu. ");
INSERT INTO mxv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ra yuꞌu, ra xaa yoꞌo vichin, ra xaa yu ña nanduku yu yuvi na nindoñuꞌu, ra sakaku va yu na. ");
INSERT INTO mxv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Ndixaa tuvi ndo? Tu iin tiaa ra iyoo iin ciento ndikachi sana ra, ra na ndoñuꞌu indaa ri nuu ra, saa ra, ¿a ndaköo ñaꞌa ra ri kumi xiko xaꞌun kumi kan, ra kuꞌun ra iinii kuvi iku ña nanduku ra ri nindoñuꞌu kan, tuvi ndo? ¿Su kuꞌun va ra xaꞌa ri? ");
INSERT INTO mxv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ra tu na ndaniꞌi ra ri, saa ra tiaa ni ka va kusii ini ra xiꞌin ri indaa mituꞌun kan, nuu takundiꞌi ri kumi xiko xaꞌun kumi, ri xa ndee vaꞌa, ri nindoñüꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ra kuꞌva saa ke yoo tu Tata yo Ndioxi ra iyoo ndivi va, chi küni ra kan ña na ndoñuꞌu ndia nii yuvi na xa ninu xiꞌin mii yoꞌo ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Saa ndikaꞌan ka Jesús kachi ra saa: ―Tu ndia iin ñani kun ^xa ña väꞌa xiꞌin kun, saa ra ña sa kun ke kuꞌun mituꞌun saa kun, ña kaꞌan kun xiꞌin ra xaꞌa ña ^xa va ra; ra tu xiin ra xini soꞌo ra ña ndikaꞌan kun xiꞌin ra, ra ndakiꞌin xini ra xiꞌin ña, saa ra kuchuun va kun ña ^kindoo mani kun xiꞌin ñani kun. ");
INSERT INTO mxv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ndi su tu ndixïin ra kandixa ra ña ndikaꞌan kun xiꞌin ra, saa ra na nduku kun, iin a uvi na kuꞌun xiꞌin kun, ña kaꞌan ndo xiꞌin ra, ra saa ke vaꞌa na koo uvi a uni na ndakuiin xaꞌa takundiꞌi tuꞌun ña kaꞌan ndo. ");
INSERT INTO mxv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ra tu nii na kan ndikandïxa ra, saa ra na ndatuꞌun kun xiꞌin na veꞌe ñuꞌu va, ra tu nii na veꞌe ñuꞌu ndikandïxa ra ña ndikaꞌan vi, ndia saa ra na koo ra saa va, chi ta iyoo yuvi kuachi na xïni vaꞌa tuꞌun Ndioxi va ke iyoo ra, ra iin kuvi tu ra xiꞌin na sandaꞌvi, kaya xuꞌun ndaꞌa yuvi ña kuaꞌan ndaꞌa ra chiñu kaꞌnu ñuu Roma va. ");
INSERT INTO mxv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi takundiꞌi ñaꞌa, ña chikuꞌni ndo nuu ña yuuvi yoꞌo, ra kunuꞌni tu ña ndivi va, ra takundiꞌi tu ñaꞌa, ña ndaxi ndo nuu ña yuuvi yoꞌo, ra ndaxi tu ña ndivi va. ");
INSERT INTO mxv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ra kuni yu ña na kundaa ini ndo, chi tu uvi ndo na chitaꞌan tuꞌun nuu ña yuuvi yoꞌo, ña kaꞌan ndo xiꞌin Ndioxi, xaꞌa ndia iin ña kuni ndo, saa ra Tata yu Ndioxi ra iyoo ndivi, ra taxi va ra ña ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Saa chi nuu ndakitaꞌan uvi a uni yuvi, na kandixa yuꞌu, ra tiañu na kan íin va yu ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ra saa kuyachin ra Pedro ra ndikaꞌan ra xiꞌin Jesús kachi ra saa: ―Tata, ¿ndixaa ichi ke xiniñuꞌu koo kaꞌnu ini yu xaꞌa ñani yu, na ^xa ña väꞌa xiꞌin yu? ¿A uxa ichi vi ke xiniñuꞌu sa kaꞌnu ini yu xaꞌa na? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Süvi takua uxa ichi ke kaꞌan yu xiꞌin kun ña sakaꞌnu ini kun xaꞌa ñani kun, chi uni xiko uxi ichi ña uxa vi ke xiniñuꞌu koo kaꞌnu ini kun xaꞌa na ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ndia kachi ra saa: ―Kuꞌva ña xachiñu Ndioxi ra inuu va ña xiꞌin chiñu ña xa iin ra rey, ra ndasayukun kuenda xiꞌin ndia xachiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ra te xaꞌa ra rey kan ndasayukun ra kuenda xaꞌa xuꞌun ra, ra saa ndixaꞌan na ndakiꞌin na iin ra nika kuaꞌa ni xuꞌun nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ra ra nika kuaꞌa ni xuꞌun kan, ra ninïꞌi ra ña ndataxi ra, ra saa xaꞌndia ra rey kan chiñu, ña na xiko na ra nika kan, ra ndia yasiꞌi ra, xiꞌin seꞌe vali ra, xiꞌin takundiꞌi ñaꞌa ña kuu mii ra ke na kiyaꞌvi, ra saa vi ke kuchuun ndita ndiꞌi xuꞌun ra rey kan. ");
INSERT INTO mxv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ra saa ndakusiti ra nika kan nuu ra rey kan, ra xaꞌa ra xaku ndaꞌvi ka vi ra nuu ra kachi ra saa: “Tata, tiaa ni ke kaꞌnu na koo ini kun xiꞌin yu, ra na kundiatu ñaꞌa kun loꞌo xiꞌin yu, ra ndachaꞌvi ndiꞌi va yu ña nika yu nuu kun”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Saa ra kundaꞌvi ka vi ini ra rey kan xini ra ra, ra xa kaꞌnu ini ra xaꞌa takundiꞌi va ña nika ra nuu ra, ra saa saña ndika ra ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ndi su te kanata ra xinika kan kuaꞌan ra, ra saa ndakitaꞌan ra xiꞌin iin ra ndaꞌvi ra nika nuu mii ra, saa ra ndikun tiin ra sukun va ra kan, ra xaꞌa ra kaꞌan ra xiꞌin ra kachi ra saa: “¡Ndachaꞌvi takundiꞌi ña nika kun nuu yu mii ña takaꞌan kuiti!”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ra saa ndakusiti ra ndaꞌvi kan nuu ra, ra xaꞌa ra xaku ndaꞌvi ka vi ra nuu ra kachi ra saa: “Tata, tiaa ni ke kaꞌnu na koo ini kun xiꞌin yu, ra na kundiatu ñaꞌa kun loꞌo xiꞌin yu, ra ndachaꞌvi ndiꞌi va yu ña nika yu nuu kun”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ndi su ndixïin tiaa kan ña koo kaꞌnu ini ra xiꞌin ra nika nuu mii ra, chi xakin va ra kuachi xiꞌin ra ndaꞌvi kan, ra tiin na ra chikaa na veꞌe kàà, ra iin ndiakua nduxa na ndachaꞌvi ndiꞌi va ra ña nika ra nuu ra ^kuni ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ra saa xini ndia itaꞌan xachiñu xiꞌin ra nuu ra rey kan, ra kusuchi ka vi ini ndia xiꞌin ra ndaꞌvi kan te xini ndia ña ndoꞌo ra, ra saa kee ndia ndixaꞌan ndia ndatuꞌun ndia xiꞌin ra rey kan xaꞌa takundiꞌi ña xini ndia kuu. ");
INSERT INTO mxv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ra saa xaꞌndia ra rey kan chiñu, ra ndixaꞌan na ndakiꞌin na ra xinika kan xaa ra, ra saa ndikaꞌan ra rey kan xiꞌin ra kachi ra saa: “Takundiꞌi ña xinika kun nuu yu, ra sandiꞌi va yu xaꞌa ña xiꞌin kun, chi xaku ndaꞌvi ni kun nuu yu xaꞌa ña, ña kan ke vaꞌa xa kaꞌnu ini yu xaꞌa kun, ndi su yoꞌo, ra ra ñaꞌa va kuvi kun. ");
INSERT INTO mxv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ra a väꞌa ta xa yuꞌu xiꞌin kun ña kundaꞌvi ini yu xini yu yoꞌo, ra saa ndixa kun ña sa kaꞌnu ini kun xaꞌa ra taꞌan kun ra nika nuu kun?”, kachi ra rey kan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Saa ra ndisaa ka vi ra rey kan xiꞌin tiaa kan, ra saa ndataxi ra ra ndaꞌa na chiñu ña na sandoꞌo na ra, ra iin ndiakua nduxa ke na ndachaꞌvi ra takundiꞌi va ña xinika ra nuu ra rey kan ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Ta kuꞌva xa ra rey kan xiꞌin tiaa kan ke, sa tu Tata yu Ndioxi ra iyoo ndivi xiꞌin ndoꞌo va, tu na kuïin ndo ña sa kaꞌnu ndinuni vaꞌa ini ndo xaꞌa na taꞌan ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ta sandiꞌi Jesús ña sañaꞌa ra na, ra saa kee ra Galilea, ra ndakiꞌin ra kuaꞌan ra, chi Judea ña ndikaa chi inka xiyo yuꞌu itia Jordán. ");
INSERT INTO mxv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ra iin tiaꞌndia chee yuvi ndikun kuaꞌan xiꞌin ra, ra ikan sandaꞌa ra takundiꞌi va na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Saa ra ndixaa va sava ndia fariseo nuu íin Jesús, ña ^kuni ndia kotondoso ndia ra, ra saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata Maestro, ¿a iyoo ndiayu ña ndakoo iin tiaa yasiꞌi ra, xaꞌa ndia ndia ka kuachi? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A täan kaꞌvi ndo tuꞌun Ndioxi ña ndakani kachi suꞌva, te xavaꞌa Ndioxi yuvi kii nuu, “ra xavaꞌa ra tiaa, ra xavaꞌa tu ra ñaꞌa va”? ");
INSERT INTO mxv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ra ndikaꞌan ka tu Ndioxi kachi ra suꞌva va: “Ña kan ke tiaa, ra ndakoo va ra iva ra xiꞌin siꞌi ra, ra tandaꞌa ra xiꞌin iin ñaꞌa ña kuu yasiꞌi ra, ra uvi saa na, ra ndia sa indaa va nduu na.” ");
INSERT INTO mxv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ra suꞌva va ke iyoo, ña kan ke süvi ka uvi yuvi kuvi na, chi sa indaa mituꞌun va nduu na. Ra na chutaꞌan Ndioxi, ra ndia nii na yuuvi yoꞌo na satäꞌvi taꞌan ñaꞌa ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ra saa ndikaꞌan ndia fariseo kachi ndia saa xiꞌin Jesús: ―Tu saa va iyoo ña, ¿ra nichuun xaꞌndia tu ra Moisés chiñu ña kachi ra saa: “Vaꞌa va ndakoo iin tiaa yasiꞌi ra, ra ña sa ra ke na sandakuita ra iin tutu, ña ndakuiin xaꞌa ra ña xa ndakoo taꞌan na, saa ra xavaꞌa va”?, kachi ra Moisés ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ra saa ndakuiin Jesús kachi ra saa: ―Xaꞌa ña ndiee ni ini va ndo kuvi ña taxi ra Moisés ndiayu ñaa ndaꞌa ndo, ña ndakoo ndo yasiꞌi ndo, ndi su te kii xaꞌa, ra süvi saa ke ndikaꞌan Ndioxi xiꞌin ndo sa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ña kan ke yuꞌu, ra siin va kachi yu xiꞌin ndo vichin. Tu ndia iin tiaa ra kuëe ndikiꞌvi yasiꞌi ra xiꞌin inka tiaa, ra ndakoo ra ña, ra tandaꞌa ra xiꞌin inka ñaꞌa, saa ra ndiayu Ndioxi va ke kanduu ra, ra tiaa ra ndakiꞌin tu ñaꞌa ña nindoo nuu yii kan, ra ndiayu Ndioxi ke kanduu tu ra kan va ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ra saa ndikaꞌan ndia itaꞌan xiꞌin Jesús xiꞌin ra kachi ndia saa: ―Ra tu saa va ke iyoo ña xaꞌa na ndakoo taꞌan, saa ra vaꞌa ka va kita ña, ña na tandäꞌa vaꞌa ka vi yuvi tu saa ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ña yoꞌo, ra süvi takundiꞌi yuvi kuvi na kuchuun kundaa ini xiꞌin ña, chi takua na ^taxi Ndioxi ña xinituni va kuvi na kundaa ini xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ra ña yuuvi yoꞌo ra iyoo sava na, ra tandäꞌa na chi te ñuꞌu na tixi siꞌi vi na ke niniꞌi taꞌvi na ña koo na saa, ña kan ke tandäꞌa na, ra sava tu na, ra na yuuvi yoꞌo va kuvi na xaꞌndia ñaꞌa, ña kan ke tandäꞌa ka na, ra sava tu na ra nii vaꞌa va na, ndi su xaꞌa ña kuni na sachiñu na nuu Ndioxi va ke tandäꞌa ka na. Ra na kiꞌin kuenda kuchuun koo na saa, ña tandäꞌa na, saa ra saa na koo va na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ra saa ndixaa sava na xiꞌin na vali seꞌe na nuu íin Jesús, ña na chinduꞌu ra ndaꞌa ra sata na vali kan, ra kaꞌan ra xiꞌin Ndioxi xaꞌa na kuni na. Ra saa ndukueꞌe ndia itaꞌan xiꞌin ra xiꞌin na ndixaa xiꞌin na kuachi vali kan. ");
INSERT INTO mxv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Säsi ndo nuu na vali ñaa. Saña ndo na, ña na kixi na nuu yu. Chi na iyoo ta kuꞌva iyoo na vali kuvi na kuchuun kiꞌvi koo xiꞌin Ndioxi nuu xaꞌndia ra chiñu va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ra saa chinduꞌu ra ndaꞌa ra sata na kuachi vali kan ña ndikaꞌan ra xiꞌin Ndioxi xaꞌa na, ra te ndiꞌi saa ndakiꞌin ra kuaꞌan ra inka xiyo va. ");
INSERT INTO mxv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saa kuu ra xaa iin tiaa ra itia ra nindakatuꞌun ra Jesús kachi ra saa. ―Tata Maestro, ra vaꞌa, kaꞌan xiꞌin yu ndia ña ke vaꞌa sa yu, ra niꞌi yu koo yu xiꞌin Ndioxi ndia ndikaa ndikuꞌun ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―¿Nichuun kaꞌan kun “ra vaꞌa” xiꞌin yu? Chi köo ndia nii yuvi na vaꞌa, chi indaa mituꞌun Ndioxi va kuvi ra vaꞌa. Ndi su tu kuni kun ña koo kun xiꞌin Ndioxi iin ndisaa kii, saa ra xiniñuꞌu na satoꞌo kun ndiayu Ndioxi va ―*kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Saa ndakuiin ra loꞌo kan kachi ra saa: ―¿Ra ndia ña kuu ndiayu Ndioxi ña xiniñuꞌu satoꞌo yu, Tata? ―kachi ra. Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Käꞌni kun ndii; ra kïꞌvi kun xiꞌin inka ñaꞌa ña küu yasiꞌi kun; ra sakuïꞌna kun; ra nii xaväꞌa ini kun ña ndatuꞌun kun xaꞌa inka yuvi; ");
INSERT INTO mxv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ra na satoꞌo kun iva kun xiꞌin siꞌi kun; ra na kuꞌvi ini kun kuni kun na taꞌan kun, ta kuꞌva kuꞌvi ini kun xini kun mii kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ra saa ndakuiin ra loꞌo kan kachi ra saa: ―Tata, takundiꞌi ña ñaa, ra ndia loꞌo vi yu ke xaꞌa yu ^xá yu ña; ¿ra ndia ka ña ke kumani ka tu nuu yu? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Tu kuni kun ña kuu kun iin tiaa ra ndaku, saa ra kuaꞌan ra xiko kun takundiꞌi ñaꞌa ña iyoo nuu kun, ra saniꞌi kun xuꞌun na ndaꞌvi, ra saa ke kuu kun ra kuika ndivi nuu xaꞌndia Ndioxi chiñu, ra te ndiꞌi saa na kixi kun ra kundikun kun yuꞌu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ra te xini soꞌo ra loꞌo kan tuꞌun yoꞌo, saa ra ndakiꞌin ra kuaꞌan va ra, ndi su tiaa ni kusuchi ini ra kuaꞌan ra, saa chi kuika ni ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi na kuika, ra tiaa ni uꞌvi kiꞌvi na ichi nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ra na kaꞌan ka yu xiꞌin ndo ña vaꞌa na kundaa ini ndo: Tu ña kuvi vi kuu ña, ra a iin sana vaꞌa ka va kiꞌvi iin camello chee yavi loꞌo xaꞌa iin tiku, nuu ña kiꞌvi iin ra kuika ichi nuu xaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ra te xini soꞌo ndia itaꞌan xiꞌin Jesús ña kachi ra saa, saa ra ndakanda ka vi ini ndia, ra ndikaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―Tu saa va ke kuu xiꞌin na kuika, saa ra, ¿yoo va kuvi na kuchuun kaku tu saa? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ra saa ^ixtoꞌni Jesús nuu ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Nuu na yuuvi yoꞌo va ke uꞌvi ni ña yoꞌo, ndi su nuu Ndioxi, ra köo ña üꞌvi ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Saa ndikaꞌan ra Pedro xiꞌin Jesús kachi ra saa: ―Tata, nduꞌu, ra ni ke niꞌi ndi, chi ndakoo ndiꞌi va ndi ñaꞌa ña kuu mii ndi, ra ndakundikun ndi yoꞌo xika ndi xiꞌin kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Saa ndakuiin Jesús kachi ra saa. ―Ña ndixa kaꞌan yu xiꞌin ndo, chi te na xaa kii ña nduxaa takundiꞌi ñaꞌa, ra saa ke ndakunduꞌu yuꞌu, ra xaa yoꞌo vichin, tiayu kaꞌnu, ra ndakiꞌin yu ña kaꞌndia yu chiñu. Saa ra ndoꞌo ndia ndikun yuꞌu vichin, ra niꞌi tu ndoꞌo va iin iin tiayu naꞌnu kundee ndo, ra kaꞌndia ndo chiñu nuu uxi uvi saa na seꞌe xikua na ñuu Israel. ");
INSERT INTO mxv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ra takundiꞌi yuvi, na ndakoo veꞌe, na ndakoo ñani, na ndakoo kuꞌva, na ndakoo siꞌi, na ndakoo iva, na ndakoo yasiꞌi, na ndakoo seꞌe, na ndakoo ñuꞌú, xaꞌa ña ndikun na yuꞌu, ra na kan, ra iin ciento ka va nduu ña ndakiꞌin na sa Ndioxi, ra niꞌi tu na ña kutiaku na xiꞌin Ndioxi ndia ndikaa ndikuꞌun va. ");
INSERT INTO mxv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ra kuaꞌa ni tu na inuu vichin, ra ndakundikun va na kan kii ña vaxi, ra na ndikun vichin kuvi na ndakunuu va tu ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Saa ndikaꞌan ka Jesús iin tuꞌun ndichi xiꞌin na kachi ra saa: ―Kuꞌva ña xachiñu Ndioxi ra inuu va ña xiꞌin chiñu ña xa iin ra tata, ra chiꞌi teꞌe uva nuu iin ñuꞌu ña kuu mii ra, ra saa kuu ñaꞌa ka vi kee ra iin kii kuaꞌan ra, ña nduku ra na sachiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ra saa kindoo ra xiꞌin na ña chaꞌvi ra na iin xuꞌun ña nani denario iin kii nduvi, ra saa tiꞌvi ra na kuaꞌan na sachiñu na chiñu ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ra ta kuꞌva kaa ìi̱n ixtiaan, saa kee tuku ra tata kan kuaꞌan ra, ra saa ndixaa ra nuu yaꞌvi, ra saa xini ra ndee mii sava na. ");
INSERT INTO mxv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Saa ndikaꞌan ra xiꞌin na kachi ra saa: “Naꞌa ndo, ra kuꞌun tu ndoꞌo va sachiñu ndo chiñu yu, ra chaꞌvi xinu va yu ndoꞌo”, kachi ra xiꞌin na. Ra saa ndakiꞌin na kan kuaꞌan na sachiñu na chiñu ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Saa kuu, ra kee tuku va ra kuaꞌan ra ta kuꞌva kaa uxi uvi kaꞌñu, ra ndakitaꞌan tuku va ra xiꞌin sava na; ra saa kachi tu ra xiꞌin na kan va. Ra saa ndiko tuku va ra ndixaꞌan ra ta kuꞌva ka uni xikuaa, ra iin ta kachi ra xiꞌin takundiꞌi na sava kan ke kachi tu ra xiꞌin na kan va. ");
INSERT INTO mxv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ra ta kuꞌva ka uꞌun xikuaa, saa kee tuku va ra kuaꞌan ra, ra ndakitaꞌan tuku va ra xiꞌin sava na ndee mii, na ninïꞌi chiñu, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: “¿Nichuun íin ndo saa ndee ndo iin nduvi ndaa vichin?”, kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Saa ndakuiin na kachi na saa xiꞌin ra: “Ndia nii na ndikäꞌan xiꞌin ndi ña kuꞌun ndi sachiñu ndi xiꞌin na, ña kan ke saa íin ndi ndee va ndi, Tata”, kachi na xiꞌin ra. Saa ndikaꞌan ra xiꞌin na kachi ra saa: “Tu saa, ra kuaꞌan tu ndoꞌo va sachiñu ndo chiñu yu, ra chaꞌvi xinu va yu ndoꞌo kii vichin”, kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Ra saa te xa kuaa ña xa ndixinu hora kee na xachiñu kan, ra saa ndikaꞌan ra tata kan xiꞌin ra inuu xaꞌndia chiñu nuu na xachiñu xiꞌin ra, kachi ra saa: “Ndakana takundiꞌi na xachiñu, na kixi na, ra xaꞌa kun chaꞌvi kun na, ra xiꞌna ka va na ndikun xaa na xaꞌa kun chaꞌvi kun, ra saa vi chaꞌvi kun na xaa ñaꞌa vaꞌa”, kachi ra xiꞌin ra ndiso chiñu kan. ");
INSERT INTO mxv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ra saa ndixaa na ndikun ndikee xachiñu, te kàà uꞌun xikuaa, ra saa taxi ra iin xuꞌun denario ndaꞌa ta iin ta iin na kan, xaꞌa hora ña xachiñu na. ");
INSERT INTO mxv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ra te ndiꞌi, saa xaa tu na ndikee xachiñu ñaꞌa ni va, ra ndakani ini na kaꞌan na saa: “Viꞌi ka va chaꞌvi ra yoo chi ñaꞌa ni va ndikee yo”, kaꞌan na, ndi su inuu chaꞌvi ra ta kundiꞌi va na, chi indaa indaa xuꞌun kàà ña nani denario ke taxi ra ndaꞌa takundiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ra te ndiꞌi ndakiꞌin na yaꞌvi na, ra saa xaꞌa na kaꞌan ñàꞌa na xaꞌa ra ixtoꞌo uva kan, ");
INSERT INTO mxv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ra ndikaꞌan na xiꞌin ra kachi na saa: “Tata, nichuun inuu chaꞌvi va kun nduꞌu xiꞌin na kaa, ra xa xikuaa va ndikee na, ra iin hora loꞌo vi ke xachiñu na, ra nduꞌu, ra iin nduvi ndaa vi xachiñu ndi, ra iꞌni ka vi kaꞌñu ndixika ndi, ra väꞌa vi ndixa kun xiꞌin ndi, chi inuu chaꞌvi va kun nduꞌu xiꞌin na”, kachi na xiꞌin ra ixtoꞌo uva kan. ");
INSERT INTO mxv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Saa ndakuiin ra Tata kan kachi ra saa xiꞌin ra ndikaꞌan xiꞌin ra: “Tata, ndukuëꞌe kun chi ndisandäꞌvi yu yoꞌo, chi ta kuꞌva kindoo yu xiꞌin kun ke chaꞌvi yu yoꞌo va, ra saa ke kindoo va yo. ");
INSERT INTO mxv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ra xa saa ke koo yaꞌvi va kun, ra kuanuꞌu chi xa vaꞌa va. Ndi su ra ndikun ndikiꞌvi xachiñu, ra ta kuꞌva chaꞌvi yu yoꞌo ke, kuni yu chaꞌvi tu yu ra kan va. ");
INSERT INTO mxv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Saa chi mii va yu kuvi ra xini, ndia ña ke kuvi sa yu xiꞌin xuꞌun yu. ¿Ra nichuun ndukuini ini kun xini kun na ña ^xa yu ña vaꞌa xiꞌin na?”, kachi ra ixtoꞌo uva kan xiꞌin tiaa kan, ^kachi tuꞌun ndichi yoꞌo ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Na kundaa ini ndo, chi na ndikun vichin kuvi na ndakunuu va, ra na inuu vichin kuvi na ndakundikun va tu. Ra saa ke iyoo va ña: saa chi kuaꞌa ni va kuvi na ^kana Ndioxi kuꞌun koo xiꞌin ra nuu xaꞌndia ra chiñu, ndi su loꞌo ni va kuvi na ^ndakaxin ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ra saa kuu ra ndakiꞌin Jesús kuaꞌan ra chi ñuu Jerusalén, ra saa tava siin ra uxi uvi saa ndia itaꞌan xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Vichin ke kuaꞌan yo ñuu Jerusalén, ra ikan ku nuu ndataxi na yuꞌu, ra xaa yoꞌo, ndaꞌa sutu ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ra kaꞌndia ndia chiñu ña na kuvi yu, ");
INSERT INTO mxv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ra ndataxi tu ndia yuꞌu ndaꞌa na yuvi kuachi na xïni tuꞌun Ndioxi, na küu judío, ra kusiki ni na yuꞌu, ra kani ni na yuꞌu xiꞌin ñii ña kuu kuarta, ra saa katakaa na yuꞌu ndaꞌa cruz, ndi su kii uni ra ndatiaku va yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ra saa kuyachin ña siꞌi ndia seꞌe ra Zebedeo xiꞌin uvi saa tiaa seꞌe ña, ndia itaꞌan xiꞌin Jesús, ra xikusiti ña nuu Jesús; ña ^nduku ña iin ña mani nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ra saa ndikaꞌan ra xiꞌin ña kachi ra saa: ―¿Ni ke kuni kun sa yu xiꞌin kun, Nana? ―kachi ra xiꞌin ña. Saa ndakuiin ña kachi ña saa: ―Kuni yu ña na taxi kun ndiayu ra vaꞌa na kundee seꞌe yu xiꞌin kun nuu kaꞌndia kun chiñu; ra iin ra na kunduꞌu chi xiin kuaꞌa kun, ra inka ra na kunduꞌu chi xiin ichin kun ―*kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ra saa ndakuiin Jesús kachi ra saa: ―Ndoꞌo, ra kundäa ini ndo ni ke kaꞌan ndo xaꞌa vi. ¿A kuchuun ndo koꞌo ndo vaso ña koꞌo yu, ra kuchi tu ndo ta kuꞌva kuchi yu, ña kuu tundoꞌo ña ndoꞌo yu, tuvi ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Kuchuun va ndi, Tata ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña ndixa kuvi va ña kuchuun ndo koꞌo ndo vaso ña koꞌo yu, ra kuchuun tu ndo kuchi ndo ta kuꞌva kuchi yu; saa chi ndoꞌo ni tu ndoꞌo va xaꞌa ña ndikun ndo yuꞌu. Ndi su ña taxi yu kundee ndo xiin kuaꞌa yu, a xiin ichin tu yu, ra uꞌvi ni va ña kan, saa chin süvi yuꞌu kuvi ra xaꞌndia xaꞌa ña kan, chi Tata va yu kuvi ra xini, yoo kuvi na taxi ra ndiayu ndaꞌa ña kundee na xiin yu nuu kaꞌndia yu chiñu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ra te xini soꞌo ndia uxi kan, ña nduku uvi ndia kundee ndia xiin Jesús, saa ra ndisaa ni ndia xiꞌin ndia uvi kan. ");
INSERT INTO mxv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ra saa ndakana Jesús takundiꞌi ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Xa kundaa ini mii va ndo chi na kunaꞌnu xaꞌndia chiñu nuu ña yuuvi yoꞌo, xiꞌin ndia ndia ka na chiñu, ra ndiee ni va ndasanaꞌnu na mii na, ra indaa mii va na kuvi na xaꞌndia chiñu, ra ña kuni mii na ke iyoo va, ra ta kuꞌva kuni mii na ke ^xa va na xiꞌin na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ndi su ndoꞌo, ra süvi saa ke koo ndo, chi xa siin va ke koo xiꞌin ndoꞌo. Saa chi ndoꞌo, na ^kuni kuu na kunaꞌnu, ra na xachiñu nuu takundiꞌi va na ke kuu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ra na ^kuni kunuu nuu ndo, ra na sachiñu nuu takundiꞌi va ndo ke na kuu na. ");
INSERT INTO mxv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta kuꞌva iyoo yuꞌu, ra xaa yoꞌo, chi yuꞌu ra ndixäa yu ña kaꞌndia yu chiñu, chi ra xaa xachiñu nuu takundiꞌi va ndo kuvi yu, ra ndataxi yu mii yu xaꞌa takundiꞌi va na yuuvi yoꞌo, ra saa ke vaꞌa saña ndika na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ra ta kee Jesús ñuu Jericó kuaꞌan ra, ra kuaꞌa ka vi yuvi ndandikun kuaꞌan sata ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ra ichi nuu yaꞌa ra kuaꞌan ra kan ndee uvi ndia kuaa, ra te xini soꞌo ndia ña yaꞌa Jesús kuaꞌan ra, saa ra ndiee ka vi xaꞌa ndia ^kana ndia ra kachi ndia saa: ―¡Tata, seꞌe ra rey David, kundaꞌvi ini kuni nduꞌu! ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Saa ra xaꞌa sava yuvi kan ndaꞌyu na nuu ndia, ña kuni na, ña na koo taxin yuꞌu ndia; ndi su ndia kuaa kan ra ndia ndiee ka kana va kuvi ndia kachi ndia saa: ―¡Tata, seꞌe ra rey David, kundaꞌvi ini kuni nduꞌu! ―kachi tuku va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ra saa xikundichi Jesús, ra kana ra ndia xaa ndia nuu ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Ni ke kuni ndo sa yu xiꞌin ndo? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ra saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, nuu va ndi ke kuni ndi na ndanuña ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Saa ra kundaꞌvi ni ini Jesús xini ra ndia, ra saa nditiandiaa ndaꞌa ra nuu ndia, ra ndikun ndanuña ndixa va ña, ra vaꞌa ka vi ndakotoꞌni ndia. Ra saa ndakundikun ndia kuaꞌan ndia xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ra saa kuu Jesús xika ra kuaꞌan ra xiꞌin yuvi kan, ra saa ndixaa na ñuu Betfagé ña ndikaa yachin xiꞌin iku ña nani Olivo, ra ikan xaꞌndia Jesús chiñu nuu uvi ndia itaꞌan xiꞌin ra, ");
INSERT INTO mxv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ra kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ñuu loꞌo ña ndikaa yachin kaa, ra kaa ndaniꞌi ndo iin burru tiatan loꞌo íin ri xiꞌin burru loꞌo seꞌe ri, ra ndaxi ndo ri na kixi ri xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ra tu ndia na ndakoyo, ra kaꞌan na xiꞌin ndo xaꞌa ri, ra suꞌva ke kachi ndo xiꞌin na: “Tata yo ku ra xiniñuꞌu ri nuu, ra ndïꞌi ini ndo xaꞌa ri chi takaꞌan va kixi ndi ndiaka ndi ri”, kachi ndo xiꞌin na ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ra suꞌva ke kuu ña vaꞌa ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ta kachi ra suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kaꞌan ndo xiꞌin na ñuu Jerusalén na kuu ñuu Ndioxi, ra kachi ndo saa xiꞌin na: “Kotoꞌni ndo chi kaa vaxi ra kuu Rey ndo, ña ndakitaꞌan ra xiꞌin ndo, ra iin ra toꞌo ni va kuvi ra, ra yoso ra iin burru loꞌo seꞌe kiti ri ndiso ña vee vaxi ra nuu ndo”, kachi ra ndikaꞌan tuꞌun Ndioxi kan. ");
INSERT INTO mxv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ra saa kee ndia itaꞌan xiꞌin Jesús ndixaꞌan ndia, ra ta kuꞌva kachi ra xiꞌin ndia ke xa va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ra saa ndiaka ndixa va ndia burru tiatan loꞌo kan xiꞌin seꞌe loꞌo ri xaa ndia, ra saa tiso ndia tikoto ña isukun ndia sata ri, ra ndakoso Jesús ri kuaꞌan ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ra yuvi na kuaꞌa ni kan, ra xaꞌa na ^xakin na tikoto ña isukun na ichi nuu yaꞌa ra kuaꞌan ra, ra sava tu na kuaꞌan xaꞌnu iku ndaꞌa itun va, ra xakin na ña ichi nuu yaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ra yuvi na inuu chi nuu, xiꞌin na ndikun chi sata ra, ra iin siso siso ndaꞌyu na kachi na saa: ―¡Ra kaꞌnu ni kuvi ra yoꞌo!, chi ndiseꞌe ra Rey David kuvi ra; ¡ra kaꞌnu ni ra, chi Tata yo Ndioxi kuvi ra tiꞌvi ra ña vaxi ra sakaku ra yoo! ¡Na ndasakaꞌnu ndo Tata yo Ndioxi ra iyoo ndivi! ―^kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ra te ndikiꞌvi Jesús ñuu Jerusalén kuaꞌan ra, ra iin takundiꞌi yuvi na ndee ñuu kan, ra iin xaꞌa ndakaña yuꞌu na, ra iin ndakatuꞌun taꞌan na kachi na saa: ―¿Yoo ku ra yoꞌo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Saa ndakuiin na kuaꞌan xiꞌin Jesús kachi na saa xiꞌin na: ―Ra yoꞌo kuvi Jesús ra kaꞌan tuꞌun yuꞌu Ndioxi, ra kee ñuu Nazaret ña ndikun ndiaa Galilea ―kachi na xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Saa ndixaa Jesús ndikiꞌvi ra ini veꞌe ñuꞌu Ndioxi, ra tava ra takundiꞌi na ndee ixiko, ra saa tu na sata nuu va na, ra tiin ra mesa na ndee nama xuꞌun xiꞌin yuvi, ra sanduva ra nu kan va, ra saa tu tiayu tu ndee na ixiko paloma va; ");
INSERT INTO mxv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Tuꞌun Ndioxi ra suꞌva va kachi ña: “Veꞌe yu, ra veꞌe nuu kaꞌan takundiꞌi yuvi xiꞌin Ndioxi va ke kunani ña”, ^kachi ña, ndi su ndoꞌo, ra kava nuu ndakuitaꞌan na kuiꞌna va ndasa ndo ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ra ini veꞌe ñuꞌu kan ndixaa kuaꞌa ni na xiꞌi, na kuaa, xiꞌin na nduchiꞌña küvi kaka, ra sandaꞌa Jesús takundiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndi su ndia xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, ra ixtoꞌni ndia ña ^xa Jesús ña xituꞌun, ra iin siso siso tu ndaꞌyu na kuachi vali na ñúꞌu ini veꞌe ñuꞌu kan va, ^kachi na saa: “¡Ra kaꞌnu ni kuu Jesús seꞌe ra Rey David!”, ^kachi na. Saa ra ndukueꞌe ni ini ndia xikuaꞌa kan, ");
INSERT INTO mxv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ra ndikaꞌan ndia xiꞌin Jesús kachi ndia saa: ―¿A xini soꞌo kun ña kuu yuꞌu na kuachi yoꞌo? ―kachi ndia xiꞌin ra. Saa ndakuiin ra yuꞌu ndia kachi ra saa: ―^Xini va soꞌo yu. ¿Ra a ndia nii va ichi täan kaꞌvi ndo tuꞌun Ndioxi ña kaꞌan, kachi suꞌva?: Yuꞌu na kuachi vali, xiꞌin yuꞌu na sakan chichin ke chinduꞌu kun tuꞌun ndaku ña ndixa, ña ndasakaꞌnu na yoꞌo, ^kachi ña ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ndia saa ra ndakoo Jesús ndia ini veꞌe ñuꞌu kan, ra kanata ra chi keꞌe, ra ndakiꞌin ra kuaꞌan ra chi ñuu Betania va, ra ñuu kan vi ndixaa ra ndikixi ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ra te ndituvi inka kii saa kee Jesús ñuu kan, ra nandiko tuku va ra vaxi ra ñuu Jerusalén, ra vaxi ra ichi saa xaꞌa ndikaꞌun ini va ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ra saa xini ra ndichi iin tu koxi yachin yuꞌu ichi kan, saa ra ndakiꞌin ra ndixaa ra nuu íin nu, ra ndia nii koxi loꞌo köo ndaꞌa nu ndiniꞌi ra, chi takua niña iku va ke iyoo ndaꞌa nu, ra saa ndikaꞌan ra xiꞌin nu kachi ra saa: ―Ndia nii ka kii na küun kuiꞌi ndaꞌa kun ―kachi ra xiꞌin nu. Saa ra ndikun ndachi va itun koxi kan. ");
INSERT INTO mxv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Saa ra ixtoꞌni ndia itaꞌan xiꞌin ra, ra xaꞌa ndakanda ka vi ini ndia, ra ndakatuꞌun taꞌan ndia kachi ndia saa: ―¿Nichuun ke, ra kama ni ndachi itun koxi yoꞌo? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, chi tu ndinuni ni na kandixa ndo, ra sä uvi ini ndo, saa ra süvi takua itun koxi kuvi nu kuchuun ndo sandachi ndo, ta kuꞌva xa yuꞌu, chi kuchuun tu ndo, ña kaꞌan ndo xiꞌin iku kaa ra kachi ndo saa xiꞌin ña: “Kita nuu iin kun ñaa, ra kuaꞌan sakoꞌni kun mii kun ini mini”, kachi ndo xiꞌin ña, saa ra, saa sa ndixa va ña. ");
INSERT INTO mxv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Saa chi takundiꞌi ña nduku ndo nuu Ndioxi, ra taxi va ra ña ndaꞌa ndo, tu ndinuni ni na kandixa ndo ta kaꞌan ndo xiꞌin ra xaꞌa ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Saa kuu ra ndixaa Jesús ndikiꞌvi ra ini veꞌe ñuꞌu, ra saa xaꞌa ra sañaꞌa ra yuvi kan tuꞌun Ndioxi; ra sakan saa kuu ra sañaꞌa ra na, saa ra ndixaa va sutu ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, ra nindakatuꞌun ndia ra kachi ndia saa: ―¿Ni ndiayu ku mii kun ña xa kun saa? ¿Ra yoo taxi ndiayu ndaꞌa kun ña xa kun ña yoꞌo? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Kuni tu yuꞌu va ndakatuꞌun yu iin ña ndoꞌo, ra tu na ndakuiin ndo yuꞌu yu, ra saa ke ndatuꞌun tu yuꞌu va xiꞌin ndo, yoo ko taxi ndiayu ndaꞌa yu ña xa yu ña yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Saa nindakatuꞌun ra ndia kachi ra saa: ―¿Yoo ko xaꞌndia chiñu nuu ra Juan ña sakuchi ra yuvi? ¿Ndioxi, a na yuuvi va? ―kachi ra xiꞌin ndia. Ra saa xaꞌa ndia kaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―¿Ni ke kachi yo xiꞌin ra? Chi tu na kaꞌan yo: “Ndioxi va kuvi ra taxi ndiayu ndaꞌa ra”, saa ra, kachi ra saa xiꞌin yo: “¿Nichuun ndikandïxa tu ndo ña ndikaꞌan ra tu saa?”, kachi ra xiꞌin yo. ");
INSERT INTO mxv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ra tu na kachi tu yo: “Na yuuvi yoꞌo va kuvi na taxi ndiayu ndaꞌa ra”, saa ra iyo ni va xiꞌin yo, saa chi takundiꞌi na ñuu, ra kandixa va na ra Juan, ña kuu ra, ra ndikaꞌan ndoso tuꞌun Ndioxi ―*kachi ndia xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ra saa ndikaꞌan ndia xiꞌin Jesús kachi ndia saa: ―Xïni ndi yoo kuvi na taxi ndiayu ndaꞌa ra ―kachi ndia. Saa ndakuiin Jesús yuꞌu ndia kachi ra saa: ―Saa ra nii yuꞌu ndatüꞌun tu xiꞌin ndoꞌo va, yoo ko taxi ndiayu ndaꞌa yu ña ^xa yu ña yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin na kachi ra saa: ―Na ndakani yu ña yoꞌo nuu ndo, ¿ra ndia kuꞌva ke tuvi ndo xiꞌin ña? Ndixiyo iin tiaa, ra ndixiyo uvi tiaa vali seꞌe ra, ra saa ndikaꞌan ra xiꞌin seꞌe ra, ra nuu, kachi ra saa: “Ra loꞌo, naꞌa, ra kuꞌun kun loꞌo kii vichin sachiñu kun xiꞌin teꞌe uva yu”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ra saa ndakuiin ra loꞌo kan kachi ra saa: “Küꞌun yu”, kachi ra xiꞌin iva ra. Ndi su nduꞌu ra saa, saa ra nandiko ini va ra, ra ndakiꞌin ra ndixaꞌan ra xachiñu va ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ra saa ndixaꞌan tu ra tata kan ndikaꞌan ra xiꞌin seꞌe ra, ra kuloꞌo va, ra iin ta kachi ra xiꞌin ra nuu kan ke kachi tu ra xiꞌin ra uvi kan va. Ra saa ndakuiin ra kan kachi ra saa: “Vaꞌa va, tata, kuꞌun va yu sachiñu yu xiꞌin kun”, kachi ra xiꞌin iva ra, ndi su ndixäꞌan vi ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ra ndia iin ndia kan kuvi ndia xiin xa suvi chiñu ña xaꞌndia iva ndia nuu ndia, tuvi ndo? ―kachi Jesús xiꞌin na. Ra saa ndakuiin na kachi na saa: ―Ra nuu va ku ra xiin xachiñu nuu iva ―kachi na. Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo vichin, chi na kaya xuꞌun ndaꞌa na ñuu, ña kuaꞌan ndaꞌa gobierno ñuu Roma, xiꞌin na siꞌi na ixiko mii, ra xiꞌna ka va na kan kuvi na kunuu kiꞌvi nuu xaꞌndia Ndioxi chiñu nuu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Saa chi kixi ra Juan sañaꞌa ra ndoꞌo xaꞌa ichi ndaku ña kuni Ndioxi na kundikun ndo, ndi su ndikandïxa ndo; ra na kaya xuꞌun, xiꞌin na siꞌi ixiko mii, ra kandixa va na kan ña ndikaꞌan ra. Ndi su ndoꞌo, ra vaꞌa ni xini nuu va ndo ña xa ra, ndi su ndixïin ndo ña nandiko ini ndo xaꞌa kuachi ndo, ra kandixa ndo ña ndikaꞌan ra xiꞌin ndo ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Tiaa soꞌo ndo na ndatuꞌun yu inka tuku tuꞌun ndichi xiꞌin ndo kachi ra: Suꞌva ndoꞌo iin tiaa, ra ndataan teꞌe uva iin nuu ñuꞌu kaꞌnu, ra chikaa tu ra korra yuu va nuu ñuꞌu kan, ra kaan tu ra yavi sata kava nuu kuꞌni na uva va, ra saa xavaꞌa tu ra iin veꞌe sukun nuu kundee na kondiaa teꞌe uva kan va. Ra te ndiꞌi, saa satatu ra ña inka yuvi, ra ndakiꞌin ra kuaꞌan ra inka ñuu xika va. ");
INSERT INTO mxv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ra te nditiandiaa kii ña tiaꞌndia uva, ra saa tiꞌvi ra sava na xachiñu nuu ra kuaꞌan na nuu na tatu too ñuꞌu kan, ña na ndataxi na loꞌo kuenda ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ndi su na tatu ñuꞌu nuu yoo teꞌe uva kan, ra ndukuiin na tiin na na xachiñu nuu ra, ra kani na na, ra sava na xaꞌni na, ra sava tu na kuun na yuu va. ");
INSERT INTO mxv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ra saa tiꞌvi kuaꞌa ka va ra xitoꞌo uva kan, na xachiñu nuu ra ndixaꞌan na, nuu na tatu too ñuꞌu kan, ndi su ta xa na xiꞌin na inuu ndixaꞌan kan ke, xa tu na xiꞌin na kan va. ");
INSERT INTO mxv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ndi su te ndiꞌi, ra saa tiꞌvi ra xitoꞌo uva kan seꞌe mii ra, ña kuaꞌan ra nuu na, chi ndakani ini ra kaꞌan ra saa: “Satoꞌo va na seꞌe yo”, káꞌán ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ndi su na tatu too ñuꞌu nuu yoo teꞌe uva kan, ra te xini na ra loꞌo seꞌe ra, ra saa ndikaꞌan na xiꞌin taꞌan na kachi na saa: “Ra yoꞌo va kuvi ra ndoo ndiꞌi ña yoꞌo ndaꞌa; ra naꞌa ndo vichin ra tiin yo ra, ra kaꞌni yo ra, ra ñaꞌa mii yo nduu ndiꞌi va ña yoꞌo”, kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ra saa tiin na ra loꞌo kan, ra tava na ra nuu ñuꞌu iva ra, ra ikan xaꞌni va na ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ra vichin na kundaa ini yo: ¿Ni ke sa ra xitoꞌo uva kan, xiꞌin na tatu too ñuꞌu nuu yoo teꞌe uva, te na ndiko ra, tuvi ndo? ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ra saa ndakuiin na ndee xini soꞌo kan kachi na saa: ―Ña sa ra ke, kaꞌni ndiꞌi va ra yuvi ñaꞌa kan, ra ndia nii na köo kaꞌnu ini ra xiꞌin vi, ra saa satatu ra ñuꞌu nuu yoo teꞌe uva kan inka yuvi na toꞌo, na kuiin chaꞌvi nuu ra, te xa na xinu uva ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―¿A ndia nii va ichi täan kaꞌvi ndo tuꞌun Ndioxi ña tiaa na xinaꞌa, ña kachi suꞌva?: Yuu ña kuñuꞌu na xavaꞌa veꞌe ta yachi kuu yuu ña xiniñuꞌu vaꞌa ka va vichin. Ra Ndioxi va ku ra xa ña yoꞌo, ra ndakanda ni ini yo xiꞌin ña, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Ra ña kan ke kaꞌan yu xiꞌin ndo, ra na kundaa ini ndo: chi kindiaa va Ndioxi ndiayu ndaꞌa ndo ra küvi kiꞌvi ndo nuu xaꞌndia ra chiñu, ra ndataxi ra ña ndaꞌa inka yuvi na xiin sa ña kuni va ra. ");
INSERT INTO mxv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ra ndia ndia ka yuvi na nduva sata yuu yoꞌo, saa ra taꞌnu ndiꞌi va na; ra tu mii yuu yoꞌo tu na ndakava sata na, saa ra kuu xeꞌe yaa va na sa ña ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ra saa ixtoꞌni ndia xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia fariseo, ña ndakani Jesús tuꞌun ndichi yoꞌo, saa ra kundaa va ini ndia, ña kaꞌan ra xaꞌa mii ndia. ");
INSERT INTO mxv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ra saa kuni ndia ña tiin ndia ra, ndi su ndiyuꞌvi va ndia nuu na ñuu, saa chi takundiꞌi na ñuu, ra kandixa va na Jesús, ña kuu ra, ra kaꞌan tuꞌun yuꞌu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Saa xaꞌa Jesús ndatuꞌun ra inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Kuꞌva ña xachiñu Ndioxi, ra inuu va ña xiꞌin chiñu ña xa iin rey ra xakin viko tandaꞌa, ña satandaꞌa ra tiaa loꞌo seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ra te xaꞌa ra rey kan ña ^xa nduvi ra koo viko xaꞌa seꞌe ra, saa tiꞌvi ra na xachiñu nuu ra kuaꞌan na nuu yuvi, na xa ndikaꞌan ra xiꞌin kuꞌun viko kan, ndi su ndixïin na kuꞌun na. ");
INSERT INTO mxv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ra saa tiꞌvi tuku va ra rey kan na xachiñu nuu ra kuaꞌan na, ra ndikaꞌan ra xiꞌin na kachi ra saa: “Kuaꞌan ndo ra kaꞌan ndo xiꞌin na, ña na kixi na chi xa xanduvi ndiꞌi va yu ñaꞌa ña kuxi na. Chi xa xaꞌndia va yu chiñu ña xaꞌni na, kuaꞌa ni sindiki sana yu, ra saa tu kuaꞌa ni ka tu nuu kiti sana yu ri sandaꞌa va yu, ra xa iyoo nduvi ndiꞌi va ña, ra kama ni na kixi na kachi ndo xiꞌin na”, kachi ra rey kan xiꞌin na xachiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ra iin ta kachi ra rey kan xiꞌin na xachiñu nuu ra ke xa va na: Ndi su yuvi kan ra nditiäa soꞌo vi na ña ndikaꞌan na xachiñu nuu ra xiꞌin na, saa chi ndakiꞌin ta iin ta iin na kuaꞌan na chiñu va na, iin na ndakiꞌin kuaꞌan kotoꞌni ñuꞌu, ra inka tu na ndakiꞌin kuaꞌan xiko va, ");
INSERT INTO mxv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ra sava tu na ndukuiin, ra tiin ná na xachiñu nuu ra rey kan ra kanitaꞌan na xiꞌin na, ra xaꞌni va ná na. ");
INSERT INTO mxv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ra saa te kundaa ini ra rey kan, ra tiaa ni ndisaa ra xiꞌin na, ra saa tiꞌvi ra ndia soldado ra, ra ndixaꞌan ndia xaꞌni ndia takundiꞌi yuvi na xaꞌni na na xachiñu nuu ra, ra ndia ñuu va na ke xaꞌmi ndia soldado kan. ");
INSERT INTO mxv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ra saa ndikaꞌan ra rey kan xiꞌin na xachiñu nuu ra kachi ra saa: “Takundiꞌi ñaꞌa ña kuniñuꞌu yo viko tandaꞌa yoꞌo, ra xa iyoo nduvi yaa va ña. Ndi su na ndikaꞌan yu xiꞌin kixi, ra köo yaꞌvi ndiaa vi na ña kixi na, ña kan ke ndikïxi na. ");
INSERT INTO mxv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ra vichin kuaꞌan ndo iinii kuvi nuu ndakitaꞌan ichi, nuu yaꞌa kuaꞌa ni yuvi, ra kaꞌan ndo xiꞌin takundiꞌi na ndakitaꞌan xiꞌin ndo, ra na kixi na viko tandaꞌa”, kachi ra rey kan xiꞌin na xachiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ra saa kee na xachiñu nuu ra rey kan ndixaꞌan na iinii kuvi ichi, ra ndakaya na takundiꞌi va yuvi xaa xiꞌin na, na vaꞌa, xiꞌin na väꞌa, ra iin ndakutu ndaa va veꞌe nuu iyoo viko tandaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ra te ndikiꞌvi ra rey kan kuni ra na ndixaa viko kan, ra saa xini ra iin tiaa, ra ndïxi tiaa kan tikoto taꞌan ña ndixi na kuaꞌa, na ndixaa viko tandaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ra saa ndikaꞌan ra rey kan xiꞌin tiaa kan kachi ra saa: “Tata, ¿ni ke xa kun ndikiꞌvi kun yoꞌo? Chi ndïxi kun taꞌan tikoto ña ndixi na kuaꞌa yoꞌo”, kachi ra xiꞌin ra. Saa ra ndia nii tuꞌun ndindäkuiin tiaa kan. ");
INSERT INTO mxv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ra saa ndikaꞌan ra rey kan xiꞌin na xachiñu nuu ra kachi ra saa: “Tiin ndo ra, ra chikuꞌni ndo xaꞌa ra xiꞌin ndaꞌa ra, ra sakoꞌni ndo ra chi keꞌe, chi nuu ñaa, ra ikan ke kuaku ni ra, ra iin ndiakua ndakaxi nùꞌù ra”, kachi ra rey kan, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ra saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Kuaꞌa ni va kuvi na ^kana Ndioxi, ña kiꞌvi na koo na xiꞌin ra nuu xaꞌndia ra chiñu, ndi su loꞌo ni va kuvi na ^ndakaxin ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ra te sandiꞌi Jesús ndakani ra tuꞌun ndichi kan nuu na, ra saa ndakiꞌin ndia fariseo kuaꞌan ndia, ra ndakutaꞌan ndia ndikataꞌan ndia, ndia kuꞌva ke sa ndia ña vaꞌa na kaꞌan Jesús iin tuꞌun kiꞌvi, ra saa ke kuvi niꞌi ndiee ndia, ña taxi ndia kuachi xaꞌa ra kaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ra saa tiꞌvi ndia fariseo kan ndia itaꞌan xiꞌin ndia kuaꞌan ndia xiꞌin ndia itaꞌan xiꞌin ra Herodes, ña kuaꞌan ndia kotondoso ndia Jesús, ra te ndixaa ndia ra saa ndikaꞌan ndia kachi ndia saa xiꞌin ra: ―Tata Maestro, kundaa ini ndi chi ña kaꞌan kun ra ña ndixa ni va kuvi ña, ra sañaꞌa kun yuvi tuꞌun Ndioxi ta kuꞌva iyoo mii va ña, ra nii xä kun xaꞌa vi ña kaꞌan yuvi, chi iin kuu ndiꞌi va na nuu kun, ra köo na ndakaxin kun. ");
INSERT INTO mxv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ra kaꞌan xiꞌin ndi vichin, ¿a vaꞌa ña chaꞌvi ndi nuu ra tata chiñu César ñuu Roma, xuꞌun ña nduku ra nuu ndi, a väꞌa? ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ndi su xa ^kundaa va ini Jesús, ña kuni ndia kotondoso ndia ra, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ndia chiꞌña tuꞌun va kuvi ndo, saa chi yuꞌu va kuvi ra ixtondoso ndo. ");
INSERT INTO mxv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ra vichin na ñaꞌa ndo iin xuꞌun kàà ña chaꞌvi ndo nuu yu ―kachi ra xiꞌin ndia. Ra saa taxi na iin xuꞌun kàà ña nani denario ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ra saa nindakatuꞌun ra ndia kachi ra saa: ―¿Yoo naꞌna ke yoꞌo, ra yoo kivi ke nduꞌu nuu ña? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ra saa ndakuiin ndia kachi ndia saa: ―Naꞌna ra César va kuvi ña ―kachi ndia. Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Tu saa, ra taxi ndo ña kuu kuenda ra César ndaꞌa va ra, ra ña kuu kuenda Ndioxi na taxi tu ndo ndaꞌa Ndioxi va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ra te xini soꞌo ndia ña ndikaꞌan ra tuꞌun kan, saa ra ndakanda ni ini ndia, ndia saa ra ndakoo ndia ra, ra ndakiꞌin ndia kuaꞌan va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ra suvi mii kii kan ndixaa sava ndia saduceo nuu Jesús, ra nindakatuꞌun ndia ra, a ndixa ke ndatiaku na ndi̱ì, chi ndia saduceo kan, ra kuëe kandixa ndia ña ndatiaku na ndi̱ì, ña kan ke nindakatuꞌun ndia Jesús kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tata Maestro, ndiayu ña ndakoo ra Moisés ndaꞌa ndi, ra suꞌva va ke kachi ña: “Tu ndia iin tiaa ra iyoo yasiꞌi, ra ndikäku seꞌe ra xiꞌin ña, ra ndixiꞌi va ra, saa ra xiniñuꞌu na ndakiꞌin inka ñani ra ñaꞌa kan, ra ta xa na kaku seꞌe ra xiꞌin ña, ra ta iyoo seꞌe ra ndixiꞌi kan va, na koo ña kaku kan”, kachi ndiayu ña ndakoo ra Moisés. ");
INSERT INTO mxv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ra ndakani nuu ndi vichin ra na kundaa ini ndi, chi suꞌva ke kuu xiꞌin iin veꞌe: Uxa tiaa xikuu ndia veꞌe ndia. Ra saa kuu ra nditandaꞌa va ñani ndia ra chee, ra ndia nii seꞌe ra ndikäku xiꞌin yasiꞌi ra, ra ndixiꞌi va ra; saa ra ndakiꞌin ña inka ñani va ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ra saa ndoꞌo tu ra uvi kan va, chi ndia nii seꞌe ra ndikäku xiꞌin ña, ra ndixiꞌi tu ra kan va, ra saa ndakiꞌin ña inka tuku va ra, ra ndixiꞌi tu ra uni kan va, ra uxa saa ndia xinduꞌu ña xiꞌin va, ra ndia nii ndia ndikäku seꞌe xiꞌin ña, ra ndixiꞌi ndiꞌi va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Saa ra te ndiꞌi, ra ndixiꞌi tu mii ñaꞌa kan va. ");
INSERT INTO mxv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ra ña kan ke kuni ndi ndakatuꞌun ndi yoꞌo: Te na ndatiaku ndia kan, ¿ra yoo kuvi ndia kuu yii ña?, saa chi xinduꞌu ña xiꞌin uxa saa va ndia ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ndo yaꞌa xini va kuvi ndo, saa chi xa xïni ndo ni ke kachi tuꞌun Ndioxi, ra xa xïni tu ndo xaꞌa ndiee va ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Saa chi te na xaa kii ña ndatiaku na ndixiꞌi, ra tiaa xiꞌin na siꞌi ra tandäꞌa ka na, chi xa ta iyoo mii na tatun Ndioxi, na iyoo ndivi va nduu na. ");
INSERT INTO mxv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ra ña kaꞌan tu ndo a ndixa ke ndatiaku na ndi̱ì, ra nuu ndiayu ña ndakoo ra Moisés va ke ndakani ña xaꞌa ña, ¿ra a käꞌvi va ndo ña tu saa? Ra na kundaa ini ndo chi suꞌva va ke kachi Ndioxi ndikaꞌan ra: ");
INSERT INTO mxv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yuꞌu kuvi Ndioxi ra ^kañuꞌu ra Abraham, xiꞌin ra Isaac, xiꞌin ra Jacob”, kachi ra. Ra xiꞌin tuꞌun yoꞌo ke kundaa ini yo ña ndatiaku va ndia xii xikua yo yoꞌo, saa chi tu ndindatiäku ndia saa ra küvi vi ^kañuꞌu ndia Ndioxi ―kachi Jesús xiꞌin ndia saduceo kan. ");
INSERT INTO mxv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ra te xini soꞌo yuvi na ndee kan, ña ndichi ni ^sañaꞌa Jesús, saa ra ndakanda ni ini na. ");
INSERT INTO mxv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ra saa te kundaa ini ndia fariseo ña sakutaxin Jesús yuꞌu ndia saduceo kan, ra saa ndakutaꞌan tuku va ndia ña ndikataꞌan ndia, ");
INSERT INTO mxv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ra saa nindakatuꞌun iin ra maestro ra sañaꞌa ndiayu Ndioxi Jesús, ña kuni ra kotondoso ra ra, ra saa ndikaꞌan ra xiꞌin ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tata Maestro, ¿nuu ndiayu Ndioxi ña ndakoo ra Moisés, ra ndia ña kuu ndiayu ña chee vaꞌa ka nuu takundiꞌi ña? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ndiayu ña kaꞌnu vaꞌa ka nuu takundiꞌi ña ke yoꞌo: “Kuꞌvi ni ini kun kuni kun Tata kun Ndioxi xiꞌin takundiꞌi nima kun, xiꞌin takundiꞌi ña tiaku kun, xiꞌin takundiꞌi ña xinituni kun.” ");
INSERT INTO mxv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ra ña yoꞌo ku ndiayu ña nuu vaꞌa va, ra ña yoꞌo ke chee nuu takundiꞌi va tu ña. ");
INSERT INTO mxv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ra ndiayu ña uvi ku tu ña yoꞌo, ra kuni kitaꞌan va ña xiꞌin ndiayu ña nuu: “Kuꞌvi ni ini kun kuni kun na taꞌan kun, ta kuꞌva kuꞌvi ini kun xini kun mii kun”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ra uvi saa ndiayu yoꞌo kuvi ña kuu tioꞌo takundiꞌi va ndiayu Ndioxi ña ndakoo ra Moisés, ra kuu tu ña tioꞌo ña sañaꞌa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ra saa kúú ndia fariseo kan itaꞌan ndia ndita ndia, ra saa nindakatuꞌun Jesús ndia, ");
INSERT INTO mxv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","kachi ra saa: ―¿Ndixaa tuvi ndoꞌo xaꞌa ra tiꞌvi Ndioxi xaa sakaku na yuuvi yoꞌo? ¿Ra yoo seꞌe ku ra tuvi ndo? ―kachi Jesús xiꞌin ndia. Ra saa ndakuiin ndia kachi ndia saa xiꞌin ra: ―Seꞌe ra David va kuvi ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Tu saa, ¿ra nichuun ke ndikaꞌan David ña kuu Iva ra, ra kixi kan? Te ndikaꞌan ra xiꞌin ndiee Tachi Yii Ndioxi, ta kachi ra suꞌva: ");
INSERT INTO mxv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Suꞌva kachi Tata yu Ndioxi xiꞌin Iva yu: Naꞌa, kunduꞌu kun xitia kuaꞌa yu, ra na sandiꞌi yu xaꞌa takundiꞌi na iyoo kuachi xiꞌin kun, kachi Ndioxi ndikaꞌan ra, kachi ra David. ");
INSERT INTO mxv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’Ra tu “Iva” va tu ra David kachi ra xiꞌin ra tiꞌvi Ndioxi xaa, saa ra, ¿ni ke sa tu ra ña kuu seꞌe ra ra? ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Saa ra ndia nii ka tuꞌun ninïꞌi ndia ndakuiin ndia yuꞌu ra. Ra ndia kii kan ke ndixkuiin na ña nindäkatuꞌun ka na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ra saa ndikaꞌan Jesús xiꞌin yuvi na ndee kan, ra ndikaꞌan tu ra xiꞌin ndia itaꞌan xiꞌin ra va ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin ndia fariseo, ra xini vaꞌa va ndia kan ni ke kachi tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ña kan ke, na kandixa va ndo takundiꞌi ña sañaꞌa ndia ndoꞌo, ndi su na kundïkun ndo chiñu kiꞌvi ña xa ndia, chi ndia kan, ra siin sañaꞌa ndia, ra siin tu xa va ndia. ");
INSERT INTO mxv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ra kuaꞌa ni chiñu ña ndaku, ña uꞌvi ni xaꞌndia ndia nuu yuvi sa na, ndi su mii tu ndia, ra ndia nii chiñu loꞌo ña kaꞌan ndia xaꞌa ke xä vi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ra takundiꞌi chiñu ña xa ndia, ra süvi ña xatoꞌo ndia Ndioxi ke xa ndia ña, chi ña kuni ndia kindoo vaꞌa ni ndia nuu na ñuu va ke xa ndia ña. Ra xaꞌa ña kan ke iin niꞌi savi ndia tutu ña ndoso tuꞌun Ndioxi nuu xika ndia, ra ndia nuu tikoto ndia xiꞌin tiaan va ndia ndee tuꞌun Ndioxi xika ndia, ra xinisii ni tu ndia kundixi ndia tikoto ña nani ni iꞌva yuꞌu va ña vaꞌa na kuni yuvi ra kaꞌan na xaꞌa ndia, ña ndinuni ni ndikun ndia Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ra te kuaꞌan ndia nuu iyoo viko, a te kuaꞌan tu ndia veꞌe ñuꞌu, ra kutoo ni ndia kundee ndia tiayu tu ndita chi nuu, nuu ndee na kunaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ra kuni ni tu ndia ña na satoꞌo yuvi ndia, te ndakutaꞌan na xiꞌin ndia nuu yaꞌvi, ra “maestro” ke na kachi yuvi xiꞌin ndia kuni ndia. ");
INSERT INTO mxv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ndi su ndoꞌo ra ndiätu ndo ña kaꞌan na “maestro” xiꞌin ndo, saa chi ndoꞌo ra iin kuvi va ndo xiꞌin takundiꞌi yuvi, ra indaa mituꞌun va kuu Cristo ra kuu Maestro ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ra ndia nii tu na, na käꞌan ndo “tata” xiꞌin nuu ña yuuvi yoꞌo, chi indaa mituꞌun va kuvi Tata yo Ndioxi ra iyoo ndivi. ");
INSERT INTO mxv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ra nii täxi tu ndo ña kaꞌan na “maestro” xiꞌin ndo, saa chi indaa mituꞌun va kuu Cristo ra kuu Maestro. ");
INSERT INTO mxv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ra na kuchee inuu nuu ndo, ra xiniñuꞌu na sachiñu na nuu takundiꞌi va ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Saa chi yuvi na ndasa chee ni mii, kuvi na nduu loꞌo va, ra na ndasa loꞌo mii kuvi tu na nduchee ka va. ");
INSERT INTO mxv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Ra ndaꞌvi ni ndoꞌo, ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra ndasi ndo yeꞌe ña kuu ichi nuu xaꞌndia Ndioxi chiñu, ra täxi ndo kiꞌvi yuvi, ra nii mii tu ndo xïin kiꞌvi va, ra na kuni kiꞌvi, ra nii täxi tu ndo kiꞌvi na kan va. ");
INSERT INTO mxv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Ndaꞌvi ni ndoꞌo, ndia maestro ndia sañaꞌa ndiayu Ndioxi, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra sandaꞌvi ni tu ndo na siꞌi ndaꞌvi na ndukuaan va, chi kindiaa ndiꞌi ndo ñaꞌa ña iyoo veꞌe na ndaꞌa na, ra ña kuni ndo kindoo vaꞌa ndo nuu na ñuu, ra naꞌa ka vi kaꞌan ndo xiꞌin Ndioxi. Ra xaꞌa ña xa ndo ña yoꞌo ke chee ni ka tundoꞌo vaxi nuu ndo sa Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Ndaꞌvi ni ndoꞌo, ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra kee ndo kuaꞌan ndo iinii kuvi nuu ñuꞌu, ra ndia nuu tiañuꞌu va yaꞌa ndo kuaꞌan ndo ña nduku ndo na kundikun sata ndo, ra te niꞌi ndo na, ra na ndiee ka sandiꞌi ndo xaꞌa va kuvi na, saa chi na ndasa ñaꞌa va ndo kuvi na, ra ndiaya ke kuꞌun va na, xaꞌa ña xa ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Ndaꞌvi ni ndoꞌo, saa chi ta kuꞌva iyoo na kuaa va ke iyoo ndo, ra niꞌi tu ndo ichi nuu inka na kuaa va, saa chi kaꞌan ndo xiꞌin yuvi kachi ndo saa: “Tu veꞌe ñuꞌu kaꞌnu ke na chunaꞌa na ña kindoo na sa na iin chiñu, saa ra kuni kachi ña saa ña köo ña ndikindoo vi na, ndi su tu oro ña iyoo ini veꞌe ñuꞌu kaꞌnu va ke na chunaꞌa na, saa ra xiniñuꞌu na saxinu va na nuu ña kindoo na sa na”, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ndoꞌo, ra na kiꞌvi va kuvi ndo, ra kuaa va tu ndo! ¿Ndia ña ke xiniñuꞌu vaꞌa ka tuvi ndo: a oro, a veꞌe ñuꞌu kaꞌnu, ña ndasa yii oro kan va? ");
INSERT INTO mxv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ra kaꞌan tu ndo kachi ndo suꞌva va xiꞌin yuvi: “Tu Altar yii ke na chunaꞌa na ña kindoo na ña sa na iin chiñu, saa ra kuni kachi ña saa, ña köo vaꞌa ña ndikindoo vi na sa na; ndi su tu ñaꞌa ña ñuꞌu ña soko na nuu altar yii ini veꞌe ñuꞌu va ke na chunaꞌa na ña kindoo na sa na iin chiñu, saa ra xiniñuꞌu na saxinu va na ña kindoo na sa na”, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ndoꞌo, ra kuaa ndo, ra kiꞌvi ni va tu ndo, saa chi ¿ndia ña ke xiniñuꞌu vaꞌa ka tuvi ndo, ñaꞌa ña soko na, a mii altar yii, nuu kuaꞌan ña nduyii va ña? ");
INSERT INTO mxv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ra na chunaꞌa altar yii, ña kindoo na sa na iin chiñu ra süvi takua altar yii ke chunaꞌa na ña kindoo na sa na ña, chi chunaꞌa tu na takundiꞌi ñaꞌa, ña iyoo nuu altar yii kan va. ");
INSERT INTO mxv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ra na chunaꞌa tu veꞌe ñuꞌu kaꞌnu ña kindoo na ña sa na iin chiñu, saa ra süvi takua veꞌe ñuꞌu kaꞌnu ke chunaꞌa na ña kindoo na sa na ña, chi chunaꞌa tu na Ndioxi ra iyoo ini va ña. ");
INSERT INTO mxv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ra na chunaꞌa ndivi ña kindoo na sa na iin chiñu, ra süvi takua ndivi ke chunaꞌa na ña kindoo na sa na ña, chi chunaꞌa tu na Ndioxi va, ra saa tu tiayu tun nduꞌu va ra. ");
INSERT INTO mxv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Ndavi ni ndoꞌo, ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, chi ña xa ndo ke tava va ndo iin taꞌvi loꞌo ñaꞌa ña chiꞌi ndo tixi uxi taꞌvi takundiꞌi ñaꞌa, ña chiꞌi ndo, ra taxi ndo ña ndaꞌa Ndioxi, ndi su naa va ini ndo ña saxinu ndo ndiayu Ndioxi ña xiniñuꞌu vaꞌa ka, ña kaꞌan kachi saa: na satoꞌo ndo na taꞌan ndo, na kuꞌvi ini ndo kuni ndo na, ra na kandixa vaꞌa tu ndo Ndioxi va; ra na taxi tu ndo iin taꞌvi loꞌo nuu uxi taꞌvi ñaꞌa ña chiꞌi va ndo, ra na kukuïin vi ndo ña sa ndo ña kan. ");
INSERT INTO mxv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ndoꞌo, ra na kuaa, na inuu ichi nuu na kuaa va kuvi ndo, saa chi te xiꞌi ndo ndia ndia ka ndutia, ra saxixin va ndo ra ña vaꞌa na köko ndo ndikama vali, ndi su xïni vi ndo, ra koko va tu ndo iin camello chee. Ra na kundaa ini ndo ña kaꞌan yu suꞌva xiꞌin ndo, saa chi, niña chiñu vali va ke ndiꞌi ni ini ndo xaꞌa, ra ndiayu Ndioxi ña xiniñuꞌu vaꞌa, ndakoo va tu ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Ndaꞌvi ni ndoꞌo ndia Maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra te ndakatia ndo koꞌo xixi ndo, a yaxin ña xiꞌi ndo tiakuii, ra niña chi sata va ña ke ndakatia ndo, ndi su chi ini ña, ra iin chitu ndaa va ña yakua. Ra ta kuꞌva xa ndo xiꞌin ña yoꞌo ke, iyoo tu mii va ndo, saa chi toꞌo ni va xa ndo, ndi su nima ndo ra iin chitu ndaa va ña xiꞌin ña kuiꞌna xiꞌin ña kini. ");
INSERT INTO mxv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ndoꞌo, ndia fariseo kuaa, ra xiꞌna ka va chi ini yaxin ndo xiꞌin ini koꞌo ndo ke na ndakatia ndo, ra saa ke kindoo vaꞌa tu ndia chi sata va ña. ");
INSERT INTO mxv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Ndaꞌvi ni ndoꞌo, ndia maestro sañaꞌa ndiayu Ndioxi xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra ta iyoo kaka na ndii va ke iyoo ndo, saa chi kaka na ndii, ra chi sata va ña ke ndakaꞌyu na, ña yaa, ra sa̱ví ka vi ñaꞌa ña, ndi su chi ini ña, ra iin chitu ndaa va leke ndii, xiꞌin takundiꞌi ña kini. ");
INSERT INTO mxv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ra ta kuꞌva iyoo kaka na ndii kan va ke iyoo tu ndoꞌo va, saa chi toꞌo ni va xa ndo nuu yuvi, ndi su nima ndo, ra iin chitu ndaa va ña xiꞌin tuꞌun chiꞌña xiꞌin ña ndivaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Ndaꞌvi ni ndoꞌo ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndoꞌo ndia fariseo, saa chi chiꞌña ni tuꞌun ndo, ra täxi vaꞌa vi ndo, ndiꞌi xaꞌa kaka nuu ndoꞌni na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ra saa xa tu ndo, xiꞌin kaka nuu ñuꞌu na xindikun Ndioxi va, chi savi ka vi ndasa ndo xiꞌin ña, ");
INSERT INTO mxv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ra te ndiꞌi, ^kaꞌan ndo kachi ndo saa: “Tu xa ndee vi yo kii te xindee na xii xikua yo xinaꞌa, saa ra kandïxa vi yo, ña koo yuꞌu yo xiꞌin na, ña kaꞌni na na ndikaꞌan tuꞌun yuꞌu Ndioxi”, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ra xiꞌin tuꞌun ña kaꞌan ndo yoꞌo ke, ndañaꞌa ndo mii ndo ña kuu ndo seꞌe xikua na xaꞌni na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Ra ta kuꞌva xa na xii xikua ndo ke na sa tu ndoꞌo va, ña vaꞌa na saxinu ndo nuu chiñu ña xaꞌa na xiꞌin te yachi! ");
INSERT INTO mxv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ndoꞌo, yuvi ñaꞌa, seꞌe timiaꞌa, ¿ra ni ke sa ndo ña vaꞌa kaku ndo, ra küꞌun ndo ndiaya, tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ra na kundaa ini ndo, chi yuꞌu kuvi ra tiꞌvi na kaꞌan tuꞌun yuꞌu Ndioxi kixi na, xiꞌin na ndichi, xiꞌin na maestro sañaꞌa tuꞌun Ndioxi; ndi su ndoꞌo, ra kaꞌni va ndo sava na, ra sava tu na tiin ndo katakaa ndo ndaꞌa cruz va, ra sava tu na tiin ndo kani ndo nuu keꞌe veꞌe ñuꞌu va, ra sava tu na kundikun ndo taxi ndo ta ñuu ta ñuu va. ");
INSERT INTO mxv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ra xaꞌa ña sa ndo ña yoꞌo ke, ndakuiso kuachi ndo xaꞌa takundiꞌi nii yuvi toꞌo, na xaꞌni na xii xikua ndo xinaꞌa ta kuu ra Abel, iin saa ndia ra Zacarías, seꞌe ra Berequías, ra xaꞌni ndo ini veꞌe ñuꞌu nuu iyoo altar yii. ");
INSERT INTO mxv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ra ña ndaa kaꞌan yu xiꞌin ndo, chi xaꞌa nii na ndixiꞌi kan ke, kixi yaa va tundoꞌo sata ndoꞌo na ndee tiempo vichin ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Saa ndikaꞌan Jesús kachi ra saa: ―¡Kusuchi ni ini yu xaꞌa ndoꞌo na ñuu Jerusalén, saa chi väꞌa vaꞌa vi ^xa ndo, chi xaꞌni ndiꞌi va ndo na kaꞌan tuꞌun yuꞌu Ndioxi, ra xakin tu ndo yuu na tiꞌvi Ndioxi vaxi nuu va ndo! ¡Ra kuaꞌa ni va ichi kuni yu ndakaya ndiꞌi yu ndoꞌo ña sakaku yu ndoꞌo, ta kuꞌva ^xa iin nduxi xiꞌin seꞌe vali ri, ta ndataan ri ri tixi ndixin ri, ra saa ke kuni yu sa yu xiꞌin ndo, ndi su ndixïin ndo! ");
INSERT INTO mxv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ra xaꞌa ña kan ke niꞌi ndo tundoꞌo vichin, saa chi veꞌe ndo, ra ndoo ndaꞌa ndiꞌi va ña, ");
INSERT INTO mxv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ra kuni yu ña na kundaa ini ndo, chi vichin, ra küni yachi ka ndo yuꞌu, chi ndia te na xaa kii, ña kaꞌan na ñuu yoꞌo xiꞌin yu kachi na saa: “¡Kaꞌnu ni ra xaa sakaku yoo xiꞌin kivi Tata yo Ndioxi ra iyoo ndivi!”, kachi na, ra ndia saa vi ke kuni ndo yuꞌu ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ra saa te kanata Jesús ini veꞌe ñuꞌu kaꞌnu, ra ndakiꞌin ra kuaꞌan ra, ra saa kuyachin ndia itaꞌan xiꞌin ra, ra ndikaꞌan ndia xiꞌin ra xaꞌa veꞌe ñuꞌu kaꞌnu kan, ña chee ni ña, ra iyo ni kaa ña. ");
INSERT INTO mxv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A tiaa ni iyo kaa veꞌe ñuꞌu chee yoꞌo tuvi ndo? Ra na kundaa ini ndo chi ña ndaa va ke kaꞌan yu xiꞌin ndo vichin, chi vaxi kii ra ña ndiꞌi xaꞌa va kuvi ña, ra yuu ña kuvaꞌa ña, ra iin kutia yava va ña kundee ña ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ra saa ndakiꞌin ndia kuaꞌan ndia iku ña nani Olivo, ra ikan ndixaa Jesús ndakunduꞌu ra, ra saa kuyachin ndia itaꞌan xiꞌin ra, ra nindakatuꞌun ndia ra kachi ndia saa: ―Tata, kuni ndi ña na ndatuꞌun kun xiꞌin ndi, ¿ama ke kuu ndiꞌi ña ndikaꞌan kun? ¿Ra ni ke kuu kuni ndi ta xa ninumi ndiko kun kixi kun? ¿Ra ni ke sa tu ndi kundaa ini ndi ta xa ninumi ndiꞌi xaꞌa ña yuuvi yoꞌo? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Kuenda ni koo ndo, koto ndia na sandaꞌvi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi kuaꞌa ni na kixi ra kuniñuꞌu na kivi yu ña sandaꞌvi na yuvi, ra kachi na saa: “Yuꞌu ku Cristo ra xaa sakaku na yuuvi yoꞌo”, kachi na, ra kuaꞌa ni yuvi sandaꞌvi na. ");
INSERT INTO mxv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ra te xa na xaꞌa kuni soꞌo ndo ña xa iyoo ni kuachi ra xaꞌa kuni soꞌo ndo ña kanitaꞌan ni yuvi saa ra kuayüꞌvi ndo, chi xiniñuꞌu saa ke kuu va. Ndi su süvi ña xa ndiꞌi xaꞌa kuvi ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ra kuaꞌa ni ñuu ra kanitaꞌan ni ña xiꞌin taꞌan ña, ra saa tu ñuu ña kunaꞌnu va, chi kanitaꞌan ni tu ña kan va xiꞌin taꞌan ña; ra kuaꞌa ni nuu kueꞌe kixi, ra kundikaa ni soko, ra kuaꞌa ni ñuu ndiee ni taan. ");
INSERT INTO mxv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ndi su süvi ña ndikun ndiꞌi xaꞌa kuvi ña yuuvi yoꞌo, chi ña sakan xaꞌa va kuvi tundoꞌo ña satixuꞌvi ña na. ");
INSERT INTO mxv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ra kii kan tiin na ndoꞌo, ra ndataxi na ndoꞌo ndaꞌa na chiñu ra sandivaꞌa ni na xiꞌin ndo; ra kaꞌni na ndoꞌo, ra kundasi takundiꞌi na yuuvi yoꞌo ndoꞌo, xaꞌa ña ndikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ra te xa na xaa kii kan, ra kuaꞌa ni na ndikun yuꞌu, ra nandiko va ini na, ra kundïkun ka na yuꞌu; ra xaꞌa na kundasi taꞌan mii va na, ra xiko taꞌan mii va tu na nuu na chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ra kii kan ra kuaꞌa ni na maña, na xa kaꞌan tuꞌun yuꞌu Ndioxi kixi sandaꞌvi yuvi, ra kuaꞌa ni yuvi sandaꞌvi na. ");
INSERT INTO mxv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ra xaꞌa ña nduu ikú ni yuvi ke kuaꞌa ni na ndi̱kò, ra küꞌvi ka ini na kuni taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ra na kuchuun sa ndiee ini ndia kii ndiꞌi, ra ndïko ini na ña ndikun na yuꞌu, ra na kan ku vi na kuchuun kaku va. ");
INSERT INTO mxv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ra iinii saa ña yuuvi yoꞌo kaꞌan ndoso na ndikun yuꞌu, tuꞌun Ndioxi ña kaꞌan xaꞌa ichi nuu xaꞌndia ra chiñu, ña vaꞌa na kundaa ini takundiꞌi na xaꞌa ña, ra saa vi ke ndiꞌi xaꞌa ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ra vichin ke na kundaa ini ndo, chi vaxi kii ra kanata kiti ñaꞌa ri kundasi Ndioxi xini ra. Ra ri kan kuvi ri ndikaꞌan ra Daniel xaꞌa. Ra ta xa na kuni ndo kiti kan ña ndakunduꞌu ri nuu yii, ra saa ke kundaa ini ndo ña xa xaa kii ña vaxi tundoꞌo va ―na ^kaꞌvi, ra na kundaa ini na xiꞌin ña kaꞌvi va na―, ");
INSERT INTO mxv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ra na ndee Judea, ra na kunu na kuꞌun na chi iku va. ");
INSERT INTO mxv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ra na ndee tu chi xini veꞌe, ra na kïꞌvi ka na veꞌe na, ña ndakiꞌin na ñaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ra na ñuꞌu xachiñu iku, ra na ndïko ka na veꞌe na ña ndakiꞌin na tikoto na. ");
INSERT INTO mxv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ra ndaꞌvi ni na siꞌi na ñuꞌu seꞌe, xiꞌin na iyoo seꞌe vali, te na xaa kii ña kuu ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ña kan ke na kaꞌan ni ndo xiꞌin Ndioxi, ra te xa na kuu saa, ra na küu ña yoo te kuun savi, xiꞌin ni kii yii sábado kii ndakindiee. ");
INSERT INTO mxv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ra tundoꞌo kaꞌnu ña kuu kii kan, ra ndia te xavaꞌa Ndioxi ña yuuvi yoꞌo, ra täan kuu ña, iin saa ndia vichin, ra nii kii ña vaxi küu ka ña. ");
INSERT INTO mxv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ra tu kuëe ndixaꞌndia Ndioxi tiempo yoꞌo ña ndasa loꞌo ra ña, saa ra ndia nii yuvi kuvi na käku vi, ndi su xaꞌa na ndikun sata ra na ndikaxin ra ke kaꞌndia ra tiempo yoꞌo ra nduloꞌo va kii. ");
INSERT INTO mxv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ra kii kan ndakoyo sava yuvi kaꞌan na xiꞌin ndo kachi na saa: “Kotoꞌni ndo, chi kaa iin ra tiꞌvi Ndioxi xaa sakaku yoo”, kachi na; ra kaꞌan tu na kachi na saa: “Kaa va iin ra”, kachi na xiꞌin ndo, ndi su na kandïxa ndo ña kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi kuaꞌa ni na maña kixi ra kachi na saa: “Yuꞌu ku Cristo”, a “Yuꞌu kuvi ra kaꞌan tuꞌun yuꞌu Ndioxi”, kachi na. Ra kuaꞌa ni ña ndichi xiꞌin ña xituꞌun sa na, ña sandaꞌvi na yuvi, ra kusana ndia na xa ndikaxin Ndioxi kundikun ichi va ra kuni na sandaꞌvi na. ");
INSERT INTO mxv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ña kan ke xa kaꞌan ndiꞌi va yu ña yoꞌo xiꞌin ndo vichin, ra na kiꞌin ni ndo kuenda xiꞌin mii ndo. ");
INSERT INTO mxv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ra te na kaꞌan na xiꞌin ndo kachi na saa: “Kuaꞌan ndo kuni ndo, chi iku kaa iin ra tiꞌvi Ndioxi xaa sakaku yoo”, kachi na; ra na kandïxa ndo kuꞌun ndo. Ra tu na kaꞌan tu na xiꞌin ndo kachi na saa: “Naꞌa ndo, ra kuni ndo chi ini veꞌe yoꞌo iin ra tiꞌvi Ndioxi xaa sakaku yoo”, na kachi na xiꞌin ndo, saa ra na kandïxa ndo na. ");
INSERT INTO mxv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Saa chi kii na nandiko yuꞌu ra xaa yoꞌo vichin ra iin ta kuꞌva xa taxa ta ndayeꞌe ña chi nuu kanata ñuꞌu ra iin saa ndia chi nuu kita ña, saa ke kuu, saa chi kuni takundiꞌi va na yuuvi yoꞌo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ra xa kundaa va tu ini ndo, chi ndia ndia ka mii nuu ndee kiti ndìì, ra ikan ke ndakutaꞌan pilo ndee va ri ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ra te xa na ndiꞌi suꞌva kuu tundoꞌo kaꞌnu kan, saa ra kuñaa nuu ñuꞌù kaa, ra nii yoo kaa ra ndayëꞌe ka ri, ra kimi ri ndee nuu ndivi kaa, ra koyo ndiꞌi va ri, ra takundiꞌi ñaꞌa ña ndee nuu ndivi kaa ra ndakanda ndiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ra saa kuni takundiꞌi na ña kuu nuu ndivi, ña taxi kuꞌva nuu na ña xa kuyachin ni ndiko tuku yuꞌu, ra xaa yoꞌo kixi yu. Ra te xa na kuni takundiꞌi na ñuu yuuvi yoꞌo yuꞌu, ña kee yu ndivi vaxi yu iin nuu viko xiꞌin takundiꞌi ndiee yu ña kaꞌnu, saa ra yuꞌvi ni na ra kuaku ni na. ");
INSERT INTO mxv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ra tiꞌvi yu na tatun yu kuꞌun na kumi saa tutun ña yuuvi, ra kuniꞌi na itun tivi na, ña ndakaya na na ndikaxin yu koo xiꞌin yu ndivi, na ndee chi nu kanata ñuꞌu, ra iin saa ndia nuu kita ña. ");
INSERT INTO mxv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ra na kutuꞌva ndo tuꞌun ndichi xaꞌa itun koxi: Te xa xaꞌa nduu itia ndaꞌa nu, ra xaꞌa ndukuii nu, ra saa ke xa kundaa ini ndo ña xa kuyachin tiempo savi va. ");
INSERT INTO mxv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ra kuꞌva saa ke iyoo tu ña yoꞌo va, saa chi te xa na kuni ndo ña xaꞌa kuu takundiꞌi ña yoꞌo, saa ra kuni kachi ña saa, ña xa ninumi ndiko tuku va yu. ");
INSERT INTO mxv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi yuvi na ndee vichin ra ndee ka va na nuu ña yuvi yoꞌo, te na kuu takundiꞌi ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","’Ndivi kaa xiꞌin ñuꞌú yoꞌo, ra ña ndiꞌi xaꞌa va kuvi ña, ndi su tuꞌun yu ra ndïꞌi xaꞌa ña, chi xinu ndiꞌi va ña kaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ra ndia nii na kundäa ini ndia kii ke, ra ndia hora ke ndiko yu, chi ndia nii na tatun Ndioxi na iyoo ndivi ra kundäa ini na; ra nii yuꞌu, ra xaa yoꞌo, kundäa ini; chi indaa mituꞌun iva va yu kuvi ra xini ama ke kuu saa. ");
INSERT INTO mxv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ra na kundaa ini ndo, chi ta kuꞌva kuu xinaꞌa, te ndixiyo ra Noé va ke kuu, kii te na ndiko yuꞌu ra xaa yoꞌo, ");
INSERT INTO mxv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","saa chi te xitiaku ra Noé, te täan kuun savi ñaꞌa, ra yuvi kan, ra ndakundiee na xixi na, ra xiꞌi na, ra satandaꞌa taꞌan va tu na, ra saa kuu na ndee na saa, ndia te ndixaa kii ndikiꞌvi ra Noé ini barca va. ");
INSERT INTO mxv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Saa chi nindakäni ini vi na ña ndiꞌi xaꞌa ña yuuvi, ra saa kuu na ndee na saa, ndia te xaꞌa kuun ñaꞌa savi ra xaꞌni ndiꞌi va ra na. Ra kuꞌva saa ke kuu tu te xa na ndiko yuꞌu ra xaa yoꞌo vichin va. ");
INSERT INTO mxv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chi kii kan, ra tu ñuꞌu uvi tiaa xachuun ndia iku, ra iin ra kuꞌun xiꞌin yu, ra iin ra ndoo va. ");
INSERT INTO mxv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ra tu xika tu uvi na siꞌi, ndiko ná, ra iin ña kuꞌun xiꞌin yu, ra iin ña ndoo va. ");
INSERT INTO mxv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ña kan ke na kiꞌin ni ndo kuenda, chi kundäa ini ndo ama ke ndiko yuꞌu, ra kuu Iva ndo kixi yu. ");
INSERT INTO mxv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ra na kundaa ini ndo ña yoꞌo, saa chi tu iin ra tata, ra iyoo iin veꞌe ra, ra na kundaa ini ra ama ke kiꞌvi ra kuiꞌna ña sakuiꞌna ra ñaꞌa veꞌe ra, saa ra küsun vi ra, chi kunduꞌu va ra kondiaa ra, ra täxi vi ra kiꞌvi ra kuiꞌna kan ña sakuiꞌna ra ñaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ra kuꞌva saa ke na sa tu ndoꞌo va, ña na koo nduvi ni ndo; saa chi yuꞌu ra xaa yoꞌo, ra kii te kuëe ndiatu ndo yuꞌu va ke ndiko yu kixi yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ná ndatuꞌun yu xiꞌin ndo ndia kuꞌva ke iyoo iin ra xachiñu tatu ra toꞌo ni, ra ndichi ni ra. Ra na kundaa ini ndo chi ra kan kuvi ra ndakiꞌin ndiayu ña kiꞌin ra kuenda xiꞌin veꞌe ra kuu xitoꞌo ra, ña vaꞌa taxi ra ña kuxi takundiꞌi na xachiñu tatu nuu ra kuu xitoꞌo ra, ta mii hora ña kaꞌun ini na. ");
INSERT INTO mxv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ra vaꞌa ni kee ra xachiñu tatun kan, tu iin ta kuꞌva ndikaꞌan ra xitoꞌo ra xiꞌin ra ke, na sa ra, te na nandiko ra kan xaa ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi taxi va ra xitoꞌo ra, ndiayu ndaꞌa ra ña ndakuiso chiñu ra xiꞌin takundiꞌi ñaꞌa, ña kuu mii ra xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ndi su tu ra xachiñu tatu kan, ra ra iku va kuvi ra, ra xaꞌa ra ndakani ini ra kaꞌan ra saa: “Ndïko yachi vi ra xitoꞌo yo”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Saa ra xaꞌa ra sandivaꞌa ra xiꞌin na xachiñu tatu taꞌan ra, na nindoo ndaꞌa ra kiꞌin ra kuenda xiꞌin. Ra ndakutaꞌan ra xiꞌin na xiꞌi, ña kuxi ra xiꞌin na, ra koꞌo ra xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ra kii te kuëe ndiatu ra, te naa ni ini ra, saa ra tuꞌva xaa va ra xitoꞌo ra, ña niꞌi taꞌan ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Saa ra tiaa ni sandivaꞌa ra xitoꞌo ra xiꞌin ra, ra tiin ra ra, ra sakoꞌni ra ra nuu ndoꞌni yuvi ñaꞌa, na chiꞌña tuꞌun. Ra ikan kuu nuu kuaku ni ra, ra iin ndiakua ndakaxi nùꞌù ra ―*kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ta kuꞌva ndoꞌo uxi na siꞌi vali kuaan, saa ke ^kuu, xiꞌin ichi nuu xaꞌndia Ndioxi chiñu. Na siꞌi vali kuaan na uxi kan, ra kiꞌin na ñaꞌa, nuu ñúꞌu ndutia xaꞌan ra kutuun nuu na, ña vaꞌa kuꞌun na ndakiꞌin na ra tandaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ra uꞌun kuvi na ndichi ni, ra uꞌun kuvi tu na kiꞌvi va. ");
INSERT INTO mxv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ra na kiꞌvi kan, ra takua mii ñaꞌa ña ñuꞌu ndutia xaꞌan ña kutuun nuu va na ndakiꞌin na kuaꞌan xiꞌin na, ndi su kuäꞌan ka inka ñaꞌa ña ñuꞌu ndutia xaꞌan ra nandee ka ini ña, xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ndi su na siꞌi na ndichi ni kan, ra ndakiꞌin na ñaꞌa ña ñuꞌu ndutia xaꞌan kutuun nuu na, ra kuaꞌan ka tu inka ñaꞌa ña ñuꞌu ndutia xaꞌan va xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ra saa kuu, ra kukuachi va ra tandaꞌa kan, saa ra kiꞌin maꞌna va na, ra ndikixi ndiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ra saa te kuaꞌan kuu sava ñuu, ra tuꞌva xini soꞌo va na nindaꞌyu yuvi, kachi na saa: “Kee ndo ra ndakiꞌin ndo ra tandaꞌa, chi xa vaxi ra”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ra saa ndakoo takundiꞌi na siꞌi vali kuaan kan, ra xaꞌa na ndasavii na ñaꞌa ña kutuun nuu na. ");
INSERT INTO mxv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ra saa ndikaꞌan na uꞌun, na kiꞌvi kan xiꞌin na uꞌun, na ndichi kan, kachi na saa: “Saniꞌi ndo loꞌo ndutia xaꞌan nduꞌu, saa chi ñùꞌù ndi ra xa kuni ndaꞌva va ña nuu ndi”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ra saa ndakuiin na ndichi ni kan kachi na saa xiꞌin na kiꞌvi kan: “Küvi taxi ndi ra ndaꞌa ndo, saa chi iyo ni ndaꞌva tu ñùꞌù nduꞌu va, ra ña vaꞌa na kumäni ra nuu yo. Ra vaꞌa ka va na kuꞌun mii ndo nuu kiyaꞌvi ra, ra sata ndo ra sachiñu xiꞌin va ndo”, kachi na xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ra nani saa kuu na uꞌun, na kiꞌvi kan, ndoꞌni na ichi kuaꞌan na, ña sata na ndutia xaꞌan ra kutuun nuu na, saa ra xaa va ra tandaꞌa kan, ra na uꞌun, na xa iyoo nduvi kan, ra ndikiꞌvi va na xiꞌin ra ini veꞌe nuu iyoo viko tandaꞌa kan, saa ra ndasi va yeꞌe veꞌe kan. ");
INSERT INTO mxv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ra te ndiꞌi, saa xaa na siꞌi vali kuaan kiꞌvi kan, ra xa ndasi va yeꞌe, ra saa xaꞌa na kana na kachi na saa: “Tata, ndakuña yeꞌe nuu ndi, ndaꞌvi ni ndi”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ra saa ndakuiin ra tandaꞌa kan kachi ra saa: “Küvi, saa chi xïni yu ndoꞌo”, kachi ra xiꞌin na, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ra saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Na kiꞌin ni tu ndoꞌo va kuenda xiꞌin mii ndo vichin, saa chi kundäa ini ndo ndia mii kii ke, ra ndia mii hora ke ndiko yuꞌu ra xaa yoꞌo kixi yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ra saa ndikaꞌan Jesús inka tuku tuꞌun ndichi xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu, ra kuꞌva suꞌva ke ^kuu xiꞌin ña. Ta kuꞌva ndoꞌo iin ra tata, ra ^ndasavii ña kee ra kuꞌun ra inka ñuu xika, ra ndakana ra na xachiñu nuu ra, ra ndataxi ra xuꞌun ra ndaꞌa na ña sachiñu na xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ra iin ra taxi ra uꞌun mil xuꞌun ndaꞌa, ra inka ra taxi ra uvi mil ña ndaꞌa, ra inka ra taxi ra iin mil va ndaꞌa, ra kuꞌva ña kiꞌin ra kuenda kundiee ndia xiꞌin va ke, taxi ra ndaꞌa ndia. Ra te ndiꞌi, saa ra ndakiꞌin ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ra ra nindoo uꞌun mil ndaꞌa, ra ndikun ndakiꞌin ra kan ndixaꞌan ra nduku ra chiñu xa ra xiꞌin va ña, saa ra ndiniꞌi ra inka tuku uꞌun mil siki va ña. ");
INSERT INTO mxv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ra saa xa tu ra nindoo uvi mil ndaꞌa va, ra ndiniꞌi tu ra kan va, inka uvi mil siki ña. ");
INSERT INTO mxv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ndi su ra nindoo iin mil ndaꞌa, ra ña xa ra kan ke, kaan ra yavi, ra chikaa seꞌe va ra xuꞌun ra xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ra saa kuu, ra ndiyaꞌa kuaꞌa va kuiya, ra saa vi nandiko ra xitoꞌo ndia xachiñu tatu kan ndaxaa ra, ra saa xaꞌa ra ndasa yukun ra kuenda xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Saa xaa ra nindoo uꞌun mil ndaꞌa, ra niꞌi siin va ra inka tuku uꞌun mil siki ña xaa ra, ra saa ndikaꞌan ra xiꞌin ra xitoꞌo ra kachi ra saa: “Tata, yoꞌo iyoo uꞌun mil xuꞌun kun ña taxi kun ndaꞌa yu, ra yoꞌo tu iyoo inka uꞌun mil ña ndiniꞌi yu siki va ña”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ra saa ndikaꞌan ra xitoꞌo ra xiꞌin ra kachi ra saa: “Tiaa ni vaꞌa xa kun, ra vaꞌa ni xachiñu kun, chi tiayu ni kun. Saa chi loꞌo va kuu xuꞌun ndakoo yu ndaꞌa kun, ra vaꞌa ni xachiñu kun xiꞌin ña, ra vichin, ra iin chiñu chee vaꞌa ka va ndataxi yu ndaꞌa kun, ra kuayaꞌa chi ini veꞌe ña ndatava kun viko xiꞌin yu”, kachi ra xitoꞌo ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Te ndiꞌi, saa ra xaa tu ra nindoo uvi mil ndaꞌa kan va, ra ndikaꞌan ra xiꞌin ra xitoꞌo ra kachi ra saa: “Tata, yoꞌo iyoo uvi mil xuꞌun kun ña taxi kun ndaꞌa yu, ra yoꞌo tu iyoo inka uvi mil ña ndiniꞌi yu siki va ña”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ra saa ndikaꞌan ra xitoꞌo ra xiꞌin ra kachi ra saa: “Tiaa ni vaꞌa xa kun, vaꞌa ni xachiñu kun, ra tiayu ni kun, saa chi loꞌo va kuu xuꞌun ndakoo yu ndaꞌa kun, ra vaꞌa ni xachiñu kun xiꞌin ña. Ra vichin, ra iin chiñu chee vaꞌa ka va ndataxi yu ndaꞌa kun, ra kuayaꞌa chi ini veꞌe ña ndatava kun viko xiꞌin yu”, kachi ra xitoꞌo ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ndi su te xaa ra, ra nindoo iin mil ndaꞌa kan, ra saa ndikaꞌan ra xiꞌin ra xitoꞌo ra kachi ra saa: “Tata, xa xini va yu ini kun, chi yoꞌo ra tiaa ni ndaku ini kun, chi nii ña ndixäꞌan kun chiꞌi va kun, ra kuaꞌan kun sakee va kun ña, ra ndakaya kun kuiꞌi nuu ndixäꞌan kun ndataan kun itun kuiꞌi va. ");
INSERT INTO mxv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ra xaꞌa ña kan ke ndiyuꞌvi va yu, ra vaꞌa ka ndixaꞌan yu kaan yu iin yavi nuu ñuꞌu, ra chikaa seꞌe va yu xuꞌun kun, ra vichin, ra yoꞌo iyoo xuꞌun kun, ra ta iyoo ña taxi kun ndaꞌa yu, ra saa iyoo ña ndakiꞌin va kun”, kachi ra xiꞌin ra xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ra saa ndakuiin ra xitoꞌo ra kachi ra saa xiꞌin ra: “Yoꞌo, ra ndikuchïñu ña vivii sa chiñu kun, ra ra kiꞌvi va kuvi kun, saa chi xuxan ni kun, ra tu xa kundaa va ini kun ña sakee yu nuu ndixäꞌan yu chiꞌi yu, ra ndakaya yu kuiꞌi nuu ndixäꞌan yu ndataan yu itun kuiꞌi va, ");
INSERT INTO mxv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ra, ¿a väꞌa ndixaꞌan kun taxi kun loꞌo xuꞌun yu ndaꞌa na sakuaꞌnu xuꞌun? Ra te xa ndaxaa yu vichin, ra xa ndakiꞌin va yu xuꞌun yu xiꞌin siki ña, ña niꞌi yu”, kachi ra xitoꞌo ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ra saa ndikaꞌan ra xitoꞌo ra xiꞌin na ndee kan kachi ra saa: “Ndakiꞌin ndo xuꞌun, ña mil ñaa ndaꞌa ra, ra ndataxi ndo ña, ndaꞌa ra xa iyoo uxi mil nuu. ");
INSERT INTO mxv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Saa chi na xa iyoo kuaꞌa ñaꞌa nuu, ra niꞌi kuaꞌa ka va na ña, ra kuaꞌa vaꞌa ka nduu ñaꞌa va na, ra na köo ña nuu, ra ndia ña loꞌo xa iyoo nuu na ke nundiaa ndaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ra ra ndikuchïñu vivii sa chiñu, ra kuu ra kiꞌvi yoꞌo, ra tiin ndo ra, ra sakoꞌni ndo ra chi keꞌe, chi nuu ñaa, ra ikan ku nuu kuaku ni ra, ra iin ndiakua ndakaxi nùꞌù ra”, kachi ra xitoꞌo ra xaꞌa ra ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Te na ndiko yuꞌu ra xaa yoꞌo, kixi yu xiꞌin takundiꞌi ndiee yu, ra kixi takundiꞌi tu na tatun va yu xiꞌin yu, ra saa ke ndakunduꞌu yu tiayu kaꞌnu ña kaꞌndia yu chiñu. ");
INSERT INTO mxv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ra kii kan ke ndakaya takundiꞌi na yuuvi yoꞌo, ña xaa na nuu yu, ra ndakaxin yu na, ta kuꞌva ^xa iin ra ndiaa kiti, ta ndakaxin ra ndikachi vali sana ra, tiañu tixuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ra chi ndaꞌa kuaꞌa yu ke chindee yu ndikachi, ra chi ndaꞌa ichin yu ke chindee yu tixuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ra te ndiꞌi, saa kaꞌan yuꞌu, ra kuu Rey, xiꞌin na chindee yu chi ndaꞌa kuaꞌa yu, ra kachi yu saa xiꞌin na: “Ndoꞌo, na ndiniꞌi ña vaꞌa nuu Tata yu Ndioxi, ra kuayaꞌa ndo vichin, ña ndakiꞌin ndo nuu kundee ndo ndivi yoꞌo, chi yoꞌo ke xa iyoo ndúvi xaꞌa ndoꞌo, te kuvaꞌa ña yuuvi vi. ");
INSERT INTO mxv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Saa chi te ndikaꞌun ini yu, ra taxi va ndo ña xixi yu; ra te ndi ichi tu ini yu tiakuii, ra taxi va ndo ra xiꞌi yu; ra ta kee yu inka ñuu ndixaa yu nuu ndo, ra ndakiꞌin mani va ndo yuꞌu veꞌe ndo; ");
INSERT INTO mxv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ra te ndixiyo yala yu, ra taxi va ndo tikoto xindixi yu; ra te kiꞌin kueꞌe yu xikanduꞌu yu, ra ndixaa va ndo ixtoꞌni ndo yuꞌu; ra te xindikaa yu veꞌe kàà, ra ndixaa va ndo ixtoꞌni ndo yuꞌu”, kachi yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ra saa ndakatuꞌun na xa ña vaꞌa yoꞌo yuꞌu, kachi na saa: “Tata, ¿ama ke ndikaꞌun ini kun, ra taxi ndi ña xixi kun? ¿Ra ama ke ndi ichi ini kun, ra taxi ndi tiakuii xiꞌi kun? ");
INSERT INTO mxv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ra ama ke kee kun inka ñuu xika ndixaa kun veꞌe ndi, ra ndakiꞌin mani ndi yoꞌo? ¿Ra ama ke ndixiyo yala kun, ra taxi ndi tikoto xindixi kun? ");
INSERT INTO mxv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ra ama ke kiꞌin kueꞌe yoꞌo, ra ndixaa ndi ixtoꞌni ndi yoꞌo? ¿Ra ama ke xindikaa kun veꞌe kàà, ra ndixaa ndi ixtoꞌni ndi yoꞌo, Tata?”, kachi na xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ra saa ndakuiin yuꞌu, ra kuu Rey, kachi yu saa xiꞌin na: “Ña ndixa kaꞌan yu xiꞌin ndo, saa chi takundiꞌi ña vaꞌa, ña xa ndo xiꞌin na ndaꞌvi na ndee nuu ña yuuvi yoꞌo, na kuu ñani yu, ra süvi xiꞌin na kan ke ndixa ndo ña, chi xiꞌin yuꞌu va ke xa ndo ña”, kachi yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ra te na ndiꞌi, saa kaꞌan tu yu xiꞌin na chindee yu chi ndaꞌa ichin va yu, ra kachi yu saa xiꞌin na: “Kuatiaꞌa ndo nuu yu, chi na ndivaꞌa va kuvi ndoꞌo, ra vichin ke kuꞌun ndo chi nuu xixi ñùꞌù, ñuu kaꞌñu, ña xa iyoo ndúvi xaꞌa timiaꞌa xiꞌin na tatun ri. ");
INSERT INTO mxv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Saa chi te ndikaꞌun ini yu, ra nditäxi ndo ixta kuxi yu; ra te ndi ichi ini yu, ra nditäxi tu ndo tiakuii koꞌo va yu; ");
INSERT INTO mxv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ra ta kee yu inka ñuu ndixaa yu veꞌe ndo, ra ndixïin ndo ña ndakiꞌin mani ndo yuꞌu; ra ta ndixiyo yala yu, ra nditäxi ndo tikoto kundixi yu; ra te kiꞌin kueꞌe yuꞌu xikanduꞌu yu, ra ndixäa ndo kotoꞌni ndo yuꞌu; ra ta xindikaa tu yu veꞌe kàà, ra ndixäa ndo kotoꞌni ndo yuꞌu”, kachi yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ra saa ndakuiin na, kachi na saa xiꞌin yu: “Tata, ¿ama ke ndikaꞌun ini kun, ra ndi ichi ini kun tiakuii, ra kee kun inka ñuu xika ndixaa kun veꞌe ndi, ra ndixiyo yala kun, ra kiꞌin kueꞌe yoꞌo, ra xindikaa kun veꞌe kàà, ra ndichindiëe taꞌan ndi xiꞌin kun?”, kachi na xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ra saa ndakuiin yu kachi yu saa xiꞌin na: “Ña ndaa kaꞌan yu xiꞌin ndo, saa chi ta xini ndo na ndaꞌvi ndoꞌo, ra ndixïin ndo sa ndo ña vaꞌa yoꞌo xiꞌin na, ra süvi xiꞌin na kan ke ndixïin ndo sa ndo ña, chi xiꞌin yuꞌu va ke ndixïin ndo sa ndo ña”, kachi yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ra saa kaꞌndia yu chiñu kachi yu saa: “Yuvi ñaꞌa yoꞌo, ra na ku̱ꞌu̱n na xitun nuu xixi ñùꞌù ñuu kaꞌñu; ra na vaꞌa, na toꞌo na kuꞌun ña koo na xiꞌin Ndioxi, iin ndisaa kii, ndia ndikaa ndikuꞌun va”, kachi yu xiꞌin na ―*kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ra saa te sandiꞌi Jesús ndikaꞌan ra takundiꞌi ña yoꞌo, saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Xa kundaa va ini ndo, chi ndia soo uvi kii va ke kumani ra tiandiaa kii ña ndatava na viko pascua, ra tiin na yuꞌu, ra xaa yoꞌo, ra ndataxi na yuꞌu ndaꞌa na saa ini xini yuꞌu, ra takaa na yuꞌu ndaꞌa cruz ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ra kii kan, ndakutaꞌan takundiꞌi ndia xikuaꞌa kunaꞌnu nuu ndia sutu xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, ra iin ndakaya takundiꞌi ndia ndee ndia nuu keꞌe veꞌe ra sutu kuchee ra nani Caifás. ");
INSERT INTO mxv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ra saa ndikataꞌan ndia, ña chikaa ndia kuachi siki sata Jesús, ña vaꞌa tiin ndia ra, ra kaꞌni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ra saa ndikaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa. ―Tïin yo ra mii viko, chi koto kanitaꞌan yuvi xiꞌin yo, ra tiaa ni ndiee sa na xaꞌa ra ―kachi ndia xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ra saa kuu ndixaa Jesús ñuu Betania, ra ndikiꞌvi ra xikunduꞌu ra veꞌe ra Simón, ra ndoꞌo kueꞌe tiaꞌyu. ");
INSERT INTO mxv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ra nani saa kuu Jesús nduꞌu ra nuu mesa, ra saa ndixaa iin ñaꞌa, ra niꞌi ña iin yuyu loꞌo, ra iin chitu ndaa ña xiꞌin ndutia xaꞌan tami, ra yaꞌvi ni, ra saa taꞌvi ña sukun yuyu loꞌo kan, ra koso ndiee ña ra xini Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ra te xini sava ndia itaꞌan xiꞌin Jesús, saa ra ndukueꞌe ni ini ndia xini ndia ñaꞌa kan, ra ndikaꞌan ndia kachi ndia saa: ―¿Nichuun ke ndixitia uun ndutia xaꞌan tami, ra yaꞌvi ni kaa? ");
INSERT INTO mxv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿A väꞌa ndikiyaꞌvi va ra? Ra kusana yaꞌvi ni va sata na ra, ra xuꞌun ña kiꞌin yo xaꞌa ra, ra vaꞌa taxi yo ña ndaꞌa na ndaꞌvi, ña chindiee taꞌan yo xiꞌin na ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ra saa xini soꞌo Jesús ña ndikaꞌan ndia, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Koo yaa ndo xiꞌin ña. ¿Nichuun kañaꞌa ndo xaꞌa ña? Chi ña xa ña xiꞌin yu yoꞌo, ra ña vaꞌa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Saa chi na ndaꞌvi na kaꞌan ndo xaꞌa, ra iin ndisaa kii va ke kundee na kan xiꞌin ndo, ndi su yuꞌu, ra süvi iin ndisaa kii ke kuiin yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ra ña xa ña yoꞌo xiꞌin yu vichin, ña chikaa ña ndutia ra xaꞌan tami yoꞌo yuꞌu, ra xa ña xanduvi va kuvi ña xiꞌin yu, te xa na nduxin na yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi ndia ndia ka nuu ñuꞌu ña yuuvi yoꞌo, nuu ndatuꞌun na tuꞌun vaꞌa xaꞌa yu, ra ikan ndatuꞌun tu na xaꞌa ña xa ña yoꞌo va, ra saa ndakaꞌan na xaꞌa ña vaꞌa ña xa ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ra ra nani Judas Iscariote, ra itaꞌan xiꞌin ndia ña kuu ndia uxi uvi ña itaꞌan ndia xiꞌin Jesús, ra kee ra kuaꞌan ra nuu ndia sutu ndia kunaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ra te ndixaa ra nuu ndia sutu kan, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Nisaa ke chaꞌvi ndo yuꞌu, ra ndataxi yu Jesús ndaꞌa ndo? ―kachi ra xiꞌin ndia. Ra saa kindoo ndia, ña taxi ndia oko uxi xuꞌun kàà ña plata ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Saa ra ndikun mii kii kan ke, xaꞌa va ra Judas, ña xika nduku ra ndia kuꞌva ke sa ra, ña vaꞌa ndataxi ra Jesús ndaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ra kii nuu te iyoo viko ña xixi na ixta vaꞌa ña köo ndavi xiꞌin, saa kuyachin ndia itaꞌan xiꞌin Jesús, ra nindakatuꞌun ndia ra kachi ndia saa: ―Tata, ¿ndia mii ke kuni kun kuꞌun ndi savii ndi ñaꞌa kuxini yo viko pascua vichin? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ñuu, ra ikan kuni ndo iin tiaa, ra kaꞌan ndo xiꞌin ra kachi ndo saa: “Suꞌva ke kachi ra Tata Maestro: Xa ninumi ni xaa kii ña sa yu chiñu ña xiniñuꞌu sa yu, ra veꞌe kun kuvi ña kuni yu xaa yu ndatava yu viko pascua xiꞌin ndia itaꞌan xiꞌin yu”, ^kachi yu, kachi ndo xiꞌin ra ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ra iin ta kuꞌva kachi ra xiꞌin ndia ke xa ndixa va ndia, ra mii veꞌe tiaa kan ke xavii va ndia ñaꞌa ña kuxini ndia viko pascua kan. ");
INSERT INTO mxv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ra te xa kuaꞌan kuñuu, saa xaa Jesús, ra xikunduꞌu ra nuu mesa xiꞌin uxi uvi saa ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ra nani saa kuu Jesús xixini ra xiꞌin ndia, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, saa chi iin ndoꞌo, ndia ndee xiꞌin yu vichin va kuvi ndo ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ra saa xaꞌa kusuchi ka vi ini ndia, ra xaꞌa ta iin ta iin ndia kaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, ¿a yuꞌu kuvi ra sa saa xiꞌin kun? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Iin ndoꞌo ndia chindaxi ixta ini koꞌo ña xixi yu kuvi ndo ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ra saa ndikaꞌan ka ra kachi ra saa: ―Ña ndixa ke yuꞌu ra xaa yoꞌo, ra xa saa xiniñuꞌu ndoꞌo ni va yu, ta kuꞌva kachi mii tuꞌun Ndioxi ña tiaa na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa va. Ndi su, ¡ndaꞌvi ni tiaa ra ndataxi yuꞌu!, ra vaꞌa ka va kee ra ndaꞌvi tu kuëe ndikaku ra ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ra saa ndakuiin ra Judas, ra ^kuni ndataxi Jesús ndaꞌa na saa ini, kachi ra saa: ―¿A yuꞌu kuvi ra sa saa, Tata Maestro? ―kachi ra. Saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Xa mii kun ndikaꞌan va ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ra nani saa kuu ndia xixi ndia ndee ndia, ra saa kiꞌin Jesús iin ixta, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra saa taꞌvi ra ña, ra taxi ra ña ndaꞌa ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kiꞌin ndo ña yoꞌo kuxi ndo, chi ña yoꞌo ku iki kuñu yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ra te ndiꞌi saa kiꞌin ra iin copa ña ñuꞌu vino, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ra, ra saa taxi ra ña ndaꞌa ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kiꞌin ndo copa yoꞌo, ra loloꞌo ra koꞌo takundiꞌi ndo, ");
INSERT INTO mxv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","saa chi vino yoꞌo kuvi ra kuu nii yu, ña kutia xaꞌa takundiꞌi na yuuvi yoꞌo, ra nii yu ña kutia kan, kuvi iin trato xaa ña kindoo yu xiꞌin ndo vichin. ");
INSERT INTO mxv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ra kuni yu ña na kundaa ini ndo vichin, saa chi nandïko ka yu ña koꞌo yu vino yoꞌo xiꞌin ndo; chi ndia te na xaa kii ña ndakutaꞌan tuku yo nuu xaꞌndia Ndioxi chiñu, ra ndia saa vi ke koꞌo yu vino ra xaa xiꞌin ndo ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ra saa te ndiꞌi xita ndia yaa yii, ra saa kee ndia ra ndakiꞌin ndia kuaꞌan ndia, chi iku ña nani Olivo. ");
INSERT INTO mxv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ñuu vichin ra yuꞌvi takundiꞌi va ndo, ra ndakoo mituꞌun va ndo yuꞌu, chi saa kachi tuꞌun Ndioxi: “Kuvi ra kuu paxto, ra ndutia ndiꞌi va ndikachi kuꞌun ri” ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndi su te na ndatiaku yu, ra xiꞌna ka va yuꞌu ku ra kunuu kuꞌun nuu ndo chi Galilea ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Saa ndakuiin ra Pedro kachi ra saa xiꞌin Jesús: ―Tata, vaꞌa ni na yuꞌvi takundiꞌi va ndia, ra ndakoo ndia yoꞌo, ndi su yuꞌu, ra ndaköo ndaꞌa yu yoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin kun, chi ñuu vichin ra xa uni va ichi tiseꞌe tuꞌun kun xaꞌa yu, ra saa kana chele ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ra saa ndakuiin tuku ra Pedro kachi ra saa: ―Vaꞌa ni na kuvi va yu xiꞌin kun, Tata, ndi su tisëꞌe tuꞌun mii vi yu xaꞌa kun ―kachi ra xiꞌin Jesús. Ra iin saa kachi takundiꞌi tu ndia sava kan va. ");
INSERT INTO mxv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ra saa ndixaa Jesús xiꞌin ndia itaꞌan xiꞌin ra xaꞌa iku Olivo iin nuu nani Getsemaní, ra ikan ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Kundee ndo yoꞌo, ra yuꞌu na kuꞌun kaꞌan xiꞌin Ndioxi ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ra ndikaꞌan ra xiꞌin ra Pedro, xiꞌin uvi saa ndia seꞌe ra Zebedeo kuaꞌan ndia xiꞌin ra, ra saa xaꞌa kusuchi ka vi ini ra, ra xaꞌa ndiꞌi ka vi ini ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Tiaa ni kusuchi ini yu, iin yoo ini yu kuvi va yu, ra ndoꞌo ndia ndoo yoꞌo, ra kundito ndo xiꞌin yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ra saa kuxika ra loꞌo nuu ndee ndia, ra ikan xikusiti ra, ra iin ndiakua nditiandiaa tiaan ra ndia nuu ñuꞌu, ra xaꞌa ra kaꞌan ra xiꞌin Ndioxi kachi ra saa: ―Tata, tu ña kuvi ke, ra na yaꞌa va tundoꞌo, ña kuyachin vaxi nuu yu; ndi su na köo ña kuni yuꞌu, chi na koo ña kuni yoꞌo va ―^kachi ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Te ndiꞌi saa nandiko ra xaa ra nuu ndee ndia, ra xa ndia ^kixi va kuvi ndia, ra saa ndikaꞌan ra xiꞌin ra Pedro kachi ra saa: ―¿A ndia nii hora loꞌo vi ke ndixändiee ini ndo ña kundito ndo ra kaꞌan ndo xiꞌin Ndioxi xiꞌin yu? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ra saa ndikaꞌan ka Jesús, kachi ra saa xiꞌin ndia: ―Kundito ndo, ra kaꞌan ni ndo xiꞌin Ndioxi, ña vaꞌa na täxi ra koyo ndo ndaꞌa kuachi, chi ña ndixa ke: Ndoꞌo, ra kuni ni va ndo kaꞌan ndo xiꞌin Ndioxi, ndi su vita ni va ini ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ra saa ndakiꞌin tuku Jesús kuaꞌan ra, kaꞌan ra xiꞌin Ndioxi ichi ña uvi, ra saa xaꞌa ra kaꞌan ra ^kachi ra saa: ―Tata, tu yuꞌu kuvi ra xiniñuꞌu ndoꞌo tundoꞌo yoꞌo, saa ra, na koo ta kuꞌva kuni mii va kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ra te nandiko tuku ra xaa ra nuu ndee ndia, ra kixi tuku va ndia ndee ndia, saa chi tiaa ni kuni kusun ndia, ra iin vevee takaa maꞌna nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ra saa ndakoo ra ndia, ra ndakiꞌin tuku ra kuaꞌan ra kaꞌan ra xiꞌin Ndioxi ichi ña uni va. Ra iin ta kachi ra ke, kachi tuku va ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ra saa nandiko ra, xaa tuku ra nuu ndee ndia itaꞌan xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¡A ndakundiee ndo kixi ndo ra ndakindiee ndo saa va! Na kundaa ini ndo, chi xa nditiandiaa va hora ña ndataxi na yuꞌu ra xaa yoꞌo, ndaꞌa yuvi kuachi. ");
INSERT INTO mxv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","^Ndakoo ndo, ra kuꞌun yo; chi xa kuyachin va ra ndataxi yuꞌu ndaꞌa na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ra sakan saa kuu Jesús kaꞌan ra xiꞌin ndia, saa ra xaa va ra Judas, ra itaꞌan xiꞌin ndia, ña kuu ndia uxi uvi ña itaꞌan ndia xiꞌin Jesús, ra iin tiaꞌndia chee yuvi ndiaka ra, ra niꞌi na ichi xiꞌin itun. Ra ndia xikuaꞌa, xiꞌin ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi kuvi ndia tiꞌvi na ña ndixaa na. ");
INSERT INTO mxv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ra xa ndikataꞌan va ra Judas xiꞌin na ndia kuꞌva ke ndataxi ra Jesús ndaꞌa na. Ra suꞌva ke kachi ra xiꞌin na: ―Ra xaa yu kaꞌan ndioxi yu xiꞌin kan kuvi ra tiin ndo, ra tuun vaꞌa kuꞌni ndo ra ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ra te ndixaa ndixa ra Judas, saa ra ndikun kuyachin va ra nuu iin Jesús, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―¿A iyoo vaꞌa kun, Tata Maestro? ―kachi ra xiꞌin ra. Ra saa nditiandiaa yuꞌu ra nuu Jesús, ña ndikaꞌan Ndioxi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ñani, saxinu nuu chiñu ña vaxi kun sa kun ―kachi ra xiꞌin ra. Ra saa nditiandiaa yuvi kan, ra ti̱in na Jesús kuaꞌan ra xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ra saa tava iin ra itaꞌan xiꞌin Jesús ichi, ra xaꞌndia ra iin xiyo soꞌo ra muso, ra xachiñu nuu ra sutu, ra kuchee nuu takundiꞌi ndia sutu. ");
INSERT INTO mxv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ra saa ndikaꞌan Jesús xiꞌin ra xaꞌndia soꞌo tiaa kan, kachi ra saa: ―Ndachikaa vaꞌa ichi kun nuu ndikaa ña, saa chi takundiꞌi yuvi na xaꞌni xiꞌin ichi, ra xiꞌin ichi ke kuvi tu na kan va. ");
INSERT INTO mxv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ra a kundäa ini kun, ña kuvi va kaꞌan yu xiꞌin Tata yu, ra takaꞌan va tiꞌvi ra iin tiaꞌndia chee na tatun ra kixi na sata yu? ");
INSERT INTO mxv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ndi su tu saa na sa yu, saa ra küvi vi xinu nuu tuꞌun Ndioxi ña kaꞌan xaꞌa takundiꞌi ña xiniñuꞌu ndoꞌo yu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ra saa ndikaꞌan Jesús xiꞌin yuvi kan, kachi ra saa: ―¿Nichuun xaa ndo xiꞌin ichi, xiꞌin itun ña tiin ndo yuꞌu, a ra kuiꞌna kuvi yu tuvi ndo? ¿A su iin ndisaa kii va ndixiyo yu xiꞌin ndo ini veꞌe ñuꞌu, ña sañaꞌa yu ndoꞌo, ra nditïin ndo yuꞌu? ");
INSERT INTO mxv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ndi su, suꞌva ke xiniñuꞌu kuu va, ra saa ke xinu nuu ña kaꞌan tuꞌun Ndioxi, ña ndikaꞌan na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ―*kachi Jesús xiꞌin na. Ndia saa, ra xinu ndiꞌi va ndia itaꞌan xiꞌin Jesús, kuaꞌan ndia, ra ndakoo ndaꞌa va ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ra na ndixaꞌan tiin Jesús, ra ndiaka na ra ndixaa na xiꞌin ra nuu keꞌe veꞌe ra sutu, ra nani Caifás, ra kuchee nuu takundiꞌi ndia sutu. Ra xa ikan ndakutaꞌan takundiꞌi va ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, ndee ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ra ra Pedro, ra xika xika va ndikun ra kuaꞌan ra sata Jesús, ra saa ndixaa ra ndia nuu keꞌe ra sutu Caifás ra kuchee nuu na sutu kan, ra ikan ndakunduꞌu ra xiꞌin ndia kumisio ndiaa yeꞌe ñuꞌu, ña ndiatu ra, kuni ra ni ke sa na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ra ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia xikuaꞌa veꞌe ñuꞌu, ra xaꞌa ndia xika nduku ndia kuachi siki, ña taxi ndia xaꞌa Jesús, ña vaꞌa ndataxi ndia ra ndaꞌa na chiñu, ra kaꞌni na ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ra vaꞌa ni kuaꞌa ni va yuvi ndixaa nuu na chiñu kan, ña taxi na kuachi siki xaꞌa Jesús, ndi su nindanïꞌi na kuachi ra. Ra xa nuu väꞌa ka va na, saa vi ndixaa uvi ndia chikaa kuachi siki sata Jesús, ");
INSERT INTO mxv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ra ndikaꞌan ndia, kachi ndia saa: ―Nduꞌu kuu ndia xini soꞌo ña ndikaꞌan ra, ta kachi ra suꞌva “Yuꞌu, ra kani yu veꞌe ñuꞌu kaꞌnu, ra kivi uni ndakanindichi tuku va yu ña” kachi ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ra saa ndakundichi ra sutu ra kuchee nuu takundiꞌi ndia sutu, ra ndikaꞌan ra kachi ra saa xiꞌin Jesús: ―¿A ndakuïin vaꞌa vi kun ña taxi ni ndia yoꞌo kuachi xaꞌa kun? ¿Ra a ndixa saa kachi kun, chi saa kachi ndia yoꞌo? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ndi su ndia nii tuꞌun loꞌo nindäkuiin Jesús, ra saa ndikaꞌan tuku ra sutu kuchee kan xiꞌin ra kachi ra saa: ―Xiꞌin kivi Ndioxi ra tiaku ke na ndatuꞌun kun xiꞌin ndi vichin, ¿a ndixa yoꞌo kuvi ra kuu seꞌe Ndioxi, ra tiꞌvi ra vaxi sakaku na yuuvi yoꞌo? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Xa mii kun ku ra ndikaꞌan va, ra suvi kuvi va yu. Ra na kundaa ini ndo vichin, chi kuni ndo yuꞌu ra xaa yoꞌo, ña ndakunduꞌu yu chi xitia kuaꞌa Ndioxi ra kaꞌnu, ndivi nuu xaꞌndia ra chiñu, ra ndiko yu kixi yu iin nuu viko yaa ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Saa ra iin ndata saa ini ra sutu kuchee kan tikoto ña ndixi ra, ra ndikaꞌan ra kachi ra saa: ―Ra ndaa yuꞌu va ku ra yoꞌo Ndioxi. ¿Ra nichuun ke kuniñuꞌu ka vi yo yuvi na kaꞌan tieꞌe nuu ra?, chi xa xini soꞌo tu mii va ndo, ña ndaa yuꞌu ra Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ra ndixaa tuvi ndoꞌo? ―kachi ra sutu kuchee kan xiꞌin na. Ra saa ndakuiin na kachi na saa: ―Xiniñuꞌu na kuvi va ra, saa chi ndaa yuꞌu ra Ndioxi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ra saa xaꞌa sava na kondiaa na tiasiꞌi na nuu Jesús, ra kani ni na ra, ra sava tu na xaꞌa xakin xaꞌndia nuu va ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ra kaꞌan na xiꞌin ra kachi na saa, ña xasiki na ra: ―Yoꞌo, ra kaꞌnu, ra tiꞌvi Ndioxi xaa sakaku na yuuvi yoꞌo, ra kaꞌan ndaku xiꞌin ndi vichin, ¿yoo kuvi na kani yoꞌo?, tu ndixa ra kaꞌnu kuvi kun ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ra saa ^kuu na xa ndivaꞌa na xiꞌin Jesús xika na. Ra saa ndixaa ra Pedro ndakunduꞌu ra chi nuu keꞌe, veꞌe ra sutu kan, ra saa ndixaa iin ñaꞌa, ña xachiñu veꞌe kan, ra ndikaꞌan ña xiꞌin ra Pedro kachi ña saa: ―Ra itaꞌan xiꞌin Jesús, ra kee chi Galilea kuu tu yoꞌo va ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ndi su ra Pedro, ra tiseꞌe tuꞌun va ra xaꞌa Jesús, nuu takundiꞌi na ndee kan, ra ndikaꞌan ra kachi ra saa: ―Xïni yu yoo ku ra kaꞌan kun xaꞌa ñaa ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ra saa ndakundichi ra Pedro kanata ra chi yeꞌe, ra saa xini inka tuku ña xachiñu veꞌe kan ra, ra ndikaꞌan ña xiꞌin takundiꞌi na ndee kan, kachi ña saa: ―Ra itaꞌan xiꞌin Jesús, ra kee ñuu Nazaret ku tu ra yoꞌo va ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ndi su tiseꞌe tuꞌun tuku va ra Pedro xaꞌa ra, ra chinaꞌa ra Ndioxi nuu na ndee kan, kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi xïni yu yoo kuvi ra kaꞌan ndo xaꞌa ñaa ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ra saa kuu ndiyaꞌa iin kani loꞌo, ra saa kuyachin na ndee kan, ra ndikaꞌan na xiꞌin ra kachi na saa: ―Ña ndixa ke ra itaꞌan xiꞌin ndia itaꞌan xiꞌin Jesús ku tu yoꞌo va, saa chi iin ta ndatuꞌun ndia kan, ra iin saa ndatuꞌun tu yoꞌo va ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ra saa xaꞌa ra Pedro, kañaꞌa ra, ra chinaꞌa ra Ndioxi, kachi ra saa: ―Xïni yu yoo kuvi tiaa ra kaꞌan ndo xaꞌa ñaa ―kachi ra. Ra te sakan saa kuu ra kaꞌan ra, saa ra kana va chele. ");
INSERT INTO mxv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ra saa ndakaꞌan ra xaꞌa tuꞌun ña ndikaꞌan Jesús xiꞌin ra, ta kachi ra saa: “Xiꞌna ka va uni ichi tiseꞌe tuꞌun kun xaꞌa yu, ra saa kana chele”, kachi ra xiꞌin ra. Ra saa kanata ra Pedro chi keꞌe, ra xaꞌa ra xaku ni ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ra ñaꞌa ni ndakutaꞌan takundiꞌi ndia kunaꞌnu nuu ndia sutu, xiꞌin takundiꞌi ndia xikuaꞌa kunaꞌnu nuu na ñuu, ña ndikataꞌan ndia xaꞌa Jesús, ndia kuꞌva ke sa ndia ña vaꞌa kaꞌni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ra saa chikuꞌni na Jesús, ra ndakundiaka na ra kuaꞌan ra xiꞌin na, ña ndataxi na ra ndaꞌa ra Poncio Pilato ra kuu gobernador. ");
INSERT INTO mxv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ra saa te xini ra Judas ra ndataxi Jesús, ña ndikataꞌan ndia ña kaꞌni ndia Jesús, saa ra nandiko ka vi ini ra xaꞌa ña xa ra, ra saa ndixaꞌan ra sandiko ra oko uxi saa xuꞌun ña plata ndaꞌa ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, ");
INSERT INTO mxv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Chee ni kuachi xa yu, saa chi ndataxi yu iin tiaa ra köo kuachi ndaꞌa ndo, ña kaꞌni ndo ra ―kachi ra xiꞌin ndia. Ra saa ndakuiin ndia kachi ndia saa xiꞌin ra: ―¿Ra ni ke ndoꞌo vi tu nduꞌu ndiꞌi ini ndi xaꞌa ña xa yoꞌo? ¡Mii kun xini va! ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ra saa koꞌni ra Judas oko uxi saa xuꞌun ña plata kan, ini veꞌe ñuꞌu kan, ra saa kanata ra chi keꞌe ra ndixaꞌan ra sakuaꞌña ra mii va ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Saa ndakiꞌin ndia kunaꞌnu nuu ndia sutu xuꞌun kan, ra ndikaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―Xuꞌun yoꞌo ra küvi ndataan yo ña ini xatun nuu ndoꞌni xuꞌun ña soko yuvi nuu Ndioxi, saa chi süvi ka xuꞌun vaꞌa kuvi ña, chi nii iin tiaa va ndixitia xaꞌa ña ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ra te ndiꞌi saa ndikataꞌan ndia ña sata ndia iin yoso kaꞌnu ña nani “Yoso Alfarero” xiꞌin xuꞌun kan, ra ikan ku nuu nduxin na takundiꞌi yuvi na kee inka ñuu, tu na xaa na kuvi na ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ra xaꞌa ña kan ke, ndia kii vichin ra “Yoso ña ndixitia nii xaꞌa” ke nani va yoso kan. ");
INSERT INTO mxv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ra yoꞌo ke ndixinu nuu tuꞌun ña ndikaꞌan ra Jeremías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, te kachi ra suꞌva: “Ndakiꞌin na oko uxi xuꞌun ña plata, xuꞌun ña chaꞌvi na xaꞌa iin tiaa ra ndiaa yaꞌvi ni, ta kuꞌva ndikataꞌan na ñuu Israel ña kuu yaꞌvi ra, ");
INSERT INTO mxv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ra xiꞌin xuꞌun kan ke sata na iin yoso, ña nani alfarero, ra iin ta kuꞌva kachi Ndioxi xiꞌin yu ke kuu va”, kachi ra Jeremías. ");
INSERT INTO mxv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ra saa ndiaka na Jesús ndixaa na xiꞌin ra nuu ra Pilato ra kuu gobernador, ra saa nindakatuꞌun ra Jesús kachi ra saa: ―¿A ndixa yoꞌo kuvi ra kuu rey na Judío? ―kachi ra. Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ta kachi kun ke iyoo va ña ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ra na kunaꞌnu nuu ndia sutu, xiꞌin ndia xikuaꞌa nuu na ñuu, ra xaꞌa ndia taxi ndia kuachi xaꞌa Jesús nuu ra Pilato, ndi su Jesús ra ndia nii tuꞌun loꞌo nindäkuiin ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ra saa ndikaꞌan ra Pilato xiꞌin Jesús kachi ra saa: ―¿A xini soꞌo kun takundiꞌi kuachi ña taxi ndia yoꞌo xaꞌa kun, ra a ndixa kuachi kun kuvi ña? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ndi su ndia nii tuꞌun loꞌo nindäkuiin Jesús yuꞌu ra, ra saa ndakanda ka vi ini ra gobernador kan xini ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ra vichin na kundaa ini yo, chi kii te ndatava na viko pascua, ra yunaꞌa ra Pilato ña saña ndika ra iin na ñuꞌu veꞌe kàà, ta kuiya ta kuiya, ndia ndia ka mii na kaꞌan na ñuu xaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ra mii kuiya kan ndikaa iin tiaa, ra nani Barrabás veꞌe kàà, ra yoso tuꞌun ni ra xiꞌin chuun kiꞌvi ña ^xa ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ra saa nindakatuꞌun ra Pilato takundiꞌi yuvi na ndakaya ndixaa kan, kachi ra saa: ―¿Yoo kuvi ndia kuni ndo saña ndika yu: ra Barrabás, a Jesús ra kaꞌan ndo xaa sakaku ndoꞌo va? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Saa chi xa kundaa va ini ra Pilato, chi xaꞌa ña ndukuini ini va na ke ndataxi na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ra sakan saa kuu ra Pilato nduꞌu ra tiayu nuu xandaku ra kuachi, ra saa tiꞌvi ña yasiꞌi ra chiñu ndixaa ña nuu ra, ra kachi ña saa: ―Ndia nii ña na sä kun xiꞌin tiaa ñaa, chi ra vaꞌa va kuvi ra, saa chi iin ni ñuu ndaa, ra iyo ni ndixani yu xaꞌa ra ―kachi ña xiꞌin chuun kan. ");
INSERT INTO mxv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ndi su ndia kunaꞌnu nuu ndia sutu xiꞌin ndia xikuaꞌa nuu na ñuu, ra xaꞌa ndia chikaa yuꞌu ndia na ñuu ña na kaꞌan na xaꞌa ra Barrabás ña na saña ndika ra, ra Jesús, na kuvi va kachi ndia xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ra saa nindakatuꞌun tuku ra gobernador kan na kachi ra saa: ―¿Yoo kuvi ndia kuni ndo saña ndika yu?, ―kachi ra xiꞌin na. Ra saa ndakuiin na kachi na saa: ―Ra Barrabás kuvi ra na saña kun ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ra saa ndikaꞌan ra Pilato xiꞌin na kachi ra saa: ―¿Ra ni ke sa yu xiꞌin Jesús, ra kaꞌan ndo xaa sakaku ndoꞌo tu? ―kachi ra xiꞌin na. Ra saa iin siso siso ndakuiin na kachi na saa: ―¡Na kutakaa ra ndaꞌa cruz! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ra saa ndikaꞌan tuku ra gobernador kan xiꞌin na kachi ra saa: ―¿Ndia ña kuu kuachi xa ra tuvi ndo? ―kachi ra xiꞌin na. Ndi su yuvi kan ra na ndiee ka ndaꞌyu va kuvi na, kachi na saa: ―Na kutakaa ra ndaꞌa cruz ―kachi tuku va na. ");
INSERT INTO mxv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ra te xini ra Pilato ña kundiëe ka tuꞌun ra xiꞌin yuvi kan, saa chi na ndiee ka xaꞌa xa va kuvi na, saa ra xaꞌndia ra chiñu ña taxi na tiakuii ndaꞌa ra, ra saa ndakatia ra ndaꞌa ra nuu takundiꞌi na ñuu, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Ndïso ka yu xaꞌa nii tiaa yoꞌo, ña kutia ña, saa chi ra vaꞌa va kuvi ra, ra ndia ñaa ke kotoꞌni mii ka va ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ra saa ndakuiin takundiꞌi na ñuu kan kachi na saa: ―Nduꞌu, xiꞌin seꞌe ndi kuvi na, na kuiso xiꞌin nii ra ña kutia ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ra saa tava ra ra Barrabás veꞌe kàà ña kuaꞌan ndika ra, ra xaꞌndia ra chiñu ña na kani na Jesús xiꞌin ñii ña kuu kuarta, ra te na ndiꞌi, saa na kuꞌun na xiꞌin ra ña katakaa na ra ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ra saa ndakiꞌin ndia soldado ndia xachiñu nuu ra gobernador kan Jesús, kuaꞌan ra xiꞌin ndia, ra ndixaa ra xiꞌin ndia chi nuu keꞌe veꞌe chiñu kaꞌnu kan, ra ikan ndakaya takundiꞌi ndia soldado ra iin xinunduu ndia ra ndita ndia. ");
INSERT INTO mxv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ra saa tava ndia tikoto ña ndixi ra, ra ndachikaa ndia iin tikoto kuaꞌa ña kani sukun ra, ");
INSERT INTO mxv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ra chikaa na iin corona ña xavaꞌa na xiꞌin ìñu̱ xini ra, ra taxi na iin ndoo ñuꞌù ndaꞌa kuaꞌa ra, ra saa xaꞌa na ndakusiti na nuu ra, ña xa siki na ra, ra kaꞌan na xiꞌin ra kachi na saa: ―Kaꞌnu ni yoꞌo ra kuu rey na judío ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ra saa xaꞌa na kondiaa na tiasiꞌi na nuu ra, ra ndakiꞌin na ndoo ñuꞌù kan ndaꞌa ra, ra xaꞌa na xakin na nuu xini ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ra saa te sandiꞌi na, ña xa siki na ra, ra saa tava na tikoto ña chikaa na sukun ra, ra ndachikaa na tikoto mii ra sukun ra, ra ndakiꞌin na ra kuaꞌan ra xiꞌin na, ña katakaa na ra ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ra ta kee na ndakiꞌin na kuaꞌan na xiꞌin Jesús, ra saa ndakutaꞌan na xiꞌin iin tiaa ra nani Simón ra kee ñuu Cirene, ra xa nduxa na xiꞌin ra ña na kasoko ra cruz tun kasoko Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ra te ndixaa na xiꞌin Jesús iin nuu nani Gólgota, ra tuꞌun yoꞌo: “Ra iku leke xini ndii” ke kachi ña, ");
INSERT INTO mxv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ra ikan taxi na vino tia ndikava nuu iku iva xiꞌin, ña na koꞌo Jesús kuni na, ndi su te ixtondoso Jesús ndutia kan, saa ra ndixïin ra koꞌo ra rá. ");
INSERT INTO mxv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ra te ndiꞌi katakaa ndia soldado kan Jesús ndaꞌa cruz; ra saa xaꞌa ndia keꞌe taꞌan ndia xaꞌa tikoto ra, yoo ku ndia ndakiꞌin ña. Ra suꞌva ke kuu ña ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ta kachi ra suꞌva: “Ndataꞌvi na tikoto yu xiꞌin taꞌan na, ra sata tikoto yu ke, keꞌe taꞌan na, ra kundaa ini na yoo ku na kuchuun ndakiꞌin ña”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ra saa ndakundee ndia soldado kan ña ndiaa ndia Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ra tia̱à ndia nuu iin vitu loꞌo chinundiaa ndia xini cruz ra, ra kaꞌan tuꞌun kan ni xaꞌa ke kuvi ra, ra suꞌva ke kachi ña: “Ra yoꞌo ku Jesús ra kuu Rey na Judío”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ra katakaa tu ndia soldado kan uvi ndia kuiꞌna va xiꞌin Jesús, ra iin ra katakaa ndia ndaꞌa cruz tu iin chi kuaꞌa, ra iin ra katakaa tu ndia ndaꞌa cruz tu iin chi ichin va. ");
INSERT INTO mxv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ra yuvi na yaꞌa kuaꞌan ichi kan, ra iin xiko xini na, ra kañaꞌa na xiꞌin Jesús, ");
INSERT INTO mxv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kachi na saa: ―¡Yoꞌo, ra ndikaꞌan kani veꞌe ñuꞌu Ndioxi, ra kii uni xa ndakanindichi tuku kun ña, kachi kun, ra sakaku mii kun vichin, ra sanuu mii kun ndaꞌa cruz, tu ndixa seꞌe Ndioxi kuvi kun! ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ra iin saa xa tu ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia fariseo, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, ña xasiki ndia Jesús, ra kaꞌan ndia xaꞌa ra kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Kuchuun va ra sakaku ra inka yuvi, ra kuchüun tu ra sakaku ra mii ra ―kachi ndia. Ra saa kaꞌan ka ndia kachi ndia saa: ―Tu ndixa Rey na Israel kuvi ra, ra na sanuu ra mii ra ndaꞌa cruz vichin, ra saa ke kandixa yo ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Saa chi ndikaꞌan ra ña ndiaa ni ini ra Ndioxi, ra kuu tu ra seꞌe mii Ndioxi va kachi ra. Ra tu ndixa ke kuꞌvi ni ini Ndioxi xini ra ra, saa ra na sakaku ra ra vichin ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ra iin saa xa tu ndia kuiꞌna, ndia takaa ndaꞌa cruz kan va xiꞌin ra, saa chi kañaꞌa ni tu ndia kan va xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ra kuꞌva ka uxi uvi kaꞌñu ke, xaꞌa kuñaa nuu iinii saa ña yuuvi yoꞌo, ra iin saa ndia ka uni xikuaa. ");
INSERT INTO mxv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ra mii hora kan ndiee ka vi nindaꞌyu Jesús kachi ra saa: ―Elí, Elí, ¿lama sabactani? ―kachi ra. Ra suꞌva ke kachi tuꞌun yoꞌo: “Tata yu Ndioxi, Tata yu Ndioxi, ¿nichuun ndakoo ndaꞌa kun yuꞌu?”, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ra te xini soꞌo sava na ndita yachi kan, ra saa ndikaꞌan na xiꞌin taꞌan na kachi na saa: ―Tiaa soꞌo ndo, chi ra Elías ra ndikaꞌan tuꞌun yuꞌu Ndioxi va kuvi ra kana ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ra saa ndikun xinu iin ra ndixaꞌan ra chindaxi ra iin koꞌndo kachi ini iin ñaꞌa nuu ñuꞌu ndutia iyá, ra chinduꞌu ra ña xini iin itun ndoo ñuꞌu, ra sakuyachin ra ña yuꞌu Jesús ña na koꞌo ra ndutia iyá kan kuni ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ndi su ndixïin sava na ndita kan, ra ndikaꞌan na xiꞌin ra kachi na saa: ―Koyaa kun xiꞌin ra, ra na kuni yo a ndixa ke kixi ra Elías sanuu ra ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Saa ra ndiee ka vi nindaꞌyu tuku Jesús, ndia saa ra kuaꞌan va tachi ra ña ndixiꞌi ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ra tikoto yii ña ndasi nuu yii ini veꞌe ñuꞌu kaꞌnu kan, ra iin nindata sava ña, kiꞌin ña yuꞌu ña chi ni̱nù ra iin saa ndia chi ni̱nu̱, ña saña taꞌan ña, ra nduu ña uvi ñaꞌñu va. Saa ra ndiee ni nditaan, ra ninduva kava naꞌnu; ");
INSERT INTO mxv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ra ndanuña kuaꞌa ni yavi nuu ñuꞌu na ndii, ra kuaꞌa ni na yii, na xindikun Ndioxi, ndatiaku. ");
INSERT INTO mxv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ra te ndiatiaku Jesús, ra saa ndakoyo tu na kan va ini yavi nuu ñuꞌu na, ra kee na ndixaꞌan na ñuu kaꞌnu Jerusalén ña yii, ra kuaꞌa ni yuvi xini ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ra ra soldado ra kuchee kan xiꞌin ndia itaꞌan xiꞌin ra, ña ndiaa ndia Jesús, ra te xini ndia ña ndiee ni nditaan, ra xini tu ndia takundiꞌi ña kuu kan va, saa ra tiaa ni ndiyuꞌvi ndia, ra ndikaꞌan ndia kachi ndia saa: ―Ña ndixa ke seꞌe Ndioxi kuvi ndixa va ra yoꞌo ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ra xika va ndita kuaꞌa ni na siꞌi, na kee ndia chi Galilea, ña ixtoꞌni na, ña ndixiꞌi Jesús. Ra na siꞌi yoꞌo kuvi na xindikun sata Jesús, ra chindiee taꞌan na xiꞌin ra te ndixika ra ñuu ña ndoꞌni chi Galilea, ra iin saa ndikun na sata ra xaa na, ndia Jerusalén va. ");
INSERT INTO mxv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ra tiañu na kan ndichi ña María Magdalena, ra ndichi tu ña María siꞌi ra Jacobo xiꞌin ra José va, ra ndichi tu ña siꞌi ndia seꞌe ra Zebedeo va xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ra te xa kuaꞌan kuñuu kii kan, ra saa ndixaa iin tiaa ra kuika ni, ra kee ñuu Arimatea, ra José ke nani ra, ra ra xindikun sata Jesús ku tu ra yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ra saa kee ra ndixaꞌan ra nuu ra Pilato, ra ndikaꞌan ra xiꞌin ra, ña na ndataxi ra iki kuñu Jesús ndaꞌa ra, ña nduxin ra ña. Ra saa xaꞌndia ra Pilato chiñu ña na ndataxi na iki kuñu Jesús ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ra saa ndakiꞌin ra José kan iki kuñu Jesús, ra ndasuvi ra ña iin manda xaa ña vaꞌa, ");
INSERT INTO mxv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ra ndixaꞌan ra ninduxin ra ña ini yavi xaa, ña kaan ra ndika iin kava nuu ñuꞌú ra te yachi. Ra te ndiꞌi saa satuvi satuvi ra iin yuu chee ra nandasi ña yuꞌu yavi kan, ndia saa ra ndakiꞌin ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ra ña María Magdalena, xiꞌin inka tuku ña nani María, ra ndixaa na xikundee na yachin yuꞌu yavi kan, ña ixtoꞌni na ndia mii ku nuu ninduxin na iki kuñu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ra saa te ndituvi inka kii, te xa ndiꞌi xa nduvi na ña ndakindiee na kii sábado, ña kuu kii yii, ra saa ndixaꞌan ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia fariseo nuu ra Pilato, ");
INSERT INTO mxv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata gobernador, vaxi ndi nuu kun ndatuꞌun ndi xiꞌin kun, saa chi ndakuꞌun ini ndi xaꞌa tuꞌun ña ndikaꞌan Jesús, ra maña, ra sandaꞌvi yuvi kan, te xitiaku ra, chi ndikaꞌan ra kachi ra saa: “Te xa na kuvi yu ra kii uni ndatiaku tuku va yu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ra ña kan ke kuni ndi, ña na tiꞌvi kun ndia soldado kun kuꞌun ndia kondiaa ndia yuꞌu yavi nuu ndikaa ra uni saa kii. Chi koto iyo ni kuꞌun ndia xitaꞌan xiꞌin ra, ra tava seꞌe ndia iki kuñu ra yavi kan, ra te na ndiꞌi, xaꞌa ndia kaꞌan ndia xiꞌin yuvi, kachi ndia saa: “Xa ndatiaku va Jesús”, kachi ndia. Ra tu saa na sa ndia, saa ra tiaa ni ka va kuaꞌa yuvi sandaꞌvi ndia vichin nuu ña te xitiaku ra ―kachi ndia xiꞌin ra Pilato. ");
INSERT INTO mxv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Saa ndikaꞌan ra Pilato xiꞌin ndia kachi ra saa: ―Ñaa ndee ndia soldado, ra vaꞌa na kuꞌun ndia xiꞌin va ndo, ra na kondiaa ndia yuꞌu yavi kan, ra tuun vaꞌa na nandasi ndia ña, ta kuꞌva kachi mii va ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ra saa kee ndia soldado kan ndixaꞌan ndia ndasatuun vaꞌa ka ndia yuꞌu yavi kan, ra xakin ndia kuꞌva yuu ña ndasi yuꞌu yavi kan, ra nindoo ka sava ndia ña kondiaa ndia yuꞌu yavi nuu ndikaa iki kuñu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ra saa te ndiyaꞌa kii yii sábado, kii ndakindiee, ra ñaꞌa ni chi ixtiaan kii domingo, kii ña kiꞌin xaꞌa semana, ke kee ña María Magdalena, xiꞌin inka ña María kuaꞌan na kutoꞌni na yuꞌu yavi nuu ninduxin na iki kuñu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ra saa kuu na siꞌi kan ndixaa na yuꞌu yavi kan, saa ra tuꞌva ndiee ka vi nditaan. Ra saa kee iin ra tatun Ndioxi ndivi ra nduxinu ra, nuu ñuꞌu yoꞌo, ra sakutiaꞌa ra yuu ña ndasi yuꞌu yavi nuu ndikaa iki kuñu Jesús, ra te ndiꞌi saa ndakunduꞌu ra sata yuu kan. ");
INSERT INTO mxv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ra ra tatun Ndioxi kan, ra iin taxa taxa kaa ra, ra tikoto ña ndixi ra, ra yaa ka vi ña, iin ndiakua mii kachi kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ra te xini ndia soldado kan ra, saa ra tiaa ni ndiyuꞌvi ndia ra iin ndiakua kisi ña ndia, ra iin ndixiꞌi too ndia xindee ndia. ");
INSERT INTO mxv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ra saa ndikaꞌan ra tatun Ndioxi kan xiꞌin na siꞌi kan, kachi ra saa: ―Kuayüꞌvi ndo, chi xa kundaa va ini yu ña nanduku ndo Jesús, ra xitakaa ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ra köo ka ra ndikaa yoꞌo vichin, chi xa ndatiaku va ra, ra ta kuꞌva kachi ra xiꞌin ndo ke kuu va. Ra yaꞌa ndo kutoꞌni ndo nuu xindikaa ra, ra kuni ndo chi köo ka ra. ");
INSERT INTO mxv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ra vichin kama ni na kuꞌun ndo, ra ndatuꞌun ndo xiꞌin ndia xitaꞌan xiꞌin ra: “Saa chi xa ndatiaku va ra, ra xa chi Galilea va inuu ra kuaꞌan ra nuu ndo, ra ikan ndakutaꞌan tuku ndo xiꞌin va ra.” Ra takua ña yoꞌo ke ndatuꞌun yu xiꞌin va ndo ―*kachi ra tatun Ndioxi kan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ra saa kee na siꞌi kan ndakiꞌin na xinu na kuaꞌan na ndatuꞌun na xiꞌin ndia xitaꞌan xiꞌin Jesús, ña xa ndatiaku va ra. Ra tiaa ni iyuꞌvi na, ndi su tiaa ni kusii tu ini va na xaꞌa tuꞌun ña ndikaꞌan ra tatun Ndioxi kan. ");
INSERT INTO mxv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ra te saa kuu na ndoꞌni na ichi kan kuaꞌan na, saa ra tuꞌva kanata va Jesús nuu na, ra ndikaꞌan ndioxi ra xiꞌin na. Ra saa kuyachin na nuu ra, ra ndakusiti na ña ndanumi ndiaa na xaꞌa ra, ra ndasakaꞌnu ni na ra. ");
INSERT INTO mxv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Kuayüꞌvi ndo, ra vichin kuaꞌan ndo ndatuꞌun xiꞌin ndia ñani yu, chi xa ndatiaku va yu, ra na kuꞌun ndia chi Galilea, ra ikan ndakitaꞌan ndia xiꞌin yu, kachi ndo xiꞌin ndia ―*kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ra saa kuu na siꞌi kan ndoꞌni na ichi kuaꞌan na, ra saa kee sava ndia soldado, ndia ndee ndiaa yuꞌu yavi kan kuaꞌan ndia ñuu, ña ndatuꞌun ndia xiꞌin ndia xikuaꞌa, ndia kunaꞌnu nuu ndia sutu xaꞌa takundiꞌi ña xini ndia kuu. ");
INSERT INTO mxv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ra saa ndakutaꞌan ndia sutu kunaꞌnu kan xiꞌin ndia xikuaꞌa nuu na ñuu, ra ndikataꞌan ndia ndia kuꞌva ke sa ndia, ra saa kindoo ndia ña chaꞌvi ndia ndia soldado kan, ra saa taxi ndia kuaꞌa ni xuꞌun ndaꞌa ndia, ");
INSERT INTO mxv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ra ndikaꞌan ndia xiꞌin ndia kachi ndia saa: ―Kuaꞌan ndo vichin ra ndatuꞌun ndo xiꞌin takundiꞌi yuvi kachi ndo saa: “Kuni ndi ña na kundaa ini ndo, chi te naa loꞌo ini ndi ndikixi ndi ñuu, saa ra ndixaa va ndia xitaꞌan xiꞌin Jesús, ra xakuiꞌna va ndia iki kuñu ra kuaꞌan ña xiꞌin ndia”, kachi ndo xiꞌin takundiꞌi na. ");
INSERT INTO mxv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ra tu na kundaa ini ra tata gobernador xaꞌa ña yoꞌo, ra kuayüꞌvi ndo, saa chi kaꞌan mii va ndi xiꞌin ra, ra kuëe sa ra xiꞌin vi ndo ―kachi ndia xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ra saa kiꞌin ndia soldado kan xuꞌun ndaꞌa ndia kunaꞌnu kan, ra iin ta kachi ndia xiꞌin ndia ke xa ndixa va ndia. Ra tuꞌun chiꞌña ña ndatuꞌun ndia soldado kan ndixika ndia ke ndatuꞌun na judío ndia kii vichin va. ");
INSERT INTO mxv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ra saa kee soo uxi iin ndia xitaꞌan xiꞌin Jesús kuaꞌan ndia chi Galilea, ra ndixaa ndia ndakitaꞌan ndia xiꞌin ra iku nuu kindoo ra ña ndakitaꞌan ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ra te xini ndia ra, ra saa ndasakaꞌnu ni ndia ra, ra sava tu ndia iin xa uvi suꞌva ini va. ");
INSERT INTO mxv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ra saa kuyachin Jesús nuu ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ndaꞌa yuꞌu ke ndataxi Ndioxi takundiꞌi ndiayu ña kaꞌndia yu chiñu ndivi, ra saa tu nuu ña yuuvi yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ra vichin kuaꞌan ndo iinii kuvi ña yuuvi, ra sañaꞌa ndo takundiꞌi yuvi ña ndinuni ni na kundikun na yuꞌu, ra sakuchi ndo na tixi ndiee Tata yo Ndioxi, xiꞌin tixi ndiee Seꞌe ra, xiꞌin tixi ndiee Tachi Yii ra, ");
INSERT INTO mxv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ra na sañaꞌa ndo na, ña na kandixa na takundiꞌi chiñu ña ^xaꞌndia yu nuu ndo. Ra na kundaa ini ndo, saa chi iin ndisaa kii va kuiin yu xiꞌin ndo, ra iin saa ndia te na ndiꞌi xaꞌa ña yuuvi yoꞌo ―*kachi Jesús xiꞌin ndia xitaꞌan xiꞌin ra. Saa koo.");
INSERT INTO mxv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Suꞌva ke kuu te ndituvi tuꞌun vaꞌa xaꞌa Jesús, seꞌe Ndioxi, ra kixi sakaku yo. ");
INSERT INTO mxv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iin ta kachi tuꞌun Ndioxi, ña ndatiaa ra Isaías xinaꞌa, ndakani ña xaꞌa ña kuu, ra iin saa ke kuu ndixa va. Saa chi tuꞌun Ndioxi, ña ndatiaa ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ra suꞌva kachi ña ndakani ña: “Tiꞌvi yu iin ra kaꞌan ndoso tuꞌun yu kunuu kuꞌun nuu kun, ña ndasavii ra ichi nuu kuꞌun kun”, kachi Ndioxi xiꞌin Jesucristo kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ra ndikaꞌan tu ra Isaías xaꞌa ra kaꞌan ndoso, kunuu kixi yoꞌo, ra saa kachi ka ra saa: Ndiee ka vi kaꞌan iin tiaa ra ndikaa iku yuu ra kachi ra saa: “Ndasavii ndo ichi ndo, ra na koo tuꞌva nima ndo nuu Iva yo Ndioxi. Ndasandaku ndo ichi ndo nuu ra”, kachi ra Isaías, kachi tuꞌun Ndioxi ndakani ña. ");
INSERT INTO mxv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ra ta kachi tuꞌun Ndioxi ndakani ña, ra saa ndixa ke kuu va: saa kuu iin kii kita ra Juan iin iku yuu sakuchi ra yuvi, ra ndikaꞌan ndoso ra tuꞌun Ndioxi nuu na, ña na ndandiko ini na xaꞌa kuachi na, ra ndakuchi na, ra sakaꞌnu ini Ndioxi xaꞌa kuachi na kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ra kuaꞌa ka vi yuvi kuaꞌan nuu iin ra, iin takundiꞌi na ñuu ña ndikun ndiaa Judea, xiꞌin takundiꞌi na ñuu Jerusalén, kuaꞌan na nuu ra ña xini soꞌo na tuꞌun Ndioxi, ra naꞌma na kuachi na, ra saa xaꞌa ra sakuchi ra na itia Jordán. ");
INSERT INTO mxv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ra tikoto ña xindixi ra Juan, ra ixi ti camello ke kuvaꞌa ña, ra ñii camello ku tu ña xinuꞌni toko va ra, ra ñaꞌa ña yaxi ra xitiaku ra xikuu ti̱ka ndixaꞌan xiꞌin ñuñu ña iyoo iku. ");
INSERT INTO mxv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ra ndikaꞌan ndoso ra tuꞌun Ndioxi nuu yuvi, kachi ra saa: ―Chi sata yuꞌu ndikun iin tiaa ra kaꞌnu ni ka nuu yuꞌu vaxi ra, ra ndia nii chiñu loꞌo köo yaꞌvi ndiaa yu sa yu nuu ra, chi ra kaꞌnu ni kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ña ndixa ke yuꞌu, ra xiꞌin tiakuii va sakuchi yu ndoꞌo, su ndi ra kan, ra xiꞌin Tachi Yii Ndioxi va ke sakuchi ra ndoꞌo ―kachi ra Juan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Saa kuu kee Jesús ñuu Nazaret ña ndikaa chi Galilea ra ndixaa ra yuꞌu itia Jordán, ra ikan kuchi ra xa ra Juan. ");
INSERT INTO mxv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ra te kanata suꞌva Jesús ini tiakuii vaxi ra, saa xini ra ndanuña ndivi, ra ta kaa iin sata loꞌo, saa kaa Tachi Yii Ndioxi vaxi nuu ña sata ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ra tiaku ndikaꞌan Ndioxi xiꞌin ra ndia ndivi, kachi ra saa: ―Yoꞌo ku Seꞌe mii yu ra kuꞌvi ni ini yu xini yu yoꞌo. Ra kusii ni ini yu xiꞌin kun, ―kachi Ndioxi xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te ndiꞌi kuchi Jesús, saa ndakiꞌin Tachi Yii Ndioxi ra, kuaꞌan ra chi iku yuu. ");
INSERT INTO mxv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ra iku yuu kan ndixiyo ra uvi xiko kii. Saa ra xaa va ña ndivaꞌa ixtondoso ña ra, ña na ndakava ra kuni ña, ra iku yuu kan ndixiyo mituꞌun saa ra, ra takua kiti iku va kuvi ri ndee nuu ndixiyo Jesús. Ra saa xaa na tatun Ndioxi ña chindiee taꞌan na xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ra saa kuu te ndikita ra Juan veꞌe kàà xa ra Herodes, ra saa ndakiꞌin Jesús kuaꞌan ra chi Galilea. Ra ikan xaꞌa ra ndikaꞌan ndoso ra tuꞌun vaꞌa ña taxi Ndioxi nuu na yuvi, ra xaꞌa ra ndakani ra ndia kuꞌva ke xaꞌndia chiñu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ra kaꞌan ndoso ra nuu na kachi ra saa: ―Xa nditiandiaa kii kuu ña ndikaꞌan Ndioxi kuu, ra xa kuyachin kii ña kaꞌndia Ndioxi chiñu nuu ndo; nandiko ini ndo xaꞌa kuachi ndo, ra kandixa ndo tuꞌun vaꞌa ña taxi Ndioxi xiꞌin ndinuni nima ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saa kuu iin kii xika Jesús kuaꞌan ra yuꞌu tiañuꞌu ra ndikaa Galilea, ra ikan xini ra ra Simón xiꞌin ra Andrés ñani ra, ña xika ndia tiin ndia tiaka, ra koꞌni ndia inu ndia ini tiakuii kan ña tiin ndia tiaka. Chi ña kan ku chiñu va ndia. ");
INSERT INTO mxv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Naꞌa ndo, na kuꞌun yo xiꞌin yu, ra sañaꞌa yu ndoꞌo ndia kuꞌva ke ndatuꞌun ndo xiꞌin yuvi ra ndakundikun na yuꞌu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Saa ra ndikun ndakoo ndia inu ndia ña tiin ndia tiaka, ra ndakundikun ndia ra kuaꞌan ndia xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ra iin vivii loꞌo ndiyaꞌa Jesús kuaꞌan ra, saa ra xini tu ra ra Jacobo va xiꞌin ra Juan, ñani ra, ndia seꞌe ra Zebedeo ña ndoꞌni ndia ini barca ndakaꞌma ndia inu ndia ña tiin ndia tiaka. ");
INSERT INTO mxv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Saa kana ra ndia, ña na kuꞌun ndia xiꞌin ra. Saa ra ndikun ndakoo ndia ra Zebedeo, iva ndia, xiꞌin ndia xachiñu xiꞌin ndia ini barca kan, ra ndakiꞌin ndia kuaꞌan ndia xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Saa ndixaa Jesús ñuu Capernaum xiꞌin ndia kuaꞌan xiꞌin ra. Ra te nditiandiaa kii yii sábado, saa ndikiꞌvi ra ini veꞌe ñuꞌu nuu ndakutaꞌan na ñuu kan, ra xaꞌa ra sañaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ra ndakanda ka vi ini na ña xini soꞌo na kuꞌva ke sañaꞌa ra na, saa chi iin ta kaꞌan na kuu mii ndiayu iin saa kaꞌan ra; xä ra ta xa na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés. ");
INSERT INTO mxv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ra ini veꞌe ñuꞌu kan nduꞌu iin tiaa ra tiin tachi ndivaꞌa, ra saa ndiee ka vi nindaꞌyu tachi ndivaꞌa kan kachi ña saa xiꞌin Jesús: ");
INSERT INTO mxv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Nichuun vaxi kun sataꞌan kun nduꞌu, Jesús, ra kee ñuu Nazaret? ¿A vaxi kun sandiꞌi kun xaꞌa ndi? Chi xini va ndi yo kuvi yoꞌo: Yoꞌo kuvi ra yii, ra kee nuu Ndioxi ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Saa nindaꞌyu Jesús nuu ña ndivaꞌa kan, kachi ra saa xiꞌin ña: ―¡Koyaa yuꞌu kun! ¡Kanata ini ra tiaa ñaa, ra kuaꞌan! ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndia saa ra xaꞌni yiꞌi ña ra tiaa yoꞌo, ra iin cho choꞌo kuun ña ra, ra iin kokoꞌo nindaꞌyu ña, saa kita ña ini ra tiaa yoꞌo, kuaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ra ndakanda ka vi ini takundiꞌi na yuvi ndee kan, ra xaꞌa na iin ndakatuꞌun taꞌan na kachi na saa: ―¿Ni ke yoꞌo? ¿Ndia sañuꞌu xaa ke sañaꞌa ra tiaa yoꞌo, ña iyoo ni ndiee ra, saa chi ndia tachi ndivaꞌa, ra xaꞌndia ra chiñu nuu ña, ra kandixa ña ña kaꞌan ra xiꞌin ña? ―kachi na xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ra iin vichin vichin ndindutia ndoso tuꞌun xaꞌa Jesús iin takundiꞌi ñuu ña ndoꞌni chi Galilea. ");
INSERT INTO mxv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ra te kita Jesús ini veꞌe ñuꞌu kan, saa ndakiꞌin ra kuaꞌan ra xiꞌin ra Jacobo, xiꞌin ra Juan, ra ndixaa ndia veꞌe ra Simón xiꞌin ra Andrés ñani ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ra ndiee ka vi ndoꞌo ña siso ra Simón kanduꞌu ña xiꞌin kaꞌni, iin ndiakua ndatuvi ña xiꞌin ña te ndixaa ndia. Ra saa ndikun ndikaꞌan na xiꞌin Jesús xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Saa kuyachin Jesús nuu kanduꞌu ña, ra tiin ra ndaꞌa ña, ra ndoniꞌi ra ña, saa ra ndikun nduvaꞌa va ña, ra xaꞌa ña xavii ña kuxi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ra te xa kuaa ndikita ñuꞌù kii kan, saa ndi̱xaa na yuvi xiꞌin takundiꞌi na xiꞌi, xiꞌin na tiin tachi ndivaꞌa nuu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ra iin ndakutu ndaa nuu keꞌe veꞌe nuu iin Jesús xiꞌin takundiꞌi na ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ra sandaꞌa Jesús kuaꞌa ni na xiꞌi, na ndoꞌo ndia ndia ka mii nuu kueꞌe va. Ra sanduvaꞌa tu ra kuaꞌa ni na tiin tachi ndivaꞌa va. Ra nditäxi ra ña na kaꞌan ña xiꞌin ra, chin tachi ndivaꞌa kan, ra xini va ña ra, ña kuu ra Seꞌe Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Iin kii, ra ñaꞌa ka vi ndakoò Jesús kuaꞌan ra chi iku nuu köo yuvi, kaꞌan ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ra saa xaꞌa ra Simón xiꞌin ndia itaꞌan xiꞌin ra nanduku ndia Jesús xika ndia. ");
INSERT INTO mxv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ra te ndaniꞌi ndia ra, saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, iin takundiꞌi yuvi xika ndanduku yoꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Naꞌa ndo, na kuꞌun yo ñuu ña ndoꞌni yachin yoꞌo, ra kaꞌan ndoso yu tuꞌun Ndioxi nuu na, chi xaꞌa ña yoꞌo ke vaxi chiñu va yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ra ndixika Jesús iinii kuvi ñuu ña ndoꞌni chi Galilea ta veꞌe ñuꞌu ta veꞌe ñuꞌu, ndikaꞌan ndoso ra tuꞌun Ndioxi, ra sanduvaꞌa tu ra yuvi na tiin tachi ndivaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Saa kuu ndixaa iin ra ndoꞌo kueꞌe tiaꞌyu, xikusiti ra nuu Jesús. Ra xakundaꞌvi ra kachi ra saa: ―Tata, tu kuni kun, ra na sandaꞌa va kun yuꞌu chi xa xini va yu ña iyoo ni ndiee kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Saa kundaꞌvi ni ini Jesús xini ra ra. Saa nditiandiaa ndaꞌa ra ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kuni va yu sandaꞌa yu yoꞌo, na nduvaꞌa kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ra te kachi Jesús saa xiꞌin ra, saa ra ndikun nindoñuꞌu va ña tiaꞌyu kan, ra ndikun nduvaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Saa ndatiꞌvi Jesús ra kuanuꞌu ra veꞌe ra. Ra ndikaꞌan ka vi ra xiꞌin ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Kuaꞌan, ra ndia nii na ndatüꞌun kun xiꞌin xaꞌa ña sandaꞌa yu yoꞌo. Ra takua nuu ra sutu va, na kuꞌun kun, ra na kuni ra ña xa nduvaꞌa kun, ra kaniꞌi kun ñaꞌa ña soko kun xaꞌa ña xa nduvaꞌa kun xa Ndioxi, ta kuꞌva kachi ley Ndioxi ña ndakoo ra Moisés te yachi; ra na kundaa ini ndia sutu ña xa nduvaꞌa kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Su ndi te ndakiꞌin ra tiaa yoꞌo kuaꞌan ra, saa ra xaꞌa ra ndikun ndatuꞌun ra xiꞌin takundiꞌi yuvi xaꞌa ña xa Jesús xiꞌin ra. Ra ña kan ke ndiküvi ka kiꞌvi Jesús ndia ndia ka ñuu nuu xaa ra, chi ndia nuu ñuu va xaa ra xikoo ra. Ndia iku nuu köo yuvi ndee va xaa ra. Ra iin takundiꞌi ñuu kee yuvi kuaꞌan na nuu ra, iku kan. ");
INSERT INTO mxv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ra saa kuu ndiyaꞌa ndiaꞌvi kii, saa ndiko tuku Jesús ndaxàà ra ñuu Capernaum. Ra te kundaa ini na yuvi ña ndúꞌu̱ ra veꞌe ");
INSERT INTO mxv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","saa ra ndikun iin taxi taꞌan na yuvi xaa na nuu íin ra. Ra iin chitu ndaa veꞌe xiꞌin na, ra ndia nuu keꞌe ka kïta kuita na; ra kaꞌan ndoso Jesús tuꞌun Ndioxi nuu na. ");
INSERT INTO mxv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Saa kasoko kumi tiaa iin ra nduchiꞌña kuvita ndaꞌa, kuvita xaꞌa, küvi kaka, ra kanduꞌu ra nuu ixto ndixaa ra xiꞌin ndia nuu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Su ndi ndiküvi tiandiaa na xiꞌin ra ndia nuu íin Jesús, chi iin chitu ndaa yuvi, saa ra ndaa na chi xi̱ni̱ veꞌe nuu íin Jesús, ra kaan na iin yavi, ra yavi kan sanuu na ixto ra küvi kaka kan. ");
INSERT INTO mxv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Saa te xini Jesús ña ndinuni ni kandixa na yuvi kan ña iyoo ndie̱e̱ ra ña kuvi sandaꞌa ra, ra nduchiꞌña kan, ra saa ndikaꞌan ra xiꞌin ra nduchiꞌña kan kachi ra saa: ―Seꞌe, xa xakaꞌnu va ini yu xaꞌa kuachi kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ra ikan ndee sava na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, ra xaꞌa ndakani ini na kaꞌan na saa: ");
INSERT INTO mxv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nichuun kachi ra yoꞌo saa xiꞌin ra kaa? Chee ni kuachi ke yoꞌo nuu Ndioxi chi ndia nii yuvi köo ichi sakaꞌnu ini xaꞌa kuachi yo, chi indaa mituꞌun Ndioxi va ku ra iyoo ichi sakaꞌnu ini xaꞌa kuachi yo”, kaꞌan na ndakani ini na. ");
INSERT INTO mxv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Saa ra ndikun kundaa va ini Jesús ña ndakani ini na, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―¿Nichuun ndakani ini ndo ña köo ichi yu sa yu ña yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ni ke vaꞌa kachi yu xiꞌin ra nduchiꞌña yoꞌo, tuvi ndo? Chi “xa xakaꞌnu ini yu xaꞌa kuachi kun”, kachi yu, ra kundäa ini ndo. Ra a vaꞌa ka tu na kaꞌan yu xiꞌin ra: “Ndakoò ndakiꞌin ixto kun ra kuanu̱ꞌu̱”, kachi yu xiꞌin ra. Ra saa ke kundaa ini ndo ña iyoo ndiayu yu. ");
INSERT INTO mxv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ra nuu ndo saa, na sandaꞌa yu ra, ra saa ke na kundaa ini ndo, chi yuꞌu, ra xaa yoꞌo, ra kuu mii yu ndiayu ña sakaꞌnu ini yu xaꞌa kuachi yuvi na ndee nuu ñuꞌu yoꞌo ―kachi Jesús xiꞌin na. Ra saa ndikaꞌan Jesús xiꞌin ra nduchiꞌña küvi kaka kan, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Yoꞌo ku ra kaꞌan yu xiꞌin: ndakoo, ra ndakiꞌin ixto kun, ra kuanuꞌu veꞌe kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Saa ra ndikun ndakoò ra nduchiꞌña kan ra ndakiꞌin ra ixto ra, ra ndakiꞌin ra kuanuꞌu ra, ra xini takundiꞌi na yuvi kan. Ra ndakanda ka vi ini na, ra ndasakaꞌnu ka vi na Ndioxi kachi na saa: ―¿Ni ke yoꞌo? chi ndia nii kii täan kuni yo ña ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ra te ndiꞌi saa ndiko tuku Jesús kuaꞌan ra chi yuꞌu tiañuꞌu. Ra iin takundiꞌi yuvi kuaꞌan nuu ra, ra sañaꞌa ra tuꞌun Ndioxi na. ");
INSERT INTO mxv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ra saa te ndiyaꞌa Jesús kuaꞌan ra, saa xini ra iin ra nani Leví, seꞌe ra Alfeo, ra ndiso chiñu kaya xuꞌun nuu na ñuu ña kuaꞌan ndaꞌa gobierno ñuu Roma. Ra ^nduꞌu ra nuu mesa nuu ndakiꞌin ra xuꞌun ndaꞌa na yuvi, ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Kundikun yuꞌu. Na koꞌo xiꞌin yu ―kachi ra xiꞌin ra. Saa ra ndikun ndakundichi ra Leví ra ndakiꞌin ra kuaꞌan ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Saa kuu iin kii ^nduꞌu Jesús nuu mesa xixi ra veꞌe ra Leví. Ra ndee tu na kiꞌin xuꞌun nuu yuvi va xiꞌin ra, ra ndee tu na ^nduꞌu tuꞌun kiꞌvi xaꞌa va xiꞌin ra nuu mesa, ra ndee tu na ndikun sata va ra xiꞌin ra, saa chi kuaꞌa ni kuvi yuvi ndikun kuaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ra saa te xini na maestro sañaꞌa ley Ndioxi, xiꞌin na fariseo, ña ^nduꞌu Jesús xixi ra xiꞌin na yuvi kuachi, ra saa ndikaꞌan na xiꞌin ndia xitaꞌan xiꞌin ra kachi na saa: ―¿Nichuun nduꞌu ra tata maestro ndo xixi ra xiꞌin na yuvi nduꞌu tuꞌun kiꞌvi xaꞌa, xiꞌin na yuvi kuachi, ―kachi na xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ra ta xini soꞌo Jesús ña ndikaꞌan na, saa ra ndakuiin ra yuꞌu na kachi ra saa: ―Yuvi na iyoo vaꞌa ini ra xiniñüꞌu vi na kan kutatan na, chi na ndiee ndoꞌo va kuvi na xiniñuꞌu kutatan. Ra yuꞌu, ra süvi xaꞌa na vaꞌa, na köo kuachi ke vaxi yu, chi xaꞌa na iyoo kuachi va ke xaa yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saa kuu iin kii iyoo suꞌun ndia itaꞌan xiꞌin ra Juan, ra sandakuchi yuvi, ra iyoo suꞌun tu na itaꞌan xiꞌin na fariseo va, ra saa kee sava na ndixaꞌan na nuu iin Jesús ra ndindakatuꞌun na ra kachi na saa: ―¿Nichuun ra ndia itaꞌan xiꞌin ra Juan, xiꞌin ndia itaꞌan xiꞌin na fariseo, ra iyoo suꞌun va na kan, chin kuëe xixi ndia, ra ndia itaꞌan xiꞌin yoꞌo, ra iyöo suꞌun tu na yoꞌo? ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A vaꞌa tu na koo suꞌun na ndee nuu iyoo viko tandaꞌa, tuvi ndo, ña ndee na kusii ini na xiꞌin migo na ra tandaꞌa? Su küvi, chi ta iin ka va ra, ra takundiꞌi kii ra na ndee kusii ini va kuvi na, ra küvi koo suꞌun na, ña küxi na. ");
INSERT INTO mxv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ndi su te na xaa kii ña kuꞌun ra tandaꞌa kan nuu na, saa ra kindoo mii va na, ra ndia saa vi ke kuvi koo suꞌun na, küxi na. ");
INSERT INTO mxv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ndia nii yuvi ra ndakäꞌma na tikoto yata xiꞌin tikoto xaa, chi tu saa na sa na, saa ra nandii va tikoto xaa, ra ndandata vaꞌa ka va ña tikoto yata. ");
INSERT INTO mxv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ra ndia nii tu na täân vino xaa ini ñii̱ yata, chi tu saa na sa na, saa ra ndata va ñii̱ yata sa ra, ra ku̱tia ndiꞌi va vino, ra ndiꞌi xaꞌa tu mii va ñii̱ kan, ña kan ke vino xaa, ra ini ñii̱ xaa va ke xiniñuꞌu kundoꞌni ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Saa kuu iin kii sábado, kii yii, ndiyaꞌa Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra iin nuu iyoo itu trigo, ra saa xaꞌa ndia xika xiꞌin ra xaꞌnu ndia yo̱ko̱ itu trigo kan ra sakoyo ndia ña kaxi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ra saa, ndikaꞌan na fariseo xiꞌin Jesús kachi na saa: ―Toꞌni, ¿nichuun xa ndia itaꞌan xiꞌin kun saa? Chi köo ndiayu ndaꞌa yo ña sa yo saa kii yii sábado, chi kii ndakindiee̱ va yo ke ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Saa ndakuiin Jesús yuꞌu na kachi ra saa: ¿A ndia nii va ichi täan kaꞌvi ndo tuꞌun Ndioxi ña ndakani xaꞌa ra Rey David, te ninïꞌi ra ña kuxi ra xiꞌin na kuaꞌan xiꞌin ra? ");
INSERT INTO mxv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chi suꞌva va ke kachi tuꞌun Ndioxi ndakani ña: “Ra Rey David, ra ndikiꞌvi va ra ini veꞌe ñuꞌu Ndioxi, te kuu ra Abiatar sutu ra kuchee nuu takundiꞌi na sutu, ra kiꞌin ra Rey David ixtavaꞌa yii ña soko na nuu Ndioxi iyoo ini veꞌe ñuꞌu kan xixi ra, ra köo ndiayu ra ña kuxi ra ña, chi indaa na sutu va kuvi na iyoo ichi kuxi ña, ra xixi tu na kuaꞌan xiꞌin va ra ña xiꞌin ra”, ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndioxi xakin ra kii yii sábado, ña kutaꞌvi yo ña vaꞌa; ndi ndixäkin ra kii yii ña sandoꞌo ra yoo. ");
INSERT INTO mxv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ra xaꞌa ña kan ke yuꞌu, ra xaa yoꞌo, ra kachi yu suꞌva: chi yuꞌu kuvi ra iyoo ni ka ndiayu ndaꞌa xaꞌa kii yii sábado, ndia ña ke kuvi sa yo, ra ndia ña ke küvi sa yo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saa kuu iin kii ndixaa tuku Jesús ini veꞌe ñuꞌu, ra ini veꞌe ñuꞌu kan nduꞌu iin tiaa ra ndachi ndaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ra iin suꞌva nuu na fariseo ña ixtonani na Jesús, a sandaꞌa ra ra kue̱ꞌe ndaꞌa kan kii yii sábado, ra saa ke kuvi ni̱ꞌi̱ na kuachi taxi na xaꞌa Jesús, kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Saa ndikaꞌan Jesús xiꞌin ra kue̱ꞌe ndaꞌa kan, kachi ra saa: ―Ndakundichi, ra naꞌa chi maꞌñu yoꞌo ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ra saa ndindakatuꞌun Jesús na ndee kan, kachi ra saa: ―¿Ni ke iyoo ndiayu sa yo kii yii: a ña vaꞌa, a ña väꞌa? ¿Ni ke vaꞌa sa yo: a chindiee taꞌan yo xiꞌin yuvi, a sandiꞌi yo xaꞌa na? ¿Ni ke vaꞌa tuvi ndoꞌo? ―kachi ra xiꞌin na. Ra ndia nii mii tuꞌun na ndindäkuiin. ");
INSERT INTO mxv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Saa xakueꞌe ni Jesús ixtoꞌni ra nuu takundiꞌi na ndee kan, ra kusuchi ni tu ini ra xiꞌin va na xaꞌa ña ndiee ni ini na; chi xïin na kandixa na ña kaꞌan ra. Saa ndikaꞌan ra xiꞌin ra kue̱ꞌe ndaꞌa kan, kachi ra saa: ―Sandakaa ndaꞌa kun ―kachi ra xiꞌin ra. Ra saa sandakaa tiaa kan ndaꞌa ra, ra ndikun nduvaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ra te ndakoyo na fariseo chi keꞌe, ra ndakutaꞌan na xiꞌin na partido na ndikun sata ra Herodes ra xaꞌa na kataꞌan na ndixa koo kaꞌni na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Saa ndakoo Jesús ñuu kan, ra ndakiꞌin ra kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra chi yuꞌu tiañuꞌu. Ra kuaꞌa ka vi na kee Galilea xiꞌin Judea, ra ndikun na sata ra kuaꞌan na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ra te nindutia ndoso tuꞌun xaꞌa Jesús ra kundaa ini takundiꞌi yuvi ña kuaꞌa ni ña ndichi xa ra, saa ra iin tiaꞌndia chee na yuvi ndixaa nuu ra, na kee Judea, na kee ñuu Jerusalén, na kee Idumea, na ndee chi inka xiyo yuꞌu itia Jordán, xiꞌin na kee ñuu ña ndikun ndiaa Tiro xiꞌin Sidón. ");
INSERT INTO mxv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ra saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, ña xa na koo nduvi ndia xiꞌin iin barca loꞌo, tu xika nuu mini, kundikaa ra kaꞌan ndoso ra, chi koto kundiëe ra xiꞌin na, ra ndaa na sata ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chi xaꞌa ña xa sanduvaꞌa ra kuaꞌa ni na xiꞌi ke iin takundiꞌi ka na ndiee ndoꞌo, ra iin taꞌvi taꞌan na kuaꞌan na sata ra, ña kuni na tiandiaa ndaꞌa na ra, ra nduvaꞌa na kuni na. ");
INSERT INTO mxv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ra te kuyachin na ndoꞌo kueꞌe tachi ndivaꞌa nuu Jesús, ra ndikun iin xikusiti tachi ndivaꞌa ñuꞌu ini na kan nuu ra. Ra iin kokoꞌo ndaꞌyu ña kachi ña saa xiꞌin ra: ―Yoꞌo ku seꞌe Ndioxi ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ra ndukueꞌe Jesús xiꞌin tachi ndivaꞌa kan, ña na käꞌan ña yo kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te ndiꞌi, saa ndaa Jesús iin xiki. Ra ikan kana ra ndia kuni mii ra kana ra, ra saa ndixaa ndia nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ra ndakaxin ra uxi uvi ndia kaka tuun xiꞌin ra, ra tiꞌvi tu ra ndia ña kuꞌun ndia kaꞌan ndoso ndia tuꞌun Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ra taxi ra ndiayu ndaꞌa ndia ña sanduvaꞌa ndia na ndiee ndoꞌo, xiꞌin ña tava tu ndia tachi ndivaꞌa ini yuvi na ñuꞌu ña ini. ");
INSERT INTO mxv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ra ndia yoꞌo ku ndia ndikaxin ra kaka xiꞌin ra, ra suꞌva ke nani ndia: Iin ra nani Simón, ra ndasama Jesús kivi ra ndakunani ra Pedro, ");
INSERT INTO mxv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","iin ra nani Jacobo, iin ra nani Juan, ñani suvi ra Jacobo, ndia seꞌe ra Zebedeo, ndia chinduꞌu Jesús kivi nani Boanerges, ra tuꞌun yoꞌo kachi ña saa: Seꞌe taxa ña ndaꞌyu ndivi; ");
INSERT INTO mxv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ra iin ra nani Andrés, iin ra nani Felipe, iin ra nani Bartolomé, iin ra nani Mateo, iin ra nani Tomás, iin ra nani Jacobo, ra seꞌe ra Alfeo; iin ra nani Tadeo, iin ra nani Simón ra ndixika xiꞌin na partido Cananista, ");
INSERT INTO mxv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ra iin ra nani Judas Iscariote, ra ndixiko Jesús te ndiꞌi. Ra te ndiꞌi ndikaxin Jesús ndia kaka xiꞌin ra, ra saa nandiko ndia ndaxaa ndia chi veꞌe. ");
INSERT INTO mxv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ra kuaꞌa ka vi yuvi ndakaya tuku, ra nii nuu kuxi ka Jesús xiꞌin ndia itaꞌan xiꞌin ra küvi. ");
INSERT INTO mxv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ra saa te kundaa ini na taꞌan Jesús xaꞌa ña xa ra, saa ra, ndixaa na ña kuni na ndakiꞌin na ra kuꞌun ra xiꞌin na, chi ra xaꞌa kukiꞌvi va kuvi ra kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ra na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, ra ndia ñuu Jerusalén ke kee na ra ndixaa na nuu xika ra, ra kachi na saa: ―Ndie̱e̱ ti Beelzebú, mii ti kuchee vaꞌa nuu takundiꞌi ña ndivaꞌa va, ke iyoo xiꞌin ra, ña kan ke vaꞌa tava ra tachi ndivaꞌa ―kachi na xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Saa ndakana Jesús yuvi kan ña na kuyachin na. Ra ndikaꞌan ra iin tuꞌun ndichi xiꞌin na kachi ra saa: ―¿Ndixa sa ti ndivaꞌa ña sandiꞌi ri xaꞌa inka ti ndivaꞌa taꞌan ri, tuvi ndoꞌo? Su küvi. ");
INSERT INTO mxv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chi iin ñuu nuu kataꞌan xiꞌin taꞌan mii na yuvi, ra kuchüun na ña koo na, chi ndiꞌi xaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ra saa tu iin veꞌe va. Tu na kataꞌan xiꞌin taꞌan mii na, saa ra kuchüun na koo na chi ndiꞌi xaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ra kuꞌva saa ke iyoo tu ti ndivaꞌa va. Tu na ndukuiin ri taꞌvi taꞌan ri, ra kataꞌan xiꞌin taꞌan mii ri, saa ra kuchüun ri koo vi ri, chin ndiꞌi xaꞌa va ri ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Ndia nii yuvi ra küvi kiꞌvi na veꞌe iin tiaa ra ndaku ni sakuiꞌna na ñaꞌa ña kuu mii ra, tu na chikätun na ra; chi xiꞌna ka va xiniñuꞌu katun na ra, ra te ndiꞌi, saa vi ke kuchuun na kiꞌvi na veꞌe ra sakuiꞌna na. ");
INSERT INTO mxv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ra kuni yu kaxi ni na kindoo ña yoꞌo nuu ndo, chi ña yoꞌo ra süvi siki kuvi ña: chi takundiꞌi ka kuachi ña xa na yuvi yoꞌo, xiꞌin ña ndaa yuꞌu na Ndioxi, ra koo kaꞌnu va ini Ndioxi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Su ndi yuvi na ndaa yuꞌu tu Tachi Yii Ndioxi, ra kaꞌan ndivaꞌa na xaꞌa ña, ra köo kaꞌnu ini Ndioxi xaꞌa na kan, ndia nii kii, ndia nii tiempo, chi ña yoꞌo kuu kuachi na ña kuiso na xiꞌin iin ndisaa kii va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ra suꞌva ke kachi Jesús xiꞌin na, saa chi ndikaꞌan na ña iyoo ndie̱e̱ ti ndivaꞌa xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ra saa xaa siꞌi Jesús, xiꞌin na ñani ra. Ra xikundita na chi keꞌe, ra tiꞌvi na iin na kuaꞌan kaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Saa ndikaꞌan na xinunduu ndee kan xiꞌin Jesús, kachi na saa xiꞌin ra: ―Chi keꞌe xaa siꞌi kun xiꞌin ñani kun nanduku na yoꞌo ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Saa ndakuiin ra kachi ra saa xiꞌin na: ―¿Yoo ku na kuu siꞌi yu, ra yo ku na kuu ñani yu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Saa ndakotoꞌni ra nuu na ndee xini soꞌo ña kaꞌan ra, ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―Na yoꞌo va ku siꞌi yu xiꞌin ñani yu. ");
INSERT INTO mxv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi takundiꞌi na xanduvi ña kaꞌan Ndioxi va kuvi ñani yu, xiꞌin kuꞌva yu, xiꞌin siꞌi yu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Saa kuu, ra ndixaa tuku Jesús yuꞌu mini kan, ra xaꞌa ra sañaꞌa ra na. Ra kuaꞌa ka vi ku na ndakaya tuku. Iin chitu ndaa na yuꞌu mini kan, saa ndaa ra ndakunduꞌu ra ini itun xika nuu mini, ra na yuvi kan xikundita yuꞌu mini kan va. ");
INSERT INTO mxv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ra kuaꞌa ka vi tuꞌun ndichi xaꞌa ra sañaꞌa ra na. Ra saa ndikaꞌan ra iin tuꞌun ndichi xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tiaa soꞌo ndo; na ndatuꞌun yu iin tuꞌun ndichi xiꞌin ndo. Saa kuu, ra kee iin ra chiꞌi kuaꞌan ra chiꞌi ra itu trigo. ");
INSERT INTO mxv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ra saa kuu ra xatia yava ra nuni vali kan kuaꞌan ra, ra sava ña ndikoyo yachin yuꞌu ichi, ra xaa sàà ra ndakiꞌin ri ña xaxi ri. ");
INSERT INTO mxv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ra sava tu ña ndikoyo nuu iyoo yuu va, nuu köo kuaꞌa ñuꞌú, ra kama ni nindutia ña, chi yaxin ni ndúꞌu̱ ñuꞌú. ");
INSERT INTO mxv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Su ndi te kanata ñuꞌù, saa ra xii va ña, chi künu ndoꞌni tioꞌo ña, ña kan ke ndachi̱ ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ra sava tu ña ndikoyo nuu iyoo ndikin ìñu̱, ra te nindutia ña, ra ndiküvi kuaꞌnu ña, saa chi ìñu̱ kan va sanduxin ñaꞌa, saa ra ndiꞌi xaꞌa va ña, ra nditäxi ka ña nuni. ");
INSERT INTO mxv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ra sava tu ña ndikoyo nuu ñuꞌú xaꞌan va, ra vaꞌa ka vi xaꞌnu ña, ra kuchuun ka vi ña, chi indaa tata ra taxi ña ndia oko uxi nuni, xiꞌin ndia uni xiko nuni, xiꞌin ndia iin ciento nuni vali taxi ta iin, ta iin ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Saa ndikaꞌan ka ra xiꞌin na, kachi ra saa: ―Ndoꞌo, na xini soꞌo ña kaꞌan yu xiꞌin ndo yoꞌo, ra ndakiꞌin xini ndo xiꞌin ña ni ke kuni kachi ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te ndiꞌi nindutia ndiꞌi na yuvi kan kuaꞌan na, ra nindoo mituꞌun saa Jesús, saa ndakutaꞌan sava na nindoo ndee kan, xiꞌin uxi uvi saa ndia itaꞌan xiꞌin ra, ra ndindakatuꞌun na ra xaꞌa tuꞌun ndichi kan, ni ke kuni kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Ndoꞌo, ra mii Ndioxi va ku ra taxi ndiayu ndaꞌa ndo ña na kundaa ini ndo xaꞌa ichi mii ra ña iyoo seꞌe nuu xaꞌndia ra chiñu. Su ndi yuvi na iyoo chi keꞌe, ra täxi ra ña ndaꞌa na kan, ra xaꞌa ña kan ke takundiꞌi ña kuni yu kaꞌan yu xiꞌin na, ra xiꞌin tuꞌun ndichi va ke kaꞌan yu ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ra vaꞌa ni ixtoꞌni tieꞌe va na, su ndi kundäa ini na xiꞌin ña, ra nii xini soꞌo va na, su ndi ndakïꞌin xini na xiꞌin ña, ra saa ke na kuïin na ndandiko ini na xaꞌa kuachi na nuu Ndioxi, ra sakäꞌnu ini ra xaꞌa na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―¿Tu kundäa ini ndo xiꞌin tuꞌun ndichi yoꞌo, saa ra, ndixa sa ndo ña kundaa ini ndo xiꞌin sava ka tuꞌun ndichi, tu saa? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Saa xaꞌa ra ndakani ra nuu na kachi ra saa: ―Ra chiꞌi nuni vali kan ku na kaꞌan ndoso tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ra ñuꞌu yuꞌu ichi kan kuvi yuvi na xini soꞌo tuꞌun Ndioxi. Su te ndiꞌi xini soꞌo na ña, saa ra ndikun vaxi ti ndivaꞌa sandaꞌvi ri na, ra kandïxa ka na tuꞌun Ndioxi ña xini soꞌo na. ");
INSERT INTO mxv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ra ñuꞌú nuu iyoo yuu kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ra kusii ka vi ini na, ra ndikun ndakiꞌin va na ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Su ndi te vaxi tundoꞌo nuu na, a te xaꞌa yuvi kataꞌan na xiꞌin na xaꞌa ña ndikun na ichi Ndioxi, saa ra ndikun ndiko ini va na, ra ndakoo va na ña, saa chi künu ndoꞌni tioꞌo ña, xaꞌa ña kan ke kuchüun na ña tuun vaꞌa kuita na. ");
INSERT INTO mxv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ra ñuꞌú nuu iyoo ìñu̱ yoꞌo kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ra ndakiꞌin na ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Su ndi xaꞌa ndakundiꞌi ini na xaꞌa ñaꞌa ña iyoo nuu ña yuuvi yoꞌo va, ra ndakundiꞌi tu ini na xaꞌa ña kuika va, ra xaꞌa kutoo na koo takundiꞌi ñaꞌa ña savi va nuu na, ra ña yoꞌo va xaꞌa ndiꞌi ini na xaꞌa. Saa ra kuee kuee naa ini va na xaꞌa ichi Ndioxi, ra ndiꞌi xaꞌa va na, saa ra, köo ka ñaꞌa kuun ndaꞌa vi tata yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ra ñuꞌú xaꞌan kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ra kandixa na ña kaꞌan ña. Ra na yoꞌo kuvi na iyoo ta kuꞌva iyoo tata ña vaꞌa ni xaꞌnu, ra ndia oko uxi, ndia uni xiko, xiꞌin ndia iin ciento nuni vali taxi mituꞌun mituꞌun ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Saa ndikaꞌan ka tuku Jesús xiꞌin na kachi ra saa: ―Köo iin yuvi na tuun ñùꞌù, ra ndasi tu na nuu ña xiꞌin xikoꞌo; ra nii chikäa tu na ña tixi ixto, chi nuu sukun va chinduꞌu na ña, ra vaꞌa tuun ña nuu na. ");
INSERT INTO mxv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ra saa ke iyoo tu ñaꞌa ña iyoo seꞌe va, chi vaxi kii ra ndatuvi ndiꞌi va xaꞌa ña, ra saa tu ñaꞌa ña kundäa ini yuvi xaꞌa va, chi vaxi kii ra kundaa ini na xaꞌa takundiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ndoꞌo, na xini soꞌo ña kaꞌan yu xiꞌin ndo yoꞌo, ra ndakiꞌin xini ndo xiꞌin ña ni ke kuni kachi ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ra ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Tiaa ni soꞌo ndo ña kaꞌan yu xiꞌin ndo yoꞌo. Chi ta kuꞌva xa ndo xiꞌin inka yuvi, ra saa ke sa tu Ndioxi xiꞌin ndoꞌo va, ra ndia ndakunuu ka va siki ña ndakiꞌin ndoꞌo sa ra. ");
INSERT INTO mxv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi na xa iyoo ñaꞌa nuu, ra ni̱ꞌi̱ ka na taꞌan va ña; ra na köo ñaꞌa nuu, ra ndia ña loꞌo ña xa iyoo nuu na ke nundiaa ndaꞌa va na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Saa ndikaꞌan tuku Jesús xiꞌin na kachi ra saa: ―Ichi nuu xaꞌndia Ndioxi chiñu ra suꞌva va ke iyoo ña: ta kuꞌva kuu xiꞌin tata, ña ndixaꞌan iin tiaa chiꞌi ra nuu ñuꞌú, ra saa iyoo ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Saa chi takua chiꞌi ra ña ra ndakiꞌin ra kuaꞌan va ra, ra a kixi̱ ra, a ndito va ra, ndi mii ra xini va, ra tata ña chiꞌi ra, ra ñuu kaꞌñu xaꞌnu va ña kan kuaꞌan ña, ndi su tiaa kan, ra kundäa ini vi ra ni ke kuu xaꞌnu ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Saa chi xa chuun nuu mii va ñuꞌu yoꞌo ke, ña sakuaꞌnu ña ña, ra xiꞌna ndutia ña, saa te ndiꞌi, ra kuee kuee xaꞌnu va ña, ra xaꞌa kuyoko ña, ra kuxixa ña ra nduu ña nuni va. ");
INSERT INTO mxv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ra ta xa xinu ña, ña kuu ña nuni, saa ra, xaꞌa ra sakee va ra ña, chi xa ndixaa tiempo ña ndakaya va ña, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Saa ndikaꞌan ka Jesús inka tuꞌun ndichi xiꞌin na kachi ra saa: ―¿Ndia ña ke inuu xiꞌin chi nuu xaꞌndia Ndioxi chiñu? Ra kuni yu na kundaa ini ndo vichin. ");
INSERT INTO mxv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Chi suꞌva va ke iyoo ña: ta kuꞌva iyoo iin ndikin mostaza loꞌo ña chiꞌi na, saa iyoo ña. Ra xa kundaa va ini ndo chin ndikin itun mostaza yoꞌo ke loꞌo vaꞌa ka nuu takundiꞌi va ndikin ña iyoo nuu ña yuuvi yoꞌo; ");
INSERT INTO mxv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ra vaꞌa ni loꞌo ni va ña, ndi te ndutia ña ra xaꞌa xaꞌnu ña, ra tiaa ni ka chee xaꞌnu itun ña yoꞌo nuu takundiꞌi ka itun tu iyoo xiꞌin ña; ra naꞌnu ka vi xaꞌnu itun ndaꞌa ña, ra ndia sàà va xaa xavaꞌa chiꞌyo ndaꞌa itun ña. Ra kuꞌva suꞌva ke iyoo tu ichi ña kuaꞌan nuu xaꞌndia Ndioxi chiñu va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ra niña xiꞌin tuꞌun ndichi taꞌan ña yoꞌo ke xiniñuꞌu Jesús ña sakuaꞌa ra na; ra tuꞌun ndichi ña kiꞌin mii ra kuenda xiꞌin, ña kuchuun sava na ndakiꞌin xini na xiꞌin ke kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ra takundiꞌi ña sañaꞌa ra na yuvi, ra niña xiꞌin tuꞌun ndichi va ke sañaꞌa ra na, ra vaꞌa ni ndikundäa va ini ndia itaꞌan xiꞌin ra, ndi su sañaꞌa siin va ra ndia kan ni ke kuni kachi tuꞌun ndichi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Saa kuu ra kuñuu va kii kan. Ra ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Na kuꞌun yo chi inka xiyo yuꞌu mini yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Saa nindiayu taꞌan ndia xiꞌin na yuvi kan, ra nandaa ndia itaꞌan xiꞌin ra ini itun xika nuu mini nuu xa ndikaa ra kan, ra ndakiꞌin ndia kuaꞌan ndia xiꞌin ra. Ra taxi ndikun tu sava ka na yuvi kan va kuaꞌan na xiꞌin barca na. ");
INSERT INTO mxv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ra saa kuu na kuaꞌan na nuu mini kan, ra xaꞌa ndiee ka vi xika tachi, iin ndakundichi ndakundichi nuu mini kan xa ña, ra xaꞌa iin kuni̱ kutu ndaa barca loꞌo tu ndoꞌni ndia ini kan xiꞌin tiakuii xa ña. ");
INSERT INTO mxv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ra chi kaꞌa barca kan ndúꞌu̱ iin ñaꞌa ndachiꞌi Jesús si̱ki̱ ra, ra ndakanduꞌu ra, ra saa naa ini ra ndikixi va ra, ra saa ndi̱xa̱a̱ ndia itaꞌan xiꞌin ra sandoto ndia ra, ra ndikaꞌan ndia xiꞌin ra, kachi ndia saa: ―¡Tata Maestro! ¿A ndïꞌi ini kun ña kuni saꞌvi barca loꞌo yoꞌo xiꞌin yo kaꞌa mini yoꞌo? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Saa ndakoo Jesús, ra xaꞌndia ra chiñu nuu tachi kan, ña na kutuvi ña ra ndikaꞌan tu ra xiꞌin tiañuꞌu kan va kachi ra saa: ―Xavaꞌa, koo taxin kun, ―kachi ra xiꞌin ra. Saa ra ndikun ndixkuiin va tachi kan, ra yayaa kutaxin va. ");
INSERT INTO mxv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―¿Nichuun ndiee ni iyuꞌvi ndo? ¿A täan xinu ini ndo kandixa ndo Ndioxi saa va? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ra ndakanda ka vi ini ndia, iin kuaꞌan ini ndia ndee ndia, ra kaꞌan xiꞌin taꞌan ndia kachi ndia saa: ―¿Ndia tiaa kuvi ra yoꞌo? Ra ndia tachi xiꞌin tiañuꞌu, ra kandixa ra ña kaꞌan ra ―kachi ndia xika xiꞌin Jesús xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Saa ra ndixaa ndia ñuu Gadara, ña ndikaa chi inka xiyo yuꞌu tiañuꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ra te nuu suꞌva Jesús ini barca kan, saa ra ndikun ndixaa iin tiaa ra ñuꞌu tachi ndivaꞌa ini, niniꞌi taꞌan ra xiꞌin Jesús, ra tiaa yoꞌo ra ini yavi ndìì ke ndikaa ra, kanata ra ndixaa ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chi ra tiaa yoꞌo, ra yavi ndìì ke xikuu veꞌe va ra. Ra ndia nii na taꞌan ra ndikuchüun ña chikuꞌni na ra, nii xiꞌin cadena ndikuchüun na. ");
INSERT INTO mxv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ra nii ndiäꞌvi ichi nditiin na ra, ña taan na kàà ndaꞌa ra xiꞌin xaꞌa ra, ra nii xiꞌin cadena tu chikatun na ra, su ndi köo mii xaꞌa vi ña nuu ra, chi iin xaꞌndia ndiꞌi va ra ña, ra iin vali vali xa ra ña, ndia nii na kundiëe xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ra iin ndisaa kii, ñuu kaꞌñu xika ra iku, ra ñuu kaꞌñu xika tu ra kumisanto va, ra iin ndaꞌyu koꞌo ra xika ra, ra iin satakueꞌe ndiꞌi ra mii ra xiꞌin yuu. ");
INSERT INTO mxv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Saa ra te xini ra xika ka va vaxi Jesús, saa ra ndikun xinu ra xaa ra xikusiti ra nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ra iin kokoꞌo ndaꞌyu tachi ndivaꞌa ña ñuꞌu ini ra, ra kachi ña saa xiꞌin Jesús: ―¡Jesús, Seꞌe Ndioxi ra kaꞌnu! ¿Ni ke kuni kun xiꞌin yu? Xakundaꞌvi yu nuu kun xiꞌin nuu Ndioxi, ña na sandöꞌo kun yuꞌu. ¡Ndaꞌvi ni yu! ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ra saa kachi ra ñuꞌu tachi ndivaꞌa ini kan ndikaꞌan ra, saa chi xa xaꞌndia va Jesús chiñu nuu ña ndivaꞌa kan ña na kee ña kuꞌun ña, ra suꞌva ke kachi Jesús xiꞌin ña: ―¡Tachi ndivaꞌa, kita ini ra tiaa xaan! ¡Kuaꞌan! ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Saa ndindakatuꞌun Jesús tachi ndivaꞌa kan, kachi ra saa xiꞌin ña: ―¿Ndixa nani kun? ―kachi ra xiꞌin ña. Saa ndakuiin ña kachi ña saa: ―Legión va nani yu, saa chi kuaꞌa ni kuvi ndi ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ra xakundaꞌvi ka vi tachi ndivaꞌa kan nuu Jesús ña na täva ra ña kuꞌun ña inka xiyo. ");
INSERT INTO mxv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ra yachin nuu iku kan xika iin tiꞌvi chee kini xaxaꞌan ri. ");
INSERT INTO mxv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Saa xakundaꞌvi ni tachi ndivaꞌa kan nuu Jesús kachi ña saa: ―Tiꞌvi nduꞌu na kuꞌun ndi nuu xika kini kaa, ra taxi kun ndiayu ndaꞌa ndi ña na ndee ndi ini ri ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Saa ndikun taxi Jesús ndiayu ndaꞌa ña, ña na kuꞌun ña ndee ña ini kini kan, ra kuꞌva uvi mil kuvi kini kan. Ra xaꞌa sasana ndiꞌi ña ri, ra xinu ndiꞌi ri ndi̱xàà ri ndikoyo ri iin taꞌvi nuu ndikaa mini, ra ndikaꞌa ndiaa ndiꞌi ri, ra ndixiꞌi ri. ");
INSERT INTO mxv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ra ndiyuꞌvi ka vi na ndiaa kini kan, ra kee na xinu na ndixaꞌan na ndatuꞌun na xiꞌin na ndee ñuu, ra ndatuꞌun tu na xiꞌin na ndakitaꞌan xiꞌin na chi iku va. Ra saa ndakoyo takundiꞌi na yuvi kan ra ndi̱xa̱a̱ na xini na ña kuu kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ra te ndi̱xa̱a̱ na nuu iin Jesús, ra xini na ra tiaa xindoꞌni tachi ndivaꞌa ini kan, ra xa nduvaꞌa va ra, ra xa ndakundixi va ra tikoto, ra xa yayaa va nduꞌu ra, chi xa ndukaxin va ini ra. Saa ra ndayuꞌvi ka vi ini na yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ra yuvi na xini ña ndoꞌo ra xindoꞌni tachi ndivaꞌa ini kan, xiꞌin ña ndoꞌo kini kan, ra ndatuꞌun na xiꞌin inka yuvi xaꞌa ña xini na. ");
INSERT INTO mxv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ra saa xakundaꞌvi na nuu Jesús ña na sa ra ña mani kita ra ñuu na kuꞌun ra inka xiyo. ");
INSERT INTO mxv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ra saa te nandaa Jesús ini barca loꞌo kan kuꞌun ra, saa xakundaꞌvi ra tiaa xindoꞌni tachi ndivaꞌa ini kan nuu Jesús ña na taxi ra kuꞌun ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Su ndi ndixïin Jesús ña kuꞌun ra xiꞌin ra, chi suꞌva va kachi ra xiꞌin ra: Kuanuꞌu̱ veꞌe kun nuu na taꞌan kun, ra ndatuꞌun kun xiꞌin na xaꞌa takundiꞌi ña vaꞌa xa Ndioxi xiꞌin kun, xiꞌin ña kundaꞌvi ini ra xini ra yoꞌo ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Saa ndakiꞌin ra tiaa kan kuanuꞌu ra, ra xaꞌa ra iinii kuvi ndaꞌa ñuu Decápolis ndatuꞌun ra xiꞌin na xaꞌa ña vaꞌa xa Jesús xiꞌin ra, ra ndayuꞌvi ka vi ini na yuvi kan xaꞌa ña ndoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ra te ndiko tuku Jesús ndaxàà ra xiꞌin barca chi inka xiyo yuꞌu tiañuꞌu kan, ra kuaꞌa ka vi yuvi ndakaya tuku xaa na nuu ra; ra saa nindoo ra xiꞌin na yuꞌu mini kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Saa kuu ra ndixaa va iin ra xikuaꞌa, ra nani Jairo, ra kuchee nuu na veꞌe ñuꞌu, ra te xini ra Jesús, saa ra ndikun xikusiti va ra nuu ra, ");
INSERT INTO mxv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ra xakundaꞌvi ka vi ra kachi ra saa: ―Tata, seꞌe loꞌo yu ra ña xa kana nima kuvi ña, ra na sa kun ña mani kuꞌun kun xiꞌin yu ra chinduꞌu kun ndaꞌa kun sata seꞌe yu, ra na nduvaꞌa va ña ra kutiaku ña. Chi ndaꞌvi ni yu ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ra. Ra iin tiaꞌndia chee na yuvi ndikun kuaꞌan xiꞌin ndia, ra iin kuni̱ ndaa na sata ndia. ");
INSERT INTO mxv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ra tiañu na yuvi kan, ndikaa iin ñaꞌá ña xitia ni̱i̱ kuaꞌan ña xiꞌin na, ra ñaꞌá kan ra xa uxi uvi kuiya ke ndoꞌo ña saa, ra küvi nduvaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ra kuaꞌa ka vi na xatatan ndixika ña nuu, ra sandoꞌo ka vi na ña, ra sasiki yaa ña xuꞌun ña, su ndi ndia ña mani uun va chi ninduväꞌa ña, ra ña ndiee ka nundiee va ku kueꞌe kan xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ra te xini soꞌo ña ndatuꞌun na yuvi xaꞌa ña vaꞌa xa Jesús, saa ra xiña niꞌni, ña tiañu na yuvi kan, ra kuyachin ña chi sata Jesús, ra nditiandiaa ndaꞌa ña tikoto ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Saa chi ndakani ini ña kaꞌan ña saa: “Tu na tiandiaa loꞌo ndaꞌa va yo tikoto ra, saa ra ndikun nduvaꞌa va yo”, kaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Saa ra ndikun xikutuvi ndixa va ña xitia ni̱i̱ ña, ra ndikun kundaa ini ña ña nduvaꞌa va ña, chi xïꞌi ka ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ra saa kundaa ini Jesús ña ke̱e ndie̱e̱ ra, ra saa ndikokuiin ra ndakotoꞌni ra nuu na yuvi kan, ra ndindakatuꞌun ra na, kachi ra saa: ―¿Yoo ku na nditiandiaa ndaꞌa tikoto yu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Saa ndakuiin ndia itaꞌan xiꞌin ra, kachi ndia saa: ―Tata, iin chindaꞌa taꞌan na yuvi vaxi na sata kun, ra ^ndakatuꞌun ka kun, yo ku na nditiandiaa ndaꞌa tikoto kun ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Su ndi ndïxa ra xaꞌa vi ña kaꞌan ndia xiꞌin ra, chi ndakundiee ra ixtoꞌni ra nuu va na, ña ndiatu ra kundaa ini ra, yo ku na nditiandiaa ndaꞌa tikoto ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ra ñaꞌa kan ra iyuꞌvi ka vi ña, iin ndiakua kisi ña ña, chi kundaa ini ña ña nduvaꞌa ña xa ra. Saa ndixaa ña xikusiti ña nuu ra, ra ndatuꞌun ndiꞌi ña xiꞌin ra, ni xaꞌa ke xa ña saa. ");
INSERT INTO mxv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Seꞌe, xaꞌa ña kandixa kun yuꞌu ke xa ndikaku kun. Ra kuanuꞌu veꞌe kun, ra ndïꞌi ka ini kun, chi xa nduvaꞌa va kun ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ra te kaꞌan ka va Jesús, saa xaa na kee veꞌe ra Jairo, ra xikuaꞌa xaꞌndia chuun veꞌe ñuꞌu, kachi na saa xiꞌin ra: ―Tata, xa ndixiꞌi va seꞌe kun. Köo ka chuun ke sandiꞌi vi kun tata maestro kuꞌun ra xiꞌin yo ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Saa te xini soꞌo Jesús ña kuyuꞌu na saa xaa na nuu ra Jairo, saa ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kuayüꞌvi kun, indaa yuꞌu va kandixa kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ra nditäxi Jesús kuꞌun ndiꞌi na xiꞌin ra, chi takua ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan ñani ra Jacobo va kuvi ndia ndakiꞌin ra kuaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ra te ndixaa ra veꞌe ra xikuaꞌa Jairo, ra iin niniꞌi kuu, iin siso siso ndaꞌyu na, ra xaku ka vi na ndee na. ");
INSERT INTO mxv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Saa ndikiꞌvi ndia ra ndikaꞌan Jesús xiꞌin na kachi ra saa: ―¿Nichuun xaku ni ndo? Ña loꞌo yoꞌo ra süvi ña ndixiꞌi kuvi ña, chi ña kixi va kuvi ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ndi su na ndixaku ndiaa va kuvi na ra. Ra saa xaꞌndia ra chiñu ña na kee takundiꞌi na chi keꞌe, ra takua iva ña loꞌo kan xiꞌin siꞌi ña, xiꞌin ndia kuaꞌan xiꞌin va ra kuvi na ndikiꞌvi xiꞌin ra nuu kanduꞌu ña loꞌo ndixiꞌi kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ra saa tiin ra ndaꞌa ña loꞌo kan, ra ndikaꞌan ra xiꞌin ña kachi ra saa: ―Talita kumi ―kachi ra xiꞌin ña; ra tuꞌun yoꞌo kachi ña saa: “Ña loꞌo, xiꞌin yoꞌo ke kaꞌan yu, ndakoo”. ");
INSERT INTO mxv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Saa ra ndikun ndakoò va ña loꞌo yoꞌo xika ña, ra uxi uvi va kuiya ke ndikaa ña, ra ndakanda ka vi ini na yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ra ndikaꞌan ka vi Jesús xiꞌin na, ña na ndatüꞌun na xiꞌin ndia nii yuvi xaꞌa ña kuu yoꞌo. Saa xaꞌndia ra chiñu nuu na vasiꞌi ña loꞌo kan, ña na taxi na ña kuxi ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Saa kanata Jesús ñuu kan, ra ndakiꞌin ra kuaꞌan ra ñuu nuu kee ra, xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ra te ndixaa kii yii, saa ndikiꞌvi Jesús ini veꞌe ñuꞌu, ra xaꞌa ra sañaꞌa ra na. Ra kuaꞌa ka vi ku na ndee xini soꞌo, ra ndakanda ka vi ini na kachi na saa ndakatuꞌun taꞌan na: ―¿Ndia ndixaꞌan kiꞌin tiaa yoꞌo takundiꞌi ña ndichi yoꞌo? ¿Ndixa xa ra ña kundichi ni ra? ¿Ndia ndixaꞌan ra sakuaꞌa ra? ¿Ndia ndixaꞌan ra kutuꞌva ra takundiꞌi ña xituꞌun yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿A su ra yoꞌo ku ra kuxi itun, ra seꞌe ña María va kuvi ra? ¿A su ñani ra yoꞌo kuvi ra Jacobo, José, Judas, xiꞌin ra Simón? ¿A su yoꞌo ndee tu na siꞌi kuꞌva va ra xiꞌin yo? ―kachi na. Ra xaꞌa ña yoꞌo ke ndixïin na kandixa vaꞌa vi na ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Takundiꞌi ñuu ra xatoꞌo va na iin yuvi na kaꞌan tuꞌun yuꞌu Ndioxi, su ndi ñuu na nuu kee na, nuu ndee na taꞌan na, na veꞌe na, ra xätoꞌo na na kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ra ndiküvi sa Jesús ndia nii ña xituꞌun ñuu ra, chi takua ña xa ra ke sanduvaꞌa ra ndiaꞌvi na xiꞌi̱ va, ña chinduꞌu ra ndaꞌa ra sata na, ra ña yoꞌo kuiti va ke xa ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ra ndakanda ka vi ini Jesús xini ra na yuvi yoꞌo xaꞌa ña ndiee ni ini na, chi ndixïin na kandixa vaꞌa vi na ra. Saa ndakiꞌin ra kuaꞌan ra iinii kuvi ñuu vali ndoꞌni yachin kan, sañaꞌa ra na yuvi tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Saa kuu ndakana Jesús uxi uvi saa ndia itaꞌan tuun xiꞌin ra, ra saa tiꞌvi ra ndia kuaꞌan ndia kaꞌan ndoso ndia tuꞌun Ndioxi, ra ta uvi ta uvi chitaꞌan ra ndia kuaꞌan ndia, ra taxi ra ndiayu ndaꞌa ndia ña tava ndia tachi ndivaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ra xaꞌndia ra chiñu nuu ndia ña na küꞌu̱n ndia nii ñaꞌa xiꞌin ndia ichi nuu ku̱ꞌu̱n ndia; nii leka, nii ixta, nii xuꞌun küꞌu̱n xiꞌin ndia, chi takua indaa itun katuvi va ndia ku nu ku̱ꞌu̱n xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ra takua ndixan va ndia ke na ku̱ꞌu̱n xaꞌa ndia, ra na küꞌun uvi naꞌa tikoto ndia xiꞌin ndia, chi takua ña xa ndixi ndia kuaꞌan va ndia ke, na kuꞌun xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ra ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Ndia ndia ka ñuu nuu xaa ndo, ra veꞌe nuu ndakiꞌin na ndoꞌo koo ndo xiꞌin na; ikan ke na koo va ndo. Ra xinüꞌni ndo kuꞌun ndo inka veꞌe na, chi mii veꞌe kan ke kee ndo kuꞌun ndo inka ñuu va. ");
INSERT INTO mxv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ra tu ndia ñuu xïin na ndakiꞌin mani na ndoꞌo, xiꞌin nii xïin na kunisoꞌo na ña kaꞌan ndo, saa ra kee ndo ñuu na, ra kuun ndo xaꞌa ndo na ko̱yo yaka ñuu na xaꞌa ndo, ra na kuu ña iin seña nuu na, ra na kundaa ini na ña kundasi na tuꞌun Ndioxi; ra saa ke ndoꞌo, ra köo ka kuachi ndo. Ra ña ndixa kaꞌan yu xiꞌin ndo, te na xaa kii sandaku Ndioxi kuachi na ñuu yuuvi yoꞌo, ra ndiee ni ka chee tundoꞌo taxi Ndioxi ndaꞌa na yuvi yoꞌo nuu na ñuu Sodoma, xiꞌin na ñuu Gomorra ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Saa kee ndixa ndia ra ndakiꞌin ndia kuaꞌan ndia kaꞌan ndoso ndia tuꞌun Ndioxi nuu na yuvi, ña na ndiko ini na xaꞌa kuachi na ra ndakiꞌin na ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ra tava ndia tachi ndivaꞌa ini yuvi na tiin ña, ra chikaa tu ndia aceite xi̱ni̱ na xiꞌi̱ ra nduvaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Saa kuu ra kundaa ini ra rey Herodes ña ndatuꞌun na yuvi xaꞌa Jesús ña xa ra ña xituꞌun. Chi ndiꞌi kuvi ñuu ndixitia ndoso tuꞌun xaꞌa ra, ra kundaa ini na xaꞌa ra. Saa ndikaꞌan ra Herodes kachi ra saa: ―Ra Juan ra sandakuchi yuvi ku ra ndatiaku. Ña kan ke vaꞌa iyoo ni ndie̱e̱ yoꞌo xiꞌin ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ra sava tu na kaꞌan kachi saa: Ra Elías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va kuvi ra ―kachi na. Ra inka tu na kachi saa: ―Iin ra kaꞌan tuꞌun yuꞌu Ndioxi taꞌan na kixi xinaꞌa va kuvi ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ra te xini soꞌo ra Rey Herodes ña kaꞌan na suꞌva, saa ndikaꞌan ra kachi ra saa: ―Ra Juan, ra ndikaꞌan yu xiꞌin na xaꞌndia na sukun, ku ndixa va ra ndatiaku yoꞌo vichin ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chi te yachi ra mii ra Herodes yoꞌo ku ra xaꞌndia chuun ña ndixaꞌan na tiin na ra Juan. Ra chikatun na ra xiꞌin cadena, ra chikaa na ra veꞌe kaa xaꞌa ña ndikaꞌan ra xaꞌa ña Herodías xanu ra rey Herodes, chi ra Herodes yoꞌo ra ndakiꞌin ra ña Herodías yoꞌo nduu ña yasiꞌi va ra. Ndi su yasiꞌi ra Felipe, ñani va ra, kuvi ña, ra ndakiꞌin ra ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ra xaꞌa ña yoꞌo ke ndikaꞌan ra Juan xiꞌin ra Herodes, ra kachi ra saa xiꞌin ra: ―Väꞌa xa kun, chi köo ichi kun ña ndakiꞌin kun yasiꞌi ñani kun kunduꞌu ña xiꞌin kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ra ña kan ke xani ni ini ña Herodías xini ña ra Juan, ra tiaa ni kuni ña kaꞌni ña ra, su ndi kuchüun ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ndi su mii ra Herodes ra iyuꞌvi ini va ra xini ra ra Juan, chi kundaa ini ra ña kuu ra Juan iin tiaa vaꞌa, ra ndaa, ra yii; ña kan ke xindiaa va ra ra, ra nditäxi ra kuvi ra. Ra te xini soꞌo ra Herodes ña kaꞌan ra Juan xiꞌin ra, ra xaꞌa ndataꞌvi ña xi̱ni̱ ra, ra iin sana suꞌva ini ra, ra nii nïꞌi ra ni ke sa ra, ra vaꞌa ni saa ndo̱ꞌo va ra, su ndi kusii ka vi ini ra xini soꞌo ra ña kaꞌan ra Juan. ");
INSERT INTO mxv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ra saa kuu ra ndi̱xa̱a̱ va kii ña ndixinu ra Herodes kuiya, saa ra nditiandiaa va iin kii ña xa ndiee ni ndiatu ña Herodías ndixa koo ña kaꞌni ña ra Juan. Ra kii yoꞌo ra ndiee ni ndasakaꞌnu ra Herodes ña, iin viko chee ndatava ra, ra ndakana ra takundiꞌi na kunaꞌnu xiꞌin ra, xiꞌin na komandande, xiꞌin na xikuaꞌa na ndee iinii saa kuvi Galilea. ");
INSERT INTO mxv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Saa ra ndixaa va ña loꞌo seꞌe ña Herodías ndikiꞌvi ña nuu ndee na ndatava na viko kan nditaxaꞌa ña nuu na. Saa ra ndiee ni kusii ini ra Herodes xaꞌa ña xa ña saa, ra saa tu na ndixaa ndee xixi xiꞌin va ra. Ra saa ndikaꞌan ra rey Herodes xiꞌin ña loꞌo kuaan kan kachi ra saa: ―Nduku ndia ndia ka ñaꞌa ña kuni̱ kun nuu yu, ra taxi yu ña ndaꞌa kun ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ra iin uvi uni ichi kindoo ra xiꞌin ña, ña taxi ra ndia ndia ka ñaꞌa ña kuni ña ndaꞌa ña, ra ndïko ini ra kachi ra xiꞌin ña, ra ndia taxi tu ra sava ñuu nuu kuu ra rey va ndaꞌa ña, tu na nduku ña ña, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Saa kanata ña ndixaꞌan ña ndindakatuꞌun ña siꞌi ña kachi ña saa: ―Nana, ¿ni ke vaꞌa nduku yu nuu ra ―kachi ña xiꞌin siꞌi ña. Saa ndakuiin siꞌi ña kachi ña saa xiꞌin ña: ―Nduku xi̱ni̱ ra Juan ra sandakuchi yuvi nuu ra ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Saa ndikun xinu ña nandiko ña nuu ndúꞌu̱ ra Herodes, ra ndikaꞌan ña xiꞌin ra kachi ña saa: ―Kuni yu ndikun na kundikaa xini ra Juan ra sandakuchi yuvi ini iin ko̱ꞌo̱, ra taxi kun ña ndaꞌa yu ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Saa ra kusuchi ka vi ini ra rey Herodes, saa chi küni ra ña kaꞌni ra ra Juan, su ndi ndiküvi ka ndasa uvi yuꞌu ra, saa chi xa kee va yuꞌu ra ña taxi ra ndia ndia ka ñaꞌa ña kuni ña ndaꞌa ña, nuu takundiꞌi na kana ra ndi̱xa̱a̱ viko kan. ");
INSERT INTO mxv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ndia saa ra ndikun xaꞌndia ra chuun nuu iin soldado ña na kuꞌun ra kaꞌndia ra sukun ra Juan, ra kaniꞌi ra xini ra, kixi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Saa ndakiꞌin ra soldado kan ndixaꞌan ra ini veꞌe kàà nuu ndikaa ra Juan, ra xaꞌndia ra sukun ra, ra niꞌi ra xini ra Juan ndikaa ña ini iin ko̱ꞌo̱ xaa ña xiꞌin ra, ra ndataxi ra ña ndaꞌa ña loꞌo kuaan kan, ra saa ke̱e ña loꞌo kan ndixaꞌan ña ndiaka ña ña ndaꞌa siꞌi ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ra saa te kundaa ini na xitaꞌan tuun xiꞌin ra Juan ña xa ndixiꞌi ra, ra saa ke̱e na ndixaꞌan na ndakiꞌin na iki kuñu ra ndinduxin na. ");
INSERT INTO mxv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Saa kuu ra ndaxàà ndia itaꞌan tuun xiꞌin Jesús, ndakutaꞌan ndia xiꞌin ra, ndia tiꞌvi ra ndixaꞌan ndikaꞌan ndoso, ra ndataxi ndiꞌi ndia nuu ra xaꞌa takundiꞌi ña xa ndia, xiꞌin ña sañaꞌa ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Naꞌa ndo, na kuꞌun yo chi iku nuu köo yuvi ndakindiee ndo loꞌo ―kachi ra xiꞌin ndia. Chi kuaꞌa ka vi yuvi vaxi nuu ndia; na kuaꞌan, ra na xaa va, ra ndia nii ña kuxi ndia ke küvi, chi kuñäꞌa mii vi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Saa nandaa Jesús ini barca xiꞌin ndia xika xiꞌin ra, ra ndakiꞌin ndia kuaꞌan ndia iin iku nuu köo yuvi. ");
INSERT INTO mxv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Su ndi kuaꞌa ni yuvi xini ña ndakiꞌin ndia kuaꞌan ndia, ra ndakuni na Jesús kuaꞌan ra xiꞌin ndia. Saa ra ndikun taxindikun ndiꞌi na kuaꞌan na sata ra, ra iin takundiꞌi ñuu ndakoyo yuvi ra xika xaꞌa na ndixaa na ndia iku yuu kan, ra xiꞌna ka va na kan ndixaa nuu Jesús xiꞌin ndia xika tuun xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ra te nuu ra ini barca loꞌo yoꞌo ra ndakotoꞌni ra, ra xa iin ndandaa va kaa iku kan xiꞌin yuvi, saa ra kundaꞌvi ka vi ini ra xini ra na, chin chiꞌña ka vi íin na ndee na, ta iin ndikachi vali ti köo ixtoꞌo saa íin na. Saa xaꞌa ra sañaꞌa ra na xaꞌa takundiꞌi ña vaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ra saa kuu kuaꞌan kuaa va, saa ndi̱xaa ndia xika tuun xiꞌin ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata, xa kuaꞌan kuaa ni, ra iku yoꞌo ra köo mii ñaꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndatiꞌvi na yuvi yoꞌo na kuꞌun na, ra na kunuꞌni na ñuu ña ñuꞌu yachin yoꞌo, ndia ndia ka mii nuu ndee yuvi, ra na sata na ixta kuxi na, chi xa kuaa ni, ra köo mii ñaꞌa niꞌi na kuxi vi na ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿Nichuun kuꞌun na? Taxi ndoꞌo na kuxi na, chi ndoꞌo va ku ndo xiniñuꞌu sakuxi na ―kachi ra. Saa ndakuiin ndia kachi ndia saa: ―Tata, ¿a kuni kun na kuꞌun ndi sata ndi ñaꞌa xaa xiꞌin ndi kuxi takundiꞌi na yuvi yoꞌo? Ra kuꞌva uvi ciento denario xuꞌun, saa vi ke kundiee yo sakuxi yo na yuvi yoꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―¿Ndixaa ku ixta niꞌi ndo? Kuaꞌan ndo toꞌni ndo ―kachi ra xiꞌin ndia. Saa ndixaꞌan ndia ixtoꞌni ndia, ra nandiko ndia xaa ndia kachi ndia saa xiꞌin ra: ―Uꞌun va ku ixta, ra uvi ku tiaka va ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Saa xaꞌndia ra chiñu ra ndixaꞌan ndia ndachindee vii ndia yuvi kan, ra ta tiꞌvi ta tiꞌvi ndachindee ndia na nuu itia kuii̱ kan. ");
INSERT INTO mxv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ra saa ndakundee na nuu itia kan, ra ta ciento ta ciento, xiꞌin ta uvi xiko uxi, ta uvi xiko uxi ndakundee na. ");
INSERT INTO mxv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Saa kiꞌin Jesús uꞌun saa ixta kan, xiꞌin uvi saa tiaka, ra ndoniꞌi ra nuu ra chi ndivi, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra te ndiꞌi, saa taꞌvi ra ixta kan taxi ra ndaꞌa ndia xika xiꞌin ra, ña ndataꞌvi ndia xiꞌin na yuvi kan, ra saa ndataꞌvi tu ndia uvi saa tiaka kan xiꞌin takundiꞌi na yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ra xixi takundiꞌi na yuvi yoꞌo ndiakua nditiandiaa ini na. ");
INSERT INTO mxv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ra te ndiꞌi xixi na, saa ndakaya ndia takundiꞌi ixta ñaꞌñu ña nindoo ndoso, xiꞌin tiaka ti nindoo ndoso, ra uxi uvi ka tuká sakutu ndia xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ra takundiꞌi na yuvi xixi yoꞌo, ra kuꞌva uꞌun mil kuvi niña tiaa va. ");
INSERT INTO mxv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te ndiꞌi, saa ndikaꞌan Jesús xiꞌin ndia xika xiꞌin ra ña na ndaa ndia ini barca loꞌo kan, ra xa na kunuu ndia kuꞌun ndia chi ñuu Betsaida ña ndikaa chi inka xiyo yuꞌu mini kan, ra nani saa kuee na ndiayu taꞌan ra xiꞌin na yuvi kan, ra saa kuꞌun ra chi kan ndakutaꞌan ra xiꞌin ndia, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ra saa te ndiꞌi nindiayu taꞌan ra xiꞌin takundiꞌi na, saa ndakiꞌin ra kuaꞌan ra iin iku nuu köo yuvi ña kaꞌan ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ra te xa kuñuu, ra xa nditaꞌvi sava va ndia xika xiꞌin ra kuaꞌan ndia nuu tiañuꞌu kan, ra ndia mituꞌun saa va Jesús nindoo chi yuꞌu mini kan. ");
INSERT INTO mxv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ra saa kuu xini ra xikutuvi ndia ra nii küvi ka kuꞌun ndia, iin ndia xiꞌin ña nduxa va kuaꞌan ndia, chi tachi ra chi nuu ndia suꞌva va vaxi ña, ña kan ke küvi kuꞌun barca ndia xiꞌin ndia. Ra saa te xa kuaꞌan kuni̱ tu̱vì ta kuꞌva kaa uni ñuu, saa xika xaꞌa Jesús nuu tiakuii kan ndixaa ra nuu ndia, ra ta iyoo ra yaꞌa ndaku kuꞌun va, saa iyoo ra tuvi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ra saa te xini ndia xika ra nuu tiakuii kan kuxaa ra, saa ra iin nindaꞌyu ko̱ꞌo̱ ndia, chi nima va xa ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chi xini takundiꞌi ndia ña xika ra xaa ra nuu ndia, ra ndiee ni ndiyuꞌvi ndia. Saa ra ndikun ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¡Yayaa koo ndo chi yuꞌu va kuvi ra! Kuayüꞌvi ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Saa ndixaa ra nandaa ra ini barca kan xiꞌin ndia, ra ndikun ndixkuiin va tachi kan ña kini ni kuu ña. Ra ndiee ni ka ndayuꞌvi ini ndia xini ndia ra, ra ndakanda ka vi ni ndia. ");
INSERT INTO mxv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chi täan ndakiꞌin xini ndia ña kuu ra, ra kaꞌnu, saa chi nii xi̱ni̱ nuu va ndia ña ndasakuaꞌa ra ixta, ra nani saa küvi kundaa ini ndia, saa chi xaꞌa ña ndaku ni ini va ndia ke ndoꞌo ndia suꞌva. ");
INSERT INTO mxv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ra saa te ndakoyo ndia yuꞌu tiakuii kan, ra katun ndia barca ndia yuꞌu mini kan, ra saa ndixaa ndia ñuu Genesaret. ");
INSERT INTO mxv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ra te nu̱ù suꞌva ndia ini tu loꞌo xika nuu mini kan, saa ra ndikun ndakuni va na yuvi kan Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Saa ra ndikun kee yuvi kan kuaꞌan na iinii kuvi ñuu ña ndatuꞌun na xiꞌin na taꞌan na, ra saa xaꞌa na xaa na xiꞌin na xiꞌi̱ nuu Jesús ra ndia nuu ixto va ndee na xiꞌi̱ kan, xaa na xiꞌin na nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ra ndia ndia ka mii nuu xaa va Jesús, a ñuu naꞌnu kuvi ña, a ñuu vali kuvi ña, a iku kuvi va ña, ra ndia nani ke kundaa ini na tuꞌun ña xa vaxi ra, saa ra ndikun tava va na na xiꞌi̱ ra chindee na na ichi nuu yaꞌa ra kuaꞌan ra, ra xakundaꞌvi ka vi na nuu ra, ña na sa ra ña mani ra taxi ra tiandiaa ndaꞌa na xiꞌi̱ kan tikoto ra. Chi takundiꞌi na tiandiaa ndaꞌa tikoto ra, ra ndikun nduvaꞌa ndixa va na. ");
INSERT INTO mxv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Saa kuu ra ndixaa sava na fariseo xiꞌin na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés; ra na ñuu Jerusalén ke kee na, xaa na nuu xika Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ra xini na ña nindäꞌa sava ndia xika xiꞌin Jesús, ra ndakundee ndia xixi ndia, saa ra väꞌa ni ndikuni na kuni na ndia, chi nuu na fariseo yoꞌo ra iin kuachi chee ku ña yoꞌo nuu Ndioxi tu na ndäꞌa iin yuvi ra kuxi na, kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Saa chi na fariseo xiꞌin takundiꞌi na judío, ra xiꞌna ka ndaꞌa na saa ^xixi na. Chi ña yoꞌo ku costumbre ña sañaꞌa na xii xikua va na na, ra ta iyoo iin ña yii ni saa iyoo ña tuvi na. ");
INSERT INTO mxv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ra te na ndiko na ndaxaa na veꞌe na, te xaꞌan na nuu yaꞌvi, ra xiꞌna ka ndaꞌa na saa xaxi na ndia ndia ka ñaꞌa, ra saa ke saxinu ndiꞌi na costumbre ña ndakoo xii xikua na, ra ndiee ni xatoꞌo na ña. Na kachi yo saa, ta kuu ña ndakatia na yaxin na, xiꞌin ña ndoo kisi na, xiꞌin ña ndoo xikoꞌo na, xiꞌin ña ndoo ixto kixi̱ na, takundiꞌi ña yoꞌo ra iin ndiakua nduxa xa na ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Xaꞌa ña kan ke kuyachin na fariseo xiꞌin na maestro sañaꞌa ley Ndioxi nuu xika Jesús ra ndindakatuꞌun na ra, kachi na saa: ―¿Nichuun xätoꞌo ndia xika xiꞌin kun costumbre na xikuaꞌa? ¿A kundäa ini ndia, ña xiꞌna xiniñuꞌu ndaꞌa ndia saa kuxi ndia? Ra ndia yoꞌo ra iin saa iyoo ndaꞌa va ndia xixi ndia ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Ña ndixa ni ke ndikaꞌan ra Isaías xaꞌa ndoꞌo na maña te yachi, ra suꞌva ke kachi Ndioxi ndikaꞌan ra xiꞌin ra xaꞌa ndo, kachi tuꞌun ña ndatiaa ra: “Na yuvi yoꞌo, ra takua iin tuꞌun ni̱nù va ke kaꞌan na ña xatoꞌo na yuꞌu. Ndi su nima na, ra xika ni va iyoo ña nuu yu. ");
INSERT INTO mxv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ra ña uun va ke kaꞌan na ña kañuꞌu na yuꞌu. Saa chi süvi ichi yuꞌu ke sañaꞌa na yuvi, chi ichi ña ndaku ini mii va na ke sañaꞌa taꞌan na”, kachi Ndioxi xaꞌa ndo, kachi ña ndatiaa ra Isaías te yachi. ");
INSERT INTO mxv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ra ña ndixa ni kuvi va ña, saa chi ndakoo ñaꞌa va ndo chiñu ña xaꞌndia Ndioxi, ra costumbre ña sandaku mii na yuvi yoꞌo va ndiee ni ndakundikun ndo, saa chi takuu ña ndakatia ndo kisi ndo, xiꞌin ña ndakatia ndo yaxin ndo, xiꞌin ña xa ndo kuaꞌa ni ka chiñu, su ndi chiñu yoꞌo, ra ña xaꞌndia na yuuvi yoꞌo va ke yoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ndoꞌo, ra iin xiyo va ndakoo ndo ndiayu ña xaꞌndia Ndioxi, ra chiñu ña ndakoo na xii xikua va ndo, ndiee ni xayii ndo, ra xanduvi ndo ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ra kaꞌan yu saa xiꞌin ndo, saa chi ndiayu Ndioxi ña ndakoo ra Moisés, ra suꞌva va kachi ña: “Satoꞌo kun iva kun xiꞌin siꞌi kun” chin “Yuvi na kaꞌan ndivaꞌa xiꞌin vasiꞌi, ra na köo ña kaꞌnu ini xiꞌin na, chi xiniñuꞌu na kuvi va na”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Su ndi ndoꞌo, ra süvi saa ^xa ndo, chi suꞌva va kachi ndo̱: “Iin tiaa ra kuvi kachi ra suꞌva xiꞌin siꞌi ra a xiꞌin iva ra: ‘Küvi chindiee taꞌan yu xiꞌin kun, chi takundiꞌi xuꞌun ña xani xini yu taxi yu ndaꞌa kun, ra xa ta iyoo ña xa ndisoko yu nuu Ndioxi va iyoo ña, ra xa corbán va nduu ña’, kachi ra xiꞌin vasiꞌi ra. Saa ra xavaꞌa va. Xiniñüꞌu ka ndiakua nduxa toꞌni ra na”, kachi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ra suꞌva va ke xa ndo kava ndo yuvi, ra sasi ndo nuu na; täxi ndo satoꞌo na iva siꞌi na, ña kiꞌin na kuenda xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ra suꞌva ke ^xa tu ndo ña sandiꞌi ndo xaꞌa tuꞌun Ndioxi va xiꞌin costumbre ndo, chi costumbre ña sandaku mii ndo yoꞌo va ke ndiee ni ndasatoꞌo ndo, ra chiñu xaꞌndia Ndioxi sandiꞌi ndo xaꞌa va. Ra süvi takua ña yoꞌo ke ^xa ndo, chin kuaꞌa ni ka va ña xa ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Saa ndakana ra takundiꞌi na yuvi kan ra ndu̱yachin na nuu ra, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Tiaa ni soꞌo takundiꞌi ndo ña kaꞌan yu xiꞌin ndo yoꞌo, ra na kundaa ini ndo xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndia nii ñaꞌa ña iyoo nuu ñuꞌú yoꞌo, ra xaxi na ña, a xixi tu na ña, ra xayäkua ña na; chi tuꞌun ña ndakoyo nima va na ke xayakua ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndoꞌo, na xini soꞌo ña kaꞌan yu xiꞌin ndo yoꞌo, ra ndakiꞌin xi̱ni̱ ndo xiꞌin ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ra saa te ndiꞌi ra ndakoo ra na yuvi kan, ra ndaxaa ra chi veꞌe, saa ndindakatuꞌun ndia xika xiꞌin ra ra xaꞌa tuꞌun ndichi ña ndikaꞌan ra, ni ke kuni kachi ña: ");
INSERT INTO mxv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿A ta iyoo na yuvi kan ke iyoo tu ndoꞌo va ña ndakïꞌin xi̱ni̱ ndo xiꞌin ña ni ke kuni kachi ña? ¿A kundäa ini ndo takundiꞌi ñaꞌa ña iyoo nuu ñuꞌu yoꞌo, ra xaxi na ña, a xixi tu na ña, ra xayäkua ña na? ");
INSERT INTO mxv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi süvi nima na kuaꞌan ña, chi ini siti va na ke kuaꞌan ña, ra te ndiꞌi xitia ña kuaꞌan ña ni̱nu̱ va ―kachi ra xiꞌin ndia. Ra suꞌva ke kachi Jesús xiꞌin ndia ña na kundaa ini ndia, ña kuvi kaxi yo takundiꞌi va ñaꞌa, chi ña vaꞌa ku takundiꞌi va ña; köo ña yakua. ");
INSERT INTO mxv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Saa ndikaꞌan ka ra xiꞌin ndia kachi ra saa: ―Takundiꞌi tuꞌun ña kee yuꞌu mii va yuvi ke kuyakua na xiꞌin. ");
INSERT INTO mxv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Saa chi nima na ke kaku takundiꞌi va ña väꞌa, ña vaxi xini na kuni na sa na, ña kotoo na kaka na ña yuuvi, ra kuaꞌa ni koo tani na kuni na, nii na siꞌi kuvi na, ra nii tiaa kuvi va ndia, ra nii ndakatüꞌun taꞌan tu na a kuachi na a naꞌnu na, chi inuu xasiki taꞌan ndiꞌi va na, ra saa tu ña kuni na kaꞌni na ndìì va, ");
INSERT INTO mxv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xiꞌin ña xakuiꞌna na, xiꞌin ña iin suꞌva kuni̱ na koo kuika na, xiꞌin ña xa na takundiꞌi nuu ña väꞌa, xiꞌin ña sandaꞌvi na yuvi, xiꞌin ña kuni na kindiaa na ñaꞌa iyoo nuu inka yuvi koo nuu na, xiꞌin ña ndukuini na xiꞌin taꞌan na, xiꞌin ña kandivaꞌa kini na xiꞌin taꞌan na, xiꞌin ña kutiaa na nuu ñani taꞌan na, ra niña chuun kiꞌvi va xani xini na sa na. ");
INSERT INTO mxv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Takundiꞌi ña ki̱ꞌvi yoꞌo ra nima va yuvi ke kana ña, ra ña yoꞌo ke kuyakua na xiꞌin, ra nduu na na väꞌa nuu Ndioxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Saa kee Jesús ñuu kan ra ndakiꞌin ra kuaꞌan ra ñuu Tiro xiꞌin Sidón. Ra ndixaa ra ndikiꞌvi ra iin veꞌe ndakunduꞌu ra, chi ndiküni ra ña na kundaa ini yuvi ña ndixaa ra kan, su ndi ndikuchüun ra ña koo seꞌe ra nuu na. ");
INSERT INTO mxv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ra ñuu kan iyoo iin ñaꞌá, ra tachi ndivaꞌa ke tiin ña loꞌo seꞌe ña. Ra te xini ña tuꞌun ña ndi̱xaa ra, saa ra ndikun ndakiꞌin ña ndi̱xàà ña nuu nduꞌu ra, ra xikisiti ña nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ra ñaꞌa yoꞌo ra süvi taꞌan na judío kuvi ña, chi ña ñuu Sirofenicia va kuvi ña. Ra xakundaꞌvi ka vi ña nuu Jesús ña na sa ra ña mani tava ra tachi ndivaꞌa kan kuꞌun ña, ra na saña ña ña loꞌo seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Saa ndikaꞌan Jesús xiꞌin ñaꞌa yoꞌo kachi ra saa: ―Kundiatu ñaꞌa kun nana, xiꞌna ka mii na xiꞌin veꞌe kuvi na, na kuxi ñaꞌa, chi väꞌa kita ña tu na kindiaa yo ixta yuꞌu seꞌe yo, ra taxi yo ña ndaꞌa tina kuxi ri ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Saa ndakuiin ña, kachi ña saa xiꞌin ra: ―Ña ndaa ni kuvi va ña kaꞌan kun Tata, su ndi tina, ra ndia ikin vali ña koyo yuꞌu na kuachi chi tixi mesa va ndakaya ri xixi ri, ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Saa kusii ni ini Jesús ña kachi ña saa, ra ndikaꞌan ra xiꞌin ña kachi ra saa: ―Vaꞌa ni ndikaꞌan kun nana, ra kuanuꞌu veꞌe kun chi xa kita va tachi ndivaꞌa kuaꞌan ña, ra xa nduvaꞌa va seꞌe kun, xaꞌa tuꞌun ña ndikaꞌan kun yoꞌo ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ra saa te ndaxàà ndixa ñaꞌa kan veꞌe ña, ra xa nuu ixto va yayaa kanduꞌu ña loꞌo seꞌe ña, ra xa kita va tachi ndivaꞌa ini ña kuaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Saa kuu kanata Jesús ñuu Tiro ra ndiyaꞌa ra chi ñuu Sidón iin saa ndixaa ra ndia yuꞌu tiañuꞌu Galilea, chi inka xiyo nuu ndikaa Decápolis. ");
INSERT INTO mxv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ra ikan ndixaa na nuu ra xiꞌin iin ra miꞌmi ra xïni tu soꞌo va ra, ra xakundaꞌvi ka vi na nuu ra, ña na sa ra ña mani̱ chinduꞌu ra ndaꞌa ra sata ra xiꞌi̱ kan. ");
INSERT INTO mxv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Saa kuxiyo Jesús xiꞌin ra kueꞌe̱ kan, chi nuu köo yuvi, ra ikan chinii ra nduku ndaꞌa ra ini soꞌo ra kue̱ꞌe kan, ra koꞌni ra loꞌo tiasiꞌi ra nuu ndaꞌa ra, ra nditiandiaa ndaꞌa ra nuu yaa ra küvi kaꞌan kan. ");
INSERT INTO mxv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ra ndoniꞌi ra nuu ra chi ndivi, ra ndixaka ini ra, ra ndikaꞌan ra kachi ra saa: ―¡Efata! ―kachi ra. Tu̱ꞌun yoꞌo kachi ña saa: “Na ndanuña ña”. ");
INSERT INTO mxv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Saa ra ndikun ndanuña ndixa va soꞌo ra, ra ndukama tu yaa va ra, ra ndikun vaꞌa ndakaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ra ndikaꞌan Jesús xiꞌin na, ña na ndatüꞌun na xiꞌin ndia nii yuvi xaꞌa ña yoꞌo; su ndi na ndiee ka xa va kuvi na, chi te kaꞌan ra xiꞌin na, ña na ndatüꞌun na xiꞌin inka yuvi xaꞌa ña xa ra xiꞌin na, ra na ndiee ka ndatuꞌun va kuvi na. ");
INSERT INTO mxv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ra ndakanda ka vi ini na yuvi kan kachi na saa: ―Vaꞌa ni ^xa Jesús chi ndia na soꞌo xiꞌin na küvi kaꞌan ra vaꞌa sanduvaꞌa ra na ―kachi na xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saa kuu iin kii ra kuaꞌa ka vi yuvi ndakaya tuku. Ra ndia nii loꞌo ñaꞌa köo niꞌi na kuxi na, saa kana Jesús ndia xika xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Kundaꞌvi ni ini yu xini yu na yuvi yoꞌo, chi xa kii uni va ke iyoo na xiꞌin yu vichin, ra köo mii ñaꞌa niꞌi na kuxi vi na ra ndaꞌvi ni na. ");
INSERT INTO mxv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ra tu saa na koo na xiꞌin so̱kò ndatiꞌvi yu na kunuꞌu na veꞌe na, saa ra kuaꞌan na ichi saa kundiëe ka na ra kuñaa nuu va na, chin sava na ke̱e xika va ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Saa ndakuiin ndia xika xiꞌin ra kachi ndia saa: ―Tata, ¿ndia mii ku kiꞌin yo ñaꞌa kuxi takundiꞌi na yoꞌo? Chi iku nuu köo yuvi va ke yoꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ra saa ndindakatuꞌun ra ndia kachi ra saa: ―¿Ndixaa ku ixta niꞌi ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Uxa va ke niꞌi ndi, tata ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Saa xaꞌndia ra chiñu ña na ndakundee takundiꞌi na yuvi kan nuu ñuꞌu. Ra kiꞌin ra uxa saa ixta kan, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra te ndiꞌi saa taꞌvi ra ña ra taxi ra ña ndaꞌa ndia xika xiꞌin ra, ña na ndataꞌvi ndia ña xiꞌin na yuvi kan; ra saa ndixa xa va ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ra niꞌi tu na iin tiꞌvi loꞌo tiaka ichi vali va, ra saa ndataxi tu ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ri kan va. Ra te ndiꞌi saa xaꞌndia ra chiñu ña na ndataꞌvi tu ndia ri kan va xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ra xixi na ndiakua nditiandiaa ini na. Ra uxa ka tuká sakutu na xiꞌin ñaꞌñu ña nindoo ndoso ndakaya na. ");
INSERT INTO mxv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ra takundiꞌi na xixi kan ra kuꞌva kumi mil yuvi kuvi na, ra te ndiꞌi saa ndindiayu taꞌan Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ra saa nandaa ra ini barca xiꞌin ndia xika xiꞌin ra, ra ndakiꞌin ndia kuaꞌan ndia chi ñuu Dalmanuta va. ");
INSERT INTO mxv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ra te ndixaa ndia ñuu kan, saa ra ndixaa tu na fariseo va ra xaꞌa na tiin taꞌan na xiꞌin Jesús, ra kaꞌan na xiꞌin ra ña na sa ra iin ña ndichi kuni na, ña ixtondoso na ra, a ndixa ndivi ke kee ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Saa ra iin ndiakua ndixaka ini ra, ña ndindiꞌi ini ra nuu na, ra ndakuiin ra kachi ra saa: ―¿Nichuun kuni̱ ni ndo kuni ndo ña xituꞌun? Ña ndixa kaꞌan yu xiꞌin ndo, ndia nii ña sä yu kuni ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Saa ndakoo Jesús na, ra nandaa tuku ra ini barca loꞌo kan, ra ndakiꞌin ra kuaꞌan ra chi inka xiyo yuꞌu mini kan xiꞌin ndia xika xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ra ndia xika xiꞌin Jesús, ra naa ini ndia ña kuꞌun ixta xiꞌin ndia kuxi ndia, ra indaa mituꞌun nuu vi ku ixta kuaꞌan xiꞌin ndia ini barca kan. ");
INSERT INTO mxv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Saa xaꞌndia Jesús chiñu nuu ndia ra kachi ra saa: ―Toꞌni ndo, ra kuenda ni koo ndo xiꞌin ixan iyá ña kuu ndavi na fariseo ra saa tu ra Herodes va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ra saa xaꞌa ndatuꞌun taꞌan mii ndia kachi ndia saa: ―A ña ndixinïꞌi yo ixta va ke kachi ra saa xiꞌin yo ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Saa xini Jesús ña xaꞌa ndatuꞌun xiꞌin taꞌan ni ndia, saa ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Ni ke ndiee ni ndatuꞌun ndo xaꞌa? ¿Nichuun kaꞌan ndo ña köo ixta niꞌi ndo? ¿A ra ndixa ke ndia nii loꞌo chiin täan kundaa ini ndo, ra nii ndakïꞌin xini ndo? ¿Nichuun ndaku ni ini ndo ña küvi xinu ini ndo saa va? ");
INSERT INTO mxv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iyoo nduchi nuu ndo ra xïni ndo; iyoo soꞌo ndo ra xïni soꞌo ndo. ¿A ndaküꞌun ini ndo xaꞌa ña xituꞌun xa yu ");
INSERT INTO mxv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","te sakuxi yu uꞌun mil yuvi, xiꞌin takua uꞌun ixta, ña xiniꞌi ndo? ¿Ra ndixaa ka tuká ixta nindoo ndoso ndakaya ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Uxi uvi ka tuká ndakiꞌin ndi, Tata ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Saa ndikaꞌan ka ra xiꞌin ndia kachi ra saa: ―Ra te sakuxi tu yu kumi mil yuvi xiꞌin uxa kuiti ixta tu, ¿ndixaa ka tuká chitu nindoo ndoso ndakiꞌin ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia kachi ndia saa: ―Uxa ka tuká ndakiꞌin ndi, Tata ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ra nani saa küvi kundaa ini ndo vichin va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Saa ndixaa Jesús ñuu Betsaida xiꞌin ndia xika xiꞌin ra. Ra ikan ndiaka na yuvi kan iin ra kuaa ndixaa ra xiꞌin na nuu Jesús, ra xakundaꞌvi na nuu ra ña na sa ra ña mani̱ chinduꞌu ra ndaꞌa ra sata ra kuaa kan. ");
INSERT INTO mxv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Saa tiin Jesús ndaꞌa ra kuaa kan ra ndiaka ra ra ndixaꞌan ra xiꞌin ra ndia nuu ñuu kan, ra ikan kondiaa ra tiasiꞌi ra nuu ra, ra te ndiꞌi chinduꞌu ra ndaꞌa ra sata ra, ra ndindakatuꞌun ra ra kachi ra saa: ―¿A xa tuvi loꞌo? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ra xa ndatuvì va loꞌo nuu ra kuaa kan, Saa ndakuiin ra kachi ra saa xiꞌin Jesús: ―Xa xini va yu na yuvi, Tata, ndi ta iin itun naꞌnu va, iin na tuvi yu, ra tu xika kuaꞌan va kuvi nuu tuvi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Saa chinduꞌu tuku Jesús ndaꞌa ra nuu ra kuaa kan, ra ndikaꞌan ra xiꞌin ra na toꞌni ra, saa ra ndikun nduvaꞌa ndixa va nuu ra, ra iin kaxi kaxi ndakotoꞌni ra iinii kuvi. ");
INSERT INTO mxv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ra saa ndatiꞌvi Jesús ra kuanuꞌu ra veꞌe ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kuaꞌan, ra kïꞌvi kun ñuu, ra ndia nii yuvi ndatüꞌun kun xiꞌin xaꞌa ña yoꞌo ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te ndiꞌi, saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia xika xiꞌin ra chi ñuu vali ña ndoꞌni ñuu Cesarea ña ndikun ndiaa Filipo. Ra nani saa kuu ndia kuaꞌan ndia ichi kan, saa ndindakatuꞌun ra ndia kachi ra saa: ―¿Yoo kuu yuꞌu kachi na yuvi? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Saa ndakuiin ndia kachi ndia saa: ―Sava na kaꞌan ña kuu kun ra Juan ra sandakuchi yuvi, ra sava tu na kaꞌan ña kuu kun ra Elías va, ra inka tu na kaꞌan xaꞌa kun ña kuu kun ndia iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va kuvi ra ndatiaku, kachi na ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ra ndoꞌo tu, ¿yo kuvi yu tuvi ndo? ―kachi ra xiꞌin ndia. Saa ndakuiin ra Pedro kachi ra saa: ―Tata, yoꞌo ku Cristo ra ndikaxin Ndioxi sakaku na yuuvi yoꞌo ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ndia nii yuvi ndatüꞌun ndo xiꞌin xaꞌa ña yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Saa xaꞌa Jesús ndakani ra nuu ndia kachi ra saa: ―Yuꞌu, ra xaa yoꞌo, ra xiniñuꞌu ndoꞌo ni yu, ra na xikuaꞌa ñuu Israel, xiꞌin na sutu kunaꞌnu, xiꞌin na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, ra kundasi ni na yuꞌu, ra kaꞌni na yuꞌu, su ndi kii uni ra ndatiaku va yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ra nditisëꞌe tuꞌun vaꞌa vi ra xaꞌa ña ndoꞌo ra chi iin kaxi kaxi va ndatuꞌun ra xiꞌin ndia. Ra saa tava siin ra Pedro Jesús ra ndiyaꞌa tuꞌun ndikaꞌan ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Saa ndikokuiin Jesús ra ndakotoꞌni ra nuu ndia xika xiꞌin ra, ra nindaꞌyu ra nuu ra Pedro nuu ndia kuaꞌa kan, kachi ra saa: ―¡Kuatiaꞌa nuu yu, timiaꞌa! Chi yoꞌo, ra süvi chiñu Ndioxi ke ndiꞌi ini kun xaꞌa sa kun chi chiñu ña xa na yuvi yoꞌo va ke kiꞌin kun kuenda xiꞌin ―kachi ra xiꞌin ra Pedro. ");
INSERT INTO mxv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ra saa ndakana Jesús ndia xika xiꞌin ra, xiꞌin na yuvi kan, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Tu ndia ndo kuni̱ kundikun yuꞌu, ra xiniñuꞌu kaꞌndia ini ndo xaꞌa mii ndo, ra ndakasoko ndo cruz ndo ra kundikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Saa chi yuvi na kuni̱ sakaku mii ra na kan kuvi na ndiꞌi xaꞌa va. Ra na sandoñuꞌu mii xaꞌa yuꞌu, xiꞌin xaꞌa tuꞌun Ndioxi, ra na kan kuvi na kuchuun kaku va. ");
INSERT INTO mxv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ra ni ke vaꞌa niꞌi vi yuvi, tu na sakanaa na iinii saa ña yuuvi yoꞌo, ra sandoñuꞌu tu na mii na? ");
INSERT INTO mxv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chi na yuuvi yoꞌo, ra ndia nii ñaꞌa kuchüun na chaꞌvi na xaꞌa ña kutiaku na. ");
INSERT INTO mxv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ra yuvi na kukaꞌan nuu tu xiꞌin yu, a xiꞌin tuꞌun yu nuu na yuvi kuachi yoꞌo vichin, saa ra, saa sa tu yuꞌu, ra xaa yoꞌo va, chi kukaꞌan nuu tu yuꞌu va xiꞌin na nuu Tata yu, ta xa na ndiko yu kixi yu xiꞌin ndie̱e̱ Iva yu, xiꞌin na yii na ku tatun ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ña ndaa kaꞌan yu xiꞌin ndo, chi sava ndoꞌo na ndee yoꞌo vichin, ra kuni nuu ndo nuu xaꞌndia Ndioxi chiñu xiꞌin takundiꞌi ndie̱e̱ ra, ra saa vi ke kuvi ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ra saa kuu ndiyaꞌa i̱ñu̱ kii, saa ndakiꞌin Jesús ra Pedro xiꞌin ra Jacobo, xiꞌin ra Juan kuaꞌan ndia xiꞌin ra iin xiki sukun. Ra ikan ndanama ra xini ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ra tikoto ña ndixi ra, ra iin yeyeꞌe nduu ña, ra iin taxa taxa nduu ña, ra yàà ka vi nduu ña, iin mii kachi̱ nduu ña; ndia nii yuvi ra kuchüun na ndasayaa ni na tikoto ta kuꞌva nduu tikoto ra yoꞌo, nii na ndakatia ni va na ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Saa ra tuꞌva ndituvi va ra Elías xiꞌin ra Moisés, ra xaꞌa ndia ndatuꞌun ndia xiꞌin Jesús ndita ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ra saa ndikaꞌan ra Pedro xiꞌin Jesús, kachi ra saa: ―Tata Maestro, tiaa ni vaꞌa ña ndee yo yoꞌo vichin, tu kuni kun ra na savaꞌa ndi uni veꞌe tuvíxi̱n vali, iin ña koo yoꞌo, ra iin ña koo ra Moisés, ra iin ña koo ra Elías ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Su ndi ra saa ka ndikaꞌan va kuvi ra, saa chi nii ndikundäa ini vi ra ni ke ndikaꞌan ra, ra iin kuaꞌan ini ndia ndee ndia ña iyuꞌvi ni ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ra saa nduxinu vi̱ko̱ ndasi ña sata ndia. Ra tiañu vi̱ko̱ kan tiaku ndikaꞌan Ndioxi, kachi ra saa: ―Ra yoꞌo ku Seꞌe yu ra ^kuꞌvi ni ini yu xini yu, ra na kandixa ndo ña kaꞌan ra xiꞌin ndo, ―kachi tachi Ndioxi kan xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ra te sakuꞌun nuu ndia ndakotoꞌni ndia, ra nii ka yuvi köo ndixini ndia, ra ndia siin ndaa mituꞌun saa va Jesús ndichi xini ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ra te saa kuu ndia nandiko ndia vaxi nuu ndia iku kan, saa ndikaꞌan Jesús xiꞌin ndia ña na ndatüꞌun ndia xiꞌin ndia nii yuvi xaꞌa ña xini ndia kuu iku kan, chi ndiakua te na ndatiaku ra xaa yoꞌo vichin, ra saa vi ke kundaa ini na. ");
INSERT INTO mxv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ña kan ke ndia nii yuvi nindatüꞌun ndia xiꞌin xaꞌa ña xini ndia. Ra xika ka vi ini ndia xaꞌa ña ndikaꞌan ra ña ndatiaku ra, chi ndikundäa ini ndia ni ke kuni kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Saa ndindakatuꞌun ndia Jesús kachi ndia saa: ―Tata, ¿nichuun kachi na maestro na sañaꞌa ley Ndioxi ña xiꞌna ka ra Elías ku ra xiniñuꞌu kunuu kixi? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ña ndixa ke, xiꞌna ka ra Elías ku ra kunuu kixi sanduvi takundiꞌi ña xiniñuꞌu kunduvi. Ra ta kuꞌva kaꞌan tuꞌun Ndioxi xaꞌa yuꞌu, ra xaa yoꞌo vichin, ña xiniñuꞌu ndoꞌo ni yu ra kundasi ni na yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ra ña ndixa ke kaꞌan yu xiꞌin va ndo, chi ra Elías ra xa kixi va ra, ra xa xa na ña kuni̱ mii na xiꞌin va ra, ta kuꞌva kachi tuꞌun Ndioxi ña ndakani ña xaꞌa ra ndia kuꞌva ke ndoꞌo ra ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Saa te ndandiko Jesús xaa ra nuu nindoo sava ka ndia xika xiꞌin ra, ra xa iin tiꞌvi chee va yuvi ndakaya ndee xiꞌin ndia xini ra, ra ikan ndee tu sava na maestro na sañaꞌa ley Ndioxi ña tiin taꞌan na xiꞌin ndia xika xiꞌin Jesús, ra ndaꞌyu na nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ra saa te xini na yuvi kan Jesús ra ndakanda ka vi ini na, saa ra ndikun ndakuita takundiꞌi na ra xinu na ndixaa na kaꞌan ndioxi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Saa ndindakatuꞌun ra ndia xika xiꞌin ra kachi ra saa: ―¿Ni ke xakuachi ndo xaꞌa xiꞌin na yuvi kaa ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Saa ndakuiin iin ra ndikaa tiañu na yuvi kan, kachi ra saa: ―Tata Maestro, yoꞌo xaa iin seꞌe yu xiꞌin yu nuu kun, chi tachi ndivaꞌa ke ndikaa ñaꞌa, ra täxi ña kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ra te ^xaa tachi ndivaꞌa yoꞌo tiin ña ra ndia ndia ka mii nuu ndúꞌu̱ ra, ra tiin ña ra kuun ña ñuꞌú, ra xaꞌa iin kee lolo yuꞌu ra, ra iin ndakaxi taꞌan nùꞌù ra, ra iin kutuun ra xa ña. Ra xa ndikaꞌan yu xiꞌin ndia xika xiꞌin kun ña na tava ndia tachi ndivaꞌa yoꞌo ini seꞌe yu kuꞌun ña, su ndi ndikuchüun ndia xiꞌin ña ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia xika xiꞌin ra: ―¿Nichuun ndaku ni ini ndo? ¿Ni ka ke kachi yu xiꞌin ndo, ña na kundaa ini ndo? Kundiëe ka ini yu nuu ndo. Naꞌa ndo xiꞌin ra loꞌo ñaa yoꞌo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Saa ndixaa na xiꞌin ra nuu Jesús. Ra te xini tachi ndivaꞌa kan Jesús, ra ndikun iin xaꞌni yiꞌi ña ra, ra iin kee ndaꞌa ra, iin kee xaꞌa ra kanduꞌu ra, ra iin chichi ñuꞌu ra ndiakua kee lolo yuꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Saa ndindakatuꞌun Jesús iva ra loꞌo kan, kachi ra saa: ―¿Xa ndixaa kuiya ke ndoꞌo ra saa? ―kachi ra xiꞌin ra. Saa ndakuiin iva ra kachi ra saa: ―Te loꞌo vi ra ke kiꞌin ña ra, Tata. ");
INSERT INTO mxv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ra tachi ndivaꞌa yoꞌo, ra nii ndiäꞌvi ichi xaa ña sakoꞌni ña ra nuu ñuꞌù, xiꞌin nuu tiakuii, ña kuni̱ ña kaꞌni ña ra; ña kan ke nduku yu ña mani nuu kun, tu na kuvi chindiee taꞌan kun xiꞌin ndi, Tata, ra na kundaꞌvi ini kun kuni kun nduꞌu, ra na sa kun ña mani xiꞌin ndi, chi ndaꞌvi ni ndi ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Tu na kandixa kun saa ra kuvi va, chin takundiꞌi na kandixa ra köo ña uꞌvi nuu na kan ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ra saa ndikun ndiee ka vi ndikaꞌan iva ra loꞌo kan, kachi ra saa: ―¡Kandixa va yu, Tata, ra chindiee taꞌan ka xiꞌin yu, ña na kandixa vaꞌa ka yu yoꞌo! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ra te xini Jesús ña xaꞌa iin kutiꞌvi na yuvi kuxaa na, saa ra ndikaꞌan ra xiꞌin tachi ndivaꞌa kan, kachi ra saa: ―Tachi ndivaꞌa ña miꞌmi, xiꞌin ña xïni soꞌo, yuꞌu ku ra xaꞌndia chiñu nuu kun. Ra na kita kun kuꞌun kun, ra nandïko ka kun tiin kun ra loꞌo yoꞌo ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Saa ra iin kokoꞌo nindaꞌyu tachi ndivaꞌa kan, ra iin xaꞌni yiꞌi tuku ña ra loꞌo kan, saa kita ña kuaꞌan ña, ra iin ta kaa ra ndixiꞌi kaa ra kanduꞌu ra xa ña, ra saa ndikaꞌan takundiꞌi na ndita kan kachi na saa: “Ndixiꞌi va ra loꞌo kaa” ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Saa tiin Jesús ndaꞌa ra loꞌo yoꞌo ra ndoniꞌi ra ra, ra ndikun ndakoo va ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ra saa ndikiꞌvi Jesús iin veꞌe ndakunduꞌu ra xiꞌin ndia xika xiꞌin ra, ra saa ndindakatuꞌun ndia ra kachi ndia saa: ―Tata, ¿nichuun ndikuchüun ndi tava ndi tachi ndivaꞌa kan? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Saa ndakuiin ra, kachi ra saa xiꞌin ndia: ―Ña xiniñuꞌu sa yo ke kaꞌan ni yo xiꞌin Ndioxi, ra na koo suꞌun yo küxi yo, ra saa ke kuchuun yo tava yo tachi ndivaꞌa ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Saa kuu ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia xika xiꞌin ra. Ra chi Galilea ke kuaꞌan ndia, ra ndiküni Jesús ña kundaa ini na yuvi xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chi takua ndia xika xiꞌin va ra kuvi ndia ndakani ra nuu, ra kachi ra saa: ―Yuꞌu, ra xaa yoꞌo, ra ndataxi na yuꞌu ndaꞌa na ñuu, ra kaꞌni na yuꞌu, su ndi kii uni ra ndatiaku tuku va yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ra ndia xika xiꞌin ra, ra nii kundäa ini ndia ni ke kaꞌan ra, ra nii xandiëe ini tu ndia ña ndakatuꞌun va ndia ra xaꞌa ña kaꞌan ra, chi iyuꞌvi ni ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Saa ndixaa ndia ñuu Capernaum. Ra te xa ndee ndia veꞌe kan, saa ndindakatuꞌun Jesús ndia kachi ra saa xiꞌin ndia: ―¿Ni xaꞌa ke ndatuꞌun kuachi ndo xiꞌin taꞌan ndo vaxi ndo ichi kan? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ra nii ndindäkuiin ndia, saa chi xaꞌa iin ra kunuu kaꞌndia chiñu nuu va ndia ke ndatuꞌun ndia vaxi ndia ichi kan. ");
INSERT INTO mxv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Saa ndakunduꞌu Jesús, ra ^ndakana ra uxi uvi saa ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ndoꞌo, ndia kuni̱ kunuu, ra xiniñuꞌu ndakundikun ndo ndia chi sata takundiꞌi na, ra xiniñuꞌu chindiee taꞌan tu ndo xiꞌin takundiꞌi va na ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Saa kana ra iin ra loꞌo ra xanindichi ra ra maꞌñu ndia, ra saa ndakunu ndiaa tu ra ra loꞌo kan, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Yuvi, na ndakiꞌin mani̱ iin ra loꞌo tan ra yoꞌo xaꞌa yuꞌu, ra yuꞌu va ku ra ndakiꞌin mani̱ na, ra na ndakiꞌin mani̱ yuꞌu, ra süvi takua yuꞌu kuvi ra ndakiꞌin mani̱ na, chi ra tiꞌvi yuꞌu vaxi va yu kuvi ra ndakiꞌin mani̱ na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Saa ndikaꞌan ra Juan xiꞌin Jesús kachi ra saa: ―Tata Maestro, ikan xini ndi xika iin tiaa ra tava ra tachi ndivaꞌa xiꞌin kivi kun, su ndi itäꞌan ra xiꞌin yo, ña kan ke ndikaꞌan ndi xiꞌin ra ña na sä ka ra saa, saa chi süvi ra xika xiꞌin yo kuvi ra, ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ra saa ndakuiin Jesús kachi saa xiꞌin ra: ―Säsi ndo nuu na, saa chi takundiꞌi yuvi na xa iin ña xituꞌun xiꞌin kivi yu, ra kïxi ka ini na kan ña kaꞌan kiꞌvi ka tu na xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi yuvi na kuëe kataꞌan xiꞌin yo, ra ndie̱e̱ va yo ke kuaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ra ndia ndia ka na na taxi iin yaxin loꞌo tiakuii koꞌo̱ ndo xaꞌa ña ^ndíku̱n ndo yuꞌu, ra ña ndixa kaꞌan yu xiꞌin ndo, chi ndïꞌi uun xaꞌa ña mani̱ kan, chi ndakiꞌin tu na kan va yaꞌvi na, xaꞌa ña mani̱ kan sa Ndioxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ra na kuu mii kuachi sakoyo iin na vali vaꞌa, na ndikun ichi yu, ra vaꞌa ka va yachi na kunuꞌni iin yuu katia chee sukun na, ra koꞌni na na ini mini ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Saa ndikaꞌan ka ra kachi ra saa: ―Tu ndaꞌa ndo kuvi ña ku mii kuachi sandakava ña ndóꞌo̱ ña sa ndo kuachi, saa ra kaꞌndia ndo ña, saa chi vaꞌa ka va ke na kiꞌvi ndo nuu kutiaku ndo iin ndisaa kii xiꞌin iin xiyo ndaꞌa ndo, nuu ña kuꞌun ndo ndiaya xiꞌin uvi saa ndaꞌa ndo nuu xixi̱ ñùꞌù, ñuu kaꞌñu, ra ndäꞌva ña, ");
INSERT INTO mxv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","chi ikan ra ñuu kaꞌñu ke iyoo va tikuxi ra xïꞌi ri, ra nii ñùꞌù ña xixi̱ kan, ra ndäꞌva ña, chin iin nduvi niñuu ke xixi̱ va ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ra tu xaꞌa tu ndo kuvi ña ku mii kuachi ña sandakava ña ndoꞌo sa ndo kuachi, saa ra kaꞌndia ndo ña, saa chi vaꞌa ka va ke na ni̱ꞌi̱ ndo kiꞌvi ndo nuu kutiaku ndo iin ndisaa kii xiꞌin iin xiyo xaꞌa ndo, nuu ña na kuꞌun ndo ndiaya xiꞌin uvi saa xaꞌa ndo, nuu ndäꞌva ñuꞌù, ");
INSERT INTO mxv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","chi ikan ra ñuu kaꞌñu ke iyoo va tikuxi, ra xïꞌi ri, ra nii ñùꞌù ña xixi̱ kan, ra ndäꞌva ña, iin nduvi niñuu ke xixi̱ va ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ra tu nduchi nuu tu ndo kuvi ña ku mii kuachi ña sandakava ña ndoꞌo sa ndo kuachi, saa ra vaꞌa ka va na tava ndo ña, saa chi vaꞌa ka va ke na ni̱ꞌi̱ ndo kiꞌvi ndo xiꞌin iin xiyo nduchi nuu ndo nuu xaꞌndia Ndioxi chiñu koo ndo, nuu ña na kuꞌun ndo ndiaya xiꞌin uvi saa xiyo nduchi nuu ndo, ");
INSERT INTO mxv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","chi ikan, ra ñu̱u kaꞌñu ke iyoo va tikuxi, ra xïꞌi ri, ra nii ñùꞌù ña xixi̱ kan, ra ndäꞌva ña, chi iin nduvi niñuu ke xixi̱ va ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Chi takundiꞌi yuvi ra xiꞌin ñuꞌù ke ku̱ꞌva takundiꞌi va na, ra takundiꞌi ñaꞌa ña soko na ra xiꞌin ñi̱i̱ ke ku̱ꞌva va ña. ");
INSERT INTO mxv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ra ña ndixa ke ñi̱i̱ ra ña vaꞌa ni kuvi va ña, ra ndi tu na ndiꞌi xaꞌa ña, ña üꞌva ka koo ña, saa ra, ndiꞌi xaꞌa va ña, ¿Ra ndixaa ka ke sa ndoꞌo ña ndasa uꞌva ndo ña, ra vaꞌa ndakuniñuꞌu tuku ndo ña? Ra ta iyoo ñi̱i̱ yoꞌo ña uꞌva ña, saa na koo ndo, ra vivii na koo ndo xiꞌin na taꞌan ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Saa kee Jesús ñuu Capernaum, ra ndakiꞌin ra kuaꞌan ra ñuu ña ndikun ndiaa Judea, ña ndoꞌni chi inka xiyo yuꞌu itia Jordán. Ra iin tiꞌvi chee yuvi ndakaya tuku xaa nuu ra ikan, ra saa xaꞌa ra sañaꞌa tuku ra na tuꞌun Ndioxi, xa ta yunaꞌa ra xa va ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Saa kuyachin sava na fariseo nuu iin ra, ra ndindakatuꞌun na ra kachi na saa: ―¿A iyoo ichi ndakoo iin tiaa yasiꞌi ra? ―kachi na xiꞌin Jesús, saa chin na kuni tandoso va kuvi na ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―¿Ndixa iyoo ndiayu ña ndakoo ra Moisés ndaꞌa ndo xaꞌa ña? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Saa ndakuiin na kachi na saa: ―Vaꞌa va ndakoo iin tiaa yasiꞌi ra kachi ndiayu ña ndakoo ra Moisés, ndi xiniñuꞌu na sandakuita ra iin tutu taxi ra ndaꞌa yasiꞌi ra, ña ndakuiin ña xaꞌa ra, ña ndixa ke xa ndakoo ra ña, saa ra xa vaꞌa va kachi ña ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Xaꞌa ña ndiee ni ini va ndo ke taxi ra Moisés ndiayu yoꞌo ndaꞌa ndo ña sa ndo saa. ");
INSERT INTO mxv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Chi xinaꞌa te sakan chituni Ndioxi ña yuuvi yoꞌo, ra siin va ndixiyo. Chi takua iin ndaa tiaa xiꞌin iin ndaa ñaꞌa va xavaꞌa ra ña na koo na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Xaꞌa ña kan ke ^ndakoo va tiaa iva ra xiꞌin siꞌi ra, ra ^ndakutaꞌan ra xiꞌin yasiꞌi ra, ra ^nduu na iin va. ");
INSERT INTO mxv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ra uvi saa na ra sa iin mituꞌun va yuvi nduu na, ra süvi ka uvi yuvi kuvi na, chi sa iin ndaa va nduu na. ");
INSERT INTO mxv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ra na chutaꞌan Ndioxi, ra ndia nii na yuuvi yoꞌo na satäꞌvi taꞌan ñaꞌa ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ra te xa ndaxaa Jesús chi veꞌe xiꞌin ndia xika xiꞌin ra, saa ndindakatuꞌun tuku ndia ra xaꞌa suvi ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Tiaa ra ndakoo yasiꞌi, ra tandaꞌa ra xiꞌin inka ñaꞌa, ra ley Ndioxi va ke kanduu ra, chi xasiki ra yasiꞌi ra ña nuu. ");
INSERT INTO mxv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ra saa tu iin ña siꞌi va, tu na ndakoo ña yii ña, ra tandaꞌa ña xiꞌin inka tiaa, ra ley Ndioxi ke kanduu tu ña kan va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Saa kuu ra kuaꞌa ka vi na ndixaa xiꞌin na kuachi vali seꞌe na nuu Jesús ña na chinduꞌu ra ndaꞌa ra sata na, ña sa yii ra na. Saa ra xaꞌa ndia xika xiꞌin ra nindaꞌyu ndia nuu na ndixaa xiꞌin na kuachi vali kan. ");
INSERT INTO mxv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ra te xini Jesús ña xa ndia, saa ra nindaꞌyu ra nuu ndia kachi ra saa: ―Saña ndo na vali, na kixi na nuu yu, ra säsi ndo nuu na, chi na iyoo ta kuꞌva iyoo na vali yoꞌo ku na kuchuun kiꞌvi koo xiꞌin Ndioxi nuu xaꞌndia ra chiñu chi taxi na ña xaꞌndia chiñu ra nima na. ");
INSERT INTO mxv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi takua na ndakiꞌin ichi Ndioxi ra xa na ta kuꞌva xa iin na kuachi vali, ra na kan va kuvi na kuchuun kiꞌvi koo nuu xaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Saa ndanumi ndiaa ra na vali kan ra chinduꞌu ra ndaꞌa ra sata na, ra nduku ra ña vaꞌa nuu Ndioxi xaꞌa na, ña xa yii ra na. ");
INSERT INTO mxv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ra saa te ndakiꞌin Jesús kuaꞌan ra ichi kan, saa xinu iin tiaa xaa ra xikusiti ra nuu ra, ra ndindakatuꞌun ra ra kachi ra saa: ―Tata Maestro, ra vaꞌa, ¿ni ke xiniñuꞌu sa yu ña vaꞌa kuvi ni̱ꞌi̱ taꞌvi yu kutiaku yu ndia ndikaa ndikuꞌun xiꞌin Ndioxi? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―¿Nichuun kaꞌan kun ra vaꞌa xiꞌin yu? Chi köo ndia nii yuvi na vaꞌa, chi indaa mituꞌun Ndioxi va ku ra vaꞌa, ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ra saa ndikaꞌan ka Jesús xiꞌin ra kachi ra saa: ―Xa xini va kun takundiꞌi ndiayu ña ndakoo Ndioxi, takuu ña kaꞌan ña kandüu kun Ndioxi, ra käꞌni kun ndìì, ra sasïki kun yasiꞌi kun, xiꞌin nii xakuïꞌna kun, ra chikäa kun kuachi siki yuvi, xiꞌin nii sandäꞌvi kun yuvi, ra na satoꞌo kun iva kun xiꞌin siꞌi kun, ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Saa ndakuiin tiaa yoꞌo kachi ra saa: ―Tata Maestro, te loꞌo vi yu xaꞌa yu kandixa yu takundiꞌi ña yoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ra saa kakaxi ixtoꞌni Jesús nuu ra, ra ku̱ꞌvi̱ ka vi ini ra xini ra ra, saa ndikaꞌan ra xiꞌin ra kachi ra saa: ―Iyoo va inka ña kumani nuu kun: Kuaꞌan, ra xiko kun takundiꞌi ñaꞌa ña iyoo nuu kun, ra ndataꞌvi kun xuꞌun xiꞌin na ndaꞌvi, ra saa ke kuu kun ra kuika ndivi nuu iyoo Ndioxi, ra te ndiꞌi ndakasoko kun cruz kun ra kixi kun kuꞌun yo xiꞌin yu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ra te kachi Jesús saa xiꞌin ra, saa ra, ndakava ka vi ini ra, ndia saa ra, ndakiꞌin ra kuaꞌan va ra, ra kusuchi ni ini ra chi kuika ni ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Saa ndikokuiin Jesús ra ndakotoꞌni ra nuu ndia xika xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Na kuika, ra tiaa ni uꞌvi saa kuchuun na kiꞌvi na ndivi nuu xaꞌndia Ndioxi chiñu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ra ndia xika xiꞌin Jesús ra ndakanda ka vi ini ndia xiꞌin tuꞌun yoꞌo, ra saa ndikaꞌan tuku ra xiꞌin ndia kachi ra saa: ―Seꞌe, ña ndaa kaꞌan yu xiꞌin ndo, chi tiaa ni uꞌvi kiꞌvi iin yuvi na ndiaa ni ini ña kuika ichi nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ra üꞌvi ka vi kiꞌvi iin camello yavi xaꞌa tiku, nuu ña kiꞌvi iin ra kuika ichi nuu xaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ra ndia xika xiꞌin ra, ra ndiee ka va ndakanda ini ndia, kachi ndia saa xiꞌin taꞌan ndia: ―Ra tu saa va iyoo ña, saa ra, ¿yoo va ku na kuchuun kaku tu saa? ―kachi ndia xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Saa ndakotoꞌni Jesús nuu ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Nuu na yuvi, ra tiaa ni va uꞌvi ña tuvi na, su ndi nuu Ndioxi ra köo ña uꞌvi, chi ra kan ra kuvi sa ra takundiꞌi va chiñu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ra saa xaꞌa ra Pedro kaꞌan ra xiꞌin Jesús kachi ra saa: ―Tata, nduꞌu, ra ndakoo ndiꞌi va ndi ñaꞌa ndi, ra ^ndakundikun ndi yoꞌo ^xika ndi xiꞌin kun. ¿Ra ni ke koo tu nduꞌu? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Saa ndakuiin Jesús kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi takundiꞌi yuvi na ndakoo veꞌe, xiꞌin na ndakoo ñani, xiꞌin na ndakoo kuꞌva, xiꞌin na ndakoo iva siꞌi, xiꞌin na ndakoo yasiꞌi, xiꞌin na ndakoo seꞌe, xiꞌin na ndakoo ñuꞌu, xaꞌa ña ^ndíku̱n na yuꞌu, xiꞌin xaꞌa ña ndakiꞌin na ichi Ndioxi, ");
INSERT INTO mxv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ra süvi ña uun kuvi ña, chi nuu ña yuuvi yoꞌo vichin ra kuaꞌa ni ka va ña vaꞌa ndakiꞌin na kan. Saa chi ndakiꞌin na veꞌe na xiꞌin ñani na xiꞌin kuꞌva na xiꞌin vasiꞌi na xiꞌin seꞌe na xiꞌin ñuꞌu na, ña ndakoo na; ra ndia iin ciento ka va nduu takundiꞌi ña yoꞌo ndakiꞌin na nuu ña yuuvi yoꞌo vichin. Ra vaꞌa ni ndoꞌo va na xika na ña taxi yuvi na xaꞌa ña ndikun na yuꞌu, su ndi xa saa ni̱ꞌi̱ taꞌvi̱ va na ña kutiaku na xiꞌin Ndioxi ndisaa tiempo ndia ndikaa ndikuꞌun, inka ña yuuvi ña vaxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ra saa ndikaꞌan tu ra xiꞌin ndia, kachi ra saa: ―Kuaꞌa ni na inuu vichin kuvi na ndakundikun kii kan, ra na ^ndíku̱n vichin kuvi na ndakunuu va tu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ra saa kuu iin kii kuaꞌan na chi ñuu Jerusalén, ra inuu Jesús nuu na xika xiꞌin ra kuaꞌan na, ra ndakanda ka vi ini na ra iyuꞌvi ka vi na ndikun na kuaꞌan na. Saa ndakana siin tuku ra uxi uvi saa ndia, ra xaꞌa ra ndakani tuku ra nuu ndia xaꞌa tundoꞌo ña ndoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Xa kundaa ini ndo chi vichin ke kuaꞌan yo ñuu Jerusalén, nuu ndataxi na yuꞌu, ra xaa yoꞌo, ndaꞌa na kunaꞌnu nuu na sutu, xiꞌin na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés. Ra kaꞌndia na chiñu ña na kuvi yu kachi na, ra ndataxi na yuꞌu ndaꞌa na inka ñuu, na küu judío, ");
INSERT INTO mxv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ra kusiki ni na yuꞌu, ra xaa yoꞌo, ra kani na yuꞌu xiꞌin ñii̱ ña ku kuarta, xiꞌin kondiaa na tiasiꞌi na yuꞌu, ra kaꞌni na yuꞌu, ndi su kii uni ndatiaku tuku va yu ―kachi Jesús xiꞌin ndia ña ndakani ra nuu ndia, xaꞌa ña ndoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Saa kuyachin ra Jacobo xiꞌin ra Juan ndia seꞌe ra Zebedeo nuu iin Jesús, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata Maestro, kuni̱ ndi nduku ndi iin ña mani̱ nuu kun, ra na taxi kun ña nduku ndi nuu kun ndaꞌa ndi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Saa ndindakatuꞌun ra ndia, kachi ra saa: ―¿Ndia ña mani̱ ke kuni̱ ndo sa yu xiꞌin ndo? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Saa ndakuiin ndia kachi ndia saa: ―Ña mani̱ kuni ndi sa kun xiꞌin ndi ke na taxi kun ndiayu kaꞌndia ndi chiñu xiꞌin kun nuu kaꞌndia kun chiñu; iin ndi na kunduꞌu xii̱n kuaꞌa kun, ra iin ndi na kunduꞌu xii̱n ichin kun, ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ndoꞌo, ra xïni ndo ni ke kaꞌan ndo xaꞌa vi. ¿A kiꞌin ndo kuenda ña kuchuun ndo ndoꞌo ndo tundoꞌo ña ndoꞌo yu, ra yaꞌa ndo xiꞌin yu nuu tundoꞌo ña vaxi nuu yu? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Saa ndakuiin ndia kachi ndia saa: ―Kuchuun va ndi Tata, ―kachi ndia. Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, ña ndoꞌo ni tu ndóꞌo̱ va, iin ta kuꞌva ^ndoꞌo yu, saa ndoꞌo tu ndóꞌo̱ va. ");
INSERT INTO mxv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Su ndi ña kundee ndo xitia kuaꞌa yu xiꞌin xitia ichin yu, ña kaꞌndia ndo chiñu xiꞌin yu, ra süvi yuꞌu ku ra, ra iyoo ichi taxi ña, chin Ndioxi va ku ra xini yoo ku na kundee yachin xiꞌin yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ra saa te xini soꞌo ndia uxi kan, saa ra ndiee ni xakueꞌe ndia xiꞌin ra Jacobo xiꞌin ra Juan. ");
INSERT INTO mxv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Saa ndakana Jesús uxi uvi saa ndia, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Xa xini ndo chin, na chiñu, na xïni ichi Ndioxi iyoo ña yuuvi yoꞌo, ra indaa mii na kan ku na iyoo ichi kaꞌndia chiñu, ra xanduxa na xiꞌin yuvi. ");
INSERT INTO mxv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Su ndi ndóꞌo̱, ra süvi saa ke koo ndo, chi xa siin va ke koo xiꞌin ndóꞌo̱: na kuni̱ kuu na chee, ra xiniñuꞌu sachiñu na nuu takundiꞌi va yo. ");
INSERT INTO mxv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ra ndóꞌo, na kuni̱ kunuu, ra muso nuu takundiꞌi va na ke xiniñuꞌu kuu ndo. ");
INSERT INTO mxv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi ndia nani yuꞌu, ra xaa yoꞌo, ra ndixäa yu ña kaꞌndia yu chiñu, chi ra xaa ku muso va kuvi yu, ra taxi yu mii yu ndoꞌo yu xaꞌa takundiꞌi ndo, ña vaꞌa na ni̱ꞌi̱ ndo kakù ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Saa ndixaa Jesús xiꞌin na xika xiꞌin ra ñuu Jericó. Ra te kee ra ikan kuaꞌan ra xiꞌin ndia xika xiꞌin ra, ra iin tiꞌvi chee yuvi ndikun kuaꞌan sata ra, ra ichi kan nduꞌu iin ra kuaa ndakan ra, ra Bartimeo nani ra; ra seꞌe ra Timeo kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ra saa te xini soꞌo ra kuaa kan, ña yaꞌa Jesús, ra kee ñuu Nazaret kuaꞌan ra, saa ra xaꞌa ra kana koꞌo ra kachi ra saa: ―Jesús, Seꞌe ra David, ¡kundaꞌvi ini kuni yuꞌu! ¡Ndaꞌvi ni yu! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ra kuaꞌa na ndaꞌyu nuu ra ña na koo taxin yuꞌu ra, su ndi ra ndiee ka ndaꞌyu va kuvi ra, kachi ra saa: ―Jesús, Seꞌe ra David, ¡kundaꞌvi ini kuni yuꞌu! ¡Ndaꞌvi ni yu! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Saa xikundichi Jesús, ra xaꞌndia ra chiñu ña na kana na ra kuaa kan kixi ra. Ra saa kana na ra kuaa kan, kachi na saa xiꞌin ra: ―Kuayüꞌvi kun, ndakundichi koꞌo̱, chi kana ra yoꞌo ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Saa kiꞌin ra tikoto ña isukun ra sakoꞌni ra ñuꞌu kan, ra ndakundichi ra ndixaa ra nuu iin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Saa ndindakatuꞌun Jesús ra: ―¿Ni ke kuni̱ kun sa yu xiꞌin kun? ―kachi ra xiꞌin ra. Saa ndakuiin ra kuaa kan kachi ra saa: ―Nuu va yu ke kuni̱ yu na ndanuña Tata Maestro ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Kuanuꞌu, chi xa nduvaꞌa va kun, xaꞌa ña ndinuni ni ini kun kandixa kun yuꞌu, ―kachi Jesús xiꞌin ra. Saa ra ndikun ndanuña ndixa va nuu ra, ra ndakundikun ra kuaꞌan ra xiꞌin Jesús, ichi kan. ");
INSERT INTO mxv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ra saa te kuaꞌan kuyachin Jesús nuu ñuu kaꞌnu Jerusalén xiꞌin na xika xiꞌin ra, ra yaꞌa na kuaꞌan na ñuu Betfagé, xiꞌin ñuu Betania ña ñuꞌu chi nuu ixtondiaa suꞌva iku ña nani Olivo, saa xaꞌndia ra chuun nuu uvi ndia xika xiꞌin ra, ");
INSERT INTO mxv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ñuu loꞌo ña tuvi yachin kaa, ra te ndikiꞌvi ndo kuaꞌan ndo ra ichi kan, kuni ndo nuꞌni iin burru loꞌo, ti täan koso ndia nii yuvi, ra ndaxi ndo ri na kixi ri xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ra tu ndia na ndakoyo kaꞌan xiꞌin ndo: “¿Nichuun ndaxi ndo ri?” kachi na, ra kaꞌan ndo xiꞌin na: “Iva yo ku ra kuniñuꞌu ri, ra takaꞌan va ndaxaa ri”, kachi ndo xiꞌin na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Saa ndakiꞌin ndia kuaꞌan ndia, ra te ndixaa ndia, saa xini ndia nuꞌni yachin burru loꞌo kan, ichi kuaꞌan yeꞌe na kan, saa ndaxi ndia ri. ");
INSERT INTO mxv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ra saa ndindakatuꞌun sava na ndee kan ndia kachi na saa: ―¿Nichuun kuu ndo saa ndaxi ndo burru loꞌo ñaa? ―kachi na xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Saa ndakuiin ndia yuꞌu na, ra ndikaꞌan ndia xiꞌin na iin ta kuꞌva iyoo ña kachi Jesús xiꞌin ndia, ra saa taxi na ri kuaꞌan ri xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ra saa ndiaka ndia burru loꞌo kan ndixaa ri xiꞌin ndia nuu iin Jesús, ra ti̱so ndia tikoto ndia sata ri, ra ndakoso Jesús ri kuaꞌan ra xiꞌin ndia chi ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ra kuaꞌa ni yuvi kan ra tikoto ña isukun na, ra xakin na ña iinii kuvi ichi nuu yaꞌa Jesús kuaꞌan ra, ra sava tu na kuaꞌan xaꞌnu i̱ku̱ ndaꞌa itun ra xakin na ña ichi nuu yaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ra na inuu xiꞌin na ndikun, ra iin siso siso ndaꞌyu na kachi na saa: ―¡Tata, sakaku nduꞌu! ¡Ra kaꞌnu ni kuvi yoꞌo ra vaxi xiꞌin kivi Iva yo Ndioxi! ");
INSERT INTO mxv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kaꞌnu ni ra yoꞌo, chin ra yoꞌo kuvi ra kuu rey ra kaꞌndia chiñu nuu yo, chi ra yoꞌo ku ra ndakiꞌin nuu xii xikua yo David, ra xikuu rey, ra ra kaꞌnu ni ku Iva yo Ndioxi ra nduꞌu ndivi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ra te ndixaa Jesús ñuu Jerusalén, ra saa ndikiꞌvi ra ini korra veꞌe ñuꞌu kaꞌnu kan kuaꞌan ra. Ra xini ra takundiꞌi ñaꞌa ña iyoo ikan, ra saa xa kuaꞌan kuñuu va tu, ndia saa ra, ndakiꞌin ra kuaꞌan ra chi ñuu Betania va xiꞌin ndia uxi uvi ndia xika xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ra te ndituvi inka kii, saa kee ndia ñuu Betania ra ndakiꞌin ndia vaxi tuku ndia, ra saa xaꞌa ndikaꞌun ini Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ra xika va xini ra ndichi iin itun koxi, ra vaꞌa ka vi ndukuii nu. Ra saa ndixaꞌan ra ixtoꞌni ra ndaꞌa nu, a iyoo koxi kaꞌan ra; su ndi te ndixaa ra nuu ndichi nu, ra ndia nii ri köo ndiniꞌi ra, chin takua niña i̱ku̱ va ke iyoo ndaꞌa nu, saa chi süvi tiempo ña xa ku̱chi ri kuvi ña, ra nii ri kuii̱ köo ndiniꞌi ra ndaꞌa nu. ");
INSERT INTO mxv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Saa ndikaꞌan Jesús xiꞌin itun koxi kan, kachi ra saa: ―Ndia nii ka yuvi na käxi kuiꞌi ña kuun ndaꞌa kun ―kachi ra xiꞌin nu. Ra xini soꞌo takundiꞌi ndia xika xiꞌin ra, ña kachi ra saa xiꞌin itun koxi kan. ");
INSERT INTO mxv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ra saa te ndixaa Jesús ñuu Jerusalén xiꞌin na xika xiꞌin ra, ra ndikiꞌvi ra ini korra veꞌe ñuꞌu kaꞌnu kan kuaꞌan ra. Ra saa xaꞌa ra tava ra takundiꞌi na ndee ixiko kan ra saa tu na sata nuu va na, ra tiin ra mesa na ndee nama xuꞌun xiꞌin na yuvi, ra koꞌni ra nu kan, ra saa tu tiayu na ndee ixiko paloma va. ");
INSERT INTO mxv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ra ndia nii ka na ixiko nditäxi ra kiꞌvi yeꞌe korra veꞌe ñuꞌu kaꞌnu kan. ");
INSERT INTO mxv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Saa xaꞌa ra ndakani ra nuu na kachi ra saa: ―Suꞌva kachi tuꞌun Ndioxi ña ndatiaa na xinaꞌa: “Veꞌe yu, ra veꞌe nuu kaꞌan takundiꞌi na yuvi xiꞌin Ndioxi va kunani ña.” Chin saa kachi tuꞌun Ndioxi. Su ndi ndoꞌo ra kava nuu ndakuitaꞌan na kuiꞌna va ndasa ndo ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ra te kundaa ini na maestro na sañaꞌa ley Ndioxi ña ndakoo ra Moisés, xiꞌin na kunaꞌnu nuu na sutu, ña xa Jesús ña yoꞌo, ra saa xaꞌa na xika nduku na ndixaa koo ña kaꞌni na ra, chi xaꞌa iyuꞌvi ini na xini na ra, saa chin takundiꞌi na yuvi ra kusii ka vi ini na ña xini soꞌo na ña sañaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ra saa te xa kuaꞌan kuñuu, saa kanata Jesús ñuu kan ra ndakiꞌin ra kuaꞌan ra xiꞌin ndia xika xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ra te ndituvi inka kii, saa ndiyaꞌa na ichi nuu iin itun koxi kan, ra iin ndiakua tioꞌo nu ke ndachi̱ iin nu xini na. ");
INSERT INTO mxv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ra saa ndakaꞌan ra Pedro ña satavi̱ chiꞌña Jesús nu, saa ndikaꞌan ra xiꞌin Jesús, kachi ra saa: ―Tata Maestro, ¡Koto vii! ¡Xa ndachi̱ va itun koxi, tu satavi̱ chiꞌña kun! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ndinuni ni na kandixa ndo Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, tu ndia iin ndo na kaꞌan xiꞌin iku yoꞌo, ra kachi ndo saa: “Kita nuu iin kun ña­a, ra sakoꞌni mii kun ini mini”, kachi ndo xiꞌin ña. Ra tu na kandixa vaꞌa ndo ña kaꞌan ndo, ra sä uvi ini ndo, saa ra, takundiꞌi ña kaꞌan ndo, ra xinu ndixa va nuu ña. ");
INSERT INTO mxv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ña kan ke kaꞌan yu xiꞌin ndo, xaꞌa takundiꞌi ñaꞌa ña nduku ndo nuu Ndioxi, ra tu na kandixa ndo ña xa ndakiꞌin ndo ña, ra nii täan taxi va ra ña ndaꞌa ndo, ndi xa ta iyoo ña xa ndakiꞌin va ndo iyoo ña tuvi ndo, saa ra ni̱ꞌi̱ ndixa va ndo ña. ");
INSERT INTO mxv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ra te kaꞌan ndo xiꞌin Ndioxi, ra tu väꞌa kuni ndo xini ndo iin yuvi, xaꞌa ndia iin kuachi ña xa na xiꞌin ndo, saa ra xiniñuꞌu na sakaꞌnu ini ndo xaꞌa na. Ra saa ke koo kaꞌnu tu ini Iva ndo Ndioxi, ra ^nduꞌu ndivi, xaꞌa kuachi ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chi tu na köo kaꞌnu ini ndo xaꞌa kuachi ña xa ndia iin yuvi xiꞌin ndo, saa ra nii Iva ndo Ndioxi, ra ^nduꞌu ndivi, köo kaꞌnu ini tu xaꞌa kuachi ndoꞌo va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Saa xaa tuku Jesús ñuu kaꞌnu Jerusalén xiꞌin ndia xika xiꞌin ra, ra te saa kuu ra xika ra ini veꞌe ñuꞌu kan, saa xaa na kunaꞌnu nuu na sutu, xiꞌin na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, xiꞌin na xikuaꞌa ñuu kan, ra kuyachin na nuu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ra ndindakatuꞌun na ra, kachi na saa: ―¿Yoo taxi ndiayu ndaꞌa kun ña xa kun ña yoꞌo? ¿Ni ndiayu ku mii kun ña xa kun saa? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Saa ndakuiin Jesús, kachi ra saa xiꞌin na: ―Kuni̱ tu yuꞌu va ndakatuꞌun yu ndoꞌo. Ra tu na ndakuiin ndo yuꞌu yu, ra saa ke ndatuꞌun tu yuꞌu va xiꞌin ndo yoo ko taxi ndiayu ndaꞌa yu ña xa yu suꞌva ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ra saa ndindakatuꞌun ra na, kachi ra saa: ―¿Yoo ko xaꞌndia chiñu nuu ra Juan ña sandakuchi ra yuvi? ¿Ndioxi taxi ña ndaꞌa ra, a na yuvi? Ndakuiin ndo. ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ra saa xaꞌa na kaꞌan na xiꞌin taꞌan na, kachi na saa: ―¿Ni ke kachi yo xiꞌin ra? Chi tu na kaꞌan yo: “Ndioxi va kuvi ra taxi ndiayu ndaꞌa ra”, saa ra, kachi ra saa xiꞌin yo: “¿Nichuun ndikandïxa tu ndo ña ndikaꞌan ra tu saa?”, kachi ra xiꞌin yo. ");
INSERT INTO mxv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ra tu na kachi tu yo: “Na yuvi yoꞌo va kuvi na taxi ndiayu ndaꞌa ra”, saa ra, iyo ni kaꞌni na yo ―kachi na kunaꞌnu kan xiꞌin taꞌan na. Saa chin iyuꞌvi ni na xikuaꞌa kan xini na na ñuu, chi takundiꞌi na ñuu ra ^kandixa va na ra Juan ña kuu ra, ra ndikaꞌan tuꞌun yuꞌu Ndioxi, chin Ndioxi ku ra tiꞌvi ra ña kixi va ra. ");
INSERT INTO mxv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ra xaꞌa ña kan ke ninïꞌi na ni ke kachi na, ra saa ndakuiin na kachi na saa xiꞌin Jesús: ―Kundäa ini ndi yoo taxi ndiayu ndaꞌa ra Juan ña sandakuchi ra yuvi ―kachi na. Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Saa ra nii yuꞌu ndatüꞌun tu xiꞌin ndoꞌo va, yoo ko taxi ndiayu ndaꞌa yu ña xa yu ña yoꞌo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Saa xaꞌa Jesús sañaꞌa ra na xiꞌin tuꞌun ndichi, kachi ra saa: ―Suꞌva ndoꞌo iin tiaa, ra ndataan teꞌe uva iin nuu ñuꞌu kaꞌnu, ra chikaa tu ra korra yuu va nuu ñuꞌu yoꞌo, ra kaan tu ra yavi sata kava nuu kuꞌni na uva va, ra saa xavaꞌa tu ra iin veꞌe sukun nuu kundee na kiꞌin kuenda xiꞌin teꞌe uva kan; ra te ndiꞌi saa satatu ra ña inka yuvi, ra ndakiꞌin ra kuaꞌan ra inka ñuu xika va. ");
INSERT INTO mxv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ra te nditiandiaa kii tiaꞌndia uva, saa tiꞌvi ra iin muso ra kuaꞌan nuu na tatu too ñuꞌu kan, ña na ndataxi na loꞌo kuenda ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Su ndi na tatu ñuꞌu nuu yoo teꞌe uva kan, ra ndukuiin na tiin na ra muso kan, ra kani na ra, ra sandiko vichi na ra kuanu̱ꞌu̱ ra nuu xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Saa tiꞌvi tuku ra xitoꞌo uva kan inka muso kuaꞌan nuu na, ra saa xa tu na xiꞌin ra kan va: tiin na ra, ra kuun na yuu xini ra, ra kundivaꞌa ka vi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ra saa tiꞌvi tuku ra xitoꞌo uva inka muso ra kuaꞌan nuu na yuvi kan, ra te ndixaa­ ra ndaꞌvi kan, saa ra tiin na ra, ra xaꞌni va na ra. Ra saa tiꞌvi ka ra xitoꞌo uva kan kuaꞌa ni ka na ndixaꞌan, ra saa xa tu na xiꞌin na kan va, chi sava na kani na, ra sava na xaꞌni va na. ");
INSERT INTO mxv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ra te ndiꞌi, ra köo ka na tiꞌvi ra xitoꞌo uva kan kuꞌu̱n, chi siin ndaa mituꞌun seꞌe va ra kuvi ra ndindoo xiꞌin ra, ra kuꞌvi ka vi ini ra xini ra ra. Ndia saa ra tiꞌvi ra ra kuaꞌan ra nuu va na, saa chi ndakani ini ra kaꞌan ra saa, “Satoꞌo va na seꞌe yo te na xaa ra nuu na”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Su ndi na tatu too ñuꞌu nuu yoo teꞌe uva kan, ra suꞌva va kachi na xiꞌin taꞌan na: “Ra yoꞌo va kuvi ra ndòò ndiꞌi ña yoꞌo ndaꞌa. Ra naꞌa ndo vichin, ra na tiin yo ra, ra kaꞌni yo ra, ra ñaꞌa mii yo nduu ndiꞌi va ña yoꞌo”, kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ra saa tiin ndixa va na ra, ra xaꞌni va na ra, ra saa tava na ra nuu ñuꞌu Iva ra, ra ndixaꞌan na sakana na ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ra saa ndikaꞌan Jesús, kachi ra saa: ―¿Ni ke sa Iva ra ndixiꞌi kan xiꞌin na tatu too ñuꞌu nuu yoo teꞌe uva kan tuvi ndoꞌo? Su kuꞌun ra ra kaꞌni ndiꞌi va ra, na tatu too ñuꞌu kan, ra saa ndataxi ra ña ndaꞌa inka yuvi va. Ra saa va ke koo na kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ra saa ndikaꞌan ka Jesús xiꞌin na xikuaꞌa veꞌe ñuꞌu, kachi ra saa: ―¿A täan kaꞌvi ndo tuꞌun Ndioxi ña tiaa na xinaꞌa? Ña kachi suꞌva: Yuu ña ku̱ñu̱ꞌu̱ na xavaꞌa veꞌe te yachi ku yuu ña xiniñuꞌu vaꞌa ka va vichin. ");
INSERT INTO mxv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ra Ndioxi va ku ra xa ña yoꞌo, ra ndakanda ni ini yo xiꞌin ña, kachi tuꞌun Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ra xaꞌa na xikuaꞌa veꞌe ñuꞌu kuni na tiin na ra, saa chi kundaa ini na ña xaꞌa mii va na ke ndikaꞌan ra tuꞌun ndichi yoꞌo, su ndi nditïin na ra, saa chi ndiyuꞌvi va na nuu na ñuu, na ndee xini soꞌo tuꞌun yoꞌo, ndia saa ra ndakoo na ra, ra ndakiꞌin na kuaꞌan va na. ");
INSERT INTO mxv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Saa tiꞌvi na xikuaꞌa sava na fariseo xiꞌin na ndikun sata ra Herodes kuaꞌan na nuu xika Jesús ña na kotondoso na ra, tu ndia iin tuꞌun ña väꞌa na kaꞌan ra, ra saa ke ni̱ꞌi̱ ndie̱e̱ na, ña taxi na kuachi xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ra saa ndi̱xàà na yuvi kan nuu xika Jesús, ra ndikaꞌan na xiꞌin ra kachi na saa: ―Tata Maestro, kundaa ini ndi, chi ña kaꞌan kun ra ña ndixa ni kuvi va ña, ra nii xä kun xaꞌa vi ña kaꞌan na yuvi, ra iin ku ndiꞌi va na nuu kun, köo na ndakaxin kun, chi sañaꞌa kun na ichi Ndioxi ta kuꞌva iyoo va ña. Ra yoꞌo ku ndixa va ra sañaꞌa ta kuꞌva kuni Ndioxi. Ra kaꞌan xiꞌin ndi vichin, ¿A vaꞌa ña chaꞌvi ndi nuu ra tata chiñu César ñuu Roma, xuꞌun ña nduku ra nuu ndi, a väꞌa? ¿A taxi ndi ña ndaꞌa ra a täxi ndi ña? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ra xa kundaa va ini Jesús ra ixtondoso va na kuvi ra, saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¿Nichuun xamaña ndo ra ixtondoso ndo yuꞌu? Taxi ndo iin xuꞌun kaa ndaꞌa yu na kuni yu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Saa taxi na iin xuꞌun ndaꞌa ra, ra ndindakatuꞌun ra na kachi ra saa: ―¿Yoo naꞌna ke nduꞌu nuu xuꞌun yoꞌo, ra yo kivi ke ndoso nuu ña? ―kachi Jesús xiꞌin na, Saa ndakuiin na kachi na saa: ―Naꞌna ra César, xiꞌin kivi ra kuvi ña ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Tu saa, ra taxi ndo ñaꞌa ra César ndaꞌa ra, ra ña ku kuenda Ndioxi, na taxi tu ndo ndaꞌa Ndioxi va ―kachi ra xiꞌin na. Saa ra, ndakanda ka vi ini na ña ndichi ni ndakuiin ra yuꞌu na. ");
INSERT INTO mxv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saa ndaxàà sava na saduceo nuu Jesús, ra ndindakatuꞌun na ra a ndixa ke ndatiaku na ndìì chi na saduceo, ra kuëe kandixa na ña ndatiaku na ndìì. Ña kan ke ndindakatuꞌun na Jesús kachi na saa: ");
INSERT INTO mxv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tata Maestro, ley ña ndakoo ra Moisés ndaꞌa ndi, ra suꞌva va kachi ña: “Tu iin tiaa ra iyoo yasiꞌi, ra ndikäku seꞌe ra xiꞌin ña, ra ndixiꞌi va ra, saa ra xiniñuꞌu na ndakiꞌin inka ñani ra ñaꞌa kan, ra ta xa na kaku seꞌe ña, ra ta yoo seꞌe ra ndixiꞌi kan, saa na koo ña kaku kan”, kachi ña tiaa ra Moisés. ");
INSERT INTO mxv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ra suꞌva ke kuu xiꞌin iin veꞌe: uxa tiaa xikuu ndia veꞌe ndia. Ra saa kuu tandaꞌa ñani ndia ra chee, ra ndia nii seꞌe ra ndikäku xiꞌin yasiꞌi ra, ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Saa ndakiꞌin ña inka ñani ra, ra ndikun sata ra, ra ndixiꞌi tu ra kan va, ra ndia nii seꞌe ra ndikäku xiꞌin ña. Ra saa ndakiꞌin ña inka tuku va ra, ra ndixiꞌi tu ra uni kan va. ");
INSERT INTO mxv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ra uxa saa ndia xinduꞌu ña xiꞌin va, ra ndixiꞌi uxa saa va ndia; ra ndia nii ndia ndikäku seꞌe ña xiꞌin. Saa ra ndixiꞌi tu mii va ña. ");
INSERT INTO mxv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ña kan ke kuni ndi ndakatuꞌun ndi yoꞌo: te na ndatiaku ndia kan, ¿ra yoo ku ndia kuu yii ña, chi xinduꞌu ña xiꞌin uxa saa va ndia? ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Ndo yaꞌa xini va kuvi ndo, saa chi xa xïni ndo ni ke kachi tuꞌun Ndioxi, ra xa xïni tu ndo xaꞌa ndie̱e̱ Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chi te na xaa kii ndatiaku na ndixiꞌi, na tiaa xiꞌin na siꞌi ra tandäꞌa ka na, chi xa ta iyoo mii na tatun Ndioxi, na iyoo ndivi va, nduu na. ");
INSERT INTO mxv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ra saa tu, xaꞌa ña kaꞌan ndo ña ndatiaku na ndìì va, ra suꞌva va kachi tuꞌun Ndioxi ndakani ña, ¿A täan kaꞌvi ndo tuꞌun Ndioxi ña tiaa ra Moisés, nuu ndikaꞌan Ndioxi xiꞌin ra, te xini ra xixi̱ itun ìñu̱? Ra ikan ke ndikaꞌan Ndioxi xiꞌin ra kachi ra saa: “Yuꞌu ku Ndioxi ra kañuꞌu ra Abraham, xiꞌin ra Isaac, xiꞌin ra Jacob.” ");
INSERT INTO mxv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ña kan ke na kundaa vaꞌa ini yo, chin Ndioxi, ra Ndioxi na tiaku va kuvi ra, süvi Ndioxi na ndii kuvi ra. Ra ndoꞌo, ra na täan kundaa vaꞌa ini va kuvi ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ra saa te xini soꞌo iin ra maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, ña vaꞌa ni ndakuiin Jesús yuꞌu na kan, ra saa kuyachin ra ndindakatuꞌun ra Jesús, kachi ra saa: ―¿Tata ndia ndiayu ke chee vaꞌa ka nuu takundiꞌi ña? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Ndiayu ña kaꞌnu vaꞌa ka nuu takundiꞌi ña ke yoꞌo: “Kuni soꞌo ndoꞌo na Israel, chi Iva yo Ndioxi ra indaa mituꞌun va kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ra ndinuni ni na kuꞌvi ini kun kuni kun Iva kun Ndioxi xiꞌin takundiꞌi nima kun, xiꞌin takundiꞌi ña tiaku kun, xiꞌin takundiꞌi ña xinituni kun, xiꞌin takundiꞌi ndie̱e̱ kun;” ña yoꞌo ku ndiayu ña chee vaꞌa ka nuu takundiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ra ndiayu ña uvi ku tu ña yoꞌo, ra iin nuu kaꞌan va ña: “Na kuꞌvi ini kun kuni kun na taꞌan kun ta kuꞌva kuꞌvi ini kun xini kun mii kun.” Ra köo ka ña kaꞌnu nuu ña yoꞌo ―kachi Jesús xiꞌin tiaa kan. ");
INSERT INTO mxv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Saa ndakuiin ra maestro sañaꞌa ley Ndioxi, kachi ra saa xiꞌin Jesús: ―Vaꞌa ni ndikaꞌan kun, Tata Maestro, ña ndixa ke, indaa mituꞌun va ku Ndioxi, ra köo ka inka Ndioxi nuu ra kan. ");
INSERT INTO mxv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ra ña kuꞌvi ini yo kuni yo Ndioxi xiꞌin takundiꞌi nima yo, xiꞌin takundiꞌi ña xinituni yo, xiꞌin takundiꞌi ña tiaku yo, xiꞌin takundiꞌi ndie̱e̱ yo, xiꞌin ña kuꞌvi ini yo kuni yo na taꞌan yo ta kuꞌva kuꞌvi ini yo xini yo mii yo, ra ndiaa yaꞌvi ni ka va ña yoꞌo nuu takundiꞌi ñaꞌa ña soko yo nuu Ndioxi ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ra te xini soꞌo Jesús ña mii ña ndixa ke ndikaꞌan ra maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, saa ra ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Xa yachin ni va iyoo kun ichi nuu xaꞌndia Ndioxi chiñu ―kachi ra xiꞌin ra. Ndia saa ra ndia nii ka na ndixändiee ini ña ndakatuꞌun na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Saa ndikaa Jesús ini korra veꞌe ñuꞌu sañaꞌa ra na yuvi, ra ndindakatuꞌun ra na kachi ra saa: ―¿Nichuun kaꞌan na maestro sañaꞌa ley Ndioxi ña seꞌe xikua ra David kuvi ra tiꞌvi Ndioxi xaa sakaku ña yuuvi yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ra ra David, ra suꞌva va kachi ra, ndikaꞌan ra xiꞌin ndie̱e̱ Tachi Yii Ndioxi: “Suꞌva kachi Ndioxi xiꞌin Iva yu, ‘Naꞌa, koo kun chi xii̱n kuaꞌa yu, ra vaꞌa sandiꞌi yu xaꞌa takundiꞌi na iyoo kuachi xiꞌin kun’”, kachi Ndioxi, kachi ra David. ");
INSERT INTO mxv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndatuꞌun ndo xiꞌin yu, ¿Ndixaa ke iyoo ña, ña kaꞌan ra David ña ku Iva ra, ra tiꞌvi Ndioxi kixi, ra kaꞌan tu na ña kuu ra seꞌe xikua va ra? ―kachi Jesús xiꞌin na. Ra kuaꞌa ka vi na ndee xini soꞌo ña kaꞌan ra, ra kusii ka vi ini na. ");
INSERT INTO mxv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ra saa sakuaꞌa ka Jesús na, kachi ra saa: ―Kuenda ni koo ndo, ra xä ndo ta xa na sañaꞌa ley Ndioxi ña ndakoo ra Moisés, chi na yoꞌo ra kotoo ni na kundixi na tikoto nani̱, ra kuni ni tu na na satoꞌo ni yuvi na te ndakutaꞌan na xiꞌin na nuu yaꞌvi. ");
INSERT INTO mxv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ra saa tu te kuaꞌan na veꞌe ñuꞌu a te kuaꞌan na viko, ra xini sii ni na kundee na tiayu tu ndee na kunaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ra sandaꞌvi ni tu na, na siꞌi na ndukuaan va, chi kindiaa na ñaꞌa ña ku mii na ndaꞌa na. Ra ña kuni na kindoo vaꞌa na nuu na ñuu, ra naꞌa ka vi kaꞌan na xiꞌin Ndioxi. Ra ña xa na ña yoꞌo, ra chee ni ka tundoꞌo vaxi nuu na sa Ndioxi ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Saa nduꞌu Jesús ini korra veꞌe ñuꞌu, ra yachin kan iin iin ñaꞌa nuu taan na xuꞌun ña soko na. Ra ixtoꞌni ra ña soko ka vi na xuꞌun, ra kuaꞌa ka vi xuꞌun soko sava na kuika. ");
INSERT INTO mxv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ra saa ndi̱xa̱a̱ iin ña siꞌi ndaꞌvi ndixiꞌi yii, ndisoko ña uvi xuꞌun kàà vali nuu Ndioxi, ra uvi saa ku mii xuꞌun loꞌo va ña. ");
INSERT INTO mxv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Saa ra ndakana Jesús ndia xika xiꞌin ra, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi ndiaa yaꞌvi ni ka va xuꞌun ña ndisoko ña ndaꞌvi kaa nuu ña ndisoko takundiꞌi na kan. ");
INSERT INTO mxv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi vaꞌa ni kuaꞌa ni va ku xuꞌun soko na, su ndi ña xa ndoo ndoso nuu va na ke soko na. Ra ña ndaꞌvi kaa, ra takua ña kaa ku ndiꞌi xuꞌun loꞌo va ña, ra ndisoko ndiꞌi va ña ña nuu Ndioxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ra saa te kanata Jesús ini korra veꞌe ñuꞌu kan ra ndikaꞌan iin ra xika xiꞌin ra, kachi ra saa: ―¡Tata, toꞌni. Tiaa ni nduvi yuu ña kuvaꞌa veꞌe ñuꞌu yoꞌo, ra tiaa ni iyo kaa veꞌe ñuꞌu chee yoꞌo! ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Saa ndakuiin Jesús yuꞌu ra, kachi ra saa: ―¿A tiaa ni iyo kaa veꞌe ñuꞌu chee yoꞌo tuvi kun? Ndi vaxi kii ra ña ndiꞌi uun xaꞌa va kuvi ña. Chi ndia nii nuu ndichi ka ña ke ku̱ñäꞌa vi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Saa ndakiꞌin na kuaꞌan na chi iku ña nani Olivo, ña ixtondiaa ndaa nuu iin veꞌe ñuꞌu. Ra ikan ndi̱xàà Jesús ndakunduꞌu ra, ra saa kuyachin ra Pedro, ra Santiago, ra Juan, xiꞌin ra Andrés, ra ndindakatuꞌun seꞌe ndia ra kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tata, kaꞌan xiꞌin ndi, ¿ama ke kuu saa? ¿Ra ni ke sa ndi kundaa ini ndi te xa ndinumi ku saa? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Saa ndakuiin Jesús kachi ra saa: ―Kuenta ni koo ndo koto ndiaa na sandaꞌvi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi kuaꞌa ni na kixi ra kuniñuꞌu na kivi yu ña sandaꞌvi na yuvi, ra kachi na saa: “Yuꞌu ku Cristo ra tiꞌvi Ndioxi xaa sakaku na yuuvi yoꞌo”, kachi na, ra kuaꞌa ni yuvi sandaꞌvi na. ");
INSERT INTO mxv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ra te xa na xaꞌa kunisoꞌo ndo ña xa iyoo ni kuachi ra xaꞌa kunisoꞌo ndo ña kanitaꞌan ni na yuvi, saa ra kuayüꞌvi ndo, chi xiniñuꞌu saa ke kuu va. Su ndi süvi ña xa ndiꞌi xaꞌa kuvi ña yuuvi. ");
INSERT INTO mxv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ra kuaꞌa ni ñuu ra kanitaꞌan ña xiꞌin taꞌan ña, ra saa tu ñuu ña kunaꞌnu va, chi kanitaꞌan ni tu ña kan va xiꞌin taꞌan ña; ra kuaꞌa ni ñuu ndiee ni taan, ra kundikaa ni so̱kò, ra kanitaꞌan ni yuvi xiꞌin taꞌan na; ndi süvi ña xa ndinumi ndiꞌi xaꞌa kuvi ña yuuvi yoꞌo, chi sakan ña xaꞌa va ku tundoꞌo yoꞌo ña satixuꞌvi ña na. ");
INSERT INTO mxv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ra ndoꞌo, ra kondiaa ni ndo mii ndo; chi tiin na ndoꞌo ra kuꞌun ndo xiꞌin na nuu na chiñu, ra kuꞌun tu ndo xiꞌin na chi veꞌe ñuꞌu va, ra sandivaꞌa ni na xiꞌin ndo ra kani ni na ndoꞌo. Ra ndataxi na ndoꞌo ndaꞌa na chiñu naꞌnu xiꞌin na ku rey, na kunaꞌnu xaꞌndia chiñu xaꞌa ña ndikun ndo yuꞌu; ra saa ke kuvi ndatuꞌun ndo xaꞌa yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ndi su xiniñuꞌu kunisoꞌo ndiꞌi na yuvi tuꞌun Ndioxi iin ni kuvi, ra saa ke ndiꞌi xaꞌa ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ra te na tiin na ndoꞌo kuꞌun ndo xiꞌin na nuu na chiñu, ra ndïꞌi ini ndo xaꞌa tuꞌun ña ndakuiin ndo yuꞌu na, ra nii ndakäni ini ndo; chi mii Ndioxi va kuvi ra taxi tuꞌun ña kaꞌan ndo xiꞌin na, chi süvi mii ndo kuvi ndo kaꞌan, chi Tachi Yii Ndioxi ra iyoo xiꞌin va ndo ku ra kaꞌan. ");
INSERT INTO mxv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ra na iyoo ñani, ra xi̱ko̱ taꞌan na xiꞌin na ra ndataxi na na, ña kuvi na xaꞌa tuꞌun Ndioxi, ra na iyoo seꞌe ra xi̱ko̱ taꞌan tu na kan va xiꞌin seꞌe na ña kuvi na xaꞌa tuꞌun Ndioxi, ra saa tu na iyoo vasiꞌi va chi xiko taꞌan tu na kan va xiꞌin vasiꞌi na ña kuvi na xaꞌa tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ra kundasi ni na yuvi yoꞌo ndóꞌo̱ xaꞌa ña ^ndíku̱n ndo yuꞌu, ra ndoꞌo, na kuchuun sandiee ini ndia kii ndiꞌi, ra ndïko ini ndo, ra ndóꞌo̱ kuvi ndo kuchuun kaku va. ");
INSERT INTO mxv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ra na ndee Judea na kunu na kuꞌun na chi iku te na kuni na ña ndivaꞌa, ña yuku, ña ndikaꞌan ra Daniel xaꞌa, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, te kachi ra saa, “Iyoo ñaꞌa ra süvi nuu koo ña ke iyoo ña.” (Ra na kaꞌvi, ra na kundaa ini na xiꞌin ña kaꞌvi na). ");
INSERT INTO mxv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ra na ndee chi xi̱ni̱ veꞌe, ra na kïꞌvi ka na veꞌe ndakiꞌin na ñaꞌa na; ");
INSERT INTO mxv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nii na ñuꞌu xachiñu iku, ra na ndïko ka na ndakiꞌin na tikoto na. ");
INSERT INTO mxv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ra ndaꞌvi ni na siꞌi na ñuꞌu seꞌe, xiꞌin na iyoo seꞌe vali te na xaa kii kuu ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kaꞌan ndo xiꞌin Ndioxi ra te na ndoꞌo ndo saa, ra na küu ña yo̱o̱ te kuun savi. ");
INSERT INTO mxv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tundoꞌo kaꞌnu ña kuu kii yoꞌo, ra ndia te xavaꞌa Ndioxi ña yuuvi yoꞌo ra täan kuu ña, iin saa ndia vichin, ra nii kii ña vaxi küu ka ña. ");
INSERT INTO mxv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ra tu kuëe ndixaꞌndia Ndioxi tiempo yoꞌo ña ndasa loꞌo ra ña, saa ra ndia nii yuvi kuvi na käku vi, su ndi xaꞌa na ^ndíku̱n sata ra, na ndikaxin ra ke xaꞌndia ra tiempo yoꞌo ra nduloꞌo va kii. ");
INSERT INTO mxv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tu ndia na kaꞌan xiꞌin ndo, kachi na saa: “¡Toꞌni ndo, yoꞌo iin Cristo!” Ra inka tu na kaꞌan: “¡Toꞌni ndo chi ra iin kaa kuvi ra!” kachi na, ra kandïxa ndo ña kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi kuaꞌa ni na maña kixi ra kachi na saa, “Yuꞌu ku Cristo”, a “Yuꞌu ku ra kaꞌan tuꞌun yuꞌu Ndioxi”, kachi na. Ra kuaꞌa ni ña ndichi xiꞌin ña xituꞌun sa na ña sandaꞌvi na yuvi, ra kusana ndia na xa ndikaxin Ndioxi kundikun ichi va ra ku̱ni̱ na sandaꞌvi na. ");
INSERT INTO mxv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ña kan ke xa kaꞌan ndiꞌi va yu ña yoꞌo xiꞌin ndo vichin, ra kiꞌin ni ndo kuenda xiꞌin mii ndo. ");
INSERT INTO mxv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ra te xa na ndiꞌi kuu tundoꞌo yoꞌo, ra saa kuñaà nuu ñuꞌù kaa, ra nii yo̱o̱ kaa ra ndayëꞌe̱ ka ri. ");
INSERT INTO mxv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ra kimi, ri ndee nuu ndivi kaa, ra ko̱yo ndiꞌi va ri, ra takundiꞌi ñaꞌa ña ndee nuu ndivi kaa ra ndakanda ndiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ra saa vi ke kuni ndo yuꞌu, ra xaa yoꞌo vichin, ña kixi tuku yu iin nuu vi̱ko̱ xiꞌin takundiꞌi ndie̱e̱ yu ña kaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ra saa ke tiꞌvi yu na tatun yu kuꞌun na kumi saa tutun ña yuuvi, ña ndakaya na na ndikaxin yu kuꞌun xiꞌin yu, na ndee ndia xaꞌa ña yuuvi yoꞌo, iin saa ndia nuu ndiꞌi ñuꞌú. ");
INSERT INTO mxv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Na kutuꞌva ndo tuꞌun ndichi xaꞌa itun koxi: Te xa xaꞌa ndu̱itia ndaꞌa nu, ra xa ndukuii nu, ra saa ke xa kundaa ini ndo ña xa kuyachin tiempo savi. ");
INSERT INTO mxv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Saa tu iyoo ña yoꞌo va, te xa xini ndo xaꞌa kuu takundiꞌi va ña yoꞌo, saa ra kuni kachi ña saa, ña xa ndinumi ni ndiko tuku va yu. ");
INSERT INTO mxv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi xiꞌna ka kuu takundiꞌi ña yoꞌo, ra saa ke kuvi na yuvi ndee tiempo vichin. ");
INSERT INTO mxv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ndivi kaa xiꞌin ñuꞌu yoꞌo, ra ña ndiꞌi xaꞌa va kuvi ña, su ndi tuꞌun yu ra ndïꞌi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ra kii xiꞌin hora te na ndiko yu, ra ndia nii na kundäa ini ama ke kuu saa, chi nii na tatun Ndioxi na iyoo ndivi ra kundäa ini na; ra ni yuꞌu, ra xaa yoꞌo, kundäa ini; chi indaa mituꞌun Iva va yu kuvi ra xini. ");
INSERT INTO mxv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ra ña kan ke kuenda ni na koo ndo, ra kaꞌan ni ndo xiꞌin Ndioxi, ra kundito ni ndo chi kundäa ini ndo ama ke ndiko yu. ");
INSERT INTO mxv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta kuꞌva xa iin tiaa ra kuaꞌan inka ñuu xika, ra ndakoo ra veꞌe ra ndaꞌa na xa chuun nuu ra ña na kondiaa na ña, ra taxi ra chuun ndaꞌa ta iin, ta iin na, ña na sa na, ra xaꞌndia tu ra chuun nuu iin ra ña na kondiaa ra yeꞌe va. ");
INSERT INTO mxv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Saa ra, xiniñuꞌu na koo tuꞌva tu ndoꞌo va, saa chi kundäa ini ndo ama ke ndiko ra Tata xiꞌin veꞌe kan; a te kuaa ke xaa ra, a sava ñu̱u ke xaa ra, a te xa kana chele va xaa ra, a te xa ndituvi va tu, ndi ndia nii na kundaa ini. ");
INSERT INTO mxv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chi kama ni va xaa ra, ra koto ndaniꞌi ra ndoꞌo ña ndee ndo kixi̱ ndo. ");
INSERT INTO mxv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ra ña kaꞌan yu xiꞌin ndoꞌo ke kaꞌan tu yu xiꞌin taku yaa va na: ra kuenda ni na koo ndo; kïxi ndo. ");
INSERT INTO mxv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ndia soo uvi kii ke kumani ra koo va viko pascua, te xixi na ixtavaꞌa ña köo ndavi xiꞌin. Ra na kunaꞌnu nuu na sutu xiꞌin na maestro sañaꞌa ley Ndioxi, ra xaꞌa na xika nduku na maña ndia kuꞌva ke tiin na Jesús, ra kaꞌni na ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ra sava tu na kachi saa: ―Sä yo saa mii viko, chi koto tiaa ni sa na yuvi xiꞌin yo ―kachi na kunaꞌnu kan xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ra chi ñuu Betania ke ndakiꞌin Jesús kuaꞌan ra, ra ndi̱xa̱a̱ ra veꞌe ra nani Simón, ra ndoꞌo kueꞌe tiaꞌyu. Ra nani saa kuu Jesús ^nduꞌu ra nuu mesa, saa xaa iin ñaꞌa, ra niꞌi ña iin yuyu loꞌo ra iin chitu ndaa ña xiꞌin ndutia ra xaꞌan tami, ra tiaa ni yaꞌvi ndutia yoꞌo, chi ra kana xiꞌin ndinuꞌu i̱ku̱ nardo kuvi ra. Saa taꞌvi ña sukun yuyu loꞌo, ña ñuꞌu ra, ra ko̱so ndiee ña ra xi̱ni̱ Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ra saa ndisaa sava na ndee yoꞌo, ra ndikaꞌan na kachi na saa: ―¿Nichuun ke ndixitia uun ndu̱tia xaꞌan tami yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A väꞌa ndikiyaꞌvi ra. Ra kusana ndia uni ciento denario yaꞌa va ki̱yaꞌvi̱ ra tu ra ndixiko yo kuvi ra; ra chindiee taꞌan yo xiꞌin na ndaꞌvi ―kachi na ña kañaꞌa na xaꞌa ñaꞌa yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Saa ndikaꞌan Jesús xiꞌin na: ―Koyaa ndo xiꞌin ña. ¿Nichuun kañaꞌa ndo xaꞌa ña? Chi ña xa ña xiꞌin yu yoꞌo, ra ña vaꞌa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chi na ndaꞌvi, ra iin ndisaa tiempo va ke iyoo na kan xiꞌin ndo, ra kuvi sa ndo ña vaꞌa xiꞌin na kan ndia ndia ka mii kii ña kuni̱ va ndo; ndi yuꞌu, ra süvi ndisaa tiempo ke koo yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ra ñaꞌa yoꞌo, ra xa kuchuun va ña xa ña ña yoꞌo chi xa chikaa va ña ndutia ra xaꞌan tami yuꞌu, ña xa na koo nduvi yu te na nduxin na yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi ndia ndia ka nuu ñuꞌu ña yuuvi yoꞌo, nuu ndatuꞌun na tuꞌun Ndioxi, ra ikan ndatuꞌun tu na xaꞌa ñaꞌa yoꞌo va, ra saa ndakaꞌan na xaꞌa ña vaꞌa xa ña. ");
INSERT INTO mxv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Saa kee ra Judas Iscariote, iin ra itaꞌan xiꞌin ndia ña kuu ndia uxi uvi ña xika ndia xiꞌin Jesús, ra kuaꞌan ra kaꞌan ra xiꞌin na kunaꞌnu nuu na sutu ña kuni ra ndataxi ra Jesús ndaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ra te xini soꞌo na ña ndikaꞌan ra Judas xiꞌin na, saa ra ndiee ni kusii ini na, ra kindoo na chaꞌvi na ra, saa ra xaꞌa xika nduku ra ndia kuꞌva ke sa ra ña vaꞌa ndataxi ra Jesús ndaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kii nuu te iyoo viko ña xixi na ixtavaꞌa ña köo ndavi xiꞌin, ra soko tu na iin ndikachi loꞌo xaꞌa kuachi na te viko pascua, ra saa ndindakatuꞌun ndia xika xiꞌin Jesús, kachi ndia saa: ―¿Ndia mii ke kuni kun kuꞌun ndi savii ndi ñaꞌa kuxini yo viko pascua vichin, Tata? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ra saa tiꞌvi Jesús uvi ndia xika xiꞌin ra, ra kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo chi ñuu. Ra ikan ndakutaꞌan ndo xiꞌin iin tiaa, ra kasoko ra iin yoo tiakuii kuaꞌan ra, ra kundikun ndo ra kuꞌun ndo. ");
INSERT INTO mxv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ra nuu xaa ra kan, ikan kaꞌan ndo xiꞌin mii ra tata xiꞌin veꞌe kan kachi ndo saa: “Suꞌva kachi ra Tata Maestro: ¿Ndia mii ku veꞌe nuu koo yu xiꞌin ndia xika xiꞌin yu ña kuxini yu viko pascua vichin? kachi ra”, kachi ndo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Saa ñaꞌa ra iin veꞌe chee ña piso ni̱nù nuu ndo ra xa iyoo nduvi ndiꞌi va ini ña. Ñaa savii ndo ñaꞌa ña kuxini yo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Saa ndakiꞌin ndia kuaꞌan ndia ñuu kan. Ra iin ta iyoo ña ndikaꞌan Jesús xiꞌin ndia, iin saa iyoo ña kuu ndixa va, ra ikan xanduvi ndiꞌi ndia chuun ña ndikaꞌan ra xiꞌin ndia sa ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ra te xa kuaꞌan kuñaà nuu ñuꞌu saa ndi̱xàà Jesús xiꞌin uxi uvi saa ndia xika xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ra ndakundee ndia nuu mesa kuxi ndia, ra nani saa kuu ndia ndee ndia xixi ndia, saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, iin ndóꞌo̱ ndia ndee xixi xiꞌin yu kuvi ndia ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ra xaꞌa kusuchi ka vi ini ndia, ra saa xaꞌa ta iin ta iin ndia ndakatuꞌun ndia Jesús kachi ndia saa: ―¿A yuꞌu ku ra sa saa, Tata? ―kachi ta iin ta iin ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Saa ndakuiin Jesús kachi ra saa: ―Iin ndoꞌo, ndia uxi uvi, ndia chindaxi ixta ini koꞌo ña xixi yu kuvi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ña ndixa ke yuꞌu, ra xaa yoꞌo, ra xiniñuꞌu ndoꞌo ni yu ta kuꞌva kachi tuꞌun Ndioxi ña tiaa na xaꞌa yu; su ndi ¡Ndaꞌvi ni ra ndataxi yuꞌu kan! Ra vaꞌa ka va kee ra ndaꞌvi tu kuëe ndikaku ra ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nani saa ku ndia ndee ndia xixi ndia, saa kiꞌin Jesús iin ixta, ra taxi ra tixaꞌvi ndaꞌa Ndioxi, ra saa taꞌvi ra ña taxi ra ndaꞌa ndia, ra kachi ra saa xiꞌin ndia: ―Kiꞌin ndo ña yoꞌo, kuxi ndo; chi ña yoꞌo ku iki kuñu yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ra saa ti̱in ra iin copa vino, ra taxi ra tixaꞌvi ndaꞌa Ndioxi, ra sayaꞌa ra copa kan ndaꞌa ndia, ra loloꞌo ra xiꞌi takundiꞌi ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Vino yoꞌo ku iin trato xaa ña kindoo yu xiꞌin ndo vichin, chi ra yoꞌo ku ni̱i̱ yu ña ku̱tia xaꞌa takundiꞌi na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ra ña ndixa ke kaꞌan yu xiꞌin ndo chi ndandïko ka yu ña koꞌo yu ndutia uva yoꞌo xiꞌin ndo; chi ndia te na xaa kii kaꞌndia Ndioxi chiñu, ndia saa vi ke koꞌo tuku yu vino xaa xiꞌin ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ra saa te sandiꞌi ndia xita ndia yaa yii, saa ke̱e ndia ndakiꞌin ndia kuaꞌan ndia chi iku ña nani Olivo. ");
INSERT INTO mxv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ñuu vichin ra takundiꞌi ndo yuꞌvi, ra ndakoo mii tuꞌun va ndo yuꞌu; chi saa kachi tuꞌun Ndioxi: “Kuvi ra kuu paxto, ra ndutia ndiꞌi va ndikachi kuꞌun ri”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ra te na ndatiaku yu, ra xiꞌna ka yuꞌu ku ra kunuu kuꞌun nuu ndo chi Galilea ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ra ndikaꞌan ra Pedro kachi ra saa xiꞌin Jesús: ―Tata, vaꞌa ni na yuꞌvi takundiꞌi va ndia ra ndakoo ndia yoꞌo, ndi yuꞌu, ra ndaköo ndaꞌa yu yoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Saa ndikaꞌan Jesús xiꞌin ra: ―Ña ndixa kaꞌan yu xiꞌin kun, chi xa uni va ichi ti̱se̱ꞌe tuꞌun kun xaꞌa yu ñu̱u vichin, ra saa kana chele uvi ichi ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ndi ra ndiee ka ndakuiin va ku ra Pedro kachi ra saa: ¡Vaꞌa ni na kuvi va yu xiꞌin kun, Tata, ndi tïseꞌe tuꞌun mii vi yu xaꞌa kun! ―kachi ra xiꞌin Jesús. Ra iin saa kachi takundiꞌi tu ndia sava kan va. ");
INSERT INTO mxv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Saa xaa Jesús xiꞌin ndia xika xiꞌin ra xaꞌa iku Olivo iin nuu nani Getsemaní, ra ikan ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Koo ndo yoꞌo, ra yuꞌu, na kuꞌun kaꞌan xiꞌin Ndioxi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ra ndikaꞌan ra xiꞌin ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan, kuaꞌan ndia xiꞌin ra. Ra saa xaꞌa kusuchi ka vi ini Jesús ra xaꞌa ndiꞌi ka vi ini ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Tiaa ni ke kusuchi ini yu, iin iyoo ini yu kuvi va yu; ra ndoꞌo, ndia ndòò yoꞌo ra kundito ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ra saa kuxika ra loꞌo nuu ndee ndia, ra ikan xikusiti ra, ra xaꞌa ra kaꞌan ra xiꞌin Ndioxi, tu ña kuvi ke ra na yaꞌa va tundoꞌo ña kuyachin vaxi yoꞌo nuu ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ra kachi ra saa kaꞌan ra xiꞌin Ndioxi: ―Abba Tata, köo ña uꞌvi nuu yóꞌo̱. Ra sayaꞌa yuꞌu ndaꞌa tundoꞌo ña vaxi yo̱ꞌo̱; ndi na köo ña kuni yuꞌu, chi na koo ña ta kuꞌva kuni mii va kun ―kachi ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Te ndiꞌi, saa nandiko ra xaa ra, ra xa ndia kixi va ku ndia ndee ndia; ra saa ndikaꞌan ra xiꞌin ra Pedro kachi ra saa: ―Simón, ¿a ra kixi va kuvi kun? ¿A ndia nii hora loꞌo vi ke ndixändiee ini kun kundito kun? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kundito ndo, ra kaꞌan ni ndo xiꞌin Ndioxi, ra na täxi ra ña koyo ndo ndaꞌa kuachi; chi ña ndixa ke: ndoꞌo, ra kuni ni va ndo kaꞌan ndo xiꞌin Ndioxi, su ndi vita ni ini ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Saa ndakiꞌin tuku ra kuaꞌan ra, ra iin saa kachi tuku va ra kaꞌan ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ra te nandiko ra, xaa tuku ra nuu ndee ndia, ra kixi tuku va ndia, chi iin vevee takaa maꞌna nuu ndia ra tiaa ni kuni kusu ndia, ra nii ninïꞌi ndia ni ke kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ra xa ichi uni va ke nandiko ra xaa ra, ndia saa ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¡Kundee ka ndo kusu va ndo! Chi xa nditiandiaa va hora ña ndataxi na yuꞌu, ra xaa yoꞌo, ndaꞌa na yuvi kuachi. ");
INSERT INTO mxv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndakoò ndo ra kuꞌun yo; chi xa kuyachin va ra ndataxi yuꞌu ndaꞌa na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sakan saa kuu ra kaꞌan ra xiꞌin ndia, saa ra xa xaa va ra Judas, ra itaꞌan xiꞌin ndia, ra iin tiaꞌndia chee na yuvi niꞌi i̱chi̱ xiꞌin itun xaa na; ra na xikuaꞌa, xiꞌin na sutu, xiꞌin na maestro sañaꞌa ley Ndioxi kuvi na tiꞌvi ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ra xa ndikataꞌan va ra Judas xiꞌin na ndia kuꞌva ke ndataxi ra Jesús ndaꞌa na. Ra suꞌva kachi ra xiꞌin na: ―Ra xaa yu kaꞌan ndioxi yu xiꞌin kan kuvi ra tiin ndo, ra tuun vaꞌa katun ndo ra, ra na kuꞌun ra xiꞌin ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te ndi̱xàà ndixa ra Judas, saa ndikun kuyachin ra nuu Jesús ra ndikaꞌan ra kachi ra saa: ―¡Tata Maestro! ¡Tata Maestro! kachi ra. Saa nditiandiaa yuꞌu ra nuu Jesús, ña ndikaꞌan ndioxi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ra na xaa xiꞌin ra, saa ra ndikun tiin ndixa va na Jesús kuaꞌan ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ra saa tava iin ra xika xiꞌin Jesús i̱chi̱, ra xaꞌndia ra iin xiyo soꞌo ra muso ra xachiñu nuu sutu ra kuchee nuu taku yaa na sutu. ");
INSERT INTO mxv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Saa ndikaꞌan Jesús xiꞌin na yuvi yoꞌo, kachi ra saa: ―¿Nichuun xaa ndo xiꞌin i̱chi̱, xiꞌin itun ña tiin ndo yuꞌu? ¿A ra kuiꞌna kuvi yu tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A su iin ndisaa kii va ndixiyo yu xiꞌin ndo ini veꞌe ñuꞌu, sañaꞌa yu ndóꞌo̱, ra nditïin ndo yuꞌu. Ndi suꞌva ke xiniñuꞌu koo va, ra saa ke xinu nuu ña kaꞌan tuꞌun Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndia saa ra xinu ndiꞌi va ndia xika xiꞌin ra kuaꞌan ndia ra ndakoo ndaꞌa va ndia ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ra ndikun iin ra loꞌo kuaꞌan ra sata Jesús, ra takua indaa manda va ke isukun vixin ra kuaꞌan ra, ra kuni tiin tu na ra kan va. ");
INSERT INTO mxv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ra xandaku ra kunuu ra ndaꞌa na, ra saña va ra manda ña isukun ra, ra xinu yala ra kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Saa ndi̱xa̱a̱ na xiꞌin Jesús nuu ra sutu, ra kuchee, ra ikan ndakutaꞌan takundiꞌi na kunaꞌnu nuu na sutu, xiꞌin na xikuaꞌa naꞌnu, xiꞌin na maestro sañaꞌa ley Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ra xika xika ^ndíku̱n ra Pedro kuaꞌan ra, iin saa ndiakua ndixaa ra ndia nuu keꞌe veꞌe ra sutu kuchee kan, ra ikan ndakunduꞌu ra xiꞌin na kumisio ndiaa yeꞌe ñuꞌu, ndasaa ra xiꞌin na nuu xixi̱ ñùꞌù kan. ");
INSERT INTO mxv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ra na kunaꞌnu nuu na sutu xiꞌin na xikuaꞌa veꞌe ñuꞌu, xaꞌa na xika nduku na kuachi Jesús, ña vaꞌa ndataxi na ra ndaꞌa na chiñu ña kaꞌni na ra, ndi ndia nii kuachi ra köo ndaniꞌi na. ");
INSERT INTO mxv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vaꞌa ni kuaꞌa ni va ku yuvi taxi kuachi siki xaꞌa Jesús, su ndi ndindäkitaꞌan tuꞌun na, chi xa siin xa siin kaꞌan iin iin va na. ");
INSERT INTO mxv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Saa ndakuita sava na ra xavaꞌa ini na xaꞌa ra, kachi na saa: ");
INSERT INTO mxv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nduꞌu xini soꞌo ña ndikaꞌan ra kachi ra saa: “Kani yu veꞌe ñuꞌu ña xavaꞌa na yuvi yoꞌo, ra kii uni saa ndakanindichi yu inka ña, ndi süvi ka ña savaꞌa ndaꞌa na kuvi ña kan”, kachi ra xini soꞌo ndi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ra vaꞌa ni saa kachi va na, su ndi xïin ña ndakitaꞌan tuꞌun na. ");
INSERT INTO mxv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Saa ndakundichi mii ra sutu kuchee maꞌñu takundiꞌi na, ra ndindakatuꞌun ra Jesús kachi ra saa: ―¿Nichuun ndakuïin kun xaꞌa ña kaꞌan na yoꞌo? ¿A ndixa kuachi kun kuvi ña kaꞌan na yoꞌo? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ra yayaa va íin Jesús ra ndia nii tuꞌun ndindäkuiin ra. Saa ndindakatuꞌun tuku mii ra sutu kuchee kan ra, kachi ra saa: ―¿A yoꞌo ku Cristo, seꞌe Ndioxi ra kaꞌnu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Suvi va yu. Ra kuni ndo yuꞌu, ra xaa yoꞌo vichin, kunduꞌu yu chi xitia kuaꞌa Ndioxi ra kaꞌnu, ra ndiko tuku yu iin nuu vi̱ko̱ kixi yu xiꞌin takundiꞌi ndie̱e̱ Ndioxi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ra saa iin ndata saa ini ra sutu kuchee yoꞌo tikoto ña ndixi ra, ra kachi ra saa: ―¿Nichuun ke kuniñuꞌu ka vi yo yuvi na kaꞌan tieꞌe nuu ra? ");
INSERT INTO mxv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi xa xini soꞌo tu ndoꞌo va, ña ndaa yuꞌu ra Ndioxi. ¿Ra a vaꞌa tuvi ndo? ―kachi ra xiꞌin na. Ra iin yuꞌu ku taku yaa va na ra kachi na saa: ―Na kuvi ra chi ndixa ke iyoo va kuachi ra, ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ra saa xaꞌa sava na kondiaa na tiasiꞌi na ra. Ra ndasi na nuu ra, ra kani na ra, ra kaꞌan na xiꞌin ra kachi na saa: ―¡Kaꞌan ndaku! ¿Yoo ko kani yoꞌo? ―kachi na xiꞌin ra ña xasiki na ra. Ra saa tu na ndiaa yeꞌe veꞌe ñuꞌu va, kani ni tu na kan va ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ra saa kuu ra Pedro nduꞌu ra nuu keꞌe chi ni̱nu̱, saa ndi̱xàà iin ñaꞌa ña xachiñu nuu ra sutu kuchee kan. ");
INSERT INTO mxv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ra te xini ña ra Pedro nduꞌu ra ndasaa ra nuu xixi ñùꞌù xiꞌin na kan, saa iin kaxi kaxi ixtoꞌni ña nuu ra, ra ndikaꞌan ña xiꞌin ra, kachi ña saa: ―Ra itaꞌan xiꞌin Jesús ra Nazaret ku tu yoꞌo va ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Saa ndakuiin ra yuꞌu ña, kachi ra saa: ―Xïni yu yo̱o̱ ku ra kaꞌan kun xaꞌa ñaa, ra nii kundäa ini yu ni ke kaꞌan kun xaꞌa ―kachi ra xiꞌin ña, chi ti̱se̱ꞌe tuꞌun va ra. Saa ndakundichi ra kanata ra yeꞌe, ra saa kana va chele. ");
INSERT INTO mxv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ra saa xini tuku va ña xachiñu kan ra, ra xaꞌa ña kaꞌan ña xiꞌin takundiꞌi na ndee kan, kachi ña saa: ―Taꞌan na kan ku tu ra yoꞌo va ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ra ti̱se̱ꞌe tuꞌun tuku va ra Pedro. Ra saa ndiyaꞌa iin kani loꞌo, ra ndikaꞌan tuku va na ndee kan xiꞌin ra Pedro, kachi na saa: ―Ña ndixa ke taꞌan na kan ku tu yoꞌo va, chi ra Galilea kuvi kun, chi iin ta ndatuꞌun na kan iin saa ndatuꞌun kun ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Saa xaꞌa ra Pedro chinaꞌa ra Ndioxi, kachi ra saa: ―¡Xïni yu ra tiaa kaꞌan ndo xaꞌa ñaa! ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ra saa kana va chele ichi ña uvi. Saa ndakaꞌan ra Pedro ña ndikaꞌan Jesús xiꞌin ra: ña “Xiꞌna ka uni ichi ke tiseꞌe tuꞌun kun xaꞌa yu, ra saa kana chele uvi ichi”, kachi Jesús xiꞌin ra. Ra te ndakaꞌan ra tuꞌun yoꞌo, saa ra xaꞌa ra xaku va ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ra ñaꞌa ni ndakutaꞌan takundiꞌi na kunaꞌnu nuu na sutu, xiꞌin na xikuaꞌa, xiꞌin na maestro sañaꞌa ley, xiꞌin takundiꞌi na chiñu ndikataꞌan na. Ra saa chikuꞌni na Jesús ra kuaꞌan na ndataxi na ra ndaꞌa ra Pilato. ");
INSERT INTO mxv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ra saa ndindakatuꞌun ra Pilato Jesús kachi ra saa: ―¿A yoꞌo ku rey na judío? ―kachi ra. Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Xa mii kun ku ra ndikaꞌan va ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Saa xaꞌa na kunaꞌnu nuu na sutu taxi ni na kuachi siki xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ra saa ndindakatuꞌun tuku va ra Pilato Jesús: ―Toꞌni, tiaa ni kuaꞌa kuachi taxi na xaꞌa kun. ¿Ra a ndakuïin vaꞌa vi kun ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ndi ndia nii tuꞌun loꞌo ndindäkuiin Jesús, saa ra ndakanda ni ini ra Pilato. ");
INSERT INTO mxv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ra vichin na kundaa ini yo, chi kii te ndatava na viko pascua, ra yunaꞌa ra Pilato ña saña ndika ra iin na ñuꞌu veꞌe kàà, ta kuiya ta kuiya, ndia ndia ka mii na kaꞌan na ñuu xaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ra mii tiempo yoꞌo ke ndikaa iin ra nani Barrabás veꞌe kàà, xiꞌin na itaꞌan xiꞌin ra, xaꞌa ña xaꞌni na ndìì, ra kani taꞌan na xiꞌin gobierno. ");
INSERT INTO mxv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Saa ndakaya na ñuu ndi̱xa̱a̱ na, ra xaꞌa na kaꞌan na xiꞌin ra Pilato ña na sa ra xa ta yunaꞌa ra xa ra, ta kuiya ta kuiya va. ");
INSERT INTO mxv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Saa ndikaꞌan ra Pilato xiꞌin na kachi ra saa: ―¿A kuni ndo na saña ndika yu ra ku Rey ndoꞌo, na judío? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Saa chi xa kundaa va ini ra Pilato xaꞌa ña ndukuini ini va na xikuaꞌa ku naꞌnu nuu na sutu xini na Jesús ke ndataxi na ra ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ra saa xaꞌa na kunaꞌnu nuu na sutu chikaa yuꞌu na na ñuu, ña na kaꞌan na xaꞌa ra Barrabás, chi ra kan kuvi ra na saña ndika ra Pilato kuni̱ na. ");
INSERT INTO mxv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Saa ndindakatuꞌun tuku ra Pilato na kachi ra saa: ―¿Ni ke kuni ndo sa yu xiꞌin ra kaꞌan ndo kuu Rey nuu ndoꞌo na judío, tu saa? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ra saa ndakuiin na, ra iin kokoꞌo ndaꞌyu na kachi na saa: ―¡Takaa ra ndaꞌa cruz! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Saa ndikaꞌan ra Pilato xiꞌin na: ―¿Nichuun? ¿Ra ndia ña ku kuachi ra yoꞌo? ―kachi ra xiꞌin na. Ndi na kan, ra na ndiee ka kaꞌan va kuvi na kachi na saa: ―¡Takaa ra ndaꞌa cruz! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ndia saa ra saña ndika va ra Pilato ra Barrabás kuaꞌan ra, chi kuni ra ña kindoo vaꞌa ra xiꞌin na yuvi kan. Ra te ndiꞌi, saa xaꞌndia ra chiñu nuu na soldado ña na kani na Jesús xiꞌin ñii̱ ña ku cuarta, ra saa ndakiꞌin na ra kuaꞌan ra xiꞌin na ña takaa na ra ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Saa ndakiꞌin na soldado Jesús kuaꞌan ra xiꞌin na chi nuu keꞌe veꞌe chiñu, ra ikan ndakutaꞌan takundiꞌi na soldado. ");
INSERT INTO mxv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ra sandakundixi na ra iin capa ña kuaꞌa, ra chikaa na corona ña xavaꞌa na xiꞌin ìñu̱ xi̱ni̱ ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ra xaꞌa na xasiki na ra kachi na saa: ―¡Ra kaꞌnu ni ku rey na judío! ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ra ndo̱o̱ ñuꞌu ku nu kuun ni na xi̱ni̱ ra, ra kondiaa na tiasiꞌi na ra, ra ndakusiti na nuu ra, ña xatoꞌo na ra, iyoo tuꞌun. ");
INSERT INTO mxv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ra te ndiꞌi xasiki na ra, ña kundivaꞌa ni na xiꞌin ra. Saa tava na capa ña xindixi ra, ra ndachikaa na tikoto mii ra sukun ra, saa ndakiꞌin na ra kuaꞌan ra xiꞌin na ña takaa na ra ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ra iin tiaa ra ke̱e ñuu Cirene, ra nani Simón, iva ra Alejandro xiꞌin ra Rufo kuvi ra, ra iku ke kee ra vaxi ra, ra te yaꞌa ra yoꞌo kuaꞌan ra, saa tiin na soldado ra ra sakuiso nduxa na cruz tun kasoko Jesús ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ra ndi̱xa̱a̱ na xiꞌin Jesús iin nuu nani Gólgota, tuꞌun yoꞌo kachi ña saa: “Iku leke xi̱ni̱ ndìì”. ");
INSERT INTO mxv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ra taxi ndia vino tia ndikava nuu mirra xiꞌin, ña na koꞌo Jesús; su ndi ndixïin ra koꞌo ra ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Saa takaa ndia soldado Jesús ndaꞌa cruz, ra xaꞌa ndia ke̱ꞌetaꞌan ndia xaꞌa tikoto ra, yo ku ndia ndakiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ra kuꞌva ka ìi̱n chi ixtiaan ke takaa ndia Jesús ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ra tiaa tu ndia nuu iin vitu loꞌo chinundiaa ndia xini cruz ra, ra ndakani tuꞌun yoꞌo ni xaꞌa ke kuvi ra: chi “Ra yoꞌo ku Rey na judío” kachi tuꞌun yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ra takaa tu ndia uvi ra kuiꞌna va ndaꞌa cruz, ra iin ra takaa ndia ndaꞌa nu iin chi kuaꞌa, ra inka ra takaa ndia ndaꞌa nu iin chi ichin va. ");
INSERT INTO mxv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ra yoꞌo ke ndixinu nuu tuꞌun Ndioxi ña ndatiaa na te yachi, ña kachi saa: ña “Ndutaꞌan ra kutaꞌan ra xiꞌin na iyoo kuachi”. ");
INSERT INTO mxv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ra na yaꞌa kuaꞌan ichi kan, ra iin xiko xi̱ni̱ na ña kañaꞌa ni na xiꞌin ra, kachi na saa: ―¡Yoꞌo ra ndikaꞌan kani veꞌe ñuꞌu Ndioxi, ra kii uni xa ndakanindichi tuku kun ña, kachi kun, ");
INSERT INTO mxv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ra sakaku mii kun vichin, ra sanùù mii kun ndaꞌa cruz ñaa, ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ra iin saa xa tu na kunaꞌnu nuu na sutu, xiꞌin na maestro sañaꞌa ley Ndioxi ña ndakoo ra Moisés, chi xasiki ni na Jesús kachi na saa xiꞌin taꞌan na: ―*Kuchuun ra sakaku ra inka yuvi, ra kuchüun tu ra sakaku ra mii ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Saa ndikaꞌan na xiꞌin Jesús kachi na saa: ―Yoꞌo ra ndikaxin Ndioxi ra ku Rey nuu nduꞌu, na Israel; nuu ndaꞌa cruz ñaa takaꞌan na kuni ndi ra kandixa ndi yoꞌo, ―kachi na xiꞌin ra. Ra ndia ndia takaa ndaꞌa cruz kan, kañaꞌa xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ra kuꞌva ka uxi uvi kaꞌñu ke, xaꞌa xikuiñaa nuu takundiꞌi ña yuuvi yoꞌo, iin saa ndia ka uni xikuaa, ");
INSERT INTO mxv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ra mii ka uni xikuaa yoꞌo ke ndiee ni ndindaꞌyu Jesús kachi ra saa: ―Eloi, Eloi, ¿lama sabactani? ―kachi ra. Ra tuꞌun yoꞌo kachi ña saa: Iva yu Ndioxi, Iva yu Ndioxi, ¿nichuun ndakoo ndaꞌa kun yuꞌu? kachi ña. ");
INSERT INTO mxv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ra sava na ndita yachin kan, ra xini soꞌo na ña ndikaꞌan ra, ra saa xaꞌa na kaꞌan na xiꞌin taꞌan na kachi na saa: ―Tiaa soꞌo ndo chi ra Elías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi va kuvi ra kana ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Saa xinu iin ra ndixaꞌan ra chindaxi ra iin koꞌndo kachi ini iin ñaꞌa nuu ñuꞌu ndutia iyá, ra chinduꞌu ra ña xi̱ni̱ iin tu ndo̱o̱ ñuꞌu, ra taxi ra ra na koꞌo Jesús, ra ndikaꞌan ra kachi ra saa: ―Na kuni yo a ndixa ke kixi ra Elías koniꞌi ra ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ra ndiee ka vi ndindaꞌyu Jesús, ndia saa ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ra tikoto yii ña tanii ini veꞌe ñuꞌu kaꞌnu ra iin nindata sava ña, chi kiꞌin ña yuꞌu ña chini̱nù ra iin saa ndia ni̱nu̱ saña taꞌan ña, ra nduu ña uvi ñaꞌñu va. ");
INSERT INTO mxv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ra ndichi yachin, ra kuchee nuu na soldado ñuu Roma, ra te xini ra ña ndixiꞌi Jesús, ra saa ndikaꞌan ra, kachi ra saa: ―Seꞌe Ndioxi kuvi ndixa va ra yoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ra xika va ndita sava na siꞌi ixtoꞌni na ña ndixiꞌi Jesús, ra tiañu na kan ndichi María Magdalena, xiꞌin ña María siꞌi ra José xiꞌin ra Jacobo ra kuloꞌo, ra ndichi tu ña Salomé va xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na siꞌi yoꞌo ra na xindikun Jesús kuvi na, ra chindiee taꞌan na xiꞌin ra te ndixika ra ñuu ña ndoꞌni chi Galilea, ra kuaꞌa ni ka va na siꞌi ndikun ndi̱xa̱a̱ xiꞌin ra ndia ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ra xikuaa te xa kuaꞌan ku ñu̱u kii viernes saa xaꞌa na xanduvi na ña ndakindiee̱ na kii yii sábado. ");
INSERT INTO mxv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ra iin ra kuchee xiꞌin na chiñu, ra José ke nani ra, ra ñuu Arimatea ke ke̱e ra, ra chikaa nda̱ku̱ ini ra ndi̱xaꞌan ra nuu ra Pilato, ra nduku ra iki kuñu Jesús ña ndakiꞌin ra ña nduxin ra. Ra ra José yoꞌo ra iin tiaa ra kandixa Ndioxi ku tu ra yoꞌo va, ra ndiatu ini ra ña xaa Ndioxi kaꞌndia ra chiñu nuu ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Saa ra ndakanda ni ini ra Pilato ña kundaa ini ra ña xa ndixiꞌi Jesús. Saa kana ra ra kuchee nuu na soldado xaa ra, ra ndindakatuꞌun ra ra a ndixa ke xa ndixiꞌi Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ra saa te ndataxi ra kuchee nuu na soldado yoꞌo nuu ra Pilato, ra kundaa kaxi ini ra ña ndixa ke saa iyoo va ña, ra saa taxi ra ndiayu ndaꞌa ra José ña na ndakiꞌin ra iki kuñu Jesús kuꞌun ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ra sata ra José iin manda xaa, ña vaꞌa, ra koniꞌi ra Jesús ra ndasuvi ra ra xiꞌin manda kan, ra ndixaꞌan ra ndinduxin ra ra ini kava nuu xa kaan ra yavi te yachi, ra satuvi̱ satuvi̱ ra iin yuu chee ra ndasi ña yuꞌu yavi kan. ");
INSERT INTO mxv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ra ña María Magdalena xiꞌin ña María siꞌi ra José, ra ndita na ixtoꞌni na ndia mii ke ndinduxin na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ra saa kuu te ndiyaꞌa kii ndakindiee na, ra sata ña María Magdalena, xiꞌin ña María siꞌi ra Jacobo, xiꞌin ña Salomé, ndutia xaꞌan tami koso na sata iki kuñu Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ra ñaꞌa ni chi ixtiaan kii domingo, kii ña kiꞌin xaꞌa semana, ra te sakan kuaꞌan kanata ndaa nuu ñuꞌù, saa ndakiꞌin na kuaꞌan na nuu ndinduxin na Jesús. ");
INSERT INTO mxv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Saa kaꞌan na xiꞌin taꞌan na kachi na saa: ―¿Yoo vi kuu na sakutiaꞌa yuu ña ndasi yuꞌu yavi ra vaꞌa yaꞌa yo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ra te sakuꞌun nuu na ndakotoꞌni na yuꞌu yavi kan, ra xa ndixkutiaꞌa va yuu chee kan. ");
INSERT INTO mxv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ra te ndikiꞌvi na ini yavi kuaꞌan na, ra saa xini na iin tiaa ra itia, nduꞌu ra chi ndaꞌa kuaꞌa, ra ndixi ra iin tikoto yàà ña kani, ra ndiyuꞌvi ni na. ");
INSERT INTO mxv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Kuayüꞌvi ndoꞌo, na ndanduku Jesús ra ñuu Nazaret, ra tanii na ndaꞌa cruz, chi köo ka ra ndikaa yoꞌo, chi xa ndatiaku va ra. Toꞌni ndo nuu xindikaa ra ra kuni ndo. ");
INSERT INTO mxv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ra vichin kuaꞌan ndo ra ndatuꞌun ndo xiꞌin ndia ndixika xiꞌin ra, ra saa tu xiꞌin ra Pedro va, chi xa chi Galilea va inuu Jesús kuaꞌan ra nuu ndo, ra ikan kuni ndo ra, ra iin ta iyoo ña ndikaꞌan ra xiꞌin ndo iin saa koo ña kuni va ndo ―kachi ra xiꞌin na siꞌi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Saa kee na siꞌi yoꞌo yuꞌu yavi kan xinu na ndakiꞌin na kuaꞌan na. Ra ndiyuꞌvi ni na, ra iin ndiakua kisi ni̱nù ña na kuaꞌan na. Ra ndia nii yuvi ndindatüꞌun na xiꞌin xaꞌa ña xini na, chi ndiyuꞌvi ni na. ");
INSERT INTO mxv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ra ñaꞌa ni ixtiaan kii domingo, kii nuu ña kiꞌin xaꞌa semana, ke ndatiaku Jesús. Ra xiꞌna ka va nuu ña María Magdalena ke kanata ra. Ra ña yoꞌo ke tava Jesús uxa nuu tachi ndivaꞌa ini ta yachi. ");
INSERT INTO mxv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ra te ndiꞌi xini ña Jesús, ra saa kee ña kuaꞌan ña ndatuꞌun ña xiꞌin ndia ndixika xiꞌin ra, ña xa ndatiaku va ra. Ra kusuchi ka vi ini ndia xaku ndia ndee ndia. ");
INSERT INTO mxv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ra saa te kundaa ini ndia ña ndatuꞌun ña xiꞌin ndia ña xa xini ña Jesús, ña xa ndatiaku ra, ra ndi ndikandïxa vaꞌa vi ndia ña. ");
INSERT INTO mxv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ra saa ndita tu Jesús nuu uvi ndia ndixika xiꞌin ra, iin ichi nuu xika ndia kuaꞌan ndia iku, ra xa siin va nduu tu ra te ndita ra nuu ndia yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ra saa ndakiꞌin tu ndia yoꞌo va ndixaꞌan ndia ndatuꞌun ndia xiꞌin ndia sava kan, ña na kundaa ini ndia ña xa ndatiaku va ra; ra nii ndia yoꞌo ndikandïxa ndia kan yuꞌu vi. ");
INSERT INTO mxv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ra saa kuu ndita Jesús nuu uxi iin saa ndia ndixika xiꞌin ra, ra ndia ndee xixi kuvi ndia yoꞌo te xaa ra nuu ndia. Ra saa ndikaꞌan ra xiꞌin ndia xaꞌa ña ndaku ni ini ndia, chi ndikandïxa vaꞌa vi ndia yuꞌu na, ndatuꞌun xiꞌin ndia ña xa xini na ndatiaku ra. ");
INSERT INTO mxv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kuaꞌan ndo iinii kuvi ña yuuvi ra kaꞌan ndoso ndo tuꞌun vaꞌa, tuꞌun Ndioxi nuu iin takundiꞌi na yuvi. ");
INSERT INTO mxv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ra na kandixa tuꞌun yu, ra kuchi na; ra na kan kuvi na kaku va; ra na xïin kandixa, ra na kan kuvi na ni̱ꞌi̱ tundoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ra na kandixa yuꞌu, ra ña yoꞌo ku iin seña ña koo xiꞌin na: Xiꞌin kivi yu tava na tachi ndivaꞌa, ra kaꞌan na inka nuu tuꞌun xaa; ");
INSERT INTO mxv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ra tiin ndaꞌa na ko̱o̱, ndi kuëe sa ri xiꞌin na, ra tu na kaxi na ñaꞌa ña ñuꞌu tatan xiꞌin, ra kuëe ndoꞌo na; ra chindee na ndaꞌa na sata na xiꞌi̱, ra nduvaꞌa va na xiꞌi̱ kan ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ra te ndiꞌi ndikaꞌan Iva yo Jesús takundiꞌi ña yoꞌo xiꞌin ndia, saa ra ndakuita ra kuanuꞌu ra ndivi va, ra ndakunduꞌu ra chi xitia kuaꞌa Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Saa kee ndia ndixika xiꞌin Jesús kuaꞌan ndia iinii kuvi ñuu kaꞌan ndoso ndia tuꞌun Ndioxi, ra mii Iva yo kuvi ra chindiee taꞌan xiꞌin ndia, ña xa ndia kuaꞌa ni ña ndichi, xiꞌin ña xituꞌun ra saxinu ra nuu tuꞌun ra, ña kaꞌan ndoso ndia. Amén.");
INSERT INTO mxv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tata Teófilo, xa kuaꞌa ni ndia ndatiaa xaꞌa chiñu ña xa Jesús xiꞌin yo. ");
INSERT INTO mxv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ra iin ta sañaꞌa ndia xitaꞌan xiꞌin Jesús ta yachi ke ndatiaa va ndia, saa chi ndia xitaꞌan xiꞌin Jesús kuvi ndia xini nuu takundiꞌi ña xa va ra, ra nuu mii ndia kan ke xaꞌndia Jesús chiñu ña na kaꞌan ndoso ndia tuꞌun va ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ra saa tu ke xa yuꞌu va, ña kuenda ni ndanduku ndiꞌi yu xaꞌa ña, ni ke kuu ta yachi, ra saa tu ndia kii ña ndixiꞌi va ra xiꞌin kii ña ndatiaku ra. Ra suꞌva ke xa yu ña vaꞌa ikun ikun ^tiaa yu ña xaa ña ndaꞌa kun, ña vaꞌa na kundaa ini kun xaꞌa ña ndoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ra kundaa tu ini kun xaꞌa ña sañaꞌa na yoꞌo xaꞌa Jesús va. Saa chi ña ndaa ni va ke sañaꞌa na yoꞌo ―kachi ra Lucas xiꞌin ra Teófilo. ");
INSERT INTO mxv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ta tiempo xaꞌndia chiñu ra rey Herodes nuu takundiꞌi ñuu ña xindikun ndiaa chi Judea, kuvi ña ndixiyo iin sutu ra xinani Zacarías. Ra xindiaꞌvi ndiaa ra xiꞌin iin tiꞌvi ndia sutu ndia nduꞌu kivi nani Abías. Ra ña yasiꞌi ra xinani Elisabet, ra seꞌe xikua ra Aarón xikuu uvi saa va na. ");
INSERT INTO mxv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ra toꞌo ni ndixiyo na nuu Ndioxi. Ra iin kandixa ndiꞌi va na ña xaꞌndia Ndioxi nuu na. ");
INSERT INTO mxv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ndi su ndia nii seꞌe na köo, saa chi ña numa va kuvi ña Elisabet. Ra xa kunaꞌnu ni tu mii va na. ");
INSERT INTO mxv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saa kuu nditiandiaa kii ña sa ndia sutu ndia itaꞌan xiꞌin ra Zacarías chiñu veꞌe ñuꞌu kaꞌnu ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ra xa yunaꞌa va na ña ndakaxin na iin mituꞌun sutu, ra chiꞌma nuu arta yii ini veꞌe ñuꞌu. Saa ndikaxin na ra Zacarías ña kiꞌvi ra chiꞌma ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ra te xa ndikiꞌvi ra ichiꞌma ra, saa xaꞌa yuvi na ndita chi nuu keꞌe veꞌe ñuꞌu kaꞌnu kan kaꞌan na xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ra nani saa kuu ra ichiꞌma ra, saa ra tuꞌva ndituvi va iin ra tatun Ndioxi chi xiin kuaꞌa arta yii nuu ndikaa ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ra te xini ra Zacarías ra tatun Ndioxi kan ra ndiyuꞌvi ka vi ra, ra ndakanda ka vi ini ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ra saa ndikaꞌan ra tatun Ndioxi kan xiꞌin ra, kachi ra saa: ―Kuayüꞌvi kun, Zacarías, saa chi xa xini va soꞌo Ndioxi ña ndikaꞌan kun xiꞌin ra. Ra vichin kaku iin tiaa loꞌo seꞌe yasiꞌi kun, ra Juan chinduꞌu kun kivi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ra tiaa ni kusii ini kun na kaku ra. Ra kuaꞌa ni ka tu yuvi kusii ini xiꞌin va kun ña kaku ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Saa chi ra kaꞌnu ni kuu ra loꞌo yoꞌo nuu Ndioxi; ra nii köꞌo ra ndixi, xiꞌin ndia nii ka ndutia ra saxini yuvi. Chi ta ndikaa ka ra tixi siꞌi vi ra ke, tiꞌvi Ndioxi Tachi Yii ra ña koo ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ra xiꞌin chiñu ña sa ra yoꞌo ke kuaꞌa ni na ñuu Israel ndandiko ini, ra ndakiꞌin na ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chi ra loꞌo yoꞌo kuvi ra kunuu kuꞌun nuu ra tiꞌvi Ndioxi kixi ña yuuvi yoꞌo. Ra iin ta ndixiyo ndie̱e̱ Ndioxi xiꞌin ra Elías, saa koo tu ña xiꞌin ra yoꞌo va. Saa ke kuchuun ra kaꞌan ra xiꞌin yuvi, ña na ndakundee vaꞌa na xiꞌin iva siꞌi na, xiꞌin seꞌe na; ña na köo ka na kuachi xiꞌin taꞌan na. Ra kuchuun tu ra sandiko ra ini yuvi na ndiee ni ini va, ña ndakiꞌin na ichi Ndioxi. Ra saa ke sa ra xiꞌin na, ña vaꞌa xa na koo nduvi na ndakiꞌin na Tata yo ta xa na tiꞌvi Ndioxi ra kixi ra ña yuvi yoꞌo ―kachi ra tatun Ndioxi kan xiꞌin ra Zacarías. ");
INSERT INTO mxv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Saa ndikaꞌan ra Zacarías xiꞌin ra tatun Ndioxi kan, kachi ra saa: ―¿Ni ke sa yu ña vaꞌa kundaa ini yu a ña ndixa ke kaku seꞌe yasiꞌi yu? Chi xa na naꞌnu va kuvi ndi ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ra saa ndakuiin ra tatun Ndioxi kan, kachi ra saa: ―Yuꞌu kuvi ra nani Gabriel. Ra iin ndisaa kii va iyoo nduvi yu ña xika yu chiñu nuu Ndioxi. Ra suvi kuvi ra tiꞌvi yuꞌu ña vaxi yu ndatuꞌun yu xiꞌin kun xaꞌa ña vaꞌa yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ra xaꞌa ña ndikandïxa kun ña ndikaꞌan yu xiꞌin kun ke kumiꞌmi kun vichin. Ra küvi kaꞌan kun ndia na xinu ndiꞌi ña ndikaꞌan yu xiꞌin kun, saa chi xiniñuꞌu xinu va ña ndikaꞌan Ndioxi. Ra ndia te xa na kaku seꞌe vi ndo, kuvi ña ndakaꞌan kun ―kachi ra tatun Ndioxi xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ra saa ^kuu yuvi kan ndee na ndiatu na ña kita ra Zacarías ini veꞌe ñuꞌu, ra nii köo ra kanata. Saa xaꞌa na ^ndakani ini na xaꞌa ra: “¿Ni ke ndoꞌo ra? ¿Nichuun köo ra kanata?”, kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ra te kanata ra chi keꞌe, ra ndiküvi ka kaꞌan ra xiꞌin na. Ra saa kundaa ini na ña iyoo iin ña xini ra ini veꞌe ñuꞌu kaꞌnu va. Saa chi ndia ndaꞌa va ra ke ndixika nuu na ña ndikaꞌan ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ra te ndixinu kii ña xachiñu ra Zacarías veꞌe ñuꞌu, ra saa ndakiꞌin ra kuanuꞌu ra veꞌe va ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Saa kuu ra ndikee va seꞌe ña Elisabet, yasiꞌi ra. Ra saa xinduꞌu ña veꞌe uꞌun yoo, ra ndikëe ña kuꞌun ña inka xiyo. Ra ndakani ini ña, kaꞌan ña saa: ");
INSERT INTO mxv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ndioxi ku ra xa ña mani yoꞌo xiꞌin yo, ña na kundäsi ka yuvi yoꞌo yo”, kaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ra te ndixinu i̱ñu̱ yoo ña ñuꞌu seꞌe ña Elisabet, ra saa tiꞌvi Ndioxi tatun ra, ra nani Gabriel, kuaꞌan ra ñuu Nazaret ña ndikun ndiaa chi Galilea. ");
INSERT INTO mxv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ra ikan iyoo iin ñaꞌa loꞌo kuaan ña nani María. Ra xa ña iyoo nduvi va ke ña tandaꞌa ña xiꞌin iin tiaa ra nani José. Ra seꞌe xikua ra rey David kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ra te ndikiꞌvi ra tatun Ndioxi veꞌe nuu iyoo ña loꞌo María kan, ra ndikaꞌan ra xiꞌin ña, kachi ra saa: ―Kusii ni ini Ndioxi xiꞌin kun chi vaꞌa ni ^xa kun, ra iyoo ra xiꞌin kun vichin; ra kuaꞌa ni ña vaꞌa taxi Ndioxi ndaꞌa yoꞌo nuu takundiꞌi ka na siꞌi ―*kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Saa ra ndayuꞌvi ni ini ña, ra saa ndakani ini ña xaꞌa tuꞌun ña ndikaꞌan ndioxi ra xiꞌin ña ni ke kuni kachi ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ra saa ndikaꞌan ra tatun Ndioxi xiꞌin ña, kachi ra saa: ―Kuayüꞌvi kun María, chi ña vaꞌa va kuni Ndioxi sa ra xiꞌin kun. ");
INSERT INTO mxv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ra vichin kee seꞌe kun. Ra te na kaku ra, ra chinduꞌu kun kivi ra ña kunani ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Chi ra loꞌo yoꞌo, ra ra kaꞌnu ni kuu ra, ra “Seꞌe Ndioxi Ra Kaꞌnu kuvi ra” kachi na. Ra taxi Ndioxi ndie̱e̱ ndaꞌa ra, ña kuu ra rey, ta kuꞌva ndixiyo ra rey David, xii xikua ra, ra xaꞌndia chiñu nuu na Israel. ");
INSERT INTO mxv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ra ra loꞌo yoꞌo kuvi ra kaꞌndia chiñu nuu na Israel iin ndisaa tiempo; ra ndïꞌi xaꞌa ña xaꞌndia ra chiñu ―*kachi ra tatun Ndioxi xiꞌin ña María. ");
INSERT INTO mxv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ra saa ndindakatuꞌun ña ra, kachi ña saa: ―¿Ndia kuꞌva ke kuu ña yoꞌo? Saa chi täan tandaꞌa yu ―*kachi ña xiꞌin ra tatun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Saa ndakuiin ra, kachi ra saa: ―Ndïꞌi ini kun, chi mii va Tachi Yii Ndioxi ke xinu koo xiꞌin kun; ra suvi mii ndiee Ndioxi, ra kaꞌnu ke kusaꞌvi tu sata va kun. Ña kan ke ra Yii kuvi ra kaku yoꞌo, ra Seꞌe Ndioxi, ra kaꞌnu ke kunani ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ra na kundaa ini kun chi ña kuꞌvi kuachi kun, Elisabet, ra vaꞌa ni xa ña chee kuvi va ña, ra koo va seꞌe ña. Ndi su te yachi, ra ña numa va xikuu ña, ndi su vichin, ra xa i̱ñu̱ va yoo ke ñuꞌu seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Saa chi nuu Ndioxi ra ndia nii ña üꞌvi ―*kachi ra tatun Ndioxi xiꞌin ña María. ");
INSERT INTO mxv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ra saa ndakuiin ña, kachi ña saa: ―Vaꞌa va, ta kuꞌva kuni mii Tata yo, na sa ra xiꞌin va yu. Na kuu ña ndikaꞌan kun, chi ña xa chiñu nuu ra kuvi va yu ―*kachi ña xiꞌin ra tatun Ndioxi. Ra saa nandiko ra kuanuꞌu va ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Saa kuu ra ndiyaꞌa loꞌo kii ra numi ka vi xavii ña María ra ndakiꞌin ña kuaꞌan ña iin ñuu loꞌo ña ndikaa chi kuñuꞌu ña ndikun ndiaa Judea ña kotoꞌni ña ña Elisabet. ");
INSERT INTO mxv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ra ta ndixaa ña kan, saa ndikiꞌvi ña veꞌe ra Zacarías. Ra ndikaꞌan ndioxi ña xiꞌin ña Elisabet. ");
INSERT INTO mxv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ra te xini soꞌo ña Elisabet ña ndikaꞌan ña María xiꞌin ña, saa ra ndikun kanda va seꞌe ña tixi ña. Ra saa ndixinu Tachi Yii Ndioxi sata ña Elisabet, ");
INSERT INTO mxv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ra ndiee ni ndikaꞌan ña xiꞌin ña María, kachi ña saa: ―Vaꞌa ni kee kun nuu ndiꞌi ka na siꞌi, ra vaꞌa ni kee tu seꞌe kun, ra ndikaa tixi va kun. ");
INSERT INTO mxv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Yoo vi ku yuꞌu ña vaxi kun kotoꞌni kun yuꞌu? Chi yoꞌo, ra siꞌi Tata yu Ndioxi va kuvi kun. ");
INSERT INTO mxv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saa chi ta ndikaꞌan ndioxi kun xiꞌin yu, ra ndikun kanda va seꞌe yu tixi yu, saa chi kusii ni ini ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ra vaꞌa ni kee kun, chi kandixa kun tuꞌun ña ndikaꞌan Ndioxi xiꞌin kun. Ra xinu va ña ndikaꞌan ra xiꞌin kun ―kachi ña Elisabet xiꞌin ña María. ");
INSERT INTO mxv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ra saa ndikaꞌan ña María, kachi ña saa: ―Xiꞌin ndinuni ni nima va yu ke ndasakaꞌnu yu Tata yu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ra kusii ni ini yu xiꞌin ra, chi ^sakaku ra yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ra vaꞌa ni ndaꞌvi ni va yu, ndi su ninäa ini Ndioxi xaꞌa yu. Ra iin ndisaa tiempo ña vaxi, kaꞌan na xaꞌa yu ña vaꞌa ni ^kee yu. ");
INSERT INTO mxv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chi Ndioxi ku ra iyoo ndie̱e̱, ra kuaꞌa ni ña vaꞌa ^xa ra xiꞌin yu; Ra ra yii kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ra iyoo ni ña kaꞌnu ini ra xiꞌin yuvi na xa toꞌo ñaꞌa; ra saa sa tu ra xiꞌin seꞌe ñani va na, ra saa tu xiꞌin seꞌe xikua va na. ");
INSERT INTO mxv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ra xiꞌin ndie̱e̱ Ndioxi kuvi ña xa ra ña kaꞌnu; ra sandiꞌi ra xaꞌa ña kiꞌvi, ña xani ini na tiaa ni ini. ");
INSERT INTO mxv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ra kindiaa ra ndiayu ndaꞌa na kuu rey naꞌnu. Ra ndasanaꞌnu ra na ndaꞌvi. ");
INSERT INTO mxv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ra sakuxi ra na ndaꞌvi xiꞌi soko. Ra kindiaa ra ña xixi na kuika; ra ndia nii loꞌo ka ña nindäkoo ra ndaꞌa na kuxi na. ");
INSERT INTO mxv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ra kundaꞌvi ini ra xini ra takundiꞌi yo na ñuu Israel na xachiñu nuu ra; ra chindiee taꞌan ra xiꞌin yo. Saa chi ninäa ini ra ña sa ra ña vaꞌa xiꞌin yo. ");
INSERT INTO mxv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi ta kuꞌva kindoo ra xiꞌin ra xii xikua yo Abraham, ke xa ndixa ra xiꞌin va yo; ra iin ndisaa kii ña vaxi ra näa ka ini ra xaꞌa yo ―*kachi ña María. ");
INSERT INTO mxv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ra kuꞌva uni yoo ke kuachi ña María xiꞌin ña Elisabet, ra saa ndakiꞌin ña kuanuꞌu ña veꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Saa kuu ra nditiandiaa kii, ña kaku seꞌe ña Elisabet. ");
INSERT INTO mxv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ra ta kundaa ini na veꞌe ña, xiꞌin na ndee yachin xiꞌin ña, ña xa kaku ra loꞌo seꞌe ña, ra kusii ka vi ini na, saa chi xa Ndioxi ña vaꞌa xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta ndixinu una kii kaku ra loꞌo yoꞌo, ra saa xaa na taꞌan na veꞌe na, ra chikaa na tuni Ndioxi ra. Ra te ndiꞌi xa na saa, ra saa ndikaꞌan na ña na kunani ra Zacarías, chi saa nani iva ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ndi su ndixïin siꞌi ra ña kunani ra saa, chi suꞌva va kachi ña: ―Juan va kunani ra ―kachi ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ra saa ndikaꞌan na xiꞌin ña, kachi na saa: ―¿Nichuun kunani ra saa? Ra ndia nii na veꞌe yo näni saa ―kachi na xiꞌin ña Elisabet. ");
INSERT INTO mxv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Saa ndindakatuꞌun na ra Zacarías xika ndaꞌa na nuu ra, ña kuni na kundaa ini na ndia kuꞌva ke kunani ra loꞌo seꞌe ra, kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Saa nduku ra iin vitu loꞌo nuu na, ra tiaa ra nuu nu. Ra suꞌva ke kachi ña tiaa ra: “Juan ke kunani ra”, kachi ña. Ra ndakanda ka vi ini na veꞌe ra ta xini na ña tiaa ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ra ndikun saa ndakaꞌan va ra Zacarías, ra ndasakaꞌnu ra Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ra ndakanda ka vi ini na taꞌan ra Zacarías ta xini soꞌo na xaꞌa ña kuu kan. Ra iin ndisaa kuvi ñuu kuñuꞌu ña ndikun chi Judea ndindutia ndoso tuꞌun xaꞌa ña kuu. ");
INSERT INTO mxv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ra takundiꞌi yuvi na kundaa ini ña ndoꞌo ra Zacarías ra xaꞌa na ndakani ini na, káꞌán na saa: ―¿Ndia chiñu ke kuiso ra loꞌo yoꞌo nuu Ndioxi, te na kuchee ra? ―káꞌán na. Saa chi kundaa ini takundiꞌi va na ña ndixa ke iyoo va ndiee Ndioxi xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ra ra Zacarías, iva ra loꞌo Juan, ra iyoo ni ndie̱e̱ Tachi Yii Ndioxi xiꞌin ra, ra ndikaꞌan ra tuꞌun ña taxi Ndioxi ndaꞌa ra, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kaꞌnu ni na koo Ndioxi, ra kiꞌin kuenda xiꞌin yoo, na ñuu Israel, chi xa xaa va ra sakaku ra yoo. ");
INSERT INTO mxv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chi xa tiꞌvi va ra iin ra chee, vaxi sakaku yoo, ra ra kan, ra seꞌe xikua ra rey David, ra xachiñu nuu Ndioxi va kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ra ta iyoo ña ndikaꞌan na, na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, saa ke iyoo ña xa ra xiꞌin va yo. Ra suꞌva kachi na: ");
INSERT INTO mxv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Sakaku ra yoo nuu na kani taꞌan xiꞌin yo, ra saa tu nuu na sáa̱ ini xini yoo va. ");
INSERT INTO mxv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ra ña yoꞌo ke xa ra xiꞌin yo, xaꞌa ña kundaꞌvi ini ra xini ra na xii xikua yo; ra ndakaꞌan tu ra xaꞌa tuꞌun vaꞌa ña yii, ña kindoo ra xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ra ña yoꞌo ku tuꞌun ña vaꞌa ña kindoo Ndioxi xiꞌin ra xii xikua yo Abraham, ña sa ra xiꞌin yo: ");
INSERT INTO mxv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ña sakaku ra yoo nuu takundiꞌi na kani taꞌan xiꞌin yo, ra kuayüꞌvi ka yo nuu na. Ra saa ke ndinuni ni ka yo sachiñu yo nuu ra, ra ndasakaꞌnu yo ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ra sä ka yo ña väꞌa, ra vii ni na kundee yo, ra ña ndaku va na sa yo nuu ra iin ndisaa kii ña vaxi. ");
INSERT INTO mxv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ra yoꞌo tu, ra loꞌo seꞌe mii yu, ra ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi, ra kaꞌnu, va kuu kun. Ra kunuu kun nuu Tata yo kuꞌun kun ña ndasavii kun ichi ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ra taxi kun xini na ñuu yo, Israel, ña koo kaꞌnu va ini Ndioxi xaꞌa kuachi yo, ra sakaku va ra yoo, ");
INSERT INTO mxv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","xaꞌa ña kundaꞌvi ni ini ra xini ra yoo. Ra ta kuꞌva yeꞌe ñuꞌù inka kii xaa, saa yeꞌe ra xaa ra nuu yo, ña kee ra ndivi. ");
INSERT INTO mxv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ña vaꞌa na taxi ra ndayeꞌe nuu na ndee nuu ñaa, na xa ndiatu ini kuvi. Ra ndañaꞌa ra ichi vaꞌa nuu yo ña kaka yo, kachi ra Zacarías xiꞌin ra loꞌo Juan seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Saa kuu xaꞌnu ra loꞌo Juan xiꞌin ndiee Ndioxi, ra ndixinu tiaa va ra. Ra niña iku ichi va ndixiyo ra, iin saa ndia te ndixaa kii ña ndita ra ndikaꞌan ndoso ra tuꞌun Ndioxi nuu na ñuu Israel va. ");
INSERT INTO mxv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ra suvi mii kuiya kan ke xaꞌndia ra rey Augusto chiñu ña na ndakoo ndiaꞌvi yuvi, na ndee iin ndisaa kuvi ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ra sakan ichi nuu ke ndakoo ndiaꞌvi ndiꞌi yuvi te xaꞌndia ra Cirenio chiñu nuu ñuu ña ndikun ndiaa Siria. ");
INSERT INTO mxv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ra xiniñuꞌu kuꞌun ndiꞌi va yuvi ñuu nuu kee xii xikua na ña ndakaꞌyu kivi na. ");
INSERT INTO mxv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ra xaꞌa ña kan ke, ke̱e ra José ñuu Nazaret ña ndikundiaa chi Galilea. Ra ndakiꞌin ra kuaꞌan ra ña ndakaꞌyu kivi ra ñuu Belén ña ndikundiaa chi Judea, nuu kaku ra rey David, xii xikua ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ra kuaꞌan tu ña María va xiꞌin ra, ña ndakaꞌyu kivi ña ñuu Belén, ra xa iyoo nduvi va ña ña tandaꞌa ña xiꞌin ra José, ndi su xa ^ñuꞌu va seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ra nani saa kuu na ndee na ñuu Belén kan, ra nditiandiaa va kii ña ^kaku seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ra saa kaku ra loꞌo seꞌe nuu ña María. Ra suvi ña ra iin tikoto loꞌo, ra chikanduꞌu ña ra ini xatun nuu ñuꞌu iku xaxi kiti, saa chi ndinïꞌi na veꞌe nuu koo na, ra ndia veꞌe nuu kixi kiti va ndiniꞌi na. ");
INSERT INTO mxv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ra suvi mii ñuu te kaku Jesús, ra ndee ndia paxto ndiaa ndia ndikachi sana ndia iku ña ndikaa yachin nuu ñuu Belén kan. ");
INSERT INTO mxv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ra saa kuu ndia ndee ndia, ra iin kuu suꞌva ra ndituvi va iin ra tatun Ndioxi nuu ndia. Ra ndayeꞌe ndiꞌi nuu ndee ndia xiꞌin ndiee Ndioxi, ra ndiyuꞌvi ka vi ndia paxto kan. ");
INSERT INTO mxv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ra saa ndikaꞌan ra tatun Ndioxi kan xiꞌin ndia, kachi ra saa: ―Kuayüꞌvi ndo, chi ña vaꞌa va vaxi yu ndatuꞌun yu xiꞌin ndo. Chi iin kusii ini takundiꞌi va na yuuvi yoꞌo xaꞌa ña ndatuꞌun yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chi vichin kaku iin ra loꞌo ñuu Belén, nuu kaku ra rey David; ra ra loꞌo yoꞌo ku Cristo, ra kaꞌnu nuu yo, ra ra ndikaxin Ndioxi sakaku ndoꞌo kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ra kuaꞌan ndo kotoꞌni ndo. Chi suꞌva ke kaa ra kuni ndo: Isuvi ra iin tikoto loꞌo, ra kanduꞌu ra ini xatun nuu ñuꞌu iku xaxi kiti ―kachi ra tatun Ndioxi xiꞌin ndia paxto. ");
INSERT INTO mxv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ra iin kuu suꞌva, ra kuaꞌa ka vi na tatun Ndioxi ndakoyo ra ndakuitaꞌan na xiꞌin ra tatun Ndioxi kan. Ra saa xaꞌa na ^ndasakaꞌnu ka vi na Ndioxi, kachi na saa: ");
INSERT INTO mxv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Kaꞌnu ni na koo Ndioxi ra iyoo ndivi! ¡Ra vaꞌa ni na koo na yuuvi yoꞌo, na ^xa ra ña vaꞌa xiꞌin! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ra saa nandiko na tatun Ndioxi kuanuꞌu na ndivi. Ra ndikaꞌan ndia paxto kan xiꞌin taꞌan ndia, kachi ndia saa: ―Na kuꞌun yo ñuu Belén kuni yo ña ndikaꞌan ra tatun Ndioxi xiꞌin yo ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Saa ra numi ka vi ndia ndakiꞌin ndia kuaꞌan ndia ñuu Belén. Ra te ndixaa ndia, ra ikan nduꞌu ña María, xiꞌin ra José, ra kanduꞌu ra loꞌo seꞌe ña nuu ñuꞌu iku xaxi kiti xini ndia. ");
INSERT INTO mxv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ra saa xaꞌa ndia paxto kan ndakani ndiꞌi ndia ña ndikaꞌan ra tatun Ndioxi xiꞌin ndia xaꞌa ra loꞌo kan. ");
INSERT INTO mxv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ra takundiꞌi yuvi na xini soꞌo ña ndatuꞌun ndia paxto xaꞌa ra loꞌo kan, ra ndakanda ka vi ini na. ");
INSERT INTO mxv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndi su ña María, ra chuvaꞌa ndiꞌi va ña tuꞌun kan nima ña. Ra ndakani ka vi ini ña xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ra saa nandiko ndia paxto kan kuanuꞌu va ndia. Ra kusii ka vi ini ndia xaꞌa ña xini soꞌo ndia xiꞌin ña xini ndia ra ^ndasakaꞌnu ka vi ndia Ndioxi kuaꞌan ndia. Chi iin ta iyoo ña ndikaꞌan ra tatun Ndioxi xiꞌin ndia, ra iin saa ke iyoo ña xini va ndia. ");
INSERT INTO mxv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ra te ndixinu una kii ña kaku ra loꞌo seꞌe ña María, ra saa xakin na tuni Ndioxi ra, ra chinduꞌu na kivi ra nani ra Jesús ta kuꞌva ndikaꞌan ra tatun Ndioxi xiꞌin ña María te kuni ka kee seꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ra te ndixinu kii ña xa yii ña María ra saa ndasavii ña xiꞌin mii ña, ta kuꞌva iyoo ña tiaa ra Moisés, ña ndikaꞌan Ndioxi xiꞌin ra xinaꞌa, ra saa ndakiꞌin ña kuaꞌan ña xiꞌin ra José ña ndataxi na ra loꞌo Jesús ndaꞌa Ndioxi veꞌe ñuꞌu kaꞌnu ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chi saa kachi tuꞌun Ndioxi ña tiaa ra Moisés xinaꞌa: “Takundiꞌi seꞌe tiaa na, ra nuu, ra xiniñuꞌu ndataxi na ra ndaꞌa Ndioxi”. ");
INSERT INTO mxv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ra takundiꞌi na ivasiꞌi na vali ra xiniñuꞌu soko na uvi ndiyuu a uvi satà vali nuu Ndioxi, kachi ña tiaa ra Moisés. Ña kan ke ndakiꞌin ra José, xiꞌin ña María kuaꞌan na sanduvi na ña ndikaꞌan Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ra tiempo kan ndixiyo iin ra xinani Simeón ñuu Jerusalén. Ra vaꞌa ni tiaa xikuu ra, ra kañuꞌu ka vi ra Ndioxi. Ra ndixiyo Tachi Yii Ndioxi xiꞌin ra, ra xindiatu ra ra tiꞌvi Ndioxi xaa sakaku na ñuu Israel. ");
INSERT INTO mxv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chi xa ta yachi vi ke ndikaꞌan Tachi Yii Ndioxi xiꞌin ra, kachi ña saa: “Küvi yachi kun, chi ndia na kuni kun ra ndikaxin Ndioxi sakaku na Israel, saa vi ke kuvi kun”, kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ra mii kii ndixaa ra José, xiꞌin ña María, xiꞌin ra loꞌo Jesús veꞌe ñuꞌu kaꞌnu, ña saxinu na ta kuꞌva kaꞌan ña tiaa ra Moisés, ra ndikaꞌan tu Tachi Yii Ndioxi xiꞌin ra Simeón ña na kuꞌun ra veꞌe ñuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ra te ndixaa ra, ra saa ndakiꞌin ra ra loꞌo Jesús ndakunu ndiaa ra, ra ndasakaꞌnu ra Ndioxi, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Vichin, ra xa ndixinu va ña ndikaꞌan kun xiꞌin yu te yachin, Tata. Ra xa vaꞌa va kuvi yuꞌu, ra xachiñu nuu kun, chi ndïꞌi ka ini yu. ");
INSERT INTO mxv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi xa xini nuu va yu ra ndikaxin kun sakaku na yuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ra ra yoꞌo ku ra tiꞌvi kun xa̱à, ra kuni nuu takundiꞌi va na yuuvi yoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Chi ra yoꞌo kuvi ra kuu ñuꞌu ña ndayeꞌe nuu takundiꞌi yuvi, na täan kundaa ini xaꞌa ichi kun. Ra xaꞌa ra yoꞌo ke chinuu toꞌo ni na tuꞌun xaꞌa na ñuu Israel, kachi ra Simeón. ");
INSERT INTO mxv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ra ndakanda ka vi ini na ivasiꞌi ra loꞌo Jesús xaꞌa tuꞌun ña ndikaꞌan ra Simeón. ");
INSERT INTO mxv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Saa ndikaꞌan ra Simeón xiꞌin na, kachi ra saa: ―Ndioxi na taxi ka ña vaꞌa ndaꞌa ndo; ra na chindiee taꞌan ra xiꞌin ndo ―kachi ra. Ra saa ndikaꞌan ka ra xiꞌin ña María, kachi ra saa: ―Xa mii Ndioxi ndikaxin ra loꞌo seꞌe kun, ña sakaku ra na ñuu Israel. Ra kuaꞌa ni na kaku sa ra, ra kuaꞌa ni tu na ndiꞌi xaꞌa va. Ra ra yoꞌo ku ra kuu iin seña nuu na yuuvi yoꞌo, ra kuaꞌa ni na kuïin kandixa. ");
INSERT INTO mxv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ra kundaa ini ra xaꞌa ña ndakani ini yuvi. Ra kusuchi ni tu ini va kun xaꞌa ra. Chi iin ndiakua ta ndoꞌo na siso ichi nima, saa ndoꞌo kun xaꞌa ra ―kachi ra Simeón xiꞌin ña María. ");
INSERT INTO mxv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ra suvi mii veꞌe ñuꞌu kan ndixiyo iin ñaꞌa ña xinani Ana, ra xa kuaꞌa ni kuiya ndikaa ña, ra ña ndikaꞌan tuꞌun yuꞌu Ndioxi xikuu ña. Ra Fanuel xinani iva ña. Ra xii xikua ña xikuu na veꞌe ra Aser. Ra itia ni ña nditandaꞌa ña, ndi uxa va kuiya xinduꞌu ña xiꞌin yii ña ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ra xa kumi xiko kumi kuiya ke kindoo kuaan ña. Ra nii ndixikütiaꞌa ña veꞌe ñuꞌu kan chi ñuu kaꞌñu va xindikaa ña ndikaꞌan ña xiꞌin Ndioxi, ra ndixiyo suꞌun ña ña ndixïxi ña sava. ");
INSERT INTO mxv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ra saa xaa ña nuu ndee na ivasiꞌi ra loꞌo Jesús xiꞌin ra. Ra ndataxi ña tixaꞌvi ndaꞌa Ndioxi xaꞌa ra loꞌo kan. Ra saa xaꞌa ña kaꞌan ña xaꞌa ra loꞌo Jesús xiꞌin takundiꞌi yuvi na ndiatu xaa ra tiꞌvi Ndioxi sakaku na ñuu Israel. ");
INSERT INTO mxv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta ndiꞌi xanduvi ndiꞌi na ndiayu Ndioxi ña tiaa ra Moisés, ra saa nandiko na ndaxaa na ñuu Nazaret ña ndikun ndiaa chi Galilea. ");
INSERT INTO mxv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ra ikan xaꞌnu ra loꞌo Jesús ra iin takundiꞌi kuiya ke kundiee ka ra, ^xaꞌnu ra, ra ndichi ka vi ra, ra kusii ni tu ini Ndioxi va xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ra iin takundiꞌi kuiya ke xaꞌan na ivasiꞌi ra loꞌo Jesús viko pascua ñuu Jerusalén. Chi xa saa yunaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ra ta ndixinu ra loꞌo yoꞌo uxi uvi kuiya, ra saa ndakiꞌin ra kuaꞌan ra ñuu Jerusalén xiꞌin na ivasiꞌi ra viko pascua. ");
INSERT INTO mxv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ra te ndiꞌi viko pascua, ra saa ndakiꞌin na kuanuꞌu na ñuu Nazaret. Ra ndixïni na ndindoo ra loꞌo Jesús ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chi a ndia ndikaa ra tiañu yuvi va kuaꞌan ra, kaꞌan na. Ra xa iin kii nduvi va ñuꞌu na ichi, saa xaꞌa na nanduku na ra tiañu na taꞌan na, xiꞌin tiañu na xini taꞌan xiꞌin na, ");
INSERT INTO mxv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ra köo ra ndindaniꞌi na. Ra saa nandiko tuku na nanduku na ra ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ra ndia kii uni vi ndaniꞌi na ra loꞌo Jesús veꞌe ñuꞌu kaꞌnu. Nduꞌu ra tiañu ndia sañaꞌa ndiayu Ndioxi ña tiaa ra Moisés, ra xini soꞌo ra ña kaꞌan ndia, ra ndakatuꞌun ra ndia. ");
INSERT INTO mxv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ra ^ndakanda ka vi ini ndia xini soꞌo tuꞌun ña ndakuiin ra yuꞌu ndia, chi ndichi ka vi kaꞌan ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Saa xaa na ivasiꞌi ra, ra ndayuꞌvi ka vi ini na xiꞌin ra. Saa ndikaꞌan siꞌi ra, kachi ña saa: ―¿Nichuun xa kun saa xiꞌin ndi? Iva kun xiꞌin yuꞌu, ra ndanduku ni ndi yoꞌo, chi ndiꞌi ni ini ndi xaꞌa kun ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Saa ndakuiin ra, kachi ra saa: ―¿Nichuun ndanduku ndo yuꞌu? ¿A kundäa ini ndo chiñu Tata yu, ra iyoo ndivi va ke xiniñuꞌu sa yu? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ndi su nii ndikundäa ini vi na ni ke kuni kachi ña ndikaꞌan ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ra saa ndakiꞌin ra kuanuꞌu ra xiꞌin na ivasiꞌi ra ñuu Nazaret. Ra xatoꞌo ka vi ra na, iin kandixa ndiꞌi va ra chiñu ña xaꞌndia na nuu ra. Ra ndakani ka vi ini ña María xaꞌa takundiꞌi ña kuu. ");
INSERT INTO mxv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ra saa ^xaꞌnu ra loꞌo Jesús ña kuchee ra; ra ^kundichi ka vi ra; ra kusii ka vi ini Ndioxi xiꞌin ra, ra saa tu yuvi va. ");
INSERT INTO mxv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ra xa xaꞌun kuiya ke ndikaa ra rey Tiberio, ra chee nuu ndiꞌi ndia gobernador, xaꞌndia ra chiñu nuu iin takundiꞌi ñuu ña ndikun ndiaa ñuu Roma. Ra suvi kuiya kan ke xaꞌndia chiñu tu ra gobernador Poncio Pilato nuu takundiꞌi ñuu ña ndikun ndiaa Judea va; ra xaꞌndia chiñu tu ra gobernador Herodes nuu takundiꞌi ñuu ña ndikun ndiaa chi Galilea va, ra ra Felipe, ñani ra Herodes ku ra ndixiyo gobernador ra xaꞌndia chiñu nuu takundiꞌi ñuu ña ndikun ndiaa chi Iturea, xiꞌin ña ndikun ndiaa chi Traconite; ra ra xinani Lisanias ku ra ndixiyo gobernador ra xaꞌndia chiñu nuu na ndikun ndiaa chi Abilinia. ");
INSERT INTO mxv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ra suvi mii kuiya kan ke xikuu ra Anás xiꞌin ra Caifás, sutu ndia kunaꞌnu nuu takundiꞌi ndia sutu ndia ñuu Israel, ra saa ke ndikaꞌan Ndioxi xiꞌin ra Juan, seꞌe ra Zacarías, iin iku yuu. ");
INSERT INTO mxv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ra ke̱e ra kuaꞌan ra chi nuu ndikaa itia Jordán. Ra xaꞌa ra kaꞌan ndoso ra tuꞌun Ndioxi nuu yuvi na ke̱e iin takundiꞌi ñuu, ña na ndandiko ini na xaꞌa kuachi na, ra ndakuchi na, ra sakaꞌnu ini Ndioxi xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ra yoꞌo ke ndixinu nuu ña tiaa ra Isaías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa xaꞌa ra Juan. Ra suꞌva ke kachi ña tiaa ra: Tiꞌvi Ndioxi iin tiaa, ra kuꞌun ra iku yuu, ra ndiee ni kaꞌan ra, kachi ra saa: “Ndasavii ndo ichi ndo nuu Tata yo Ndioxi. Ndandiko ini ndo xaꞌa kuachi ndo, ra ndakundee vii ndo nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Takundiꞌi ichi nuu iyoo yavi ra ndakutu va ña, Ra takundiꞌi ichi nuu iyoo koꞌndo xiꞌin xiki sukun, ra ndakuꞌnu ña ra ndundaa va ña. Ra ichi ndiakua, ra ndundaku va ña. Ra ichi nuu iyoo ni yuu, ra ndandaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ra kuni takundiꞌi va yuvi ra xaa sakaku na yuuvi yoꞌo”, ^kachi ña tiaa ra Isaías. ");
INSERT INTO mxv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ra kuaꞌa ka vi yuvi ndixaa nuu ra Juan ña kuni na, ña na sakuchi ra na. Ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―¡Na ndivaꞌa kuvi ndoꞌo! ¿A kaku ndo xaꞌa kuachi ndo sa Ndioxi tuvi ndo tu na nandïko ini ndo? ");
INSERT INTO mxv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ña xiniñuꞌu sa ndo ke xiꞌna ka na nandiko ini va ndo xaꞌa kuachi ndo, ra sa ndo ña vaꞌa. Ra saa ke kixi ndo kuchi ndo. Ra tu ndakani ini ndo ña: “Koo kaꞌnu va ini Ndioxi xaꞌa kuachi yo, saa chi seꞌe xikua ra Abraham va kuvi yo”, kaꞌan ndo, ra na kundaa ini ndo, chi köo yaꞌvi ndiaa vi ña nuu Ndioxi. Chi ndia yuu ndee ñaa ra kuvi ndasama Ndioxi ña ra nduu ña yuvi va, ra nduu na seꞌe xikua ra Abraham. ");
INSERT INTO mxv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ra na kundaa ini ndo chi xa iyoo nduvi va Ndioxi xiꞌin yacha ña kaꞌndia ra ndia tioꞌo takundiꞌi itun kuiꞌi ra koko nu chi köo kuiꞌi ña vaꞌa kuun ndaꞌa nu. Ra saa ke sa tu Ndioxi xiꞌin ndoꞌo va tu na nandïko ini ndo xaꞌa kuachi ndo ―kachi ra Juan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ra saa ndindakatuꞌun na ra kachi na saa: ―¿Ra ni ke xiniñuꞌu sa ndi, tu saa? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ra saa ndakuiin ra, kachi ra saa xiꞌin na: ―Na iyoo uvi tikoto nuu, ra na taxi na iin ña ndaꞌa na köo ña nuu; ra na iyoo ña xixi, ra na taxi na ña kuxi na köo ña kuxi ―kachi ra Juan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ra saa ndixaa tu ndia kaya xuꞌun kuaꞌan ndaꞌa gobierno va, ña kuni ndia kuchi ndia, ra ndindakatuꞌun ndia ra, kachi ndia saa: ―Maestro, ¿ndia ña ke xiniñuꞌu sa tu nduꞌu? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Saa ndakuiin ra, kachi ra saa: ―Kïꞌin siki ka ndo xuꞌun ndaꞌa taꞌan ndo; chi xa ta kuꞌva ndikaꞌan gobierno xiꞌin ndo ke na sa va ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ra saa ndixaa tu sava ndia soldado va ra ndindakatuꞌun ndia ra, kachi ndia saa: ―Ra nduꞌu tu, ¿ndia ña ke xiniñuꞌu sa ndi? ―kachi ndia. Ra saa ndakuiin ra, kachi ra saa: ―Xa kuïꞌna ka ndo ñaꞌa yuvi, ra täxi ka ndo kuachi siki xaꞌa na. Ra käꞌan kuachi ka ndo xaꞌa yaꞌvi ndo, chi na kindoo ini ndo ta kuꞌva chaꞌvi na ndoꞌo va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ra takundiꞌi va yuvi ndiatu ña kama ni kixi ra kuu Cristo, ra ña kan ke tiaa ni kuni na kundaa ini xaꞌa ra Juan, saa chi ndakani ini na a ra kan kuvi ra kuu Cristo kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ra saa ndikaꞌan ra Juan xiꞌin na, kachi ra saa: ―Süvi yuꞌu kuvi ra. Ra vaꞌa ni ña ndixa va ke ^sakuchi yu ndoꞌo xiꞌin tiakuii, ndi su vaxi inka ra kaꞌnu ni ka nuu yuꞌu, ra ndia nii chiñu loꞌo ke köo yaꞌvi ndiaa yu sa yu nuu ra. Ra ra kan kuvi ra sakuchi ndoꞌo xiꞌin ñuꞌu xiꞌin ndie̱e̱ Tachi Yii Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ra xa iyoo nduvi va ra xiꞌin ñaꞌa ña ndativi ra trigo ra ndachuvaꞌa ra ña veꞌe nuu koo ña, ra taan ra ña väꞌa nuu xixi ñùꞌù ña tüꞌva ndaꞌva ra koko ña. ");
INSERT INTO mxv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ra kuaꞌa ni ka va kuꞌva sañaꞌa ra Juan yuvi, ña na nandiko ini na ra ndakiꞌin na ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ra saa ndukeꞌe tu ra Juan xiꞌin ra gobernador, Herodes, xaꞌa ña ndakiꞌin ra yasiꞌi ra Felipe, ñani ra, ña nduu ña yasiꞌi va ra, ra saa tu xaꞌa takundiꞌi ña väꞌa xa va ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ra inka tuku va ña väꞌa xa ra Herodes, saa chi chikaa ra ra Juan veꞌe kàà xaꞌa ña ndukueꞌe ra xiꞌin ra xaꞌa kuachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ta yachi ta täan kuꞌun ra Juan veꞌe kàà, ra kuaꞌa ka vi yuvi sakuchi ra, ra sakuchi tu ra Jesús va, ra te ndiꞌi chichi Jesús, ra saa xaꞌa ra kaꞌan ra xiꞌin Ndioxi, ra ndanuña ndivi. ");
INSERT INTO mxv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ra ta kaa iin sata loꞌo, saa kaa Tachi Yii Ndioxi nduxinu ña xika ña xini ra. Ra xini soꞌo na ndee kan ña ndikaꞌan Ndioxi xiꞌin Jesús, kachi ra saa: ―Yoꞌo ku seꞌe mii yu ra kuꞌvi ni ini yu xini yu yoꞌo, ra kusii ni ini yu xiꞌin kun ―kachi Ndioxi xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ta ndixinu Jesús oko uxi kuiya ra saa xaꞌa ra sañaꞌa ra yuvi. Ra seꞌe ra José va kuvi ra ndituvi na. Ra ra José ra seꞌe ra Elí va xikuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ra seꞌe ra Matat xikuu ra Elí. Ra seꞌe ra Leví xikuu ra Matat. Ra seꞌe ra Melqui xikuu ra Leví. Ra seꞌe ra Jana xikuu ra Melqui. Ra seꞌe ra José xikuu ra Jana. ");
INSERT INTO mxv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ra seꞌe ra Matatías xikuu ra José. Ra seꞌe ra Amós xikuu ra Matatías. Ra seꞌe ra Nahum xikuu ra Amós. Ra seꞌe ra Esli xikuu ra Nahum. Ra seꞌe ra Nagai xikuu ra Esli. ");
INSERT INTO mxv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ra seꞌe ra Maat xikuu ra Nagai. Ra seꞌe ra Matatías xikuu ra Maat. Ra seꞌe ra Semei xikuu ra Matatías. Ra seꞌe ra José xikuu ra Semei. Ra seꞌe ra Judá xikuu ra José. ");
INSERT INTO mxv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ra seꞌe ra Joana xikuu ra Judá. Ra seꞌe ra Resa xikuu ra Joana. Ra seꞌe ra Zorobabel xikuu ra Resa. Ra seꞌe ra Salatiel xikuu ra Zorobabel. Ra seꞌe ra Neri xikuu ra Salatiel. ");
INSERT INTO mxv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ra seꞌe ra Melqui xikuu ra Neri. Ra seꞌe ra Adi xikuu ra Melqui. Ra seꞌe ra Cosam xikuu ra Adi. Ra seꞌe ra Elmodan xikuu ra Cosam. Ra seꞌe ra Er xikuu ra Elmodan. ");
INSERT INTO mxv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ra seꞌe ra Josué xikuu ra Er. Ra seꞌe ra Eliezer xikuu ra Josué Ra seꞌe ra Jorim xikuu ra Eliezer. Ra seꞌe ra Matat xikuu ra Jorim. ");
INSERT INTO mxv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ra seꞌe ra Leví xikuu ra Matat. Ra seꞌe ra Simeón xikuu ra Leví. Ra seꞌe ra Judá xikuu ra Simeón. Ra seꞌe ra José xikuu ra Judá. Ra seꞌe ra Jonán xikuu ra José. Ra seꞌe ra Eliaquim xikuu ra Jonán. ");
INSERT INTO mxv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ra seꞌe ra Melea xikuu ra Eliaquim. Ra seꞌe ra Mainán xikuu ra Melea. Ra seꞌe ra Matata xikuu ra Mainán. Ra seꞌe ra Natán xikuu ra Matata. ");
INSERT INTO mxv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ra seꞌe ra David xikuu ra Natán. Ra seꞌe ra Isaí xikuu ra David. Ra seꞌe ra Obed xikuu ra Isaí. Ra seꞌe ra Booz xikuu ra Obed. Ra seꞌe ra Salmón xikuu ra Booz. Ra seꞌe ra Naasón xikuu ra Salmón. ");
INSERT INTO mxv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ra seꞌe ra Aminadab xikuu ra Naasón. Ra seꞌe ra Aram xikuu ra Aminadab. Ra seꞌe Esrom xikuu ra Aram. Ra seꞌe ra Fares xikuu ra Esrom. Ra seꞌe ra Judá xikuu ra Fares. ");
INSERT INTO mxv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ra seꞌe ra Jacob xikuu ra Judá. Ra seꞌe ra Isaac xikuu ra Jacob. Ra seꞌe ra Abraham xikuu ra Isaac. Ra seꞌe ra Taré xikuu ra Abraham. Ra seꞌe ra Nacor xikuu ra Taré. ");
INSERT INTO mxv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ra seꞌe ra Serug xikuu ra Nacor. Ra seꞌe ra Ragau xikuu ra Serug. Ra seꞌe ra Peleg xikuu ra Ragau. Ra seꞌe ra Heber xikuu ra Peleg. Ra seꞌe ra Sala xikuu ra Heber. Ra seꞌe ra Cainán xikuu ra Sala. ");
INSERT INTO mxv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ra seꞌe ra Arfaxad xikuu ra Cainán. Ra seꞌe ra Sem xikuu ra Arfaxad. Ra seꞌe ra Noé xikuu ra Sem. Ra seꞌe ra Lamec xikuu ra Noé. ");
INSERT INTO mxv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ra seꞌe ra Matusalén xikuu ra Lamec. Ra seꞌe ra Enoc xikuu ra Matusalén. Ra seꞌe ra Jared xikuu ra Enoc. Ra seꞌe ra Mahalaleel xikuu ra Jared. Ra seꞌe ra Cainán xikuu ra Mahalaleel. ");
INSERT INTO mxv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ra seꞌe ra Enós xikuu ra Cainán. Ra seꞌe ra Set xikuu ra Enós. Ra seꞌe ra Adán xikuu ra Set. Ra seꞌe Ndioxi xikuu ra Adán. ");
INSERT INTO mxv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ra iyoo ni ndie̱e̱ Tachi Yii Ndioxi xiꞌin Jesús, ra saa ke̱e ra nuu ndikaa itia Jordán, ra ndakiꞌin Tachi Yii Ndioxi ra kuaꞌan ra iin iku yuu. ");
INSERT INTO mxv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ra uvi xiko kii ndixiyo ra kan. Ra ndixïxi ra, chi saa ndixiyo va ra soko; ra ta ndixinu uvi xiko kii, ra saa xaꞌa ndikaꞌun ini ra. Ra saa ixtondoso timiaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ra ndikaꞌan ri xiꞌin ra kachi ri saa: ―Tu ndixa Seꞌe Ndioxi kuvi kun, ra kaꞌan xiꞌin yuu yoꞌo ra na nduu ña ixta kuxi kun ―kachi ri xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ri: ―Suꞌva va kachi tuꞌun Ndioxi: “Süvi xiꞌin indaa ixta ke xiniñuꞌu kutiaku yuvi chi xiniñuꞌu tu kandixa na takundiꞌi tuꞌun Ndioxi va ra saa ke kutiaku na” ―kachi ña, kachi ra xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ra saa ndakiꞌin timiaꞌa kan Jesús ndixaa ra xiꞌin ri iin xiki ña sukun vaꞌa, ra ikan ndiñaꞌa ri iin takundiꞌi ñuu ña iyoo nuu ña yuuvi yoꞌo nuu ra iin too loꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ra ndikaꞌan ri xiꞌin ra, kachi ri saa: ―Ndaꞌa yoꞌo taxi yu takundiꞌi ñuu yoꞌo, ra kaꞌndia kun chiñu nuu ña, ra xiꞌin yoꞌo koo takundiꞌi ña kuika ña kuu mii ñuu yoꞌo. Chi kuenda yuꞌu va ke, ra ndia ndia ka mii na kuni yu taxi yu ña ndaꞌa, ra taxi va yu ña. ");
INSERT INTO mxv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ra tu na ndakusiti kun nuu yu, ra ndasakaꞌnu kun yuꞌu, ra kuenda mii kun kuu takundiꞌi va ña ―*kachi ri xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ri: ―¡Kuatiaꞌa nuu yu, Timiaꞌa! Saa chi suꞌva va kachi tuꞌun Ndioxi: “Indaa mituꞌun va Tata yu Ndioxi ndasakaꞌnu yu, ra indaa ra kan va xiniñuꞌu kandixa yu” ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ra saa ndakiꞌin timiaꞌa kan Jesús ndixaa ra xiꞌin ri ñuu Jerusalén. Ra ikan sandaa ri ra xini veꞌe ñuꞌu kaꞌnu, ndia nuu sukun vaꞌa. Ra ndikaꞌan ri xiꞌin ra, kachi ri saa: ―Tu ndixa Seꞌe Ndioxi kuvi kun, ra sandakava mii kun yoꞌo vichin. ");
INSERT INTO mxv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Saa chi kaꞌan tuꞌun Ndioxi: Ña tiꞌvi va ra na tatun ra kixi na kondiaa na yoꞌo ra chindiee taꞌan na xiꞌin kun. ");
INSERT INTO mxv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ra nuu ndaꞌa va na ndakava kun. Ra täxi na takueꞌe kun sa yuu ―kachi ri xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ra saa ndakuiin Jesús kachi ra saa xiꞌin timiaꞌa kan: ―Suꞌva va kachi tuꞌun Ndioxi: “Küvi kotondoso yu Tata yu Ndioxi”, kachi ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ndia saa ra ninïꞌi ka timiaꞌa ni ke sa ri ña kotondoso ka ri Jesús. Ra saa ndixikutiaꞌa ri nuu ra iin ndiaꞌvi kii. ");
INSERT INTO mxv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ra saa nandiko Jesús kuaꞌan ra chi Galilea, ra iyoo ni ndiee Tachi Yii Ndioxi xiꞌin ra, ra saa ndindutia ndoso tuꞌun xaꞌa ra iin takundiꞌi ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ra xaꞌa ra sañaꞌa ra tuꞌun Ndioxi yuvi iin takundiꞌi veꞌe ñuꞌu ña iyoo ñuu ña ndikun ndiaa chi Galilea. Ra ndiee ni ^ndasakaꞌnu na ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ra saa ndixaa Jesús ñuu Nazaret nuu xaꞌnu ra. Ra kii ndakindiee̱ na ndixaꞌan ra veꞌe ñuꞌu kan, chi saa yunaꞌa va ra. Ra ndakundichi ra ña kaꞌvi ra tuꞌun Ndioxi nuu yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ra saa taxi na tutu ña tiaa ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ndaꞌa ra. Ra ndakuiña ra nuu kachi ña suꞌva, ra kaꞌvi ra ña: ");
INSERT INTO mxv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ndie̱e̱ Tachi Yii Ndioxi iyoo xiꞌin yu. Saa chi ra kan va kuvi ra ndikaxin yuꞌu ña ndatuꞌun yu tuꞌun vaꞌa xiꞌin na ndaꞌvi, ra tiꞌvi ra yuꞌu vaxi yu ña chindiee taꞌan yu xiꞌin na ndoꞌo ni ini, ra sakaku yu na ñuꞌu veꞌe kàà ra saña ndika na, ra ndakuiña tu yu nuu na kuaa va, ra sakaku tu yu na ndoꞌo tundoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ra xaa yu ña kaꞌan ndoso yu nuu takundiꞌi yuvi, ña vaꞌa na niꞌi na ña vaꞌa ña taxi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ra te ndiꞌi kaꞌvi Jesús tutu kan, ra saa ndatuvi ra ña, ra ndataxi ra ña ndaꞌa tiaa ra ndiso chiñu xiꞌin veꞌe ñuꞌu, ra saa ndakunduꞌu va ra. Ra saa iin ixtoꞌni takundiꞌi na ndee veꞌe ñuꞌu kan nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ra saa xaꞌa ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Vichin ke ^xini ndo ña ndixinu nuu tuꞌun Ndioxi ña kaꞌvi yu yoꞌo ―*kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ra ndiee ni ndachinuu toꞌo na tuꞌun xaꞌa Jesús. Ra ndakanda ka vi ini na, saa chi nduvi ni ndikaꞌan ra xiꞌin na. Ra saa xaꞌa na kachi na saa: ―¿A su seꞌe ra José va kuvi ra yoꞌo? ―kachi na xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Xa kundaa va ini yu chi vaxi kii ra kaꞌan ndo iin tuꞌun ndichi xiꞌin yu, kachi ndo saa: “Yoꞌo, ra xa tatan inka yuvi, na sa tatan kun mii kun vichin”, kachi ndo. Ra kaꞌan ka ndo: “A su yoꞌo kuvi ra kuaꞌa ni ña vaꞌa xa ñuu Capernaum; ra saa na sa tu kun yoꞌo va, chi yoꞌo kuvi ñuu kun”, kachi ndo xiꞌin yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ra saa ndikaꞌan ka Jesús tuꞌun yoꞌo xiꞌin na kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, chi ndia nii na kaꞌan tuꞌun yuꞌu Ndioxi ra mäni na nuu na ñuu na. ");
INSERT INTO mxv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi saa ndoꞌo na te xinaꞌa ta ndixika ra Elías, ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi: ta ndasi Ndioxi ndivi ra ndiküun ka savi uni kuiya sava. Ra ndiee ni xindikaa tama ra ndikaꞌun ni ini yuvi, ra kuaꞌa ni na siꞌi na ndukuaan xindee ñuu Israel, ra ndoꞌo ni ini na. ");
INSERT INTO mxv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ndi su ndia nii na siꞌi kan ndixäꞌan ra Elías chindiee taꞌan ra xiꞌin, chi inka ñuu ña nani Sarepta, ña ndikun ndiaa ñuu kaꞌnu Sidón va, tiꞌvi Ndioxi ra ndixaꞌan ra, ra ikan chindiee taꞌan ra xiꞌin iin ña ndaꞌvi ña ndukuaan ndixiyo ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ra saa ndoꞌo tu na te ndixika ra Eliseo, ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa va, ra kuaꞌa ni na ndoꞌo kue̱ꞌe̱ tiaꞌyu ñuu Israel. Ndi su ndia nii na kan ndikäꞌan Ndioxi xaꞌa nduvaꞌa, chi iin tiaa ra nani Naamán, ra ke̱e inka ñuu xika ña nani Siria va, kuvi ra sandaꞌa Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ra te xini soꞌo na ndee ini veꞌe ñuꞌu kan, ña ndikaꞌan Jesús ña yoꞌo, saa ra ndisaa ni na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ra saa ndakundita na tiin na Jesús ra tava na ra ndia nuu ñuu na, ra ndixaa na xiꞌin ra siki kava sukun nuu kaku kaꞌa ñuu na, ra ikan kuni na sandakava na ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ndi su ndikuchüun na xiꞌin Jesús, ra kuee kuee ndiyaꞌa ra maꞌñu na, ra ndakiꞌin ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ra saa ndakiꞌin Jesús kuaꞌan ra ñuu Capernaum ña ndikaa chi Galilea. Ra saa xaꞌa ra sañaꞌa ra yuvi na ndee veꞌe ñuꞌu kan kii yii ña ndakindiee na. ");
INSERT INTO mxv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ra ^ndakanda ka vi ini na ña xini soꞌo na tuꞌun ña kaꞌan ra. Chi kaꞌan ra xiꞌin iin takundiꞌi ndiayu ña kuu mii ra, ra kuëe ndixa ra ta kuꞌva xa iin na xïni tuꞌun kaꞌan. ");
INSERT INTO mxv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ra ini veꞌe ñuꞌu kan nduꞌu iin tiaa ra kuu mii tachi ndivaꞌa, ra saa ndiee ka vi ndindaꞌyu tachi ndivaꞌa ña ndikaa ini ra, ");
INSERT INTO mxv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","kachi ña saa xiꞌin Jesús: ―Koo yaa kun xiꞌin ndi. ¿Nichuun sandiꞌi kun nduꞌu, Jesús, ra ñuu Nazaret? ¿A vaxi kun sandiꞌi kun xaꞌa ndi? Chi yuꞌu ra xini va yu yoꞌo, ña kuu kun Ra Yii, ra ke̱e nuu Ndioxi ―kachi ña ndivaꞌa kan suꞌva xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Saa ndukueꞌe Jesús xiꞌin tachi ndivaꞌa kan, ra kachi ra saa: ―¡Koo yaa yuꞌu kun! Ra saña tiaa ñaa ―kachi ra. Ra saa kùùn ña ndivaꞌa kan tiaa kan ndia nuu ñuꞌu, ra ke̱e ña kuaꞌan ña, ndi su kuëe nindoꞌo vaꞌa vi ra. ");
INSERT INTO mxv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ra ndakanda ni ini yuvi na ndee kan, ra xaꞌa na kaꞌan na xiꞌin taꞌan na kachi na saa: ―¿Ndia tuꞌun ke yoꞌo? Chi xiꞌin ndiayu ra, ra xiꞌin ndie̱e̱ ra xaꞌndia ra chiñu nuu tachi ndivaꞌa ra kandixa ña ra, ra kee ña kuaꞌan va ña ―*kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ra saa nindutia ndoso tuꞌun xaꞌa Jesús iinii kuvi ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ra te kita Jesús veꞌe ñuꞌu kan, ra saa ndakiꞌin ra kuaꞌan ra veꞌe ra Simón ra itaꞌan xiꞌin ra. Ra saa ndiee ni ndoꞌo ña siso ra Simón kanduꞌu ña xiꞌin kueꞌe kaꞌni, ra saa xakundaꞌvi ka vi na nuu Jesús ña na sandaꞌa ra ña. ");
INSERT INTO mxv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ra saa kuyachin Jesús nuu ña, ra xaꞌndia ra chiñu nuu kueꞌe kan, ña na kee ña; saa ra ndikun nduvaꞌa va ña; ra ndakoo ña xavii ña xixi va na. ");
INSERT INTO mxv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ra ta kuaa ndikita ñuꞌu, ra kuaꞌa ni yuvi ra ndiaka na na xiꞌi, iin ta nuu kueꞌe, ndixaa na nuu Jesús; ra saa chinduꞌu ra ndaꞌa ra sata ta iin, ta iin na, ña sandaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ra kuaꞌa ni tu na kuu mii tachi ndivaꞌa, va nduvaꞌa xa Jesús, ra iin ndaꞌyu koꞌo ña ndivaꞌa kan ta kee ña, ra kachi ña saa: ―¡Yoꞌo, kuvi Seꞌe Ndioxi! ―kachi ña xiꞌin ra. Ra nditäxi ra kaꞌan ña xiꞌin ra, saa chi xa kundaa va ini ña, ña kuu ra Cristo. ");
INSERT INTO mxv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta ndituvi, ra saa ndakiꞌin Jesús kuaꞌan ra iin iku yuu nuu köo yuvi. Ra ndikun yuvi sata ra kuaꞌan na ndanduku na ra. Ra ta ndaniꞌi na ra ra nditäxi na kuꞌun ra inka xiyo. ");
INSERT INTO mxv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ra saa ndikaꞌan Jesús xiꞌin na, kachi ra saa: ―Xiniñuꞌu kuꞌun yu inka ñuu ña ndatuꞌun yu xiꞌin yuvi ña na kuiin na kaꞌndia Ndioxi chiñu nuu na, ra sa ra ña vaꞌa xiꞌin na chi xaꞌa ña yoꞌo ke tiꞌvi Ndioxi yuꞌu vaxi va yu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ra saa ndixika Jesús ndikaꞌan ndoso ra tuꞌun Ndioxi takundiꞌi veꞌe ñuꞌu ña iyoo chi Galilea. ");
INSERT INTO mxv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Saa kuu iin kii ndichi Jesús yuꞌu mini kaꞌnu ra nani Genesaret, ra kuaꞌa ka vi yuvi ndakutaꞌan, ra ndixaa na nuu ra, ra iin chindaꞌni taꞌan na ña kuni na kuni soꞌo na tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ra suvi yachin yuꞌu mini kan tu xini Jesús ndita vichi uvi itun vali xika nuu mini. Ra köo ka ixtoꞌo nu ñuꞌu ini nu, chi xa nuu va ndia ña ndakatia ndia inu ndia ña ^tiin ndia tiaka. ");
INSERT INTO mxv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ra saa ndaa Jesús ini iin nu; ra kuenda ra Simón va kuvi nu. Ra nduku Jesús ña mani nuu ra, ña na sakundutiaꞌa ra loꞌo nu chi nuu xa kunu ka loꞌo mini kan. Ra saa sakundutiaꞌa ra nu, ra ndakunduꞌu Jesús ini nu ra xaꞌa ra sañaꞌa ra yuvi. ");
INSERT INTO mxv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ra te ndiꞌi sañaꞌa ra na, ra saa ndikaꞌan ra xiꞌin ra Simón, kachi ra saa: ―Na koꞌo xiꞌin nu chi nuu kunu ra kaa, ra chikaa ndo inu ndo ña tiin ndo tiaka ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saa ndakuiin ra Simón, kachi ra saa: ―Tata Maestro, xa iinii ñuu ndaa ndixika ndi xaꞌa ri, ra ndia nii ri nditïin vi ndi. Ndi su tu xa mii kun kachi saa, ra vaꞌa, na chikaa tuku va ndi ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ra saa chikaa tuku va ndia inu ndia. Ra kuaꞌa ka vi ri tiin ndia ra xaꞌa ndia ixita ndia inu, ra saa xaꞌa ndindata va ña xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ra saa ndixika ndaꞌa ndia nuu ndia taꞌan ndia, ndia ndoꞌni ini inka nu, ña na kixi ndia chindiee taꞌan ndia xiꞌin ndia. Ra saa xaa ndia kan chindiee taꞌan ndia xiꞌin ndia. Ra iin chitu ndaa va uvi saa nu xiꞌin tiaka, ra saloꞌo koyo nu xiꞌin ndia kaꞌa mini kan. ");
INSERT INTO mxv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ra ta xini ra Simón ña xa Jesús, saa ra ndikun ndakusiti ra nuu ra, ra kachi ra saa: ―Tata, tiaa ra iyoo kuachi va kuvi yuꞌu, ndi su yoꞌo, ra ra yii va kuvi kun. Ña kan ke küvi kitaꞌan yu xiꞌin kun, ra vaꞌa ka na kutiaꞌa va kun nuu yu ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saa chi ndakanda ni ini ra Simón xaꞌa ña kuaꞌa ni tiaka tiin ndia. Ra ndakanda ni tu ini ndia itaꞌan xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ra ndakanda ni tu ini ra Jacobo, xiꞌin ra Juan ndia seꞌe ra Zebedeo, ndia itaꞌan xiꞌin ra Simón va. Ra saa ndikaꞌan Jesús xiꞌin ra Simón, kachi ra saa: ―Kuayüꞌvi kun; chi vichin nduu kun ra sañaꞌa yuvi ña ndakundikun na yuꞌu ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ra saa ke̱e ndia chi yuꞌu mini kan xiꞌin barca ndia. Ra ndakoo ndiꞌi ndia chiñu ndia. Ra ndakundikun ndia Jesús, kuaꞌan ndia xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saa kuu iin kii ra xika Jesús iin ñuu, ra ndixaa iin tiaa ra ndoꞌo kue̱ꞌe̱ tiaꞌyu nuu ra. Ra ndakusiti ra, ra ndixinu nuu ra ndia ñuꞌu, ra xakundaꞌvi ka vi ra nuu ra, kachi ra saa: ―Tata, tu kuni kun, ra na sa kun ña mani ra na sandaꞌa va kun yuꞌu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ra saa nditandiaa ndaꞌa Jesús ra ndoꞌo kueꞌe tiaꞌyu kan ra ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Kuni va yu; ra na nduvaꞌa kun ―kachi ra xiꞌin ra. Ra ndikun saa ndindoñuꞌu va kue̱ꞌe̱ tiaꞌyu kan sata tiaa kan. ");
INSERT INTO mxv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ra saa xaꞌndia Jesús chiñu nuu ra kachi ra saa: ―Kuaꞌan, ra ndia nii yuvi ndatüꞌun kun xiꞌin xaꞌa ña sandaꞌa yu yoꞌo. Chi takua nuu ra sutu va na kuꞌun kun, ra na kaniꞌi kun ñaꞌa ña soko kun ta kuꞌva kachi ndiayu Ndioxi ña ndakoo ra Moisés ta yachi; ra na kundaa ini ndia sutu ña xa nduvaꞌa va kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ra vaꞌa ni ndikaꞌan ni va Jesús xiꞌin ra ña na ndatüꞌun ra, ndi su xa saa kundaa va ini yuvi xaꞌa ña nduvaꞌa ra. Ra iin vichin vichin ndindutia ndoso tuꞌun xaꞌa Jesús, ra kuaꞌa ka vi yuvi kuaꞌan nuu ra ña kuni soꞌo na ña ndakani ra, ra sandaꞌa ra na xiꞌin kueꞌe ña ndoꞌo na. ");
INSERT INTO mxv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ra kuaꞌa ni ichi ke̱e siin ra nuu na, ña ndixaꞌan ra iku yuu nuu köo yuvi ña ndikaꞌan ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Saa kuu iin kii ra íin Jesús sañaꞌa ra yuvi. Ra ikan ndee sava ndia fariseo, xiꞌin ndia sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés. Ra saa tu na ke̱e ñuu ña ndikun ndiaa chi Galilea, ra saa tu na ke̱e ñuu ña ndikun ndiaa chi Judea va. Ra saa tu na ke̱e ñuu Jerusalén va. Ra mii Ndioxi taxi ndie̱e̱ ndaꞌa Jesús ña ^sandaꞌa ra yuvi na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ra saa kuu, ra ndixaa sava tiaa xiꞌin iin ra xiꞌi ra ndachi xaꞌa küvi kaka, ra kanduꞌu ra nuu ixto ndixaa ra xiꞌin ndia. Ra ndixika nduku ndia kiꞌvi ndia ña chikanduꞌu ndia ra ini veꞌe nuu nduꞌu Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ndi su ndiküvi vi kiꞌvi ndia xiꞌin ra, chi iin chitu ndaa va yuvi. Ra saa ndaa ndia chi xini veꞌe, ra kaan ndia iin yavi xini ña. Ra yavi kan sanuu ndia ixto nuu kanduꞌu ra. Ra saa nduxinu ra tiañu takundiꞌi yuvi, nuu nduꞌu Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ra te kundaa ini Jesús ña ndinuni ni ini ndia ^kandixa ndia, ña kuchuun va ra sandaꞌa ra ra. Ra saa ndikaꞌan ra xiꞌin ra xiꞌi kan, kachi ra saa: ―Tata, xa xa kaꞌnu va ini yu xaꞌa kuachi kun ―*kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ra ta xini soꞌo ndia fariseo, xiꞌin ndia sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ña ndikaꞌan Jesús xiꞌin ra, ra saa xaꞌa ndia ndakani ini ndia: “¿Yoo ku ra yoꞌo, ra kachi ra saa xiꞌin ra kaa? Chee ni kuachi ke yoꞌo nuu Ndioxi, chi ndia nii yuvi, ra küvi sakaꞌnu ini na xaꞌa kuachi yo, chi indaa mituꞌun Ndioxi va ku ra kuvi sakaꞌnu ini xaꞌa kuachi yo”, kaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ra kundaa kuaꞌa va ini Jesús ña ^ndakani ini ndia, ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¿Nichuun ndakani ini ndo ña köo ndiayu yu ña sakaꞌnu ini yu xaꞌa kuachi yuvi? ");
INSERT INTO mxv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ra ni ke vaꞌa kachi yu xiꞌin ra yoꞌo, tuvi ndo? ¿A vaꞌa ka na kachi yu ña: “Xa xakaꞌnu ini yu xaꞌa kuachi kun”? ¿Ra a vaꞌa ka na kaꞌan yu xiꞌin ra: “Ndakoo, ra kaka xaꞌa kun kunuꞌu kun”?, kachi yu. ");
INSERT INTO mxv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ra ña na kundaa vaꞌa ini ndo, ra vichin nuu ndo yoꞌo, na sandaꞌa yu ra yoꞌo, saa ke kundaa ini ndo chi yuꞌu kuvi ra tiꞌvi Ndioxi xaa, ra kuu mii yu ndiayu ña sakaꞌnu ini yu xaꞌa kuachi na yuuvi ―kachi ra xiꞌin ndia. Ra saa ndikaꞌan ra xiꞌin ra nduchiꞌña kan, kachi ra saa: ―Ndakoò, ra ndakiꞌin kun ixto kun, ra kunuꞌu kun veꞌe kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ra ndikun nuu na saa ndakoò tiaa kan, ra ndakiꞌin ra ixto ra, ra kuanuꞌu ra veꞌe va ra. Ra ^ndasakaꞌnu ka vi ra Ndioxi xaꞌa ña nduvaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ra ndakanda ka vi ini yuvi xaꞌa ña xa Jesús. Ra ndasakaꞌnu ni na Ndioxi. Ra ndayuꞌvi ka vi ini na, kachi na saa: ―¿Ni ke yoꞌo? Ndia nii kii täan kuni yo ña, ra ndia vichin xini yo ña xituꞌun yoꞌo ―kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ra ta sandiꞌi Jesús, saa ra ndakiꞌin ra kuaꞌan va ra, ra ndiyaꞌa ra nuu nduꞌu iin ra nani Leví ra ndiso chiñu kaya xuꞌun ndaꞌa na ñuu, ña kuaꞌan ndaꞌa gobierno ñuu Roma. Ra ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Na koꞌo xiꞌin yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Saa ra, ndikun ndakoo ndiꞌi ra Leví chiñu ra, ra ndakiꞌin ra kuaꞌan ra xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Saa kuu, xakin ra Leví iin viko kaꞌnu veꞌe ra ña ndasatoꞌo ra Jesús. Ra kuaꞌa ka vi na kaya xuꞌun ndaꞌa na ñuu, xiꞌin sava ka yuvi xaa ndixkundee nuu mesa ña kuxi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ra ndia fariseo, xiꞌin ndia sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ra xaꞌa ndia xa kuachi ndia ra ndikaꞌan ndia xiꞌin ndia itaꞌan xiꞌin Jesús, kachi ndia saa: ―¿Nichuun xixi ndo xiꞌin ndia kaya xuꞌun ndaꞌa yuvi, xiꞌin sava ka yuvi kuachi? Ra süvi na vaꞌa kuvi na ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Na iyoo vaꞌa ini, ra xiniñüꞌu vi na kan na xatatan, chi na ndiee ndoꞌo va ku na xiniñuꞌu na xatatan. ");
INSERT INTO mxv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Saa chi yuꞌu, ra växi yu chindiee taꞌan yu xiꞌin na vaꞌa, na köo kuachi, tuvi na. Chi xaꞌa na iyoo kuachi va ke xaa yu, ña vaꞌa na ndandiko ini na ra ndakiꞌin na ichi Ndioxi ―kachi Jesús xiꞌin ndia fariseo. ");
INSERT INTO mxv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ra saa ndikaꞌan ndia xiꞌin Jesús, kachi ndia saa: ―Na itaꞌan xiꞌin ra Juan, xiꞌin na itaꞌan xiꞌin ndia fariseo, ra kuaꞌa ni va ichi xïxi na, ña iyoo suꞌun na, ra kaꞌan ni tu na xiꞌin Ndioxi va. ¿Ra nichuun iyöo suꞌun tu ndia itaꞌan xiꞌin yoꞌo? Chi niña ndia xixi va kuvi ndia ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ra saa ndakuiin Jesús, kachi ra saa: ―Na ndee kusii ini xiꞌin migo na nuu iyoo viko tandaꞌa, ra küvi vi koo suꞌun na, ña koo na saa soko, chi ta íin va ra tandaꞌa xiꞌin na, ña kan ke küvi koo suꞌun na. ");
INSERT INTO mxv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ndi su vaxi kii, ra tiin ndia ra tandaꞌa kuꞌun ra xiꞌin ndia, ra saa vi ke ndoo na itaꞌan xiꞌin ra ña koo suꞌun na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ra saa ndikaꞌan ka ra iin tuꞌun ndichi xiꞌin ndia, kachi ra saa: ―Ndia nii yuvi ra ndakäꞌma na iin ñaꞌñu tikoto xaa xiꞌin tikoto yata. Saa chi tu saa na sa na, saa ra ndiꞌi xaꞌa va tikoto xaa. Ra nii kindöo vaꞌa tu ña xiꞌin tikoto yata va. ");
INSERT INTO mxv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ra ndia nii yuvi ra täan na vino xaa ini ñii̱ yata, chi tu saa na sa na, saa ra, ndata va ñii̱ yata kan sa ra, ra ña uun va kuitia ndiꞌi ra, ra ndia ñii̱ kan ke ndiꞌi xaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ña kan ke vino ra xaa, ra ini ñii̱ xaa ke xiniñuꞌu kuꞌun va ra, ra saa ke nii vino kütia, ra nii ñii̱ ña ñuꞌu ra ke ndïꞌi xaꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ra na xiꞌi vino yata, ra küni na koꞌo na vino ra xaa, chi vaꞌa ni ka va xiꞌi vino yata kachi na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Saa kuu iin kii ña ndakindiee̱ na, ra ndiyaꞌa Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, nuu iyoo itu trigo. Ra xaꞌa ndia itaꞌan xiꞌin Jesús kindiaa ndia yoko itu trigo kan. Ra sakoyo ndia nuni sata ña ^xaxi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ra saa ndikaꞌan ndia fariseo xiꞌin ndia, kachi ndia saa: ―¿Nichuun xa ndo saa?, saa chi köo ndiayu ndaꞌa yo, ña sa yo saa kii yii saa chi kii ña ñakindiee̱ va yo kuvi ña ―kachi ndia xiꞌin ndia itaꞌan xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ra saa ndakuiin Jesús, kachi ra saa: ―¿A täan kaꞌvi ndo ni ke kaꞌan tuꞌun Ndioxi xaꞌa ña xa ra rey David, xiꞌin ndia xitaꞌan xiꞌin ra, ta ndikaꞌun ini ndia? ");
INSERT INTO mxv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Saa chi su ndikiꞌvi va ra Rey David ini veꞌe ñuꞌu, ra kiꞌin ra ixta ña ndee nu yii ña soko na nuu Ndioxi, xixi ra xiꞌin ndia itaꞌan xiꞌin ra. Ra köo ndiayu ra sa ra saa, chi indaa ndia ku sutu va kuvi ndia iyoo ichi kuxi ixta kan ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Yuꞌu, ra tiꞌvi Ndioxi xaa yoꞌo kuvi ra iyoo ndiayu ndaꞌa xaꞌa kii ña ndakindiee̱ na ndia ña ke vaꞌa sa yo, ra ndia ña ke küvi sa va yo ―kachi Jesús xiꞌin ndia fariseo. ");
INSERT INTO mxv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ra saa kuu, inka tuku kii ña ndakindiee̱ na ra saa ndixaa Jesús iin veꞌe ñuꞌu ra xaꞌa ra sañaꞌa ra na tuꞌun Ndioxi. Ra veꞌe ñuꞌu kan nduꞌu iin tiaa ra kutuun ndaꞌa kuaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ra ndia sañaꞌa ndiayu Ndioxi xiꞌin ndia fariseo ra iin suꞌva nuu ndia ixtonani ndia Jesús, a sandaꞌa ra ra kue̱ꞌe ndaꞌa kan kii ña ndakindiee̱ na, ra saa ke niꞌi ndia taxi ndia kuachi xaꞌa Jesús, káꞌán ndia. ");
INSERT INTO mxv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ra xa kundaa va ini Jesús ña ndakani ini ndia. Ra saa ndikaꞌan ra xiꞌin ra kue̱ꞌe ndaꞌa kan, kachi ra saa: ―Ndakundichi ra na kuni takundiꞌi na yoꞌo ―kachi ra xiꞌin ra. Saa ra ndikun ndakundichi va ra kue̱ꞌe ndaꞌa kan maꞌñu na. ");
INSERT INTO mxv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ra saa ndikaꞌan Jesús xiꞌin ndia fariseo, kachi ra saa: ―Na ndakatuꞌun yu ndoꞌo. ¿Ndia ña ke kuvi sa yo kii ña ndakindiee̱ kachi ña tiaa ra Moisés? ¿A ña vaꞌa ke sa yo, a ña väꞌa? ¿A sakaku yo yuvi, a sandiꞌi yo xaꞌa va na? ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Saa ixtoꞌni Jesús nuu takundiꞌi na xinunduu ndita kan, ra ndikaꞌan ra xiꞌin ra kue̱ꞌe ndaꞌa kan kachi ra saa: ―Sandakaa ndaꞌa kun ―kachi ra xiꞌin ra. Ra saa sandakaa tiaa kan ndaꞌa ra, ra ndikun nduvaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ra tiaa ni ndisaa ini ndia fariseo xini ndia Jesús. Ra xaꞌa ndia kataꞌan ndia ndixa koo taxi ndia kuachi xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Saa kuu iin kii ke̱e Jesús kuaꞌan ra iku kaꞌan ra xiꞌin Ndioxi, ra iinii ñuu ndaa ndikaꞌan ra xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ra te ndituvi saa kana ra takundiꞌi na ndikun sata ra, ra ndikaxin ra uxi uvi tiaa, ndia kaka chiñu nuu ra. Ra ndia yoꞌo kuvi ndia kuu apóstoles, ra tuꞌun yoꞌo kachi ña saa: “Ndia ^tiꞌvi Ndioxi.” ");
INSERT INTO mxv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ra suꞌva nani ndia ndikaxin Jesús: Simón ra ndakunani Pedro, inka ra nani Andrés ñani ra Simón, iin ra nani Jacobo, iin ra nani Juan, iin ra nani Felipe, inka ra nani Bartolomé, ");
INSERT INTO mxv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","inka ra nani Mateo, iin ra nani Tomás, inka ra nani Jacobo seꞌe ra Alfeo, iin ra nani Simón ra xindikaa xiꞌin partido ña nani Zelote, ");
INSERT INTO mxv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","inka ra nani Judas, ñani ra Jacobo, iin ra nani Judas Iscariote ra ndixiko Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Saa ke̱e Jesús iku kan ra ndakiꞌin ra vaxi nuu ra xiꞌin ndia ndakaxin ra kaka chiñu nuu ra. Ra ta nduxinu ndia iin yoso, ra xa ikan va ndee kuaꞌa ni ka na ndikun sata ra ña ndiatu na ra. Ra xaa kuaꞌa ni tu yuvi, na ke̱e iinii kuvi ñuu ña ndikun ndiaa Judea, xiꞌin ñuu ña ndoꞌni yuꞌu tiañuꞌu, ña ndikun ndiaa ñuu Tiro xiꞌin ñuu Sidón, ra saa tu na ke̱e ñuu Jerusalén va. Ra ndakutaꞌan takundiꞌi yuvi yoꞌo ña kuni soꞌo na tuꞌun ña kaꞌan ndoso ra, ra kuni tu na ña na sandaꞌa va ra na. ");
INSERT INTO mxv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ra kuaꞌa ni na ku mii tachi ndivaꞌa, nduvaꞌa xa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ra takundiꞌi na xiꞌi, ra kuni na ña tiandiaa ndaꞌa na Jesús, chi kundaa ini na ña ku mii ra ndie̱e̱ ña sandaꞌa ra na, ra nduvaꞌa ndiꞌi va na xiꞌi xa ra. ");
INSERT INTO mxv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ra saa ndakotoꞌni Jesús nuu na ndikun sata ra, ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―Vaꞌa ni kee ndoꞌo, na ndaꞌvi, chi xa ndixaa va kii ña kaꞌndia Ndioxi chiñu nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Vaꞌa ni kee ndoꞌo, na kaꞌun ini vichin, chi vaxi kii ra ndoo ndoso va ña nuu ndo. Vaꞌa ni kee ndoꞌo na xaku vichin, chi vaxi kii ra kusii ni ini ndo. ");
INSERT INTO mxv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Vaꞌa ni kee ndo tu kundasi taꞌan na xiꞌin ndo, ra taxi na ndoꞌo, ra kañaꞌa na xaꞌa ndo, xaꞌa ña kandixa ndo yuꞌu, ra tiꞌvi Ndioxi xaa yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kusii ni ini ndo ta xa na xaa kii kan, ra kuaku ndo, chi xa iyoo va ña vaꞌa taxi Ndioxi ndaꞌa ndo ndivi. Ra ta kuꞌva ^xa ndivaꞌa na xiꞌin ndo vichin, ra saa ke xa tu na xii xikua na xiꞌin na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ndi su ndaꞌvi ni ndoꞌo na kuika, chi xa iyoo vaꞌa ni va ini ndo vichin, ndi su vaxi kii ra köo ña vaꞌa niꞌi vi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ndaꞌvi ni ndoꞌo, na iyoo ña xixi vichin, chi vaxi kii ra kaꞌun ni ini ndo. ’Ndaꞌvi ni ndoꞌo, na ^xáku̱ vichin, chi vaxi kii ra kusuchi ni ini ndo ra kuaku ni ndo. ");
INSERT INTO mxv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ndaꞌvi ni ndoꞌo, na chinuu toꞌo ni na tuꞌun xaꞌa vichin, chi saa ke xa tu na xii xikua ndo xiꞌin na maña, na ndikaꞌan ndoso siki tuꞌun yuꞌu Ndioxi xinaꞌa va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Vichin ^kaꞌan yu xiꞌin ndoꞌo na xini soꞌo ña kaꞌan yu: ―Kuꞌvi ini ndo kuni ndo na saa ini xini ndoꞌo; ra sa ndo ña vaꞌa xiꞌin na kundasi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ra tu ndia na kañaꞌa xaꞌa ndo, a kundivaꞌa na xiꞌin ndo, ra na kaꞌan ndo xiꞌin Ndioxi xaꞌa na, ña na chindiee ra na. ");
INSERT INTO mxv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ra tu ndia na xakin xaꞌndia nuu ndo, ra käni ndo na. Chi na taxi ndo inka xiyo, na kani va na. Ra tu ndia na kuni ndakindiaa chiꞌlo ndixi ndo, ra kuxïꞌndia ndo ña nuu na; chi ndia tikoto ña ndixi ndo na kuꞌun xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tu ndia na nduku ñaꞌa nuu ndo, ra kuxïꞌndia ndo ña nuu na. Ra tu ndia na kindiaa ñaꞌa ndo, ra na käꞌan kuachi ndo xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ra tu kuni ndo sa yuvi ña vaꞌa xiꞌin ndo, ra ña vaꞌa na sa tu ndoꞌo xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ra tu kuꞌvi ini ndo xini ndo takua yuvi na kuꞌvi ini xini ndoꞌo, saa ra, köo yaꞌvi ndiaa vi ña nuu Ndioxi, chi saa ke xa tu yuvi na xïni ichi Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tu xa ndo ña vaꞌa xiꞌin takua yuvi, na xa ña vaꞌa xiꞌin ndo, saa ra köo yaꞌvi ndiaa vi ña nuu Ndioxi, chi saa xa tu yuvi kuachi va. ");
INSERT INTO mxv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ra tu chindiee ndo xuꞌun takua yuvi, na xini ndo kuchuun ndataxi ña ndaꞌa va ndo, saa ra köo yaꞌvi ndiaa vi ña nuu Ndioxi, chi saa xa tu yuvi na xïni ichi Ndioxi va: saa chi chindiee na xuꞌun taꞌan na ra ndiatu ini na ña ndakiꞌin na ña xiꞌin siki va ña. ");
INSERT INTO mxv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kuꞌvi ini ndo kuni ndo na saa ini xini ndoꞌo, ra sa ndo ña vaꞌa xiꞌin na. Ra tu chindiee ndo xuꞌun na ra ndiätu ini ndo ña ndakiꞌin ndo ña ndaꞌa na. Saa ke niꞌi ndo ña vaꞌa nuu Ndioxi, ra kunani ndo seꞌe Ndioxi ra kaꞌnu. Chi vaꞌa ni ini Ndioxi xiꞌin takundiꞌi va yuvi, nii na köo ña toꞌo kuvi na, ra nii na yuvi ñaꞌa kuvi va na. ");
INSERT INTO mxv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ra na kundaꞌvi ini ndo kuni taꞌan ndo, ta kuꞌva kundaꞌvi ini Ndioxi xini ra ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Na käꞌan ndo xaꞌa kuachi inka yuvi, saa ke käꞌan Ndioxi ña iyoo kuachi ndo. Ra na satävi chiꞌña ndo yuvi, saa ke satävi chiꞌña Ndioxi ndoꞌo. Ra koo kaꞌnu ini ndo xaꞌa ña xa inka yuvi xiꞌin ndo, saa ke koo kaꞌnu ini Ndioxi xaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ra vaꞌa ni na koo ini ndo xiꞌin yuvi; ra na taxi ndo ñaꞌa ndaꞌa na xiꞌin ña kusii ini ndo, ra saa ke taxi Ndioxi ñaꞌa ndaꞌa ndo. Ra chikaa ka ra siki ña sandiko ra ndaꞌa ndo, chi ta kuꞌva chuꞌun ndo xiꞌin yuvi, ra saa ke chuꞌun tu Ndioxi xiꞌin va ndo ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin na kachi ra saa: ―¿A kuvi kunuu iin ra kuaa ichi nuu inka ra kuaa, tuvi ndo? Su küvi chi koyo uvi saa va ndia yavi. ");
INSERT INTO mxv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ra ndia nii na sakan sakuaꞌa ra küvi sa chee na nuu maestro na, chi na sakan kutuꞌva va kuvi na. Ra ndia na ndiꞌi kaꞌvi na, saa vi ke xinu na koo na ta kuꞌva iyoo maestro na. ");
INSERT INTO mxv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Nichuun vaꞌa ixtoꞌni kun nuu miꞌi loꞌo ña ndikaa nuu ñani kun, ra kïꞌin kun kuenda xiꞌin itun chee ndikaa nuu mii kun? ");
INSERT INTO mxv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ra tu xïni kun itun chee ndikaa nuu mii kun, ¿ra nichuun vaꞌa kiꞌin kun kuenda ña kaꞌan kun xiꞌin ñani kun: “Ñani, naꞌa, na tava yu miꞌi loꞌo ña ndikaa nuu kun”, kachi kun? ¡Ra ra chiꞌña tuꞌun va kuvi kun! Chi xiꞌna ka itun chee ndikaa nuu mii kun na tava kun. Ra saa ke vaꞌa ndakotoꞌni kaxi kun, ra vaꞌa tava kun miꞌi loꞌo ña ndikaa nuu ñani kun ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Saa ndikaꞌan Jesús xiꞌin na, kachi ra saa: ―Takundiꞌi itun kuiꞌi tu vaꞌa, ra küvi kuun kuiꞌi ña väꞌa ndaꞌa nu. Ra takundiꞌi itun väꞌa, ra küvi kuun kuiꞌi ña vaꞌa ndaꞌa nu. ");
INSERT INTO mxv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Takundiꞌi itun kuiꞌi ra xiꞌin ñaꞌa ña kuun ndaꞌa nu ke ndakuni yo nu. Chi küun koxi ndaꞌa itun ìñu̱, ra nii uva küun ndaꞌa ìñu̱ nañu. ");
INSERT INTO mxv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ra saa tu iin tiaa va, ra iyoo ña vaꞌa nima, ra ña vaꞌa tu ndatuꞌun va ra. Ra iin tiaa ra iyoo ña väꞌa nima, ra ña väꞌa ndatuꞌun va ra. Chi takundiꞌi ña iyoo nima yo ke kaꞌan va yo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Saa ndikaꞌan ka Jesús xiꞌin na, kachi ra saa: ―¿Nichuun kaꞌan ndo, “Tata, Ra Kaꞌnu”, xiꞌin yu, ra xïin tu ndo sa ndo ña kaꞌan yu xiꞌin ndo? ");
INSERT INTO mxv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na kaꞌan yu xiꞌin ndo, ndia kuꞌva ke iyoo yuvi na ndikun yuꞌu, ra kandixa na ña kaꞌan yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta iyoo iin tiaa ra xavaꞌa iin veꞌe, ra kunu ni chikaa ra xaꞌa ña, chi ndia sata kava kaku xaꞌa ña, ra kii nduxinu tiañuꞌu kaꞌnu, ra ndiee ni kani ndiaa ra ña, ra ndikuchüun ra sanduva ra ña, chi tuun ni va xikundichi ña, saa ke iyoo na. ");
INSERT INTO mxv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ndi su na xini soꞌo tuꞌun ña kaꞌan yu, ra kandïxa na ña, ra ta iyoo iin tiaa ra xavaꞌa veꞌe, ra ndichikäa kunu ra xaꞌa ña, chi nuu ñuꞌu taya va sakaku ra xaꞌa ña, ke iyoo na kan. Ra kii nduxinu tiañuꞌu kaꞌnu, ra ikan vi kiꞌin ra veꞌe kan sakoꞌni ra, ra sandiꞌi yaa va ra xaꞌa ña ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ra te sandiꞌi Jesús ndikaꞌan ra xiꞌin na ndee xini soꞌo, ra saa ndakiꞌin ra kuaꞌan ra chi ñuu Capernaum. ");
INSERT INTO mxv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ra ikan iyoo iin ra kuchee nuu iin ciento ndia soldado ndia ñuu Roma. Ra iyoo iin ra xachiñu nuu ra, ra kuꞌvi ni ini ra xini ra ra, ra saa kiꞌin kueꞌe ra xachiñu nuu ra, ra xa iin numi va kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ra ta kundaa ini ra kuchee nuu ndia soldado kan, ña xa ndixaa Jesús ñuu Capernaum, ra saa kana ra ndia xikuaꞌa inuu nuu na judío. Ra ndikaꞌan ra xiꞌin ndia, ña na kuꞌun ndia kuaku ndaꞌvi ndia nuu Jesús, ña kixi ra sandaꞌa ra, ra xachiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ra saa ndixaa ndia nuu Jesús ra xaꞌa ndia xakundaꞌvi ndia nuu ra, kachi ndia saa: ―Tata, vaxi ndi kuaku ndaꞌvi ndi nuu kun ña na kuꞌun kun xiꞌin ndi ra sandaꞌa kun ra xachiñu nuu ra kuchee nuu ndia soldado, saa chi xiniñuꞌu va chindiee taꞌan kun xiꞌin ra chi vaꞌa ni tiaa kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ra suvi ra xavaꞌa veꞌe ñuꞌu ña iin ñuu ndi, chi kuꞌvi ni ini ra xini ra yoo, na ñuu Israel. Ña kan ke vaxi ndi nduku ndi ña mani nuu kun ―kachi ndia xikuaꞌa kan xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia. Ra ta xa kuyachin ndia vaxi ndia nuu iin veꞌe ra kuchee kan, ra saa tiꞌvi ra ndia itaꞌan xiꞌin ra kuaꞌan ndia ña kaꞌan ndia xiꞌin Jesús. Ra ta ndixaa ndia nuu vaxi Jesús, ra saa kachi ndia saa xiꞌin ra: ―Tata, sandïꞌi kun mii kun, chi köo ichi ra ña kiꞌvi kun veꞌe ra, chi ra kaꞌnu ni kuvi yoꞌo nuu ra, kachi ra xiꞌin ndi ña vaxi ndi nuu kun. ");
INSERT INTO mxv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ña kan ke nii ndixändiee ini ra ña kixi mii ra nuu kun. Ra suꞌva va kachi ra xiꞌin chiñu ña vaxi nuu kun: “Tata, vaꞌa ni ñaa va na kundichi kun, ra kaꞌan kun xiꞌin kueꞌe̱ ra nduvaꞌa va ra xachiñu nuu yu. ");
INSERT INTO mxv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi xini va yu, chi iyoo na xaꞌndia tu chiñu nuu yuꞌu va, ra kandixa va yu na; ra yuꞌu tu, xaꞌndia chiñu nuu ndia soldado ra kandixa va ndia yuꞌu: Kuaꞌan ndo, kachi yu xiꞌin ndia, ra kuaꞌan va ndia; Naꞌa ndo, kachi yu, ra vaxi va ndia. Ra saa tu ra xachiñu nuu va yu, xaꞌndia yu chiñu nuu ra, ra kandixa va ra ña kaꞌan yu xiꞌin ra”, kachi ra xiꞌin chiñu vaxi nuu kun ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ra ta xini soꞌo Jesús, ra ndakanda ni ini ra xiꞌin tuꞌun ña ndikaꞌan tiaa kan, ra ndakotoꞌni ra nuu na ndikun sata ra. Ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi täan ndaniꞌi yu ndia nii na Israel na kandixa yuꞌu ta kuꞌva kandixa ra yoꞌo yuꞌu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ra te ndandiko ndia ndixaꞌan xiꞌin chiñu ndaxaa ndia veꞌe ra kuchee kan, ra xa nduvaꞌa va ra xachiñu nuu ra, chi xa sandaꞌa va Jesús ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Saa kuu ndakiꞌin Jesús, kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, ñuu ña nani Naín. Ra kuaꞌa ka vi yuvi ndikun sata ra kuaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ra ta kuyachin ra nuu ñuu kan, ra xini ra kuaꞌan na nduxin na iin ndii, ra seꞌe iin ñaꞌa ña ndukuaan va kuvi ra. Ra iin mii tuꞌun saa va kuvi seꞌe ña. Ra kuaꞌa ka vi yuvi kuaꞌan xiꞌin ña, ña nduxin na ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ra ta xini Jesús ñaꞌa yoꞌo, ra kundaꞌvi ni ini ra xini ra ña, ra ndikaꞌan ra xiꞌin ña kachi ra saa: ―Nana, xäku kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ra saa kuyachin Jesús ra nditiandiaa ndaꞌa ra ixto ndii kan. Ra ndikun ndixkundita va ndia kuaꞌan xiꞌin ndii. Ra ndikaꞌan Jesús, kachi ra saa: ―Ra loꞌo, xiꞌin yoꞌo kaꞌan yu: ¡Ndakoo! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ra saa ndatiaku va ra loꞌo kan, ra ndakunduꞌu ra nuu ixto, ra xaꞌa ra kaꞌan ra, ra saa ndataxi Jesús ra ndaꞌa siꞌi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ra te xini yuvi kan ña ndatiaku ra, ra ndiyuꞌvi ni na. Ra xaꞌa na ^ndasakaꞌnu na Ndioxi, kachi na saa: ―Iin ra kaꞌnu, ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi kuvi ra xaa nuu yo. Chi Ndioxi kuvi ra xaa chindiee taꞌan xiꞌin yo ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ra saa ndindutia ndoso tuꞌun xaꞌa Jesús, iinii kuvi ñuu ña ndikun ndiaa chi Judea xiꞌin sava ka ñuu ña ndoꞌni yachin kan. ");
INSERT INTO mxv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ndatuꞌun ndia itaꞌan xiꞌin ra Juan xaꞌa ña xa Jesús, ra ta kundaa ini ra Juan, ra saa kana ra uvi ndia itaꞌan xiꞌin ra, ");
INSERT INTO mxv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ra tiꞌvi ra ndia kuaꞌan ndia ndakatuꞌun ndia Jesús ña vaꞌa na kundaa ini ra: a ra kan kuvi ra xa iyoo tuꞌun xa kixi sakaku na yuuvi yoꞌo, a kundiatu ndia inka va ra, kachi ra Juan xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ra saa ndixaa ndia nuu Jesús ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Ra Juan, ra ^sakuchi yuvi kuvi ra tiꞌvi nduꞌu vaxi ndi ña ndakatuꞌun ndi yoꞌo: “¿A yoꞌo kuvi ra xa iyoo tuꞌun xaꞌa kixi sakaku nduꞌu? ¿A xiniñuꞌu kundiatu ndi inka va ra?” ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ra suvi mii hora yoꞌo ke kuaꞌa ni na xiꞌi sandaꞌa Jesús, ra kuaꞌa ni tu na ñuꞌu tachi ndivaꞌa va sandaꞌa ra, ra kuaꞌa ni tu na kuaa va ndakotoꞌni xa ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ra ndatuꞌun ndo xiꞌin ra Juan ña xini ndo xiꞌin ña xini soꞌo ndo: Chi na kuaa ra ^ndakotoꞌni va na; ra na küvi kaka, ra ^ndakaka va na; ra na ndoꞌo kueꞌe̱ tiaꞌyu, ra ^nduvaꞌa va na; ra na soꞌo, ra ^ndanuña va soꞌo na; ra na ndii, ra ^ndatiaku va na. Ra ndakani yu tuꞌun Ndioxi nuu na ndaꞌvi ña vaꞌa na kaku va na. ");
INSERT INTO mxv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ra vaꞌa ni ^kee yuvi na ndikun yuꞌu, ra kuëe xa uvi ini na xaꞌa tuꞌun ña kaꞌan yu xiꞌin na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ra ta ndakiꞌin ndia tiꞌvi ra Juan kuanuꞌu ndia, ra saa xaꞌa Jesús kaꞌan ra xaꞌa ra Juan xiꞌin na ndee kan, kachi ra saa: ―¿Ndixa kaa tiaa ra ndixaꞌan ndo xini ndo iku yuu kan? ¿A xini ndo iin tiaa ra kisi ña, ta kuꞌva ndoꞌo iin ndoo ñuꞌu ta xika tachi? ");
INSERT INTO mxv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ra tu süvi saa kaa ra, ¿ra ndixa ke kaa tiaa ra ndixaꞌan ndo xini ndo? ¿A xini ndo iin tiaa ra ndixi tikoto vaꞌa, ña yaꞌvi? Ra xa kundaa ini ndo chi na ndixi tikoto vaꞌa, ña savi, ra vaꞌa ni va iyoo na kan, ra veꞌe vaꞌa nuu ndee na Rey va ndee na. ");
INSERT INTO mxv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ra tu süvi saa kaa ra ndixini ndo, ¿ra ndixa va ke kaa ra? ¿A xini ndo iin ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi? Ndixa va, chi suvi kuvi va ra. Chi chee ka va chiñu ña ^xa ra Juan nuu takundiꞌi na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ra xaꞌa ra Juan yoꞌo ke kaꞌan ña tiaa na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa, ña kunuu ra kixi va ra, ra suꞌva ke kachi ña: Yoꞌo tiꞌvi yu iin tiaa ra kunuu kuꞌun ndasavii ichi kun, kachi tuꞌun Ndioxi kan. ");
INSERT INTO mxv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Ra na kundaa ini ndo chi ra Juan ra sakuchi yuvi kuvi ra chee ka nuu takundiꞌi na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa. Ndi su na kuëe xiniñuꞌu vaꞌa vichin nuu xaꞌndia Ndioxi chiñu, ra na kan kuvi na nduchee ka nuu ra Juan va. ");
INSERT INTO mxv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ra ta xini soꞌo na ña ndikaꞌan ndoso ra Juan ra chinuu toꞌo ni na tuꞌun xaꞌa Ndioxi, ra ndikaꞌan na xiꞌin ra, ra sakuchi ra na, ra ndia na kaya xuꞌun kuaꞌan ndaꞌa gobierno ñuu Roma va, chichi xa ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ndi su ndia fariseo xiꞌin ndia sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ra kundasi va ndia ña vaꞌa, ña kuni Ndioxi sa ra xiꞌin ndia, ra nii ndixïin tu ndia ña sakuchi ra Juan va ndia. ");
INSERT INTO mxv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ra saa ndikaꞌan ka Jesús xiꞌin na, kachi ra saa: ―¿Yoo kuvi na chinuu yu xiꞌin ndoꞌo na ndee vichin? ¿Ra yo kuvi tu na inuu ndo xiꞌin? ");
INSERT INTO mxv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na kaꞌan yu xiꞌin ndo ndia kuꞌva ke iyoo ndo. Ndoꞌo, ra ta iyoo na kuachi na sasiki nuu yaꞌvi va ke iyoo ndo, ra kaꞌan na xiꞌin taꞌan na, kachi na saa: “*Tivi ndi yaa sii xiꞌin tiyoo, ra ndixïin ndo taxaꞌa ndo; ra xita ndi yaa suchi ini, ra nii ndixïin tu ndo kuaku va ndo”, kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ra ta iyoo na kuachi kan va ke, iyoo ndoꞌo, na ndee tiempo vichin. Chi kixi ra Juan ra sakuchi yuvi, ra nii ndixïxi ra, ra nii vino ndixïꞌi ra, ra kaꞌan ndo ña kuu mii ra tachi ndivaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ra vichin xaa tu yuꞌu, ra tiꞌvi Ndioxi; ra ^xixi yu, ra ^xiꞌi yu vino, ra kaꞌan ndo xaꞌa yu: ña xixi ni yu, ra xiꞌi ni yu vino, ra itaꞌan tu yu xiꞌin yuvi kuachi, xiꞌin na maña na kaya xuꞌun kuaꞌan ndaꞌa gobierno ñuu Roma va, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ra na ^ndakiꞌin ña vaꞌa, ña ndichi ña taxi Ndioxi kuvi na ndañaꞌa ña ku na seꞌe va ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iin ra nani Simón ra itaꞌan xiꞌin ndia fariseo ra ndixaꞌan ra ndikaꞌan ra xiꞌin Jesús ña kuꞌun ra kuxi ra xiꞌin ra. Ra saa ndixaa Jesús ndixkunduꞌu ra nuu mesa. ");
INSERT INTO mxv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ra suvi mii ñuu kan iyoo iin ñaꞌa, ña iyoo ni kuachi, ra nduꞌu ni tuꞌun kiꞌvi xaꞌa ña. Ra ta kundaa ini ña ña ndixaa Jesús kuxi ra xiꞌin ra Simón, ra saa ndixaa ña ra niꞌi ña iin yuyu, ra iin chitu ndaa ña xiꞌin ndutia ra xaꞌan tami, tia yaꞌvi ni. ");
INSERT INTO mxv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ra ndixaa ña ndixikusiti ña xaꞌa Jesús, ra xaku ni ña, ra xaꞌa ndikoyo tiakuii nuu ña sata xaꞌa ra, ra xaꞌa ña ndakatia ña xaꞌa ra xiꞌin tiakuii nuu ña. Ra xiꞌin ixi xini ña sandachi ña xaꞌa ra. Ra ta ndiꞌi, saa tiatuvi yuꞌu ña xaꞌa ra, ra kiꞌin ña ndutia xaꞌan tami chikaa ña xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ra ta xini ra Simón ña xa ñaꞌa kan, saa xaꞌa ra ndakani ini ra, kaꞌan ra saa: “Süvi ndixa vi ra kaꞌan tuꞌun yuꞌu Ndioxi kuvi ra yoꞌo, saa chi tu ndixa suvi ra, saa ra xa kundaa va ini ra ndia ñaꞌa kuvi ña yoꞌo, saa chi süvi ña vaꞌa kuvi ña”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Simón, iyoo iin ña kuni yu kaꞌan yu xiꞌin kun ―kachi ra. Ra saa ndakuiin ra Simón, kachi ra saa: ―Vaꞌa va, kaꞌan xiꞌin yu Tata Maestro ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ra saa xaꞌa Jesús ndakani ra iin tuꞌun ndichi kachi ra saa: ―Saa ndoꞌo uvi tiaa ndia xinika xuꞌun nuu iin ra satatu xuꞌun yuvi. Iin ra xinika uꞌun ciento denario, ra inka ra xinika uvi xiko uxi ña. ");
INSERT INTO mxv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ra ndinïꞌi ndia xuꞌun ndataxi ndia ndaꞌa tiaa kan. Ra saa xa kaꞌnu ini ra xaꞌa uvi saa va ndia, kachi tuꞌun ndichi yoꞌo. Ra kaꞌan yoꞌo xiꞌin yu vichin: ¿Yoo kuvi ndia yoꞌo, ndia kuꞌvi ni ka ini kuni tiaa ra xa kaꞌnu ini xiꞌin ndia, tuvi yoꞌo? ―kachi Jesús xiꞌin ra Simón. ");
INSERT INTO mxv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ra saa ndakuiin ra Simón, kachi ra saa: ―Ra kuaꞌa ni ka xinika kuvi ra kuꞌvi ni ka ini xini tiaa kan, tuvi yuꞌu ―kachi ra. Saa ndikaꞌan Jesús kachi ra saa: ―Ña ndixa ke ndikaꞌan kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Saa ndakotoꞌni Jesús nuu ñaꞌa kan. Ra ndikaꞌan ra xiꞌin ra Simón, kachi ra saa: ―¿A xini kun ña xa ñaꞌa yoꞌo xiꞌin yu? Chi ta xaa yu veꞌe kun, ra köo tiakuii nditaxi kun ndoo xaꞌa yu. Ndi su ña yoꞌo, ra xaa ña ndakatia ña xaꞌa yu xiꞌin tiakuii nuu ña, ra sandachi ña xaꞌa yu xiꞌin ixi xini ña. ");
INSERT INTO mxv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta xaa yu veꞌe kun, ra ndixätoꞌo kun yuꞌu. Ndi ña yoꞌo, ra xatoꞌo ni va ña yuꞌu, chi tiatuvi yuꞌu ni va ña xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ra nii aceite ndichikäa kun xini yu, ndi su ña yoꞌo, ra xaa ña chikaa ña ndutia xaꞌan tami xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ra ña kan ke kaꞌan yu xiꞌin kun vichin, chi kuaꞌa ni kuachi ña yoꞌo ra xa xa kaꞌnu va ini yu xaꞌa ña, ra kuꞌvi ni ini ña xini ña yuꞌu; ndi su na loꞌo ni iyoo kuachi tuvi na, ra loꞌo va kuꞌvi ini na xini na yuꞌu ―kachi Jesús xiꞌin ra Simón. ");
INSERT INTO mxv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ra saa ndikaꞌan Jesús xiꞌin ñaꞌa kan, kachi ra saa: ―Xa xa kaꞌnu va ini yu xaꞌa takundiꞌi kuachi kun ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ra na ndee xixi xiꞌin ra nuu mesa kan, ra xaꞌa na kaꞌan na xiꞌin taꞌan na kachi na saa: ―¿Yoo kuvi ra yoꞌo ña vaꞌa xa kaꞌnu ini ra xaꞌa kuachi yuvi? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Saa ndikaꞌan Jesús xiꞌin ñaꞌa kan, kachi ra saa: ―Xaꞌa ña kandixa kun yuꞌu va ke ndikaku kun, ra vichin kuanuꞌu, ra ndïꞌi ka ini kun ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ra ta ndiꞌi, ra ndakiꞌin Jesús kuaꞌan ra xiꞌin uxi uvi saa ndia itaꞌan xiꞌin ra. Ra iinii kuvi ñuu naꞌnu, xiꞌin ñuu vali kaꞌan ndoso ra tuꞌun Ndioxi. Ra ndatuꞌun ra xiꞌin na xaꞌa ichi nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ra kuaꞌan tu sava na siꞌi va xiꞌin Jesús, ra na kan kuvi na tava ra tachi ndivaꞌa ini ta yachi, ra sandaꞌa ra na xiꞌin kueꞌe ña ndoꞌo na. Ra ikan kuaꞌan ña nani María ña ñuu Magdala, ra ña yoꞌo ke tava Jesús uxa nuu tachi ndivaꞌa ini. ");
INSERT INTO mxv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ra kuaꞌan tu ña Juana ña yasiꞌi ra Chuza ra xindiso chiñu xiꞌin veꞌe ra rey Herodes va; ra kuaꞌan tu ña Susana va, ra kuaꞌa ni ka tu sava na siꞌi va kuaꞌan. Ra na siꞌi kan kuvi na chindiee taꞌan xiꞌin Jesús, ña taxi na ndia ndia ka ñaꞌa ña xiniñuꞌu ra xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ra iin ndisaa ñuu ke̱e yuvi ndixaa na nuu Jesús. Ra kuaꞌa ka vi kuvi na ndakuitaꞌan ña kuni soꞌo na ña kaꞌan ra. Ra saa xaꞌa ra ndatuꞌun ra iin tuꞌun ndichi xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Saa kuu, ra kee iin ra chiꞌi kuaꞌan ra chiꞌi ra itu trigo, ra saa kuu ra xatia yava ra nuni vali kan kuaꞌan ra. Ra sava ña ndikoyo yuꞌu ichi, ra ndixañu va na ña, ra xaa tu saa ra ndakiꞌin ri ña xaxi va ri. ");
INSERT INTO mxv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ra sava ña ndikoyo tiañu yuu va ra ndindutia va ña. Ndi su kama ni va ndachi ña chi kuëe kani koꞌyo xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ra sava tu ña ndikoyo nuu iyoo ndikin ìñu̱, ra inuu ndindutia va ña. Ndi su ndiküvi vi kuaꞌnu ña chi ìñu̱ kan va sanduxin ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ra ña ndikoyo nuu ñuꞌu xaꞌan, ra vaꞌa ni xaꞌnu ña. Chi iin mituꞌun yoko trigo ra ndia iin ciento va nuni vali taxi ña ―kachi Jesús xiꞌin na. Ra te sandiꞌi ra ndikaꞌan ra xiꞌin na xaꞌa ña yoꞌo, ra saa ndiee ka vi ndikaꞌan ra xiꞌin na, kachi ra saa: ―Ndoꞌo, na xini soꞌo ña kaꞌan yu. Ra ndakiꞌin xini ndo ni ke kuni kachi ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Saa ndindakatuꞌun ndia itaꞌan xiꞌin Jesús, kachi ndia saa xiꞌin ra: ―Tata, ¿ni ke kuni kachi tuꞌun ndichi ña ndikaꞌan kun? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ra saa ndakuiin Jesús kachi ra saa: ―Ndoꞌo, ra mii Ndioxi va kuvi ra ^taxi ndiayu ndaꞌa ndo ña kundaa ini ndo xaꞌa ichi mii ra, ña iyoo seꞌe nuu xaꞌndia ra chiñu. Ndi su inka yuvi, ra ^täxi vi ra ña ndaꞌa na kan. Ra xaꞌa ña kan ke takundiꞌi ña kuni yu kaꞌan yu xiꞌin na, ra xiꞌin tuꞌun ndichi va kaꞌan yu ña xiꞌin na. Ra nii ixtoꞌni na, ndi küni na, ra nii xini soꞌo va na, ndi kundäa ini na ni ke kuni kachi vi ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ra suꞌva ke kachi tuꞌun ndichi yoꞌo: Nuni ña ndixitia yava yoꞌo kuvi tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ra ña ndikoyo yuꞌu ichi, kuvi yuvi na xini soꞌo tuꞌun Ndioxi. Ra xaa timiaꞌa tava ri ña nima na, ña na kandïxa na Ndioxi ra käku na. ");
INSERT INTO mxv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ra ña ndikoyo tiañu yuu, kuvi yuvi na xini soꞌo tuꞌun Ndioxi. Ra kusii ni ini na ndakiꞌin na ichi Ndioxi, ndi su kuëe kunu ñuꞌu tioꞌo ña nima na, chi loꞌo ni va tiempo ^kandixa na, ra ta vaxi tundoꞌo nuu na, saa ra ndiko ini va na. ");
INSERT INTO mxv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ra ña ndikoyo tiañu ìñu̱, kuvi yuvi na xini soꞌo tuꞌun Ndioxi, ndi su kuee kuee naa ini va na xaꞌa tuꞌun Ndioxi. Ra xaꞌa ndakundiꞌi ini na xaꞌa ña kuika, xiꞌin xaꞌa ña sii ini iyoo nuu ña yuuvi yoꞌo va, ra xä ka na ña vaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ra ña ndikoyo ñuꞌu xaꞌan, kuvi yuvi na xini soꞌo tuꞌun Ndioxi. Ra ndinuni ni kandixa na tuꞌun ña xini soꞌo na, ra chuvaꞌa na ña nima na. Ra kuëe ndiko ini na, chi niña ña vaꞌa va xa na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ra saa ndikaꞌan Jesús kachi ra saa: ―Köo iin yuvi ndatuun ñuꞌu, ra ndasi tu na nuu ña. A chikaa seꞌe tu na ña tixi ixto. Chi nuu sukun va chinduꞌu na ña, ra saa ke vaꞌa yeꞌe nuu takundiꞌi na kuaꞌan kiꞌvi veꞌe. ");
INSERT INTO mxv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ra takundiꞌi ñaꞌa ña iyoo seꞌe, ra ndatuvi ndiꞌi va xaꞌa ña, ra saa tu ña kundäa ini yuvi xaꞌa va, chi vaxi kii ra kundaa va ini na xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ra ña kan ke kuenda ni koo ndo xiꞌin ña kaꞌan yu xiꞌin ndo yoꞌo ra na sa ndo ña. Chi na xiin xini soꞌo ña sañaꞌa yu ra kuaꞌa ni ka ña ndichi taxi Ndioxi ndaꞌa na; ndi su na xïin kuni soꞌo tuꞌun yu, ra ndia ña loꞌo ña xa xini na tuvi mii na ke kindiaa Ndioxi ndaꞌa va na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ra saa xaa siꞌi Jesús xiꞌin na ñani ra nuu iin ra, ra ndiküvi kiꞌvi na veꞌe nuu iin ra, chi chitu ni yuvi xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ra saa ndikaꞌan iin tiaa xiꞌin Jesús kachi ra saa: ―Tata, chi keꞌe xaa siꞌi kun xiꞌin na ñani kun, ndita na, ra kuni na kaꞌan na xiꞌin kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ra saa ndakuiin Jesús, kachi ra saa: ―Na xini soꞌo tuꞌun Ndioxi ra kandixa na ña, ra na kan va kuvi siꞌi yu xiꞌin ñani yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Saa kuu iin kii ndaa Jesús xiꞌin ndia itaꞌan xiꞌin ra ini itun tu xika nuu mini. Ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Na kuꞌun yo inka xiyo yuꞌu mini ―kachi ra. Ra saa ndakiꞌin ndia kuaꞌan ndia xiꞌin nu. ");
INSERT INTO mxv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ra nani saa kuu ndia kuaꞌan ndia xiꞌin itun kan nuu mini, ra nditavi maꞌna Jesús ra ndikixi va ra. Ra saa xaꞌa tachi ndiee ni sakandita ña mini kan ra ndikee ra ini itun kan, ra iin chitu ndaa ini nu xiꞌin tiakuii. Ra ndiakua ^kuni saꞌvi nu kaꞌa mini kan, ra iyo ka vi ^kuu. ");
INSERT INTO mxv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ra saa sandoto ndia Jesús ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―¡Tata Maestro! ¡Tata Maestro! ¡Kuandee itun yoꞌo xiꞌin yo kaꞌa mini! ―kachi ndia xiꞌin ra. Ra saa ndakoo Jesús ra xaꞌndia ra chiñu nuu tachi xiꞌin tiakuii, ra ndikun ndixkuiin va ña, ra iin yayaa kutaxin va. ");
INSERT INTO mxv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ra saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―¿Nichuun kuëe kandixa ndo? ―kachi ra. Ra ndakanda ka vi ini ndia, ra ndiyuꞌvi ni ndia, ra saa xaꞌa ndakatuꞌun taꞌan ndia, kachi ndia saa: ―¿Yoo kuvi ra yoꞌo, ra ndia tachi xiꞌin tiakuii ra xaꞌndia ra chiñu nuu ña ra kandixa ña ra? ―kachi ndia xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ra saa ndixaa ndia xiꞌin itun kan inka xiyo yuꞌu mini, nuu ndikaa ñuu Gadara, chi xitondiaa Galilea. ");
INSERT INTO mxv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ra ta nuu Jesús ñuꞌu, ra niniꞌi taꞌan ra xiꞌin iin tiaa ra ke̱e ñuu kan, ra xa naꞌa ni tiempo ke ñuꞌu tachi ndivaꞌa ini ra. Ra iin saa kaa chala va ra xika ra, ra nii veꞌe ra ndixkandüꞌu ka ra, chi ndia yavi ndii va ndixkuu veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ra ta xini ra Jesús, saa ra ndindaꞌyu koꞌo ra, ra ndikun ndixkusiti ra, ra ndiee ka vi ndikaꞌan ra, kachi ra saa: ―¡Jesús, Seꞌe Ndioxi Ra Kaꞌnu! ¿Ni ke kuni kun xiꞌin yu? Xaku ndaꞌvi yu nuu kun, ña na sandöꞌo kun yuꞌu ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ra ndikaꞌan ra tuꞌun yoꞌo saa chi xa ndikaꞌan va Jesús xiꞌin tachi ndivaꞌa kan ña na kee ña kuꞌun ña. Chi xa naꞌa ni ndikaa ña ra. Ra kuaꞌa ni ichi ndiee ni ^xa ña xiꞌin ra. Ra nii chikaa na yoꞌo kàà ndaꞌa ra xiꞌin xaꞌa ra, ña ndiaa na ra, ndi su xaꞌndia ndiꞌi va ra ña, ra tava tachi ndivaꞌa kan ra kuaꞌan ra iku yuu va iyoo ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Saa ndindakatuꞌun Jesús ra, kachi ra saa xiꞌin ra: ―¿Ni ke nani kun? ―kachi ra. Ra saa ndakuiin ra, kachi ra saa: ―Legión va nani yu ―kachi ra. Saa chi kuaꞌa ni tachi ndivaꞌa ndikee ini ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ra saa xaku ndaꞌvi ka vi tachi ndivaꞌa kan nuu Jesús, ña na tïꞌvi ra ña kuꞌun ña ndiaya kaꞌnu nuu ndoꞌo ni ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ra yachin iku kan xika iin tiꞌvi chee kini xaxaꞌan ri. Ra saa xakundaꞌvi ka vi tachi ndivaꞌa kan nuu Jesús, ña na taxi ra ndiayu ndaꞌa ña nde̱e ña ini kini kan. Ra saa taxi ra ndiayu ndaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ra saa ke̱e tachi ndivaꞌa ini tiaa kan, ra ndandee ña ini kini. Ra xaꞌa sasana ndiꞌi ña ri, ra xinu ndiꞌi ri ndixaꞌan ri ndikoyo ri iin taꞌvi sukun nuu ndikaa mini, ra ndikaꞌa ndiaa ndiꞌi ri ndixiꞌi ri. ");
INSERT INTO mxv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ra ta xini ndia ndiaa kini ña kuu kan, ra saa ke̱e ndia xinu ndia ndixaꞌan ndia ndatuꞌun ndia xiꞌin na ndee ñuu. Ra ndatuꞌun tu ndia xiꞌin na ndee iku va. ");
INSERT INTO mxv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ra saa ke̱e yuvi kan kuaꞌan na kuni na ña kuu. Ra ta ndixaa na nuu iin Jesús, ra xini na tiaa ra ke̱e tachi ndivaꞌa ini, ra xa nduvaꞌa va ra, ra ndakundixi ra tikoto nduꞌu koo ra xaꞌa Jesús, ra ndiyuꞌvi ka vi na. ");
INSERT INTO mxv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ra na xini ña kuu kan, ra ndatuꞌun na xiꞌin takundiꞌi yuvi ndia kuꞌva ke nduvaꞌa tiaa ra xindoꞌni tachi ndivaꞌa ini kan. ");
INSERT INTO mxv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ra takundiꞌi na ñuu Gadara, ra xaku ndaꞌvi ni na nuu Jesús, ña na kuꞌun ra inka xiyo, chi iyuꞌvi ni na ^xini na ra. Saa ndandaa Jesús ini itun kan ra ndakiꞌin ra kuaꞌan va ra xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ra tiaa ra kee tachi ndivaꞌa ini kan, ra xaku ndaꞌvi ka vi ra nuu Jesús ña na taxi ra kuꞌun ra xiꞌin ra. Ndi su ra nindiayu taꞌan va kuvi Jesús xiꞌin ra, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Kuanuꞌu veꞌe kun, ra ndatuꞌun kun xiꞌin takundiꞌi yuvi xaꞌa ña xa Ndioxi xiꞌin kun ―kachi ra xiꞌin ra. Saa ndakiꞌin tiaa kan kuanuꞌu ra. Ra ndatuꞌun ra xiꞌin takundiꞌi yuvi xaꞌa ña vaꞌa xa Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ta ndiko Jesús ndaxaa ra inka xiyo yuꞌu mini nuu ke̱e ra ta kuaꞌan ra, ra xa iin chitu ndaa va yuvi ndee na ndiatu na ra. Ra ^kusii ka vi ini na ndakiꞌin na ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ra saa xaa iin tiaa ra nani Jairo nuu iin Jesús. Ra ra xikuaꞌa ndiso chiñu xiꞌin veꞌe ñuꞌu kuvi ra, ra ndikun ndixkusiti va ra nuu Jesús, ra xaku ndaꞌvi ka vi ra nuu ra ña na kuꞌun ra xiꞌin ra veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Saa chi ña loꞌo seꞌe ra, ña mituꞌun nuu ra, ra sakan uxi uvi va kuiya ndikaa ña, ra ndiee ni ndoꞌo ña chi xa yachin va kuvi ña. Ra saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ra Jairo. Ra kuaꞌa ka vi yuvi ndikun kuaꞌan sata ndia, ra iin chindaꞌni taꞌan mii na kuaꞌan na xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ra tiañu yuvi kan ndikaa iin ñaꞌa ña ndiee ni ndoꞌo kuaꞌan ña xiꞌin na, ra xa uxi uvi kuiya ke xatia ña nii ña. Ra xa sandiꞌi yaa va ña xuꞌun ña xiꞌin na xatatan, ra ndia nii na ndikuchüun sandaꞌa ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ra saa kuyachin ña chi sata Jesús ra nditiandiaa ndaꞌa ña yuꞌu tikoto ra. Ra ndikun ndixkuiin va ña ndixätia ka ña nii ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ra saa ndikaꞌan Jesús, kachi ra saa: ―¿Yoo kuvi na nditiandiaa ndaꞌa yuꞌu? ―kachi ra. Ra iin xa xïni ndiꞌi va na. Ra saa ndikaꞌan ra Pedro, kachi ra saa: ―Tata Maestro, iin takundiꞌi na chindaꞌni taꞌan sata kun, ¿ra ni ke sa kun ña kundaa ini kun yo kuvi na nditiandiaa ndaꞌa yoꞌo? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Saa ndakuiin tuku Jesús kachi ra saa: ―Ndi su iyoo va iin na nditiandiaa ndaꞌa yuꞌu, chi kundaa ini yu ña ke̱e ndie̱e̱ yu sandaꞌa ña na ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ra te kundaa ini ñaꞌa yoꞌo ña ndiküvi koo seꞌe, ña ndoꞌo ña, ra iyuꞌvi ka vi ña, ra iin ndiakua kisi ña ña xaa ña ndixkusiti ña nuu Jesús. Ra nuu ndiꞌi na ndakani ña ni xaꞌa ke nditiandiaa ndaꞌa ña tikoto ra. Chi ta nditiandiaa ndaꞌa suꞌva ña tikoto ra, saa ra ndikun nduvaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ra saa ndikaꞌan Jesús xiꞌin ña, kachi ra saa: ―Seꞌe, xaꞌa ña ndiaa ini kun yuꞌu va ke xa nduvaꞌa kun. Ra vichin kuanuꞌu, ra ndïꞌi ka ini kun ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ra ta kaꞌan ka va Jesús, saa xaa iin ra ke̱e veꞌe ra Jairo, ra ndikaꞌan ra kachi ra saa xiꞌin ra: ―Tata, xa ndixiꞌi va seꞌe kun, sandïꞌi ka kun ra Tata Maestro ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ra ta xini soꞌo Jesús, ña ndikaꞌan tiaa kan, ra saa ndikaꞌan ra xiꞌin ra Jairo, kachi ra saa: ―Kuayüꞌvi kun. Indaa yuꞌu va kandixa kun, ra ndatiaku va seꞌe kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ra ta kuyachin na yeꞌe ra Jairo, ra nditäxi Jesús kiꞌvi ndiꞌi na xiꞌin ra veꞌe nuu kanduꞌu ña loꞌo kan, chi takua ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan xiꞌin takua iva ña xiꞌin siꞌi va ña kuvi na ndikiꞌvi xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ra xaku ka vi yuvi ndee kan xaꞌa ña. Saa ndikaꞌan Jesús xiꞌin na, kachi ra saa: ―Xäku ndo chi süvi ña ndixiꞌi kuvi ña. Chi ña kixi va kuvi ña ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ra xaꞌa na ^xa siki na ra, chi xa kundaa va ini na ña ndixa ke xa ndixiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ra saa tiin Jesús ndaꞌa ña. Ra ndiee ni ndikaꞌan ra xiꞌin ña, kachi ra saa: ―¡Ña loꞌo, ndakoo! ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Saa ra, ndikun ndatiaku ndixa va ña, ra ndakoo ña. Ra saa xaꞌndia ra chiñu nuu na, ña na taxi na ña kuxi ña. ");
INSERT INTO mxv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ra saa ndakanda ni ini na ivasiꞌi ña. Ra ndikaꞌan Jesús xiꞌin na, kachi ra saa: ―Ndia nii na ndatüꞌun ndo xiꞌin xaꞌa ña ndoꞌo ña loꞌo seꞌe ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ra saa ndachitaꞌan Jesús uxi uvi saa ndia itaꞌan xiꞌin ra. Ra taxi ra ndie̱e̱ xiꞌin ndiayu ndaꞌa ndia ña tava ndia takundiꞌi nuu tachi ndivaꞌa, ra sandaꞌa ndia na xiꞌi ndia ndia ka nuu kue̱ꞌe̱. ");
INSERT INTO mxv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ra saa tiꞌvi ra ndia kuaꞌan ndia kaꞌan ndoso ndia tuꞌun Ndioxi, ra sandaꞌa ndia na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ndia nii ñaꞌà kanïꞌi ndo kuꞌun ndo ichi, nii itun kätuvi ndo, ni leka, ni ixta, ni xuꞌun, ni tikoto ña ndasama ndo küꞌun xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ra ndia ndia ka veꞌe nuu ndixaa ndo, ra ndakiꞌin mani na ndoꞌo ra ikan kundee ndo xiꞌin na ndia kii na kee ndo kuꞌun ndo inka ñuu va. ");
INSERT INTO mxv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ra tu ndia ñuu ndixaa ndo, ra xïin na ndakiꞌin mani na ndoꞌo koo ndo xiꞌin na, saa ra kee ndo ñuu ñaa kuꞌun va ndo. Ra sakoyo ndo yaka xaꞌa ndo ña na kundaa ini na ña ^kundasi na tuꞌun Ndioxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ra saa ndakiꞌin ndia kuaꞌan ndia iinii kuvi ñuu kaꞌan ndoso ndia tuꞌun Ndioxi, ra sandaꞌa ndia na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ta xini soꞌo ra rey Herodes, ra Tetrarca xaꞌa takundiꞌi ña ^xa Jesús, ra xaꞌa ndakani ka vi ini ra, chi sava na kaꞌan: “Ra Juan ra ndixiꞌi va kuvi ra ndatiaku”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ra sava tu na kaꞌan: “Ra Elías ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa va kuvi ra ndita”, kachi na. Ra sava tu na kaꞌan: “Inka ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa va kuvi ra ndatiaku”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Saa ndikaꞌan ra Herodes, kachi ra saa: ―¿Yoo ku ra yoꞌo? Ra kuaꞌa ni ña xini soꞌo yu ^xa ra. Ndi süvi ra Juan kuvi ra chi yachi vi xaꞌndia yu chiñu ña xaꞌndia na sukun ra kan ―kachi ra Herodes. Ra xaꞌa ña yoꞌo ke ndiee ni ndixika nduku ra Rey Herodes kuni ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ra ta nandiko uxi uvi saa ndia itaꞌan xiꞌin Jesús ndaxaa ndia, ra ndatuꞌun ndiꞌi va ndia xiꞌin Jesús xaꞌa ña xa ndia nuu ndixaꞌan ndia ndikaꞌan ndoso ndia tuꞌun Ndioxi. Saa ndakundiaka ra ndia kuaꞌan ndia xiꞌin ra chi iku nuu ñuu Betsaida. Ra saa ndixaa ndia iku nuu köo yuvi kan ndixkundee ndia ña ndakindiee ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ra ta kundaa ini yuvi nuu kuaꞌan Jesús, ra saa ndakundikun na kuaꞌan na sata va ra. Ra ta ndixaa na nuu iin ra, ra saa ndakiꞌin ra na, ra xaꞌa ra ndakani ra nuu na ndia kuꞌva ke kaꞌndia chiñu Ndioxi nuu na. Ra sandaꞌa tu ra na xiꞌi va. ");
INSERT INTO mxv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Saa kuu, ra xa kuaꞌan kuaa va, ra saa kuyachin uxi uvi saa ndia itaꞌan xiꞌin Jesús ra ndikaꞌan ndia xiꞌin ra, kachi ndia saa: ―Tata, vaꞌa ka na kaꞌan kun xiꞌin na, ra na kuꞌun na ndakindiee na, ra nduku na ña kuxi na ndia ndia ka ñuu ña ndoꞌni yachin. Chi yoꞌo ra köo mii vi ña kuxi na ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Taxi ndoꞌo ña kuxi na ―kachi ra xiꞌin ndia. Ra saa ndakuiin ndia, kachi ndia saa: ―Tata, ¿ndia mii kee ña kuxi na? Chi takua uꞌun va ku ixta, xiꞌin uvi tiaka va ndiso ndi. Ra näni mii vi ña yoꞌo kuxi na chi kuaꞌa ni kuvi na. Tu kuꞌun ka ndi ndia ñuu va sata ndi ña kuxi na ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ―Kaꞌan ndo xiꞌin na ña na ndakundee vii na, ra ta uvi xikoxi ta uvi xikoxi na ndakundee na ―kachi ra xiꞌin ndia. Ra na ndakundee kan, ra kuꞌva uꞌun mil kuvi niña tiaa va. ");
INSERT INTO mxv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ra saa ndikaꞌan ndia xiꞌin na ña na ndakundee vii na. ");
INSERT INTO mxv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ra kiꞌin Jesús uꞌun saa ixta xiꞌin uvi saa tiaka, ra ndoniꞌi ra nuu ra ndivi ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña. Ra te ndiꞌi saa ndataꞌvi ra ña, ra taxi ra ña ndaꞌa ndia itaꞌan xiꞌin ra, ña na ndataꞌvi ndia ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ra xixi takundiꞌi va na ndiakua nditiandiaa ini na. Ra uxi uvi ka tuka chitu ndakiꞌin ndia xiꞌin ña ndindoo ndoso. ");
INSERT INTO mxv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Saa kuu iin kii nduꞌu mituꞌun saa Jesús kaꞌan ra xiꞌin Ndioxi. Ra yachin kan ndee uxi uvi saa ndia itaꞌan xiꞌin ra. Ra saa ndindakatuꞌun ra ndia, kachi ra saa: ―¿Yoo kuvi yuꞌu kachi yuvi? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Saa ndakuiin ndia, kachi ndia saa: ―Sava na kaꞌan ña kuu kun ra Juan ra sakuchi yuvi; ra sava tu na kaꞌan ña kuu kun ra Elías va; ra sava tu na kachi saa ña kuu kun ndia iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va, ra ndatiaku kun, kachi na xaꞌa kun ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Ra ndoꞌo tu, ¿yoo kuvi yu, tuvi ndo? ―kachi ra xiꞌin ndia. Ra saa ndakuiin ra Pedro kachi ra saa: ―Tata, yoꞌo kuvi Cristo, ra ndikaxin Ndioxi sakaku na yuuvi yoꞌo ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ra ndikaꞌan ni Jesús xiꞌin ndia itaꞌan xiꞌin ra, ña na ndatüꞌun ndia xiꞌin ndia nii yuvi xaꞌa ña ndikaꞌan ra Pedro. ");
INSERT INTO mxv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Yuꞌu, ra xaa yoꞌo, ra xiniñuꞌu ndoꞌo ni yu, ra ndia xikuaꞌa ñuu Israel, xiꞌin ndia sutu kunaꞌnu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, ra kundasi ni ndia yuꞌu, ra kaꞌni ndia yuꞌu, ndi su kii ña uni ra ndatiaku va yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ra ta ndiꞌi, saa ndikaꞌan ra xiꞌin takundiꞌi na ndee kan, kachi ra saa: ―Tu ndia ndo kuni kundikun yuꞌu, ra xiniñuꞌu kaꞌndia ini ndo xaꞌa mii ndo; ra iin ndisaa kii ndakasoko ndo cruz ndo, ra kundikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Saa chi yuvi na kuni sakaku mii, ra na kan ku na ndiꞌi xaꞌa va; ra na sandoñuꞌu mii xaꞌa yuꞌu, kuvi na kuchuun kaku va. ");
INSERT INTO mxv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ra vaꞌa ni na sakanaa yuvi iinii saa va ña yuuvi yoꞌo, ndi su tu na sandoñuꞌu va tu na nima na, saa ra köo yaꞌvi ndiaa vi ña. ");
INSERT INTO mxv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ra tu ndia ndo kukaꞌan nuu xaꞌa ña ndikun ndo yuꞌu, xiꞌin xaꞌa ña sañaꞌa yu, ra kukaꞌan tu nuu yuꞌu va kuni yu ndoꞌo ta xa na ndiko yu xiꞌin ndie̱e̱ yu, xiꞌin ndie̱e̱ Tata yu, xiꞌin na yii na kuu tatun ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ña ndaa kaꞌan yu xiꞌin ndo, chi sava ndoꞌo na ndee yoꞌo vichin, ra saa kuu tiaku ka va ndo, ra kuni nuu va ndo ña kaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ra xa kuꞌva una kii ke ndiyaꞌa ta ndikaꞌan ra tuꞌun yoꞌo xiꞌin na. Saa ndakiꞌin ra kuaꞌan ra iin iku sukun kaꞌan ra xiꞌin Ndioxi, ra kuaꞌan ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ra sakan ta kaꞌan va ra xiꞌin Ndioxi, ra saa ndasama nuu ra, ra ndayeꞌe ña, ra nduyaa ni tikoto ña ndixi ra, ra iin yeyeꞌe nduu ña, ra iin ndiakua taxa taxa nduu ña. ");
INSERT INTO mxv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Saa ndakoyo uvi tiaa ndatuꞌun ndia xiꞌin ra. Ra ra Moisés, xiꞌin ra Elías va kuvi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ra iin ndayeꞌe ndiꞌi nuu ndita ndia, ra kaꞌan ndia xiꞌin Jesús, xaꞌa ña ndoꞌo ra, ña kuvi ra ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ra nii kuni kusun ni va ra Pedro, ra saa tu ndia itaꞌan xiꞌin va ra, ndi su ndikïxi ndia. Ña kan ke vaꞌa xini ndia ña ndayeꞌe Jesús, xiꞌin uvi ndia ndita xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ra ta sakan ndixikutiaꞌa ndia ndita xiꞌin Jesús; ra saa ndikaꞌan ra Pedro, xiꞌin ra kachi ra saa: ―Tata Maestro, vaꞌa ni kuu ndee yo yoꞌo. Ra na savaꞌa ndi uni veꞌe tuvixin vali, ra iin ña kuu veꞌe yoꞌo, ra iin ña kuu veꞌe ra Moisés, ra iin ña kuu veꞌe ra Elías ―kachi ra xiꞌin Jesús. Ra nii ndikundäa ini ra ni ke kaꞌan ra xaꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ra sakan ta kaꞌan va ra, saa nduxinu viko sata ndia. Ra ta xini ndia viko kan ra ndiyuꞌvi ni ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ra tiañu viko kan tiaku ndikaꞌan Ndioxi, kachi ra saa: ―Ra yoꞌo kuvi seꞌe yu, ra kuꞌvi ni ini yu xini yu ra. Ra na kandixa ndo ña kaꞌan ra xiꞌin ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ra ta ndiꞌi ndikaꞌan Ndioxi, ra ndia mituꞌun saa va Jesús xini ndia ndichi. Ra takundiꞌi tiempo kan ra ndia nii yuvi ndindatüꞌun ndia xiꞌin xaꞌa vi ña xini ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ra ta ndituvi inka kii, saa nandiko Jesús xiꞌin ndia ndixaꞌan xiꞌin ra iku. Ra kuaꞌa ka vi yuvi xa ndee ndiatun na ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ra iin tiaa ra ndikaa tiañu na kuaꞌa kan, ra ndiee ka vi ndikaꞌan ra, kachi ra saa: ―Tata Maestro, xaku ndaꞌvi yu nuu kun, ña na sandaꞌa kun seꞌe yu, chi iin mituꞌun saa va kuvi ra nuu yu. ");
INSERT INTO mxv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chi ta xaa tachi ndivaꞌa yoꞌo, ra tiin ña ra, ra iin sandaꞌyu koꞌo ña ra, ra xaꞌni yiꞌi ña ra ndiakua lolo tava ña yuꞌu ra. Ra xa ndivaꞌa ni ña xiꞌin ra, ra xïin ña saña ña ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ra xa xaku ndaꞌvi va yu nuu ndia itaꞌan xiꞌin kun, ña na tava ndia tachi ndivaꞌa yoꞌo, ndi su ndikuchüun vi ndia ña tava ndia ña ―kachi tiaa kan xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Saa ndakuiin Jesús, kachi ra saa: ―Ni va yuvi kuvi ndoꞌo ña kandïxa ndo. ¿Nichuun ndiee ni ini ndo? Kundiëe ka ini yu nuu ndo ―kachi ra xiꞌin ndia. Ra saa ndikaꞌan ra xiꞌin tiaa kan, kachi ra saa: ―Naꞌa choꞌo xiꞌin seꞌe kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ra ta kuyachin ra loꞌo kan ndixaa ra nuu Jesús, ra ndikun kuun tuku va tachi ndivaꞌa kan ra ñuꞌu, ra xaꞌa xaꞌni yiꞌi tuku va ña ra. Ra saa ndukueꞌe Jesús xiꞌin ña, ra sandaꞌa ra ra loꞌo kan, ra ndataxi ra ra ndaꞌa iva ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Saa ra, ndakanda ni ini na ndee kan, xaꞌa chiñu ña kaꞌnu ni ña xa Ndioxi. Ra nani saa kuu yuvi kan, ña ndakanda ini na ixtoꞌni na nuu Jesús xaꞌa ña xa ra. Ra saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Kuni vaꞌa soꞌo ndo, ña kaꞌan yu xiꞌin ndo, ra näa ini ndo xaꞌa ña. Chi yuꞌu, ra xaa yoꞌo, ra ndataxi na yuꞌu ndaꞌa na saa ini xini yuꞌu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ra nii ndikundäa ini ndia ni xaꞌa ke kachi Jesús saa xiꞌin vi ndia. Chi ^ndasi va ña xini tuni ndia, ña kan ke ndinïꞌi xini ndia xiꞌin vi tuꞌun kan. Ra iyuꞌvi ni tu ndia ña ndakatuꞌun ndia Jesús va. ");
INSERT INTO mxv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Saa xaꞌa ndatuꞌun kuachi ndia itaꞌan xiꞌin Jesús, ña yo kuvi iin ndia kunuu kaꞌndia chiñu, kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ra kundaa va ini Jesús ña ndakani ini ndia. Ra saa tiin, ra iin ra loꞌo xani ndichi ra xitia ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Yuvi na ndakiꞌin mani iin ra loꞌo taꞌan ra yoꞌo xaꞌa ña kandixa na yuꞌu, saa ra ndakiꞌin mani tu na yuꞌu va; ra na ndakiꞌin mani tu yuꞌu, saa ra, ndakiꞌin mani tu na ra tiꞌvi yuꞌu va. Ra tiaa ra köo yaꞌvi ndiaa, tuvi ndo, kuvi ra chee vaꞌa ka va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ra saa ndikaꞌan ra Juan xiꞌin Jesús kachi ra saa: ―Tata Maestro, xini ndi iin tiaa, ra tava ra tachi ndivaꞌa xiꞌin kivi kun. Ra ndikaꞌan ndi xiꞌin ra, ña na kuniñüꞌu ka ra kivi kun, chi süvi ra itaꞌan xiꞌin yo kuvi ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Säsi ndo nuu ra, chi yuvi na kuëe kataꞌan xiꞌin yo, kuvi na kuaꞌan ndie̱e̱ va yo ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ra ta xa kuaꞌan kuyachin kii ña nandiko Jesús kunuꞌu ra ndivi, ra saa ndachikaa ndaku ni ini ra ña kuꞌun ra ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ra saa chinuu ra sava ndia itaꞌan xiꞌin ra, kuaꞌan ndia chi ñuu ña ndikun ndiaa chi Samaria, ña nduku ndia veꞌe nuu kusun ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ra ndixïin na ñuu kan taxi na veꞌe kusun ra, saa chi kundaa va ini na ña yaꞌa ra kuaꞌan ra chi ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ra ta xini ra Jacobo xiꞌin ra Juan ña xa na saa, ra saa ndikaꞌan ndia xiꞌin Jesús, kachi ndia saa: ―Tata, ¿a kuni kun na kaꞌan ndi xiꞌin Ndioxi, ra sakuun ra ñuꞌu ña kee ndivi ta kuꞌva xa ra Elías, ra na kaꞌmi ndiꞌi ña na? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ra saa ndikokuiin Jesús ndakotoꞌni ra nuu ndia, ra ndukueꞌe ra xiꞌin ndia, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","―Yuꞌu, ra xaa yoꞌo, ra växi yu sandiꞌi yu xaꞌa yuvi, chi na sakaku va yu kuvi na, ña xaa yu ―kachi ra xiꞌin ndia. Ra saa ndakiꞌin ndia kuaꞌan ndia inka ñuu va. ");
INSERT INTO mxv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sakan saa kuu Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra ichi kan, ra saa ndikaꞌan iin tiaa xiꞌin ra, kachi ra saa: ―Tata, ndia ndia ka mii nuu kuaꞌan va kun, ra kuꞌun yu xiꞌin va kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ra saa ndakuiin Jesús, kachi ra saa: ―Yukuii, ra iyoo va yuꞌu kava nuu kixi ri, ra saa tu sàà va, saa chi iyoo va chiꞌyo ri. Ndi su yuꞌu, ra xaa yoꞌo, ra köo nuu kanduꞌu yu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Saa ndikaꞌan tu Jesús xiꞌin inka ra kachi ra saa: ―Naꞌa, na koꞌo xiꞌin yu ―kachi ra xiꞌin ra. Ra saa ndakuiin tiaa kan, kachi ra saa: ―Tata, kundiatu ñaꞌa kun yuꞌu, ra na nduxin yu iva yu. Saa kuꞌun yu xiꞌin kun ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ra saa ndakuiin Jesús, kachi ra saa: ―Ndakoo na ndii, ra na nduxin taꞌan mii va na. Ra kuaꞌan va yoꞌo, ña kaꞌan ndoso kun tuꞌun Ndioxi va ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ra saa ndikaꞌan tuku inka ra xiꞌin Jesús kachi ra saa: ―Tata, kuni tu yuꞌu va kundikun yu yoꞌo. Ndi su kundiatu yuꞌu, ra na kuꞌun yu ndiayu taꞌan yu xiꞌin na veꞌe yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Saa ndakuiin Jesús, kachi ra saa: ―Iin tiaa ra tiin xaꞌa yata, ra taꞌvi ra, ra küvi ndikokuiin ra ndakotoꞌni ra chi sata ra, chi tu saa na sa ra, saa ra, tivi va chichi ña kuaꞌan ra xiꞌin. Ra na ^xa suꞌva, ra kuchüun vi na kiꞌvi na nuu xaꞌndia Ndioxi chiñu ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ra saa kuu ndikaxin Jesús uni xiko uxi tiaa, ndia ndikun sata ra, ra ta uvi, ta uvi chitaꞌan ra ndia. Ra chinuu ra ndia kuaꞌan ndia kaꞌan ndoso ndia tuꞌun Ndioxi iin takundiꞌi ñuu nuu kuꞌun ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ña ndixa ke iyoo kuaꞌa ni va yuvi kumani kuni soꞌo tuꞌun Ndioxi. Ra ta kuꞌva iyoo itu ña xa vaꞌa sakee va yo, ke iyoo na, chi xa iyoo nduvi va na. Ña kan ke xiniñuꞌu ni va kaꞌan ndo xiꞌin Ndioxi ña na tiꞌvi ka ra, na chindiee taꞌan xiꞌin ndo, chi loꞌo ni va kuvi ndoꞌo na kaꞌan ndoso tuꞌun ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ra vichin kuaꞌan ndo sanduvi ndo ña ndikaꞌan yu xiꞌin ndo. Ra kuenda ni na koo ndo, chi ta iyoo ndikachi vali ri kuaꞌan tiañu ndivaꞌyu va ke iyoo ndo. ");
INSERT INTO mxv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ra nii leka ndo kanïꞌi ndo, ra nii xuꞌun kanïꞌi ndo, ra nii küꞌun tu inka naꞌa ndixan va ndo xiꞌin ndo, ra nii kundïta ndo ña kaꞌan ndioxi ndo xiꞌin na ndakutaꞌan xiꞌin ndo ichi. Chi iin ndaku ndaku na kuꞌun va ndo. ");
INSERT INTO mxv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ra te xa na xaa ndo iin veꞌe, ra xiꞌna ka va na kaꞌan ndioxi ndo xiꞌin na kachi ndo suꞌva: “Ña vaꞌa na koo xiꞌin ndoꞌo na ndee veꞌe yoꞌo”, kachi ndo xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ra tu iyoo yuvi na iyoo ña vaꞌa ini, saa ra niꞌi ka na ña vaꞌa kuaꞌan xiꞌin ndo, koo xiꞌin va na, ra tu köo na, saa ra ndiko ña vaꞌa yoꞌo kuꞌun ña xiꞌin va ndo. ");
INSERT INTO mxv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ra veꞌe nuu ndakiꞌin mani na ndoꞌo ke na koo ndo xiꞌin va na. Ra na kuxi ndo ña taxi na kuxi ndo, ra na koꞌo tu ndo tiakuii ra taxi na ndaꞌa va ndo. Saa chi takundiꞌi na xachiñu, ra iyoo va ichi na ña koo yaꞌvi na. Ra xïka ndo ta veꞌe ta veꞌe na kusun ndo. ");
INSERT INTO mxv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ra te na xaa ndo iin ñuu, nuu ndakiꞌin mani na ndoꞌo, ra taxi na ñaꞌa kuxi ndo xiꞌin na, ra na kuxi va ndo ña. ");
INSERT INTO mxv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ra tu iyoo na xiꞌi ñuu nuu xaa ndo, ra na sandaꞌa va ndo na. Ra kaꞌan ndo xiꞌin takundiꞌi yuvi, kachi ndo saa: “Xa kuyachin Ndioxi nuu yo ña kaꞌndia ra chiñu”, kachi ndo xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ra tu ndixaa ndo iin ñuu ra ndixïin na ndakiꞌin mani na ndoꞌo, saa ra na kee ndo kuꞌun va ndo ra kaꞌan ndo xiꞌin na kachi ndo saa: ");
INSERT INTO mxv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ndia yaka ñuu ndo ña chichi xaꞌa ndi ke na sakoyo va ndi, ra saa ke kundaa ini ndo ña kundasi ndo tuꞌun Ndioxi, ra na kundaa ini ndo, chi xa kuyachin ni va Ndioxi ña kaꞌndia ra chiñu nuu ndo”, kachi ndo xiꞌin na ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Saa ndikaꞌan ka Jesús xiꞌin ndia, kachi ra saa: ―Ña ndaa kaꞌan yu xiꞌin ndo, chi kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo, ra chee ni ka va ña ndoꞌo na ñuu nuu xïin na ndakiꞌin na tuꞌun Ndioxi vichin nuu na ñuu Sodoma, na sandiꞌi Ndioxi xaꞌa xinaꞌa ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ra saa ndikaꞌan Jesús kachi ra saa: ―¡Ndaꞌvi ni na ñuu Corazín, xiꞌin na ñuu Betsaida! Chi kuaꞌa ni ña xituꞌun xa yu ñuu na, ra nindïko ini na. Ra tu ñuu Tiro xiꞌin ñuu Sidón ndixa yu ña xituꞌun yoꞌo, saa ra xa yachi vi nandiko ini na kan, ra xa ndakundixi ndaꞌvi va na iin tikoto ña tumi ña kueꞌe ni, ra xa ndakundee va na nuu yaa nuꞌu, ña ndañaꞌa na mii na ña xa ^nandiko ini na xaꞌa kuachi na. ");
INSERT INTO mxv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ra ndoꞌo ni ka va na ñuu Corazín, xiꞌin na ñuu Betsaida, nuu na ñuu Tiro, xiꞌin na ñuu Sidón, kii ña sandaku Ndioxi kuachi xiꞌin na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ra ndoꞌo, na ñuu Capernaum, ra kuaꞌa ni va ña xituꞌun xa yu xini ndo. Ndi su ndixïin ndo kandixa ndo, ra kuꞌun va ndo ndivi tuvi ndo, ndi su ¡ndaꞌvi ni ndo!, saa chi, ndia ndiaya kaꞌnu va saxinu Ndioxi ndoꞌo ―kachi Jesús xiꞌin na ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ―Na xini soꞌo tuꞌun ña kaꞌan ndo, ra tuꞌun yuꞌu va ke xini soꞌo na. Ra na kundasi ndoꞌo, ra yuꞌu va kuvi ra kundasi na. Ra na kundasi yuꞌu, ra ra tiꞌvi yuꞌu xaa va yu kuvi ra kundasi na ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ta nandiko ndia uni xiko uxi ndaxaa ndia, ra kusii ka vi ini ndia ndixaa ndia nuu Jesús, ndatuꞌun ndia xiꞌin ra kachi ndia saa: ―Tata, xiꞌin kivi kun tava ndi takundiꞌi nuu tachi ndivaꞌa. Ra kandixa va ña kee ña kuaꞌan ña xiꞌin ndiee kun ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Ña ndixa ke, xini va yu ke̱e timiaꞌa ndivi. Ra iin ta ndakava taxa, saa ndakava ri ndia nuu ñuꞌu chi ndikundiëe ri xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ra yuꞌu kuvi ra taxi ndie̱e̱ ndaꞌa ndo, ña kuañu ndo koo xiꞌin tisuꞌma; ra sa tiaa tu ndo nuu ña ndivaꞌa va. Ra ndia nii ña ndöꞌo ndo. ");
INSERT INTO mxv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ra na kusïi ini ndo ña kandixa tachi ndivaꞌa ndoꞌo, chi na kusii ini ndo xaꞌa ña xa ndikaꞌyu kivi ndo nuu tutu Ndioxi ña nduꞌu ndivi va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ra mii hora kan tiaa nii kusii ini Jesús xiꞌin ndiee Tachi Yii Ndioxi, ra ndikaꞌan ra kachi ra saa: ―Ndasakaꞌnu yu yoꞌo, Tata Ndioxi, saa chi yoꞌo kuvi ra xaꞌndia chiñu ndivi ra saa tu ñuꞌu va, saa chi chikaa seꞌe va kun ña vaꞌa yoꞌo nuu na ndichi xiꞌin na kundaa ni ini, ra ndañaꞌa va kun ña nuu na ndaꞌvi, na kundäa ini, na iyoo ta kuꞌva iyoo na kuachi vali, ra saa xa kun, Tata, chi saa kuni mii kun koo va ―*kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ra saa ndikaꞌan ka ra xiꞌin yuvi kan kachi ra saa: ―Tata yu kuvi ra ndataxi takundiꞌi ñaꞌa ndaꞌa yu, ra ndia nii na xïni yo kuvi yuꞌu, ra kuu seꞌe Ndioxi, chi indaa Tata va yu kuvi ra kundaa ini yo kuvi yu, ra ndia nii tu na xïni yo kuvi ra kuu Tata va yu, chi indaa mituꞌun yuꞌu ra kuu seꞌe va ra kuvi ra xini yo kuvi ra, ra yuꞌu va kuvi ra ^ndañaꞌa Tata yu nuu na kuni mii yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ra saa ndikoniꞌi Jesús, ra ndikaꞌan ra xiꞌin takua mii ndia itaꞌan xiꞌin ra, kachi ra saa: ―Vaꞌa ni ^kee na ^xini nuu ña kuu, ña xini ndo yoꞌo vichin; ");
INSERT INTO mxv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ra kaꞌan yu tuꞌun yoꞌo xiꞌin ndo, saa chi kuaꞌa ni na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, xiꞌin na xikuu rey, ra kuni ni na kuni na ña xini ndo yoꞌo vichin, ra ndixïni na ña; ra kuni ni tu na kuni soꞌo na ña xini soꞌo ndo yoꞌo vichin va, ndi su ndixïni soꞌo na ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ra saa ndakundichi iin ra maestro xini ndiayu Ndioxi ra kuyachin ra nuu iin Jesús ra ndikaꞌan ra xiꞌin ra ña kuni ra kotondoso ra ra. Ra kachi ra saa: ―Tata Maestro, ¿ni ke xiniñuꞌu sa yu ña vaꞌa niꞌi yu kutiaku yu xiꞌin Ndioxi ndia ndikaa ndikuꞌun? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Saa ndakuiin Jesús kachi ra saa: ―¿Ni ke kachi ndiayu Ndioxi ña tiaa ra Moisés xinaꞌa? Ra ni ke kachi ña ña kaꞌvi kun ña? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ra saa ndakuiin ra maestro kan kachi ra saa: ―Suꞌva va ke kachi ña: “Na kuꞌvi ini yo kuni yo Ndioxi xiꞌin ndinuni nima yo, xiꞌin takundiꞌi ña tiaku yo, xiꞌin takundiꞌi ndie̱e̱ yo, xiꞌin takundiꞌi ña xini tuni yo; ra ta kuꞌva kuꞌvi ini yo xini yo mii yo, saa na kuꞌvi tu ini yo kuni yo inka na taꞌan va yo”, kachi ña ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Vaꞌa va ndakuiin kun. Ra tu na sa kun ña kaꞌan ña, saa ra niꞌi va kun kutiaku kun xiꞌin Ndioxi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ra ña kuni ra maestro xini ndiayu Ndioxi kan ña ndasa vaꞌa ra mii va ra ke ndindakatuꞌun ra Jesús, kachi ra saa: ―¿Yoo kuvi na taꞌan yo tuvi yoꞌo, Tata? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ra kachi ra saa: ―Saa ndoꞌo iin tiaa ra ke̱e ñuu Jerusalén, ra kuaꞌan ra chi ñuu Jericó. Ra ichi kan ndakoyo ndia kuiꞌna, ra ndakiꞌin ndiꞌi ndia ñaꞌa ra, ra ndia tikoto va ra ndakiꞌin ndia. Ra kani ni ndia ra; ra iin satakueꞌe ndiꞌi ndia ra; ra saloꞌo kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ra saa ndiyaꞌa sana iin sutu kuaꞌan ra ichi kan, ra ta xini ra kanduꞌu ra takueꞌe kan, saa ra iin xiyo xiyo va ndiyaꞌa ra kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ra saa kuu ra ndiyaꞌa tu iin ra ndiso chiñu xiꞌin veꞌe ñuꞌu kaꞌnu va, ra seꞌe xikua ra Leví kuvi ra. Ra ta xini ra kanduꞌu ra takueꞌe kan, ra iin xiyo xiyo ndiyaꞌa tu ra kan va kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ra saa ndiyaꞌa tu iin ra kee ñuu Samaria va kuaꞌan ra ichi kan, ra ta xini ra kanduꞌu ra takueꞌe kan, ra kundaꞌvi ka vi ini ra xini ra ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ra saa kuyachin ra nuu kanduꞌu ra takueꞌe kan, ra xatatan ra ra. Xiꞌin aceite xiꞌin vino, ra saa chikuꞌni ra tikoto nuu takueꞌe. Ra ta ndiꞌi saa sandaa ra ra sata burru sana ra, ra ndakiꞌin ra ra, kuaꞌan ra xiꞌin ra veꞌe tatu nuu kixi yuvi na xika ichi, ra ikan xindiaa ra ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ra ta ndituvi inka kii, ra saa tava ra uvi xuꞌun ña nani denario, ra taxi ra ña ndaꞌa ra xiꞌin veꞌe kan. Ra kuꞌva uvi kii ke chaꞌvi ra tiaa ra xiꞌin veꞌe kan. Ra ndikaꞌan ra xiꞌin ra, kachi ra saa: “Kondiaa loꞌo ra yoꞌo; ra tu na kuniñuꞌu ka kun xuꞌun kun xiꞌin ra, ra ta xa na ndiko yu saa ndachaꞌvi yu ña nuu kun”, kachi ra suꞌva xiꞌin tiaa kan ―*kachi Jesús xiꞌin ra xini ndiayu Ndioxi kan. ");
INSERT INTO mxv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Saa nindakatuꞌun Jesús ra maestro xini ndiayu Ndioxi, kachi ra saa: ―¿Ndia iin ndia uni kan kuvi ndia kuu taꞌan tiaa ra takueꞌe xa ndia kuiꞌna kan tuvi yoꞌo? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Saa ndakuiin ra maestro xini ndiayu Ndioxi kan kachi ra saa: ―Ra kundaꞌvi ini xini ñaꞌa kuvi ra, tuvi yuꞌu ―kachi ra. Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Vaꞌa ni va ndakuiin kun. Kuaꞌan, ra saa ke na sa tu yoꞌo va ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ra saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, ra ndixaa ndia iin ñuu loꞌo, nuu iyoo iin ñaꞌa ña nani Marta ra ndakiꞌin mani ña ndia veꞌe ña. ");
INSERT INTO mxv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ra iyoo iin kuꞌvi ña ña nani María. Ra ta ndixaa Jesús veꞌe na, ra saa ndakunduꞌu ña María xini soꞌo ña ña ndakani ra. ");
INSERT INTO mxv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ndi su ña Marta ra tiaa ni ndiꞌi ini ña chi iyoo ni chiñu nuu ña, ra saa kuyachin ña nuu Jesús, ra ndikaꞌan ña xiꞌin ra, kachi ña saa: ―Tata, ¿a kiꞌin kun kuenda? Ra na kaꞌan kun loꞌo xiꞌin ña María, kuꞌvi yu, ra na chindiee taꞌan ña xiꞌin yu. Saa chi ndakoò ndiꞌi va ña chiñu ndaꞌa yu ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ña: ―Marta, Marta, ña ndixa ke ndiee ni ndiꞌi ini va kun, chi iyoo ni chiñu nuu kun ña sandiꞌi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ndi su iyoo va iin chiñu ña xiniñuꞌu vaꞌa ka, ra ña María ra chiñu vaꞌa va ke ndikaxin ña, chi nduꞌu ña xini soꞌo ña. Ra ndia nii na kindiäa ña yoꞌo ndaꞌa ña ―kachi ra xiꞌin ña Marta. ");
INSERT INTO mxv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saa kuu iin kii ke̱e Jesús kuaꞌan ra kaꞌan ra xiꞌin Ndioxi. Ra ta ndiꞌi ndikaꞌan ra xiꞌin Ndioxi, ra saa ndikaꞌan iin ra itaꞌan xiꞌin ra kachi ra saa xiꞌin ra: ―Tata, sa ña mani sañaꞌa kun nduꞌu kaꞌan ndi xiꞌin Ndioxi, ta xa ra Juan, ra sakuchi yuvi, ña sañaꞌa ra ndia xitaꞌan xiꞌin ra ña kaꞌan ndia xiꞌin Ndioxi ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Ta kaꞌan ndo xiꞌin Ndioxi, ra suꞌva ke na kachi ndo xiꞌin ra: Tata ndi, ra iyoo ndivi, yii ni na koo kivi kun. Ra na kixi kun kaꞌndia kun chiñu nuu ña yuuvi yoꞌo. Ra ta xa kun ndivi ke na sa kun nuu ñuꞌu yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ra iin takundiꞌi kii na taxi kun ña xiniñuꞌu nuu ndi kuxi ndi; ra na kumäni ña. ");
INSERT INTO mxv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ra na sakaꞌnu ini kun xaꞌa kuachi ndi, ta kuꞌva ^xa mii ndi ña ^xa kaꞌnu ini ndi xaꞌa kuachi yuvi na ^xa ña väꞌa xiꞌin ndi. Ra täxi kun koyo ndi ndaꞌa ña väꞌa; chi na ndakiꞌin va kun nduꞌu ndaꞌa ña, kachi ndo xiꞌin Ndioxi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ra saa ndikaꞌan ka ra xiꞌin ndia kachi ra saa: ―Tu ndia iin ndo ra iyoo iin ra itaꞌan xiꞌin ndo, na kachi yo. Ra na kee ndo kuꞌun ndo veꞌe ra iin sava ñuu. Ra kaꞌan ndo xiꞌin ra, kachi ndo saa: “Ñani, na chindiee kun loꞌo uni xita yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Saa chi iin ra itaꞌan xiꞌin yu sakan xaa veꞌe yu, ra köo ña taxi yu kuxi ra”, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ra saa ndakuiin ra itaꞌan xiꞌin ndo kan, kachi ra saa: “Sandïꞌi kun yuꞌu ñani, chi xa ndasi tuun va yu yeꞌe. Ra xa ra kixi va kuvi yu xiꞌin seꞌe vali yu, ra küvi ndakoo yu taxi yu ña ndaꞌa kun”, na kachi ra xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ra tu na ndakoo ra, ra süvi xaꞌa ña itaꞌan ra xiꞌin ndo ke ndakoo ra taxi ra ña ndaꞌa ndo. Chi xaꞌa ña ndiee ni sandiꞌi ndo ini ra, ña kani ndaꞌa ndo yeꞌe va ra ke, ndakoo ra taxi ra ña xiniñuꞌu nuu ndo ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ña kan ke kaꞌan yu xiꞌin ndo vichin: Ra na nduku ndo ña kumani nuu ndo nuu Ndioxi, ra taxi va ra ña ndaꞌa ndo; ra na nanduku ndo ña xiniñuꞌu nuu ndo, ra chindiee taꞌan va ra xiꞌin ndo ña ndaniꞌi ndo ña; ra na kani ndaꞌa ndo yeꞌe, ra ndakuiña va ra yeꞌe nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi na nduku ñaꞌa ña kumani nuu na nuu Ndioxi, ra niꞌi va na ña; ra na nanduku ña, ra ndaniꞌi va na ña. Ra na kaꞌan xiꞌin ra, ra ndakuiña va ra yeꞌe nuu na. ");
INSERT INTO mxv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ra tu ndia ndoꞌo na iyoo seꞌe, ra na nduku na xita nuu ndo kuxi na, ¿ra ama taxi ndo yuu ndaꞌa na kaxi na? Ra tu nduku tu na tiaka nuu ndo kaxi na, ¿ra ama taxi tu ndo koo ndaꞌa na kaxi na? ");
INSERT INTO mxv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ra tu ndivi tu na nduku na nuu ndo kaxi na, ¿ra ama taxi tu ndo tisuꞌma ndaꞌa na kaxi na, su täxi ndo ri? ");
INSERT INTO mxv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Saa chi ndoꞌo, ra vaꞌa ni yuvi kuachi kuvi va ndo, ndi su xini va ndo taxi ndo ña vaꞌa ndaꞌa seꞌe ndo. ¡Ra ña kuu Tata yo Ndioxi, ra vaꞌa, ra köo ndia nii kuachi, ña kan ke kundaa kaxi va ini yo ña taxi va ra ña vaꞌa ni ña kuu Tachi Yii ra ndaꞌa takundiꞌi yuvi na nduku ña nuu ra! ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ra saa tava Jesús tachi ndivaꞌa ini iin tiaa ra miꞌmi. Ra ta kita suꞌva ña ndivaꞌa kan, saa ra ndikun ndakaꞌan va ra, ra ndakanda ka vi ini yuvi na xini ña nduvaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ra saa ndikaꞌan sava na kachi na saa: ―Ndie̱e̱ ri Beelzebú, mii ri kuchee vaꞌa nuu takundiꞌi ña ndivaꞌa va ke iyoo xiꞌin ra, ña kan ke vaꞌa tava ra tachi ndivaꞌa. ―^kachi na xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ra sava tu na kaꞌan xiꞌin Jesús, ña na sa ra iin ña ndichi nuu ndivi va kuni na, ña ixtondoso na ra, ra a ndixa xiꞌin ndie̱e̱ Ndioxi ke tava ra tachi ndivaꞌa káꞌán na, chi ndikandïxa na ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ra xa kundaa kuaꞌa va ini Jesús ña ndakani ini na. Ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Iin ñuu nuu kataꞌan xiꞌin taꞌan mii yuvi, ra kuchüun vi na ña koo na, chi ndiꞌi va xaꞌa na. Ra saa tu iin veꞌe nuu kataꞌan xiꞌin taꞌan mii va yuvi, chi kuchüun na koo vi na, chi ndiꞌi va xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ra kuꞌva saa ke iyoo tu ri ndivaꞌa va, saa chi tu na ndukuiin ri, ra kanitaꞌan ri xiꞌin taꞌan mii ri. ¿Ra a kuchuun ri koo ri, tuvi ndo? Ra suꞌva ke kachi yu xiꞌin ndo, saa chi kaꞌan ndo ña tava yu tachi ndivaꞌa xiꞌin ndiee ri ndivaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ra tu ndixa xiꞌin ndie̱e̱ kiti ñaꞌa ke tava yu tachi ndivaꞌa, na kachi yo, saa ra, ¿yoo ndiee ke tava tu na itaꞌan xiꞌin ndoꞌo tachi ndivaꞌa, tuvi ndo? Ra na kundaa ini ndo chi süvi saa iyoo ña. Ra mii na ñaa na sayukun kuachi xiꞌin va ndo, saa chi na yaꞌa xini va kuvi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saa chi yuꞌu, ra xiꞌin ndie̱e̱ Ndioxi va ke tava yu tachi ndivaꞌa. Ra na kundaa ini ndo chi xa xaa va Ndioxi ña kaꞌndia ra chiñu nuu ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Kiti ñaꞌa, ra ta iyoo iin tiaa ra ndaku ni, saa va ke iyoo ri. Saa chi tiaa ra ndaku ni, ra iin suꞌva va iyoo ra xiꞌin ichi ña täxi ra kiꞌvi ra kuiꞌna sakuiꞌna ra veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ndi su tu na kixi inka ra ndaku vaꞌa ka nuu ra, ra ra ndaku kan kuvi ra sa tiaa va, ra kindiaa ndiꞌi va ra ñaꞌa ra. Ra ndataꞌvi ra ña xiꞌin na itaꞌan xiꞌin va ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Na xïin kuꞌun ndie̱e̱ yu, ra kuachi va ke iyoo na xiꞌin yu. Ra na xïin sakee xiꞌin yu, ra na kan kuvi na sandiꞌi xaꞌa chiñu va yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Ta xa kee tachi ndivaꞌa ini iin yuvi ra suꞌva va ke xa ña: ^kee ña ra ndakiꞌin ña kuaꞌan ña iinii kuvi iku yuu, chi nuu köo ndia nii ñaꞌa, nuu ichi ni, ña xika nduku ña nuu koo ña ndakindiee ña, ndi su ndanïꞌi ka ña nuu koo ña. ");
INSERT INTO mxv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Saa ra kaꞌan ña xiꞌin mii ña kachi ña saa: “Vaꞌa ka va na nandiko yo veꞌe chi nuu kee yo”, kachi ña. Ra saa te nandiko ña ndaxaa ña nuu ndixiyo ña, ra ndia nii ka ñaꞌa köo veꞌe kan, ra vaꞌa ka vi ndatiꞌvi na, ra vii ka vi nduu veꞌe kan xa na. ");
INSERT INTO mxv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ra saa ^ndakiꞌin tuku tachi ndivaꞌa kan kuaꞌan ña, ra ^nanduku ña inka uxa nuu tachi ndivaꞌa, ña kini ni ka nuu mii ña ^xaa xiꞌin ña, ra saa ^nandee takundiꞌi ña ini veꞌe kan, ña koo ña. Saa ra yuvi na ndoꞌo saa ña xindikaa tachi ndivaꞌa ini na, ra na ndiee ka ndasa va kuvi na, nuu ña ndixiyo na ta yachi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ra ta sakan sandiꞌi Jesús ndikaꞌan ra xiꞌin na, saa ra tuꞌva ndikaꞌan va iin ñaꞌa ña ndikaa tiañu yuvi kan kachi ña saa xiꞌin ra: ―Vaꞌa ni kee ñaꞌa ña sakaku yoꞌo, ra sakuaꞌnu ña yoꞌo ―kachi ña xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ra saa ndakuiin Jesús kachi ra saa: ―Vaꞌa ni ka va kee yuvi na xini soꞌo tuꞌun Ndioxi, ra kandixa na ña kaꞌan ra xiꞌin na ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ra saa kuu ra kuaꞌa ka vi yuvi xaꞌa ^ndakutaꞌan nuu iin Jesús, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¡Ndivaꞌa ni ini yuvi na ndee tiempo vichin! Chi nduku na seña nuu yu, ña kuni na kotondoso na yuꞌu. Ndi su ndia nii ka seña sä yu kuni na. Chi ña kuni na kuvi taꞌan ña ndoꞌo ra Jonás xinaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi ta kuꞌva ndoꞌo ra Jonás, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ña ndixikuu ra iin seña nuu yuvi väꞌa, na ñuu Nínive, ra saa ke ndoꞌo tu yuꞌu, ra xaa yoꞌo va, kuni yuvi na ndee tiempo vichin. ");
INSERT INTO mxv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ra kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo, saa ke ndakundichi tu ña reina ña kee chi nínu̱ nuu kaꞌan na kuu sur, ña taxi ña kuachi xaꞌa ndo. Chi xïin ndo kandixa ndo ña kaꞌan yu. Saa chi ña reina kan, ra kani ni va ke̱e ña kixi ña xini soꞌo ña tuꞌun ndichi ña sakuaꞌa ra rey Salomón na xinaꞌa. Ra na kundaa ini ndo, chi kaꞌnu ni ka va ra iin yoꞌo vichin nuu ra rey Salomón, ra xïin ndo kuni soꞌo ndo ña kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ra saa ke sa tu na ñuu Nínive va, chi taxi tu na kan va kuachi xaꞌa ndoꞌo na ndee tiempo vichin, te xa na xaa kii ña sandaku Ndioxi kuachi na yuuvi yoꞌo. Chi na ñuu Nínive, ra nandiko va ini na nuu Ndioxi ta xini soꞌo na, ña ndikaꞌan ndoso ra Jonás, ra na kundaa ini ndo, chi kaꞌnu ni ka va ra iin yoꞌo vichin nuu ra Jonás, ra xïin ndo nandiko ini ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Yuvi na ndatuun ñuꞌu, ra chikäa seꞌe na ña, ra nii kuëe chindiee tu na iin xikoꞌo va nuu ña. Chi nuu sukun va chinduꞌu na ña, ra saa ke vaꞌa yeꞌe nuu takundiꞌi na kuaꞌan kiꞌvi veꞌe. ");
INSERT INTO mxv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ra saa ke iyoo tu nduchi nuu va yo, saa chi ta iyoo ñuꞌu ña tuun, va ke iyoo ña. Ra tu ña vaꞌa kuvi ña, saa ra yeꞌe ndiꞌi tu iki kuñu va yo, ra tu ña väꞌa va kuvi tu nduchi nuu yo, saa ra nuu ñaa va iyoo iki kuñu yo. ");
INSERT INTO mxv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ña kan ke na kiꞌin ni ndo kuenda xiꞌin mii ndo xiꞌin ñuꞌu ña yeꞌe nuu ndo; chi koto ndaꞌva ña, ra kuñaa ndiꞌi nuu iki kuñu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Saa chi tu iinii saa iki kuñu ndo ke yeꞌe, ra ndia nii loꞌo ka ña ñaa köo xiꞌin ña, ra saa ke vaꞌa kuni kaxi ndo takundiꞌi va ñaꞌa, ra ta kuꞌva iyoo ñuꞌu ña tuun veꞌe, saa ke na koo ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ra saa te sandiꞌi Jesús ndikaꞌan ra, ra saa ndikaꞌan iin ra fariseo xiꞌin ra ña na kuꞌun ra kuxi ra xiꞌin ra veꞌe ra. Ra saa ndixaa Jesús ndikiꞌvi ra veꞌe ra, ra ndakunduꞌu ra nuu mesa xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ra nindäꞌa vi Jesús ra ndakunduꞌu ra. Saa ra ndakanda ka vi ini ra fariseo kan xini ra ra ña nindäꞌa ra, chi ña yunaꞌa ndia fariseo kan, ra xiꞌna ka va ndaꞌa ndia a saa xixi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Saa ra kundaa va ini Jesús ña ^ndakani ini ra fariseo kan, ra saa ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Ndoꞌo, ndia fariseo, ra ta iyoo koꞌo xiꞌin vaso ña ndakatia na sata, ra chi ini tu ña yakua va, saa iyoo ndo. Saa chi sata va ndo ke savi ni ñaꞌa, ndi su nima ndo, ra iin chitu ndaa va ña kuiꞌna, xiꞌin ña kini. ");
INSERT INTO mxv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ra Kiꞌvi ni ndo!, saa chi, ¿a kundäa ini ndo Ndioxi va kuvi ra xavaꞌa iki kuñu ndo, ra xavaꞌa tu ra nima va ndo? ");
INSERT INTO mxv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ña kan ke tu ndinuni ni nima ndo na taxi ndo ñaꞌa ndaꞌa na ndaꞌvi, ra saa ke kindoo vaꞌa ndo nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Ndi su, ¡Ndaꞌvi ni ndoꞌo, ndia fariseo!, chi xuꞌun loꞌo ña kiꞌin ndo xaꞌa iku menta, xiꞌin takuu ruda, xiꞌin ndia ndia ka iku, va ke chaꞌvi ndo nuu. Ndi su ndïꞌi vi ini ndo ña sa ndo ña ndaku xiꞌin yuvi taꞌan ndo; ra ni küꞌvi tu ini ndo xini ndo Ndioxi va. Ra ña xiniñuꞌu sa ndo ke na kuꞌvi ini ndo kuni ndo Ndioxi, ra nii na näa tu ini ndo ña chaꞌvi ndo nuu ñaꞌa ña kuu mii va ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ra ndaꞌvi ni ndoꞌo, ndia fariseo!, saa chi ta kuaꞌan ndo veꞌe ñuꞌu ra kuni ni ndo kundee ndo tiayu na kunaꞌnu; ra saa tu ta xika ndo nuu yaꞌvi va, saa chi kuni ni ndo ña na satoꞌo yuvi ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ra ndaꞌvi ni ndoꞌo, ndia fariseo!, saa chi ta iyoo yavi nuu ñuꞌu ndii ña kuëe ñaꞌa tuni ka, ra yaꞌa yuvi xañu na ña kuaꞌan va na, chi kundäa ini na, ndi su xa kuyakua va na, ra saa va ke iyoo ndo ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ra saa ndakuiin iin ra maestro sañaꞌa ndiayu Ndioxi, kachi ra saa: ―Tata Maestro, ña kachi kun saa, ra ndia nduꞌu va kuvi ndi yaꞌa yuꞌu kun xiꞌin ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―¡Saa iin tu ndoꞌo, ndia sañaꞌa ndiayu Ndioxi va! Saa chi sakuiso ndo yuvi iin ñaꞌa ña kundiëe na xiꞌin; ra mii tu ndo, ra ndia nii loꞌo ndïꞌi ini ndo kuiso ndo ña. ");
INSERT INTO mxv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ra ndaꞌvi ni ndo! Saa chi ndasavaꞌa ndo kaka na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ra mii va tu na xii xikua ndo kuvi na xaꞌni ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ra ña ndasavaꞌa ndo kaka na vichin, ra kuni kachi ña saa, ña iin yuꞌu kuvi va ndo xiꞌin na xii xikua ndo; chi na kan kuvi na xaꞌni ñaꞌa, ra ndoꞌo tu ndasavaꞌa kaka va na. ");
INSERT INTO mxv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ña kan ke ndichi ni ndikaꞌan Ndioxi kachi ra saa: “Tiꞌvi yu na kuꞌun na kaꞌan ndoso na tuꞌun yu, ra tiꞌvi tu yu na xika chiñu nuu va yu kuꞌun na nuu na ñuu Israel, ra sava na kaꞌni na; ra sava tu na taxi va na”, kachi ra xaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ra ndoꞌo, na ndee vichin kuvi na nduku Ndioxi kuenda nuu xaꞌa nii tu ndia ndikaꞌan tuꞌun yuꞌu Ndioxi te yachi, te sakan ndixkunduꞌu ña yuuvi, iin saa ndia vichin va. ");
INSERT INTO mxv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ra ndia xaꞌa nii ra Abel, iin saa ndia xaꞌa nii ra Zacarías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ra xaꞌni na nuu altar yii ini veꞌe ñuꞌu kaꞌnu, xiꞌin nuu xaꞌni na kiti ri soko na nuu Ndioxi. Ra xaꞌa ndia yoꞌo ke kaꞌan Ndioxi kuachi nuu ndoꞌo, na ndee tiempo vichin ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―¡Ndaꞌvi ni ndoꞌo ndia sañaꞌa ndiayu Ndioxi! Saa chi xa iyoo va ña xiña ña ndichi nuu ndo, ña vaꞌa na kiꞌvi ndo yeꞌe Ndioxi, ndi su xïin ndo kiꞌvi ndo, ra nii täxi tu ndo kiꞌvi inka yuvi, na kuni kiꞌvi va ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ra te sandiꞌi Jesús ndikaꞌan ra tuꞌun yoꞌo, saa ra ndisaa ka vi ini ndia fariseo xiꞌin ndia maestro ndia sañaꞌa ndiayu Ndioxi xini ndia ra. Ra saa xaꞌa ndia keꞌe taꞌan ndia xiꞌin ra, ña ndindakatuꞌun ni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Saa chi kuni ndia ña na kaꞌan ra iin tuꞌun kiꞌvi te ndatuꞌun ra. Ra saa ke kuchuun ndia taxi ndia kuachi xaꞌa ra nuu na chiñu. ");
INSERT INTO mxv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ra sakan saa kuu ndia, ra saa kuaꞌa ka vi mil yuvi ndakaya, ra iin ndiakua chindaꞌni taꞌan na. Ra saa xaꞌa Jesús kaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Kuenda ni koo ndo xiꞌin ndia fariseo. Saa chi ta iyoo ixan iyá ña kuu ndavi ña kee̱ xiꞌin xita vaꞌa, va ke iyoo ndia. Saa chi kaꞌan ndia xaꞌa ña vaꞌa, ra xa tu ndia ña väꞌa va. ");
INSERT INTO mxv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ndi su vaxi kii ra ndatuvi ndiꞌi va xaꞌa ña ^xa seꞌe ndia vichin. Saa chi takundiꞌi ña iyoo seꞌe nuu yuvi vichin, ra ndatuvì ndiꞌi va xaꞌa ña vaxi kii. ");
INSERT INTO mxv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ra takundiꞌi ña ndatuꞌun seꞌe ndo chi nuu ñaa, ra ndita tuvi va ña kuni soꞌo yuvi; ra ña ndatuꞌun seꞌe ndo chi ini veꞌe, ña ndasi tuun, ra vaxi kii ra kundaa ndiꞌi va ini na xaꞌa ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ndia: ―Ndoꞌo, ndia itaꞌan xiꞌin yu, kuvi ndia kaꞌan yu xiꞌin, ña na kuayüꞌvi ndo nuu na xaꞌni ndii. Chi takua iki kuñu va ke xaꞌni na, ndi su kuchüun vi na sandiꞌi na xaꞌa ña ku nima yuvi. ");
INSERT INTO mxv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ra na kaꞌan yu xiꞌin ndo ra kundaa ini ndo yoo kuvi na xiniñuꞌu yuꞌvi ndo kuni ndo: ra ra yuꞌvi ndo kuni ndo kuvi Ndioxi, saa chi ra kan kuvi ra iyoo ndiayu ndaꞌa ña kindiaa ra ña tiaku ndo, ra te ndiꞌi, ra iyoo tu ndiayu ndaꞌa ra ña chikaa ra nima ndo ndiaya va. Ra ra kan va kuvi ra na yuꞌvi ndo kuni ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ra xa kundaa va ini ndo, chi saa vali, ra nuu ni va ixiko na ri; chi uꞌun vi ri uvi xuꞌun vali. Ndi su Ndioxi ra näa vi ini ra xaꞌa ri. Chi ra kan kuvi ra kiꞌin kuenda xiꞌin va ri. ");
INSERT INTO mxv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ndi su ndiaa yaꞌvi ni ka va ndoꞌo nuu Ndioxi. Chi ndia ixi xini va ndo ke ndiaꞌvi ra. Ña kan ke na kuayüꞌvi ndo. Chi mii Ndioxi va kuvi ra ndiaa ndoꞌo. Saa chi ndiaa yaꞌvi ni ka va ndoꞌo nuu saa vali ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ndia: ―Tu ndia na ndakuiin ña ndikun na yuꞌu nuu yuvi yoꞌo, ra saa tu yuꞌu, ra xaa yoꞌo va, chi ndakuiin tu yuꞌu va xaꞌa na, nuu na tatun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ndi su, na tiseꞌe tuꞌun xaꞌa yu nuu yuvi yoꞌo, ra saa sa tu yuꞌu va, chi tiseꞌe tuꞌun tu yuꞌu va xaꞌa na, nuu na tatun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ra tu ndia na kañaꞌa xaꞌa yuꞌu, ra xaa yoꞌo, ra sakaꞌnu va ini Ndioxi xaꞌa na. Ra na kañaꞌa xaꞌa Tachi Yii Ndioxi, ra köo kaꞌnu vi ini Ndioxi xaꞌa na kan ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Saa ndikaꞌan ka ra kachi ra saa: ―Tu ndia yuvi na taxi kuachi xaꞌa ndo nuu na chiñu a nuu na kunaꞌnu nuu veꞌe ñuꞌu na judío, ra ndïꞌi ini ndo xaꞌa tuꞌun ña ndakuiin ndo yuꞌu na. ");
INSERT INTO mxv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chi mii va Tachi Yii Ndioxi taxi tuꞌun ña kaꞌan ndo xiꞌin na ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ra saa tuꞌva ndikaꞌan va iin tiaa ra ndikaa maꞌñu yuvi kan xiꞌin Jesús kachi ra saa: ―Tata Maestro, kaꞌan xiꞌin ñani yu ña na ndataꞌvi ra ñaꞌa iva ndi xiꞌin yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Yoꞌo, ra kaꞌan ñaa, ¿nichuun kuni kun ndataꞌvi yu ñaꞌa xiꞌin ndo? ¿A yuꞌu va kuvi ra ndataꞌvi ñaꞌa, tuvi kun? Süvi ra chiñu kuvi yu ña kan ke ndataꞌvi yu ñaꞌa xiꞌin ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ra saa xitoꞌni Jesús nuu yuvi na ndee kan, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Kuenda ni koo ndo, ra kotöo ndo koo kuaꞌa ni ñaꞌa ndo. Chi vaꞌa ni na koo kuaꞌa ni va ñaꞌa ndo, ndi su süvi ña kan kuvi ña taxi ña tiaku ndo nuu ña yuuvi yoꞌo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Saa ndikaꞌan ra iin tuꞌun ndichi xiꞌin na kachi ra saa: ―Saa ndoꞌo iin ra kuika, ra vaꞌa ka vi ke̱e ra xiꞌin ñaꞌa ña chiꞌi ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ra saa xaꞌa ra ndakani ini ra, kaꞌan ra saa: “¿Ni ke sa yo? ¿Ra ndia mii ke chuvaꞌa yo ñaꞌa yo?”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Saa ndikaꞌan ra xiꞌin mii ra kachi ra saa: “Xa xini va yu ni ke sa yu: kani ndiꞌi yu yaka vali, ra savaꞌa yu yaka naꞌnu vaꞌa. Ra ikan chuvaꞌa ndiꞌi yu nuni yu xiꞌin takundiꞌi ñaꞌa ña kuu mii yu. ");
INSERT INTO mxv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ra ta ndiꞌi, ra kaꞌan yu xiꞌin mii yu kachi yu saa: Kuaꞌa ni ñaꞌa yu iyoo, ra kuaꞌa ni kuiya kuxi yu ña. Ra sachïñu ka yu, ra na ndakindiee̱ yu, ra na kuxi yu, ra na koꞌo yu, na kusii ini yu, chi iyoo kuaꞌa ni ñaꞌa yu, kachi yo xiꞌin mii yo”, kaꞌan ra kuika kan suꞌva. ");
INSERT INTO mxv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ndi su Ndioxi ra suꞌva va tu kachi ra xiꞌin ra: “Ra kiꞌvi kuvi yoꞌo, chi ñuu vichin va kuvi kun. Ra takundiꞌi ñaꞌa, ña chuvaꞌa kun, ra inka va na kuxi ña”, kachi Ndioxi xiꞌin ra kuika kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ra saa ndikaꞌan Jesús xiꞌin yuvi, na xini soꞌo tuꞌun ndichi kan kachi ra saa: ―Ta ndoꞌo ra kuika yoꞌo, saa ke ndoꞌo yuvi, na chuvaꞌa ni ñaꞌa nuu ña yuuvi yoꞌo. Chi yoꞌo va ke kuika ni na, ndi su nuu Ndioxi ra na ndaꞌvi va kuvi na ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ra ta ndiꞌi, saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ndïꞌi ini ndo xaꞌa ñaꞌa kaxi ndo ña vaꞌa kutiaku ndo, nii xaꞌa ña kuxi ndo, ra nii xaꞌa tikoto ña kundixi ndo na kundïꞌi ini ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Saa chi ña ndiaa yaꞌvi ni ka va kuvi ña tiaku ndo nuu ña xixi ndo; ra ndiaa yaꞌvi ni ka va tu iki kuñu ndo nuu tikoto ña ndixi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ra na kotoꞌni ndo ta kuꞌva tiaku tikaka, chi nii chïꞌi ri, ra nii sakëe ri, ra nii yaka nuu kuꞌun ñaꞌa ri köo vi. Ra nani saa xixi va ri chi Ndioxi va kuvi ra kiꞌin kuenda xiꞌin ri. Ra saa sa tu ra xiꞌin ndoꞌo va, saa chi ndiaa yaꞌvi ni ka va ndoꞌo nuu saa vali. ");
INSERT INTO mxv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ra nii na kundiꞌi ni va ini ndo, ndi su köo ñaꞌa niꞌi vi ndo, saa chi ndia nii hora loꞌo ka vi kuchüun ndo kutiaku ndo tu xa na xaa kii ña kuvi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ra tu kuchüun ndo sa ndo chiñu vali, ¿ra nichuun ke ndiꞌi ni ini ndo xaꞌa inka ñaꞌa? ");
INSERT INTO mxv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ra na koto ndo ndia kuꞌva ke xaꞌnu ita, chi nii xachïñu ña, ra nii tikoto ña xaväꞌa ña. Ndi su nduvi ni va ña, chi Ndioxi va kuvi ra kuni ña koo ña saa. Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi ra rey Salomón, ra nduvi ni va tikoto xindixi ra. Ndi su yaꞌa ni ka va nduvi ita nuu tikoto ña xindixi ra kan. ");
INSERT INTO mxv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chi Ndioxi va kuvi ra sanana ita, ra nduvi ni ña; ndi su loꞌo ni va kii iyoo ña, saa ra ndachi va ña, ra kuaꞌan yuvi ndakaya na ña xaꞌmi na nuꞌu va. Ndi su ndiaa yaꞌvi ni ka va ndoꞌo nuu ita. ¿Ra nichuun loꞌo ni kandixa ndo Ndioxi? ");
INSERT INTO mxv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ra ña kan ke kaꞌan yu xiꞌin ndo, ña na kundïꞌi ni ini ndo xaꞌa ña kuxi ndo, xiꞌin xaꞌa ña kutiaku ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Saa chi yuvi na xïni Ndioxi va kuvi na ndiꞌi ni ini xaꞌa ña kan. Ndi su ndoꞌo, na kuu seꞌe Ndioxi, ra xa xini mii va ra ni ñaꞌa ke kumani nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ña kan ke na ndakundiee ndo nanduku ndo nuu xaꞌndia Ndioxi chiñu va, ra saa ke taxi ndiꞌi ra ñaꞌa ña kumani nuu ndo ndaꞌa ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ra saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Kuayüꞌvi ndoꞌo, ndia ndikun yuꞌu, saa chi ta iyoo iin tiꞌvi ndikachi vali sana va yu, ke iyoo ndo. Ra kusii ni va ini Ndioxi taxi ra koo ndo xiꞌin ra nuu xaꞌndia ra chiñu. ");
INSERT INTO mxv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ra na xiko ndo ñaꞌa ña kuu mii ndo, ra saa ke kuchuun ndo chindiee taꞌan ndo xiꞌin na xamani nuu. Ra na ndiꞌi ini ndo ña chuvaꞌa ndo ñaꞌa ndo ini ñaꞌa ña nduꞌu ndivi, ña kuëe ndiꞌi xaꞌa, nuu koo ña kuika ña kuëe ndiꞌi xaꞌa, ra nii ra kuiꞌna kuchüun sakuiꞌna ña, ra nii tikixin sandïꞌi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chi nuu chuvaꞌa ndo ñaꞌa ndo, ra ikan ke koo tu nima va ndo xiꞌin ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ra saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ra iin ndisaa kii na koo nduvi ndo, ra xa na kundixi vii va ndo tikoto ndo, ra xa koo nduvi tu ndo xiꞌin ñuꞌu ña kutuun nuu va ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ra ta iyoo iin tiaa ra xachiñu tatu, ra xa iyoo nduvi ndakuña yeꞌe nuu xitoꞌo, va ke na koo ndo. Saa chi tiaa ra xachiñu tatu kan, ra xa iyoo nduvi va ra ña ndakuña ra yeꞌe nuu ixtoꞌo ra, ta xa na ndaxaa ra kan ña kuaꞌan ra viko tandaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ra vaꞌa ni va kee na xachiñu tatu na xa iyoo nduvi, ña ndiatu na ra kuu xitoꞌo na ta xa na xaa ra ndakutaꞌan ra xiꞌin na; ra ña ndaa kaꞌan yu xiꞌin ndo, chi te xa na kuni ra ña xa iyoo nduvi na ña ndiatun na ra, saa ra kusii ni ini ra xiꞌin na. Ra ndachindee ra na nuu mesa, ra mii va ra chuꞌun ndaꞌa ña kuxi na. ");
INSERT INTO mxv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ra vaꞌa ni va kee na xachiñu tatu na xa iyoo nduvi ta xa na xaa xitoꞌo na ndakutaꞌan ra xiꞌin na, ra nii sava ñuu ke na xaa va ra, ra a ta xa kuaꞌan tuvi va tu na xaa ra, ndi su ndiatu va na ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ra saa sa tu iin tiaa ra iyoo veꞌe va, tu na kundaa ini ra ndia mii hora ke kiꞌvi ra kuiꞌna sakuiꞌna ra ñaꞌa ña iyoo veꞌe ra, saa ra kunduꞌu tuꞌva va ra kondiaa ñaꞌa ra; ra täxi ra kiꞌvi ra kuiꞌna veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ra saa ke na sa tu ndoꞌo va, ña na koo nduvi ndo kundiatun ndo yuꞌu, ra xaa yoꞌo vichin te xa na ndiko yu, chi te kuëe ndiatu va ndo ke ndiko yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Saa ndikaꞌan ra Pedro xiꞌin Jesús, kachi ra saa: ―Tata, ¿a takua nduꞌu va kuvi ndia ndikaꞌan kun xiꞌin? ¿A ndikaꞌan kun xiꞌin takundiꞌi va na? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Saa ndikaꞌan Jesús kachi ra saa: ―Na kaꞌan yu xiꞌin ndo ra kundaa ini ndo ndia kuꞌva ke xa iin ra muso ra kama, ra ndichi, ra taxi xitoꞌo ra ña kuiso ra chiñu xiꞌin veꞌe ra ña kiꞌin ra kuenda xiꞌin na xachiñu tatu nuu xitoꞌo ra, ra taxi ra kuxi na te xa xiniñuꞌu kuxi na. ");
INSERT INTO mxv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ra vaꞌa ni kee ra muso ra ^xa chiñu ña xaꞌndia xitoꞌo ra nuu ra, ra te xa na nandiko xitoꞌo ra ra ndaniꞌi ra ra ña ^xa ra chiñu nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ra ña ndixa kaꞌan yu xiꞌin ndo, chi ra xitoꞌo ra, ra taxi va ra ndiayu ndaꞌa ra kuiso chiñu ra xiꞌin takundiꞌi ñaꞌa ña iyoo nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ndi su tu na xaꞌa ra moso kan ndakani ini ra, kaꞌan ra saa: “Ndïko yachi vi xitoꞌo yo”, na kaꞌan ra. Ra saa xaꞌa ra kuxi ra, ra koꞌo ra ña xini ra, ra xaꞌa ra sa ndivaꞌa ra xiꞌin na xachiñu tatu nuu ra xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ra iin ta nanaa ini ra, saa ra ndandiko va xitoꞌo ra, ra sandoꞌo ni ra ra. Ra chikaa ra ra kuꞌun ra nuu ^ñuꞌu na xïin kandixa. ");
INSERT INTO mxv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ra ra muso, ra kundaa ini ndia chiñu ke kuni xitoꞌo ra sa ra, ra xïin ra sa nduvi ra ña sa ra ña, ra ndoꞌo ni ra sa xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ra ra muso ra kundäa tu ini xaꞌa chiñu ña kuni xitoꞌo ra sa ra, ra ^xa ra iin chiñu kiꞌvi, ra loꞌo va ndoꞌo ra kan sa xitoꞌo ra. Ra na taxi Ndioxi kuaꞌa ni ña vaꞌa ndaꞌa, ra xiniñuꞌu ndataxi va na kuenda ndaꞌa Ndioxi xaꞌa ña, saa chi xaꞌa ña kuaꞌa ni ña taxi Ndioxi ndaꞌa na, ra xiniñuꞌu na kuniñuꞌu na ña vaꞌa kan ña chindiee taꞌan na xiꞌin inka yuvi va, saa chi saa ke kuni mii Ndioxi va ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Ña xaa yu ña yuuvi yoꞌo, ra ñùꞌù va ke xaa yu chikaa yu. Ra kuni ni yu ña xa na koko va ña. ");
INSERT INTO mxv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ra xiꞌna xiniñuꞌu tixuꞌvi ni yu, ra ndoꞌo ni ini yu, ra kusuchi ni ini yu ndia te na xinu nuu ña. ");
INSERT INTO mxv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A ra vaxi ndachindee vaꞌa va kuvi yu ndoꞌo tuvi ndo? Ra na kundaa ini ndo chi ra ndataꞌvi va kuvi yu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Saa chi kii vichin, iin saa ndia kii ña vaxi, ra tu uꞌun kuvi yuvi iin veꞌe, ra uni kuu na kanitaꞌan xiꞌin uvi na, a uvi kuu tu na ña kanitaꞌan na xiꞌin uni va na. ");
INSERT INTO mxv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ra tiaa, ra iyoo seꞌe tiaa, ra kanitaꞌan ra xiꞌin seꞌe tiaa va ra, ra tiaa, ra iyoo iva, ra kanitaꞌan ra xiꞌin iva va ra, ra ñaꞌa, ña iyoo seꞌe siꞌi, ra kanitaꞌan ña xiꞌin seꞌe siꞌi va ña; ra ñaꞌa, ña iyoo siꞌi, ra kanitaꞌan ña xiꞌin siꞌi va ña; ra ña iyoo xanu, ra kanitaꞌan ña xiꞌin xanu va ña, ra ña ixanu, kanitaꞌan tu xiꞌin siso va ña ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ra saa ndikaꞌan ka Jesús xiꞌin takundiꞌi na ndee kan, kachi ra saa: ―Ndoꞌo, ra ta xini ndo vaxi viko chi nuu kanata ñuꞌu, ra kaꞌan ndo kuun savi vichin, kachi ndo. Ra saa kuun ndixa va ra. ");
INSERT INTO mxv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ra ta xini tu ndo vaxi tachi chi nuu kita ñuꞌu, ra kaꞌan ndo iꞌni ni koo vichin, kachi ndo. Saa ra iꞌni ni ndixa va. ");
INSERT INTO mxv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ra na chiꞌña tuꞌun va kuvi ndo!, saa chi xini va ndo ña kiꞌin ndo kuenda xiꞌin ña kuu nuu ndivi xiꞌin ña kuu nuu ñuꞌu, ¿ra nichuun kundäa tu ini ndo xiꞌin ña kuu tiempo ña ndee ndo vichin? ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Saa ndikaꞌan ka Jesús xiꞌin na kachi ra saa: ―Ra vivii va na kiꞌin xini ndo, ra suꞌva ke na sa ndo. ");
INSERT INTO mxv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tu ndia na taxi kuachi xaꞌa ndo nuu na chiñu, ra vaꞌa ka va yachi na ndakaꞌan mani ndo xiꞌin na, ña vaꞌa na küꞌun ndo veꞌe chiñu; saa chi tu na kuꞌun ndo nuu ra juez ña sandaku ra kuachi xiꞌin ndo, saa ra, ndataxi va ra kan ndoꞌo ndaꞌa ndia kumisio ra taan va ndia ndoꞌo veꞌe kàà. ");
INSERT INTO mxv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi këe yachi vi ndo veꞌe kàà, chi xiniñuꞌu ndiakua na chaꞌvi ndiꞌi ndo xuꞌun loꞌo ndo, saa vi ke tava ndia ndoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ra te sandiꞌi Jesús ndikaꞌan ra xiꞌin yuvi kan. Ra saa xaa sava na ndee kan ra ndatuꞌun na xiꞌin ra kachi na saa: ―Ra Pilato ra kuu gobernador kuvi ra tiꞌvi ndia soldado ra, ra ndixaꞌan ndia ña xaꞌni ndia sava tiaa ndia kee Galilea te ñuꞌu ndia veꞌe ñuꞌu kaꞌnu ñuu Jerusalén ña xaꞌni ndia kiti soko ndia nuu Ndioxi. Ra ndakava nuu nii ndia xiꞌin nii kiti ri soko ndia nuu Ndioxi ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin na: ―¿Ni ke ndakani ini ndo xaꞌa ña ndoꞌo ndia yoꞌo, a ndia iyoo ni ka kuachi va kuvi ndia nuu takundiꞌi ka yuvi tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ra ña kachi yuꞌu xiꞌin ndo ra süvi saa iyoo ña. Chi tu na nandïko ini ndo xaꞌa kuachi ndo, ra mii saa ke ndoꞌo tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ra na xaꞌun uni na ndixiꞌi ñuu Jerusalén te nduva torre ña nani Siloé sata na, ¿ra a iyoo ni ka kuachi na kan, nuu takundiꞌi ka na ndee ñuu Jerusalén, tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ra ña kachi yuꞌu xiꞌin ndo ra süvi saa iyoo ña. Chi tu na nandïko ini ndo xaꞌa kuachi ndo, ra kuvi tu ndoꞌo va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ra saa ndakani Jesús iin tuꞌun ndichi nuu na kachi ra saa: ―Suꞌva ndoꞌo iin tiaa ra ndichi iin itun koxi nuu ñuꞌu, ra saa kuu ra ndixaꞌan ra xitoꞌni ra a xa iyoo kuiꞌi ndaꞌa nu, kaꞌan ra. Ndi su ndia nii ri köo ndikun ndaꞌa nu ndixini ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ra saa ndikaꞌan ra xiꞌin ra ndiaa ñuꞌu ra kachi ra saa: “Xa uni kuiya ke kixi yu nanduku yu koxi ndaꞌa nu. Ra ndia nii ri köo nindaniꞌi yu ndaꞌa nu. Ra vaꞌa ka na kaꞌndia va kun nu; saa chi ña uun va ke ndichi nu ndasi nu nuu ñuꞌu yu” ―kachi ra xiꞌin ra ndiaa ñuꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ra saa ndakuiin ra ndiaa ñuꞌu kan kachi ra saa xiꞌin ra: “Tata, xikan yu ña mani nuu kun, ra na kundichi ka nu saa iin kuiya; ra na ndasavita yu ñuꞌu xaꞌa nu, ra chikaa ka yu tatan xaꞌan xaꞌa nu. ");
INSERT INTO mxv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ra a kusana taxi va nu kuiꞌi saa; ra tu nditäxi nu kuiꞌi ra saa ke tiaꞌndia va nu”, kachi ra ndiaa ñuꞌu kan xiꞌin xitoꞌo ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ra saa kuu iin kii yii sábado ña ndakindiee̱ na ra ndichi Jesús sañaꞌa ra yuvi ini veꞌe ñuꞌu; ");
INSERT INTO mxv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ra suvi mii ini veꞌe ñuꞌu kan ke ndichi tu iin ñaꞌa ña xiꞌi, ra xa xaꞌun uni kuiya vi ke kutoso sata ña. Ra tachi ndivaꞌa va ke xa saa xiꞌin ña, ra ndiküvi vaꞌa vi nundaku sata ña. ");
INSERT INTO mxv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ra te xini Jesús ñaꞌa ña xiꞌi kan, ra saa kana ra ña xaa ña nuu ra. Ra ndikaꞌan ra xiꞌin ña kachi ra saa: ―Nana, xa nduvaꞌa va kun vichin ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ra saa chindee ra ndaꞌa ra sata ña, saa ra ndikun ndundaku va sata ña, ra xaꞌa ña ^ndasakaꞌnu ña Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Saa ra ndisaa ni ini ra kuchee ndiso chiñu ndiaa veꞌe ñuꞌu kan xiꞌin Jesús xaꞌa ña sandaꞌa ra ña xiꞌi kan, kii yii sábado ña ndakindiee̱ na, ra saa ndikaꞌan ra xiꞌin yuvi na ndee kan kachi ra saa: ―I̱ñu̱ va kii ke xiniñuꞌu sachiñu yo, ra kii kan ke na kixi ndo ña nandaꞌa ndo. Ndi su küvi nandaꞌa ndo kii yii sábado ña ndakindiee yo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Na chiꞌña tuꞌun va kuvi ndoꞌo, saa chi, ¿a ndäxi ndo sindiki sana ndo a burru sana ndo ña kuꞌun ri koꞌo ri tiakuii kii yii ndakindiee̱ yo, su ndaxi va ndo ri? ");
INSERT INTO mxv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ra ñaꞌa yoꞌo, ra seꞌe xikua ra Abraham va kuvi ña. Ra xa xaꞌun uni kuiya vi ke katun kiti ndivaꞌa ña ña ndoꞌo ña kueꞌe yoꞌo. ¿Ra a küvi ndaxi ña kii yii sábado tuvi ndo? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ra ta ndikaꞌan Jesús tuꞌun yoꞌo, ra na saa ini xini ra, ra tiaa ni kukaꞌan nuu na; ndi su yuvi na kuaꞌa kan, ra kusii ka vi ini na ña xini na takundiꞌi ña xituꞌun ña xa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ra saa ndikaꞌan Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―¿Ndia ña ke inuu xiꞌin ichi nuu xaꞌndia Ndioxi chiñu, ra ndia ñaꞌa ke kuvi chinuu yu xiꞌin ña? ");
INSERT INTO mxv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ra kuni yu na kundaa ini ndo, chi ta kuꞌva iyoo ndikin loꞌo itun mostaza ña chiꞌi iin tiaa nuu ñuꞌu ra, ra xaꞌnu ña nduu ña ta kuꞌva iyoo iin itun chee va, ra ndia sàà va xaa xavaꞌa chiꞌyo ndaꞌa itun ña, ra kuꞌva saa va ke iyoo nuu xaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ra saa ndikaꞌan tuku Jesús kachi ra saa: ―¿Ndia ña ke kuvi chinuu yu xiꞌin nuu xaꞌndia Ndioxi chiñu? ");
INSERT INTO mxv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ra na kundaa ini ndo chi ña kuvi chinuu yu xiꞌin ichi nuu xaꞌndia Ndioxi chiñu kuvi ña ndoꞌo iin ñaꞌa ña kavanuu loꞌo ixan iyá xiꞌin kuaꞌa ni ixan ixtavaꞌa va, ra kuaꞌa ni nduu ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ra te ndakiꞌin Jesús kuaꞌan ra ñuu Jerusalén, ra iin takundiꞌi ñuu naꞌnu xiꞌin ñuu vali yaꞌa ra kuaꞌan ra, ra sañaꞌa ra takundiꞌi yuvi kan tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ra saa nindakatuꞌun iin na Jesús kachi na saa: ―Tata, ¿a loꞌo ni va kuvi na kaku? ―kachi na xiꞌin ra. Ra saa ndakuiin ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Na sa nduxa ndo ña kee ndo yeꞌe tiañu; saa chi kuaꞌa ni yuvi kuni kiꞌvi, ndi su kuchüun ka na. ");
INSERT INTO mxv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Saa chi nuña ka va yeꞌe vichin, ndi su vaxi kii ra ndakundichi va mii ra xitoꞌo veꞌe kan ra ndasi ra yeꞌe nuu ndo. Ra ndoꞌo, na kindoo chi keꞌe; ra kaꞌan ndo xiꞌin ra kachi ndo saa: “Tata, ndakuña yeꞌe nuu ndi”, kachi ndo xiꞌin ra. Ndi su kuïin ka ra ndakuña ra yeꞌe nuu ndo, chi suꞌva va kachi ra xiꞌin ndo: “Xïni yu yoo kuvi ndoꞌo”, kachi ra xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ra saa xaꞌa ndo kaꞌan ndo xiꞌin ra, kachi ndo saa: “Tata, xini va ndi yoꞌo chi ndixaa va kun ñuu ndi sañaꞌa kun nduꞌu, ra xixi tu ndi xiꞌin va kun”, kachi ndo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ra saa ndakuiin ra kachi ra saa: “Xa ndikaꞌan yu xiꞌin ndo, chi xïni yu yoo kuvi ndoꞌo. Kuatiaꞌa ndo nuu yu, chi yuvi väꞌa va kuvi ndoꞌo”, kachi ra xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Saa ra kusuchi ni ini ndo, ra xaꞌa ndo kuaku ndo ndiakua ndakaxi nuu ndo. Saa chi kuni ndo ra Abraham xiꞌin ra Isaac, xiꞌin ra Jacob, xiꞌin takundiꞌi ka na na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa, ña ndee na nuu xaꞌndia Ndioxi chiñu. Ra ndoꞌo tu, küvi kiꞌvi va. ");
INSERT INTO mxv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ra kixi takundiꞌi yuvi na kee kumi saa tutun ña yuuvi ra ndakundee na nuu mesa ña kuxi na xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ra na ndikun vichin ra na inuu va nduu na, ra na inuu vichin ra na ndikun va nduu na. ");
INSERT INTO mxv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ra te ndiꞌi ndikaꞌan Jesús xiꞌin yuvi kan, ra saa xaa sava ndia fariseo ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Kita ñuu yoꞌo ra kuaꞌan inka xiyo, saa chi ra rey Herodes ra kuni ra kaꞌni ra yoꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo ra ndatuꞌun ndo xiꞌin yukuii ñaa, chi vichin xiꞌin tiaan ra tava ka va yu tachi ndivaꞌa ra sandaꞌa tu yu na xiꞌi va, ra kii uni vi sandiꞌi yu chiñu ña xa yu, kachi ndo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ndi su vichin, xiꞌin tiaan, xiꞌin isa, ra xiniñuꞌu sa ka va yu chiñu ña xiniñuꞌu sa yu, saa chi väꞌa kita ña ña kuvi iin ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi inka xiyo nuu ña kuvi ra ñuu Jerusalén ―kachi Jesús xiꞌin ndia fariseo. ");
INSERT INTO mxv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―¡Ndoꞌo, na ñuu Jerusalén, kuvi na ^xaꞌni na kaꞌan ndoso tuꞌun yuꞌu Ndioxi, ra xakin ndo yuu na tiꞌvi Ndioxi vaxi! ¡Kuaꞌa ni ichi kuni yu ndachitaꞌan yu ndoꞌo, ta kuꞌva ^xa iin nduxi xiꞌin seꞌe vali ri ña ^ndataan ri ri tixi ndixin ri, ndi su ndixïin ndo! ");
INSERT INTO mxv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ra xaꞌa ña kan ke ndoo ndaꞌa va veꞌe ndo, ra sa tu ñuu va ndo, ra na kundaa ini ndo chi küni ka ndo yuꞌu, ndia te na xaa kii ña kaꞌan ndo kachi ndo saa: “Ra vaꞌa ni kuvi ra vaxi xiꞌin kivi Tata yo Ndioxi”, kachi ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Saa kuu iin kii ña ndakindiee̱ na ra ke̱e Jesús kuaꞌan ra kuxi ra veꞌe iin ra kuchee nuu ndia fariseo. Ra ikan ndee ka tu sava ndia fariseo va. Ra xitonani ndia ra a sa ra iin ña väꞌa kaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ra veꞌe kan nduꞌu tu iin tiaa ra ndikiꞌvi kuiñu va. ");
INSERT INTO mxv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ra saa ndindakatuꞌun Jesús ndia maestro, ndia sañaꞌa ndiayu Ndioxi xiꞌin ndia fariseo kachi ra saa: ―¿A kuvi nandaꞌa na xiꞌi kii yii sábado, a küvi vi? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ndi su ndia nii ndia ndindäkuiin yuꞌu ra. Ra saa chinduꞌu ra ndaꞌa ra sata ra xiꞌi kan ra nduvaꞌa va ra. Ra saa ndatiꞌvi ra ra kuanuꞌu ra veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ra saa ndikaꞌan ra xiꞌin ndia fariseo kan kachi ra saa: ―¿Tu ndia iin ndoꞌo, ndia ndee yoꞌo, ra na ndakava burru sana ndo a sindiki sana ndo iin yavi kunu, ra a täva ndo ri kii yii sábado? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ndia saa ra nindäkuiin vaꞌa ka vi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ra ta xini Jesús ña kaxin na kana na xaa viko kan tiayu tu ndee na kunaꞌnu, tu ndita yachin ndia nuu iin mesa ña kundee na, ra saa ndikaꞌan ra tuꞌun ndichi yoꞌo xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ta xa na kana na ndoꞌo ña kuꞌun ndo kuxi ndo nuu iyoo viko tandaꞌa, ra na käxin ndo tiayu tu ndee na kunaꞌnu kundee ndo. Saa chi tu köo, ra iyo ni xaa inka na kunaꞌnu nuu ndoꞌo, ");
INSERT INTO mxv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ra kaꞌan ra tava viko kan xiꞌin ndo kachi ra saa: “Taxi ndo loꞌo ndo tiayu ndo ndaꞌa na yoꞌo, na kundee na; ra kuaꞌan ndo chi sata kaa kundee ndo”, kachi ra xiꞌin ndo. Saa ra tiaa ni kukaꞌan nuu ndo, ña kuꞌun ndo chi sata ndakundee ndo. ");
INSERT INTO mxv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ra ña kan ke ta xa na kana na ndoꞌo ña kuꞌun ndo nuu iyoo viko tandaꞌa, ra tiayu tu ndita ndia chi sata va na kundee ndo; ra ndia te na xaa ra kana ndoꞌo, ra kaꞌan ra xiꞌin ndo kachi ra saa: “Ñani, naꞌa ndo, chi nuu ndee na kunaꞌnu yoꞌo kundee ndo”, kachi ra xiꞌin ndo. Ra saa ke kunduꞌu toꞌo tuꞌun xaꞌa ndo nuu na ndee nuu mesa kan. ");
INSERT INTO mxv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Saa chi yuvi na ndasa naꞌnu mii, kuvi na nduvali va; ra yuvi na xa ninu xiꞌin mii, kuvi na ndunaꞌnu va ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ra saa ndikaꞌan tu Jesús xiꞌin ra fariseo ra tava viko kan va kachi ra saa: ―Ta tava kun iin viko veꞌe kun, ra käna kun na itaꞌan xiꞌin kun, nii ñani kun, nii na veꞌe kun, nii na ndee yachin xiꞌin kun, nii na kuika ña kixi na kuxi na xiꞌin kun, saa chi vaxi kii ra kana va na yoꞌo kuꞌun kun kuxi kun veꞌe na. Ña sandiko na ña nuu kun. ");
INSERT INTO mxv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ra ña kan ke te xa tava kun viko, ra na ndaꞌvi, na köo chiñu, na küvi kaka xiꞌin na kuaa va kuvi na, na kana kun na kuxi xiꞌin kun. ");
INSERT INTO mxv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Saa ra vaꞌa ni kee kun. Saa chi na kan, ra küvi sandiko na ña ndaꞌa kun, ndi su vaꞌa ni va kee kun ta xa na ndatiaku na ndikun Ndioxi ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ra te xini soꞌo iin ra nduꞌu nuu mesa kan, ra saa ndikaꞌan ra xiꞌin Jesús kachi ra saa: ―Vaꞌa ni kee yuvi na kuꞌun kuxi viko nuu xaꞌndia Ndioxi chiñu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ra kachi ra saa: ―Suꞌva ndoꞌo iin tiaa, ra tava ra iin viko kaꞌnu veꞌe ra, ra kuaꞌa ni yuvi ndikaꞌan xiꞌin ña na kixi na. ");
INSERT INTO mxv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ra ta xa ndixaa hora ña kuxini na, ra saa ndatiꞌvi ra na xachiñu nuu ra ndixaꞌan na ndikaꞌan tuku na xiꞌin yuvi kan, ña na kixi na kuxi na veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ndi su ndia nii yuvi kan ndixïin kuꞌun chi xa iin iin chiñu ndatiaa va na: Ra ra nuu ra suꞌva va kachi ra: “Ñuꞌú va sakan sata yu, ra ña kan va kuꞌun yu kuni yu; ra kaꞌnu koo ini kun chi küvi vi kuꞌun yu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ra inka ra ndikaꞌan kachi suꞌva va: “Sindiki va sakan sata yu uꞌun yunta, ra ri kan va kuꞌun yu kotondoso yu; ra kaꞌnu koo ini kun chi küvi kuꞌun yu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ra inka tu ra kachi suꞌva va: “Ra sakan tandaꞌa va kuvi yu, ra ña kan ke küvi vi kuꞌun yu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ra saa ndandiko ra muso kan nuu xitoꞌo ra, ra ndakani ndiꞌi ra ña ndikaꞌan na xiꞌin ra. Saa ra ndisaa ni ini ra xitoꞌo ra, ra ndikaꞌan ra xiꞌin ra moso kan kachi ra saa: “Kuaꞌan iinii kuvi nuu yaꞌvi, xiꞌin iinii kuvi yaꞌya ña ndoꞌni ñuu kaꞌnu, ra ndakaya kun takundiꞌi na ndaꞌvi, xiꞌin na küvi kaka, xiꞌin na kuaa, ra na kixi na xiꞌin kun”, kachi ra xiꞌin ra muso ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ra saa ndixa xa va ra moso kan. Ra saa ndikaꞌan ra xiꞌin xitoꞌo ra kachi ra saa: “Tata, xa xa va yu takundiꞌi ña ndikaꞌan kun, ndi su iyoo kuaꞌa ka va nuu kundee na”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ra saa ndakuiin ra xitoꞌo ra kachi ra saa xiꞌin ra: “Kuaꞌan iinii kuvi ichi chi nuu ndee yuvi, ra na sanduxa kun xiꞌin na ña na kixi na ra ndiakua na kutu veꞌe yu. ");
INSERT INTO mxv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Saa chi ndia nii na kana yu ña nuu, küxi veꞌe yu”, kachi ra xiꞌin ra muso ra, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Saa kuu iin kii ra kuaꞌa ka vi yuvi ndikun kuaꞌan sata Jesús, ra saa ndikokuiin ra, ra ndikaꞌan ra xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tu ndia ndo kuni kundikun yuꞌu, ra xiniñuꞌu kuꞌvi ni ka ini ndo kuni ndo yuꞌu, nuu iva ndo, xiꞌin nuu siꞌi ndo, xiꞌin nuu yasiꞌi ndo, xiꞌin nuu seꞌe ndo, xiꞌin nuu ñani ndo, xiꞌin nuu kuꞌva ndo. Ra xiniñuꞌu koo nduvi tu ndo ña ndoꞌo ndo xaꞌa va yu. Ra tu na sä ndo saa, saa ra küvi kundikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ra tu kuëe xa ndiee ini ndo ña vaꞌa ni na kuvi va ndo ña kundikun ndo yuꞌu, saa ra kuchüun vi ndo ña kundikun ndo yuꞌu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ra saa ndikaꞌan Jesús inka tuꞌun ndichi xiꞌin na kachi ra saa: ―Tu ndia iin ndo kuni savaꞌa iin veꞌe chee sukun, ¿ra a su xiꞌna ka va xiniñuꞌu kundee ndo tava ndo kuenda, ra saa ke kundaa ini ndo ndixaa xuꞌun ke kusiki ndo xiꞌin ña, ña kuchuun ndo saxinu ndo ña? ");
INSERT INTO mxv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Saa chi tu na ndakäni ini ndo, ra xaꞌa ndo tava ndo xaꞌa ña, ra te na ndiꞌi, ra kuchüun ndo saxinu ndo ña. Saa ra takundiꞌi yuvi na kuni, ra xaꞌa na kusiki na ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ra kaꞌan na kachi na saa: “Tiaa yoꞌo, ra takua xaꞌa va veꞌe ra tava ra, ra ndikuchüun ra saxinu ra ña”, kachi na xaꞌa ndo ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ra saa ndikaꞌan Jesús inka tuku tuꞌun ndichi xiꞌin na kachi ra saa: ―Tu ndia iin rey, ra kuni ra kanitaꞌan ra xiꞌin inka rey, ¿ra a su xiꞌna ka va xiniñuꞌu kunduꞌu ra kiꞌin xini ra, a kuchuun uxi mil ndia soldado ra, ña kanitaꞌan ndia xiꞌin oko mil soldado inka ra rey? ");
INSERT INTO mxv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ra tu xa kiꞌin ra rey kan kuenda ña kuchüun ra, saa ra yachi ka va tiꞌvi ra na xika chiñu nuu ra ña kuꞌun na kindoo mani na xiꞌin inka ra rey kan. ");
INSERT INTO mxv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ra mii saa ke iyoo tu ña yoꞌo va, saa chi tu na ndaköo ndo takundiꞌi ñaꞌa ña kuu mii ndo, saa ra kuchüun vi ndo ña kundikun ndo yuꞌu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","―Ña vaꞌa ni kuvi va i̱i̱n te iꞌva ña, ndi su tu na ndukati ña, saa ra, ¿ni ke sa na ña kuniñuꞌu ka na ña? ");
INSERT INTO mxv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Saa chi nii ña sa xaꞌan ña ñuꞌú ke väꞌa ka vi ña, ra ndia ña kutia va kuvi ña. Ña kan ke na xini soꞌo ra na tiaa ka soꞌo va na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Saa kuu iin kii ra xaa takundiꞌi ndia kaya xuꞌun ña kuaꞌan ndaꞌa gobierno ñuu Roma, xiꞌin na nduꞌu tuꞌun kiꞌvi xaꞌa, ña kuni soꞌo na ña kaꞌan Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ra xaꞌa ña kuyachin na yoꞌo nuu Jesús ke xaꞌa ndiaa fariseo xiꞌin ndiaa maestro sañaꞌa ndiayu Ndioxi, ndikaꞌan ñaꞌa ndia xaꞌa Jesús kachi ndia saa: ―Tiaa yoꞌo, ra itaꞌan va ra xiꞌin yuvi, na iyoo ni kuachi, ra xixi tu ra xiꞌin va na ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ndia kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tu ndia iin ndo, ra iyoo iin ciento ndikachi sana ndo, na kachi yo. Ra na ndoñuꞌu iin ri iku, ¿ra a ndaköo ñaꞌa ndo ri kumi xiko xaꞌun kumi kan iku nuu ndee ri, ra kuꞌun ndo ndanduku ndo ri nindoñuꞌu kan ndiakua ndaniꞌi ndo ri? ");
INSERT INTO mxv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ra te xa na ndaniꞌi ndo ri, ra saa ndakasoko ndo ri ña kusii ni ini ndo xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ra te xa na ndaxaa ndo xiꞌin ri veꞌe ndo, ra saa ndakaya ndo na itaꞌan xiꞌin ndo, xiꞌin na ndee yachin xiꞌin ndo. Ra kaꞌan ndo xiꞌin na kachi ndo saa: “Na kusii ini ndo xiꞌin yu saa chi xa ndaniꞌi va yu ndikachi loꞌo sana yu ri ndindoñuꞌu”, kachi ndo xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ra mii ña ndixa kaꞌan yu xiꞌin ndo, saa chi kusii ni ka va ini Ndioxi, ra saa tu na tatun va ra, xaꞌa na indaa na nandiko ini xaꞌa kuachi kan, nuu na kumi xiko xaꞌun kumi na xa ndee vaꞌa na kuëe xiniñuꞌu ka nandiko ini ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ra saa ndikaꞌan Jesús inka tuꞌun ndichi xiꞌin ndia kachi ra saa: ―Ra tu ndia tu iin ñaꞌa ña iyoo uxi xuꞌun kaa nuu, ra na sandoñuꞌu ña iin ña, ¿ra a ndavikun ña ñuꞌu, ra kaka ña ndatiꞌvi ña veꞌe ña ndiakua ndaniꞌi ña ña? ");
INSERT INTO mxv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ra ta xa na ndaniꞌi ña ña, ra saa ndakaya ña na itaꞌan xiꞌin ña, xiꞌin na ndee yachin xiꞌin ña, ra kaꞌan ña xiꞌin na kachi ña saa: “Na kusii ini ndo xiꞌin yu, saa chi xa ndaniꞌi va yu xuꞌun yu ña nindoñuꞌu”, kachi ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ra mii ña ndixa kaꞌan yu xiꞌin ndo, saa chi ^kusii ni va ini Ndioxi ra saa tu na tatun va ra, xaꞌa na indaa na nandiko ini xaꞌa kuachi ―*kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ra saa ndakani Jesús inka tuku tuꞌun ndichi nuu ndia kachi ra saa: ―Suꞌva ndoꞌo iin ra tata, ra ndixiyo uvi tiaa seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ra iin kii ndikaꞌan seꞌe ra ra loꞌo xiꞌin ra, kachi ra saa: “Tata, kuni yu ra na taxi va kun ñaꞌa ña niꞌi yu ndaꞌa yu”, kachi ra xiꞌin iva ra. Ra saa ndataꞌvi ndixa va ra tata kan ñaꞌa ña kuu mii ra xiꞌin uvi saa tiaa seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ra täan kunaꞌa vi ndiniꞌi ra ku loꞌo kan ñàꞌà nuu iva ra, saa ra ndikun ndixiko ndiꞌi va ra ña. Ra saa ndakiꞌin ra kuaꞌan ra inka ñuu xika va xiꞌin xuꞌun ra. Ra ikan sasiki ndiꞌi va ra xuꞌun ra xiꞌin takundiꞌi chiñu kiꞌvi ña xa ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ra ta ndiꞌi sasiki ndiꞌi ra xuꞌun ra, ra saa xaꞌa tama ñuu nuu iyoo ra, ra xaꞌa kaꞌun ka vi ini ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ra saa kee ra ndixaꞌan ra nduku ra chiñu nuu iin tiaa ra iyoo ñuu kan, ra taxi va tiaa kan chiñu ndaꞌa ra, ña kuꞌun ra kondiaa ra kini nuu ndee ri. ");
INSERT INTO mxv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ra saa ^kuu ra xika ra ndiaa ra kini kan, ra kaꞌun ka vi ini ra, ra iin ndiakua iyoo ini ra ña kaxi ra ñaꞌa ña xaxi kini kan, ndi su ndia nii na nditäxi ñaꞌa kuxi ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ra saa xaꞌa ^ndakani ini ra, ^kaꞌan ra saa: “¡Kuaꞌa ka vi na xachiñu nuu tata yo, ra vaꞌa ka vi xixi na, ra iin ndiakua ndoo ndoso va ña nuu na, ra yoo yoꞌo tu kaꞌun ka vi ini xika yoꞌo va! ");
INSERT INTO mxv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ra vaꞌa ka va na nandiko yo nuu tata yo, ra kaꞌan yo xiꞌin ra kachi yo saa: Tata, na koo kaꞌnu ini kun xaꞌa yu, chi xa yu kuachi nuu Ndioxi, ra saa tu nuu yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ra köo ka ichi vi yu ña kuu yu seꞌe kun vichin, ra ndia ta kuꞌva iyoo iin ra xachiñu nuu va kun na koo yu, kachi yo xiꞌin tata yo”, ^kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ra saa ndakiꞌin ra ichi kuanuꞌu ra veꞌe iva ra. Ra xika ka va kuaꞌan ra saa ra xa xini va iva ra ra, ra saa kundaꞌvi ka vi ini iva ra xini ra ra, ra xinu ra ndixaꞌan ra ndakiꞌin ra ra, ra ndanumi ra ra, ra xiꞌi ra nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ra saa ndikaꞌan ra loꞌo kan xiꞌin iva ra kachi ra saa: “Tata, koo kaꞌnu ini xaꞌa yu, saa chi xa yu kuachi nuu Ndioxi, ra saa tu nuu yoꞌo va. Ra köo ka ichi yu ña kuu yu seꞌe vi kun”, kachi ra xiꞌin iva ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ra ta kaꞌan ka va ra loꞌo kan xiꞌin iva ra, saa ra ndikun xaꞌndia va iva ra chiñu nuu ndia xachiñu nuu ra, ra kachi ra saa xiꞌin ndia: “Kuaꞌan kiꞌin ndo tikoto ña vaꞌa ni, ra na sandakundixi ndo ña seꞌe yu, ra chikaa tu ndo xeꞌe ndaꞌa va ra, ra na ndachikaa tu ndo ndixan xaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ra na kuꞌun ndakiꞌin tu ndo iin sindiki ri vaꞌa ni va, ra kaꞌni ndo ri kuxi yo ña ndatava yo viko vichin. ");
INSERT INTO mxv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Saa chi ndaxaa va ra loꞌo seꞌe yu. Ra xa ta iyoo ra ndixiꞌi va ndixiyo ra, ña ndindoñuꞌu ra ndixaꞌan ra, ndi su vichin ra ndatiaku va ra saa chi ndaxaa va ra nuu yo”, kachi iva ra loꞌo kan xiꞌin na xachiñu nuu ra. Ra saa xakin na viko xaꞌa ra loꞌo kan ña ^kusii ni ini na. ");
INSERT INTO mxv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ndi su seꞌe tiaa kan ra chee, ra iku va ndikaa ra xachiñu ra. Ra saa nandiko ra vaxi ndixi ra, ra ta kuyachin ra nuu iin veꞌe ra, ra saa xini soꞌo ra ña iyoo ni yaa, ra taxaꞌa ka vi na. ");
INSERT INTO mxv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ra saa kana ra iin ra xachiñu nuu iva ra, ra nindakatuꞌun ra ra kachi ra saa: “¿Ni ke kuu ni?”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Saa ndakuiin ra kan kachi ra saa: “Ñani va kun kuvi ra ndaxaa, ña kan ke xaꞌni tata kun sindiki ri vaꞌa ni, ña ndatava ra viko ña ^kusii ni ini ra, saa chi iyoo vaꞌa va ñani kun ndaxaa ra”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Saa ra ndisaa ni ra, ra nii ndixïin ka ra ña ndiꞌvi ra veꞌe. Ra saa kita iva ra ña xaku ndaꞌvi ra nuu ra ña ndiꞌvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ra saa ndikaꞌan ra xiꞌin iva ra kachi ra saa: “Tata, xa kundaa va ini kun chi xa kuaꞌa ni va kuiya xachiñu yu xiꞌin kun, ra kandixa ndiꞌi va yu ña kaꞌan kun xiꞌin yu, ndi su ndia nii ichi täan taxi kun iin tixuꞌu loꞌo ndaꞌa yu ña ndatava yu viko kuxi yu xiꞌin na itaꞌan xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ra vichin ndita seꞌe kun, ra ndixaꞌan sasiki xuꞌun kun xiꞌin na siꞌi kókó, ra ndia sindiki ri iin vaꞌa va xaꞌni kun kuxi ra”, kachi ra xiꞌin iva ra. ");
INSERT INTO mxv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ra saa ndakuiin iva ra kachi ra saa: “Iin ndisaa kii va íin yoꞌo xiꞌin yu. Ra takundiꞌi ñaꞌa ña ku mii yu, ra kuenda yoꞌo kuu ndiꞌi va ña. ");
INSERT INTO mxv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndi su xiniñuꞌu va ndatava yo viko, ña na kusii ini yo, saa chi xa ta iyoo ra ndixiꞌi va ndixiyo ñani kun, ña ndindoñuꞌu ra ndixaꞌan ra, ndi su vichin ra ndaxaa va ra, ra ta iyoo ra ndatiaku va iyoo ra”, kachi iva ra xiꞌin ra, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ndixiyo iin tiaa ra kuika ni, ra xachiñu tatu iin tiaa nuu ra, ra saa kuu iin kii ra ndixaꞌan va iin na nuu ra kuika kan, ña taxi na kuachi xaꞌa tiaa ra xachiñu tatu kan ña sasiki ra xuꞌun ra kuika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ra saa ndakana ra kuika kan, ra xachiñu tatu nuu ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: “¿A ña ndixa ke sasiki kun xuꞌun yu?, chi saa kachi na xiꞌin yu. Ña kan ke na ndasa ikun kun kuenda nuu yu vichin, saa chi sachïñu ka kun xiꞌin yu”, kachi ra kuika kan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ra saa ndakani ini ra xachiñu tatu kan kaꞌan ra saa: “¿Ni ke sa yo vichin ra xïin ka ra xitoꞌo yo ña sachiñu yo xiꞌin ra? Ra köo ndiee yo ña sachiñu yo iku, ra kukaꞌan ni tu nuu yo ña ndakan va yo. ");
INSERT INTO mxv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ra ña sa yo vichin ke, na nduku yo ndia kuꞌva ke ndakiꞌin mani yuvi yoo veꞌe na, te xa na kindiaa ra ixtoꞌo yo chiñu ndaꞌa yo”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ra saa ndakana ra ndia nika nuu ixtoꞌo ra, ra ndikaꞌan ra xiꞌin ra inuu xaa kan kachi ra saa: “¿Nisaa ke nika kun nuu ixtoꞌo yu?”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Saa ndakuiin ra kan kachi ra saa: “Iin ciento yoo kuvi ndutia xaꞌan ra nika yu”, kachi ra. Ra saa ndikaꞌan ra xachiñu tatu nuu ra kuika kan xiꞌin ra kachi ra saa: “Kunduꞌu ñaa, ra yoꞌo iyoo tutu ña ndatiaa kun, ra soo uvi xiko uxi yoo va ke ndachinduꞌu kun nuu ña”, kachi ra xiꞌin ra nika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ra saa ndikaꞌan tu ra xiꞌin ra uvi kan va, kachi ra saa: “¿Ra nisaa ke nika tu yoꞌo?”, kachi ra. Ra saa ndakuiin ra kan kachi ra saa: “Iin ciento kuvi itin nuni trigo nika yu”, kachi ra. Ra saa ndikaꞌan ra xiꞌin ra kachi ra saa: “Yoꞌo iyoo tutu, ra soo kumi xiko, itin va na ndachinduꞌu kun nuu ña”, kachi ra xiꞌin ra nika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ra te kundaa ini ra kuika kan xaꞌa ña xa ra xachiñu tatu nuu ra, saa ra ndakanda ni ini ra xini ra ra, saa chi ndichi ni xa ra. Ra na kundaa ini ndo chi yuvi na xïni ichi Ndioxi, ra xini ni ka va na kan ndia kuꞌva ke sa na ña koo yuvi kitaꞌan mani xiꞌin na, nuu na xini ichi Ndioxi, kachi tuꞌun ndichi yoꞌo ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Ña kuni yu kaꞌan yu xiꞌin ndo ke na kuniñuꞌu ndo ña kuika iyoo nuu ña yuuvi yoꞌo, ña sakanaa ndo yuvi kutaꞌan xiꞌin ndo, ra te xa na ndiꞌi ña, ra koo na ndakiꞌin mani ndoꞌo veꞌe nuu koo ndo ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ra iin tiaa ra vaꞌa ndiaa ñaꞌa ña loꞌo iyoo nuu ra, saa ra kuchuun tu ra kondiaa ra ña viꞌi va; ra tu kuchüun ra kondiaa ra ña loꞌo iyoo nuu ra, saa ra kuchüun tu ra kondiaa ra ña viꞌi va. ");
INSERT INTO mxv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ra tu na kondiäa ndo ña kuika iyoo nuu ndo, ¿saa ra ndixaa sa ndo ña kondiaa ndo ñaꞌa ña ndiaa yaꞌvi ni ka? ");
INSERT INTO mxv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Saa chi tu na kondiäa ndo ñaꞌa inka yuvi, saa ra, ndia nii ka yuvi täxi ñaꞌa ndaꞌa ndo ña kondiaa ndo ña? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Ndia nii yuvi ra küvi sachiñu na nuu uvi tiaa ndia xaꞌndia chiñu, saa chi na xachiñu nuu uvi tiaa, ra küvi kindoo vaꞌa na xiꞌin uvi saa ndia. Saa chi tu vaꞌa na kitaꞌan na xiꞌin iin ra, ra inka tu ra saa na xiꞌin va. Xaꞌa ña kan ke küvi sachiñu ndo nuu Ndioxi ra sachiñu tu ndo nuu xuꞌun ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Saa ra ndixaku ndiaa va ndia fariseo kan Jesús, saa chi xinisii ni ndia ña koo xuꞌun ndia. Ña kan ke ndikindöo ini ndia ña ndikaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ra saa ndikaꞌan Jesús xiꞌin ndia fariseo kan kachi ra saa: ―Ndoꞌo, ra nuu yuvi yoꞌo va ke ndasa vaꞌa ni ndo mii ndo, ndi su Ndioxi, ra xini va ra ndixaa ke iyoo nima ndo. Ra ñaꞌa ña chee ni nuu na yuuvi yoꞌo, ra ña kundasi va Ndioxi kuvi ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Te yachi ra ndiayu Ndioxi ña tiaa ra Moisés, xiꞌin tuꞌun ña ndikaꞌan na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ke xindikun va yuvi iin saa ndia kii ña kixi ra Juan, ra sakuchi yuvi va, ra ndia kii ña kixi ra kan ke xaꞌa na kaꞌan ndoso na tuꞌun vaꞌa xaꞌa ichi nuu xaꞌndia Ndioxi chiñu. Ra takundiꞌi yuvi ra xa nduxa va na ña kuni na ndakiꞌin na ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ra kuni yu na kundaa ini ndo, chi vaꞌa ni na ndiꞌi va xaꞌa ndivi xiꞌin ñuꞌu, ndi su ndia nii loꞌo ndiayu Ndioxi ndïꞌi xaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ra tu ndia iin tiaa, ra na ndakoo ra yasiꞌi ra, ra tandaꞌa ra xiꞌin inka ñaꞌa, saa ra ndiayu Ndioxi va ke kanduu ra. Ra tiaa ra ndakiꞌin tu ñaꞌa ña nindoo nuu yii kan, ra ndiayu Ndioxi ke kanduu tu ra kan va ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin na kachi ra saa: ―Saa kuu iin kii ra ndixiyo iin ra kuika. Ra vaꞌa ka vi xindixi ra saa chi niña tikoto ña savi ña yaꞌvi xindixi ra, ra iin ndisaa kii ndixiyo viko veꞌe ra, ra vaꞌa ka vi xixi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ra ndixiyo tu iin ra ndaꞌvi, ra xinani Lázaro va. Ra iin ndiakua mii tiaꞌyu kuu sata ra. Ra iin ndisaa kii xaa ra xikunduꞌu ra yeꞌe ra kuika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ra chiꞌña ka vi kuu ra, ña kuni ndakiꞌin ra ña koyo tixi mesa ra kuika kan kuxi ra; ndia tina va kuyachin ra iyakun yaa ri sata ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ra saa kuu ra nditiandiaa va kii ña ndixiꞌi ra ndaꞌvi Lázaro kan. Ra xaa na tatun Ndioxi ndakiꞌin na ra kuaꞌan ra xiꞌin na ndivi, ra ndakunduꞌu ra xiꞌin ra Abraham va. Ra saa kuu ra ndixiꞌi tu ra kuika kan va, ra ndinduxin va na ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ra te xa ndikaa ra ndiaya ña ndoꞌo ni ra. Ra saa ndakotoꞌni ra chi ndivi, ra xika ka vi ndichi ra Abraham xiꞌin ra ndaꞌvi Lázaro xini ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ra saa ndiee ka vi kana ra kachi ra saa: “¡Tata Abraham, kundaꞌvi ini kuni yuꞌu saa chi ndaꞌvi ni yu! Ra na kaꞌan kun xiꞌin ra Lázaro ña na chindaxi ra nuu nduku ndaꞌa ra ini tiakuii, ra na kixi ra chindaxi ra loꞌo yaa yu. Saa chi ndoꞌo ni yu ndikaa yu nuu ñuꞌu yoꞌo”, kachi ra kuika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ra saa ndakuiin ra Abraham kachi ra saa: “Na ndakaꞌan kun, chi ta ndixiyo kun ña yuuvi, ra vaꞌa ni va ndixiyo kun, saa chi ndixiyo ndiꞌi va ñaꞌa ña kuni kun. Ndi su ra Lázaro, ra ndoꞌo ni va ini ra yoꞌo. Ra vichin ra vaꞌa ni va kee ra, ra yoꞌo tu ndoꞌo ni ini va. ");
INSERT INTO mxv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ra küvi chindiee taꞌan yu xiꞌin kun, saa chi iyoo iin taꞌvi chee ña sukun ni tiañu yo, ra ña kan ke na ñuꞌu yoꞌo ra küvi yaꞌa na xaa na chi ñaa, ra nii na ñuꞌu ñaa ra küvi yaꞌa na kixi na yoꞌo”, kachi ra Abraham xiꞌin ra kuika kan. ");
INSERT INTO mxv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ra saa ndikaꞌan ra kuika kan kachi ra saa: “Tata Abraham, xaku ndaꞌvi yu nuu kun, ra na sa kun ña mani ra tiꞌvi kun ra Lázaro ña na kuꞌun ra veꞌe iva yu. ");
INSERT INTO mxv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ra kaꞌan ra xiꞌin na ñani yu na uꞌun na tiaku ka ña na nandiko ini na, ra na kïxi na nuu ndikaa yu yoꞌo ña ndoꞌo na”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ra saa ndakuiin ra Abraham kachi ra saa: “Xa kundaa va ini na saa chi xa iyoo va ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin ña tiaa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ndaꞌa na. ¡Ra ña kan ke na kandixa va na!”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Saa ndakuiin ra kuika kan kachi ra saa: “Ndixa va Tata, ndi su tu na ndatiaku iin na ndixiꞌi ra kuꞌun na ndatuꞌun na xiꞌin na, saa ra kandixa va na”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ra saa ndikaꞌan ra Abraham kachi ra saa: “Tu xïin na kandixa na ndiayu ña tiaa ra Moisés, xiꞌin ña tiaa na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, saa ra nii na ndatiaku va iin na ndii kuꞌun na kaꞌan na xiꞌin na; ra xa saa kandïxa vi na”, kachi ra Abraham xiꞌin ra kuika kan ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ña ndixa ke koo va ñaꞌa ña sandaꞌvi yuvi ña sa na kuachi. ¡Ndi su ndaꞌvi ni yuvi na sandaꞌvi inka na ña sa na kuachi, saa chi vaxi kii ra ndoꞌo ni na sa Ndioxi! ");
INSERT INTO mxv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ra vaꞌa ka va yachi na kunuꞌni iin yuu katia chee ña ndiko ñaꞌa sukun na, ra koꞌni na na ini mini, nuu ña sandaꞌvi na iin na vali ndikun sata yu, ña sa na kuachi. ");
INSERT INTO mxv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ra kuenda ni na koo ndo. ’Tu ndia iin ñani ndo ^xa ña väꞌa xiꞌin ndo, ra na kaꞌan ndo xiꞌin na, ña na sä ka na saa. Ra tu na nandiko ini na, saa ra, na sa kaꞌnu ini ndo xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ra vaꞌa ni uxa va ichi na sa na ña väꞌa xiꞌin ndo iin kii, ra uxa ichi saa na ndiko tu na ña kaꞌan na xiꞌin ndo kachi na saa: “Sä ka yu saa xiꞌin kun”, na kachi na, saa ra xiniñuꞌu na sa kaꞌnu ini ndo xaꞌa va na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ra saa ndikaꞌan ndia itaꞌan xiꞌin Jesús kachi ndia saa: ―Tata, taxi ndie̱e̱ ndi ra na kandixa vaꞌa ka ndi Ndioxi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Saa ndakuiin Jesús kachi ra saa, xiꞌin ndia: ―Tu ña kandixa ndo ra na koo ña ta kuꞌva iyoo iin ndikin loꞌo itun mostaza, saa ra kuvi va kaꞌan ndo xiꞌin itun sicómoro yoꞌo kachi ndo saa: “Tuꞌun mii kun, ra kuaꞌan ndataan kun mii kun ini mini”, na kachi ndo, ra itun yoꞌo ra kandixa va nu ndoꞌo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Tu ndia iin ndo ra iyoo iin ra xachiñu nuu ndo, ña taꞌvi ra ñuꞌu ndo, a kiti sana va tu ndo ndiaa ra, ra ta xa na ndaxaa ra veꞌe ndo, ¿ra a kaꞌan ndo xiꞌin ra kachi ndo saa: “Kuayaꞌa ra kunduꞌu kun kuxi kun”? ");
INSERT INTO mxv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Su käꞌan ndo saa xiꞌin ra, chi suꞌva va kachi ndo: “Savii ña kuxini yu, ra na koo nduvi kun ña kiꞌin kun kuenda xiꞌin yu ña kuxi yu ra koꞌo yu. Ra te xa na ndiꞌi saa vi ke kuvi kuxi kun ra koꞌo kun”, ^kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ra a ndataxi ndo tixaꞌvi ndaꞌa ra xachiñu nuu ndo xaꞌa ña xa ra takundiꞌi chiñu ña xaꞌndia ndo nuu ra? Su ndatäxi vi ndo ña. ");
INSERT INTO mxv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ra ta kuꞌva iyoo ra xachiñu tatu kan ke iyoo tu ndoꞌo va, ra te xa na ndiꞌi sa ndo takundiꞌi chiñu ña xaꞌndia Ndioxi nuu ndo sa ndo; saa ra na kaꞌan ndo kachi ndo saa: “Nduꞌu ra ndia xachiñu tatu ndia köo yaꞌvi ndiaa vi kuvi ndi, saa chi takua chiñu ña xaꞌndia Ndioxi nuu va ndi ke xa ndi”, kachi ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ra saa kuu Jesús ndikaa ra ichi ña kuaꞌan chi ñuu Jerusalén, ra saa ndiyaꞌa ra ichi ña ndikaa yachin nuu ndakutaꞌan xaꞌñu Samaria xiꞌin Galilea. ");
INSERT INTO mxv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ra te ndixaa ra iin ñuu loꞌo, ra ikan ke̱e uxi tiaa ndia ndoꞌo kue̱ꞌe tiaꞌyu, ra xika ka vi xikundita ndia nuu Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ra ndiee ka vi kana ndia ra kachi ndia saa: ―¡Tata Maestro, kundaꞌvi ini kuni nduꞌu, ra sandaꞌa kun nduꞌu! ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ra te xini Jesús ndia, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Kuaꞌan ndo nuu ra sutu, ra na kuni ra ndoꞌo ña xa nduvaꞌa ndo ―kachi ra xiꞌin ndia. Ra te ndakiꞌin ndia kuaꞌan ndia, saa ra ndikun nduvaꞌa va ndia xa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ra te kundaa ini iin ra ña xa nduvaꞌa ra, ra saa nandiko ra nuu Jesús ra ndiee ka vi ndaꞌyu ra ña ndasakaꞌnu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ra xaa ra ndakusiti ra nuu Jesús, ra ndakundiee ra ndia nuu ñuꞌu, ra ndataxi ra tixaꞌvi ndaꞌa Jesús. Ra tiaa yoꞌo ra ra ñuu Samaria va kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ra saa ndikaꞌan Jesús, kachi ra saa: ―¿A su uxi kuvi ndia sandaꞌa yu? ¿Ra ndia chi kuaꞌan inka ìi̱n ndia? ");
INSERT INTO mxv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Saa chi köo ndia nindandiko ndasakaꞌnu ndia Ndioxi, ra ra indaa ndandiko yoꞌo ra ndia nii süvi ra judío kuvi ra ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ra saa ndikaꞌan Jesús xiꞌin tiaa kan kachi ra saa: ―Ndakundichi ra kuaꞌan nuu ra sutu; saa chi xaꞌa ña kandixa va kun ke nduvaꞌa kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ra saa kuu iin kii ra ndindakatuꞌun ndia fariseo Jesús kachi ndia saa: ―¿Ama ke xaa Ndioxi kaꞌndia ra chiñu nuu ña yuuvi yoꞌo? ―kachi ndia. Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Kii ña xaa Ndioxi kaꞌndia ra chiñu ra ndia nii ñaꞌa täxi kuꞌva nuu na ña kundaa ini na. ");
INSERT INTO mxv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ra ni köo tu na kaꞌan kachi suꞌva va: “¡Yoꞌo iyoo ña!”, a “¡Kaa iyoo ña!”, kachi na. Chi xa tiañu ndo yoꞌo va xaa Ndioxi xaꞌndia ra chiñu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Vaxi kii, ra ku̱ni̱ ni ndo kuni ndo yuꞌu, ra xaa yoꞌo, ña kixi tuku yu, ndi su küni ka ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ra kii kan ra kaꞌan na xiꞌin ndo kachi na saa, “Yoꞌo íin ra ke̱e nuu Ndioxi”; a “kaa íin ra ke̱e nuu Ndioxi”, na kachi na. Ra na küꞌun ndo nuu na, ra nii na ndakundïkun ndo sata na. ");
INSERT INTO mxv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Saa chi kii ña nandiko yuꞌu ra xaa yoꞌo vichin, ra iin ta kuꞌva xa taxa ta ndayeꞌe ña chi nuu kanata ñuꞌu ra iin saa ndia chi nuu kita ña, saa ke kuu kii ña ndiko yuꞌu, ra xaa yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ndi su xiꞌna xiniñuꞌu ndoꞌo ni yu ra kundasi ni na yuuvi yoꞌo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ta kuꞌva kuu xinaꞌa ta ndixiyo ra Noé, ke kuu tu kii ña nandiko yuꞌu, ra xaa yoꞌo vichin va. ");
INSERT INTO mxv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saa chi ta ndixiyo ra Noé, ra yuvi kan ra ndakundiee na xixi na, ra xiꞌi na, ra satandaꞌa taꞌan va tu na, ra saa kuu na ndee na saa, ndia te ndixaa kii ña ndikiꞌvi ra Noé ini barca. Ra saa kuun savi ñaꞌa ra ndixiꞌi ndiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ra mii saa ke kuu tu te ndixiyo ra Lot va: saa chi xixi na, ra xiꞌi na, ra sata na, ra ndixiko na, ra xavaꞌa na veꞌe na, ra chiꞌi na, ra sakee va na. ");
INSERT INTO mxv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ndi su te kita ra Lot ñuu Sodoma, saa ra kuun va ñuꞌu xiꞌin ñuꞌu kaꞌndi, ra xaꞌni ndiꞌi va ña na. ");
INSERT INTO mxv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ra mii saa kuu tu kii ña nandiko yuꞌu ra xaa yoꞌo va kixi yu. ");
INSERT INTO mxv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ra kii kan, ra na ndee chi xini veꞌe, ra na kïꞌvi ka na veꞌe na, ña ndakiꞌin na ñaꞌa na; ra na ñuꞌu xachiñu iku, ra na nandïko ka na veꞌe na. ");
INSERT INTO mxv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ra na ndakaꞌan ndo xaꞌa ña ndoꞌo ña yasiꞌi ra Lot, saa chi sandiꞌi va Ndioxi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ra yuvi na kuni sakaku mii, ra na kan kuvi na ndiꞌi xaꞌa va; ra na xiin sandoñuꞌu mii, kuvi na kaku va. ");
INSERT INTO mxv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ra ña ndixa kaꞌan yu xiꞌin ndo, chi nuu kuu ña ñuu te xa na nandiko yu, ra tu ndee uvi na kixi nuu ixto, ra iin na kuꞌun, ra iin na ndoo va. ");
INSERT INTO mxv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ra tu uvi na siꞌi xika ndiko na, kii na ndiko yu, ra iin ña kuꞌun, ra iin ña ndoo va. ");
INSERT INTO mxv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ra tu uvi tiaa ñuꞌu xachiñu iku, ra iin ra kuꞌun, ra iin ra ndoo va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ra te ndiꞌi xini soꞌo ndia ra saa ndindakatuꞌun ndia Jesús kachi ndia saa: ―¿Ndia mii ke ku saa, Tata? ―kachi ndia xiꞌin ra. Ra saa ndakuiin ra yuꞌu ndia kachi ra saa: ―Ra xa kundaa va ini ndo chi ndia ndia ka mii nuu ndee kiti ndìì, ra ikan ke ndakutaꞌan pilo ndee va ri ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ra saa ndikaꞌan Jesús iin tuꞌun ndichi xiꞌin ndia itaꞌan xiꞌin ra, ña xiniñuꞌu ni kaꞌan ndia xiꞌin Ndioxi iin ndisaa kii, ra na ndïko ini ndia. ");
INSERT INTO mxv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ra saa ndikaꞌan ra kachi ra saa: ―Ndixiyo iin ñuu kaꞌnu ra ikan ndixiyo iin ra juez ra ndixätoꞌo ra Ndioxi, ra nii yuvi ndixätoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ra suvi mii ñuu kan ndixiyo tu iin ñaꞌa ña ndukuaan va, ra kanitaꞌan na xiꞌin ña, ra ndixaꞌan ña kaꞌan ña xiꞌin ra juez kan ña na sayukun ra kuachi xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ra kuaꞌa ni ichi ndixaꞌan ña nuu ra, ndi su ndixïin ra sayukun ra kuachi xiꞌin ña. Ra te ndiꞌi saa vi ndakani ini ra kaꞌan ra saa: “Vaꞌa ni xätoꞌo yo Ndioxi, ra nii xätoꞌo yo yuvi va, ");
INSERT INTO mxv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ra xaꞌa ña sandiꞌi ni ñaꞌa yoꞌo yoo, ra na sayukun va yo kuachi xiꞌin ña ra na sandïꞌi ka ña yoo”, kaꞌan ra juez kan ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ra saa ndikaꞌan Jesús kachi ra saa: ―Suꞌva ke xa ra juez ra iku ni kan. ");
INSERT INTO mxv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ra kachi ka vi tu Ndioxi, ¿a sandäku ra kuachi xiꞌin na ndikaxin ra tu na kaꞌan na xiꞌin ra ñuu kaꞌñu? ¿Ra a naꞌa ni vi sa ndakuiin ra tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi kama ni va sandaku Ndioxi kuachi xiꞌin na. Ndi su te xa na ndiko yuꞌu ra xaa yoꞌo vichin kixi yu, ¿ra a ndaniꞌi yu yuvi na ndiaa ini yuꞌu? ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ra saa ndatuꞌun Jesús inka tuꞌun ndichi xaꞌa yuvi na ndasavaꞌa ni mii, ra kundasi na inka na, ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Saa kuu ra ndixaꞌan uvi tiaa veꞌe ñuꞌu kaꞌan ndia xiꞌin Ndioxi. Ra iin ra kuu fariseo, ra inka ra ku ra kaya xuꞌun ndaꞌa na ñuu, ña kuaꞌan Roma. ");
INSERT INTO mxv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ra saa ndixaa ra fariseo kan, xikundichi ra ini veꞌe ñuꞌu, ra xaꞌa kaꞌan ra xiꞌin Ndioxi kachi ra saa: “Tata, taxi ni yu tixaꞌvi ndaꞌa kun, saa chi kuëe iyoo yu ta kuꞌva iyoo na kuiꞌna, na ndivaꞌa, ra nii xïka yu xiꞌin inka ñaꞌa; ra ni kuëe iyoo yu ta kuꞌva iyoo tiaa ra kaya xuꞌun yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yuꞌu, ra uvi kii xïxi yu iin semana; ra soko yu nuu xuꞌun ña xakanaa yu”, kachi ra fariseo kan xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ndi su tiaa ra kaya xuꞌun kan, ra xika va xikundichi ra. Ra nii ndixäa ndiee ini ra ña ndoniꞌi ra nuu ra ndivi, chi ndika va ra kani ndaꞌa ra kachi ra saa: “¡Tata Ndioxi, na kundaꞌvi ini kun kuni kun yuꞌu. Saa chi yuꞌu, ra iyoo ni kuachi yu!”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ra ña ndixa kaꞌan yu xiꞌin ndo, chi xa kaꞌnu va ini Ndioxi xini ra ra kaya xuꞌun kan. Ndi su ndixakäꞌnu vi ini ra xaꞌa ra fariseo kan. Ra ña kan ke takundiꞌi yuvi na xa ni̱nù ni xiꞌin mii kuvi na nduvali va, ra na xa ni̱nu̱ xiꞌin mii kuvi na ndunaꞌnu va ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ra saa ndixaa sava na xiꞌin na vali seꞌe na nuu iin Jesús, ña na chinduꞌu ra ndaꞌa ra sata na vali kan, ra kaꞌan ra xiꞌin Ndioxi xaꞌa na kuni na. Ra te xini ndia itaꞌan xiꞌin Jesús ra saa xaꞌa ndia ndukueꞌe va ndia xiꞌin na ndixaa xiꞌin na kuachi vali kan. ");
INSERT INTO mxv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ra saa kana Jesús na kuachi vali kan ña na kuyachin na nuu ra, ra ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Saña ndo na vali ña na kixi na nuu yu, ra säsi ndo nuu na. Saa chi na iyoo ta kuꞌva iyoo na kuachi vali yoꞌo ku na kuchuun koo nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi tu na ndakïꞌin yuvi ichi Ndioxi ra sa na ta kuꞌva xa na kuachi vali, saa ra kuchüun vi na koo na nuu xaꞌndia Ndioxi chiñu ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ra saa kuu ra ndindakatuꞌun iin ra itia ra kuika ra kuu ra xikuaꞌa Jesús kachi ra saa: ―Tata Maestro, ra vaꞌa, ¿ni ke sa yu ña vaꞌa niꞌi taꞌvi yu kutiaku yu xiꞌin Ndioxi ndiaa ndikaa ndikuꞌun? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―¿Nichuun kaꞌan kun “ra vaꞌa” xiꞌin yu?, saa chi köo ndia nii yuvi na vaꞌa, chi indaa mituꞌun Ndioxi va ku ra vaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ra xa xini va kun ndiayu Ndioxi ña kaꞌan kachi suꞌva: “Kïꞌvi kun xiꞌin yasiꞌi inka tiaa, käꞌni kun ndii, xakuïꞌna kun, ra chikäa siki kun kuachi inka na; ra na satoꞌo kun iva kun xiꞌin siꞌi kun” ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ra saa ndakuiin ra kuika kan kachi ra saa xiꞌin ra: ―Tata, ta loꞌo vi yu xaꞌa yu kandixa ndiꞌi yu ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ra te ndiꞌi xini soꞌo Jesús ña ndikaꞌan ra, ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ra: ―Iyoo ka va iin ña kumani nuu kun: Xiko takundiꞌi ñaꞌa ña iyoo nuu kun, ra ndataꞌvi kun xuꞌun xiꞌin na ndaꞌvi, ra saa ke taxi Ndioxi ña kuika ña iyoo ndivi ndaꞌa kun vaxi kii. Ra te xa na ndiꞌi, ra na kixi kun kundikun kun yuꞌu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ra te ndiꞌi xini soꞌo ra kuika kan, saa ra kusuchi ni ini ra saa chi kuika ni ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ra te xini Jesús ña kusuchi ni ini ra kuika kan, ra saa ndikaꞌan ra kachi ra saa: ―¡Tiaa ni uꞌvi kiꞌvi na kuika ndivi nuu xaꞌndia Ndioxi chiñu! ");
INSERT INTO mxv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ra üꞌvi ka vi kiꞌvi iin camello yavi loꞌo xaꞌa tiku, nuu ña kiꞌvi iin ra kuika ichi nuu xaꞌndia Ndioxi chiñu ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ra saa ndikaꞌan na xini soꞌo, ña ndikaꞌan Jesús kachi na saa: ―Tu saa va ke iyoo ña, ¿ra yoo va ku na kuchuun kaku tu saa? ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Nuu na yuuvi yoꞌo va ke uꞌvi ni ña yoꞌo, ndi su nuu Ndioxi ra köo ña uꞌvi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ra saa ndikaꞌan ra Pedro xiꞌin Jesús kachi ra saa: ―Tata, nduꞌu, ra ndakoo ndiꞌi va ndi ñaꞌa ndi, ra ndakundikun ndi yoꞌo, xika ndi xiꞌin kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ña ndixa kaꞌan yu xiꞌin ndo: chi takundiꞌi yuvi na ndakoo veꞌe, na ndakoo iva, na ndakoo ñani, na ndakoo yasiꞌi, na ndakoo seꞌe xaꞌa ña ndikun na ichi Ndioxi, ");
INSERT INTO mxv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ra kuaꞌa ni ka va ña vaꞌa ndakiꞌin na kan nuu Ndioxi nuu ña yuuvi yoꞌo vichin, ra niꞌi tu na ña kutiaku na ndia ndikaa ndikuꞌun va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ra saa ndikaꞌan Jesús xiꞌin uxi uvi saa ndia itaꞌan xiꞌin ra kachi ra saa: ―Vichin ke kuꞌun yo ñuu Jerusalén, ra ikan ku nuu xinu ndiꞌi nuu tuꞌun ña tiaa na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi xinaꞌa xaꞌa yuꞌu ra xaa yoꞌo vichin. ");
INSERT INTO mxv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ra ikan ku nuu ndataxi na yuꞌu ndaꞌa yuvi na xïni Ndioxi, ra sasiki na yuꞌu, ra kaꞌan ñaa na xiꞌin yu, ra kondiaa na tiasiꞌi na nuu yu. ");
INSERT INTO mxv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ra kani ni na yuꞌu, ra kaꞌni na yuꞌu, ndi su kii uni ra ndatiaku va yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ndi su ndia itaꞌan xiꞌin ra ra ndikundäa vi ini ndia xiꞌin tuꞌun yoꞌo, ra nii ndikundäa tu ini ndia ni xaꞌa ke kaꞌan ra xiꞌin va ndia, saa chi tuꞌun ña kundäa ini ndia xiꞌin va ke ndikaꞌan Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ra ta kuyachin Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra nuu ñuu Jericó kan, ra yuꞌu ichi kan nduꞌu iin ra kuaa ña ndakan ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ra ta xini soꞌo ra kuaa kan ña yaꞌa ni yuvi kuaꞌan na ichi kan. Ra saa ndindakatuꞌun ra kachi ra saa: ―¿Ni ke kuu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Saa ndakuiin na kachi na saa xiꞌin ra: ―Jesús, ra ke̱e ñuu Nazaret va ku ra yaꞌa kuaꞌan ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ra saa xaꞌa ra iin kokoꞌo kana ra kachi ra saa: ―¡Jesús, seꞌe xikua ra rey David, kundaꞌvi ini kuni yuꞌu! ―^kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ra saa nindaꞌyu na inuu kuaꞌan kan nuu ra, ña na koo taxin yuꞌu ra, ndi su ra ndiee ka nindaꞌyu va kuvi ra kachi ra saa: ―¡Jesús seꞌe xikua ra rey David, kundaꞌvi ini kuni yuꞌu! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ra saa xikundichi Jesús, ra xaꞌndia ra chiñu nuu na ña na kuꞌun na ndakiꞌin na ra. Ra ta xaa na xiꞌin ra kuaa kan, ra saa ndindakatuꞌun Jesús ra kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ni ke kuni kun sa yu xiꞌin kun? ―kachi ra. Saa ndakuiin ra kuaa kan kachi ra saa: ―Tata, na ndanuña nuu yu ra vaꞌa kotoꞌni yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―¡Kotoꞌni! Chi xaꞌa ña kandixa va kun ke nduvaꞌa kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Saa ra ndikun ndanuña va nuu ra kuaa kan ra vaꞌa va ndakoto ra. Saa ra ndakundikun ra kuaꞌan ra xiꞌin Jesús va, ra ndasakaꞌnu ka vi ra Ndioxi kuaꞌan ra. Ra takundiꞌi yuvi na xini ña kuu xiꞌin tiaa kan, ra ^ndasakaꞌnu ni tu na kan va Ndioxi kuaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ra ta ndixaa Jesús ñuu Jericó ra saa ndikiꞌvi ra maꞌnu ñuu kan kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ra ñuu kan iyoo iin ra kuika ra nani Zaqueo. Ra ra kuchee kuvi ra nuu na kaya xuꞌun kuaꞌan ndaꞌa gobierno. ");
INSERT INTO mxv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ra kuni ni ra kuni ra Jesús, ndi su ndiküvi kuni ra ra, saa chi kuiti ni ra, ra kusiin tu kuaꞌa ni yuvi kuaꞌan va ra na kan va xisaꞌvi nuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ra saa ndakosonuu ra xinu ra kuaꞌan ra chi nuu, ra ikan ndaa ra ndaꞌa iin itun, tu nani sicómoro ña vaꞌa kuni ra yaꞌa Jesús, saa chi mii ikan ke yaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ra ta xa yaꞌa Jesús kuaꞌan ra nuu iin itun kan, ra saa ndakoto ndiaa ra ndaꞌa nuu ra xini ra ra Zaqueo, ra ndikaꞌan xiꞌin ra kachi ra saa: ―Zaqueo, kama ni nuu kun, saa chi veꞌe kun ke xiniñuꞌu koo yu vichin ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Saa ra ndikun nuu ndixa va ra Zaqueo, ra tiaa ni kusii ini ra ña ndakiꞌin ra Jesús kuaꞌan ra xiꞌin ra veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ra ta xini yuvi kan ña ndakiꞌin Jesús kuaꞌan ra xiꞌin ra Zaqueo, saa ra xaꞌa na kañaꞌa na xaꞌa ra kachi na saa: ―¿Nichuun kuaꞌan Jesús veꞌe ra Zaqueo? Saa chi süvi ra vaꞌa kuvi ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ra ta xa ndee ndia veꞌe ra Zaqueo, ra saa ndakundichi ra Zaqueo ra ndikaꞌan ra xiꞌin Jesús kachi ra saa: ―Tata, na kundaa ini kun chi kuni yu ndataꞌvi yu iin sava ñaꞌa ña iyoo nuu yu xiꞌin na ndaꞌvi. Ra tu ndia na sandaꞌvi yu, ra viꞌi ka va xuꞌun ndakiꞌin yu ndaꞌa na, ra ndia kumi va ichi sandiko yu ña ndaꞌa na vichin ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Saa ndikaꞌan Jesús xaꞌa ra Zaqueo nuu takundiꞌi na ndee kan kachi ra saa: ―Kii vichin ke xa sakaku Ndioxi ra yoꞌo, xiꞌin na veꞌe ra. Saa chi ndiseꞌe ra Abraham kuvi tu ra yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Saa chi yuꞌu ra xaa yoꞌo vichin, kuvi ra xaa ndanduku na nindoñuꞌu, ra sakaku yu na ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ra nani saa kuu yuvi kan xini soꞌo na ña ndatuꞌun Jesús xiꞌin na ña kuaꞌan na ichi kan, ra ta xa kuyachin ra xiꞌin na nuu ñuu Jerusalén kan, ra saa ndikaꞌan ra inka tuꞌun ndichi xiꞌin na, saa chi xaꞌa na ndakani ini na kaꞌan na saa: “Xa ninumi ni va kaꞌndia Ndioxi chiñu nuu yo”, kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ña kan ke ndikaꞌan ra xiꞌin na, kachi ra saa: ―Suꞌva ndoꞌo iin ra kuika, ra ndasavii kee kuꞌun inka ñuu xika, nuu tiaꞌndia xaꞌa ra ña kuu ra rey, ra te xa na ndiꞌi, saa nandiko ra ndaxaa ra ña kaꞌndia ra chiñu nuu na ñuu ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ra te xa ndinumi kuꞌun ra, saa ndakana ra uxi tiaa ndia xachiñu nuu ra, ra iin iin xuꞌun kàà ña viꞌi ni ndiaka taxi ra ndaꞌa ta mituꞌun ta mituꞌun ndia ra ndikaꞌan ra xiꞌin ndia kachi ra saa: “Na sachiñu ndo xiꞌin xuꞌun yu, ra na ndukuaꞌa ña, ra te xa na nandiko yu saa ndakiꞌin yu ña ndaꞌa ndo”, kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ndi su na ñuu ra, ra kundasi ni va na ra, ra ndiküni na ña kaꞌndia ra chiñu nuu na, ña kan ke tiꞌvi na ndia kumisio ra ndikun ndia ndixaꞌan ndia sata ra, ra ndikaꞌan ndia xiꞌin mii ra rey ra xaꞌndia chiñu nuu ra, kachi ndia saa: “Küni ndi ña kuu ra yoꞌo rey ra kaꞌndia ra chiñu nuu ndi”, kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Ra vaꞌa ni ndikaꞌan ni va na ña küni na kaꞌndia ra chiñu nuu na, ndi su xa saa ndakiꞌin va ra ña kuu ra rey. Ra te ndiꞌi ndakiꞌin ra chiñu, saa nandiko ra ndaxaa ra ñuu ra, ra saa ndakana tuku ra ndia xachiñu nuu ra, ña kuni ra kundaa ini ra nisaa ke ndiniꞌi ta iin iin ndia siki xuꞌun ña taxi ra ndaꞌa ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ra saa xaa ra nuu, ra ndikaꞌan ra, kachi ra saa: “Tata, xuꞌun ña taxi kun ndaꞌa yu, ra inka uxi xuꞌun ndiniꞌi yu siki ña”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Saa ndakuiin ra rey kan, kachi ra saa xiꞌin ra: “Vaꞌa ni va xa kun, iin tiaa ra vaꞌa ni xachiñu kuvi kun, ra xaꞌa ña vaꞌa ni xachiñu kun xiꞌin ña loꞌo taxi yu ndaꞌa kun, ke ndasa yu yoꞌo iin ra chiñu chee ra kaꞌndia kun chiñu nuu uxi ñuu naꞌnu vichin”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ra saa xaa ra uvi, ra ndikaꞌan ra, kachi ra saa: “Tata, xuꞌun ña taxi kun ndaꞌa yu, ra uꞌun ka xuꞌun ndiniꞌi yu siki ña”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Saa ndakuiin ra rey kan, kachi ra saa xiꞌin ra: “Vaꞌa ni xa kun, ra xaꞌa ña vaꞌa ni xachiñu kun, ke ndasa tu yu yoꞌo iin ra chiñu chee ra kaꞌndia kun chiñu nuu uꞌun ñuu naꞌnu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ra saa xaa inka ra, ra ndikaꞌan ra kachi ra saa: “Tata, yoꞌo iyoo xuꞌun ña taxi kun ndaꞌa yu. Ra na ndakiꞌin kun ña. Chi tikoto va chikuꞌni yu ña ra nditiseꞌe yu ña ña vaꞌa va nindïꞌi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Saa chi ndiyuꞌvi yu ndoñuꞌu ña, ra xa xini va yu yoꞌo ña kuu kun iin tiaa ra ndaku ni ini, chi tu ndindoñuꞌu ña, ra xa saa ndachaꞌvi va yu ña nuu kun, saa chi yoꞌo, ra ndakiꞌin kun ñaꞌa nuu nditäxi kun ña, ra sakee kun nuu ndichïꞌi va kun,” kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ra saa ndakuiin ra rey kan, kachi ra saa: “Yoꞌo, ra süvi tiaa ra vaꞌa xachiñu kuvi kun, ra xiꞌin mii tuꞌun ña kaꞌan kun ke sayukun yu kuachi xiꞌin va kun. Saa chi xa xini va kun yuꞌu, ña kuu yu iin tiaa ra ndiee ni ini, chi ndakiꞌin yu ñaꞌa, nuu nditäxi yu ña, ra sakee tu yu nuu ndichïꞌi va yu, ");
INSERT INTO mxv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿ra nichuun ndixäꞌan kun chikaa kun xuꞌun yu nuu sakuaꞌnu na xuꞌun, ra xa ndukuaꞌa va siki ña ndakiꞌin yu ña ndaxaa yu veꞌe yu vichin?”, kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ra saa ndikaꞌan ra rey kan xiꞌin ndia ndita kan, kachi ra saa: “Kindiaa ndo xuꞌun ndaꞌa ra ñaa, ra ndataxi ndo ña ndaꞌa ra xa iyoo uxi ña nuu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Saa ndakuiin ndia kan, kachi ndia saa xiꞌin ra: “Tata, ¿nichuun taxi ka ndi ña ndaꞌa ra? Ra xa uxi vi ku xuꞌun ra”, kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ra saa ndakuiin ra rey kan, kachi ra saa: “Na xa iyoo ña nuu, ra niꞌi ka na taꞌan va ña; ra na köo ña nuu, ra ndia ña loꞌo iyoo nuu na ke nundiaa ndaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ra na sáa̱̱ ini xini yuꞌu, na ndixïin ña kuu yu rey ra kaꞌndia yu chiñu nuu na, ra na sayaꞌa ndo na choꞌo, ra xitoꞌni yu saa na kaꞌni ndo na, kachi ra rey kan, kachi tuꞌun ndichi yoꞌo”, kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ta sandiꞌi Jesús ndatuꞌun ra xiꞌin na, ra saa ndakiꞌin ra kuaꞌan ra chi ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ra ta kuaꞌan kuyachin ra nuu ñuu Betfagé xiꞌin ñuu Betania, yachin nuu ndikaa iku ña olivo, ra saa ndikaꞌan ra xiꞌin uvi ndia itaꞌan xiꞌin ra, ");
INSERT INTO mxv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kachi ra saa: ―Kuaꞌan ndo ñuu loꞌo ña ndikaa yachin kaa ra ta ndikiꞌvi ndo kan kuaꞌan ndo, ra ikan kuni ndo nuꞌni iin burru loꞌo ri täan koso na. Ra ndaxi ndo ri na kixi ri xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ra tu ndia na ndakoyo kaꞌan xiꞌin ndo: “¿Nichuun ndaxi ndo ri?”, kachi na, ra kaꞌan ndo xiꞌin na xiꞌin na kachi ndo saa: “Tata yo Jesús kuvi ra kuniñuꞌu ri”, kachi ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ra saa ndakiꞌin ndia itaꞌan xiꞌin ra kuaꞌan ndia, ra iin ta iyoo ña ndikaꞌan ra xiꞌin ndia, ra iin saa ke kuu ndixa va. ");
INSERT INTO mxv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ra sakan saa kuu ndia ndaxi ndia ri, saa ra ndakoyo va na xiꞌin sana ri, ra ndikaꞌan na xiꞌin ndia, kachi na saa: ―¿Nichuun ndaxi ndo burru loꞌo ñaa? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ra saa ndakuiin ndia yuꞌu na, kachi ndia saa: ―Tata yo kuniñuꞌu ri, ña kan ke ndaxi ndi ri ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ra saa ndakiꞌin ndia ri kuaꞌan ri xiꞌin ndia, ra ta ndixaa ndia xiꞌin ri nuu iin Jesús, ra saa tiso ndia tikoto sata ri, ra saa sandaa ndia ra sata ri. ");
INSERT INTO mxv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ra iinii kuvi ichi nuu yaꞌa Jesús kuaꞌan ra, xakin na tikoto. ");
INSERT INTO mxv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ra ta kuyachin ra vaxi nuu ra xaꞌa iku Olivo, ra saa xaꞌa kusii ka vi ini takundiꞌi na itaꞌan xiꞌin ra, ra ndikun na sata ra, ra xaꞌa na ndasakaꞌnu na Ndioxi xaꞌa takundiꞌi ña vaꞌa xa ra xini na. ");
INSERT INTO mxv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ra xaꞌa na ndaꞌyu na kachi na saa: ―¡Ra ña vaꞌa na koo xiꞌin yoꞌo, ra vaxi xiꞌin kivi Tata yo Ndioxi! ¡Ra ña kaꞌnu, xiꞌin ña vaꞌa na koo xiꞌin na iyoo ndivi! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ra tiañu yuvi kan ñuꞌu sava ndia fariseo kuaꞌan ndia xiꞌin na, ra saa ndikaꞌan ndia xiꞌin Jesús, kachi ndia saa: ―Tata Maestro, kaꞌan xiꞌin na itaꞌan xiꞌin kun ra na koo taxin yuꞌu na ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Tu na kaꞌan yu xiꞌin na ña kutaxin yuꞌu na, saa ra xaꞌa yuu ña ndee ñaa ndaꞌyu va ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ra te ndixaa Jesús nuu ñuu kaꞌnu Jerusalén, ra saa ndakoto ndiaa ra nuu ñuu kan, saa ra xaku va ra xaꞌa na ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ra saa ndikaꞌan ra kachi ra saa: ―¡Tu ndo xiin vi kuvi ndo ña ndakiꞌin xini ndo, saa ra kundaa va ini ndo ña kuni Ndioxi sa ra ña vaꞌa xiꞌin ndo! Ndi su xïin ndo. Ra ña kan ke iyoo seꞌe va ña vaꞌa kuni Ndioxi sa ra xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Saa chi vaxi kii, ra kixi na sáa̱̱ ini xini ndoꞌo, ra iin kununduu va na ndoꞌo, ra ndakasi va na ichi nuu ndo, ra küvi ka kunu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ra kaꞌni ndiꞌi va na seꞌe vali ndo, ra ndia nii nuu ndita veꞌe ndo ke kuñäꞌa ka vi; saa chi ndixïin ndo ña sakaku yu ndoꞌo, kii ña xaa yu sakaku yu ndoꞌo vichin ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ra te ndixaa Jesús ñuu Jerusalén, ra ndikiꞌvi ra ini korra veꞌe ñuꞌu kaꞌnu kan kuaꞌan ra, ra saa xaꞌa ra tava ra takundiꞌi na ndee ndaxiko kan, ra saa tu na sata nuu va na. ");
INSERT INTO mxv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ra saa ndikaꞌan ra kachi ra saa xiꞌin na: ―Tuꞌun Ndioxi ña tiaa na xinaꞌa ra suꞌva va ke kachi ña: “Veꞌe yu, ra veꞌe nuu kaꞌan takundiꞌi na xiꞌin Ndioxi va ke kuu ña.” Ndi su ndoꞌo, ra kava nuu ndakutaꞌan na kuiꞌna va ndasa ndo ña ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ra iin takundiꞌi kii ndixaꞌan Jesús veꞌe ñuꞌu kaꞌnu kan sañaꞌa ra yuvi, ra na xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin na xikuaꞌa kunaꞌnu nuu na ñuu, ra ndakundiee va ndia xika ndia nduku ndia kuꞌva ña kuchuun ndia kaꞌni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ndi su ndinïꞌi vi ndia ndia kuꞌva ke kuchuun ndia ña kaꞌni ndia ra, saa chi iin takundiꞌi va na ñuu ndinuni ni xini soꞌo ña sañaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Saa kuu iin kii íin Jesús ini veꞌe ñuꞌu kaꞌnu sañaꞌa ra yuvi ña ndakani ra tuꞌun Ndioxi nuu na. Ra saa ndixaa ndia xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, xiꞌin ndia xikuaꞌa ñuu kan, ");
INSERT INTO mxv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ra ndikaꞌan ndia xiꞌin ra, kachi ndia saa: ―Kaꞌan xiꞌin ndi, ¿yoo taxi ndiayu ndaꞌa kun ña ^xa kun ña yoꞌo, ra nii ndiayu ku mii kun ña xa kun saa? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Kuni tu yuꞌu va ndakatuꞌun yu ndoꞌo, ra na ndakuiin ndo yuꞌu yu. ");
INSERT INTO mxv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yoo taxi ndiayu ndaꞌa ra Juan ña sakuchi ra yuvi? ¿Ndioxi taxi ña ndaꞌa ra, a na yuuvi yoꞌo va? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ra saa xaꞌa ndia kaꞌan ndia xiꞌin taꞌan ndia, kachi ndia saa: ―¿Ni ke kachi yo xiꞌin ra? Chi tu na kaꞌan yo: “Ndioxi va kuvi ra taxi ndiayu ndaꞌa ra”, saa ra kachi ra saa xiꞌin yo: “¿Nichuun ndikandïxa tu ndo ña ndikaꞌan ra tu saa”?, kachi ra xiꞌin yo. ");
INSERT INTO mxv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ra tu na kachi tu yo: “Na yuuvi yoꞌo va kuvi na taxi ndiayu ndaꞌa ra”, saa ra, iyo ni kaꞌni na yoo xiꞌin yuu. Saa chi takundiꞌi na ñuu, ra kandixa va na ra Juan ña kuu ra, ra ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi ―kachi ndia kunaꞌnu kan xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ra saa ndakuiin ndia, kachi ndia saa xiꞌin Jesús: ―Xïni ndi yoo kuvi na taxi ndiayu ndaꞌa ra Juan ña sakuchi ra yuvi ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Saa ndikaꞌan Jesús, kachi ra saa xiꞌin ndia: ―Saa ra nii yuꞌu ndatüꞌun tu xiꞌin ndoꞌo va, yoo taxi ndiayu ndaꞌa yu ña xa yu ña yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ra saa xaꞌa tuku Jesús ^ndatuꞌun ra inka tuꞌun ndichi xiꞌin yuvi kan, kachi ra saa: ―Suꞌva ndoꞌo iin tiaa, ra ndataan teꞌe uva nuu iin ñuꞌu kaꞌnu, ra te ndiꞌi ndataan ra ña, ra saa satatu ra ña inka yuvi, ra ndakiꞌin ra kuaꞌan ra inka ñuu xika va, ra naꞌa ni va koo ra kan. ");
INSERT INTO mxv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ra te nditandiaa kii ña tiaꞌndia uva, ra saa tiꞌvi ra iin ra xachiñu nuu ra, ña kuaꞌan ra nuu na tatu too ñuꞌu kan ña na ndataxi na loꞌo kuenda ra. Ndi su na tatu ñuꞌu nuu iyoo teꞌe uva kan, ra ndukuiin na tiin na ra xachiñu nuu ra, ra kani na ra, ra sandiko vichi na ra kuanuꞌu ra nuu xitoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ra saa tiꞌvi tuku ra xitoꞌo ñuꞌu kan inka ra xachiñu nuu ra kuaꞌan ra nuu na, ra saa xa tu na xiꞌin ra kan va, chi ndukuiin na tiin na ra, ra kani ka vi na ra, ra kundivaꞌa ka vi na xiꞌin ra, ra saa sandiko vichi na ra kuanuꞌu ra nuu xitoꞌo va ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ra saa tiꞌvi tuku va ra xitoꞌo ñuꞌu kan, ra xachiñu nuu ra, ra uni, ña kuaꞌan ra nuu yuvi kan, ra sa xa tu na xiꞌin ra kan va, chi ndukuiin na kanitaꞌan na xiꞌin ra, ra iin satakueꞌe ndiꞌi na ra, ra saa taxi na ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ra saa xaꞌa ndakani ini ra xitoꞌo ñuꞌu kan, kaꞌan ra saa: “¿Ni ke sa yo vichin? Ra vaꞌa ka va na tiꞌvi yo seꞌe yo, ra kuꞌvi ni ini yo xini yo, kuꞌun ra nuu na. Ra ta xa na xaa ra nuu na, ra iin ña saa satoꞌo va na ra”, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ndi su te xini na tatu too ñuꞌu nuu yoo teꞌe uva kan, ña ^xaa ra, ra saa ndikaꞌan na xiꞌin taꞌan na kachi na saa: “Ra yoꞌo kuvi ra ndoo ndiꞌi ña yoꞌo ndaꞌa. Ra naꞌa ndo vichin, ra na tiin yo ra, ra kaꞌni yo ra, ra ñaꞌa mii yo nduu ndiꞌi va ña yoꞌo”, kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ra saa tiin ndixa va na ra, ra xaꞌni va na ra, ra saa tava na ra nuu ñuꞌu iva ra, ra ndixaꞌan na sakana na ra ―kachi Jesús xiꞌin na. Saa ndikaꞌan ka Jesús xiꞌin na ndee xini soꞌo kan, kachi ra saa: ―Ta xa na xaa mii ra xiꞌin ñuꞌu ña, ¿ra ni ke sa ra xiꞌin na xaꞌni seꞌe ra, tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Su kuꞌun ra tiin ra na, ra kaꞌni ndiꞌi va ra na, ra saa ndataxi ra ñuꞌu ra ndaꞌa inka yuvi ña kondiaa na ña. Saa va ke ndoꞌo na tatu too ñuꞌu kan, kachi tuꞌun ndichi yoꞌo ―kachi Jesús xiꞌin yuvi na ndee xini soꞌo kan. Ra te kundaa ini na ni ke kachi tuꞌun ndichi kan, ra saa ndikaꞌan na, kachi na saa: ―¡Na chindiee taꞌan ndioxi xiꞌin yo ra na ndöꞌo yo ña ndoꞌo na kan! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ra saa xitoꞌni Jesús nuu na, ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―¿Ni ke kachi ndo xaꞌa tuꞌun Ndioxi ña tiaa na xinaꞌa? Chi suꞌva va ke kachi ña: Yuu ña kuñuꞌu na xavaꞌa veꞌe ta yachi ku yuu ña xiniñuꞌu vaꞌa ka va vichin. ");
INSERT INTO mxv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ra takundiꞌi na koyo sata yuu kan, ra taꞌnu ndiꞌi va na, ra takundiꞌi na ndakava mii yuu kan sata, ra kuxeꞌe ndiꞌi va na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ra saa xaꞌa ndia xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, ña xika nduku ndia tiin ndia Jesús, mii hora kan, saa chi kundaa va ini ndia, ña xaꞌa mii va ndia ke ndikaꞌan ra tuꞌun ndichi kan; ndi su nditïin vi ndia ra, saa chi ndiyuꞌvi va ndia nuu na ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ra saa tiꞌvi ndia yuvi kuaꞌan na kotonani na ra, ra yuvi kan ra nii kuëe ndañaꞌa na mii na ña iyoo na kuachi xiꞌin ra, ra ña kuaꞌan na ra ña vaꞌa na kaꞌan na xiꞌin Jesús va kuvi ña ra kaꞌan ra iin tuꞌun ña väꞌa ra niꞌi na taxi na kuachi xaꞌa ra nuu ra chiñu kuchee, kaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Saa ndixaa na ndakatuꞌun na ra, kachi na saa: ―Tata Maestro, xa kundaa ini ndi chi ndaku ni va sañaꞌa kun yuvi, ra nii ndakäxin ku na, chi iin ku ndiꞌi va na nuu kun, ra ndaku ni va sañaꞌa kun yuvi ichi Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ra kaꞌan xiꞌin ndi vichin, ¿a vaꞌa chaꞌvi ndi nuu ra tata chiñu César ñuu Roma, xuꞌun ña nduku ra nuu ndi, a väꞌa? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ndi su Jesús ra xa kundaa va ini ra ña kuni ndia sandaꞌvi ndia ra, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿Nichuun xa maña ndo ra xitondoso ndo yuꞌu? ");
INSERT INTO mxv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Taxi ndo iin xuꞌun kaa ndaꞌa yu na kuni yu ―kachi ra xiꞌin ndia. Ra saa taxi ndia ña ndaꞌa ra, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¿Yoo naꞌna ke nduꞌu nuu xuꞌun yoꞌo, ra yoo kivi ke ndoso nuu ña? ―kachi ra. Ra saa ndakuiin ndia, kachi ndia saa: ―Naꞌna ra César, ra kivi tu ra ke ndoso nuu va ña ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ra saa ndakuiin ra, kachi ra saa: ―Tu saa, ra na taxi ndo ñaꞌa ra César ndaꞌa va ra, ra ña kuu kuenda Ndioxi, na taxi ndo ndaꞌa Ndioxi va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndia saa ra nii ndiniꞌi ndia ni ke sa ndia xiꞌin ra, saa chi ndia nii tuꞌun kiꞌvi ndikäꞌan ra nuu chitu yuvi kan, saa ra tiaa ni ndakanda ini na xiꞌin tuꞌun ña ndakuiin ra yuꞌu ndia, ndia saa ra kutaxin yuꞌu va ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ra te ndiꞌi, saa ndixaꞌan sava ndia saduceo nuu Jesús. Ra ndia kan, ra kuëe kandixa ndia ña ndatiaku na ndii, ra xaꞌa ña kan ndindakatuꞌun ndia ra kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tata Maestro, ndiayu Ndioxi ña ndakoo ra Moisés ndaꞌa ndi ra suꞌva va kachi ña: “Tu iin tiaa ra iyoo yasiꞌi ra, ra ndikäku seꞌe ra xiꞌin ña, ra ndixiꞌi va ra, saa ra xiniñuꞌu na ndakiꞌin inka ñani ra ñaꞌa kan, saa ra, ta xa na kaku seꞌe ña, ra ta iyoo seꞌe ra ndixiꞌi kan va, na koo ña kaku kan”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ra suꞌva ke kuu xiꞌin iin veꞌe, uxa tiaa xikuu ndia veꞌe ndia. Ra saa kuu ra nditandaꞌa va iin ñani ndia ra chee, ra ndia nii seꞌe ra ndikäku xiꞌin yasiꞌi ra, ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ra saa ndakiꞌin ña inka ñani ra, ra ndikun sata ra, ra ndixiꞌi tu ra kan va, ra ndikäku tu seꞌe ra kan va xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ra saa ndakiꞌin ña inka tuku va ra, ra ndixiꞌi tu ra uni kan va, ra uxa saa ndia xinduꞌu ña xiꞌin va, ra ndixiꞌi uxa saa va ndia; ra ndia nii ndia ndikäku seꞌe ña xiꞌin vi. ");
INSERT INTO mxv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndia saa ra ndixiꞌi tu mii va ña. ");
INSERT INTO mxv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ña kan ke kuni ndi ndakatuꞌun ndi yoꞌo vichin, ta xa na ndatiaku ndia kan, ¿ra yoo kuu iin ndia kuu yii ña, chi xinduꞌu ña xiꞌin uxa saa va ndia? ―kachi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ra saa ndakuiin ra, kachi ra saa xiꞌin ndia: ―Na ndee ña yuuvi yoꞌo vichin va kuvi na tandaꞌa. ");
INSERT INTO mxv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ndi su na taxi Ndioxi ndiayu ndatiaku, ra koo na xiꞌin ra ndivi, ra tandäꞌa ka vi na kan. ");
INSERT INTO mxv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ra nii küvi ka va tu na. Saa chi xa ta iyoo na tatun Ndioxi va ke koo na, ra seꞌe Ndioxi va kuu na saa chi ndiatiaku va na. ");
INSERT INTO mxv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ra ña kaꞌan ndo xaꞌa ña ndatiaku na ndii, ra na kundaa ini ndo, chi xa mii tuꞌun Ndioxi ña tiaa ra Moisés xinaꞌa vi ke ndakani nuu yo xaꞌa ña ndatiaku na ndii. Ra suꞌva ke kachi Ndioxi ndikaꞌan ra xiꞌin ra Moisés ta xini ra xixi itun ìñu̱ kan: “Yuꞌu kuu Ndioxi ra Abraham, xiꞌin ra Isaac, xiꞌin ra Jacob”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ña kan ke na kundaa vaꞌa ini yo. Chi Ndioxi, ra Ndioxi na tiaku va kuvi ra. Ra süvi Ndioxi na ndii kuvi ra, ra nuu ra kan ra tiaku takundiꞌi va na xa ndixiꞌi ―kachi Jesús xiꞌin ndia saduceo. ");
INSERT INTO mxv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ra saa ndakuiin sava ndia maestro sañaꞌa ndiayu Ndioxi ndee kan, kachi ndia saa: ―Tata Maestro, vaꞌa ni va ndikaꞌan kun ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ndia saa, ra ndia nii ka na ndixäa ndiee ini ña ndakatuꞌun ka na Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Saa ndikaꞌan Jesús xiꞌin na ndee kan, kachi ra saa: ―¿Ndixaa iyoo ña tuvi ndoꞌo? ¿Nichuun kaꞌan na ña kuu seꞌe xikua ra rey David ra tiꞌvi Ndioxi xaa sakaku na yuuvi yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ra ra David, ra suꞌva va tu kachi ra ndikaꞌan ra nuu tutu Salmo ña tiaa ra: Suꞌva kachi Ndioxi xiꞌin Tata yu: “Na kunduꞌu kun xiin kuaꞌa yu ");
INSERT INTO mxv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ra vaꞌa sandiꞌi yu xaꞌa takundiꞌi na iyoo kuachi xiꞌin kun”, kachi Ndioxi, kachi ra rey David. ");
INSERT INTO mxv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ndatuꞌun ndo xiꞌin yu, ¿ndixaa ke iyoo ña, ña kaꞌan ra David ña kuu iva ra, ra tiꞌvi Ndioxi kixi, ra kaꞌan tu ra ña kuu ra seꞌe va ra? ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ra saa kuu yuvi na ndee xini soꞌo ña ndakani Jesús ndee na, ra saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Kuenda ni koo ndo, ra xä ndo ta xa ndia maestro sañaꞌa ndiayu Ndioxi ña ndakoo ra Moisés, saa chi ndia kan, ra kotoo ni ndia kundixi ndia tikoto nani, ra kuni ni tu ndia satoꞌo ni yuvi ndia te ndakutaꞌan ndia xiꞌin na nuu yaꞌvi va. Ra saa tu te kuaꞌan ndia veꞌe ñuꞌu a te kuaꞌan ndia viko, ra xini sii ni ndia kundee ndia tiayu tu ndee na kunaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ra sandaꞌvi ni tu ndia na siꞌi na ndukuaan va, ra ndakiꞌin ndiaa ndia ñaꞌa ña kuu mii na ndaꞌa na. Ra ña kuni ndia kindoo vaꞌa ndia nuu na ñuu, ra naꞌa ka vi kaꞌan ndia xiꞌin Ndioxi. Ra ña xa ndia ña yoꞌo, ra chee ni ka va tundoꞌo vaxi nuu ndia sa Ndioxi ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ra saa nduꞌu Jesús ini korra veꞌe ñuꞌu kaꞌnu, ra yachin kan, íin iin ñáꞌa nuu taan na xuꞌun ña soko na. Ra xitoꞌni ra ña soko ka vi na xuꞌun, ra kuaꞌa ka vi xuꞌun soko sava na kuika. ");
INSERT INTO mxv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ra saa ndixaa iin ñaꞌá ndaꞌvi ña ndixiꞌi yii, ndisoko ña uvi xuꞌun kàà vali nuu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Saa ndikaꞌan Jesús xiꞌin na ndee kan, kachi ra saa: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi ndiaa yaꞌvi ni ka va xuꞌun ña ndisoko ña ndaꞌvi kaa nuu ña ndisoko takundiꞌi na. ");
INSERT INTO mxv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Saa chi vaꞌa ni kuaꞌa ni va ku xuꞌun soko na, ndi su ña xa ndoo ndoso nuu va na ke soko na. Ra ña ndaꞌvi kaa, ra takua ña kaa ku ndiꞌi xuꞌun loꞌo va ña, ra ndisoko ndiꞌi va ña ña nuu Ndioxi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ra saa ndikaꞌan sava ndia itaꞌan xiꞌin Jesús, xaꞌa veꞌe ñuꞌu kaꞌnu ñuu Jerusalén kan ña nduvi ni yuu kuvaꞌa ña, ra kuaꞌa ka vi ñaꞌa nduvi ndisoko na iyoo ini ña, kachi ndia. Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Veꞌe ñuꞌu kaꞌnu ña iyo ni kaa xitoꞌni ndo nuu yoꞌo, ra vaxi kii ra ña ndiꞌi xaꞌa va kuvi ña, ra ndia nii nuu ndichi ka ña ke kuñaꞌa ka vi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ra saa nindakatuꞌun ndia ra kachi ndia saa: ―Tata Maestro, ¿ama ke kuu saa? ¿Ra ni ke sa ndi ña vaꞌa kundaa ini ndi ta xa na kuyachin ndiꞌi xaꞌa ña? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Kuenda ni koo ndo ra täxi ndo sandaꞌvi na ndoꞌo. Saa chi kuaꞌa ni na kixi ra kuniñuꞌu na kivi yu ña sandaꞌvi na ndoꞌo, ra kaꞌan na xiꞌin ndo, kachi na saa: “Yuꞌu ku Cristo; ra vichin ke nditandiaa kii ndiꞌi xaꞌa ña yuuvi yoꞌo”, kachi na. Ra na kandïxa ndo na, ña ndakundikun ndo na. ");
INSERT INTO mxv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ra te xa na xaꞌa kuni soꞌo ndo ña iyoo ni kuachi, ra xaꞌa kuni soꞌo ndo ña kanitaꞌan ni yuvi, saa ra na kuayüꞌvi ndo, chi xiniñuꞌu saa ke kuu va. Ndi su süvi ña xa ndiꞌi xaꞌa kuvi ña yuuvi. ");
INSERT INTO mxv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ra saa ndikaꞌan ka ra xiꞌin ndia, kachi ra saa: ―Kuaꞌa ni ñuu ra kanitaꞌan ni ña xiꞌin taꞌan ña, ra saa tu ñuu ña naꞌnu va, chi kanitaꞌan ni tu ña kan va xiꞌin taꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ra ndiee ni taan, ra kundikaa ni soko, ra koo ni tu kueꞌe va, ra tiaa ni iyo kuu ndivi kaa, ra kuu kuaꞌa ni ña ndichi. ");
INSERT INTO mxv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ndi su ta kumani ka kuu takundiꞌi ña yoꞌo, ra saa tiin na sava ndo ra sandivaꞌa ni na xiꞌin ndo, ra taxi na ndoꞌo, ra tiin na ndoꞌo kuꞌun ndo xiꞌin na veꞌe ñuꞌu na, ra taan na ndoꞌo veꞌe kàà, ra kundiaka na ndoꞌo kuꞌun ndo xiꞌin na nuu na rey, xiꞌin nuu na kunaꞌnu xaꞌa ña ndikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ra saa ke kuvi ndatuꞌun ndo xaꞌa yu xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ra na ndïꞌi ini ndo xaꞌa tuꞌun ña ndakuiin ndo yuꞌu na, ña ndakiꞌin ndo mii ndo ndaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi yuꞌu va taxi ña xini tuni ndo, ña vaꞌa ndakuiin ndo yuꞌu na, ra ndia nii na kanitaꞌan xiꞌin ndo kuchüun ndakuiin yuꞌu ndo, ra nii nïꞌi na ni ke kachi na xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ra na kundaa ini ndo, chi ivasiꞌi ndo, xiꞌin na ñani ndo, xiꞌin na veꞌe ndo, xiꞌin na itaꞌan mani xiꞌin va ndo kuvi na xiko taꞌan xiꞌin ndo nuu na chiñu. Ra kaꞌni va na sava ndo. ");
INSERT INTO mxv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ra kundasi ni yuvi yoꞌo ndoꞌo xaꞌa ña ndikun ndo yuꞌu, ");
INSERT INTO mxv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ra na kundïꞌi ini ndo, chi ndia nii ixi loꞌo xini ndo ke ndoñüꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ña kan ke na sa ndiee ni ini ndo, ra saa ke kuchuun ndo kaku ndo. ");
INSERT INTO mxv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ra ta xa na kuni ndo, ña xa iin xinunduu ndia soldado ñuu Jerusalén, saa ra na kundaa ini ndo ña xa ndixaa kii ña ndiꞌi xaꞌa va ña. ");
INSERT INTO mxv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ra na ndee chi Judea, ra na kunu na kuꞌun na chi iku, ra na ndee ñuu kaꞌnu Jerusalén, ra na kee na kuꞌun va na, ra na ñuꞌu xachiñu iku, ra na nandïko ka na ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Saa chi kii kan ra sandoꞌo ni Ndioxi na xaꞌa ña ndikandïxa na, ra saa ke xinu nuu takundiꞌi ña kaꞌan tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ra ndaꞌvi ni na siꞌi na ñuꞌu seꞌe, xiꞌin na iyoo seꞌe vali te xa na xaa kii ña kuu ña yoꞌo! Saa chi kii kan ke sandoꞌo ni Ndioxi yuvi, ra sandaku ra kuachi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ra sava na kaꞌni na xiꞌin ichi, ra sava tu na tiin na kuꞌun xiꞌin na iin takundiꞌi ñuu xika va, ra saa kuu yuvi na xïni Ndioxi ña sandiꞌi na xaꞌa na ñuu Jerusalén, saa ra xaa tu kii ña sandiꞌi Ndioxi xaꞌa mii va na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Saa ndikaꞌan ka Jesús xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ―Ta xa na xaa kii ña ndiꞌi xaꞌa ña yuuvi yoꞌo, saa ra kuni na ña iyo ni kuu nuu ñuꞌù xiꞌin nuu yoo, xiꞌin takundiꞌi kimi; ra takundiꞌi yuvi na ndee nuu ñuꞌu yoꞌo, ra tiaa ni yuꞌvi na, ra iin sana suꞌva ini na xaꞌa ña kuni soꞌo na, ña ndiee ni iyoo kuu niꞌi yuꞌu tiañuꞌu ña kandita ra. ");
INSERT INTO mxv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ra iin ndiakua kuvi too na yuuvi yoꞌo, xaꞌa ña ndakani ini na xaꞌa ña ndiꞌi xaꞌa ña yuuvi, saa chi kuni na ña ndakanda ndiꞌi ñaꞌa ña ndee nuu ndivi. ");
INSERT INTO mxv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ra saa vi ke kuni ndo yuꞌu, ra xaa yoꞌo vichin, ña kixi yu xiꞌin takundiꞌi ndiee yu ña kaꞌnu. ");
INSERT INTO mxv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ra te xa na xaꞌa kuu takundiꞌi ña ndikaꞌan yu xiꞌin ndo, saa ra na kusii ini ndo, ra na ndoniꞌi ndo nuu ndo chi ndivi. Saa chi xa ndinumi ni kixi yu ña sakaku yu ndoꞌo, ña ndöꞌo ka ini ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ra saa ndikaꞌan ka ra iin tuꞌun ndichi xiꞌin ndia, kachi ra saa: ―Kotoꞌni ndo ta kuꞌva iyoo itun koxi xiꞌin takundiꞌi ka itun naꞌnu. ");
INSERT INTO mxv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chi te xa xaꞌa nduu itia nu, ra xaꞌa ndukuii nu, ra saa ke xa kundaa ini ndo ña xa kuyachin kii ña kuun savi va. ");
INSERT INTO mxv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ra ta xa ndo ña kundaa ini ndo xiꞌin itun ña ndukuii nu, ra mii saa ke sa tu ndo te xa na kuni ndo ña kuu takundiꞌi ña yoꞌo, saa ra xa kundaa ini ndo ña xa kuyachin Ndioxi ña kaꞌndia ra chiñu nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ra ña ndixa ke kaꞌan yu xiꞌin ndo, chi xiꞌna ka va kuu takundiꞌi ña yoꞌo, ra saa vi ke kuvi yuvi na ndee kii vichin. ");
INSERT INTO mxv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ra ndivi kaa xiꞌin ñuꞌù yoꞌo, ra ña ndiꞌi xaꞌa va kuvi ña, ndi su tuꞌun yu ra ndïꞌi xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ña kan ke kuenda ni na koo ndo, ra na sandäꞌvi ndo mii ndo, ña xaꞌa ndo ndakundiꞌi ni ini ndo xaꞌa viko ña kuxi ndo, xiꞌin ña koꞌo ndo xini ndo, ra nii na ndïꞌi ni tu ini va ndo xaꞌa ña iyoo nuu ña yuuvi yoꞌo, chi kama ni va ndakava tundoꞌo ña kuu kii kan sata ndo. ");
INSERT INTO mxv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Saa chi ta iyoo iin kuakun ña sakakuꞌun na kiti ta tiin na ri xiꞌin ña seꞌe, ra saa va ke ndoꞌo takundiꞌi yuvi. ");
INSERT INTO mxv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ña kan ke xiniñuꞌu na koo nduvi ni ndo, ra kaꞌan ni ndo xiꞌin Ndioxi iin takundiꞌi kii, ra saa ke kuvi kaku ndo nuu takundiꞌi ña kuu, ra kuchuun ndo xaa ndo nuu yuꞌu, ra xaa yoꞌo vichin ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús, ra iin takundiꞌi kaꞌñu ndixika ra veꞌe ñuꞌu kaꞌnu sañaꞌa ra yuvi, ra te ñuu ndixika ra iku ña nani olivo ndikaꞌan ra xiꞌin Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ra iin takundiꞌi ixtiaan ndixaꞌan yuvi kan ña xini soꞌo na, ña sañaꞌa ra na ini veꞌe ñuꞌu kaꞌnu kan. ");
INSERT INTO mxv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ra ta xa kuaꞌan kuyachin ni ña koo viko pascua, ta xixi na xita vaꞌa ña köo ndavi xiꞌin, ");
INSERT INTO mxv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ra saa xaꞌa ndia xikuaꞌa kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, ña xika ndia nduku ndia ndia kuꞌva ke sa ndia ña vaꞌa kaꞌni seꞌe ndia Jesús, saa chi iyuꞌvi ni va ndia nuu na ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ra saa ndikiꞌvi ti ndivaꞌa ini ra Judas, ra nani tu ra Iscariote va, ra ra yoꞌo kuvi iin ra itaꞌan xiꞌin ndia itaꞌan xiꞌin Jesús ña kuu ndia uxi uvi. ");
INSERT INTO mxv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Saa ndakiꞌin ra Judas kan ndixaꞌan ra nuu ndia kunaꞌnu nuu ndia sutu, xiꞌin nuu ndia kunaꞌnu nuu ndia kumisio ndiaa veꞌe ñuꞌu kaꞌnu, ra ndikataꞌan ra xiꞌin ndia, ndia kuꞌva ke sa ra ña vaꞌa ndataxi ra Jesús ndaꞌa ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Saa ra tiaa ni kusii ini ndia, ra kindoo ndia xiꞌin ra ña chaꞌvi ndia ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ra kindoo tu ini mii va ra ña ndikaꞌan ndia xiꞌin ra, ra saa xaꞌa ra xika nduku ra ndia kuꞌva ke sa ra ña vaꞌa ndataxi seꞌe ra Jesús ndaꞌa ndia, kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ra ta nditiandiaa kii ña kuxi na xita vaꞌa ña köo ndavi xiꞌin, ra soko tu na iin ndikachi loꞌo xaꞌa ña ndakaꞌan na ña sakaku Ndioxi na, ");
INSERT INTO mxv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ra saa ndikaꞌan Jesús xiꞌin ra Pedro, xiꞌin ra Juan, kachi ra saa: ―Kuaꞌan ndo, ra savii ndo ña kuxini yo viko pascua vichin ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Saa ndindakatuꞌun ndia ra, kachi ndia saa: ―¿Ndia mii ke kuni kun kuꞌun ndi savii ndi ña kuxini yo Tata? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―Kuaꞌan ndo chi ñuu, ra te ndikiꞌvi ndo ñuu kan kuaꞌan ndo ra ikan ndakutaꞌan ndo xiꞌin iin tiaa ra kasoko ra yoo tiakuii kuaꞌan ra. Ra kundikun ndo sata ra kuꞌun ndo ndia mii veꞌe nuu xaa ra kiꞌvi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ra ikan kaꞌan ndo xiꞌin mii ra tata xiꞌin veꞌe kan, kachi ndo saa: “Ra Tata Maestro kuvi ra kachi suꞌva: ¿Ndia mii ke íin veꞌe nuu koo yu kuxini yu xiꞌin ndia itaꞌan xiꞌin yu viko pascua vichin?, kachi ra”, kachi ndo xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ra saa ñaꞌa ra iin veꞌe chee ña piso ninu nuu ndo, ra iyoo nduvi ndiꞌi va ini ña; ra ikan ke na savii ndo ña kuxini yo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ra saa ndakiꞌin ndia kuaꞌan ndia, ra iin ta iyoo ña ndikaꞌan Jesús xiꞌin ndia, ra iin saa ndixa ke iyoo ña kuu va, ra ikan xanduvi ndiꞌi ndia chiñu ña ndikaꞌan Jesús xiꞌin ndia sa ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ra ta nditandiaa hora ña kuxini ndia, ra saa xaa Jesús xiꞌin ndia itaꞌan xiꞌin ra, ra ndakundee ndia nuu mesa ña kuxi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Tiaa ni xa kuni yu, ña kuxini yu xiꞌin ndo viko pascua yoꞌo vichin, ña kumani ndoꞌo ni yu, ra kuvi yu. ");
INSERT INTO mxv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ra na kundaa ini ndo ña kaꞌan yu xiꞌin ndo yoꞌo, chi takundiꞌi ka viko pascua ña vaxi ra köo ka yu ña kuxini yu xiꞌin ndo. Saa chi ndia na xinu kii ña kaꞌndia Ndioxi chiñu vi ke kuxini tuku yu xiꞌin ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ra saa tiin ra copa ña ñuꞌu vino, ra taxi ra taxaꞌvi ndaꞌa Ndioxi, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Kiꞌin ndo ra yoꞌo, ra loloꞌo na koꞌo takundiꞌi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ra ña ndaa kaꞌan yu xiꞌin ndo vichin, chi nandïko ka yu ña koꞌo yu nduxi uva yoꞌo xiꞌin ndo, saa chi ndia te na tandiaa kii ña kaꞌndia Ndioxi chiñu vi ke koꞌo tuku yu ra xiꞌin ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ra saa kiꞌin ra xita vaꞌa ra taxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra saa taꞌvi ra ña taxi ra ndaꞌa ndia, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ña yoꞌo ku iki kuñu yu, ña ndataxi yu xaꞌa ndo vichin. Ra iin takundiꞌi ichi na sa ndo ña yoꞌo ña ndakaꞌan ndo xaꞌa yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ra te sandiꞌi ndia xixini ndia, ra saa kiꞌin tuku ra copa ña ñuꞌu vino, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Vino yoꞌo ku iin trato xaa ña kindoo yu xiꞌin ndo vichin, chi ra yoꞌo ku nii yu ña kutia xaꞌa kuachi takundiꞌi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ra vichin na kundaa ini ndo, chi iin ra nduꞌu nuu mesa xiꞌin va yu kuvi ra ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ra ña ndixa ke xiniñuꞌu ndoꞌo ni va yuꞌu, ra xaa yoꞌo vichin, saa chi xa saa kuni mii Ndioxi ña ndoꞌo va yu, ndi su ¡ndaꞌvi ni tiaa ra ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu! ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ra saa xaꞌa ndia ndakatuꞌun taꞌan ndia, ña kuni ndia kundaa ini ndia, yoo ku iin ndia ndataxi Jesús ndaꞌa na saa ini. ");
INSERT INTO mxv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Saa kuu, ra xaꞌa ndia itaꞌan xiꞌin Jesús xa kuachi ndia xiꞌin taꞌan ndia, ña kuni ndia ña iin mii ndia na kuu ra kuchee kaꞌndia chiñu nuu mii ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Na kundaa ini ndo, chi na chiñu iyoo nuu ña yuuvi yoꞌo, ra xa nduxa na xiꞌin yuvi ña na sa na chiñu, ra ndiakua xiꞌin ndiayu mii na ke kuu ndiꞌi va chiñu ña kuni na. Ra na kuu mii iin chiñu chee, ra xinisii ni na ña kaꞌan vaꞌa yuvi xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ndi su ndoꞌo, ra süvi saa ke koo ndo, chi xa siin va ke koo xiꞌin ndoꞌo. Saa chi iin ra kuni kuchee nuu ndo ra ta iyoo iin ra loꞌo va ke na koo ra, ra ra xaꞌndia chiñu nuu ndo, ra ta xa iin na chuꞌun ndaꞌa va ke na sa ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","’Ra vichin kuni yu ndakatuꞌun yu ndoꞌo, ra na kaꞌan ndo xiꞌin yu, ¿yoo ku na chee vaꞌa ka tuvi ndo, a na ndee nuu mesa, a na chuꞌun ndaꞌa va? ¿A su na nduꞌu nuu mesa va kuvi na chee? Ra na kundaa ini ndo, chi yuꞌu ra kuu maestro ndo, ra ta iyoo iin ra chuꞌun ndaꞌa va ke iyoo yu nuu ndo vichin. ");
INSERT INTO mxv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ra ndoꞌo kuvi ndo xitaꞌan tuun xiꞌin yu ña ndoꞌo yu tundoꞌo ña uꞌvi va. ");
INSERT INTO mxv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ra xaꞌa ña kan ke ^taxi va yu ña kaꞌndia ndo chiñu, ta kuꞌva xa Tata yu ña taxi ra ña xaꞌndia yu chiñu. ");
INSERT INTO mxv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ra ndoꞌo kuvi ndo kuxi ra koꞌo ndo nuu kaꞌndia yu chiñu. Ra kundee ndo tiayu naꞌnu ña sandaku ndo kuachi xiꞌin uxi uvi saa na seꞌe xikua na ñuu Israel ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ra saa ndikaꞌan tu Jesús xiꞌin ra Pedro va, kachi ra saa: ―Simón, Simón, na kundaa ini kun chi xa nduku va timiaꞌa ndiayu xaꞌa ndo ña kotondoso ri ndoꞌo. Ra iin ta kuꞌva xa na ña ndativi na nuni trigo, ke sa ri xiꞌin ndo kuni ri. ");
INSERT INTO mxv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ndi su xa ndikaꞌan va yu xiꞌin Ndioxi xaꞌa kun, ña na kandixa ni ka kun yuꞌu, ra ta xa na nandiko tuku kun nuu yu, ra na chindiee taꞌan kun xiꞌin ndia ñani kun, ña ndinuni ni ka na kandixa ndia yuꞌu ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Saa ndakuiin ra Simón, kachi ra saa xiꞌin ra: ―Tata, yuꞌu ra xa iyoo nduvi va yu, nii veꞌe kàà na kuꞌun yu xiꞌin va kun, ra nii na kuvi tu yu xiꞌin va kun chi nandïko ini yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ra saa ndikaꞌan Jesús xiꞌin ra, kachi ra saa: ―Na kaꞌan yu xiꞌin kun ra kundaa ini kun, chi vichin ra xa uni va ichi tiseꞌe tuꞌun kun xaꞌa yu, ña xïni kun yuꞌu kachi kun, ra saa kana chele ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ra saa ndindakatuꞌun Jesús ndia itaꞌan xiꞌin ra kachi ra saa: ―Ta tiꞌvi yu ndoꞌo ndixaꞌan ndo ndikaꞌan ndoso ndo tuꞌun Ndioxi, ta ndixinïꞌi ndo leka, ra nii xuꞌun ndixinïꞌi ndo, ra nii ndixan ndixinïꞌi ka ndo kuꞌun xiꞌin ndo kuꞌun xaꞌa ndo, ¿ra a ndia ñaꞌa kumani nuu ndo? ―kachi ra. Ra saa ndakuiin ndia, kachi ndia saa: ―Ndia nii ñaꞌa ndikumäni nuu ndi, Tata ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Xa siin va koo vichin, chi ndoꞌo, ndia iyoo leka, ra na kaniꞌi va ndo ña, ra ndoꞌo, ndia niꞌi xuꞌun, ra kaniꞌi va ndo ña, ra ndoꞌo, ndia köo ichi niꞌi, ra na xiko ndo tikoto ña isukun ndo, ra sata ndo iin ichi ña kaniꞌi ndo. ");
INSERT INTO mxv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ra kaꞌan yu ña yoꞌo xiꞌin ndo, chi vichin ke xiniñuꞌu xinu nuu tuꞌun Ndioxi ña tiaa na xaꞌa yu xinaꞌa ña ndakani kachi suꞌva: “Ra tiꞌvi Ndioxi xaa, ra xiꞌin yuvi na iyoo kuachi va ndachutaꞌan na ra”, kachi ña. Ra takundiꞌi tuꞌun ña ndakani xaꞌa yu, ra ña xaa yu vichin ke xinu nuu va ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ra saa ndikaꞌan ndia xiꞌin ra, kachi ndia saa: ―Tata, xa yoꞌo va iyoo uvi ichi ―kachi ndia. Ra saa ndakuiin Jesús, kachi ra saa: ―Xa vaꞌa; na käꞌan ka yo xaꞌa ña yoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ra saa kita Jesús ini veꞌe kan, ra ndakiꞌin ra kuaꞌan ra iku Olivo kaꞌan ra xiꞌin Ndioxi, chi xa saa yunaꞌa va ra. Ra ndakundikun tu ndia itaꞌan xiꞌin va ra kuaꞌan ndia sata ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ra te ndixaa ndia kan, ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Kaꞌan ndo xiꞌin Ndioxi ña na chindiee taꞌan ra xiꞌin ndo, ña vaꞌa na köyo ndo ndaꞌa ña kuni kotondoso ndoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ra saa kuxika ra iin viviꞌi nuu ndia, ra iin ta kuꞌva ña sakoꞌni na yuu ke kuxika ra; ra ikan xikusiti ra, ra xaꞌa ra kaꞌan ra xiꞌin Ndioxi, ");
INSERT INTO mxv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","kachi ra saa: ―Tata, tu kuni kun, ra na täxi kun ña ndoꞌo yu. Ndi su na köo ña kuni yuꞌu, chi na sa kun ña kuni mii va va kun ―^kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ra saa xaa iin ra tatun Ndioxi ra kee ndivi, ña taxi ra ndiee ndaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ra saa kusuchi ka vi ini ra, ra saa ndakundiee ni ka ra ndikaꞌan ra xiꞌin Ndioxi, ra saa xaꞌa koyo tiatiin ra nuu ñuꞌu, ra iin ta iin tinaꞌnu nii saa íin ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ra ta sandiꞌi ra ndikaꞌan ra xiꞌin Ndioxi, ra saa nandiko ra xaa ra nuu ndee ndia itaꞌan xiꞌin ra, ra xa ndia kixi va kuvi ndia ndee ndia xaꞌa ña kusuchi ni ini ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¿Nichuun kixi ni ndo? Ndakoo ndo ra kaꞌan ndo xiꞌin Ndioxi ña na chindiee taꞌan ra xiꞌin ndo, ña vaꞌa na köyo ndo ndaꞌa ña kuni kotondoso ndoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ra sakan saa kuu Jesús kaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, saa ra xa ndixaa va iin tiaꞌndia chee yuvi nuu ndee ndia. Ra ra Judas ra itaꞌan xiꞌin ndia itaꞌan xiꞌin Jesús ña kuu ndia uxi uvi kuvi ra inuu nuu yuvi kan ndixaa na, ra saa kuyachin ra Judas ra nditandiaa yuꞌu ra nuu Jesús ña kaꞌan ndioxi ra xiꞌin ra iyoo tuꞌun. ");
INSERT INTO mxv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ra saa ndikaꞌan Jesús xiꞌin ra Judas, kachi ra saa: ―¿A suꞌva va ke xa kun ña ndataxi kun yuꞌu ndaꞌa na saa ini xini yuꞌu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ra saa xitoꞌni ndia itaꞌan xiꞌin Jesús ndita ndia, ra kundaa va ini ndia ña ^ndoꞌo ra, ra saa ndindakatuꞌun ndia ra kachi ndia saa: ―Tata, ¿a kuni kun tu na kanitaꞌan ndi xiꞌin na, xiꞌin ichi ña niꞌi ndi? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Saa ra ndikun xaꞌndia va iin ra itaꞌan xiꞌin ndia soꞌo kuaꞌa iin tiaa ra xachiñu nuu sutu ra kuchee nuu takundiꞌi sutu. ");
INSERT INTO mxv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ra saa ndikaꞌan Jesús xiꞌin ra, kachi ra saa: ―Xa vaꞌa, na koo na saa ―kachi ra. Ra saa nditiandiaa ndaꞌa Jesús soꞌo tiaa kan, ra sandaꞌa va ra ña. ");
INSERT INTO mxv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ra te ndiꞌi, ra saa ndikaꞌan tu ra xiꞌin ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia kunaꞌnu nuu ndia kumisio ndiaa veꞌe ñuꞌu kaꞌnu, xiꞌin ndia xikuaꞌa kunaꞌnu nuu na ñuu, na ndixaa tiin ñaꞌa, ña kuꞌun ra xiꞌin ndia, kachi ra saa: ―¿A ra kuiꞌna va kuvi yu tuvi ndo? ¿Nichuun xaa ndo xiꞌin ichi, xiꞌin itun ña tiin ndo yuꞌu? ");
INSERT INTO mxv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A su iin takundiꞌi va kii ndixiyo yu xiꞌin ndo ini veꞌe ñuꞌu kaꞌnu, ra nditïin ndo yuꞌu. Ndi su vichin ke xa ndixaa hora ña sa ndo ña kuni va ndo, saa chi vichin ke kaꞌndia ña ndivaꞌa chiñu va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ra saa tiin na Jesús, ra ndakiꞌin na kuaꞌan na xiꞌin ra chi veꞌe ra sutu kuchee. Ra saa xika xika ndikun ra Pedro kuaꞌan ra sata na. ");
INSERT INTO mxv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ra te ndixaa na veꞌe ra sutu kuchee kan, saa chikaa na ñuꞌu nuu keꞌe ra, ra iin xinunduu na ndee na ndasaa na, ra tiañu yuvi kan ndakunduꞌu taꞌan va ra Pedro ndasaa ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ra saa kuu ra Pedro nduꞌu ra ndasaa ra xiꞌin na. Ra xini va iin ñaꞌa ña xachiñu nuu ra sutu kan ra, ra saa ndikaꞌan ña, kachi ña saa: ―Ra itaꞌan xiꞌin Jesús kuvi tu ra yoꞌo va ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Saa ndakuiin ra Pedro, kachi ra saa xiꞌin ña: ―Ndïxa, xïni yu ra kaꞌan kun xaꞌa ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ra saa ndiyaꞌa iin kani loꞌo, ra tuku va tiaa ndakuni ra Pedro, ra ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Ra itaꞌan xiꞌin Jesús kuvi tu yoꞌo va ―kachi ra. Ra saa ndakuiin ra Pedro, kachi ra saa: ―Yoꞌo, ra kaꞌan ñaa, ndïxa. Süvi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ra saa ndiyaꞌa kuꞌva iin hora, ra tuku va tiaa ndikaꞌan xiꞌin ra, kachi ra saa: ―Ña ndixa ke, ra itaꞌan xiꞌin Jesús kuvi tu ra yoꞌo va, chi ra kee Galilea kuvi ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Saa ndikaꞌan ra Pedro xiꞌin ra, kachi ra saa: ―Yoꞌo, ra kaꞌan ñaa, kundäa ini yu yoo xaꞌa ke kaꞌan kun ―kachi ra. Ra sakan saa kuu ra kaꞌan ra, saa ra kana va chele. ");
INSERT INTO mxv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ra saa ndikokuiin Jesús ndakotoꞌni ra nuu ra Pedro, ra saa vi ke ndakaꞌan ra Pedro xaꞌa tuꞌun ña ndikaꞌan Jesús xiꞌin ra, ta kachi ra suꞌva: “Ñuu vichin ra xa uni va ichi tiseꞌe tuꞌun kun xaꞌa yu, ra saa kana chele”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ndia saa ra kanata ra Pedro chi keꞌe, ra xaꞌa ra xaku ni ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ra saa xaꞌa ndia soldado, ndia ndiaa Jesús ña ^xa siki ndia ra, ra kani ni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ra ndasi ndia nuu ra, ra kani ndia ra, ra kaꞌan ndia xiꞌin ra, kachi ndia saa: ―Kaꞌan xiꞌin ndi, ¿yoo ku na kani yoꞌo? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ra kuaꞌa ni ka nuu tuꞌun kiꞌvi kaꞌan ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ra te ndituvi inka kii, ra saa ndakutaꞌan ndia xikuaꞌa, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi ña tiaa ra Moisés, xiꞌin ndia sutu kunaꞌnu, ra saa ndiaka ndia soldado kan Jesús ndixaa ra nuu na chiñu kan. Ra saa xaꞌa ndia ndakatuꞌun ndia ra kachi ndia saa: ");
INSERT INTO mxv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Kaꞌan xiꞌin ndi vichin, ¿a ndixa yoꞌo ku Cristo ra tiꞌvi Ndioxi xaa sakaku ña yuuvi yoꞌo? ―kachi ndia. Ra saa ndakuiin Jesús, kachi ra saa: ―Nii na kaꞌan va yu xiꞌin ndo ña suvi yu, ra xa saa kandïxa vi ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ra tu na ndakatuꞌun tu yu ndoꞌo, ra ndakuïin vi ndo, ra nii saña tu ndo yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ndi su vichin, ra iin saa ndia kii ña vaxi ke kunduꞌu yuꞌu, ra xaa yoꞌo vichin, xitia kuaꞌa Tata yu Ndioxi ra kuu mii takundiꞌi ndiee ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ra saa ndindakatuꞌun takundiꞌi ndia ra, kachi ndia saa: ―¿A Seꞌe Ndioxi kuvi ndixa va kun? ―kachi ndia. Ra saa ndakuiin Jesús, kachi ra saa: ―Xa mii ndo ndikaꞌan va, ra suvi kuvi va yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ra saa ndikaꞌan ndia, kachi ndia saa: ―Yoo ka ku na xiniñuꞌu yo kaꞌan tieꞌe nuu vi ra, ra xa mii yo kuvi yo xini soꞌo, ña ndikaꞌan mii ra ña ku ra seꞌe Ndioxi va ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ra saa ndakiꞌin takundiꞌi ndia chiñu kan Jesús ra kuaꞌan ra xiꞌin ndia nuu ra Pilato. ");
INSERT INTO mxv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ra ta ndixaa ndia xiꞌin ra nuu ra chiñu chee Pilato kan, ra saa xaꞌa ndia taxi ndia kuachi siki xaꞌa ra, kachi ndia saa: ―Nduꞌu kuvi ndi ndaniꞌi tiaa yoꞌo ña xika ra sakanitaꞌan ra na ñuu ndi, ra kaꞌan ra, ña chäꞌvi ka ndi xuꞌun ña chaꞌvi ndi ndaꞌa ra tata chiñu César ñuu Roma. Ra kaꞌan tu ra ña kuu ra Cristo, ra kúu tu ra rey va, kachi ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ra saa ndindakatuꞌun ra Pilato Jesús, kachi ra saa: ―¿A ndixa rey na judío kuvi yoꞌo? ―kachi ra. Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Ta iyoo ña ndikaꞌan kun, saa iyoo va ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ra saa ndikaꞌan ra Pilato xiꞌin ndia sutu kunaꞌnu nuu ndia sutu, xiꞌin takundiꞌi ka yuvi kan, kachi ra saa: ―Köo ndia nii kuachi tiaa yoꞌo ndaniꞌi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ndi su ndia kan ra iin tuun tuun va kaꞌan ndia, kachi ndia saa: ―Ra ñaa, ra xa iinii saa va ñuu ke xika ra sakanitaꞌan yuvi. Ra ndia Galilea ke kee ra xika ra sañaꞌa ra yuvi, ra iin saa xaa ra ndia Judea yoꞌo va ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ra te xini soꞌo ra Pilato ña kachi ndia saa xaꞌa Jesús, ra saa ndindakatuꞌun ra ndia, kachi ra saa: ―¿A ra Galilea kuvi ra? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ra ta ndikaꞌan ndia xiꞌin ra ña suvi ra, ndia saa ra ndatiꞌvi ra Jesús kuaꞌan ra ndaꞌa ra Herodes, chi ra kan kuvi ra kuu rey xaꞌndia chiñu chi Galilea. Ra ndixiin tu ra ñuu Jerusalén va kii kuu saa kan. ");
INSERT INTO mxv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ra ta xini ra Herodes ña ndixaa na xiꞌin Jesús nuu ra, ra kusii ni ini ra; saa chi xa yachi ni vi ke kuni ra ña kuni ra Jesús, saa chi xa ndatuꞌun va na xaꞌa Jesús, ña xa ra kuaꞌa ni ña ndichi, ra xaꞌa ña kan ke kuni ra Herodes ña na sa Jesús iin ña xituꞌun, kuni ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ña kan ke tiaa ni kuaꞌa nuu ña nindakatuꞌun ra Herodes Jesús. Ndi su ndia nii tuꞌun nindäkuiin Jesús yuꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ra ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia maestro sañaꞌa ndiayu Ndioxi, ra iin tutuun va ndita ndia ña chikaa ndia kuachi siki sata Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Saa xaꞌa ra Herodes, xiꞌin ndia soldado ra ña kañaꞌa ni ndia xiꞌin Jesús, ra xa siki ni ndia ra, ra sandakundixi ndia ra iin tikoto vaꞌa ña ndixi mii na rey, ra sandiko tuku ra Herodes kan Jesús kuaꞌan ra nuu ra Pilato. ");
INSERT INTO mxv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ra mii kii kan ndakutaꞌan mani ra Herodes xiꞌin ra Pilato, saa chi yachi ra kuachi va ndixiyo ndia. ");
INSERT INTO mxv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Saa sandakitaꞌan ra Pilato kan, ndia sutu kunaꞌnu nuu ndia sutu, xiꞌin ndia chiñu kunaꞌnu, xiꞌin takundiꞌi na ñuu. ");
INSERT INTO mxv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―Ndoꞌo kuvi na ndiaka tiaa yoꞌo xaa ra xiꞌin ndo nuu yu, ña taxi ndo kuachi xaꞌa ra, ña xika ra sakanitaꞌan ra na ñuu, kachi ndo, ra nuu ndo saa sanaꞌma yu ra, ndi su ndia nii kuachi ña taxi ndo xaꞌa ra köo nindaniꞌi yu. ");
INSERT INTO mxv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ra nii ra Herodes nindanïꞌi kuachi ra, ña kan ke sandiko tuku ra ra xaa ra nuu yu vichin. Ra nii yuꞌu kuvi ra ndanïꞌi kuachi ra, ña kuvi ra xaꞌa ña. ");
INSERT INTO mxv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ña kan ke na taxi yu ndiayu, ña kani ndia soldado ra xiꞌin ñii ña kuu kuarta, ña sandoꞌo ndia ra. Ra te ndiꞌi, saa na saña ndika ra kuꞌun va ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chi xa saa yunaꞌa va ra chiñu chee Pilato kan ña saña ndika ra iin na ndikaa veꞌe kàà viko pascua ta kuiya ta kuiya. ");
INSERT INTO mxv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ndi su ndia nii yuvi kan, ndixïin ña saña Jesús kuꞌun ra, chi na ndiee ka xaꞌa ndikaꞌan va kuvi na, kachi na saa: ―¡Tava ra ñaa chi keꞌe ña kuꞌun ra kuvi ra, ra na saña ndika kun ra Barrabás va! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ra ra Barrabás kan, ra xaꞌa ña xaꞌni ra ndii, xiꞌin xaꞌa ña kanitaꞌan ra xiꞌin na chiñu va ke ndikaa ra veꞌe kàà. ");
INSERT INTO mxv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ra kuni va ra Pilato saña ndika ra Jesús, ña kan ke ndikaꞌan tuku ra xiꞌin yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ndi su na ndiee ka xaꞌa nindaꞌyu va kuvi na, ra iin tuku tuku kaꞌan na kachi na saa: ―¡Na kutakaa ra ndaꞌa cruz, na kutakaa ra ndaꞌa cruz! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ra saa ndikaꞌan tuku ra Pilato kan xiꞌin na ichi ña uni, kachi ra saa: ―¿Ndia ña kuu kuachi tiaa yoꞌo tuvi ndo? Chi ndia nii kuachi ra köo ndaniꞌi yu ña kuvi ra xaꞌa ña; ña kan ke takua na sandoꞌo va yu ra, ra saa saña ndika yu ra kuꞌun va ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ndi su yuvi kan, ra na ndiee ka ndikaꞌan va kuvi na, ña kuni na ña na kuꞌun Jesús kutakaa ra ndaꞌa cruz. Ra xaꞌa ña ndiee ni sandiꞌi yuvi kan, xiꞌin ña ndikaꞌan ni ndia kunaꞌnu nuu ndia sutu va ke ndixinu va ña kuni na sa na. ");
INSERT INTO mxv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ndia saa ra xa ra Pilato ña kuni va na. ");
INSERT INTO mxv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ra saa saña ndika va ra Pilato, ra Barrabás, ra ndikaa veꞌe kàà xaꞌa ña xaꞌni ra ndii, xiꞌin xaꞌa ña kanitaꞌan ra xiꞌin na chiñu, ra ndataxi ra Jesús ndaꞌa na ña sa na ña kuni mii na xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ra saa ndakundiaka ndia soldado kan Jesús kuaꞌan ra xiꞌin ndia ña katakaa ndia ra ra ndaꞌa cruz, ra ichi kan ndakutaꞌan na xiꞌin iin tiaa ra nani Simón, ra chi iku va ke kee tiaa kan vaxi ndixi ra ñuu Jerusalén, ra ra ñuu Cirene va kuvi ra. Ra saa sakuiso nduxa na cruz tun kasoko Jesús ra, ra ndakundikun ra sata Jesús kuaꞌan ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ra kuaꞌa ka vi na ñuu kan ndikun kuaꞌan sata Jesús, ra kuaꞌan kuaꞌa tu na siꞌi va, ra tiaa ni xaku na, ra iin kani na ndika na xaꞌa ña kusuchi ni ini na xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ra saa ndakotoꞌni Jesús nuu na siꞌi kan, ra ndikaꞌan ra xiꞌin na, kachi ra saa: ―Ndoꞌo, na siꞌi ñuu Jerusalén, xäku ndo xaꞌa yuꞌu, chi na kuaku ndo xaꞌa mii ndo, xiꞌin xaꞌa seꞌe va ndo. ");
INSERT INTO mxv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Saa chi vaxi kii ra kaꞌan na ñuu yoꞌo, kachi na saa: “Vaꞌa ni ^kee na siꞌi numa, ra saa tu na siꞌi na ndikäku seꞌe va, saa chi köo na vali sachichin na ña sakuaꞌnu na na” ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ra saa xaꞌa na kaꞌan na xiꞌin xiki naꞌnu, kachi na saa: “Koyo ndo sata ndi”; ra kaꞌan tu na xiꞌin koꞌndo vali va kachi na: “Ndasi ndo sata ndi”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Saa chi tu suꞌva xa na xiꞌin itun kuii, saa ra ndiee ka va sa na xiꞌin itun ichi ―kachi Jesús xiꞌin na siꞌi ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ra ndiaka tu ndia soldado kan, uvi tiaa ndia iyoo ni kuachi va ña kuaꞌan ndia kuvi ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ra ta ndixaa na iku ña nani Leke Xini Ndìì, ra ikan katakaa ndia soldado kan Jesús ndaꞌa cruz, ra katakaa tu ndia tiaa ndia iyoo ni kuachi va, ra iin ra katakaa ndia ndaꞌa cruz tu ndichi chi xiin kuaꞌa Jesús, ra inka ra katakaa ndia ndaꞌa cruz tu ndichi chi xiin ichin va ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ra saa ndikaꞌan Jesús xiꞌin Ndioxi, kachi ra saa: ―Tata, sakaꞌnu ini xaꞌa kuachi na, saa chi kundäa ini na ni ke xa vi na ―kachi ra. Ra saa keꞌe taꞌan ndia soldado kan, ña vaꞌa kundaa ini ndia yoo ku ndia ndakiꞌin tikoto Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ra xitoꞌni takundiꞌi yuvi na ndixaa kan ndita na, ra ndia ndia chiñu kan va ^xa siki Jesús, kachi ndia saa: ―Vaꞌa va sakaku ra inka yuvi, ra na sakaku tu ra mii ra vichin va tu ndixa ke kuu ra Cristo, ra ndikaxin Ndioxi ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ra xasiki ni tu ndia soldado kan va Jesús, ra taxi ndia ndutia iyá koꞌo ra, ");
INSERT INTO mxv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ra ndikaꞌan ndia xiꞌin ra, kachi ndia saa: ―Tu ndixa rey na judío kuvi kun, ra sakaku mii kun vichin ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ra tiaa na nuu iin vitu loꞌo, ra chinuu ndiaa na nu xini cruz tu takaa Jesús ndaꞌa, ra kaꞌan tuꞌun kan kachi ña saa: “Ra yoꞌo kuvi rey na Israel”, kachi ña, ra uni nuu tuꞌun ke tiaa na, tuꞌun griego, xiꞌin tuꞌun latin, xiꞌin tuꞌun hebreo. ");
INSERT INTO mxv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ra saa xaꞌa iin ra iyoo ni kuachi, ra takaa ndaꞌa cruz kan, kañaꞌa ra xiꞌin Jesús, kachi ra saa xiꞌin ra: ―Tu ndixa yoꞌo kuvi Cristo, saa ra sakaku mii kun, ra sakaku kun nduꞌu vichin ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Saa ndukueꞌe ra iyoo kuachi taꞌan ra xiꞌin ra, kachi ra saa: ―¿Nichuun kuayüꞌvi kun Ndioxi? Ra xa kundaa kaxi ini kun chi yo kuvi ku uni saa va yo vichin. ");
INSERT INTO mxv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ra vaꞌa va yoo chi xaꞌa kuachi va yo ke ndoꞌo yo ña yoꞌo, ndi su ra yoꞌo, ra ndia nii kuachi köo ndixa ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ra saa ndikaꞌan ra xiꞌin Jesús, kachi ra saa: ―Tata, ta xa na ndakiꞌin kun ña kaꞌndia kun chiñu, ra na ndakaꞌan kun xaꞌa yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Ña ndixa kaꞌan yu xiꞌin kun, chi mii kii vichin koo kun xiꞌin yu nuu nduvi ni kaa ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ra ta xa kuu ña kaa uxi uvi kaꞌñu, saa ra kuñaa nuu iinii saa nuu ña yuuvi yoꞌo, ra iin saa ndia ka uni xikuaa. ");
INSERT INTO mxv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ñuꞌù, ra iin nundiaa ni va ña, ra nindata sava maꞌñu tikoto ña takaa ini veꞌe ñuꞌu kaꞌnu ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ra saa ndiee ka vi nindaꞌyu Jesús, kachi ra saa: ―¡Tata, ndaꞌa mii kun ndataxi yu nima yu! ―kachi ra xiꞌin Ndioxi. Ra ndia tuꞌun yoꞌo ndikaꞌan ra, saa ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ra ta xini ra kuchee nuu ndia soldado ñuu Roma ña kuu, ra saa ndasakaꞌnu ra Ndioxi, kachi ra saa: ―Ña ndixa ke, ra vaꞌa ku ndixa va tiaa yoꞌo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ra takundiꞌi yuvi na ndixaa nuu katakaa na Jesús ndaꞌa cruz, ra ta xini na ña ndoꞌo ra, ra saa nandiko na kuanuꞌu na, ra iin kani ndaꞌa na ndika na kuaꞌan na, ña kusuchi ni ini na. ");
INSERT INTO mxv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndi su takundiꞌi na itaꞌan mani xiꞌin Jesús, ra xika va xikundita na xitoꞌni na ña ndoꞌo ra, ra ndita tu na siꞌi na ndikun kuaꞌan xiꞌin ra ndia ta kee ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ra ñuu kan, xikanduꞌu iin tiaa ra nani José, ra ra ñuu Arimatea ña ndikun ndiaa Judea kuvi ra, ra iin tiaa ra toꞌo, ra vaꞌa ni kuvi ra, ra ndiaꞌvi ndiaa tu ra xiꞌin na kunaꞌnu kan va. ");
INSERT INTO mxv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ndi su ndixïyo vi yuꞌu ra xiꞌin na, xaꞌa ña xa na xiꞌin Jesús. Saa chi xindiatu tu ra kan va ña xaꞌa Ndioxi kaꞌndia ra chiñu nuu na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ra ra kan kuvi ra ndixaꞌan nuu ra Pilato, ña nduku ra ndiayu ña sanuu ra iki kuñu Jesús ña nduxin ra ña. ");
INSERT INTO mxv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ra saa kee ra ndixaꞌan ra sanuu ra Jesús ndaꞌa cruz, ra ndasuvi ra ra iin tikoto ña vaꞌa ni, ra saa ndixaꞌan ra chikaa ra ra ini iin yavi ña kaan ra ndika kava ta yachi, ra yavi kan ra ña xaa vaꞌa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ra xikuaa kii viernes te xaꞌa na ñuu Israel xa nduvi na ndakindiee na kii yii sábado ke kuu ña. ");
INSERT INTO mxv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ra takundiꞌi na siꞌi na ndikun sata Jesús ta kee ra ndia chi Galilea, ra ndikun na sata ra José ndixaꞌan na xini na ndia nuu chikaa ra iku kuñu Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ra ta ndiꞌi, saa nandiko na siꞌi kan ndaxaa na chi veꞌe, ra saa xavii na ndutia xaꞌan tami, xiꞌin tatan ña xaꞌan tami, ña chikaa na sata iki kuñu Jesús. Ra ndakindiee̱ va na kii yii sábado, xa ta kuꞌva kachi mii ndiayu Ndioxi ña ndakoo ra Moisés va. ");
INSERT INTO mxv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ra naꞌa ni chi xitiaan kii domingo, kii ña kiꞌin xaꞌa semana, ndakiꞌin na siꞌi kan kuaꞌan na, ra niꞌi na ndutia xaꞌan tami ra xavaꞌa na chikaa na sata iki kuñu Jesús nuu chikaa na ra. Ra ndakutaꞌan ka tu sava na siꞌi va xiꞌin na kuaꞌan na. ");
INSERT INTO mxv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ra ta ndixaa na yuꞌu yavi nuu chikaa na iki kuñu Jesús, ra saa ndakutoꞌni na xa ndixikutiaꞌa va yuu chee ña ndasi yuꞌu yavi kan. ");
INSERT INTO mxv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ra saa ndikiꞌvi na ini yavi kan kuaꞌan na, ra köo ka iki kuñu Jesús ndixini na. ");
INSERT INTO mxv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ra sakan saa kuu na ndakanda ini na ndita na, ña köo ka iki kuñu Jesús ndixini na, saa ra tuꞌva ndituvi va uvi tiaa nuu na, ra ndixi ndia tikoto yaa ña yeꞌe ni. ");
INSERT INTO mxv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Saa ra ndiyuꞌvi ka vi na, ra iin kama ndakusiti na. Ra saa ndikaꞌan ndia xiꞌin na, kachi ndia saa: ―¿Nichuun vaxi ndo ndanduku ndo iin tiaa ra tiaku nuu ñuꞌu na ndii? ");
INSERT INTO mxv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Köo ka ra ndikaa yoꞌo, chi xa ndatiaku va ra. Na ndakaꞌan ndo ta kuꞌva ndikaꞌan ra xiꞌin ndo, ta ndixika ra chi Galilea, ");
INSERT INTO mxv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ta kachi ra suꞌva: “Yuꞌu, ra xaa yoꞌo vichin, ra xiniñuꞌu tiin na yuꞌu, ra ndataxi na yuꞌu ndaꞌa yuvi kuachi, ra katakaa na yuꞌu ndaꞌa cruz, ña kaꞌni na yuꞌu, ndi su kii uni, ra ndiatiaku va yu”, kachi ra xiꞌin ndo ―kachi ndia xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ra saa vi ke ndakaꞌan na siꞌi kan, xaꞌa tuꞌun ña ndikaꞌan Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ra saa kee na siꞌi kan ndaxaa na chi veꞌe, ra saa ndatuꞌun na xiꞌin ndia xitaꞌan xiꞌin Jesús, xaꞌa takundiꞌi ña xini na, ra ndatuꞌun tu na xiꞌin na kuaꞌa na xitaꞌan xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ra suꞌva ke nani na siꞌi na xini ña kuu kan: Iin ña nani María ña kee ñuu Magdala, iin ña nani Juana, ra inka tuku ña María ña siꞌi ra Jacobo, xiꞌin kuaꞌa ni ka na siꞌi. ");
INSERT INTO mxv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ndi su ndikandïxa vi ndia xitaꞌan xiꞌin Jesús ña ndatuꞌun na xiꞌin ndia, saa chi na xavaꞌa ini va kuvi na ndituvi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ña kan ke kanata ra Pedro xinu ra kuaꞌan ra kotoꞌni ra yavi nuu chikaa na iki kuñu Jesús. Ra ta ndixaa ra nuu íin yavi kan, ra ndia tikoto ña xisuvi va Jesús ndee ini yavi kan xini ra, ra saa nandiko ra kuanuꞌu ra chi veꞌe ra ndakanda ka vi ini ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ra suvi mii kii kan ndakiꞌin uvi ndia xitaꞌan xiꞌin Jesús kuaꞌan ndia chi ñuu ña nani Emaús. Ra kuꞌva uni hora ke kaka ndia, saa xaa ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ra ndatuꞌun ka vi ndia xaꞌa takundiꞌi ña kuu kuaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ra sakan saa kuu ndia ndatuꞌun ndia xaꞌa Jesús kuaꞌan ndia, saa ra kuyachin va mii Jesús ra ndakutaꞌan ra xiꞌin ndia kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ndi su nditäxi Ndioxi ña ndakuni ndia ra, chi iin ta ndoꞌo na kuni kusun va, saa ndoꞌo ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¿Yoo xaꞌa ke ndatuꞌun ndo kuaꞌan ndo ichi yoꞌo? ¿Ra nichuun kusuchi ni ini ndo? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Saa ndakuiin iin ra nani Cleofas, kachi ra saa: ―¿A iin ndaa yoꞌo va kuvi ra inka ñuu, ra täan kundaa ini xaꞌa ña kuu ñuu Jerusalén semana ndiyaꞌa yoꞌo? ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ra saa nindakatuꞌun Jesús ndia, kachi ra saa: ―¿Ni ke kuu? ―kachi ra xiꞌin ndia. Saa ndakuiin ndia, kachi ndia saa: ―Xaꞌa Jesús, ra ke̱e ñuu Nazaret, ke ndatuꞌun ndi, chi iin ra ndikaꞌan tuꞌun yuꞌu Ndioxi kuvi ra. Ra ndixiyo ni ndiee Ndioxi xiꞌin ra. Ra kuaꞌa ni ña vaꞌa xa ra xiꞌin na ñuu Israel. ");
INSERT INTO mxv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ndi su ndia sutu kunaꞌnu, ra tiin ndia ra ra ndataxi ndia ra ndaꞌa ndia chiñu kunaꞌnu, ra ndia kan xaꞌndia chiñu nuu ndia soldado ña kani ndia ra, ra katakaa ndia ra ndika cruz ndixiꞌi ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ra xindiaa ni ini ndi ra ña kuu ra, ra xaa sakaku yoo, na ñuu Israel, ndi su xa kii uni va ke ndixiꞌi ra vichin. ");
INSERT INTO mxv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ra sava tu na siꞌi na itaꞌan xiꞌin ndi ra sayuꞌvi ni na nduꞌu xitiaan nduveꞌe, chi ñaꞌa ni ndixaꞌan na xitoꞌni na nuu iin yavi ña chikaa na Jesús, ");
INSERT INTO mxv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ra köo ka ra ndikaa ndixini na, ^kachi na ndaxaa na ndatuꞌun na xiꞌin ndi, ra xini tu na uvi ndia tatun Ndioxi va kachi na, ra ndikaꞌan ndia xiꞌin na, ña xa ndatiaku va ra, kachi na. ");
INSERT INTO mxv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ña kan ke kee sava ndia itaꞌan xiꞌin ndi ndixaꞌan ndia xini vaꞌa ndia, ra iin ta iyoo ña ndatuꞌun na siꞌi kan xiꞌin ndi ke iyoo tu ña xini ndia kan va, saa chi köo ndixa va Jesús ndikaa ndixini ndia, kachi ra, xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―¿Nichuun kiꞌvi ni ndo, ña uꞌvi ni kundaa ini ndo xiꞌin takundiꞌi ña ndikaꞌan na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa? ");
INSERT INTO mxv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A kundäa ini ndo, xa saa xiniñuꞌu ndoꞌo ni va Cristo. Ra saa vi ke nandiko ra kunuꞌu ra ndivi nuu xaꞌndia ra chiñu, kachi ndia ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ra saa xaꞌa ra ndakani ra nuu ndia, ra xiꞌna ka xaꞌa ndiayu Ndioxi ña tiaa ra Moisés ke kiꞌin ra ndakani ra, ra iin saa ndiakua sandiꞌi ra ndakani ra xaꞌa takundiꞌi ndia ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa, ra xaꞌa Cristo ra xiniñuꞌu ndoꞌo ni kan ke kaꞌan tu ña tiaa ndia ndixika chiñu nuu Ndioxi xinaꞌa va, kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ra ta kuyachin ndia xiꞌin Jesús ñuu nuu kuaꞌan ndia, saa ra, ta ^xa ra yaꞌa kuaꞌan kani va xa ra, ");
INSERT INTO mxv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ra saa xakundaꞌvi ndia nuu ra, kachi ndia saa: ―Tata, na yaꞌa va kun ndakindiee kun xiꞌin ndi ñuu yoꞌo. Saa chi xa kuaꞌan kuaa ni va, ra kama ni va ku ñuu ―kachi ndia. Ra saa kuachi ndixa va ra xiꞌin ndia ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ndi su ta ndakunduꞌu ra nuu mesa ña kuxi ra xiꞌin ndia, saa kiꞌin ra xita, ra taxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra saa taꞌvi ra ña, ra taxi ra ña ndaꞌa ndia ña kuxi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ra iin ta xa ña ndanuña xa nuu ndia, ra saa vi ke ndakuni ndia ra. Saa ra nindoñuꞌu tuku va ra nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ra saa xaꞌa ndia ndatuꞌun ndia xiꞌin taꞌan ndia, kachi ndia saa: ―¿A su ta ndatuꞌun ra xiꞌin yo vaxi ra ichi, ra kusii ka vi ini yo iin ndiakua kandita nima yo ta ndakani ra tuꞌun Ndioxi nuu yo? ―kachi ndia xiꞌin taꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndia saa ra ndakuita ndia, ra ndikun nandiko tuku ndia kuanuꞌu ndia ñuu Jerusalén va. Ra te ndaxaa ndia ra xa ndakutaꞌan kuiti tuku va ndia uxi iin ndia xitaꞌan xiꞌin Jesús ndee ndia, ra ndee ka tu na sava kan va xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ra saa ndikaꞌan ndia ndee kan xiꞌin ndia, kachi ndia saa: ―Ña ndixa ke xa ndatiaku va Tata yo Jesús, saa chi xa xini tu ra Simón Pedro va ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Saa xaꞌa tu ndia uvi kan va ndatuꞌun ndia xaꞌa takundiꞌi ña ndoꞌo ndia ta ndakutaꞌan ra xiꞌin ndia ichi, ta kuaꞌan ndia ñuu Emaús. Ra ndatuꞌun tu ndia ña ndakuni ndia ra ta taꞌvi ra xita taxi ra ndaꞌa ndia kuxi va ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ra te sakan saa kuu ndia ndatuꞌun ndia xaꞌa ña ndoꞌo ndia, saa ra tuꞌva xikundichi va Jesús maꞌñu ndia, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ndioxi na koo xiꞌin ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Saa ra ndiyuꞌvi ka vi ndia, ra iin kuaꞌan ini ndia, kaꞌan ndia saa: “Nima va ke yoꞌo”, kaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―¿Nichuun iyuꞌvi ni ndo? ¿Ra nichuun ndakani ini ndo ña ñaa? ");
INSERT INTO mxv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kotoꞌni ndo ndaꞌa yu xiꞌin xaꞌa yu, chi yuꞌu kuvi va ra, ra na kuyachin ndo ña tandiaa ndaꞌa ndo yuꞌu, ra kundaa ini ndo ña suvi kuvi va yu. Chi iin nima ra köo kuñu ña ra nii leke ña köo. Ndi su yuꞌu, ra iyoo va kuñu yu xiꞌin leke yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ra ta ndiꞌi ndikaꞌan ra tuꞌun yoꞌo, ra saa ndiñaꞌa ra yavi ndaꞌa ra xiꞌin xaꞌa ra nuu ndiñani clavo nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ra xaꞌa ña kusii ni ini ndia, xiꞌin xaꞌa ña ndakanda ni ini ndia, ra ndikandïxa vi ndia ra, ra saa ndindakatuꞌun ra ndia, kachi ra saa: ―¿A iyoo loꞌo ñaꞌa kuxi yo? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ra saa taxi ndia iin ñaꞌñu tiaka ri yatan ndaꞌa ra, ra taxi tu ndia loꞌo ñuñu va ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ra ndikun nuu ndia saa xaxi va ra tiaka ri taxi ndia ndaꞌa ra, ra saa tu ñuñu va. ");
INSERT INTO mxv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Xaꞌa takundiꞌi ña kuu yoꞌo ke ndikaꞌan yu xiꞌin ndo te ndixiyo yu xiꞌin ndo ta yachi: ña xiniñuꞌu xinu nuu ndiayu Ndioxi ña ndakoo ra Moisés, ra saa tu ña ndikaꞌan na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va, ra saa ke ^kachi tu ña tiaa na nuu tutu Salmo va ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Saa ra ndanuña va ña xini tuni ndia, ra kundaa ini ndia xiꞌin takundiꞌi va ña ndakani tuꞌun Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ra saa ndikaꞌan ka Jesús xiꞌin ndia, kachi ra saa: ―Tuꞌun Ndioxi ña ndikaꞌyu xinaꞌa ra suꞌva ke kachi ña: ra kuu Cristo, ra xiniñuꞌu kuvi va ra, ndi su kii ña uni ra ndatiaku tuku va ra; ");
INSERT INTO mxv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ra kaꞌan ndoso na ndikun ichi ra kivi ra iinii kuvi ña yuuvi, ña vaꞌa na nandiko ini takundiꞌi yuvi xaꞌa kuachi na, ra koo kaꞌnu ini ra xaꞌa na, ra xiꞌna ka va ñuu Jerusalén ke kiꞌin na kaꞌan ndoso na kuꞌun na, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ra na kundaa ini ndo vichin, chi ndoꞌo va kuvi ndo sa chiñu yoꞌo, saa chi ndoꞌo kuvi ndo xini takundiꞌi ña ndoꞌo va yu. ");
INSERT INTO mxv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ra ñuu Jerusalén yoꞌo ke kundiatu ndo, ra saa tiꞌvi yu ña kindoo Tata yu tiꞌvi ra sata ndo, ra ndia ta xa na ndakiꞌin ndo ndiee ña kee ndivi, saa vi ke kee ndo kuꞌun ndo ña kaꞌan ndoso ndo tuꞌun yu ―kachi Jesús xiꞌin ndia xitaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ra saa ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia xitaꞌan xiꞌin ra chi nuu ndikaa ñuu Betania, ra ikan ndoniꞌi ra ndaꞌa ra chi ndivi, ña ndikaꞌan ra xiꞌin Ndioxi xaꞌa ndia ña xa yii ra ndia. ");
INSERT INTO mxv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ra sakan saa kuu ra ña kaꞌan ra xiꞌin Ndioxi ña ^xa yii ra ndia, saa ra kuee kuee kuxika ra nuu ndia ña ndakuita ra kuaꞌan ra chi ndivi ninu va. ");
INSERT INTO mxv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Saa ra ndasakaꞌnu ni ndia ra, ra kusii ka vi ini ndia nandiko ndia kuanuꞌu ndia ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ra iin ndisaa kii ndixaꞌan ndia veꞌe ñuꞌu kaꞌnu ñuu Jerusalén ndasakaꞌnu ndia Ndioxi.");
INSERT INTO mxv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Te kuni ka kukava xaꞌa ña yuuvi yoꞌo, ra xa iyoo va ra kuu tuꞌun. Ra ra kuu tuꞌun kan kuvi ra xa iyoo xiꞌin Ndioxi te yachi vi. Ra suvi mii ra kuu tuꞌun kan kuvi tu ra kuu Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ra xa xiꞌin mii Ndioxi ke, xa iyoo va ra kuu tuꞌun kan ndia te kii xaꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ra iin ndiakua íin ra kan saa ke kuvaꞌa takundiꞌi ñaꞌa ña iyoo, chi tu köo ra kan, saa ra ndia nii ñaꞌa ke kuväꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ra ra kan kuvi ra ^taxi ña tiaku yuvi, ra ña tiaku kan kuvi ñùꞌù ña ^ndatuun nuu takundiꞌi na yuuvi yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ra ñùꞌù kan kuvi ña tuun nuu ña ñaa, ña kuu ña väꞌa; ra ña ñaa ña kuu ña väꞌa kan, ra kuchüun vi ña ndaꞌva ña ñuꞌu ña tuun kan. ");
INSERT INTO mxv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ndixiyo iin tiaa ra xinani Juan, ra ra kan kuvi ra tiꞌvi Ndioxi kixi nuu ña yuuvi yoꞌo, ");
INSERT INTO mxv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ña na ndakuiin ra xaꞌa ra kuu ñuꞌu ña tuun kan, ra ndatuꞌun tu ra xiꞌin yuvi va, ña vaꞌa na kandixa na ra kuu ñuꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ndi su süvi mii ra Juan kan kuvi ra kuu ñùꞌù, chi takua ra kixi ndatuꞌun va kuvi ra xaꞌa ra kuu ñùꞌù kan. ");
INSERT INTO mxv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ra ra kuu ñùꞌù ña ndixa ña tuun nuu takundiꞌi yuvi, ra xa kixi va ra nuu ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ra nuu ña yuuvi yoꞌo ke xa ndixika va ra, ra ndiakua ndixiin va ra te xavaꞌa Ndioxi ña yuuvi yoꞌo, ndi su na yuuvi yoꞌo, ra nindükuni na ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ra nuu mii na ñuu ra ke kixi va ra, ndi su na ñuu ra ra nindakïꞌin mani na ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ra takundiꞌi na ndakiꞌin mani ñaꞌa, ra ^kandixa na kivi ra, ra taxi ra ndiayu ndaꞌa na ña ^kuu na seꞌe Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ra na yoꞌo, ra süvi ña ndikusii ini yuvi xiꞌin taꞌan na ke ninduu na seꞌe Ndioxi, chi ña kuni mii Ndioxi va ke nduu na seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ra ña kuu tuꞌun kan ke nduu iin tiaa va, ra ra kan kuvi ra kixi ndixiyo nuu ña yuuvi yoꞌo va. Ra xini nuu va ndi ndiee ña taxi iva ra ndaꞌa ra, ña kuu ra ra mituꞌun, ra ndañaꞌa ra mii ra nuu ndi ña kuu ra ra ndaa, ra kuꞌvi ni ini ra xini ra yoo. ");
INSERT INTO mxv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ra suꞌva ke kachi ra Juan ndikaꞌan ra xaꞌa ra kuu tuꞌun kan: ―Ra yoꞌo ku ra ndikaꞌan yu xaꞌa xiꞌin ndo, te ndikaꞌan yu kachi yu suꞌva: “Tiaa ra ndikun vaxi chi sata yuꞌu, ra ra kaꞌnu ni ka va kuvi ra kan nuu yuꞌu, saa chi xa yachi vi ke iyoo ra kan nuu yuꞌu” ―kachi ra Juan. ");
INSERT INTO mxv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ra xaꞌa ña kuaꞌa ni ña vaꞌa iyoo nuu ra kuvi ña ^ndakiꞌin takundiꞌi va yo ña vaꞌa ^xa ra, ra viꞌi ni ña ^taxi ra ndaꞌa yo ta iin iin kii. ");
INSERT INTO mxv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ra ña kuu ndiayu mii Ndioxi, ra ndaꞌa ra Moisés va ke taxi ra ña, ra ra kan kuvi ra ndañaꞌa ña nuu yoo va, ndi su ña ndaa, ña ku mii Ndioxi xiꞌin ña kuꞌvi ni ini ra xini ra yoo, ra Jesucristo va kuvi ra ndañaꞌa ña kan nuu yo. ");
INSERT INTO mxv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndioxi ra ndia nii na täan kuni ñaꞌa ra seꞌe ra, ra mituꞌun, ra íin xiꞌin ra ndiꞌi kii va kuvi ra ^ndañaꞌa ra kuu iva ra nuu yo. ");
INSERT INTO mxv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ra saa kuu iin kii, ra ndakutaꞌan ndia sutu kunaꞌnu nuu na judío na ndee ñuu Jerusalén ra tiꞌvi ndia sava ndia sutu xiꞌin ndia levita ña ndixaꞌan ndia nindakatuꞌun ndia ra Juan ra sakuchi yuvi, kachi ndia saa: ―¿Ndia chiñu ke ^xa kun nuu Ndioxi? ―*kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ra saa ndakani ra Juan mii ña ndaa va nuu ndia kachi ra saa: ―Süvi yuꞌu kuvi ra kuu Cristo, ra xaa sakaku ndoꞌo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ra saa ndindakatuꞌun tuku va ndia ra kachi ndia saa: ―¿Yoo kuvi yoꞌo, tu saa? ¿A ra Elías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa kuvi kun? ―kachi ndia xiꞌin ra. Ra saa ndakuiin ra Juan kachi ra saa: ―Süvi yu ―kachi ra. Ra saa ndindakatuꞌun tuku va ndia ra kachi ndia saa: ―¿A yoꞌo kuvi ra iyoo tuꞌun xaꞌa kixi kaꞌan ndoso tuꞌun yuꞌu Ndioxi? ―kachi ndia xiꞌin ra. Ra saa ndakuiin ra kachi ra saa: ―Süvi yuꞌu kuvi ra ―kachi tuku va ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ra saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―¿Yoo va kuvi yoꞌo, tu saa? Chi xiniñuꞌu kundaa ini ndi, ra saa ke vaꞌa niꞌi ndi tuꞌun ndakani ndi nuu na ^tiꞌvi nduꞌu vaxi ndi. ¿Ra ni ke kachi kun xaꞌa mii kun? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saa ndakuiin ra Juan kachi ra saa: ―Yuꞌu kuvi ra tiꞌvi Ndioxi vaxi iku iyu, ra ^kaꞌan yu xiꞌin ndo kachi yu saa: “Ndasandaku ndo nima ndo nuu Ndioxi”, ta kuꞌva kachi ra Isaías ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa ―*kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ra ndia ndixaꞌan nuu ra Juan, ra ndia fariseo va kuvi ndia tiꞌvi ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ra ndindakatuꞌun ndia ra kachi ndia saa: ―¿Nichuun ^sakuchi kun yu̱vi tu süvi Cristo kuvi kun, ra nii süvi tu ra Elías kuvi kun, ra nii süvi tu ra ka̱ꞌa̱n tuꞌun yuꞌu Ndioxi kuvi va kun? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ra saa ndakuiin ra Juan, kachi ra saa xiꞌin ndia: ―Yuꞌu, ra takua xiꞌin tiakuii va ke ^sakuchi yu yuvi, ndi su xa maꞌñu ndo yoꞌo va ndichi iin tiaa, ra xïni ndo ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ra ra kan kuvi ra ndikun vaxi sata yuꞌu, ra xa ta yachi vi ke iyoo ra kan nuu yuꞌu. Ra yuꞌu, ra ndia nii ñii ndixan vi ra ke köo ndiayu yu ndaxi yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ra takundiꞌi ña yoꞌo, ra chi ñuu ña nani Betábara ña ndikaa chi inka xiyo yuꞌu itia Jordán nuu ^sakuchi ra Juan yu̱vi ke kuu ña. ");
INSERT INTO mxv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Saa kuu ndiyaꞌa iin kii, ra xini ra Juan ña kuyachin Jesús kuaꞌan ra nuu íin ra. Ra saa ndikaꞌan ra kachi ra saa: ―Kutoꞌni ndo, chi ra yoꞌo kuvi ra kuu ndikachi loꞌo ra kuu kuenda Ndioxi, ra ra yoꞌo kuvi ra sandiꞌi xaꞌa kuachi na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ra xaꞌa ra yoꞌo ke xa ndikaꞌan yu xiꞌin ndo, te kachi yu suꞌva: “Vaxi iin tiaa chi sata yu, ra ra kaꞌnu ni ka va kuvi ra kan nuu yuꞌu, saa chi xa yachi vi ke iyoo ra”, kachi yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ra nii yuꞌu kuvi ra xïni ñaꞌa vi; ra ña vaꞌa na kundaa ini na ñuu Israel yoo kuvi ra, ña kan ke ^vaxi yu sakuchi yu na xiꞌin tiakuii, ―kachi ra Juan. ");
INSERT INTO mxv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ra saa ndakani ka ra Juan nuu na kachi ra saa: ―Yuꞌu kuvi ra xini Tachi Yii Ndioxi ña kee ña ndiví, ra ta kaa iin paloma, saa kaa ña, ra nduxinu ña xika ña sata ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ra nii yuꞌu ndikundäa ini yoo kuvi ra, ndi su ra tiꞌvi yuꞌu vaxi yu, ña ^sakuchi yu yu̱vi xiꞌin tiakuii kuvi ra ndikaꞌan xiꞌin yu, kachi ra saa: “Ra kuni kun nduxínu̱ Tachi Yii sata ra kukoo ña xiꞌin ra, ra ra kan kuvi ra ^sakuchi yuvi xiꞌin Tachi Yii”, kachi ra xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ra xa xini va yu ra, ña kan ke ^ndakuiin yu xaꞌa ra ña ndixa ke kúú va ra Seꞌe Ndioxi ―*kachi ra Juan. ");
INSERT INTO mxv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ra saa kuu inka tuku kii, ra íin tuku va ra Juan nuu sakuchi ra yuvi xiꞌin uvi ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ra saa xini ra Juan ña xika Jesús ika̱n, ra saa ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ―Kutoꞌni ndo, chi ra kaa kuvi ra kuu ndikachi loꞌo ra kuu kuenda Ndioxi ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ra te xini soꞌo ndia uvi kan ña kachi ra Juan saa, saa ra ndikun ndakundikun ndia kuaꞌan ndia sata Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ra saa ndikokuiin Jesús ndakutoꞌni ra, ra xini ra ña ndikun ndia kuaꞌan ndia sata ra, ra saa ndindakatuꞌun ra ndia kachi ra saa: ―¿Ni ke ^ndanduku ndo? ―kachi ra xiꞌin ndia. Ra saa ndakuiin ndia kachi ndia saa: ―Rabí, ¿ndia mii ke iyoo kun? ―kachi ndia xiꞌin ra. Tuꞌun “Rabí” yoꞌo, ra “maestro” va ke kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Naꞌa ndo, na kuꞌun yo xiꞌin yu ra kuni ndo ―kachi ra. Ra saa ndakiꞌin ndia ndixaꞌan ndia xiꞌin ra, ra xini ndia nuu kanduꞌu ra; ra ndia kan kuachi ndia xiꞌin va ra kii kan, saa chi xa kaa kumi xikuaa va ke ndixaa ndia xiꞌin ra nuu kanduꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iin ndia uvi, ndia xini soꞌo ña ndikaꞌan ra Juan xaꞌa Jesús, ra ndakundikun ndia ra kuvi ra Andrés ñani ra Simón Pedro. ");
INSERT INTO mxv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ra ra Andrés yoꞌo, ra nu̱ú ni ka va ra Simón ñani ra kuvi ra nanduku ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Xa ndaniꞌi va ndi ra kuu Mesías ―kachi ra xiꞌin ra. Tuꞌun Mesías yoꞌo, ra “Ra ndikaxin Ndioxi sakaku na yuuvi yoꞌo” va ke kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ra saa ndiaka ra Andrés ra Simón ñani ra ndixaa ra nuu Jesús. Ra ta xini Jesús ra Simón, ra saa ndikaꞌan ra xiꞌin ra kachi ra saa: ―Yoꞌo kuvi Simón, seꞌe ra Jonás, ra vichin ndakunani kun Cefas ―kachi ra xiꞌin ra. Ra tuꞌun Cefas yoꞌo, ra Pedro va ke kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ra ta ndituvi inka kii ndakani ini Jesús ña kuꞌun ra chi ñuu ña ndikun ndiaa Galilea. Ra saa ndakiꞌin ra kuaꞌan va ra, ra ikan ndakutaꞌan ra xiꞌin ra Felipe ra ndikaꞌan ra xiꞌin ra, kachi ra saa: ―Kundikun yuꞌu ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ra ra Felipe yoꞌo, ra ra ñuu Betsaida va kuvi ra, ra suvi ra ñuu kan ku tu ra Andrés xiꞌin ra Pedro va. ");
INSERT INTO mxv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ra saa ndixaꞌan ra Felipe nanduku ra ra Natanael ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Xa ndaniꞌi va ndi tia̱à ra tiaa ra Moisés xaꞌa, ra suvi xaꞌa ra kan ke ndikaꞌan tu na ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va. Ra ra kan kuvi Jesús, seꞌe ra José ra ñuu Nazaret va ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ra saa ndakuiin ra Natanael kachi ra saa: ―¿A kuvi vi tan kanata iin tiaa ra vaꞌa ñuu Nazaret? ―kachi ra. Ra saa ndakuiin ra Felipe kachi ra saa xiꞌin ra: ―Na koꞌo, ra kuni kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ra ta xini Jesús ña ^kuyachin ra Natanael kuaꞌan ra nuu ra, ra saa ndikaꞌan ra kachi ra saa: ―Ra ^vaxi yoꞌo ra mii ra ñuu Israel ndixa kuvi ra, saa chi köo ña maña nuu ra ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ra saa ndindakatuꞌun ra Natanael Jesús kachi ra saa: ―¿Nichuun vaꞌa xíni̱ kun yuꞌu? ―kachi ra xiꞌin ra. Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ta kumani ka kaꞌan ra Felipe xiꞌin kun, ra xa xini va yu yoꞌo ña ^nduꞌu kun xaꞌa itun koxi ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ra saa ndikaꞌan ra Natanael kachi ra saa xiꞌin Jesús: ―Maestro, yoꞌo kuvi ndixa va ra kuu Seꞌe Ndioxi, ra yoꞌo kuvi tu ra kuu Rey na ñuu Israel va ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ra: ―¿A xaꞌa ña ndikaꞌan yu xiꞌin kun ña xa xini yu yoꞌo, ña ^nduꞌu kun xaꞌa itun koxi ke kandixa kun yuꞌu? Ndi su vichin ra kuaꞌa ni ka va ña xituꞌun kuni kun ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ra saa ndikaꞌan ka Jesús xiꞌin ra kachi ra saa: ―Ña ndixa ke ^kaꞌan yu xiꞌin ndo, saa chi vaxi kii, ra kuni ndo ña nuña ndivi, ra kuni tu ndo ndia tatun Ndioxi ña kuanda̱a ndia chi ndivi, ra vaxi nuu ndia sata yuꞌu ra xaa yoꞌo vichin ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ra saa kuu te ndiyaꞌa uni kii, ra saa ndixiyo iin viko tandaꞌa ñuu Caná, ña ndikun ndiaa chi Galilea. Ra ndixaa tu siꞌí Jesús va nuu iyoo viko kan, ");
INSERT INTO mxv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ra kana tu na Jesús va ndixaa ra xiꞌin ndia itaꞌan xiꞌin ra nuu iyoo viko tandaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ra saa kuu ndia ndee ndia kan saa ra ndiꞌi va vino, ra saa ndikaꞌan siꞌí Jesús xiꞌin ra kachi ña saa: ―Köo ka vino koꞌo na ―kachi ña̱. ");
INSERT INTO mxv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ña: ―Nana, ¿nichuun ^kaꞌan kun saa xiꞌin yu? Saa chi täan xa̱a̱ kii ña xaꞌa yu sachiñu yu ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ra saa ndikaꞌan ña xiꞌin na chuꞌun ndaꞌa kan, kachi ña saa: ―Na sa ndo takundiꞌi ña ^kaꞌan ra xiꞌin ndo ―kachi ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ra nuu iyoo viko kan ndita i̱ñu̱ kisi yuu naꞌnu, ña xiniñuꞌu na judío taan na tiakuii ra ndaꞌa na, saa chi xa saa yunaꞌa va na. Ra kuꞌva iin ciento litro kuvi tiakuii ra kita ñuꞌu ini iin iin kisi kan. ");
INSERT INTO mxv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ra saa ndikaꞌan Jesús xiꞌin na chuꞌun ndaꞌa kan kachi ra saa: ―Sakutu ndo i̱ñu̱ saa kisi yoꞌo xiꞌin tiakuii ―kachi ra. Ra saa sakutu ndáá na kisi kan xiꞌin tiakuii. ");
INSERT INTO mxv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ra te ndiꞌi saa ndikaꞌan ra xiꞌin na kachi ra saa: ―Tava ndo loꞌo rá, taxi ndo ndaꞌa ra ndíso chiñu tava viko ―kachi ra xiꞌin na. Ra saa tava na rá taxi na ndaꞌa ra ndiso chiñu tava viko kan. ");
INSERT INTO mxv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ra te ixtondoso ra tiakuii ra nduu vino kan, ra nii ndikundäa ini ra ndia mii ke kee ra, ndi su na chuꞌun ndaꞌa ra xa kundaa va ini na kan, saa chi mii na kan kuvi na taan va tiakuii ini kisi kan. Ra saa ndakana ra ndíso chiñu ndatava viko kan mii ra tandaꞌa kan, ");
INSERT INTO mxv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Takundiꞌi yuvi ra xiꞌna ka va vino ra váꞌa, kuvi ra taxi na xiꞌi yuvi na xaꞌan viko, ra te xa ndiꞌi ra kan xiꞌi na, ra saa vi ke tava na vino ra nu̱u. Ndi su yoꞌo, ra nduvi ni va xa kun saa chi chuvaꞌa va kun vino ra vaꞌa, ra ndia vichin vi ndatava kun ra ―kachi ra ndiso chiñu ndatava viko kan xiꞌin ra tandaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ña yoꞌo ku ña xituꞌun ña nuu vaꞌa xa Jesús ñuu Caná, ña ndikun ndiaa chi Galilea, ña ndañaꞌa ra ndiee ña iyoo xiꞌin ra, saa ra kandixa va ndia itaꞌan xiꞌin ra ra. ");
INSERT INTO mxv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ra te ndiꞌi viko yoꞌo, saa ndakutaꞌan Jesús xiꞌin siꞌi ra, xiꞌin ndia ñani ra, xiꞌin ndia itaꞌan xiꞌin ra; ra ndakiꞌin na kuaꞌan na chi ñuu Capernaum, ra ikan xindee na ndiaꞌvi kii. ");
INSERT INTO mxv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ra saa kuu ra xa kuaꞌan kuyachin va kii ña koo viko pascua, ña ndatava na judío, ra saa ndakiꞌin Jesús kuaꞌan ra chi ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ra te ndixaa ra ndikiꞌvi ra kuaꞌan ra nuu keꞌe veꞌe ñuꞌu kaꞌnu kan, ra saa xini ra na ndee ixiko sindiki, xiꞌin paloma, xiꞌin ndikachi, xiꞌin na ndéé ^nama xuꞌun xiꞌin yu̱vi. ");
INSERT INTO mxv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ra saa nduku ra ñii, ra xavaꞌa ra ñii ndoꞌo xiꞌin ña, ra xiꞌin ña kan ke tava ra takundiꞌi na ndee ixiko chi keꞌe kuaꞌan na, ra saa tu kiti sana va na, ta kuu sindiki xiꞌin ndikachi, xiꞌin paloma. Ra sanduva ndiꞌi tu ra mesa na ndee nama xuꞌun xiꞌin yuvi va, ra ndixitia ndiꞌi xuꞌun na. ");
INSERT INTO mxv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ra saa ndikaꞌan ra xiꞌin na ndee ixiko paloma kachi ra saa: ―¡Tava ndo ri yóꞌo chi keꞌe! ¡Saa chi veꞌe Tata va yu kuvi ña yoꞌo, ra na ndäsa ndo ña nuu yaꞌvi! ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ra saa ndakaꞌan ndia itaꞌan xiꞌin Jesús xaꞌa tuꞌun ña ndikaꞌan ra rey David xiꞌin Ndioxi te yachi ta kachi ra suꞌva: “^Ndiꞌi ni ini yu xaꞌa veꞌe kun chi kuni ni yu ña na koo vaꞌa ña”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ra saa kuyachi ndia judío ra ndindakatuꞌun ndia Jesús kachi ndia saa: ―¿Ndia ña ku iin ña xituꞌun sa kun kuni ndi, ña vaꞌa na kandixa ndi ña taxi Ndioxi ndiayu ndaꞌa kun ña tava kun na ndee ixiko nuu keꞌe veꞌe ñuꞌu kaꞌnu yoꞌo? ―*kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―^Kani ndo veꞌe ñuꞌu kaꞌnu yóꞌo, ra kii uni ndakani ndichi yu ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ra saa ndikaꞌan ndia judío kan kachi ndia saa xiꞌin Jesús: ―Uvi xiko i̱ñu̱ kuiya vi ke kuvaꞌa veꞌe ñuꞌu kaꞌnu yoꞌo. ¿Ra yoꞌo tu, kaꞌan ña ndakani ndichi kun ña uni kuiti kii va? ―*kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndi su süvi xaꞌa veꞌe ñuꞌu kaꞌnu kan ke ndikaꞌan Jesús xiꞌin ndia, chi xaꞌa iki kuñu va ra ke ndikaꞌan ra xiꞌin ndia, ña kachi ra saa. ");
INSERT INTO mxv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ña kan ke ta ndixiꞌi Jesús ra ndatiaku tuku ra, ra saa ndakaꞌan ndia xitaꞌan xiꞌin ra xaꞌa tuꞌun ña ndikaꞌan ra xiꞌin ndia, ra saa kandixa vaꞌa ka va ndia tuꞌun Ndioxi, ra saa tu tuꞌun ña ndikaꞌan mii Jesús xiꞌin va ndia. ");
INSERT INTO mxv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ra saa kuu Jesús íin ra ñuu Jerusalén ta ndasakaꞌnu na viko pascua, ra kuaꞌa ka vi yuvi xaꞌa ^kandixa ñaꞌa, te xini na ña kuaꞌa ni ña xituꞌun xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ndi su Jesús ra ndikandïxa vi ra na, saa chi xa xíni̱ va ra ndia kuꞌva ke iyoo takundiꞌi yuvi. ");
INSERT INTO mxv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña kan ke ndixïniñuꞌu vi ra ndia nii yuvi ña ndatuꞌun na xiꞌin ra xaꞌa yuvi kan, saa chi Jesús ra xa xini ndiꞌi va ra ndia kuꞌva ke iyoo nima takundiꞌi yuvi. ");
INSERT INTO mxv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ndixiyo iin ra fariseo ra xinani Nicodemo, ra ra xikuaꞌa xikuu ra nuu na judío. ");
INSERT INTO mxv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ra saa kuu, ra kee ra iin ñuu ndixaꞌan ra nuu Jesús, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Maestro, kundaa va ini ndi ña ndixa ke Ndioxi kuvi va ra tiꞌvi yoꞌo xaa kun ña sañaꞌa kun nduꞌu, saa chi ndia nii na kuchüun sa ña xituꞌun ña xa kun yoꞌo, tu köo Ndioxi íin xiꞌin na ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin kun chi tu na ndakäku xaa iin yuvi, saa ra küvi vi kuni na nuu xaꞌndia Ndioxi chiñu ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ra saa ndindakatuꞌun ra Nicodemo Jesús kachi ra saa: ―¿Ni ke sa iin yuvi ña ndakaku tuku na ta xa chee na? ¿Ama kuvi ndita tuku na tixi siꞌi na ra ndakaku tuku na? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ña ndixa ke kaꞌan yu xiꞌin kun saa chi tu na ndakäku iin yuvi xiꞌin tiakuii xiꞌin Tachi yii Ndioxi, saa ra küvi vi kiꞌvi na nuu xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Takundiꞌi na kaku tixi siꞌi, ra kuñu kuvi vi va na, ra na kaku xiꞌin Tachi Yii Ndioxi ra kuenda Tachi Yii Ndioxi kuvi va na. ");
INSERT INTO mxv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ra na ndakända ini kun ña kaꞌan yu ña yoꞌo xiꞌin kun: “Chi ña xiniñuꞌu va ke ndakaku xaa yuvi.” ");
INSERT INTO mxv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ra na kundaa ini kun chi tachi ra kani ña kuaꞌan ña choꞌo ra kani tu kuaꞌan ña chikaa va, ra xini tu soꞌo kun xika va ña, ndi su kundäa ini kun ndia mii vaxi ña, ra nii kundäa tu ini kun ndia chi kuaꞌan va ña. Ra saa ke iyoo tu takundiꞌi na kaku xiꞌin Tachi Yii Ndioxi va ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ra saa ndindakatuꞌun tuku ra Nicodemo Jesús kachi ra saa: ―¿Ndia va kuꞌva ke kuu ña yoꞌo? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―¿Nichuun kundäa ini kun xiꞌin ña yoꞌo, ra maestro na Israel vi kuvi kun? ");
INSERT INTO mxv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ña ndixa ke kaꞌan yu xiꞌin kun chi ña ^xíni̱ ndi xaꞌa va ke kaꞌan ndi xaꞌa xiꞌin ndo; ra ña xini nuu tu ndi ke ^ndatuꞌun ndi xiꞌin ndo xaꞌa va; ndi su ndoꞌo, ra xïin ndo kandixa ndo ña kaꞌan ndi. ");
INSERT INTO mxv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ra tu kandïxa ndo yuꞌu ña kaꞌan yu xaꞌa ñaꞌa ña iyoo ña yuuvi yoꞌo xiꞌin ndo, saa ra, ¿ndixaa sa tu ndo ña kandixa ndo tu na kaꞌan yu xaꞌa ñaꞌa ña iyoo chi ndivi xiꞌin ndo? ");
INSERT INTO mxv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ra na kundaa ini ndo chi ndia nii yuvi täan ndaa ndivi, ra nuu tuku na, ndi su iyoo va indaa ra kee ndivi, ra ra kan kuvi ra xaa nuu ña yuuvi yoꞌo vichin va. ");
INSERT INTO mxv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ra ta kuꞌva xa ra Moisés ña xavaꞌa ra iin ko̱o̱ ra chinduꞌu ra ri xini iin itun, ra ndakani ndichi ra nu xiꞌin ri iku yuu, ra kuꞌva saa ke xiniñuꞌu tu ndoniꞌi na ra xaa yoꞌo vichin va, ");
INSERT INTO mxv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ña vaꞌa na kaku takundiꞌi yuvi, na kandixa ñaꞌa, ra kutiaku na ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Saa chi kuꞌvi ni ini Ndioxi xini ra na yuuvi yoꞌo, ña kan ke tiꞌvi ra seꞌe ra, ra mituꞌun nuu ra ña kixi ra ndixiꞌi ra xaꞌa na, ra takundiꞌi na kandixa ñaꞌa, ra ndoñüꞌu na, chi niꞌi va na ña kutiaku na xiꞌin ra ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ra nditïꞌvi Ndioxi seꞌe ra ña kixi ra ña kaꞌan ra ña na ndoꞌo na yuuvi yoꞌo xaꞌa kuachi na, chi xaꞌa ña sakaku va ra na ke kixi ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ra takundiꞌi na kandixa Seꞌe Ndioxi ra ^käꞌan ra ña ndoꞌo na xaꞌa kuachi na; ra na xïin kandixa ñaꞌa ra ^kaꞌan va ra ña na ndoꞌo na kan xaꞌa kuachi na, saa chi xïin na kandixa na seꞌe Ndioxi ra mituꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ra xaꞌa ña yoꞌo ke sayukun Ndioxi kuachi xiꞌin va na; saa chi kixi ñùꞌù ña kutuun nuu na, ra ndikandïxa na ña, chi kuni ni ka va na ña ñaa nuu ñùꞌù ña yeꞌe, saa chi chuun kiꞌvi ke ^xa va na. ");
INSERT INTO mxv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ra takundiꞌi yuvi na ^xa chiñu kiꞌvi ra kundasi va na ñùꞌù ña tuun, ra xïin na kuyachin na nuu ña, saa chi tu köo, ra ndatuvi ndiꞌi va xaꞌa chiñu kiꞌvi ña xa na. ");
INSERT INTO mxv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ndi su yuvi na ^xa chiñu vaꞌa, ra kuyachin va na kan nuu ñùꞌù ña tuun, ña vaꞌa ndañaꞌa tuni na ña ^xa na chiñu xiꞌin ndiee Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te ndiꞌi yoꞌo, ra sa ndakiꞌin Jesús kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra chi Judea, ra ikan ndixiyo ra iin ndiaꞌvi kii xiꞌin na ñuu kan, ra sakuchi tu ra yuvi va. ");
INSERT INTO mxv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ra ra Juan tu xindikaa sakuchi yuvi iin ñuu ña nani Enón ña ndikaa yachin nuu nani Salim va. Saa chi ikan ku nuu iyoo kuaꞌa tiakuii va, ra kuaꞌa ni yuvi ndixaꞌan nuu ra Juan ña sakuchi ra na. ");
INSERT INTO mxv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ra te täan tiin na ra Juan kuꞌun ra veꞌe kàà vi ke xa ra ña yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ra saa xaꞌa sava ndia itaꞌan xiꞌin ra Juan ña xa kuachi ndia xiꞌin na judío xaꞌa ña yunaꞌa na xa na ña ndasa vii na xiꞌin mii na xiꞌin ña ndakatia na ñaꞌa ña kuu mii na ña saxinu na ndiayu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ra saa kee sava ndia ndixaꞌan ndia nuu ra Juan ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Maestro, kutoꞌni, chi ra ndixiin xiꞌin kun chi inka xiyo yuꞌu itia Jordán, ra ndikaꞌan kun xaꞌa, ra vichin ra ^sakuchi tu ra kan va yuvi, ra kuaꞌa ni ka va na kuaꞌan nuu ra kan ―kachi ndia xiꞌin ra Juan. ");
INSERT INTO mxv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ra saa ndakuiin ra Juan kachi ra saa: ―Ndia nii yuvi ra küvi sa na iin chiñu tu na täxi Ndioxi ndiayu ndaꞌa na ña sa na ña. ");
INSERT INTO mxv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ra xa ta kachi yu xiꞌin ndo ta yachi ke iyoo va ña: “Chi süvi yuꞌu ku Cristo, chi ra inuu vaxi kaꞌan xiꞌin yuvi ña ndakoo nduvi va na kuvi yu.” ");
INSERT INTO mxv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ra na kundaa ini ndo, chi ta ^kuu nuu iyoo viko tandaꞌa, ra ra íin xiꞌin ñaꞌa ña tandaꞌa kan va kuvi ra kuu yii ña, ndi su ra itaꞌan xiꞌin ra kuu yii ñaꞌa kan, ra nduꞌu yachin xitia ra, ra te xini soꞌo ra ña kaꞌan ra tandaꞌa kan saa ra tiaa ni va kusii ini ra xiꞌin ra; ra mii saa ke ndoꞌo tu yuꞌu va vichin, saa chi xa xiꞌin va yo íin ra xaa sakaku yoo, ña kan ke kusii ni ini yu. ");
INSERT INTO mxv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ra ra kan kuvi ra, xiniñuꞌu kuaꞌnu ra nduu ra ra kaꞌnu va, ra yuꞌu kuvi ra ndakundikun va ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ra ra kee chi ndivi kuvi ra kaꞌnu nuu takundiꞌi va na yuuvi yoꞌo. Ra na iyoo nuu ña yuuvi yoꞌo, ra ña iyoo nuu ña yuuvi yoꞌo ke kaꞌan na xaꞌa va, ndi su ra kee chi ndivi kuvi ra kaꞌnu nuu takundiꞌi va yuvi. ");
INSERT INTO mxv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ra ña xini ra xiꞌin ña xini soꞌo ra, ra ndatuꞌun va ra ña xiꞌin na yuuvi yoꞌo, ndi su ndia nii na xïin kandixa ña ndatuꞌun ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ra na kandixa ña kaꞌan ra, ra na kan kuvi na kundaa ini ña kaꞌan Ndioxi ña ndaa va; ");
INSERT INTO mxv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","saa chi seꞌe Ndioxi ra tiꞌvi ra xaa, ra tuꞌun Ndioxi ke kaꞌan va ra, saa chi Ndioxi, ra taxi va ra takundiꞌi ndiee Tachi Yii ra ndaꞌa seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ra Ndioxi, ra kuu iva ra, ra kuꞌvi ni va ini ra xini ra ra, ña kan ke ndataxi ra takundiꞌi va ñaꞌa ña iyoo nuu ra ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ra na kandixa seꞌe Ndioxi, ra niꞌi va na kan ña kutiaku na ndia ndikaa ndikuꞌun; ndi su na xïin kandixa seꞌe Ndioxi, ra nïꞌi vi na kan ña kutiaku na xiꞌin ra, chi ña niꞌi na kan kuvi tundoꞌo ndiee ña taxi Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ra saa kuu ra kundaa va ini ndia fariseo ña kuaꞌa ni ka yuvi ndakundikun sata Jesús nuu ra Juan, saa chi viꞌi ni ka va na sakuchi ra nuu ra Juan. ");
INSERT INTO mxv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ra süvi ndixa mii vi Jesús kuvi ra ndisakuchi na, chi ndia itaꞌan xiꞌin va ra kuvi ndia sakuchi na. ");
INSERT INTO mxv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ra te kundaa ini Jesús ña kachi ndia saa xaꞌa ra, ra saa kee ra chi Judea ra ndakiꞌin tuku ra kuaꞌan ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ra ña xaa ra chi Galilea ra xiniñuꞌu ndiakua yaꞌa va ra chi Samaria saa xaa ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ra saa ndixaa ra iin ñuu ña nani Sicar ña ndikun ndiaa Samaria, ña ndikaa yachin nuu nduꞌu ñuꞌu ña saniꞌi ra Jacob ra José seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ra ikan íin yavi kunu ña kaan ra Jacob nuu tava na tiakuii xiꞌi na. Ra saa ndixaa Jesús xikunduꞌu ra yuꞌu ña ndakindiee ra, chi kuñaa ni ra. Ra kuꞌva ka uxi uvi kaꞌñu kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Saa ndixaa iin ñaꞌa ña ñuu kan ña tava ña tiakuii ini yavi kunu kan, ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Taxi loꞌo tiakuii na koꞌo yu, Nana ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ra ndia itaꞌan xiꞌin ra, ra ñaꞌa ña kuxi ndia xiꞌin va ra kuaꞌan ndia sata ndia ñuu kan. ");
INSERT INTO mxv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Saa ndakuiin ñaꞌa kan kachi ña saa: ―¿Nichuun nduku yoꞌo tiakuii koꞌo kun nuu yu? Ra süvi taꞌan kun kuvi yuꞌu chi ña Samaria va kuvi yu, ra yoꞌo ra ra judío va kuvi kun ―kachi ña xiꞌin Jesús. Ra suꞌva ke kachi ñaꞌa kan saa chi ndakanda ni va ini ña xaꞌa ña nduku ra tiakuii nuu ña saa chi na judío, xiꞌin na Samaria, ra itäꞌan vii na chi na kanitaꞌan va kuvi na. ");
INSERT INTO mxv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ñaꞌa kan: ―Tu na kundaa ini kun ña kaꞌnu ña taxi Ndioxi, ra kundaa tu ini kun yoo kuvi ra kaꞌan xiꞌin kun ña taxi kun tiakuii koꞌo ra, saa ra mii va kun kuvi ña nduku tiakuii nuu ra, ra ra kan ra tiakuii ra taxi ña kutiaku va kun kuvi ra taxi ra koꞌo kun ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Saa ndakuiin ñaꞌa kan kachi ña saa xiꞌin ra: ―Tata, tiaa ni kunu ndikaa tiakuii yoꞌo, ra nii ñaꞌa köo niꞌi kun ña tava kun ra. ¿Ra ndia mii kuꞌun kiꞌin kun tiakuii ra taxi ña kutiaku yuvi, ra kaꞌan kun xaꞌa taxi kun koꞌo yu? ");
INSERT INTO mxv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ra xii xikua ndi Jacob va kuvi ra ndakoo yavi yoꞌo ndaꞌa ndi, ra mii yoꞌo ke kana tiakuii xiꞌi va ra, ra saa tu seꞌe va ra, ra saa tu kiti sana va ra. ¿Ra a chee ka va yoꞌo nuu ra kan? ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Saa ndakuiin Jesús kachi ra saa xiꞌin ña: ―Takundiꞌi yuvi na xiꞌi tiakuii tia kee ini yavi yoꞌo, ra iin kani loꞌo ra xa ndachi tuku va ini na. ");
INSERT INTO mxv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ndi su na koꞌo tiakuii ra ^taxi yuꞌu, ra ndia nii ka kii ndächi ini na. Saa chi tiakuii ra taxi yuꞌu, ra iin ta kuꞌva iyoo iin itia kaꞌnu iin saa koo ra, ña kana ra ini na, ra ra kan kuvi ra taxi ña kutiaku na ndia ndikaa ndikuꞌun ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ra saa ndikaꞌan ñaꞌa kan xiꞌin Jesús kachi ña saa: ―Tata, taxi loꞌo tiakuii ra kaꞌan kun xaꞌa ñaa koꞌo yu, ra na ndächi ka ini yu, ra nii na kïxi ka tu yu yoꞌo va ña tava yu tiakuii yoꞌo ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Kuaꞌan ndakiꞌin yii kun ra na kixi ra xiꞌin kun yoꞌo ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Saa ndakuiin ñaꞌa kan kachi ña saa: ―Köo yii yu, Tata ―kachi ña. Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―¡Mii ña ndixa ni va ke ndikaꞌan kun ña köo yii kun! ");
INSERT INTO mxv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Saa chi xa uꞌun vi yii kun ndixiyo, ra nii ra nduꞌu xiꞌin kun vichin kuu süvi yii vi kun. ¡Mii ña ndixa ni va ke ndikaꞌan kun! ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Saa ndikaꞌan ña xiꞌin Jesús kachi ña saa: ―Tata, ña tuvi yu, ra ra kaꞌan tuꞌun yuꞌu Ndioxi va kuvi kun. ");
INSERT INTO mxv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ra na xii xikua ndi, ra iku yoꞌo va ke ndasakaꞌnu na Ndioxi, ndi su ndoꞌo na judío, ra ñuu Jerusalén va ke xiniñuꞌu ndasakaꞌnu ndo Ndioxi kachi ndo ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ña: ―Nana, na kandixa kun tuꞌun ña kaꞌan yu xiꞌin kun, chi xa ndixaa va kii ña xiniñüꞌu ka ndiakua kixi vi ndo xiki yoꞌo ña ndasakaꞌnu ndo Ndioxi, ra nii ñuu Jerusalén ke xiniñüꞌu kuꞌun vi ndo, ña ndasakaꞌnu ndo ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ndoꞌo, na Samaria, ra kundäa ini vi ndo ni ñaꞌa ke ndasakaꞌnu ndo, ndi su nduꞌu, na judío, ra kundaa va ini ndi yoo ndasakaꞌnu ndi. Ra tiañu nduꞌu ke kanata va iin ra sakaku na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ra vichin ke xa ndixaa va kii, ra na ndinuni ni ini ndasakaꞌnu Ndioxi, ra na ndasakaꞌnu ni ka va na Tata na Ndioxi xiꞌin ndiee Tachi Yii ra xiꞌin ña ndaa ta kuꞌva kuni mii ra, saa chi taꞌan na kan kuvi na kuni va Tata yo Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Saa chi Ndioxi ra ta iyoo tachi va saa iyoo ra, ña kan ke na ndasakaꞌnu na ra ta kuꞌva iyoo va ra ―kachi Jesús xiꞌin ñaꞌa kan. ");
INSERT INTO mxv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ra saa ndikaꞌan ñaꞌa kan kachi ña saa: ―Xa kundaa va ini yu ña tiꞌvi Ndioxi iin tiaa ña kixi ra sakaku ra yoo, ra ra kan kuvi ra kaꞌan yo kuu Cristo. Ra te na xaa ra kan, ra ra kan kuvi ra ndakani nuu yo xaꞌa takundiꞌi va ña iyoo ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ña: ―Yuꞌu, ra kaꞌan xiꞌin kun yoꞌo kuvi va ra ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ra saa kuu Jesús kaꞌan ra xiꞌin ñaꞌa kan, saa ra xaa tu ndia itaꞌan xiꞌin va ra, ra ndakanda ni ini ndia ta xini ndia ña ndatuꞌun ra xiꞌin ñaꞌa kan. Ndi su ndia nii ndia ndixändiee ini ña ndakatuꞌun ndia ra nichuun ke ndatuꞌun ra xiꞌin ña, a ni xaꞌa ke kaꞌan ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ra saa ndakoo ñaꞌa kan yoo ña xiko ña tiakuii, ra ndakiꞌin ña xinu ña kuaꞌan ña ñuu kaꞌnu kan, ra ikan ndikaꞌan ña xiꞌin takundiꞌi yuvi kan kachi ña saa: ");
INSERT INTO mxv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Naꞌa ndo, kuꞌun yo xiꞌin yu ra kuni ndo, chi ikan nduꞌu iin tiaa ra ndikaꞌan ra xiꞌin yu xaꞌa takundiꞌi va ña xa yu. Ra kusana ra kan va kuvi Cristo, ra xaa sakaku yoo ―kachi ña xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ra saa kee takundiꞌi na ñuu kan kuaꞌan na nu nduꞌu Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ra nani saa kuu yuvi yoꞌo kuaꞌan na nuu nduꞌu ra, ra saa xaꞌa ndia itaꞌan xiꞌin ra ña xakundaꞌvi ndia nuu ra, ra kaꞌan ndia kachi ndia saa: ―Rabí, kuxi va ra loꞌo ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Xa iyoo va ñaꞌa ña kuxi yu, ra xïni vi ndoꞌo ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ra saa xaꞌa ndia itaꞌan xiꞌin ra kaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―¿A ndia na kixi taxi ña xixi va ra? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ñaꞌa ña xixi yu kuvi ña xa yu chiñu ña kuni Tata yu ra tiꞌvi yuꞌu vaxi va yu, xiꞌin ña saxinu yu chiñu ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ra vaꞌa ni kuni ka va kumi yoo saa sakee ndoꞌo”, kachi ndo; ndi su yuꞌu, ra suꞌva va tu kachi yu xiꞌin ndo vichin, ndoniꞌi ndo nuu ndo ra koto ndo iinii kuvi nuu ñuꞌu ra kuni ndo, chi xa iin yayaa va kaa xiꞌin ñaꞌa tata, ra xavaꞌa va sakee yo. ");
INSERT INTO mxv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ra na sakee ra ndakiꞌin na yaꞌvi va na, ra ñaꞌa ña sakee na kan, ra ña kutiaku ndia ndikaa ndikuꞌun va kuvi ña, ra na ^chiꞌi ña xiꞌin na ndakaya ña ra na kusii ni ini va na. ");
INSERT INTO mxv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ra yoꞌo ke xinu nuu tuꞌun ndichi ña kaꞌan na ta kachi na suꞌva: “Iin na chiꞌi ña ra inka tu na ^ndakaya va ña”. ");
INSERT INTO mxv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ra yuꞌu kuvi ra ^tiꞌvi ndoꞌo ña kuꞌun ndo ndakaya ndo ñaꞌa ña ndichïꞌi ndo, saa chi inka yuvi va kuvi na chiꞌi nuu kuꞌun ndo sakee ndo vichin ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ra tiaa ni kuaꞌa na Samaria kandixa Jesús xaꞌa tuꞌun ña ndatuꞌun ñaꞌa kan xiꞌin na, saa chi ndikaꞌan ña kachi ña saa: “Ndikaꞌan ndiꞌi va ra xiꞌin yu xaꞌa chiñu ña xa yu”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ra saa kuyachin na Samaria kan nuu Jesús, ra xakundaꞌvi na nuu ra ña na kuachi ra xiꞌin na, ra saa kuachi ra ñuu kan uvi kii xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ra kuaꞌa ni ka va na kandixa tuꞌun ña xini soꞌo na ña ndikaꞌan mii ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ra saa ndikaꞌan na kachi na saa xiꞌin ñaꞌa kan: ―Vichin ra kandixa va ndi, ndi su süvi takua xaꞌa tuꞌun ña ndikaꞌan yoꞌo xiꞌin ndi ke kandixa ndi, chi xini tu mii va ndi ña ndikaꞌan ra ña kan ke kundaa ini ndi ña ndixa ra yoꞌo kuvi va ra kuu Cristo, ra xaa sakaku na ñuu yuuvi yoꞌo ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ra saa kuu ra ndiyaꞌa va uvi kii kan, ra saa kanata Jesús ñuu kan ra ndakiꞌin ra kuaꞌan ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ra “Ndia nii na kaꞌan tuꞌun yuꞌu Ndioxi ra xätoꞌo na na mii ñuu na” kachi Jesús ndikaꞌan ra ta yachi. ");
INSERT INTO mxv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ra saa te ndixaa ra chi Galilea, ra na ndee ñuu kan ra vii ni ndakiꞌin na ra, saa chi te ndixaꞌan na viko pascua ñuu Jerusalén ra xini ndiꞌi va na ña xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ra saa nandiko tuku Jesús chi ñuu Caná ña ndikun ndiaa Galilea nuu ndasa ra tiakuii vino. Ra yachin kan ndikaa iin ñuu ña nani Capernaum, ra ikan kanduꞌu iin tiaa ra xachiñu nuu ra rey Herodes ra Antipas, ra tiaa kan ra iyoo iin seꞌe ra, ra xa ra kuni kuvi va kuvi ra loꞌo kan. ");
INSERT INTO mxv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ra te kundaa ini ra xachiñu nuu ra rey kan ña kee Jesús ndia Judea ra xaa ra ndia chi Galilea, ra saa ndixaꞌan ra nuu Jesús ra xakundaꞌvi ra nuu ra, ña na kuꞌun ra xiꞌin ra veꞌe ra, ra sandaꞌa ra seꞌe ra, chi xa ra kuni kuvi va kuvi ra loꞌo seꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ndoꞌo, ra kandïxa vi ndo yuꞌu tu na sä yu ña xituꞌun xiꞌin ña ndichi kuni ndo ―kachi ra xiꞌin tiaa kan. ");
INSERT INTO mxv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ra saa ndikaꞌan tiaa ra xachiñu nuu ra rey kan kachi ra saa: ―Tata, sa ña mani ra na koꞌo xiꞌin yu chi tu köo, ra kuvi va seꞌe yu ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Kuanuꞌu veꞌe kun, chi xa iyoo vaꞌa va seꞌe kun, Tata ―kachi ra xiꞌin ra. Ra tiaa kan ra kandixa va ra ña ndikaꞌan Jesús xiꞌin ra, ra saa ndakiꞌin ra kuanuꞌu ra veꞌe va ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ra nani saa kuu ra ndikaa ra ichi kuaꞌan ra, saa xaa sava na xachiñu nuu ra ichi kan ndakutaꞌan na xiꞌin ra, ra ndikaꞌan na xiꞌin ra kachi na saa: ―Xa nduvaꞌa va seꞌe kun ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ra saa nindakatuꞌun ra na kachi ra saa: ―¿Ndia hora ke xaꞌa kuaꞌan kuvita loꞌo ña xiꞌin seꞌe yu? ―kachi ra xiꞌin na. Ra saa ndikaꞌan na kachi na saa xiꞌin ra: ―Kuꞌva ka iin xikuaa kuni vi ke nuu kaꞌni seꞌe kun ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ra saa ndakaꞌan ra iyoo seꞌe kan ña kuꞌva mii hora kan ke ndikaꞌan Jesús xiꞌin ra kachi ra saa: “Xa nduvaꞌa va seꞌe kun”, kachi ra. Ra mii ra xiꞌin na veꞌe ra ra kandixa ndiꞌi va na Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ra ña yoꞌo ku ña xituꞌun ña uvi xa Jesús, te kee ra Judea ra nandiko ra xaa ra Galilea. ");
INSERT INTO mxv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ra te ndiꞌi kuu ña yoꞌo, ra saa ndakiꞌin Jesús kuaꞌan ra chi ñuu Jerusalén, saa chi xa ndinumi tu ndatava na judío va iin viko. ");
INSERT INTO mxv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ra ñuu Jerusalén kan iyoo iin nuu nani yeꞌe ndikachi, ra ikan ndikaa iin pila nuu ñuꞌu tiakuii, ra xavaꞌa na korra siꞌin yuu yuꞌu ña ra saa tu maꞌñu va ña, ra ndasi xini nu, ra nuna ndiꞌi va tiañu siꞌin kan, ra vaꞌa yaꞌa na uꞌun saa xiyo va, ra Betesda ke nani ña tuꞌun hebreo. ");
INSERT INTO mxv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ra ikan ndee kuaꞌa ni na xiꞌi, na kuaa, na köo iin xiyo xaꞌa, xiꞌin na nduchiꞌña küvi kaka, ña ndiatu na kanda nuu tiakuii kan. ");
INSERT INTO mxv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Saa chi iin kama suꞌva va ^nduxinu iin ra tatun Ndioxi ña sakanda ra tiakuii kan; ra yuvi na nuu vaꞌa kita ini tiakuii kan te ndiꞌi suꞌva kanda ra, ra ndia ndia ka mii kueꞌe ke xiꞌin na ra nduvaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ra tiañu na kan kanduꞌu iin tiaa, ra xa oko xaꞌun uni kuiya vi ke ndiee ndoꞌo ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ra te xini Jesús ra ña kanduꞌu ra ikan, ra kundaa ini ra ña xa kuaꞌa ni kuiya ke kaa ra saa, ra saa ndikaꞌan ra xiꞌin ra kachi ra saa: ―¿A kuni kun nduvaꞌa kun? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ra saa ndakuiin ra xiꞌi kan kachi ra saa: ―Tata, köo mii vi yuvi tiin yuꞌu ra chikaa na yuꞌu ini tiakuii kaa te kanda ra, ra te kuni yu kuꞌun yu kita yu, saa ra xa inka va na kita nuu yu, ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Ndakoo, ra ndakiꞌin kun ixto kun ra kuaꞌan ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saa ra ndikun nduvaꞌa va tiaa kan ra saa ndakiꞌin ra ixto ra ra ndakiꞌin ra kuaꞌan va ra. Ra kii yii ña ndakindiee va na ke nduvaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Saa ndikaꞌan na judío xiꞌin tiaa ra nduvaꞌa kan kachi na saa: ―Köo ndiayu ña kaniꞌi kun ixto kun kaka kun vichin chi kii yii ndakindiee va yo kuvi ña ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ra saa ndakuiin tiaa kan yuꞌu na kachi ra saa: ―Tiaa ra sandaꞌa yuꞌu, kuvi ra ndikaꞌan xiꞌin yu kachi ra saa: “Ndakiꞌin ixto kun ra kaka kuaꞌan”, kachi ra xiꞌin yu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ra saa nindakatuꞌun na ra kachi na saa: ―¿Yoo kuvi ra ndikaꞌan xiꞌin kun, ña ndakiꞌin kun ixto kun ra kuꞌun kun? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ndi su tiaa kan ra ndikundäa ini vi ra ndia tiaa kuvi ra sandaꞌa ñaꞌa, saa chi Jesús ra xa kita va ra tiañu yuvi ndee kan kuaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ra te ndiꞌi saa ndaniꞌi Jesús tiaa ra nduvaꞌa kan ini veꞌe ñuꞌu kaꞌnu, ra saa ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kotoꞌni, chi vichin ra xa nduvaꞌa va kun, ra ña kan ke xä ka kun kuachi, chi tu köo ra iyo ini kixi tundoꞌo ña chee vaꞌa ka nuu kun ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ra saa ndakiꞌin tiaa kan ndixaꞌan ra, ra ndatuꞌun ra xiꞌin ndia judío xaꞌa Jesús, chi Jesús va kuvi ra sandaꞌa ñaꞌa. ");
INSERT INTO mxv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ra xaꞌa ña sandaꞌa Jesús yuvi kii ndakindiee va ke ndixika nduku ndia judío tiin ndia ra, ra kaꞌni ndia ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Tata yu, ra iin ndisaa kii va xachiñu ra, ña kan ke iin takundiꞌi kii ke xachiñu tu yuꞌu va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ra xaꞌa tuꞌun yoꞌo ke ndixika nduku ni ka na judío ña kaꞌni na Jesús, saa chi süvi niña kii yii ndakindiee na kuvi ña ndikanduu ra, chi ndikaꞌan tu ra ña kuu Iva ra Ndioxi va, ra iin kuvi va tu ra xiꞌin Ndioxi kachi ra, ña kan ke ndisaa ni ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, chi ra kuu seꞌe Ndioxi, ra ndia nii chiñu loꞌo ke kuchüun ra sa vii ra xiꞌin ndiee mii ra; saa chi takundiꞌi chiñu ña ^xini ra ^xa Iva va ra ke ^xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Saa chi Iva ra, ra kuꞌvi ni va ini ra xini ra ra, ña kan ke ñaꞌa ra takundiꞌi va chiñu ña ^xa ra nuu ra; ra chiñu chee vaꞌa ka va ñaꞌa ra nuu ra kuni ndo, ra saa ke tiaa ni ka va ndakanda ini ndo. ");
INSERT INTO mxv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Saa chi ta kuꞌva ^xa Iva ra ña sandatiaku ra na ndii, ra ^taxi ka ra ña kutiaku na, ra mii saa ke ^xa tu ra kuu seꞌe va ra, chi ^taxi tu ra kan va ña kutiaku na kuni mii ra taxi ra ña ndaꞌa. ");
INSERT INTO mxv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ra ra kuu Iva ra, ra ndia nii yuvi ku na xä ndaku ra kan kuachi xiꞌin vi, chi ndaꞌa ra kuu seꞌe va ra ke ndataxi ra takundiꞌi ndiayu ña sandaku ra kuachi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Saa ke vaꞌa na satoꞌo na ra ta kuꞌva xa na ña xatoꞌo na Iva ra. Chi yuvi na xïin satoꞌo ra kuu seꞌe Ndioxi, saa ra, xätoꞌo tu na Iva va ra, chi Iva ra kuvi ra tiꞌvi ñaꞌa vaxi va ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ra ña ndixa ni ke kaꞌan yu xiꞌin ndo, saa chi yuvi na xini soꞌo tuꞌun ña kaꞌan yu, ra kandixa tu na ra tiꞌvi yuꞌu vaxi yu, ra na kan kuvi na niꞌi kutiaku ndia ndikaa ndikuꞌun; ra küꞌun ka na nuu ndoꞌo na, saa chi xa ndikaku va na nuu ña kuvi na, ra xa na kutiaku va kuvi na vichin. ");
INSERT INTO mxv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi vaxi kii, ra xa mii kii vichin kuvi va ña kuni soꞌo na ndii tachi ra kuu seꞌe Ndioxi; ra na kuiin kuni soꞌo kuvi na niꞌi kutiaku va. ");
INSERT INTO mxv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chi ta kuꞌva iyoo Ndioxi ña kuu mii ra ndiee ra ^taxi ra ña tiaku yuvi, ra saa ke iyoo tu ra kuu seꞌe va ra, saa chi mii Ndioxi kuvi tu ra taxi ndiayu ndaꞌa ra kuu seꞌe va ra, ña taxi ra ña kutiaku yuvi. ");
INSERT INTO mxv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ra taxi tu ra ndiayu ndaꞌa ra ña sandaku ra kuachi xiꞌin takundiꞌi yuvi va, xaꞌa ña kuu ra ra xaa ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ra na ndakända ni ini ndo xaꞌa ña kaꞌan yu ña yoꞌo xiꞌin ndo, saa chi vaxi kii ra takundiꞌi na xa ndixiꞌi ndoꞌni tixi ñuꞌu ra kuni va soꞌo na tachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ra na xa ña vaꞌa, ra ndakoyo na kan yavi nuu ninduxin na na, ra ndatiaku na ña kutiaku va na; ndi su na xa ña väꞌa, ra ndakoyo tu na kan va yavi nuu ninduxin na na, ra ndatiaku na kan ña kuꞌun na chi nuu ndoꞌo va na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Yuꞌu, ra süvi xiꞌin ndiayu mii yu ke xa ndaku yu kuachi xiꞌin yuvi, chi xiꞌin ndiayu Tata yu ra tiꞌvi yuꞌu vaxi va yu ke xa ndaku yu ña xiꞌin na, ra ndaku ni va ^tiin yu kuachi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ra tu na kaꞌan vaꞌa ni yu xaꞌa mii yu nuu ndo, saa ra köo yaꞌvi ndiaa vi ña saa chi ra xavaꞌa ini va kuvi yu, kachi ndo. ");
INSERT INTO mxv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ndi su iyoo va iin tiaa ra ndakuiin xaꞌa yu, ra kundaa ini yu chi ña kaꞌan ra kan, ra ña ndixa ni va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ra mii ndo kuvi ndo tiꞌvi yuvi ña ndixaꞌan na nindakatuꞌun na ra Juan va, ra mii ña ndaa va ke ndatuꞌun ra xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ndi su yuꞌu ra xiniñüꞌu vi yu ndia nii yuvi ña kaꞌan vaꞌa na xaꞌa yu, chi ña kuni yu kaku va ndo ke, kaꞌan yu ña yoꞌo xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ra ra Juan ra ta iyoo iin ñùꞌù ña vaꞌa ni tuun va ke ndixiyo ra kan, ra xiin va ndo kusii ini ndo xiꞌin ñùꞌù yeꞌe ña kuu mii ra iin kani loꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ndi su chee ni ka va iin ña ndakuiin xaꞌa yuꞌu nuu tuꞌun ña ndikaꞌan ra Juan, saa chi chiñu ña xa va yu ke ndakuiin xaꞌa yu, ra Tata yu Ndioxi va kuvi ra taxi chiñu yoꞌo ndaꞌa yu ña saxinu yu nuu ña, ra mii chiñu yoꞌo ke ndakuiin tu xaꞌa va yu ña tiꞌvi ra yuꞌu vaxi yu. ");
INSERT INTO mxv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ra tata yu, ra tiꞌvi yuꞌu vaxi yu, ra ndakuiin tu ra kan va xaꞌa yu; ra ndoꞌo, ra ndia nii ichi ke täan kuni soꞌo ndo tachi vi ra, ra nii täan kuni tu ndo ndixaa kaa va tu ra, ");
INSERT INTO mxv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ra nii tuꞌun tu ra ke köo nima vi ndo, saa chi xïin ndo kandixa ndo ra tiꞌvi ra xaa. ");
INSERT INTO mxv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ra tiaa ni va vii ^kaꞌvi ndo tuꞌun Ndioxi, saa chi nuu ña ñaa ke ndiatu ndo ndaniꞌi ndo ña kutiaku ndo ndia ndikaa ndikuꞌun va, ra tu na kundaa ini ndo chi xaꞌa yuꞌu va ke ndakani ña; ");
INSERT INTO mxv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ra xïin ndo kixi ndo nuu yuꞌu, ra ^taxi ña kutiaku ndo ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Yuꞌu ra xiniñüꞌu yu ña kaꞌan vaꞌa ni yuvi xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ra xa kundaa tu ini yu, ndia kuꞌva ke íin va ndo, chi ndoꞌo ra kuëe kuꞌvi ini ndo xini ndo Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ra yuꞌu, ra xiꞌin ndiayu Tata va yu ke vaxi yu, ra xïin ndo kandixa ndo yuꞌu, ra tu inka tu na na kixi xiꞌin ndiayu mii, saa ra ndakiꞌin mani va ndo na kan. ");
INSERT INTO mxv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ra ni ke sa ndo ña vaꞌa kandixa ndo tuvi ndo, tu niña ndo ndasakaꞌnu taꞌan mii va kuvi ndo, ra xïin ndo nanduku ndo ña kaꞌnu ña taxi indaa Ndioxi ra tiaku? ");
INSERT INTO mxv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ra ndakäni ini ndo ña kaꞌán ndo saa, ña taxi yuꞌu kuachi xaꞌa ndo nuu Tata yu Ndioxi. Chi ra ^taxi kuachi xaꞌa ndo kuvi ra Moisés va, ra ra kan kuvi tu ra ndiaa ni ini va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ra tu ndixa kandixa ndo ra Moisés, saa ra kandixa tu ndo yuꞌu va, chi xaꞌa yuꞌu ke kaꞌan tuꞌun Ndioxi ña tiaa ra Moisés va. ");
INSERT INTO mxv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ndi su tu xïin va tu ndo kandixa ndo ña tiaa ra Moisés, saa ra, ¿ndixaa sa ndo kandixa ndo ña kaꞌan yuꞌu tu saa? ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te ndiꞌi yoꞌo, saa ndakiꞌin Jesús kuaꞌan ra chi inka xiyo yuꞌu tiañuꞌu ra ndikaa chi Galilea, ra suvi mii ra kan ku tu ra nani Tiberias va. ");
INSERT INTO mxv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ra iin tiaꞌndia chee yuvi ndikun kuaꞌan sata ra, saa chi xini na ^xa ra ña xituꞌun ña sandaꞌa ra na xiꞌi. ");
INSERT INTO mxv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ra saa ndaa Jesús xini iin iku, ra ikan ndakunduꞌu ra xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ra xa ninumi ni va koo viko pascua, viko ña ndatava mii na judío. ");
INSERT INTO mxv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ra te ndakutoꞌni Jesús ra saa xini ra iin tiaꞌndia chee yuvi ndikun xaa nuu nduꞌu ra, ra saa ndikaꞌan ra xiꞌin ra Felipe kachi ra saa: ―¿Ndia mii kuꞌun yo sata yo ñaꞌa kuxi yuvi kaa ra kuaꞌa ni kuvi na? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ndi su ra ixtondoso va Jesús kuvi ra Felipe ña kachi ra saa xiꞌin ra; saa chi xa xini vaꞌa va mii ra ni ke sa ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ra saa ndakuiin ra Felipe kachi ra saa: ―Nii uvi ciento denario va xita na sata yo, ra kïta mii vi ña kuxi na chi tiaa ni kuaꞌa kuvi na ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ra saa ndikaꞌan iin ra itaꞌan xiꞌin Jesús, ra nani Andrés, ñani ra Simón Pedro kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Yoꞌo xika iin ra loꞌo ra niꞌi ra uꞌun xita ña cebada, ra niꞌi tu uvi tiaka vali va, ndi su kïta vi ña yoꞌo kuxi yuvi yoꞌo, chi kuaꞌa ni kuvi na ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ra saa ndikaꞌan Jesús kachi ra saa: ―Kaꞌan ndo xiꞌin takundiꞌi na ña na ndakundee vii na ―kachi ra xiꞌin ndia. Ra iyoo ka vi itia kuii vali nuu ñuꞌu kan, ra saa ndakundee vii na nuu itia kan, ra kuꞌva uꞌun mil kuvi niña tiaa va. ");
INSERT INTO mxv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ra saa kiꞌin Jesús xita, ra ndataxi ra tixaꞌvi ndaꞌa Ndioxi xaꞌa ña, ra saa ndataꞌvi ra ña xiꞌin ndia itaꞌan xiꞌin ra, ra ndia kan ndataꞌvi tu ña xiꞌin yuvi na ndakundee nuu itia kan va. Ra mii saa xa tu ra xiꞌin tiaka vali kan va, ra xixi takundiꞌi va yuvi kan ndiakua nditiandiaa ini na. ");
INSERT INTO mxv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ra te ndiꞌi nditiandiaa ini na xixi na, saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Ndakaya ndo ñaꞌñu ña nindoo ndoso yuꞌu na, ra saa ke ndia nii loꞌo ña na ndïꞌi xaꞌa ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ra saa ndakaya ndia ña, ra nuu uꞌun ixta ña cebada kan, ra uxi uvi ka vi tuka sakutu ndia xiꞌin ñaꞌñu ña nindoo ndoso. ");
INSERT INTO mxv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ra te xini yuvi kan ña xituꞌun xa Jesús, ra saa ndikaꞌan na kachi na saa: ―Ña ndixa ke ra kaꞌan tuꞌun yuꞌu Ndioxi, ra iyoo tuꞌun kixi nuu ña yuuvi yoꞌo kuvi ndixa va ra yoꞌo ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ndi su te kundaa ini Jesús ña kuni na kundiaka nduxa na ra kuꞌun ra xiꞌin na, ra ndasa na ra rey kuni na, saa ra kuxiyo tuku ra nuu va na, ra ndakiꞌin mituꞌun saa ra kuaꞌan ra chi iku sukun va. ");
INSERT INTO mxv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ra te xa kuaꞌan kuñuu saa nduxinu ndia itaꞌan xiꞌin ra chi yuꞌu tiañuꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ra ikan ndandaa ndia ini iin itun xika nuu mini ra ndakiꞌin ndia kuaꞌan ndia xiꞌin nu chi ñuu Capernaum va. Ra saa xa kuaꞌan kuñuu vaꞌa va, ra köo Jesús xaa niꞌi taꞌan xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ra saa xaꞌa iin ndakundichi ndakundichi nuu tiañuꞌu kan, ^xa tachi, chi ndiee ka vi xaꞌa xika ña. ");
INSERT INTO mxv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ra te xa kuxika ndia kuaꞌan ndia ta kuꞌva uꞌun a i̱ñu̱ mil metro, saa ra xini va ndia Jesús xika ra nuu tiakuii kan xaa ra sata ndia, saa ra ndiyuꞌvi ka vi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¡Kuayüꞌvi ndo, chi yuꞌu va kuvi ra! ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Saa ra kusii ka vi ini ndia ra ndakiꞌin ndia ra, ra nandaa ra ini barca kan kuaꞌan ra xiꞌin va ndia, saa ra iin kuu suꞌva va, saa ra xa ndixaa va ndia chi nu kuaꞌan ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ra te ndituvi inka kii, ra saa xaa tuku va yuvi nuu xa Jesús ña xituꞌun ña ndiatu na ndakutaꞌan na xiꞌin Jesús, chi ndixïni na ña ndaa ra ini barca kan kuꞌun ra xiꞌin ndia itaꞌan xiꞌin ra, chi niña mii va ndia kuvi ndia kuaꞌan xiꞌin indaa saa barca tu xindichi kan. ");
INSERT INTO mxv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ra saa kuu na ndita na, saa ra xaa va sava barca tu kee chi ñuu Tiberias, suvi mii kan va, ra ikan kuu nuu ndataxi Jesús tixaꞌvi ndaꞌa Ndioxi xaꞌa xita ña taxi ra xixi na. ");
INSERT INTO mxv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Saa te kundaa ini yuvi na xa ndee ndiatu kan, xiꞌin na kee ñuu Tiberias ña köo Jesús, ra nii ndia itaꞌan xiꞌin ra kuvi ndia köo, ra saa nandaa takundiꞌi na ini barca tu ndixaa xiꞌin na kee ñuu Tiberias, ra ndakiꞌin na kuaꞌan na chi ñuu Capernaum ña nanduku na Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ra te ndixaa yuvi kan chi inka xiyo yuꞌu tiañuꞌu, ra ikan ndaniꞌi taꞌan na xiꞌin Jesús, ra saa ndikaꞌan na xiꞌin ra kachi na saa: ―Tata Maestro, ¿ama xaa kun yoꞌo? ―*kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ra saa ndakuiin ra kachi ra saa xiꞌin na: ―Ña ndixa kaꞌan yu xiꞌin ndo, chi xaꞌa ña taxi yu ixta xixi ndo ra ndiakua nditiandiaa ini va ndo ke nanduku ndo yuꞌu, chi süvi vi ndixa xaꞌa ña xituꞌun ña xa yu xini ndo ke nanduku ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ra na sä chiñu ndo xaꞌa ñaꞌa ña xixi ndo ña ndiꞌi xaꞌa, chi na sa chiñu ndo xaꞌa ñaꞌa kuxi ndo ña kuëe ndiꞌi xaꞌa, ñaꞌa ña taxi ña kutiaku ndo, ndia ndikaa ndikuꞌun. Ra ñaꞌa ña kuxi ndo ra kutiaku ndo kan, ra ra xaa yoꞌo vichin va kuvi ra taxi ña, saa chi Tata ra Ndioxi va kuvi ra taxi ndiayu ndaꞌa ra ña sa ra ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ra saa ndikaꞌan na xiꞌin ra kachi na saa: ―¿Ni ke xiniñuꞌu sa ndi ña vaꞌa sanduvi ndi chiñu ña kuni Ndioxi? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Chiñu ña kuni Ndioxi sa ndo ke, na kandixa ndo tiaa ra tiꞌvi ra xaa nuu va ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Saa ndakuiin na kachi na saa xiꞌin ra: ―¿Ndia ña ku iin ña xituꞌun sa kun kuni ndi, ra vaꞌa kandixa ndi yoꞌo? ¿Ra a väꞌa ndikun na sa kun ña kuni va ndi? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ra ndikaꞌan ka na xiꞌin ra kachi na saa: ―Na xii xikua ndi ra ixta ña nani maná va ke xixi na kan iku yuu nuu xindoꞌni na, ta kuꞌva kachi mii tuꞌun Ndioxi va: “Saa chi ra Moisés ra ixta ña kee ndivi va ke taxi ra xixi na” ―kachi na xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Ña ndixa ke kaꞌan yu xiꞌin ndo: Saa chi süvi ndixa ra Moisés kuvi ra nditaxi ixta ña kee ndivi xixi na, chi Tata yu Ndioxi va kuvi ra taxi ña, ra ^taxi tu ra ixta ña ndixa, ña kee ndivi kuxi tu ndoꞌo vichin va. ");
INSERT INTO mxv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ra ixta ña taxi Ndioxi kuvi tiaa ra kee ndivi ra xaa ra nuu ña yuuvi yoꞌo vichin, ra ^taxi ra ña kutiaku takundiꞌi va na yuuvi ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ra saa ndikaꞌan na xiꞌin ra kachi na saa: ―Tata, taxi ixta ña kaꞌan kun xaꞌa ñaa kuxi ndi iin ndisaa kii ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Yuꞌu kuvi ra kuu ixta ña ^taxi ña kutiaku yuvi. Ra na vaxi nuu yuꞌu, ra ndia nii ka kii käꞌun ini na, ra na kandixa yuꞌu, ra ndia nii ka tu kii ïchi ini na tiakuii va. ");
INSERT INTO mxv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ra xa ta kachi yu ndikaꞌan yu xiꞌin va ndo, chi ndoꞌo, ra xa xini nuu va ndo yuꞌu, ndi su kuëe kandixa ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ra takundiꞌi yuvi na taxi Tata yu Ndioxi ndaꞌa yu, ra vaxi na nuu va yu, ra na vaxi nuu yu, ra täva yu na keꞌe. ");
INSERT INTO mxv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Saa chi yuꞌu, ra ña kee yu ndivi vaxi yu, ra ndixäa yu ña sa yu ña kuni mii yu, chi ña xiniñuꞌu sa yu ke na saxinu yu nuu chiñu Tata yu Ndioxi, ra tiꞌvi yuꞌu vaxi va yu. ");
INSERT INTO mxv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ra chiñu ña kuni Tata yu Ndioxi ra tiꞌvi yuꞌu vaxi yu ke na sandoñüꞌu yu ndia nii yuvi na taxi ra ndaꞌa yu, chi ña kuni ra kan ke na sandatiaku yu na kii ña vaxi va. ");
INSERT INTO mxv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ra ña kuni ra tiꞌvi yuꞌu vaxi yu ke: na ndoñüꞌu takundiꞌi yuvi na xitoꞌni nuu yu ra kandixa na yuꞌu, ra na kan kuvi na kutiaku ndia ndikaa ndikuꞌun; ra yuꞌu kuvi ra sandatiaku ñaꞌa kii ña vaxi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ra saa xaꞌa na judío kañaꞌa na xaꞌa Jesús, chi ndikaꞌan ra kachi ra saa: “Yuꞌu ku ra kuu ixta ña kee ndivi” ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ra saa ndikaꞌan na xaꞌa ra kachi na saa: ―¿A su Jesús yoꞌo, ra seꞌe ra José va kuvi ra? Xini yo iva ra, ra saa tu siꞌi va ra. ¿Ra nichuun ke kaꞌan ra ña kee ra ndivi? ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Xavaꞌa käꞌan ñaꞌa ndo xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Saa chi ndia nii na küvi kixi nuu yuꞌu, tu süvi tata yu Ndioxi ra tiꞌvi yuꞌu vaxi yu taxi na ndaꞌa yu, ra sandatiaku yu na kii ña vaxi. ");
INSERT INTO mxv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ta kuꞌva kachi tuꞌun Ndioxi ña tiaa na ndikaꞌan tuꞌun ra xinaꞌa, ña kachi suꞌva: “Mii va Ndioxi kuvi ra sañaꞌa takundiꞌi yuvi.” Ra takundiꞌi na xini soꞌo ña kaꞌan Tata yo Ndioxi, ra kutuꞌva na ña kaꞌan ra, ra na kan kuvi na vaxi nuu yu vichin va. ");
INSERT INTO mxv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ra ña kachi yu suꞌva xiꞌin ndo, ra küni kachi ña, ña xa xini nuu na Tata yo Ndioxi, chi indaa mituꞌun ra kee ndivi va kuvi ra xini nuu Tata yo Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ra ña ndixa ke kaꞌan yu xiꞌin ndo; chi yuvi na kandixa yuꞌu, ra niꞌi va na kan ña kutiaku na ndia ndikaa ndikuꞌun xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Saa chi yuꞌu kuvi ra kuu ixta ña ^taxi ña kutiaku va na. ");
INSERT INTO mxv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ra na kundaa ini ndo: Chi na xii xikua ndo ra xixi va na ñaꞌa ña nani maná iku yuu, ra ndixiꞌi va tu na, ");
INSERT INTO mxv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ndi su yuꞌu ra ixta ña kee ndivi va ke kaꞌan yu xiꞌin ndo xaꞌa; ra na kuxi ixta yoꞌo, ra küvi ka na. ");
INSERT INTO mxv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ra Yuꞌu va kuvi ra kuu ixta ña tiaku ña kee ndivi; ra na kuxi ixta yoꞌo kuvi na kutiaku iin ndisaa kii iin ndisaa tiempo va; Ra ixta ña taxi yu kuxi na, kuvi iki kuñu va yu. Ra taxi yu ña xaꞌa ña kutiaku na yuuvi va ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ra saa xaꞌa na judío kan ndatuꞌun kuachi na xiꞌin taꞌan na kachi na saa: ―¿Ni ke sa ra yoꞌo ña taxi ra kuñu ra kaxi yo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, chi tu na käxi ndo kuñu ra kuu Seꞌe Ndioxi, ra köꞌo tu ndo nii ra, saa ra kuchüun vi ndo kutiaku ndo. ");
INSERT INTO mxv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ra na kaxi kuñu yu, ra koꞌo na nii yu, ra na kan kuvi na niꞌi kutiaku ndiaa ndikaa ndikuꞌun, ra sandatiaku tu yu na kii ña vaxi va. ");
INSERT INTO mxv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Saa chi kuñu yu kuvi ñaꞌa ña ndixa xixi na, ra nii yu kuvi ndixa ndutia ra xiꞌi va na. ");
INSERT INTO mxv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ra yuvi na kaxi kuñu yu, ra koꞌo na nii yu, ra na kan kuvi na ndikun yuꞌu, ra yuꞌu tu íin xiꞌin na kan va. ");
INSERT INTO mxv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ra Tata yo Ndioxi ra tiꞌvi yuꞌu vaxi yu, ra ra tiaku va kuvi ra, ña kan ke vaꞌa tiaku yu, ra yuvi na kaxi kuñu yuꞌu, ra kutiaku tu na kan va xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ra ixta ña kee ndivi, ña kaꞌan yu xaꞌa xiꞌin ndo yoꞌo, ra süvi taꞌan ixta ña nani maná ña xixi na xii xikua ndo, ra ndixiꞌi va tu na kuvi ña, chi xa siin va kuvi ña yoꞌo, chi na kuxi ña yoꞌo, ra iin ndisaa kii iin ndisaa tiempo ke kutiaku va na ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ra takundiꞌi ña yoꞌo ke sañaꞌa Jesús yuvi ini veꞌe ñuꞌu ña íin ñuu Capernaum. ");
INSERT INTO mxv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ra te xini soꞌo na itaꞌan xiꞌin Jesús tuꞌun ña ndikaꞌan ra, ra saa ndikaꞌan na kachi na saa: ―Tiaa ni ndaku tuꞌun ña kaꞌan ra yoꞌo, ¿ra yoo ku na kundiee saxinu nuu ña? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ra xa kundaa va ini Jesús ña ndatuꞌun kuachi ni na itaꞌan xiꞌin ra xaꞌa tuꞌun ña ndikaꞌan ra, ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¿A ^tixuꞌvi ni ini ndo xiꞌin tuꞌun yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tu saa, ¿ra ni ke sa tu ndo tu na kuni ndo nandaa yuꞌu ra xaa yoꞌo chi ndivi nuu xinduꞌu yu ta yachi? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Tachi Ndioxi va kuvi ña taxi ña tiaku; ra ndiee ña kuu mii yuvi ra köo mii ña kuchuun ña sa vi ña. Ra tuꞌun ña ndikaꞌan yu xiꞌin ndo, ke taxi ña tiaku nima yuvi va. ");
INSERT INTO mxv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ndi su sava ndo ra kandïxa vi ndo yuꞌu ―kachi ra xiꞌin na. Ra suꞌva ke kachi Jesús xiꞌin na, saa chi ndia ta kii xaꞌa vi ke xa kundaa ini ra, yoo kuvi na ndikandïxa ñaꞌa, ra xa kundaa tu ini ra, yoo kuvi ra xiko ñaꞌa nuu na sáa̱ ini va. ");
INSERT INTO mxv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ra saa ndikaꞌan ka ra xiꞌin na kachi ra saa: ―Ra xaꞌa ña yoꞌo va ke ndikaꞌan yu xiꞌin ndo, chi ndia nii yuvi, küvi kixi nuu yu, tu süvi Tata yo Ndioxi kuvi ra taxi na ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ra mii kii kan ra kuaꞌa ni na itaꞌan xiꞌin Jesús nandiko kuaꞌan, ra ndixïka ka na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ra saa ndindakatuꞌun Jesús ndia uxi uvi ndia itaꞌan xiꞌin ra kachi ra saa: ―¿A kuꞌun tu ndoꞌo va xiꞌin na, kuni ndo? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ra saa ndakuiin ra Simón Pedro kachi ra saa: ―Tata, ¿yoo nuu ka ke kuꞌun ndi? Ra xa tuꞌun ña kaꞌan kun ke taxi ña kutiaku va ndi. ");
INSERT INTO mxv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ra nduꞌu, ra xa kandixa va ndi, ra kundaa ini ndi ña kuu kun Cristo, Seꞌe Ndioxi ra tiaku va ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A su yuꞌu kuvi ra ndikaxin uxi uvi saa va ndo? Ndi su, iin ndoꞌo kuvi ndia kuu timiaꞌa va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ra ña kachi ra saa, ra xaꞌa ra Judas Iscariote, seꞌe ra Simón va ke ndikaꞌan ra, saa chi ra Judas kuvi ra ndataxi ra ndaꞌa na sáa̱ ini xini ñaꞌa, ra ra yoꞌo ku ra xitaꞌan xiꞌin ndia ña kuu ndia uxi uvi ña xitaꞌan ndia xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ra suvi mii ñuu ña ndoꞌni chi Galilea kan ke, ndixika niꞌni va Jesús tiempo kan, saa chi ndiküni ra koo ra chi Judea, saa chi na judío ra na xika nduku va ku na ña kaꞌni na ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ra nani saa kuu Jesús xika ra, saa ra xa kuaꞌan kuyachin ni tu koo viko ña ndatava na judío, ta kuiya ta kuiya va, ña xavaꞌa na veꞌe tuvixin vali ndee na. ");
INSERT INTO mxv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ra xaꞌa ña kan ke ndikaꞌan ndia ñani Jesús xiꞌin ra kachi ndia saa: ―Kanata ñuu yoꞌo, ra kuaꞌan chi Judea, ña vaꞌa na kuni tu na ndikun sata kun na ndee kan va chiñu ña xa kun. ");
INSERT INTO mxv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Saa chi iin tiaa ra kuni ña na kundaa ndiꞌi ini yuvi xaꞌa ra, ra xä seꞌe ra chiñu. Ra ña kan ke yoꞌo, ra chiñu ña xa kun ra na sa kun ña kuni takundiꞌi va yuvi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Saa chi nii ndia ñani ra, ra ndikandïxa vi ndia ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Täan xaa kii ña kuꞌun yu, ndi su nuu ndoꞌo ra ndia ndia ka mii kii ra ña vaꞌa kuvi va ña. ");
INSERT INTO mxv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Saa chi na yuuvi yoꞌo, ra küvi vi kundasi na ndoꞌo, ndi su kundasi va na yuꞌu, xaꞌa ña kaꞌan yu xiꞌin na ña xa na chiñu ña väꞌa. ");
INSERT INTO mxv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ña kan ke na kuꞌun mii va ndo viko, chi yuꞌu ra küꞌun yu, saa chi täan xa kii ña kuꞌun yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo xiꞌin ndia, ra saa nindoo ra chi Galilea va. ");
INSERT INTO mxv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ra te xa ndakiꞌin ndia ñani ra kuaꞌan ndia, ra saa ndakiꞌin tu mii va ra kuaꞌan ra viko kan, ndi kuäꞌan tuvi ra, chi kuaꞌan seꞌe va ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ra ndanduku ni va na judío ra viko kan, ra ndikaꞌan na kachi na saa: ―¿Ndia chi xika tiaa kan? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ra yuvi kan ra iin niniꞌi kaꞌan na xaꞌa ra. Ra sava na kaꞌan kachi na saa: “Ra vaꞌa va kuvi ra”, kachi na. Ra sava tu na kaꞌan kachi saa: “Süvi ra vaꞌa kuvi ra, chi ra sandaꞌvi yuvi va kuvi ra”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ra ndia nii na ndiküvi kaꞌan tuvi xaꞌa Jesús, xaꞌa ña iyuꞌvi na nuu na judío. ");
INSERT INTO mxv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ra te xa nditaꞌvi sava viko kan, ra saa ndikiꞌvi Jesús kuaꞌan ra nuu keꞌe veꞌe ñuꞌu kaꞌnu, ra xaꞌa ra sañaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Saa ra iin ndakanda ini na judío kan ra kachi na saa: ―¿Ni ke ^xa tiaa yoꞌo ña xini ni ra, ra ndikäꞌvi ra xaꞌa tuꞌun Ndioxi veꞌe ñuꞌu? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Ña sañaꞌa yu, ra süvi ña sandaku mii yu kuvi ña, chi ra tiꞌvi yuꞌu vaxi va yu kuvi ra ^taxi ña. ");
INSERT INTO mxv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ra na kuni sa ña kaꞌan Ndioxi, ra ndakuni va na a ndixa Ndioxi ku ra taxi ña sañaꞌa yu, a ña sandaku ini mii va yu kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Saa chi ra kaꞌan ña ^ndaku ini mii, ra ña kuni ra ña na satoꞌo ni yuvi va ra ke kaꞌan ra; ndi su ra kuni ña na satoꞌo ni na ra tiꞌvi ñaꞌa vaxi ra, ra ña ndaa va kaꞌan ra, ra sandäꞌvi ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ra ndoꞌo, ra ña ndixa ke iyoo va ndiayu Ndioxi ña ndakoo ra Moisés ndaꞌa ndo, ndi su ndia nii ndo xïin kandixa ña. ¿Nichuun kuni ndo kaꞌni ndo yuꞌu? ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ra saa ndakuiin takundiꞌi yuvi kan kachi na saa: ―Tachi ndivaꞌa va ke iyoo xiꞌin kun, saa chi ¿yoo ku na kuni kaꞌni yoꞌo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Xaꞌa ña xa yu iin ña xituꞌun kii ndakindiee yo ke ndiee ni ndakanda ini ndo. ");
INSERT INTO mxv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ndi su xachiñu tu ndoꞌo va kii ña ndakindiee yo, chi xaꞌndia va ndo ñii loꞌo xini kaꞌa tiaa vali seꞌe ndo, ña saxinu ndo ndiayu ña ndakoo ra Moisés ndaꞌa ndo (ra süvi vi ra Moisés kuvi ra nindakoo ña, chi na xii xikua va ndo kuvi na xa ña). ");
INSERT INTO mxv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ra tu xaꞌa ña küni ndo kanduu ndo ndiayu ña ndakoo ra Moisés va ke xaꞌndia ndo ñii xini kaꞌa seꞌe tiaa vali ndo kii ña ndakindiee yo, ra na kundaa ini ndo, chi ña vaꞌa ke xa tu yuꞌu va kii ña ndakindiee yo, saa chi iin tiaa ka vi sandaꞌa yu, ¿ra nichuun sáa̱ ndo xiꞌin yu? ");
INSERT INTO mxv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ra na sandäku ndo kuachi ta kuꞌva tuvi mii ndo, chi xiꞌna ka va na kundaa vaꞌa ini ndo ndia kuꞌva ke iyoo iin chiñu ra saa ke vaꞌa sandaku ndo iin kuachi xiꞌin mii ña ndaa ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ra saa xaꞌa sava mii na ñuu Jerusalén kan kaꞌan na kachi na saa: ―¿A süvi ra yoꞌo, kuvi ra xika nduku na kaꞌni na? ");
INSERT INTO mxv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ra yoꞌo va tu íin ra kaꞌan ndoso ra nuu takundiꞌi yuvi, ra köo mii na kaꞌan xiꞌin vi ra. ¿Ra a Cristo ku ndixa va ra tuvi na chiñu? ");
INSERT INTO mxv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndi su ra yoꞌo, ra xini va yo ndia ke kee ra, ra te xa na kixi ra kuu Cristo ra ndia nii na kundäa ini ndia mii ke kee vi ra kan ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ra saa kuu Jesús íin ra sañaꞌa ra na nuu keꞌe veꞌe ñuꞌu kan, ra kundaa va ini ra ña kaꞌan na xaꞌa ra, ra saa ndiee ka vi ndoniꞌi ra tachi ra, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―^Xini ndo yuꞌu, ra ^xini tu ndo ñuu va yu tuvi, ndo, ndi su na kundaa ini ndo, chi süvi ña kuni mii yu ke vaxi yu, chi iyoo va iin ra ndaa, ra ra kan va kuvi ra tiꞌvi yuꞌu ña vaxi yu, ra ndoꞌo, ra xïni vi ndo ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndi su yuꞌu ra xini va yu ra, chi nuu ra kan ke kee va yu vaxi yu, chi ra kan kuvi ra tiꞌvi yuꞌu va ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ra saa xaꞌa sava na kuni tiin na Jesús ña chikaa na ra veꞌe kàà, ndi su ndia nii na ndixändiee ini ña tiin na ra, saa chi täan xaa kii ña tiin na ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ra kuaꞌa ni na ndee ini veꞌe ñuꞌu kaꞌnu kan, ra kandixa va na Jesús, ra ndikaꞌan na ^kachi na saa: ―Te na xaa ra kuu Cristo, ¿ra a kuaꞌa ni ka va ña xituꞌun sa ra kan, nuu ña ^xa ra yoꞌo? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ra saa xini soꞌo na fariseo ña ndiee ni kaꞌan yuvi kan xaꞌa Jesús, ra saa ndakutaꞌan na xiꞌin na xikuaꞌa nuu ndia sutu ra xaꞌndia na chiñu nuu ndia kumisio ndiaa veꞌe ñuꞌu kaꞌnu kan, ña na tiin ndia Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ra saa ndikaꞌan Jesús xiꞌin yuvi kan kachi ra saa: ―Saloꞌo ni va tiempo íin yu xiꞌin ndo, saa ra nandiko yu kuꞌun yu nuu ra tiꞌvi yuꞌu vaxi va yu. ");
INSERT INTO mxv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ra ndoꞌo, ra nanduku ni va ndo yuꞌu, ndi su ndanïꞌi ndo yuꞌu, ra nii nuu kuꞌun yu koo yu ke kuchüun ndo kuꞌun vi ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ra saa xaꞌa na judío kan ndakatuꞌun taꞌan na kachi na saa: ―¿Ndia chi ke kuꞌun ra yoꞌo ña kaꞌan ra, ña ndanïꞌi yo ra? ¿A nuu na taꞌan yo, na xinuꞌni kuaꞌan ndoꞌni tiañu na griego ke kuꞌun ra, ra ikan sañaꞌa ra na griego kan va? ");
INSERT INTO mxv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ra ni ke kuni kachi tuꞌun yoꞌo ña ndikaꞌan ra ña xiꞌin yo: “Nanduku ndo yuꞌu, ndi su ndanïꞌi ndo yuꞌu, ra nii nuu kuꞌun yu koo yu, kuchüun ndo xaa vi ndo kachi ra”? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ra kii ña ndiꞌi viko kan kuvi iin kii ña tiaa ni ka va ndasakaꞌnu na judío. Ra mii kii kan ke ndakundichi Jesús ra ndiee ka vi ndikaꞌan ra xiꞌin na kachi ra saa: ―Tu ndia ndo ndachi ini, ra naꞌa ndo nuu yu, ra yuꞌu taxi tiakuii koꞌo ndo. ");
INSERT INTO mxv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ra yuvi na kandixa yuꞌu, ra ini vi na ke kana iin itia kaꞌnu, ra tiakuii ra taxi ña tiaku yuvi va kuvi ra, ta kuꞌva kachi tuꞌun Ndioxi ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ra ña ndikaꞌan Jesús tuꞌun yoꞌo xiꞌin na, ra xaꞌa Tachi Yii Ndioxi ña xinu koo xiꞌin takundiꞌi na kandixa tuꞌun va ra ke ndikaꞌan ra ña; saa chi täan xaa vi Tachi Yii Ndioxi ña koo ña xiꞌin na, chi täan nandiko Jesús kunuꞌu ra ndivi. ");
INSERT INTO mxv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ra saa te xini soꞌo sava na ndita tiañu yuvi kan, tuꞌun ña ndikaꞌan Jesús, ra saa ndikaꞌan na kachi na saa: ―Tiaa yoꞌo kuvi ndixa va ra vaxi kaꞌan ndoso tuꞌun yuꞌu Ndioxi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ra sava tu na kaꞌan kachi saa: ―Ra yoꞌo kuvi ra kuu Cristo va ―kachi na. Ra inka tu na kaꞌan kachi saa: ―¿Ama kee Cristo chi Galilea? Këe ra chi kan. ");
INSERT INTO mxv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Saa chi Cristo, ra seꞌe xikua ra rey David va ke xiniñuꞌu kuu ra, ra ñuu Belén nuu ndixiyo ra rey David va ke kee ra, kachi tuꞌun Ndioxi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ra saa taꞌvi taꞌan ndiꞌi va yuvi kan xaꞌa Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ra saa kuni sava na tiin na Jesús kuꞌun ra veꞌe kàà, ndi su ndia nii na ndixändiee ini ña tiin na ra. ");
INSERT INTO mxv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ra saa nandiko ndia kumisio, ndia kuaꞌan tiin Jesús ndaxaa ndia nuu ndia xikuaꞌa kunaꞌnu nuu ndia sutu xiꞌin ndia fariseo, ra nindakatuꞌun ndia ndia kachi ndia saa: ―¿Nichuun ndixïndiaka ndo ra kixi ndo? ―kachi ndia xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ra saa ndakuiin ndia kumisio kan kachi ndia saa: ―¡Ndia nii tiaa ra täan kaꞌan ra taꞌan tuꞌun ña kaꞌan ra kan! ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ra saa ndakuiin ndia fariseo kachi ndia saa xiꞌin ndia: ―¿A kuchuun tu ra sandaꞌvi ra ndoꞌo va? ");
INSERT INTO mxv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A kandixa ndia kunaꞌnu nuu ndo ra, tuvi ndo? ¿A ndia kunaꞌnu nuu ndia fariseo tu kandixa ñaꞌa, tuvi ndo? ");
INSERT INTO mxv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Yuvi na xini soꞌo ña kaꞌan ra kan, ra na xïni ndiayu Ndioxi vi kuvi na, chi na nditavi chiꞌña va kuvi na! ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ra nduꞌu tu ra Nicodemo, ra ndixaꞌan seꞌe nuu Jesús iin ñuu va xiꞌin ndia fariseo kan, saa chi fariseo ku tu ra kan va, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Küvi vi sandaku yo kuachi xiꞌin iin tiaa, tu täan kundaa vaꞌa ini yo ndia ña kuu kuachi ra, kachi ndiayu ña iyoo ndaꞌa yo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ra saa ndakuiin ndia, kachi ndia saa xiꞌin ra: ―¿A ra kee ñuu Galilea ku tu yoꞌo va? Na kaꞌvi vaꞌa kun tuꞌun Ndioxi, ra kundaa ini kun, saa chi ndia nii ra kaꞌan tuꞌun yuꞌu Ndioxi täan kee chi Galilea ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ndia saa ra ndakiꞌin ta iin ta iin ndia kuanuꞌu ndia veꞌe va ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ra saa ndakiꞌin Jesús kuaꞌan ra iku nuu yoo itun Olivos. ");
INSERT INTO mxv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ra te ndituvi inka kii ra saa nandiko ra xaa ra ini korra veꞌe ñuꞌu kaꞌnu. Ra saa ndixaa takundiꞌi yuvi kan nuu ra, ra saa ndakunduꞌu ra, ra xaꞌa sañaꞌa ra na. ");
INSERT INTO mxv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ra saa kuu ra ndixaa va sava ndia maestro sañaꞌa ndiayu Ndioxi, xiꞌin ndia fariseo, ra ndiaka ndia iin ñaꞌa ña ndatuvi xiꞌin tiaa ra küu yii ña ndixaa ndia nuu Jesús. Ra xani ndichi ndia ña maꞌñu takundiꞌi yuvi kan. ");
INSERT INTO mxv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ra ndikaꞌan ndia xiꞌin Jesús kachi ndia saa: ―Tata Maestro, ñaꞌa yoꞌo ra xiꞌin iin tiaa ra küu yii ña ke kanduꞌu ña ndatuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ra ndiayu ña ndakoo ra Moisés ra kaꞌan va ña, ña na kuvi taꞌan na siꞌi na xa suꞌva. ¿Ra ndia kuꞌva ke kachi tu yoꞌo? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ra ña ndikaꞌan ndia tuꞌun yoꞌo, ra ndia kuni sandakava va ku vi ndia ra, ña vaꞌa na niꞌi ndia kuachi taxi ndia xaꞌa ra, káꞌán ndia. Ndi su Jesús ra nuu ñuꞌu va ndakandiee ra, ra xaꞌa ra tiaa ra nuu ñuꞌu kan xiꞌin nduku ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ra ndakundiee va ndia ndakatuꞌun ndia ra, ra saa ndoniꞌi ra nuu ra, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Tu ndia iin ndoꞌo ndia köo vaꞌa kuachi tuvi ndo, ra na kunuu ndo kakin ndo yuu va ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ra saa ndakandiee tuku va ra, ra tiaa tuku va ra nuu ñuꞌu kan nduꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ra te ndiꞌi xini soꞌo ndia ña ndikaꞌan ra tuꞌun kan xiꞌin ndia, saa ra ndakiꞌin xini mii va ndia ña iyoo va kuachi ndia, ra saa xaꞌa kee ta iin ta iin mii ndia kunaꞌnu kan kuaꞌan va ndia, ndia saa ra kee tu ndia sava kan va kuaꞌan ndia, ra saa nindoo mituꞌun va ñaꞌa kan nuu nduꞌu Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ra saa ndoniꞌi Jesús nuu ra, ra ndia nii ka yuvi köo ndixini ra, chi ndia mituꞌun saa va ñaꞌa kan ndichi, ra saa ndikaꞌan ra xiꞌin ña kachi ra saa: ―Nana, ¿ndia chi kuaꞌan ndia taxi kuachi xaꞌa kun? ¿A ndia nii ndia ndikäꞌan ña kuvi kun? ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ra saa ndakuiin ñaꞌa kan kachi ña saa: ―Ndia nii ndia, Tata ―kachi ña. Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Ni yuꞌu tu käꞌan ña kuvi va kun. Kuaꞌan ra xä ka kun kuachi ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ra saa ndikaꞌan tuku Jesús xiꞌin yuvi kan, kachi ra saa: ―Yuꞌu kuvi ra kuu ñùꞌù ña tuun nuu ña yuuvi yoꞌo, ra yuvi na ndikun yuꞌu ra käka na nuu ñaa, saa chi ñùꞌù ña taxi ña kutiaku yuvi va ke koo nuu na ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ra saa ndikaꞌan ndia fariseo kan xiꞌin ra kachi ndia saa: ―Yoꞌo, ra mii va kun kuvi ra ndakuiin xaꞌa kun, ra ña kan ke süvi ña ndaa vi ke kaꞌan kun ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Vaꞌa ni mii yu ku ra ndakuiin xaꞌa va yu, ndi su ndiaa yaꞌvi va ña kaꞌan yu. Saa chi yuꞌu ra kundaa va ini yu ndia chi ke kee yu, ra kundaa tu ini yu ndia chi ke kuꞌun va yu; ndi su ndoꞌo ra kundäa ini vi ndo ndia chi ke kee yu, ra nii kundäa tu ini ndo ndia chi kuꞌun va yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ndoꞌo, ra ta kuꞌva kuni mii va ndo ke xa ndaku ndo kuachi, ra yuꞌu ra ndia nii yuvi xandäku yu kuachi vi. ");
INSERT INTO mxv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ra tu xa ndaku yu kuachi, ra ndaku va xa ndaku yu ña, saa chi süvi indaa yuꞌu kuvi ra xa ndaku ña, chi Tata yu Ndioxi ra tiꞌvi yuꞌu vaxi va yu kuvi ra xa ndaku ña xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ra ndiayu mii ndo ke kaꞌan va, tu uvi yuvi ndakuiin xaꞌa iin chiñu, saa ra ña ndixa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ra yuꞌu ra ndakuiin mii yu xaꞌa yu, ra ndakuiin tu Tata yu ra tiꞌvi yuꞌu vaxi va yu xaꞌa yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ra saa nindakatuꞌun ndia ra kachi ndia saa: ―¿Ndia chi íin Tata kun? ―kachi ndia xiꞌin ra. Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Ndoꞌo, ra xïni vi ndo yuꞌu, ra nii Tata yu xïni vi ndo, saa chi tu kundaa ini ndo yoo kuu yuꞌu, saa ra kundaa tu ini ndo yoo kuu Tata va yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ra ini korra veꞌe ñuꞌu kaꞌnu nuu íin ñaꞌa ña taan na xuꞌun ña soko na ke ndichi Jesús sañaꞌa ra, ta ndikaꞌan ra tuꞌun yoꞌo, ndi su ndia nii na ndixäa ndiee ini ña tiin na ra, saa chi täan tandiaa kii ña tiin na ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ra saa ndikaꞌan tuku Jesús xiꞌin ndia kachi ra saa: ―Yuꞌu, ra kuꞌun va yu, ra nanduku ni ndo yuꞌu, ndi su kuvi va ndo xaꞌa kuachi ndo, saa chi nuu kuꞌun yu, ra kuchüun vi ndo kuꞌun ndo ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ra saa ndikaꞌan ndia judío kan xiꞌin taꞌan ndia kachi ndia saa: ―¿A ra kaꞌni mii va kuvi ra, ña kan ke kaꞌan ra ña kuchüun yo kuꞌun yo nuu kuꞌun ra? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Ndoꞌo, ra nuu ñuꞌú yoꞌo va ke ndee ndo, ndi su yuꞌu, ra ndivi va kee yu; ndoꞌo, ra na yuuvi yoꞌo va kuvi ndo, ndi su yuꞌu, ra süvi ra yuuvi yoꞌo kuvi yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ña kan ke ndikaꞌan yu xiꞌin ndo ña kuvi ndo xaꞌa kuachi ndo, saa chi tu na kuïin ndo kandixa ndo yuꞌu ña ^kuu yu tiaa ra kuu yu, saa ra kuvi va ndo xaꞌa kuachi ndo ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ra saa nindakatuꞌun ndia Jesús kachi ndia saa: ―¿Yoo kuvi yoꞌo? ―kachi ndia. Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Xa ta yachi vi ndikaꞌan yu xiꞌin ndo yoo kuvi yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iyoo ni ña kaꞌan yu xaꞌa ña ^xa ndo ra sandaku tu yu xaꞌa ña xiꞌin va ndo. Ra ña ndaa va ke kaꞌan yu saa chi ra tiꞌvi yuꞌu vaxi yu ra ña ndaa va ke kaꞌan ra, ra ña ndikaꞌan ra kan xini soꞌo yu ke, kaꞌan yu xiꞌin na yuuvi yoꞌo va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ndi su ndikundäa ini vi ndia ña kaꞌan ra, xaꞌa Ndioxi ra kuu Tata ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ra saa ndikaꞌan ka Jesús xiꞌin ndia kachi ra saa: ―Te xa na ndoniꞌi ndo yuꞌu ra xaa yoꞌo vichin, ra saa vi ke kundaa ini ndo ña kuu yu tiaa ra kuu yu, ra xä yu ndia nii ña kuni mii yu, chi ña sañaꞌa Tata yu yuꞌu va ke ^xa yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Saa chi íin va ra tiꞌvi yuꞌu vaxi yu xiꞌin yu; Tata yu ra täan ndakoo mituꞌun ra yuꞌu, saa chi niña xa va yu ña kuni ra ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ra kuaꞌa ni na kandixa Jesús, ña kachi ra saa xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ra saa ndikaꞌan Jesús xiꞌin na judío na ndakundikun sata ra kachi ra saa: ―Tu iin ndisaa kii na kundikun ndo tuꞌun ña ^kaꞌan yu xiꞌin ndo, saa ra ndoꞌo kuvi ndo ndikun ndixa yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ra ta xa na kundaa ini ndo ña ndaa, ra ña ndaa kan ke saña ndika ndoꞌo va ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ra saa ndakuiin na kachi na saa xiꞌin ra: ―Nduꞌu ra ndiseꞌe ra Abraham va kuvi ndi, ra ndia nii ichi täan kuꞌun ndi sa chiñu ndaꞌvi ndi nuu inka yuvi. ¿Ra nichuun ke kaꞌan yoꞌo ña saña ndika ndi? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Ña ndaa kaꞌan yu xiꞌin ndo, chi takundiꞌi yuvi na xa kuachi, ra tixi kuachi kan ke ñuꞌu va na, ra xaꞌndia ña chiñu nuu va na. ");
INSERT INTO mxv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ra na kundaa ini ndo chi na xachiñu ndaꞌvi ra kindöo vi na kan veꞌe nuu xa chiñu na iin ndisaa tiempo, ndi su na kuu seꞌe mii ra xiꞌin xitoꞌo veꞌe kan, ra iin ndisaa tiempo va ndee na kan veꞌe ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ña kan ke, tu mii ra kuu Seꞌe Ndioxi kuvi ra na saña ndika ndoꞌo, saa ra ña ndixa ke saña ndika va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ra xa kundaa va ini yu ña kuu ndo ndiseꞌe ra Abraham, ndi su kuni va ndo kaꞌni ndo yuꞌu, saa chi xïin ndo kandixa ndo ña kaꞌan yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yuꞌu, ra chiñu ña sañaꞌa Tata yu yuꞌu va ke kaꞌan yu xaꞌa xiꞌin ndo, ra ndoꞌo, ra chiñu ña sañaꞌa iva siꞌi ndo ndoꞌo va ke ^xa ndo ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ra saa ndakuiin na kachi na saa xiꞌin ra. ―Nduꞌu ra ra Abraham va kuvi Tata ndi ―kachi na. Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin na: ―Tu ndixa seꞌe ra Abraham kuvi ndo, saa ra chiñu ña xa ra kan ke sa tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ndi su ndoꞌo, ra na kuni kaꞌni va kuvi ndo yuꞌu, xaꞌa ña ndikaꞌan yu ña ndaa ña sañaꞌa Tata yu yuꞌu xiꞌin ndo. ¡Ra ra Abraham, ra süvi saa ndixa ra kan! ");
INSERT INTO mxv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ra ndoꞌo ra chiñu ña ^xa tata va va ndo ke ^xa ndo ―*kachi ra xiꞌin na. Ra saa ndakuiin na kachi na saa xiꞌin ra: ―Nduꞌu, ra süvi seꞌe saka na kuvi ndi, chi indaa va kuvi Tata ndi, ra Ndioxi va kuvi ra ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Tu ndixa seꞌe Ndioxi kuvi ndo, saa ra kuꞌvi va ini ndo kuni ndo yuꞌu, saa chi yuꞌu, ra nuu Ndioxi ke kee va yu ña xaa yu yoꞌo. Ra süvi ña kuni mii yu ke ndixaa yu, chi Ndioxi va kuvi ra tiꞌvi yuꞌu xaa yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndoꞌo, ra küvi kundaa ini ndo xiꞌin tuꞌun ña kaꞌan yu xiꞌin ndo, saa chi xïin ndo kuni soꞌo ndo ña kaꞌan yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ña kan ke seꞌe timiaꞌa va kuvi ndo, ra kuenda ri kan kuvi va ndo, ña kan ke kuni ndo sa ndo chiñu ña ^xa ri. Saa chi timiaꞌa, ra ndia ta kii xaꞌa ra niña ri xaꞌni kuvi va ri. Ri kan, ra köo ña ndaku ^xa vi ri, ra nii käꞌan tu ri ña ndaa va. Ra ta kaꞌan ri tuꞌun chiꞌña, ra ta kuni mii ri ke kaꞌan va ri; saa chi ri chiꞌña tuꞌun va kuvi ri, ra ri kan kuvi iva tuꞌun chiꞌña va. ");
INSERT INTO mxv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ra ña kaꞌan yuꞌu, ña ndaa xiꞌin va ndo ke xïin ndo kandixa ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ra ndia iin ndoꞌo kuvi ndo kuvi kaꞌan xiꞌin yu, ña iyoo kuachi yu? Ra tu ña ndaa va ke kaꞌan yu xiꞌin ndo, saa ra, ¿nichuun ke xïin ndo kandixa ndo yuꞌu tu saa? ");
INSERT INTO mxv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Saa chi yuvi na kuu kuenda Ndioxi, ra tuꞌun Ndioxi ke ^xini soꞌo va na, ndi su ndoꞌo, ra süvi kuenda Ndioxi kuvi ndo ña kan ke xïin ndo kuni soꞌo ndo tuꞌun Ndioxi ―*kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ra saa ndikaꞌan na judío kan xiꞌin Jesús kachi na saa: ―Xini vaꞌa va ndi ña ndikaꞌan ndi ña kuu kun ra ñuu Samaria, ra sana kun, ra kuu mii kun tachi ndivaꞌa ―*kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Köo tachi ndivaꞌa ndikaa ini yu, chi Tata yu Ndioxi va kuvi ra xa toꞌo yu, ña kan ke kaꞌan ñaꞌa ndo xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yuꞌu, ra ndïꞌi ini yu a xa toꞌo na yuꞌu a kuëe xa toꞌo na yuꞌu va, saa chi iyoo va iin ra kuni ña na sa toꞌo na yuꞌu, ra ra kan kuvi tu ra xandaku kuachi va. ");
INSERT INTO mxv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ra ña ndaa kaꞌan yu xiꞌin ndo, chi yuvi na kandixa tuꞌun ña kaꞌan yu, ra küvi na ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ra saa ndikaꞌan na judío kan kachi na saa xiꞌin ra: ―Vichin ke ^kundaa kaxi va ini ndi ña ndixa ke ndikaa va tachi ndivaꞌa yoꞌo, saa chi ra Abraham xiꞌin takundiꞌi na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi, ra ndixiꞌi va na. Ra yoꞌo tu kaꞌan, ña küvi na kandixa tuꞌun ña kaꞌan va kun. ");
INSERT INTO mxv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ra a chee ka va yoꞌo nuu ra xii xikua ndi Abraham ra xitiaku ta yachi? Ra kan ra ndixiꞌi va ra, ra saa tu na ndikaꞌan ndoso tuꞌun yuꞌu Ndioxi va. ¿Ra yoꞌo, ra yoo kuvi kun tuvi kun? ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ra saa ndakuiin Jesús kachi ra saa xiꞌin na: ―Tu na chinduꞌu toꞌo ni yu tuꞌun xaꞌa mii yu, saa ra köo yaꞌvi ndiaa vi ña. Saa chi ra kachi ndoꞌo kuu Ndioxi va ndo kuvi ra chinduꞌu toꞌo tuꞌun xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ndi su mii ña ndaa ra xïni vi ndo ra. Ra yuꞌu, ra xini va yu ra. Ra tu na kaꞌan yu ña xïni yu ra, saa ra ra chiꞌña tuꞌun kuvi tu yuꞌu va xiꞌin ndo. Ndi su yuꞌu, ra xini va yu ra ña kan ke kandixa va yu ña kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ra ra Abraham xii xikua ndo ra xitiaku ta yachi, ra kusii ni va ini ra te kundaa ini ra ña kixi yu; ra xini ndixa va ra ña xaa yu, saa ra tiaa ni ka va kusii ini ra ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ra saa ndikaꞌan tuku na judío kan xiꞌin Jesús kachi na saa: ―Ndia nii uvi xiko uxi kuiya ke täan xaa vi kun, ¿ra kaꞌan kun ña xa xini kun ra Abraham? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ra saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi te kuni ka kaku vi ra Abraham ra xa iyoo va yuꞌu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ra saa kiꞌin na yuu kuni kakin na Jesús; ndi su ndiseꞌe va ra nuu na, ra te ndiꞌi saa kita ra ini korra veꞌe ñuꞌu kan, ra suvi mii tiañu na ke ndiyaꞌa tu ra kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ra ichi nuu yaꞌa Jesús kuaꞌan ra kan, nduꞌu iin tiaa ra kaku kuaa. ");
INSERT INTO mxv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ra saa ndindakatuꞌun ndia itaꞌan xiꞌin Jesús kachi ndia saa: ―Tata Maestro, ¿nichuun ke kaku kuaa tiaa yoꞌo? ¿A mii ra kuvi ra iyoo kuachi? ¿A xaꞌa kuachi na iva siꞌi va ra ke? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Süvi xaꞌa kuachi mii ra ke, ra nii süvi tu xaꞌa kuachi na iva siꞌi ra kuvi ña nindoꞌo ra saa, chi xaꞌa ña vaꞌa na kuni yuvi ña iyoo ndiee Ndioxi ña sandaꞌa va ra ra kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ra yoo, ra xiniñuꞌu sa va yo chiñu ra tiꞌvi yuꞌu vaxi yu, ña kuu ka ña kaꞌñu, saa chi ta xa na kuu ñuu ra ndia nii ka yuvi küvi sachiñu vi. ");
INSERT INTO mxv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ra ña íin ka yu nuu ña yuuvi yoꞌo, ra ñuꞌu ña tuun nuu na yuuvi kuvi va yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ra te ndiꞌi ndikaꞌan ra tuꞌun yoꞌo xiꞌin ndia, ra saa koꞌni ra tiasiꞌi ra nuu ñuꞌu, ra xavaꞌa ra loꞌo ndiaꞌyu, ra ndikuꞌni ra ña nduchi nuu ra kuaa kan. ");
INSERT INTO mxv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―Kuaꞌan ndakatia kun nuu kun ini pozo ña nani Siloé ―kachi ra xiꞌin ra. ―Ra tuꞌun Siloé yoꞌo, ra tiakuii ra ndixaꞌan na kiꞌin na xaa xiꞌin chichi va kuvi ra ―kachi ña. Ra saa ndakiꞌin ra kuaa kan ndixaꞌan ra ndakatia ra nuu ra, ra te nandiko ra xaa ra, saa ra xa vaꞌa va ndakutoꞌni ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ra yuvi na ndee yachin xiꞌin tiaa kan, xiꞌin na ^xini ña kuu ra, ra kuaa, ra xaꞌa na ndakatuꞌun na kachi na saa: ―¿A su ra yoꞌo kuvi ra xinduꞌu ndindakan? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ra sava tu na kaꞌan kachi saa: ―Suvi kuvi va ra ―kachi na. Ra inka tu na kaꞌan kachi saa: ―Takaa ra kan ke kaa va ra, ndi su süvi vi ra ―kachi na. Ra saa ndakuiin mii tiaa kan kachi ra saa: ―Suvi kuvi va yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ra saa ndikaꞌan na xiꞌin ra kachi na saa: ―¿Ni ke xa kun ña vaꞌa ndanuña nuu kun? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ra saa ndakuiin ra yuꞌu na kachi ra saa: ―Tiaa ra nani Jesús va kuvi ra xavaꞌa ndiaꞌyu, ra ndikuꞌni ra ña nuu yu, ra te ndiꞌi ra saa ndikaꞌan ra xiꞌin yu kachi ra saa: “Kuaꞌan, ra ndakatia kun nuu kun ini pozo ña nani Siloé”, kachi ra xiꞌin yu. Ra saa ndixaꞌan yu ndakatia yu nuu yu, saa ra ndanuña va ña ra vaꞌa va ndakutoꞌni yu ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ra saa ndikaꞌan na xiꞌin ra kachi na saa: ―¿Ndia chi íin tiaa kan vichin? ―kachi na. Ra saa ndakuiin ra kachi ra saa xiꞌin na: ―Xïni yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ra saa ndiaka na ra ndixiyo kuaa kan ndixaꞌan na xiꞌin ra nuu na fariseo. ");
INSERT INTO mxv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ra ta xavaꞌa Jesús ndiaꞌyu ña sandaꞌa ra nuu ra kuaa kan, ra kii yii ña ndakindee va na ke. ");
INSERT INTO mxv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ra saa nindakatuꞌun tuku ndia fariseo tiaa kan, ni ke xa ra ña vaꞌa nduvaꞌa nuu ra kachi ndia xiꞌin ra. Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ndiaꞌyu va ke ndikuꞌni Jesús nuu yu, ra saa ndixaꞌan yu ndakatia yu ña, saa ra vaꞌa va ndakutoꞌni yu vichin ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ra saa ndikaꞌan sava ndia fariseo kan kachi ndia saa: ―Tiaa ra xa saa kan ra süvi kuenda Ndioxi kuvi ra, saa chi xä toꞌo ra kii yii ña ndakindiee yo ―kachi ndia. Ndi su inka tu na kaꞌan kachi suꞌva va: ―¿Ni ke sa ra, ña vaꞌa sa ra ña xituꞌun, tu iin tiaa ra iyoo kuachi va kuvi ra? ―kachi na. Saa ra iin sana suꞌva va ini ndia saa chi nii nindakitäꞌan tuꞌun ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ra saa nindakatuꞌun tuku va ndia ra ndixiyo kuaa kan kachi ndia saa: ―¿Ndia tiaa kuvi ra sandaꞌa nuu kun tuvi kun? ―kachi ndia xiꞌin ra. Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Iin ra kaꞌan ndoso tuꞌun yuꞌu Ndioxi va kuvi ra tuvi yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ndi su ndia judío, ra ndikandïxa vi ndia tiaa kan ña xikuu ra ra kuaa, ra ndanuña nuu ra, ra saa ndixaꞌan ndia kiꞌin ndia, na iva siꞌi ra nduvaꞌa nuu kan xaa na. ");
INSERT INTO mxv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ra nindakatuꞌun ndia na kachi ndia saa: ―¿A seꞌe ndoꞌo kuvi ra yoꞌo? ¿Ra a ra yoꞌo kuvi ra kuaa ta kaku ra kachi ndo? ¿Ra ndixaa ke iyoo ña, ña vaꞌa tu ixtoꞌni ra vichin? ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ra saa ndakuiin na iva siꞌi ra kachi na saa: ―Ña ndixa ke seꞌe ndi kuvi va ra, ra ña ndixa ke kuaa va tu ra ta kaku ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ndi su kundäa ini ndi nichuun vaꞌa ndakutoꞌni ra vichin, ra nii kundäa tu ini ndi yoo kuvi na sandaꞌa nuu va ra. Ra na ndakatuꞌun ndo mii va ra, ra na ndatuꞌun ra xiꞌin ndo, saa chi xa ra chee va kuvi ra, ra na ndakuiin ra xaꞌa mii va ra ―kachi na xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ra xaꞌa ña ndiyuꞌvi va na iva siꞌi ra nuu ndia judío kan ke kachi na saa, saa chi xa ndikataꞌan va ndia judío kan ña tava ndia ndia ndia ka yuvi ini veꞌe ñuꞌu, tu na kaꞌan na ña kuu Jesús ra tiꞌvi Ndioxi xaa sakaku na yuuvi. ");
INSERT INTO mxv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xaꞌa ña kan va ke ndikaꞌan iva siꞌi ra kachi na saa: “Ndakatuꞌun ndo mii ra, chi xa ra chee va kuvi ra”, kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Saa ndakana tuku va ndia judío ra ndixiyo kuaa kan, ra ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Chunaꞌa Ndioxi tu ndixa ña ndaa kuvi ña ndatuꞌun kun xiꞌin ndi; saa chi nduꞌu, ra kundaa va ini ndi ña kuu ra iin tiaa ra iyoo kuachi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ra saa ndakuiin ra kachi ra saa xiꞌin ndia: ―Kundäa ini yu a iyoo kuachi ra, a köo va tu ña, chi ña kundaa ini yu ke xikuu yu ra kuaa va, ndi su vichin ra xa vaꞌa ndakutoꞌni yu ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ra saa ndikaꞌan tuku ndia xiꞌin ra kachi ndia saa: ―¿Ni ke xa ra xiꞌin kun? ¿Ndia kuꞌva ke xa ra ña vaꞌa sandakutoꞌni ra yoꞌo? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Saa ndakuiin ra yuꞌu ndia kachi ra saa: ―Xa ndikaꞌan va yu xiꞌin ndo, ndi su xïin ndo kandixa ndo yuꞌu; ¿ra nichuun ke kuni ndo kaꞌan tuku yu ña xiꞌin ndo? ¿Ra a kuni tu ndoꞌo va kundikun ndo ra? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ra saa ndikaꞌan ndivaꞌa ndia xiꞌin ra, kachi ndia saa: ―Yoꞌo va kuvi ra ndikun sata tiaa ñaa, ndi su nduꞌu, ra ra Moisés va kuvi ra ndikun ndi. ");
INSERT INTO mxv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Saa chi kundaa va ini ndi ña ndikaꞌan Ndioxi xiꞌin ra kan, ndi su ra ñaa ra kundäa ini ndi xaꞌa ra, ndia mii ke kee ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Saa ndakuiin ra ndixiyo kuaa kan kachi ra saa xiꞌin ndia: ―¡Ña yoꞌo ke ndakanda ini yo xiꞌin va! Saa chi ndoꞌo, ra xïni ndo ndia mii ke kee ra, ra sandaꞌa va tu ra nuu yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ra xa kundaa va ini yo chi Ndioxi, ra tiäa soꞌo vi ra tuꞌun ña kaꞌan yuvi kuachi xiꞌin ra, ndi su xini va tu soꞌo ra ña kaꞌan na ndasakaꞌnu kivi ra xiꞌin na xa ña kuni ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ra ndia nii ichi täan kundaa ini yo, xaꞌa iin tiaa ña sandaꞌa ra nuu iin yuvi na kaku kuaa, ra vaꞌa ndakutoꞌni na. ");
INSERT INTO mxv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ra tu süvi Ndioxi nditiꞌvi tiaa yoꞌo kixi ra, saa ra ndia nii ña ke kuchüun ra sa vi ra ―kachi ra nduvaꞌa nuu kan xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ra saa ndikaꞌan ndia kachi ndia saa xiꞌin ra: ―¿A yoꞌo, ra kaku xiꞌin kuachi vi kuvi ra xaa sañaꞌa nduꞌu? ―kachi ndia xiꞌin ra. Ra saa tava ndia ra ini veꞌe ñuꞌu kan, kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ra ta kundaa ini Jesús ña tava va ndia tiaa kan veꞌe ñuꞌu, ra saa ndixaꞌan Jesús nanduku ra ra, ra te ndaniꞌi ra ra, ra ndikaꞌan ra xiꞌin ra kachi ra saa: ―¿A kandixa kun ra kuu Seꞌe Ndioxi? ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ra saa ndakuiin tiaa kan kachi ra saa: ―Tata, ndatuꞌun xiꞌin yu ra kundaa ini yu yoo kuvi ra, ra vaꞌa kandixa yu ra ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Xa xini va kun ra, chi yuꞌu ra kaꞌan xiꞌin kun yoꞌo va kuvi ra ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Saa ndakuiin tiaa kan kachi ra saa xiꞌin Jesús: ―Kandixa va yu yoꞌo, Tata, ―kachi ra. Ra saa ndakusiti ra ra ndasakaꞌnu ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ra saa ndikaꞌan Jesús kachi ra saa: ―Ña xaa yu ña yuuvi yoꞌo, ra kuachi yuvi va ke xaa yu sandaku yu; saa chi na kuaa, ra vaꞌa va ndakutoꞌni na sa yu, ra na vaꞌa ixtoꞌni kuu kuaa va tu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ra te xini soꞌo sava ndia fariseo ndia ndita yachin xiꞌin ra, tuꞌun ña ndikaꞌan ra, ra saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―¿A ndia kuaa ku tu nduꞌu va tuvi kun, ña kan ke kachi kun saa? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Tu ndia kuaa ndixiyo ndo, saa ra köo vi kuachi ndo, ndi su vichin ra vaꞌa va nuu ndo, kachi ndo, ra ña kan ke iyoo va kuachi ndo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ra saa ndikaꞌan Jesús kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi tiaa ra ndaa chi nuu korra nuu ndoꞌni ndikachi vali, ra kïꞌvi ra chi yeꞌe korra nu ñuꞌu ri, ra ra kan, ra ra kuiꞌna va kuvi ra, saa chi xakuiꞌna ra ri xiꞌin ña uꞌvi. ");
INSERT INTO mxv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ra tiaa ra kiꞌvi chi yeꞌe korra, ra ra kan ra ndixa va paxto ra ndiaa ri kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ra te ^ndakuña ra ndiaa yeꞌe korra kan, ña ^kiꞌvi ra ndixa kuu paxto ra ndiaa ri, saa ra ndikun ndakuni va ndikachi vali sana ra tachi ra, ra saa xaꞌa ra kaꞌan ra kivi ta iin ta iin ri, ra saa kee ri korra kan kuaꞌan va ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ra te ndiꞌi tava ra takundiꞌi ndikachi vali sana ra chi keꞌe, saa ra ndakunuu ra nuu ri kuaꞌan va ra, ra vaꞌa ka vi ndakundikun ri sata ra kuaꞌan ri, saa chi xini va ri tachi ra kuu ixtoꞌo ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ndi su iin tiaa ra xïni ri, ra ndïkun tu mii vi ri sata ra kan, chi ri xinu ka va kuvi ri nuu ra, saa chi xïni ri tachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ra xiꞌin tuꞌun ndichi yoꞌo ke ndikaꞌan Jesús xiꞌin na, ndi su ndikundäa ini na, ni ke kuni kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ra saa ndikaꞌan tuku Jesús xiꞌin na kachi ra saa: ―Ra na kundaa ini ndo ña ndaa: Saa chi yuꞌu va kuvi ra kuu yeꞌe nuu kiꞌvi ndikachi vali. ");
INSERT INTO mxv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ra takundiꞌi na xinuu kixi ta yachi nuu yuꞌu, ra na kuiꞌna va xikuu na kan, ña kan ke nditiäa soꞌo vi ndikachi vali tachi na. ");
INSERT INTO mxv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ra yuꞌu va kuvi ra kuu yeꞌe, ra yuvi na ^kiꞌvi yeꞌe yoꞌo, ra kaku va na. Ra koo na ta kuꞌva iyoo ndikachi vali ri ñuꞌu ini korra, ra ^kee ri, ra ndéé va tu ri, ra iin ndisaa kii va iyoo itia kuii xixi ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ra ra kuiꞌna, ra ra vaxi sakuiꞌna va kuvi ra kan, yuvi na iyoo ta kuꞌva iyoo ndikachi vali, ra kaꞌni ra na, ra sandiꞌi tu xaꞌa va na; ndi su yuꞌu, ra ra xaa taxi ña kutiaku va na kuvi yu, ra viꞌi ni kii kuiya taxi yu kutiaku na. ");
INSERT INTO mxv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Saa chi yuꞌu kuvi ra kuu paxto ra vaꞌa ni ndiaa ndikachi vali. Ra ra kuu paxto ra vaꞌa ra ndataxi va ra mii ra, ña kuvi ra xaꞌa ndikachi vali sana ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ndi su iin tiaa ra kiꞌin xuꞌun, ña ndiaa tatu ra ndikachi vali, ra te xini ra vaxi ndivaꞌyu, saa ra ndakoo ndaꞌa va ra ri, ra xinu ra kuaꞌan va ra, saa chi süvi sana ra kuvi ri, ña kan ke ndakoo va ra ri, ra xaa ndivaꞌyu kan ra kanitaꞌan ri xiꞌin va ri, saa ra taxi ndiꞌi ri ri kuaꞌan va ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ra xinu va tiaa kan, saa chi takua xaꞌa xuꞌun va ke xachiñu ra, ña kan ke ndïꞌi tu ini mii ra xaꞌa vi ndikachi vali kan. ");
INSERT INTO mxv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ra na kundaa ini ndo chi yuꞌu kuvi ra kuu paxto ra vaꞌa ni ndiaa ndikachi vali. Ra xini va yu ndikachi vali sana yu, ra xini tu ri kan va yuꞌu, ");
INSERT INTO mxv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ta kuꞌva iyoo Tata yu Ndioxi ña xini ra yuꞌu, ra xini tu yuꞌu ra kan va, ra saa ke iyoo tu yuꞌu va xiꞌin ndikachi vali sana yu, saa chi ^ndataxi yu mii yu ña kuvi yu xaꞌa ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ra iyoo ka va ndikachi vali sana yu, ri köo ñuꞌu korra yoꞌo, ra xiniñuꞌu kuꞌun yu ndakiꞌin tu yu ri kan va, ra kandixa va ri yuꞌu, ra ndakutaꞌan ri xiꞌin ri xa ñuꞌu korra, ra iin nduu va ri, ra iin kuu tu paxto, ra kondiaa va ri. ");
INSERT INTO mxv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ra kuꞌvi ni va ini Tata yu xini ra yuꞌu, saa chi ^taxi yu mii yu ña kuvi yu, ra te xa na ndiꞌi, saa ra ndatiaku tuku va yu. ");
INSERT INTO mxv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ra ndia nii na kuchüun kaꞌni yuꞌu, ra ña kuni mii va yu ke ^ndataxi yu mii yu ña kuvi yu. Saa chi iyoo ndiayu ndaꞌa yu ña kuvi yu, ra iyoo tu ndiayu ndaꞌa yu ña ndatiaku tuku va yu. Saa chi ña yoꞌo kuvi chiñu ña xaꞌndia Tata yu nuu va yu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ra te xini soꞌo na judío ña kachi Jesús saa, saa ra nindakitäꞌan tuku va tuꞌun na, saa chi xa siin xa siin kaꞌan va na. ");
INSERT INTO mxv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ra sava tu na ndikaꞌan kachi na saa: ―Tiäa soꞌo ndo ña kaꞌan ra, saa chi ra yaꞌa xini va kuvi ra, ra tachi ndivaꞌa va ke kuu mii ra ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ra inka tu na ndikaꞌan, kachi saa: ―Ndia nii na kuu mii tachi ndivaꞌa, ra käꞌan na, taꞌan tuꞌun ña kaꞌan ra yoꞌo. ¿Ra a kuchuun iin na kuu mii tachi ndivaꞌa ña sandaꞌa na nuu iin ra kuaa? ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ra saa kuu, ra nditiandiaa va yoo ña vixin ni, ra suvi tu mii tiempo kan ke ndatava na judío viko veꞌe ñuꞌu kaꞌnu ñuu Jerusalén va. ");
INSERT INTO mxv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Saa ndixaa Jesús xika ra nuu keꞌe veꞌe ñuꞌu kaꞌnu kan, yachin nuu nani yeꞌe kaꞌnu ña xavaꞌa ra Salomón, ");
INSERT INTO mxv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ra saa iin xinunduu ndia judío kan ra, ra ndindakatuꞌun ndia ra kachi ndia saa: ―¿Ama vi ke kaꞌan kun ña ndaa xiꞌin ndi ra kundaa ini ndi? Chi tu ndixa yoꞌo kuvi ra tiꞌvi Ndioxi xaa sakaku na yuuvi yoꞌo, saa ra kaxi kaxi va na kaꞌan kun xiꞌin ndi ra kundaa ini ndi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Xa ndikaꞌan va yu xiꞌin ndo, ra xïin ndo kandixa ndo yuꞌu. Ra takundiꞌi chiñu ña ^xa yu xiꞌin ndiayu Tata yu, ra ña kan kuvi ña ndakuiin xaꞌa yu ña ndixa ke kuu yu seꞌe va ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ndi su ndoꞌo ra xïin ndo kandixa ndo yuꞌu, saa chi süvi ndikachi vali sana yu kuvi ndo, xa ta kachi yu xiꞌin va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ra ndikachi vali sana yu, ra xini va soꞌo ri ña kaꞌan yu xiꞌin ri, ra xini tu mii va yu ri, ra ndikun tu ri yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ra ^taxi yu ña kutiaku ri ndia ndikaa ndikuꞌun, ra ndia nii kii ndïꞌi xaꞌa ri, ra ndia nii tu na kuchüun kindiaa ri ndaꞌa va yu. ");
INSERT INTO mxv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Saa chi Tata yu, ra taxi ri ndaꞌa yu, kuvi ra kaꞌnu nuu takundiꞌi va na, ña kan ke ndia nii na kuchüun kindiaa ri ndaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ra Yuꞌu, xiꞌin Tata yu, ra indaa mituꞌun va kuvi ndi ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ra saa kiꞌin tuku va ndia judío kan yuu, ña kuni ndia kakin ndia Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña vaꞌa va kuvi ña kuaꞌa ni xa yu xini ndo, xiꞌin ndiee Tata yu; ¿ra ndia iin ña kuvi ña kakin ndo yuu yuꞌu xaꞌa? ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Saa ndakuiin ndia judío kan kachi ndia saa xiꞌin ra: ―Süvi xaꞌa chiñu vaꞌa ña xa kun ke kakin ndi yuu yoꞌo, chi xaꞌa ña ndaa yuꞌu kun Ndioxi va ke kakin ndi ña yoꞌo. Saa chi tiaa yuuvi yoꞌo va kuvi kun, ra kaꞌan kun ña kuu kun Ndioxi ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿A su nuu ndiayu Ndioxi ña niꞌi va ndo ke ndikaꞌyu tuꞌun ña kachi suꞌva: “Mii yu kuvi va ra kaꞌan ña kuu ndo ndioxi”, kachi Ndioxi, ndikaꞌan ra kachi ña? ");
INSERT INTO mxv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ra xa kundaa va ini yo, chi tuꞌun ña ndikaꞌyu nuu ndiayu Ndioxi, ra küvi kanduu yo ña; saa chi mii Ndioxi va kuvi ra ndikaꞌan kachi ra saa xiꞌin na ndakiꞌin ndiayu ra ta yachi, ña kuu na ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ra Ndioxi va kuvi ra ndikaxin yuꞌu, ra tiꞌvi ra yuꞌu xaa yu ña yuuvi yoꞌo vichin, ra kaꞌan yu ña kuu yu seꞌe ra, ra ña kan ke kaꞌan ndo, ña ndaa yuꞌu yu ra. ");
INSERT INTO mxv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ra tu xä yu chiñu ña ^xa Tata yu, saa ra na kandïxa ndo yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ra tu ^xa va tu yu ña, saa ra vaꞌa ni na kandïxa va ndo yuꞌu, ndi su na kandixa va ndo chiñu ña xini ndo ^xa yu, ra saa ke vaꞌa na kundaa ini ndo ra kandixa ndo ña iyoo Tata yu Ndioxi xiꞌin yu, ra yuꞌu, tu iyoo xiꞌin ra kan va ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ra saa kuni tuku va ndia tiin ndia Jesús, ndi su ndikuchüun ndia, chi ndisaña va ra ndaꞌa ndia. ");
INSERT INTO mxv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ra saa ndakiꞌin ra kuaꞌan chi nuu kanata ñuꞌù, ra kee ra itia Jordán ra ndixaa ra ndixikoo ra chi nuu ndixiyo ra Juan ra sakuchi yuvi te yachi. ");
INSERT INTO mxv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ra kuaꞌa ka vi yuvi ndixaꞌan nuu iin Jesús, ra ndikaꞌan na xiꞌin taꞌan na kachi na saa: ―Vaꞌa ni ña ndixa ke köo va ña xituꞌun ndixa ra Juan, ndi su takundiꞌi ña ndikaꞌan ra xaꞌa tiaa yoꞌo, ra ña ndixa va kuvi ña ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ra kuaꞌa ni yuvi na ndee yachin kan, ndakundikun sata Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ra ñuu Betania ndixiyo iin tiaa ra xinani Lázaro ra kiꞌin kueꞌe ra, ra kuꞌva ña María, xiꞌin ña Marta kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ra ña María, kuvi ña kosondiee ndutia xaꞌan tami xaꞌa Jesús, ra ndakuꞌva ña ña xiꞌin ixi xini ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ra saa tiꞌvi na siꞌi kuꞌva ra Lázaro kan, chiñu kuaꞌan ña nuu Jesús, ra kachi na saa: ―Tata, ndiee na kuii ndoꞌo ra itaꞌan xiꞌin kun, ra nani Lázaro ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ra saa te xini soꞌo Jesús tuꞌun yoꞌo, ra saa ndikaꞌan ra kachi ra saa: ―Ña ndiee ndoꞌo ra Lázaro, ra süvi ra kuvi vi kuvi ra, chi ña vaꞌa na kundaa ini yuvi ña kaꞌnu ni Ndioxi va kuvi ña, ra ndasakaꞌnu tu na yuꞌu, ra kuu seꞌe va ra ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ra vaꞌa ni kuꞌvi ni va ini Jesús xini ra ña Marta, xiꞌin ña María, xiꞌin ra Lázaro, ");
INSERT INTO mxv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ra te kundaa ini ra ña ndiee ndoꞌo ra Lázaro, ra kuëe ndikun ndixaꞌan ra nuu iyoo ra Lázaro, chi kuachi ka va ra uvi kii ñuu nuu íin ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Te ndiꞌi saa vi ndikaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Naꞌa ndo na kuꞌun tuku yo chi Judea ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ra saa ndikaꞌan ndia xiꞌin ra kachi ndia saa: ―Tata Maestro, sakan ndiaꞌvi kii va ke kuni na judío na ndee kan kaꞌni na yoꞌo xiꞌin yuu, ¿ra a tuku va ichi kuni kuꞌun kun? ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ndia: ―¿A kundäa ini ndo iin kii, ra uxi uvi hora kuvi ña? Ra ña kan ke na xika kaꞌñu ra kakïꞌi vi na, saa chi tuun va ñùꞌù ña iyoo nuu ña yuuvi yoꞌo nuu na. ");
INSERT INTO mxv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ndi su yuvi na xika ñuu, ra kakiꞌi va na kan, saa chi köo ñùꞌù tuun nuu na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te ndiꞌi saa ndikaꞌan ka Jesús kachi ra saa xiꞌin ndia: ―Xa ndikixi va ra itaꞌan xiꞌin yo, ra nani Lázaro; ra ña kan ke kuꞌun yu sandoto yu ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ra saa ndikaꞌan ndia itaꞌan xiꞌin ra, kachi ndia saa xiꞌin ra: ―Tata, tu ra ndikixi va kuvi ra, saa ra ndoto va ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ra ña kachi Jesús ña ndikixi ra Lázaro, ra ra ndixiꞌi va kuvi ra, kachi ra xiꞌin ndia itaꞌan xiꞌin ra, ndi su ndia kan ra ndikundäa ini vi ndia, chi vaꞌa ra kixi ku ndixa va ra káꞌán ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ra saa vi ke ndikaꞌan tieꞌe vaꞌa Jesús, xiꞌin ndia kachi ra saa: ―Xa ndixiꞌi va ra Lázaro. ");
INSERT INTO mxv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ra kusii ni ini yu ña ndixïyo yu xiꞌin ra, ra saa ke vaꞌa na kuni ndoꞌo, ra kandixa vaꞌa ka ndo yuꞌu, ra naꞌa ndo, ra na kuꞌun yo kuni yo ra ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ra saa ndikaꞌan iin ra nani Tomás, ra kaꞌan na kuu kuati kachi ra saa, xiꞌin ndia sava ndia itaꞌan xiꞌin Jesús: ―Naꞌa ndo, ra na kuꞌun yo kuvi yo xiꞌin va ra ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ra saa te ndixaa Jesús ñuu kan, ra saa kundaa ini ra ra xa kumi va kii ke ndikaa ra Lázaro tixi ñuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ra ñuu Betania kan, ra yachin va ndikaa ña xiꞌin ñuu Jerusalén, saa chi kuꞌva uvi kilómetro sava va ke kindoo ñuu Betania xiꞌin ñuu Jerusalén. ");
INSERT INTO mxv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ra ña kan ke vaꞌa kuaꞌa ni na judío ndixaꞌan ixtoꞌni ña Marta xiꞌin ña María, ña ^taxi na tuꞌun ndiee ini ndaꞌa na, xaꞌa ña ndixiꞌi ra Lázaro kuꞌva na. ");
INSERT INTO mxv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ra saa te kundaa ini ña Marta ña kuyachin Jesús xaa ra, ra saa kanata ña ndakiꞌin ña ra; ra ña María, nindoo chi ini veꞌe va. ");
INSERT INTO mxv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ra saa ndikaꞌan ña Marta xiꞌin Jesús, kachi ña saa: ―Tata, tu ndixiin kun yoꞌo, saa ra küvi vi kuꞌva yu. ");
INSERT INTO mxv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ndi su kandixa va yu chi tu na nduku kun iin ñaꞌa nuu Ndioxi ra taxi va ra ña ndaꞌa kun ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Ra kuꞌva kun, ra ndatiaku tuku va ra ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ra saa ndakuiin ña Marta kachi ña saa: ―Xa kundaa va ini yu, chi ndatiaku va ra te na xaa kii ña ndatiaku na ndii kii ña vaxi ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Yuꞌu kuvi ra sandatiaku yuvi, ra taxi tu yu ña kutiaku va na. Ra na kandixa yuꞌu, ra vaꞌa ni xa ndixiꞌi va na, ndi su kutiaku va na. ");
INSERT INTO mxv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ra takundiꞌi yuvi na tiaku, ra kandixa na yuꞌu, ra ndia nii kii küvi na. ¿A kandixa kun ña yoꞌo? ―kachi Jesús xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ra saa ndakuiin ña kachi ña saa: ―Kandixa va yu, Tata, ra kandixa tu yu, ña kuu kun Seꞌe Ndioxi va, ra ndikaxin tu ra yoꞌo ña sakaku kun na yuuvi yoꞌo va, ra xa iyoo tu tuꞌun xaꞌa kun ña kixi kun nuu ña yuuvi yoꞌo va ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ra saa ta ndiꞌi ndikaꞌan ña Marta tuꞌun yoꞌo, ra saa ndixaꞌan ña ndikaꞌan seꞌe ña xiꞌin ña María kuꞌvi ña, kachi ña saa: ―Tata yo Maestro, ra yoꞌo va íin ra, ra kana ra yoꞌo ―kachi ña xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ra saa te kundaa ini ña María tuꞌun yoꞌo, saa ra ndikun ndakundichi ña, ra ndixaa ña nuu íin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ra Jesús ra täan kiꞌvi vi ra ñuu, saa chi sakan nuu ndixaa ña Marta niniꞌi taꞌan ña xiꞌin va ra ke íin ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ra saa te xini na judío na ndixaa ndee kiꞌin kuenda xiꞌin ña Maria, ña kama ni ndakundichi ña kuaꞌan ña, ra saa taxi ndikun na kuaꞌan na sata va ña, saa chi vaꞌa yuꞌu yavi nuu ndikaa kuꞌva va ña kuaꞌan ña kunduꞌu ña kuaku ña, káꞌán na. ");
INSERT INTO mxv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ra saa te ndixaa ña María nuu íin Jesús, ra saa ndakutoꞌni ña nuu ra, ra ndakusiti ña xaꞌa ra, ra ndikaꞌan ña xiꞌin ra kachi ña saa: ―Tata, tu yoꞌo ndixiin kun, saa ra küvi vi kuꞌva yu ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ra saa te xini Jesús ña ^xaku ña Maria, ra xaku tu na judío na ndixaa xiꞌin va ña, saa ra kusuchi ni tu ini Jesús va xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ra saa ndikaꞌan ra xiꞌin na kachi ra saa: ―¿Ndia mii ninduxin ndo ra? ―kachi ra xiꞌin na. Ra saa ndakuiin na kachi na saa: ―Tata, naꞌa, ra koꞌo xiꞌin ndi ra kuni kun nuu ninduxin ndi ra ―kachi na xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Saa ra xaku va Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ra saa ndikaꞌan na judío kan, kachi na saa: ―Kutoꞌni ndo, chi tiaa ni kuꞌvi ini ra xini ra ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ra sava tu na kaꞌan kachi saa: ―Ra yoꞌo, ra vaꞌa va sandaꞌa ra nuu na kuaa, ¿ra a väꞌa saa ndixa ra, ña täxi kuvi ra Lázaro? ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Saa kundaꞌvi tuku va ini Jesús xini ra na, saa ndixaa ra yuꞌu yavi nuu ndikaa ra Lázaro, ra ndika kava va ku nuu íin yavi kan, ra ndasi iin yuu chee yuꞌu ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Saa ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Sakutiaꞌa ndo yuu yuꞌu yavi ―kachi ra xiꞌin na. Ra saa ndikaꞌan ña Marta kuꞌva ra Lázaro kachi ña saa: ―Küvi sakutiaꞌa ndi ña, Tata, saa chi xa kumi vi kii ke ndixiꞌi ra, ra xa xaꞌan ni va ra ―kachi ña xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―¿A ndakäꞌan kun ña ndikaꞌan yu xiꞌin kun, tu kandixa kun yuꞌu, saa ra kuni va kun ña xituꞌun ^xa Ndioxi? ―kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ra saa sakutiaꞌa na yuu ña ndasi yuꞌu yavi nuu ndikaa iki kuñu ra Lázaro, ra saa ndoniꞌi Jesús nuu ra chi ndivi, ra ndikaꞌan ra kachi ra saa: ―Tata, ndataxi yu tixaꞌvi ndaꞌa kun, saa chi xa xini va soꞌo kun ña ndikaꞌan yu xiꞌin kun. ");
INSERT INTO mxv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ra xa kundaa va ini yu, saa chi takundiꞌi tuꞌun ña kaꞌan yu xiꞌin kun ra ^xini va soꞌo kun ña Tata, ndi su xaꞌa yuvi yoꞌo va ke ndikaꞌan yu xiꞌin kun, ña vaꞌa na kundaa ini na, ra kandixa na ña yoꞌo kuvi ra tiꞌvi yuꞌu vaxi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ra te ndiꞌi ndikaꞌan ra tuꞌun yoꞌo, ra saa ndiee ka vi ndikaꞌan ra kachi ra saa: ―¡Lázaro, kita keꞌe! ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ra saa kita ra Lázaro kan, ra nuꞌni ndaꞌa ra, xiꞌin xaꞌa ra, xiꞌin tikoto ña nii, ra isuvi tu ña nuu va ra. Ra saa ndikaꞌan Jesús xiꞌin na, kachi ra saa: ―Ndaxi ndo ra, ra saña ndo ra na kuꞌun ra ―kachi ra xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ra ña kuu ña yoꞌo, ra kuaꞌa ni na judío na ndixaꞌan kiꞌin kuenda xiꞌin ña María ra kandixa va na, ña xini na xa Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ndi su sava tu na kee, ra ndixaꞌan na ndatuꞌun na xiꞌin ndia fariseo, xaꞌa ña xini na xa Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ra saa ndakutaꞌan ndia fariseo xiꞌin ndia xikuaꞌa nuu na sutu, xiꞌin ndia xikuaꞌa xaꞌndia chiñu, ra ndikaꞌan ndia xiꞌin taꞌan ndia kachi ndia saa: ―¿Ni ke sa yo? Chi tiaa yoꞌo, ra kuaꞌa ni ña xituꞌun ^xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ra tu na taxi yo ña sa ka ra saa, saa ra kandixa ndiꞌi va na ra, ra iyo ni kixi na chiñu ñuu Roma, ra sandiꞌi na xaꞌa veꞌe ñuꞌu kaꞌnu yo, ra sandiꞌi tu na xaꞌa ñuu va yo ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ra saa ndikaꞌan iin ra sutu ra nani Caifás, ra kuchee nuu takundiꞌi ndia sutu mii kuiya kan, kachi ra saa xiꞌin ndia: ―Ndoꞌo, ra xïni vaꞌa vi ndo. ");
INSERT INTO mxv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿A kïꞌin xini ndo, ña vaꞌa ka va ke na kuvi iin tiaa xaꞌa takundiꞌi yuvi, nuu ña kuvi takundiꞌi na ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ra ña ndikaꞌan ra Caifás tuꞌun yoꞌo, ra süvi xini mii ra ke ndikaku ña, chi xaꞌa ña kuu ra sutu, ra kuchee nuu takundiꞌi sutu kuiya kan va ke taxi Ndioxi tuꞌun yoꞌo ndaꞌa ra, ña vaꞌa ndikaꞌan ra, ña kuvi Jesús xaꞌa takundiꞌi na ñuu kan; ");
INSERT INTO mxv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ra süvi takua xaꞌa na ñuu Israel ke kuvi ra, chi kuvi tu ra xaꞌa na kuu seꞌe Ndioxi na ndee takundiꞌi ñuu va, ña ndachutaꞌan ra na, ra nduu na iin. ");
INSERT INTO mxv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ra mii kii kan ke, kindoo na ña kaꞌni na Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ra xaꞌa ña kan ke ndiküvi ka kaka tuvi Jesús tiañu na judío, ra saa kita ra Judea kan, ra ndixaꞌan ra iin ñuu ña nani Efraín ña ndikaa yachin xiꞌin iin iku yuu. Ra ikan ndixiyo ra xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ra suvi mii yoo kan ke, xa kuyachin ni tu ndatava na judío viko pascua va, ra ña kan ke kuaꞌa ni na kuaꞌan ñuu Jerusalén, ña xa sanduvi na xiꞌin mii na ña vaꞌa ndasakaꞌnu na viko kan. ");
INSERT INTO mxv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ra ndanduku tu na Jesús va, ra ta ndixaa na veꞌe ñuꞌu kaꞌnu kan, ra saa ^ndakatuꞌun taꞌan na kachi na saa: ―¿Ndixa tuvi ndo, a kixi ra viko yoꞌo a kïxi ra? ―kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ra ndia sutu ndia kunaꞌnu nuu ndia sutu xiꞌin ndia fariseo, ra xa xaꞌndia va ndia chiñu nuu yuvi, ña tu ndia iin na na kundaa ini nuu iyoo Jesús, ra ndikun na ndatuꞌun na xiꞌin ndia, ra vaꞌa tiin ndia ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ra i̱ñu̱ ka kii ke kumani koo viko pascua, ra saa kee Jesús kuaꞌan ra chi ñuu Betania ñuu ra Lázaro ra ndixiꞌi, ra ndasatiaku Jesús ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ra ikan xavii na ña xixini ra xaꞌa ña xatoꞌo na ra, ra ña Marta kuvi ña chikaa koꞌo kata ña nuu ndia, ra ra Lázaro kuvi ra xinduꞌu nuu mesa xixi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ra saa xaa tu ña María va, ra niꞌi ña iin yuyu loꞌo ña ñuꞌu ndutia xaꞌan tami, ra kuvaꞌa xiꞌin niña iku nardo, ra tiaa ni yaꞌvi ra, ra koso ndiee ña ra xaꞌa Jesús, ra te ndiꞌi saa ndakuꞌva ña xaꞌa ra xiꞌin ixi xini ña, ra iin chitu ndaa ini veꞌe kan, xiꞌin xiko ndutia xaꞌan tami kan. ");
INSERT INTO mxv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ra saa ndikaꞌan iin ra itaꞌan xiꞌin Jesús, ra nani Judas Iscariote ra seꞌe Simón, ra ndataxi Jesús ndaꞌa na sáa̱ ini te na ndiꞌi, kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿A väꞌa ndikiyaꞌvi ndutia xaꞌan tami yoꞌo, uni ciento denario, ra chindiee taꞌan yo xiꞌin na ndaꞌvi? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ndi su süvi ndixa xaꞌa na ndaꞌvi ke ndiꞌi ini ra ña ndikaꞌan ra tuꞌun yoꞌo; saa chi xaꞌa ña kuni ra xuꞌun va ke kachi ra saa; chi ra kan kuvi ra xindiso xuꞌun, ra ikan tava seꞌe ra loꞌo ña, ña kan ke kachi ra saa. ");
INSERT INTO mxv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Koo yaa kun xiꞌin ña, chi ña vaꞌa va ke ^xa ña xiꞌin yu, saa chi chuvaꞌa va ña ndutia yoꞌo, ra chikaa ña ra sata yu vichin, ña vaꞌa xa na koo nduvi yu kii te na nduxin na yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ra na ndaꞌvi, ra iin takundiꞌi va kii ke kundee na kan xiꞌin ndo; ndi su yuꞌu, ra süvi iin takundiꞌi kii ke kuiin yu xiꞌin ndo ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ra saa kuu, ra kuaꞌa ni na judío kundaa ini ña íin Jesús ñuu Betania, ra saa ndakiꞌin na ndixaꞌan na xini na ra, ra süvi takua ra kan kuvi ra ndixaꞌan na kuni na, chi ndixaꞌan tu na xini na ra Lázaro ra ndixiꞌi, ra ndasatiaku Jesús ta yachi va. ");
INSERT INTO mxv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ra saa ndakutaꞌan ndia xikuaꞌa nuu ndia sutu, ra ndikataꞌan ndia ña kaꞌni tu ndia ra Lázaro va, ");
INSERT INTO mxv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","saa chi xaꞌa ra yoꞌo ke, kuaꞌa ni na judío ra ndakoo va na ndia sutu kunaꞌnu kan, ra ndakundikun na sata Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ra saa kuu inka kii, ra saa ndakiꞌin Jesús kuaꞌan ra chi ñuu Jerusalén, ra kii kan ra ndee kuaꞌa tu yuvi na xaa ña iyoo viko pascua va, ra ta kundaa ini na ña xaa Jesús ñuu kan, ");
INSERT INTO mxv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ra saa kee na, ra xaꞌndia na ñuu ndaꞌa itun ñuu, ra ndixaꞌan na ndakiꞌin na Jesús, ra iin siso, siso ndaꞌyu na kachi na saa: ―¡Ra kaꞌnu kuvi Ndioxi! ¡Ra ra kaꞌnu kuu tu ra tiꞌvi va ra! ¡Kaꞌnu ni ra tiꞌvi ra, saa chin Rey na ñuu Israel kuvi ra! ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ra saa taxi na iin burru loꞌo ndaꞌa Jesús ra nandaa ra sata ri. Ra suꞌva va ke kuu ña vaꞌa ndixinu nuu tuꞌun Ndioxi, ña ndikaꞌyu xinaꞌa, ña kachi suꞌva: ");
INSERT INTO mxv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kuayüꞌvi ndoꞌo, na ñuu Jerusalén; na kundaa ini ndo, chi xa vaxi va ra kuu rey ndo, ra yoso ra iin burru loꞌo vaxi ra, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ra ndia itaꞌan xiꞌin Jesús, ra ndikundäa vi ini ndia xiꞌin tuꞌun kan, ra ndia te ndatiaku Jesús kuanuꞌu ra chi ndivi vi ke, ndakaꞌan ndia ña ndikaꞌyu tuꞌun kan xaꞌa Jesús, ra iin ta kachi tuꞌun kan ña ndakani ña, ra iin saa ke kuu va. ");
INSERT INTO mxv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ra yuvi na ndixaꞌan xini te kana Jesús ra Lázaro ini yavi ña sandatiaku ra ra, ra ndatuꞌun na xiꞌin yuvi xaꞌa ña xini na xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ra xaꞌa ña kan ke kee yuvi kan ndakiꞌin na Jesús, chi kundaa va ini na xaꞌa ña xituꞌun xa ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ra saa ndikaꞌan ndia fariseo kan xiꞌin taꞌan ndia kachi ndia saa: ―*Xi̱nì ndo chin ña uun va ke kuu yo saa xika yo, saa chi sata ra kaa, ndakundikun takundiꞌi va na ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ra ñúꞌu tu sava na griego va tiañu yuvi na ndixaa ndasakaꞌnu viko pascua ñuu Jerusalén kan. ");
INSERT INTO mxv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ra saa kuyachin na griego kan nuu iin ra Felipe ra kee ñuu Betsaida, ña ndikun ndiaa chi Galilea, ra xakundaꞌvi na nuu ra kachi na saa: ―Tata, kuni ndi kuni ndi Jesús ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ra saa kee ra Felipe ra ndixaꞌan ra ndikaꞌan ra xiꞌin ra Andrés, ra saa ndakutaꞌan uvi saa ndia ra ndixaꞌan ndia ndatuꞌun ndia xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ndia: ―Xa kuyachin ni kii ña taxi Ndioxi ña kundaa ini yuvi, ña kaꞌnu ni yuꞌu, ra xaa yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ra xa kundaa va ini ndo, chi tu na ndakäva nuni trigo nuu ñuꞌu, saa ra köo mii kuiꞌi taxi vi ña, ra tu na ndakava ña nuu ñuꞌu, ra kuvi ña, saa ra, kuaꞌa ni va kuiꞌi taxi ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ra yuvi na kuꞌvi ni ini xini mii, ra na ndiꞌi xaꞌa va kuvi na; ndi su yuvi na kuë kuꞌvi ini xini mii, ra na kan kuvi na niꞌi kutiaku ndia ndikaa ndikuꞌun va. ");
INSERT INTO mxv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ra tu ndia na xiin sachiñu ndaꞌvi nuu yu, ra xiniñuꞌu na kundikun na yuꞌu va, ra nuu koo yu ke koo tu na xachiñu ndaꞌvi nuu va yu, ra ndia ndia ka na ^xachiñu ndaꞌvi nuu yu, ra satoꞌo va Tata yu na. ");
INSERT INTO mxv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ra vichin ra tiaa ni ndiꞌi ini yu. ¿Ra ni ke vaꞌa kachi yu? ¿A vaꞌa tu na kaꞌan yu xiꞌin Tata yu ña sayaꞌa ra yuꞌu nuu tundoꞌo ña vaxi nuu yu? Küvi, saa chi xaꞌa ña yoꞌo ke xaa va yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ra saa ndikaꞌan ka Jesús xiꞌin Ndioxi kachi ra saa: ―Tata, na taxi kun kundaa ini yuvi, ña kaꞌnu ni kun ―kachi ra. Ra saa tiaku ndikaꞌan iin tachi chi ndivi kachi ña saa xiꞌin ra: ―Xa taxi va yu ña kundaa ini na, ña kaꞌnu ni yu, ra taxi tuku va yu ña na kundaa ini na, ña kaꞌnu ni yu ―kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ra ta xini soꞌo yuvi na ndee xiꞌin Jesús tuꞌun ña ndikaꞌan tachi kan, ra saa ndikaꞌan na kachi na saa: ―Savi va kuvi ra nindaꞌyu ―kachi na. Ra sava tu na ndikaꞌan kachi saa: ―Tatun Ndioxi va kuvi ra ndikaꞌan xiꞌin Jesús ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin na: ―Tachi yoꞌo, ra süvi xaꞌa yuꞌu ke ndikaꞌan ña, chi xaꞌa ndoꞌo va ke ndikaꞌan ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ra vichin ke ndixaa kii ña kundaku kuachi xiꞌin na yuuvi yoꞌo; ra vichin ke ndixaa tu kii ña kita tachi ndivaꞌa ña xaꞌndia chiñu nuu ña yuuvi yoꞌo va, kuꞌun ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ra te xa na ndoniꞌi sukun na yuꞌu, ra ña sa yu ke sakanda yu nima yuvi ra nanduku takundiꞌi va na yuꞌu ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ra ña kachi Jesús suꞌva, ra xaꞌa ña katakaa na ra ndika cruz, va ke kachi ra saa. ");
INSERT INTO mxv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ra saa ndakuiin yuvi kan kachi na saa xiꞌin ra: ―Nduꞌu, ra te ^xini soꞌo ndi ña kaꞌvi na tuꞌun Ndioxi ra suꞌva va kachi ña, Cristo ra iin takundiꞌi tiempo va ke kutiaku ra kan, kachi ña. ¿Ra nichuun ke kaꞌan tu yoꞌo ña ndakuita tiaa ra xaa yoꞌo? ¿Ra yoo kuvi tiaa ra xaa ñaa? ―*kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ra saa ndikaꞌan tuku Jesús, kachi ra saa xiꞌin na: ―Vichin, ra iyoo ka va ñùꞌù xiꞌin ndo, ndi su saloꞌo ni va tiempo iyoo ña xiꞌin ndo. Ra ña iyoo ñùꞌù xiꞌin ndo vichin, ra na kaka va ndo, chi koto iin kama suꞌva xaa ña ñaa niꞌi ña ndoꞌo, chi yuvi na xika nuu ñaa, ra kundäa ini na ndia mii ku nuu kuaꞌan vi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ra na kandixa ndo ñùꞌù ña iyoo ña xiꞌin ndo vichin, ra saa ke niꞌi ndo, kuu ndo seꞌe ña ―kachi ra. Ra te ndiꞌi ndikaꞌan ra tuꞌun yoꞌo, ndia saa ra ndakiꞌin ra ndixaꞌan ra ndiseꞌe ra nuu va na. ");
INSERT INTO mxv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ra vaꞌa ni kuaꞌa ni va ña xituꞌun xa Jesús nuu na, ndi su ndikandïxa vi na ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ra ña kuu ña yoꞌo, ra ña vaꞌa na xinu nuu tuꞌun ña tiaa ra Isaías, ra ndikaꞌan tuꞌun yuꞌu Ndioxi xinaꞌa va kuvi ña, ta kachi ra suꞌva: Tata, ndia nii na xïin kandixa tuꞌun ña kaꞌan ndi Ra ndia nii tu na xïin kandixa xaꞌa ña ^xini na ña kaꞌnu ni ndiee va kun, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ra ndikaꞌan tu ra Isaías kachi ra suꞌva va: ");
INSERT INTO mxv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ndioxi kuvi ra ndasi nuu na, ra ndasatieꞌe ra nima na, ña vaꞌa na küni na xiꞌin nduchi nuu na, ra nii na kuïin na kandixa na xiꞌin ndinuni nima na, ra nii na nandïko na nuu yu, ña sandaꞌa yu na, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ra suꞌva ke kachi ra Isaías xaꞌa Jesús te yachi, saa chi xa xini nuu va ra ña kaꞌnu kuu mii Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ra vaꞌa ni saa va, ndi su kuaꞌa ni va na judío na kunaꞌnu xaꞌndia chiñu ra kandixa va na ña ndikaꞌan Jesús, ndi su ndixïin na ndatuꞌun na xiꞌin yuvi saa chi ndiyuꞌvi va na, ña tava ndia fariseo na veꞌe ñuꞌu kan. ");
INSERT INTO mxv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Saa chi kuni ka va na, ña na kaꞌan vaꞌa ni na yuuvi yoꞌo xaꞌa na, nuu ña kaꞌan vaꞌa Ndioxi xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ra saa ndiee ka vi ndikaꞌan Jesús xiꞌin na kachi ra saa: ―Yuvi na kandixa yuꞌu, ra süvi takua yuꞌu kuvi ra kandixa na, chi Tata yu, ra tiꞌvi yuꞌu vaxi va yu kuvi ra kandixa na. ");
INSERT INTO mxv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ra yuvi na ^xíní yuꞌu, ra ra tiꞌvi yuꞌu vaxi va yu kuvi ra ^xíní na. ");
INSERT INTO mxv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yuꞌu, ra kuu ñùꞌù, ra ña xaa yu ña yuuvi yoꞌo, ra ña vaꞌa na kundëe na kandixa yuꞌu, nuu ñaa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ra tu ndia na ^xini soꞌo tuꞌun yu, ra xïin na kandixa na ña, ra süvi yuꞌu kuvi ra sayukun kuachi xiꞌin na, saa chi ndixäa yu, ña sayukun yu kuachi xiꞌin na yuuvi yoꞌo, chi na xaa yu sakaku va yu kuvi na. ");
INSERT INTO mxv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ra yuvi na kundasi yuꞌu, ra xïin na kandixa na yuꞌu, ra iyoo va ña sayukun kuachi xiꞌin na, saa chi tuꞌun ña ndikaꞌan va yu ke sayukun kuachi xiꞌin na kii ña vaxi. ");
INSERT INTO mxv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Saa chi yuꞌu, ra süvi ña kuni mii yu ke kaꞌan yu; chi Tata yu ra tiꞌvi yuꞌu va kuvi ra xaꞌndia chiñu nuu yu, ndia ña ke xiniñuꞌu kaꞌan yu, ra ndia ña ke xiniñuꞌu sañaꞌa yu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ra xa kundaa va ini yu, chi ndiayu ña xaꞌndia Tata yu, ra ña taxi kutiaku yuvi ndiaa ndikaa ndikuꞌun va kuvi ña. Ña kan ke, ña xaꞌndia Tata yu nuu yu ke kaꞌan tu yu xiꞌin ndoꞌo va ―kachi Jesús xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ra ndia saloꞌo ni va kumani ña koo viko pascua, ra xa ^kundaa va ini Jesús ña xa ndixaa kii ña ndakoo ra ña yuuvi yoꞌo, ra nandiko ra kunuꞌu ra chi nuu nduꞌu Iva ra. Ra kuꞌvi ka vi ini ra xini ra na ndikun sata ra, na iyoo nuu ña yuuvi yoꞌo, ra ña kuꞌvi ni ini ra xini ra na, ra ndiakua ndataxi ra mii ra ña ndixiꞌi ra xaꞌa na. ");
INSERT INTO mxv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ra saa kuu, ra ndakunduꞌu Jesús xiꞌin ndia itaꞌan xiꞌin ra ña kuxini ndia, ra xa chikaa yuꞌu va timiaꞌa ra Judas Iscariote, seꞌe ra Simón, ña ndataxi ra Jesús ndaꞌa na saa ini. ");
INSERT INTO mxv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ndi su xa ^kundaa va ini Jesús ña taxi Iva ra Ndioxi takundiꞌi ndiayu ndaꞌa ra, saa chi nuu mii Ndioxi ke kee va ra, ra nuu mii Ndioxi ke nandiko tu ra kunuꞌu va ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ra saa kuu ndia ndee ndia xixini ndia, ra saa ndakundichi Jesús, ra kiꞌin ra tikoto ña isukun ra chinduꞌu ra kan, ra saa kiꞌin ra iin tikoto kani ra chikuꞌni ra ña toko ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ra te ndiꞌi saa chikaa ra tiakuii ini iin xikoꞌo, ra xaꞌa ra ndakatia ra xaꞌa ndia itaꞌan xiꞌin ra, ra te ndiꞌi saa sandachi ra ña xiꞌin tikoto ña nuꞌni toko ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ra ta kuyachin Jesús ña ndakatia ra xaꞌa ra Simón Pedro, ra saa ndikaꞌan ra Simón Pedro kachi ra saa xiꞌin ra: ―Tata, väꞌa kita ña ndakatia kun xaꞌa yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ña ^xa yu ra kundäa vi ini kun xiꞌin ña vichin, ndi su vaxi kii ra kundaa va ini kun xiꞌin ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ra saa ndikaꞌan ka ra Pedro kachi ra saa: ―Tata, ndia nii kii täxi yu ndakatia kun xaꞌa yu ―kachi ra. Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Tu na ndakätia yu xaꞌa kun, saa ra küvi kutaꞌan kun xiꞌin yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ra saa ndakuiin ra Simón Pedro kachi ra saa: ―Tata, tu saa, ra süvi takua xaꞌa yu ke ndakatia kun, chi na ndakatia tu kun ndaꞌa yu, xiꞌin xini va yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Saa ndikaꞌan Jesús kachi ra saa xiꞌin ra: ―Yuvi na xa chichi ra ndia takua xaꞌa va na kan ke xiniñuꞌu ndoo, saa chi yäkua ka na. Ra ndoꞌo tu, ra xa ndo nduyaa va kuvi ndo, saa chi yäkua ka ndo, ndi su süvi takundiꞌi tu ndo ninduyaa ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Saa chi ^xa kundaa va ini Jesús xaꞌa tiaa ra ndataxi ñaꞌa ndaꞌa na saa ini, ña kan ke ndikaꞌan ra, ña süvi takundiꞌi ndia kuvi ndia ninduyaa. ");
INSERT INTO mxv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ra te ndiꞌi ndakatia ra xaꞌa ndia, saa ndakusukun ra tikoto ña isukun ra, ra saa ndakunduꞌu tuku ra nuu mesa va, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿A ^kundaa ini ndo ni ke kuni kachi ña xa yu yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ndoꞌo, ra Tata Maestro kachi ndo xiꞌin yu, ra vaꞌa kaꞌan va ndo, saa chi suvi kuvi va yu. ");
INSERT INTO mxv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ra tu yuꞌu, ra kuu yu Tata Maestro ndo, ra ndakatia tu yu xaꞌa va ndo, saa ra, xiniñuꞌu ndakatia tu ndoꞌo va xaꞌa na taꞌan ndo. ");
INSERT INTO mxv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ra ña yoꞌo ke ^xa yu ña sakuaꞌa yu ndoꞌo, ra ta kuꞌva xa yu xi̱nì ndo ke na sa tu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ra ña ndixa ke kaꞌan yu xiꞌin va ndo, saa chi ndia nii na xachiñu tatu, ra küvi sa chee na nuu ra kuu xitoꞌo na, ra nii yuvi na kuaꞌan chiñu küvi sa chee tu nuu na tiꞌvi ñaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ra tu na kundaa ini ndo xiꞌin ña yoꞌo, ra sa ndo ña, saa ra vaꞌa ni va kee ndo. ");
INSERT INTO mxv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ra süvi xaꞌa takundiꞌi ndo ke kaꞌan yu, chi xa kundaa va ini yu ni ke iyoo nima ta iin iin ndoꞌo, ndia ndikaxin yu. Ndi su ña xiniñuꞌu va ke na xinu nuu tuꞌun Ndioxi ña kaꞌan kachi suꞌva: “Ra xixi xiꞌin va yu kuvi ra ndukuiin kanitaꞌan xiꞌin yu”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ra ña vaꞌa na kundaa ini ndo xaꞌa ña kuu, ña kan ke xa yachi va kaꞌan yu ña yoꞌo xiꞌin ndo, ra te xa na kuu ña, saa ra na kandixa va ndo, ña kuu yu tiaa ra kuu va yu. ");
INSERT INTO mxv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ra ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi yuvi na ndakiꞌin mani yuvi na ^tiꞌvi yu kuꞌun, ra yuꞌu va kuvi ra ndakiꞌin mani na; ra na ndakiꞌin mani yuꞌu, ra ra tiꞌvi yuꞌu xaa va yu kuvi ra ndakiꞌin mani na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo xiꞌin ndia, saa ra kusuchi ka vi ini ra, ra saa ndikaꞌan tieꞌe ra xiꞌin va ndia kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin ndo, saa chi iin ndoꞌo ndia ndee yoꞌo va kuvi ndia ndataxi yuꞌu ndaꞌa na saa ini xini yuꞌu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ra saa xaꞌa ndia itaꞌan xiꞌin ra xitoꞌni ndia nuu taꞌan ndia, ra ^ndakani ini ndia yoo xaꞌa ke ndikaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ra saa kuu ndia ndee ndia xixini ndia, ra yachin xiꞌin mii Jesús va nduꞌu iin ra itaꞌan xiꞌin ra, ra ^kuꞌvi ni ini ra xini ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ra saa ndixika ndaꞌa ra Simón Pedro nuu ra ña na ndakatuꞌun ra Jesús, ra vaꞌa kundaa ini ndia yoo xaꞌa ke ndikaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Saa nduyachin vaꞌa ka va ra xiin Jesús, ra ndindakatuꞌun ra ra, kachi ra saa: ―Tata, ¿yoo kuvi ra sa saa? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Ra chindaxi yu ixta taxi yu ndaꞌa kuvi ra ―kachi ra. Ra saa chindaxi Jesús ixta, ra taxi ra ña ndaꞌa ra Judas Iscariote, seꞌe ra Simón. ");
INSERT INTO mxv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Saa kiꞌin ra Judas ixta kan xixi ra, ra saa kuu ndia ndee ndia, saa ra ndikiꞌvi va timiaꞌa ini ra. Ra saa ndikaꞌan Jesús xiꞌin ra kachi ra saa: ―Chiñu ña kuni kun sa kun, ra kama ni ka na sa va kun ña ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ndi su ndia nii ndia ndee nuu mesa kan ndikundäa ini, nichuun ke kachi Jesús saa xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ra sava ndia ndakani ini, ña kuꞌun ra Judas kan sata ra ñaꞌa ña kuniñuꞌu ndia viko, a ñaꞌa, ña saniꞌi ndia na ndaꞌvi va tu, saa chi mii ra kan kuvi ra ndiso xuꞌun va. ");
INSERT INTO mxv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ra te ndiꞌi xixi ra Judas ixta kan, saa ra ndakundichi ra kuaꞌan va ra. Ra xa ñuu va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ra te kanata ra Judas kuaꞌan ra, ra saa ndikaꞌan Jesús kachi ra saa: ―Vichin ke ^kuni takundiꞌi yuvi yuꞌu ra xaa yoꞌo, ña kuu yu ra kaꞌnu, ra kundaa tu ini na ña kaꞌnu ni tu Tata yu Ndioxi va, xaꞌa chiñu ña ^xa yu. ");
INSERT INTO mxv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ra tu xiꞌin chiñu ña ^xa yu ke kundaa ini na ña kaꞌnu ni Ndioxi, saa ra ndasakaꞌnu ni tu mii va ra yuꞌu, ra xa numi ni va sa ra ña. ");
INSERT INTO mxv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ndoꞌo, ndia kuu seꞌe mii yu, ra na kundaa ini ndo, saa chi saloꞌo ni va kii íin yu xiꞌin ndo, ra xa ta kachi yu xiꞌin na judío ke ^kachi tu yu xiꞌin ndoꞌo va: Saa chi nanduku ni va ndo yuꞌu, ndi su kuchüun vi ndo xaa ndo nuu kuꞌun yu. ");
INSERT INTO mxv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ra ndiayu xaa ña ^ndakoo yu ndaꞌa ndo ke yoꞌo: na kuꞌvi ni ini ndo kuni taꞌan ndo. Ra ta kuꞌva ^kuꞌvi ini yuꞌu xini yu ndoꞌo, saa ke na sa tu ndoꞌo va, ña kuꞌvi ni ini ndo kuni taꞌan ndo. ");
INSERT INTO mxv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ra tu saa na sa ndo, ña kuꞌvi ni ini ndo kuni taꞌan ndo, saa ra kundaa ini takundiꞌi va yuvi ña kuu ndo ndia itaꞌan xiꞌin yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ra saa ndindakatuꞌun ra Simón Pedro Jesús kachi ra saa: ―Tata, ¿ndia mii ke kuꞌun kun? ―kachi ra. Ra saa ndakuiin Jesús kachi ra saa: ―Nuu kuꞌun yu, ra küvi vi kuꞌun kun xiꞌin yu vichin, ndi su kundikun va kun xaa kun te xa na ndiꞌi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ra saa ndikaꞌan ra Pedro xiꞌin ra kachi ra saa: ―Tata, ¿nichuun ke küvi kuꞌun yu xiꞌin kun vichin? Chi yuꞌu, ra xa iyoo nduvi va yu ña kuvi yu xaꞌa kun ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―¿A ndixa iyoo nduvi kun ña kuvi kun xaꞌa yu? Na kundani kun chi mii ña ndaa, ra ñuu vichin, ra xa uni va ichi tiseꞌe tuꞌun kun xaꞌa yu, ra saa kana chele ―kachi Jesús xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ra saa ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra, kachi ra saa: ―Ndïꞌi ini ndo. Na kundiaa ini ndo Ndioxi, ra na kundiaa ini tu ndo yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ra veꞌe Tata yu, ra iyoo kuaꞌa va nuu kundee ndo, ra tu süvi saa iyoo ña, saa ra käꞌan yu xiꞌin vi ndo, ra vichin ke kuꞌun yu ña sanduvi ka yu nuu kundee ndo. ");
INSERT INTO mxv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ra te xa na ndiꞌi savii yu nuu kundee ndo ña kuꞌun yu vichin, ra saa nandiko yu ndakiꞌin yu ndoꞌo ña kuꞌun ndo xiꞌin yu, ra mii nuu koo yu ke kundee tu ndoꞌo va xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ra ^xa xini va ndo, ndia chi ku nuu kuꞌun yu, ra xa xini tu ndo ichi ña kuaꞌan chi nuu kuꞌun va yu ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Saa ndikaꞌan ra Tomás, xiꞌin Jesús kachi ra saa: ―Tata, xïni ndi ndia chi ku nuu kuꞌun kun; ¿ra ni ke sa ndi kundaa ini ndi ndia mii kuu ichi? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Yuꞌu ku ra kuu ichi, ra yuꞌu ku ra kuu ña ndaa, ra yuꞌu ku ra kuu mii ña tiaku va. Ra ndia nii yuvi küvi xaa nuu Tata yu, tu na kïxi na nuu yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tu xíni̱ ndo yoo kuvi yu, saa ra xíni̱ tu ndo yoo kuvi Tata va yu; ra xa xíni̱ va ndo ra vichin, saa chi xa ^xíní va ndo ra ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ra saa ndikaꞌan ra Felipe, kachi ra saa xiꞌin Jesús: ―Tata, na sa kun ña mani ñaꞌa kun Tata yo Ndioxi nuu ndi, ra kundaa ini ndi ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Felipe, ¿xa kuaꞌa ni va kii iyoo yu xiꞌin ndo, ra nani saa xïni kun yuꞌu saa va? Yuvi na ^xíní yuꞌu, ra ^xíní tu na Tata va yu; ¿ra nichuun ke kaꞌan kun, ña na ñaꞌa yu Tata yo Ndioxi nuu kun? ");
INSERT INTO mxv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ra a kandïxa va kun ña íin Tata yo Ndioxi xiꞌin yu, ra yuꞌu tu íin xiꞌin ra kan va? Ra tuꞌun ña kaꞌan yu, ra süvi tuꞌun mii yu kuvi ña. Chi Tata yo Ndioxi va kuvi ra taxi ña, ra mii ra kuvi tu ra xa takundiꞌi chiñu va. ");
INSERT INTO mxv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ra na kandixa ndo yuꞌu, ña íin Tata yo Ndioxi xiꞌin yu, ra yuꞌu tu íin xiꞌin ra kan va; ra tu kandïxa ndo ña kaꞌan yu, saa ra ña sa ndo ke na kandixa ndo yuꞌu xiꞌin chiñu ña ^xa va yu. ");
INSERT INTO mxv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ra ña ndaa kaꞌan yu xiꞌin ndo, chi yuvi na kandixa yuꞌu, ra taꞌan chiñu ña ^xa yuꞌu ke sa tu na kan va; ra tu na kuvi, ra ña naꞌnu ka va sa na, saa chi yuꞌu ra xa kunuꞌu va yu nuu Tata yo Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ra takundiꞌi ña nduku ndo nuu Tata yo Ndioxi xiꞌin kivi yu, ra sa va yu ña, ra saa ke kundaa ini ndo ña kaꞌnu ni Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ra ndia ndia ka ñaꞌa na nduku ndo xiꞌin kivi yu, ra sa va yu ña ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Tu ndixa kuꞌvi ini ndo xini ndo yuꞌu, saa ra na kandixa ndo ndiayu va yu. ");
INSERT INTO mxv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ra yuꞌu tu kuaku ndaꞌvi nuu Tata yo Ndioxi, ra tiꞌvi ra Tachi Yii ra kixi ña chindiee taꞌan ña xiꞌin ndo, ra koo ña xiꞌin ndo iin ndisaa kii. ");
INSERT INTO mxv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ra ña kan kuu Tachi Yii Ndioxi ña ndaa. Ra na yuuvi yoꞌo ra ^küvi vi ndakiꞌin na ña chi xïni na ña, ra nii kundäa tu ini na ni ñaꞌa kuvi va ña, ndi su ndoꞌo, ra ^xini va ndo ña, chi xa xiꞌin va ndo iyoo ña, ra koo tu ña xiꞌin ndo iin takundiꞌi kii va. ");
INSERT INTO mxv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ra na kundaa ni ndo, chi ndaköo ndaꞌa yu ndoꞌo; saa chi ndiko tuku va yu kixi yu sata ndo. ");
INSERT INTO mxv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ra saloꞌo ni va kumani, saa ra küni ka vi na yuuvi yoꞌo yuꞌu, ndi su ndoꞌo ra kuni va ndo yuꞌu; saa chi kutiaku va ndo, chi yuꞌu ra tiaku va yu. ");
INSERT INTO mxv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ra te xa na xaa kii kan ke kundaa kaxi ini ndo, ña íin yu xiꞌin Tata yu Ndioxi, ra ndoꞌo tu iyoo xiꞌin yuꞌu va, ra yuꞌu tu íin xiꞌin ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ra yuvi na xini ndiayu yu, ra xa na ña kaꞌan ña, saa ra, ^ndañaꞌa na mii na ña ndixa ke kuꞌvi ini na xini na yuꞌu va. Ra na kuꞌvi ini xini yuꞌu, ra kuꞌvi ni tu ini Tata va yu kuni ra na, ra saa tu yuꞌu va, chi kuꞌvi ni va ini yu kuni yu na, ra ndañaꞌa yu mii yu nuu na ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ra saa ndikaꞌan iin ra itaꞌan xiꞌin Jesús ra nani Judas (ndi su süvi ra Judas Iscariote kuvi ra) kachi ra saa: ―Tata, ¿ra ni ke iyoo ña, ña ñaꞌa kun mii kun nuu takua nduꞌu, ra ñäꞌa tu kun mii kun nuu na yuuvi yoꞌo? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Saa ndakuiin Jesús kachi ra saa xiꞌin ra: ―Yuvi na kuꞌvi ini xini yuꞌu, ra kandixa va na tuꞌun ña kaꞌan yu, ra Tata yu Ndioxi, ra kuꞌvi ni va ini ra kuni ra na, ra yuꞌu xiꞌin Tata yu, ra kixi va ndi koo ndi xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ra yuvi na küꞌvi ini xini yuꞌu, ra kandïxa vi na kan tuꞌun ña kaꞌan yu xiꞌin na. Ra tuꞌun ña xini soꞌo ndo yoꞌo, ra süvi tuꞌun yuꞌu kuvi ña, chi tuꞌun Tata yu Ndioxi ra tiꞌvi yuꞌu vaxi va yu kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ra ña íin ka yu xiꞌin ndo vichin va ke kaꞌan yu takundiꞌi ña yoꞌo xiꞌin ndo, ");
INSERT INTO mxv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ndi su Tachi Yii, ña tiꞌvi Tata yo Ndioxi kixi nuu va yu kuvi ña chindiee taꞌan xiꞌin ndo, ra taxi ña tuꞌun ndiee ini ndaꞌa ndo, ra sañaꞌa tu ña ndoꞌo xaꞌa takundiꞌi chiñu, ra sandakaꞌan tu ña ndoꞌo xaꞌa takundiꞌi tuꞌun ña ^kaꞌan yu xiꞌin va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ra vichin ke, indiayu taꞌan yu xiꞌin ndo xiꞌin ña vaꞌa ña kuu mii yu. Ra ña vaꞌa ña kuu mii yu ke ndakoo tu yu xiꞌin va ndo, ra inüu ña xiꞌin ña taxi ña yuuvi yoꞌo. Ra na kundïꞌi ni ini ndo, ra nii na kuayüꞌvi va tu ndo xaꞌa ña kuu. ");
INSERT INTO mxv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ra xa xini va soꞌo ndo, ña ndikaꞌan yu xiꞌin ndo ña kuꞌun yu, ndi su nandiko va tu yu sata ndo. Ra tu ndixa ke kuꞌvi ini ndo xini ndo yuꞌu, saa ra ndo kusii ka ini va kuvi ndo, ña ^kundaa ini ndo ña kuꞌun yu nuu Tata yu, saa chi kaꞌnu ni ka va ra kan nuu yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ra xa yachi va kaꞌan yu xiꞌin ndo xaꞌa ña kuu; ra te xa na kuu ña, saa ra na kandixa va ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ra käꞌan kuaꞌa ni ka yu xiꞌin ndo; saa chi xa kuyachin va ri ñaꞌa, ri xaꞌndia chiñu nuu ña yuuvi yoꞌo vaxi ri. Ra köo vaꞌa mii ndiee vi ri kan nuu yuꞌu, ");
INSERT INTO mxv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ndi su ña vaꞌa na kundaa ini na yuuvi yoꞌo, ña kuꞌvi ni ini yu xini yu Tata yu ke xiniñuꞌu saxinu va yu chiñu ña xaꞌndia ra nuu yu, ra iin ta kachi ra xiꞌin yu ke sa va yu. Ndakuita ndo. Ra kuꞌun yo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ra saa ndikaꞌan Jesús kachi ra saa xiꞌin ndia itaꞌan xiꞌin ra: ―Yuꞌu kuvi ra kuu teꞌe uva ña ndixa, ra Tata yu kuvi ra chiꞌi ña, ra ndiaa ra ña. ");
INSERT INTO mxv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ra takundiꞌi yoꞌó vali ndaꞌa ña, ña kuëe taxi uva, ra kaꞌndia ndiꞌi va ra ña, ra ña taxi uva, tu ndaxatia va ra, ña vaꞌa kuaꞌa ni ka uva na taxi va ña. ");
INSERT INTO mxv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ra ndoꞌo, ra xa ndo nduvii va kuvi ndo xiꞌin tuꞌun ña sañaꞌa yu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ña kan ke na kundikun ndiaa va ndo yuꞌu, ra yuꞌu tu kuiin xiꞌin ndoꞌo va. Ra na kundaa ini ndo, chi takundiꞌi yoꞌó vali ndaꞌa teꞌe uva, ra tu na kundïkun ndiaa ña sata mii yoꞌo chee teꞌe uva, saa ra küvi vi taxi ña uva, ra mii saa ke ndoꞌo tu ndoꞌo va, tu na kundïkun ndiaa ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yuꞌu kuvi ra kuu teꞌe uva, ra ndoꞌo kuvi ndia kuu yoꞌo vali ndaꞌa va ña, ra na ndikun ndiaa yuꞌu, ra yuꞌu tu iin xiꞌin va na, ra na kan kuvi na kuaꞌa ni uva taxi va; ra tu na kundïkun ndiaa na yuꞌu, saa ra ndia nii ña ke kuchüun na sa vi na. ");
INSERT INTO mxv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ra yuvi na ndïkun ndiaa yuꞌu, ra kutia va na, ra ndachi va tu na, ra ndoꞌo na ta kuꞌva ndoꞌo yoꞌo vali ndaꞌa teꞌe uva ña xitia ra ndachi ña, ra te ^ndiꞌi ndakaya na ña, ra taan na ña nuu ñùꞌù xixi va ña. ");
INSERT INTO mxv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tu na kundikun ndiaa ndo yuꞌu, ra näa ini ndo xaꞌa tuꞌun yu, saa ra ndia ndia ka ña kuni ndo nduku ndo nuu Tata yu, ra niꞌi va ndo ña. ");
INSERT INTO mxv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ra na kundaa ini ndo, chi ndukaꞌnu ni va Tata yu Ndioxi, te kuaꞌa ni kuiꞌi ^taxi ndo, ra saa ke ndañaꞌa tu ndo mii ndo ña ndikun ndo yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ra iin ta kuꞌva kuꞌvi ini Tata yu Ndioxi xini ra yuꞌu, ra iin saa ke kuꞌvi tu ini yuꞌu va xini yu ndoꞌo, ra na ndaköo ndo ña kuꞌvi ini yu xini yu ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ra tu na kandixa ndo ndiayu yu, saa ra kaka va ndo tixi ña kuꞌvi ini yu xini yu ndoꞌo, ta kuꞌva ^xa yuꞌu ña ^kandixa yu ndiayu Tata yu Ndioxi, ra xika yu tixi ña kuꞌvi ini ra xini ra yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ra tuꞌun yoꞌo ke kaꞌan yu xiꞌin ndo, ña vaꞌa na koo ña sii ini ña iyoo nuu yu xiꞌin ndo, ra saa ke na kusii ni ka va ini ndo. ");
INSERT INTO mxv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ra ndiayu ña taxi yu ndaꞌa ndo kuvi ña: na kuꞌvi ni ini ndo kuni taꞌan ndo, ta kuꞌva ^kuꞌvi ini yuꞌu xini yu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ra iin ña kuꞌvi ini ña chee ni kuvi ña, taxi yuvi mii na ña kuvi na xaꞌa na itaꞌan xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ra tu na sa ndo ña kaꞌan yu, ra saa ke kuu ndo ndia itaꞌan mani xiꞌin va yu. ");
INSERT INTO mxv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ra käꞌan ka yu ña kuu ndo, ndia xachiñu tatu, saa chi ndia xachiñu tatu ra xïni vi ndia kan, xaꞌa takundiꞌi chiñu ña xa xitoꞌo ndia. Ña kan ke ndoꞌo, ra ndia itaꞌan mani xiꞌin va yu kaꞌan yu xiꞌin ndo, saa chi xa ndañaꞌa ndiꞌi va yu tuꞌun ña ndikaꞌan Tata yu xiꞌin yu nuu ndo. ");
INSERT INTO mxv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ra süvi ndoꞌo kuvi ndo nindakaxin yuꞌu, chi yuꞌu va kuvi ra ndakaxin ndoꞌo, ra taxi yu chiñu ndaꞌa ndo, ña na kuꞌun ndo sa ndo ña kaꞌan yu, ra kuaꞌa ni kuiꞌi na taxi ndo, ra kuiꞌi ña taxi ndo kan, ra na koo ña iin ndisaa kii, ra saa ke taxi Tata yu takundiꞌi ña nduku ndo nuu ra xiꞌin kivi yu. ");
INSERT INTO mxv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ra chiñu ña xaꞌndia yu nuu ndo ke, na kuꞌvi ni ini ndo kuni taꞌan va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ra ña kundasi na yuuvi yoꞌo ndoꞌo, ra na kundaa ini ndo, chi xiꞌna ka vi yuꞌu kuvi ra kundasi na. ");
INSERT INTO mxv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ra tu ta kuꞌva iyoo mii na yuuvi yoꞌo ndixiyo ndo, saa ra kuꞌvi ni va ini na kuni na ndoꞌo, ndi su süvi ka taꞌan na kuvi ndo, saa chi xa ndatava va yu ndoꞌo tiañu na, ra ña kan va ke kundasi na ndoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ra na ndakaꞌan ndo xaꞌa tuꞌun ña ndikaꞌan yu xiꞌin ndo, ta kachi yu suꞌva: “Ndia nii na xachiñu tatu ra chëe na nuu xitoꞌo na.” Ra na kundaa ini ndo, chi tu taxi na yuꞌu, saa ra taxi tu na ndoꞌo va; ra tu xiin va na sakuaꞌa na tuꞌun ña sañaꞌa yu na, saa ra kuiin tu na sakuaꞌa na ña sañaꞌa ndoꞌo va na. ");
INSERT INTO mxv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ra xaꞌa ña ndikun ndo yuꞌu va ke kundasi na ndoꞌo, ra sa na takundiꞌi ña kuni na xiꞌin ndo, saa chi xïni na ra tiꞌvi yuꞌu xaa yu, ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ra tu kuëe ndikixi yu ndatuꞌun yu xiꞌin na, saa ra köo vi kuachi na, ndi su vichin, ra köo ka ña niꞌi na tiaa vi na, ña kachi na köo kuachi na, ");
INSERT INTO mxv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","saa chi yuvi na kundasi yuꞌu, ra kundasi tu na Tata yu Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ra tu kuëe ndixa yu, ña xituꞌun ña täan sa ndia nii yuvi kuni na, saa ra köo vi kuachi na, ndi su vichin, ra xa xini va na ña xituꞌun xa yu, ra xaꞌa ña kan ke ^kundasi na yuꞌu, ra ^kundasi tu na Tata yu Ndioxi va. ");
INSERT INTO mxv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ra suꞌva ke xiniñuꞌu kuu va, ña kan ke vaꞌa xinu nuu tuꞌun Ndioxi ña kachi suꞌva: “Iin saa kaa kundasi na yuꞌu va”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ra te xa na xa̱a̱ Tachi Yii ña chindiee taꞌan xiꞌin ndo, ña tiꞌvi yu kixi, ña kuu mii Tata yu Ndioxi, ra ña kan va kuvi ña ndatuꞌun mii ña ndaa xiꞌin ndo xaꞌa yu. ");
INSERT INTO mxv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ra ndatuꞌun tu ndoꞌo va mii ña ndaa xaꞌa yu, saa chi ndoꞌo kuvi ndo xikutaꞌan xiꞌin yu ndia te kii xaꞌa vi. ");
INSERT INTO mxv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ra takundiꞌi ña yoꞌo ke kaꞌan yu xiꞌin ndo, ña vaꞌa na ndïko ini ndo ña ndikun ndo yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Saa chi vaxi kii, ra tava va na ndoꞌo veꞌe ñuꞌu nuu ndakitaꞌan ndo, ra ndia kaꞌni va na ndoꞌo, ra ta xa na ^sa na saa, ra ña vaꞌa kuni Ndioxi va ke ^xa na kàꞌàn na. ");
INSERT INTO mxv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ra saa ke sa va na, saa chi xïni vi na yuꞌu, ra nii Tata yu Ndioxi kuvi ra xïni vi na. ");
INSERT INTO mxv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ra ña yoꞌo ke kaꞌan yu xiꞌin ndo ña xa na ku̱ꞌu̱n ini ndo, ra te xa na kuu ña xiniñuꞌu kuu, ra saa ke na ndakaꞌan ndo xaꞌa ña xa ndikaꞌan yu xiꞌin va ndo ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. Ra saa ndikaꞌan ka Jesús kachi ra saa: ―Te kii xaꞌa, ra ndikäꞌan vi yu ña yoꞌo xiꞌin ndo, saa chi ta íin ka va yu xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ndi su vichin, ra xa nandiko va yu kunuꞌu yu nuu Tata yu Ndioxi ra tiꞌvi yuꞌu vaxi yu, ra ndia nii tu ndo xïin ndakatuꞌun yuꞌu ndia mii ku nuu kuꞌun va yu. ");
INSERT INTO mxv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chi ña xa ndo ke kusuchi ni ini ndo, xaꞌa tuꞌun ña ndikaꞌan yu xiꞌin va ndo. ");
INSERT INTO mxv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ndi su ña ndaa va ke kaꞌan yu xiꞌin ndo: chi ña vaꞌa ni ka va ke na kuꞌun yu, saa chi tu na küꞌun yu, saa ra küvi vi kixi Tachi Yii Ndioxi ña chindiee taꞌan ña xiꞌin ndo, ña kan ke xiniñuꞌu kuꞌun va yu, ra saa ke vaꞌa tiꞌvi yu Tachi Yii, ña kixi ña koo ña xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ra ta xa na xaa Tachi Yii Ndioxi, ra ña kan va kuvi ña kaꞌan xiꞌin na yuuvi yoꞌo, ra kundaa va ini na ña iyoo kuachi na, ra kaꞌan ña xiꞌin na ña iyoo iin ichi ndaku, ra kaꞌan tu ña xiꞌin na, ña sandaku Ndioxi kuachi xiꞌin va na. ");
INSERT INTO mxv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ra kaꞌan ña, ña iyoo kuachi na, saa chi xïin na kandixa na yuꞌu; ");
INSERT INTO mxv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ra kaꞌan ña xiꞌin na ra kundaa va ini na xaꞌa ichi Ndioxi ña ndaku, saa chi yuꞌu, ra xa kunuꞌu va yu nuu Tata yu Ndioxi, ra ndoꞌo, ra küni ka vi ndo yuꞌu; ");
INSERT INTO mxv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ra kaꞌan ña xiꞌin na ra kundaa tu ini na, ña sandaku Ndioxi kuachi xiꞌin va na, saa chi ri kuchee xaꞌndia chiñu nuu ña yuuvi yoꞌo, ra xa nditiaꞌndia va xaꞌa ri ña ndiꞌi xaꞌa ri. ");
INSERT INTO mxv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ra iyoo kuaꞌa ni ka va ña kaꞌan yu xiꞌin ndo, ndi su kundiëe ndo xiꞌin vi ña. ");
INSERT INTO mxv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ra te xa na xa̱a̱ Tachi Yii Ndioxi ña ndixa, ra ña kan va ke sañaꞌa ndoꞌo xaꞌa takundiꞌi ña ndaa; saa chi süvi ña kuni mii ña ke kaꞌan ña xiꞌin ndo, chi ña kuni soꞌo ña kaꞌan Ndioxi va ke kaꞌan ña xiꞌin ndo, ra taxi ña xini ndo, ra kundaa va ini ndo xaꞌa takundiꞌi ña kuu kii ña vaxi. ");
INSERT INTO mxv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ra Tachi Yii Ndioxi va kuvi ña chinduꞌu toꞌo tuꞌun xaꞌa yu, saa chi ^kundaa va ini ña xaꞌa takundiꞌi ña xa yu, xiꞌin ña sañaꞌa yu, ra ndañaꞌa tu ña ña nuu ndoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ra takundiꞌi ñaꞌa ña iyoo nuu Tata yu Ndioxi, ra ñaꞌa yuꞌu ke xiꞌin va ra. Ra ña kan va ke ndikaꞌan yu xiꞌin ndo ña ndakiꞌin Tachi Yii Ndioxi ña iyoo nuu yu, ra ndañaꞌa ña ña nuu ndoꞌo va ―kachi Jesús xiꞌin ndia itaꞌan xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ra ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Na kundaa ini ndo, chi ndia saloꞌo ni va kii kumani, ra küni ka vi ndo yuꞌu, ndi su te xa na yaꞌa loꞌo kii, saa ra kuni tuku va ndo yuꞌu, saa chi nuu iyoo Tata yu Ndioxi va ke kuꞌun yu ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ra saa xaꞌa sava ndia itaꞌan xiꞌin Jesús ndakatuꞌun taꞌan ndia kachi ndia saa: ―¿Ni ke kuni kachi tuꞌun ña kaꞌan ra xiꞌin yo, ña kachi ra, ña saloꞌo ni va kii kumani ra küni ka yo ra, ra te xa na yaꞌa loꞌo kii, ra kuni tuku va yo ra, ra kuꞌun tu ra nuu Tata ra Ndioxi va kachi ra? ");
INSERT INTO mxv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ra ni ke kuni kachi ra, “ña saloꞌo ni va kii kumani”? Kundäa vaꞌa ini vi yo ni ke kaꞌan ra ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ra kundaa va ini Jesús ña kuni ndia ndakatuꞌun ndia ra, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―¿A xaꞌa ña ndikaꞌan yu xiꞌin ndo, ña saloꞌo ni kii kumani ra küni ka ndo yuꞌu, ra te xa na yaꞌa loꞌo kii, saa ra kuni tuku va ndo yuꞌu, ke ndakatuꞌun ndo xaꞌa? ");
INSERT INTO mxv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ra ña ndaa ke kaꞌan yu xiꞌin ndo, saa chi kusuchi ni va ini ndo, ra kuaku ni va tu ndo, ra na yuuvi yoꞌo tu tiaa ni kusii ini va. Ra ña kusuchi ni ini ndo, ra ndasama ña ra nduu ña ña sii ini va. ");
INSERT INTO mxv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ta kuꞌva ndoꞌo iin ñaꞌa ña kaku seꞌe, chi te xa kuyachin kaku seꞌe ña, ra tiaa ni va xaꞌndia ña ini ña, ra tixuꞌvi ni ña, ndi su te xa ndiꞌi kaku ña loꞌo, saa ra ndakäꞌan ka vi ña xaꞌa ña tixuꞌvi ña, chi xiꞌin seꞌe ña, ña kaku kan va tiaa ni kusii ini ña. ");
INSERT INTO mxv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ra mii saa ke ^ndoꞌo tu ndoꞌo va; saa chi vichin va ke kusuchi ni ini ndo, ndi su te xa na nandiko tuku yu kuni ndo, saa ra tiaa nii va kusii ini ndo, ra ña kusii nii ini ndo, ra ndia nii na kuchüun kindiaa ña ndaꞌa ndo. ");
INSERT INTO mxv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ra kii kan, ra köo mii ka ña ndakatuꞌun ndo yuꞌu vi. Ra ña ndaa kaꞌan yu xiꞌin ndo: saa chi xa mii va Tata yu Ndioxi kuvi ra taxi takundiꞌi ña nduku ndo nuu ra xiꞌin kivi yu. ");
INSERT INTO mxv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ra ndia kii vichin, ra ndia nii ñaꞌa täan nduku ndo xiꞌin kivi yu nuu tata yu, ra na nduku ndo ña, ra niꞌi va ndo ña, ra saa ke kusii ni ka va ini ndo ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ra ndikaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra kachi ra saa: ―Takundiꞌi tuꞌun ña xa ndikaꞌan yu xiꞌin ndo, ra xiꞌin tuꞌun ndichi va ndikaꞌan yu ña; ndi su vaxi kii ra käꞌan ka yu tuꞌun ndichi xiꞌin ndo, chi kaxi kaxi va kaꞌan yu xiꞌin ndo xaꞌa Tata yu Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ra te xa na xaa kii ña nduku ndo ña kumani nuu ndo xiꞌin kivi yu, ra kuäku ndaꞌvi ka yu nuu Tata yu Ndioxi xaꞌa ndo, ");
INSERT INTO mxv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","chi xa ^kuꞌvi ni tu ini mii va ra xini ra ndoꞌo, saa chi ^kuꞌvi ni ini ndo xini ndo yuꞌu, ra kandixa tu ndo yuꞌu ña kee yu nuu va ra. ");
INSERT INTO mxv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ra nuu iyoo Tata yu Ndioxi ke kee yu ña xaa yu ña yuuvi yoꞌo va, ra vichin ndakoo yu ña yuuvi yoꞌo, ra nandiko yu kunuꞌu tuku yu nuu Tata yu Ndioxi va ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ra saa ndikaꞌan ndia itaꞌan xiꞌin Jesús kachi ndia saa xiꞌin ra: ―Vichin, ra kaxi ni va kaꞌan kun xiꞌin ndi, ra nii xiniñüꞌu ka kun tuꞌun ndichi vi. ");
INSERT INTO mxv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ra vichin ke kundaa kaxi ini ndi ña kundaa ini kun xaꞌa takundiꞌi va ñaꞌa, saa chi vaꞌa ni ndakatüꞌun vi na yoꞌo, ra xa kaꞌan va kun ña kuni na ndakatuꞌun na. Ra xaꞌa ña kan ke kandixa va ndi yoꞌo ña kee kun nuu Ndioxi ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―¿Ra ndia vichin vi ke kandixa ndo yuꞌu? ");
INSERT INTO mxv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ra na kundaa ini ndo, chi vaxi kii, ra xa mii kii vichin kuvi va ña, ra takundiꞌi ndoꞌo, ra kunu va ndo kunuꞌu ndo veꞌe ndo, ra ndakoo mituꞌun va ndo yuꞌu. Ndi su xa saa kuïin mituꞌun vi yu, chi kuiin va Tata yu Ndioxi xiꞌin yu. ");
INSERT INTO mxv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ra tuꞌun yoꞌo ke kaꞌan yu xiꞌin ndo, ña vaꞌa na kundaa ini ndo, chi nuu yuꞌu ke niꞌi ndo ña vaꞌa koo xiꞌin va ndo. Ra ña ndixa ke sandoꞌo ni va na ndoꞌo nuu ña yuuvi yoꞌo; ndi su na kundiaa ini ndo yuꞌu, saa chi yuꞌu, ra xa xatiaa va yu nuu ña yuuvi yoꞌo ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo, ra saa ndoniꞌi ra nuu ra chi ndivi, ra ndikaꞌan ra xiꞌin Ndioxi kachi ra saa: ―Tata, vichin ke ndixaa kii ña na ndañaꞌa kun yuꞌu, ra kuu seꞌe kun nuu yuvi ra na kundaa ini na ña kaꞌnu ni yu, ra ndañaꞌa tu yuꞌu va yoꞌo nuu na, ra kundaa ini na ña kaꞌnu ni kun. ");
INSERT INTO mxv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Saa chi yoꞌo kuvi ra taxi takundiꞌi ndiayu ndaꞌa yu, ña kaꞌndia chiñu yu nuu takundiꞌi na yuuvi, ra taxi yu ña kutiaku takundiꞌi na taxi kun ndaꞌa yu ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ra ña vaꞌa na niꞌi na ña kutiaku na ndia ndikaa ndikuꞌun, kuvi ña xiniñuꞌu kuni taꞌan vaꞌa na xiꞌin indaa mituꞌun yoꞌo va Tata Ndioxi, ra ndaa, ra saa tu yuꞌu, ra kuu Jesucristo ra tiꞌvi kun xaa ña yuuvi yoꞌo va. ");
INSERT INTO mxv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ra xa ndañaꞌa va yu yoꞌo nuu na yuuvi ña kaꞌnu ni kun, xaꞌa ña xa saxinu yu takundiꞌi chiñu ña xaꞌndia kun nuu yu sa yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ra vichin ke na ndataxi tuku kun ndiee ña xa xikuu mii yu ndaꞌa yu, Tata, xa ta kuꞌva ndixiyo ndiee yu xiꞌin kun ta kumani ka kukava xaꞌa ña yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ra xa ndañaꞌa va yu yoꞌo, nuu na ndakaxin kun tiañu na yuuvi yoꞌo, ra kuenda yoꞌo va kuvi na, ra taxi kun na ndaꞌa yu, ra ^kandixa va na tuꞌun kun. ");
INSERT INTO mxv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ra vichin, ra takundiꞌi ñaꞌa ña ^taxi kun ndaꞌa yu, ra ^kundaa va ini na xaꞌa ña ña kuu ña kuenda kun. ");
INSERT INTO mxv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ra tuꞌun ña taxi kun ndaꞌa yu ke sañaꞌa va yu na; ra xiin va na kandixa na ña, ra kundaa kaxi va ini na ña kee yu nuu iyoo kun, ra ^kandixa tu na ña tiꞌvi kun yuꞌu xaa va yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ra xaku ndaꞌvi yu nuu kun xaꞌa takua na itaꞌan xiꞌin va yu, ndi su xäku ndaꞌvi vi yu xaꞌa na yuuvi yoꞌo, saa chi takua na taxi kun ndaꞌa va yu kuvi na kaꞌan yu xaꞌa xiꞌin kun; saa chi kuenda yoꞌo va kuvi na. ");
INSERT INTO mxv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ra takundiꞌi na itaꞌan xiꞌin yu kuvi na kuu kuenda va kun, ra takundiꞌi na kuu kuenda yoꞌo, kuvi tu na itaꞌan xiꞌin yuꞌu va; ra xaꞌa ña xa na yoꞌo ke ndukaꞌnu ni tu yuꞌu va. ");
INSERT INTO mxv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yuꞌu, ra köo ka yu nuu ña yuuvi yoꞌo, ndi su na yoꞌo, ra kundee va na, ra yuꞌu tu xa xaa koo xiꞌin yoꞌo va Tata Ndioxi, ra yii. Ra na taxi kun ndaꞌa yu, ra na kondiaa kun na xiꞌin kivi kun, ña kuu mii ndiee, ra iin tuꞌun na kuu na xiꞌin taꞌan na, ta kuꞌva iyoo yoꞌo xiꞌin yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ra te ndixiyo yu xiꞌin na taxi kun ndaꞌa yu nuu ña yuuvi yoꞌo, ra xiꞌin ndiee va kun ke xindiaa yu na; ra ndia nii na nindoñüꞌu sa yu, chi takua ra xa iyoo tuꞌun xaꞌa ndoñuꞌu va kuvi ra nindoñuꞌu, ra saa ke kuu va ña vaꞌa na xinu nuu tuꞌun kun ña kaꞌan xaꞌa ra. ");
INSERT INTO mxv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ra vichin, ke nandiko yu xaa yu nuu iyoo kun, ra ña íin ka yu xiꞌin na nuu ña yuuvi yoꞌo vichin, ke kaꞌan ka yu tuꞌun yoꞌo xiꞌin va na, ña vaꞌa na kusii ini na ta kuꞌva kusii ini yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ra xa ndatuꞌun va yu tuꞌun kun xiꞌin na itaꞌan xiꞌin yu, ndi su na yuuvi yoꞌo ra kundasi va na na, saa chi süvi ka kuenda na yuuvi yoꞌo kuvi na, ra saa tu yuꞌu va chi süvi kuenda na yuuvi yoꞌo kuvi yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ra käꞌan yu xiꞌin kun, ña tava kun na itaꞌan xiꞌin yu tiañu na yuuvi yoꞌo, chi ña nduku yu nuu kun ke na kondiaa kun na nuu timaꞌa va. ");
INSERT INTO mxv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Saa chi süvi ka kuenda na yuuvi yoꞌo kuvi na, ra saa tu yuꞌu va chi süvi kuenda na yuuvi yoꞌo kuvi yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ra xiꞌin ña ndaa ña kuu mii kun ke, na ndakaxin kun na, ña sachiñu na nuu kun, saa chi tuꞌun kun ra ña ndaa va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ra ta kuꞌva xa kun ña tiꞌvi kun yuꞌu xaa yu nuu ña yuuvi yoꞌo, ra saa ke sa tu yuꞌu va, ña tiꞌvi yu na yoꞌo kuꞌun na nuu na yuuvi yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ra xaꞌa na yoꞌo ke ^ndataxi yu mii yu ndaꞌa kun, ña vaꞌa na ndasayii ña ndaa ña kuu mii kun na. ");
INSERT INTO mxv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ndi su süvi takua xaꞌa na yoꞌo ke kaꞌan yu xiꞌin kun, chi ^kaꞌan tu yu xiꞌin kun xaꞌa takundiꞌi na kandixa yuꞌu, na kaꞌan ndoso na itaꞌan xiꞌin yu nuu, kii ña vaxi va. ");
INSERT INTO mxv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ra saa ke, iin tuꞌun na nduu takundiꞌi va na, ta kuꞌva iyoo yoꞌo xiꞌin yuꞌu, Tata, ña kuu yo iin va, ra saa ke na koo tu na yoꞌo va, ña iin va na nduu na xiꞌin yo. Ra saa ke vaꞌa na kandixa na yuuvi yoꞌo, ña tiꞌvi kun yuꞌu xaa yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ra ña kaꞌnu, ña taxi kun ndaꞌa yu kuvi ña ndataxi tu yuꞌu va ndaꞌa na yoꞌo, ña vaꞌa iin tuꞌun na nduu na, ta kuꞌva iyoo yoꞌo xiꞌin yuꞌu, ña kuu yo iin va. ");
INSERT INTO mxv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ra yuꞌu kuvi ra íin xiꞌin na yoꞌo, ra yoꞌo kuvi tu ra íin xiꞌin yuꞌu va, saa chi saa ke vaꞌa ndinuni ni kutaꞌan na xiꞌin taꞌan na, ña vaꞌa na kundaa ini na yuuvi yoꞌo, ña tiꞌvi kun yuꞌu, xaa yu nuu ña yuuvi yoꞌo, saa chi ^kuꞌvi ni ini kun xini kun na, ta kuꞌva ^kuꞌvi ini kun xini kun yuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ra na taxi kun ndaꞌa yu yo̱ꞌo̱, Tata, ra kuni yu ña na kundee na xiꞌin yu nuu koo yu, ra saa ke vaꞌa na kuni na ña kaꞌnu, ña taxi kun ndaꞌa yu; saa chi yoꞌo kuvi ra xa kuꞌvi ni ini xini yuꞌu te täan kukava xaꞌa ña yuuvi yoꞌo vi. ");
INSERT INTO mxv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, yoꞌo kuvi ra ^xa ña ndaku, ra na ndee nuu ña yuuvi yoꞌo, ra xïni vi na yoꞌo, ndi su yuꞌu, ra xini va yu yoꞌo, ra na itaꞌan xiꞌin yu, ra kundaa va ini na ña tiꞌvi kun yuꞌu xaa yu. ");
INSERT INTO mxv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ra xa ndikaꞌan va yu xiꞌin na itaꞌan xiꞌin yu, yoo kuvi kun, ra kaꞌan ka tuku va yu xiꞌin na, yoo kuvi kun, ra saa ke vaꞌa na kuꞌvi ini na kuni taꞌan na ta kuꞌva kuꞌvi ini kun xini kun yuꞌu, ra kuiin tu mii yu xiꞌin va na ―kachi Jesús xiꞌin Tata ra Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ra te ndiꞌi ndikaꞌan Jesús xiꞌin Ndioxi, ra saa ndakiꞌin ra kuaꞌan ra xiꞌin ndia itaꞌan xiꞌin ra, ra ndiyaꞌa ndia iin yuvi ña nani Cedrón. Ra saa ndixaa ndia, iin nuu iyoo itun kuiꞌi, ra ikan xikundee va ndia. ");
INSERT INTO mxv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ra ^xini tu ra Judas, ra ndixiko taꞌan xiꞌin Jesús va, nuu iyoo itun kuiꞌi kan, saa chi kuaꞌa ni va ichi ndixaꞌan Jesús xiꞌin ndia itaꞌan xiꞌin ra ikan. ");
INSERT INTO mxv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ra saa kuu, ra ndixaa va ra Judas xiꞌin kuaꞌa ni ndia soldado ñuu Roma, ra ndixaa tu ndia kumisio, ndia ndiaa veꞌe ñuꞌu kaꞌnu va, ra niꞌi ndia ichi xiꞌin itun, ra niꞌi tu ndia ñùꞌù ña tuun nuu va ndia; ra ndia kunaꞌnu nuu ndia sutu, xiꞌin ndia fariseo kuvi ndia, tiꞌvi ndia kumisio kan ndixaa ndia. ");
INSERT INTO mxv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ra xa kundaa va ini Jesús xaꞌa takundiꞌi tundoꞌo ña ndoꞌo ra, ra saa kuyachin ra nuu ndia ndixaa kan, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―¿Yoo kuvi na nanduku ndo? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ra saa ndakuiin ndia kachi ndia saa: ―Jesús ra ñuu Nazaret va kuvi ra nanduku ndi ―kachi ndia. Ra saa ndakuiin Jesús, kachi ra saa: ―Yuꞌu kuvi va ra ―kachi ra. Ra xa itaꞌan va ra Judas, ra ndixiko taꞌan xiꞌin Jesús, xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ra te ndikaꞌan Jesús xiꞌin ndia kachi ra saa: “Yuꞌu kuvi va ra”, kachi ra, saa ra iin ndiakua nandiko suꞌma ndia, ra nduva ndia, ndia nuu ñuꞌu. ");
INSERT INTO mxv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ra saa nindakatuꞌun tuku va Jesús ndia, kachi ra saa: ―¿Yoo kuvi na nanduku ndo? ―kachi ra. Ra saa ndakuiin ndia, kachi ndia saa: ―Jesús, ra ñuu Nazaret va kuvi ra nanduku ndi ―kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ra saa ndikaꞌan Jesús xiꞌin ndia kachi ra saa: ―Xa ndikaꞌan va yu xiꞌin ndo, chi yuꞌu kuvi va ra. Ra tu yuꞌu va kuvi ra nanduku ndo, saa ra na tïin vi ndo, ndia itaꞌan xiꞌin yu, chi na saña ndia kuꞌun va ndia ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ra suꞌva ke kuu, ña vaꞌa ndixinu nuu tuꞌun ña ndikaꞌan mii Jesús, te kachi ra suꞌva; “Na taxi kun ndaꞌa yu, Tata, ra ndia nii na ndisandoñüꞌu yu”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ra saa tava ra Simón Pedro ichi ña niꞌi ra, ra xaꞌndia ra soꞌo kuaꞌa iin tiaa ra nani Malco, ra ra xachiñu nuu sutu ra kuchee kuvi tiaa kan. ");
INSERT INTO mxv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Saa ndikaꞌan Jesús xiꞌin ra Pedro, kachi ra saa: ―Ndachikaa ichi kun, ini ñii nuu ndikaa ña. Saa chi tu xa Tata yu kuvi ra taxi ndiayu, ña ndoꞌo yu tundoꞌo yoꞌo, saa ra na ndoꞌo va yu ña ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ra ra kuchee xaꞌndia chiñu nuu ndia soldado ñuu Roma, xiꞌin takundiꞌi mii ndia soldado ra, xiꞌin ndia kumisio ndia tiꞌvi na judío kan ndixaa kuvi ndia tiin Jesús, ra katun ndia ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ra saa ndakundiaka ndia ra kuaꞌan ra xiꞌin ndia nuu ra Anás, ra kuu siso ra Caifás. Ra ra Caifás kan kuvi ra kuu sutu, ra kuchee nuu takundiꞌi ndia sutu kuiya kan. ");
INSERT INTO mxv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ra suvi mii ra Caifás kan kuvi ra ndikaꞌan xiꞌin na judío, ña vaꞌa ka va kita ña, ña na kuvi iin tiaa xaꞌa takundiꞌi na ñuu. ");
INSERT INTO mxv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ra ra Simón Pedro, xiꞌin inka ra itaꞌan xiꞌin Jesús, ra ndikun ndia kuaꞌan ndia sata ra. Ra ^xini taꞌan va iin ra kan xiꞌin ra sutu kuchee kan, ña kan ke vaꞌa ndikiꞌvi ra, ndia mii nuu keꞌe veꞌe ra sutu kuchee kan xiꞌin Jesús; ");
INSERT INTO mxv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ndi su ra Pedro, ra chi keꞌe va nindoo ra. Ra saa kanata ra itaꞌan xiꞌin Jesús, ra xinitaꞌan xiꞌin sutu ra kuchee kan, ra ndikaꞌan ra xiꞌin ñaꞌa ña ndiaa yeꞌe korra kan, ña na taxi ña yaꞌa ra Pedro chi ini. ");
INSERT INTO mxv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ra saa ndikaꞌan ñaꞌa ña ndiaa yeꞌe kan xiꞌin ra Pedro, kachi ña saa: ―¿A su taꞌan ndia itaꞌan xiꞌin tiaa yoꞌo, kuvi tu yoꞌo va? ―kachi ña. Ra saa ndakuiin ra Pedro, kachi ra saa: ―Üꞌun, süvi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ra ndia xachiñu nuu ndia sutu, xiꞌin ndia kuu kumisio ndiaa veꞌe ñuꞌu, ra ndakaꞌmi ndia ñuꞌu ndasaa ndia ndita ndia, saa chi vixin ni, ra ndichi tu ra Pedro va xiꞌin ndia ndasaa ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ra saa xaꞌa sutu ra kuchee kan, ndakatuꞌun ra Jesús xaꞌa ndia itaꞌan xiꞌin ra, ra saa tu xaꞌa ña sañaꞌa ra yuvi va. ");
INSERT INTO mxv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Köo iin ña ndikaꞌan seꞌe yu, saa chi takundiꞌi ichi ña ndixika yu sañaꞌa yu na ñuu yo Israel, ra veꞌe ñuꞌu naꞌnu xiꞌin veꞌe ñuꞌu vali va ndixika yu, ra nuu chitu kuaꞌa yuvi va sañaꞌa yu na. ");
INSERT INTO mxv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ra nichuun ke ndakatuꞌun kun yuꞌu? Ra vaꞌa ka va na ndakatuꞌun kun na xini soꞌo ña sañaꞌa va yu, saa chi na kan ra kundaa va ini na, ni ñaꞌa ke sañaꞌa yu na ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ra te ndikaꞌan Jesús tuꞌun yoꞌo, saa ra ndikun xakin va iin ra kumisio kan xaꞌndia nuu ra, ra ndikaꞌan ra kachi ra saa: ―¿Nichuun ndaa yuꞌu kun, sutu ra kuchee? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Tu väꞌa ndikaꞌan yu, saa ra kaꞌan xiꞌin yu ndia ña kuu ña väꞌa; ra tu mii ña ndaku va ke ndikaꞌan yu, saa ra, ¿nichuun kani kun yuꞌu? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ra saa ndatiꞌvi ra Anás kan Jesús kuaꞌan ra chi nuu ra Caifás, ra kuu sutu kuchee nuu takundiꞌi ndia sutu, ra nuꞌni va Jesús kuaꞌan ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ra nani saa kuu ra Pedro ndichi ra ndasaa ra xiꞌin ndia nuu xixi ñuꞌu kan, ra saa nindakatuꞌun na ra kachi na saa: ―¿A su ra itaꞌan xiꞌin tiaa yoꞌo, kuvi tu yoꞌo va? ―kachi na. Saa ra tiseꞌe tuꞌun tuku va ra xaꞌa Jesús, ra ndikaꞌan ra kachi ra saa: ―Üꞌun, süvi yu ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ra saa ndikaꞌan inka tuku tiaa ra xachiñu nuu sutu ra kuchee kan, ra kuu taꞌan ra xaꞌndia ra Pedro soꞌo kan, kachi ra saa: ―¿A su yoꞌo kuvi ra íin xiꞌin tiaa yoꞌo, xini yu nuu iyoo itun kuiꞌi kan? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Saa ra tiseꞌe tuꞌun tuku va ra Pedro xaꞌa Jesús, saa ra kana va chele. ");
INSERT INTO mxv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ra saa kee na veꞌe ra Caifás xiꞌin Jesús, ra ndakundiaka na ra kuaꞌan ra xiꞌin na chi yeꞌe chiñu kaꞌnu, nuu ndikaa ra chiñu kuchee, ra nani Pilato ra kee ñuu Roma. Ra nani saa kuu na, saa ra xa kuaꞌan tuvi va, ra ndixïin vi mii na judío kan kiꞌvi na ndia nuu keꞌe veꞌe chiñu kaꞌnu kan, saa chi tu köo ra kuyakua na ra küvi kuxini na viko pascua tuvi na. ");
INSERT INTO mxv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xaꞌa ña kan ke kita ra Pilato chi keꞌe, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―¿Ndia ña kuu kuachi xa tiaa yoꞌo, ña kan ke taxi ndo kuachi xaꞌa ra? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ra saa ndakuiin na kachi na saa xiꞌin ra: ―Tu köo kuachi tiaa yoꞌo, saa ra käꞌan vi ndi xiꞌin kun ña sayukun kun kuachi xiꞌin ra ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ra saa ndakuiin ra Pilato, kachi ra saa xiꞌin na: ―Ndakiꞌin ndo ra na kuꞌun ra xiꞌin ndo, ra na sandaku mii ndo kuachi xiꞌin va ra, ta kuꞌva kachi ndiayu ña iyoo ndaꞌa va ndo ―*kachi ra. Ra saa ndakuiin na kachi na saa: ―Nduꞌu, ra köo ndiayu ndaꞌa ndi ña kaꞌni ndi ndia nii yuvi na iyoo kuachi ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ra xiꞌin tuꞌun ña ndikaꞌan na yoꞌo kuvi ña ndixinu nuu tuꞌun ña ndikaꞌan Jesús, te ndikaꞌan ra ndia kuꞌva ke kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ra saa nandiꞌvi ra Pilato chi ini veꞌe chiñu kan, ra saa kana ra Jesús, ra ndindakatuꞌun ra ra kachi ra saa: ―¿A yoꞌo kuvi ra kuu rey na judío? ―kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―¿A mii kun kuvi ra kaꞌan tuꞌun ñaa xiꞌin yu, a inka yuvi va xini soꞌo kun ndikaꞌan ña? ―kachi Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ra saa ndakuiin ra Pilato, kachi ra saa: ―Süvi ra judío taꞌan kun kuvi yuꞌu. Chi mii na judío, xiꞌin ndia sutu kunaꞌnu nuu na ñuu va kun kuvi ndia ndataxi yoꞌo ndaꞌa yu. ¿Ra ndia ña ku kuachi xa kun? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Yuꞌu, ra süvi nuu ña yuuvi yoꞌo ke xaꞌndia yu chiñu; chi tu yoꞌo kuvi nuu xaꞌndia yu chiñu, saa ra na itaꞌan xiꞌin yu, ra kanitaꞌan va na xiꞌin na judío taꞌan yu xaꞌa yu. Ndi su süvi nuu ña yuuvi yoꞌo ke xaꞌndia yu chiñu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ra saa ndikaꞌan ra Pilato xiꞌin Jesús, kachi ra saa: ―¿Saa ra, rey kuvi ndixa va kun? ―*kachi ra. Ra saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Xa mii kun ndikaꞌan ña kuu yu rey va. Ra xaꞌa ña yoꞌo ke kaku va yu, ra xaꞌa ña yoꞌo ke, xaa tu yu ña yuuvi yoꞌo va, ña vaꞌa na kaꞌan yu xaꞌa ña ndaa xiꞌin na yuuvi. Ra takundiꞌi na kandixa ña ndaa, ra kandixa tu na tuꞌun ña ^kaꞌan yu xiꞌin va na ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ra saa ndikaꞌan ra Pilato kachi ra saa, xiꞌin Jesús: ―¿Ndia ña kuvi ña ndaa? ―kachi ra. Ra te ndiꞌi ndikaꞌan ra tuꞌun yoꞌo, saa kanata ra chi keꞌe ra ndikaꞌan ra xiꞌin na judío, kachi ra saa: ―Ndia nii kuachi tiaa yoꞌo köo ndaniꞌi yu. ");
INSERT INTO mxv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ndi su ndoꞌo, ra yunaꞌa va ndo ña saña ndika ndo iin tiaa ndia ñúꞌu veꞌe kàà ta kuiya, ta kuiya ña ndatava ndo viko pascua; ¿ra a kuni ndo tu na saña ndika yu, ra kuu rey nuu ndoꞌo na judío? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ra saa iin siso siso ndikaꞌan tuku va na, kachi na saa: ―¡Säña kun ra ñaa! ¡Chi na saña kun ra Barrabás va! ―*kachi na. Ra ra Barrabás kan, ra ra kuiꞌna va kuvi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ra saa xaꞌndia ra Pilato chiñu ña na kani na Jesús, xiꞌin ñii ndoꞌo ña ñuꞌu kàà nuu. ");
INSERT INTO mxv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ra saa xavaꞌa ndia soldado kan iin tivi ìñu̱ ña kuꞌun Jesús, ra saa chikaa ndia ña xini ra, ra sandakundixi ndia ra iin kapa ña kuaꞌa tuun. ");
INSERT INTO mxv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ra kaꞌan ndia xiꞌin ra kachi ndia saa: ―¡Kaꞌnu ni yoꞌo, ra kuu rey na judío! ―^kachi ndia. Saa ra xakin tu ndia xaꞌndia nuu va ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ra saa kanata tuku ra Pilato, ra ndikaꞌan ra xiꞌin na kachi ra saa: ―Kotoꞌni ndo, chi xa yoꞌo, xaa tiaa yoꞌo nuu ndo, ra na kundaa ini ndo, chi ndia nii kuachi ra köo ndaniꞌi yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ra saa kanata Jesús nuu na, ra xa ndikaa va iin tivi ìñu̱ xini ra, ra xa ndixi tu ra iin kapa ña kuaꞌa tuun va. Ra saa ndikaꞌan ra Pilato xiꞌin na, kachi ra saa: ―¡Kotoꞌni ndo, chi xa yoꞌo íin tiaa yoꞌo! ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Saa ra te xini ndia kunaꞌnu nuu ndia sutu xiꞌin ndia kuu kumisio ndiaa veꞌe ñuꞌu kaꞌnu kan Jesús, ra saa xaꞌa ndia iin kokoꞌo ndaꞌyu ndia, kachi ndia saa: ―¡Takaa ra ndaꞌa cruz! ¡Takaa ra ndaꞌa cruz! ―^kachi ndia. Ra saa ndikaꞌan ra Pilato xiꞌin ndia kachi ra saa: ―Ndakiꞌin ndoꞌo ra, ra takaa ndo ra ndaꞌa cruz, saa chi köo kuachi ra ndaniꞌi yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ra saa ndakuiin ndia judío kunaꞌnu kan kachi ndia saa xiꞌin ra: ―Nduꞌu, ra kuu mii ndi iin ndiayu, ra ta kuꞌva kachi mii ndiayu ndi ke xiniñuꞌu kuvi va ra, saa chi kaꞌan ra, ña kuu ra seꞌe Ndioxi ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ndi su ta xini soꞌo ra Pilato ña ndikaꞌan ndia tuꞌun yoꞌo, saa ra ndiyuꞌvi vaꞌa ka va ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ra saa nandiꞌvi tuku ra chi ini veꞌe chiñu, ra ndikaꞌan ra xiꞌin Jesús kachi ra saa: ―¿Ndia mii kuu ñuu kun? ―*kachi ra. Ndi su ndia nii tuꞌun nindäkuiin Jesús yuꞌu vi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ra saa ndikaꞌan ra Pilato xiꞌin Jesús, kachi ra saa: ―¿Nichuun ndakuïin kun yuꞌu yu? ¿A kundäa ini kun ña iyoo ndiayu ndaꞌa yu ña takaa yu yoꞌo ndaꞌa cruz, ra iyoo tu ndiayu ndaꞌa yu ña saña ndika yu yoꞌo va? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Ndia nii chiñu küvi kaꞌndia kun xaꞌa yu, tu süvi Ndioxi nditaxi ndiayu ndaꞌa kun; ndi su tiaa ra ndataxi yuꞌu ndaꞌa kun, ra chee ni ka va kuachi ra kan ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ra saa xaꞌa ndiꞌi vaꞌa ka va ini ra Pilato, ña kuni ra saña ra Jesús; ndi su ndia judío, ra ndia ndiee ka ndaꞌyu va kuvi ndia, kachi ndia saa: ―¡Tu na saña kun tiaa ñaa, saa ra kuëe itaꞌan mani vi kun xiꞌin ra tata chiñu César! ¡Saa chi takundiꞌi na kuni kuu rey, ra xiꞌin ra kan va ke kiꞌvi na kuachi! ―^kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ra te xini soꞌo ra Pilato tuꞌun ña kaꞌan ndia, ra saa tava ra Jesús chi keꞌe, ra ndakunduꞌu ra nuu tiayu kaꞌnu, tu íin nuu keꞌe veꞌe chiñu kaꞌnu kan, ra Gabata ke nani yuu savi ña chikaa na nuu ñuꞌu nuu iin tiayu kan, ra tuꞌun Gabata ra tuꞌun hebreo va kuvi ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ra mii kaꞌñu kii ña xaꞌa na xa nduvi na ña ndatava na viko pascua ke ndikaꞌan ra Pilato xiꞌin na judío kan, kachi ra saa: ―¡Yoꞌo, íin ra kuu rey ndo! ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ndi su ndia kan ra ndia ndiee ka ndaꞌyu va kuvi ndia, kachi ndia saa: ―¡Tava ra! ¡Tava ra! Na kuꞌun ra kutakaa ra ndaꞌa cruz ―kachi ndia. Ra saa ndikaꞌan ra Pilato xiꞌin ndia, kachi ra saa: ―¿A kuni ndo, ña katakaa yu ra kuu rey ndo ndaꞌa cruz? ―*kachi ra. Ra saa ndakuiin ndia kunaꞌnu nuu ndia sutu kan, kachi ndia saa: ―Nduꞌu, ra köo inka rey nuu ndi, chi xa iyoo va ra César ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndia saa ra ndataxi ra Pilato Jesús ndaꞌa va ndia, ra saa ndakundiaka ndia soldado kan Jesús kuaꞌan ra xiꞌin ndia, ña katakaa ndia ra ndaꞌa cruz va. ");
INSERT INTO mxv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ra saa kanata Jesús nuu ñuu Jerusalén kan, ra kasoko ra cruz ra kuaꞌan ra xiꞌin ndia iin nuu nani leke xini ndii, ra Gólgota ke kachi tuꞌun yoꞌo, tuꞌun hebreo. ");
INSERT INTO mxv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ra ikan katakaa ndia ra ndaꞌa cruz, ra katakaa tu ndia, inka uvi tiaa va xiꞌin ra; ra iin ndia katakaa ndia ndaꞌa cruz tu ndichi xiin ra xixiyo, ra tun íin maꞌñu, katakaa ndia mii Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ra saa xaꞌndia ra Pilato chiñu ña na tiaa ndia nuu iin vitu loꞌo, ra chinduꞌu ndia ndia nu xini cruz, tu takaa Jesús ndaꞌa, ra suꞌva ke kachi tuꞌun ña tiaa ndia nuu nu: “Jesús ra ñuu Nazaret, ra kuu rey na judío”, kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ra kuaꞌa ni va mii na judío kaꞌvi tuꞌun yoꞌo, saa chi nuu katakaa na Jesús, ra yachin nuu ñuu va kuvi ña, ra uni nuu tuꞌun ke tiaa ndia nuu vitu loꞌo kan: tuꞌun hebreo, xiꞌin tuꞌun griego, xiꞌin tuꞌun latin. ");
INSERT INTO mxv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ra saa ndikaꞌan ndia sutu kunaꞌnu nuu na judío xiꞌin ra Pilato, kachi ndia saa: ―Tata, na käꞌan tuꞌun ñaa “rey na judío”; chi vaꞌa ka va na chinduꞌu kun, “ra yoꞌo ku ra kaꞌan ku rey na judío” ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Saa ndakuiin ra Pilato yuꞌu ndia, kachi ra saa: ―Tuꞌun ña tiaa yu, ra xa ña tiaa yu kuvi va ña ―kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ra te ndiꞌi katakaa ndia soldado kan Jesús ndaꞌa cruz, ra saa ndakiꞌin ndia tikoto ra, ra ndataꞌvi ndia ña kumi ñaꞌñu, ra kumi kuvi ndia, ra iin iin ñaꞌñu ndakiꞌin va ndia. Ra saa ndakiꞌin tu ndia tikoto kani ña xindikaa tixi tikoto va ra, ra tikoto kan, ra köo tiku ña chi iin kuu yuꞌu ña ra iin saa ndia sukun va ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ra saa ndikaꞌan ndia soldado kan xiꞌin taꞌan ndia, kachi ndia saa: ―Na ndäta yo ña, chi vaꞌa ka va na keꞌe taꞌan yo xaꞌa ña, ra kuni yo yoo kuvi yo kuchuun ndakiꞌin ña, ―kachi ndia. Ra suꞌva va ke kuu ña vaꞌa ndixinu nuu tuꞌun Ndioxi ña kaꞌan kachi suꞌva: “*Ndataꞌvi na tikoto yu xiꞌin taꞌan na, ra keꞌe taꞌan tu na xaꞌa va ña”, kachi ña. Ra mii saa ndixa ke xa va ndia soldado kan. ");
INSERT INTO mxv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ra yachin nuu iin cruz, nuu takaa Jesús ndichi siꞌi ra xiꞌin kuꞌvi ña, ra saa tu ña María yasiꞌi ra Cleofas, xiꞌin ña María Magdalena va. ");
INSERT INTO mxv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ra te xini Jesús siꞌi ra xiꞌin ra itaꞌan xiꞌin ra, ra kuꞌvi vaꞌa ini ra xini ra, ña ndita yachin na kan, ra saa ndikaꞌan ra xiꞌin siꞌi ra, kachi ra saa: ―Nana, ñaa va ndichi seꞌe kun ―*kachi ra xiꞌin ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ra te ndiꞌi, saa ndikaꞌan tu ra xiꞌin ra itaꞌan xiꞌin va ra, kachi ra saa: ―Ñaa ndichi siꞌi kun ―*kachi ra. Ra mii kii kan kuanuꞌu va siꞌi Jesús, xiꞌin ra itaꞌan xiꞌin ra veꞌe ra ña kondiaa ra ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ra te ndiꞌi kuu ña yoꞌo, ra xa kundaa va ini Jesús, ña xa ndixinu nuu takundiꞌi va chiñu xa ra, ra saa ndikaꞌan ra, kachi ra saa: ―Ichi ni ini yu ―*kachi ra. Ra tuꞌun yoꞌo ke ndikaꞌan ra, ña vaꞌa na xinu nuu tuꞌun Ndioxi ña kaꞌan xaꞌa ra, ndia te yachi vi. ");
INSERT INTO mxv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ra yachin kan va ndichi iin xikoꞌo ña ñuꞌu ndutia iyá; ra saa chindaxi ndia soldado kan, iin koꞌndo chaꞌma, ra chinduꞌu ndia ña xini iin itun, ra satandiaa ndia ña yuꞌu ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ra te ndiꞌi xiꞌi Jesús ndutia iyá kan, ra saa ndikaꞌan ra, kachi ra saa: ―Xa saxinu yu nuu takundiꞌi va chiñu ―*kachi ra. Ndia saa ra nduviko sukun ra, ra ndixiꞌi va ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ra mii kii ña kana viko pascua kan ke, xa xaꞌa tu na xanduvi na ña ndakindiee na kii yii, ra ndiküni ndia judío ña kutakaa ka ndia, katakaa ndia ndaꞌa cruz kii kan, ña kan ke ndixaꞌan ndia ndikaꞌan ndia xiꞌin ra Pilato, ña na kaꞌnu ra siꞌin ndia takaa ndaꞌa cruz, ra kama na kuvi ndia, ra vaꞌa nuu iki kuñu ndia ndaꞌa cruz. ");
INSERT INTO mxv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ra saa kee ndia soldado kan ndixaꞌan ndia ndixaꞌnu ndia siꞌin iin ra takaa xiin Jesús, ra saa ndixaꞌnu tu ndia siꞌin ra takaa chi inka xiyo va. ");
INSERT INTO mxv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ra saa kuyachin tu ndia soldado kan nuu tanii Jesús, ra xa ndixiꞌi va ra xini ndia, ndia saa ra ndixäꞌnu ka vi ndia siꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ra saa tuvi iin ndia soldado kan kàà ndiko nuu kindika Jesús, ra kee nii, ra kee tu tiakuii va kindika ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ra ra ^ndakani xaꞌa ña yoꞌo, ra ña xini nuu ra kuu va, kuvi ña ndatuꞌun ra xaꞌa, ra ña ndaa ni va kuvi ña, saa chi mii ra kuvi ra kundaa ini, ña ^kuu ña ña ndaa va; ra ña kan ke xiniñuꞌu na kandixa tu ndoꞌo va ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ra suꞌva ke kuu, ña vaꞌa ndixinu nuu tuꞌun Ndioxi ña kaꞌan kachi suꞌva: “Ndia nii iki ra käꞌnu na”, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ra ndixinu tu nuu tuꞌun Ndioxi ña kaꞌan kachi suꞌva va: “Kuni na, iin tiaa ña tuvi na kàà kindika ra”, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ra te ndiꞌi kuu takundiꞌi ña yoꞌo, ra saa ndixaꞌan ra José ra ñuu Arimatea, nduku ra ndiayu nuu ra Pilato, ña na ndataxi ra iki kuñu Jesús ndaꞌa ra, ra nduxin ra ña, ra ra xitaꞌan xiꞌin Jesús kuvi tu ra José kan va, ndi su xitaꞌan seꞌe va ra xiꞌin Jesús, saa chi ndiyuꞌvi va ra nuu na judío, ra saa taxi ra Pilato ndiayu ndaꞌa ra, ra saa ndixaꞌan ra ndakiꞌin ra iki kuñu Jesús, kuaꞌan ña xiꞌin va ra. ");
INSERT INTO mxv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ra saa ndixaa tu ra Nicodemo ra ndixaꞌan ndatuꞌun xiꞌin Jesús, iin ñuu te yachi va, ra niꞌi ra kuꞌva oko uxi kilo ichi xaꞌan tami, ña ndikava nuu, xuxa itun tu nani mirra xiꞌin, ra saa tu ichi itun, tu nani áloes va. ");
INSERT INTO mxv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ra saa ndakutaꞌan ra José xiꞌin ra Nicodemo, ra ndakiꞌin ndia iki kuñu Jesús, ra chikaa ndia ichi ña xaꞌan tami sata ña, ra ndasuvi ndia ña iin tikoto kani, chi xa saa yunaꞌa va na judío kan, xa na xiꞌin taꞌan na te nduxin na na. ");
INSERT INTO mxv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ra mii nuu katakaa na Jesús ndaꞌa cruz ke, ndikaa iin yoso nuu iyoo itun kuiꞌi, ra nuu iyoo itun kuiꞌi kan ke, ndichi iin yavi xaa ña täan kundikaa ndia nii, ndii ini. ");
INSERT INTO mxv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Saa ra ndia ini yavi kan va, chikaa ndia iki kuñu Jesús, saa chi xa ninumi ni va, xaꞌa kii ña ndakindiee na judío. ");
INSERT INTO mxv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ra ñaꞌa ni domingo, kii ña kiꞌin xaꞌa semana te kumani ka kana kuaꞌa xaꞌa ndivi, ke kee ña María, ña kee ñuu Magdala ndixaꞌan ña xitoꞌni ña, yuꞌu yavi nuu chikaa na iki kuñu Jesús. Ra te ndixaa ña, ra xa ndixikutiaꞌa va yuu chee ña ndasi yuꞌu yavi kan xini ña. ");
INSERT INTO mxv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ra saa nandiko ña, ra xinu ña ndixaꞌan ña ndatuꞌun ña xiꞌin ra Simón Pedro ra xitaꞌan xiꞌin Jesús, ra saa tu xiꞌin inka ra xitaꞌan xiꞌin Jesús ra kuꞌvi ni ini ra xini va ra, ra kachi ña saa xiꞌin ndia: ―Ndixaꞌan va na ndatava na iki kuñu Tata yo ini yavi kan, ra kundäa ini yo, ndia mii ndixaꞌan na ndiaka na ña ―*kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ra saa ndakiꞌin ra Pedro xiꞌin inka ra xitaꞌan xiꞌin Jesús kan kuaꞌan ndia kutoꞌni ndia ini yavi kan. ");
INSERT INTO mxv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ra xinu uvi saa va ndia kuaꞌan ndia; ndi su ndiee ni ka va xinu inka ra xitaꞌan xiꞌin Jesús kan, nuu ra Pedro, ra ra kan kuvi ra, kama ka ndixaa va yuꞌu yavi kan. ");
INSERT INTO mxv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ra saa ndakandiee ra xitoꞌni ra ini yavi kan, ra ndia tikoto ña xisukun va Jesús ke ndee xini ra, ndi su ndikïꞌvi vi ra ini yavi kan. ");
INSERT INTO mxv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ra saa ndikun tu ra Simón Pedro va ndixaa ra yuꞌu yavi kan, saa ra ndikun ndikiꞌvi ra ini yavi kan kuaꞌan va ra, ra ndia tikoto va ke ndee xini tu ra kan va; ");
INSERT INTO mxv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ra xini tu ra tikoto ña xisuvi xini Jesús va ndee ña, ndi su xa vivii va ndataꞌnu ña, ra xa ndee siin va ña. ");
INSERT INTO mxv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Saa ra ndikiꞌvi tu ra xitaꞌan xiꞌin Jesús, ra inuu ndixaa yuꞌu yavi kan va, ra xini ra ña kuu kan, saa ra kandixa va ra ña ndatiaku Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ra ta kumani ka kuꞌun ndia nuu iin yavi kan, ra täan kundaa kaxi vi ini ndia xiꞌin tuꞌun Ndioxi, ña kaꞌan xaꞌa Jesús, ña xiniñuꞌu ndatiaku ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ndia saa ra nandiko ndia xitaꞌan xiꞌin Jesús, kuanuꞌu ndia veꞌe va ndia. ");
INSERT INTO mxv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ra ña María nindoo yuꞌu yavi chi keꞌe, xaku va ña, ra nani saa kuu ña xaku ña, ra saa ndakandiee ña xitoꞌni ña ini yavi kan. ");
INSERT INTO mxv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Saa ra xini va ña uvi ndia tatun Ndioxi, ndia ndixi tikoto yaa, ra iin ra nduꞌu chi nuu xikanduꞌu xini Jesús, ra inka tu ra nduꞌu chi nuu ndixiyo xaꞌa va ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ra saa nindakatuꞌun ndia ña, kachi ndia saa: ―¿Nichuun xaku kun, Nana? ―kachi ndia xiꞌin ña. Ra saa ndakuiin ña, kachi ña saa: ―Tata va yu kuvi ra ndakiꞌin na kuaꞌan xiꞌin na, ra kundäa ini yu, ndia mii ku nuu chikaa na ra ―*kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ra sakan saa kuu ña kaꞌan ña, ra saa ndikokuiin ña ndakutoꞌni ña, ra xini ña íin Jesús ikan, ndi su nindäkuni ña ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ra saa nindakatuꞌun Jesús ña kachi ra saa: ―¿Nichuun xaku kun, Nana? ¿Ra yoo kuvi na nanduku kun? ―*kachi ra xiꞌin ña. Ra vaꞌa ra ndiaa itun kuiꞌi kan va kuvi ra ndikaꞌan xiꞌin ña káꞌán ña, ra saa ndikaꞌan ña kachi ña saa xiꞌin ra: ―Tata, tu yoꞌo va kuvi ra kuaꞌan ra xiꞌin, ra na ndatuꞌun va kun xiꞌin yu ndia mii ku nuu chikaa kun ra, ra vaꞌa kuꞌun yu ndakiꞌin yu ra kuꞌun ra xiꞌin yu ―*kachi ña. ");
INSERT INTO mxv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Saa ra ndikaꞌan va Jesús xiꞌin ña, kachi ra saa: ―¡María! ―*kachi ra. Ra saa ndikokuiin ña ndakutoꞌni ña nuu ra, ra ndikaꞌan ña tuꞌun hebreo xiꞌin ra, kachi ña saa: ―¡Raboni! ―ra Maestro ke kachi tuꞌun yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ra saa ndikaꞌan Jesús xiꞌin ña kachi ra saa: ―Saña yuꞌu, ra ndïꞌi ini kun chi íin ka va yu xiꞌin ndo, saa chi kuni ka va kunuꞌu yu nu Tata yu. Ra ña xiniñuꞌu sa kun ke, na kuꞌun kun ndatuꞌun kun xiꞌin ndia ñani yu, saa chi kuꞌun va yu nuu Tata yu, ra Tata tu ndoꞌo va kuvi ra, ra kuu ra Ndioxi yu, ra Ndioxi tu ndoꞌo va kuvi ra ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ra saa ndixaꞌan ña María, ña ñuu Magdala ndatuꞌun ña xiꞌin ndia xitaꞌan xiꞌin Jesús, ña xa xini va ña ra, ra ndikaꞌan ra tuꞌun kan xiꞌin ña, kachi ña xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ra te xa kuñuu suvi mii kii, ña kiꞌin xaꞌa semana kan ke, ndakutaꞌan takundiꞌi ndia xitaꞌan xiꞌin Jesús ndee ndia, ra ndasi tuun va yeꞌe veꞌe nuu ndee ndia, xaꞌa ña iyuꞌvi ndia nuu na judío taꞌan ndia. Ra saa xaa Jesús veꞌe nu ndee ndia, ra xikundichi ra mañu ndia, ra ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Ña vaꞌa, na koo xiꞌin ndo ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ra te ndiꞌi ndikaꞌan ra tuꞌun yoꞌo xiꞌin ndia xitaꞌan xiꞌin ra, ra saa ndiñaꞌa ra ndaꞌa ra xiꞌin kindika ra nuu ndia. Ra kusii ka vi ini ndia, te xini ndia ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ra saa ndikaꞌan tuku Jesús xiꞌin ndia, kachi ra saa: ―Ña vaꞌa na koo xiꞌin ndo. Ra ta kuꞌva xa Tata yu Ndioxi ña tiꞌvi ra yuꞌu xaa yu yoꞌo, ra saa ke ^xa tu yuꞌu va, ña tiꞌvi yu ndoꞌo kuꞌun ndo vichin ―*kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo, ra saa tivi ra tachi yuꞌu ra, chi nuu ndita ndia ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ndakiꞌin ndo Tachi Yii Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ra yuvi na sakaꞌnu ini ndo xaꞌa kuachi, ra sakaꞌnu tu ini Ndioxi va xaꞌa kuachi na; ra tu na köo kaꞌnu ini ndo xaꞌa kuachi na, saa ra köo kaꞌnu tu ini Ndioxi va xaꞌa kuachi na ―*kachi ra xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ndi su ra Tomás, ra kaꞌan na kuu kuati, ra xitaꞌan xiꞌin ndia xitaꞌan xiꞌin Jesús, ña xikuu ndia uxi uvi, ra köo ra ndixiyo xiꞌin ndia te ndixaa Jesús nuu ndia. ");
INSERT INTO mxv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ra saa ndikaꞌan ndia sava, ndia xitaꞌan xiꞌin Jesús xiꞌin ra, kachi ndia saa: ―*Xini va ndi, tata yo Jesús ―*kachi ndia. Ra saa ndakuiin ra kachi ra saa, xiꞌin ndia: ―Tu na küni yu, ndaꞌa ra nuu ñaꞌa ndiñani clavo, ra tüvi yu, nduku ndaꞌa yu yavi nuu xindoꞌni ña, ra tüvi tu yu ndaꞌa yu, kindika ra nuu kaan na yavi, saa ra kandïxa vi yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ra saa kuu ndiyaꞌa una kii, ra ndakutaꞌan tuku va ndia xitaꞌan xiꞌin Jesús ndee ndia iin veꞌe, ra xa nduꞌu va ra Tomás xiꞌin ndia. Ra kutu ka vi ndasi yeꞌe veꞌe kan ndee ndia, ndi su ndikiꞌvi va Jesús, ra xikundichi ra maꞌñu ndia, ra ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ña vaꞌa, na koo xiꞌin ndo ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ra saa ndikaꞌan ra xiꞌin ra Tomás, kachi ra saa: ―Kuyachin, ra tuvi kun nduku ndaꞌa kun, yavi nu xindoꞌni clavo ndaꞌa yu, ra kuni kun, ra na tuvi tu kun, ndaꞌa kun kindika yu nuu kaan va na; ra na küu kun tiaa ra xïin kandixa, chi vaꞌa ka va na kuu kun iin tiaa ra kandixa ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Saa ndikaꞌan ra Tomás, kachi ra saa: ―¡Tata mii yu, Ndioxi mii yu kuvi yoꞌo! ―kachi ra xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Saa ndikaꞌan Jesús xiꞌin ra, kachi ra saa: ―Tomás, ña xini kun yuꞌu va ke ^kandixa kun. Ndi su vaꞌa ni ka va kee yuvi na küni yuꞌu, ra kandixa na yuꞌu ―kachi ra xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ra kuaꞌa ni ka va ña xituꞌun xa Jesús, xini ndia xitaꞌan xiꞌin ra, ra ndikäꞌyu ndiꞌi vi ña nuu tutu yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ndi su ndikaꞌyu va tu sava ña xituꞌun ña xa ra, nuu tutu yoꞌo, ña kan ke vaꞌa na kandixa ndo Jesús, ña kuu ra, ra ndikaxin Ndioxi sakaku na yuuvi yoꞌo, ra ra yoꞌo kuvi seꞌe Ndioxi va, ra na ^kandixa ñaꞌa, ra niꞌi va na ña kutiaku xiꞌin ra, ndia ndikaa ndikuꞌun. ");
INSERT INTO mxv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ra te ndiꞌi kuu takundiꞌi ña yoꞌo, saa ndita tuku va Jesús nuu ndia xitaꞌan xiꞌin ra, chi nuu ndikaa mini ra nani Tiberias. Ra suꞌva ke xa ra te ndita ra nuu ndia: ");
INSERT INTO mxv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ra saa kuu ra Simón Pedro, nduꞌu ra xiꞌin ra Tomás, ra kaꞌan na kuu kuati, xiꞌin ra Natanael, ra ñuu Caná ña ndikun ndiaa chi Galilea, xiꞌin ndia seꞌe ra Zebedeo, xiꞌin inka uvi ndia xitaꞌan xiꞌin Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ra saa ndikaꞌan ra Simón Pedro, xiꞌin ndia kachi ra saa: ―Na kuꞌun yu kachiꞌi yu ―kachi ra. Ra saa ndakuiin ndia, kachi ndia saa: ―Kuꞌun va ndi xiꞌin kun ―kachi ndia xiꞌin ra. Ra saa kee ndia ndixaꞌan ndia nandaa ndia itun xika nuu mini, ndi su ñuú kan, ra iin niñuu ndaa va ndixika ndia, ndi su ndia nii tiaka ndinïꞌi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ra te xa kuaꞌan tuvi, saa ndixaa Jesús yuꞌu tiakuii kan, ra ndia xitaꞌan xiꞌin ra, ra nindäkuni vi ndia ra ña kuu ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ra saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Ndia kuachi, ¿a täan tiin ndo loꞌo tiaka kaxi yo? ―*kachi ra. Ra saa ndakuiin ndia, kachi ndia saa: ―Köo vaꞌa vi ri ―*kachi ndia. ");
INSERT INTO mxv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Saa ndikaꞌan ra xiꞌin ndia, kachi ra saa: ―Sakoꞌni ndo inu ndo, chi xiin kuaꞌa itun ñaa, ra niꞌi va ndo ri ―*kachi ra. Ra saa sakoꞌni ndixa va ndia inu ndia, ra tiaa ni va kuaꞌa tiaka sakakuꞌun ña, ra nii ndikundiëe ndia tava ndia ña, ini tiakuii kan. ");
INSERT INTO mxv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Saa ra ndikaꞌan va iin ra xitaꞌan xiꞌin Jesús, ra kuꞌvi ni ra xini ra, kachi ra saa xiꞌin ra Pedro: ―¡Tata yo Jesús va kuvi ra! ―*kachi ra. Ra ta xini soꞌo ra Simón Pedro tuꞌun kan, saa ra ndikun ndakundixi va ra tikoto ra, ra ndava niꞌni ra ini tiakuii kan kuaꞌan ra ndakitaꞌan ra xiꞌin Jesús va. ");
INSERT INTO mxv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ra ndia sava kan nindoo vaxi xiꞌin itun kan va, ra ndia kañuꞌu va ndia inu ndia vaxi ndia, saa chi iin chitu ndaa va ña xiꞌin tiaka; ra kuꞌva iin ciento metro ka vi ke kumani, ra saa ndakoyo ndia yuꞌu mini kan. ");
INSERT INTO mxv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ra te nuu suꞌva ndia itun kan, ra saa xini ndia ña vaꞌa ka vi ninduꞌva tikayu ñùꞌù, ra xa nduꞌu va iin tiaka yatan ri nuu ña, ra saa tu xita va. ");
INSERT INTO mxv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Kuaꞌan kiꞌin ndo, tiaka ri sakan tava ndo ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ra saa nandaa ra Pedro ini itun kan, ra saa kañuꞌu ra inu kan; ra kita ra xiꞌin ña ndia chi nuu ichi. Ra iin chitu ndaa ña xiꞌin tiaka kan, ra naꞌnu ka vi ri, ra saa ndakaꞌvi ndia ri, ra iin ciento uvi xiko uxi uni vi kuvi ri, ra vaꞌa ni vee ni va ri, ndi su nindäta vi inu kan xiꞌin ri. ");
INSERT INTO mxv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ra saa ndikaꞌan Jesús xiꞌin ndia, kachi ra saa: ―Naꞌa ndo, ra kasini ndo ―*kachi ra. Ra ndia nii ndia xitaꞌan xiꞌin Jesús, ndixändiee ini ña ndakatuꞌun ndia yoo kuvi ra, saa chi xa kundaa va ini ndia, ña kuu ra Jesús. ");
INSERT INTO mxv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ra saa kiꞌin Jesús xita, ra taxi ra ña ndaꞌa ndia, ra saa tu tiaka va. ");
INSERT INTO mxv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ra xa ichi uni va ke ^ndita Jesús nuu ndia xitaꞌan xiꞌin ra, ña ndatiaku ra vichin. ");
INSERT INTO mxv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ra te ndiꞌi sasini ndia, ra saa nindakatuꞌun Jesús ra Simón Pedro, kachi ra saa: ―Simón, seꞌe ra Jonás, ¿a kuꞌvi ni ka ini kun xini kun yuꞌu, nuu ndia sava yoꞌo? ―*kachi ra. Ra saa ndakuiin ra Pedro, kachi ra saa: ―Tata, xa kundaa ini mii va kun, ña kuꞌvi ni va ini yu, xini yu yoꞌo ―*kachi ra. Ra saa ndikaꞌan Jesús, kachi ra saa xiꞌin ra: ―Saa ra kondiaa ndikachi vali sana yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ra saa nindakatuꞌun tuku va Jesús ra Pedro, ichi ña uvi, kachi ra saa xiꞌin ra: ―Simón, seꞌe ra Jonás, ¿a kuꞌvi ni ini kun xini kun yuꞌu? ―*kachi ra. Ra saa ndakuiin ra Pedro, kachi ra saa: ―Kuꞌvi va ini yu xini yu yoꞌo, Tata, ra xa kundaa tu ini mii va kun, ña kuꞌvi ni ini yu xini yu yoꞌo ―*kachi ra. Ra saa ndikaꞌan Jesús xiꞌin ra, kachi ra saa: ―Saa ra na kondiaa va kun ndikachi vali sana yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Saa ra nindakatuꞌun tuku va Jesús ra Pedro, ichi ña uni, kachi ra saa xiꞌin ra: ―Simón, seꞌe ra Jonás, ¿a kuꞌvi ni ini kun xini kun yuꞌu? ―*kachi ra. Saa ra kusuchi va ini ra Pedro, ña xa ndixinu uni ichi ndakatuꞌun Jesús ra, xaꞌa ña, a kuꞌvi ini ra xini ra ra. Ra saa ndakuiin ra, kachi ra saa: ―Tata, mii kun kuvi ra kundaa ini xaꞌa takundiꞌi va ña, ra kundaa va ini kun, ña kuꞌvi ni va ini yu xini yu yoꞌo ―*kachi ra xiꞌin Jesús. Ra saa ndikaꞌan Jesús xiꞌin ra, kachi ra saa: ―Saa ra kondiaa ndikachi vali sana yu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Saa ndikaꞌan ka Jesús xiꞌin ra Pedro, kachi ra saa: ―Ña ndixa ke kaꞌan yu xiꞌin kun: chi te ndixiyo itia kun, ra vaꞌa ndakundixi mii va kun tikoto kun, ra ndixika kun chi nuu kuni mii va kun, ndi su te xa na kutoꞌo kun, ra ndia ndaꞌa va kun sandakaa kun, ra inka va na sandakundixi tikoto yoꞌo, ra kundiaka na yoꞌo, kuꞌun kun nuu küni kun kuꞌun va kun ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ña yoꞌo ke ndikaꞌan Jesús xiꞌin ra Pedro, ña vaꞌa na kundaa ini ra, ndia kuꞌva ke kaꞌni na ra, ra xiꞌin ña kuvi ra ke ndasakaꞌnu ni ka va ra Ndioxi. Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo, ra saa ndikaꞌan ka ra xiꞌin ra Pedro, kachi ra saa: ―Kundikun yuꞌu ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ra te ndikokuiin ra Pedro ndakutoꞌni ra, ra saa xini ra ndikun ra xitaꞌan xiꞌin Jesús, ra kuꞌvi ni ini ra xini ra, kuaꞌan ra sata ndia. Ra ra yoꞌo kuvi tu ra nindakatuꞌun Jesús, te xindee ndia xixini va ndia, ta kachi ra suꞌva: “¿Yoo ku na ndataxi yoꞌo, ndaꞌa na saa ini, Tata?” ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ra saa ndikaꞌan ra Pedro kachi ra saa, xiꞌin Jesús: ―Tata, ¿ni ke ndoꞌo tu ra yoꞌo? ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Saa ndakuiin Jesús, kachi ra saa xiꞌin ra: ―Tu kuni yu kutiaku ra, ra kutiaku va ra, ndia kii te na ndiko yu kixi tuku yu ña yuuvi yoꞌo va, ¿ra ni ke ndoꞌo yoꞌo ndiꞌi ini kun? Na kundikun yuꞌu va ―*kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ra xaꞌa ña kan ke, ndindutia ndoso tuꞌun nuu takundiꞌi na ndikun sata Jesús, ña küvi ra xitaꞌan xiꞌin Jesús yoꞌo. Ndi su ndikäꞌan Jesús ña küvi ra, chi suꞌva va ke kachi Jesús: “Tu kuni yu kutiaku ra, ra kutiaku va ra, ndia te na ndiko tuku yu kixi yu ña yuuvi yoꞌo va, ¿ra ni ke ndoꞌo yoꞌo, ndiꞌi ini kun?”, kachi ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ra mii ra xitaꞌan xiꞌin Jesús yoꞌo, kuvi ra ndakuiin va xaꞌa ña yoꞌo, ra suvi mii ra kuvi tu ra tiaa va ña. Ra kundaa va ini ndi, chi mii ña ndaa va ke kaꞌan ra. ");
INSERT INTO mxv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ra iyoo kuaꞌa ni ka va ña xa Jesús, ra tu ta iin, ta iin ña nditiaa na, saa ra kïta vi nuu iinii saa ña yuuvi yoꞌo, kundee tutu ña tiaa na. Saa iyoo va ña.");
INSERT INTO mxv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tata Teófilo, nuu tutu ña tiꞌvi yu ndi̱xa̱a̱ ndaꞌa kun ke ^ndakani yu nuu kun xaꞌa takundiꞌi ña xa Jesús xiꞌin ña sañaꞌa ra te sakan xaꞌa suꞌva ra xiꞌin chiñu ra, ");
INSERT INTO mxv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ra iin saa ndia kii te ndakuita ra kuanuꞌu ra ndiví va. Ra te kuni ka kunuꞌu ra ndivi ke xiniñuꞌu ra Tachi Yii ra ña ndakoo ra ndiayu ndaꞌa ndia ndikaxin ra. ");
INSERT INTO mxv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ra suvi nuu mii ndia kan ke ndita ra kuaꞌa ni ichi, ña vaꞌa na kundaa ini ndia ña ndixa ke ndatiaku va ra. Ra uvi xiko ka kii ke ndixika ra ndakani ka ra nuu ndia xaꞌa ichi nuu ^xaꞌndia Ndioxi chiñu. ");
INSERT INTO mxv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ra saa kuu iin kii ndakutaꞌan takundiꞌi ndia xitaꞌan xiꞌin Jesús ndee ndia xiꞌin ra, ra saa ndikaꞌan ra xiꞌin ndia kachi ra saa: ―Këe yachi ndo kuꞌun ndo inka ñuu; chi takua mii ñuu Jerusalén yoꞌo va ke, na kundee ndo kundiatu ndo ña saxinu Iva yu Ndioxi ña ndikaꞌan ra xaꞌa, ra ndikaꞌan tu yuꞌu va xaꞌa ña xiꞌin ndo. ");
INSERT INTO mxv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ra ña ndixa ke chi ra Juan, ra xiꞌin tiakuii va sakuchi ra na yuvi, ndi su ndoꞌo, ra xiꞌin Tachi Yii Ndioxi va ke ndakuchi ndo soo ndiaꞌvi kii vichin ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ra saa kuu iin kii nindakatuꞌun ndia ndakutaꞌan ndee kan Jesús kachi ndia saa xiꞌin ra: ―Tata, ¿a ndia vichin ke ndi̱xa̱a̱ tiempo ña kaꞌndia kun chiñu nuu yoo, na Israel yoꞌo, ña nduu tuku yo iin ñuu kaꞌnu ña ^xaꞌndia nuu mii? ―kachi ndia xiꞌin ra. ");
INSERT INTO mxv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ra saa ndakuiin Jesús kachi ra saa xiꞌin ndia: ―Xiniñüꞌu kundaa vi ini ndoꞌo xaꞌa ña chituni Iva yo Ndioxi sa ra, chi indaa mii va ra kuvi ra kundaa ini xaꞌa ña, ra ama ke sa ra ña, ra ndia kii ke sa tu ra ña. ");
INSERT INTO mxv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ndi su ndoꞌo, ra te xa ná nduxínu̱ Tachi Yii Ndioxi sata ndo, ra saa vi ke ndakiꞌin ndo ndiee Ndioxi; ra kaꞌan ndoso ndo xaꞌa yu nuu takundiꞌi na ñuu Jerusalén, xiꞌin nuu na ñuu ña ndikun ndiaa Judea, xiꞌin nuu na ñuu ña ndikun ndiaa Samaria, xiꞌin nuu takundiꞌi ñuu ña iyoo nuu ña yuuvi yoꞌo ―kachi Jesús xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ra te ndiꞌi ndikaꞌan Jesús tuꞌun yoꞌo xiꞌin ndia, saa ra ndakuita ra kuanuꞌu ra ndivi va, ra ixtoꞌni ndia saa ndisaꞌvi ra tiañu viko kuaꞌan va ra. ");
INSERT INTO mxv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ra iin kuaꞌan ini ndia ixtoꞌni ndia chi ndivi ndíta ndia, ña kuaꞌan Jesús, saa ra tuꞌva xaa va uvi tiaa ndia ndixi tikoto yaa xikundita ndia xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ra ndikaꞌan ndia xiꞌin ndia kachi ndia saa: ―Ndoꞌo, ndia ñuu Galilea, ¿nichuun ke iin kua̱ꞌa̱n ini ndo ixtondiaa ndo ndivi ndíta ndo? Ra na kundaa ini ndo chi iin ta kuꞌva kuu ña kuaꞌan Jesús chi ndivi, ra iin saa ke kuu tu te xa na nandiko ra kixi tuku va ra ―*kachi ndia xiꞌin ndia. ");
INSERT INTO mxv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ra saa kee ndia xitaꞌan xiꞌin Jesús iku ña nani Olivo, kuanuꞌu ndia ñuu Jerusalén. Ra takua yachin iku kan va ke ndixaꞌan ndia xiꞌin Jesús te kuanuꞌu ra ndivi, saa chi na judío ra ndixïyo ndiayu ndaꞌa na ña kaka kani ni na kii yii ña ndakindiee na. ");
INSERT INTO mxv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ra te ndaxàà ndia ñuu Jerusalén, ra saa ndindiꞌvi ndia iin veꞌe toto ña sukun, ra veꞌe chi ninu ke xindokoo ndia ndakundee ndia. Saa chi ikan ku nu xikanduꞌu ra Pedro, xiꞌin ra Jacobo, xiꞌin ra Juan, xiꞌin ra Andrés, xiꞌin ra Felipe, xiꞌin ra Tomás, xiꞌin ra Bartolomé, xiꞌin ra Mateo, xiꞌin ra Jacobo seꞌe ra Alfeo, xiꞌin ra Simón ra xitaꞌan xiꞌin na yuvi xika kuachi xiꞌin gobierno, xiꞌin ra Judas seꞌe inka tiaa ra xinani Jacobo. ");
INSERT INTO mxv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ra iin ndisaa ichi va ^ndakutaꞌan ndia xiꞌin taꞌan ndia ña kaꞌan ndia xiꞌin Ndioxi, saa chi iin yuꞌu va ndia; ra ndakutaꞌan tu sava na siꞌi va xiꞌin ndia, ra saa tu ña María, siꞌi mii Jesús, xiꞌin ndia ñani va ra. ");
INSERT INTO mxv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Saa kuu iin kii ra ndakutaꞌan kuꞌva ciento oko yuvi ndee na, ra saa ndakundichi ra Pedro maꞌñu na, ra ndikaꞌan ra xiꞌin na kachi ra saa: ");
INSERT INTO mxv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ñani yo, xa kundaa ini takundiꞌi va yo ña ndoꞌo Jesús saa chi mii va ra Judas, ra xitaꞌan xiꞌin yo kuvi ra xinuu nuu na saa ini ta ndixaꞌan na tiin na Tata yo. Ra saa ke kuu va ña vaꞌa ndixinu nuu tuꞌun Ndioxi ña ndikaꞌan Tachi Yii Ndioxi xiꞌin ra rey David xaꞌa ra Judas. ");
INSERT INTO mxv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ra ra Judas kan, ra xiꞌin yoo ke xindiaꞌvi ndiaa va ra, ra iin chiñu xindiso tu ra xiꞌin va yo. ");
INSERT INTO mxv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ra xiꞌin xuꞌun ña ki̱ꞌin ra xaꞌa Jesús ña ndixiko ra ra ke sata ra iin ñuꞌú. Ra te ndiꞌi, ra nuu ñuꞌu kan ke ndakava ndiee ra, ra ndi̱ka̱a̱n tixi ra, ra iin ndakoyo yaa va ñaꞌa ini ra. ");
INSERT INTO mxv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ra te kundaa ini takundiꞌi na ndéé ñuu Jerusalén xaꞌa ña ndoꞌo ra, ra saa nduku na kivi ñuꞌu kan, ña ndakunani ña Acéldama, ra tuꞌun mii na, ra “Yoso nuu ndixitia nii” ke kachi tuꞌun yoꞌo.) ");
INSERT INTO mxv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ra iin taꞌvi loꞌo nuu tutu Salmo ^kaꞌan tuꞌun Ndioxi ^kachi ña saa xaꞌa ra: Veꞌe ra, ra veꞌe vichi va na nduu ña, ra ndia nii yuvi ná kundëe ini ña. Ra kaꞌan ka tu ña kachi ña suꞌva va: Ra inka yuvi tu na ndakiꞌin chiñu nuu va ra, ^kachi ña. ");
INSERT INTO mxv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Ra vichin ke ndakaya kuaꞌa ni tiaa ndee ndia yoꞌo, ra sava ndia yoꞌo ra xa yachi vi ke itaꞌan ndia xiꞌin yo, saa chi xa xitaꞌan va ndia xiꞌin yo ta ndixika Jesús xiꞌin yo, ");
INSERT INTO mxv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ra xini tu ndia te sakuchi ra Juan Jesús va, ra xini nuu tu ndia ta ndakuita ra kuanuꞌu ra ndivi va. Ra iin ndia yoꞌo kuvi ndia xiniñuꞌu kana kutaꞌan xiꞌin yo, ra saa ke vaꞌa ndatuꞌun ndia xiꞌin yuvi xaꞌa ña ndatiaku Jesús. ―kachi ra Pedro xiꞌin na. ");
INSERT INTO mxv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ra saa ndikaꞌan na xaꞌa uvi tiaa, ndia ndakiꞌin chiñu. Ra iin ra nani José Barsabás, ra kaꞌan tu na ña nani ra Justo va; ra iin tu ra nani Matías va. ");
INSERT INTO mxv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ra saa ndikaꞌan na xiꞌin Ndioxi kachi na saa: ―Tata, yoꞌo kuvi ra xíni̱ ndia kuꞌva ke iyoo nima takundiꞌi yuvi; ra kuni̱ ndi na taxi kun kuꞌva nuu ndi, ra na kundaa ini ndi ndia iin ndia yoꞌo kuvi ndia ndakaxin kun, ");
INSERT INTO mxv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ña ndakiꞌin ndia chiñu ña ndakoo ra Judas, ra ndakitaꞌan ndia xiꞌin ndi, saa chi ra Judas, ra ndakava va ra xiꞌin kuachi ra, ra kua̱ꞌa̱n ra chi nuu xiniñuꞌu ku̱ꞌu̱n va ra ―kachi na xiꞌin Ndioxi. ");
INSERT INTO mxv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ra saa xaꞌa ndia sasiki ndia xiꞌin iin ñaꞌa, ña taxi kuꞌva nuu ndia, ra kundaa ini ndia yoo kuvi ra ndakundichi. Ra te ndiꞌi xa ndia saa, saa ra chi nuu ra Matías va kindoo ñaꞌa kan; ndia saa ra ndakutaꞌan ra xiꞌin ndia uxi iin kan, ra iin nduu ra xiꞌin va ndia. ");
INSERT INTO mxv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Saa kuu ra nditiandiaa va kii ña koo viko Pentecostés, ra itaꞌan kuiti takundiꞌi va na kandixa Jesús ndéé na iin veꞌe. ");
INSERT INTO mxv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ra tuꞌva iin niniꞌi va xaꞌa ^kuu chi ndiví, ra iin ta ^kuu te ndiee ni vaxi tachi, iin saa xaꞌa kuu, ra saa ndu̱xínu̱ ña ini veꞌe nuu ndéé na, ra iin niniꞌi xaꞌa kuu veꞌe kan. ");
INSERT INTO mxv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ra iin ta kuꞌva íin yaa ñùꞌù, saa iyoo ña ndixinu sata ta iin ta iin na. ");
INSERT INTO mxv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ra saa ndakiꞌin takundiꞌi na Tachi Yii Ndioxi, ra xaꞌa na ^kaꞌan na inka nuu tuꞌun, ra ta iyoo mii tuꞌun ña taxi Tachi Yii Ndioxi ndaꞌa na kaꞌan na, ke ndikaꞌan va na. ");
INSERT INTO mxv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ra kii kan, ra kuaꞌa ni na judío na ^kandixa ndinuni Ndioxi, na ndéé iinii saa kuvi ña yuuvi ndi̱xa̱a̱ ña ndasakaꞌnu na Ndioxi ñuu Jerusalén, viko Pentecostés xa ta kuꞌva yunaꞌa va na. ");
INSERT INTO mxv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ra te xini soꞌo yuvi kan ña iin níníꞌi kuu ra saa xaꞌa ndakaya kuaꞌa ka vi na ña xini soꞌo na ni ke kúú veꞌe kan, ra nii kundäa ini na ni ke sa vi na, saa chi ^xini soꞌo na ña kaꞌan yuvi na ndee veꞌe kan taꞌan tuꞌun ña kaꞌan ta iin iin na ndixaa kan. ");
INSERT INTO mxv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ra iin kua̱ꞌa̱n ini na ndita na, ra ndakanda ka vi ini na, ra kaꞌan na xiꞌin taꞌan na, kachi na saa: ―¿Ni ke yoꞌo? ¿Ra a süvi va na ñuu Galilea kuvi takundiꞌi yuvi yoꞌo? ");
INSERT INTO mxv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ra ni chuun ke vaꞌa ^kaꞌan na tuꞌun ña kaꞌan yo, tuꞌun ka̱ku yo? ¿Ra ndixaa ke xa̱ na ña sakuaꞌa na ña? ");
INSERT INTO mxv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ra iinii kuvi va ke kee yoo, na xaa yoꞌo vichin; saa chi yoo yoꞌo ra Partia va kee yo, ra sava tu na ke̱e Media va, ra sava tu na ke̱e Elam va, xiꞌin na kee Mesopotamia, xiꞌin na ke̱e Judea, xiꞌin na ke̱e Capadocia, xiꞌin na ke̱e Ponto, xiꞌin na ke̱e Asia, ");
INSERT INTO mxv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ra saa tu na ke̱e Frigia, na ke̱e Panfilia, na kee Egipto, ra saa tu na ke̱e África, ña ndikaa chikan ka nuu ndikaa ñuu Cirene; ra saa tu na ke̱e ñuu Roma na xaa ndakundee yoꞌo, ra nduu na judío xiꞌin yo vichin, ra saa tu mii yo na kuu judío va; ");
INSERT INTO mxv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ra sava tu na kee ñuu Creta xiꞌin ñuu Arabia. Ra ^xini soꞌo takundiꞌi yo ña ^kaꞌan yuvi na ñúꞌu veꞌe yoꞌo taꞌan tuꞌun ña kaꞌan ta iin iin yo. Ra kaꞌan na xaꞌa ña vaꞌa, ña nduvi ña xa Ndioxi ―^kachi na xiꞌin taꞌan na. ");
INSERT INTO mxv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ra ndakanda ka vi ini na ra nii nïꞌi na ni ke kachi na, ra saa ^kaꞌan na xiꞌin taꞌan na ^kachi na saa: ―¿Ni ke kuni ^kachi takundiꞌi ña kuu yoꞌo vichin? ―^kachi na. ");
INSERT INTO mxv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ra sava tu na ^xasiki va, ra ^kaꞌan na ^kachi na saa: ―Tiäa soꞌo ndo ña kuu yuꞌu vi na, saa chi na xíꞌí va kuvi na ―kachi na. ");
INSERT INTO mxv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ra saa ndakundichi ra Pedro xiꞌin ndia uxi iin ndia itaꞌan xiꞌin ra, ra ndikaꞌan ra xiꞌin takundiꞌi yuvi na ndakaya ndita kan, kachi ra saa: ―Ndoꞌo, na taꞌan yo, na Israel, xiꞌin takundiꞌi na ndee ñuu Jerusalén yoꞌo, ra na tiaa ni soꞌo ndo ña ka̱ꞌa̱n yu xiꞌin ndo vichin, ra na kundaa ini ndo xaꞌa ña kúú yoꞌo. ");
INSERT INTO mxv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Saa chi nduꞌu, na ndee yoꞌo vichin, ra süvi na xíꞌí kuvi ndi, ta kuꞌva kachi sava ndo, chi vichin ra