﻿USE sofia;
DROP TABLE IF EXISTS sofia.mxtNT_vpl;
CREATE TABLE mxtNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mxtNT_vpl WRITE;
INSERT INTO mxtNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ican ihya cuví sɨvɨ ñáyɨvɨ vachi ra Jesucristo tata. Tata ra David ta tata ra Abraham cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Sehe ra Abraham cuví chi ra Isaac, sutu ra Jacob. Ta sehe ra Jacob cuví chi ra Judá ta yañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ta sehe ra Judá chihin cu Tamar cuví chi ra Fares ta ra Zara. Ta sehe ra Fares cuví chi ra Esrom sutu ra Aram. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ta sehe ra Aram cuví chi ra Aminadab sutu ra Naasón. Ta sehe ra Naasón cuví chi ra Salmón. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ta sehe ra Salmón chihin cu Rahab cuví chi ra Booz. Ta sehe ra Booz chihin cu Rut cuví chi ra Obed, sutu ra Isaí. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ta sehe ra Isaí cuví chi rey David. Ta sehe rey David chihin ñaha cha cuvi̱ ñasɨhɨ ra Urías cuví chi ra Salomón. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ta sehe ra Salomón cuví chi ra Roboam sutu ra Abías. Ta sehe ra Abías cuví chi ra Aza. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sehe ra Aza cuví chi ra Josafat, sutu ra Joram. Ta sehe ra Joram cuví chi ra Uzías. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sehe ra Uzías cuví chi ra Jotam, sutu ra Acaz. Ta sehe ra Acaz cuví chi ra Ezequías. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sehe ra Ezequías cuví chi ra Manasés, sutu ra Amón. Sehe ra Amón cuví chi ra Josías. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sehe ra Josías cuví chi ra Jeconías ta yañi ra. Cacacu̱ ra quɨvɨ catɨɨ̱n ra ñuu Babilonia chi ñu Israel, cuahan coyo ñu cua sacuvi ñu tyiño nuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cha yaha cuan, ta chicoo sehe ra Jeconías, ta ican cuví ra Salatiel sutu ra Zorobabel. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ta sehe ra Zorobabel ican cuví chi ra Abiud sutu ra Eliaquim. Ta sehe ra Eliaquim cuví chi ra Azor. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ta sehe ra Azor cuví chi ra Sadoc sutu ra Aquim. Ta sehe ra Aquim cuví chi ra Eliud. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ta sehe ra Eliud cuví chi ra Eleazar sutu ra Matán. Ta sehe ra Matán cuví chi ra Jacob. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ta ra Jacob cuví sutu ra José yɨɨ cu María. Ican ña cuví sɨhɨ ra Jesús ra cuví Cristo, o cuñí chi catyí, ra cha saquichi Nyoo vatyi cuví ra rey cuenda yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ra Abraham chicoo̱ uchi cumi tahan tata ra nyacua nya cacu̱ ra David. Ta ra David chicoo̱ uchi cumi tahan tata ra nyacua nya quɨvɨ tɨɨ̱n ñu Babilonia chi ñu Israel. Ta nyacua nya quɨvɨ cuan chicoo̱ uchi cumi ca tahan tata ñu nyacua nya quɨvɨ cacu̱ ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tyehe caa cacu̱ ra Jesucristo: Cha yaha̱ cundaa tyiño cha cutandaha cu María, sɨhɨ ra Jesús, chihin ra José. Ta cha ni cumañi ca coo ñu chihin tahan ñu, chicoho̱n sehe ña, soco cha cuenda maa Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ta ra José ra cua cuvi yɨɨ ña, cuví ra noo ra vaha. Ta ña cuñí ra cuhva ra tɨcahan nuu chi ña, yucuan chaha tyaa̱ ra cuhva cha sandoo xehe ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ta cha nɨ ri ca cha chicá xiñi ra tyicuan caa, tuvi̱ noo ángel Sutu Mañi yo nuu ra nu quixí ra. Ta nyehe̱ ra ñumahna ta catyí ángel cuan chi ra tyehe caa: ―Yoho José, tata ra David cuvún. Ma caca iñun quehun chi cu María cuvi ña ñasɨhun, vatyi sehe ña cha cua cacu, cuenda Tatyi Ii Nyoo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta cha yaha cacu cha lee cuan, cusacunañun chi cue: Jesús. Tyicuan caa cunañi ra vatyi cusacacu ra chi ñáyɨvɨ chihin cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tandɨhɨ ihya cuvi̱ tacuhva nachino cava tuhun cha caha̱n Sutu Mañi yo chihin yuhu ra cacuvi̱ profeta ra ta cha naha, ra cachahá cuenda tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta catyi̱ ra tyehe caa: Ñaha tyivaa cha ta coo ca rayɨɨ chi, cucohon sehe ña. Ta coo noo sehe ña. Ta cunañi cue: Emanuel. Ta sɨvɨ cuan cuñí chi catyí: “Nyoo nyaá ra chihin yo.” Catyí ángel cuan chi ra José chichi ñumahna. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuhva cha nducachi̱ iñi ra José, sacuvi̱ ra tari cuhva catyi̱ ángel cuan chi ra. Ta quehe̱n ra chi cu María vatyi cuvi ña ñasɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Soco ña chiyo̱ ra chihin ña cha numi ri. Nyacua nya cha yaha̱ cacu̱ sehe ña. Ta sacunañi̱ ra chi cue: Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cacu̱ ra Jesús noo ñuu cha nañí Belén. Ta ñuu cuan nyaá chi nu cuví Judea. Ta rey Judea cuan nañí ra Herodes. Tyicuan ta chaa̱ coyo suhva ra nya ñuu Jerusalén. Quichi̱ coyo ra ityi nu caña ñanyii. Ta ra cachiñi tuñi xaan cacuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ta candaca̱ tuhun ra chi ñáyɨvɨ tyehe caa: ―¿Nya nyaá ra cuvi rey cuenda ñu Israel? Vatyi ityi nu caña ñanyii nyehe̱ ndi tiñoo cha chaha̱ cuenda tyi cacu̱ ra ityi ihya. Ta vachi ndi vachi sacahnu ndi chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ta quɨvɨ cha chito̱ rey Herodes tuhun cuan cutyoño cuñí ra. Ta tyicuan caa tucu tandɨhɨ ñáyɨvɨ ñuu Jerusalén cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tyicuan ta cana̱ ra Herodes chi tandɨhɨ ra cacuví nuu chi tata sutu ta ra casacuahá ley vehe ñuhu. Ta ndaca̱ tuhun ra chi ra, nya maa maa tahán chi cacu ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta canacaha̱n ra cuan ta cacatyí ra tyehe caa: ―Ñuu Belén ityi Judea, yucuan tahán chi cacu ra vatyi tyehe caa catyaa̱ ra profeta Nyoo nu tutu ta cha naha: ");
INSERT INTO mxtNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ta yoho ñuu Belén ityi Judá, vasɨ ñuu luhlu ri cuvún cha nuu ñuu nahnu ca iyó ityi Judá nu nyaún. Soco cahnu ca cucuvun vatyi Belén chiña cucacu minoo ra cunyaca ñaha. Ta cusaha cumi ra chi ñu Israel ñáyɨvɨ cuende. Tyicuan caa catyí nu tutu Nyoo, ―cacatyí ra cuan chi ra Herodes. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tyicuan ta cana̱ xehe ra Herodes chi ra chiñi tuñi cuan, ta ndaca̱ tuhun ra chi ra ñáá cuhva ta ñáá quɨvɨ caña̱ tiñoo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tyicuan ta tachi̱ ra chi ra nya ñuu Belén, ta catyí ra chi ra: ―Cua̱han ndo, ta ndu̱cu tuhun vaha ndo tuhun cha lee cuan. Ta tatu nañihi ndo chi cue, ta qui̱chi catyi ndo chii, tacuhva vatyi cuhun tucu yuhu cusacahni chi cue ―catyí ra Herodes chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cha yaha̱ cachiñi ra chiñi tuñi cuan cha catyi̱ ra Herodes, caquehen ra ityi ta cuahan coyo ra. Ta tiñoo cha canyehe̱ ra ityi nu cañá ñanyii cuan, cuahan tɨ ityi nuu ra. Ta chicuɨñɨ̱ tɨ maa maa sɨquɨ nu catuví cha lee cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ta cuhva cha canyehe̱ ra chiñi tuñi cuan tyi chicuɨñɨ̱ tiñoo cuan, sɨɨ xaan cacuñi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta caquɨhvɨ̱ ra chichi vehe nu catuví cha lee cuan. Ta cananyehe̱ ra chi cue chihin cu María sɨhɨ cue. Ta chicuɨñɨ chɨtɨ ra vatyi sacahnu ra chi cue. Tyicuan ta canuña̱ ra yuhu caja cha canyisó ra. Ta catava̱ ra regalo cha cuví xuhun cuaan, ta cutu vixi chahán, ta ndutya vixi chahán cha nañí mirra. Ta cachaha̱ ra chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yaha̱ cuan ta cataha̱n ra ñumahna ta cutuñi iñi ra vatyi ña tahán chi canayaha ra ityi nu nyaá ra Herodes, yucuan chaha sɨɨn ca ityi cuanuhu coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cha yaha̱ cuahan coyo ra chiñi tuñi cuan, tyicuan ta noo ángel Sutu Mañi yo tuvi̱ nuu ra José chichi ñumahna. Ta catyí ra chi ra: ―Ndɨ̱cuita, que̱hen chi ra lee ihya, ta chi sɨhɨ ra, ta cuhun ndo nya Egipto. Ta yucuan cu̱nyaa ndo nyacua nya sacote chi ndo. Vatyi ra Herodes cunanducu ra chi cha lee ihya vatyi cahñi ra chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tyicuan ta ndɨcuita̱ ra José cha cuaa cuan. Ta quehe̱n ra chi cha lee cuan ta chi sɨhɨ cue. Ta cuahan ñu nya Egipto. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta yucuan chinyaa̱ ñu nyacua nya cha chihi̱ ra Herodes. Tyehe caa cuvi̱ tacuhva na chino cava tuhun cahán Nyoo cha tyaa̱ ra profeta ta cha naha. Tyehe caa catyí ra: “Nya ñuu Egipto cane̱ chi Sehi”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cha tuvi̱ iñi ra Herodes vatyi ra cachiñí tuñi cuan sandavi̱ ñaha ra chi ra, nduxaa̱n vavaha ra. Ta tachi̱ ra tyiño na cacahñi ra chi ra cuatyaa cha iyó ñuu Belén cuan ta ndaha ñuu ñandɨhɨ, ra cuatyaa cha nɨ cacu nyacua nya cha uvi cuiya. Tyicuan caa sacuvi̱ ra vatyi nandichi̱ xiñi ra vatyi tyicuan tahan cuiya ra Jesús tari cuhva catyi̱ ra chiñi tuñi cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tyicuan caa chino̱ cava tuhun cahán Nyoo cha tyaa̱ ra Jeremías profeta Nyoo ta cha naha, ta catyi̱ ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tyacú noo ndusu ñuu Ramá, cha chacú chaa ñáyɨvɨ, ta iyo tahan ñu. Ta ican cuví ñáyɨvɨ tata cu Raquel, ñáyɨvɨ Israel, chacú chaa ñu cha cuenda sehe ñu. Soco ña cuñí ñu cha naquehen ndahvi ñu chi ñu cha cuenda cha cachihi̱ sehe ñu, catyí chi nuu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Soco cha yaha̱ cha chihi̱ ra Herodes, tyicuan ta tuvi̱ tucu noo ángel cha tachi̱ Sutu Mañi yo nuu ra José nu quixí ra ñuu Egipto. Ta catyí ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ndɨ̱cuita ta que̱hen chi cha lee chiña, ta chi sɨhɨ cue. Ta cua̱nuhu ndo nya ñuu Israel, vatyi cha chihi̱ ra nducu̱ cahñi chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tyicuan ta ndɨcuita̱ ra José, ta quehe̱n ra chi cha lee cuan ta chi sɨhɨ cue. Ta cuanuhu̱ coyo ñu nya Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Soco quɨvɨ chito̱ ra José vatyi ra Arquelao cuví ra rey tyiño nuu sutu ra, ra Herodes, nya Judea, nayuhvi̱ ra ta ña cuñí ra cuhun ra yucuan. Ta vatyi sacoto̱ Nyoo chi ra chichi ñumahna, yucuan chaha cuanuhu ñu nya Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cha chaa̱ ñu yucuan, cuahan ñu nya ñuu Nazaret, cua coo ñu. Ta yucuan chiyo̱ ñu. Tyehe caa cuvi̱ tacuhva chino cava tuhun cha cahán Nyoo, cha catyaa̱ ra profeta ta cha naha. Vatyi catyi̱ ra tyi ra Jesús ra ñuu Nazaret cucunañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Quɨvɨ cuan ra Juan ra sacondutyá chi ñáyɨvɨ cuahan ra noo chiqui ndɨɨ ityi Judea. Ta quichaha̱ cahan ra tuhun Nyoo chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ta catyí ra: ―Ndu̱ uvi iñi ndo cuatyi ndo vatyi cha yatyin nyaá Nyoo ra cua cunyaca ñaha añima yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ican tuhun ra Juan ihya cuví cha tyaa̱ ra Isaías ra cuvi̱ profeta Nyoo ta cha naha. Tyehe caa tyaa̱ ra: Chiñí yo cha caná chaa noo ra noo nu chiqui ndɨɨ ta catyí ra: “Tari sanduvahá ndo noo ityi, tyicuan caa sa̱nduvaha ndo añima ndo, vatyi cua quichi Sutu Mañi yo. Nu̱ña ndo noo ityi ndoo chi ra naquɨhvɨ ra añima ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ta ra Juan ñihnó ra sahma chino̱ chihin ixi camellu. Ta sincho ra, ñɨɨ cuví. Ta maa maa ri pinchi chachí ra ta tyañuñu cuhu chihí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ñáyɨvɨ ñuu Jerusalén ta tandɨhɨ ñu ñuu cha nyicú Judea, ta ñu ca iyó yatyin ri ityi yuvi cahnu Jordán cuan, quichi coyo ñu, quichi̱ tyasoho ñu tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta cha yaha̱ nahma ñu cuatyi ñu, ra Juan sacondutya̱ ra chi ñu yuvi cahnu Jordán cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Soco ra Juan nyehe̱ ra vatyi cuaha xaan ra fariseo, ra quichahá xaan ley vehe ñuhu, ta cuaha xaan ra saduceo, caquichi̱ coyo ra vatyi condutya ra. Ta catyí ra chi ra: ―¡Nyoho, tari noo tata coo xaan cuví ndo! ¿Yóó cha sacoto̱ chi ndo vatyi chihin cha condutya ri ndo ta ma tachi tuñi ca Nyoo chi ndo? Ña ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Co̱o ndo noo cha quetuví vaha tyi ndicha cha ndu uvi iñi ndo cuatyi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ta ma cuyaa ndo catyí ndo vatyi tata ra Abraham vachi ndo. Vatyi nyacua nya chihin yuu ihya ta cuví savaha Nyoo ñáyɨvɨ tata ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tari yutun cha ña chahá chɨtɨ, tyicuan caa cuví ndo. Vatyi ña sacuví ndo tari cuhva cuñí Nyoo. Ta yutun cha ña chahá chɨtɨ, cahnya ñáyɨvɨ chi tun. Ta cahmi ñu chi tun. Tyicuan caa tucu nyoho, cuhun ndo nu cayú ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Cha ndicha vatyi yuhu sacondutyé chi ñáyɨvɨ chihin ndutya, tari noo seña vatyi cha ndu̱ uvi iñi ñu cuatyi ñu. Soco cha yaha sacondutya yuhu chihin ndutya, vachi inga ra cusacondutya chi ñáyɨvɨ chihin Tatyi Ii Nyoo ta chihin ñuhu̱ ihñi. Iyó ca tunyee iñi chi maa ra ta ñima ca yuhu. Ta ni cha cuise ndichan ra ta ña nañe, vatyi cahnu xaan ca ra cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tari noo ra cha cua naquehen vaha trigo ta natyihi vaha ra chichi yaca ta mihin cahmi ra, tyicuan caa cuví maa Sutu Mañi yo chihin yo. Tatu chinó iñi yo chi ra cunaquehen vaha ra chi yo. Ta cunyicu yo chihin ra. Soco tatu ña chinó iñi yo chi ra cutyihi ra chi yo anyaya nu cayu ñuhu̱ cha ma ndahva ca maa ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tyicuan ta quita̱ ra Jesús Galilea ta chaa̱ ra yuvi cahnu Jordán nu ñohó ra Juan, vatyi cuñí ra cha sacondutya ra Juan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cha xihna ri ña cuñi̱ ra Juan sacondutya ra chi ra, ta quichaha̱ catyi ra chi ra Jesús tyehe caa: ―Yoho cuñún cha sacondutye chuun, soco ña tahán chi cha sacondutya yuhu chuun. Maun tahán chi sacondutyon chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Soco ra Jesús catyí ra chi ra: ―Cha vityin, na cuvi chi cuhva catyi̱ yuhu chuun. Vatyi cuñí chi cha sacuvi yo tandɨhɨ cha cuñí Nyoo ―catyí ra chi ra Juan. Tyicuan ta ndoo̱ ra Juan vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cha yaha̱ ri condutya̱ ra Jesús ta quita̱ ra chichi ndutya. Ta nuña ri andɨvɨ, ta ra Jesús nyehe̱ ra yoso caa vachi noó Tatyi Ii Nyoo, tari noo paloma, ta chaa̱ chi sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tyicuan ta tyacu noo ndusu ityi andɨvɨ, ta catyí chi tyehe caa: ―Ican ra ihya cuví Sehi, ra cuñí xain chi. Ta sɨɨ xaan cuñí chihin ra ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tyicuan ta Tatyi Ii Nyoo chinyaca̱ chi ra Jesús noo chiqui ndɨɨ, tacuhva nducu nyehe cuihna chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ña chachi̱ ra uvi xico quɨvɨ ta uvi xico ñuu. Ta yaha̱ cuan ta chaa̱ soco chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tyicuan ta tuhva̱ cuihna chi ra, vatyi cuñí ra nducu nyehe ra chi ra. Ta catyí ra chi ra: ―Tatu ndicha cha Sehe Nyoo cuví chuun, sa̱nanduvi pan yuu ihya ―catyí cuihna chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Soco ra Jesús nacaha̱n ra ta catyí ra: ―Tuhun Nyoo catyí chi tyehe caa: “Ñima chihin cha cachi ri ñáyɨvɨ ta conyito ñu. Conyito tucu añima ñu chihin tuhun cahán Nyoo” ―catyí ra Jesús chi cuihna cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tyicuan ta chinyaca̱ cuihna cuan chi ra Jesús nya ñuu Jerusalén. Ta sandaa̱ cuan chi ra xiñi vehe ñuhu cahnu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ta catyí cuan chi ra: ―Tatu ndicha cha Sehe Nyoo cuvún, sa̱ndupehla nyacua nya nu sucun ihya ta nyacua nya nu ñuhú. Vatyi nyaá nu catyí chi nu tutu Nyoo tyehe caa: “Nyoo cusaquichi ra ángel, quichi saha cuenda chuun. Cunaquehen ra chuun chihin ndaha ra ta ma cuhva ra cha taxin chahun chihin yuu” ―catyí cuihna cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ta nacaha̱n ra Jesús ta catyí ra: ―Soco catyí tucu chi nu tutu Nyoo tyehe caa: “Ma nducu nyehun chi Sutu Mañi yo Nyoo” ―catyí ra Jesús chi cuihna. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tyicuan ta chinyaca̱ tucu cuihna cuan chi ra noo yucu sucun. Ta sañaha̱ cuan tandɨhɨ cha cahnu cuví nu nyacá ñaha rey ta ra cuví tyiño chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta catyí cuihna cuan chi ra tyehe caa: ―Yuhu cuhve tandɨhɨ maa ihya chuun, tatu yoho ta cuɨñɨ chɨtun nui ta sacahnun chii ―catyí cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi cuihna cuan: ―Ca̱nyaha chuun nui, yoho cuihna. Vatyi tuhun cahán Nyoo nyaá chi nu tutu ta catyí chi tyehe caa: “Noo ri chi maa Nyoo sa̱cahnu yo. Ta ɨɨn ri chi maa ra qui̱chaha yo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tyicuan ta cuahan cuihna cuan, ta ndoo̱ ra Jesús, ta chaa̱ coyo ángel ta tyinyee̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quɨvɨ cha chito̱ ra Jesús vatyi ra Juan ñohó ra vehe caa, cuahan ra nya Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Soco ña ndoo̱ ra ñuu Nazaret, nu chahnu̱ ra. Cuahan ra cua coo ra nya ñuu Capernaum, noo ñuu cha nyaá yatyin ri yuhu miñi, cha nyaá yatyin ñuhú cuenda ra Zabulón chihin ñuhú ra Neftalí. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tyehe caa cuvi̱ tacuhva chino cava tuhun cha tyaa̱ ra Isaías nu tutu Nyoo ta cha naha. Catyí chi tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuhú ra Zabulón ta ñuhú ra Neftalí cha nyaá yuhu miñi inga chiyo yuvi cahnu Jordán, cha cuví Galilea nu iyó ñu ñima ñu Israel cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chinyicu̱ añima ñu nu ñaa iñi vatyi chinyaca̱ ñaha ra ña vaha chi ñu chihin tuhun chihi, soco sandundichín ñuhu̱ Sutu Mañi yo añima ñu nu nyicú ñu, catyí ra Isaías. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nyacua nya quɨvɨ cuan, ta quichaha cahan ra Jesús tuhun Nyoo chihin ñáyɨvɨ, ta catyí ra chi ñu: ―Ndu̱ uvi iñi ndo cuatyi ndo vatyi yatyin ri nyaá Nyoo ra cua cunyaca ñaha añima ndo ―catyí ra Jesús chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ra Jesús chicá noo ra yuhu miñi cha nañí Tyañuhu Galilea cuan. Ta nanyehe̱ ra chi uvi tahan ra chihin yañi ra, ra Simón cha nañí tucu Pedro, ta ra Andrés. Ra catɨɨ́n tiyaca cacuví ra. Ta cacañí ra yuhva ra nu ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tyicuan ta quichaha̱ catyi ra Jesús chi nɨnduvi ra tyehe caa: ―Cu̱nyicon ndo chii. Ta yuhu cusacuvi vatyi tari ñihí ndo tiyaca, tyicuan caa cuñihi ndo anima ñáyɨvɨ (ta cutava ndo chi ñu nu quiñi caa na quɨhvɨ ñu cuenda Nyoo) ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Caa cuhva ri cuan casandoo̱ ra yuhva ra ta cuahan coyo ra chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chiin ri ca chica̱ ra Jesús ityi nuu ca ta nanyehe̱ ra chi uvi ca ra chihin yañi ra, ra Jacobo ta ra Juan. Sehe ra Zebedeo cacuví chi ra. Canyicú ra chichi noo canoa chihin sutu ra canaquicú ra yuhva ra. Ta cana̱ ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta caa cuhva ri cuan casandoo̱ ra canoa cuan ta chi sutu ra, ta cuahan coyo ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Cuahan ra Jesús chicá noo ra tandɨhɨ ñuu cha nyicú Galilea sañahá ra chichi vehe ñuhu tahan tahan ñuu. Cahán ra tuhun vaha yoso caa nyacá ñaha Nyoo añima yo. Ta sanduvaha̱ ra chi ñu cuhví chihin tandɨhɨ ri nuu cuehe cha iyó chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cachitó tandɨhɨ ñáyɨvɨ ñuu cha nyicú Siria tuhun ra Jesús. Ta quichi̱ nyaca ñu tandɨhɨ ñu cuhví chi ra: tandɨhɨ ñu sɨɨn sɨɨn cuehe tahán. Ta suhva ñu yɨhɨ́ tatyi ña vaha chi ñu. Ta yɨhɨ́ ñu, yɨhɨ́ cuehe chihi tañi chi ñu. Ta yɨhɨ́ ñu ña cuví nacanda ñu. Ta ra Jesús sanduvaha̱ ra chi tandɨhɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cuaha xaan ñáyɨvɨ nyicón chi ra Jesús: ñáyɨvɨ iyó ñuu cha nyicú Galilea, ñáyɨvɨ iyó ndɨ uchi ñuu Decápolis, ñáyɨvɨ iyó ñuu cha nyicú Judea, ta ñáyɨvɨ iyó inga chiyo yuvi cahnu Jordán ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cuhva cha nyehe̱ ra Jesús tyi cuaha xaan ñáyɨvɨ, ndaa̱ ra noo nuu yucu. Ta chicunyaa̱ ra yucuan. Tyicuan ta ñu nyicón chi ra chicunyicu̱ ñu nɨcachico nu nyaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tyicuan ta quichaha̱ sañaha ra Jesús chi ñu tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Tandɨhɨ ri ñu cha chitó vatyi chiñuhú Nyoo chi ñu, sɨɨ xaan cucuvi chi ñu, vatyi tahán chi vatyi cunyaca ñaha Nyoo añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ta tandɨhɨ ri ñu nducuihya iñi vityin cha catyi cuatyi ñu, sɨɨ xaan cucuvi chi ñu. Vatyi cusanaa Nyoo cha cuihya iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Tandɨhɨ ri ñu cha ña cahnu sahá chi, sɨɨ xaan cucuvi chi ñu, vatyi cuquehen cuenda ñu ñuhu ñayɨvɨ̱ cha catyi̱ Nyoo tyi cuhva ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ta tandɨhɨ ri ñu cuñí xaan sacuvi cuhva catyí Nyoo, sɨɨ xaan cucuvi chi ñu, vatyi Nyoo cutyinyee ra chi ñu tacuhva cuvi sacuvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ta tandɨhɨ ri ñu cha iyó tucahnu iñi chi, sɨɨ xaan cucuvi chi ñu, vatyi Nyoo, cucoo tɨcahnu iñi chi ra chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ta tandɨhɨ maa ñu ndundɨɨ̱ añima saha̱ Nyoo, sɨɨ xaan cucuvi chi ñu, vatyi ñu cuan, cunyehe ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ta ñu nducú cuhva cha coo taxi ri ñáyɨvɨ chihin Nyoo sɨɨ xaan cucuvi chi ñu, vatyi Nyoo, cucatyi ra tyi sehe ra cuví chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ta tandɨhɨ ñu cha tasɨ cuñí nyehe ñáyɨvɨ chi ñu cha catyi cha sacuví ñu tari cuhva catyí Nyoo, sɨɨ xaan cuvi chi ñu, vatyi nyacá ñaha Nyoo añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Na cusɨɨ cuñi ndo tatu cahán ña vaha ñáyɨvɨ sɨquɨ ndo. Ta sanyehé ñu tɨndoho chi ndo. Ta tavá ñu cuaha cuendu sɨquɨ ndo cha catyi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Na cusɨɨ cuñi ndo vatyi tatu tyehe caa sacuví ñu chihin ndo, sɨɨ xaan cucuvi chi ndo, vatyi cahnu xaan ta tyaquɨ xaan cha cutahan chi chi ndo, nachaa ndo andɨvɨ. Vatyi suri tyicuan caa chinyacuvi̱ tucu ñu cha ña vaha chihin ra cacuvi̱ profeta cuenda Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Nyoho cha chinó iñi ndo chii, tari ñɨɨ vaha cuví ndo. Soco tatu ñɨɨ, ta ndɨhɨ cha uhva, ma sacu uhva ca chi cha cachi yo. Ña vaha ca ñɨɨ cuan. Tyicuan ta sacuita yo. Ta cuañi ñáyɨvɨ sɨquɨ chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nyoho cuví ndo tari ñuhu̱ cha sandundichín nu cuahan ñáyɨvɨ. Noo ñuu cha nyaá xiñi noo yucu, ma cuvi quɨhɨ xehe. Tyicuan caa tahán chi cuvi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta yori yo cha tyaa yo noo ñuhu̱ tima, ta tixehe yo chichi noo caja. Soco tyiso yo noo nu sucun vatyi sandichin chi chichi vehe tatu cua quɨhvɨ ñáyɨvɨ, soco ndichin. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ta tyicuan caa tahán chi sandundichin tucu nyoho chihin ñuhu̱ Nyoo cha iyó añima ndo nu cuahan ñáyɨvɨ. Tyicuan ta nanyehe ñu cha vaha cha nyacuví ndo, ta sacahnu ñu chi Sutu yo Nyoo ra nyaá andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ma cuñi ndo vatyi yuhu vachi sanai ley cha tachi̱ Nyoo chi ra Moisés vatyi tyaa ra. Ta nɨ ri ña vachi sanai tuhun cha tyaa̱ ra cacuvi̱ profeta cuenda Nyoo ta cha naha. Yuhu ña vachi vatyi sanai yucuan. Soco vachi quichahi tandɨhɨ cha catyí tuhun cuan, ta sañahí ñáá cha cuñí chi catyí. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cha ndicha catyí chi ndo vatyi cha nɨ ri ca cha iyó ca andɨvɨ chihin ñuhu ñayɨvɨ̱ ma naa nɨ chiin cha tyaa̱ ra Moisés ta ra cacuvi̱ profeta Nyoo ta cha naha, nyacua nya yaha cuvi tandɨhɨ tari cuhva nyaá cha catyaa̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yucuan chaha, tatu ña quichahá ñáyɨvɨ tuhun cha tachi̱ Nyoo chi ñu, vasɨ noo tuhun luhlu ri cuví, ta tatu chasɨ ñu nu quichaha inga ñáyɨvɨ, luhlu xaan cucuvi ñu nu nyacá ñaha Nyoo. Soco ñu cha quichahá tandɨhɨ, ta sañahá tucu ñu chi inga ñáyɨvɨ. Ican ñu cuan cahnu xaan cucuvi ñu nu nyacá ñaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Vatyi cuñí chi cha quichahá vaha ca ndo chi Nyoo ican saha ra sacuahá cuenda ley vehe ñuhu, ta ra cacuví fariseo. Yucuan ta cuvi quɨhvɨ ndo nu nyacá ñaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nyoho cha cuaha chaha chiñi̱ ndo tuhun cha catyi̱ Nyoo chi ñu chiyo̱ ta cha naha. Catyi̱ ra: “Ma cahñi ndo chi ñáyɨvɨ, vatyi tatu cahñi ndo ñáyɨvɨ, tahán chi cutuñi chi ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Soco yuhu, catyí chi ndo, vatyi vasɨ cha cuxaan ri ndo chi noo ñáyɨvɨ, o vasɨ cha cahán uhvi ri ndo chi ñáyɨvɨ, o vasɨ cha cahán nyaa ri ndo chi ñáyɨvɨ, tahán chi cutuñi chi ndo. Ta sɨɨn ri sa̱ha cuenda ndo chi ndo coto cuhun ndo anyaya chihin cuatyi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ta yucuan chaha quɨvɨ cuahun vehe ñuhu, ta nyisón cha cucuhvon chi Nyoo, ta tatu cha nanyaun cha cua cuhvon ta nɨcohon iñun vatyi ña vaha iyó noo yañun chuhun. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Sa̱ndoo cha cua cuhvon chi Nyoo yucuan. Ta cu̱hun vatyi na coo vahun chihin yañun. Tyicuan ta ndi̱chun nya vehe ñuhu, ta cu̱hva cuendon cha cua cuhvon chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tatu yóó ra chicán cuatyi chahun, ta cuahan ra chuhun nya nuu ra cuví tyiño, na̱ndacan tɨcahnu iñi chi ra ityi cuahun, coto cuhva cuenda ra chuun chi ra cuví tyiño. Ta ra cuví tyiño cua cuhva cuenda ra chuun chi policía. Ta policía cuan cutyihi ra chuun vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Soco catyí chuun vatyi ma cuvi quiton vehe caa cuan nyacua nya tyiyahvun tandɨhɨ cha tahán chi tyiyahvun. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nyoho chiñi̱ ndo tuhun vatyi catyi̱ Nyoo ta cha naha vatyi nyoho cha iyó ñasɨhɨ ndo, ma coo inga ñusɨhɨ chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Soco yuhu catyí chi ndo, vatyi nya nyoho cha nyehé ndo chi noo ñusɨhɨ ta quɨhvɨ iñi ndo chi ñu, catyí chi ndo vatyi chihin yucuan ri ta cha chicoo̱ cuatyi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","’Vatyi tatu chɨtɨ nuu chiyo vahun sanacavá chuun nu cuatyi, vaha taxin ca ta̱va ta sa̱cuiton cañi. Vatyi vaha ca quɨhvun nu nyacá ñaha Nyoo chihin noo chɨtɨ nuun, ta ñima ca chihin cha nɨnduvi chɨtɨ nuun ta cuhun nu cayu ñuhu̱ chichi anyaya. O tatu ndahun sanacavá chuun nu cuatyi, vaha taxin ca ca̱hnya ta sa̱cuiton cañi. Vatyi vaha ca cha quɨhvun nu nyacá ñaha Nyoo chihin cha luu ndahun, ta ñima ca cha nanɨun ta cuhun nu cayu ñuhu̱ chichi anyaya. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ta suri catyi̱ tucu Nyoo chi ñáyɨvɨ chiyo̱ ta cha naha vatyi yóó ra sandoo̱ ñasɨhɨ, cuñí chi cuhva ra noo tutu cuenda cha sandoo̱ ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Soco catyí yuhu chi ndo, ñahri ityi iyó chi noo ra cha sandoo ra chi ñasɨhɨ ra tatu ña natuvi̱ ña chihin inga rayɨɨ. Vatyi tatu sandoo̱ ra chi ña, ta ñima cha catyi cuatyi cuan, chicoo̱ cuatyi ra nuu Nyoo. Ta sɨɨn ri sacoo̱ ra cuatyi ña vatyi tatu quehen ña inga ra, chicoo̱ cuatyi ña nuu Nyoo. Ta chicoo̱ tucu cuatyi ra cha quehe̱n chi ña cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ta chiñi̱ tucu ndo, vatyi catyi̱ tucu Nyoo chi ñu chiyo̱ ta cha naha tyehe caa: “Tatu tyanaha ndo Nyoo tyi cusacuvi ndo noo cha cusacuvi ndo, tahan chi cha sacuvi ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Soco yuhu catyí chi ndo vatyi ma tyanaha ndo Nyoo tacuhva chino iñi ñáyɨvɨ vatyi ndicha cha cahán ndo. Ta ma tyanaha ndo ni tuhun andɨvɨ, vatyi yucuan nu nyaá maa Nyoo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ta nɨ ri tuhun ñuhu ñayɨvɨ̱ ihya ma tyanaha ndo, vatyi yucuan cuví nu chañí Nyoo. Ta nɨ ri tuhun ñuu Jerusalén, ta ma tyanaha ndo, vatyi yucuan cuví ñuu Nyoo ra cuví Rey cha cahnu ca. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta nɨ ri tuhun xiñi ndo, ta ma tyanaha ndo, vatyi ma cuvi sanducuichin ndo ni noo ixi xiñi ndo. Ta ni ma cuvi sandutoon tucu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Ican” ca̱tyi ndo, tatu ican. Soco tatu ñima, “ñima”, ca̱tyi ndo. Ta ma tyanaha ndo Nyoo vatyi ra ña vaha tyiyuhú chi ndo cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ta chiñi̱ tucu ndo cha catyí tuhun cha tyaa̱ ra Moisés ta cha naha: “Vatyi tatu noo ñáyɨvɨ cañi ñu nuu ndo, ta tahvi noo noho ndo, o tɨvɨ noo chɨtɨ nuu ndo, o nya chi ndo sañicuehe̱ ñu, tahán chi vatyi sañicuehe tucu ñáyɨvɨ chi maa ñu, tari cuhva cha sañicuehe̱ ñu chi ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Soco yuhu catyí chi ndo, vatyi ma nasacuvi ndo cha ña vaha cha nyacuvi̱ ñu tasɨ iñi chi ndo. Vatyi tatu yóó cha cañi ɨɨn chiyo xɨtɨn ndo, ma nduxaan ndo chi ñu. Soco cuhva tucu ndo inga chiyo xɨtɨn ndo na cañi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O tatu chicán ñu cuatyi chaha ndo, ta cuñí ñu tinyaa ñu noo camisa ndo, ma cuxaan ndo chi ñu. Soco cuhva ndɨhɨ ndo chaqueta ndo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O tatu yóó cha catyí chi ndo na cuiso ndo cha chii ñu noo kilómetro, cuiso ndo uvi kilómetro. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tatu yóó ñu chicán tumañi iñi chi ndo, cu̱hva ndo chi ñu. Ma catyi ndo cha ma saha ndo tumañi iñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ta chiñi̱ tucu ndo tuhun cha catyi̱ ñu chiyo̱ ta cha naha vatyi cu̱ñi ndo chi ra tahan ndo. Ta chi ra xaan iñi chi ndo quɨ̱hɨ tɨsɨhɨ iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Soco yuhu catyí chi ndo, cu̱ñi ndo chi ñáyɨvɨ xaan iñi chi ndo. Ta sa̱cuvi ndo cha vaha chihin ñáyɨvɨ cahan chi ndo, ta chi ñu ña cuñí nyehe chi ndo. Ta ca̱can tahvi ndo chaha ñu quiñi nyacuvi chihin ndo ta sanyehé tɨndoho chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta tyicuan caa sa̱cuvi ndo tacuhva coto ñáyɨvɨ vatyi cuví ndo sehe Sutu yo ra nyaá andɨvɨ. Vatyi maa ra sacañá ra ñanyii, ta sacoón ra savi sɨquɨ tyiño sahá ñáyɨvɨ vaha ta ñáyɨvɨ ña vaha ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tatu nyoho ta cuñí ndo chi ñáyɨvɨ cha vaha iyó chihin ndo ta ña cuñí nyehe ndo chi ñáyɨvɨ xaan iñi chi ndo, ñahri cha vaha cuñihi ndo. Vatyi suri tyicuan caa nyacuví tucu ra catavá xuhun cuenda gobiernu ñuu Roma. Ta quiñi ca iyó ra cuan cuñí maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","O tatu chahá ndo nocumi chi ra tahan ri ndo, ñahri cha vaha xaan nyacuví ndo. Vatyi suri tyicuan caa sacuví tucu ñáyɨvɨ ña ñohó nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tari Sutu yo cha nyaá andɨvɨ maa maa ri cha vaha sacuví ra, tyicuan caa nyoho maa maa ri cha vaha sa̱cuvi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Sa̱ha ndo cuenda ta ma cuyaa ndo ñáá tumañi iñi sacuvi ndo chi ñáyɨvɨ. Vatyi tatu cuyaa ndo nuu ñáyɨvɨ, ñahri cuñihi ndo nuu Sutu yo ra nyaá andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cuhva cha sahá ndo tumañi iñi, ma sacoto ndo chi inga ñáyɨvɨ vatyi sahá ndo tumañi iñi. Ma sacuvi ndo tari sacuví ra sahá tyi vaha ta chicá noo ra nuyahvi ta chichi vehe ñuhu. Sahá ra tumañi iñi tacuhva na catyi ñáyɨvɨ vatyi vaha xaan ñáyɨvɨ cuví ra. Soco yucuan ri ñihí ra cuan ta ñahri ca cuñihi ra nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Soco nya quɨvɨ sahá ndo tumañi iñi chi ñu ndahvi, ma sacoto ndo ni chi ra tahan cahnu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xehe ri sa̱cuvi ndo, tacuhva cha ma coto ñáyɨvɨ. Tyicuan ta Sutu yo Nyoo nyehe ra cha sacuvi ndo tyicuan caa. Ta cuaha ca cha vaha cucuhva ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ta cuhva cha chicán tahvi ndo chi Nyoo, ma cacan tahvi ndo tari cuhva sacuví ñu savahá chii. Vatyi ñu cuan tahán iñi ñu cacan tahvi ñu chi Nyoo nu tuvi ñáyɨvɨ, tacuhva catyi ñáyɨvɨ vatyi vaha xaan ñáyɨvɨ cuví ñu, vaha xaan chinó iñi ñu chi Nyoo. Soco catyí chi ndo cha ndicha vatyi ñahri ca cuñihi ñu nuu Nyoo. Vatyi ñima cha ndicha sacuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Soco nyoho ñáá quɨvɨ cacan tahvi ndo chi Nyoo, ma cacan tahvi ndo tacuhva nyehe ri ñáyɨvɨ chi ndo. Soco quɨ̱hvɨ ndo chichi vehe ndo ta na̱casɨ ndo yuvehe ta ca̱can tahvi ndo chihin tandɨhɨ añima ndo. Ta noo tuhun ri maa Nyoo Sutu yo nyehe ra cha sacuvi ndo tyicuan caa vatyi nuu maa ra chicán tahvi ndo, ta ñima nuu ñáyɨvɨ. Ta cuaha ca cha vaha cucuhva ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cuhva cha cahán ndo chihin Nyoo ñima susuri tuhun cha ñima ri tuhun ca̱han ndo. Vatyi tyicuan caa sacuví ñu cha ñahri tuhun Nyoo caá añima. Cuñí maa ñu vatyi tyicuan caa ta cuɨñɨ Nyoo cha cahán ñu. Vatyi cuaha xaan chaha cahán ñu susuri maa tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma sacuvi ndo tyicuan caa. Vatyi Nyoo cha chitó ra ñáá cha chiñuhú chi ndo, cha nɨ ri ca cha cumañi ca cacan ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yucuan chaha nyoho, tatu cua cacan tahvi ndo chi Nyoo, tyehe caa ca̱tyi ndo: Sutu Mañi yuhu, yoho cha nyaún andɨvɨ. Sacahnú xaan ndi chuun. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na quichi quɨvɨ cha nyaca ñahun ihya sɨquɨ ñuhu ñayɨvɨ̱, tari nyacá ñahun andɨvɨ. Na sacuvi ñáyɨvɨ ihya sɨquɨ ñuhu ñayɨvɨ̱ tandɨhɨ cuhva cuñí maun, tari cuhva cuví gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cu̱hva cha cachi ndi tacuhva cha yaha ndi noo noo quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sa̱ha tucahnu iñi chi ndi ñáá ndɨhɨ cha ña vaha nyacuvi̱ ndi, tari maa ndi sahá ndi tɨcahnu iñi chi ñu satasɨ́ iñi chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma cuhvon cha nducu nyehe ra ña vaha chi ndi, tacuhva ma sacuvi ndi cuatyi nuun. Soco maun cuví ra sacacú chi ndi ndaha ra ña vaha. Vatyi maun cuví ra nyacá ñaha tandɨhɨ. Ta maun cuaha xaan ca tunyee iñi iyó chuun. Ta tahán chi vatyi sacahnu tandɨhɨ ñáyɨvɨ chuun tyicuan ri maa. Ta na cuvi chi tyicuan caa. Tyicuan caa cuhva tahán chi cacan tahvi ndo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Vatyi tatu nyoho ta sahá ndo tɨcahnu iñi chi ñu nyacuví cha ña vaha chihin ndo, tyicuan caa ta Sutu yo ra nyaá andɨvɨ, cusaha ra tɨcahnu iñi chi maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vatyi tatu ma saha ndo tɨcahnu iñi chi ñu nyacuví cha ña vaha chihin ndo, tyicuan caa tucu Sutu yo, ma saha ra tɨcahnu iñi cuatyi maa ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ta catyí tucu ra Jesús chi ñu chicá noo chihin ra: ―Quɨvɨ cha ña chachí ndo ta nanducú ndo chi Nyoo, ma cuihya nyehe ndo, tari ñu savahá chii. Vatyi cuñí ñu cha coto ñáyɨvɨ vatyi ña chachí ñu ta nanducú ñu chi Nyoo. Soco catyí chi ndo vatyi yucuan ri ñihi ñu. Ñahri ca cuñihi ñu nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Soco tatu nya quɨvɨ ña chachí ndo ta nanducú ndo chi Nyoo, na̱catya ndo nuu ndo. Ta na̱cuaca ndo cuca xiñi ndo, ");
INSERT INTO mxtNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tacuhva vatyi ma tuvi iñi ñáyɨvɨ vatyi ña chachí ndo ta nanducú ndo chi Nyoo. Tyicuan ta noo tuhun maa Nyoo nyehe ra cha sacuví ndo cha xehe ri cuan. Ta cuaha ca cha vaha cua cuhva ra chi ndo chihin nuu ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ma sacaya ndo cha tyayɨɨ ihya ñayɨvɨ̱. Vatyi coto tɨvɨ cha tyayɨɨ cuan. O cuví tucu quɨhvɨ ra suhu, ta suhu ra tandɨhɨ cha tyayɨɨ ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vaha taxin ca sa̱caya ndo cha vaha chi ndo nu nyaá Nyoo gloria. Vatyi nuu Nyoo ña ndɨhɨ cha vaha cuan. Vatyi nɨ ri ra suhu, nɨ quɨtɨ, yori cha satɨvɨ iyó yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta catyí chi ndo vatyi nu nyaá cha tyayɨɨ ndo, yucuan cuví nu nyaá xiñi ndo. Ta yucuan cunyaa añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Chɨtɨ nuu ndo noo cha sandundichin ityi cuahan ndo cuví. Ta tyicuan caa tucu añima ndo, tatu iyó cha ndichin Nyoo, vaha ñáyɨvɨ cuví ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Soco tatu ña vaha chɨtɨ nuu ndo, ña ndichin nyehe ndo nu cuahan ndo. Tandɨhɨ ri ta ñaa iñi. Ta tyicuan caa tucu tatu ñahri cha ndichin Nyoo nyaá añima ndo, tari noo ra cuaa cuví ndo. Ña cuví nyehe ndo ityi vaha cha cuahan nu nyaá Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Noo musu ma cuvi coo uvi chitoho ra. Vatyi musu cuan cuñí ca ra chi noo ra ta ñima ca chi inga ra. Ta quichahá ra chi noo ra, ta chi inga ra ma quichaha ra. Ta tyicuan caa tucu nyoho, ma cuvi cuñi ndo chi Nyoo, ta suri cuhva cuan cuñí ndo cha tyayɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Yucuan chaha catyí chi ndo vatyi ma caca xaan iñi ndo yoso caa ñihi ndo cha cachi ndo ta cha coho ndo. Nɨ ma caca iñi ndo ñáá cha cuihno ndo. Vatyi yahvi ca nyaá añima ndo ta coño ñuhu ndo nuu Nyoo, ican saha cha cachi ndo ta cha cuihno ndo. Vatyi maa ra chahá ra ñayɨvɨ̱ coo ndo. Ta ña yɨɨ cuhva ra inga cha chiñuhú chi ndo ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sa̱ha ndo cuenda chi saa. Ña savahá tɨ itu. Ta ña sahá tyiño tɨ. Nɨ ri ña naquehén vaha tɨ tyiño sahá tɨ chichi yaca. Soco Sutu yo Nyoo chahá ra cha cachi tɨ. ¿Atu ña yahvi ca nyaá nyoho nuu Nyoo ta ñima ca saa cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɨ ri maa chicá xaan xiñi ndo ma cuvi sandusucun ndo nɨ chiin ca chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ta tatu ni chiin cuan ña cuví chi ndo, ¿ñáá tuhun cha chicá xaan xiñi ndo tuhun sahma ndo? Sa̱ha ndo cuenda yoso caa iyó tu ita nu chiqui. Vatyi ña taví tun. Ta nɨ ña conó tun isa. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Soco catyí chi ndo vatyi nɨ rey Salomón cha tyayɨɨ xaan cuvi̱ ra, soco ña cuvi̱ cuihno ra cha tyaquɨ, tari cha sacuihnó Nyoo chi tu ita cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta tu ita cuan tyaqui xaan ñihno tun suhva ri quɨvɨ ta yaha cuan ta cuna ityi tun ta cucayu tun chichi horno. Ta nyoho, vaha ca cusacuihno Nyoo chi ndo. Soco chiin xaan chinó iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yucuan chaha ma caca xaan xiñi ndo ta catyí ndo: “¿Ñáá cha cachi ndi, o ñáá cha coho ndi, o ñáá cha cuihno ndi?” ");
INSERT INTO mxtNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vatyi ñáyɨvɨ cha ñahri tuhun Nyoo caá añima, chicá xaan xiñi ñu tuhun ihya. Soco nyoho ma caca iñi ndo tuhun cuan vatyi iyó noo Sutu ndo, ra nyaá andɨvɨ. Ta chitó ra ñáá ndɨhɨ cha chiñuhu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yucuan chaha, cu̱nyaa xiñi ndo maa maa ri maa tuhun maa Nyoo. Ta ndu̱cu ndo cuhva cunyaca ñaha ra añima ndo. Ta sa̱cuvi ndo tari cuhva cuñí maa ra. Ta tyicuan caa ñihi ndo tandɨhɨ cuii maa cha chiñuhú chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tandɨhɨ quɨvɨ ta iyó tɨndoho chi ndo. Ma caca xiñi ndo tuhun tɨndoho cha vachi. Vatyi Nyoo nyaá ra chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ma cahan ndo cha caá inga ñáyɨvɨ. Tyicuan caa ta ma tɨɨn Nyoo cuenda cha caá ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vatyi tari cuhva cahán ndo cha caá inga ñu, tyicuan caa cuhva cutachi tuñi Nyoo chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Yoso caa cha cuví nyehun cuatyi luhlu ra yañun ta ña cuví nyehún cuatyi cahnu cha iyó chi maun? ");
INSERT INTO mxtNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tatu chɨtɨ nuu maun yɨhɨ́ noo vitu cahnu, ¿yoso caa cuví catyun chi ra yañun: “Nya̱ca, na tave mihin lee cha yɨhɨ́ chɨtɨ nuun”? ");
INSERT INTO mxtNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yoho cha savahún chuun, ta̱va xihna vitu cahnu cha yɨhɨ́ chɨtɨ nuu maun, tyicuan ta cuvi nyehe vahun mihin lee cha cutavon chɨtɨ nuu ra yañun. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ma sañihi ndo cahan ndo tuhun Nyoo chihin ñu ña cuñí coto, vatyi coto cañi ñu chi ndo. Tari ina cha tɨɨn vavaha chi ndo, tyicuan caa cuví ñu. Ta tari quɨnɨ cha chaca chaha tɨ cha yahvi nyaá, tyicuan caa cahán ña vaha ñu sɨquɨ tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ca̱can ndo cha chiñuhú chi ndo chi Nyoo. Ta cuhva ra chi ndo. Na̱nducu ndo, ta nañihi ndo. Sa̱cachan ndo yuvehe, ta nuña. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vatyi tandɨhɨ ndo cha chicán ndo, ñihi ndo. Tatu nanducú ndo, nañihi ndo. Ta tatu sacachán ndo yuvehe, cunuña yuvehe. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Tyicuan caa tucu nyoho cha iyó sehe ndo. Chahá ndo cha vaha chi sehe ndo. Ña tuhvá ndo chaha ndo noo yuu chi sehe ndo, tatu chicán ndotyin pan chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ta ña tuhvá ndo chaha ndo noo coo chi sehe ndo tatu chicán ndotyin noo tiyaca chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyoho cha quiñi iyó ndo soco chitó ndo yoso caa cuhva ndo cha vaha chi sehe ndo. Ta vihi ca Sutu yo, ra nyaá andɨvɨ. Cuaha ca cha vaha cuhva ra chi ndo tatu cacan ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Tari cuñí maa ndo cha cunyacuvi ñáyɨvɨ cha vaha chihin ndo, tyicuan caa cunyacuvi tucu maa ndo cha vaha chihin ñu. Vatyi tyicuan caa catyí tuhun cha tachi̱ Nyoo, cha tyaa̱ ra Moisés ta ra cacuvi̱ profeta Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ndu̱cu ndo cuhva quɨhvɨ ndo yuvehe tɨhɨn. Vatyi quehen yuvehe, ta quehen ityi cha cuahan nya nu cunaa ñáyɨvɨ anyaya. Ta cuaha xaan ñu cuahan ityi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Soco tɨhɨn yuvehe ta cuɨñɨ ityi cha cuahan ñayɨvɨ̱ cha ma naa ca maa nu cucoo ñáyɨvɨ vaha. Soco suhva ri ñáyɨvɨ nañihí ityi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Sa̱ha ndo cuenda chi ra cuendu. Vatyi cacatyí ra vatyi cuenda Nyoo cahán ra. Soco ña ndicha. Vatyi vachi coyo ra tari noo mbee nu nyicú ndo. Sahá ra tyi ra vaha cacuví ra. Soco tari noo ñaña xaan cacuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nyoho cuví nɨcohón nuu ndo chi ra chihin cha nyacuví ra. Tari noo yutun ña vaha, tyicuan caa cacuví ra. Vatyi noo tuñiyaca ma cuhva tun mango, ta nɨ ri noo iñu nduhva ma cuvi cuhva chi tɨchaha ndɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ta tyicuan caa tucu tandɨhɨ yutun vaha. Chahá tun chɨtɨ vaha. Ta tandɨhɨ yutun ña vaha, chahá tun chɨtɨ ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ta yutun vaha, ma cuvi cuhva tun chɨtɨ ña vaha. Ta nɨ ri yutun ña vaha ma cuvi cuhva tun chɨtɨ vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta tandɨhɨ yutun cha ña chahá chɨtɨ vaha, cahnya yo chi tun. Ta cahmi yo chi tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ta tyicuan caa, chihin cha nyacuví ñáyɨvɨ cuví nɨcohon nuu ndo chi ñu tatu ñu vaha cuví ñu, o ñu ña vaha cuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ma tandɨhɨ ñu cha catyí chii: “Sutu Mañi yuhu, Sutu Mañi yuhu”, cuquɨhvɨ ñu nu nyacá ñaha Nyoo gloria. Ñu sacuví tandɨhɨ cha catyí maa Nyoo Suti, ican ñu cuan cuquɨhvɨ nu nyacá ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quɨvɨ cha cucutuñi chi ñáyɨvɨ, cuaha xaan ñu cucatyi ñu chii tyehe caa: “Sutu Mañi yuhu. Yuhu cahi̱n tuhun maun chihin ñáyɨvɨ. Ta chihin sɨvun tave̱ tatyi ña vaha cha yɨhɨ̱ añima ñáyɨvɨ. Ta cuaha xaan milagru savahi̱ chihin sɨvun”, cucatyi ñu chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","’Tyicuan ta yuhu cucatyi chi ñu: “Ña ñohó nui chi nyoho. Ca̱nyaha ndo nu nyaí. Vatyi nyoho sacuvi̱ ndo maa maa ri cha ña vaha.” ");
INSERT INTO mxtNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ihya catyí chi ndo, yóó cha chiñí tuhun cahín ta sacuví tari cuhva catyí; cuví ra tari noo ra chiñi tuñi cha savaha̱ ra vehe ra sɨquɨ cava. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta quichaha̱ coon savi. Ta cama xaan yuvi ndutya yaha̱. Ta ñihi xaan caa̱ tatyi. Soco ña cuvi̱ sanduva chi vehe cuan. Vatyi ñihi nanyaá sɨquɨ cava cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Soco yóó cha chiñí tuhun cahín, ta ña sacuví ra tari cuhva catyí; cuví ra tari noo ra tondo, cha savaha̱ ra vehe ra nu ñɨtɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta chaa̱ savi. Ta cama xaan yuvi ndutya yaha̱. Ta ñihi xaan caa̱ tatyi. Ta vehe cuan tañi tyehe ri nduva̱ ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuhva cha ndɨhɨ̱ cahan ra Jesús chihin ñáyɨvɨ, iyo xaan cuñi̱ ñu tuhun cha sañahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vatyi sañahá ra tari noo ra cha nyacá ñaha. Ta ña sañahá ra tari ra sacuahá cuenda ley vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuhva cha noo̱ ra Jesús yucu cuan, cuaha ñáyɨvɨ nyicón chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta chaa̱ noo ra cha tyahyú coño, ta chicuɨñɨ̱ chɨtɨ ra nuu ra, ta catyí ra chi ra: ―Sutu Mañi yuhu, tatu yoho ta cuñún, cuví sanduvahun chii ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tyicuan ta sanacaa̱ ra Jesús ndaha ra ta tɨɨ̱n ra chi ra, ta catyí ra: ―Cuñí sanduvahi chuun. Ta na nduvahun vityin ri ―catyí ra. Ta caa cuhva ri cuan ta nduvaha̱ nu tyahyu̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tyicuan ta quichaha catyí ra Jesús chi ra: ―Nye̱he, yori chihin cahun tuhun. Soco cua̱han, ta sa̱ñahun chuun chi tata sutu, ta cu̱hva cuendon ofrenda cha catyi̱ ra Moisés nu ley chahnu vatyi tacuhva coto ñu vatyi cha nduvahu̱n. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cuhva cha chaa̱ ra Jesús Capernaum, noo capitán, ra ñuu Roma, chaa̱ ra nu nyaá ra Jesús ta chacu̱ ndahvi ra nuu ra, ");
INSERT INTO mxtNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ta catyí ra: ―Sutu Mañi yuhu, musi catuví ra nu cama. Cuhví ra. Ña cuví nducuita ra vatyi ñihi xaan tahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta catyí ra Jesús chi ra: ―Cuhun mai ta cusanduvahi chi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nacaha̱n capitán cuan ta catyí ra: ―Sutu Mañi yuhu, ña nañé cha cuhun vehi; soco tacuhva catyi run, ta musi nduvaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vatyi suri iyó ra nyacá ñaha chi mai. Ta iyó sɨndaro nyacá ñaha tucu mai. Ta tatu cha tave tyiño chi noo ra, cuhun ra. Ta tatu cane chi inga ra, quichi ra. Ta tatu cha tave tyiño chi musi, sacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ta cha chiñi̱ ra Jesús cha caha̱n ra, iyo xaan cuñi̱ ra. Ta catyí ra chi ñu nyicón chi ra: ―Cha ndicha catyí chi ndo, vatyi ñuu cha nyicú nicahnu Israel, ta nañihi que ni noo ñáyɨvɨ cha chinó xaan iñi ñu tari chinó iñi ra ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta catyí chi ndo vatyi cuaha ñu inga ñuu cuquichi coyo ityi nu caña ñanyii, ta ityi nu quee ñanyii, ta cunyicu ñu cachi ñu chihin ra Abraham ta ra Isaac ta ra Jacob nya andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ta ñu Israel cha tahán chi cuhun andɨvɨ, yɨhɨ́ ñu, ma cuhun ñu, vatyi cuhun ñu nu ñaa iñi ityi chata. Ta yucuan cucuacu chaa ñu ta cucahñi noho ñu ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tyicuan ta quichaha catyí ra chi capitán cuan tyehe caa: ―Cua̱han, ta na cuvi chi tari cuhva catyu̱n vatyi chinó xaan iñun chii ―catyí ra. Ta suri cuhva cuan nduvaha̱ musu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ta cha yaha̱ cuan, chaa̱ ra Jesús vehe ra Pedro. Ta nanyehe̱ ra chi maha tyiso ra Pedro, catuví ña nu chito chihin cahñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ta tɨɨ̱n ra ndaha ña, ta quita̱ cahñi cuan chi ña. Ta ndɨcuita̱ ña, ta quichaha̱ tyiñuhu ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ta cuhva cha cuaa cuan, quichi̱ nyaca ñu cuaha xaan ñáyɨvɨ yɨhɨ́ tatyi ña vaha chi chi ra Jesús. Ta chihin noo ri tuhun caha̱n ra, tava̱ ñehe ra chi tatyi ña vaha cuan, ta sanduvaha̱ ra chi tandɨhɨ ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tyicuan caa cuvi̱ tacuhva vatyi na chino cava tari cuhva catyi̱ ra profeta Isaías, quɨvɨ catyi̱ ra tyehe caa: “Maa ra quehe̱n ra cuehe cha yɨhɨ́ chi yo, ta tinyaa̱ ra cha uhvi chi yo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tyicuan ta nyehe̱ ra Jesús vatyi nicachico nu nyaá ra nyicú ñáyɨvɨ. Ta catyi̱ ra chi ñu vatyi cuyaha ra inga chiyo miñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tyicuan ta chaa̱ noo ra sacuaha ley vehe ñuhu ta catyí ra chi ra: ―Maestro, cuñí cunyiquen chuun tandɨhɨ ri ityi nu cuhun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta ra Jesús catyí ra chi ra: ―Ñaña, iyó vehe tɨ, ta saa cha chicó nu tatyi, iyó taca tɨ. Soco yuhu Rayɨɨ cha quichi̱ nya gloria, ñahri vehi ta nɨ ri nu cava xiñi ta ñahri ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inga tucu ra chicá noo chihin ra catyí ra chi ra: ―Tata, cu̱hva na cuhun xihne cutyihi chi suti chichi ñuhú, tyicuan ta quichi ta cunyiquen chuun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta catyí ra Jesús chi ra: ―Ña̱ha yoho vatyi cunyicon chii. Sa̱ña chi ñu ña ñohó nuu chi Nyoo, na tyihi maa ñu chi tahan ñu chichi ñuhú ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tyicuan ta quɨhvɨ̱ ra chichi canoa, ta ra cachicá noo chihin ra, cuahan coyo ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ta chaa̱ noo tatyi ñihi xaan nu miñi cuan, ta nyacua chasɨ́ ndutya cuan canoa ra soco maa ra Jesús quixí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta ra cachicá noo chihin ra sandoyo̱ ra chi ra, ta cacatyí ra: ―¡Sutu Mañi yuhu, sa̱cacu chi yo, vatyi cuñí cunaa yo! ");
INSERT INTO mxtNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta catyí ra Jesús chi ra: ―¿Ñáá tuhun cha yuhví xaan ndo? ¡Nyoho chiin xaan chinó iñi ndo chii! Tyicuan ta nacanda̱ ra ta sacutaxi̱n ra tatyi nu miñi cuan, ta tandɨhɨ cutaxi̱n. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ta iyo xaan cacuñí ra cuan ta cacatyí ra: ―¿Yóó ra cuví ra ihya? Vatyi nyacua nya tatyi ta nyacua nya ndutya ta quichahá chi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tyicuan ta chaa̱ coyo ra inga chiyo miñi cha nyaá ñuhú cha nañí Gadara. Ta chaa̱ coyo uvi tahan ra yɨhɨ́ tatyi ña vaha chii. Ta nu ñaña caquita̱ coyo ra cuan. Xaan vavaha ra, ta yori maa cuví yaha ityi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ta canachaá ra, ta cacatyí ra: ―¿Ñáá cha cuñún chihin ndi, yoho Jesús Sehe Nyoo? ¿Atu vachun vachi sanyehun tɨndoho chi ndi cha ni cumañi ca chaa quɨvɨ? ―cacatyí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta yatyin ri cuan nyicú cuaha quɨnɨ cachachí tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta catyí tatyi ña vaha cuan chi ra Jesús: ―Tatu cuatava ñehun chi ndi, cu̱hva cha quɨhvɨ ndi chichi quɨnɨ cuan ―cacatyí tatyi ña vaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Vaha. Quɨ̱hvɨ ndo ―catyí ra Jesús. Ta caquita̱ coyo tatyi ña vaha cuan, ta quɨhvɨ coyo chichi tandɨhɨ quɨnɨ canyicú cuan. Ta tandɨhɨ quɨnɨ cuan cachino̱ tɨ ta canacoyo tɨ noo xahva yuhu miñi cuan, ta chihi̱ tɨ chihin ndutya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tyicuan ta ra casaha̱ cumi chi tɨ cuan, cachinó vavaha ra cuahan coyo ra chichi ñuu, ta canacatyi̱ ra tandɨhɨ cha cuvi̱ chi ra cayɨhɨ̱ tatyi ña vaha cuan chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ta tandɨhɨ ñáyɨvɨ ñuu, chaha̱n ñu chinyehe̱ ñu chi ra Jesús, ta chacu̱ ndahvi ñu nuu ra na quita ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tyicuan ta quɨhvɨ̱ ra Jesús chichi canoa ta yaha̱ sava ra inga chiyo miñi, ta nachaa̱ ra nya ñuu nu iyó ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nu nyaá ra yucuan chinyaca̱ ñáyɨvɨ chi noo ra cuhví cha ña cuví nacanda catuví ra nu chito. Ta cha nyehe̱ ra Jesús vatyi chinó xaan iñi ñu chi ra, quichaha catyí ra chi ra cuhví cuan: ―Sa̱nɨɨ iñun, suti vatyi cha chicoo̱ tɨcahnu iñi cuatyun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tyicuan ta quichaha̱ chica xiñi suhva ra sacuahá ley vehe ñuhu cha nyicú yucuan tyehe caa: “Ra ihya chicoo̱ cuatyi ra nu Nyoo chihin tuhun cahán ra”, cachicá xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Soco ra Jesús chitó ri ra ñáá cha cachicá xiñi ra, ta catyí ra chi ra: ―¿Ñáá tuhun cha ña vaha maa chicá xiñi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Vatyi ¿nya cha yɨɨ ca catyí yo: atu yɨɨ ca catyí yo “Cuatyun cha yaha ndachi”, o yɨɨ ca catyi yo: “Ndɨ̱cuita ta ca̱con”? ");
INSERT INTO mxtNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vaha. Cuasañahi chi ndo vatyi yuhu Rayɨɨ cha quichi nya gloria, iyó ityi chii sɨquɨ ñuhu ñayɨvɨ̱ ihya vatyi sahi tɨcahnu iñi cuatyi ―catyí ra Jesús. Tyicuan ta catyí ra chi ra cuhví cuan: ―Ndɨ̱cuita, na̱quehen chiton ta cua̱nuhu nya vehun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tyicuan ta ndɨcuita̱ ra cuhví cuan ta cuanuhu̱ ra nya vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cuhva cha nyehe̱ ñáyɨvɨ tuhun ihya, canayuhví ñu. Ta casacahnú ñu chi Nyoo vatyi chaha̱ ra tunyee iñi cuan chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Quita̱ ra Jesús yucuan, ta nanyehe̱ ra chi noo ra cha nañí Mateo, nyaá ra quehen ra xuhun cha tyiyahví ñu Israel chi gobiernu ñuu Roma. Ta catyí ra chi ra: ―Co̱ho chihin. Tyicuan ta ndɨcuita̱ ra Mateo ta tyinyico̱n ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tyicuan ta cuvi̱ chi noo chaha ra Jesús nyaá ra nya vehe ra Mateo, chachí ra. Ta cachaa̱ coyo cuaha ra catavá xuhun cuenda gobiernu ñuu Roma ta inga ca ra ca iyó cuatyi. Ta cachicunyicú tucu ra yucuan nu mesa ɨɨn ri chihin ra Jesús ta ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Soco cha canyehe̱ ra fariseo cha tyicuan caa, candaca̱ tuhun ra chi ra cachicá noo chihin ra Jesús, ta cacatyí ra: ―¿Ñáá tuhun cha vatyi ra sacuahá chi nyoho chachí ra chihin ra catavá xuhun cuenda ra nyacá ñaha nya Roma ta chihin ra ca iyó cuatyi? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chiñi̱ ra Jesús cha caha̱n ra, ta catyí ra chi ra: ―Ña chiñuhú doctor chi ñu iyó vaha, ñu ña cuhví, soco chi ñu cuhví chiñuhú ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cua̱han ndo ta cu̱tuhva ndo cha cuñí chi catyi nu tutu Nyoo, nu catyí ra tyehe caa: “Yuhu cuñí vatyi cundahvi cuñi ndo chi ñáyɨvɨ, ta ñima ca cha cahñi ndo quɨtɨ ta cuhva cuenda ndo chii.” Ña vachi na cane chi ñu vaha, soco chi ñu iyó cuatyi, tacuhva na nasama ñu cuhva iyó ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tyicuan ta ra canyicón chi ra Juan, ra sacondutya chi ñáyɨvɨ, catuhva̱ ra chi ra Jesús ta candaca̱ tuhun ra chi ra ta cacatyí ra: ―¿Ñáá tuhun cha nyuhu ta ra cacuví fariseo, cuaha xaan chaha savaha ndi ayuno, ña chachí ndi ta nanducú ndi chi Nyoo? ¿Ta ra cachicá noo chihin yoho ñima tyicuan caa sacuvi ra? ―cacatyí ra nyicón chi ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ta nacaha̱n ra Jesús ta catyí ra: ―¿Atu cuví cunyaa cuihya ñu nyicú vico cha nɨ ri ca cha nyaá ra cua tandaha chihin ñu? Soco vachi quɨvɨ vatyi cucuachiyo ra nu nyicú ñu, tyicuan ndicha ta cusavaha ñu ayuno. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Yori naquicú noo vestido chahnu chihin noo sahma chaa vatyi coto cundɨyɨ nu naquicu̱ ñu chihin cha chaa cuan, ta cahnya chi cha chahnu cuan, ta nu tahnya cuan nducahnu ca. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta ni ña tyihí yo vinu chaa chichi ñɨɨ chahnu vatyi tatu sacuvi yo tyicuan caa, tahnya ñɨɨ cuan, ta tari cunaa vinu, ta cunaa ñɨɨ cuan. Yucuan chaha cuñí chi tyihi yo vinu chaa chichi ñɨɨ chaa, ta tyicuan ta nɨnduvi ta cusaha cuenda chi chi tahan chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cha nɨ ri ca cha catyí ra Jesús tuhun ihya, chaa̱ noo ra cuví nuu chi ñu Judea ta chicuiñi̱ chɨtɨ ra nuu ra Jesús, ta catyí ra: ―Ni chihi̱ sehi, soco tatu yoho quichun ta tyison ndahun sɨquɨ ña, cunandoto ña ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ndɨcuita̱ ra Jesús ta cuahan ra ɨɨn ri chihin ra ta ra cachicá noo chihin ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tyicuan ta noo ñaha, cuhví ña chihin cha chatɨ nɨñɨ ña. Ta cha uchi uvi cuiya cuhví ña. Ta tuhva̱ ña chi ra Jesús ityi chata ra, ta tɨɨ̱n ña yuhu sahma ra, ");
INSERT INTO mxtNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","vatyi tyehe caa chicá xiñi ña: “Ma chihin cha tɨɨn ri sahma ra ta nduvahi”, chicá xiñi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Soco ra Jesús nanyocava̱ ra nanyehe ra chi ña, ta catyi ra chi ña: ―Ndunɨɨ iñun sɨhi, cha nduvahu̱n vatyi chinó iñun ―catyí ra. Ta caa cuhva ri cuan ta nduvaha̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yaha̱ cuan ta chaa̱ ra Jesús vehe ra cuví nuu cuan, ta nyehe̱ ra vatyi ra música canyatú tuhva ra cha cuhun coyo ra nu quɨhvɨ cue chichi ñuhú. Ta ñáyɨvɨ cha nyicú cuan chacú chaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta catyí ra chi ñu: ―Qui̱ta ndo ihya. Ñaha tyivaa ihya, ña chihi̱ ña, soco quixí ña ―catyí ra. Ta chacú cuehe ri ñáyɨvɨ nyehe ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Soco ra Jesús tava̱ ra chi ñu ityi chata vehe, tyicuan ta quɨhvɨ̱ ra ta tɨɨ̱n ra ndaha ñaha tyivaa cuan, ta maa ña ndɨcuita̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta tandɨhɨ ityi cuan chitya̱ tuhun cha cuvi̱ yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cuhva cha quita̱ ra Jesús yucuan, uvi tahan ra cuaa canyicón chi ra suri caná chaa ra ta cacatyí ra: ―¡Cu̱ndahvi cuñi chi ndi, yoho ra vachi tata ra David! ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ta cuhva cha quɨhvɨ̱ ra Jesús chichi vehe, ra cuaa cuan, catuhva̱ ra chi ra, ta maa ra Jesús quichaha ndaca̱ tuhun ra chi ra: ―¿Atu chinó iñi nyoho vatyi cuví sanduvahi chi ndo? ―catyí ra. Ta canacaha̱n ra ta catyí ra: ―Ay, chinó iñi ndi chuun, Sutu Mañi yuhu ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tyicuan ta tɨɨ̱n ra Jesús chɨtɨ nuu ra ta catyí ra chi ra: ―Na cuvi maa yoso cuhva chinó iñi ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ta canduvaha̱ chɨtɨ nuu ra. Ta catyí vaha ra Jesús chi ra tyehe caa: ―Ndu̱cu ndo cuhva cha yori coto. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Soco quita̱ coyo cuiri ra ta quichaha canacatyi̱ ra cha sacuvi̱ ra Jesús chihin ra chi ñáyɨvɨ tandɨhɨ ityi yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cha nɨ ri ca cha caquita̱ coyo ra cucuaa cuan, suhva ñáyɨvɨ quichi̱ nyaca ñu chi noo ra ñɨhɨ́ cha yɨhɨ́ noo tatyi ña vaha chi nu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta caa cuhva ri cha tava̱ ñehe ra Jesús tatyi ña vaha cuan, quichaha̱ cuvi cahan ra cuan. Ta iyo xaan cuñí ñáyɨvɨ, ta catyí ñu: ―Ni noo chaha ta cuvi ca cha tyehe caa Israel Ihya ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Soco ra cacuvi fariseo, cacatyí ra: ―Ra ihya tavá ñehe ra tatyi ña vaha chihin tunyee iñi chi cuihna ra cuví nuu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ra Jesús chaha̱n ra tandɨhɨ ñuu sañahá ra chi ñáyɨvɨ chichi vehe ñuhu tahan tahan ñuu. Cahán ra tuhun Nyoo yoso caa nyacá ñaha Nyoo añima ñáyɨvɨ. Ta sanduvahá ra tandɨhɨ nuu cuehe cha yɨhɨ́ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta cha nanyehé ra chi ñáyɨvɨ, cundahvi cuñí ra nyehé ra chi ñu, vatyi nyehé ñu tɨndoho ta cuihya cuñí ñu, tari mbee quɨtɨ cha yori sahá cumi chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tyicuan ta catyí ra chi ra cachicá noo chihin ra tyehe caa: ―Cha ndicha, cuaha tyiño iyó, soco ra sahá tyiño, ña cuaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yucuan chaha, ca̱can ndo chi chitoho tyiño yucuan, na tachi ra chi ra saha tyiño na sataca ra tyiño cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tyicuan ta cana̱ ra Jesús chi ndɨ uchi uvi ra chicá noo chihin ra ta chaha̱ ra ityi chi ra vatyi tava ñehe ra chi tatyi ña vaha cha yɨhɨ́ añima ñáyɨvɨ, ta sanduvaha ra ndɨhɨ nuu cuehe ta cha uhvi ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ican ihya cuví sɨvɨ ndɨ uchi uvi ra chicá tyiño ra: xihna ca, ra Simón, cha nañí tucu Pedro, ta yañi ra, ra Andrés, ra Jacobo ta yañi ra, ra Juan, sehe ra Zebedeo cacuví chi ra; ");
INSERT INTO mxtNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ta ra Felipe, ra Bartolomé, ra Tomás, ta ra Mateo ra tava̱ xuhun cuenda gobiernu ñuu Roma, ra Jacobo sehe ra Alfeo, ra Lebeo cha nañí tucu Tadeo, ");
INSERT INTO mxtNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ta ra Simón cha yɨhɨ́ cuenda ityi ra cacuñí cuhun cuatyi sɨquɨ gobiernu ñuu Roma cha nyacá ñaha chi ñu, ta ra Judas Iscariote, ra cha naxico̱ tuhun chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ta tyehe caa tachi̱ ra Jesús chi uchi uvi tahan ra cuan, ta catyí ra: ―Ma cuhun ndo nu iyó ñu cha ñima ñu Israel cuví, ta ni ma quɨhvɨ ndo ñuu cha nyicú Samaria. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cua̱han ndo, soco nu nyicú mbee cha cuanaa cha cuví ñu ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cua̱han ndo cuacahan ndo tuhun vatyi cha chaa̱ cha cunyaca ñaha Nyoo añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sa̱nduvaha ndo chi ñu cuhví ñu tyahyú coño, ta ñu yɨhɨ́ inga cuehe chii. Sa̱nandoto ndo ndɨyɨ, ta̱va ñehe ndo chi tatyi ña vaha cha yɨhɨ́ chi ñu. Nyoho, naquehén cuenda ndo tunyee iñi ihya chihin cha ñahri yahvi, ta co̱tyiño ndo soco ma quehen ndo yahvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ma cuiso ndo ni noo xuhun, ni xuhun cuaan ni xuhun cuichin, ni xuhun cuaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma cuiso ndo ni yono cha cuenda cha caca ityi ndo. Noo ri camisa cha ñihnó ndo cuhun chihin ndo. Ta ma cuiso ndo inga ityi ndichan, ni yutun ma tuvi ndo, vatyi ra sahá tyiño, iyó ityi chi ra cha coo yahvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cuhva cha chaa ndo noo ñuu, ndu̱cu ndo noo ñáyɨvɨ cachi iyó, ta ndo̱o ndo vehe ñu nyacua nya quita ndo ñuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuhva cha cua quɨhvɨ ndo noo vehe, cu̱hva ndo nocumi chi ñáyɨvɨ iyó vehe cuan. Ta ca̱tyi ndo chi ñu: Na coo cha taxi Nyoo añima ndo, ca̱tyi ndo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta tatu ñu ñuu cuan ta nacotó ñu tyi chiñuhú cha taxi ri cuan chi ñu, cundoo cuan chihin ñu. Soco tatu ña nacotó ñu vatyi chiñuhú cuan chi ñu, ma ndoo cuan chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta tatu ña cuñí ñu quehen cuenda ñu chi ndo, ta ni ña cuñí ñu cuɨñɨ ñu tuhun cahán ndo, tyicuan ta qui̱ta ndo vehe yucuan, o ñuu yucuan, ta naquɨsɨ ndo ñiyaca chaha ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cha ndicha catyí chi ndo vatyi quɨvɨ cutuñi chi ñáyɨvɨ, ñihi ca cutachi tuñi Nyoo chi ñu cuan, ta ñima ca ñáyɨvɨ ñuu Sodoma ta ñuu Gomorra. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Nye̱he ndo! Yuhu tachí chi ndo, tari mbee mahñu lobo. Quɨyɨ sa̱ha ndo chi ndo, tari coo, soco masu sa̱ha ndo chi ndo tari paloma. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sa̱ha ndo cuenda chi ndo vatyi ñáyɨvɨ cucuhva cuenda ñu chi ndo chi ra cuví tyiño, ta chichi vehe ñuhu cucañi ñu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta cha cuenda yuhu, nyacua cunyaca ñu chi ndo nuu gobiernu ta nuu rey. Ta tyicuan caa ta cuví cahan ndo tuhin nuu ra ta nuu ñu cha ñima ñu Israel cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Soco tatu nacuhva cuenda ñu chi ndo chi ra cuví tyiño, ma caca xiñi ndo yoso caa cucahan ndo, vatyi tatu chaa cuhva cha cahan ndo, Nyoo cucuhva ra tuhun cha cucahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Vatyi ñima maa ndo cucahan, soco maa Tatyi Ii Sutu yo Nyoo cusacahan chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Rayɨɨ cunaxico tuhun ra suri chi yañi ra tacuhva na cacahñi ra chi ra. Ta yɨhɨ́ ra cunaxico tuhun ra chi sehe ra. Ta yɨhɨ ñáyɨvɨ cunanuhu ñu sɨquɨ sutu ñu ta sɨhɨ ñu, ta cusacuvi ñu, na cúvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tandɨhɨ ñáyɨvɨ, cucutasɨ cuñi nyehe ñu chi ndo cha catyi yuhu. Soco tatu ña ndu uvi iñi ndo chino iñi ndo chii, tyicuan ta cucacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tatu chica nyicon ñu chi ndo noo ñuu, cono ri ndo inga ñuu. Vatyi cha ndicha catyi chi ndo ni cha ta ndɨhɨ ca cahan ndo tuhun Nyoo tandɨhɨ ñuu nu nyicu ñáyɨvɨ Israel ta yuhu Rayɨɨ cha quichi nya gloria cuquichi inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ni noo ra cutuhvá, ña cahnu ca ra cuví ra ican saha ra sacuaha chi ra. Ta ni noo musu, ña cahnu ca cuví ra ican saha chitoho ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ra cutuhva, cuñí chi ndoo ra vaha cha chaa ra cuvi ra tari ra sacuaha chi ra, ta musu tari chitoho ra. Tatu yuhu ra cuví chitoho vehe, catyí ñu chii vatyi Beelzebú, cuihna ra cuví nuu, cuví, suri tyicuan caa cucatyi tucu ñu chi ñáyɨvɨ cuende. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Yucuan chaha ma yuhvi ndo chi ñáyɨvɨ, vatyi ni noo tuhun xehe ta cuñun, tyi ma natuvi. Ta ni ñahri cha ñohó xehe, ta cuñún tyi ma coto tandɨhɨ ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tandɨhɨ cha catyí chi ndo nu ñaa iñi, ca̱tyi nyoho nu ndichin. Ta tandɨhɨ cha catyi chi ndo nu xehe, ca̱na chaa ndo nya xiñi vehe, na coto tandɨhɨ ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma yuhvi ndo chi ñu chahñí coño ñuhu yo, vatyi ma cuvi cahñi ñu añima yo. Soco yu̱hvi ndo chi ra cuví sanaa coño ñuhu yo ta añima yo chichi anyaya ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Atu ñima chihin noo xuhun luhlu ri, sata yo uvi tahan saa? Ican. Soco ni noo tɨ ña canacava tɨ nu ñuhú tatu ña catyí maa Nyoo Sutu yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vatyi nyacua nya ixi xiñi nyoho ta chitó Nyoo yoso tahan nyaá. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ma yuhvi ndo. Nyoho, yahvi ca nyaá ndo ta ñima ca tɨcuɨtɨ saa. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Tandɨhɨ ñu cha cahán vaha tuhin nuu ñáyɨvɨ, yuhu tucu cucahan vahi cuenda ñu nuu Suti ra nyaá andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Soco ñu cahán nuu cahan tuhin, yuhu tucu ma cahin tuhun ñu nuu Suti ra nyaá andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ma cuñi ndo vatyi yuhu vachi cuhve cha taxi ri coo ndo sɨquɨ ñuhu ñayɨvɨ̱ ihya. Ña vachi cuhve cha taxi ri, soco cha cañi tahan ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vatyi sasɨín chi ndo. Vatyi noo ra cuhun ra sɨquɨ sutu ra. Ta noo ña cuhun ña sɨquɨ sɨhɨ ña. Ta ñu cuví chono cucañi tahan ñu chihin tyiso ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta tyicuan caa suri ñáyɨvɨ chi ndo cucuvi ñu ñu xaan iñi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ñu cha cuñí ca chi sutu o chi sɨhɨ ican saha chi yuhu, ña tahán chi cuví ñu ñu cuende. Ta ñu cuñí ca chi sehe, ican saha chi yuhu, ña tahán chi cuví ñu ñu cuende. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta ñu cha ña cuñí nyehe tɨndoho ta cunyicon ñu chii, ña tahán chi cuvi ñu ñu cuende. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Vatyi ñu ña cuñí nyehe tɨndoho cha cuenda yuhu, cunyehe ñu tɨndoho anyaya, soco ñu nyehé tɨndoho ta chahá ñayɨvɨ̱ cha catyi yuhu, cucacu añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ñu quehén cuenda chi ndo, chi yuhu quehén cuenda ñu, ta ñu quehén cuenda chi yuhu, quehén cuenda ñu chi ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ñu quehén cuenda noo ra profeta Nyoo cha cuenda vatyi cuenda Nyoo cahán ra, cuñihi ñu suri tahan yahvi cha cuñihi profeta cuan. Ta ñu quehén cuenda chi noo ra vaha cha cuenda tyi ra vaha cuví ra, suri tahán yahvi cha cuñihi ra vaha cuan cuñihi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta savahri ñu cha cuhva vasɨ noo vasu ndutya vichin coho ñu nyihi ihya cha cuenda cha nyicón ñu chii, cuñihi ñu cha cucuhva Nyoo chi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ndɨhɨ̱ chaha̱ ra Jesús tuhun chi uchi uvi ra chicá noo chihin ra, tyicuan ta quita̱ ra yucuan, vatyi cucahan ra tuhun Nyoo chihin ñáyɨvɨ cha iyó ñuu cha nyicú ityi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta ra Juan nu ñohó ra vehe caa, ñihi̱ ra tuhun cha sacuví ra Cristo. Tyicuan ta tachi̱ ra chi uvi ra nyicón chi ra, cundaca tuhun ra noo tuhun chi ra Jesús. Ta cachaa̱ coyo ra nu nyaá ra ");
INSERT INTO mxtNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta cacatyí ra chi ra: ―¿Atu yoho cuvún ra Cristo cha tahán chi quichi sacacu chi ndi, o cuñí chi cha cuatu ndi chi inga ra? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nacaha̱n ra Jesús ta catyí ra: ―Cua̱han ndo ta ca̱tyi ndo chi ra Juan cha nyehé ndo, ta cha chiñí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na̱catyi ndo chi ra yoso caa nanyehé ñu cuaa, yoso caa nacacá ñu coxo, ta ñu tyahyu coño yoso caa nduvahá ñu, ta yoso caa nacuɨñɨ ñu soho, ta ñu ndɨyɨ nandoto ñu, ta chihin ñu ndahvi cahán ndi tuhun Nyoo yoso caa sacacu ra añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","’Sɨɨ xaan cuñí ñu ña chicá uvi iñi nyicón chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuhva cha cuahan coyo ra, ra Jesús quichaha cahan ra tuhun ra Juan chihin ñáyɨvɨ, ta catyí ra: ―¿Ñáá cha chaha̱n nyoho chinyehe ndo chiqui ndɨɨ cuan? ¿Atu chinyehe̱ ndo noo ndoo cha naquɨsɨ́ tatyi? ¿Ñáá cha nyehe̱ ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Atu nyehe̱ ndo noo ra vaha ñihnó? Ñima. Nyoho chitó ndo vatyi ra ñihnó vaha, nyaá ra vehe rey. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tu tyicuan caa, ¿ñáá cha chaha̱n ndo chi nyehe ndo? ¿Atu noo ra cuví profeta? Ican. Soco noo ra cha cahnu ca cuví ican saha noo profeta cuenda Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vatyi ican ra Juan ihya, cuví cha cahán tuhun nu tutu Nyoo tyehe caa: Yuhu cuví Nyoo ta tachí chi noo ra cahan tuhin ityi nuu nu cuhun. Vatyi cucahan ra tuhun chihin ñáyɨvɨ nanasama ñu cuhva iyo ñu ta cuatu tuhva ñu quɨvɨ quichun. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Cha ndicha catyí chi ndo, vatyi chichi cha tandɨhɨ ñáyɨvɨ, ni noo chaha ta coo ca noo ra cahnu ca cuví ican saha ra Juan ra sacondutyá chi ñáyɨvɨ. Soco ra cha nyacá ñaha Nyoo añima, vasɨ cuví ra noo ra luhlu ca, soco cahnu ca ra ta ñima ca ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nyacua nya quɨvɨ cha chaa̱ ra Juan ta nya vityin, cuaha ñu ndachan sahá chii nducú satɨvɨ ñu tuhun Nyoo, ña cuñí ñu cha cunyacá ñaha Nyoo añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ra Moisés caha̱n ra tuhun yoso caa nyacá ñaha Nyoo añima ñáyɨvɨ, ta tyicuan caa tucu tandɨhɨ ra profeta nyacua nya quɨvɨ quichi̱ ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta tatu cuñí nyoho chino iñi ndo tuhun cahín, catyí chi ndo vatyi profeta Elías cha taha̱n chi quichi, ra Juan cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yóó ñu cha cutuñi iñi, na tyasoho ñu tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Yóó chihin sandu ɨnuu ri chi ñáyɨvɨ cha iyó tyembu ihya? Tari ra cuatyaa cuví ñu, vatyi chicunyaa ndotyin nuyahvi nyasɨquɨ ndotyin, ta canachaa ndotyin chi ra tahan ndotyin, ta catyí ndotyin tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tɨvɨ̱ ndi flauta, soco ña chita̱ chaha ndo. Chita̱ ndi yaa cuihya soco ña chacu̱ ndo.” Tyicuan caa tucu nyoho, ni noo cuhva ña tahán iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Vatyi quichi̱ ra Juan, cha ña chachi̱ ra ta ña chihi̱ ra, ta nyoho catyí ndo vatyi noo tatyi ña vaha yɨhɨ́ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yaha̱ cuan ta quichi̱ tucu yuhu Rayɨɨ cha quichi nya gloria. Ta yuhu chachí ta chihí tandɨhɨ, ta catyí ndo tyi ra cuahyɨ ra tuhvá chihi cuví. Ta ña tahán iñi ndo cha cutahín chihin ra iyó cuatyi ta ra tavá xuhun. Soco vasɨ ni noo ndi ña naquehén cuenda ndo tuhun cahán ndi, soco Nyoo chahá ra cha chiñi tuñi ra chi ñu naquehén tuhun cahin ta tuhun caha̱n ra Juan, ta maa ñu cusañaha chi ndo vatyi vaha cha chiñi tuñi Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tyicuan ta quichaha̱ cahan ra Jesús chi ñu ñuu nu sacuvi̱ ra cuaha milagru, vatyi ñáyɨvɨ cuan ña canasama̱ maa ñu cuhva iyó ñu, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ndahvi nyoho, ñu ñuu Corazin! ¡Ndahvi nyoho ñu ñuu Betsaida! Vatyi nyehé ndo nyatu cahnu ta ña nasama̱ ndo cuhva iyó ndo. Soco ñáyɨvɨ ñuu Tiro ta ñuu Sidón cha sanaa̱ Nyoo ta cha naha cha cuenda cuatyi ñu ñahri nyatu cahnu nyehe̱ ñu. Soco tyehe ta nyehe̱ ñu nyatu cahnu quɨvɨ cuan tari cha nyehé nyoho vityin, tañi tyehe ri ndɨhvɨ noo ñu sahma tucuihya iñi ta cunyaa ñu nu ñiyaa. Tari cuhva costumbre iyó maa ñu, noo seña vatyi ndu uvi iñi ñu cuatyi ñu cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Soco catyí chi ndo vatyi quɨvɨ cutuñi chi nyoho nuu Nyoo, cahnu ca cha uhvi cunyehe ndo ta ñima ca ñáyɨvɨ Tiro ta Sidón. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta nyoho ñu ñuu Capernaum, cuñí maa ndo tyi cundaa ndo nya andɨvɨ, soco cunoo ndo nya nu nyicú ñu ndɨyɨ. Vatyi tyehe ta cuvi̱ milagru ñuu Sodoma cuan, tahán cha cuvi̱ ñuu ndo, ñuu cuan coo ca nyacua nya vityin. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Soco catyí chi ndo vatyi quɨvɨ cutuñi chi nyoho, yaha ca cunyehe ndo tɨndoho, ta ñima ca ñu ityi ñuu Sodoma cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tyembu cuan catyi ra Jesús chi Nyoo tyehe caa: ―Sutu Mañi yuhu, Nyoo, ra nyacá ñaha andɨvɨ ta ñuhu ñayɨvɨ̱. Sacahní chuun vatyi sañahu̱n tuhun maun chi ñu ñahri maa chitó. Ta tixehu̱n tuhun maun chi ñu cha sahá tuhun tyi chitó xaan ta ñu chiñi tuñi ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ndicha Sutu Mañi yuhu, vatyi tyicuan caa cuñí maun. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tyicuan ta catyí tucu ra: ―Suti nacuhva̱ cuenda ra tandɨhɨ chii. Yori maa ñohó nuu noo cha ndicha chii, soco noo tuhun ri maa Suti ñohó nuu ra chii. Ta yori ñohó nuu noo cha ndicha chi Suti, soco noo tuhun ri mai, cha cuví Sehe ra chii, ñohó nui chi ra. Ta ñáyɨvɨ cha cuñí mai cha cohon nuu chi ra, ican ñu cuan cua cohon nuu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tandɨhɨ nyoho cha chitatu ndo cha sahá tyiño ndo, ta chihin carga cha nyisó ndo, qui̱chi ndo nu nyaí, ta yuhu cuhve cha nyitatu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cu̱hva ndo cha cunyaca ñahi chi ndo ta cu̱tuhva ndo cuhva iyó yuhu. Vatyi yuhu masu iñi ta cama iñi. Tyicuan caa ta ñihi ndo nu nyitatu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ña yɨɨ cha cuhva ndo chi ndo cha cunyaca ñahi. Ta carga cha chahí chi ndo, ñahma. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Noo quɨvɨ nyitatú ñáyɨvɨ, yaha̱ ra Jesús mahñu nu iyó cha tachi̱ ñu. Ta chaa̱ soco chi ra cachicá noo chihin ra. Ta quichaha catohon ra yoco trigu cuan ta quichaha cachachi ra chɨtɨ yoco cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cuhva cha cananyehe̱ ra fariseo cha tyicuan caa, cacatyi̱ ra chi ra Jesús: ―Nye̱he, ra cachicá noo chuhun sacuví ra noo cha ña tahán chi sacuví yo quɨvɨ nyitatú yo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Soco maa ra Jesús catyí ra chi ra: ―¿Atu ta sacuaha ca nyoho cha sacuvi̱ ra David chihin ra tahan ra quɨvɨ cha chisoco̱ ra? ");
INSERT INTO mxtNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Quɨhvɨ̱ ra chichi vehe Nyoo. Ta quehe̱n ra pan ii cha cha yaha̱ catuvi̱ nuu Nyoo. Ta chachi̱ ra ta ña tahán chi cachi ra, ni maa ra ni ra ndɨhɨ chihin ra, vatyi maa ri maa tata sutu tahán chi cachi pan cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O ta sacuaha ca ndo nu ley cha chaha̱ Nyoo chi ra Moisés nu catyí chi vatyi ra cacuví sutu, ña canyitatú ra quɨvɨ nyitatú yo, soco sahá tyiño ra chichi vehe ñuhu? Yucuan nyehé yo vatyi ñima cuatyi cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta catyí chi ndo, vatyi ihya nyaá yuhu cha cuví noo ra cahnu ca ican saha vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nyoho, ta cutuñi ca iñi ndo nu catyí chi tyehe caa nu tuhun Nyoo: “Cha cuñí yuhu, cha cundahvi cuñi ndo nyehe ndo chi tahan ndo, ta ñima ca cha cahñi ndo quɨtɨ ta cuhva cuenda ndo chii.” Tyehe ta cutuñí iñi ndo tuhun ihya, ma tyaa ndo cuatyi sɨquɨ ñáyɨvɨ cha ñahri sacuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yuhu cuví Rayɨɨ cha quichi̱ nya gloria. Ta iyó ityi chii vatyi catyi chi noo noo ndo ñáá cha sacuvi ndo quɨvɨ nyitatú yo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tyicuan ta quita̱ ra Jesús yucuan, ta cuahan ra vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta yucuan ñohó noo ra ityi ɨnchiyo ndaha. Ta nyicú tucu suhva ra nducu cuhva yoso caa ta catyaa ra cuatyi sɨquɨ ra Jesús. Yucuan chaha candaca̱ tuhun ra chi ra ta catyí ra: ―¿Atu cuví sanduvaha yo chi noo ñu cuhví quɨvɨ nyitatú yo? ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta nacaha̱n ra Jesús ta catyí ra: ―¿Nya noo nyoho, tatu canacava noo mbee sana ndo chichi noo yavi quɨvɨ nyitatu yo, atu ma cuhun ndo ta tava ndo chi tɨ? ");
INSERT INTO mxtNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ta ¿atu ña yahvi ca nyaá noo ñáyɨvɨ ta ñima ca noo mbee? Yucuan chaha vatyi tahán chi sacuvi yo cha vaha quɨvɨ nyitatú yo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tyicuan ta catyí ra chi ra cha ityi ndaha cuan: ―Sa̱nacaa ndahun ―catyí ra. Ta cuhva cha sanacaa̱ ra, nduvaha̱ ri ndaha ra tari inga chiyo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tyicuan ta caquita̱ coyo ra fariseo cuandatuhun tahan ra yoso caa cacahñi ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cha chito̱ ra Jesús tuhun tyi canducú ra chi ra, quita̱ ra yucuan ta cuaha ñáyɨvɨ chinyico̱n chi ra. Ta maa ra sanduvaha̱ ra chi tandɨhɨ ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ta catyí ra chi ñu tyi ma cahan ñu tuhun vatyi ican ra sanduvaha̱ chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tyicuan caa cuvi̱ tacuhva nachino cava tuhun cha tyaa̱ ra Isaías ra cuví profeta Nyoo ta cha naha. Tyehe caa tyaa ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ican ra ihya cuví ra sacuvi tyiño nui, ra cha nacachi̱ vahi. Cuñí xain chi ra, ta sɨɨ cuñí chihin ra. Cusacuti chi ra chihin Tatyi Ii cha iyó chii. Ta cusacoto ra chi ñáyɨvɨ cha ñima ñu Israel cuví yoso caa sacuvahi chi ñu nui. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta ma xaan cahan ra ta ni ma cana chaa ra, ta ni yori cuɨñɨ ndusu ra ityi cahnu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta ni noo ndoo yacua, ta ma cahnu ndɨhɨ ra. Ta ni ma ndahva ndɨhɨ ra mecha cha caña ñuhma. Nyacua nya cha sanicoo vaha ra chi ñáyɨvɨ chihin ra ta cunyaca ñaha vaha ra añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta tandɨhɨ ñáyɨvɨ, ta chi ra cuquɨhɨ iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tyicuan ta nu nyaá ra Jesús chinyaca̱ ñu chi noo ra yɨhɨ́ tatyi ña vaha chi, cuaa ra ta ñɨhɨ ra. Ta ra Jesús sanduvaha̱ ra chi ra. Ta cuvi̱ nacahan ra, ta cuvi̱ nanyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyo xaan cuñí tandɨhɨ ñáyɨvɨ, ta catyí ñu: ―¿Vasɨ ra vachi tata rey David cuví chi ra ihya? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Soco cuhva cha cachiñi̱ ra fariseo tuhun cuan, cacatyí ra: ―Chihin fuerza ra Beelzebú, ra cuví nuu chi cuihna, tavá ra ihya tatyi ña vaha ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Soco ra Jesús chitó ra cha cachicá xiñi ra, yucuan chaha catyí ra chi ra: ―Tatu noo gobiernu ta cacusɨɨn ra, cuaha ri ityi nanduvi ra, cucañi tahan ra chihin tahan ra, ta cundɨhɨ tuhun cha canyacá ñaha ra. O tatu noo ñuu o tandɨhɨ ñáyɨvɨ noo vehe cacusɨɨn ñu chihin tahan ñu, cutɨvɨ nu nyicú ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ta tyicuan caa tucu, tatu cuihna ta tava ra suri ra tahan maa ra, cuñí chi catyi vatyi ña ɨɨn ri cacuví ra, ta cundɨhɨ fuerza cha iyó chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ta nyoho catyí ndo vatyi yuhu tavé tatyi ña vaha chihin fuerza ra Beelzebú. Tu tyicuan caa, ra nyicú chihin maa ndo, ¿yóó cha chaha fuerza vatyi tavá ra tatyi ña vaha? Maa ra na sacoto ra chi ndo cha ndicha, vatyi nyoho tondo ri chicá xiñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yucuan chaha catyí chi ndo, vatyi yuhu tave tatyi ña vaha chihin fuerza Tatyi Ii Nyoo. Ta cuñí chi catyi vatyi ndicha cuii Nyoo ra nyacá ñaha añima ñáyɨvɨ cha chaa̱ ra nu canyicú ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Chichi vehe noo ra ñihi xaan, tari cuihna, ma cuvi quɨhvɨ noo ra ta quehen ra tandɨhɨ cha chii ra, soco tatu cuhñi xihna ra chi ra tyicuan caa ta cuví tinyaa ra tandɨhɨ cha chii ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ñáyɨvɨ cha ña nyaá tumañi iñi chii, ñáyɨvɨ xaan iñi chii cuví ñu. Ta tatu ña tyinyeé ndo chii cha cahán ndo tuhin nuu ñáyɨvɨ, cuñí chi catyí vatyi ña chahá ndo cha coto ñáyɨvɨ tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Yucuan chaha catyí chi ndo vatyi Nyoo sahá ra tɨcahnu iñi cuatyi ñáyɨvɨ, ta ñáá cha ña vaha cahán ñu ñandɨhɨ, soco cha cahan ña vaha ñu sɨquɨ Tatyi Ii Nyoo, yucuan ndicha, ma coo tɨcahnu iñi cha cuenda ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ta yóó ri ñu cha cahán ña vaha sɨquɨ yuhu Rayɨɨ cha quichi̱ nya gloria, coo tɨcahnu iñi chi ñu cha cuenda cuan. Soco ñu cahán ña vaha sɨquɨ Tatyi Ii Nyoo, ma coo maa tɨcahnu iñi chi ñu cha cuenda cuatyi cuan, nɨrɨ ihya ñayɨvɨ̱, ta nɨrɨ inga ñayɨvɨ̱ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Noo yutun vaha chahá tun chɨtɨ vixi, chɨtɨ vaha. Ta noo yutun ña vaha chahá tun chɨtɨ ña vaha. Nɨcohón nuu ri yo tatu yutun vaha cuví tun chihin chɨtɨ cha chahá tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Nyoho, ñu quiñi iyó, tari tata coo xaan cuví ndo! ¿Yoso caa cuví quitá tuhun vaha yuhu ndo, ta ñáyɨvɨ quiñi caa añima cuví ndo? Vatyi cha quitá chichi añima yo ican cuan cahán yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noo ra vaha cahán ra tuhun vaha vatyi ñohó cha vaha añima ra. Ta ra quiñi iyó, maa maa ri tuhun quiñi caa cahán ra, vatyi cha quiñi caa ñohó añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ta yuhu catyí chi ndo vatyi quɨvɨ cutuñi chi tandɨhɨ ñáyɨvɨ, cucuhva ñu cuenda tandɨhɨ tuhun cha ña saha̱ ñu cuenda ta caha̱n ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vatyi yoso cuhva cahún, yucuan cuhva cucutuñi chuun, tatu iyó o ñahri cuatyun. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tyicuan ta suhva ra fariseo ta ra sacuahá ley vehe ñuhu cacatyí ra chi ra Jesús tyehe caa: ―Maestro, cuñí ndi vatyi sacuvun noo seña milagru vatyi nyehe ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta nacaha̱n ra Jesús ta catyí ra: ―Ñu quiñi iyó ta ñu nyicón inga nyoo cuñí ñu nyehe ñu seña milagru. Soco ma nyehe ca ñu inga seña, noo ri seña ra Jonás ra profeta Nyoo, yucuan ri cunyehe ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vatyi tari ñoho̱ ra Jonás chichi tiyaca cahnu cuan uñi quɨvɨ ta uñi ñuu, tyicuan caa cucohon yuhu Rayɨɨ cha quichi̱ nya gloria chichi ñuhú uñi quɨvɨ ta uñi ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta quɨvɨ cucutuñi chi tandɨhɨ ñáyɨvɨ, cundɨcuita ñu chiyo̱ ñuu Ninive ta cha naha ta cucatyi ñu na tachi tuñi Nyoo chi nyoho ñáyɨvɨ cha iyó vityin, ta cucatyi ñu vatyi cucunaa ndo, vatyi maa ñu cha cuví ñu ñuu Nínive, canasama̱ ñu cuhva iyó ñu quɨvɨ caha̱n ra Jonás tuhun Nyoo chihin ñu. Ta ihya nyaá ra cahnu ca cuví ta ñima ca ra Jonás. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vatyi tyicuan caa tucu ñaha cha cuvi̱ reina ityi Sur, cundɨcuita ña quɨvɨ cucutuñi chi ñáyɨvɨ ta cucatyi ña vatyi cucunaa nyoho ñu iyó vityin, vatyi maa ña, vasɨ cañi ñuu ña soco quichi̱ ña, quichi̱ tyasoho ña tuhun cha chiñi tuñi ra Salomón. Ta ihya cahnu ca cuvi ra cha cahán chihin ndo vityin ta ñima ca ra Salomón. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Tatu noo tatyi ña vaha quita chi añima noo rayɨɨ, chicá noo chi noo nu ityi, nanducú chi noo nu nyitatu chi, soco ña nañihi chi nu nyitatu chi. Tyicuan ta ndichi xiñi chi: ");
INSERT INTO mxtNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cunuhu tiqui nya vehi nu quite̱.” Yucuan ta nachaa chi añima ra nu quita̱ chi. Ta nanyehe̱ chi vatyi ndɨɨ xaan, ta yori nyaá. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tyicuan ta cuanaquehen chi ucha ca tahan tatyi ña vaha, cha yaha ca cuhva ican saha maa chi. Tyicuan ta quɨhvɨ tandɨhɨ tatyi ña vaha cuan añima ra cuan. Yucuan chaha, quiñi ca cunɨcoo ra ta ñima ca cuhva chiyo̱ maa ra. Ta tyicuan caa cucuvi chi ñáyɨvɨ quiñi iyó ihya ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ni cahán ca ra Jesús chihin ñáyɨvɨ, ta chaa̱ sɨhɨ ra ta yañi ra, ta ndoo̱ ñu chata vehe, ta cuñí ñu cahan ñu chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tyicuan ta sacoto̱ noo ñáyɨvɨ nyaá cuan chi ra Jesús, ta catyí ñu: ―Sɨhun ta yañun nyicú ñu chata vehe. Ta cuñí ñu cahan ñu chuhun. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi ñu: ―¿Yóó cha cuví sɨhi ta yañi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tyicuan ta sañaha̱ ndaha ra chi ra cachicá noo chihin ra, ta catyí ra: ―Ican ra ihya cuví sɨhi ta yañi. ");
INSERT INTO mxtNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vatyi tandɨhɨ ñáyɨvɨ cha sacuvi cuhva cuñí Suti ra nyaá andɨvɨ, ican ñu cuan cuví yañi, ta cuhve, ta sɨhi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Quɨvɨ cuan quita̱ ra Jesús vehe ra ta chicunyaa̱ ra yuhu miñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta chaha cha cuaha ñáyɨvɨ nataca̱ nu nyaá ra, quɨhvɨ̱ ra chichi noo canoa ta chicunyaa̱ ra. Ta tandɨhɨ ñáyɨvɨ ndoo̱ ñu nyicú ñu nu ñɨtɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tyicuan ta cuaha ri cha quichaha sañahá ra chi ñu chihin noo cuhva ta catyí ra: ―Noo chaha quita̱ noo ra, tachi̱ ra chɨtɨ trigu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta nu cuahan ra quɨtɨ̱ ra chɨtɨ cuan, canacoyo̱ suhva chɨtɨ cuan yuhu ityi. Ta quichi̱ coyo saa ta cachachi̱ tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta suhva ca canacoyo̱ tɨcu yuu, nu ña cuaha ñuhú yɨhɨ́. Ta yucuan caña̱ chɨtɨ cuan cha numi ri vatyi ña cuaha ñuhú yɨhɨ́ chaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Soco cuhva cha caña̱ ñanyii ɨɨn na ityi ri tun, vatyi ña cono yɨhɨ́ yoho tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Suhva ca chɨtɨ canacoyo̱ tɨcu iñu. Ta chahnu̱ iñu cuan. Ta chasɨ̱ chi nuu tun. Yucuan chaha ña chiyo̱ chɨtɨ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Soco suhva ca canacoyo̱ nu ñuhú vaha. Ta quɨvɨ cachahnu tun, vaha xaan cachaha̱ tun chɨtɨ, vatyi yɨhɨ́ tun noo cientu chɨtɨ chaha tun cha noo ri maa tun. Ta inga tun uñi xico, ta inga tun oco uchi chɨtɨ chaha̱ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Tatu cutuñi iñi ndo, tya̱soho ndo! ");
INSERT INTO mxtNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tyicuan ta tuhva ra cachicá noo chihin ra Jesús, ta candaca̱ tuhun ra chi ra, ta catyí ra: ―¿Ñáá tuhun cha chihin cuhva ri cahún chihin ñáyɨvɨ, ta ña cahán cachun chihin ñu? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ta nacaha̱n ra Jesús ta catyí ra: ―Chi nyoho sacotó Nyoo tuhun xehe, yoso caa nyacá ñaha ra, soco chi maa ñu ña chahá ra cha coto ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vatyi ñáyɨvɨ cutuñí iñi tuhun cahín ta sacuví ñu, cuaha ca cucutuñi iñi ñu. Ta ñáyɨvɨ cha chiin ri cutuñí iñi, ta ña cuñí ñu sacuvi ñu, cutinyaa ndɨhi cha cutuñí iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yucuan chaha vatyi chihin cuhva ri cahín chihin ñu, tacuhva nyehe ñu ta cuví chi tari cha ña ndichin nyehe ñu. Ta cuɨñɨ ñu soco ma cutuñi iñi ñu, tari cha ña chiñi ñu cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta tyicuan caa ta chinó cava tuhun cha caha̱n ra Isaías ra profeta Nyoo ta cha naha, ta catyí ra: Cha ndicha vatyi nyoho cuɨñɨ ndo tuhin, soco ma cutuñi iñi ndo. Ta cunyehe ndo cha sacuví, ta ma cutuñi iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vatyi cha ndundava̱ añima ñáyɨvɨ ihya, ta ña cachi vaha chiñí ñu. Ta tahán nuu ñu, Tacuhva cha ma nyehe ñu chihin chɨtɨ nuu ñu. Ta ma cuɨñɨ ñu chihin soho ñu. Ta ni ma cutuñi iñi ñu chihin añima ñu. Ta ni ma nanducu ñu chii, tacuhva sanduvahi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Soco sɨɨ xaan cuví chi nyoho, vatyi nyehé ndo chihin chɨtɨ nuu ndo, ta chiñí ndo chihin soho ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cha ndicha catyí chi ndo, vatyi cuaha ra cacuvi̱ profeta Nyoo ta cuaha ñáyɨvɨ vaha, cacuñi̱ ñu nyehe ñu cha nyehé nyoho cha sacuví, soco ña nyehe̱ ñu. Cuñi̱ ñu cuɨñɨ ñu tandɨhɨ tuhun cha chiñi nyoho vityin, soco ña chiñi̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Tya̱soho ndo ñáá cha cuñí chi catyi noo cuhva cha catyi̱ chi ndo tuhun ra cha tachí chɨtɨ trigu cuan: ");
INSERT INTO mxtNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñáyɨvɨ cha chiñí tuhun yoso caa cuñí Nyoo cunyaca ñaha ra añima ñu, ta ña cutuñí iñi ñu, tari nu canacoyo chɨtɨ yuhu ityi, tyicuan caa cuví ñu. Vatyi quichi̱ cuihna ta tava̱ ra tuhun Nyoo cha caa añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ta tari nu canacoyo̱ chɨtɨ tɨcu yuu cuan, tyicuan caa cuví tucu ñáyɨvɨ cha chiñí tuhun Nyoo, ta sɨɨ xaan cuví chi ñu naquehen cuenda ñu noo ri cuhva. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Vatyi nu caña̱ chɨtɨ tɨcu yuu cuan, chiin ri ñuhú yɨhɨ́ chaha. Yucuan chaha caña̱ soco ña cuví tyihi yoho chi. Ta tyicuan caa ñu cuan. Suhva ri quɨvɨ chinó iñi ñu. Soco quɨvɨ cha quichaha nyehe ñu tɨndoho, ta satasɨ iñi ñáyɨvɨ chi ñu cha cuenda tuhun Nyoo ta sandɨhɨ ri ñu tuhun cha chinó iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta tari nu canacoyo chɨtɨ chichi iñu cuan, tyicuan caa cuví tucu inga ñu cha chiñí tuhun Nyoo. Chiñí ñu, soco ña cuñí ñu sacuvi ñu tari cuhva chiñí ñu. Vatyi nyaá xaan ca xiñi ñu tuhun tɨndoho ñayɨvɨ̱ ican saha tuhun Nyoo. Ta nyiyo ca iñi ñu cha tyayɨɨ. Ta tandɨhɨ tuhun cuan sayanga chi chi ñu, ta ña chahá nanducu vaha ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Soco tari nu canacava̱ chɨtɨ nu ñuhu vaha, tyicuan caa cuví ñu chiñí tuhun Nyoo, ta cutuñí iñi ñu, ta sacuví ñu tandɨhɨ tuhun cahán ra. Yɨhɨ́ ñu cuví ñu tari yutun cha chaha noo cientu chɨtɨ, ta inga ñu tari yutun cha chaha uñi xico, o tari yutun cha chahá oco uchi chɨtɨ noo noo tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ta chaha̱ tucu ra Jesús inga cuhva ihya chi ñu; ta catyí ra: ―Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo ra cha tachi̱ chɨtɨ trigu nu noo ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Soco cuhva cha caquixí tandɨhɨ ra casahá tyiño cuan, quɨhvɨ̱ noo ra xaan iñi chi ra, ta tachi̱ ra chɨtɨ cuhu ña vaha, ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ta quɨvɨ caña̱ chɨtɨ trigu cuan, ta caña̱ yoco chi, ta yucuan na tuvi tucu cuhu ña vaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tyicuan ta ra cacuví musu, cachaha̱n ra chicatyi̱ ra chi chitoho ra: “Tata, tatu maa maa ri maa chɨtɨ trigu tachu̱n, ¿nya quita̱ cuhu ña vaha cuan?” cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ta nacaha̱n ra cuan ta catyi ra: “Iyó noo ra xaan iñi chi yo tachi̱.” Tyicuan ta musu cuan, catyí ra chi chitoho ra: “¿Atu cuñún cha cuhun ndi ta tohon ndi cuhu ña vaha cuan?” ");
INSERT INTO mxtNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Soco chitoho ra catyí ra: “Ma tohon ndo, coto cuhva cha tohon ndo cuhu ña vaha cuan, ta coyo ndɨhɨ trigu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sa̱ña ndo, na cuahnu maa chi ɨɨn ri chihin trigo cuan, tyicuan ta quɨvɨ cunɨcoñehi tyiño sahí, cutachi chi ra casaha tyiño cutohon xihna ca ra cuhu ña vaha cuan ta cuhñi ra cuenda sucun, vatyi cahmi ra. Ta yaha cuan ta canaquehen vaha ra cha vaha cuan chichi yaque.” ");
INSERT INTO mxtNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tyicuan ta catyí tucu ra Jesús inga cuhva ihya chi ñu: ―Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo chɨtɨ yutun cha nañí mostaza cha tachi̱ noo ra nu ñuhú ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Vatyi ican chɨtɨ cuan cuví cha luhlu ca ican saha tandɨhɨ ca chɨtɨ. Soco quɨvɨ chahnu̱ tun cuví tun noo yutun cahnu vavaha. Ta quichi̱ coyo saa, ta casavahá tɨ taca tɨ nuu tun ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta catyí tucu ra Jesús inga cuhva ihya: ―Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari yuchan iya cha nasaca̱ noo ñaha chihin uñi cuhva yutyi pan. Vatyi tari ndaa tandɨhɨ pan cuan chihin yuchan iya cuan, tyicuan caa cuahan nducuaha ca ñu nyacá ñaha Nyoo añima ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tandɨhɨ tuhun ihya cahan ra Jesús chihin ñáyɨvɨ chihin cuhva ri. Ta tandɨhɨ tuhun cha catyi̱ ra chi ñu soco maa maa ri chihin noo cuhva ri. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tyehe caa sacuvi̱ ra tacuhva chino cava tuhun cha cahán ra profeta ta cha naha ta tyaa̱ ra tyehe caa: Chihin cuhva ri cucahin chihin ñáyɨvɨ. Cucatyi chi ñu tuhun cha ñohó xehe nyata savaha̱ Nyoo ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tyicuan ta sacunuhu̱ ra Jesús chi ñáyɨvɨ, ta ndɨhvɨ̱ ra chichi vehe. Ta catuhva̱ ra cachicá noo chihin ra chi ra, ta catyí ra chi ra: ―Na̱catyi chi ndi ñáá cha cuñí chi catyí tuhun cha caña̱ cuhu ña vaha cuan nu ñuhu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tyicuan ta quichaha catyí ra Jesús chi ra: ―Ra cha tachi̱ chɨtɨ trigu cuan ican cuví yuhu Rayɨɨ cha quichi̱ nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta ñuhú cuan, ican cuví añima ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. Ta chɨtɨ trigu cuan ican cuñí chi catyí ñáyɨvɨ cha nyicón chi Nyoo, ta chɨtɨ cuhu ña vaha cuan cuñí chi catyí ñáyɨvɨ cha nyacuví cuhva cuñí ra ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","’Ra cha tachi̱ cuhu ña vaha cuan, ican cuví cuihna ra xaan iñi chi Nyoo. Ta quɨvɨ cunacoñehe ra tyiño saha ra, ican cuví quɨvɨ cucunaa ñuhu ñayɨvɨ̱. Ta ra cha cunacoñehe chɨtɨ cuan, ican cuví ra cacuví ángel. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tari nasataca̱ ra cuhu ña vaha cuan vatyi cayu chi, tyicuan caa cucuvi quɨvɨ naa ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yuhu Rayɨɨ cha quichi nya gloria cutachi chi ángel cunasataca ra chi ñu sacoo cuatyi inga ñu, ta ñu cha sacuví cha ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta cutyihi ra chi ñu chichi horno nu cayú ñuhu. Ta cucuacu ñu ta cusacahñi ñu noho ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta ñu cha sacuví cuhva cuñí Nyoo cutuvi ñu nuu Nyoo Sutu yo. Ta tari cha ndichin ñanyii, tyicuan caa cucuvi ñu. Tatu cutuñí iñi ndo, tya̱soho ndo tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo xuhun cuaan ñohó xehe chichi ñuhú. Ta noo ra nañihi̱ xuhun cuaan cuan, soco natyihi̱ xehe tucu ra inga chaha ta sɨɨ xaan cuñí ra cuanuhu ra ta xico̱ ra tandɨhɨ cha iyó chi ra, ta sata̱ ra ñuhu nu ñohó xehe xuhun cuaan cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ta cha nyacá ñaha Nyoo añima ñáyɨvɨ, cuví tucu chi tari noo ra satá ta naxicó perla finu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta cuhva cha ñihi̱ ra noo cha yahví vavaha nyaá, ta xico̱ ra ndɨɨ maa cha cumi̱ ra, ta sata̱ ra perla vaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ta suri cuví tucu cha nyacá ñaha Nyoo añima ñáyɨvɨ tari tarraya cha cañí ra nu tyañuhu, ta ñihi ra ndɨhɨ nuu tiyaca chihin. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ta cuhva cha chitu̱ tarraya cuan chihin tiyaca, catava̱ ra ityi nu ñɨtɨ, ta yucuan canacachi̱ ra chi tɨ, canaquehe̱n vaha ra chi quɨtɨ vaha chichi noo tica, ta sacuita̱ ra chi quɨtɨ ña vaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ta tyicuan caa cucuvi quɨvɨ naa ñayɨvɨ̱, cuquichi coyo ángel, quichi tava sɨɨn ra chi ñu vaha ta ñu ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta cutyihi ra chi ñu ña vaha cuan chichi anyaya nu cayú ñuhu̱, nu cucuacu ñu ta cusacahñi ñu noho ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tyicuan ta ra Jesús ndaca̱ tuhun ra chi ra cachicá noo chihin ra, ta catyí ra: ―¿Atu cutuñí iñi ndo tandɨhɨ tuhun ihya? Ta nacaha̱n ra ta cacatyí ra: ―Ay, Sutu Mañi yuhu. Cutuñí iñi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tyicuan ta catyí ra Jesús chi ra: ―Tatu noo ra sacuahá cuenda ley vehe ñuhu, ta cutuhva ra tuhun yoso caa nyacá naha Nyoo añima ñáyɨvɨ, cumí ra cha vaha tuhun chahnu Nyoo, ta cumí tucu ra tuhun chaa cha sañahí. Ta cuví ra tari noo ra cuví nuu, ra chitó ta sañahá ra tuhun chahnu ta tuhun chaa cha sañahí ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ndɨhɨ̱ cahan ra Jesús cuhva ihya ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta nachaa̱ ra ñuu ra. Ta yucuan quichaha sañaha ra chichi vehe ñuhu ñuu cuan. Ta iyo cuñí ñáyɨvɨ ta catyí ñu: ―¿Nya maa maa cutuhva̱ ra ihya cha chiñi tuñi xaan ra? ¿Ta yoso caa cuví sacuvi ra milagru? ");
INSERT INTO mxtNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Vatyi sehe ra satyá vitu cuan cuví chi ra. Ta cu María cuví sɨhɨ ra. Ta yañi ra cuví chi ra Jacobo, ta ra José, ta ra Simón ta ra Judas. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ta cuhva ra ñandɨhɨ, iyó ñu ityi nu iyó yo. Tu tyicuan caa, ¿nya maa maa cutuhva̱ ra tandɨhɨ tuhun ihya? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta yucuan chaha ña cuñí ñu quichaha ñu chi ra. Soco ra Jesús catyí ra chi ñu: ―Tandɨhɨ ñáyɨvɨ tandɨhɨ ri ityi sahá ñu ñáyɨvɨ chi ra profeta. Soco ña quichahá ñu chi ra tatu ra ñuu ñu, o ra vehe ñu cuví chi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta ña cuaha milagru sacuvi̱ ra yucuan cha cuenda vatyi ña chinó iñi ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Quɨvɨ cuan ra Herodes, ra cuví gobiernu nɨcahnu nu cuví Galilea, ñihi̱ ra tuhun ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ta catyí ra chi ra nyicú chihin ra: ―Ican ra cuan cuví ra Juan ra sacondutya̱ chi ñáyɨvɨ, ra cha chihi̱ ta vityin nandoto̱ ra. Yucuan chaha iyó tunyee iñi chi ra cha sacuví ra milagru. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tyicuan caa catyi̱ ra vatyi suri maa ra tyihi̱ tyiño ta catɨɨ̱n ra chi ra Juan. Ta chahñi̱ ra chi ra chihin cadena, ta tyihi ra chi ra vehe caa. Tyicuan caa sacuvi̱ ra tyi xaan cuñí ra tyi catyi̱ ra Juan tyi ña vaha cha nyaá ra chihin cu Herodías cha cuví ña ñasɨhɨ yañi ra ra Felipe. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ta yucuan chaha, ra Herodes, cuñi̱ ra cahñi ra chi ra Juan, soco yuhvi̱ ra chi ñáyɨvɨ, vatyi tandɨhɨ ñu chinó iñi ñu tyi ra Juan cuenda Nyoo cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Soco noo quɨvɨ cha vico ra Herodes, ta quichahá chita chaha sehe cu Herodías nu nyicú ñu vico cuan. Ta taha̱n xaan iñi ra Herodes. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta tyaa̱ ra cuhva vatyi cuhva ra ñáá ri cha cacan ñaha tyivaa cuan, ta ma nacahnu ra tuhun cahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tyicuan ta tyiyuhu̱ sɨhɨ ña chi ña, na catyi ña chi ra Herodes tyehe caa: ―Cu̱hva xiñi ra Juan ra sacondutya ñáyɨvɨ chii nu noo coho ―catyi̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cha chiñi̱ rey Herodes tuhun caha̱n ña, nducuihya̱ cuñi ra. Soco cha cuenda cha tyaa̱ ra cuhva vatyi cuhva ra ñáá ri cha cacan ña nuu ñu canyicú vico cuan ta ma cuvi nacahnu ra, yucuan chaha tachi̱ ra nacuhva ra xiñi ra Juan chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ta tachi̱ ra tyiño na cutahnya sucun ra Juan nu ñohó ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tyicuan ta caquichi̱ nyaca ra xiñi ra, yɨhɨ́ noo nu coho. Ta cachaha̱ ra chi ñaha tyivaa cuan. Ta maa ña nacuhva̱ cuenda ña chi sɨhɨ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tyicuan ta chaa̱ coyo ra canyico̱n chi ra Juan ta canaquehe̱n ra coño ñuhu ra, ta catyihi̱ ra chichi ñuhu. Ta yaha̱ cuan ta chaha̱n coyo ra chisacoto ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cha chito̱ ra Jesús tuhun ihya, quehe̱n ra noo canoa, ta cuahan noo tuhun ri maa ra noo nu taxi ri iyó. Soco chito̱ ri ñáyɨvɨ, ta quita̱ coyo ñu ñuu ñu, ta cuahan coyo ñu chata ra ityi nu ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cha quita̱ ra Jesús chichi canoa cuan, nanyehe̱ ra cuaha xaan ñáyɨvɨ. Ta cundahvi̱ xaan cuñi̱ ra nyehé ra chi ñu. Ta sanduvaha̱ ra chi ñu cuhví cha chaa̱ chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta vatyi cha cua cuaa̱, ra cachicá noo chihin ra Jesús chaa coyo ra, ta catyí ra chi ra: ―Cha iñi xaan, ta yori ñáyɨvɨ iyó yatyin ri ihya. Yucuan cuenda na̱tachi chi ñáyɨvɨ ihya na cunuhu coyo ñu nya ñuu cusata ñu cha cachi ñu ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ta ra Jesús catyí ra: ―Ña tahán chi cuhun ñu. Cu̱hva maa ndo cha cachi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ta nacaha̱n ra ta cacatyí ra: ―Noo tuhun ohon tahan sɨɨn pan ta uvi tahan sɨɨn tiyaca cumí ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta catyí ra Jesús: ―Nya̱ca ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tyicuan ta tachi̱ ra tyiño na cunyicu ñáyɨvɨ nu cuhu cuan. Yaha̱ cuan ta quehe̱n ra ohon tahan pan cuan, ta ni nduvi tiyaca cuan. Ta nanyehe̱ ndaa ra andɨvɨ, ta nacuhva̱ ra tyahvi nyoo chi Nyoo ta tahvi̱ ra pan cuan. Ta chaha̱ ra chi ra cachicá noo chihin ra, na casacha ra chi ñáyɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ta tandɨhɨ ñu cachachi̱ ñu ta ndaha iñi ñu. Yaha̱ cuan ta canasataca̱ ra yɨquɨn cha ndoo̱. Ta quita̱ uchi uvi tahan tica. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta cha tandɨhɨ ñu cachachi̱ cuan, quita̱ ta cha ohon mil cha maa ri maa rayɨɨ. Ta ña quɨhvɨ̱ cuenda ñusɨhɨ ni ra cuatyaa. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ta cha yaha tuhun cuan ta catyí ra Jesús chi ra cachicá noo chihin ra, na quɨhvɨ coyo ra chichi canoa, vatyi cayaha sava ra miñi cuan ta cuhun coyo ra inga chiyo. Ta nɨri ca cha cuahan coyo ra cuan, ra Jesús ndoo ra natachi ra chi ñáyɨvɨ na cuhun coyo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cha yaha̱ cha natachi̱ ra chi ñu cuan, ta ndaa̱ ra yucu cuan cua cacan tahvi noo tuhun ri maa ra chi Nyoo. Ta yucuan ñohó ra ta cuaa ndɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta cha nɨ ri ca cha chicán tahvi ra cha cuahan vavaha canoa cuan nya mahñu miñi. Ta ndutya miñi cuan cañí chi chi canoa cuan cha cuenda vatyi ñihi xaan caá tatyi nu cuahan coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta cuhva cha ñaa ca cuan cua tuhva ra Jesús nu cuahan coyo ra chihin canoa cuan suri chicá ra nu ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ta cuhva cha cananyehe̱ ra chi ra, chicá ra nu ndutya cuan, canayuhvi̱ xaan ra. Ta cacana chaa vavaha ra, ta catyí ra: ―¡Noo cha sayuhvi cuví! ");
INSERT INTO mxtNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Soco nacahan ra Jesús chihin ra, ta catyí ra: ―¡Sa̱nɨɨ ndo iñi ndo, yuhu cuví, ma yuhvi ndo! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tyicuan ta nacaha̱n ra Pedro ta catyí ra: ―Sutu Mañi yuhu, tatu icon cuvún, ca̱tyi na quichi yuhu nu ndutya chiña nyacua nya nu vachun. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta ra Jesús catyí ra chi ra: ―Ña̱ha. Tyicuan ta noo̱ ra Pedro nu canoa cuan, ta quichaha̱ chica ra nu ndutya vatyi cuhun ra nu vachi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Soco cuhva cha tuvi̱ iñi ra tyi ñihi xaan fuerza tatyi cuan, nayuhvi̱ ra ta quichaha nducu nyee ra, ta quichaha cana chaa ra ta catyí ra: ―¡Sa̱cacu chii, Sutu Mañi yuhu! ");
INSERT INTO mxtNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta caa cuhva ri cuan, ta tɨɨ̱n ra Jesús ndaha ra, ta catyí ra chi ra: ―¡Chiin xaan chinó iñun chii! ¿Ñáá tuhun cha nacaca uvi iñun? ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta cuhva cha ndaa̱ coyo ra nu canoa cuan, cutaxin ri tatyi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tyicuan ta ra cañohó chichi canoa cuan cachicuiñi̱ chɨtɨ ra nuu ra Jesús, ta cacatyí ra chi ra: ―Ndicha ndicha cuii vatyi Sehe Nyoo cuví chuun ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cha cayaha̱ sava ra miñi cuan, cachaa̱ coyo ra nu cuví Genesaret. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta cuhva cha canɨcoho̱n nuu ñáyɨvɨ iyó yucuan chi ra Jesús, sacoto ñu chi tandɨhɨ ñáyɨvɨ ityi cuan. Ta quichi̱ nyaca ñu tandɨhɨ ñu cuhví nu nyaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta chacú ndahvi ñu nuu ra, na cuhva ra tɨɨn ñu vasɨ chiin sahma ra. Ta tandɨhɨ ñu tɨɨ̱n sahma ra, nduvaha̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tyicuan ta suhva ra cacuví fariseo ta ra casacuaha ley vehe ñuhu quita̱ coyo ra Jerusalén. Ta chaa̱ coyo ra nu nyaá ra Jesús ta candaca̱ tuhun ra chi ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ñáá tuhun cha ña sacuví ra cachicá noo chuhun costumbre cha sañahá ra cacuví mandoñi ñuu yo? Vatyi ña canacatyá ra ndaha ra tari cuhva cha tahán chi, tatu cuacachi ra xita ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Soco ndaca̱ tuhun ra Jesús chi ra, ta catyí ra: ―¿Ñáá tuhun cha ña quichahá tucu nyoho tuhun cahán Nyoo ta ñihi xaan ca quichaha ndo costumbre maa ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vatyi Nyoo catyí ra: “Sa̱ha ndo ñáyɨvɨ chi sutu ndo ta chi sɨhɨ ndo. Ta tandɨhɨ ñu cha cahán ña vaha chi sutu o chi sɨhɨ, na cúvi ñu”, catyí Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Soco nyoho catyí ndo tyi noo ñáyɨvɨ cuví catyí ñu chi sutu ñu o chi sɨhɨ ñu tyehe caa: “Ma cuvi tyinyei chuun vatyi tandɨhɨ cha iyó chii cha yaha̱ chaha̱ cuende chi Nyoo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ta tatu cha catyi̱ ndo tyicuan caa, ña cuñí ca chi cha tyinyee ca ndo chi sutu ndo o chi sɨhɨ ndo, catyí ndo. Ta tyicuan caa sacuachiyó xiin ndo tuhun cha catyi̱ Nyoo tyi sacuvi ndo, vatyi cuñí ndo sacuvi maa ndo cuhva costumbre maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Nyoho cha sahá ndo tyi vaha ndo! Ndicha vaha tuhun cha tyaa̱ ra Isaías, ra profeta Nyoo ta cha naha nu catyí Nyoo tuhun ndo tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ñáyɨvɨ ihya, chihin yuhu ri ñu catyí ñu tyi cuñí ñu chii. Soco ñima chihin tandɨhɨ añima ñu, tyi sɨɨn nu nyaá xiñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ta ñahri maa tuhun cha sacahnú ñu chii. Vatyi cha sañahá ñu maa maa ri cuhva sañahá ñáyɨvɨ ri cuví, tyehe caa tyaa̱ ra Isaías tuhun ndo, catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tyicuan ta cana̱ ra chi ñáyɨvɨ ta catyí ra chi ñu: ―Tya̱soho ndo, ta cu̱tuñi iñi ndo tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vatyi cha quɨhvɨ́ yuhu ñáyɨvɨ, ñima cuan satɨvɨ́ chi ñu nuu Nyoo. Soco cha quitá yuhu ñu, ican cuan satɨvɨ́ chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tyicuan ta catuhva̱ ra cachicá noo chihin ra Jesús ta candaca̱ tuhun ra chi ra, ta catyí ra: ―¿Atu chitón vatyi ra fariseo quiñi xaan cuñí ra cha cachiñi̱ ra tuhun cahún? ");
INSERT INTO mxtNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Soco maa ra Jesús nacaha̱n ra: ―Tandɨhɨ yutun cha ña tachi̱ Suti, ra nyaá andɨvɨ, cucoyo tun nya yoho tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sa̱ña ndo chi ra vatyi ra cuaa cacuví ra, ta casañahá ra ityi chi inga ra cuaa. Ta tatu noo ra cuaa ta sañahá ra ityi chi inga ra cuaa, nɨ nduvi ra cucanacoyo ra chichi noo yavi. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tyicuan ta quichaha catyí ra Pedro chi ra Jesús: ―Na̱catyi chi ndi ñáá cha cuñí chi catyí cuhva cha cahu̱n cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tyicuan ta ra Jesús catyí ra chi ra: ―¿Atu ni nyoho ta ña cutuñi iñi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Atu ña cutuñí iñi ndo vatyi cha quɨhvɨ ityi yuhu yo, chichi yo cuahan? Yaha̱ cuan ta quita tucu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Soco tuhun cha quitá yuhu yo, chichi añima yo quitá, ta ican cuan cuví cha satɨvɨ́ chi ñáyɨvɨ nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vatyi nya chichi añima ñu quitá cha quiñi caá chicá xiñi ñu. Ta cuñun, cha chahñi ñu chi ñáyɨvɨ, cha quichi cuvi iñi ñu coo ñu chihin inga ñu cha ñima ñasɨhɨ ñu cuví. Ta tandɨhɨ ca cha quiñi caa cha sacuvi ñu chihin coño ñuhu ñu. O yɨhɨ́ ñu cha suhu ñu cha chii ñáyɨvɨ. O sandaví ñaha ñu. O cahán ndasɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ican cuan cuví cha satɨvɨ́ chi ñáyɨvɨ. Soco cha ma sacuvi ñu costumbre cha nacatyá xaan ñu ndaha ñu cha ni cumañi ca cachi ñu, ña satɨvɨ́ cuan chi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Quita̱ ra Jesús ñuu cuan ta cuahan ra ityi ñuu Tiro ta ñuu Sidón. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta noo ñaha ñuu Canaan iyó ña ityi cuan, suri caná chaa ña vachi ña nu vachi ra Jesús, ta catyí ña: ―Sutu Mañi yuhu, ra vachi tata rey David cuvún. Cu̱ndahvi cuñi nyehun chii, vatyi sehi yɨhɨ́ noo tatyi ña vaha chi ña, ta nyehé xaan ña tɨndoho ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Soco ra Jesús ña nacaha̱n ra nu cahán ña. Tyicuan ta tuhva ra cachicá noo chihin ra chi ra ta cachacu̱ ndahvi ra nuu ra ta catyí ra chi ra: ―Ca̱tyi chi ña na cunuhu ña vatyi caná chaa xaan ña vachi ña chata yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tyicuan ta catyí ra Jesús chi ra: ―Nyoo noo ri nu tachi̱ ra chii, cuenda mbee cha cuanaa. Ta mbee cuan ican cuví ñu ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Soco ñaha cuan tuhva̱ ña ta chicuiñi̱ chɨtɨ ña nuu ra ta catyí ña chi ra: ―Sutu Mañi yuhu, ¡tyi̱nyee chii! ");
INSERT INTO mxtNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta ra Jesús catyí ra chi ña: ―Ña vaha cha tinyaa yo pan yuhu sehe yo ta cuhva yo cachi ina ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Soco maa ña ña quichaha̱ ña ta catyí ña chi ra: ―Ndicha, Sutu Mañi yuhu. Soco nyacua nya ina ta chachí tɨ yɨquɨn cha canacoyo nu mesa chitoho tɨ ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tyicuan ta catyí ra Jesús chi ña: ―Sɨhi ¡ñana cha chinó xaan iñun chii! Cua sacuvi tari cuhva cuñún. Ta caa cuhva ri cuan ta nduvaha̱ sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Quita̱ ra Jesús yucuan ta yaha̱ ra yuhu miñi Galilea, ta ndaa̱ ra noo yucu ta chicunyaa̱ ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta cuaha ñáyɨvɨ chaa̱ coyo nu nyaá ra ta quichi nyaca ñu cuaha ñu cuhví: ñu coxo, ñu cuaa, ñu luu, ñu ñɨhɨ. Ta cuaha ca ñu cuhví quichi nyaca ñu nu nyaá ra. Ta chacu̱n ñu chi ñu nuu ra, ta maa ra sanduvaha̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ta iyo cuñí ñáyɨvɨ nyehé ñu yoso caa nacaha̱n ñu ñɨhɨ ta yoso caa nduvaha̱ ñu luu, ta yoso caa nacacá ñu coxo, ta yoso caa nanyehé ñu cuaa. Ta quichaha casacahnu ñu chi ra cuví Nyoo cuenda ñu, ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tyicuan ta cana̱ ra Jesús chi ra cachicá noo chihin ra, ta catyí ra chi ra: ―Ndahvi xaan cuñí nyehi chi ñáyɨvɨ ihya, vatyi cha uñi quɨvɨ nyicú ñu ihya chihin, ta ñahri maa cha cachi ñu nyisó ñu. Ta ña cuñí natachi chi ñu nya vehe ñu vatyi ta cachi ca ñu, coto coñaa ñu ityi cunuhu ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tyicuan ta ra cachicá noo chihin ra cacatyí ra chi ra: ―Soco ¿nya cuquehen yo cha cachi ñáyɨvɨ cuaha ihya, nu yori maa ñáyɨvɨ iyó ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tyicuan ta ra Jesús ndaca̱ tuhun ra chi ra: ―¿Yoso tahan pan cumí ndo? Ta maa ra catyí ra: ―Ucha tahan pan, ta uvi tahan tiyaca nyihi ri. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tyicuan ta tachi̱ ra na cunyicu ñáyɨvɨ cuan nu ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tyicuan ta quehe̱n ra ndɨ ucha pan cuan ta tiyaca cuan, ta nacuhva̱ ra tyahvi nyoo chi Nyoo. Tyicuan ta tahvi̱ ra ta chaha̱ ra chi ra cachicá noo chihin ra, ta maa ra cachicá noo chihin ra canasacha̱ ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tandɨhɨ ñu chachi ñu, ta chitu̱ chichi ñu. Ta yaha̱ cuan casacutu̱ ra ucha tica chihin yɨquɨn cha ndoo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cumi mil rayɨɨ cachachi̱, ta ña quɨhvɨ̱ cuenda ñusɨhɨ nɨ ri ra cuatyaa. ");
INSERT INTO mxtNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yaha̱ cuan ta sacunuhu ra chi ñáyɨvɨ, ta quɨhvɨ̱ ra nu canoa, ta cuahan ra ityi nu cuví Magdala. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tyicuan ta ra fariseo ta ra saduceo chaha̱n coyo ra nu nyaá ra Jesús. Vatyi cacuñí ra nducu nyehe ra chi ra yucuan chaha chicán ra na sacuvi ra noo milagru chihin tunyee iñi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Soco nacaha̱n ra Jesús ta catyí ra chi ra: ―Cha cha iñi cuhva cha cuaa quee ñanyii, tuhvá ndo catyí ndo: “Vaha xaan cucuvi quɨvɨ tyaan, vatyi tyaquɨ xaan cuaha andɨvɨ.” ");
INSERT INTO mxtNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta cha ñaha ri catyí ndo: “Vityin ña tyaquɨ maa cucuvi quɨvɨ vatyi cuaha ta iñi ñaa xaan andɨvɨ”, catyi ndo. Nyoho vaha xaan chitó ndo ¿yoso caa nacotó ndo tuhun vico andɨvɨ soco ña cuví nacoto ndo yoso caa cuahan tuhun cha sañahá Nyoo chi ndo vityin? ");
INSERT INTO mxtNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñáyɨvɨ iyó vityin, quiñi iyó ñu ta ña chinó iñi ñu chi Nyoo. Cuñí ñu nyehe ñu noo cha iyo. Soco ma cuhve nyehe ñu vatyi cha yaha̱ sañaha̱ Nyoo cha iyó cha sacuvi̱ ra chihin ra Jonás ―catyí ra Jesús chi ra, ta sandoo̱ ra chi ra, ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuhva cha cayaha̱ ra cachicá noo chihin ra Jesús inga chiyo miñi cuan, canaa̱ iñi ra cacuiso ra pan. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tyicuan ta catyí ra Jesús chi ra: ―Sa̱ha ndo cuenda chi ndo chihin yuchan iya ra fariseo ta ra saduceo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tyicuan ta quichaha̱ candatuhun ra chihin ra tahan ra ta catyí ra: ―Cha cuenda vatyi ñahri pan nyisó yo vachi, yucuan chaha catyí ra tyicuan caa chi yo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta tuvi̱ iñi ra Jesús tuhun candatuhún ra, ta catyí ra chi ra: ―Nyoho, chiin xaan chinó iñi ndo chii. ¿Ñáá tuhun cha catyí ndo vatyi ñahri pan nyisó ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Atu ta cutuñi ca iñi ndo? ¿Atu ña nɨcohón iñi ndo quɨvɨ sacachi chi ndɨ ohon mil rayɨɨ chihin ohon tahan ri pan? Ta ¿yoso tahan tica sacutu̱ ndo chihin yɨquɨn cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Atu ña nɨcohón iñi ndo quɨvɨ sacachi̱ chi cumi mil ca ra chihin ucha tahan pan? Ta ¿yoso tahan tica sacutu̱ ndo chihin yɨquɨn cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Yoso caa cha ña tuví iñi nyoho vatyi ñima tuhun pan cahín, cuhva cha catyi̱ vatyi na saha ndo cuenda chi ndo chihin yuchan iya ra fariseo ta ra saduceo? ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tyicuan ta cacutuñí iñi ra vatyi ñima tuhun yuchan iya pan cuan cahán ra, soco na casaha ra cuenda chi ra chihin tuhun cha casañahá ra fariseo ta ra saduceo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cuhva cha chaa̱ ra Jesús ityi ñuu Cesarea Filipo, ndaca̱ tuhun ra chi ra cachicá noo chihin ra ta catyí ra: ―¿Ñáá catyí ñáyɨvɨ? ¿Yóó ra cuvi Rayɨɨ cha quichi nya gloria? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta canacaha̱n ra ta catyí ra: ―Yɨhɨ́ ñu catyí ñu tyi ra Juan ra sacondutya chi ñáyɨvɨ cuvún. Ta inga ñu catyí ñu tyi ra Elías, ta yɨhɨ́ tucu ñu catyí ñu tyi ra Jeremías, o inga ra cuví profeta Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tyicuan ta catyí ra chi ra: ―Ta cha cuenda chi nyoho, ¿Yóó ra cuví yuhu? ");
INSERT INTO mxtNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tyicuan ta nacaha̱n ra Simón Pedro: ―Yoho cuvún ra Cristo, Sehe Nyoo nyitó ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta nacaha̱n ra Jesús ta catyí ra: ―Sɨɨ xaan cuví chi yoho, Simón sehe ra Jonás, vatyi ni noo rayɨɨ ña sañaha̱ ra chuun tuhun ihya, soco maa Suti ra nyaá andɨvɨ sañaha̱ chuun. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta yuhu catyí chuun tyi yoho cuvún ra Pedro. Ta sɨquɨ cava ihya, savahí vehe ñuhi. Ta ma cuvi chasaha tuhun chihi chi chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yuhu cuhve ndaha tɨcu andɨvɨ nu nyacá ñaha Nyoo chuun. Ta cha cuhñun ihya sɨquɨ ñuhu ñayɨvɨ̱, cha nuhñi̱ saha̱ maa Nyoo nya andɨvɨ. Ta tandɨhɨ cha ndachun ihya sɨquɨ ñuhu ñayɨvɨ̱, cha ndachi maa Nyoo nya andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tyicuan ta catyi̱ ra Jesús chi ra cachicá noo chihin ra tyi yori chihin cacahan ra tuhun vatyi ican ra cuví Cristo cha quita̱ nu nyaá Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nya ndaha quɨvɨ cuan quichaha̱ catyí ra Jesús chi ra cachicá noo chihin ra, vatyi cuñí chi cha cuhun ra ñuu Jerusalén. Ta ra cacuví mandoñi, ta ra cacuví nuu chi tata sutu, ta ra sacuaha ley vehe ñuhu, cucasanyehe xaan ra tɨndoho chi ra. Ta catyí tucu ra vatyi cucahñi ra chi ra soco nu cu uñi quɨvɨ ta cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tyicuan ta quehe̱n ra Pedro chi ra ta quita̱ sɨɨn ra chihin ra ta quichaha̱ catyí ra chi ra Jesús vatyi ña vaha cha cahán ra ta catyí ra: ―Ña cuñí Nyoo ta cuvi chuun tyehe caa, Sutu Mañi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Soco nanyocava̱ ra Jesús, ta quichaha̱ catyí ra chi ra Pedro: ―¡Ca̱nyaha chuun nui, cuihna! Vatyi cha cahún tyiña caa nducú sanacavon chii. Vatyi ña chicá xiñun cuhva chicá xiñi Nyoo. Soco cuhva chicá xiñi ñáyɨvɨ chicá xiñun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tyicuan ta ra Jesús catyi̱ ra chi ra cachicá noo chihin ra: ―Tatu nya nyoho cuñí ndo cunyicon ndo chii, cuñí chi sa̱naa ndo iñi ndo tuhun maa ndo. Ta ma ndu uvi iñi ndo cha nyicón ndo chii, vasɨ nyehe ndo tɨndoho cha cuende vatyi yucuan cuví cruzi cha tahán chi cuiso ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vatyi nya nyoho ña cuñí ndo nyehe ndo tɨndoho cha cuenda yuhu, cucúvi ndo ta cuhun ndo anyaya. Soco nya ndo cuhva ndo ñayɨvɨ̱ ndo cha cuende, cucacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vatyi ñáá ri tuhun cha saha ganaa ndo tandɨhɨ cha tyayɨɨ cha iyó sɨquɨ ñuhu ñayɨvɨ̱ tatu cunaa añima ndo. Vatyi ñahri chihin cutyiyahvi ndo ta cacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria, cuquichi tiqui soco chihin cha cahnu cuví Suti, ta cuquichi coyo ángel chihin. Tyicuan ta cutyiyahvi chi noo noo ndo yoso cuhva sacuvi̱ ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cha ndicha catyí chi ndo, vatyi yɨhɨ́ nyoho cha nyicú ndo ihya cha ma cúvi ñaha ndo nyacua nya nyehe ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria, cunyehe ndo yoso caa vachi cunyaca ñahi chi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iñu quɨvɨ cha yaha̱, ta quehe̱n ra Jesús chi ra Pedro ta ra Jacobo, ta ra Juan yañi ra Jacobo. Ta cuahan coyo ra noo yucu sucun xaan chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta yucuan nasama̱ cuhva caa ra Jesús nuu ra ndɨhɨ chihin ra. Ta xiño vavaha nanduvi̱ nuu ra tari ñanyii. Ta sahma ra cuichin xaan nanduvi̱ tari maa ñuhú cuichin. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tyicuan ta cananyehe̱ ra chi ra Moisés ta ra Elías, candatuhún ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ta quichaha̱ catyí ra Pedro chi ra Jesús: ―Sutu Mañi yuhu, vaha xaan cha nyicú ndi ihya. Tatu cuñún na savaha ndi uñi tahan vehe. Noo chuun, noo chi ra Moisés, ta nonga chi ra Elías ―catyí ra Pedro chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cha nɨ ri ca cha cahán ra Pedro, quichi̱ ri noo vico cha xiño vavaha sɨquɨ ra. Ta sahvi cuan chi ra. Ta chichi vico cuan quita̱ noo ndusu cha catyí chi tyehe caa: ―Ican ra ihya cuví Sehi, ta cuñí xain chi ra. Ta sɨɨ xaan cuñí chihin ra. Tya̱soho ndo tuhun cahán ra ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cha cachiñi̱ ra cachicá noo chihin ra Jesús tuhun cuan, cachicava̱ ra nya ñuhu, ta cayuhvi̱ xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tyicuan ta tuhva̱ ra Jesús nu cayucú ra, ta tɨɨ̱n ra chi ra, ta catyí ra: ―Ndɨ̱cuita ndo. Ma yuhvi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta cuhva cha cananyehe̱ ra, noo tuhun ri ca ra Jesús nanyaá, ta uvi ca ra cuan, yori ca ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ta cuhva cha vachi noo coyo ra yucu cuan, catyí ra Jesús chi ra: ―Yori chihin ca̱han ndo tuhun cha nyehe̱ ndo ihya. Ca̱han ndo tuhun soco nya yaha cúvi ta nandoto yuhu Rayɨɨ cha quichi̱ nya gloria ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tyicuan ta candaca̱ tuhun ra cachicá noo chihin ra chi ra, ―¿Ñáá tuhun cha catyí ra casacuahá ley vehe ñuhu vatyi xihna ca ra Elías tahán chi quichi? ");
INSERT INTO mxtNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta nacaha̱n ra Jesús ta catyí ra: ―Cha ndicha vatyi xihna ca ra Elías quichi ta cusanduvaha ra tandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Soco yuhu catyí chi ndo vatyi cha yaha̱ quichi̱ ra Elías, soco ña nɨcoho̱n nuu ñáyɨvɨ chi ra, ta casacuvi̱ ñu chihin ra tandɨhɨ cuhva cuñi̱ maa ñu. Ta tyicuan caa tucu yuhu Rayɨɨ cha quichi̱ nya gloria, cusanyehe ñu tɨndoho chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tyicuan ta cacutuñi̱ iñi ra vatyi tuhun ra Juan ra sacondutya cahán ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuhva cha cachaa̱ coyo ra nu nyicú ñáyɨvɨ, tuhva noo ra ta chicuiñi chɨtɨ ra nuu ra Jesús, ta catyí ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tata, cu̱ndahvi cuñi nyehun chi sehi, vatyi yɨhɨ́ noo cuehe chihi tañi chi ra, ta cuaha xaan tɨndoho nyehé ra chihin cuehe cuan. Ta cuaha xaan chaha nduva̱ ra nu ñuhu̱ ta cayu̱ ra, ta nduva̱ ra nu ndutya ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ta quichi̱ nyaque chi ra chi ra cachicá noo chuhun, soco ña cuvi̱ sanduvaha̱ ra chi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta nacaha̱n ra Jesús ta catyí ra: ―¡Nyoho, ñu ña chinó iñi cuví ndo! ¡Ta nɨcaa ni quiñi iyó ndo! ¿Yoso tahan ca quɨvɨ cunyai chihin ndo ta cunyei tɨsɨhɨ ndo nyacua nya cutuhva ndo ta chino iñi ndo chii? Nya̱ca ndo chi ra tyivaa chiña tyehe ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tyicuan ta tava̱ ñehe ra Jesús chi tatyi ña vaha cuan, ta quita̱ cuan chi ra tyivaa cuan. Ta caa cuhva ri cuan ta nduvaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cha yaha̱ cuan ta ndaca̱ tuhun sɨɨn ra chicá noo chihin ra Jesús chi ra ta catyí ra: ―¿Ñáá tuhun cha ña cuvi̱ tava nyuhu chi tatyi ña vaha cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta ra Jesús nacaha̱n ra ta catyí ra: ―Cha cuenda cha chiin xaan chinó iñi ndo chii. Cha ndicha catyí chi ndo vatyi tyehe ta chinó iñi ndo chii, tari cuhva cha cahnu noo chɨtɨ mostaza, cuví catyi ndo chi yucu ihya na canyaha chi ta cuhun chi inga ityi, ta yucu ihya cuhun chi inga ityi. Ta ñahri cha ma cuvi sacuvi ndo tatu ndicha cha chinó iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Soco tahan tatyi ña vaha cuan, quita chi chihin cha ma cachi yo ta cacan tahvi yo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cha nɨ ri ca cha ɨɨn ri cachicá noo ra ityi Galilea cuan, ra Jesús catyí ra chi ra cachicá noo chihin ra: ―Yuhu Rayɨɨ cha quichi̱ nya gloria, cucuhva cuenda ñu chii chichi ndaha ra xaan iñi chii. Ta cucahñi ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Soco nu cu uñi quɨvɨ ta cunandote ―catyí ra. Ta canducuihya xaan iñi ra cachicá noo chihin ra cha cachiñi̱ ra tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuhva cha chaa̱ ra Jesús ta ra cachicá noo chihin ra ñuu Capernaum, ra catavá xuhun cuenda vehe ñuhu cuan, chaha̱n coyo ra chinyehe ra nu nyaá ra Pedro ta candaca̱ tuhun ra chi ra: ―¿Atu ña tyiyahví ra sacuaha chi nyoho xuhun cha tahán chi cuenda vehe ñuhu cahnu? ―cacatyí ra chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta nacaha̱n ra Pedro ta catyí ra: ―Tyiyahví ra. Cuhva cha quɨhvɨ̱ ra Pedro chichi vehe nu ca iyó ra, xihna ca ra Jesús nacaha̱n ra ta catyí ra: ―¿Yoso caa catyi tucu yoho vityin Simón? Ra cuví tyiño sɨquɨ ñuhu ñayɨvɨ̱ ihya, ¿yóó chi caquehen ra yahvi? ¿Atu chi ñu ñuu maa ra o chi ñu inga ñuu? ");
INSERT INTO mxtNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nacaha̱n ra Pedro ta catyí ra: ―Chi ñu inga ñuu. Ta catyí ra Jesús chi ra: ―Tu tyicuan caa, ñu ñuu maa ra ña tahán chi tyiyahvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Soco tacuhva vatyi ma cuhva yo tɨsɨhɨ chi ni noo ra, cua̱han miñi cuan, ta tyi̱hun anzuelo, ta tiyaca cha tavon cha xihna ri, chichi yuhu tɨ cunañihun noo xuhun. Ta ñihi tyiyahvun cha cuende ta cha cuenda maun. Que̱hun ta cu̱tyiyahvun ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Quɨvɨ cuan catuhva̱ ra cachicá noo chihin ra Jesús chi ra, ta candaca̱ tuhun ra chi ra: ―¿Nya ndi cahnu ca cuví nu nyacá ñaha Nyoo? ");
INSERT INTO mxtNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tyicuan ta ra Jesús cana̱ ra chi noo ra cuehe luhlu, ta chinanyaa̱ ra chi cue mahñu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ta catyí ra: ―Cha ndicha catyí chi ndo, vatyi tatu nyoho ta ma nasama ndo cuhva iyó ndo, ta tatu ma cuvi ndo tari ra cuatyaa, ma cuvi quɨhvɨ ndo nu nyacá ñaha Nyoo. Vatyi ra cuatyaa chahá ndotyin cunyaca ñaha sutu ndotyin chi ndotyin, ta tyicuan caa cu̱hva ndo chi ndo cunyaca ñaha Nyoo chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta tyicuan caa ra cahnu ca cuví nuu Nyoo, ican cuví ñu ña cahnu sahá chi, ta cuví ñu tari ra cuehe luhlu ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta ñáyɨvɨ cha natɨɨ́n cuenda chihin sɨvi chi noo ra ña cahnu sahá chi, tari ra cuehe luhlu ihya, chi yuhu natɨɨ́n cuenda ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tatu yóó ñu sanacavá nu cuatyi chi noo ra nachinó iñi chii ta cuví ra tari minoo ra luhlu, vaha taxin ca, cuhñi ñu noo yuu vee sucun ñu ta tuchi ñu chi ñu nu cono tyañuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ñana cha ña vaha cha cuenda ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ, vatyi iyó tuhun cha sacoo ñu cuatyi tahan ñu! Ta tyicuan ri coo tuhun cuan, soco ¡ndahvi ñu ndahvi cha sanacava nu cuatyi chi inga ñu! ");
INSERT INTO mxtNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Yucuan chaha tatu ndahun o tatu chahun sanacava chuun nu cuatyi, vaha taxin ca ca̱hnya ta sa̱cuiton cañi. Vatyi vaha ca quɨhvun nu coun chihin Nyoo chihin cha luu ndahun o luu chahun, ta ñima ca cha nanɨun ta tuchi Nyoo chuun nu cayú ñuhu̱ cha ma ndahva ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta tatu noo chɨtɨ nuun sanacavá chuun nu cuatyi, vaha taxin ca ta̱va ta sa̱cuiton cañi. Vatyi vaha ca quɨhvun nu coun chihin Nyoo chihin noo chɨtɨ nuun, ta ñima ca chihin cha nɨnduvi chɨtɨ nuun ta tuchi Nyoo chuun nu cayú ñuhu̱ chichi anyaya. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ma tava xiin ndo chi ni noo ra cha cuví tari noo ra luhlu, vatyi catyí chi ndo tyi ángel cha sahá cuenda chi ra, tyicuan ri sacuví ra tyiño nuu Suti, ra nyaá andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria, vachi sacaqui chi ñáyɨvɨ cha cuanaa chihin cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Yoso caa catyi nyoho? Tatu noo ra cumí ra noo cientu mbee, ta cuanaa noo tɨ, ¿atu ma sandoo ra ndɨ cumi xico chahun cumi tahan ca tɨ cuan yucu cuan, ta cuhun ra cunanducu ra chi quɨtɨ cha cuanaa cuan? Yuhu catyí tyi sandoo ra ta cuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta tatu nañihi ra chi tɨ, cha ndicha vatyi cusɨɨ ca cuñí ra chihin quɨtɨ cuan, ta ñima ca chihin cumi xico chahun cumi ca quɨtɨ cha ña chinaa̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ta tyicuan caa tucu, Sutu ndo ra nyaá andɨvɨ ña cuñí ra cha cunaa ni noo ñu cuví tari noo ra luhlu. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tatu ra yañun ta sacuvi̱ ra cha ña vaha chuhun, ca̱han chihin noo tuhun ri maa ra ta ca̱tyun chi ra tyi ña vaha cuhva sacuvi̱ ra. Ta tatu quichaha ra tuhun cahún, cha saha̱ ganaun chi ra cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Soco tatu ña quichahá ra chuun, tyicuan ta ca̱non chi uvi o uñi ra, tacuhva tandɨhɨ cha cahun cucuvi ra testigu. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tatu ña quichaha̱ ra ni chi ra cha chaha̱n coyo chuhun cuan, tyicuan ta ca̱han chihin ra chihin nuu ñáyɨvɨ nyicú vehe ñuhu. Ta tatu ña quichaha ra chi ñu vehe ñuhu, tyicuan ta cuví saha ndo tuhun tyi tari noo ra ña chinó iñi chi Nyoo cuví ra, o tari ra catavá xuhun cuenda gobiernu ñuu Roma. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cha ndicha catyí chi ndo, vatyi tandɨhɨ cha cuhñi ndo ihya sɨquɨ ñuhu ñayɨvɨ̱, ta cha nuhñi saha̱ maa Nyoo nya andɨvɨ. Ta tandɨhɨ cha ndachi ndo ihya sɨquɨ ñuhu ñayɨvɨ̱, cha ndachi maa Nyoo nya andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ta suri catyí tiqui chi ndo, vatyi tatu uvi nyoho ihya sɨquɨ ñuhu ñayɨvɨ̱, ndu ɨɨn ri ndo ta cacan tahvi ndo cuenda ñáá noo cha cuñí ndo cacan ndo, Suti, ra nyaá andɨvɨ cuhva ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vatyi nu nyicú uvi o uñi ñu sacahnú chii, yucuan cunyai mahñu ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tyicuan ta chaha̱n ra Pedro chindaca̱ tuhun ra chi ra Jesús ta catyí ra: ―Sutu Mañi yuhu, tatu ra tahin ta sacuvi ra ñáá noo cha ña vaha chihin, ¿yoso tahan chaha tahán chi sahi tɨcahnu iñi chi ra? ¿Atu ucha tahan chaha? ");
INSERT INTO mxtNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ta nacaha̱n ra Jesús ta catyí ra: ―Catyí chuun vatyi ñima ucha tahan ri chaha, soco tandɨhɨ ri chaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yucuan chaha cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo rey cha nacana̱ chi tandɨhɨ musu vatyi cuanyehe ra yoso yosó yɨca ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ta cuhva cha quichaha̱ natava ra cuenda, ta quichi̱ nyaca ñu chi noo musu cha cuaha millón pesu yosó yɨca chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ta musu cuan ñahri maa chihin tyiyahvi ra chi chitoho ra, ta chitoho ra catyí ra: “Cuaxico ndo chi ra ɨɨn cuenda ri chihin ñasɨhɨ ra, ta chihin sehe ra ta tandɨhɨ cha iyó chi ra tacuhva vatyi chihin xuhun cuan cunatyiyahvi ra cha yosó yɨca ra chii.” ");
INSERT INTO mxtNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tyicuan ta musu cuan chicuiñi̱ chɨtɨ ra nuu chitoho ra, ta chacu̱ ndahvi ra nuu ra, ta catyí ra: “Tata, cua̱tu noo chiin chii, ta tyiyahvi mai tandɨhɨ chuun”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ta cundahvi̱ cuñi chitoho ra chi ra, ta saha̱ ra tɨcahnu iñi chi ra, ta sanaa̱ ra tandɨhɨ cha yoso yɨca ra, ta saña̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Soco cuhva cha quita̱ musu cuan, nañihi̱ ra chi noo ra tahan ra cha cuví musu tari maa ra. Ta ra cuan yosó yɨca ra chiin ri chi ra. Ta tɨɨ̱n ra chi ra cuan, ta quichaha̱ quitu ra sucun ra, ta catyí ra chi ra: “Tyi̱yahvi cha yosó yɨcon chii.” ");
INSERT INTO mxtNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tyicuan ta chicuiñi̱ chɨtɨ ra cuan nuu ra, ta chacu̱ ndahvi ra nuu ra ta catyí ra: “Cua̱tu noo chiin chii, ta tyiyahvi mai tandɨhɨ chuun”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Soco maa ra ña cuñi̱ ra, ta chaha̱n ra ta tyihi̱ ra chi ra vehe caa nyacua nya cha tyiyahvi̱ ra cha yoso̱ yɨca ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cha canyehe̱ inga ca musu cha sacuvi̱ ra, uhvi xaan cacuví chi ra, ta chaha̱n coyo ra chinacatyi̱ ra chi chitoho ra cha sacuvi̱ ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tyicuan ta chitoho ra cuan tachi̱ ra tyiño na quichi ra ta catyí ra chi ra: “Musu ña vaha cuvún. Yuhu sahi̱ tɨcahnu iñi tandɨhɨ cha yosó yɨcon chii, vatyi chacu̱ ndahvun nui. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tyicuan caa tucu cuñí chi cundahvi cuñun chi ra tahun cuan tari cundahvi̱ cuñi̱ nyehi chuun”, catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ta cuxaa̱n xaan chitoho ra, ta tachi̱ ra tyiño na tachi tuñi ñu chi ra, nyacua nya cha tyiyahvi ra tandɨhɨ cha yosó yɨca ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta nu ndɨhɨ caha̱n ra Jesús, ta catyí ra tyehe caa: ―Tyicuan caa tucu cusacuvi Suti, ra nyaá andɨvɨ, chihin ndo tatu ma saha ndo tɨcahnu iñi chihin cha tandɨhɨ añima ndo chi tahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cha yaha̱ cha catyi̱ ra Jesús tuhun ihya, ta quita̱ ra Galilea cuan, ta cuahan ra ityi Judea cha nyaá inga chiyo yuvi cahnu Jordán, ityi nu caña ñanyii. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cuaha ñáyɨvɨ chinyico̱n chi ra, ta yucuan sanduvaha̱ ra chi ñu cuhvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tyicuan ta suhva ra fariseo catuhva̱ ra chi ra Jesús, vatyi cacuñí ra nducu ra cuhva tyaa ra cuatyi sɨquɨ ra. Ta candaca̱ tuhun ra chi ra ta catyí ra: ―¿Atu vaha cha sandoo rayɨɨ chi ñasɨhɨ ra cha cuenda ñáá ri tɨsɨhɨ luhlu chaha̱ ña chi ra? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta nacaha̱n ra ta catyí ra: ―¿Atu ta sacuaha ca nyoho nu tutu Nyoo nu catyí chi vatyi ra cha savaha̱ chi ndo nya quɨvɨ xihna ri, savaha̱ ra rayɨɨ ta ñaha sɨhɨ? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta catyí tucu chi tyehe caa: “Tahán chi sandoo rayɨɨ chi sutu ra ta chi sɨhɨ ra, ta ndu ɨɨn ri ra chihin ñasɨhɨ ra. Ta chichi cha nɨnduvi ñu, cucuvi ñu tari cha noo ri ñáyɨvɨ.” ");
INSERT INTO mxtNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yucuan chaha, ñima ca uvi tahan cuví ñu, soco cha nanduvi̱ ñu noo ri ñáyɨvɨ. Yucuan chaha, cha sandu ɨɨ̱n ri Nyoo ña tahán chi cha sasɨɨn ñáyɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tyicuan ta candaca̱ tuhun ra chi ra Jesús ta cacatyí ra: ―¿Ñáá tuhun cha tyaa̱ ra Moisés vatyi cuví cahnya noo rayɨɨ tutu chihin ñasɨhɨ ra ta sandoo ra chi ña? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta ra Jesús catyí ra chi ra: ―Cha cuenda cha ndavá añima ndo, yucuan chaha, chaha̱ ra Moisés cha sandoo ra ñasɨhɨ ra. Soco quɨvɨ xihna ri ñima tyicuan caa cuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yuhu catyí chi ndo tyehe caa: Ra cha sandoo̱ ñasɨhɨ, ta ñima cha cuenda cha natuvi̱ ña chihin inga ra, ta tandaha̱ ra chihin inga ñu, chicoo̱ cuatyi ra nuu Nyoo. Ta ra cha tandaha chihin noo ñaha sɨhɨ cha sandoo̱ yɨɨ chi, suri chicoo̱ tucu cuatyi ra cuan ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tyicuan ta ra cachicá noo chihin ra, cacatyí ra chi ra: ―Tatu tyicuan caa tahán chi coo rayɨɨ chihin ñasɨhɨ ra, vaha taxin ca ma tandaha yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta ra Jesús catyí ra chi ra: ―Soco ña tandɨhɨ ñáyɨvɨ cuví cutuñi iñi ñu tuhun ihya. Soco ñu cha chaha̱ Nyoo cha cutuñi iñi, ican ñu cua cutuñi iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Cha ña tandaha ñáyɨvɨ, cuaha ri cuenda cuví. Yɨhɨ́ ñu ña quichi cuví iñi ñu tandaha ñu vatyi ɨɨn caa maa ñu cacu ñu. Ta inga ñu ña quichi cuvi iñi ñu tandaha ñu vatyi cha yaha tava ñáyɨvɨ ñɨɨ ñu. Ta yɨhɨ́ ñu ña tandaha̱ ñu cha cuenda cha cuñí ñu sacuvi ñu tyiño nuu Nyoo, na nducuaha añima cha nyacá ñaha Nyoo. Tandɨhɨ ñu cuví sacuvi tyehe caa, na sacuvi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tyicuan ta quichi̱ nyaca ñu suhva ra cuatyaa chi ra Jesús tacuhva na tyiso ra ndaha ra sɨquɨ ndotyin, ta cacan tahvi ra chaha ndotyin. Soco ra cachicá noo chihin ra quichaha̱ cacahan ra chi ñu quichi̱ nyaca chi ndotyin. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Soco ra Jesús catyí ra: ―Sa̱ña ndo chi ra cuatyaa, na quichi maa ndotyin nu nyaí. Ta ma casɨ ndo. Vatyi ñu nyacá ñaha Nyoo añima, cuví ñu tari ra cuatyaa ihya ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tyicuan ta tyiso̱ ra ndaha ra sɨquɨ ndotyin. Yaha̱ cuan ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Noo ra tyivaa chaha̱n ra chindaca̱ tuhun ra chi ra Jesús ta catyí ra: ―Maestro vaha xaun. ¿Ñáá cha vaha tahán chi sacuvi ta ñihi ñayɨvɨ̱ cha ma naa ca maa coi? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta ra Jesús catyí ra chi ra: ―¿Ñáá tuhun cha catyun tyi vaha yuhu? Noo ri ra vaha iyó ta ican ra cuan cuví Nyoo. Ta cha catyun tyi vahi, nacotón tyi Nyoo cuvi. Soco tatu cuñún quɨhvun ñayɨvɨ̱ cha ma naa ca maa, sa̱cuvun tandɨhɨ tuhun cha tachi̱ Nyoo tyi sacuvi yo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta ra tyivaa cuan catyí ra: ―¿Nya cha cuví cuan? Ta ra Jesús catyí ra chi ra: ―Ma cahñun chi ñáyɨvɨ. Ma coo inga ñusɨhɨ chuun. Ma suhun cha chii ñáyɨvɨ. Ma cahun cuendu sɨquɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Sa̱ha ñáyɨvɨ chi sutun ta chi sɨhun. Ta cu̱ñun chi ñáyɨvɨ, tari cha cuñún chi maun. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta ra tyivaa cuan, catyí ra chi ra: ―Tandɨhɨ tuhun ihya ta quichahí nyata luhli ta nya vityin. ¿Ñáá ca cha cumañí chii? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta ra Jesús catyí ra chi ra: ―Tatu cuñún cuvun noo ra cuɨtɨ nuu Nyoo, cua̱han ta xi̱con cha iyó chuun, ta cu̱hvon chi ñu ndahvi, ta cu̱nyicon chii. Tyicuan ta coo cha tyayɨɨ chuun nya gloria ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Soco cuhva cha chiñi̱ ra tyivaa cuan cha caha̱n ra Jesús tyehe caa, cuihya xaan cuanuhu ra vatyi tyayɨɨ xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tyicuan ta ra Jesús catyí chi ra cachicá noo chihin ra: ―Cha ndicha catyí chi ndo vatyi yɨɨ xaan cuhva ra tyayɨɨ cha cunyaca ñaha Nyoo añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Catyí chi ndo inga chaha, vatyi numi ca yaha noo camellu xiyu noo yɨquɨ tɨcu, ta ñima ca noo ra tyayɨɨ ta cuhva ra chi ra cha cunyaca ñaha Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cha cachiñi̱ ra cachicá noo chihin ra tuhun ihya, iyo xaan cacuñi̱ ra, ta quichaha̱ candaca tuhun ra chi ra tahan ra, ta cacatyí ra: ―Tu tyicuan caa, ¿yóó cha cuví cacu vii? ");
INSERT INTO mxtNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tyicuan ta nanyehe̱ ra Jesús nu nyicú ra ta catyí ra: ―Ñáyɨvɨ ma cuvi sacuvi ñu tyehe caa, soco Nyoo cuví sacuvi ra tandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tyicuan ta quichaha̱ catyí ra Pedro chi ra: ―Sutu Mañi yuhu, nyuhu tandɨhɨ maa cha iyó chi ndi sandoo̱ ndi ta nyicón ndi chuun. ¿Ñáá cha cuñihi ndi? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta nacaha̱n ra Jesús ta catyí ra: ―Cha ndicha catyí chi ndo, vatyi quɨvɨ cha cunduchaa tandɨhɨ, yucuan quɨvɨ yuhu Rayɨɨ cha quichi̱ nya gloria cucunyai ta cunyaca ñahi, ta nyoho cha nyicón ndo chii, cunyaa tucu nyoho nu uchi uvi tahan tyayu tyaquɨ. Ta cunyaca ñaha ndo chi ndɨ uchi uvi tahan ityi ñáyɨvɨ Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta tandɨhɨ ndo cha sandoo̱ ndo vehe ndo, o yañi ndo, o cuhva ndo, o sutu ndo, o sɨhɨ ndo, o ñasɨhɨ ndo o sehe ndo, o ñuhú ndo cha catyí yuhu, cunañihi ndo noo cientu ca chaha sɨquɨ cuan, ta cunañihi tucu ndo ñayɨvɨ̱ cha ma naa ca maa coo ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cuaha xaan ñu cuahan ityi nuu vityin, ican ñu cuan, cuhun nya nu ndɨhɨ. Ta cuaha xaan ñu cuahan nu ndɨhɨ vityin, ican ñu cuhun ñu ityi nuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Cha nyacá ñaha Nyoo añima ñáyɨvɨ, cuví chi tari noo chitoho chacu yoho tɨchaha ndɨvɨ. Ta chitoho chacu cuan ñaha cuiri quita̱ ra cuanducu ra cuaha ri musu cusaha tyiño nu tyiño saha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta sandaa̱ ra tyiño chihin musu cuan vatyi cutyiyahvi ra yahvi cha tahán chi chi ra cha noo quɨvɨ, ta tachi̱ ra chi ra cusaha tyiño ra nu iyó tyiño sahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yaha̱ cuan ta quita̱ tucu ra cuhva cha caa ɨɨn cha ñaha ri. Ta nanyehe̱ ra chi suhva ca ra canyicú ri maa nuyahvi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta catyí ra chi ra: “Cua̱han tucu nyoho cua saha tyiño ndo nu iyó tyiño sahí, ta tyiyahvi mai yahvi cha tahán chi chi ndo.” Tyicuan ta cuahan coyo tucu ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tyicuan ta chitoho chacu cuan quita̱ tucu ra inga chaha cuhva cha ora. Yucuan ta quita̱ tucu ra cuhva cha caa uñi cha cha iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta yaha̱ cuan ta quita̱ tucu ra cuhva cha caa ohon cha cha iñi ta nanyehe̱ ra canyicú ri maa suhva ca ra nuyahvi cuan. Ta catyí ra chi ra: “¿Ñáá tuhun cha canyicú ri maa nyoho ndiyaca ihya, ta ña sahá tyiño ndo?” ");
INSERT INTO mxtNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta canacaha̱n ra cuan ta catyí ra: “Yori maa caha̱n chihin ndi cha cusaha tyiño ndi.” Tyicuan ta catyí ra chi ra: “Cua̱han tucu nyoho cua saha tyiño ndo nu iyó tyiño sahí. Ta tyiyahvi mai chi ndo yoso cuhva cha tahán chi chi ndo”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ta cuhva cha cuaa cuan, chitoho tyiño cuan catyí ra chi ra cuví nuu chi musu cuan: “Na canon chi musu, ta tyi̱yahvun chi ra. Qui̱chaha tyiyahvun chi ra cha caquɨhvɨ̱ nu ndɨhɨ, ta nu ndɨhɨ ta tyi̱yahvun chi ra cha caquɨhvɨ̱ cha xihna ri”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tyicuan ta chaa̱ coyo ra cha caquɨhvɨ̱ cuhva cha caa ohon cha cha iñi cuan. Ta tahan tahan ra quehe̱n ra yahvi nanɨɨ noo quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaha̱ cuan, ta cuhva cha tahán chi chi ra cha caquɨhvɨ̱ coyo cha xihna ri cuan, cacuñí maa ra vatyi cuaha ca cutyiyahvi ra chi ra. Soco suri ɨɨn ri yahvi noo quɨvɨ caquehe̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta cuhva cha caquehe̱n ra, quichaha̱ cacahan ra chi chitoho tyiño cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ta catyí ra: “Ra cha cachaa̱ coyo nu ndɨhɨ ihya, noo tuhun hora casaha̱ tyiño ra. Ta ɨɨn ri cuhva tyiyahvu̱n chi ra chihin nyuhu cha saha̱ tyiño ndi nu cahñi ndiyaca”, cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Soco nacaha̱n chitoho tyiño cuan, ta catyí ra chi noo ra cuan: “Amigo, ñahri cha ña vaha sacuví chuhun. ¿Atu ñima yahvi cha noo quɨvɨ catyi̱ vatyi tyiyahvi chuun? ");
INSERT INTO mxtNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Que̱hen yahvun, ta cua̱nuhu. ¿Atu ñahri ityi iyó chii cha tyiyahvi chi ra cha quɨhvɨ̱ nu ndɨhɨ ɨɨn ri cuhva cha tyiyahvi̱ chi yoho? ");
INSERT INTO mxtNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Atu ñahri ityi iyó chii cha sacuvi cha cuñí mai chihin xuhin? ¿Atu quiñi cuñún tyi vaha ñáyɨvɨ cuví chihin inga ra cuan?” catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta tyicuan caa ñu quɨhvɨ̱ nu ndɨhɨ, cuhun ñu ityi nuu. Ta ñu cuahan ityi nuu, nya nu ndɨhɨ cuhun ñu. Vatyi cuaha xaan ñu nacaná Nyoo chi. Soco chiin xaan ri ñu nacachí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuhva cha cuñí cuhun ra Jesús nya Jerusalén, cana̱ sɨɨn ra chi ndɨ uchi uvi ra cachicá noo chihin ra ta catyí ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ta cha nyehe̱ maa ndo vatyi cuahan yo Jerusalén vityin. Ta yucuan cucuhva cuenda ñu chi yuhu Rayɨɨ cha quichi̱ nya gloria chi ra cacuví nuu chi tata sutu, ta chi ra casacuaha ley vehe ñuhu, ta cucatyi ra tyi tahán chi cúvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ta cucuhva cuenda ra chii chi ra ñuu Roma, ta cucuacu nyaa ra chii, ta cucañi ra chii, ta cucahñi ra chii nu cruzi. Soco nu cu uñi quɨvɨ cunandote ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tyicuan ta sɨhɨ ra Jacobo ta ra Juan sehe ra Zebedeo tuhva̱ ña nu nyaá ra Jesús chihin nɨnduvi sehe ña. Ta chicuiñi̱ chɨtɨ ña nuu ra vatyi cacan ña noo tumañi iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta quichaha̱ ndaca tuhun ra Jesús chi ña: ―¿Ñáá cha cuñún? Ta catyí ña: ―Quɨvɨ cha cunyaun nu nyacá ñahun nya andɨvɨ, cu̱hva cha cunyaa nɨnduvi sehi xiun. Na cunyaa noo ra chiyo vahun, ta inga ra cunyaa ra chiyo satyun. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Soco nacaha̱n ra Jesús ta catyí ra: ―Nyoho ña chitó ndo cha chicán ndo. ¿Atu cuví nyehe nyoho tɨndoho cha cunyehe yuhu? ¿Atu cuví cuhun ndo tuhun chihi tari cuhva cuhun yuhu? ―catyí ra. Ta canacaha̱n ra ta catyí ra: ―Cuví chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta catyí ra Jesús chi ra: ―Cha ndicha vatyi cunyehe ndo tɨndoho, ta cuhun ndo tuhun chihi tari cuhun yuhu tuhun chihi. Soco tuhun cha cunyaa ndo chiyo vahi ta chiyo satyin, ñima yuhu tahán chi cuhve chi ndo, soco maa Suti cucatyi ra yóó cha cuñihi nyatu cuan ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta cha cachiñi̱ uchi ca ra cachicá noo chihin ra Jesús tuhun cuan cacuxaa̱n ra chihin nɨnduvi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Soco cana̱ ra Jesús chi ra ta catyí ra chi ra: ―Cha chitó maa ndo, vatyi ra nyacá ñaha chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya, ñihi xaan nyacá ñaha ra chi ñu tari nyaca ñaha ra musu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Soco ñima tyicuan caa tahán chi sacuvi nyoho. Vatyi ra cha cuñí cucahnu ca nu Nyoo, cuñí chi cuví ra musu tandɨhɨ ca ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta nya nyoho cha cuñí ndo cuví ndo nuu, cuñí chi cuví ndo musu tandɨhɨ ca ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tari yuhu Rayɨɨ cha quichi nya gloria, ña vachi vatyi sacuvi ndo tyiño nui, soco vachi sacuvi tyiño nuu ndo, ta cuhve ñayɨvi̱. Vatyi chihin cuan ta cuvi sacaqui cuaha ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuhva cha cua quitá coyo ra ñuu Jericó, cuaha xaan ñáyɨvɨ cuahan chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta yuhu ityi cuan canyicú uvi tahan ra cuaa. Ta cuhva cha cachiñi̱ ra vatyi cua yaha ra Jesús, quichaha̱ canachaa ra. Ta catyí ra: ―Sutu Mañi yuhu, ra vachi tata ra David cuvún. ¡Cu̱ndahvi cuñi nyehun chi ndi! ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ta ñáyɨvɨ quichaha cahan ñu chi ra na cacasɨ ra yuhu ra. Soco maa ra ñihi ca cacana̱ chaa ra: ―Sutu Mañi yuhu, ra vachi tata ra David cuvún. ¡Cu̱ndahvi cuñi nyehun chi ndi! ");
INSERT INTO mxtNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tyicuan ta chicuɨñɨ̱ ra Jesús ta cana̱ ra chi nɨnduvi tahan ra cuaa cuan, ta ndaca̱ tuhun ra chi ra: ―¿Ñáá cha cuñí ndo cha sacuvi chihin ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta canacaha̱n ra ta catyí ra: ―Sutu Mañi yuhu, cuñí ndi nyehe ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tyicuan ta cundahvi cuñí ra Jesús nyehe ra chi ra, ta tɨɨ̱n ra chɨtɨ nuu ra. Ta caa cuhva ri cuan cananyehe̱ ra, ta cananyico̱n ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cuhva cha cua chaa̱ coyo ra ñuu Jerusalén, ta cachaa̱ ra ñuu Betfagé, yatyin ri nu cuví yucu yutun Olivo. Tyicuan ta tachi̱ ra Jesús tyiño chi uvi ra chicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ta catyí ra chi ra: ―Cua̱han ndo ñuu cha nyaá ityi nuu ihya. Ta yucuan cunañihi ndo noo burru sɨhɨ, nuhñí tɨ. Ta nyacá tɨ noo burru luhlu. Nda̱chi ndo chi tɨ, ta qui̱chi nyaca ndo chi tɨ chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta tatu yóó cha catyí ñáá cha catyí chi ndo, ca̱tyi ndo chi ñu: “Vatyi chiñuhú tɨ chi maa ra nyacá ñaha, soco numi ri quichi nanyaca ndi chi tɨ”, ca̱tyi ndo chi ñu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tyehe caa cuvi̱ tacuhva na chino cava tuhun cha catyí ra profeta nu tyaa̱ ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ca̱tyi ndo chi ñu ñuu Sión: “Nye̱he ndo, vachi rey maa ndo nu nyaá ndo. Ndahvi ri vachi ra yosó ra noo burru luhlu, sehe noo quɨtɨ cha tuhvá nyisó carga”, catyí ra profeta. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tyicuan ta cuahan coyo ra cachicá noo chihin ra, ta casacuvi̱ ra tari cuhva catyi̱ ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Caquichi̱ nyaca ra chi tɨ chihin sɨhɨ tɨ. Ta catyiso̱ ra sahma ra sɨquɨ tɨ, ta ndaa̱ ra Jesús chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta cuaha xaan ñáyɨvɨ candɨca̱ ñu sahma ñu ityi nu cuahan ra, ta inga ñu catoho̱n ñu numa yutun ta cachacu̱n ñu ityi. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ñáyɨvɨ cha cuahan ityi nuu ta ityi chata, quichaha̱ cana chaa ñu ta catyí ñu: ―¡Cahnu xaan cuví ra vachi tata rey David! ¡Cahnu xaan cuví ra vachi cuenda Sutu yo Nyoo! ¡Ta sacahnú xaan yo chi Nyoo nu nyaá ra ityi andɨvɨ! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuhva cha chaa̱ ra Jesús ñuu Jerusalén cuan, tandɨhɨ maa ñáyɨvɨ ñuu naquɨquɨ̱, ta cuaha xaan ñu candacá tuhun ñu chi tahan ñu, ta catyí ñu: ―¿Yóó ra cuví ra ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta ñáyɨvɨ catyí ñu: ―Ra Jesús, ra chahá cuenda tuhun cahan Nyoo, ra ñuu Nazaret nu cuví Galilea cuví ra ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yaha̱ cuan ta quɨhvɨ̱ ra Jesús chichi vehe ñuhu cahnu Nyoo. Ta tava̱ ñehe ra chi tandɨhɨ ra casatá ta ra caxicó yucuan. Ta sanduva̱ ra mesa ra canasamá xuhun chi ñáyɨvɨ yucuan. Ta sanduva̱ ra tyayu ra caxicó paloma. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta catyí ra: ―Nu tutu Nyoo catyí chi tyehe caa: “Vehi, vehe nu chicán tahvi ñáyɨvɨ chii cuví, ta tyicuan caa cucunañi chi. Soco nyoho cha nasaha̱ ndo vehe nu nyicú ra suhu” ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chichi vehe ñuhu cuan catuhva̱ suhva ra cuaa ta ra coxo chi ra Jesús. Ta maa ra sanduvaha̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Soco canyehe̱ ra cacuví nuu chi tata sutu ta ra casacuahá ley vehe ñuhu cuan vatyi savaha̱ ra Jesús milagru, ta canachaa̱ ra cuatyaa chichi vehe ñuhu, ta catyí ndotyin: ―¡Cahnu xaan cuví ra vachi tata rey David! ―catyí ndotyin. Tyicuan ta cacuxaa̱n tata sutu ta inga ra cuan cha canyehe̱ ra ta cha cachiñi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta cacatyí ra chi ra Jesús tyehe caa: ―¿Atu chiñún cha cahán ndotyin? Ta nacaha̱n ra Jesús ta catyí ra: ―Chiñí. Soco ¿atu ta sacuaha ca ndo nu tutu Nyoo nu catyí chi tyehe caa? Sutu Mañi yuhu, sacuvu̱n vatyi ra cuatyaa nyihi cata ndotyin. Ta ra cuatyaa lee cha chaxín sacahnú ndotyin chuun, catyí chi, ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tyicuan ta sandoo̱ ra chi ra, ta quita̱ ra ñuu cuan ta cuahan ra ñuu Betania. Ta yucuan ndoo̱ ra cha cuaa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tuvi inga quɨvɨ. Ta cha ñaha ri, cua ndichi ra Jesús nya Jerusalén, ta chaa̱ soco chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta nanyehe̱ ra noo tu higo yatyin ri yuhu ityi cuan. Ta tuhva̱ ra nu nanyaá tun, soco ñahri maa nañihi ra nuu tun. Maa maa ri maa numa ri iñi nuu tun. Tyicuan ta catyi̱ ra chi tun tyehe caa: ―¡Ni nonga chaha ma cuhva con chɨtɨ! Ta caa cuhva ri cuan ta na ityi tun. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta cha nyehe̱ ra cachicá noo chihin ra cha sacuvi̱ ra, iyo cacuñí ra, ta ndaca̱ tuhun ra chi ra ta catyí ra: ―¿Ñáá tuhun cha numi xaan na ityi tu higo cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta nacaha̱n ra Jesús ta catyí ra: ―Cha ndicha catyí chi ndo, vatyi tatu chinó iñi ndo ta ma nacaca uvi iñi ndo, ñima ihya ri cha sacuvi̱ chi tu higo ihya cuví sacuvi ndo, soco cuví catyi ndo chi yucu ihya tyehe caa: “Ca̱nyaha chuun ihya ta cua̱han nya chichi tyañuhu.” Ta tyicuan caa cucuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta tandɨhɨ cha cacan ndo nu chicán tahvi ndo, tatu chinó iñi ndo tyi cucuhva Nyoo, cuñihi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yaha̱ cuan ta quɨhvɨ̱ ra Jesús chichi vehe ñuhu cahnu, ta cha nɨ ri ca cha sañahá ra yucuan, tuhva̱ ra cacuví nuu chi tata sutu chi ra, ta ra cacuví mandoñi ñu ñuu Israel, ta candaca̱ tuhun ra chi ra: ―¿Yóó cha tyaa̱ tyiño vatyi sacuvun tyehe caa, ta yóó cha chaha̱ tyiño cuan chuun? ");
INSERT INTO mxtNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Ta nacaha̱n ra Jesús ta catyí ra: ―Yuhu tucu cua ndaca tuhin noo tuhun chi ndo. ¿Yóó cha tachi̱ chi ra Juan vatyi sacondutya ra chi ñáyɨvɨ? ¿Atu Nyoo tachi̱ chi ra, o ñáyɨvɨ? Tatu catyi ndo chii, cucatyi tucu yuhu chi ndo yóó cha tyaa̱ tyiño ihya chii ―catyí ra Jesús chi ra. Tyicuan ta quichaha̱ cacuvi yuhu ra chihin ra tahan ra, ta cacatyí ra: ―Tatu catyí yo tyi Nyoo tachi̱ chi ra, cucatyi ra chi yo: “Tu tyicuan caa, ¿ñáá tuhun ña chinó iñi ndo chi ra?” ");
INSERT INTO mxtNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta tatu catyí yo tyi ñáyɨvɨ, ñáyɨvɨ cuví nacanda ñu sɨquɨ yo, vatyi tandɨhɨ ñu chinó iñi ñu tyi ra Juan, cuenda Nyoo caha̱n ra ―catyí ra chi ra tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tyicuan ta quichaha̱ cacatyí ra chi ra Jesús tyehe caa: ―Ña chitó ndi. Tyicuan ta ra Jesús catyí ra chi ra: ―Ni yuhu, ta ma catyi chi ndo yóó cha tyaa tyiño ihya chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ra Jesús catyí ra chi ra: ―¿Yoso caa catyí ndo cuenda tuhun cha cua catyi ihya? Noo ra, iyó uvi tahan sehe ra. Ta catyí ra chi noo sehe ra: “Cua̱han cua saha tyiño nu iyó tyiño sahí.” ");
INSERT INTO mxtNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ta nacaha̱n sehe ra ta catyí ra: “¡Ma cuhin!” Soco yaha̱ cuan ta nasama̱ cuhva chicá xiñi ra ta chaha̱n ra chisaha tyiño ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yaha̱ cuan ta sutu ra chaha̱n ra nu nyaá inga sehe ra. Ta catyí tucu ra chi ra na cuhun ra cusaha tyiño ra. Soco ra yucuan numi ri quehe̱n ra tuhun, ta catyí ra: “Vaha, Tata, cuhin.” Soco ña chaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chichi cha nɨnduvi tahan ra, ¿nya ra sacuvi̱ ra cha catyi̱ sutu ra? ―catyí ra Jesús. Ta nacaha̱n ra ta cacatyí ra: ―Ra cha caha̱n ra chihin cha xihna ri. Ta catyí ra Jesús chi ra: ―Cha ndicha catyí chi ndo, vatyi xihna ca ra catavá xuhun cuenda gobiernu, ta ñu cata iñi cuquɨhvɨ ñu nu nyacá ñaha Nyoo, ican saha nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vatyi ra Juan ra sacondutya quichi̱ ra, quichi sañaha ra chi ndo yoso caa tahán chi coo ndo, soco nyoho ña chino̱ iñi ndo chi ra, soco ra catavá xuhun ta ñu cata iñi cachino̱ iñi ñu chi ra. Ta nyoho vasɨ nyehe̱ ndo ihya, soco ña nasama̱ ndo cuhva iyó ndo, tacuhva chino iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Tya̱soho ndo inga cuhva ihya: Chiyo̱ noo chitoho noo ñuhú, ta tachi ra yoho tɨchaha ndɨvɨ, ta tyihi̱ ra noo chacu. Ta savaha̱ ra noo nu cuhñi ra tɨchaha ndɨvɨ cuan ta tava ra ndutya chi. Ta savaha̱ tucu ra noo vehe sucun tacuhva vatyi cuvi saha ra cuenda tandɨhɨ. ’Yaha̱ cuan ta chaha̱ noo ra ñuhú cuan chi suhva ra casahá tyiño, ta cuahan ra inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta cha chaa̱ quɨvɨ cha iyó tɨchaha ndɨvɨ cuan, tachi̱ ra chi suhva musu, na cucacan ra chi ra casahá tyiño cuan, na cuhva ra suhva tɨchaha ndɨvɨ cha tahán chi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Soco ra casaha tyiño cuan, catɨɨ̱n ra chi musu cuan, ta cacañi̱ ra chi noo ra. Ta chi inga ra cachahñi̱ ra, ta catuchi̱ ra yuu chi inga ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tyicuan ta cha inga chaha, cuaha ca musu tachi̱ chitoho chacu cuan ta ñima ca cha xihna ri. Soco tari casacuvi̱ ra chi ra cha xihna ri, sacuvi̱ tucu ra chi ra ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Nu ndɨhɨ tachi̱ ra chi maa maa sehe ra, vatyi cuñí maa ra vatyi cusaha ra ñáyɨvɨ chi sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Soco cuhva cha cananyehe̱ ra casahá tyiño cuan chi sehe ra, catyí ra chi ra tahan ra tyehe caa: “Ican ra ihya cundoo chihin tandɨhɨ ihya. Na cahñi yo chi ra tacuhva ndoo maa yo chihin”, cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tyicuan ta catɨɨ̱n ra chi ra, ta catava̱ ra chi ra ityi chata chacu, ta cachahñi̱ ra chi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tyicuan ta ndaca̱ tuhun ra Jesús chi ñu: ―Quɨvɨ quichi chitoho ñuhú cuan, ¿ñáá cha cusacuvi ra chihin ra casahá tyiño quiñi iyó cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta nacaha̱n ra ta cacatyí ra: ―Ma cuatu ra, soco cahñi ra chi ra caquiñi iyó cuan. Ta cuhva ra ñuhú cuan chi inga ra casahá tyiño. Ta quɨvɨ coo tɨchaha ndɨvɨ, cunacuhva cuenda ra chi chitoho chacu cuan cha tahán chi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tyicuan ta quichaha catyí ra Jesús chi ñu: ―¿Atu ta sacuaha ca nyoho nu tutu Nyoo nu catyí chi tyehe caa? Yuu cha ña cuñi̱ ra casavahá vehe cotyiño ra, ican cuan cuví yuu cha nɨñɨ ca. Ican ihya cuví cha sacuvi̱ Sutu yo Nyoo. Ta tyaquɨ xaan tuhun cuan cha cuenda chi yo, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Yucuan chaha catyí chi ndo vatyi ma cuhva ca Nyoo cuhun ndo nu nyacá ñaha ra, ta cucuhva ra chi ñu cha ndicha nyacá ñaha ra añima. Vatyi maa ñu cunacuhva cuenda ñu cha vaha cha tahán chi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta cha cuenda yuu cuan, yóó ñu cha nduva sɨquɨ chi, yɨquɨn maa cucuvi ñu. Ta tatu yuu cuan ta canacava sɨquɨ yóó ñu, cutaxin nyihi maa ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cuhva cha catuvi̱ iñi ra cacuví nuu chi tata sutu cuan ta ra fariseo vatyi cuenda ra caha̱n ra Jesús cuhva ihya, ");
INSERT INTO mxtNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","cacuñí ra catɨɨn ra chi ra, soco cayuhvi ra chi ñáyɨvɨ vatyi ñáyɨvɨ, chitó ñu vatyi ra Jesús cuenda Nyoo cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Quichaha̱ cahan tucu ra Jesús chihin ñu inga chaha chihin cuhva, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo rey cha savaha̱ noo vico cha cuenda cha cua tandaha sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta tachi̱ ra chi musu ra na cuhun ra cucana ra chi ñu cha nacatyi̱ tuhun ra, soco ñu cuan, ña cacuñí ñu quichi coyo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tachi̱ ra inga chaha chi inga musu, ta catyi̱ ra chi ra tyehe caa: “Ca̱tyi ndo chi ñu cha nacatyi̱ tuhin, vatyi cha yaha̱ chahñi̱ sɨndɨquɨ sane, ta inga quɨtɨ cha xahan ñandɨhɨ, ta cha nyaá vaha nyayu, ta tandɨhɨ cha nyatú tuhva. Na quichi ñu vico tandaha”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Soco ñu nacatyi̱ tuhun ra, ña caquichaha̱ ñu chi ra. Noo ñu chaha̱n coyo ñu nu iyó chacu ñu, inga ñu chaha̱n ñu nu tyiño sahá ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta inga ñu tɨɨ̱n ñu chi musu rey cuan ta cañi̱ vavaha ñu chi ra nyacua chahñi̱ ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tyicuan ta rey cuan cuxaa̱n vavaha ra, ta tachi̱ ra chi sɨndaro ra, cucahñi ra chi ra cachahñi̱ cuan, ta cahmi ra ñuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tyicuan ta quichaha̱ catyí ra chi musu ra: “Tandɨhɨ ta cha iyó vaha cha cuenda vico tandaha, soco ñu nacatyi̱ tuhin cuan, ña tahán chi cha quichi coyo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cua̱han ndo tandɨhɨ calle ta na̱catyi tuhun ndo chi tandɨhɨ ri ñu cha nañihi ndo na quichi coyo ñu vico tandaha”, catyí rey cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Musu cuan cuahan coyo ra tandɨhɨ calle, ta casandu ɨɨ̱n ri ra chi tandɨhɨ ñu canañihi̱ ra: ñu quiñi iyó, ta ñu vaha. Ta tyicuan caa chitu chichi vehe ra chihin ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tyicuan ta quɨhvɨ̱ rey cuan cua nyehe ra chi ñáyɨvɨ cha canacatyi̱ tuhun musu cuan. Ta nanyehe̱ ra chi noo ra ñohó yucuan, soco ñahri sahma vico tandaha ñihnó ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta catyí rey chi ra: “Amigo, ¿yoso caa cha quɨhvu̱n ihya ta ñahri sahma vico tandaha ñihnón?” Soco ra cuan ña na caha̱n maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tyicuan ta catyí rey cuan chi ra catyihí mesa cuan: “Cu̱hñi ndo chaha ra ta ndaha ra, ta tu̱chi ndo chi ra nu ñaa iñi ityi chata vehe, ta yucuan cucuacu ra, ta cusacahñi ra noho ra”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Vatyi cuaha xaan ñu nacana̱ Nyoo chii, soco chiin xaan ñu nacachi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tyicuan ta catyihi̱ tahan ra fariseo tuhun chihin tahan ra vatyi cusacahan ra chi ra Jesús noo cuhva cha ña tahán chi, vatyi tyicuan caa ta coo cuatyi catyaa ra sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta tachi̱ ra chi suhva ra cuenda ra, ɨɨn ri chihin suhva ra cuenda ra Herodes. Ta cacatyí ra chi ra Jesús tyehe caa: ―Maestro, chitó ndi vatyi cha ndicha cahún. Ta chihin cha ndicha sañahún ityi Nyoo. Ta ña quichahún cha cahán ñáyɨvɨ, vatyi ña tɨɨ́n cuendon cuhva caá ri ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ca̱tyi chi ndi yoso caa chicá xiñun: ¿Atu vaha cha tyiyahví yo cha chicán gobiernu ñuu Roma chi yo, o ma tyiyahvi yo? ");
INSERT INTO mxtNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Soco tuvi̱ iñi ra Jesús vatyi ña vaha cuhva cachicá xiñi ra, ta catyí ra chi ra: ―Nyoho sahá ndo tyi vaha ndo, soco ña ndicha ndo. ¿Ñáá tuhun cha nducu nyehe ndo chii? ");
INSERT INTO mxtNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sa̱ñaha ndo xuhun cha tuhva ndo tyiyahvi ndo chi gobiernu ―catyí ra. Ta caquichi̱ nyaca ra noo xuhun cha nañí denariu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ta cuhva cha nanyehe̱ ra Jesús, ta quichaha̱ ndaca tuhun ra chi ra: ―¿Yóó chi nuu ta yóó chi sɨvɨ nyaá ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta nacaha̱n ra ta cacatyí ra: ―Chi ra nyacá ñaha. Tyicuan ta catyí ra Jesús chi ra: ―Cu̱hva ndo chi ra nyaca ñaha cha tahán chi chi ra, ta cu̱hva tucu ndo chi Nyoo cha tahán chi chi Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cuhva cha cachiñi̱ ra cha caha̱n ra Jesús, iyo xaan cacuñi̱ ra. Ta cuahan coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Suri quɨvɨ cuan suhva ra saduceo chaha̱n coyo ra nu nyaá ra Jesús. Ta ra saduceo cuan ña cachino iñi ra cha cunandoto ndɨyɨ quɨvɨ cu naa ñayɨvɨ̱. Yucuan chaha candaca̱ tuhun ra chi ra Jesús, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, ra Moisés catyi̱ ra vatyi tatu noo ra tandaha̱ ta chihi̱ ra ta ña chiyo̱ sehe ra, tahán chi cha tandaha yañi ra chihin ñaha chihi̱ yɨɨ cuan. Tyicuan ta coo sehe ra chihin ña cha cuenda yañi ra cha chihi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vaha. Vityin tyehe caa cuvi̱ chi noo ra chiyo ucha tahan ra chihin yañi ra. Ra cha xihna ri tandaha̱ ra. Yaha̱ cuan ta chihi̱ ra. Soco vatyi ña chiyo̱ sehe ra, ndoo ñasɨhɨ ra chi yañi cu uvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta suri tyicuan caa cuvi̱ chi yañi ra ra cu uvi. Ta yaha̱ cuan, ta ra cu uñi quehen ra chi ña, ta suri chihi̱ tucu ra. Ta tyicuan caa cuvi̱ chi ndɨ ucha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta cha yaha̱ cuan nu ndɨhɨ tuhun chihi̱ ndɨhɨ maa ña cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta cha tyicuan caa, quɨvɨ cunandoto ñu, chichi cha ucha ra chihin yañi ra, ¿nya ra cucuvi ñasɨhɨ chi ñaha cuan? ¿Vatyi tandɨhɨ ra tandaha ra chihin ña? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nacaha̱n ra Jesús ta catyí ra: ―Nyoho, cahán tondo ri maa ndo, cha cuenda vatyi ña chitó ndo cha nyaá nu tutu Nyoo, ni tunyee iñi Nyoo, ta ña chitó ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vatyi quɨvɨ cunandoto ndɨyɨ, ni ma tandaha ñu, ta ni ma cuhva ñu sehe ñu tandaha, vatyi tari ángel Nyoo ra nyaá andɨvɨ cucuvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Soco tuhun cha nandotó ñu ndɨyɨ, ¿atu ta sacuaha ca ndo tuhun cha catyi̱ maa Nyoo chi ndo? Catyí ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yuhu cuví Nyoo cuenda ra Abraham, ta ra Isaac ta ra Jacob.” Ihya nyehé yo vatyi canyito añima ra cuan, vasɨ cha naha chihi̱ ra vatyi Nyoo ñima Nyoo cuenda ñu ndɨyɨ cuví ra, soco Nyoo cuenda ñu nyitó cuví ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iyo cuñí ñáyɨvɨ cha chiñi̱ ñu tuhun sañahá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cha cachito̱ ra fariseo vatyi ra Jesús chasɨ̱ ra yuhu ra saduceo, candu ɨɨ̱n ri ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ta noo ra cha cuví ra sacuahá ley vehe ñuhu, cuñi̱ ra nducu nyehe ra chi ra Jesús. Ta quichaha ndaca tuhun ra chi ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿nya mandamiento cha nyaa nu ley cuví cha nɨñɨ ca? ");
INSERT INTO mxtNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta catyí ra Jesús chi ra: ―“Cu̱ñun chi Sutu Mañi yo Nyoo chihin cha nɨɨ iñun ta chihin cha tandɨhɨ añimon, ta chihin cha tandɨhɨ cha chiñi tuñi xiñun.” ");
INSERT INTO mxtNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ican ihya mandamiento cha nɨñɨ ca, ta cha xihna ri ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta cha cu uvi cha yatyin ri tyicuan caa, ta catyí chi: “Cu̱ñun chi ñáyɨvɨ tahun tari cuñún chi maun.” ");
INSERT INTO mxtNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ican uvi tahan mandamiento ihya cuví cha nyisó chi ley cha chaha̱ Nyoo chi ra Moisés ta tandɨhɨ tuhun cha casañaha̱ ra profeta Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cha nɨ ri ca cha canyicú ɨɨn ri ca ra fariseo, ");
INSERT INTO mxtNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ra Jesús ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Yoso caa chicá xiñi nyoho cuenda ra cuví Cristo? ¿Yóó chi tata vachi ra cuñí maa ndo? Ta canacaha̱n ra ta catyí ra: ―Tata ra David cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tyicuan ta ra Jesús catyí ra chi ra: ―¿Ta yoso caa cha vatyi ra David cuan, maa Tatyi Ii Nyoo chotyiño̱ chi ra? ta catyi̱ ra vatyi ra cuví Cristo, ra nyacá ñaha chi ra cuví ra, vatyi catyi̱ ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Caha̱n Suti Nyoo chihin Suti ra Cristo, ta catyí ra chi ra: “Cu̱nyaa chiyo vahi nyacua nya quɨvɨ cuhve chi ra xaan iñi chuun vatyi cuaca chahun sɨquɨ ra” tyaa̱ ra David. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Yoso caa cha ra vachi tata ra David cuví chi ra Cristo, tatu suri maa ra David catyi̱ ra vatyi ra Cristo Sutu ra cuví chi ra? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ta yori maa cuvi̱ nacaha̱n ni noo tuhun. Ta nya ndaha quɨvɨ cuan, yori ca maa caña̱ iñi candaca tuhun ñáá ca cha candaca tuhun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tyicuan ta ra Jesús catyí ra chi ñáyɨvɨ, ta chi ra cachicá noo chihin ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ra sacuahá ley ta ra fariseo nyicú ra tyiño cha sañahá ra ley cha tyaa̱ ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ta cha tyicuan caa, qui̱chaha ndo cha cahán ra ta sa̱cuvi ndo tandɨhɨ cha cacatyí ra chi ndo. Soco ma quehen ndo cuhva iyó ra, vatyi maa ra, sɨɨn cha sañaha ra, ta sɨɨn cha sacuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vatyi yori ndoyo carga cha tyaá ra sɨquɨ ñáyɨvɨ. Ta sanɨñɨ ra chi ñu na cuiso ñu, ta maa ra ni chiin nundaha ra ña nañi chata carga cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tandɨhɨ cha casacuví ra, cha cuñi ra na nyehe ñáyɨvɨ. Vatyi tahán iñi ra catyaa ra tuhun Nyoo tyaan ra ta soco ra chihin letra nahnu. Ta tahán iñi ra cacuihno ra sahma chihin adorno nañi. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta nu vaha ca, cuñí ra cunyicu ra vico, ta cachi ra. Ta nu vaha ca cuñí ra cunyicu ra chichi vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta nu chicá noo ra cacuñí ra vatyi cuhva ñáyɨvɨ nocumi chi ra chihin cha sahá xaan ñu ñáyɨvɨ chi ra. Ta cuñí tucu ra cha catyi ñu chi ra vatyi chito xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Soco nyoho, ma cuhva ndo ityi cha catyi ñáyɨvɨ vatyi chitó xaan ndo. Vatyi tandɨhɨ nyoho, yañi ndo cuví. Ta noo ri ra chitó iyó, ta ican ra cuví Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta ma catyi ndo Sutu ndo chi ninoo ra ñuhu ñayɨvɨ ihya, vatyi iyó noo Sutu ndo, ta nyaá ra andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta ma catyi ndo vatyi ra cuví nuu cuví ndo, vatyi noo ri maa ra Cristo cuví nuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ra cha sacuví tyiño nuu tandɨhɨ ca ra, ican ra cuan cuví ra cahnu ca nu nyicú ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vatyi ra cahnu sahá chii, cunocuee ra. Ta ra ña cahnu sahá chii cucucahnu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ndahvi nyoho ra sacuahá ley vehe ñuhu, ta ra fariseo! ¡Ndahvi nyoho cha sahá ndo tyi vaha ndo! Vatyi chasɨ́ ndo yuvehe nu nyacá ñaha Nyoo, tacuhva ma cuvi quɨhvɨ ñáyɨvɨ. Ta ni ri maa ndo ña quɨhvɨ́ ndo ta ni ña chahá ndo cha quɨhvɨ ñáyɨvɨ, ñu cuñí quɨhvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ndahvi nyoho ra sacuahá ley ta ra fariseo, nyoho cha sahá ndo tyi vahá ndo! Vatyi tinyaá ndo vehe ñu chihi̱ yɨɨ, tyi ña cuví tyiyahvi ñu ñáá xuhun tavá ndo sɨquɨ ñu. Ta yaha̱ cuan, ta naha chicán tahvi ndo nu tuvi vatyi sahá ndo tyi vaha ndo. Ta cuenda cha sacuví ndo tyehe caa, cahnu ca tɨndoho cunyehe ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Ndahvi nyoho ra sacuahá ley vehe ñuhu, ta ra fariseo. ¡Sahá ndo tyi vaha ndo, soco ña ndicha ndo! Vatyi nducú xaan ndo cuhva na cunyicon ñáyɨvɨ chi ndo. Ta tatu cha nandɨhvɨ ñu cuenda ndo, quiñi caa nɨcoo ñu saha ndo, ta ñima ca maa ndo. Ta cha tyicuan caa nyacuví ndo, ñihi ca sacuhún ndo chi ñu anyaya cha nuu maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ndahvi nyoho ra ndahvi! Vatyi cuñí ndo saquehen ityi ndo chi ñáyɨvɨ, ¡soco cuaa ndo! Vatyi catyí ndo tatu noo ñu catyí ñu cha cusacuvi ñu noo cha cusacuvi ñu, ta tyanaha ñu chihin sɨvɨ vehe ñuhu, yucuan ña nɨñɨ cha sacuvi ñu. Soco tatu xuhun cuaan cha iyó vehe ñuhu cuan tyanaha ñu, yucuan ndicha, nɨñɨ cuñí chi cha sacuvi ñu, catyí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tondo xaan ndo ta cuaa ndo! ¿Nya cha nɨñɨ ca? ¿Atu nɨñɨ ca xuhun cuaan cuan, o vehe ñuhu cha sacu ii chi xuhun cuaan cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta suri catyí tucu ndo: “Tatu yɨhɨ́ ñu catyí ñu cha cusacuvi ñu cha cusacuvi ñu, ta tyanaha ñu cuenda arta cha yoso cha chahá cuenda ñu chi Nyoo, ña nɨñɨ cha sacuvi ñu. Soco tatu tyanaha ñu cuenda ofrenda cha yosó sɨquɨ arta cuan, yucuan ndicha nɨñɨ cuñí chi sacuvi ñu, catyí ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tondo xaan ndo ta cuaa ndo! ¿Nya cha nɨñɨ ca? ¿Atu nɨñɨ ca ofrenda o arta cuan cha sacu ii chi ofrenda cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Vatyi ñu tyanahá cuenda arta cuan, ñima cuenda ri cuan tyanaha ñu, soco cha cuenda tandɨhɨ cha yosó nuu ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta ñu tyanahá cuenda vehe ñuhu cahnu, ñima cuenda vehe ñuhu ri cuan, soco cuenda Nyoo tyanahá ñu ñandɨhɨ, vatyi iyó ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta tyicuan caa tucu ñu tyanahá cuenda andɨvɨ, tyanahá tucu ñu cuenda tyayu Nyoo ta suri cha cuenda maa Nyoo ñandɨhɨ, tyi maa ra cuví ra nyaá nyacá ñaha yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ndahvi nyoho ra sacuahá ley vehe ñuhu ta ra fariseo! sahá ndo tyi vaha ndo vatyi chahá ndo diesmo chi Nyoo cha cuví menta, ta añii, ta comino. Soco ña quichahá ndo tuhun cha nɨñɨ ca cha nyaá nu ley cha tahán chi sacuvi yo. Ta cuñun, cha sacuví yo cha vaha chihin tandɨhɨ ñáyɨvɨ, cha cundahvi cuñi yo chi ñu, cha chinó iñi yo chi Nyoo ta ma sandoo yo chi ra. Ican ihya cuñí chi sacuvi ndo, ta ma sandɨhɨ ndo cha cuhva ndo diesmo cuan ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyoho cuñí ndo casaquehen ityi ndo chi ñáyɨvɨ, soco cuaa ndo. Vatyi sacuita ndo noo tiyucun luhlu, soco coco ndo noo camellu. Cuatyi luhlu ri nyehe ndo ta ña sahá ndo cuenda cuatyi cahnu cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ndahvi nyoho ra sacuahá ley vehe ñuhu ta ra fariseo, ra casaha tyi vaha! Vatyi ityi chata ri vasu ta ityi chata ri coho sanduvií ndo, soco ityi chichi ña sanduvií ndo. Vatyi chichi añima ndo tyitu ñohó cha quiñi caa. Chicá xiñi ndo cha ñihi ndo nu cusuhu ndo, ta ña cuví chasaha ndo cha quiñi caa cha quichi cuvi xaan iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ra fariseo cuaa cuví ndo! Sa̱nduvii xihna ndo ityi chichi vasu ta coho, tyicuan ta cuvii tucu ityi chata. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ndahvi nyoho ra sacuahá ley vehe ñuhu ta ra fariseo, ra casavaha chii! Vatyi cuví ndo tari noo ñaña ndɨyɨ cha nacahyu, vatyi ityi chata chi tyaquɨ xaan, soco ityi chichi tyitu ñohó yɨquɨ ndɨyɨ, ta tandɨhɨ nuu cha quiñi caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tyicuan caa cuví nyoho. Vatyi ityi chata tari maa tyi vaha xaan ndo nuu ñáyɨvɨ, soco ityi chichi, tyitú ñohó cha cuendu ndo, ta cha quiñi caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ndahvi nyoho ra sacuahá ley vehe ñuhu, ta nyoho ra fariseo! Sahá ndo tyi vaha ndo ta ña ndicha. Nyoho samá ndo ñaña ra profeta Nyoo ra chiyo̱ ta cha naha. Ta nyoho nacahyu ndo ñaña ñáyɨvɨ vaha ñu chiyo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta yucuan ta catyí ndo! “Tyehe ta chiyo̱ ndi quɨvɨ chiyo̱ ñáyɨvɨ chahnu ndi, ma tyinyee ndi chi ra chahñi̱ chi ra profeta Nyoo”, catyí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","¡Ma chihin yucuan ri! Suri maa ndo nacotó ndo vatyi vachi ndo tata ñu cachahñi̱ chi profeta Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Vaha vityin, chaha chi cuhva savaha ndɨhɨ ndo cha quiñi caa cha quichaha savaha sutu chahnu ndo! ");
INSERT INTO mxtNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Nyoho ñu quiñi iyó, ñu vachi tata coo! ¿Yoso caa cucacu nyoho tacuhva ma cuhun ndo anyaya? Ma cuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yucuan chaha cutachi chi ra profeta Nyoo nu nyicú ndo, cutachi tiqui chi ra chiñi tuñi, ta ra sacuahá nu nyicú ndo. Soco nyoho cucahñi ndo chi ra ta cutyaa ndo chi suhva ra nu cruzi. Ta chi inga ra cucañi ndo chi ra chichi vehe ñuhu. Ta cacanyicon ndo chi ra tahan tahan ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yucuan chaha, sɨquɨ ndo cucunyaa cuatyi cha cuenda cha cachihi̱ tandɨhɨ ra vaha cha cachahñi̱ ñu nyacua nya ra Abel ta nyacua nya ra Zacarías sehe ra Berequías ra cha chahñi̱ ndo chichi vehe ñuhu yatyin nu nyaá arta cha yosó cha chahá cuenda yo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cha ndicha catyí chi ndo, vatyi tandɨhɨ cuatyi ihya cucoso sɨquɨ ñáyɨvɨ cha iyó vityin ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, Jerusalén! ¡Ndahvi nyoho ñu iyó ñuu chiña! Vatyi chahñi̱ ndo chi ra profeta Nyoo. Ta tuchi̱ ndo yuu chi tandɨhɨ ra cha saquichi̱ Nyoo nu nyicú ndo. Cuaha xaan chaha cuñí saha cuende chi ndo, tari noo ndɨvɨ cha sahá cuenda tɨ chi sehe tɨ, ta naquehén ndahvi tɨ chi tɨ chichi ndichin tɨ, soco ña cuñí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nye̱he ndo vityin, vatyi cha sandoo̱ ndahvi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vatyi catyí chi ndo, vatyi ma nyehe ca ndo chii nyacua nya chaa chi quɨvɨ cucatyi ndo tyehe caa: “Cahnu xaan ra cuví ra vachi chihin tunyee iñi sɨvɨ Sutu yo Nyoo”, cucatyi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Quita̱ ra Jesús chichi vehe ñuhu cahnu cuan, ta cha cuñí cuhun ra, ta catuhva̱ ra cachicá noo chihin ra chi ra, ta quichaha̱ casañaha ra vehe ñuhu cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Soco nacaha̱n ra Jesús ta catyí ra: ―¿Atu nyehé ndo tandɨhɨ ihya? Cha ndicha catyí chi ndo, vatyi ihya ni noo yuu ta ma ndoo coso nyitahan. Tandɨhɨ ta cutanɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tyicuan ta cuahan coyo ra yucu yutun Olivo. Ta cuhva cha nyaá ra Jesús yucuan, ra cachicá noo chihin ra quichi̱ coyo ra ta catyí xehe ra chi ra tyehe caa: ―Cuñí ndi cha ca̱tyun chi ndi, ama cucuvi tuhun cuan. ¿Ñáá seña cucuvi cha cuquichun inga chaha ta cha cunaa ñayɨvɨ̱? ");
INSERT INTO mxtNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tyicuan ta nacaha̱n ra Jesús: ―Sa̱ha ndo cuenda chi ndo coto yóó cha sandahvi ñaha chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vatyi cuaha xaan ra cuquichi, ta cotyiño ra sɨvi, ta cucatyi ra tyehe caa: “Yuhu cuví Cristo ra cha saquichi Nyoo.” Ta cuaha ñu cusandavi ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nyoho cuñihi ndo tuhun tyi iyó cuatyi ta cañí tahan ñáyɨvɨ ityi cuan ityi ihya. Soco ma nayuhvi ndo, vatyi tyicuan caa tahán maa chi cuvi. Soco ta chaa ca quɨvɨ cunaa ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vatyi ñáyɨvɨ noo ñuu cahnu, cucañi tahan ñu chihin ñáyɨvɨ inga ñuu cahnu. Ta cucoo cuatyi noo ñuu chihin inga ñuu. Ta cucoo soco, ta cucoo cuehe, ta cha taan nahnu cuaha ri ityi. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tandɨhɨ ihya ta nu cua quichaha ñáyɨvɨ nyehe ñu tɨndoho cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Tyicuan ta cucuhva cuenda ñu chi nyoho vatyi sanyehe ra tɨndoho chi ndo. Ta cacahñi ra chi ndo. Ta tandɨhɨ ñu iyó sɨquɨ ñuhu ñayɨvɨ̱ cutasɨ cuñi nyehe ñu chi ndo cha cuenda yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Quɨvɨ cuan cuaha xaan ñu cusandɨhɨ ñu cha chino iñi ñu chii, ta cutasɨ cuñi ñu nyehe ñu chi tahan ñu. Ta cunaxico tuhun ñu chi tahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Cuaha xaan ra cuendu cunatuvi, ta cucatyi ra vatyi cuenda Nyoo cacahan ra. Ta cuaha xaan ñáyɨvɨ cucasandavi ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ta cuaha xaan cha quiñi caa cucoo. Yucuan chaha cuaha xaan ñu cusandɨhɨ ñu cha cuñi ñu chi tahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Soco ñu cha ña ndu uvi iñi chino iñi chii nyacua nya nu ndɨhɨ, cucacu añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta cucutya nɨcahnu ñayɨvɨ̱ tuhun vaha cha nyacá ñaha Nyoo añima ndo, tacuhva coto tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ, tyicuan ta cunaa ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Tandɨhɨ nyoho cha sacuahá ndo ihya, na cutuñi iñi ndo tuhun ihya: Ra Daniel, ra profeta Nyoo ta cha naha, tyaa̱ ra tuhun noo cha sacuquiñí caa, noo cha satɨvɨ́. Ta quɨvɨ nyehe ndo vatyi chaa ihya Nu Ii, ");
INSERT INTO mxtNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tyicuan ta ñu ñohó Judea, cuñí chi cono ñu ityi yucu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta ñu yosó xiñi vehe, noo ñu, soco ma quɨhvɨ ñu chichi vehe ñu tava ñu cha iyó chichi vehe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta ñu ñohó nu chiqui, ni ma cunuhu ca ñu cunaquehen ñu ni sahma ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ndahvi ñusɨhɨ cha cañohó sehe quɨvɨ cuan! O tatu iyó sehe ñu cha chaxín, ¡ndahvi ñu cuan! ");
INSERT INTO mxtNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ca̱can ndo chi Nyoo tacuhva cha ma tahan chi caca cono ndo quɨvɨ vichin, ni quɨvɨ nyitatú yo. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vatyi cuaha xaan tɨndoho cucoo quɨvɨ cuan, noo tɨndoho cha ta coo ca maa nyata chino̱ ñuhu ñayɨvɨ̱, ta ni ma coo ca cha yaha tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Soco tatu Nyoo, ta ma sanducuɨtɨ ra quɨvɨ cuan, yori maa cacu. Soco cusanducuɨtɨ ra cha cuenda cha cuñí ra chi ñu nacachi̱ maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ta tatu yóó cha catyí chi nyoho: “Nye̱he ndo, ma ra Cristo ihya” o “Nye̱he ndo ma ra nyaá yucuan”, ma chino iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vatyi cuquichi coyo ra casandavi ñaha ta cucatyi ra vatyi ra Cristo cacuví ra. Ta cucatyi ra vatyi ra profeta Nyoo cacuví ra. Ta cusavaha ra seña ta milagru nahnu tacuhva casandavi ñaha ra. Nyacua nya ñu cha nacachi̱ maa Nyoo ta cusandavi ñaha ra tatu cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sa̱ha ndo cuenda vatyi cha yaha̱ catyi chi nyoho cha ni cumañi ca cuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yucuan chaha tatu catyí ñu chi ndo tyehe caa: “Nye̱he ndo, ma ra Cristo nyaá nu chiqui ndɨɨ cuan”, catyí ñu chi ndo, ma cuhun ndo. O tatu catyí ñu chi ndo: “Nye̱he ndo, ma ra nyaá chichi cuartu ihya”, ma chino iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vatyi tari noo cha quɨhvɨ tacha cha nyehé yo cuxiño nya nu caña ñanyii ta nya nu quee ñanyii, tyicuan caa cucuvi quɨvɨ quichi yuhu Rayɨɨ cha quichi nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nu caá coño chihi̱, yucuan cuchaa coyo chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ta cha yahá ri cha nyehé ñu tɨndoho, ta cunduñaa ñanyii, ta yoo ma sacundichin ca chi. Ta tiñoo cucanacoyo tɨ andɨvɨ, ta nyacua nya cha iyó andɨvɨ cunacanda. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tyicuan ta cuquetuvi noo seña ityi andɨvɨ nu vachi yuhu Rayɨɨ cha quichi̱ nya gloria. Cuquichi nu vico ityi andɨvɨ chihin tunyee iñi cahnu ta chihin cha cahnu cuví Nyoo. Ta tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱, cucuacu chaa xaan ñu cha nanyehe ñu chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta cutachi ángel cuende tacuhva vatyi chihin cha ñihi tɨvɨ ra cutu ra ta cusandu ɨɨn ri ra chi ñu nacachi̱ maa Nyoo chi, cuquita ñu nɨcacahnu nu ñuhu ñayɨvɨ̱, nyacua nya nu ndɨhɨ ñuhu ñayɨvɨ̱ ta nyacua nya nu ndɨhɨ andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Cu̱tuñi iñi ndo noo cuhva yutun cha nañí higo: Tatu cha yutya soco tun, ta caña ndaha tun, nyoho cha chitó ndo vatyi cha vachi vico savi. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta suri tyicuan caa, tatu cha nyehé ndo tandɨhɨ maa cha cucuvi ihya, co̱to ndo vatyi cha cuyatyin quichi. Cha nyañaí yuvehe cuví chi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cha ndicha catyí chi ndo vatyi tandɨhɨ tuhun ihya, cucuvi cha nɨ ri ca cha iyó ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Andɨvɨ ta ñuhu ñayɨvɨ̱ cundɨhɨ chi, soco tuhun cahán yuhu, ma ndɨhɨ chi. Ta cuchino cava tandɨhɨ tuhun cahin chihin ndo ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Soco quɨvɨ ta cuhva cha cucuvi cuan, yori chitó, ni ángel andɨvɨ ta ña chitó ra. Ni yuhu Rayɨɨ cha quichi̱ nya gloria ta ña chité. Noo tuhun ri maa Nyoo Suti chitó ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tari cuvi̱ quɨvɨ chiyo̱ ra Noé, tyicuan caa cucuvi quɨvɨ quichi tucu yuhu Rayɨɨ cha quichi nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quɨvɨ ta ni cumañi ca coon savi xaan, ñáyɨvɨ cuan, chachí ñu, ta chihí ñu, tandahá ñu, ta chahá ñu chi sehe ñu tandaha nyacua nya quɨvɨ quɨhvɨ̱ ra Noé chichi barcu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta sana iñi ñu ta chaa̱ savi ta tyañi̱ tandɨhɨ ñu. Ta tyicuan caa cucuvi tucu quɨvɨ quichi tucu yuhu Rayɨɨ cha quichi̱ nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quɨvɨ cuan, tu uvi ra ñohó ra nu chiqui. Noo ra cunaquehin, ta noo ra ndoo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tu uvi ñusɨhɨ nyicó ñu molinu. Noo ña cunaquehin, ta noo ña ndoo ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cua̱tu tuhva vaha ndo vatyi ña chitó ndo ñáá cuhva cuquichi ra nyacá ñaha chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Soco co̱to ndo tuhun ihya vatyi tatu noo chitoho vehe ta chitó ra ñáá cuhva cuquɨhvɨ ra suhu chichi vehe ra, cuatu tuhva vaha ra ta ma cuhva ra cha quɨhvɨ ra suhu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yucuan chaha nyoho, cua̱tu tuhva ndo. Vatyi sana ri iñi ndo, ta cuquichi yuhu Rayɨɨ cha quichi nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Noo musu cha tyasohó tuhun cahán chitoho, ta tyicuan ri sacuví ra tyiño tyaa̱ ra chi ra, yucuan cuví noo musu vaha. Ta sahá cuenda ra vehe chitoho ra. Ta chahá ra cha cachi inga musu cha vahri cuhva. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ta sɨɨ xaan cuví chi musu cuan tatu cuhva cha sahá tyiño ra ta nachaa chitoho ra. Vatyi quichahá ra tandɨhɨ cha tahán chi sacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta cha ndicha catyí chi ndo, vatyi chitoho ra cunatyaa ra tandɨhɨ cha cumí ra ndaha ra, vatyi vaha quichahá ra chihin tyiño sahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Soco tatu noo musu quiñi iyó ta chicá xiñi ra vatyi naha cuahan chitoho ra, ");
INSERT INTO mxtNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ta quichaha nyacuvi ra cha ña vaha chihin inga musu cuan, ta quichaha chachi ra ta chihi ra ndixi chihin ra chiñi, ");
INSERT INTO mxtNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tyicuan ta sana iñi ra ta ndichi chitoho ra quɨvɨ cha ña nyatú ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tyicuan ta chitoho ra ñihi xaan cutachi tuñi ra chi ra chihin ñáyɨvɨ quiñi iyó cha savaha chii soco ña ndicha. Tyicuan ta cucuacu ra ta cusacahñi ra noho ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari uchi tahan ñu tyivaa cha quehe̱n ñu lámpara cha yɨhɨ́ acetye ta cuahan coyo ñu noo vico tandaha cua quehen cuenda ñu chi ra cha cua tandaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ohon tahan ñu, tondo xaan ñohó iñi ñu, ta ohon tahan ñu cachi xaan ñohó iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ñu cha tondo ñohó iñi cuan, canyisó ñu lámpara ñu soco ña quehe̱n ñu suhva ca acetye vatyi natyihi ñu chichi lampara ñu tatu ndɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Soco ñu cachi ñohó iñi cuan, canyisó sɨɨn ñu yutyi acetye chihin lámpara ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ta vatyi cucuee ca chaa ra cha cua tandaha cuan, catɨɨ̱n ñumahna chi tandɨhɨ ñu, ta caquixí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tyicuan ta ñáá cuhva ñuu, ta chiñi ñu noo ndusu cha catyí tyehe caa: “¡Cha vachi ra cha cua tandaha! ¡Qui̱ta ndo, que̱hen cuenda ndo chi ra!” catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tandɨhɨ ñu tyivaa cuan canducuita̱ coyo ñu ta quichaha casanduvaha ñu lámpara ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tyicuan ta quichaha catyí ohon ñu tondo ñohó iñi cuan chi inga ohon ñu cuan: “Cu̱hva ndo suhva acetye ndo chi ndi, vatyi cuñí ndahva lámpara ndi”, catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Soco ñu tyivaa cha cachi ñohó iñi cuan nacahan ñu tyehe caa: “Ma cuhva ndi vatyi coto ma ñihi, ni cha cuenda maa ndi ta ni cha cuenda maa ndo. Cua̱han taxi ndo nya nu quiyahví chi, ta sa̱ta ndo cha cuenda ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Soco cha nɨ ri ca cha cuahan coyo ndɨ ohon ñu cha tondo ñohó iñi cuan, cua sata ñu acetye, ta chaa̱ ra cha cua tandahá cuan. Ta ñu tyivaa cha nyatú tuhva cuan, quɨhvɨ̱ coyo ñu chihin ra chichi vehe nu cuacoo vico tandaha cuan. Ta nɨcunyasɨ̱ ri yuvehe. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yaha̱ cuan ta cachaa̱ coyo tucu ñu chisata̱ acetye cuan, ta catyí ñu: “¡Tata! ¡Tata! ¡Nu̱ña yuvehe naquɨhvɨ ndi!” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Soco maa ra nacaha̱n ra, ta catyí ra: “Cha ndicha vatyi ña ñohó nui chi nyoho.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tyicuan ta quichaha catyí ra Jesús: ―Cua̱tu tuhva ri nyoho, vatyi ña chitó ndo nya quɨvɨ ta ñáá cuhva cuquichi yuhu Rayɨɨ cha quichi Nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo ra cha cha nyaá cha cua quita cuhun inga ñuu. Ta cana̱ ra chi musu ra, ta chaha̱ cuenda ra xuhun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Chi noo ra chaha̱ ra ta cha ohon mil xuhun, ta chi inga ra chaha̱ ra ta cha uvi mil, ta chi inga ra tari noo mil. Chaha̱ ra chi noo noo ra yoso cuhva cha cuví saha tyiño ra chihin. Tyicuan ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Musu cha quehe̱n cuenda ohon mil xuhun cuan, saha̱ ra lucha chihin xuhun cuan, ta saha̱ ganaa ra nonga ohon ca mil chihin xuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ta suri tyicuan caa tucu ra cha quehe̱n cuenda uvi mil cuan, saha̱ ganaa ra uvi ca mil chihin xuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Soco ra cha quehe̱n cuenda noo ri mil cuan, chaha̱n ra ta chatya̱ ra noo yavi chichi ñuhú ta tixehe̱ ra xuhun chitoho ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cuaha quɨvɨ yaha̱ ta nachaa̱ chitoho musu cuan. Ta quichaha natava ra cuenda chihin noo noo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Xihna ca ra cha quehe̱n cuenda ohon mil xuhun cuan chaa̱, ta nacuhva̱ cuenda ra ohon ca mil sɨquɨ cuan, ta catyí ra: “Tata, ohon mil chahu̱n chii, ma inga ohon mil ihya cha saha̱ ganai.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ta chitoho ra catyí ra chi ra: “Vaha. Noo musu vaha xaan cuvún. Ta sacuvu̱n tandɨhɨ cha catyí. Ta vasɨ chiin ri xuhun chahi̱ chuun soco vaha xaan chotyiñon chi chi. Vityin cuaha ca cucuhva cuende chuun. Quɨ̱hvɨ nu vaha ihya, ta cusɨɨ cuñun chihin.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yaha̱ cuan ta chaa̱ tucu musu cha quehe̱n cuenda uvi mil xuhun cuan, ta catyí ra: “Tata, uvi mil chahu̱n chii, ma uvi ca mil ihya cha saha̱ ganai sɨquɨ.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ta catyí chitoho ra chi ra: “Vaha. Noo musu vaha xaan cuvún, ta sacuvún cha catyí. Vasɨ chiin ri xuhun chahi̱ chuun soco vaha xaan chotyiñon chi chi. Vityin cuaha ca cucuhva cuende chuun. Quɨ̱hvɨ nu vaha ihya, ta cu̱sɨɨ cuñun chihin”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Soco cuhva cha chaa̱ musu cha quehe̱n cuenda noo mil ri xuhun cuan, catyí ra chi chitoho ra: “Tata, yuhu chité vatyi cuvún noo ra xaan ta cuñún naquehún xuhun noo nu ña sahá tyiñon, ta cuñun naquehun cosecha noo nu ña tachu̱n. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yucuan chaha nayuhvi̱ ta chahi̱n ta tyihi̱ xehi xuhun chichi ñuhú. Soco ma xuhun ihya cha chahu̱n chii”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tyicuan ta nacaha̱n chitoho ra, ta catyí ra chi ra: “Musu quiñi iyó ta musu suchan cuví yoho. Tatu chitón vatyi cuñí naquehín nu ña saha̱ tyiñe, ta quehín cosecha noo nu ña tachí, ");
INSERT INTO mxtNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿ñáá tuhun ña chityihu̱n xuhin banco? Ta cha ndichi ta, cunaquehin xuhun cuan chihin xuhun sɨquɨ cha saha̱ ganaa chi”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tyicuan ta quichaha catyí ra chi ñu nyicú cuan: “Ti̱nyaa ndo noo mil xuhun cha nyisó ra, ta cu̱hva ndo chi ra cha nyisó uchi mil. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vatyi ñu iyó chii, cuhva que chi ñu, ta coo cuaha chi ñu, nyacua ndoo ca. Soco ñu ñahri chii, nyacua nya cha chiin cha cumí ñu, cutinyaa ndɨhi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta musu cha ña chiñuhú ihya, tu̱chi ndo chi ra nu ñaa iñi ityi chata, ta yucuan cuacu chaa ra, ta cusacahñi ra noho ra chihin cha nyehe ra tɨndoho.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Quɨvɨ cuquichi yuhu Rayɨɨ cha quichi̱ nya gloria, cuquichi chihin cuaha ángel cuende, ta cucunyai tyayu tyaquɨ ta cunyaca ñahi. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ñáyɨvɨ tandɨhɨ ri ñuu cundu ɨɨn ri ñu nui. Ta cusasɨin chi noo noo ñu, tari ra sahá cumi mbee tavá sɨɨn ra chi mbee ta tava sɨɨn ra ndixihyu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta cucuatyai chi mbee cuan chiyo vahi, ta chi ndixihyu cuan, chiyo satyin. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tyicuan ta yuhu cha cuví Rey cucatyi chi ñu nyicú chiyo vahi: “Ña̱ha nyoho vatyi nyoho ñáyɨvɨ cha nasocó Suti cuví ndo. Que̱hen cuenda ndo nu cuacunyaa ndo nu nyacá ñaha Nyoo, vatyi cha cuenda maa ndo chino̱ ihya nyata quɨvɨ savaha̱ Nyoo ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vatyi quɨvɨ chisoque, ta nyoho chaha̱ ndo cha cachi. Quɨvɨ cu ityi ndutya ta chaha̱ ndo cohi. Ta quɨvɨ chica̱ noi tari ra inga ñuu ta nyoho chaha̱ ndo vehe coi. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Quɨvɨ cumañi sahme, ta nyoho chaha̱ ndo sahme. Quɨvɨ cuhvi̱ ta nyoho chaha̱n ndo chinyehe̱ ndo chii. Ta quɨvɨ ñohi̱ vehe caa, ta quichi̱ nyehe ndo nu ñohi̱.” ");
INSERT INTO mxtNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ta ñu cha vaha cuan cundaca tuhun ñu chii, ta catyi ñu: “Sutu Mañi yuhu, ¿ama nyehe̱ ndi chisoco̱n, ta chaha̱ ndi cha cachun? ¿Ama nyehe̱ ndi ityun ndutya ta chaha̱ ndi cohun? ");
INSERT INTO mxtNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ama nyehe̱ ndi chuun chicá noun tari ra inga ñuu ta chaha̱ ndi vehe coun? ¿Ama cumañi̱ sahmon, ta chaha̱ ndi chuun? ");
INSERT INTO mxtNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ama nyehe̱ ndi cuhvún, o ñohún vehe caa, ta chaha̱n ndi chinyehe̱ ndi chuun?” cucatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ta yuhu cha cuví Rey cucatyi chi ñu: “Cha ndicha catyí chi ndo, vatyi tandɨhɨ tumañi iñi sacuvi̱ ndo chihin ra ndahvi, ra yañi ihya, chi yuhu sacuvi̱ ndo tumañi iñi cuan.” Tyicuan caa cucatyi yuhu chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tyicuan ta yuhu cha cuví Rey cucatyi tiqui chi ñu nyicú chiyo satyin tyehe caa: “Ca̱nyaha ndo nui, nyoho ñu tahán chi cuhún anyaya. Cua̱han ndo nu ñuhu̱ cha ma ndahva ca maa. Vatyi yucuan cuví nu chino̱ cha cuenda cuihna ta cha cuenda tatyi ña vaha cuenda ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vatyi chisoque̱, ta nyoho ña chaha̱ ndo cha cachi. Cu ityi̱ ndutya, ta ña chaha̱ ndo ndutya cohi. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Chica̱ noi tari chicá noo ra inga ñuu, ta ña chaha̱ ndo nu coi. Cumañi̱ sahme ta ña chaha̱ ndo sahma cuihne. Cuhvi̱ ta ñohi̱ vehe caa, soco ña chaha̱n ndo chinyehe̱ ndo chii nu ñohi̱”, cucatyi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tyicuan ta cucatyi ñu chii tyehe caa: “Sutu Mañi yuhu, ¿ama nyehe̱ ndi chisoco̱n, o ityun ndutya, o chicán noun tari ra inga ñuu, o ñahri sahmon, o cuhvu̱n, o ñohu̱n vehe caa, ta ña tyinyee̱ ndi chuun?” cucatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ta yuhu cha cuví Rey cucatyi chi ñu tyehe caa: “Cha ndicha catyí chi ndo vatyi tandɨhɨ maa cha ña sacuvi̱ ndo chi ñáyɨvɨ ndahvi ihya, suri ña sacuvi̱ tucu ndo chi yuhu cuví cuan”, cucatyi yuhu chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tyicuan ta ñu cuan cuhun coyo ñu nu cayú ñuhu̱ cha ma ndahva ca maa. Ta ñáyɨvɨ vaha cuan cuhun ñu cucoo ñu noo ñayɨvɨ̱ cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuhva cha ndɨhɨ̱ catyi̱ ra Jesús tuhun ihya, ta quichaha̱ catyi ra chi ra cachicá noo chihin ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nyoho chitó ndo vatyi uvi ca quɨvɨ ta sanducahnu yo vico pascua. Ta yuhu Rayɨɨ cha quichi̱ nya gloria cucuhva cuenda ñu chii vatyi tyaa ñu chii nu cruzi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Quɨvɨ cuan ra cacuví nuu chi tata sutu, ta ra casacuahá ley vehe ñuhu, ta ra cacuví mandoñi ñu Israel, candu ɨɨ̱n ri ra nuquehe vehe tyiño ra Caifás, ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yucuan casandaa̱ ra tyiño yoso caa ta sandavi ñaha ra chi ra Jesús ta catɨɨn ra chi ra ta cacahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Soco cacatyí ra: ―Ma cahñi yo chi ra cha nɨ ri ca cha chichi vico, tacuhva cha ma naquɨquɨ xaan ñáyɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ra Jesús ñohó ra ñuu Betania, vehe ra Simón, cha catyí ñu Ra Tyahyu Coño chi, sɨvɨ saca ra cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ta tuhva̱ noo ñaha nu nyaá ra Jesús, nyisó ña noo yutyi tyitú yɨhɨ́ ndutya vixi chahan. Ta yahvi xaan nyaá ndutya cuan. Ta ra Jesús nyaá ra yuhu mesa ta choso̱ ña ndutya cuan xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cuhva cha cananyehe̱ ra chicá noo chihin ra cacuxaa̱n ra ta quichaha̱ catyi ra: ―¿Ñáá tuhun cha satɨvɨ̱ ña ndutya vixi chahan cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vaha ca tyehe ta xico̱ ña, ta ñihi ña cuaha xuhun chihin ta tyinyee ña chi ñu ndahvi chihin xuhun cuan ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tyicuan ta chiñi̱ ra Jesús, ta catyí ra chi ra: ―¿Ñáá tuhun cha sayangá ndo chi ñaha ihya? Vatyi cha sacuvi̱ ña chihin, noo cha vaha cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vatyi ñu ndahvi tyicuan ri cunyaa ñu chihin ndo, soco yuhu, ñima tyicuan ri cua cunyai chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Choso̱ ña ndutya vixi chahan sɨquɨ coño ñuhi, vatyi sanduvaha̱ ña cuenda cha cohin chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cha ndicha catyí chi ndo, vatyi tandɨhɨ ri nu cahan ñu tuhun Nyoo nicahnu ñayɨvɨ̱, cunacatyi tucu ñu cha sacuvi̱ ñaha ihya, tacuhva nɨcohon iñi ñáyɨvɨ chi ña ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tyicuan ta noo ra chicá noo chihin ra Jesús, ra cha nañí Judas Iscariote, chaha̱n ra chicahan ra chihin ra cacuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ta catyí ra chi ra: ―¿Yoso cuhva ndo chii tatu cuhva cuende chi ra Jesús chi ndo? Tyicuan ta ra cacuví nuu cuan cacatyi ra vatyi oco uchi tahan xuhun cuichin. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta nya cuhva cuan ta quichaha̱ nducu ra Judas ñáá noo cuhva cuvi nacuhva cuenda ra chi ra Jesús chi ra cacuví nuu chi tata sutu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Quɨvɨ xihna ri cha quichaha̱ vico ta chachí ñu pan cha ñahri yuchan iya yɨhɨ́ chihin, ra cachicá noo chihin ra Jesús tuhva̱ ra chi ra ta quichaha̱ candaca tuhun ra chi ra: ―¿Nya cuñun cha sanduvaha ndi cha cuxiñun cuenda vico pascua ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta catyí ra Jesús chi ra: ―Cua̱han ndo chichi ñuu ta cha̱a ndo vehe noo ra cuan. Ta ca̱tyi ndo chi ra: “Ra Sacuaha catyí ra vatyi cha cuyatyin cua cúvi ra, ta vehun cusanducahnu ndi vico pascua”, ca̱tyi ndo chi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tyicuan ta casacuvi̱ ra tari cuhva catyi̱ ra Jesús chi ra. Yaha̱ cuan ta casanduvaha̱ ra cha cacuxiñi ra cha vico pascua cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuhva cha cuaa, chicunyaa̱ ra Jesús nu mesa chihin ndɨ uchi uvi ra chicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta cha nɨ ri ca cha cachachí ra, catyí ra Jesús chi ra: ―Cha ndicha catyí chi ndo vatyi noo nyoho cucuhva cuenda ndo chii chi ra xaan iñi chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ta canducuihya̱ xaan iñi ra, ta quichaha̱ candaca tuhun ɨɨn ɨɨn ra chi ra ta cacatyí ra: ―Sutu Mañi yuhu, ¿atu yuhu cuví? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta nacaha̱n ra Jesús ta catyí ra: ―Ra cha chachí ɨɨn ri coho chihin, ican ra cuan cua na cuhva cuenda chii. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yuhu Rayɨɨ cha quichi̱ nya gloria, cuahin ityi cha catyí nu tutu tuhun Nyoo. Soco ndahvi ra ndahvi cha cunacuhva cuenda chii. Quitá vihi ca cuenda chi ra, tyehe ta ña cacu taxin ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tyicuan ta nacaha̱n ra Judas, ra cha cua cuhva cuenda chi ra, ta catyí ra: ―Maestro, ¿atu yuhu cuví? Ta nacaha̱n ra Jesús, ta catyí ra: ―Ican yoho cuvún. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cha nɨ ri ca cha cachachí ra, ra Jesús quehe̱n ra pan ta nacuhva̱ ra tyahvi nyoo chi Nyoo, ta cha yaha̱ tahvi sava ra, ta chaha̱ ra chi ra cachicá noo chihin ra, ta catyí ra: ―Ca̱chi ndo. Ican ihya cuví coñe. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yaha̱ cuan ta quehe̱n tucu ra copa, ta nacuhva̱ ra tyahvi nyoo chi Nyoo, ta sayaha̱ ra chi tandɨhɨ ra ta catyí ra: ―Co̱ho tandɨhɨ ndo ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vatyi ican ihya cuví nɨñi. Ta chihin nɨñi natyihí tahan Nyoo tuhun chaa chihin ndo, vatyi cucatɨ nɨñi cha catyi cha vaha chi cuaha ñu, vatyi chihin nɨñi coo tɨcahnu iñi cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Soco catyí chi ndo, vatyi ma coho que tahan vinu tɨchaha ndɨvɨ ihya, nyacua nya cha cohi vinu chaa chihin ndo nya nu nyacá ñaha Suti andɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cha yaha̱ cha cachita̱ ra yaa chi Nyoo, ta cuahan coyo ra yucu yutun Olivo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tyicuan ta quichaha̱ catyi ra Jesús chi ra: ―Tandɨhɨ nyoho ta cucaca uvi iñi ndo cha nyicón ndo chii vityin cha cuaa. Vatyi nu tutu Nyoo catyí chi tyehe caa: “Cucahñi chi ra sahá cumi mbee, ta mbee cuquɨtɨ cuatyi tɨ”, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Soco cha yaha̱ nandote, xihna que cuhin Galilea, ican saha nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tyicuan ta nacaha̱n ra Pedro ta catyí ra: ―Vasɨ tandɨhɨ ra ndu uvi iñi ra cha nyicón ra chuun, soco yuhu ma ndu uvi iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tyicuan ta quichaha̱ catyi ra Jesús chi ra: ―Cha ndicha catyí chuun vatyi suri maa cha cuaa ihya, cha ni cumañi ca cuacu loho, yoho cucatyun uñi chaha vatyi ña ñohó nuun chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta ra Pedro catyí ra: ―Vasɨ cúvi chuhun, soco ma catyi cha ña ñohó nui chuun ―catyí ra. Ta suri tyicuan caa catyí tandɨhɨ ra chicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tyicuan ta chaa̱ ra Jesús chihin ra cachicá noo chihin ra noo nu nañí Getsemaní, ta catyí ra chi ra: ―Cu̱nyicu ndo ihya, cha nɨri ca cha cuahin yucuan, cua cacan tahvi. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta quehe̱n ra chi ra Pedro ta chi nɨ nduvi sehe ra Zebedeo, cuahan coyo chihin ra. Ta quichaha̱ nducuihya cuñi ra, ta tyoño xaan cuñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tyicuan ta catyí ra chi ra: ―Cahnu xaan tucuihya iñi nyaá añime. Nyacua cuñi chi cahñi chi chii. Ndo̱o ndo ihya ri ta co̱nyito ndo chihin ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tyicuan ta cuahan ra Jesús chiin ca ityi nuu ca ta chicuiñi̱ chɨtɨ ra ta chacu̱n ra nuu ra nu ñuhú, ta chican tahvi ra chi Nyoo ta catyí ra: ―Sutu Mañi yuhu, tu yoho ta cuñun, cu̱hva cha ma nyehi tɨndoho ihya. Soco ma cuvi tari cuhva cha cuñí mai, soco tari cuhva cuñí maun na cuvi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tyicuan ta nachaa̱ ra nu nyicú ra cachica̱ noo chihin ra, ta nyehe̱ ra vatyi caquixí ra. Ta catyí ra chi ra Pedro tyehe caa: ―¿Atu ni minoo hora ña cuví conyito ndo chihin? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Co̱nyito ndo, ta ca̱can tahvi ndo tacuhva cha ma cuvi chasaha cuihna chi ndo. Cha ndicha vatyi añima ndo, cuñí xaan chi nanducu chi Nyoo, soco coño ñuhu ndo vita cuñí chi ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nu cu uvi chaha chaha̱n ra, ta chica̱n tahvi ra tyehe caa: ―Sutu Mañi yuhu, tatu ma cuvi cha ma nyehi tɨndoho ihya, tu tyicuan caa, na cuvi maa cuhva cuñún ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tyicuan ta nachaa̱ ra inga chaha ta caquixí tucu ra cachicá noo chihin ra, vatyi nɨcunyasɨ maa chɨtɨ nuu ra chihin cha cacuñí ra cusu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tyicuan ta sandoo̱ ra chi ra, ta cuahan ra cha cu uñi chaha cua cacan tahvi ra. Ta catyí ra suri maa tuhun cha yaha̱ caha̱n ra cha chica̱n tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tyicuan ta nachaa̱ ra nu canyicu ra cachicá noo chihin ra, ta catyí ra chi ra: ―Vityin ndicha, cu̱su ndo ta nyi̱tatu ndo. Vatyi cha chaa̱ cuhva cha cua nacuhva cuenda ra chii chi ra quiñi iyó, ta Rayɨɨ cha quichi̱ nya gloria cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndɨ̱cuita ndo, ta co̱ho ndo. Vatyi cha vachi ra cha cunacuhva cuenda chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ni cahán ca ra Jesús tuhun ihya, ta chaa̱ ra Judas, ta ra Judas cuví noo ra chicá noo chihin ra Jesús. Ta cuaha ra vachi coyo chihin ra, canyisó ra mityi ta yutun. Ra cuví nuu chi tata sutu, ta ra cacuví mandoñi ñu Israel, ican tachi̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ra Judas, ra cha chahá cuenda chi ra Jesús, cha yaha̱ chaha̱ ra noo seña chi ra cuan, tacuhva coto ra yóó chi tɨɨn ra. Ta catyi̱ ra: ―Ra cha cutyayuhi chi, ican ra cuan cuví. Tɨ̱ɨn ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tyicuan ta tuhva̱ ra chi ra Jesús ta catyí ra: ―Nocumi chuun, Maestro. Ta tyayuhu̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi ra: ―Amigo, sa̱cuvi ñáá tyiño vachun. Tyicuan ta catuhva̱ ra ta catɨɨ̱n ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tyicuan ta noo ra ndɨhɨ chihin ra Jesús, tava̱ ra mityi ra ta chahnya̱ ra soho noo musu ra cuví nuu chi tata sutu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ta catyí ra Jesús chi ra: ―Na̱tyihi mityun chichi vena. Vatyi tandɨhɨ ñu cacañi tahan chihin mityi, suri chihin mityi cúvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Atu ña chitón vatyi tatu yuhu ta cuñí, cuví caquen chi Suti, ta maa ra cutachi ra vityin vityin yaha ca uñi xico uchi mil ángel, ta sacacu ra chii? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Soco tatu tyicuan caa, ¿yoso caa chino cava cuhva nyaá nu tutu Nyoo? Vatyi catyí chi tyi tahán maa chi cuvi chi yuhu tyehe caa ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ta catyí tucu ra Jesús chi ñáyɨvɨ: ―¿Atu vachi coyo nyoho vachi tɨɨn ndo chii chihin cha xaan ta chihin yutun? Tari cha noo ra suhu cuví yuhu sahá ndo. Ndɨquɨvɨ chinyai̱ sañahi nu nyicú ndo chichi vehe ñuhu cahnu, soco ña tɨɨ̱n ndo chii cha cuhin vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vatyi tandɨhɨ cha cuví chii vityin, ta chicunyaa̱ nu tutu Nyoo, cha catyaa̱ ra profeta Nyoo ta cha naha. Tyicuan ta ndɨɨ ra cachicá noo chihin ra, cachino̱ ra. Noo tuhun ca maa ra Jesús casandoo̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ta ra cha catɨɨ̱n chi ra Jesús cuan, chinyaca̱ ra chi ra nuu ra Caifás, ra cuví nuu chi tata sutu. Suri yucuan canyicú ɨɨn ri ra sacuaha ley vehe ñuhu ta ra cacuví mandoñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Soco ra Pedro cuahan ra chata ra, nya sava ri nya nuquehe vehe ra cuví nuu chi tata sutu cuan. Ta quɨhvɨ̱ ra ta ndoo̱ ra nyaá ra chihin policía cuan, vatyi nyehe ra yoso caa quita tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ra cacuví nuu chi tata sutu, ta ra cacuví mandoñi, ta tandɨhɨ ra cuví tyiño, canducu ra noo cuatyi catyaa ra sɨquɨ ra Jesús, vasɨ ña ndicha, tacuhva vatyi chihin cuatyi cuan ta cuví cahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Soco ña cañihi̱ maa ra cuatyi ra, vasɨ cuaha ñáyɨvɨ chaha̱n ñu chicatyi ñu cuendu sɨquɨ ra. Soco nu ndɨhɨ tuhun, chaa̱ coyo uvi ca testigu cuendu. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ta cacatyí ra: ―Ra ihya, catyi̱ ra vatyi cuví satanɨ ra vehe ñuhu cahnu Nyoo, ta chichi cha uñi quɨvɨ cunacananyaa ra inga chaha, na ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tyicuan ta ra cuví nuu chi tata sutu cuan, ndɨcuita̱ ra, ta catyí ra chi ra Jesús: ―¿Atu ña nacahun nu cahan ra ihya? ¿Ñáá cha cuvi cha cacatyi ra ihya sɨcun? ");
INSERT INTO mxtNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Soco ra Jesús taxi ri nanyaá ra. Tyicuan ta quichaha̱ catyi ra cuví nuu chi tata sutu cuan chi ra: ―Chihin sɨvɨ Nyoo nyitó, catyí chuun vatyi ca̱tyun cha ndicha vaha. ¿Atu ra Cristo Sehe Nyoo nyitó cuví chuun? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta catyí ra Jesús chi ra: ―Ican cuví, tari cuhva catyí maun. Ta suri catyí chi ndo, vatyi cunyehe ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria, cunyai chiyo vaha Nyoo ra iyó tandɨhɨ tunyee iñi chii, ta cunyehe ndo nu quichi tiqui nu vico ityi andɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tyicuan ta ra cuví nuu chi tata sutu cuan chahnya̱ ra sahma ra tari noo seña tyi cuñí maa ra tyi ña vaha cha caha̱n ra Jesús, ta catyí ra: ―Ra ihya chicoo̱ cuatyi ra nuu Nyoo chihin tuhun cahán ra. ¡Nye̱he ndo vityin! Ña nɨñɨ cha tava yo cha ndaa. Nyoho cha chiñi̱ ndo tuhun ña vaha caha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ñáá catyí ndo vityin? Ta canacaha̱n ra ta cacatyí ra: ―Iyó cuatyi ra, ta cuñí chi cha cúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tyicuan ta catyicusɨɨ̱ ra nuu ra ta cacañi̱ ra chi ra. Inga ra cacatu ra nuu ra chihin chiqui ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ta cacatyí ra chi ra: ―Yoho, cha sahún Cristo chuun. ¡Na̱coto yóó cha cañi̱ chuun! ");
INSERT INTO mxtNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Cha nɨri ca cha nyaá ca ra Pedro nuquehe ityi chata cuan, ta noo ñaha cha cuví musu tata sutu cuan, tuhva̱ ña nu nyaá ra ta catyí ña chi ra: ―Yoho tucu chica̱ noun chihin ra Jesús, ra Galilea cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ta ra Pedro catyí ra vatyi ña ñohó nuu ra chi ra nuu tandɨhɨ ñu nyicú cuan, ta catyí ra: ―Ña chité ñáá tuhun cahún. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tyicuan ta cuahan ra Pedro ityi yuvehe, ta nyehe̱ inga ña chi ra, ta catyí ña chi ra nyicú cuan: ―Suri chica̱ noo tucu ra ihya chihin ra Jesús, ra ñuu Nazaret cuan ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta inga chaha tucu tixehe̱ ra Pedro cha ñohó nuu ra chi ra ta catyí ra: ―Cha ndicha vaha tyi ña ñohó nui chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Suhva ri ca cuhva cuan, ta ra canyicú cuan catuhva̱ ra nu nyaá ra Pedro ta cacatyí ra chi ra: ―Ra tahan ra cuan cuví chi yoho, ndicha. Vatyi quetuvi nyacua nya cuhva cahún. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tyicuan ta iyo xaan tyanaha ra ta catyí ra: ―Chitó vaha Nyoo tyi ña ñohó nui chi ra cuan, ta nacahñi Nyoo chii tatu ña ndicha cha cahín ―catyí ra. Ta suri cuhva cuan nacuacu chaa noo loho. ");
INSERT INTO mxtNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tyicuan ta nɨcoho̱n iñi ra Pedro tuhun cha catyi̱ ra Jesús chi ra: “Cha ni cumañi ca cuacu loho, yoho cha yaha catyun uñi chaha vatyi ña ñohó nuun chii.” Tyicuan ta quita̱ ra Pedro yucuan, ta chacu̱ vavaha ra cha cuihya iñi ra cha sacuvi̱ ra tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cuhva cha cundichin, tandɨhɨ ra cacuví nuu chi tata sutu ta ra cacuví mandoñi ñuu cuan, catyihi̱ tahan ra tuhun vatyi cacahñi ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ta nuhñí ra. Ta chaha̱n coyo ra chicuhva cuenda ra chi ra chi ra Poncio Pilato, ra cuví gobiernu cuenda ñuu Roma cha nyacá ñaha ñuu Israel cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cha nyehe̱ ra Judas, ra cha naxico̱ tuhun chi ra Jesús, vatyi cuacúvi ra, ta ndu uvi̱ iñi ra cha sacuvi̱ ra, ta nacuhva ra ndɨ oco uchi xuhun cuichin cuan chi ra cacuví nuu chi tata sutu cuan, ta chi ra cacuví mandoñi ñuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta catyí ra: ―Chicoo̱ cuatyi yuhu, vatyi chaha̱ cuende chi noo ra ñahri cuatyi na cúvi ra. Soco maa ra canacaha̱n ra ta cacatyí ra: ―Ta yucuan ¿ñáá cuenda nyuhu? ¡Nye̱he maa yoho! ");
INSERT INTO mxtNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tyicuan ta tuchi̱ ra Judas xuhun cuan chichi vehe ñuhu cahnu, ta chaha̱n ra ta chicuhñi̱ ra yoho sucun ra ta suri maa ra chitacaa̱ ra chi ra. Ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ra cacuví nuu chi tata sutu cuan canaquehe̱n ra xuhun cuan ta cacatyí ra: ―Ma cuvi tyihi yo xuhun ihya chichi caja ofrenda vatyi yahvi cha chahñi̱ ñu noo ñáyɨvɨ cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tyicuan ta catyihi̱ tahan ra tuhun, ta chihin xuhun cuan casata̱ ra noo ñuhú cha nañí Ñuhú Ra Savahá Quɨsɨ. Vatyi coo nu cuchi ra chi ñu inga ñuu tu chihi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yucuan chaha nañí ñuhú cuan nyacua nya vityin Ñuhú Sata Ñu Chihin Xuhun Yahvi Cha Chihi̱ Ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta tyicuan caa chino̱ cava cha tyaa̱ ra Jeremías profeta Nyoo ta cha naha. Catyí chi tyehe caa: “Quehe̱n ra ndɨ oco uchi xuhun cuichin, yahvi cha tyaa̱ ñu Israel chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta chihin cuan, casata̱ ra Ñuhú Ra Savahá Quɨsɨ, tari cuhva catyí Sutu Mañi yo chii”, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Cachinyaca̱ ra chi ra Jesús nuu gobiernu, ta ra cuan ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Atu ican yoho cuví rey cuenda ñu Israel? Ta ra Jesús catyí ra chi ra: ―Ican, yuhu cuví. Ndicha cha cahún. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta cuhva cha catyaa̱ ra cacuví nuu chi tata sutu cuan ta mandoñi cuatyi sɨquɨ ra, ra Jesús ña nacahan maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tyicuan ta quichaha̱ catyí ra Pilato chi ra: ―¿Atu ña chiñún tandɨhɨ cha cacahán ra sɨcun? ");
INSERT INTO mxtNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Soco ra Jesús ña nacahan ra. Ta nyacua iyo cuñí gobiernu cuan vatyi ña nacaha̱n ra. Ta ña chitó ra ñáá cunyacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Soco cha vico pascua cuan, iyó noo tuhun chi ñu vatyi tuhva ra gobiernu saña ra noo ra ñohó vehe caa, nya ra cachi maa ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta quɨvɨ cuan ñohó noo ra cha nañi Barrabás vehe caa. Ta chitó tandɨhɨ ñáyɨvɨ tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta cuhva cha canyicú ɨɨn ri ñu, ra Pilato ndaca̱ tuhun ra chi ñu, ta catyí ra: ―¿Yóó chi cuñí nyoho cha sañe? ¿Atu chi ra Barrabás o chi ra Jesús, ra nañí Cristo? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Vatyi chitó ra vatyi cha cuenda cha tasɨ cuñí nyehe ñu chi ra Jesús, yucuan cuenda chaha̱ cuenda ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cha nɨ ri ca cha nyaá ra Pilato nu tyayu ra, nu cuví ra tyiño, tachi̱ ñasɨhɨ ra noo tyiño chi ra ta catyí ña: “Ma tyihun chuun chihin ra vaha chiña. Vatyi cuñi tahi̱n noo ñumahna cha cuenda ra. Ta quiñi xaan tahi̱n chihin”, catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Soco ra cacuví nuu chi sutu ta mandoñi ñuu cuan, cacuñihi ra catyiyuhu ra chi ñáyɨvɨ na cacan ñu cha saña ra Pilato chi ra Barrabás, ta na cúvi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta gobiernu cuan caha̱n ra chihin ñu inga chaha, ta catyí ra: ―Chichi cha nɨnduvi ra, ¿nya ra cuñí ndo cha sañe? Ta maa ñu nacaha̱n ñu, ta catyí ñu: ―Chi ra Barrabás. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta ra Pilato ndaca̱ tuhun ra chi ñu, ta catyí ra: ―¿Ta ñáá cha cusacuvi chihin ra Jesús cha nañí Cristo ihya? Tandɨhɨ ñu nacaha̱n ñu ta catyí ñu: ―¡Na cúvi ra nu cruzi! ");
INSERT INTO mxtNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tyicuan ta quichaha̱ catyí ra Pilato chi ñu: ―Soco ¿ñáá cha ña vaha sacuvi̱ ra? Soco maa ñu nacana̱ chaa tucu ñu inga chaha ta catyí ñu: ―¡Ca̱hñi chi ra nu cruzi! ");
INSERT INTO mxtNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cuhva cha nyehe̱ ra Pilato vatyi ñahri maa cha cuví sacuvi ra, vatyi quiñi xaan cacuví ñu, chica̱n ra ndutya, ta nacatya̱ ra ndaha ra chihin nuu ñáyɨvɨ cuan, ta catyí ra: ―Yuhu ñahri cuatyi cha cua cúvi ra ñahri cuatyi ihya. Na ndoo sɨquɨ maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta tandɨhɨ ñáyɨvɨ canacaha̱n ñu, ta catyí ñu: ―Na ndoo chi sɨquɨ maa ndi ta sɨquɨ sehe ndi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tyicuan ta ra Pilato saña̱ ra chi ra Barrabás, ta tachi̱ ra na ndoho ra Jesús, ta nacuhva̱ cuenda ra chi ra na cúvi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tyicuan ta sɨndaro cuenda gobiernu cuan chinyaca̱ ra chi ra Jesús nya vehe tyiño, ta casandu ɨɨ̱n ri ra chi tandɨhɨ sɨndaro cuan nɨcachico. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tyicuan ta catava̱ ra sahma ra ta casacuihno̱ ra noo sahma cuaha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ta catyihi̱ ra noo corona cha chino̱ chihin iñu xiñi ra. Ta chaha̱ ra noo yutun na quɨndaha ra chihin chiyo vaha ra. Tyicuan ta cachicuiñi̱ chɨtɨ ra nuu ra, ta cachacu̱ nyaa ra chi ra ta catyí ra: ―¡Nocumi chuun, yoho Rey cuenda ñu Israel! ");
INSERT INTO mxtNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta catyicu̱ sɨɨ ra chi ra ñandɨhɨ. Ta quehe̱n ra yutun cuan ta cañi̱ ra xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cha yaha̱ cha cachacu̱ nyaa ra chi ra ta catava̱ ra sahma cuaha cuan chi ra ta sandɨhvɨ̱ noo tucu ra sahma maa ra chi ra. Tyicuan ta quehe̱n ra chi ra cua cahñi ra chi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuhva cha caquita̱ coyo ra yucuan, cataha̱n ra chi noo ra ñuu Cirene, nañí ra Simón. Ta casanɨñɨ̱ ra chi ra na cuiso ra cruzi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta cachaa̱ coyo ra noo nu nañí Gólgota, ta cuñí chi catyí Nu Cuví Yɨquɨ Xiñi Ndɨyɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ta yucuan cachaha̱ ra vinu nasaca̱ chihin cava uva coho ra Jesús. Soco cha yaha̱ cha chihi̱ ra chiin, ña cuñí ca ra coho. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta cha yaha̱ cha catyaa̱ ra chi ra nu cruzi, tyicuan ta sɨndaro cuan caquehe̱n ra sahma ra ta chaha̱n ra noo sɨhva chihin. Ta nya ra saha ganaa, ñihi̱ ra sahma cuan. Ta tyicuan caa chino̱ cava tuhun cha tyaa̱ noo profeta Nyoo ta cha naha nu catyí chi tyehe caa: “Casacha̱ ra sahme chihin cha chaha̱n ra sɨhva”, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tyicuan ta cachicunyicu̱ ra yucuan vatyi saha cuenda ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta ityi xiñi ra catyaa̱ ra noo letra cha catyí ñáá tuhun cua cahñi ra chi ra. Ta catyí chi tyehe caa: “Ican ra ihya cuví ra Jesús, rey cuenda ñu ñuu Israel.” ");
INSERT INTO mxtNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tacoyó tucu uvi ra suhu chihin ra nu uvi ca cruzi cuan. Noo ra chiyo vaha ra, ta inga ra chiyo satyin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta ñu yahá coyo cuan, cacahán ñu chi ra, ta quɨsɨ xiñi ñu, ");
INSERT INTO mxtNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta catyí ñu chi ra: ―¡Yoho cha catyu̱n tyi cusanduvon vehe ñuhu cahnu, ta chichi cha uñi quɨvɨ ta nacananyaa tucun! ¡Sa̱cacu chuun vityin! ¡Tatu Sehe Nyoo cuví chuun, no̱o nu cruzi chiña! ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta suri tyicuan caa cachacú nyaa tucu ra cacuví nuu chi tata sutu chi ra, ta ra sacuahá ley vehe ñuhu, ta mandoñi ñuu ñandɨhɨ. Ta cacatyí ra chi tahan ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Sacacu̱ ra chi inga ñu, soco ña cuví sacacu ra chi maa ra. Tatu Rey cuenda ñu Israel cuví ra, na noo ra nu cruzi cuan, tacuhva chino iñi yo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Itá iñi ra chi Nyoo, vityin na sacacu Nyoo chi ra, tatu ndicha cuñí ra chi ra. Vatyi catyi̱ ra chi yo vatyi Sehe Nyoo cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta nyacua nya ra suhu cha tacaá nu cruzi xiin ra ta cacaha̱n ra chi ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tyicuan ta tandɨhɨ sɨquɨ ñuhu ñayɨvɨ̱ nduñaa̱ iñi, nyacua nya ora ta nyacua nya ca uñi cha cha iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta suri cuhva cuan, cana̱ chaa ra Jesús chihin cha chaa ndusu ra. Ta catyí ra tyehe caa: ―Elí, Elí, ¿lama sabactani? ―ta cuñí chi catyí: Nyoo Suti, Nyoo Suti, ¿ñáá tuhun cha sandoó ñihnon noo tuhun mai? ");
INSERT INTO mxtNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Suhva ra canyicú cuan, cachiñi̱ ra cha caha̱n ra, ta cacatyí ra: ―Chi ra Elías, ra profeta Nyoo ta cha naha, ican cana̱ chaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta caa cuhva ri cuan, cuahan vavaha noo ra cua quehen ra noo xixan, ta satyii̱ ra chihin vinu iya, ta tyaa̱ ra noo nu yutun, ta satuhva̱ ra yuhu ra Jesús tacuhva na coho ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Soco inga ra cacatyí ra: ―Sa̱ña chi ra. Na nyehe yo tatu quichi sacacu ra Elías chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Inga tucu chaha cana̱ chaa ñihi ra Jesús, tyicuan ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta caa cuhva ri cuan ndata̱ sava sahma cha tacaá chichi vehe ñuhu cahnu cuan, nyacua nya sɨquɨ ta nyacua nya yuvi ndata̱. Ta taa̱n. Ta ndata̱ yuu. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta nuña̱ yuhu ñaña. Ta nyacua canandoto̱ cuaha ñu chinó iñi chi Nyoo, ñu cachihi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta cha yaha̱ nandoto ra Jesús caquita̱ coyo ñu nu ñaña ta quɨhvɨ̱ coyo ñu chichi ñuu Jerusalén, ta cuaha ñáyɨvɨ nyehe chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tyicuan ta capitán ta sɨndaro cha casahá cumi chi ra Jesús, cayuhvi xaan ra cuhva cha taa̱n. Ta cha canyehe̱ ra inga ca cha cuvi̱, ta cacatyí ra: ―Ndicha ndicha cuii, vatyi Sehe Nyoo cuví chi ra ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cuaha ñusɨhɨ cha chinyico̱n chi ra Jesús nya Galilea ta tyinyee̱ ñu chi ra, nyicú ñu canyehé ñu nya sava ri yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta ican suhva ñu ihya cuví cu María ñaha Magdala, ta cu María sɨhɨ ra Jacobo ta ra José, ta sɨhɨ sehe ra Zebedeo. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cuhva cha cua cuaa, quichi noo ra tyayɨɨ cha nañí José. Ra ñuu Arimatea. Ta suri chinó iñi ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta chaha̱n ra chinyehe̱ ra nu nyaá ra Pilato, ta chica̱n ra coño ñuhu ra Jesús. Tyicuan ta tyihi̱ ra Pilato tyiño na cuhva ra coño ñuhu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tyicuan ta quehe̱n ra José coño ñuhu ra, tyihi̱ ra chichi noo sɨnduhu ndɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ta tyihi̱ ra chi ra chichi noo ñaña nicaa chaa cha cuví noo yavi yuu cha tyihi̱ ra tyiño cachatya ra. Ta cha yaha̱ cha nacasɨ ra yuhu ñaña cuan chihin noo yuu cahnu, ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Soco cu María ñaha Magdala, ta inga cu María, ndoo ñu nyicú ñu yuhu ñaña cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta cha inga quɨvɨ, quɨvɨ nyitatú ñu cuví, ta ra cacuví nuu chi tata sutu, ta ra fariseo chaha̱n coyo ra chinyehe̱ ra nu nyaá ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ta catyí ra chi ra: ―Tata, nɨcohón iñi ndi vatyi ra cuendu cuan, catyí ra ta nyitó ca ra vatyi cha yaha cha uñi quɨvɨ cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yucuan chaha tyi̱hi tyiño na casaha cumi vaha ra ñaña cuan, nya yaha cha uñi quɨvɨ, coto quichi coyo ra cachica̱ noo chihin ra cha cha cuaa, ta casuhu ra coño ñuhu ra. Yaha cuan ta cucatyi ra chi ñáyɨvɨ vatyi cha nandoto ra. Ta cha tyicuan caa nu ndɨhɨ tuhun ihya, yaha ca cuhva cucuvi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta ra Pilato catyí ra chi ra: ―Ma suhva sɨndaro chiña. Cua̱han ndo, ta sa̱ha cumi vaha ndo ñaña cuan, yoso cuhva cha vaha cuví saha cumi ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tyicuan ta cuahan coyo ra, ta casaha̱ cumi vaha ra ñaña cuan, ta catyaa̱ ra noo sellu chata yuu cha chasɨ́ cuan. Ta casandoo̱ ra chi sɨndaro sahá cumi yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cha yaha̱ quɨvɨ cha nyitatu ñu, cuhva cha vachi cundichin, nu quichaha vitya cuví. Ta cu María ñaha Magdala cuan, ta inga cu María chaha̱n coyo ñu nu ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta quichi minoo cha taa̱n vatyi quichi̱ ángel Sutu Mañi yo noo̱ ra nya ityi andɨvɨ, ta chaa̱ ra nu ñaña cuan. Ta sacanyaha̱ ra yuu cha nyasɨ̱ yuhu cuan, ta chicunyaa ra sɨquɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ta xiño vavaha ra, tari cha quɨhvɨ tacha. Ta sahma ra cuichin vavaha. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cuhva cha cananyehe̱ sɨndaro cuan chi ra, canayuhví vavaha ra nyacua nɨhɨ́ ra, ta nyacua coñaa ra chihin cha yuhví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tyicuan ta quichaha̱ catyí ángel cuan chi ñusɨhɨ cuan: ―Ma yuhvi ndo. Yuhu chité vatyi chi ra Jesús cha chihi̱ nu cruzi nanducú ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yori ca ra ñohó ihya, vatyi cha nandoto̱ ra, tari catyi̱ ra. Ña̱ha ndo ta nye̱he ndo nu catuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta cu̱hun ndo numi ri, ta ca̱tyi ndo chi ra cachica̱ noo chihin ra vatyi cha nandoto̱ ra, ta cha cuahan ra Galilea, nyatú ra chi ra yucuan. Ican ihya cuví cha nyaa catyi chi ndo ―catyí ángel cuan chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tyicuan ta numi ri quita̱ coyo ñu nu ñaña cuan. Suhva ri yuhví ñu, ta suhva ri sɨɨ vavaha cuñí ñu. Ta chino̱ vavaha ñu cua catyi ñu chi ra cachica̱ noo chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta cuhva cuan tuvi̱ ra Jesús nuu ñu ta chaha̱ ra nocumi chi ñu. Tyicuan ta catuhva ñu chi ra ta chicuiñi chɨtɨ ñu nuu ra ta casacahnu ñu chi ra, ta suri numi̱ ñu chaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta catyí ra chi ñu: ―Ma yuhvi ndo. Cua̱han ndo cua sacoto ndo chi yañi vatyi na cuhun coyo ra Galilea, ta nyicuan cuñihi tahan ndi ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cha nɨ ri ca cha cuahan coyo ñu cuan, suhva sɨndaro cha casaha̱ cumi yucuan, cuahan coyo ra nya ñuu, cua nacatyi ra cha cuvi̱ cuan chi ra cacuví nuu chi sutu. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tyicuan ta ra cacuví nuu cuan chaha̱n coyo ra chicahan ra chihin ra mandoñi ñuu vatyi catyihi tahan ra tuhun yoso caa casacuvi ra. Tyicuan ta cuaha xuhun cachaha̱ ra chi sɨndaro cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ta cacatyí ra chi ra: ―Nyoho, ca̱tyi ndo vatyi cha cha cuaa cha nɨ ri ca cha quixí ndo, chaha̱n coyo ra cachica̱ noo chihin ra Jesús ta chicasuhu̱ ra coño ñuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta tatu chito̱ gobiernu tuhun ihya, cua nyehe maa ndi yoso caa catyi ndi chi ra, ta nyoho ma caca iñi ndo. Ñahri cucuvi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tyicuan ta caquehe̱n sɨndaro cuan xuhun, ta cuahan coyo ra cua casacuvi ra cha cacatyi̱ ra chi ra. Ta nya vityin ta tyicuan caa catyí ñáyɨvɨ ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ta tyicuan caa, ndɨ uchi ɨɨn ra cachica̱ noo chihin ra, cuahan coyo ra nya Galilea nya yucu nu catyi̱ maa ra Jesús chi ra vatyi cuhun coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta cuhva cha cananyehe̱ ra chi ra Jesús, casacahnu̱ ra chi ra soco suhva ra chica uvi iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tyicuan ta tuhva̱ ra Jesús chi ra ta catyí ra chi ra: ―Nyoo chaha̱ ra cha cunyaca ñaha yuhu tandɨhɨ andɨvɨ ta sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yucuan chaha, cua̱han ndo tandɨhɨ nu nyicú ñáyɨvɨ, tandɨhɨ ri ñuu, ta ca̱tyi ndo chi ñu na nanyicon ñu chii. Ta sa̱condutya ndo chi ñu chihin sɨvɨ Sutu yo Nyoo ta chihin sɨvɨ yuhu Sehe Nyoo, ta chihin sɨvɨ Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta sa̱ñaha ndo chi ñu na naquichaha ñu tandɨhɨ cha catyi̱ yuhu tyi sacuvi ñu. Ta co̱to ndo vatyi yuhu cunyai chihin ndo tandɨhɨ quɨvɨ nyacua nya naa ñayɨvɨ̱ ―catyí ra Jesucristo chi ra cachicá tyiño ra.");
INSERT INTO mxtNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tyehe caa quichaha̱ tuhun vaha ra Jesuscristo Sehe Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ra Isaías profeta Nyoo tyaa̱ ra tuhun ra Cristo ta tuhun ra Juan. Tyehe caa catyí Nyoo chi ra Cristo: Cumañi ca cuhun sɨquɨ ñuhu ñayɨvɨ̱ ta cutachi chi noo ra cusacoto chi ñáyɨvɨ vatyi nyaá cuhun nu nyicú ñu, catyí Nyoo chi ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chiñí yo ndusu noo ra cha canachaá nu chiqui ndɨɨ, ta catyí ra: “Tari sanduvahá ndo noo ityi, tyicuan caa sa̱nduvaha ndo añima ndo vatyi cua quichi Sutu Mañi yo. Nu̱ña ndo noo ityi ndoo chi ra na quɨhvɨ ra añima ndo.” Tyicuan caa tyaa̱ ra profeta Isaías nu tutu Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ta tyicuan caa quichi̱ ra Juan sacondutya̱ ra chi ñáyɨvɨ nu chiqui ndɨɨ cuan. Ta catyí ra chi ñu na ndu uvi iñi ñu cuatyi ñu, ta na condutya ñu tari noo seña tyi nasama̱ ñu cuhva iyó ñu, ta tyicuan caa ta Nyoo cusaha ra tɨcahnu iñi cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta tandɨhɨ ñáyɨvɨ ityi Judea quichi̱ coyo ñu tyasoho ñu tuhun cahán ra, ta ñu ñuu Jerusalén ñandɨhɨ. Ta cha yaha̱ nahma ñu cuatyi ñu, sacondutya̱ ra Juan chi ñu yuvi cahnu Jordán. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ta sahma cha ñihno ra Juan cuan chihin ixi camellu chino̱ chi. Ta ñɨɨ cuví sinchu ra. Ta pinchi tuhvá ra chachí. Ta tyañuñu cuhu tuhvá ra chihí. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ta cahán ra tuhun Nyoo ta catyí ra: ―Cha yaha yuhu ta vachi noo ra iyó xaan ca tunyee iñi chi ican saha yuhu. Ta ña nañé ni cha ndachi ñɨɨ xityin ndichan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yuhu sacondutyé chi ndo chihin ndutya. Soco maa ra cusacondutya ra chi ndo chihin Tatyi Ii Nyoo ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Quɨvɨ cuan quita̱ ra Jesús ñuu Nazaret, cha nyaá ityi Galilea, ta cuahan ra nya yuvi cahnu Jordán. Ta yucuan sacondutya̱ ra Juan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta cha yaha̱ condutya ra Jesús, ta cuhva cha cua quita ra chichi ndutya, ta nanyehe̱ ra andɨvɨ cuahan nuña. Ta nyehe̱ ra Tatyi Ii Nyoo tari noo paloma, vachi noó sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta tyacú noo ndusu ityi andɨvɨ ta catyí ndusu cuan tyehe caa: ―Yoho cuvún Sehi ta cuñí xain chuun. Ta sɨɨ xaan cuñí chuhun ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yaha̱ cuan ta sacuhu̱n Tatyi Ii Nyoo chi ra Jesús noo nu chiqui ndɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ta yucuan chinyaa̱ ra uvi xico quɨvɨ nu chiqui ndɨɨ cuan, nu yori ñáyɨvɨ iyó, maa ri quɨtɨ iyó. Ta nducu̱ nyehe cuihna chi ra. Ta yaha̱ cuan ta chaa̱ coyo ángel ta catyiñuhu̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cha yaha̱ catyihi̱ ñu chi ra Juan vehe caa, ta ra Jesús cuanuhu ra Galilea ta cahán ra tuhun vaha Nyoo chihin ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta catyí ra: ―Cha chaa̱ cuhva cha cua cunyaca ñaha Nyoo añima ndo. Yatyin ri nyaá ra chihin ndo. Ndu̱ uvi iñi ndo cuatyi ndo, ta chi̱no iñi ndo tuhun Nyoo cha sacacu añima ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chicá noo ra Jesús yuhu miñi cha nañí Tyañuhu Galilea. Ta nanyehe̱ ra chi ra Simón ta chi yañi ra, ra Andrés, cacañí ra yuhva ra nu ndutya, vatyi ra catɨɨ́n tiyaca cacuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta catyí ra Jesús chi ra: ―Cu̱nyicon ndo chii, ta yuhu cusacuvi vatyi tari ñihí ndo tiyaca, tyicuan caa cuñihi ndo añima ñáyɨvɨ, tava ndo chi ñu nu quiñi caa, na quɨhvɨ ñu cuenda Nyoo ―catyí ra Jesús chi ra Simón ta chi ra Andrés cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Caa cuhva ri cuan casandoo̱ ra yuhva ra, ta cuahan coyo ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yaha̱ cuan ta chiin ri ca chica̱ ra Jesús, ta nanyehe̱ ra chi ra Jacobo, sehe ra Zebedeo, ta chi yañi ra, ra Juan. Cañohó ra chichi noo canoa canaquicú ra yuhva ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cana̱ ra Jesús chi ra. Ta nɨnduvi tahan ra casandoo̱ ra sutu ra, ra Zebedeo, chichi canoa chihin ra catyinyeé chi ra. Ta cuahan coyo ra chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta chaa̱ coyo ra ñuu Capernaum. Ta cuví chi noo quɨvɨ nyitatú ñáyɨvɨ, ta quɨhvɨ̱ ra Jesús chichi vehe ñuhu, ta quichaha̱ sañaha ra tuhun Nyoo chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta iyo cuñí ñu tuhun cahán ra, vatyi sañahá ra tari noo ra iyó vaha ityi chii cha cahán. Ña cahán ra cuhva cahán ra casacuahá cuenda ley vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chichi vehe ñuhu cuan ñohó noo ra yɨhɨ́ tatyi ña vaha añima. Ta cana̱ chaa ra ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Ñáá tuhun cha tyihún chuun chihin ndi, yoho Jesús ra ñuu Nazaret? ¿Atu vachun vatyi sanaun chi ndi? Yuhu ñohó nui chuun, ta chité vatyi Sehe Ii Nyoo cuví chuun ―catyí ra yɨhɨ́ tatyi ña vaha cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nacaha̱n ra Jesús ta catyí ra chi tatyi ña vaha cuan: ―¡Taxi ri! ¡Sa̱ña chi ra ndahvi chiña! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ta tatyi ña vaha cuan, chihi̱ tañi ra cuhví cuan saha̱ chi, ta iyo canachaa̱ tatyi cuan quita̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tandɨhɨ ñáyɨvɨ yuhvi xaan ñu cuvi̱, ta candaca̱ tuhun ñu chi tahan ñu, ta catyí ñu: ―¿Ñáá cha cuví ihya? ¿Ñana vaha tuhun chaa sañahá ra ihya? ¡Vatyi iyo vaha tunyee iñi chi ra, nyacua nya tatyi ña vaha, ta quichahá chi ra! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta numi ri cachito̱ ñáyɨvɨ tandɨhɨ ñuu cha iyó Galilea cuan tuhun ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuhva cha quita̱ coyo ra chichi vehe ñuhu, ta cuahan ra Jesús vehe ra Simón ta ra Andrés. Ta cuahan tucu ra Jacobo ta ra Juan chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta maha tyiso ra Simón catuví ña nu chito, cuhví ña chihin cahñi. Ta catyi̱ ñu chi ra Jesús tyi cuhví ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tyicuan ta tuhva̱ ra Jesús, ta tɨɨ̱n ra ndaha ña. Ta nacoñehe̱ ra chi ña. Ta caa cuhva ri cuan, tinyaa̱ cahñi chi ña. Ta quichaha tyiñuhu ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cuhva cha quee̱ ñanyii ta cha cua cuaa, quichi̱ nyaca ñu tandɨhɨ ñu cuhví ta ñu yɨhɨ́ tatyi ña vaha nu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta tandɨhɨ ñáyɨvɨ ñuu cuan candu ɨɨ̱n ri ñu yuvehe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ta cuaha ñu cuhví cha sɨɨn sɨɨn cuehe sanduvaha̱ ra. Ta tava̱ ñehe ra chi cuaha tatyi ña vaha, soco ña chaha̱ ra cha cahan tatyi cuan, vatyi chitó cuan yóó ra cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta cha inga quɨvɨ cuhva cha ni ñaa ca, ndɨcuita̱ ra Jesús, ta cuahan ra ityi chata ñuu. Cuahan ra noo nu yori sayanga chi ra cua cacan tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta ra Simón ta ra tahan ra cuahan coyo ra cua nanducu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta cuhva cha canañihi̱ ra chi ra cacatyí ra chi ra: ―Tandɨhɨ ñáyɨvɨ nanducú ñu chuun ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Soco maa ra catyí ra chi ra: ―Co̱ho ndo inga ñuu cha nyicú yatyin ri ihya, vatyi cahan tiqui tuhun Nyoo yucuan, vatyi yucuan tyiño vachi ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yucuan chaha chica̱ noo ra Jesús tandɨhɨ ri ñuu cha iyó Galilea, cahán ra tuhun Nyoo chichi vehe ñuhu tahan tahan ñuu. Ta tava̱ ñehe ra tatyi ña vaha cha yɨhɨ̱ añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Noo chaha tuhva̱ noo ra cuhví cha tyahyu coño nu nyaá ra Jesús. Ta chicuiñi̱ chɨtɨ ra nuu ra, ta catyí ra chi ra: ―Tatu cuñún, cuví sanduvahun chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta cundahvi cuñí ra Jesús nyehé ra chi ra, ta tyiso̱ ra ndaha ra sɨquɨ ra, ta catyí ra: ―Cuñí sanduvahi chuun. Ta na nduvahun vityin ri ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Caa cuhva ri cha catyi̱ ra tyehe caa, tinyaa̱ cuehe cuan chi ra, ta nduvaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tyicuan ta catyí ra Jesús vatyi cha cuvi cuhun ra, soco catyi̱ xaan ra chi ra na sacuvi ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Nye̱he. Yori chihin cahun tuhun. Soco cua̱han nu nyaá tata sutu. Ta sa̱ñahun chuun chi ra, ta cu̱hvon cha tahán chi cuhvon na ndundɨun nu Nyoo tari cuhva catyí nu ley cha tyaa̱ ra Moisés, vatyi tacuhva coto tandɨhɨ ñáyɨvɨ tyi cha nduvahu̱n chihin cuehe cuan ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Soco ra cuan chaha̱n ra, ta quichaha̱ nacatyi ra chi tandɨhɨ ñáyɨvɨ. Yucuan chaha ña cuvi̱ ca quɨhvɨ ndichin ra Jesús chichi ni noo ñuu. Ta ityi chata ri ñuu chicá noo ra nu yori ñáyɨvɨ iyó, soco tandɨhɨ ri ityi quita̱ coyo ñu, quichi̱ nyehe ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Suhva quɨvɨ yaha̱ ta quɨhvɨ̱ ra Jesús inga chaha chichi ñuu Capernaum. Ta cachito̱ ñáyɨvɨ tyi nyaá ra vehe. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta numi ri candu ɨɨ̱n ri cuaha ñáyɨvɨ. Ta nyacua ña chitaha̱n ñu, ni yuvehe. Ta maa ra Jesús caha̱n ra tuhun Nyoo chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tyicuan ta cumi tahan ra canyisó chi noo ra cuhví cha ña cuví nacanda, caquichí nyaca ra chi ra nu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Soco ña cuví caquɨhvɨ ra nya nu nyaá ra Jesús cha cuenda vatyi tuvi xaan ñáyɨvɨ. Tyicuan ta candaa̱ ra ityi xiñi vehe. Ta sacuachiyo̱ ra suhva tyiyo. Ta sanoo̱ ra chi ra cuhví cuan chihin chito. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nyehe̱ ra Jesús vatyi cachinó xaan iñi ra cuan. Ta catyí ra chi ra cuhví cuan: ―Cha ndachi̱ cuatyun, suti ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Soco suhva ra sacuahá cuenda ley vehe ñuhu nyicú ra cuan, ta cachicá xiñi ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ñáá tuhun cha cañá iñi ra ihya cahan ra tyehe caa? Chicoo̱ cuatyi ra nuu Nyoo chihin tuhun caha̱n ra vatyi yori cuví sandachi cuatyi, noo tuhun ri maa Nyoo cuví sandachi ra cuatyi”, cachicá xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Soco ra Jesús chitó ra cha cachicá xiñi ra. Ta catyi ra chi ra: ―¿Ñáá tuhun cha chicá xiñi nyoho tyicuan caa? ");
INSERT INTO mxtNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ñáá cha yɨɨ ca, cha catyi yo chi ra cuhví ihya vatyi cuatyi ra cha yaha̱ ndachi, o cha catyi yo chi ra vatyi nducuita ra ta naquehen ra chito ra ta caca ra? ");
INSERT INTO mxtNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vaha, vityin chihin cha sanduvahi chi ra ihya, cusañahi chi ndo vatyi yuhu ra cuví Rayɨɨ cha quichi̱ nya gloria, iyó ityi chii cha sandachi cuatyi ñáyɨvɨ ―catyí ra Jesús chi ra. Tyicuan ta quichaha catyí ra chi ra cuhví cuan: ");
INSERT INTO mxtNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Catyí chi yoho, ndɨ̱cuita, na̱quehen chiton, ta cua̱nuhu nya vehun ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta ra cuhví cuan ndɨcuita̱ ra. Naquehe̱n ra chito ra, ta cuanuhu ra. Ta tandɨhɨ ñu nyehe̱ ñu, ta iyo cuñí ñu, ta sacahnú ñu chi Nyoo, ta catyí ñu: ―Ni noo chaha ta nyehe ca yo cha tyehe caa ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yaha̱ cuan ta cuahan tucu ra Jesús inga chaha yuhu miñi cuan. Ta cuhva cha nataca̱ ñáyɨvɨ nu nyaá ra, quichaha cahan ra nuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tyicuan ta cuahan ra ta nu yaha̱ ra nanyehe̱ ra chi ra Leví sehe ra Alfeo, nyaá ra nu sahá tyiño ra, tavá ra xuhun cuenda gobiernu ñuu Roma. Ta catyí ra Jesús chi ra: ―Co̱ho chihin. Tyicuan ta nducuita̱ ra Leví, ta cuahan ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yaha̱ cuan ta taha̱n chi nyaá ra Jesús chihin ra cachicá noo chihin ra cachachí ra nu mesa vehe ra Leví. Ta nyicú tucu cuaha ra catavá xuhun chihin inga ñáyɨvɨ iyó cuatyi. Vatyi cuaha xaan ñu nyicón chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Soco ra casacuahá cuenda ley vehe ñuhu, ta ra cacuví fariseo, ra cha quichahá xaan ley vehe ñuhu, cha canyehe̱ ra vatyi chachí ra Jesús chihin ra catavá xuhun, ta ñu iyó cuatyi, ta cacatyi̱ ra chi ra cachicá noo chihin ra Jesús: ―¿Yoso caa cha ra sacuaha chi nyoho chachí ra ta chihí ra chihin ra catavá xuhun ta ñu iyó cuatyi? ");
INSERT INTO mxtNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chiñi̱ ra Jesús cha cacaha̱n ra ta catyí ra: ―Ña chiñuhú doctor chi ñu ña cuhví, soco chiñuhú ra chi ñu cuhví. Vachi yuhu soco ñima cha cuenda cha vaha chi ñu vaha, soco cha cuenda cha vaha chi ñu iyó cuatyi ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Noo chaha, ra canyicón chi ra Juan ta ra canyicón chi ra fariseo, ña chachí ra ta nanducú ra chi Nyoo. Ta suhva ñáyɨvɨ quichi̱ coyo ñu nu nyaá ra Jesús, ta ndaca̱ tuhun ñu chi ra, ta catyí ñu chi ra: ―¿Ñáá tuhun cha ra canyicón chi ra Juan ta ra canyicón chi ra fariseo tuhvá ra savaha ra ayuno, ta ra cachicá noo chuhun ña tuhvá ra? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta nacaha̱n ra Jesús ta catyí ra: ―Noo vico tandaha, ¿atu cuví cha ma cachi ra ñohó vico cha nɨ ri ca cha nyaá ra cha cua tandaha cuan chihin ra? Tatu nyaá ca ra cua tandaha cuan chihin ra, ma cuvi cha ma cachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Soco vachi chi quɨvɨ cha cutinyaa ra chi ra tandaha cuan nu nyicú ra tahan ra. Yucuan ndicha quɨvɨ coo cuhva cha ma cachi ra ta nanducu ra chi Nyoo ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Catyí ra Jesús: ―Yori naquicu noo sahma chahnu chihin noo sahma chaa, vatyi cha chaa cuan nandɨyɨ ta cahnya chi sahma chahnu, ta nu tahnya cuan cunducahnu ca. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta nɨ ri ña tuhvá yo tyihi yo vinu chaa chichi ñɨɨ chahnu, vatyi vinu chaa chahnyá chi ñɨɨ, ta chatɨ vinu, ta tɨvɨ ñɨɨ. Yucuan chaha cuñí chi cha tyihi yo vinu chaa chichi ñɨɨ chaa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Noo quɨvɨ cha tuhvá ñáyɨvɨ nyitatu, cuahan ra Jesús chicá ra mahñu nu iyó cha tachi̱ ñáyɨvɨ. Ta ra cachicá noo chihin ra quichaha catohon ra yoco trigo cuan cuhva cha yahá coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tyicuan ta quichaha cacatyí ra fariseo chi ra Jesús: ―¡Nye̱he xihna! ¿Ñáá tuhun cha sacuví ra cachicá noo chuhun tyiño cha ña tahán chi sacuví yo quɨvɨ nyitatú yo? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Soco maa ra Jesús catyí ra chi ra: ―¿Atu ni noo chaha ta sacuaha ca nyoho cha sacuvi̱ ra David chihin ra tahan ra noo quɨvɨ cha cachisoco̱ vavaha ra? ");
INSERT INTO mxtNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Quɨvɨ cha cuví ra Abiatar tyiño cha cuví ra nuu chi tata sutu, quɨhvɨ̱ ra David chichi vehe Nyoo. Ta chachí ra pan ii, cha tahán chi cachi maa ri maa ra cuví sutu. Ta chaha̱ tucu ra cachi ra ndɨhɨ chihin ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta catyí tucu ra Jesús chi ra: ―Chicoo quɨvɨ nyitatú yo, cuenda cha vaha chi ñáyɨvɨ, soco ñáyɨvɨ ña chicoo ñu cha cuenda cha vaha chi quɨvɨ nyitatu yo. ");
INSERT INTO mxtNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yucuan chaha yuhu Rayɨɨ cha quichi̱ nya gloria, iyó ityi chii cha catyi chi noo noo ndo ñáá cha sacuvi ndo quɨvɨ nyitatú yo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Quɨhvɨ̱ ra Jesús inga chaha chichi noo vehe ñuhu. Ta yucuan nyaá noo ra na ityi ɨnchiyo ndaha. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta cañañí ra fariseo chi ra Jesús nyehé ra tatu sanduvaha ra chi ra quɨvɨ nyitatú ñu, vatyi tacuhva coo cuatyi tyaa ra sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tyicuan ta ra Jesús catyí ra chi ra na ityi ndaha cuan: ―Ndɨ̱cuita ta cui̱nanyaa mahñu ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yaha̱ cuan ta ndaca̱ tuhun ra chi inga ñu cha tayucú cuan, ta catyí ra: ―¿Ñáá cha tahán chi sacuvi yo quɨvɨ nyitatu yo? ¿Atu sacuví yo cha vaha o cha ña vaha? ¿Atu tahán chi sanduvaha yo ñáyɨvɨ o cha cahñi yo? ―catyí ra Jesús. Tyicuan ta taxi taxi maa candoo̱ ñu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tyicuan ta xaan nanyehe ra Jesús chi ñu, ta cuihya cuñí ra vatyi ña cuñí ñu cutuñi iñi ñu. Ta catyí ra chi ra cuan: ―Sa̱nacaa ndahun. Ta sanacaa̱ ra, ta nduvaha̱ ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tyicuan ta quita̱ coyo ra fariseo, ta quichaha̱ catyihi tahan ra tuhun chihin ra cuenda ra Herodes, yoso caa cacahñi ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Soco ra Jesús cuahan ra chihin ra cachicá noo chihin ra yuhu miñi, ta cuaha ñáyɨvɨ ityi Galilea canyicón chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ta cha chito̱ ñáyɨvɨ tuhun nahnu cha sacuví ra, cuaha xaan ñu quichi̱ coyo ñu ñuu Jerusalén ta inga ñuu cha iyó ityi Judea, ta ñuu cha iyó Idumea, ta inga chiyo yuvi cahnu Jordán, ta ñuu Tiro ta ñuu Sidón ñandɨhɨ, vatyi cuñí ñu nyehe ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yucuan chaha catyí ra Jesús chi ra cachicá noo chihin ra na casanduvaha ra noo canoa, tacuhva vatyi tatu ndutɨhɨn xaan chihin ñáyɨvɨ, cuví quɨhvɨ ra chichi canoa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Vatyi cuaha xaan ñu cha yaha̱ sanduvaha̱ ra, ta yucuan chaha tandɨhɨ ñu cuhví cuahan ñu nu nyaá ra vatyi cuñí ñu tɨɨn ñu chi ra tacuhva nduvaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta ñu yɨhɨ́ tatyi ña vaha añima, chicuiñi chɨtɨ ri ñu nuu ra, ta canachaa tatyi ña vaha cuan, ta catyí chi tyehe caa: ―¡Yoho cuvún Sehe Nyoo! ");
INSERT INTO mxtNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Soco ra Jesús chasɨ̱ ra yuhu tatyi cuan vatyi ma catyi ca chi yóó ra cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yaha̱ cuan ta ndaa̱ ra Jesús noo yucu ta cana̱ ra chi ra cuñí maa ra nacachi ra. Ta quichi̱ coyo ra nu nyaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta tyiso̱ ra chi uchi uvi tahan ra vatyi cundɨhɨ ra chihin ra, ta vatyi tyatyiño ra chi ra na cucahan ra tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta chaha̱ ra ityi chi ra vatyi sanduvaha ra chi ñu cuhví, ta tava ñehe ra chi tatyi ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ta ican ra ihya cacuví ndɨ uchi uvi tahan ra: ra Simón cha sacunañi̱ ra Jesús Pedro chi; ");
INSERT INTO mxtNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ra Jacobo ta yañi ra ra Juan, sehe ra Zebedeo. Ta Boanerges sacunañi̱ ra chi nɨnduvi tahan ra ta cuñí chi catyi: ra ñihi cahán tari cahán savi, ");
INSERT INTO mxtNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ra Andrés, ra Felipe, ra Bartolomé, ra Mateo, ra Tomás, ra Jacobo sehe ra Alfeo, ra Tadeo, ta inga ra Simón cha yɨhɨ́ cuenda ityi ra cuñí cuhun cuatyi sɨquɨ gobiernu ñuu Roma cha nyacá ñaha chi ñu, ");
INSERT INTO mxtNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta ra Judas Iscariote, ra cha naxico̱ tuhun chi ra Jesús. Yaha̱ cuan ta quɨhvɨ̱ ra Jesus noo vehe chihin ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ta inga chaha nataca̱ cuaha ñáyɨvɨ, ta nyacua ni ña cuví ca cachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cha cachito̱ ñáyɨvɨ chi ra Jesús vatyi nyaá ra yucuan, quichi̱ coyo ñu vatyi cunuhun ra chihin ñu, vatyi catyi̱ ñáyɨvɨ chi ñu tyi nduloco ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ta suhva ra casacuahá cuenda ley vehe ñuhu Jerusalén cha quichi̱ coyo suri tyicuan caa cacatyí ra: ―Ra ihya, ra Beelzebú ra cuví nuu chi cuihna yɨhɨ́ chi ra. Ta chihin tunyee iñi cuihna tava ñehe ra tatyi ña vaha ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tyicuan ta cana̱ ra Jesús chi ra, ta catyí ra chi ra: ―¿Yoso caa, atu tavá ñehe cuihna suri chi ra tahan maa ra? Ma sacuvi cuihna tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tatu noo gobiernu cacusɨɨn ra, ta cacañí tahan ra chihin tahan ra, gobiernu cuan ña naha cuacunyaca ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O tatu ñáyɨvɨ noo vehe, ña ɨɨn ri cuví ñu chihin tahan ñu ta cañi tahan ñu, cutɨvɨ nu nyicú ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ta tatu cuihna cacusɨɨn ra ta canducuita ra sɨquɨ tahan ra, ¿yoso caa cucuvi chi ra? Cundɨhɨ tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Yori cuví quɨhvɨ chichi vehe noo ra ñihi tari cuihna ta tinyaa ra cha chii ra, tatu ma cuhñi xihna ra chi ra. Yucuan ndicha ta cuví tinyaa yo cha chii ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Cha ndicha catyí chi ndo vatyi cuví coo tɨcahnu iñi tandɨhɨ nuu cuatyi ñáyɨvɨ, ta tandɨhɨ cha quiñi caa cha cahán ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Soco ñu cahán ña vaha sɨquɨ Tatyi Ii Nyoo, ma cuvi maa coo tɨcahnu iñi cuenda cuan, soco tyicuan ri maa coo cuatyi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tyicuan caa catyi̱ ra Jesús chi ra casacuahá cuenda ley vehe ñuhu, vatyi maa ra cacatyi ra vatyi ñohó noo tatyi ña vaha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tyicuan ta chaa̱ coyo sɨhɨ ra Jesús ta yañi ra, soco ndoo̱ ñu ityi chata vehe, ta tachi̱ ñu cucana chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta ra nyicú nicachico nu nyaá ra Jesús cacatyí ra chi ra: ―Sɨhun ta yañun ta cuhvon nyicú ñu ityi chata vehe, ta nanducú ñu chuun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Soco maa ra catyí ra: ―¿Yóó ñu cuví sɨhi ta yañi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tyicuan ta nanyehe̱ ra chi ñu nyicú nicachico, ta catyí ra: ―Ican ñu ihya cuví sɨhi ta yañi. ");
INSERT INTO mxtNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vatyi savahri ñu sacuví cuhva cuñí Nyoo, ican ñu cuan cuví yañi, ta cuhve, ta sɨhi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Inga chaha quichaha sañaha ra Jesús yuhu miñi, ta ndu ɨɨ̱n ri cuaha ñáyɨvɨ nu nyaá ra. Yucuan chaha quɨhvɨ̱ ra chichi noo canoa cha tacaá nu ndutya yuhu miñi cuan. Ta chicunyaa̱ ra, ta tandɨhɨ ñáyɨvɨ ndoo ñu nu ñɨtɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tyicuan ta cuaha cha sañaha ra chi ñu chihin cuhva ri. Ta nu sañahá ra chi ñu, ta catyí ra chi ñu: ");
INSERT INTO mxtNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tya̱soho ndo tuhun ihya. Minoo ra quita̱ ra vehe ra, cuahan ra nu iyó tyiño sahá ra. Ta quichaha quɨtɨ ra chɨtɨ trigu nu ñuhú ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta ityi cuahan ra quɨtɨ́ ra, suhva chɨtɨ cuan canacoyo̱ yuhu ityi, ta quichi̱ coyo saa ta cachachi̱ tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Suhva ca chɨtɨ canacoyo̱ tɨcu yuu nu ña cuaha ñuhú yɨhɨ́. Ta chɨtɨ cuan numi ri caña̱, vatyi ña cono xaan yɨhɨ́ ñuhú cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Soco cuhva cha caña̱ ñanyii, na ityi chi vatyi ña cono yɨhɨ́ yoho chi. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta suhva ca chɨtɨ canacoyo̱ chichi tu iñu. Ta chahnu̱ tu iñu cuan, ta chasɨ̱ tun nuu trigo cuan. Yucuan chaha ña chiyo̱ chɨtɨ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Soco suhva chɨtɨ cha canacoyo̱ nu ñuhú vaha. Ta caña̱ ta chahnu̱. Ta vaha chaha̱ tun chɨtɨ. Suhva tun chaha̱ tun oco uchi chɨtɨ cha noo noo tun. Inga tun chaha tun uñi xico chɨtɨ. Ta inga tun chaha̱ ciento chɨtɨ ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta catyí tucu ra chi ñu: ―Tatu cutuñi iñi ndo, tya̱soho ndo tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yaha̱ cuan ta ndoo̱ maa ri maa ra Jesús chihin ñu nyicón chi ra ta ndɨ uchi uvi tahan ra chicá noo chihin ra. Ta candaca̱ tuhun ñu chi ra ñáá cha cuñí chi catyi tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta catyí ra chi ñu: ―Chi nyoho sacotó Nyoo tuhun xehe yoso caa nyacá ñaha ra añima ñáyɨvɨ. Soco chi ñu cha ña chinó iñi chi ra, maa maa ri chihin cuhva ri sañahí chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Vatyi tatu nyehé ñu soco cuví chi tari cha ña nyehé ñu, ta tatu chiñí ñu soco ma cutuñi iñi ñu. Tacuhva cha ma nasama ñu cuhva iyó ñu ta ni ma coo tɨcahnu iñi cuatyi ñu ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta catyí tucu ra chi ñu: ―¿Atu ña cutuñí iñi nyoho tuhun ihya? Tatu tyicuan caa ña cutuñí iñi ndo, ¿yoso caa cuví cutuñi ini ndo tandɨhɨ inga tuhun sañahí chi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ra cha tachí chɨtɨ trigu cuan cuví ra tari noo ra cahán tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yɨhɨ́ ñáyɨvɨ cuví ñu tari nu canacoyo̱ chɨtɨ yuhu ityi: chiñí ñu tuhun Nyoo, soco cha yaha̱ chiñi ñu, quichi cuihna ta tinyaa̱ ra tuhun Nyoo cha tachi̱ ra añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inga ñáyɨvɨ cuví ñu tari nu canacoyo chɨtɨ tɨcu yuu: chiñí ñu tuhun Nyoo ta sɨɨ cuñí ñu natɨɨn cuenda ñu noo ri cuhva. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Vatyi nu caña̱ chɨtɨ tɨcu yuu cuan, chiin ri ñuhú yɨhɨ́ chaha, yucuan chaha caña̱ soco ña cuvi̱ tyihi yoho vaha chi. Ta tyicuan caa ñu cuan, suhva ri quɨvɨ chino iñi ñu. Soco quɨvɨ vachi tɨndoho sɨquɨ ñu, o satasɨ iñi ñáyɨvɨ chi ñu cha cuenda tuhun Nyoo, sandɨhɨ ri ñu tuhun cha chinó iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ta inga ñu cuví ñu tari nu canacoyo̱ chɨtɨ chichi tu iñu: chiñí ñu tuhun Nyoo, ");
INSERT INTO mxtNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","soco cutyoño ca iñi ñu cha cuenda tɨndoho cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya. Cha tyayɨɨ sandaví ñaha chi ñu, ta cuñí ñu tandɨhɨ ri nuu cha iyó. Tandɨhɨ ihya quɨhvɨ́ xiñi ñu ta ña nyaá ca xiñi ñu tuhun Nyoo, ta ña chahá chi sacuvi ñu cha vaha cha cuenda cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Soco yɨhɨ́ ñu cha chiñí ñu tuhun Nyoo ta naquehén cuenda ñu, ta vaha sacuví ñu, tari nu canacoyo chɨtɨ nu ñuhú vaha cuví ñu. Yɨhɨ́ ñu cuví ñu tari yutun cha caña̱ ta chaha̱ tun oco uchi tahan chɨtɨ tahan tahan tun. Ta inga ñu cuví ñu tari yutun cha chaha̱ uñi xico. Ta inga ñu tari yutun cha chaha̱ ciento. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta catyí tucu ra chi ñu: ―¿Atu quichi nyaca yo noo tima vatyi cananyaa yo chichi noo cajón o xiu chito? Ñima. Tima cuan cuñí chi tyiso yo noo nu sucun vatyi na sacundichin chi chichi vehe. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta tyicuan caa tucu, ñahri cha ñohó xehe, ta cuñun, tyi ma natuvi. Ta ñahri noo tuhun xehe, ta cuñun, tyi ma coto yo. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nyoho cha cutuñí iñi ndo, tya̱soho ndo tuhun cahín ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Catyí tucu ra tyehe caa: ―Tya̱soho vaha ndo tuhun cahín. Yoso cuhva sacuví ndo chi ñáyɨvɨ, yucuan cuhva sacuvi Nyoo chihin ndo. Ta cuaha ca cucuhva ra chi ndo tatu tyasohó ndo cha cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vatyi ñu tyasohó cha cahín, cuaha ca cuhva Nyoo chi ñu. Soco ñu ña tyasohó, cutinyaa ndɨhɨ ra cha chiin cha cha yaha̱ chaha̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Catyí tucu ra Jesús tyehe caa: ―Cha nyacá ñaha Nyoo añima ñáyɨvɨ cuví chi tari noo ra tachi̱ noo chɨtɨ chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta cuahan ra cua cusu ra. Yaha̱ cuan ta ndɨcuita ra. Ta cuaha quɨvɨ yaha. Ta caña chɨtɨ cuan, ta chahnu̱ yutun. Soco maa ra ña chitó ra yoso caa chahnu̱ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cha cuenda vatyi maa ñuhú cuan sacuvahá chi tun tyicuan ri caa. Xihna ca quita̱ xityin tun, ta yaha cuan yoco tun, yaha cuan ta quita̱ chɨtɨ nu yoco cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ta tatu cha chityi chɨtɨ cuan, cutohon ra vatyi cha chaa̱ quɨvɨ cha coyo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ta catyí tucu ra Jesús: ―¿Ñáá chihin sanandɨquɨ tahin cha nyacá ñaha Nyoo añima yo? ¿Ñáá chihin sandu ɨnuu ri yo? ");
INSERT INTO mxtNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cuví chi tari noo chɨtɨ mostaza cha tachi̱ yo nu ñuhú. Ican chɨtɨ cuan, lee ca cha nuu tandɨhɨ chɨtɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Soco tatu tachí yo, cañá ta cuahnu. Ta cahnu vavaha cuví tun. Ta nahnu soco tun, ta nyacua nya saa cha chicó nu tatyi cuví nyitatu tɨ nu vatɨ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tyehe caa sañaha̱ ra Jesús chi ñu, chihin cuaha cuhva, nyacua nya nu cuví cutuñi íñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ñahri maa cha catyí ra chi ñu tatu ñima chihin noo cuhva. Soco chi ra cachicá noo chihin ra, nacatyí vaha ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Suri maa quɨvɨ cuan, cuhva cha cuaa̱, catyi ra chi ra cachicá noo chihin ra: ―Co̱ho ndo inga chiyo miñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tyicuan ta casandoo̱ ra chi ñáyɨvɨ. Ta cuahan ra Jesús chihin ra chichi canoa cha catuvi cuan. Ta cuahan tucu inga canoa chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta quichaha caa noo tatyi ñihi xaan, ta quichaha quɨhvɨ ndutya chichi canoa cuan, ta quichaha chitu. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta ra Jesús quixí ra sɨquɨ noo cabecera cha nyaá ɨnchiyo xiin canoa cuan. Ta casandoyo̱ ra chi ra, ta cacatyí ra: ―¡Maestro! ¿atu ñahri cuendon cha cuñí nyee yo? ");
INSERT INTO mxtNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tyicuan ta ndɨcuita̱ ra Jesús ta cahan ra chi tatyi cuan na cutaxin. Ta catyí ra chi ndutya miñi cuan tyehe caa: ―¡Taxi ri! ¡Taxi cu̱nyaun! ―catyí ra. Ta tatyi cuan cutaxin, ta taxi taxi cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tyicuan ta catyí ra Jesús chi ra cachicá noo chihin ra: ―¿Ñáá tuhun cha yuhví xaan ndo? ¿Atu ta chino ca iñi ndo? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Soco maa ra cayuhví xaan ra cha cuvi̱ cuan. Ta cacatyi̱ ra chi ra tahan ra: ―¿Yóó ra cuví ra ihya, vatyi nyacua nya tatyi ta miñi quichahá chi ra? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chaa̱ coyo ra yuhu miñi, inga chiyo nu nyaá ñuu Gadara. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ta quita̱ ri ra Jesús chichi canoa, ta quita̱ noo ra nu ñaña cuan ta chaa̱ ra nu nanyaá ra Jesús. Ta yɨhɨ́ noo tatyi ña vaha añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ta nu ñaña cuan iyó maa ra cuan. Ta yori maa cuví chasaha chi ra, nɨ ri chihin cadena. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cuaha xaan chaha chahñi̱ ñu chaha ra ta ndaha ra chihin cadena, soco chahnya̱ ra. Yɨquɨn maa sacuvi ra. Ta yori maa cuví chasaha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñicahñu ta cha cuaa chicá noo ra canachaá ra nya nu yucu ta nya nu ñaña. Ta sañicuehé ra suri chi maa ra chihin yuu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Soco cañi ca nanyehe̱ ra chi ra Jesús, ta chino vavaha ra chaa ra. Ta chicuiñi chɨtɨ ra nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta cana̱ chaa ra ta catyí ra: ―¿Ñáá tuhun cha tyihún chuun chihin yuhu, yoho Jesús, Sehe Nyoo ra cuví nuu? Chacú ndahvi nuun chihin sɨvɨ Nyoo, ma sanyehun tɨndoho chii. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Catyí tatyi cuan tyehe caa vatyi ra Jesús cha catyi̱ ra chi ra: ―¡Sa̱ña chi ra chiña, yoho tatyi ña vaha! ―catyi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta ra Jesús ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Ñáá nañún? Ta nacaha̱n tatyi ña vaha cuan: ―Legión nañí, vatyi cuaha xaan ndi ―catyí chi chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta chacu̱ ndahvi tatyi ña vaha cuan nuu ra Jesús tacuhva cha ma tachi ra chi chi nu cañi. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta yatyin ri yucu cuan nyicú cuaha xaan quɨnɨ cachachí tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yucuan chaha catyí tatyi ña vaha cuan chi ra Jesús tyehe caa: ―Ta̱chi chi ndi na quɨhvɨ ndi quɨnɨ cuan ―catyí tatyi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tyicuan ta chaha̱ ra Jesús, ta tatyi cuan quita̱ coyo chi ra cuan, ta quɨhvɨ̱ chi quɨnɨ cuan. Ta cha uvi mil quɨnɨ nyicú cuan, cachino̱ tɨ, ta canacoyo̱ tɨ chichi noo xahva yuhu miñi cuan, ta cachihi̱ tɨ chichi ndutya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tyicuan ta ra sahá cumi quɨnɨ cuan, chino̱ xaan ra chihin cha yuhví ra, ta chinacatyi̱ ra chi ñáyɨvɨ ñuu cuan ta ñu ñohó nu chiqui. Ta quichi̱ coyo ñáyɨvɨ, quichi̱ nyehe ñu ñáá cha cuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cuhva cha chaa̱ coyo ñu nu nyaá ra Jesús, nanyehe̱ ñu chi ra cha yɨhɨ̱ tatyi ña vaha cuan chi. Ta vityin nyaá ra ñihnó ra sahma, ta cachi vaha iyó xiñi ra. Ta yuhví xaan ñu cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta ñu cha nyehe̱ cha cuvi̱ chi ra cuan ta chi quɨnɨ cuan, canacatyi̱ ñu chi tandɨhɨ ca ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tyicuan ta quichaha̱ chacu ndahvi ñu nuu ra Jesús, na quita ra ñuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ta cuhva cha cua quɨhvɨ ra Jesús chichi canoa, ra cha yɨhɨ̱ tatyi ña vaha cuan chi chacu̱ ndahvi ra nuu ra Jesús na cuhva ra cuhun ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Soco ra Jesús ña chaha̱ ra cuhun ra, ta catyí ra chi ra: ―Cua̱nuhu nya vehun, nu nyaá ñáyɨvɨ chuun, ta na̱catyun chi ñu tandɨhɨ cha sacuvi̱ Sutu yo Nyoo chuhun, ta yoso caa cundahvi̱ cuñi ra nyehe ra chuun. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ta ra cuan cuahan ra ta quichaha nacatyi ra chi ñáyɨvɨ tandɨhɨ ñuu Decápolis tandɨhɨ cha sacuvi̱ ra Jesús chihin ra. Ta tandɨhɨ ñu, iyo cuñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ta cuhva cha nachaa̱ ra Jesús chihin canoa nya inga chiyo miñi cuan, chaa̱ coyo cuaha ñáyɨvɨ nu nyaá ra. Ta ndoo̱ ra yuhu miñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tyicuan ta chaa̱ noo ra cuví nuu vehe ñuhu. Nañí ra Jairo. Ta cuhva cha nanyehe̱ ra chi ra Jesús, chicuiñi chɨtɨ ra nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ta chacu̱ ndahvi ra nuu ra ta catyí ra: ―Cha cuñí cúvi sehi. Co̱ho chihin ta tyi̱son ndahun sɨquɨ ña na nduvaha ña ta ma cúvi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tyicuan ta cuahan ra Jesús chihin ra, soco cuaha ñáyɨvɨ nyicón chi ra, ta nyacua nañi tahan ri ca maa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta mahñu ñáyɨvɨ cuan ñohó noo ñaha cha cuhví. Cha quita uchi uvi cuiya ndoho ña cuehe cha chatɨ́ nɨñɨ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta cuaha tɨndoho nyehe ña cha cuaha xaan doctor nyehe̱ chi ña. Ta cha sanaa̱ ña tandɨhɨ maa cha iyó chi ña, soco ñahri maa tyinyee̱ chi chi ña. Soco ñihi ndɨhɨ ca nanduvi. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cuhva cha chitó ña tuhun milagru cha sacuví ra Jesús, tuhva̱ ña ityi chata ra ta tɨɨ̱n ña sahma ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Vatyi chicá xiñi ña: “Ma chihin cha tɨɨn ri sahma ra, ta nduvahi”, chicá xiñi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ta caa cuhva ri cha tɨɨ̱n ña sahma ra ta cha chatɨ́ nɨñɨ ña cutaxi̱n. Ta tuvi̱ iñi coño ñuhu ña tyi cha nduvaha̱ ña chihin cuehe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tyicuan ta tuvi̱ iñi ra Jesús vatyi nduvaha̱ noo ñáyɨvɨ chihin suhva tunyee iñi cha quita̱ chi ra. Tyicuan ta nanyehe̱ ra ityi chata ra ta quichaha ndaca̱ tuhun ra: ―¿Yóó cha tɨɨ̱n sahme? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tyicuan ta ra cachicá noo chihin ra quichaha̱ catyi ra chi ra: ―Cha nyehu̱n vatyi ñáyɨvɨ tyandahá chuun tyi tɨhɨn xaan. ¿Yoso caa cha ndaca tuhun: “Yóó cha tɨɨn chii”? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Soco ra Jesús nyehe̱ ra ityi cuan ityi ihya, vatyi cuñí ra nyehe ra yóó cha tɨɨ̱n chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tyicuan ta ñaha cuan nɨhɨ́ ña chihin cha yuhví ña vatyi chitó ña ñáá cha cuvi̱ chi ña. Ta chaha̱n ña chicuiñi̱ chɨtɨ ña nuu ra. Ta nacatyi̱ ña tandɨhɨ cha ndicha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta catyí ra Jesús chi ña: ―Cha nduvahu̱n, Sɨhi, vatyi chinó iñun. Cua̱han, ta ma caca xiñun, vatyi cha nduvahu̱n chihin cuehe cha ndohu̱n ―catyí ra Jesús chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ni cahán ca ra Jesús ta chaa̱ coyo ñu vehe ra cuví nuu cuan, ta catyí ñu chi ra cha cuví sutu cha luhlu cuan: ―Sehun, cha chihi̱ ña. Ñáá ri ca tuhun cha sayangon chi Ra Sacuaha chiña ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Soco ra Jesús ña quichaha̱ ra cha caha̱n ñu, ta catyí ra chi ra cuví nuu vehe ñuhu cuan: ―Ma yuhvun. Chi̱no iñun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ña chaha̱ ra yóó ca cha cuhun chihin ra, notuhun ri ra Pedro ta ra Jacobo ta ra Juan, yañi ra Jacobo. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta cuhva cha cachaa̱ coyo ra vehe ra cuví nuu vehe ñuhu, nyehe̱ ra cha chacú chaa ñáyɨvɨ ta caná chaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Quɨhvɨ̱ ra ta catyí ra chi ñu: ―¿Ñáá tuhun cha iyo xaan cuví ndo, ta chacú ndo tyiña caa? Cuehe luhlu ihya, ña chihi̱ cue, quixí cue ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Soco chacu̱ cuehe ri ñu nyehe ñu chi ra. Tyicuan ta ra Jesús tava̱ ra chi tandɨhɨ ñu, ta quehe̱n ra chi sutu cue ta sɨhɨ cue ta chi ra cha chaa̱ coyo chihin ra, ta quɨhvɨ̱ coyo ra nu catuví cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta tɨɨ̱n ra ndaha cue, ta catyí ra chi cue: ―Talita cumi ―ta cuñí chi catyí cuan: Catyí chuun, yoho cuehe luhlu, ¡ndɨ̱cuita! ");
INSERT INTO mxtNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta caa cuhva ri cua ndɨcuita̱ cuehe luhlu cuan. Iyó uchi uvi cuiya cue. Ta cuví nacaca cue. Ta ñáyɨvɨ iyó xaan cuñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Soco ra Jesús ñihi chaha̱ ra tuhun chi ñu, tyi ma cahan maa ñu tuhun, ta catyi̱ ra chi ñu na cuhva ñu cha cachi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tyicuan caa cuvi̱ ta quita̱ ra Jesús yucuan, ta cuanuhu ra nya ñuu ra. Ta ra cachicá noo chihin ra cuahan coyo ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta chaa̱ quɨvɨ nyitatu ñáyɨvɨ, ta quichaha̱ sañaha ra chichi vehe ñuhu. Ta cuaha ñáyɨvɨ chiñi̱ tuhun cahán ra, ta iyo cuñí ñu, ta catyí ñu: ―¿Nya cutuhva̱ ra ihya tandɨhɨ tuhun ihya? ¿Yóó cha chaha̱ cha chiñi tuñi ihya chi ra? ¿Yoso caa cha cuví sacuvi ra milagru nahnu xaan ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Atu ñima ra satyá vitu cuan cuví ra? Sehe cu María cuví chi ra. Ta yañi ra Jacobo, ta ra José, ta ra Judas, ta ra Simón, ta cuhva ra iyó tucu ñu chihin yo ihya ―catyi ñu. Ta quiñi cuñí ñu nyehe ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Soco catyí ra Jesús chi ñu: ―Tandɨhɨ ñu inga ñuu sahá ñu ñáyɨvɨ chi noo ra profeta Nyoo, soco ñu ñuu ra ña quichahá ñu chi ra, ni ñu vehe ra, ni ñáyɨvɨ chi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta ña cuvi̱ sacuvi ra ni noo milagru yucuan, soco tyiso̱ ra ndaha ra sɨquɨ suhva ri ñu cuhví, ta sanduvaha̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta iyo cuñí ra vatyi ñu ñuu ra ña chinó iñi ñu chi ra. Ta chaha̱n ra tandɨhɨ ñuu nyihi cha nyicú yatyin ri cuan, ta sañaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yaha̱ cuan ta cana̱ ra chi ndɨ uchi uvi ra chicá noo chihin ra, ta quichaha̱ tachi ra chi uvi uvi ra. Ta chaha̱ ra ityi chi ra vatyi tava ñehe ra chi tatyi ña vaha yɨhɨ́ añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta catyi̱ ra chi ra vatyi ñahri maa cha cacuiso ra ityi. Ni yono, ni cha cachi ra, ni xuhun. Ñahri maa cuquɨndaha ra, noo ri yutun tuvi ra cuiso ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ndichan ri quɨhɨ chaha ra. Ta noo ri sahma cuihno ra, ñima uvi tahan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta catyí ra chi ra: ―Cuhva cha chaa ndo noo ñuu ta quɨhvɨ ndo noo vehe, ndo̱o ndo yucuan ri nyacua nya cha quita ndo ñuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ta tatu ñáyɨvɨ iyó noo ñuu, ña cuñí ñu tɨɨn cuenda ñu chi ndo, ta ña cuñí ñu tyasoho ñu tuhun cahan ndo, qui̱ta ndo yucuan ta na̱quɨsɨ ndo ñiyaca chaha ndo tari noo seña vatyi ña vaha sacuví ñu. Cha ndicha catyí chi ndo, vatyi quɨvɨ cucutuñi chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱, ñu cha ma cuñi tɨɨn cuenda tuhun cahan ndo, cuaha ca tɨndoho cunyehe ñu, ta ñima ca ñu ñuu Sodoma ta ñuu Gomorra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tyicuan ta quita̱ coyo ra ta chicaha̱n ra tuhun Nyoo chihin ñáyɨvɨ na ndu uvi iñi ñu cuatyi ñu, ta na nanducu ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta catava̱ ñehe ra cuaha tatyi ña vaha añima ñáyɨvɨ. Ta cahyu̱ ra acetye chi cuaha ñu cuhví ta casanduvaha̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chito̱ rey Herodes tuhun ra Jesús vatyi tandɨhɨ ñáyɨvɨ cahán ñu tuhun cha sacuví ra, ta chicá xiñi ra tyehe caa: ―Ra Juan ra sacondutya̱ chi ñáyɨvɨ cuví ra cuan. Nandoto̱ ra cha yaha̱ chihi̱ ra, yucuan chaha iyó tunyee iñi chi ra ―chicá iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inga ñu catyí ñu: ―Ra Elías profeta Nyoo ta cha naha cuví ra ihya ―catyí ñu. Ta inga ñu catyí ñu: ―Inga profeta Nyoo cuví ra, tari ra profeta Nyoo ra chiyo̱ ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cuhva cha chiñi̱ ra Herodes tuhun ihya, catyí ra: ―Ican ra cuan cuví ra Juan cha tyihi̱ tyiño tahnya sucun, ta vityin nandoto̱ ra ―catyí ra Herodes. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tyicuan caa catyí ra Herodes vatyi cha catyi cu Herodías, ta tyihi̱ ra chi ra Juan vehe caa ta chahñi̱ ra chi ra chihin cadena. Cu Herodías cuan, ñasɨhɨ ra Felipe, yañi ra Herodes, cuví chi ña. Soco ra Herodes quehe̱n ra chi ña vatyi cuvi ña ñasɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ta ra Juan catyi̱ ra chi ra Herodes vatyi ña vaha cha cunyaa ra chihin ñasɨhɨ yañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yucuan chaha cu Herodías tasɨ xaan cuñí ña nyehe ña chi ra Juan, ta cuñí ña cahñi ña chi ra, soco ña cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vatyi ra Herodes chitó ra vatyi ra Juan cuví ra noo ra vaha, ra ii, ta yuhví ra chi ra. Yucuan chaha sahá cuenda vaha ra chi ra, ña chaha̱ ra cha sacuvi ña cha cuñí maa ña chihin ra. Ta vasɨ ña cuaha cutuñi iñi ra Herodes cha cahán ra Juan soco vaha cuñí ra chiñí ra cha cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Soco cu Herodías ñihi̱ ña noo cuhva nu ndɨhɨ ra Herodes cuiya, vatyi sacoo̱ ra noo vico cha cuenda ra cacuví tyiño, ta comandante cuenda sɨndaro, ta ra nahnu ca ityi Galilea cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Ta quɨhvɨ̱ sehe cu Herodías vico cuan, ta quichaha chita̱ chaha ña. Ta taha̱n xaan iñi ra Herodes ta ra cha nyicú cuxiñi chihin ra. Ta tyaa ra cuhva vatyi cuhva ra ñáá cha cacan ña chi ra. Ta catyi ra chi ña: ―Ca̱can ñáá cha cuñún chii, ta cuhve chuun ―catyí ra chi ña. Ta catyí ra vatyi cuhva ra ñáá ri cha cacan ña, vasɨ sava ñuhú ñuu nu nyacá ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Quita̱ ña ta catyí ña chi sɨhɨ ña: ―¿Ñáá cha caquen chi ra? ―catyí ña. Ta catyí sɨhɨ ña: ―Ca̱can xiñi ra Juan ra sacondutyá ―catyí ña chi sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ta numi ri ndɨhvɨ̱ ñaha tyivaa cuan nu nyaá rey Herodes, ta catyí ña chi ra: ―Cuñí vatyi cahnyon xiñi ra Juan ra sacondutyá ta tyihun nuu noo coho ta cuhvon chii vityin vityin ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tyicuan ta nducuihya̱ xaan iñi rey cuan. Soco cha tyaa ra cuhva vatyi cuhva ra chi ña, ta sɨɨn ri cachiñi̱ ra canyicú chihin ra, ta ña cuñí ra nacahnu ra cha catyi̱ ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Numi ri tachi̱ rey cuan tyiño chi noo sɨndaro na quichi nyaca ra xiñi ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chaha̱n sɨndaro cuan chichi vehe caa cuan, ta chahnya̱ ra xiñi ra Juan. Ta quichi̱ nyaca ra, yɨhɨ́ nu noo coho. Tyicuan ta chaha̱ ra chi ñaha tyivaa cuan, ta maa ña nacuhva̱ ña chi sɨhɨ ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cha chito̱ ra canyicón chi ra Juan, chaha̱n coyo ra chinaquehe̱n ra coño ñuhu ra, ta cachityihi̱ ra chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yaha̱ cuan ta ndu ɨɨ̱n ri ra cha tyatyiño̱ ra Jesús chi chihin ra, ta canacatyi̱ ra tandɨhɨ cha casacuvi̱ ra, ta cha casañaha̱ ra nu chaha̱n ra chicahan ra tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta catyí ra Jesús chi ra: ―Ña̱ha ndo, na nyitatu yo chiin noo nu taxi ri iyó ―catyí ra chi ra. Tyicuan caa catyi̱ ra vatyi cuaha ñáyɨvɨ cuahan ta vachi ñu, ta nyacua ña cacuyatyi ra cha cacachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tyicuan ta maa ri maa ra Jesús ta ra cachicá noo chihin ra cuahan coyo ra chihin noo canoa noo nu yori maa ñáyɨvɨ nyicú, minoo nu taxi ri. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Soco cuaha ñu nyehe̱ nu quitá ra. Ta canɨcohon nuu ñu chi ra. Ta cuahan coyo vavaha ñu chihin chaha ñu, quita̱ ñu tandɨhɨ ñuu ta xihna ca maa ñu chaa̱ coyo. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuhva cha chaa̱ ra Jesús, quita̱ ra chichi canoa ta nanyehe̱ ra tyi cuaha xaan ñu nyicú yucuan. Ta cundahvi cuñí ra nyehé ra chi ñu, vatyi nyicú ñu tari mbee cha yori ra sahá cumi chi tɨ. Ta quichaha̱ sañaha ra cuaha tuhun chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cha cua iñi xaan, ta ra cachicá noo chihin ra catuhva̱ ra ta catyí ra chi ra: ―Cha iñi xaan, ta yucu taxin cuví ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ca̱tyi chi ñu, na cuhun ñu ñuu cha nyicú yatyin ihya, ta sata ñu pan, vatyi ñahri cha cachi ñu iyó ihya ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Soco nacaha̱n ra Jesús, ta catyí ra: ―Cu̱hva maa ndo cha cachi ñu. Canacaha̱n ra ta catyí ra: ―Vasɨ saha tyiño ndi iñu yoo, soco ma caña xuhun cha cusata ndi pan cachi tandɨhɨ ñu ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta catyí ra Jesús chi ra: ―¿Yoso tahan pan nyisó ndo? Cua̱han ndo cua nyehe ndo. Ta cuhva cha cachito̱ ra yoso tahan, cacatyí ra chi ra: ―Ohon tahan pan ta uvi tiyaca. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tyicuan ta catyi ra na cunyicú noo noo tɨcuɨtɨ ñu nu cuhu cuii cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ta chicunyicu̱ ñu cuenda ciento ta cuenda uvi xico uchi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tyicuan ta quehe̱n ra Jesús ndɨ ohon tahan pan cuan ta nɨnduvi tiyaca cuan. Ta nanyehe̱ ndaa ra andɨvɨ, ta nacuhva̱ ra tyahvi nyoo chi Nyoo, ta tahvi̱ ra pan cuan, ta chaha̱ ra chi ra cachicá noo chihin ra na casacha ra. Tyicuan ta casacha̱ ra chi ñáyɨvɨ cuan. Yaha cuan ta casacha̱ tucu ra nɨnduvi tiyaca cuan chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tandɨhɨ ñu cachachi̱ ta ndaha iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta nyacua ndoo ca ta casacutu̱ ra uchi uvi tica chihin yɨquɨn pan ta tiyaca. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ta ohon mil rayɨɨ cachachi̱ pan cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tyicuan ta catyi̱ ra Jesus chi ra cachicá noo chihin ra na quɨhvɨ coyo ra chichi canoa vatyi cuhun coyo ra ityi nuu nya inga chiyo miñi cuan ñuu Betsaida. Vatyi maa ra Jesús cunasacha xihna ra ñáyɨvɨ, tyicuan ta cuhun ra catyi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta cha yaha̱ cuahan coyo ra, ra Jesús cuahan ra nu yucu, cua cacan tahvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta cuhva cha cuaa, canoa nu ñohó ra cachicá noo chihin ra cha cuahan nya mahñu miñi cuan, ta ndoo̱ noo tuhun ri maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta nyehe̱ ra vatyi ña cacuví vaha casacaca ra canoa cuan vatyi ñihi xaan tatyi. Ta cha ñaa ca cuan tuhva̱ ra Jesús chicá ra nu ndutya cuan. Ta saha̱ ri ra cha cua yaha ra nu canoa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Soco cananyehe̱ ra chi ra, chicá ra nu ndutya. Ta cacuñi̱ maa ra vatyi noo cha sayuhvi cuví, ta cacana̱ chaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vatyi tandɨhɨ ra canyehe̱ ra chi ra ta cayuhvi̱ ra. Soco maa ra caha̱n ra chihin ra ta catyí ra: ―¡Sa̱nyee ndo iñi ndo! ¡Yuhu cuví! ¡Ma yuhvi ndo! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Quɨhvɨ̱ ra chichi canoa nu canyicú ra, ta cutaxin tatyi cuan. Ta iyo xaan cacuñí ra ");
INSERT INTO mxtNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","cha cuenda vatyi ta cutuñi ca iñi ra milagru cha sacuvi̱ ra chihin pan, vatyi ni ndava ca añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cayaha̱ sava ra miñi cuan ta cachaa̱ coyo ra ñuu Genesaret, ta cachahñi̱ ra canoa cuan yuhu ndutya ri cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ta cha quita̱ coyo ri ra chichi canoa cuan, nɨcohon nuu ri ñáyɨvɨ chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ta cachino̱ vavaha ñu nɨcahnu ityi cuan sacotó ñu vatyi chaa̱ ra. Ta quichi̱ coyo ñu tandɨhɨ ri ñuu, quichi̱ nyaca ñu chi ñu cuhví chihin chito nya nu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta tandɨhɨ ri ityi nu quɨhvɨ̱ ra chichi ñuu luhlu o chichi ñuu nahnu, o chichi cuhu, chacu̱n ñu chi ñu cuhví yuhu ityi. Ta chacu̱ ndahvi ñu nuu ra na cuhva ra cha tɨɨn ñu vasɨ chiin yuhu sahma ra. Ta tandɨhɨ ri ñu tɨɨ̱n chi ra, nduvaha̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yaha̱ cuan ta ra fariseo ta suhva ra sacuahá cuenda ley vehe ñuhu quichi̱ coyo ra nya ñuu Jerusalén, ta catuhva̱ ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ta canyehe̱ ra vatyi yɨhɨ́ ra cachicá noo chihin ra Jesús cachachí ra ta ña nacatya̱ ra ndaha ra tari cuhva cha tahán chi cha costumbre. Yucuan chaha cacaha̱n nyaa ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Vatyi ra fariseo ta tandɨhɨ ñu Israel cuan nyicón ca ñu costumbre sutu chahnu ñu, vatyi ma cachi ra tatu ma ndoo ndaha ra cuaha chaha tari cuhva costumbre iyó chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta tatu nachaa coyo ñu cha chahan ñu nuyahvi, ma cachi ñu tatu ma sacuvi ñu cuhva cuan cha canacatya xaan ñu ndaha ñu. Ta iyó cuaha ca costumbre cha canyicón ñu. Iyó noo cuhva cha tahán chi nacatya ñu vasu, jarra, ta tandɨhɨ ndaha tyiño caa cha iyó chi ñu ta cama ñu ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tyicuan ta ra fariseo ta ra sacuahá cuenda ley cuan candaca tuhun ra chi ra Jesús, ta catyí ra: ―¿Ñáá tuhun ña sacuví ra nyicón chuun cuhva costumbre sutu chahnu yo? Vatyi ña nacatyá ra ndaha ra tari cuhva tahán chi tatu cuacachi ra xita ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta nacaha̱n ra Jesús, ta catyí ra: ―Ndicha cha caha̱n ra Isaías tuhun ndo vatyi sahá ndo tyi vaha ndo ta ña ndicha ndo. Catyi̱ ra tyehe caa: Ñáyɨvɨ ihya, chihin yuhu ri ñu catyí ñu tyi cuñí ñu chii. Soco ñima chihin cha tandɨhɨ añima ñu, tyi sɨɨn nu nyaá xiñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñahri maa tuhun cha sacahnú ñu chii, vatyi cha sañahá ñu chi tahan ñu, maa maa ri maa cuhva sañahá ñáyɨvɨ ri cuví, tyaa̱ ra Isaías tuhun ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Vatyi nyoho sandoó ndo cuhva catyí Nyoo, ta nanyicón ndo cuhva costumbre ñáyɨvɨ ri, tuhun cha nacatya xaan ndo ndaha tyiño ndo, ta cuaha cha tyicuan caa sacuví ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nyoho sanducaxii̱n ndo tuhun cha catyí Nyoo tyi sacuvi ndo, tacuhva vatyi cuvi sacuvi ndo costumbre cha iyó ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Soco ra Moisés catyí ra nu ley cha tyaa̱ ra: “Sa̱ha ndo ñáyɨvɨ chi sutu ndo ta chi sɨhɨ ndo.” Ta catyí tucu ra: “Tandɨhɨ ñu cha cahán ña vaha chi sutu o chi sɨhɨ ñu, tahán chi cúvi ñu.” catyí ra Moisés nu ley Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Soco nyoho catyí ndo tyi noo ñáyɨvɨ cuví catyí ñu chi sutu ñu o chi sɨhɨ ñu tyi ma cuvi tyinyee ñu chi ñu vatyi tandɨhɨ cha iyó chi ñu Corbán cuví. (Cuñí chi catyí: “Cha chahi̱ chi Nyoo cuví.”) ");
INSERT INTO mxtNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta tatu catyí ñu tyicuan caa, ña cuñí ca chi cha tyinyee ñu chi sutu ñu o chi sɨhɨ ñu catyí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta tyicuan caa sacuachiyó ndo tuhun cha catyí Nyoo tyi sacuvi ndo, vatyi cuñí ndo sacuvi ri maa ndo tuhun cha iyó ndo. Ta cuaha ca cha ɨnuu ri caa sacuví ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tyicuan ta cana̱ tucu ra Jesús chi ñáyɨvɨ ta catyí ra chi ñu: ");
INSERT INTO mxtNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","―Tya̱soho vaha tandɨhɨ ndo tuhun cahín, ta natyihi tuñi iñi ndo. Cha quɨhvɨ́ yuhu ñáyɨvɨ ta chachí ñu, ña cuví satɨvɨ chi chi ñu. Soco cha quitá añima ñu, ican cuan satɨvɨ́ chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nyoho cha cutuñí iñi ndo, tya̱soho ndo tuhun cahín ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tyicuan ta sandoo̱ ra Jesús chi ñáyɨvɨ cuan, ta quɨhvɨ̱ ra chichi vehe. Ta ra cachicá noo chihin ra candaca̱ tuhun ra chi ra ñáá cha cuñí chi catyi tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta catyí ra Jesús chi ra: ―Tu tyicuan caa, ni nyoho, ña cutuñí iñi ndo. ¿Atu ña cutuñí iñi ndo vatyi cha quɨhvɨ́ chichi yuhu yo ña satɨvɨ́ chi chi yo? ");
INSERT INTO mxtNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vatyi ñima añima yo quɨhvɨ́ chi, soco chichi yo. Ta yaha cuan ta quita chi chichi coño ñuhu yo ―catyí ra Jesús. Chihin cuan cuñí ra catyi ra vatyi tandɨhɨ nyayu ta vaha cachi yo. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta catyí tucu ra: ―Cha quitá añima ñáyɨvɨ, ican cuan satɨvɨ́ chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vatyi añima ñu quitá cha ña vaha chicá xiñi ñu, ta sacuví ñu cha ña vaha. Yɨhɨ́ ñu iyó ñu chihin rayɨɨ o chihin ñusɨhɨ ta ñima ñasɨhɨ ra cuví, ta ñima yɨɨ ñu cuví. Yɨhɨ́ ñu casuhú ñu. Yɨhɨ́ ñu cachahñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Yɨhɨ́ ra iyó ñasɨhɨ ra ta chicá noo ra chihin inga ñu. Yɨhɨ́ ñu quichi cuvi iñi ñu cha chii inga ñáyɨvɨ. Yɨhɨ́ ñu sacuví ñu cha quiñi caa. Yɨhɨ́ ñu sandaví ñaha ñu. Yɨhɨ́ ñu iyó viciu chi ñu. Yɨhɨ́ ñu nyiyo iñi ñu. Yɨhɨ́ ñu ñɨɨ ñu cuendu. Yɨhɨ́ ñu cahnu sahá ñu chi ñu. Yɨhɨ́ ñu ña chaa cha chiñi tuñi xiñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tandɨhɨ tuhun ña vaha ihya, quitá chi ityi chichi añima ñáyɨvɨ, ta satɨvɨ́ chi chi ñu ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yaha̱ cuan ta quita̱ ra Jesús yucuan, ta cuahan ra ityi ñuu Tiro ta Sidón. Quɨhvɨ̱ ra chichi noo vehe ta ña cuñí ra cha coto ni noo ñáyɨvɨ, soco ña cuví tixehe nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta sɨhɨ noo ñaha tyivaa cha yɨhɨ́ noo tatyi ña vaha añima, numi ri chito̱ ña tuhun ra Jesús. Ta chaa ña ta chicuiñi̱ chɨtɨ ña nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ñaha cuan, ñaha inga ñuu cuví ña, ñaha ñuu Sirofenicia cuví ña. Quichi̱ ña ta chacú ndahvi ña nuu ra Jesús na tava ra tatyi ña vaha cha yɨhɨ́ añima sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Soco catyí ra Jesús chi ña: ―Sa̱ña, na̱cachi xihna ca ñu Israel ñu cuví sehe Nyoo, vatyi ña vaha cha tinyaá yo pan chi sehe yo ta cuhva yo cachi ina ―catyí ra Jesús chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta nacaha̱n ña ta catyí ña: ―Ndicha, Tata, soco ina cuan chachí tucu tɨ yɨquɨn cha canacoyo xiu mesa cuan ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tyicuan ta catyí ra Jesús chi ña: ―Vaha nacahu̱n. Ta cha cuenda cuan cuví cuhun, vatyi tatyi ña vaha cha yaha̱ quita̱ chi añima sehun ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta cuhva cha nachaa̱ ña vehe ña, catuví sehe ña nu chito, ta tatyi ña vaha cuan cha yaha̱ quita̱ chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ta quita̱ tucu ra Jesús ñuu Tiro, ta yaha̱ ra ñuu Sidón, ta cuahan ra ityi ñuu cha canañí Decápolis, ta nachaa̱ ra miñi Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nu nyaá ra Jesús yucuan, quichi̱ nyaca ñu chi noo ra soho ta ña cuví vaha cahán ra. Ta chacu̱ ndahvi ñu nuu ra Jesús na tyiso ra ndaha ra sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tava̱ sɨɨn ra Jesús chi ra ɨɨn chiyo xiin, nu yori ñáyɨvɨ, ta tyihi̱ ra nundaha ra chichi soho ra, ta tyaa̱ sɨɨ ra nu yaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yucuan ta nanyehe̱ ndaa ra andɨvɨ. Ta naxita̱ ra tatyi ra, ta catyí ra: ―¡Efata! ―ta cuñí chi catyí: ¡Nu̱ña! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ta chihin cuan nuña̱ soho ra soho cuan, ta nduvaha̱ yaa ra, ta nacaha̱n vaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ta catyi̱ ra Jesús chi ñu tyi yori chihin cahan ñu tuhun, soco tatu catyí ra chi ñu tyicuan caa, ñihi ca canacatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta iyo cuñí ñu ta catyí ñu: ―Tandɨhɨ ta vaha sacuví ra. Nyacua cuvi nacuɨñɨ ñáyɨvɨ soho sahá ra ta cuví tucu nacahan ñáyɨvɨ ñɨhɨ̱ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Quɨvɨ cuan nataca̱ tucu cuaha xaan ñáyɨvɨ. Ta ñahri maa cha cachi ñu iyó. Tyicuan ta cana̱ ra Jesús chi ra cachicá noo chihin ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Cundahvi cuñí nyehi chi ñáyɨvɨ ihya, vatyi cha uñi quɨvɨ nyicú ñu ihya chihin, ta ñahri maa cha cachi ñu iyó. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tatu natachi chi ñu nya vehe ñu cucachi ñu, coto coñaa ñu ityi, vatyi yɨhɨ́ ñu cañi quichi̱ coyo ñu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta nacaha̱n ra cachicá noo chihin ra, ta catyí ra chi ra: ―¿Soco yoso caa cuhva yo cha cachi ñu ihya, ta yori maa ñáyɨvɨ iyó ta xico ñu chi yo? ");
INSERT INTO mxtNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta ndaca̱ tuhun ra Jesús chi ra, ta catyí ra: ―¿Yoso tahan pan nyisó ndo? Ta cacatyí ra: ―Ucha tahan. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ta catyí ra na cunyicu ñáyɨvɨ cuan nu ñuhú. Ta quehe̱n ra ucha pan cuan, ta nacuhva̱ ra tyahvi nyoo chi Nyoo. Yaha̱ cuan ta tahvi̱ sava ra pan cuan, ta chaha̱ ra chi ra cachicá noo chihin ra, na casacha ra chi ñáyɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta canyisó tucu ra suhva tiyaca nyihi. Ta nacuhva̱ tucu ra Jesús tyahvi nyoo chi Nyoo, ta chaha̱ ra chi ra na casacha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tandɨhɨ ñu cachachi̱ ñu, ta cachitu chichi ñu. Ta casacutu ra ucha tahan tica chihin yɨquɨn cha ndoo ca. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ta cha cumi mil tahan ñu cachachi̱. Yaha̱ cuan ta catyí ra Jesús chi ñu na cunuhu coyo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta quɨhvɨ̱ ra chichi noo canoa chihin ra cachicá noo chihin ra. Ta cuahan coyo ra ityi Dalmanuta. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tyicuan ta cachaa̱ coyo ra fariseo, ta quichaha cuvi yuhu ra chihin ra Jesus. Ta cacatyí ra chi ra na sacuvi ra noo milagru tatu ndicha cha Nyoo tachi̱ chi ra. Tyicuan caa catyi̱ ra vatyi cuñí ra nducu nyehe ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta ra Jesús uhvi uhvi naxita̱ ra tatyi ra, ta catyí ra: ―¿Ñáá tuhun cha chicán ñáyɨvɨ iyó vityin milagru? Cha ndicha catyí chi ndo vatyi ma sacuvi ni noo milagru nyehe ndo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tyicuan ta sandoo̱ ra chi ra, ta nandɨhvɨ̱ ra chichi canoa ta cuahan ra inga chiyo miñi. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naa iñi ra cachicá noo chihin ra Jesús cacuiso ra cha cacachi ra. Ta noo pan ri ñohó chihin ra chichi canoa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tyicuan ta catyí ra Jesús chi ra: ―Sa̱ha ndo cuenda chi ndo chihin yuchan iya ra fariseo ta ra Herodes ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta ra cachicá noo chihin ra quichaha cacatyi ra chi ra tahan ra: ―Cha cuenda vatyi ñahri pan nyisó yo, yucuan cuenda caha̱n ra tuhun cuan ―catyí ra chi ra tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tuví iñi ra Jesús cha ndatuhún ra, ta catyí ra chi ra: ―¿Ñáá tuhun cha catyí ndo tyi ñahri pan nyisó ndo? ¿Atu ta cutuñi ca iñi nyoho? ¿Atu ta coto ca ndo? ¿Atu ni ndava xaan añima ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyaá chɨtɨ nuu ndo, ¿atu ña nyehé ndo? Nyaá soho ndo. ¿Atu ña chiñí ndo? ¿Atu ña nɨcohon iñi ndo ");
INSERT INTO mxtNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","quɨvɨ cha sache̱ ohon tahan pan cuan chi ndɨ ohon mil rayɨɨ? ¿Yoso tahan tica yɨquɨn naquehe̱n ndo? ―catyí ra Jesús, ndacá tuhun ra chi ra cachicá noo chihin ra. Ta maa ra cacatyí ra: ―Uchi uvi. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta catyí tucu ra Jesús chi ra: ―Ta quɨvɨ sache̱ ucha tahan pan chi cumi mil ñu, ¿yoso tahan tica tyitu nacoñehe̱ ndo? Ta cacatyí ra: ―Ucha tahan. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tyicuan ta catyí ra Jesús chi ra: ―¿Atu ta cutuñi ca iñi ndo? ―catyí ra chi ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yaha̱ cuan ta chaa̱ ra Jesús chihin ra cachicá noo chihin ra nya ñuu Betsaida. Ta quichi̱ nyaca ñu chi noo ra cuaa. Ta cachacu̱ ndahvi ñu nuu ra na tɨɨn ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tyicuan ta tɨɨ̱n ra ndaha ra cuaa cuan, ta cuahan ra chihin ra ityi chata ñuu. Ta tyaa̱ sɨɨ ra chɨtɨ nuu ra, ta tyiso̱ ra ndaha ra sɨquɨ ra, ta ndaca̱ tuhun ra chi ra tatu cuví nyehe ra chiin. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ra cuaa cuan nanyehe̱ ra ta catyí ra: ―Nyehí ɨn cahnu ri maa chi ñáyɨvɨ. Cuhva caa yutun caa ñu cahvi iñi, soco chicá ñu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tyicuan ta tɨɨ̱n tucu ra Jesús chɨtɨ nuu ra inga chaha, ta maa ra nanyehe̱ vaha ra ta nduvaha̱ ra. Nanyehe cachi vaha ra tandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tyicuan ta natachi ra Jesús chi ra ta catyí ra chi ra: ―Ma quɨ̱hvun chichi ñuu ta ni yori chihin cahun tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yaha̱ cuan ta chaha̱n ra Jesús chihin ra cachicá noo chihin ra ñuu cha ca iyó Cesarea Filipo. Ta ityi cuahan ra, ta ndaca̱ tuhun ra chi ra cachicá noo chihin ra, ta catyí ra: ―¿Ñáá catyí ñáyɨvɨ? ¿Yóó ra cuví yuhu? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta canacaha̱n ra ta catyí ra: ―Yɨhɨ́ ñu catyí ñu tyi ra Juan ra sacondutyá chi ñáyɨvɨ cuvún. Inga ñu catyí ñu tyi ra Elías cuvún. Ta inga ñu catyí ñu tyi inga ra profeta Nyoo cuvún ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tyicuan ta ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Ta nyoho, yóó ra cuví yuhu, cuñí tucu nyoho? Ra Pedro catyí ra chi ra: ―Yoho cuví Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Soco catyi ra Jesús chi tandɨhɨ ra tyi yori chihin cacahan ra tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tyicuan ta quichaha̱ sañaha ra vatyi Rayɨɨ cha quichi̱ nya gloria cunyehe ra cuaha xaan tɨndoho. Ta ra mandoñi ta ra cacuví nuu chi tata sutu ta ra casacuahá cuenda ley vehe ñuhu ma cuñi ra natɨɨn cuenda ra chi ra. Catyi̱ ra Jesús chi ra vatyi cucahñi ñu chi ra soco chichi cha cu uñi quɨvɨ cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Catyi̱ cachi ra chi ra tuhun ihya. Tyicuan ta tava̱ sɨɨn ra Pedro chi ra ta quichaha catyi ra tyi ña vaha cha cahan ra cha tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Soco ra Jesús nanyocava̱ ra, ta nanyehe̱ ra chi inga ra cachicá noo chihin ra. Ta quichaha cahan ra chi ra Pedro ta catyí ra: ―¡Cua̱chiyo chuun nui, cuihna! Vatyi yoho ña chicá xiñun tari cuhva chicá xiñi Nyoo, soco tari chicá xiñi ñáyɨvɨ, chicá xiñun ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tyicuan ta cana̱ ra Jesús chi ñáyɨvɨ ta chi ra cachicá noo chihin ra ta catyí ra chi ñu: ―Tatu nya ndo cuñí ndo cunyicon ndo chii, cuñí chi cahnya ndo iñi ndo tuhun maa ndo. Ta ma ndu uvi iñi ndo cha yɨhɨ́ ndo cuende vasɨ nyehe ndo tɨndoho cha cuende. Vatyi yucuan cuví cruzi cha tahán chi cuiso ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vatyi nya ndo ña cuñí ndo cúvi ndo cha cuende, suri cha cúvi maa ndo cuvi, ta cuhun ndɨhɨ ndo anyaya. Soco nya ndo cuhva ndo ñayɨvɨ̱ ndo cha cuende ta cha cuenda tuhun Nyoo, cucacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tatu sacunaa ndo añima ndo anyaya, ¿ñáá ri tuhun cha saha ganaa ndo tandɨhɨ cha tyayɨɨ cha iyó sɨquɨ ñuhu ñayɨvɨ̱? ");
INSERT INTO mxtNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Vatyi tatu sacunaa ndo añima ndo, ñahri maa cha iyó cha cuví cuhva ndo ta sacacu ndo añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tatu nya noo ndo cucahan nuu ndo nyehe ndo chii, ta cucahan nuu ndo tuhun cahín nuu ñáyɨvɨ cha iyó cuatyi ta ña quichahá tuhun Nyoo, yuhu Rayɨɨ cha quichi̱ nya gloria cucahan tucu nuu mai nyehi chi ndo quɨvɨ quichi tiqui chihin ángel cuenda Nyoo. Vatyi cuquichi chihin cha tyaquɨ maa Suti. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","’Cha ndicha catyí chi ndo, vatyi yɨhɨ́ ndo cha nyicú ndo ihya, ma cúvi ñaha ndo nyacua nya nyehe ndo yoso caa nyacá ñaha Nyoo. Vatyi cuquichi chihin tunyee iñi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iñu quɨvɨ yaha ta cuahan ra Jesús noo yucu sucun. Ta ra Pedro, ra Jacobo, ta ra Juan ri cuahan coyo chihin ra. Ta yucuan nasama̱ cuhva caa nuu ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nduxiño xaan sahma ra ta cuichin xaan nanduvi̱. Yori maa sɨquɨ ñuhu ñayɨvɨ̱ ihya cuví nacatya ta nducuichin tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta cananyehe̱ ra tyi nanyaá ra Elías ta ra Moisés, candatuhún ra chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tyicuan ta ra Pedro catyí ra chi ra Jesús: ―Maestro, ¡vaha xaan cha nyicú ndi ihya! Na savaha ndi uñi tahan tiyahva: noo cha cuenda maun, ta noo cha cuenda ra Moisés, ta nonga cha cuenda ra Elías ―catyí ra Pedro, ");
INSERT INTO mxtNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","vatyi ña chitó ra ñáá tuhun cahán ra. Vatyi maa ra ta inga ra cayuhví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tyicuan ta noo̱ xica noo vico sɨquɨ ra ta sahvi̱ chi ra. Ta chichi vico cuan tyacu noo ndusu cha catyí: ―Ican ihya cuví Sehi, ta cuñí xain chi ra. Tya̱soho ndo tuhun cahan ra ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta cuhva cha cananyehe̱ ra, yori ca ra tayucú chihin ra, noo ri ca maa ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuhva cha cuanoo coyo ra yucu cuan, catyí ra Jesús chi ra tyi ma cacahan ra tuhun cha canyehe̱ ra yucuan, soco nya yaha cha nandoto Rayɨɨ cha quichi nya gloria, tyicuan ta cuvi cahan ra tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yucuan chaha ña cacaha̱n maa ra tuhun, vasɨ cacatyí ra chi tahan ra ñana vaha tuhun cuví cha cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tyicuan ta quichaha̱ candaca tuhun ra chi ra Jesús: ―¿Ñáá tuhun cha catyí ra casacuahá cuenda ley vehe ñuhu vatyi cuquichi xihna ca ra Elías? ");
INSERT INTO mxtNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta nacaha̱n ra, ta catyí ra: ―Cha ndicha vatyi xihna ca ra Elías nyaá quichi ta sanduvaha ra tandɨhɨ. ¿Ta yoso caa catyí tuhun Nyoo cuenda Rayɨɨ cha quichi nya gloria? Catyí chi tyi cunyehe ra tɨndoho, ta ma cuñi nyehe ñáyɨvɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Soco yuhu catyí chi ndo tyi cha yaha̱ quichi̱ ra Elías. Ta sacuvi̱ maa ñáyɨvɨ cha cuñi̱ ñu chihin ra, tari cuhva catyí nu tutu Nyoo cha cucuvi chi ra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yaha̱ cuan ta nachaa̱ coyo ra nu nyicú inga ra cachicá noo chihin ra Jesús. Ta canyehe̱ ra tyi cuaha ñáyɨvɨ tayucú nicachico. Ta nyicú tucu ra sacuahá cuenda ley yucuan, ta cacuví yuhu ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tyicuan ta cha nanyehe̱ ñu chi ra Jesús, tandɨhɨ ñu iyo cuñí ñu, ta cachino ñu chicuhva ñu nocumi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tyicuan ta ndaca̱ tuhun ra Jesús chi ra cacuvi yuhu cuan ta catyí ra: ―¿Ñáá cuenda cuví yuhu xaan ndo? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ta noo ra nanyaá chichi cha cuaha ñáyɨvɨ yucuan, nacaha̱n ra ta catyí ra: ―Maestro, ihya vachi nyaque chi sehi. Yɨhɨ́ noo tatyi ña vaha chi cue ta sacuñɨhɨ chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vatyi tandɨhɨ ri nu tɨɨn tatyi cuan chi cue, sanduva chi cue nu ñuhú, ta yucuan quita tɨñɨ yuhu cue ta cahñi noho cue. Ta ndundava cue. Cha catyi̱ chi ra cachicá noo chuhun na tava ra tatyi ña vaha cuan, soco ña cacuvi̱ chi ra ―catyí ra cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nacaha̱n ra Jesús ta catyí ra: ―¡Nyoho ñu ña chinó iñi cuví ndo! ¿Yoso tahan ca quɨvɨ cunyai chihin ndo ta cunyei tɨsɨhɨ ndo nyacua nya cha cutuhva ndo ta chino iñi ndo chii? Ta catyí ra chi ra cuan: ―Nya̱ca chi ra luhlu chiña tyehe ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Quichi̱ nyaca ra chi ra luhlu cuan. Ta cuhva cha nanyehe̱ tatyi cuan chi ra Jesús, quehe̱n tatyi cuan chi cue. Ta nduva̱ cue nu ñuhú, sacañuhú cue chi cue, ta quita̱ tɨñɨ yuhu cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tyicuan ta ndaca̱ tuhun ra Jesús chi sutu cue: ―¿Ama quichaha cuvi chi ra tyehe caa? ―catyí ra chi ra. Ta nacaha̱n sutu cue, ta catyí ra: ―Nyata luhlu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta cuaha chaha tyihi̱ tatyi ña vaha ihya chi cue nu cayú ñuhu̱, o nu ndutya. Cuñí chi cahñi chi chi cue. Soco tatu cuví chuun, cu̱ndahvi cuñi nyehun chi ndi, ta tyi̱nyeun chi ndi ―catyí sutu cue chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta catyí ra Jesús chi ra: ―Tatu chinó iñun, tandɨhɨ ta cuví cha cuenda ñu chino iñi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tyicuan ta sutu cue canachaa̱ ra ta catyí ra: ―¡Chinó iñi! ¡Tyi̱nyee chii na chino ca iñi! ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cuhva cha nyehe̱ ra Jesús tyi cuaha ñáyɨvɨ candu ɨɨ̱n ri, ta tava̱ ñehe ra chi tatyi ña vaha cuan, ta catyí ra: ―Yoho tatyi ña vaha cha sañɨhɨ́ ta sasohó chi cue ihya, catyí chuun, na quiton. Sa̱ña chi ra luhlu ihya, ta ma ndɨhvɨ con chi ra ―catyí ra Jesús chi tatyi ña vaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta tatyi cuan quiñi xaan canachaa̱ ta na quɨsɨ chi chi cue inga chaha ta quita̱. Ta sandoo̱ tatyi cuan chi cue tari noo ndɨyɨ. Ta cuaha ñu catyí vatyi cha chihi̱ cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Soco tɨɨ̱n ra Jesús ndaha cue, ta nacoñehe̱ ra chi cue, ta nicuinanyaa̱ cue. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tyicuan ta quɨhvɨ̱ ra Jesús noo vehe, ta ra cachicá noo chihin ra candaca̱ tuhun ra chi ra ta catyí ra: ―¿Ñáá tuhun ña cuvi̱ tava ndi chi tatyi ña vaha cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta catyí ra Jesús: ―Cha cuenda vatyi tahan tatyi ña vaha ihya, quitá, soco chihin cha ma cachi yo ta cacan tahvi yo chi Nyoo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Quɨvɨ cha quita̱ coyo ra yucuan, yahá coyo ra ityi Galilea. Ta ña cuñí ra Jesús cha coto ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Vatyi sañahá ra chi ra cachicá noo chihin ra. Ta catyí ra chi ra vatyi Rayɨɨ cha quichi nya gloria cunacuhva cuenda ñu chi ra ndaha ñáyɨvɨ. Ta cucahñi ñu chi ra, soco cha cu uñi quɨvɨ cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Soco ña cacutuñí iñi ra tuhun cahán ra chihin ra. Ta cayuhví ra candaca tuhun ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tyicuan ta cachaa̱ coyo ra ñuu Capernaum. Ta cuhva cha nyicú ra nya vehe, ra Jesús ndaca̱ tuhun ra chi ra ta catyí ra: ―¿Ñáá tuhun cuvi̱ xaan yuhu nyoho ityi vachi yo? ―catyí ra ndaca tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Taxi taxi cacuvi̱ ra, vatyi ityi vachi coyo ra, ta cacuví yuhu ra nya ra cuví ra ra cahnu ca. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tyicuan ta chicunyaa̱ ra Jesús ta cana̱ ra chi ndɨ uchi uvi ra chicá noo chihin ra, ta catyí ra chi ra: ―¿Nya ndo cuñí ndo cuvi ndo nuu, cuñí chi cha cuví ndo ra nu ndɨhɨ cha nuu tandɨhɨ ra, ta sacuvi ndo tyiño nuu tandɨhɨ ra? ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tyicuan ta quehe̱n ra chi noo ra cuehe luhlu ta chinanyaa̱ ra chi cue mahñu ra. Ta tyihi̱ sucun ndaha ra chi cue, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ñáyɨvɨ cha natɨɨ́n cuenda chi noo ra cuehe luhlu chihin sɨvi, chi yuhu natɨɨ́n cuenda ñu. Ta ñu natɨɨ́n cuenda chii, ñima chi yuhu ri natɨɨ́n cuenda ñu, soco chi ra cha tachi̱ chii ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tyicuan ta catyí ra Juan chi ra Jesús: ―Maestro, nyehe̱ ndi chi noo ra cuan ta chihin sɨvun tavá ñehe ra chi tatyi ña vaha. Soco vatyi ñima chihin yo chicá noo ra, catyi̱ ndi chi ra tyi ma sacuvi ca ra ―catyí ra Juan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Soco catyí ra Jesús chi ra: ―Ma casɨ ndo. Vatyi ni noo ra cha casacuvi milagru chihin sɨvi ta yaha cuan ta caña iñi ra cahan ña vaha ra sɨqui. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vatyi ñu cha ña cuahan sɨquɨ yo, tumañi iñi chi yo cuahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tatu cuhva noo ñu, vasɨ noo vasu ndutya coho ndo chihin sɨvi, cha cuenda vatyi ñu cuenda yuhu ra Cristo cuví ndo, cha ndicha vatyi cuñihi ñu cha cuacuhva Nyoo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tatu yóó ñu sanacava nu cuatyi chi noo ñu chinó iñi chii, vaha taxin ca cuhñi ñáyɨvɨ noo yuu sucun ñu ta tuchi ñu chi ñu cuan nu tyañuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tatu ndahun sanacavá chuun nu cuatyi, vaha taxin ca ca̱hnya. Vatyi vaha ca cha quɨhvun nu coun chihin Nyoo chihin cha luu ndahun ta ñima ca chihin cha nɨnduvi ndahun ta cuhun anyaya nu cayú ñuhu̱ cha ma ndahva ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta yucuan ña chihí tɨndacu chachí chi ñu, ta ñuhu̱ ña ndahva maa ni noo chaha. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ta tatu chahun ta sanacavá chuun nu cuatyi, vaha taxin ca ca̱hnya. Vatyi vaha ca cuhun nu coun chihin Nyoo chihin cha luu chahun ta ñima ca chihin cha nɨnduvi chahun ta tuchi Nyoo chuun anyaya. Vatyi yucuan ma ndahva ca maa ñuhu̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta ña chihí tɨndacu chachí chi ñu, ta ñuhu̱ ni noo chaha ña ndahva. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ta tatu noo chɨtɨ nuu sanacavá chuun nu cuatyi, vaha taxin ca ta̱va. Vatyi vaha ca cha quɨhvun nu nyacá ñaha Nyoo chihin noo chɨtɨ nuu ta ñima ca chihin nɨnduvi chɨtɨ nuun ta tuchi Nyoo chuun anyaya. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vatyi yucuan ña chihí tɨndacu chachí chi ñu, ta ni noo chaha ña ndahva ñuhu̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Soco tandɨhɨ ñu nyicon chii, tari cha cayú ñu chihin ñuhu̱ tatu nyehe ñu tɨndoho cha cuende, vatyi chihin cuan cua sanduvaha Nyoo chi ñu, tari nduvaha nyayu chihin ñɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ñɨɨ vaha xaan. Soco tatu ndɨhɨ cha uhva, ¿yoso caa cuví cotyiño yo inga chaha? Tyicuan caa tucu nyoho, ma sandɨhɨ ndo cha coo tuhun Nyoo añima ndo cha cuví tari ñɨɨ vaha. Tyicuan caa ta coo taxi ri ndo chihin tahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Quita̱ ra Jesús Capernaum ta cuahan ra ityi Judea nya inga chiyo yutya Jordán. Yucuan candu̱ ɨɨn ri ñáyɨvɨ inga chaha nu nyaá ra, ta quichaha̱ sañaha tucu ra chi ñu tari tuhvá maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tyicuan ta suhva ra fariseo catuhva̱ ra nu nyaá ra Jesús, vatyi nducu ra cuhva tyaa ra cuatyi sɨquɨ ra. Ta candaca̱ tuhun ra chi ra tatu vaha cha sandoo noo rayɨɨ chi ñasɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tyicuan ta nacaha̱n ra Jesús ta catyí ra: ―¿Ñáá cha catyi̱ ra Moisés tyi sacuví ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta canacaha̱n ra ta cacatyí ra: ―Ra Moisés chaha̱ ra cha cuví cahnya noo ra tutu cha tandaha ra tyicuan ta cuvi sandoo ra chi ñasɨhɨ ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tyicuan ta catyí ra Jesús chi ra: ―Catyi̱ ra Moisés cha sacuvi ndo tyicuan caa soco cha cuenda cha ndava añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Soco quɨvɨ xihna ri, quɨvɨ savaha̱ Nyoo tandɨhɨ maa, savaha̱ ra rayɨɨ ta ñaha sɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Yucuan cuenda sandoó rayɨɨ chi sutu ra ta chi sɨhɨ ra vatyi ndu ɨɨn ri ra chihin ñasɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ta chichi cha nɨnduvi tahan ñu cucuvi ñu tari cha noo ri ñáyɨvɨ.” Yucuan chaha ñima ca uvi tahan cuví ñu, soco cha nanduvi̱ ñu noo ri ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yucuan chaha, ña tahán chi cha sasɨɨn ñáyɨvɨ cha sandu̱ ɨɨn ri Nyoo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yaha̱ cuan ta nachaa̱ coyo ra nya vehe, ta quichaha̱ ndaca tuhun ra cachicá noo chihin ra inga chaha sɨquɨ tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta catyí ra Jesús chi ra: ―Ra cha sandoó ñasɨhɨ ta tandaha ra chihin inga ñu, chicoó cuatyi ra vatyi ña vaha sacuvi̱ ra chihin ñasɨhɨ ra, ñaha cha xihna ri cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ta tyicuan caa tucu ñusɨhɨ. Tatu sandoó ñu chi yɨɨ ñu ta tandaha ñu chihin inga ra suri chicoo̱ tucu cuatyi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tyicuan ta quichi̱ nyaca ñu suhva ra cuatyaa chi ra Jesús tacuhva natyiso ra ndaha ra sɨquɨ ndotyin. Soco ra cachicá noo chihin ra ña chahá ca ra cha quichi nyaca ñu chi ndotyin. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Soco cuhva cha nanyehe̱ ra Jesús, cuxaan ra. Ta catyí ra chi ra: ―Sa̱ña ndo. Na quichi nyaca ñu chi ra cuatyaa nu nyaí. Ta ma casɨ ndo. Vatyi ñu nyacá ñaha Nyoo añima, cuví ñu chinó iñi chi Nyoo tari chinó iñi ra cuatyaa ihya. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cha ndicha catyí chi ndo vatyi tatu ma nacuhva cuenda ndo chi ndo chi Nyoo tari noo ra cuatyaa chihin sutu ndotyin, ma cuvi quɨhvɨ ndo nu nyacá ñaha Nyoo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta quehe̱n ra chi noo noo ndotyin ta tyihi̱ sucun ndaha ra. Ta tyiso̱ ra ndaha ra sɨquɨ ndotyin, ta chica̱n tahvi ra chaha ndotyin. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yaha̱ cuan ta cuahan ra Jesús. Ta chino̱ vavaha noo ra cuan chata ra ta chicuiñi̱ chɨtɨ ra nuu ra, ta ndaca̱ tuhun ra chi ra, ta catyí ra: ―Maestro, ra vaha cuvún. ¿Yoso caa sacuvi ta ñihi ñayɨvɨ̱ cha ma naa ca maa coi? ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta catyí ra Jesús chi ra: ―¿Yoso caa chitón tyi vahi? Noo ri ra vaha iyó, ta ican ra cuan cuví Nyoo. (Ta cha catyún tyi vahi, nacotón tyi Nyoo cuví.) ");
INSERT INTO mxtNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yoho cha chitón cha catyí Nyoo cha sacuvi yo: “Ma coun chihin inga ñusɨhɨ tatu ñima ñasɨhun cuví. Ma cahñun. Ma suhun. Ma cahun cuendu sɨquɨ ni noo ñu. Ma sandavi ñahun. Sa̱hun ñáyɨvɨ chi sutun ta chi sɨhun” ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta nacaha̱n ra cuan ta catyí ra: ―Maestro, tandɨhɨ ihya cha sacuví nyata luhli ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tyicuan ta cusɨɨ cuñí ra Jesús nanyehé ra chi ra. Ta catyí ra chi ra: ―Cumañi noo ri ca cha cumañi chuun. Cua̱han ta xi̱con tandɨhɨ cha iyó chuun ta cu̱hvon chi ñu ndahvi. Tyicuan ta coo cha tyayɨun nya andɨvɨ. Yaha cuan ta qui̱chun cunyicon chii vasɨ nyehún tɨndoho ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Soco cha chiñi̱ ra tuhun caha̱n ra Jesús tyehe caa, nducuihya̱ iñi ra, ta cuihya xaan cuanuhu ra vatyi tyayɨɨ xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tyicuan ta nanyehe̱ ra Jesús nicachico chata ra, ta catyí ra chi ra cachicá noo chihin ra: ―¡Ñana cha yɨɨ ta cuvi nacuhva cuenda ñu tyayɨɨ chi ñu na cunyaca ñaha Nyoo chi ñu! ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iyo cacuñí ra cachicá noo chihin ra tuhun cahán ra. Soco catyí ra Jesús chi ra inga chaha: ―Sehi, ñu cha tyaa xaan xiñi cha tyayɨɨ, ¡yɨɨ xaan quɨhvɨ ñu nu nyacá ñaha Nyoo! ");
INSERT INTO mxtNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tañi tyehe yaha noo camellu xiu noo yɨquɨ tɨcu, ta ñima ca cha cuhva noo ñu tyayɨɨ cunyacá ñaha Nyoo chi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cha cachiñi̱ ra tuhun ihya, iyo xaan cacuñí ra, ta candaca̱ tuhun ra chi ra tahan ra, ta catyí ra: ―Tu tyicuan caa, ¿yóó cha cuví cacu añima? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nanyehe̱ ra Jesús chi ra ta catyí ra chi ra: ―Ñáyɨvɨ ña cuví sacuvi ñu ihya. Soco Nyoo cuví chi ra. Vatyi cha cuenda Nyoo ñahri cha yɨɨ sacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tyicuan ta catyí ra Pedro chi ra: ―Sutu Mañi yuhu, nyuhu sandoo̱ ndi tandɨhɨ cha iyó chi ndi, ta vityin nyicón ndi chuun. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nacaha̱n ra Jesús ta catyí ra: ―Cha ndicha catyí chi ndo vatyi tandɨhɨ ñu sandoo̱ vehe, o yañi, o cuhva, o sutu, o sɨhɨ, o ñasɨhɨ, o sehe, o ñuhú, cha cuenda yuhu ta cha cuenda cha sacoto ñu chi ñáyɨvɨ tyi cuñí Nyoo sacacu ra chi ñu, ");
INSERT INTO mxtNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cuañihi ñu ciento chaha sɨquɨ cha sandoo̱ ñu ihya ñuhu ñayɨvɨ̱. Cuañihi ñu vehe ta yañi ñu, ta cuhva ñu, ta sɨhɨ ñu, ta sehe ñu, ta ñuhú, vasɨ sanyehe ñáyɨvɨ tɨndoho chi ñu. Soco inga ñayɨvɨ̱ cha vachi, cuñihi ñu ñayɨvɨ̱ cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Soco cuaha xaan ñu cha cuvi nuu vityin, ñu nu ndɨhɨ cucuvi ñu. Ta cuaha xaan ñu cuví ñu nu ndɨhɨ vityin, ican ñu cucuvi nuu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cuahan coyo ra ndaa ra ityi cuahan ñuu Jerusalén, ta ra Jesús cuahan ra ityi nuu ñu nyicón chi ra. Ta maa ñu iyo cuñí ñu ta chihin cha yuhví ñu cuahan coyo ñu chata ra. Tyicuan ta cana sɨɨ̱n ra chi ndɨ uchi uvi ra cachicá noo chihin ra. Ta quichaha̱ catyí ra cha cucuvi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ta catyí ra: ―Tari cuhva nyehé ndo vityin, cua ndaa yo ityi cuahan ñuu Jerusalén nu cucuhva cuenda ñu chi yuhu Rayɨɨ cha quichi nya gloria chi ra cuví nuu chi tata sutu, ta chi ra sacuahá cuenda ley vehe ñuhu. Ta cucatyi ra tyi cucúvi ta cucuhva cuenda ra chii chi ra inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ta cucuacu nyaa ra chii, cucañi ra chii, cutyicu sɨɨ ra chii. Ta cucahñi ra chii. Soco cha cu uñi quɨvɨ cunandote cha yaha cúvi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tyicuan ta ra Jacobo ta ra Juan, ra cacuví sehe ra Zebedeo, catuhva̱ ra nu nyaá ra Jesús, ta catyí ra chi ra: ―Maestro, cuñí ndi cha sa̱hun noo tumañi iñi chi ndi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta ndaca̱ tuhun ra Jesús chi ra: ―¿Ñáá cha cuñí ndo cha sacuvi cha cuenda ndo? ");
INSERT INTO mxtNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta canacaha̱n ra ta catyí ra: ―Cu̱hva cha cunyaa ndi chuhun nu nyacá ñahun, noo ndi chiyo vahun, ta inga ndi chiyo satyun ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tyicuan ta catyí ra Jesús chi ra: ―Nyoho ña chitó ndo cha chicán ndo. ¿Atu cuví nyehe nyoho tɨndoho cha cuanyehe yuhu? ¿Atu cuví cuhun ndo tuhun chihi tari cuhun yuhu? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta canacaha̱n ra: ―Cuví chi ndi. Ta ra Jesús catyí ra: ―Cha ndicha vatyi cunyehe ndo tɨndoho ta cuhun ndo tuhun chihi tari cuhun yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Soco tuhun cha cunyaa ndo chiyo vahi ta chiyo satyin, ñima yuhu tahán chi cuhve chi ndo, soco maa Nyoo cucatyi yóó cha cuñihi nyatu cuan ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cha cachiñi̱ uchi ca tahan ra chicá noo chihin ra Jesús tuhun cuan, cacuxaan ra chihin ra Jacobo ta ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Soco cana̱ ra Jesús chi ra ta catyí ra chi ra: ―Chitó nyoho vatyi ra canyacá ñaha chi ñáyɨvɨ sɨquɨ ñuhu ñayɨvɨ̱, ñihi xaan yosó ra sɨquɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Soco ñima tyicuan caa tahán chi sacuvi nyoho. Vatyi ra cuñí cucahnu ca, cuñí chi cuvi ra musu tandɨhɨ ca ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta nya nyoho cha cuñí ndo cuví ndo nuu, cuñí chi cuvi ndo musu tandɨhɨ ca ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vatyi nɨ ri yuhu Rayɨɨ cha quichi̱ nya gloria ta ña vachi vatyi sacuvi ñáyɨvɨ tyiño nui. Soco vachi vatyi sacuvi tyiño nuu ndo. Ta vachi vatyi cuhve ñayɨvi̱ tari noo cha cutyiyahvi ta cusacaqui cuaha ñáyɨvɨ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tyicuan ta cachaa̱ coyo ra ñuu Jericó. Ta cua yaha ri ra ñuu cuan. Ta cuhva cha quita̱ ra Jesús ñuu cuan cuaha xaan ñáyɨvɨ cuahan chata ra, ɨɨn ri chihin ra cachicá noo chihin ra. Ta yucuan nyaá noo ra cuaa cha nañí Bartimeo. Sehe ra Timeo cuví chi ra. Nyaá ra cuan yatyin ri yuhu ityi cuan, chicán ra caridaa. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta cha chiñi̱ ra cuaa cuan tyi cua yaha ra Jesús ra ñuu Nazaret, quichaha̱ cana chaa ra, ta catyí ra: ―¡Yoho Jesús, ra vachi tata ra David, cu̱ndahvi cuñi chii! ―catyí ra canachaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cuaha ñu chasɨ yuhu ra na cutaxin ra, soco maa ra ñihi ca cana chaa ra ta catyí ra: ―¡Yoho ra vachi tata ra David, cu̱ndahvi cuñi chii! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tyicuan ta chicuɨñɨ̱ ra Jesús ta catyí ra: ―Ca̱na ndo chi ra. Ta cacana̱ ra chi ra cuaa cuan ta catyí ra chi ra: ―Sa̱nɨɨ iñun. Ndu̱cuita, vatyi caná ra chuun ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tyicuan ta tuchi̱ ñihno ra sahma ndichi ra. Ta ndava̱ ra noo ta tuhva̱ ra nuu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tyicuan ta quichaha̱ ndaca̱ tuhun ra Jesús chi ra: ―¿Ñáá cha cuñún cha sacuvi chuhun? Ta nacaha̱n ra cuaa cuan ta catyí ra: ―Maestro, cuñí cha sanduvahun chɨtɨ nui ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta catyí ra Jesús chi ra: ―Cua̱han. Cha nduvahun vatyi chinó iñun chii. Ta caa cuhva ri cuan cuví nanyehe ra cuaa cuan. Ta cuahan ra chata ra Jesús ityi cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cachaa̱ coyo ra yatyin ri ñuu Jerusalén, nu nyaá ñuu Betfagé ta ñuu Betania. Ta yucu yutun Olivo nyaá ityi nuu chiin ca. Tyicuan ta catyí ra Jesús chi uvi ra chicá noo chihin ra: ");
INSERT INTO mxtNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Cua̱han ndo chichi ñuu cha nyaá ityi nuu chiña. Ta nu cua chaa ndo cunañihi ndo noo burru chaa nuhñí tɨ, quɨtɨ ta quɨhɨ ca tyayu cuví tɨ. Nda̱chi ndo chi tɨ, ta qui̱chi nyaca ndo chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta tatu yóó cha ndaca tuhun ñáá tuhun sacuví ndo tyicuan caa, ca̱tyi ndo chi ñu vatyi chiñuhú tɨ chi ra nyacá ñaha, ta numi ri cunanyaca ndo chi tɨ, ca̱tyi ndo chi ñu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tyicuan ta cuahan coyo ra, ta canañihi̱ ra burru cuan nuhñí tɨ ityi cahnu yatyin ri noo yuvehe, ta candachi̱ ra chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta suhva ra canyicú cuan catyí ra chi ra: ―¿Ñáá cha nyacuvi ndo? ¿Ñáá tuhun cha ndachí ndo burru chiña? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tyicuan ta canacaha̱n ra tari cuhva cha catyi̱ ra Jesús chi ra. Ta cachaha̱ ra cuhun coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tyicuan ta caquehe̱n ra burru cuan ta chinyaca̱ ra chi ra Jesús. Ta catyiso̱ ra sahma ra sɨquɨ tɨ, ta ndaa̱ ra Jesús chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta cuaha ñu ndɨca ñu sahma ñu ityi cuahan ra, ta inga ñu chahnu̱ ñu soco numa ta cachacu̱n ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tyicuan ta ñu cha cuahan ityi nuu ra ta ñu cha cuahan ityi chata, quichaha̱ cana chaa ñu ta catyí ñu: ―¡Cahnu xaan cuví Nyoo! ¡Na sacahnu yo chi ra vachi cuenda Sutu yo Nyoo! ");
INSERT INTO mxtNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Sa̱cahnu yo chi ra vachi nyacá ñaha tari chinyaca̱ ñaha sutu chahnu yo ra David! ¡Cahnu xaan ca cuví ra nyaá andɨvɨ! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tyicuan ta quɨhvɨ̱ ra Jesús chichi ñuu Jerusalén, ta cuahan ra vehe ñuhu cahnu. Ta cha yaha̱ nanyehe̱ ra ityi cuan ityi ihya, ndaca̱ chata ra ñuu Betania chihin ndɨ uchi uvi ra chicá noo chihin ra vatyi cha iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cha inga quɨvɨ quita̱ coyo ra ñuu Betania cuan, ta cha nɨ ri ca cha cuahan ra chicá ityi ra chaa̱ noo soco chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta nyasava ri nanyehe̱ ra noo tu higo cha nyaá numa. Ta chaha̱n ra chinyehe̱ ra tatu iñi chɨtɨ nuu tun, soco maa maa ri numa ri iñi, vatyi ta chaa ca quɨvɨ quita chɨtɨ tun. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tyicuan ta caha̱n ra Jesús chihin tun, ta catyí ra chi tun tyehe caa: ―Ma coo ca chɨtɨ cachi ñáyɨvɨ nuun ―catyí ra chi tun. Ta ra cachicá noo chihin ra cachiñí ra cha cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yaha̱ cuan ta nachaa̱ coyo ra Jerusalén. Ta quɨhvɨ̱ tucu ra Jesús chichi vehe ñuhu cahnu. Ta quichaha̱ tava ñehe ra chi ra caxicó ta ra casatá yucuan. Sanduva̱ ra mesa ñu canasamá xuhun chi ñáyɨvɨ. Ta suri tyicuan caa sacuvi̱ ra chihin tyayu ra caxicó paloma. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta ña chaha̱ ca ra ca cuiso ñu ñáá cha cuiso ñu ityi chichi vehe ñuhu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta quichaha sañaha̱ ra chi ñu, ta catyí ra: ―Nu tutu Nyoo catyí chi: “Vehi, vehe nu chicán tahvi tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ cuví”, catyí Nyoo. ¡Soco nyoho nasahá ndo vehe nu nyicú ra suhu! ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ta ra cacuví nuu chi tata sutu ta ra casacuahá cuenda ley vehe ñuhu cachiñi̱ ra cha cahán ra, ta quichaha̱ canducu ra cuhva cha cacahñi ra chi ra vatyi cayuhví ra chi ra tyi cha tandɨhɨ ñáyɨvɨ iyo cuñí ñu cha sañahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Soco cuhva cha cua cuaa ra Jesús quita̱ ri ra ñuu cuan chihin ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cha ñaha ri cha inga quɨvɨ cuan, nayaha̱ coyo ra nu nanyaá tu higo cuan. Ta cananyehe̱ ra vatyi na ityi nyacua nya yoho tun. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tyicuan ta nɨcoho̱n iñi ra Pedro vatyi soco̱ ra Jesús chi tun ta catyí ra chi ra Jesús: ―Maestro, nye̱he tu higo cha soco̱n, cha na ityi tun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nacaha̱n ra Jesús, ta catyí ra: ―Chi̱no iñi ndo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Vatyi cha ndicha catyí chi ndo vatyi nya nyoho catyi ndo chi yucu ihya, “Na canyaha ta cuhun nu tyañuhu”, ta tatu ña chicá uvi iñi ndo, ta chinó iñi ndo, tuhun cahan ndo cua cuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yucuan chaha catyí chi ndo vatyi tandɨhɨ cha chicán tahvi ndo, ta tatu chinó iñi ndo tyi cha naquehe̱n ndo, tyicuan caa cucuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta tatu chicán tahvi ndo chi Nyoo ta cuxaán ndo chi inga ñu, sa̱ha ndo tɨcahnu iñi chi ñu, tacuhva vatyi Sutu ndo, ra nyaá andɨvɨ, saha tucu maa ra tɨcahnu iñi cuatyi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Soco tatu ña sahá ndo tɨcahnu iñi chi ñu, nɨ ri Sutu ndo, ra nyaá andɨvɨ, ma saha ra tɨcahnu iñi cuatyi maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tyicuan ta nachaa̱ coyo ra Jerusalén. Ta cha nɨri ca cha chicá noo ra Jesús chichi vehe ñuhu cahnu cuan, catuhva̱ ra cacuví nuu chi tata sutu, ta ra sacuahá cuenda ley, ta ra cacuví mandoñi nu nyaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ta candaca̱ tuhun ra chi ra. ―¿Yóó cha tyaa̱ tyiño chuun vatyi sacuvun tyehe caa? ¿Yóó cha chaha̱ ityi chuun vatyi sacuvun? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Ta nacahan ra Jesús, ta catyí ra: ―Cua ndaca tuhun tucu yuhu noo tuhun chi ndo. ¿Yóó cha tachi̱ chi ra Juan vatyi sacondutya ra chi ñáyɨvɨ? ¿Atu Nyoo tachi̱ chi ra, o ñáyɨvɨ? Tatu catyi ndo chii, tyicuan ta cua catyi tucu yuhu chi ndo yóó cha tyatyiño̱ ihya chii ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tyicuan ta quichaha cacuvi yuhu maa ra chihin tahan ra ta cacatyí ra: ―Tatu catyi yo tyi Nyoo tachi̱ chi ra Juan, cucatyi ra chi yo: “Tu tyicuan caa, ¿ñáá tuhun ña chino̱ iñi ndo chi ra?” ");
INSERT INTO mxtNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ta yoso caa catyi yo tyi ñáyɨvɨ tachi̱ chi ra? Ma cuvi ―cacatyí ra, vatyi cayuhví ra chi ñáyɨvɨ, vatyi tandɨhɨ ñu cachinó iñi ñu vatyi cha ndicha cuenda Nyoo caha̱n ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tyicuan ta quichaha cacatyí ra chi ra Jesús: ―Ña chitó ndi. Tyicuan ta ra Jesús catyí ra chi ra: ―Ni yuhu ma catyi chi ndo yóó cha tyaa̱ tyiño chii tyi sacuvi cha sacuví ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tyicuan ta chihin cuhva ihya quichaha cahan ra Jesús chihin ra, ta catyí ra chi ra: ―Chiyo̱ noo ra cha tachi̱ ra yoho tɨchaha ndɨvɨ. Ta chasɨ̱ ra chaha. Ta savaha̱ ra noo nu cuhñi ra tɨchaha ndɨvɨ. Ta savaha̱ ra noo vehe sucun tacuhva vatyi cuví saha ra cuenda tandɨhɨ. ’Yaha̱ cuan ta chaha̱ noo ra ñuhú cuan chi suhva ra casahá tyiño. Ta cuahan ra inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta cha chaa̱ quɨvɨ iyó chɨtɨ yoho cuan, chitoho ñuhú cuan tachi̱ ra noo musu nu nyicú ra casahá tyiño cuan vatyi cacan ra suhva chɨtɨ cha tahán chi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Soco catɨɨ̱n ra chi ra. Ta cacañi̱ ra chi ra. Ta canatachi̱ ra chi ra chihin nu ndaha nu ndɨɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tyicuan ta chitoho ñuhú cuan tachi̱ ra chi inga musu, soco chi ra ihya catuchi̱ ra yuu chi ra, catahvi̱ ra xiñi ra, ta cacahan uhvi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta inga tucu musu tachi̱ chitoho ñuhú cuan. Ta chi ra cuan cachahñi̱ ra. Yaha̱ cuan ta tachi̱ ra cuaha ca ra. Soco cacañi̱ ra chi suhva ra. Ta chi suhva ca ra cachahñi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ta ndoo noo ri ca ra cha cuví tachi chitoho ñuhú cuan. Ican cuví sehe ra cha cuñí xaan ra. Ta nu ndɨhɨ tachi̱ ra chi sehe ra vatyi cuñí maa ra chicá xiñi ra: “Cucasaha ra ñáyɨvɨ chi sehi”, cuñí ra chicá xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Soco nu chaa̱ sehe ra, ra casahá tyiño cuan catyi̱ ra chi tahan ra: “Ican ra ihya cundoo chihin tandɨhɨ ihya. Na cahñi yo chi ra, ta ndoo maa yo chihin”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta tyicuan caa catɨɨ̱n ra chi ra ta cachahñi̱ ra chi ra. Tyicuan ta cachituchi̱ ra coño ñuhu ra ityi chata chacu cuan ―tyicuan caa cuhva cahan ra Jesús chihin ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tyicuan ta ndaca̱ tuhun ra Jesús chi ra ta catyí ra: ―¿Ñáá cha cusacuvi ra cuví chitoho ñuhú cuan? Cuquichi ra ta cucahñi ra chi ra casahá tyiño cuan. Ta cuhva ra ñuhú cuan chi inga ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Atu ta sacuaha ca nyoho nu tutu Nyoo nu catyí chi tyehe caa? Yuu cha ña cacuñi̱ ra casavaha vehe cotyiño ra, ican cuan cuví yuu cha nɨñɨ ca. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ican ihya cuví cha sacuvi̱ Sutu yo Nyoo. Ta tyaquɨ xaan tuhun cha cuenda chi yo, catyí chi nu tutu Nyoo ―catyí ra Jesús chi ra cacuví nuu chi tata sutu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tyicuan ta canducu ra cuhva cha tyihi ra chi ra Jesús vehe caa vatyi cachitó ra vatyi caha̱n ra cuhva ihya soco cha cuenda maa ra. Soco vatyi cayuhví ra chi ñáyɨvɨ, casandoo̱ ra chi ra, ta cuahan coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tyicuan ta catachi̱ ra suhva ra cuenda ra Herodes ta suhva ra fariseo nu nyaá ra Jesús vatyi casacahan ra chi ra ta coo cuatyi catyaa ra sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaa̱ coyo ra ihya ta quichaha catyí ra chi ra Jesús: ―Maestro, chitó ndi vatyi cahún cha ndicha, ta ña quichahún cha cahán ñáyɨvɨ, ta ña natɨɨ́n cuendon cuhva caa ri ñu. Ta ndicha sañahún ityi Nyoo. Yucuan chaha cuñí ndi coto ndi, ¿atu vaha cha tyiyahvi yo cha chicán gobiernu ñuu Roma chi yo, o ña vaha? ¿Atu tahán chi cha tyiyahvi yo, o ña tahán chi? ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Soco ra Jesús chitó ra vatyi ñima cha vaha chicá xiñi ra, ta catyí ra chi ra: ―¿Ñáá tuhun cha cuñí ndo sandavi ñaha ndo chii? Nya̱ca ndo noo xuhun chii, na nyehi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Caquichi̱ nyaca ra chi ra. Ta cuhva cha nanyehe̱ ra ta ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Yóó chi nuu ihya, ta yóó chi sɨvɨ nyaá ihya? ―catyí ra chi ra. Ta canacaha̱n ra ta cacatyí ra: ―Chi gobiernu. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tyicuan ta catyí ra Jesús chi ra: ―Cu̱hva ndo chi gobiernu cha tahán chi chi ra. Ta cu̱hva tucu ndo chi Nyoo cha tahán chi Nyoo ―catyí ra Jesús chi ra. Ta iyo cacuñí ra tuhun cha nacaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tyicuan ta cuahan coyo suhva ra saduceo nu nyaá ra Jesús. Ican ra saduceo ihya catyí ra vatyi ña nandotó ndɨyɨ. Yucuan chaha cacaha̱n ra tyehe caa ta catyí ra chi ra Jesús: ");
INSERT INTO mxtNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, tyaa̱ ra Moisés tuhun yoso caa tahán chi sacuvi yo tatu noo rayɨɨ ta chihi̱ ra ta ndoo̱ ñasɨhɨ ra soco ña chicoo̱ sehe ra chihin ña. Catyí ra vatyi tahán chi tandaha yañi ra chihin ñaha cha chihi̱ yɨɨ cuan, tacuhva vatyi coo sehe ña cha cuenda ndɨ yañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Noo chaha chiyo̱ ucha tahan ra chihin yañi ra. Ra cha xihna ri tandaha̱ ra chihin noo ña, ta yori sehe ra chicoo̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ta ra cu uvi tandaha ra chihin ñaha cha ndoo̱ cuan. Ta suri chihi̱ ra. Ta suri yori sehe ra chicoo̱. Ta tyicuan caa tucu cuvi̱ chihin ra cu uñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta tyicuan caa ndɨ ucha tahan ra tandaha̱ chihin ña. Ta ni noo ra ña cachiyo̱ sehe ra chihin ña. Ta nu ndɨhɨ tuhun, chihi̱ ndɨhɨ maa ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta vityin, quɨvɨ cunandoto ñáyɨvɨ, ¿nya ra cucuvi yɨɨ ña? Vatyi ndɨ ucha tahan ra cuan chiyo̱ chihin ña ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi ra: ―Nyoho cahán tondo ri maa ndo, vatyi ña chitó ndo cha nyaá nu tutu tuhun Nyoo. Ta ni ña chitó ndo yoso caa tunyee iñi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vatyi quɨvɨ cunandoto ndɨyɨ, ni ma tandaha ñu ta ni ma cuhva ñu sehe ñu tandaha, vatyi tari ángel cha nyaá andɨvɨ tyicuan caa cucuvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta tuhun cha nandotó ndɨyɨ cuan, ¿atu ta sacuaha ca ndo nu libru ra Moisés yoso caa caha̱n Nyoo chihin ra nu cayú taca iñu cuan? Ta tyehe caa catyi̱ ra chi ra: “Yuhu cuví Nyoo cuenda ra Abraham, ta cuenda ra Isaac, ta cuenda ra Jacob”, catyí Nyoo chi ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ta cha catyí Nyoo tyicuan caa cuñí chi catyi vatyi vasɨ cha naha cachihi̱ ra, soco canyitó añima ra vatyi Nyoo ñima Nyoo cuenda ñu ndɨyɨ cuví ra, soco Nyoo cuenda ñu nyitó cuvi ra. Yucuan chaha catyí vatyi nyoho cahán tondo ri ndo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chaa̱ tucu noo ra sacuahá cuenda ley vehe ñuhu cuan, ta chiñi̱ ra cacuví yuhu ra. Ta vatyi chitó ra vatyi ra Jesús vaha nacaha̱n ra nu cacahan ra yucuan, ta ndaca̱ tuhun ra chi ra ta catyí ra: ―Chichi cha tandɨhɨ ley, ¿nya cha nɨñɨ ca sacuvi yo? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta nacaha̱n ra Jesús ta catyí ra: ―Cha xihna ca sacuví yo cha nuu tandɨhɨ, ican cuví ihya: “Cuɨ̱ñɨ ndo ñu Israel. Sutu yo Nyoo, noo ri maa ra iyó. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cu̱ñun chi Sutu yo Nyoo chihin cha nɨɨ iñun ta chihin cha tandɨhɨ añimon, ta chihin cha tandɨhɨ cha chiñi tuñi xiñun, ta chihin cha tandɨhɨ tunyee iñun.” Ican ihya cuví cha xihna ca cha tahán chi sacuvi yo. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ta cha cu uvi catyí chi: “Cu̱ñun chi tahun tari cuñún chi maun.” Ñahri ca tuhun cha nɨñɨ ca ican saha nduvi tahan ihya ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tyicuan ta ra sacuahá cuenda ley cuan catyí ra chi ra: ―Vaha xaan nacahu̱n, Maestro. Ndicha cha catyún vatyi noo ri Nyoo iyó, ta yori ca Nyoo iyó, noo tuhun ri maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ta cha cuñí yo chi Nyoo chihin cha nɨɨ iñi yo ta chihin cha tandɨhɨ cha chiñi tuñi xiñi yo, ta chihin cha tandɨhɨ añima yo, ta chihin cha tandɨhɨ fuerza yo, ta cu̱ñi yo chi tahan yo tari cha cuñí yo chi maa yo, vale ca cuan ta ñima ca tandɨhɨ quɨtɨ cha chahá yo chi Nyoo cha chahñi̱ yo ta chahmi̱ yo ―catyí ra sacuaha cuenda ley cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nyehe̱ ra Jesús vatyi vaha nacaha̱n ra chihin cha cachi xiñi ra. Ta catyí ra chi ra: ―Chiin ri ca cuñí chi ta ñihún cuhva yoso caa nacuhvon añimon chi Nyoo na cunyaca ñaha ra ―catyí ra Jesús chi ra. Ta ni noo ca ñu ña cañá ca iñi ñu candaca tuhun ñu ñáá cha ndaca tuhun ñu chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sañahá ra Jesús chichi vehe ñuhu cahnu, ta catyí ra: ―¿Yoso caa cha cacatyí ra sacuahá cuenda ley vehe ñuhu vatyi ra Cristo vachi ra tata ra David? ");
INSERT INTO mxtNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vatyi suri maa ra David chotyiño̱ Tatyi Ii chi ra ta catyí ra: Caha̱n Suti Nyoo chihin Suti ra Cristo, ta catyí ra: “Cu̱nyaa chiyo vahi nyacua nya cuhve chi ra xaan iñi chuun vatyi cuaca chahun sɨquɨ ra”, catyí Nyoo chihin yuhu ra David ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Yoso caa cha ra vachi tata ra David cuví chi ra Cristo, ta suri maa ra David catyi̱ ra vatyi ra Cristo cuví Sutu ra? ―catyí ra Jesús. Ta cuaha xaan ñáyɨvɨ nyicú yucuan sɨɨ xaan cacuñí ñu chiñí ñu tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nu sañahá ra Jesús ta catyí ra tyehe caa: ―Sa̱ha ndo cuenda chi ndo chihin ra casacuahá cuenda ley vehe ñuhu, vatyi tahán iñi ra cacuihno ra sahma nañi ta chicá noo ra nuyahvi tacuhva saha ndo ñáyɨvɨ chi ra, ta cuhva ndo nocumi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Maa ra cananducú ra nu vaha ca cunyicu ra chichi vehe ñuhu. Ta nu vaha ca cacuñí ra cachi ra nyayu nu iyó vico. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta ican ra catinyaá vehe ñu chihi̱ yɨɨ, vatyi ña cuví tyiyahvi ñu ñáá xuhun tava ra sɨquɨ ñu. Ta cuñí ra sacuvaha ra chi ra nuu ñáyɨvɨ. Yucuan chaha naha chicán tahvi ra nu tuvi. Maa ra cuví cha cutachi tuñi ca Nyoo chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Noo chaha nyaá ra Jesús chichi vehe ñuhu cahnu yatyin ri nu nyaá chatun nu cumí ñu xuhun cha chaha̱ ñáyɨvɨ chi Nyoo. Ta nyehe̱ ra yoso caa tyihí ñáyɨvɨ xuhun yucuan. Ta cuaha ñu tyayɨɨ chahá ñu cuaha xaan xuhun. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tyicuan ta chaa̱ tucu noo ñaha ndahvi chihi̱ yɨɨ, ta tyihi̱ ña uvi tahan xuhun cuatyi cha caha xaan nyaá. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tyicuan ta cana̱ ra Jesús chi ra cachicá noo chihin ra, ta catyí ra chi ra: ―Cha ndicha catyí chi ndo vatyi ñaha ndahvi chihi̱ yɨɨ ihya, cuaha ca chaha̱ ña ta ñima ca inga ñu catyihí xuhun chiña. ");
INSERT INTO mxtNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vatyi tandɨhɨ ñu cachaha̱ ñu cha ndoo ri ca chi ñu. Soco maa ña chihin cha ndahvi ña chaha̱ ña tandɨhɨ cha cumí ña ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuhva cha cua quita ra Jesús chichi vehe ñuhu cahnu cuan, noo ra chicá noo chihin ra catyi ra chi ra: ―¡Maestro, nye̱he ñana cha tyaquɨ yuu yɨhɨ́ vehe ihya! ¡Ñana cha nahnu vehe ihya! ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Soco nacaha̱n ra Jesús, ta catyí ra chi ra: ―¿Atu nyehún vehe nahnu ihya? Soco catyí chuun vatyi ma ndoo ni noo yuu coso sɨquɨ tahan, vatyi tandɨhɨ cutanɨ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tyicuan ta cuahan coyo ra nya yucu yutun Olivo cha nyaá inga chiyo xahva ityi nuu vehe ñuhu cahnu. Ta cuhva cha nyaá ra Jesús yucuan, ra Pedro, ra Jacobo, ra Juan, ta ra Andrés candaca tuhun xehe ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Cuñí ndi cha ca̱tyun chi ndi ama cucuvi tandɨhɨ tuhun cha cahu̱n tuhun. ¿Ñáá seña cucuvi tatu cha cua cuvi? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nacaha̱n ra Jesús ta catyí ra: ―Sa̱ha ndo cuenda chi ndo tacuhva yori sandavi ñaha chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vatyi cuaha xaan ra cuquichi coyo ra, ta cucotyiño ra sɨvi ta cucatyi ra: “Yuhu cuví ra Cristo.” Ta cusandavi ñaha ra chi cuaha xaan ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Soco tatu chiñí ndo tuhun tyi iyó cuatyi ta cañí tahan ñáyɨvɨ, ma nayuhvi ndo. Vatyi tyicuan caa tahán chi cucuvi, soco ta chaa ca quɨvɨ cunaa ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vatyi noo ñuu cucañi tahan chi chihin inga ñuu, ta ñáyɨvɨ cuenda noo gobiernu cucañi tahan ñu chihin ñáyɨvɨ cuenda inga gobiernu. Ta cucoo cha taan nahnu cuaha ri ityi. Ta cucoo tama. Ta cunaquɨquɨ ñáyɨvɨ. Ta tyehe caa cua quichaha cha nyehe ñáyɨvɨ tɨndoho. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Soco sa̱ha ndo cuenda chi ndo. Vatyi cucuhva cuenda ñu chi ndo chi ra cacuví tyiño. Ta cucañi ñu chi ndo chichi vehe ñuhu. Cucuhva cuenda ñu chi ndo nuu gobernador ta nuu rey cha cuenda yuhu. Ta tyicuan caa cuví cahan ndo tuhin nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vatyi cha ni cumañi ca naa ñayɨvɨ̱, cuñí chi cucutya tuhun Nyoo yoso caa sacacú ra añima ñáyɨvɨ tandɨhɨ ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ta cuhva cha cunyaca ñu chi ndo nuu ra cacuví tyiño, ma caca xiñi ndo ñáá tuhun cucahan ndo, ni ma ndichi xiñi ndo. Ca̱han ndo cha catyi Nyoo chi ndo cha cahan ndo cuhva cuan. Vatyi ñima nyoho cucahan, soco maa Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yɨhɨ́ ra cunacuhva cuenda ra nyacua nya chi yañi maa maa ra. Ta sacuvi ra na cacahñi ñu chi ra. Ta yɨhɨ́ ñáyɨvɨ cunacuhva cuenda ñu chi sehe ñu. Ta yɨhɨ́ ñu cunaquɨquɨ ñu sɨquɨ sutu ñu ta sɨhɨ ñu. Ta cunacuhva cuenda ñu chi ñu na cahñi ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tandɨhɨ ñáyɨvɨ cutasɨ cuñi nyehe ñu chi ndo cha cuenda yuhu. Soco tatu cunyee iñi ndo nyacua nya nu ndɨhɨ, cucacu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ra Daniel, ra profeta Nyoo ta cha naha, tyaa̱ ra yoso caa cuahan tuhun noo cha cusacaquiñi nu ii xaan. Ta cusatɨvɨ chi tandɨhɨ. Tatu nyehé ndo nanyaá yucuan nu ña tahán chi cuinanyaa, (nyoho cha sacuahá ndo ihya na cutuñi iñi ndo) cuñí chi cha cono tandɨhɨ ñu iyó Judea nya ityi yucu. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta ñu ñohó xiñi vehe quɨvɨ cuan, noo ñu, soco ma quɨhvɨ ñu chichi vehe ñu tava ñu ñáá cha tava ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ta ñu ñohó nu chiqui, ma cunuhu ñu nya vehe ñu cha cunaquehen ñu sahma ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ndahvi ñusɨhɨ cha cañohó sehe quɨvɨ cuan! ¡Ndahvi tucu cuvi ñusɨhɨ cha chaxín sehe quɨvɨ cuan! ");
INSERT INTO mxtNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ca̱can ndo chi Nyoo tacuhva cha ma tahan chi caca cono ndo quɨvɨ vichin. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vatyi quɨvɨ tɨndoho cucuvi. Ta ni noo chaha ta cuvi ca tyicuan caa nyata quɨvɨ chino̱ ñuhu ñayɨvɨ̱ nyacua nya vityin. Ta ni ma coo ca tɨndoho tahán ihya nu cuahan ca chi. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tyehe ta ma sanducuɨtɨ Sutu Mañi yo tyembu cuan, yori maa cucacu. Soco cusanducuɨtɨ ra cha cuenda cha cuñí ra chi ñu cuenda ra, ñu cha nacachi̱ maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tatu yóó cha catyí chi ndo: “Nye̱he ndo, ma ra Cristo ihya” o “Nye̱he, ma ra nyaá yucuan”, ma chino iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vatyi cuquichi ra casandaví ñaha, cucatyi ra tyi ra Cristo cuví ra. Ta yɨhɨ́ ra cucatyi ra vatyi profeta Nyoo cacuví ra. Ta cucasavaha ra seña, milagru, vatyi canducú ra cuhva sandavi ñaha ra nyacua nya chi ñu cha nacachi̱ maa Nyoo tatu cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Soco sa̱ha vaha ndo cuenda vatyi yuhu cha sacote̱ chi ndo cha ni cumañi ca cuvi tyicuan caa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ta catyí tucu ra Jesús tyehe caa: ―Soco quɨvɨ cha yaha tɨndoho, cunduñaa ñanyii. Ma cundichin ca yoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tiñoo cunacoyo andɨvɨ. Ta nyacua nya tandɨhɨ cha iyó andɨvɨ ta cunacanda. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tyicuan ta cunyehe ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria inga chaha, vachi nu vico chihin cha ndicha ñuhu Nyoo, ta chihin cha cahnu cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tyicuan ta cutachi chi ángel ta cusandu ɨɨn ri chi ñu nacachi̱ nɨcahnu sɨquɨ ñuhu ñayɨvɨ̱, nyacua nya nu ndɨhɨ ñuhu ñayɨvɨ̱ ta nyacua nya nu ndɨhɨ andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Cu̱tuñi iñi ndo cuhva tu higo ihya: Tatu nduyutya soco tun ta caña numa tun cha chitó ndo vatyi cha cuñí chaa quɨvɨ coo chɨtɨ, cha vachi vico savi. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta suri tyicuan caa tatu cha nyehe ndo tuhun ihya, co̱to ndo tyi cha nyañaa yatyin quɨvɨ quichi tiqui. Cha nyañai yuvehe cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cha ndicha catyí chi ndo vatyi tandɨhɨ ihya cucuvi cha nɨ ri ca cha iyó ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tyicuan ta cunaa andɨvɨ ta ñuhu ñayɨvɨ̱ cha iyó cha vityin. Soco tuhun cahín tyicuan ri cucuvi tari cuhva catyí. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Soco yori chitó ñáá quɨvɨ ta ñáá cuhva cucuvi tandɨhɨ ihya, ni ángel Nyoo, ni yuhu Sehe Nyoo. Noo tuhun ri maa Nyoo Suti cuví ra chitó. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Yucuan chaha co̱nyito vaha ndo, ta sa̱ha ndo cuenda ta ca̱can tahvi ndo, vatyi ña chitó ndo ñáá quɨvɨ cuchaa cuhva. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tari noo ra cha cua cuhun nu cañi. Ta cha ni cumañi ca cuhun ra, chaha̱ cuenda ra vehe ra chi musu ra. Ta chaha̱ ra tyiño chi noo noo ra. Ta tachi̱ ra chi ra sahá cumi yuvehe cuan na saha ra cuenda. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yucuan chaha nyoho co̱nyito ndo vatyi ña chitó ndo ñáá cuhva cuquichi ra cha cuví tari chitoho vehe cuan, an cha ni cua cuaa, an ñuu, an cuhva cha chacú chaa loho, an cha ñaha ri. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Co̱nyito ndo coto sana iñi ndo ta quichi ra, ta nañihi ra chi ndo quixí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cha catyi̱ chi nyoho, catyí tiqui chi tandɨhɨ ñáyɨvɨ ñandɨhɨ. Na conyito ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uvi ca quɨvɨ cumañi ta cua tahan chi vico cha nañí pascua ta vico cha tuhva ñu chachí ñu pan cha ñahri yuchan iya yɨhɨ́. Ta ra cacuví nuu chi tata sutu ta ra casacuahá cuenda ley vehe ñuhu canducú ra cuhva catɨɨn xehe ra chi ra Jesús ta cacahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Soco cacatyí ra chi ra tahan ra: ―Ma tɨɨn yo chi ra cha chichi vico vityin coto naquɨquɨ ñáyɨvɨ ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ñohó ra Jesús ñuu Betania vehe ra Simón, cha catyí ñu: “Simón ra cha tyahyu coño.” Ta cha nɨ ri ca cha nyaá ra mesa, chaa̱ noo ñaha sɨhɨ ndaha ña noo yutyi cha chino̱ chihin noo yuu cha nañí alabastro. Tyitu yɨhɨ́ chihin ndutya vixi chahán cha nañí nardo. Ta yahvi vavaha nyaá. Ta tahvi̱ ña yutyi cuan ta choso̱ ña ndutya vixi chahán cuan xiñi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Soco suhva ra canyicú yucuan cacuxaan ra ta cacatyí ra chi tahan ra: ―¿Ñáá tuhun satɨvɨ̱ ña ndutya vixi chahán cuan? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tyehe ta quiyahvi̱ cuan, cuenda mil cuñihi yo chihin chi, ta tyinyee chi chi ñu ndahvi ―catyí ra. Ta caha̱n ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Soco ra Jesús catyi̱ ra: ―¡Sa̱ña ndo chi ña! ¿Ñáá tuhun cha sayangá ndo chi ña? Cha choso̱ ña chii tyehe caa, cha vaha cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vatyi ñu ndahvi tyicuan ri cua cunyaa ñu chihin ndo, ta cuví sacuvi maa ndo cha vaha chihin ñu ñáá ri quɨvɨ cuñí ndo. Soco yuhu ñima tyicuan ri cua cunyai chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñaha sɨhɨ ihya sacuvi̱ ña yoso cuhva cha cuvi̱ chi ña. Choso̱ ña ndutya vixi chahán coño ñuhi, cha ni cumañi ca cucúvi ta quɨhvi chichi ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cha ndicha catyí chi ndo, vatyi tandɨhɨ ri nɨcahnu ñuhu ñayɨvɨ̱ nu cahan ñu tuhun Nyoo, cunacatyi tucu ñu tuhun cha sacuvi̱ ñaha ihya, tacuhva nɨcohon iñi ñáyɨvɨ tuhun ña ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yaha̱ cuan ta ra Judas Iscariote, noo ra chichi cha uchi uvi tahan ra cachicá noo chihin ra Jesús, chaha̱n ra chindatuhun ra chihin ra cacuví nuu chi tata sutu, vatyi casandaa ra noo tyiño ta nacuhva cuenda ra chi ra Jesús chichi ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuhva cha cachiñi̱ ra ihya, cusɨɨ xaan cacuñí ra, ta catyí ra vatyi cuhva ra xuhun chi ra. Tyicuan ta quichaha̱ nducu ra Judas cuhva nacuhva cuenda ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cuví chi quɨvɨ quichaha vico cha chachí ñu pan cha ñahri yuchan iya yɨhɨ́. Yucuan quɨvɨ cha vico pascua tuhvá ñu chahñi ñu mbee luhlu cha chahá ñu chi Nyoo. Ta ra cachicá noo chihin ra Jesús candaca̱ tuhun ra chi ra, ta cacatyí ra: ―¿Nya maa maa cuñún cha sanduvaha ndi cha cuxiñun cha vico ihya? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tyicuan ta tachi̱ ra chi uvi tahan ra ta catyí ra chi ra: ―Cua̱han ndo chichi ñuu, ta yucuan cunañihi ndo chi noo ra cha nyisó noo quɨyɨ ndutya. Cua̱han ndo chata ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ta nu quɨhvɨ ra, ca̱tyi ndo chi ra cuví chitoho vehe yucuan tyehe caa: “Ra Sacuaha cuñí ra coto ra nya nyaá cuartu nu cusanducahnu ra vico chihin ra cachicá noo chihin ra”, ca̱tyi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta maa ra cusañaha ra noo cuarto cahnu nu piso sucun chi ndo. Cha yaha̱ nduvii, ta yucuan cusanduvaha ndo cha cuxiñi yo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Cuahan coyo ra. Ta chaa̱ coyo ra chichi ñuu. Canañihi̱ ra tari cuhva catyi̱ ra Jesús chi ra, ta casanduvaha̱ ra cha cuxiñi ra cha vico pascua cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta cha cuaa cuan chaa̱ ra Jesús chihin ndɨ uchi uvi ra chicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ta cuhva cha canyicú ra nu mesa cachachí ra, ra Jesús catyí ra: ―Cha ndicha catyí chi ndo vatyi noo nyoho cha chachí ndo chihin cunaxico tuhun ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tyicuan ta canducuihya̱ iñi ra ta quichaha candaca̱ tuhun tahan tahan ri ra chi ra, ta cacatyí ra: ―¿Atu yuhu? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ta nacaha̱n ra Jesús ta catyí ra: ―Noo ra chichi cha uchi uvi ndo. Ra cha satyii pan ɨɨn ri nu coho chihin, ican ra cuan cuví. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria cucuvi chii tari cuhva catyí nu tutu tuhun Nyoo. Soco ¡ndahvi ra ndahvi ra naxicó tuhun chii! Vaha taxin ca cha cuenda ra, tyehe ta ña cacu̱ ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cha nɨ ri ca cha cachachí ra, ra Jesús quehen ra pan ta nacuhva̱ ra tyahvi nyoo chi Nyoo. Ta tahvi̱ ra ta chaha̱ ra chi tandɨhɨ ca ra, ta catyí ra: ―Que̱hen ndo. Ican ihya cuví coñe ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yaha̱ cuan ta quehe̱n ra vaso vinu. Ta cha yaha̱ cha nacuhva̱ ra tyahvi nyoo chi Nyoo, chaha̱ ra chi ra. Ta tandɨhɨ ra cachihi̱ ra cha ñohó chichi vaso cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta catyí ra chi ra: ―Vinu cha yɨhɨ́ chichi vasu ihya tari nɨñi cuví. Ta chihin nɨñi tyihí tahan Nyoo tuhun chaa chihin ndo vatyi cucatɨ cha cuenda cha vaha chi cuaha ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cha ndicha catyí chi ndo vatyi ma coho que vinu nyacua nya quɨvɨ nachai nu nyacá ñaha Nyoo ta cohi vinu chaa ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cha yaha̱ cha cachita̱ ra yaa, ta caquita̱ ra cuahan coyo ra nya yucu yutun Olivo. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tyicuan ta catyí ra chi tandɨhɨ ra: ―Tandɨhɨ nyoho cusandoo notuhun maa ndo chii vityin cha cuaa. Vatyi catyí chi nu tutu tuhun Nyoo tyehe caa: “Cucahñi chi ra sahá cumi mbee, ta mbee cacacono tɨ ityi cuan ityi ihya”, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Soco cha yaha cha nandote, xihna que cuhun ityi Galilea ican saha nyoho ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tyicuan ta quichaha catyí ra Pedro chi ra: ―Vasɨ tandɨhɨ ra sandoo ra chuun, soco yuhu ma sandoi chuun ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Soco ra Jesús catyí ra chi ra: ―Cha ndicha catyí chuun, vatyi suri maa cha cuaa ihya, cha ni cumañi ca cuacu loho uvi chaha, yoho cucatyun tyi ña ñohó nuun chii uñi chaha ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Soco sanɨñɨ̱ ra Pedro ta catyí ra: ―Vasɨ cúvi chuhun, soco ma tixehi cha ñohó nui chuun ―catyí ra Pedro. Ta tandɨhɨ ra cacatyí ra tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tyicuan ta cachaa̱ coyo ra noo nu nañí Getsemaní. Ta ra Jesús catyí ra chi ra cachicá noo chihin ra: ―Cu̱nyicu ndo ihya nɨ ri cuhin cucacan tahvi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta quehe̱n ra chi ra Pedro, ta ra Jacobo ta ra Juan cuahan chihin ra. Ta quichaha̱ chica xaan iñi ra ta cutyoño cuñí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ta catyí ra chi ra: ―Tuví iñi añime noo tucuihya iñi, ta cuñí cahñi chi chii. Ndo̱o nyoho ihya, ta co̱nyito ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tyicuan ta cuahan ra chiin ca ityi nuu ca. Ta chicuiñi̱ chɨtɨ ra nu ñuhú. Ta chica̱n ra chi Nyoo tatu cuvi cha ma nyehe ra tɨndoho cha cua cuvi chi ra cuhva cuan, catyí ra chicán tahvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ta nu chicán tahvi ra, ta catyí ra: ―Sutu Mañi yuhu, cha cuenda yoho ñahri cha ma cuvi chuun. Tu yoho ta cuñún na canyaha tɨndoho ihya chii. Soco ma cuvi tari cuhva cha cuñí mai, soco cuhva cha cuñí maun na cuvi ―catyí ra Jesús chicán tahvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yaha̱ cuan ta nachaa̱ ra nu nyicú ra. Ta nyehe̱ ra tyi caquixí ra. Ta catyí ra chi ra Pedro: ―Yoho Simón, ¿atu quixún? ¿Atu ña cuvi̱ conyiton ni noo hora? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Co̱nyito ndo ta ca̱can tahvi ndo tacuhva cha ma sanacava ra ña vaha chi ndo nu cuatyi. Cha ndicha, cuñí añima ndo sacuvi ndo cha vaha, soco coño ñuhu ndo vita xaan cuñí chi ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tyicuan ta cuahan ra inga chaha. Ta chica̱n tahvi ra suri maa cha chica̱n ra cha xihna ri. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tyicuan ta nachaa̱ tucu ra inga chaha, nyehe̱ ra tyi caquixí ra. Vatyi nɨcunyasɨ maa chitɨ nuu ra chihin cha cacuñí xaan ra cusu ra. Ta ña cachitó ra ñáá cha nacahan ra chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta chaha̱n ra cha cu uñi chaha, ta nachaa̱ ra, ta catyí ra: ―Vityin ndicha cu̱su ndo, nyi̱tatu ndo. Cha iyó vaha ri vityin, cha chaa̱ cuhva cha cucuhva cuenda ra chi yuhu Rayɨɨ cha quichi nya gloria ndaha ra ca iyó cuatyi. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndɨ̱cuita ndo, co̱ho ndo. Cha vachi ra naxicó tuhun chii ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ni cahán ca ra Jesús ta chaa̱ ri ra Judas, noo ra chichi cha uchi uvi tahan ra chicá noo chihin ra. Ta cuaha sɨndaro ta policía vachi coyo chihin ra canyisó ra mityi ta yutun. Vachi coyo ra cuenda ra cacuví nuu chi tata sutu, ta ra casacuaha cuenda ley vehe ñuhu, ta cuenda ra mandoñi. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Cha ni cumañi ca cachaa coyo ra, ra Judas, ra cha naxicó tuhun chi ra, chaha̱ ra noo seña chi ra ta catyi̱ ra: ―Ra cha tyayuhi, ican ra cuan cuví. Tɨ̱ɨn vaha ndo chi ra na cuhun ra chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta cuhva cha chaa̱ ra tuhva̱ ra nu nyaá ra Jesús ta catyí ra chi ra: ―Maestro. Ta tyayuhu̱ ra xɨtɨn ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tyicuan ta catɨɨ̱n ra chi ra Jesús ta cuahan ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Soco noo ra cha nyaá yucuan tava̱ ra mityi ra ta chahnya̱ ra soho musu ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tyicuan ta ra Jesús catyí ra chi ra cachaa̱ coyo cuan: ―¿Atu vachi tɨɨn ndo chii chihin mityi ta chihin yutun, tari cha vatyi cuví yuhu noo ra suhu? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndɨ quɨvɨ chinyai̱ chihin ndo sañahi̱ chichi vehe ñuhu cahnu cuan. Ta ni noo chaha ña tɨɨ̱n ndo chii. Soco cuví chi tyehe caa vityin, tacuhva chino cava tari cuhva catyí nu tutu tuhun Nyoo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tyicuan ta tandɨhɨ ra cachicá noo chihin ra, cachino̱ ra ta casandoo̱ noo tuhun maa ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Soco noo ri ca ra tyivaa nyicón ra chi ra, ndichí ra noo sɨnduhu ta catɨɨ̱n tucu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Soco sandoo̱ ra sɨnduhu cuan ta cuahan vavaha ra vityiaa vityi cañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tyicuan ta cachinyaca̱ ra chi ra Jesús nuu ra cuví nuu chi tata sutu, ta candu ɨɨ̱n ri tandɨhɨ ra chihin ra cacuví mandoñi, ta ra casacuahá cuenda ley vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta ra Pedro cuahan ra chata ra nya sava ri, nyacua nya nuquehe vehe ra cuví nuu chi tata sutu cuan. Ta ndoo̱ ra nyaá ra chihin policía sanasaá ra chi ra yatyin yunuhu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ra cacuví nuu chi tata sutu, ta tandɨhɨ ra cuví tyiño canducu ra ñáá noo cuatyi tyaa ra sɨquɨ ra Jesús, tacuhva cuvi cacahñi ra chi ra soco ña cañihi̱ maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vasɨ cuaha ñáyɨvɨ caha̱n ñu cuendu sɨquɨ ra, soco ña nacachí tahan tuhun cahán ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yɨhɨ́ ñu candɨcuita̱ ñu ta catyaa̱ ri maa ñu cuendu sɨquɨ ra, ta cacatyí ñu: ");
INSERT INTO mxtNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nyuhu chiñi̱ ndi cha caha̱n ra vatyi cusatanɨ ra vehe ñuhu cahnu cha savaha̱ ñáyɨvɨ. Ta chichi cha uñi quɨvɨ cunacananyaa ra inga vehe ñuhu cha ñima ñáyɨvɨ savaha, na ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Soco ni tyicuan caa ña nacachi̱ tahan cha catyi̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tyicuan ta ra cuví nuu chi tata sutu ndɨcuita̱ ra mahñu nu nyicú tandɨhɨ ra yucuan, ta quichaha̱ ndaca tuhun ra chi ra Jesús, ta catyí ra: ―¿Atu ña nacahan maun? ¿Ñáá cha cuví ihya cha cacahán ra sɨcun? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Soco ra Jesús taxi ri nanyaá ra, ta ña nacaha̱n maa ra. Ta ra cuví nuu chi tata sutu cuan ndaca̱ tuhun ra chi ra inga chaha, ta catyí ra: ―¿Atu yoho cuvún Cristo, Sehe Nyoo ra cha iyó cha vaha chi? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ra Jesús catyí ra chi ra: ―Ican, yuhu cuví. Ta nyoho cunyehe ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria, cucunyai chiyo vaha Nyoo ra cha iyó tandɨhɨ tunyee iñi chi. Ta cunyehe ndo chii quɨvɨ quichi nu vico andɨvɨ ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tyicuan ta ra cuví nuu chi tata sutu cuan, chahnya̱ ra sahma ra tari noo seña vatyi ña tahán iñi ra, ta catyí ra: ―¿Ñáá ca cha ndaa cuñí yo? ");
INSERT INTO mxtNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyoho cha chiñi̱ ndo vatyi chicoo̱ cuatyi ra nuu Nyoo chihin tuhun cahán ra. ¿Yoso caa cuñí nyoho? ―catyí ra. Ta tandɨhɨ ra cacatyí ra vatyi tahán chi cúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tyicuan ta suhva ra quichaha̱ tyicu sɨɨ ra chi ra. Ta chasɨ̱ ra nuu ra, ta cañi̱ ra chi ra chihin chiqui ra ta cacatyí ra chi ra: ―¡Nacoto yóó cha cañi̱ chuun! ―cacatyí ra chi ra. Ta policía cacatu ra nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ra Pedro nyaá ra ityi yuvi nuquehe. Tyicuan ta chaa̱ noo ñaha sahá tyiño chihin ra cuví nuu chi tata sutu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta cuhva cha nanyehe̱ ña chi ra Pedro vatyi sanasaá ra chi ra yunuhu cuan, ndoo̱ ña nyehé vavaha ña chi ra, ta catyí ña chi ra: ―Yoho ñandɨhɨ, chica̱ noun chihin ra Jesús ra ñuu Nazaret cuan ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Soco ra Pedro tixehe̱ ra, ta catyí ra: ―Ña ñohó nui chi ra, ña chité ñáá tuhun cahún ―catyí ra chi ña. Tyicuan ta quita̱ ra ityi yuvehe. Tyicuan ta chacu̱ noo loho. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tyicuan ta ñaha cha nyaá tyiño yoo cuan, nanyehe̱ tucu ña chi ra inga chaha ta quichaha̱ catyi ña chi ra canyicú yucuan: ―Noo ra tahan ra cuan cuví ra ihya ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Soco tixehe̱ ra inga chaha. Ta yaha suhva ri ca cuhva ta ra canyicú yucuan cacatyí tucu ra inga chaha chi ra Pedro: ―Cha ndicha vatyi noo ra yucuan cuví yoho, vatyi ra Galilea cuvún, vatyi tari cahán ñu, cahún ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tyicuan ta iyo xaan tyanaha ra Pedro, ta catyí ra: ―¡Chitó vaha Nyoo tyi ña ñohó nui chi ra cha cahán nyoho tuhun! ¡Na cahñi Nyoo chii tatu ña ndicha cha cahín! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta caa cuhva ri cuan chacu̱ ri loho cha cu uvi chaha. Tyicuan ta nɨcoho̱n iñi ra Pedro tuhun cha caha̱n ra Jesús chihin ra: “Cha ni cumañi ca cuacu loho uvi chaha, yoho cucatyun vatyi ña ñohó nuun chi yuhu uñi tahan chaha.” Nɨcoho̱n iñi ra Pedro ta quichaha chacu chaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cuhva cha cundichin candu ɨɨ̱n ri ra cacuví nuu chi tata sutu chihin ra cacuví mandoñi ta chihin ra casacuahá cuenda ley vehe ñuhu ta tandɨhɨ ra cuví tyiño ñu Israel. Ta ra Jesús nuhñí ra, chinacuhva cuenda ra chi ra chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta ndaca̱ tuhun ra Pilato chi ra, ta catyí ra: ―¿Atu rey cuenda ñu Israel cuví yoho? Ta nacaha̱n ra Jesús ta catyí ra: ―Ican, yuhu cuvi. Ndicha cha cahún. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta ra cacuví nuu chi tata sutu cuaha xaan cha catyaa̱ ra sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tyicuan ta quichaha̱ ndaca tuhun tucu ra Pilato inga chaha chi ra, ta catyí ra: ―¿Atu ña nacahan maun? Nye̱he yoso cha cuaha cha tyaá ra sɨcun. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Soco ra Jesús ña nacaha̱n maa ra. Yucuan chaha ña chitó ra Pilato ñáá cha caca xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta vico cuan tuhvá ra Pilato saña ra chi noo ra ñohó vehe caa, noo ra cha cacan maa ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta ñohó noo ra nañí Barrabás vehe caa cuan, ɨɨn ri chihin inga ra cha cachahñi̱ chi ñáyɨvɨ noo nu naquɨquɨ̱ ñáyɨvɨ sɨquɨ gobiernu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta quichi̱ coyo ñáyɨvɨ quichaha̱ chican ñu chi ra Pilato na saña ra chi noo ra tari tuhvá maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ta nacaha̱n ra Pilato, ta catyí ra: ―¿Atu cuñí nyoho cha sañe chi Rey cuenda ñu Israel? ");
INSERT INTO mxtNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tyicuan caa catyi̱ ra vatyi tuví iñi ra vatyi ra cacuví nuu chi tata sutu cuan tasɨ cuñí ra chi ra Jesús tyi cuaha ñáyɨvɨ nyicón chi ra, yucuan chaha nacuhva cuenda ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Soco ra cacuví nuu chi tata sutu cuan catyiyuhu̱ ra chi ñáyɨvɨ na catyi ñu na saña ra chi ra Barrabás. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tyicuan ta ndaca̱ tuhun ra Pilato chi ñu, ta catyí ra: ―¿Ta ñáá cha cuñí ndo sacuvi chihin ra cha catyí nyoho Rey cuenda ñu Israel chi? ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tyicuan ta nacanachaa̱ ñu, ta catyí ñu: ―¡Na cúvi ra nu cruzi! ―catyí ñu, canachaá ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta catyí ra Pilato chi ñu: ―Soco ¿ñáá cha ña vaha sacuvi̱ ra? ―catyí ra. Soco canachaa̱ ca ñu ta catyí ñu: ―¡Na cúvi ra nu cruzi! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tyicuan ta vatyi cuñí ra Pilato cuvaha ra nuu ñu, saña̱ ra chi ra Barrabás. Tyicuan ta tyihi̱ ra tyiño na ndoho ra Jesús, ta cha yaha cuan chaha̱ cuenda ra chi ra vatyi cúvi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tyicuan ta chinyaca̱ sɨndaro chi ra nuquehe vehe tyiño cuan. Ta casandu ɨɨ̱n ri ra tandɨhɨ sɨndaro. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta casacuihno̱ ra noo sahma tyacu nyaa chi ra. Ta caquicu̱ ra noo corona chihin iñu. Ta catyihi̱ ra xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yaha̱ cuan ta quichaha cacana̱ chaa ra sɨquɨ ra chacú nyaa ra chi ra, ta catyí ra: ―¡Nocumi chuun, yoho Rey cuenda ñu Israel! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta cacañi ra xiñi ra chihin noo yutun, ta tyicú sɨɨ ra chi ra. Ta cachicuiñi̱ chɨtɨ ra casaha ra tyi sacahnu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cha yaha̱ cha chacu̱ nyaa ra chi ra tyicuan caa, tinyaa̱ ra sahma nyaa cuan chi ra, ta sandɨhvɨ̱ noo ra sahma maa ra chi ra. Yaha̱ cuan ta cuahan ra chihin ra vatyi cuatyaa ra chi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yahá noo ra ñuu Cirene, nañí ra Simón. Sutu ra Alejandro ta ra Rufo cuví chi ra. Ni cua nachaa ra cha chaha̱n ra nu chiqui. Ta cuhva cha cua yaha ra ityi cuan, casanɨñɨ̱ sɨndaro chi ra na cuiso ra cruzi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta cachinyaca̱ ra chi ra Jesús noo nu nañí Gólgota. Ta cuñí chi catyi: Nu Cuví Yɨquɨ Xiñi Ndɨyɨ. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta cachaha̱ ra vinu nasaca̱ chihin noo tatan cha nañí mirra coho ra. Soco ra Jesús ña chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cha yaha̱ catyaa̱ sɨndaro chi ra nu cruzi, cachaha̱n ra sɨhva chihin sahma ra ta nya ra saha̱ ganaa caquehen ra sahma ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Caa ɨɨn cha ñaha ri catyaa̱ ra chi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta letra cha catyaa̱ ra xiñi cruzi cuan, catyí chi ñáá cuatyi ra. Ta catyí chi tyehe caa: “Ican ra ihya cuví Rey cuenda ñu ñuu Israel.” ");
INSERT INTO mxtNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta chinanyaa̱ ra uvi ca cruzi nu chitacaa̱ ra uvi tahan ra suhu, noo ra chiyo vaha ra, ta inga ra chiyo satyin ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ta tyicuan caa quita̱ chi tari cuhva catyí nu tutu tuhun Nyoo tyehe caa: “Sahá ñu tuhun tyi cuví ra noo ra quiñi iyó.” ");
INSERT INTO mxtNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta ñu yahá coyo chacú nyaa ñu chi ra. Ta quɨsɨ́ xiñi ñu, ta catyí ñu chi ra: ―¡Jaan! ¡Yoho cha catyu̱n tyi cusatanun vehe ñuhu cahnu, ta chichi cha uñi quɨvɨ cunacoñehun inga chaha! ");
INSERT INTO mxtNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Sa̱cacu maun chuun ta no̱o nu cruzi chiña! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta tyicuan caa tucu ra cacuví nuu chi tata sutu ta ra casacuahá cuenda ley vehe ñuhu, cachacú nyaa ra chi ra, ta catyí ra chi tahan ra: ―¡Chi inga ñu sacacu̱ ra, soco ña cuví sacacu ra chi maa ra! ");
INSERT INTO mxtNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na noo ra nu cruzi vityin, na nyehe yo ta chino iñi yo tyi Cristo Rey cuenda ñu Israel cuví ra ―catyí ra. Ta nyacua nya ra tacaá inga cruzi ɨnchiyo ɨnchiyo xiin ra ta cacahán ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cuhva cha cua cu hora, tandɨhɨ ñuhu ñayɨvɨ̱ nduñaa, nyacua nya caa uñi cha cha iñi. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta suri cuhva cuan canachaa̱ ra Jesús chihin tandɨhɨ fuerza ra, ta catyí ra: ―Eloi, Eloi, ¿lama sabactani? ―ta cuñí chi catyí: Nyoo Suti, Nyoo Suti, ¿ñáá tuhun sandoo̱ noo tuhun maun chii? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Suhva ra tayucu yucuan cachiñí ra ta catyí ra: ―¡Xihna! Caná chaa ra chi ra profeta Elías ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tyicuan ta chino̱ noo ra yucuan chiquehe̱n ra noo tari caa xixan ta satyii̱ ra chihin vinu iya. Ta tyaa̱ ra noo nu yutun ta satuhva̱ ra yuhu ra na coho ra, ta catyí ra: ―Cua̱tu ndo. Na nyehe yo tatu quichi ra Elías sanoo ra chi ra ―catyí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tyicuan ta ñihi xaan canachaa̱ ra Jesús, ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta sahma cha tacaá chichi vehe ñuhu cahnu ndata̱ sava maa chi, nya sɨquɨ ta nyacua nya ityi yuvi. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta noo capitán cuenda sɨndaro Roma nanyaá ra yatyin nuu ra Jesús cuan. Cha nyehe̱ ra yoso caa cana̱ chaa ra, ta yoso caa chihi̱ ra, ta catyí ra: ―Cha ndicha ndicha cuii vatyi Sehe Nyoo cuví chi ra ihya ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta nya sava ri tayucú tucu suhva ñusɨhɨ canyehé ñu. Ta mahñu ñu cuan nanyaá cu María ñaha Magdala, ta cu María sɨhɨ ra José ta ra Jacobo ra tyivaa ca. Ta nanyaá tucu cu Salomé. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ican ñusɨhɨ ihya cachinyico̱n chi ra Jesús, ta tyinyeé ñu chi ra quɨvɨ chica̱ noo ra ityi Galilea. Ta sɨɨn ri nyicú cuaha ca ñu cha chaa̱ coyo chihin ra Jerusalén cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cuví chi quɨvɨ cha sanduvaha ñu cha cachi ñu vatyi inga quɨvɨ tuhvá ñu nyitatu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ta cha cuaa cuan chaa̱ ra José ra ñuu Arimatea. Noo ra cuví tyiño. Nyatú tucu maa ra nu cunyaca ñaha Nyoo. Ta ndachan cuñí ra ta quɨhvɨ̱ ra nu nyaá ra Pilato, ta chica̱n ra coño ñuhu ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iyo cuñí ra Pilato cha nacoto̱ ra vatyi cha chihi̱ ra Jesús. Ta cana̱ ra chi capitán vatyi ndaca tuhun ra tatu cha yaha̱ chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta cha catyi̱ capitán vatyi cha yaha̱ chihi̱ ra, ra Pilato chaha̱ ra coño ñuhu ra chi ra José. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tyicuan ta sata̱ ra José noo sɨnduhu cha chino̱ chihin sahma finu cha nañi lino, ta sanoo̱ ra coño ñuhu ra. Ta sɨquɨ̱ noo ra chihin sɨnduhu cuan. Yaha̱ cuan ta chityihi̱ ra chi ra noo chichi ñaña cha cachatya̱ ra chichi noo yuu. Ta chasɨ̱ ra yuhu ñaña cuan chihin noo yuu cahnu. ");
INSERT INTO mxtNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta cu María ñaha Magdala cuan ta cu María sɨhɨ ra José, chaa̱ coyo ñu nyehe ñu nu tyihi̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yaha̱ quɨvɨ nyitatú ñu. Tyicuan ta cu María ñaha Magdala ta cu María sɨhɨ ra Jacobo, ta cu Salomé sata̱ ñu ndutya vixi chahán ta cuahan coyo ñu cua tyihi ñu coño ñuhu ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta timingu cuví, quɨvɨ quichaha vitya, ñaha cuii ri cuhva cha vachi cundichin cuhva cha ni cua caña̱ ñanyii, chaa̱ coyo ñu nu ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta catyí ñu chi tahan ñu: ―¿Yóó cha cusacanyaha yuu yuhu ñaña cuan? ―catyí ñu chi tahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Soco cuhva cha nanyehe̱ ñu, yuu cahnu cha nyasɨ̱ yuhu ñaña cuan cha cuachiyo̱ chi nya sava. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Quɨhvɨ̱ coyo ñu chichi ñaña yucuan. Ta nanyehe̱ ñu chi noo ángel tari caa noo ra tyivaa, nyaá ra chiyo vaha. Ta ñihnó ra sahma cañi ta cuichin. Ta canayuhví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Soco catyí ra chi ñu: ―Ma yuhvi ndo. Nyoho nanducú ndo chi ra Jesús ra ñuu Nazaret, ra cha chihi̱ nu cruzi. Soco cha nandoto̱ ra. Ña ñohó ca ra ihya. Nye̱he ndo nu chacu̱n ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cua̱han ndo cua sacoto ndo chi ra Pedro ta chi inga ra cachica̱ noo chihin ra. Ca̱tyi ndo chi ra vatyi na cuhun coyo ra ityi Galilea vatyi yucuan nyatú ra Jesús chi ra, tari cuhva catyi̱ ra chi ra. Vatyi ra Jesús cha cuahan ra ityi nuu ―tyicuan caa catyí ángel cuan chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tyicuan ta cuahan coyo vavaha ñu, vatyi suri canɨhɨ́ ñu cha cuenda cha yuhví ñu. Ta yori maa chihin cahán ñu tuhun cha cuenda cha yuhví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cuví chi timingu quɨvɨ quichaha vitya cha nandoto̱ ra Jesús. Yaha̱ cuan ta xihna ca nuu cu María ñaha Magdala tuvi̱ ra. Maa ña cuví ñaha cha tava̱ ñehe ra ucha tahan tatyi ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta chaha̱n ña chisacoto ña chi ra cachica̱ noo chihin ra, vatyi canyicú cuihya ra ta cachacú chaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Soco cuhva cha cachiñi̱ ra vatyi iyó ra Jesús ta vatyi nyehe̱ ña chi ra, ña cachino̱ iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cha yaha̱ cuan, ra Jesús tuvi̱ ra nuu uvi tahan ra cha cuahan coyo chica ityi ityi nu chiqui. Soco sɨɨn caa cuhva caá ra cananyehe ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta cuanuhu coyo ra ta sacoto̱ ra chi tandɨhɨ ca ra. Soco suri ña cachino̱ iñi ra cha cacaha̱n ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta cuee ca ta tuvi̱ ra Jesús nuu ndɨ uchi ɨɨn ra cha cachica̱ noo chihin ra, cha nɨ ri ca cha canyicú ra nu mesa. Ta caha̱n ra chi ra cha cuenda cha ña cachinó iñi ra, ta cha cuenda cha candava añima ra vatyi ña cachino̱ iñi ra tuhun caha̱n ñu nyehe̱ tyi nandoto̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta catyí ra chi ra: ―Cua̱han ndo nɨcacahnu ñuhu ñayɨvɨ̱, ta ca̱han ndo chihin tandɨhɨ ñáyɨvɨ, ta ca̱tyi ndo chi ñu yoso caa sacacú Nyoo añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta ñu cha chinó iñi ta condutya ñu, cucacu añima ñu. Soco ñu cha ña chinó iñi cundoo cuatyi ñu sɨquɨ ñu ta cunaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta tandɨhɨ seña ihya cusacuvi ñu cha chinó iñi chii: Chihin sɨvi cutava ñehe ñu tatyi ña vaha. Cucahan ñu inga sahan cha ña chitó ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cutɨɨn ñu coo, ta tatu coho ñu cha yɨhɨ́ venenu, ma saha cuehe chi ñu. Ta sɨɨn ri cutyiso ñu ndaha ñu sɨquɨ ñu cuhví, ta cunduvaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu ndɨhɨ caha̱n Sutu Mañi yo Jesús chihin ra, ta nandaa̱ xica ra andɨvɨ, ta chicunyaa̱ ra chiyo vaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tyicuan ta ra cachica̱ noo chihin ra quita̱ ra ta chaha̱n coyo ra chicaha̱n ra tuhun Nyoo yoso caa sacacú ra añima yo tandɨhɨ ri ityi. Suri maa Sutu Mañi yo tyinyee̱ chi ra vatyi chaha̱ ra cha sacuvi ra cuaha milagru. Ta tyicuan caa nyehé ñáyɨvɨ tyi ndicha tuhun cacahán ra.");
INSERT INTO mxtNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Cha chitón yoho Tata Teófilo, vatyi cha cuaha ñáyɨvɨ nducu̱ ñu cuhva ta tyaa̱ ñu nuu tutu tuhun cha cuvi̱ nu nyicú ndi. Tyaa̱ ñu tari maa cuhva nacatyi̱ ñáyɨvɨ chi yo, ñáyɨvɨ cha nyehe̱ ta cahán tuhun ra Jesús nya quɨvɨ xihna ri. Ta vityin tahán tucu chi chi yuhu tyi sacote tuhun ra chuun. Vatyi cha yaha̱ sacuahi̱ ta nyehe vahi tandɨhɨ nya nu quichaha̱. Ta vityin ñañi ñañi ri cuatyai tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Vatyi coto vahun tyi ndicha cha sacoto̱ ñáyɨvɨ chuun. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Quɨvɨ cha cuví ra Herodes rey nɨcahnu Judea, chiyo̱ noo tata sutu, chinañi̱ ra Zacarías. Ta yɨhɨ̱ ra cuenda ityi tata sutu cha chinañi̱ Abías. Ta ñasɨhɨ ra chinañi̱ ña Elisabet. Ta vachi ñu tata ra Aarón, ra chiyo̱ ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ta ñahri maa cuatyi ñu iyó nuu Nyoo. Vatyi vaha xaan quichahá ñu tuhun cahán Nyoo. Ta yori maa cuví tyaa cuatyi sɨquɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Soco yori maa sehe ñu chicoo̱. Vatyi cu Elisabet, ña cuví coo sehe ña. Ta sɨɨn ri nɨnduvi tahan ñu chahnu xaan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ta noo quɨvɨ taha̱n chi ityi cuenda ra Zacarías cha sacuvi ra tyiño nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tari cuhva costumbre maa tata sutu, nyehe̱ ra nya ra taha̱n chi nyatu chi. Ta taha̱n chi nyatu chi ra Zacarías cha quɨhvɨ ra chichi vehe ñuhu, vatyi cahmi ra cutu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cha nɨ ri ca cha ñohó ra chahmí ra cutu cuan, cuaha xaan ñáyɨvɨ chicán tahvi ñu ityi chata vehe. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yucuan ta tuvi̱ noo ángel cuenda Nyoo nuu ra Zacarías. Ta chicuinanyaa̱ ra chiyo vaha arta nu chahmí ra cutu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ta cha nanyehe̱ ra Zacarías chi ángel cuan, iyo xaan cuñí ra. Ta yuhví xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Soco ángel cuan catyí ra chi ra: ―Zacarías, ma yuhvun. Vatyi Nyoo chiñí ra tuhun cahún. Ta ñasɨhun cu Elisabet cucoo noo sehe ña. Ta Juan cusacunañun chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sɨɨ xaan cucuvi chuun. Ta cuaha xaan ñu, cusɨɨ cuñi quɨvɨ cacu cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Vatyi sehun, cahnu xaan ra cucuví ra nuu Nyoo. Ma coho ra vinu ta ni ndixi. Ta ñihi xaan cuquɨhɨ Tatyi Ii Nyoo chi ra nyata cumañi cacu ra ta tandɨhɨ tyembu cha coo ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta cuaha xaan ñáyɨvɨ Israel cunyicon chi Sutu yo Nyoo cha cuenda ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta cucoo tunyee iñi Nyoo chi ra. Ta cuquɨhɨ xaan Tatyi Ii Nyoo chi ra. Vatyi cucuvi ra tari ra Elías, ra cuvi̱ profeta Nyoo ta cha naha. Ta cusanɨcoo vaha ra chi ñáyɨvɨ chihin sehe ñu. Ta cusañaha ra chi ñáyɨvɨ quiñi iyó na quichaha ñu tuhun cahán Nyoo. Tyicuan caa cusanduvaha ra chi ñáyɨvɨ ta cuatu tuhva ñu chi Nyoo ―catyí ángel chi ra Zacarías. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ta ndaca tuhun ra Zacarías chi ángel, ta catyí ra: ―¿Yoso caa ta cote noo cha ndicha vaha? Vatyi yuhu cha chahnu xain. Ta ñasɨhi cha chahnu xaan ña ñandɨhɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ta ángel cuan quichaha̱ catyi ra: ―Yuhu Gabriel nañí. Ta chiqué tyiño Nyoo. Maa ra tachi̱ chii vatyi cahin nuun ta sacote tuhun vaha ihya chuun. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ta vityin nduñɨhun. Vatyi ña chinó iñun tuhun cahín. Ta ma cuvi cahun nyacua nya chino cava tuhun cahi̱n chuhun ―catyí ángel cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta ñáyɨvɨ cha nyatú chi ra Zacarías ityi chata vehe, iyo xaan cuñí ñu ñáá tuhun cha cucuee xaan ra chichi vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Soco cuhva cha quita̱ ra Zacarías, ña cuví maa cahan ra chihin ñu. Tyicuan ta tuvi̱ iñi ñu vatyi iyó cha nyehe̱ ra chichi vehe ñuhu cuan. Ta quichaha̱ cahan ra chihin ñu chihin seña ri. Vatyi ña cuví cahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta quɨvɨ cha ndɨhɨ̱ tyiño saha ra Zacarías vehe ñuhu cuan, ta cuanuhu ra nya vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ta cha yaha̱ tuhun cuan chicoho̱n sehe ñasɨhɨ ra, cu Elisabet. Ta ña quita̱ maa ña chata vehe cha nɨ ri ca cha ohon yoo. Ta chicá xiñi ña: ");
INSERT INTO mxtNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tyehe caa sacuví Sutu Mañi yuhu chihin, tacuhva ma cahan cuehe ca ñáyɨvɨ chii”, chicá xiñi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nu cu iñu yoo cha ñohó sehe cu Elisabet, tachi̱ Nyoo chi ángel Gabriel ñuu Nazaret ityi Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Vatyi cucahan ra chihin noo ñaha tyivaa cha nañí María. Ta cha nyañaa cha tandaha ña chihin noo ra nañí José. Ta ra José cuan vachi ra tata rey David. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ta tuvi̱ ángel cuan nu nyaá ña. Ta quichaha̱ catyi ra chi ña: ―Nocumi chuun, María. Ñihun tumañi iñi nuu Nyoo. Vatyi maa ra nyaá chuhun. Ta chi yoho nasocó xaan ca Nyoo nuu tandɨhɨ ca ñusɨhɨ ―catyí ángel cuan chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta cuhva cha chiñi̱ ña cha caha̱n ra, iyo xaan cuñi ña tuhun caha̱n ra. Ta ndichí xiñi ña: “¿Ñáá tuhun cha chaha̱ ra ihya nocumi chi yo tyicuan caa?” ndichí xiñi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta catyí ángel cuan: ―Ma yuhvun, María, vatyi ñihún tumañi iñi nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vatyi cuacohon noo sehun. Ta sacunañun Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cahnu xaan ra cuacuvi ra. Ta cunañi ra Sehe Nyoo ra cuvi nuu. Ta Nyoo Sutu Mañi yo cusacuvi ra rey chi ra. Tari cuvi̱ ra David, ra vachi ra tata. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Vatyi cunyaca ñaha ra chi ñáyɨvɨ Israel tandɨhɨ maa tyembu. Ta ma ndɨhɨ maa cha cunyaca ñaha ra ―catyí ángel cuan chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yucuan ta ndaca̱ tuhun cu María chi ángel, ta catyí ña: ―¿Yoso caa cuahan tuhun ihya? Vatyi yuhu, ta coo ca yɨi. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta nacaha̱n ángel ta catyí ra: ―Maa Tatyi Ii Nyoo cuquichi sɨcun. Ta tunyee iñi Nyoo cahnu cuquichi tari noo vico ta casɨ chi sɨcun. Yucuan chaha ra ii cha cucacu cunañi ra Sehe Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tyicuan caa tucu cu Elisabet ñáyɨvɨ chuun. Cucacu noo sehe ña vasɨ cha chahnu ña. Ñaha cha catyí ñáyɨvɨ vatyi ña cuví maa coo sehe. Soco vityin cha ñohó sehe ña. Cha iñu yoo ñohó. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vatyi Nyoo ñahri cha ma cuvi sacuvi ra ―catyí ángel chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ta quichaha catyí cu María: ―Yuhu cuví musu Sutu yo Nyoo. Na sacuvi maa ra yoso cuhva catyún ―catyí ña. Yucuan ta cuahan ángel cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cuví noo quɨvɨ cuan, numi xaan cuahan cu María noo ñuu ityi Judea nu maa ri maa yucu cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta quɨhvɨ̱ ña chichi vehe ra Zacarías. Ta chaha̱ ña nocumi chi cu Elisabet. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cuhva cha chiñi̱ cu Elisabet tuhun caha̱n cu María, natyoño̱ cha lee cha ñohó chichi ña. Ta chitu ña chihin Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ta chaa nacaha̱n ña, ta catyí ña: ―Nyoo sahá ra tumañi iñi chuun cha nuu tandɨhɨ ñusɨhɨ. Ta nasocó ra chi sehun. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ta yóó ñaha cuví yuhu? Vatyi quichi sɨhɨ Sutu Mañi yo quichi̱ nyehe ña nu nyai. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cuhva cha chiñi̱ tuhun cahu̱n, ta natyoño̱ sehi cha ñohó chichi. Vatyi sɨɨ xaan cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ta sɨɨ xaan cuñí añimon vatyi chinó iñun cha cuacuvi tuhun cahán Nyoo chuhun ―catyí cu Elisabet. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta quichaha̱ catyi cu María: ―Sacahní chi Nyoo chihin tandɨhɨ añime. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ta sɨɨ xaan cuví chii vatyi sacacú Nyoo añime. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Vatyi cuví yuhu noo ñaha ndahvi ta Nyoo tɨɨn cuenda ra chii. Ta vityin tandɨhɨ quɨvɨ cucatyi ñáyɨvɨ chii vatyi cahnu xaan tumañi iñi ñihi̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Vatyi Nyoo, cahnu xaan cuví ra. Ta cahnu cha sacuví ra chihin. Ta ii xaan sɨvɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ta tyicuan ri ndahvi cuñí ra chi tandɨhɨ ñáyɨvɨ cha sahá ñáyɨvɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cahnu xaan cha sacuví ra chihin tunyee iñi iyó chi ra. Sanaá ra cuhva chicá xiñi ñu cahnu sahá chi. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sanocueé ra chi ñu sacahnú chii. Ta ra cha ña cahnu sahá chii, sacucahnú ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chahá Nyoo cha vaha chi ñu cuñí coto cha vaha, ñu chitó vatyi chiñuhú Nyoo chi. Soco ñu tyayɨɨ cha cuñí maa tyi ñahri chiñuhu chi, chihin nundaha nu ndɨɨ ñu, sacuhún ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tyinyeé ra chi ñáyɨvɨ Israel cha cuví musu ra. Ta ña naá iñi ra chi ñu. Nyehé ndahvi ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tari cuhva catyí Nyoo chi ra Abraham, sutu yo, ta chi sehe ra, tyicuan caa sacuví Nyoo tyicuan ri maa ―catyí cu María. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ta cu María ndoo̱ ña chihin cu Elisabet uñi yoo. Ta cha yaha̱ uñi yoo cuan ta cuanuhu̱ ña nya vehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ta chaa̱ quɨvɨ cha cuacacu cha lee sehe cu Elisabet. Cacu̱ cue ta rayɨɨ cuví cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ta cha chiñi̱ ñáyɨvɨ cha nyicú yatyin yuvehe ña ta ñáyɨvɨ chi ña cha tyicuan caa, sɨɨ xaan cuví chi ñu. Ta sɨɨ xaan cuñí tucu maa ña. Vatyi vaha xaan cha sacuvi̱ Nyoo chihin ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta nu cu uña quɨvɨ cha cacu̱ cue, chaha̱n ñu chihin cue vehe ñuhu. Vatyi cuhva cuenda ñu chi cue chi Nyoo. Ta saha̱ ñu circuncidar chi cue tari cuhva iyó maa ñu. Chahnya̱ ñu chiin ñɨɨ cue nu cuví cue rayɨɨ. Ta cuñí ñu sacunañi ñu Zacarías chi cue tari sutu cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Soco sɨhɨ cue catyí ña: ―Ma cuvi. Juan, cunañi cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta quichaha catyí ñu: ―¿Ñáá tuhun sacunañún Juan chi cue? Yori ñáyɨvɨ chi ndo cha nañí tyicuan caa ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ta quichaha ndaca tuhun ñu chihin seña ri chi sutu cue. Vatyi coto ñu ñáá sɨvɨ cuñí ra cha cunañi cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ta chica̱n sutu cue noo vitu, ta nuu vitu cuan tyaa̱ ra tyehe caa: “Juan cuví sɨvɨ cue”, tyaa̱ ra. Ta tandɨhɨ maa ñu cuan iyo xaan cuñí ñu tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta nacaha̱n ra Zacarías caa cuhva ri cuan. Ta quichaha̱ sacahnu ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tandɨhɨ maa ñu iyó yatyin ri yuvehe ñu, yuhví xaan ñu tuhun ihya. Ta tandɨhɨ maa ñáyɨvɨ cha iyó yucu ityi Judea cuan nacatyí ñu chi tahan ñu tuhun ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta tandɨhɨ maa ñáyɨvɨ cha chitó tuhun cuan, ndichi̱ xiñi ñu, ta ndaca̱ tuhun ñu chi tahan ñu: ―¿Yóó ra cuví cha lee cuan? ―catyí ñu. Vatyi ndicha, Nyoo nasoco xaan ra chi cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sutu cue, ra Zacarías, tyitú ra chihin Tatyi Ii Nyoo. Tyicuan ta quichaha̱ cahan ra tuhun cha chahá Nyoo chi ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Cahnu xaan ra cuví Sutu Mañi yo Nyoo cuenda yo ñu Israel. Vatyi quichi̱ ra nu nyicú yo, cha cuví yo ñáyɨvɨ chi ra. Ta sacacu̱ ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta chaha̱ ra noo ra cahnu chi yo, cha cusacacu chi yo. Tata ra David ra cha sacuvi̱ tyiño nuu Nyoo vachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tyicuan caa caha̱n Nyoo chihin yuhu ra cacuví profeta cuenda ra ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Vatyi tyicuan caa cusacacu ra chi yo ndaha ra xaan iñi chi yo, ra cha tasɨ cuñí nyehé chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tyicuan caa cundahvi cuñí nyehé ra chi ñáyɨvɨ chi yo ta cha naha. Ta ma sanaa ra iñi ra tuhun caha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ican ihya tuhun caha̱n Nyoo chihin ra Abraham sutu yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Catyí ra vatyi cusacacu ra chi yo ndaha ra xaan iñi chi yo. Vatyi ma yuhvi ca yo sacahnu yo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta maa ra sanducachi ra iyó yo nuu ra. Ta vaha coo yo nuu ra tandɨhɨ quɨvɨ cha cuacoo yo ñayɨvɨ̱ ―catyí ra Zacarías. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta catyí ra Zacarías chi cha lee cuan tyehe caa: ―Ta yoho sehi, profeta Nyoo cahnu cucatyí ñáyɨvɨ chuun. Vatyi cuhun ityi nuu Sutu Mañi yo. ta cucahun tuhun ra chihin ñáyɨvɨ vatyi cha cuñí quichi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta cusacoton chi ñáyɨvɨ vatyi cunasaha Nyoo tucahnu iñi cuatyi ñu. Ta tyicuan caa ta cacu añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vatyi Sutu yo Nyoo cuñí ra chi yo. Ta cundahvi cuñí ra chi yo. Ta saquichí ra noo ra tyinyeé chi yo. Tari noo ñuhu̱ ñanyii cucuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Vatyi chihin cha sañahá ra chi yo sacundichín ra nu nyicú yo nu ñaa iñi cha catyi cuatyi yo. Ta cusañaha ra chi yo yoso caa quɨhvɨ yo ityi vaha ―catyí ra Zacarías. ");
INSERT INTO mxtNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ta cha luhlu cuan cuahan chahnu ra. Nyee cuñí ra chihin Tatyi Ii Nyoo. Ta chicoo̱ ra noo chiqui ndɨɨ nyacua nya quɨvɨ cha chicoho̱n nuu ñáyɨvɨ Israel chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta quɨvɨ cuan iyó noo ra nyacá ñaha, nañí ra Augusto. Tachi̱ ra tyiño natyaa ra sɨvɨ tandɨhɨ ñáyɨvɨ nɨcahnu ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ta quɨvɨ cuan ra Cirenio cuví ra ra nyacá ñaha tandɨhɨ ñuu ityi Siria. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ta tahán chi cuhun tandɨhɨ ñáyɨvɨ nya ñuu ñu. Vatyi cuhva ñu sɨvɨ ñu yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yucuan chaha quita̱ ra José ñuu Nazaret ityi Galilea. Ta chaha̱n ra ityi Judea ñuu Belén nu cacu̱ ra David. Yucuan chaha̱n ra vatyi tata ra David vachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ta chaha̱n ra chi cuhva ra sɨvɨ ra chihin cu María. Ta cha cuñí tandaha ña chihin ra. Ta ñohó sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta chiquɨtaha̱n chaa quɨvɨ cha cacu sehe ña cha nɨ ri ca cha ñohó ñu Belén cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta yucuan cacu̱ sehe nuu ña. Ta natyihi̱ ña chi cue chichi sahma. Ta nandacu̱n ña chi cue chichi noo nu chachí quɨtɨ. Vatyi cuaha xaan ñáyɨvɨ chaa̱ coyo ñuu cuan. Ta ña nuña ca ni minoo vehe nu cunyaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatyin ñuu Belén cuan nyicú suhva ra casahá cumi mbee sana ra cha cha cuaa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta sana iñi ra ta tuvi̱ noo ángel Nyoo. Ta cha ndichin Nyoo Sutu Mañi yo ndundichi̱n nɨcachico ri nu canyicú ra. Ta nayuhví xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ta quichaha cahán ángel cuan, ta catyí ra tyehe caa: ―Ma yuhvi ndo. Vatyi cuacatyi mai noo tuhun chi ndo. Noo tuhun cha sɨɨ xaan cuacuvi chi tandɨhɨ ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vatyi vityin cacu̱ ra sacacú añima ndo ñuu ra David. Noo ra cuví Cristo, ra cuví Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta ihya cuví seña chahi chi ndo, cunyehe ndo chi cha lee cuan, sɨquɨ noo cue sahma. Catuví cue chichi noo nu chachí quɨtɨ ―catyí ángel chi ra casahá cumi mbee cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta caa cuhva ri cuan chaa̱ coyo cuaha xaan ca ángel casacahnú ra chi Nyoo, ta cacatyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Sa̱cahnu yo chi Nyoo nu nyaá ra gloria. Ta ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ cha ñihi tumañi iñi ra, na coo taxi añima ñu, catyí angel cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yucuan ta cuanuhu̱ coyo ángel cuan gloria. Tyicuan ta ra casahá cumi mbee quichaha̱ catyi ra chi ra tahan ra: ―Co̱ho ndo Belén. Cunyehe yo ñáá cha cuvi̱. Vatyi maa Sutu yo Nyoo sacoto̱ chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tyicuan ta numi xaan cuahan coyo ra Belén. Ta nañihi̱ ra chi cue chihin cu María ta ra José. Ta catuví cue noo nu chachí quɨtɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ta yaha̱ cha canyehe ra chi cue, ta canacatyi̱ ra chi ñu ñáá ndɨhɨ tuhun caha̱n ángel chihin ra cuenda cha lee cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta tandɨhɨ ñu chiñi̱ tuhun cahán ra, iyo xaan cuñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Soco cu María ta cuhva chicá ri xiñi ña tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ta ra sahá cumi chi mbee cuan cuanuhu̱ coyo ra. Ta casacahnú ra chi Nyoo cha cuenda cha cachiñi̱ ra ta canyehe̱ ra. Vatyi chino̱ cava tandɨhɨ cha catyi̱ ángel chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta nu cu uña quɨvɨ, saha̱ ñu circuncidar chi cue, tari cuhva tuhva maa ñu. Ta sacunañi̱ ñu chi cue, Jesús. Suri maa sɨvɨ cha catyi̱ ángel chi cu María quɨvɨ cha cumañi ca cohon sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta cha yaha̱ quɨvɨ cha taha̱n chi vatyi ndundɨɨ ñu nuu Nyoo, tari cuhva catyí maa ley Nyoo cha tyaa̱ ra Moisés, tyicuan ta cuahan ñu Jerusalén. Vatyi cuacuhva cuenda ñu chi cue chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sacuvi̱ ñu tyicuan caa vatyi ɨɨn caa maa catyí ley tyehe caa: “Tandɨhɨ rayɨɨ cha cuví sehe nuu ñu, cucuhva cuenda ñu chi Nyoo”, catyí ley cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta chaha̱n ñu chicuhva cuenda ñu uvi tahan quɨtɨ tari cuhva catyí maa ley Sutu yo Nyoo nu catyí chi tyehe caa: “Cu̱hva ndo uvi tahan cucu o uvi tahan ndicuiya”, catyí ley cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta quɨvɨ cuan iyó noo ra ñuu Jerusalén cha nañí Simeón. Ta cuví ra noo ra vaha, ra sacahnú chi Nyoo. Ta nyatú tuhva ra nya quɨvɨ cusacacu Nyoo chi ñáyɨvɨ Israel. Ta yɨhɨ́ ra Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ta sacoto̱ Tatyi Ii Nyoo chi ra vatyi ma cúvi ra cha nɨ ri ca cha ta nyehe ca ra chi ra sacacú chi ñu Israel, ra cuví Cristo, ra cha cusaquichi Sutu yo Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta ra cuan chaha̱n ra vehe ñuhu cuhva catyi̱ maa Tatyi Ii Nyoo chi ra. Cuhva cuan chaha̱n tucu sutu ta sɨhɨ cha lee cuan chinyaca̱ ñu chi cue vehe ñuhu cahnu, vatyi sacuvi ñu tari cuhva catyí maa ley. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ta quehe̱n ra Simeón chi ra Jesús. Ta tyihi̱ sucun ndaha ra chi ra. Ta quichaha̱ sacahnu ra chi Nyoo. Ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Sutu Mañi yuhu. Na cúvi mai vityin chihin cha vaha. Vatyi cha sacuvu̱n cha catyu̱n chi yuhu cha cuví sehun. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vatyi cha nyehi̱ chihin nui chi ra cusacacu chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Vatyi sañahu̱n chi ra nuu tandɨhɨ ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cha catyi ra ta cucahnu ñáyɨvɨ Israel nuu inga ñáyɨvɨ. Ta ican ra cuví ra cha sacundichín añima tandɨhɨ inga ñáyɨvɨ cha ñima ñu Israel cuví. Vatyi cusacuvi ra na cutuñi iñi ñu tuhun Nyoo ―catyí ra Simeón. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta ra José chihin sɨhɨ ra Jesús, iyo xaan cuñi̱ ñu cha caha̱n ra Simeón tuhun cha lee cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yucuan ta chica̱n tahvi ra Simeón chi Nyoo chaha ñu. Ta catyí ra chi cu María sɨhɨ ra Jesús: ―Nye̱he chi cha lee ihya. Vatyi cuaha xaan ñáyɨvɨ cuchino iñi ñu chi ra quɨvɨ coto ñu tuhun ra, ta cucacu añima ñu. Soco cuaha ñu ma chino iñi ñu chi ra, ta cunaa ñu. Ta cucahan ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ta cha tyicuan caa cusanatuvi ra cha caa añima noo noo ñáyɨvɨ. Soco cha cuenda yoho, María. tari cha uhvi cha yahá sava noo tyicaa añima ñáyɨvɨ, tyicuan caa cha uhvi cunyehún cha catyi cha lee ihya ―catyí ra Simeón. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta yucuan ñohó tucu noo ñaha cha cuví profeta Nyoo. Ta cha chahnu xaan ña. Nañí ña Ana. Ta sehe ra Fanuel noo ra vachi tata ra Aser cuví chi ña. Luhlu xaan ña ta tandaha ña, ta ucha ri cuiya chiyo̱ ña chihin yɨɨ ña ta chihi̱ ri ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta cha cumi xico cumi cuiya chihi̱ yɨɨ ña. Ta vehe ñuhu cahnu ña quitá ña, vatyi ndiyaca ta ñiyaca chicán tahvi ña chi Nyoo. Ta iyó cuhva cha ña chachi̱ ña cha nɨ ri ca cha chicán tahvi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ta cuhva cha ñohó ra José ta cu María chihin cha lee, chaa̱ ña nu canyicú ñu. Ta nacuhva̱ ña tyahvi nyoo chi Nyoo. Ta quichaha̱ cahan ña tuhun ra Jesús chihin tandɨhɨ ñáyɨvɨ cha nyatú tuhva cha quita ñuu Jerusalén chichi ndaha ra ñuu Roma. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cha yaha̱ cha sacuvi ñu tandɨhɨ maa yoso caa catyí ley Sutu yo Nyoo, ta cuanuhu ñu nya Galilea nya ñuu ñu nu nañí Nazaret. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta ra Jesús cuahan chahnu ca ra. Ta cuahan ndunyee ca ra ta cuahan chicoo ca cha chiñi tuñi Nyoo. Vatyi nasoco Nyoo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ra José chihin sɨhɨ ra Jesús ndɨhɨ cuiya ri tuhva ñu chahán nya Jerusalén cha vico pascua. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta quɨvɨ ndɨhɨ̱ ra Jesús uchi uvi cuiya, chaha̱n tandɨhɨ ñu Jerusalén tari tuhvá maa ñu chahán cha vico. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ta quɨvɨ ndɨhɨ̱ vico ta cuandichi ñu, ta ra Jesús ndoo̱ ra Jerusalén. Ta ña saha̱ ñu cuenda. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cuñí maa ñu vatyi cuandichi ra mahñu nu tuvi ñáyɨvɨ cuan. Yucuan chaha ñahri chicá iñi ñu chicá ityi ñu noo quɨvɨ. Tyicuan ta nanducu̱ ñu chi ra chichi nu tuvi ñáyɨvɨ cuan, ");
INSERT INTO mxtNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ta ña nañihi̱ ñu chi ra. Tyicuan ta cuanuhu chata ñu cuananducu ñu chi ra nya Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cha yaha̱ cha uñi quɨvɨ ta nañihi̱ ñu chi ra chichi vehe ñuhu cahnu cuan. Nyaá ra chihin ra sacuahá cuenda ley vehe ñuhu. Ta tyasohó ra cuan tuhun cahán ra. Ta ndacá tuhun ra tuhun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta tandɨhɨ ñu chiñí tuhun cahán ra, iyo xaan cuñí ñu chihin cha chiñi tuñi ra, ta chihin tuhun cha nacahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cuhva cha nanyehe̱ sutu ra ta sɨhɨ ra chi ra, iyo xaan cuñí ñu. Ta sɨhɨ ra catyí ña chi ra: ―Sehe luhli. ¿Ñáá tuhun cha sacuvu̱n chi ndi tyehe caa? Sutun ta yuhu chica̱ xaan iñi ndi ta nanducu̱ xaan ndi chuun ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tyicuan ta catyí ra Jesús: ―¿Ñáá tuhun cha nanducu ndo chii? ¿Atu ña chito̱ ndo vatyi nɨñɨ cuñí chi cha cahin tuhun Suti chihin ñáyɨvɨ? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Soco ña cutuñí iñi ñu tuhun caha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tyicuan ta cuanuhu̱ ra chihin ñu nya Nazaret. Ta quichahá ra tuhun cahán ñu. Ta sɨhɨ ra naquehen vaha ña tandɨhɨ tuhun ihya chichi añima ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yucuan cuví nu cuacuahnu ca ra Jesús. Ta cuahan chaa ca cha chiñi tuñi xiñi ra. Ta sɨɨ xaan cuví chi Nyoo chihin ra ta ñáyɨvɨ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nu ndɨhɨ chahun cuiya cha cuví ra Tiberio rey cahnu ñuu Roma, ta ityi Judea nyacá ñaha ra Poncio Pilato. Ta ra Herodes nyacá ñaha ra Galilea. Ta yañi ra, ra Felipe nyacá ñaha ra Iturea chihin Traconite. Ta ra Lisanias nyacá ñaha ra Abilinia quɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta ra Anás chihin ra Caifás, ican ra cuví ra ra cacuví nuu chi tandɨhɨ tata sutu. Ta quɨvɨ cuan cahán Nyoo chihin ra Juan sehe ra Zacarías noo nu chiqui ndɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ta ra Juan chicá noo ra tandɨhɨ ñuu cha nyaá yatyin ri nu nyaá noo yuvi cahnu cha nañí Jordán cahán ra tuhun Nyoo chihin ñáyɨvɨ. Ta catyí ra chi ñu na ndu uvi iñi ñu cuatyi ñu ta na condutya ñu. Tyicuan caa ta Nyoo saha ra tucahnu iñi chi ñu, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tyehe caa cuvi tari cuhva catyí nu libru cha tyaa̱ ra Isaías profeta Nyoo ta cha naha. Ta catyí ra: Chiñí yo cha caná chaa noo ra noo nu chiqui ndɨɨ, ta catyí ra: “Tari sanduvahá ndo noo ityi, tyicuan caa sa̱nduvaha ndo añima ndo vatyi cuaquichi Sutu Mañi yo. Nu̱ña ndo noo ityi ndoo chi ra na quɨhvɨ ra añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tari cha sanandutú ndo noo tɨcoho, ta tari sandundaá ndo noo yucu cahnu, ta tari sandundoó ndo cha yacua, ta tari sanduvií ndo nu quiñi caa, tyicuan caa na̱sama ndo cuhva iyó ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tyicuan caa ta tandɨhɨ ñáyɨvɨ ta nyehe ñu vatyi Nyoo chaha ra cha cacú añima ñu.” ");
INSERT INTO mxtNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ta tyicuan caa cahán ra Juan chihin ñáyɨvɨ. Yucuan ta cuhva cha chiñí ñu tuhun cahán ra, ta catyí ñu chi ra vatyi na sacondutya ra chi ñu. Yucuan ta quichaha catyi ra chi ñu: ―¡Nyoho tari noo tata coo xaan cuví ndo! ¿Yóó cha sañaha̱ chi ndo vatyi chihin cha condutya ri ndo ta ma tachi tuñi ca Nyoo chi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na̱sama ndo cuhva iyó ndo, na nyehe ñáyɨvɨ vatyi cha ndu uvi iñi ndo cuatyi ndo. Ta ma catyi ndo vatyi tata ra Abraham vachi ndo. Vatyi nyacua nya noo yuu ihya, Nyoo cuví sananduvi ra noo ñáyɨvɨ chi ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tari yutun cha ña chahá chɨtɨ, tyicuan caa cuvi ndo. Vatyi ña sacuví ndo tari cuhva cuñí Nyoo. Ta yutun cha ña chaha chɨtɨ, cahnya ñáyɨvɨ chi tun. Ta cahmi ñu chi tun. Tyicuan caa tucu nyoho cha cuñí cuiri cuhun ndo nu cayu ñuhu ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yucuan ta quichaha ndaca tuhun ñáyɨvɨ chi ra: ―¿Yoso caa sacuvi ndi, cuñí yoho? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta nacaha̱n ra Juan, ta catyí ra: ―Yóó ra cha iyó uvi tahan camisa, tahán chi cuhva ra noo chi ra cha ñahri chi. Ta yóó ñu cha iyó cha cachi, tahán chi cuhva ñu cha cachi ñu ñahri chi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta chaa̱ coyo tucu suhva ra catavá xuhun cuenda gobiernu Roma, ta cuñí ra condutya ra. Ta candaca̱ tuhun ra chi ra Juan: ―Maestro, ¿yoso caa sacuvi tucu nyuhu? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ta catyí ra Juan chi ra: ―Tari cuhva catyí ley ta̱va ndo xuhun. Ta ma tava ndo cuaha ca. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yucuan ta quichaha candaca̱ tuhun tucu suhva sɨndaro chi ra, ta catyí ra: ―Ta nyuhu tucu, ¿yoso caa sacuvi ndi? ―catyí ra. Ta nacaha̱n ra Juan ta catyí ra: ―Ma tinyaa ca ndo cha chii ñáyɨvɨ. Ta ma tyanaha ndo chi ñu. Ma tyaa ndo cuatyi sɨquɨ ñu tatu ñahri cuatyi ñu. Ta ndo̱o ndo vaha yoso cuhva yahvi ndo ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iyo cuñí ñáyɨvɨ tuhun cahán ra Juan. Ta cuñí ñu tyi ican ra cuví Cristo, ra cha sacacú chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Soco ra Juan catyí ra chi tandɨhɨ ñu: ―Cha ndicha vatyi sacondutyé chi ndo chihin ndutya. Soco cha yaha yuhu cuhin cuquichi inga ra cusacondutya chi ndo chihin Tatyi Ii Nyoo ta chihin ñuhu̱. Iyó ca tunyee iñi chi maa ra, ta ñima ca yuhu. Vatyi ña nañé cha cuví musu ra ta nɨri cha ndachi ñɨɨ xityin ndichan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tari noo ra cha cuanaquehen vaha nɨñɨ, ta natyihi vaha ra chichi yaca. Ta cahmi ra mihin. Tyicuan caa cuví maa Sutu Mañi yo chihin yo. Tatu chinó iñi yo chi ra, cunaquehen vaha ra chi yo, ta cunyicu yo chihin ra. Soco tatu ña chinó iñi yo chi ra cutyihi ra chi yo anyaya nu cayu ñuhu̱ cha ma ndahva ca maa ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ta tyehe caa caha̱n ra Juan chihin ñu. Ta cuaha xaan ca tuhun cahan ra nuu ñu tyi cuaquichi Sehe Nyoo ta cua sacacu ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ta cahán ra Juan chi ra Herodes cha cuenda tandɨhɨ cuii cha ña vaha nyacuví ra. Vatyi naquehe̱n ra chi cu Herodías, ñasɨhɨ ra Felipe yañi ra. Ta cuaha ca cha ña vaha nyacuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Soco ra Herodes tahán chi cha tyasoho̱ ra tuhun ihya soco ña cuñí ra. Nu ndɨhɨ tuhun tyihi̱ ndɨhɨ ra chi ra Juan vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cumañi ca cha cohon ra Juan vehe caa sacondutya̱ ra chi tandɨhɨ ñáyɨvɨ. Ta sacondutya̱ tucu ra chi ra Jesús. Ta cha nɨ ri ca cha chicán tahvi ra Jesús chi Nyoo ta nuña̱ andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ta nyehe̱ ra Tatyi Ii Nyoo quichi̱ sɨquɨ ra tari noo paloma. Ta tyacu̱ noo ndusu andɨvɨ cha catyí tyehe caa: ―Yoho cuvún Sehi cha cuñí. Ta sɨɨ xaan cuñí chuhun ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Oco uchi cuiya ra Jesús ta quichaha̱ saha tyiño ra tyiño Nyoo. Ta tandɨhɨ ñáyɨvɨ cuñí maa ñu vatyi sehe ra José cuví chi ra. Ta ra José, sehe ra Elí cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ta ra Elí, sehe ra Matat cuví chi ra. Ta ra Matat, sehe ra Leví cuví chi ra. Ta ra Leví, sehe ra Melqui cuví chi ra. Ta ra Melqui, sehe ra Jana cuví chi ra. Ta ra Jana, sehe ra José cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ta ra José, sehe ra Matatías cuví chi ra. Ta ra Matatías, sehe ra Amós cuví chi ra. Ta ra Amós sehe ra Nahum cuví chi ra. Ta ra Nahum, sehe ra Esli cuví chi ra. Ta ra Esli, sehe ra Nagai cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ta ra Nagai, sehe ra Maat cuví chi ra. Ta ra Maat, sehe ra Matatías cuví chi ra. Ta ra Matatías sehe ra Semei cuví chi ra. Ta ra Semei, sehe ra José cuví chi ra. Ta ra José, sehe ra Judá cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ta ra Judá, sehe ra Joana cuví chi ra. Ta ra Joana sehe ra Resa cuví chi ra. Ta ra Resa, sehe ra Zorobabel cuví chi ra. Ta ra Zorobabel, sehe ra Salatiel cuví chi ra. Ta ra Salatiel, sehe ra Neri cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta ra Neri, sehe ra Melqui cuví chi ra. Ta ra Melqui, sehe ra Adi cuví chi ra. Ta ra Adi, sehe ra Cosam cuví chi ra. Ta ra Cosam, sehe ra Elmodam cuví chi ra. Ta ra Elmodam, sehe ra Er cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta ra Er, sehe ra Josué, cuví chi ra. Ta ra Josué, sehe ra Eliezer cuví chi ra. Ta ra Eliezer, sehe ra Jorim cuví chi ra. Ta ra Jorim, sehe ra Matat cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ta ra Matat, sehe ra Leví cuví chi ra. Ta ra Leví, sehe ra Simeón cuví chi ra. Ta ra Simeón, sehe ra Judá cuví chi ra. Ta ra Judá, sehe ra José cuví chi ra. Ta ra José sehe ra Jonán cuví chi ra. Ta ra Jonán, sehe ra Eliaquim cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ta ra Eliaquim, sehe ra Melea, cuví chi ra. Ta ra Melea, sehe ra Mainán cuví chi ra. Ta ra Mainán, sehe ra Matata cuvi chi ra. Ta ra Matata, sehe ra Natán cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta ra Natán, sehe ra David, cuví chi ra. Ta ra David, sehe ra Isaí cuví chi ra. Ta ra Isaí, sehe ra Obed cuví chi ra. Ta ra Obed, sehe ra Booz cuví chi ra. Ta ra Booz, sehe ra Salmón cuví chi ra. Ta ra Salmón, sehe ra Naasón cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ta ra Naasón, sehe ra Aminadab cuví chi ra. Ta ra Aminadab, sehe ra Aram cuví chi ra. Ta ra Aram, sehe ra Esrom cuví chi ra. Ta ra Esrom, sehe ra Fares cuví chi ra. Ta ra Fares, sehe ra Judá cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ta ra Judá, sehe ra Jacob cuví chi ra. Ta ra Jacob, sehe ra Isaac cuví chi ra. Ta ra Isaac, sehe ra Abraham cuví chi ra. Ta ra Abraham sehe ra Taré cuví chi ra. Ta ra Taré, sehe ra Nacor cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ta ra Nacor, sehe ra Serug cuví chi ra. Ta ra Serug, sehe ra Ragau cuví chi ra. Ta ra Ragau, sehe ra Peleg cuví chi ra. Ta ra Peleg, sehe ra Heber cuví chi ra. Ta ra Heber, sehe ra Sala cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ta ra Sala, sehe ra Cainán cuví chi ra. Ta ra Cainán, sehe ra Arfaxad cuví chi ra. Ta ra Arfaxad, sehe ra Sem cuví chi ra. Ta ra Sem, sehe ra Noé cuví chi ra. Ta ra Noé, sehe ra Lamec cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ta ra Lamec, sehe ra Matusalén cuví chi ra. Ta ra Matusalén sehe ra Enoc cuví chi ra. Ta ra Enoc, sehe ra Jared cuví chi ra. Ta ra Jared, sehe ra Mahalaleel cuví chi ra. Ta ra Mahalaleel, sehe ra Cainán cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ta ra Cainán, sehe ra Enós cuví chi ra. Ta ra Enós, sehe ra Set cuví chi ra. Ta ra Set, sehe ra Adán cuví chi ra. Ta ra Adán, sehe Nyoo cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ta chitú ra Jesús chihin Tatyi Ii Nyoo cha yaha̱ condutya ra. Yucuan ta quita̱ ra nu cuví yuvi cahnu Jordán ta cuanuhu ra. Ta Tatyi Ii Nyoo chinyaca̱ chi ra noo nu chiqui ndɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yucuan chinyaa̱ ra uvi xico quɨvɨ. Ta nducú nyehe cuihna chi ra. Ña chachi̱ maa ra quɨvɨ cuan. Yaha̱ cuan ta quichaha chisoco ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yucuan ta quichaha catyí cuihna chi ra: ―Tatu ndicha cha Sehe Nyoo cuví chuun, ca̱tyi chi yuu cha catuví ihya, na nanduvi pan. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta ra Jesús nacaha̱n ra, ta catyí ra: ―Catyí tuhun Nyoo tyi ñima chihin cha cachi ri ñáyɨvɨ ta conyito ñu. Soco conyitó tucu añima ñu chihin tandɨhɨ tuhun cahán Nyoo ―catyí ra Jesús chi cuihna. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yucuan ta quehe̱n cuihna chi ra Jesús. Ta cuahan ra chihin ra noo nu sucun ca. Ta numi ri sañaha̱ ra tandɨhɨ nu nyacá ñaha ñáyɨvɨ sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ta cuihna catyí ra chi ra Jesús: ―Ndaha yuhu nyaá tandɨhɨ ñayɨvɨ̱ ihya. Vatyi chaha̱ Nyoo cha cunyaca ñahi tandɨhɨ ihya sɨquɨ ñuhu ñayɨvɨ. Ta cuví cuhve yóó chi cuñí mai cuhve. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Cuhve tandɨhɨ ñayɨvɨ̱ cuan chuun tatu yoho ta cuɨñɨ chɨtun nui, ta sa̱cahnun chii ―catyí cuihna cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Soco ra Jesús catyí ra chi cuihna: ―Ca̱nyaha chuun nui, cuihna. Vatyi nyaá tuhun cahán Nyoo ta catyí chi tyehe caa: “Noo ri chi maa Nyoo sacahnu yo. Ta ɨɨn ri chi maa ra quichaha yo.” ");
INSERT INTO mxtNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yaha̱ cuan ta quehe̱n tucu cuihna cuan chi ra Jesús. Ta chinyaca̱ ra chi ra nya ñuu Jerusalén. Ta sandaa̱ ra chi ra xiñi vehe ñuhu cahnu. Ta quichaha catyí ra chi ra Jesús: ―Tatu ndicha cha Sehe Nyoo cuví chuun, sa̱ndupehla nyacua nya nu ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Vatyi nyaá nu catyí chi nu tutu Nyoo tyehe caa: Nyoo cusaquichi ra ángel, quichi saha cuenda chuun. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cunaquehen ra chuun chihin ndaha ra. Ta ma cuhva ra cha taxin chahun chihin yuu ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ―Soco catyí tucu nu tutu Nyoo tyehe caa: “Ma nducu nyehun chi Sutu Mañi yo Nyoo”, ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta cuihna ña cuvi̱ sandahvi ñaha ra chi ra Jesús. Ta cuahan ra suhva quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Cha yaha̱ tuhun cuan, ta nachaa̱ ra ityi Galilea. Ta tyitú ra yɨhɨ́ chihin tunyee iñi Tatyi Ii Nyoo. Ta cahán ñáyɨvɨ tuhun ra tandɨhɨ ri ityi. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta sañahá ra chi ñáyɨvɨ nu cuví vehe ñuhu tandɨhɨ ri ñuu. Ta tandɨhɨ ñu sacahnú ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tyicuan ta nachaa̱ ra Jesús nya Nazaret, ñuu nu chahnu̱ ra. Ta noo quɨvɨ nyitatú ñáyɨvɨ, ta quɨhvɨ̱ ra chichi vehe ñuhu, tari tuhva maa ra. Ta chicunanyaa̱ ra vatyi cua sacuaha ra tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ta chaha̱ ñu noo libru Nyoo chi ra cha tyaa̱ ra Isaías ra profeta Nyoo ta cha naha. Ta cuhva cha nuña̱ ra, nañihi̱ ra noo nu catyí tyehe caa. Ta quichaha̱ sacuaha ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nyaá Tatyi Ii Nyoo chihin vatyi maa ra tachi̱ chii. Vatyi nacachi̱ ra chii vatyi sañahi tuhun vaha ra chi tandɨhɨ ñáyɨvɨ ndahvi. Tachi̱ ra chii vatyi sanduvahi chi ñu uhvi añima. Tachi̱ ra chii vatyi sacote tuhun ra chi ñu nyaá ndaha ra ña vaha, vatyi cusacacu Nyoo chi ñu. Tachi̱ ra chii vatyi sanyehi chi ñáyɨvɨ cuaa. Ta sacote chi ñu nyehe tɨndoho vatyi cucacu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta sacote chi ñu vatyi cha chaa̱ quɨvɨ cha chaha̱ Nyoo tumañi iñi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ndɨhɨ̱ sacuaha ra ta nacasɨ̱ ra nu libru cuan. Ta nacuhva̱ ra chi noo ra cha nyaá vehe ñuhu cuan. Ta chicunyaa̱ ra. Yucuan ta tandɨhɨ ñáyɨvɨ cha nyicú cuan ndoo̱ ñu nyehe ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yucuan ta quichaha catyí ra chi ñu: ―Vityin quɨvɨ ihya chino̱ cava tuhun cha nyaá nu libru cha sacuahi̱ nuu ndo ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tandɨhɨ ñu, vaha cahán ñu tuhun ra Jesús. Ta iyo cuñí ñu tuhun cha cahán ra vatyi vaha xaan cha cahán ra. Ta quichaha ndaca tuhun ñu chi tahan ñu: ―¿Atu ñima ra ihya cuví sehe ra José? ");
INSERT INTO mxtNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ta quichaha catyí ra Jesús chi ñu: ―Chité cha nacacá iñi ndo. Vatyi tyehe caa cua catyi ndo chii: “Tatu ra sanduvahá cuvún, sa̱nduvaha xihna ca chi maun. Tandɨhɨ cha chiñi̱ ndi cha sacuvu̱n ñuu Capernaum. Sa̱cuvi tucu ñuu maun vityin.” ");
INSERT INTO mxtNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta catyí tucu ra Jesús: ―Cha ndicha vatyi ni noo ra profeta Nyoo, ta ña quichaha ñáyɨvɨ ñuu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta cha ndicha catyí chi ndo vatyi cuaha xaan ñu chihi̱ yɨɨ chiyo̱ Israel ihya cuiya cha chica̱ noo ra Elías. Ta cuiya cuan ña coo̱n savi uñi cuiya sɨsava. Ta cuaha xaan tama chiyo̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Soco ña tachi̱ Nyoo chi ra Elías vatyi tyinyee ra chi ni noo ñu chihi̱ yɨɨ Israel cuan. Soco tachi̱ Nyoo chi ra nu nyaá noo ñaha chihi̱ yɨɨ ñuu Sarepta cha nyaá yatyin ñuu Sidón. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","’Ta tyicuan caa tucu cuaha ra yɨhɨ́ cuehe cha tyahyu coño chi chiyo̱ Israel quɨvɨ chica̱ noo ra Eliseo, profeta Nyoo. Soco ña nduvaha̱ ni noo ra Israel cuiya cuan. Minoo ri ra Naamán ra ñuu Siria nduvaha̱ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ta cha chiñi̱ ñáyɨvɨ nyicú vehe ñuhu cuan tuhun cuan, cuxaan xaan tandɨhɨ cuii ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ta nducuita ñu. Ta tɨɨ̱n ñu chi ra Jesús. Tava̱ ñu chi ra xiñi noo yucu nya yuhu ñuu, vatyi tuchi ñu chi ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Soco ra Jesús yaha̱ ri ra mahñu ñu ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ta cuahan ra Jesús Capernaum cha nyaa Galilea quɨvɨ nyitatú ñáyɨvɨ. Ta quichaha sañaha ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ta iyo cuñí ñu tuhun cahán ra. Vatyi ñihi cahán ra tari noo ra iyó vaha ityi chi cha cahán. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta chichi vehe ñuhu cuan nyaá noo ra cha yɨhɨ́ tatyi ña vaha chi. Ta quichaha canachaa ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Sa̱ña chi ndi, yoho Jesús ra ñuu Nazaret. ¿Ñáá tuhun cha tyihun chuun chihin ndi? ¿Atu vachi sanaun chi ndi? Yuhu, ñohó nui chuun. Ta chité vatyi Sehe Nyoo cuví chuun ―catyí tatyi ña vaha cuan sacahan chi chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ta cahan ra Jesús chihin tatyi ña vaha cuan, ta catyí ra: ―Ta̱xi ri. Sa̱ña chi ra ndahvi chiña ―catyí ra. Tyicuan ta tatyi ña vaha cuan sanduva̱ chi ra cuan nu ñuhú. Ta quita̱ tatyi cuan chi ra ta cuahan. Ta ñahri ca sacuvi chi chi ra ndahvi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tandɨhɨ ñáyɨvɨ nayuhvi̱ ñu. Ta quichaha catyí ñu chi tahan ñu: ―¿Ñáá túhun cuví ihya? Ra Jesús ihya chihin cha iyó ityi chi ra ta chihin tunyee iñi ta tachi ra chi tatyi ña vaha cuan na quita. Ta quichaha chi nu cahán ra ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ta tandɨhɨ ri ityi cahán ñáyɨvɨ tuhun ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ta quita̱ ra Jesús chichi vehe ñuhu cuan. Ta chaa̱ ra vehe ra Simón. Ta tyiso ra Simón cuhví ña chihin cahñi. Ta quichaha cahán ñu chihin ra Jesús cha cuenda ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ta nanyehe noo ra nu catuví ña. Ta quichaha catyí ra chi cahñi cuan vatyi na quita. Ta caa cuhva ri cuan ta quita cahñi cuan chi ña. Ta nducuita ri ña. Ta quichaha tyiñuhu ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ta cuhva cha quee ñanyii, tandɨhɨ maa ñu cha cumí chi ñu cuhví tandɨhɨ nuu cuehe, chinyaca̱ ñu chi ra Jesús. Ta tyiso̱ ra ndaha ra sɨquɨ noo noo ñu. Ta tyicuan caa ta sanduvaha̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta chichi cha tandɨhɨ ñu yɨhɨ́ ñu cha yɨhɨ́ tatyi ña vaha chi, ta quita̱ chi. Ta suri cana chaa chi cuahan coyo chi, ta catyí chi: ―Yoho Sehe Nyoo cuví chuun ―catyí chi. Soco ña chaha̱ ca ra Jesús cha cahan chi. Vatyi chitó chi vatyi ra Cristo, ra cha saquichi̱ Nyoo cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cundichin cuan ta quita̱ ra Jesús ñuu cuan. Ta cuahan ra noo nu taxi ri iyó. Soco ñáyɨvɨ nanducu̱ ñu chi ra. Ta chaa̱ ñu nya nu ñohó ra. Ta ña cuñí ñu cha cuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Soco catyí ra Jesús chi ñu: ―Cumañi sacote chi ñáyɨvɨ inga ñuu tuhun vaha yoso caa nyacá ñaha Nyoo añima ñu. Vatyi yucuan chaha vachi sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ta tyicuan caa chicá noo ra Jesús cahán ra tuhun Nyoo vehe ñuhu ityi Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Noo quɨvɨ nyaá ra Jesús yuhu miñi nu cuví Genesaret. Ta chaa̱ coyo cuaha xaan ñáyɨvɨ, vatyi cuñí ñu cuɨñɨ ñu tuhun Nyoo. Ta tɨhɨn xaan ñohó ra Jesús mahñu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ta nanyehé ra uvi tahan canoa yatyin ri yuhu miñi cuan. Yori ñohó chichi. Vatyi cha quita̱ coyo ra catɨɨ́n tiyaca cuan. Ta cha quichaha canacatya ra yuhva ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yucuan ta quɨhvɨ̱ ra Jesús chichi noo canoa cuan. Ta canoa cuan chi ra Simón cuví. Ta catyí ra chi ra vatyi na tyandaha ra suhva ca cuhun nya mahñu ca cuan. Tyicuan ta chicunyaa̱ ra Jesús chichi canoa cuan. Ta quichaha sañaha ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuhva cha ndɨhɨ̱ cahan ra, catyí ra chi ra Simón: ―Sa̱cuhun canoa nya nu cama ca ndutya cuan. Ta tu̱chi ndo yuhva vatyi tɨɨn ndo tiyaca ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ta nacaha̱n ra Simón ta catyí ra: ―Maestro, cha saha̱ tyiño xaan ndi ñiyaca maa ta ni noo tiyaca ña ñihi̱ ndi. Soco tatu maun catyi, cuatuchi tucu ndi yuhva ―catyí ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cuhva cha cacañi̱ ra yuhva cuan, cuaha xaan tiyaca ñihi̱ ra. Ta nyacua tahnya̱ yuhva ra chihin cha vee tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tyicuan ta cachaha̱ ra seña chi ra tahan ra, ra cha canyicú chichi inga canoa cuan, na quichi coyo ra ta tyinyee ra chi ra. Yucuan ta chaa̱ coyo ra cuan. Ta casacutu̱ ra nɨnduvi canoa cuan chihin tiyaca. Ta nyacua cuñí nyee canoa cuan cha tyitu yɨhɨ́ tiyaca. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cha nanyehe̱ ra Simón Pedro cha tyicuan caa, ta chicuɨñɨ chɨtɨ ra nuu ra Jesús. Ta catyí ra chi ra: ―Cua̱chiyo chuun nui, Sutu Mañi yuhu, vatyi yuhu ra iyó cuatyi cuví ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Vatyi ra Simón iyo xaan cuñi ra chihin tandɨhɨ ra canyicu chihin ra. Vatyi cuaha xaan tiyaca catɨɨ̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tyicuan caa tucu ra tahan ra Simón: ra Jacobo chihin ra Juan, sehe ra Zebedeo, iyo xaan cacuñí ra. Ta catyí ra Jesús chi ra Simón: ―Ma iyo xaan cuñun. Vatyi vityin ta nu cuahan ca chi quɨvɨ, ma tɨɨn con tiyaca. Soco cunducun ñáyɨvɨ, tavon chi ñu nu quiñi caa na quɨhvɨ ñu cuenda Nyoo ―catyí ra Jesús chi ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yucuan ta casacunuhu ra canoa nya ñuhu ityi. Ta casandoo̱ ra tandɨhɨ cha iyó chi ra nyacua nya tiyaca cha tɨɨ̱n ra. Ta cuahan ra chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Noo quɨvɨ ñohó ra Jesús noo ñuu nu iyo noo ra cuhví. Ta tyahyu xaan coño ra. Ta cha nanyehe ra chi ra Jesús, ta chicuɨñɨ chɨtɨ ra nuu ra. Ta nacañinoo ra xiñi ra nya nu ñuhu. Ta chacu ndahvi ra nuu ra, ta catyí ra: ―Sutu Mañi yuhu, tu yoho ta cuñún, cuví sanduvahun chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tyicuan ta tyiso̱ ra Jesús ndaha ra sɨquɨ ra. Ta catyí ra: ―Cuñí sanduvahi chuun. Ta na nduvahun vityin ri ―catyí ra Jesús chi ra. Ta caa cuhva ri cuan ta nduvaha̱ ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tyicuan ta catyí ra Jesús chi ra: ―Ma nacatyun chi ñáyɨvɨ. Noo ri catyí chuun, cua̱han nu nyaá tata sutu. Ta sa̱ñahun chuun chi ra. Ta cu̱hva cuendon cha tahán chi cuhvon tari cuhva catyí nu ley ra Moisés tacuhva coto ñáyɨvɨ vatyi nduvahu̱n ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Vasɨ ña cuñí ra cha coto ñáyɨvɨ, soco cuaha ca ñáyɨvɨ ñihi ñu tuhun ra. Ta cuaha xaan ñáyɨvɨ ndu ɨɨn ri ñu, vatyi cuñí ñu cuɨñɨ ñu tuhun cahán ra. Ta cuñí xaan ñu nduvaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Soco ra Jesús, canyaha canyaha ri ra nu iyó ñáyɨvɨ. Ta cuahan ra noo nu yori ñáyɨvɨ iyó. Ta yucuan chica̱n tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Noo quɨvɨ sañahá ra Jesús chi ñáyɨvɨ. Ta chicunyicú suhva ra fariseo, ra quichahá xaan ley vehe ñuhu cha tyaa̱ ra Moisés ta cha naha. Ta nyicú tucu suhva ra sacuahá cuenda ley vehe ñuhu cuan. Quichi̱ coyo ra ñuu cha iyó Galilea, ta ñuu Jerusalén, ta tandɨhɨ ca ñuu cha iyó Judea. Ta iyó xaan tunyee iñi Nyoo chi ra Jesús, tacuhva vatyi sanduvaha ra chi ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yucuan ta chaa̱ coyo ra canyisó chihin noo chito chi noo ra ña cuví nacanda. Ta cuñí ra quɨhvɨ ra chichi vehe ta cacun ra chi ra nuu ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Soco ña cuví quɨhvɨ ra vatyi tuvi xaan ñáyɨvɨ. Tyicuan ta candaa̱ ra ityi xiñi vehe. Ta sacuachiyo̱ ra suhva tyiyo. Tyicuan ta sanoo̱ ra chi ra cuhví cuan maa maa nuu ra Jesús mahñu nu tuvi ñáyɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yucuan cuví nu nyehe ra Jesús vatyi cachinó xaan iñi ra chi ra. Ta quichaha catyí ra chi ra cuan: ―Xaa, cha chicoo̱ tɨcahnu iñi tandɨhɨ cuatyun ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tyicuan ta ra casacuahá cuenda ley vehe ñuhu chihin ra fariseo quichaha nacuaan iñi ra: “¿Yóó ra cuví ra ihya? Vatyi cuñí maa ra vatyi cuví saha ra tɨcahnu iñi cuatyi yo. Noo ri maa Nyoo cuví saha ra tɨcahnu iñi cuatyi yo”, ndichi xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Soco ra Jesús chitó ra tuhun chicá xiñi ra. Ta quichaha catyí ra chi ra: ―¿Ñáá tuhun chicá xiñi ndo tyehe caa? ");
INSERT INTO mxtNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","¿Ñáá cha yɨɨ ca catyí yo? ¿Atu yɨɨ ca catyi yo: “Cuatyun cha yaha̱ ndachi”, o yɨɨ ca catyí yo chi noo ñáyɨvɨ: “Ndɨ̱cuita ta ca̱con”? Soco vityin cua sañahi chi ndo vatyi iyó ityi chii cha sahi tɨcahnu iñi cuatyi. Vatyi yuhu Rayɨɨ cha quichi nya gloria cuví. Ta vityin cua sanduvahi chi ra ña cuví caca ihya ―catyí ra Jesús. Tyicuan ta quichaha catyí ra chi ra cha catuví cuan: ―Catyí chuun, ndɨ̱cuita. Na̱quehen chiton ta cua̱nuhu nya vehun. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta caa cuhva ri cuan nducuita̱ ra cha cuhvi̱ cuan, ta naquehe̱n ra chito ra. Ta cuanuhu ra vehe ra, suri sacahnú ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tandɨhɨ ñáyɨvɨ iyo xaan cuñí ñu. Ta yuhví xaan ñu. Ta sacahnú ñu chi Nyoo, ta catyí ñu: ―Vityin ndicha nyehé yo minoo tuhun cha iyo caa ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yaha̱ cuan ta quita̱ ra Jesús vehe cuan. Ta nanyehe̱ ra chi noo ra cha tavá xuhun cuenda gobiernu ñuu Roma. Ta nañí ra Leví. Ta nyaá ra nu tyiyahví ñáyɨvɨ. Ta catyí ra Jesús chi ra: ―Co̱ho chihin ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tyicuan ta nducuita̱ ra Leví. Ta sandoo̱ ra tandɨhɨ cha iyó chi ra. Ta cuahan ra chata ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tyicuan ta savaha̱ ra Leví noo vico cahnu vehe ra cuenda ra Jesús. Ta cuaha vavaha ra catavá xuhun cuenda gobiernu ñuu Roma canyicú ra mesa. Ta canyicú tucu inga ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Soco ra fariseo chihin ra sacuahá ley vehe ñuhu quichaha cahan nyaa ra chi ra cachicá noo chihin ra Jesús ta catyí ra: ―¿Ñáá tuhun chachí ndo ta chihí ndo chihin ra catavá xuhun ta chihin ra cahnu cuatyi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ta ra Jesús nacahan ra, ta catyí ra: ―Ña chiñuhú doctor chi ra iyó vaha. Chi ra cuhví, yucuan ra chiñuhú doctor chi. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yuhu ña vachi tyinyei chi ñu vaha sahá chi, soco vachi tyinyei chi ñu chitó vatyi iyó cuatyi, vatyi tacuhva nasama ñu cuhva iyó ñu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tyicuan ta quichaha candaca tuhun ra chi ra Jesús, ta catyí ra: ―Ra canyicón chi ra Juan savahá ra ayuno, ña cachachí ra ta nanducú ra chi Nyoo, ta tyicuan caa tucu ra fariseo. Soco ra cachicá noo chihin yoho, ndɨ quɨvɨ maa chachi ra ta chihi ra. ¿Ñáá tuhun? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ta nacahan ra Jesús, ta catyí ra: ―¿Atu cuví cha ma cuhva ndo cachi ñu canyicu vico tandaha tatu nyaá ra cha cua tandaha chihin ñu? Ma cuvi. Vatyi sɨɨ cuñí ñu, ta cuñí ñu cachi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Soco cuchaa quɨvɨ cuachiyo ra tandaha cuan nu nyicú ñu. Yucuan ndicha quɨvɨ, ta cusaha ñu ayunar. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tyicuan ta cahan ra Jesús noo cuhva chihin ñu, ta catyí ra: ―Yori cahnya noo sahma chaa, ta chihin cuan naquicu ñu noo sahma chahnu. Vatyi tatu sacuvi ñu tyicuan caa, cundɨyɨ sahma chaa cuan. Ta sɨɨn ri ma cuhva chi chihin sahma chahnu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta tyicuan caa tucu ma cuvi tyihi ñáyɨvɨ vinu chaa chichi ñɨɨ chahnu. Vatyi cutahnya ñɨɨ cuan chihin vinu chaa cuan. Ta tɨvɨ vinu cuan ta tɨvɨ ñɨɨ chahnu cuan ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yucuan chaha tahán chi tyihi yo vinu chaa chichi ñɨɨ chaa. Vatyi tyicuan ta nɨnduvi ta saha cuenda chi tahan. ");
INSERT INTO mxtNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta yori ñu chihi vinu chahnu, ta cuñí ñu coho ñu cha chaa. Vatyi catyí ñu, vaha ca vinu chahnu. Cuñí ca ñu vinu chahnu cuan vatyi ican cuan cuví costumbre cha iyó maa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Noo quɨvɨ cha nyitatu ñáyɨvɨ, yahá ra Jesús mahñu cha tachi̱ ñu. Ta ra cachicá noo chihin ra catohón ra yoco trigu. Ta casacoyó ra chihin ndaha ra. Ta cachachí ra chɨtɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tyicuan ta catyí suhva ra fariseo chi ra: ―¿Ñáá tuhun cha sacuví ndo noo tyiño cha ña tahán chi sacuvi yo quɨvɨ nyitatu yo? ");
INSERT INTO mxtNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ta nacaha̱n ra Jesús, ta catyí ra: ―¿Atu ta sacuaha ca ndo cha sacuvi̱ ra David chihin ra tahan ra quɨvɨ cha chisoco ra? ");
INSERT INTO mxtNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Quɨhvɨ̱ ra chichi vehe Nyoo. Ta quehe̱n ra pan cha chacu̱n ñáyɨvɨ nuu Nyoo. Ta chachi̱ ra. Ta chaha̱ ra chi ra candɨhɨ chihin ra. Ta maa ri maa tata sutu tahán chi cachi pan cuan ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yucuan ta catyí tucu ra Jesús: ―Yuhu cuví Rayɨɨ cha quichi̱ nya gloria. Ta iyó ityi chii vatyi catyi chi noo noo ndo ñáá cha sacuvi ndo quɨvɨ nyitatu yo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inga quɨvɨ cha nyitatu ñáyɨvɨ, quɨhvɨ ra Jesús chichi vehe ñuhu. Ta quichaha sañaha ra chi ñáyɨvɨ. Ta yucuan nanyehe̱ ra chi noo ra cha na ityi chiyo ndaha vaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta ra casacuaha cuenda ley chihin ra fariseo, canducú nyehe ra chi ra Jesús, tatu sanduvaha ra chi ra cuhví cuan quɨvɨ nyitatu ñu. Tyicuan caa ta cuvi tyaa ra cuatyi sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Soco ra Jesús chitó ra tuhun chicá xiñi ra. Ta catyí ra chi ra cha ityi ndaha cuan: ―Ndu̱cuita. Ta cuinanyaun mahñu ihya. Tyicuan ta ra cha ityi ndaha cuan nducuita̱ ra. Ta chicunanyaa̱ ra mahñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tyicuan ta catyí ra Jesús chi ra canyicú cuan: ―Cua nducu tuhin noo tuhun chi ndo. ¿Yoso caa cuhva tahán chi cha sacuvi yo quɨvɨ nyitatú yo? ¿Atu tahán chi vatyi sacuvi yo cha vaha, o cha ña vaha? ¿Atu tahán chi vatyi sacacu yo chi ñáyɨvɨ, o cha cahñi ndɨhɨ yo chi ñu? ");
INSERT INTO mxtNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tyicuan ta ra Jesús nanyehe̱ ra chi noo noo ra canyicú cuan. Ta quichaha catyi ra chi ra cuhví cuan: ―Sa̱nacaa ndahun. Tyicuan ta ra cuhví cuan sanacaa̱ ra ndaha ra. Ta nduvaha̱ ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Soco suhva ra canyicú cuan, cuxaa̱n xaan ra. Ta quichaha̱ candaca tuhun ra chi ra tahan ra: ―¿Yoso caa sacuví yo tacuhva cha ma cuvi ca cahan ra Jesús nuu ñáyɨvɨ? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Quɨvɨ cuan ndaa̱ ra Jesús noo yucu. Ta ñiyaca maa chicán tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cuhva cha cundichin, cana̱ ra chi tandɨhɨ ri ñu nyicón chi ra. Ta nacachi̱ ra uchi uvi tahan ri ra. Ta sacunañi̱ ra chi ra, apóstol ra, ta cuñí chi catyí, ra caca tyiño nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta ihya nyaá sɨvɨ ndɨ uchi uvi tahan ra: Ra Simón ra cha sacunañi̱ ra Cristo Pedro chi, ta yañi ra, ra Andrés, ta ra Jacobo, ra Juan, ra Felipe, ra Bartolomé, ");
INSERT INTO mxtNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ra Mateo, ra Tomás, ra Jacobo sehe ra Alfeo, ta ra Simón ra yɨhɨ̱ cuenda ityi ra cacuñí cuhun cuatyi sɨquɨ gobiernu ñuu Roma cha nyacá ñaha chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ta ra Judas, yañi ra Jacobo, ta ra Judas Iscariote, ra cha naxico̱ tuhun chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Noo̱ ra Jesús yucu cuan chihin ndɨ uchi uvi tahan ra. Ta chicutayucu̱ ra nu ndaa cuan chihin ñu nyicón chi ra. Ta cuaha ri ityi quita̱ coyo ñáyɨvɨ. Quita̱ coyo ñu ñuu Jerusalén ta tandɨhɨ ca ñuu cha iyó Judea, ta ñuu Tiro chihin ñuu Sidón cha nyicú yuhu tyañuhu. Ta chaa̱ ñáyɨvɨ cuan vatyi cuɨñɨ ñu tuhun cahán ra Jesús. Ta tandɨhɨ ñu cuhví cuñí ñu vatyi sanduvaha ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta tandɨhɨ ñu cha yɨhɨ́ tatyi ña vaha chi, nduvaha̱ ñu saha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta tandɨhɨ ñu cuñí ñu tɨɨn ñu chi ra. Vatyi nduvaha ñu chihin tunyee iñi Nyoo, vasɨ tacuhva tɨɨn ri ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tyicuan ta nanyehe̱ ra Jesús chi ra cachicá noo chihin ra. Ta quichaha̱ catyí ra chi ra: ―Tandɨhɨ nyoho cha ndahvi ndo, sɨɨ xaan cuví chi ndo, vatyi tahán chi cha cunyaca ñaha Nyoo añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Tandɨhɨ nyoho cha chisocó ndo vityin, sɨɨ xaan cuví chi ndo. Vatyi coo quɨvɨ cha ma nyehe ca ndo soco. Tandɨhɨ nyoho cha chacú chaa ndo cha cuihya iñi ndo, sɨɨ xaan cuví chi ndo vatyi coo quɨvɨ ta ñahri ca tucuihya iñi coo chi ndo. Ta cuacu ndo chihin cha sɨɨ cuñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Sɨɨ xaan cucuvi chi ndo, quɨvɨ cha tasɨ cuñí ñáyɨvɨ nyehé ñu chi ndo, quɨvɨ tavá ñehe ñu chi ndo nu nyaá ñu, quɨvɨ cahán ñu chi ndo, quɨvɨ catyí ñu vatyi ñáyɨvɨ ña vaha cuví ndo vatyi chinó iñi ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sɨɨ xaan cucuvi chi ndo quɨvɨ nyehe ndo tɨndoho cuan vatyi tyicuan caa tucu sacuvi̱ ñáyɨvɨ ta cha naha. Caha̱n vavaha ñu chi ra cacuvi profeta Nyoo. Ca̱ña ndava ndo chihin cha sɨɨ cuñí ndo. Vatyi cahnu xaan cha cucuhva Nyoo chi ndo gloria. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Soco ndahvi nyoho, ñu tyayɨɨ. Vatyi vityin sɨɨ xaan cuñí ndo chihin tandɨhɨ cha tyayɨɨ ndo. Soco coo quɨvɨ maa maa ri tundoho cunyehe ndo. Vatyi ñahri cuñihi ndo nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ta ndahvi nyoho cha cuñí maa ndo vatyi ñahri cumañí chi ndo cha vityin, vatyi coo quɨvɨ cunyehe ndo soco. Nyoho cha sɨɨ cuñí ndo cha vityin, ndahvi nyoho vatyi coo quɨvɨ cunyehe ndo tucuihya iñi. Ta cuacu chaa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ta ndahvi nyoho vatyi vaha cahán ñáyɨvɨ sɨquɨ ndo. Vatyi tyicuan caa tucu ñáyɨvɨ ta cha naha, vaha xaan caha̱n ñu sɨquɨ ra cha caha̱n cha ña ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Tandɨhɨ nyoho cha chiñí ndo tuhun cahín, catyí chi ndo tyehe caa: Cu̱ñi ndo chi ñu xaan iñi chi ndo. Sa̱cuvi ndo cha vaha chihin ñu cha tasɨ cuñi nyehe chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ca̱han ndo cha vaha chihin ñu cha cahán ña vaha sɨquɨ ndo. Ca̱can tahvi ndo chaha ñu cahán chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tatu yóó cha cañi̱ ɨnchiyo nuu ndo, cuhva tucu ndo inga chiyo nacañi maa ñu. Tatu yóó cha tinyaa chaqueta ñihno ndo, cu̱hva ndɨhɨ ndo camiseta ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cu̱hva ndo ñáá ndɨhɨ cha chicán ñu chi ndo. Tatu tinyaa ñu ñáá cha iyó chi ndo, ma ndacan ndo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tari cuhva cuñí ndo cha sacuvi ñáyɨvɨ cha vaha chihin ndo, tyicuan caa sa̱cuvi ndo cha vaha chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tatu cuñí ndo chi maa ri maa ñu cha cuñí chi ndo, ñahri cha vaha xaan sacuví ndo. Vatyi tyicuan caa nyacuví tucu ñu quiñi iyó, cuñí ñu chi ñáyɨvɨ ñohó nuu ri ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O tatu sacuví ndo cha vaha chihin ñu cha sacuví cha vaha chihin ndo, ñahri cha vaha xaan nyacuví ndo. Vatyi tyicuan caa nyacuví tucu ñu quiñi iyó. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O tatu sacuví ndo tumañi iñi chi noo ñáyɨvɨ, ta yɨhɨ́ iñi ndo vatyi cusacuvi tucu ñu cuan tumañi iñi chi ndo, ñahri cha vaha nyacuví ndo. Vatyi tyicuan caa nyacuví tucu ñu quiñi iyó. Tatu ñáá noo tumañi iñi sacuví ñu chi tahan ñu, nyatú ñu cha nacuhva tucu ñu cuan tumañi iñi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Soco nyoho, cu̱ñi ndo chi ñu xaan iñi chi ndo. Ta sa̱cuvi ndo cha vaha chi ñu. Ta cu̱hva noo ndo chi ñu. Soco ma cuatu ndo ñáá tumañi iñi cunacuhva ñu chi ndo. Tyicuan ta cahnu xaan cha cuñihi ndo nuu Nyoo ta cucuvi ndo sehe vaha Nyoo cahnu. Vatyi Nyoo vaha ñáyɨvɨ cuví ra chihin ñu cha ña nacuhva tyahvi nyoo chi ra ta chihin ñu quiñi iyó. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vaha ñáyɨvɨ cu̱vi ndo chihin ñáyɨvɨ, tari maa Nyoo Sutu yo, vaha ñáyɨvɨ cuví ra chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ma cahan ndo cha caá tahan ndo, tyicuan ta Nyoo ma tɨɨn cuenda ra cha caá maa ndo. Ma soco ndo chi ñáyɨvɨ cha cuhun ñu anyaya, tyicuan ta ma sacuhun Nyoo chi ndo anyaya. Sa̱ha ndo tucahnu iñi chi ñáyɨvɨ. Ta Nyoo cusaha ra tucahnu iñi chi maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cu̱hva ndo cha chiñuhú chi ñáyɨvɨ. Ta tyicuan caa cuhva tucu maa Nyoo cha chiñuhú chi maa ndo. Noo ñáyɨvɨ vaha, tatu xicó ñu ñáá cha xicó ñu chi ndo, tyitu maa chahá ñu chi ndo, tyicuan caa tucu cuhva Nyoo chi ndo. Vatyi tari cuhva cuhva ndo chi ñáyɨvɨ, tyicuan caa cuhva cuhva Nyoo chi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ta chaha̱ ra Jesús cuhva ihya chi ñu, ta catyí ra: ―Noo ra cuaa ña cuví sañaha ra ityi chi nonga ra cuaa. Vatyi nɨnduvi ra ña nyehé ra ityi cuahan ra. Ta cuví canacoyo ra chichi noo xahva. Tyicuan caa tucu noo ra ña chitó ityi Nyoo, vasɨ cuñí ra, soco ma cuvi sañaha ra ityi Nyoo chi nonga ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni noo ra cuatyaa sɨcuela ma cuvi coto ra cha chitó ra cha sañaha chi ra. Vatyi nicaa ni quichaha sacuaha ra. Coto ra soco nya ndɨhɨ sacuaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Yoso caa tyi nyehún cuatyi luhlu cha cuví tari mihin lee ri cha yɨhɨ́ chɨtɨ nuu tahun, ta ña sahun cuenda cuatyi cahnu cha iyó chuun cha cuví tari vitu cahnu cha yɨhɨ́ nuu maun? ");
INSERT INTO mxtNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tatu chɨtɨ nuu maun yɨhɨ́ noo vitu cahnu, yoso caa cuví catyun chi ra yañun: “Nya̱ca, natave mihin lee cha yɨhɨ́ chɨtɨ nuun.” ¡Yoho cha savahún chuun! Ta̱va xihna vitu cahnu cha yɨhɨ́ chɨtɨ nuun. Tyicuan ta cuví nyehe vahun mihin lee cha cutavon chɨtɨ nuu yañun. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Noo yutun vaha chahá tun chɨtɨ vixi, chɨtɨ vaha. Ta noo yutun ña vaha chahá tun chɨtɨ ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tandɨhɨ yutun nɨcohon nuu yo chi tun chihin chɨtɨ ri tun. Vatyi tuñiyaca, ma cuhva tun mangu. Ta nɨ ri noo iñu nduhva ma cuhva tun tɨchaha ndɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ta tyicuan caa tandɨhɨ ñáyɨvɨ vaha, tuhun vaha cahán ñu. Vatyi yɨhɨ́ cha vaha añima ñu. Soco ñáyɨvɨ ña vaha, maa maa ri maa tuhun ña vaha cahán ñu. Vatyi yɨhɨ́ cha caquiñi añima ñu. Chihin yuhu ñu cahán ñu tandɨhɨ cha quiñi caa cha quitá añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Ñáá tuhun cha catyí ndo chii, “Sutu Mañi yuhu, Sutu Mañi yuhu”, tatu ña sacuvi ndo tari cuhva cha catyí chi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ihya cua catyi chi ndo yóó chi ndacu nyoho cha vachi ndo nu nyaí, ta tyasohó ndo cha cahín, ta sacuví ndo cha catyí. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tari noo ra chitó vaha savaha vehe cuví ndo. Vatyi xihna ca chatyá ra cono vavaha ta tahan ra yuu. Ta sɨquɨ yuu cuan savahá ra vehe ra. Ta quɨvɨ coon xaan savi, ta cama xaan ndutya yahá, ta ña nduva vehe cuan vatyi sɨquɨ yuu nanyaá chi. ");
INSERT INTO mxtNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Soco ñu cha chiñí tuhun cahín ta ña sacuví ñu tari cuhva catyí, cuví ñu tari minoo ra ña chitó savaha vehe. Vatyi ña chatyá ra nu quɨhɨ chaha vehe ra. Ta ñima nu yuu savaha̱ ra vehe ra. Ta chaa quɨvɨ cha coon savi. Cama xaan ndutya yaha. Ta chatya chi chaha vehe ra vatyi ñuhu ri cuví. Ta nduva vehe ra vatyi ña cunyee. (Ta tyicuan caa cuví ñáyɨvɨ, tatu sacuví ñu tari cuhva catyí, tyicuan ta cacu ñu. Soco tatu ma sacuvi ñu, ma cacu ñu) ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cuhva cha ndɨhɨ̱ cahan ra Jesús chihin ñáyɨvɨ, ta cuanuhu tucu ra inga chaha nya Capernaum. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta yucuan iyó noo capitán cha nyacá ñaha noo cientu sɨndaro cuatyi. Ta iyó noo musu ra cha cuñí vavaha ra. Ta cuhví ra. Ta cha cuñí cúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quɨvɨ cha chitó capitán cuan tuhun ra Jesús, tachi̱ ra chi suhva ra cacuvi mandoñi ñuu Israel na cucahan ra chihin ra Jesús, vatyi na quichi ra vatyi sanduvaha ra chi musu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Tyicuan ta chaa̱ coyo ra mandoñi cuan nu nyaá ra Jesús. Ta quichaha catyí ra chi ra: ―Iyó noo capitán cuenda ñuu Roma. Ta vaha xaan ñáyɨvɨ cuví ra chihin yo cha cuví yo ñáyɨvɨ Israel. Nyacua savaha̱ ra noo vehe ñuhu yo. Ta tahán chi vatyi tyinyeun chi ra. Vatyi cuhví xaan noo musu ra. Ta cuñí ra vatyi sanduvahun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tyicuan ta cuahan ra Jesús chihin ra. Soco cuhva cha cumañi ca chaa ra nya vehe capitán cuan, capitán cuan tachi̱ ra chi suhva ra tahan ra. Ta quichaha catyi ra chi ra Jesús: ―Tata, catyí capitán vatyi ma sayangon chuun cha cuhun nya vehe ra na. Vatyi ña naña ra cha cuhun, na. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yucuan chaha ña caña iñi ra quichi ra nu nyaún. ¿Atu ma sahun noo tumañi iñi chi ra vatyi noo tuhun cahan run ihya ri, ta nduvaha ri musu ra, na? ");
INSERT INTO mxtNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vatyi maa ra capitán cuví ra. Ta nyacá ñaha rey chi ra. Ta maa ra nyacá ñaha ra chi ra cuatyi ca cha nuu ra. Tatu tava ra tyiño chi noo ra cuatyi cuan, na cuhun ra. Cuhun ra. O tatu catyi ra chi nonga ra na quichi ra, quichi ra. O tatu tachi ra chi inga ra na sacuvi ra tyiño, sacuvi ra. Ta tyicuan caa tucu yoho, tatu catyun na nduvaha musu ra, tyicuan ta nduvaha ra na ―catyí ra tahan capitán cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cha chiñi̱ ra Jesús cha catyí ra cuan ta iyo xaan cuñí ra. Ta nanyehe̱ ra chi ñáyɨvɨ cha nyicú chihin ra, ta catyí ra: ―Ndicha ndicha cuii vatyi chinó xaan iñi capitán cuan. Ta nañihi que chi ni noo ra Israel cha chinó xaan iñi tari ra cuan ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yucuan ta cuanuhu ra tahan capitán cuan. Ta cha nachaa̱ coyo ra nya vehe, ta nanyehe̱ ra vatyi cha nduvaha̱ musu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cha yaha̱ tuhun cuan ta cuahan ra Jesús noo ñuu cha nañí Naín. Ta cuahan tucu ra cachicá noo chihin ra, ta cuaha xaan ñáyɨvɨ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tyicuan ta cuhva cha cua chaa ra yatyin ñuu cuan, nanyehe̱ ra cuaha ñáyɨvɨ quitá coyo ñuu cuan. Ta canyisó ñu noo ndɨyɨ, cuacuchi ñu sehe noo ñaha ndahvi cha chihi̱ yɨɨ. Ta noo tuhun ri maa ra iyó chi ña, ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta cha nanyehe̱ ra Jesús chi ña, ta cundahvi cuñí nyehe ra chi ña. Ta quichaha̱ catyi ra chi ña: ―Ma cuacun. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tyicuan ta tuhva̱ ra ta tɨɨ̱n ra chatun cha yɨhɨ́ ndɨyɨ cuan. Tyicuan ta ra canyisó chi ndɨyɨ cuan chicuitayucu ra. Ta catyí ra Jesús chi ndɨyɨ cuan: ―Ndɨ̱cuita, ra cuehe ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tyicuan ta ndɨcuita̱ ndɨyɨ cuan. Ta nɨcunyaa ra. Tyicuan ta quichaha cahan ra. Ta ra Jesús nacuhva cuenda ra chi ra chi sɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cha nanyehe̱ ñu cha tyicuan caa ta yuhvi xaan ñu cuvi. Ta quichaha sacahnu ñu chi Nyoo. Ta catyí ñu: ―Cahnu xaan ra profeta Nyoo tuví nu nyicú yo ihya. Ta catyí tucu ñu: ―Maa Nyoo, ican vachi nu nyicú yo, vachi tyinyee ra chi yo ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta tandɨhɨ maa ñáyɨvɨ nɨcahnu ityi Judea, chitó ñu cha sacuví ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta ra cachicá noo chihin ra Juan nacatyi̱ ra tuhun cha sacuví ra Jesús. Tyicuan ta cana̱ ra Juan chi uvi tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ta tachi̱ ra chi ra nu nyaá ra Jesús, vatyi cundaca tuhun ra chi ra tatu ican ra cuví Cristo ra cha cusaquichi Nyoo. Vatyi tatu ñima ra, tyi cuatu ra inga ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tyicuan ta ra cha tachi̱ ra Juan, cuahan coyo ra. Ta chaa̱ ra nu nyaá ra Jesús. Ta quichaha catyí ra: ―Ra Juan, ra sacondutyá, tachi̱ ra chi ndi vatyi ndaca tuhun ndi chuun tatu icon cuví Cristo ra cha cusaquichi Nyoo. Vatyi tatu ñimon, cuatu ndi chi inga ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta cuhva cha canyicú ra tachi̱ ra Juan cuan, ra Jesús sanduvaha̱ ra cuaha xaan ñu cuhví, ta cuaha xaan ñu yɨhɨ́ tatyi ña vaha chi. Ta sananyehe̱ ra chi ñu cuaa. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tyicuan ta catyí ra Jesús chi ra tachi̱ ra Juan: ―Cua̱han ndo. Ta na̱catyi ndo chi ra Juan tandɨhɨ cha nyehe̱ ndo, ta tandɨhɨ cha chiñi̱ ndo. Ta ca̱tyi ndo chi ra yoso caa nanyehé ra cuaa, yoso caa nacacá ra coxo, yoso caa nduvahá ra tyahyu coño, yoso caa nacuɨñɨ ra soho, yoso caa nandotó ndɨyɨ, yoso caa cahín tuhun Nyoo chihin ñu ndahvi yoso caa sacacú ra añima ñu. Ta ca̱tyi tucu ndo chi ra vatyi ");
INSERT INTO mxtNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","sɨɨ xaan cuví chi ñu ña chicá uvi iñi nyicón chii ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cuhva cha cuahan coyo ra cha tachi̱ ra Juan, ta quichaha cahan ra Jesús tuhun ra Juan chihin ñáyɨvɨ. Ta catyí ra: ―¿Ñáá cha chaha̱n ndo chinyehe ndo quɨvɨ chaha̱n ndo chiqui ndɨɨ cuan? ¿Atu chaha̱n ndo chinyehe ndo noo ndoo cha naquɨsɨ́ tatyi? ");
INSERT INTO mxtNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿O noo ra cha ñihnó sahma vaha chinyehe̱ ndo vaha? Ñima. Vatyi chitó ndo vatyi ra ñihnó sahma vaha iyó vaha ra ñayɨvɨ̱ ta iyó ra vehe rey. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Atu ña chinyehe ndo chi noo profeta Nyoo? Ican. Ta cahnu ca ra cuví ra ican saha noo profeta. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ican tuhun ra Juan nyaá nuu tutu cha tyaa̱ ra Isaías ta cha naha. Ta catyí Nyoo tuhun ra tyehe caa: Yuhu tachí chi noo ra cahan tuhin ityi nuu nu cuahun. Vatyi cucahan ra tuhun chihin ñáyɨvɨ na nasama ñu cuhva iyó ñu, ta cuatu tuhva ñu quɨvɨ quichun. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Ta catyí chi ndo vatyi chichi cha tandɨhɨ ra cha cacu̱, yori profeta cha cahnu ca ican saha ra Juan. Soco ra cha nyacá ñaha Nyoo añima, vasɨ cuví ra noo ra luhlu ca soco cahnu ca ra ican saha ra Juan ra sacondutyá ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cha chiñi ñu tuhun ihya, tandɨhɨ ñáyɨvɨ ta ra catavá xuhun cuenda gobiernu ñuu Roma cha sacondutya̱ ra Juan nacoto̱ ñu vatyi cuhva sacuví Nyoo vaha xaan. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Soco tandɨhɨ ra fariseo chihin ra sacuahá cuenda ley vehe ñuhu, maa ra cuví ra ña cuñí cha sacondutya ra Juan chi ra, vatyi ña cuñí ra quehen ra cha chahá Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ta catyí ra Jesús: ―¿Ñáá chihin sandu inuu ri chi nyoho, ñu iyó quɨvɨ ihya? ¿Yóó cha tari caa caá ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tari ra cuatyaa cuví nyoho. Vatyi ra cuatyaa nyasɨquɨ́ ndotyin nuyahvi. Ta caná chaa ndotyin chi tahan ndotyin, ta catyí ndotyin: “Tɨvɨ̱ ndi tiyoo ta ña chita̱ chaha ndo. Ta chita̱ ndi yaa cuihya, soco ña chacu ndo.” Ta tyicuan caa ni noo cuhva ña tahán iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Vatyi ra Juan ra sacondutyá, quichi̱ ra ta ña chachí vaha ra. Ta ña chihí ra vinu. Ta nyoho catyí ndo vatyi tatyi ña vaha yɨhɨ́ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta quichi̱ tucu yuhu Rayɨɨ cha quichi nya gloria. Ta chachí ta chihí. Ta nyoho catyí ndo vatyi ra cuahyɨ cuví ta cuví noo ra tuhvá chihí. Ta ña tahán iñi ndo cha cutahín chihin ra iyó cuatyi, ta chihin ra tavá xuhun. Soco vasɨ ni noo ndi ña quehen cuenda ndo, ");
INSERT INTO mxtNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","soco catyí chi ndo vatyi cha chiñi tuñi Nyoo, chaha̱ ra chi ñu naquehen tuhun cahín ta tuhun cahán ra Juan. Ta maa ñu cusañaha ñu chi ndo vatyi vaha cha chiñi tuñi Nyoo ―catyi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Noo ra fariseo cha nañí Simón nacatyi̱ tuhun ra chi ra Jesús noo vico vehe ra. Ta chaa̱ ra Jesús vehe ra, ta chicunyaa ra mesa. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tyicuan ta noo ñaha cata iñi ñuu cuan chitó ña vatyi nyaá ra Jesús yucuan. Ta chaa̱ ña chihin noo yutyi alabastro tyitu yɨhɨ́ ndutya vixi chahán. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta chicunyaa̱ ña yatyin ri chaha ra. Ta quichaha chacu chaa ña vatyi ndu uvi iñi ña cuatyi ña. Ta quitá ndutya nuu ña. Ta chihin ndutya nuu ña nacatya̱ ña chaha ra. Yaha̱ cuan ta sana ityi ña chaha ra chihin ixi xiñi ña. Ta tyayuhu̱ ña chaha ra. Tyicuan ta choso̱ ña ndutya vixi chahán cuan sɨquɨ chaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cuhva cha nyehe̱ ra fariseo cuan cha tyicuan caa, ndichí xiñi ra: “Tatu ndicha ndicha cha Nyoo saquichi chi ra ihya, coto ra yóó ñaha tɨɨ́n chaha ra, vatyi ñaha cuan, ñaha iyó cuatyi cuví ña.” ");
INSERT INTO mxtNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tyicuan ta ra Jesús catyí ra chi ra fariseo cuan: ―Yoho Simón, iyó noo tuhun cua catyi chuun ―catyí ra chi ra. Tyicuan ta nacaha̱n ra Simón: ―Vaha, ca̱tyi chii, Maestro ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ta quichaha catyi ra Jesús tyehe caa: ―Uvi tahan ra yosoyɨcá ra xuhun chi noo ra cha tuhva chahá noo. Ta noo ra cuan yosiyɨcá ra ohon cientu denario. Ta nonga ra yosiyɨcá ra uvi xico uchi ri denario (tari ohon cientu ri pesu). ");
INSERT INTO mxtNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta nɨnduvi tahan ra ña cuví tyiyahvi ra. Ta ra tuhvá chahá noo cuan, saha̱ ra tɨcahnu iñi chi nɨnduvi tahan ra. Ta vityin ca̱tyi chii, yoho Simón ¿nya ra cua cuñi ca chi ra cha chahá noo cuan? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tyicuan ta nacaha̱n ra Simón, ta catyí ra: ―Ra cha cuaha ca saha̱ ra tucahnu iñi chi ―catyí ra. Tyicuan ta catyí ra Jesús: ―Ndicha cha cahún. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tyicuan ta nanyehe̱ ra Jesús chi ñaha sɨhɨ cuan, ta catyi ra chi ra Simón: ―¿Nyehún chi ñaha ihya? Yuhu quɨhvi̱ chichi vehun. Ta ña chahu̱n ndutya cha ndoo chahi tari cuhva costumbre cha iyó chi yo. Ta ñaha ihya nacatya̱ ña chahi chihin ndutya nuu ña. Ta yaha̱ cuan, ta sana ityi̱ ña chihin ixi xiñi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yoho ña tyayuhu̱n ndahi, tari costumbre cha iyó chi yo, soco maa ña nyacua nya cuhva cha quɨhvi̱ ihya ta ña sandɨhɨ ña cha tyayuhú ña chahi. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta yoho ña tyihu̱n aceitye xiñi, soco ñaha ihya tyihi̱ ña ndutya vixi chahán chahi. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ta catyí chuun, yoho Simón, vasɨ cahnu xaan cuatyi ña, soco sahí tɨcahnu iñi chi ña. Yucuan chaha cuñí xaan ña chii. Ta ñu sahí tucahnu iñi chiin ri cuatyi, chiin ri cuñí ñu chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tyicuan ta quichaha catyí ra Jesús chi ña: ―Cuatyun cha yaha̱ sandachi. Vatyi cha saha̱ Nyoo tɨcahnu iñi chuun ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tyicuan ta ra nyicú chihin ra quichaha ndichí xiñi ra: “¿Yóó ra cuví ra ihya? Vatyi sahá ra tucahnu iñi cuatyi ñáyɨvɨ.” ");
INSERT INTO mxtNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tyicuan ta quichaha catyí ra Jesús chi ñaha sɨhɨ cuan: ―Cua̱han vityin, cha cacu̱n vatyi chinó iñun chii. Cua̱han chihin cha vaha ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cha yaha̱ tuhun cuan, ta cuahan ra Jesús chicá noo ra noo noo ñuu cahnu ta noo noo ñuu luhlu. Ta cahan noo ra nuu ñáyɨvɨ. Ta sacoto ra chi ñu tuhun vaha yoso cuhva cuñí Nyoo cunyaca ñaha ra chi ñu. Ta ndɨ uchi uvi tahan apóstol, ra cha tyatyiño̱ ra chi, cuahan coyo ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta cuahan coyo tucu suhva ñusɨhɨ cha sanduvaha̱ ra, ñu cuhvi̱ ta ñu yɨhɨ̱ tatyi ña vaha chi. Ta chihin ñu cuahan cu María noo ñaha ñuu Magdala, cha yɨhɨ̱ ucha tahan tatyi ña vaha chi ta nduvaha̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta cuahan tucu cu Juana ñasɨhɨ ra Chuza ra cuví tyiño cuenda ra Herodes, ta cu Susana chihin cuaha xaan ca ñu cha tyinyeé chi ra chihin ñáá cha iyó chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ta cuaha xaan ñáyɨvɨ quitá noo noo ñuu, vatyi cua nyehe ñu nu cahan ra Jesús tuhun Nyoo. Ta tuvi xaan ñu nyicú ñu, ta quichaha catyi ra chi ñu chihin noo cuhva: ");
INSERT INTO mxtNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Quita̱ noo ra vehe ra. Ta cuahan ra nu iyó tyiño sahá ra, vatyi cua quɨtɨ ra chɨtɨ trigu nu ñuhú ra. Ta cuhva cha quɨtɨ ra canacoyo̱ suhva chɨtɨ cuan yuhu ityi. Ta chañi̱ ñáyɨvɨ sɨquɨ. Ta quichi̱ saa ta chachi̱ tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta suhva ca chɨtɨ cuan canacoyo̱ tɨcu yuu. Caña̱ chɨtɨ cuan. Soco na ityi ri vatyi chiin xaan ñuhu yɨhɨ́ chaha. Ta sɨɨn ri ña cachin. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta suhva ca chɨtɨ canacoyo̱ chichi chɨtɨ iñu, soco quɨvɨ caña̱ tun ɨɨn ri, tu iñu cuan chahñi̱ chi tun. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Soco suhva ca chɨtɨ canacoyo̱ nu ñuhú vaha ta quɨvɨ chahnu tun, vaha xaan chaha̱ tun chɨtɨ. Vatyi noo ri chɨtɨ cuan, cientu chɨtɨ quita̱ chihin ―catyí ra Jesús. Ta cha yaha̱ catyí ra tuhun cuan. Ta quichaha cana chaa ra vatyi na cuɨñɨ ñáyɨvɨ, ta catyí ra: ―Tatu cutuñí iñi ndo, tya̱soho ndo tuhun cahín ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yaha̱ cuan ta ra cachicá noo chihin ra, ndaca̱ tuhun ra chi ra ñáá cha cuñí chi catyí tuhun cha nacatyi̱ ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tyicuan ta quichaha catyí ra: ―Chi nyoho sacotó Nyoo tuhun xehe, yoso caa nyacá ñaha ra. Soco chi tandɨhɨ ca ñu cuan, cuhva ri chahí chi ñu. Tacuhva nyehe ñu ta cuví chi tari cha ña ndichin nyehé ñu, ta cuɨñɨ ñu soco ma cutuñi iñi ñu ñáá tuhun cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Cuhva cha catyi̱ chi ndo, cuñí chi catyí tyehe caa: chɨtɨ cuan tari tuhun Nyoo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ta tari nu canacoyo̱ chɨtɨ trigu cuan yuhu ityi, tyicuan caa cuví noo ñu chiñi tuhun Nyoo. Soco quichi̱ cuihna ta tinyaa̱ ra tuhun Nyoo chi ñu tacuhva cha ma chino iñi ñu. Ta ma cacu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta tari nu canacoyo̱ chɨtɨ cuan tɨcu yuu, tyicuan caa tucu inga ñáyɨvɨ cha chiñí tuhun Nyoo. Ta sɨɨ xaan cuví chi ñu suhva ri quɨvɨ. Soco vatyi ña yɨhɨ́ vaha yoho ñu, suhva ri quɨvɨ chino̱ iñi ñu, soco quɨvɨ cha quichaha nyehe ñu tɨndoho, ta sandɨhɨ ri ñu tuhun cha chinó iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tari nu canacoyo̱ chɨtɨ chichi iñu, tyicuan caa cuví tucu inga ñu chiñi̱ tuhun Nyoo. Chiñí ñu tuhun Nyoo soco ña cuñí ñu sacuvi ñu tari cuhva chiñi̱ ñu. Vatyi yɨhɨ́ ñu, nyaá ca xiñi ñu tuhun tɨndoho ican saha tuhun Nyoo. Ta nonga ñu nyiyo ca iñi ñu cha tyayɨɨ. Ta nonga tucu ñu sɨɨ ca cuñí ñu chica noo yanga ri ñu. Ta tari cha ña chicoo chɨtɨ nuu ñu cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Soco tari nu canacava chɨtɨ nu ñuhú vaha, tyicuan caa cuví noo ñu cha chiñí tuhun Nyoo. Ta vaha añima ñu vatyi chinó iñi ñu chihin tandɨhɨ añima ñu. Ta vaha tyasohó ñu tuhun Nyoo, ta ña naa maa iñi ñu tuhun ra. Ta sacuví ñu tandɨhɨ tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Yori yo cha natyaa yo ñuhu̱ tima ta tixehe yo xiu chito o nonga nu xehe. Natyaa yo ñuhu̱ tima soco cha cananyaa yo noo nu sucun. Ta cuhva quɨhvɨ ñáyɨvɨ chichi vehe soco ndichin. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vatyi ñahri noo cha ñohó xehe, ta cuñún, tyi ma natuvi. Ta ni noo tuhun xehe, ta cuñun, tyi ma quita nu ndichin ta coto yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yucuan chaha tya̱soho ndo tuhun cahín. Vatyi tatu quichaha ndo tuhun cahín, cuaha ca cusañahi chi ndo. Soco tatu ma tyasoho ndo, tyicuan ta cutinyaa Nyoo tandɨhɨ maa chi ndo nyacua nya cha chiin ri cha cuñí maa ndo tyi cumí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tyicuan ta chaa̱ sɨhɨ ra Jesús chihin yañi ra nu nyaá ra. Soco ña cuvi̱ chaa ñu vatyi tuví xaan ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tyicuan ta sacoto ñáyɨvɨ canyicú cuan chi ra Jesús, ta catyí ñu: ―Sɨhun chihin yañun nyicú ñu chata vehe. Ta cuñí ñu cahan ñu chuhun. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ―Tandɨhɨ maa ñáyɨvɨ cha chiñí ta sacuví tuhun Nyoo cha cahín, ican ñu cuví sɨhi, ta ican ñu cuví yañi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cuví chi noo quɨvɨ cuan quɨhvɨ̱ ra Jesús chichi noo canoa chihin ra cachicá noo chihin ra. Ta quichaha catyí ra chi ra: ―Co̱ho ndo inga chiyo miñi ihya. Yucuan ta cuahan coyo ra chihin canoa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta cha nɨ ri ca cha cuahan ra mahñu miñi cuan, tɨɨ̱n ñumahna chi ra Jesús. Tyicuan ta sana iñi ra ta chaa̱ noo tatyi ñihi vavaha. Ta quichaha tyihi chi ndutya chichi canoa cuan. Ta quichaha cuñí nyee canoa cuan vatyi cama xaan ndutya quɨhvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tyicuan ta casandoyo̱ ra chi ra Jesús. Ta quichaha catyi ra: ―¡Maestro! ¡Maestro! Cha cuñí nyee yo chichi ndutya ―catyí ra. Tyicuan ta nducuita̱ ra Jesús. Ta quichaha catyí ra chi tatyi cuan ta chi ndutya cuan, na cutaxin chi. Ta cutaxi̱n ri. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tyicuan ta quichaha catyí ra chi ra cachicá noo chihin ra: ―¿Ñáá tuhun yuhví ndo? ¿Atu ña chinó iñi ndo vatyi yuhu sahá cuende chi ndo? ―catyí ra. Soco ra cuan, yuhvi xaan ra. Ta iyo xaan cuñí ra. Ta quichaha ndaca tuhun ra chi ra tahan ra: ―¿Yóó ra cuví ra ihya? Vatyi nyacua nya tatyi ta ndutya ta quichahá tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tyicuan ta chaa̱ coyo ra ityi Gadara cha nyaá inga chiyo miñi ityi nuu Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ta quita̱ ra chichi canoa cuan. Ta yucuan chaa̱ noo ra cha quichi noo ñuu ityi cuan chisatahan ra chi ra. Ta yɨhɨ́ tatyi ña vaha chi ra. Ta cha naha xaan ña ñihnó maa ra sahma. Nɨ ri ña iyó ra vehe ra. Chicá noo ri maa ra nu ñaña calavari cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ta tuhvá tatyi ña vaha cuan naquɨquɨ chi ra. Ta yucuan chaha chahñí ñu ndaha ra ta chaha ra chihin cadena. Soco tatyi ña vaha cuan chahá fuerza chi ra cha cahnya ra. Ta sacono chi chi ra. Ta chinyaca̱ chi chi ra noo nu yori maa ñáyɨvɨ iyó. Ta cuhva cha nyehe̱ ra chi ra Jesús, chicuɨñɨ̱ chɨtɨ ra nuu ra. Ta quichaha canachaa ra, ta catyí ra: ―¿Ñáá tuhun tyihún chuun chihin yuhu, yoho Jesús, Sehe Nyoo cahnu? Chiquén chuun vatyi ma sanyehun tundoho chii ―catyí ra yɨhɨ́ tatyi ña vaha cuan chi ra Jesús. Ta catyí ra tyehe caa vatyi ra Jesús tachi̱ ra chi tatyi ña vaha cuan, na quita chi ra ndahvi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ta quichaha ndaca tuhun ra Jesús chi tatyi ña vaha cuan, ta catyí ra: ―¿Ñáá nañún? Ta tatyi ña vaha cuan sacahan chi ra cuan, ta catyí ra: ―Nyuhu nañí ndi, Legión. Tyicuan caa catyí ra vatyi cuaha xaan tatyi ña vaha yɨhɨ́ chi ra. Cuenda mil tatyi ña vaha cuan yɨhɨ́ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tyicuan ta tatyi ña vaha cuan catyí chi ra Jesús vatyi ma tuchi ra chi chi nu tɨndoho nu ma cuvi maa quita chi. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ta chicán tatyi ña vaha cuan chi ra Jesús nacuhva ra caquɨhvɨ chi chichi quɨnɨ cha canyicú yuhu miñi cuan. Tyicuan ta chaha ra Jesús permiso cha caquɨhvɨ chi chichi quɨnɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta quita̱ tatyi ña vaha cuan chi ra ndahvi cuan. Ta caquɨhvɨ̱ chi chichi quɨnɨ cuan. Tyicuan ta cachino quɨnɨ cuan. Ta yatyin cuan nyaá noo xahva yuhu miñi cuan. Yucuan canacoyo̱ tɨ chichi miñi cuan. Ta cachihi tɨ chihin ndutya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tyicuan ta ra casahá cumi chi quɨnɨ cuan, yuhví xaan ra. Ta cuahan coyo vavaha ra cua nacatyi ra chi ñáyɨvɨ nya ñuu. Ta tandɨhɨ ri ñáyɨvɨ cha nyehe ra, ta nacatyi ra tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tyicuan ta chaa̱ coyo ñáyɨvɨ cua nyehe ñu ñáá cha cuvi̱ cuan. Tyicuan ta chaa̱ ñu nu nyaá ra Jesús. Ta nañihi̱ ñu chi ra cha yɨhɨ̱ tatyi ña vaha cuan chi. Nyaá ra nuu ra Jesús. Ta ñihnó ra sahma ra. Ta vaha cuñí ra. Ta yuhví xaan ñu cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tyicuan ta tandɨhɨ ñu cha nyehe̱ cha cuvi̱ cuan, nacatyi̱ ñu chi tandɨhɨ ca ñáyɨvɨ yoso caa quita̱ tatyi ña vaha chi ra ndahvi cuan, ta nduvaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Yucuan ta tandɨhɨ ñáyɨvɨ ityi Gadara cuan quichaha catyi ñu chi ra Jesús na cunuhu ra ityi nu quichi ra. Vatyi yuhví xaan ñu chihin cha sacuvi̱ ra chihin tatyi ña vaha cuan. Tyicuan ta ra cha quita̱ tatyi ña vaha cuan chi, catyi̱ ra chi ra Jesús, na cuhva ra cha cuhun ra chihin ra. Soco catyí ra Jesús chi ra: ―Cua̱nuhu nya vehun. Ta na̱cuhva cuendon chi ñáyɨvɨ chuun ñáá cha sacuvi̱ Nyoo chuhun ―catyí ra. Yucuan ta ra Jesús nandɨhvɨ̱ ra chichi canoa cuan. Ta cuanuhu ra chihin ra cachicá noo chihin ra. Tyicuan ta ra ndahvi cha nduvaha cuan, cuanuhu ra nya ñuu ra. Ta ityi cuahan ra nacatyí ra chi tandɨhɨ ñáyɨvɨ ñuu cuan yoso caa sanduvaha̱ ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quɨvɨ cha nachaa̱ ra Jesús cha chaha̱n ra inga chiyo miñi cuan, cuaha xaan ñáyɨvɨ nyatú ñu chi ra. Ta sɨɨ xaan cuñí ñu vatyi nachaa̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tyicuan ta chaa̱ noo ra cha nañí Jairo, ra cuví nuu vehe ñuhu, ta chicuɨñɨ̱ chɨtɨ ra nuu ra. Ta quichaha chacu ndahvi ra nuu ra, na cuhun ra vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Vatyi iyó noo tuhun ri sehe ra, ta iyó uchi uvi cuiya ña. Ta cha cuñí cúvi ña chihin cuehe. Ta cuahan ra Jesús vehe ra. Ta cuaha xaan ñáyɨvɨ cuahan chihin ra Jesús, ta tɨhɨn xaan cuahan ra mahñu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta chihin ñáyɨvɨ cuan cuahan noo ñaha cuhví. Cha iyó uchi uvi cuiya ndoho ña noo cuehe nɨñɨ. Ta cha ndɨhɨ maa xuhun ña sanaa̱ ña, ta ña nduvahá ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Soco chaa̱ ña nu nyaá ra Jesús ityi chata ra. Ta tɨɨ̱n ña sahma ra. Ta caa cuhva ri cuan, ta chicunyasɨ cha chatɨ nɨñɨ ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tyicuan ta quichaha catyí ra Jesús: ―¿Yóó cha tɨɨ̱n sahme? Ta tandɨhɨ ñu cuahan chihin ñu catyí ra: ―Yori. Ta catyí ra Pedro ta ra tahan ra chi ra Jesús: ―Maestro, cuaha xaan ñáyɨvɨ cuahan chuhun, ta tɨhɨn xaan cuahun. Ta suri maa ñu tyandahá ñu chuun. Ta ndacá tuhun con “¿Yóó cha tɨɨ̱n sahme?” ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Soco ra Jesús catyí ra: ―Chitó mai vatyi iyó noo cha tɨɨ̱n sahme. Vatyi tuvi̱ iñi cuahan suhva tunyee iñi cha iyó chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tyicuan ta ñaha sɨhɨ cuan nyehe̱ ña vatyi cha chitó ra. Ta quichaha nɨhɨ ña chihin cha yuhví ña. Ta chicuɨñɨ̱ chɨtɨ ña nuu ra. Ta quichaha nacatyí ña chi ra ñáá tuhun cha tɨɨ̱n ña sahma ra, ta yoso caa nduvaha̱ ña caa cuhva ri cuan. Ta chiñí tandɨhɨ ñáyɨvɨ cuan cha nacatyi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yucuan ta catyí ra Jesús chi ña: ―Yoho sɨhi, cha nduvahu̱n vatyi chinó iñun chii. Cua̱han chihin cha vaha ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nɨ cahán ca ra Jesús tuhun ihya, ta chaa̱ noo ra quita̱ vehe ra cuví nuu vehe ñuhu cuan. Ta quichaha catyí ra chi ra Jairo cuan: ―Sehun cha yaha̱ chihi ña. Ma sayanga con chi Ra Sacuaha chiña ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Soco cha chiñi̱ ra Jesús tuhun cuan. Ta quichaha catyí ra: ―Ma yuhvun. Chi̱no iñun. Ta sehun cua nduvaha ña ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta cuhva cha chaa̱ ra Jesús vehe ra Jairo, ña chaha̱ ra quɨhvɨ ñáyɨvɨ chichi vehe. Maa ri maa ra Pedro ta ra Jacobo ta ra Juan ta maa ra Jairo chihin ñasɨhɨ ra, quɨhvɨ̱ ñu chichi vehe cuan nu catuví cuehe luhlu cha chihi̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta tandɨhɨ ñu chacú chaa ñu cha cuenda vatyi chihi̱ cue. Soco ra Jesús catyí ra chi ñu: ―Ma cua̱cu ca ndo. Vatyi ña chihi̱ cue. Quixí cue ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Soco chacú nyaa ñu tuhun caha̱n ra. Ta ña chinó iñi ñu. Vatyi chitó ñu tyi cha chihi̱ cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tyicuan ta tɨɨ̱n ra Jesús ndaha cue. Ta ñihi cahan ra ta catyí ra chi cue: ―Ndu̱cuita, cuehe luhlu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tyicuan ta nandoto̱ cue. Ta caa cuhva ri cuan ndɨcuita̱ cue. Ta quichaha catyí ra Jesús: ―Cu̱hva ndo cha cachi cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ta sutu cue ta sɨhɨ cue, iyo xaan cuñí ñu. Soco catyi̱ ra Jesús chi ñu vatyi yori maa chihin cahán ñu tuhun cha cuvi̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sandu ɨɨn ri ra Jesús ndɨ uchi uvi tahan ra cachicá noo chihin ra. Ta chaha̱ ra tunyee iñi chi ra vatyi cuví tava ra tatyi ña vaha, ta cuví sanduvaha ra chi ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ta tachi̱ ra tyiño chi ra vatyi na sanduvaha ra chi ñu cuhví, ta cahan ra tuhun Nyoo yoso caa nyacá ñaha ra añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta catyí ra chi tandɨhɨ ra cuan: ―Ñahri cha cuison ndo ityi cuhun ndo, ni yutun ma tuvi ndo. Ni yɨtɨn, ta nɨ ri cha cachi ndo ta ma cuison ndo. Ta nɨ ri xuhun ta ma cuison ndo. Tacuhva ñihnó ri ndo cu̱hun ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ta savaha ri vehe cha chaa ndo, cu̱nyaa ndo yucuan nyacua nya cha chaa quɨvɨ cha cuhun ndo inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ta nu ña cuñí ñu cuɨñɨ ñu tuhun cahan ndo, qui̱ta ndo ñuu cuan. Ta na̱quɨsɨ ndo ñiyaca chaha ndo. Tyehe caa sa̱cuvi ndo na cuvi chi tari minoo seña chi ñu, vatyi ña cuñí ñu tyasoho ñu tuhun Nyoo ―catyí ra Jesús chi tandɨhɨ ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tyicuan ta cuahan coyo ra tandɨhɨ cuii maa ñuu. Ta cahán ra tuhun vaha Nyoo ta yoso caa cuñí chi ta cacu ñu. Ta sanduvaha̱ ra chi ñu cuhvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ra Herodes ra cuví ra nyacá ñaha nɨcahnu ityi Galilea, ñihi̱ ra tuhun cha sacuví ra Jesús. Ta ña ñihi̱ vaha ra cuhva yóó ra cuví ra. Vatyi yɨhɨ́ ñu catyí ñu vatyi ra Juan, ican ra nandoto̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta yɨhɨ́ ñu catyí ñu vatyi ra Elías, ican ra nandoto̱. Ta yɨhɨ́ ñu catyí ñu vatyi inga ra profeta Nyoo ta cha naha, ican nandoto̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Soco catyí ra Herodes: ―Maa mai tyihi̱ tyiño chicahnya sucun ra Juan. ¿Tu tyicuan caa, yóó ra chiñí xain tuhun ihya? ―catyí ra. Ta ra Herodes cuan nducú xaan ra cuhva yoso caa nyehe ra chi ra cha chicá noo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ta cuhva cha nachaa̱ coyo ra chicá tyiño nuu ra Jesús, canacatyi̱ ra chi ra Jesús tandɨhɨ cuii maa cha cuvi̱ nu chaha̱n coyo ra. Tyicuan ta tava̱ sɨɨn ra Jesús chi ra ta cuahan coyo ra yatyin ri noo ñuu cha nañí Betsaida. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Soco cuhva cha ñihi̱ ñáyɨvɨ tuhun vatyi cuahan ra Jesús nyicuan, ta cuahan coyo vavaha ñu nya nu nyaá ra. Tyicuan ta quichaha cahan ra chihin ñu tuhun yoso caa nyacá ñaha Nyoo añima ñáyɨvɨ. Ta sanduvaha̱ ra chi ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta cuhva cha cua iñi xaan, ndɨ uchi uvi tahan ra chicá noo chihin ra quichaha catyí ra chi ra: ―Ca̱tyi chi ñáyɨvɨ ihya na cunuhu ñu cunyitatu ñu, ta na cunducu ñu noo cha cachi ñu noo ñuu cha nyaá yatyin ri cuan. Vatyi ihya ñahri maa cha cachi yo iyó ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tyicuan ta quichaha catyí ra Jesús chi ndɨ uchi uvi tahan ra cuan: ―Cu̱hva ndo cha cachi ñu ―catyí ra. Tyicuan ta quichaha catyi ra chicá noo chihin ra chi ra tahan ra: ―Ñahri maa cha iyó ihya. Ohon tahan ri pan, ta uvi tahan ri tiyaca iyó. Soco ma ñihi cha cachi tandɨhɨ ñáyɨvɨ ihya. Nɨ ri cusata ndi soco ma ñihi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Vatyi ohon mil rayɨɨ nyicú yucuan. (Ta sɨɨn ri nyicú ñusɨhɨ chihin sehe ñu.) Yucuan ta ra Jesús catyí ra chi ra cachicá noo chihin ra: ―Na cunyicu ñáyɨvɨ cha uvi xico uchi tahan ñu noo noo nu cunyicu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tyicuan ta chicunyicu̱ tandɨhɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tyicuan ta quehe̱n ra Jesús ohon tahan pan cuan chihin uvi tahan tiyaca cuan. Ta nanyehe̱ ndaa ra andɨvɨ, ta nacuhva̱ ra tyahvi nyoo chi Nyoo. Tyicuan ta tahvi̱ sava ra pan ta tiyaca cuan. Ta chaha̱ ra chi ra cachicá noo chihin ra na casacha ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tyicuan ta tandɨhɨ ñu chachi̱ ñu. Ta chitu chichi ñu. Yaha̱ cuan ta ndoo̱ ca yɨquɨn ta sacutu̱ ra uchi uvi tahan tica chihin yɨquɨn cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Noo quɨvɨ quita̱ sɨɨn ra Jesús chihin ra cachicá noo chihin ra. Ta quichaha chicán tahvi ra chi Nyoo. Ta nu ndɨhɨ chicán tahvi ra, ta quichaha ndaca tuhun ra chi ra chicá noo chihin ra ta catyí ra: ―¿Ñáá catyí ñáyɨvɨ, yóó ra cuví yuhu? ");
INSERT INTO mxtNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tyicuan ta nacaha̱n ra cachicá noo chihin ra, ta catyí ra: ―Yɨhɨ́ ñu catyí ñu vatyi ra Juan ra sacondutya̱ chi ñáyɨvɨ cuvún. Ta yɨhɨ́ ñu catyí ñu vatyi ra Elías cuvún. Ta yɨhɨ́ ñu catyí ñu vatyi inga ra profeta Nyoo ta cha naha cuvún ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tyicuan ta ndaca̱ tuhun ra Jesús chi tandɨhɨ ra, ta catyí ra: ―Ta nyoho, ¿yóó ra cuví yuhu, cuhva cha cuñi nyoho? Tyicuan ta nacaha̱n ra Pedro, ta catyí ra: ―Yoho cuví ra Cristo ra cha quita̱ nu nyaá Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ta catyí ra Jesús chi ra cachicá noo chihin ra vatyi yori maa chihin cahan ra tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tyicuan ta catyí tucu ra chi ra: ―Yuhu Rayɨɨ cha quichi̱ nya gloria cuví. Ta tahán chi vatyi cuaha xaan tundoho cunyehi. Ta ra cacuví mandoñi ta ra cacuví nuu chi tata sutu chihin ra casacuaha cuenda ley, ma chino iñi ra chii. Ta cucahñi ra chii. Soco nu cu uñi quɨvɨ cunandote ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tyicuan ta quichaha catyí tucu ra chi tandɨhɨ ra: ―Tatu nya nyoho cuñí ndo cunyicon ndo chii, ca̱hnya iñi ndo cha cuñí maa ndo sacuvi ndo, tacuhva cuví sacuvi ndo cha cuñí Nyoo. Ma ndu uvi iñi ndo cha yɨhɨ́ ndo cuende vasɨ ndɨquɨvɨ nyehe ndo tundoho. Vatyi yucuan cuví cruzi cha tahán chi cuiso ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta nya ndo ña cuñí ndo nyehe ndo tundoho cha catyi yuhu, cunyehe ndo tundoho anyaya. Soco nya ndo cuhva ndo ñayɨvɨ̱ ndo cha catyi yuhu, cucacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ñáá cuenda quita chi ndo cha saha ganaa ndo tandɨhɨ cha iyó ñayɨvɨ̱, tatu cuhun añima ndo anyaya? ");
INSERT INTO mxtNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vatyi tatu cahan nuu ndo cha cahán ñayɨvɨ chi ndo cha catyi yuhu, ta cha catyi tuhun cahín, cucahan tucu nuu mai nyehi chi ndo nachaa quɨvɨ quichi inga chaha. Vatyi cuquichi chihin cha cahnu cuví, ta cha cahnu cuví Sutu yo Nyoo ta ángel cuenda ra. Vatyi yuhu cuvi Rayɨɨ cha quichi̱ nya gloria. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta catyí chi ndo vatyi yɨhɨ́ ndo cha nyicú ndo ihya vityin, ma cúvi ndo nyacua nya nyehe ndo yoso caa cuví nu nyacá ñaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Uña quɨvɨ yaha̱ cha catyi̱ ra Jesús tuhun cuan. Ta ndaa̱ ra noo yucu vatyi cua cacan tahvi ra chi Nyoo. Ta cuahan ra Pedro, ra Jacobo ta ra Juan chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta cha nɨ ri ca cha chicán tahvi ra Jesús, nasama cuhva caá sahma ra ta nuu ra. Tyaquɨ xaan cuichin nanduvi sahma ra. Ta xiño xaan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tyicuan ta tuvi uvi tahan ra candatuhún chihin ra, ra Moisés ta ra Elías. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ta ndichin xaan nu tayucú ra. Ta cacahán ra tuhun yoso caa cunyehe ra Jesús tundoho Jerusalén ta cúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta vasɨ cuñí xaan ra Pedro chihin ra tahan ra cacusu ra, soco ña quixí ra. Ta nyehé ra cha ndichin xaan cuan nu nanyaá ra Jesús chihin ra cha tayucú chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cuhva cha cuahan coyo ra tayucú chihin ra Jesús cuan, catyí ra Pedro: ―Maestro, vaha xaan cha nyicú ndi ihya. Na savaha ndi uñi tahan vehe, noo chuun, noo chi ra Moisés, ta noo chi ra Elías ―catyí ra. Soco ña chitó ra Pedro tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta cha nɨ ri ca cha cahán ra ta quichi̱ noo vico sɨquɨ ra. Ta yuhví xaan ra cacuví cha caquɨhvɨ ra chichi vico cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tyicuan ta chichi vico cuan chiñi̱ ra noo ndusu cha catyí: ―Ican ra ihya cuví Sehi, ta cuñí xain chi ra. Tya̱soho ndo tuhun cahán ra ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta cha yaha̱ caha̱n ndusu cuan, nanyehe ra Pedro ta ra ndɨhɨ chihin ra vatyi noo ri ca maa ra Jesús nanyaá yucuan. Ta yori maa chihin cacahan ra tuhun cha nyehe̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta cha inga quɨvɨ cha noo̱ ra Jesús yucu cuan, cuaha xaan ñáyɨvɨ chisataha̱n chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tyicuan ta chichi cha cuaha ñáyɨvɨ cuan, noo ra cana chaa xaan ra, ta catyí ra: ―Maestro, sa̱ha tumañi iñi chii. Nye̱he ndahvi chi sehi. Vatyi noo tuhun maa ra iyó chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta yɨhɨ́ ndɨhɨ tatyi ña vaha chi ra. Ta sacanachaa chi chi ra. Ta tuchí chi chi ra nyasava. Ta quitá tɨñɨ yuhu ra. Ta quiñi xaan nyacuví chi chihin ra. Ta ña cuñí maa tatyi ña vaha cuan saña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cha cahi̱n chihin ra cachicá noo chuhun na tava ra tatyi ña vaha cuan, soco ña cuví chi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tyicuan ta nacaha̱n ra Jesús ta catyí ra: ―Nyoho, ñu ña chinó iñi cuví ndo. Ta ni caa ni quiñi iyó ndo. ¿Yoso ca tahan quɨvɨ cunyai chihin ndo ta cunyee iñi tɨsɨhɨ ndo nyacua nya cha cutuhva ndo ta chino iñi ndo chii? Ta catyí ra chi ra cuan: ―Nya̱ca chi sehun. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta cuhva cha cua tuhva ra cuehe cuan nu nyaá ra Jesús, ta tuchi̱ tatyi ña vaha cuan chi cue nya sava. Soco ra Jesús tava̱ ra chi tatyi ña vaha cuan. Ta sanduvaha̱ ra chi cue. Tyicuan ta nacuhva̱ cuenda ra chi cue chi sutu cue. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ta tandɨhɨ ñáyɨvɨ, iyo xaan cuñí ñu cha cahnu cha sacuví Nyoo chihin ñu. Cha nɨ ri ca cha iyo cuñí ñáyɨvɨ cha sacuvi̱ ra Jesús, ta quichaha catyí ra chi ra cachicá noo chihin ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tya̱soho vaha ndo tuhun cahín. Ta ma naa iñi ndo. Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria, cucuhva cuenda ñu chii ndaha ra xaan iñi chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Soco ra cachicá noo chihin ra ña cutuñí iñi ra ñáá tuhun cahán ra. Vatyi Nyoo ña chaha̱ ra cha cacutuñi iñi ra. Ta cayuhví ra ndaca tuhun ra chi ra Jesús ñáá cha cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yucuan ta ra cachicá noo chihin ra quichaha cacuvi yuhu ra tuhun nya ra cahnu ca cuví chichi cha uchi uvi tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tyicuan ta chitó ra Jesús cha chicá xiñi ra, ta quehe̱n ra chi noo ra cuehe luhlu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ta quichaha catyí ra chi tandɨhɨ ra cuan: ―Tatu chihin sɨvi natɨɨ́n cuenda ndo chi noo ñáyɨvɨ ña cahnu sahá chi tari ra cuehe luhlu ihya, chi yuhu natɨɨ́n cuenda ndo. Ta tatu natɨɨ́n cuenda ndo chii, chi maa Nyoo cha saquichi̱ chii, natɨɨ́n cuenda ndo. Vatyi ra cha ñima ri tuhun sahá maa ndo tuhun, ican ra cuví ra cahnu nuu Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yucuan ta ra Juan catyí ra chi ra Jesús: ―Maestro, nyehe̱ ndi chi noo ra cuan. Cahán ra sɨvun ta tavá ra tatyi ña vaha. Soco ña chaha̱ ca ndi. Vatyi ñima chihin yo chicá noo ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tyicuan ta catyí ra Jesús chi ra: ―Ma casɨ ndo nu cahan ra. Vatyi yóó ra ña cahán chi yo, tumañi iñi chi yo cuahan ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tuvi iñi ra Jesús vatyi cha nyañaa yatyin cha tahán chi cunuhu ra gloria, ta sandunɨɨ ra iñi ra. Ta quehen ra ityi ta cuahan ra Jerusalén nu cucuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta tachi̱ ra tyiño na cuhun coyo ra cachicá noo chihin ra ityi nuu ca noo ñuu ityi Samaria. Vatyi canducu ra nu nyitatu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Soco ñu Samaria cuan, ña cuñí ñu cha ndoo ra yucuan, vatyi tuví iñi ñu vatyi Jerusalén cuahan coyo ra, ta ñu Samaria ña cuví nyehe ñu chi ñu Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cuhva cha chitó ra Jacobo ta ra Juan cha ña chahá ñu Samaria cuan cha ndoo ra yucuan, cuxaan ra. Ta quichaha catyí ra chi ra Jesús: ―Sutu Mañi yuhu, ¿atu cuñun cha sacuvi yo tari sacuvi̱ ra Elías? cacan yo chi Nyoo na saquichi ra ñuhu̱ andɨvɨ sɨquɨ ñáyɨvɨ Samaria cuan, vatyi cayu ñu vatyi ña cuñí ñu cha ndoo yo ñuu ñu ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tyicuan ta nanyehe̱ ra Jesús chi ra. Ta cahan ra chi ra ta catyí ra: ―Taxi ri ndo. Vatyi ña cutuñi iñi ndo ñáá tyiño vachi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria, ña vachi vatyi sanai añima ñáyɨvɨ, Soco vachi vatyi sacaqui chi ñu ―catyí ra. Tyicuan ta cuahan coyo ra inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta cuhva cha cachica ityi ra, quita noo ra, ta catyí ra chi ra Jesús: ―Sutu Mañi yuhu, cuñí cunyiquen chuun. Ta cuhin chuhun tandɨhɨ ri ityi cuahun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yucuan ta catyí ra Jesús chi ra: ―¿Atu ndichon? Vatyi yuhu ñahri maa cha iyó chii. Ñaña iyó vehe tɨ. Ta saa iyó taca tɨ. Soco yuhu Rayɨɨ cha quichi̱ nya gloria ñahri maa nu cava xiñi iyó ―catyí ra chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tyicuan ta catyí ra Jesús chi inga ra: ―Co̱ho chihin. Tyicuan ta nacaha̱n ra cuan ta catyí ra: ―Tata, cua̱tu noo chii, na cuhun xihne cucuchi chi suti ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tyicuan ta ra Jesús nacaha̱n ra ta catyí ra chi ra: ―Sa̱ndoo chi ñu ña ñohó nuu chi Nyoo natyihi maa ñu chi tahan ndɨyɨ ñu chichi ñuhu. Soco yoho cua̱han cua cahan tuhun Nyoo chihin ñáyɨvɨ nacuhva cuenda ñu chi ñu chi Nyoo na cunyaca ñaha ra chi ñu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tyicuan ta quichaha catyí inga ra chi ra Jesús: ―Tata, cuñí cunyiquen chuun. Soco cuhva xihna na cuhin cucahin chihin ñu vehi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tyicuan ta ra Jesús catyí ra: ―Tari noo ra tahví ñuhú chihin arado, tatu nanyehe chata ra ña quita vaha yucun nu sahá tyiño ra. Ta tyicuan caa cuví noo ra nyicón chii, tatu yɨhɨ́ iñi ra cha sandoo̱ ra, ña yɨhɨ́ vaha iñi ra cha cuví cunyaca ñaha Nyoo chi ra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cha yaha̱ tuhun cuan ta nacachi̱ Sutu Mañi yo Jesús chi inga uñi xico uchi tahan ca ra. Ta tachi̱ ra chi uvi uvi ra noo noo ityi cuahan ra tandɨhɨ ñuu ta tandɨhɨ ityi nu tahán chi cuhun ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta catyí ra chi ra: ―Tari noo itu cahnu vavaha, tyicuan caa nu tyiño sahí. Soco ña cuaha musu. Yucuan chaha ca̱can ndo chi Nyoo na saquichi ca ra musu. Vatyi tyinyee ra chi ndo cahan ndo tuhun ra chihin ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ta cua̱han ndo ta nye̱he ndo vatyi cua sacuhin chi ndo tari mbee mahñu lobo. Vatyi lobo tuhvá tɨ chachí tɨ chi mbee. Ta tyicuan caa cucuñi ñáyɨvɨ satasɨ iñi ñu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta ma cuiso ndo ni yono ta ni cha quɨhɨ xuhun ndo, ni inga ityi ndichan ndo. Sa̱numi ndo. Ta ma cohon vaha ndo ityi ndatuhun ndo tuhun cha ñima ri tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cuhva cha quɨhvɨ ndo chichi vehe noo ñáyɨvɨ, ca̱han vaha ndo chihin ñu. Ta ca̱tyi ndo, na coo cha vaha añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta tyicuan caa tatu iyó ñáyɨvɨ vaha vehe cuan, ndoo cha vaha cuan chihin ñu. Soco tatu yori ñu vaha añima, ma ndoo cha vaha chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ta ndo̱o ndo suri maa vehe cuan. Tatu chaha ñu cha cachi ndo, ca̱chi ndo. Tatu chaha ñu cha coho ndo, co̱ho ndo yucuan. Vatyi ra sahá tyiño, iyó ityi chi ra cha cachi ra cha sahá ganaa ra. Ɨɨn ri maa vehe cuan cunyaa ndo nyacua nya cha chaa chi quɨvɨ cha cuhun ndo inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ta nu chaa ndo noo ñuu ta vaha cahan ñu chihin ndo, ca̱chi ndo ta co̱ho ndo tandɨhɨ cha cuhva ñu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ta sa̱nduvaha ndo chi ñu cuhví ñuu cuan. Ta ca̱tyi ndo chi ñu: “Cha nyañaa yatyin Nyoo ra cunyaca ñaha añima ndo.” ");
INSERT INTO mxtNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Soco tatu chaa ndo noo ñuu ta ña cuñí ñu tyasoho ñu tuhun cahan ndo, qui̱ta ndo ityi cahnu. Ta ca̱tyi ndo chi ñu: ");
INSERT INTO mxtNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nyacua nya ñiyaca ñuu ndo cha iñi chaha ndi, ta cunaquɨsɨ ndi. Vatyi tari noo seña vatyi ndoo cuatyi ndo sɨquɨ ndo. Vatyi Nyoo nyañaa yatyin ra chi ndo ta ña tyasoho̱ ndo tuhun cahán ra yoso caa cuñí ra cunyaca ñaha ra añima ndo.” Tyicuan caa ca̱tyi ndo chi ñu ―catyí ra Jesús chi ra nyicón chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta quichaha catyí tucu ra chi ra: ―Quɨvɨ tachi tuñi Nyoo chi ñáyɨvɨ, yaha ca cuhva cunyehe ñáyɨvɨ ñuu cuan tundoho, ta ñima ca ñáyɨvɨ chiyo̱ ta cha naha ñuu Sodoma, ñu chihi̱ cha catyi cuatyi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ta catyí ra: ―¡Ndahvi nyoho, ñáyɨvɨ ñuu Corazín! Ta ¡ndahvi nyoho, ñáyɨvɨ ñuu Betsaida! Vatyi nyehé ndo nyatu cahnu, ta ña nasamá ndo cuhva iyó ndo. Soco ñáyɨvɨ ñuu Tiro ta ñuu Sidón cha sanaa̱ Nyoo ta cha naha cha cuenda cuatyi ñu, ñahri nyatu cahnu nyehe̱ ñu. Soco tyehe ta nyehe̱ ñu quɨvɨ cuan cha nyehé nyoho vityin, tañi tyehe ri ndɨhvɨ noo ñu sahma tucuihya iñi ta cunyaa ñu nu ñiyaa. Tari cuhva costumbre iyó maa ñu, noo seña vatyi ndu uvi iñi ñu cuatyi ñu cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yucuan chaha, nyoho ñuu Corazín chihin ñuu Betsaida, ñihi ca cutachi tuñi Nyoo chi ndo ican saha ñáyɨvɨ Tiro ta ñáyɨvɨ Sidón cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta nyoho ñu ñuu Capernaum, cuñí maa ndo vatyi cundaa ndo nyacua nya andɨvɨ. Soco cunoo ndo nyacua nya anyaya, vatyi ña quichahá ndo tuhun Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ta catyí ra chi ndɨ uñi xico uchi tahan ra cuan: ―Ñáyɨvɨ cha tyasohó tuhun cahán nyoho, tuhun cahán yuhu tyasohó ñu cuví cuan. Ta ñu ña quichahá tuhun cahán nyoho, tuhun cahán yuhu ña quichahá ñu cuví cuan. Ta ñu ña quichaha tuhun cahán yuhu, tuhun cahán ra cha saquichi̱ chii, ña quichahá ñu cuví cuan ―catyí ra Jesús chi tandɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yucuan cuví nu nachaa̱ coyo ndɨ uñi xico uchi ra cha chicaha̱n tuhun Nyoo chihin ñáyɨvɨ. Ta sɨɨ xaan cacuví chi ra. Ta cacatyí ra chi ra Jesús: ―Sutu Mañi yuhu, nyacua nya tatyi ña vaha ta quichahá tuhun cahán ndi tatu cahán ndi sɨvun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tyicuan ta catyí ra Jesús chi ra: ―Ay, yuhu nyehi̱ andɨvɨ nu cana̱ cava cuihna, ra nañí Satanás. Tari noo tacha, tyicuan caa cana̱ cava ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ta yuhu, chahi̱ fuerza chi ndo vatyi cuví chasaha ndo chi ra ña vaha cuan. Ta cuví cuaca chaha ndo sɨquɨ coo ta tɨsuhma, ta ñahri cha cuvi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Soco ma sɨɨ xaan cuvi chi ndo vatyi cuví tava ñehe ndo tatyi ña vaha cuan. Sɨɨ ca cu̱vi chi ndo vatyi nyaá sɨvɨ ndo nu libru Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Cuhva cuan sɨɨ xaan cuñí ra Jesús sahá Tatyi Ii Nyoo, ta catyí ra: ―Sacahní chuun, Sutu Mañi yuhu, vatyi nyacá ñahun andɨvɨ ta ñuhu ñayɨvɨ̱. Vatyi maun sañahún tuhun maun chi ñu ndahvi ihya. Ta ña sañahún chi ra chitó ta ra cha chiñi tuñi. Tyicuan caa Sutu Mañi yuhu vatyi tyicuan caa cuhva cuñún ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta catyí ra Jesús chi tandɨhɨ ra sacuví tyiño nuu ra: ―Tandɨhɨ maa tuhun cuan chaha̱ Suti chii. Yori ñohó nuu chii, noo tuhun ri maa Suti ñohó nuu chii. Ta yori ñohó nuu chi Suti, noo tuhun ri mai ñohó nui chi ra. Ta chi ñáyɨvɨ cuñí mai sacote tuhun ra, chi ñu cuan cusacote ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tyicuan ta nanyehe̱ ra chi ra cachicá noo chihin ra. Ta catyi ra chi ra: ―Sɨɨ xaan cuñí nyoho ta ñáyɨvɨ cha iyó vityin vatyi nyehé ndo cha sacuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vatyi cuaha xaan rey ta ra profeta Nyoo ta cha naha cuñi̱ ra nyehe ra cha nyehé nyoho vityin. Soco ña nyehe̱ ra. Ta cuñí ra cuɨñɨ ra tuhun cha chiñí nyoho vityin. Soco ña chiñi̱ ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tyicuan ta chaa̱ noo ra sacuahá cuenda ley vehe ñuhu. Ta quichaha ndaca tuhun ra chi ra Jesús, Vatyi nducu nyehe ra chi ra. Ta catyí ra: ―Maestro, ¿yoso caa cunyacuvi ta cuhin nu coi noo ñayɨvɨ̱ cha ma naa ca maa? ");
INSERT INTO mxtNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ―¿Ñáá catyí nu ley? ¿Yoso caa tuhun cha sacuahún? ");
INSERT INTO mxtNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tyicuan ta nacaha̱n ra sacuaha cuenda ley cuan ta catyí ra: ―Catyí ley, cu̱ñi yo chi Nyoo chihin tandɨhɨ añima yo ta chihin cha nɨɨ iñi yo, ta chihin tandɨhɨ fuerza yo, ta chihin cha tandɨhɨ cha chiñi tuñi xiñi yo. Ta cu̱ñi yo chi ñáyɨvɨ tahan yo tari cha cuñí yo chi maa yo. Tyicuan caa catyí chi ―catyí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tyicuan ta catyí ra Jesús chi ra: ―Ndicha cha cahún. Tyicuan caa sa̱cuvun ta cacu añimon ta coun ñayɨvɨ̱ cha ma naa ca maa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Soco ra sacuaha cuenda ley cuan cuñí ra savaha ra chi ra, ta quichaha catyi tucu ra chi ra Jesús: ―¿Yóó cha cuví ñáyɨvɨ tahin? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ―Noo ra quita̱ ra Jerusalén ta cuahan ra nya ñuu Jericó. Ta taha̱n ra chi ra suhu. Ta suhu̱ ra tandɨhɨ cuii maa cha nyiso̱ ra, nyacua nya sahma ra. Ta cañi̱ ra chi ra nyacua chacu̱n taxin ra chi ra. Ta sandoo̱ maa ra chi ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tyicuan ta yaha̱ noo tata sutu ityi cuan. Soco cuhva cha nanyehe̱ ra chi ra catuví cuan nya sava ri yaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tyicuan ta yaha̱ tucu nonga ra cha yɨhɨ́ cuenda vehe ñuhu, cha nañí levita. Soco cha nanyehe̱ ra chi ra catuví cuan suri nya sava ri yaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tyicuan ta quichi tucu noo ra Samaria. Ta cua yaha tucu ra suri ityi cuan. Ta nanyehe̱ ra chi ra catuví yucuan, ta quichi nundahvi cuñi ra nyehe ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta tuhva̱ ra nu catuví ra, ta quichaha saha ra tatan chi ra. Ta tyihi̱ ra aceitye ta vinu nu cahvi chi ra. Ta sahvi̱ ra noo sahma chata ra. Yaha̱ cuan ta sandaa ra chi ra burru sana ra, ta naquehe̱n ra chi ra, ta cuahan ra chihin ra nu nyaá noo vehe. Ta yucuan saha̱ cuenda ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta cha inga quɨvɨ cha cuñí cuhun ra Samaria cuan. Ta tava ra uvi tahan xuhun. Ta chaha̱ ra chi chitoho vehe cuan. Ta catyí ra chi ra: “Sa̱ha cuenda vahun chi ra ihya. Ta cu̱hvon cha cachi ra. Ta sa̱ton tatan chi ra na nduvaha ri ra. Tatu cuñí ca chi xuhun, tyiyahvi̱ mai chuun nandichi”, catyí ra. Yucuan ta cuahan ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nu ndɨhɨ̱ nacatyi̱ ra Jesús tuhun ihya, quichaha ndaca tuhun ra chi ra sacuaha cuan, ta catyí ra: ―Vaha. ¿Chichi cha uñi tahan ra cuan, nya ra cuví ra tahan ra ndahvi cuan? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tyicuan ta quichaha catyi ra sacuaha cuan: ―Ra cha cundahvi cuñi chi ra ―catyí ra. Tyicuan ta quichaha catyi ra Jesús: ―Cu̱ahan ta sa̱cuvi tucu yoho tyicuan caa chihin ñáyɨvɨ cha iyó tundoho chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ta quehe̱n ra Jesús ityi cuahan ra. Ta chaa̱ ra noo ñuu. Ta yucuan iyó noo ñaha cha nañí Marta. Ta chaa̱ ra vehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta cu Marta iyó noo cuhu ña cha nañí María. Ta cu María chicunyaa̱ ña yatyin ri chaha ra Jesús, vatyi cuɨñɨ ña tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Soco cu Marta cuaha xaan tyiño nyaá sacuvi ña. Ta chaa̱ ña nu nyaá ra Jesús, ta quichaha catyí ña chi ra: ―Tata. ¿Atu ña chicá xiñi yoho vatyi cuhi sandoó maa ña chii chihin tyiño? Ca̱tyi chi ña na tyinyee ña chii ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Soco ra Jesús catyí ra chi ña: ―Marta, Marta, chicá xaan xiñun ta cutyiño xaan cuñún chihin tyiño chiña. ");
INSERT INTO mxtNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Soco iyó noo tuhun cha tahán chi caca xiñi yo. Ta cu María ihya nacachi̱ ña tyiño vaha ca sacuvi ña cha tyasohó ña tuhun cahín. Ta yuhu ma cuvi tinyai chi ña ―catyí ra Jesús chi cu Marta. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cuví noo chaha cha chicán tahvi ra Jesús. Ta cuhva cha ndɨhɨ̱ chican tahvi ra, ta quichaha catyí noo ra chicá noo chihin ra chi ra: ―Sa̱ñaha chi ndi yoso caa cacan tahvi ndi chi Nyoo. Tari sañaha̱ ra Juan chi ra chica̱ noo chihin ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tyicuan ta catyí ra Jesús chi ra: ―Cua cuhve cuhva chi ndo yoso caa. Tyehe caa ca̱can tahvi ndo: Sutu Mañi yuhu, yoho cha nyaun andɨvɨ. Sacahnu xaan ndi chuun. Na quichi quɨvɨ cha nyaca ñahun ihya sɨquɨ ñuhu ñayɨvɨ̱. Na sacuvi ñáyɨvɨ ihya sɨquɨ ñuhu ñayɨvɨ̱ tandɨhɨ cuhva cuñí maun, tari cuhva cuví gloria. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cu̱hva cha cachi ndi tacuhva yoso cuhva yaha ndi noo noo quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sa̱ha tucahnu iñi chi ndi. Tari maa ndi sahá ndi tucahnu iñi chi ñu tasɨ iñi chi ndi. Ma cuhvon cha nducu nyehe ra ña vaha chi ndi, soco sacacu chi ndi tacuhva ma sacuvi ndi cuatyi nuun. Tyicuan caa cacan tahvi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta catyí tucu ra ñandɨhɨ: ―Sa̱ha yo tuhun tyi nyoho iyó noo amigon, ta chaa ra vehun cha ñuu ta catyí ra chuun: “Xaa, sa̱ha tumañi iñi chii, cu̱hva noo uñi tahan pan chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Vatyi noo ra tahin nɨchaa̱ ra vehi. Ta cañi xaan quichi ra. Ta ñahri maa cha iyó chii cuhve chi ra.” ");
INSERT INTO mxtNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta yoho cunacahun ta catyun chi ra: “Ma sayangon chii, ndee. Vatyi nyasɨ́ yuvehi. Ta nɨquixi chihin sehi. Ta ña cuvi nducuite ta cuhve cha cuhve chuun cha vityin.” Tyicuan caa cucatyun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta catyí yuhu chuun. Vasɨ ra tahun cuví chi ra, ma nducuiton ta cuhvon chi ra cha numi ri. Soco tatu ndoo̱ ra yucuan, ta ma cundihñi ra cacan ra chuun, sacachan ra yuvehun ta cana chaa ra chuun tacuhva cha ma cuvi cusun, ta cundihñun cha sacachan ra yuvehun, tyicuan ta nducuiton ta cuhvon chi ra, tacuhva cha ma sayanga ca ra chuun. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ta tyicuan caa tucu nyoho, ca̱can ndo chi Nyoo. Ta cuhva ra chi ndo. Na̱nducu ndo ta ñihi ndo. Sa̱cachan ndo yuvehe ta nuña. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vatyi tatu chican ndo, ñihi ndo. Tatu nducu ndo, ñihi ndo. Ta tatu sacachan ndo yuvehe, nuña yuvehe. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tyicuan caa tucu nyoho cha iyó sehe ndo. Chahá ndo cha vaha chi sehe ndo. Ña tuhvá ndo chahá noo yuu chi sehe ndo tatu chican ndotyin pan. Ta ña tuhvá ndo chaha ndo noo coo chi sehe ndo, tatu chicán ndotyin tiyaca. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ta ña tuhvá ndo chaha ndo noo tɨsuhma chi sehe ndo tatu chicán ndotyin ndɨvɨ cachi ndotyin. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nyoho cha quiñi iyó ndo, soco chitó ndo yoso caa cuhva ndo cha vaha chi sehe ndo. Ta vihi ca Sutu Mañi yo cha nyaá andɨvɨ, cuaha ca cha vaha cuhva ra chi ndo tatu cacan ndo chi ra. Ta cuhva ra Tatyi Ii ra cunyaa añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ra Jesús tavá ra tatyi ña vaha cha yɨhɨ́ chi noo ra cha ñɨhɨ sahá cuihna. Ta cuhva cha quita̱ tatyi ña vaha cuan chi ra ñɨhɨ cuan, nacaha̱n ra. Tyicuan ta ñáyɨvɨ, iyo xaan cuñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta yɨhɨ́ ñu catyí ñu: ―Ra ihya, tavá ra tatyi ña vaha soco chihin fuerza ra Beelzebú ra cuví nuu chi cuihna ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta yɨhɨ́ ñu cuñí ñu nducu nyehe ñu chi ra, ta chica̱n ñu chi ra Jesús na savaha ra noo seña chi ñu chihin tunyee iñi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Soco ra Jesús chitó ra tuhun chicá xiñi ñu. Ta quichaha catyi ra chi ñu: ―Tatu gobiernu ta cacusɨɨn ra, cuaha ri ityi nanduvi ra, cucañi tahan ra chihin tahan ra, ta cundɨhɨ tuhun cha cunyaca ñaha ra. Tatu noo vehe ta cacusɨɨn ñu chihin tahan ñu, cutɨvɨ nu nyicú ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta tyicuan caa tucu cuihna. Tatu tandɨhɨ ra cacusɨɨn ra chihin tahan ra cundɨhɨ fuerza cha iyó chi ra. Ta ihya catyí chi ndo tyehe caa vatyi nyoho catyí ndo vatyi chihin fuerza ra Beelzebú tavé tatyi ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Soco tyehe ta tavé tatyi ña vaha tari cuhva catyí ndo, nda̱ca tuhun ndo chi ra nyicú chihin ndo yóó chi fuerza tavá maa ra tatyi ña vaha. Maa ra sacoto ra chi ndo cha ndicha vatyi nyoho tondo ri chicá xiñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Soco catyí chi ndo vatyi yuhu tave tatyi ña vaha chihin fuerza Nyoo. Ta cuñí chi catyí cuan vatyi ndicha cuii Nyoo ra nyacá ñaha añima ñáyɨvɨ cha chaa̱ ra nu nyicú ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tatu noo ra iyó vavaha fuerza chi ra ta nyisó ra mityi ra, ta sahá cumi ra vehe ra. Ñohó xehe vaha ndaha tyiño ra chichi vehe ra tacuhva cha ma cuvi tinyaa ra suhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Soco tatu quichi inga ra cha cuaha ca fuerza iyó chi, ta cañi tahan ra chihin ra, ta cuvi chasaha ra chi ra, tyicuan ta tinyaa ra ndaha tyiño ra, ta sacha ra chi ra tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ñáyɨvɨ ña sahá tyiño chihin, satɨvɨ́ ñu tyiño sahí. Ta ñu ña tyinyeé chii cha cahán ñu tuhun Nyoo chihin ñáyɨvɨ, cuñí chi catyi vatyi ña chahá ñu cha coto ñáyɨvɨ tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Tatu noo tatyi ña vaha quita̱ chi noo ñáyɨvɨ, chicá noo chi noo ñuhu ityi, nanducú chi noo nu nyitatu chi. Soco ña nañihi maa chi nu nyitatu chi, tyicuan ta ndichi xiñi chi: “Cunuhu tiqui nya vehi nu quite̱.” ");
INSERT INTO mxtNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yucuan ta nachaa chi añima nu quita̱ chi. Ta nanyehe̱ chi vatyi ndɨɨ xaan ta vii xaan. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tyicuan ta cua naquehen chi ucha ca tahan tatyi ña vaha cha yaha ca cuhva ta ican saha maa chi. Tyicuan ta ɨɨn ri quɨhvɨ tandɨhɨ chi añima ñu cuan. Yucuan chaha yaha ca cuhva nanduvi ñu ican saha cha cuvi̱ maa ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cha nɨ ri ca cha cahán ra Jesús tuhun cuan, ta cana̱ chaa noo ñaha cha ñohó mahñu ñáyɨvɨ cuan. Ta quichaha catyí ña: ―Ñana cha sɨɨ cuví chi ñaha cha sacacu chuun ñaha cha chaha̱ caxun ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Soco ra Jesús catyí ra: ―Sɨɨ ca cuñí ñu cha chiñí tuhun cahán Nyoo ta quichahá ñu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tyicuan ta chaa̱ coyo ñáyɨvɨ nu nyaá ra Jesús. Ta quichaha catyí ra chi ñu: ―Ñáyɨvɨ cha iyó vityin quiñi xaan iyó ñu. Ta nyiyo iñi ñu. Cuñí ñu nyehe ñu seña ta cha iyo. Soco noo ri cunyehe ñu, tahan cha sacuvi̱ Nyoo chihin ra Jonas. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tari ra Jonás cuvi̱ ra seña chi ñáyɨvɨ ñuu Nínive ta cha naha, tyicuan caa tucu yuhu Rayɨɨ cha quichi nya gloria, cuví tari noo seña chi ñáyɨvɨ cha iyó vityin. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Quɨvɨ tachi tuñi Nyoo chi ñáyɨvɨ cunandoto ñaha cuví reina ityi sur ta cha naha, ta cucatyi ña vatyi cuhun ndo anyaya, vatyi maa ña vasɨ cañi ñuu ña, soco quichi̱ ña, quichi̱ tyasoho ña tuhun cha chiñi tuñi caha̱n ra Salomón. Ta ihya cahnu ca cuví ra cha cahán chihin ndo vityin ta ñima ca ra Salomón. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta quɨvɨ cutuñi chi tandɨhɨ ñáyɨvɨ, cunducuita ñu chiyo̱ ñuu Nínive ta cha naha, ta cucatyi ñu vatyi nyoho ñu cha iyó vityin cuhun ndo anyaya, vatyi maa ñu ñu Nínive, canasama̱ ñu cuhva iyó ñu quɨvɨ caha̱n ra Jonás tuhun Nyoo chihin ñu. Ta vityin yuhu ra cahnu ca cahán chihin ndo ta ñima ca ra Jonás. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Yori ndo tyaa ndo lámpara ta tyihi xehe ndo, o tyihi ndo chichi noo caja. Vatyi ñuhu̱ cuan tahán chi coso minoo nu sucun. Tacuhva quɨhvɨ ñáyɨvɨ vehe ndo, soco ndichin. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Chɨtɨ nuu ndo noo cha sandichin chi ndo cuví. Ta tyicuan caa tucu añima ndo, tatu iyó cha ndichin Nyoo añima ndo, vaha ñáyɨvɨ cuví ndo. Tatu ñahri cha ndichin Nyoo nyaá tari noo ra cuaa cuví ndo, ña cuví nyehe ndo ityi vaha cha cuahan nu nyaá Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yucuan chaha sa̱ha ndo cuenda añima ndo. Tatu nyaá cha ndichin Nyoo chihin ndo, o nyaá cha ñaa iñi. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tatu tyitu añima ndo chihin cha ndichin Nyoo ñahri ca maa noo nu ñaa iñi iyó chi ndo, vatyi sandichin chi tandɨhɨ ndo. Tari cha nyaá noo lámpara sacatá chi ñuhu̱ chi ndo cuví cuan ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuhva cha ndɨhɨ̱ cahan ra Jesús nuu ñáyɨvɨ, noo ra fariseo, ra quichaha xaan ley vehe ñuhu, catyí ra chi ra Jesús, vatyi na cuhun ra cucachi ra nya vehe ra. Ta chaa̱ ra Jesús vehe ra. Ta quɨhvɨ̱ ra chicunyaa ra mesa. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tyicuan ta ra fariseo cuan iyo cuñí ra vatyi ña nacatya̱ ra Jesús ndaha ra, tari cuhva costumbre maa ñu cha cumañi cachi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Soco ra Jesús catyí ra chi ra: ―Nyoho, ra cacuví fariseo, tari cha chata ri vaso ta coho sanduvii nyoho. Soco ityi chichi, quiñi caa. Vatyi ña nacatyá ndo. Tyicuan caa nyoho. Vatyi cuñí ñáyɨvɨ vatyi vaha ñáyɨvɨ cuví ndo. Soco xehe ri suhu ndo ta ña sacuví ndo cha vaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ndava xaan iñi ndo. ¿Atu ña chitó ndo vatyi ra cha savahá ityi chata vaso, suri maa ra savahá ityi chichi? Vatyi tari vaso cuví ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tahán chi sahá ndo tumañi iñi chi ñáyɨvɨ, ta tyi̱nyee ndo chi ñu. Sa̱cuvi ndo cha vaha chihin ñu, tyicuan ta nduvii tucu ityi chichi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ndahvi nyoho ra fariseo! Vatyi nyoho vasɨ vaha chaha ndo diesmo chi Nyoo cuenda yucu cha nañí menta ta ruda ta ñáá ndɨhɨ ca yucu cha tachi̱ ndo, soco ña quichahá ndo cuhva cha vaha cha cuñí Nyoo sacuvi yo, ta cha cuñí yo chi ra. Ta ican ihya cuví cha tahán chi sacuvi ndo, soco ma sandɨhɨ ndo cha cuhva ndo diesmo ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ndahvi nyoho cha cuví ndo fariseo! vatyi cuñí ndo cunyaa ndo nu tyayu vaha ca chichi vehe ñuhu. Ta cuñí ndo cha saha ñáyɨvɨ ñáyɨvɨ chi ndo nuyahvi. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ndahvi nyoho ra sacuaha cuenda ley, ta nyoho ra fariseo! Vaha sahá ndo chi ndo, soco cuví ndo tari noo ñaña ndɨyɨ cha ña quetuví. Vatyi yahá ñáyɨvɨ sɨquɨ soco ña chitó ñu ñáá cha ñohó chichi ñaña cuan. Vatyi ñahri seña catuví nu yɨhɨ́ ndɨyɨ cuan. Cuñí maa ñu vatyi vaha ndo, soco ña chitó ñu vatyi ña vaha añima ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tyicuan ta nacaha̱n noo ra sacuahá cuenda ley vehe ñuhu, ta catyí ra: ―Maestro, cha catyún tyehe caa, nañí tucu chiin chi nyuhu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tyicuan ta quichaha catyí ra Jesús chi ra: ―¡Ndahvi tucu nyoho ra casacuaha cuenda ley vehe ñuhu! Vatyi sanducuaha ca ndo ley cha tachi̱ Nyoo ta cha naha. Ta ña tahán chi. Ta yori ndoyó carga cuan, ta sanɨñɨ ndo na sacuvi ñu ta ni maa ndo nɨ chiin ña tyinyee ndo chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ndahvi nyoho! Vatyi sanduvahá vaha ndo ñaña nu ñohó yɨquɨ ra profeta Nyoo cha cachahñi̱ sutu chahnu ndo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chihin cuan cuñí chi catyi vatyi ndoó ndo vaha cha sacuvi sutu chahnu ndo ta cha naha. Vatyi sutu ndo cachahñi̱ ra chi ra profeta Nyoo. Ta nyoho sanduvahá ndo ñaña ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yucuan chaha catyí Nyoo ta cha naha vatyi cutachi ra suhva ra profeta ta ra caca tyiño ra nu nyicú ndo. Ta cucahñi ndo suhva ra ta inga ra cusacono ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ta ndicha tyicuan caa sacuví ndo. Nyoo cutachi tuñi ra chi ndo cha cuenda tandɨhɨ ra profeta ra cachahñi̱ sutu chahnu ndo nyata chino̱ ñuhu ñayɨvɨ̱ ta nyacua nya vityin. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nyacua nya nɨñɨ ra Abel cha chatɨ cha chahñi̱ ra Caín yañi ra, ta nyacua nya nɨñɨ ra Zacarías cha cachahñi̱ ñu chichi vehe ñuhu yatyin nu nyaa arta. Yucuan chaha catyí Nyoo vatyi cutachi tuñi ra chi ñáyɨvɨ cha iyó vityin cha catyi cuatyi ñu chiyo̱ ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ndahvi nyoho ra casacuaha cuenda ley vehe ñuhu! Vatyi tari cha tyihí xehe ndo ndaha tɨcu cuenda yuvehe nu quɨhvɨ ñáyɨvɨ ityi Nyoo. Ta ni maa ndo ña quɨhvɨ ndo nu nyaá Nyoo. Ta nɨ ri ña chahá ndo cha quɨhvɨ inga ñáyɨvɨ cha cuñí quɨhvɨ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ndɨhɨ̱ cahan ra Jesús tuhun cuan, ta quita̱ ra. Soco ra casacuaha ley vehe ñuhu chihin ra fariseo, nduxaan xaan ra ta quichaha cuquiñi cuñi ra nyehe ra chi ra Jesús. Ta canducu ra cuhva yoso caa cahan ra Jesús noo tuhun ña vaha, ta tyaa ra cuatyi sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cuenda mil ñáyɨvɨ ndu ɨɨ̱n ri nyacua nañi tahan ñu, vatyi cuaha xaan ñu. Tyicuan ta ra Jesús catyí xihna ca ra chi ra cachicá noo chihin ra: ―Sa̱ha ndo cuenda chi ndo chihin ra fariseo coto sandahvi ñaha ra chi ndo. Vatyi tari ndaa pan chihin yuchan iya, tyicuan caa cuví cuatyi ra tyi sahá ra tyi vaha ra. Soco ma cuvi tixehe ra cuatyi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vatyi ñahri noo cha ñohó xehe ta cuñún, tyi ma natuvi, ta ñahri cha xehe ta cuñun, vatyi ma coto ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yucuan chaha ñáá ndɨhɨ tuhun cha cahán ndo nu xehe, cuquita chi nu ndichin. Ta ñáá ndɨhɨ tuhun cha cahan ndo chichi vehe ndo, cucuɨñɨ tandɨhɨ ñáyɨvɨ noo quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ta catyí chi ndo cha cuví ndo ra tahin, vatyi ma yuhvi ndo chi ra chahñí coño ñuhu ri. Vatyi yaha̱ tuhun cuan ta ñahri ca cha cuví sacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Soco cua catyi chi ndo yóó chi tahán chi cuyuhvi ndo. Yu̱hvi ndo ta qui̱chaha ndo, soco chi maa Nyoo ra cuví tinyaa ñayɨvɨ̱ ndo. Ta yaha cuan ta cuví tyihi ra añima ndo anyaya. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Saa, ña yahvi nyaá tɨ. Cuví sata yo ohon tahan tɨ chihin uvi ri xuhun. Soco vasɨ nyihi ri tɨ, Nyoo ña naa iñi ra chi ni noo tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ta nyoho, yahvi ca nyaá ndo nu Nyoo ta ñima ca cuaha saa ta nyacua nya ixi xiñi ndo ta chitó Nyoo yoso tahan nyaá. Yucuan chaha ma yuhvi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Catyí chi ndo vatyi nya ndo cahán ndo tuhin chihin ñáyɨvɨ, tyicuan caa tucu cucahin tuhun ndo nuu ángel Nyoo gloria. Vatyi yuhu Rayɨɨ cha quichi nya gloria cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Soco nya nyoho cha cahán nuu ndo cahán ndo tuhin chihin ñáyɨvɨ, tyicuan caa tucu yuhu, ma cahin tuhun ndo nuu ángel cuenda Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ta vasɨ cahán ñáyɨvɨ chi yuhu Rayɨɨ cha quichi̱ nya gloria, Nyoo cusaha ra tucahnu iñi chi ñu. Soco yóó cha cahán ña vaha sɨquɨ Tatyi Ii Nyoo ma ñihi ñu tucahnu iñi cuenda cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cuhva cha cunyaca ñáyɨvɨ chi ndo chichi vehe ñuhu, o nu juez, o nuu ra cuví tyiño, ma caca xiñi ndo ñáá tuhun cunacahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Vatyi cuhva cha cua nacahan ndo, yucuan cuhva cuhva maa Tatyi Ii Nyoo ñáá tuhun tahán chi nacahan ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Noo ra cha ndɨhɨ chihin ñáyɨvɨ cuaha cuan, catyí ra chi ra Jesús: ―Maestro, ca̱tyi chi yañi vatyi natahvi sava ra cha tyayɨɨ cha sandoo sutu ndi chi ndi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tyicuan ta catyí ra Jesús chi ra: ―¿Yóó cha tyiso chi yuhu cha cuví juez ta catyi ndo vatyi tahvi sava yuhu cha chii ndo? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tyicuan ta quichaha catyí tucu ra: ―Sa̱ha ndo cuenda ta ma nyiyo iñi ndo cha tyayɨɨ. Vatyi ña chiñuhú ri cha coo cuaha ndaha tyiño yo tacuhva coo vaha yo ñayɨvɨ̱ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tyicuan ta chaha̱ ra Jesús noo cuhva ihya chi ñu: ―Chiyo̱ noo ra tyayɨɨ. Ta cuaha xaan tyiño sahá ra iyó. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tyicuan ta ndichi xiñi ra: “¿Yoso caa cusacuvi? Ñahri nu naquehen vahi tandɨhɨ tyiño sahi. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Soco cha chité yoso caa cunyacuvi. Cusatani yaca nyihi nu yɨhɨ́ nɨñi, vatyi nyihi xaan. Ta cusavahi cha nahnu ca. Ta yucuan cunaquehen vahi tandɨhɨ maa nɨñi cha cuquita nu iyó tyiño sahí. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tyicuan ta cuaha cuiya ma saha tyiño que. Cunyitati ta cusɨɨ cuñi. Ta cachi vahi. Ta cucoho vahi”, ndichi xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Soco catyí Nyoo chi ra: “Tondo xaan iyón. Vatyi vityin cha cuaa cucúvun. Ta cha cumí vahun ¿yóó chi cua ndoo?” ");
INSERT INTO mxtNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tyicuan caa cuvi chi ñáyɨvɨ cha sacayá tandɨhɨ cha tyayɨɨ soco ñahri maa iyó chi ñu nuu Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tyicuan ta quichaha catyí ra Jesús chi ra cachicá noo chihin ra: ―Catyí chi ndo, vatyi ma caca xaan xiñi ndo yoso caa ñihi ndo cha cachi ndo, ta tuhun sahma cuihno ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vatyi yahvi ca nyaá ñayɨvɨ̱ yo ican saha cha cachi yo. Ta yahvi ca nyaá coño ñuhu yo ican saha cha cuihno yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sa̱ha ndo cuenda saa vatyi ña sahá tyiño tɨ. Ta nɨ ri ña naquehén vaha tɨ cha cachi tɨ. Soco chachí tɨ, vatyi Nyoo chahá ra cha cachi tɨ. Ta nuu Nyoo yahvi ca nyaá nyoho ta ñima ca saa. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta vasɨ chicá xaan xiñi ndo soco ma cuvi sandusucun ca ndo nɨ chiin ca chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tatu nɨ chiin cuan ña cuví chi ndo, ¿ñáá tuhun cha chicá xaan xiñi ndo tuhun tandɨhɨ ca cha chiñuhu chi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Sa̱ha ndo cuenda yoso caa iyó tu ita vatyi ña sahá tyiño tun. Soco catyí chi ndo vatyi ni rey Salomón chihin tandɨhɨ cha tyayɨɨ ra ta ña tyaquɨ cha ñihnó ra tari cha sacuihno Nyoo chi tu ita cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tatu tyicuan caa sacuihnó Nyoo chi tun ita cha iyó nu chiqui vityin, ta tyaan cucayu tun chichi horno, ta nyaca cuví chi nyoho ta ma sacuihno ra. Soco maa ndo ña chinó vaha iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma caca xaan xiñi ndo tuhun cha cachi ndo ta cha coho ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vatyi ñáyɨvɨ cha ña chinó iñi chi Nyoo chicá xiñi ñu tuhun ihya. Soco nyoho chinó iñi ndo chi Sutu yo Nyoo ta maa ra chitó ra ñáá cha chiñuhú chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vaha ca cha nanducu ndo yoso caa nacuhva cuenda ndo chi ndo chi Nyoo vatyi cunyaca ñaha ra añima ndo. Ta tyicuan caa ta ñihi ndo tandɨhɨ cha chiñuhú chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ma yuhvi nyoho, mbee sane. Vasɨ ña cuaha ndo soco Sutu yo Nyoo cuñí ra chi ndo. Yucuan chaha cucuhva ra quɨhvɨ ndo nu nyacá ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xi̱co ndo cha iyó chi ndo. Ta cu̱hva ndo chi ñu ndahvi. Tatu sacuví ndo tyehe caa, sacayá ndo cha vaha nuu Nyoo cuví cuan. Vatyi nuu Nyoo ña ndɨhɨ́ cha vaha cuan. Vatyi nɨ ri ra suhu, ni quɨtɨ, yori cha satɨvɨ iyó yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vatyi nuu cunyaa cha tyayɨɨ ndo, yucuan cuví nu nyaá xiñi ndo. Ta yucuan cucunyaa añima ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Cua̱tu tuhva vaha ndo quɨvɨ quichi inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ta cu̱vi ndo tari musu cha canyatú tuhva chi chitoho ñáá cuhva ndichi ra cha cuahan ra noo vico tandaha. Ta nyatú tuhva ra, vatyi tacuhva tañi tyehe ri nuña ra yuvehe cuhva cha sacachan chitoho ra cha nachaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Ta caa cuhva ri cuan sɨɨ xaan cuñí ra nyehe ra chi ra. Vatyi nyatú tuhva ra chi ra nyacua nya nachaa ra, vasɨ cha cuaa, vasɨ ñaa ca. Ta cuatyaa ra chi musu cuan yuhu mesa ta cacachi ra. Tyicuan ta sɨɨ xaan cucuñi musu cuan. Vatyi tyicuan caa nyacuví chitoho ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ta co̱to ndo tuhun ihya vatyi tatu noo chitoho noo vehe, ta coto ra ñáá cuhva cuquɨhvɨ ra suhu vehe ra, saha ra cuenda vehe ra. Ta ma cuhva ra quɨhvɨ ra suhu cuan chichi vehe ra. Vatyi coto quehen ra tandɨhɨ cha iyó chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ta tyicuan caa cuví tucu nyoho, cua̱tu tuhva ri ndo. Vatyi yuhu Rayɨɨ cha quichi nya gloria, sana ri iñi ndo ta cuquichi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tyicuan ta quichaha ndaca tuhun ra Pedro chi ra Jesús: ―¿Yóó chi cuenda cahun tuhun ihya? ¿Atu cha cuenda maa ri maa ndi, o cha cuenda tandɨhɨ ñáyɨvɨ? ");
INSERT INTO mxtNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra chi ra: ―Musu cha tyasohó tuhun cahán chitoho, yucuan cuví musu vaha. Vatyi sahá cuenda ra vehe chitoho ra. Ta vaha ri cuhva chahá ra cha cachi tandɨhɨ ca musu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta sɨɨ xaan cuví chi musu cuan tatu cuhva cha sahá tyiño ra, ta nachaa chitoho ra. Vatyi quichaha ra tandɨhɨ cha tahán chi sacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta catyí chi ndo vatyi cha ndicha cuví. Vatyi chitoho ra cunatyaa ra tandɨhɨ cuii cha cumí ra ndaha ra. Vatyi vaha quichahá ra chihin tyiño sahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Soco tatu chicá xiñi musu cuan vatyi naha xaan cuahan chitoho ra, ta quichaha nyacuvi ra cha ña vaha chihin ñu nyaá tyiño yoo, ta chihin ra canyicú tucu sahá tyiño cuan. Ta ña cuñí ra sahá tyiño ra. Tyiño chachí ta tyiño chihí ndixi iyó ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tyicuan ta sana iñi ra ta ndichi chitoho ra quɨvɨ cha ña nyatú ra chi ra noo cuhva cha ña chito ra. Tyicuan ta cutachi tuñi chitoho ra chi ra, tari tuhva maa ra chihin musu cha ña quichahá tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ta noo musu cha chitó yoso caa iyó chitoho ta ña sacuvi tari cuhva cuñi chitoho ra, cuaha xaan tundoho cunyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Soco tatu noo musu cha ña chitó ta sacuvi ra cha ña vaha, tachi tuñi chitoho ra chi ra. Soco chiin ri, vatyi ña chitó ra, ta chinyacuvi̱ ra. Tatu noo musu ta cuaha cha chaha chitoho ra chi ra, cuaha tahán chi nacuhva cuenda ra chi chitoho ra. Ta ra cha cuaha xaan nyaá ndaha, cuaha xaan tahán chi nacuhva cuenda ra chi chitoho ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Tari cha sanatahín ñuhu̱ sɨquɨ ñuhu ñayɨvɨ̱, tyicuan caa cuví tyiño vachi. ¡Ñana cha cuñí cha nacayu catyin ri ñuhu̱ ihya! ");
INSERT INTO mxtNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Vatyi nyaá yahi noo tundoho cahnu, ta ñana cha nyehí tundoho nyacua nya ndɨhɨ tyiño sahí. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Cuñí maa ndo vatyi cha vachi cuhve cha taxi ri coo ndo sɨquɨ ñuhu ñayɨvɨ̱ ihya. Soco yuhu vachi vatyi sasɨin chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vatyi cha vityin ta ityi nuu ca, ohon ñáyɨvɨ noo vehe cucusɨɨn ñu. Uñi ñu cañi tahan chihin uvi ñu. Ta uvi ñu cucañi tahan chihin uñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta ra cuví sutu, cucañi tahan ra chihin sehe ra. Ta ra cuví sehe cucañi tahan ra chihin sutu ra. Ta ñu cuví sɨhɨ cucañi tahan ñu chihin sehe ñu. Ta ñu cuvi sehe cucañi tahan ñu chihin sɨhɨ ñu. Ta ñu cuví tyiso cucañi tahan ñu chihin chono ñu. Ta ñu cuví chono cucañi tahan ñu chihin tyiso ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Catyí tucu ra Jesús chi ñáyɨvɨ cuaha cha nyicú yucuan: ―Tatu cha nyehe ndo vatyi cha ndɨhvɨ̱ vico, catyí ndo vatyi cua coon savi. Ta tyicuan caa cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tatu cha nyehe ndo vatyi cha caá tatyi ityi tyañuhu, catyi ndo vatyi cha chaa quɨvɨ ihñi. Ta tyicuan caa cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyoho sahá ndo tyi chitó ndo, ta nacotó ndo tandɨhɨ tuhun andɨvɨ, ta tandɨhɨ tuhun ñuhu ñayɨvɨ̱. Soco ¿ñáá tuhun cha ña nacotó ndo ñáá tyembu nyaá ndo vityin? ");
INSERT INTO mxtNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Ñáá tuhun ña sahá ndo cuenda nya cha vaha ta nya cha ña vaha? ");
INSERT INTO mxtNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tatu noo ra chicán cuatyi chahun ta cuahun chihin ra nu nyaá ra cuví tyiño, ityi cuahun ndu̱cun cuhva nɨ coo vahun chihin ra cha cumañi ca chaa ndo nu nyaá ra cuví tyiño. Coto nacuhva cuenda ra chuun chi juez. Ta juez cuan cunacuhva cuenda ra chuun chi policía. Ta policía cuan cutyihi ra chuun chichi vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tatu tyicuan caa cuvi, catyí chuun vatyi ma quiton nyacua nya tyiyahvun tandɨhɨ cha tahán chi tyiyahvun ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tyicuan ta suri quɨvɨ cuan canyicu suhva ra. Ta quichaha canacatyi ra chi ra Jesús yoso caa cha nyacuvi̱ ra Pilato chihin suhva ra Galilea. Vatyi tyihi ra tyiño na cucahñi sɨndaro chi ra Galilea cha cachaha̱ ofrenda chi Nyoo vehe ñuhu. Ta nasaca̱ ra nɨñɨ ra cuan chihin nɨñɨ quɨtɨ cha cua cuvi ofrenda cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ta nacaha̱n ra Jesús ta catyí ra chi ra: ―¿Atu chicá xiñi nyoho vatyi cahnu xaan ca cuatyi ra Galilea cuan cha nuu tandɨhɨ ra ityi ñuu ra. Ta yucuan chaha cachihi̱ ra? ");
INSERT INTO mxtNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ñima. Vatyi tatu nyoho ta ma nasama ndo cuhva iyó ndo, tyicuan caa tucu cunaa nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ta ndɨ chahun uñi ra cachihi̱ cha canacava̱ torre Siloé cuan sɨquɨ ra. ¿Atu cuaha ca cuatyi ra ta ican saha inga ra cha iyó ñuu Jerusalén cuñí maa ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ñima. Vatyi tatu nyoho ta ma nasama ndo cuhva iyó ndo, cunaa tucu nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tyicuan ta chaha̱ ra Jesús noo cuhva. Ta catyí ra: ―Noo ra iyó yutun cha nañí higo chi ra. Ta nanyaá tun nu ñuhú ra. Ta chaha̱n ra chinyehe ra tatu iñi chɨtɨ tun. Ta nanyehe ra vatyi ñahri. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ta quichaha catyí ra chi ra sahá cuenda chi tun: “Cha uñi cuiya tyito ri quichi nyehi tatu iyó chɨtɨ tun. Ta ñahri maa chɨtɨ tun iñi. Na cahnya yo chi tun. Vatyi ¿ñáá ri tuhun sayangá tun nu ñuhú ihya? Vatyi ñahri chɨtɨ chahá tun”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Soco ra cha sahá cuenda ñuhú cuan quichaha catyí ra: “Tata, ma cahnya yo chi tun vityin. Na cuinanyaa maa tun nonga cuiya ihya. Cusanduvite ñuhú chaha tun ta cutyihi ñuhú tyahyu. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Vasɨ tyicuan caa ta cuhva tun chɨtɨ. Soco tatu ña chaha tun chɨtɨ, tyicuan ta cahnya yo chi tun”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Noo quɨvɨ cha nyitatú ñáyɨvɨ sañahá ra Jesús chi ñu chichi vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta yucuan nyaá noo ñaha cha yɨhɨ́ tatyi ña vaha chi. Ta cha chahun uñi cuiya cuhví ña cha ndutɨhɨ chata ña. Ta ña cuví ndundoo ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tyicuan ta nanyehe̱ ra Jesús chi ña. Ta cana̱ ra chi ña. Ta quichaha catyi ra chi ña: ―Cha nduvahu̱n. Ñahri ca cuehe ndohún ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tyicuan ta tyiso̱ ra ndaha ra sɨquɨ ña. Ta caa cuhva ri cuan ta ndundoo̱ ña. Tyicuan ta quichaha sacahnu ña chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Soco ra cuví nuu vehe ñuhu, cuxaan xaan ra. Vatyi quɨvɨ nyitatú ñáyɨvɨ sanduvaha̱ ra Jesús chi ña. Ta quichaha catyí ra chi ñáyɨvɨ canyicú cuan: ―Iyó iñu tahan quɨvɨ tahán chi saha tyiño yo. Yucuan quɨvɨ quichi ndo quichi cuvi tatan chi ndo. Ta ma quichi ndo quɨvɨ nyitatu yo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tyicuan ta ra Jesús quichaha catyí ra chi ra: ―Nyoho cha sahá ndo tyi vaha ndo. ¿Atu ña ndachi tucu nyoho quɨtɨ sana ndo vatyi sacoho ndo ndutya chi tɨ quɨvɨ nyitatú yo? ");
INSERT INTO mxtNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta tyicuan caa tucu ñaha ihya, vachi ña tata ra Abraham. Ta cha chahun uñi cuiya nuhñí ña chihin cuehe ihya sahá ra ña vaha. Ta yori ndachi chi ña. ¿Atu ña tahán chi ndachi yo chi ña vasɨ quɨvɨ nyitatu yo? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tyicuan ta cuhva cha catyí ra Jesús tuhun cuan, tandɨhɨ maa ra xaan iñi chi ra caha̱n cuvi nuu ra. Soco tandɨhɨ maa ñáyɨvɨ cusɨɨ cuñi ñu chihin cha cahnu cha sacuví ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tyicuan ta quichaha catyí ra Jesús: ―¿Ñáá chihin sandɨquɨ tahin cha nyacá ñaha Nyoo añima yo? ¿Ñáá chihin sandu ɨnuu ri yo? ");
INSERT INTO mxtNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tari noo chɨtɨ mostaza, tyicuan caa cuví. Vatyi noo ra tachi̱ ra noo chɨtɨ nu ñuhú, ta chahnu̱ tun. Ta cuví tun noo yutun cahnu vavaha. Tyicuan ta chaá coyo saa nuu yutun cuan. Ta yucuan savahá tɨ taca tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tyicuan ta quichaha catyí ra Jesús inga chaha: ―¿Ñáá ca chihin sandu inuu ri yo yoso caa nyacá ñaha Nyoo añima yo? ");
INSERT INTO mxtNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cuví chi tari noo yuchan iya cha nasaca̱ noo ñaha sɨhɨ chihin uñi cuhva yutyi pan. Vatyi tari ndaa pan cuan chihin yuchan iya cuan, tyicuan caa cuahan nducuaha ca ñu nyacá ñaha Nyoo añima ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ityi cuahan ra Jesús Jerusalén cahán ra tuhun Nyoo chihin ñáyɨvɨ tandɨhɨ ñuu nu yaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta quichaha ndaca tuhun noo ra chi ra: ―¿Atu ña cuaha maa ñáyɨvɨ cucacu añima? ―catyí ra. Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Na̱nducu ndo cuhva quɨhvɨ ndo yuvehe tɨhɨn. Vatyi yɨɨ xaan quɨhvɨ ndo nu nyacá ñaha Nyoo. Vatyi cuaha xaan ndo cha cucuñi ndo quɨhvɨ ndo yucuan. Ta ma cuvi. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Vatyi tari chitoho noo vehe tyicuan caa cuví Nyoo. Ta chitoho vehe cuan cunacasɨ ra yuvehe. Tyicuan ta nyoho cha nyicú ndo ityi chata cusacachan ndo yuvehe, ta cucatyi ndo: “Nu̱ña yuvehe.” Ta ra cuan cucatyi ra chi ndo: “Ña chité nya ityi quichi nyoho.” ");
INSERT INTO mxtNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tyicuan ta nyoho cucatyi ndo: “Nyuhu chachi̱ ndi ta chihi̱ ndi chuhun. Maun sañahu̱n tuhun Nyoo chi ndi ityi nu nyaá vehe ndi”, cucatyi ndo chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Soco ra cuan cunacahan ra chihin ndo ta cucatyi ra: “Cha catyi chi ndo vatyi ña chité nya ityi quichi nyoho. Ca̱nyaha ndo nu nyai, tandɨhɨ nyoho ñu nyacuví cha ña vaha”, cucatyi ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yucuan ta cuacu ndo ta sacahñi noho ndo cha nyehe ndo chi ra Abraham ta chi ra Isaac ta chi ra Jacob, ta chi tandɨhɨ ra profeta Nyoo cha chiyo ta cha naha. Vatyi canyicú ra nu nyacá ñaha Nyoo. Ta nyoho ndoo ndo ityi chata. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta cuquichi ñáyɨvɨ ityi tyañuhu, ta ityi norte, ta ityi nu caña ñanyii, ta ityi nu quee ñanyii. Ta cunyicu ñu cachi ñu chihin Nyoo nu nyacá ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ta yóó ñu cha cuñí cuhun ityi nuu, ican ñu cuhun nu ndɨhɨ. Ta ñu cuahan nu ndɨhɨ, ican ñu cuhun ityi nuu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Suri maa quɨvɨ cuan chaa̱ coyo suhva ra fariseo. Ta catyí ra chi ra Jesús: ―Qui̱ta ihya vatyi ra Herodes cuñí ra cahñi ra chuun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Soco ra Jesús quichaha catyi ra chi ra: ―Cua̱han ndo ta catyi ndo chi ra ñucuii quiñi iyó cuan, vatyi nyacua nya nu chaa maa chi quɨvɨ cha ndɨhɨ tyiño sahí cha tave tatyi ña vaha ta cha sanduvahi chi ñu cuhví, tyicuan ta cundɨhɨ tyiño sahí. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Soco nya tahán chi cha ndɨhɨ maa tyiño sahí, tyicuan ta cuhun mai cucúvi nya Jerusalén. Vatyi ma cuvi cha cúvi noo ra profeta Nyoo ityi chata Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ndahvi nyoho ñáyɨvɨ Jerusalén! vatyi chahñí ndo chi ra profeta ra cachahá cuenda tuhun cahán Nyoo chi ndo. Ta tuchi ndo yuu chi tandɨhɨ ra cha saquichi̱ Nyoo nu nyicú ndo. Ta yuhu cuaha xaan chaha cuñí saha cuende chi ndo tari noo ndɨvɨ cha sahá cuenda tɨ chi sehe tɨ, ta naquehen vaha tɨ chi tɨ chichi ndichin tɨ. Soco maa ndo ña cuñí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nye̱he ndo vityin vatyi cha sandoi̱ chi ndo. Ta catyí chi ndo vatyi ma nyehe ca ndo chii nyacua nya chaa chi quɨvɨ cuacatyi ndo vatyi cahnu xaan ra vachi chihin sɨvɨ Nyoo ―catyi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cuví chi noo quɨvɨ nyitatú ñáyɨvɨ. Ta ra Jesús cuahan ra cua cachi ra vehe noo ra cuví nuu chi ra fariseo. Ta suhva ca fariseo cuan cañañi ra chi ra Jesús tatu ñáá cha ña vaha cunyacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yucuan ta nuu ra Jesús nyaá noo ra cuhví cha yɨhɨ́ cuiño chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tyicuan ta quichaha catyi ra Jesús chi ra casacuaha ley vehe ñuhu ta chi ra fariseo: ―¿Atu vaha sanduvaha yo chi ñáyɨvɨ cuhví quɨvɨ nyitatú yo? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tyicuan ta tandɨhɨ ra cuan, taxi taxi cacuvi ra. Yucuan cuví nu tyiso̱ ra Jesús ndaha ra sɨquɨ ra cuhví cuan. Ta sanduvaha̱ ra chi ra. Ta natachi̱ ra chi ra na cunuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tyicuan ta quichaha catyi ra Jesús chi ra fariseo: ―Tatu canacava noo burru sana ndo, o nonga quɨtɨ sana ndo chichi noo xahva, ¿atu ma cutava ndo chi tɨ tañi tyehe ri, vasɨ quɨvɨ nyitatú yo cuví? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tyicuan ta inga chaha tucu taxi cuii ri nɨcunyicu ra fariseo. Vatyi ña ñihi ca ra tuhun nacahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cha nyehe̱ ra Jesús vatyi tandɨhɨ ra canyicú vico cuan nacachí ra tyayu vaha ca cunyaa ra. Tyicuan ta quichaha chaha ra tuhun ihya chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nya quɨvɨ cuhun ndo vico tandaha, ma nanducu ndo tyayu vaha ca cunyaa ndo. Vatyi coto quichi inga ra cha cahnu ca cuvi ican saha ndo, ");
INSERT INTO mxtNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ta coto quichi ra cha nacatyi tuhun ta catyí ra chuun: “Cu̱hva tyayu chiña. Vatyi cunyaa ra ihya.” Tyicuan ta yoho chihin cha cahán nuun, ta cuhvon. Yucuan ta cunyaun nu ndɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Soco catyí chi ndo, vatyi nya quɨvɨ nacatyi tuhun ra chi ndo, cunyaa ndo noo nu ñima ri tuhun. Vatyi quichi maa ra cha nacatyi̱ tuhun chi ndo ta catyi ra chi ndo: “Ra tahin, ña̱ha, cu̱nyaun nu tyayu vaha tyehe.” Ta tyicuan caa sacucahnu ra chuun nu ñáyɨvɨ nyicú yuhu mesa chuhun. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vatyi yóó ra cha cahnu sahá chii, cuquehen ra tɨcahan nuu. Ta yóó ra cha ndahvi sahá chii, cahnu cucuvi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tyicuan ta quichaha catyi tucu ra chi ra nacatyi̱ tuhun chi ra: ―Nya quɨvɨ coo vico vehun, ma nacatyi tuhun chi ra tahun, nɨ chi yañun, nɨ ri chi ñáyɨvɨ chuun, nɨri chi ñu nyicú yuvehun ñu tyayɨɨ. Vatyi ñu cuan cuví nacatyi tuhun ñu chuun, na coo tucu vico vehe maa ñu. Tyicuan ta nacahnya ñu cuenda cha chaha̱n ñu vico vehun. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Soco cua catyi chuun vatyi nya quɨvɨ coo vico vehun, nacatyi tuhun chi ñu ndahvi, chi ñu cuhví, chi ñu coxo, ta chi ñu cuaa. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tyicuan ta sɨɨ cuví chuun, vatyi ñu cuan ma cuvi natyiyahvi ñu chuun. Soco cuñihun yahvun quɨvɨ cunandoton chihin ñáyɨvɨ vaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ta chiñi̱ noo ra cha nyaá yuhu mesa cuan tuhun cahán ra Jesús. Ta quichaha catyí ra chi ra: ―Sɨɨ xaan cuvi chi ñu cachi nu nyacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tyicuan ta catyí ra Jesús: ―Noo ra cuan savaha̱ ra noo vico cahnu vavaha vehe ra. Ta nacatyi̱ tuhun ra chi cuaha xaan ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tyicuan ta chaa̱ cuhva cha cuxiñi ñu, ta tachi̱ ra chi musu ra nacana ra chi ñu. Vatyi cha chaa̱ cuhva cha cuxiñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Soco tandɨhɨ ñu cuan quichaha catyí ñu vatyi ma cuhun ñu. Ta noo ra cuan catyí ra: “Ni sate̱ noo ñuhú. Ta cuñí chi cuhin cunyehi. Ican tuhun chiquén na saha ra tucahnu iñi chii vatyi ma cuhin.” ");
INSERT INTO mxtNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tyicuan ta inga tucu ra cuan catyí ra: “Ni sata cuiri ohon tahan yunta quɨtɨ. Ta cuhin cunyehi tatu vaha tɨ. Ican tuhun chiquén tumañi iñi chi ra na saha ra tucahnu iñi chii, vatyi ma cuvi cuhin.” ");
INSERT INTO mxtNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tyicuan ta inga tucu ra cuan catyi ra: “Ni ndɨhɨ tandahi, ta ma cuvi cuhin”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tyicuan ta musu ra cuan cuanuhu ra. Ta nacatyi ra tandɨhɨ tuhun cuan chi ra cha tachi̱ chi ra. Cha chiñi̱ ra savaha vico cuan cha tyicuan caa, ta cuxaan xaan ra. Ta catyí ra chi musu ra: “Cua̱han tandɨhɨ maa ityi. Ta quichi nyacon chi ñu ndahvi, chi ñu cuhví, ta chi ñu coxó, ta chi ñu cuaa”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ta cha yaha̱ nachaa̱ musu cuan ta catyi̱ ra chi ra cha tachi̱ chi ra: “Cha sacuvi̱ tandɨhɨ maa cha catyún. Ta nuñá ca chichi vehe”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tyicuan ta chitoho ra catyí ra chi ra: “Cua̱han cua nducu ca chi ñu tandɨhɨ maa ityi. Ta sa̱nɨñun chi ñu na quichi coyo ñu, vatyi na cutu chichi vehi. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vatyi catyí chuun vatyi ni minoo ñu cha nacatyi̱ tuhin cha xihna ri, ma cachi ñu chihin” ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cuaha xaan ñáyɨvɨ nyicón chi ra Jesús. Tyicuan ta nanyehe ra chi ñu, ta quichaha catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tandɨhɨ nyoho cha nyicón ndo chii, tatu cuñí ca ndo chi ñáyɨvɨ chi ndo ican saha chi yuhu, ñima cuende yɨhɨ́ ndo. Ta tatu cuñí ca ndo chi maa ndo ican saha chi yuhu, ñima cuende yɨhɨ́ ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Vatyi nya nyoho cha ña cuñí ndo nyehe ndo tundoho cha cunyicon ndo chii, ña tahán chi cuví ndo ñu cuende, vatyi cha nyehe ndo tɨndoho yucuan cuví cruzi cha tahán chi cuiso ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vatyi tatu nya nyoho cuñí ndo savaha ndo noo vehe cahnu, xihna ca cunyaa ndo ta ndichi xiñi ndo tatu caña xuhun ndo cha cananyaa ndo vehe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vatyi tatu quichaha sacacu ndo vehe cuan, ta quichaha ña cuví sandɨhɨ ndo vatyi ñahri ca xuhun ndo, cuacu nyaa ñáyɨvɨ chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ta cuacatyi ñu: “Ra cuan quichaha savaha ra vehe ra, ta nɨ ña cuví sandɨhɨ ra”, cucatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O tatu noo rey cha cuñí cañi tahan chihin inga rey ¿atu ña chicunyaa xihna ra ta ndichi xiñi ra tatu ñihi uchi mil sɨndaro cha cuahan chihin ra cua cañi tahan chihin inga rey cha vachi chihin oco mil sɨndaro cuan? ");
INSERT INTO mxtNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tatu chitó ra vatyi ma cuvi chasaha ra chi inga rey cuan, tyicuan ta cañi ca vachi rey cuan, ta tachi ra chi noo musu ra vatyi cucatyi ra chi rey cuan na ndɨhɨ tuhun yucuan ri. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ta tyicuan caa cuví chi nyoho. Tatu ma cahnya iñi ndo tandɨhɨ maa cha cuñi ndo ta cha cumi ndo, ma cuvi cunyicon ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Vaha ñɨɨ vatyi sacu uhva chi cha cachi yo. Soco tatu ndɨhɨ cha uhva chi, ña vaha ca chi. ");
INSERT INTO mxtNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñahri ca tyiño cuví saha chi. Ta sacuita yo vatyi ña vaha ca. Nya nyoho cha cutuñí iñi ndo, tya̱soho ndo tuhun cahín ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tandɨhɨ ra tavá xuhun cuenda gobiernu ñuu Roma, ta ra iyó cuatyi, tuhva̱ ra nu nyaá ra Jesús, tacuhva cuɨñɨ ra tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tyicuan ta ra fariseo ta ra casacuaha ley vehe ñuhu quichaha cacahan nyaa ra, ta cacatyí ra: ―Ra ihya, cahán ra chihin ra iyó cuatyi. Ta chachí ra chihin ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tyicuan ta ra Jesús caha̱n ra noo cuhva ihya, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ta nya nyoho cha iyó noo cientu mbee sana ndo, tatu cuanaa noo tɨ, ¿atu ma sandoo ndo chi tandɨhɨ ca tɨ cuan nu chiqui. Ta cunanducu ndo chi quɨtɨ cha cuanaa cuan, nyacua nya cha nañihi ndo chi tɨ? ");
INSERT INTO mxtNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta cuhva cha nañihi ndo chi tɨ, ta natyiso soco ndo chi tɨ. Ta sɨɨ vavaha cuví chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ta cuhva cha nachaa ndo vehe ndo, ta ndu ɨɨn ri ndo chihin ra tahan ndo ta chihin ñu nyicú yatyin yuvehe ndo, yucuan ta catyi ndo chi ñu vatyi na cusɨɨ cuñi ñu chihin ndo vatyi nañihi̱ ndo chi mbee sana ndo cha chinaa̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ta ihya catyí chi ndo, vatyi sɨɨ xaan ca cuvi chi ángel Nyoo andɨvɨ cha catyi noo ra cha iyó cuatyi ta nasama cuhva iyó ra, ta ñima ca cha catyi ndɨ cumi xico chahun cumi tahan ñáyɨvɨ cha ñahri cuatyi. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Ta catyí chi ndo, tatu iyó noo ñaha cha iyó uchi tahan xuhun ña, ta tatu cuanaa noo xuhun ña, tyaa ña noo candil. Ta tɨhvɨ ña tandɨhɨ cuii maa chichi vehe ña. Ta nanducu ña tandɨhɨ cuii nyacua nya cha nañihi ña xuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ta cuhva cha yaha̱ nañihi̱ ña, cuahan ña cua nanducu ña chi ñaha tahan ña, ta ñáyɨvɨ cha nyicú yuvehe ña, ta catyi ña chi ñu: “Cu̱sɨɨ cuñi ndo chihin vatyi cha nañihi̱ xuhin cha chinaa”, catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ta catyí chi ndo vatyi tyicuan caa sɨɨ cuví chi ángel Nyoo cha catyi noo ra iyó cuatyi ta ndu uvi iñi ra cuatyi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tyicuan ta quichaha catyí tucu ra Jesús cuhva ihya: ―Noo ra, chiyo̱ uvi tahan sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ta noo chaha, ra luhlu ca cuan catyí ra chi sutu ra vatyi nacuhva ra cha tahán chi chi ra. Tyicuan ta sutu ra chaha̱ ra chi nɨnduvi sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta ña cuaha ri quɨvɨ cuan ta ra luhlu ca cuan xico̱ ra tandɨhɨ cuii maa cha chaha̱ sutu ra chi ra. Ta sandu ɨɨn ri ra xuhun ra, ta quehe̱n ra ityi ta cuahan ra noo ñuu cañi. Ta yucuan chiyo̱ ra, sanaa̱ ra tandɨhɨ maa xuhun ra chihin tusɨɨ iñi. Ta quiñi xaan chicá noo ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tyicuan ta chaa̱ noo tama ityi nu iyó ra. Ta quichaha chisoco ra vatyi ndɨhɨ xuhun ra sanaa̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tyicuan ta chaha̱n ra chicaca̱n ra tyiño chi noo ra ñuu cuan. Ta ra cuan tachi̱ ra chi ra noo nu iyó quɨnɨ sana ra, vatyi cusaha cuenda ra chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta cuví noo chaha cuan chisoco xaan ra. Ta ñahri maa cha cachi ra iyó, nyacua quichi cuvi iñi ra cachi ra cha cachachí quɨnɨ cuan soco yori maa chaha cha cachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tyicuan ta nɨcohon iñi ra tuhun sutu ra. Ta ndichi xiñi ra: “¿Atu chiin cuaha ra casahá tyiño chihin suti? Soco ñahri maa cha cumañi chi ra. Ta yuhu cuñí cúvi soco ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vityin cunuhin nu nyaá suti. Ta catyi chi ra tyi chicoo̱ cuatyi nuu Nyoo ta nuu maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta ña naña que cha cuvi sehe ra chii, ta na saha ra tuhun vatyi noo musu ri ra cuví chii.” Tyicuan caa ndichi xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Tyicuan ta quehe̱n ra ityi cuanuhu ra nya vehe sutu ra. Cañi ca vachi ra ta nanyehe̱ sutu ra chi ra, ta cundahvi̱ cuñi ra nyehe ra chi ra. Ta chino̱ ra chisataha̱n ra chi sehe ra. Ta nanumi̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tyicuan ta quichaha catyí ra chi sutu ra: “Tata, chicoo̱ cuatyi nuu Nyoo ta chicoo̱ cuatyi nu maun. Ta yucuan chaha ña naña que cha cuví sehun chii”, catyí ra chi sutu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Soco sutu ra tyihi ra tyiño, ta catyí ra chi musu ra: “Ta̱va ndo sahma vaha ca ta sa̱cuihno ndo chi ra. Ta tyi̱hi ndo noo xehe nundaha ra. Ta nya̱ca ndo zapato quɨhɨ chaha ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta sɨɨn ri ca̱hñi ndo noo becerru cha xahan ca, vatyi cachi yo chi tɨ. Vatyi vityin cucoo yo noo vico. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vatyi ra sehi ihya cha chihi̱ ra saha̱ mai tuhun. Cuñi̱ mai vatyi ma nyehe que chi ra, soco natuvi̱ ra”, catyí sutu ra. Tyicuan ta quichaha chicoo ñu vico. Ta sɨɨ xaan cacuñí ñu vatyi natuvi̱ ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tyicuan ta inga sehe ra, ra cha chahnu ca, ñohó ra nu chiqui. Ta cuhva cha cuanachaa ra nya vehe ra, ta quichaha chiñi̱ ra yaa. Ta chiñí ra vatyi sɨɨ xaan cachitá chaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tyicuan ta cuhva cha cuyatyin ra nya vehe ra ta cana̱ ra chi noo musu ra. Ta ndaca tuhun ra ñáá cha cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tyicuan ta musu ra quichaha catyí ra: “Yañun, ican nachaa̱. Ta yucuan chaha tachi̱ sutun vatyi na cahñi ra chi noo becerru xahan ca. Vatyi vaha ri nachaa yañun, ta ñahri cha cuvi̱ chi ra”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tyicuan ta cuxaan xaan cuñí ra. Ta ña cuñí ra ndɨhvɨ ra chichi vehe. Soco sutu ra chaha̱n ra chicaha̱n ndahvi ra chihin ra, vatyi na ndɨhvɨ ra chichi vehe. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tyicuan ta nacaha̱n ra ta catyí ra chi sutu ra: “¿Atu chiin cuiya sahá tyiñe chuhun? Ta tyasohí tuhun cahún. Ta ni noo chaha ta ta nacahnu que nu cahún. Soco ni noo ndixihyu lee ta cuhva con chii vatyi coi vico chihin ra tahin. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Soco vityin cha nachaa̱ sehun ihya, ra cha sanaa̱ xuhun chihin ñu cata iñi. Ta vityin chahu̱n noo becerro quɨtɨ xahan ca chi ra”, catyí ra chi sutu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tyicuan ta nacaha̱n sutu ra ta catyí ra chi ra: “Sehi, yoho tyicuan ri nyaún chihin. Ta tandɨhɨ cha cumi, chuun cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Soco vityin tahán chi sacuvi yo vico ihya. Ta cusɨɨ cuñí yo. Vatyi nachaa̱ yañun, ra cha saha̱ mai tuhun vatyi chihi̱. Tari quɨvɨ nandoto̱ ra cuví ihya. Ta chinaa̱ ra, ta nañihi̱ tucu yo chi ra inga chaha”, catyí ra chi sehe ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tyicuan ta quichaha catyí ra Jesús chi ra cachicá noo chihin ra: ―Iyó noo ra tyayɨɨ vavaha ra. Ta iyó noo ra yɨndaha tandɨhɨ tyiño sahá ra. Ta chaha̱n coyo musu ra canacatyi ra chi ra tyayɨɨ cuan, vatyi ra yɨhɨ́ ndaha tyiño cuan, sanaa ra tandɨhɨ cha iyó chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tyicuan ta cana̱ ra tyayɨɨ cuan chi ra yɨndaha tyiño cuan, ta catyí ra chi ra: “Cha cuaha xaan cuatyi chahún quichi nu nyaí. Na̱cuhva cuendon tandɨhɨ tyiño cha sacuvu̱n chii. Vatyi ma saha tyiño con chihin”, catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tyicuan ta ra yɨndaha tyiño cuan ndichi xiñi ra: “¿Yoso caa cunyacuvi vityin? Chitohi ña cuñí ca ra cha sahá tyiñe chihin ra. Ta ñahri fuerza iyó chii cha saha tyiñe nu ñuhú. Ta cahán nui caye chichi ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Soco cha chité yoso caa cunyacuvi vityin, ta vaha coo ñáyɨvɨ chihin quɨvɨ cha ma coo ca tyiño sahi, ta vaha chai vehe ñu”, ndichi xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tyicuan ta cana̱ ra chi noo noo ra yosoyɨcá chi chitoho ra. Ta quichaha catyí ra chi noo ra cuan: “¿Yoso yosoyɨcón chi chitohi?” catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tyicuan ta nacaha̱n ra cuan ta catyí ra: “Yuhu yosoyɨqué noo cumi mil litru aceitye.” Tyicuan ta ra yɨndaha tyiño cuan catyí ra chi ra: “Que̱hen nonga tutu ihya. Ta na̱tyaa uvi mil ri. Ta sa̱cuiton tutu chahnu cuan”, catyí ra. Tyicuan caa sacuvi̱ ra. Ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tyicuan ta chaa̱ inga ra. Ta quichaha ndaca tuhun tucu ra chi ra cuan ta catyí ra: “¿Yoso yosoyɨcá yoho chi chitohi?” Ta nacaha̱n ra cuan ta catyí ra: “Yosoyɨqué noo mil arroba trigu”, catyí ra. Tyicuan ta quichaha catyí ra yɨndaha tyiño cuan: “Que̱hen inga tutu, ta na̱tyaun uña cientu ri arroba. Ta sa̱cuita tutu chahnu chiña”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tyicuan ta chitó chitoho ra cha ña vaha cha chinyacuvi̱ ra. Ta iyo xaan cuñí ra vatyi yatyi xaan saha̱ ra cuan chi ra ―catyí ra Jesús. Ta quichaha catyi tucu ra chi ra cachicá noo chihin ra: ―Ñáyɨvɨ ña vaha añima yatyi xaan ca sahá ñu chi ñu ican saha ñáyɨvɨ vaha añima. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ta catyí chi ndo, vatyi co̱tyiño ndo cha tyayɨɨ cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya, ta sa̱ha ganaa ndo amigo. Ta quɨvɨ cha ndɨhɨ cha tyayɨɨ cuan, cuñihi ndo nu cunyicu ndo nya nu nyaá Nyoo tyicuan ri maa. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tatu chitó ndo cotyiño ndo chiin cha iyó chi ndo cha cuenda cha vaha, tyicuan caa coto tucu ndo cotyiño ndo tatu cuaha iyó chi ndo. Soco tatu ña chitó ndo cotyiño ndo chiin cha iyó chi ndo, tyicuan caa ma coto tucu ndo cotyiño ndo tatu cuaha coo chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta catyí chi ndo, tatu ña sahá ndo tumañi iñi chihin cha iyó chi ndo sɨquɨ ñuhu ñayɨvɨ̱ ihya, Nyoo ma cuhva ra noo cha tyayɨɨ cha ndicha chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tandɨhɨ cha iyó chi ndo maa Nyoo chaha̱ noo chi ndo. Soco tatu ña sahá ndo tumañi iñi chihin cuan, ma cuhva ra cha tahán chi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Noo musu ma cuvi coo uvi tahan chitoho ra. Vatyi musu cuan cuñí ca ra chi noo ra, ta ñima ca chi inga ra. O chi noo ra, vaha quichahá ra tuhun cahán ra, ta chi inga ra, ma quichaha ra cha cahán ra. Ma cuvi cuñi ndo chi Nyoo ta suri cuhva cuan cuñi tucu ndo cha tyayɨɨ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tyicuan ta cha chiñi̱ ra fariseo tandɨhɨ tuhun cahán ra Jesús. Tyicuan ta quichaha chacu cuehe ra nyehe ra chi ra. Vatyi maa ra fariseo cuan cuñí xaan ra chi xuhun. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tyicuan ta quichaha catyí ra Jesús chi ra: ―Vaha xaan sahá ndo chi ndo nuu ñáyɨvɨ. Soco chitó Nyoo vatyi añima ndo ña vaha. Ta tandɨhɨ cha catyí ñáyɨvɨ vatyi cahnu xaan ihya sɨquɨ ñuhu ñayɨvɨ̱, Nyoo ña cuñí nyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ley cha tachi̱ Nyoo chi ra Moisés vatyi tyaa ra, ta tuhun cha tyaa̱ ra profeta Nyoo ta cha naha, ican chi cuvi cha saquehe̱n ityi chi ñáyɨvɨ nyacua nya quɨvɨ chaa̱ ra Juan. Ta maa ra Juan quichaha cahan ra tuhun vaha vatyi cha cuñí quichi Nyoo vatyi cunyaca ñaha ra. Ta tandɨhɨ ñáyɨvɨ cha nducú cuhva yoso caa cunyaca ñaha Nyoo añima ñu, ican ñu quɨhvɨ ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Soco catyí chi ndo, vasɨ cunaa andɨvɨ ta ñuhu ñayɨvɨ̱, soco cha cuví ley Nyoo cha tyaa̱ ra Moisés, ma naa nyacua nya cha yaha̱ cuvi tandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tatu noo rayɨɨ iyó ñasɨhɨ ra, ta sanandoo ra chi ña, ta tandaha ra chihin inga ña, iyó cuatyi ra nuu Nyoo. Ta tatu tandaha noo rayɨɨ chihin noo ñaha cha sandoo yɨɨ chii, coo tucu cuatyi ra nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Chiyo̱ noo ra tyayɨɨ. Ta vaha ñihnó ra. Ta tandɨhɨ quɨvɨ iyó ra vico ta chachí vaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta chiyo̱ tucu noo ra ndahvi cha nañí Lázaro. Ta cuaha xaan ndɨhyɨ iñi ra. Ta nyaá ra yuvehe ra tyayɨɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta ra ndahvi cuan, cuñí ra cachi ra, vasɨ cha canacoyo nu mesa ra tyayɨɨ cuan. Ta nyacua nya ina ta chaa̱ tɨ nu nyaá ra, ta yuyaá tɨ nu cahvi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ta noo quɨvɨ cuan chihi̱ ra ndahvi cuan. Ta ángel Nyoo quehe̱n ra chi ra ta cua nyaca ra chi ra nya nu nyaá ra Abraham gloria. Tyicuan ta chihi̱ tucu ra tyayɨɨ cuan. Ta chicuchi̱ ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tyicuan ta ra tyayɨɨ cuan nyehé xaan ra tundoho nu ñohó ra anyaya. Ta nanyehe̱ ra nu cañi. Ta nanyehe̱ ra chi ra Abraham chihin ra Lázaro, nyaá ra chihin ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tyicuan ta canachaa̱ ra ta catyí ra: “Tata Abraham, cu̱ndahvi cuñi chii. Ta̱chi chi ra Lázaro na satyii ra chiin nundaha ra. Ta na satoo ra ɨɨn tɨtɨ ndutya nu yai. Vatyi nyehé xain tundoho nu cayú ñuhu̱ ihya”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Soco ra Abraham catyí ra chi ra: “Nɨ̱cohon iñun vatyi vaha chiyo̱n ñuhu ñayɨvɨ̱. Ta ra Lázaro, ña vaha chiyo̱ ra. Vityin vaha iyó ra ihya, ta yoho nyehún tundoho. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta sɨɨn ri, mahñu ihya cono xaan. Ta ma cuvi yaha ra iyó tyehe cuhun ra chiña. Ta ma cuvi yaha ra iyó chiña, quichi ra tyehe”, catyí ra Abraham chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tyicuan ta quichaha catyí ra tyayɨɨ cuan: “Tata Abraham, sa̱hun tumañi iñi chii. Ta ta̱chun chi ra Lázaro nya vehe suti. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vatyi iyó ohon tahan yañi. Ta cuñí vatyi nacatyi ra chi ra yoso caa iyé ihya nu nyehí tundoho, coto quichi coyo tucu ra cuan ihya”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tyicuan ta quichaha catyí ra Abraham: “Iyó ley cha tyaa̱ ra Moisés. Ta iyó tuhun cha tyaa̱ ra profeta Nyoo ta cha naha. Na quichaha ra tu cuñí ra”, catyí ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tyicuan ta quichaha catyí ra tyayɨɨ cuan: “Tata Abraham. Ma quichaha ra. Soco tatu yóó cha nandoto, ta cuhun cucahan chihin ra, yucuan ta tyasoho ra ta nasama ra cuhva iyó ra”, catyí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Soco ra Abraham catyí ra: “Tatu ña cuñí ra quichaha ra tuhun tyaa̱ ra Moisés ta tuhun cha tyaa̱ ra profeta Nyoo ta cha naha, ma chino iñi ra tuhun cahan noo ndɨyɨ tatu nandoto ra ta cahan ra chihin ra.” ");
INSERT INTO mxtNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tyehe caa catyí ra Jesús chi ra cachicá noo chihin ra: ―Tyicuan ri iyó cha quiñi caa cha satɨvɨ́ chi ñáyɨvɨ. Soco ndahvi ra ndahvi ra satɨvɨ́ chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaha taxin ca cuhñi ra noo yuu sucun ra. Ta cutuchi ra chi ra nu tyañuhu. Coto satɨvɨ ra chi ñu ni nasama cuhva iyó ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Sa̱ha ndo cuenda chi ndo. Tatu noo ra tahan ndo ta sacuvi ra noo cha ña vaha chihin ndo. Ca̱tyi ndo chi ra vatyi ña vaha cha sacuvi ra. Tatu nasama ra cuhva iyó ra, sa̱ha ndo tucahnu iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta nɨ ri maa sacuvi ra cha ña vaha chihin ndo ucha tahan chaha cha noo quɨvɨ. Tatu ndɨ ucha tahan chaha ta catyi ra chi ndo vatyi ndu uvi iñi ra cha sacuví ra chi ndo, ndɨ ucha tahan chaha sa̱ha ndo tucahnu iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tyicuan ta quichaha catyí ra cachicá tyiño nuu ra Jesús chi ra: ―Cu̱hva cha chinó ca iñi ndi chuun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tyicuan ta catyí ra Jesús chi ra: ―Tatu chinó iñi ndo chi yuhu vasɨ chiin ri tari cuhva noo chɨtɨ mostaza luhlu, cuví catyí ndo chi yutun sicómoro cha nanyaá ihya nacoyo tun, ta cucuinanyaa tun nu tyañuhu. Ta cucuvi nu cahan ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ta catyí ra Jesús: ―Tatu noo nyoho ta iyó noo musu ndo. Ta nachaa ra cha chaha̱n ra nu chiqui chi sahatyiño ra, o chi saha cumi ra quɨtɨ sana ndo, ¿atu catyí ndo chi ra: “Cu̱nyaa ta cachun”? Ña catyí ndo chi ra tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Soco tyehe caa catyí ndo chi ra: “Sa̱nduvaha cha cuxiñi. Ta tyi̱hun cha cachi. Cha yaha cha cachi tyicuan ta cachi tucu maun”, catyí ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ni ña tuhvá ndo nacuhva ndo tyahvi nyoo chi ra vatyi sacuvi̱ ra ñáá noo tyiño tava̱ ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tyicuan caa tucu nyoho chihin Nyoo. Quɨvɨ ndɨhɨ sacuvi ndo cha catyí Nyoo chi ndo, tahán chi catyí ndo: “Nyuhu chiin ri cha tachu̱n chi ndi, yucuan ri sacuvi̱ ndi. Ta ña yaha ca.” ");
INSERT INTO mxtNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ityi cuahan ra Jesús ityi ñuu Jerusalén yaha̱ ra nu cuví xahñi Samaria chihin Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nu chaa̱ ra noo ñuu, quita̱ coyo uchi tahan ra cuhví chihin cha tyahyu coño ra. Ta chicuitayucu ra nyasava ri. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ta quichaha cacanachaa ra chi ra Jesús, ta catyí ra: ―Yoho, Maestro Jesús, cu̱ndahvi cuñi chi ndi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tyicuan ta nanyehe̱ ra Jesús chi ra ta catyí ra chi ra: ―Cua̱han ndo. Ta cua sa̱ñaha ndo chi ndo chi tata sutu vatyi cha nduvaha̱ ndo. Tyicuan ta cuahan coyo ra cuan. Ta ityi cuahan coyo ra ta cananyehe̱ ra vatyi nduvaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tyicuan ta cuhva cha nanyehe noo ra cuan vatyi nduvaha̱ ra, cuanuhu chata ra nu nyaá ra Jesús. Ta cana̱ chaa ra, ta sacahnu ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta chicuɨñɨ̱ chɨtɨ ra. Ta nacañi̱ noo ra xiñi ra nya nu ñuhu nuu ra Jesús. Ta nacuhva̱ ra tyahvi nyoo chi ra. Ta ra cuan, ra Samaria cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tyicuan ta catyí ra Jesús chi ra: ―¿Atu ñima uchi tahan ndo nduvaha̱? ¿Nya nyaá inga ɨɨn tahan ca ra? ");
INSERT INTO mxtNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ñáá tuhun cha noo tuhun ri maa ra inga ñuu nandichi chata ra ta sacahnu ra chi Nyoo? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tyicuan ta quichaha catyí ra chi ra cuan: ―Ndu̱cuita ta cua̱han. Nduvahu̱n vatyi chinó iñun ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Candaca̱ tuhun ra fariseo chi ra Jesús, ta catyí ra: ―¿Ama quichi Nyoo cunyaca ñaha ra? Tyicuan ta ra Jesús quichaha catyí ra: ―Cha cunyaca ñaha Nyoo ihya sɨquɨ ñuhu ñayɨvɨ̱, ñima cha nyehé yo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma cuvi catyi ñáyɨvɨ: “Ma ra nyaá ihya, o ma ra nyaá ityi cuan.” Vatyi Nyoo cha chaa̱ ra mahñu ndo, ta nyacá ñaha ra añima ñáyɨvɨ cuenda ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yaha̱ cuan ta catyí ra chi ra cachicá noo chihin ra: ―Cuchaa chi quɨvɨ vatyi cucuñi ndo nyehe ndo chi yuhu Rayɨɨ cha quichi̱ nya gloria. Soco ma nyehe ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cuchaa tucu chi quɨvɨ ta cucatyi ñáyɨvɨ chi ndo: “Ihya nyaá ra”, o “Yucuan nyaá ra.” Soco ma cuhun ndo cunyehe ndo. Ta ma cunyicon ndo chi ra cuan vatyi ñime cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vatyi tandɨhɨ ñáyɨvɨ cunyehe chi yuhu Rayɨɨ cha quichi̱ nya gloria quɨvɨ quichi inga chaha. Tari nyehé tandɨhɨ ñáyɨvɨ nu quɨhvɨ tacha nɨcahnu andɨvɨ, tyicuan caa cucuvi. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Soco cunyehe xihne tundoho. Vatyi ñáyɨvɨ cha iyó cha vityin cua cutasɨ cuñi nyehe ñu chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tari cuví quɨvɨ ra Noé, tyicuan caa cucuvi quɨvɨ quichi yuhu Rayɨɨ cha quichi nya gloria inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Quɨvɨ ra Noé, chachí ñu. Chihí ñu. Tandahá ñu. Ta chahá ñu sehe ñu tandaha. Nya quɨvɨ quɨhvɨ̱ ra Noé chichi barcu ra, ta coon savi xaan. Ta tandɨhɨ ñu cachihi̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tyicuan caa tucu cuvi̱ quɨvɨ ra Lot. Chachí ñu. Chihí ñu. Satá ñu. Xicó ñu. Tachí ñu. Ta savahá ñu vehe ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Soco quɨvɨ cha quita̱ ra Lot ñuu Sodoma cuan, coo̱n ñuhu̱ chihin azufre andɨvɨ. Ta chihi̱ tandɨhɨ ñáyɨvɨ Sodoma. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ta tyicuan caa cucuvi quɨvɨ cha quichi tucu yuhu Rayɨɨ cha quichi nya gloria inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ta quɨvɨ cuan tatu nyicú ndo nuquehe ndo, ma ndɨhvɨ ndo chichi vehe ndo vatyi tava ndo ndaha tyiño ndo. O tatu chicá noo ndo nu chiqui, ma cunuhu ndo nya vehe ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nɨ̱cohon iñi ndo ñasɨhɨ ra Lot, ñáá cha cuvi̱ chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tandɨhɨ ndo cha cuñí ca ndo cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya, cucunaa ndo. Ta tandɨhɨ ndo cha ña quichaha ndo cha iyó ñáyɨvɨ̱ ihya, cucacu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ta catyí chi ndo vatyi cha cuaa cuan uvi tahan ra cucava noo nu chito. Noo ri ra cunaquehin. Ta nonga ra cundoo ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ta uvi tahan ñusɨhɨ ɨɨn ri cu nyicó ñu quɨvɨ cuan. Noo ri ña, cunaquehin. Ta nonga ña cundoo ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ta catyí chi ndo vatyi uvi tahan ra cohon nu chiqui. Noo ra cunaquehin, ta nonga ra cundoo ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cuhva cha chiñi̱ ñu tuhun ihya, quichaha ndaca tuhun ñu chi ra Jesús. ―¿Nya maa maa cucuvi ihya Tata? ―catyí ñu. Tyicuan ta nacaha̱n ra Jesús ta catyí ra: ―Nu catuví coño ñuhu chihi, yucuan cundu ɨɨn ri chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tyicuan ta chaha̱ ra Jesús noo cuhva ihya. Vatyi na cacan tahvi ñu tyicuan ri maa, ta ma cundihñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta catyí ra: ―Iyó noo ñuu cha nyaá noo juez. Ta juez cuan ña sahá maa ra ñáyɨvɨ chi Nyoo. Ta nɨ ri ña quichaha maa ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta suri ñuu cuan iyó tucu noo ñaha ndahvi cha chihi̱ yɨɨ. Ta chaha̱n ña chicahan ña chihin ra, vatyi chicá ña cuatyi chaha noo ra xaan iñi chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta juez cuan ña quichaha̱ maa ra chi ña. Ña sandaa̱ maa ra tyiño chicá ña. Ta cha naha xaan chicán ña. Tyicuan ta quichaha ndichi xiñi juez cuan: “Vasɨ ña yuhví chi Nyoo, ta ñahri cuende chi ñáyɨvɨ, ");
INSERT INTO mxtNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","soco ñaha ihya sayangá xaan ña chii. Ta yucuan chaha cua sacaqui chi ña. Vatyi coto quichi ca ña, ta sanaquɨquɨ ña tɨsɨhi”, ndichi xiñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tyicuan ta catyí ra Jesús: ―Tyicuan caa catyi̱ juez ña vaha cuan. Tu juez cuan cha quiñi iyó ra ta tyinyee̱ ra chi ñaha ndahvi cuan, ");
INSERT INTO mxtNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ta nyaca cuví Nyoo, ¿atu ma tyinyee ra chi ñáyɨvɨ cha chicán ndiyaca ta ndɨquɨvɨ chi ra? ¿Atu cuatu xaan ra cha tyinyee ra chi ñu? ");
INSERT INTO mxtNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Catyí chi ndo, vatyi numi ri cutyinyee ra chi ñu. Soco quɨvɨ quichi yuhu, Rayɨɨ cha quichi̱ nya gloria, inga chaha, chitó Nyoo tatu nañihi que chi ñu cha ndicha chinó iñi chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tyicuan ta chaha̱ ra Jesús nonga cuhva cuenda ra savahá chii, ta ña cuñí nyehe ra chi inga ra. Ta quichaha catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Iyó uvi tahan ra chaha̱n chichi vehe ñuhu chicaca̱n tahvi ra chi Nyoo. Noo ra cuan ra fariseo cuví ra. Ta inga ra cuan ra tavá xuhun cuenda gobiernu ñuu Roma cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ta ra fariseo cuan chicuinanyaa ra, ta quichaha cahan ra chihin Nyoo. Ta cahnu saha ra chi ra. Ta catyí ra: “Sutu Mañi yuhu, nacuhve tyahvi nyoo chuun vatyi yuhu ñima tari inga ñáyɨvɨ cuví. Vatyi suhu ñu. Quiñi iyó ñu. Iyó ñasɨhɨ ra ta iyó inga ñusɨhɨ chi ra. Ta nɨ ri ñima tari ra tavá xuhun cuan cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Vaha ca quichahí tuhun maun ta ñima ca inga ñáyɨvɨ. Vatyi uvi chaha cha noo vitya ña chachí. Ta chahí uchi sɨquɨ noo noo cientu cha sahá ganai chuun”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Soco ra tavá xuhun cuenda gobiernu Roma cuan cha cañi ri chiin nanyaá ra. Ta ña caña iñi ra nanyehe ndaa ra. Ta cañí ra ndaha ra añima ra vatyi ndu uvi iñi ra cuatyi ra. Ta catyí ra: “Sutu Mañi yuhu. Nye̱he ndahvi chii vatyi iyó xaan cuatyi”, catyí ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta catyí tucu ra Jesús tyehe caa: ―Catyí chi ndo vatyi Nyoo sahá ra tucahnu iñi chi ra tavá xuhun cuan. Sanaa̱ Nyoo cuatyi ra ta cuanuhu ra nya vehe ra. Soco ra fariseo cuan, ñahri tucahnu iñi ñihi ra, vatyi yóó ñáyɨvɨ cha savahá xaan chi nuu Nyoo, cusanocuee Nyoo chi ñu, ta ñu sanocuee chi, Nyoo cusanducahnu ra chi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tyicuan ta quichi nyaca ñáyɨvɨ chi ra cuatyaa chi ra Jesús vatyi na tyiso ra ndaha ra xiñi ndotyin. Soco cuhva cha nanyehe̱ ra cachicá noo chihin ra vatyi tyicuan caa, ña chaha̱ ca ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tyicuan ta cana̱ ra Jesús chi ra cachicá noo chihin ra, ta catyí ra chi ra: ―Sa̱ña ndo chi ra cuatyaa na quichi maa ndotyin nu nyai. Ta ma casɨ ndo, vatyi ñu nyacá ñaha Nyoo añima, cuví ñu tari ra cuatyaa ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta catyí chi ndo vatyi tatu ña ita iñi ndo chi Nyoo, tari noo ra cuatyaa ita iñi ndotyin chi sutu ndotyin, ma cuvi quɨhvɨ ndo nu nyacá ñaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tyicuan ta noo ra cha cuví nuu cuenda vehe ñuhu ndacá tuhun ra chi ra Jesús, ta catyí ra: ―Maestro, ra vaha cuvún. ¿Yoso caa cunyacuvi ta ñihi ñayɨvɨ̱ cha ma naa ca maa coi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tyicuan ta catyí ra Jesús chi ra: ―¿Ñáá tuhun catyún vatyi ra vaha cuví? Noo ri maa Nyoo cuví ra ra vaha. (Ta cha catyún tyi vahi, nacotón tyi Nyoo cuví.) ");
INSERT INTO mxtNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yoho chitón tandɨhɨ tuhun cha tachi̱ Nyoo tyi sacuvi yo: “Cha ma coo inga ñusɨhɨ chuun. Ma cahñun chi ñáyɨvɨ. Ma suhun. Ma cahun cuendu sɨquɨ ñáyɨvɨ. Ta sa̱hun ñáyɨvɨ chi sutun ta chi sɨhun” ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tyicuan ta ra cuan catyí ra: ―Tandɨhɨ ihya ta quichahí nyata luhli ta nyacua nya vityin ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nu chiñi̱ ra Jesús cha catyí ra cuan, tyicuan ta catyí ra chi ra: ―Soco cumañi sacuvun nonga cha sacuvun. Xi̱co tandɨhɨ cha iyó chuun. Ta cu̱hva chi ñu ndahvi. Ta qui̱chun chate. Tyicuan ta coo cha tyayɨɨ chuun nya gloria ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Soco ra cuan nu chiñi̱ ra tuhun cuan, nducuihya xaan iñi ra, vatyi tyayɨɨ xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cha nanyehe̱ ra Jesús vatyi nducuihya iñi ra, ta quichaha catyi ra: ―Yɨɨ xaan ta cuvi nacuhva cuenda ñu tyayɨɨ chi ñu na cunyaca ñaha Nyoo añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tañi tyehe yaha noo camello xiu noo yɨquɨ tɨcu, ta ñima ca cha quɨhvɨ noo ñu tyayɨɨ nu nyacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ta ñu cha cachiñi̱ tuhun ihya catyí ñu: ―Tatu tyicuan caa, ¿yóó cha cuví cacu vii? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tyicuan ta ra Jesús catyí ra: ―Tandɨhɨ cha ña cuví sacuvi rayɨɨ, Nyoo cuví sacuvi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tyicuan ta ra Pedro catyí ra: ―Sutu Mañi yuhu, nyuhu tandɨhɨ maa cha iyó chi ndi sandoo̱ ndi, ta nyicón ndi chuun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tyicuan ta catyí ra Jesús chi ra: ―Cha ndicha catyí chi ndo. Vatyi tandɨhɨ ndo cha sandoo ndo vehe ndo, o ñasɨhɨ ndo, o yañi ndo, o sutu ndo, o sehe ndo cha catyi cha chaha̱ ndo cha cunyaca ñaha Nyoo añima ndo, ");
INSERT INTO mxtNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cuaha xaan cha vaha cunañihi ndo ihya ñayɨvɨ̱ ta cunañihi ndo inga ñayɨvɨ̱ cha ma naa ca maa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ta cana̱ sɨɨn ra Jesús chi ndɨ uchi uvi ra cachicá noo chihin ra, ta catyí ra chi ra: ―Vityin cuhun yo nya Jerusalén. Vatyi yucuan cuchino cava tandɨhɨ tuhin cha tyaa̱ ra profeta Nyoo ta cha naha. Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vatyi cucuhva cuenda ra chii chi ra inga ñuu, ra cha ñima ra ñuu Israel cuví. Ta cucuacu nyaa ra chii. Ta cucahan ra chii. Ta cutyicusɨɨ ra nui. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta cucañi ra chii, ta cucahñi ra chii, soco nu cu uñi quɨvɨ ta cunandote ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta ra cachicá noo chihin ra ña cutuñi iñi ra tuhun cuan ni ña cachitó ra ñáá tuhun cahán ra Jesús chihin ra. Vatyi ña chaha̱ Nyoo vatyi cacutuñi iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cuhva cha cua chaa ra Jesús ñuu Jericó. Ta yuhu ityi cuan nyaá noo ra cuaa. Ta chicán ra limuxtan. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tyicuan ta chiñi̱ ra vatyi cuaha xaan ñáyɨvɨ cua yaha. Ta ndaca̱ tuhun ra ñáá cha cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ta ñáyɨvɨ nacatyí ñu chi ra vatyi ra Jesús, ra ñuu Nazaret, ican cua yaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tyicuan ta quichaha cana chaa ra: ―¡Yoho Jesús, ra vachi tata rey David! ¡Cu̱ndahvi cuñi nyehun chii! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ta ra cha cuahan coyo ityi nuu cuan, quichaha cacatyi ra chi ra, nacasɨ ra yuhu ra. Soco chaa ca caná chaa ra, ta catyí ra: ―¡Yoho, ra vachi tata ra David! ¡Cu̱ndahvi cu̱ñi nyehun chii! ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tyicuan ta chicuɨñɨ ra Jesús yucuan. Ta tachi̱ ra tyiño na cuquehen chi ra cuaa cuan. Ta cuhva cha chaa̱ ra cuaa cuan nu nanyaá ra Jesús, ta ra Jesús quichaha ndaca tuhun ra chi ra, ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ñáá cha cuñún vatyi sacuvi chuun? Tyicuan ta ra cuaa cuan nacahan ra, ta catyí ra: ―Sutu Mañi yuhu, cuñí nanyehi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tyicuan ta catyí ra Jesús chi ra: ―Na̱nyehe. Cha nduvaha̱ chɨtɨ nuun, vatyi chinó iñun chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ta caa cuhva ri cuan, ra cuaa cuan nanyehe̱ ra. Ta cuahan ra chata ra Jesús. Ta sacahnú ra chi Nyoo. Ta tandɨhɨ ñáyɨvɨ cha nyehe ñu tyicuan caa, sacahnú ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yucuan ta quɨhvɨ̱ ra Jesús ñuu Jericó cuan. Ta cua yaha ra chichi ñuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta yucuan iyó noo ra tyayɨɨ vavaha. Nañí ra Zaqueo. Ta ra cuví nuu cuenda ra catava xuhun cuenda gobiernu ñuu Roma cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta cuñí xaan ra cohon nuu ra chi ra Jesús. Ta ña cuví nyehe ra chi ra vatyi cuaha xaan ñáyɨvɨ. Ta maa ra tyaha xaan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yucuan ta chino vavaha ra cuahan ra ityi nuu, ta ndaa̱ ra nu noo yutun cha nañí sicómoro cha nanyaá yuhu ityi nu cua yaha ra Jesús, tacuhva cuvi nyehe ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta cuhva cha yaha̱ ra Jesús nanyehé ndaa ra ityi sɨquɨ ta nanyehe ra chi ra Zaqueo. Ta quichaha catyí ra chi ra: ―Zaqueo, sa̱numi ta no̱un nu yutun chiña. Vatyi vityin cuhin vehun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tyicuan ta numi ri noo̱ ra Zaqueo nuu yutun cuan. Ta sɨɨ vavaha cuví chi ra. Ta quehe̱n cuenda ra chi ra Jesús. Ta cuahan ra chihin ra nya vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ta cha nyehe̱ ñáyɨvɨ cha tyicuan caa, ta tandɨhɨ ñu quichaha cahán nyaa ñu chi ra Jesús. Ta catyí ñu vatyi ndoo̱ ra vehe noo ra iyó cuatyi. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nu canyicú ra chichi vehe cuan, ra Zaqueo nɨcuinanyaa̱ ra. Ta quichaha catyí ra chi ra Jesús: ―Sutu Mañi yuhu, yuhu cua cuhve sava cha iyó chii chi ñu ndahvi. O tatu suhi chi ñáyɨvɨ chihin cha sandavi ñahi chi ñu, vityin cunacuhva cuende nya cumi ca tahan chaha chi ñu ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tyicuan ta catyí ra Jesús: ―Vityin cacu añimon, ta ñáyɨvɨ chi ra Abraham cuvún. Vatyi nacuhva cuendon chuun chi Nyoo tari nacuhva cuenda ra Abraham chi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vatyi yuhu Rayɨɨ cha quichi̱ nya gloria vachi nanduqui ta vachi sacaqui chi ñáyɨvɨ cha cua naa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta cha nɨ ri ca cha chiñí ñáyɨvɨ tuhun cahán ra Jesús, quichaha cahan tucu ra inga cuhva ihya. Vatyi cha cuyatyin chaa ra Jerusalén. Ta ñáyɨvɨ cuñí maa ñu vatyi cha cua quichaha ra cunyaca ñaha ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tyicuan ta catyí ra: ―Chiyo noo ra vaha ta cuñí cuhun ra noo ñuu cañi. Vatyi yucuan cunanduvi ra rey tacuhva vatyi ndichi ra ñuu ra, soco cha cuví ra rey. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta cuhva cha cumañi cuhun ra, cana̱ ra chi uchi tahan musu ra. Ta chaha̱ cuenda ra noo xuhun chi noo noo ra. Ta catyí ra chi ra: “Sa̱ha tyiño ndo chihin xuhun chiña nyacua nya ndichi mai”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Soco suhva ñáyɨvɨ ñuu ra, tasɨ cuñí ñu nyehe ñu chi ra ta ña cuñí ñu cha cuví ra rey chi ñu. Ta tachi̱ ñu chi suhva ra cuhun chata ra, vatyi catyi ra vatyi ña cuñí ñu cha cuví ra rey chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Soco ra cuan nduvi̱ ra rey. Tyicuan ta nachaa̱ ra nya ñuu ra. Ta quɨvɨ cha nachaa̱ ra, cana̱ ra chi musu ra, ra cha sandoo̱ ra xuhun chii. Vatyi coto ra yoso saha̱ ganaa xuhun ra cha nɨ ri ca cha chaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ta chaa̱ noo ra cuan. Ta catyí ra: “Tata, saha̱ ganai uchi ca tahan chaha sɨquɨ xuhun cha sandou̱n chii”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tyicuan ta quichaha catyí rey cuan chi ra: “Vaha xaan. Yoho vaha musu cuvún. Vatyi vaha saha̱ tyiñon chihin chiin xuhun cha chahi̱ chuun. Ta vityin cunyaca ñahun uchi tahan ñuu”, catyí rey cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tyicuan ta chaa̱ tucu inga ra cha chaha̱ ra xuhun chii. Ta quichaha catyí ra: “Ma xuhun ihya. Saha̱ ganai ohon tahan ca chaha sɨquɨ xuhun cha sandou̱n chii”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tyicuan ta catyí rey chi ra: “Yoho cunyaca ñahun ohon tahan ñuu”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tyicuan ta chaa̱ tucu inga ra cuan. Ta quichaha catyi ra: “Ma xuhun ihya cha chahu̱n chii. Yuhu chicumi̱ vahi chichi noo pañitu. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Vatyi yuhví xain chuun, vatyi yoho cuvún noo ra xaan. Vatyi naquehun cha ñima chuun cuví. Ta naquehun tyiño saha inga ñáyɨvɨ”, catyí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tyicuan ta rey cuan catyí ra chi ra: “Yoho musu ña vaha cuvún. Vityin suri chihin tuhun cha catyun chii, cucatyi tucu yuhu chuun. Tatu chitón vatyi yuhu, xain, ta chitón vatyi naquehin cha ñima chii cuví, ta naquehín cha ña saha̱ tyiñe, ");
INSERT INTO mxtNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿ñáá tuhun ña chahu̱n ta chityihu̱n xuhin banco vatyi nachai soco cha nducuaha ca xuhin?” catyí rey cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ta quichaha catyí ra chi ra canyicú cuan: “Ti̱nyaa ndo xuhun cha chahi̱ chi ra, ta cu̱hva ndo chi ra cha saha ganaa uchi ca tahan cuan”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tyicuan ta quichaha catyi ra chi rey cuan: “Tata, soco ra cuan, cha iyó uchi tahan chi ra”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tyicuan ta rey cuan catyí ra: “Soco catyi yuhu chi ndo. Vatyi ra cha vaha ca sahá tyiño chihin cha chahi̱ chi, cucuhva que chi ra. Ta ra cha chahi̱ chiin ri, ta ña cuñí ra sahá tyiño ra chihin cuan, cutinyaa ndɨhi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta tandɨhɨ ñu xaan iñi chii, ñu ña cuñí vatyi cunyaca ñahi chi ñu, nya̱ca ndo chi ñu tyehe vatyi cahñi ndo chi ñu nui”, catyí rey cuan ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cha yaha̱ cahan ra Jesús cuhva cuan, ta sañihi ra cuahan ra ityi Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yucuan ta cua chaa ra ñuu Betfagé chihin ñuu Betania, yatyin ri noo yucu cha nañi Olivo, vatyi maa maa ri maa tun Olivo iyó yucuan. Ta tava̱ ra tyiño chi uvi tahan ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ta catyí ra chi ra: ―Cua̱han ndo ñuu cha nyaá yatyin ri cuan. Ta yucuan cunañihi ndo noo burru luhlu, quɨtɨ ta coto ca tyayu, nuhñí tɨ. Nda̱chi ndo chi tɨ. Ta nya̱ca ndo chi tɨ tyehe. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tatu yóó cha catyí chi ndo: “¿Ñáá tuhun cha ndachi ndo chi tɨ?” ca̱tyi ndo chi ñu: “Vatyi chiñuhú tɨ chi maa ra nyaca ñaha chi yo.” ");
INSERT INTO mxtNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tyicuan ta ra cachicá noo chihin ra, cuahan coyo ra. Ta nañihi̱ ra chi tɨ tari cuhva catyí maa ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ta cuhva cha candachi ra chi tɨ, chaa̱ coyo chitoho tɨ. Ta candaca tuhun ra chi ra: ―¿Ñáá tuhun cha ndachi ndo chi burru chiña? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tyicuan ta canacaha̱n ra cuan ta cacatyi ra: ―Ndachí ndi chi tɨ vatyi chiñuhú tɨ chi maa ra nyacá ñaha ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tyicuan ta quehe̱n ra chi tɨ. Ta chinyaca̱ ra chi tɨ nu nyaá ra Jesús. Ta tyiso̱ ra sahma ra sɨquɨ tɨ. Tyicuan ta casandaa̱ ra chi ra Jesús sɨquɨ tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tyicuan ta cuahan ra Jesús. Ta cuaha vavaha ñáyɨvɨ cachacu̱n ñu sahma ñu ityi nu cua yaha ra, yosó ra burru cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tyicuan ta cha cua cuyatyin tandɨhɨ ñu chihin ra Jesús nu iñi noo yucu Olivo cuan. Ta quichaha cana̱ chaa tandɨhɨ ñu chinó iñi chi ra chihin cha sɨɨ cuví chi ñu. Ta sacahnú ñu chi Nyoo vatyi cuaha xaan cha vaha nyehe̱ ñu cha sacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yucuan chaha catyí ñu: ―¡Na sacahnu yo chi Rey ihya vatyi vachi ra chihin sɨvɨ Nyoo! ¡Na coo cha taxi ri andɨvɨ! ¡Ta na sacahnu yo chi Nyoo! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tyicuan ta suhva ra fariseo cha cuahan coyo chihin ñáyɨvɨ cuan quichaha cacatyi ra: ―Maestro, sa̱cutaxin chi ñu nyicón chuun ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nacaha̱n ra Jesús ta catyí ra: ―Tatu ñáyɨvɨ ihya ta cu taxin ñu, nyacua nya yuu ta nacana chaa chi, ta sacahnu chi chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yucuan ta cha cua chaa ra yatyin ri Jerusalén cuan. Ta nanyehe ra Jesús chi ñuu cuan ta quichaha chacu chaa ra vatyi cuihya iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ta catyí ra: ―Tyehe ta chitó nyoho, ta cutuñi iñi ndo yoso caa cha vaha cha vachi nyaque chi ndo quɨvɨ ihya. Soco xehe xaan ñohó cha chiñi tuñi cuan, ta ña nañihí maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Soco cuchaa quɨvɨ ña vaha vatyi ra xaan iñi chi ndo cutyihi chacu ra chi ndo. Vatyi tandɨhɨ ri ityi cuquichi coyo ra sɨquɨ ndo. Ta cucañi tahan ra chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta cucacun ñuhú ra chi ndo ta cucahñi ra chi ndo. Ta ni noo yuu yoso nyitahan ta ma sandoo ra. Tyicuan caa cucuvi vatyi ña cuñí ndo nacoto ndo cha quichi̱ Nyoo quichi sacacu ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tyicuan ta ra Jesús quɨhvɨ̱ ra chichi nuquehe vehe ñuhu cahnu. Ta quichaha tava ñehe ra tandɨhɨ ra caxicó ta casatá yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta catyí ra chi ra: ―Nu tutu Nyoo catyí chi vatyi vehe Nyoo, nu chicán tahvi yo chi ra cuví. Soco nyoho sananduvi̱ ndo vehe nu nyicú ra suhu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta tandɨhɨ quɨvɨ chahán ra Jesús chisañaha ra chi ñáyɨvɨ chichi vehe ñuhu cuan. Soco ra cacuví nuu chi tata sutu, ta ra casacuahá cuenda ley vehe ñuhu, ta ra cacuví nuu chi ñuu cuan, canducú ra cuhva yoso caa ta cahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Soco ña ñihí maa ra cuhva yoso caa sacuvi ra. Vatyi tandɨhɨ ñáyɨvɨ ta vaha tyasohó ñu tuhun cahán ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Noo quɨvɨ cuan cha nɨ ri ca cha sañahá ra Jesús chi ñáyɨvɨ chichi vehe ñuhu cahnu, ta cahán ra tuhun yoso caa sacacú Nyoo chi ñu. Ta chaa̱ coyo ra cuví nuu chi tata sutu chihin ra casacuahá cuenda ley vehe ñuhu, ɨɨn ri chihin ra cacuví mandoñi. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ta cacatyí ra chi ra: ―Ca̱tyi chi ndi ¿yóó cha tyaa̱ tyiño chuun vatyi sacuvun tyehe caa? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tyicuan ta ra Jesús quichaha catyí ra chi ra: ―Yuhu tucu cua ndaca tuhin noo tuhun chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yóó cha tachi̱ chi ra Juan vatyi sacondutya ra chi ñáyɨvɨ? ¿Atu Nyoo tachi̱ chi ra, o ñáyɨvɨ? ");
INSERT INTO mxtNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tyicuan ta cacatyí ra cuan chi ra tahan ra: ―Tatu catyí yo vatyi Nyoo tachi̱ chi ra Juan cuan, cucatyi ra chi yo “Ñáá tuhun ña chinó iñi ndo tuhun caha̱n ra.” ");
INSERT INTO mxtNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta tatu catyí yo vatyí ñáyɨvɨ tachi̱ chi ra, ñáyɨvɨ cahñi ñu chi yo chihin yuu. Vatyi tandɨhɨ ñu, ta cuñí ñu vatyi Nyoo tachi̱ chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tyicuan ta cacatyi ra chi ra Jesús vatyi ña cachitó ra yóó cha tachi̱ chi ra Juan vatyi na sacondutya ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tyicuan ta ra Jesús catyí ra chi ra: ―Nɨ ri yuhu, ta ma catyi chi ndo yóó cha tachi̱ chii, cha sacuvi tyehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tyicuan ta quichaha catyi ra Jesús noo cuhva ihya chi ñáyɨvɨ: ―Noo ra tachi̱ ra cuaha yoho tɨchaha ndɨvɨ nu ñuhú ra. Yaha̱ cuan ta chaha̱ noo ra ñuhú cuan chi suhva ra casaha tyiño. Tyicuan ta naha cuahan ra inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta chaa̱ quɨvɨ cha iñí chɨtɨ cuan. Tyicuan ta tachi̱ ra chi noo musu vatyi cuquehen ra suhva chɨtɨ cha tahán chi chi ra. Soco cacañi xaan ra casahá tyiño cuan chi musu cuan. Ta sacunuhu ra chi ra chihin nu ndaha nu ndɨɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tyicuan ta chitoho yoho tɨchaha ndɨvɨ cuan tachi̱ tucu ra chi inga musu. Suri cacañi̱ xaan ra chi ra. Ta cacahan uhvi ra chi ra. Ta natachi̱ ra chi ra. Soco suri ñahri cachaha ra cuiso ra cunuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tyicuan ta chitoho cuan tachi̱ tucu ra chi inga ra. Soco suri tyicuan caa chinyacuvi tucu ra chihin ra. Ta sañicuehe̱ ra chi ra. Ta tava̱ ñehe ra chi ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Yaha̱ cuan ta quichaha catyi chitoho ñuhu cuan: “¿Yoso caa cunyacuvi vityin? Cua tachi chi sehi, ra cha cuñí vavahi. Ta cha nanyehe ra chi ra, vasɨ casaha ra ñáyɨvɨ chi ra, vatyi sehi cuví chi ra.” ");
INSERT INTO mxtNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Soco cuhva cha cananyehe̱ ra casahá tyiño cuan chi ra, catyí ra chi ra tahan ra: “Ican ra ihya cundoo chihin ñuhú ihya tatu chihi sutu ra. Soco nacahñi yo chi ra. Vatyi ndoo maa yo chihin ñuhú ihya”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tyicuan ta tava̱ ñehe ra chi sehe chitoho ñuhú cuan ityi chata chacu. Ta cachahñi̱ ra chi ra ―catyí ra Jesús. Tyicuan ta catyí ra Jesús chi ñáyɨvɨ nyicú cuan: ―¿Ñáá cha cusacuvi chitoho ñuhú cuan chi ra cachahñi̱ chi sehe ra cha cuhva cha cuñí nyoho? ");
INSERT INTO mxtNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Catyí chi ndo vatyi quichi ra ta cahñi ra chi ra casahá tyiño cuan. Ta cuhva ra ñuhú cuan chi inga ra ―catyí ra Jesús. Ta cuhva cha chiñi ñáyɨvɨ tuhun cuan, yuhví xaan ñu cuví. Ta quichaha catyí ñu: ―¡Ña cuñi Nyoo ta cuvi tyicuan caa! ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Soco ra Jesús nanyehe ra chi ñu ta catyí ra: ―Tyicuan caa cucuvi. Vatyi nyaá nu tutu Nyoo ta catyí chi tuhin tyehe caa: Yuu cha ña cuñí ra casavahá vehe cotyiño ra, Ican cuan cuví yuu cha nɨñɨ ca. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tari tahnu noo ra cha canacava sɨquɨ yuu, tyicuan caa tɨvɨ ñu ña cuñí quichaha tuhun cahín. Ta sɨɨn ri, tari taxin nyihi noo ra cha canacava yuu sɨquɨ, tyicuan caa cunaa ñu ña cuñí quichaha tuhun cahín ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ta ra cacuví nuu chi tata sutu ta ra casacuahá cuenda ley vehe ñuhu catuvi̱ iñi ra vatyi tuhun cha catyí ra Jesús, chi maa ra nañi cuan. Ta cuñí ra catɨɨn ra chi ra Jesús vatyi cacahñi ra chi ra. Soco ña cachitó maa ra yoso caa. Vatyi yuhví ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tyicuan ta catachi̱ ra chi suhva ra vatyi cunducu nyehe ra chi ra Jesús. Ta casaha̱ ra tyi ra vaha cacuvi ra. Vatyi coto ra ñáá noo tuhun ña vaha cahán ra Jesús tacuhva cuvi catɨɨn ra chi ra. Ta cuhva cuenda ra chi ra chi gobernador. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yucuan chaha candaca̱ tuhun ra casavaha chii cuan chi ra Jesús: ―Maestro, chitó ndi vatyi vaha tuhun cahún. Ta sañahún cha vaha chi ñáyɨvɨ. Ta ñima cuhva iyó ri ñu nyehun soco añima ñu ñandɨhɨ. Ta maa ri maa ityi Nyoo sañahún. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ca̱tyi chi ndi ¿atu vaha cha tyiyahvi yo cha chicán gobiernu ñuu Roma chi yo, o ña vaha? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Soco ra Jesús tuví iñi ra vatyi cuñí ra nducu nyehe ra chi ra. Ta catyí ra chi ra: ―¿Ñáá tuhun cuñí ndo nducu nyehe ndo chii? ");
INSERT INTO mxtNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Sa̱ñaha ndo noo xuhun chiña chii, na nyehi. ¿Yóó chi nuu ta yóó chi sɨvɨ nyaá nu xuhun ihya? ―catyí ra. Tyicuan ta nacaha̱n ra cuan, ta catyí ra: ―Nuu gobiernu, ta sɨvɨ ra ñandɨhɨ ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tyicuan ta catyí ra Jesús: ―Tu tyicuan caa, cu̱hva ndo xuhun chiña chi ra cuví gobiernu cuan vatyi chi maa ra tahán chi. Ta cu̱hva tucu ndo chi Nyoo cha tahán chi chi ra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta ña cuví maa sandahvi ñaha ra chi ra Jesús chihin tuhun cahán ra nuu ñáyɨvɨ. Ta iyo xaan cacuñí ra tuhun cha nacaha̱n ra. Ta taxi ri cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cha yaha̱ cuan ta chaa̱ coyo suhva ra saduceo nu nyaá ra Jesús. Maa ra cuví ra casañahá vatyi ña nandotó ndɨyɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tyicuan ta catyí ra chi ra Jesús: ―Maestro, sandoo̱ ra Moisés tuhun ihya vatyi tatu noo ra chihi̱ ra ta ndoo ñasɨhɨ ra, tatu yori sehe ra chiyo̱ chihin ña, tahán chi cha tandaha yañi ra chihin ña tacuhva cha ma cunaa tata yañi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Soco cuñí ndi coto ndi vatyi chiyo̱ ucha tahan ra chihin yañi ra. Ta ra cha ñihi ca chicoo̱ ñasɨhɨ ra, soco yori sehe ñu chiyo̱, ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tyicuan ta naquehe̱n ra cha cu uvi suri maa ña cuan. Ta yori tucu sehe ñu chiyo̱. Ta chihi̱ tucu ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ta suri tyicuan caa cuvi̱ chihin ra cu uñi cuan. Ta suri tyicuan caa cuví chi ndɨ ucha ra. Ni noo ra ta yori sehe ra chiyo̱ chihin ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta nu ndɨhɨ tuhun chihi̱ ndɨhɨ maa ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta cuñí ndi coto ndi yóó ra cuví ñasɨhɨ chi ña chichi cha ndɨ ucha tahan ra cuan nu cunandoto ñu nuu Nyoo ―cacatyí ra saduceo cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tyicuan ta nacaha̱n ra Jesús, ta catyí ra: ―Ihya ñayɨvɨ̱, rayɨɨ ta ñusɨhɨ tandaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Soco ñu cha tahán chi nandoto inga ñayɨvɨ̱ nu nyacá ñaha Nyoo, ña tandaha ca ñu ta ni ma cuhva ca ñu sehe ñu tandaha. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ta ñahri tuhun chihi iyó nyicuan. Soco cucuvi ñu tari ángel. Ta cuví ñu sehe Nyoo cha ndicha vaha vatyi nandoto̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Cha ndicha cuví vatyi ra Moisés nu sacoto̱ ra tuhun cha cayu taca iñu cuan, yucuan sacotó ra chi yo vatyi ñu chihi nandotó ñu. Vatyi yucuan catyí ra vatyi Sutu Mañi yo Nyoo cuenda ra Abraham, ta Nyoo cuenda ra Isaac, ta Nyoo cuenda ra Jacob, cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vatyi Nyoo ñima Nyoo cuenda ñáyɨvɨ chihi cuví ra. Nyoo cuenda ñu nyitó cuví ra. Vatyi cha cuenda Nyoo tandɨhɨ yo ta nyitó añima yo vasɨ chihi̱ coño ñuhu yo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tyicuan ta suhva ra casacuahá cuenda ley vehe ñuhu catyí ra: ―Vaha xaan nacahu̱n Maestro ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yucuan ta ña caña ca maa iñi ra candaca tuhun ra ñáá ca tuhun chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tyicuan ta ndaca̱ tuhun ra Jesús chi ñu: ―¿Ñáá tuhun cha catyí ndo vatyi ra Cristo tata ra David vachi ra? ");
INSERT INTO mxtNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Vatyi suri maa ra David catyí ra nu libru Salmo tyehe caa: Cahán Suti Nyoo chihin Suti ra Cristo, ta catyí ra chi ra: “Cu̱nyaa chiyo vahi nyacua nya cuhve chi ra xaan iñi chuun vatyi cuaca chahun sɨquɨ ra”, catyí Nyoo chihin yuhu ra David ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Yoso caa cha ra vachi tata ra David cuví chi ra Cristo, ta suri maa ra David catyí vatyi Sutu ra cuví chi ra Cristo? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tandɨhɨ ñáyɨvɨ cachiñí ñu tuhun cahán ra Jesús chihin ra cachicá noo chihin ra nu catyí ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Sa̱ha ndo cuenda chi ndo chihin ra casacuahá ley vehe ñuhu. Tahán xaan iñi ra cuihno ra sahma cañi. Ta cuñí ra vatyi saha ndo ñáyɨvɨ chi ra nuyahvi ta cuhva ndo nocumi chi ra. Ta nanducú ra tyayu vaha cunyaa ra chichi vehe ñuhu ta nu cuahan ra vico. ");
INSERT INTO mxtNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta naha chicán tahvi ra chi Nyoo nu tuvi, cha cuñí ra cha catyi ñáyɨvɨ tyi vaha ñáyɨvɨ cuví ra. Soco suri maa ra tinyaá ra vehe ñu ndahvi cha chihi̱ yɨɨ vatyi ña cuví tyiyahvi ñu xuhun cha tavá ra sɨquɨ ñu. Yucuan chaha ñihi ca cutachi tuñi Nyoo chi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ta nyehe̱ ra Jesús vatyi cuaha xaan ñu tyayɨɨ catyihí ra xuhun chichi caja cha nanyaá chichi vehe ñuhu cahnu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta nyehe̱ tucu ra noo ñaha ndahvi cha chihi̱ yɨɨ. Ta tyihi̱ ña uvi tahan ri xuhun cuatyi. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta catyí ra Jesús: ―Cha ndicha catyí chi ndo vatyi nuu Nyoo cuaha ca tyihi̱ ñaha ndahvi ihya ta ñima ca tandɨhɨ ñu tyayɨɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vatyi cha ndoó ri sɨquɨ chi ñu catyihi̱ ñu. Soco ñaha ihya tyihi̱ ña tandɨhɨ cha iyó chi ña ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tyicuan ta suhva ñu ndatuhún ñu tuhun vehe ñuhu cahnu cuan. Ta catyí ñu vatyi tyaquɨ xaan yuu. Tyaquɨ xaan tacaá cha chaha̱ ñáyɨvɨ. Tyicuan ta quichaha catyí ra Jesús: ");
INSERT INTO mxtNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Coo quɨvɨ ta tandɨhɨ cha nyehé ndo ihya cutanɨ. Ni noo yuu ta ma coso ca sɨquɨ tahan. Vatyi cusanacoyo ra xaan iñi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tyicuan ta quichaha candaca tuhun ra chi ra Jesús, ta catyí ra: ―Maestro, ¿ama cucuvi tandɨhɨ tuhun cahun ihya? ¿Yoso caa ta coto ndi tatu cha cuyatyin cha naa ñayɨvɨ̱? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tyicuan ta catyí ra Jesús: ―Sa̱ha vaha ndo cuenda, coto sandavi ñaha ra chi ndo. Vatyi cuaha xaan ra cuquichi, ta cucotyiño ra sɨvi, ta cucatyi ra: “Yuhu cuví Cristo ra cha saquichi̱ Nyoo chi. Cha cuñí cunaa ñayɨvɨ̱”, cucatyi ra. Soco ma cunyicon ndo chi ra. Ta ma chino iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta quɨvɨ ñihi ndo tuhun tyi iyó cuatyi ta cañí tahan ñáyɨvɨ, ma nayuhvi ndo. Vatyi tandɨhɨ cuan cutahan chi cuvi xihna ca. Soco cumañi ca chaa quɨvɨ cha naa ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ta catyí tucu ra: ―Ñáyɨvɨ iyó noo ñuu cucañi tahan ñu chihin ñáyɨvɨ inga ñuu. Ta cucoo cuatyi. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta cutaan nahnu. Ta cucoo tama. Ta cucoo cuehe tandɨhɨ ri ityi. Ta cunyehe ñáyɨvɨ cuaha xaan cha yuhví andɨvɨ. Cuaha xaan seña nahnu cha ña tuhvá ñu nyehe cunyehe ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Soco cha cumañi ca cuvi ihya, cutasɨ iñi ñáyɨvɨ chi ndo. Ta cucacan ñu cuatyi chaha ndo. Vatyi cucutuñi chi ndo ta cucuhva cuenda ñu chi ndo chi tata sutu. Ta cutyihi ñu chi ndo chichi vehe caa. Ta cunyaca ñu chi ndo nuu rey ta nuu ra cacuví tyiño cha catyi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tyicuan ta cuvi cahan ndo tuhin chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Soco sa̱ha ndo cuenda ta ma caca xiñi ndo ñáá tuhun cunacahan ndo chihin ra cuví tyiño cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Vatyi yuhu cucuhve tuhun cunacahan ndo. Ta cucuhve cha chiñi tuñi xiñi ndo. Vatyi ni noo ra xaan iñi chi ndo ta ma cuvi chasaha ra chi ndo chihin tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Soco ñáyɨvɨ cunacuhva cuenda ñu chi ndo nuu ñu xaan iñi chi ndo. Nyacua nya sutu ndo ta sɨhɨ ndo, yañi ndo, tahan ndo, ta ra tahan ndo cunacuhva cuenda ra chi ndo chi ñu xaan iñi chi ndo. Ta yɨhɨ́ nyoho cucahñi ñu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tandɨhɨ ñáyɨvɨ ta cutasɨ cuñí ñu nyehe ñu chi ndo cha catyi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Soco ni noo ixi xiñi ndo ta ma cunaa. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tatu ma ndu uvi iñi ndo chii, cucacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Quɨvɨ nyehe ndo vatyi nicachico yuhu ñuu Jerusalén ihya nyicú sɨndaro, co̱to ndo vatyi cha cuñi chaa quɨvɨ cha sanaa ra ñuu ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ta ñáyɨvɨ cha nyicú ityi Judea, na cono ñu ta na tixehe nuu ñu ityi yucu. Ta ñu nyicú ñuu Jerusalén ihya, na quita ñu. Ta ñu nyicú nu chiqui, ma ndichi ñu ñuu ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vatyi yucuan quɨvɨ cutachi tuñi Nyoo chi ñáyɨvɨ ñuu ihya. Vatyi cuchino cava tandɨhɨ cuhva catyí maa nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ta ndahvi ñusɨhɨ cha ñohó sehe quɨvɨ cuan. Ta ndahvi ñu cha iyó cha lee sehe cha ni chaxín ca. Vatyi cuaha xaan tɨndoho cunyehe ñu ta tandɨhɨ ñáyɨvɨ. Vatyi cuxaan xaan Nyoo chihin ñáyɨvɨ ñuu Jerusalén ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sɨndaro cucahñi ra chi suhva ñáyɨvɨ chihin mityi ra. Ta suhva ñu cutɨɨn ra ta cunyaca ra chi ñu vehe caa inga ñuu. Ta ñáyɨvɨ cha ñima ñu Israel cuví, cucuaca chaha ñu Jerusalén nyacua nya quɨvɨ cha catyí maa Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tyicuan ta cuaha cha iyo cunyehe ñáyɨvɨ nu ñanyii, ta nu yoo, ta nu tiñoo. Ta ihya sɨquɨ ñuhu ñayɨvɨ̱ cunayuhvi ñáyɨvɨ chihin cha iyo cunacatyin tyañuhu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ta cucoñaa ñu chihin cha yuhví ñu cha chicá xiñi ñu ñáá ndɨhɨ cha cua cuvi ihya sɨquɨ ñuhu ñayɨvɨ̱. Vatyi nyacua nya cha iyó andɨvɨ cunacanda. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tyicuan ta cunyehe ñu chi yuhu Rayɨɨ cha quichi̱ nya gloria vachi chichi noo vico tyaquɨ chihin tunyee iñi Nyoo, ta chihin cha cahnu cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ta cuhva cha quichaha tuhun ihya, sa̱ndunɨɨ ndo iñi ndo ta cu̱sɨɨ cuñi ndo vatyi numi xaan ta cucacu ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tyicuan ta chaha̱ ra Jesús noo cuhva ihya, ta catyí ra: ―Sa̱ha ndo cuenda noo yutun cha nañí higuera, o ñáá nonga yutun. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tatu cha cua cuyatyin cha coon savi cha nduyutya numa tun. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ta tyicuan caa tucu nyoho, tatu cha nyehe ndo vatyi cha quichaha tandɨhɨ tuhun cha catyí chi ndo, co̱to ndo vatyi cha cuyatyin quɨvɨ cha cunyaca ñaha Nyoo sɨquɨ ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Soco catyí chi ndo vatyi tuhun ihya cucuvi cha nɨ ri ca cha iyó ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ta coo quɨvɨ cucunaa andɨvɨ ta ñuhu ñayɨvɨ̱, soco tuhun cahán yuhu, tyicuan ri cucuvi tari cuhva catyí. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ta sa̱ha ndo cuenda chi ndo coto ndundava añima ndo chihin vicio, ta coho xaan ndo ndixi, o caca xaan iñi ndo tuhun tundoho ñayɨvɨ̱ ihya. Ta coto sana iñi ndo ta chaa quɨvɨ quichi yuhu ta quichi tundoho sɨquɨ ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vatyi tyicuan caa cucuvi chi tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. Sana iñi ñu ta tari noo cha cua nacasɨ Nyoo nu ñohó ñu ta ma cuvi quita ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Soco nyoho cua̱tu tuhva ri ndo. Ca̱can tahvi ndo chi Nyoo tandɨhɨ quɨvɨ, tacuhva tyinyee ra chi ndo. Ta ma cunaa ndo quɨvɨ cuan, tacuhva cuvi chaa vaha ndo nuu yuhu Rayɨɨ cha quichi nya gloria ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta cha ñucahñu sañahá ra Jesús chi tandɨhɨ ñáyɨvɨ chichi vehe ñuhu cahnu. Ta cha cha cuaa chahán ra yucu Olivo. ");
INSERT INTO mxtNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta tandɨhɨ ñáyɨvɨ chaa̱ coyo ñu chichi vehe ñuhu cahnu ndɨhɨ ñaha ri. Vatyi cuɨñɨ ñu tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ta cha nyañaa yatyin quɨvɨ cha coo vico pascua vico nu tuhva ñu chachi pan cha ñahri yuchan iya yɨhɨ́ chihin. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ta ra cacuví nuu chi tata sutu chihin ra casacuahá cuenda ley vehe ñuhu, nducú xaan ra cuhva yoso caa ta cacahñi ra chi ra Jesús. Soco cayuhví ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tyicuan ta quɨhvɨ̱ cuihna chi ra Judas cha catyí ñáyɨvɨ Iscariote chi. Ta maa ra cuvi noo ra cha uchi uvi tahan ra cha nacachi̱ ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta ra cuan, chaha̱n ra chi cahan ra chihin ra cuví nuu chi tata sutu, ta chihin ra cuví nuu chi ra sahá cuenda vehe ñuhu cahnu. Ta candatuhu̱n tahan ra yoso caa cunacuhva cuenda ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ta ra cuan sɨɨ xaan cacuví chi ra. Ta tyaa̱ ra cuhva vatyi cuhva ra xuhun chi ra Judas. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta ra Judas ndoo ra vaha. Ta quichaha nducu ra cuhva yoso caa cuhva cuenda ra chi ra Jesús chi tata sutu cuan, cuhva cha yori ñáyɨvɨ nyicú chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ta chaa̱ quɨvɨ cha cuví vico nu chachí ñu pan cha ñahri yuchan iya yɨhɨ́. Ta suri quɨvɨ cuan tuhvá ñu chahñi ñu noo mbee luhlu cha vico pascua cuan. Vatyi cachi ñu chi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ta ra Jesús tachi̱ ra chi ra Pedro chihin ra Juan, ta catyí ra chi ra: ―Cua̱han ndo cua sanduvaha ndo mbee cha cuxiñi yo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tyicuan ta quichaha ndaca tuhun ra chi ra: ―¿Nya cuñún cha sanduvaha ndi cha cuxiñi yo? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tyicuan ta catyí ra Jesús chi ra: ―Cua̱han ndo chichi ñuu. Ta yucuan cunañihi ndo chi noo ra nyisó noo quɨyɨ ndutya. Ta cua̱han ndo chata ra nyacua nya nu quɨhvɨ ra chichi vehe. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ta ca̱tyi ndo chi chitoho vehe cuan: “Ra Sacuaha, cuñí ra coto ra nya nyaá cuartu nu sanduvaha ra cha cuxiñi ra chihin ra cachicá noo chihin ra, vatyi casanducahnu ra vico pascua.” Tyicuan caa ca̱tyi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tyicuan ta maa ra cuan cusañaha ra cuartu cahnu ityi sɨquɨ nu cu uvi piso chi ndo. Ta cha yaha̱ nduvii. Ta yucuan sa̱nduvaha ndo cha cuxiñi yo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tyicuan ta cuahan coyo ra. Ta nañihi̱ ra tandɨhɨ tari cuhva catyi̱ ra Jesús. Tyicuan ta casanduvaha̱ ra cha cuxiñi ra cha vico pascua cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yucuan ta cha chaa̱ cuhva cha cuxiñi ra Jesús ta tandɨhɨ apóstol ra, cachicunyicu̱ ra yuhu mesa. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tyicuan ta ra Jesús quichaha catyí ra: ―Cuñí xain cuxiñi ɨn caa ri chihin ndo cuenda vico pascua ihya cha nɨ ri ca cha cumañi ca cunyehi tundoho ta cúvi. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Vatyi nya ri ca ihya cua cachi ta cucúvi. Yucuan ta cachi tiqui soco nya nu nyacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tyicuan ta quehe̱n ra noo vasu vinu. Ta nacuhva̱ ra tyiyahvi nyoo chi Nyoo, ta sayaha̱ ra chi tandɨhɨ ra nyicú chihin ra. Ta quichaha catyi ra: ―Que̱hen ndo ihya. Ta co̱ho ndo suhva suhva. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vatyi catyí chi ndo vatyi ma coho que vinu tɨchaha ndɨvɨ nyacua nya quichi cha nyacá ñaha Nyoo ñayɨvɨ̱ ihya ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ta yaha̱ cuan ta quehe̱n ra pan. Ta nacuhva̱ ra tyahvi nyoo chi Nyoo. Ta tahvi̱ sava ra. Ta chaha̱ ra chi ra cachicá noo chihin ra. Ta quichaha catyí ra: ―Ican ihya cuví coñe. Vatyi cha catyi ndo ta cua cuhva cuende chii ta cúvi. Tyicuan ri nɨ̱cohon iñi ndo chii ta cu̱xiñi ndo tyehe caa ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ta cha yaha̱ cuxiñi ra, tyicuan ta quehe̱n tucu ra vaso vinu tɨchaha ndɨvɨ, ta quichaha catyí ra: ―Chihin ihya natyihí tahan Nyoo tuhun chaa chihin ndo vityin. Vatyi vinu cha yɨhɨ́ chichi vaso ihya, tari nɨñi cuví. Ta cha catyi nyoho ta cucatɨ nɨñi. Vatyi cucúvi cha catyi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Soco vityin, ra cha cua nacuhva cuenda chii chi ra xaan iñi chii, ɨɨn ri yoso ndaha ra chihin ndahi nu mesa ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Vatyi yuhu Rayɨɨ cha quichi nya gloria cua cuvi chii tari cuhva cha nyaá maa tyi cuvi chii. Soco ¡ndahvi ra ndahvi, ra cha cunacuhva cuenda chii! ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tyicuan ta ra cachicá noo chihin ra Jesús quichaha candaca tuhun ra chi tahan ra, nya ra cuví ra cua nacuhva cuenda chi ra chi ra xaan iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yaha̱ cuan ta quichaha candatuhun ra cachicá noo chihin ra Jesús nya ra cahnu ca cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Soco ra Jesús catyí ra: ―Chitó nyoho vatyi ra nyacá ñaha chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱, ñihi xaan yosó ra sɨquɨ ñu. Ta cacuñí ra vatyi catyí ñáyɨvɨ tyi tyinyee ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Soco nyoho ña tahán chi sacuvi ndo tari sacuví ra cuan. Vatyi tatu cuñí ndo cuvi ndo ra cuví nuu, tahán chi sacuvi ndo tyiño nuu ñáyɨvɨ. Vatyi tatu sacuví ndo tyiño nuu ñáyɨvɨ, ican ndo cuví ra cuví nuu. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vatyi ihya sɨquɨ ñuhu ñayɨvɨ̱ ra cuví nuu cuví ra cha ña sahá tyiño. Ta nyaá ra yuhu mesa ta musu ra sacuví ra tyiño nuu ra. Soco yuhu ra cuví nuu cuví, ta sacuví tyiño nuu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Soco nyoho tyicuan ri ndɨhɨ ndo chihin, tandɨhɨ chaha cha nyehí tundoho. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yucuan chaha, yuhu chahí noo nu cunyaca ñaha ndo tari cha chaha̱ Suti chii cha cunyaca ñahi. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Vatyi cucachi ndo cucoho ndo yuhu mesa chihin nya nu nyacá ñahi. Ta yucuan cunyaa ndo nu tyayu tyaquɨ. Ta cunyaca ñaha ndo chi ndɨ uchi uvi tahan ityi ñáyɨvɨ vachi tata ra Israel. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tyicuan ta catyí ra Jesús chi ra Pedro: ―Nye̱he vahun, yoho Simón. Vatyi cuihna, ra nañí Satanás, cha chica̱n ra chi Nyoo na cuhva ra ityi chi ra vatyi quɨsɨ ñihno ra chi ndo tari naquɨsɨ ñihno yo trigu, tacuhva ndu uvi iñi ndo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Soco chicán xain chi Nyoo cha catyun, vatyi ma ndɨhɨ cha chinó iñun chi ra. Ta quɨvɨ ndu uvi iñun cuatyun ta na chino vaha iñun chii cutyinyeun chi ra tahun cha ma sandɨhɨ ra cha cachino iñi ra chii ―catyí ra Jesús chi ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ta ra Simón catyí ra chi ra: ―Sutu Mañi yuhu, cha iyó vahi vatyi cuhin chuhun vasɨ vehe caa, vasɨ tuhun chihi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tyicuan ta catyí ra Jesús chi ra: ―Pedro, catyí chuun vatyi vityin cha nɨ ri ca cha cumañi ca cuacu chaa loho, yoho cha uñi tahan chaha cucatyun vatyi ña ñohó nuun chii ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tyicuan ta ndaca̱ tuhun ra Jesús chi ra cachicá noo chihin ra, ta catyí ra: ―Nɨ̱cohon iñi ndo quɨvɨ cha tachi̱ chi ndo vatyi cucahan noo ndo nuu ñáyɨvɨ ta ñahri nyiso̱ ndo, nɨ ri cha cachi ndo, nɨ ri xuhun, nɨ ri sahma ndo. ¿Atu chiyo̱ cha cumañi chi ndo quɨvɨ cuan? ―catyí ra Jesús. Tyicuan ta canacaha̱n ra, ta catyí ra: ―Ñahri cha cumañi chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tyicuan ta quichaha catyí ra Jesús chi ra: ―Soco vityin, tatu iyó cha cachi ndo ta iyó xuhun ndo, cui̱so ndo. Ta tatu ñahri mityi ndo, xi̱co ndo noo sahma ndo ta sa̱ta ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Vatyi catyí chi ndo, vatyi tandɨhɨ tuhin cha nyaá nu tutu Nyoo cuchino cava vatyi tyehe caa catyí chi: “Sahá ñu tuhun tyi cuví ra noo ra quiñi iyó.” Tyicuan caa catyí tuhin nu tutu Nyoo. Ta tandɨhɨ cuan cuchino cava ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tyicuan ta quichaha catyi ra cachicá noo chihin ra: ―Ihya nyaá uvi tahan mityi ―catyí ra. Tyicuan ta catyí ra Jesús: ―Cha iyó vaha ri ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tyicuan ta quita̱ ra Jesús vehe cuan. Ta cuahan ra nya yucu Olivo. Tari cuhva tuhvá maa ra chahan. Ta ra cachicá noo chihin ra cuahan coyo ra chata ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta cuhva cha chaa ra yucuan, quichaha catyi ra chi ra cachicá noo chihin ra: ―Ca̱can tahvi ndo chi Nyoo tacuhva ma cuvi chasaha cuihna chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tyicuan ta cuahan ra Jesús cha cañi ca, tari cuhva cha chaa noo yuu tatu tuchi yo. Yucuan ta chicuɨñɨ chɨtɨ ra. Ta quichaha cahan ra chihin Nyoo, ");
INSERT INTO mxtNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ta catyí ra: ―Sutu Mañi yuhu, tu yoho ta cuñún, cuhva cha ma nyehi tundoho ihya. Soco ma cuvi tari cuhva cha cuñí mai. Soco na cuvi tari cuhva cha cuñí maun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tyicuan ta tuvi̱ noo ángel, vatyi cuhva ca ra tunyee iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ta cha nɨ ri ca cha nyehé xaan ra Jesús tundoho vatyi cuihya vavaha iñi ra, ta ñihi ca chicán tahvi ra chi Nyoo. Ta cuaha xaan tyeen ra quitá ta canacoyó nu ñuhú, ta tari caa nɨñɨ caa. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yucuan ta nducuita̱ ra cha ndɨhɨ̱ cahan ra chihin Nyoo. Ta cuanuhu ra nu canyicu tandɨhɨ ra cachicá noo chihin ra. Ta nyehe̱ ra vatyi caquixí ra, cha cuenda vatyi cacuihya xaan iñi ra, ña cacunyee̱ ra ñumahna ta caquixi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tyicuan ta quichaha catyi ra Jesús chi ra: ―¿Ñáá tuhun cha caquixí ndo? Ndu̱cuita ndo. Ta ca̱can tahvi ndo chi Nyoo, tacuhva cha ma cuvi chasaha cuihna chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nɨ cahán ca ra Jesús tuhun ihya, ta cuaha xaan ra cachaa̱ coyo. Ta ityi nuu vachi ra Judas, noo ra chicá noo chihin ra Jesús cuví ra. Ta tuhva̱ ra chi ra Jesús vatyi cua tyayuhu ra xɨtɨn ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tyicuan ta catyí ra Jesús chi ra: ―Judas, ¿atu chihin cha cua tyayuhun chii, nacuhvá cuendon chi yuhu, Rayɨɨ cha quichi nya gloria, chi ra xaan iñi chii? ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ta ra canyicú chihin ra Jesús quichaha ndaca tuhun ra chi ra: ―Sutu Mañi yuhu, ¿atu sañicuehe ndi chi ra chihin mityi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yucuan ta noo ra, chahnya̱ ra soho chiyo vaha noo ra cha cuví musu ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Soco ra Jesús catyí ra chi ra: ―Sa̱ña ndo. Vaha ri ―catyí ra. Tyicuan ta naquehe̱n ra Jesús soho ra cuan. Ta natyaa̱ ra, ta nduvaha̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ta ra cacuví nuu chi tata sutu chihin ra cacuví nuu chi ra sahá cuenda vehe ñuhu, chihin ra cacuví mandoñi, ican ra cuví ra quichi coyo vatyi catɨɨn ra chi ra Jesús. Ta quichaha catyí ra Jesús chi ra: ―¿Atu vachi coyo nyoho sɨqui chihin cha xaan ta chihin yutun tari cha vatyi minoo ra suhu cuví yuhu sahá ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɨquɨvɨ chinyai̱ chichi vehe ñuhu cahnu, ¿ñáá tuhun ña cuví tɨɨn ndo chii? Soco vityin chaa̱ cuhva cha ñaa iñi vatyi ra ña vaha nyacá ñaha. Yucuan chaha vachi tɨɨn ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tyicuan ta catɨɨn ra chi ra Jesús. Ta cua nyaca ra chi ra nya vehe ra cuví nuu chi tata sutu. Ta ra Pedro nyasava ri cuahan ra chata ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta cha chaa̱ coyo ra vehe ra cuví nuu chi tata sutu cuan, casanataha̱n ra ñuhu̱ nuquehe. Ta chicunyicú cutya ra nɨcachico ri nu cayú ñuhu̱ cuan. Ta chicunyaa̱ tucu ra Pedro mahñu ñáyɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ta cuhva cha ndundichin cha cayu ñuhu̱ cuan, tyicuan ta noo ñaha cha cuví musu tata sutu cuan nanyehe̱ ña chi ra. Ta quichaha catyí ña: ―Ra ihya chicá noo ra chihin ra cuan ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Soco ra Pedro catyí ra: ―Yuhu ña ñohó nui chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tañi ri cuan ta nyehe̱ tucu inga ra chi ra, ta catyí ra: ―Yoho, ra cuenda ra cuan cuvún ―catyí ra. Ta ra Pedro catyí ra: ―Ñima ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ta cha yaha̱ noo ora, ta nanyehe̱ tucu inga ra chi ra ta catyí ra chi ra tahan ra: ―Cha ndicha cuii vatyi ican ra ihya cuví noo ra cha chicá noo chihin ra cuan. Vatyi suri ra Galilea cuví ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tyicuan ta catyí ra Pedro: ―Ña chité ñáá tuhun cahún ―catyí ra. Ta caa cuhva ri cuan, nɨ cahán ca ra Pedro tuhun cuan, ta chacu̱ chaa ri noo loho. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tyicuan ta ra Jesús nanyehe̱ ra nuu ra Pedro. Ta ra Pedro nɨcoho̱n iñi ra tuhun cha catyi̱ ra Jesús chi ra: “Cuhva cha nɨ cumañi ca cuacu chaa loho, yoho cha catyun tyi ña ñohó nuun chii uñi tahan chaha.” ");
INSERT INTO mxtNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tyicuan ta quita̱ ra Pedro ityi chata vehe. Ta chacu̱ vavaha ra cha cuihya iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tyicuan ta ra casahá cuenda chi ra Jesús, quichaha chacu nyaa ra chi ra. Ta cacañí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cachahñi̱ ra sahma nuu ra, ta quichaha cacatu ra nuu ra. Ta cacatyí ra chi ra: ―Na̱coto yóó cha cañí chuun ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta cuaha vavaha ca cha cacahan ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta cha cundichi̱n inga quɨvɨ cuan. Ta candu ɨɨ̱n ri ra chahnu ñuu cuan chihin ra cuví nuu chi tata sutu, ta ra casacuahá cuenda ley vehe ñuhu. Ta caquehe̱n ra chi ra Jesús. Ta cuahan coyo ra chihin ra nya nu cuví junta cahnu. Ta quichaha candaca tuhun ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ca̱tyi chi ndi ¿atu ra Cristo ra cha saquichi̱ Nyoo cuvún? ―catyí ra chi ra. Ta ra Jesús nacaha̱n ra, ta catyí ra: ―Tatu catyi chi ndo vatyi ican, ma chino iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","O tatu ndaca tuhin ñáá cha ndaca tuhin chi ndo, ma nacahan ndo ni ma saña ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Soco vityin ta ityi nuu ca yuhu Rayɨɨ cha quichi nya gloria cucunyai chiyo vaha Nyoo ra cha iyó tandɨhɨ tunyee iñi chi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tyicuan ta tandɨhɨ ra quichaha ndaca tuhun ra chi ra: ―Tu tyicuan caa, Sehe Nyoo cuví chuun ―catyí ra. Tyicuan ta nacahan ra Jesús ta catyí ra: ―Suri maa ndo catyí tyi ican cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tyicuan ta quichaha cacatyí ra cuan chi ra tahan ra: ―Nyehe nuu. Yuhu maa ra quita̱. Ña nɨñɨ ca cha tava yo cha ndaa. Vatyi suri maa yo chiñi̱ ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tyicuan ta tandɨhɨ ra nducuita̱ ra. Ta cua nyaca ra chi ra nya nu nyaá ra Pilato, ra cuví gobernador. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tyicuan ta quichaha cacatyi ra chi ra Pilato: ―Ra ihya, satɨvɨ́ ra chi ñáyɨvɨ chihin cha cahán ra nuu ñu, ta catyí ra vatyi ña vaha tyiyahvi ndi xuhun chi gobiernu ñuu Roma. Ta sɨɨn ri catyí ra vatyi ra Cristo ra cha saquichi Nyoo vatyi cuvi ra rey cuví ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tyicuan ta ra Pilato quichaha ndaca tuhun ra chi ra Jesús, ta catyí ra: ―¿Atu ican yoho cuví Rey cuenda ñu Israel? ―catyí ra. Ta nacahan ra Jesús, ta catyí ra: ―Ican, suri maun catyí. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tyicuan ta quichaha catyí ra Pilato chi ra cuví nuu chi tata sutu ta chi ñáyɨvɨ: ―Ñahri cuatyi ra ihya ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Soco xaan ca nanduvi̱ ñu. Ta quichaha cacatyí ñu: ―Cahnu xaan cuatyi ra. Cuaha xaan tɨsɨhɨ chaha̱ ra, vatyi cahán ra nuu ñáyɨvɨ. Cha xihna ri quichaha cahan noo ra nuu ñáyɨvɨ ityi Galilea. Ta nɨcañi maa ityi vachi ra cahán ra chihin ñáyɨvɨ nyacua nya chaa̱ ra Judea ihya ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuhva cha chiñi̱ ra Pilato tuhun ihya, quichaha ndaca tuhun ra tatu ra Galilea cuví ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta catyí ñáyɨvɨ chi ra vatyi ican. Tyicuan ta sacuhu̱n ra Pilato chi ra nya nu nyaá ra Herodes. Vatyi ra Herodes cuví ra gobernador nɨcahnu Galilea. Soco quɨvɨ cuan ñohó ra ñuu Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ta cuhva cha nanyehe̱ ra Herodes chi ra Jesús, sɨɨ xaan cuví chi ra. Vatyi cha naha xaan cuñí ra nyehe ra chi ra. Vatyi ñihi̱ ra tuhun vatyi cuaha xaan milagru sacuví ra. Ta cuñí xaan ra nyehe ra noo milagru cha sacuví ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ta cuaha xaan tuhun ndaca̱ tuhun ra chi ra. Soco ra Jesús ña nacaha̱n maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta yucuan canyicú tucu ra cuví nuu chi tata sutu ta ra casacuahá ley vehe ñuhu. Ta catyaa̱ xaan ra cuatyi sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tyicuan ta ra Herodes chihin sɨndaro cuenda ra chacu̱ nyaa ra chi ra. Ta sandɨhvɨ̱ noo ra noo sahma yahvi ta tyaquɨ chi ra, tari cha tuhvá rey ñihnó. Tyicuan ta natachi̱ ra Herodes chi ra inga chaha nuu ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta quɨvɨ cuan ra Pilato chihin ra Herodes nduvaha iyó ra chihin tahan ra. Vatyi nu quichi chi, ña cuví canyehe ra chi tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tyicuan ta ra Pilato sandu ɨɨ̱n ri ra chi ra cuví nuu chi tata sutu, ta chi ra cuví tyiño, ta chi ñáyɨvɨ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ta catyí ra chi ñu: ―Nyoho quichi̱ nyaca ndo chi ra ihya chii. Ta catyí ndo vatyi satɨvɨ́ ra chi ñáyɨvɨ. Soco yuhu cha sacutuñi̱ chi ra nuu ndo. Ta ñahri cuatyi ra nañihi̱ tari cuhva catyí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta nɨ ri ra Herodes ña nañihi̱ ra ni noo cuatyi ra. Yucuan chaha sandichi̱ ra chi ra inga chaha nu nyai. Nye̱he ndo vatyi ñahri cha sacuví ra, ñahri cuatyi ra. Ta ña tahán chi cha cúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yucuan chaha cua tachi tuñi ri chi ra. Yaha̱ cuan ta sañe chi ra ―catyí ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tyicuan caa catyí ra Pilato vatyi cha nɨ ri ca cha iyó vico cuan, tahán chi cha saña ra noo ra ñohó vehe caa, tari cuhva cha tuhva maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Soco tandɨhɨ ñu ɨɨn ri nacanachaa ñu, ta catyí ñu: ―Ca̱hñi chi ra Jesús. Ta sa̱ña chi ra Barrabás ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ta ra Barrabás cuan ñohó ra vehe caa cha cuenda cha cuñí ra nacanda ra sɨquɨ ra cuví tyiño. Ta sɨɨn ri chahñi̱ ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta ra Pilato cuñí ra saña ra chi ra Jesús. Ta quichaha catyí ra chi ñáyɨvɨ cuan inga chaha vatyi cusaña ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Soco ñáyɨvɨ chaa ca caná chaa ñu, ta catyí ñu: ―Na cúvi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tyicuan ta cha cu uñi chaha catyí ra Pilato chi ñu: ―Soco ¿ñáá cha ña vaha sacuvi̱ ra ihya? Nyehi̱ tyi ña tahán chi cúvi ra. Tacuhva cutachi tuñi ri chi ra, ta sañe chi ra ―catyí ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Soco ñáyɨvɨ caná chaa ca ñu, ta catyí ñu vatyi tyaa ra chi ra nu cruzi. Ta cuví chasaha ñu. Vatyi maa ñu ta ra cacuví nuu chi tata sutu caná chaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tyicuan ta sacuvi̱ ra Pilato tari cuhva catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta tari cuhva catyí ñáyɨvɨ, saña̱ ra chi ra Barrabás cha ñohó vehe caa cha cuenda cha cuñí ra nacanda ra sɨquɨ ra cuví tyiño ta cha cuenda cha chahñi̱ ra. Ta sacuvi̱ ra chi ra Jesús tari cuhva catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yucuan ta quehe̱n sɨndaro chi ra Jesús. Ta cuahan ra chihin ra. Ta catɨɨ̱n tucu ra chi noo ra Cirene cha nañí Simón. Ra cuan ni cua ndichi ra cha chaha̱n ra nu chiqui. Ta sanɨñɨ sɨndaro chi ra, na cuiso ra cruzi ra Jesús ta cuahan ra chata ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta cuaha xaan ñáyɨvɨ cuahan chata ra. Ta cuaha xaan ñusɨhɨ chacú chaa ñu cha cuihya iñi ñu cha catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Soco ra Jesús nanyehe̱ ra chi ñu. Ta quichaha catyi ra chi ñu: ―Tandɨhɨ nyoho ñusɨhɨ ñuu Jerusalén, ma cuacu ndo cha catyi yuhu. Cua̱cu ndo, soco cha catyi maa ndo ta cha catyi sehe ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vatyi cuquichi quɨvɨ nu cunyehe xaan ndo tundoho. Ta cucahan ñáyɨvɨ chihin tandɨhɨ ndo cha cuví ndo ñusɨhɨ cha yori sehe ndo iyó. Ta cucatyi ñu chi ndo: “Vaha xaan vatyi yori sehe ndo iyó vatyi cuaha xaan tundoho nyehé yo vityin”, cucatyi ñu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vatyi quɨvɨ cuan cucuñí ñu vatyi na canacoyo yucu sɨquɨ ñu tacuhva sahvi chi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vatyi tatu tyehe caa sacuvi ñu chihin yuhu cha ñahri cuatyi. Yaha ca cuhva cunyacuvi tucu ñu chihin maa ndo cha iyó cuatyi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta quehe̱n tucu sɨndaro cuan chi uvi tahan ra quiñi iyó, vatyi cahñi ra chi ra ɨɨn ri chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tyicuan ta cachaa̱ ra noo nu nañi Nu Cuví Yɨquɨ Xiñi Ndɨyɨ. Ta yucuan chicatacaa̱ ra chi ra Jesús nu cruzi. Ta tyicuan caa tucu chinyacuvi̱ ra chihin nɨnduvi tahan ra iyó cuatyi cuan. Noo ra chitacaá ra nuu cruzi chiyo vaha ra Jesús. Ta nonga ra cuan chitacaá ra nuu cruzi chiyo satyin ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ta cuhva cha tacaá ra Jesús nu cruzi cuan, quichaha catyi ra: ―Sutu Mañi yuhu, sa̱ha tucahnu iñi chi ra. Vatyi ña chitó ra ñáá cha nyacuví ra chihin ―catyí ra. Tyicuan ta sɨndaro cuan chaha̱n ra noo sɨhva chihin sahma ra Jesús. Nya ra saha ganaa caquehen ra sahma cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ta ñáyɨvɨ tayucú ñu nyehé ñu. Ta nyacua nya ra cacuví nuu cuenda vehe ñuhu, ta chacú cuehe ra nyehé ra chi ra Jesús. Ta catyí ra: ―Sacacu̱ ra chi inga ñáyɨvɨ. Soco vityin na sacacu tucu ra chi maa ra, tatu ndicha cha Cristo, ra cha saquichi Nyoo, cuví ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ta suri cahán cuehe tucu sɨndaro chi ra. Ta catuhva̱ ra chi ra. Ta chaha̱ ra vinu iya coho ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ta quichaha cacatyi ra chi ra: ―Tatu rey cuenda ñáyɨvɨ Israel cuvún. Sa̱cacu chuun ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta sɨquɨ cruzi ityi xiñi ra nyaá noo nu tyaa̱ ra chihin griego, chihin latín, ta chihin hebreo. Tyehe caa quita cahán letra cuan: “Ican ra ihya cuví Rey cuenda ñu ñuu Israel” ―catyí nu vitu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ta noo ra quiñi iyó cha tacaá xiin ra Jesús, quichaha cahan ra chihin ra, ta catyí ra: ―Tatu ndicha cha Cristo cuvún, sa̱cacu chuun. Ta sa̱cacu chi ndi ñandɨhɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Soco inga ra cuan catyí ra chi ra: ―¿Atu ña yuhvún chi Nyoo? Vatyi nyehún suri tundoho cha nyehé maa ra vityin. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maa yo nyehé yo tundoho ihya vatyi iyó cuatyi yo. Soco ra ihya ñahri cuatyi ra iyó ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tyicuan ta quichaha catyí ra chi ra Jesús: ―Yoho Jesús, nɨ̱cohon iñun tuhin quɨvɨ cunyaca ñahun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tyicuan ta ra Jesús catyí ra chi ra: ―Cha ndicha catyí chuun vatyi tañi ri vityin ta cunyaun chihin nya paraíso nu nyaá añima ñu chinó iñi chi Nyoo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tyicuan ta ñáá cuhva ora quichaha nduñaa ñayɨvɨ̱, nyacua nya caa uñi cha cha iñi. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Vatyi nduñaa ñanyii. Ta sahma cha tacaá chichi vehe ñuhu cahnu cuan, tahnya̱ sava. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tyicuan ta quichaha cana chaa ra Jesús: ―Sutu Mañi yuhu, natyaí añime chichi ndahun ―catyí ra. Ta cuhva cha catyi̱ ra tuhun ihya, ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta ra cuví nuu chi sɨndaro cuan, nyehe̱ ra tandɨhɨ cha cuvi̱ cuan. Ta sacahnú ra chi Nyoo, ta catyí ra: ―Ñahri ndicha cuii cuatyi ra iyó ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta tandɨhɨ ñáyɨvɨ cha canyicú yucuan canyehe̱ ñu cha cuvi̱ cuan. Ta cuahan coyo ñu ta suri cacañí ñu ndaha ñu yɨquɨ nyica ñu. Vatyi chitó ñu vatyi ña vaha cha chinyacuvi̱ ñu chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ta tandɨhɨ ñu cha ñohó nuu chi ra Jesús, ta ñusɨhɨ cha chinyico̱n chi ra nya Galilea, canyicú ñu nya sava ri. Ta nyehe̱ ñu tandɨhɨ cha cuvi̱ yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ta iyó noo ra vaha, nañí ra José. Ta Arimatea ityi Judea cuví ñuu ra. Ta cuví ra noo ra cuví nuu cuenda Junta Cahnu ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ta ra José cuan nyatú ra quɨvɨ cha cunyaca ñaha Nyoo. Ta ña ndoo̱ ra vaha chihin cha sacuvi̱ ra tahan ra, ra cacuví nuu cuenda tata sutu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tyicuan ta chaha̱n ra chicacan ra coño ñuhu ra Jesús chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ta yaha̱ cha sanoo̱ ra José cuan coño ñuhu ra Jesús nu cruzi, ta natyihi̱ ra chichi noo sahma cha cuví lino. Ta cuahan ra cua cuchi ra chi ra chichi noo ñaña chaa cha cuví yavi yuu cha savaha̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ta viarni cuví, quɨvɨ cha sanduvahá ñáyɨvɨ cha cachi ñu cha sabaru inga quɨvɨ, quɨvɨ nyitatu ñu. Ta cha cuñí cuví sabaru. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta tandɨhɨ ñusɨhɨ cha quichi chihin ra Jesús nya Galilea, cuahan ñu chata ra. Ta nyehe̱ ñu chichi yavi yuu cuan. Ta nyehe̱ ñu yoso caa chicava coño ñuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ta cuanuhu coyo ñu nya vehe ñu. Ta sanduvaha̱ ñu ndutya vixi chahán vatyi cutyihi ñu coño ñuhu ra Jesús coto coo xico. Vatyi tyicuan caa cuví costumbre cuiya cuan. Tyicuan ta nyitatú ñu inga quɨvɨ cuan tari cuhva catyí maa tuhun cha tachi̱ Nyoo chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cundichin timingu quɨvɨ nu quichaha vitya. Ta ñaha cuiri cuahan coyo ñusɨhɨ cuan nya nu ñaña ra Jesús. Ta nyisó ñu ndutya vixi chahán cha sanduvaha̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ta cuhva cha chaa̱ coyo ñu, nanyehe̱ ñu vatyi ña nyasɨ́ ca yavi yuu cuan tari cuhva chinyasɨ̱ maa. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ta quɨhvɨ̱ ñu chichi, soco ña nañihi̱ ñu coño ñuhu Sutu Mañi yo Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ta yucuan tayucú ñu chihin cha yuhví ñu. Ta ña chitó ñu ñáá cunyacuvi ñu. Ta tuvi̱ uvi tahan rayɨɨ nuu ñu. Ta xiño vavaha sahma cañihnó ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ta chihin cha yuhví ñu, ta chicuiñi̱ chɨtɨ ñu chihin nuu ñu nya nu ñuhú. Tyicuan ta quichaha cacatyi ra cuan chi ñu: ―¿Ñáá tuhun nanducú ndo chi ra Jesús ihya nu ñohó ndɨyɨ? ");
INSERT INTO mxtNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yori ra ñohó ihya, vatyi cha nandoto̱ ra. Nɨ̱cohon iñi ndo tuhun cha caha̱n ra chihin ndo quɨvɨ chicá noo ra Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Catyi̱ ra vatyi tahán chi cucuhva cuenda ñu chi ra ndaha ra iyó cuatyi. Vatyi cuví ra Rayɨɨ cha quichi̱ nya gloria. Ta tahán chi cucahñi ra chi ra nu cruzi. Soco nu cu uñi quɨvɨ cunandoto ra. Tyicuan caa catyi̱ ra chi ndo ―catyí ángel cuan chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tyicuan ta nɨcoho̱n iñi ñu tuhun caha̱n ra Jesús quɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ta cuanuhu coyo ñu. Ta nacatyi̱ ñu chi ndɨ uchi ɨɨn tahan ra apóstol ra Jesús chihin tandɨhɨ ca ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ta ñu sacoto̱ tuhun cuan chi ra cuan cuví ñu cu María, ñaha Magdala, ta cu Juana, ta cu María sɨhɨ ra Jacobo, ta suhva ca ñusɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Soco ra cachica̱ noo chihin ra Jesús cuñí maa ra vatyi cahán ri maa ñu. Ta ña chinó iñi ra tuhun cahán ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Soco ra Pedro nducuita̱ ra ta chino̱ vavaha ra cuahan ra cuanyehe ra nya chichi ñaña ra Jesús tatu ndicha. Ta nanyehe̱ ra chichi yavi yuu cuan tyi sahma ri cayucú ɨnchiyo xiin. Tyicuan ta cuanuhu ra nya vehe. Ta iyo cuñí ra vatyi ñahri ca coño ñuhu ra Jesús catuví chichi ñaña cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Suri maa quɨvɨ cuan, uvi tahan ra chicá noo chihin ra Jesús cuahan coyo ra nya ñuu cha nañí Emaús, tari noo cha uchi ɨɨn kilómetro cha quita yo Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta cuahan coyo ra ta ndatuhún ra tuhun ñáá ndɨhɨ cha cuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ta cha nɨ ri ca cha candatuhún ra, ta ra Jesús nataha̱n ra chi ra nu cuahan coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Soco nɨ ri maa nyehé ra chi ra Jesús, ña canɨcohon nuu ra chi ra. Vatyi tari cha iyó noo cha chasɨ nuu ra tacuhva cha ma canɨcohon nuu ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tyicuan ta quichaha ndaca̱ tuhun ra Jesús chi ra: ―¿Ñáá tuhun ndatuhún xaan ndo? ¿Ñáá tuhun cha cuihya xaan iñi ndo? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ta ra cha nañí Cleofas, nacaha̱n ra. Ta catyí ra: ―¿Atu ñima nya Jerusalén quichi yoho? ¿Atu ra inga ñuu cuvún? ¿Atu ña chitón cha cuvi̱ ñuu cuan? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tyicuan ta catyí ra Jesús chi ra: ―¿Ñáá cha cuvi̱? Ta quichaha canacatyi̱ ra chi ra: ―Tuhun ra Jesús ra ñuu Nazaret. Vatyi cuvi̱ ra noo ra profeta Nyoo. Ta chihin tunyee iñi cahnu Nyoo sacuvi̱ ra cha vaha nuu Nyoo ta nuu ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Soco ra cacuví nuu chi tata sutu ta ra cacuví nuu cuenda vehe ñuhu, nacuhva̱ cuenda ra chi ra chi sɨndaro ñuu Roma. Ta cachahñi̱ ra chi ra. Ta chihi̱ ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ta cha vityin cha iyó uñi quɨvɨ cuvi̱ tuhun cuan. Ta nyuhu cuñí maa ndi vatyi ican ra cuví ra cusacacu chi ñáyɨvɨ Israel. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Soco vityin iyo xaan cuñí ndi cha nacatyi̱ suhva ñusɨhɨ chi ndi. Vatyi maa ñu, ñaha cuii ri chaha̱n coyo ñu nu ñaña ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ta nacatyi̱ ñu chi ndi vatyi ñahri ca coño ñuhu ra catuví. Ta nacatyi̱ ñu vatyi nyehe̱ ñu uvi tahan ángel. Ta catyí ángel cuan chi ñu vatyi ra Jesús nyitó ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yaha̱ cuan ta chaha̱n coyo tucu suhva ra tahan ndi nu ñaña. Ta nyehe̱ ra vatyi cha ndicha cuví tari cuhva catyí ñusɨhɨ cuan. Vatyi ñahri ca coño ñuhu ra Jesús catuví ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tyicuan ta ra Jesús catyí ra chi ra: ―Chiin xaan cutuñí iñi ndo. Ta cuee xaan chinó iñi ndo tuhun tyaa̱ ra profeta Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Atu ña chitó ndo vatyi tahán chi cha cunyehe xihna ra Cristo tundoho? Yaha cuan ta tahán chi cuñihi ra tyiño cha cunyaca ñaha ra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tyicuan ta quichaha nacuhva ra cuenda yoso caa cuahan tuhun ra nu tutu Nyoo. Ta quichaha cahan ra tuhun cha tyaa̱ ra Moisés ta cha naha. Ta yaha̱ cuan ta caha̱n ra tuhun tandɨhɨ libru cha tyaa̱ ra profeta Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta cuhva cha chaa̱ ra nya ñuu Emaús cuan nu cuahan coyo ra, ta saha̱ ra Jesús vatyi cañi ca cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tyicuan ta cacatyi ra chi ra na ndoo ra chihin ra. Ta catyi ra: ―Ndo̱o chihin ndi vatyi cha cua quee ñanyii ―cacatyí ra. Tyicuan ta cuahan ra Jesús nya vehe nɨnduvi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta cuhva cha chicunyaa̱ ra yuhu mesa chihin ra, quehe̱n ra pan. Ta chaha̱ ra tyahvi nyoo chi Nyoo. Ta chahnu̱ sava ra, ta chaha̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ta caa cuhva ri cuan nuña nuu ra canɨcohon nuu ra chi ra Jesús. Soco ra Jesús cuanaa ri ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tyicuan ta quichaha catyí ra chi ra tahan ra: ―Yucuan chaha vaha xaan cuñí añima yo cuhva cha vachi ra chihin yo, ta nacatyi̱ vaha ra yoso caa cuahan tuhun Nyoo cha nyaa nu tutu chi yo, ta nɨcohon nuu yo chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ñahri ca cha canyatu̱ ra, ta cuanuhu coyo ra nya Jerusalén. Ta yucuan nañihi̱ ra chi ndɨ uchi ɨɨn ra chicá noo chihin ra Jesús, canyicú ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tyicuan ta quichaha canacatyi ndɨ uchi ɨɨn tahan ra chi ra cha nɨchaa coyo cuan: ―Ndicha vatyi Sutu Mañi yo, nandoto̱ ra. Vatyi ra Simón nyehe̱ ra chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tyicuan ta ra cha ni nachaa coyo cuan canacatyi̱ tucu ra yoso caa ndatuhu̱n ra Jesús chihin ra ityi cuahan ra ñuu Emaús, ta yoso caa canɨcoho̱n nuu ra chi ra nu chahnu̱ ra pan. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nɨ cahán ca ra tuhun cuan ta tuvi̱ ra Jesús nu canyicú ra. Ta chaha̱ ra nocumi, ta catyí ra: ―Na coo cha taxi ri añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tyicuan ta canayuhví xaan ra. Ta cacuñí maa ra vatyi noo tatyi ri cuví. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tyicuan ta catyí ra Jesús chi ra: ―¿Ñáá tuhun cha nayuhvi ndo? ¿Ñáá tuhun cha chicá uvi iñi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nye̱he ndo ndahi. Ta nye̱he ndo chahi. Vatyi suri mai cuví. Tɨ̱ɨn ndo chii ta co̱to ndo. Vatyi tatyi, ñahri coño ñuhu. Ta ñahri yɨquɨ tari cha nyehé ndo tyi yɨhɨ́ chi yuhu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta cuhva cha catyi̱ ra tuhun ihya, sañahá ra ndaha ra ta chaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Soco maa ra chaha cha iyo cacuñí ra ta sɨɨ cacuñí ra nyacua ña chinó vaha iñi ra. Tyicuan ta catyí ra Jesús chi ra: ―¿Atu iyo cha cachi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tyicuan ta chaha̱ ra chiin yuhu tiyaca tyihyo chihin tyañuñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ta quehe̱n ra. Ta quichaha chachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta catyí ra chi ra: ―Tandɨhɨ cha cuvi̱ chii, ican ihya cuví cha catyi̱ chi ndo quɨvɨ cuan. Ta catyi̱ chi ndo vatyi tyicuan caa cucuvi, tari cuhva nyaá tuhun cha tyaa̱ ra Moisés ta ra profeta Nyoo ta cha nyaá nu libru salmo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tyicuan ta chaha̱ ra Jesús vatyi na cutuñi iñi tandɨhɨ ra cuan yoso caa catyí nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tyicuan ta catyí ra Jesús chi ra vatyi tyicuan caa nyaá nu tutu Nyoo vatyi tahán chi cha cúvi ra Cristo. Ta nu cu uñi quɨvɨ nandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ta tahán chi coto ñáyɨvɨ tuhun sɨvɨ ra Cristo ñuu Jerusalén, ta yaha cuan ta tandɨhɨ ñuu nɨcahnu ñuhu ñayɨvɨ̱. Tacuhva cuvi ndu uvi iñi ñu ta ndachi cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","―Ta nyoho cuví ndo cha ndaa tandɨhɨ tuhun ihya. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta cusaquichi mai Tatyi Ii Nyoo sɨquɨ ndo tari catyi̱ Suti tyi cuhva ra chi ndo. Soco cu̱nyicu ndo Jerusalén ihya. Ta ma quita maa ndo nyacua nya quichi tunyee iñi Tatyi Ii Nyoo cuquɨhɨ chi ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tyicuan ta ra Jesús cuahan ra chihin tandɨhɨ ra cachicá noo chihin ra ityi chata ñuu, nya ñuu Betania. Ta sandaa̱ ra ndaha ra. Ta nasoco̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta cha nɨ ri ca cha nasocó ra chi ra, nandaa̱ xica ra andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tyicuan ta tandɨhɨ ra sacahnú xaan ra chi ra. Ta sɨɨ xaan cacuví chi ra, cuanuhu coyo ra Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta tyicuan ri chinyicú ra chichi vehe ñuhu cahnu cuan, ta sacahnú xaan ra chi Nyoo.");
INSERT INTO mxtNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nyata quɨvɨ xihna ri, nyata ni cumañi ca coo tandɨhɨ cha iyó, ta cha iyó ra cuví Tuhun Cahán Nyoo. Nyaá ra chihin Nyoo. Ta Nyoo cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ta chicoo̱ ra chihin Nyoo nyata quɨvɨ xihna ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta chihin ra, savaha̱ Nyoo tandɨhɨ cuii maa cha iyó. Ta ñahri savaha̱ Nyoo cha maa ri maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta chihin ra cuví Tuhun Cahán Nyoo nyaá ñayɨvɨ̱ cha ma naa ca maa. Ta ñayɨvɨ̱ cuan, ican cuví cha sacundichín añima ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ta cha ndichin ihya, sacundichín chi nu ñaa iñi. Ta cha ñaa iñi ña cuñihi̱ chi ndahva chi cha ndichin cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chiyo̱ noo ra cha tachi̱ Nyoo chi. Ta nañí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Quichi̱ ra cuvi̱ ra noo cha ndaa. Vatyi caha̱n ra tumañi iñi cuenda ra cuví cha ndichin cuan, tacuhva vatyi chino iñi tandɨhɨ ñáyɨvɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ra Juan, ñima cha ndichin cuan cuví ra. Noo cha ndaa ri cuví ra cha cuenda cha ndichin cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Vatyi cha ndichin cha ndicha vaha cuan, nɨ cuachaa chi sɨquɨ ñuhu ñayɨvɨ̱, tacuhva vatyi sacundichín chi añima tandɨhɨ ñáyɨvɨ cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ra cuví Tuhun Cahán Nyoo quichi̱ ra sɨquɨ ñuhu ñayɨvɨ̱. Ta ican ra cuví ra Cristo. Ta suri maa ra savaha̱ ra ñuhu ñayɨvɨ̱. Soco ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱, ña nɨcoho̱n nuu ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Quichi̱ ra nu nyicú ñáyɨvɨ cha savaha̱ ra, soco ñáyɨvɨ cha savaha ra ña natɨɨ̱n cuenda ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Soco tandɨhɨ ñu natɨɨ̱n cuenda chi ra, ta chinó iñi ñu chi ra, ican chi ñu cuan, chaha̱ ra ityi vatyi nanduvi ñu sehe Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Vatyi nacacu̱ chaa ñu. Soco ñima tari cacu̱ ñu ta lee ñu cuenda coño ñuhu ñu. Ta ni ñima cha cuenda cha quichi cuvi iñi noo rayɨɨ coo ra chihin noo ñaha sɨhɨ. Ñima cha cuenda cha cuñí ñáyɨvɨ coo sehe ñu. Soco maa Nyoo sanacacu̱ chaa chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta ra cuví Tuhun Cahán Nyoo nanduvi̱ ra noo rayɨɨ. Ta chicoo̱ ra chihin yo. Ta nyehe̱ ndi cha cahnu cuví ra. Ta cahnu cuví ra vatyi Sehe mañi Sutu yo Nyoo cuví chi ra. Tyitu yɨhɨ́ ra chihin cha ndicha ta tumañi iñi cha cua cuhva ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ta ra Juan cuan caha̱n ra tumañi iñi cuenda ra, ta catyí ra: ―Ican ra ihya cha cahi̱n tuhun quɨvɨ cuan, vatyi ra cha vachi ityi chate, cahnu ca ra cuví ra ican saha yuhu. Vatyi nyata tyembu chahnu ta cha iyó maa ra ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tandɨhɨ yo naquehén cuenda yo tumañi iñi cahnu cha chaha̱ ra chi yo, vatyi nasocó xaan ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ra Moisés chaha̱ cuenda ra ley Nyoo chi yo. Soco ra Jesucristo cundahvi̱ iñi ra chi yo ta saha̱ ra tɨcahnu iñi cuatyi yo. Ta chaha̱ ra cha ndicha coo chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ta yori ca maa nyehé chi Nyoo. Notuhun ri maa Sehe mañi ra cha iyó ɨɨn ri chihin ra. Ican ra cuví ra chahá cha cohon nuu yo chi Sutu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ra cacuví nuu chi ñu Israel cha iyó ñuu Jerusalén, catachi̱ ra chi tata sutu ta chi ra cacuví levita nu nyaá ra Juan na ndaca tuhun ra chi ra yóó ra cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ta maa ra Juan catyí cachi ra: ―Yuhu ñima ra Cristo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tyicuan ta candaca̱ tuhun ra inga chaha chi ra: ―¿Yóó ra cuví yoho? ¿Atu ra Elías, ra cuvi̱ profeta Nyoo ta cha naha cuvún? ―catyí ra chi ra. Ta ra Juan nacahan ra: ―Ñima ra cuan cuví. Ta sañihi̱ ca ra candaca̱ tuhun ra chi ra, ta catyí ra: ―Tu tyicuan caa, ¿atu icon cuví ra profeta Nyoo cha nyaá cha quichi? Ta nacaha̱n tucu ra Juan ta catyí ra: ―Ñima. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ta inga tucu chaha candaca̱ tuhun ra chi ra: ―¿Yóó ra cuví yoho? Vatyi cuñí chi cuiso ndi tyiño chi ra cha tachi̱ chi ndi. ¿Yóó ra cuví yoho? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ta ra Juan nacaha̱n ra: ―Yuhu cuví ra cahán ta canachaá noo nu chiqui ndɨɨ, ta catyí: “Nu̱ña ndo noo ityi ndoo chichi añima ndo vatyi cha vachi Sutu Mañi yo.” Tari cuhva caha̱n ra Isaías profeta Nyoo tuhin ta cha naha ―catyí ra Juan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ra cha cacahán chihin ra Juan, ra cacuví fariseo tachi̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ta candaca̱ tuhun tucu ra chi ra: ―Tatu ñima ra Cristo, ni ra Elías, ni ra profeta cuan cuvún, ¿ñáá tuhun cha sacondutyón chi ñáyɨvɨ? ―cacatyí ra chi ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta ra Juan catyí ra chi ra: ―Yuhu sacondutyé chihin ndutya. Soco mahñu ndo nanyaá noo ra cha ña ñohó nuu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ican ra cuví ra vachi chate. Soco cha iyó maa ra ta caqui. Ta ña naña mai ni cha cuví musu ra ta ndachi ñɨɨ xityin ndichan ra ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tandɨhɨ tuhun ihya cuvi̱ noo nu nañí Betábara cha nyaá inga chiyo yuvi cahnu Jordán nu ñohó ra Juan sacondutyá ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cha inga quɨvɨ nanyehe̱ ra Juan chi ra Jesús cuachaa ra nu nyaá ra, ta catyí ra Juan: ―Nye̱he ndo, ican ra ihya cuví Mbee Luhlu sana Nyoo vatyi cucuhva ra ñayɨvɨ̱ ra tacuhva cahnya ra cuatyi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tuhun maa ra cahi̱n quɨvɨ cha catyi̱ chi ndo vatyi cha yaha yuhu ta vachi nonga ra cha cahnu ca cuví ta ñima ca yuhu, vatyi nyata tyembu chahnu ta cha iyó ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni yuhu ta ña ñoho̱ nui chi ra quɨvɨ cuan. Soco vachi sacondutyé chihin ndutya tacuhva vatyi ñu ñuu Israel cohon nuu ñu chi ra ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta catyi̱ tucu ra Juan ñandɨhɨ: ―Yuhu nyehi̱ chi Tatyi Ii Nyoo quichi̱ ityi andɨvɨ vachi chi tari noo paloma, ta ndoo̱ chi sɨquɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yuhu ta coto que yóó ra cuví ra quɨvɨ cuan. Soco Nyoo, ra cha tachi̱ chii na sacondutye chihin ndutya, catyi̱ ra chii: “Quɨvɨ nyehun Tatyi Ii yuhu, vachi noó sɨquɨ noo rayɨɨ, ican ra cuan cuví ra sacondutyá chihin Tatyi Ii yuhu”, catyí Nyoo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yuhu cha yaha̱ nyehi̱ chi ra. Ta cuví cha ndaa vatyi ican ra cuví Sehe Nyoo ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cha inga quɨvɨ, ra Juan nyaá tucu ra yucuan inga chaha, ta nyicú tucu uvi ra nyicón chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta cuhva cha nyehe̱ ra, yahá ra Jesús, ta catyí ra: ―Nye̱he ndo, ican ra cuan cuví Mbee Luhlu sana Nyoo ―catyí ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cha chiñí nɨnduvi ra nyico̱n chi ra Juan tuhun caha̱n ra, ta cananyico̱n ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tyicuan ta nanyehe̱ ra Jesús ityi chata ra, ta nyehe̱ ra tyi canyicón ra chi ra, ta catyí ra: ―¿Ñáá cha nducú ndo? Tyicuan ta canacaha̱n ra ta catyí ra: ―Maestro, ¿nya iyón? ");
INSERT INTO mxtNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta ra Jesús catyí ra chi ra: ―Co̱ho ndo chihin. ta nyehe ndo ―catyí ra chi ra. Tyicuan ta cuahan coyo ra chihin ra. Ta canyehe̱ ra nu iyó ra. Ta yucuan cuaa ndɨhɨ ra vatyi tari cha caa cumi cha cha iñi cuhva cha chaa̱ ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chichi cha nɨnduvi ra cha chiñi̱ tuhun caha̱n ra Juan ta nanyico̱n ra chi ra Jesús, noo ra cuví ra ra Andrés yañí ra Simón Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta ra Andrés numi ri chinanducu̱ ra chi yañí ra, ra Simón, ta catyí ra chi ra: ―Nañihi̱ ndi chi ra cha cuví Mesías ―catyí ra. Ta tuhun Mesías cuan cuñí chi catyí, ra Cristo, o ra cha nacachi̱ vaha Nyoo, vatyi cuví ra rey chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tyicuan ta ra Andrés chinyaca̱ ra chi ra Simón yañi ra nu nyaá ra Jesús. Ta cuhva cha nyehe̱ ra Jesús chi ra Simón, ta catyí ra chi ra: ―Yoho Simón, sehe ra Jonás cuví chuun. Soco cunañun Cefas. ―catyí ra chi ra. Ta Cefas cuñí chi catyí Pedro chihin sahan griego, ta nɨnduvi tahan sɨvɨ cuan, cuñí chi catyí “yuu”. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cha inga quɨvɨ tyaa̱ ra Jesús cuhva cuhun ra ityi Galilea. Tyicuan ta nañihi̱ ra chi ra Felipe. Ta catyí ra chi ra: ―Cu̱nyicon chii ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ra Felipe ihya, ra ñuu Betsaida cuví ra. Ta yucuan iyó tucu ra Andrés ta ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tyicuan ta chaha̱n ra Felipe chinanducu̱ ra chi ra Natanael. Ta catyí ra chi ra: ―Nyehe̱ ndi chi ra cha tyaa̱ ra Moisés tuhun nu libru ley, ta suri tuhun ra catyaa̱ tucu ra profeta Nyoo ta cha naha. Jesús nañí ra. Sehe ra José ra ñuu Nazaret cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta catyi̱ ra Natanael: ―¿Atu cuvi quita cha vaha ñuu Nazaret cuan? ―catyí ra chi ra Felipe. Ta nacaha̱n ra Felipe ta catyí ra: ―Ña̱ha ta nye̱hun ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yaha̱ cuan ta cuachaa ra Natanael nu nyaá ra Jesús. Ta cuhva cha nanyehe̱ ra Jesús tyi vachi ra, ta quichaha catyí ra: ―Ihya vachi noo ra cha ndicha ndicha ra ñuu Israel cuví. Ta ña tuhvá ra sandaví ñaha ―catyí ra Jesús tuhun ra Natanael. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tyicuan ta ra Natanael ndaca̱ tuhun ra chi ra: ―¿Yoso caa cha ñohó nuun chii? Ta ra Jesús nacaha̱n ra ta catyí ra: ―Yuhu nyehi̱ chuun nyata ni cumañi ca cana ra Felipe chuun, cuhva cha nyaún chaha tun higo cuan ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tyicuan ta quichaha̱ catyí ra Natanael: ―Sutu Mañi yuhu, yoho cuvún Sehe Nyoo. Yoho cuvún rey cuenda ndi ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ta ra Jesús catyí ra chi ra Natanael: ―¿Atu chinó iñun chii cha cuenda vatyi catyí tyi nyehi̱ chuun chaha tun higo? Soco nahnu ca cha cunyehun ican saha cuan ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta catyí tucu ra Jesús: ―Cha ndicha catyí chi ndo vatyi nyoho cunyehe ndo andɨvɨ cuitanuña ta cuaha ángel Nyoo cundaa ra, ta cunoo ra sɨquɨ yuhu ra cuví Rayɨɨ cha quichi̱ nya gloria ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yaha̱ uñi quɨvɨ ta chicoo̱ noo vico tandaha ñuu Caná ityi Galilea. Ta sɨhɨ ra Jesús ñohó ña yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta suri canacatyi̱ tuhun ñu chi ra Jesús ta chi ra cachicá noo chihin ra cha cuhun coyo ra vico tandaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tyicuan ta cuahan coyo ra. Ta nyicú ñu vico, ta ndɨhɨ̱ vinu. Tyicuan ta catyi̱ sɨhɨ ra Jesús chi ra: ―Ñahri ca vinu ñu ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ta catyí ra Jesús chi ña: ―¿Ñáá cha cuñún cha sacuvi yuhu, Maha? Ta chaa ca cuhva cha sañahi chi ndo yóó ra cuví yuhu ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Soco sɨhɨ ra catyi̱ ña chi ra cha catyinyeé vico cuan: ―Sa̱cuvi ndo tandɨhɨ cha catyi ra chi ndo ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta tayucú iñu tahan quɨsɨ yuu nahnu cha quɨhɨ ndutya cha catuhvá ra Israel chotyiñó nu tuhvá ra canacatyá xaan ra ndaha ra tari cuhva costumbre cha ca iyó maa ra. Ta tahan tahan quɨsɨ cuan chitahan tari uvi xico uchi o uñi xico uchi litru ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tyicuan ta catyí ra Jesús chi ra cha catyinyeé vico cuan: ―Sa̱cutu ndo quɨsɨ ihya chihin ndutya ―catyí ra chi ra. Tyicuan ta sacuvi̱ ra tari cuhva catyi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tyicuan ta catyí ra Jesús chi ra: ―Vityin ta̱va ndo suhva ta cu̱nyaca ndo chi ra cuví nuu cuenda vico ihya ―catyí ra Jesús chi ra. Ta tyicuan caa casacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ra cuví nuu cuenda vico cuan chihi̱ ra ndutya cha nanduvi̱ vinu cuan. Soco ña chitó ra nya quichi. Maa ri maa ra catyinyee vico cuan cachitó ra, vatyi maa ra catava̱ ndutya cuan. Tyicuan ta ra cuví nuu cuenda vico cuan cana̱ ra chi ra cha tandaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ta catyí ra chi ra: ―Tandɨhɨ ñáyɨvɨ, xihna ca vinu vaha tuhvá ñu tava. Yaha cuan ta tatu cha cachihi̱ xaan ñu, tyicuan ta tava ñu vinu pehe ca. Soco yoho chicumi̱ vahun vinu vaha. Ta nya vityin tavo̱n ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cha sacuvi̱ ra Jesús ñuu Caná ityi Galilea, ican cuan cuví milagru cha xihna ri savaha̱ ra vatyi sañaha̱ ra cha cahnu cuví ra. Ta ra cachicá noo chihin ra cachino̱ iñi ra chi ra vatyi ican ra cuví ra cha tachi̱ Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cha yaha̱ cuan ta cuahan ra ñuu Capernaum. Ta cuahan sɨhɨ ra, yañi ra ta ra cachicá noo chihin ra. Ta yucuan chinyicu̱ ñu suhva quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cha cuñí chaa quɨvɨ vico cha nañí pascua cha sanducahnú ñu Israel. Yucuan chaha cuahan ra Jesús ñuu Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta chaa̱ ra ñuu cuan, ta quɨhvɨ̱ ra nuquehe vehe ñuhu cahnu cuan, ta nanyehe̱ ra chi ra caxicó sɨndɨquɨ, mbee, ta paloma. Ta na nyehe̱ tucu ra chi ñu nyicú nasama xuhun chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta cha nyehe̱ ra Jesús cha tyicuan caa, savaha̱ ra noo yoho. Ta chihin yoho cuan tava̱ ñehe ra chi tandɨhɨ ñu nuquehe vehe ñuhu ɨɨn ri chihin mbee ta chihin sɨndɨquɨ sana ñu. Ta ñu nasamá xuhun cuan, sacuita̱ ra xuhun ñu nu ñuhu ta sanduva̱ ra mesa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta catyí ra chi ñu xicó paloma cuan: ―¡Ta̱va ndo paloma chiña ihya! ¡Ma nasaha ndo vehe Suti tari noo nuyahvi! ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tyicuan ta ra cachicá noo chihin ra, canɨcoho̱n iñi ra cha catyí nu tutu Nyoo tyehe caa: “Cuiño xain chihin vehun”, catyí chi, nɨcoho̱n iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tyicuan ta quichaha candaca̱ tuhun ra cacuví nuu chi ñu Israel chi ra: ―¿Ñáá seña cuhvon chi ndi ta sañahun vatyi chaha̱ Nyoo ityi chuun cha sacuvun tyehe caa? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ta nacaha̱n ra Jesús ta catyí ra: ―Sa̱tanɨ ndo vehe ñuhu ihya, ta chichi cha uñi quɨvɨ, yuhu cusanandai inga chaha ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tyicuan ta quichaha cacatyí ra cuan chi ra: ―Uvi xico iñu cuiya cañoho̱ ra casavaha̱ ra vehe ñuhu ihya. Ta yoho catyún tyi chichi cha uñi quɨvɨ cusanandaun inga chaha ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Soco vehe ñuhu cha caha̱n ra Jesús tuhun, ican cuví coño ñuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yucuan chaha ra cachicá noo chihin ra canɨcoho̱n iñi ra tuhun ihya quɨvɨ nandoto̱ ra Jesús. Ta cutuñi̱ iñi ra vatyi tuhun cha nyaá nuu tutu Nyoo cahán chi cuenda ra Jesús. Ta canachino̱ iñi ra tuhun caha̱n ra Jesús ta tuhun cha nyaá nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Quɨvɨ cha ñohó ra Jesús Jerusalén, quɨvɨ vico pascua cuan, cuaha xaan ñu nachino iñi ñu chi ra cha cuenda cha cuaha xaan milagru sacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Soco ra Jesús ña cunɨɨ iñi ra nyehé ra chi ñu vatyi chitó ra cha caá añima tandɨhɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña chiñuhú ri cha nacatyi yo chi ra yoso caa ñáyɨvɨ, vatyi maa ra chitó ra ñáá cha caá chichi añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chiyo̱ noo ra fariseo cha nañí Nicodemo. Ta cuví ra noo ra cuví nuu chi ra ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ra Nicodemo ihya, chaha̱n ra nu nyaá ra Jesús noo cha cuaa. Ta catyí ra chi ra: ―Maestro, chitó ndi vatyi Nyoo tachi̱ chuun quichi sañahun chi ndi. Vatyi yori ñáyɨvɨ cuvi sacuvi milagru tahan cha sacuvún, tatu yori Nyoo nyaá chihin ñu ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tyicuan ta catyí ra Jesús chi ra: ―Cha ndicha catyí chuun vatyi tatu ma nacacu chaa ñáyɨvɨ inga chaha, ma cuvi nyehe ñu nu nyacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tyicuan ta ndaca̱ tuhun ra Nicodemo ta catyí ra: ―¿Yoso caa cuví cacu noo rayɨɨ inga chaha tatu cha chahnu ra? ¿Atu cuvi ndɨhvɨ ra chichi sɨhɨ ra ta nacacu chaa ra inga chaha? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nacaha̱n ra Jesús ta catyí ra: ―Cha ndicha catyí chuun vatyi ñima chihin cha cacu ri ñáyɨvɨ chihin coño ñuhu ñu ta cuví quɨhvɨ ñu nu nyacá ñaha Nyoo. Soco nɨñɨ tucu cuñí chi cha nacacu ñu chihin Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vatyi ñáyɨvɨ cha cacu̱ chihin coño ñuhu, coño ñuhu ri nyisó ñu. Ta ñu cha nacacu̱ chaa chihin Tatyi Ii Nyoo, iyó Tatyi Ii Nyoo añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma iyo cuñun cha catyí chuun tuhun ihya vatyi tandɨhɨ ñu, cuñí chi nacacu chaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tari caá tatyi tandɨhɨ ri ityi nu cuñí chi ta chiñún cayú chi, soco ña chitón nya ityi quichi chi, ni nya ityi cuahan chi; ta tyicuan caa tandɨhɨ ñu nacacu̱ chihin Tatyi Ii Nyoo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tyicuan ta ndaca̱ tuhun tucu ra Nicodemo inga chaha chi ra: ―¿Yoso caa cuahan tuhun ihya? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nacaha̱n ra Jesús ta catyí ra: ―Yoho cha cuvún noo ra sacuaha cuenda ñu Israel, tahán chi coton tuhun ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cha ndicha catyí chuun vatyi cahín cha chité ta cuví cha ndaa cha nyehi̱. Soco nyoho ña chinó iñi ndo cha catyí chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tatu ña chinó iñi ndo chii nu cahín tuhun ñayɨvɨ̱ ihya chihin ndo, ¿yoso caa chino iñi ndo tu cahin tuhun andɨvɨ chihin ndo? ");
INSERT INTO mxtNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Yori chaha̱n andɨvɨ chinyehe̱ yoso caa iyó. Noo ri yuhu Rayɨɨ cha quichi̱ nya gloria nyehí, vatyi yucuan iyé. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tari nacatacaa̱ ra Moisés noo coo cha chino chihin caa nu noo chiqui ndɨɨ, tyicuan caa cunacatacaa tucu ñu chi yuhu Rayɨɨ cha quichi nya gloria, ");
INSERT INTO mxtNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tacuhva vatyi tandɨhɨ ñu cha chinó iñi chii, ma cunaa ñu. Soco coo ñu ñayɨvɨ̱ cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Vatyi Nyoo cuñí xaan ra chi tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. Yucuan cuenda chaha̱ ra vatyi cúvi Sehe mañi ra nu cruzi cha cuenda ñu. Tacuhva vatyi tandɨhɨ ñu cha chinó iñi chi Sehe ra, ma cunaa ñu, soco coo ñu noo ñayɨvɨ̱ cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyoo ña tachi̱ ra chi Sehe ra sɨquɨ ñuhu ñayɨvɨ̱ vatyi sacunaa ra chi ñáyɨvɨ, soco tachi̱ ra chi ra na sacacu ra añima ñu tacuhva ma cuhun ñu anyaya cha catyi cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Vatyi ñu chinó iñi chi Sehe Nyoo ma cunaa ñu, soco ñu ña chinó iñi chi ra, cha cuanaa ñu cha cuenda cha ña chinó iñi ñu chi noo ri Sehe mañi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ñu ña chinó iñi, cha cuanaa ñu. Vatyi quɨvɨ quichi̱ ra cuví ñuhu̱ ndichin cha sacundichín sɨquɨ ñuhu ñayɨvɨ̱, ña natɨɨ̱n cuenda ñu chi ra tyi taha̱n ca iñi ñu nu ñaa iñi vatyi nyacuví ñu cha ña vaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tandɨhɨ ñu cha nyacuví cha ña vaha, ña tahán iñi ñu ñuhu̱ ndichin, vatyi coto quetuvi cha ña vaha cha nyacuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Soco ñu nyacuví cha ndicha, nanyitá ñu nu ndichin tacuhva na cundichin nyehe ñáyɨvɨ vatyi sacuví ñu cuhva cuñí Nyoo vatyi nyaá ra chihin ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cha yaha̱ tuhun ihya, ra Jesús chihin ra cachicá noo chihin ra cuahan coyo ra nu cuví Judea. Ta candoo̱ ra suhva quɨvɨ yucuan, vatyi casacondutya ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tyicuan caa tucu ra Juan cuan ñohó ra sacondutyá ra chi ñáyɨvɨ nu cuví Enón yatyin ri nu cuví Salim, vatyi yucuan ñohó cama ndutya. Ta ñáyɨvɨ chaá coyo ñu ta condutya ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tuhun ihya cuvi̱ ta ni cumañi ca catyihi ra chi ra Juan vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tyicuan ta suhva ra nyicón chi ra Juan quichaha̱ cuvi yuhu ra chihin noo ra ñuu Israel sɨquɨ yoso caa sandundɨɨ ñáyɨvɨ chi ñu nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tyicuan ta cuahan coyo ra nu nyaá ra Juan. Ta catyí ra chi ra: ―Maestro, ra cha ñoho̱ chuhun inga chiyo yuvi cahnu Jordán, ra cha cahu̱n tuhun chihin ndi, vityin sacondutyá ra ta tandɨhɨ ñu nanyicón ñu chi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tyicuan ta ra Juan catyí ra chi ra: ―Ni noo yo ta ñahri cha cuví sacuvi yo, tyehe ta ña chahá Nyoo tunyee iñi ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Suri maa ndo chiñi̱ vaha ndo cha cahi̱n vatyi yuhu ñima ra Cristo cuví. Noo ra cha tachi̱ ri Nyoo ityi nuu ra cuví yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Vatyi noo vico tandaha, ra nyaá xiin ñaha tyivaa cuan, ican ra cuan cutandaha chihin ña. Ta ra tahan ra nyaá ra yatyin ri cuan. Ta cusɨɨ cuñí ra chiñí ra tuhun cahán ra cha cuatandaha. Ta tyicuan caa tucu yuhu, sɨɨ cuñí vatyi naquehen ñáyɨvɨ tuhun cahán ra Jesús ta nyicón ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maa ra cahnu ca ra cuacuvi ra. Ta yuhu cunocuee que vatyi tyicuan caa tahán maa chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ra cha quichi̱ nya gloria, cahnu ca ra cuví ra cha nuu tandɨhɨ ñáyɨvɨ. Vatyi ra iyó sɨquɨ ñuhu ñayɨvɨ̱, cuenda ñuhu ñayɨvɨ̱ cuví ra. Ta cahán ra tuhun ñuhu ñayɨvɨ̱. Soco ra quichi̱ nya gloria, cahnu ca ra cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta cahán ra cha nyehé ra ta cha chiñí ra, soco yori chinó iñi tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Soco tatu nya noo yo chinó iñi yo chi ra, cuví yo noo cha ndaa vatyi Nyoo ndicha cha cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vatyi ra cha tachi̱ Nyoo chii, tuhun Nyoo cahán ra vatyi Nyoo ña tyicuhvá ra Tatyi Ii ra chaha̱ ra chi ra. Chaha̱ ra nanɨɨ Tatyi Ii ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyoo Sutu yo cuñí ra chi Sehe ra. Ta natyaa̱ ra tandɨhɨ ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ñu cha chinó iñi chi Sehe Nyoo, iyó ñu noo ñayɨvɨ̱ chaa cha ma naa ca maa. Soco ñu ña cuñí chino iñi chi ra, ma coo ñu ñayɨvɨ̱ cuan. Ta cutachi tuñi Nyoo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Cachitó ra cuví fariseo vatyi cuaha ca ñáyɨvɨ nyicón chi ra Jesús ican saha ra Juan. Ta cuaha ca ñu sacondutya̱ ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Vasɨ ñima maa ra Jesús sacondutyá, soco ra cachicá noo chihin ra, ican casacondutyá. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ta quɨvɨ chito̱ ra Jesús vatyi cachito̱ ra tuhun ihya, ta quita̱ ra Judea cuan ta cuanuhu ra nya Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta ityi cuanuhu ra, tahan chi yaha ra nu cuví Samaria. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yucuan ta chaa̱ ra noo ñuu cha nyaá ityi Samaria cha nañí Sicar yatyin nu nyaá ñuhú ra Jacob nu chaha̱ ra chi ra José sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta yucuan nyaá noo yavi ndutya cha catyí ñu tyi chi ra Jacob cuví. Ta vatyi chitatú xaan ra Jesús cha chica ityi ra, ta chicunyaa̱ ra yuhu yavi cuan, ñáá cuhva hora cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ta ra cachicá noo chihin ra, yori ra canyicú vatyi cuahan coyo ra chichi ñuu, cuasata ra cha cacachi ra. Tyicuan ta chaa̱ noo ñaha Samaria cuatava ña ndutya chichi yavi cuan. Ta quichaha catyí ra Jesús chi ña: ―Cu̱hva chiin ndutya cohi ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tyicuan ta ñaha Samaria cuan catyí ña chi ra Jesús: ―Yoho cha cuvún noo ra ñuu Israel, ¿yoso caa cha chicón ndutya cohun chi yuhu cha cuví ñaha Samaria? ―catyí ña vatyi ñu Israel ña vaha iyó ñu chihin ñu Samaria. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tyicuan ta ra Jesús nacaha̱n ra ta catyí ra: ―Tyehe ta chitón cha chahá Nyoo, ta chitón yóó cha chicán ndutya chuun, maun cucacon ndutya chii. Ta yuhu cuhve ndutya nyitó chuun ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tyicuan ta catyí ña chi ra: ―Tata, ni ñahri vihi chihin tavon ndutya ihya. Vatyi yavi ihya cono xaan. ¿Nya cuquehun ndutya nyitó cuhvon cohi? ");
INSERT INTO mxtNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Vatyi sutu chahnu yo, ra Jacob sandoo̱ ra yavi ihya chi yo. Ta suri ihya chihi̱ tucu maa ra ndutya. Ta suri ihya chihi̱ tucu sehe ra ta quɨtɨ sana ra. ¿Atu cahnu ca ra cuví yoho ican saha ra cuan? ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi ña: ―Tandɨhɨ ñu chihí ndutya ihya, cu ityi ca ñu ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Soco ñu chihí ndutya cha chahá yuhu, ma cu ityi ca ñu. Vatyi ndutya cha chahí chi ñu cucaña chi tari noo ndohyo chichi añima ñu tacuhva coo ñu ñayɨvɨ̱ cha ma naa ca maa ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tyicuan ta quichaha catyí ña chi ra: ―Tata, cu̱hva ndutya cuan cohí, tacuhva cha ma cu ityi que ndutya, ta ni ma quichi que quichi tave ndutya chichi yavi ihya ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tyicuan ta ra Jesús catyí ra chi ña: ―Cua̱han cuacana chi yɨun ta qui̱chun ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta nacaha̱n ña ta catyí ña: ―Yori yɨi iyó ―catyí ña. Tyicuan ta catyí ra Jesús chi ña: ―Ndicha cha cahun, vatyi yori yɨun iyó. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vatyi cha ohon tahan yɨun chiyo̱, ta ra nyaá chuhun vityin ñima yɨun cuví chi ra. Ndicha tuhun cha cahún ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cha chiñi̱ ña tuhun caha̱n ra, quichaha catyí ña chi ra: ―Tata, tuví iñi vatyi noo profeta cuenda Nyoo cuvún. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sutu chahnu ndi, ra Samaria, sacahnu̱ ra chi Nyoo yucu ihya. Soco nyoho ñu Israel catyí ndo vatyi Jerusalén yucuan tahán chi sacahnu yo chi Nyoo ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tyicuan ta ra Jesús nacaha̱n ra ta catyí ra chi ña: ―Chi̱no iñun tuhun cahín chuhun. Vatyi vachi cuhva vatyi cusacahnu ndo chi Sutu yo Nyoo. Soco ña chiñuhú ri cha quichi ndo yucu ihya o cuhun ndo nya Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyoho ñu Samaria, ña chitó ndo yóó chi sacahnú ndo. Soco nyuhu chitó ndi yóó chi sacahnú ndi. Vatyi chitó ndi vatyi cuenda noo ra Israel cuasacacu Nyoo chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Soco chaa chi cuhva ta cuhva cuan nyaa yo vityin vatyi ñáyɨvɨ cha ndicha sacahnú chi Sutu yo Nyoo, cusacahnu ñu chi ra chihin añima ñu ta cha ndicha. Tari cuhva saquehen ityi Tatyi Ii Nyoo chi ñu. Vatyi Sutu yo Nyoo tyicuan caa cuñí ra cha sacuvi ñu cha sacahnú chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Vatyi Nyoo Tatyi Ii cuví ra. Ta ñu sacahnú chi ra cuñí chi sacahnú ñu chi ra chihin cha ndicha tari cuhva saquehen ityi Tatyi Ii chi ñu ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta nacaha̱n ña ta catyí ña chi ra: ―Yuhu chité vatyi cuquichi ra cuví Mesías, ra Cristo, ra cuvi rey chi yo. Ta quɨvɨ quichi ra, maa ra cunacatyi tandɨhɨ chi yo ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tyicuan ta nacaha̱n ra Jesús ta catyí ra chi ña: ―Ra cha cahún tuhun cuan, ican ra cahán chuhun ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tyicuan ta canachaa̱ coyo ra cachicá noo chihin ra ta iyo cacuñí ra cha ndatuhún ra Jesús chihin noo ñaha sɨhɨ. Soco ni noo ra ña cañá iñi ra ndaca tuhun ra ñáá cha cuñí ra o ñáá cuenda ndatuhún ra chihin ñaha cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tyicuan ta sandoo̱ ña quɨyɨ ña ta cuanuhu ña chichi ñuu. Ta catyí ña chi ñáyɨvɨ ñuu ña: ");
INSERT INTO mxtNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ña̱ha ndo cunyehe ndo chi noo ra cha catyi̱ tandɨhɨ cha cai. ¿Atu ñima ra Cristo cuví ra? ―catyí ña chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tyicuan ta quita̱ coyo ñu ñuu cuan ta cuahan coyo ñu nu nyaá ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta cha nɨri ca cha cumañi chaa ñu nu nyaá ra, ra cachicá noo chihin ra, sanɨñɨ́ ra chi ra na cachi ra chiin. Ta cacatyí ra chi ra: ―Maestro, ca̱chi chiin ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Soco catyí ra Jesús chi ra: ―Yuhu iyó noo nyayu cuacachi, ta nyoho ña chitó ndo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tyicuan ta ra cachicá noo chihin ra quichaha candaca tuhun ra chi ra tahan ra, ta catyí ra: ―¿O iyó yóó cha quichi̱ nyaca cha cachi ra, vaha? ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Soco ra Jesús catyí ra chi ra: ―Cha chachí yuhu ican cuví cha sacuví cuhva cuñí ra cha tachi̱ chii ta sacuví tyiño chaha̱ ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nyoho catyí ndo: “Soco cumañi ca cumi yoo ta naquehen yo cha tachi̱ yo.” Soco yuhu catyí chi ndo vatyi nye̱he ndo ta sa̱ha ndo cuenda cha cuaha ñáyɨvɨ cuñí ñu quichi ñu chihin, cuví ñu tari noo itu cha cuaan ta cuñí chi cha cahnu yo nɨñɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ra cha naquehén nɨñɨ cuan ñihi ra yahvi ra. Ta nɨñɨ cha naquehen vaha ra cuví ñu cha ñihi noo ñayɨvɨ̱ cha ma naa ca maa. Ta tyicuan caa cuví tacuhva vatyi ra cha tachí, ta ra cha naquehén nɨñɨ cuan ɨɨn ri cacusɨɨ cuñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ta iyó noo tuhun ñayɨvɨ̱ cha catyí vatyi sɨɨn ñu tachí ta sɨɨn ñu naquehén nɨñɨ. Ta ndicha tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yuhu sacuhi̱n chi ndo vatyi cucahnu ndo nɨñɨ cha iyó nu ña saha̱ tyiño ndo. Vatyi inga ra saha̱ tyiño. Ta nyoho nyari cucahnu ndo ta naquehen vaha ndo nɨñɨ cuan ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ta cuaha xaan ñu ñuu Samaria cuan canachino̱ iñi ñu chi ra Jesús cha cuenda cha catyi̱ ñaha cuan, vatyi catyí ña: “Catyi̱ ra tandɨhɨ cha cai chii”, catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ta cuhva cha cachaa̱ coyo ñu Samaria nu nyaá ra Jesús, cha cundahvi̱ ñu nuu ra nandoo ra chihin ñu. Ta ra Jesús ndoo̱ ra yucuan uvi quɨvɨ chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta cuaha ca ñu cachino̱ iñi ñu cha chiñi̱ ñu tuhun cahán maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tyicuan ta quichaha catyí ñu chi ñaha sɨhɨ cuan: ―Vityin chinó iñi ndi, ñima cha cuenda vatyi catyun chi ndi, soco vatyi chiñi̱ maa ndi chihin soho ndi tuhun cahán ra, ta chitó vaha ndi vatyi ican ra cuví Cristo ra sacacú chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cha yaha̱ uvi quɨvɨ ta quita̱ ra Jesús ñuu Samaria cuan ta cuahan ra ityi nu cuví Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Vatyi suri maa ra Jesús catyi̱ ra vatyi ñáyɨvɨ ñuu noo ra cuví profeta, ra chahá cuenda tuhun cahán Nyoo, ña sahá ñu ñáyɨvɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tyicuan ta cuhva cha chaa̱ ra Galilea, ñu iyó yucuan vaha tyiñuhu̱ ñu chi ra, vatyi chaha̱n coyo tucu maa ñu Jerusalén vico cuan, ta nyehe̱ ñu cha vaha cha sacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tyicuan ta cuanuhu tucu ra Jesús nya ñuu Caná nu cuví Galilea nu sananduvi̱ ra vinu chihin ndutya. Ta iyó noo ra cuví tyiño cuenda rey, ta iyó noo sehe ra cha cuhví ñuu Capernaum. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quɨvɨ cha chito̱ ra cuan vatyi nachaa̱ ra Jesús Galilea cha chaha̱n ra Judea, chaha̱n ra chinyehe̱ ra chi ra, ta chica̱n ra tumañi iñi chi ra na cuhun ra vehe ra ta sanduvaha ra chi sehe ra, vatyi cha cuñí cuii ri cúvi sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tyicuan ta ra Jesús catyí ra chi ra: ―Nyoho ma chino iñi ndo tatu ma nyehe xihna ndo noo milagru ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Soco ra cha vaha cuan catyí ra chi ra Jesús: ―Tata, co̱ho chihin cha numi ri vityin cha ta cúvi ca sehi ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tyicuan ta ra Jesús catyí ra chi ra: ―Cua̱nuhu nya vehun. Sehun cha nduvaha̱ ra ―catyí ra chi ra. Tyicuan ta ra cha vaha cuan chinó iñi ra tuhun caha̱n ra Jesús ta cuanuhu̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta cuhva cha cuanachaa ra nya vehe ra, quita̱ coyo musu ra ta cacatyí ra chi ra: ―¡Cha nduvaha̱ sehun! ");
INSERT INTO mxtNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tyicuan ta quichaha ndaca̱ tuhun ra chi ra ñáá cuhva nduvaha ra. Ta cacatyí ra chi ra: ―Icu cuhva ca ɨɨn cha yaha̱ hora tinyaa̱ cahñi chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tyicuan ta tuví iñi ra cha vaha cuan, vatyi cuhva cuan catyí ra Jesús chi ra, “Cua̱nuhu vatyi sehun cha nduvaha̱ ra.” Ta maa ra ta tandɨhɨ ñáyɨvɨ chi ra nachino̱ iñi ñu chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ican ihya cuví cha cu uvi milagru cha sacuvi̱ ra Jesús cha nachaa̱ ra Galilea cha chaha̱n ra Judea. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cha yaha̱ tuhun cuan ta ra Jesús cuahan ra Jerusalén inga chaha vatyi ñu ñuu Israel sanducahnu ñu noo vico. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta ñuu cuan iyó noo yuvehe cha nañí Yuvehe Cuenda Mbee. Ta yatyin ri nyaa noo vehe cahnu. Ta chichi vehe cuan ñohó ndutya. Ta cha chihin sahan hebreo nañí chi Betesda. Ta iyó ohon tahan corredor. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta yucuan cayucu cuaha ñu cuhví: ñu cuaa, ñu coxo, ta ñu ña cuví nacanda. Canyatú ñu ñáá cuhva nacanda ndutya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Vatyi ña naha ña naha ri ta noó noo ángel sanacanda ra ndutya cuan. Ta yóó cha quɨhvɨ xihna ca cha yaha nacanda ndutya cuan, nduvaha ñu nɨri maa ñáá ca cuehe ndoho ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta yucuan catuví noo ra cuhví cha iyó oco chahun uñi cuiya cuhví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Cuhva cha nanyehe̱ ra Jesús chi ra catuví ra yucuan, tuvi̱ iñi ra vatyi cha cañi xaan cuiya caá ra tyicuan caa. Ta ndaca̱ tuhun ra chi ra, ta catyí ra: ―¿Atu cuñún nduvahun? ");
INSERT INTO mxtNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ta ra cuhví cuan nacaha̱n ra ta catyí ra: ―Tata, yori maa tyihi chii chichi tanque tatu cha nacandá ndutya. Vatyi tahan ri cha cuñí quɨhvi, inga ñu quɨhvɨ xihna ca ―catyí ra cuhví cuan chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tyicuan ta catyí ra Jesús chi ra: ―Ndɨ̱cuita ta na̱quehen yuvun ta ca̱con ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta caa cuhva ri cuan nduvaha̱ ra, naquehe̱n ra yuvi ra, ta nacaca ra. Soco vatyi quɨvɨ nyitatu ñu cuví, ");
INSERT INTO mxtNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ra cacuví nuu chi ñu Israel catyí ra chi ra cha nduvaha̱ cuan: ―Quɨvɨ nyitatú yo cuví vityin, ña tahán chi cuison yuvun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ta ra cha nduvaha̱ cuan nacaha̱n ra ta catyí ra: ―Ra cha sanduvaha̱ chii, ican ra catyi̱ chii: “Na̱quehen yuvun ta ca̱con”, catyí ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tyicuan ta quichaha candaca tuhun ra chi ra, ta catyí ra: ―¿Yóó ra cha catyi̱ chuun vatyi naquehun yuvun ta cacon? ");
INSERT INTO mxtNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Soco ra cha nduvaha̱ cuan ña chitó ra yóó cha sanduvaha̱ chi ra. Vatyi cuaha xaan ñáyɨvɨ yucuan, ta ra Jesús yori ca ra vatyi cha cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yaha̱ cuan ta nañihi̱ ra Jesús chi ra chichi vehe ñuhu cahnu, ta catyí ra chi ra: ―Nye̱he, vityin cha nduvahu̱n, ma sacuvi con cuatyi, coto ñáá ca cha cahnu ca cuvi chuun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tyicuan ta chaha̱n ra chicatyi ra chi ra Israel cuan vatyi ra Jesús cuví ra cha sanduvaha̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta cha cuenda cha sacuvi̱ ra Jesús tyehe caa quɨvɨ nyitatú ñu, yucuan chaha cuxaa̱n xaan ra cacuví nuu chi ñu Israel chi ra Jesús. Ta cuñí ra cahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Soco ra Jesús catyí ra chi ra: ―Maa Suti, nya vityin ta sahá tyiño ra. Ta yuhu tucu sahá tyiñe ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta cha cuenda cha caha̱n ra tuhun ihya, xaan ca cuñí ra Israel cuan. Ta ñihi ca cuñí ra cahñi ra chi ra vatyi cuñí maa ra vatyi ña sahá ra ñáyɨvɨ quɨvɨ nyitatu ñu, ta sɨɨn rí tyi sahá ra tuhun tyi ɨɨn ri cuví ra chihin Nyoo vatyi catyí ra tyi sutu ra cuví chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tyicuan ta ra Jesús catyí ra chi ra: ―Cha ndicha catyí chi ndo vatyi yuhu, cha cuví Sehe Nyoo, ñahri cha savahí cha maa ri mai. Soco sacuví cha nyehí sacuví Suti. Tandɨhɨ cha sacuví Suti ta sacuvi tucu maí. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Vatyi cuñí xaan Suti chii, vatyi Sehe ra cuví chii, yucuan chaha sañahá ra tandɨhɨ cha sacuví ra chii. Ta nahnu ca cha cusañaha ra, tacuhva cu iyo cuñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tari sanandotó Nyoo Suti chi ndɨyɨ, ta chahá ra ñayɨvɨ̱ coo ñu, tyicuan caa tucu yuhu cha cuví Sehe ra, chahí ñayɨvɨ̱ chi ñu cuñí mai cuhve. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ta Suti Nyoo ña sandaa ra cuatyi ni noo ñu, soco chi yuhu cha cuví Sehe ra chaha̱ ra ityi na sandai cuatyi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tyicuan caa sacuví Suti Nyoo vatyi cuñí ra tyi sacahnu ñáyɨvɨ chi Sehe ra tari sacahnú ñu chi maa ra. Ñu ña sacahnú chi yuhu Sehe Nyoo, nɨri chi Suti ta ña sacahnú ñu. Tyi maa ra tachi̱ ra chi yuhu cha cuví Sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ta cha ndicha catyí vatyi ñu tyasohó tuhun cahín ta chinó iñi ñu chi ra cha tachi̱ chii, iyó ñu noo ñayɨvɨ̱ chaa cha ma naa ca maa. Ta ma cuhun ca ñu anyaya cha catyi cuatyi ñu vatyi cha sacacu̱ Nyoo añima ñu ndaha tuhun chihi, ta nacuhva̱ ra ñayɨvɨ̱ chaa coo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ñáyɨvɨ tari cha ndɨyɨ cuví ñu soco cha ndicha catyí chi ndo vatyi vachi chi quɨvɨ vatyi cuɨñɨ ñu ndusu Sehe Nyoo. Ta ñu cha quichahá cha cahán ra, cucoo ñu ñayɨvɨ̱ cha ma naa ca maa. Ta vityin cuví quɨvɨ cha cahín tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Vatyi Nyoo Suti iyó ra ñayɨvɨ̱ cha ma naa ca maa. Ta chaha̱ tucu ra ityi chi yuhu cha cuví Sehe ra vatyi cuhve ñayɨvɨ̱ coo ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta Nyoo chaha̱ ra vatyi sandai cuatyi ñáyɨvɨ, vatyi Rayɨɨ cha quichi nya gloria cuví yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma iyo cuñi ndo tuhun ihya, vatyi cuchaa chi quɨvɨ vatyi ñu ndɨyɨ chichi ñaña cucuɨñɨ ñu ndusu Sehe Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ta cuquita coyo ñu chichi ñaña. Ta ñu cha sacuvi̱ cha vaha cunandoto ñu vatyi coo ñu noo ñayɨvɨ̱ chaa. Soco ñu ña sacuvi̱ cha vaha cunandoto ñu vatyi cuhun ñu anyaya nu cutachi tuñi Nyoo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yuhu ñima noo tuhun ri mai sacuví ñáá noo cha sacuví. Nyehí cha caá añima ñáyɨvɨ yoso cuhva catyí Suti. Ta vaha cuhva nyehí vatyi ña sacuví cuhva cuñí mai, soco cuhva cuñí Suti, ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ta tatu suri mai cuví cha ndaa chi mai, ñahri yahvi nyaá cha ndaa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Soco iyó inga ra cuví cha ndaa cuenda yuhu. Ta yuhu chité vatyi cha cahán ra cuende yucuan cuví noo cha ndaa ta cha ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyoho chindaca̱ tuhun ndo chi ra Juan. Ta tuhun cha caha̱n ra, ndicha vaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Soco yuhu ña chiñuhú cha cuví rayɨɨ cha ndaa cuende. Soco catyí tuhun ihya chi ndo cha cuenda cha vaha chi ndo, tacuhva vatyi chino iñi ndo chii ta cacu añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ra Juan cuvi̱ ra tari noo lámpara cha cayú ta sacundichín. Ta nyoho taha̱n iñi ndo cusɨɨ iñi ndo nu ndichin ñuhu̱ ra suhva ri quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Soco yuhu iyó noo cha ndaa vaha ca cha nuu cha catyi̱ ra Juan. Vatyi tandɨhɨ cha sacuví yuhu, maa Suti catyí chii na sacuvi. Ta ican cuví cha ndaa cha nyehé ndo vatyi ndicha vatyi maa Suti tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta tyicuan caa tucu Suti, ra cha tachi̱ chii, cuví ra cha ndaa cuende. Nyoho ta cuɨñɨ ca ndo ndusu ra. Ta ni ta nyehe ca ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ta tuhun ra cha cahín nuu ndo, ña ndoó chi añima ndo vatyi ña chinó iñi ndo vatyi Nyoo tachi̱ ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyoho chihin cuenda xaan sacuaha ndo nu tutu Nyoo, vatyi cuñí maa ndo vatyi nuu cuan cuanañihi ndo ñayɨvɨ chaa̱ cha ma naa ca maa. Soco nu tutu Nyoo cuan, tuhun yuhu cahán chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ta nyoho ña cuñí ndo quichi ndo nu nyaí tacuhva vatyi cuhve ñayɨvɨ̱ chaa cuan coo ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Yuhu ña nduqui nu cuvahi nuu ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vatyi yuhu ñohó nui chi nyoho ta chité vatyi ña cuñí ndo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yuhu vachi cuenda Suti ta nyoho ña naquehén ndo tuhun cahín. Soco tatu inga ra vachi ra cuenda maa ra, chi ra cuan nachino iñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nyoho ña cuví chino iñi ndo chii vatyi cuñí ndo cuvaha ndo nu tahan ndo. Ta ña nducú ndo nu cuvaha ndo nuu Nyoo cha noo tuhun ri maa iyó. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma cuñi ndo vatyi cutyaa yuhu cuatyi chaha ndo nuu Suti. Ra Moisés cuví ra tyaá cuatyi chaha ndo vatyi ña sacuví ndo ley cha tyaa̱ ra. Ta ley ra cuñí maa ndo vatyi cunyaca chi chi ndo andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vatyi tyehe ta chinó iñi ndo tuhun caha̱n ra Moisés, chinó tucu iñi ndo tuhun cahán yuhu. Vatyi tuhun yuhu ican tyaa̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Soco tatu ña chinó iñi ndo tuhun cha tyaa̱ ra, ¿yoso caa cuchino iñi ndo tuhun cahán yuhu? ―catyí ra Jesús chi ra cacuví nuu chi ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cha yaha̱ cuan, ra Jesús cuahan ra inga chiyo miñi cahnu cha nañí Tyañuhu Galilea. Ta suri miñi cuan nañí chi Miñi Tiberias. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cuaha xaan ñáyɨvɨ cuahan nyicon chi ra cha cuenda vatyi nyehé ñu milagru cha sacuví ra vatyi sanduvahá ra chi ñu cuhví. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tyicuan ta ra Jesús ndaa̱ ra noo yucu ta chicunyaa̱ ra yucuan chihin ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta cha nyañaa quɨvɨ vico cha nañí pascua cha sanducahnú ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cha nanyehe̱ ra Jesús vatyi cuaha ñáyɨvɨ nyicón chi ra, ta quichaha̱ catyí ra chi ra Felipe: ―¿Yoso caa cusata yo cha cachi tandɨhɨ ñáyɨvɨ cuaha ihya? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Soco catyi̱ ri maa ra chi ra Felipe cha nducú nyehe ra chi ra ñáá catyi ra, vatyi ra Jesús chitó vaha ra ñáá cha cuasacuvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tyicuan ta nacaha̱n ra Felipe ta catyi̱ ra: ―Yahvi cha quehen yo cha saha̱ tyiño yo ucha tahan yoo ta ma ñihi sata yo cha cachi ñu chiin chiin ―catyí ra Felipe. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ta ra Andrés nonga ra nyicón chi ra Jesús, ta yañi ra Simón Pedro cuví chi ra, catyí ra chi ra Jesús: ");
INSERT INTO mxtNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ihya nyaá noo ra cuehe luhlu nyisó cue ohon tahan pan cebada ta uvi tahan tiyaca. Soco ¿nyata cuví ihya ta cuaha ñáyɨvɨ ihya? ―catyí ra Andrés. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tyicuan ta ra Jesús catyí ra chi ra: ―Ca̱tyi ndo chi tandɨhɨ ñu na cunyicu ñu ―catyí ra. Iyó vavaha cuhu yucuan ta chicunyicu̱ ñu ta cha ohon mil rayɨɨ, ta sɨɨn ri ñusɨhɨ chihin ra cuatyaa. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tyicuan ta quehe̱n ra Jesús pan cuan ta cha yaha̱ nacuhva ra tyahvi nyoo chi Nyoo, chaha̱ ra chi ra cachicá noo chihin ra. Ta ra cachicá noo chihin ra casacha̱ ra chi tandɨhɨ ñu canyicú cuan. Suri tyicuan caa sacuvi̱ tucu ra chihin tiyaca cuan, chaha̱ ra cachi ñu nyacua nya cha chitu chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta cuhva cha ndaha iñi ñu, ra Jesús catyí ra chi ra cachicá noo chihin ra: ―Na̱coñehe ndo yɨquɨn cha ndoo tacuhva vatyi ñahri cha tɨvɨ ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Canacoñehe̱ ra, ta casacutu̱ ra uchi uvi tahan tica chihin yɨquɨn cha ndoo cuan cha cuenda ohon tahan pan cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tyicuan ta cha yaha̱ nyehe ñáyɨvɨ cuan milagru cha savaha̱ ra Jesús, ta catyí ñu: ―Ican ndicha cuii ra ihya cuví profeta, ra chahá cuenda tuhun cahan Nyoo cha nyaá cha quichi sɨquɨ ñuhu ñayɨvɨ̱ ihya ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Soco tuvi̱ iñi ra Jesús vatyi cuñí ñu quehen ñu chi ra chihin fuerza vatyi sacuvi ñu rey chi ra. Ta cuahan ri ra nu sucun yucu cuan inga chaha vatyi cunyaa notuhun maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta cha cuaa, ta noo̱ coyo ra cachicá noo chihin ra Jesús yuhu miñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta quɨhvɨ̱ coyo ra chichi canoa ta cuayaha sava ra mahñu miñi cuan vatyi cuchaa ra Capernaum. Cha cuñaa ta ra Jesús suri cha ta ndichi ca ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tyicuan ta chaa̱ noo tatyi ñihi. Ta iyo ndɨcuita̱ ndutya miñi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tyicuan ta cha cayaha̱ ra chihin canoa cuan tari noo cha ohon o iñu kilómetro, ta cananyehe̱ ra chi ra Jesús suri chicá ra nu ndutya cuan cuachaa ra nu nyaá canoa cuan, ta canayuhvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Soco ra Jesús catyí ra chi ra: ―¡Yuhu cuví, ma yuhvi ndo! ");
INSERT INTO mxtNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tyicuan ta chihin cha casɨɨ cuñi ra caquehen cuenda ra chi ra Jesús chichi canoa. Tyicuan ta tañi ri ta cachaa̱ ra yuhu miñi nu cuahan coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tuvi inga quɨvɨ cuan cha ñaha cuiri chitó ñáyɨvɨ cha ndoo̱ inga chiyo miñi cuan vatyi ra cachicá noo chihin ra Jesús cuahan coyo ra chihin noo canoa cha iyó cuan. Vatyi noo ri maa iyó. Ta chitó ñu tyi ña cuahan ra Jesús chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Soco chaa̱ coyo ca canoa cha quita̱ coyo ñuu Tiberias. Chaa̱ chi yatyin ri ityi nu cachachi̱ ñu pan, yaha̱ cha nacuhva̱ Sutu Mañi yo tyahvi nyoo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tyicuan ta cha nanyehe̱ ñu tyi yori ra Jesús yucuan ta nɨ ra cachicá noo chihin ra, quɨhvɨ̱ coyo ñu chichi inga canoa cuan ta cuahan ñu nya Capernaum cuananducu ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cha chaa̱ coyo ñu inga chiyo miñi cuan, nañihi̱ ñu chi ra Jesús. Ta ndaca̱ tuhun ñu chi ra: ―Maestro, ¿ama chau̱n ihya? ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Soco ra Jesús catyí ra chi ñu: ―Cha ndicha catyí chi ndo vatyi nyoho nanducú ndo chii soco cha cuenda vatyi chachi̱ ndo nyacua nya cha chitu̱ chi ndo. Soco ñima vatyi nyehe̱ ndo milagru cha sacuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma saha tyiño ndo cuenda nyayu cha ndɨhɨ, soco sa̱ha tyiño ndo cuenda nyayu cha ña ndɨhɨ́ ta chahá chi noo ñayɨvɨ̱ chaa cha ma naa ca maa coo ndo. Ican ihya cuví nyayu cha cucuhve chi ndo vatyi Nyoo Suti tyaa̱ tyiño cuan chii vatyi yuhu cuví Rayɨɨ cha quichi nya gloria ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tyicuan ta quichaha̱ ndaca tuhun ñu chi ra ta catyí ñu: ―¿Ñáá cha cuví sacuvi ndi tacuhva sacuvi ndi cuhva cuñí Nyoo? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tyicuan ta ra Jesús catyí ra chi ñu: ―Cha cuñí Nyoo cha sacuvi ndo ican cuví ihya: Cha chi̱no iñi ndo chi yuhu, ra cha tachi̱ ra chi ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ta candaca̱ tuhun tucu ñu chi ra, ta catyí ñu: ―¿Ñáá seña cuhvon chi ndi tacuhva vatyi nyehe ndi ta chino iñi ndi chuun? ¿Ñáá cha cuasacuvun? ");
INSERT INTO mxtNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sutu chahnu ndi chachi̱ ñu maná chiqui ndɨɨ nu yori ñáyɨvɨ iyó quɨvɨ cuan, tari catyí tuhun Nyoo: “Nyoo chaha̱ ra pan cha quichi̱ ityi andɨvɨ cachi ñu” ―catyí ñu chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ta ra Jesús nacaha̱n ra ta catyí ra: ―Cha ndicha catyí chi ndo. Ñima ra Moisés chaha̱ pan cha quichi̱ ityi andɨvɨ cachi ñu, soco Nyoo Suti cuví ra chahá pan cha ndicha vaha cha quichi̱ ityi andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vatyi pan cha chahá Nyoo, ican cuví ra cha noo̱ ityi andɨvɨ. Ta ican cuví ra cha chahá noo ñayɨvɨ̱ chaa coo ñu iyó sɨquɨ ñuhu ñayɨvɨ̱ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tyicuan ta quichaha̱ cacatyí ñu chi ra: ―Tata, cu̱hva pan chiña cachi ndi tyicuan ri maa ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta nacaha̱n ra Jesús ta catyí ra chi ñu: ―Yuhu cuví pan cha chahá cha conyito añima ndo. Ñu vachi nu nyaí ma cusoco ca añima ñu, ta ñu chino iñi chii ma cu ityi ca maa añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Soco cha yaha̱ catyi chi ndo vatyi nyoho ña chinó iñi ndo vasɨ cha nyehé ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tandɨhɨ ñáyɨvɨ cha chaha̱ Nyoo Suti chii, vachi ñu nu nyaí, ta ñu vachi nu nyaí, naquehén cuende chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vatyi yuhu quichi̱ ityi andɨvɨ soco ñima cha cuenda cha sacuvi cuhva cuñí mai, soco sacuvi cuhva cuñí ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta cuhva cuñí ra cha tachi̱ chii, ican cuví ihya: cha ma sacunai ni noo ñu cha chahá ra chii, tacuhva vatyi sanandote chi ñu nu cuandɨhɨ quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Suti, ra cha tachi̱ chii, cuñí ra vatyi tandɨhɨ ñáyɨvɨ cha nyehe chi yuhu ra cha cuví Sehe Nyoo, ta chino iñi ñu chii, coo ñu noo ñayɨvɨ̱ cha ma naa ca maa. Ta suri yuhu cusanandote chi ñu nu cuandɨhɨ quɨvɨ ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cha cuenda cha caha̱n ra Jesús tyehe caa, ñu Israel quichaha cacahan nyaa ñu chi ra vatyi catyí ra: “Yuhu cuví pan cha quichi̱ ityi andɨvɨ”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tyicuan ta quichaha catyí ñu: ―¿Atu ñima ra cuví ra Jesús, sehe ra José vii? Yoó ñohó nuu yo chi sutu ra ta chi sɨhɨ ra. ¿Yoso caa cha catyí ra vatyi ityi andɨvɨ quichi̱ ra? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tyicuan ta ra Jesús catyí ra chi ñu: ―Sa̱ndɨhɨ ndo tuhun cha cahan nyaa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yori maa ñu quichi nu nyaí tatu ñima Suti, ra cha tachi̱ chii, cana chi ñu. Ta cusanandote chi ñu nu cuandɨhɨ quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nu libru cha catyaa̱ ra profeta Nyoo ta cha naha catyí chi tyehe caa: “Nyoo cusañaha ra chi tandɨhɨ ñáyɨvɨ.” Yucuan chaha vatyi ñu cha tyasohó tuhun cahan Nyoo Suti ta cutuhvá ñu tuhun cahan ra, ican ñu vachi nu nyaí. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ñima cha cuenda vatyi nyehé ñu chi Nyoo Suti, vatyi yori nyehé chi ra. Soco noo ri mai nyehé chi ra. Ta iquen cuví ra cha quita̱ nu nyaá ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cha ndicha catyí chi ndo vatyi ñu chinó iñi chii coo ñu noo ñayɨvɨ̱ chaa cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yuhu cuví pan cha chahá cha conyito añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sutu chahnu ndo chachi̱ ñu maná chiqui ndɨɨ cuan, soco suri cachihi̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Soco yuhu, tuhun pan cha quichi̱ ityi andɨvɨ cahín chihin ndo, vatyi nya ñu cachi pan cuan, ma cúvi añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Suri mai cuví pan nyitó cha quichi̱ ityi andɨvɨ. Yóó cha cachi pan ihya coo ñu tyicuan ri maa. Pan cha cuhva yuhu, ican cuví coño ñuhi. Ta cuhve ñayɨvi̱ cha cuenda tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tyicuan ta ra Israel cuan quichaha̱ candatuhun ra chihin tahan ra ta cacatyí ra: ―¿Yoso caa cuhva ra cha cachi yo coño ñuhu ra? ");
INSERT INTO mxtNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ta ra Jesús catyí ra: ―Cha ndicha catyí chi ndo, yuhu cuví Rayɨɨ cha quichi̱ nya gloria, ta tatu nyoho ta ma cachi ndo coño ñuhi, ta tatu ma coho ndo nɨñi, ma cuvi coo ndo ñayɨvɨ̱ chaa. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ñu chachí coño ñuhi ta chihí ñu nɨñi, iyó ñu noo ñayɨvɨ̱ chaa cha ma naa ca maa. Ta yuhu cusanandote chi ñu nu cuandɨhɨ quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vatyi coño ñuhi ican cuví pan cha ndicha vaha cha tahán chi cachi ndo, ta nɨñi cuví vinu cha ndicha vaha cha tahán chi coho ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ñu chachí coño ñuhi ta chihí nɨñi, ɨɨn ri cuví ñu chihin. Ta mai ɨɨn ri cuví chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Suti ra tachi̱ chii, Nyoo nyitó cuví ra. Ta yuhu iyé chihin tunyee iñi ra. Ta suri tyicuan caa tucu ñu chachí coño ñuhi, coo ñu chihin tunyee iñi iyó chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tuhun pan cha quichi̱ ityi andɨvɨ cahín. Pan ihya ñima tari maná cha chachi̱ sutu chahnu ndo, vatyi suri chihi̱ ñu. Ñu chachí pan cha cuví coño ñuhi, coo ñu tyicuan ri maa ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ican tuhun ihya sañaha̱ ra Jesús nu ndu ɨɨn ri ñu chichi vehe ñuhu Capernaum. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cuaha xaan ñáyɨvɨ nyicón chi ra Jesús. Ta cuhva cha chiñi̱ ñu tuhun ihya catyí ñu: ―Tuhun cha caha̱n ra ihya, yɨɨ xaan cha natɨɨn cuenda yo. Yori cuví quichaha tuhun cahán ra ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tyicuan ta tuvi̱ iñi ra Jesús vatyi ña cuñí ñu naquehen ñu tuhun cuan. Ta ndaca̱ tuhun ra chi ñu: ―¿Atu quiñi cuñí ndo cha cahín tuhun ihya? ");
INSERT INTO mxtNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ta ¿yoso caa sacuvi ndo tatu nyehe ndo chi yuhu Rayɨɨ cha quichi nya gloria nandaa xica tiqui inga chaha ityi nu quite quɨvɨ xihna ri? ");
INSERT INTO mxtNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tatyi Ii Nyoo ican cuví cha chahá ñayɨvɨ̱ chaa. Coño ñuhu, ña tyinyeé chi coo yo ñayɨvɨ̱ cuan. Ta tuhun cha cahín chihin ndo, Tatyi Ii Nyoo cuví ta chahá chi cha conyito añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Soco yɨhɨ́ suhva ndo cha ña chinó iñi ndo chii ―tyicuan caa catyí ra Jesús. Vatyi nya quɨvɨ xihna ri ta chitó ra yóó cha ña chinó iñi chi ra ta yóó cha cunaxico tuhun chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ta catyí ra: ―Yucuan chaha catyí chi ndo vatyi yori ñu cuví quichi nu nyaí tatu ñima Nyoo Suti cana chi ñu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nya ndaha quɨvɨ cuan cuaha xaan ñu nyico̱n chi ra Jesús sandoo̱ ñu chi ra. Ta ña chicá noo ca ñu chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tyicuan ta ra Jesús ndaca̱ tuhun ra chi ndɨhɨ uchi uvi tahan ra chicá noo chihin ra, ta catyí ra: ―¿Atu cuñí tucu nyoho cuhun ndo? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Soco nacahan ra Simón Pedro ta catyí ra: ―Sutu Mañi yuhu, ¿yóó chi cunyicon ndi? Ta noo tuhun yoho cahún tuhun ñayɨvɨ̱ cha ma naa ca maa coo ndi. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nyuhu chinó iñi ndi, ta ñoho nuu ndi chuun vatyi yoho cuvún ra cuví Cristo Sehe Nyoo nyitó. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ta nacaha̱n ra Jesús ta catyí ra: ―¿Atu ñima yuhu nacachi̱ chi ndɨ uchi uvi nyoho? Ta noo nyoho cuví cuihna ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tuhun cha cahán ra Jesús ihya, tuhun ra Judas Iscariote sehe ra Simón cuví. Vatyi ra Judas cuví ra cucuhva cuenda chi ra Jesús chi ra xaan iñi chi ra, vasɨ noo ra cha uchi uvi cuan cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cha yaha̱ tuhun ihya, ta ra Jesús chicá noo ra ityi Galilea. Ña cuñí ra cuhun ra Judea vatyi ra cacuví nuu chi ñu Israel cuan cacuñí ra cacahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta cha nyañaa quɨvɨ vico cha sanducahnu ñu Israel ndɨ cuiya ri. Ta nañí chi vico Tabernáculo. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yucuan chaha yañi ra Jesús cacatyí ra chi ra: ―Ma ndoun ihya. Cua̱han Judea tacuhva vatyi ñu naquehén tuhun cahún cha nyicú yucuan nyehe ñu tyiño cha sacuvún. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vatyi tatu cuñí yo cha cohon nuu ñáyɨvɨ chi yo, ma xehe ri sacuví yo cha sacuví yo. Ta yoho tatu ndicha cha sacuvún tuhun ihya, sa̱cuvi nuu tandɨhɨ ñáyɨvɨ ―cacatyí yañi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tyicuan caa cacatyí ra vatyi ni yañi ra ta ña chinó iñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tyicuan ta ra Jesús catyí ra chi ra: ―Ta chaa ca cuhva cha cuhun yuhu. Soco nyoho savahri quɨvɨ cuví cuhun ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vatyi ñáyɨvɨ ña cutasɨ cuñí ñu nyehé ñu chi ndo, soco chi yuhu tasɨ cuñí ñu nyehé ñu cha cuenda vatyi cachi ri catyi chi ñu vatyi ña vaha cha nyacuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cua̱han nyoho vico cuan. Yuhu ma cuhin vatyi ta chaa ca cuhva cha tahán chi cuhin ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yaha̱ cuan ta ndoo̱ ra nya Galilea. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cha yaha̱ cuahan coyo yañi ra Jesús, cuahan tucu maa ra vico cuan, soco xehe ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ta ra cacuví nuu chi ñu Israel cananducú ra chi ra vico cuan, ta cacatyí ra chi ra tahan ra: ―¿Nya nyaá ra cuan? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta ñáyɨvɨ ñohó vico cuan cacahán ñu tuhun ra. Ta yɨhɨ́ ñu catyí ñu: “Noo ra vaha cuví ra.” Ta inga ñu catyí ñu: “Ña vaha ra, sandaví ñaha ra chi ñáyɨvɨ”, catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Soco yori cahán ndichin tuhun ra cha cuenda cha yuhví ñu chi ra cacuví nuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cha cusava iyó vico ta quɨhvɨ̱ ra Jesús chichi vehe ñuhu cahnu quichaha̱ cahan ra nuu ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ta ra cacuví nuu cuan iyó cacuñí ra ta cacatyí ra chi ra tahan ra: ―¿Yoso caa chitó ra ihya ta ña sacuaha̱ ra? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ta nacaha̱n ra Jesús ta catyí ra: ―Tuhun cha sañahí, ñima cha cuenda mai cuví, soco cuenda ra cha tachi̱ chii cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tatu yɨhɨ́ nyoho cha cuñí ndo sacuvi ndo cuhva cuñí Nyoo, cua coto ndo vatyi cuenda Nyoo sacote ta ñima cha cuenda mai. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ra cha cahán cuenda maa, cahán ra na sacahnu ñáyɨvɨ chi ra. Soco ra nanducú cha sacahnu ñu chi Nyoo, ra cha tachi̱ chi ra, ican ra cuan cahán cha ndicha. Ta ñahri cha sandaví ñaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Atu ña ndicha vatyi ra Moisés chaha̱ ley chi ndo? Soco ni noo nyoho ña quichahá ndo ley cuan. ¿Ñáá tuhun cuñí ndo cahñi ndo chii? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ta nacaha̱n ñáyɨvɨ ta catyí ñu chi ra: ―Noo tatyi ña vaha yɨhɨ́ chi yoho. Yori cuñí cahñi chuun ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ta catyí ra Jesús: ―Cha catyi noo milagru cha sacuvi̱ quɨvɨ nyitatu yo, iyo xaan cuñí nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Soco ra Moisés catyí ra chi ndo vatyi sacuvi ndo costumbre circuncisión. Vasɨ ñima ra quichaha̱ chihin tuhun cuan, soco ñáyɨvɨ chi ra ityi chata, casacuvi tyicuan caa. Yucuan chaha nyoho sacuví ndo costumbre cuan vasɨ tahán chi quɨvɨ nyitatu yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta vityin, vaha tatu cha cuenda cha ña cuñí ndo nacahnu ndo ley ra Moisés sacuvi ndo tyicuan caa vasɨ quɨvɨ nyitatu yo tahán chi. Soco tatu tyicuan caa sacuvi ndo, ¿ñáá tuhun cha cuxaan ndo chii cha cuenda vatyi sanduvahi̱ nanɨɨ coño ñuhu noo ra cuan quɨvɨ nyitatu yo? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma tyaa ndo cuatyi sɨquɨ ñáyɨvɨ tatu ña chitó vaha ndo ñáá cha sacuvi ñu. Cua̱tu ndo nya nyehe vaha ndo, tyicuan ta cucoto ndo yoso caa sacutuñi ndo chihin cha ndaa ta chihin cha ndicha vaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tyicuan ta suhva ñu iyó Jerusalén, quichaha̱ ndaca tuhun ñu: ―¿Atu ñima chi ra ihya canducu ra cha cahñi ra? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ta maa ra nanyaá cuan cahán ra nuu ñáyɨvɨ. Ta yori maa catyi ñáá cha catyí chi ra. ¿O vasɨ ca chinó tucu iñi ra cacuví nuu vatyi ra ihya ra Cristo ra cuvi rey cha saquichi Nyoo cuví ra? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Soco yoó chitó yo nya quita̱ ra ihya. Soco quɨvɨ quichi ra Cristo yori coto nya ityi quichi ra cuan ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chitó ra Jesús tuhun cha ndatuhún ñu ihya cuhva cha sañahá ra chichi vehe ñuhu. Ta ñihi cahán ra ta catyí ra: ―¡An ñohó nuu ndo chii ta chitó ndo nya ityi quichi, cuñi maa ndo! Soco yuhu vachí soco ñima cuenda mai. Vachí cuenda ra cha tachi̱ chii, ra cha cuví cha ndicha. Ta nyoho ña ñohó nuu ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yuhu ñohó nui chi ra vatyi cuenda ra vachi, ta maa ra tachi̱ chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tyicuan ta cuñí ñu tyihi ñu chi ra chichi vehe caa. Soco ni noo ñu ña tɨɨ̱n ñu chi ra cha cuenda vatyi ta chaa ca quɨvɨ cha tahán chi tɨɨn ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Soco cuaha xaan ñu chinó iñi chi ra. Ta catyí ñu: ―Ican ra ihya cuví Cristo. ¿Atu cuaha ca milagru sacuvi inga ra tatu quichi ra? ―catyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Cha chiñi̱ ra fariseo cha cahán ñáyɨvɨ tuhun ra Jesús, maa ra ta ra cacuví nuu chi tata sutu catachi̱ ra chi policía cuenda vehe ñuhu cuan cuquehen ra chi ra tyi cohon ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tyicuan ta ra Jesús catyí ra: ―Cunyai chihin ndo suhva ri ca quɨvɨ. Yaha̱ cuan ta cunuhi nu nyaá ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nyoho cunanducu ndo chii. Soco ma nañihi ndo chii. Vatyi ma cuvi cuhun ndo nu cuacunyai ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tyicuan ta quichaha candaca tuhun ra cacuví nuu chi ñu Israel chi ra tahan ra: ―¿Nya cuhun ra ihya cha ma nañihi yo chi ra? ¿O cuhun ra nu nyaa ra Israel cha ca iyó ñuu Grecia vatyi sañaha ra chi ñu iyó yucuan, vaha? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ñáá cha cuñí chi catyi tuhun cahan ra chihin yo? Vatyi catyi ra: “Cuananducu ndo chii soco ma nañihi ndo chii. Vatyi ma cuvi cuhun ndo nu cucunyai” ―tyicuan caa cacuví yuhu ra tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Quɨvɨ nu ndɨhɨ chiyo vico, yucuan quɨvɨ cha nɨñɨ ca. Ta quɨvɨ cuan ndɨcuita̱ ra Jesús ta ñihi cahán ra ta catyí ra: ―Tatu nya noo ndo ityi añima ndo tuhun Nyoo, ña̱ha ndo ta na̱chino iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ñu cha chinó iñi chii, chichi añima ñu cucono tari noo yuvi ndutya cha nyitó, tari cuhva catyí nu tutu Nyoo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Soco chihin cuan cuñí ra catyi ra vatyi ñu chinó iñi chi ra cunaquehen ñu Tatyi Ii Nyoo, vatyi quɨvɨ cuan ta quichi ca Tatyi Ii Nyoo vatyi ra Jesús, ta cunuhu ca ra nya gloria nu cusacahnu Sutu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Suhva ñáyɨvɨ cha chiñi̱ ñu tuhun ihya, catyí ñu: ―Ndicha vatyi ra ihya profeta Nyoo cha nyaá quichi cuví ra ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta inga ñu catyí ñu: ―Ican ra cuví Cristo ―catyí ñu. Soco inga ñu catyí ñu: ―¿Yoso caa cha ra Galilea cuví ra Cristo? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Vatyi nu tutu Nyoo catyí chi vatyi ra Cristo cucuvi ra ñáyɨvɨ vachi tata rey David ta ra ñuu Belén cucuvi ra tari ra David ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tyicuan ta ñáyɨvɨ cuan canatahvi̱ sava ñu cha cuenda ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yɨhɨ́ ñu cuñí ñu quehen ñu chi ra cutyihi ñu chi ra chichi vehe caa. Soco yori tɨɨ̱n chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tyicuan ta policía vehe ñuhu cahnu cuan, cuanuhu coyo ra nu nyicú ra fariseo ta ra cuví nuu chi tata sutu. Ta candaca̱ tuhun ra chi policía cuan ta cacatyí ra: ―¿Ñáá tuhun ña quehe̱n ndo chi ra? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ta policía cuan cacatyí ra: ―¡Ni noo chaha ta ni yori tuhva cahan tari cahán ra cuan! ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tyicuan ta ra fariseo catyí ra chi policia cuan: ―¿Atu sandaví ñaha ndɨhɨ ra chi nyoho ñandɨhɨ? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nye̱he ndo vatyi ni noo ra cuví nuu chi ndi cha cuví ndi fariseo ta ña chinó iñi chi ra cuan? ");
INSERT INTO mxtNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Soco maa ri ñáyɨvɨ cha ña chitó nyicón chi ra. Soco ña vaha ñu nuu Nyoo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tyicuan ta ra Nicodemo, ra cha chaha̱n nu nyaá ra Jesús cha cha cuaa, cuví ra noo ra fariseo, ta catyí ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Catyí ley vatyi ma cuvi tachi tuñi yo chi noo ra tatu ma cuɨñɨ xihna yo tuhun cahan ra, tacuhva coto yo ñáá cha sacuvi̱ ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tyicuan ta canacaha̱n ra ta cacatyí ra chi ra: ―¿Atu suri ra Galilea cuví tucu yoho? Sa̱cuaha nu tutu Nyoo ta nye̱hun, vatyi ni noo ra chahá cuenda tuhun cahán Nyoo ta ña nyaá chi cha quichi ra ityi Galilea ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tyicuan ta tahan tahan ra cuanuhu coyo ra vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Soco ra Jesús cuahan ra yucu cha nañi Olivo. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta cha inga quɨvɨ cuhva cha vachi cundichin, cuahan tucu ra inga chaha vehe ñuhu cahnu. Ta tandɨhɨ ñáyɨvɨ tuhva̱ ñu nu nyaá ra. Ta maa ra chicunyaa̱ ra ta quichaha cahan ra nuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tyicuan ta ra sacuahá cuenda ley ta ra cuví fariseo chaa̱ coyo ra chihin noo ñaha iyó yɨɨ vatyi natɨɨ̱n ra chi ña nu cuatyi ña chihin inga rayɨɨ. Ta cuatyaa ra chi ña mahñu ñáyɨvɨ nyicú cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ta quichaha cacatyí ra chi ra Jesús: ―Maestro, ñaha sɨhɨ ihya natɨɨ̱n ndi chi ña nu cuatyi ña chihin inga rayɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ta ley cha tyaa̱ ra Moisés catyí chi vatyi nacahñi yo chihin yuu chi ñusɨhɨ cha sacuví tyehe caa. ¿Ta yoho, yoso caa catyun vityin? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cacatyi̱ ra tuhun ihya chi ra Jesús cha cuenda cha nducú nyehe ra chi ra tacuhva tyaa ra noo cuatyi sɨquɨ ra. Tyicuan ta ra Jesús chicunyaa̱ tyayɨɨ ra nu ñuhú ta quichaha̱ tyaa ra letra nu ñuhú chihin nundaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Soco vatyi candacá tuhun ca ra chi ra, tyicuan ta nicuinanyaa̱ ra ta catyí ra chi ra: ―Xihna ca nyoho cha ñahri cuatyi ndo que̱hen ndo yuu ta ca̱ñi ndo chi ña ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta nicunyaa̱ tucu ra ta quichaha sañihi ra tyaa ra letra nu ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Soco maa ra cha cachiñi̱ ra tuhun ihya, tuvi̱ iñi ra tyi iyó tucu cuatyi maa ra. Ta quichaha quita coyo tahan tahan ri ra, quichaha xihna ca ra chahnu. Ta cuhva cha ndɨhɨ ra quita̱ coyo ta ndoo̱ noo tuhun ca maa ra Jesús chihin ñaha sɨhɨ cuan mahñu nu nyicu ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tyicuan ta nicuinanyaa̱ ra Jesús ta nyehe ra tyi cha cuahan coyo ra cuan ta ndoo̱ noo tuhun ri ca ñaha. Tyicuan ta catyí ra chi ña: ―¿Nya nyaá ra tyaa̱ cuatyi sɨcun vityin? ¿Yori ni minoo ca ra cuñí cahñi chuun? ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ta nacaha̱n ña ta catyí ña: ―Ni nonga ra, Tata. Tyicuan ta ra Jesús catyí ra chi ña: ―Ni yuhu ta ma cahñi chuun. Cua̱han vityin. Ta ma sacuvi con cuatyi ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tyicuan ta caha̱n tucu ra Jesús nuu ñáyɨvɨ inga chaha, ta catyí ra chi ñu: ―Yuhu cuví ra cha sandichin añima ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. Yóó cha nyicón chii, coo ñu noo ñayɨvɨ̱ chaa nu ndichin. Ta ma caca noo maa ñu nu ñaa iñi ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tyicuan ta ra cacuví fariseo cacatyí ra chi ra: ―Yoho, cahún tumañi iñi cuenda maun. Ta yucuan ña ndicha ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nacaha̱n ra Jesús ta catyí ra: ―Vasɨ suri mai cahín tumañi iñi cuende, soco ndicha cha cahin vatyi yuhu chité nya ityi quichi̱ ta nya ityi cuahín. Soco nyoho ña chitó ndo nya ityi quichi̱ ni nya ityi cuahín. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyoho yatyin xaan cahan ndo cha caa ñáyɨvɨ. Soco yuhu, yori chi cahin cha caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Soco tatu catyi cha caa ñáyɨvɨ, catyí cha ndicha. Vatyi ñima noo ri mai nyehí, soco Suti ra cha tachi chii, ican ra nyehé chihin. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu ley nyoho nyaá vatyi tatu uvi ra chaha cha ndaa, cuñí chi chinó iñi yo cha ndaa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ta vityin vaha, suri mai cuví cha ndaa cuenda mai. Ta Suti, ra cha tachi̱ chii, cuví inga cha ndaa ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tyicuan ta candaca̱ tuhun ra chi ra: ―¿Nya nyaá sutun? Ta ra Jesús catyí ra: ―Nyoho ña ñohó nuu ndo chi yuhu. Ta ni chi Suti ña ñohó nuu ndo. Tyehe ta ñohó nuu ndo chii, cohon nuu ndo chi Suti ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tuhun ihya caha̱n ra Jesús cha nɨ ri ca cha sañahá ra chichi vehe ñuhu cahnu, nu nyaá caja nu tyihí ñáyɨvɨ xuhun. Soco yori tyihi̱ chi ra vehe caa, vatyi ta chaa ca quɨvɨ cha tahán chi cohon ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ra Jesús catyí ra chi ra cacuvi fariseo inga chaha: ―Yuhu cuhin, ta nyoho cunanducu ndo chii, soco cucúvi ndo ta cundoo cuatyi ndo sɨquɨ ndo. Nu cuahan yuhu, nyoho ma cuvi cuhun ndo ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tyicuan ta ra cacuví nuu chi ñu Israel cacatyí ra: ―¿Atu cucahñi maa ra chi ra? vatyi catyí ra vatyi ma cuvi cuhun yo nu cuahan ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tyicuan ta ra Jesús catyí ra: ―Nyoho ra cuenda ityi yuvi ihya cuví ndo. Soco yuhu ra cuenda ityi sɨquɨ cuví. Nyoho ñu ñuhu ñayɨvɨ̱ ihya cuví ndo. Soco yuhu ñima ra ñuhu ñayɨvɨ̱ ihya cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yucuan chaha catyí chi ndo vatyi cucúvi ndo ta cundoo cuatyi ndo sɨquɨ ndo. Vatyi tatu ña chinó iñi ndo cha yuhu cuví ra tinyaá cuatyi ndo, cundoo cuatyi ndo sɨquɨ ndo quɨvɨ cúvi ndo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tyicuan ta quichaha candaca̱ tuhun ra chi ra, ta catyí ra: ―¿Yóó ra cuví yoho? Ta ra Jesús nacaha̱n ra ta catyí ra: ―Cha yaha catyi̱ chi ndo nyata quɨvɨ xihna ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cuaha xaan ca cha nyaá cha catyi chi ndo, ta cuaha xaan ca nyaá catyi cha caá ndo. Soco tuhun cha catyí yuhu chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱, tuhun cha chiñi̱ cha cahán ra cha tachi̱ chii cuví. Ta maa ra cahán ra cha ndicha ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Soco maa ra cacuví nuu chi ñu Israel ña cutuñi̱ iñi ra vatyi tuhun Nyoo Sutu yo cahán ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yucuan chaha catyi̱ ra chi ra: ―Cutyaa ndo chi ra cuví Rayɨɨ cha quichi nya gloria nu cruzi. Tyicuan ta cunacoto ndo vatyi yuhu cuví, ta cucoto ndo vatyi tyiño sahí ñima cha cuenda mai sacuví, soco cahín cha sañahá Suti chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Vatyi Suti, ra cha tachi̱ chii, nyaá ra chihin. Ta ña sandoó ra chii cha maa ri mai. Vatyi yuhu tyicuan ri sacuví cuhva cuñí ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cha cahán ra Jesús tuhun ihya, cuaha ra quichaha chino iñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tyicuan ta catyí ra Jesús chi ra cacuvi nuu chi ñu Israel cha chinó iñi chi ra: ―Tatu nyoho ta sañihi ca ndo sacuvi ndo cuhva sañahí chi ndo, cuchaa ndo cuví ndo noo ñu yɨhɨ cuende. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta cucoto ndo cha ndicha. Ta chihin cha ndicha cuan cundoo ndo libre ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ta canacahán ra ta catyí ra: ―Nyuhu ñáyɨvɨ vachi tata ra Abraham cuví ndi. Ta ni noo chaha ta cuvi ca ndi musu chi ni noo ñáyɨvɨ. ¿Yoso caa cha catyí yoho tyi ndoo ndi libre? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ta ra Jesús catyí ra: ―Cha ndicha catyí chi ndo vatyi tandɨhɨ ñu sacuví cha quiñi caa, musu cuenda cha quiñi caa cuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Noo musu ña nyaá ra vehe chitoho ra tyicuan ri. Soco noo sehe ra cuví chitoho cuan, nyaá ra tyicuan ri chihin sutu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yucuan chaha tatu yuhu cha cuví Sehe Nyoo ta tave chi ndo ndaha ra ña vaha, ndicha cuii cucoo ndo libre. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cha chité vatyi ñáyɨvɨ chi ra Abraham cuví chi ndo. Soco yɨhɨ́ ndo cuñí ndo cahñi ndo chii, vatyi ña tɨɨ́n cuenda ndo tuhun cahin. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yuhu cahín cha sañaha̱ Suti chii. Ta nyoho sacuví ndo cha catyi̱ sutu ndo chi ndo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta canacaha̱n ra ta catyí ra: ―Sutu ndi cuví chi ra Abraham ―catyí ra. Soco ra Jesús catyí ra chi ra: ―Tyehe ta ndicha cha sehe ra Abraham cuví chi ndo, sacuví ndo cha sacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Soco nyoho, vasɨ catyí chi ndo cha ndicha cha sañaha̱ Nyoo chii, nyoho cuñí ndo cahñi ndo chii. ¡Ra Abraham ña sacuvi̱ ra cha tyicuan caa! ");
INSERT INTO mxtNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyoho tari sacuví sutu ndo, sacuví ndo ―catyí ra chi ra. Tyicuan ta nacaha̱n ra ta catyí ra: ―Nyuhu ñima sehe ndahvi ñu cuví chi ndi. Iyó noo ri sutu ndi ta ican ra cuví Nyoo ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tyicuan ta ra Jesús catyí ra: ―Tyehe ta ndicha cha Nyoo cuví sutu ndo, nyoho cuñí ndo chii. Vatyi yuhu quite̱ nu nyaá ra ta chai̱ nyehe. Ña vachí cuenda mai, soco Nyoo tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ñáá tuhun cha ña cutuñí iñi ndo tuhun cha catyí chi ndo? Cha cuenda tyi ña cuñí ndo tyasohó ndo tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Cuihna ican ra cuví sutu ndo. Ta sehe ra cuví chi ndo. Ta cuñí ndo sacuvi ndo cuhva cuñí ra. Ra chahñí ñáyɨvɨ cuví cuihna nyata quɨvɨ xihna ri. Ni noo chaha ña sacuví ra cha ndicha. Ta ni noo chaha ña cahán ra cha ndicha. Cuhva cha cahán ra cuendu, cahán ra cuhva caá ra, vatyi cuendu ra. Ta sutu ñu cuendu cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta yuhu vatyi cahín cha ndicha, ña chinó iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nya noo nyoho cuví catyi ndo vatyi yuhu iyó noo cuatyi? Ni noo ndo. Ta cha tyicuan caa cahín cha ndicha, ¿ñáá tuhun cha ña chinó iñi ndo chii? ");
INSERT INTO mxtNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ñu cuenda Nyoo tyasohó ñu tuhun cahán Nyoo. Soco vatyi nyoho ñima ñu cuenda Nyoo cuví ndo, yucuan chaha ña cuñí ndo tyasoho ndo tuhun cahín ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tyicuan ta ra cacuvi nuu chi ñu Israel cacatyí ra chi ra: ―¿Atu ña ndicha vatyi yoho ra ñuu Samaria cuvún, ta ñohó noo tatyi ña vaha chuun? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ta nacaha̱n ra Jesús ta catyí ra: ―Ñahri tatyi ña vaha ñohó chi yuhu. Chi Suti sacahní. Ta nyoho cahán ña vaha ndo sɨqui. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yuhu ña nanduquí nu sacahnu ñáyɨvɨ chii, soco iyó noo ra nanducú cha sacahnu ñu chii. Ta maa ra cunyehe ra tatu sacahnú ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cha ndicha catyí vatyi ñu quichahá tuhun cahín ma chaa tuhun chihi añima ñu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tyicuan ta ra Israel cuan canacaha̱n ra ta catyí ra: ―Vityin chitó vaha ndi vatyi yɨhɨ́ noo tatyi ña vaha chuun. Vatyi ra Abraham ta tandɨhɨ ra cuví profeta Nyoo cachihi̱ ra. Ta yoho catyún vatyi ñu quichahá tuhun cahún ma cúvi maa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Atu cahnu ca ra cuví yoho ican saha sutu ndi ra Abraham? Maa ra chihi̱ ra ta ra cuví profeta Nyoo ñandɨhɨ. ¿Yóó ra cuví yoho cuñí maun? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ta nacaha̱n ra Jesús ta catyí ra: ―Tatu suri mai sacahní chii, ñahri maa vale cuan. Soco ra sacahnú chii, ican cuví Suti. Ta suri maa ra cuví cha catyí nyoho tyi Nyoo cuenda ndo cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Soco nyoho ña ñohó nuu ndo chi ra. Yuhu, ñohó nui chi ra. Ta tatu catyí tyi ña ñohó nui chi ra, cuví noo ra cuendu tari nyoho. Soco yuhu ndicha cha ñohó nui chi ra, ta quichahí tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ra Abraham sutu chahnu ndo cusɨɨ xaan cuñi̱ ra vatyi cunyehe ra quɨvɨ quichi yuhu sɨquɨ ñuhu ñayɨvɨ̱. Ta nyehe̱ ra ta cusɨɨ xaan cuñí ra ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tyicuan ta ra Israel cuan cacatyí ra chi ra Jesús: ―Ni uvi xico uchi cuiya ta quita con, ta catyún tyi nyehu̱n chi ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ta ra Jesús nacaha̱n ra ta catyí ra: ―Cha ndicha catyí chi ndo vatyi nyata ni cumañi coo ra Abraham ta cha iyó yuhu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tyicuan ta quehe̱n ra yuu vatyi cañi ra chi ra Jesús. Soco maa ra quɨhvɨ̱ xehe ra, ta quita̱ ra chichi vehe ñuhu cuan. Ta yaha̱ ra mahñu ra ta cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cuhva cha yaha̱ ra Jesús noo nu yaha̱ ra, nyehe̱ ra chi noo ra cha cuaa nyata cacu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ta quichahá ndaca tuhun ra cachicá noo chihin ra Jesús chi ra: ―Maestro, ¿ñáá tuhun cha cacu cuaa ra ihya? ¿Atu cha cuenda cuatyi sɨhɨ ra ta sutu ra, o cha cuenda cuatyi maa ra? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ta ra Jesús nacaha̱n ra ta catyí ra: ―Ñima cuatyi maa ra, ta ni ñima cuatyi sɨhɨ ra ta sutu ra. Soco cha cuenda vatyi cuví sañaha Nyoo tunyee iñi ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cha nɨ ri ca cha ñicahñu, cuñí chi cha sacuvi tyiño ra cha tachi̱ chii. Vatyi vachi cha cuaa cha ma cuvi ca saha tyiño yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cha nɨ ri ca cha nyaí sɨquɨ ñuhu ñayɨvɨ̱ ihya, ñuhu̱ ndichin cuenda ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cha yaha̱ cha catyí ra Jesús tuhun ihya, ta tyicu̱ sɨɨ ra nu ñuhú. Ta savaha̱ ra chiin nyahyu chihin sɨɨ ra ta tyaa̱ ra chɨtɨ nuu ra cuaa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tyicuan ta catyí ra chi ra: ―Cua̱han cuanacatya nuun nya tanque Siloé cuan. ―Sɨvɨ cuan cuñí chi catyí: “Tachi̱ Chuun.” Tyicuan caa ta ra cuaa cuan chaha̱n ra chinacatya̱ ra nuu ra. Ta cuhva cha nachaa̱ ra, cha nyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tyicuan ta ñu nyicú yatyin yuvehe ra, ta ñu cha nyehe̱ chi ra cha cucuaa̱ ra ta caya̱ ra, catyí ñu: ―¿Atu ñima ra ihya cuví cha tuhva chinyaa chican caridaa? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yɨhɨ́ ñu catyí ñu: ―Ican ra. Inga ñu catyí ñu: ―Ñima ra cuví ra, soco ndacú xaan ra chi ra. Soco maa ra catyí ra: ―Ican yuhu cuví ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tyicuan ta quichaha candaca tuhun ñu chi ra: ―¿Ta yoso caa cha cuví nyehun vityin? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta catyí ra: ―Ra cha nañí Jesús cuan, ican savaha̱ nyahyu ta tyaa̱ ra chɨtɨ nui ta catyí ra chii: “Cua̱han nya tanque Siloé ta nacatyon nuun.” Tyicuan ta chahi̱n. Ta cha yaha̱ nacatye nui ta nanyehi̱ ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tyicuan ta quichahá ndaca tuhun ñu chi ra: ―¿Nya nyaá ra cuan vityin? Ta maa ra catyí ra: ―Ña chité ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tyicuan ta chinyaca̱ ñu chi ra cha cucuaa̱ cuan nuu ra cuví fariseo. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Vatyi quɨvɨ cha savaha̱ ra Jesús nyahyu ta sanduvaha̱ ra chi ra cha cucuaa̱ cuan, quɨvɨ nyitatú yo cuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yucuan chaha ra fariseo candaca̱ tuhun tucu ra chi ra yoso caa cha vatyi nanyehé ra. Ta maa ra catyí ra: ―Tyaa̱ ra nyahyu chɨtɨ nui, ta nacatye̱ ta vityin ndichin nyehí ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tyicuan ta suhva ra fariseo cacatyí ra: ―Ra cha sacuvi̱ tyehe caa ñima ra cuenda Nyoo cuví ra, vatyi ña sahá ra ñáyɨvɨ quɨvɨ nyitatú yo ―cacatyí ra. Soco inga ra cacatyí ra: ―¿Yoso caa cha cuví sacuvi ra milagru ihya tatu ra iyó cuatyi cuví ra? ―catyí ra. Ta sɨɨn sɨɨn cha cacahan ra. Ta cacusɨɨ̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ta candaca̱ tuhun tucu ra inga chaha chi ra cha cucuaa̱ cuan, ta catyí ra chi ra: ―¿Ta yoho, ñáá catyún cuenda ra cha sanduvaha̱ chɨtɨ nuun? ―catyí ra. Ta nacaha̱n ra ta catyí ra: ―Yuhu catyí vatyi noo profeta cuenda Nyoo cuví ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Soco ra cacuví nuu chi ñu Israel ña cuñí ra chino iñi ra cha cucuaa̱ ra cuan ta vityin nyehé ra. Ta nyacua nya cha cacana̱ ra chi sɨhɨ ra ta chi sutu ra cha nduvaha̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta candaca̱ tuhun ra chi ñu, ta catyí ra: ―¿Atu ican ra ihya cha cuví sehe ndo cha catyí ndo tyi cuaá ra ta cacu̱ ra? ¿Yoso caa cha cuví nyehe ra vityin? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ta nacaha̱n sutu ra ta sɨhɨ ra ta catyí ñu: ―Chitó ndi vatyi ican ra ihya cuví sehe ndi. Ta cuaá ra nyata cacu̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Soco ña chitó ndi ñáá tuhun cha cuví nyehe ra vityin. Ta ni ña chitó ndi yóó cha sanduvaha̱ chɨtɨ nuu ra. Nda̱ca tuhun ndo chi maa ra. Cha iyó cuiya ra. Ta cuví nacatyi maa ra chi ndo ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sutu ra sɨhɨ ra catyí ñu tyehe caa cha cuenda cha yuhví ñu chi ra cacuví nuu chi ñu Israel, vatyi cha catyihi̱ tahan ra tuhun vatyi cutava ñehe ra chi ñu vehe ñuhu, yóó ri ñu cha catyí vatyi ra Jesús cuví Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yucuan chaha catyi̱ ñu: “Cha ñihi ra. Nda̱ca tuhun ndo chi maa ra.” ");
INSERT INTO mxtNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tyicuan ta canacana̱ tucu ra chi ra cha cucuaa̱ cuan inga chaha. Ta cacatyí ra chi ra: ―Chihin nuu Nyoo ca̱tyi cha ndicha chi ndi. Vatyi nyuhu chitó ndi tyi rayɨɨ cuan, ra iyó cuatyi cuví ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tyicuan ta nacaha̱n ra cha cucuaa̱ cuan ta catyí ra: ―Yuhu ña chité tatu ra iyó cuatyi cuví ra, o ñima. Soco noo ri cha chité vatyi yuhu cucuai̱, ta vityin ndichin nyehí ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ta candaca tuhu̱n tucu ra chi ra inga chaha ta catyí ra: ―¿Ñáá cha sacuví ra chuun? ¿Yoso caa sacuvi̱ ra ta nanyehún? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta catyí ra: ―Cha catyi̱ chi ndo, ta ña quichahá ndo chii. ¿Ñáá tuhun cha cuñí ndo cha catyi inga chaha? ¿Atu cuñí tucu nyoho cunyicon ndo chi ra? ");
INSERT INTO mxtNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tyicuan ta cacaha̱n ra chi ra, ta catyí ra: ―Yoho yɨhún cuenda ra, soco nyuhu cuenda ra Moisés yɨhɨ́ ndi. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nyuhu chitó ndi tyi Nyoo caha̱n chihin ra Moisés. Soco ra cuan, ña chitó ndi nya quita̱ ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tyicuan ta nacaha̱n ra cucuaa̱ cuan ta catyí ra: ―¡Ñana vaha cha cuví ihya! Nyoho ña chitó ndo nya quita̱ ra, ta chi yuhu sananyehe̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Chitó vaha yo vatyi Nyoo ña tyasohó ra nu chicán ra iyó cuatyi. Soco ra cha sacahnú chi ra ta sacuví cuhva cuñí ra, tyasohó Nyoo nu chicán ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni noo chaha ta cuɨñɨ ca yo vatyi iyó noo ra sananyehe̱ chi noo ra cuaá nyata cacu̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tyehe ta ra ihya ta ñima cuenda Nyoo vachí ra, ñahri cha cuví sacuvi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tyicuan ta cacatyí ra chi ra: ―Yoho ra iyó cuatyi cuvún nyata cacu̱n. ¿Ta cuñún sañahu̱n chi nyuhu? ―cacatyí ra. Ta catava̱ ñehe ra chi ra vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ra Jesús chitó ra vatyi catava̱ ñehe ra chi ra cucuaa̱ cuan vehe ñuhu. Ta cuhva cha nañihi̱ ra chi ra ta catyí ra chi ra: ―¿Atu chinó iñi yoho chi Rayɨɨ cha quichi nya gloria? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ta nacaha̱n ra ta catyí ra: ―Tata, ca̱tyi chii, yóó ra cuví ra vatyi chino iñi chi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta ra Jesús catyí ra: ―Cha nyehu̱n chi ra. Ta ican ra ndatuhún chuhun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tyicuan ta chicuiñi̱ chɨtɨ ra chaha ra Jesús ta catyí ra chi ra: ―Chinó iñi chuun, Sutu Mañi yuhu ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta ra Jesús catyí ra: ―Yuhu vachí vatyi catyi cha caá añima ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya. Vatyi ñu cuaa, ñu ña chitó tuhun Nyoo cunanyehe ñu vatyi cucava tuhun Nyoo añima ñu. Ta ñu cuñí maa tyi ndichin nyehe tyi catyí ñu tyi chitó ñu tuhun Nyoo, coto ñu tyi cuaa ñu tyi ña chinó iñi ñu chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tyicuan ta suhva ra cuví fariseo cha nyicú yucuan chiñi̱ ra cha caha̱n ra Jesús, ta catyí ra chi ra: ―¿Atu cuaa tucu nyuhu ñandɨhɨ? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tyicuan ta catyí ra Jesús chi ra: ―Tyehe ta cuaa nyoho, nɨcohón nuu ndo tyi chiñuhú tuhun Nyoo chi ndo, ta ma coo cuatyi ndo. Soco vatyi catyí ndo tyi nyehé ndo ta chitó ndo, yucuan chaha ndoó cuatyi sɨquɨ ndo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Cahán ca ra Jesús ta catyí ra: ―Cha ndicha catyí chi ndo, tatu noo ra cuaquɨhvɨ chichi noo chacu mbee, ta cha nuu cha quɨhvɨ́ ra yuhu chacu, quɨhvɨ́ ra inga ityi, ra suhu cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Soco ra quɨhvɨ́ ityi yuhu chacu, ra sahá cumi mbee cuan cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ra nyaá yuhu chacu cuan nuña ra na quɨhvɨ ra sahá cumi mbee cuan. Ta mbee cuan nɨcohón soho tɨ ndusu ra. Noo noo tɨ ta iyó sɨvɨ tɨ sahá ra, ta cana ra chi tɨ ta tavá ra chi tɨ ityi chata chacu. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ta cha yaha̱ tava̱ ra chi tɨ, ta cuahan ra ityi nuu tɨ ta nyicón tɨ chi ra, vatyi nɨcohón soho tɨ ndusu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Soco tatu ña ñohó soho tɨ ndusu ra, chinó tɨ chi ra ta ma cunyicon tɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tyehe caa tuhun caha̱n ra Jesús chihin ñu. Soco maa ñu ña cutuñí iñi ñu ñáá tuhun cuñí ra cahán ra cha tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tyicuan ta catyí ra Jesús inga chaha chi ñu: ―Cha ndicha catyí chi ndo vatyi yuhu cuví tari noo yuhu chacu nu quɨhvɨ́ coyo ñáyɨvɨ cuende cha cuví ñu tari mbee sane. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tandɨhɨ ra cha yaha̱ caquichi̱ coyo, ra suhu cacuví ra. Soco mbee ña quichaha̱ tɨ cha cacaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yuhu cuví yuvehe gloria. Ñu quɨhvɨ̱ cuende, cacu̱ ñu cha ma cuhun ñu anyaya. Ta cuví ñu tari noo mbee cha quɨhvɨ́ ta quitá chichi chacu cuan. Ta ñihí tɨ cuhu cachi tɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Noo ra suhu vachí ra, soco vachí suhu ra, vachí cahñi ra, vachí satɨvɨ ra. Soco yuhu vachí vatyi coo ndo noo ñayɨvɨ̱ chaa cha ma naa ca maa. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yuhu cuví noo ra vaha sahá cumi mbee. Vatyi ra sahá cumi mbee chahá ra ñayɨvɨ̱ ra cuenda sana ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Soco ra cuví musu, tatu nyehé ra vachí lobo cha cuví noo quɨtɨ xaan, sandoo maa ra chi mbee sana chitoho ra. Ta chinó ra. Vatyi ñima sana maa ra cuví tɨ. Tyicuan ta tɨɨn quɨtɨ xaan chi mbee cuan. Ta saquicono tɨ chi tɨ ityi cuan ityi ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Musu cuan chino ra cha cuenda vatyi cha cuenda xuhun ri sahá tyiño ra. Ta ñahri cuenda ra chi mbee, tyi ñima sana ra cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Yuhu cuví ra sahá cumi vaha mbee sane. Ta ñohó nui chi tɨ. Ta maa tɨ ñohó nuu tɨ chii, ");
INSERT INTO mxtNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tari ñohó nuu Suti chii, ta yuhu ñohó nui chi ra. Yuhu chahí ñayɨvi̱ cuenda mbee sane. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Iyó tucu inga mbee sane cha ñima chichi chacu ihya iyó tɨ. Cuñí chi cha cuhin cunaquehin chi tɨ. Ta cuquichaha tɨ chii. Ta coo noo ri nu quɨhɨ tandɨhɨ tɨ. Ta noo ri ra sahá cumi chi tɨ cucoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Suti cuñí ra chii vatyi chahí ñayɨvi̱ cha catyi ñáyɨvɨ cuende. Soco yaha cuan, nacuhva tucu ra ñayɨvi̱ inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yori tinyaá ñayɨvi̱, soco cha iyó vaha iñi mai ta chahí. Iyó ityi chii cha cuhve ñayɨvi̱ ta cúvi, ta iyó tucu ityi chii cha naquehen tiqui inga chaha vatyi cunandote. Ican ihya cuví tyiño cha tyaa̱ Suti chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cha cachiñi̱ tucu ra cacuví nuu chi ñu Israel tuhun cha cahán ra Jesús ihya, cacusɨɨ̱n tucu ra chihin tahan ra inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ta cuaha xaan ra catyí ra: ―¿Ñáá tuhun cha quichaha ndo chi ra chiña? Ta yɨhɨ́ noo tatyi ña vaha chi ra, ta loco ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta inga ra catyí ra: ―Yori ñu ñohó tatyi ña vaha chi cahán tyehe caa. ¿Atu cuví sananyehe noo tatyi ña vaha chi noo ra cuaa? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nya ñuu Jerusalén yoo vichin cuví. Ta sanducahnú ñu noo vico quɨvɨ nanduchin cuiya cha suhñi̱ ñu vehe ñuhu cahnu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta ra Jesús chicá noo ra vehe ñuhu cuan ityi corredor ra Salomón. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ta ra cacuví nuu chi ñu Israel cachicuitayucu̱ cutya ra nuu ra. Ta quichaha̱ ndaca tuhun ra chi ra: ―¿Ama catyi cachun chi ndi tatu icon cuví Cristo? ɨngaña ri ca̱tyi cachi chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ta ra Jesús catyí ra: ―Cha yaha̱ catyi chi ndo, ta ña chinó iñi ndo chii. Tyiño sacuví nuu Suti ican cuví cha ndaa cuende. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Soco nyoho ña chinó iñi ndo chii vatyi ñima mbee sane cuví chi ndo. Tari cuhva catyi̱ chi ndo ndaa ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mbee sane nɨcohón soho tɨ ndusi, ta yuhu ñohó nui chi tɨ. Ta maa tɨ nyicón tɨ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yuhu chahí ñayɨvɨ̱ cha ma naa ca maa coo tɨ. Ta ma cunaa tɨ. Ta ni yori maa cuví tinyaa chi tɨ chichi ndahi. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maa Suti chaha̱ chi tɨ chii. Ta cahnu ca cuví maa ra ican saha tandɨhɨ ca. Ta yori cuví tinyaa chi tɨ chichi ndaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yuhu ta Suti Nyoo, noo ri cuví ndi ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tyicuan ta ra cacuví nuu chi ñu Israel cuan caquehe̱n tucu ra yuu vatyi tuchi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ta ra Jesús catyi ra chi ra: ―Cuaha xaan cha vaha sacuvi̱ yuhu nuu ndo chihin tunyee iñi Suti. ¿Ta nya cuenda cuan cua tuchi ndo yuu chii? ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta ra cacuví nuu chi ñu Israel cuan cacatyí ra: ―Ñima cha cuenda noo cha vaha sacuvu̱n cutuchi ndi yuu chuun, soco cha cuenda vatyi yahun nuu Nyoo chihin tuhun cahún. Noo rayɨɨ ri cuvún, soco sahún tari Nyoo chuun ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tyicuan ta catyí ra Jesús chi ra: ―Nu tutu tuhun Nyoo nyaá vatyi Nyoo catyí ra: “Nyoho cuví ndo nyoo”, catyí Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chitó yo vatyi cha cahán tuhun Nyoo, ma cuvi catyi yo tyi ña ndicha. Ta Nyoo sacunañí ra nyoo chi ñu naquehén tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ta tatu maa Nyoo nacachi̱ chi yuhu ta tachi̱ ra chii sɨquɨ ñuhu ñayɨvɨ̱ ihya ¿yoso caa catyí nyoho vatyi yahá yuhu nuu Nyoo nu catyí tyi Sehe Nyoo cuví chii? ");
INSERT INTO mxtNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tatu ña sacuví cha sacuví Suti, ma chino iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Soco tatu sacuví, vasɨ ma chino iñi ndo chii, soco chi̱no iñi ndo tyiño sacuví. Tyicuan ta cucoto cachi ndo vatyi Nyoo Suti ɨɨn ri cuví ra chihin. Ta yuhu ɨɨn ri cuví chihin Nyoo Suti ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inga tucu chaha cacuñi̱ ra catyihi ra chi ra vehe caa, soco ra Jesús cuahan ri ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tyicuan ta cuanuhu̱ ra ityi nu caña ñanyii inga chiyo yuvi cahnu Jordán cuan nu sacondutya̱ ra Juan ta xihna ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cuaha ñáyɨvɨ chaha̱n chinyehe chi ra, ta catyí ñu: ―Ndicha, vasɨ ni noo milagru ña sacuvi̱ ra Juan, soco tandɨhɨ tuhun cha caha̱n ra cuenda ra ihya ta ndicha ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ta cuaha xaan ñu cachino̱ iñi ñu chi ra Jesús ityi cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iyó noo ra cuhví cha nañí Lázaro ñuu Betania nu cuví ñuu cu María ta cu Marta cuhu ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta cu María, cuhva ra Lázaro cuan ican ña cuví ñaha cha choso̱ ndutya vixi chahán chaha Sutu Mañi yo, ta chihin ixi xiñi ña nacuhva̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ta tyicuan caa nɨnduvi tahan ñu, cu María chihin cuhu ña, tachi̱ ñu tyiño na cucatyi ra chi ra Jesús tyehe caa; ―Sutu Mañi ndi, amigon cuhví ra ―catyí ñu, tachi̱ ñu tyiño. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta cha chiñi̱ ra Jesús tuhun ihya ta catyí ra: ―Cuehe cuan ma cahñi chi chi ra. Cuhví ra tyehe caa tacuhva vatyi quɨvɨ nduvaha ra cunyehe ñáyɨvɨ tyi cahnu xaan ca ra cuví Nyoo ta tyicuan caa tucu Sehe ra ―catyí ra Jesús tuhun maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Cuñí vavaha ra Jesús chi cu Marta ta chi cuhu ña, ta chi cuhva ña, ra Lázaro. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Soco cuhva cha catyí ñu chi ra tyi cuhví ra Lázaro, ndoo̱ ra nu ñohó ra uvi ca quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tyicuan ta catyí ra chi ra cachicá noo chihin ra: ―Coho ndo inga chaha nya Judea ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tyicuan ta ra cachicá noo chihin ra cacatyí ra chi ra: ―Maestro, ta cunaha ca cha cuñí ra cacuví nuu chi ñu Israel cahñi ra chuun chihin yuu. Ta vityin, ¿inga chaha cuñún cuhun yucuan? ¿Ñáá tuhun? ");
INSERT INTO mxtNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta catyí ra Jesús: ―¿Atu ñima uchi uvi hora iyó noo quɨvɨ? Vatyi tatu cha ñicahñu chicá noo noo ra, ma nduva ra vatyi ndichin nyehé ra ta sacuví ra tyiño nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Soco tatu cha cha cuaa chicá noo ra, nduva ra vatyi ñahri ñuhu̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tyicuan ta quichaha catyí tucu ra Jesús: ―Amigo yo, ra Lázaro quixí ra. Soco cuhin cusandoye chi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tyicuan ta catyí tucu ra cachicá noo chihin ra: ―Tata, tatu quixí ra, cuñí chi catyí vatyi cuanduvaha ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Soco ra Jesús cuñí ra catyi ra vatyi cha chihi̱ ra Lázaro. Ta ra cachicá noo chihin ra, cuñí maa ra vatyi cha ndicha quixí ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tyicuan ta catyi̱ cachi ra Jesús chi ra: ―Ra Lázaro cha chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta cusɨɨ cuñí vatyi yori chinyaa̱ yucuan. Vatyi tyicuan caa vaha ca cha cuenda nyoho, tacuhva chino iñi ndo chii. Co̱ho ndo cunyehe ndo chi ra ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tyicuan ta ra Tomás, cha catyí ñu: “ra tɨnɨhɨ cuan”, catyí ra chi inga ra cachicá noo chihin ra Jesús: ―Co̱ho tucu yo vatyi cúvi yo ɨɨn ri chihin ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cha chaa̱ ra Jesús Betania, ñihi̱ ra tuhun vatyi ra Lázaro cha cumi quɨvɨ ñohó ra chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñuu Betania cuan nyaá chi yatyin ri nu nyaá ñuu Jerusalén, tari noo uvi kilómetro sɨsava. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta cuaha ra cacuví nuu chi ñu Israel cuahan ra cuanyehe ra nu nyaá cu Marta ta cu María vatyi chihi̱ cuhva ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta ñihi̱ cu Marta tuhun vatyi cha cuachaa ra Jesús. Ta cuahan ña cuasatahan ña chi ra. Soco cu María ndoo̱ ña vehe. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ta cu Marta catyí ña chi ra Jesús: ―Sutu mañí yuhu, tyehe ta nyau̱n ihya, ma cúvi cuhve. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Soco yuhu chité vatyi Nyoo cusacuvi ra tandɨhɨ cha cacon chi ra ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta ra Jesús catyí ra chi ña: ―Cuhvon cunandoto ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ta cu Marta catyí ña: ―Ndicha, chité vatyi cunandoto ra quɨvɨ nandoto ndɨyɨ nu cuandɨhɨ quɨvɨ ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tyicuan ta catyí ra Jesús chi ña: ―Yuhu cuví ra sanandotó chi ndɨyɨ. Ta chahí cha conyito ñáyɨvɨ. Ñu chinó iñi chii, vasɨ cha chihi̱ ñu soco coo tucu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta tandɨhɨ ñu nyitó ca ta chinó iñi ñu chii, ma cúvi maa ñu. ¿Atu chiñó iñun tuhun ihya? ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta maa ña catyí ña: ―Chinó iñi, Sutu Mañi yuhu, vatyi yoho cuvún Cristo Sehe Nyoo, ra cha nyaá cha quichi sɨquɨ ñuhu ñayɨvɨ̱ ihya ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cha yaha̱ cha catyi̱ cu Marta tuhun ihya, ta chaha̱n ña chiquehen ña chi cuhu ña, cu María, ta catyi̱ xehe ña chi ña: ―Cha chaa̱ Ra Sacuaha. Ta tachi̱ ra tyiño nacuhun nu nyaá ra ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ta cha chiñi̱ cu María tuhun ihya, nducuita̱ ri ña, ta cuahan ña nu nyaá ra Jesús, ");
INSERT INTO mxtNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ta ra Jesús ta quɨhvɨ ca ra chichi ñuu cuhva cuan, nyaá ra nu nañihi̱ cu Marta chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta nya vehe cu María, nyicú ra cacuví nuu chi ñu Israel tyinyeé ra chi ñu. Ta nyehe̱ ra vatyi numi ri quita̱ ña. Ta cuñí maa ra tyi cuahan ña nu ñaña cuacuacu ña. Ta cuahan coyo ra chata ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta cuhva cha chaa̱ cu María nu nyaá ra Jesús chicuɨñɨ̱ chɨtɨ ña chaha ra, ta catyí ña: ―Sutu Mañi yuhu, tyehe ta chinyau̱n ihya, cuhve ma cúvi ra ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nyehe̱ ra Jesús cha chacú cu María chihin ra Israel cha vachi coyo chihin ña, ta nducuihya xaan cuñí añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta ndaca̱ tuhun ra chi ñu: ―¿Nya maa maa tyihi̱ ndo chi ra? ―catyí ra. Ta catyí ñu: ―Tata, co̱ho ta nye̱hun ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ta ra Jesús chacu̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tyicuan ta catyí ra Israel cuan: ―Nye̱he ndo yoso cha cuñí ra chi ra ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Soco suhva ñu catyí ñu: ―Ican ra ihya cha sananyehe̱ chi ra cuaa cuan. ¿Atu ña cuví sanduvaha tucu ra chi ra Lázaro ihya? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nducuihya cuñí ra Jesús inga chaha ta tuhva̱ ra nu ñaña cuan. Noo chichi yuu cuví. Ta nyasɨ́ noo yuu yuhu chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ta catyí ra Jesús: ―Sa̱canyaha ndo yuu chiña ―catyí ra. Ta cu Marta, cuhva ndɨyɨ cuan, catyí ña: ―Soco cha caña̱ xico, Sutu Mañi yuhu, vatyi cha cumi quɨvɨ cha chihi̱ ra ―catyí ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Soco ra Jesús catyí ra chi ña: ―¿Atu ña cha catyi̱ chuun vatyi tatu chinó iñun, cunyehun yoso cha cahnu cuví Nyoo? ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tyicuan ta sacanyaha̱ ñu yuu cuan. Ta ra Jesús nanyehe̱ ndaa ra ityi andɨvɨ, ta catyí ra: ―Sutu Mañi yuhu, tyahvi nyoo chuun tyi chiñu̱n cha cahín. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yuhu chité vatyi tyicuan ri chiñún tuhun cahín. Soco tyehe caa cahín cha cuenda cha vaha chi ñáyɨvɨ nyicú ihya, tacuhva nachino iñi ñu tyi yoho tachi̱ chii ―catyí ra Jesús chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cha yaha̱ cha catyi̱ ra tuhun ihya, canachaa̱ ra, ta catyí ra: ―¡Lázaro, qui̱ta chiña! ");
INSERT INTO mxtNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ta quita̱ ra cha chihi̱ cuan, nuhñí ndaha ra ta nuhñí chaha ra chihin sahma. Ta nuhñí nuu ra chihin noo sahma. Ta ra Jesús catyí ra chi ñáyɨvɨ nyicú yucuan: ―Nda̱chi ndo chi ra. Ta sa̱ña ndo chi ra nacuhun ra ―catyí ra Jesús chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ta cuaha xaan ra cacuví nuu chi ñu Israel cha chaha̱n coyo chihin cu María nachino iñi ñu cha nyehe̱ ñu cha sacuvi̱ ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Soco suhva ra chaha̱n ra chisacoto ra chi ra fariseo cha sacuvi̱ ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tyicuan ta ra fariseo ta ra cacuví nuu chi tata sutu sacoo ra noo junta ta cacatyí ra: ―¿Ñáá cha sacuví yo? Vatyi cuaha xaan milagru sacuví ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tatu cuhva yo cha sacuvi ca ra tyicuan caa, tandɨhɨ ñáyɨvɨ cuchino iñi ñu chi ra. Ta ra cacuví tyiño nya ñuu Roma cuquichi ra ta cusatanɨ ra vehe ñuhu yo ta ñuu yo ―cacatyí ra chi ra tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Soco ra cuví nuu cahnu ca chi tata sutu cuiya cuan, ra nañí Caifás caha̱n ra ta catyí ra chi ra: ―Nyoho ñahri maa cha chitó ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni ña cutuñí iñi ndo vatyi vaha ca cha cúvi noo ri rayɨɨ cha cuenda tandɨhɨ ñáyɨvɨ ñuu, ta ñima ca cha cúvi tandɨhɨ yo ―catyí ra Caifás. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Soco ra Caifás cuan ñima cha cuñí maa ra ta cahán ra, soco vatyi ra cuví nuu cahnu ca chi tata sutu cuiya cuan cuví ra, yucuan chaha maa Nyoo sacaha̱n chi ra. Vatyi catyí ra vatyi ra Jesús cucúvi ra cha cuenda tandɨhɨ ñáyɨvɨ ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ta ñima cha cuenda ri ñu cuan, soco vatyi cusandu ɨɨn ri ra chi tandɨhɨ ñu cuví sehe Nyoo cha iyó inga ñuu ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yucuan ta nyacua nya quɨvɨ cuan ta ra cacuví nuu chi ñu Israel cuan, nducu ra cuhva yoso caa cahñi ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yucuan chaha tyi ra Jesús ña chicá noo ndichin ca ra nu nyicú ñu Israel. Ta quita̱ ra ityi Judea cuan. Ta cuahan ra noo ñuu cha nañí Efraín cha nyaá yatyin ri ñuhu ityi. Ta yucuan ndoó ra chihin ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ña cuaha ri ca quɨvɨ ta chaa̱ vico cuenda ñu Israel, vico cha nañí pascua. Ta cuaha xaan ñáyɨvɨ quita̱ ñu ñuu ñu ta cuahan ñu Jerusalén cuasacuvi ñu cha tuhvá maa ñu sacuví cha sandundɨɨ́ ñu chi ñu nuu Nyoo cha ni cumañi ca chaa quɨvɨ vico cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nanducú ñu chi ra Jesús. Ta cuhva cha nyicú ñu chichi vehe ñuhu cahnu cuan ta ndaca̱ tuhun ñu chi tahan ñu, ta catyí ñu: ―¿Yoso caa cuñí nyoho? ¿Atu cuquichi ra vico ihya, o ma quichi ra? ―catyí ñu chi tahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ta ra cacuví fariseo ta ra cacuví nuu chi tata sutu, catyí ra vatyi tatu nya noo ñu chitó ñu nya nyaá ra Jesús, nacatyi ñu. Vatyi cutɨɨn ra chi ra vatyi cohon ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cumañi iñu ca quɨvɨ cha cuatahan chi vico pascua, ta chaa̱ ra Jesús ñuu Betania nu iyó ra Lázaro, ra cha sanandoto̱ ra Jesús chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yucuan savaha̱ ñu cha cuxiñi ra Jesús. Cu Marta tyihi̱ ña coho nu mesa. Ta chicunyaa̱ ra Jesús nu mesa. Ta nyaá tucu ra Lázaro chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tyicuan ta cu María quehe̱n ña ta cha sava litro ndutya vixi chahán cha chino̱ chihin maa ri nardo, noo cha yahvi xaan nyaá. Ta cuhvi̱ ña chaha ra Jesús chihin ndutya vixi chahán cuan. Yaha̱ cuan ta sana ityi ña chihin ixi xiñi ña. Tandɨhɨ chichi vehe cuan chitu̱ chihin xico ndutya vixi chahán cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ta yucuan nyaá tucu ra Judas Iscariote, sehe ra Simón. Cuví ra noo ra chicá noo chihin ra Jesús. Ta suri maa ra cuví ra cha naxico̱ tuhun chi ra Jesús nuu ra xaan iñi chi ra. Ta quichaha catyí ra Judas cuan chi ñu cuan: ");
INSERT INTO mxtNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Ñáá tuhun ña xico̱ ndo ndutya vixi chahán ihya chi ñáyɨvɨ, cuhva ñu cuenda mil chi ndo chihin, ta tyinyee ndo chi ñu ndahvi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Soco ra Judas ña catyí ra tuhun ihya cha cuenda cha ndahvi cuñí ra nyehe ra chi ñu ndahvi, soco vatyi ra suhu cuví ra. Ta vatyi ndaha maa ra nyaá yɨtɨn xuhun ta tuhvá ra suhu ra cha tyihí ñu chichi yɨtɨn cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tyicuan ta catyí ra Jesús chi ra: ―Sa̱ña chi ña, vatyi ñaha ihya sacuvi̱ ña tyehe caa cha cuenda cha cuquɨhvɨ coño ñuhi chichi ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñu ndahvi tyicuan ri cu cunyicú ñu chihin ndo, soco yuhu ña tyicuan ri ―catyí ra Jesús chi ra Judas cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cuaha xaan ñu Israel ñihi̱ ñu tuhun tyi ra Jesús ñohó ra Betania, ta chaha̱n coyo ñu nyicuan. Ñima cha cuñí ñu nyehe ñu chi ra Jesús ri, soco cuñí tucu ñu nyehe ñu chi ra Lázaro, ra cha sanandoto̱ ra Jesús chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tyicuan ta ra cacuví nuu chi tata sutu catyihi̱ tahan ra tuhun vatyi cucahñi tucu ra chi ra Lázaro ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Vatyi cha cuenda ra ta cuaha xaan ñu Israel cacusɨɨn ñu chihin ra ta nachino iñi ñu chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cuaha xaan ñáyɨvɨ cuahan ñu Jerusalén cha vico pascua. Ta cha inga quɨvɨ cachitó ñu tyi ra Jesús cuachaa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tyicuan ta chahnya̱ ñu ndaha tunducaha ta cuahan coyo ñu cuasatahan ñu chi ra Jesús. Ta canachaa ñu, ta catyí ñu: ―¡Cahnu xaan ca cuví maa Nyoo! ¡Nasoco xaan Nyoo chi ra vachi ihya chihin tunyee iñi Nyoo! ¡Nasoco xaan Nyoo chi Rey cuenda yo ñu Israel! ―cacatyí ñu, canachaa ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ta ra Jesús ñihi̱ ra noo burru ta chicoso̱ ra chi tɨ tari cuhva catyí maa nu tutu Nyoo tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ma yuhvi ndo ñáyɨvɨ ñuu Sión Nye̱he ndo, vachi Rey ndo. Yosó ra noo burru ―catyí chi nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Quɨvɨ cuan ra cachicá noo chihin ra Jesús, ña cacutuñí iñi ra tuhun cuan cha nyaá nu tutu Nyoo. Soco cha yaha̱ cuanuhu ra Jesús gloria, canɨcohon iñi ra vatyi tandɨhɨ tuhun cuan ta nyaá nu tutu Nyoo tyi tyicuan caa cucuvi chi ra. Ta tyicuan caa cuvi̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ta ñáyɨvɨ cha nyehe̱ quɨvɨ cha cana̱ ra Jesús chi ra Lázaro chichi ñaña, quɨvɨ sanandoto̱ ra chi ra, nacatyí ñu cha nyehe̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ta yucuan chaha cuaha xaan ñáyɨvɨ chisataha̱n ñu chi ra Jesús, vatyi chito̱ ñu milagru cha sacuvi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tyicuan ta ra cuví fariseo cacatyí ra chi ra tahan ra: ―Cha nyehé maa ndo tyi ñahri maa cuví sacuví yo, vatyi tandɨhɨ ñáyɨvɨ nyicón chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ñohó tucu suhva ra ñuu Grecia mahñu ñáyɨvɨ cha chaha̱n coyo chisacahnu vico ñuu Jerusalén cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tyicuan ta catuhva̱ ra ñuu Grecia cuan nu nyaá ra Felipe, ra ñuu Betsaida nu cuví Galilea, ta cachacu̱ ndahvi ra nuu ra ta cacatyí ra: ―Tata, cuñí ndi cahan ndi chihin ra Jesús ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ta ra Felipe chaha̱n ra chicatyi̱ ra chi ra Andrés. Ta nɨnduvi ra chinacatyi̱ ra chi ra Jesús vatyi ra Grecia cuan cuñí ra cahan ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ta nacaha̱n ra Jesús, ta catyí ra: ―Chaa̱ cuhva vityin vatyi yuhu cha cuví Rayɨɨ cha quichi nya gloria, cuananuhu tiqui nya gloria, ta cusacahnu Suti chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cha ndicha catyí chi ndo vatyi tatu noo chɨtɨ ta ma quɨhɨ chichi ñuhú ta ma tyahyu chi, noo ri chɨtɨ cucuvi chi tyicuan ri maa. Soco tatu tyahyu chi, nduchaa chi inga chaha ta coo cuaha ca chɨtɨ chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ñu cuñí xaan ñayɨvɨ̱ iyó ñu, cucunaa ñu. Soco ñu ña cuñí ñayɨvɨ̱ ñuhu ñayɨvɨ̱ ihya, cunañihi ñu noo ñayɨvɨ̱ cha ma naa ca maa cucoo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tatu yɨhɨ́ ndo cuñí ndo sacuvi ndo tyiño nui, cu̱nyicon ndo chii. Ta nu cuacunyai, yucuan cucunyaa tucu ñu sacuví tyiño nui. Tatu nya nyoho sacuví ndo tyiño nui, Suti cusacahnu ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Vityin chicá xaan xiñi. Ta ¿ñáá cha cucatyi? ¿Atu catyi chi Suti na sacanyaha ra tɨndoho cha nyaá cunyehi vityin? Ma catyi cha tyicuan caa vatyi cha cuenda cuan vachi sɨquɨ ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Vaha ca catyi chi Suti: “Sutu Mañi yuhu, sa̱cahnu sɨvun” ―catyí ra Jesús. Tyicuan ta caha̱n noo ndusu ityi andɨvɨ ta catyí chi tyehe caa: ―Cha yaha̱ sacahni sɨvi, ta cusacahni inga chaha ―catyí ndusu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta ñu nyicú yucuan, chiñi̱ ñu ndusu cuan, ta catyí ñu vatyi savi caha̱n. Ta inga ñu catyí ñu: ―Noo ángel caha̱n chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tyicuan ta ra Jesús catyí ra chi ñu: ―Ñima cha cuenda cha vaha chi yuhu caha̱n ndusu cuan soco cha cuenda cha vaha chi maa ndo cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vityin cuví cuhva cutachi tuñi Nyoo chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱. Ta vityin cuhva cutava ñehe Nyoo chi ra nyacá ñaha sɨquɨ ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta cuhva cha cuitacai nu cruzi, yucuan cuhva cunaxite chi tandɨhɨ ñáyɨvɨ ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cahán ra tyehe caa cha cuñí ra na cutuñi iñi ñu tyi tyicuan caa cuhva cucúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ta ñáyɨvɨ nacaha̱n ñu ta catyí ñu chi ra: ―Tuhvá ndi chiñi ndi sacuaha ra nu libru ley yo vatyi ra cuví Cristo tyicuan ri maa cucoo ra. ¿Yoso caa cha catyí yoho tyi cusandaa ñu chi Rayɨɨ quichi nya gloria nu cruzi? ¿Yóó ra cuví Rayɨɨ cha quichi nya gloria cha cahún tuhun? ―catyí ñu, ndacá tuhun ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tyicuan ta ra Jesús catyí ra chi ñu: ―Iyó cha ndichin nu nyicu ndo, soco suhva ri ca quɨvɨ. Ca̱ca ndo ityi nu ndichin cha ni ri ca cha ndichin. Coto sana ri iñi ndo ta nduñaa iñi, vatyi ñu chicá noo nu ñaa iñi ña chitó ñu nya ityi cuahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chi̱no iñi ndo chi yuhu ra cuví ñuhu ndichin cuan, cha nɨ ri ca cha nyaá que chihin ndo. Tyicuan ta cuví ndo ñáyɨvɨ iyó nu ndichin. Cha yaha̱ catyi̱ ra Jesús tuhun ihya tixehe̱ nuu ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vasɨ cuaha xaan milagru sacuvi̱ ra Jesús nuu ñu soco ña chinó iñi ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Vatyi tahán chi cha cuví tari catyi̱ ra Isaías profeta Nyoo, nu caha̱n ra tyehe caa: Sutu Mañi yuhu, yori cuñí chino iñi tuhun cahán ndi. Yori cutuñí iñi tunyee iñi iyó chuun, Sutu Mañi yuhu, catyi̱ ra Isaías ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ta cha cuenda tuhun ihya cha nyaá nu tutu, yucuan chaha vatyi ña cuví chino iñi ñu vatyi suri tyaa̱ tucu ra Isaías tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nyoo sanducuaa̱ ra chi ñu. Ta sandundava̱ ra añima ñu, tacuhva cha ma nyehe ñu chihin chɨtɨ nuu ñu, ta ma cutuñi iñi añima ñu, ta ni ma nacuhva cuenda ñu chi ñu chi ra tacuhva sanduvaha ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ra Isaías catyi̱ ra tyehe caa vatyi nyehe̱ ra nu nyacá ñaha Sutu Mañi yo Jesús ta caha̱n ra tuhun ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Soco cuaha ñu Israel chinó iñi chi ra Jesús, ta nyacua nya suhva ra cacuví nuu, soco ña saquetuví ra nuu ñáyɨvɨ vatyi yuhví ra chi ra cacuví fariseo coto tava ñehe ra chi ra vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vatyi cuñí ca ra cuvaha ra nuu ñáyɨvɨ ta ñima ca cha cuvaha ra nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ñihi cahán ra Jesús, ta catyí ra: ―Ñu chinó iñi chii, ñima chi maa ri mai chinó iñi ñu, soco chinó tucu iñi ñu chi ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta ñu nyehé chii, nyehé tucu ñu chi ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yuhu cha cuví tari noo cha ndichin vachi ñuhu ñayɨvɨ̱ ihya, vatyi tacuhva vatyi ñu chinó iñi chii ma ndoo ñu nu ñaa iñi. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Soco tatu yɨhɨ́ ndo chiñí ndo tuhun cahín, ta ña sacuví ndo cha cahín, ñima yuhu tachi tuñi chi ndo. Vatyi ña vachi yuhu ñuhu ñayɨvɨ̱ ihya vatyi tachi tuñi chi ñáyɨvɨ. Soco vachi sacaqui añima ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ñu ña cuñí naquehen tuhun cahín ta ña cuñí ñu sacuvi ñu tari cuhva cuñí, iyó cha cutachi tuñi chi ñu. Tuhun cha cahín, ican cuan cutachi tuñi chi ñu nu cundɨhɨ quɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Vatyi ñima cuenda mai cahín. Suti ra cha tachi̱ chii, chaha̱ ra tuhun chii ñáá cha cucahin ta ñáá cha cusañahi. ");
INSERT INTO mxtNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta chité vatyi tuhun cha chaha̱ ra, chahá chi noo ñayɨvɨ̱ cha ma naa ca maa coo ñáyɨvɨ. Yucuan chaha, tuhun cha cahín, cahín soco cuhva catyí maa Suti cha cahín cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nonga quɨvɨ cumañi ta chaa vico pascua chitó ra Jesús vatyi cha chaa cuhva cha cuaquita ra ñuhu ñayɨvɨ̱ ihya ta cunuhu ra nu nyaá Sutu ra. Tyicuan ri cuñí xaan ra chi ñu cuenda ra cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya. Ta vityin cua sañahá ra chi ñu tyi cuñí xaan ra chi ñu vatyi cuacúvi ra cha cuenda ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta cuxiñí ra Jesús chihin ra cachicá noo chihin ra. Ta cha quɨhvɨ̱ cuihna añima ra Judas Iscariote sehe ra Simón tyiyuhu̱ ra chi ra, naxico tuhun ra chi ra Jesús ta nacuhva cuenda ra chi ra chi ra xaan iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Soco ra Jesús chitó ra vatyi chaha̱ cuenda Sutu ra tandɨhɨ chi ra vatyi cunyaa ndaha ra. Ta chitó ra vatyi nu nyaá Nyoo quita̱ ra ta suri yucuan cunanuhu ra. Ta nyaá ra Jesús cuxiñí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tyicuan ta nicuinanyaa̱ ra ta tava̱ ra sahma chata ra, ta chahñi̱ ra noo toalla chichi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tyicuan ta tyihi̱ ra ndutya chichi noo caa ta quichaha nacatya ra chaha ra cachicá noo chihin ra. Ta quichaha nacuhva ra chihin toalla cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta cha cuanacatya ra chaha ra Simón Pedro ta catyí ra Simón chi ra: ―Sutu Mañi yuhu, ¿atu yoho cuanacatyon chahi? ");
INSERT INTO mxtNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tyicuan ta catyí ra Jesús: ―Vityin ña cutuñí iñun cha sacuví. Soco cucutuñi maa iñun nu cuahan ca chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Soco ra Pedro catyí ra chi ra: ―Ni noo chaha ta ma nacatyon chaha yuhu. Ta catyí ra Jesús chi ra: ―Tatu ma nacatye chahun, ñima ra cuende cuvún. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tyicuan ta catyí ra Pedro chi ra Jesús: ―Tu tyicuan caa, Sutu Mañi yuhu, ñima chaha ri nacatyon, soco na̱catya tucun ndahi ta xiñi ñandɨhɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Soco ra Jesús catyí ra chi ra: ―Ñu cha ni chityi, ña cuñí chi cha ndoo tandɨhɨ coño ñuhu ñu. Chaha ri ca ñu cuñí chi, vatyi cha ndɨɨ maa nanɨɨ ñu. Nyoho cha ndɨɨ ndo, vasɨ ña tandɨhɨ ndo ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ta catyi̱ ra vatyi ña tandɨhɨ ra ndɨɨ ra vatyi chitó ra yóó cha cunaxico tuhun chi ra chi ra xaan iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ta cha yaha̱ cha nacatya̱ ra Jesús chaha ra cachicá noo chihin ra, ndɨhvɨ̱ noo ra sahma ra, ta nɨcunyaa̱ tucu ra inga chaha nu mesa ta catyí ra chi ra: ―¿Atu cutuñí iñi nyoho cha sacuví chi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyoho catyí ndo chii, Maestro ta Sutu mañí yuhu, ta ndicha vatyi ican cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yuhu cha cuví Ra Sacuaha ta Sutu Mañi ndo, nacatye̱ chaha ndo, tyicuan caa cuñí tucu chi cha nacatya ndo chaha tahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yuhu chahi̱ noo cuhva chi ndo vatyi sa̱cuvi ndo tari cuhva sacuvi̱ mai. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cha ndicha catyí chi ndo vatyi ni noo musu ta ña cahnu ca ra ican saha chitoho ra. Ta ni noo ra cha cuahan tyiño, ña cahnu ca ra ican saha ra cha tachi̱ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tatu cutuñí iñi ndo tuhun ihya, ta sacuví ndo, sɨɨ xaan cucuví chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ñima cha cuenda tandɨhɨ ndo cahín. Yuhu chité yóó chi nacachi̱ mai. Soco cuñí chi cha cucuvi tari catyí tuhun Nyoo tyehe caa: “Ra cha chachi̱ pan chihin, ican ra cuan cunaxico tuhun chii chi ra xaan iñi chii”, catyí chi nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Catyí chi ndo tuhun ihya cha ni cumañi ca chino cava tacuhva vatyi quɨvɨ nacuvi tyehe caa, chino iñi ndo tyi iquen cuví ra cha tinyaa cuatyi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cha ndicha catyí chi ndo vatyi ñu tɨɨ́n cuenda chi ñu tachí yuhu chi, chi yuhu tɨɨ́n cuenda ñu cuví cuan. Ta ñu cha tɨɨ́n cuenda chi yuhu, tɨɨ́n cuenda tucu ñu chi ra cha tachi̱ chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cha yaha̱ cha catyí ra Jesús tyehe caa, quichaha̱ nducuihya xaan cuñi añima ra, ta catyí cachi ra: ―Cha ndicha catyí chi ndo, vatyi noo nyoho cunaxico tuhun ndo chii nuu ra xaan iñi chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tyicuan ta ra cachicá noo chihin ra, quichaha̱ canyehe ra nuu tahan ra, ta ña cachitó ra yóó chi tuhun cahán ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Noo ra chicá noo chihin ra nyañaá ra chi ra Jesús nu cuxiñí ra. Ta ican ra cuví ra cha cuñí xaan ra Jesús chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ta ra Simón Pedro savaha̱ ra seña chi ra, na ndaca tuhun ra yóó chi tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tyicuan ta nyañaá ra chi ra Jesús, ta ndaca̱ tuhun ra chi ra: ―Sutu Mañi yuhu, ¿yóó ra cuví ra cha cahún tuhun? ");
INSERT INTO mxtNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta nacaha̱n ra Jesús ta catyí ra: ―Cuasatyii chiin pan, ta ra cha cuhve chi, ican ra cuan cuví ra ―catyí ra. Tyicuan ta quehe̱n ra chiin pan ta satyii̱ ra, ta chaha̱ ra chi ra Judas Iscariote, sehe ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta cha quehe̱n ra Judas pan cuan ta quɨhvɨ̱ ra ña vaha añima ra. Tyicuan ta ra Jesús catyí ra chi ra: ―Tuhun cha yɨhɨ́ iñun sacuvun, sa̱cuvi cha numi ri ―catyí ra Jesús chi ra Judas. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Soco ni noo ra canyicú nu mesa cuan, ña cacutuñí iñi ra ñáá tuhun cha catyi̱ ra chi ra tyicuan caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Soco cha cuenda vatyi ndaha ra Judas nyaá yɨtɨn xuhun, yucuan chaha yɨhɨ́ ra cuñi̱ maa ra vatyi cuñí ra Jesús cha cusata ra cha chiñuhú chi ra cha cuenda cha vico cuan, o nacuhva ra suhva xuhun cuan chi ñu ndahvi, cacuñi̱ maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cha yaha̱ chachi̱ ra Judas pan, tyicuan ta quita̱ ra. Ta cha cuaa cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cha yaha̱ cha cuahan ra Judas, ra Jesús catyí ra: ―Vityin cunyehe ñáyɨvɨ yoso cha cahnu yuhu cha cuví Rayɨɨ cha quichi̱ nya gloria. Ta cuanyehe ñu yoso cha cahnu Nyoo cha cuende. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta tatu Rayɨɨ cha quichi̱ nya gloria sacahnú ra chi Nyoo, tyicuan ta Nyoo cusacahnu ra chi ra. Ta cha chaa̱ quɨvɨ cuasacahnu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sehe luhli, ña naha ca cuacunyai chihin ndo. Nyoho cunanducu ndo chii, soco tari catyi̱ chi ra cacuví nuu chi ñu Israel cuan, catyí chi ndo vityin, vatyi ma cuvi cuhun ndo nu cuahin. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chahí noo tuhun chaa chi ndo. Cu̱ñi ndo chi tahan ndo. Tari cuñí yuhu chi ndo, tyicuan caa cuñí chi cha cuñí ndo chi tahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tatu cuñí ndo chi tahan ndo, tandɨhɨ ñáyɨvɨ ta coto ñu vatyi ñu nyicón chii cuví ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ra Simón Pedro ndaca̱ tuhun ra chi ra Jesús ta catyí ra: ―Sutu Mañi yuhu, ¿nya cuhun? ―catyí ra. Ta ra Jesús nacaha̱n ra ta catyí ra: ―Nu cuahan yuhu, vityin ma cuvi cunyicon chii. Soco nu cuahan ca chi, ta cunyicon chii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tyicuan ta catyí ra Pedro chi ra: ―Sutu Mañi yuhu, ¿ñáá tuhun ma cuvi cunyiquen chuun vityin? Nyaí cha cuhve ñayɨvi̱ cha cuendon ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta nacaha̱n ra Jesús ta catyí ra: ―¿Atu ndicha cha cuhvon ñayɨvu̱n cha cuende? Cha ndicha catyí chuun, vatyi cha ni cumañi ca cuacu chaa loho, yoho cucatyun uñi chaha tyi ña ñohó nuun chii ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ta catyí ra Jesús: ―Ma caca xaan xiñi ndo. Chi̱no iñi ndo chi Nyoo, ta chi̱no iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Vehe Suti cuaha xaan nuu coo ndo iyó. Tyehe ta ñima tyicuan caa, cha naha catyí yuhu chi ndo. Ta cuhin cusanduvahi noo nu coo ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta cha yaha cha cuhin ta sanduvahi nu coo ndo, ta cuquichi inga chaha, quichi naquehin chi ndo. Tacuhva cunyaa ndo nu cuacunyai. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyoho chitó ndo nya cuhin, ta chitó ndo ityi. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ta catyí ra Tomás chi ra: ―Tata, ña chitó ndi nya cuhun. Ta ¿yoso caa coto ndi ityi? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ta ra Jesús catyí ra: ―Yuhu cuví ityi cha cuahan gloria. Ta yuhu cuví cha ndicha. Ta suri yuhu cuví ra chahá ñayɨvɨ̱ coo ndo. Noo tuhun ri cha cuenda yuhu, cuvi chaa ndo nu nyaá Suti. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ñohó nuu ndo chii, ta cha cuenda cuan ñohó nuu tucu ndo chi Suti. Ta nya vityin ta nu cuahan ca chi, ñohó nuu ndo chi ra, vatyi cha nyehé ndo chi ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tyicuan ta catyí ra Felipe chi ra: ―Tata, cu̱hva cha nyehe ndi chi Sutu yo Nyoo, ta chihin yucuan ri ta ndoo ndi vaha. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ta nacaha̱n ra Jesús, ta catyí ra: ―Yoho Felipe, cha naha nyaí chihin ndo, ta ¿yoso caa cha catyún cha ta cohon nuu con chii? Ñu cha nyehé chii, nyehé tucu ñu chi Nyoo Suti. Ta ¿ñáá tuhun catyún chii: “Cu̱hva cha nyehe ndi chi Sutu yo Nyoo”? ");
INSERT INTO mxtNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Atu ña chinó iñun tyi ɨɨn ri cuví yuhu chihin Suti Nyoo? Ta maa ra ɨɨn ri cuví ra chihin. Tuhun cha catyí chi ndo, ñima yuhu ri catyí, soco Suti cha nyaá chihin, ican ra sacuví tyiño ra chihin. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chi̱no iñi ndo chii vatyi ɨɨn ri ra cuví chihin Nyoo Suti. Ta Nyoo Suti ɨɨn ri ra cuví ra chihin. O cuví tucu chino iñi ndo chii cha cuenda tyiño Nyoo Suti cha sacuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cha ndicha catyí chi ndo vatyi ñu chinó iñi chii, cusacuvi tucu ñu cha sacuví yuhu. Ta cahnu ca cusacuvi ñu, vatyi yuhu cuhin nu nyaá Nyoo Suti. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta tandɨhɨ cha cacan ndo chihin sɨvi, yuhu cusacuvi tacuhva vatyi sacahnu ñáyɨvɨ chi Suti Nyoo cha cuenda cha cuví Sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuhu cusacuvi ñáá cha cacan ndo chihin sɨvi. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tatu cuñí ndo chii, qui̱chaha ndo tuhun cahín. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ta cacan tahvi mai chi Nyoo Suti na saquichi ra noo ra naquehen ndahvi chi ndo. Ta ican ra cuan cuví Tatyi Ii Nyoo, ra cha cahán maa ri cha ndicha. Ta cucunyaa ra chihin ndo tyicuan ri maa. Soco ñáyɨvɨ cha tahán ca iñi cha iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya ma cuvi naquehen ñu Tatyi Ii Nyoo vatyi ña cuví nyehe ñu chi ra. Ta ni ña caá ra añima ñu. Ta ni ña ñohó nuu ñu chi ra. Soco nyoho ñohó nuu ndo chi ra vatyi nyaá ra chihin ndo ta cuandoo ra chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma sandoo maa ri mai chi ndo. Quichi tiqui nu nyaá ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chiin ri ca, ta ñáyɨvɨ cuenda ñuhu ñayɨvɨ̱ ma nyehe ca ñu chii. Soco nyoho nyehé ndo chii. Vatyi yuhu iyé, yucuan chaha nyoho coo ndo ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quɨvɨ cuan cucoto ndo tyi yuhu ɨɨn ri cuví chihin Suti. Ta nyoho ɨɨn ri cuví ndo chihin. Ta yuhu ɨɨn ri cuví chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ñu cha cumí vaha tuhun cahín, ta sacuví ñu cuhva catyí, ican ñu cuan cuví ñu cha cuñí chii. Ta ñu cha cuñí chii, Suti cucuñi ra chi ñu. Ta cuñí tucu yuhu chi ñu ta cusañahi chi ñu yóó ra cuví yuhu ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta catyí ra Judas, ñima ra Judas Iscariote, inga ra. ―Sutu Mañi yuhu, ¿yoso caa cha chi nyuhu cusañahun chuun, ta ñima chi ñu cuenda ñuhu ñayɨvɨ̱? ");
INSERT INTO mxtNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nacaha̱n ra Jesús ta catyí ra: ―Ñu cuñí chii, sacuví ñu tuhun cahín. Ta Suti cuñí ra chi ñu. Ta quichi ndi nu nyaá ñu ta coo ndi chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ñu ña cuñí chii, ña sacuví ñu cha catyí. Ta tuhun cahín cha chiñi̱ ndo, ñima tuhun mai cuví, tuhun cahán Suti, ra cha tachi̱ chii cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Catyí tandɨhɨ tuhun ihya chi ndo cha nɨ ri ca cha nyaí chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Soco nu cuahan ca chi cutachi Suti Tatyi Ii ra tyiño nui. Maa ra cuví ra cutyinyee chi ndo ta cunaquehen ndahvi ra chi ndo ta cusañaha ra tandɨhɨ chi ndo. Ta cusanɨcohon ra iñi ndo tuhun cha yaha cahi̱n chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Sandoí noo cha taxi coo añima ndo, tari cha taxi cuñí añime. Ican chahí chi ndo. Ñima tari cha taxi cha ñihí ndo sɨquɨ ñuhu ñayɨvɨ̱ ihya. Ma caca xaan iñi ndo ta ma yuhvi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chiñi̱ ndo tuhun cha cahi̱n nu catyi̱ vatyi cuahin ta quichi tiqui nu nyicú ndo. Tatu cuñí ndo chii, cucusɨɨ cuñi ndo tyi catyi vatyi cuahin nu nyaá Suti. Vatyi cahnu ca cuví Suti ican saha yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ta vityin catyí tiqui chi ndo cha ni cumañi ca cuhin, tacuhva quɨvɨ cuhin, cunachino iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ma cahan cuaha que chihin ndo. Vatyi vachi ra nyacá ñaha sɨquɨ ñuhu ñayɨvɨ̱ ihya. Vasɨ ña nyacá ñaha ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Soco cuñí chi nacoto ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ vatyi yuhu cuñí chi Nyoo Suti, ta sacuví tyiño tyaa̱ ra chii. ’Ndɨ̱cuita ndo. Co̱ho ndo, naquita yo ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Yuhu cuví yoho tɨchaha ndɨvɨ cha ndicha vaha. Ta Suti cuví ra sahá cumi chi yoho cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chahnyá ra soco cha ña chahá chɨtɨ. Ta soco cha chahá chɨtɨ nacahnyá ra nuu chi, ta sanduvií ra, tacuhva nacuhva ca chi cuaha ca chɨtɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Suti cha sandundɨɨ̱ ra chi ndo chihin tuhun cha cahín chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sa̱ñihi ca ndo cu ɨɨn ri ndo chihin, tari yuhu ɨɨn ri cuví chihin ndo. Tari noo soco yoho cuan ma cuvi cuhva chi chɨtɨ cha maa ri maa chi tatu ña nyañaá chi chata yoho cahnu, tyicuan caa nyoho, ma cuvi sacuvi ndo cha vaha tatu ña ɨɨn ri cuvi ndo chihin. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yuhu cuví yoho cahnu cuan. Ta nyoho cuví ndo soco yoho cuan. Ñu cha nyañaá chii, ta yuhu nyañaí chi ñu, cuaha cha vaha sacuví ñu, vatyi ñahri cha cuví sacuvi ndo tatu yori yuhu nyaá chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ñu cha ña nyañaa chii, cusacuita Suti chi ñu, tari sacuitá yo soco yoho cha chahnya̱ yo vatyi ña chahá chɨtɨ. Ta na ityi ta nasataca yo, ta cucayu nu ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tatu nyoho ta tyicuan ri nyañaa ndo chii, ta ña naa iñi ndo tuhin, ca̱can ndo ñáá cha cuñí ndo, ta yuhu cuhve. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tatu cuaha cha vaha sacuví ndo, sacahnú xaan ndo chi Suti. Ta tyicuan caa sañahá ndo tyi cuví ndo noo ñu ndicha cha nyicón chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yuhu cuñí chi ndo, tari cuñí Suti chii. Ma naa iñi ndo cuhva cuñí chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tatu quichahá ndo tuhun cahín, cuacuñi que chi ndo. Tari yuhu quichahí nu cahán Suti, ta cuñí xaan ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Cahín tyehe caa chihin ndo tacuhva na cusɨɨ cuñí ndo chihin. Ta cucusɨɨ vavaha cuñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tuhun cha catyí chi ndo, ican cuví ihya: na cuñi ndo chi tahan ndo, tari cuñí yuhu chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tatu yaha xaan cuñí yo chi tahan yo, caña iñi yo cuhva yo nyacua nya ñayɨvɨ̱ yo cha cuenda ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyoho cuví ndo amigue, tatu sacuví ndo cha catyí chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ña catyí que vatyi musi cuví chi ndo, vatyi noo musu ña chitó ra ñáá cha sacuví chitoho ra. Amigue, catyí chi ndo vatyi sacote̱ chi ndo tandɨhɨ maa cha catyi̱ Suti chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyoho ña cachi̱ ndo chii. Mai nacachi̱ chi ndo. Ta catyi̱ chi ndo na cuhun ndo ta sa̱cuvi ndo tyiño nui. Ta tyiño sahá ndo cucuvaha xaan tari cuvaha noo itu. Ta cuaha vavaha nɨñɨ cucoo, ta ma tɨvɨ maa chi. Ta tyicuan caa ta Suti cuhva ra tandɨhɨ cha cacan ndo chihin sɨvi. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ican ihya cuví cha catyí chi ndo: Cu̱ñi ndo chi tahan ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tatu ñu cuenda ñuhu ñayɨvɨ̱ ña cuñí nyehe ñu chi ndo, co̱to ndo vatyi xihna ca chi yuhu ña cuñi̱ nyehe ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tyehe ta cuví ndo ñu cuenda ñuhu ñayɨvɨ̱, cucuñi ñu chi ndo tari cuñí ñu chi tahan ñu. Soco yuhu nacachi̱ chi ndo mahñu ñu. Ta yucuan chaha tasɨ cuñí nyehe ñu chi ndo, vatyi ñima ca ñu cuenda ñuhu ñayɨvɨ̱ cuví ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɨ̱cohon iñi ndo tuhun cha catyi̱ chi ndo, tyi ni noo musu ta ña cahnu ca ra ican saha chitoho ra. Ta tatu quichahá ñu tuhun cahín chihin ñu, tyicuan caa cuquichaha tucu ñu tuhun sañaha ndo chi ñu. Ta tatu satasɨ́ iñi ñu chii, cusatasɨ iñi tucu ñu chi nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tandɨhɨ ihya cusacuvi ñu chi ndo cha catyi yuhu, vatyi ña ñohó nuu ñu chi ra cha tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tyehe ta ña quichi̱ cahin chihin ñu, yucuan ndicha ñahri cuatyi ñu. Soco vityin ñahri sɨquɨ tyaa ñu cuenda cuatyi ñu, vatyi cha yaha̱ catyi chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñu cha tasɨ cuñí nyehé chii, tasɨ cuñí nyehé ñu chi Suti ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ñahri cuatyi ñu, tyehe ta ña sacuví milagru cha ni nonga ñáyɨvɨ ta sacuvi ca. Soco cha nyehé ñu tandɨhɨ ihya. Ta vasɨ cha nyehé ñu soco tasɨ cuñí nyehé ñu chii, ta chi Suti ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Soco tandɨhɨ tuhun ihya cuví chi tyehe caa, vatyi cuñí chi cha chino cava tari cuhva catyí nu tutu ley cha sacuaha ñu nu catyí chi tyehe caa: “Ñahri vihi tuhun, ta cutasɨ cuñi̱ ñu nyehe ñu chii”, catyí chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Soco cuquichi Tatyi Ii, ra cha cahán maa ri cha ndicha. Maa ra cuví ra cha naquehen ndahvi chi ndo. Nachai nu nyaá Suti ta cusaquichi ndi chi ra nu nyicú ndo. Ta quɨvɨ quichi ra, cucahan ra tumañi iñi cuende. ");
INSERT INTO mxtNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta nyoho tucu cucahan ndo tumañi iñi cuende, vatyi nyaá ndo chihin nyata quɨvɨ quichaha̱ sahatyiñe. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Catyí tuhun ihya chi ndo tacuhva cha ma sandɨhɨ ndo cha chinó iñi ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cutava ñehe ñáyɨvɨ chi ndo vehe ñuhu. Ta cuchaa chi quɨvɨ vatyi ñu cahñi chi ndo, cucuñi ñu vatyi tyiño nuu Nyoo sacuví ñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tyehe caa cusacuvi ñu cha cuenda vatyi ni chiin maa ta cohon nuu ca ñu ni chi Suti ta ni chi mai. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Catyí tuhun ihya chi ndo tacuhva vatyi quɨvɨ chaa chi tari cuhva catyí chi ndo, nɨcohon iñi ndo vatyi cha yaha̱ catyi̱ chi ndo. ’Ña catyi̱ tuhun ihya chi ndo quɨvɨ xihna ri cha cuenda tyi nyaá que chihin ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Soco vityin cuhin vatyi cunyai chihin ra cha tachi̱ chii. Ta ni noo nyoho ña ndacá tuhun ndo chii nya cuhin. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Soco nducuihya ndɨhɨ iñi ndo cha catyí tuhun ihya chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Soco catyí cha ndicha chi ndo: vaha ca cha cuhin cha cuenda cha vaha chi ndo. Vatyi tatu ma cuhin, ma quichi Tatyi Ii cha naquehen ndahvi chi ndo. Soco tatu cuhin, cutachi mai chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta quɨvɨ quichi ra cusacoto ra chi ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ vatyi iyó cuatyi ñu. Ta cusañaha ra chi ñu vatyi iyó noo cuhva vaha tahán chi coo ñu. Ta cusacoto ra chi ñu vatyi cutuñi chi ñu nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cusacoto ra chi ñu tyi iyó cuatyi ñu cha cuenda cha ña chinó iñi ñu chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cusacoto ra chi ñu tyi iyó noo cuhva vaha cha tahán chi coo ñu, vatyi yuhu cuhin nu nyaá Suti ta ma nyehe ca ndo chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta cu coto ñu tyi cusandaa Nyoo cuatyi ñu vatyi cha yaha̱ cundaa̱ cuatyi ra cuví cuihna, ra nyacá ñaha sɨquɨ ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ta cuaha ca tuhun nyaá catyi chi ndo, soco ma cutuñi iñi ndo vityin. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Soco quɨvɨ quichi Tatyi Ii cha cahán maa ri cha ndicha, maa ra cusañaha tandɨhɨ cha ndicha chi ndo. Vatyi ñima cuenda maa ra cucahan ra, soco cucahan ra tandɨhɨ cha chiñí ra. Ta cusacoto ra tuhun ñáá cha cucuvi nu cuahan ca chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cusacahnu ra chii, vatyi cunaquehen ra tuhin ta cusañaha ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tandɨhɨ cha iyó chi Suti, chi mai cuví ñandɨhɨ. Yucuan chaha vatyi Tatyi Ii cuquehen cuenda ra cha iyó chii, ta cusañaha ra chi nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ña naha ca ta ma nyehe ca ndo chii, soco yaha cuan ta cunyehe tucu ndo chii, vatyi yuhu cuhin nu nyaá Suti ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tyicuan ta suhva ra cachicá noo chihin ra, candaca tuhun ra chi tahan ra ta catyí ra: ―¿Ñana vaha tuhun cahán ra ihya? Catyí ra chi yo vatyi ña naha ca ta ma nyehe ca yo chi ra, ta yaha cuan ta cunyehe tucu yo chi ra inga chaha vatyi cuhun ra nu nyaá Sutu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ñáá cha cuñí chi catyi cha ña naha ca cuan? Ña cutuñí iñi yo ñáá túhun cahan ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ra Jesús tuvi̱ iñi ra vatyi cacuñí ra candaca tuhun ra chi ra, ta catyí ra: ―Yuhu catyi̱ chi ndo vatyi ña naha ca ta ma nyehe ca ndo chii, soco yaha cuan ta nanyehe tucu ndo chii. ¿Atu ican ihya cuví cha ndacá tuhun ndo chi tahan ndo? ");
INSERT INTO mxtNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cha ndicha catyí chi ndo vatyi nyoho cucuacu ndo ta cunducuihya iñi ndo, soco ñu cuenda ñuhu ñayɨvɨ̱ cusɨɨ cuñi ñu. Soco vasɨ cuihya iñi ndo vityin, tucuihya iñi cha iyó chi ndo cunanduvi chi tusɨɨ iñi. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cuhva cha cuacacu sehe noo ñaha sɨhɨ nyehé ña cha uhvi. Soco cha yaha cha cacu cha lee cuan, ni tuhun cha uhvi cuan ña nɨcohon ca iñi ña cha cuenda cha sɨɨ cuñí ña vatyi cacu̱ noo cha lee sehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tyicuan caa tucu nyoho vityin, nducuihyá iñi ndo. Soco cunanyehe tiqui chi ndo inga chaha. Tyicuan ta cundusɨɨ tucu iñi añima ndo. Ta yori cuví tinyaa tusɨɨ iñi cuan chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Quɨvɨ cuan ñahri ca cha cundaca tuhun ndo chii. Cha ndicha catyí chi ndo vatyi Nyoo Suti cucuhva tandɨhɨ cha cacan ndo chi ra chihin sɨvi. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nya vityin ta ta ñaha ca cha cacan ndo chihin sɨvɨ yuhu. Ca̱can ndo ta cuñihi ndo tacuhva na cusɨɨ xaan cuñi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Maa maa ri chihin cuhva ri sañahí chi ndo. Soco nu cuahan ca chi, ñima ca chihin cuhva cuasañahi chi ndo, soco cuacatyi cachi chi ndo tuhun Suti. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Quɨvɨ cuan chihin sɨvi cucacan ndo cha cacan ndo chi ra. Ta ña chiñuhú ca cha cucuacu ndahvi nuu Suti cha cuenda ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Vatyi maa Nyoo Suti suri cuñí ra chi ndo. Cuñí ra chi ndo vatyi nyoho cuñí ndo chii. Ta nachinó iñi ndo vatyi nu nyaá Nyoo quite̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nu nyaá Suti quite̱ vatyi quichi sɨquɨ ñuhu ñayɨvɨ̱ ihya. Soco vityin cusandoi ñuhu ñayɨvɨ̱ ihya vatyi cunuhi nu nyaá ra ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tyicuan ta ra cachicá noo chihin ra cacatyí ra: ―Vityin ndicha catyí cachun chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vityin nyehe ndi vatyi chitón tandɨhɨ maa tuhun, ta ña nyatun cha ndaca tuhun ndi chuun, vatyi cha chitón nyacua nya tandɨhɨ cha chicá xiñi ndi. Yucuan chaha chinó iñi ndi vatyi nu nyaá Nyoo quito̱n ―cacatyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ta catyí ra Jesús: ―Ta vityin ¿atu chinó iñi ndo chii? ");
INSERT INTO mxtNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Soco catyí chi ndo vatyi cha vachi chi cuhva ta vityin cuví cuhva vatyi nyoho cuquɨtɨ cuatyi ndo sɨɨn sɨɨn ityi, ta cusandoo ndo notuhun mai. Soco ñima notuhun ri mai nyaá, vatyi nyaá Suti chihin. ");
INSERT INTO mxtNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Catyí tuhun ihya chi ndo tacuhva na coo cha taxi ri añima ndo cha cuenda cha ɨɨn ri cuví ndo chihin. Ñuhu ñayɨvɨ̱ ihya cunyehe ndo tɨndoho, soco sa̱nyee ndo iñi ndo vatyi yuhu cha cuvi̱ chasahi chi cha ña vaha cha iyó ñuhu ñayɨvɨ̱ ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cha yaha̱ cha catyi ra Jesús tuhun ihya, nanyehe̱ ndaa ra ityi andɨvɨ ta catyí ra: ―Sutu Mañi yuhu, cha chaa̱ cuhva vityin. Sa̱cahnu chi yuhu cha cuví sehun, tacuhva sacahnu tucu yuhu chuun. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vatyi tyau̱n tyiño chii sɨquɨ tandɨhɨ ñáyɨvɨ, vatyi cuhve ñayɨvɨ̱ cha ma naa ca maa chi tandɨhɨ ñu chahu̱n chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta ihya cuví cuhva coo ñu ñayɨvɨ̱ cha ma naa ca maa: Cha cohon nuu ñu chuun vatyi noo tuhun ri maun cuví Nyoo cha ndicha vaha, ta cohon nuu ñu chi yuhu ra Jesucristo ra cha tachu̱n chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Cha sacahni̱ chuun ihya sɨquɨ ñuhu ñayɨvɨ̱ ta cha sandɨhi̱ tyiño cha chahu̱n chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta vityin, Sutu Mañi yuhu, cua ndichi nu nyaun, na̱cuhva cha cahnun cuví maun chii, tari cuhva cha chiyo chii nyata ni cumañi ca chino ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Tandɨhɨ ra cha chahu̱n chii ra cha natava̱ vahun mahñu ñu iyó sɨquɨ ñuhu ñayɨvɨ̱ ihya sacote̱ chi ra yóó ra cuví yoho. Chi maun cuví chi ra ta chahu̱n chi ra chii. Ta quichahá ra tuhun cahún. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vityin cachitó ra vatyi tandɨhɨ cha chahu̱n chii, nu nyaún quita̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Vatyi catyi̱ chi ra tuhun cha catyu̱n chii, ta maa ra canatɨɨ̱n cuenda ra. Ta tuvi̱ iñi ra vatyi ndicha cha quite̱ nu nyaún, ta chinó iñi ra tyi maun tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Yuhu chiquén cha cuenda ra chuun. Ña chiquén cha cuenda ñáyɨvɨ ña ñohó nuu chuun, soco chiquén cha cuenda ra cha chahu̱n chii, vatyi chi maun cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tandɨhɨ cha iyó chii, chi maun cuví. Ta tandɨhɨ cha chuun, chi mai cuví. Ta tandɨhɨ cuan sacahnú chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yuhu ma ndoo que ñuhu ñayɨvɨ̱ ihya, soco maa ra cundoo ra ñuhu ñayɨvɨ̱ ihya. Ta yuhu cuhin tyi cunyai chuhun. Sutu Mañi yuhu, sa̱ha cumi chihin cha ndicha ñuhu chi ra cha chahu̱n chii, tacuhva na cu ɨɨn ri ra chihin ra tahan ra, tari yoho chihin yuhu, ɨɨn ri cuví yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Quɨvɨ chinyai ñuhu ñayɨvɨ̱ ihya chihin ra, saha̱ cumi chi ra cha chahu̱n chii chihin cha ndicha ñuhun. Ta sahi̱ cuenda chi ra. Ta ni noo ra ña cuanaa̱ soco noo tuhun ri ra cha cha nyaá maa cunaa, ican ra cuan cunaa, tacuhva chino cava tari cuhva catyí nu tutu maun. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vityin cha vachi nu nyaún, soco cha nɨ ri ca cha nyaí sɨquɨ ñuhu ñayɨvɨ̱ ihya, catyí tuhun ihya tacuhva na cusɨɨ cuñi ra tari mai. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yuhu catyi̱ chi ra tuhun cahún, soco ñáyɨvɨ cuenda ñuhu ñayɨvɨ̱ tasɨ cuñí nyehe ñu chi ra nyicón chi yo, cha cuenda vatyi ñima ra cuenda ñuhu ñayɨvɨ̱ cuví ra, tari yuhu, ñima ra cuenda ñuhu ñayɨvɨ̱ cuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ña chiquén chuun cha tavon chi ra nyicón chi yo nu ñuhu ñayɨvɨ̱ ihya, soco sa̱ha cumun chi ra coto ñáá cha saha ra ña vaha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tari yuhu ñima ra cuenda ñuhu ñayɨvɨ̱ cuví, tyicuan caa tucu ra ihya, ñima ra cuenda ñuhu ñayɨvɨ̱ cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cu̱hva cha ndicha chi ra nasacuvi ra maa maa ri cuhva cuñí maun. Tuhun cahún, ican cuví cha ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tari tachu̱n chi yuhu nu nyicú ñu iyó sɨquɨ ñuhu ñayɨvɨ̱, tyicuan caa tachi̱ tucu yuhu chi maa ra nyicón chi yo nu nyicú ñu iyó sɨquɨ ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta cha cuenda cha vaha chi ra, sacuví yuhu maa maa ri cuhva cuñí maun, tacuhva vatyi chihin cha ndicha, cuví sacuvi tucu maa ra maa maa ri cuhva cuñí maun. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Soco ñima cha cuenda ri ra ihya chiquén chuun, soco chicán tiqui cha cuenda ñáyɨvɨ cha cuchino iñi chii chihin tuhun cahán ra ihya nu cuahan ca chi. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chiquén chuun na tandɨhɨ ñu ta ɨɨn ri na cuvi ñu chihin tahan ñu. Ta noo ri na cuvi ñu chihin yo, Sutu Mañi yuhu. Tari yoho nyaún chihin ta yuhu nyaí chuhun, na cu ɨɨn ri cuví ñu chihin yo, tacuhva vatyi tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ chino iñi ñu tyi maun tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yuhu chahi̱ cha ndicha ñuhu chi ñu nyicón chi yo, suri cha ndicha ñuhu cha chahu̱n chii. Vatyi chihin cuan na ɨɨn ri cuví ñu tari yoho chihin yuhu noo ri cuví yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yuhu nyaí chihin ñu ta yoho nyaún chihin, tacuhva na cuvi yo noo ri chihin ñu. Tyicuan caa ta coto tandɨhɨ ñáyɨvɨ iyó sɨquɨ ñuhu ñayɨvɨ̱ tyi maun tachi̱ chii, ta cuñí xaun chi ñu nyicón chi yo tari cuñún chi yuhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Sutu Mañi yuhu, maun chahu̱n chi ñu chii. Ta cuñí cha cunyaa ñu chihin nu cuacunyai, tacuhva nanyehe ñu cha ndicha ñuhu cha chahu̱n chii vatyi cuñún chii nyata ni cumañi ca chino ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sutu Mañi yuhu, ra vaha cuvún, ta ñu cuenda ñuhu ñayɨvɨ̱ ña ñohó nuu ñu chuun, soco yuhu ñohó nui chuun. Ta ra nyicón chi yo ihya chitó ra tyi maun tachi̱ chii. ");
INSERT INTO mxtNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cha catyi̱ chi ra yóó ra cuvún, ta cucatyi tiqui inga chaha, tacuhva vatyi tari cuhva cuñún chii, tyicuan caa cuhva cuacuñi tucu maa ra chi ra tahan ra. Ta yuhu cunyai añima ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cha yaha̱ cha catyi̱ ra Jesús tuhun ihya, quita̱ ra ta cuahan ra chihin ra cachicá noo chihin ra inga chiyo yuhu yuvi Cedrón. Ta yucuan nyaá noo chacu yutun yucu. Ta yucuan quɨhvɨ̱ ra Jesús chihin ra cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta ra Judas, ra cha naxicó tuhun chi ra, chitó ra nu cuahan ra Jesús. Vatyi tuhvá ra Jesús chahán ra yucuan chihin ra cha cachicá noo chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ta yucuan chaa̱ ra Judas chihin cuaha sɨndaro ta cuaha policía cuenda vehe ñuhu cha tachi̱ ra cuví nuu chi tata sutu ta ra cuví fariseo. Chaa̱ coyo ra yucuan, canyisó ra mityi, ta canyiso ra lámpara ta ñuhu̱ yɨtɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ta vatyi ra Jesús cha chitó ra tandɨhɨ cha cucuvi chi ra, quita̱ ra ta ndaca̱ tuhun ra chi ra: ―¿Yóó chi nanducú ndo? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta cacatyí ra chi ra: ―Chi ra Jesús ra ñuu Nazaret. Ta catyí ra Jesús: ―Yuhu cuví ―catyí ra. Ta ra Judas, ra cha naxicó tuhun chi ra Jesús nuu ra xaan iñi chi ra, nanyaá ra chihin ra yucuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta cuhva cha catyi̱ ra Jesús: “Yuhu cuví”, tandɨhɨ ra canandaca̱ chata ra ta canduva̱ ra nu ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tyicuan ta inga tucu chaha ndaca̱ tuhun ra Jesús chi ra, ta catyí ra: ―¿Yóó chi nanducú ndo? Ta cacatyí ra: ―Chi ra Jesús ra ñuu Nazaret. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ta catyí ra Jesús: ―Cha catyi̱ chi ndo tyi yuhu cuví. Tatu chii nanducú ndo, sa̱ña ndo chi ra chica noo chihin na cunuhun coyo ra ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ican tyehe caa catyi̱ ra Jesús tacuhva na chino cava cha catyi̱ maa ra ta ityi chata ca nu catyí ra: “Ra cha chaha̱ Suti chii, ni noo ra ña cuanaá.” ");
INSERT INTO mxtNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tyicuan ta ra Simón Pedro nyisó ra noo mityi. Ta tava̱ ra ta chahnya̱ ra soho chiyo vaha noo ra cha nañí Malco. Cuví ra cuan musu ra cuví nuu chi tandɨhɨ tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Soco ra Jesús catyí ra chi ra Pedro: ―Na̱tyihi mityun chichi veno. Tatu Nyoo Suti ta cuñí ra cha nyehi tɨndoho, tahán chi cha nyehi ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tyicuan ta sɨndaro cuan chihin capitán ra, ta policía cuenda vehe ñuhu, catɨɨ̱n ra chi ra Jesús, ta chahñi̱ ra chi ra vatyi cuhun ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tyicuan ta chinyaca̱ ra chi ra vehe ra Anás, vatyi ra Anás cuan tyiso ra Caifás cuví chi ra. Ta cuiya cuan cuví ra Caifás ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ican ra Caifás ihya cuví ra cha catyi̱ chi ra cacuví nuu chi ñu Israel vatyi vaha ca cha cúvi noo ri rayɨɨ cha cuenda tandɨhɨ ñáyɨvɨ ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ra Simón Pedro ta nonga ra cha chica̱ noo chihin ra Jesús, canyicón ra chi ra Jesús nu cuahan ra nuquehe vehe ra Anás cuan. Ta ra cuvi̱ nuu chi tata sutu cuan ñohó nuu ra chi inga ra cuan. Yucuan chaha quɨhvɨ̱ ra cuan chihin ra Jesús nuquehe ra cuví nuu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Soco ra Pedro ndoo̱ ra yuvehe chata vehe. Yucuan chaha quita̱ ra cha ñohó nuu chi ra cuvi̱ nuu chi tata sutu cuan, ta caha̱n ra chihin ñaha cha nyaá yuvehe cuan. Ta tyihi̱ ra chi ra Pedro chichi nuquehe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tyicuan ta ñaha cha nyaá yuvehe cuan ndaca̱ tuhun ña chi ra Pedro, ta catyí ña: ―¿Atu ñima noo ra chica̱ noo chihin rayɨɨ cuan cuvún? Ta ra Pedro catyí ra: ―Ñime cuví ―catyí ra chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tyicuan ta musu ta policía cha tayucú yucuan, casanataha̱n ra ñuhu̱ vatyi vichin xaan. Ta tayucú ra casanasaá ra chi ra. Ta ñohó tucu ra Pedro cuan yunuhu cuan, sanasaá ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tyicuan ta ra cuvi̱ nuu chi tata sutu quichaha̱ ndaca tuhun ra chi ra Jesús, yóó ra cuví ra cachicá noo chihin ra, ta ñáá cha sañahá ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ta ra Jesús catyí ra chi ra: ―Yuhu chihin nuu tandɨhɨ ñáyɨvɨ cahín. Ta sañahi̱ chichi vehe ñuhu tahan tahan ñuu ta chichi vehe ñuhu cahnu ñuu ihya nu ndu ɨɨ́n ri tandɨhɨ ñu Israel. Ta ñahri tuhun xehe cahín. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ñáá tuhun cha ndacá tuhun chii? Vaha taxin ca nda̱ca tuhun chi ñu cha chiñi̱ tuhun cahi̱n, ta maa ñu nacatyi ñu ñáá tuhun cahi̱n chihin ñu. Maa ñu chitó ñu ñáá tuhun cahi̱n ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuhva cha catyí ra Jesús tuhun ihya, noo policía vehe ñuhu cha nanyaá cuan, cañi̱ ra noo nuu ra Jesús ta catyí ra: ―¿Atu tyiña caa nacahún nu cahán ra cuvi̱ nuu chi tata sutu? ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ta ra Jesús catyí ra: ―Tatu cahi̱n noo tuhun ña vaha, ca̱tyi chii nya maa maa ña vaha cahi̱n. Soco tatu cahi̱n tuhun vaha, ¿ñáá tuhun cha cañu̱n chii? ―catyí ra Jesús chi ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yaha̱ cuan ta nuhñí ra Jesús, ta tachi̱ ra Anás chi ra nu nyaá ra Caifás, ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ta ra Pedro nanyaá ca ra yunuhu cuan sanasaá ra chi ra. Ta catyi̱ ñu chi ra: ―¿Atu ñima noo ra chicá noo chihin ra cuan cuví yoho? ―catyí ñu chi ra. Ta ra Pedro tixehe̱ ra, ta catyí ra: ―Ñime. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tyicuan ta noo musu ra cuví nuu chi tata sutu, noo ra cha cuví ñáyɨvɨ chi ra cha chahnya̱ ra Pedro soho, quichaha̱ ndaca tuhun ra ta catyí ra: ―Ta caa cuiri tyi nyehi̱ chuun chihin ra chichi chacu cuan ―catyí ra chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta ra Pedro tixehe̱ ra inga chaha, ta caa cuhva ri cuan ta chacu̱ noo loho. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yaha̱ cuan ta quita̱ coyo ra chihin ra Jesús vehe ra Caifás ta chinyaca̱ ra chi ra vehe tyiño gobernador. Cha vachi cundichin ta ra Israel ña caquɨhvɨ̱ ra chichi vehe tyiño cuan vatyi ñima vehe ñu Israel cuví. Ta vatyi catyí ñu tyi yɨca cha quɨhvɨ̱ ñu vehe savahri vatyi coto ma cuvi cuxiñi ñu quɨvɨ vico pascua cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yucuan chaha quita̱ ra Pilato vatyi cahan ra chihin ra, ta catyi ra: ―¿Ñáá cuatyi tyaá ndo sɨquɨ ra ihya? ―catyí ra Pilato chi ra ñuu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ta canacaha̱n ra Israel ta catyí ra: ―Tyehe ta ñima noo ra iyó cuatyi cuví ra, ma nacuhva cuenda ndi chi ra chuun ―cacatyí ra chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tyicuan ta ra Pilato catyí ra chi ra: ―Que̱hen maa ndo chi ra, na cutuñi chi ra nuu maa ndo tari cuhva catyí ley maa ndo. Ta nacaha̱n ra ñuu Israel cuan ta cacatyí ra: ―Soco nyuhu ñu Israel ñahri ityi iyó chi ndi cha cahñi ndi chi ni noo ñáyɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tyicuan caa chino̱ cava cha catyi̱ ra Jesús yoso caa cucúvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tyicuan ta nandɨhvɨ̱ tucu ra Pilato chichi vehe tyiño cuan inga chaha. Ta cana̱ ra chi ra Jesús ta ndaca̱ tuhun ra chi ra: ―¿Atu yoho cuvún rey cuenda ñu Israel? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ta ra Jesús catyí ra: ―¿Atu cha cuenda maun ndaca tuhun, o inga ñu nacatyi̱ ñu tuhin chuun? ―catyí ra Jesús chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ta catyí ra Pilato: ―Ñima ra ñuu Israel cuví yuhu. Suri ra ñuu maun ta ra cuví nuu chi tata sutu ñuu maun cuví ra canacuhva̱ cuenda chuun chii. ¿Ñáá cha sacuvu̱n? ―catyí ra chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tyicuan ta nacaha̱n ra Jesús ta catyí ra: ―Nu nyacá ñahi ñima cuenda ñuhu ñayɨvɨ̱ ihya cuví. Tyehe ta ican, ra nyicón chii cañi tahan ra tacuhva ma cunyai ndaha ra Israel. Soco nu nyacá ñahi, ñima cuenda ihya cuví ―catyí ra Jesús chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tyicuan ta ra Pilato catyí ra chi ra: ―¿Tu tyicuan caa, rey cuvún vii? ―catyí ra Pilato chi ra Jesús. Ta nacaha̱n ra Jesús ta catyí ra: ―Rey cuví tari catyun chiña. Yucuan cuenda caqui̱ ta vachi ñuhu ñayɨvɨ̱ ihya, vatyi catyi ñáá cha cuví cha ndicha. Tandɨhɨ ñu quichaha cha ndicha, tyasohó ñu tuhun cahín ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ta ra Pilato catyí ra chi ra: ―¿Ta ñaá cha cuví cha ndicha? ―catyí ra. Cha yaha̱ cha ndaca̱ tuhun ra tuhun ihya, quita̱ ra Pilato chicaha̱n ra chihin ra Israel inga chaha ta catyí ra: ―Yuhu ña nañihi mai ni noo cuatyi ra ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Soco nyoho iyó noo costumbre chi ndo cha chican ndo na sañe chi noo ra ñohó vehe caa cha vico pascua ihya. ¿Atu cuñí ndo cha sañe chi ra cha cuví rey cuenda ndo ñu Israel? ―catyí ra Pilato chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tyicuan ta tandɨhɨ ra quichaha̱ canachaa ra ta catyí ra: ―¡Ma sañon chi ra chiña! ¡Chi ra Barrabás sa̱ñon! ―catyí ra. Ta ra Barrabás cuví ra noo ra suhu. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tyicuan ta quehe̱n ra Pilato chi ra Jesús ta tachi̱ ra na cucañi sɨndaro chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ta sɨndaro savaha̱ ra noo corona chihin iñu ta catyihi̱ ra xiñi ra Jesús. Ta sacuihno̱ ra chi ra chihin noo sahma tyacu nyaa tari cha tuhvá rey cañihnó. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tyicuan ta catuhva̱ ra nu nanyaá ra ta chacú nyaa ra chi ra, ta cacatyí ra: ―¡Nocumi chuun yoho Rey cuenda ñu Israel! ―cacatyí ra, ta cacatu̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tyicuan ta quita̱ tucu ra Pilato inga chaha ta catyí ra chi ra: ―Nye̱he ndo cuatave chi ra ityi nuu ndo tacuhva nanyehe ndo vatyi ni noo cuatyi ra ña nañihi̱ ―catyí ra Pilato chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ta quita̱ ra Jesús yɨhɨ́ corona iñu cuan xiñi ra, ta ñihnó ra sahma tyacu nyaa cuan. Tyicuan ta ra Pilato catyí ra chi ra: ―¡Ma ra ihya! ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cuhva cha cananyehe ra cacuví nuu chi tata sutu ta policía chi ra, quichaha̱ cacana chaa ra ta catyí ra: ―¡Ca̱hñi chi ra nu cruzi! ¡Ca̱hñi chi ra nu cruzi! ―cacatyí ra. Soco ra Pilato catyí ra chi ra: ―Que̱hen maa ndo chi ra ta ca̱hñi maa ndo chi ra nu cruzi. Vatyi yuhu ni noo cuatyi ra ña nañihí. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Soco nacaha̱n ra Israel cuan ta cacatyí ra: ―Iyó noo ley chi ndi, ta cuhva catyí ley ndi, cuñí chi cha cúvi ra vatyi nasahá ra Sehe Nyoo chi ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cha chiñi̱ ra Pilato tuhun ihya, nayuhví ca ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ta ndɨhvɨ̱ tucu ra inga chaha chichi vehe tyiño, ta ndaca̱ tuhun ra chi ra Jesús: ―¿Nya quita̱ yoho? ―catyí ra chi ra. Soco ra Jesús ñahri cha nacaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tyicuan ta ra Pilato catyí ra chi ra: ―¿Ñáá tuhun ña nacahún nu cahán yuhu? ¿Atu ña chitón vatyi ra cuví tyiño cuví ta iyó ityi chii cha tyai chuun nu cruzi, ta iyó tucu ityi chii cha sañe chuun? ―catyí ra Pilato chi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta nacaha̱n ra Jesús ta catyí ra: ―Tyehe ta ña chaha̱ Nyoo tyiño cuan chuun, ñahri ityi iyó chuun cha tachi tuñun chii. Yucuan chaha, ra cha cachaha̱ cuenda chii chuun, cahnu ca cuatyi ra ican saha yoho ―catyí ra Jesús chi ra Pilato. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nya cuhva cuan ta nducu̱ ra Pilato cuhva saña ra chi ra Jesús, soco ra Israel cacana̱ chaa ra sɨquɨ ra, ta catyí ra: ―¡Tatu sañon chi ra, ñima amigo rey cahnu cuví chuun! Vatyi tandɨhɨ ri ra cha catyí tyi rey cuví ra, ra xaan iñi chi rey cahnu cuví ra ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tyicuan ta cha chiñi̱ ra Pilato tuhun ihya, tachi̱ ra na quita ra Jesús ityi chata vehe. Ta chicunyaa̱ ra Pilato nu tyayu ra nu tuhvá ra sandaa cuatyi ñáyɨvɨ nu nañí chi Gabata chihin sahan hebreo, ta cuñí chi catyí: “Nu yɨhɨ́ yuu”. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta cuví chi noo quɨvɨ cha ni cumañi ca vico pascua, ñáá cuhva ora. Tyicuan ta ra Pilato catyí ra chi ra Israel cuan: ―¡Ma rey ndo chiña! ");
INSERT INTO mxtNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Soco maa ra Israel canachaa̱ ra ta cacatyí ra: ―¡Na cúvi ra! ¡Na cúvi ra! ¡Ca̱hñi chi ra nu cruzi! ―cacatyí ra. Ta ra Pilato catyí ra chi ra: ―¿Atu cahñi nu cruzi chi rey ndo? Soco ra cacuví nuu chi tata sutu cacatyí ra: ―Yori ca rey iyó. Noo tuhun ri ra César, cha cuví rey cahnu ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tyicuan ta ra Pilato chaha̱ cuenda ra chi ra Jesús chi ra na cunyaa ra nu cruzi. Ta quehe̱n sɨndaro chi ra, ta cuahan ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ta nyisó ra Jesús cruzi ra, cuahan ra noo nu nañí: “Yɨquɨ Xiñi Ndɨyɨ”. Ta chihin sahan hebreo nañí chi Gólgota. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ta yucuan catyaa̱ ra chi ra nu cruzi chihin clavu. Ta ɨɨn ri chihin ra catyaa̱ ra uvi ca ra. Noo ra tacaá ra noo nu cruzi ɨnchiyo xiin ra ta inga ra inga chiyo xiin ra. Ta ra Jesús tacaá ra mahñu. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ta ra Pilato tachi̱ ra tyiño na cunyaa letra xiñi cruzi cuan. Ta catyí chi tyehe caa: “Ra Jesús ra ñuu Nazaret, Rey cuenda ñu ñuu Israel.” ");
INSERT INTO mxtNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ta cuaha ñu Israel sacuaha̱ ñu tuhun cuan, vatyi yatyin ri ñuu ñu cuví nu chinanyaa̱ ra cruzi ra Jesús. Ta letra cuan nyaá chihin sahan hebreo, ta sahan griego, ta sahan latín. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yucuan chaha ra cacuví nuu chi tata sutu cacatyi̱ ra chi ra Pilato: ―Ma tyaun: “Rey cuenda ñu ñuu Israel”, vaha ca tyaun: “Ican ra ihya cha catyí vatyi rey cuenda ñu ñuu Israel cuví ra” ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Soco ra Pilato catyí ra: ―Noo cha yaha̱ tyai̱, nandoo maa tyicuan caa ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cha yaha̱ cha catyaa̱ sɨndaro cuan chi ra Jesús nu cruzi, canaquehe̱n ra sahma ra ta cha cumi tahan ra quehe̱n ra noo noo sahma ra. Ta ndoo̱ nonga sahma ra cha ña quicu̱ ñu. Noo ri savaha̱ ñu nyacua nya sɨquɨ ta nya yuvi. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ta sɨndaro cuan cacatyí ra chi ra tahan ra: ―Ma cahnya yo. Cu̱hun yo noo sɨhva, nyehe yo yóó chi tahán chi sahma cuan ―cacatyí ra. Tyicuan caa cuvi̱ tari cuhva catyí nu tutu Nyoo nu catyí chi tyehe caa: “Casacha̱ ra sahme ta chaha̱n ra noo sɨhva chihin chi, nyehe̱ ra yóó ra saha canaa.” Ta ican ihya casacuvi̱ sɨndaro cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ta chaha cruzi ra Jesús nanyaá sɨhɨ ra. Ta nanyaá tucu cuhu ña, ta cu María ñasɨhɨ ra Cleofas, ta cu María ñaha Magdala. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta nanyehe̱ ra Jesús chi sɨhɨ ra, nanyaá ña yatyin ri. Ta nanyehe̱ tucu ra chi ra cha chica̱ noo chihin ra, ra cha cuñí xaan ra chi. Ta catyí ra chi sɨhɨ ra: ―Ma sehun nanyaá chiña ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tyicuan ta catyí ra chi ra cha cuñí xaan ra chi: ―Ma sɨhun nanyaá chiña ―catyí ra chi ra. Ta nya quɨvɨ cuan ta naquehe̱n cuenda ra chi ña cuanuhu ña vehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cha yaha̱ tuhun ihya, cha nyehe̱ ra Jesús vatyi cha ndɨhɨ̱ tyiño saha ra. Tyicuan ta catyí ra: ―Ityi ndutya ―catyí ra. Ta chihin tuhun cuan nachino cava tuhun cha nyaá nu tutu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ta yucuan nanyaá noo quɨyɨ tyitú chihin vinagre. Tyicuan ta casatyii̱ ra chihin noo xixan ndutya iya cuan. Ta tyaa̱ ra noo nu soco yutun cha nañí hisopo, ta catyañaa̱ ra nya yuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chihi̱ ra Jesús ndutya cuan ta catyí ra: ―Cha iyó vaha tandɨhɨ vityin ―catyí ra. Tyicuan ta nacañi̱ noo ra xiñi ra ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Noo ri ca quɨvɨ cumañi ta cuvi quɨvɨ cahnu ca vico pascua cuan, ta ra cacuví nuu chi ñu Israel ña cuñí ra cha ndoo coño ñuhu cuan nu cruzi quɨvɨ nyitatú ñu, vatyi quɨvɨ nyitatú ñu quɨvɨ ii cuví. Yucuan chaha chica̱n ra tumañi iñi chi ra Pilato na tachi ra na cucahnu sɨndaro sɨhɨn ra cha catacoyo nu cruzi cuan tacuhva na cacúvi ra cha numi ri, ta cañehe ra coño ñuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tyicuan ta cuahan coyo sɨndaro nu tayucú cruzi cuan. Ta chahnu̱ ra sɨhɨn noo ra cha tacaá yucuan. Tyicuan ta chahnu̱ tucu ra sɨhɨn inga ra cha tacaa xiin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Soco cuhva cha cuatuhva ra nu tacaá ra Jesús, cananyehe̱ ra vatyi cha chihi̱ ra. Ta yucuan chaha ña cachahnu̱ ca ra sɨhɨn ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Soco suvita ri noo sɨndaro cuan quiñi̱ ra lanza yɨquɨ naha ra Jesús. Ta quita̱ nɨñɨ ta ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ra cha nacatyí tuhun ihya, noo ra cha nyehe̱ cuví ra. Ta cha ndicha cahán ra, vatyi maa ra chitó ra vatyi cha ndicha cahán ra, tacuhva nachino tucu iñi nyoho. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Vatyi tuhun ihya cuvi̱ chi tyehe caa tari cuhva catyí tuhun Nyoo nu catyí chi: “Ni noo yɨquɨ ra ta ma tahnu.” ");
INSERT INTO mxtNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta iyó nonga tucu nu catyí chi nu tutu Nyoo tyehe caa: “Cunyehe ñu chi ra cha quiñi̱ ra lanza chi.” ");
INSERT INTO mxtNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cha yaha̱ tuhun ihya, ra José ra ñuu Arimatea chica̱n ra chi ra Pilato nacuhva ra cha naquehen ra coño ñuhu ra Jesús. Ta ra José cuan cuví ra noo ra yɨhɨ́ cuenda ra Jesús vasɨ xehe ri cha cuenda cha yuhví ra chi ra cacuví nuu chi ñu Israel. Tyicuan ta chaha̱ ra Pilato permisu chi ra, ta ra José chaha̱n ra chinaquehe̱n ra coño ñuhu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chaha̱n tucu ra Nicodemo, ra cha chaha̱n chicaha̱n chihin ra Jesús cha cha cuaa. Chaa̱ ra chihin ndutya vixi chahán. Ta noo ndutya vixi chahán cha nañí mirra nasaca̱ ñu chihin inga cha nañí áloe. Ta quita̱ chi tari noo oco uchi kilu cha tandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yucuan ta ra José ta ra Nicodemo caquehe̱n ra coño ñuhu ra Jesús ta canasɨquɨ̱ noo ra chi ra chihin sahma cuɨñɨ cahyu̱ ra ndutya vixi chahán cuan, tari cuhva noo tuhun cha iyó chi ñu Israel tu cuatyihi ñu noo ndɨyɨ chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yatyin nu cachahñi̱ ra chi ra Jesús nu cruzi nyaá noo chacu yutun yucu vixi. Ta chichi chacu cuan nyaá noo ñaña chaa nu ta cohon ca ni noo ndɨyɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yucuan tyihi̱ ra coño ñuhu ra Jesús vatyi yatyin ri cuan nyaá ñaña cuan ta vatyi cha cua quichaha quɨvɨ nyitatú ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cha timingu cha ñaa ca, cu María ñaha Magdala cuan chaha̱n ña nu ñaña. Ta nyehe̱ ña tyi ñahri ca yuu nyasɨ́ yuhu ñaña cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tyicuan ta chinó vavaha ña cuahan ña nu nyaá ra Simón Pedro ta inga ra chica̱ noo chihin ra Jesús, ra cha cuñí xaan ra Jesús chi. Ta catyí ña chi ra: ―Quehe̱n ñáyɨvɨ coño ñuhu Sutu Mañi yo chichi ñaña, ta ña chitó yo nya chinyaca̱ ñu ―catyí cu María chi ra Pedro ta chi inga ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tyicuan ta ra Pedro ta inga ra cuan cuahan coyo ra nu ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nɨnduvi ra ɨɨn ri cuahan coyo ra cachino ra. Soco chino ca inga ra cuan ican saha ra Pedro, ta xihna ca ra chaa̱ nu ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Quichaha̱ nyehe ñihñi ra chichi ñaña, ta nyehe̱ ra sahma cuɨñɨ cha yɨhɨ̱ coño ñuhu ra Jesús, catuví cuan. Soco ña quɨhvɨ̱ ra chichi ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yaha̱ cuan ta chaa̱ ra Simón Pedro chata ra, ta quɨhvɨ̱ ra chichi ñaña cuan. Suri nyehe̱ tucu ra cuan sahma cuan catuví. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ta suri nyehe̱ tucu ra vatyi sahma cha sɨquɨ̱ noo xiñi ra Jesús, ña ɨɨn ri cayucú chihin inga sahma cuan, soco catuví sɨɨn. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tyicuan ta quɨhvɨ̱ tucu inga ra chica̱ noo chihin ra Jesús cuan, ra cha chaa̱ cha xihna ri nu ñaña cuan. Ta nyehe̱ ra cha cuvi̱ cuan, ta chino̱ iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vatyi cha cuvi̱ maa ta cutuñi ca iñi ra cha catyí nu tutu Nyoo, vatyi ra Jesús cuñí chi cha nandoto ra cha yaha̱ chihi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tyicuan ta ra cachica̱ noo chihin ra Jesús cuanuhu coyo ra nya vehe. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Soco cu María ndoo̱ ña chata yatyin ri yuhu ñaña, chacú chaa ña. Cha nɨri ca cha chacú ña, nyehé ñihñi ña chichi ñaña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ta nyehe̱ ña uvi tahan ángel ñihnó ra sahma cuichin, nyicú ra nu catuvi̱ coño ñuhu ra Jesús. Noo ra nyaá ityi nu catuvi̱ xiñi ra, ta nonga ra ityi nu catuvi̱ chaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ta ángel cuan ndaca̱ tuhun ra chi ña ta catyí ra: ―Maha, ¿ñáá tuhun chacú chaun? Ta catyí ña: ―Vatyi quehe̱n ñu chi Sutu Mañi yuhu, ta ña chité nya tyihi̱ ñu chi ra ―catyí ña chi ángel cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ni cahán ña tuhun ihya ta nanyocava̱ ña ta nanyehe̱ ña chi ra Jesús yucuan. Soco ña chitó ña cha ra Jesús cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tyicuan ta ra Jesús ndaca̱ tuhun ra chi ña: ―¿Ñáá tuhun chacún? ¿Yóó chi nanducún? ―catyí ra chi ña. Cuñí maa ña vatyi ra sahá cumi chacu cuan cuví ra. Ta catyí ña: ―Tata, tatu yoho quehu̱n chi ra Jesús, ca̱tyi chii nya sandou̱n chi ra, vatyi naquehin chi ra ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tyicuan ta catyí ra Jesús chi ña: ―¡María! ―catyí ra chi ña. Maa ña nanyehe̱ ña ta caha̱n ña chihin ra chihin sahan hebreo, ta catyí ña: ―¡Raboni! ―Ta cuñí chi catyí: “Maestro”. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ta catyí ra Jesús chi ña: ―Ma tɨun chii, vatyi ta nandaa que nu nyaá Suti. Soco cua̱han ta ca̱tyun chi tandɨhɨ yañi vatyi cuahin nu nyaá Suti, ta suri Sutu ndo cuví chi ra. Cuahin nu nyaá Nyoi, ta suri Nyoo ndo cuví chi ra ―catyí ra Jesús chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tyicuan ta chaha̱n cu María ñaha Magdala cuan chisacoto̱ ña chi ra cachica̱ noo chihin ra Jesús vatyi nyehe̱ ña chi ra Jesús ta catyi̱ ra tuhun cuan chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Suri maa quɨvɨ cuan cha quichaha vitya, cha cuacuaa ta candu ɨɨ̱n ri ra cachica̱ noo chihin ra Jesús. Ta nyasɨ́ vaha yuvehe nu nyicú ra cha cuenda cha yuhví ra chi ra cacuví nuu chi ñu Israel. Ta ra Jesús tuvi̱ ra ta chicuinanyaa̱ ra mahñu. Ta chaha̱ ra nocumi chi ra, ta catyí ra: ―Na coo cha taxi ri añima ndo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cha yaha̱ cha catyi̱ ra tuhun ihya ta sañaha̱ ra ndaha ra ta yɨquɨ naha ra. Ta maa ra cacusɨɨ cuñi ra cha nanyehé ra chi Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ta catyí tucu ra Jesús inga chaha chi ra: ―Na coo cha taxi ri añima ndo. Tari tachi̱ Suti tyiño chii, tyicuan caa tachí tyiño chi nyoho ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tyicuan ta tɨvɨ̱ ra sɨquɨ ra ta catyí ra chi ra: ―Na̱quehen ndo Tatyi Ii Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ñu cha sahá ndo tucahnu iñi chi, iyó tucahnu iñi chi ñu. Ta ñu cha ña sahá ndo tucahnu iñi chi, ñahri tucahnu iñi iyó chi ñu ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Soco ra Tomás, noo ra chica̱ noo chihin ra Jesús, ra cha catyí ñu: “ra tɨnɨhɨ”, yori ra nyaá chihin ra cuhva cha quichi̱ ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yaha̱ cuan ta canacatyi̱ ra cachica̱ noo chihin ra Jesús chi ra: ―Nyehe̱ ndi chi Sutu Mañi yo ―cacatyí ra chi ra. Soco ra Tomás catyí ra: ―Tatu ma nyehi ndaha ra nu cahví nu yɨhɨ̱ clavu, ta tatu ma tyihi ndahi nu yɨhɨ̱ clavu cuan, ta tatu ma tyihi ndahi yɨquɨ naha ra, ma chino iñi ―catyí ra Tomás. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uña quɨvɨ yaha̱ ta canyicú tucu ra cachica̱ noo chihin ra Jesús noo vehe. Ta nyaá ra Tomás chihin ra. Tyicuan ta vasɨ nyasɨ́ vaha yuvehe soco quɨhvɨ̱ ra Jesús ta chicuinanyaa̱ ra mahñu ra. Ta chaha̱ ra nocumi ta catyí ra: ―Na coo cha taxi ri añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tyicuan ta quichaha catyí ra chi ra Tomás: ―Tyi̱hi nu ndahun nu cahví ndahi. Ta tyi̱hi ndahun yɨquɨ nahi. Ta ma caca uvi iñun, soco chi̱no iñun ―catyí ra Jesús chi ra Tomás. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tyicuan ta nacaha̱n ra Tomás ta catyí ra: ―¡Sutu Mañi yuhu! ¡Nyoo Suti cuví chuun! ―catyí ra Tomás. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ta catyí ra Jesús chi ra: ―Yoho Tomás, vityin chinó iñun tyi nyehún chi. Sɨɨ ca cuñí ñu cha ña nyehe̱ ta chinó iñi ñu ―catyí ra Jesús chi ra Tomás. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ta cuaha ca milagru sacuvi̱ ra Jesús nuu ra cachica̱ noo chihin ra, ta ñahri chicunyaa nu libru ihya. ");
INSERT INTO mxtNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Soco chicunyaa̱ tuhun ihya vatyi tacuhva chino iñi ndo vatyi ra Jesús cuví Cristo, ra cuví Sehe Nyoo, ta vatyi coo ndo ñayɨvɨ̱ cha ma naa ca maa tatu chinó iñi ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cha yaha̱ cuan ta tuvi̱ tucu ra Jesús nuu ra cachica̱ noo chihin ra inga chaha. Tyehe caa tuvi̱ ra yuhu miñi Tiberias. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ɨɨn ri nyicú ra Simón Pedro ta ra Tomás cha catyi ñu: “ra tɨnɨhɨ” chi, ta ra Natanael, ra ñuu Caná nu cuví Galilea. Nyicú tucu sehe ra Zebedeo ta uvi ca ra cachica̱ noo chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ta catyí ra Simón Pedro chi ra: ―Cuahin cuatɨin tiyaca ―catyí ra. Ta cacatyí ra chi ra: ―Cuhun tucu nyuhu chuhun ―cacatyí ra. Cuahan coyo ra ta quɨhvɨ̱ coyo ra chichi noo canoa, soco cha cuaa cuan ni noo tiyaca ña catɨɨ̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cha vachi cundichin cuan tuvi̱ ra Jesús nu ñɨtɨ yuhu miñi cuan. Soco ra cachica̱ noo chihin ra, ña canɨcohón nuu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tyicuan ta catyí ra chi ra: ―Yoho ra tahan yo, ¿atu ta ñihi ca ndo tiyaca? Ta canacaha̱n ra ta catyí ra: ―Ta ñihi ca ndi. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tyicuan ta nacaha̱n ra Jesús ta catyí ra: ―Tyi̱hi ndo tarraya chiyo vaha canoa chiña, ta ñihi ndo ―catyí ra Jesús chi ra. Tyicuan caa casacuvi̱ ra, ta yaha cuan ta nyacua ña cuvi̱ tava ra tarraya cuan nu ndutya chaha cha cuaha tiyaca yɨhɨ́. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ta ra cha cuñí xaan ra Jesús chii catyí ra chi ra Pedro: ―¡Sutu Mañi yo cuví! ―catyí ra chi ra Pedro. Cha chiñi̱ ra Simón Pedro vatyi Sutu Mañi yo cuví, ndɨhvɨ̱ noo ra sahma ra, vatyi tava̱ ra cha cuatɨɨn ra tiyaca, ta quiñi ra cuahan ra chichi ndutya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ta inga ra cachica̱ noo chihin ra Jesús chaa̱ coyo ra nya yuhu miñi cuan chihin canoa, caxitá ra tarraya cuan tyitú yɨhɨ́ tiyaca, vatyi yatyin ri yuhu miñi cuan cañohó ra ta cha noo cientu metru ri. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuhva cha canoó ra nu ñuhú, cananyehe̱ ra noo nu caá tɨtɨ ñuhu̱. Ta catuví noo tiyaca sɨquɨ tɨtɨ ñuhu̱ cuan, ta pan ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ta ra Jesús catyí ra chi ra: ―Nya̱ca ndo suhva tiyaca cha ni tɨɨ̱n ndo ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ta ra Simón Pedro ndaa̱ ra nu canoa ta quichaha̱ xita quiñoho ra tarraya tyitú yɨhɨ́ tiyaca nahnu. Cientu uvi xico uchi uñi tahan tɨ ñohó. Ta vasɨ cuaha tɨ, ña tahnya̱ tarraya cuan. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tyicuan ta catyí ra Jesús chi ra: ―Ña̱ha ndo ta curumusa ndo ―catyí ra Jesús chi ra. Ta ni noo ra cachica̱ noo chihin ra ña cacaña̱ iñi ra candaca tuhun ra yóó ra cuví ra vatyi cachitó ra vatyi Sutu Mañi yo cuví ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tyicuan ta tuhva̱ ra Jesús ta quehe̱n ra pan, ta chaha̱ ra chi ra. Ta suri tyicuan caa sacuvi̱ ra chihin tiyaca. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ican ihya cuví chaha cu uñi cha tuvi̱ ra Jesús nuu ra cachica̱ noo chihin ra cha yaha̱ cha nandoto̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cha yaha̱ cha curumusa ra Jesús, ndaca̱ tuhun ra chi ra Simón Pedro: ―Simón, sehe ra Jonás, ¿atu cuñí con chii ican saha ra ihya? Ta nacaha̱n ra Pedro ta catyí ra: ―Ay, Sutu Mañi yuhu, maun chitón tyi cuñí chuun ―catyí ra Pedro. Ta catyí ra Jesús chi ra: ―Cu̱hva cha cachi mbee nyihi sane ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ta ndaca̱ tuhun ra Jesús chi ra inga chaha: ―Simón sehe ra Jonás, ¿atu cuñún chii? ―catyí ra Jesús chi ra. Ta nacaha̱n ra Pedro ta catyí ra: ―Sutu Mañi yuhu, maun chitón tyi cuñí chuun ―catyí ra Pedro chi ra. Ta catyí ra chi ra: ―Sa̱ha cumi mbee sane ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta chaha cu uñi ndaca̱ tuhun ra chi ra: ―Simón Pedro, sehe ra Jonás, ¿atu cuñun chii? ―catyí ra Jesús chi ra. Cuhva cha ndaca̱ tuhun ra chi ra cha cu uñi chaha tatu cuñí ra chi ra, ra Pedro nducuihya iñi ra, ta catyí ra chi ra: ―Sutu Mañi yuhu, maun chitón yoso caa añime ta maun chitón tyi cuñí chuun ―catyí ra Pedro. Ta ra Jesús catyí ra chi ra: ―Sa̱ha cuenda mbee sane. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cha ndicha catyí chuun vatyi ta tyivaun ndɨhvɨ̱ noun sahmon ta chahu̱n nu cuñún. Soco na cuchahnun, cusanacaun ndahun ta inga ra cusandɨhvɨ noo chuun. Ta cunyaca ra chuun nu ña cuñún cuhun ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Cha catyí ra Jesús tuhun ihya cuñí ra catyi ra yoso caa cucúvi ra Pedro ta cusacahnu ra chi Nyoo cha cuenda cuan. Yaha̱ cuan ta catyí ra Jesús chi ra Pedro: ―¡Cu̱nyicon chii! ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tyicuan ta nyocava̱ ra Pedro ta nanyehe̱ ra vatyi nyicón inga ra cha chica̱ noo chihin ra Jesús, ra cha cuñí xaan ra Jesús chi. Suri maa ra chinyañaa̱ ra chi ra Jesús cha cuxiñi ra quɨvɨ cuan. Ta ndaca̱ tuhun ra ta catyí ra: “Sutu Mañi yuhu, ¿yóó ra cunaxico tuhun chuun?” catyi̱ ra, ndaca̱ tuhun ra quɨvɨ cha ni cumañi cúvi ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cuhva cha nanyehe̱ ra Pedro chi ra, ndaca̱ tuhun ra chi ra Jesús: ―Sutu Mañi yuhu, ta ra ihya, ¿ñáá cha cucuvi chi ra? ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nacaha̱n ra Jesús ta catyí ra: ―Tatu cuñí mai cha coo ra nyacua nya ndichi inga chaha, ¿ñáá cha cuenda yoho? Yoho cu̱nyicon chii ―catyí ra Jesús chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tyicuan ta chitya̱ tuhun ihya nu canyicú yañi yo vatyi ra cuan, ma cúvi ra. Soco ña catyi̱ ra Jesús cha ma cúvi ra. Catyí ra: “Tatu cuñí yuhu cha coo ra nyacua nya quichi inga chaha, ¿ñáá cha cuenda yoho?” ");
INSERT INTO mxtNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yuhu cuví ra yucuan, ra cha cahán ra Jesús tuhun. Ta nyehi̱ tandɨhɨ cuii maa cha cuvi̱ ta tyai̱ nu libru ihya. Yuhu chite vatyi tandɨhɨ cha tyai̱, ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iyó cuaha ca cha sacuvi̱ ra Jesús. Tyehe ta chicunyaa̱ tahan tahan tuhun cuan nu libru, cahví iñi tyi nanɨɨ ñuhu ñayɨvɨ̱ ma cutahan tandɨhɨ libru cuan.");
INSERT INTO mxtNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yoho Teófilo, yuhu ra Lucas sacuhi̱n tutu chuun quɨvɨ cuan. Ta nu sacuhín tutu cha xihna ri cuan, tyai̱ tandɨhɨ cha quichaha̱ sacuvi ra Jesús ta tandɨhɨ cha sañaha̱ ra nya quɨvɨ xihna ri ");
INSERT INTO mxtNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ta nya quɨvɨ nandaa̱ xica ra andɨvɨ. Ta cha cumañi ca nandaa ra andɨvɨ, nacachi̱ ra chi ra apóstol cuenda ra. Ta tyatyiño̱ ra chi ra chihin Tatyi Ii Nyoo tyi cacaca ra tyiño ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ta maa ra Jesús nyehe̱ ra tɨndoho ta chihi̱ ra. Ta cha yaha̱ cuan, nandoto̱ ra ta tuvi̱ ra nu canyicú ra apóstol. Ta chichi cha uvi xico quɨvɨ, cuaha xaan chaha tuvi̱ ra nu canyicú ra, vatyi na cacoto ra vatyi ndicha cha nyitó ra. Ta caha̱n ra tuhun yoso caa nyacá ñaha Nyoo chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cuhva cha nyaá ca ra chihin ra, ra Jesús catyí ra chi ra: ―Ma quita ndo Jerusalén ihya, nyacua nya naquehen ndo Tatyi Ii cha catyi̱ Suti tyi cuhva ra chi ndo, tari catyi̱ chi ndo quɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chihin ndutya sacondutya̱ ra Juan chi ñáyɨvɨ. Soco nyoho ña cuaha ca quɨvɨ ta cucondutya ndo chihin Tatyi Ii ―catyí ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cuhva cha canyicú ra apóstol ɨɨn ri chihin ra Jesús, ta candaca̱ tuhun ra chi ra: ―Sutu Mañi yuhu, ¿atu vityin ri cusacacun chi ñuu yo Israel ihya ndaha ra ñuu Roma? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ta nacaha̱n ra Jesús ta catyí ra: ―Ña tahán chi coto nyoho nya quɨvɨ. Noo tuhun ri maa Nyoo Sutu yo cuacatyi ra ama. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Soco cuhva cha quichi Tatyi Ii sɨquɨ ndo cunaquehen ndo tunyee iñi, ta cuquita ndo vatyi cahan ndo tuhin Jerusalén ihya ta tandɨhɨ ñuu cha nyicú Judea ta Samaria, ta nɨcahnu ñuhu ñayɨvɨ̱. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ta cha yaha̱ cha catyi̱ ra Jesús tuhun ihya, ta cha nɨ ri ca cha canyehé ra chi ra, nandaa̱ xica ra andɨvɨ, ta quɨhvɨ̱ ra chichi noo vico. Ta ña canyehe̱ ca ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ta cuhva cha canyehé ndaa ra andɨvɨ, ta tuvi̱ uvi tahan ángel yatyin nu canyicú ra. Ñihnó ra sahma cuichin. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ta cacatyí ra cuan chi ra: ―Nyoho ra Galilea, ¿ñáá tuhun cha ndoo̱ ndo nyehé ndaa ndo andɨvɨ? Suri maa ra Jesús cha nyehe̱ ndo nandaa̱ xica ihya, tyehe caa cuquichi tucu ra inga chaha. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tyicuan ta quita̱ coyo ra apóstol nu chinyicu̱ ra yucu nu iyó yutun olivo cuan. Ta cuanuhú coyo ra ñuu Jerusalén. Ta yatyin ri nyaá ñuu cuan, tari sava hora ri. Ta sava ri hora cuví caca ñáyɨvɨ quɨvɨ nyitatú ñu, vatyi tyicuan caa catyí ley cha tyaa̱ ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuhva cha nachaa̱ coyo ra Jerusalén cuan, candaa̱ ra nu cu uvi piso noo vehe nu ca iyó ra. Ta tandɨhɨ ra cuan, ican ra cuví, ra Pedro, ra Jacobo, ra Juan, ra Andrés, ra Felipe, ra Tomás, ra Bartolomé, ra Mateo, ra Jacobo sehe ra Alfeo, ta ra Simón cuenda ra cacuñí naquɨquɨ sɨquɨ gobiernu Roma, ta ra Judas yañi ra Jacobo. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ta nyita ri ndu ɨɨ́n ri ra ta ɨɨn ri cuhva cachicá xiñi ra ta cachicán tahvi ra chi Nyoo. Ta nyicú tucu yañi ra Jesús ta cu María sɨhɨ ra, ta inga ñusɨhɨ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tari noo ciento oco ñáyɨvɨ ndu ɨɨ́n ri ñu quɨvɨ cuan. Ta nicuinanyaa̱ ra Pedro. Ta catyí ra chi ñu: ");
INSERT INTO mxtNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nyoho yañi, cuñi̱ chi cha cuvi̱ tari cuhva catyí nu tutu Nyoo. Vatyi caha̱n Tatyi Ii chihin yuhu ra David yoso caa cucuhva cuenda ra Judas chi ra Jesús chi ra xaan iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ta ra Judas cuvi̱ ra noo ra chindɨhɨ̱ chihin yo. Ta ɨɨn ri chica̱ ra tyiño Sutu Mañi yo chihin yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Soco chaha̱n ra, ta sata̱ ra noo ñuhú chihin xuhun cha ñihi̱ ra cha chaha̱ cuenda ra chi ra Jesús. Yaha̱ cuan ta canacava̱ ra chihin xiñi ra, ta ndata̱ chichi ra ta quita̱ tandɨhɨ chɨtɨ yɨhvɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ta quɨvɨ cha cachito̱ ñu ca iyó Jerusalén ihya cha chihi̱ ra, casacunañi̱ ñu chi ñuhu cuan Acéldama. Ta cha chihin sahan maa ñu cuñí chi catyí Nu Catuvi Nɨñɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Vatyi nu libru Salmo catyí chi tuhun ra Judas tyehe caa: Na ndoo maa ri maa vehe ra. Ta yori coo chichi. Ta catyí tucu chi: Inga ra cunanduvi tyiño nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Ta vityin nyicú ra cachica̱ noo chihin yo quɨvɨ chinyaa̱ Sutu Mañi yo Jesús chihin yo; nya quɨvɨ sacondutya̱ ra Juan chi ra, ta nya quɨvɨ nandaa̱ xica ra andɨvɨ. Ta vityin cuñí chi cha ndu ɨɨn ri noo ra chihin yo, vatyi cuvi ra cha ndaa cha cuenda cha nandoto̱ ra Cristo ―catyí ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tyicuan ta cacana̱ ra chi uvi tahan ra, chi ra José cha nañi Barsabás, ta suri nañí tucu ra Justo; ta cacana̱ tucu ra chi ra Matías. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ta cachica̱n tahvi ra tyehe caa: ―Sutu Mañi yuhu, yoho chitón cha caa añima tandɨhɨ ndi. Sa̱ñaha chi ndi chichi cha uvi tahan ra ihya, nya ra cha nacachi̱ maun, ");
INSERT INTO mxtNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","vatyi sacuvi ra tyiño cha sacunaa̱ ra Judas cha cuenda cuatyi ra, ta cuaha̱n ra nu tahán chi cuhun ra ―cacatyí ra, chicán tahvi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tyicuan ta cachaha̱n ra noo sɨhva, tacuhva nyehe ra nya ra tahán chi nyatu cuan chi. Ta taha̱n chi chi ra Matías. Ta yucuan cuví nu ndu ɨɨ̱n ri ra chihin ndɨ uchi ɨɨn apóstol. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ta ɨɨn ri nyicú ñáyɨvɨ yɨhɨ́ cuenda ra Jesús ta chaa̱ quɨvɨ vico Pentecostés cha sanducahnú ñáyɨvɨ Israel. Ta ɨɨn ri cuhva chicá xiñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ta sana iñi ñu ta nacuɨñɨ̱ ñu noo cha cayu vachi ityi andɨvɨ. Tari cha cayu yahá noo tatyi ñihi. Ta iyo cuví tandɨhɨ chichí vehe nu canyicú ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tyicuan ta tuvi̱ tari yaa ñuhu̱ quɨtɨ̱ cuatyi sɨquɨ noo noo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ta tandɨhɨ ñu chitu ñu chihin Tatyi Ii. Ta quichaha̱ cahan ñu inga sahan yoso cuhva saquehen ityi maa Tatyi Ii chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta quɨvɨ cuan cuaha xaan ra Israel ra vaha chicá chihin Nyoo canyicú ra ñuu Jerusalén cuan. Cuaha xaan ra ca iyó inga ityi nɨcahnu sɨquɨ ñuhú ñayɨvɨ̱ chaa̱ coyo vatyi casanducahnu ra vico Pentecostés. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ta cha cachiñi̱ ra cuan cha iyo xaan cuví nu canyicú ñu, ta cuahan coyo ra ta nataca̱ ra yatyin ri nu nyicú ñu. Ta ña cutuñí iñi ra ñáá cha cuví cuan, vatyi noo noo ra cachiñí ra cahán ñu cuhva sahan cha cacahán maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyo cuñí ra ta catyí ra chi ra tahan ra: ―¿Atu ñima ñu Galilea cuví tandɨhɨ ñu cha cahán ihya? ");
INSERT INTO mxtNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ñáá tuhun cha chiñí yo cahán ñu cuhva sahan noo noo yo? ");
INSERT INTO mxtNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ihya nyicú yo cha cuví yo ñu Partia, ta ñu Media, ta ñu Elam, ta ñu Mesopotamia, ta ñu Judea, ta ñu Capadocia, ta ñu Ponto, ta ñu Asia. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ta ñu Frigia ta ñu Panfilia, ta ñu Egipto, ta ñu iyó ityi nuu ca Cirene ityi Africa. Ta nyicú tucu ñu ñuu Roma cha iyó ñuu ihya. Ta suhva ñu cuví ñu ñu Israel nya quɨvɨ cacu̱ ñu. Ta inga ñu cuví ñu ñáyɨvɨ nanduvi̱ cuenda ñu Israel ta nyicon ñu ley ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iyó tucu ñáyɨvɨ ñuhú Creta ta ñu Arabia. Soco tandɨhɨ yo ta chiñí yo cahán ñu chihin sahan cha cahán yo. Ta nacatyí ñu cha cahnu cha sacuví Nyoo ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tandɨhɨ ra, iyo xaan cacuñí ra, ta yɨhɨ́ ra ndacá tuhun ra chi tahan ra: ―¿Ñáá cha cuñí chi catyí chi tandɨhɨ tuhun ihya? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Soco inga ra cahán nyaa ra ta cacatyí ra vatyi cachiñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tyicuan ta nicuinanyaa̱ ra Pedro chihin inga uchi ɨɨn tahan apóstol. Ta chihin cha chaa caha̱n ra ta catyí ra: ―Nyoho yañi, cha cuví ndo ra Israel, ta tandɨhɨ nyoho cha iyó ndo Jerusalén ihya. Co̱to ndo tuhun ihya. Ta cuɨ̱ñɨ vaha ndo tuhun cha cuacatyi chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Vatyi cuñí maa ndo tyi chiñí ndi. Soco ña chiñí ndi, vatyi ña tuhvá ñáyɨvɨ chiñi cha cuhva ihya, vatyi ni ca ɨɨn cha ñaha ri cuví. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Soco ihya cuví tuhun cha caha̱n ra Joel, ra cuvi̱ profeta Nyoo ta cha naha. Vatyi catyi̱ ra: ");
INSERT INTO mxtNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nu cuandɨhɨ ca quɨvɨ, catyí Nyoo, cusaquichi Tatyi Ii sɨquɨ tandɨhɨ ñáyɨvɨ. Ta cucahan sehe ndo cuende. Ta ra tyivaa ta ñu tyivaa cunyehe ñu cha sañaha Nyoo chi ñu. Ta ra chahnu cunyehe ra ñumahna. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Cusaquichi Tatyi Ii sɨquɨ ñu sacuví tyiño nui. Ta cucahan ñu cuende, catyí Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta catyi ra vatyi cusañaha ra cha iyo cucuvi ityi andɨvɨ. Ta ityi nu ñuhu ñayɨvɨ̱ cusañaha ra seña, seña nɨñɨ, seña ñuhu̱, ta vico ñuhma. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cunduñaa ñanyii. Ta yoo tari caa tyacu nɨñɨ cunanduvi. Tyicuan caa cucuvi cha nɨri ca cha chaá quɨvɨ quichi Sutu Mañi yo. Ta cucuvi noo quɨvɨ cahnu vatyi cucutuñi chi yo nuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta tandɨhɨ ñu chicán tahvi sɨvɨ ra cucacu ñu. Tyicuan caa catyi̱ ra Joel. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Cuɨ̱ñɨ ndo nyoho ra Israel. Cuɨ̱ñɨ ndo tuhun cha cuacatyi ihya. Ra Jesús ra Nazaret cuví ra noo ra cha cachi̱ Nyoo chi vatyi quichi ra nu nyicu yo. Ta chitó yo vatyi ndicha vatyi cuaha xaan cha iyo, ta cuaha xaan milagru ta seña sacuvi̱ Nyoo nu canyicú yo cha cuenda ra Jesús. Ta nyoho chitó vaha ndo tuhun ihya. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Soco quɨvɨ quehe̱n cuenda ndo chi ra, sacuvi̱ ndo tari cuhva tyaa̱ maa Nyoo cuhva nyata quɨvɨ xihna ri. Vatyi chaha̱ cuenda ndo chi ra chi ra quiñi iyó. Ta chitacaa̱ ra chi ra nu cruzi. Ta tyicuan caa chahñi̱ ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Soco Nyoo sanandoto̱ ra chi ra vatyi sacacu̱ ra chi ra ndaha tuhun chihi. Vatyi tuhun chihi ña cuví cunyaca ñaha chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Vatyi ra David caha̱n ra tuhun ra Cristo ta cha naha, ta catyí ra: Tyicuan ri nyehí chi Sutu Mañi yo ityi nui. Maa ra nyaá ɨɨn chiyo vahi ta ñahri maa cha cuví sayuhvi chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yucuan chaha cusɨɨ xaan cuñí añime. Ta chité yaa chihin cha sɨɨ cuñí. Ta sɨɨn ri coño ñuhi cunyitatu chi vatyi chité tyi cunandote. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Vatyi yoho Nyoo Suti, ma sandoun añime nu nyicu ñu chihi, ta ni ma cuhvon cha tyahyu coño ñuhi. Vatyi sehe iun cuví chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sañahún ityi cha cuahán nu coi ñayɨvɨ̱ chaa cha ma naa ca maa. Ta sacutún chii chihin tusɨɨ iñi vatyi nyaún chihin, catyí ra David ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nyoho yañi, chitó cachi yo vatyi ra David sutu chahnu yo chihi̱ ra ta quɨhvɨ̱ ra chichi ñuhu. Ta ñaña ra nyaá ca chi ihya nya vityin. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Soco ra David cuvi̱ ra noo profeta cuenda Nyoo. Ta chitó ra vatyi Nyoo tyaa̱ ra cuhva ta ɨɨn ri tuhun cahan ra chihin ra vatyi suri tata maa ra ican cuacacu ra Cristo. Ta ra Cristo, ican ra cunyaca ñaha. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta tyicuan caa ra David tari cha vatyi nyehe̱ ra cha cuacuvi nu cuahan ca chi quɨvɨ. Ta caha̱n ra tuhun cha cunandoto ra Cristo. Ta catyi̱ ra vatyi ma ndoo añima ra nu nyicu ñu chihi̱. Ta ni ma tyahyu coño ñuhu ra, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ta ra Jesús ihya sanandoto̱ Nyoo chi ra. Ta tuhun ihya tandɨhɨ maa ndi cuví ndi cha ndaa. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyoo sacahnú ra chi ra Jesús, ta cuatyaa̱ ra chi ra chiyo vaha ra andɨvɨ. Ta ra Jesús naquehe̱n cuenda ra Tatyi Ii cha catyi̱ Sutu yo Nyoo ta cha naha vatyi cuhva ra chi yo. Ta ican cuví cha chahá ra chi ndi vityin. Ican cuví nyehé ndo ta chiñí ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Vatyi ñima ra David nandaa̱ ra andɨvɨ. Vatyi suri maa ra David caha̱n ra tuhun ra Jesús, ta catyí ra: Catyí Suti Nyoo chi Suti ra Cristo: “Cu̱nyaa chiyo vahi ");
INSERT INTO mxtNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","cha nɨri ca cha caquin chi ra xaan iñi chuun chahun”, catyi Nyoo chi ra Cristo chihin yuhu ra David. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nyoho ta tandɨhɨ ca ñu Israel, co̱to vaha ndo vatyi tuhun ra Jesús ican cahín ihya. Chitacaa̱ ndo chi ra nu cruzi. Soco Nyoo cuatyaa̱ ra chi ra tyi cuvi ra Sutu Mañi yo, ra nyaca ñaha chi yo ―catyí ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuhva cha chiñi̱ ñu tuhun caha̱n ra Pedro ihya, nducuihya̱ iñi ñu. Ta ndaca̱ tuhun ñu chi ra Pedro ta chi tandɨhɨ ca ra apóstol, ta catyi ñu: ―Nyoho yañi, ¿yoso caa sacuví ndi vityin? ―catyí ñu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yucuan ta catyí ra Pedro chi ñu: ―Noo noo ndo ndu̱ uvi iñi ndo cuatyi ndo ta na̱sama ndo cuhva iyó ndo nuu Nyoo. Ta co̱ndutya ndo chihin sɨvɨ ra Jesucristo. Tacuhva na saha ra tɨcahnu iñi cuatyi ndo. Tyicuan caa ta cua cuhva Nyoo Tatyi Ii ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Vatyi cha naha catyi̱ Nyoo vatyi cuhva ra Tatyi Ii ra chi maa ndo, ta chi sehe ndo, ta chi ñu cha cañi nyaa ñandɨhɨ. Vatyi tandɨhɨ ñu cha nacana̱ Sutu Mañi yo Nyoo chii cucuhva ra Tatyi Ii ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chihin tuhun ihya ta chihin inga tuhun, ra Pedro chahá ra tuhun chi ñu ta catyí ra chi ñu: ―Ndu̱cu ndo cuhva na sacacu Nyoo chi ndo, tacuhva cuví sandoo ndo cha caa ñáyɨvɨ quiñi iyó ihya ―catyí ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tyicuan ta tandɨhɨ ñu cha natɨɨ̱n cuenda tuhun caha̱n ra Pedro condutya̱ ñu. Ta quita tari noo uñi mil ñu, ta ndu ɨɨn ri ñu chihin ñu yɨhɨ́ cuenda ra Jesucristo. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ta tyicuan ri ndu ɨɨn ri tandɨhɨ ñu, ta chihin cha nɨɨ iñi ñu tyasoho ñu cha sañahá ra apóstol chi ñu. Ta ɨɨn ri cuví ñu chihin tahan ñu, ta chicán tahvi ñu ta chachí ñu pan ta chihí ñu vinu vatyi nɨcohón iñi ñu tyi chihi̱ ra Cristo tyiño nuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta cuaha milagru ta seña sacuvi̱ Nyoo chihin ndaha ra apóstol. Ta tandɨhɨ maa ñáyɨvɨ iyo cuñí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tandɨhɨ ñu yɨhɨ́ cuenda ra Cristo ɨɨn ri cacuví ñu chihin cha iyó chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xicó ñu cha tyayɨɨ ñu ta cha iyó chi ñu. Ta sachá ñu xuhun ñu chi tahan ñu yoso cuhva cha chiñuhú chi noo noo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ndɨquɨvɨ ta ndu ɨɨ́n ri ñu nya vehe ñuhu cahnu. Ta ndu ɨɨ́n tucu ri ñu noo noo vehe tahan ñu ta chachí ñu pan ta chihí ñu vinu. Ta ɨɨn ri cachachí ñu chihin cha sɨɨ cuñí añima ñu. Ta chahá ñu cha cachi tahan ñu chihin cha nɨɨ iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ta sacahnú ñu chi Nyoo. Ta vaha cahán tandɨhɨ ñáyɨvɨ sɨquɨ ñu. Ta tahan tahan quɨvɨ cuahan sanducuahá ca Sutu Mañi yo chi ñu cha cuahán sacacu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Noo quɨvɨ cuahán coyo ra Pedro chihin ra Juan vehe ñuhu cahnu. Cuví chi cuhva caa uñi cha cha iñi, cuhva cha tuhvá ñáyɨvɨ Israel cachicán tahvi ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta ndɨ quɨvɨ maa nyaá noo ra ndahvi, ra coxo nyata cacu̱, yuvehe ñuhu cahnu cuan. Vatyi chinyacá ñu chi ra na cacan ra limuxtan chi ñáyɨvɨ quɨhvɨ yuvehe cuan, ta nañí chi: Yuvehe Tyaquɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tyicuan ta nanyehe̱ ra coxo cuan chi ra Pedro ta chi ra Juan cha cuaquɨhvɨ ra chichi vehe ñuhu cahnu. Ta chica̱n ra noo limuxtan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ta cananyehe̱ ra Pedro ta ra Juan chi ra. Ta ra Pedro catyí ra chi ra: ―Nye̱he chi ndi ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tyicuan ta quichaha̱ nyehe ra coxo cuan chi ra. Cuñí maa ra vatyi iyó cha cuacuhva ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Soco ra Pedro catyí ra chi ra: ―Ñahri maa xuhun cuichin ta xuhun cuaan iyó chii, ta cuhve chuun. Soco nonga cha iyó chii cua cuhve chuun. Chihin sɨvɨ ra Jesucristo ra Nazaret, catyí chuun, ndɨ̱cuita ta ca̱con ―catyí ra Pedro chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tyicuan ta tɨɨ̱n ra Pedro ndaha chiyo vaha ra ta nacoñehe̱ ra chi ra. Ta caa cuhva ri cuan nɨcoo̱ fuerza chaha ra ta tatu chaha ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tyicuan ta ra coxo cuan ndava̱ ra noo, ta nɨcuinanyaa̱ ra. Ta quichaha̱ chica ra. Ta quɨhvɨ̱ ra chihin ra chichi vehe ñuhu. Ta chicá ra. Ta cañá ndava ra. Ta sacahnú ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tandɨhɨ ñáyɨvɨ nyehe̱ ñu chicá ra ta sacahnú ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ta iyo xaan cuñí ñu ta yuhví ñu cha cuenda cha nduvaha̱ ra cuan. Vatyi nɨcohón nuu ñu chi ra. Ta chitó ñu vatyi suri maa ra cuví cha tuhva chinyaa̱ Yuvehe Tyaquɨ cuan chican ra limuxtan. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ra coxo cha nduvaha̱ cuan, ña sañá maa ra chi ra Pedro ta ra Juan. Ta tandɨhɨ ñáyɨvɨ iyo cuñí ñu ta chino̱ ñu nataca̱ ñu nu nyicú ra, nya nu cuví corredor ra Salomón chichi vehe ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cha nanyehe̱ ra Pedro cha tyicuan caa, catyí ra chi ñáyɨvɨ: ―Nyoho ra Israel, ¿ñáá tuhun cha iyo xaan cuñí nyoho? ¿Ñáá tuhun cha nyehé xaan ndo chi nyuhu? Tari cha vatyi chihin tunyee iñi maa ndi, o cha cuenda cha cachi iyó ndi nuu Nyoo, sanduvaha̱ ndi chi rayɨɨ ihya, cuñí maa ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nyuhu ña cuví sanduvaha ndi chi ñáyɨvɨ. Nyoo cuenda sutu chahnu yo, ra Abraham, ra Isaac, ta ra Jacob, ican ra sacahnú xaan ca ra chi Sehe ra, ra Jesús. Ta maa ndo chaha̱ cuenda ndo chi ra chi ra Pilato, ra cuví tyiño. Ta maa ra cuñi̱ ra saña ra chi ra. Soco nyoho ña chaha̱ ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Cha nuu cha cacan ndo cha saña ra chi ra vaha, ra ii cuan, nyoho chica̱n ndo cha saña ra chi noo ra tuhvá chahñi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tyicuan caa chahñi̱ ndo chi ra cha chahá ñayɨvɨ̱ chaa coo yo chihin Nyoo. Soco Nyoo sanandoto̱ ra chi ra. Ta ña ndoo̱ ra chihin ñu chihi̱. Ta nyuhu cuví ndi cha ndaa. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ta suri maa ra Jesús cuví ra chaha̱ fuerza chaha ra coxo ihya. Vatyi chinó iñi ndi tyi iyó tunyee iñi chi ra Jesús. Yucuan chaha ndunyee̱ chaha ra ihya, ta ñohó nuu vaha ndo chi ra ihya. Ta nduvaha̱ ra vatyi chinó iñi ndi chi ra Jesús. Ta tandɨhɨ nyoho cha nyehe̱ maa ndo vityin. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Chité yañi ―catyí ra Pedro― vatyi quɨvɨ cha chahñi̱ ndo chi ra Jesús, ña chito̱ ndo tyi ña vaha cha nyacuví ndo. Ta tyicuan caa tucu ra cuví nuu chi ndo, ña cachitó ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Soco tyehe caa chino̱ cava tuhun caha̱n Nyoo chihin yuhu ra profeta cuenda ra ta cha naha, vatyi catyí ra vatyi ra Cristo cunyehe ra tɨndoho. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yucuan chaha ndu̱ uvi iñi ndo cuatyi ndo. Ta na̱cuhva ndo añima ndo chi Nyoo, tacuhva na ndachi cuatyi ndo. Tyicuan ta Sutu Mañi yo sandunyee ra añima ndo vatyi cohon ra añima ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tyicuan ta cutachi ra chi ra Jesús ra cuví Cristo na quichi ra inga chaha. Vatyi quɨvɨ xihna ri tyaa̱ Nyoo cuhva tyi quichi ra cha cuenda ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tahán chi cha ndoó ra Jesucristo andɨvɨ cha vityin nyacua nya sanduchaa Nyoo tandɨhɨ maa. Tari cuhva catyi̱ maa ra chihin yuhu ra profeta cuenda ra ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Vatyi tyicuan caa catyi̱ ra Moisés chi sutu chahnu yo: “Cusaquichi Sutu yo Nyoo chi noo ra cahan cuenda ra. Ta suri ñáyɨvɨ chi yo cucuvi ra. Ta cuacahan ra tuhun Nyoo chihin ndo tari cahán yuhu. Qui̱chaha ndo tandɨhɨ cha catyí ra chi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Vatyi tandɨhɨ ñu cha ma tyasoho tuhun cahan ra, cunaa ñu, vatyi ma cu ɨɨn ri ñu chihin ñáyɨvɨ cachi Nyoo chii”, catyí ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ta tyicuan caa tucu tandɨhɨ profeta cuenda Nyoo nya quɨvɨ ra Samuel ta nyacua nya vityin, casacoto̱ ra tuhun cha cuví vityin. ");
INSERT INTO mxtNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tandɨhɨ promesa cha chaha̱ Nyoo cha caha̱n ra profeta tuhun ta cha naha, chi maa ndo cuví. Ta tuhun cha natyihi̱ tahan Nyoo chihin sutu chahnu yo, chihin ra Abraham, suri cha cuenda maa ndo cuví. Vatyi catyi̱ Nyoo chi ra Abraham: “Tandɨhɨ ñáyɨvɨ cha iyó sɨquɨ ñuhu ñayɨvɨ̱ cunasoque chi ñu cha cuenda ñáyɨvɨ chuun.” ");
INSERT INTO mxtNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ta quɨvɨ sanandoto̱ Nyoo chi Sehe ra, xihna ca nu nyicú ndo tachi̱ ra chi ra, vatyi nasoco ra chi ndo. Tacuhva vatyi tahan tahan ndo sandoo ndo cha quiñi caa ―catyí ra Pedro chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ni cahán ca ra Pedro ta ra Juan chihin ñáyɨvɨ, ta chaa̱ coyo tata sutu cuenda ñu Israel chihin ra cuví nuu chi ra sahá cumi vehe ñuhu, ta chihin ra cuví saduceo. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Cacuxaan xaan ra vatyi ra Pedro ta ra Juan sañahá ra chi ñáyɨvɨ ta catyí ra vatyi ndicha cha nandotó ñu chihi̱, vatyi ra Jesús nandoto̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tyicuan ta catɨɨ̱n ra chi ra. Ta catyihi̱ ra chi ra vehe caa. Ta candoo̱ ra nyacua nya inga quɨvɨ vatyi cha iñi xaan cuhva cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Soco cuaha ñu cha chiñi̱ tuhun cahán ra Pedro nachinó iñi ñu. Ta candu ɨɨn ri ñu chihin ñu yɨhɨ́ cuenda ra Jesús. Ta cha tandɨhɨ ñu vasɨ quita ohon mil ñu cha maa ri maa rayɨɨ ri. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tuvi inga quɨvɨ ta candu ɨɨn ri ra cacuví tyiño chi ñu Israel, ra chahnu, ta ra casacuaha cuenda ley cha tyaa̱ ra Moisés, nya Jerusalén cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ta ñohó tucu ra Anás ra cuví nuu chi tata sutu. Ta ra Caifás, ta ra Juan, ta ra Alejandro. Ta nyicú tucu tandɨhɨ ñáyɨvɨ chi ra cacuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tyicuan ta catachi̱ ra tyiño chiquehe̱n chi ra Pedro ta chi ra Juan. Ta chitayucu̱ ra chi ra mahñu. Ta candaca̱ tuhun ra chi ra: ―¿Yóó cha chaha̱ ityi chi ndo vatyi sanduvaha̱ ndo chi ra cuan? ¿Yóó chi cha cuenda nyacuvi̱ ndo tyehe caa? ―cacatyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ta ra Pedro tyitu ra yɨhɨ́ Tatyi Ii Nyoo. Ta catyí ra chi ra: ―Nyoho ra nyacá ñaha Israel ñuu yo ihya. Ta nyoho ra chahnu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vityin ndacá tuhun ndo chi ndi tuhun vaha cha cuvi̱ chi noo ra coxo ihya, vatyi cuñí ndo coto ndo yoso caa nduvaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yucuan chaha cunacatyi ndi chi ndo tacuhva nacoto tandɨhɨ ñáyɨvɨ Israel. Vatyi ra ihya nanyaá ra nuu tandɨhɨ ndo. Vatyi nduvaha̱ ra chihin tunyee iñi ra Jesucristo ra ñuu Nazaret, ra cha chaha̱ cuenda ndo vatyi cúvi ra nu cruzi. Soco Nyoo sanandoto̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ta suri ra Jesús ihya cuví yuu cha chiñuhú ca cha ña cuñí ra savahá vehe cotyiño ra, tari cuhva catyí nuu tutu Nyoo. Ta ican ndo cuví tari ra savahá vehe ta ña cuñí ndo yuu cha chiñuhu ca cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vatyi yori inga ra cuví sacacú chi yo. Vatyi noo tuhun ri maa ra chaha̱ Nyoo vatyi sacacu ra chi yo. ―catyí ra Pedro chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tyicuan ta cachiñi̱ ra cacuvi tyiño cuan vatyi nɨɨ xaan iñi ra Pedro ta ra Juan cacahán ra. Ta ñima ra cañoho̱ vaha sɨcuela cacuví ra. Ta iyo xaan cuñi̱ ra. Tyicuan ta nɨcoho̱n nuu ra chi ra vatyi ican ra cuví ra cha cachica̱ noo chihin ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ta sɨɨn ri, ra cha nduvaha̱ cuan, nanyaá ra chihin ra yucuan. Yucuan chaha ña cuví cahan ña vaha ra cacuvi tyiño cuan sɨquɨ ra Pedro ta ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tyicuan ta catyi̱ ra chi ra naquita coyo nɨnduñi ra chata vehe. Ta candoo̱ maa ra cacuví tyiño cuan candatuhun tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ta catyí ra: ―¿Yoso caa cunyacuvi yo chihin ra ihya? Vatyi tandɨhɨ maa ñu Jerusalén chitó ñu seña cha casacuvi̱ ra ihya. Ta ma cuvi catyi yo vatyi ña ndicha. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Soco tacuhva cha ma cono tuhun ihya nɨcahnu chichi ñuu ihya, cutyanaha yo chi ra, tacuhva vatyi ma cahan ca ra tuhun ra Jesús chihin ñáyɨvɨ ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tyicuan ta cacana̱ ra chi ra Pedro ta ra Juan. Ta catyi̱ ra chi ra vatyi ni chiin ca maa ta ma cahan ca ra tuhun ra Jesús. Ta ma sañaha ca ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Soco ra Pedro ta ra Juan canacaha̱n ra ta catyí ra: ―Ndi̱chi xiñi nyoho ta nye̱he ndo tatu vaha ca cha quichaha ndi chi maa ndo o vaha ca cha quichaha ndi chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Vatyi nyuhu ma cuvi cha sandɨhɨ ndi cha nacatyi ndi tuhun cha nyehe̱ ndi ta chiñi̱ ndi ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tyicuan ta nacatyanaha̱ tucu ra chi ra. Soco saña̱ ra chi ra vatyi ña ñihi̱ ra cuhva tachi tuñi ra chi ra. Vatyi tandɨhɨ ñáyɨvɨ sacahnú ñu chi Nyoo cha cuenda cha cuvi̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vatyi rayɨɨ cha nduvaha̱ cuan, yaha ca uvi xico cuiya ra, ta tyicuan cuiya nyehe̱ ra tɨndoho ta nduvaha̱ ra saha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ta casaña̱ ra chi ra Pedro ta chi ra Juan. Tyicuan ta cuahan coyo ra nu nyicú ra tahan ra. Ta canacatyí ra tandɨhɨ cha cacatyi̱ ra chahnu ta ra cacuví nuu chi tata sutu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cuhva cha cachiñi̱ ñu tuhun ihya tandɨhɨ ñu ta ɨɨn ri quichaha̱ chican tahvi ñu chi Nyoo. Ta catyí ñu: ―Sutu Mañi yuhu, yoho savahu̱n andɨvɨ ta ñuhu ñayɨvɨ̱. Savahu̱n tyañuhu. Ta tandɨhɨ ca cha iyó, maun savaha̱. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ta yoho chihin Tatyi Iun sacahu̱n chi ra David ta cha naha. Ta catyí ra: ¿Ñáá tuhun cha naquɨquɨ ñáyɨvɨ ña ñohó nuu Nyoo? ¿Ñáá tuhun chicá xiñi ñu cha ñima ri tuhun? ");
INSERT INTO mxtNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Rey ta inga cha nyacá ñaha sɨquɨ ñuhu ñayɨvɨ̱ ihya candu cuita ra sɨcun Sutu Mañi yuhu, ta sɨquɨ ra Cristo, catyi ra David. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sutu Mañi yuhu, ndicha vatyi ra Herodes, ta ra Poncio Pilato candu ɨɨn ri ra ñuu Jerusalén ihya chihin ra ñuu Roma ta chihin ra Israel vatyi cahñi ra chi ra Jesús Sehe iun cha cachi̱ vahun. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ta tyicuan caa ta casacuvi̱ ra, tari cuhva cha catyi̱ maun ta cha naha tyi cucuvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ta vityin, Sutu Mañi yuhu, nye̱he cha tyanaha̱ ra chi ndi. Ta cu̱hva cha cunɨɨ ca iñi ndi tyi tyiño nuu maun sacuvi ndi, Sutu Mañi yuhu. Ta cu̱hva cha cahan ndi tuhun chihin cha ña yuhví ndi. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta chihin fuerza maun ta cunduvaha ñu cuhví, ta cunyehe ndi seña ta milagru cha cuenda tunyee iñi ra Jesús Sehe iun ―catyí ñu chicán tahvi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ta cuhva cha ndɨhɨ savaha ñu oración ta taa̱n nu nyicu ñu. Ta tandɨhɨ ñu chitu ñu chihin Tatyi Ii ta caha̱n ñu tuhun Nyoo chihin cha nɨɨ iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tandɨhɨ ñu cha chinó iñi, ɨɨn ri cuví ñu, ta ɨɨn ri cuhva chicá xiñi ñu. Ni noo ñu ta ña catyí ñu vatyi chi maa ñu cuví cha iyó chi ñu, soco chi tandɨhɨ ñu cuví, catyí ñu. Vatyi ɨɨn ri nyicú ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ta chihin tunyee iñi cahnu, cacahán ra apóstol tuhun cha nandoto̱ Sutu Mañi yo Jesús. Ta Nyoo nasocó xaan ra chi tandɨhɨ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ta ni noo ñu ta ñahri cumañí chi ñu vatyi tandɨhɨ ñu cha iyó vehe o ñuhú, xicó ñu. Ta quichi nyacá ñu xuhun, ");
INSERT INTO mxtNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ta chahá cuenda ñu chi ra apóstol. Ta maa ra nasachá ra chi noo noo ñu yoso cuhva cha chiñuhú chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tyicuan caa sacuvi̱ noo ra cha nañi José. Ra cuan vachi ra tata ra Levi. Ta cacu̱ ra ñuhú Chipre cha nyaá mahñu tyañuhu. Ta ra apóstol sacunañi̱ ra Bernabé chi ra. Ta cuñí chi catyí sɨvɨ cuan: Ra Naquehen Ndahvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ta ra Bernabé cuan xico̱ ra ñuhú ra. Ta chaha̱ ra xuhun cuan chi ra apóstol. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Soco noo ra cha nañí Ananías chihin cu Safira ñasɨhɨ ra, xico̱ ñu noo ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Soco tixehe ñu suhva xuhun. Tyicuan ta chinyaca̱ ra Ananías suhva xuhun chi ra apóstol. Ta catyí ra vatyi tandɨhɨ xuhun cha quiyahvi̱ ñuhú cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tyicuan ta catyí ra Pedro chi ra: ―Yoho Ananías, ¿ñáá tuhun cha chahu̱n cha quɨhvɨ ra ña vaha añimon, vatyi cuñún sandavi ñahun chi Tatyi Ii, ta catyún vatyi tandɨhɨ xuhun cha quiyahvi ñuhu cuví ihya ta ndoún chihin suhva? ");
INSERT INTO mxtNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Chuun cuvi̱ ñuhú, ta chuun cuví xuhun cha ñihu̱n cuenda ñuhú cuan. ¿Ñáá tuhun cha cuñún sandavi ñahun chi Nyoo ta catyún tyi tandɨhɨ xuhun chahu̱n? Ñima chi nyuhu sandaví ñahun, chi Nyoo sandaví ñahun ―catyi ra Pedro chi ra Ananías. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cha chiñi̱ ra Ananías tuhun cha caha̱n ra Pedro, nduva̱ ra ta chihi̱ ra. Ta quichi noo cha yuhvi cuñí ñáyɨvɨ cha chito̱ ñu tuhun ihya. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tyicuan ta quichi̱ coyo suhva ra tyivaa ta tyihi̱ ra coño ñuhu ra chichi noo sahma. Ta chaha̱n ra chityihi̱ ra chi ra chichi ñuhú. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yaha̱ noo uñi hora ta chaa̱ ñasɨhɨ ra Ananías ta quɨhvɨ̱ ña nu nyicú ra apóstol. Soco ña chitó ña cha cuvi̱ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ta quichaha̱ ndaca tuhun ra Pedro chi ña ta catyí ra: ―¿Atu tyehe cuví yahvi cha quiyahvi̱ ñuhú ndo? ―catyí ra. Ta nacaha̱n ña ta catyí ña: ―Ay, tyehe cuví yahvi chi ―catyí ña chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tyicuan ta catyí ra Pedro chi ña: ―¿Ñáá tuhun cha ñoho̱ naha ndo tuhun ta sandavi ñaha ndo chi Tatyi Ii Sutu Mañi yo Nyoo? Cha cuandichi coyo ra cha chaha̱n chityihi chi yɨun chichi ñuhú. Ta vityin cuhun tucu ra cutyihi ra chi yoho ―catyí ra Pedro chi ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Caa cuhva ri cuan ta nduva̱ ña chaha ra Pedro, ta chihi̱ ña. Ta caquɨhvɨ̱ coyo ra tyivaa cuan, ta nyehe̱ ra vatyi chihi̱ ña. Ta canacoñehe̱ ra chi ña ta chityihi ra chi ña xiin yɨɨ ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ta tandɨhɨ ñáyɨvɨ yɨhɨ́ cuenda ra Cristo, ta tandɨhɨ ca ñu chitó tuhun cuan, canayuhvi xaan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cuaha seña ta milagru sacuvi̱ ra apóstol sahá Nyoo nu nyicú ñáyɨvɨ. Ta tandɨhɨ ñu yɨhɨ́ cuenda ra Cristo ndu ɨɨ́n ri ñu nu cuví corredor ra Salomón. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta ni nonga ñu cha inga cuenda ta ña cañá iñi ñu cutahan ñu chihin ñu yɨhɨ́ cuenda ra Cristo. Soco vaha cahán ñáyɨvɨ sɨquɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta cuaha xaan ñáyɨvɨ nachinó iñi chi Sutu Mañi yo Jesús, tari rayɨɨ ta ñusɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ta nyacua tavá ñu chi ñu cuhví ityi cahnu, chacún ñu chi ñu nu chito. Vatyi tatu yaha ra Pedro soco vasɨ xiñahñu ra yaha sɨquɨ ñu, ta nduvaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tyicuan tucu ñu iyó yatyin ri Jerusalén cuan, quichí nyaca ñu chi ñu cuhví ta ñu cha yɨhɨ́ tatyi ña vaha chi. Ta nduvaha̱ tandɨhɨ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tyicuan ta ra cuví nuu chi tata sutu, ta ra cayɨhɨ́ cuenda ra cuví saduceo, quiñi cuñi ra nyehe ra chi ra apóstol cha cuenda cha vaha cha casacuví ra chihin tunyee iñi chahá Nyoo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tyicuan ta catɨɨ̱n ra chi ra apóstol. Ta catyihi̱ ra chi ra vehe caa. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Soco cha cuaa cuan quichi̱ noo ángel cha tachi Sutu Mañi yo, ta nuña̱ ra yuvehe caa cuan. Ta tava̱ ra chi ra. Ta catyi̱ ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cua̱han ndo ta cui̱nanyaa ndo chichi vehe ñuhu cahnu. Ta na̱catyi ndo chi ñáyɨvɨ yoso caa cuvi coo ñu ñayɨvɨ̱ chaa cha iyó ndo ―catyí ángel cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cha cachiñi̱ ra tuhun caha̱n ángel cuan, ta cuahan coyo ra. Ta ñaha cuii ri quɨhvɨ̱ coyo ra chichi vehe ñuhu cahnu. Ta quichaha̱ sañaha ra chi ñáyɨvɨ. Ta cha nɨ ri ca cha sañahá ra apóstol cuan, ndu ɨɨn ri ra cuví nuu chi tata sutu ta ra ndɨhɨ chihin ra. Ta cana̱ ra chi ra cacuví tyiño cuenda ñáyɨvɨ Israel vatyi coo ra junta. Tyicuan ta tachi̱ ra na cuquehen chi ra apóstol nu cañohó ra vehe caa cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Soco cuhva cha chaa̱ coyo policia chichi vehe caa cuan, ña nañihi̱ ra chi ra apóstol. Ta cuanuhu coyo ra cuanacatyi ra chi ra cuví nuu chi tata sutu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ta cacatyí ra chi ra: ―Nyasɨ yuvehe caa cuan ta chaa̱ ndi. Ta sɨndaro, tayucú ra yuvehe casahá cumi ra. Soco cuhva cha nuña̱ ndi, ña nañihi̱ ndi chi ni noo ra chichi vehe caa cuan ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cuhva cha cachiñi̱ tata sutu chihin ra cuví nuu chi ra, ta ra cuví nuu chi ra casaha cuenda vehe ñuhu tuhun ihya, iyo xaan cuñí ra. Ta candatuhun tahan ra yoso caa sacuvi ra ta cundɨhɨ tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tyicuan ta chaa̱ noo ra ta catyí ra: ―Ra cha tyihi̱ ndo vehe caa cuan, nyicú ra chichi vehe ñuhu sañahá ra chi ñáyɨvɨ ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tyicuan ta ra cuví nuu chi ra casahá cuenda vehe ñuhu, chaha̱n ra chihin policia, ta chiquehen ra chi ra chihin cha vii ri ta ña cañi̱ ra chi ra, vatyi yuhví ra chi ñáyɨvɨ coto tuchi ñu yuu chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chinyaca̱ ra chi ra nuu ra cacuvi tyiño vehe ñuhu cahnu. Ta ra cuví nuu chi tata sutu catyí ra chi ra: ");
INSERT INTO mxtNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Nyuhu catyi̱ cachi ndi chi ndo vatyi ma cahan ca ndo tuhun ra Jesús. Soco nyoho ña tyasohó maa ndo. Cha ndɨhɨ maa chichi ñuu Jerusalén sacotó ndo tuhun ra. Ta cuñí ndo natyaa ndo sɨquɨ ndi vatyi nyuhu chahñi̱ ndi chi ra cuan ―catyí ra cuví nuu chi tata sutu chi ra apóstol. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tyicuan ta nacaha̱n ra Pedro ta inga ra apóstol, ta catyí ra: ―Nyaá sɨquɨ ndi cha quichaha xihna ca ndi chi Nyoo ta ñima ca chi rayɨɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nyoo cuenda sutu chahnu yo ican sanandoto̱ chi ra Jesús, ra cha chitacaa̱ ndo nu cruzi ta chahñi̱ ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ta ra Jesús ican ra cuví ra cha sacahnu̱ xaan Nyoo chi, ta cuatyaa̱ ra chi ra chiyo vaha ra, vatyi cunyaca ñaha ra tandɨhɨ. Ta noo tuhun ri maa ra cuví ra sacacú chi yo. Vatyi tyicuan caa chahá ra cuhva chi yo cha cuví yo ñu Israel na ndu uvi iñi yo cuatyi yo tacuhva saha ra tɨcahnu iñi cuatyi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ta nyuhu cuví ndi cha ndaa cuenda ihya. Ta tyicuan caa tucu Tatyi Ii cha chaha̱ Nyoo cunyaa añima ñu quichahá chi ra ―catyi ra Pedro chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta cha cachiñi̱ ra cha catyi̱ ra Pedro, nduxaan xaan ra. Ta cuñi̱ ra cahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Soco mahñu ra cacuví tyiño cuan ñohó noo ra cuví fariseo cha nañi Gamaliel. Ta cuví ra ra sacuahá cuenda ley ra Moisés. Ta ñáyɨvɨ sahá xaan ñu ñáyɨvɨ chi ra. Ta ra Gamaliel cuan, nicuinanyaa̱ ra. Ta tachi̱ ra naquita coyo ra apóstol cuan noo cuhva ri. Tyicuan ta quita coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ta quichaha̱ catyi ra Gamaliel cuan chi inga ra cacuví tyiño: ―Nyoho ra nyacá ñaha ñu Israel, sa̱ha ndo cuenda chi ndo chihin cha cua cunyacuvi ndo chihin ra chiña. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɨ̱cohon iñi ndo vatyi cha iyó suhva quɨvɨ ndɨcuita̱ noo ra cha nañi̱ Teudas. Ta catyi̱ ra vatyi cuví ra noo ra vaha. Ta tari cha cumi cientu rayɨɨ chinyicon chi ra. Soco yaha̱ cuan chahñi̱ ñáyɨvɨ chi ra. Ta tandɨhɨ ra chinyico̱n chi ra nacutya̱ cuatyi ra. Ta ndɨhɨ̱ tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yaha̱ cuan ta nu cuahan ca chi, quɨvɨ nacahvi ra gobiernu chi ñáyɨvɨ, ta ndɨcuita ra Judas ra ityi Galilea cuan. Ta cuaha ñu chinyico̱n chi ra. Soco suri chahñi̱ ñáyɨvɨ chi ra. Ta tandɨhɨ ñu cha chinyico̱n chi ra chitya̱ cuatyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yucuan chaha sa̱ña ndo chi ra chiña. Ta ma tyihi ndo chi ndo chihin ra vatyi tatu tuhun ñáyɨvɨ ri cuví cha chicá noo ra, cundɨhɨ tuhun. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Soco tatu ndicha tyi tuhun Nyoo cuví, ma cuvi chi nyoho satɨvɨ ndo. Sa̱ha ndo cuenda chi ndo coto vaha chihin Nyoo cañí tahan ndo ―catyí ra Gamaliel chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tandɨhɨ ra ndoo̱ ra vaha. Tyicuan ta cana̱ ra chi ra apóstol. Cacañi̱ policia chi ra. Ta chasɨ̱ ra nu cahan ca ra tuhun ra Jesús. Tyicuan ta saña̱ ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ta quita̱ coyo ra apóstol nuu ra cuví tyiño. Ta sɨɨ xaan cacuñí ra vatyi chaha̱ Nyoo cuhva vatyi nyehé ra tɨndoho cha cuenda ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ta ña casandɨhɨ̱ ra cha cacahán ra. Ta ndɨquɨvɨ ri sañahá ra tuhun ra Jesucristo vehe ñuhu ta vehe ñáyɨvɨ ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta nu cuaha̱n ca chi quɨvɨ cuaha xaan nanduví ñáyɨvɨ cha yɨhɨ́ cuenda ra Cristo. Tyicuan ta ñu cha cahán sahan griego quichaha̱ cahan ñu sɨquɨ ñu cha cahán sahan hebreo cuan. Vatyi catyí ñu tyi ña tyiñuhú vaha ra cha cahán sahan hebreo chi ñu chihi̱ yɨɨ cuenda ñu, cuhva cha sachá ra cha cacachi ñu ndɨquɨvɨ ri. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tyicuan ta ndɨ uchi uvi tahan apóstol sandu ɨɨn ri ra chi tandɨhɨ ñu yɨhɨ́ cuenda ra Cristo. Ta cacatyí ra chi ñu: ―Ña vaha cha sandɨhɨ ndi cha cahan ndi tuhun Nyoo ta sacha ndi cha cachi ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yucuan chaha yañi, na̱nducu ndo ucha tahan ra nu canyicú ndo ihya, ra vaha iyó chihin Nyoo, ra chiñi tuñi, ra tyitú yɨhɨ́ chihin Tatyi Ii. Ta cuhva yo tyiño ihya chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta nyuhu sañihi ndi cacan tahvi ca ndi. Ta cuasañaha ca ndi tuhun Nyoo ―catyí ra apóstol. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tandɨhɨ ñu ndoó ñu vaha. Ta nacachi̱ ñu chi ra Esteban. Vatyi chinó xaan iñi ra chi Nyoo. Ta tyitu ra chihin Tatyi Ii. Ta nacachi̱ tucu ra chi ra Felipe, ta chi ra Prócoro, ta chi ra Nicanor, ta chi ra Timón, ta chi ra Parmenas, ta chi ra Nicolás cha cuví ra noo ra ñuu Antioquía, ta nanduvi̱ ra noo ra Israel. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tyicuan ta quichi̱ nyaca ra chi ra nu nyicu ra apóstol. Tyicuan ta catyiso̱ ra ndaha ra xiñi noo noo ra ta cachica̱n tahvi ra chi Nyoo cha cuenda ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ta cuaha̱n chitya ca tuhun Nyoo. Ta nducuaha̱ ca ñu yɨhɨ́ cuenda ra Cristo ñuu Jerusalén. Ta na chino̱ iñi tucu cuaha tata sutu cuenda ñu Israel ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ra Esteban cuví ra noo ra cha tyitú chihin tunyee iñi Nyoo. Ta vaha xaan ñáyɨvɨ cuví ra vatyi tyitu añima ra chihin cha vaha Nyoo. Ta cuaha xaan milagru ta seña sacuví ra nu nyicú ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tyicuan ta suhva ra vehe ñuhu ñuu Israel cha nañi Vehe Ñuhu Cuenda Ñáyɨvɨ Ndoo Libre, candu ɨɨn ri ra chihin ra ñuu Cirene, ta ra ñuu Alejandría, ta ra ityi Cilicia, ta ra ityi Asia. Ta quichaha̱ cuvi yuhu ra chihin ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Soco ña cacuvi chasaha ra chi ra, vatyi ra Esteban cahán ra chihin cha chiñi tuñi cha chaha Tatyi Ii chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tyicuan ta catyiyahvi̱ ra cuan chi suhva ra vatyi canducu ra cuendu chaha ra Esteban ta catyi ra cuendu cuan vatyi ra Esteban cahán ña vaha ra sɨquɨ ra Moisés, ta sɨquɨ Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yucuan chaha tandɨhɨ ñáyɨvɨ cuan naquɨquɨ̱ ñu. Tyicuan ta ra chahnu ta ra sacuaha cuenda ley ra Moisés, catɨɨ̱n ra chi ra Esteban. Ta chaha̱n ra chinyaca ra chi ra nu ndu ɨɨn ri ra cuví tyiño cuenda vehe ñuhu ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta canducu̱ ra chi ra cahan cuendu chaha ra. Ta maa ra catyí ra tyehe caa: ―Ra Esteban ihya, ña sandɨhɨ́ ra cha cahan cuehe ra sɨquɨ vehe ñuhu yo ta sɨquɨ ley ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta chiñi̱ ndi caha̱n ra vatyi ra Jesús ra Nazaret cuan cusatanɨ ra vehe ñuhu cahnu ihya. Ta cunasama ra costumbre cha sandoo̱ ra Moisés chi yo na ―catyí ra cuendu cuan sɨquɨ ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tyicuan ta ra cacuví tyiño ta ra canyicú yucuan canyehe̱ ra chi ra Esteban vatyi tari maa nuu ángel tyicuan caa nuu ra cuhva cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tyicuan ta ra cuví nuu chi tata sutu ndaca̱ tuhun ra chi ra Esteban, ta catyí ra: ―¿Atu ndicha cha catyi̱ ra ihya? ");
INSERT INTO mxtNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tyicuan ta nacaha̱n ra Esteban ta catyí ra: ―Nyoho yañi, ta nyoho tata, cuɨ̱ñɨ ndo tuhun cahín. Sutu yo Nyoo cha cahnu ca tuvi̱ ra nuu sutu chahnu yo, ra Abraham quɨvɨ nyaá ra ityi Mesopotamia cha nɨri ca cha cumañi cucoo ra nya ñuu Harán. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ta catyí ra chi ra: “Sa̱ndoo ñuun, ta chi tandɨhɨ ñáyɨvɨ chuun. Ta cu̱nuhu inga ñuu cha cusañahi chuun”, catyí Nyoo chi ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tyicuan ta ra Abraham quita̱ ra ñuu Caldea ityi Mesopotamia cuan, ta cuanuhu̱ ra nya ñuu Harán. Ta yucuan cuví nu chihi̱ sutu ra. Yaha cuan saquichi̱ Nyoo chi ra ñuhú nu iyó yo vityin. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Soco ñahri ñuhú chaha̱ Nyoo chi ra quɨvɨ cuan. Ni noo nu cuinanyaa chaha ra ta ña chaha̱ ra. Soco catyi̱ Nyoo chi ra vatyi cucuhva ra. Ta cutahan chi chi sehe ra chata cha yaha cúvi ra. Tyicuan caa catyi̱ Nyoo chi ra Abraham, vasɨ ta coo ca sehe ra quɨvɨ cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ta sɨɨn ri catyi̱ Nyoo chi ra vatyi ñáyɨvɨ chi ra cucoo ñu inga ñuu. Ta cusacuvi ñu tyiño nuu ñáyɨvɨ ñuu cuan, ta ma tyiyahvi ñu chi ñu. Ta cunyehe ñu tɨndoho cumi cientu cuiya. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Soco catyi̱ tucu Nyoo chi ra tyehe caa: “Ñáyɨvɨ ñuu cuan cusanyehe ñu tɨndoho chi ñáyɨvɨ chuun. Yucuan cuenda cuatachi tuñi yuhu chi ñu. Ta yaha̱ cuan ta cuquita ñáyɨvɨ chuun ñuu cuan ta cuquichi ñu ihya. Ta cusacuvi ñu tyiño nuu mai ihya”, catyi̱ Nyoo chi ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","’Tyicuan caa natyihi̱ tahan Nyoo tuhun chihin ra. Ta chaha̱ Nyoo noo costumbre cha cuasacuvi ñu coto naa iñi ñu. Chaha̱ ra tyi cutahnya chiin ñɨɨ xiñi ndɨvɨ cha lee sehe ñu, o cha sahá ñu circuncidar chi sehe ñu cuví cuan. Ta cha yaha̱ uña quɨvɨ cha cacu̱ ra Isaac sehe ra Abraham, tyicuan caa chinyacuvi̱ ra chihin ra. Ta suri tyicuan caa sacuvi̱ tucu ra Isaac chihin ra Jacob sehe ra. Ta ra Jacob tucu chihin uchi uvi tahan sehe ra, tyaa ra noo seña cuan chi noo noo sehe ra. Ta ican ra cuan cacuví sutu chahnu yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ta ican uchi ɨɨ́n tahan ra sehe ra Jacobo ihya catasɨ cuñí ra nyehe ra chi ra José yañi ra cha cuenda vatyi vaha ca ra nuu sutu ra. Yucuan chaha caxico̱ ra chi ra na cuhun ra Egipto. Soco Nyoo ña sandoó ra chi ra José. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ta sacacu̱ ra chi ra nu nyehé ra tɨndoho. Ta chaha̱ ra cha chiñi tuñi ra chi ra. Ta chaha̱ ra cha vaha coo ra nuu ra Faraón, ra cuví rey Egipto. Ta rey cuan chaha̱ ra cha cuvi ra José gobiernu Egipto cuan. Ta chinyaca̱ ñaha tucu ra vehe maa rey ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tyicuan ta chiyo̱ tama nɨcahnu ityi Egipto ta ityi Canaán. Ta nyehe̱ xaan ñáyɨvɨ tɨndoho. Ta tandɨhɨ sutu chahnu yo cha chicoo tyembu cuan ña cañihi̱ ra cha cachi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Soco quɨvɨ chito̱ ra Jacob vatyi iyó trigu nya Egipto, ta tachi̱ ra chi sehe ra na cuquehen ra. Ta chaha̱n coyo ra noo chaha. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ta cha cu uvi chaha cha chaha̱n coyo ra, ra José sacoto̱ ra chi ra vatyi yañi ra cuví chi ra. Yucuan quɨvɨ chito̱ ra Faraón yóó chi tata vachi ra José. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tyicuan ta tachi̱ ra José tyiño na quichi sutu ra, ra Jacob, chihin tandɨhɨ ñáyɨvɨ chi ra, uñi xico chahun tahan ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ta tyicuan caa cuvi cha cuahan ra Jacob cuacoo ra Egipto cuan. Yaha̱ cuan ta chihi̱ ra yucuan. Ta chihi̱ tucu sehe ra, ra cacuví sutu chahnu yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tyicuan ta chaa̱ quɨvɨ cha chinanyaca̱ ñu yɨquɨ ra Jacob ta yɨquɨ sehe ra nya Siquem. Ta yucuan quɨhvɨ ra chichi ñuhú nu sata̱ ra Abraham noo ñaña chi sehe ra Hamor ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Soco cha ni cumañi ca quita ñu Egipto, ñáyɨvɨ chi ra Abraham cha iyó Egipto cuan cuaha xaan nanduvi ñu. Ta cha nyañaa yatyin quɨvɨ cha cuacuhva Nyoo ñuhú chi ñu tari cuhva catyi̱ cachi ra chi ra Abraham. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tyicuan ta quichaha̱ nyaca ñaha noo rey cha ña ñohó nuu chi ra José. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey cuan sandavi̱ ñaha ra chi ñáyɨvɨ chi yo cuan. Ta sanyehe̱ xaan ra tɨndoho chi ñu, ta sanɨñɨ̱ ra chi ñu na sanandoo ñu chi sehe ñu cha ni cacu vatyi na cúvi ndotyin. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta suri quɨvɨ cuan cacu̱ ra Moisés. Ta tahan xaan iñi Nyoo chi ra lee cuan. Ta uñi yoo sacuahnu̱ sɨhɨ ra chi ra nya vehe ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yaha cuan ña cuví ca tixehe sɨhɨ ra chi ra. Ta sandoo ña chi ra chichi noo tica yuhu yutya. Tyicuan ta sehe maa rey Egipto cuan nañihi̱ ña chi ra. Ta naquehe̱n ña chi ra. Ta sacuahnu̱ ña chi ra, tari cha sehe ña cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yucuan chaha cutuhva̱ ra Moisés tandɨhɨ cha chitó ñu Egipto. Ta sɨɨn ri nyee xaan cuhva cahan ra, ta cuhva sacuví ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ta quɨvɨ cha chaa̱ uvi xico cuiya ra Moisés quichi cuvi iñi ra cuhun ra cunyehe ra nu nyicú ñu Israel, ñáyɨvɨ chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tyicuan ta noo quɨvɨ nyehe̱ ra nu cañí noo ra Egipto cuan chi noo ra Israel cuan. Tyicuan ta chahñi̱ ra Moisés chi ra Egipto cuan vatyi satasɨ iñi ra chi ra Israel ra ñuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Cuñí maa ra Moisés cuan vatyi ñáyɨvɨ Israel cuan cutuñi iñi ñu tyi Nyoo tachi̱ chi ra vatyi cusacacu ra chi ñu. Soco maa ñu ña tuví iñi ñu cha tyicuan caa cucuvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tyicuan ta cha inga quɨvɨ cuan nyehé ra Moisés chi uvi tahan ra Israel cha cacañí tahan ra. Ta ra Moisés, cuñi ra cha ma cacañi tahan ca ra, ta quichaha catyi ra: “Ña vaha cha cacañi tahan nyoho, vatyi suri yañi ndo cuvi”, catyi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tyicuan ta ra cha cañí chi tahan cuan tyandaha̱ ra chi ra Moisés, ta catyi ra chi ra: “¿Yóó cha tyatyiño chi yoho vatyi cunyaca ñahun ta cuvun juez chi ndi? ");
INSERT INTO mxtNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Atu cuñun cahñun chii tari chahñu̱n chi ra Egipto cuan icu?” catyi ra chi ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuhva cha chiñi̱ ra Moisés cha catyi̱ ra, chino̱ ra. Ta cuahan ra nya ñuu Madián. Yucuan ñihi̱ ra ñasɨhɨ ra. Ta yucuan chiyo̱ uvi tahan sehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Yaha̱ uvi xico cuiya. Tyicuan ta noo quɨvɨ chicá noo ra Moisés chiqui ndɨɨ yatyin noo yucu cha nañí Sinaí. Ta nyehe̱ ra noo taca iñu cha cayú. Tyicuan ta tuvi noo ángel chichi ñuhu̱ cha cayu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iyo xaan cuñí ra Moisés cha nyehé ra yucuan. Ta cuhva cha tuhva̱ yatyin ca ra vatyi tacuhva nyehe vaha ra, chiñi̱ ra noo ndusu Sutu Mañi yo. Ta catyí ra tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yuhu cuví Nyoo cuenda sutu chahnun, Nyoo cuenda ra Abraham, ta ra Isaac, ta ra Jacob”, catyí Nyoo chi ra. Tyicuan ta ra Moisés quichaha̱ nɨhɨ ra chihin cha yuhvi ra. Ta ña caña iñi ra nanyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ta quichaha catyi tucu Sutu Mañi yo chi ra: “Ta̱va ndichan chahun vatyi ñuhú nu chañun, ñuhú ii cuví. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yuhu nyehí tandɨhɨ tɨndoho cha nyehé ñáyɨvɨ cuende ñuu Egipto chiña. Ta chiñí ndusu ñu cha chacú chaa ñu. Yucuan chaha noó xique vityin vatyi sacaqui chi ñu. Ña̱ha, vatyi cutachi chuun nya Egipto”, catyí Nyoo chi ra Moisés. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Quɨvɨ cuan ña cuñi̱ ñáyɨvɨ Israel chi ra Moisés cha cunyaca ñaha ra chi ñu, ta catyi̱ ñu chi ra: “¿Yóó cha tyatyiño̱ chi yoho vatyi cunyaca ñahun ta cuvun juez chi ndi?”, catyi̱ ñu chi ra. Ta vasɨ ña cuñi̱ ñu cha cunyaca ñaha ra chi ñu, soco Nyoo tachi̱ chi ra vatyi cuvi ra nuu, ta sacacu ra chi ñu. Vatyi tyicuan caa catyí ángel cha tuvi̱ nuu ra nu taca iñu cha cayu cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ta ican ra Moisés cuan tava̱ chi ñáyɨvɨ Israel Egipto cuan. Ta cha yaha savaha̱ ra milagru ta seña ñuu cuan, ta sacuvi̱ tucu ra nu yaha̱ ñu Tyañuhu Cuaha. Ta nu chica̱ noo ñu ñuhú ityi chichi cha uvi xico cuiya sacuvi̱ tucu ra ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ta suri maa ra Moisés cuan cuví ra cha catyi̱ chi ñu Israel ta cha naha tyehe caa: “Nyoo cutachi ra noo profeta ra tari tachi̱ ra chi mai. Ta cucuvi ra noo ra Israel tari maa ndo. Qui̱chaha ndo chi ra”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ta suri maa ra Moisés cuan ndɨhɨ ra chihin ñáyɨvɨ chahnu yo nu chica noo ñu ñuhú ityi cuan. Ta ican ra cuví ra cha caha̱n ángel cuan chihin nya yucu Sinaí. Ta ican ra quehe̱n cuenda ra tuhun yoso caa coo ñáyɨvɨ ta sañaha̱ ra chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Soco ñáyɨvɨ chahnu yo ña quichaha̱ ñu chi ra. Tava̱ xiin ñu chi ra. Ta cacuñi ñu cunuhu coyo ñu nya Egipto. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yucuan chaha cuhva cha nyaá ca ra Moisés yucu Sinaí ta caha̱n ñáyɨvɨ chihin ra Aarón ta catyí ñu: “Sa̱vahun suhva nyoo cha cuhun coyo ityi nuu ndi. Vatyi ña chitó ndi ñáá cha cuvi̱ chi ra Moisés, ra cha tava̱ chi ndi Egipto”, catyi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tyicuan ta casavaha̱ ñu noo becerru xuhun cuaan. Tyicuan ta cachahñi̱ ñu quɨtɨ vatyi cuhva cuenda ñu chi xitohyo cuan. Ta sɨɨ xaan cuñi̱ ñu cachiyo̱ ñu vico cuenda xitohyo cha casavaha ñu chihin ndaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tyicuan ta Nyoo cuachiyo̱ ra chi ñu. Ta saña̱ ndaha ra chi ñu vatyi cusacahnu ñu chi ñanyii, chi yoo, ta ñáá ndɨhɨ tiñoo cha iyó ityi andɨvɨ. Vatyi tyehe caa catyaa̱ ra profeta cuenda Nyoo nu libru ta cha naha: Nyoho ñáyɨvɨ Israel, ¿atu chahñi̱ ndo quɨtɨ vatyi cuhva cuenda ndo chi yuhu chichi cha uvi xico cuiya cha chica noo ndo ñuhu ityi? Ñima. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Soco sacahnu̱ ndo chi nyoo cha nañí Moloc, ta sacahnu̱ tucu ndo chi nyoo cha nañí Renfán cha caá tari caá tiñoo andɨvɨ. Suri maa ndo savaha̱ xitohyo cuan, vatyi sacahnu ndo. Yucuan chaha yuhu cuatave chi ndo ñuu ndo, ta cuasacuhin chi ndo noo nu cañi ityi nuu ca Babilonia, catyi̱ Nyoo chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Nu chicá noo sutu chahnu yo ñuhú ityi cuan, chicumi ra noo vehe ñuhu cha chino̱ chihin ñɨɨ quɨtɨ. Ta chichi vehe cuan chicumi ra tabla yuu cha nyaá ley Nyoo nuu. Ta ra Moisés tachi̱ ra tyiño na savaha ñu vehe ñuhu cuan ta ityi chata ca tari cuhva sañaha̱ maa Nyoo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yucuan ta ra Josué nanduvi̱ ra nuu chi ñu. Ta quehe̱n ñu vehe ñuhu ta chicoo ñu chihin nu nyaá yo ihya vityin. Vatyi Nyoo tava̱ ñehe ra chi ñáyɨvɨ chiyo̱ ñuhu ihya ta nacuhva̱ cuenda ra chi ñu Israel ñáyɨvɨ chi yo. Ta chotyiño̱ ñu vehe ñuhu cuan nyacua nya quɨvɨ chiyo̱ rey David. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ta rey David ñihi̱ ra tumañi iñi nuu Nyoo. Ta cuñi̱ ra savaha ra noo vehe vaha nu coo Nyoo. Suri Nyoo ihya sacahnu̱ ra Jacob ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Soco ra Salomón savaha̱ vehe Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Vasɨ ña iyó Nyoo chichi vehe ñuhu cha savahá ñáyɨvɨ. Tari catyi̱ ra chihin yuhu ra profeta ta cha naha tyehe caa: ");
INSERT INTO mxtNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Andɨvɨ cuví tyayu nu nyaí ta nyacá ñahi tandɨhɨ. Ta ñuhu ñayɨvɨ̱, yucuan cuví nu chañí chahi. ¿Atu cuví savaha ndo vehi ta coi chichi, cuñí maa ndo? ¿Ta nya maa maa cuvi nyitati, cuñí maa ndo? ");
INSERT INTO mxtNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Atu ña chitó ndo vatyi mai savahi andɨvɨ ta ñuhu ñayɨvɨ̱? catyí Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Soco nyoho ―catyí ra Esteban― tyicuan ri tuhvá ndo sandava ndo iñi ndo. Ta ña cuñí ndo naquehen ndo tuhun cahán Nyoo. Tyicuan ri ña quichahá ndo chi Tatyi Ii. Ɨnuu ri caa ndo chihin sutu chahnu ndo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sutu chahnu ndo satasɨ̱ iñi ra ta cachahñi̱ ra chi tandɨhɨ ra profeta cuenda Nyoo ta cha naha. Ta ican ra cuan cacatyi̱ vatyi cuquichi noo ra vaha. Ta cha quichi̱ ra vityin, nyoho ña cuñí nyehe ndo chi ra, ta cachahñi̱ ndo chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nyoho naquehe̱n cuenda ndo ley Nyoo cha chaha̱ ángel chi ndo, soco ña cuñí ndo sacuvi ndo cuhva catyí ley cuan ―catyí ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cuhva cha chiñi̱ ra cacuví tyiño vehe ñuhu cahnu tuhun ihya, xaan xaan cuñi̱ ra, nyacua casacahñi noho ra nyehé ra chi ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Soco ra Esteban tyitú cuii maa ra chihin Tatyi Ii ta nanyehé ra ityi andɨvɨ. Ta nyehé ra cha cahnu cuví Nyoo. Ta suri nyehe̱ ra chi ra Jesús nanyaá ra chiyo vaha Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tyicuan ta catyí ra Esteban: ―¡Nye̱he ndo! Nyehí tanuña andɨvɨ. Ta nyehí chi ra Jesús, Rayɨɨ cha quichi̱ nya gloria, nanyaá ra chiyo vaha Nyoo ―catyí ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Soco ra cuan cachasɨ ra soho ra, cha ma cuɨñɨ ra tuhun cahán ra Esteban. Tyicuan ta vaa ri cananduvi ra. Ta tandɨhɨ ra cuahan coyo ra sɨquɨ ra Esteban. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tyicuan ta catava̱ ra chi ra yuhu ñuu. Ta ca chahñi̱ ra chi ra chihin yuu. Ta ra cha casacuví cha ña vaha cuan, casandoo̱ ra sahma cha nyaa chata ra vatyi sahacumi noo ra tyivaa cha nañi Saulo. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cha nɨri ca cha cacañi ra yuu chi ra Esteban, quichaha̱ chican tahvi ra Esteban chi Nyoo, vatyi tuvi iñi ra cuacúvi ra. Ta catyi ra tyehe caa: ―Sutu Mañi yuhu Jesús, na̱quehen añime ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yaha̱ cuan, tyicuan ta chicuɨñɨ chɨtɨ ra, ta chaa canachaa̱ ra ta catyi ra: ―Sutu Mañi yuhu, ma tɨɨn cuendon cuatyi cha sacuví ñu ―catyí ra. Ta cha yaha̱ catyi ra tyehe caa, ta chihi̱ ri ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ta ra Saulo ña chinó iñi ra chi ra Jesús, ta ndoó ra vaha cha chahñi̱ ra chi ra Esteban. Ta suri quɨvɨ cuan quichaha nducu xaan ñáyɨvɨ chi ñu yɨhɨ́ cuenda ra Cristo ñuu Jerusalén cuan vatyi cucahñi ñu chi ñu. Soco ra apóstol ña caquita̱ ra. Candoo ra nyicú ra Jerusalén. Ta tandɨhɨ ca ñu cachino ñu, cuahan coyo ñu cuacoo ñu ityi Samaria, ta ityi Judea. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ta suhva ra cha nyicón vaha chi Nyoo Jerusalén cuan, catyihi̱ ra coño ñuhu ra Esteban chichi ñuhú. Ta cachacu̱ xaan ra cha cuenda ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Cha nɨri ca cha tyicuan caa, ra Saulo chicá nyicon vavaha ra chi ñáyɨvɨ yɨhɨ́ cuenda Cristo. Ta tahan tahan vehe ñu chaha̱n ra. Ta suri quiñoho ñaa ra chi ñu, ta chaha̱ cuenda ra chi ñu vatyi cohon ñu vehe caa, rayɨɨ ta ñusɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Soco tandɨhɨ ñu cha quita̱ ñuu Jerusalén, cahán ñu tuhun yoso caa sacacú ra Cristo añima ñu tandɨhɨ ri maa ityi nu chaa̱ coyo ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Minoo ra cha nañí Felipe chaa̱ ra noo ñuu ityi Samaria. Ta quichaha̱ cahan ra tuhun ra Cristo chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ta tandɨhɨ ri ñáyɨvɨ ta tyasoho̱ ñu tuhun cha cahán ra. Ta nyehé ñu milagru ta seña cha savahá ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vatyi cuaha vavaha ñáyɨvɨ cha yɨhɨ́ tatyi ña vaha chii nduvaha ñu. Vatyi tatyi ña vaha cha yɨhɨ́ chi ñu, quita̱ chi ta suri canachaa̱ chi cuahan chi. Ta cuaha vavaha ñáyɨvɨ coxo ta ñáyɨvɨ cha ña cuví nacanda, nduvaha ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yucuan chaha ñáyɨvɨ ñuu cuan, sɨɨ xaan cacuví chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Soco ñuu Samaria cuan iyó noo ra tasɨ cha nañí Simón. Ta sandaví ñaha ra chi ñáyɨvɨ cuan. Catyí ra vatyi cuví ra noo ra cahnu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ndɨɨ cuii maa ñáyɨvɨ tyasohó ñu tuhun cahan ra, nya ñu tyayɨɨ, ta nya ñu ndahvi. Ta cacatyí ñu: ―Ndicha ndicha cuii, vatyi tunyee iñi Nyoo nyaá chihin ra ihya ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Quichahá xaan ñu tuhun cahán ra vatyi cha naha xaan sandaví ñaha ra chi ñu chihin tuhun tasɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tyicuan ta quichi̱ ra Felipe. Ta sacoto ra chi ñu yoso caa nyacá ñaha Nyoo añima ñáyɨvɨ. Ta yoso cuhva cha cahnu cuvi ra Jesucristo. Ta yucuan ta chino iñi ñu chi ra Cristo, rayɨɨ ta ñusɨhɨ. Ta condutya̱ ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nyacua nya ra Simón cuan, ta nachino̱ iñi ra chi ra Cristo, ta condutya̱ ra. Ta quichaha̱ chica noo ra chihin ra Felipe. Ta iyo xaan cuñi̱ ra nyehe ra milagru, ta seña cha sacuví ra Felipe cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tyicuan ta ra apóstol cha canyicú ñuu Jerusalén cuan ñihi̱ ra tuhun cha canachinó iñi ñáyɨvɨ ityi Samaria cuan tuhun Nyoo. Ta catachi̱ ra chi ra Pedro ta chi ra Juan. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuhva cha chaa̱ coyo ra yucuan, ta chica̱n tahvi ra chaha ñu quɨhvɨ̱ cuenda ra Cristo vatyi tacuhva tyi naquehen ñu Tatyi Ii. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Vatyi ñu cuan, ta naquehen ca ñu Tatyi Ii. Tacuhva condutya̱ ri ñu chihin sɨvɨ Sutu Mañi yo Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tyicuan ta ra Pedro ta ra Juan catyiso̱ ra ndaha ra sɨquɨ ñu, ta naquehe̱n ñu Tatyi Ii. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ta ra Simón cuan nyehe̱ ra cuhva cha catyiso̱ ra apóstol ndaha ra sɨquɨ ñu cuan, ta naquehe̱n ñu Tatyi Ii. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ta quichaha̱ catyi ra tyehe caa: ―Yoso xuhun cuñí ndo ta cuhva ndo tunyee iñi chiña chii, vatyi tacuhva cuvi tyise ndahi sɨquɨ ñáyɨvɨ, ta naquehen tucu ñu cuan Tatyi Ii ―catyi ra Simón cuan chi ra apóstol. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tyicuan ta nacaha̱n ra Pedro ta catyí ra: ―Na cunaun ɨɨn ri chihin xuhun chiña. Vatyi chicá iñun tyi cuví sata yo chihin xuhun nyatu cha chahá maa Nyoo chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yoho, ña tahán chi tyihun chuun chihin tuhun ihya. Vatyi añimon ña vaha nuu Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ndu̱ uvi iñun cuhva chicá xiñun chiña, vatyi cahnu cha quiñi caa cuví cuan nuu Nyoo. Ta ca̱can tahvi chi ra na nyehe yo tatu saha ra tɨcahnu iñi chuun cha cuenda cha caa chichi añimon. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vatyi nyehí tyi chichi añimon tyitú maa yɨhɨ́ cha quiñi caa cha cuvi tari cha uva. Ta cha quiñi caa cuan, ña chahá coton cha vaha. ―catyí ra Pedro chi ra Simón cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tyicuan ta nacaha̱n ra Simón ta catyí ra: ―Ca̱can tahvi maa ndo cha cuende nuu Nyoo, ta cuhva cha ma quichi tandɨhɨ tuhun cha catyún chiña sɨqui ―catyí ra Simón chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cha yaha̱ cuan ta ra apóstol nacatyi̱ ra tandɨhɨ cha nyehe̱ ra cha sacuvi̱ ra Cristo. Ta caha̱n ra tuhun Nyoo. Tyicuan ta cuanuhu̱ coyo ra nya Jerusalén. Ta suri sacoto ra tuhun yoso caa sacuví yo ta cacu añima yo tandɨhɨ ñuu ityi Samaria nu yaha̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Cha yaha̱ tuhun cuan tyicuan ta caha̱n noo ángel Nyoo chihin ra Felipe, ta catyí ra: ―Ndɨ̱cuita ta cuhun ityi sur, ityi quita nya Jerusalén ta cuahan nya Gaza ―catyí ángel cuan chi ra. Yucuan cuvi ityi cha yahá noo ñuhú ityi. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tyicuan ta ra Felipe ndɨcuita ra ta cuahan ra. Ta ityi cuahan ra ta ñihi tahan ra chihin noo ra ñuu Etiopía. Ta cuvi ra eunuco. Cuví ra noo ra cuví tyiño cahnu ñuu Etiopía, vatyi sahá cuenda ra xuhun cu Candace, ñaha cha cuví reina ñuu Etiopía cuan. Ta chaha̱n ra Etiopía cuan chisacahnu̱ ra chi Nyoo nya Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ta ityi cuanuhú ra nya ñuu ra nyaá ra sɨquɨ carru ra. Ta sacuahá ra libru cha tyaa̱ ra Isaías ra profeta cuenda Nyoo ta cha naha. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tyicuan ta Tatyi Ii catyí chi ra Felipe: ―Sa̱tuhva ca nu cuahan carru cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ta cuhva cha tuhva̱ ra Felipe, chiñi̱ ra vatyi sacuahá ra cuan nu libru cha tyaa̱ ra Isaías. Ta ndaca̱ tuhun ra chi ra: ―¿Atu cutuñí iñun cha sacuahún? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tyicuan ta nacaha̱n ra cuan ta catyí ra: ―¿Yoso caa cutuñi iñi ta yori sañahá chii? ―catyí ra chi ra. Ta chica̱n ra chi ra Felipe na ndaa ra ta cunyaa ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ta nu cuahan sacuaha ra, catyí chi tyehe caa: Chahñi̱ ra chi ra tari chahñí ra noo mbee. Vatyi tari ña chacú mbee tatu cuasatya ra ixi tɨ, ta tari ña chacú tɨ tatu chahñi ra chi tɨ, tyicuan caa cuví ra cuan tyi nyehe̱ ra tɨndoho ta ñahri maa catyi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sanocuee̱ ñu chi ra ta yori cuñí sacacu chi ra. ¿Yóó ra cuvi nacatyi tuhun sehe ra cha cuacoo? Yori, vatyi chihi̱ ra. Catyí chi nu tutu cha sacuaha ra cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tyicuan ta ra cuan quichaha̱ ndaca tuhun ra chi ra Felipe, ta catyí ra: ―Sa̱ha tumañi iñi chii, ta ca̱tyun chiin chii yóó chi tuhun cahán ra profeta ihya. ¿Atu tuhun maa ra, o yóó chi tuhun cahán ra? ―catyí ra chi ra Felipe. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tyicuan ta ra Felipe quichaha̱ cahan ra sɨquɨ tuhun cha cha yaha̱ sacuaha ra cuan, ta nacatyí ra chi ra vatyi tuhun ra Jesús cahán ra cuan. Ta nacatyí ra vatyi ra Jesús cuví ra cha sacacú chi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tyicuan ta cha cuayaha ra noo nu ñohó ndutya. Ta ra cuan quichaha̱ catyí ra chi ra Felipe: ―Ihya ñohó ndutya. ¿Atu ma cuvi condutye vityin? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tyicuan ta nacaha̱n ra Felipe, ta catyí ra: ―Tatu chinó iñun chihin cha tandɨhɨ añimon, cuví condutyon ―catyí ra chi ra. Tyicuan ta nacaha̱n ra cuan, ta catyí ra: ―Chinó iñi yuhu vatyi Sehe Nyoo cuví chi ra Jesucristo ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tyicuan ta ra cuan catyí ra chi musu ra na sacucuɨñɨ ra carru cuan. Tyicuan ta canoo̱ nduvi tahan ra. Ta caquɨhvɨ̱ ra chi ndutya. Tyicuan ta sacondutya̱ ra Felipe chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ta cuhva cha caquita̱ coyo ra chichi ndutya cuan, Tatyi Ii Sutu Mañi yo naquehe̱n chi chi ra Felipe. Ta ra cuan ña nyehe̱ ca ra chi ra. Soco sɨɨ xaan cuví chi ra, cuanuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ta ra Felipe chaa̱ ra ñuu Azoto. Ta cuahan ra tahan tahan ñuu, ta caha̱n ra tuhun ra Cristo chihin ñáyɨvɨ nyacua nya cha chaa̱ ra ñuu Cesarea. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Cha nɨ ri ca cha chicá noo ra Felipe cahán ra tuhun ra Cristo chihin ñáyɨvɨ, ra Saulo ña sandɨhɨ́ ra tuhun cha nducú cahñi ra chi ñu yɨhɨ́ cuenda Sutu Mañi yo. Ta chaha̱n ra nu nyaá ra cuví nuu chi tata sutu, ");
INSERT INTO mxtNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","chicaca̱n ra noo tutu chi ra, tacuhva nacuhva ra cuhun ra vehe ñuhu ñuu Damasco, ta tɨɨn ra chi ñu cuahan ityi ra Cristo, ta quichi nyaca ra chi ñu vehe caa Jerusalén, rayɨɨ o ñusɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ñihi̱ ra Saulo tutu cuan ta cuaha̱n ra. Ta cuhva cha cuachaa ra ñuu Damasco cuan, sana cuii ri iñi ra, ta quichi̱ noo nduva ñuhu̱ ityi andɨvɨ, sacundichin nɨcachico maa nu cuaha̱n ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tyicuan ta ra Saulo nduva̱ ra nu ñuhú. Ta chiñi̱ ra noo ndusu cha catyí tyehe caa: ―Saulo, Saulo, ¿ñáá tuhun cha chicá nyicon chi yuhu? ―catyí ndusu cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tyicuan ta nacaha̱n ra Saulo ta ndaca tuhu̱n ra chi ra ta catyí ra: ―¿Yóó yoho Tata? ―catyi ra. Tyicuan ta nacaha̱n ndusu cuan chihin ra, ta catyí: ―Yuhu cuví ra Jesús, ra chicá nyicon chi. Suri chi maun sañicuehún, tari sañicuehé sɨndɨquɨ quɨtɨ tahví ñuhu chi tɨ cha chañí nyaa tɨ nu noo cha xaan cha saquehen ityi ra chi tɨ ―catyí ra Jesús chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tyicuan ta ra Saulo suri nɨhɨ ra chihin cha yuhvi ra. Ta catyí ra: ―Sutu Mañi yuhu, ¿ñáá cha cuñún tyi sacuvi? ―catyí ra. Tyicuan ta Sutu Mañi yo catyí ra chi ra tyehe caa: ―Ndɨ̱cuita ta quɨ̱hvun chichi ñuu Damasco chiña. Ta yucuan cucatyi noo ra chuun ñáá cha cusacuvun ―catyí ra Jesús chi ra Saulo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ra cha candɨhɨ chihin ra Saulo, yuhvi xaan ra cacuvi̱. Ta ña cañihi̱ ra tuhun cahan ra vatyi cachiñi̱ ra ndusu cuan soco yori chi nyehe ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tyicuan ta ra Saulo ndɨcuita̱ ra. Soco cuhva cha nuña̱ ra chɨtɨ nuu ra, ña cuví ca maa nyehe ra vatyi nducuaa̱ ra. Yucuan chaha, ra tahan ra cayɨndaha̱ ra ndaha ra ta chinyaca ra chi ra ñuu Damasco cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yucuan chinyaa̱ ra uñi tahan quɨvɨ. Ta ña cuvi̱ nyehe ra. Ta nɨri ña chachi̱ ra, ta ña chihi̱ ra ndutya. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ñuu Damasco cuan iyó noo ra chinó iñi chi Nyoo. Ta nañí ra Ananías. Ta nyehe̱ ra noo visión nu catyí Sutu Mañi yo chi ra tyehe caa: ―¡Ananías! ―catyí ra chi ra. Tyicuan ta nacaha̱n ra Ananías, ta catyí ra: ―Ma yuhu ihya, Sutu Mañi yuhu ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tyicuan ta Sutu Mañi yo catyí ra: ―Ndɨ̱cuita, ta cu̱hun noo ityi cahnu cha nañi Ndoo. Ta na̱nducun vehe noo ra cha nañí Judas. Ta nda̱ca tuhun sɨvɨ noo ra cha nañí Saulo, ra ñuu Tarso. Vatyi chicán tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ta nyehé ra noo visión, ta nyehé ra chi noo ra nañí Ananías. Ta chaá ra nu nyaá ra, ta tyisó ra ndaha ra sɨquɨ ra tacuhva cuví nanyehe ra inga chaha ―catyí Sutu Mañi yo chi ra Ananías. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tyicuan ta nacaha̱n ra Ananías ta catyí ra: ―Sutu Mañi yuhu, cuaha xaan ñáyɨvɨ nacatyí chii vatyi cuaha xaan cha ña vaha chinyacuvi̱ ra Saulo cuan chihin ñu yɨhɨ cuendon nya ñuu Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ta vityin vachi tucu ra ihya vatyi chaha̱ ra cacuví nuu chi tata sutu ityi chi ra cha tyihi ra chi ñáyɨvɨ chicán tahvi chihin sɨvun vehe caa ―catyi ra Ananías chi Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Soco Sutu Mañi yo catyí ra chi ra: ―Cua̱han vatyi yuhu cha nacachi̱ vahi chi ra Saulo cuan, vatyi cahan ra tuhin chihin ñáyɨvɨ inga ñuu, ta chihin rey inga ñuu, ta suri cahan tucu ra chihin ñáyɨvɨ Israel ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yuhu cusañahi chi ra yoso caa cha cuaha tɨndoho cunyehe ra cha cuende ―catyí Sutu Mañi yo chi ra Ananías. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tyicuan ta cuahan ra Ananías vehe nu nyaá ra Saulo. Chaa̱ ra vehe cuan ta quɨhvɨ̱ ra chichi vehe. Ta tyiso̱ ra ndaha ra sɨquɨ ra Saulo, ta catyí ra chi ra tyehe caa: ―Yañi Saulo, Sutu Mañi yo ra Jesús ra tuvi̱ nuun ityi vachun, ican ra tachi̱ chii vatyi tacuhva cuvi nanyehun inga chaha. Ta cusacutu ra chuun chihin Tatyi Ii ra ―catyí ra Ananías chi ra Saulo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Caa cuhva ri cuan ta cana̱ coyo noo cha tari caa soo tiyaca cha yɨhɨ̱ chɨtɨ nuu ra Saulo. Tyicuan ta cuvi̱ nanyehe ra inga chaha. Yaha̱ cuan ta condutya̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yaha̱ cuan ta chachi̱ ra. Ta ndunyee̱ coño ñuhu ra inga chaha. Ta ndoo̱ ra suhva quɨvɨ chihin ñu yɨhɨ́ cuenda ra Cristo ñuu Damasco cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tyicuan ta numi ri quichaha̱ cahan ra Saulo tuhun ra Cristo chihin ñáyɨvɨ tandɨhɨ vehe ñuhu ñu Israel ñuu Damasco cuan. Ta catyí cachi ra vatyi ra Jesús, Sehe Nyoo cuví chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndɨɨ cuii maa ñáyɨvɨ cha chiñi̱ tuhun cahán ra, iyo vavaha cuñí ñu. Ta catyí ñu chi tahan ñu: ―¿Atu ñima ra ihya cuví ra cha chica nyicon chi ñu chicán tahvi chihin sɨvɨ ra Jesús ityi ñuu Jerusalén cuan? ¿Atu suri ñima ra cuví cha vachi tɨɨn chi ñu ityi tyehe vatyi cucuhva cuenda ra chi ñu chi ra cacuví nuu chi tata sutu? ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Soco ra Saulo ñihi ca cahán ra tuhun ra Cristo chihin cha nɨɨ ca iñi ra. Ta sañahá ra vatyi ra Jesús cuví ra Cristo, Sehe Nyoo. Nyacua ña cutuñí iñi ra Israel nyicú Damasco cuan nya ityi chino iñi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cha yaha̱ suhva quɨvɨ, ta ra Israel cha ña chinó iñi chi ra Cristo catyihi̱ tahan ra tuhun cha cahñi ra chi ra Saulo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ta ndiyaca ta ñiyaca canyatú ra chi ra yuvehe cahnu ñuu cuan. Soco ra Saulo cuan numi ri chito ra tuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tyicuan ta ñáyɨvɨ cha chinó iñi chi ra Cristo ñuu cuan catyihi̱ ñu chi ra chichi noo tica cahnu. Ta noo cha cuaa casanoo̱ ñu chi ra ityi ventana noo vehe cha cacu̱ chihin barda cha nyaá nɨcachico yuhu ñuu cuan. Ta tyicuan caa chino̱ ra cuahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Quɨvɨ cha chaa̱ ra Saulo Jerusalén, cuñi̱ ra ndu ɨɨn ri ra chihin ñu yɨhɨ́ cuenda ra Cristo. Soco tandɨhɨ maa ñu cuan ta yuhvi̱ ñu chi ra. Vatyi ña chinó iñi ñu cha yɨhɨ́ ra cuenda ra Jesús. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Soco noo ra cha nañí Bernabé, naquehe̱n ra chi ra. Ta chaha̱ cuenda ra chi ra chi ra apóstol. Ta nacatyi̱ ra chi ra yoso caa nyehe̱ ra Saulo chi Sutu Mañi yo ra Cristo ityi ñuu Damasco; ta nacatyi̱ ra yoso caa caha̱n Sutu Mañi yo chihin ra. Ta yoso caa caha̱n ra tuhun ra Cristo chihin cha ña yuhvi ra nya ñuu Damasco cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tyicuan ta ndoo̱ ra Saulo Jerusalén chihin ñu yɨhɨ́ cuenda ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ta cahan ra tuhun Sutu Mañi yo chihin cha ña yuhvi ra. Ta ndatuhún xaan ra tuhun ra Cristo chihin ra Israel cha cahan sahan griego. Soco ra cuan cananducu̱ ra cuhva yoso caa ta cacahñi ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Soco cachitó ra hermano cuan vatyi tyicuan caa yɨhɨ́ iñi ra cuan. Yucuan chaha chinyaca ra chi ra Saulo nya ñuu Cesarea. Ta yucuan ta natachi̱ ra chi ra nya Tarso ñuu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tyicuan ta ñu yɨhɨ́ cuenda ra Cristo cha nyicú tandɨhɨ ityi Judea, ta ityi Galilea, ta ityi Samaria, vii xaan nyicu ñu vatyi ña cuxaan ca ñáyɨvɨ chi ñu. Ta ndunyee̱ ca iñi ñu chihin fuerza Nyoo vatyi quichaha̱ vaha ñu cuhva catyí Nyoo, vatyi yuhví ñu coto ma sacuvi ñu cuhva cuñí ra. Iyó ñu chihin cha tyinyeé Tatyi Ii chi ñu. Ta cuaha xaan ñu cuahan nanduvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tyicuan caa cuvi̱ ta ra Pedro tuhvá ra chica noo ra nyehe ra yoso caa canyicu hermano noo noo ñuu. Ta chahan tucu ra chinyehe ra nu nyicu ñu yɨhɨ́ cuenda ra Jesucristo noo ñuu cha nañí Lida. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yucuan nañihi̱ ra chi noo ra cuhvi. Nañi ra Eneas. Ta cha uña cuiya catuví ra ña cuvi nacanda ra vatyi ndundava coño ñuhu ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Soco ra Pedro catyí ra chi ra: ―Yoho Eneas, ra Jesucristo sanduvaha̱ ra chuun. Ndɨ̱cuita ta na̱tuvi yuvun ―catyí ra chi ra. Tyicuan ta caa cuhva ri cuan ndɨcuita̱ ra Eneas. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ta nyehe̱ tandɨhɨ ñáyɨvɨ ñuu Lida cuan tyi nduvaha̱ ra. Ta ñáyɨvɨ ñuu Sarón ñandɨhɨ. Tyicuan ta ñu cuan nachino̱ iñi ñu chi Sutu Mañi yo. Ta sandoo̱ ñu tuhun chahnu cha chino̱ iñi ñu ta cumañi ca coto ñu tuhun ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Quɨvɨ cuan chiyo̱ noo ñaha chinó iñi chi ra Cristo ñuu Jope. Ta nañí ña Tabita, soco chihin sahan griego, Dorcas nañí ña. Ta tyicuan ri sacuví ña cha vaha chihin ñáyɨvɨ. Tyinyeé ña chi ñu ndahvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ta quɨvɨ cuan cu Dorcas quehe̱n noo cuehe chi ña ta chihi̱ ña. Ta cha yaha̱ sacutyi̱ ñu chi ña, chicacun ñu chi ña chichi noo cuarto nu cu uvi piso. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ñuu Jope cuan yatyin ri nyaá chihin ñuu Lida, nu nyaá ra Pedro. Ta ñu cha yɨhɨ́ cuenda ra Cristo ñuu Jope cuan chitó ñu vatyi nyaá ra Pedro ñuu Lida cuan. Tyicuan ta tachi̱ ñu chi uvi tahan ra na cucatyi ra chi ra Pedro vatyi naquichi ra cha numi ri. Cuahan ra cuan ta catyí ra chi ra Pedro: ―Co̱ho nya Jope. Sa̱numi ta ma cucueun ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tyicuan ta ra Pedro ndɨcuita̱ ra ta cuahan ra chihin ra. Ta cuhva cha chaa ra, chinyaca ra chi ra nya cuarto nu caa ndɨyɨ cuan. Ta tandɨhɨ maa ñu chihi̱ yɨɨ catuhva ñu nɨcachico chata ra. Suri chacú chaa ñu. Ta sañahá ñu sahma cha quicu̱ cu Dorcas ta chinyito ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tyicuan ta ra Pedro tava̱ ra chi tandɨhɨ ñáyɨvɨ cuarto cuan. Tyicuan ta chicuiñi chɨtɨ ra ta quichaha chican tahvi ra chi Nyoo. Tyicuan ta nanyehe̱ ra chi ñaha chihi̱ cuan catuvi ña. Ta quichaha̱ catyi ra chi ña: ―Hermana Tabita, ndɨ̱cuita ―catyí ra chi ña. Tyicuan ta nandɨca̱ ña chɨtɨ nuu ña. Ta cuhva cha nanyehe ña chi ra Pedro, nɨcunyaa̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tyicuan ta ra Pedro tɨɨ̱n ra ndaha ña ta sandɨcuita̱ ra chi ña. Tyicuan ta cana̱ ra chi ra hermano, ta chi ñu chihi̱ yɨɨ. Ta nacuhva̱ cuenda ra chi ña chi ñu vatyi nandoto̱ ña. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yaha̱ cuan ta ndɨɨ cuii maa ñu Jope chitó ñu cha nandoto̱ ña cuan. Ta cuaha vavaha ñu nachino̱ iñi chi Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ta ra Pedro ndoo̱ ra cuaha ri quɨvɨ ñuu cuan. Nyaá ra vehe noo ra satyahyu ñɨɨ. Nañí ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñuu Cesarea iyó noo ra cha nañí Cornelio. Ta cuví ra capitán cuenda noo ciento sɨndaro. Ta ityi sɨndaro cuan, Italia nañí. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ta ra Cornelio cuan yuhví ra chi Nyoo ta vaha sacahnú ra chi ra, maa ra ta ñáyɨvɨ chi ra ñandɨhɨ. Ta sɨɨn ri cuaha vavaha xuhun chahá ra chi ñu ndahvi ñu Israel. Ta tyicuan ri chicán tahvi ra chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta cuví noo quɨvɨ cuan cuhva cha caa uñi cha cha iñi, nyehe̱ ra noo visión. Ta yucuan cuvi̱ nu cachi xaan nyehe̱ ra vatyi noo ángel cha tachi̱ Nyoo quɨhvɨ̱ nu nyaá ra, ta catyí ra chi ra: ―¡Yoho Cornelio! ―catyi ángel cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tyicuan ta nanyehe̱ ra Cornelio chi ángel cuan. Ta yuhvi xaan ra cuvi. Ta quichaha̱ ndaca tuhun ra ta catyí ra: ―¿Ñáá cha cuví ihya, Tata? ―catyí ra chi ángel cuan. Tyicuan ta ángel cuan quichaha catyi ra chi ra: ―Nyoo chiñi̱ ra ndɨɨ cuii maa cha chicón chi ra. Ta tahán iñi ra vatyi tyinyeé xaun chi ñu ndahvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ta vityin cuñí chi cha tachun tyiño nya ñuu Jope na cuquehen chi noo ra cha nañí Simón Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ta maa ra cuan cuacatyi ra chuun ñáá cha tahán chi sacuvun. Ta iyó ra vehe noo ra cha nañí tucu Simón, cuví ra noo ra satyahyú ñɨɨ. Ta iyó vehe ra yuhu tyañuhu ―catyí ángel cuan chi ra Cornelio, ta cuahan ángel cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ta cha yaha̱ cuahan ángel cuan, ra Cornelio cana̱ ra chi uvi tahan musu ra, ta chi noo sɨndaro cha chinó xaan iñi chi Nyoo. Ta cuví tucu ra noo ra sahá cuenda chi ra Cornelio ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ndɨɨ cuii tuhun caha̱n ángel cuan chihin ra Cornelio ta nacatyi̱ ra chi nduñi tahan ra cuan. Ta tachi̱ ra chi ra ñuu Jope. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tuvi̱ inga quɨvɨ ta cuahan coyo ra cuan. Ta cuhva cha cuachaa coyo ra yuhu ñuu Jope cuan, ra Pedro ndaa̱ ra xiñi vehe vatyi cuacacan tahvi ra chi Nyoo, ta cha cuñí hora cuví cuhva cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ta chaa̱ noo soco chi ra ta chisocó vavaha ra. Soco cha nɨri ca cha sanduvahá ñu cha cachi ra, quichaha̱ nyehe ra noo visión. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ta nyehe̱ ra vatyi nɨcuitacoho andɨvɨ. Ta nyehe ra cua noo̱ noo sahma cahnu vavaha ityi andɨvɨ. Ta tari quɨvɨ nuhñi noo noo tutun sahma cuan ta cuahan noo ityi nu ñuhu. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ta chichi sahma cuan ñohó tandɨhɨ maa nuu quɨtɨ cha cumi tahan chaha. Ta tandɨhɨ nuu coo, ta tandɨhɨ nuu saa. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tyicuan ta chiñi̱ ra noo ndusu cha catyí chi ra: ―Pedro, ndɨ̱cuita ta ca̱hñi quɨtɨ ihya, ta ca̱chun ―catyí ndusu cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Soco ra Pedro nacaha̱n ra ta catyí ra: ―Ma cachi, Sutu Mañi yuhu. Yuhu ña tuhvé chachi quɨtɨ cha catyí ley tyi yɨca cha cachi ndi ―catyí ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tyicuan ta quichaha catyi tucu ndusu cuan chi ra inga chaha: ―Ma catyun vatyi yɨca cha cachun noo cha cha yaha̱ sanduvii̱ yuhu ―catyí ndusu cuan chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uñi tahan chaha sañaha̱ Nyoo visión ihya chi ra. Tyicuan ta sahma cahnu cuan nandaa̱ cuanuhu tucu ityi andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Cha nɨri ca cha chicá xiñi ra Pedro ñáá cha cuñí chi catyi visión cuan, chaa̱ coyo musu cha tachi̱ ra Cornelio. Ta candaca tuhun ra nya nyaá vehe ra Simón. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ta cha chaa coyo ra ityi yuvehe candaca̱ tuhun ra tatu yucuan iyó noo ra cha nañí Simón Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ta ra Pedro suri cha chicá xiñi ra ñáá cha cuñí chi catyi visión cha nyehe̱ ra. Tyicuan ta Tatyi Ii quichaha̱ catyi chi ra: ―Nye̱he Pedro, uñi tahan ra nanducú chuun. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndɨ̱cuita ta cu̱hun chihin ra, ta ma quɨhɨ uvi iñun vatyi mai tachi̱ chi ra ihya ―catyí Tatyi Ii chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tyicuan ta ra Pedro noo̱ ra nu canyicu ra cha tachi̱ ra Cornelio, ta catyí ra chi ra: ―Yuhu cuví ra nanducú ndo. ¿Ñáá tyiño vachi ndo? ");
INSERT INTO mxtNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tyicuan ta canacaha̱n musu ra Cornelio ta catyí ra: ―Ra Cornelio, ra cuví capitán chi ndi ican tachi̱ chi ndi. Noo ra vaha xaan ñáyɨvɨ cuví. Ta vaha xaan quichahá ra nu cahán Nyoo. Ta tandɨhɨ maa ra Israel ityi Judea ihya cacuñí ra chi ra chaha cha cuenda cha vaha ñáyɨvɨ cuví ra. Ta noo ángel Nyoo catyi̱ chi ra vatyi na cana ra chuun, vatyi cuhun vehe ra vatyi tacuhva cuɨñɨ ra tuhun cha cuacahun ―cacatyí musu ra Cornelio chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tyicuan ta chaha̱ ra Pedro quɨhvɨ coyo ra chichi vehe. Ta candoo̱ ra chihin ra cha cuaa cuan. Ta cha inga quɨvɨ cuan ta cuahan ra Pedro chihin ra. Ta cuahan suhva ra hermano cha iyó Jope cuan ñandɨhɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Cha inga quɨvɨ chaa̱ coyo ra nya Cesarea nu nyatú ra Cornelio chi ra chihin ñáyɨvɨ chi ra, ta chihin tandɨhɨ ra tahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuhva cha chaa̱ ra Pedro vehe ra, ra Cornelio quita̱ ra ta cahan ra chihin ra. Ta chicuiñi̱ chɨtɨ ra nuu ra ta quichaha sacahnu ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Soco ra Pedro nacoñehe̱ ra chi ra, ta catyí ra chi ra: ―Ndɨ̱cuita vatyi noo rayɨɨ ri cuví yuhu tari yoho, ta ñima Nyoo cuví ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ta cha nɨri ca cha cahán ra chihin ra, quɨhvɨ̱ ra ta nanyehe ra cuaha ñáyɨvɨ candu ɨɨn ri. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tyicuan ta catyí ra Pedro chi ñu: ―Nyoho chitó ndo vatyi ley nyuhu cha cuví ndi ñu Israel, ña chahá chi cha cu ɨɨn ri ndi chihin ñáyɨvɨ inga ñuu. Ta nɨ ri chichi vehe ñu ta ma cuvi quɨhvɨ ndi. Soco Nyoo sañaha̱ ra chii, ta catyí ra: “Yoho, ma catyun chi ni noo ñáyɨvɨ tyi ña vaha ñu”, catyí Nyoo chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yucuan chaha quɨvɨ cha cana̱ ndo chii, numi ri vachi. Ta vityin cuñí cote ñáá cuenda cana̱ ndo chii ―catyí ra Pedro chi ra Cornelio. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tyicuan ta nacaha̱n ra Cornelio, ta catyí ra: ―Cha iyó cumi quɨvɨ vityin, suri maa cuhva ihya cha nyaí vehi ta ña chachi̱ ta chicán tahvi chi Nyoo cha cha iñi. Ta tuvi̱ noo ra nui. Ñihnó ra noo sahma xiño vavaha. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ta catyí ra chii: “Yoho Cornelio, Nyoo chiñí ra cha chicán tahvun. Ta nɨcohón iñi ra cha sacuvún vatyi tyinyeún chi ñu ndahvi. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ta̱chi tyiño nya ñuu Jope na quichi ra Simón Pedro. Nyaá ra vehe inga tucu ra cha nañí Simón, noo ra cha satyahyu ñɨɨ. Ta vehe ra nyaá yatyin ri yuhu tyañuhu. Ta na quichi ra Simón Pedro ta cahan ra chuhun”, catyí ángel cuan chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tyicuan ta numi ri tachi̱ tyiño vatyi cuquehen chuun. Ta vaha vatyi vachun. Ta vityin tandɨhɨ yo nyicú yo nuu Nyoo. Ta cuñí ndi cuɨñɨ ndi tandɨhɨ cuii maa cha tachi̱ Sutu Mañi yo chuun vatyi nacatyun chi ndi. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tyicuan ta quichaha cahan ra Pedro ta catyí ra: ―Vityin cutuñi iñi vatyi Nyoo cuñí ra chi tandɨhɨ ñáyɨvɨ. Cuví ri yo ñu Israel, o cuví ri yo ñu inga ñuu. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Soco naquehen ra chi yo tatu quichaha yo chi ra, ta sacuví yo cha vaha. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Caha̱n ra chihin nyuhu ñu vachi tata ra Israel, ta sacoto̱ ra vatyi nduvaha coo yo chihin ra cha cuenda ra Jesucristo. Maa ra nyacá ñaha tandɨhɨ maa yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nyoho chitó vaha ndo tandɨhɨ cha cuvi̱ ñuu Israel ñui, yoso caa quichaha̱ chi nu cuví Galilea cha yaha̱ cha caha̱n noo ra Juan nuu ñáyɨvɨ, ta sacondutya̱ ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Chitó ndo yoso caa chaha̱ Nyoo tunyee iñi Tatyi Ii ra chi ra Jesús, ra Nazaret. Ta chica̱ noo ra sacuvi̱ ra cha vaha, sanduvaha̱ ra chi tandɨhɨ ñu cha nyehé tɨndoho sahá ra ña vaha. Tyehe caa sacuví ra Jesús vatyi Nyoo nyaá ra chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nyuhu cuví ndi cha ndaa tandɨhɨ cha sacuvi̱ ra Jesús nɨcahnu Judea ta ñuu Jerusalén. Yaha̱ cuan ta chahñi̱ ñu chi ra nu cruzi. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Soco sanandoto̱ Nyoo chi ra nu cu uñi quɨvɨ. Ta tuvi̱ ra nuu ndi. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ña tuvi̱ ra nuu tandɨhɨ ñáyɨvɨ. Soco tuvi̱ ra nuu nyuhu vatyi nacachi̱ ra chi ndi nyata ityi chata ca vatyi cuvi ndi cha ndaa cuenda ra. Nyuhu chachi̱ ndi ta chihi̱ ndi chihin ra cha yaha̱ cha nandoto̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ta tachi̱ ra chi ndi vatyi cahan ndi tuhun ra chihin ñáyɨvɨ. Ta cuví ndi cha ndaa vatyi Nyoo cuatyaa̱ ra chi ra Jesús tyi cuvi ra juez chi ñu cha nyitó ta ñu cha chihi̱. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ta tyicuan caa tucu nyata ityi chata ca, cacaha̱n tandɨhɨ ra profeta Nyoo tuhun ra Jesús. Ta cacatyí ra vatyi tandɨhɨ ñu cha chinó iñi chi ra Jesús, cusandachi Nyoo cuatyi ñu cha cuenda maa ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ni cahán ca ra Pedro ta noo̱ xica ri Tatyi Ii sɨquɨ tandɨhɨ ñu tyasohó tuhun cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ta ra Israel cha cayɨhɨ́ cuenda ra Jesús cha chaa̱ coyo chihin ra Pedro iyo xaan cuñí ra vatyi chaha̱ tucu Nyoo Tatyi Ii ra chi ñu cha ñima ñu Israel cuví. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chitó ra tyi tyicuan caa cuví vatyi chiñí ra cahán ñu inga sahan, ta sacahnú ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tyicuan ta quichaha̱ catyí ra Pedro chi ra cha chaa̱ coyo chihin ra: ―Ma cuvi casɨ yo nu condutya ñáyɨvɨ ihya. Vatyi cha naquehe̱n tucu maa ñu Tatyi Ii tari maa yo ―catyí ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tyicuan ta tachi̱ ra Pedro chi ñu nɨ ñihí Tatyi Ii na condutya ñu chihin sɨvɨ ra Jesucristo. Tyicuan ta chacu̱ ndahvi ñu nuu ra Pedro vatyi cuñí ñu cha ndoo ra suhva quɨvɨ chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ra apóstol ta inga ra hermano cha nyicú Judea, ñihi̱ ra tuhun vatyi nyacua nya ñu cha ñima ñu Israel cuví ta naquehén ñu tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tyicuan ta nachaa̱ ra Pedro Jerusalén. Ta ra cha catyí vatyi cuñí chi cha sacuvi yo costumbre circuncisión ta cuhva cuvi cacu yo, xaan xaan cuñí ra nyehe ra chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ta cacatyí ra chi ra tyehe caa: ―¿Ñáá tuhun cha chahu̱n vehe ñu cha ñima ñu Israel cuví ta chachu̱n chihin ñu? ―catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tyicuan ta ra Pedro nacatyí ra nya nu quichaha tandɨhɨ cha cuvi̱ chi ra ta catyí ra: ");
INSERT INTO mxtNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Yuhu nyaí ñuu Jope. Ta cuhva cha chicán tahvi chi Nyoo ta nyehi̱ noo visión. Ta nyehi̱ tari noo sahma cahnu cha noó ityi andɨvɨ. Tari cha nuhñí noo noo tutun ta cuahan noo ityi nu ñuhú nu nyaí. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ta nanyehe̱ vahi ñáá cha ñohó chichi. Ta nyehi̱ quɨtɨ cha cumi chaha, quɨtɨ cuhu, ta coo, ta saa. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ta chiñi̱ noo ndusu cha catyí chii: “Ndɨ̱cuita Pedro. Ca̱hñi quɨtɨ ihya ta ca̱chun”, catyi ndusu cuan chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ta nacahi̱n ta catyi̱ tyehe caa: “Sutu Mañi yuhu, ma cuvi, vatyi ni noo chaha ta ta cachi que coño quɨtɨ quiñi caa.” ");
INSERT INTO mxtNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tyicuan ta ndusu andɨvɨ nacaha̱n chi chihin inga chaha, ta catyí chi: “Ma catyi yoho vatyi ma cachun noo cha yaha̱ sanduvii̱”, catyí ndusu cuan chi. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Uñi chaha cuvi̱ tyehe caa. Yaha̱ cuan ta nandaa̱ tandɨhɨ chihin sahma cuan ityi andɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ta caa cuhva ri cuan chaa̱ coyo uñi tahan ra vehe nu nyaí, quita̱ ra ñuu Cesarea ta nanducu̱ ra chii. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ta Tatyi Ii tachi̱ chii na cuhin chihin ra. Ta catyi̱ ra chii tyi ma caca iñi cha ñima ñu Israel cuví ñu. Ta chaha̱n coyo tucu iñu tahan ra yañi yo ihya chihin. Ta cha chaa̱ ndi nya Cesarea quɨhvɨ̱ ndi chichi vehe noo ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ta nacatyi̱ ra cuan chi ndi yoso caa nyehe̱ ra chi noo ángel chichi vehe ra. Nanyaá ángel cuan ta catyi̱ ra chi ra vatyi na tachi ra musu ra ñuu Jope na cana ra chi noo ra cha nañi Simón Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Vatyi ican ra cucatyi ra chi ra yoso caa cacu añima ra ta añima tandɨhɨ ñáyɨvɨ chi ra, catyí ángel cuan chi ra cuan na. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ta sacuvi̱ ra cuan tari cuhva catyi̱ ángel cuan chi ra. Ta cuhva cha chai̱ vehe ra quichaha cahín chihin ñu. Ta quichi̱ ri Tatyi Ii sɨquɨ ñu tari quichi̱ sɨquɨ yo cha xihna ri. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tyicuan ta nɨcoho̱n iñi cha catyi̱ Sutu Mañi yo quɨvɨ cuan. Ta catyí ra tyehe caa: “Ndicha vatyi ra Juan sacondutya̱ ra chi ñáyɨvɨ chihin ndutya. Soco nyoho cucondutya ndo chihin Tatyi Ii”, catyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nyoo chaha̱ tucu ra Tatyi Ii ra chi ñu cuan tari chaha̱ ra chi maa yo quɨvɨ chino iñi yo chi Sutu Mañi yo Jesucristo. Ta cha tyicuan caa ¿yóó ra cuvi yuhu vatyi casi cha sacuví Nyoo? ―catyí ra Pedro chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tyicuan ta cuhva cha cachiñi̱ ra yañi yo ra Jerusalén tuhun cuan ña nacaha̱n ca ra. Ta casacahnu̱ ra chi Nyoo. Ta cacatyí ra: ―Tu tyicuan caa cuvi̱, cuñí chi catyi vatyi Nyoo chahá tucu ra chi ñu cha ñima ñu Israel cuví vatyi ndu uvi iñi tucu maa ñu cuatyi ñu, ta coo ñu ñayɨvɨ̱ cha ma naa ca maa ―cacatyí ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Quɨvɨ cha cachahñi̱ ra chi ra Esteban, quichaha chica nyicon ra chi inga ñu yɨhɨ́ cuenda ra Cristo. Ta yɨhɨ́ ñu cachino̱ ñu ta cuahan coyo ñu ityi Fenicia. Ta inga ñu nya noo ñuhú cha nyaá mahñu tyañuhu cha nañí Chipre. Ta yɨhɨ́ ñu chaa̱ coyo ñu ñuu Antioquía. Ta suri cahan ñu tuhun ra Cristo soco ɨɨn ri maa chihin ñu Israel. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ta chihin ñu cha cuahan coyo cuan, ndɨhɨ́ suhva ñáyɨvɨ ñuhú Chipre. Ta yɨhɨ tucu suhva ñu ñuu Cirene. Ta cha chaa̱ coyo ñu ñuu Antioquía, ta quichaha cahan tucu ñu cuan chihin ñu cha ñima ñu Israel cuví. Ta sacoto ñu tuhun Sutu Mañi yo Jesús, ra cha sacacu añima yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ta tunyee iñi Sutu Mañi yo nyaa chihin ñu. Ta yucuan chaha cuaha ñáyɨvɨ casandoo̱ ñu tuhun chahnu cha chino̱ iñi ñu. Ta nachino iñi ñu chi Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tyicuan ta chaa̱ tuhun cuan nya Jerusalén. Ta ñu yɨhɨ́ cuenda Cristo tachi̱ ñu chi ra Bernabé na cuhun ra nya Antioquía. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta cha chaa̱ ra Bernabé Antioquía cuan, nyehe̱ ra yoso caa nasocó Nyoo chi ñu. Ta ndusɨɨ xaan cuñí ra. Ta cahán ra nuu ñu na cunyicon ñu chi Sutu Mañi yo chihin cha nɨɨ iñi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tyicuan caa sacuvi̱ ra Bernabé vatyi cuví ra noo ra vaha. Tyitú ra chihin Tatyi Ii. Ta chinó xaan iñi ra chi Nyoo. Ta tyicuan caa ta cuaha ñáyɨvɨ quɨhvɨ̱ ñu cuenda Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Cha yaha cuan ta cuahan ra Bernabé cuananducu ra chi ra Saulo nya ñuu Tarso. Ta cha nañihi̱ ra chi ra, chinyaca ra chi ra nya ñuu Antioquía. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ta cachinyicu̱ ra chihin ñu yɨhɨ́ cuenda Nyoo ñuu cuan noo cuiya nanɨɨ ta sañaha̱ ra tuhun Nyoo chi cuaha ñáyɨvɨ. Ta suri ñuu Antioquía cuan cuvi nu quichaha catyi ñáyɨvɨ: Cristiano chi ñu, o ñu yɨhɨ́ cuenda ra Cristo cuví cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ta quɨvɨ cuan chaa̱ coyo ra cachahá cuenda tuhun cahán Nyoo, ra cacuví profeta. Quita̱ ra ñuu Jerusalén ta chaa̱ coyo ra Antioquía. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ta noo ra cuan nañí ra Agabo chicuinanyaa̱ ra nu nyicú ra yɨhɨ́ cuenda ra Cristo ta cahan ra tuhun cha chaha̱ Tatyi Ii chi ra. Ta catyí ra vatyi cuquichi noo tama nicacahnu ñayɨvɨ̱. Ta tyicuan caa cuvi̱ quɨvɨ chinyaa̱ ra Claudio cuví ra rey cahnu. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tyicuan ta ñu yɨhɨ́ cuenda Cristo nya Antioquiá tyihi̱ tahan ñu tuhun vatyi cucuhva ñu yoso cuhva cundaa iñi maa noo noo ñu, vatyi cutyinyee ñu chi ñu yɨhɨ́ cuenda Cristo cha iyó ityi Judea. ");
INSERT INTO mxtNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tyicuan caa sacuvi̱ ñu ta sacuhu̱n ñu xuhun chi ra cuví nuu chi ñu yɨhɨ́ cuenda Cristo nya Jerusalén. Ta ra Bernabé ta ra Saulo chinyaca̱ ra xuhun cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ta quɨvɨ cuan quichaha̱ chica nyicon rey Herodes chi suhva ñu yɨhɨ́ cuenda ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ta tachi̱ ra tyiño vatyi na cahñi ra chi ra Jacobo yañi ra Juan chihin mityi. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta nyehe ra Herodes vatyi tahan xaan iñi ñu Israel cha sacuvi̱ ra tyicuan caa, ta tyihi̱ ra tyiño vatyi tɨɨn ndɨhɨ ra chi ra Pedro. Ta cuví chi noo quɨvɨ vico pascua nu tuhva ñu chachi ñu pan cha ñahri yuchan iya yɨhɨ chihin. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cha yaha̱ cha tɨɨ̱n ra chi ra Pedro, tyihi̱ ra chi ra vehe caa. Ta cumi ityi sɨndaro sahá cumi chi ra. Ta cumi sɨndaro cha noo ityi ra ta sahá cuenda ra suhva suhva cuhva chi ra. Ta tyaa̱ ra Herodes cuhva vatyi nayahá vico cuan ta cucuhva cuenda ra chi ra chi ñáyɨvɨ. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ta tyicuan caa ñohó ra Pedro vehe caa. Ta sɨndaro cuan sahá cumi vaha xaan ra chi ra. Soco cha nɨ ri ca cha ñohó ra yucuan, ñu yɨhɨ́ cuenda ra Cristo chicán tahvi xaan ñu nyita cuii ri maa cha cuenda ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta tyaá ra Herodes cuhva vatyi cha ñaha ri inga quɨvɨ cuan cutava ra chi ra Pedro nuu ñáyɨvɨ. Ta suri cha cuaa cuan ra Pedro quixí vavaha ra mahñu uvi sɨndaro cuan. Ta nuhñí ra chihin uvi cadena. Ta uvi ca sɨndaro canyicú ra yuvehe casahá cumi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta tañi ri ta tuvi̱ noo ángel cha tachi̱ Sutu Mañi yo. Ta ndundichin ri chichi vehe caa cuan. Ta ángel cuan tɨɨ̱n ra xiin ra Pedro. Ta sandoyo̱ ra chi ra. Ta catyí ra chi ra: ―Sa̱numi. Ndɨ̱cuita ―catyi ángel cuan chi ra. Tyicuan ta ndachi̱ cadena cha nuhñi ndaha ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ta ángel cuan catyí ra chi ra: ―Na̱cuhñi vaha chichun ta na̱tyihi ndichan chahun ―catyí ángel cuan. Tyicuan caa sacuvi̱ ra Pedro. Ta catyí ángel chi ra: ―Que̱hen sahmon ta tya̱un chaton ta qui̱chun chate ―catyí ángel cuan chi ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ta ra Pedro quita̱ ra chata ángel cuan. Soco ña chitó ra tatu cha ndicha o cha ña ndicha cuví cuan, ta cuñi maa ra vatyi visión nyehé ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Soco cuahan ra chata ángel cuan ta cayaha̱ ra noo nu sahá cumi sɨndaro. Tyicuan ta cayaha̱ ra inga tucu nu casahá cumi sɨndaro cuan. Yaha̱ cuan ta chaa̱ coyo ra yuvehe caa cahnu nu quita ñáyɨvɨ ta quɨhvɨ ñu chichi ñuu. Ta yuvehe cuan nuña ri maa. Ta quita̱ coyo ra. Ta cha yaha̱ yaha ra noo ityi cahnu, ta sandoo̱ ángel cuan chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tyicuan ta nacoto̱ ra Pedro vatyi ndicha ta quichaha catyi ra: ―Ndicha, ñima visión cuvi. Soco maa Sutu Mañi yo tachi̱ ra noo ángel vatyi sacacu̱ ra chii ndaha ra Herodes ta ndaha ra Israel ―catyí ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chicá xiñi ra tuhun ihya ityi cuahan ra. Ta chaa̱ ra vehe cu María sɨhɨ ra Juan Marcos. Ta cuaha xaan ñu canyicú cuan chicán tahvi ñu chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ta cuhva cha sacacha̱n ra Pedro yuvehe nuquehe, quita̱ noo ñaha tyivaa cha nañí Rode chinyehe ña yóó cha sacachan cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Soco cuhva cha nɨcohon soho ña ndusu ra Pedro, ña nuña̱ ña yuvehe. Vatyi sɨɨ xaan cuñí ña, ta chino ña cua nacatyi ña. Ta catyí ña vatyi ra Pedro nanyaá ra yuvehe. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tyicuan ta quichaha catyí ñu chi ña: ―Loco yoho ―catyí ñu chi ña. Soco ña cuan catyí ña vatyi ndicha cha cahán ña. Soco ñu cuan catyí ñu tyi ñima ra Pedro cuví ra, soco ángel cuenda ra cuví, catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta ra Pedro sañihí ca ra sacachan ra yuvehe. Ta cuhva cha nuña̱ ñu ta nanyehe̱ ñu chi ra, iyo xaan cuñi̱ ñu ta yuhvi̱ ñu cuvi̱. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Soco savaha̱ ra seña chihin ndaha ra nacutaxin ñu. Ta nacatyi̱ ra chi ñu yoso caa tava̱ Sutu Mañi yo chi ra vehe caa. Ta catyí ra chi ñu: ―Na̱catyi ndo chi ra Jacobo ta chi inga yañi yo ―catyí ra. Ta quita̱ ra ta cuahan ra inga ityi. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuhva cha cundichin, iyo cacuvi sɨndaro cha sahá cumi chichi vehe caa cuan, vatyi ña cachitó ra yoso caa quita̱ ra Pedro. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tyicuan ta tachi̱ ra Herodes cunanducu chi ra. Ta vatyi ña nañihi̱ ra chi ra, tyicuan ta tachi̱ ra na cacahñi ra chi ra sahá cumi vehe caa cuan. Yaha̱ cuan ta quita̱ ra Herodes ityi Judea cuan ta cuahan ra ñuu Cesarea cuacoo ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ta ra Herodes cuxaan xaan ra chihin ñáyɨvɨ ñuu Tiro ta ñáyɨvɨ ñuu Sidón. Soco cuñí ñu cuan nduvaha coo ñu chihin ra vatyi ñuu cha nyacá ñaha ra yucuan quitá cha cachi ñu. Tyicuan ta ndu ɨɨ̱n ri ñu ta cuahan coyo ñu cuacutahan ñu chihin noo ra cha nañí Blasto. Ican ra sahá cuenda chi ra Herodes. Ta chicán ñu cha nduvaha coo ra Herodes chihin ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tyicuan ta catyí ra Herodes vatyi cuhun ñu nu nyaá ra noo quɨvɨ. Ta chaa̱ quɨvɨ cuan ta ndɨhvɨ̱ noo ra sahma tyiño ra. Ta chicunyaa ra nu tyayu cahnu ra. Ta caha̱n noo ra nuu ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tyicuan ta quichaha canachaa̱ ñáyɨvɨ, ta catyí ñu: ―Ra cha cahán ihya ñima noo rayɨɨ ri cuví ra. Nyoo cuví ra ―catyí ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ta caa cuhva ri cuan noo ángel Sutu Mañi yo chaha̱ ra noo cuehe chi ra Herodes vatyi chaha̱ ra cha catyi̱ ñáyɨvɨ tyi Nyoo cuví ra. Ta quɨhvɨ̱ tɨndacu chi ra, ta chihi̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Soco tuhun Nyoo cuahan chitya ca. Ta caha̱n ñu tuhun Nyoo tandɨhɨ ri ityi. ");
INSERT INTO mxtNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Quɨvɨ cha ndɨhɨ̱ tyiño saha ra Bernabé ta ra Saulo nya Jerusalén, cuanuhu coyo ra ñuu Antioquia. Ta cuahan tucu ra Juan Marcos chihin ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Vehe ñuhu Antioquía cuan iyó ra cacuví profeta Nyoo. Ta iyó tucu ra cha sañahá tuhun Nyoo chi ñáyɨvɨ. Ta sɨvɨ ra cuan ican cuvi ihya: Ra Bernabé, ra Simón Toon, ra Lucio ra ñuu Cirene, ra Manaén cha chahnu̱ ɨɨn ri chihin ra Herodes cha cuví rey ityi Galilea, ta ra Saulo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ta noo quɨvɨ nyicú tandɨhɨ ra ta casacahnú ra chi Sutu Mañi yo. Ta casahá ra ayunar: ña cachachi ra ta cananducu ra chi Nyoo cuví cuan. Tyicuan ta catyí Tatyi Ii chi ra: ―Ta̱va sɨɨn ndo chi ra Bernabé ta ra Saulo cha cuenda tyiño cha cané chi ra ―catyí Tatyi Ii chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tyicuan ta cha ndɨhɨ saha ra ayunar, ta catyiso̱ ra ndaha ra sɨquɨ ra, ta cachica̱n tahvi ra chi Nyoo cha cuenda ra. Ta cacahan ra chihin ra tahan ra ta cuaha̱n coyo ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaha̱ cuan tachi̱ Tatyi Ii chi ra Bernabé ta chi ra Saulo noo ñuu cha nañí Seleucia. Tyicuan ta cuahan coyo ra. Ta yucuan caquɨhvɨ̱ ra chichi noo barcu ta cuaha̱n ra nya ñuhú Chipre cha nyaa mahñu tyañuhu. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yucuan ta cachaa̱ coyo ra noo ñuu yuhu tyañuhu cha nañí Salamina. Ta quichaha̱ cahan ra tuhun Nyoo vehe ñuhu ra Israel. Cuaha̱n tucu ra Juan chihin ra vatyi tyinyee ra chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tyicuan ta cuahan coyo ra cahán ra tuhun Nyoo noo noo ñuu cha nyaa Chipre cuan nyacua nya chaa coyo ra ñuu cha nañí Pafos. Ta yucuan nañihi ra chi noo ra Israel cha nañí Barjesús. Ta chitó ra tuhun tasɨ́. Cuví ra noo ra cuendu vatyi catyi ra vatyi cuenda Nyoo cahán ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ta ra tasɨ cuan nyaá ra chihin gobernador Sergio Paulo. Ta ra Sergio cuví ra noo ra cachi iñi. Ta cana̱ ra chi ra Bernabé ta chi ra Saulo, vatyi cuñí ra cuɨñɨ ra tuhun Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ta ra tasɨ cuan nañí tucu ra Elimas, ta chasɨ́ ra nu chino iñi gobernador cuan chi ra Cristo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tyicuan ta ra Saulo cha nañí tucu Pablo, tyitú ra chihin Tatyi Ii. Ta nyehe̱ vavaha ra chi ra Elimas cuan. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ta catyí ra chi ra: ―Yoho ra sandaví ñaha, cuendu xaun. Sehe cuihna cuví chuun. Ta cuñún satɨvun tandɨhɨ cha vaha. Ta tyicuan ri chasún ityi vaha Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ta vityin Sutu Mañi yo cutachi tuñi ra chuun, vatyi cunducuaun. Ta ma cuvi nyehun ñuhu̱ ñanyii suhva quɨvɨ ―catyí ra Pablo chi ra Elimas. Tyicuan ta caa cuhva ri cuan ta nducuaa̱ ra. Ta ndoo̱ ra nu ñaa iñi. Ta nducu̱ ra noo ra tɨɨn ndaha ra vatyi ña ndichin ca nyehé ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cuhva cha nyehe̱ gobernador cuan cha cuvi̱ chi ra Elimas, chino̱ iñi ra chi ra Jesucristo. Vatyi iyo cuñi ra nyehe ra cha sañahá Sutu Mañi yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ra Pablo ta ra tahan ra quɨhvɨ̱ ra chichi noo barcu ñuu Pafos. Ta cuahan coyo ra nya ñuu Perge ityi Panfilia. Soco ra Juan Marcos sandoo̱ ra chi ra ta cuanuhu ra nya Jerusalén. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yaha̱ cuan ta caquita̱ ra Perge cuan, ta cuahan coyo ra ñuu Antioquía cha nyaá ityi Pisidia. Yucuan quɨhvɨ̱ coyo ra chichi vehe ñuhu ñu Israel ta cuví chi noo quɨvɨ nyitatu ñu. Ta chicunyicu̱ ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tyicuan ta quichaha̱ sacuaha ñáyɨvɨ nu libru ley cha tyaa̱ ra Moisés. Ta sacuaha̱ tucu ñu libru cha tyaa̱ ra cacuvi profeta Nyoo ta cha naha. Yaha̱ cuan ta ra cacuví nuu vehe ñuhu catyi̱ ra chi ra hermano nyicú cuan, vatyi tatu iyó noo tuhun cuñí ra cahan ra chihin ñáyɨvɨ, cuví cahan ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tyicuan ta ndɨcuita̱ ra Pablo ta sacuvi̱ ra noo seña chihin ndaha ra vatyi na cutaxin ñu. Ta catyí ra: ―Cuɨ̱ñɨ ndo nyoho ra Israel, ta nyoho cha quichahá ndo chi Nyoo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyoo cuenda yo, ñu Israel, nacachi̱ vaha ra chi sutu chahnu yo. Ta quɨvɨ cha iyó ca ñu ityi Egipto sacuvi̱ ra noo ñuu cahnu chi ñu. Vasɨ ñima ñáyɨvɨ ñuu cuan cuví ñu, soco sanducuaha ra chi ñu. Yaha̱ cuan ta tava̱ ra chi ñu ityi cuan chihin tunyee iñi chi ra. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ta cunyee̱ iñi Nyoo tandɨhɨ cuhva chiyo̱ ñu nu chicá noo ñu ñuhú ityi chichi cha uvi xico cuiya. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ta sanaa̱ ra ucha tahan ñuu nahnu cha chiyo̱ nɨcahnu Canaán, vatyi chaha̱ ra ñuhú cuan chi sutu chahnu yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yaha̱ cuan ta sacuvi̱ Nyoo vatyi cunyaca ñaha maa maa ri juez chi ñáyɨvɨ cuan. Tari noo cumi ciento sɨsava cuiya chinyaca̱ ñaha juez chi ñu nyacua nya quɨvɨ chinyaca̱ ñaha ra profeta Samuel chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tyicuan ta maa ñu chica̱n ñu noo rey cha cunyaca ñaha chi ñu. Ta Nyoo chaha̱ ra chi ra Saúl sehe ra Cis chi ñu, vatyi cunyaca ñaha ra chi ñu. Ta ra Saúl vachi ra tata ra Benjamín. Ta uvi xico cuiya chinyaca̱ ñaha ra chi ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yaha̱ cuan ta Nyoo tava̱ ra chi ra Saúl cha cuví ra rey. Ta chaha̱ ra vatyi cuvi ra David rey. Ta catyí ra: “Nyehí vatyi ra David sehe ra Isaí cuví ra noo rayɨɨ cha tahán iñi cuhva iyó. Ta cusacuvi ra tandɨhɨ cha cuñí yuhu”, catyí Nyoo tuhun ra David. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ta minoo ra vachi tata ra David cuan ican cuví ra Jesús. Ta maa Nyoo tachi̱ chi ra vatyi sacacu ra chi yo ñu Israel, tari catyi̱ ra chi sutu chahnu yo. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ta cumañi ca quichi ra Jesús, ra Juan ra sacondutya chi ñáyɨvɨ caha̱n ra nuu tandɨhɨ ñáyɨvɨ Israel. Ta catyí ra chi ñu vatyi cuñí chi cha ndu uvi iñi ñu cuatyi ñu, ta condutya ñu. ");
INSERT INTO mxtNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ta cha cuandɨhɨ tyiño saha ra Juan ta catyí ra: “¿Atu cuñí maa ndo vatyi yuhu cuví noo ra cahnu cha saquichi̱ Nyoo? Soco ñima yuhu cuví ra cahnu cuan. Vatyi chata cha yaha̱ yuhu ta vachi n