﻿USE sofia;
DROP TABLE IF EXISTS sofia.mwp_vpl;
CREATE TABLE mwp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mwp_vpl WRITE;
INSERT INTO mwp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mina kulay kaypaypa nanga, Awgadh matha Awgadh meparu. Nuydh koeykoeyne za aymoemoedhin dapar a nubi gugu ubidh thoeyayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Boeradharoeginga kasa inur matha malu, Awgadhaw Maygi Marin mura kangur poegamoeyz ina mer senawbi thonara woerngu poediya, ngoedhe uruy boethan palgin. ");
INSERT INTO mwp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Awgadhan nungu woenabal yangukudu guythuyadhin kedha, buyapa nagaypa. Wa, senabi thonara buya nagaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nuydh nanga imadhin, nubepa matha ngoedhagidh. Kalanu nuydh Awgadhan buya adhapa sig thamadhin inurngu. ");
INSERT INTO mwp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nuydh buya nel tharadhin ‘Goeyga’ a inur nuydh nel tharadhin ‘Kubil’ senawbi goeyga kubil yabay thayadhin. Bathaynga na goeyga nanga ukasar goeyga gasamoedhin urapu goeyga yabay thoeyayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Kalanu Awgadhan nungu woenabal yangukudu guythuyadhin kedha, ‘Gugu ubidh thoeyayzinga aymaypa, woerpa dhadhiya moeypa ukasar yaynanob loegiya gimal a apal.’ Wa, gugu ubidh thoeyayzinga senabi thonara aymaydhin. Nuydh nanga Awgadhan gugu ubidh thoeyayzinga bokadhanga aymoedhin nadh woer dhadhiya madhin gimal a apal. ");
INSERT INTO mwp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nuydh Awgadhan senabi gugu ubidh thoeyayzinga kedha nel tharadhin ‘Dapar’ senawbi goeygoey kubil yabay thayadhin. Bathaynga goeygoey buya mangaydhin senaw goeyga thoeri gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Awgadhan nungu woenabal yangukudu guythuyadhin kedha, woerpa urapu doegamunu garwoeydhamoeypa dapara apal, na kay boeradhar sama woeydhoemipa. Senabi thonara na woer urapu doegampa garwoeydhamaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Awgadhan nan woerngu lag nel tharadhin ‘Malu’ a sena nanga sama woeydhayzinga nuydh kedha tharadhin ‘Boeradhar’ nubepa moetha ngoedhagidh nuydh nanga imadhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kalanu Awgadhan nungu woenabal yangukudu guythuyadhin kedha, mura nagupa malguy puydhaypa boeradhoerangu, ay nagu kapulmayl a ay puy koewsaw kapulmayl sethabi thonara mura malguy puydhoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Wa, Awgadhan nanga imadhin kedha boeradhoerangu mura nagul a puy koewsal malguy adhadhin nubepa moetha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Senawbi goeygoey kubil yabay thayadhin bathaynga goeyga miyaydhin goeyga gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kalanu Awgadhan nungu woenabal yangukudu guythuyadhin kedha, danakitul aymoeypa goeygipa adhapa thoemaypa kubilngu a mura thonarpa seysithamaypa goeygil, wathal, nagu uthuy, ayboewdhu thonarpa thonar tidaypa, dapara gimal. ");
INSERT INTO mwp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","16","Lak bangal thanamun buyan daparngu gimaz nubi apa goewapa buya. Wa, Awgadhan kedha aymoedhin, nuydh ukasar koey danakitu aymoemoedhin, goeyga a moelpal goeyga goeygipa buya a moelpal kubilpa buya; nuydh wara thithuyl aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nuydh sethabi danakitul zuru poethaypa dapara gimal wanamoeydhin nubi apaw goewapa buya mekath. ");
INSERT INTO mwp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Matha goeyga buya kedha goeygipa goeyginu noegaypa zurupoethaypa a moelpal kubilpa, goeygingu adhapa thoemaypa. Awgadhoepa moetha ngoedhagidh nuydh nanga imadhin. Wa, Awgadhan adhapa sig thamadhin buya inurngu. ");
INSERT INTO mwp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Senawbi goeygoey kubil yabay thayadhin bathaynga goeygoey buya mangaydhin senaw goeyga payb gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Awgadhan nungu woenabal yangukudu guythuyadhin kedha, ‘Mura malu uruypa koeygoesar aymoeypa sew malunu muynu igililmayl a boethal uruypa gimal lak kedha koeygoersar sey, imaygasiw.’ ");
INSERT INTO mwp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Wa Awgadhan mura malu uruyl aymoeydhin koey uruyl a moegina uruyl, a kasa mura wapil malunu muynu a kasa mura boethal uruyl boeradharoenu gimal; thana mura yaynanob matha ngoedhagidh thanamun kazipa koesimaypa. Nubepa Awgadhoepa matha ngoedhagidh nuydh nanga imadhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nuydh kalanu woenab poeybadhin, a mulaydhin kedha, ‘Wapil senaw bangal malu mura kangur pagamidhe.’ A nuy lak gimal uruypa kedha mulaydhin, ‘Senaw bangal gimal ngithamuniya yabay thoeyaypa manine.’ ");
INSERT INTO mwp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Senawbi goeygoey kubil yabay thayadhin a bathaynga goeygoey buya mangaydhin senaw goeyga siks gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Awgadhan lak nungu woenabal yangukudu guythuyadhin kedha, boeradhoeranu kasa mura uruypa aymoeypa; lagaw uruyl a bupaw koey uruyl a moegina uruyl. ");
INSERT INTO mwp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Awgadhan thana mura aymoeydhin, a nubepa moetha ngoedhagidh nuydh nanga imaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kalanu nuy Awgadh kedha mulaydhin, ‘Wa, ngalpa kay mamu a mabayg aymoempa, palay bal ngoedhe ngalpan ngoedhalnga a palay bangal wapiya, boethal uruya, matha kedha tetel uruya, ngaru bangal gimal lagaw uruyl a bupaw uruyl, koey uruyl a moegina uruyl.’ ");
INSERT INTO mwp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Awgadhan kalanu mabayg aymoemoedhin nungu ngoedhalnga. Nuydh aymoemoedhin garkaz a yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kalanu Awgadhan palamulpa woenab poeybadhin a kedha mulaydhin, ‘Koeyma bangal kazil gasamidhe, lak bangal thana mura doegamuya nithamoene thabi gugu ubidh thoeyayzimaynu; a mura zapul bangal thanamuniya apal. Ngath ngipel mura wapil, a uruyl boethalmayl, bupaw uruyl danal poethay mabayg aymoeman. ");
INSERT INTO mwp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ngath ngipel mura seysithamaypa ay puy nagu kapul, a ay puy koewsal yadu poelagiz aygudoepa. ");
INSERT INTO mwp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kasa kay kedha, setha nanga mura bupaw uruyl a boethal uruyl, ngath thanamulpa bupal a koey nisal aygudoepa mamayidhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Awgadh kalanu adhanagaydhin nungu zagethoepa; nuydh imadhin kedha, nubepa adhapudhay koey matha ngoedhagidh. Senabi goeyga, kubil yabay thayadhin, bathaynga goeygoey buya mangaydhin, sena goeyga seben gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Wa, nuydh nubi gugu ubidh thoeyayzinga mura muwasidhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Goeyga seben nanga Awgadh ngoena pudhaydhin, nungu zageth mura muwasidhin nubi gugu ubidh thoeyayzinga nuydh na aymoedhin nuy kulay mi zagethan nanga meparu. ");
INSERT INTO mwp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nuydh nan adhapa thamadhin, nubepa goeyga woenabalnga. Minguz kedha nuy senawbi goeyginu ngoena pudhaydhin mura nubi gugu ubidh thoeyayzimay zagethoengu; nan mina muwasidhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Senaw nuy kedha kuniya nubi gugu ubidh thoeyayzinga sama woeydhadhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Wa, nuydh Awgadhan nubi gugu ubidh thoeyayzinga nanga aymoedhin, boeradhar wara zaginga puyginga, wara kedha kasa kobegadh puy kapul malguy adhayginga, minguz kedha nuydh Awgadhan ari woeyayginga, a wara mabaygoeginga boeradhoeraw zagethoepa. ");
INSERT INTO mwp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kasa kay kedha woer nanga apaz kadaypa nan boeradhar woernu mayparu boeradhoeraw poediya. ");
INSERT INTO mwp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Awgadhan kalanu mabayg aymoedhin boeradhoerangu, nuydh igilaw gub poeybadhin pitiya nungu aymoeyzi mabaygiya nuy mabayg kalanu igililnga aymaydhin ngoena woelaylnga ngalpa midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Awgadhan mamu a apaw lag aymoedhin nanu nel Edhoen sager doegamunu, nuydh kalanu nungu aymoeyzi mabayg si wanadhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nuydh kasa mura puyl aymoeydhin mina kapu ngoedhalmayl a, kapu gamulmayl, a aypuyl koewsalmayl. Mina matha dhadhal nanga senabi apaw loegoenu ukasar puy, wara puy nuy igilaw puy, a wara puy mura ngulaygaw puy. Nuy mura ngulayg poeybaypa kedha, mina pawa midh a wati pawa midh. ");
INSERT INTO mwp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Senabi apaw lagiya nanga, koesa adhiya pungaypu nadh mura apaw lag woernu mayparu kalanu nabiya Edhoeninu nanga na kasa dhadhiya miyaydhin po koesal aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Koeykoeyne koesa nel Pison; na mura yoewdhepu Abelaya. ");
INSERT INTO mwp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Kapu bamagadh koethil kulal ngalagaz nanga imaydhin, a dhuray kapu gamul koethil kulal a kapul ganul zapul.) ");
INSERT INTO mwp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wara koesa nanga nanu nel Geyon, na yoewdhepu nanga lag nel Kus sike adhiya. ");
INSERT INTO mwp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ukamodhabayg koesa nanga nanu nel Tigris; na yoewdhepu Asiriya sager doegamuya a po koesa nanga nanu nel Ewprates. ");
INSERT INTO mwp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nuydh Awgadhan kalanu senawbi garkaz wanadhin apaw lag nel Edhoen zagethoepa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Awgadh kedha mulaydhin nubepa, ‘Itha mura puy koewsal ngibepa aygudoepa ubipa apaw loegoenu. ");
INSERT INTO mwp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Matha senawbi puy lawnga, mina ngulaygaw a wati ngulaygaw puy koewsal ngalaga nanga puydhemipa. Ngidh bangal purthayg. Ngidh bal nanga purthane ngi bangal senawbi goeyginu um medhedhe.’ ");
INSERT INTO mwp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kalanu nuy Awgadh kedha mulaydhin, ‘Garkazoepa matha ngoedhagidh lawnga nungu kusayg moeypa, ngath bangal nubepa wara kapu ngoedhal igalayg aymoene nubepa ibupuydhaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nuydh kalanu boeradhoer garwoeydhamoedhin a mura kay kedha ubipa uruyl aymoeydhin tetelmayl a boethalmayl kalanu nuydh nungu aymoeyzi mabaygoepa imaypa kusumoedhin nubepa nel thoeraypa. ");
INSERT INTO mwp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kalanu nuydh nungu aymoeyzi mabaygan mura nelay tharaydhin tetel uruyl a boethal uruyl, kasa kedha thanamulngu wara kedha urapun matha ngoedhagidh lawnga nubepa pasiw puzi mabayg, a nubepa ibupuydhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Wa, Awgadhan midh madhin, uthuy yoewthadhin nungu aymoeyzi mabayg a kalanu bero ridh adhapa madhin, a nan kay pisuypa gudmathamoedhin kuniya goengaw. ");
INSERT INTO mwp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nuydh sizi berongu yoepkaz aymoedhin kalanu nuydh nan nubepa oengaydhin imaypa. ");
INSERT INTO mwp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nuy mabayg kedha mulaydhin, ‘Mina kuthapa kay, ngaw ridhangu mina ngaw ngoedhalnga a ngaw goengawlngu.’ Nuydh nan kedha tharadhin yoepkaz. Minguz kedha nan nungu gamungu aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kedha zoenguz garkazin kayb apuwal thathil wanepa a yoepkaziya garwoeydhamoeypa, kalanu palamun gamu urapun aymiz ");
INSERT INTO mwp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Garkaz a yoepkaz palay kulay kasa kupal palamun gamu wara zaginga sepalbi thonara palay kidhakidhan azirgig. ");
INSERT INTO mwp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Awgadhan nanga mura uruyl aymoeydhin boeradharoenu gimal, mura balbayginga. In nanga nuy thabu nuy mabaygaw koey dhipa yoewthaylayg. Wara thonara nanga nuy thabu yoepkazipa yapupoeybaydhin kedha, ‘Awgadhaw yangukudu ngipelpa midh, nuydh lawnga mamamoedhin puy koewsaw purthayle senabi apaw lagoenu a?’ ");
INSERT INTO mwp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Na yoepkaz kedha mulaydhin nubepa kuniya, ‘Lawnga, mura puy koewsapa aygudoepa matha ngoedhagidh, ");
INSERT INTO mwp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kasa kay kedha Awgadh kedha mulaydhin ngalbelpa, “Urapun puy koewsa sey apaw laganu dhadhal poegaypa, ngipelpa aygudoepa lawnga, a gethan gasamoeyle lawnga. Ngipel bangal nanga gethan gasamoene nanga purthane nanga ngipel bangal umanga.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nuy thabu nabepa yoepkazipa kuniya kedha mulaydhin, ‘Sena mina yangukudu lawnga, ngipel bangal nanga purthane, ngipelpa umapa lawnga, ");
INSERT INTO mwp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","a wara kedha ngipel bangal koey ngulayg mabayg Awgadh midh nanga. Nuydh Awgadhan kedha zoenguz ngipel lawnga mamamoedhin, ngipelngu mura zangu ngulayg oesile, nuy midh nanga mura zangu koey ngulayg, gegeyadh ngalaga a balbayginga ngalaga.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wa, nadh nanga yoepkazin senawbi puy koewsa imadhin nabepa mina kapu gamulnga, nanu mamu gud woer wayadhin, na kedha, ‘Ina mina matha ngoedhagidh kedha, lak bangal ngay koey ngulayg.’ Kalanu nadh urapun paradhin a purthadhin. Kalanu nadh nanu alaypa madhin a nuydh purthadhin. ");
INSERT INTO mwp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Palay nanga purthadhin nanga senawbi puy koewsa, palay palamulngu ngulayg asimoedhin kedha, palay kasa kupal. Kalanu palay koey nisal tharpamoeydhin palamulpa gamupa woerdhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Senawbi goeygi kutapa nanga palay karngemidhin kedha, Kuykulmay mabaw yal, nuy sike apaw loegiya mab woelmay. Palay nanga karngemidhin, palay kasa ziziginga thuma asimoedhin bupanu kalanu. ");
INSERT INTO mwp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kasa kay kedha nuy Awgadh wal miyaydhin Adhamalpa kedha, ‘Adham, ngi nagalaga?’ ");
INSERT INTO mwp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nuy Adham kedha mulaydhin, ‘Ngath nginu yal karngemidhin kedha, ngi kay apaw lagoenu, ngay nginungu akan uthema, kedha zoenguz kedha, ngay kasa kupal.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nuy Kuykulnga Adhamalpa kedha kuniya mulaydhin, ‘Ngi midh paru ngulayg kedha, ngi kasa kupal. Ngidh sikedh senawbi puy koewsa purthanu, ngath ngin mi puy koewsangu nanga aygudangu lawnga madhin a?’ ");
INSERT INTO mwp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nuy Adham Kuykulmaypa kuniya kedha mulaydhin, ‘Sena nadh ngayapa aygudoepa manu, ngidh ngayapa mi yoepkaz nanga ina ngaybiya wanadhin. Wa, kalanu ngath purthadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kalanu nuy Awgadh nabepa yoepkazipa buwayl thayaydhin a, kedha mulaydhin, ‘Minguz ngidh senabi za aymoenu?’ Na kuniya kedha Kuykulmaypa mulaydhin, ‘Senaw nuydh thabun ngoena nuthanu kedha puy koewsapa purthaypa. Kalanu ngath purthanu.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kalanu Awgadhan mina wati kuth madhin thabupa kedha, ‘In bangal nubi kuth gegeyadh matha ngibepa, mura lawnga itha boeradharaw uruyl. Koezi kayboengu kuykayman, ngi bangal mulupa gud maythal amaypu, ngi bal nginu igilaw kuthalpa wara poeyn purthaypu. ");
INSERT INTO mwp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ngi a yoepkaz ngath bangal ngipel wati igalayg aymoemoene, a matha kedha nanu kaziw kazil a nginu kaziw kazil. Wara nanu kaziw kazingu bangal, nginu kuyk moegithap mayparuy a ngidh bangal nanga nungu ngaranu thoeydhaypa meparuy.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Awgadhan lak mulaydhin yoepkazipa kedha, ‘Ngath bangal nginu kazimay kikir mapu poelaypu, se kasa midh ngi bal ngaru nginu alaypa ubin meparu, a nuy bangal ngaru nginu kuyk.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kalanu Awgadh garkazipa mulaydhin kedha, ‘Ngidh nginu ipipa karngeminu, a senawbi puy koewsa purthanu, ngath ngin mi puy koewsangu nanga lawnga madhin aygudangu. Koezi kayboengu kuykaymay, ngidh bangal kasa mag ngoena kikir gasampu nginu aypa zapa gasamoeypa, a matha ngoedhagidhoepa gasamoeypa; kedha zoenguz kedha kuyk nginu gegeyadh ngibepa, nginu boeradharaw zageth koey mapunga. Koezi pawpa boeradhar muwayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nabiya bal koeygarsar bup malguy adhaypu pathalnga a ngi bangal wara kasa bupan purathipu. ");
INSERT INTO mwp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ngidh bangal nginu kasa zagethaw ngoedhiya ayde gasampu boeradharangu, kurusipa bangal ngi senawbi boeradharoepa kuniya tidedhe, ngin ngalaga nanga mabayg aymoedhin, a ngi bangal lak kasa boeradhar.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Senabi thonara Adham nungu ipi nel tharadhin Ebb*. Minguz kedha, nan aymoedhin po gubaw gizupa apu. ");
INSERT INTO mwp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Wa, nungu Awgadhaw danal poethay palamulpa kedha, nuydh tetel uruy goengaw poeybadhin palamun gamupa. ");
INSERT INTO mwp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Senawbi Koeliya Awgadh mulaydhin kedha, ‘Wa, nuy mabayg ngoedhe ngalpa nge, kayib koey ngulayg balbayginga ngalaga a gegeyadh ngalaga. Nuyn bangal pa woeyayg wara puy koewasoengu purthayle, igilaw ay puy koewsangu, nungungu ngaru igililmayngu gasamoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kalanu nuyn Adhaman Edanoengu adhapa wayadhin Awgadhan, nungu geth apaw lagaw zagethoepa, nuyn ngalagaz nanga mabayg aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Wa, palay Adham a Eb adhapa wayamoemoedhin nanga Awgadhan angelal wanamoeydhin danal poethaypa. Thanamuniya koey gizul kuyay thurik koey buyalnga gulgupipa, nuydh mura yabugudal thamudhamoeypu mabaygoengu senawbi igilaw puypa gamupa mabale, kedha zoenguz kedha, senaw senawbi puy nuy mina igilaw puy. ");
INSERT INTO mwp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Wa, palay mudhaw lag wara doegamoenu aymoedhin Adham a Eb. Palay na sepalbi kayn mudhaw loegoenu palamun memampu nanga, na Eb nungu maythalayg aymaydhin a nadh kazi madhin garkaz. Na kedha mulaydhin, ‘Ngath balbayginga kazi mangu kuyk Awgadhaw ibupuydhay ngayapa.’ Nadh kedha zoenguz nuyn nel tharadhin Keyn. ");
INSERT INTO mwp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Wagel nanga nadh wara garkaz kazi gasamoedhin, nungu nel Abelu. Palay koey mabayg aymoemoedhin nanga, nuydh Abelu mamuy danal poethay zageth gasamoedhin, a Keyn nuydh apaw lagaw zageth gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ayboewdhu thonar nanga gasamoedhin, Keyn nuydh Awgadhoepa boeradharaw ayde kusumoedhin, nungu eso poeybay Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abelu nungu Awgadhoepa eso poeybay, nuydh kuykuyg kazi mamuy mathamoedhin, a mura mina madhul nuydh Awgadhoepa poeybaydhin. Awgadhoepa koey dhiwalnga Abelu a nungu poeybayzimayl, ");
INSERT INTO mwp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kasa kay kedha nuy ubigasidhin Keynalngu a nungu eso poeybayngu. Keyn nanga ngulayg gasamoedhin kedha, Awgadh ubigig nungu poeybayzimayngu, nungu kasa mura ngurum a nungu parunu mina thuthu woerimoeyzinga, nguruman. ");
INSERT INTO mwp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kalanu Awgadh Keynoelpa yapupoeybaydhin kedha, ‘Keyn, nginu miyaw thoebukir, nginu mingu paru watin oesipa? ");
INSERT INTO mwp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ngidh nay balbaygi za aymoenu, ngi giwl moesalnga nay nagepa, kasa kay kedha ngidh gegeyadh za aymoengu, wati wakay thamamayil kalmel. Sethabi wati wakay thamamayil nginu, thana matha kedha thoeydhayl uruy midh nanga ngibepa koenamoeypa gasamoeypa mina zoengu aymoeyle. Kasa kay kedha ngi bangal koeyma nuthepu senabi wati ngurpay mulupa maypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Lawnga Keyn nuydh Kuykulmay yangukudu ubilnga patidhadhin, nuydh Aboeloelpa yawar madhin kedha, ‘Ngoeba uzarpa zagethaw lagoepa.’ Palay nanga uzarmoedhin, Keyn kedha miyaydhin kuniya buwayl thayadhin, nuydh nungu tukuyap mathamoedhin umapa. ");
INSERT INTO mwp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kalanu Awgadh nubepa Keynoelpa yapupoeybaydhin kedha, ‘Nginu tukuyap ngalaga, Abelu?’ Nuy Keyn kedha mulaydhin, ‘Ngay koerawayg, ngay nungu danal poethay mabayg lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kalanu Awgadh kedha mulaydhin, ‘Sena ngidh mingu mina koey gudal gegeyadh aymoengu? Nginu tukuypaw kulka sena boey ngayapa wal mepa boeradhoeroengu, ngayapa kuniya modhabiya maypa. ");
INSERT INTO mwp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","‘Koezi pawpa ngibepa lak boeradhaw woenaboepa gasamoeypa lawnga, nginu apaw zageth muwasin. Boeradharan nginu tukuypaw kulka wanadhin ngidh nanga nuyn mathamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kedha zoenguz ngidh bangal kasa midh nagu uthuypu ngibepa aypa gasamaypa lawnga senabi boeradharoengu. Ngi bangal kasa badanu dak mathamipu, nubi apaw goewanu.’ ");
INSERT INTO mwp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Nuy Keyn Kuykulmaypa kedha mulaydhin, ‘Ina ngaw kuniya modhab mina koey gudal mapunga ngayapa matha ngoedhagidh lawnga gima thoeridhoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Senaw ngidh ngoena adhapa woeyaypa ngaw dharbaw lagoengu a nginu parungu ngidh ngoena lak kedha adhapa woeyaypa, ngay bangal kasa lagagig uthuypa. Ngay bangal kasa badanu dak mathamipu, a mabaygan ngadh bangal nanga ngoena imane, ngoena bal uma mathamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kasa kay kedha Awgadh nubepa kedha mulaydhin, ‘Lawnga, ngin bangal nanga ngadh mathamoene nanga, seben mura mabaygal bangal nungu doegamoengu modhabiya kuniya mathamoeyne.’ Kalanu Awgadhan Kanana adhapa thamadhin mabaygoengu nungungu uma mathamoeyle. ");
INSERT INTO mwp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kalanu Keyn uzaraydhin Kuykulmay parungu, bupapa adhapa, lag nel Zagathoegi Lag Edanoengu, sageraw doegamoenu. Minguz kedha nuy Keyn senabi thonara amal ziyal. ");
INSERT INTO mwp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nuy Keyn nanga niyaypa yoelpaydhin nungu ipin garkaz kazi gasamoedhin, a nel tharadhin kedha, ");
INSERT INTO mwp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka, nuydh keyn kalanu koey goegath aymoedhin, a nungu kaziw nel tharadhin senabi koey goegath. Enokan garkaz kaziw nel Iradh, a Iradhan garkaz kaziw nel Meyuzawul, a Meyuzawulan kazi Methusela, nuy Lamekon thathi. ");
INSERT INTO mwp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nungu Lamekon ukasar ipi nel Adha a Zila. Lamekon wara ipi ");
INSERT INTO mwp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adha, nadh garkaz kazi madhin nel Zabal. Nungu Zabalan kaziw kazil tetel uruy danal poethay mabaygal aymoeydhin a thanamun uthuy loegal potowakul. ");
INSERT INTO mwp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Zabalan tukuyap nel Zubal a nungu kaziw kazil mura kapu wakayl zoengu sagul poelay mabaygal aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamekon wara ipi nel Zila nadh garkaz kazi madhin nel Thubalkeyn, nuy nanga koey mabayg aymaydhin nanga, nuydh zagithaw rugal aymoeydhin komal malilan, dhuray ayanil. Nungu Thubalkeynan babathaw nel Nama. ");
INSERT INTO mwp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Nuy Lameko nungu ukasar ipipa kedha mulaydhin, ‘Adha a Zila, ngayapa kurusipagemoeriw. Ngath kayn garkaz uma mathamoengu, minguz kedha nuydh ngoena mathamoengu. ");
INSERT INTO mwp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kanana nay mathamoedhin, wa seben mabaygaw igililmayl mayginga nay kuniya modhabipa, ngoena bangal nanga mathamoene ngaw modhabiya bangal sebenti seben mura mabaygal uma mathamoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aboelaniya wagel Adhamaw a Ebaw wara garkaz kazi gasamoedhin. Na kedha Eb, ‘Awgadhan ngayapa nubi kazi mangu Aboelan buthoepa, Keyn ngan na uma mathamoedhin.’ Nadh nuyn kedha zoengu nel tharadhin Seth. ");
INSERT INTO mwp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sethan garkaz kazi nel Enos. Sizi senawbi thonarngu pawpa mabaygan kuykaymaydhin Kuykulmay maygi nel thawmaythu. ");
INSERT INTO mwp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Itha Adhaman kaziw kaziw nelay. Awgadhan nanga mabaygal aymoeydhin nanga; nuydh thana nungu ngoedhalmayl aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nuydh garkaz a yoepkaz aymoemoedhin, woenab poeybadhin palamulpa, a nel tharimoedhin kedha, ‘Ngipel a ngipen kaziw kazil bangal kedha thoeraypu “mabaygal”.’ ");
INSERT INTO mwp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adham nanga 130 wathoelayg aymaydhin nungu ipin kazi gasamadhin, nungu nel Seth. Nuy mina thathiw ngoedhalnga. ");
INSERT INTO mwp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sew kalanu Adham nuy kuykuthalnga uzaraydhin 800 wathoelnga. Senabi dhadhabuthanu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nuydh muwasidhin nuy nanga 930 wathoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sethan nanga 105 wathal aymoeydhin, nuydh garkaz kazi gasamoedhin nel Enos. ");
INSERT INTO mwp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nuy pawpa lak mina koey kuykuthalnga uzaraydhin 807 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nuydh muwasidhin nuy nanga 912 wathoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos nungu nanga 90 wathal gasamoedhin nuydh garkaz kazi gasamoedhin nungu nel Kenan. ");
INSERT INTO mwp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nuy pawpa lak kuykuthalnga uzaraydhin 815 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nuydh muwasidhin nuy nanga 905 wathoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan nanga 70 wathal aymoeydhin nanga nuydh garkaz kazi gasamoedhin, nungu nel Mayalalel. ");
INSERT INTO mwp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nuy pawpa lak kuykuthalnga uzaraydhin 840 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nuydh muwasidhin nuy nanga 910 wathoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Nungu nanga Mayalalelan 65 wathal gasamoeydhin nuydh garkaz kazi gasamoedhin, nel Zared. ");
INSERT INTO mwp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nuy pawpa lak kuykuthalnga uzaraydhin 830 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nuydh muwasidhin nuy nanga 895 wathoelayg aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Zaredan nanga 162 wathal gasamoeydhin nuydh garkaz kazi gasamoedhin, nel Enoka. ");
INSERT INTO mwp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nuy pawpa lak kuykuthalnga uzaraydhin 800 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin, ");
INSERT INTO mwp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nuydh muwasidhin nuy nanga 962 wathoelayg aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enokan nanga 65 wathal gasamoeydhin nuydh garkaz kazi gasamoedhin, nungu nel Methusela. ");
INSERT INTO mwp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nuy pawpa lak kuykuthalnga uzaraydhin 300 wathoelnga, a mura thonara nungu mab ngaru Awgadhiya kalmel. Sethabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Wa, nuy mura thonara Awgadhiya kalmel, nuy nanga 365 wathoelayg aymoeydhin nanga Awgadhan nuyn madhin nubepa a nuy thadhumay asidhin mabaygaw dana buyangu. ");
INSERT INTO mwp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselan nanga 187 wathal aymoeydhin nanga nuydh garkaz kazi gasamoedhin, nel Lameko. ");
INSERT INTO mwp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nuy pawpa lak kuykuthalnga uzaraydhin 782 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nuydh muwasidhin nuy nanga 969 wathoelayg aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameko nanga 182 wathal gasamoeydhin nuydh garkaz kazi gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nuy kedha mulaydhin, ‘Wa, Awgadhan nubi boeradhar kulkub gud wayadhin, a ngalpan kasa mag ngoena kikir, kasa kay kedha nubi kazin bangal kay ngalpan mapunga mura thoew palane.’ Kedha zoenguz Lameko nungu kazi nel tharadhin Nowa. ");
INSERT INTO mwp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuy pawpa lak kuykuthalnga uzaraydhin 595 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nuydh muwasidhin nuy nanga 777 wathoelayg aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Wa, Nowan nanga 500 wathal gasamoeydhin nanga, kalanu nungu nuydh thoeri garkaz kazil gasamoeydhin; thanamun nelay itha kedha, Sem, Am a Zapeth. ");
INSERT INTO mwp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wa, senawbi thonara nanga, mabayg mura thanuraydhin nubi apaw goewanu muynu, yoepkaz kazil lak koeyma. ");
INSERT INTO mwp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Awgadhoepa parul thoeyayzi garkazil thana imaydhin sethabi yoepkazil nanga kapu ngoedhalmayl. Thanamun ngoenakapul asimoeydhin kasa kobegadh yoepkaziya niyaypa yoelpaypa. ");
INSERT INTO mwp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nuydh nanga Awgadhan imadhin kedha, nuy ubigasidhin nuy kedha mulaydhin, matha ngoedhagidh lawnga kedha, mabaygaw igililnga kuykuthalnga, kuthaginga kuykuginga, ngaw maripa mura thonara danal poethaypa nuthan aymoeypa lawnga, koezi pawpa mabaygaw igililnga bangal matha 120 wathoelnga. ");
INSERT INTO mwp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sethabi goeyginu nanga dhuray mina koey gudal kuykuthal koey goeray mabaygal nubi apaw goewanu memayipu. Kalanu nanga dhuray Awgadhoepa parul thoeyayzi garkazil thanamulpa ipil mamayidhin kasa kobigadh yoepkazil thana niyaypa yoelpemidhin nanga thanamun kazil koey nel mabaygal aymoeydhin kazipay ngapa parungu, thanamun gamu magaw mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Awgadhan thanamun ipidhadh gegeyadh imadhin nanga nubi po gubaw gizunu muynu mura mabaygaw wakay thoemamay a ngoenakap ubilmayl mura thonara gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Awgadhaw koerkak badh mina koeyza, nuy kedha mulaydhin, ‘Matha ngoedhagidh kedha ngath kasa nay thana mabaygal aymayginga. ");
INSERT INTO mwp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ngath bangal ngaw aymayzi mabaygal mura adhapa idimoeyne nubi apa goewangu. Ngath adhapa idimoeyne mabaygal, a tetel uruyl, a amayl uruyl, a boethal uruyl. Matha ngoedhagidh kedha ngath kasa nay thana aymayginga mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Senabi thonara matha Nowa Awgadhaw purkapa balbayginga. ");
INSERT INTO mwp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nungu Nowan gidha ina kedha. Nungu kazil matha thoeri, thanamun nelay itha kedha, Sem, Am, a Zapeth. Nowa nungu ngarapudhamay mura balbayginga Awgadhoepa, mura mabaygal lawnga, wara mabaygoeginga Awgadhoepa parul thoeyaypa, matha Nowa kedha Awgadhoepa amadhan nungu ngarapudhamoeynu a nungu mura thonara ya sagul Awgadhiya. ");
INSERT INTO mwp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mura nubi apaw goewaw mabaygal Awgadhaw imaynu kasa ipidhadh gegeyadh. Thana mura thonara thabukir ayimpu, mabaygal umamathamaypu. ");
INSERT INTO mwp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Wa, Awgadh nagaydhin, a nubi apaw goewoepa imadhin nanga wati za muynu mina koeyza, mabaygal wati igililmaynu niparuy. ");
INSERT INTO mwp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Awgadh mulaydhin Nowalpa wara thonara, ‘Ngaw wakay thoemamay kedha ngath bangal nubi po gubaw gizu idimoeyne a mura mabaygal muynu. Minguz kedha, in nubi gugu ubidh thoeyayzinga kasa mura thanamun wati pawa koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","But bangal aymoene ngibepa mina puy badan. Ngidh bal yaynanob uruypa lagal aymoeyne muynu, a nuyn bangal awen pinine woerngu lagiya muya adhiya. ");
INSERT INTO mwp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","‘Nanu kuykuthalnga bangal 133 mital, nanu athadhalnga 22 mital mura, apaz karaypa 13 mital kuykuthalnga. ");
INSERT INTO mwp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Thodh bal aymoene butanu a thoeri dekal a pasagud bangal aymoeyne apal a laganu, a dhadhabuth bangal wanane 44 sentimeter muynu thodhiya apiya. ");
INSERT INTO mwp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ngath bangal sena adhapudhay koey woer wayane, nubi po gubaw gizunu mura mabaygoepa igilzapa dudupoeypa a lagal bangal mura woeray malemine thoerpumoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kasa kay kedha ngath bangal ngibepa yawoedhan aymoene. Ngi a nginu ipi a garkaz kazil a nginu kaziw ipil but bangal wangedhe. ");
INSERT INTO mwp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","‘A ngidh bangal wara mura uruyngu yoepkazin garkazin wangane urapu urapun, tetel uruyngu, a amayl uruyngu, a boethal uruyngu thanamulngu dudupoeyle. Lak bangal thana matha igililmayl butanu muynu, ");
INSERT INTO mwp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","a mura ayde bangal yaynanob malane ngithamulpa a uruypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Wa, Nowa mina mura aymoedhin Awgadh nubepa midh na mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nuydh Nowa nanga butaw aymay muwasidhin, Awgadh wara thonara nubepa mulaydhin kedha, ‘Ngi a nginu ipi kazil a kaziw ipil sew butanu pathemiw. Ngay ngulayg kedha, matha ngi wadhe thulu mabayg nubi apaw goewanu. ");
INSERT INTO mwp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Wa, uruyl lak kedha, ngi mina ngulayg kedha wara tetel uruyl mina poeybayzi zapul ngayapa. Ngidh kedha uruyngu ngibiya kalmel kusumoene seben garkazil a seben yoepkazil. Kasa uruyl nanga, ngidh ukasar ukasar kusumoene, garkaz a yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","‘Wara boethal uruyl lak kedha, thana setha ngaya nanga mina poeybayzi zapul ngayapa, ngidh kedha boethal uruyngu ngibiya kalmel kusumoene, seben garkazil a seben yoepkazil. Ngidh bangal kedha aymoene thanamulpa igil poelaypa, kurusipa bangal thana yaynanob kazil mamayine thabi apaw goewanu. ");
INSERT INTO mwp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Seben goeygil waniz koezi, ngath bangal ari wayane, poti goeygilnga a poti kubiloelnga mura igilzapa umamathamaypa, mura ngaw oeymayzimayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Wa, Nowa mina mura aymoedhin Awgadh nubepa midh na mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Lagaw thoerpumay woer nanga wayadhin, sethabi thonara Nowan wathal 600 mura. ");
INSERT INTO mwp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuy a nungu ipi a nungu garkaz kazil, a thanamun ipil mura but wangaydhin, thanamulngu wara dudupoeyle. ");
INSERT INTO mwp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","A mura uruyngu yoepkaz a garkaz but wangaydhin Nowaniya, setha mi uruyl nanga Awgadhoepa poeybaypa balbayginga a wara uruyl thana mura wangaydhin Awgadh midh na mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Wa, Awgadh kulay mulaydhin wagel kay na za aymaydhin, seben goeygiw kaliya lagaw thoerpumay woer wayaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Wa, nuy Nowa senabi thonara 600 wathoelayg, thanamun wathaw a moelpalaw thonaral kedha ukasar moelpal nanga, numela goeyga sebentin, mura boeradharaw muy ngukil boeradharal yoelgamoeydhin a ariw nguki gimaz mulupa mina koeyma payoewdhaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","A senabi ari matha woeydheypu poti goeygilnga a poti kubiloelnga. ");
INSERT INTO mwp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Senawbi goeyginu nanga thana mura muynu nge butanu, Nowa, nungu ipi, nungu thoeri garkaz kazil Sem, Am, a Zapeth, a thanamun ipil, ");
INSERT INTO mwp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","thanamuniya kalmel mura uruyl, thubudh uruyl, bupaw uruyl, moegina uruyl, a koey uruyl, kasa mura boethal uruyl, ");
INSERT INTO mwp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","yoepkazil a garkazil mura yaynanob uruyngu but wangaydhin, thanamun mura yaynanob uruy igililnga danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Wa, senawbi goeyginu nanga thana mura muynu nge Awgadh midh nanga mulaydhin. Kalanu nuydh Awgadhan koey butaw pasa gud thamudhoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Senabi ari mina gegeyadh gamu tharaydhin poti goeygilnga, woer malu asidhin, thanamun but pulaloedhin. ");
INSERT INTO mwp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Woer malu asidhin, nuyn but adhanithudhin, nuy kasa bal thayar maluya. ");
INSERT INTO mwp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Woer ngapa kadaypa, koey padal mura wardhamoeydhin, ");
INSERT INTO mwp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","na matha kadaypa woelmay woer, kurusipa na seben mita padaw guyangu kadaypa woerngu padoepa. ");
INSERT INTO mwp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mura igililmayl zapul umamayl, mura boethal uruyl, mura tetel uruyl, a mura amayl uruyl, a mura mabaygal. ");
INSERT INTO mwp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Setha mura ngoenawoelaylmayl kasa umamayl. ");
INSERT INTO mwp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wa, nuydh Awgadhan kedha madhin, kasa mura idimoedhin, mabaygal, uruyl, a boethal uruyl. Igililmayl matha wanaydhin Nowa, nubiya ngaya nanga butanu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Woer matha gimanoeka tharal nanga 150 goeygilnga. ");
INSERT INTO mwp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Awgadhoengu yakanurayginga Nowa a mura uruyl nubiya butanu muynu. Nuydh gub wayadhin woer siyadh mulupa kuyktidaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Setha boeradharaw muy bubul mura wath pathamoeydhin, a dapar gimanoeka gud mathamoeydhin, ari wath pathadhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Woer nanga kuyk tidaydhin Nowan but padanu gimanoeka woeydhadhin moelpal seben numela goeyga sebentin. Senabi koey woer matha siyaydh mulupa nuray 150 goeygilnga. ");
INSERT INTO mwp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Moelpal ten, numela goeyga urapun, senawbi goeyginu padaw goyal kadaypa adhapuydhadhin woerngu poediya, na koey woer matha nuray. ");
INSERT INTO mwp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Poti goeygiw kaliya nanga Nowa gubaw pasa gud pudhadhin a kuwa wayadhin kulay. Kasa kedha nuy kuwa ngapa kuniya tidayginga, nuy kasa adhiya waril, kurusipa woer mura nuraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nowa yan ugadhin kuwa, nuydh wagel mamu ngedh a goeynaw wayadhin imaypa, na midh woer mura nuraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nadh goeynawan imadhin kedha woer matha koeyza, nabepa niyay lagaginga, na kasa butapa kuniya tidaydhin. Nowa nabepa geth yoewdhadhin, a muy thayadhin nan butiya. ");
INSERT INTO mwp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Seben goeygi koeliya nuydh nan lak wayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kutapa nanga na ngapa kuniya tidaydhin, nabiya gudanu kuniya, ay puy koewsaw nis Nowalpa mer. Nowa imadhin, nuy ngulayg asidhin kedha woer mura nuraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuydh mamu lak seben goeygipa ugadhin, kalanu lak goeynaw wayadhin, kasa kedha na kuniya tidayginga Nowalpa. ");
INSERT INTO mwp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nungu nanga Nowan 601 wathal gasamoeydhin numela goeyga urapun a moelpal urapun, senabi thonar woer mura thepadhasidhin. Nuydh Nowa butaw moegina thodh mura gud pudhadhin a gurguy nagaydhin, nuydh imadhin kedha woer mura mulupa miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Numela na gasamoedhin goeyga 27 moelpal ukasar, woer kuniya nanu mina thonara balbayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Awgadh kedha mulaydhin Nowalpa, ‘Seyzi butangu adhapagamoey. Ngi, nginu ipi, a garkaz kazil, a thanamun ipil. ");
INSERT INTO mwp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Setha mura boethal uruyl, a boeradharaw uruyl wara adhapa mamayiw butangu, lak bangal thana mura kazil mamayine thabi apa goewanu muynu.’ ");
INSERT INTO mwp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wa, Nowa nungu ipi, a nungu garkaz kazil, a thanamun ipil mura adhapagoemoeydhin butangu. ");
INSERT INTO mwp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mura boethal uruyl a boeradharaw uruyl lak kedha adhapa poegamoeydhin mamuy mamuyl, a donki donkil, thana mura kedha adhapuydhadhin yaynanob. ");
INSERT INTO mwp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kalanu Nowa olta moeydhadhin uruypa mathamoeypa a Awgadhoepa yoewdhaypa, setha mi uruy nanga Awgadhoepa yoewdhaypa balbayginga apaw boeradharaw uruyngu a gimaw boethal uruyngu. Nuydh thanamulngu mura yaynanob madhul mamayidhin, muypu noegidhoedhin a Awgadhoepa kuniya yoewdhaydhin, senabi oltanu gimal. ");
INSERT INTO mwp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Senawbi poeybayzi madhu ganu nanga Awgadhoepa adhapudhay matha ngoedhagidh. Nuy nubiya muynu kedha miyaydhin, ‘Ngayapa lak kedha ngoedhalnga aymaypa lawnga, nubi apa goewapa lak kuth thoeraypa lawnga mabaygaw gegeyadhoepa. Ngay ngulayg kedha, mura mabaygal thanamun kazimay thonarngu pawpa thanamun wakay thoemamayil kasa mura thonara wati wakay thoemamayil. Ngayapa lak igilzapa, a mabaygoepa kedha zapa aymaypa lawnga ngath miza na aymoedhin, mura idimoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","‘Koezi kayboengu pawpa ngaru bangal thonaralnga, nagu uthuypa, a nagu ayboewdhaw thonarpa, wara bangal kedha naygay thonara, a gabu thonara, goeyga, kubil, wath koeygarsar, kurusipa sey ngalaga nubi gugu ubidh thoeyayzimaynu kuth.’ ");
INSERT INTO mwp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Awgadhan nungu woenab poeybadhin Nowalpa a nungu garkaz kazipa. Nuy kedha mulaydhin, ‘Koeyma bal matha kazil gasamidhe, lak bangal ngithamun kaziw kazil mura thabi apa goewanu nithamoene. ");
INSERT INTO mwp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","‘Mura boeradharaw uruyl, a boethal uruyl, a malu uruyl ngithamulngu bangal akan; thana mura ngithamuniya apal. ");
INSERT INTO mwp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ngithamulpa aygudoepa ubipa, matha kedha boeradharaw ayde, ngath mura ngithamulpa kusuman ayde. ");
INSERT INTO mwp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Urapun za ngitha bal purthayg, ngidh nanga uruy mathaman ngidh ngaru kulka adhapa manin sobaginga, kalanu ngidh purthan. Madhul nanga kulkalmayl ngath lawnga manin ngithamulngu aygudoengu kedha zoenguz kedha senaw kulka nanga nuy mura igilaw za. ");
INSERT INTO mwp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","‘Mabaygaw kulka lak kedha igilaw za, ngitha mabaygaw kulka pay yoewdhayg, minguz kedha nuyn Awgadhaw ngoedhalnga aymoedhin. Ngadh nanga mabaygaw kulka pay yoewdhan, nungu kuniya modhab ngaru kedha, mabaygan kuniya lak nungu kulka pay yoewdhan. A uruy lak kedha, nuydh nanga mabaygaw kulka pay yoewdhan ngath lak kedha kuth poeyban uruypa. ");
INSERT INTO mwp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","‘Ngitha koeyma bangal kazil mamayine, lak bangal thana mura nithamoene thabi apa goewanu.’ ");
INSERT INTO mwp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Awgadh lak mulaydhin thanamulpa, Nowa a nungu garkaz kazil kedha, ");
INSERT INTO mwp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","‘Ina ngath ngaw patidhaygi yawadhan ayimpa ngithamulpa, a ngithamun kaziw kazipa, ");
INSERT INTO mwp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","a setha ngithamuniya kalmel mi igil uruyl nanga adhapa pagamoeydhin butangu, boeradharaw uruyl a boethal uruyl. ");
INSERT INTO mwp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","In nubi yadu ngath ngaw patidhaygi yangukudu ayman ngithamuniya mura parunu. Ngay mina ya muliz kedha, ngayapa lak mura igilzapa woeray dudupoeypa lawnga, ngayapa nubi gugu ubidh thoeyayzimayngu lak woerngu idimoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nubi patidhaygi yangukudupa ngaw, ngithamulpa mina yapathoemaypa, ngitha mabaygal a mura igil uruyl, ");
INSERT INTO mwp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ngath maku ayman dhudhuwab dapara ziyanu gimanoeka, ngithamulpa ngoenanumaypa ngaw patidhaygi yangukudu ngithamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Mi thonara nanga ngath dapar ziyal palan, senabi thonara ngath dhudhuwab nanga iman, ngath ngaw patidhaygi yangukudu ngoenanumanin ngithamulpa kedha, ngayapa nubi apa goewapa lak dudupoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Dhudhuwab nanga zilamiz ziyaw kuthiya ngitha bangal ngaw yangukudu ngoenanumayparu kuthagi kuykugi yawadhan ngayapa ngithamulpa mura mabaygal a igil zapul nubi gugu ubidh thoeyayzimaya. ");
INSERT INTO mwp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Senawbi dhudhuwab nuy bangal maku ngaw yawoedhayzimaypa mura nubi apaw goewaw mabaygoepa a igilzapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowan kaziw nelay itha kedha, Sem, Am, a Zapeth. Thana butungu adhapagoemoeydhin. (Am nungu kazil Kananaw doegam mabaygal aymoeydhin.) ");
INSERT INTO mwp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","In mura mabayg nubi apaw goewanu muynu nanga thanamun kaziw kazingu pawpa kupar palaydhin Nowan thoeri kazingu. ");
INSERT INTO mwp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Woerngu kalanu, koeykoeyne apaw lagaw zagethaw mabayg Nowa; nuydh kulay goereypaw apaw lag aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Thana nanga goereypaw koewsal giyasimoeydhin, nuydh umal nguki aymoedhin a wanaydhin. Nuy nanga um walaydhin nuy kasa kupal potowakunu muynu uthuy yoewnadhin. ");
INSERT INTO mwp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nungu kazi Am, Kananalgaw muruyg nuydh nungu thathi imadhin kasa kupal. Nuy uzaraydhin a nungu ukasar tukuypoepa mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kalanu palay Sem a Zapeth koey sodh madhin, palay kaliya gud paladhin palamuniya a kalal uzarmoedhin muya uthemoemoedhin palamun thathiw potowakuya. Palay nuyn imayginga palay kasa matha woergi thayadhin palamun thathiya, paru matha adhapa nungungu imayle. ");
INSERT INTO mwp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowa nanga balbayg asidhin nanga nuydh gasamoedhin kedha, nungu kuthay kazin nubepa midh nanga aymoedhin ");
INSERT INTO mwp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","nuy kedha mulaydhin, ‘Kanana, ngi ngaw wati koewba kazi, ngi bangal kasa nginu ukasar tukuypaw zagethaw mabayg, ngibepa wara mina zapa gasamoeypa lawnga, ngi bangal kasa zagethaw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuy Nowa kalanu eso pugaydhin Awgadhoepa kedha, ‘Ngay ngibepa mina koey eso, ngaw kazipa Semalpa, nuy waza nginu getha doegamaw mabayg, a ngi waza nungu Awgadh, Kanana bangal ngaru nungu kasa zagethaw mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Zapeth lak kedha Awgadhan bangal nubepa kapu za aymoene, nungu kaziw kazil bangal koeygarsar. Thana bangal Semaniya memayipu, a Kanana bangal lak Zapethan kasa zagethaw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Koey woerngu woeyay kalanu Nowa sizi pawpa lak kuykuthalnga uzaraydhin 350 wathoelnga. ");
INSERT INTO mwp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kurusipa nungu wathoel 950 aymoeydhin nanga nuydh nungu kuth gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sem, Am, a Zapeth Nowan garkaz kazil, thanamun kaziw kazil woer thoerpumay kalanu itha kedha. ");
INSERT INTO mwp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zapethan garkaz kazil itha kedha, Gomer, Magog, Maday, Zaban, Thubal, Mesek, a Tiras. Itha thana muruygal, thana buwayl mura thanamun geth buway muruygaw nelaygal. ");
INSERT INTO mwp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeran kaziw kazil itha thabi lagaw mabaygal, Askenaz, Ripath, a Togarma. ");
INSERT INTO mwp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Zabanan kaziw kazil itha thabi lagaw mabaygal, Elisa, Soepeyn, Sayprus, Rodes. ");
INSERT INTO mwp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wa, thana mura woerngu buwadhaw mabaygal, kawaw mabaygal. Thana matha kedha lak Zapethoengu pawpa nungu kaziw kazil kasa kay kedha thanamuniya thanamun geth yangukudul. ");
INSERT INTO mwp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Aman garkaz kazil itha kedha, Kus Aykupithu Lebiya, a Kanan; thana thanamun nelay mabaygaw kuyku mabaygal. ");
INSERT INTO mwp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusenoengu pawpa kaziw kazil nanga, Sebalgal, Abilalgal, Sabthalgal, Ramalgal, a Sebtekalgal. Rawalngu pawpa kaziw kazil nanga Sebalgal a Dedoenigal. ");
INSERT INTO mwp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusan wara garkaz kazi nel Nimrod, nuy mina kay magawal mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nuy aypu lumepu nanga matha moeygoepa. Minguz kedha Awgadhan nuyn ibupuydhaypu, kedha zoenguz mabaygal kedha umamoeypu thanamun igalgoepa, ‘Awgadhaw woenab ngibiya kalmel a nuydh bangal ngibepa koey moegaw poeybane, a ngi bangal koey aypu lumaylayg ngoedhe kedha Nimrod midh.’ ");
INSERT INTO mwp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Koeykoeyne na nuydh kuyk aymoedhin nungu yadaymayl itha thabi loegal Babilon Erek a Arkad itha thabi loegal Babilonaw doegamunu. ");
INSERT INTO mwp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nuy seyzi meparu Asiriyapa a koey goegath moeydhadhin kayb kedha thoeraypa Nineba, a wara Rewobet Oer, a wara Kala. ");
INSERT INTO mwp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Wara koey goegath nuydh moeydhadhin Resan na sey dhadhal Ninebaya a Kalaya. ");
INSERT INTO mwp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Aykupithungu pawpa kaziw kazil nanga Lidiyalgal, Anamalgal, Liyabalgal, a Napathoelaylgal Patharusalgal, Kasluwalgal, a thana setha Koerithalgal, wagel mura Pilistaw mabaygal Thanamun kuyk Koerithangu. ");
INSERT INTO mwp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kananan garkaz kazi ukasar, Sidon kuykuyg a Eth kuthayg, palamulngu ukasar buway tharimoedhin kedha, Sidonan buway a Ethan buway. ");
INSERT INTO mwp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Nuy Kanana wara Zebusaythalgaw muruyg, a Amaraythalgaw muruyg, Gergoesaytalgaw muruyg, a ");
INSERT INTO mwp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ebaytalgaw muruyg, a Arkaythalgaw muruyg, a Sinaylgaw muruyg, a ");
INSERT INTO mwp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","19","wara Abadaytalgaw muruyg, a Zemaraytalgaw muruyg a Amathaythalgaw muruyg. Wa, nuy Kanana mura thanamun muruyg a thana nungu kaziw kazil mura woeyamoeydhin kurusipa lag Sidon a Gerar zaya doegamoenu Gazapa amadhan a sageraw doegamoenu nanga Sodom, Gomora, Adhama a Zebowim, Lasapa amadhan. ");
INSERT INTO mwp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Wa, itha mura Aman kaziw kazil Kusalgaw buwayngu kuykaymay, kurusipa Amathaythalgal. Thana mura thanamun geth wara buwaya a wara koey goegathiya nithamoedhin a thana mura thanamun geth yangukudulgal yaynanob. ");
INSERT INTO mwp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Zapethan kuykuyg Sem nuy mura Eboerulgaw muruyg, ");
INSERT INTO mwp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seman garkaz kazil itha kedha, Elam, Asur, Apasadh, Lud, a Aram. Itha thana muruygal, thana buwayl mura thanamun geth buway muruygaw nelaygal. ");
INSERT INTO mwp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araman kaziw kazil itha thabi goegathiya nipa Uz, Ul, Getha, a Mesek. ");
INSERT INTO mwp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apasadhan garkaz kazi Sela, a Selan garkaz kazi Iber. ");
INSERT INTO mwp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Nungu Eberan garkaz kazi ukasar garkaz. Wara nel Peleg a wara nel Zoktan. Pelegan kazimay thonar nanga Awgadhan mura nubi apaw goewaw mabaygal siga gudal wanaydhin mura yaynanob lagiya, nubi po gubaw gizuya. ");
INSERT INTO mwp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Zoktanan kaziw kazil nanga thana itha thabi buwayl aymoeydhin, Almodadalgal, Selepalgal, Azarmabethalgal, Zaralgal, ");
INSERT INTO mwp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoramalgal, Uzalgal, Diklalalgal, ");
INSERT INTO mwp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obalgal, Abimoelgal, Sebalgal, ");
INSERT INTO mwp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opiralgal, Abilalgal, a Zobabalgal. Wa, itha mura Zoktanoengu pawpa kupar palaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Thanamun koeygarsar goegathal woeraw doegam padaw dhadha sakariya Mesangu kurusipa Sepapa. ");
INSERT INTO mwp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Wa, nuy Zoktan wara Seman buway mabayg a itha mura yaynanob nanga Zoktanan buway thana matha kedha Seman buway, thana urapun, kasa kay kedha thana thanamun geth yangukudulgal. ");
INSERT INTO mwp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Itha mura thabi buwayl kazipay ngapa Semoelngu, a nungu ukasar tukuyap, Am a Zapeth thanamulngu thana mura Nowalngu, thanamun koey muruyg. Thoerpumay woerngu kalanu nanga mura nubi po gubaw gizu buwayl nungungu mura, Nowalngu. ");
INSERT INTO mwp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wa, sethabi thonara mabaygal mura urapun yangukuduya ya umamoeypu. ");
INSERT INTO mwp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Thana nanga sager doegamoenu mudh thamemipu nanga, thana padagi dhadha sakar gasamoedhin Babilon. Thana si mudh yoewthaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Thana kidhakidhan ya umadhin kedha, ‘Ayawal ngalpa mamu lag moeydhaypa za gamupa oengaypa.’ Thanamun lagaw moeydhay zapul kedha thana dawmal muythu ridh palimoeydhin, boerikoepa aymoeypa kalanu thana lag moeydhay kuykaymoedhin, dowmal kubikub awen pinimoeydhin, kalanu karaypa budhamar boerikan. ");
INSERT INTO mwp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Thana kedha, ‘Ngalpa koey goegath ayimpa a mina kadaypa kuykuthal lag kay wara, nadh bal mamu ziyaya alalipu; a mabaygal bangal nanga nan yawaypu thana bal kedha memayipu, “Sena koey mabaygaw nel.” Ngalpan mura lag a ngalpalpa yaynanob niyaypa lawnga nubi apaw goewanu mura wadhwadhgamuya.’ ");
INSERT INTO mwp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kalanu Awgadh ngapa mulupa miyaydhin thanamun zagethoepa imaypa senabi koey goegathoepa a thanamun kadaypa kuykuthal lagoepa imaypa. ");
INSERT INTO mwp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Nuydh Awgadhan kedha mulaydhin, ‘Itha thabi mabaygal thana mina urapun a thanamun yangukudu ya thana ya umamoeypa lak urapun. Ina kedha ngoedhalnga, thana bangal kasa thanamun ubipa zapul aymoeypu, kuyk thanamun kuyku magaw mina koeyza. Ina thanamun matha koeykoeyne zageth kedha, thana bangal miza nge aymoene. ");
INSERT INTO mwp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ngalpa bangal thanamun yangukudu sakariya thayane lak thanamulpa tidaypa lawnga kidhakidhan. Ngalpa kedha zoenguz thanamulpa pathoeran aympa.’ ");
INSERT INTO mwp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kalanu nungu yangukudu kuyku nidhadhin wakay thamamay, thana sig woeyamaydhin mura nubi gugu ubidh thoeyayzimoeynu, thana lak koey goegath moeydhayginga. ");
INSERT INTO mwp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Senabi koey goegath kedha tharadhin, Babilon, kedha zoenguz kedha, Awgadhan thanamun yangukudul mura sakariya thoeyamoeydhin thanamulpa yoelgamoeypa mura nubi po gubaw gizuya. ");
INSERT INTO mwp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seman kaziw kazil itha kedha, woerngu thoerpumay kalanu nanga ukasar wath yabaythayamoedhin Seman mura andred wathoel aymoeydhin, nungu ipi senabi thonara garkaz kazi madhin. Nungu nel Apasadh ");
INSERT INTO mwp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Senabi kalanu nuy lak kuykuthalnga uzaraydhin 500 wathoelnga. Sethabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apasadh nanga 35 wathoelayg nanga nungu ipin garkaz kazi madhin nel Sela. ");
INSERT INTO mwp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Senabi kalanu nuy lak kuykuthalnga uzaraydhin 403 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selan nanga 30 wathoelayg aymoeydhin nanga nungu ipi garkaz kazi madhin nel Iber. ");
INSERT INTO mwp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Senabi kalanu nuy lak kuykuthalnga uzaraydhin 403 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberan nanga 34 wathoelayg nungu ipin garkaz kazi madhin, nel Peleg. ");
INSERT INTO mwp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Senabi kalanu nuy kuykuthalnga uzaraydhin 430 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg nanga 30 wathoelayg aymoeydhin nungu ipin garkaz kazi madhin, nel Rew. ");
INSERT INTO mwp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Senabi kalanu nuy lak kuykuthalnga uzaraydhin 209 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rew nanga 32 wathoelayg nungu ipin garkaz kazi madhin, nel Serug. ");
INSERT INTO mwp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nuy kalanu lak kuykuthalnga uzaraydhin 207 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug nanga 30 wathoelayg aymaydhin nungu ipin garkaz kazi madhin, nungu nel Nayo. ");
INSERT INTO mwp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nuy lak kuykuthalnga uzaraydhin 200 wathoelnga. Senabi dhadhabuthoenu nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nayo nanga 29 wathoelayg aymaydhin nungu ipin garkaz kazi madhin, nel Tera. ");
INSERT INTO mwp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Senabi kalanu nuy lak kuykuthalnga uzaraydhin 119 wathoelnga. Senabi dhadhabuthoenu nanga nuydh dhuray kazil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera na 70 wathoelayg aymaydhin, kalanu nungu ipin thoeri garkaz kazil mamayidhin. Thanamun nelay kedha, Abram, Nayo, a Aran. ");
INSERT INTO mwp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teran kaziw kazil itha kedha. Nungu garkaz kazil Abram, Nayo a Aran. Aranan garkaz kazi Lotha. ");
INSERT INTO mwp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aran kalanu um miyaydhin Babilonanu muynu. Nungu geth lagoenu koey goegath Oer. Nungu thathi senabi thonar matha igililnga. ");
INSERT INTO mwp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram geth dhoerdhimoeydhin Serayniya a Nayo geth dhoerdhimoeydhin Milkaynoeniya. Na Milka Aranan yoepkaz kazi. Nungu Aranan wara yoepkaz kazi nel Iska. ");
INSERT INTO mwp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Seray Abraman ipi na kazipa matha ngoedhagidh lawnga senabi thonara. ");
INSERT INTO mwp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera nungu garkaz kazi madhin a garkaz ngep Lotha Aranan garkaz kazi a nungu yoepkaz ira Seray Abraman ipi kalmel. Kalanu thana senabi goegath wanadhin thana Kananapa memayidhin, kasa kay kedha thana dhadhal mudhaw lag aymoedhin Arananu. ");
INSERT INTO mwp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kurusipa Teran guythuyadhin si. Sethabi thonara nungu wathal 205. ");
INSERT INTO mwp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wara thonara nuy Awgadh Abramalpa mulaydhin kedha, ‘Sena bangal ngidh nginu thathiw kupar moeram wanane, a nginu wara buway mabaygal. Ngath bangal ngibepa yakamoene mina kapu boeradhar, ");
INSERT INTO mwp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","a ngath bangal nginu kaziw kazil koeyma aymoeyne, kurusipa bangal thana wara koey buway aymidhe. Ngath ngibepa woenab poeybane a nginu nel kadaypa manine. Ngi bangal ngaw woenaboenu kaday siparu mabaygoepa mura ibupuydhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ngibiya ngaya nanga asimoeyne mina zapa aymoeypa. Wa, ngath bangal lak thana ibupuydhepu mina zapa aymoeypa. A ngin bangal ngaya nanga wati bag thoeyaypu. Wa, ngath bangal thana lak wati bag idimpu. Ngath bangal mura lagal woenabal palepu kasa nginu yabugudiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abraman nanga 75 wathoelayg aymoeydhin, nuydh mab kuykaymoedhin Aranoengu adhapa, Awgadh midh na mulaydhin nubepa. Lotha nubiya kalmel asidhin. ");
INSERT INTO mwp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Wa, itha kedha mabaygal mab kuykaymaydhin, Abrama, a nungu ipi Sera, a nungu tukuypaw kazi Lotha, a mura setha midh zagethaw mabaygal a koethil zapul nuydh sethabi lagoenu kusumoedhin, Aranoengu, kurusipa thana gasamoedhin lag nel Kanana. ");
INSERT INTO mwp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Thana koeyma goeygilnga toedipu, kurusipa thana mangemidhin koey puy kuykunu, Sekamoenu. Sethabi thonara Kananalgal matha memayipu si sethabi goegathiya, a senabi puy ngalaga nanga poegaypu thanamun adhapa thoemayzinga nel muraw puy. ");
INSERT INTO mwp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Wa, senawbi lagoenu nanga Awgadh yakamaydhin Abramalpa a kedha mulaydhin nubepa, ‘In nubi lag ngath bangal poeybane nginu kaziw kazipa.’ Kalanu Abrama kulaw olta aymoeydhin Awgadhoepa, si senawbi doegamoenu. ");
INSERT INTO mwp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Senawbi kaliya nanga thana sizi lak memayidhin zaya doegampa padal maypa. Thana potowakul thoeydhamoeydhin ukasar goegathoenu dhadhal. Bethel kuki doegamoenu a Ay sager doegamoenu, Abrama lak wara kulaw olta moeydhadhin si, thanamulpa Awgadhoepa thawmoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kalanu thana sizi kasa wardoegampa, wardoegampa memayipu mura thonara, kurusipa thana Kananaw zaya doegam gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Senabi thonara Kanana aygi asidhin mina ipidhadh gegeyadh. Abrama aypa lumay zayapa kuniya miyaydhin Aykupithupa. Nuy kasa thawpay thonarpa si meparu. ");
INSERT INTO mwp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Thana kay wagel kay Aykupithupa yabay idimpa Abram kulay mulaydhin nungu ipipa kedha, ‘Ngi mina thiyaygi yoepkaz, ");
INSERT INTO mwp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aykupithulgan kay nanga ngin imaypa thana kay kedha memayipa, ngi ngaw ipi, a thana kay ngoena uma mathamoene; thanamulpa ngibepa uma mathamoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ngi gar kay thanamulpa kedha muli, ngi ngaw babath. Thana bangal nanga gasamoene kedha, ngi ngaw babath, thanamulpa ngayapa mathamaypa lawnga, thana bangal ngoena balbayginga danal poethaypu, kuyk ngi thiyaygi yoepkaz.’ ");
INSERT INTO mwp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Thana nanga Aykupithunu mangemidhin Aykupithulgan imadhin kedha, na mina kapu yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Thanamun mopakuyku getha doegam zagethaw mabaygan imadhin, a mopakuykupa mulemidhin, kalanu nan Serana yoelpadhin mopakuyku mabaygaw lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nuydh nanga Pero Serana imadhin, nuydh Abramalpa poeybaydhin itha kedha zapul, mamuyl, nanil, kawal, donkil, a kamelal, a zagethaw mabaygal dhuray. ");
INSERT INTO mwp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Awgadhan nanga imadhin kedha Pero Serana madhin, nubepa gegeyadh, kalanu nuydh wati kikir wayadhin Perolpa a mura nungu mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kalanu Pero Abraman thuradhin, yapupoeybaydhin kedha, ‘Ngidh mingu ngayapa kedha aymangu. Ngi mingu ngayapa kulay mulayginga kedha, Sera nginu ipi, ");
INSERT INTO mwp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ngi mipa ngayapa kedha mulaydhin kedha, na nginu babath ngath kedha zoenguz nan ngayapa ipi madhin. Mar ina nginu ipi a adhapa kay ladhu!’ ");
INSERT INTO mwp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Nuy nungu zagethaw mabaygoepa mulaydhin Pero kedha, ‘Adhapa mariw koezi ngalpan lagoengu a nungu ipi a setha mura nungu mabaygal a thanamun zapul.’ Thana nungu zagethaw mabaygan aymoedhin Pero thanamulpa midh nanga mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abraman nanga adhapa wayadhin Aykupithungu, nuy a nungu ipi a nungu mura zagethaw mabaygal, a mura tetel uruyl, a mura nungu zapul, thana naygay doegampa adhapa memayidhin Aykupithungu. Nubiya kalmel nungu tukuypaw kazi Lotha. Kurusipa thana Kananaw zaya doegam gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram nuy mina koey ayde zapul mabayg. Nuy kedha, mamuylayg, nanilayg, a kawalayg; a nubiya lak koethil zapul, silba a goli. ");
INSERT INTO mwp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Sizi nuy lak miyaydhin war doegampa. Nuy kedha meparu, urapu lagoenu thuma oesiginga, kurusipa nuy Bethela mangaydhin. Thana si thawpay thonarpa mudh yoewthadhin Bethel war doegapa a Ay war doegapa, thana kulay ngalaga nanga kawa mudhaw lag aymoedhin, ");
INSERT INTO mwp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","a olta moeydhadhin. Thana nanga si kulay aymayzi oltanu mangemidhin, Abram lak Awgadhoepa thoeythupoegaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Matha Abram lawnga koey uruylayg, nungu tukuypaw kazi Lotha lak kedha koey uruylayg, mamuylayg, nanilayg, kawalayg. Nuy lak nungu geth ipi kazilayg, a zagethaw maoebaygoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Senabi thonara nanga palamun kalmel tetel uruypa bup matha ngoedhagidh lawnga, thana ngalagiya na mudh thoemaypu thana kasa mura bup urapun goeyginu eygi thoeyaypa purthaypu. ");
INSERT INTO mwp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abraman a Lothan uruy danal poethay mabaygal kidhakidhan wati igalgal aymoeydhin, yaynanob uruy may. (Senabi thonara nanga thana Kananalgal a Perezaythalgal, thana matha memayipu sethabi doegamoenu.) ");
INSERT INTO mwp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kalanu Abram Lothalpa kedha mulaydhin, ‘Ipal ngoeba urapu kulkaw mabayg, thana kidhakidhan ya poeybayginga nay. ");
INSERT INTO mwp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Matha ngoedhagidh kedha ngoeba bangal dhadh pulgemoene. Ngi kulay nginu midh doegampa ubi, kasa ubipa doegam ngibepa mar nginu uruypa matha ngoedhagidh, ngay wadgoepa uzaripa.’ ");
INSERT INTO mwp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nuy Lotha karaypa gima nagaydhin a gurguy nagaydhin, nuydh imadhin Yuridhaw koesa, nanu doegam, mura kedha naygay kurusipa Zoa senabi doegam mina koey ngukilnga, Awgadhaw Dharbaw lag midh nanga, a Aykupithu midh nanga. Senabi thonara nanga Sodom a Gomara sepalbi ukasar goegath matha memampu, Awgadhoepa palay matha idimoeyginga. ");
INSERT INTO mwp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lotha mura padagi dhadhar sakar nubepa madhin Yuridhaw koesa ngalagiya na thoeraypa. Nuy kalanu Abramalngu sager doegampa adhapa miyaydhin sipa Yuridhaw koesapa. Senaw palamun dhadh poelamay kedha kuniya aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Lotha nanga miyaydhin nuy Abram matha meparu adhal bupanu Kanananu. A Lotha kay goegathoepa thamaydhin, nuydh nungu kawamudhaw lagal aymoeydhin padagi dhadhasakara, Sodomoepa amadhan. ");
INSERT INTO mwp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Thana kay nanga setha Sodomaw mabaygal thana mina adhapudhay wati pawaw mabaygal. Thana Awgadhoepa wati pawal aymoeypu, Awgadhaw mina nanga pathidhaypu. ");
INSERT INTO mwp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotha nanga thamaydhin, nungu kalanu Awgadh Abramalpa mulaydhin kedha, ‘Senaw ngi ngalaga nanga mepa mamu kay mina nagi mura wad wad gampa. ");
INSERT INTO mwp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","In mura kapu boeradhar, ngath bangal ngibepa manine a nginu kaziw kazipa. In mura nubi kapu boeradhar bangal pamoeygoepa ingaru nginu za, nginu kaziw kaziw geth niyaylag.’ ");
INSERT INTO mwp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","‘Ngath bangal nanga ngin kazil palane buthudh koeygarsar, mabaygoepa gethatidaypa matha ngoedhagidh lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wa uzar, ngidh mura iman nabi koey boeradhar nabi buwadhoengu wara buwadhoepa, in bangal ngath ngibepa manine mura.’ ");
INSERT INTO mwp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kalanu Abram thamaydhin a mudh yoewthadhin, Mamren adhapa thamayzi puyl doegamoenu amadhan Ebronoenu nuy Mamre wara kuyku mabayg Ebronoenu. Nuydh Abrama kalanu si kulaw olta moeydhadhin Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Si senawbi thonara nanga, mopakuyku mabayg koey garsar. Thana po mopakuykun ya umadhin wara payb mopakuykupa koewbupa. Ya umayzi mopakuyku nelay itha kedha, Amrapel Babilonaw kuyk, Ariyok Elasaw kuyk, Sedaloma Elamaw kuyk, a Tidal Gowimaw kuyk. ");
INSERT INTO mwp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Thana koewbupa memayidhin payb mopakuykupa, thanamun nelay itha kedha, Bera Sodomaw kuyk, Boesa Gomoraw kuyk, Sina Adhamaw kuyk, Semeba Zebowimaw kuyk, a wara kuyk Belamaw ");
INSERT INTO mwp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nubi payb mopakuykul lak ya umadhin koewbupa, a koewbu mabayg garwoeydhamoedhin, Sidimaw padaw dhadha soekara. Nan kayib kedha thoeraypa, Umaw Woer, na mina wapiginga. ");
INSERT INTO mwp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Elimaw kuyk Sedaloma nuydh thana payb mopakuykul nudaydhin nuy thanamun mura mina mopa kuyk aymaydhin twaylob wathoelnga. Wath thirtin nanga, thana lak nubepa kurusipoegayginga. ");
INSERT INTO mwp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Wath potin nanga nuydh imadhin kedha, thanamun koerngayginga koeyza, nuydh wara koey goegathaw mopakuykupa yangukudu guythuyadhin nubepa ibupuydhaypa. Thana nubepa ngapa thanamuniya thanamun koeygarsar koewbu mabaygal. Thana kalanu koewbupa memayidhin mura goegathoepa. Thana adhadhin, thanamuniya Repaymalgal thanamun goegath Astheroth a Karnaym, Zuzimoelgal thanamun goegath Am a Emim, palay sepalbi goegath Kiriyathamaw padaw dhadhasakara, ");
INSERT INTO mwp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","a Oraythalgal Edomaw padanu gimanoeka wara kuthoengu wara kuthoepa mathamoeydhin kurusipa thana Elparan puygi dhadha sakaraw dhang gasamoedhin. Sethabi koewbu kalanu mura sethabi goegathal koerngayl kawra madhin. ");
INSERT INTO mwp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kalanu Sedaloma a thana setha ya umayzi mopakuykul, kuniya tidemidhin Kadesoepa. Thana mura Amalakaytalgal lak mathamoeydhin mura thanamun goegathiya, a Amoraythalgal lak kedha, setha ngaya nanga Azazon thamanu memayipu. ");
INSERT INTO mwp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Wa, thana Sodomaw Gomoraw mopakuykul, a thanamuniya kalmel Adhamaw, Zebowimaw, a Belamaw mopakuykul thanamun koewbu mabaygal garwoeydhamoeydhin koewbupa. Thana kasa ugar thonar Sidimaw pada dhadha sakara. ");
INSERT INTO mwp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Thana nanga ya umayzi mopakuykul ngabunadhin Elimaw, Gowimaw, Babilonaw, a Elasaw, thana po ya umayzi mopakuykul panithoedhin setha payb Sidimaw doegam mopakuykupa. ");
INSERT INTO mwp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Senabi padaw dhadha sakar nanga kasa mura kubikub dhidheral pawoeynayl doenabaylnga. Kalanu thana payb mopakuykul kasa akan zilmemidhin, a thanamun koewbu mabaygal. Dhuray Sodomaw, Gomoraw mabaygal sethabi dhidheral pawoeynayl doenabaynu irimoeydhin, a setha dhuray nanga mura padapa kadaypa akan zilmemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wa thana ya umayzi mopakuykun mura mina zapul a ayde kusumoedhin Sodomoengu a Gomoroengu, wara za wanayginga ayde kalmel. Kalanu memayidhin kaliya noegayginga. ");
INSERT INTO mwp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wa, Abraman tukuypaw kazi Lotha thana lak nuyn madhin sizi Sodomoengu, nubiya kalmel mura nungu mabaygal a zapul. ");
INSERT INTO mwp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Matha urapun sakariya palgidhin a Abraman yadu thuradhin, zapul midh na paru aymoedhin Lothalpa. Wa, nuy Abram waza thanamun Eberu buway kuyk. Nungu kawamudh senabi thonara Mamren adhapa thamayzi puyl doegamoenu amadhan. Nuy Mamre Amaraythalayg nuy a nungu tukuyap Esoekol a Ana thana Abraman igalgal, urapu doegamuya thayamidhin. ");
INSERT INTO mwp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Nuydh nanga Abram gasamoedhin kedha, nungu tukuypaw kazi Lothan gasamoedhin, nuydh mura nungu mabaygal thuraydhin, mura setha ngaya nanga koewbu mabaygal nungu kawamudhoenu, kalmel garwoeydhamoeydhin mura 318. Kalanu Abram a nungu koewbu mabaygal sethabi ya umayzi kuyku mabaygal a thanamun koewbu mabaygal wakay moeydhin kurusipa goegath nel Dan. ");
INSERT INTO mwp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nuydh thana si imaydhin, kalanu nuydh nungu mabaygal dhadhiya mamayidhin. Thana kubilu kay pananithadhin, a thanamun wara doegam mabaygal kasa akan zilmemidhin. Abraman mabaygal wagel wakaymoeydhin thana kurusipa Obar, Damaskasanu wara doegamoenu, naygay doegamoenu. ");
INSERT INTO mwp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nuydh mura kuniya gasamoeydhin thana midh zapul Sodomoengu a Gomaroengu kusumoedhin a mabaygal lak kedha nuydh kuniya gasamoedhin. Nuydh nungu tukuypaw kazi Lothan kuniya gasamoedhin kalmel yoepkazil a zagethaw mabaygal, mura thanamun rugal kalmel, a Lothan rugal. ");
INSERT INTO mwp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wa, Abram nuydh Sedaloma a nungu doegam mabaygal mura mathamoeydhin; thana nanga kuniya tidemidhin, Sodomaw mopakuyk yabuya uzaraydhin thanamulpa. Nuydh thana gasamoedhin, wara padaw dhadha sakarnu nel Sabela, lawnga Mopakuyku Padaw Dhadhasakara. ");
INSERT INTO mwp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Senabi thonara nanga wara mabayg mangaydhin, nungu nel Melkizadek, Salemaw mopakuyk, nuy lak misnare, Daparaw Gimaw Awgadhaw. Nuydh kunaw susu a umal nguki Abramalpa mamoemoedhin, ");
INSERT INTO mwp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","kalanu Abramalpa kuyku nidhayzi yangukuduya mulaydhin kedha, ‘Ngibepa mura kapu za ngapa gimaz. Awgadh adhapudhay koey Awgadh. In nubi gugu ubidh thoeyayzinga matha nungu aymayzinga gimal a apal, Nuydh bangal ngin danal poethaypu, mura thonara koeygoersar. ");
INSERT INTO mwp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Wa, nuy mina Adhapudhay Kuykulnga Awgadh gimal darapa, mabayg ngaru nuyn bangal thawmayparuy, kedha zoenguz kedha nuy waza ngibiya kalmel a kulay nginu pazalmay buwalthoeyaynu. Kedha zoenguz thana nginu wati koewbu mabaygal akan kuniya zilmemidhin.’ Kalanu Abram nubepa Melkizadekoepa koeygarsar zapul poeybamoeydhin urapu urapu mura nungu koewbu thonaraw gasamoeyzimayngu. Ten mamuyl nanga nuydh urapun madhin nubepa, a rugal lak kedha, a mura zapul lak kedha. ");
INSERT INTO mwp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kalanu nuy Sodomaw mopakuyk Abramalpa mulaydhin kedha, ‘Koey eso ngibepa ngidh mura ngaw mabaygal balbayginga gudaz puydhadhin kuniya, mura matha ngoedhagidh, mura setha Sodomaw mayzi rugal nanga ngidh bangal ngibepa gasamidhe sew ngibiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Kasa kay kedha nuy Abram ubigasidhin, nuy kedha mulaydhin, ‘Ngay mina Awgadhaw parunu, nubi gugu ubidh thoeyayzinga ngunu aymayzinga nanga, ngayapa wara moegina zapa gasamoeypa lawnga nginungu; nginu ngayapa kedha yoengu kedha, mura matha ngoedhagidh ngidh ngayapa poeybadhin a ngay nginungu matha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ngayapa ngaw geth wara zapa kuniya gasamoeypa lawnga, ngath kay matha kuniya gasamoeypa ngaw zagethaw mabaygan mi aydel zapul nanga thana purthamoeydhin, wara kedha mabaygan nanga thana kay thanamun kupayl gasamoeypa, Ana, Esoekol, a Mamre. Thana waza ngaw doegamuya thayamidhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kalanu Kuykulnga Abramalpa goeyginu pikin umay kedha, ‘Abram, ngi akan maygi, ngath bangal ngin kaludhoepu mura wati zoengu, A ngath bangal ngibepa, adhapudhay mina za poeybane.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Abram kuniya mulaydhin Awgadhoepa kedha, ‘Ngath bangal midh paru nginungu kozan gasamoene ngaw buwaypa, ngay wara kazigig, ngaw zapa a ngaw buthoepa. Zapul ngaru kedha kuniya pudhedhe bangal, urapun ngaw niyaykazin, nuydh ngaw buth manine, Eliyayza nungu nel. Ngidh ngayapa kazi poeybayginga, kedha zoenguz nuydh bangal ina ngaw zageth mura manine, senabi wara buway mabayg Eliyayza Damaskasoengu.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pikinu nanga Awgadh lak mulaydhin Abramalpa, ‘Lawnga, nginu zagethaw mabayg lawnga; nginu kazi bangal nginu buth manine.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Senawbi pikinu nanga muynu, Awgadhan Abraman adhapa yoelpadhin nungu kawa mudhaw lagoengu, kalanu dapara kadaypa dan thayadhin, ‘Kedha nagi, ngidh setha thithuyl imiz a? Buthudh koeygarsar, ngibepa getha tidaypa matha ngoedhagidh lawnga, nginu kaziw kazil bangal kedha koey garsar.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram nuydh mina yoepathaman Awgadhaw yawoedhay yangukudu midh nanga. Wa, nungu Abraman mina yoepathaman kapu ngoedhalnga Awgadhoepa senabi thonara, Awgadhaw purkapa balbayginga. ");
INSERT INTO mwp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Awgadh kalanu lak mulaydhin Abramalpa kedha, ‘In ngay Awgadh, ngath kulkulb ngin yoelpadhin ngapa, nginu thathiw thathiw niyay lagoengu, Oerngu, Babilonangu muyngu. Ngibepa nubi boeradharapa ngath yadu palgadhin nginu geth za ingaru.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram kalanu yoewdhaydhin kedha, ‘Adhapudhay Kuykulnga, ngath bangal midh paru ngulayg gasamoene kedha, ngin bangal mina yoepathamaypa kedha, ina nabi boeradhar ngaw boeradhar, ngaw geth niyaylag?’ ");
INSERT INTO mwp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Awgadhan Abraman ibupuydhadhin mina yoepathamaypa nubepa. Nuy kedha mulaydhin Abramalpa, ‘Wa, ngidh ngayapa kaw ngapa mar, a nani a garkaz mamuy, mura thoeri wathalgal kay a yawa goeynaw a mina goeynaw.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Nuydh Abram mura Awgadhoepa kusumoedhin sethabi uruyl. Kalanu papathoemoeydhin thana uruyl. Nuydh boethal uruy dhadhiya dhadh mayginga. Nuydh setha papathoemoeyzimayl mura uka doegamuya budhamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Thana wara boethal uruyl ngapa mulupa nanga, setha nuthemir aygudoepa nanga, nuydh thana adhapa zizimoeyr. ");
INSERT INTO mwp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Goeyga nanga pudhaydhin Abram gamu kawban uthuy yoewnadhin, nungu uthuy mina koeyza. Kalanu nuydh mina koey aka gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Awgadh nubepa mulaydhin kedha, ‘Wagel bangal nanga nginu kaziw kazil bangal wara mabaygaw niyay lagiya nithamoene. Danal poethay bangal thanamulpa gegeyadh po andred wathalnga, ");
INSERT INTO mwp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","kasa kay kedha ngath bangal idimoene sethabi wati danal poethay mabaygal, a thanamun buway. Midh thonara nanga thana sethabi wati danal poethay lagoengu ngapa kuniya, thanamuniya bangal koey garsar kapu ngoedhal koethil zapul a dhuray matha ngoedhagidh zapul. ");
INSERT INTO mwp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","‘Kasa kay kedha mura thabi zapul ngaru nginu thonarngu pawpa, nginu thonara nanga gasamoene, nginu bangal kapu kuth koewbuginga, ngin bangal balbayginga boeradhoeranu wanane. ");
INSERT INTO mwp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nginu bangal nanga kuth senabi thonara ka matha lawnga, thanamulpa Amaraythalgoepa adhapa idimoeypa nubi boeradhoerangu. Ngithamun buwayn ngaru bangal mina thonar ugane; thana kuykuthalnga ugane nanga wara lagoenu, maykuyk mulupa, maykuyk kadaypa, po muykuykul mura. Kalanu bangal thanamun Amaraythalgaw wati pawa nanga koeyza aymidhe. Ngath senawbi thonara kay lak ngapa thuraypa nginu buway thanamulpa kuth poeybaypa, thanamun Amaraythalgaw kuniya modhab.’ ");
INSERT INTO mwp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Goeyga nanga pudhaydhin, koey inur thoeydhamoeydhin ukasar muythaynga za kasa palamun geth buyalnga dhadhiya thamemar uruy madhuya. Palay ukasar kalmel, wara muythaynga a wara thungedh ngoedhalnga kalmel thamemar. ");
INSERT INTO mwp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Senabi thonara nanga Awgadhan yawadhan aymoedhin Abramalpa kedha, ‘Ngath nginu kaziw kazipa bangal in nubi boeradhar maypa marngu, Aykupithu doegamoengu kuyku oemay kurusipa Upreythizaw Koesapa. ");
INSERT INTO mwp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","‘Setha mura lagal thabi boeradharoenu muynu, mabaygal ngalagiya nipa nanga, Kenalgal, a Kenazalgal, a Kadhmonaythalgal, ");
INSERT INTO mwp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","a Ithalgal, a Perezaythalgal, a Repaymalgal, ");
INSERT INTO mwp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","a Amonaythalgal, a Kananalgal, a Gergoesaythalgal, a Zebusaythalgal. Wa, ngath bangal mura mamayiene nginu kaziw kazipa, mura thabi mabaygaw niyaylagal kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abraman ipi na mina koey kuykuthalnga uzaraydhin kazigig, kasa kay kedha nabiya urapun Aykuputhulayg, nanu zagethaw yoepkaz meparu; nanu nel Eyga. ");
INSERT INTO mwp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Wara thonara Sera nanu alaypa mulaydhin kedha, ‘Ngayapa kazipa gasamaypa lawnga, Awgadhan ngayapa kazi poeybayginga; ngi bangal ngoezu zagethaw yoepkaziya uthuy yoewnane, wara kedha nadh ngayapa kazi gasamoene. Wa Abraman asidhin Serana ubilmaya.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wa, Sera Eygana poeybadhin nubepa zagethaw yoepkaz ipi. In nubi za na aymoedhin Kananaw niyay kalanu ten wathalnga. ");
INSERT INTO mwp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Eyganiya uthuy yoewnaydhin, kalanu na maythalayg aymaydhin. Nadh na imadhin kedha na maythalayg, na Seralpa adhawanepu. ");
INSERT INTO mwp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sew kalanu Sera gegeyadh gasamoedhin, na kedha mulaydhin Abramalpa, ‘Na Eyga na kasa koeyma kupuripa ngayapa kedha, na maythalayg. Ina ngoezu gegeyadh lawnga, ina nginu gegeyadh; Awgadhan kay bangal seysithamoene. Ngath madhin Eygana ngibepa ipi, midh paru na ngaybiya gimal yadu umepa? Na ngoezu zagethaw yoepkaz.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram nuy Seralpa kuniya kedha mulaydhin, ‘Wa sena nginu zagethaw yoepkaz, nginu ubi nabepa midh zagethoepa aymoeypa.’ Sera sizi pawpa nan koey dharadh mayparu, a kalanu na Eyga gamungu zilmaydhin Seralngu. ");
INSERT INTO mwp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Na nanga Eyga zilmaydhin nanga Awgadhaw angelan nan dhadhal gasamoedhin moegina ngukiw maynu, nanu mabaw lagoenu pasinu, mabaygoegi dhadha sakara, lag nel Soer. ");
INSERT INTO mwp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Angela nabepa mulaydhin kedha, ‘Eyga, ngi Serana zagethaw mabayg, ngi ngalagaz ngapa, a ngi ngalagapa ulaypa?’ Na kedha angeloepa, ‘Ngay nanungu gamungu zilayma, ngoezu kuyku mabaygoengu.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Angela nabepa kuniya mulaydhin, ‘Lak kuniya tidi, ngi waza nanu zagethaw mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ngath bangal ngin danal poethaypu, a nginu kaziw kazil bangal buthudh koey garsar. ");
INSERT INTO mwp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ngidh bangal kazi gasamoene, garkaz kazi, a ngidh bangal nuyn nel tharane Ismeyl. Minguz kedha, Awgadhan nginu may wakay karngemingu. ");
INSERT INTO mwp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","‘Kasa kay kedha nuy bangal senawbi garkaz kazi mina igalgoegig, ngoedhe bangal igalgoegi donki, bupaw donkil midh nanga. Nuy bangal kasa mabaygoepa matha koey dharadh yadu umepu, a thana bangal nubepa wati igalgal, a nuy bangal nungu buwayngu koerawayg, nungu kusayg niparuy.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Eyga na nabepa wakay thamoemaynu muynu yapu poeybaydhin kedha, ‘Ina ngath mina Awgadh imanu a, a ngay um mayginga? Ngay bangal midh, ngay bangal mabaygoepa umepu a?’ Kalanu na mulaydhin kedha, ‘Nuy Awgadh mina Awgadh, nuydh purkan yawayipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Thana kedha zoenguz nan may kedha thoeraypu, ‘Purkan Yawayay Mabaygaw Ngukiw May, nuy Ngaru Igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kalanu na Eyga kuniya tidaydhin nadh angeloepa karngemidhin, a nadh garkaz kazi madhin Abramalpa. Nuydh nuyn nel tharadhin Ismeyl. ");
INSERT INTO mwp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Senawbi thonara Abraman wathal mura 86. ");
INSERT INTO mwp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sizi pawpa nanga moegina kuykuthalnga, nungu Abraman 99 wathal gasamoedhin nanga Awgadh lak yakamoeydhin nubepa, a mulaydhin kedha, ‘Ngay adhapudhay Awgadh, ngayapa karngemir. Wara lak kedha ngoedhal Awgadhoeginga, ngay midh nanga. Ngidh bangal ngaru mura thonara ngaw ubilmayl aymoeypu a mina zageth ayman. ");
INSERT INTO mwp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngath bangal ngaru ngibepa ngaw ya woeydhayzinga kuykunidhane, a nginu kaziw kazil bangal koey garsar.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram nuy Awgadhoepa thawmaythu boeradharoepa lugobel tharaydhin. Awgadh kedha mulaydhin nubepa, ");
INSERT INTO mwp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","‘Ngath nabi yawadhan ngibepa ayman, ngath bangal ngin mopakuyk thathi aymoene mura lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ngi bangal lak lawnga Abram, ngath ngibepa kayn nel manin, nginu nel bangal Abrama, minguz kedha ngath ngin ayman mura buwaypa thathi, mopakuyk. ");
INSERT INTO mwp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nginu kaziw kazil bangal mina koey gudal goesar, a dhuray thanamulngu bangal goegathaw mopakuykul aymoeyne. ");
INSERT INTO mwp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ngayapa ngaw yawaydhayzimoeypa yakanuraypa lawnga, ngibepa a nginu kaziw kazipa sey boey wagel, ina ngaw patidhaygi ingaru yawoedhayzinga. Ngay bangal nginu Awgadh a nginu kaziw kaziw ngaru Awgadh. ");
INSERT INTO mwp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","‘Ngath bangal ngithamulpa poeybane, ngi a nginu kaziw kazil in nubi boeradhar Kanana, ingaru za ngithamun, a ngay bangal ngithamun Awgadh. ");
INSERT INTO mwp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","A Abrama ngi kay ngaru ngaw wakay thoemamay a ubilmaya asir ya woedhayzimaya, ngi a nginu kaziw kazil sey boey wagel.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Awgadh matha umay Abramalpa kedha, ‘Ngitha bangal mura asimoeyne thabi yawoedhayzimaya ngaw. Ngitha ngaru motho poethaypa mura ngithamun garkazil, koey mabaygal a moegina kazil. ");
INSERT INTO mwp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Koezi pawpa mura ngithamun kayn mapethal garkazil boera rumayl nanga thana eyth goeygil na gasaman nanga ngaru ngapa pathamoeyn. Ngithamun geth kazil a matha kedha zagethaw mabaygaw kazil, a matha kedha koey mabaygal garkazil kayn gasamayzimayl azaz lagoengu. ");
INSERT INTO mwp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","‘In nubi mina gamunu maku yawoedhayzinga mabaygoepa imaypa kedha, in ngoeban patidhaygi yawoedhayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mi garkaz nanga ngithamulngu, motho poethayginga, nuy lak lawnga ngaw buway mabayg; minguz kedha, nuydh ngaw yawoedhayzinga pathidhan.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Awgadh matha umay Abramalpa kedha, ‘Ngidh bangal nginu ipi kedha thoerayg, Sera; koezi pawpa nanu nel bangal Seray. ");
INSERT INTO mwp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngath bangal nabepa mina igililmay woenab poeybane, a nadh bangal ngibepa garkaz kazi gasamoene. Na bangal mura apu koey garsar buwaypa a nanu kaziw kazingu dhuray bangal mopakuykul aymoeyne koey goegathiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrama apasidhin Awgadhoepa nungu paru mulupa thayadhin boeradharoepa, kasa kay kedha nuydh nanga wakay thoemamayidhin nungu kasa giw kedha, ‘Ngalbe koey apu thathi, ngalbelpa matha ngoedhagidh lawnga kazipa gasamoeypa, ngay waza 100 wathalayg a ngaw ipi 90 wathalayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nuy Awgadhoepa yapupoeybaydhin kedha, ‘Ngibepa balbayginga kedha Ismeyl bangal ngaw buth manine?’ ");
INSERT INTO mwp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kasa kay kedha Awgadh nubepa kedha mulaydhin, ‘Lawnga! Nginu mina ipin Seray, nadh bangal ngibepa kazi gasamoene. Ngidh bangal nuyn nel tharane Isaka a ngath bangal ngaw yawoedhayzinga ngaru ngoenanu mayparu nubepa a nungu kaziw kazipa. Ina patidhaygi yawoedhayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","‘A wara kedha, ngath nginu yangukudu gasamoenu Isoereylan doegam, ngath bangal nubepa koeyma kazil mamayiene a kaziw kazil, a nuy bangal toewalob garkaziw thathi; ngath bangal mura yaynanob thanamulpa kaziw kazil mamayine, a ngath bangal thanamun koey goegath aymoene. ");
INSERT INTO mwp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kasa kay kedha nginu ipi Seray bangal ngibepa garkaz kazi manine, kedha thonara wagelaw wathoenu. Nungu nel bangal Isaka; ngaw yawoedhayzinga ngaru nubepa bangal.’ ");
INSERT INTO mwp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Awgadhan nanga muwasidhin Abramaniya nanga ya sagul, kalanu nuydh Abraman wanadhin. ");
INSERT INTO mwp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Senawbi goeyga nanga nuydh Abrama Awgadhoepa karngemidhin a motho pathadhin Ismeylan a mura garkazil nungu lagoenu muynu, a matha kedha nungu mapu zagethaw mabaygal garkazil a thanamun garkaz kazil. ");
INSERT INTO mwp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wa, nuy nanga Abrama nanga 99 wathalayg, nuyn lak motho pathadhin, kedha zoenguz kedha Awgadh a Abrama palamun kayn yawoedhayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nungu Kazi Ismeyl sinubi thonara thoertin wathalayg. ");
INSERT INTO mwp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Wa, palay urapun goeyginu sepalbi thonara motho pathamoemoedhin urapu mayn Abraman zagethaw garkazil. ");
INSERT INTO mwp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","War thonara nanga Awgadhan lak Abramalpa yakamaydhin. Senabi thonara Abraman kawamudh Mamren puykuykunu amadhan. Nuy nanga nungu potowakunu pasagudanu nir nanga dhadha goeyginu gabupa, senawbi goeyga koey komalnga. ");
INSERT INTO mwp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kedha nanga nuydh gima nagaydhin, nuydh thoeri mabaygal imoeydhin. Nuy sobaginga yabuya uzaraydhin thanamulpa, nuydh apapudhaydhin nungu paru mulupa thayadhin boeradharoepa. ");
INSERT INTO mwp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Nuy kedha, ‘Ngay gar ngithamuniya yoewdhiz, matha yabay kay mabag, ayawal mamu itha ngoena pudhemipa, ngay mura mabaygaw ibupuydhay mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kow nithamaw puy kuykoenu iradhoepa, ngath ngithamulpa woer thoeydhaypa ngaroepa garwalgaypa. ");
INSERT INTO mwp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ngitha kay mamu moegina ay purthaypa, ngithamulpa lak wamenalnga maboepa. Ngitha gar ngoedhalnga ngapa ladhunu ngaw lagoepa. Ngath kay ngaru ibupuydhay ayimpa ngithamulpa.’ Thana kedha, ‘Eso, wa ngoey sethaki.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kalanu Abrama mina sobaginga nungu potowakupa uzariz a nungu ipipa Seraylpa kedha muliz, ‘Kazaginga sena nginu mina kapu kun, seyzi ngapa mar a kunaw susul kay aymoeyr.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kalanu Abrama soeyzi zilmaydhin, a nungu uruyngu nuydh koey buzaral kazi kaw madhin nungu zagethaw mabaygoepa buth pathaypa. Sobaginga nuydh ay ayman. ");
INSERT INTO mwp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kalanu matha nuydh susu ikay a madhu mamoemoedhin a parunu thiyamoeydhin thanamulpa puy kuykoenu apal ayde, a thana purthadhin. ");
INSERT INTO mwp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Thana kalanu yapupoeybemidhin kedha, ‘Nginu ipi ngalaga Seray?’ Nuy kedha, ‘Na sey potowakunu.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wara thanamulngu kedha muliz, ‘Nayn moelpalaw koeliya nanga, nginu ipin bangal garkaz kazi gasamoene. Wa, senawbi thonara ngay lak bangal boey kuniya tidhedhe ngipelpa mura zapa kuyku nidhaypa.’ Wa, Seray senabi thonara muynu, potowaku pasanu, kalanu sir. ");
INSERT INTO mwp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Nadh na karngemidhin nanga nanu kasa giw, minguz kedha, nanu kaziw gasamay thonar yabay thayadhin, sepalbi thonar palay koey apu thathi. Na giwl giwl kedha umay, ‘Ngalbelpa kazipa gasamoeypa matha ngoedhagidh lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Wa, nuydh kuykulnga Serayna giw wakay karngemidhin senabi thonara. Nuy Abramalpa yapupoeybaydhin kedha, ‘Senaw Seray miyaw may giwn pungaypa, nadh ngaw ya mina yapathoemayginga? Na minguz kedha umepu, na koey apu, na kazipa matha ngoedhagidh lawnga? ");
INSERT INTO mwp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","In nubi za kasa zagethoeginga, in nubi sama woeydhayzimaya wara zaginga Kuykulmaypa koey zagethoepa aymoeypa. Koezi pawpa nayn moelpalal waniz, ngay bangal na boey kuniya. Wa, senawbi thonara nginu ipin seray bangal garkaz kazi gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nadh nanga Seray Kuykulmay yangukudu na karngemidhin nanga nanu aka mina koeyza, na gud thadhaydhin kedha, ‘Ngay giw walayginga.’ Kuykulnga nabepa kedha mulaydhin, ‘Lawnga, ngi giw walema.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kalanu sethabi thoeri mabaygal ladhudhin war lagoepa sizi mulupa nagaypa wara goegathoepa nel Sodom, a Abrama thana dhadhapa agaydhin yawa thurayl. ");
INSERT INTO mwp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nuy Kuykulnga wakay thoemamoeydhin kedha, ‘Ngath kay Abraman ngulayg palane ngath bangal mi za nanga aymoene. ");
INSERT INTO mwp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Wa ngoeban ya woedhayzinga kedha, nuydh nungu kazil a ngepal ngurpamoeypu bangal ngaw yoepa koerngaypa, thana bangal koey ridhamayl siparu, a koey mudhaw lag aymoene. A lak kedha nungungu pawpa ngath mura nubi po gubaw gizuwaw koey goegathapa bangal woenab poeybaypu. ");
INSERT INTO mwp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ngath nuyn Abrama adhapa thamadhin nungu kazipa a nungu kaziw kazipa ngurpaypa, thanamulpa mura koerngaypa ngaw yangukudupa, a mura mina doegamuya buwayl thoeyaypa. Thana bangal nanga mura ngaw ubilmayl aymoeypu nanga, wa ngath bangal ngaw yawoedhayzinga mura kuyku nidhane Abramalpa a nungu kaziw kazipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nuy Kuykulnga Abraman ngulayg paladhin kedha, ‘Ngath karngeminu kedha, sena Sodomaw, Gomoraw muliya muynu ipidhadh gegeyadh za mura. ");
INSERT INTO mwp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ngay kay mulupa mepa sepalbi goegathoepa yapupoeybaypa a imaypa kedha, ina mina ngath midh karngemingu?’ ");
INSERT INTO mwp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Palay yaday woeyay mabayg mulupa uzarmoedhin Sodomoepa. Kuykulnga a Abrama palay yawayg; palay si gimal ya pugemoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kalanu Abrama nuy kuykulmaypa kuyku wakayayl yapu poeybaydhin kedha, ‘Ngidh bangal idimoene senabi goegath, a mura mina mabaygal a wati mabaygal a? Zangu mingu ngidh bangal mina mabaygal lak idimoeyne? ");
INSERT INTO mwp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Thana sike sey pipti mina mabaygal goegathoenu muynu; pipti nanga mina mabaygal nanga, wa ngay ngibiya yoewdhiz, ngidh gar bangal thana kalmel mura idimayg. ");
INSERT INTO mwp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ngibepa koey zageth kedha zapa aymoeypa, mina mabaygal a wati mabaygal kalmel idimoeyn, kedha zoenguz kedha ngi nubi apaw goewaw minamay mabayg, ngidh ngaru zapul balbayginga buwayl idimpa, ngi mina zagethaw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Wa, nuy Kuykulnga Abramalpa kedha kuniya mulaydhin, ‘Ngath nanga mina mabaygal imedhe nanga, ngayapa Sodomoepa idimoeypa lawnga, ngath bangal kasa wanane, kuyk pipti mina mabaygal dhuray muynu.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrama lak mulaydhin Kuykulmaypa kedha, ‘Ngay gar ngibiya yoewdhiz pawoeyar, ngawngu ngibepa koey dharadh ngaru yangu, ngay kasa mabayg, ngay balbayginga lawnga mina yangukudupa sey sithamaypa ngibepa, ");
INSERT INTO mwp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","kasa kay kedha wara kedha, sey moenarimayl poti payb mina mabaygal, ngidh bangal thana ngaru idimoeyne a? Minguz kedha setha moenarimayl, matha payb thanamulngu matha lawnga.’ Nuy Kuykulnga kuniya mulaydhin kedha, ‘Sena balbayginga, ngayapa senabi goegathoepa idimoeypa lawnga, ngath bangal nanga imedhe poti payb mina mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrama lak mulaydhin kedha, ‘Wara kedha, matha poti nge.’ Kuykulnga kedha mulaydhin, ‘Ngayapa idimoeypa lawnga, kasa midh poti lawnga moenarimayl mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrama Awgadhoepa lak mulaydhin kedha, ‘Kuykulnga ngidh gar ngayapa gegeyadh gasamayg, ngay gar ngibepa lak mulepa, ngidh kay na matha thoerti imepa midh?’ Nuy Kuykulnga kedha mulaydhin kuniya, ‘Wa, thoerti mina mabaygal balbayginga, ngayapa idimoeypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrama mamu kedha mulaydhin, ‘Ngay gar ngibeya yoewdhiz, ngidh gar pawayar ngayapa ngaw moegina apasigi yoewdhay; wara kedha ngidh matha bangal twenti mina mabaygal imedhe midh?’ Kuykulnga Abramalpa kuniya mulaydhin kedha, ‘Ngayapa senabi goegathoepa a twenti mina mabaygoepa idimoeypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrama mamu nge lak mulaydhin kedha, ‘Ngay gar apasin ngibiya, ngayapa kay wati ngoenakap gasamayg, ngay ngibepa mina moeygoepa mulepa kedha, ten kay na mina mabaygal midh?’ Kuykulnga kedha mulaydhin Abramalpa, ‘Ngayapa ngaru senabi goegathoepa a ten mina mabaygoepa idimoeypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Senawbi koeliya nanga palay muwasidhin ya sagul, dhadh pulgemoedhin; Kuykulnga miyaydhin a Abrama nungu lagoepa kuniya miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Palay nanga ukasar yaday woeyay mabayg Sodomoenu mangemoedhin kutoepa, Lotha nuy goegathaw yabugudaw pasagudoenu nir. Nuydh nanga palay imoemoedhin nuy koezi pa uzaraydhin palamulpa ayawal maypa. Nuydh palamuniya parunu apasin kuyk patidhadhin ");
INSERT INTO mwp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","a kedha mulaydhin palamulpa, ‘Ayawal, ngay mura mabaygaw ibupuydhay mabayg, ayawal ngalpa ngaw lagoepa. Ngipel kay sepal ngar garwalgempa a ngipen uthuy kay ngaybiya. Ngipel mina bathaynga kay kaykedh uzarampa inuriya.’ Kasa palay kedha mulemoedhin, ‘Lawnga ngalben uthuy kay adhal goegathoenu dhadhal.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kasa kay kedha nuy palamulpa thuma umay, kurusipa palay nubiya asimoemoedhin nungu lagoepa. Kalanu Lotha nungu zagethaw mabaygoepa mulaydhin kedha, ‘Ngitha kay kunaw susul aymoey a kapu ayde kay buth pathamoey palamulpa aygudoepa.’ Mura nanga muwasidhin kalanu thana purthadhin. ");
INSERT INTO mwp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Palay kay wagel kay uthuypa uzarampa thana sew Sodomaw garkazin kulay lag kidh nuradhin, kayn mabaygal a koey mabaygal. ");
INSERT INTO mwp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mun na asidhin nanga thana Lothalpa wal miyaydhin kedha, ‘Sepal mabayg ngalaga, ngibiya uthuypa kaybaw kubilpa? Palay ngapa adhapa mamamar, ngoeymulpa kidhakidhan wati sagulpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lotha palay kaludhoemoedhin, nuy adhapadhaydhin thanamulpa a pasa thamudhadhin nubiya wagel. ");
INSERT INTO mwp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nuy kedha thanamulpa Sodomaw mabaygoepa, ‘Ngitha ngaw kapu igalgal, ngay gar ngithamuniya yoewdhiz, sena adhapudhay gegeyadh aymayg. ");
INSERT INTO mwp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ngithamun nanga ubi, ngath kay ngithamulpa ngaw ukasar kazimay muwamu ngoewakaz mamoempa. Ngath palay boey adhapa mamoempa ngithamulpa ngithamun ubipa. Kasa kay kedha ngitha kay ngaru za aymayg koepa ukasar yaday woeyay mabaygoepa, sepal ukasar dhadhiya pudhay mabayg ipal ngaybiya kaybaw kubilpa. Ngath kay ngaru palay danal pathampu.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kasa kay kedha thana mulemidhin nubepa kedha, ‘Adhapa uzar lagagi mabayg, ngi ngalagaw mabayg in mepa? Ngidh kay midh ngoey ngurpamoeypa itha a? Ngidh kay na ngoeymulpa lag woenayg ngoey kay ngibepa mina wati za ayimpa.’ Thana kalanu Lothan kabuya guythuyar, lagiya muypa. Thanamun ubi kedha thana kay pasa patidaypa ");
INSERT INTO mwp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","kasa kay kedha palay yaday woeyay mabaygan geth luwoeyamoedhin a nuyn Lothan muypa madhin kalanu pasa thamudhoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Palay kalanu sethabi mabaygal adhal, mina mura mathamoeydhin a thana mamu thanamun purkaw buya guythuyadhin. Kalanu thana kasa yan nuthemir lagaw pasapa imaypa, thana ngaru imayginga. ");
INSERT INTO mwp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Palay kalanu mulemoedhin Lothalpa kedha, ‘Nginu nanga kay igalgal memayipa nanga, garkaz kazil, a yoepkaz kazil, a nginu mura iral, nginu buway mabaygal thana mamayir, adhapa bangal koezi memayine thabi lagoengu. ");
INSERT INTO mwp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Minguz kedha, ngalbe ngaru bangal ngaru nubi lag idimoene. Kuykulmayn nuydh karngemin Sodomaw wati yangu wakay midh nanga. Ngalbe bangal ngaru idimoene Sodom kasa midh.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lotha uzaraydhin nungu kazi mi kawakuya bangal nanga niyaypa yoelpamoene a nuydh palay ngulayg palimoedhin kedha, ‘Ngalpa koezi sobaginga adhapa goegathoengu. Awgadhan kay nabi goegath idimoeypa.’ Kasa kay kedha palamulpa kedha, nuy muku yangukudu ya yadu umepa, palay ngoelkay yoepathamar. ");
INSERT INTO mwp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bathaynga nanga goeyga palay angela, yaday woeyay mabaygan Lothan kazayginga mar. Palay kedha, ‘Nginu ipi kazil kusumar a paypa ladhu koezi adhapa, ngithamulngu umangu ina kay idimoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nuy Lotha mina moegina bal sir, kasa kay kedha Kuykulnga nungu koerkak boedhan Lotha adhapa yoelpadhin. Palay angela kalanu thana apu thath kazi gethan yoelpamoeydhin adhapa Sodomoengu. ");
INSERT INTO mwp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Urapun angela kedha mulaydhin, ‘Zilmemiw ngithamun igilpa. Kuniya kay noegayg, a bal thoerayg padaw dhadha sakara. Matha wamayziw pa padapa kadaypa, ngithamulngu umangu.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lotha kuniya mulaydhin kedha, ‘Maygi gar, ngitha gar ngoey kedha maygi. ");
INSERT INTO mwp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ngipel ngoeymulpa koey adhapudhay ibupuydhay aymoenu, ngoey lak igililmayl, kasa kay kedha sethabi padal mina koey sigal. Ngoey bangal kasa dhadhal umamayl sethabi wati zoengu. ");
INSERT INTO mwp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ngipel sena moegina goegath iman pinangap a? Sena amadhan ngoedhalnga, ngalpa gar matha sepa amadhan? Ngipel kay imaypa, na kasa moegina goegath, ngoey bangal balbayginga setha, wara gegeyadhoepa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nuy angela kedha mulaydhin, ‘Wa, ngitha bangal matha sew, ngalbelpa senabi moegina goegathoepa idimaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kazaginga zilmemiw, ngayapa zapa aymaypa lawnga, mamu kay ngitha ngabunoepa sethabi moegina goegathanu.’ Lotha nan kedha tharaydhin, Zowa, kedha zoenguz kedha na moegina goegath. ");
INSERT INTO mwp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bathaynga na goeyga mer Lothaya goeygil goeygil mangemir Zowanu, senabi moegina goegathoenu. ");
INSERT INTO mwp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Senabi thonara zagi dhadhabuthanu nanga Awgadhan komal bukeral buwaylmayl a komal kulal aridh woeydhadhin daparngu gimaz Sodomaw Gomoraw muliya. ");
INSERT INTO mwp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A nuydh mura idimoedhin senabi koey padaw dhadhasoekara, mabaygal a mura thanamun za koey garsar, matha kedha mura bupaw nagul mina mura ridha ridhal pathar. ");
INSERT INTO mwp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","*A matha kedha, Lothan ipi koeliya nagaydhin nanga, senabi muyngu bibirin nan gasamoedhin nanga na kasa nge kula tharthayadhin senabi muyngu muthukun. Nanu kuth kedha. ");
INSERT INTO mwp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wara bathaynga nanga mina inuriya, Abrama kikimidhin sipa thonarpa palay Awgadhaw ngalaga nanga ya soegul siyamar. ");
INSERT INTO mwp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nuy nanga nagaydhin mulupa palamun siyayzimayngu. Nuydh Sodomaw Gomoraw padaw dhadha sakara, kasa nge thu wayar, mina koey muyngu thu. ");
INSERT INTO mwp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Awgadhan na idimoedhin sepalbi goegath, a padaw dhadha sakara Abraman tukuypaw kazi Lotha ngalaga nanga kulay niparu, nuydh Abraman wakay thoemamayn gasamoedhin, nuydh kedha zoenguz nungu tukuypaw kazi gudaz puydhadhin balbaygi maypa. ");
INSERT INTO mwp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Thana nanga si Zowangu niparu nubiya Lothaniya aka muynu araydhin ngaru sew Zowanu maythayle. Kalanu nuydh nungu ukasar yoepkaz kazi mamamoedhin padapa kadaypa memayidhin. Thana si sakayinu memayipu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Na kuykuyg yoepkaz kazi kedha mulaydhin nanu yoepkaz kuthaygoepa, ‘Ngoeban thathi mina koey thathi ayimpa, a ina mina garkazoeginga ngoebalpa niyaypa yoelpaypa a ngoebalpa kazipa gasamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aya ngoeba ngoeban thathi umal ngukiw poeybaypa, nuy kay um walepa ngoeba kay nubiya uthuy yoewnampa, lak bangal ngoeba kazilayg ngoeban thathingu nungu nelpa oengaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Senabi kubilu nanga palay nuyn mina koeyma umal ngukin poeybadhin. Kalanu na kuykuyg yoepkaz kazi nubiya uthuy yoewnadhin. Nuy palamun thathi sinubi thonara mina koey umanga, nuy koerawayg kedha nuydh za miyay aymoedhin a na sizi midh thonara uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wara goeyginu nanga na kedha nanu yoepkaz kuthaygoepa, ‘Ngay ngoeban thathiya kubilu uthuy yoewnangu. Wa, ngoeba kay nuyn lak gurukun poeybaypa a ngi ngedh kay nubiya uthuy yoewnaypa. Ngoeba bangal ngoeban thathiw kazilayg nungungu nelgi oesile pawpa napapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Palay senawbi kubilu nuyn lak umal ngukin poeybadhin. Kalanu na kuthayg yoepkaz kazi nubiya uthuy yoewnadhin. Nuy palamun thathi sinubi thonara mina koey koerawayg kedha nuydh za miyay aymoedhin a na sizi midh thonara uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Wa, nungu Lothan ukasar yoepkaz kazi kedha zoenguz maythalayg aymoemoedhin palamun thathingu. ");
INSERT INTO mwp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kalanu nadh kuthayg yoepkazin garkaz kazi imadhin. Nadh nuyn kedha tharadhin Mowab a nungu kaziw kazil kayib kedha tharepa, Mowabalgal. ");
INSERT INTO mwp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nadh lak kuthayg yoepkazin garkaz imadhin. Nadh nuyn kedha tharadhin Benami, a nungu kaziw kazil kayib kedha tharepa Amonaythalgal. Sena nuy kedha kuniya kazimay ngapa parungu Lothan kaziw kaziw ya. ");
INSERT INTO mwp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrama nuydh nungu tental lak thamayidhin Mamrengu Kananapa zeya doegampa, nuydh nubepa dhadhabuth imadhin. Goegathoengu moegina sigal, goegath Kades zeya doegamoenu a goegath Soer wara dagamoenu. Nubiya kalmel nungu ipi Seray, a nungu mura zagethaw mabaygal a tetel uruyl. Thana mura gurguy toedipu, bupaya lumemipu uruypa. Kurusipa thana wara goegathoenu ngabunadhin, goegath nel Gerar. ");
INSERT INTO mwp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Lagaw mopakuyk si meparu nel Abimoelek. Abrama nuydh Geraraw mabaygal na imaydhin nanga nuy kedha thanamulpa, ‘Ina nabi yoepkaz nanu nel Seray, na ngaw babath.’ Kalanu thanamun Geraraw mopakuykun mabayg wayaydhin Seraylpa yoelpaypa nubepa ipi. ");
INSERT INTO mwp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Wa, nungu muynu ubi nubepa ipi kidh thoeyaypa. Wara kubilu Awgadhan pikin tharaydhin nubepa Abimoelekoepa, kedha mulaydhin nubepa, ‘Abimoelek ngitha bangal umamayl, kedha zoenguz kedha ngidh nan Serayna madhin ngibepa ipi, na wara mabaygaw ipi.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimoelek nuy kuniya mulaydhin kedha, ‘Kuykulnga, ngath wati za aymayginga! Ngidh bangal midh paru ngoena ngaw mabaygal idimoeyne? ");
INSERT INTO mwp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nuy Abrama ngayapa kedha, na Seray nungu babath; a nanu ya lak kedha Abraman midh nanga. Sena ngaw kuyk lawnga, a wara ngath nan gasamayginga, a wara za gegeyadh aymayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Awgadh lak mulaydhin nubepa senabi pikinu, ‘Wa, ngay ngulayg kedha, ina nginu kuyk lawnga, ngath kedha zoenguz ngin panidhan wati pawangu aymoeyle, ngaw sabingu pathidhayle, wara mabaygaw ipingu gasamoeyle. ");
INSERT INTO mwp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngidh kay nan kuniya wayar nanu alaypa. Nuy peropetha, nuy kay ngibepa thaythupagepa, ngithamulngu umangu. Koey poeypiyam, ngidh bangal nanga nanu alaypa kuniya woeyayginga ngi a nginu mabaygal, ngitha bangal mura umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bathaynga nanga goeyga miyaydhin nuydh Abimoelek nungu koey mabaygal thurimoeydhin, a ngulayg palimoeydhin. Thanamun aka mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Kalanu nuydh Abraman thuradhin, a nuyn yapupoeybaydhin kedha, ‘Ngidh mipa senabi za ngoeymulpa aymoengu? Ina mina koey gudal gegeyadh, ngaw basalayangu idimoeyle. Ngath za ngibepa kulay aymayginga, ngidh midh paru kedha ayimpa?’ ");
INSERT INTO mwp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nuy Abrama kuniya kedha mulaydhin, ‘Ngay kedha zoengu ngithamulpa mulaydhin kedha, ngay akan. Ngath kedha wakay thamamaydhin nubi goegathaw mabaygal Awgadhoepa kapu akasizi mabaygal lawnga; mabaygan bangal ngoena bangal mathamoene a ngaw ipi bangal manine. ");
INSERT INTO mwp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ngay kedha zoenguz akan. Ngath ngithamulpa sole aymayginga, Seray na ngaw baban kazi, nungu wara ipin nan kazi madhin, ngaw apu lawnga. Ngath kalanu nan madhin ngayapa ipi.’ (Thanamun pawa kedha senabi thonara.) ");
INSERT INTO mwp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","‘Ngath kulkub nabepa kedha ya madhin, mi thonara nanga Awgadhan ngoena wayadhin ngaw thathiw lagoengu, ngalben Serom mab midh thonara azaz lagiya, nanga na mabaygoepa kedha umepu, “Nuy ngoezu babath.” Sena nanu ibupudhay ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kalanu nuydh Abimoelek kuniya madhin nan Serayna Abramalpa, a nuydh wara Abramalpa mamayidhin mamuyl, bulokal, a zagethaw mabaygal. ");
INSERT INTO mwp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Nuy nubepa kedha mulaydhin, ‘Ina ngaw boeradhar mura, nginu ubipa ngidh kay ngalaga niyay lag aymoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nuy Seraylpa kedha mulaydhin, ‘Ngath mina kozan nginu babathoepa maypa urapun thawzoen silba bokadhzapul, ina ngaw ya wadhan ngibepa mura nginu mabaygoepa ngulaygoepa, ngidh wati pawa aymayginga. Mura mabaygal bangal ngulaygal kedha ngidh wati pawa aymayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Senabi thonara mura yoepkazil Abimoelekan lagoenu thana kazipa matha ngoedhagidh lawnga; kedha zoenguz kedha Awgadhaw ubiginga Serayna ipipa wayan. Seray na nanga kuniya madhin nuy Abrama thaythupoegaydhin Awgadhoepa thanamun sirisiripa balbayg poelaypa. Nuy na thathupoegaydhin nanga Awgadhan balbayg tidadhin nuyn Abimoelekan a nungu ipi a zagethaw yoepkazil. Kalanu Awgadhan thana balbayg palimoeydhin kazipa gasamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Awgadhan Seraylpa nungu woenewoen poeybadhin, nuy palamulpa midh nanga mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Wa, na Seray kalanu maythalayg aymoedhin, garkaz kazi imadhin; nuy Abrama mina kulba thathi senubi thonara. Wa, Awgadh kulay Abramalpa mulaydhin Isakan kazimay thonaraw ya. ");
INSERT INTO mwp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrama nuyn nel tharadhin Isaka. ");
INSERT INTO mwp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nungu Isakan eyth goeygil na gasamoeydhin nanga Abrama nungu motho pathadhin, Awgadhaw ya midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Senabi thonara nuy Abrama 100 wathoelayg, nuy thathi aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na Seray kedha, ‘Ina koey ikalnga, koey dhiwalnga. Awgadh, nuydh mina kapu za aymoedhin; mabaygan bangal nanga karngemine, mabaygaw bangal dhiwa koeyza.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","*Seray na lak mulaydhin kedha, ‘Mura mabaygal madhu pamemine bangal ngay Abraman ipi ngulayg kazingu koesimoeyle. Nungu Abraman wathoel mina koeyma kasa kay nungu mapeth in.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Palamun moegina kazi nanga koey mabayg aymoedhin, nuydh susu wanadhin. Senawbi goeyginu nuydh Abrama koey ay aymoedhin, koey zoerazar aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Wara yoepkaz si meparu Serayna niyaykazi Eyga. Nadh kulay kazi madhin Abraman wara garkaz kazi Ismeyl. Seray nan kulay poeybadhin Abramalpa ipi, kazipa gasamoeypa. Senawbi thonara nuy Ismeyl Serayna kaziya sagul sir. ");
INSERT INTO mwp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Seray nanga imadhin na ubigasidhin. Na kedha Abramalpa, ‘Nan adhapa wayar, zagethaw yoepkaz a nanu kazi kalmel, nginu aykuykungu gasamoeyle. Nguzu ubi kedha, matha nguzu kazi Isaka bangal, nginu aykuyk gasamane.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Senabi pathowkamay koey koerkak badhalnga Abramalpa, nungu kazi Ismeyl lak nungu kazi. ");
INSERT INTO mwp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Awgadhan nanga Abraman mapu imadhin nanga nuy kedha Abramalpa, ‘Wakay thamamayg nginu kazipa, a nginu zagethaw yoepkazipa matha aymar Serayna ubilnga. Isaka a nungu kaziw kazil nginu nel bangal oengaypu. ");
INSERT INTO mwp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Wara kazi lak kedha, nuy zagethaw yoepkaziw kazi; nuy bangal lak koey buway mabayg, kedha zoenguz kedha nuy nginu kulka.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Bathaynga nanga goeyga Abrama nuydh ayde ngukil mamayidhin Eyga nanu kazipa. Palamun ngukiw za tetel uruy goengaw yana. Nuydh ayde a nguki wanaman Eygana thabaynu gimal, nanu kazi nabiya kalmel. Nuydh Abrama palay kalanu adhapa wayamoedhin. Na mabaygoegi lagoepa miyaydhin, lag nel Biyasiba. Na kasa gurguy ulaypu, nabiya kalmel nanu kazi. ");
INSERT INTO mwp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kurusipa palamun nguki aygithayadhin. Nanu wakay thoemamay kedha, nguzu kaziw amadhan um. Nguzu ubiginga nungu kuthoepa imaypa. Nadh nuyn kasa wanan, moegina puy kuykunu. ");
INSERT INTO mwp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Na moegina sigapa uzaraydhin, 100 mita sike nungungu. Na thanuraydhin mayarsir. ");
INSERT INTO mwp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Awgadh nuydh nanu kaziw may karngemidhin. Nungu Awgadhaw angela wal miyaydhin daparoengu. Nuy nabepa kedha mulaydhin, ‘Eyga nginu ngoenakap mapu miyay? Akan maygi. Awgadhan nuydh karngeminu nginu kaziw may. ");
INSERT INTO mwp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kaday tari, nginu kazi gasampa, nubepa danal poethaypa. Ngath bangal nungungu wara koey buway aymoene nungu kaziw kazingu.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kalanu Awgadhan kakal aymoedhin nabepa nguki. Nadh na may imadhin nanga palay apu kazi sizi ngukin wanemoedhin. Nadh nanu uruy goengaw ngukiw za nguki maladhin, a nanu kazipa madhin. ");
INSERT INTO mwp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nanu kazi nanga koesimoeydhin, Awgadh nubiya kalmel a nubepa woenab poeybadhin. Nuy mina koey aygethalayg aymaydhin; nungu ayngu gasamayza gagay a thayak. ");
INSERT INTO mwp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Palamun niyay lag nel tharan Mabaygoegi Lag, kurusipa nuy koey garkaz aymaydhin, nungu ama nubepa gasamadhin ipi, Aykupithulgaw yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Wara thonara thanamun Geraraw mopakuyk Abimoelek a nungu koewbu kuyk nel Pikol Abramalpa uzarmoedhin. Nuy mopakuyk mulaydhin kedha, ");
INSERT INTO mwp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","‘Ina kakal Awgadh ngibiya kalmel nginu buyal thayaynu; ngoeba ngaru igalayg. Ngidh Awgadhaw parunu ya wadhar, koezi kayboengu matha mina zapul aymoeypa ngayapa ngaw kaziw kazipa. Ngidh lawnga ngoey mina mamayipa, ngoeban ya wadhan kedha, ngath matha mina zapul aymoeyrngu ngibepa. Matha ngoedhagidh ngidh lak kedha ngayapa a ngaw lagoepa ngi ngalaga na kayib mepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nuy Abrama kedha mulaydhin, ‘Wa sena mina ya, sena ngoeban ya wadhayzinga kedha.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","26","Kalanu Abrama ya madhin Abimoelekoepa kedha, ‘Ngay ngibepa moegina yoepa mepa. Wara nguki ngoeymun aymayzi may, nginu niyay kazil ngoeymulngu madhin.’ Nuy mopa kuyk kuniya kedha mulaydhin ‘Yagar, ngath kulay koerngayginga. Ngi ngayapa mina mulayginga; kedha zoenguz ngay koerawayg ngath ina kay karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kalanu nuydh Abrama poeybadhin mamuyl a kawal nubepa mopakuykupa palamun yawoedhayzimaypa aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nuydh mamayidhin nungu uruyngu mura seben kayn mamuyl. ");
INSERT INTO mwp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nuy mopakuyk kedha yapu poeybaydhin, ‘Setha mipa?’ ");
INSERT INTO mwp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrama kuniya kedha mulaydhin, ‘Ngaw ubi thabi kayn mamuypa ngibepa moeypa. Ngidh nanga thana gasamidhe nanga, sena ngaru kakal mura mabaygoepa kedha, ina may ngaw poemayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Koezi pawpa senabi lag nel Biyasiba. Thanamun ya wadhayzinga kedha. ");
INSERT INTO mwp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ya wadhayzi thonaraw kalanu nuy kuyku mabayg Abimoelek a nungu koewbu kuyk Pikol kuniya uzarmoedhin palamun lagoepa, Pilistayapa. ");
INSERT INTO mwp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kalanu Abrama puy uthudhin palamun ya wadhayzi maynu, koey ridhaw puy nel tamaris. Nuy thoeythu pagaydhin Awgadhoepa, wathaw wathaw Ngaru Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrama a nungu mabaygal kuykuthalnga si niparu, Pilistayoenu. ");
INSERT INTO mwp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","2","Kalanu Awgadhan Abraman nuthadhin nubepa wal miyaydhin kedha, ‘Abrama.’ Abrama nuy kuniya nubepa, ‘Wa, in ngay.’ Awgadh kedha, ‘Ngi a nginu urapun mamal kazi Isaka uzarmoeriw wara koey padoepa, padaw lag nel Moraya ngath ngibepa yadu palgane bangal. Ngidh nuyn bangal ngibiya kalmel manine a padoenu gimal ngidh nuyn muypu nathane ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Bathaynga nanga goeyga nuy Abrama dan palaydhin, urapun nungu donki gasaman. Nuydh nuyn donki balbay tidan rugapa oengaypa. Nuydh thurimadhin nungu ukasar gamu zagethaw mabaygal a nungu kazi Isaka. Watharal tidadhin, thana geth wanemidhin sena mi lag Awgadhan nubepa yadu palgadhin. ");
INSERT INTO mwp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Thoeri goeygi kaliya Abrama nuydh kadaypa nagaydhin, senabi pad imadhin. ");
INSERT INTO mwp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nuy kedha nungu niyaykazipa, ‘Ngipel matha kow donki danal poethaypa; ngay a ngaw kazi koezi uzarampa kadaypa Awgadhoepa thawmaypa, kalanu ngalbe ngapa kuniya ngipelpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nuydh watharal gasamoeydhin, nungu kaziw thabaynu wanadhin, nubepa oengaypa. Nuydh nungu kusaygan koey gi a muyngu muthukul mamayidhin, palay kalmel uzarmoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka nungu baban tharan kedha, ‘Bab.’ Nuy kuniya muliz kedha, ‘Miyay ngaw kazi.’ Nuy kazi kedha, ‘Ngath imanu ngibiya muthukul a watharal, kasa kedha mamuyginga muypu nathaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nuy kuniya nungu kazipa kedha, ‘Matha Awgadh nuydh nubepa maypa mamuy.’ Palay matha kalmel ulmempa. ");
INSERT INTO mwp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kurusipa gasaman senabi lag Awgadh kulay mulaydhin. Nuy Abrama kulan garwoeydhamiz oltapa aymaypa; watharal balbay tidadhin si gimal. Nuydh nungu kazi kunumoedhin, nuyn watharnu gimal wanadhin oltanu. ");
INSERT INTO mwp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","11","Nuydh nungu gi gasamoedhin kazipa mathamoeypa mer, Awgadhaw angela nubepa wal miyaydhin daparoengu, ‘Abrama, Abrama!’ Nuy kuniya, kedha muliz, ‘Wa in ngay.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Angela lak mulaydhin, ‘Nginu kazi poegayg, nuyn wanar. In ngayapa kakal ngi mina mabayg Awgadhaw ubilmay mura aymoeyrngu nungu thawmayzi mabayg. Ngi lawnga kedha, ngidh nginu kazi Awgadhoepa poeybayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrama nuy kalanu nagaydhin, garkaz mamuy imadhin, nungu on sirisirnu alalayzinga nuydh senawbi mamuy gasamadhin kalanu muypu nathadhin senabi oltanu, nungu kaziw buthapa. ");
INSERT INTO mwp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrama nuydh senabi lag nel tharadhin kedha, Awgadhaw Poeybayzinga. Kedha zoenguz kedha umamoeypu kurusipa kayib kuykulmay pad say kay gimal ayman, ngalpalpa ibupuydhay ayman. ");
INSERT INTO mwp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kalanu Awgadhaw angela lak wal mizin nubepa kedha, ‘Ngath ngaw yawoedhayzinga koey zageth pathidhan, kedha zoenguz ngay waza Awgadh. ");
INSERT INTO mwp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ngath ngibepa ya wadhan kedha, ina mina ngay Awgadh kedha yadu umepa, ngaw ngibepa woenab a nginu kaziw kazil ngaru bangal mina koey garsar ngoedhe lak buthul thawala midh nanga a daparaw thithuyil midh nanga; minguz kedha, ngidh nginu kazi kuniya gasamoeyginga. ");
INSERT INTO mwp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kedha zoenguz kedha nginu kaziw kazil bangal ngaru koeyma boeradhar gasampu thanamun wati igalgoengu. ");
INSERT INTO mwp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mura buwayl ngayapa bangal umamoeypu woenaboepa ngath ngibepa midh nanga woenab poeybadhin. Minguz kedha ngidh ngaw ubilnga aymoedhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kalanu nuy Abrama a nungu kazi, mulupa pagamoedhin zagethaw mabaygoepa. Thana mura kuniya Birsibapa. Abrama nuy si meparu. ");
INSERT INTO mwp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Wagel bangal Abrama ya gasamadhin, karngemidhin kedha nungu tukuyap Nayo lak kazilayg. Nungu ipi Milka palamun kazil eyt mura thurkiyay kazil. ");
INSERT INTO mwp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kuykuyg kazi nel Uz, nubiya wagel Buz, a nubiya wagel Kemwel. Kemwel nuy Araman thathi. ");
INSERT INTO mwp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Wara Nayon kaziw nelay itha kedha Kesed, Azo, Pildas, Zidlal a moeygoepa kazi Bethwel. ");
INSERT INTO mwp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethwel nuy lak kazilayg urapun nungu yoepkaz kazi nel Rebeka. Wa itha Nayon ipi Milka palamun eyt mura thurkiyay kazil. ");
INSERT INTO mwp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wara yoepkaz nuydh nungu zagethaw mabaygoengu gasaman a ipipa kidh thayadhin. Nanu nel Rewma. Nadh kazi madhin nungungu Nayolngu kaziw nelay kedha, Teba, a Gayam, a Tayas, a Maka. ");
INSERT INTO mwp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Abraman ipi Seray kurusipa koey apu aymaydhin, nanu 127 wathoel na gasamoeydhin, nan guythuyadhin. Thana senabi thonara Ebronanu memayipu, Kananaw doegamoenu. Nuy Abrama mayoersir. ");
INSERT INTO mwp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","4","Nuydh nanu gamu wanadhin sey lagoenu nuy Ithaythaw goegathoepa uzaraydhin mura zapul balbaytidaypa nabepa. Nuy thanamulpa Ithaythaw buwaypa mulaydhin kedha, ‘Ngitha waza ngulaygal kedha, ngay azaz mabayg in mepa ngithamuniya ngay koey sigaz ngapa. Ngay kedha zoengu kedha sakaypa barpudaypa ubin mepa nanu gamupa wanaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Thana Ithaythaw buway kedha, ‘Sa ngi wara koey mabayg ngoeymuniya in, kasa nginu ubipa sakay ngidh mar, nanu gamupa wanaypa, ngoeymuniya mabaygoeginga ngibepa panidhaypa, senabi zangu aymoeyle kasa ubipa sakay. Nginu ubil sakay ngalaga?’ ");
INSERT INTO mwp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Wara buway thathi sey thanamuniya ya umay lagoenu nipa nungu nel Epron. Nungu thathi Zowa. Abrama thanamulpa apasin kuyk pathiz nuy kedha, ");
INSERT INTO mwp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","‘Ngithamulpa gar balbayginga ngath nanu gamu kulaw sakaynu wanaypa, mamu Epronalpa yapu poeybepa. Ngitha nubepa yapu poeybemiw, ngath ngayapa barpudoepa urapun sakay nungu boeradhoerangu, sakay nel Makpela. Nungu boeradhoeranu dhadhal lawnga, sena kuth thoepi, nubepa balbayginga kedha ngath kay barpudoepa? Ngitha nubepa kedha mulemiw, ngath kay mina modhab nubepa maypa, ina ngithamuniya parunu.’ Mura mabaygal ngaru ngulaygal senabi sakay bangal ngaw buway koey mudhaw lag. ");
INSERT INTO mwp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nuy Epron sey goegathaw pasagudanu amadhan, mura Ithaythaw buwaynu parunu. Nuy mulaydhin kedha Abramalpa, ");
INSERT INTO mwp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","‘Wa, ngath kasa ngibepa maypa mura nan koey boeradhar sena sakay ngalaga nanga. Ngay ngibepa kedha mulepa in mura ngaw buwaynu parunu, kedha zoengu ngidh kay aymar, sena kay nginu ipiw gamu koew wanar ngoeymuniya.’ ");
INSERT INTO mwp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kasa kay kedha nuy Abrama lak thanamuniya apasidhin a kuyk pathidhaydhin, ");
INSERT INTO mwp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","lak yapu poeybaydhin Epronalpa kedha, ‘Sa, ngay gar ngibiya yoewdhiz, ngath nginungu barpudoepa boeradhar mura, a sakay. Ina gar ngaw bokadhza ngidh gasamar, a ngath kay nanu gamu wanaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nuy kuniya kedha mulaydhin, ");
INSERT INTO mwp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","‘Ngidh mipa wakay thoemamipa senabi boeradhaw modhab matha 400 silba bokadhzapul. Ngidh nanu gamu sew wanar.’ ");
INSERT INTO mwp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrama nuy kedha, ‘Wa, ngath ngibepa maypa.’ Nuydh Ithaythaw buway mabaygiya parunu madhin 400 kula bokadhzapul silbal, nuydh mapu seysithamay zapunu gimal wanaydhin Epronalpa mi bokadhza nanga madhin sawalagoenu midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Na kedha zoengu senabi boeradhar Abraman za aymaydhin Epronalngu, sena sakay ngalaga nanga mura puyil kalmel, Makpelanu Mamrepa amadhan. ");
INSERT INTO mwp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Thana Ithaythaw mabaygal mura ngulaygal senabi doegam pasi nanga mura Abraman za aymaydhin. Mura mabaygal ngaya nanga ya umay lagoenu memayir. ");
INSERT INTO mwp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kalanu nuy Abrama nanu gamu senabi kulaw sakayinu muynu wanadhin Kanananu. ");
INSERT INTO mwp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Senabi boeradhar koey mudhaw lag aymaydhin nungu buwaypa. Thana Ithaythaw buwayn nubepa madhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Senabi thonara Abraman wathoel mina koeyma, nuy ngulayg kedha, Awgadhan nubepa woenab poeybarngu nungu igililmaypa mura. ");
INSERT INTO mwp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wara nungu zagethaw mabayg lak koey mabayg nungu wathal mura wara zagethaw mabaygiya gimal. Matha nuy Abraman getha doegam zagethaw mabayg. Abrama nubepa mulaydhin, ‘Ngidh piti madhuya apiya geth mar, mina ya muli Awgadhaw parunu. Ngidh bangal mura ngaw ubilmayl aymoeypu. ");
INSERT INTO mwp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nuy mina nubi apaw goewaw Awgadh, gimal daparaw Awgadh, ngidh lawnga ipi gasampa ngaw kazipa koezi Kananaw yoepkazingu. ");
INSERT INTO mwp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ngi ngaru bangal kuniya ngoena ngalaga nanga kazi madhin ipipa gasamaypa, ngaw thurkiyay kazipa Isakalpa nungu ipi bangal ngaru ngaw buwayngu.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kalanu nuy zagethaw mabayg yapu poeybaydhin kedha, ‘Wara kedha na ngoewakaz ubigasin ngaybiya ngapa kuniya oesile nabi goegathoepa ina nginu lag mina koey sigal, ngath bangal midh manine? Ngath bangal kasa Isakan kuniya yoelpane nginu thathiw kuyku lagoepa?’ ");
INSERT INTO mwp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nuy kedha, ‘Maygi! Nuyn kuniya yoelpayg, ");
INSERT INTO mwp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ina nubi boeradhar Awgadhaw ya wadhayzinga ngayapa a ngaw kaziw kazipa. Awgadhan nanga ngoena yoelpadhin ngaw thathiw lagoengu, ngaw mura buway lagoengu. Wa, nuydh Awgadhan bangal ngibiya wayane nungu angela ngibepa danal pathaypa, nginu zagethoepa ibupuydhaypa. Ngidh ngaw kazipa ipi gasamane ngay ngalagaz nanga ngapa. ");
INSERT INTO mwp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wara kedha ngoewakaz ubigasin ngibiya ngapa oesile, wa, ngi bangal kalanu ubipa nubi wadhayzimayngu. Kasa kay kedha ngidh bangal nuyn kuniya oengayg senabi lagoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kalanu nuy zagethaw mabaygan nungu geth Abraman piti madhunu apal wanadhin, senawbi ya woedhayzi yoepa ridha poelaypa, Abraman yangukudupa aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nuydh zagethaw mabaygan mura rugal buthpathamoeydhin nungu yawarpa. Nuydh Abramalngu ten mura kamelal gasamoeydhin, koey tetel uruyl. Kalanu nuy miyaydhin naygay doegampa Mesopoetaymiyapa, Abraman buway mabaygaw lagoepa, Nayon lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kurisipa nuy mangaydhin nuydh nungu kameloepa wal mizin kedha, ‘Apa nithamaw.’ Thana apiya poeydhan maynu pasinu. Senabi may sey goegathoenu adhal. Goeyga kay pawpa aymipa, thana goegathaw yoepkazil ngapa ngukipa. ");
INSERT INTO mwp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nuy thoeythupagaydhin kedha, ‘Awgadh, ngi ngaw kuyku mabaygaw Awgadh, ngidh ngaw kaybaw zageth ridh palar. ");
INSERT INTO mwp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ngidh lak nginu mam a woenab poeybar ngaw kuyku mabaygoepa, Abramalpa. Ngi waza mura Kuykulnga ngibepa kakal ngay in ngukinu pasinu a itha mura yoepkazil ngapa ngukipa. Thana mura nubi goegathaw kazil. Ngay gar koerawayg yoepkaz nga matha ngoedhagidh ngaw kuyku mabaygaw kazipa ipi, ngayapa gar kakal aymar, ngoewakaz nga? ");
INSERT INTO mwp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","‘Na bangal nanga aymidhe, ngay bangal wara ngoewakazipa muledhe kedha, “Ngayapa gar kusungu nguki ngapa.” Na na kedha kuniya ngayapa, “Wani matha ngi lawnga ngukipa, mura ubipa nginu kameloepa lak kedha, ngath lak nguki gasampa nginu kameloepa mura.” Ina kay sikedh nabi yoepkaz ngidh adhapa thamadhin nginu zagethaw mabaygoepa ipi Isakalpa. Wa, nadh kasa nanungu kedha koey zageth aympa kamelal ngukin poeybepa, ngay ngulayg asin kedha, wa ina nginu adhapa thoemayzinga ipi, nginu poeybayzinga ngaw kuyku mabaygoepa. Na na kedha zagig nanga, na lawnga, ngidh bangal wara ngoewakaz adhapa thamane.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Abraman tukuypaw mabaygal si sethabi thonara. Nayo a nungu ipi Milka, palamun kazi Bethwel a nungu ngoewakaz kazi Rebeka. Wa Abraman zagethaw mabaygaw thoeythu poegaynu amadhan kuthoepa nanga Rebeka ngukipa uzaraydhin sizi, nabiya nanu koey ngukiw za kusu thabaynu mer. Na mina kapu ngoewakaz, alaygig, na garkazingu koerawayg. Na maypa mulupa ngukipa moelaypa uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Na na koezi dhadhiya aymiz nanga, nuy Abraman zagethaw mabayg tari zilamiz nabepa muliz kedha, ‘Ngidh gar ngayapa seyzi kusungu nguki?’ ");
INSERT INTO mwp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Na kedha, ‘Wani.’ Nadh sobaginga thabayngu mulupa madhin ngukilnga kusu gasaman. Nuy waniz. ");
INSERT INTO mwp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nuydh nanga muwasin, na kedha, ‘Ngath lak nguki gasampa nginu kameloepa mura.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nadh sobaginga nanu kusu pay yoewdhan kamelaw ngukiw zapunu, kalanu na lak ngukipa zilamiz, kurisipa kamelan mura nguki wanimoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nuy zagethaw mabayg kasa nan danal pathar wara yaginga imaypa kedha Awgadhan sike nungu mab kuyku nidhan. ");
INSERT INTO mwp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamelan nanga nguki wani muwasin nanga nuydh zagethaw mabaygan nungu rugangu koey modhabil zapul gasamoeyn. Nuydh nabepa mamayin wara piti oengay za, a ukasar gethiya oengay za, thana mura koethilmayl, goli zapul. ");
INSERT INTO mwp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nuy kedha, ‘Ngay apasin ngibiya ngayapa gar muli nginu thathi nga, sey gar buthalnga ngoeymulpa ngaw mabaygal a ngay, kasa urapu kubilpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Na kedha, ‘Ngoezu thathi Bethwel nuy Nayon kazi, a nungu apu Milka. ");
INSERT INTO mwp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ngoey aydegal nginu kameloepa, kapu uthuy lag thanamulpa lak mepa a ngithamulpa lak kedha.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Nuydh nanga karngemidhin nanga nungu ngoenakap mina koey dhiwalnga. Nuy lak Awgadhoepa apa pudhaydhin eso poeybaydhin a thawmadhin. Nuy kedha, ‘Ngi mina adhapudhay Awgadh ngaw kuyku mabaygaw Abraman Awgadh. Ngidh mina aymarngu nginu yawoedhayzinga midh nanga. Ngidh ngoena balbayginga yoelpadhin ngaw kuyku mabaygaw buwaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Na ngoewakaz zoelmaydhin nanu apuwaw lagoepa mura yadu thuray aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Nanu babath nuy sey mepa nungu nel Leyboen. Nuydh na karngemidhin a imadhin nan a goli zapul nabiya, kalmel pitiya gethiya nuy sobaginga imaypa uzaraydhin Abraman zagethaw mabaygoepa. Nuydh nuyn iman ngukinu pasinu kaday sir nubiya kalmel nungu kamelal. ");
INSERT INTO mwp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nuy Leyboen kedha, Abraman zagethaw mabaygoepa, ‘Sa, mina ngi Awgadhaw woenabal mabayg, matha ngoedhagidh lawnga ngi in adhal. Ngaw lag ngithamulpa buthalnga a ngithamun kameloepa lak kedha.’ Kalanu thana mura lagoepa memayidhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nuy Abraman zagethaw mabayg lagiya muy uthiz. Nuydh Leyboen mura kalmeloengu zapul adhapa memayin. Kalanu bupan poeybaydhin thanamulpa purthaypa, wara bupal thanamulpa apiya yuwipa nuydh ngukil kusumoeydhin thanamulpa mangayzi mabaygoepa ngaroepa garwoelgaypa. ");
INSERT INTO mwp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A kalanu aydel thanamulpa, kasa kay kedha Abraman zagethaw mabayg kedha mulaydhin thanamulpa, ‘Thuma, ngay kay ngaru ngithamulpa kulay a mulepa kalanu kay aygud.’ Leyboen nuy kedha, ‘Wa, muli.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nuy zagethaw mabayg kedha, ‘Wa, ngay Abraman mabayg, ");
INSERT INTO mwp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Awgadhan koeyma woenab poeybadhin Abramalpa, nungu zapul koeygarsar mamuyl, nanil, kawal, silbal, golil, koeygarsar, zagethaw mabaygal, yoepkazil, matha kedha garkazil, wara kamelal a donkil mura koeygarsar nungu zapul. ");
INSERT INTO mwp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","‘Ngaw kuyku mabaygaw ipi Seray na koey apu aymaydhin nanga palay thurkiyay kazi gasamoedhin. Nuydh nubepa senawbi kazipa poeybadhin mura nungu zapul, ");
INSERT INTO mwp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","kalanu nuy ngayapa kedha, ngath ngaru ya wadhan nubepa kedha, mura nungu ubilnga aymaypa nungu kazipa. Nuy kedha ngayapa, “Ipi gasamayg koezi Kananaw ngoewakazingu ngaw kazipa. ");
INSERT INTO mwp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ngi ngaru ngaw thathiw buwaypa kuniya. Ngidh ngaw buwayngu ipi gasamar nubepa.” ");
INSERT INTO mwp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","‘Kalanu ngay yapupoeybiz kedha, na ngoewakaz sike ubigig ngaybiya ngapa kuniya Kananapa oesile. ");
INSERT INTO mwp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nuy kedha, “Nuydh Awgadhan bangal ngin danal pathaypu, kedha zoenguz kedha ngath mura thonara ngungu ubilmayl aymoeyrngu. Nuydh bangal nungu angela wayane ngibepa, danal poethaypa, nginu zagethoepa kuykunidhaypa. Ngi ngaru ngaw buwaypa bangal Isakalpa ipi lumepu. ");
INSERT INTO mwp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ngoeban ya woedhayzimayngu pathidhayle kasa kay kedha thana nanga ubigigal nanga ngoewakaz ngibiya na woeyayg nanga, wa ngoeban ya wadhayzinga kasa gegeyadh ngi bangal nginu ubipa.” ");
INSERT INTO mwp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ngay ina kayb na mangema nanga nubi ngukiw maynu, wa ngaw thoeythupoegay kedha Awgadhoepa, Kuykulnga ngi ngaw kuyku mabaygaw Awgadh, ngidh gar nungu ubilnga kuyku nidhar. ");
INSERT INTO mwp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ngay gar in pasinu maynu nipa. Ngidh ngayapa kakal aymar, ngoewakaz na bangal nanga aymidhe ngay bangal ngoewakazipa muledhe kedha, “Ngayapa gar nguki ngapa.” ");
INSERT INTO mwp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","‘Wa, ina kay sike nabi ngoewakaz ngidh adhapa thamadhin nanga ngaw kuyku mabaygaw kazipa ipi. Wa kedha nanga na ngaru kedha muledhe, “Wa, wani ngath kay kalanu nginu kameloepa nguki maypa.” ");
INSERT INTO mwp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","‘Ngaw thoeythupoegaynu muynu amadhan kuthapa, na Rebeka mangiz nabiya kalmel nanu ngukiw za kusu. Na maypa woelmay ngukipa. Kalanu ngay ngukipa yapupoeybiz, ");
INSERT INTO mwp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nadh sobaginga nanu kusu gasaman, kalanu ngayapa woenipa nguki manin. Na kedha mulaydhin, “Ngath kay kalanu nginu kameloepa nguki maypa!” Wa ngay waniz, kalanu nadh kamelal ngukin poeybiz. ");
INSERT INTO mwp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ngay nabepa yapupoeybiz, “Nginu thathi nga?” Nadh ngayapa mura sakar manin nanu thathiw doegam, Bethwel, Nayom Milkom kazi. Kalanu ngath nabepa piti oengayza manin a gethiya oengayza. ");
INSERT INTO mwp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ngay kalanu kulun pasoeyniz thawmanin a eso pugiz Awgadhoepa kedha, ngi mina ngaw kuyku mabaygaw Awgadh. Ngidh ngoena balbayginga gethiya yoelparngu ngaw kuyku mabaygaw buwaypa. Ngayapa kakal kedha, nuydh Awgadhan ngithamun yoepkaz kazi adhapa thamadhin Abraman kazipa. ");
INSERT INTO mwp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Sa, ngitha nanga nubi za balbayginga buwayl thayane nanga ngaw kuyku mabaygoepa, ngayapa mulemiw midh nanga, ngath kay bangal pudhamayne, ngath bangal midh paru kuykul za aymoene nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leyboen a Bethwel palay kedha, ‘In nubi za Awgadhoengu ngapa, ngoeymulpa kuthoepa maypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Wa, Rebeka ina mariw nginu kuyku mabaygaw kaziw ipi bangal aymoene Awgadhaw mulayzinga midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nuydh nanga Abraman zagethaw mabaygan karngemidhin, nuydh kuyk patidan a thawmanin Awgadh. ");
INSERT INTO mwp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kalanu nuydh mina thoeyaygi kapu dhoemawakul a silba goli koethil zapul nabepa Rebekalpa kusumadhin a mina koey modhabil sibaw wanay zapul kusumoedhin nanu babathoepa a nanu apupa. ");
INSERT INTO mwp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kalanu Abraman zagethaw mabayg a nungu mabaygal aygud gasamoedhin a thana senabi kubil mura si madhin. Wara bathaynga nanga nuy kedha mulaydhin, ‘Ngoey ngaru kuniya ngaw kuyku mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kasa kay kedha Rebekana babath a apu palay kedha, ‘Ngitha gar moegina thuma oesipa, ngoewakaz na ngaru koew ngoeymuniya lak urapun wikipa lawnga ten goeygipa. A na bangal senawki kay.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Abraman zagethaw mabayg kedha kuniya mulaydhin thanamulpa, ‘Ngitha ngoey woeydhayg, ina Awgadhan ngaw mab kuyku nidhaypa. Ngitha gar ngoena pawayaw ngaw kuyku mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","58","Thana nubepa kedha mulemidhin, ‘Ngalpa mamu ngoewakaz thuraypa, na kay midh mulepa.’ Wa, thana nan thuran a yapupoeyban, ‘Ngi kay thanamuniya oesipa?’ Na kedha mulaydhin, ‘Wa ngay kay oesipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kalanu thana nan wayadhin kalmel nanu kulay buway zagethaw mabayg, na koey apu. ");
INSERT INTO mwp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Thana nanu doegam mabaygan poeybadhin woenab Rebekalpa kedha, ‘Ngi ngoeymun mina tukuyap. Ngi bangal nanga apu aymidhe mura koeygarsar mabaygoepa a nginu kaziw kazin bangal uma mathampu thanamun thabukiril a ngurumaw mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kalanu Rebeka a nanu ngoewakaz zagethaw mabaygal a nanu kulay buway zagethaw mabayg buthpathemin a kameloenu gimal thanuraydhin. Kalanu thana mura kalmel Abraman zagethaw mabaygiya oesipa. Thana koeyma goeygilnga uzaraydhin kurusipa amadhan thamadhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaka senabi thonara woelmay mabaygoegi maya. Nuy ngapa woelmay ngukiw maypa amadhan. May nel Nungu May Danal Pathay Kuykulnga Nuy Ngaru Igililnga. Nuy senawbi thonara Kananaw zey doegamoenu meparu. ");
INSERT INTO mwp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Nuy senawbi kutapa kulay miyaydhin gurguy mabapa puygi lagiya. Kedha nanga nuy nagiz, thanamun kamelal imiz. ");
INSERT INTO mwp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nadh nanga Rebeka Isakan iman nanga na adhapa pagan kameloengu. ");
INSERT INTO mwp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Kalanu na yapupoeybiz Abraman zagethaw mabaygoepa kedha, ‘Senaw nga boey kuniya ulaypa ngalpalpa?’ Nuy kedha, ‘Senaw ngaw kuykulnga.’ Kalanu nadh nanu paru dhoemawakun wardhan. ");
INSERT INTO mwp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Wa, kalanu Abraman zagethaw mabaygan balbayginga mura yadu thuray ayman, zapul midh paru mura nanga aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kalanu palay garwoeydhamoemoedhin, nuydh Isaka nan Rebekana yoelpadhin potowakupa nungu apu ngalaga nanga niparu a nuydh nan mina koeyma maman mayparuy, a mina koeyma danal poethaypu a siyargitha kabuthoepu matha kedha nungu apu midh nanga nuydh danal poethaypu. Kalanu nungu ngoenakap lak balbaygoesidhin nungu apuwaw awmoengu, mura balbayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrama nuydh wara yoepkaz niyaypa yoelpadhin nanu nel Kethura. ");
INSERT INTO mwp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nadh Kethura kazil mamayidhin nubepa itha kedha, Ziram, Zoksan, Medin, Midiyan, Isbak, a Suwa. ");
INSERT INTO mwp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Zoksan nuy Seba a Dedan palamun thathi, a Dedan nungungu pawpa thoeri mura buwayl, itha kedha, Asurum, Lethusin, a Lewmin. ");
INSERT INTO mwp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mediyanan kazil itha kedha Epa, Eper, Anok, Abida, a Elda, mura itha nanga Kethurana kaziw kazil. ");
INSERT INTO mwp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrama mura nungu zapul wanaydhin Isakalpa. ");
INSERT INTO mwp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kasa kedha nuy nanga igililnga meparu, nuydh nungu ukasar zagethaw yoepkaz ipiw kazipa sibwanay aymoedhin thanamun igililmaypa kuyk aymoeypa. Kalanu nuydh sethabi nungu garkaz kazil sager doegampa wayamoeydhin Isakalngu nungu kupa moeramaw gasamayzi kazingu. ");
INSERT INTO mwp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abrama nuydh muwasidhin, nungu wathoel matha mura urapun andred a sebenti payb. ");
INSERT INTO mwp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nungu ukasar garkaz kazi Isaka a Ismeyl palay nuyn muynu wanaydhin sakay gudanu, Makpelaw kulaw sakay. Na senabi sakay sager doegamoenu Mamrenu, a nan senabi boeradhar Epronan za. Nuy Epron Zowan kazi nuy Ithalayg. ");
INSERT INTO mwp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrama nuydh kaypaypa kulay barpudoedhin Epronalngu senabi boeradhar, palay kalmel Abrama a Seray sepalbi sakay gudoenu woenamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrama nanga muwasidhin, Awgadhan kalanu woenab poeybadhin nungu kazipa Isakalpa. Nuy nanga senabi thonara, ngukiw maynu pasinu meparu. Senabi mayngu nel, ‘Purkan Yawayay Mabaygaw Ngukiw May nuy Ngaru Igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ngalpa ngulaygal kedha, nuy Ismeyl, Eygana kazi nungu thathi lak Abrama, na Eyga Serana zagethaw mabayg. Nungu buway kuyk kedha, ");
INSERT INTO mwp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Itha nungu kaziw nelay nanga thanamun maykuykuya balbayginga; Nebayoth, Kedar, Adbil, Mibsam, Misma, Duma, Masa, Adhadh, Tem, Zethur, Napis, a Kedema, ");
INSERT INTO mwp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Thana 12 buway kuykul aymoeydhin a thanamun nelay mamayidhin thanamun mudhaw lagoepa a kawa mudhaw lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismeyl nungu nanga wathoel 137 aymoeydhin nuydh muwasidhin. ");
INSERT INTO mwp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A nungu kazil memayipu lagaw nel Abila a Sur matha dhadhal sager doegamoenu Asiriyapa mabaw doegamoenu thana thanamun kusaygal koey sigal memayipu Abraman wara kaziw kazingu. ");
INSERT INTO mwp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ina Abraman kaziw ya, Isakan. ");
INSERT INTO mwp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka nungu nanga poti wathoel gasamoeydhin nuydh nan Rebekana nubiya niyaypa yoelpadhin. Na Rebeka Bethwelan kazi Leyboenan babath. Bethwel nuy Araminalayg Mesopoetaymiyaw doegamoenu. ");
INSERT INTO mwp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka Rebeka palay matha kazigig. Nuy Isaka Awgadhoepa thoeythupoegaydhin a Awgadhan nungu thoeythupoegay karngemidhin, Rebekana kalanu maythalayg aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebeka nabiya maythanu muynu koetha kazi. Nadh kay palay wagel kazi moemoempa palay muynu nabiya pathowkampu, na kedha mulaydhin, ‘Ina mingu ngayapa kedha ngoedhal za aymoedhin?’ Kalanu nadh Awgadhoepa yoewdhaydhin, a Awgadhan karngemidhin nanu woelmay. ");
INSERT INTO mwp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Awgadh kedha mulaydhin, ‘Sepal ngibiya muynu ukasar koey lag. Palay bangal nanga kazi mamoemoene wara bangal koey puridhoeralnga a wara bangal mamu puridhoeralnga lawnga. Kuykuyg bangal apasipu kuthaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","25","Nadh nanga palay kazi mamoemoedhin, nuy kuykuyg kazi waza kulka gamul goengawlnga a koey gamu magadhalnga; kedha zoenguz nungu nel Isaw. ");
INSERT INTO mwp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kuthayg nanga kazi madhin, nuy mina koey ridh nungu tukuypaw pukukoenu nidhay. Kedha zoenguz nuy nel tharadhin Yakubu. Senawbi thonara Isaka nuy siksti wathoelayg. ");
INSERT INTO mwp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Palay koesimampu ngapa, nuy Isaw mura ngulayg asidhin bupaw aypa lumayle. Nuydh kedha ubilmaypa koeyma ubinmeparu. A Yakubu nanga nuy kasa lagal boedhiya zagethan meparu. ");
INSERT INTO mwp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka nuydh Isawan mina koeyma maman mayparu. Minguz kedha, Isaw nuydh nanga ay gasaman Isaka ngaru purthan. A Rebeka kay maman mayparu Yakubu. ");
INSERT INTO mwp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wara thonara Yakubu nanga aydu muythu miyay nanga Isaw sinubi thonara mangiz aypu lumayngu. Nungu maytha mina ayginga. ");
INSERT INTO mwp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nuy kedha Yakubulpa, ‘Ngaw maytha ayginga, ngayapa sizi ngapa moegina nginu kulka gamul ayngu pathar.’ Nuyn kedha zoenguz kedha thoeraypa, Edom. Thanamudh kedha, kulka gamulnga. ");
INSERT INTO mwp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakubu kuniya mulaydhin kedha, ‘Ngath kay ngibepa poeybaypa, ngidh kay nanga ngayapa nginu kupay maypa ngoedhe kedha nge ngay bangal nginu kuykuyg.’ ");
INSERT INTO mwp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isaw kedha mulaydhin, ‘Wa miyay nanga, ngaw um amadhan, ngaw maytha mina ayginga. Na kay ngaw senabi mina noemayn ngayapa za miyay ayimpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakubu kedha, ‘Wa, kulay ngayapa mina ya muli, ridha ya kedha, ngidh bangal ngayapa kupay manine.’ Wa Isaw asidhin, a nuydh ya woedhan aymoedhin, nungu kupay Yakubulpa poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kalanu Yakubu aydu poeybadhin Isawan, kulka gamul aydu a kunaw susun poeybadhin. Aygudaw kalanu nuy uzaraydhin. Sena nuydh Isaw kedha yababiya nungu kupay sagul paladhin Yakubulpa. ");
INSERT INTO mwp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Wara thonara nanga lak aygi asidhin kulay kay paypa Abraman thonar midh nanga. Isaka nuy uzaraydhin Gerapa Abimelekoelpa, Pilistaw mopakuykulnga. ");
INSERT INTO mwp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","(Thanamun kulba pawa kedha, aygi thonar na mangiz thana Aykupithupa ay luman.) Kasa kay kedha aygi wath wagel, Awgadh kulay mulaydhin Isakalpa kedha, ‘Aykupithupa bangal maygi, koew bangal matha meparu nubi lagoenu, ngath ngibepa in seysithamar yawarpa. ");
INSERT INTO mwp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","‘Koew bangal meparu, a ngay bangal ngibiya kalmel a ngaw woenab. Ina kay ngath nubi lag mura ngibepa maypa a matha kedha nginu kaziw kazipa. Ngath bal ngaw yawoedhayzinga nginu thathipa Abramalpa ngoenanu mayparu. ");
INSERT INTO mwp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngath bangal ngibepa poeybedhe mina koeygarsar kazil a thanamun bangal kaziw kazil ngoedhe bangal kedha daparaw thithuyil midh nanga, a ina bangal ngath nubi lag thanamulpa poeybane. Mura bangal lagal ngayapa yoewdhemipu woenaboepa thanamulpa poeybaypa nginu kaziw kazil midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","‘Ngath bangal woenab ngibepa poeybane. Minguz kedha Abrama ngaw yangukudul karngemipu a matha kedha ngaw sabiw yawoeydhayzinga pathidhayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaka matha si Geranu meparu. ");
INSERT INTO mwp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nubepa nanga mabaygal nungu ipiw yapupoeybemipu nanga nuy kedha umepu, ‘Na ngaw babath.’ Nuy balbayginga mulayginga kedha, ‘Sena na ngaw ipi.’ Minguz kedha nungu aka, mabaygoengu nungungu umamathamoeyle, Rebekana may na mina thoeyaygi yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka nuy si meparu moegina kuykuthalnga. Wara thonara Abimoelek nuy mulupa nagaydhin nungu lagoengu a palay imamoedhin ubi sagulan. ");
INSERT INTO mwp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimoelek wayadhin Isakalpa kedha, ‘A! Sena na ngaru nginu ipi. Minguz ngi ngayapa kedha umepu, sena na nginu babath?’ Nuy kedha kuniya mulaydhin, ‘Ngaw wakay thoemamay kedha, ngay nay nanga balbayginga mulepa kedha, na ngaw ipi, ngoena bangal umamathamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimoelek kedha, ‘Sena ngidh za miyay aympa ngoeymulpa? Sena zagethoeginga ngaw mabaygoepa nginu ipiya uthuypa. Minguz kedha, nginu karum kuyk.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kalanu Abimoelek kedha mulaydhin mura mabaygiya paruya, ‘Ngadh bangal nanga za gegeyadh aymoene Isakalpa a matha kedha nungu ipiya, senawbi mabayg bangal umapa mathamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Wa, Isaka nuydh ay nagun uthudhin senawbi boeradharoenu, a senabi wathoenu nanga ayboewdhaw thonara na gasamoedhin nuydh ayde adhapa mamayidhin koeyma nungu uthuyzimaya, kedha zoenguz Awgadhaw woenab waza nubiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nuy matha kedha meparu kurusipa nuy koey aydeg zapulayg aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nuy nanga mura zapulayg aymaydhin nanga, kawalayg, a mamuylayg, a zagethaw maoebaygoelayg nanga, thana Pilistalgal uwan memayidhin nubiya. ");
INSERT INTO mwp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Thana kalanu ngukiw mayl mura gud mathamoeydhin; mura setha kulba poemoeyzimayl, nungu thathiw Abraman zagethaw mabaygaw, Abrama nanga matha danalayg meparu. ");
INSERT INTO mwp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimoelek kalanu kedha mulaydhin, ‘Isaka, ngidh bangal ina ngoeymun lag wanane, ngi mina koey puridharalnga; ngoey mamu mina puridharalmayl lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Wa, nuy Isaka kalanu adhapa miyaydhin. Nuy nubepa niyaylag aymoedhin Geraraw padaw dhadha sakara. Nuy si meparu lak moegina kuykuthalnga. ");
INSERT INTO mwp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nuydh lak ngukiw mayl pamamoeydhin, Abraman thonaraw poemoeyzimayl, Pilistalgaw gud mathamayzimayl Abraman umaw kaliya. Isaka thana mayl lak kedha nelay thurimoeydhin nungu thathin sethabi mayl mi nelay tharaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isakan zagethaw mabaygan may pamadhin padaw pasinu nanga imadhin. ");
INSERT INTO mwp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kasa kedha thana Geraraw mamuy danal poethay mabaygal ya pathukamoeydhin Isakan mamuy danal poethay mabaygiya kedha, ‘Ina ngoeymun nguki.’ Wa, Isaka nan kedha tharadhin, ‘Koey yaday nguki.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isakan mabaygan mamu a wara ngukiw may pamadhin. Thana Geralgal lak ya mulemidhin. Nuydh nan kedha tharadhin, ‘Koey Kaliya Thoerayl Nguki.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nuy sizi adhapa miyaydhin a wara may pamadhin. Thana wara yagigal. Wa, nuydh nan kedha tharadhin, ‘Ubipa Ngukiw May.’ Nuy kedha, ‘Mina kedha thonara kay Awgadhan ubipa mangu koew maypa nabi boeradharanu, a ngalpa bangal balbayginga kay nithamoene itha.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kalanu Isaka nungu kawamudh mamayidhin Biyasibapa. ");
INSERT INTO mwp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Senabi kubilu Awgadh nubepa seysithamaydhin a kedha mulaydhin, ‘Ngay nginu thathiw Abraman Awgadh. Akan maygi, ngay ngibiya kalmel, a ngath poeyban woenab ngibepa a nginu kaziw kazil bangal mina koey goersar; minguz kedha, ngaw yawoedhan aymayzinga nginu thathipa, ngaw zagethaw mabayg Abrama.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka nuydh olta moeydhadhin senabi lagoenu Awgadhoepa thoeythupoegaypa a thawmaypa. Nuydh lag moeydhadhin a nungu zagethaw mabaygan wara kayn may pamadhin. ");
INSERT INTO mwp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kalanu Abimoelek Gerangu miyaydhin Isakalpa, nubiya kalmel nungu ukasar getha doegam mabayg wara Ayuzath nungu yangu mabayg a wara Pikol nungu koewbu kuyk. ");
INSERT INTO mwp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nuy Isaka kedha yapupoeybiz, ‘Ngitha mingu ngapa ngayapa imaypa. Ngitha waza ngayapa wati igalgal a ngitha ngoena ngur woeydhadhin ngithamun lagoengu?’ ");
INSERT INTO mwp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Thana kedha, ‘Ngoey ngulaygal Awgadh ngibiya kalmel, a ngoeymun wakaythoemamay kedha, ngalpa kay urapu ubinu yawadhay aympa ngalpaniya dhadhal. Ngoeymun ubi kedha, ngi gar kay muli ngoeymulpa mura ya muli. ");
INSERT INTO mwp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ngibepa ngoeymulpa gegeyadh zapa aymoeypa lawnga. Matha kedha ngoey midh nanga gegeyadh kuniya za aymoeyginga ngibepa. Ngoey ngibepa kapu pawan memayirngu, wara gegeyadhoeginga, ngi midh thonara nanga adhapa miyaydhin ngoeymulngu. Ina kasa koey kakal kedha, Awgadh ngibiya kalmel a nungu woenab.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaka nuydh thanamulpa koey ay aymoedhin, a thana mura matha ngoedhagidh gasamoedhin senabi ay a nguki. ");
INSERT INTO mwp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wara bathaynga nanga thana mura yaynanob yawadhan aymoeydhin, a Isaka thanamuniya yawa thuray thana nanga kuniya mab kuykayman. Kalanu thana kapu igalgal. ");
INSERT INTO mwp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Senawbi goeyginu Isakan zagethaw mabayg ngapa nubepa muliz kedha, ‘Ngalpa na may pamangu a nguki balbayginga mangu.’ ");
INSERT INTO mwp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kalanu nuydh nan kedha tharadhin, Biyasiba. (Muynu aykap kedha, Mina Yawoedhayzinga.) Sena nadh kedha kuniya, senabi koey goegathan nanu nel gasamoedhin kedha Biyasiba. ");
INSERT INTO mwp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isakan ukasar kazi Isaw a Yakubu palay koesimadhin. Isaw nanga poti wathoelayg nuydh ukasar yoepkaz niyaypa yoelpamoedhin; Ithalayg palay. Wara ipiw nel Zudoeth, nanu thathi nel Beri, a wara nel Basemath, nanu thathi nel Elon. ");
INSERT INTO mwp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Palay palbi ipi nanga palay kasa mura igililnga gegeyadh mayparu Isaka a Rebekalpa. Palay apu thathi dhiwagig. ");
INSERT INTO mwp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka nuy nanga koey thathi aymaydhin nanga nuydh zapul moegina yawaymoeypu, nuydh nungu garkaz kazi thuradhin Isawan a kedha mulaydhin, ‘Ngaw kazi!’ Nuy kedha Isaw, ‘Midh, ngay in.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kalanu nuy Isaka kedha mulaydhin, ‘Ngidh ngoena iman a? Ngay koey thathi, ngaw amadhan um. ");
INSERT INTO mwp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ngidh nginu gagay a thayak mamamar, uzar ngayapa kay tetel uruy ay kay mathamar. ");
INSERT INTO mwp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ngayapa kay mina kapu mithal ay aymoene a kalanu kay ngayapa manine. Aygudaw kalanu kay ngath ngibepa ngaw moeygoepa woenab poeybaypa, wagel bangal ngaw kuth.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaka nanga yadu umay Isawalpa, nadh Rebeka karngimir. Wa nuy gar nanga Isaw aypu lumaypa mizin nanga ");
INSERT INTO mwp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","na Yakubulpa kedha mulaydhin, ‘Ngath nginu thathiw yaday karngemidha, nuy midh nanga umedha Isawalpa kedha, ");
INSERT INTO mwp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Ngayapa tetel uruy ngapa a giya kay palane. Aygudaw kaliya kay ngath ngibepa woenab maypa Awgadhaw parunu, wagel kay ngaw kuth.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Na kedha Rebeka, ‘Ngoezu kazi ngayapa karngemir ngay midh kay na mulepa ");
INSERT INTO mwp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kedha uzar setha ngalpan nanil, ngoebalpa seyzi ngapa ukasar kayn koey ngabi mamamar; ngath kay giya palimpa dhuray mithal ayde nginu thathipa, nubepa mina ayde. ");
INSERT INTO mwp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ngidh kay kalanu nubepa muypa agepa. Ayngu kalanu nuydh ngibepa woenab poeybaypa, wagel nungu kuth.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nuy kedha Yakubu nungu apupa, ‘Ngi ngulayg kedha Isaw koey gamu magadhalnga a ngay gamu magadhoegig. ");
INSERT INTO mwp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Wara kedha, ngaw thathin nanga kay nanga gamu thoeraypa nuy kay ngulayg oesipa a sena kay kakal ngaw karum poelay nubepa, a ngath kay mura wati za ngayapa thuraypa, woenab lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nungu apu kedha, ‘Mi wati pawa ngibepa, kay ngapa ngayapa, nguzu kazi kasa aymar ngay ngibepa midh nanga mulema, uzar sepal ngapa nani mamamar.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Wa, nuy gar uzariz gasamoeman a nabepa mamaman. Nadh kalanu giya paliman kedha Isakalpa mi giya palay koey ubilnga. ");
INSERT INTO mwp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Isawan kapu rugal nabiya mer lagoenu muynu. Kalanu nadh sethabi rugal Yakubulpa mamayin ubamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nadh nubiya tetel uruy goengawl nungu gethiya a muduliya wara mura gamu magadhoegimiya. ");
INSERT INTO mwp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kalanu nadh nubepa madhul a kunaw susul kusuman. ");
INSERT INTO mwp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kalanu Yakubu uzariz nungu thathipa, a kedha mulaydhin, ‘Bab!’ Nuy Isaka kuniya, ‘Miyay, ngi nga ngipelngu?’ ");
INSERT INTO mwp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakubu kedha, ‘In ngay nginu kuykuyg garkaz kazi Isaw; ngath nginu ubilnga aymoenu. Igi thanur aygudoepa. Ayde itha ngath ngapa kusumoenu. Nuydh kay ngidh ngayapa woenab poeybaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka nuy kedha, ‘Ngidh midh paru mina sobaginga gasaman ngaw kazi?’ Yakubu kedha, ‘Awgadhan ngoena ibupuydhanu sobaginga gasamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaka kedha Yakubulpa, ‘Aya ngapa gar amadhan thami nuy kay ngath ngin gamu thuraypa. Nuy ngi mina Isaw a?’ ");
INSERT INTO mwp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakubu amadhan thamiz nungu thathipa, nuy nungu thathi kedha, ‘Nginu yangu wakay Yakubun yangu wakay, kasa kay kedha nginu geth Isawan geth.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaka Yakubun ngurpayginga, minguz kedha nungu geth gamu moegadhalnga, kedha Isawan midh nanga. Nuydh kay wagel kay woenab Yakubulpa maypa. ");
INSERT INTO mwp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Nuy lak mamu yapupoeybaydhin, ‘Ngi mina ngaw kuykuyg garkaz kazi a?’ Nuy kuniya, ‘Wa, ngay mina nginu kuykuyg garkaz kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaka kedha, ‘Ngayapa ukamay ay madhu ngapa, ngath kay na aygud muwasipa ngath kay ngibepa maypa woenab.’ Yakubu nubepa ayde kusuman kalmel umal nguki. ");
INSERT INTO mwp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kalanu nungu thathi nubepa kedha mulaydhin, ‘Ngapa amadhan thami a ngoena gud thapamar ngaw kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakubu nanga nubepa amadhan thamiz nanga guda thapamoeypa, Isaw nungu rugaw ganu madhin, kalanu Isaka woenab Yakubulpa poeybaydhin. Nuy Isaka kedha yangukudu ya madhin nungu kazipa, ‘Ina nabi kapu ganu ngoedhe bupaw ganu Awgadhaw woenab ngalaga nanga. ");
INSERT INTO mwp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Awgadhan kay dhibag woeyaypa daparngu, senabi boeradhar nuy bangal kay aydenga. Nginu kun a umal nguki ngaru bangal koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mura lagal a mabaygal apasimoeypu ngibepa. Ngi bangal thanamuniya gimal a nginu buway matha kedha nginu apuwaw kaziw kazil bangal ngibepa apasimoeypu, a thana senaw ngaya nanga ngin wati bag thoeyaypa, senawbi wati za bangal thanamuniya woenaripu. A setha ngaya nanga ngibepa kapu yangukudu ya umamoeypa a kapu woenab ngibepa, wa, matha kedha woenab thanamuniya kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka nuydh woenab Yakubulpa poeyban. Mun nangasin nuy Yakubu sizi uzariz, Isaw gar mangaydhin aypu lumayzimayngu. ");
INSERT INTO mwp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nuydh Isaw lak kedha mina kapu mithal madhul aymoeyn, kalanu nungu thathipa mamayin. Nuy kedha mulaydhin, ‘Bab! Igi thanur aygudoepa itha ngath ngapa kusuman na kay ngidh kalanu ngayapa woenab poeybaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka nuy kedha yapupoeybiz, ‘Ngi nga?’ Nuy kuniya mulaydhin kedha, ‘In ngay nginu kuykuyg garkaz kazi Isaw.’ Nuy Isaka madhu pamiz, mamu mina koeyma gar lupan. ");
INSERT INTO mwp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nuy kedha mulaydhin, ‘In kulay nga mangema, a ngi nga nge, ngayapa kulay ngadh ayde kusumoenu? Ngay purathima, ngath ngaw moeygoepa woenab nubepa manu, sena nungu za pamoeygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nuydh nanga Isaw karngemin, nungu mamu kasa may mina koey gimiya umay kedha, ‘Ngayapa gar mar nginungu woenab, Bab!’ ");
INSERT INTO mwp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nuy thathi kedha, ‘Nginu tukuyap in kulay mangema ngoena ngoelkanu. Nuydh gasamoenu nginu woenab.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isaw kedha, ‘Ina nungu ngayapa ukasar thonaralnga aymiz kedha sagul poelay kedha zoenguz nungu nel Yakubu, nuydh ngaw mina za madhin, ngaw kuykuy kaziw kupay, ina mamu a woenab! Na kay ngidh moegina kuniya thoeyayginga ngayapa?’ ");
INSERT INTO mwp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka kedha, ‘Ngath nuyn muwasinu, kuykulnga aymoenu ngibiya. A ngath mura nungu tukuypal nungu zagethaw mabaygal aymoenu, a ngath nubepa kun a umal nguki mamamoenu. Ngay kedha thonara zagig ngibepa ngaw kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isaw matha umay nungu thathipa kedha, ‘Ngibiya sey kedha urapun mayginga, ngayapa gar lak kedha woenab mar ngaw Bab.’ Kalanu gar nuydh Isaw koey may puydhan. ");
INSERT INTO mwp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaka nubepa kedha mulaydhin, ‘Ngibepa wara dhibagoepa nginu boeradharanu pudhaypa lawnga, a ngibepa boeradhaw aypa gasamoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ngi a nginu buway bangal gegeyadh niparuy, a nginu kuyay thurik ngaru nginu gethaw rug. A ngi bangal nginu kuythaygaw zagethaw mabayg aymoene. Kasa kay kedha ngitha bangal a kuniya nanga, ngitha bangal guythuyane nginu tukuypaw danal poethay.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isaw nuy yagiyasidhin Yakubulpa, kedha zoenguz kedha Isaka woenab poeybadhin Yakubulpa. Isaw nungu wakay thoemamay kedha, ngaw thathiw um amadhan, ngath bangal Yakubun uma mathamoene. ");
INSERT INTO mwp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Rebeka nadh nanga gasamoedhin Isawan wakay thoemamay midh nanga, Yakubulpa uma mathamoeypa nadh Yakubu yadu thuradhin. Na kedha nubepa, ‘Ngidh kay ina aymar nguzu yangukudu, nginu tukuypoepa kedha, nuydh ngin uma mathamoene bangal. Uzar kedha thonara nginu wadhumalpa Leyboenalpa, nuy sey Arananu. ");
INSERT INTO mwp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Sew bangal meparu moegina kuykuthalnga, nginu wadhumiya, mamu bangal nginu tukuypaw ngoenakap moegina gabu asine, a nginungu bangal yakanuridhe kedha, ngidh nubepa miza aymoedhin. Kalanu bangal ngath ngibepa mabayg wayane, ngapa kuniya maypa. Mingu ngath ngoezu kazi kalmel guythuyamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A war na mulaydhin Isakalpa, ‘Nguzu gamu kawbasin Isawan war lagaw ipingu. Yakubu bangal nanga lak Ithaythaw ngoewakaziya garwoeydhamidhe, ngay kasa um miyay.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaka kalanu Yakubun thuradhin. Nuy nanga si mangaydhin Isaka ayawal madhin nuyn. Kalanu kedha mulaydhin, ‘Maygi ngidh ipi gasaman koezi Kananaw yoepkazingu. ");
INSERT INTO mwp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Uzar nginu amana baban lagoepa, Bethwelan lagoepa, Mesopoetaymiyanu. Soeyzi bangal ngidh ipi yoelpane nginu wadhumaw Leyboenan yoepkaz kazingu. ");
INSERT INTO mwp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Awgadh Adhapudhay Kuykulnga poeybane nungu woenab nginu niyaypa yoelpay thonara a matha ngibepa koeyma kazil bangal. Minguz kedha ngi bangal koeygarsar lagoepa thathi. ");
INSERT INTO mwp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","A nungu woenab bangal nginu kaziw kaziya, Abramalpa midh nanga nuydh woenab poeybadhin, a ngidh bangal mura ina aykuyk manine in nabi boeradhoeranu a in ngalaga mepa, a Awgadhan midh nanga Abramalpa poeybadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaka Yakubun wayadhin Mesopoetaymiyapa, thanamun Araman buwaypa, Leyboenalpa Bethwelan garkaz kazi. Nuy Leyboen waza palamun Yakubuwom Isawom amana babath. Nuy kedha mulaydhin, ‘Ngidh nginu wadhumaw kaziya niyaypa yoelapidhe.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","8","Isaka nanga Yakubulpa woenab poeybadhin nanga nuydh nuyn lawnga madhin Kananaw yoepkazingu, kalanu nuyn wayadhin Mesopoetaymiyalpa ipiya lumaypa. Isaw nuydh nanga thanamun apthathkaziw buwaylthoeyay na imadhin, nubepa mura kakal aymoeydhin kedha, Yakubu nuy kurusipagaydhin apu thathiw ubilnga. Nuy Isaw ngulayg asidhin kedha, nungu thathiw ubigig Kananaw yoepkazingu. ");
INSERT INTO mwp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nuy kalanu Ismeylapa uzaraydhin, Abraman kazi. Kalanu nuydh Ismeylan yoepkaz kaziya niyaypa yoelpaydhin, nanu nel Mayalath, Nebayothoen tukuyap. ");
INSERT INTO mwp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakubu pathiz Biyasibangu uzaraydhin Aranoepa kuniya. ");
INSERT INTO mwp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Goeyga na pudhaydhin nanga nuy balbayginga boeradharoenu pudhaydhin a nungu uthuy si, nungu guzi kula. ");
INSERT INTO mwp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Senawbi kubilu nuydh pikin thayar kedha, nuydh imadhin na koeyza dhayab sir apaz gimanoeka kurusipa sipa daparpa sithaki thamemir, angelal mulupa kadaypa. ");
INSERT INTO mwp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nubiya pasinu sir Kuykulnga, nuy kedha mulaydhin, ‘Ngay nginu thathiw Abraman Awgadh, a Isakan Awgadh. Ngath bangal poeybane ngibepa a nginu kaziw kazipa in nubi lag ngi ngalaga uthuy yuwipa. ");
INSERT INTO mwp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Thana bangal gethatidaygi koeygarsar matha kedha buthul mi koeygarsar nanga. Thana bangal koezi adhapa kupar palepu, mura wad wadgoepa nubi gugu ubidh thoeyayzimaynu. Kalanu mabaygan mura woenab lumaypa ngayapa, ngath mi woenab nanga ngithamulpa poeyban. ");
INSERT INTO mwp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","‘Ina bangal ngoenanu mayparu ngay bangal ngibiya kalmel danal pathaypa, ngi bangal kasa ngalagiya, ngath bangal ngin ngaru kuniya gasampu nubi lagoepa. Ngayapa ngibepa kasa woenaypa lawnga, kurusipa bangal ngath mura kuyku nidhane ngaw yawoeydhayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakubu danpaliz. Nuy kedha, ‘Kuykulnga kay! Ngay koerawayg kedha nuy kay nubi loegoenu.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nungu aka mina koeyza. Nuy kedha, ‘In mi lag? In sikedh Awgadhaw lag pasagud daparpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","War bathaynga Yakubu mina inuriya danpaliz. Nuydh senabi kula manin, nuy mi kulanu guzi wazir nanga, nuydh nan kakal wanan wakay thoeyaypa a ngoenanumaypa. Kalanu nuydh kapu mina idi pay yoewdhadhin senabi kulaya gimiya, adhapa thamaypa Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nuydh nan senabi lag kedha tharan Bethel. Senabi thonara kulay goegath meparu nel Luz. ");
INSERT INTO mwp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kalanu Yakubu Awgadhoepa mulaydhin kedha, ‘Ngi bangal nanga ngaybiya kalmel danal poethaypa ngaw mabanu, a ayde, doemawakul ngayapa nanga mamayine a ");
INSERT INTO mwp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ngay bangal nanga balbayginga ngaw thathipa kuniya tidedhe, wa ngi bangal ngaw Awgadh, a ngath bangal matha ngin thawmayparu koezi kayboengu. ");
INSERT INTO mwp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","‘In nubi kula ngoenanu maypa ngath nanga wanadhin bangal nginu thawmay lag a ngath bangal ngibepa balbayginga moegina mayparu mura zangu, ngidh bangal nanga ngayapa kusumpu. Mura ngaw ten zapungu nanga, ngath balbayginga mayparu nginu urapun za ngibepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakubu nuy nungu mabanu matha woelmay, a nuy woelmay sager doegampa lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Gumi nuy nubepa ngukiw may mangaydhin a mamuyl sike pasiya apiya poelemar wadhwadhgam. Setha thana mamuyl koezi nabi mayngu nguki poeybayngu, ina kay kula gudpuday lagoenu nabiya. ");
INSERT INTO mwp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Thana mamuyl garwoeydhamiz sipa. Thana danal poethay mabaygan senabi koey kula adhapa manin a ngukin poeybiz thana mamuyl. Kalanu thana lak nan kula balbaman nanu woenay lagoenu. ");
INSERT INTO mwp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakubu nuy yapupoeybiz thanamulpa mamuy danal poethay mabaygoepa kedha, ‘Ngitha ngalagaw lagalgal.’ Thana kedha mulaydhin kuniya, ‘Ngoey Aranalgal.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakubu lak yapupoeybiz kedha, ‘Ngitha Nayon kazi Leyboenoelngu ngulaygal?’ Thana kedha, ‘Wa ngoey ngulaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kalanu Yakubu yapupoeybiz kedha, ‘Nuy Leyboen matha ngoedhagidh a?’ Thana kedha, ‘Wa, nuy balbayginga. Kedha nagi, sena boey ulaypa nungu kazi Reysoel, nungu mamuylayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakubu kedha, ‘Ina goeyga mina koeyza, a thonar kay matha lawnga mamuypa muythoeyaypa. Ngitha thana mingu kasa nay ngukin poeybiz, a lak kuniya nay mamayin thanamun aygudaw lagoepa?’ ");
INSERT INTO mwp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Thana nubepa kedha kuniya mulaydhin, ‘Ngoeymulpa kedha aymoeypa lawnga. Kurusipa kay manin mura mamuyl mangemipa a kula kay adhapa thoemaypa kay, mamuypa ngukiw poeybaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nuy nanga Yakubu yadu umay thanamulpa nanga Reysoel senabi thonara mangiz mamuylayg, thanamuniya si. ");
INSERT INTO mwp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakubu nanga Reysoelana iman nungu wadhuman mamuylayg, nuy uzariz a kula mayngu adhapa thaman a ngukin poeybaydhin nungu wadhuwaman mamuyl. ");
INSERT INTO mwp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kalanu nuydh nan gudthapaman a mamu mayl ikan gasaman. ");
INSERT INTO mwp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Nuy kedha nabepa, ‘Ngay nginu thathiw buway mabayg Rebekana kazi.’ Na kalanu zilamiz nanu thathipa mulaypa. ");
INSERT INTO mwp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nuydh nanga mi thonara karngemidhin nungu wadhumaw Yakubun ya nanga nuy Leyboen mamu gar kasa woeynaydhin Yakubuniya a mamu gud thapaman a kalanu nuydh Yakubun lagoepa madhin. Kalanu Yakubu Leyboenan mura yadu thuran zapul midh paru aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","15","Leyboen kedha mulaydhin, ‘Wa, se mina, ngi ngaw gamu kulkaw mabayg.’ Wa, Yakubu matha puzir Leyboeniya urapun moelpal na yabaythayadhin nanga. Leyboen Yakubulpa kedha, ‘Ngibepa kasa zagethoepa lawnga, kasa kulka a buway doegumuya, nginu mi modhabipa ubi?’ ");
INSERT INTO mwp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leyboenan ukasar yoepkaz kazi, kuykuyg Leya a kuthayg Reysoel. ");
INSERT INTO mwp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya na mina kapu purkalnga, kasa kay kedha Reysoelb* nanga adhapudhay ruwaypa kapu yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakubu nungu Reysoelapa ubi. Nuy kedha, ‘Ngay bangal ngibepa seben wathoepa zagethan meparu ngidh kay nanga ngayapa pawoeyaypa Reysoelaniya garwoeydhamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leyboen kedha, ‘Ngath bangal sike nan ngibepa manine, ngi ngayapa matha ngoedhagidh wara mabay midh nanga, koew ngaybiya yawpugi.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wa, Yakubu seben wathoepa zagethan miyaydhin nubepa Reysoelapa gasamoeypa. Sizi pawpa zageth nungu moegina kuykuthalnga kasa kay kedha sethabi koeygarsar goeygil thana nubepa ngoedhe kedha goeygil moenarimayl wanaydhin. Minguz kedha, nungu ubi waza nabepa. ");
INSERT INTO mwp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nuy kedha Yakubu Leyboenalpa, ‘Ina thonar gasaman niyaypa yoelpaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Wa, Kalanu Leyboen niyaypa yoelpay ay aymoedhin, mura igalgal a mabaygal thuraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kasa kedha senabi kubilu nanga Reysoel lawnga nge, nuydh mamu Leyana Yakubulpa madhin a Yakubun uthuy mamu ngedh Leyaniya ");
INSERT INTO mwp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Leyboen nungu zagethaw yoepkaz Zilpana poeybaydhin Leyalpa nanu geth mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kurusipa war boethaynga Yakubu ngulayg asin kedha, sena Leya nubiya uthuy yoewnan. Nuy kalanu uzariz Leyboenalpa muliz kedha, ‘Ngidh mingu ngayapa kedha ayman? Ngay ngibepa seben wathoelnga miyaydhin Reysoelapa gasamoeypa. Ngidh minguz ngayapa sagul poelay aympa?’ ");
INSERT INTO mwp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Leyboen nubepa kuniya muliz kedha, ‘Ina koew pawa kedha lawnga kuthayg kulay niyaypa yoelpaypa; mamu kuykuyg kulay a kuthayg wagel kay. ");
INSERT INTO mwp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mamu nubi wiki ugar yabay thoeyaypa nubi Leyana niyaypa yoelpay kalmel niyay, ngath kay Reysoelana poeybaypa ngibepa, ngidh kay kalanu nanga war seben wathoepa ngayapa zagethan mepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakubu senawbi ubilmaya Leyboenan asidhin, senawbi wiki nanga yabay thayadhin Leyboen nuydh poeybadhin Reysoelana Yakubulpa ipi. ");
INSERT INTO mwp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Leyboen nungu zagethaw yoepkaz Bila Reysoelapa nanu geth mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakubu nuy Reysoelaniya niyaypa yoelpaydhin, nungu nabepa ubi mina koeyza Leya mamu mina lawnga. Kalanu nuydh lak zagethan miyaydhin Leyboenalpa wara seben wathoepa. ");
INSERT INTO mwp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Awgadhan nanga imadhin kedha Leyana moegina ubilnga yawaypu Reysoelaniya, nuydh balbayg paladhin Leyalpa kazipa. Reysoel nanga na ngaru kazigig. ");
INSERT INTO mwp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Wa, na Leya maythalayg aymaydhin a garkaz kazi madhin. Na kedha mulaydhin, ‘Awgadhan nguzu ngoenakap kikir imadhin. Nuydh kalanu ngoena ubilnga imane, nguzu alayn.’ Nadh kedha zoenguz nanu kazi Rewbenan tharadhin. ");
INSERT INTO mwp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","*Na kalanu lak maythalayg aymaydhin a wara garkaz kazi madhin. Na kedha, ‘Awgadhan ngayapa in kazi manu. Minguz kedha, nuydh karngemidhin kedha, ngoena waza mamu ubilnga imayginga.’ Nadh kedha zoenguz kazi nel tharadhin Simiyon. ");
INSERT INTO mwp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Naka lak mamu maythalayg aymaydhin a kazi madhin, lak garkaz kazi. Na kedha, ‘Wa, ngath nguzu alaypa mamayin thoeri garkaz kazi. Nuy bangal mina kay ngayapa papudhedhe adhapa mayginga.’ Nadh kedha zoenguz nel tharadhin Lebi. ");
INSERT INTO mwp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Na kalanu lak maythalayg aymaydhin a kazi madhin garkaz. Na kedha, ‘Ngath kay senaw Awgadh thawmaypa.’ Nadh kedha zoenguz kazi nel tharadhin Zudha. Na kalanu kazigig gasamayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Reysoel wara kazi mayginga Yakubulpa, na Reysoel daniya bal pudhaydhin nanu tukuypangu Leyalngu, Yakubulpa kedha mulaydhin, ‘Ngayapa kazi mar nguzungu kasa umangu.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakubu mina kaliya yoewipa, kedha kay muliz nabepa, ‘Ngayapa Awgadhaw buthapa maypa lawnga, matha nuydh ngin kazingu gasamoeyle panidhaypa, sena ngaru Awgadh.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Na kedha Reysoel, ‘Wa, ngoezu zagethaw yoepkaz ina Bila. Ngidh nabiya uthuy yoewnar. Na kay nadh ngayapa kazi gasampa. Na bangal ngay kedha zapuya apu aymidhe, kuyk Bila.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kalanu nadh Bilana nubepa a nuy nabiya uthuy yoewnadhin. ");
INSERT INTO mwp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila Kalanu maythalayg aymaydhin a kazi madhin Yakubulpa garkaz. ");
INSERT INTO mwp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Na Reysoel kedha mulaydhin, ‘Awgadhan nguzu doegamuya zoeyzinoeydhayngu. Nuydh nguzu thoeythupoegay karngemingu a in ngayapa garkaz kazi mangu.’ Nadh kedha zoenguz nel tharadhin Dan. ");
INSERT INTO mwp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilan kalanu lak maythalayg aymaydhin, a kazi madhin lak garkaz kazi. ");
INSERT INTO mwp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Reysoel kedha, ‘Ngay mina koeyma ngaw tukuypoepa silamaypa miyayngu, kasa kay kedha ngath mura mangu.’ Kedha zoenguz nadh kazi kedha nel tharadhin Napathoelay. ");
INSERT INTO mwp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","*Na nanga Leya ngulayg asidhin kedha, nabepa lak kazipa lawnga, nadh Zilpa Yakubulpa madhin ipi, nanu zagethaw yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kalanu Zilpa kazi madhin Yakubulpa, garkaz kazi. ");
INSERT INTO mwp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya kedha mulaydhin, ‘Ngayapa kapu woenab.’ Nadh nel tharadhin Gad. ");
INSERT INTO mwp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","*Zilpa mamu lak garkaz kazi madhin. ");
INSERT INTO mwp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya kedha mulaydhin, ‘Nguzu dhiwa mina koeyza, yoepkazin bangal ngoena kedha thoeraypa, dhiwaw yoepkaz.’ Nadh kedha zoenguz nuyn kedha tharadhin Aser. ");
INSERT INTO mwp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","*Ayboewdhaw thonar nanga gasamoedhin Leyana garkaz kazi Rewben uzaraydhin. Nuydh imadhin bokadh koewsal. Kalanu nuydh nungu apupa, Leyalpa madhin. Nanu tukuyap Reysoel nadh na imadhin nanga sethabi puy koewsal, nanu kasa bag woer wayaydhin sepa puy koewsapa kedha, ‘ngayapa gar ngapa seyzi nginu kaziw ayngu mar.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya kedha kuniya mulaydhin, ‘Sena matha ngoedhagidh lawnga kedha ngidh nguzu alay mamu adhapa madhin nguzungu a kedha thonar ngidh mamu nguzu kaziw aypa adhapa maypa umepa.’ Reysoel kedha mulaydhin, ‘Ngidh kay nanga ngayapa nginu kaziw ayngu maypa, wa ngi kay kalanu ngoeban alayniya uthuy kaybaw kubilu.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yakubu nanga ngapa kuniya zagethaw lagoengu nanga mangiz kutapa, Leya nubepa adhapadhan kedha muliz, ‘Ngi kay ngaybiya kubilu, minguz kedha ngath modhabiya manu nguzu kaziw ayngu Reysoelapa.’ Wa Yakubun uthuy nabiya senabi kubilu. ");
INSERT INTO mwp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Awgadhan karngemidhin Leyana yoewdhay, na kalanu maythalayg aymaydhin a kazi madhin garkaz. Sena nanu garkaz kazi payb mura. ");
INSERT INTO mwp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya kedha mulaydhin, ‘Awgadhan ngayapa kuniya nguzu modhabiya mangu. Minguz kedha ngath ngoezu zagethaw yoepkaz poeybangu nguzu alaypa ipi.’ Nadh kalanu nanu kazi nel tharadhin Isaka. ");
INSERT INTO mwp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","*Kalanu Leya lak maythalayg aymaydhin a garkaz kazi madhin Yakubulpa sikis garkaz kazil mura. ");
INSERT INTO mwp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Na kedha mulaydhin, ‘Awgadhan ngayapa mina kapu sibawanay aymoeyngu. Nguzu alayn bangal ngoena balbayginga ayawal manine, minguz kedha ngath nubepa sikis mura garkaz kazil kazi mamayingu.’ Nadh kedha zoenguz kazi kedha tharadhin Zeboelon. ");
INSERT INTO mwp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","*Lak nanga wagelkun mamu nge yoepkaz kazi nadh nel tharadhin Dina. ");
INSERT INTO mwp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Awgadhan ngoenanu madhin Reysoelapa a nuydh nanu thoeythupoegay kuniya tidaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Na kalanu maythalayg aymaydhin, a garkaz kazi madhin. Na kedha mulaydhin, ‘Awgadhan nguzu azir adhapa madhin, nuydh ngayapa in kazi madhin, ");
INSERT INTO mwp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Awgadhan bangal ngayapa wara garkaz manine.’ Nuy waza nanu kulay kazi, nadh nuyn nel tharadhin, Yoewsepa. ");
INSERT INTO mwp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yoewsepan kazimay kaliya nanga Yakubu kedha mulaydhin Leyboenalpa, ‘Ngoena pawayar, ngay gar bangal ngaw lagoepa kuniya tidedhe. ");
INSERT INTO mwp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Setha ngaw ipi-kazil ngapa ngath nanga nginu zagethan gasamoeydhin. Ngath gar thana kuniya yoelpemine ngaybiya. Ngi ngulayg kedha, ngay ngibepa midh matha ngoedhagidh zagethan miyaydhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Leyboen kuniya mulaydhin kedha, ‘Ngay gar mamu kedha mulepa, ngay ngurpaydhin kedha ngaw guguwam zapungu, Awgadhan nanga ngayapa woenab madhin kuyk ngi. ");
INSERT INTO mwp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nginu ubi mi modhabipa nelay tari, ngath kay ngibepa modhabiya mamayipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakubu kuniya mulaydhin, ‘Ngi ngulayg ngay ngibepa midh zagethan miyaydhin, a mura nginu mamuyl ngath midh danal pathepu. ");
INSERT INTO mwp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ngibepa waza kulay kasa moegina ngay nanga ngapa mangaydhin ngath kay koesimoedhin, Awgadhan kalanu ngibepa woenab poeybarngu ngay bangal kasa ngalagiya nginu zagethaw lagiya. Ina ngaw thonar gasaman noegaypa ngaw ubilmaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Leyboen kuniya mulaydhin, ‘Ngath kay ngibepa miyay modhabiya maypa?’ Yakubu kedha, ‘Ngaw ubiginga modhabipa. Ngath bangal matha danal pathepu nginu mamuyl ina ngaw kasa wakaythoemamay nginu nanga ubi. ");
INSERT INTO mwp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ngath mamu mura nginu mamuyl zoeyzinoeydhemipa kayib, a adhamulaypa kay kubikub kazi mamuyl, a minaralmayl kazi nanil, setha kay mura ngaw ubi kedha. Thana kalanu ngaw uruyl modhabipa. ");
INSERT INTO mwp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sey boey kalaw goeygil ngidh bangal imaypu kay kedha ngay mi balbaygi mabayg, ngidh bangal nanga ngaw modhabipa imaypa medhedhe. Ngidh bangal nanga matha kubikubimayl a minaralmayl imaypa ngaybiya, wa balbayginga. Ngidh na nanga wara gamul mamuy lawnga nani ngaybiya imane nanga. Wa, ngi ngulayg asin kedha ngath kedha uruy nginungu purunu wardhamoeyngu.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leyboen kedha, ‘Wa, ngaw ubi ngoeba kedha aymoene nginu ubilnga midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kasa kedha Leyboen sethabi goeyginu mura minaralmayl garkaz a yoepkaz nanil lak adhapa thamayidhin, a kubikub mamuyl kalanu nuydh nungu garkaz kazil thurimoeydhin thanamuniya kedha nani a mamuy danal poethaypa wanadhin. ");
INSERT INTO mwp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kalanu thana adhapa memayidhin Yakubulngu, kalmel thanamuniya yoepkaz a garkaz nanil a mamuyl. Thana thoeri goeygilnga mab uzaraydhin nungungu. Yakubu nuydh kasa ngedh Leyboenan woenayzimayl danal pathepu uruyl. ");
INSERT INTO mwp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kalanu Yakubu nuydh maludh gamul thamal gasamoeydhin a puyngu piya moegina adhapakadhaman nubiya puyngu waniz. Matha goerab gamulmayl minaral waniz. ");
INSERT INTO mwp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Nuydh Yakubu thana thamal kalanu naniya parunu wanaydhin thanamun nguki woeni lagoenu. Nuy thana thamal sitha wanaydhin thanamulpa kazipa thana nanga ngapa ngukiw woenipa. ");
INSERT INTO mwp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Thana nanga nanil sike puy thamiya sagulsir paruya thana kazil mamayir mina kedha gamulmayl setha minaral puy thamal midh nanga. Nungu wakaythamamay a ubi kedha. ");
INSERT INTO mwp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Wa, nuydh Yakubu kedha aymoeydhin nanipa. Mamuyl wara dagamoenu nuydh wanaydhin. Wara nungu wakaythoemamay kedha, nuy thana Leyboenan mamuypa parul thoeyaymoeydhin, setha mi kubikub a minaralmayl Leyboen adhapa thamayidhin a setha mi mamuyl nanga Yakubuniya thana goerab gamulmayl kasa kay kedha thanamun kazil mamu kubikubilmayl nge. Wa, sethabi uruy kazil kubikubimayl a minaralmayl nuydh kalanu dhadh mamayidhin nubepa Leyboenan uruyngu. ");
INSERT INTO mwp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kurusipa Leyboenan mamuy amadhan goegadhasi a Yakubun mura mina mamuyl kedha zoenguz kedha thana nanga mina balbaygi uruyl kazipa gasamoeypa nanga Yakubu nuydh thana puy thamal thanamuniya parunu wanay ngukiw woeniw lagoenu. Lak thana sithaki kazin puremipa. ");
INSERT INTO mwp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nuydh goegadh uruypa kedha mayginga a thanamun kazil nanga Leyboenalpa. ");
INSERT INTO mwp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakubu kedha doegamuya balbaygoesidhin. Nuy koeyma mamuyl a nanil a zagethaw mabaygal a kamelal a donkil gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kalanu Yakubu karngemidhin kedha, Leyboenan garkaz kazin nuyn Yakubun koeliya thoeraypa kedha, ‘Yakubu, mura ngalpan thathiw zapul kusumoedhin. Nuy koey aydeg zapulayg aymiz, nungu luman lawnga Yakubun, setha mura muwaw zapul ngalpan thathiw zapul nuydh kusumadhin.’ Wa, nuydh Yakubu karngemidhin thanamun adhiya thoeray ya. ");
INSERT INTO mwp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Senawbi thonara nuydh lak imadhin kedha, Leyboen nungu ira, igalgagasidhin, nuy kulay mi igalayg nanga nungu irapa. ");
INSERT INTO mwp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kalanu Awgadh mulaydhin nubepa Yakubulpa kedha, ‘Yakubu, ngi ngaru kuniya nginu thathiw thathiw lagoepa, nginu buwaypa. Ngi akan maygi, kedha zoenguz kedha, ngay bangal ngibiya kalmel mura thonara koeygarsar.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kalanu Yakubu ya madhin Reysoelaw Leyaw mulipa, nungu ukasar ipipa kedha, ‘Ngalpa bal setha garwoeydhamoeyne, ngaw mamuyl ngalaga nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Palay nubiya mangemoedhin nanga, nuy kedha, ‘Ngath iman kedha ngipen thathi, ngayapa war paru thabukiriw paru aymiz, lak mina igalgaw paru lawnga nge. Kasa kay kedha, ngaw thathiw Awgadhan ngoena danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ngipel kalmel ngulayg kedha, ngay mina koey zageth aymoedhin ngipen thathipa, ");
INSERT INTO mwp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","kasa nuydh ngaw senawbi mina kapu zageth imayginga, nuydh ngoena ngalkadhin nuydh ngalben bokadhzoengu yawoeydhamoeyzinga patidhadhin ten thonaralnga. Kasa kay kedha Awgadhan ngoena wardhadhin nungungu ngayapa zangu aymoeyle. ");
INSERT INTO mwp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","‘Wa, ngipen thathiw kulay ya kedha, mura setha bokadh minaralmayl nanga ngaw zapul. Kalanu kazil mura matha kedha bokadh minaralmayl, mamuy kazil a naniw kazil. A nuy nanga kedha muliz, ngayapa itha kuykuthal minaralmayl, thana lak sethabi kazil mamayidhin kuykuthal minaralmayl. ");
INSERT INTO mwp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","In matha Awgadhan sethabi mamuyl, a nanil adhapa kusumoedhin nungungu, ngayapa mamayidhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Kazimay thonar nanga mangaydhin, ngoena pikin thayar. Ngath senabi pikinu muynu imadhin kedha, mura garkaz naningu, kazil mura thanamun minaralmayl, kedha bokadh minaralmayl a kuykuthal minaralmayl. ");
INSERT INTO mwp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Senabi pikinu muynu Awgadhaw angela ngayapa mulaydhin, ngoena tharal kedha, “Yakubu” ngath kudu manin kedha, “Midh?” ");
INSERT INTO mwp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Nuy angela kedha, “Ngapa nagi, setha garkaz manin nanga thana mura bokadh minaralmayl a kuykuthal minaralmayl a kazil lak kedha matha minaralmayl. Ngath kedha zoenguz kedha aymoedhin, ngay ngulayg kedha, nginu ira Leyboen ngibepa mi wati pawa aymoedhin nanga. ");
INSERT INTO mwp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","In ngay Kuykulnga Awgadh. Ngath ngibepa kulkub yakamaydhin wara lagoenu Betheloenu, ngidh ngalaga na kula adhapa thamadhin ngayapa, a ngidh olibaw puy koewsaw idi yoewdhadhin gimiya senabi kulaya, a ngidh ya woedhadhin ngayapa. Kedha thonara buth pathi a kuniya uzar senabi lagoepa ngin ngalaga nanga kazi madhin.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","Palay Reysoelaw Leyaw kedha, ‘Wa ngi mina yadu umepa, mura senawbi zangu modhab, ngalben niyaypa yoelpay thonara, kasa mulupa pudhaydhin wara zaginga, ngalben thathin wara ngalbelpa mina ngoedhal za mayginga. Nuydh ngalbe kasa yoewdhamoedhin, ngoedhe adhaz mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Wa, mura sethabi mina ngoedhal zapul, Awgadhan ngalben thathingu mamayidhin a ngibepa poeybaydhin, thana mura ngalpan kalmel zapul, a ngalpan kaziw. Ina matha Awgadhaw zageth, ngidh ngaru ayman nungu yangukudu ubilnga ngibepa midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yakubu mina sobaginga nungu ipi kazil buth pathamoeydhin yawarpa, gumi nungu thathiw Isakan lagoepa, Kananapa. Nuydh thanamulpa yaynanob poeybamoeydhin kamelal, thanamulpa niyaypa. A mura nungu koeygarsar tetel uruyl, a rugal, nuydh kulay wayaydhin nungu zagethaw mabaygiya. Mura setha tetel uruyl a mabaygal, a zapul nubiya Yakubuniya nuydh Leyboenan niyaylagungu, Mesopoetaymiyoengu balbayginga kusumadhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","20","Kasa kay kedha nuydh Yakubu Leyboenan karum paladhin, nuy yaginga miyaydhin gumi. Senawbi thonara Leyboen adhal nungu mamuya zagethan mer, nuydh thana baban thudhay adhal. Nuy nanga senawbi zagethan mer, nadh Reysoel nungu kalanu geth supamoeydhin Leyboenan lagaw muwaw parul kusumoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nuydh Yakubu mura zapul kusumoedhin a mina sobaginga nuy miyaydhin sizi adhapa. Thana koesiya bal poegamoeydhin, Ewpratesaw Koesiya, bal poegamoeydhin nanga thana padal lagoepa kalanu memayidhin Giliyadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Leyboen mina thoeri goeygiw kalanu kay ngulayg gasamoedhin kedha, Yakubu mema. ");
INSERT INTO mwp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kalanu Leyboen nungu mabaygal kusumadhin, Yakubulpa wagel lumaypa. Seben goeygiw kaliya thana nuyn imadhin Yakubun, Giliyadhoenu, padal lagoenu. ");
INSERT INTO mwp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Senabi kubilu nuyn Leyboenan pikin thayar kedha, nuydh Awgadh imadhin, a nuy Awgadh nubepa mulaydhin Leyboenalpa kedha, ‘Ngi ngaru koey giyawlnga bangal, Yakubulpa bangal wara za aymayg, ya bal mulayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakubu padanu gimal kawamudh aymaydhin a Leyboen nubepa lak kedha wara padoenu kawamudh aymaydhin a nungu mabaygal nubiya kalmel, Giliyadhoenu. ");
INSERT INTO mwp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Bathaynga na goeyga miyaydhin, Leyboen Yakubulpa kedha mulaydhin, ‘Ngidh mingu ngayapa kedha ngoedhal za aymoengu, ngaw yoepkaz kazi kasa yaginga mamoemoengu ngoedhe koewbu thonara pawa sena ngidh aymoengu, ");
INSERT INTO mwp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ngidh mingu kedha aymoengu, yaginga miyaydhin, ngoena ngulayg poelayginga. Ngi nay ngayapa mulaydhin, ngath ngin balbayginga nay wayadhin ikalnga dhiwalnga nathay nathay. ");
INSERT INTO mwp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ngidh ngayapa dhadhabuth mayginga ngaw ngepoepa, ngaw kazipa gud thoepamaypa, a yawa thuraypa. Sena ngidh ngayapa mina koey gegeyadh aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ngayapa mina matha ngoedhagidh kedha, ngath ngibepa za ayman kasa kay kedha, ngoena nginu thathiw Awgadhan, kubilu pikinu lawnga manin, ngibepa zangu aymoeyle. ");
INSERT INTO mwp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ngay ngulayg kedha wanangu, kedha zoenguz kedha, nginu lagoepa kuniya toedipa ubi, kasa kedha ngidh minguz ngaw lagaw muwal kusumoedhin?’ ");
INSERT INTO mwp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakubu kedha kuniya nubepa, ‘Ngay kedha zoenguz gumi miyaydhin ngapa, ngaw aka kedha, ngidh bangal nginu kazi ngawngu lawnga mamoemoene. ");
INSERT INTO mwp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kasa kay kedha, ngoey nginu zapul mayginga, muwal mayginga, aya nagi kowki ngoeymun zapuya, nginu mabaygal a ngaw mabaygal, koew thanamuniya parunu. Ngidh kay na ngunu ruganu imaypa nanga, senawbi mabayg kay uma mathampa, ngath ngin ngoelkayginga, kasa kay kedha nginu zapul nanga ngidh kay mamayir.’ Yakubu koerawayg kedha, Reysoel senawbi puru aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kalanu Leyboen Yakubun lagiya nagaydhin, a wara Leyana lagiya, ukasar yoepkaz zagethaw mabaygaw lagiya nagaydhin, nuydh ngaru imayginga. Kalanu nuydh Reysoelana lagiya nagaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reysoel sethabi muwal kusumoedhin, kamelaw yananu arimoeydhin, a kalanu na gimal thanuraydhin kalmelaw yananu. Leyboen mura nagaydhin nanu lagiya, kasa kedha ngaru imayginga. ");
INSERT INTO mwp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Reysoel nanu thathipa muliz kedha, ‘Ngayapa gar ngoenakap kom asig, ngayapa nginu parunu kaday thoeraypa lawnga, ngay yoepkaziw kikirilayg.’ Leyboen nuydh ngaru imayginga nungu muwal. ");
INSERT INTO mwp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakubu kalanu thabugud umiz, kedha muliz, ‘Ngan ngath za gegeyadh miyay manu.’ Nuy thabugudaw umayl kalmel yapu poeybiz, ‘Ngath mi sabi pathidhanu, mamu ngidh ngoena wagel lumanu ngapa? ");
INSERT INTO mwp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ngidh mura ngaw zapul tharthayamaynu lumayn, ngidh wara za imanu nginu lagaw za a? Koew adhal wanar ngoeban mabaygoepa imaypa kedha ngoebalngu nga balbayginga. ");
INSERT INTO mwp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ngay ngibiya mina koey kuykuthalnga, twenti wathoelnga, ngath danal poethepu nginu mamuy, thana wara gegeyadhoeginga kazimay thonara. Ngath kay mith matha poethayginga nginu garkaz mamuyngu. ");
INSERT INTO mwp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","41","A ngath lak kedha matha mura balbayginga danal poethamoeyngu, thoeydhayl uruyngu kubilu goeyginu, kasa midh, koey komalnga a koey gabunga sumaylnga, ngath mamu uthuy gasamayginga, ngay kedha meparuy twenti wathoelnga, nginu mamuyngu nanga urapun mathaman nanga ngath ngaru ngawngu kuniya ngibepa kuniya balbayg palan. Ngi ngulayg kedha wara mamuy danal poethay mabayg ngulayg ya dhadhawardhan kedha, “Ngapa nagi, ina umanga, ina ngaw gegeyadh lawnga, ina koey uruyn mathaman.” Ngath ngibepa kedha ngoelkay matha aymayginga. Potin wathoelnga ngay ngibepa zagethan miyaydhin nginu yoepkaz kazipa gasamaypa. Sikis wathoelnga ngay mamuy modhabipa zagethan miyaydhin ngibepa. Kasa kay kedha ngidh ngoena ngoelkaypu, modhabiw sakariya, ten thonaralnga. ");
INSERT INTO mwp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","‘Ngaw thathiw Awgadh, Abramaw, Isakaw. Nuy ngaybiya nay lawnga ngidh ngoena kasa zagig wayadhin adhapa nay. Kasa kay kedha Awgadh ngulayg kedha, ngaw gegeyadh midh a ngaw zageth, nuydh kubilu seysithaman, nungu minaman midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leyboen Yakubulpa mulaydhin kedha, ‘Ipal palbi yoepkaz nanga, palay ngaw kazi, a palamun kazil lak kedha, ngaw kazil, a setha mura tetel uruyl ngibiya ngaw zapul, mina kay kedha itha na zapul nanga mura ngaw zapul. Kasa kay kedha ngayapa koey zageth ngaw yoepkazil a ngepal panidhaypa ngibiya oesile, ");
INSERT INTO mwp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ngoeba urapun yangukudu ayimpa. Senabi zapa ngoeba kulan gamaypa ngoebalpa wakay thoeyaypa ngoeban yawoeydhayzinga midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","46","Kalanu Yakubu kula madhin kaday tharadhin a nuy nungu zagethaw mabaygoepa mulaydhin wara kulapa pasiya woenaypa. Kalanu thana mura Leyboenan kalmel ay purthadhin senabi kulaw gamayzimaynu pasinu. ");
INSERT INTO mwp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kalanu nan Leyboen nel tharadhin nungu yangukudun kedha ‘Zegar Sayadhutha.’ Yakubu nan kedha nel tharadhin nungu yangukudun kedha, ‘Galid.’ Sepal ukasar nel palamun aykap muynu kedha matha urapun, ‘Kulal Samayzinga Ngalpalngu Yakanurayle.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kalanu Leyboen kedha Yakubulpa, ‘Ina nabi kulaw gamayzinga nanga ngoebalpa ngoenanumaypa, nan kedha zoengu nel tharadhin Galid.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nuy Leyboen wara kedha mulaydhin, ‘Awgadhan bangal purka woenaypu ngabaniya, ngoeba nanga yaynanob memampu.’ Kedha zoenguz senabi lag nel tharadhin Yakubun yangukudu kedha, Mizpa muynu kedha, ‘Thuraw Lag.’ ");
INSERT INTO mwp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Leyboen nuy Yakubulpa matha umay yadu kedha, ‘Ngidh bangal ngaw yoepkaz kazi yababiya danal poethampu a ngi bangal nanga wara yoepkaziya niyaypa yoelapidhe, kasa bal ngay midh koerawayg, ngi ngulayg kedha Awgadhan ngoeba danal poethampa, nginu kedha wati zoengu aymayle. ");
INSERT INTO mwp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Itha kulal ngath gamamoeyn ngoebaniya dhadhal, in matha dhadhaw kula ngoebalpa wakay thoeyaypa. Ngayapa bangal koey zageth nubi gamayzimaya kaliya thoeyaypa, ngibepa mathamaypa, a ngi lak kedha koewki kaliya thoeyayg bangal ngayapa mathamaypa. ");
INSERT INTO mwp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nginu popu Abrama a nungu tukuyap Nayo ngaw thathi, palamun Awgadhan ngoebaniya dhadhal seysithamaypu.’ Kalanu Yakubu kedha, ‘Ngaw thathi Isaka, nungu Awgadhaw parunu, ngath ngaru ngoeban yawoedhayzinga ayman.’ Nubepa mina koey yawoedhayzinga. ");
INSERT INTO mwp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kalanu nuydh uruy mathamoedhin, nuydh Awgadhoepa poeybadhin padanu gimanoeka, a nungu mabaygal thuraydhin senabi zapa aygudoepa. Aygudaw kalanu thana kubil ukamoedhin padanu gimanoeka, ");
INSERT INTO mwp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","wara goeygiw mina bathaynga Leyboen nungu ngepal gudthapamoeydhin a nungu yoepkaz kazi ukasar, a nuy yawa thuraydhin thanamuniya. Kalanu nuy nungu lagoepa kuniya tidaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kalanu nanga Yakubu a nungu mabaygal ladhudhin. Nuy nanga mab woelmay nanga koeygarsar angelal nubiya dhadha mangemidhin yabugudoenu. ");
INSERT INTO mwp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nuydh nanga thana imaydhin nuy kedha mulaydhin, ‘Ina Awgadhaw mudhathoemay lag.’ Nuydh kalanu nan kedha tharadhin Mayanaym. ");
INSERT INTO mwp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Wa, kalanu thana amadhan thamadhin nungu tukuypaw Isawan lagoepa. Nuydh nungu zagethaw mabaygiya adhapudhay yangukudu gethamadhin kedha, nungu tukuypoepa, Isawalpa sey Edomoenu. ");
INSERT INTO mwp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nuydh thana yangu kudun mina ngurpaydhin mulaypa, ‘Ngath Yakubu nginu koerngayl zagethaw mabaygan yadu thuray ayman ngaw kuykulmaypa, matha kedha nubepa kedha, “Ngay kedha zoenguz ngapa kuniya tidayginga, ngay sin Leyboeniya merngu kurusipa kayib. ");
INSERT INTO mwp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ngath sizi ngayapa donkil, a mamuyl, a nanil gasamoeyngu, a zagethaw mabaygal. Ngath ngibepa yangukudu gethamanu. Ngaw wakaythamamay kedha, nginu ngoenakapoepa balbayg poelaypa ngayapa.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wa, yangukudu nanga ngapa kuniya Yakubulpa tidaydhin nanga, thana kedha, ‘Ngoey ladhudhin nginu tukuypoepa, Isawalpa. Nuy kay dhadhiya ulaypa yabugudiya ngibepa imaypa, nubiya kalmel 400 mabaygal mura.’ Yakubu nuy koerawayg kedha nungu tukuyap nuy ngapa mipa, koewbupa lawnga midh. ");
INSERT INTO mwp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nuydh koeyma aka gasamoedhin. Nuydh dhadhiya mamayidhin ukasar aymoemoedhin mabaygaw kubi, mabaygal nubiya ngaya nanga a nungu mamuyl, a donkil, a nanil, a kamelal. ");
INSERT INTO mwp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nungu wakay thoemamay kedha, ukasar mabaygaw kubi nanga moegina balbayginga, kedha zoenguz kedha Isaw kay mangepa a pakay nanga wara kubi nuydh mathaman, wa nakay wara mabaygaw kubipa nubepa gasamoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakubu kalanu thoeythupoegaydhin, ‘Awgadh, ngaw powpun Abraman a Isakan Awgadh ngapa kawra balthayar, ngi ngayapa mulaydhin kuniya tidaypa ngaw lagoepa a ngaw mabaygoepa a ngidh bangal mura zapul balbayg palimoeyne ngayapa. ");
INSERT INTO mwp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ngay kasa nginu wati zagethaw mabayg, ngay matha ngoedhagidh lawnga ngidh midh matha ngoedhagidh kapu pawa ngayapa aymarngu. Kulkub ngay balpagadhin Uridhaw koesiya ngaw thathiw lagoengu adhapadhadhin. Senabi thonar ngay wara zagig, matha boegi ngaybiya, a kedha thonara ngay koey aydeg zapulayg, palbi ukasar mabaygaw kubi kalmel a uruyl. Ina nginu koey woenabal danal poethay ngayapa. ");
INSERT INTO mwp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ngidh gar ngoena sib wanar ngaw tukuypoengu, nungungu ngayapa thabukiriw zangu aymoeyle, nungungu ngawngu mathamoeyle, a moegina kazil a yoepkazil lak kedha. ");
INSERT INTO mwp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wa, ngi ngulayg kedha nginu yawoedhayzinga ngayapa midh, ngidh bangal ngayapa matha ngoedhagidh aymoeypu, a ngaw kaziw kazil ngidh koeygarsar aymoeyne, mabaygoepa koey zageth gethatidaypa, matha kedha malu buwadhaw buthul midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Senawbi kubilu Yakubu si ukamoedhin. Bathaynga na goeyga nanga nuydh koeygarsar uruyl adhapa thamaydhin nungu uruyngu nungu tukuypoepa kozanipa maypa kedha, 200 yoepkaz nanil, 20 garkaz nanil, 200 yoepkaz mamuyl, a 20 garkaz mamuyl, a 30 susu poeybay kamelal thanamuniya thanamun kazil, a 40 kawal a 10 garkaz kawal, a 20 yoepkaz donkil, a 10 garkaz donkil. ");
INSERT INTO mwp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nuydh sethabi uruyl mura dhadhiya mamayidhin, a nungu zagethaw mabaygoepa mulaydhin kedha, ‘Ngitha ladhu Isawalpa, ngithamun yaynanob kubiya. Koey buth wanaw wara uruy kubingu wara kubipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Mi zagethaw mabayg nanga kulay uzaraydhin kubiya nuy Yakubu nubepa kedha, ‘Midh thonara nanga ngidh ngaw tukuyap iman nanga, nuydh sike ngin yapupoeyban kedha, “Nginu kuyku mabayg nga, a ngi ngalagapa, a itha ngunu uruyl.” ");
INSERT INTO mwp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ngi nubepa kuniya kedha muledhe, “Itha thabi uruyl Yakubun zapul ngibepa poeybayzimayl, nuy ngibepa koeyma apasin. Nuy kedha, nuy waza kasa zagethaw mabayg nginu, a nuy ngapa kalmel ngoeymuniya wagel.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nuy mura nungu wara zagethaw mabaygoepa lak kedha mulaydhin, thanamulpa Isawalpa lak kedha mulaypa, ");
INSERT INTO mwp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Nginu zagethaw mabayg Yakubu bangal wagel boey.’ Nungu ngoenanumanin kedha, wagel kay ngay nubiya dhadha mangemipa, nuydh kulay mura sethabi poeybayzimayl ngawngu gasampa, thana sike matha ngoedhagidh nungu tukuypaw Isawan ngoenakapoepa balbayg tidaypa. ");
INSERT INTO mwp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nuy Yakubu mura woeyamoeydhin sethabi poeybayzimayl nungu tukuypoepa, a nuy matha mudhathoemay lagoenu ugadhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Senabi kubilu nanga nuy Yakubu lak kaday tharaydhin a nungu ipi-kazil thurimoeydhin. Nuydh woeyamoedhin nungu ukasar ipi a nungu ukasar zagethaw yoepkaz, palay nungu wara ipi, a thana nungu eleben moegina kazil. Thana Zabok koesiya balpagamoeydhin. Thana garwoeydhoemoeypa maluya kapu mabawlagiya koesiya pagamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kalanu nuydh mura nungu mabaygal a rugal woeyamoeydhin nubiya kulay, matha nuydh ugadhin senabi mudhathoemay lagoenu. ");
INSERT INTO mwp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Senabi kubilu nanga mabayg nubiya mangaydhin a woeynaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Palamun woeynay silamay koeyza, kurusipa amadhan goeyga. Nuydh wara mabaygan imadhin kedha, nuy Yakubu goegadhoesiginga. Kalanu nuydh Yakubun dokap tidadhin a woeyam adhathayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nuy mabayg kedha mulaydhin, ‘Ngidh ngoena wanar, goeyga amadhan thamiz.’ Kasa kay kedha nuy Yakubu kedha, ‘Lawnga, ngidh mamu woenab poeybar ngayapa, kalanu kay ngath ngin woenaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nuy mabayg kedha mulaydhin, ‘Nginu nel nga.’ Nuy kuniya mulaydhin, ‘Ngaw nel Yakubu.’ ");
INSERT INTO mwp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Wa, nuy mabayg kedha mulaydhin, ‘Nginu nel lak lawnga Yakubu, nginu nel bangal Isoereyl kedha zoenguz kedha ngi mina goba kula, mura thonara ngi ngibepa mina koeyma zagethan meparuy, a mabaygoengu zapul mamayipa, a Awgadhoengu, kurusipa ngidh mura gasamoengu.’ ");
INSERT INTO mwp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakubu kedha, ‘Ngayapa tharal nginu nel.’ Kasa kay kedha nuy mabayg nubepa Yakubulpa kuniya kedha muliz, ‘Ngi mipa ngaw nelpa ngulaygoepa mepa?’ Kalanu nuydh mabaygan Yakubulpa woenab poeybadhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nuy Yakubu madhu pamiz, a nuy kedha, ‘Ngath midh paru Awgadh iman, ngalbe midh paru kidhakidhan imay sagul tharan, a ngaybiya midh paru za gegeyadh dhadha mangayginga.’ Nuydh senabi lag nel tharadhin Peniyel. ");
INSERT INTO mwp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Goeyga na mizin nanga Yakubu sizi mab kuykayman, roepayl roepayl, minguz kedha nungu dokap tidadhin. ");
INSERT INTO mwp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kurusipa kaybaw goeyginu nanga thana Isoereylaw mabaygan dokapiw senabi moegina madhu purthayginga, kuyk kedha zoenguz kedha Yakubun waza mathamoedhin senabi moegina dokapiw madhuya. ");
INSERT INTO mwp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakubu nuydh imadhin kedha Isaw a kalmel nubiya nungu mabaygal mura 400, nuydh Yakubu ipi kazil dhadhiya mamaydhin kalanu Leyaw, Reysoelaw muliya a nungu wara ukasar ipiya zagithaw mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nuydh kulay nungu wara ukasar ipiya zagethaw mabaygiya palamun kazil wanaydhin, kalanu Leya a nanu kazil a moeygoepa Reysoel a nanu kazi Yoewsepa palay mina wagel. ");
INSERT INTO mwp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakubu nungu mabaygoengu kulay uzaraydhin nuy nanga koezi woelmay Isawalpa nuydh kasa kulay seben thonaralnga nungu kuyk patidhadhin boeradhoerapa mulupa Isawalpa apapudhayn. ");
INSERT INTO mwp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kasa kedha Isaw Yakubulpa pa yabuya tharizoelmaydhin. Isaw nanga Yakubun gasamoedhin Isaw Yakubuniya dhadha goeray woeynaydhin a gud thapamoedhin palamun kalmel kidhakidhan may. ");
INSERT INTO mwp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kedha nanga nuy Isaw nagaydhin nuydh imaydhin yoepkazil a kazil nuy yapu poeybaydhin kedha, ‘Itha ngalagaw mabaygal ngibiya puzimoeypa?’ Yakubu kuniya Isawalpa kedha, ‘Itha Awgadhaw ngayapa poeybayzimayl ipi kazil a zagethaw mabaygal, nungu kapu kozan.’ ");
INSERT INTO mwp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kalanu Yakubun wara ukasar zagithaw mabayg ipi a palamun kazil kalmel. Isawalpa mura thanamun kuykul patidamoeyr. ");
INSERT INTO mwp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","A Leyange lak kedha nanu kazil kalmel mura kuykul patidamoeyr, a moeygoepa Yoewsepa a Reysoel palamun kuyk pathidhamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isaw yapupoeybaydhin kedha, ‘Setha dhuray mabaygal midh ngath ngaya nanga gasamoeyngu? Sew aykap miyay?’ Yakubu nubepa kuniya kedha, ‘Kobegadh kedha nginungu matha ngoedhagidhapa gasamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kasa kay kedha, Isaw kedha mulaydhin, ‘Ngaybiya matha ngoedhagidh ngayapa ngaw tukuyap setha sew ngibepa setha ngibiya mi zapul nanga?’ ");
INSERT INTO mwp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakubu kedha Isawalpa, ‘Maygi! Ngay gar yoewdhiz ngath kay nanga nginu matha ngoedhagidh gasampa ngidh kay ngaw sibwanan gasamar ngi ngaw mina kapu igalayg kayb ngath nginu paru yawaypa ngoedhe Awgadhaw paru ngayapa. ");
INSERT INTO mwp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngay gar yoewdhiz ngibiya matha gasamar ina ngaw sibwanan ngibepa Awgadhan ngoedhalnga ngoena sibwanaypa mura ngaw ubilmayl nuydh ngayapa aymoeypa.’ Yakubu Isawalpa matha umay a kurusipa Isaw Yakubulpa karngemidhin a madhin senabi sibwanan Yakubun. ");
INSERT INTO mwp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Wa, Isaw kedha, ‘Ngalpa ngadha palemipa mabapa, a ngay kay kulay uzaripa.’ ");
INSERT INTO mwp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakubu kedha Isawalpa, ‘Ngi ngulayg kedha itha kazil moegawgigal a ngath koepa mamuypa a itha tetel uruyl a thanamun kazipa wakaythoemamipa. Ngalpa bangal nanga thana mabapa mamayine nanga urapun goeygipa itha bangal mura umamayl. ");
INSERT INTO mwp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ngay ngibiya yoewdhiz, kulay uzar a ngay bangal gabudhan wagel senawki imaypa sobaginga bangal kalmel itha mura mamuyl a tetel uruyl a thanamun kazil kurusipa bangal ngath ngin gasamoene Idomoenu.’ ");
INSERT INTO mwp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Wa, Isaw kedha, ‘Ngath dhuray ngaw mabaygal ngibiya wanepa?’ Yakubu kedha, ‘A, kasa wanar wakay thoemoemayg ngaw ubi kedha, ngath matha nginu ubilmayl aymoeypu.’ ");
INSERT INTO mwp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Senawbi kaliya Isaw kuyk aymoedhin mab kuniya Idomoepa. ");
INSERT INTO mwp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kasa kedha Yakubu nuy Sukothoepa uzaraydhin nuydh ngalaga nanga nubepa nungu geth lag moeydhadhin iradh lag nungu tetel uruypa nan sena kedha zoenguz senabi lag kedha thoeraypa Sukoth. ");
INSERT INTO mwp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Nuy nanga kuniya tidaydhin Mesopoetaymiyangu nuy mura balbayginga mangaydhin Sekoemoenu Kananaw doegamunu. Nuydh nubepa mudha thoemay lag si aymoedhin senabi koey goegathoepa amadhan. ");
INSERT INTO mwp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nuydh nan senabi boeradhar barpudhoedhin Amoran buwayngu modhab mura 100 silba bokadhzapul. Nuy Amor waza Sekoman thathi. ");
INSERT INTO mwp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nuydh Yakubu kalanu olta moeydhadhin a nel tharadhin kedha El, Isoereylaw Awgadhaw nel. ");
INSERT INTO mwp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","War goeyginu na Dina, Yakubuwom Leyom yoepkaz kazi. Na uzaraydhin kasa gurguy mab Kananaw yoepkazipa. ");
INSERT INTO mwp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Wara garkaz sey nungu nel Sekoem, nungu thathi Amor thanamun Aybaythaw mopakuyk. Kedha nanga Sekoem imadhin nan Dina. Kedha nanga Sekoem Amoran garkaz kazi. Nuy Amor mamus thanamun Abaytaw, imadhin nan Dina nanga nuydh nan yoelpadhin a mina mura rugan thudhadhin. ");
INSERT INTO mwp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nuydh nan imadhin kedha, na mina adhapudhay thoeyaygi kapu yoepkaz. Nuydh nabepa ubi yadu pagadhin. ");
INSERT INTO mwp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nuy nungu thathipa kedha mulaydhin, ‘Ngaw ubi nabi yoepkazipa ngayapa ipi. Ngi gar uzar nanu thathipa muli.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kalanu Yakubu karngemidhin kedha, nungu yoepkaz kazipa mina kay aziral pawa aymoedhin a sethabi thonara Yakubun mura garkaz kazi adhal memayir kawaw lagoenu; nuydh Yakubu wara za aymoeyginga kurisipa nungu kazil kuniya mangemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sekoeman thathi Amor uzaraydhin Yakubuniya yasoegulpa. ");
INSERT INTO mwp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakubun garkazin mi thonara karngemin nanga a thana kay kayn kedha zagethoengu mangemidhin mina madhu pamemoedhin a mina gegeyadh gasamoedhin. Thana kedha umamoeyr, ‘Sena Sekoem mina wati pawa aymoengu nuydh kasa mura Isoereylaw mabaygiya azir kuykuya angarngu nuydh na Yakubun yoepkaz kazi rugan thudhadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kasa kay kedha nuy Amor ngapa Yakubulpa nubepa mulaydhin kedha, ‘Ngaw garkaz kazi Sekoem nginu yoepkaz kazipa ubin mepa; ngay ngibiya yoewdhiz matha pawayar nuyn getha garwoeydhamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ngoeba urapun yangukudu aympa lak bangal thana ngalpan mabaygal kidhakidhan niyaypa yoelpemipu. ");
INSERT INTO mwp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","A lak bangal thana ngitha itha memayipa ngoeymun memayipa a ina lag ubipa niyaypa zagethoepa a aypa zapa yoewdhaypa a gasamoeypa ngithamulpa boeradharoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kalanu nuy Sekoem Dinana thathipa a babathoepa kedha mulaydhin, ‘Ngoena gar ibupupuydhaw a ngath ngithamulpa bangal ngithamun ubil mura aymoeypu ngitha mipa mulemin. ");
INSERT INTO mwp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ngayapa mulemiw ngithamun mipa ubil midhel tharaw yoepkaziw matha gimal zagethoeginga ngithamun ubipa ngath kay poeybaypa ngithamulpa ngitha kay nanga ngoena pawoeyaypa garwoeydhamoeypa nabiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakubun garkaz kazil kalanu kasa ngoelkay aymoedhin Sekoemaw Amoraw mulipa thathi kazipa. Minguz kedha, Sekoem nuydh azir kuykuya angadhin thanamun babathiya. ");
INSERT INTO mwp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Thana kedha, ‘Ngoeymulpa ngoeymun babathoepa garkoeziya niyaypa yoelpaypa pawoeyaypa lawnga garkaz nanga motho poethalygig ngoeymulpa koey aziroelnga. ");
INSERT INTO mwp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ngoey kay matha asimoeypa kedha ubiya ngi a setha garkazil ngithamuniya bangal nanga motho pathamoeyne. ");
INSERT INTO mwp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","‘Wa, ngoey bangal urapun yangukudu aymoene kidhakidhan niyaypa yoelpaypa. Ngoey bangal ngithamuniya kalmel nithamoene a ngalpa bangal mura urapun. ");
INSERT INTO mwp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kasa kay kedha ngi bangal nanga ngoeymun ubiya oesiginga ngoey bangal nan kuniya manine a ngoey bangal memayine adhapa koezi.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Thanamun ubi ngoedhe balbayginga Amor a nungu garkaz kazi Sekoem palamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nuydh Sekoem mamu ugayginga nuy lak sin thamamun ubiya buwayl thayaydhin thana mi ubilnga wakay thoemamay nanga yakamoedhin. Minguz kedha, nungu ubi waza senabi yoepkazipa a nuy lak koey mina mabayg nungu buway. ");
INSERT INTO mwp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amor a Sekoem palay kalanu memamoedhin ya umay lagoepa thanamun goegathoepa a palay mulemoedhin, ");
INSERT INTO mwp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","‘Itha thabi mabaygal igalgal, thana bangal itha ngalpaniya ngalpan lagoenu bangal memayipa zapa yoewdhaypa a ubipa gurguy toedipu thamamun ubilmaypa. In boeradhar mina koeyza, a koey gudalnga thanamulpa a ngalpa bangal mura kidhakidhan yoepkaziya niyaypa yoelpemipa. ");
INSERT INTO mwp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Thabi mabaygal matha asimoeyne ngalpaniya kalmel maypa, urapun zapun ngalpa bangal nanga mura ngalpan garkazil motho pathamoeyne thanamun midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Wa, bangal thanamun tetel uruyl a mura zapul bangal midh mura ngalpan geth zapul aymoeyne a? Wa ngalpa urapun yangu kudu aympa lak thana bangal ngalpaniya kalmel niparuy.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Sethabi goegathaw mabaygal mura asimoeydhin Amor a Sekoem palamun yangukuduya kalanu garkazil mura motho pathamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Kasa kay kedha. Thoeri goeygiw kaliya nanga mura sethabi goegathaw garkazil matha motho poethay kikirilgal Yakubun garkaz kazi ukasar Simiyon a Lebi, Daynana babath palamun kuyay thurik mamamoedhin kalanu senabi goegathoepa memamoedhin a gumi mangemoedhin, a mina mura garkazil uma mathamoeydhin, kalmel Amor a nungu kazi Sekoem. Kalanu Daynana madhin sizi Sekoeman lagoengu kuniya kalmel palamuniya. ");
INSERT INTO mwp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Senawbi kaliya Yakubun dhuray garkaz kazin mina mura zapul kusumadhin thana senawbi gegeyadh madhin kuyk palamun babath. ");
INSERT INTO mwp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Thana mina mura tetel uruyl kawal, donkil a mura zapul kusumoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Koey zapul a yoepkazil a kazil lagoengu mura kusumoedhin thanamuniya kalmel. ");
INSERT INTO mwp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakubu kedha mulaydhin Simiyonaw Lebiw mulipa, ‘Ngipel aymoeynu ngayapa mina koey gudal gegeyadh Kananalgal a Perezaythalgal a mura sew mabaygal bangal ngayapa ngoenakap mapu gasamoene. A ngay mabaygoegig thana bangal nanga garwoeydhamidhe ngayapa mathamoeypa ngalpa bangal mura umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Palay kuniya kedha mulemoedhin, ‘Ngalbelpa ngalben babathoepa kasa kedha wati zapa imaypa a pawoeyaypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Wa, Awgadh Yakubulpa mulaydhin kedha, ‘Ngi a nginu mabaygal ngitha ladhu, kedha thonara, Betheloepa, sew bangal Betheloenu memayipu. Ngidh bangal olta ngayapa moeydhane sew. Ngay Awgadh ngibepa nga nanga kulay yakamaydhin, ngi nanga zoelmaydhin seyzi adhapa Isawalngu, nginu tukuypoengu.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kalanu Yakubu mulaydhin nungu ipi kazipa, nubiya ngaya nanga mabaygal na mura, ‘Adhapa geth wanemiw seyzi setha adhaz paru awgadhal ngithamuniya memayipa. Adha idimaw ngithamulngu, woer poelaw, a pudhu rugal maw, a buth pathemiw. ");
INSERT INTO mwp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ngalpa sethaki Betheloepa Awgadhaw oltapa moeydhaypa, ngoena ngadh ibupuydhar ngaw gegeyadhoengu, a ngaybiya nga na puzirngu mura thonara ngay ngalagiya nanga walmayrngu.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wa, kalanu thana setha azaz parul, muwal Yakubulpa kusumoedhin, a thanamun thawthil thanamuniya pagemir nanga. Nuydh kalanu thana moerama idimoedhin puy kuykoenu apal, amadhan Sekoemoenu. ");
INSERT INTO mwp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wa, Yakubu a nungu garkaz kazil, thana na mab kuykaymaydhin nanga. Mura pasiw goegathaw mabaygan aka gasoemoedhin muynu. Thana kedha zoengu Yakubulpa kuniya za aymayginga, thanamun koey aka. ");
INSERT INTO mwp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakubu a nungu mabaygal thana wara Kananaw goegathoepa miyaydhin, goegath nel Luz. Kayib nan kedha thoeraypa, Bethel. ");
INSERT INTO mwp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nuydh Yakubu kalanu olta moeydhadhin, a nuydh nan nel tharadhin mina Awgadhaw nel sey Betheloenu. Minguz kedha, kay paypa kulay thonar nanga Yakubu nuy buparaydhin nanga nungu tukupangu Isawalngu, senawbi thonara nanga Awgadh nungu geth mina yakamaydhin Yakubulpa. ");
INSERT INTO mwp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Thana si Betheloenu memayipu nanga Rebekana getha doegam zagethaw mabayg, nanu nel Debora, nadh muwasidhin. Thana nan moerama thayadhin puy kuykunu zaya doegamoenu, Bethela. Thana kalanu lag kedha tharadhin kedha, Maynguzi Gaybawaw Lag, thanamun may waza Reysoelana getha doegam zagethaw mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakubu nanga, kuniya tidaydhin Mesopoetaymiyangu. Awgadh nubepa lak yakamaydhin, a woenab poeybadhin. ");
INSERT INTO mwp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Wa, Awgadh nubepa mulaydhin, ‘Nginu nel Yakubu, kasa kay kedha koezi kayboengu, nginu nel Isoereyl.’ Awgadhan nuyn nel tharadhin ");
INSERT INTO mwp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","a Awgadh nubepa mulaydhin, ‘Ngay woenabaw poeraparaw Awgadh ngath ngibepa woenab poeyban; nginu bangal koezi powpa, kaziw kazil bangal mina koey garsar. Koey boeradharal bangal mabaygal palepu nginu kaziw kazingu, a powpa thanamun mopakuykul lak kedha nginu kulkangu. ");
INSERT INTO mwp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ngath bangal ngibepa poeybane boeradhar, mi boeradhar nanga ngath kulay nginu populpa Abramalpa a nginu thathipa Isakalpa, lak bangal kedha nginu kaziw kazipa ngibiya wagel.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Awgadhan nuyn wanadhin. ");
INSERT INTO mwp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Awgadh nubepa ngalaga nanga yadu umay, nuydh Yakubu kalanu kula kaday tharadhin paru. Kalanu nuydh Yakubu umal nguki a olibaw idi gimiya suladhin pay yoewdhadhin senabi kula, kedha zapa adhapa thamadhin senaw Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Nuydh kalanu nan kedha nel tharadhin, ‘Bethel.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakubu a nungu ipi kazil a mabaygal Betheloengu ladhudhin. Thana nanga matha sigal tadir nanga wara lagaw nel Eprathoengu. Nanu, senabi thonara Reysoelana kazi kikirin gasamoedhin, nadh mina gegeyadh wati kaziw kikir gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nan nanga kazi kikirin ngapa koeyza aymaydhin nanga, kazi gasamay zagethaw yoepkaz nabepa mulaydhin kedha, ‘Akan maygi Reysoel, nginu wara garkaz kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kasa kay kedha na mina magawg asidhin, nadh nanga nanu moeygoepa gub nanga kabapa yoewthay nanga, nadh nuyn senawbi kazi kedha tharadhin, Benoni. Kasa kedha nungu thathin nuyn nel tharadhin Benzoeman.* ");
INSERT INTO mwp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","*Na nanga Reysoel um miyaydhin nanga, nan moerama thayadhin yabugudoenu pasinu, Eprathapa yabugudoenu. Kayib nan lag kedha thoeraypa Bethliyam. ");
INSERT INTO mwp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakubu wara paru kula lugitharadhin, senabi thonara; kedha zapa kedha kurusipa kayib, senabi moeram ngaru mepa sey senabi thonara. ");
INSERT INTO mwp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kalanu Yakubu a nungu mabaygal lak mamayidhin sizi, a kalanu thana moegina mudhaw lagal aymoeydhin, wara doegamoenu Edhanu. Mabaygaw moeydhayzi lag sey koey kuykuthalnga apaz kadaypa. ");
INSERT INTO mwp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Thana nanga si memayipu nanga, Rewben nuydh mina koey wati pawa aymoedhin, nungu thathiw zagethaw yoepkaz ipiya Bilaniya. Yakubu karngemidhin, nungu Yakubun kalanu mina koey ngurum. Yakubun garkaz kazil mura toewalob. ");
INSERT INTO mwp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leyana kazil Rewbend* Yakubun kuykuy kazi, Simiyone*, Lebif*, Zudhag*, Isakarh*, a Zeboeloni*. ");
INSERT INTO mwp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","*Reysoelana garkaz kazil, Yoewsepa a Benzoemank*. ");
INSERT INTO mwp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","*Reysoelana zagethaw yoepkaz nanga, Bila nanu kazi Danm* a Napathoelayn*. ");
INSERT INTO mwp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leyana zagethaw yoepkaz Zilpa, nanu kazi Gad a Aserb*. Itha thabi garkaz kazil Yakubun, thana mura dan imaydhin sey Mesopoetaymiyanu. ");
INSERT INTO mwp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakubu miyaydhin nungu thathipa Isakalpa, goegathaw nel Mamre, amadhan Ebronoenu, Abrama kulay ngalaga nanga meparu. ");
INSERT INTO mwp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka senawbi thonara nanga mina koey thathi, nungu wathal mura 180. ");
INSERT INTO mwp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kalanu nuydh muwasidhin. Nungu garkaz kazi Isaw a Yakubu, palay nuyn si moerama thayadhin, matha kedha. ");
INSERT INTO mwp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nuy Isaw nungu wara nel Edom, nungu kaziw kazil powpa itha kedha. ");
INSERT INTO mwp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nuy ukasar yoepkaziya geth dhoerdhimoeydhin Kanananu kedha, koeykoeyne ipiw nel Adha, na Elonan kazi, Ithalayg. Nungu wara ipiw nel Oyolibama, na Anan kazi. Ana nuy Ziboenan kazi Aybaythalayg. ");
INSERT INTO mwp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A wara nungu ipi Basemath, Ismeylan yoepkaz kazi. Nanu babath nel Nabiyath. ");
INSERT INTO mwp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adha Isawan koeykoeyne ipi kazi madhin nel Elipaz, a nungu wara ipi Basemath na kazi madhin nel Ruwel. ");
INSERT INTO mwp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","A Oyolibama, na kazi madhin nel Zewus, Zewusan kalanu Zalam, a Zalaman kalanu, Kora. Itha thabi garkaz kazil dan imaydhin thana nanga Kanananu mamayipu. ");
INSERT INTO mwp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kalanu Isaw mamayidhin nungu ipil a kazil, garkaz kazil a yoepkaz kazil, a mura mabaygal a zagethaw mabaygal, mura nungu tetel uruyl, a mura nungu soeyzi gasamoeyzimayl zapul, thanamuniya kalmel Kananangu. Kalanu thana memayidhin, nungu tukuypoengu, Yakubulngu wara lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nuydh kedha zoenguz wanadhin senawbi lag. Senawbi boeradhar buthag asidhin thanamulpa mura, a thanamun tetel uruypa kalmel moegina aypa purthaypa. Palamun Isawom Yakubuwom tetel uruyl mina koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isaw nubepa niyaylag aymoedhin Edomoenu, padanu dhadhal. ");
INSERT INTO mwp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isawan kaziw kazil thana Edomaw buyalgal aymoeydhin kedha. ");
INSERT INTO mwp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Isawan ipi Adha kazi madhin urapun garkaz kazi nel Elipaz. Elipazan payb garkaz kazil kedha, Teman, Omar, Zepo, Gatam, a Kenaz, a wara ipingu nanga, nanu nel Timna nuydh urapun garkaz kazi gasamoedhin nel Amalek. Isawan ipi Basemath nadh nubepa garkaz kazi madhin nel Ruwel. A Rewlan garkaz kazil puwa mura, nelay itha, Nayath, Zera, Sama a, Miza. ");
INSERT INTO mwp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isawan wara ipi nel Oyolibama, na Anan yoepkaz kazi. Ana nuy Ziboenan garkaz kazi. Nanu Oyolibamana thoeri mura garkaz koezil nelay kedha Zewush kuykuyg, Zalam dhoedhalayg, a Kora kuthayg. ");
INSERT INTO mwp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isawan kazingu buwayl pawpa kedha; Isawan kuykuyg kazi Elipaz nuy thabi buwaypa kuyku mabayg aymaydhin. Nungu garkaz kazil mura buway kuyku mabaygal aymoeydhin, thanamun nelay itha kedha; Teman, Omar, Zepo, Kenaz ");
INSERT INTO mwp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, a Amoelek. Itha mura Isawan ipiw Adhama kaziw kazil. ");
INSERT INTO mwp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isawan wara garkaz kazi nel Ruwel. Nuy thabi buwaypa kuyku mabayg aymaydhin; a nungu garkaz kazil mura buway kuyku mabaygal aymoeydhin, thanamun nelay itha kedha; Nayath, Zera, Samak, a Miza. Itha mura Isawan ipiw Basemathana kaziw kazil. ");
INSERT INTO mwp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Itha wagelaw buwayl nanga Isawan, wara ipingu, Oyolibamalngu Anan yoepkaz kazi. Nanu kedha garkaz kazil mura buway kuyku mabaygal aymoeydhin; buwayl itha kedha. Zewush, Zalam, a Kora. ");
INSERT INTO mwp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Itha thabi buwayl nanga Isawalngu pawpa. ");
INSERT INTO mwp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Mina Idomaw niyay Idomalgal buwaya dhadh memayidhin Isawaniya kulay, kuyk nanga lumadhin Seyra nuy Oraythalayg. Nungu kaziw kazil itha kedha, Potan, Sobal, Ziboen, Ana Dison, Ezer, a Disan. Thanamulngu powpa buwayl itha kedha. ");
INSERT INTO mwp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Potan kaziw kazingu, Ori a Erman palamun ipal buway matha kedha. Potan babath nanu nel Timna. ");
INSERT INTO mwp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalan kaziw kazingu Alban, Manayadh, Ebal, Sepo, a Onam. ");
INSERT INTO mwp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ziboenan ukasar garkaz kazi nel Aya, a Ana. In nubi Ana nanga, komal ngukiw kuyk, ngoedhalnga bupanu imadhin nungu thathiw donkiw danal poethay thonara. ");
INSERT INTO mwp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana nungu garkaz kazi Dison. Disonan kaziw kazingu ngapa buwayl itha kedha. Nungu garkaz kazil mura buway kuyku mabaygal aymoeydhin a thanamun nelay itha kedha, Emdan, Esban, Ithran, a Seyran. Anan wara kazi yoepkaz nel Oyolibama. ");
INSERT INTO mwp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Seyran wara garkaz kazi nel Ezer. Ezeran kaziw kazingu Belan, Zaban, a Akan, setha thoeri buway. ");
INSERT INTO mwp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishanan kaziw kazingu palbi buway Uza a Aran. ");
INSERT INTO mwp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Itha thabi buwayl nanga thana Oraythalgal buwayl Idomoenu, Potan, Sobal, Ziboen, Ana, Dison, Ezer a Disan. ");
INSERT INTO mwp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wagel kay thana mopakuyku mabaygal aymoedhin Isoereylanu itha kedha, Sewl, Dhawitha, Solomon. Kulay thanamuniya kedha ngoedhal mopakuyku mabaygoeginga, kasa kay kedha Edomoenu nanga thana mina kulay mopakuyku mabaygalgal. Nelay itha kedha, ");
INSERT INTO mwp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Mamu Bela nuy Beyon kazi, nungu goegath Dinaba. ");
INSERT INTO mwp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela nanga guythuyadhin, Zobab Zeran kazi aymoedhin thanamun Edomaw mopakuyk. Zobaban goegath Bozra. ");
INSERT INTO mwp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Zobaban umaw kalanu Usam nge thanamun mopakuyk aymoedhin, nuy Temnalayg. ");
INSERT INTO mwp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Usaman umaw kalanu Adad, Bedadan kazi aymoedhin thanamun mopakuyk. Nuydh mura azaz mabaygal Midiyanalgal adhadhin. Nungu goegath Abith. ");
INSERT INTO mwp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Adadan umaw kalanu Semla aymoedhin thanamun mopakuyk, Masreykalayg nuy. ");
INSERT INTO mwp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Semlan umaw kalanu Suwal aymoedhin thanamun mopakuyk. Nuy Reybothoengu, Ewpratesaw koesaw buwadhoengu. ");
INSERT INTO mwp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Suwalan umaw kalanu Balanan Akoran kazi aymoedhin mopakuyk thanamun. ");
INSERT INTO mwp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balananan umaw kalanu Adhar aymoedhin thanamun mopakuyk. Nungu goegath Pawu, a nungu ipiw nel Meyethabel, Methredhan yoepkaz kazi, Mezaybalngu. ");
INSERT INTO mwp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Isaw waza nubi Edomalgaw buwaylayg Timna, Alba, Zetheth, Oyolibama, Ela, Pinon, Kenaz, Teman, Mibzar, Anagadiyel, a Iram. Itha thabi buwayl ngalaga nanga memayipu yaynanob thana thanamun buway nel thoeraypu. ");
INSERT INTO mwp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakubu nuy matha meparu Kanananu, nungu thathiw kupa moeramoenu. ");
INSERT INTO mwp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ina Yakubuya apu thath kaziw ya. Wara nungu garkaz kazi Yoewsepa, mina kayn mabayg matha sebentin wathalayg, nuydh danal poethepu mamuyl a nanil kalmel nungu tukuypal, Bilawom a Zilpawom garkaz kazil. Palay nungu thathiw zagethaw yoepkaz a matha kedha ipi nungu. Nuydh Yoewsepa nungu tukuypal yadu palgamoeydhin thanamun thathipa, Yakubulpa kedha thana gegeyadh aymoedhin adhal zagethaw lagoenu. Thana nungungu kedha zoengu ubigigal. ");
INSERT INTO mwp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isoereyl Yoewsepan mina koeyma maman mayparu, nungu tukuypal mamu maman mayginga. Minguz kedha, nuyn Yoewsepan nanga kazi madhin nuy Isoereyl mina koey gudal thathi sinubi thonara. Nuydh sodh koey kutha gethalnga aymoedhin Yoewsepalpa. ");
INSERT INTO mwp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Thana nanga nungu Yoewsepan tukuypan imadhin thanamun thathin Yoewsepan koeyma maman mayparuy a thana mamu maman mayginga, thanamun ngoenakapul koey komalmayl Yoewsepalpa a thana nuyn kaliya thoeraypu a matha koey dharadh nubepa ya umamoeypu. ");
INSERT INTO mwp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Wara kubilu nanga nuyn Yoewsepan pikin thayar a nuydh na nan piki umar nungu tukuypoepa nanga, thanamun kasa kay lak thabukir mina koeyza Yoewsepalpa. ");
INSERT INTO mwp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nuy Yoewsepa kedha, ‘Kurusipagemiw ngaw pikipa. ");
INSERT INTO mwp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ngalpa mura kalmel dharbaw lagoenu nanga ngalpa yaynanob kunaw koewnil woeydhamoeynguz kunaw apaw lagoenu; ngaw koewni nanga nanu geth lugithariz na wadhethulu matha siyanguz a ngithamun koewnil thanamun geth ngaw koewniya mura wadhwadhgam kasa kay kuykul pathidhamoeynguz ngaw koewnipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Thana nungu tukuypal nubepa kedha yapupoeybemidhin, ‘A! Na nginu wakaythoemamay kedha, ngin bangal kuyku mabayg aymoene a ngidh bangal minampu ngoeymulpa a?’ Kalanu thanamun kasa kay lak thabukir mina koeyza nungu pikingu a nuy thanamulpa midh nanga umay. ");
INSERT INTO mwp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kalanu Yoewsepan mamu lak nge pikin thayar, nuy kedha mulaydhin nungu tukuypoepa, ‘Ngoena kubilu lak pikin thayan, ngath pikin iman goeyga a moelpal a eleben thithuyl ngayapa kuykul pathidhamoeynguz.’ ");
INSERT INTO mwp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Nuydh Yoewsepa nungu thathipa umadhin nan nungu piki, kasa kay kedha nungu thathi nubepa Yoewsepalpa yapoeybaydhin kedha, ‘Sena midh paru piki, ngi kasa nginungu koeyza aymipa. Na nginu wakaythamamay midh kedha nginu apu a nginu tukuypal a ngay mura bangal ngibepa kuykul pathidhamoeypu a ngin bangal thawmayparu a?’ ");
INSERT INTO mwp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yoewsepan tukuypaw daniya balpudhay mina koeyza, kasa kay nungu thathin wakay thoemamipu muynu nungu ngoenakapoenu a pudhamoeypu nungu Yoewsepan pikipa. ");
INSERT INTO mwp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wara goeyginu thana Yoewsepan tukuypal ladhudhin Sekompa thanamun thathiw tetel uruypa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isoereyl nuy Yoewsepalpa kedha muliz, ‘Ngaw ubi ngibepa Sekompa mabapa nginu tukuypan ngalaga nanga tetel uruyl danal pathepa.’ Nuy Yoewsepa kedha muliz, ‘Ngay buth pathepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakubu, kedha, ‘Uzar, imaypa thana nginu tukuypal midh balbayginga a thana tetel uruyl midh lak balbayginga; ngi kay kalanu ngapa kuniya tidi ngayapa yadu thuraypa.’ Wa, nungu thathin nuyn wayadhin. Nungu yabugudiya Ebronaw padaw dhadha sakariya Yoewsepa mangaydhin Sekoemoenu. ");
INSERT INTO mwp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Nuy kasa sike gurguy woelmay a nagay kedha Sekoemoenu, nuyn nanga garkazin imadhin. Nuy garkaz yapupoeybiz kedha, ‘Ngidh mabayg lumaypa?’ ");
INSERT INTO mwp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nuy Yoewsepa kedha muliz mabaygoepa, ‘Ngath ngaw tukuypal lumepa, tetel uruyl ngaya nanga danal pathayngu. Ngi gar kay ngayapa mulepa kedha thana ngalaga?’ ");
INSERT INTO mwp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nuy senawbi mabayg kedha muliz, ‘Thana memayingu. Ngath kedha karngemingu, thana Dothanipa memayingu.’ Kalanu nuy Yoewsepa wagel uzaraydhin nungu tukuypoepa. Nuydh thana si Dothaninu gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Thana nanga nuyn imadhin nuy ka matha sigal ngapa woelmay. Nuy kay thanamuniya wagel kay mangepa, thana nubepa mathamoeypa ya umadhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Thana kedha mulemidhin kidhakidhan, ‘In boey ulaypa pikiw thoerayzig. ");
INSERT INTO mwp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ayawal ngalpa nuyn mathamaypa a nungu gamu kay ngalpa aygi maypa thoeyaypa. Ngalpa kay kedha mulemipa, thoeydhayl uruy nuyn mathamoengu. Kalanu bangal ngalpa nagemine na bangal nungu pikingu ngalpa miyay imane.’ ");
INSERT INTO mwp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Thanamun kuykuyg, Rewben nuydh karngemidhin thana midh nanga umamoeyr, nuydh nuthay aymoedhin Yoewsepalpa gudaz puydhaypa. Nuy kedha, ‘Ngalpalpa nubepa mathamaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ngalpa kay kasa nuyn aygi ngukiw maynu woenaypa in bupanu, wara zapa aymoeypa lawnga, nungu kulka payoewdhayg.’ Muynu nanga nungu Rewbenan nuthay Yoewsepalpa gudaz puydhaypa a kalanu kuniya wayan nungu thathipa. ");
INSERT INTO mwp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nuy nanga Yoewsepa thanamuniya mangaydhin nungu tukuypiya, thana nungu koey sodh pakadamoeydhin, nungu kuykuthal gethal sodh. ");
INSERT INTO mwp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kalanu thana nuyn Yoewsepan aygi maypa thayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Thana nanga ay purthar thana imaydhin Ismoeylalgal Giliyadhoengu tadir Aykupithupa. Thanamun kamelal rugan guray kapu ganul rugal a dhuray rugal kedha. ");
INSERT INTO mwp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yudha nuy kedha, ‘Na kay ngalpa za miyay gasampa ngalpa kay na nuyn uma mathampa a wara mulaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ngalpa kasa nuyn yoewdhaypa thanamulpa Ismeylgoepa, ngalpalpa nubepa wara zapa aymoeypa lawnga. Senaw mina ngalpan tukuyap, urapun kulka ngalpaniya.’ Nungu Yoewdhan tukuypal asimoeydhin nungu ubiya. ");
INSERT INTO mwp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Senabi thonar zangu yoewdhay mabaygal, Midiyanalgal nanga sike yabay matha tadir, thana Yoewsepan tukuypan nuyn Yoewsepan adhapa madhin mayngu a kasa zapudh yoewdhadhin twenti silba bokadhzapupa Ismeylgoepa. Thana Ismeylalgan madhin Yoewsepan Aykupithupa. ");
INSERT INTO mwp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kedha nanga nuy Rewben ngapa maypa nuydh imadhin kedha, Yoewsepa sizi matha lawnga, nuydh koerkak badhan nungu rugal pakadamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nuy Rewben koezi nungu tukuypoepa si nanga mangiz thanamuniya nuy kedha, ‘Yoewsepa mayngu matha lawnga! Ngath kay za miyay ayimpa?’ ");
INSERT INTO mwp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kalanu thana nungu Yoewsepan tukuypan nani mathamoedhin a nungu Yoewsepan sodh kulkanu tharadhadhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Thana kalanu nan sodh thanamun thathipa madhin a kedha mulemidhin, ‘Ngoey ina imangu, ina nginu kaziw sodh a?’ ");
INSERT INTO mwp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nuydh nanga ngurpadhin a kedha mulaydhin, ‘Wa, ina nungu sodh, Yoewsepan! Thoeydhayl uruyn mathamoedhin, ngaw kazi mina moegithap madhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakubu koerkak badhan nungu rugal pakadamoeydhin a awmaw rugan ubamoeydhin. Kalanu nuy mina koey kuykuthalnga nungu kaziw awmanu thanuraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Mura nungu kazil yoepkaz kazil a garkaz kazil imaypa kedha nuyn balbayg tidar kasa kay nuy ubigoesipu. Nuy kedha mulaydhin thanamulpa, ‘Ngay bangal lak umanga ngaw kaziw awmanu dhadhal.’ Nuy kay matha awmanu niparu, nungu kaziw Yoewsepan. ");
INSERT INTO mwp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Senawbi thonara Aykupithunu Midiyanalgan Yoewsepan yoewdhadhin Aykupithu mabaygoepa, nubepa Pothipalpa Aykupithu mopakuyku getha doegam zagethaw mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Senawbi thonara nanga, Yudha miyaydhin nungu tukuypoengu, a nuydh nungu mudhathoemay lag amadhan aymoeydhin Adulamaw mabaygiya nungu nel Yira. ");
INSERT INTO mwp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Si nuydh Yudha Kananaw yoepkaz, ngoewakaz gasamoedhin, nanu thathiw nel Suwa. Nuy kalanu niyaypa yoelpaydhin nabiya. ");
INSERT INTO mwp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kalanu nadh garkaz kazi imadhin, Yudha nuyn nel tharadhin Er. ");
INSERT INTO mwp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kalanu na lak mapunga aymaydhin, kazi madhin wara garkaz kazi. Yudha nuyn nel tharadhin Onan. ");
INSERT INTO mwp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na lak mapunga aymaydhin, kazi madhin lak garkaz kazi, Yudha nuyn nel tharadhin Sela. Thana sethabi thonara lagoenu memayipu, lagaw nel Akzib, Selan nanga kazi madhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yudha nungu kuykuyg kazipa ipi gasamoedhin, nanu nel Thamar. ");
INSERT INTO mwp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kasa kay kedha nungu Eroen ngarapudhamay, a buwayl thoeyay Awgadhoepa matha ngoedhagidh lawnga. Awgadhan nuyn umapa wayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Era na guythuyan nanga, Yudha kedha Onanalpa, kuthaygoepa kedha, ‘Ngidh ngaru ngalpan koey pawa ayman nabepa, ngidh nan mar niyaypa yoelpaypa kazipa koesimoeypa nginu kuykuygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kasa kay kedha Onan nuy ngulayg kedha, nadh bangal na kazil mamayine nanga, nungu Onanan kazil lawnga, nungu tukuypaw kazil. Kalanu nuy Onan kedha, palay nanga sagul thareman nanga, nuydh nan ngaru maytha poelayginga. Nungu Onanan ubiginga kedha, nungu lumayzi kazil nungu kuykuygaw nelay wamayipa. ");
INSERT INTO mwp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nungu Onanan buwaylthoeyay lak kedha Awgadhoepa matha ngoedhagidh lawnga. Awgadhan kalanu nuyn umoepa wayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yudha nungu urapun garkaz kazi wanadhin, ukasar mulupa, nungu aka kedha zoengu, wara kedha nungu kazi Sela, lak kedha umanga. Nuydh kalanu nan Tamana wayadhin kuniya nanu apu thathiw lagoepa, mulaydhin nabepa kedha, ‘Ngi bangal sew meparu, kurusipa bangal ngaw kazi Sela koey mabayg aymidhe ngibepa alaypa.’ Wa, na miyaydhin nanu apu thathiw lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sizi powpa moegina kuykuthalnga buth, a kalanu Yudhan ipi um miyaydhin. Nuydh nanga koerkak badh nanga awm muwasidhin nanga adhathayadhin. Sew kalanu nuy nungu igalgoepa mulaydhin Yiralpa, Adulamoelayg nuy. Palay kalmel uzarmoedhin thanamulpa nungu mamuy zagethaw mabaygoepa. Thana ngalaga nanga nungu mamuyl baban thudhamoeyr, lagaw nel Timna. ");
INSERT INTO mwp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Thamar nungu Yudhan garkaz kaziw ipi, nadh karngemidhin nanu ira Timnapa miyaydhin nungu mamuypa baban thudhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Na Thamar ngulayg kedha, nan bangal Selapa ipi manine, kasa kay kedha Yudha thanamun koey pawa aymayginga, Sela kay koey mabayg aymoeydhin, Yudha nuydh nuyn poeybayginga nabepa alay. Na kedha zoenguz buwaylthoeyay aymoeydhin kedha, nadh yoepkaziw maykaw rugan thudhaydhin, na wara rugan ubamoedhin parupa gamupa woerdhaypa, kalanu na Timnaw yabugudoenu pasinu thanuraydhin, goegathoepa amadhan, goegath Enaym nadh nanu ira ugadhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yudha nanga nan imadhin nanga, nanu paru a gamu mura woerdhayzinga, nubepa Yudhalpa kedha, wa ina yabugudaw yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nubepa gumi kedha na waza nungu ira nuy nabepa ubilmaypa muliz aymaypa. Na, nubepa kedha muliz, kuniya, ‘Ngidh kay ngayapa modhabiya za miyay maypa?’ ");
INSERT INTO mwp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Nuy kedha, ‘Ngath ngibepa kazi nani boey gethawayane bangal.’ Na kedha, ‘Wa, ngidh kay ngaybiya kow aw? Za wanar kaykedh, nginungu zangu yakanurayle.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Nuy yapupoeybiz kedha, ‘Ngath kay ngibiya mi maku wanaypa?’ Na kedha, ‘Wa, ngi kay ngayapa senaw nginu boegi kow a wara za nginu nelaynga a nanu urikam wanar kayke, nginungu naningu yakanurayle.’ Wa, nuydh kalanu si nabiya mamoemoeman. Kalanu palay ubilnga aymoedhin, kalanu na nungu mapunga aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Na Thamar lagoepa kuniya miyaydhin nanu lagoepa. Na sethabi gamu paru woerdhayzi rugan thudhaydhin kalanu nanu yoepkaz maykaw rugan ubamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kalanu Yudha wayadhin nungu igilayg Yira. Nuy kedha, ‘Yira, ngidh nani kedha mar nabepa, sena yoepkaz nga nanga yabugudoenu pasinu nipa, a sepal ngaw za ngapa kuniya kaykedh mamoemoene.’ Kasa kay kedha Yira nuy si mangaydhin nanga, nuydh nan yan lumar, imayginga. ");
INSERT INTO mwp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nuy mabaygoepa yapupoeybiz kedha, goegathaw nel Enaym, ‘Ina nanga yabugudaw yoepkaz naki woelmayngu, na ngalaga, koezi?’ Thana kuniya kedha mulemin, sethabi mabaygal kedha, ‘Ina ngaru kedha, kulay goeyginu yabugudaw yoepkazoeginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nuy Yira kuniya tidaydhin nanga nuy Yudhalpa mulaydhin kedha, ‘Ngath nan imayginga, mabaygan ngaya sethabi lagoenu kedha muliz kedha, “Ina ngaru kedha, kulay goeyginu kedha ngoedhal, yoepkazoeginga!” ’ ");
INSERT INTO mwp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yudha nubepa kedha muliz, ‘Aw, kasa wanaw, na waza sepalbi za nabiya niyamoeypu, ngoeban ubigig mabaygoengu ngoebalngu giwn maythayle. Ngay mina yan nuthayngu nabepa nani pa maypa, kasa kay kedha, ngidh nan ngaru gasamoeyginga, imayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Sizi powpa thoeri moelpalaw kaliya nanga, mabaygan Yudha ngulayg paladhin kedha, ‘Nginu kaziw ipi, Thamar, na mina yababir buwayl thayamar, na ngoedhe yabugudaw yoepkaz nge, na kayib mapunga.’ Kalanu Yudha ya guythuyadhin kedha, ‘Adhapa kay sena mariw, muypu kay nathaw umapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wa, thana nanga nan gasamoedhin adhapa madhin nanga, nadh yangukudu gethawayadhin nanu iralpa, Yudhalpa kedha, ‘Ngay mapunga, itha ngunu zapul nanga, ngaybiya niyaypa imay, nelaynga za a boegi, itha ngaybiya niyaypa. Ngunu za ipal, imay itha?’ ");
INSERT INTO mwp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yudha nanga sethabi za imamoeydhin nanga, nelaynga za a nanu urikam a boegi, nuydh thana ngurapiz kedha nungu zapul, nuy kedha mulaydhin, ‘Sena na balbayginga, na balbaygi doegamoenu, ngaw gegeyadh; ngath ney ngaw kazi Sela nabepa madhin garwoeydhamoeypa ney, wa balbayginga ney.’ Wa Yudha kalanu lak nungu ubilnga nabiya aymayginga. ");
INSERT INTO mwp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wa, thonar na gasamadhin, nanu kazimay thonar nanga, thana imadhin kedha, ‘a ipal nanu koetha kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na nanu kaziw kikirin na pungar nanga nuydh wara kazi geth adhathayan. Nadh kaziw gasamay yoepkazin iman. Nadh na imadhin nanga nadh kulka gamul thoewman yatharadhin. Na kedha mulaydhin kedha, ‘Wa, in kuykuy kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kasa kedha, sena ngunu geth na kulay adhapadhadhin nanga nuydh nungu geth muy thayadhin nanga nungu tukuyap kasa nungungu paypa miyaydhin kulay danadhaypa. Na kedha, kazi gasamay yoepkaz, ‘a, a ngi kasa nginungu paypa ngapa kulay adhapadhaypa.’ Kalanu nadh nuyn kedha tharadhin, Perez. ");
INSERT INTO mwp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","*Kalanu nungu tukuyap ngapa, kulka gamul mukubilnga kazi adhapadhadhin. Nadh nanga nuyn imadhin nadh nuyn kedha tharadhin kedha, ‘Nginu nel Zera.’ ");
INSERT INTO mwp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ngalpa lak Yoewsepan ya kuykayimpa, sey Aykupithunu. Wa, nungu tukuypan nuyn yoewdhadhin thanamulpa Ismeylgoepa. Kalanu thana Ismoeylalgal nuyn sizi yoewdhadhin Aykupithu mabaygoepa, mabayg nel Pothipa. Wa nuy Pothipa nanga Aykupithu mopakuyku mabaygaw getha doegam zagethaw mabayg kobegadh wati mabaygoengu mangayle. ");
INSERT INTO mwp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Wa Awgadh ngaru Yoewsepaniya kalmel a nuydh kapu igililnga gasampu nungu kuyku mabaygaw lagoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nuy kuyku mabayg, Pothipa imadhin kedha, Yoewsepan igililnga koey woenabalnga, kuyk Awgadhan nuyn koeyma kaludhoepu. ");
INSERT INTO mwp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nuy Pothipa kedha miyaydhin, ‘A wa, in nuy kapu mabayg, ngath nuyn ngayapa getha doegam zagethaw mabayg ayimpa.’ Nuydh nuyn kuyku mabayg aymoedhin mura nungu wara zagethaw mabaygiya, muynu nungu niyay lagoenu. ");
INSERT INTO mwp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sizi pawpa Awgadhan Pothipan niyay lag a dharbaw lagal mina ngoedhalnga mura danal pathepu. Minguz kedha, Yoewsepa nuy waza Awgadhaw mina getha doegam mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kalanu Pothipa, nuydh mura zapul poeybaydhin Yoewsepalpa nuy nungu geth ngoenanumayginga, nuydh Yoewsepalpa wanaydhin mura lagaw doegam zageth. Nuydh Pothipa matha wakay thoemamipu nungu maythaw doegampa. Nuy Yoewsepa waza kapu garkaz a magawpa ruway, ");
INSERT INTO mwp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","a nungu Pothipan ipi nadh imadhin nuyn. Sizi pawpa kasa thawpaynga kedha, na mulaydhin nubepa nabiya uthuypa. ");
INSERT INTO mwp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kasa kay kedha nuy ubigasidhin. Nuy nabepa kedha mulaydhin kedha, ‘Itha mura thabi niyay lagoenu mura zapul nanga, nuydh ngoena danal poethaypa wanadhin. ");
INSERT INTO mwp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Matha nuydh ngin ngayapa danal poethaypa mayginga, kedha zoenguz kedha ngi nungu ipi. Nginu alayn ngayapa mina kapu zageth madhin mura zapul nuydh ngayapa matha ngoedhagidh aymaydhin, ngath kay midh paru wati pawa aympa nubepa nungu gururidhiya kaliya kay ngay uzaripa, gegeyadh. Awgadhoepa koey gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Yoewsepa nabepa mina yadu yan umay, nadh kay kedha mura goeyginu nuyn nuthaypu. ");
INSERT INTO mwp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nadh nuyn kedha nuthaypu a kurusipa wara goeyginu nanga nuy Yoewsepa ngapa muya uthaydhin nanga zagethoepa lagiya nanga. Senabi thonara nanga wara zagethaw mabaygoegina lagoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kayka na lagoenu muynu palay palamun kusayg, na nubepa muliz, Pothipan ipi, ‘Aya, ngaybiya uthuy yoewnar.’ Kasa kay kedha nuy Yoewsepa ngaru ubigig. Nadh nungu koey sodh gasamoedhin a nuyn koeyma yoewdhaydhin nanu ubipa. Nuy adhapa zoelmaypa miyaydhin, nadh gasamadhin nungu koey sodh. Nuy ngaru adhapa mer, nuy kasa nungu koey sodhoengu adhapa miyaydhin, kalanu adhapa zoelmaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Nadh na imadhin kedha, nungu koey sodh waza nanu gethanu muynu nanga, ");
INSERT INTO mwp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nadh mamu nuyn ya tharnge thayadhin sew zagethaw mabaygoepa. Na kedha, ‘Ayawal, imaw ina ngalpan nanga Eberaw zagethaw mabayg gasamoedhin nanga, nuy ngapa ngoezu uthuy lagiya muya uthema ngoena rugaw thudhaypa manu. ");
INSERT INTO mwp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kedha nanga ngay arpugema nanga, nuy zilayma adhapa sizi, ngoezu uthuy lagoengu. Ayawal ina imaw nungu koey sodh ina.’ ");
INSERT INTO mwp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nadh nungu koey sodh kasa gasamoedhin nabiya, nanu uthuy lagoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kurusipa nanu alay kuniya tidaydhin. Na nubepa kedha, nanu alaypa, ‘Ngi senaw, ngidh senawbi mabayg ngapa gasamoedhin, zagethaw mabayg. Nuy ngoezu uthuy lagoenu muynu arayngu, ngoena rugan thudhaypa madha. ");
INSERT INTO mwp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kedha na ngay arpugema mabaygoepa nanga, nuy adhapadhadhin. Ina ngaybiya nungu koey sodh ina muynu wanadhin akan.’ ");
INSERT INTO mwp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wa, Yoewsepan kuyku mabaygaw ngurum mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nuydh, kalanu Yoewsepan zeylanu thayadhin mura mopakuyku mabaygaw kunumayzi mabaygal mi zeylanu nanga muynu. Nuy sin thayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kasa kay kedha senaw muynu nanga Awgadh ngaru Yoewsepaniya kalmel, a nungu mam yakamaydhin kedha. Thanamun danal poethay mabayg nuydh imadhin kedha, Yoewsepa mina mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Nuydh kalanu Yoewsepan kuyku mabayg aymoedhin sepa wara yatharayzi mabaygoepa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yoewsepan kuyku mabayg nuydh wara ngoenakap mapu gasamoeyginga zapul muynu midh. Nubepa kakal kedha, zapul bangal mura balbayginga. Awgadh waza Yoewsepaniya kalmel mura thonara a nungu Yoewsepan mura zagethal ngaru koey woenabalmayl. ");
INSERT INTO mwp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nuy za kedha kuniya aymaydhin, thana Aykupithulgan thanamun mopakuyk kedha thoeraypu, Pero. War thonara palay ukasar Peron zagithaw mabayg; wara umal ngukiw aymay danal poethay mabayg, a wara kunaw nuday kuyku zagithaw mabayg, palay zeyloenu thayamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Minguz kedha, Pero mina gegeyadh gasamoedhin palamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Nuydh palay kunumay lagoenu thayamoedhin muynu, Yoewsepaniya kalmel ngalaga nanga thayadhin. Senabi kunumay lag Peron getha doegam zagethaw mabaygaw lagoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Palay mina kay kuykuthalnga kunumay lagoenu muynu, nuydh sew danal poethay kuyku mabaygan Yoewsepan palamulpa zagithaw mabayg madhin. ");
INSERT INTO mwp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","War kubilu palay kunumay lagoenu muynu pikin thayamar umal ngukiw aymay danal poethay mabayg a kunaw nuday kuyku zagethaw mabayg palamun pikiw aykap muynu yaynanob. ");
INSERT INTO mwp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nuy nanga Yoewsepa war bathaynga ngapa palamulpa woelmay nuydh palay imamoedhin kedha palay ngoedhe ngoenakap kikirilayg nge. ");
INSERT INTO mwp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nuy Yoewsepa yapupoeybiz palamulpa kedha, ‘Ngipel minguz kedha nagempa za gegeyadh a?’ ");
INSERT INTO mwp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Palay nubepa kedha muleman, ‘Ngalbe pikin thayoeman kasa kay mabaygoeginga ngalbelpa pikipa sakar pudhaypa kedha, aykap muynu midh?’ Nuy Yoewsepa kedha muliz, ‘Matha Awgadh kedha woenabalnga bibiripa poeybaypa mabaygoepa pikiya dhadh poelamoeypa; umamoeriw ngipen piki ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wa, kulay umal ngukiw zagithaw danal poethay mabaygan uman nungu piki. Nuy kedha, ‘Ngath pikin ngaybiya iman goereypaw kuyk ");
INSERT INTO mwp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","thoeri thamalnga kedha nanga nisal noeridhoemoeyn poelawal kay gud palemin a goereypal giyasimoeyn. ");
INSERT INTO mwp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ngaybiya minguz Peron kap; kalanu ngath thana goereypal sasimoeyn kapanu muynu kalanu ngath Perolpa madhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yoewsepa kedha, ‘Sena nginu pikiw aykap muynu kedha. Thoeri thamal nanga setha Thoeri goeygil kedha. ");
INSERT INTO mwp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Thoeri goeygoey kaliya Pero bangal ngin kunumay lagoenu adhapa manine a ngibepa bangal mura pawayane nginu gegeyadh a lak bangal ngin kuniya nginu zagethoenu wananu. Ngidh bangal nubepa nungu kap manine kulay midh nanga, ngi na nungu umal ngukiw zagethaw danal poethay mabayg meparu. ");
INSERT INTO mwp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","‘Kasa ngay gar ngibiya yoewdhiz ngoena bangal ngoenanu mayparu ngibepa nanga zapul balbayginga, a yakanurayg ngaw nelpa thoeraypa Perolpa ngoena bangal ibupuydhane koezi kunumay lagoengu adhapoedhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mina kay kedha, thana kasa magan ngoena gasamadhin ngapa ngaw goegathoengu nel Eberu, a kalanu ina ngath za wara gegeyadh aymayginga. Thana kasa magan ngoena wati kunumay loegoenu thoeyadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nuydh na kunaw nuday kuyku zagethaw mabaygan imadhin kedha. A ina nungu umal ngukiw mabaygaw piki mina balbayginga. Nuy Yoewsepalpa mulaydhin kedha, ‘Ngoena lak pikin thayarngu; ngaybiya thoeri mura kunaw leday kuykunu memayipa. ");
INSERT INTO mwp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mina gimaw leday nanga mura giyaw aydel zapul Perolpa, kasa uruyn thana purthamoeynguz.’ ");
INSERT INTO mwp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yoewsepa nubepa dhadh poelamoeyn nungu piki kedha, ‘Sew aykap kedha thoeri leday nanga setha thoeri goeygil. ");
INSERT INTO mwp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Thoeri goeygiw kaliya Pero bangal ngin adhapa manine kunumay lagoengu a ngin bangal kuyk pathane, kalanu bangal nginu gamu puynu gimal puydhane uruypa idhaypa nginu gamupa.’ ");
INSERT INTO mwp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wa, balbayginga thoeri goeygiw koeliya Peron, kazimoeyzi thonar nanga gasamoedhin, nuydh mura nungu zagethaw mabaygal thuraydhin koey aygudoepa a nuydh sepalbi ukasar zagithaw mabayg parunu tharimoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Umal ngukiw zagethaw mabayg nuydh nungu kulay zagethoepa kuniya wayadhin. ");
INSERT INTO mwp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Wara nanga nuydh, puynu gimanoeka pudhadhin. Kedha mina Yoewsepa midh nanga umay. ");
INSERT INTO mwp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ina na nuy umal ngukiw zagethaw danal poethay mabayg nuydh wara Yoewsepan ya ngoenanumayginga. ");
INSERT INTO mwp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sizi pawpa, ukasar wathaw koeliya nanga nuy Aykupithu mopa kuyk, Peron pikin thayar. Nuy pikin Naylaw Koesa pasinu sir. ");
INSERT INTO mwp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nuydh yawayay seben kawal mina koey goeraymayl. Thana nanga ngapa koesangu kadaypa tadir thana urapumayn bup purthar. ");
INSERT INTO mwp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wagel mamunge a war seben kawal ngapa kadaypa; thana mina koey moerimoeril. Thana ngapa kadaypa nanga thana kasa war kawaya koesaw pasinu sir. ");
INSERT INTO mwp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","A setha nanga moerimar kawal thana koey goeray kaw purthar. Nuy Pero nubi thonara danpaliz. ");
INSERT INTO mwp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nuy kalanu lak uthuy yoewnan. Nuyn mamu ngedh war pikin thayar kedha, seben mura puy kunal giyamayl urapu kuykungu koesimoeyr kadaypa. ");
INSERT INTO mwp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A dhuray seben puy kunal kadaypa memayidhin moegi ridhal kasa komal guban thana magawg palimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","A moerimar puy kunan nanga koey goeray puy kunal angemidhin. Nuy Pero dan palaydhin a kedha miyaydhin, ‘A in ngoena kasa pikin thoeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bathaynga nanga nungu ngoenakap mina koey mapunga, nuydh ya madhin mura mina koey ngulayg mabaygoepa a guguwaw mabaygoepa Aykupithunu. Nuydh thanamulpa nungu piki umadhin kasa thana nubepa yan sakar pudhadhin nungu piki. ");
INSERT INTO mwp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kalanu umal ngukiw zagithaw danal poethay mabayg nubepa Perolpa kedha muliz ‘Ngay ngibepa mulepa ngaw gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ngi waza ngalbeniya wati igalayg aymaydhin a ngidh ngalbe kunumay lagoenu muynu thayamoedhin, nginu getha doegam zagethaw mabaygaw kunumay lag, kunaw nuday kuyku mabayg a ngay. ");
INSERT INTO mwp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","‘Urapun kubilu ngalbe pikin thayamar yaynanob a palay piki ngalben nanga muynu aykap urapun lawnga, aykap yaynanob. ");
INSERT INTO mwp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Senabi thonara nanga urapun kayn garkaz Ebrulayg. Nuy danal poethay kuyku mabaygaw zagethaw mabayg si muynu kunumay lagoenu. Ngalbe nalben piki umamoedhin a nuydh ngalbelpa sakar mamamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Zapul mina kedha balbayginga aymoeydhin; ngidh ngoena ngaw zagethoenu kuniya wanadhin a kunaw nuday kuyku mabayg ngidh puynu gimal puydhadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kalanu Pero ya madhin Yoewsepalpa, nuyn kunumay lagoengu sinubi thonara adhapa madhin. Nuydh Yoewsepa nanga buthapoethay muwasidhin yathapathay a kayn rugal ubamiz. Nuy kalanu Perolpa uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Nuy Pero Yoewsepalpa kedha muliz, ‘Ngoena pikin thayar kasa kedha mabaygan sakar mayginga ngayapa ngaw piki. Ngath kedha karngemingu ngidh ngulayg piki sakar manin.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yoewsepa kedha muliz nubepa Perolpa, ‘Ngayapa koey zageth, matha Awgadhaw ibupuydhaynu kedha, ngath kay balbayginga sakar maypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nuy Pero kedha, ‘Ngoena pikin thayarngu, ngay Naylaw Koesaw bawadhoenu kaday sirngu. ");
INSERT INTO mwp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ngath yawayay seben kawal koey goeraymayl thana koesangu ngapa kadaypa tadir urapumayn, bup purthar. ");
INSERT INTO mwp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","‘Kalanu seben kawal ngapa kadaypa mina koey gudal moerimoeril. Ngath kulay ngaw igililmaynu kedha ngoedhalmayl imayginga itha Aykupithunu. ");
INSERT INTO mwp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Thana koey moerimar kawan koey goeray kawal purthamoeyr. ");
INSERT INTO mwp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kasa kay kedha maythal yoewruyginga thana kasa ngaru wati ngoedhalmayl, kulay thana midh nanga. Kalanu ngay danpalaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","‘Ngay lak uthuy yoewnan. Ngoena nanga lak pikin thayar, ngath yawayay seben mura koey goeray puy kunal giyamayl urapu puy kunaw kuykungu kadaypa sazir. ");
INSERT INTO mwp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Dhuray seben puy kunal nanga kadaypa malguyl puydhadhin komal guban thana goegadh ngur palngimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","A moerimar puy kunan koey goeray puy kunal angemidhin. Wa, kalanu ngath palay piki umamoedhin guguwaw mabaygoepa kasa kedha thana ngayapa sakar mayginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yoewsepa Perolpa kedha mulaydhin, ‘Sepal piki nginu nanga muynu aykap urapun; Awgadh ngibepa mulayngu kedha nuydh bangal miyay nanga za aymoene. ");
INSERT INTO mwp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Setha seben koey goeray kawal nanga seben ayde wathal, a seben mina puy kunal nanga lak seben ayde wathal muynu aykap urapun. ");
INSERT INTO mwp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","‘A matha kedha dhuray seben moerimar kawal kadaypa wagel nanga tadir a setha moerimar puy kunal komal guban goegadh palayzimayl, sew aykap kedha, seben bangal mura aygi wathal. ");
INSERT INTO mwp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Zapul bangal mina kedha, mina in ngay ngibepa umepa Awgadhan ngibepa yakamoengu, nuydh bangal ngibepa miyay nanga za aymoene. ");
INSERT INTO mwp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Seben wathoelnga ay za bangal mina koey goersar Aykupithunu, mura nanu goegathiya. ");
INSERT INTO mwp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kalanu bangal mamungedh a seben mura aygi wathal mina ipidhadh gegeyadh. Ngoedhe kedha nge Aykupithu kulay kedha wathoeginga, aygi wathal bangal lag mina idimoene. ");
INSERT INTO mwp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Senaw bangal mina thonar mura guythuyane, minguz kedha, aygi wathal bangal ipidhadh gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sepa, nginu pikipa kedha Awgadhan ukasar thonaralnga ngibepa yakamoedhin, nubepa Awgadhoepa kasa woenaypa lawnga, nuydh bangal ngaru senawbi za aymoeyne. A senabi thonar amadhan. ");
INSERT INTO mwp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","‘Ngidh kedha thonara mina mabayg adhapa thamar, a koey ngulayg mabayg koepa goegathoepa danal poethaypa mura Aykupithunu. ");
INSERT INTO mwp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","A ngidh bangal ngaru dhuray zagithaw mabaygal adhapa thamayine moegina aypa ngoewmaypa mura goegathoengu, koey ayde wathaw thonara setha bangal seben wathal mina wathal toedipu nanga. ");
INSERT INTO mwp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","36","Ngi bangal thanamulpa muledhe a ngidh bangal kupay thanamulpa manine aypa adhapamoeypa a danal poethaypa senabi mina wathaw thonara, mura goegathaw koey sawalagal. Setha bangal ayde danal pathepu seben aygi wathaw thonarpa, senawbi thonar kay nanga mangepa mina adhapudhay gegeyadh lak bangal mabaygoepa mura maytha aygipa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pero a nungu zagithaw mabaygal thana zeyzinoeydhaydhin kedha, ‘Wa, ina mina yangu kudu urapun aymoeyzinga.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nuy Pero thanamulpa kedha, ‘Ngalpalpa lak wara mabaygoepa imaypa lawnga kedha Yoewsepa midh nanga. Awgadhaw Maygi Mari ngabiya nanga kalmel muynu.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nuy Pero nubepa Yoewsepalpa kedha mulaydhin, ‘Awgadhan thabi zapul mura ngibepa yakamoeydhin wara lak yaginga senaw ngi balbaygi mabayg koey ngulayg wara lak kedha ngoedhal mabaygoeginga. ");
INSERT INTO mwp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ngath kay ngin kuyku mabayg aympa mura ngaw goegathapa danal poethaypa a ngaw mabaygal bangal mura nginu yapa kurusipagemipu. Ngi bangal ngaybiya wagel paru. ");
INSERT INTO mwp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ngath ngin kuyku mabayg ayman Aykupithupa.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kalanu Pero nungu gethaw dhimurngu nelaynga za adhapa madhin, a Yoewsepan gethaw dhimuriya angan kalanu kapu golidh gamul kusa Yoewsepaniya katiya thayan, a kapu sodh nubiya angan. ");
INSERT INTO mwp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nuydh Pero nubepa Yoewsepalpa sigangar madhin, yawaraw za nungu danal poethay zagithaw mabaygal kulay wal tidhumar kedha, ‘Nubepa buth wanaw, nubepa buth wanaw’ minguz kedha, nuyn Yoewsepan waza kuyku mabayg aymoedhin Aykupithupa, Peron wagel paru. ");
INSERT INTO mwp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pero nubepa Yoewsepalpa kedha mulaydhin, ‘Ngay koew Aykupithu mopa kuyk wara mabaygoepa ngibiya gimiya woelaypa lawnga, matha ngi kedha.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Nuydh Pero nubepa Yoewsepalpa wara sew Aykupithu nel madhin kedha, Zapenath Paneya, a wara nuydh ipi madhin Yoewsepalpa, nanu nel Asenath Potheperan yoepkaz kazi. Nuy thanamun misnare, Iliyopolisaw goegathaw misnare. Yoewsepa nanga Perolpa zagithaw kuyk aymoedhin nuy sinubi thonara 30 wathoelayg Aykupithunu. Nuy sizi Peron lagoenu mura gulgupipu Aykupithuya. ");
INSERT INTO mwp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Seben koey ayde wathoenu nanga. ");
INSERT INTO mwp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yoewsepa nuydh mura ayde yaynanob goegathiya ngoew mamaydhin Aykupithungu. Kuyk aymay puy kunaw zagethaw lagoengu. ");
INSERT INTO mwp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Senawbi thonara ay puy kun mina koey gudal goersar. Yoewsepalpa matha ngoedhagidh lawnga getha tidaypa. Ay kedha koey gudal goersar ngoedhe buthul midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Wa, wagel aygi wathaw thonar mangaydhin Yoewsepan ipin Asenath kulay ukasar garkaz kazi mamamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nuy Yoewsepa kedha, ‘Awgadhan ngaw ngoenakap thoew palangu mura ngaw wati thonarngu a ngaw mura thathiw buwayngu.’ Kalanu nuydh nungu kuykuyg kazi kedha nel tharadhin, Manesey. ");
INSERT INTO mwp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Wara nuy Yoewsepa kedha mulaydhin ‘Awgadhan ngayapa kazi mamamoengu ngaw sirisirizi lagoenu.’ Wa nuydh nungu kuthayg kazi kedha nel tharadhin Epelema. ");
INSERT INTO mwp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Senaw mi seben wathoepa nanga Aykupithu mabaygapa ay saran poegaypu, kuth muwasidhin senawbi kapu thonar amadhan thamaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","A aygi wathaw thonar kuyk aymaydhin balbayginga kedha mina Yoewsepa midh nanga mulaydhin dhuray lagal lak mura aygi asimoeydhin. Kasa Aykupithunu ayde matha niyaypu thanamun koey sawalagoenu. ");
INSERT INTO mwp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Aykupithulgan nanga maytha aygi kuyk aymoedhin, thana Perolpa ay thoeraypu. Nuy Pero thanamulpa kedha, ‘Yoewsepalpa ladhu nuy kay nanga ngithamulpa midh muledhe ngitha, kay matha aymaw.’ ");
INSERT INTO mwp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aygi wath ipidhadh gegeyadh mangaydhin mura doegamuya Aykupithunu. Wa, nuydh Yoewsepa kalanu sawalag gud pudhaydhin a ayde yoewdhamoeydhin Aykupithulgoepa. ");
INSERT INTO mwp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sethabi thonara mabaygal kasa mura Aykupithupa toedipu aypa barpudoeypa mura lagoengu Yoewsepalngu. Minguz kedha, senawbi thonara nanga gasamoedhin mina koey ipidhadh gegeyadh mura doegamuya. ");
INSERT INTO mwp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakubu nuydh nanga gasamoedhin kedha Aykupithunu puy kunalnga, nuy mulaydhin nungu garkaz kazipa kedha, ‘Ngitha za aymayg a? ");
INSERT INTO mwp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ngath kedha karngemingu, Aykupithu puy kunalnga; ngitha ladhu ngalpalpa puy kunal ngapa barpudhamoey ngalpalngu maytha aygingu a umangu.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wa, Yoewsepan 10 mura tukuypal ladhudhin Aykupithupa puy kunoepa barpudhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kasa Benzoemanan Yoewsepan kuthayg thanamuniya kalmel woeyayginga, zangu yabugudanu dhadha moengayle Benzoemananiya. ");
INSERT INTO mwp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Thana Yakubun garkaz koezil mabaygiya kalmel puzimoeyr puy kunoepa barpudhaypa kedha zoenguz Kanana lak aygi asidhin. ");
INSERT INTO mwp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nuy Yoewsepa kuykulnga waza, nuydh puy kunal yoewdamoeyr Aykupithunu mura goegathaw mabaygoepa thana nanga Yoewsepan tukuypal mamu nubiya parunu kuykul pathidhamoey boeradharoepa. ");
INSERT INTO mwp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nuydh Yoewsepa thana ngurpamoeydhin nungu tukuypal, kasa kedha nuy kedha mer, nuy thanamulngu koerawayg nuy matha, wamenalnga thanamulpa yapupoeybaydhin kedha, ‘Ngitha ngalagaz ngapa?’ Thana nubepa kedha mulemidhin, ‘Ngoey Kananangu ngapa aypa barpudhaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nuydh Yoewsepa thana ngurpamoeydhin, kasa kedha thana nungu tukuypan nuyn Yoewsepan kay ngurpayginga. ");
INSERT INTO mwp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Senawbi thonara Yoewsepa nungu kulkubaw piki ngoenanumadhin nuyn nanga pikin thayar thanamun. Nuy kedha thanamulpa, ‘Ngitha kasa dana oengaypa ngapa kedha, ngoey midh balbayginga ngithamulpa koewbupa.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Thana kedha, ‘Lawnga ngoey kasa ngoedhe nginu zagethaw mabaygal, aypa barpudhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ngalpa mura tukuyap kazil. Ngoey ngapa lawnga dan angayl. Mina ngoey balbaygi mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nuy thanamulpa kuniya mulaydhin kedha, ‘A! Lawnga lawnga setha ngitha kasa dana angayl ngapa kedha zapa thana midh ngoey balbayginga ngithamulpa koewbupa.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Thana kedha, ‘Ngoey matha toewalob mura urapu thathiw koezil Kananalgal, wara tukuyap ngoeymun umanga a kuthayg ngoeymun thathiya yawayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nuy thanamulpa kedha muliz Yoewsepa, ‘A, a, lawnga, ngaw kulay yangukudu kasa balbayginga kedha, ngithamun sole. Ngitha kasa dan oengayl toedipa. Mabaygal ngitha kedha zapa ngapa wayamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ngath bangal ngaru nubi za kuyk sulane bangal. Ngay ngithamulpa mina yadu umepa Peron parunu, kedha karngemiw a? Ngitha matha kow kurusipa bangal ngithamun koewba kuthayg ngapa in mangedhe. ");
INSERT INTO mwp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","‘Ngithamulngu kay ngaru kuniya urapun mabayg uzaripa, sena kay koewba kuthayg ngapa yoelpaypa, imaypa kedha ngitha midh, ngitha mina ya umamoeypa. Wa, urapun ngithamulngu nanga Kananapa kuniya kuthaygoepa, a ngitha ngaya wanayzi mabaygal nanga ngitha bangal kunumay lagoenu muynu, kurusipa bangal ngalpa imane kedha, nuy nga mina. Ngay mina Peron parunu, setha ngitha dan oengayl ngayapa ngapa wayaydhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kalanu nuydh thana thoeri goeygipa kunumay lagoenu muynu arimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Thoeri goeygiw kaliya nanga nuy Yoewsepa thanamulpa kedha, ‘Awgadh, mina Awgadh ngath mina yapathamadhin, ngath bangal ngithamulpa, urapun doegam ibupudhay aymoene. Ngay mina wadhe thulu mabayg, ngitha nanga ngaw ubilnga ayman nanga ngitha lak igililmayl. ");
INSERT INTO mwp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Urapun ngithamulngu bangal ngaru in muynu, kunumay lagoenu, ngitha ngalaga nanga muynu memayirngu. Setha ngitha ngaya wanayzimayl nanga, ngitha bangal kuniya tidemine lagoepa, setha ayngu baykal kusumoene ngithamulpa, setha ngaya mabaygal sey maythaygin memayipa Kanananu.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nuy Yoewsepa thanamulpa kedha mulaydhin kedha, ‘Wa, mina yapathoemaypa, ngitha bangal ngaru ngithamun kuthayg ngapa manine bangal. Ngitha bangal ngayapa manine. Wa, ngayapa ngithamulpa umamathamaypa lawnga.’ Wa, thana asimoeydhin, sethabi yangukudu ya. ");
INSERT INTO mwp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Thana kidhakidhan kedha mulemidhin, ‘Ey, ina sike ngalpa ngalpan kuykungu, nabi wati thonar gasampa. Itha ngalpa thabi wati thonara muynu memayipa. Ngalpa sethabi thonara ngalpan kawral gud poelayginga ngalpan tukuypoepa koerngaypa. Ngalpa mina koerngaygi kawral aymoeydhin. Kedha zoenguz ngalpa kayib kedha, thabi sirisirinu muynu. Nuy na ngalpalpa ibupuydhaypa na umay nanga ngalpa aymayginga. Ngalpa kedha zoengu thabi sirisirinu muynu kayib.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nuy Rewben kedha mulaydhin ‘Ngitha wakay thoemamay, senabi goeygipa? Senabi thonara nanga ngay kedha mulaydhin, nuyn mathamayg. Ngitha nay ngayapa karngemidhin nay, wa mura zapul balbayginga nay. A itha kayib kedha nanga, ina ngalpa ngalpan modhabiya gasampa, nungu kuthaw modhabiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nuy Yoewsepa ngulayg, kedha, thana midh nanga Yoewdhayalgadh umamoeyr, kasa kay kedha thana tukuypal koerawaygal kedha, nuy ngulayg mabayg. Nuydh kasa nungu wara zagethaw mabayg gud aymar thanamulpa yapa. A senawbi gud aymay mabayg nuydh thanamun Yoewdhayalgaw yangukudul nubepa sakariya thayamoeyr. Nuy Yoewsepa waza thanamulpa mina Aykupithu mabayg. ");
INSERT INTO mwp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Nuy Yoewsepa si moegina sig thamaydhin nungu tukuypoengu, a nuy si mayoersir nungu tukuypoepa koerkak badhan. Wa, nuydh nanga Yoewsepa nan koerkak badh muwasidhin nanga, nuy ngapa kuniya thanamulpa tukuypoepa. Nuydh nuyn Simiyonan sizi thanamulngu adhapa bag thayadhin. Kalanu zagethaw mabaygal urukamin aymoedhin Simiyonan, thanamuniya tukuypiya parunu. ");
INSERT INTO mwp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kalanu Yoewsepa nungu zagethaw mabaygoepa muliz kedha, ‘Ngitha thanamun mabaygaw yanal mura aydu malimoey a thanamun bokadhzapul kay, thanamun yanaya kay kedha arimoey, a ayde kay thanamulpa mamayi, giya ayde, yabugudiya dhadhiya aygudoepa.’ Wa, thana zagethaw mabaygan mina mura kedha aymoedhin, Yoewsepa thanamulpa midh na mulaydhin aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Thana Yoewsepan tukuypan kalanu thanamun donkiya rugal aydemayl gimal wanaydhin a kalanu thana mab kuykaymoedhin kuniya lagoepa Kananapa. ");
INSERT INTO mwp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Thana nanga mi doegamoenu uthuy ukamoedhin nanga, urapun mabaygan thanamulngu nungu rugan a yana gud pudhan pathu na donkipa aydu poeybaypa. Muynu nuydh wara bokadhza iman, nungu yananu gimanoeka aral. ");
INSERT INTO mwp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nuy kedha mulaydhin, ‘A, a, thana ngaw bokadhza ngayapa kuniya manu. Ina ngaw yananu muynu oeraypa.’ Thana mura tukuypal mina gegeyadh gasamoedhin. Thanamun aka mina koeyza. Thana kidhakidhan kedha mulemidhin kedha, ‘Ina Awgadhan ngalpalpa za miyay ayimpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wa, thana na mangemidhin Kanananu nanga, thana thathipa Yakubulpa mulemidhin, mura nuyn yadu thuradhin, thanamulpa Aykupithunu zapul midh na paru aymoeydhin nanga. ");
INSERT INTO mwp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Thana kedha thanamun thathipa, ‘Nuy sew kuyku mabayg, nuy ngoeymulpa mina koey dharadh ya mulema. Nuy kedha, “Ngitha ngoelkay ya umamoeypa, ngitha dan oengayl mabaygal ngapa koepa thabi lagoepa, thana ngoey midh balbayginga ngithamulpa puzalmoeypa.” ");
INSERT INTO mwp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ngoey kay nubepa kedha mulemin, “Lawnga, ngoey dan oengaypa lawnga ngapa wayadhin, ngoey balbayginga, ngoey wadhe thulu mabaygal ngoey ngibepa mina ya umamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ngoey matha mura toewalob urapun thathingu, ngoeymun wara tukuyap mulupa, a koewba kuthayg ngoeymun thathiya yawayg, Kanananu.” ");
INSERT INTO mwp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","‘Kasa kay kedha nuy kuyku mabayg thanamun, nuy ngoeymulpa kedha mulaydhin kedha, “Ngath bangal ngaru nubi za kuyk sulane bangal, urapun ngithamulngu bangal ngaru in. Setha ngitha ngaya wanayzimayl nanga, ngitha bangal kuniya tidemine lagoepa a setha aydel bangal kusumoene ngithamun maythaygi mabaygoepa. Wa, ngitha paypa ladhu, ");
INSERT INTO mwp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ngithamun kuythaygoepa ngapa ngayapa manine. Nuy na ngapa nanga, wa ngayapa kakal aymiz kedha ngitha wadhe thulu mabaygal. Kalanu ngath ngithamulpa pawayane ngithamun yatharayzi tukuyap, a ngitha bangal itha memayipu ayde zapul bangal sakariya idimpu.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wa, thana na setha mabazi mabaygal thanamun yanal mura tigal lupamoeydhin nanga, thana mura bokadhzapul imaydhin thanamun yananu muynu. Thana kedha mulemidhin, ‘E! Itha setha bokadhzapul, ngalpa mi bokadhzapul nanga kunal barpudhamoeyn. Itha kasa lak ngalpalpa kuniya mamayinu.’ Thana, thanamun thathi Yakubu, thanamun aka mina koey gudal koeyza. Thana kedha umamoeyr, ‘Setha sike Aykupithu mabaygan sethabi bokadhzapul kuniya arimoeyngu ngalpan yananu. Setha sike thana kasa ngalpalpa sirisiripa aymipa nagemipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kalanu thanamun thathi thanamulpa kedha muliz, ‘Ngitha mipa nuthemipa, ngithamun ubi midh kedha, ngithamun ngaw kazil mura guythuyane. Kulay Yoewsepa, wagel Simiyon, a kalanu Benzoeman midh. Ngath midh paru nuyn ngithamulpa maypa. Matha ngath bangal ngoenakap kikir gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kalanu Rewben nungu thathipa kedha mulaydhin kedha, ‘Sena ngidh Benzoeman ngapa ngayapa mar. Ngath bangal nuyn danal poethaypu koezi kedha a kedha ngapa. Kurusipa bangal ngath nuyn ngibepa kuniya manine. Ngay bangal nanga gegeyadh medhedhe nanga, ngay na sike ngoelkay yadu umepa nanga, wa ngidh bangal ngaw ukasar garkaz kazi mathamoemoene bangal modhabiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kasa kay kedha nungu thathi Yakubu nubepa kedha mulaydhin, ‘Ngayapa ngibepa ngaw kazipa woeyaypa lawnga. Nungu tukuyap umanga, Yoewsepa Reysoelana kazi. Nuy gar matha nuy urapun wanangu kuniya ngayapa. Wara kedha, za dhadha mangiz ngithamuniya yabugudoenu koerkak badhan ngoena kasa uma mathaman.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Wa, senabi aygi wath nanga mina gegeyadh mangaydhin thanamuniya Kanananu. ");
INSERT INTO mwp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Thana na Yakubun ipi kazin na ay mura purthadhin nanga, setha mi ayde barpudamoeyn Aykupithungu, nuy Yakubu thanamulpa nungu kazipa kedha mulaydhin kedha, ‘Ngitha lak ladhu, ngalpalpa moegina aydel barpudamoey ngapa Aykupithungu.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nuy Yudha kedha muliz nungu thathipa, Yakubulpa, ‘Thanamun Aykupithu mabaygaw kuyku mabayg koey dharadh mulaydhin ngoeymulpa, “Ngitha bangal na ngapa kasa matha ngitha ngapa wa, ngayapa ngithamulpa imaypa lawnga.” ");
INSERT INTO mwp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bab ngibepa balbayginga kedha ngoeymun kuthaygoepa ngoeymuniya oesipa, wa, ngoey kay Aykupithupa aypa gasamoeypa soeyzi. ");
INSERT INTO mwp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ngidh bangal nanga ngoeymulpa Benzoemanan mayginga nanga, wa ngoeymulpa mabapa lawnga, kedha zoenguz kedha Aykupithunu ngoeymulpa kuyku mabayg kedha mulaydhin kedha. Nuydh kedha ya wadhadhin kedha, “Ngitha bangal ngapa ngithamun kusaygal mabag. Ngitha bangal ngaru ngithamun tukuyap ngithamuniya kalmel ngapa manine. Aymayginga nanga, ngithamuniya ngaw sawalagiya muy yoewthaypa lawnga.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nuy Yakubu kedha, ‘Ngidh nay nginu kuythaygaw nel nay sey thoerayginga nay Aykupithu kuyku mabaygaw parunu nay, wa mura zapul balbayginga nay, matha ngoedhagidh.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Thana kedha mulemidhin kedha, ‘Lawnga ngoeymulpa koey zageth woerdhaypa. Sena nuy Aykupithu kuyku mabayg nanga, nuy ngoeymulpa kedha yapupoeybay kedha, “Ngithamun thathi matha igililnga a? A ngithamuniya wara tukuyap wagel a?” Nuydh kasa koeyma yapupoeybaydhin.’ Thana nubepa thathipa kedha mulaydhin kedha, ‘Ngoey koerawaygal kedha ngoey kay midh mulemipa. Ngoey koerawaygal kedha nuy kay wagel kedha mulepa, “Ngitha bangal ngaru kuythayg ngapa oengane. Ngithamuniya kalmel.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nuy Yudha kedha muliz thanamun thathipa kuniya kedha, ‘Na ngapa ngayapa mar Benzoemanan, ngoey ladhuypa; ngath bangal nuyn balbayginga danal poethaypu, ngoey bangal ayde barpudamoeyne boey ngalpalpa, ngalpalngu maythaygingu. Sena nginu kazi ngapa wayar ngoeymuniya kalmel aypa barpudaypa. Ngidh kay na nuyn woeyayg nanga, ngoeymulpa bangal aypa barpudaypa lawnga. Sena kuth kedha mizin kedha, ngalpa bangal mura umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nuy Yudha wara kedha mulaydhin thanamun thathipa, ‘Za nanga bangal mangedhe nanga, nginu koewbu kaziya nanga, wa ngaru bangal ngaw kuyk, war tukuypaw lawnga. Ngidh bangal ngoena buthaw waydhaypu bangal. ");
INSERT INTO mwp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ina ngidh kasa mura yadu thonar guythuyanu; ngidh nay kuykuthalnga gasamoeyginga nay, ngoey kedha ukasar thonaralnga nay mab manu koezi sepa a soeyzi ngapa, ayde nay na gasaman ngalpalpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nuy thanamun thathi nubepa Yudhalpa kedha mulaydhin, ‘Ngaw ubiginga Benzoemanan ngithamuniya woeyaypa kasa kay kedha, nuy kay oesipa kay ngithamuniya, a koeyma goeygilnga bangal yabugudiya koezi kedha Aykupithupa, a Aykupithungu ngapa kuniya. Ngitha mina kapu zapul kusumaw ngithamuniya kalmel, Aykupithu kuyku mabaygaw ngoenakapoepa balbayg poelaypa, kapu ganul zapul, a puy susul mithalmayl, a kapu mithal ayde, a aypuykoewsaw ridhal wara. ");
INSERT INTO mwp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ngitha ngaru balbayginga kay mura bokadhzapul kusumaw mina moeypa kedha kulay aypa a thabi thonara aypa modhabiya maypa kay. Minguz kedha, thaki setha bokadhzapul kuniya kusumaw, setha mi bokadhzapul thana Aykupithulgan ngapa kuniya tidemoeydhin gimanoeka ngithamun yananu mura muynu yaynanob. Sena sike thana kedha kasa kedha geth supamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","‘Wa, mariw senaw ngithamun tukuyap ngithamuniya kalmel, paypa bangal, ngapa bangal paypa kuniya.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A nuy thathi thanamulpa lak kedha muliz kedha, ‘Awgadh mina koey woenabal Awgadh, ngalpan. Nuydh kaybanu Aykupithu mabaygaw ngoenakap gabu palane. Na bangal nuydh Benzoeman a ngithamun wara tukuyap sena ngitha ngan kuniya wanadhin kunumay lagoenu muynu, nuydh sike palay pawoeyamoeyne lak kuniya ngapa ngithamuniya kalmel. Ngath na guythuyamoen ngaw kazi nanga, wa ngath guythuyamoen.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wa, thana nungu Yakubun kazin Benzoemanan madhin a mina kapu zapul kusumoedhin, a thanamun bokadhzapul ukasar thonaralnga ukamoedhin. Kalanu thana geth wanemidhin Aykupithupa. Thana na Aykupithunu mangemidhin nanga thana thanamun geth kakal aymoedhin Yoewsepalpa. ");
INSERT INTO mwp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wa, nuydh nanga Yoewsepa imadhin nanga Benzoemanan thanamuniya nanga, nuy kedha mulaydhin nungu getha doegam zagethaw mabaygoepa, lagaw kuyku mabaygoepa kedha, ‘Ngitha mamayi ngaw lagoepa, thana kay ngaybiya ay purthaypa. Ngidh kayke mamuy mathamar koey nabi mamuy mathamar a buth kay pathar nan.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nuydh kalanu nungu Yoewsepan zagethaw mabayg kedha mina ayman Yoewsepa nubepa midh nanga muliz. Nuydh kalanu thana tukuypal yoelpamoeydhin nungu Yoewsepan lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wa, thana nanga Yoewsepan zagethaw mabaygan Yoewsepan lagoepa na memayidhin nanga thanamun tukuypaw aka mina koeyza a thana kedha wakay thoemamiz kedha, ‘Itha ngalpa koepa ngapa na mamayinu nanga, setha bokadhzapul ngalpa ngalpan yananu muynu imaydhin kulay maban. Thana bangal ngalpa yaginga bangal itha mi mamayine doerdhimoeyne. Thana bangal ngalpa zagethaw mabaygal itha aymoeyne bangal ina Aykupithunu a ngalpan donkil lak kedha mamayine.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wa, thana na koezi pamithal asimoeyn lagoepa pasagudoepa nanga, thana nungu Yoewsepan zagethaw kuyku mabaygoepa kedha mulemidhin kedha, ");
INSERT INTO mwp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","‘Ngoey kulay ngapa ladhudhin aypa barpudaypa, ");
INSERT INTO mwp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ngoey ina koezi kuniya nanga ngoey dhadhal uthuy ukamoedhin. Sethabi kubilu nanga ngoey ngoeymun yana na pathumoeydhin nanga, ngoey mura yaynanob bokadhzapunu imaydhin gimanoeka arimoeydhin ngoeymun yananu. Ngoey senabi bokadhza mura kuniya manu ngithamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ngoey ngapa dhuray bokadhzapul kusumoeynu aypa barpudaypa ngoeymulpa. Ngoey koerawaygal kedha, ngoeymun kulay mangay thonara ngadh bokadhzapul ngoeymun yananu muynu arimoeydhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nuy kedha Yoewsepan zagethaw mabayg thanamulpa, ‘Wakay thoemamayg sepa, yakanuray, akan maygi. Ngithamun thathiw Awgadh, a ngithamun Awgadhan sike, senabi bokadhza ngithamun rugaw yananu muynu arangu. Ngath modhabiya gasamadhin.’ A kalanu nuydh Simiyonan ngapa manin thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wa, nuydh na zagethaw mabaygan thana lagoepa mamayidhin nanga, nuydh zapul mura balbayginga thanamulpa buth pathamoeydhin. Nuydh thanamulpa nguki madhin ngaroepa garwalgaypa a nuydh thanamun donkil aydu poeybaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wa si lagoenu muynu nanga thana thanamuniya mi kapu zapul thana kusumoeydhin Aykupithu mabaygaw ngoenakapoepa balbayg poelaypa, Yoewsepan ngoenakapoepa balbayg poelaypa. Thana ngadha palemin, thana kakal waniz. Sena Yoewsepa kuniya tidepa kay nanga thana nubepa kusumpa. Minguz kedha, thana ngulayg palemoeydhin kedha, thana kay nubiya ay purthaypa. ");
INSERT INTO mwp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wa, Yoewsepa na nungu lagoenu mangaydhin nanga, thana sitha sibaw wanay zapul kusumoedhin nungu lagoenu nubepa thana kuykul patidamoeyr nubepa apasin, nubiya parunu. ");
INSERT INTO mwp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yoewsepa thanamulpa yapupoeybiz kedha, ‘Ngitha balbayginga?’ Thana kedha muliz, ‘Wa, ngoey balbayginga.’ Nuy kedha, ‘Ngayapa mulemiw, ngithamun thathiw ya, nuy midh balbayginga, matha igililnga?’ ");
INSERT INTO mwp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Thana kuniya Yoewsepalpa kedha mulemidhin, ‘Nginu zagethaw mabaygaw thathi, ngoeymun thathi matha igililnga, wara kikirigig.’ Thana kulun tharemidhin nubiya parunu apasin nubepa Yoewsepalpa. ");
INSERT INTO mwp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Nuydh nanga Yoewsepa nuyn imadhin nungu tukuyap Benzoemanan nanga, nuy thanamulpa kedha mulaydhin nanga kedha, ‘A in ngithamun mopa kuthayg in. Ngitha yadu marngu, Awgadhaw woenab ngibiya kalmel ngaw kazi.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wa, nuydh Yoewsepa nuyn Benzoemanan imadhin nanga kedha, nungu tukuyap, nungu ngoenakap mina gegeyadh miyaydhin. Nuy kasa tidiz adhapa uzaraydhin thanamulngu, nungu uthuy lagiya muya uthaydhin. Nuy mina gegeyadh koerkak badh gasamoedhin mayoersir sena nungu kasa kedha dhiwaw may. ");
INSERT INTO mwp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","May kalanu nanga nuy Yoewsepa paru garwalgaydhin a ngapa adhapadhadhin. Nuy nungu kedha balbayg asir kedha, a nuy balbaygoesidhin. Kalanu nuy nungu zagethaw mabaygoepa muliz kedha, ‘Ngitha ayde wanay sew.’ ");
INSERT INTO mwp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Thana mura yaynanob aygudaw lagiya ay purthaw. Yoewsepa nuy wara pasinu, a nungu tukuypal urapun mayn wara pasinu, a thana Aykupithu mabaygal wara pasinu. Thana kedha zoenguz kedha aymoedhin kedha, Aykupithu mabaygoepa gegeyadh kedha thanamulpa aygudoepa kalmel niyaypa Eberaw mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Thana Yakubun kazil balbayginga nithamoedhin aygudaw laganu maykuykuya, thana mura Yoewsepaniya parunu kuykuygoengu mulupa kurusipa kuth. Thana na iman kedha thana midh paru aygudapa nir, thana kidhakidhan nagemin kedha, ‘Thana Aykupithu mabaygan midh paru ngulaygal ngalpan maykuykiya midh nanga, ngalpan niyaylagoepa minamaypa kedha?’ Thana madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Wa, thanamulpa Yoewsepan aygudaw lagoengu aydu a nguki kusumoemar, a thana gar koeyma nuyn Benzoemanan aydu poeybar, payb thonaralnga. Kalanu thana mina koeyma ay purthadhin nubiya kalmel a koeyma wanema. ");
INSERT INTO mwp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yoewsepa kedha mulaydhin nungu zagethaw mabaygoepa, ‘Setha thanamun yanal matha koeyma aydu malimoeyr mina mura, a thanamun bokadhzoepul kay mura gimal yaynanob arimoeyr thanamun yanaya. ");
INSERT INTO mwp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Senaw kay ngaw koethil za, silba kap, koewba kuthaygaw yananu gimal arane kalmel nungu puy kunaw bokadhza.’ Wa, nuydh zagethaw mabaygan kedha mina aymoedhin Yoewsepa nubepa midh nanga mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","War boethaynga thana mina inuriya memayidhin thanamun donkil kalmel. ");
INSERT INTO mwp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Thanaka maban sig matha oesiginga Aykupithu goegathoengu, Yoewsepa nungu kuyku zagethaw mabaygapa kedha mulaydhin, ‘Uzar kazayginga thanamulpa wagel ngidh kay nanga thana gasamidhe kedha kay muledhe, “Sena ngitha mingu kedha wati pawa aymoengu, ngoey ngithamulpa nanga ngoey mina pawa aymoengu. ");
INSERT INTO mwp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ngitha minguz ngaw kuyku mabaygaw silba kap purunu wardhangu senaw nungu woeniw kap, a nuydh senaw wara goewgupa angarngu. Ngitha adhapudhay gegeyadh wati pawa aymoengu.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Nuydh nanga zagethaw mabaygan thana gasamoedhin nuy kedha umay thanamulpa, ");
INSERT INTO mwp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yoewsepan yangukudu ya midh nanga. Thana tukuypal nubepa kedha mulemidhin, ‘Ngoey kedha ngoedhal mabaygal lawnga. Ngoey mina ya umamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ngi ngulayg kedha ngoey Kananangu kuniya madhin bokadhza, ngoey nanga imadhin ngoeymun yanangu a ngoey kay midh paru koethil zapul purunu wardhamoeypa nginu kuyku mabaygaw lagoengu. ");
INSERT INTO mwp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ngidh kay nanga ngoeymulngu ngabiya imaypa nuyn bangal umamathamoene a dhuray kay bangal ngoeymulngu ngithamun zagethaw mabaygal aymoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yoewsepan zagethaw mabayg kedha, ‘Wa, ngay asin ngithamun senawbi yangukudu ya. Kasa kay kedha senaw kap ngadh nanga mangu, matha nuy kay ngaw zagethaw mabayg aymidhe, ngitha dhuray lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kalanu thana thanamun yanal mulupa idiman a gud pudhamoeyr. ");
INSERT INTO mwp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yoewsepan zagithaw mabaygan mura thanamun yanal imaydhin. Kuykuygaw yana kuykaymay kurisipa kuthaygaw yana. Nuydh kap imadhin koewba kuthaygaw yananu. ");
INSERT INTO mwp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Thana nungu Benzoemanan tukuypan thanamun sodhal nubepa koerkak boedhan pakadamoeydhin. Kalanu thanamun donkil rugan balbayg palimoeydhin a lak goegathoepa kuniya tidemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yudha a nungu tukuypal thana koezi nanga nuy Yoewsepa matha sin lagoenu. Thana nubepa parunu kuykul patidamoeyr. ");
INSERT INTO mwp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nuy Yoewsepa kedha thanamulpa, ‘Ngitha za miyay aymoedhin? Ngitha ngulaygal kedha, mi mabayg mangu, ngaw zagethoenu sepa, ngitha sobaginga imiz ngaw goewguwam zapun.’ ");
INSERT INTO mwp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yudha thanamun kuykuyg kedha muliz Yoewsepalpa kuniya, ‘Ngoey gar ngibiya yoewdhemin, ngoey kedha ngoedhal mabaygal lawnga. Ngoey kay ngibepa midh, ngoeymun mina pawa yakampa. In nubi sirisrin ngaru Awgadhaw kuniya tiday ngoeymulpa, ngoeymun kulay thonaraw wati pawapa. Ngoey bangal mura kalmel nginu zagethaw mabaygal wara nuy senaw kap ngabiya nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yoewsepa kedha, ‘A, a, lawnga! Ngayapa mina kay gudal zageth kedha zapa aymoeypa. Lawnga matha senaw kap ngabiya nanga imangu nuy bangal ngaw zagethaw mabayg. Setha ngitha ngaya lawnga ngitha balbayginga Kananapa kuniya memay ngithamun thathipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yudha Yoewsepalpa mulaydhin kedha, ‘Ngay gar apasin ngibiya, ngidh kay ngoena pawoeyaypa ngibepa yapa. Ngayapa kay thabukirin maygi; ngi ngoedhe mopa kuyk midh nginu geth. ");
INSERT INTO mwp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ngi ngoeymulpa yapu poeybadhin kedha, “Ngitha thathilgal a? Ngitha tukuypoelgal a?” ");
INSERT INTO mwp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ngoey ngibepa kedha mulemidhin, wa ngoey thathilgal, nuy mina koey thathi a ngoey kuthaygoelgal, nuyn kazi madhin nanga ngoeymun thathi sinubi thonara mina kay gudal thathi. Senawbi kaziw tukuyap umanga nungu apuwaw kazi. Matha nuy kedha kayib nungu thathiw koey mamal kazi. ");
INSERT INTO mwp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ngi ngoeymulpa mulaydhin nubepa ngapa moeypa lak ngidh nuyn iman. ");
INSERT INTO mwp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","‘Kasa kay kedha ngoey ngibepa kedha mulemidhin. Senawbi kazin koey zageth nuydh nungu thathi wanan. Nuydh kay woenaypa nungu thathi kay um mepa. ");
INSERT INTO mwp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kalanu ngi kedha ngoeymulpa mulaydhin, ngoeymulpa nginu lagoenu moengaypa lawnga, mamu bangal ngoeymun kuthayg nanga ngoeymuniya kalmel. ");
INSERT INTO mwp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ngoey mura ngoeymun thathi yadu thuradhin, ngi midh umay nanga ngoeymulpa. ");
INSERT INTO mwp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","‘Nuydh ngoey lak ngapa wayayngu puy kunoepa barpudoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ngoey kedha, ngoeymulpa mabapa lawnga a ngoeymulpa nungu lagoepa mabapa lawnga. Benzoemanalayg nanga, ngoey kay memayipa. Wa, ngoeymun koewba kuthayg kay oesipa kalmel ngoeymuniya. ");
INSERT INTO mwp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ngoeymun thathi ngoeymulpa mulaydhin kedha, “Ngitha ngulaygal ngaw ipi Reysoel nadh ngayapa kazi mamamoedhin matha ukasar. ");
INSERT INTO mwp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Urapun palamulngu umanga, thoeydhayl uruyn nuyn moegithap madhin sikedh. Ngath lak nuyn imayginga nuy nanga koezi miyaydhin ngawngu. ");
INSERT INTO mwp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ngidh kay nanga Benzoemanan maypa ngawngu, wara kedha za dhadha mangiz nubiya yabugudanu dhadhal, ngay bal kasa umanga koerkak boedhan. Minguz kedha in ngay mina kay thathi.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yudha lak mulaydhin kedha Yoewsepalpa, ‘Ngay kay nanga Benzoemanagig ngaw thathipa kuniya tidepa, a nuydh kay nanga imaypa kedha Benzoemanaginga nuy kay um mepa. Kedha zoenguz, senaw Benzoeman nungu igililnga a nuy mina koey thathi nungu ngoenakap kikirin kay kedha nungu kuth gasamoene. ");
INSERT INTO mwp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Lak kay wara miyay? Ngath ngaw igililnga madhin ngaw thathipa sepa koewba kuthaygoepa, ngay nubepa kedha mulaydhin, ngath bangal nanga nuyn kuniya balbayginga sena bangal ngaw gegeyadh ngaw igilaw kuthalpa. ");
INSERT INTO mwp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kedha zoenguz ngay gar kay koew nungu buthapa nginu zagethaw mabayg ngedh. Nuyn nungu tukuypiya kalmel kuniya wayar? ");
INSERT INTO mwp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ngay kay nanga ngaw kusayg kuniya tidepa ngaw thathipa Benzoemanagig? Ngaw mina ubiginga, ngaw thathipa ngoenakap mapupa gegeyadh gasamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yoewsepa nanga karngemidhin Yudhan yaday, nuydh nungu koerkak badh yan panidhar mura mabaygaw parunu. Nuydh nungu mura zagethaw mabaygal adhapa wayaydhin lagoengu muyngu. Wa, matha nungu tukaypal si lagoenu muynu nubiya. Nuy thanamulpa yakamaydhin kedha, nuy mina Yoewsepa thanamun tukuyap. ");
INSERT INTO mwp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Senawbi kaliya nuydh Yoewsepa mina koey gimiya may puydhadhin laganu muynu. Aykupithulgan nungu may adhaz karngemidhin thana Perolpa mulemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yoewsepa nanga mulaydhin nungu tukuypoepa kedha, ‘Ngay Yoewsepa.’ Nungu tukuypal mina madhu pamemidhin, thana wara ya mulayginga nubepa, nuy nanga thanamulpa yapupoeybaydhin kedha, ‘Ngaw thathi matha igililnga?’ Kasa thana ngaru ya mulayginga, thanamun aka mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yoewsepa kedha thanamulpa, ‘Ngapa gamupa thamemiw.’ Thana nubepa gamupa thamemin. Nuy kedha, ‘Ngay ngithamun tukuyap Yoewsepa ngitha ngan nanga yoewdhadhin Aykupithulgoepa. ");
INSERT INTO mwp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aka gasamayg. Ngithamulpa sike kedha, ngitha bangal gegeyadh gasamane modhabiya ngithamun kedha wati zagethoengu. Lawnga ina Awgadhaw butha poethay koezi pay ngapa parungu. Nungu ubilnga kedha, nuydh ngoena ngithamuniya kulay wayadhin ngitha akaw woekay thoemamayg. Ngay ngapa kulay ngithamuniya, mabaygoepa gudaz puydhaypa. ");
INSERT INTO mwp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ina matha ukasar wath ulaypa urapu gethaw dhimural wathal mura waniz zagethoepa matha ngoedhagidh lawnga, ayboewdhu thonarpa gasamoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","8","‘Ngitha lak wakay thoemamay ina ngoena Awgadhan kulay ngithamuniya wayadhin ngithamulpa gudaz puydhaypa. Ngithamun kulay ngara pudhamay midh nanga. Ngitha sepa yakanuray poeybaw. Awgadhan senawbi gegeyadh balbaygi maypa mina wadhethulu balbayg tidadhin. Nuydh ngoena ayngu zangu danal poethay kuyku mabayg aymoedhin, ngithamulngu maytha aygin um pudhayle, ngithamun buwayngu idhumoeyle. Ngitha ngoena yoewdhadhin, kasa kay kedha ngitha ngithamun geth lawnga. Awgadhan mura zapul buwayl idimoedhin kuyku nidhaypa. Ngitha, ngoena ngapa woeyayginga koepa, ngoena Awgadhan wayadhin. Nuydh ngoena koew mopakuyku mabaygan kuyku zagethaw mabayg aymoedhin. Kayib ngath ina minampa Aykupithunu.’ ");
INSERT INTO mwp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yoewsepa matha umay thanamulpa kedha, ‘Ngitha kedha thonara memayi ngaw thathipa kedha kay mulemiw, “In nginu kazi Yoewsepa kedha mulema. Ngapa bangal paypa, Awgadhan ngoena kuykulnga aymoengu in Aykupithunu. Ngitha gar bangal kazayginga ngapa ngayapa. ");
INSERT INTO mwp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ngitha bangal ngayapa amadhan memayipu ngi a nginu kazil a ngepal, nginu mamuyl, kawal, nanil a setha mi zapul sey ngapa bangal mura. Mamuypa balbayginga amadhan lag Gusen. ");
INSERT INTO mwp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Thana bal ngitha nanga Goseninu ngath bangal ngitha danal pathepu urapu gethaw dhimural wathal ka matha bangal aygimayl. Ngaw ubiginga kedha ngitha maythaygi thiyaypa, ngithamun ipi-kazil a tetel uruyl.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","‘Wa! Ngitha kalmel purkan iman ngoena, a matha kedha Benzoemanalpa kakal, in ngay ngaw gudan ngithamulpa umepa mina ngalpan yangukudu ya. ");
INSERT INTO mwp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ladhu ngaw thathipa mulemiw kedha, ngay mi koey mabayg in Aykupithunu, a mura bangal yadu thurane zapul itha midh nanga paru ngitha imayngu. Paypa bangal ngapa nuyn manine.’ ");
INSERT INTO mwp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nuydh Yoewsepa kalanu maylmayl geth thayan Benzamoenaniya; a nungu Benzoemanan lak may nubepa Yoewsepalpa. ");
INSERT INTO mwp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nuy nanga Yoewsepa mayoersir nuydh thana mura yaynanob moeylmoeyl gamupa gasamoeyr a gudthapamoeyr nungu tukuypal. Nungu may kaliya thana tukuypal nungu urapun mayn ya sagul sir Yoewsepaniya. ");
INSERT INTO mwp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pero nanga karngemidhin kedha, Yoewsepan tukuypal ngabunanu, nuy a nungu zagithaw mabaygal thanamulpa mina kay dhiwalnga. ");
INSERT INTO mwp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Nuy kalanu Yoewsepalpa mulaydhin kedha, ‘Ngi thanamulpa muli, thanamun tetel uruya rugal balbayg poelaypa kuniya Kananapa mabapa. ");
INSERT INTO mwp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Lak bangal thanamun thathi a thanamun ipi kazil boey kuniya mamayine, ngath bangal thanamulpa mina kapu boeradhar poeybane in Aykupithunu, thanamulpa balbayginga niyaypa koew. Thanamulpa thawpay oesipa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Midh setha kay dhuray sigangaral a kusumoene ipipa, kazipa, a thathipa thanamun ngapa moeypa. ");
INSERT INTO mwp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Thanamulpa kedha wakay oesig setha mi zapul kay thana wanepa, itha kay mi mina zapul nanga Aykupithunu bangal mura thanamun zapul.’ ");
INSERT INTO mwp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakubun garkaz kazin kedha mina aymoedhin thanamulpa ya midh nanga madhin. Yoewsepa thanamulpa wara sigangaral mamayidhin a yabuya ayde dhuray, Pero nubepa midh na umay. ");
INSERT INTO mwp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yoewsepa wara thanamulpa mura yaynanob rugal mamaydhin sakariya thiyaypa, a thanamun koewba kuthaygoepa thoeri andred mura koethil bokadhzoepul a urapu gethaw dhimural mura rugal kusumoedhin sakariya thoeyaypa. ");
INSERT INTO mwp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Nuydh nungu thathipa mina zapul woeyamoeydhin donkiya. Kapu Eykupithaw rugal nuydh wayamoeydhin wara ten donkiya a yabuya aydel puy kunalmayl a dhuray aydel nuydh wayamoeydhin ten yoepkaz donkiya. ");
INSERT INTO mwp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nuydh nungu tukuypal wayaydhin mabapa. Moeygoepa nuydh thana wakay mamayidhin kedha, ‘Kidhakidhan bangal yabuya ya pathowkamayg.’ ");
INSERT INTO mwp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Thana kuniya ladhudhin Aykupithungu thanamun thathipa Yakubulpa Kananapa. ");
INSERT INTO mwp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Thana nanga ngabunadhin, thana thathipa kedha mulemidhin, ‘Yoewsepa matha igililnga. Nuy Aykupithu kuyku minamay mabayg.’ Nuydh kay Yakubu mina yapoethoemayginga, minguz kedha nuy ngoedhe madhu pamaydhin. Thana nanga nubepa mulemidhin. ");
INSERT INTO mwp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kalanu nanga thana nubepa mulemidhin kedha, Yoewsepa midh na mulaydhin a nuydh na Yakubu sigangar yawaraw za imadhin, Yoewsepa mi sigangar wayadhin nubepa Aykupithupa, nuy Yakubu kalanu balbaygoesidhin a mina yapa thamadhin. ");
INSERT INTO mwp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kalanu nuy kedha ‘Ngaw garkaz kazi ka matha igililnga! Ngaw ya matha kedha ngay kay ngaru nubepa maypa mepa, wagel bangal umanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wa, Isoereylnungu kazil, a nungu kaziw kazil rug buthapoethay uzaraydhin. Kalanu thana memayidhin Biyasibalpa. Nuy Awgadhoepa yoewdhaydhin a eso poeybaydhin oltanu, nungu thathiw Isakan Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Senawbi kubilu nanga nuyn pikin thayar Awgadhan nuy tharal kedha ‘Yakubu, Yakubu!’ Nuy Yakubu kuniya Awgadhoepa kedha muliz ‘Midh ngay in.’ ");
INSERT INTO mwp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nuy Awgadh kedha, ‘Ngay mina Awgadh, ngay nginu thathiw Isakan Awgadh. Akan maygi Aykupithupa moeythayle ngath bangal nginu kaziw kazil wara bangal koey goegath aymoene Aykupithunu. ");
INSERT INTO mwp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngay bangal ngibiya kalmel Aykupithupa, a Yoewsepa bangal ngibiya kalmel ngi bangal na umanga, kurusipa bangal ngath nginu kaziw kazil lak boey kuniya thabi boeradhoerapa mamayine.’ ");
INSERT INTO mwp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kalanu Yakubu a mura nungu kazil a kaziw kazil thana memayidhin Biyasibangu. Nungu kazin nuyn, a mura ngepal sigangar mabaw zapunu pathamoeydhin Aykupithu Peron mi sigangar mabaw za wayadhin thanamulpa nanga. ");
INSERT INTO mwp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Thana mura thanamun zapul kusumoedhin a thanamun tetel uruyl Kananangu Aykupithupa. Yakubu mura nungu kazil, a kaziw kazil, ");
INSERT INTO mwp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","8","garkaz kazil, yoepkaz kazil, a nungu garkaz a yoepkaz ngepal. A setha ngaya nanga Yakubuniya kalmel asimoeydhin Aykupithupa itha kedha: ");
INSERT INTO mwp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rewben nungu kuykuyg garkaz kazi. Rewben, nungu garkaz koezil; Anok, Palu, Ezron, a Kami. ");
INSERT INTO mwp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyon, nungu garkaz koezil. Zemuwel, Zamin, Oad, Zasin, Zowa a Sawlo nuy Kananaw yoepkoeziw kazi. ");
INSERT INTO mwp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lebi, nungu garkaz kazil. Gosoen, Kowath, a Merari. ");
INSERT INTO mwp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudha nungu garkaz kazil; Sela, Periz, a Zera. Perezan garkaz kazil kedha Ezron a Amul. ");
INSERT INTO mwp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka, nungu garkaz kazil; Tola, Puwa, Zasub a Sirom. ");
INSERT INTO mwp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zeboelon, nungu garkaz kazil; Seredh, Elon, a Zalil. ");
INSERT INTO mwp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Itha Leyana kazil Yakubulpa, a wara nungu yoepkaz kazi Dina. Leya mura nanu kazil mamayidhin Mesopoetaymiyanu. Mura garwoeydhamoeyn Yakubun kaziw kazil thoerti thoeri Leyalngu. ");
INSERT INTO mwp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad, nungu garkaz kazil; Zepon, Agi, Suni, Izbon, Eri, Arod, a Areli. ");
INSERT INTO mwp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asa, nungu garkaz kazil; Imna, Isba, Isbi, Beriya, a thanamun babath Sera. Beriyan garkaz kazi; Eba, a Malkiyel. ");
INSERT INTO mwp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Itha thabi sikstin Yakubun kaziw kazil Zelpangu, Leyboen ngan nanga Leyalpa zagithaw yoepkaz madhin. ");
INSERT INTO mwp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakubu, nungu ipi Reysoel nanu garkaz kazi matha ukasar Yoewsepa a Benzoeman. ");
INSERT INTO mwp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Aykupithunu, nanga Yoewsepan kazi ukasar garkaz nel; Manase a Epelema, apu Asenath Potheperan kazi, nuy Eliyopolisaw misnare. ");
INSERT INTO mwp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benzoemanan garkaz kazil; Bela, Bisa, Asbel, Gera, Naman, Eyi, Ros, Mupim, Upin, Ard. ");
INSERT INTO mwp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Itha thabi potin nanga Yakubun kaziw kazil Reysoelalngu. ");
INSERT INTO mwp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan nungu garkaz kazi Usim. ");
INSERT INTO mwp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napathoelay nungu garkaz kazil; Zazil, Guni, Zeza, a Silem. ");
INSERT INTO mwp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Itha thabi seben nanga Yakubun kaziw kazil thana Bilalngu, Leyboen Reysoelapa ngan nanga madhin zagethaw yoepkaz. ");
INSERT INTO mwp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakubun mina buway namba mura siksti sikis Aykupithupa memayidhin Yakubun kaziw kazil. Matha nungu kaziw ipil ukamayginga. ");
INSERT INTO mwp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sepal ukasar garkaz kazi Yoewsepan, nanga kazi mamamoedhin Aykupithunu garwoeydhamoeyn Yakubu a nungu kaziw kaziya mura sebenti nubiya ngaya nanga Aykupithunu memayipa. ");
INSERT INTO mwp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Thana wagel kay Goseninu mangemidhin Yakubu Yudhan kulay wayadhin, Yoewsepalpa kedha, ‘Ngoey bangal sew Goseninu ugepu. Thana bangal na mangemine.’ ");
INSERT INTO mwp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nuy Yoewsepa kalanu nungu sigangar mabaw zapunu miyaydhin Gosenipa nungu thathipa gasamoeypa. Nuydh nanga thana si gasamoeydhin nungu Yoewsepan may mina koeyza. Nungu thathipa mamu mayn muduliya geth thayadhin. Nuy Yoewsepa mina kay kuykuthalnga may adhadhin. ");
INSERT INTO mwp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kalanu nuy Yakubu nubepa Yoewsepalpa mulaydhin kedha, ‘Wa in mina ngi ngaw kazi, a ngath lak nginu paru iman. Lak wara zapa ubinmayginga a ngaw um kasa kobegadh thonara mepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nuydh Yoewsepa kedha nungu tukuypoepa a thathipa, ‘Ngath mamu mopa kuyk Peron ngulayg palaypa kedha, ngitha mura ngabunoengu Kananangu ngaybiya. ");
INSERT INTO mwp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","A ngay kay nubepa mulepa kedha, ngitha mamuy danal poethay mabaygal a ngitha mura tetel uruyl danal pathayrngu a ngitha mura ngithamun tetel uruyl a kawal ngapa kusumoedhin, a mura ngithamun zapul. ");
INSERT INTO mwp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","‘Nuydh kay nanga ngitha thuredhe a yapu kay na poeybepa kedha, “Ngithamun zageth miyay, ngitha mi zagethaw mabaygal.” Ngitha kay kasa balbayginga mulemiw kedha, ");
INSERT INTO mwp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ngitha ngithamun kayn goeygingu ngapa mamuy danal poethay mabaygal lak kay nuydh Pero ngithamulpa Gusen niyaypa yadu poelgaypa. Kedha zoenguz Aykupithulgaw mabaygal ubiginga kedha ngitha thanamun lagoepa tetel uruyl kusuman, thanamulpa ubiginga tetel uruyl.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kalanu Yoewsepa nungu tukuypal a nungu thathi yoelpamoeydhin Perolpa. Nuy kedha, ‘Ngaw thathi a ngaw tukuypal, thana ngapa Kananangu kalmel thanamuniya tetel uruyl. Thana sey Kuseninu.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Nuydh kalanu nungu tukuypal yadu poelagiz Perolpa. ");
INSERT INTO mwp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Nuy Pero thanamulpa yapupoeybiz kedha, ‘Ngitha mi zagethaw mabaygal?’ Thana Yoewsepan tukuypal kuniya kedha mulemin. ‘Ngoey mamuy danal poethay mabaygal ngoeymun thathiw thathil midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ngoey ngapa mudh thamangu koew niyaypa Kananangu. Kedha zoenguz Kanana mina kay gudal gegeyadh ayginga matha ngoedhagidh lawnga ngoeymun tetel uruypa aygudoepa. Ngoey gar ngibiya yoewdhemin ngidh gar ngoeymulpa wa mar Kuseninu mudhaw lagoepa aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pero kalanu Yoewsepalpa kedha muliz, ‘Wa, setha nginu thathi a nginu tukuypal mangemingu. ");
INSERT INTO mwp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","In Aykupithu boeradhar thanamun za thana bangal sew Kuseninu mudh yoewthane mina doegam boeradhoeranu, a thanamulngu nga nanga balbayginga nanga mina zagethal mabayg nuydh bangal ngaw tetel uruyl danal pathepu.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yoewsepa mamunge a nungu thathi oengadhin Perolpa imaypa, a nuy Yakubu kalanu Perolpa woenabal ya mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pero Yakubulpa yapu poeybaydhin kedha, ‘Nginu wathal midh mura?’ ");
INSERT INTO mwp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakubu kuniya kedha mulaydhin, ‘Ngaw igilaw kuthalpa ngay uzaraydhin nanga, kayib ngaw wathal urapu andred thoeri. Sethabi wathal kasa moenarimayl a mina koey zageth senubi thonara kedha lawnga ngaw thathiw thathil midh nanga thanamun wathal koeyma.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakubu kalanu Perolpa yawa thuray woenab poeybadhin a kalanu kuniya tidaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yoewsepa, nuydh nungu thathi a tukuypal balbayg tidaydhin Aykupithunu a poeybadhin mina boeradhar amadhan Ramesesoepa mopa kuyk midh nanga mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yoewsepa kalanu aydu poeybaydhin mura nungu thathi, a tukuypal a mura nungu thathiw kaziw kazil mina moegina koezil wara. ");
INSERT INTO mwp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aygi wath mina kay gudal gegeyadh mangaydhin mura doegamuya Aykupithu a Kananaw mabaygan maytha aygi poegaypu a gamul goegadhimayl. ");
INSERT INTO mwp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Thana nanga Yoewsepalngu puy kunal barpudoemoeypu nuydh Yoewsepa senabi bokadhza Peron lagoepa mayparu. ");
INSERT INTO mwp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mura nanga Aykupithu a Kananaw bokadhza sagul paladhin thana Aykupithulgal Yoewsepalpa ladhudhin a kedha mulemidhin ‘Ngoeymulpa gar ayde, ngoey umapa maygi! Ngoeymun bokadhzoepul mura aygi thayamoeyngu.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yoewsepa thanamulpa kedha, ‘Wa, ngithamun tetel uruyl ngapa modhabipa. Ngath kay ayde ngithamulpa kusumpa, ngithamun bokadhzoepul mura aygi thayamoeyngu nanga.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Thana kalanu thanamun tetel uruyl Yoewsepalpa mamaydhin, a nuydh thanamulpa ayde kusumar modhabiya thanamun osapa, mamuypa, nanipa, kawapa a donkipa. Senawbi wathoenu nuydh thanamulpa mamaydhin modhabiya thanamun tetel uruypa. ");
INSERT INTO mwp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Wara na wath, sew kalanu nanga thana nubepa Yoewsepalpa kedha mulemidhin, ‘Ngoey midh nginungu wara zapa woerdhaypa lawnga, ngoeymun bokadhzoepul mura aygi thayamoeyngu setha ngoeymun tetel uruyl nanga nginu zapul. Ngoey lak zagigal ngibepa, matha ngoeymun gamul a boeradhar. ");
INSERT INTO mwp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ngoeymulngu gar umangu za aymar! Thana bangal ngoey a ngoeymun kaziw kazil bangal ngaru balbayginga wara gegeyadhoepa lawnga a ngoeymun boeradhar bangal lak kedha mabaygoegasile. Ngoeymulpa gar ayde, a ngidh ngoeymun gamul a boeradharal kusumoeyr modhabiya. Ngoey bangal Peron zagethaw mabaygal a nuy bangal ngoeymun boeradhoeraw kuyk. Ngoeymulpa gar puy kunal a kapul uthuypa ngoeymun zagithaw lagoenu uthuypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yoewsepa kalanu boeradhar mura barpudoedhin Aykupithunu Perolpa. Mura sew mabaygoepa kedha madhin thanamun boeradhoerapa yoewdhaypa. Kedha zoenguz aygi thonar mina kay gudal gegeyadh mangaydhin a setha boeradhoeral mura Peron zapul aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yoewsepa mabaygal zagithaw mabaygal aymoeydhin, war kuthangu war kuthapa. ");
INSERT INTO mwp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nuydh Yoewsepa matha misnarew boeradhar barpudayginga, minguz kedha thana nubepa yoewdayginga, Pero thanamulpa bokadhza poethaypu thanamulpa niyaypa. ");
INSERT INTO mwp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yoewsepa kedha mulaydhin mabaygoepa, ‘Ngitha iman a, ngath ngitha a ngithamun boeradhoeral Perolpa barpudoemoeyngu nagul itha ngithamulpa uthuypa ngithamun zagithaw lagiya. ");
INSERT INTO mwp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ayboewdhu thonar nanga gasamoene, ngitha bangal ngaru Perolpa ayde kusumoene ngibiya payb liday nanga kunalmayl, ngaru urapun thanamulngu Perolpa a setha midh na wanedhe nanga, mura ngithamulpa nagupa a aypa. Wa, nubi za matha kedha ngithamulpa, a ngithamun kazipa, a ngepoepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Thana kedha, ‘Ngidh ngoey igil poelayngu ngidh ngoeymulpa kapu pawa aymoeyngu, ngoey bangal Peron zagethaw mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yoewsepa nan sabi aymoedhin Aykupithunu kedha, Perolpa ngaru ayde kusuman ayboewdhu thonara ina nabi sabi ngaru meparu bangal. Matha misnarew boeradhar Peron za aymoeyginga. ");
INSERT INTO mwp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Thana Isoereylalgal Aykupithunu memayipu Kuseninu, thanamun kazil a kaziw kazil ngalaga nanga pawpa lak kupar palaydhin a matha koey ayde zapulgal aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakubu nuy meparu Aykupithunu matha mura sebentin wathoelnga kurusipa nuy urapu andred a poti seben wathalayg aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na nanga nungu Yakubun thonar amadhan thamaydhin, nuydh Yoewsepan thuradhin, nubepa kedha mulaydhin, ‘Koewki ngaw piti madhuya geth mar a mina koey ridha yawadhan kay aymar kedha, ngibepa ngayapa koew moerama thoeyaypa lawnga Aykupithunu. ");
INSERT INTO mwp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ngaw ubi kedha ngoena kalmel ngaw thathiya moerama thayan, thana ngalaga nanga ngoena bangal koezi adhapa Aykupithungu manine.’ Yoewsepa kedha, ‘Ngath bangal nginu ubilnga aymoene.’ ");
INSERT INTO mwp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakubu kedha ‘mina ya muli kedha ngidh bangal aymoene.’ Yoewsepa kalanu mina ya mulaydhin kedha, ‘Ngath bangal aymoene nginu ubilnga.’ Yakubu nuy boeginu poeydhay mina koey thathi nuy nanga eso poeybaydhin Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","War thonara nanga nuydh Yoewsepa karngemidhin kedha nungu thathiw kikir mina koeyza. Nuydh nungu ukasar garkaz kazi mamoemoedhin, Manase a Epreym. Kalanu thana Yakubulpa imaypa memayidhin. ");
INSERT INTO mwp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nuydh nanga Yakubu gasamoedhin kedha Yoewsepa nungu garkaz kazi ngapa nubepa imaypa, Yakubu moegawn garpathamoeydhin uthuy lagoenu nungu igi niyaypa. ");
INSERT INTO mwp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakubu kedha mulaydhin Yoewsepalpa, ‘Awgadh, adhapudhay woenabal poerapoeral Awgadh, ngayapa yakamaydhin goegath nel Luz Kanananu, a nuydh ngayapa woenab poeybadhin, ");
INSERT INTO mwp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","a kedha woenabal yangukudu guythuyadhin ngayapa, “Ngath bangal ngibepa koeyma kazil mamayine, thana bangal nginu kaziw kazil wara koey goegath lag bangal. Ngath kay ngibepa nubi boeradhar maypa nginu kaziw kazipa thanamun za pamoeygoepa.” ’ ");
INSERT INTO mwp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Wa, lak Yakubu Yoewsepalpa kedha, ‘Sepal nginu ukasar garkaz kazi Aykupithunu ngawal na kazi mamoemoedhin, ngay wagel kay koepa ngapa miyaydhin, sepal ngaw kazi matha kedha, Rewbenaw Simiyonaw midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nginu bangal nanga dhuray kazil nanga thana bangal ngaw kazil lawnga, thanamun aykuyk ngawngu lawnga, thana bangal mura zapul gasamipu Epelemaw Manasew mulingu nginu ukasar kazingu. ");
INSERT INTO mwp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ngath kedha zoenguz kedha aympa nginu apu Reysoel. Ngaw koerkak badh mina koeyza nadh Kanananu muwasidhin Eprathapa amadhan, ngoey nanga Mesopoetaymiyangu. Ngath nan sina moerama thayadhin Eprathapa yabugudanu pasinu.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nuydh na Yakubu Yoewsepan kazi imamoedhin, nuy yapupoeybaydhin kedha, ‘Ipal ngawal?’ ");
INSERT INTO mwp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yoewsepa kedha, ‘Sepal ngaw garkaz kazi Awgadhan ngawal ngayapa Aykupithunu mamamoedhin nanga.’ Yakubu kedha, ‘Ngapa ngayapa palay mamamoeriw nakay ngath palamulpa woenab poeybaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakubu zapul moegina yawaymoeypu minguz kedha nuy mina kay thathi nubepa matha ngoedhagidh lawnga balbayginga imaypa. Yoewsepa kalanu palay Yakubulpa mamamoedhin, nuy Yakubu palay gudthapaman. ");
INSERT INTO mwp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yakubu kedha Yoewsepalpa, ‘Kazi, ina waza kulay koey koerkak badhalnga; ngayapa kedha, ngath nginu paru lak imayginga. Kayib nanga matha nginu paru lawnga. Awgadhaw sib wanan ngayapa kedha, ngath nginu kaziw paru imamoemoenu.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Palay garkaz palamun popuya pasinu kaday siyamar, kalanu Yoewsepa palay adhapa maman a kuyk patidan apasin Yakubulpa, paru boeradhoerapa mulupa. ");
INSERT INTO mwp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","14","Nuydh Yoewsepa ngapa yoelpamoedhin nungu ukasar kazi palamun maykuykuya. Wa, kuykuyg waza Manase Yakubun getha doegamoenu, a kuthayg Epelema boedha doegamoenu. Kasa kay kedha Yakubu nungu geth wardh wanamoedhin; kuthaygiya nungu gethadoegam geth kuykunu a kuykuygiya boedhadoegam geth kuykunu wanamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kalanu nuydh Yakubu Yoewsepalpa woenab poeybadhin kedha, ‘Abraman a Isakan Awgadh ngi palamun thawmayzi Awgadh, woenab poeybaw palbi kazipa! Awgadh, ngoena ngadh nubi goeygipa gethiya yoelpadhin woenab poeybaw palamulpa. ");
INSERT INTO mwp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Angela, ngoena ngadh nanga mura wati mathamayl zoenguz gudaz puydhadhin woenab poeybaw palamulpa. Lak bangal ngaw nel a ngaw thathiw nel, Abraman a Isakan ngaru bal pawpa gethawoeyaypu palay. A lak bangal palay koeyma kazilayg a palamun kaziw kazil.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yoewsepa nanga imadhin kedha nungu thathiw getha doegam geth Epelemaniya kuykunu, nuy ubigasidhin. Nuydh nungu thathiw geth adhapa moeypa madhin Manasen kuykupa. ");
INSERT INTO mwp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nuy Yakubulpa kedha, ‘Bab kedha lawnga, senaw kuykuyg kazi nungu kuykunu nginu getha doegam geth wanar.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nungu thathi ubigasidhin kedha mulaydhin, ‘Ngaw kazi, ngay ngulayg. Manasen kaziw kazil bangal koey garsar, kasa kay kedha nungu kuthaygaw bangal lak koeyma Manaseniya, nungu kaziw kazil bangal wara koey goegath.’ ");
INSERT INTO mwp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yakubu woenab poeybadhin palamulpa senabi goeyginu, a kedha mulaydhin, ‘Isoereylaw buway bangal ngipel nel tharempu thana bangal na woenabaw ya umamoeypu kedha, “Awgadhan bangal ngithamulpa lak koey woenab poeybane kedha, Epelema Manasew midh nanga.” ’ Wa, nuydh Isoereyl kedha kuniya aymoedhin, nuydh kuthayg kulay madhin; Eplema kulay Manase wagel. ");
INSERT INTO mwp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kalanu Yakubu Yoewsepalpa kedha mulaydhin, ‘Ngidh ngoena iman, ngaw um mina amadhan, kasa Awgadh bangal ngibiya kalmel a ngin bangal lak kuniya manine nginu thathiw thathiw lagoepa. ");
INSERT INTO mwp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sena ngibepa, nginu tukuypal lawnga ngath madhin Sekoem, koey ayde lag ngath madhin Amoraythalgoengu ngaw kuyay thurikan a gagay thayakan.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakubu mura nungu garkaz kazil garwoeydhamoeydhin a kedha mulaydhin, ‘Ayawal ngapa ngayapa gamupa. Ngay ngithamulpa mulepa, kalaw goeyginu bangal midh na paru zapul aymoeypu ngithamulpa, a ngithamun kaziw kazipa.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nungu Yakubun wara nel Isoereyl. Nuy kedha nungu garkaz kazipa, ‘Kurusipagemiw ngaw yapa, ngay ngithamun thathi Isoereyl.’ Nuydh thanamulpa moeygoepa yawadhan aymar yaynanob kedha, ");
INSERT INTO mwp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","‘Rewben, ngi ngaw kuykuy kazi a ngi ngaw magaw, ngaw koeykoeyne niyaypa yoelpay kazi. Ngi mura gimal nginu tukuypiya, nginu magaw koeyza, a nginu woeydhumoeypu. ");
INSERT INTO mwp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ngi ngoedhe koey woerngu woeyay baw lagiya mura, kasa kay kedha nginu kupay bangal mamu mina lawnga nginu tukuypiya gimal. Minguz kedha, ngidh koey wati pawa aymoedhin ngaw zagethaw yoepkaziya; yoepkaz nga nanga lak kedha ngaw ipi. Ngidh nginu thathiw uthuy lag sagul paladhin, mina apasiginga.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Simiyon a Lebi ngipel mina tukuyap kazi, ngipel matha kedha koey magawlnga, ngipeniya nanga ngipen koewbu rugal niyaypa. ");
INSERT INTO mwp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Kasa kay kedha, ngayapa ngipeniya puzipa lawnga. Ngayapa kedha ngoedhal ya umaynu puzipa lawnga ngipeniya, ngipel mabayg thabukirin uma mathampa, a wara thonara garkaz kow ngipel kasa nuyn nuthaypa thatha uma mathamaypa. ");
INSERT INTO mwp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Wati za bal mangedhe ngipen thabukirinu. Ngipel waza mina silamaylayg, mina koey silamaypa nagaylayg. Ngipel koerkak badhoegig. Ngath bangal ngipel sigaw gud wanamoene ngipen mabaygiya, mura Isoereylalgiya.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Yudha, nginu tukuypan bangal ngin thawmayparu, kedha zoenguz ngi nginu thabukiriw mabaygiya kasa mabadh ulaypa. Ngidh thana mabar bal gasamoeypa. Nginu tukuypal bangal ngibiya parunu bangal kuykul pathidhamoeypu. ");
INSERT INTO mwp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ngi ngoedhe kobris ayngu aygudaw mabayg koey magawlnga ngoedhe loeyon. Silamay kalanu ngi nginu lagoepa kuniya tidiz a ngoenapudiz. Ngi ngoedhe loeyon nge, kobris aygudaw ayngu kalanu, koey akalnga nginu ngoenapudhayngu gegeyadh maythayle. ");
INSERT INTO mwp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","‘Wa, ngi Yudha ngibepa, nginu buwaypa bangal Peron rugapa oengaypa, nginu kaziw kazin bangal gethiya yoelpaypu a minampu. Lagan bangal ngi a nginu kaziw kazipa bangal modhabiya mayparu, ngithamulpa kapu asin a koerngayl kawra manin parunu, kurusipa bangal mina kupu mabayg mangedhe, kedha mopakuyku zapa oengaypa. ");
INSERT INTO mwp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ngi a nginu buway koey aydeg zapulayg bangal, ngoedhe kedha ngidh nginu tetel uruy donki goereypaw puy kuykunu yatharan, mina kapu goereypaw puy. Ngidh nginu rugal kulka gamul umal ngukin goereypaw ikaynu garwalgamoeypa. ");
INSERT INTO mwp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A nginu mabaygal bangal mina kapu ngoedhalmayl toedipu, koey gamul dhangalmayl bangal koey susu ikay woeningu a umal ngukingu kubikub purkalmayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Zeboelon bangal malu buwadhoenu niparu. Nginu buway nanga thana bangal mina koey butaw zagethalgal. Thanamun butaw anga thoeyay lagal koeygarsar kurusipa Saydon.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","‘Isakar ngi matha ngoedhagidh lawnga donkiya; donki nge bangal zagethan meparu, Isakar ngi kasa gamu goegadhin apiya yoewipa, nginu zagethaw ruganu dhadhal. ");
INSERT INTO mwp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kurusipa ngidh iman kedha, “Ina kay mina kapu ngoena pudhay lag.” Boeradhar mina kapu ngoedhalnga, mura ubilmaypa ngibiya aymaypa sethabi boeradharoenu, kasa kay kedha ngithamun buway gamul koey goegadhimayl zagethoepa aymoeypa. Kurusipa bangal ngitha wara mabaygaw mapu zagethaw mabaygal aymoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Dan, nginu nel muynu kedha, “minamay mabayg”. Nginu kaziw kazingu bangal ngulayg thanamun mabayg zoeyzi neydhay, matha kedha mura Isoereylaw buway midh nanga. ");
INSERT INTO mwp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ngi a nginu buway bangal ngoedhe thithur thabudh yabugudoenu pasinu thura nagemipu, ngithamun thabukiriw mabaygoengu gumi mangayle. Ngitha ngoedhe nge thithur thabul ngithamun thabukiriw mabaygaw osanu pukukoenu thoeydhemipa, mamu nuy thabukiriw mabayg osangu adhathayan.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Kalanu Isoereyalan thoeythupoegay Awgadhoepa kedha, ‘Kuykulnga, ngidh gar ngoena ibupudhar, a mura zapul thow palar, ngath kasa ngi ugaypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Gad, nginu buway nanga bupaw mabaygan bangal mathampu, kasa kedha nginu buwayn bangal thana wagel wakaypu mathamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","‘Aser, nginu buway boeradharan bangal, ayboedhaw thonara koey aykapulnga. Sethabi aydel bangal matha ngoedhagidh mopakuykupa.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","‘Napathoelay nginu buway bangal ngoedhe diyadh, kasa kobigadh wamayipu, matha wamenalnga wadha wadhagampa wamayipu, a thanamun kazil lak kedha kapu gamulmayl.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Yoewsepa, nginu buway bangal kapu puy koewsal tham, ngukinu pasinu. ");
INSERT INTO mwp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","26","Nginu thabukiriw mabaygal bangal ngitha mina gegeyadh mathamoeypu, kasa kay kedha thana bangal ngitha yan wakaypu gagay thayakaw poegaypa. Minguz kedha, ngithamun thabukiriw mabaygal ngapa nanga ngithamun gethal mina soersimayginga thayakal tadimaypa, a Isoereylan Awgadh, ngaw Awgadh nuydh ngitha magaw palepa. Nuydh ngithamulpa mura mina zapul poeybepa, matha kedha mamuy danal poethay mabayg nungu mamuyl danal pathepu. Minguz kedha nuy adhapudhay woenabal a poerapoeral Awgadh ngoedhe kedha kula. Nuydh poeybaypa ari nguki a matha kedha boeradharaw nguki. A woenab kalmel mura tetel uruya a ngithamun kaziya. Mura za senawbi, ngithamuniya mura gugu ubidh thoeyayzinga padal, poelawal, a aypuykoewsal. Ngaw mina ubi kedha, mura itha bangal thabi mina zapul, woenab bangal Yoewsepan kuykoenu, kedha zoenguz Awgadhan nuyn mina adhapa thamadhin nungu tukuypoengu. Awgadh nubiya parunu geth wanadhin.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Isoereyl matha umepu nungu mura garkaz kazipa, ‘Benzoeman mina bathaynga kurusipa kut, ngi ngoedhe kedha kobris ayngu aygudaw mabayg, koey magawlnga ngoedhe aygudal umay, ngoedhe woelp.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Itha thabi nelay gimal nanga thana Isoereylaw twaylob buway kuykul, a itha thabi kapu yangukudul nanga thanamun thathi Isoereyl thanamulpa yaynanob umay umapa moeygoepa. ");
INSERT INTO mwp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kalanu Isoereyl nungu twaylob garkazipa kedha mulaydhin, ‘Wa, ngaw mabaw thonar gasaman. Ngay sipa ngaw thathiw thathipa garwoeydhamoeyne bangal. Ngitha bangal ngoena sakaynu muynu wanane, ngaw thathil ngalaga nanga Epronan boeradhoernu, Ithalayg. ");
INSERT INTO mwp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ngitha ngulaygal kedha, Makpela wara lagaw nel sey Mamrenu, Kanananu muynu, ngalpan thathiw thathin ngalaga nanga boeradhar barpudhadhin, ngalpan umagamupa moerampa thoeyaypa. ");
INSERT INTO mwp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","*‘Thana Abrama, nungu ipi Seray, Isaka, nungu ipi Rebeka, a matha kedha ngath sey wanadhin ngithamun apu Leya. ");
INSERT INTO mwp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Senabi boeradhar a sakay si Ithangu barpudayzinga. Ngitha bangal ngoena sew moerama thoeyane.’ ");
INSERT INTO mwp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nuy yanu kalanu, nuy lak apiya yoewnadhin urapumayn, nuydh muwasidhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nuydh nanga Yoewsepa imadhin kedha Yakubu muwasin nuy kasa mura nungu thathiya gimiya maylmayl pudhaydhin paruya, nuyn gud thapamar. ");
INSERT INTO mwp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kalanu Yoewsepa nungu zagithaw mabaygoepa mulaydhin, nungu thathiw gamupa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Poti goeygilnga thana danal pathadhin. Aykupithulgan sebenti goeygipa koerkak badh gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Koerkak boedhaw thonar nanga muwasidhin Yoewsepa kalanu Peron zagethaw mabaygoepa mulaydhin, ‘Ngay gar yoewdhiz ngithamuniya in nubi yangukudupa Perolpa mariw. ");
INSERT INTO mwp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ngaw thathiw nanga um amadhan aymaydhin nuydh ngoena mina yoepa mulaypa madhin, ngath bangal nuyn Kanananu moerama thayane nuydh ngalaga nanga boeradhar barpudoedhin. Ngaw gar yoewdhiz ngoena pawayaw ngaw thathiw gamupa moerama thoeyaypa, a ngay bal kalanu lak boey kuniya.’ ");
INSERT INTO mwp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nuy Pero kedha mulaydhin, ‘Wa uzar a nginu thathiw gamu moerama thayar, ngi midh nanga umepa.’ ");
INSERT INTO mwp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kalanu gar nuydh Yoewsepa nungu thathi moerama thayadhin mura Aykupithu kuyku mabaygal asimoeydhin Yoewsepaniya. ");
INSERT INTO mwp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yoewsepan mabaygal a nungu tukuypal a mura nungu thathiw kaziw kazil asimoeydhin. Matha moegina koezil yawaygal, a tetel uruyl kawal a mamuyl kuniya yawaygal Goseninu. ");
INSERT INTO mwp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mabaygal kedha osanu, a sigangaraw mabaw zapunu memayidhin, Yoewsepaniya mabayg mina kay garsar senawbi thonara. ");
INSERT INTO mwp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Thana nanga ngapa si na mangemidhin kunaw zagethaw lag, Athadhoenu sager doegamunu, Yuridhaw Koesanu, thana mina gegeyadh koerkak badh gasamoedhin, a mina kay gima may mar. Kalanu Yoewsepa si maywoedhay ay aymoedhin seben goeygilnga. ");
INSERT INTO mwp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Thana nanga Kananaw mabaygan imadhin kedha Aykupithulgan maywoedhay ay aymar Athadhoenu, thana kedha mulemidhin. ‘Sena thana mina kay ridha maywoedhay ay aympa!’ Nan senawbi lag kedha zoenguz kedha tharadhin Abel Mizraym. ");
INSERT INTO mwp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yakubun kazin kalanu thanamun thathiw yawoedhayzimaya thayamidhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Thana nungu gamu madhin Kananapa a kulaw sakaynu muynu wanadhin Makpelanu sager doegamunu Mamrenu, Abrama mi boeradhar na Ebronalngu barpudoedhin, Ithalayg. ");
INSERT INTO mwp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Thana nanga Yakubun gamu moerama thayadhin kalanu thana mina mura Yoewsepaniya kuniya asimoeydhin Aykupithupa a Yoewsepan tukuypal, a setha ngaya nanga asimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Thanamun thathiw umaw kaliya nanga, thana Yoewsepan tukuypal kedha memayidhin, ‘Ngalpa bangal midh paru, Yoewsepa bangal nanga ngalpalpa matha wati igalayg muledhe bal, ngalpalpa nubepa kuniya modhabiya moeypa mura, ngalpa nubepa mi gegeyadh nanga aymoedhin?’ ");
INSERT INTO mwp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Senabi kaliya thana Yoewsepalpa kedha ya madhin, ‘Wagel ngalpan thathi mulupa, ");
INSERT INTO mwp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nuy kulay mulaydhin ngoeymulpa kedha, “Ngitha bangal nubiya yoewdemine gud pawayar sena ngithamun gegeyadh kedha, ngidh gar nginu tukuypaw gegeyadh gud woeyamar thanamulpa.” Wa, sena mina ngoeymun gegeyadh, ngoey nginu thathiw Awgadhaw zagethaw mabaygan aymoedhin.’ Nuydh na Yoewsepa thanamun yangukudu gasamoedhin nanga kasa may. ");
INSERT INTO mwp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kalanu thana nungu tukuypal lak thanamun geth kuykul patidamoeyr Yoewsepalpa parunu kedha yaday, ‘Itha ngoey ngibiya parunu ngoedhe nginu zagethaw mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kasa kedha Yoewsepa thanamulpa kedha mulaydhin, ‘Akan maygi, ngayapa ngaw geth Awgadhiya kulay thoeyaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ngitha ngoena wati doegamuya buwayl thayadhin, kasa Awgadhan nan senabi wati doegam buwayl thoeyay mina doegamuya, buwayl thayadhin mabaygaw igililmaypa kay kuthal poelaypa kayb ngaya nanga igililmayl. Minguz kedha, kulay za midh paru nanga aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ngithamulpa wara zaginga aka goesamoeypa, ngath bangal ngitha a ngithamun kaziw kazil bangal danal pathepu.’ Kalanu nuydh thana lak mina yadu mamaydhin balbayginga, a gabu yadu mamaydhin. Setha yadu nuydh thanamun ngoenakapul thamamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yoewsepa a nungu kazil a nungu kaziw kazil Aykupithunu memayipu, nungu nanga kuthaw thonar gasamoedhin nungu sethabi thonara wathal mura urapu hundred ten. ");
INSERT INTO mwp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nuy Yoewsepa igililnga memaparu kurusipa nuydh Epliyaman kazil a ngepal imaydhin, a wara nuydh Makayan kazil imaydhin. Nuy Maka waza Manasen kazi. ");
INSERT INTO mwp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nuy kedha nungu tukuypoepa, ‘Ngaw um mina amadhan, Awgadhan bangal ngitha danal pathepu, a nuydh bangal ngitha adhapa yoepamoeyne koezi sena ngalaga lag sey yadupalgadhin Abramalpa, Isakalpa, a Yakubulpa.’ ");
INSERT INTO mwp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kalanu Yoewsepa yapu poeybaydhin mabaygoepa kedha, ‘Ngayapa mulemiw, ngitha bangal Awgadhan yoelapidhe sethabi lagoepa, ngitha bangal ngaw gamu manine a ngithamuniya kalmel?’ ");
INSERT INTO mwp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Wa, thonar gasamoedhin Yoewsepa muwasidhin Aykupithunu sethabi thonara nungu wathal urapu andred ten, thana nungu gumu buth pathadhin a kobeniw muynu wanadhin. ");
INSERT INTO mwp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kerison buway kuyk kedha. Abrama nuy kuyk, wara nungu kaziw kazingu ngapa Dhawitha. Nuy aymaydhin adhapudhay kuyku garkaz muynu Isoereylanu, a Dhawithan kaziw kazingu ngapa, Yesu Keriso. ");
INSERT INTO mwp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraman kazi Isaka. Isaka nuy Yakubun thathi. Yakubu nuy Yudhan thathi. Yakubu nungu garkaz kazil lak koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudhan kazi Perez a Zera. Palamun apu Thamar. Perez nuy Ezronan thathi. Ezron nuy Raman thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rama nuy Abinoedaban thathi. Aminoedab nuy Nasonan thathi. Nason nuy Salmonan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon nuy Bawzan thathi. Bawzan apu nel Rayab. Bawzan kazi nel Obed. Obedan apu nel Rutha. Obed nuy Zesin thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi nuy Dhawithan thathi. Nuy Dhawitha Isoereylaw kuykulnga. Dhawitha nuy Solomonan thathi. Solomonan apu kulay wara mabaygaw ipi, Urayan ipi. Kalanu na Dhawithan ipi aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rewobowaman thathi. Rewobowam nuy Abayzan thathi. Abayza nuy Azan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza Ziyosapathan thathi. Ziyosapath nuy Ziyoraman thathi. Ziyoram nuy Uzayan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaya nuy Zothaman thathi. Zotham nuy Ayazan thathi. Ayaz nuy Ezakayan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezakaya nuy Manasen thathi. Manase nuy Amonan thathi. Amon nuy Zosayan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zekonaya a nungu tukuypal, thana Zosayan kazil. Senawbi thonara Babilonaw mabaygan koewbu Aymoedhin thanamulpa, gasamoeydhin koeyma mabaygal kuniya thanamun goegathoepa. Zekonaya a nungu tukuypal gasamoeydhin kalmel sethabi mabaygiya Babilonapa. ");
INSERT INTO mwp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Zekonayan kazi nel Siyaltil, nuyn kazi madhin sey Babilonanu. Siyaltil nuy Zerubaybelan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaybel nuy Abiyudhan thathi. Abiyudh nuy Eliyakoeman thathi. Eliyakoem nuy Azoran thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor nuy Zadokan thathi. Zadok nuy Asiman thathi. Asim nuy Eliyudhan thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudh nuy Eliyayzan thathi. Eliyayza nuy Mathanan thathi. Mathan nuy Yakubun thathi. ");
INSERT INTO mwp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu nuy Yoewsepan thathi, a Yoewsepa nuy Mariyana alay. Mariya na Yesun apu, nuy mina Awgadhaw woeyayzinga, Yesu Keriso. ");
INSERT INTO mwp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Thanamun maykuykul kedha, 14 maykuykul Abramalngu Dhawithalpa, a lak kedha 14 Dhawithoelngu Babilonaw thonarpa; Babilonangu ngapa Kerison thonarpa lak kedha 14 maykuykul. ");
INSERT INTO mwp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesun kazimay ya kedha. Nungu apu Mariya. Yoewsepa kulay nan yapu poeybar, kasa kay kedha wagel kay palay niyaypa yoelpempa, nadh gasamadhin kedha, na mapunga, kuykulmay Maygi Mariw woenab nabiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoewsepa nuy kapu mabayg, koey gabu ngoenakapulnga, nuydh nanga gasamoedhin kedha, na mapunga, nungu niyaypa yoelpaypa ubigasidhin, kasa kay kedha nungu ubi-ginga kedha, nuydh nan mabaygaw parunu kuniya wayan. Nungu ubi kedha palamun niyaypa yoelpay gumi pathidhan, nanungu Azirngu gasamoeyle mabaygaw parunu. ");
INSERT INTO mwp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuy senawbi wakay thoemamaynu mer, nubepa Awgadhaw angela pikin tharaydhin, a nuy nubepa kedha, ‘Yoewsepa, Dhawithan kazi, ngidh aka gasamayg, ngidh bangal Mariyana manine ngibepa ipi, sena nabiya Awgadhaw Kazi. ");
INSERT INTO mwp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nadh bangal thurkiyay kazi imane, ngidh bangal nuyn nel tharane Yesun. Nuydh bangal nungu mabaygal gudaz puydhamoeyne mura thanamulngu wati kuthangu gasamoeyle, thanamun ipidhadh gegeyadhoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ina mura Awgadhaw buthapathayzinga, kedha zoenguz nan kuyku nidhadhin, kay paypa kulay thonara Awgadhaw peropetha mura nabi buwaylthoeyay yadu madhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Ngitha bangal imane mina badhagi ngoewakaz na bangal mapunga Aymidhe, nadh bangal garkaz kazi imane. Nungu nel bangal Imanuwel.’ Nubi nel pudhamoeyn kedha, Awgadh ngalpaniya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoewsepa nuy nanga danpalaydhin, nuydh madhin Mariyana nubepa ipi, ");
INSERT INTO mwp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kasa kedha nuy nanungu koerawayg kurusipa nadh garkaz kazi imadhin. Nuydh nel tharadhin Yesun. ");
INSERT INTO mwp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nubi thonara Yesun kazi madhin muynu Bethliyamanu Yoewdhayanu. Erodh nuy kuyk senawbi thonara. Dhuray zugubaw mabaygal memayipu, thana woewra doegamoengu, azaz lagoengu ladhudhin Yoerusalemoepa, thana kedha, ");
INSERT INTO mwp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‘In kay Yoewdhayalgaw Kuykulnga ngalaga danadhadhin? Ngoey kayn thithuy imadhin. Ngoeymulpa kakal senabi kayn thithuy, ngoey gasamoedhin kedha, Yoewdhayalgaw Kuykulnga danadhangu. Ngoey ngapa nubepa apapudhaypa, a thawmaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erodh nanga karngemidhin, nuydh gegeyadh gasamoedhin, a matha kedha mura mabaygal muynu Yoerusalemoenu. ");
INSERT INTO mwp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nuydh garwoeydhamoeydhin mura kuyku misnarel a dhuray sabiw ngurpay mabaygal. Nuy kedha thanamulpa, ‘Kerison ngalaga kazimaypa?’ ");
INSERT INTO mwp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Thana kedha, ‘Muynu Bethliyamanu, Yoewdhayanu, kay paypa kulay peropetha minar paladhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Moegina goegath Yoewdhayanu muynu, nel Bethliyama, ngi moegina goegath dhadhal mura goegathal Yoewdhayanu; nginungu bangal ngapa Kuykulnga, nuydh bangal gethiya yoelpamoeyne ngaw mabaygal, Isoereylaw buway.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erodh kalanu mina muya Zugubaw mabaygal thuraydhin, gasa-moeypa thanamulngu ngulayg nuy senawbi thithuy mi thonara nanga kakal. ");
INSERT INTO mwp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nuydh kalanu thana wayaydhin Bethliyamapa, nuy thanamulpa kedha, ‘Ngitha ladhu, mina bangal nagemine senawbi mapethoepa. Ngitha nanga nuyn imane, ngayapa bangal yangukudu ngapa manine, ngay lak kedha ubin mepa apapudhay-pa, thawmaypa nubepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Thana nanga karngemidhin Erodhalngu, kalanu thana Bethliyamapa ladhudhin. Dhadhaz thana lak imadhin senawbi thithuy, nuy ngaru thanamuniya mabaw parunu. Kurusipa thana imadhin nuy nir balbayginga gimal nuy mapeth ngalaga nanga. ");
INSERT INTO mwp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Thana nanga imadhin thithuy, thanamun ika dhiw mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Thana ngapa muya uthemidhin lagiya. Si thana imadhin muynu mapeth a nungu apu Mariya. Thana kalanu pasoeynoemoeydhin koeyma apapudhemidhin a thawmadhin nuyn. Kalanu thana gud pudhamoeydhin thanamun siba wanay zapul, poeybamoeydhin nubepa, goli, punaw susu, a muraw susu. ");
INSERT INTO mwp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kalanu Awgadhaw yangukudu thanamulpa pikiya yakamoedhin kedha, ‘Erodhan yabuya kuniya tidayg.’ Thana kuniya tidemidhin wara yabugudiya thanamun lagoepa, lak Erodhan yabuya lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Thanamun kalanu, Awgadhaw angela pikin tharaydhin Yoewsepal-pa. Nuy kedha, ‘Ngi danpali, thoeridhar senaw mapeth a kalmel nungu apu. Erodh nuydh bangal senaw mapeth lumane, umamatha-moeypa. Ngitha ladhu Aykupithupa, ngitha bangal sew, kurusipa ngawngu bangal yangukudu ngibepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nuy danpalaydhin senawbi kubilu, mamamoedhin mapeth a nungu apu. Thana ladhudhin Aykupithupa. ");
INSERT INTO mwp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Thana si kurusipa Erodhan kuth. ");
INSERT INTO mwp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erodhalpa kedha, thana zugubaw mabaygal nubepa ngalkemidhin, nungu thabukir a ngurum koeyza. Nuydh wara buwaylthoeyay aymoedhin Yesulpa mathamoeypa. Nuydh yangukudu madhin nungu koewbu mabaygoepa a wayaydhin thana, umamathamoeypa mura garkaz kazil ukasar wathoengu mulupa, muynu Bethliyamanu, a dhuray goegathal nabiya pasinu. Nubepa sike kedha Yesu kedha wathalayg. Ina mura muladhin senabi thonarngu zugubaw mabaygal nanga ngabunadhin nubiya a thithuy mi thonara nanga imadhin. ");
INSERT INTO mwp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ina kuyku nidhadhin peropethaw Eremiyan yangukudu kay paypa kulay thonara kedha, ");
INSERT INTO mwp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Yangu wakay karngemin muynu Ramanu si, koerkak badh a mayngu wakay, mura apuwal, Raseloena kaziw kazil, thanamun may kazipa. Thana ubigasimoeyn balbaytidayle, kedha zoengu thanamun garkaz kazil mura umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erodhan umaw kalanu, Awgadhaw angela pikin tharaydhin Yoewsepalpa, muynu Aykupithunu. Nuy kedha, ");
INSERT INTO mwp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","‘Kadaypa mer, thoeridhar senaw nginu kazi a nungu apu. Ngitha ladhu Isoereylaw goegathoepa, sethabi mabaygal ngaya nanga mathamaypa madhin senaw mapeth, thana mura umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nuy kadaypa miyaydhin, mamamoedhin mapeth a nungu apu. Kalanu thana ladhudhin Isoereylapa. Ina kuykunidhan kuykulmay peropethaw ya mulayzinga kay paypa kulay, ‘Ngath thuradhin Ngaw Kazi adhapa Aykupithungu.’ ");
INSERT INTO mwp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nuydh Yoewsepa nanga karngemidhin kedha, Erodhan kazi Arthelaws nuy Kuykulnga, sey Yoewdhayanu nungu thathiw Erodhan buthapa. Yoewsepa aka gasamadhin sipa maythayle. Nuyn balbaytidadhin pikin. Thana memayidhin Galilayapa. ");
INSERT INTO mwp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nuydh aymoedhin thanamulpa niyaylag Galilayoenu, moegina goegath muynu nel Nazareth. Ina kuyku nidhaypa kay paypa kulay peropethaw ya mulayzinga, ‘Nuyn bangal thoeraypu Nazarethoelayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Senawbi thonara Yoewane Papthayso nungu zageth kuykaymaydhin, gima gudiya maw tharepu muynu Yoewdhaylgaw bupanu, mabaygoegi dhadhabuthanu. Mabaygal ngapa nubepa kursipoegaypa. ");
INSERT INTO mwp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nuy kedha thanamulpa, ‘Adhapa gathil thayemiw a yakanuremiw sethabi wati zoepul. Kedha zoengu, mina amadhan Awgadhaw Basalaya bangal danapa yakamidhe, mura ngalpalpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kay paypa kulay thonara Isaya, Awgadhaw peropetha yadu mayparuy Yoewanen kedha, ‘Wara mabaygaw yangu wakay poegaypa muynu bupanu, mabaygoegi dhadhabuthanu, nuy kedha, “Buthpathaw, balbay tidaw senabi ruwayl yabugud Kuykulmaypa mabapa.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoewane nanga ngapa nungu dhumawak kamelaw magadhaw aymoeyzimayl zagi mabaygaw rugal. Nungu dhadh gar gasamoey za moegi ridh goengaw, a nungu ay matha wam bupanu, a pukathal. ");
INSERT INTO mwp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mabaygal ngapa nubepa Yoerusalemoengu, a matha kedha mura Yoewdhaylgaw goegathoengu a mura Yuridhaw Koesaw goegathoengu. ");
INSERT INTO mwp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Koeygoersar mabaygan nubepa kurse pagemipu. Thana wati wakasimoeyr a nuydh thana papthayso mamayidhin Yoeridhaw Koesanu. ");
INSERT INTO mwp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoewane nuydh imadhin koeygarsar Yoewdhaylgaw yoewthaw koey mabaygal ngapa nubepa, thanamulpa paptaysoepa. Setha thana Parasayalgal a sadhusayalgal. Nuydh nanga imaydhin kedha, thanamun ubi lak kedha thana papthayso mamayin. Nuy adhamintidar thanamulpa kedha, ‘Ngay madhupamiz ngitha yoewthaw mabaygal ngapa ngayapa. Ngithamun mari igililnga ngithamulpa balbayginga lawnga midh? Ngitha midh paru ngulaygal kedha, ngitha lak kedha ngaru koey poeypiyam Awgadhaw thabukiringu? Nungu thonar senaw ngapa ngithamulpa, kasa kay kedha ngitha matha kedha mina nanga thabul muyngu akan pungamoeypa! ");
INSERT INTO mwp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Ngitha kedha mulayg, “Ngoey Abraman buway, Awgadhaw mina mabaygal.” Sena kasa ngithamun geth wakay thoemamay. Awgadhan ngulayg ngitha adhal waniz kupayngu, a wara mabaygal muy arimoeyn, ngithamun buth manin. Awgadhoepa zagethoeginga kedha, nuydh mabayg ayman kulangu, ngithamun kupaypa maypa. Kasa kay kedha mina Awgadhan bangal nanga imane ngithamun mina zageth, nuy bangal ngulayg asine kedha, ngitha mina koerkak badh gasaman wati pawapa a garkidh thayamoeyngu mina igililmaypa. Wa ngitha nanga kedha ayman nanga, ngayapa balbayginga ngithamulpa papthayso maypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nuy lak mulaydhin, ‘Ngitha a mura mabaygal matha kedha puy midh, thurik senaw buyal woeydhaypa poethaypa, sethabi puypa apa kuykuya. Puyn nanga mina koewsan mayginga, nuyn adhapa pathan a mulupa thayan muypa. ");
INSERT INTO mwp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","12","Adhapudhay koey mabayg mangedhe kay, nubepa ngithamulpa kasa ngukin papthayso maypa lawnga. Ngath nabi thonara ngitha matha ngukin papthayso mamayipa. Nuydh bangal kay ngitha mina papthayso mamayipu, a nungu paptays mina wardh. Nuydh bangal Maygi Mari ngithamuniya woenaypu, a kalmel muy. Nuydh Kuykulnga bangal ngapa nubi apa goewapa bangal balbayg tidaypa, nubiya kalmel nungu zagithaw rugal. Ngay wati moebayg, ngay matha ngoedhagidh lawnga nungu azaz sanaw urikamipa dhoerdhimaypa. Senabi goeyga bangal na ngoedhe kedha ayboewdhaw thonar midh nanga. Mina Apaw Lagaw Mabayg bangal mangedhe, nubiya nungu zagethaw rug a nuydh bangal dhadhiya dhadh mamayine mina kunaw kapul a wati zapul, ayngu noeral. Ayngu noeral, bupal, nuydh adhapa mamayin, adhamulan ingaru muypa thayan. Mina zapul ayde aymoeyn, sawalagoenu waniz.’ ");
INSERT INTO mwp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sew kalanu Yesu ngapa koesapa. Yoewane nanga imadhin kedha Yesun ubi nuydh nuyn Yesun papthayso maypa, ");
INSERT INTO mwp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","nuydh Yoewane imaypa nuthay ayman kedha, ‘Minguz ngi ngapa ngayapa ngibepa papthayso moeypa. Ngi koey mabayg, matha ngoedhagidh kedha ngidh ngoena papthayso maypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu kuniya nubepa kedha, ‘Ngoebalpa matha ngoedhagidh kedha, ngoeba ayimpa Awgadhaw ubilnga midh nanga, kedha zoengu, kuyku nidhaypa Awgadhaw yawoedhayzinga.’ Yoewane kalanu aymoedhin Yesun yangukudu ya. ");
INSERT INTO mwp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesun woerngu kalanu nungu buyal thiyay mab kadaypa koesaw buwadhoepa dapar gud pudhaydhin, a sizi ngapa mulupa Maygi Marin uruy gamu ngoedha madhin a nubiya gimal aymay. ");
INSERT INTO mwp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yangu wakay kedha seyzi pagan, ‘Ina Ngaw Geth Mamal Kazi, nuy ngayapa mina matha ngoedhagidh.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesun papthayso kalanu, Maygi Marin nuyn yoelpadhin muypa koey bupapa, Sathanalpa nubepa nuthaypa. ");
INSERT INTO mwp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nuy aygig 40 goeygilnga a 40 kubiloelnga Nungu maytha mina ayginga. ");
INSERT INTO mwp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wa, Sathana senawbi buthapa tharaydhin nuthadhin nuyn kedha, ‘Ngi nanga Awgadhaw Mina Kazi, koey bibiril mabayg, ngidh thabi kulal kidh thoeyamoeyr ngibepa aypa nginu geth yangukudun.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu nubepa kuniya buwayl thayaydhin, mamayidhin Maygi Thusiw yangukudul kedha, ‘Mabayg lawnga matha ayngu igililnga, Awgadhaw mura yangukudul ngaru mina ayde igililmaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kalanu Sathanan Yesun yoelpadhin kadaypa koey yoewthaw thodhapa muynu maygi goegathoenu Yoerusalemoenu, ");
INSERT INTO mwp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nuy kedha nubepa, ‘Ngi nanga sike mina Awgadhaw Kazi, katpoelag koezi gimaz mulupa. Maygi Thusinu waza wara Minar Poelayzinga kedha, “Awgadhan kay wayamoeypa nungu angelal ngibepa kadaypa gasamoeypa, thanamun gethan nginungu kulangu panoenamoeyle nginu ngarangu.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kedha nubepa, ‘A, wara poelayzinga Maygi Thusinu kedha, “Maygi ngidh nuthan nginu Kuykulnga Awgadh.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kalanu Sathanan nuyn yoelpadhin kadaypa mina koey padapa, danthayadhin nubepa mura nubi gugu ubidh thoeyayzinga a nanu basalayal mura adhapudhay zapul muynu. ");
INSERT INTO mwp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nuy kedha nubepa, ‘Mura ina ngath kay ngibepa poeybaypa. Ngath kay ngin Kuykulnga Awgadh, ngidh kay ngoena nanga thawmaypa a kulun pasoeynipa ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu kedha nubepa, ‘Adhapa ngaw parungu Sathana, Maygi Thusinu Minar Poelayzinga kedha, “Ngidh matha nginu Kuykulnga Awgadh thawmaypa a matha nubepa kedha apa pudhepa.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kalanu Sathanan nuyn wanan. Angelal ngapa Yesulpa, nungu gamu moegaw palan. ");
INSERT INTO mwp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nubi thonar nuydh kuyku mabaygan Yoewanen Papthayson gasamoedhin a kunumay loegoenu thayadhin. Yesu nanga karngemidhin kedha, thana Yoewanen kunumoedhin, nuy lak soersimaydhin, ");
INSERT INTO mwp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","kalanu nungu niyaylag lak lawnga Nazareth, nuy kayn goegathoepa miyaydhin, Nel Kapeniyam. Senabi goegathoenu nuydh nungu zageth kuykaymoedhin, muynu Galilayoenu malu buwadhoenu. Nabiya muynu ukasar Isoereylaw buway, Zeboelon a Napathoelay. ");
INSERT INTO mwp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nabi goeyginu Yesun buwayl thoeyayl kuyku nidhadhin Peropethaw Isayan mulayzinga kay paypa kulay kedha, ");
INSERT INTO mwp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Galilaya, war buway mabaygaw mudhaw lag, nabiya buway muynu Zeboelon a Napathoelay, amadhan malu buwadhoepa, a war doegam Uridhaw koesiya. ");
INSERT INTO mwp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ngitha mura kalmel nipa si inuraw goegathoenu, ngithamun igililnga koey gegeyadh. Ngitha bangal imane senawbi koey buya a ngitha ngaya nanga ngithamun niyay loegal koey gegeyadh, mabaygal kulay kasa um poegaypu, ngithamuniya bangal mangedhe senabi maygi buya.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Senabi thonara Yesu kuyk aymoedhin nungu zageth, maw tharepu mura moebaygoepa, a nungu ngurpan kedha, ‘Garkidh thayemiw, a guythuyamoey ngithamun wati pawal. Awgadhaw Basalaya amadhan gasamay.’ ");
INSERT INTO mwp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","War goeyginu Yesu nanga nungu mabanu woelmay Galilayaw Malu buwadhiya, nuydh imadhin ukasar kuyk kazi, Simona nungu wara nel Petheru a Andhoeru nungu tukuyap, palay pinge thayar maluya, wapipa gasamoeypa. In palamun zageth goeyga koey goersar. ");
INSERT INTO mwp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","20","Yesu kedha palamulpa, ‘Ayawal, ngapa ngaybiya asimoeriw, ngipel bangal ngaw pingew thiyay moebayg, kedha zagethapa, ngipel bangal mabaygal garwoeydhamoeypu ngayapa.’ Wara yaginga palay kuniya wanadhin palamun zageth, asimoedhin Yesuniya, nungu pasiw puziw mabayg aymoemoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Seyzi thanamun mab nuydh imoemoedhin wara ukasar kuyk kazi, Zemes a nungu tukuyap Yoewane. Palamun kalmel thathi Zebadi. Palay a palamun thathi, thana thanamun butanu, balbay tidamoeyr thanamun pingel; Yesu palay seyzi thurimoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Palay lak kedha wara yaginga, kuniya wanadhin palamun thathi a thanamun but, asimoedhin Yesuniya, aymoemoedhin nungu niyay kazi. ");
INSERT INTO mwp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesun zageth nuydh angadhin mura muynu Galilayoenu, ngurpamoeypu thanamun Awgadhaw mina yadayl. Matha kedha thanamun yoewthanu muynu yadu poelgaypu senabi mina ya, a sey sithamoeypu Awgadhaw Basalaya. Kobegadh kikirilgal nuydh doeynidhamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nungu ngulayg kangur pagamoeydhin muynu Siriyaw doegamoenu, kedha zoenguz nungu adhapudhay zageth nuydh dhoeynidhamoeypu kikirilgal, a wati mariw moelayzi mabaygal, a setha ngunu nanga kobegadh thonara gamul gegeyadh memayipu, a gamul galupepu, a setha ngunu nanga thugalal umamayl. Thabi kikiril mura, Yesu dhoeynidhamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nungu mab ngalagiya mabaygaw garsar nubiya kalmel muynu Galilayoenu a mabaygal wara ten goegathoengu, a Yoerusalemoengu, a Yoewdhayangu, a matha kedha Uridhaw koesaw war doegamoengu. ");
INSERT INTO mwp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Wara goeyginu Yesu nuydh mabaygaw garsar imadhin, nuy padiya karaypa walaydhin. Gimal padoenu nanga nuy apa thanuraydhin. Thana nungu niyaykazil garwoeydhamoeydhin nubepa, apa pudhemidhin nubiya mura wadhwadhgamuya. Nuydh nungu ngurpay zageth kuykaymoedhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘Ngitha ngaya nanga ngulaygal kedha, ngithamun geth ngarapudhamayl midh nanga a ngithamun ubi kedha ngitha lak ridh palan, ngitha ika dhiw gasamaw. Kuyk kedha Awgadhan ngithamulpa bangal ukamoene kupay muynu nungu basalayoenu. ");
INSERT INTO mwp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ngitha ngaya nanga koerkak badh a may oengamay. Awgadhaw woenab ngithamuniya kalmel; ngithamun ngoenakap bangal balbaytidane. ");
INSERT INTO mwp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ngitha ngaya nanga gabu ngoenakapulmayl, Awgadhaw woenab ngithamuniya kalmel; ngitha bangal gasamoene Awgadhaw adhapudhay yawoedhayzinga. ");
INSERT INTO mwp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ngithamun ngoenu ubilnga a wakay thamamay matha Awgadhoepa, kedha woenab ngaru ngithamuniya kalmel, nuydh bangal ngitha mina kuykunidhane. ");
INSERT INTO mwp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ngitha ngaya nanga ngithamun danal poethay kasa balbayginga mura mabaygiya, ngithamun koerkak badhan thanamulpa. Awgadhan bangal lak kedha ngithamulpa sib wanaypa, nungu danal poethay ngithamulpa lak balbayginga bangal. ");
INSERT INTO mwp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ngitha ngaya nanga ngoenakap poeyban Awgadhaw kapu zapa, ngitha ika dhiw gasamaw. Ngitha bangal Awgadh imane. ");
INSERT INTO mwp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ngitha ngaya nanga ngithamun mamoenu pathridoepa senabi kapu mam dhadhiya thabukiril mabaygiya, ngitha patharidhay mabaygan ika dhiw gasamaw. Ngitha bangal Awgadhaw kazil aymoemoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mabaygal nanga ngithamulngu ubigasimoeypa, kuyk ngithamun mina zageth, kalanu thana wati danal poethay ayman. Kasa kay kedha ngitha thanamulpa balsiyayginga. Ngitha ngulaygal kedha, sena ngitha Awgadhaw ubilnga aympa, ngitha ika dhiw gasaman, kuyk kedha Awgadhan ngithamulpa bangal ukamoene kupay muynu nungu basalayoenu. ");
INSERT INTO mwp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","‘Mabaygan bangal ngitha sole yoepa tharepu a matha kedha mulamoeypu ngitha, kuyk ngitha ngaw niyay kazil. Wa, senabi ika dhiw ngaru ngithamuniya kalmel, ngithamun koey modhabiya maypa ngithamun thathi gimal dapara. Kay paypa kulay mabaygan sethabi wati pawal aymoeydhin maygi peropethoepa. Thana sethabi wati pawal lak kedha aymoeypa kayib ngithamuniya.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Ngithamun ngoenanumaypa kedha, ngithamun igililmayl ngaru nubi apa goewanu dhadhal. Ngithamun mina zageth matha kedha kapu sol midh, ay mith palan. Ngitha nanga Awgadhaw mina ngurpay oengayginga nanga, ngithamun wati igililmayl ngoedhe kedha wati sol midh nanga, nadh nanu mina mith guythuyan. Nan lak kuniya sol aymayginga, na kasa wati za aymiz.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Ngitha matha kedha buya midh nabi apa goewapa. Buya nanga thoedhamiz, wara zapun nan woerdhayginga. Ngitha matha kedha goegath gimal padoenu. Ngitha ngaru kakal mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Koey zageth mabaygan thungi gamu woeydhan kalanu nabiya inur woergi thayan. Mina pawa kedha, nan gima gasaman zuru poethoeypa mura mabaygaw yabugudoepa mabapa kedha. ");
INSERT INTO mwp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ngitha yakaman nabi buya ngithamun igililmaynu, mabaygan iman senabi buyaw zageth ngithamun. Kuyk ngithamun kapu zageth, thana mina yoepathaman a thawmanin ngithamun Thathi gimal dapara.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu lak mulaydhin thanamulpa kedha, ‘Ngitha mura ngulaygal, Awgadhaw ya woedhayzi sabil kay paypa kulay poeybadhin Moselpa, a ngithamun ngoenanu manin sike kedha, ngay ngapa sethabi sabipa idimaypa, a matha kedha peropethaw yadhay. Lawnga! Ngay ngapa kuyku nidhaypa sethabi sabipa, matha kedha peropethaw yaday. ");
INSERT INTO mwp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngay ngithamulpa kedha, ngitha mina kurusi pagemiw a koerngayl kawra mariw, itha thabi sabil ngaru sabil, wara urapun yangukudupa pudhaypa lawnga, kurusipa dapar kasa zaginga bangal aymoene a matha kedha ina gugu ubidh thoeyayzinga mura muwasin. ");
INSERT INTO mwp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mabayg nanga adhapa ruwamiz nabi sabingu, a ngurpan war mabayg senabi wati pawan, nungu modhabiya bangal mina apal, Awgadhaw Basalayanu; a matha kedha mabayg nga balbayginga ulaypa sabiya a nuydh ngurpan war mabayg, nungu modhabiya koeyza gimal. ");
INSERT INTO mwp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngithamun kapu akasin na kedha moegina nanga, ngitha Awgadhaw Basalaya gimal gasamayginga. Thanamun nabi ngurpan getha woeyadhin mulupa kurusipa kayib.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Sena kedha, kulba ngurpan ngitha mura ngulaygal kedha. Ngitha mabayg uma mathamayg. Ngidh nanga mabayg uma mathaman, kuyku mabaygan ngin lak kedha koey dharadh manin. ");
INSERT INTO mwp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kasa kay kedha, ngay ngithamulpa muliz kedha, thabukir nginu tukuypoepa lak kedha gegeyadh, a matha kedha ngidh nanga mulamoeyn nginu tukuyap, ngin ngulayg sabipa gasaman. A ngidh rimarim pugan nginu tukuyap, a mulupa nagiz nubepa, ngi poeypiyam nginungu koey muypa thoeyayle.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Kedha kay ngidh nanga nginu eso Awgadhoepa poeyban a ngidh senabi thonara ngoenanu manin nginu tukuyap nginungu yagi asidhin. ");
INSERT INTO mwp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Wanan nginu eso sey oltanu. Ngi uzariz balbay tidar senawbi gegeyadh nginu tukuypiya, kalanu kay ngidh nginu eso Awgadhoepa poeyban. ");
INSERT INTO mwp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wara thonara mabaygan ngin thuran kotoepa, yapa sakar maypa. Kapu za kedha, ngidh ngaru kulay wakay thayiz, yoepa balbayg poelaypa nubiya. Kapu za ngidh ya balbayg palan adhal nungungu, nginungu dhoerdhimay mabaygoepa poeybayle. Kalanu nginu kuth koeyza, ngin bangal dhoerdhimay lagoenu aranu. ");
INSERT INTO mwp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngay kedha, ngibepa adhapadhaypa lawnga kunumay lagoengu, kurusipa ngidh mura nginu modhab manin thanamulpa, thana midh tharan ngibepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Ngitha mura ngulaygal, senabi kulba ngurpan kedha, ngidh wara yoepkaziya puru aymayg. ");
INSERT INTO mwp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kasa kay kedha, ngay kedha ngithamulpa, mura ngithamun noegay yoepkazipa ngithamuniya nanga wati wakay thamamay a ubilnga aymiz nabepa, ina lak kedha ngidh koey wati pawa ayman nginu wakay thamamaynu a ngoenakapoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Ngithamulpa matha ngoedhagidh midh, ngithamun mura gamu senabi koey muypa thayan lawnga midh, ngitha guythuyan urapun thugal ngithamun gamungu. Nginu purkaw noegaypa nanga ngin wati wakay thoemamaypa manin, sobaginga adhapa nagiz ngoedhe kedha ngidh midh, nan dan nalban nginu purka, matha kedha nginu getha dagam gethan wati pawa ayman, ngidh nan kazaginga adhapa manin ngoedhe kedha ngidh geth midh nanga adhapa pathan.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Wara kedha, thana yoewthaw koey mabaygal kedha, mabayg nanga dhadhpulgeman nuydh kuniya wayan nungu ipi nanu apu thathipa, nuydh ngaru peba ayman kedha, nuydh nanungu muwasin. ");
INSERT INTO mwp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kasa kay kedha ngay kedha, ngithamulpa nabi za nanga aymiz, kuykugi maypa nadh mura wati pawa aymayginga nubepa, senabi dhadh poelamay Awgadhoepa gegeyadh. Wara nadh nanga kayn alay gasaman, Awgadh ubigig, kasa kedha senabi ipidhadh gegeyadh gasaman nanu kulay alay, nungu kuykupa.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Matha kedha ngitha karngemidhin nabi kulba ngurpan kedha, ngidh ngoelkay yawoedhayzinga aymayg. Ngidh nanga nel tharan ngidh ngaru ayman senabi yawoedhayzinga pathidhayginga. ");
INSERT INTO mwp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Kasa kay kedha ngay ngithamulpa kedha, ngidh nanga kasa nginungu yangukudu manin senabi kasa yangukudu ngaru koey ridhanga gasampa nginu yawoedhayzinga. Mura itha zapul dapara, a apaw goewanu lak kedha thanamun nelngu thoerayg, kedha zoengu dapar Awgadhaw adhapudhay niyay lag a nungu ngar siyampa ipal apaw goewanu, a matha kedha Yoerusalemaw nelngu thoerayg, kedha zoengu sena kuykulmay goegath. ");
INSERT INTO mwp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A nginu kuy lak kedha thoerayg, kedha zoengu ngidh koey zageth urapun yalbup nginu kuykungu goerab gamulnga a kubikubinga ayimpa. ");
INSERT INTO mwp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Matha ngoedhagidh nginu ya woedhay yangukudu mina balbay-ginga kedha, “Wa” a “Lawnga”. Wara nanga ya ukaman palki ukasar yangukudupa sepa kedha, sena Sathanalngu, Awgadhoengu lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Ngitha karngemidhin nabi kulba ngurpan kedha, “Mabaygan ngadh nginu purka dan nalban, nungu purka lak kedha dan nalban modhabiya. Matha kedha mabaygan nanga nginu dhang pathidhan, nungu dhang lak kedha pathidhan modhabiya.” ");
INSERT INTO mwp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kasa kay kedha ngay ngithamulpa kedha, kuniya modhab thoeyayg sena wati pawa. Mabayg nanga ngibepa gegeyadh, matha kedha nuydh ngibiya getha dagam dakanu wariman, matha ngoedhagidh kedha yudhan nubepa nginu war dagam dak nubepa lak warimaypa. ");
INSERT INTO mwp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","‘Mabaygan nanga nungu koey ubi kedha, nuydh sobaginga gasaman nungu modhab nginungu. Nungu ubi nanga nuydh nginungu gabu sodh manin, wa ngidh manin nubepa, kalmel nabiya nginu sodh. ");
INSERT INTO mwp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wara thonara koewbu mabaygan nanga, ngin lupalan nungu rugaw guraypa manin urapun kilomitapa, matha ngoedhagidh ngidh ukaman wara kilomita. ");
INSERT INTO mwp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A mabayg nanga ngibepa zapa yoewdhiz matha ngoedhagidh poeybar senabi za nubepa. Mabayg nanga yoewdhiz zapa kasa thawpay thonarpa, manin nubepa senabi thawpay thonarpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Ngitha karngemidhin thanamun kulba ngurpay kedha, “Maman mamayiw ngithamun igalgal, a pasipa yawaymar ngithamun thabukiriw mabaygal.” ");
INSERT INTO mwp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kasa kay kedha, ngay ngithamulpa kedha muliz, maman mamayiw ngithamun wati igalgal, a ngoenanu mamayiw ngithamun thoeythupagaynu setha ngaya nanga ngibepa wati danal poethay ayimpa. ");
INSERT INTO mwp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‘Nginu modhabiya nginu Thathi gimal dapara ngin kay gamupathamoeypa, a aympa ngin nungu mina Mamal Kazi; kedha zoengu nuy mamal Awgadh, nuydh aymoempa goeyga zoeru a nungu kapu ari mura matha kedha ngoedhalnga mabaygal ngaya balbayginga a ngaya gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Midh kay paru ngin ibupuydhaypa ngidh nanga pud balbayg tidaypa, ngidh nanga maman mamaypa matha setha ngaya nanga ngibepa koey ubilmayl? Wati mabaygoepa lak kedha senabi kapu pawa ayimpa, matha kedha bokadhzoengu garwoeydhamay mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","48","Ngidh nanga matha nginu igalgal ayawal mamayipa, inuraw mabaygal lak kedha senabi kapu pawa aymaypa. Senabi pawa matha ngoedhagidh nabi apaw goewaw mabaygoepa, kasa kay kedha ngay ngithamulpa kedha, matha senabi mina pawa lawnga balbayginga. Awgadhaw ubilnga kedha, ngi ngaru mura doegamuya balbayginga, nginu koey Thathi gimal dapara midh nanga koey balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu lak maw sipa thanamulpa kedha, ‘Ngitha nanga nginu thoeythupoegay a siba wanay zagethal mabaygaw parunu aymaypa, kuyk kedha, ngithamun gamu dhub yoewrun, mabayg-oepa thanamulpa ngithamun zageth imaypa; kasa kay kedha sena gegeyadh. Ngidh nanga sethabi pawal aymoeypa nanga ngithamun Daparaw Thathi ngin modhabiya mayginga sethabi zagethoepa. ");
INSERT INTO mwp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kapu pawa kedha, ngitha nanga aygi zagi mabayg iman, nubepa siba wanay za poeybar gumi, gima gudiya thoerayg. Kedha mabaygal paru idemipa mabaygoepa kedha, thana kozanaw koerkakal aymoeypa, thanamun sib wanay gima gudiya muynu yoewthanu a matha kedha adhal mabaygaw parunu. Thanamun wakay thamamay kedha, mabaygan thana thawmamayin senabi pawapa. Kasa kay kedha ngay ngithamulpa kedha, thanamun modhab thana sena mabaygoengu gasaman. Mabaygan thana thawmamayipa senabi pawapa, Awgadh ubigig. ");
INSERT INTO mwp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Kapu za kedha, sib wanar aygi zagi mabayg gumi mura mabaygoepa, matha kedha gumi nginu sibaw igalgapa. Matha nginu thathi gimal dapara nuy ngulayg, nuydh kay ngin sib wanaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Nginu nanga thoeythupagay zapuyiya kedha lawnga, thana thabi mabaygal midh nanga, kasa paru idhemipa thoeythupagemipa gima gudiya, kuyk thanamun ubi mura mabaygan thana imiz muynu yoewthanu a matha kedha adhal. Ina lak thanamun modhab thana sena mabaygoengu gasaman, mabaygan kedha thawmamayipa, Awgadhoengu sib wanan lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mina pawa kedha nginu thoeythupagayl zapuyiya, muy ari nginu lagiya pasa thamudhar; yoewdi nginu Thathipa muynu, gumi mabaygoengu. Matha nginu Daparaw Thathi ngulayg, nuydh kay ngin sib wanaypa. ");
INSERT INTO mwp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Ngi nanga thoeythu pagepa, kedha lawnga inuraw mabaygal midh nanga; thanamun thoeythupagayl koey kuykuthalmayl, wakay thamayginga. Thanamun ngoenanumanin kedha, thanamun mawaw maril kay thanamulpa karngemipa, kuyk thanamun kuykuthal thoeythupagayl. ");
INSERT INTO mwp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ngitha thanamun pawapa noegayg. Na kedha zoengu, wagel kay ngi thoeythupagiz, nginu Daparaw Thathi kulay ngulayg nginu ubilnga ngoenakapoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‘Ngay ngithamulpa thoeythupagaypa ngurpaypa. Ngitha bangal kedha, thoeythupagemipu, “Ngoeymun Thathi gimal dapara, ngoeymulpa koey ubilnga nginu maygi nel thawmanin, ");
INSERT INTO mwp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","a kapu za nginu Basalaya danapa yakamiz a mura mabaygal ayman nginu ubilnga ina apal, matha kedha ngoedhalnga gimal dapara. ");
INSERT INTO mwp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ngidh ngoeymulpa matha ngoedhagidh poeybar ngoeymun nubi goeygipa ay. ");
INSERT INTO mwp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ngidh ngoeymulpa ngoeymun ipidhadh gegeyadh gud wayar, a ngoey lak kedha ngaru war mabaygaw ipidhadh gegeyadh gudwoeyamoeyn, thana mi thonara nanga ngoeymuniya bal pudhemipa. ");
INSERT INTO mwp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngidh gar ngoeymun balbayginga yabuya yoelpar, seyki setha mura nuthayl zapuya lawnga. Ngidh ngoey gudaz puydhaypa mura kedha ngoedhal wati zoengu.” ");
INSERT INTO mwp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Wa, ngay ngithamulpa kedha, wara mabaygan nanga ngibepa gegeyadh ayman, ngidh nanga gudwayan senabi gegeyadh nginu Daparaw Thathi lak kedha ngibepa nginu gegeyadhal gudwoeyamoeyn. ");
INSERT INTO mwp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngidh nanga gud woeyayginga senabi wara mabaygaw gegeyadh, nginu Thathin lak kedha ngibepa nginu gegeyadhal gud woeyayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","17","‘Wara thonara ngi nanga aygudagasin, kuyk nginu ubi ngi danal pathaypa thoeythupoegayn; kakal yakamayg senabi mina buwayl thoeyay nginu. Matha ngoedhagidh ngi buth pathiz nginu gamu a nginu rugal, kuyk senabi mina za imaygi za. Setha ngaya nanga parul noeydhemipa, thana thanamun parul gegeyadh mamayin, mabaygoepa kedha imaypa, thana aygudag asimoeyn Awgadhoepa danal pathaypa. Thanamun modhab thana sena mabaygoengu gasaman, mabaygan thana thawmamayipa, Awgadhoepa wati pawa. ");
INSERT INTO mwp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","‘Ngi nanga aygudagasin Awgadhoepa thawmaypa, mina pawa kedha, ngi mina buth pathiz, paru garwalagiz, yalbup balbay tidan, kapu ngoedha thoeyay ayman, wara mabaygoengu ngulaygoengu kedha, ngi aygudag asin. Matha nginu Daparaw Thathi ngulayg, nuydh kay ngin sibwanaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Kunubur asig nabi apaw goewaw kapu rugoepa. Setha thawpay thonaraw zapul, ngulayg moegina uruyn purthamoeyn a dhoebu asimoeyn, a ngulayg puru mabaygan purunu wardhamoeyn, setha nginu zapul. ");
INSERT INTO mwp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mina za kedha, buth pathamoeyr sethabi mina zapul a kurunu wanamoeyr ngibepa gimal dapara. Senabi lag purthayzi uruyginga, a rugal dhoebuwasiginga, a puru mabaygoeginga. ");
INSERT INTO mwp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngalaga nanga nginu kapu ubil za nginu ngoenakap ngaru sin mepa, a zagethal lak kedha thimedhalnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Nginu purka matha kedha thunge nginu gamupa. Nginu purkiya nanga balbayginga nginu mura gamu koey zoerulnga, balbayginga. ");
INSERT INTO mwp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wara kedha nginu na purka gegeyadh nginu gamu mura inur, igililnga ngaru gegeyadh. Na Nginu kasa wakay thoemamay kedha, nginu geth ngulayg mina za.’ ");
INSERT INTO mwp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Mabaygan koey zageth ukasar kuykupa zagethan meparu, wara kuyk Awgadh a wara kuyk bokadhza. Wara nuydh maman manin urapun, a wara kuykupa nuy mamagig. Nuydh matha urapun kuyku mabaygaw ubilnga ayman, a wara kuyku mabayg nuydh adhapa iman. Nginu ngoenakap nginu bokadhzapunu mepa, ngidh Awgadhaw ubilmayl aymoeyginga. ");
INSERT INTO mwp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ngay kedha zoengu ngithamulpa kedha, ngitha mingu ngithamun aypa, ngukipa koeyma ngoenanumaypa, lak ngitha igililmayl. Ngithamun igililmayl ngaru mina zapul, a ngithamun aydel kasa ngoelkay zapul. Ngithamun gamul lak kedha mina zapul, gamu rugal kasa thawpay thonarpa. ");
INSERT INTO mwp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kedha nagemiw uruypa, thanamun ubi thana warimaypa, thana thanamulpa apaw lag aymayginga, ay garwoeydhamayginga sawalagoepa; kasa kay kedha thana danal pathepa ngithamun daparaw Thathin. Ngitha nanga mabaygal, Awgadhoepa adhapudhay mamalmayl uruyiya. ");
INSERT INTO mwp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Koey zageth ngidh moegina kuykuthal palan nginu igililnga, kasa midh ngidh koeyma wakay thoemamipa. ");
INSERT INTO mwp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nginu dhoemawakupa lak kedha; nagemiw thana setha poelawal, thana zageth aymayginga, doemawakul aymayginga thanamulpa, ");
INSERT INTO mwp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngay ngithamulpa kedha muliz, thana ploewal adhapudhay rugalgal Solomon midh nanga, nuy adhapudhay kuykulnga. ");
INSERT INTO mwp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Matha Awgadhaw zageth kedha, nuydh bupaw poelawal kapu ngadh poelaypa, setha thawpay thonaraw zapul, kayib thana kapu ngoedhalmayl, bathaynga nanga thana kay asimoeyn a muypu noegidhan. Nuydh ngaru ngin rugan ubampa, nginu kapu akasin midh paru kuthuka? ");
INSERT INTO mwp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Matha ngoedhagidh kedha ngitha gegeyadh gasamayg, “Ngath kay ngalagaz ay gasampa?” a “Ngath kay ngalagaz nguki gasampa?” a “Ngath kay ngalagaz dhoemawak imaypa?” Sena inuraw mabaygaw wakay thamamay, ngitha nanga ngithamun Thathi gimal dapara, nuy ngulayg mura ngithamun thabi ubilmayngu. ");
INSERT INTO mwp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","‘Wanaw ngithamun wakay thamamay senabi Awgadhaw Basalayanu a aymaypa mura nungu ubilmayl, nuydh kay ngithamulpa ukamaypa mura ngithamun mina ubilnga. ");
INSERT INTO mwp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sepa kedha, wara bathayngoepa gegeyadh gasamayg, nanu mapul memayipa nabiya; kayib nanga nginu wakay thamamay matha kaybaw goeyga mepa. Wara goeyga nanga nabiya nanu mapul.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Yesu lak maw siparu kedha thanamulpa, ‘Sena Awgadhaw za pudhamay midh ngibepa balbayginga lawnga gegeyadh. Ngidh nanga mabaygal gegeyadh pugamoeypa, Awgadhan kay pudamaypa nginu gegeyadh. Ngidh nanga mabaygal koey dharadh zeyzinaydhemipa, Awgadhan bangal ngin lak kedha koey dharadh manine. ");
INSERT INTO mwp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","‘Mipa ngidh nubi pawa ayimpa nginu tukuypaw gegeyadh abaypa, a nginu gegeyadh nanga mina koeyza? In nabi pawa matha kedha thoekay midh. Ngi kay midh paru nubepa mulaypa thoekaypa adhapa maypa, kasa kay kedha na nginu purkanu lak kedha mina koey thoekaylnga. ");
INSERT INTO mwp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Paru idhayg, nginu purka kulay balbay tidar, lak kay ngi pudhunga nagepa nginu tukuypoepa ibupuydhaypa, thoekay adhapa maypa nungu purkangu. ");
INSERT INTO mwp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Ina ya matha ngoedhagidh ngithamun mari igililnga midh. Dhuray mabaygal thana koey kuyk walemipa, kurusipagayginga maygi yangukudupa. Thana ngurpayg sethabi maygi yangukudul, kuyk thana koey koerngaygigal Awgadhaw yapa. Thana ngoedhe kedha ngidh nginu kapu za umaypa thayan; umay kuniya buwayl thayiz a toeydiz ngibiya. Burum lak kedha nginu kapu za ngaran apapa nudhiz.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","‘Ngithamun buwayl thoeyay ngithamun Daparaw Thathipa kedha, nungu ya wadhayzinga kedha, ngitha kulay yoewdhemin ngithamun ubilmaypa, wagel kay nuydh ngithamulpa poeybaypa; sena matha ngoedhagidh ngithamulpa lumaypa. Mina lumaw senabi kapu za ngitha kay imaypa. Matha kedha ngitha pasa mathaman, Awgadhan kay ngithamulpa pudhaypa. ");
INSERT INTO mwp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Ngitha thathil ngitha ngulaygal mi za balbayginga ngithamun kazipa. Nginu kazi nanga ngibepa ay tharan, ngibepa koey zageth nubepa kulapa maypa ayngu buthoepa. ");
INSERT INTO mwp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","11","A matha kedha nuydh nanga ngibepa wapi tharan, ngidh koey zageth thabu nubepa manin. Ngithamun igililnga koey garsar zapul yoewdhepa, kasa kay kedha ngitha ngulaygal mina za ngithamun kazipa midh. Awgadhaw siba wanay ngaru mina adhapudhay ngithamulpa mura kedha, ngitha nanga nubepa yoewdhemin. ");
INSERT INTO mwp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Awgadhaw maygi sabi Moselpa poeybayzinga a nungu yangukudu peropethoepa, mura thabi zapul min tidamoeypa kedha, ngidh ngaru mam oengaypa mura mabaygoepa. Ngitha mura yaynanob ngulaygal kedha, nginu ika dhiw ngaru koeyza, mi thonara nanga wara mabaygan nungu mam pathridhan ngibepa. Ngidh ngaru lak kedha mamal zageth ayman mura mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Balbayginga kedha, muy ari moegi gudal pasa gudiya. Sena nanga koey gudal pasa gud nanu yabugudiya balbayginga mabapa, mabayg koeygarsar senabi yabugudiya, kasa kay kedha nabiya mepa wati kuth ngithamulpa. ");
INSERT INTO mwp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Moegi gudal pasa gudaw yabugud nanu mabaw lag mina koey bedhalnga, ngidh gasaman gamu kikir. Mabayg kasa moenarimayl senabi yabugudiya, kasa kay kedha nanu kuth ngaru igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Ngitha koey poeypiyam bangal, dhuray peropethal thana ngoelkay mabaygal thana ngapa ngithamulpa mamuy paru woeydhiz, ngithamulpa kedha zapa, thana Awgadhaw peropethal, kasa kay kedha thana muynu ngoedhe toeydayl uruy midh nanga. Kuyk thanamun ubi kedha, thana ngitha adhapa yoelpamoeyn Awgadhaw ngurpayngu. ");
INSERT INTO mwp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","Ngithamun bangal ngulayg asine thanamun bangal buyal thoeyayl kakal yababiya. Thana ngoedhe kedha nge puy midh pathalnga, thanamun igililnga mina koewsaginga, ngithamulpa koey zageth mina koewsa gasampa patal puyngu. ");
INSERT INTO mwp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","‘Kasa kay kedha Awgadhaw mina mabaygal ngoedhe kedha nge puy midh koey maludhoenga, kapu koewsan ubamoeypa. Nubiya wati koewsa puydhayginga. Ngoelkay mabayg ngoedhe kedha puy midh maludhoeginga, nungu koewsa moegina puydhepa, nubiya wara mina koewsa pudhayginga. ");
INSERT INTO mwp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Thabi puyngu, mi puy nanga mina koewsan mayginga, nuyn adhapa pathan a muypa thayan. ");
INSERT INTO mwp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kedha kuniya ngitha bangal mina imane sethabi ngoelkay peropethaya buyal thoeyaynu.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Koeygarsar mabaygal ngoena kedha thoeraypa, “Kuykulnga, Kuykulnga,” kasa kay kedha thabi mabaygoepa mura muya uthuypa lawnga. Matha dhuray sena daparaw basalayaw ngabepa nanga butha pathayzinga, kuyk thana mina Ngaw Thathiw ubilmayl aymaypa. ");
INSERT INTO mwp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sena kuthaw goeyga na ngapa, koeygarsar wara mabaygal bangal ngayapa kedha wal thidhampu, “Kuykulnga, Kuykulnga, ngoey nginu nel lak gima gasamarngu, kuyk ngoeymun mina zageth, a nginu Thathiw mina ngurpay seyzi gimaz ngapa pagarngu ngoeymuniya. Nginu woenabal nelngu ngoey wati maril mabaygoengu adhapa mamayirngu a dhuray koey garsar adhapudhay zagethal ngoey aymayrngu kuyk nginu nel.” ");
INSERT INTO mwp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","‘Kasa kay kedha ngaw yangukudu bangal thanamulpa kedha, “Ngay ngithamulngu koerawayg, adhapa memayiw ngaw parungu ngitha wati pawa mabaygal.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Wa, mabaygal ngaya ngapa ngayapa a karngemin ngaw yangukudul, a ayman sethabi yaday, wa balbayginga. Matha kedha mabaygan ngadh mina lag moeydhan; koey ridhanga nan kulan malan. ");
INSERT INTO mwp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Arin nanga guban gasaman, koesal kadaypa woerngu yoewrumoeyn nabi lag pathidhayginga, kedha zoengu na kulanu gimal moeydhayzinga. ");
INSERT INTO mwp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","‘A dhuray thana ngaw yaday karngemipa kasa kay kedha thana aymoeyginga ngaw ubilmayl. Thana ngoedhe kedha nge rimarim garkaz nuydh nungu lag buthunu moeydhan, ");
INSERT INTO mwp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Arin nanga guban manin, a koesa kadaypa yoewrun, koey guban senabi lag patidhadhin, nan kalanu kuykul thayan koey gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu nanga nungu ngurpay muwasin thana mina koeyma madhu pamemidhin nungu ngurpay yangukudungu, minguz kedha, nuy kasa nungu geth yangukuduya yadu umay, nuy ngoedhe mura gimal thanamun ngurpay mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Thana kedha umepu, ‘Nungu ngurpan mina wardh.’ Minguz kedha, nuy kasa nungu geth yangukuduya yadu umay, nuy ngoedhe mura gimal thanamun ngurpay mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sew kalanu Yesu mulupa pagadhin padangu, koey garsar mabaygal nubiya wagel asimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wara mabayg nuy mabayg si kikirin pungaypu, wati goengawl kikirilayg. Nuy ngapa Yesulpa, nubiya parunu kulun pasayniz, yoewdhiz nubiya kedha, ‘Ngay gar koeyma apa pudhiz ngibiya. Ngibepa balbayginga kedha, ngidh ngoena balbay tidan?’ ");
INSERT INTO mwp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nuydh nungu geth luyayadhin, gamu tharadhin nuyn kedha, ‘Wa ngaw mina ubi kedha, ngath ngin balbaytidaypa.’ Kalanu Yesu kasa yangukuduya, ya mulaydhin kedha, ‘Ngi balbayg asir kedha thonar, nginu kikiringu.’ Balbayginga senawbi thorana, nuy balbayg asidhin nungu kikiringu. ");
INSERT INTO mwp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kalanu Yesu nubepa kedha mulaydhin, ‘Nginu bangal Poeypiyam, wara mabaygoepa mulayg, ngath ngin balbay tidan. Balbayginga kedha, ngi uzar ngithamun misnarepa, nubepa ngibepa imaypa, a mina yapathamaypa kedha, ngi balbaygoesin. Sew kalanu kay ngi mer koey yoewthoepa, amaypa nginu eso. Ina Mosen Sabi yawadhayzinga nginu siba wanay za, uruy yoewdhaypa, mura imaypa kedha, ngi balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu a mura setha ngaya nanga nubiya puzimoeyr maboenu, ngabunadhin wara goegathoenu. Senabi goegathaw nel Kapeniyam. Romaniw koewbu kuyku mabayg nabi goegathaw, ngapa nubepa amadhan yoewdhiz nubiya kedha, ");
INSERT INTO mwp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","‘Ngaw geth zagethaw mabayg gar mina koey kikirilayg, nuy matha yoewipa soersimayginga. Nungu kikir mina koeyza.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kedha nubepa, ‘Wa, ngay ngibiya oesipa, ngath kay nuyn balbaytidaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kasa kay kedha nuy koewbu mabayg kuniya kedha, ‘Ngay matha ngoedhagidh lawnga ngibepa ngaw lagiya muya uthaypa. Ngibepa matha ngoedhagidh kedha kasa nginu yangukudu mar a ngaw geth zagethaw mabayg kay balbaygoesipa. ");
INSERT INTO mwp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngay ngawngu ngulayg, kuyk ngaw zageth, ngaybiya gimal ngaw mopakuykul a ngaybiya apal koewbu mabaygal zageth ulaypa. Ngay wara mabaygoepa kedha, “Uzar!” nuy uzariz. Ngay na kedha, “Aya!” nuy uzariz ngapa. Ngay ngaw danal poethay zagethaw mabaygoepa kedha, “Ina aymar!” nuydh ayman senabi zageth; a nginu yangukudu ngaru koey bibirilnga ngaybiya. Kasa nginu yangukudu manin nanga, ngaw zagethaw mabayg kay balbaygoesipa nungu kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu nanga karngemidhin Romaniw mabaygaw yangukudu, nuy Madhu pamaydhin, senabi nungu yangu, a mabaygoepa mulaydhin, thana setha ngaya nanga nubiya puzimoeyr. Nuy kedha thanamulpa, ‘Wa, Ngay kay ngithamulpa mina ya mulepa, nubi Romaniw mabaygaw mina yoepathamay mina adhapudhay. Ngath kedha ngoedhal mina yoepathamayzi mabayg kulay imayginga, matha kedha Isoereylaw buwaynu imayginga. ");
INSERT INTO mwp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngath wara mabayg imayginga kedha ngoedhalnga, muynu Isoereylanu.’ Kalanu nuydh thanamulpa ya madhin kedha, ‘Mabaygal bangal mura dagamoengu ngapa muya uthaypa Basalaya gimal dapara, apa thanuraypa kalmel Abrama, Isaka, a Yakubu, thanamuniya kalmel maypa ngaru. ");
INSERT INTO mwp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kedha kay, setha ngaya nanga kulkub karngemidhin Awgadhaw maygi yangukudul, kasa kay kedha thana mina yoepathamayginga, kuyk thana imayginga Awgadhaw ubilnga, Basalayoengu. Thanamun may a kikir bangal koeyza, thanamun bangal dhangal tikitik nudhamoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kalanu kay nuy lak buwayl thayaydhin Romaniw kuyku mabaygoepa kedha, ‘Wa, ngi uzar lagoepa, sena nginu mina yoepathaman ngibepa kay kuykinidhaypa a nginu ubilnga thoeridhiz.’ Mina balbayginga senawbi thonara nungu zagethaw mabayg balbaygoesidhin. ");
INSERT INTO mwp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kalanu Yesu miyaydhin Petherun lagoepa. Nuy nanga mangaydhin, nuydh imadhin kedha Petherun ira na sumay kikirilayg nanu uthuy lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nuydh nanu geth gasamoedhin a gamu tharadhin nan, balbayginga senabi thorana balbayg asidhin sumayngu, kadaypa miyaydhin nanu uthuy lagoengu, buth pathamoeydhin thanamulpa ayde. ");
INSERT INTO mwp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Senawbi Kutoepa nanga pudhaydhin koey garsar mabaygan ngapa memayidhin Yesulpa, thanamun kikiril igalgal dhoeynidhaypa, a matha kedha setha ngaya nanga wati mari malayzi mabaygal, Yesu thanamun mura dhoeynidhamoeydhin nungu yangukudun. Thana mura balbayg asimoeydhin thanamun kikiringu. ");
INSERT INTO mwp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nabi zageth kuykunidhadhin kay paypa kulay thonaraw peropethaw Isayan yangukudu madhin kedha, ‘Nuydh mamayine nubiya kalmel ngalpan gamu kikiril a, adhapa mamayine koey sigapa.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu nanga imadhin mabaygaw moeyay nubiya wadhwadhgam nuy nungu niyay kazipa mulaydhin kedha, ‘Ngitha ngoena mariw war dagam buwadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yesu nanga yawaraw thonara gasaman, wara sabiw mgurpay mabayg ngapa nubepa kedha, ‘Ngurpay mabayg, ngaw ubi gar ngibiya oesipa koezi kayboengu. Ngay bangal nginu gamu puziw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kedha nubepa kuniya, ‘Ngibepa matha ngoedhagidh midh? Poksal thana lagalgal, thanamun lagal arkathal boeradharoenu, a uruyl thana lak kedha moeydhamoeypa padhal thanamulpa lagal, kasa kay kedha Mabaygaw Kazi nanga ngay lagagig ngaw gamupa ngoena pudhaypa, ngaw igililnga koey mapunga.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","22","Wara Yesun niyay kazi ngapa nubepa kedha, ‘Kuyku mabayg, kedha midh, ngath mamu Ngaw Thathiw thonar ugaypa, moerama thoeyaypa nuyn. Sew kalanu kay ngay ngapa kalmel bangal ngibiya puzipa.’ Yesu nubepa kedha, ‘Ngi kedha lawnga, setha ngaya nanga kalal idimpa Awgadhiya, thana matha kedha uma mabaygal midh. Ngi aya ngaybiya asir, setha thana wani thanamun geth uma mabaygoepa moerama thoeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yawaraw thonar nanga thanamun gasaman, Yesu a nungu niyay kazin, thana mura butoenu pathemidhin. ");
INSERT INTO mwp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sizi thanamun yawar dhadhal, thanamun mina wati guban gasaman. Senabi thonar Yesu uthuy muynu. Thanamun butaw amadhan dudupay, bawal koey zapul. Niyay kaziw akal mina koey zapul. ");
INSERT INTO mwp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Thana ngapa walman Yesun kedha, ‘Danpali Kuykulnga, ibupuydhamoeyr ngalpa, wagel kay ngalpa kasa umamayl.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kedha thanamulpa, ‘Ngitha mingu mina koeyma akan memayipa, ngithamun mina yoepathamay mamu mina lawnga.’ Nubi thonara nuy kadaypa mizin, nuydh nungu yangukudun thayamoemoedhin, baw a gub mulupa pudhaydhin. Kalanu mina koey idi kayar toeydhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Setha ngaya nanga butoenu muynu mura yaynanob mina madhu pamemidhin kedha, ‘In midh paru adhapudhay mabayg. Nagemiw, bawan a guban ngulayg nubepa karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Thana nanga mangemidhin war dagam buwadhoenu, amadhan Gadarinoelgaw goegathoepa, ukasar rimarim garkaz ngapa Yesulpa. Palay koey thabukiriw mabayg, ngoedhe kedha thoeydhayl uruy midh, kuyk palamuniya muynu wati maril Sathanalngu. Palamun niyay lag uma mabaygaw mudhaw lag. Mabaygan palamulngu aka thoeyaypu. Thana koey zageth sethabi dhadhabuthiya dhadhiya pudhemin, kuyk thanamun aka, palay mina koey rimarim. ");
INSERT INTO mwp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Palay ngapa Yesulpa, koey gimiya wal memamar kedha, ‘Ngi ngapa mipa ngalbelpa! Ngi Awgadhaw Kazi. Midh kedha, ngidh kay ngalbelpa mapu maypa, kuth thoeraypa nabi thonara? Wagel kay kuthaw thonar, lawnga midh?’ ");
INSERT INTO mwp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sepal palay ngalaga nanga, sizi amadhan miyar, koey garsar buruman ay purthar. ");
INSERT INTO mwp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sethabi wati maril Sathanalngu palamuniya muynu, thana wal tidumar Yesulpa yoewdemir kedha, ‘Ngidh kay nanga ngoey adhapa wayi, ngidh ngoey kasa kobegadh lagapa woeyayg. Matha ngoedhagidh ngidh ngoey kedha burumpa wayi.’ ");
INSERT INTO mwp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kedha, ‘Wa ladhu.’ Balbayginga senabi thonara thana wati maril dhanamaydhin mabaygoengu, a burumiya uthemidhin. Sena burumaw woelak, thana mura padiya mulupa zilmemidhin, a woeray dudupamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sethabi burumaw danal pathay mabaygal imadhin senabi ngoedha thoeyay, mina koey aka gasamadhin, zilmemidhin kuniya thanamun goegathoepa, yadu thoeray aymaydhin muynu goegathoenu. Sena mura miza nanga aymoemoedhin palamulpa, kuyk wati maril. ");
INSERT INTO mwp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kalanu mura mabaygal goegathoengu ladhudhin sipa Yesu ngalaga nanga yoewdhemidhin nubiya kedha, ‘Ngi adhapa mer koezi ngoeymun doegamoengu, ngidh ngoey kasa wanan.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sew kalanu Yesu lak pathiz butoenu, nuy a nungu niyay kazil memayidhin kuniya wadagam buwadhoepa, thanamun goegathoepa. ");
INSERT INTO mwp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Thana nanga ngabunadhin kuniya nungu goegathoenu, mabaygan ngapa nubepa thanamun kikiril tukuyap dhoeynidhaypa, kuyk nungu thugalal umamayl. Nuy matha yoewir soersimayginga nungu uthuy lagoenu. Yesu nanga imadhin thanamun mina yoepathaman koeyza nuy kedha kikiril mabaygoepa, ‘Akag ngaw kazi, kapu za ngin ngapa manu; nginu ipidhadh gegeyadh mura gudwoeyamoeyn ngibepa kayib.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mura mabaygaw moeyay si nanga thanamuniya dhadhal, dhuray yoewthaw koey mabaygal, sabiw ngurpay mabaygal, thana nanga karngemidhin nungu ya, thana yaynanob kedha thanamuniya muynu, ‘In nubi mabaygan, Awgadhaw kupay nubepa purunu woerdhaypa, nuy wati mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesulpa kakal, thanamun wati wakay thoemamayil. Nuy kedha thanamulpa, ‘Ngithamuniya mingu muynu wati wakay thamamay aymiz? ");
INSERT INTO mwp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngitha koey ngulaygal kedha, palbi ukasar zageth ngaru kalmel za. Wara kedha ngay kikiril mabaygoepa muliz, “Nginu mura wati pawal gudwoeyamoeyn.” Lawnga ngay na kedha muliz, “Kaday tari a kusumar nginu uthuy rugal a mab uzar lagoepa.” ");
INSERT INTO mwp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngath ngithamulpa kakal ayman kedha, Mabaygaw Kazi kupaylnga ina apal gud woeyamoeyn mabaygaw wati pawal.’ Kalanu nuy dhagoepa buwayl thayadhin a mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nuy kalanu kaday tharaydhin, adhapa nungu uthuy lagoengu, uzaraydhin nungu lagoepa, mina matha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mabaygan nanga imadhin senabi ngoedha thoeyay, thanamuniya aka senabi adhapudhay zageth nuydh aymoedhin, thana thawmadhin Awgadh, kuyk nuydh mabaygoepa poeybadhin senabi adhapudhay kupay. ");
INSERT INTO mwp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu kalanu uzaraydhin senabi lagoengu. Nungu maboenu dhadhal nuydh imadhin bokadhzangu garwoeydhamay mabayg nungu zagethaw lagoenu nir. Nungu nel Mathayu; ina Romaniw kuyku mabaygaw poeybayzi kupay nubepa. Yesu nubepa kedha, ‘Mathayu, aya ngaybiya asir.’ Senabi yangukudunu Mathayu karngemidhin nungu thuray, kadaypa miyaydhin, wanadhin nungu zageth, aymaydhin Yesun niyay kazi. ");
INSERT INTO mwp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sew kalanu Yesu a nungu niyay kazil kalmel Mathayun lagoenu, thanamun kutaw aygud gasaman. Dhuray igalgal Mathayun, bokadhzangu garwoeydhamay mabaygal, dhuray kasa mabaygal kalmel thanamuniya aygudaw lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Thana yoewthaw koey mabaygal, Parasayalgal imaydhin nuyn Yesun a setha mabaygal nubiya. Thana kedha nungu niyay kazipa, ‘Midh paru ngithamun ngurpay mabayg kalmel aydu purathipa senawbi bokadhzangu garwoeydhamay mabaygiya, a sethabi koerngayg mabaygal; thana ngaya nanga sethabi yoewthaw sabil aymayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nanga karngemidhin thanamun Parasayalgaw ya; nuydh adhamintidan thanamulpa kedha, ‘Mabayg nanga kikirigig, nuy doktapa ubin mayginga, mabayg nga kikirilayg, wa nuy ubin miziz. Ngay ngapa mayginga mina mabaygoepa thuraypa, ngath ngaru thuran ibuypuydhan wati pawa mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kalanu nuydh thanamulpa kedha, ‘Ladhu, mina imaw Maygi Thusinu Minar Poelayzinga kedha, “Awgadhaw ubi kedha, mina pawa ngi nanga kuyk, ngidh ngaru maman manin nginu mabaygal; kedha lawnga, ngidh ngayapa nanga uruy poeyban oltanu yoewdhan.” Ngay ngapa mayginga mina mabaygoepa thuraypa, ngay ngaru wati pawa mabaygoepa thanamulpa buwayl idimpa Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sew kalanu Yoewane Papthayson niyay kazil ngapa Yesulpa, yapu poeybemin nubepa kedha, ‘Nginu niyay kazil aygudagasiginga gamupathamaypa, thoeythupagayn Awgadhoepa; ngoey a yoewthaw koey mabaygal Parasayalgal aygudoegasimoeypu koeyma thonaralnga, Awgadhoepa gamupathamoeypa, thoeythupoegayn.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu thanamulpa kedha adhamintidan, ‘Gethaw garwoeydhamay ay nanga, koey zageth mabayg aygudoeginga garwoeydhamayzi mabaygaw parunu. Nuy niyaypa yoelpayzi garkaz, nuy nanga sena kalmel mabaygan ngaru mura gasaman, aygudaginga lawnga. Wagel bangal koey thonar gasamoene a nuyn niyaypa yoelpayzi mabayg adhapa manin thanamulngu. Senabi thonara kay thana aygudoegasimoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu lak wara ya matha ngoedhoegidh aymoedhin thanamulpa, ‘Ina kayn ngurpay ngithamulpa, kayn za ngaru kayn za, a kulba za ngaru kulba za, matha kedha kulba sodhanu, ngidh ngaru kayn dhoemawak woeydhayginga. Nadh kayn dhoemawakun nan beregud palan lak yelgan, pakadaman. Koey zageth pasis woeydhamoeyn kulba sod, kayn dhoemawakun. Ngidh nanga ayman, senawbi kulba sodh lak koeyma pakadamiz. ");
INSERT INTO mwp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","‘A matha kedha umal ngukiw za, uruy goengaw aymayzinga. Kulba goengaw ngaru piranga, koey zageth mabaygan na kayn umal nguki malan kulba goengawya; kedha nanga sik waliz mina koeyma arkath dhanaman, mura idiman umal nguki a uruy goengaw. Kedha kay kayn ikay ngaru malan kayn umal ngukiw malay goengawlnu, mura zapul kay balbayginga kalanu. Wa, ngaw ngurpay matha kedha kayn za midh.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu matha yadu umay senawbi thonara nubepa ngapa urapun Yoewdhayalgaw kupay mabayg, kulun pasayniz nubiya parunu, yoewdhiz kedha, ‘Ngaw yoepkaz kazi gar guythuyan, kasa kay kedha ngaw ubi kedha, ngi aya, ngidh kay nabiya nginu geth wanaypa, poeybaypa nabepa lak igililnga, nan kay sena lak igililnga ayimpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kalanu Yesu uzaraydhin asidhin nubiya, kalmel nungu niyay kazil. ");
INSERT INTO mwp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Thanamun maboenu dhadhal wara yoepkaz na ngapa kaliya uthiz Yesulpa. Na koey kikirilayg. Nanu ubi kedha, nadh kay kasa nanga Yesun dhoemawaku kuth gamu thoeraypa, kuyk nanu ubi balbaygoesipa senabi yoepkaziw kikiringu. Nan gasamadhin muwasiginga twoeylop wathalnga na koey gabu kulka. Nadh na gamu tharadhin Yesun dhoemawaku kuth, ");
INSERT INTO mwp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","nuy kuniya buyal thayaydhin, imadhin nan nubiya kalanu. Nuy nabepa kedha, ‘Ngi akag ngaw kazi, ngin kedha zoenguz mina dhoey nidhan, kuyk nginu mina yoepathaman.’ Mina senabi thonara na yoepkaz balbaygoesidhin. ");
INSERT INTO mwp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kalanu thana gasamoedhin nungu Yoewdhaylgaw kupay mabaygaw lag. Nuy Yesu muy uthaydhin, nuydh imadhin kedha, nungu Yoewdhayalgaw mabaygaw igalgal si nir, thanamuniya kalmel dhuray na puyay mabaygal. Thana uma mabaygoepa koerkak badhaw may mar. ");
INSERT INTO mwp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nuy kedha thanamulpa, ‘Adhapa memayi ngitha mura. Sena moegina yoepkaz kasa uthuy yoewipa, na umanga lawnga.’ Thana nubepa mina yoepathamayginga. Thana kasa giwn soelmar nuyn. ");
INSERT INTO mwp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sethabi mabaygal nanga mura adhapa wayiz nuy Yesu senabi thonara muy uthiz nanu uthuy lagapa. Nuydh nanu geth nanga gasamoedhin, na kadaypa miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yadupalgadhin senabi ya mura goegathiya senabi doegumuya, Yesun zageth midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kalanu Yesu a nungu niyaykazil ladhudhin. Maboenu dhadhal ukasar maygum, palamun ubi wagel mabapa Yesulpa. Palay kedha umemar, gima gudiya, ‘Yesu, Dhawithan Kazi, ngalbe gar ibupuydhamar?’ ");
INSERT INTO mwp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nuy nanga mabaygaw lagiya ariz, palay wagel muy areman. Nuy palamulpa kedha, ‘Ngipen mina yapathamaypa midh, ngay matha ngoedhagidh ngath kay ngipel balbayg palimpa, lawnga midh?’ Palay kedha, ‘Yagar, Kuykulnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kalanu Yesu palamun purka gasaman, a kedha muliz, ‘Ngipen mina yoepathaman kedha, ngipen purkaw buya kuniya gasaman. Wa, ngipen kedha mina yoepathaman ina kuyku nidhan.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Balbayginga senawbi thonara palay palamun purkaw buya kuniya gasaman. Yesu kedha mulaydhin, koey puridharalnga palamulpa, ‘Mabaygoepa bangal mulayg, ngath miza nanga ayman ngipelpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kasa kedha palay yadu thuray aymoedhin mura goegathiya senabi doegamoenu. ");
INSERT INTO mwp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sepalbi maygum balbay tidaman nanga, senawbi thonara wara mabaygal mangemidhin Yesulpa. Thana nubepa yoelpadhin mabayg, nuy ngaru yagig kuyk nuy wati mariw malayzinga. ");
INSERT INTO mwp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kasa kay kedha Yesu midh thonara nanga geth nidhaydhin wati mari adhapa madhin nungungu, nuy yagi mabayg senabi thonara ya mulaydhin, nuy lak lawnga yagig. Mura mabaygan imadhin nuyn, thanamulpa mina ngadhagi za aymaydhin. Thana mura kidhakidhan yapupoeybemidhin kedha, ‘Kulay kedha ngoedhal za imayginga ina Isoereylanu?’ ");
INSERT INTO mwp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kasa kedha dhuray thanamuniya Parasayalgal, yoewthaw koey mabaygal. Thana kedha, ‘In Bilzibul mura wati mariw kuyk, nuydh Yesulpa kupay poeyban. Nuy kedha zoenguz ngulayg wati maripa adhapa maypa mabaygoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Senawbi thonara Yesu gurguy ulaypu mura goegathiya. Nuydh nungu ngurpay aympu muynu thanamun yoewthiya; Awgadhaw Basalaya sakar pudaypu, kapu yangu wakay thanamulpa. Nuy thanamun mura moegithap kikirin balbaytidepu. ");
INSERT INTO mwp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nuydh nanga imadhin mura mabaygal, nungu ngoenakap koey gegeyadh. Nuy koeyma asidhin thanamuniya. Minguz kedha, thanamun ngoenakap gegeyadh, a mabaygoeginga ibupudhaypa thanamulpa. Thana gar ngoedhe mamuy danal poethay mabaygoeginga. ");
INSERT INTO mwp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nuydh kedha zoengu ya matha ngoedhagidh ayman nungu niyaykazipa, ‘Itha kurusipoegayzi mabaygal, matha kedha ayboewdhaw thonara na gasaman, igililmayl ngoedhe giya aydel, mina koeygarsar kasa kay kedha zagethaw mabaygal kasa moenarimayl kedha mabaygoepa garwoeydhamoeypa Awgadhoepa. ");
INSERT INTO mwp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngitha bangal thoeythupagemipu nubepa wara zagethaw mabaygoepa ngapa woeyaypa, ayboewdhaw zagethoepa garwoeydhamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Senabi thonara Yesu nuydh nungu twoeylop niyaykazil thurimoeydhin gamupa. Nungu ubi kedha, nuydh thanamulpa kupayl kusuman kikiril mabaygoepa dhoey nidhaypa, mura wati maripa adhapa maypa, kikiril mabaygoengu a wati mariw malayzi mabaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Itha nungu niyaykazil, nungu mina woeyayzi mabaygal, thanamun nelay kedha, Simona, nungu wara nel Petheru, a nungu tukuyap Andhoeru, Zemes, a nungu tukuyap Yoewane, palay Zebadin kazi. ");
INSERT INTO mwp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Wara nelay itha kedha, Pilip a Bartholemi, Thomas a Mathayu. Nuy Mathayu kulay bokadhzoengu garwoeydhamay mabayg, a wara Zemes nuy Alpiyasan kazi, ");
INSERT INTO mwp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a wara Simona nuy kulay mina ubigig mabayg Romaniw kuyku mabaygoepa, a Yudha nuy Keriyothoelayg Yesun ngadh nanga guda aradhin yoewthaw koey mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Itha nungu twoeylop mabaygal nuydh wayamoeydhin adhapa. Nuydh thabi yangukudul thanamulpa mamayidhin, ‘Ngitha ladhu, mura Yoewdhayalgaw mabaygoepa, wara azaz mabaygaw doegampa lawnga; Samariyaw goegathoepa lawnga. Ngitha waza ngulaygal, ngay kulay muliz ngithamulpa kedha, setha Isoereylaw mabaygal guythuyayzi mamuyl, mabaygoeginga danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ladhu, ina maygi ya yadu poelgaw thanamulpa kedha, “Awgadhaw Basalaya ngapa amadhan thamiz.” ");
INSERT INTO mwp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","‘Ngitha bangal kedha zageth aymoene kay thanamuniya, kikirilgal balbaytidamoeyn, a umangu wal memayir igilpa, balbaytidamoeyn wati kikirilgal ngabiya nanga badhal gamunu, wati maril gamungu adhapa mamoeyin. In nubi za ngithamulpa modhabiginga poeybayzinga, ngitha lak kedha modhabiginga poeyban. ");
INSERT INTO mwp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Ngitha bangal wara za maygi ngithamun maboenu pasinu, a itha thabi zapul kedha, koey bokadhzapul, moegina bokadhzapul oengayg. ");
INSERT INTO mwp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bokadhzoengu yana lak oengayg, bokadhzoepa yapu poeybayg. Wara dhoemawak, a azaz san, a boegi oengayg. Ngitha kasa kedha setha ngithamuniya mi rugal nanga. Ngitha bangal mi goegathiya nanga ngaw zageth oengaypu nanga, matha thanamun kupay ngithamulpa danal poethaypa, ngitha waza ngaw zagethaw mabaygal.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Mabaygan ngadh nanga wara goegath gasaman ngithamulngu, mamu mina mabaygoepa nagemipa. Mabaygan ngadh nanga ngitha ayawal mamayin ngitha thanamuniya thuma asimoeyn ngitha mi kuykuthalnga setha memayipa; kurusipa ngidh senabi goegath wanan. ");
INSERT INTO mwp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","‘Ngitha nanga mabaygaw lagiya muy uthemin, ngitha kedha mulemin, “Awgadhaw woenab kalmel nabi lagoenu.” ");
INSERT INTO mwp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Thana nanga ngitha ayawal mamayin nanga, wa senabi woenab matha mepa senabi lagoenu. Thana nanga ngitha ayawal mayginga, wa senabi woenab lagoengu kuniya manin thanamulngu. ");
INSERT INTO mwp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi buway lawnga goegath nanga ngithamulpa kurusipoegayginga, a ayawal mayginga, wa ngitha wanan senabi goegath lawnga buway. Ngitha memayin sizi adhapa, a buthu lupemin ngithamun sanoengu, wanan senabi goegath lawnga buway. ");
INSERT INTO mwp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","‘Wa, Awgadhaw thonar sepa mepa, nuydh bangal nubi apaw goewaw zeyzineydhedhe, thanamun kedha mabaygaw kuth mina koey gegeyadh bangal. Ngay ngithamulpa kedha, kulay kay paypa Sodomalgal a Gomoroelgal, thanamun ipidhadh gegeyadh kulay koeyza, kasa kay kedha Awgadhaw kapu ngurpay mamu mina yadupalgayginga thanamun goegathiya. Nubi apaw goewaw zeyzineydhay thonara nanga gasamoene Awgadhoepa thanamulpa koey dharadh aymoeypa lawnga; kasa kay kedha kaybaw kawragigal nanga nuydh bangal koey dharadh mamayine senabi thonara, kuyk thanamun kawrag.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Ngitha kurusipagemiw, ngath kay nanga ngitha wayapa thanamulpa ngurpaypa, ngitha matha kedha mamuy midh a thana matha kedha thoeydhayl umay midh. Ngitha koey poeypiyam bangal sirisiriya uthayle, thabu midh nanga, kasa kay kedha ngitha ngaru gabu ngoenakapulmayl, thoebudh uruy midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","‘Ngitha ngaru koey poeypiyam wara mabaygoengu ngithamulngu sabiw gasamoeyle. Thana bangal ngitha palngimoeypu thanamun yoewthanu dhadhal. ");
INSERT INTO mwp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kalanu thana ngitha lak mamayipa nubi apaw goewaw adhapudhay kuyku mabaygoepa, kuyk ngitha waza ngaw gamu puziw mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ngitha sethabi zapul ngoenanu maygi, thanamun wati pawapa; kedha zoenguz kedha, thonar na gasamoeyne ngitha bangal kotoenu kaday siparuy, Romaniw kuyku mabaygiya parunu, ");
INSERT INTO mwp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","wa Maygi Marin senabi thonara bangal ngitha ngurpamoeyne, a ngitha bangal ngaru matha ngoedhagidh Awgadhaw mina ngurpaypa poeybaypa thanamulpa, adhapudhay kuyku mabaygoepa a matha kedha war mabaygoepa. Ngitha akag, senabi thonara ngithamun Daparaw Thathiw poeybayzi buth ngithamulpa ngurpay zagethoepa aymaypa. Nungu Woeyayzi Marin bangal ngaru mina yangukudul ngithamulpa poeybamoeypu ngithamun yangukudul lawnga, setha bal nungu yangukudul. ");
INSERT INTO mwp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Wa, koey sirisiril bangal mangemine, kedha thonar nanga gasaman nanga apthathkazil yaynanob bangal kidhakidhan sabinu gud aremipu uma mathamoeypa thanamulpa. Matha kedha tukuyap tukuyap, thathi kazi, a matha kedha kazil thanamun aputhathi, kasa ipidhadh gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mura bangal mabaygan wati ngoenakap gasampu ngithamulpa, minguz kedha ngitha ngaw gamu puziw mabaygal, kasa kay kedha mabaygal nanga ngaya ngaybiya ngaru kalmel kuthoepa, thana bangal matha ngoedhagidh gasamoene ngaru igililnga. ");
INSERT INTO mwp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","‘Thana nanga ngithamulpa wati danal poethay ayimpu wara goegathoenu, ngitha kasa gamungu zilmemin wara goegathoepa. Ngitha ngulaygal kedha, ngay wagel bangal Ngaw Thathipa kuniya, kasa kay kedha, ngitha ngithamun ngurpay zageth matha ayimpu, Isoereylaw goegathiya muwasiginga. Wa, senawbi thonara ngay Mabaygaw Kazi lak ngapa kuniya. ");
INSERT INTO mwp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","‘Na koey zageth kedha, ngurpay moegina kaz gimal aymiz nungu ngurpay mabaygiya, matha kedha ngitha a mura mabaygal; mabayg nanga nungu ngurpay muwasin, wa, nuy kedha ngoedhalnga ayman nungu ngurpay mabayg midh nanga. Ngitha kedha zoenguz ngaru ngulaygal kedha, thana bangal wati danal poethay ayimpa ngithamulpa. Kapu za kedha ngitha ngaybiya ngurpemin. Thana nanga ngoena mulamoeyn kedha, ngay Sathana, thana lak kedha ngitha mulamoeyne mina gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Ngitha mabaygoengu aka gasamayg, thana miza nanga ngithamulpa ayimpu. Setha mi wati pawal nanga abayzimayl imayginga, mura muy wati pawal nanga, thana bangal kakal aymoeyne, a ngaw ngurpay ngithamulpa lak kedha. ");
INSERT INTO mwp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","‘Itha mi yangukudul ngath kasa gumi poeybamoeyn ngithamulpa, kalanu kay ngitha thabi yangukudul yadu palgamoeyne mura mabaygoepa. Nubi thonara ngoedhe kedha kubil midh nanga, mura thabi zapul mabaygoepa gumi. Wagel bangal kakal aymoeyne mura mabaygoepa, matha kedha goeyga midh; ngitha bangal thanamun ngurpay mabaygal aymoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ngitha akan maygi ngaw ngurpayngu oengayle; wati mabaygaw ngulayg matha kedha ngithamun gamul idimoeypa; thanamulpa koey zageth ngithamun maripa idimoeypa. Mabaygoengu aka gasamayg, matha ngoedhagidh kedha, ngitha matha Awgadhoengu aka gasaman; minguz kedha, matha nuydh, mabaygaw gamu a mari kalmel idiman a koey muypa thayaman. ");
INSERT INTO mwp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kasa midh, moegithap zapul a uruyl ngithamun Thathin mura yawaypa, a nuy mura ngulayg. Ukasar uruy barpudhoeman urapun moegina bokadhzapun, kasa nanga urapun moegina uruy pudhiz nanga, nubepa kakal. Nungu nanga ubiginga, wa za aymoeyginga. ");
INSERT INTO mwp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ngitha lak kedha ngithamun Daparaw Thathi mura ngulayg ngithamulngu, matha kedha yalbupal midh nanga ngithamun kuykunu urapun dhadh. ");
INSERT INTO mwp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","‘Kedha kay, ngitha nubepa koey ubilmayl adhapudhay moegina uruyiya, ngitha mabaygoengu akag.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Ngitha ngaya nanga mina azirgigal ngaw nelpa kuykunidhaypa mabaygaw parunu, wa ngay bangal lak kedha aymidhe ngithamulpa, ngithamun nelay yadu palgedhe Ngaw Thathipa, ngitha waza ngaw mabaygal; ");
INSERT INTO mwp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","kasa kay kedha ngitha ngaya nanga kawragigal aymoeyn ngawngu wati mabaygaw parunu, wa ngay lak kedha kawragig ayman ngithamun nelngu, Ngaw Thathiw parunu.’ ");
INSERT INTO mwp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Ngithamulpa sike kedha, ngay na ngapa mulupa ina apal ngaru bangal koewbuginga. Lawnga, kedha lawnga, ngath pawdh ngapa manin lawnga, ngath koewbu gi manin. ");
INSERT INTO mwp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wa, ngay ngapa kedha zapa aymaypa, garkaz kazi wati igalayg aymiz nungu thathipa. Yoepkaz kazi lak kedha nanu apupa, a ipi lak kedha nanu yoepkaz irapa. ");
INSERT INTO mwp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wa, koezi pawpa mabaygaw mina buway mabaygal bangal ngaru nungu thabukiriw mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Mabaygan ngadh nanga adhapudhay maman mani nungu apu thathipa, nungu mam ngayapa matha ngoedhagidh lawnga; kedha mabayg matha ngoedhagidh lawnga ngaw puziw mabaygoepa. Kazipa lak kedha, mabaygan ngadh nanga koeyma maman mani nungu garkaz kazi lawnga yoepkaz kazi, wa nungu mam ngayapa matha ngoedhagidh lawnga, kedha mabayg matha ngoedhagidh lawnga, ngaw puziw mabayg. ");
INSERT INTO mwp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ina ya matha ngoedhagidh, mabaygan ngadh nanga sathawro oengayginga, a ngaybiya oesiginga, wa kedha mabayg matha ngoedhagidh lawnga ngaw puziw mabaygoepa aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","‘Dhuray ngaw puziw mabaygoengu bangal ngaru umamathamoeypu, kasa kay kedha mabaygal setha ngaya nanga thanamun ubi kedha, thana thanamun igililnga danal poethaypa, thana kasa guythuyamoeyne bangal thanamun igililnga. Ngadh nanga nungu igililnga kasa guythuyan kuyk nungu danal poethay ngayapa, nuy kedha mabaygan ngaru gasamoene bangal nungu igililnga. ");
INSERT INTO mwp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Mabaygan ngadh ngitha ayawal mamayin, wa nuydh matha kedha ngoena ayawal manin. Ngoena nanga ayawal manin, wa matha kedha nuyn ayawal manin, ngoena ngadh nanga wayan. ");
INSERT INTO mwp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wa, muynu kedha, ngadh nanga Awgadhaw wayayzi mabayg ayawal manin, minguz kedha nuy kedha zagethaw mabayg Awgadhaw, sepalbi ukasar mabayg kalmel Awgadhaw sib wanan gasaman; a mina mabayg lak kedha, mabaygan ngadh nanga mina mabayg ayawal manin, nuy kedha mina mabaygiya ngoenakap asin nanga, wa sepalbi ukasar mabayg kalmel Awgadhaw sib wanan gasaman. ");
INSERT INTO mwp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","‘Wa, kedha yakanurayg, mabaygan ngadh nanga ibupudhay poeyban urapun ngaw zagethaw mabaygoepa, nuy mina apal, ngayapa yakanuraypa lawnga senabi kapu zageth, kasa nguki poeyban ngaw puziw mabaygoepa nanga nuydh poeybayzi mabaygan ngaru gasaman siba wanan. Minguz kedha, senabi kapu danal poethay matha kedha ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu nanga muwasidhin ngurpay nungu niyaykazipa, thana mura ladhudhin wara goegathoepa, nubepa nungu yapa ngurpaypa. ");
INSERT INTO mwp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Senawbi thonara Yoewane Papthayso matha Zeyloenu meparuy, kunumoeyzig. Yesun adhapudhay zagethal nanga Yoewanelpa yadu palgadhin, nubiya Yoewaneniya ukasar wakay thamamay; nuy Yesu sike Mina Woeyayzig Awgadhoengu, lawnga lak wara mabayg nubiya kalanu Mina Woeyayzig. Mina ngulaygoepa gasamoeypa, nuydh Yoewane nungu geth niyaykazil wayamoeydhin Yesulpa. ");
INSERT INTO mwp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Thana Yesuniya kuyk wakayan kedha, ‘In ngi a? Awgadhaw Mina Woeyayzinga ngoeymulpa, ngath ngan nanga kulay yadu palgarngu; a lawnga war mabayg si ngapa wagel?’ ");
INSERT INTO mwp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nuy Yesu kuniya mulaydhin thanamulpa, ‘Ngitha yangukudu kuniya oengaw nubepa Yoewanelpa, mura zapul midh paru; ");
INSERT INTO mwp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","mura itha thabi mabaygal lak dhoeynidhamoeyr, maygumal balbay tidamoeyr mabagigal mabapa mamayir, wati goengawl kikirilgal lak buth pathamoeyr muwamayl kawralmayl thana lak buth pathamoeyr, umamayl thana lak igil palemoeyr, a thana aygigal zagigal, Awgadhaw kapu yangu wakay gasamar. ");
INSERT INTO mwp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngitha nubepa Yoewanelpa kedha mulemiw, “Nginu mina yoepathaman midh? Ngadh nanga ngawngu gegeyadh gasamayginga, wa, nungu ika dhiw bangal koeyza.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoewanen niyaykazil thana kuniya tidemidhin nanga, Yesu mulaydhin Yoewanen doegampa mura mabaygoepa, ‘Yoewanen maw nanga, ngithamulpa mabaygoegi dhadhabuthoenu. Ngithamun ubilnga za miyay? Ngitha kedha lawnga muku mabaygoepa imaypa, kasa kat palgipa urapu lagoenu siyayginga, ngoedhe kedha bup guban yoewimaypa, wara kuniya a wara kuniya. Ngitha mipa kedha mi ngoedhal mabaygoepa ubin maypa imaypa, adhapuydhapa? ");
INSERT INTO mwp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngitha kedha lawnga mina rugal mabaygoepa imaypa. Ngithamun na kedha ubilnga nanga, ngitha nay mopakuyku mabaygaw koey niyay lagoepa, kedha ngoedhal mabaygoepa imaypa. ");
INSERT INTO mwp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lawnga ngitha na kedha ladhudhin, mina peropethaw imaypa. Wa, ngay ngithamulpa kedha, ngitha Awgadhaw yangu mabaygoepa, Awgadhaw peropetha. Ngitha koey peropetha yawayarngu, nuy ngaru adhapudhay mura peropethaya gimal. ");
INSERT INTO mwp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‘Mina kulkub ngalbe Yoewanen ngaru yadu palgeman kedha muynu Minar Poelayzinga, “Nag! Ngath ngaw yaday woeyay mabayg bangal kulay wayane Ngibiya paruya, ngi ngaw mina adhapa Thoemayzinga. Nuydh bangal nginu yabugud buth pathane.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu lak mulaydhin thanamulpa kedha, ‘Yoewane, nungu kupay ngaru gimal mura nungu maykuykaw mabaygiya a mabaygal ngaya nubiya kulay; mabayg kulay koesimayginga, kasa kay kedha mabaygal ngaya nanga muya uthemin Awgadhaw Basalaya nanga, kasa mabayg midh, nuy nanga muy yoewthiz Awgadhaw Basalayoepa nungu igililnga ngaru gimal Yoewanen kulay igililnga midh nanga. Kuyk Awgadhaw Basalayoepa muya uthiz. ");
INSERT INTO mwp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Yoewanen ngurpay thonarngu ngapa kurusipa kayib thabukiri mabaygal gegeyadh memayipu Awgadhaw Basalayapa. Thanamun ubi kedha, thana nan gasamaypa thanamun basalayapa bangal. ");
INSERT INTO mwp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mosen Sabi a thana mura peropethal kurusipa Yoewane Papthayson thonar, thana mura yadupalgadhin Awgadhaw Basalaya. ");
INSERT INTO mwp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","‘Ngitha nanga thanamun yangukudu mina yoepathaman nanga, wa nuy Yoewane Papthayso, nuy lak kedha Elayza, ngan nanga yadu palgadhin kulkub kedha, “Nuy bangal mangedhe.” ");
INSERT INTO mwp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngitha na kawralgal nanga, wa kawran karngemiw. ");
INSERT INTO mwp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Thabi maykuyku mabaygal, thana mi ngoedhalmayl? Thana ngoedhe moegina kazil nge, zangu barpudhay lagoenu nipa. Dhuray thana moegina kazil wal mamayipa wara moegina kazipa kedha, “Ngitha mingu oesiginga ngoeymuniya, ngalpan sagulpa aymaypa. ");
INSERT INTO mwp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ngitha midh paru girel adhayginga ngoey nanga niyaypa yoelpay nathay pudhamoeypa a? Ngitha midh paru may mayginga, ngoey nanga uma mabaygaw na puyampa a? Ngitha koerkak badhoeginga?” ");
INSERT INTO mwp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","A ngitha mina koerngaygi mabaygal ngoedhe sethabi moegina kazil nge. Yoewane Papatayso nuy ngapa, nuydh amenipa ay aygudag asin, a nuy koerawayg umal ngukingu, a ngitha kedha umamoeypu, “Nubiya wati mari muynu.” ");
INSERT INTO mwp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nubiya kalanu ngay Mabaygaw Kazi na ngapa, ngay aygudoelayg a umal nguki woenile ngulayg, a ngitha kedha, “Nagemiw senabi mabaygoepa! Nuy koey aygudoelayg a koey umal ngukiw woenilayg, wati mabayg. Nuy wati mabaygiya puzipa, bokadhzoengu garwoeydhamay mabaygal a dhuray adhapa imay mabaygal.” Kasa kay kedha Awgadhaw mina za kakal yakaman, senabi mina zageth ngaru aydenga a nanu aykap ngapa kakal aymiz.’ ");
INSERT INTO mwp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kalanu nuydh mulamoeydhin sethabi goegathal, ngalagiya nanga nuydh koeygarsar adhapudhay zagethal aymoeydhin. Thana nungu zageth imadhin, kasa kay kedha thana garki thoeyayginga thanamun ipidhadh gegeyadhoengu. ");
INSERT INTO mwp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nuydh goegathaw nelay thurimoeydhin kedha, ‘Kulay ngitha Korazinalgal, wati za ngithamuniya bangal mangedhe; ngitha Bethsaydhalgal lak kedha; thana kay paypa kulay mabaygal Tayaroenu a Saydoninu nay, kedha adhapudhay zagethal imaydhin nay setha mi zagethal ngithamuniya aymoeypu, thana ngaru nay mina kulkub garki thayamoeyn, a awmaw rugal ubamoeydhin, a muyngu kunural pinimoeydhin kuykuya, thanamun wati wakasinoepa yakamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Awgadhaw minamay thonar nanga mangedhe, thana Tayaralgal a Saydonalgal lak moegina balbaygi kuth; ngitha Korazinalgal a Bethsaydhalgal ngithamulpa bangal koey gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ngitha Kapeniyamalgal ngithamun gamu dhuba yoewruy koeyza a ubi kedha, ngitha bangal ngithamulngu kaday nithamoene koeyza dapara; kasa kay kedha, ngitha bangal genoepa idimoeyne. Thana kulay mabaygal, Sodomalgal nay, kedha adhapudhay zagethal imaydhin setha mi zagethal ngithamuniya aymoeypu, thana ngaru mina kulkub garki thayamoeyn, a thanamun goegath matha memayipu nay. ");
INSERT INTO mwp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Awgadhaw minamay goeyga na mangedhe bangal, thana kulkubaw mabaygal Sodomalgal lak moegina balbayginga, ngitha nubi maykuyk bangal koey gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Senawbi thonara Yesu kedha muliz nungu Thathipa, ‘Thathi, ngi gimal Daparaw Kuykulnga a ina apal. Ngay ngibepa koeyma gud woeydhiz, kuyk ngidh mina zapul yadu poelgaypu ngurpaygi mabaygoepa, a ngurpayzi mabaygal nanga mina ngulayg mabaygal. Ngidh wara thonara wardhamoeyn thanamulngu imayle. Wa, sena nginu ubilnga koey mabayg koerawayg a moegina kaz nuy ngulayg, setha ngoenu nanga ngoenakap apal.’ ");
INSERT INTO mwp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kalanu nuy lak buyal thayadhin thanamulpa kedha, ‘Ngaw Thathi nuydh mura zapul ngayapa poeybamoeyn. Mabaygal ngawngu koerawaygal. Matha Thathi kedha ngulayg. Mabaygal lak kedha Thathingu koerawaygal, matha ngay nungu Urapun Kazi nungungu ngulayg, a matha kedha ngaya nanga ngath thanamulpa seysithaman, matha thabi mabaygal ngulaygal. ");
INSERT INTO mwp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","‘Ngitha ayawal, ngitha ngunu gamu koewba asin, ngoenakap mapungu. Aya, koezi pawpa nginu zageth kasa thowanga, ngi nanga ngaw zagethaw mabayg. Ngidh ngaw zagethaw rugal kusumoeyn, a ngawngu ngurapiz, ngaw gabu ngoenakapulnga apa pudhepa, ngidh ngaru kapu ngoenapudhay gasaman; ngoeban kalmel zageth ngaru thowanga.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kalanu kay Yesu a nungu niyaykazil, thanamun mab kunaw apaw lagiya dhadhiya; goeyga waza thanamun sabadh, kasa kedha thanamun niyay kaziw koeyma maythal aygiyasimoeyn. Thana kuyk ayman moegina kunaw poeray thanamulpa aypa. ");
INSERT INTO mwp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Thana yoewthaw koey mabaygal, Parasayalgal imadhin nanga, thana kedha umadhin Yesulpa, ‘Sepa nagi, nginu niyaykazil midh paru zageth ayimpa ngalpan sabadhaw goeyginu, thana sabi pathidhan!’ ");
INSERT INTO mwp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kuniya mulaydhin thanamulpa kedha, ngitha geth tidayginga, Maygi Thusinu muynu kedha, ‘Ngitha ngulaygal a? Kay paypa kulay ngalpan buway apakuyk Dhawitha, nuydh lak kedha za aymoedhin. Wara thonara nuy a nungu mabaygal mina maythal aygiyasimoeydhin, ");
INSERT INTO mwp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","a kusumoeydhin thanamulpa woenabal thoewa aydel sizi, kalanu purthadhin, matha koey yoewthaw niyay kaziw aydel, sethabi thoewa aydel wara mabaygoepa lawnga, sabilnga; Awgadhoepa poeybayzimayl. Nuydh kusumoedhin thanamulpa maygi bredal Awgadhaw lagoengu. Kalanu purthamoeydhin. Nuydh sabi patidhadhin, matha koew yoewthaw niyaykaziw aydel, sethabi bredal. Wara mabaygoepa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","‘Wara lak kedha, thanamun misnariw zageth midh, sey koey yoewthanu, sabathoenu? Kay paypa kulay Mose minar paladhin kedha, “Zagethan maygi sabathoenu.” Kasa kay kedha thanamun ameniw zageth matha ngoedhagidh sabadhoepa. ");
INSERT INTO mwp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wa, ngay ngithamulpa kedha, thanamulpa matha ngoedhagidh, a ngaw niyaykazipa lak kedha matha ngoedhagidh; ngitha aykap tidan a? In za mina adhapudhay, Awgadhaw koey yoewthiya. ");
INSERT INTO mwp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Awgadhaw Minar Poelayzinga kedha, “Ngay koey ubilayg lawnga mabaygaw mathamayzi uruypa yoewthanu, oltanu. Mina ngaw ubi kedha, mabaygal mura kidhakidhan ibupudhay ayman, kapu gabu ngoenakapulmayl.” Ngitha kedha yangukudu na mina tidan nanga, ngithamulpa koey zageth sethabi mina mabaygoepa mulamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mabaygaw Kazi ngay, Kuykulnga. Ngath mura yawaypa zapul matha kedha sabadhaw goeyga.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kalanu nuy uzaraydhin moegina yoewthoepa, nubiya kalmel nungu niyaykazil. ");
INSERT INTO mwp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wara kikirilayg si mepa nungu geth muwayzinga. Koey goersar mabaygal lak memayipa, thanamun ubi Yesulpa mulamoeypa. Thana kedha nubepa, ‘In matha ngoedhagidh ngalpan sabinu lawnga midh, kikirilayg lak balbay tidan sabadhoenu?’ ");
INSERT INTO mwp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nuydh yangukudu lak kuniya thayan thanamulpa, ‘Ngi nanga mamuylayg, a senabi mamuy pudhiz koey arakthoenu muynu, sabadhaw goeyginu. Ngidh midh manin, nginu mamuy? Ngidh ngaru senabi mamuy ibupuydhan. ");
INSERT INTO mwp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","In nubi mabayg adhapudhay mamuya, ngalpan sabinu matha ngoedhagidh mabayg ibupuydhan sabathoenu. Nuy mamuy lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kalanu nuy kikiril mabaygoepa buwayl thayiz kedha, ‘Geth adhapa luwayar, nginu.’ Nuydh mabaygan luwayan, a nungu geth nan balbay tidan, nungu wara geth midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Thana Parasayalgal geth wanimoeydhin thanamun wati buwayal thoeyaypa aymoeypa kedha, ‘Ngalpa bangal Yesun mathamoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Yesu nanga karngemidhin kedha, thanamun buwaylthoeyay nubepa mathamaypa, nuy uzaraydhin senabi lagoengu. Koeygarsar mabaygal nubiya kalmel. Nuydh mura thanamun kikirilgal dhoeynidhamoeydhin, kasa kedha nuy moegina koey dharadh mulaydhin thanamulpa kedha, ‘Mabaygoepa mulayg ngaw zagethaw ya.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nubi zagethan mura kuykunidhadhin Awgadhaw kulba yangukudu; Awgadh kedha nungu peropethaw Isayan gudaw ya, ");
INSERT INTO mwp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘In ngaw zagethaw mabayg, ngan nanga ngath yapaydhin a yoelpadhin, nuy mina ngaw Neydhayl Kazi, nuy ngayapa mina matha ngoedhagidh. Ngath nuyn bangal kuyku nidhane ngaw Maygi Marin a nuy bangal ngaw seysithamayzi mabayg. Nuydh bangal minamoene mabaygoepa mina matha kedha ngoedhalnga, mura nubi apaw goewaw buwaypa. ");
INSERT INTO mwp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nuy lawnga Thabukiri mabayg, nuy silamay yangukudul yaginga, gima gudiya lawnga, goegathaw mabaw lagoenu dhadhal. ");
INSERT INTO mwp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wara kedha, nungu zagethaw rugal moegina pathidhan nanga, nubepa sethabi zapupa adhathoeyaypa lawnga; nuy ngulayg sethabi zapul lak balbay tidan. Nungu zagethaw mabayg nanga matha kedha kulba tungi midh, moegina idiman, nuydh kedha mabayg lak kedha ridha palan, nungu buyangu woesimoeyle. Kurusipa mura mina pawal bangal kadaypa memayine. Wati pawal bangal mulupa. ");
INSERT INTO mwp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kalanu mura mabaygal nuyn mina yoepathamoene, nungu yangukudu bangal oengaypu.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kalanu wara mabayg ngapa Yesulpa. Nuydh nubepa madhin maygum, nuy lak yagi mabayg, kuyk nuy wati mariw malayzinga. Yesu nuyn dhoeynidhadhin a nuy mabayg lak mulaydhin, a nungu purkaw buya kuniya gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Thana mura mabaygal koeyma madhu pamemidhin. Thana kidhakidhan kedha, ‘In sike, nuy Awgadhoengu ngapa, Dhawithan Mina Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Thana Parasayalgan nanga karngemidhin thanamun ya, thana kedha umadhin, ‘Lawnga, in Bilzibul mura wati mariw kuyk nuydh Yesulpa kupay poeyban. Nuy kedha zoenguz ngulayg wati mariw adhapa moeythayle.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesulpa kakal kedha, thanamuniya muynu wati wakaythamamayil. Nuy thanamulpa buwayal thayaydhin, ya matha ngoedhagidh aymoedhin kedha, ‘Mi lagoenu nanga, nanu mabaygal kasa dhadh poelamay ayman, a kidhakidhan silamoeypu, wa kedha lag ngaru pudhiz. Goegath lak kedha, a buway lak kedha, thanamun kedha mabaygaw igililnga bangal ngaru gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kedha kay, ngitha midh paru ngoena kedha mulemin, “Sathana nuydh kupay poeyban ngibepa, nungu wati maripa idimoeypa.” Nuydh nay, kedha za na ayman nay, nungu basalaya sobaginga pudhiz. ");
INSERT INTO mwp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lawnga! Kedha lawnga. Ngay koey ngulayg kedha, ngithamun ngurpay kedha, ngithamun niyay kazil ngulayg wati mari adhapa maypa mabaygoengu. Thana ngalagaz thanamun kupay gasamadhin, thana lak Sathanalngu gasaman lawnga midh? Wa, thana ngaru zoeyzi noeydhiz ngitha, ngitha nanga kedha, na kupay ngapa Sathanalngu. (Sathanan wara nel kedha, Bilzibul.) ");
INSERT INTO mwp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","In Awgadhaw Mari ngayapa poeybayzinga, nubi poerapar wati maripa adhapa maypa. Kedha zoenguz kedha, ngitha ngaru ngulaygal kedha, Awgadhaw Basalaya in nubi thonara danapa yakampa ngithamulpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Sathana ngoedhe koey bibiril mabayg, ngibepa kasa matha nungu loegiya muya uthuypa lawnga. Nginu nanga koey magawl mabaygaw lagoengu zapa gasamoeypa ubi, ngidh ngaru kulay nuyn urukoemin yatharpa. Wagel kay ngidh nginu ubilnga ayman. ");
INSERT INTO mwp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","A ngitha sike mi dagam mabaygal? Ngadh nanga ngoena ibupuydhayginga, nuy ngawngu koeysigal, wati igalayg; a mabaygan ngadh nanga ngoena ibupuydhayginga mabaygoepa garwoeydhamoeypa, nuydh mabaygal adhapa thoemaypa, thanamun igililmayl sagul palimoeyn. ");
INSERT INTO mwp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‘Ngay ngithamulpa mina kay mina ya muliz kedha, ngitha bangal ngaru koey poeypiyam. Awgadhan ngulayg bangal mura wati pawal gud woeyamoeyne matha kedha mabaygaw Awgadhoepa kuniya ngoelkay yangukudul, Awgadhan ngulayg adhapa gud woeyamoeyn. Kasa kay kedha wara urapun za lawnga, mabaygal ngaya nanga Awgadhaw Maygi Mari mulamoeyn nanga, thanamun kedha ipidhadh gegeyadh bangal gud woeyayginga. ");
INSERT INTO mwp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","‘Mabaygal ngaya nanga, ngoena Mabaygaw Kazi mulamaypa nanga, sena balbayginga thanamun ipidhadh gegeyadh gud wayane, kasa kay kedha mabaygal ngaya nanga, Maygi Mari mulamaypa, kedha mabaygal ngaru bangal gud wayayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu lak ayman ya matha ngoedhagidh thanamulpa kedha, ‘Kapu puy nanga mina koewsalnga, wati puy nanga wati koewsalnga; kedha zoenguz kakal aymiz, mura mabaygoepa wati puyl a mina puyl. ");
INSERT INTO mwp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Ngitha Parasayalgal matha kedha wati thabu midh. Ngithamulpa koey zageth mina yapa maypa, kuyk ngithamun wati igililnga muynu. Ngitha matha kedha wati lagaw thathil midh. Ngithamun kurunu woerdhayzimayl mura wati zapul. Ngitha kedha wati ubil zapul yakamoeypu wara mabaygoepa. Wara kedha, mina mabayg nanga, nungu kurunu woerdhayzimayl mura mina zapul wara mabaygoepa yakamaypa. Mabayg nanga nubiya muynu mura wati wakay thamamayil nungu ngoenakapoenu, nungu gud lak kedha ngaru wati gud; mina mabayg nanga, nungu ngoenakap wakay thamamayil mura balbayginga, wa nungu gud lak balbayginga. ");
INSERT INTO mwp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Awgadhaw minamay thonar na mangedhe bangal, senabi goeyginu nanga ngitha a mura mabaygal ngaru zeyzinoeydhemine. Ngithamun koey yangukudul a matha kedha sagulaw yangukudul, ngaru kakal aymoeyne mina yakamaypa kedha, ngithamun igililnga muynu midh, balbayginga lawnga gegeyadh Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kalanu dhuray thanamun sabiw ngurpay mabaygal a Parasayalgal ngapa Yesulpa kedha, ‘Ngurpay Mabayg, ngoeymun ubi ngidh adhapudhay zageth ayman ngoeymulpa imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nuy thanamulpa kedha, ‘Ngitha nubi maykuyk, ngithamun kawrag mina koeyza, mina wati mabaygal. Ngitha midh paru ngoena kedha yapupoeyban? Ngayapa ngithamulpa wara adhapudhay zagethoepa aymaypa lawnga, kuyk ngitha ngoena mina yoepathamayginga. Matha urapun adhapudhay zageth ngitha imane bangal, sena mi adhapudhay zageth aymoedhin kay paypa kulay Yonan doegamunu, wa senabi adhapudhay zageth aymoeyne bangal ngithamuniya dhadhal. ");
INSERT INTO mwp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngitha ngulaygal kedha, Yona koey wapiw maythanu meparuy thoeri goeygilnga; wa, ngay Mabaygaw Kazi lak kedha bangal muy uthedhe thoeri goeygilnga koey muynu sakaynu aredhe nubi sama woeydhayzimaynu. ");
INSERT INTO mwp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","‘Lawnga! Ngithamun ngoelkay yoepathaman koeyza. Awgadhaw kuthaw goeyga nanga mura mabaygal bangal kaday nithamoene, matha kedha Ninebaw mabaygal. Na bangal kakal kedha thanamun mina yoepathaman koeyza, ngitha lawnga. Minguz kedha thana gasaman Yonan maw a thana garthi thoeyamoeydhin mura wati pawangu. Wara mabayg maw sipa in nuy ngaru koeyza Yonaniya. Ngitha mingu garki thoeyayginga? ");
INSERT INTO mwp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","‘Matha kedha wara kuyku yoepkaz Zoey doegamoengu. Kay paypa kulay na ngapa ngalpan kuyku mabaygoepa imaypa, Solomon. Na kakal aymiz kedha nanu mina yoepathaman mina koeyza, ngitha lawnga. Kedha zoenguz na uzaraydhin koeysigaz nanu boeradharoengu, koerngaypa Solomonan yoepa, a nungu mina ngurpay. Kasa kay kedha mabayg kay ngithamuniya koeyza adhapudhay Solomonaniya.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Ngath nubi maykuykaw kuth seysithamaypa ngithamulpa; mabayg sike wati mariw malayzinga, a senawbi wati mari adhapadhan mabaygoengu, nuy kasa mura loegiya ulaypa, ngukigi lag. Nuy lagiya yan lumepa nubepa uthuypa. Nuydh nanga lag gasamoeyginga ");
INSERT INTO mwp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nuy nubiya muynu kedha miziz, “Ngay lak ngaw kulay niyaylagoepa kuniya tidepa, senabi mabaygaw igililmaypa muypa.” Nuy kuniya tidiz senabi niyay lagoepa. Nuydh iman, pudhunga kapu butha poethayzinga. ");
INSERT INTO mwp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","‘Wa, wati mari lak gurguy toedipu igalgoepa lumaypa. Nuydh iman seben lak wati maril mina koey gegeyadh nubiya, a thana ngapa sin nubiya nungu niyay lagoenu. Kurusipa nungu muy yoewthayzi mabaygaw igililnga mina koey gegeyadh, kulay nuy midh nanga kuyk wati maril koeygarsar nubiya muynu.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Senawbi yanu dhadhal, Yesun apu a nungu tukuypal mangemidhin. Thana adhal nithamoedhin, thana nubepa yapa memayidhin. ");
INSERT INTO mwp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wara mabayg si amadhan kedha mulaydhin Yesulpa, ‘Sepa nagi, nginu apu a tukuypal sey adhal nithaman, ngibepa imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kuniya mulaydhin kedha, ‘Mabayg nga ngaw apu, mabaygal ngaya ngaw tukuypal?’ ");
INSERT INTO mwp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kalanu nuydh yadu palgamoeyn nungu niyaykazil kedha, ‘Ngapa nagemiw, thabi mabaygal itha, thana ngaw apu a ngaw tukuypal. ");
INSERT INTO mwp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Thana setha ngaya aymoeypa ngaw Daparaw Thathiw ubilmayl, wa kedha mabaygal ngaru ngaw tukuypal, a babthal, a ngaw apuwal.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kalanu kay Yesu wanadhin senabi lag, malu buwadhoepa uzaraydhin, niyay kazil nubiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngabunadhin nanga, mabaygaw moeyay mina koeyza thanamuniya. Yesu nanga gulpa pagadhin, nuy kasa moegina adhal thanuraydhin gulnu; thana bawadhoenu pasinu nithamadhin. ");
INSERT INTO mwp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nuydh nungu ngurpay kuykaymaydhin, ya mathangoedhagidh aymoedhin thanamulpa. Koeygarsar kedha yangukudul aymoeyr, mura war war ngurpay thanamulpa maypa. Nuy kedha thanamulpa, ‘Wara thonara, nagu uthay mabayg uzaraydhin apaw lagoepa, kunaw kapupa uthaypa. ");
INSERT INTO mwp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nuydh nanga kunaw kapul mura idiman dhoeypa. Dhuray kapul yabugudanu pudhemin uruyl ngapa purthan. ");
INSERT INTO mwp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dhuray kulal boeradharoenu pudhemir, boeradhar kuthuka a thana kapul sobaginga malguy adhan, kuyk na kuthuka, boeradhar. ");
INSERT INTO mwp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A kalanu goeygin mathamoeydhin. Minguz kedha, boeradhar kasa moegina, thanamulpa koesimoeypa matha ngoedhagidh lawnga, sipil mamu mulupa zilmayginga. ");
INSERT INTO mwp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dhuray kapul patal bupanu pudhemir. Thana na koesimir, bupan mathaman sethabi nagul, thana bibirig palimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dhuray mina boeradhariya pudhemir. Thana malguy puydhar, a koesimoeyr, a koewsa puydhemir puy kunal, wara andred, wara siksti, a wara tharti.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu kuthanu nuy muliz kedha thanamulpa, ‘Ngi nanga kawralnga, wa kurusipagi!’ ");
INSERT INTO mwp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kalanu Yesun niyaykazil ngapa nubepa amadhan thamemidhin, nubepa yapupoeybaypa kedha, ‘Ngidh midh paru ya mathangoedhagidh aymarngu thanamulpa mura thonara, kasa yangukudu aymayginga?’ ");
INSERT INTO mwp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kuniya mulaydhin thanamulpa kedha, ‘Senabi mina ngulayg ngithamulpa poeybayzinga, Awgadhaw Basalaya midh nanga, kasa kay kedha mabaygal na ngaya adhal thana kasa gimal kurusipagemipa adhamintidayzi yoepa. ");
INSERT INTO mwp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Poeypiyam kulay Awgadhoengu a kurusipagemiziw nungu yapa; ngadh nanga moegina gasaman, Awgadhan bangal nubepa poeybane mina mathangoedhagidh. Ngadh nanga tidayginga, nungungu bangal adhapa mamayine, setha nungu mi moegina zapul. ");
INSERT INTO mwp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wa, ngurpay lak kedha, thana zagigal ngaya ngurpay doegamoenu, ngath kedha zoenguz thanamulpa ya mathangoedhagidh aympu mura thonara. Thana nagemipa kasa kay imayginga, thana kurusipagemipa kasa kay thana koerngayginga, tidayginga. ");
INSERT INTO mwp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‘Kay paypa kulay peropethan Isayan mulayzinga kuykunidhan kaybaw goeyginu kedha, “Ngitha koeyma kurusipagemipu, matha tidayginga, koeyma nagemipu, matha imayginga. ");
INSERT INTO mwp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Minguz kedha, itha thabi mabaygal thanamun thigil aygimayl, a thanamun geth, thanamun kawral panidhumaypu a purkal lak kedha gud mathamoeypu. Aymayginga nay thana imaypa purkan, karngemipa kawran; thana mina gasaman Awgadhaw yangukudul thanamulpa nay. Thana kedha mabaygal nay ngayapa mina garki thayamoeyn, thana balbaytidamoeyn nay.” ");
INSERT INTO mwp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Ngitha ngaw niyaykazil bangal yakanurayg, nubi woenab ngithamul-pa adhapudhay kapu za, ngitha purkan iman, a kawran gasaman, nubi, Awgadhaw mina zapul. ");
INSERT INTO mwp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Koeygarsar maygi peropethal, a wara ngaw mina mabaygal kulay thonara, thana koey ubilgal thabi zapupa imaypa, a thabi ngurpaypa karngemipa ngithamun mi gasamayzimayl, kasa kay kedha thanamulpa lawnga, thonar matha lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Ngitha karngemiw, ngath nagu uthuy mabaygaw ya adhamintidaypa. ");
INSERT INTO mwp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dhuray mabaygal nubi Basalayaw ngurpaypa kurusipagemipa, kasa kedha thana tidayginga; senawbi ngadhathoeyay matha kedha kunaw kapul mabaw lagoenu. Awgadhaw mina ngurpay mabaygoepa thayamoeyn nanga, Sathana sobaginga ngapa adhapa manin senabi mina ya senawbi mabaygaw ngoenakapoengu, matha kedha kunaw purthay uruyl midh. ");
INSERT INTO mwp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","‘A dhuray mabaygal thanamun igilaw sakar matha kedha kapul midh kulaw boeradharoenu pudhemin. Mabayg nanga mina ngurpay karngemin, senawbi thonara nungu ika dhiw koeyza, ");
INSERT INTO mwp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kasa kay kedha senabi ngurpay mina uthuyginga, nungu igililmaypa muypa, na matha kedha kulal boeradhar midh nanga, kapu mina uthuyginga; nungu mari igililnga mamu mina lawnga. Wati danal poethay mangiz nubiya, nuy lak lawnga ngaw puziw mabayg. ");
INSERT INTO mwp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","‘Dhuray mabaygaw sakaral matha kedha patal puyl midh nanga. Mabayg nanga mina ngurpay karngemin, kasa kay kedha nuy koey ubilayg nungu gamu igililnga balbaytidaypa nubepa. Nungu ngoenakap memayipa mura nubi apaw goewaw sirisiril, a sethabi sirisiril matha kedha patal puy midh, mura Awgadhaw mina ngurpay adhapa mizin nungu igililmayngu. Nungu senawbi mabaygaw igililnga matha kedha koewsagi nagu. ");
INSERT INTO mwp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","‘Dhuray mabaygaw igilaw sakaral matha kedha mina boeradharoenu midh thoeyamoeyn. Thana mina ngurpay karngemin a tidan, thanamun igililnga kalanu koewsalmayl aymoeyn; wara thanamulngu 100 koewsalmayl, wara 60 a wara 30.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kalanu Yesu lak wara ya matha ngoedhagidh ayman thanamulpa, mura mabaygal si nubiya, ‘Awgadhaw Basalaya matha kedha nagu uthuy mabayg midh. Nuy senawbi mabayg mina kunaw kapul uthamoeyn nungu apaw lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wara kubilu mabaygal mura uthuy poelemar nanga, nungu wati igalayg mangiz, wati nagul uthumoeydhin kunaw naguya dhadhiya. Kalanu uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mura nagul na koesimoeydhin, kurusipa sethabi kunal kayn koewsalmayl aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‘Kalanu nungu zagethaw mabaygan imaydhin kedha, thana wati nagul koewsalmayl, kasa aygimayl. Thana nubepa ladhudhin a mulemidhin kedha, “Kuykulnga, ngidh mina kapul uthumoeydhin nginu apawlagiya, setha wati nagul ngalagaz ngapa?” ");
INSERT INTO mwp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nuy kedha, “Wara ngalpan thabukiriw mabayg, nuydh kedha wati pawa aymoengu.” Thana kedha, “Nginu ubi midh, ngoey sike apaw lagapa duyan thudhaypa, sethabi wati nagupa adhapa pudhaypa?” ");
INSERT INTO mwp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Nuy kedha, “Lawnga, thonar matha lawnga, ngithamulngu mina nagungu kuyk pudhayle, wati naguya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Thana ngaru kalmel koesimoeypa, kurusipa ayboewdhaw thonara. Senawbi thonara nanga ngay kedha muledhe ngaw garpathamay mabaygoepa, ngitha mamu kulay wati nagul garpathamaw, a muypa idimaw. Kalanu kay mina kunal garpathamoeyn ngaw sawalagoepa.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu thanamulpa lak kedha wara ya mathangoedhagidh ayman. Nuy kedha, ‘Awgadhaw Basalaya ngoedhe mastadaw kapu midh nanga. Mabaygan nan uthun nungu apawlagoenu. ");
INSERT INTO mwp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kulay na mina kuthuka, wara kapuginga kedha moegina, kasa kay kedha na kalanu malguyadhan a koey nagu koesimiz, adhapudhay mura wara naguya; na puy aymiz a daparaw uruyl thanamun padhal aymoeyn nabiya, thamiya.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kalanu Yesu lak wara ya matha ngoedhagidh ayman thanamulpa. Nuy kedha, ‘Awgadhaw Basalaya ngoedhe kedha yoepkazin moegina kadaypa mabal ay kusuman a urapun dram kun, kalanu nadh mura kidh thayadhin sepalbi ay, kurusipa na ay mura woeyamiz ayab, kedha zoenguz kedha nabiya kadaypa mabal ay muynu. Wa, kayib nanga mabaygal kasa moegina iman Awgadhaw zageth, na ngaru bangal koesimidhe.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nuydh mura thonara ya matha ngoedhagidhal aymoeyr thanamulpa, nuydh wara yangukudu thanamulpa aymayginga. ");
INSERT INTO mwp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nuydh ayman kedha, mina kuykunidhaypa kay paypa kulay maygi peropethaw yangukudu kedha, ‘Ngath bangal ya matha ngoedhagidhal aymoeypu thanamulpa. Ngath mina matha ngadhoegidh zapul yadu palgamoeyne thanamulpa. Nubi apaw goewaw kuykungu ngapa, mabaygal kedha ngoedhal zapul koerngayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kalanu Yesu a nungu niyaykazil wanamoeydhin mura thana mabaygal a lagapa muy uthemidhin. Thana niyaykazil nubepa, yapupoeybemidhin kedha, ‘Ngidh kay ngoeymulpa sakar maypa, setha wati nagul apawlagoenu uthuyzimayl, mina aykap midh, senabi gidhaw?’ ");
INSERT INTO mwp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nuy kuniya mulaydhin thanamulpa, ‘Aykap kedha, mina nagu uthuyzi mabayg, senaw ngay, Mabaygaw Kazi. ");
INSERT INTO mwp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","40","Senabi apaw lag matha kedha nubi apa goewa, a setha mina kapul, thana Awgadhaw Basalayaw mabaygal. Thana wati nagul nanga thana matha kedha Sathanan mabaygal. Wa nuydh sethabi wati nagul uthumoeydhin. Ayboewdhaw thonara sena matha kedha nubi apaw goewaw kuth, a thana garpathamay mabaygal, thana Awgadhaw angelal. Thana sethabi wati nagul kasa garpathamoeyne bangal, a muypa thoeyamoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","‘Wa, senawbi goeyga na mangedhe bangal, ngay Mabaygaw Kazi, ngath ngaw angelal adhapa woeyamoeyne. Thana senabi thonara mura wati mabaygal adhapa mamayipu ngaw basalayoengu, mura setha ngaya nanga ngulaygal nuthay ayimpa wara mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Thana mura wati pawa mabaygal, adhapudhay koey muypa thayamoeyne. Thana senawbi thonara koeyma may manine, a thanamun kikir mina koeyza, dhangal bangal tikitik nudhemine. ");
INSERT INTO mwp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kasa kay kedha, Awgadhaw mabaygal sethabi thonara war ngadh asimoeyne, gamul koey buwaylmayl bangal, matha kedha goeyga midh, thanamun Thathiw Basalayoenu. Ngitha ngaya nanga kawralgal, kawraw koerngaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu nuydh nungu ngurpay niyaykazipa matha ayimpa kedha, ‘Awgadhaw Basalaya matha kedha koethil za kasa gumi apawlagoenu, boeradharoenu muynu. Wara mabaygan nan iman nanga nubepa mina koey ubilnga; nungu ika dhiw mina koeyza. Kuniya nuydh lak boeradhar thayan, nan lak gud mathaman boeradhar. Nuy sobaginga uzariz; nuydh mura nungu rugal barpudhamoeyn, bokadhzapa gasamoeypa senawbi boeradhoerapa gasamoeypa nubepa. Kalanu nuydh barpudhan nan boeradhar. ");
INSERT INTO mwp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Wara kedha, Awgadhaw Basalaya matha kedha mabaygan nuydh koethil zapul lumepa, maykulal lumepu barpudaypa. ");
INSERT INTO mwp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kurusipa nuydh iman mina adhapudhay may kula. Kalanu nuy uzariz mura nungu rugal barpudhamoeyn bokadhzapun; kalanu nan adhapudhay may kula barpudhan. ");
INSERT INTO mwp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Wara kedha, Awgadhaw Basalaya matha kedha wapiw pinge maluya thayan. Mura koeygarsar wapil gasamoeyn. ");
INSERT INTO mwp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Koeygarsar na gasamoeyn nanga, thana zagethaw mabaygan kalmel imaypa wapipa, liyab dhadh maypa. Kapu wapil nanga liday arimoeypa, wati wapil kasa adhathayamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","‘Wa, nubi gugu ubidh thoeyayzimayngu kuth lak kedha, senawbi thonara thana angelal ladhune, mura wati mabaygoepa garwoeydhamoeypa adhapa thamaypa mina mabaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Setha wati mabaygal bangal mura thayamoeyne adhapudhay koey muypa. Thanamun bangal may a kikir mina koeyza, a dhangal bangal tikitik nudhemine.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kalanu nuy thanamulpa yapupoeybiz kedha, ‘Ngitha balbayginga tidamoeypa mura thabi yangukudul a?’ Thana kuniya, ‘Wa ngoey tidamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nuy kuniya mulaydhin thanamulpa, ‘Wa, ngath thabi kayn ngurpay yangukudul ngithamulpa poeybamoeydhin, koezi pawpa mura sabiw ngurpay mabaygal ngaya nanga ngaybiya asimoeyne, ngaw niyaykazil aymoeyne; thana matha kedha lagaw thathi midh nanga. Ya matha ngoedhagidh kedha, mabaygaw lagoenu muynu nungu mina koethil zapul. Nuy ngulayg nungu igalgoepa yakamoeypa, dhuray kayn zapul, a dhuray kulba zapul. Wa, ngaw ngurpay mabaygal lak kedha, thana kayn ngurpay a kulba ngurpay oengane bangal.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Senabi ngurpay kalanu, nuydh senabi lag wanadhin, nungu mina geth lagoepa kuniya uzaraydhin kalmel nungu niyay kazil. Nuydh nungu ngurpay aymaydhin thanamun yoewthanu muynu. Thana na karngemidhin nanga, thana mura mina madhu pamemidhin. Thana kedha, ‘Nuydh kedha ngurpay ngalagaz gasaman? Nuy midh paru ngulayg adhapudhay zagethoengu aymoeyle mabaygaw buth poethayle? ");
INSERT INTO mwp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nuy wara mabayg lawnga, nuy kamdaw kazi, Yoewsepan kazi. Nungu apu Mariya ina nipa, a tukuypal lak kedha, Zemes a Yoewsepa, Simona, a Yudha. ");
INSERT INTO mwp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nungu babthal lak kedha, matha itha; nuydh midh paru koey ngurpay mabaygoepa ayimpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","58","Thana kedha zoenguz nuyn mina yoepathamayginga. Nuy Yesu mulaydhin thanamulpa kedha, ‘Mura lagiya nanga peropethoepa koerngayl kawra aympa, a apasimoeypa, matha nungu goegathoenu koerngayginga mina koeyza a matha kedha nungu geth lagoenu.’ Nuydh kasa moenarimayl adhapudhay zagethal aymoeydhin, kuyk thana mina yoepathamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Senawbi thonara thanamun Galilayaw mabaygaw kuykulnga nel Erodh. Nuydh kulay uma mathamadhin Yoewane Papthayso. Kalanu nungu Erodhan puziw mabaygal nubepa kedha, Yesun adhapudhay zageth mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nuy Erodh kedha, ‘In nuy lak Yoewane Papthayso umangu kaday tharayngu. Nuy kedha zoenguz koey poerapoeralnga senawbi zagethoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wagel kay mura thabi zapul, Erodh nuydh kulay Yoewane Papthayson kunumay lagoepa gasamoedhin, kuyk nuydh nungu tukuypaw ipi nubepa madhin. Nanu nel Erodhiyas. Na kulay Erodhan tukuypaw ipi, Pilipan ipi. ");
INSERT INTO mwp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yoewane nuy Erodhalpa umepu kedha, ‘Ngipel kedha maygi, sena wati pawa, ngidh nan niyaypa yoelpaypa.’ Na Erodhiyas Yoewanelngu ubigasidhin a kalanu nuydh Erodh zeyloenu kunumoedhin Yoewanen. ");
INSERT INTO mwp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodh nuydh buwayl thayadhin nubepa umamathamoeypa, kasa kay kedha nuy akan. Minguz kedha, mura Yoewdhayalgaw mabaygal kedha, ‘Nuy Yoewane peropetha.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wara goeyga nanga Erodhan kazimay thonar, nungu ipiw Erodhiyasana ngoewakaz kazi matha nanu kusayg girel adhar Erodh a mura nungu mabaygal parunu. Nubepa mina kapu ngoedhalnga. Nungu dhiw koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nuy nabepa kedha, ‘Ngaw yawoedhayzinga ngibepa kedha, ngi mizapa ubin mepa nanga, moegina za lawnga koey za, ngath ngaru aymoene ngibepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","9","Kalanu nanu apu nabepa kedha, ‘Ngi kedha zapa yapupoeybepa, Yoewane Papthayson kuyk kedha thonar beseninu kay muynu aral.’ Wa, na ngoewakaz yapupoeybaydhin. Erodh na gasamoedhin kedha, nuydh koerkak badh gasamoedhin, kasa kay kedha nubepa koey zageth nungu yawoedhayzinga patidaypa mura mabaygaw parunu. ");
INSERT INTO mwp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Nuy kedha zoenguz nungu koewbu mabayg wayadhin. Nuy koewbu mabaygan nuyn Yoewanen kuyk patidhadhin a ngapa aradhin besininu muynu. Poeybadhin nanga ngoewakazipa, nadh nanu amalpa madhin nungu kuyk. ");
INSERT INTO mwp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kalanu nungu Yoewanen niyaykazil Erodhalpa memayidhin, nungu gamu madhin, moeramathayadhin. Kalanu thana Yesulpa nuyn yadu palgadhin. ");
INSERT INTO mwp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu karngemidhin nanga senabi yangu wakay, nuy pathaydhin butanu. Kalanu nuy matha nungu kusayg bupapa, mabaygoegi dhadhabuthoepa. Mura mabaygal nanga karngemidhin kedha, nuy pathaydhin, koeygarsar mabaygal mura sethabi goegathoengu gimiya ladhun nubiya wagel. ");
INSERT INTO mwp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nuydh war doegam buwadh gasamoedhin nanga, mabaygaw moeyay imadhin, nungu thanamulpa koeyma koerkak badh gasamoedhin. Nuydh thanamun kikirilgal buth pathamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Senabi kutapa nanga nungu niyaykazil nubepa ladhudhin a mulemidhin kedha, ‘Goeyga pawpa mizin, ina mina mabaygoegi lag aypa barpudaypa. Ngidh mura mabaygal adhapa wayamoeyn, thanamulpa thanamun kutaw aypa barpudaypa, soeyzi wara goegathoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nuy Yesu kuniya, ‘Lawnga thana matha kow, ngitha thanamulpa ayde mamayipa.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Thana mulemidhin kuniya, ‘Ngoeymuniya matha payb bredal a ukasar wapil, mabayg mina koeygarsar.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu lak mulaydhin thanamulpa, ‘Lawnga, ngitha aydel ngayapa mamayiw.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kalanu Yesu sethabi payb kunaw susul kusuman a ukasar wapi, nuy kalanu daparpa kadaypa nagaydhin a Awgadhoepa eso poeybaydhin. Nuydh kunaw susul kope tidamoeyn a nungu niyay kazipa kusuman thanamulpa mabaygoepa poeybaypa, a nuydh lak ukasar wapi kedha mamaman mura mabaygoepa. Wa, thana niyay kazil mura poeybamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Thana mura balbayginga maytha yoeruylnga, senabi ay purthadhin, na kulay kasa moegina, kasa kay kedha ay muynu koey garsar, Awgadhan senabi moegina ay kedha madhin, thana niyay kazin thadha wanayzimayn toewaylob mura liday aymoeydhin ayngu ");
INSERT INTO mwp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Thanamun mabaygaw garsar kedha, matha garkazil 5,000. Yoepkazil a moegina kazil lak koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sew kalanu nanga nuydh nungu niyay kazil wayamoeydhin butiya. Thana nubiya kulay war doegam buwadhoepa, goegath nel Bethsayda. Nuy mabaygoepa mura mulaydhin senabi thonara kedha, ‘Ladhu.’ Wa, thana mura ladhudhin kalanu. ");
INSERT INTO mwp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kalanu matha nuy padiya kadaypa walaydhin, thoeythupoegaypa. Kubilu nanga matha nuy nungu kusayg si gimal, thaythupoegayn. ");
INSERT INTO mwp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Thanamun niyaykaziw but koeysigal adhal balthayar, gub thanamulpa koeyza, butapa yawarpa gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Goeyga na amadhan nanga, Yesu thanamulpa uzaraydhin, nungu mab matha woerab gimiya. ");
INSERT INTO mwp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Thana niyaykazil na imadhin nuyn, thanamun aka koeyza. Thana kedha, ‘A! Mari senaw boey!’ Thana gima gudiya wal tiduman, kuyk thanamun aka. ");
INSERT INTO mwp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu balbayginga muliz thanamulpa senabi thonar. Nuy kedha, ‘Ngitha akan maygi, in ngay.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kalanu Petheru nubepa mulaydhin kedha, ‘Kuykulnga, senaw mina ngi a? Ngidh ngoena ngibepa mar, ngay kay lak kedha gimiya woerab uzaripa ngi midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kedha, ‘Wa aya ngayapa.’ Kalanu Petheru adhapa pagadhin butangu, Yesulpa mab uzaraydhin woerab gimiya. ");
INSERT INTO mwp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Maboenu nuydh koey gubalnga imadhin nungu purkan, nuydh aka gasamoedhin, nuy dudupaydhin mulupa woerab. Nuy walmiyaydhin kedha, ‘Kuykulnga, ngoena gasamar, ngawngu dudupoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu balbayginga nuyn gasamadhin, nubepa mulaydhin kedha, ‘Nginu kapu akasin kasa moegina, ngidh midh paru mina yapathamayginga?’ ");
INSERT INTO mwp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kalanu palay patimoedhin butanu. Balbayginga senabi thonar gub koeyma mulupa pudhadhin. ");
INSERT INTO mwp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Thana niyaykazil si butanu mina thawmadhin nuyn Yesun kedha, ‘Ngi Mina Awgadhaw Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kalanu thana wara dagam buwadhoepa thardhadhin, goegath nel Genesareth. ");
INSERT INTO mwp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sew goegathaw mabaygan nuyn imadhin nanga thana ngulaygal kedha nuy Yesu. Kalanu thana mura yadu palgadhin thanamun igalgal mura senabi doegumuya, a thana thanamun kikirilgal Yesulpa mamayidhin. ");
INSERT INTO mwp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mabayg mina koeygarsar, thana nubepa koeyma apasimir. Thana kedha nubepa, thanamulpa lak matha ngoedhagidh kedha thana nungu koey sodhaw kuth gasaman. Mura thana ngaya nanga nungu koey sodhaw kuth gasaman thana balbaygoesimoeyr senabi thonar. ");
INSERT INTO mwp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wara thonara dhuray yoewthaw koey mabaygal mangemidhin Yesuniya. Thana Parasayalgal a sabiw ngurpay mabaygal, ngapa koey mudhaw lagoengu, Yoerusalemoengu. Thana nubepa yapupoeybemidhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘Nginu niyaykazil mina pawa aymayginga, thana midh paru ngalpan thathiw thathiw ngurpay yangukudul aymayginga? Thanamun ayngu parunu thana ngalpan koey pawa aymayginga, thanamun gethoepa garwalgaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kuniya thanamulpa kedha mulaydhin, ‘Ngitha mipa yapu poeybemipa kedha? Ngitha ngithamun geth sabil aymoeypa, Awgadhaw sabil aymoeyginga. ");
INSERT INTO mwp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Awgadhaw ya kedha, “Ngidh nginu aputhathipa apapudhepa, ngidh nginu thathi, lawnga nginu apu mulamoeyn nanga, sabiw mabaygan nginu kuth tharane bangal.” ");
INSERT INTO mwp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mina pawa kedha, mabayg sike kapu rugalayg, nuydh ngaru nungu apu thathi sib wanampa. ‘Kasa kay kedha ngithamun geth pawa mina wardh; ngitha ngulaygal ngoelkay yawadhay ayimpa Awgadhoepa kedha, “Ngath wagel bangal mura thabi rugal Awgadhoepa mamayine.” ");
INSERT INTO mwp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kalanu ngitha kedha umamoeypa aputhathipa, “Yagar, mura thabi rugal ngaw lagoenu, ya woerdhayzimayl Awgadhoepa, ngayapa ngibepa poeybaypa lawnga.” Ngitha ruwamaypa Awgadhaw sabingu, ngithamun ngurpaypa. ");
INSERT INTO mwp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ngitha kasa gimiya muk, muynu loka thoeydhaylmayl. Kay paypa kulay maygi peropeth Isaya, Awgadhaw yangkudu yadu palgadhin kedha, ngithamun wati pawapa yakamaypa, ");
INSERT INTO mwp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Sethabi mabaygal ngoena thawmanin thanamun gudan, kasa kay kedha ngoenakap koeysigal. ");
INSERT INTO mwp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Thanamun thawmay wara mina aykapuginga, thana kasa gub sagul poelaypa thawmaythu, a thanamun mina ngurpay kasa koew apa goewaw mabaygaw aymayzimayl, Awgadhaw aymayzimayl lawnga.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kalanu nuydh mura mabaygal thuremoeydhin nubepa. Nuydh kedha ngurpay aymoedhin thanamulpa, ‘Ayawal, kawral bal thayamoey mina ngulaygoepa gasamoeypa. Mabayg midh paru nungu igililnga danal poethaypa, mura wati zoengu igililmayngu kusikus poelayle. ");
INSERT INTO mwp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Setha mi zapul nanga ngunu muy uthemipa, thana lawnga kusikus poelaypa. Matha setha mi wati zapul adhapadhamoeyn nungu gudiya, sethabi zapul nuyn kusikus poelaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kalanu nungu niyaykazil ngapa nubepa kedha, ‘Ngidh imadhin a? Thana Parasayalgal gegeyadh gasamoedhin nginu ngurpayngu.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nuy kuniya mulaydhin, ‘Thana matha kedha wati nagu midh. Sethabi wati nagul ngaw thathiw uthuyzimayl lawnga, kurusipa sethabi wati nagul ngaru adhapa idiman. ");
INSERT INTO mwp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ngitha thanamulpa wakay thoemamayg; thana kuyku mabaygal, mabaygaw yoelpay mabaygal matha kedha maygum midh. Kedha ngoedhal mabayg a nungu yoelpayzi mabayg ngaru pudheman koey muydhoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petheru mulaydhin kedha Yesulpa, ‘Ngi ngoeymulpa muli, senabi nginu ya matha ngoedhagidh, nanu aykap midh?’ ");
INSERT INTO mwp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kedha mulaydhin, ‘Ngitha mipa matha tidayginga, matha kedha mura mabaygal midh? ");
INSERT INTO mwp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Setha mi aydel nanga, mabaygaw gudiya muy uthiz, thana kalanu nungu maythiya, kurusipa lak adhapadhan nungu gamungu. Thana muynu ngoenakapoenu mayginga. ");
INSERT INTO mwp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","‘Kasa kay kedha, setha mi wati wakaythamamayil mabaygaw gudiya adhapadhan, nungu yangukudul, thana ngalagaz ngapa, thana nungu ngoenakapoengu. Itha thabi zapul mabaygaw igililinga kusikus palan kedha; ");
INSERT INTO mwp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","thana nuthay wakay thamamayil, mabayg ruwaman wati doegampa kedha, wara mabaygoepa uma mathamaypa, mabaygaw purupa aymaypa, a wara lak kedha wati pawal. Ngitha koey poeypiyam bangal thabi zapungu aymoeyle, purungu aymoeyle, solingu aymoeyle, lawnga wara mabaygoengu egiparayle. ");
INSERT INTO mwp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Itha thabi zapul kusikus palan mabaygaw igililnga. Thanamun Parasayalgaw koey pawa kedha, thana thanamun gethal koeyma garwoelgaypa. Kedha za kasa thanamun geth wakaythamamay, Awgadhoepa mina pawa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kalanu Yesu a nungu niyaykazil wanaydhin senabi dagam, Kananaw mabaygaw doegampa. Thanamun koey goegath ukasar, Thayar a Saydon. ");
INSERT INTO mwp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wara sew yoepkaz ngapa Yesulpa. Na kedha, ‘Kuyku Mabayg, ngay ngulayg kedha ngi Awgadhoengu ngapa, Dhawithan mina kazi. Ngay ngibepa koeyma yoewdhiz kedha, ngidh kay ngoena ibupuydhaypa? Ngoezu yoepkaz kazi gar wati mariw malayzi mabayg, na mina koey gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kasa kay kedha Yesu nabepa yagig. Nungu niyaykazil nubepa yapupoeybemidhin kedha, ‘Yoepkaz na wal mepa, na koeyma puzir ngalpaniya, ngidh gar kay nan adhapa wayar?’ ");
INSERT INTO mwp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu mulaydhin kedha, ‘Koeygarsar Isoereylaw mabaygal matha kedha guythuyayzi mamuy midh, ngoena ngapa wayan thanamulpa ibupuydhaypa, ngaw zageth kedha.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yoepkaz nadh karngemidhin kedha, na mulupa pudhaydhin Yesuniya, nanu paru boeradharapa thayan koeyma yoewdhiz kedha, ‘Kuykulnga, ngoena ibupuydhar?’ ");
INSERT INTO mwp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nuy nabepa mulaydhin, ya matha ngoedhagidh aymoedhin kedha, ‘Na matha ngoedhagidh lawnga kedha, ngath moegina kaziw ay manin thoebudh umaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na kuniya mulaydhin nubepa, ‘Kuykulnga, ngi mina yadu umepa, kasa kedha thana thoebudh umayl ngulaygal wanayzi ay purthaypa, thanamun kuyku mabaygaw aygudoezinga.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu kuniya mulaydhin, ‘Ngi mina yoepathamayzi apu! Wa, ngibepa ayman, matha kedha nginu ubilnga midh.’ Balbayginga senabi thonara nanu yoepkaz kazi balbaygoesidhin. ");
INSERT INTO mwp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kalanu Yesu a nungu niyaykazil kuniya ladhudhin, Galilayapa. Thana malu buwadhiya ladhudhin, kalanu padiya kadaypa walemidhin. Nuy si apathanuraydhin. ");
INSERT INTO mwp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Koeygarsar mabaygal nubepa ngapa, thanamun kikirilgal angamoeydhin nubepa, mabagigal, ngaral gegeyadh mabapa, maygumal, yagigal, a koeygarsar dhuray wara kikirilgal, thana nubepa mamayidhin. Nuydh thana mura dhoeynidhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Thana mura mabaygal madhu pamemidhin kedha, yagigal mulemidhin, mabaygaw bibirig asizi thugalal lak balbay tidamoeyr, mabagigal ngaral gegeyadh nuydh lak balbay tidamoeyr, a maygumal thanamun purkaw buya kuniya gasamoemoeyr. Thana mura mabaygal thawmadhin Awgadh, Isoereylaw Awgadh. ");
INSERT INTO mwp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu nuydh nungu niyaykazil thuremoeydhin, thanamulpa kedha mulaydhin, ‘Ngaw kasa koerkak badh mizin mura thabi mabaygoepa. Thana matha ngaybiya puzimoeyr thoeri goeygilnga. Thana mina aygudagasin. Ngaw ubiginga kedha, thana kasa kuniya wayamoeyn maytha aygimayl, thanamulngu bibirig oesile maboenu dhadhal.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Thana niyaykazil kedha, ‘Ina mina mabaygoegi lag, ngalpa ngalagaz ay gasamaypa kedha koeygarsar mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu yapupoeybaydhin kedha, ‘Ngithamuniya midh mura kunaw susul?’ Thana kuniya mulemidhin, ‘Kunaw susul matha seben mura a moenarimayl moegina wapil.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kalanu nuy mura mabaygoepa mulaydhin kedha, ‘Ngitha sew apa thayaw boeradharoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kalanu Yesu kusumadhin sethabi kunaw susul, kalanu eso poeybaydhin. Nuydh kunaw susul kope tidamoeyn a nungu niyay kazipa kusuman a thana poeybamoeydhin mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Thana mabaygal mura purthamoeydhin. Thanamun maythal mura yoerimoeydhin. Kalanu thana niyaykazil wanayzi aydel garpathamamoeydhin, seben lidhay mura. ");
INSERT INTO mwp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Purthayzi mabaygal 4,000 garkazil. Yoepkaziw, moegina kaziw garsar gasamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kalanu Yesu mura mabaygal kuniya wayadhin. Kalanu nuy wara dagam buwadhoepa pathaydhin butiya, lag nel Magadhan. ");
INSERT INTO mwp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wara thonara dhuray Yoewdhayalgaw koey mabaygal Yesulpa memayidhin, dhuray thana Parasayalgal a dhuray Sadusayalgal. Thanamun ubi kedha, thana nuyn karum palan, nuthay ayimpa nubepa. Thanamun kasa ubi kedha thana mura mabaygoepa yakamaypa kedha, nungu poerapar mamu mina lawnga. Thana nuyn kedha yapupoeyban, ‘Ngidh adhapudhay zageth aymar mina kuykunidhaypa kedha, ngi kupaylnga Awgadhoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu nuy kuniya muliz thanamulpa, ‘Ngitha midh paru, wara maku lumaypa? Ngitha mura daparaw maku tidamoeypu, ariw thonar a arigi thonar. Goeyga pudhiz nanga zibazib koey kulka gamulnga, wa ngitha ngulaygal kedha, “Bangal ariginga.” ");
INSERT INTO mwp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mina bathaynga wara, ziyal sike koey kulka gamulmayl, a kubikubimayl, ngitha ari tidan, kasa kay kedha ngithamulpa koey zageth Awgadhaw thonaral tidamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","‘Koeygarsar thonaral woenayzimayl Awgadhaw ngithamulpa yakamoeyzimayl. Ngitha midh paru wara makupa lumaypa, wara adhapudhay zageth yapupoeybaypa? Ngitha nubi maykuyk adhapudhay koerngaygigal Awgadhoepa. Ngitha adhapudhay zageth lumaypa ngaybiya. Lawnga matha urapun adhapudhay zageth ngithamulpa yakamoene bangal. Sena mi adhapudhay zageth aymoedhin kay paypa kulay Yonan Doegamoenu, wa senabi adhapudhay zageth aymoeyne bangal ngithamuniya dhadhal.’ Kalanu nuydh kasa wanaydhin thana. ");
INSERT INTO mwp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kalanu Yesu a nungu niyaykazil war doegam buwadhoepa memayidhin. Thana niyaykazil bredal oengayginga, yakanuriz thanamulngu. ");
INSERT INTO mwp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","7","Yesu nanga thanamulpa mulaydhin kedha, ‘Ngitha koey poeypiyam bangal thanamun gamu dhub yoewrayle, thana Parasayalgal a Sadusayalgal.’ Thana niyaykazil kedha buyal thayadhin kidhakidhan, ‘Nuy kedha zoengu bredoepa muliz, ngalpalngu bred yakanurema.’ Thana tidayginga kedha nuydh ya matha ngoedhagidh aymar. ");
INSERT INTO mwp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesulpa kakal thanamun yangukudu ya midh, nuy kedha, ‘Ngitha midh paru ngalpan aypa wakay thoemamoeypa kedha, “Ngalpa bredagigal”? Ngithamun mina yoepathaman kasa moegina. ");
INSERT INTO mwp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ngitha lak tidayginga lawnga midh? Senabi thonar ngath payb kunaw susul pathidhamoeydhin 5,000 mabaygoepa, ngitha midh mura wanayzi aydel garpathamoeydhin lidhay wangamoeydhin? ");
INSERT INTO mwp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kalanu seben bredal pathidhamoeydhin 4,000 mabaygoepa, lidhay midh mura? ");
INSERT INTO mwp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngitha midh paru bredoepa wakay thamaypa. Ngalpalpa kedha zapa wakay thamaypa lawnga. Ngitha bangal koey poeypiyam thanamun gamu dhubaw yoewrayle, thana Parasayalgal a Sadusayalgal.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kalanu thana gasamadhin kedha, senabi ya nungu, matha ngoedhagidh thanamulpa. Senabi gamu dhub yoewrayle matha bredoenu lawnga. Nanu aykap kedha, thana ngaru koey poeypiyam Parasayalgaw ngurpayngu a Sadusayalgaw ngurpayngu. ");
INSERT INTO mwp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kalanu thana ladhudhin wara doegampa, koey goegath amadhan nel Sizariya Pilipay. Amadhan nanga Yesu nuydh nungu niyaykazil yapu poeybamoeydhin kedha, ‘Mabaygaw wakay thamamay midh, in ngay Mabaygaw Kazi, midh paru mabayg? Ngay nga?’ ");
INSERT INTO mwp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Thana mulemidhin kedha, ‘Mabaygal kedha, ngi umangu lak igililnga. Wara kedha, ngi Yoewane Papatayso. Wara kedha, ngi Elayza, a wara kedha, ngi Eremiya lawnga wara kulkubaw peropetha.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nuy lak, yapupoeybaydhin kedha, ‘Ngithamun wakay thamamay midh, ngay nga?’ ");
INSERT INTO mwp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petheru, nuy kuniya mulaydhin kedha, ‘Ngi mina Keriso, ngapa Woeyayzi Mabayg Awgadhaw mina Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesun yangukudu ya kedha, ‘Ngayapa kakal, Awgadhaw wenoewen ngibiya kalmel, Simona Yonan Kazi. Ngidh senabi ngulayg mabaygoengu gasamayginga, matha Ngaw Thathi dapara, sena nungungu poeybayzinga ngibepa. ");
INSERT INTO mwp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wa, nginu wara nel Petheru (aykap muynu kedha, kula) a nubi kula nuy ngaw ekaloesiyaw kuyk. Senabi ekaloesiya na matha mepa koezi pawpa ngaru ngaru, zaginga nabepa muwasipa. Dhuray nanu mabaygal bangal um pudhepu, na bangal ekaloesiya matha meparuy. ");
INSERT INTO mwp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ngath ngithamulpa poeybamoeyne bangal Daparaw Basalayaw gud pudayzi kilay. Ngitha ngaw mabaygal kupaylmayl kedha minamay zagethoepa; midh zapun nanga ngitha gud mathamaypa itha apal, wa kedha zapul lak kedha gud mathamoeyn sey gimal dapara; a midh zapul nanga ngitha gud pudhaypa itha apal, wa sethabi zapul lak gud pudhamoeyn gimal dapara.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kalanu nuydh thana niyay kazil koey dharadh gud wadhamoeydhin mabaygoepa mulayle kedha nuy Keriso. ");
INSERT INTO mwp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Senawbi thonarngu pawpa nuydh mina kakal ngurpamoeyngu nungu niyaykazil kedha, ‘Kalanu bangal ngay ngaru Yoerusalemoepa a nanu koey mabaygal ngayapa mina wati danal poethay aymoeyne bangal. Thanamun koey mabaygal, kuyku misnarel, a sabiw ngurpay mabaygal bangal ngoena kedha mayparuy, thana ngoena umamathamoene. Thoeri goeygi kaliya ngoena bangal lak kaday tharane igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kalanu Petheru Yesun moegina adhapa yoelpadhin, a nubepa kedha mulaydhin, ‘Kedha maygi, Awgadhaw woenab ngin danal poethaypa kedha wati zoengu. Ngayapa adhapudhay gegeyadh, ngibepa nanga kedha za aymoene bangal.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu buwayl thayadhin Petherulpa, ‘Ngaybiya kaliya thoeyay, ngi ngoedhe Sathana, ngi kasa panidhay za ngaw mina yabugudoenu dhadhal. Minguz kedha, ngidh Awgadhaw doegamuya zapul aymayginga, ngi kasa mabaygaw ubil zapul aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuy lak mulaydhin thanamulpa ya matha ngoedhagidh kedha, ‘Mabayg nga nanga nungu ubi nuydh ngaybiya asin, wa yakanuriz nungu ubilnga a ngaybiya asir ngaw mab ngalagiya nanga. Ngitha bangal imane koey mangal puy, sathawro ngaw thabaynu. Kedha midh mura ngaybiya asin, ngidh ngaru nginu sathawro manin mura goeygiya, ngath midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Setha ngaya nanga thanamun ubi kedha thana thanamun igililnga danal poethaypa, thana kasa guythuyamoeyne bangal thanamun igililnga. Ngadh nanga nungu igililnga kasa guythuyan kuyk nungu danal poethay ngayapa, nuy kedha mabaygan ngaru gasamoene bangal nungu igililnga. ");
INSERT INTO mwp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Matha ngoedhagidh midh, mabaygan sike mura nabi apaw goewaw kapu rugal gasamoeyne, kasa kay kedha nuydh nungu mina igililnga guythuyaypa. Lawnga sena gegeyadh. Zaginga war nubepa maypa nungu mina igililnga kuniya gasamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","‘Ngay Mabaygaw Kazi lak mangedhe bangal. Ngay senabi thonara Ngaw Thathiw poerapar oengemine a ngaw angelal ngaybiya. Wa, senabi thonara mura mabaygal gasamoene thanamun modhab matha kedha thanamun zagethal midh, mina zageth lawnga wati zageth! ");
INSERT INTO mwp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kedha yakanurayg! Dhuray mabaygal nanga itha, thanamulpa umapa lawnga, thana parunu thabi zapul imamoeyne, ngay Mabaygaw Kazi lak ngapa kuniya, ngaw Kuykulmay zagethoepa aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sikis goeygi kaliya, Yesu thurimoeydhin Petheru a palay kuyk kazi Zemes a Yoewane. Nuydh thana yoelpamoeydhin koey padapa. Matha thana kadaypa walemidhin. ");
INSERT INTO mwp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gimal nanga thana thoeri niyaykazil imadhin kedha, nungu Yesun gamu wara ngadh asidhin; nungu paru kidh thayadhin, koey buyalnga mer matha kedha goeyga midh. Nungu rugal lak kedha mina goerab gamulmayl. ");
INSERT INTO mwp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kalanu thana imamoedhin ukasar maygi peropeth, Mose a Elayza, Yesuniya ya sagul siyamar. ");
INSERT INTO mwp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Thanamulpa mina ngadhagi za; nuy Petheru kedha mulaydhin Yesulpa, ‘Ina mina kapu za, ngalpa itha memayipa. Ngibepa midh, ngoey sike thoeri iradh lagal aymoeypa wara ngibepa, wara Moselpa, a wara Elayzalpa.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nungu Petherun yanu dhadhal, koey buyal ziya pudhaydhin thanamuniya, a senabi ziyangu dhadhaz, yangu wakay thanamulpa kedha, ‘In mina ngaw Noeydhayl Kazi, nuy ngayapa mina matha ngoedhagidh. Ngitha nubepa kurusipagemiw.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Thana niyaykazil kedha yangu wakay na karngemidhin nanga, thanamun aka mina koeyza. Thana thanamun gamul mulupa patidemidhin boeradharoepa. ");
INSERT INTO mwp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kalanu Yesu thanamulpa buyal thayadhin a nungu geth woeydhadhin thanamuniya. Nuy kedha, ‘Kadaypa memayiw, ngitha akan maygi.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kalanu thana kadaypa nagemidhin boeradharoengu, thana matha nuyn imadhin sey, wara mabaygoeginga. ");
INSERT INTO mwp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kalanu thana ngapa mulupa pagamaydhin padoengu. Maboenu dhadhal nuy Yesu koeyma mulaydhin thanamulpa, ‘Kedha thonar mabaygoepa mulayg, ngitha midh zapun nanga imamoeydhin sey padoenu gimal, kurusipa bangal Mabaygaw Kazi umangu kaday tharedhe.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lak moegina ngulaygoepa gasamaypa thana Petheru a sepalbi kuyk kazi lak yapupoeybemidhin kedha, ‘Ngibepa midh, thana sabiw ngurpay mabaygal, thanamun ngurpay kedha, Elayza bangal ngapa kuniya tidhedhe, nungu kalanu Awgadhaw Woeyayzi Mabayg kakal yakamiz mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kuniya mulaydhin, ‘Sena mina yangukudu, Elayza ngaru ngapa kulay, mura zapa buth pathamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngay ngithamulpa kedha, Elayza kulkub mangaydhin, kasa kay kedha mabaygoepa nubepa kurusipagaypa lawnga. Thana nungu mina kupay tidayginga a thanamun wati danal pathay aymoeydhin nubepa. Kalanu bangal ngay Mabaygaw Kazi lak kedha wati danal poethay gasamoene bangal thanamulngu.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kedha yangukudu na karngemidhin thana, wa thana tidamoeydhin kedha, nuy Yoewane Papatayso lak kedha Elayza. ");
INSERT INTO mwp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu a nungu thoeri niyaykazil nanga mangaydhin nungu wara niyaykazipa, mabayg mina koeygarsar. Urapun mabayg ngapa Yesulpa, kulun pasayniz nubiya parunu kedha, ");
INSERT INTO mwp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","‘Kuyku mabayg, ngidh gar ngoena ibupuydhar, ngaw garkaz kazi kobegadh thonar rimarimarepa. Wara thonar nuy kasa muypa pudhiz, wara thonar ngukipa. ");
INSERT INTO mwp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngath nuyn ngapa yoelpadhin nginu niyaykazipa, kasa kay kedha thanamulpa kasa yan nubepa balbaytidaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kuniya mulaydhin nubepa, ‘Ngitha nubi maykuyk, ngitha mina wara pawalgal, ngithamun mina yoepathaman gegeyadh, ngay in mi kuykuthalnga kalmel. Ngaw gamu koewba asin ngithamulngu. Mariw kay sena moegina garkaz ngapa ngayapa!’ ");
INSERT INTO mwp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nuy kedha mulaydhin wati maripa, ‘Ngi adhapa nungungu, moegina kazingu.’ Balbayginga senabi thonara senabi wati mari adhapadhadhin a nuy kazi balbaygoesidhin. ");
INSERT INTO mwp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kalanu thana niyaykazil muynu mulemidhin Yesulpa kedha, ‘Midh paru ngoey wati mari adhapa mayginga, ngoey koeyma nuthemidhin?’ ");
INSERT INTO mwp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nuy kuniya mulaydhin thanamulpa, ‘Ngithamun sirisir kedha, ngithamun mina yoepathaman matha ngoedhagidh lawnga; kapu za kedha ngithamun mina yoepathaman igil za, moegina kapu midh nanga, wagel kay na mina koeyza aymiz. Nginu mina yoepathaman nanga kedha moegina, moegithap kapu midh nanga, kasa kay na igil za, ngi ngulayg koey padoepa muliz kedha, “Pad ngi seyzi adhapa wara doegampa,” a na pad ngulayg wara doegampa thamiz, nginu ya ayman. Kalanu nanga wara zaginga ngibepa koey zageth, kuyk ngithamun mina yoepathaman.’ ");
INSERT INTO mwp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Wara goeyga nanga Yesu a nungu niyaykazil mura garwoeydhamoeydhin sey Galilayoenu. Nuy kedha thanamulpa, ‘Thonar mina amadhan, Mabaygaw Kazi bangal mabaygoepa manine. Thana ngoena mathamoene bangal, kasa kay kedha thoeri goeygiw kaliya, nuyn bangal kadaypa manine moeram gudoengu.’ Thana karngemidhin nanga, thana niyaykazil koerkak badh gasamadhin. ");
INSERT INTO mwp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Senabi thonara thamamun Yoewdhayalgaw sabi kedha, mura garkazil ngaru modhab ayman koey yoewthapa, mura wathanu. Yesu a nungu niyaykazil wara goegathoenu mangaydhin, Kapeniyam. Nabiya muynu bokadhzoengu garwaydhamay mabaygal koey yoewthaw doegampa. Thana Petherun yapupoeybaydhin kedha, ‘Nginu kuyku mabayg midh, nungungu yoewthapa modhab maypa a?’ ");
INSERT INTO mwp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petheru kedha, ‘Wa, nuy ngulayg.’ Kalanu nuy lagapa muy araydhin Yesulpa, kasa kedha Yesu mamu nubepa muliz kedha, Simona, ‘Nginu wakay thamamaynu midh, mi mabaygal ngulayg modhabiya maypa nubi apaw goewaw gabmenoepa, adhapudhay kuyku mabaygal, lawnga thanamun dagam buway mabaygal, lawnga azaz mabaygal?’ ");
INSERT INTO mwp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petheru kuniya, ‘Matha thana azaz mabaygal ngulayg modhabiya maypa.’ Yesu kedha, ‘Wa, ngi mina yadu umepa, buway mabaygal kedha zapa aymaypa lawnga. Ngalpa Awgadhaw mina buway mabaygal, ");
INSERT INTO mwp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","kasa kay kedha ngalpan ubiginga thana gegeyadh gasaman ngalpaniya. Ngi uzar arigapa thoeyaypa. Ngidh kedha imaypa, nginu kulay wapi, nanu gudanu muynu urapun silba bokadhza. Senabi bokadhza matha ngoedhagidh ngoeban koey yoewthaw modhabipa. Ngidh kalanu senabi bokadhza thanamulpa maypa, nginu modhabipa a ngaw modhabipa.’ ");
INSERT INTO mwp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Senawbi thonara Yesun niyaykazil nubepa ngapa, thana kedha, ‘Ngunu kupay adhapudhay koeyza Daparaw Basalayanu gimal?’ ");
INSERT INTO mwp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Thanamulpa seysithamaypa nuydh urapun moegina kazi thuradhin nubepa, nuy moegina kazi kaday tharaydhin thanamuniya parunu. ");
INSERT INTO mwp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yesu kedha thanamulpa, ‘Ngitha nanga ngithamun igililmayl sakariya thayamoeyn kedha, moegina kaziw igililmay pawa midh nanga, wa ngitha balbaygimayl kalanu bangal, Daparaw Basalayoepa muy uthuypa. Igililnga sakariya thoeyayginga nanga ngithamulpa muya yoewthaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","‘Nga nanga koey apa pudhiz wara mabaygiya matha kedha moegina kazi midh, nungu kupay bangal adhapudhay Daparaw Basalayoenu; ");
INSERT INTO mwp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","a ngadh nanga kedha ngoedhal moegina kazi ngapa mamayin, ngaw mamapa pathoeridhoepa kedha moegina kazipa, nuydh matha kedha ngoena ngapa manin. ");
INSERT INTO mwp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Ngadh nanga urapun kedha moegina kaz adhapa ruwaman kapu akasiw yabugudangu a kalanu senawbi moegina kazin ngoena mina yapathoemayginga, koey gegeyadh bangal senabi mabaygoepa ngadh nanga nuyn adhapa ruwaman. Nubepa balbayginga nay koey kula kunuman nungu muduloenu a nuyn koey malupa thayan nay. ");
INSERT INTO mwp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngitha a mura mabaygal ngaru koey poeypiyam bangal. Thabi nuthay zapul ngaru mangemipu, kasa kay kedha ngadh nanga kedha nuthay ayimpa, nungu sirisir adhapudhay koeyza bangal. ");
INSERT INTO mwp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Ngitha ngaru koey poeypiyam bangal ngithamulngu kedha wati zoengu aymoeyle. Ngithamulpa matha ngoedhagidh midh, ngithamun mura gamu senabi koey muypa thayan, lawnga midh ngitha guythuyan urapun thugal ngithamun gamungu. Nginu gethan nanga wati pawa ayman, lawnga nginu ngar wati boeradharanu tariz, ngidh nan kazayginga adhapa manin ngoedhe kedha ngidh senabi thugal midh nanga adhapa pathan; ");
INSERT INTO mwp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","a matha kedha nginu purkaw noegaypa nanga ngin wati wakay thamamaypa manin, sobaginga adhapa nagiz ngoedhe kedha ngidh midh, nan dan nalban, nginu purka. Matha ngoedhagidh kedha ngi urapun purkalnga mina igililmaynu muya uthiz, nginu ukasar purkapa mamu koey muypa thoeyaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Ngidh pasipa imayg urapun moegina kazi lawnga mabayg nga nanga mina apal, thanamun danal pathay angelal mura thonara sey daparoenu. ");
INSERT INTO mwp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ngithamulpa midh, mabayg nanga andred mamuylayg, urapun thanamulngu kasa guythuyan sey bupanu. Nuy senawbi mabayg ngaru woenamoeyn sethabi nayntynayn balbaygi mamuyl. Thana kasa bupal purthamoeyr sey padoenu pasinu a nuy uzariz nungu guythuyayzi mamuypa lumaypa. ");
INSERT INTO mwp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nuydh nan mamuy lak iman nanga, nungu ika dhiw ngaru mina koeyza, adhapudhay nungu ika mura balbaygi mamuypa. ");
INSERT INTO mwp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ngithamun Daparaw Thathi lak kedha mina ubiginga urapun moegina kazi lawnga kasa mabayg nuy mina apal, wati kuthoepa. ");
INSERT INTO mwp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Wara nginu tukuyap nanga ngibiya bal pudhiz, kapu za ngi nubepa uzariz, nubepa yakaman nungu gegeyadh. Mabaygaw parunu aymayg, matha ngipeniya muynu. Nuydh nanga ngibepa karngemin, wa balbayginga nuy lak nginu igalayg aymiz. ");
INSERT INTO mwp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nuydh nanga ngibepa koerngayginga ngidh nuyn wanan, ngidh mamu urapun lawnga ukasar wara mabayg gasamoeman, kalanu ngipel ukasar lawnga ngitha thoeri mabaygal kalmel nubepa nginu tukuypoepa ladhun. Mina poelayzinga kedha, “Za ayman ukasar lawnga thoeri mabaygiya parunu a setha mabaygal mura matha kedha yadu poelgayzi ya oengaypa, wa minamay mabaygan ngulayg mina yoepathaman sethabi yangukudul.” ");
INSERT INTO mwp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","‘Nuy nanga thoeri mabaygoepa kurusay poegaypa, wa balbayginga. Nuydh nanga koerngayginga ngithamulpa, ngitha mura ekaloesiyaw mabaygal thuremoeyn a senawbi sirisir mura sakar manin thanamulpa. Nuy nanga thanamulpa kurusipoegayginga nuyn kalanu adhapa pathan ngithamulngu, matha kedha inuraw mabayg lawnga bokadhzangu garwoeydhamay mabayg midh. ");
INSERT INTO mwp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Wa ngay ngithamulpa kedha, ngitha ngaw mabaygal kupaylmayl kedha minamay zagethoepa; midh zapul nanga ngitha gud mathamaypa itha apal, wa kedha zapul lak kedha gud mathamoeyn sey gimal dapara; a midh zapul nanga ngitha gud pudhaypa itha apal, wa sethabi zapul lak gud pudhamoeyn gimal dapara. ");
INSERT INTO mwp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ngay lak ngithamulpa mulepa kedha, mi thonar nanga ukasar ngithamulngu kalmel wakay thamamay mi za balbayginga nanga a kalmel thaythu poegay ayimpa, kalanu ngaw Daparaw Thathi lak aymoene ngithamulpa, ");
INSERT INTO mwp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","kuyk kedha, mi thonara nanga ukasar lawnga thoeri mabaygal ngithamulngu, kalmel garwoeydhamaypa ngaw nelpa thawmaypa, ngay lak kedha kalmel ngithamuniya sethabi mabaygiya.’ ");
INSERT INTO mwp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kalanu Petheru ngapa thamadhin Yesulpa kedha, ‘Kuykulnga, ngidh ngoena ngurpar. Wara thonara ngaw tukuyap sike ngayapa gegeyadh ayman koeygarsar thonaralnga, ngayapa midh mura thonaral nubepa gud woeyaypa senabi gegeyadh ngayapa? Ngath sike seben thonaralnga za gud wayan nubepa?’ ");
INSERT INTO mwp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kuniya mulaydhin nubepa, ‘Matha seben thonaralnga lawnga, seben andred thonaralnga balbayginga. ");
INSERT INTO mwp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ngath lak ngibepa sakar maypa Awgadhaw Basalaya midh nanga, matha kedha nubi gidha midh. Urapun adhapudhay kuykulnga nanga kedha buwayl thayadhin wara goeyginu, “Ngath lak imaypa nuthaypa ngaw niyaykazil, thana thanamun kuniya modhab ngayapa aymoeypu lawnga midh?” ");
INSERT INTO mwp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","‘Nuydh kasa kuykayman nanga, nungu mabaygal nubepa madhin urapun nungu zagethaw mabayg. Nuy kedha mabayg, nuydh urapun milyoen dolal gasamoeydhin nungu kuyku mabaygoengu, kasa kay kedha nuydh modhab kuniya mayginga. ");
INSERT INTO mwp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nungu niyaykaziw bokadhzapul matha ngoedhagidh lawnga senabi modhab kuniya maypa. Nuy kuykulnga mulaydhin kedha, “Ngayapa kedha, ngidh ngayapa modhabiya mayginga. Ngath ngin gasamaypa, ngi a nginu ipi-kazil a mura nginu rugal kalmel kasa barpudamoeyn, ngayapa moegina bokadhzapa kuniya gasamaypa. Kalanu ngitha kasa mapu zagethaw mabaygal wara mabaygoepa.” ");
INSERT INTO mwp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‘Nuy zagethaw mabayg kulun pasoeyniz kuykulmay parunu, koeyma yoewdhiz kedha, “Thumagar, ngidh nanga moegina kuykuthalnga ugane, kurusipa ngath mura thabi bokadhzapul ngibepa kuniya maypa.” ");
INSERT INTO mwp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","‘Nungu kuyku moebaygan koerkak badh gasamoedhin nungu zagethaw mabaygoepa. Nuy kedha, “Lawnga, ngath kasa gud woeyaypa nginu modhab nginungu, ngabalngu kasa yakanuremipa.” ");
INSERT INTO mwp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘Nuy zagethaw mabayg adhapadhan nanga nungu kuykulmayngu, nuydh wara zagethaw mabayg imadhin, kuyku mabaygaw. Nuy gud woeyayzi zagethaw mabayg buyal thoeyaydhin kedha nubepa, wara zagethaw mabaygoepa, “Ngidh midh paru kuniya mayginga sethabi moenarimayl dolal ngath ngibepa mamayidhin kasa thawpay thonarpa?” Nuydh nuyn mudulya gasamadhin, koey dharadh mulaydhin nubepa, “Ngidh ngaw bokadhzapul kuniya mamayir.” ");
INSERT INTO mwp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Nuy wara zagethaw mabayg mulupa pudhiz nubiya parunu, koeyma apasin kedha, “Thumagar, kurusipa ngath mura kuniya manin ngibepa.” ");
INSERT INTO mwp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","‘Nuy gud woeyayzi zagethaw mabayg matha kurusipagayginga nubepa. Nuydh nuyn kunumay danal poethay mabaygoepa madhin, nubepa kasa wanaypa lawnga, kurusipa nuydh mura nungu modhab kuniya manin. ");
INSERT INTO mwp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‘Kuyku mabaygaw wara zagethaw mabaygal imadhin nanga, nuydh kedha wati danal poethay aymanu nungu tukuypoepa, thana mina koeyma gegeyadh gasamoedhin. Thana sobaginga ladhudhin thanamun kuykulmaypa yadu poelgaypa. ");
INSERT INTO mwp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Gasamadhin kedha, nuydh nuyn thuradhin, muladhin kedha, “Ngi ngayapa mina wati zagethaw mabayg. Ngath mura nginu modhab gud wayanu matha kedha nginu yapu poeybayzinga midh. Ngath mina gabudhan danal poethay aymanu ngibepa; ");
INSERT INTO mwp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ngidh midh paru nginu tukuypoepa koerkak badh mayginga, ngath midh nanga ngibepa aymanu? Ngidh midh paru nungu modhab gud woeyayginga?” ");
INSERT INTO mwp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nuydh kuykulmayn mina gegeyadh gasamoedhin nungu zagethaw mabaygoepa. Nuydh nuyn mina wati kunumay danal poethay mabaygoepa madhin, nubepa kasa wanaypa lawnga kurusipa bangal nuydh kuniya modhabiya manine.’ ");
INSERT INTO mwp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nungu Yesun moeygapa yangukudu kedha, ‘Ngitha nanga ngithamun tukuypaw gegeyadh gud woeyayginga nanga, Ngaw Thathiw danal poethay ngithamulpa matha kedha nungu wati zagethaw mabaygoepa midh. Ngitha ngaru ngithamun tukuypaw gegeyadhal gud woeyaypa ngithamun ngoenakapoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nungu kedha ngurpay kalanu, Yesu a nungu niyaykazil wanadhin senabi Galilayaw Malu doegam. Thana Yuridhaw Koesaw wara doegam buwadhoepa, Yoewdhayaw doegampa. ");
INSERT INTO mwp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mabayg koeygarsar nubepa asidhin; nuydh mura buth pathamoeydhin thanamun kikiringu. ");
INSERT INTO mwp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dhuray Parasayalgal, Yesulpa nuthaypa aymaypa aymaydhin kedha, ‘Ngalpan sabinu balbayginga midh, niyaypa yoelpay pathidhan, alay nanga nungu ipiya oesiginga?’ ");
INSERT INTO mwp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kuniya buyal thayadhin thanamulpa kedha, ‘Ngitha ngaru ngulaygal kedha, Minar Poelayzinga kedha, “koezi payap ngapa parungu nubi apaw goewaw sama woeydhayzimayngu, Awgadhan garkaz a yoepkaz aymoemoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nuydh kedha zoepa aymoemoedhin, garkazin bangal nungu apu thathi wanamoene, a nuy garwoeydhamiz nungu ipiya. ");
INSERT INTO mwp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Palamun ukasar mabaygaw gamu kalanu urapun aymiz, palay lak lawnga ukasar moebayg, palamun mamu ngedh urapun gamu aymiz.” Kedha zoeguz Awgadhan nanga garwoeydhamoemoeman mabayg, mabaygoepa dhadh poelamaypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Thana Parasayalgal kedha, ‘Ngidh gud thamudhan a? Midh kay paru Mosen kedha poeybayzi sabi ngalpan thathipa, “Balbayginga kedha mabayg nungu ipi kuniya wayan a nabepa ayman thusi kedha, palamun niyaypa yoelpay dhadh palamoeyn”?’ ");
INSERT INTO mwp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kuniya mulaydhin thanamulpa, ‘Wa, nuydh Mose kedha za gud pudhan, mabaygoepa ipipa kuniya wayaypa, kuyk ngithamun koerngayginga koeyza. Kasa kay kedha, Awgadhaw mina buwaylthoeyay nubi gugu ubidh thoeyayzimaynu sama nanga, na kedha buwaylthoeyay lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mina ngay ngithamulpa muliz kedha, ngadh nanga nungu ipi kuniya wayan, nadh koey wati pawa aymayginga, nuydh kedha mabayg nanga wara ipi na gasamane bangal, wa sena nungu koey wati pawa Awgadhaw parunu.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kalanu nungu niyaykazil kedha mulaydhin nubepa, ‘Kedha nanga nginu yangukudu midh, matha ngoedhagidh mabayg kasa kawakuyk nay.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kuniya, ‘Ngithamun buyal thoeyay wara mabaygoepa matha ngoedhagidh. Matha setha ngaya nanga Awgadhan thana balbay tidamoeyn ipigi igililmaypa, wa thanamulpa matha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ipigi mabaygal kedha, dhuray kazi manin kedha, ipipa matha ngoedhagidh lawnga, dhuray thana kedha madhin wara mabaygaw gethan, a dhuray kasa ubilgal ipigi igililmaypa, Awgadhaw Basalayapa danal poethaypa. Wa, thana setha ngaya nanga ngulayg nubi ngurpay oengaypu, wa thanamulpa matha ngoedhagidh. Wara mabaygoepa matha ngoedhagidh lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kalanu wara mabaygal moegina kazil ngapa mamayidhin Yesulpa, nubepa geth nidhaypa thana, a thaythupoegay aymoeypa, kasa kay kedha nungu niyaykazil lawnga mamayidhin kedha, ‘Moegina kazil adhapa memayiw.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kedha, ‘Ngitha lawnga maygi sethabi moegina kazil, kasa wanamay thana ngapa ngayapa. Minguz kedha, senawbi koey basalaya kay gimal, na kedha ngoedhal moegina kazipa, buth pathayzinga, thanamulpa niyay lag.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nuydh kalanu geth gimal wanadhin thanamun moegina kaziw kuykunu. Kalanu nuydh wanaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wara goeyginu nanga wara kayn mabayg ngapa Yesulpa, kedha yapupoeybaydhin, ‘Ngurpay Mabayg, ngath bangal mi mina zageth aymoene mina igililmaypa gasamaypa ngayapa?’ ");
INSERT INTO mwp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kuniya buwayl thayadhin nubepa kedha, ‘Ngidh midh paru ngaybiya kuyk wakaypa kapu zapa, nuy kapu mabayg matha urapun, ngidh nungu sabi oengar mina igililmaypa gasamaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nuy mabayg lak yapupoeybiz kedha, ‘Ngidh mi sabil thuremoeypa ngayapa?’ Yesu kuniya nubepa, ‘Ngath kedha sabil, mabayg umamathamayg, koey wati pawa aymayg, wara mabaygaw rugal kusumayg, sole yangukudu ya mulayg, ngidh koeyma apasin maman manin nginu apu thathi, ");
INSERT INTO mwp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a mabaygal ngaya nanga ngibiya amadhan, ngidh thana koeyma maman mamayipa, matha kedha nginu mam a kapu danal poethay nginu geth zapupa.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nuy kayn mabayg kedha, ‘Wa mura itha thabi sabil ngath aymoeyrngu, wara za midh ngayapa aymaypa ngaw igililnga mina balbay tidaypa?’ ");
INSERT INTO mwp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kuniya mulaydhin kedha, ‘Nginu ubi nanga nginu igililnga mura balbayginga ngidh mura nginu rugal nanga yoewdhamoeyn bokadhzapa gasamaypa. Kalanu ngidh sethabi bokadhzapul poeybamoeyn mura aygi zagi mabaygoepa. Kalanu nginu kapu rugal koey zapul sey daparaw gimal. Ngidh nanga ayman kedha, wa ngi ngapa ngayapa ngaw puziw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nuy kayn mabayg na karngemidhin nanga Yesun yangukudu ya, nuy kasa wanaydhin, nungu mura dhodho papudhamoeydhin, kalanu kasa wati ngoedhalnga lagoepa kuniya tidaydhin. Minguz kedha nuy koey aydeg zapulayg. ");
INSERT INTO mwp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu buwayl thayadhin kedha nungu niyaykazipa, ‘Mabayg nanga koey rugalayg, nubepa moegina zageth lawnga Awgadhaw Basalayapa muy uthaypa. ");
INSERT INTO mwp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngay ngithamulpa kedha, mabayg nga koey rugalayg nanga, nungu muya uthay zageth adhapudhay koeyza Awgadhaw Basalayapa uthaypa, koey uruy kamel midh mina moegina arkath muya uthiz, sapur kimusaw kuykuyaya uthaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Thana niyaykazil kedha, ‘Kedha na nanga, mura mabaygoepa sike koey zageth mina igililmaypa gasamaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu thanamulpa wadhe thulu nagaydhin. Nuy kedha thanamulpa, ‘Wa, mabaygoepa nungu geth muya yoewthaypa koey zageth, kasa kay kedha Awgadhoepa mura zoepa aymoeypa zagethoeginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kalanu Petheru kuniya mulaydhin Yesulpa kedha, ‘Ngibepa midh, ngoey mura ngoeymun zapul wanamoeydhin ngibepa oesipa, ngoeymun bangal gasamayza midh?’ ");
INSERT INTO mwp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kuniya mulaydhin thanamulpa, ‘Ngay ngithamulpa mina ya muliz kedha, ngath bangal nanga ngaw kuykulmay kupay niyaylag na gasamoene bangal, wa ngitha twoeylop ngaw puziw mabaygal ngaru lak kedha gasamoeyne twoeylop kuyku mabaygaw kupay niyaylagal, ngithamun minamay zagethoepa aymaypa. Ngitha senabi thonara Isoereylaw twoeylop buway kuykul aymoene. ");
INSERT INTO mwp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wa, mura setha ngaya nanga thanamun buway a kapu rugal kalanu wanan, kuyk thanamun ubi ngoena danal poethaypa, kalanu bangal thanamun kapu kozan adhapudhay koeyza. Thana sike tukuypal, babthal, aputhathil, lawnga kazil kasa wanamoeyn, lagal a boeradharal kasa wanamoeyn ngayapa danal poethaypa, thanamun kozan bangal ngaru adhapudhay thanamun kulay guythuyay, urapun andred thonaralnga; a wara kozan thanamulpa, thana mina igililmaypa muya uthaypa. ");
INSERT INTO mwp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","‘Kasa kay kedha koeygarsar mabaygal koey kupaylmayl ina kayib, thanamun kupayl bangal koeyma mulupa manin. A dhuray koeygarsar ngaya nanga kasa mabaygal ina kayib, thanamun bangal kupayl adhapudhay senabi thonar na bangal gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu lak mulaydhin thanamulpa kedha, ‘Awgadhaw Basalaya matha kedha goereypaw apawlagaw mabayg midh. Mina baythaynga nanga nuy zangu barpudhay lagapa kayn zagethaw mabaygoepa thuraypa, nungu apaw lagapa. ");
INSERT INTO mwp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nuy thanamulpa kedha, “Kutapa nanga ngath mina modhab ngithamulpa maypa, pipti dolal yaynanob.” Kalanu nuydh thana wayamoeydhin nungu goereypaw apaw lagoepa, zagethoepa. ");
INSERT INTO mwp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","‘Nayn klok nanga nuy lak kuniya barpudhay lagoepa. Nuydh imadhin wara zagethoegi mabaygal, thanamulpa mulaydhin kedha, “Ngitha ladhu, ngaw goereypaw apaw lagapa zagethoepa, a ngath balbaygi modhab ngithamulpa maypa.” ");
INSERT INTO mwp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Thana ladhudhin. Dhadha goeyga lak kedha, a thoeri koelokoenu lak kedha, nuydh kayn zagethaw mabaygal gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","‘Goeygiw pudhay na amadhan nanga, nuy lak uzaraydhin barpudhay lagoepa. Nuydh wara zagethoegi mabaygal imaydhin. Nuy kedha muliz thanamulpa, “Ngitha midh paru in goeyga kasa mema.” ");
INSERT INTO mwp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Thana kuniya, “Mabaygoeginga ngoeymulpa barpudhamoeypa zagethoepa.” ‘Nuy kuniya, “Yargar, ngitha lak kedha ngaw goereypaw apawlagoepa zagethoepa.” ");
INSERT INTO mwp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Kutapa nanga apawlagaw mabayg nungu zagethaw kuyk thuradhin a kedha mulaydhin nubepa, “Nag, ngidh mura ngaw zagethaw mabaygal thuremoeyr thanamun modhabipa. Thana moeygapa gasamayzi zagethaw mabaygal, ngidh kulay thuremoeyr, a setha ngaya nanga ngath mina bathaynga gasamoeynu, ngidh moeygapa thuremoeyr.” Wa, nuy zagethaw kuyk nuydh aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","‘Kulay nuydh thuremoeydhin thana, setha ngaya nanga thanamun zageth kuykaymaydhin goeyga pudaynu amadhan, a thanamun modhab poeybamadhin pipti dolal yaynanob. ");
INSERT INTO mwp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Setha nanga ngaya mina bathaynga thanamun zageth kuykaymaydhin, thana nanga imadhin kedha, moeygapa mabaygaw modhab koeyza, thana kedha wakay thayaydhin, “Ngalpan modhab sike gimal.” Kasa kay kedha thanamun thonar na gasamadhin nanga thanamun modhab mura urapun, mura pipti dolal yaynanob. ");
INSERT INTO mwp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","‘Thana nanga gasamadhin kedha, thana gegeyadh gasamadhin, a kidhakidhan umamoeyr kedha, ");
INSERT INTO mwp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ngoeymun zageth koey mapunga, goeyga mina koeyza; thana moeygapa mabaygal nanga, thana matha urapun awapa zageth aymanu, goeygin thana gasamoeyginga. Midh paru thanamun a ngoeymun modhab matha urapun.” ");
INSERT INTO mwp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Nuy apawlagaw mabayg buwayl thayadhin urapun mabaygoepa kedha, “Igalayg! Ngi midh paru kedha umepa? Ngath ngin sagul poelayginga; ngaban yawadhayzinga kedha, nubi goeygiw zagethoepa, ngath pipti dolal ngibepa maypa. Wa, ngath aymoenu. ");
INSERT INTO mwp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Matha ngaybiya kurusipa ngaw bokadhzapa maypa. Ngaw ubi kedha, ngithamulpa a thanamulpa modhabiya kay urapun, wa ngi kay kasa yaginga lagapa uzar. Ina ngaw bokadhza, matha ngaw kupay kedha ngath kozan poeyban wara mabaygoepa. Ngi ngaw mina pawanu balpudhiz.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu lak mulaydhin thanamulpa, ‘Kedha kay, kalanu bangal nanga kaybaw goeygiw kasa mabaygal ngaru gimal, a kaybaw goeygiw kupay mabaygal nanga, thana bangal ngaru apal.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu a nungu niyaykazil thanamun mab kuykaymaydhin Yoerusalemoepa. Thana nanga ladhudhin, nuydh nungu ngurpan aymar thanamulpa. Wara mabaygoepa lawnga, nungu niyaykazipa. ");
INSERT INTO mwp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nuy kedha thanamulpa, ‘Kurusipagemiw, ngalpa mura Yoerusalemoepa; senabi lagoenu nanga ngay Mabaygaw Kazi ngaru bangal manine, thanamun kuyku misnarepa, a thanamun sabiw mgurpay mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Thana sethabi mabaygal kalanu ngayapa kuth thoeraypa a ngoena azaz mabaygoepa bangal manine. Thana azaz mabaygal bangal ngoena giwn soelmaypu, palngine bangal, a ngoena sathawrawpa puydhane. Koey neylan uthumoeyne. Thoeri goeygiw kalanu ngoena bangal kadaypa manine igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kalanu palay kuyk kazi Zebadin, palamun apu yoelpamoedhin Yesulpa. Na kulun pasoeyniz Yesuniya parunu a koeyma yoewdhiz. ");
INSERT INTO mwp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nuy kedha nabepa, ‘Nginu yoewdhayzinga midh?’ Na kedha mulaydhin nubepa, ‘Ngidh bangal palamulpa sib wanane kedha, ngi midh thonara nanga, ngidh nginu adhapudhay kuykulmay kupay gasamoene bangal, palamun kupay kedha, palay apathanur-man nginu getha doegamoenu a nginu boedha doegamoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nuy thanamulpa kuniya mulaydhin kedha, ‘Ngitha koerawaygal ngithamun yapupoeybayzi ya midh nanga.’ Nuy palamulpa buwayl thayadhin, ya matha ngoedhagidh aymoedhin thanamulpa, sakar maypa nungu kikir a um, ‘Ngipel matha ngoedhagidh lawnga, kedha wati nguki woenipa, ngay mi wati nguki wanedhe nanga, sey Yoerusalemoenu?’ Palay kalanu kuniya, ‘Wa, ngoeba buth pathempa kedha zagethoepa aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nuy Yesu kuniya, ‘Wa, ngipel ngaru wanimoene bangal sena mi wati nguki ngay bangal wanedhe, kasa kay kedha sena ngaw kupay lawnga ngayapa pasiw mabaygoepa thuraypa gimaw kupaypa. Sena Ngaw Thathiw zageth, nuydh sepalbi gethadoegam a boedhadoegam niyaylag buth pathaman, Thathiw ubipa mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Thana wara ten niyaykazil na karngemidhin, palamun apuwaw yapupoeybayzi ya midh, thana gegeyadh gasaman, palamulpa kuyk kazipa. ");
INSERT INTO mwp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu mura thuremoeydhin thana. Nuydh kedha yadu umay, ‘Ngitha ngulaygal kedha, wara goegathaw mabaygaw pawal midh nanga. Thanamun kuyku mabaygal matha thanamun geth pawanu nipa, mura thanamun kasa mabaygal. Thanamun adhapudhay kuyku mabaygal lak kedha, mina koey gimal mura mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngitha bangal kedha aymayg. ");
INSERT INTO mwp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ngunu bangal nanga ubi kedha, nuy koey mabayg aymoene bangal, nuy ngaru koeyma apasin mura mabaygoepa. Nuy mura mabaygaw mapu zagethaw mabayg aymiz, matha kedha ngay Mabaygaw Kazi midh. ");
INSERT INTO mwp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngay lawnga ngapa nubi apaw goewapa, wara mabayg ngayapa danal poethaypa. Lawnga, Mabaygaw Kazi kedha zoenguz ngapa, koeygarsar mabaygoepa danal poethaypa. Ngaw igililnga mabaygoepa poeyban thanamulpa kuniya maypa Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Thanamun Yoerusalemaw yabugud ngaru wara goegathiya, Zerikoniya. ");
INSERT INTO mwp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Thana na senabi goegath wanadhin, ukasar maygum si niyamar yabugudoenu pasinu. Palay na gasaman kedha nuy pasipa uzaraydhin, palay gima gudiya walmemamoedhin kedha, ‘Kuykulnga ngi Dhawithan Kazi, ngidh kay ngalbe ibupuydhampa.’ Mabayg koeygarsar sey Yesuniya, ");
INSERT INTO mwp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","thana kedha mulemidhin, ‘Yagiyasimariw.’ Kasa kay kedha palay maygum mina koey gimiya memaman, ‘Kuykulnga, ngi Dhawithan Kazi, ngalbe gar ibupudhamamar.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu nuy tharaydhin nungu maboenu; nuydh thuremoedhin palay. Mangemidhin nubiya nanga nuy kedha, ‘Ngipen ubi midh?’ ");
INSERT INTO mwp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Palay kedha, ‘Kuykulnga, ngidh gar ngalbelpa purkaw buya poeybamar.’ ");
INSERT INTO mwp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu koerkak badh gasamoedhin palamulpa, palamun purkanu geth nidhaydhin. Mina senabi thonara palay balbayg asimoedhin, palamun purka. Kalanu Yesuniya wagel asimoedhin palay. ");
INSERT INTO mwp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Thana nanga Yoerusalemoepa amadhan thamadhin, moegina goegath sey nel Bethpayz, Olibaw Padanu amadhan. ");
INSERT INTO mwp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yesu wayamoedhin ukasar nungu niyaykazi. Palamun zageth seysithamadhin kedha, ‘Sepa uzarmariw, goegath sey parunu, ngipel balbayginga imane tetel uruy donki sey kunumayzinga, na a nabiya kalmel nanu kazi. Ngipel kay gud wayamoeyne sepalbi donki a ngapa mamamoene. ");
INSERT INTO mwp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mabayg nanga ngipelpa yapupoeybedhe nanga, ngipen zagethoepa ngurpaypa, ngipel bangal kedha mulemoene, “Palbi donki nubepa Kuyku Mabaygoepa, nuy zagethoelayg palamulpa.” Mabayg nanga kedha ya na gasaman nanga, nubepa matha ngoedhagidh ngipelpa palamulpa ngapa yoelpaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ina kay paypa kulay peropethaw yangukudu kuykunidhaypa kedha, ");
INSERT INTO mwp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Yoerusalema, Zayonaw padaw koey goegath, ngitha karngemiw, sepa nagemiw ngithamun Adhapudhay Kuykulnga in mangiz ngithamuniya, nuy koey gabu ngoenakapul mabayg. Nuy koewbupa ngapa lawnga. Nuy kasa moegina donkinu ngapa, kazi donkinu.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sepalbi niyaykazi kulay uzarmoedhin a mura aymoedhin Yesun yangukudu ya midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Palay ngapa yoelpamoedhin nan donki a nanu kazi, kalanu thana niyaykazil thanamun koey sodhal ubamoeydhin palbi donkiniya gimiya, a Yesu gimal thanuraydhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Koeygarsar mabaygal sey Yesuniya, thana thanamun koey sodhal thoeyamoeydhin Yesun yabugudiya, nungu uruy yabugud mina balbayg poelaypa. Wara mabaygal boeythayl lak kedha apiya wanay. ");
INSERT INTO mwp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Koeygarsar mabaygal nubiya, paruya a koeygarsar nubiya kaliya, kedha wal tidumar kuykayman, ‘Ngoey ngin koeyma thawmanin, ngi mina Dhawithan Kazi, Awgadhaw woenab ngibiya kalmel, nuydh ngin ngapa wayan, nungu kupayl zagethoepa! Ngoey Awgadh koeyma thawmanin!’ ");
INSERT INTO mwp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Thana matha wal tidumar kedha, kurusipa nuydh Yoerusalema gasamoedhin nanga senabi goegath mura nur poeybaydhin. Mabaygal yapupoeybemidhin kedha, ‘Nuy nga?’ ");
INSERT INTO mwp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Setha mura mabaygal ngaya nanga nubiya asimoeydhin, thana kuniya mulemidhin kedha, ‘In nuy peropetha Yesu, Nazarethoengu, Galilayaw dagamoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kalanu nuy Yesu koey yoewthoepa muy uthaydhin. Nuy koeyma ya poeybaydhin a adhapa wayaydhin setha mabaygal ngaya nanga zapul yoewdhamoeyr yoewthanu muynu. Bokadhzoengu sakariya thoeyay mabagaw biraygil kuykul idimoedhin, a setha ngaya nanga moegina uruyl yoewdhamoeyr nuydh thanamun apa niyay lagal lak kuykul idimoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nuy thanamulpa kedha mulay-dhin, ‘Awgadhaw yangukudu minar paladhin kedha, “Ina ngaw lag, kedha tharan, Thaythupoegay Lag, kasa kay kedha ngitha wati mabaygal nan puru mabaygaw lag ayman ina.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kalanu thana maygumal a mabagigal nubepa ngapa, koey yoewthanu muynu. Nuydh thana mura kuykunidhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Thana kuyku misnarel a sabiw ngurpay mabaygal, nungu adhapudhay zagethal imadhin nanga, thana gegeyadh gasamadhin. Wara lak kedha thanamulpa gegeyadh, thana moegina kazil si koey yoewthanu muynu koeyma wal tidumar kedha, ‘Ngi Dhawithan Kazi, ngoey ngin thawmanin!’ ");
INSERT INTO mwp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Thana koey mabaygal ubigigal, thana kedha nubepa, ‘Ngidh thana karngemin a? Ngidh mingu thana lawnga mayginga?’ Yesu kuniya mulaydhin thanamulpa, ‘Wa, ngath mina karngemin thanamun ya, ngitha kedha Minar Poelayzinga imadhin lawnga midh, “Ngidh nginu moegina kazil a mapethal ngurpamoeydhin kedha, thana mina balbayginga thawmayzi yangukudul poeybar.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kalanu Yesu koey goegath wanaydhin, nuy wara moegina goegathoepa, Bethoenipa, nubepa dak narpaypa. ");
INSERT INTO mwp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mina bathaynga nanga Yesu koey goegathoepa mab uzaraydhin, nungu niyaykazil nubiya; nungu maythaygi asidhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maboenu dhadhal nanga nuydh imadhin puy, nungu koewsal kedha tharan pigal. Nuy sipa ruwamaydhin aypa lumaypa, kasa kedha nuydh iman kedha nuy kasa nisalnga koewsaginga. Kalanu nuy senabi puypa mulaydhin kedha, ‘Ngibepa lak koewsapa ubamoeypa lawnga.’ Balbayginga senawbi thonara nuy puy kasa um miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nungu niyaykazil koeyma madhu pamemidhin, nubepa yapupoeybemidhin kedha, ‘Senabi puy midh paru sobaginga thepadhasin?’ ");
INSERT INTO mwp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kuniya mulaydhin thanamulpa, ‘Kedha yakanurayg, ngithamun mina yoepathaman mura balbayginga nanga, ngithamulpa zagethoeginga kedha ngidh koey pad mura adhathayan malupa. Wa nan ngulayg kedha ayman nginu yangukudu ya ngidh nanga. Ngoena ngoelkay yapathamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nginu nanga mina yoepathaman kedha, ngidh gasaman. Wa, mizapa nanga ngidh yoewdhepa nanga, nginu thaythupoegaynu, ngidh nan ngaru gasaman.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kalanu nuy Yesu kuniya koey yoewthoepa, ngurpay aymadhin si. Ngurpaynu dhadhal dhuray Yoewdhayalgaw koey mabaygal a kuyku misnarel nubepa ngapa, yapupoeybemidhin kedha, ‘Muli ngoeymulpa, ngidh ngalagaz kupay gasamoengu nabi zagethoepa, a ngibepa matha ngoedhagidh ngadh mangu?’ ");
INSERT INTO mwp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kuniya mulaydhin thanamulpa, ‘Wa, ngayapa lak kedha matha urapun yapu poeybay ngithamulpa. Ngitha kay ngayapa mulemipa, ngayapa lak kedha ngithamulpa mulaypa. ");
INSERT INTO mwp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sena nungu Yoewane Papthayson Papatayso zageth, na ngalagaz ngapa Yoewanen kupay Awgadhoengu lawnga mabaygoengu?’ Thana na karngemidhin kedha, thanamuniya dhadhpoelamay aymaydhin. Thana kidhakidhan umamoeyr kedha, ‘Ngalpa na kedha umamaypa nanga, nuydh Yoewane nungu kupay Awgadhoengu gasamadhin. Nuy Yesu sike kedha umaypa ngalpalpa, “Ngitha midh paru Yoewanen mina yapathamayginga, nungu kupay nanga Awgadhoengu?” ");
INSERT INTO mwp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wara kedha, ngalpa kedha umaypa nanga, Yoewanen kupay Awgadhoengu lawnga, na kasa mabaygoengu; ngoeymun aka kedha zoengu, wara mabaygoengu silamoeyle. Mabaygaw mura wakay thamamay kedha, nuy Yoewane peropetha.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kurusipa thana kedha mulemidhin nubepa, ‘Ngoey koerawaygal.’ Yesu thanamulpa kuniya mulaydhin, ‘Ngitha yagigal, nungu kupay midh paru? Wa, ngay lak kedha, ngath ngaw kupay seysithamayginga ngithamulpa nubi zagethoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kalanu nuydh ya matha ngoedhagidh ayman, thanamun igilaw yabugud seysithamaypa, ‘Wara mabayg nungu garkaz kazi ukasar, nuy nungu kuykuy kazipa mulaydhin kedha, “Kazi, ngi zagethoepa uzar, ngaw goereypaw apawlagoepa.” ");
INSERT INTO mwp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nuy kuniya, “Lawnga, ngaw ubiginga.” Kasa kay kedha, nuy kuykuy kazi kalanu kay lak karngemidhin, apawlagoepa uzaraydhin, zagethoepa. ");
INSERT INTO mwp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‘Kalanu nuy thathi kuthay kazipa mulaydhin kedha, “Kazi, ngi zagethoepa uzar, ngaw goereypaw apawlagoepa.” Nuy kuthay kazi kedha, “Wa, ngay uzaripa.” Kasa kay kedha nuy apaw lagoepa mabaginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kalanu nuy Yesu yapupoeybaydhin kedha yoewthaw koey mabaygoepa, ‘Mi kazi nanga nungu thathiw ubilnga aymoedhin nanga?’ Thana kuniya, ‘Nuy kuykuy kazi.’ Yesu kuniya, ‘Wa, a ngitha yoewthaw koey mabaygal, ngithamun sakar lak kedha, thana bokadhzoengu garwaydhamay mabaygal a wati pawa yoepkazil, thana ngithamuniya paruya Awgadhaw Basalayapa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoewane Papatayso nanga mina yabugud seysithamadhin, kasa kay kedha ngithamun kawrag koeyza; ngitha nuyn mina yapathamayginga. Matha thana bokadhzoengu garwoeydhay mabaygal, a wati pawa yoepkazil mina yoepathaman nuyn. Ngitha nanga thanamun garki thoeyay imadhin nanga, ngitha kasa lak koerngayg asimoeydhin, lak mina yapathamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Ngitha kurusipagemiw, ngath wara ngithamulpa maypa, ya matha ngoedhagidh. Wara apaw lagaw mabayg, nungu boeradhar koeyza, nuydh goereypaw apawlag aymaydhin mina matha ngoedhagidh. Nuydh pa pagaydhin mura nabiya war war doegamuya. Koey gimanoeka nuydh moegina wetha moeydhadhin, mabaygoepa thuraypa. Wara nuydh kulanu muydh aymoedhin, goereypal nanga almathamoeyn nanga, ikay sinaki pungaypa. Kalanu nuy yoenu madhin senabi apaw lag danal poethay mabaygoepa. Yawoedhayzinga kedha, ayboewdhaw thonar nanga gasaman, mura ayde dhadhiya mamayin nubepa a thanamulpa. Kalanu nuy pathaydhin koeysigal lagoepa. ");
INSERT INTO mwp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","‘Ayboewdhaw thonar nanga nuydh zagethaw mabaygal wayamoeydhin nungu modhabipa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Thana apaw lagaw wati danal poethay mabaygal wati pawa aymoedhin thanamulpa, nungu zagethaw mabaygoepa. Wara thana palngidhin, wara thana umamathamoedhin, a wara thana kulun mathamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","‘Kalanu nuydh wara zagethaw mabaygal wayamoeydhin thanamulpa, a thana wati danal poethay mabaygal lak kedha wati pawa aymoeydhin thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘Moeygapa, nuy mabayg nungu geth kazi wayadhin, nungu modhabipa dhadhiya maypa. Nungu wakay thamamay kedha, “Thana ngaru koeyma apasin ngaw geth kazipa.” ");
INSERT INTO mwp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kasa kay kedha, thana wati danal poethay mabaygal, thanamun wakay thamamay gegeyadh. Thana mura umamoeyr kedha, “Ngalpa nanga nuyn mathaman, nungungu nungu thathiw buthoengu gasamoeyle bangal, ngalpa nubi apawlag gasamoene ngalpan geth za.” ");
INSERT INTO mwp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kalanu thana nuyn gasamoedhin, apawlagoengu nuyn kazi adhathayadhin, a kalanu umamathamadhin.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wa, Yesu kedha yapupoeybaydhin thanamulpa yoewthaw koey mabaygoepa kedha, ‘Nuy mina apawlagaw mabayg na mangedhe nanga, nuydh thanamulpa miza ayimpa wati danal pathay mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Thana yoewthaw koey mabaygal kuniya mulemidhin kedha, ‘Wa, nuydh bangal ngaru umamathamoeyne sethabi wati danal poethay mabaygal a senabi apaw lag bangal mina mabaygoepa manine setha ngaya nanga ngulaygal, thana bangal mura ayde dhadh mamayine.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nuy Yesu lak mulaydhin thanamulpa, ‘Ngitha ngaru ngulaygal Maygi Thusingu nabi Minar Poelayzinga, adhamintiday ya kedha, “Lagaw moeydhayzi mabaygal nanga Thana mina kula adhathayan, wati kulapa thaman. Kasa kay kedha na mina kula, nan ngulayg lagaw konanu kabuthan puridhiripa. Ina zageth ngalpan kuykulmay aymayzinga. Ngalpan imaypa mina adhapudhay.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu lak mulaydhin thanamulpa, ‘Wa, ngay ngithamulpa kedha, Awgadhaw Basalaya bangal ngithamulngu kusumoene a wara buwaypa bangal manine, setha ngaya nanga thanamun igililnga mina koewsalnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Thana kuyku misnarel a Parasayalgal karngemidhin nungu Yesun yangukudu ya, thana tidamoeydhin kedha, nungu yangukudu thanamulpa kuniya. ");
INSERT INTO mwp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Thana buwayal thoeyaymoeydhin nubepa kunumoeypa, kasa kay kedha thana ngaru mabaygoengu akan. Mura mabaygaw wakay thamamay kedha, Yesu nuy peropetha. ");
INSERT INTO mwp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kalanu Yesu lak wara ya matha ngoedhagidh aymoedhin thanamulpa. Nuy kedha, ");
INSERT INTO mwp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘Daparaw Basalaya matha kedha adhapudhay kuykulnga nuydh koey ay ayman nungu garkaz kazipa niyaypa yoelpaypa. ");
INSERT INTO mwp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nuydh nungu zagethaw mabaygal woeyamoeydhin mura yadu thurayzi mabaygal garwoeydhamoeydhin, kasa kay kedha thana mangayginga, thana yadu thurayzi mabaygal ubigigal. ");
INSERT INTO mwp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘Kalanu nuydh wara zagethaw mabaygal wayamoeydhin thanamulpa kedha yadu poelgaypa, “Ngitha sobaginga ayawal, mura zapul buthapoethayzimayl, mura setha bulokal a koey buzaral kazi bulokal thana pugamoeyzimayl!” ");
INSERT INTO mwp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Lawnga, thana mura yadu thurayzi mabaygal kurusipagayginga. Thana matha thanamun geth zagethoepa nagemir, wara mabayg apaw lagoepa, wara mabayg nungu sawalagoepa, a dhuray thana wati danal poethay aymoeydhin nungu zagethaw mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‘Nungu kuyku mabaygaw thabukir mina koeyza, nuydh nungu koewbu mabaygal wayamoeydhin thanamulpa mathamaypa, setha ngaya nanga nubepa koerngayg asimoeydhin. Koewbuwaw mabaygal umamathamoeydhin thana a thanamun goegath muypu nathadhin. ");
INSERT INTO mwp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‘Kalanu nuydh thuremoeydhin nungu zagethaw mabaygal, nuy kedha thanamulpa, “Ngaw niyaypa yoelpay ay mura buth poethayzinga, kasa kay kedha yadu thurayzi mabaygal matha mangayginga. Thana matha ngoedhagidh lawnga nubi koey aypa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngitha ladhu mura koey yabugudiya wara mabaygoepa lumaypa, thanamulpa ngapa thuraypa.” ");
INSERT INTO mwp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Thana nungu zagethaw mabaygal ladhudhin mura yabugudiya, mabaygoepa lumaypa. Thana mabaygal ngapa yoelpamoeydhin koey aypa, kapu mabaygal a wati mabaygal mura kalmel aypa purthaypa. Kurusipa lag mura gudiya yoewdhaydhin, mabayg waza koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Mura sethabi mabaygal ubamoeydhin kapu koey rugal, mi rugal nanga nuy kuykulnga madhin thanamulpa. Matha urapun mabayg nanga kedha rugal ubamayginga. Nuy kuykulnga nanga ngapa nungu mangayzi mabaygoepa imaypa, nuydh iman kedha, urapun mabayg nuy niyaypa yoelpay rugal ubamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nuy kuykulnga kedha nubepa, senawbi mabaygoepa, “Igalayg! Thana midh paru ngin wanan ngibepa muya uthaypa, ngi nanga kayn rugagig?” Kasa kay kedha nuy mabayg ya mulayginga. ");
INSERT INTO mwp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‘Kalanu nuy kuykulnga kedha nungu zagethaw mabaygoepa, “Ngitha nuyn gasamaw, nungu ngar a geth kunumaw a nuyn adhathayaw koey inurpa.” Nungu may a kikir bangal koeyza, nungu bangal dhangal tikitik nudhamane.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu lak mulaydhin kedha, ‘Koeygarsar mabaygal thana Awgadhaw yadu palgayzi mabaygal nungu Basalayoepa, kasa kay kedha nuydh kasa moenari mabaygan gasamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Thana Parasayalgal kalanu ladhudhin, thanamun buwaylthoeyay kedha, thana bangal karum palane Yesun. Thana kedha, ‘Nungu kuniya ya nanga ngoelkay ya, ngalpa bangal nuyn gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Thana nubepa gethawoeyamoeydhin dhuray thanamun puziw mabaygal a dhuray puziw mabaygal Erodhan. Thana ngapa Yesulpa kedha mulemidhin, ‘Ngurpay Mabayg, ngoey ngulaygal kedha, ngi mura thonara mina yadu umepa, nginu ngurpay mina matha ngoedhagidh Awgadhaw ubi seysithamaypa mura mabaygoepa, kuyk ngi mabaygoengu akan lawnga; ngidh koey mabaygoepa a kasa mabaygoepa mina matha kedha nginu ngurpay poeybar.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wa, nungu Romaniw kuyku mabaygaw yawoedhayzinga kedha, mabaygan ngaru nubepa bokadhza thoeyaypa. Thana nubepa lak mulaydhin kedha, ‘Nginu wakay thoemamaynu midh, ngalpan sabinu matha ngoedhagidh ngalpalpa kasa bokadhzapul sakariya thayan Romaniw adhapudhay kuyku mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nuy Yesu ngulayg thanamun wati buwaylthoeyay midh nanga, thanamun ubi nuyn gasamoene. Nuy kedha thanamulpa, ‘Ngitha kasa gimiya muk, muynu loka thoeydhaylnga. Ngithamun ubi ngoena kasa karum poelaypa. ");
INSERT INTO mwp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngitha kedha bokadhza yakamoey ngayapa, mi bokadhza nanga mabaygaw ngulayg Romaniw kuyku mabaygoepa maypa.’ Thana manin nubepa. ");
INSERT INTO mwp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nuydh thana yapu poeybamoeydhin, ‘In ngunu paru a nel bokadhzapunu poelayzinga?’ ");
INSERT INTO mwp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Thana kedha, ‘Senaw nungu, Romaniw kuyku mabaygaw.’ Nuy kedha muliz, ‘Wa, setha mi zapul nanga, nungu Romaniw kuyku mabaygaw rugal, ngalpa nubepa mamayipa; a setha mi zapul nanga Awgadhaw rugal, ngalpa nubepa mamayipa.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Thana na kedha karngemidhin nanga thana koeyma madhu pamemidhin, kuyk thanamun wati buwaylthoeyay kasa idimayzinga. Thana kasa ladhudhin. ");
INSERT INTO mwp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kalanu kay senabi goeyginu thana Sadusayalgal, wara Yoewthaw koey mabaygal, ngapa Yesulpa. Thanamun mina yoepathaman kedha, mabayg nanga um mizin nanga, nuy lak kaday sipa lawnga, nubi gugu ubidh thoeyayzimaynu kuth bangal mangedhe. ");
INSERT INTO mwp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Thana mulemidhin nubepa, ‘Ngurpay Mabayg, Mosen ngurpay kedha, ipilayg mabayg nanga um mizin, nuy kazigig nanga, mina pawa kedha nungu tukuyap ngaru senabi yoepkaz mayk niyaypa yoelpaypa, palamulpa kazimaypa kulay alaypa, nungu buwayngu poethayle. ");
INSERT INTO mwp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wara thonara nanga seben tukuypal si memayipu. Nuy kuykuyg niyaypa yoelpaydhin kasa kedha nuy kalanu umanga kazigig. Kalanu nungu kuthayg senabi yoepkaz mayk niyaypa yoelpaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","‘Kalanu nuy lak kedha umanga kazigig; a nan yoepkaz mayk nungu kuthaygoepa madhin. Thana mura tukuypal yaynanob um memayidhin, kuykuyg kulay kurusipa kuthayg, a na yoepkaz na thanamun mura ipi. Thana mura umamayl. ");
INSERT INTO mwp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Moeygapa na umanga. ");
INSERT INTO mwp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nginu ngurpaynu kedha, nubi gugu ubidh thoeyayzi maynu kuth nanga, mura umaw mabaygal lak kaday nithamoene umangu. Na senabi thonara ngunu ipi bangal aymidhe; thana mura nan niyaypa yoelpadhin?’ ");
INSERT INTO mwp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nuy Yesu kuniya mulaydhin thanamulpa, ‘Ngitha mina koey koerawaygal Minar Poelayzinga midh a Awgadhaw poerapar midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Uma mabaygal mi thonara nanga lak kaday nithamoene, thana matha kedha angelal daparoenu midh, garkaz a yoepkaz lak niyaypa yoelpaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wara kedha, thana uma mabaygal ngaru lak kaday nithamoene, kuyk Awgadhaw yangukudu kedha, ");
INSERT INTO mwp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ngay ngaru Abraman Awgadh, Isakan Awgadh, Yakubun Awgadh.” Nuy lawnga kedha, “Ngay kulay thonar thanamun Awgadh.” Nuy kedha, “Ngay ngaru thanamun Awgadh.” Ngay kedha zoenguz ngithamulpa kedha, thana Abrama ngaru igililmayl.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Thana mura mabaygal na karngemidhin nungu yangukudu thana koeyma madhu pamemidhin, thana kedha ngoedhal ngurpay kulay koerngayginga. ");
INSERT INTO mwp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Thana Parasayalgal nanga karngemidhin kedha Yesun ngurpay kedha bibirilnga a thana Sadusayalgal kalanu yagigal, thana Parasayalgal garwoeydhamoeydhin Yesulpa. ");
INSERT INTO mwp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Urapun thanamun sabiw mgurpay mabayg nuydh yapupoeybay aymoedhin Yesulpa nubepa nuthay aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nuy kedha, ‘Ngurpay Mabayg, mi sabi adhapudhay mura wara sabil ngalpan sabinu?’ ");
INSERT INTO mwp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Nuy Yesu kedha, ‘Adhapudhay sabi kedha, “Ngitha ngaru maman manin ngithamun Kuykulnga mura ngithamun ngoenakapoengu, a mura ngithamun mina muy igililmayngu, a mura ngithamun wakay thamamayngu.” ");
INSERT INTO mwp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wa, sena koey sabi a wara nabiya wagel kedha, “Mi mabaygal nanga ngibiya pasiya, ngidh ngaru thana maman mamayin, matha kedha nginu mam ngidh ngibepa ayman.” ");
INSERT INTO mwp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sepalbi ukasar ngurpay palay kuyk, a mura wara sabil a nungu Mosen ngurpay, sepalbi ukasar sabingu koesimoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Thana Parasayalgal mura garwoeydhamayzimayl nanga, nuy Yesu yapupoeybaydhin thanamulpa kedha, ");
INSERT INTO mwp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","‘Ngithamun wakay thamamaynu midh, Awgadhaw Woeyayzi Mabayg Keriso, nungu muruyg nga?’ Thana kedha, ‘Nuy Dhawithan Kazi, Dhawithan kulkangu.’ ");
INSERT INTO mwp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kuniya, ‘Keriso nanga Dhawithan Kazi nanga, nuy Dhawitha midh paru nuyn kedha tharan, “Kuykulnga”? Nuydh kedha koey yangukudu gasamadhin Maygi Maringu, a mulaydhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Nuy Kuykulnga mulaydhin ngaw Kuykulmaypa kedha, ‘Ngi ngapa in thanuripa ngaw getha doegamoenu, kurusipa ngath nginu mura thabukiriw mabaygal mulupa idimpa; a ngidh ngar tharal thanamuniya gimal.’” ");
INSERT INTO mwp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‘Wa, Dhawitha nuydh nuyn Keriso kedha tharadhin, “Kuykulnga”. Ngitha midh paru ngayapa kedha umamaypa, “Keriso nuy Dhawithan Kazi”. Dhawitha nanga nuydh nuyn kedha tharan, “Kuykulnga”?’ ");
INSERT INTO mwp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Thana mura yangukudugigal nubepa kuniya maypa, a koezi pawpa thanamun aka mina koeyza nubepa wara yapa mulaypa. ");
INSERT INTO mwp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kalanu Yesu nungu ngurpay aymoedhin thanamulpa, mura mabaygoepa yangu lagoenu. Nungu niyaykazil lak puzimoeyr nubiya. ");
INSERT INTO mwp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nuy kedha, ‘Thana sabiw ngurpay mabaygal, thanamun kupay kedha, Mosen Sabi ngurpaypa a sakar maypa mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Thana mina ngurpayngu ngulaygal, kasa kay kedha thana aymayginga. Ngitha thanamun yangukudupa kurusipagemipa, thanamun pawanu puzig. ");
INSERT INTO mwp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Thanamun danal poethay kedha wara mabaygoepa, thana koey mapu mayakal wanepa wara mabaygaw thabaynu, kasa kay kedha thanamulpa urapun zapa maypa lawnga kedha mayakaw oengayzi mabaygoepa ibupudhaypa. ");
INSERT INTO mwp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‘Thana mura thanamun kapu zagethal aymoeypu mabaygaw parunu, kuyk thanamun ubi kedha, mabaygan thana thawmamayipa. Thana ngulayg moegina yanal ubamoeypu paruya, poewthiya a poerthanu, muynu yatharayzimayl, Maygi Thusiw thapiw oengayzimayl. Wa, thanamun kedha moegithap yanal ngaru mura mabaygoepa imaypa. Thanamun koey sodhaw mulupa puzi zamiyakal lak kedha, ngaru mina koey kuykuthalmayl, mura mabaygoepa imaypa. ");
INSERT INTO mwp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Koey ay nanga, thanamun pawa matha kedha, thana mina kapu niyaylagal mamayin thanamulpa. Yoewthanu lak kedha, thanamun geth niyaylagal ngaru wanamoeyn thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Thanamun mina ubi kedha, mabaygal thanamulpa koeyma apasin barpudhay laganu, a thana kedha tharimoeypa, “Koey ngurpay mabayg”. ");
INSERT INTO mwp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Matha ngoedhagidh lawnga ngin kedha tharan, “Koey ngurpay mabayg”, kuyk ngitha ngaru tukuypal kidhakidhan, a ngithamun ngurpay mabayg matha urapun. ");
INSERT INTO mwp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nubi apaw goewanu nanga, ngidh mabayg kedha thoerayginga, “Thathi”, nubepa apasi ayimpa. Minguz kedha, ngithamun Thathi matha urapun sey gimal dapara. ");
INSERT INTO mwp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kuykulnga lak kedha, ngitha mabayg kedha thoerayginga, “Kuykulnga”, ngithamun Kuykulnga matha urapun, nuy Awgadhaw Mina Woeyayzi Mabayg. ");
INSERT INTO mwp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","‘Nga nanga ngithamun koey mabayg, nuy ngaru ngithamun zagethaw mabayg. ");
INSERT INTO mwp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngadh nanga nungu nel kadaypa maypa, nuyn bangal mulupa manine, a nga nanga koeyma apa pudhiz, nuyn bangal kadaypa manine.’ ");
INSERT INTO mwp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Nag, ngitha sabiw ngurpay mabaygal a Parasayalgal, ngithamun igililnga koey gegeyadh bangal, ngitha kasa gimiya muk, muynu loka thoeydhaylmayl. Ngithamun pawa kedha, ngitha Daparaw Basalaya gud mathampa, wara mabaygoengu muy oerayle; a ngitha lak kedha ngithamulpa muy oeraypa lawnga. Ngitha daparpa ubigigal, ngitha midh paru wara mabaygal wadhepa. ");
INSERT INTO mwp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘Ngithamulpa koey gegeyadh bangal, ngitha sabiw ngurpay mabaygal a Parasayalgal, ngithamun zageth mamu mina lawnga. Ngitha kedha memayipa, ngitha mura wadhwadhgamupa, wara mabaygoepa lumaypa, thanamulpa garki thoeyaypa ngithamun amenipa. Ngithamun lumay mina koeyza, kasa kay kedha, mabayg garki thayiz nanga, ngitha mina wati ngurpay ayman nubepa, kurusipa nuy adhapudhay wati mabayg aymiz, ngithamun wati pawa midh nanga. Nuy Sathanan kazi aymiz. ");
INSERT INTO mwp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Ngithamulpa koey gegeyadh bangal, ngitha kuyku mabaygal wara mabaygoepa yoelpaypa, kasa kay kedha ngithamun yoelpay ngoedhe kedha maygum midh, nuydh wara maygum yoelpaypa. Ngitha mina yabugud tidayginga. Ngithamun ngurpay kedha, mabaygan nanga koey yoewth tharan nungu yawoedhayzi yapa ridhapoelaypa, nubepa moegina zageth senabi yawadhayzinga patidaypa, kasa kay kedha mabaygan nay koey yoewthaw goli tharan nay nungu yapa ridhapoelaypa, nuydh ngaru ayman nungu yawadhayzinga midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","‘Ngitha matha kedha maygum midh, sethabi ngurpayl kasa ngithamun geth wakay thamamayil. Koey yoewth ngaru adhapudhay nanu golingu. Senabi golin nanu maygi woenab gasaman koey yoewthangu. ");
INSERT INTO mwp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wara ngithamun ngurpay lak kedha gegeyadh; mabaygan nanga olta tharan nungu yawadhayzinga ridhapoelaypa, nubepa moegina zageth nungu yangukudu patidaypa bangal, kasa kay kedha nuydh nay kozan tharan oltanu gimal, nuydh ngaru ayman nungu yawadhayzinga midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","‘Lawnga ngitha matha kedha maygum midh. Olta ngaru adhapudhay uruy kozaningu; senabi uruy kozan nanu maygi woenab gasaman oltangu. ");
INSERT INTO mwp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kedha kay, mi thonara nanga mabaygan olta tharan nungu yawadhayzinga ridhapoelaypa, senabi kozan ngaru urapumayn oltanu. Nuydh nanga olta tharan nanga, urapumayn muynu kozaniw zapul. ");
INSERT INTO mwp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Koey yoewth lak kedha, mabayg nanga koey yoewth tharan, nungu ya wadhayzinga ridhapoelaypa, nuydh urapumayn muynu Awgadh tharan, koey yoewth waza nungu niyaylag. ");
INSERT INTO mwp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dapar lak kedha, mabaygan mi thonara nanga dapar tharan; wa dapar matha kedha Awgadhaw apaniyaylag, a nuy tharayzi mabayg, nuydh urapumayn muynu Awgadhaw maygi nel tharan. ");
INSERT INTO mwp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Ngithamulpa koey gegeyadh bangal, sabiw ngurpay mabaygal a Parasayalgal, ngitha kasa gimiya muk, muynu thoeydhayl umayl. Ngitha mura moegithap sabil aymoeypa koey yoewthaw doegumuya. Ngithamun bokadhzapul a ayzapul mura dhadhiya dhadh mamayin koey yoewthoepa a ngithamulpa. Ngithamulpa koey zageth urapun moegithap nagungu yakanuraypa, thana ngaru mura dhadhiya dhadh mamayin Awgadhoepa, kasa kay kedha ngithamulngu yakanuriz mura Awgadhaw koey sabil. Ngitha ngulaygal wara mabaygiya balpudhemin mura thonara. Ngitha mina pawangu koerawaygal; a gabu ngoenakapu pawangu koerawaygal. Ngitha mina kapu akasizi mabaygal lawnga. Kapu za kedha, ngitha moegithap zagethal aymoeypa a koeythap kapu zagethal aymoeypa. Ngitha matha kedha maygumal midh, ngithamulpa koey zageth yakamoeypa mina yabugud wara mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","‘Ngitha Awgadhaw sabil balbayginga pudhamoeypa lawnga. Ngithamun karum kedha, pasiw sabil nanga ngitha parul thoeyamoeyn; kuyku sabil nanga ngitha kasa pasiya wanamoeyn. Ngithamun ngurpay kedha, mabayg midh nanga nguki woenipa mepa; kedha nanga moegina iwi pudhiz muynu, nuydh ngaru nan adhapa maypa. Kedha nanga koey tetel uruy pudhiz ngukinu, nuydh mabaygan uruy wanin urapumayn ngukiya kalmel. Nuydh senabi uruy imayginga. ");
INSERT INTO mwp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Ngithamulpa koey gegeyadh bangal ngitha sabiw ngurpay mabaygal a Parasayalgal, ngitha mowaw parul woeydhemipa. Ngitha koeyma garwalgamoeypa ngithamun aygudaw disal. Thana adhiya koey pudhumayl kasa kedha muy dagam koey gegeyadh. Thana minguz koey gegeyadh muynu? Kedha zoenguz kedha ngithamun karum palay zageth. ");
INSERT INTO mwp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kuyk na gegeyadh nanga, koewb lak gegeyadh, ngidh mamu balbay tidan sethabi wati zapul muynu a kalanu nginu aygudaw rugal ngaru mura pudhunga muya a adhiya. ");
INSERT INTO mwp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","‘Ngithamulpa koey gegeyadh bangal ngitha sabiw ngurpay mabaygal a Parasayalgal. Ngitha kasa azaz paru woeydhemipa, ngitha matha kedha kayn awin pinizi kula midh nanga mabaygaw moeram. Muynu kulba ridhal a woesimayzi gamul, a ngithamun igililnga lak kedha paruya balbayginga, muynu gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Ngithamulpa koey gegeyadh bangal ngitha ngulaygal kulkubaw peropethaw moeramaw lagal mina balbayginga danal poethaypa, a wara parul kulkubaw mina mabaygoepa lak kedha ngitha mina danal poethaypa. Lawnga ngitha kasa gimiya muk, muynu ngitha matha kedha ngithamun thathiw thathil midh. Thana ngulaygal Awgadhaw maygi peropethal umamathamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ngitha kedha mulemin, ngitha nay sethabi thonar sey ngitha aymayginga nay, ");
INSERT INTO mwp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","kasa kay kedha ngithamun ya kedha, ngitha thanamun kaziw kazil, a ngay ngulayg kedha, ngitha matha kedha wati mabaygal thana midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Thana nabi za kuykaymadhin a ngitha aymoeyziw. ");
INSERT INTO mwp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Ngitha thabul a thabu kazil. Ngithamulpa bangal koey zageth aymidhe bup oeraypa senabi woesimoeygi muyngu? ");
INSERT INTO mwp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wa, ngay ngithamulpa kedha, ngath ngithamulpa wayane bangal peropethal, a ngulayg mabaygal Awgadhaw, a Awgadhaw. Ngithamun danal poethay thanamulpa lak kedha gegeyadh bangal. Dhuray ngitha ngulayg mathamoeyne bangal a dhuray ngitha sathawro puydhamoeyne, a dhuray nanga ngitha palngemoeyne ngithamun yoewthanu dhadhal, a thana adhapa wayamoeyne mura ngithamun goegathoengu, wara goegathoengu wara goegathoepa. Ngitha kedha zoenguz wati kuth gasamoene bangal, kuyk ngitha mina mabaygal mathamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngitha mina wati maykuyk. Thanamun kulka wal mizin Awgadhoepa, ngithamun wati zageth pugamoeyn. Thana mura kuykugi umamathamayzi mabaygal, mamu Adhaman kazi Abelu, kurusipa Zakaraya, Berekayan kazi ngan nanga mathamoedhin koey yoewthanu muynu, oltanu amadhan. ");
INSERT INTO mwp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngay ngithamulpa mina muliz kedha, ngitha nubi maykuyk wati kuth gasamoene bangal, mura thabi wati pawangu.’ ");
INSERT INTO mwp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kalanu nuy Yesu koey goegathoepa buwayl thayadhin a nungu koey ngoenakap mapu yakamadhin kedha, ‘A! Yoerusalema, Yoerusalema, ngitha mura thonara Awgadhaw peropethal uma mathamoeypu, a kulan dhanamoeypu Awgadhaw woeyayzi mabaygal ngithamulpa. Koeyma thonaralnga ngaw mina ubi ngath Ngaga toeydhamoeypa ngaw geth mura ngithamuniya, Yoerusalemaw mabaygiya, ngoedhe apu pawl ngaga toeydhamoeypu nanu kazil boethanu muynu, kasa kay kedha ngitha ngithamun ubiginga ngawngu. ");
INSERT INTO mwp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","‘Kedha kay ngitha ngithamun geth yabugud ayman, kurusipa bangal ngithamun koey yoewth ngaru mabaygoegi dhadhabuth, woenaboeginga. ");
INSERT INTO mwp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Koezi kayboengu ngithamulpa ngayapa lak imaypa lawnga, kurusipa bangal ngitha mura ngoena imane, a ngithamun kalmel thawmayzi yangukudul kedha, “Awgadhaw woenab a poerapar daparngu seyzi mulupa. Awgadhan ngin ngapa wayan nungu kupaypa oengaypa.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kalanu thana ladhudhin, Yesu a nungu niyaykazil. Si koey yoewthanu adhal memayir, thana niyaykazil nubepa mulemin kedha, ‘Kuykulnga, ngidh iman kedha, nubi koey yoewth mina kapu kulaw moeydhayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kuniya muliz thanamulpa, ‘Wa, sepa nagemiw, setha mina koey kulal, kasa kay kedha kalanu bangal thana kasa mulupa pudhemine, wara kulaginga bangal gimal, mura mulupa idimoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu kalanu padapa uzaraydhin, Olibaw Pad. Matha nungu niyaykazil nubiya ladhudhin. Wara mabaygoeginga, thana nubiya kuyk wakaydhin kedha, ‘Sethabi mura zapul nanga, ngidh kulay pudhamoeynu, thana bangal mi thonar mangemine. Ngoey midh paru bangal ngulayg asimoeyne kedha, thonar amadhan thamiz, ngibepa kuniya mangaypa, a nubi gugu ubidh thoeyayzimaynu kuth.’ ");
INSERT INTO mwp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nuy kuniya muliz, ‘Thonaral koeygarsar, wara ngoelkay, wara mina. Ngitha koey poeypiyam a wergoegadhasig bangal, ngoelkay mabaygoengu ngithamulngu karum poelayle. ");
INSERT INTO mwp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kedha mabaygal bangal mangemine a sole ya umamoeypu yaynanob kedha, “Matha ngay Kuykulmayngu ngapa ngithamulpa. Ngay nungu Mina Woeyayzi Mabayg.” Wa kedha ngoedhal mabaygal bangal mangemine; koeygarsar mabaygal thanamulpa ruwamoeyne bangal, sethabi ngoelkay mabaygiya asimoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","‘Wara kedha, mabaygal bangal koeyma silamoeypu ngithamuniya amadhan a ngithamulngu koeysigal. Amadhan nanga ngitha koewbu nur karngemine, koeysigal nanga ngitha koewbungu yangu wakay gasamoene. Sethabi thonaral ngaru kulay mangemine, mina thonar matha lawnga ka nubi gugu ubidh thoeyayzimaynu kuth. ");
INSERT INTO mwp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mamu kedha, mura koey goegathal ngaru pazal memayipu kidhakidhan, a koey aygi wathal bangal mangemine, a nubi apaw goewaw boeradhar mura wadhwadhgamuya garguy medhedhe. ");
INSERT INTO mwp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","‘Mura thabi zapul kulay. Wagel bangal sirisir koeyza aymidhe. Kulay mapul nanga, setha ngoedhe yoepkaziw kayn kazimay kikir kayn gamuthariz, kulay kasa moegina, wagel bangal koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Sethabi thonaral nanga, thana bangal dhoerdhimoeypu ngitha, wati danal poethay mabaygoepa, umamathamayzi mabaygoepa mamayipu ngitha. Wa, mura nubi apaw goewaw mabaygan bangal wati ngoenakap gasampu ngithamulpa, minguz kedha ngitha ngaw gamu puziw mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kalanu koeygarsar mabaygoepa lak puzipa lawnga ngaybiya, kuyk thana mabaygoengu akan. Thanamuniya midh thonara nanga sirisir puydhiz, thana lak ngaw niyaykazil lawnga. Mabaygal sethabi thonara koeyma imul pathamoeypu kidhakidhan, a wati ngoenakap koeyza bangal meparu senabi thonara. ");
INSERT INTO mwp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","‘Kalanu koeygarsar wati peropethal yakamoeyne, thana kasa ngoelkay ngaw mabaygal aymoeypa; thana ngulayg mabaygal karum poelimoeyn. Koeygarsar mabaygal adhapa ruwamoeypu mina yabugudoengu thanamuniya, wati peropethaya asimoeypu. ");
INSERT INTO mwp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kawrag bangal mina koeyza, a mabaygaw mam Awgadhoepa mamu mina lawnga; mam kasa moegina. ");
INSERT INTO mwp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","‘Kasa kay kedha, mura setha ngaya nanga mina parul thoeyayzimayl Awgadhoepa, thana lak puzimoeypa nubiya, wa kurusipa thana kuth gasamoene balbayginga. Kedha mabaygal matha ngoedhagidh Awgadhaw Basalayapa. ");
INSERT INTO mwp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wa, Awgadhaw kapu yangu wakay nungu basalaya midh nanga, mamu yadu poelgayzinga mura nubi po gubaw gizuya, mura mabaygoepa yakamaypa, Awgadhaw ngurpay midh nanga. Wa, sew kalanu kuth gasamoene nubi gugu ubidh thoeyayzimayngu. ");
INSERT INTO mwp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Wa kalanu bangal ngitha imane abere wati ngoedhathoeyay, miza nanga nuy kulkubaw peropetha Daniyel yadupalgadhin kedha, “Ngitha bangal imane abere wati ngoedhathoeyay, Awgadhaw maygi lagoenu dhadhal.” Ngitha mura getha tiday mabaygal matha ngoedhagidh kedha, ngitha nubi ya tidan. ");
INSERT INTO mwp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Senawbi thonar mina wati thonar. Ngitha ngaya nanga sey Yoewdhayawl doegamoenu nanga, ngitha kasa sobaginga padapa zilmemin. ");
INSERT INTO mwp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ngitha setha ngaya nanga gabupa thanuriz sey gimal thodhanu, ngithamulpa koey zageth lagapa muy yoewthaypa, rugapa gasamoeypa, lawnga ngitha matha zilmemin. ");
INSERT INTO mwp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngitha ngaya nanga apawlagoenu, lak kedha lagapa kuniya tidayg sumay sodhoepa. ");
INSERT INTO mwp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Thana maythalgal yoepkazil ngaya nanga maythalgal a moegina mapethalgal, thanamun sirisir mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","‘Kapu za ngitha Awgadhoepa yoewdhemin, kedha za wati thonarngu dhadha mangayle, a sabadhoengu mangayle. Sumayl thonar nanga apupa, mapethoepa mina wati igililnga sey bupiya, mura mabaygoepa wati igililnga. Kedha wati thonar ngaru adhapudhay mura wati thonaral nubi gugu ubidh thoeyayzimayngu samayngu ngapa, a lak kedha seyzi pawpa kurusipa nubi gugu ubidh thoeyayzimayngu kuth, kedha ngoedhal wati thonarginga. ");
INSERT INTO mwp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kasa kay kedha Awgadh nuydh nan lak thawpayn pathan, senabi wati thonar; nuydh aymayginga nay mura mabaygal ngaru um pudhepa, kurusipa mura eygi thoeyamoeyn. Nuydh minguz nan thawpayn pathan, kuyk nungu yadu thurayzi mabaygal, setha ngaya nanga nuydh nubepa mamayin. ");
INSERT INTO mwp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Ngath kedha zoenguz ngithamulpa mura sakar pudhamoeyn nubi ngulayg; wara mabayg sike ngithamulpa muledhe bangal, “Mesaya in Awgadhaw Mina Woeyayzi Mabayg,” lawnga, wara mabayg kedha, “Awgadhaw Mina Wayayzi Mabayg sey senabi goegathoenu.” Ngitha kedha ngoedhal yangukudul mina yoepathamayg, setha kasa ngoelkay yangukudul. ");
INSERT INTO mwp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngoelkay peropethal mangemine bangal, a wara ngoelkay mabaygal ngaya nanga kedha yaynanob umamoeypu, “Matha ngay Awgadhaw Mina Woeyayzi Mabayg.” Thana kedha ngoedhal mabaygal ngulaygal adhapudhay zagethal aymoeyne bangal, senabi thonara. Thanamun kasa ubi kedha, thana Awgadhaw mina thurayzi mabaygal adhapa yoelpamoeyne wati yabugudoepa. ");
INSERT INTO mwp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","‘Wa, ngitha karngemiw, ngay kulay muliz ngithamulpa, thanamulngu ngithamulngu karum poelayle bangal. ");
INSERT INTO mwp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mabaygal sike kedha mulemine, “Awgadhaw Mina Woeyayzi Mabayg sey bupanu,” lawnga mabaygal kedha, “Nuy sey gumi lagoenu muynu.” Ngitha thanamulngu mina yoepathamayg. ");
INSERT INTO mwp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‘Mi thonara nanga Mabaygaw Kazi mangedhe bangal, ngay mura mabaygoepa kakal yakamidhe, matha kedha poenipoen midh mura yakamiz dapariya woewra doegamoengu kuki doegampa. ");
INSERT INTO mwp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mina thonara nanga na ngaru kakal mura mabaygoepa, matha kedha ngagalgal ngaru kakal mura mabaygoepa, ngoedhe uruyn nurimpa gibidhoepa. ");
INSERT INTO mwp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Sethabi wati goeygil kulay, na matha kedha kulba Minar Poelayzinga midh nanga, “Kalanu goeyga zurug asin, a moelpal buyag asin, a setha nanga thithuyl pudhemin daparoengu mulupa. Wa, sethabi mura koey bibiril zugubal, thana mina bibirig asimoeyn.” ");
INSERT INTO mwp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mabaygaw Kaziw maku kalanu kakal aymiz daparoenu. Senabi thonara mura nubi apaw goewaw buwayl koeyma ngudi sulemin. Kalanu ngay Mabaygaw Kazi mura mabaygoepa kakal aymiz. Ngay bangal senawki ngapa dapariya ziyaya gimiya, bibir a poerapar mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","‘Kalanu koey bu poeybedhe, a ngaw angelal kalanu wayamoey ne wara wadgoepa nubi po gubaw gizuya, ngaw adhapa thurayzi mabaygoepa garwoeydhamoeypa, ngayapa mura wadhwadhgamungu. ");
INSERT INTO mwp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Wara aypuykoewsa ngalpaniya nungu nel dhani, kapu za ngitha nubiya ngurpemipa. Nuy nanga mura maludh gamulnga aymiz a kayn nikil malguy adhamoeyn nungu thamoengu, ngitha ngulayg asimoeyn kedha, naygay thonar amadhan thamiz. ");
INSERT INTO mwp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","‘Wa, ngitha mi thonara bangal thabi moegithap zapul imamoeyne, ngaw kulay yangukudu ya midh nanga, ngitha ngulayg asimoeyne kedha, Mabaygaw Kaziw mangay amadhan. ");
INSERT INTO mwp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kedha yakanurayg, mi thonara nanga mura thabi thonaral yakamoeyne bangal, dhuray mabaygal kaybaw maykuykoengu, matha memayipa. ");
INSERT INTO mwp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","‘Kurusipa nabi apa goewa a dapar idimidhe bangal a muwasin kasa kay kedha ngaw yangukudupa ngaru muwasiginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu lak mulaydhin thanamulpa, ‘Mabaygoeginga ngulayg kedha ngaw Mabaygaw Kaziw mi thonara lak ngapa kuniya. Ngalpa goeygingu koerawaygal, awangu koerawaygal. Thana daparaw angelal a matha kedha ngay ngoey mura koerawaygal. Matha Thathi kedha ngulayg, ngay mi thonara lak ngapa kuniya. ");
INSERT INTO mwp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Thonar na gasamoene bangal matha kedha Nowan thonar midh, kulkub mangaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Senabi koey dudupay na mangaydhin nanga, mabaygal koeyma madhu pamemidhin; senabi goeyginu parunu thanamun igililnga matha kedha mura thanamun goeyginu midh nanga, thana ay purthar, a dhuray thanamulngu getha dhoerdhimay goeyga. ");
INSERT INTO mwp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mi thonar Nowa a nungu buway koey butapa muy thayadhin nanga thana mura wara mabaygal lak tidayginga, Awgadhaw buwaylthoeyay midh nanga, kurusipa koey woer gamutharaydhin, mura sethabi mabaygal mathamoeydhin. Mi thonar nanga ngay Mabaygaw Kazi lak ngapa kuniya, na lak kedha Nowan thonar midh nanga, koeygarsar mabaygal buth poethayginga. ");
INSERT INTO mwp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Senabi thonara bangal ngaw gasamayzi mabaygal ngaru adhangulamoeyne. Ukasar mabayg nanga kalmel zagethan memampa apaw lagoenu, thana ngaw garwoeydhamayzi angelal sepa nanga palamulpa, thana ngulayg wara mabayg oengane a wara mabayg kasa wanan. ");
INSERT INTO mwp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ukasar yoepkaz nanga palamun kalmel kunaw zageth, angelal na mangemin nanga wara yoepkaz sike thanamuniya, a wara kasa wanan sike. ");
INSERT INTO mwp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ngitha thural yoewaypu bangal, ngitha mura koerawoeygal ngithamun Kuykulmayngu nuy mi thonara lak ngapa kuniya bangal. ");
INSERT INTO mwp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kedha yakanurayg, mi mabayg nanga nuy lagalayg, nuy ngaru koey poeypiyam mura thonara, puru mabaygoengu muya uthayle. Lagaw mabaygan wara thonara giyaw woengayginga nanga, wa senawbi thonara za mangiz. ");
INSERT INTO mwp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A ngitha lak kedha ngaru mura thonara buth pathayzimayl, kuyk ngaw Mabaygaw Kaziw kuniya mangay aymidhe bangal ngidh midh thonara nanga ngitha wakay thamamayn gasamayginga. ");
INSERT INTO mwp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Nga nanga Awgadhaw mina zagethaw mabayg. Nuy ngoedhe kedha mabayg ngabepa kupay poeybayzinga kedha, nuydh dhuray wara zagethaw mabaygal danal pathepa, thanamulpa minamaypa thanamun ayde zapul. Nuydh ngaru ayman balbayginga senawbi zageth. ");
INSERT INTO mwp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kapu woenab nubepa zagethaw mabaygoepa kedha, nungu kuyku mabaygan nanga iman nuyn, nuy matha zagethan mepa, kuyku mabaygaw yangukudu midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","‘Ngay ngithamulpa mina yadu umepa kedha, nuy kuyku mabaygan ngaru bangal gimaw kupay manine senawbi zagethaw mabaygoepa. Kalanu bangal nuy mura sethabi lagaw zapul danal pathepu. ");
INSERT INTO mwp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wa, kedha balbayginga, nuy wati zagethaw mabayg nay nuy kedha mulaydhin nay, “Ngaw kuykulnga koey kuykuthalnga adhal, nubepa ngapa mangaypa lawnga.” ");
INSERT INTO mwp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nuydh sike wati pawa ayman nay, wara zagethaw mabaygal koeyma mathamoeypu, a nungu kunubur koeyma, gurukun koeyma woenipa mura wati mabaygiya kalmel a ayde lak kedha koeyma purathipa. ");
INSERT INTO mwp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‘Zagethaw mabaygan kedha wati pawa ayman nay, kurusipa nungu kuykulnga kasa gumi mangiz, a nungu wati pawa nuydh iman, ");
INSERT INTO mwp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nuydh nuyn koeyma palngin, kalanu nuyn adhathayan mura wati mabaygiya kalmel. Thanamun kalmel may mina koeyza a thana tikitik nudhemipa dhangal.’ ");
INSERT INTO mwp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu lak mulaydhin thanamulpa kedha, ‘Senabi goeyginu Awgadhaw Basalaya matha kedha ten ngoewakazil midh nanga. Thana niyaypa yoelpay aypa memayidhin. Thanamuniya yaynanob moegina lamal, a thana si ugadhin niyaypa yoelpayzi garkaz. ");
INSERT INTO mwp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Thanamulngu payb koerngayl ngoewakazil a wara payb koerngaygi ngoewakazil. ");
INSERT INTO mwp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","‘Wara payb thanamuniya kasa moegina idi buyunu thanamun geth lamapa malaypa. Wara payb nanga thana lak idi oengayginga thanamun lamapa malaypa. ");
INSERT INTO mwp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Thana koey kuykuthalnga ugadhin nuyn niyaypa yoelpayzi garkaz. Nungu sob nanga thana moegina uthuy poeydhadhin, kurusipa dhadha kubil gasamoedhin, ");
INSERT INTO mwp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","mabaygal wal memayidhin kedha, “Kayn alay in, ayawal ngitha mura nubepa imaypa.” ");
INSERT INTO mwp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‘Thana ten ngoewakazil mura danpalemidhin, thanamun lamaw wikil balbay tidamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Thana koerngaygi ngoewakazil imadhin kedha, thanamun lamal amadhan woesimoeypa, thana kedha koerngayl ngoewakazoepa, “Ngitha gar ngoeymulpa moegina idi malaw ngoeymun lamoengu woesimoeyle?” ");
INSERT INTO mwp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Thana kuniya mulemidhin thanamulpa, “Kedha lawnga ngoeymun idingu eygithoeyayle. Ngoeymun idi kasa moeginamayl. Ngitha ladhu barpudhay lagapa, ngithamun geth idipa barpudaw.” ");
INSERT INTO mwp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Kalanu thana koerngaygi ngoewakazil ladhudhin, kasa kay kedha thana nanga sey barpudhay lagoenu mangemidhin nanga, kayn alay mangiz. Thana koerngayl ngoewakazil nubiya kalmel muya uthemidhin niyaypa yoelpay aypa. Kalanu pasa gud matha-maydhin. ");
INSERT INTO mwp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‘Thana koerngaygi ngoewakazil lak kuniya mangemidhin barpudhay lagoengu kasa kay kedha pasa gud mathamayzinga. Thana nubepa kayn alaypa wal memayidhin kedha, “Ngidh gar pasa pudhar ngoeymulpa muy uthaypa?” ");
INSERT INTO mwp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Nuy kayn alay kuniya muliz thanamulpa, “Lawnga ngay ngithamulngu koerawayg, ngayapa pasa pudhaypa lawnga.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kalanu nuy Yesu kedha thanamulpa niyaykazipa, ‘Ngitha bangal koeyma thural yoewaypu, ngaw kuniya mangay lak kedha, ngitha goeygingu koerawaygal, a awangu koerawaygal.’ ");
INSERT INTO mwp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Ngaw kuniya mangay matha kedha kuyku mabayg midh nuy yawarpa ubin mepa, koeysigal lagapa. Nuydh mamu nungu thoeri zagethaw mabaygal thurimoeydhin nubepa, nuydh thanamulpa bokadhzapul mamayidhin thanamulpa moegina bokadhzoengu zagethoepa aymoeypa nungu yawaraw sob. ");
INSERT INTO mwp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‘Mabayg nanga bokadhzoengu sakarngu koey ngulayg nanga, nuydh nubepa koey bokadhzapul mamayidhin, mabayg nanga kasa moegina ngulayg, nubepa kasa moegina bokadhza madhin. Nuydh thanamulpa kedha mamayidhin, wara mabaygoepa $5,000 wara mabaygoepa $2,000 a moeygapa mabayg nanga, nuydh nubepa madhin $1,000. Kalanu nuy miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nuy kulay zagethaw mabayg nanga, nuydh sethabi $5,000 madhin barpudhay lagoepa, a nuydh kapu zageth aymoedhin, kurusipa nuydh lak wara $5,000 ukamadhin kuniya. ");
INSERT INTO mwp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","‘Nuy wara zagethaw mabayg nuydh nungu $2,000 madhin barpudhay lagoepa a kapu zageth aymoedhin, kurusipa nuydh lak wara $2,000 ukamadhin kuniya. ");
INSERT INTO mwp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","‘Nuy moeygapa zagithaw mabayg nanga, nuydh kedha aymayginga, wara zagithaw mabayg midh nanga. Nuy kasa kedha aymoedhin, boeradhoeranu muynu moerama thayamoeydhin sethabi nungu kuyku mabaygaw bokadhzapul. ");
INSERT INTO mwp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Wara thonara nanga thanamun kuyku mabayg lak kuniya tidaydhin thanamulpa, thanamun bokadhzoengu zagethoepa minamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nuy kulay zagithaw mabayg nuydh nubepa ngapa madhin wara $5,000. Nuy kedha nungu kuyku mabaygoepa, “Ngidh ngayapa madhin $5,000, wa ina nabiya wara $5,000 ukamoeydhin ngaw zagethoengu.” ");
INSERT INTO mwp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Nungu kuyku mabayg kedha mulaydhin, “Nginu zageth matha ngoedhagidh. Ngidh moegina zageth matha ngoedhagidh oengadhin, wa ngath ngibepa koey kupay manin. Ngi bangal ngaw koey bokadhzoengu danal poethay mabayg. Aya ngapa ngayapa, ngoeba kalmel ika dhiw gasampa, ngaw woenabal igililnga na lak kedha ngibepa.” ");
INSERT INTO mwp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘Nuy wara zagethaw mabayg lak kedha ngapa nungu kuyku mabaygoepa. Nuy kedha mulaydhin nubepa, “Ngidh ngayapa madhin $2,000, in nubiya wara $2,000 ukamoeyngu ngaw zagethoengu.” ");
INSERT INTO mwp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Nuy kuyku mabayg kuniya muliz, “Eso ina mina zageth nginu. Nginu kupay nanga kulay apal, ngidh mina zageth aymoengu. Wa ngath nginu kupay koeyma kadaypa manin, ngi kalanu lak kedha ngaw koey bokadhzoengu danal poethay mabayg. Aya ngayapa ngapa, ngoeba kalmel ika dhiw gasampa, ngaw woenabal igililnga lak kedha ngibepa.” ");
INSERT INTO mwp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘Kurusipa nuy moeygapa zagithaw mabayg ngapa nungu kuyku mabaygoepa. Nungu danal poethayzi modhab kedha, $1,000. Nuy nungu kuyku mabaygoepa kedha mulaydhin, “Kuyku mabayg, ngay ngulayg kedha, ngi koey dharadh mabayg nginu zagethaw mabaygoepa, ngidh ngulayg ayde gasamoeyn wara apawloegoengu, mi apawlag nanga na wara mabaygaw uthuyzinga, nginu magawngu lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wa, ngay kedha zoenguz koeyma akan miyaydhin nginu bokadhzoengu sagul poelayle barpudhay lagoenu. Ngay kedha zoenguz nginu bokadhzapun kasa moerama thoeyamoeydhin. Ina ngath ngibepa kuniya manin nginu $1,000.” ");
INSERT INTO mwp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Nuy kuyku mabayg kuniya muliz kedha, “Ngi mina wati zagethaw mabayg, koey goegadhinga. Ngi ngulayg kedha, ngayapa aypa gasamoeypa wara mabaygaw magawngu, a ngayapa ayboewdhaw thonara aypa garwoeydhamoeypa ngalagiya nanga ngath kapul uthuyginga. ");
INSERT INTO mwp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wa, ina kedha nanga, ngi ngulayg kedha ngaw ubi midh nanga, ngidh midh paru ngaw bokadhzapul bangoepa mayginga? Ngidh nay kedha aymoedhin nay ngath ngaw bokadhza kuniya gasaman nay nabiya moegina lak ukaman kuniya bokadhzoengu danal poethay mabaygoengu.” ");
INSERT INTO mwp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Nuydh kuyku mabaygan nungu wara zagethaw mabaygal thuraydhin, kalanu thanamulpa kedha muliz, “Ngitha setha $1,000 nungungu mariw, a wara zagithaw mabaygoepa mariw, nubepa ngadh nanga lak ukaman $5,000 dolangu $10,000 oepa. ");
INSERT INTO mwp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Thana setha ngaya nanga aydegal nanga, thanamulpa lak ukaman, kurusipa thana koey aydegal; kasa kay kedha thana setha ngaya nanga aygigal zagigal, thanamun kasa moenarimayl rugal kalanu thanamulngu kusumoeyn. ");
INSERT INTO mwp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","In nubi zagethaw mabayg nuy kasa wati mabayg. Ngitha nuyn adhathayaw inurpa, nuy kay sey mayoersiziw a tikitik nudhamoeziw nungu dhangal.” ");
INSERT INTO mwp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Kurusipa bangal ngay Mabaygaw Kazi ngapa kuniya tidedhe ngaw kuykulmay kupaypa aymoeypa, ngaw angelal ngaybiya kalmel senawbi thonara. Ngay bangal ngaw adhapudhay kupay niyaylagoenu thanuridhe. ");
INSERT INTO mwp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mura nubi apaw goewaw mabaygal senawbi thonara garwoeydhamoeyne ngaybiya parunu. Ngaw minamay zageth kedha, ngath mabaygal dhadhpoelamoeyne ukasar doegampa, matha kedha mamuy danal poethay mabayg midh nanga, nuydh mamuyl wara doegampa mamayin, a nanil wara doegampa mamayin. ");
INSERT INTO mwp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","‘Setha ngaya nanga mina mabaygal, matha kedha mamuyl midh nanga, ngath getha doegampa mamayin, a setha ngaya nanga wati mabaygal matha kedha nanil midh nanga ngath boedha doegampa mamayin. ");
INSERT INTO mwp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‘Ngaw senawbi thonaraw Kuykulmay yangukudu getha doegam mabaygoepa kedha, “Ngitha ayawal, Ngaw Thathiw woenab ngithamuniya mepa, ina kedha thonar nungu basalaya ngithamulpa kozan. Nubi basalaya ngithamulpa mina balbayginga buthapoethayzinga nubi gugu ubidh thoeyayzimay kuykoengu ngapa, ina dhadhabuth mina matha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wara thonara nanga ngaw maytha ayginga, a ngitha ngayapa ay manin. Ngoena wara thonara ngukin naynin, ngitha ngoena poeyban ngukin. Ngay wara thonar azaz mabayg igalgoegig, ngitha ngoena ayawal manin, ngithamun lagoepa. ");
INSERT INTO mwp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngay wara thonara rugagig nanga, ngitha ngoena rugan ubaman. Ngay kikirilayg nanga ngitha ngoena danal pathan, ngay dhoerdhimoeyzig nanga ngitha ngaybiya gamuya memayipa zeylaya.” ");
INSERT INTO mwp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Kalanu thana setha mina mabaygal kuniya mulemine ngayapa, “Kuykulnga, ngoey kedha zoengu koerawaygal, ngoey nginu paru kulay imayginga, ngoey midh thonar ngin imadhin aygig a ngoey ngin aydu poeyban, lawnga ngi ngukigig ngibepa nguki manin? ");
INSERT INTO mwp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ngoey mi thonar ngin imadhin igalgoegig a ngoey ngin ayawal manin ngoeymun lagoepa, lawnga ngi rugagig a ngoey ngin ubaman rugan? ");
INSERT INTO mwp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ngoey mi thonar ngin imadhin kikirilayg lawnga zeylanu a ngoey ngibiya gamuya memayin?” ");
INSERT INTO mwp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Kalanu Kuykulmay yangukudu kuniya kedha thanamulpa, “Ngitha mi thonara nanga kedha ngoedhal za ayman wara ngaw tukuypoepa, koey mabayg lawnga mabayg nuy mina apal, wa ngidh matha kedha senawbi kapu ibupudhay ngayapa ayman.” ");
INSERT INTO mwp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Kalanu ngay boedha dagam mabaygoepa buyal thayadhe a thanamulpa kedha muledhe, “Ngitha ngawngu adhapa ladhu, ngitha ngaya nanga Awgadhaw wati woenab gasamoene bangal! Ngitha kay adhapa thayamayzimayl woesimoeygi muypa, sena miza nanga buthapoethayzinga Sathanalpa a nungu wati angeloepa. ");
INSERT INTO mwp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngay mi thonara maythaygin mepa, ngitha ngayapa ay mayginga. Ngoena ngukin naypa, ngitha ngoena ngukin poeybayginga. ");
INSERT INTO mwp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngay mi thonara kasa azaz mabayg ngithamuniya igalgoegig, ngitha ngoena ayawal mayginga. Ngay mi thonara rugagig nanga ngitha ngoena rugan ubamayginga. Ngay wara thonara kikirilayg, wara thonara dhoerdhimayzig zeylanu a ngitha ngoena danal poethayginga.” ");
INSERT INTO mwp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Kalanu thana wati mabaygal ngayapa mulemine kedha, “Kuykulnga, ngoey kulay nginu paru imayginga, ngoey mi thonara ngin imadhin aygig, ngukigig, igalgoegig, rugagig, kikirilayg, lawnga zeylanu dhoerdhimayzig? Ngoey mi thonara nginungu lawnga memayin?” ");
INSERT INTO mwp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Senabi thonara bangal nanga Kuykulmay yangukudu thanamulpa kuniya kedha, “Lawnga, ngay mina yangukudu ya ngithamulpa umepa, mi thonara nanga ngitha lawnga memayin wara ngaw tukuypangu, koey mabayg lawnga mabayg nuy mina apal, ngitha kedha mabaygoepa ibupudhay aymayginga, wa ngitha matha kedha ngawngu lawnga memayin.” ");
INSERT INTO mwp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‘Wa, kedha wati mabaygal bangal ngaru wati kuth gasamoene, ngaru ngaru wati danal poethay; kasa kay kedha setha ngaya nanga mina mabaygal nanga thana mina igililmaypa, ngaru ngaru igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nanga nungu ngurpay mura muwasidhin, nuy kedha nungu niyaykazipa, ");
INSERT INTO mwp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘Ngitha mura ngulaygal kedha ukasar goeygi kaliya bangal Kaludhay Ay Aymay goeyga gasamane, a ngoena bangal senaw Mabaygaw Kazi senawbi goeyginu guda arane sathawro puydhaypa.’ (Kaludhay Ay Aymay thonara thanamun koey thonar thana ngoenanu manin senabi adhapudhay thonar thanamun mabaygal nanga gudaz pudhamoeydhin Aykupithunu, a matha thanamun Aykupithu kuykuy kazil mathamoeydhin.) ");
INSERT INTO mwp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Senawbi thonara thanamun koey misnarel a matha kedha yoewthaw koey mabaygal garwoeydhamoeydhin Kayapasan lagoenu. Nuy Kayapas thanamun kuyku misnare; nungu kapu koey lag. ");
INSERT INTO mwp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sey muynu thana gud garwaydhamoeydhin imaypa kedha, thana kay midh paru Yesun gumi gasampa a kay nuyn uma mathampa. Thana kedha umadhin, ‘Ngalpalpa nubepa ay aymay thonara gasamoeypa lawnga, kedha zoengu mabayg mina koey garsar, thanamulngu gegeyadh gasamoeyle a silamoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Thana kedha, ‘Ngalpalpa matha ngoedhagidh lawnga Yesulpa gasamaypa lawnga nabi ay aymay dhadhal kedha zoenguz kedha nuy mabaygoepa koey ubilnga, thanamulngu silamoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wagel mura thabi zapul, Yesu nuy muynu moegina goegathanu nel Bethoeni, nungu igalgaw Simonan laganu, nuy nga nanga kulay wati goengaw kikirilayg. ");
INSERT INTO mwp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu nanga nungu igalgaw laganu ngoenakap thayar na wara yoepkaz ngapa muy araydhin senabi lagiya, nabiya mer kapu ganul wakasu buyu. Nabi wakasu mina koey modhabilnga. Nadh kalanu senabi wakasu Yesun pada kuykunu suladhin. ");
INSERT INTO mwp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Thana nungu niyay kazin imadhin nan nadh nanga senabi wakasu Yesun pada kuykunu mura kupal madhin, thana gegeyadh gasamadhin nabepa. Thana kedha kidhakidhan umamoeyr, ‘Sena mingu kasa sagul palanu? ");
INSERT INTO mwp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nadh senabi wakasu nay mina koey bokadhzapa yoewdhan, kalanu nadh senabi bokadhza aygi zagi mabaygoepa poeyban.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesulpa kakal thana midh nanga umamoeyr, nuy kedha thanamulpa, ‘Nan wanaw, ngitha nabepa mingu wati ngoenakap gasaman, ina nadh ngayapa mina adhapudhay thoeyaygi zageth aymoenu. ");
INSERT INTO mwp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Setha nanga aygi zagi mabaygal thana bangal ngithamuniya kalmel mura thonar ngithamulpa danal poethaypa thana. Ngay nanga ngayapa ngithamuniya ngaru maypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ina nanga nadh ngaybiya pada kuykunu nabi wakasu sulan, nadh buth pathan ngaw gamu moerama thoeyaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mina ngay ngithamulpa kedha, igilaw yangu wakay nanga ngalagiya yadu poelgaypu nubi po gubaw gizunu, a matha kedha in nanu zageth nadh ayman lak bangal kedha yadu poelgaypu mura mabaygoepa, ingaru za nanu doegamuya.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesun toewaylop niyay kazingu, urapun nungu nel Yudha Keriyothoelayg uzaraydhin sethabi koey misnarepa. ");
INSERT INTO mwp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nuy kedha thanamulpa, ‘Ngath bangal nanga ngitha Yesulpa gasamaypa balbay tidedhe, ngitha bangal ngayapa miza modhabiya manine?’ Thana muladhin 30 silba bokadhzapul nubepa maypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Soeyzi pawpa nuydh kalanu Yudha dhadhabuthapa nagaydhin Yesulpa thanamulpa poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Koeykoeyne goeyga nanga gasamadhin thanamun senabi yistagi bredaw aygudaw goeyga thana Yesun niyay kazil nubepa yapu poeybemidhin kedha, ‘Kuykulnga, nginu ubi midh, ngoey kay ngalaga ngibepa Kaludhay Aypa aygudoepa zapul balbay tidaypa?’ ");
INSERT INTO mwp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nuydh mabayg seysithamadhin thanamulpa kedha, ‘Ngitha ladhu nubepa nungu lag sey muynu koey goegathanu. Kedha kay nubepa, “Ngurpay Mabayg lak ngibiya yoewdhiz kedha, ‘In ngaw thonar gasaman, ngaw ubilnga kedha ngay a mura ngaw niyay kazil kay nginu laganu ngoeymun Kaludhay Aygudoepa gasampa.’” ’ ");
INSERT INTO mwp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nungu niyay kazin mura nungu ubilmayl aymoeydhin, mura aydel zapul balbay tidamoeydhin Kaludhay Aypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mina kutapa Yesu a nungu toewaylop niyay kazil ngabunadhin senabi lagoenu, a kalanu kalmel nithamadhin aygudoepa. ");
INSERT INTO mwp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ayguda dhadhal nuy kedha thanamulpa, ‘Ina bangal kuyku nidhane, ngithamulngu urapu mabaygan bangal ngoena guda arane mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Thana nanga niyay kazin karngemidhin thana mina gegeyadh gasamadhin, aka a koerkak badh kalmel; thana yaynanob nubepa yapu poebemir kedha, ‘Kuykulnga ngidh ngan, ngoena maypa? Ngayapa koey zageth.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kuniya thanamulpa kedha, ‘Ngitha mura ngaybiya nithaman kalmel a ngalpa kalmel mura bredal thardhamayn urapu aygudaw zapunu, kasa kay ngaru urapun ngithamulngu bangal ngoena guda arane. ");
INSERT INTO mwp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","‘Ngay nanga ngay Mabaygaw Kazi ngay ngaru bangal um medhedhe kuyku nidhaypa Awgadhaw yawadhayzinga Minar Poelayzinga muynu Maygi Thusinu. Kasa kay kedha ina mina koey gegeyadh senawbi mabaygoepa ngadh bangal nanga senaw Mabaygaw Kazi guda arane! Nubepa matha ngoedhagidh kedha nuyn kasa nay kazi mayginga nubi apa goewanu.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudha guda arayzi mabayg, yapu poeybiz kedha, ‘Ngurpay Mabayg, ngidh lawnga ngoena maypa.’ Yesu kedha mulaydhin, ‘Senaw ngi balbayginga muliz.’ Kalanu nuy Yudha uzaraydhin thanamulngu sizi. ");
INSERT INTO mwp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Thana ay matha purthar, Yesu nuydh madhin nan yistagi bred yoewdhadhin eso Awgadhoepa, kalanu nuydh nan dhadhiya patidhadhin thanamulpa nungu niyay kazipa. Nuy kedha thanamulpa, ‘Marew a purthaw ina ngaw gamu.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kalanu nuydh lak kedha umal ngukiw kap gima gasamadhin, yoewdhadhin eso Awgadhoepa, a kalanu thanamulpa madhin nuyn kap. Nuy thanamulpa kedha mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","‘Wanimaw ngitha mura, ina ngaw kulka ngath ngithamulpa poeyban. Ina mina kuyku nidhan Awgadhaw yatharayzinga, ngaw kulka pay yoewdhayzinga koey goersar mabaygoepa gud woeyaypa ngithamun wati pawangu. ");
INSERT INTO mwp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngay ngithamulpa kedha, ngayapa lak nabi umal ngukipa woenipa lawnga ngithamuniya kalmel, kurusipa senabi thonar ngay bangal wanedhe kayin umal ngukin ngithamuniya kalmel sey Ngaw Thathiw Basalayanu muynu.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sew kalanu thana maygi na puydhadhin, ladhudhin Olibaw Padoepa. ");
INSERT INTO mwp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sey padanu nuy thanamulpa kedha, ‘Nubi kubilu kay ngitha mura bup aremipa ngawngu, ngoena kay ngaw kusayg woenaypa. Na Minar Poelayzinga kedha, “Awgadhan bangal mamuy danal pathay mabayg uma mathamoene a setha nanga mura nungu mamuyl thana bangal wadhwadhgoepa zilmemine.” ");
INSERT INTO mwp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kasa kay kedha, ngay nanga kaday tharedhe manine, ngaw igililnga kuniya, ngay bangal Galilayapa ngithamuniya kulay.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kalanu Petheru kedha Yesulpa, ‘Ngayapa ngibepa kasa woenaypa lawnga. Kasa kay midh, thana mura nginungu gamungu nanithoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kedha Petherulpa, ‘Lawnga, ngay ngibepa kedha, kaybaw kubilu wagel kay garkaz pawl poeybedhe, ngi kay kulay thoeri thonaralnga ngawngu koerawayg kudun tharepa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petheru kedha, ‘Ngayapa kedha zapa aymoeypa mina lawnga, kasa kay midh ngay kay ngaru umanga ngibeya kalmel.’ Kalanu thana mura niyay kazil lak kedha mulemidhin nubepa. ");
INSERT INTO mwp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kalanu Yesu a nungu niyay kazil nubeya kalmel ladhudhin sizi wara lagoepa apaw lag nel Gethsemoene, sey nanga ngabunadhin Yesu kedha thanamulpa, ‘Ngitha kow apa pudhay ngaw ugayl ngay mamu kedha uzaripa thoeythupagaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nuydh nubeya kalmel yoelpamoeydhin thanamulngu Petheru a Zebadin kazi ukasar. Senabi thonara nuy kasa mura goegadh asidhin kuyk nungu koerkak badh koeyza. ");
INSERT INTO mwp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nuy kedha thanamulpa, nungu thoeri niyay kazipa, ‘Ina ngaw ngoenakap kikir mina koeyza, ngoena mina koeyma nudhepa. Ngitha kow nithamaw a danal pathay aymoeziw.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nuy kalanu thanamulngu moegina sigapa uzariz kulun pasoeyniz kuykul kalmel, nungu paru nuydh mulupa boeradharapa thayan, kalanu thoeythupagiz kedha, ‘Ngaw Thathi ina nanga seyke ngibepa matha ngoedhagidh adhapa mar ina nabi adhapudhay kikiriw mapu ngawngu, kasa kay kedha ina nginu ubilnga kuyku nidhaypa ngaw ubilnga lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nuy kalanu kuniya nungu thoeri niyay kazipa imaypa, thana uthuy; nuy kedha Petherulpa, ‘Ngitha mingu uthuy poeydhanu? Ngithamulpa gegeyadh kedha ngaybiya kalmel nabi thawpay thonarpa danal poethay ayman? ");
INSERT INTO mwp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Matha ngoedhagidh kedha ngitha danal poethay aymoeziw a yoewdhemiziw ngithamulpa magaw poelaypa, wagel kay sethabi nuthayl zoepun ngitha karum paledhe. Ngithamun mariw ubil danal poethaypa ngaybiya kalmel aymoeypa kasa kay ngithamun gamul goegadhimayl.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kalanu lak kuniya tidiz a thoeythupagiz kedha, ‘Ngaw Thathi, ina kay nanga ngawngu nabi adhapudhay theral ngukiw kap adhapa mayginga, a kurusipa kay ngay wanepa, kuykunidhaypa kay nginu ubilnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sew kalanu nuy lak ngapa kuniya nungu niyay kazipa; nuydh imiz thanamun uthuy, kuyk thanamun gamul koey goegadhimayl, a thanamulpa ngoedhe koey zageth danalayg nagaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nuydh thabi thonara thana kasa waniz uthuypa, nuy lak kuniya uzaraydhin thoeythupagaypa. Ina nungu thoeri thonar thoeythupagaypa, a mura nabi thonara nungu thoeythupagay yangukudul matha thana. ");
INSERT INTO mwp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nabi thonara nanga nuy kuniya niyay kazipa, nuy kedha, ‘Ngitha mingu uthuy poeydhanu a? Ina thonar gasaman. Dan palemiw! Mabaygaw Kazi kay guda araypa thanamulpa wati pawaw mabaygapa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kadaypa memayiw ngalpa ladhuypa. Kedha nagemiw senawbi mabayg mangiz in, ngadh kay nanga ngoena guda araypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesun yanu dhadhal Yudha wara nungu niyay kazi mangiz. Nubiya kalmel koeygarsar mabaygal; thana koewbu rugalgal, kuyay thurikal a gabagabal. Thana yoewthaw kuykun a misnaren wayaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wagel kay mura thabi zapul, Yudha kulay mulaydhin koewbu mabaygoepa kedha, ‘Ngath kay nanga mi mabayg gud thapampa, ngitha kay nuyn gasamaw.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Thana nanga ngabunadhin Yudha balbayginga Yesulpa uzaraydhin, a nuy kedha, ‘Ngurpay Mabayg, kapu woenab ngibiya kalmel.’ Kalanu nuydh Yesun gud thapamadhin. ");
INSERT INTO mwp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kedha, ‘Kame! Ngi mipa in, kazayginga aymar ngi mipa nanga ngapa.’ Thana kalanu koewbu mabaygal ngapa a mina koey ridh gasamadhin Yesun. ");
INSERT INTO mwp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wara si pasiw mabayg Yesun nuydh nungu thurik adhapa pardhadhin a woeremadhin koey misnarew zagethaw mabaygiya, adhapa pathadhin nungu kawra. ");
INSERT INTO mwp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kedha mulaydhin, ‘Kuniya wanar senaw nginu kuyay thurik. Mabaygan ngaya nanga thurik gethan gasampa, thana thanamun um gasampa kuyk senaw thurik. ");
INSERT INTO mwp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngi kay matha koerawayg kedha, ngayapa koey zageth lawnga ngay kay nanga Ngaw Thathipa ibupuydhaypa yoewdhepa, nuydh kay mina sobaginga ngalpalpa koeygarsar koewbu angelal wayamoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","‘Kasa kay kedha ngath kay nanga kedha aympa midh kay paru Moeygi Thusiw ya Minar Poelayzinga kuykunidhaypa kedha, ina mi ngoedha thoeyay nanga aymiz?’ ");
INSERT INTO mwp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kalanu nuy Yesu mangayzi mabaygoepa muliz kedha, ‘Ngitha mipa ngapa, kuyay thurikalgal a gabagabalgal ngayapa gasamaypa? Ngay koerngaygi mabayg sabingu adhiya ulaypa lawnga. Ngay mura goeyginu senaw koey yoewthanu, ngath ngurpay aymarngu ngithamulpa amadhan, kasa kay kedha ngitha nuthayginga ngayapa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Itha mura thabi zapul aymaypa kuykunidhaypa Peropethaw Minar Poelayzimayl.’ Kalanu nungu niyay kazil mura wadhwadhgoepa nanithadhin nungungu. ");
INSERT INTO mwp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Thana Yesun gasamayzi mabaygan nuyn madhin Kayapasan lagapa, sena ngalaga nanga yoewthaw a ngurpay koey mabaygan garwoeydhamoeydhin. Kayapas nuy kuyku misnare. ");
INSERT INTO mwp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petheru koey sigal wagel woelmay, kurusipa nuy mangaydhin muynu a thanuraydhin kalmel thanamun poepiyamaw mabaygiya, imaypa kedha thana kay miza aympa Yesulpa. ");
INSERT INTO mwp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nuy kuyku misnari a nubeya kalmel nungu Yoewdhayalgaw koey mabaygal kawnselal. Thanamun ubi Yesulpa mathamoeypa. Thana wati mabayg luman Yesulpa mulamoeypa kedha nuydh za gegeyadh ayman, kasa kay kedha thana wara gegeyadh imayginga nubeya. Nubepa kuthoepa thoeraypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kasa kay kedha thana wara gegeyadh imayginga nubeya, a kobegadh mamu koeygarsar mabaygal ngapa paypa memayir, ngaru thanamun yaday kuykunidhayginga. Kurusipa ukasar mabayg ngapa paypa memaman. ");
INSERT INTO mwp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Palay kedha, ‘Ngalbe nubi mabaygaw ya karngemidhin kedha, “Ngath ngulayg idiman Awgadhaw koey yoewth a lak moeydhan thoeri goeygoeglnga.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nuy kuyku misnare kaday tariz, Yesun yapu poeyban kedha, ‘Ngi wara yangukudulayg sakar maypa a? Sena mura wati za ngibiya woeydhoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kasa kay kedha Yesu kuniya ya mulayginga. Nuy kuyku misnare lak muliz Yesulpa kedha, ‘Mina koew Awgadhaw parunu ngi ngoeymulpa ridha ya muli. Ngi mina Keriso, Awgadhaw Kazi a?’ ");
INSERT INTO mwp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kuniya nubepa kedha muliz, ‘Senaw ngi balbayginga muliz. Kasa kay kedha ngay ngithamulpa kedha, nabi thonarngu pawpa ngitha bangal mina yapa thamane a imane Mabaygaw Kazi Kuykulmay getha dagamoenu thanuridhe a ngay lak ngapa kuniya daparaw ziyanu gimiya.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nuydh kuyku misnaren nungu dhoemawak pakadamoedhin thabukirin, a wal mizin kedha, ‘Wara lak yaginga koezi powpa, ina nungu mina kawrag, nungu kasa ubi Awgadhaw kupaypa gasamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngithamun wakay thamamay midh?’ Thana kedha, ‘Nuy wati mabayg, nuyn kay ngaru uma mathamoene.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Thana kalanu nungu parupa mosal adhamoeyr a gethan mathamar nuyn; ");
INSERT INTO mwp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","senaw ngaya nanga nuyn mathamar yapu poebemir kedha, ‘Muli ngoeymulpa ngi nanga sike mina Awgadhaw Kazi, in ngin ngadh mathampa.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petheru nuy nir si adhal, urapun yoepkaz kuyku misnarew zagethaw mabayg ngapa nubepa kedha muliz, ‘Kame! Ngi lak kedha Yesun gamu puziw mabayg senawbi Galilayaw mabaygaw.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petheru nuy mura thanamun parunu gud thadhaydhin kedha, ‘Ngath nginu ya tidayginga, ngay senawbi mabaygangu mina koey koerawayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kalanu nuy sizi thanamulngu moegina adhapa uzariz pasagudhapa. Si wara zagethaw yoepkazin nuyn ngurpan, na kedha thanamulpa, ‘Senawbi mabayg nuy Yesun gamu puziw mabayg, senaw nga nanga Nazarethoengu.’ (Nazareth wara moegina goegath Galilayoenu.) ");
INSERT INTO mwp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petheru nuy lak gud thadhaydhin kedha, ‘Ngay mina koey balbayginga ya muliz kedha, ngay senawbi mabaygoengu koerawayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Moegina buth setha ngaya nanga sike sir ngapa Petherulpa thana kedha, ‘Ngoey ngulaygal ngi mina thanamun mabayg, kuyk ngi nungu urapu yangukudu mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petheru mina kay koey dharadh nubi thonara gud thadiz, nuy kedha, ‘Ngay sike nanga sole yadu umepa, wa Awgadhan bangal ngabiya modhab thayane. Ngay senawbi mabaygangu koerawayg.’ Senawbi thonara kay pawl poeybiz, ");
INSERT INTO mwp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","nuydh Petheru ngoenanu madhin Yesu midh nanga mulaydhin nubepa, ‘Wagel bangal pawl poeybedhe ngi kulay thoeri thonaralnga muledhe kedha, ngi ngawngu koerawayg.’ Nuy kalanu adhapadhadhin mayl mayl. ");
INSERT INTO mwp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mina bathaynga nanga thanamun kuyku misnarel a koey mabaygal lak garwoeydhamoedhin thanamun wati buwayl thoeyaypa aymoeypa, Yesulpa umamathamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Thana Yesun kunumoedhin, kalanu Pilatholpa angadhin. Nuy Pilatho Romaniw kuyku mabayg thanamuniya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudha nanga imadhin kedha, thana Yesun umamathamaypa madhin, nungu koerkak badh mina koeyza nuydh Yesun guda aradhin thanamulpa. Nuydh geth woeydhadhin, a sethabi thoerti silba bokadhzapul nuydh kuniya agaydhin thanamulpa kuyku misnarepa a wara koey mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nuy kedha, ‘Ngath gegeyadh aymoengu; senawbi mabayg ngath ngithamulpa madhin, nuydh za gegeyadh aymayginga.’ Thana kedha, ‘Sena nginu mapu, ngoeymun mapu lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudha nuydh sethabi silba bokadhzapul kasa thoeyamoeydhin koey yoewthoepa muypa, kalanu adhapadhadhin, nungu geth puynu gimal woeth yatharaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Thana kuyku misnarel garwoeydhamoeydhin sethabi thoerti silba bokadhzapul; thana kidhakidhan kedha, ‘Ngalpan sabinu nubi bokadhzapul matha ngoedhagidh lawnga yoewthaw bokadhzapa, kuyk ina mabaygaw kulkapa modhabiya manin.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","Kalanu thana moegina boeradhar barpudhaydhin sethabi bokadhzapun, a nan boeradhar kalanu azaz mabaygaw moerama thoeyay lag aymoeydhin. Senabi boeradhar na kulay besiniw zagethaw mabaygaw lag; kalanu nan kedha tharadhin, kulkaw boeradhar. ");
INSERT INTO mwp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ina kay paypa kulay peropethaw Erimayan ya kuykunidhan kedha, ‘Thana madhin thoerti silba bokadhzapul, sena Isoereylaw buway mabaygaw modhab nubepa madhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kalanu nan bokadhza boeradharoepa yoewdhaypa. Thana besiniw zagethaw mabaygaw boeradhar barpudhadhin, Awgadhaw yangukudu midh nanga ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Thana Yesun madhin Romaniw kuyku mabaygaw lagapa. Nuydh kuyku mabaygan nuyn thuradhin yapu poeybadhin kedha, ‘Ngi mina Yoewdhayalgaw Kuykulnga a?’ Yesu kuniya kedha mulaydhin, ‘Wa, nginu yangukudu moegina balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Thana mura kuyku misnarel a koey mabaygal kasa mulamoeyr Yesun Romaniw kuyku mabaygoepa, kasa kay kedha nuy Yesu kasa yagig. ");
INSERT INTO mwp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatho kedha nubepa, ‘Ngi midh paru kuniya ya mulayginga koepa thanamulpa?’ ");
INSERT INTO mwp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kasa kedha Yesu ngaru kuniya ya mulayginga. Nuy Romaniw kuyku mabayg dan katamaydhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wara thanamun pawa kedha, mura wathanu nanga mura Kaludhay Ayngu thonara nanga, nuy Romaniw Kuyku Mabaygan ngulayg urapun kunumayzi mabayg gudwayan. Mura mabaygal garwoeydhamaydhin; thanamun ubi kunumayzi mabayg thuraypa Romaniw kuyku mabaygoepa gud woeyaypa. ");
INSERT INTO mwp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Senawbi wathanu wara mabayg nel Yesu Barabas sey kunumay lagoenu a mura mabaygal nungungu ngulaygal. ");
INSERT INTO mwp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Koeygarsar mabaygal garwoeydhamaydhin nanga, nuy Pilatho yapupoeybiz kedha, thanamulpa, ‘Ngithamun mi mabaygoepa ubi ngath ngithamulpa kay gud woeyaypa, Yesun nuyn kedha tharan Keriso, lawnga nuy wara Yesu, Yesu Barabas.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nuy Pilatho ngulayg kedha, thana yoewthaw koey mabaygan kasa uwanu memayidhin, thana kedha zoenguz Yesun kotapa madhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatho nanga kotanu nir, nungu ipiw yangukudu mangiz. Nanu yangukudu kedha, ‘Ngi koey poeypiyam senabi mabaygoengu, nuydh za aymayginga, ngoena pikin thayan bongel, koey akalnga, ngidh nuyn mathamayg; nuydh wara za gegeyadh aymayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Thana kuyku misnarel a koey mabaygal ya umamoeyr thanamun wagel parul kedha, ‘Kapu za kedha, ngitha Barabasoelpa mulemiw gud woeyaypa a Yesun kay mathamaypa mariw.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatho mura mabaygoepa yapu poeybiz kedha, ‘Ngithamun ubi midh, ngath kay mabayg ngithamulpa gud woeyaypa palbi mabaygoengu?’ Thana mura kidhakidhan kedha, ‘Barabas.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nuy Pilatho thanamulpa kedha muliz kuniya, ‘Ngath kay miza ayimpa Yesulpa, nuy kedha tharan, Keriso?’ Thana mura kuniya kedha mulemin, ‘Nuyn sathawrawo puydhaw.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatho thanamulpa kedha muliz, ‘Nungu gegeyadh midh, ngath kay mingu nuyn sathawrawo puydhaypa?’ Thana koezi lak gima gudiya wal memayir kedha, ‘Nuyn sathawrawo puydhaw.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatho nuydh iman kedha, thana nubepa kurusipagayginga, nuy moegina akan mer koey silamayngu kuykaymayle. Nuydh nguki gasaman, nungu geth garwalagiz thanamuniya parunu. Nuy kedha mulaydhin thanamulpa, ‘Nag, in matha ngithamuniya mepa, ngay lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Thana mura kuniya mulemin kedha, ‘Wa, ngoeymulpa matha ngoedhagidh nuyn mathaman, nuy nanga sike mina mabayg, ngoey a ngoeymun kazin bangal wati za gasamoene Awgadhoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kalanu Pilatho thanamulpa gudwayan Barabasan, kasa kay kedha nuydh Yesun nungu koewbu mabaygoepa gud aradhin poelngipa, nuyn sathawrawo puydhaypa madhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Palngi kalanu thana koewbu mabaygan nuyn yoelpan thanamun niyaylagoepa, koey rumoepa. Thana mura garwoeydhamoeyr, nubepa giwn soelmaypa. ");
INSERT INTO mwp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Thana nuyn rugan thudhan a kulka gamul koey sodh wanan nubiya. Thanamun pawa kedha sethabi goeyginu, adhapudhay kuykulnga ngulayg kulka gamul koey rugan ubamiz. ");
INSERT INTO mwp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Thana nubepa patal puyngu ngoelkay korone aymoedhin a nungu kuykunu wanadhin gimal. Nubepa puy madhin getha doegam gethoepa, kasa ngoelkay, kuykulmay mabayg midh nanga. Thana apapudhemir nubiya parunu, giwn soelmar a kedha umamoeyr nubepa, ‘Nginu igililnga ngaru koey kuykuthalnga, ngi koey woenabalnga, ngi Yoewdhayalgaw Kuykulnga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Thana nuyn mosen tidar, a nungu boegi madhin, nubiya kuykunu wariman. ");
INSERT INTO mwp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Thanamun nanga giwn soelmay muwasin, thana kalanu kulka gamul rugal thudhan, nungu rugal kuniya ubaman. Kalanu thana adhapa yoelpadhin nuyn, sathawrawpa puydhaypa nuyn. ");
INSERT INTO mwp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yabugudoenu dhadhal thana Sayrinaw mabayg iman, nungu nel Simona. Thana nuyn gasamadhin, Yesulpa ibupuydhaypa sathawrawpa maypa. ");
INSERT INTO mwp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Thana ngabunadhin lag nel Golgotha, ngalpadh kedha, Kuyku Ridhaw Lag. ");
INSERT INTO mwp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Thana nubepa madhin, umal nguki a gal kidhthoeyayzinga. Senabi gal mabaygaw gamu uthuy yoewnay za. Nuydh kasa mith pathan senabi za, nuydh woeniginga. ");
INSERT INTO mwp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Thana nuyn sathawrawnu puydhadhin, nungu rugal thana thanamulpa mamayidhin, days thayar dhadhiya dhadh mamayir nungu rugal thanamuniya. ");
INSERT INTO mwp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kalanu thana kasa nuyn milal nagemir. ");
INSERT INTO mwp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Thana yangukudu paladhin, nubiya gimal puydhadhin, ‘In Yesu, Yoewdhayalgaw Kuykulnga.’ Sena mi yangukudu nanga thana yoewthaw koey mabaygal nuyn mulamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wara ukasar mabayg, palay lak sathawrawnu puydhamoedhin wadhwadhgam Yesuniya. Palbi thabukiri mabayg, matha kedha puru mabayg midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mabaygal ngaya sike pasiya tadir, thana kasa kuyk woerimoeyr, kedha umamoeyr. ");
INSERT INTO mwp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‘Ngidh ngulayg idiman Awgadhaw yoewth a lak moeydhan thoeri goeygi kaliya a? Ngi Awgadhaw Kazi, koey poeraparal mabayg a? Midh paru ngi nginungu balbay tidayginga a? Mingu ngi mulupa poegayginga soeyzi sathawrawngu?’ ");
INSERT INTO mwp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Thana kuyku misnarel a yoewthaw sabiw ngurpay mabaygal lak kedha nuyn giwn soelmar. ");
INSERT INTO mwp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘Nuydh wara mabaygal balbayg palimoeyn, kasa kay kedha nuy nungu geth ibupuydhayginga. Nuy kedha mulaydhin, nuy Yoewdhayalgaw Kuykulnga, nuy kay nanga nungu geth mulupa poegaypa, wa ngoey nubepa mina yoepathaman. ");
INSERT INTO mwp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nuy kedha, nuy Awgadhaw Kapu Akasizi Kazi, ngalpa kay imaypa, Awgadhan kay midh nuyn ibupuydhaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sepal sathawrawnu wadhwadhgam poeydhayzi mabaygan lak kedha nuyn giwn soelmar. ");
INSERT INTO mwp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dhadha goeyga nanga aymiz, koey inur pudhaydhin matha kedha kubil midh nanga mura doegamuya. ");
INSERT INTO mwp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Thoeri awalnga inur pudhaydhin; kalanu Yesu koey gimiya wal miyaydhin kedha, ‘Eli, Eli lema sabakthani?’ Muynu kedha, ‘Ngaw Awgadh, ngaw Awgadh, ngidh mingu ngoena kasa wananu?’ ");
INSERT INTO mwp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dhuray mabaygal si pasinu sir, thana karngemin. Thana kedha, ‘Nuy peropeth Elayzapa wal mepa sike.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Urapun mabaygan thanamulngu sobaginga zilamiz sathawrawpa, spanz gasaman, kalanu sisaberal umal ngukinu thardhan; kalanu puy kopin pagan, Yesulpa yudhan nubepa woenipa. ");
INSERT INTO mwp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kasa kedha dhuray wara mabaygal kedha, ‘Thuma, mamu imaypa peropeth Elayza lawnga soeyzi ngapa.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Senawbi thonara Yesu lak koey gimiya wal miyaydhin, nungu moeygapa guban. ");
INSERT INTO mwp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Balbayginga senawbi thonara, koey yoewthanu thanamun wolaw koey dhoemawaku nanu geth pakadamoeydhin gimanoekaz mulupa. Boeradhar koeyma garguy miyaydhin, kulal papoelamoeydhin; ");
INSERT INTO mwp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","koeygarsar kulba uma mabaygaw surumal gud pudhemidhin. Dhuray Awgadhaw mabaygal, setha ngaya nanga kulba umamayl, lak kaday nithamoedhin moeramoengu. ");
INSERT INTO mwp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kalanu bangal, Yesun kaday thoeray kalanu, setha kaday thoerayzi mabaygal bangal Yoerusalemiya muy aremine, Awgadhaw maygi goegathiya. Koeyma mabaygan thana imedhe. ");
INSERT INTO mwp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nuy koewbu kuyku mabayg a setha ngaya nanga nubiya kalmel, thana nanga imadhin kedha boeradhar koeyma garguy miyaydhin, a mura setha zapul nanga aymoeydhin Yesu midh thonara um miyaydhin, thanamun aka mina koeyza. Thana umamoeyr kedha, ‘Wa nuy mina Awgadhaw Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dhuray yoepkazil thana Galilayoengu ngapa Yesuniya asimoeydhin, thana lak kedha nungu mabaygal. Sathawrawpa thana moegina sigaz nagemir. Thana ibupuydhaypu nuyn. ");
INSERT INTO mwp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dhuray thanamuniya nelay kedha, wara goegathaw mabayg nel Mariya Magdaloengu, wara Mariya, Zemesan apu, a wara Zemesan a Yoewsepan apu. Thana mura Yesun yawayar. ");
INSERT INTO mwp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pawpa kutapa nanga, wara koey mabayg mangiz, Aramathiyalayg nungu nel Yoewsepa; nuy koey bokadhzapul mabayg. Nuy lak kedha Yesulpa kurusipagepa. ");
INSERT INTO mwp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nuy Yoewsepa Romaniw kuyku mabaygoepa, Pilatholpa yapupoeybiz kedha, ‘Ngidh gar ngayapa Yesun gamu mulupa maypa?’ Pilatho nungu koewbu mabaygoepa muliz kedha, ‘Yesun gamu nubepa mariw.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kalanu Yoewsepa nungu Yesun gamu kayn pepe dhoemawakun nuran. ");
INSERT INTO mwp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nungu Yoewsepan geth moeram meparu amadhan, kulanu anarayzinga. Nuydh Yoewsepa, Yesun gamu sin muynu aradhin wagel koey kula adhaz koezi wanadhin gud mathamoedhin, kalanu nuy uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sepalbi yoepkaz, Mariya Magdaloengu a wara Mariya, palay si adhal memamar. ");
INSERT INTO mwp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Senawbi za aymaydhin prayde; wara goeyga nanga thana yoewthaw koey mabaygal Romaniw kuyku mabaygiya mangemidhin kedha. ");
INSERT INTO mwp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","‘Kuyku Mabayg, ngoeymun ngoenanumaypa kedha, senawbi ngoelkay mabayg nga nanga sathawrawnu puydhangu, nuy kedha ngoelkay ya mulaydhin, “Ngay bangal umangu; thoeri goeygiw kaliya ngoena bangal lak kaday tharane umangu.” ");
INSERT INTO mwp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngidh gar nginu koewbu mabaygal woeyamoeyr, thoeri goeygipa nungu moerampa, mina danal poethaypa; na thanamulpa, nungu niyay kazingu nungungu purunu woerdhayle. Thana niyay kazingu mabaygoengu karum poelayle, “Nungu gamu guythuyan, nuy ngaru kaday thariz.” Senabi ngoelkay nay adhapudhay nungu kulay ngoelkay midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nuy Romaniw kuyku mabayg kuniya kedha mulaydhin thanamulpa, ‘Wa, koewbu mabaygal mamayiw, nungu moerampa mina danal poethaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kalanu thana ladhudhin, moeramaw gud mathamay kula pagasamadhin a thanamun geth za poelayzinga aymoedhin, kula ngalaga nanga pagasamadhin, wara mabaygoengu kulangu adhapa maythayle. Kalanu sethabi koewbu mabaygal wanamoeydhin danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Thanamun sabathoenu kalanu, Mariya Magdaloengu a wara na Mariya, palay moerampa uzarmoedhin mina bathaynga. ");
INSERT INTO mwp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Palay nanga amadhan aymoeman, kedha nanga boeradhar garguy mizin, Awgadhaw angela mulupa pagan daparngu, kula adhapa thaman, sin gimal thanuriz. ");
INSERT INTO mwp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nuy poenipoenidh koey buyalnga a nungu rugal adhapudhay koey goerab gamulmayl. ");
INSERT INTO mwp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","5","Thanamun koewbu mabaygaw aka mina koeyza, gamul koeyma galupamoeyn akan; kalanu thana ngoedhe uma gamul midh nanga. Nuy Angela yoepkazipa muliz kedha, ‘Koeyma wakay thoemamayg, ngay ngulayg kedha, ngipel Yesun lumaypa, ngan nanga sathawrawnu puydhayngu, kasa kay kedha nuy in lawnga. Nuyn kadaypa maninu umangu, nuy kulay midh nanga umepu. Ayawal imaw, nuyn ngalaga nanga wananu. ");
INSERT INTO mwp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","7","Ngipel kazaginga uzarmoeriw nungu niyaykazipa yadu thuraypa kedha, “Nuyn kaday tharayngu umangu nubi thonara, nuy Galilayapa bangal ngithamuniya kulay. Ngitha nanga Galilayoenu mangemine, ngitha bangal nuyn imane.” Nuy lak muliz kedha palamulpa, “Ngaw ya ngipelngu yakanurayg.” ’ ");
INSERT INTO mwp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Palay balbayginga moeramoengu kuniya tideman, palamun kedha aka a dhiw muynu. Palay kaday thareman nungu niyaykazipa yadu thuraypa. ");
INSERT INTO mwp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kedha nanga Yesu dhadha mangiz palamuniya, nuy kedha muliz, ‘Woenab ngipeniya kalmel.’ Palay nanga karngemin palay lak nungu siyara apapudheman a lak thawmanin nuyn. ");
INSERT INTO mwp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nuy kedha, ‘Ngipel akag, uzarmoeriw ngaw tukuypoepa mulemoeriw kedha, “Galilayapa bangal ladhune.” Thana bangal ngoena sin imane.’ ");
INSERT INTO mwp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Palay nanga sepalbi yoepkaz uzarmoedhin, dhuray koewbu mabaygal, moeram ngaya nanga danal poethar, kuniya ladhudhin, kuyku misnarel ngulayg palaydhin kedha, mura zapul midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kalanu thana kuyku misnarel a dhuray koey mabaygal garwoeydhamoeydhin a buwayl thayadhin kedha koewbu mabaygoepa, ‘Ngitha bangal mura mabaygoepa yadu palgane kedha, “Kubilu ngoey uthun idimar. Wa, senawbi thonara Yesun niyaykazin nungu gamu madhin.” Ngitha nanga kedha ya oengane, wa ngoey ngithamulpa kay bokadhzapun poeybane.’ ");
INSERT INTO mwp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","14","Thana lak koewbu mabaygoepa mulemidhin kedha, ‘Ngithamun kuyku mabayg nanga ngulayg asine ngithamun yangukudungu, ngoey bangal nuyn yadu palgane, nungungu gegeyadh gasamoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Thana danal poethayzi koewbu mabaygal kusumadhin sethabi bokadhzapul a mura mabaygoepa yadu palgamoeydhin setha mi yangukudul nanga thana Yoewdhayalgaw koey mabaygal thanamulpa mulemidhin. Kalanu senabi yangukudu kasa yadu palgadhin mura Yoewdhayalgiya. Soeyzi ngapa kurusipa kayib thanamun ngulayg kedha, Yesun niyaykazin nungu gamu purunu wardhadhin moeramoengu. ");
INSERT INTO mwp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kalanu leben niyaykazil ladhudhin Galilayapa, thanamulpa kulay seysithamadhin thanamulpa garwoeydhamaypa. ");
INSERT INTO mwp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Thana nanga nuyn imadhin dhuray thana koesar wakay thamamayil gasamoedhin. Thana koerawaygal kedha, in mina nuy lawnga midh; kasa kedha thana mura nuyn thawmadhin. ");
INSERT INTO mwp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nuy amadhan thamaydhin, thanamulpa kedha mulaydhin, ‘In ngayapa poeybangu, mura kupayl daparaw, a matha kedha nubi apaw goewaw. ");
INSERT INTO mwp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngitha bangal mura nubi apaw goewaw mabaygal ngurpamoeypu, ngithamun mab nanga mura wadhwadhgamuya a thana bangal ngaw niyaykazil aymoeypu. Ngitha bangal thanamuniya papthayso maypa a thana kalanu Awgadhaw buwaypa sakariya thayamoeyne. ");
INSERT INTO mwp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngitha kedha zageth oengaw; ngurpamoeypu bangal thana, ngaw ngurpan ngath ngitha midh zapun nanga ngurpamaydhin. Thana mura kedha ngurpay oengaypa. Ngitha bangal koeyma ngoenanu mayparuy kedha, ngay bangal ngithamuniya kalmel, kurusipa bangal nubi gugu ubidh thoeyayzimayngu kuth.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","In nubi Minar Poelayzinga kedha zapa. Yadu poelgay ya, mabaygoepa in nubi kapu ya Yesu Kerison, na midh paru kuyk aymaydhin, Awgadhaw Thurkuyay Kaziw ya. ");
INSERT INTO mwp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kay paypa kulay thonara Isaya Awgadhaw peropetha yadu palgadhin kedha, ‘Awgadhaw yangukudu kedha, “Ngath bangal ngaw yaday woeyay mabayg wayane, ngibiya kulay. Nuydh bangal nginu yabugud ngibepa kulay buth pathane. ");
INSERT INTO mwp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wara mabaygaw yangu wakay poegaypa muynu bupanu mabaygoegi dhadhabuthanu. Nuy kedha, ‘Buthpathaw balbay tidaw senabi ruwayl yabugud Kuykulmaypa mabapa.’” ’ ");
INSERT INTO mwp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Senabi thonara Yoewane yakamaydhin bupanu, nuydh mabaygal papthayso mamayipu, a nuy kedha maw tharepu kedha, ‘Adhapa ngithamun wati igililmay pawangu. Adhapa garthil thayemiw a ngapa papthayso moeypa ngithamun wati pawapa mura gud woeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kalanu thana Yoewdhayalgal Yoerusalemoengu a mura sethabi doegamu moegina goegathaw mabaygal Yoewanelpa ladhudhin koerngaypa. Thana wati wakasimoeyr a nuydh thana papatyso mamayidhin Yuridhaw Koesanu. ");
INSERT INTO mwp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nungu Yoewanen dhoemawak kamelaw gamu magadhoengu aymayzimayl, zagi mabaygaw rugal. Nungu dhadha gar gasamayza moegiridh goengaw, a nungu ay pukath a wam muynu bupanu. ");
INSERT INTO mwp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nuy Yoewane maw mer kedha, ‘Senaw bangal nanga nga boey ngaybiya wagel, nuy ngaybiya koey adhapudhay, koey gimal. Ngay matha ngoedhagidh lawnga nungu moegina zagethoepa aymaypa, matha kedha nungu azaz sanoepa adhapa gud idhuypa. ");
INSERT INTO mwp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngath nabi thonara ngitha matha ngukin papthayso mamayipa, nuydh bangal kay ngitha mina papthayso mamayipu, a nungu papatays mina wardh. Nuydh bangal Maygi Mari ngithamuniya woenaypu.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Senawbi thonara Yesu ngapa Galilayoengu, moegina goegath nel Nazareth, nuy Yuridhaw Koesapa miyaydhin, Yoewanelpa nubepa papthayso maypa. ");
INSERT INTO mwp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nuy nanga sizi woerngu kadaypa uzaraydhin, Yoewane imadhin kedha, dapar gud pudhaydhin a sizi ngapa mulupa Maygi Marin uruy gamu ngoedha madhin a nubiya gimal aymay. ");
INSERT INTO mwp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Senabi thonara yangu wakay pagar daparngu kedha, ‘Ina Ngaw Geth Mamal Kazi, nuy ngayapa mina matha ngoedhagidh.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Senawbi thonara Maygi Marin nuyn Yesun yoelpadhin bupapa, mabaygoegi dhadha sakarpa. ");
INSERT INTO mwp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nuy meparu bupanu poti goeygilnga. Senawbi thonara Sathanan nuyn nuthadhin. Nuy meparu thoeydhayl uruya dhadhal kasa kay kedha angelan kalmel nubiya muynu ibupuydhaypu. ");
INSERT INTO mwp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yoewane matha maw tharepu Awgadhaw ya yadu poelgaypu, kalanu thana nuyn kunumay lagoenu thayadhin. Senabi kaliya Yesu nuydh nungu zageth kuyk aymadhin, Awgadhaw kapu ya nuydh yadu palgadhin mura sethabi goegathiya, Galilaya. ");
INSERT INTO mwp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nuy kedha, ‘Mina thonar nanga gasamoene, Awgadhaw Basalaya amadhan gasamay. Adhapa buwayl thayemiw ngithamun wati pawangu a gathil thayemiw, ina Awgadhaw igilil yangukudu mina yoepathamaw.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nuy nanga wara thonara Galilayaw Malungu boewadhiya walmay, nuydh ukasar wapiw gasamay mabayg imamoedhin, Simona a nungu tukuyap Andhoeru, palay pingen wapil gasamar. ");
INSERT INTO mwp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kedha mulaydhin palamulpa, ‘Ayawal ngapa ngaybiya asimariw, ngipel bangal ngaw pingiw thoeyay mabayg kedha zagethoepa, ngipel bangal mabaygal garwoeydhamoeypu ngayapa.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wara yaginga palay kuniya wanadhin palamun zageth. Palay asimoemoedhin Yesuniya, nungu pasiw puziw mabayg aymoemoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Seyzi thanamun mab nuydh imoemoedhin wara ukasar kuyk kazi, Zemes a nungu tukuyap Yoewane. Palamun kalmel thathi Zebadi. Thana thanamun butanu balbay tidamar thanamun pingel. ");
INSERT INTO mwp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu palay sizi thuremoedhin. Palay lak kedha wara yaginga kuniya wanadhin Zebadi palamun thathi a zagethaw mabaygal si butanu. Palay asimoedhin Yesuniya a aymoemoedhin nungu pasiw puziw mabayg. ");
INSERT INTO mwp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kalanu Yesu a nungu mura niyay kazil thana mangemidhin koey goegath nel Kapeniyam. Wara nanga sabadh Yesu thanamun yoewthiya muy yoewthaydhin a nuydh ngurpay kuyk aymoedhin thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mabaygan nanga ngaya karngemidhin, thana mina koeyma madhu pamemidhin nungu ngurpay yangukudungu. Minguz kedha, nuy kasa nungu geth yangukuduya yadu umay, nuy ngoedhe mura gimal thanamun ngurpay mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Thana nanga si yoewthanu muynu memayir, thanamuniya mangaydhin muynu wati mariw malayzi mabayg. Nuy wal miyaydhin, kedha mulaydhin Yesulpa, ");
INSERT INTO mwp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","‘Ngi ngapa mipa, ngoeymulpa mura idimoeypa a? Ngi Yesu Nazarethoelayg. Ngay koey ngulayg kedha ngi nga nanga, ngi Awgadhaw maygi Seysithamayzi Mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu yangukudu guythuyadhin wati maripa kedha, ‘Yagi asir! Adhapa mer seyzi mabaygoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kalanu wati marin nuyn mabayg mina wati za kasa thayadhin, nuy nanga woelay woelay adhapa miyaydhin mabaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mabaygal mura madhu pamemidhin a kidhakidhan kedha umamoeyr, ‘Ina miyaw za? Ina miyaw kayn ngurpay kedha? In nubi mabayg mina koey bibiril kupay mabayg, nuy kasa ya muliz a wati marin nubepa karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na yadu palgadhin mina mura Galilayaw goegathiya. ");
INSERT INTO mwp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Thana thoeythu poegay koeliya, mina sobaginga ladhudhin Simonom, Andhoeruwom lagoepa. Zemesaw, Yoewanew wara kalmel asimoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Thana nanga mangemidhin palamun lagoenu mabaygal Yesulpa mulemidhin kedha, nungu Simonan yoepkaz ira sumay kikir muynu uthuy lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wa, Yesu muy uthaydhin nabepa imaypa. Nuydh nanu geth gasamoedhin a gamu tharadhin nan. Balbayginga senabi thonara na balbayg asidhin sumayngu. Na kaday tharaydhin nanu zagethaya asidhin, aymaydhin mura zagethal thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Senawbi kutoepa nanga goeyga pudhaynu mabaygal mura Yesulpa agaydhin thanamun kikiril mabaygal a dhuray wati mariw malayzi mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mura sethabi goegathaw mabaygal, thana mina mura si parunu ngapa pamar Yesu mi lagoenu nanga mer. ");
INSERT INTO mwp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu sethabi kikiril mabaygal yaynanob dhoey nidhamoeydhin a dhuray wati mari malayzi mabaygal lak kedha. A nuydh thana wati maril yangu mulayle panidhadhin. Minguz kedha, thana ngulaygal kedha, nuy mina nga nanga. ");
INSERT INTO mwp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wara bathaynga nanga mina inuriya Yesu dan palaydhin a uzaraydhin sizi lagoengu adhapa mabaygoegi dhadhar sakarpa, si nuy thoeythu poegay. ");
INSERT INTO mwp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Senawbi bathaynga nanga thana dan palemidhin Simona a nungu igalgal ladhudhin, Yesun lumadhin. ");
INSERT INTO mwp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Thana nanga nuyn imadhin, thana kedha mulemidhin, ‘Mura mabaygan ngin lumaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kasa kay kedha Yesu kedha mulaydhin thanamulpa, ‘Ngalpa kay ngaru wara goegathoepa memayipa itha muynu. Ngay kay ngaru lak kedha thanamulpa maw tharepa, ngay kedha zapa ngapa koepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kalanu nuy mura senabi Galilayaw goegathiya gulgupaydhin yoewthiya maw siparu, a wati maril adhapa mamayipu mabaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wara thonara nanga wati goengaw kikiril mabayg Yesuniya mangaydhin a parunu nubiya kulun pasaynoeydhin. Nuy yoewdhaydhin Yesuniya kedha, ‘Ngay gar koeyma apapudhiz ngibiya. Ngibepa zagethoeginga kedha ngidh ngoena balbayg tidaypa. Ngidh gar ngoena ibupuydhaw.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu nanga nuyn imadhin, nungu mina koeyma koerkak badh miyaydhin. Nuydh nungu geth luwayadhin a mulaydhin nubepa kedha, ‘Wa ngaw mina ubi kedha, ngath kay ngin balbayg poelaypa. Ngi balbayg asir kedha thonar, nginu kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Balbayginga, mina sobaginga wati kikir adhapa miyaydhin senawbi mabaygoengu. Nuy kalanu mina goengawlnga aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kalanu nuy senawbi mabaygoepa koey dharadh mulaydhin, a adhapa wayadhin nuyn kedha, ");
INSERT INTO mwp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","‘Ngi ngayapa kurusipagi, nginu bangal poeypiyam. Wara mabaygoepa mulayg kedha ngath ngin balbayg tidanu. Balbayginga kedha, ngi uzar ngithamun misnarepa, nubepa ngibepa imaypa, a mina yoepathamaypa kedha, ngi balbayg asin. Sew kalanu kay ngi mer koey yoewthoepa aymaypa nginu eso, ina Mosen Sabi yawoedhayzinga nginu siba wanay za, uruy yoewdhepa mura mabaygoepa imaypa kedha ngi balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nuy mabayg uzaraydhin, nuy mura mulaydhin mabaygoepa kedha, Yesun adhapudhay zageth midh nanga. Nubiya kurusipa kasa mura mabaygal ngapa Yesulpa imaypa, a nubepa Yesulpa matha ngoedhagidh lawnga goegathoepa mabapa mabaygiya paruya. Mabaygaw garsar nuyn ngoedhe kabuya panidhar. Nuy matha mabaygoegi dhadhabuthoenu meparu a mabaygal ngapa nubepa imaypa kasa mura doegamoengu. ");
INSERT INTO mwp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Moenari goeygi koeliya Yesu kuniya tidaydhin Kapoenamoepa. Ngulayg sobaginga gasaman kedha nuy mangiz lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Thana garwoeydhamoeydhin nungu lagoenu, mabayg koeygarsar, buthaginga muya uthaypa pasagudiya. Yesu nuy maw tharaydhin thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dhadhal nanga po mabaygal mangemidhin, thana ngapa angadhin dhag kikirilayg, magawgig. ");
INSERT INTO mwp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mabayg koeygarsar, thana yan nuthemin Yesulpa gasamaypa. Thana kadaypa memayin thodhapa, arkath ayman lagaw thodhanu balbayginga Yesuniya gimal. Thana nuyn senabi kikirilayg arkathiya mulupa madhin, apal wakunu yoewthan. ");
INSERT INTO mwp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu na imadhin thanamun mina yoepathaman koeyza, nuy dhagoepa ya mulaydhin kikiril gamupa, ‘Ngaw Kazi, nginu mura wati pawal gud woeyamoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dhuray sabiw ngurpay mabaygal thana sin nir. Thanamun wakay thoemamay muynu kedha, ");
INSERT INTO mwp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Nuy midh paru kedha umepa, mogo pugan Awgadh! Matha Awgadhaw kupay kedha nuydh gud wayan wati pawa!’ ");
INSERT INTO mwp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu senabi thonara nuy nungungu ngulayg asin thanamun wakay thoemamay midh nanga, nuy thanamulpa mulaydhin kedha, ‘Ngitha mingu senawbi wakay thoemamipa? ");
INSERT INTO mwp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngitha koey ngulaygal kedha palbi ukasar zageth ngaru kalmel za, wara kedha ngay kikiril mabaygoepa muliz, “Nginu mura wati pawal gudwoeyamoeyn!” lawnga ngay na kedha muliz, “Kaday tari a kusumar nginu uthuy rugal a mab uzar lagoepa.” ");
INSERT INTO mwp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngath ngithamulpa kakal ayman kedha, Mabaygaw Kazi kupaylnga ina apal gud woeyamoeyn mabaygaw wati pawal.’ Kalanu nuy dhagoepa buwayl thayadhin a mulaydhin, ");
INSERT INTO mwp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Ngay ngibepa muliz kedha, kaday tari, nginu uthuy zapul kusumaw a lagoepa uzar!’ ");
INSERT INTO mwp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Balbayginga senabi thonara, kikiril mabayg, kaday thariz, kusuman nungu uthuy rugal, uzariz lagoepa. Thana mura mina koeyma madhu pamemidhin, thanamun aka koeyza. Thana Awgadh koeyma thawmadhin kedha, ‘Ngoey kedha ngoedhal za kulay imayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kalanu Yesu kuniya tidaydhin Galilayaw Malu buwadhoepa. Koey garsar mabaygal nubiya kalmel. Nuydh kuykaymoedhin thanamulpa ngurpan. ");
INSERT INTO mwp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nungu maboenu woelmay nuydh iman bokadhzoengu garwoeydhamay mabayg nel Lebi, Alpiyasan kazi. Nuy muynu nungu zagethaw lagoenu. Yesu nubepa muliz, ‘Asir ngaybiya.’ Nuy matha koerar asin Yesulpa, wagel asin. ");
INSERT INTO mwp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wagel kay Yesu nuy nanga Lebin lagoenu muynu aydu purthay, kalmel nungu niyay kazil a dhuray koey garsar mabaygal si kalmel, bokadhzoengu garwoeydhamay mabaygal a adhapa imay mabaygal muynu. Thana nanga aydu purthay. ");
INSERT INTO mwp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dhuray Parasayalgal, a sabiw ngurpay mabaygal thana iman, Yesun aygudan kalmel sethabi pasipa imay mabaygal a bokadhzoengu garwoeydhamay mabaygal. Thana nungu niyay kazipa yapu poeybemidhin, ‘Nuydh midh paru ay purthaypa kedha wati mabaygiya kalmel, a ngukiw wanimpa, bokadhzoengu garwoeydhamay mabaygal a pasipa imay mabaygal?’ ");
INSERT INTO mwp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu karngemidhin thanamun Parasayalgaw ya; nuydh adhamintidan thanamulpa kedha, ‘Mabayg nanga kikirigig, nuy doktapa ubin mayginga, mabayg nga kikirilayg, wa nuy ubin miziz. Ngay ngapa mayginga mina mabaygoepa thuraypa, ngay ngaru wati pawa mabaygoepa thanamulpa buwayl idimpa Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wara thonara Yoewane Papthayson niyay kazil a mura Parasayalgal aygudag asimoeydhin Awgadhoepa apasin. War mabaygal ngapa Yesulpa yapu poeybaypa, ‘Minguz kedha Yoewanen niyay kazil a Parasayalgal ngulayg aygudagasin, a nginu niyay kazil lawnga?’ ");
INSERT INTO mwp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu thanamulpa kedha adhamintidan, ‘Gethaw garwoeydhamay ay nanga, koey zageth mabayg aygudoeginga garwoeydhamayzi mabaygaw parunu. Nuy niyaypa yoelpayzi garkaz, nuy nanga sena kalmel mabaygan ngaru mura gasaman, aygudaginga lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wagel bangal koey thonar gasamoene a nuyn niyaypa yoelpayzi mabayg adhapa manin thanamulngu. Senabi thonara kay thana aygudoegasimoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nuydh lak wara ya matha ngoedhagidh aymoedhin thanamulpa, ‘Ina kayn ngurpay ngithamulpa, kayn za ngaru kayn za, a kulba za ngaru kulba za, matha kedha kulba sodhanu, ngidh ngaru kayn dhoemawak woeydhayginga. Kedha nanga nadh kayn dhoemawakun nan beregud palan lak yelgan, pakadaman. ");
INSERT INTO mwp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","‘A matha kedha umal ngukiw za uruy goengaw aymayzinga. Kulba goengaw ngaru piranga, mabaygoepa matha ngoedhagidh lawnga kayn umal nguki malan kulba goengawya; nadh mina koeyma arkath dhanaman, mura idiman umal nguki a uruy goengaw. Kapu za kedha ngidh ngaru kayn umal nguki kayn uruy goengawya malan.’ Minguz kedha, kayn umal ngukiw sik ngaru koey bibirilnga, kulba goengawya. ");
INSERT INTO mwp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu nungu mab woelmay kunaw apaw lagiya sabadhoenu, a nungu niyay kazil kalmel. Thana niyay kazil kasa moenarimayl puy kunal tidamoeyn. ");
INSERT INTO mwp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Thana Parasayalgal nubepa Yesulpa kedha mulemin, ‘Nagi, nginu niyay kazin pathidhan ngalpan sabi. Ina sabadh! Matha ngoedhagidh lawnga thana sabadhoenu zageth ayman!’ ");
INSERT INTO mwp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kuniya mulaydhin thanamulpa kedha, ‘Ngitha geth tidayginga, Maygi Thusinu muynu kedha, kay paypa kulay ngalpan buway apakuyk, Dhawitha nuydh lak kedha za aymoedhin. Wara thonara nuy a nungu mabaygal koey maytha aygi pagar; thana ngaru ay purthar. ");
INSERT INTO mwp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nuy muy yoewthaydhin Awgadhaw lagiya a kusumoeydhin thanamulpa woenabal thoewa aydel sizi, kalanu purthadhin, matha koey yoewthaw niyay kaziw aydel, sethabi thoewa aydel wara mabaygoepa lawnga, sabilnga; Awgadhoepa poeybayzimayl. Senabi thonara Abiyatha koeyu misnari thanamuniya.’ ");
INSERT INTO mwp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu nuy kuth madhin kedha, ‘Senaw sabadh Awgadhan aymoedhin mabaygaw igililmaypa ibupuydhaypa. Ngitha sabadhaw sabi koey puridharalnga aymayg, sena mabaygoepa mapu poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mabaygaw Kazi ngay Kuykulnga, ngath mura yawaypa zapul matha kedha senabi goeyga.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wara na Sabadh nanga Yesu a nungu kalmel niyay kazil thana ladhudhin yoewthoepa. Wara mabayg si mepa nungu geth muwayzinga. ");
INSERT INTO mwp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wara Parasayalgan thana ngoelkay ayman, matha nuyn Yesu danal pathar gegeyadhoepa kedha; na kay midh, nuydh zageth ayimpa sabadhoenu, dhoey nidhaypa senabi mabayg sabathoenu. ");
INSERT INTO mwp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wa, Yesu thanamulngu ngulayg. Nuy muwayzi mabaygoepa muliz kedha, ‘Sew parunu kaday tari, mura mabaygoepa imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nuy Yesu mulaydhin thanamulpa kedha, ‘Matha ngoedhagidh midh, sabadhoenu ayimpa mina za lawnga wati za kedha, igil palan mabayg lawnga mathaman?’ Thana kasa yagi asimoeyn. ");
INSERT INTO mwp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nuy thanamulpa gegeyadh nagiz, nungu koerkak badh thanamulpa, thana koey ridha kuykul. Nuy kuniya buwayl thayiz mabaygoepa kedha, ‘Nginu geth adhapa luwayar.’ Wa, nuydh luwayadhin, na geth mina balbayg asin. ");
INSERT INTO mwp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Thana Parasayalgal sizi ladhudhin uwan, Erodhan mabaygoepa, kaliya tharaydhin Yesun, ‘Ngalpa bangal nuyn mathamoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu nuy adhapa uzaraydhin a Galilayaw Malupa. Kalmel nubiya koey goersar sew Galilayaw goegathaw mabaygal asimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Koeysigaw lagaw mabaygan na karngemidhin nuy midh na merparuy, thana mura ngapa nubepa ladhudhin Yoewdhayangu, Yoerusalemoengu, Idumayangu, a matha kedha Yuridhaw Koesaw wara doegam buwadhoengu, koeysigaw goegathoengu, a matha kedha Thayar a Saydon. ");
INSERT INTO mwp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Nuydh koeygarsar mabaygal dhoey nidhamoeydhin kedha zoengu mabayg koeygarsar kalmel kikirilgal thana amadhan pathamar nubepa gethan nidhaypa. Nuy buthagasir, zagethoepa a nuy niyay kazipa muliz kedha, moegina gul nubepa buth pathan. ");
INSERT INTO mwp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dhuray rimarim mabaygal wati mariw malayzimayl thana na midh thonar Yesun iman, thana wal tiduman kedha, ‘Ngi Awgadhaw Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nuy thanamulpa koey dharadh mulaydhin kedha, ‘Maygi, wara mabaygoepa mulayg, ngay nga nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wara thonar Yesu uzaraydhin padaw kibupa, kalanu nuy nungu ubilgal mabaygal thuraydhin, a thana asimoeydhin nubiya. ");
INSERT INTO mwp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nuydh toewalob adhapa thamayidhin kupay poeybadhin aposoelal aymoeydhin, thanamulpa nubiya kalmel oesipa; bangal wara goeyginu thana wayaydhin adhapa, nungu zagethoepa oengaypa maw siparuy a ");
INSERT INTO mwp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kupay poeybadhin thanamulpa wati maripa adhapa woeyaypa rimarim mabaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Itha thana toewalob aposolaw adhapa thamayzi mabaygaw nelay kedha, Simona. (Yesu nubepa wara nel poeybadhin Petheru.) ");
INSERT INTO mwp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zemes a nungu tukuyap Yoewane. Palay Zebadin kazi. (Nuydh thanamulpa kedha nel poeybadhin, Gigi Kazi. Thanamun yangukudu kedha bowanoerzi.) ");
INSERT INTO mwp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A wara thanamun nelay itha kedha, Andhoeru, Pilip, Bartholemiw, Mathayu, a wara Zemes Alpiyasan kazi, a Thadiyus, a wara Simona. (Thana nuyn kedha thoeraypu koey buway mabayg.) ");
INSERT INTO mwp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","A wara Yudha nuy Keriyothoelayg, ngadh na Yesun kalanu guda aradhin. ");
INSERT INTO mwp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu nuy lagoenu mangaydhin nanga mabaygan lak mina koey garsar garwoeydhamoeydhin. Thana buthag asimoeydhin sew lagaw mabaygal aypa aygudoepa. ");
INSERT INTO mwp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nungu buway mabaygan nanga kedha karngemidhin, nuydh zageth kedha oengaypa, thana ladhudhin nubepa adhapa gethiya yoelpaypa lagoepa. Thanamun wakay thoemay kedha, ‘In nuydh kuyk guythuyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dhuray sabiw ngurpay mabaygal ngaya nanga Yoerusalemoengu, thana lagoepa ladhudhin Yesulpa, a kedha mulemidhin, ‘Sena nuy Sathanan mariw gethiya yoelpayzinga, matha kedha nuyn Bilzibaban gethiya yoelpan; nuydh kedha zoengu ngulayg wati mariw adhapa maythayle; nuydh senawbi kupay gasamoedhin thanamun wati pawa mopakuykoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kalanu Yesu thana thuraydhin a mulaydhin kedha, ‘In kay ngath ngithamulpa adhamintidaypa; midh kay paru Sathana, Sathanan adhapa maypa mabaygoengu? ");
INSERT INTO mwp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Midh kay paru basalaya nanu geth dhadhiya mepa. Kedha nanga, senabi basalayapa kuykuthalnga kaday thoeraypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Buway lak kedha, nanu geth kay nanga dhadhiya mepa, nabepa kuykuthalnga kaday tharepa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‘Sathanan nanga lak kedha ngoedhal za ayman nanga, nubepa lak kedha kuykuthalnga kaday tharepa lawnga. Ngitha nanga ngayapa kedha, ngay Sathanan mariw malayzinga, wa midh kay paru ngath Sathanan mari adhapa maypa mabaygoengu? Kedha nay na ngaru Sathanan kuth. ");
INSERT INTO mwp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sathana ngoedhe koey bibiril mabayg, ngibepa kasa matha nungu loegiya muya uthuypa lawnga. Nginu nanga koey magawl mabaygaw lagoengu zapa gasamoeypa ubi, ngidh ngaru kulay nuyn urukoemin yatharpa. Wagel kay ngidh nginu ubilnga ayman. ");
INSERT INTO mwp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‘Ngay ngithamulpa mina kay mina ya muliz kedha, ngitha bangal ngaru koey poeypiyam. Awgadhan ngulayg bangal mura wati pawal bangal gud woeyamoeyne matha kedha mabaygaw Awgadhoepa kuniya ngoelkay yangukudul, Awgadhan ngulayg adhapa gud woeyamoeyn. ");
INSERT INTO mwp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kasa kay kedha mabaygan ngaya nanga Maygi Maripa ngoelkay yangukuduya ya umamoeypa, thanamun senawbi gegeyadh bangal ngaru thanamuniya kuthaginga kuykuginga. Thanamun kedha gegeyadh ngaru gud woeyayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nuy kedha zoenguz kedha mulaydhin thanamulpa kulay, minguz kedha thana kedha mulamoeydhin, nubiya muynu Sathanan mari. ");
INSERT INTO mwp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Senabi thonara nanga Yesun apu a tukuypal thana adhal mangemidhin, a ya madhin nubepa adhapa thuraypa, yapa yapupoeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nubepa na senabi yangukudu mar nanga, sinubi thonara mabayg nubiya mina koey goesar nuyn zug nanamipa. Thana nubepa kedha mulemidhin, ‘Nginu apu a tukuypal thana si adhal ngin lumaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nuy kedha mulaydhin thanamulpa kuniya, ‘Mabaygal ngaya ngaw apu a tukuypal?’ ");
INSERT INTO mwp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kalanu nuy mabaygiya mura gurguy nagaydhin nubiya ngaya nanga nir; nuy kedha, ‘Ngaw apu a tukuypal itha! ");
INSERT INTO mwp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mabaygan ngaya nanga Awgadhaw ubilnga ayimpa, thana sethabi mabaygal, ngaw apu, ngaw babath, a ngaw tukuyap.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu lak ngurpan ayman, Galilayaw Malu buwadhoenu pasinu. Mabayg mina koey garsar nubiya. Nuy gulay pathiz adhal woeray amadhan tawalpa, mura mabaygoepa nungu yoepa koerngaypa. Nuy apal gulay thanuriz a thana woerngu dhangoenu kaday sir. ");
INSERT INTO mwp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nuy thanamulpa maw tariz, ngurapiz koey garsar zapul ya matha ngoedhagidh aymoeyr. Nuy kedha, ");
INSERT INTO mwp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Karngemiw! Wara thonara nagu uthuy mabayg apaw lagoepa uzaraydhin kunaw kapupa uthuypa. ");
INSERT INTO mwp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nuydh nanga kunaw kapul mura idiman dhoeypa. Dhuray kapul yabugudanu pudhemin uruyl ngapa purthan. ");
INSERT INTO mwp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","‘Dhuray kulal boeradharoenu pudhemir, boeradhar kuthuka a thana kapul sobaginga malguy adhan, kuyk na kuthuka boeradhar. ");
INSERT INTO mwp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kalanu goeygin mathamoeydhin. Minguz kedha, boeradhar kasa moegina; thanamulpa koesimoeypa matha ngoedhagidh lawnga, sipil mamu mulupa zilmayginga. ");
INSERT INTO mwp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","‘Dhuray kapul patal bupanu pudhemir. Thana na koesimir, bupan mathaman sethabi nagul, thana koewsagimayl. ");
INSERT INTO mwp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","‘Dhuray mina boeradhariya pudhemir. Thana malguy puydhar, a koesimoeyr, a koewsa puydhemir puy kunal, wara 30, wara 60, a wara 100.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu kuthanu nuy muliz kedha thanamulpa, ‘Ngi nanga kawralnga, wa kurusipagi!’ ");
INSERT INTO mwp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu nanga nungu kusayg, dhuray mabaygal Yesun ya na gasaman nanga thana ngapa nubepa nungu toewalob niyay kaziya kalmel. Thana nubepa yapu poeybemin, nuydh lak sakar pudhan nungu adhamintidayzi ya. ");
INSERT INTO mwp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kuniya mulaydhin thanamulpa kedha, ‘Ngithamulpa ya mura yadupalgadhin muy ya, Awgadhaw Basalaya midh nanga, kasa kay kedha mabaygal na ngaya adhal thana kasa gimal kurusipagemipa adhamintidayzi yoepa. ");
INSERT INTO mwp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Thana kedha zoenguz matha kedha Minar Poelayzinga midh nanga, “Thana nagemipa kasa kay imayginga. Thana kurusipagemipa kasa kay thana koerngayginga, tidayginga. Thana nay mina gasaman Awgadhoepa buwayl thayamin, wa balbayginga, nuydh guythuyan mura thanamun gegeyadh.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kalanu Yesu kedha mulaydhin thanamulpa, ‘Ngitha toela thoeyayginga thabi sakariya thoeyayzi yaday? Kedha nanga ngitha imayginga ngitha midh paru wara sakariya yaday gasamoeyn? ");
INSERT INTO mwp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sew nagu mabayg, nungu thoeyayzi kapul thana matha kedha Awgadhaw yangukudul. ");
INSERT INTO mwp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","‘Dhuray mabaygal thana matha kedha kapul yabugudiya pudhemin. Thana na karngemin Awgadhaw ya, Sathana ngapa sobaginga adhapa manin, idiman thanamun igililmayngu. ");
INSERT INTO mwp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","‘A dhuray mabaygal thanamun igilaw sakar matha kedha kapul midh, kulaw boeradhanu pudhemin. Thana mina ngurpay na karngemin nanga, senawbi thonara thanamun ika dhiw koeyza, ");
INSERT INTO mwp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kasa kay kedha thanamun mari igililnga gimiya muk, sipil mamu mulupa zilmayginga. Thana kasa thawpay thonarpa balbayginga. Midh thonara nanga wati za dhadha mangiz lawnga koerawayg mabaygal mangemin, thana aka palimoeyn. Thana kasa akan zilmemin sobaginga geth wanemin Awgadhaw yangu. ");
INSERT INTO mwp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","‘Dhuray mabaygaw sakaral matha kedha kapul midh, patal bupanu pudhemin. Thana karngemin Awgadhaw ya, ");
INSERT INTO mwp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kasa kay kedha thana koeyma ubin memayipa apaw goewaw igililmaypa. Thanamun wakay thoemamay thanamun gamu igililmay a nabi apaw goewaw sirisiril, a sethabi sirisiril matha kedha patal puy midh. Mura Awgadhaw mina ngurpay adhapa mizin thanamun mina igililmayngu. Thanamun sethabi mabaygaw igililnga aykapuginga. ");
INSERT INTO mwp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","‘A wara mabaygal thanamun igilaw sakaral matha kedha kapul midh mina boeradhanu pudhemin. Thana karngemin a ayman senawbi mina ya, koesimiz a koewsa puydhiz. Wara igililmayl puydhamoeyn 30 koewsal a wara 60 a wara 100.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu lak adhamintidayzi ngurpay ayman thanamulpa, mina igilaw sakar midh nanga, ‘Koey zageth mabaygan thungi manin a besininu apal wardhan, lawnga uthuy lagoenu apal. Nuydh ngaru gimal wanan nanu siyay lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mi zapul kayib gumi ngaru bangal kakal mabaygaw parunu, a mi zapul woerdhayzimayl nanga ngaru bangal woerdhayginga. ");
INSERT INTO mwp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ngi nanga kawralnga, wa karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nuy thanamulpa mulaydhin kedha, ‘Mamu karngemin, mina yoepa a ngidh ayman sethabi zapul sena nginu pawa midh wara mabaygoepa, wa, nginu Daparaw Thathi lak bangal gimal kabuthan senawbi pawa ngibepa. ");
INSERT INTO mwp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Poeypiyam kulay Awgadhoengu a kurusipagemiziw nungu yapa; ngadh nanga moegina gasaman, Awgadhan bangal nubepa poeybane koeyza. Ngadh nanga tidayginga, nungungu bangal adhapa mamayine, setha nungu mi moegina zapul.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu nuy matha umepu Awgadhaw Basalaya yadu poelgaypu, ‘Awgadhaw Basalaya ngoedhe kedha nge, mabaygan kapul idiman mura nungu zagethaw boeradhoeriya. ");
INSERT INTO mwp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalanu nuy war zagethan meparu goeyga kubil koey garsar. Kasa midh kubilu nungu uthuy, goeyga nuy gurguy ulaypu nungu ubilmaypa. ‘Setha nungu uthuyzimayl kapul nanga kasa thanamun geth malguy puydhoedhin, a koesimoeydhin nubepa gumi. ");
INSERT INTO mwp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","29","Minguz kedha, na boeradhar waza kapu boeradhar, nagul balbayginga malguy palgidhin, kalanu kayn ay puydhaydhin, a burugam asidhin. Ay nanga giya asin ayboewdhaw thonar gasaman. Senaw ngadh nanga uthudhin, nuy bangal sobaginga uzaridhe, giya aypa adhapa poethaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kalanu Yesu nuy nubepa yapu poeybiz kedha, ‘Ngalpa kay mi kuykul ina Awgadhaw Basalaya sakar pudhaypa; ngath kay mi sakariya thoeyayzi ya pudhamoeypa? ");
INSERT INTO mwp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Awgadhaw Basalaya na ngoedhe kedha nge mastadaw kapu midh nanga, na kuthuka wara kedha moegina kapuginga ngithamun nagu lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kasa kay kedha ngidh nan boeradharoenu uthun na koesimiz koeyza, war nagul kuthukamayl. Nanu thamal koey zapul uruypa padoepa aymoeypa matha ngoedhagidh nanu iradhoepa, a thanamulpa lag aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nuydh koey garsar zapul thanamulpa adhamintidaydhin a nuydh thana gabudhan ngurpamoeypu, thanamulngu koerawaygoengu. ");
INSERT INTO mwp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nuydh wara thanamulpa mamu ngedh ngurpay aymayginga. Mura nungu ngurpayl thanamulpa mabaygoepa nanga, mura kakal ya matha ngoedhagidh aymoeyzimaya. Matha nuydh nungu niyay kazipa mina mura moegithap sakar madhin nungu ngurpay aykap midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Goeygiw kutapa nanga nuy nungu niyay kazipa kedha mulaydhin, ‘Ngalpa thakaripa malu war doegam buwadhoepa.’ Wa, nungu niyay kazil nubiya kalmel pathemidhin war doegam buwadhoepa butanu. Thanamuniya kalmel dhuray butal. Mabaygaw garsar kasa si kuniya wanaydhin. ");
INSERT INTO mwp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Thana nanga pungar, thanamuniya dhadhal gub mangaydhin, baw lugitharadhin butaw mina amadhan dudupay, woer kasa zapun muy thayar. ");
INSERT INTO mwp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nuy Yesu senawbi thonar uthuy yoewir kunanu, guzinu kuyk woeydhayzinga mer. Thanamun aka mina koeyza; thana nuyn walman, kedha mulemin nubepa, ‘Ngurpay Mabayg, kame! Kame! Ngidh midh wakay thoemamipa, in ngalpan amadhan dudupay?’ ");
INSERT INTO mwp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nuy nanga dan palaydhin nuy gubapa kedha mulaydhin, ‘Mulupa pudi, ngi mingu puridha asinu?’ a malupa nuy kedha mulaydhin, ‘Thuma asir.’ Sew kalanu mina koey idi pudhaydhin ngalagaw gub baw apasidhin. ");
INSERT INTO mwp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kalanu nuy nungu niyay kazipa buwayl thayiz, kedha muliz, ‘Ngitha mingu akan memayipa. Ngitha matha mina yapa thoemayginga ngayapa?’ ");
INSERT INTO mwp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Thanamun aka mina koey zapul, thana kedha kidhakidhan, ‘In midh paru mabayg, gub a malu nubepa karngeminu?’ ");
INSERT INTO mwp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Thana Galilayaw Maluya bal pagadhin wara doegam buwadhoepa. Thana gasamoedhin Geroesinaw goegathoepa. ");
INSERT INTO mwp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu nanga pagan butangu nubiya mangiz mabayg, wati mariw malayzinga. Nuy ngapa moeram gudoengu. ");
INSERT INTO mwp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Nungu niyay lag sakaynu muynu, moeram gudoenu. Nuy koey thabukiriw mabayg kasa kay kedha mabaygan koey zageth nuyn yatharan. Matha kedha malil urikam matha ngoedhagidh lawnga nuydh lak papudhamoeyn, ngarangu a gethangu. Mabaygoepa matha ngoedhagidh lawnga nubepa kunumaypa. ");
INSERT INTO mwp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Goeyga kubil koey garsar nuy kasa gurguy ulaypa moeram gudiya a padiya; ar pugepa, a nuy nungu geth gamu kulan papathamipa. ");
INSERT INTO mwp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Koey sigapa nuydh Yesun imadhin, wa nuy zilmaydhin a kulun pasayniz nubiya parunu. ");
INSERT INTO mwp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nuy koey gimiya wal miyaydhin, ‘Yesu Awgadhaw Kazi, nuy Awgadh koey gimal, ngi mi ubilmaypa ngapa ngayapa? Awgadhaw parunu ngidh kay ngayapa kuth thoerayg!’ ");
INSERT INTO mwp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wagel kay senabi garkaz wal miyaydhin, Yesu kulay kedha mulaydhin, ‘Wati mari ngi adhapa senabi mabaygoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kalanu Yesu yapu poeybiz nubepa, ‘Nginu nel nga?’ Nuy mabayg kedha nubepa muliz, ‘Ngaw nel koeygarsar kuyk koeygarsar wati maril in gamunu muynu.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nuy koeyma thonaralnga Yesulpa yoewdhaydhin kedha, ‘Maygi adhapa woeyayg wati maril thabi boeradharoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Koeygarsar buruman amadhan padaw berowiya ay purthaypu. ");
INSERT INTO mwp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Thana wati maril Yesulpa mulemidhin, ‘Ngoey kedha burumpa woeyay, ngoey kay setha muy aremipa burumoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wa, nuy kudu madhin a thana wati maril dhanamaydhin mabaygoengu a burumiya uthemidhin. Sena burumaw woelak, thana mura padiya mulupa zilmemidhin, a dudupamoeydhin malunu adhal. Senabi burumaw garsar 2000 mura. ");
INSERT INTO mwp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Thana burumaw danal poethay mabaygal zilmemidhin yangukudu madhin mudhaw lagoepa a matha kedha mura moegina mudhaw loegiya. Mabaygal imaypa ubin memayidhin, na za miza nanga aymaydhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A thana nanga Yesulpa, thana imadhin nuyn mabayg wati marin ngan na siparuy kulay. Thana nuyn dhoemawakulayg imadhin, a nuydh mina wakay thoemamay kuniya gasamadhin. Thana nanga iman thanamun aka koeyza. ");
INSERT INTO mwp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Thana ngaya na imadhin Yesun zageth, thana umamoeyr mabaygoepa kedha, zapul midh nanga aymoeydhin wati mariw moelayzi mabaygoepa, a matha kedha burumal midh na dhanamay. ");
INSERT INTO mwp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mabaygal Yesulpa mulemidhin kedha, thana bangal wanane senabi koey boeradhar. ");
INSERT INTO mwp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu nuy butanu pathaydhin, nuy kulay nga nanga wati, mariw malayzinga ngapa Yesulpa a yoewdhaydhin kedha, ‘Ngay kay ngibiya oesipa.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kasa kay kedha Yesu nuyn wadhadhin kedha, ‘Lawnga, ngi kuniya tidi nginu lagoepa a nginu mabaygoepa, a thana yadu thuremoeyr kedha, kuykulmay mi mina za ngibepa ayman, a mina koerkak badhal pawa.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wa, nuydh mabaygan Yesun wanan, nuy uzaraydhin 10 mudhaw lagoepa, senabi doegam nel Dekapolis. Nuydh thana mura yadu thuraydhin kedha, Yesu nubepa mi matha ngoedhagidh aymadhin. Mura setha ngaya nanga karngemin, thana mina madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","22","Yesu a nungu niyay kazil, thana nanga kuniya tidemidhin wadhoegam buwadhoengu, mabaygan mina mura garwaydhamoeydhin nubepa. Nuy ka matha woerngu buwadhoenu mer, wara thanamun yoewthaw kuyku mabayg nel Zayroes ngapa sin nubiya parunu kulun pasayniz, ");
INSERT INTO mwp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a mina koeyma yoewdhiz kedha, ‘Ngaw yoepkaz kaziw gar amadhan um, ngi gar aya ngaybiya asir. Ngidh gar kay kasa nanga geth wanaypa nabiya, nanungu umangu?’ ");
INSERT INTO mwp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kalanu Yesu nubiya asidhin, senawbi mabaygaw garsar lak nubiya wagel asimoeydhin, dhuray mamu zug nanamoeyr Yesuniya. ");
INSERT INTO mwp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Senabi thonara thanamuniya wara yoepkaz puzir. Na senabi yoepkaz moelpalan ipi yapaydhin 12 wathoepa, goeyga kubil koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nadh mura doktal imaypa nuthaydhin, a thana mura yaynanob nuthemidhin dhoey nidhaypa nabepa, kasa kay kedha nanu kikir kasa lak mapu oesipu a bokadhza mura guythuyadhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Senabi thonar nadh karngemidhin Yesun adhapudhay dhoey nidhay zageth, na kedha zoengu wagel asidhin Yesuniya. Mabaygiya dhadhiya nadh Yesun koey sodh gethan gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nadh nabiya kedha wakay thamamayidhin, ‘Ngath kay na nungu koey sodh gethan gasampa, ngay kay mura balbaygoesipa ngoezu nabi kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nadh na mi thonara gamu tharadhin Yesun sodh, senabi kikir nanu wath pathadhin, senabi thonara, nadh nanu gamunu muynu gasamoedhin kedha, na balbayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Senabi thonara Yesu ngulayg asidhin kedha, nungungu woenab a poerapar adhapa miyaydhin; nuy kuniya tharaydhin a mabaygoepa yapu poeybaydhin kedha, ‘Ngaw sodh, ngadh gethan gamu tharanu?’ ");
INSERT INTO mwp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Thana nungu Yesun niyay kazil nubepa kedha, ‘Ngidh imayginga, ngibepa kakal kedha, in mabayg mina koey garsar zug nanamipa, ngi mipa yapu poeybepa kedha, ngin ngadh gamu tharanu?’ ");
INSERT INTO mwp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kasa kay kedha Yesu ngaru nagay, imaypa kedha mabaygan ngadh nungu sodh gamu tharanu. ");
INSERT INTO mwp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na yoepkaz na nanunguz ngulayg nanu gamunu kikir muwasidhin. Na matha uzaraydhin Yesulpa apa pudhaydhin nubiya parunu, nanu gamu gar lupar akan. Na mina mura soleginga yadu palgadhin zapul midh paru nanga. ");
INSERT INTO mwp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kalanu Yesu mulaydhin nabepa kedha, ‘Ngaw kazi uzar, woenab ngibiya kalmel; ngin kedha zoenguz mina dhoey nidhan, kuyk nginu mina yoepathaman.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nuy nanga yadu umay Zayroesan zapa woeyay mabaygal ngabunadhin nungu lagoengu kedha yadaygal, ‘Nginu yoepkaz kazin muwasinu; ngidh nuyn Ngurpay Mabayg yoelpayg nginu lagoepa, ngidh nungu thonar guythuyayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu nanga thanamun yangu wakay gasamoedhin, nuy kedha mulaydhin yoewthaw kuyku mabaygoepa, ‘Akan maygi, thanamulpa koerngayg, lak akag kasa mina yoepathamar.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nuydh senabi mabaygaw garsar mura wadhaydhin, nuydh yoelpamoeydhin nubiya kalmel matha Petheru, Zemes, a nungu tukuyap Yoewane. ");
INSERT INTO mwp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Thana nanga amadhan aymoeydhin yoewthaw kuyku mabaygaw lagoepa nanga, Yesu imadhin kedha mabaygan may mar a thana mina koey gimiya may mar. ");
INSERT INTO mwp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nuy nanga muy yoewthaydhin nuy kedha mulaydhin thanamulpa, ‘Ngitha mingu mina koey gimiya may maypa, ina moegina kaz um mayginga, na kasa uthuy yuwipa.’ ");
INSERT INTO mwp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Thana kasa giw mar nubepa. Kalanu nuydh thana sizi lagoengu mura adhapa wayaydhin muyngu. Nubiya si matha apu thathi a nungu pasi puziw mabaygal; thana muya uthemidhin na moegina yoepkaz ngalaga nanga yuwir. ");
INSERT INTO mwp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nuy nanu gethanu nidhaydhin a thanamudh kedha mulaydhin nabepa, ‘Talitha kum.’ (Aykap muynu kedha, ‘Moegina yoepkaz, kaday tari, ngay ngibepa kedha muliz.’) ");
INSERT INTO mwp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na moegina yoepkaz mina senabi thonara kaday tharaydhin, a mab uzaraydhin; na matha toewalob wathaylayg. Thana sethabi thonara mina koeyma madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nuy thanamulpa mina koey ridha ya woedhan aymoeydhin, si muynu kedha, ‘Wara bangal kobegadh mabaygoepa mulayg, ngath miza nanga aymoenu.’ Nuy thanamulpa wara kedha mulaydhin, ‘Ngitha nan aydu poeybaw.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Senabi ngurpay kalanu Yesu nuydh senabi lag wanadhin, nungu mina geth lagoepa kuniya uzaraydhin kalmel nungu niyay kazil. ");
INSERT INTO mwp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabadhoenu nuydh nungu ngurpay kuyk aymoedhin thanamun yoewthanu muynu. Koeyma mabaygan ngaya nanga karngemidhin, thana mina koeyma madhu pamemidhin kedha, ‘Ey, nuydh ngalagaz sethabi ngurpay zapul gasamoeydhin; nubepa koey ngulayg ngalagaz? Nuy midh paru ngulayg adhapudhay zagethoengu aymoeyle mabaygaw buth poethayle? ");
INSERT INTO mwp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nuy kasa kamda, koey ngurpay mabayg lawnga, nuy miyay Mariyana kazi, a nungu tukuypal Zemes a Yoewsepa, Yudha, a Simiyon. A nungu babthal itha muynu.’ Kedha zoenguz thana nubepa koerngayl kawra mayginga, a apasiginga. ");
INSERT INTO mwp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kedha thanamulpa, ‘Mura lagiya nanga peropethoepa koerngayl kawra aympa, a apasimoeypa, matha nungu goegathoenu koerngayginga mina koeyza, a matha kedha nungu geth lagoenu, nungu kulkaw mabaygiya.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nubepa matha ngoedhagidh lawnga koey zagethoepa aymoeypa, kasa gegeyadh, nuydh matha moenarimayl kikiril mabaygal balbay tidadhin a dhoeynidhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nuy mina koeyma madhu pamaydhin nuydh nanga imadhin kedha mabaygan mina yapathamayginga nubepa. Thanamuniya thimedh mayginga. Kasa kay kedha nuydh Yesu ngurpay matha ayimpu goegath goegathiya. ");
INSERT INTO mwp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wara goeyginu nanga Yesu ngapa thuraydhin nungu niyay kazil. Kalanu nuydh wayaydhin thana ukasar ukasar mura yaynanob goegathoepa. Nuydh thanamulpa kupay madhin thanamulpa mabaygoepa wati maripa adhapa maypa. ");
INSERT INTO mwp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nuydh yawoedhan aymoedhin thanamulpa kedha, ‘Wara zapul bangal maygi ngithamuniya kalmel maboenu, matha boegi kedha. Kunaw susu lawnga, a rugaw yana lawnga, a bokadhza maygi ngithamuniya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ngitha bangal matha azaz ngaral kusumoene, a setha ngithamuniya mi rugal nanga soeyzipa; matha kedha, wara lak rugal maygi.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nuy lak mulaydhin thanamulpa kedha, ‘Ngitha na mi lagiya muya idiman nanga, matha sew bangal kurusipa ngitha sizi wara goegathoepa ladhun. ");
INSERT INTO mwp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","‘Ngitha nanga mi goegathan ayawal mayginga a koerngayginga nanga ngithamulpa, ngitha wara goegathoepa ladhun sizi. Ngitha buthu lupemin sanoengu; thana nanga iman, wa thana ngulayg asin kedha, thanamun koerngayginga koeyza thana ngoedhe inuraw mabaygal nge.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kalanu thana ladhudhin ukasar ukasar yaynanob maw siparu goegath, goegathiya kedha, ‘Adhapa buwayl thayemiw ngithamun wati pawangu, garthil thayemiw Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A thana wati maril adhapa mamayir mabaygoengu, a kikiril mabaygiya thana wakasun pinimoeypu, kalanu kuyku nidhamoeydhin thana thanamun kikiringu. ");
INSERT INTO mwp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Thanamun Yoewdhayalgaw kuyku mabayg Erodh nuydh Yesun mura zagethaw yaday karngemidhin, kuyk Yesun ya mura goegathiya zoelmaydhin. Dhuray mabaygal sethabi thonara kedha, ‘Nuy Yoewane Papthayso umangu kaday tharayngu! Nubiya kedha zoenguz senabi woenab mepa adhapudhay koey zagethoepa aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wara kedha umamoeyrngu, ‘Nuy peropeth Elayza!’ a dhuray kedha, ‘Nuy peropetha, setha kulay mi peropethal nanga kulay.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erodh nanga midh thonara karngemidhin nanga senawbi ya, nuy kedha mulaydhin, ‘Senaw nuy Yoewane Papthayso! Ngath nungu kuyk adhapa pathadhin kulay, kasa kay kedha nuy midh paru lak igililnga!’ ");
INSERT INTO mwp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wagel kay mura thabi zapul, Erodh nuydh kulay Yoewane Papthayson kunumay lagoepa gasamoedhin, kuyk nuydh nungu tukuypaw ipi nubepa ipi madhin. Nanu nel Erodhiyas. Na kulay Erodhan tukuypaw ipi, Pilipan ipi. ");
INSERT INTO mwp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yoewane nuy mura thonara kedha umepu Erodhalpa, ‘Sena matha ngoedhagidh lawnga ngi niyaypa yoelapiz nginu tukuypaw ipiya.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nanu Erodhiyasana ubi Yoewanelpa uma mathamoeypa, kasa kay kedha nabepa kedha aymoeypa koey zageth. ");
INSERT INTO mwp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Minguz kedha, nanu alay Erodh nuy akan kedha wati zoengu aymoeyle. Nuy ngulayg kedha, Yoewane mina kapu akasizi mabayg, nuydh nuyn kedha zoenguz giyaw woengan umangu. Erodh nuyn ngulayg kasa kobegadh thonara thuran Yoewanen nubepa kurusipoegaypa. Erodhan kasa midh wakay thoemamay koey garsar aymoeypa, nungu kasa ngaru ubi Yoewanelpa. ");
INSERT INTO mwp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nadh Erodhiyas kurusipa aymoedhin nanu wati ubilnga zageth. Erodhan kazi mayzi goeyga nanga nuydh mina koey tha aymoedhin mura gabmenaw kuyku mabaygoepa, koewbu kuyku mabaygoepa, a matha kedha mura Galilayaw koey mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nanu Erodhiyasana yoepkaz kazin mina kapu girel aymoedhin mura mabaygiya parunu senabi thangu lagoenu. Erodh a nungu thurayzi mabaygal thanamulpa mina matha ngoedhagidh, koey dhiwalnga nanu sagul. Nuy kuyku mabayg nabepa kedha mulaydhin, ‘Nginu mizoepa ubi, ngath kay ngibepa maypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nuydh nabepa koeygarsar zapul pa ngoedhalmayl poeybaypa mamayir kedha, ‘In ngay Awgadhaw parunu ngibepa mina koey mina yadu umepa, ngath kay ngibepa ngaru maypa, kasa kay moegina mura ngaw niyay lagaw mina zoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kalanu na adhapadhadhin a nanu apupa yapu poeybaydhin kedha, ‘Ngay kay mi zapa mulipa?’ Na apu kedha mulaydhin, ‘Yoewane Papthayson kuyk kedha thonara, adhapa pathayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na yoepkaz kuniya Erodhalpa a kedha mulaydhin, ‘Ngoezu ubi kedha ngidh ngayapa kedha thonara mar Yoewane Papthayson kuyk beseninu kay muynu aral.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nuydh na Erodh gasaman nanga nuydh mina koerkak badh gasamoedhin, kasa kay kedha nubepa ubig oesipa lawnga, kuyk nuy nabepa mulaydhin mura mabaygaw parunu, nuy mi mina koey ya mulaydhin nanga. ");
INSERT INTO mwp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nuydh nungu gamu puziw mabayg wayadhin Yoewanen kuykupa ngapa maypa. Nuy nungu gamu puziw mabayg uzaraydhin kunumay lagoepa, Yoewanen kuyk pathadhin. ");
INSERT INTO mwp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kalanu nuydh nan beseninu muynu aradhin, a nabepa yoepkazipa madhin. Kalanu nadh nanu apupa madhin. ");
INSERT INTO mwp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nungu nanga Yoewanen gamu puziw mabaygan karngemidhin nanga, Yoewanen kuykupoethay ya, thana ladhudhin a nungu gamu madhin. Kalanu thana moerama thayadhin. Kuyk mura nubi sirisir, Erodhan aka mina koeyza nuydh na senabi kasa ya karngemidhin kedha, Yoewane Papatayso lak kaday tharaydhin umangu. ");
INSERT INTO mwp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesun niyay kazin nanga zageth muwasidhin thana kuniya tidemidhin nubepa yadu thuraypa thana zapul midh paru nanga aymoeyr, a ngurpay thanamun. ");
INSERT INTO mwp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Senabi thonara mabayg mina koey garsar, Yesu a nungu niyay kazil thanamulpa kasa aygudoepa gegeyadh. Yesu kedha mulaydhin thanamulpa, ‘Ayawal, ngapa ngaybiya asimoey, ngalpa mabaygoegi dhadhasakarpa ladhuypa ngoenapudhaypa, matha ngalpa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kalanu thana thanamun butanu mamayidhin mabaygoegi dhadhasoekarpa ngoenapudhaypa. ");
INSERT INTO mwp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kasa kay kedha mabaygan thana imaydhin a kulay thayamidhin ngaran gimiya, woelay woelay wamayir mura goegathoengu. ");
INSERT INTO mwp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Thana na mangemidhin nanga Yesu kadaypa pagadhin a imadhin mabaygaw garsar; nungu koerkak badh miyaydhin thanamulpa, minguz kedha thana gar ngoedhe mamuy danal poethay mabaygoeginga. Sina nuydh matha ngurpay kuykayman mura zapun ngurpamoeyr thana. ");
INSERT INTO mwp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Goeyga na pawpa aymiz nanga, nungu niyay kazil ngapa nubepa a kedha mulemin, ‘In goeyga mina pawpa, ina amadhan goegathoeginga, ina zaginga thanamulpa aypa gasamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ngidh thana wayi amadhan apawlagaw sawalagoepa a amadhan goegathoepa lak kay thana ayde barpudhamoeypa thanamulpa aygudoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nuy kuniya thanamulpa kedha mulaydhin, ‘Lawnga, ngitha thanamulpa ayde mamayi aygudapa.’ Thana kedha nubepa Yesulpa, ‘Nginu ubi midh kedha, ngalpa kasa koeyma bokadhza sagul poelaypa, ngoey kay ngalagaz kedha koey bokadhza gasampa ten tawsan dolal sikedh, puy kunoepa barpudaypa thanamulpa aygudoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kalanu Yesu thanamulpa yapu poeybiz kedha, ‘Ngithamuniya midh mura sey puy kusnaw susul. Ladhu imaypa.’ Thana na imiz thana nubepa kedha mulemin, ‘Itha matha payb kunaw susul a ukasar wapi.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu kedha muliz nungu niyay kazipa, ‘Apa niyaypa mamayi setha mabaygal, kedha thana yaynanab, kapu maludh gamul bupiya gimiya niyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Thana gar thanamun kuwaya nithaman, wara kuwaynu pipti mabaygal, a wara kuwaynu andred mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kalanu Yesu sethabi payb kunaw susul kusuman a ukasar wapi. Nuy kalanu daparpa kadaypa nagaydhin a Awgadhoepa eso poeybaydhin. Nuydh kunaw susul kope tidamoeyn a nungu niyay kazipa kusuman thanamulpa mabaygoepa poeybaypa. A nuydh lak ukasar wapi kedha mamaman mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Thana mura balbayginga maytha yoeruylnga, senabi ay purthadhin, na kulay kasa moegina, ");
INSERT INTO mwp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kasa kay kedha ay muynu koey garsar, Awgadhan senabi moegina ay kedha madhin, thana niyay kazin thadha wanayzimayn toewalob mura liday aymoeydhin ayngu kunaw susul a wapi. ");
INSERT INTO mwp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Senabi moegina aydu poeybadhin nanga mabaygaw garsar mina koeyza, garkazil mura payb tawsan. ");
INSERT INTO mwp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sew kalanu nanga nuydh nungu niyay kazil sobaginga wayaydhin butanu. Thana nubiya kulay war doegam buwadhoepa, goegath nel Bethsayda. Nuy mabaygoepa mura mulaydhin senabi thonara kedha, ‘Ladhu.’ Wa, thana mura ladhudhin kalanu. ");
INSERT INTO mwp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mabaygaw yawal woeyay kalanu Yesu nuy padoepa kadaypa uzaraydhin, thoeythupoegaypa. ");
INSERT INTO mwp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Inur nanga toedimoeydhin, thanamun niyayziw ngulaynga, but matha malu dhadhiya pungar. Senabi thonara nuy Yesu matha gimanoeka, nungu kusayg lumadhoenu. ");
INSERT INTO mwp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nuydh imadhin kedha, nungu niyay kaziw sirisir thana mina koey gubiya paypa thapar but. Goeyga pudhaynu nanga nuy thanamulpa pagan woerab gimiya mab woelmay. Nuy nanga yabay thoeyaydh miyaydhin nanga ");
INSERT INTO mwp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","thana nuyn imadhin nuy woerab gimiya woelmay. Thanamun wakay thoemamoeypa kedha, ‘A! Mari senaw boey!’ Thana ar pugemidhin, thanamun akal mina koey zapul, thana nanga nuyn imadhin. Yesu balbayginga thanamulpa mulaydhin kedha, ‘Ngitha akag, in ngay.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kalanu nuy thanamuniya kalmel pathaydhin butanu. Sinubi thonara abere gub muwasidhin. Nungu niyay kazil mina koeyma madhu pamemidhin, muynu thana kedha memayiyir, ‘In midh paru mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Thana nungu kulay goeygiw zagethal pudhamayginga matha kedha payb tawsan mabaygal nanga aydu poeybaydhin. Thana sew aykap gasamayginga. ");
INSERT INTO mwp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kalanu thana wara doegam buwadhoepa thardhadhin, goegath nel Genesareth. Thana na si mangaydhin thana but kunaw urun aymaydhin, ");
INSERT INTO mwp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","thana na kadaypa tadir nanga, sew goegathaw mabaygan nuyn ngurpadhin kedha, ‘A, in Yesu.’ ");
INSERT INTO mwp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kalanu thana mura gurguy zilmemidhin yadu thuraypa kidhakidhan. Mura na goegathiya ya zilmaydhin nanga, thana mura thonara ngapa garwoeydhamoeypu nubepa kikiril mabaygal doey nidhaypa mamayidhin. Thana angemidhin uthuy lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesun mab ngalagiya thana kikiril mabaygal sepa thonarpa agay, nuy mi goegathiya woelmay a mi apaw lagiya woelmay, mabaygaw garsar ngalaga nanga, thanamun goegathiya dhadhiya thana sepa thonarpa mina agay. Thana nubepa siyara apa pudhemir a yoewdhemir kedha, ‘Thana gar kay, nginu kasa kay nanga dhoemawak gamu thoeraypa? Thana kay gar mura balbayg asimoeypa.’ Setha ngaya nanga mura kikirilgal nanga thana nungu dhoemawak nanga gamu tharal gethan, thana matha gethiya balbayg asimoeyr, mura thanamun kikiringu yaynanob. ");
INSERT INTO mwp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wara thonara dhuray yoewthaw koey mabaygal, Parasayalgal a sabiw ngurpay mabaygal ngapa Yesulpa ladhudhin. Thana wara koey mudhaw lagoengu, Yoerusalemoengu. ");
INSERT INTO mwp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Thana imadhin kedha dhuray nungu niyay kazil getha garwalgayginga ay purthay thonara kedha lawnga kedha Parasayalgaw kulba pawa midh nanga gethoepa garwalgaypa. ");
INSERT INTO mwp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parasayalgal a mura Yoewdhayalgal thanamulpa kasa matha aygudoepa lawnga getha garwalgayginga, thana kay ngaru kulay gethal garwalgemipa thanamun thathiw thathiw ngurpan midh nanga parunguz ngapa. ");
INSERT INTO mwp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Thana na nanga ayde gasamoeyn, ayngu sakariya lagoengu thana ngaru kulay garwalgane, kasa matha purthayginga, a matha kedha koey garsar dhuray thanamun igililmay pawal thana gasamoeydhin thanamun thathiw thathingu; panikinaw a abuwasagidhaw, a komal ngukiw zapul. ");
INSERT INTO mwp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kalanu thana Parasayalgal a sabiw ngurpay mabaygal Yesulpa yapupoeybemidhin kedha, ‘Nginu niyay kazil mingu ngoeymudh kulay igililmaydh zageth mabaginga, thana kasa getha garwalgayginga aygudoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kuniya kedha mulaydhin thanamulpa, ‘Ngitha kasa mamuy goengawl gimiya oengemipu. Senabi kulba peropeth Isaya, nuydh ngitha yadu mayparuy, nungu Minar Poelayzinga kedha, “Sethabi mabaygal ngoena thawmanin thanamun gudan, kasa kay kedha ngoenakap koeysigal. ");
INSERT INTO mwp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Thanamun thawmay wara mina aykapuginga, thana kasa gub sagul poelaypa thawmaythu, a thanamun mina ngurpay kasa koew apa goewaw mabagaw aymayzimayl, Awgadhaw aymayzimayl lawnga.” ");
INSERT INTO mwp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","‘Wa, ngitha kasa mabaygaw aymayzimayl kulay thayamoeydhin, a Awgadhaw aymayzimayl sabil kay ngitha mayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nuy matha umay kedha thanamulpa, ‘Ngithamulpa kedha, ngitha mina koey ngulaygal Awgadhaw sabi midh nanga, kasa kay kedha ngitha Awgadhaw sabi pasinu wanan a ngithamun geth aymayzi sabiw yangukudul kay gima thoeridhoemoeypa, a yakaman mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Awgadhaw wara sabi Moselpa maynguzinga kedha, “Ngidh nginu apu thathipa ngaru apa pudhepa, ngidh nginu apu lawnga nginu thathi mulamoeyn nanga, sabiw mabaygan ngin bangal umapa wayane.” ");
INSERT INTO mwp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","‘Mina pawa kedha, mabayg sike kapu rugalayg, nuydh ngaru nungu apu thathi sib wanampa, kasa kay kedha ngithamun geth pawa mina wardh; ngitha ngulaygal ngoelkay ya woedhay ayimpa Awgadhoepa kedha, “Ngath wagel bangal mura itha thabi rugal Awgadhoepa mamayine.” ");
INSERT INTO mwp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A kalanu ngitha ngulayg nuyn senawbi mabayg lawnga manin nungu apu thathipa zangu aymoeyle, kuyk nuydh ayman ina korbaniw yangukudu kedha, “Itha maygi rugal, Awgadhoepa adhapa thamayzimayl.” ");
INSERT INTO mwp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ngitha kedha zoengu Awgadhaw sabi adhapa idimoeypa a ngithamun thathiw thathiw aymayzi sabi kay ngitha ayimpa; ngitha mura thonara kedha memayirngu.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kalanu Yesu mura mabaygal lak nubepa thuraydhin a kedha mulaydhin thanamulpa, ‘Kurusipagemiw ngayapa a gasamaw kaykedh, ");
INSERT INTO mwp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wara gegeyadhoeginga mabaygaw gudiya adhaz za muya uthiz nubepa kusikus poelaypa; kasa kay kedha setha nanga mi zapul nanga mabaygoengu adhapuydhepa ngulayg nuyn kusikus palan, matha kedha nungu ngoenakap wakay thoemamayl, a yangukudul a zagethal.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kalanu nuy sizi uzaraydhin a lagiya muya uthaydhin; nuydh mabaygal si adhal wanaydhin. Lagoenu muynu nanga nungu niyay kazil nubepa yapu poeybemidhin kedha, senabi adhamintiday yangukudu nungu. ");
INSERT INTO mwp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kedha mulaydhin thanamulpa, ‘Ngitha mipa matha tidayginga, matha kedha mura mabaygal midh? Mabaygaw gudiya nanga mi zapul muya uthemipa adhaz nuyn mabayg kusikus poelayginga; ");
INSERT INTO mwp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","minguz kedha, thana nungu ngoenakap muynu gasamoeyginga, thana kasa maythanu muynu lak sizi adhapa mamayin nungu gamungu.’ Yesu na kedha mulaydhin nuydh imaypa yakamar kedha, mura aydel mabaygoepa balbayginga aygudoepa. ");
INSERT INTO mwp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nuy matha umay, ‘Mabaygoengu nanga gudiya ya adhapadhan nanga ngulayg nuyn kusikus palan. ");
INSERT INTO mwp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Minguz kedha, mabaygaw ngoenakapoengu mura wati wakay thamamayl, ngoewakaziw kawaku wati pawa, za puru, a mabaygaw mathamay, ");
INSERT INTO mwp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","wara alay ipiw wati pawa, kunubur, wara mabaygaw mina zapa ubin mepa, ngoelkay yangukudul, nginu geth wati wakay thamamayl, uwanmay, a kaliya thoeray, a gamu dhub yoewruy, a matha kedha wakay thoemamaygi za aymay. ");
INSERT INTO mwp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","‘Wa, itha mura thabi zapul mabaygoengu muyngu adhapuydhepa, wa thana ngulayg mabayg nubi zapun kusikus palan.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kalanu Yesu nungu niyay kazil kaday tharaydhin, a wanaydhin senabi lag. Thana miyaydhin Tayaraw, Saydonaw mabaygaw boeradharoepa. Thana kasa gumi muy uthaydhin lagoepa ngoenapudhaypa, kasa kay kedha mabaygal ngaru ngulayg gasaman. ");
INSERT INTO mwp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wara yoepkaz ngoenu nanga yoepkaz kazi wati mariw malayzinga, nadh ya gasaman, a mina senabi thonar na ngapa Yesulpa a apa pudhaydhin nungu siyara. ");
INSERT INTO mwp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na senabi yoepkaz, Isoereylaw mabayg lawnga, na Goerikaw yoepkaz, a nanu geth lag Siriya Ponesiyanu. Na kasa koeyma yoewdhaydhin Yesulpa kedha, nuydh kay senabi wati mari adhapa woeyaypa nanu kazingu. ");
INSERT INTO mwp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nuy nabepa mulaydhin, ya matha ngoedhagidh aymoedhin kedha, ‘Mamu kulay ay poeyban moegina kazipa, matha ngoedhagidh lawnga ngath thanamun ay apa thayan thoebudh umaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wa, senabi Goerikaw yoepkaz nadh mina sobaginga gasaman, nungu aykap muynu miyay. Na kuniya mulaydhin Yesulpa, ‘Wa, ngi mina yadu umepa, kasa kay kedha, thoebudh umay ngulayg purthan moegina kaziw ayngu burul biregoengu mulupa pudhayzimayl.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu kuniya mulaydhin nabepa kedha, ‘Nginu ya mina matha ngoedhagidh, kuyk nginu senabi ya, nginu yoepkaz kazi ngaru balbayginga; senabi wati marin nuydh muwasin, adhapadhan nanungu. Ngi matha uzar nginu lagoepa kuniya.’ ");
INSERT INTO mwp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wa, na miyaydhin. Nadh nanga lag gasamoedhin, nadh kedha imadhin, moegina kaz balbayginga yoewipa nanu uthuy lagoenu, wati marin nuydh kasa wanadhin nan. ");
INSERT INTO mwp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wa, Yesu a nungu niyay kazil kalanu sizi Tayaroengu, miyaydhin Sidonaw yabuya Galilayaw Malu buwadhoepa; wara goegathaw nel Dekapolis sipa amadhan nabiya muynu ten goegathal. ");
INSERT INTO mwp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Thana malu buwadhoenu ngabunadhin nanga, thana mabaygan nubepa madhin nuy muwamay a nuy dhugi. Thana yoewdhemidhin Yesuniya nubepa dhoey nidhaypa. ");
INSERT INTO mwp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu nuyn thanamulngu moegina pasipa yoelpadhin mabaygoengu, a nungu gethaw dhimur kawra goganu wanemoedhin a nuy mosal adhaydhin nungu dhimuriya, kalanu yagi mabaygaw noeythay wanadhin. ");
INSERT INTO mwp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kalanu nuy kadaypa nagaydhin daparpa a kuniya poeybaydhin a kedha mulaydhin senawbi mabaygoepa thanamudh kedha, ‘Epapatha!’ (Muynu aykap kedha, ‘Gud pudhar!’) ");
INSERT INTO mwp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mina senabi thonara muwamay nungu kawra gud pudhaydhin, nuydh karngemidhin mabaygaw ya a nuy yangukuduya ya mulaydhin mina thepadhanga ");
INSERT INTO mwp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu thanamulpa kedha mulaydhin, ‘Wara bangal mabaygoepa mulayg.’ Kasa kay kedha thana ngaru sethabi ya umamoeyr. Kalanu Yesu lak wadharngu thana kasa kay kedha senabi ya mina mura zilmaydhin. ");
INSERT INTO mwp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mabaygaw mina koeyma maril zizimoeydhin a madhu pamemidhin kedha, ‘Nuydh kasa mura zapul mina balbayginga aymoeypa. Imaw nuydh muwamay kawral dhoey nidhamoeypa a matha kedha dhugi dhoey nidhepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Soeyzi pawpa thawpaynga lak koeygarsar mabaygal ngapa Yesulpa. Kalanu thana aypa thawpay asimoeyn. Yesu nuydh nungu niyay kazil thurimoeydhin a thanamulpa kedha mulaydhin, ");
INSERT INTO mwp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Ngaw kasa koerkak badh mizin mura thabi mabaygoepa. Thana matha ngaybiya puzimoeypu thoeri goeygipa, a thana mina aygudagasin. ");
INSERT INTO mwp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngaw ubiginga kedha thana kasa kuniya wayamoeyn maytha aygimayl, thanamulngu bibirigoesile maboenu dhadhal.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Thana niyay kazil kedha, ‘Ina mina mabaygoegi lag, ngalpa ngalagaz ay gasampa kedha koeygarsar mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu yapupoeybaydhin kedha, ‘Ngithamuniya midh mura kunaw susul?’ Thana kuniya mulemidhin, ‘Matha seben.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kalanu nuy mura mabaygoepa mulaydhin kedha, ‘Ngitha sew apa thayaw boeradharoenu.’ Kalanu Yesu kusumadhin sethabi kunaw susul, kalanu eso poeybaydhin. Nuydh kunaw susul kope tidamoeyn a nungu niyay kazipa kusuman a thanamulpa mabaygoepa poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Thanamuniya lak moenarimayl wapil, Yesu lak thana yoewdhamoeydhin, wagel niyay kazipa mamayidhin, thanamulpa poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mabaygan mura purthadhin, a balbayg asidhin, 4,000 mabaygal mura. ");
INSERT INTO mwp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kalanu thana niyay kazil wanayzi aydel garpathamoeydhin seben lidhay mura guda poelamal. Nuydh Yesu thana wayaydhin mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kalanu nuy butanu pathaydhin kalmel niyay kazil nungu. Thana memayidhin wara goegathaw lag nel Dalmanutha. ");
INSERT INTO mwp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wara thonara dhuray koey mabaygal, Parasayalgal ngapa Yesulpa ya pathukamoeypa. Thanamun ubi kedha thana nuyn karum palan, nuthay ayimpa nubepa. Thana nubepa kedha, ‘Ngidh ngoeymulpa nginu poerapar yakamar, imaypa kedha ngi Awgadhaw purkapa balbayginga?’ ");
INSERT INTO mwp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu ridh koewba asidhin thanamulngu kedha, ‘Minguz kayibaw mabaygal mura thonara adhapudhay zageth purkaw imaypa umamoeypa? Lawnga ngay ngithamulpa kedha, kedha ngoedhal za ngithamulpa purkaw imaypa lawnga!’ ");
INSERT INTO mwp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kalanu nuydh waniz thana, nuy lak butoepa kuniya tidiz, a thardhan wara doegam buwadhoepa, senabi maluya. ");
INSERT INTO mwp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Thana niyay kazin matha ngoedhagidh thoewaw ayde mayginga, matha urapun thana madhin thanamuniya kalmel butoepa. ");
INSERT INTO mwp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu nanga thanamulpa mulaydhin kedha, ‘Ngitha koey poeypiyam bangal thanamun Parasayalgaw gamu dhuba yoewruyle, a thanamun kuyk Erodh.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Thana niyay kazil thana thanamulngu umamoeyr kedha, ‘Nuy kedha zoengu bredaw ya muliz, ngalpa bred mayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Yesulpa kakal kedha thana mi ya na umamoeypa. Nuy thanamulpa kedha mulaydhin, ‘Ngitha midh paru bredaw ya umamoeypa, “Ngalpa bredoegigal.” Ngithamuniya ngulayg mayginga, ruwamayginga, thigil koey sobalmayl. Ngitha purkalgal, midh paru imayginga; ngitha kawralgal, midh paru koerngayginga? Ngitha wakay thayemin a? ");
INSERT INTO mwp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngath nanga mamayidhin a pathidhemoeydhin payb kunaw susul, payb thawsan mabaygoepa, midh wanayzi burul ngapa liday wangamoeydhin, guda palampa?’ Thana nubepa modhabiya kedha mulemidhin, ‘Toewalob lidhay.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A nuy lak yapu poeybaydhin thanamulpa kedha, ‘Ngath nanga pathidhemoeydhin seben thoewa ayde, po thawsan mabaygoepa, wanayzi lidhay midh, moegina buru guda poelamal, thadha wanayzimayl, ngitha midh mamayidhin?’ Thana kedha, ‘Seben.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu lak mulaydhin thanamulpa, ‘A ngitha midh, matha imayginga a tidayginga?’ ");
INSERT INTO mwp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Thana ngapa wara goegathoepa Bethsayda, wara mabaygal nubepa madhin maygum, a Yesulpa yoewdhadhin lak nuy nidhiz nubiya. ");
INSERT INTO mwp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu nuydh nuyn maygum gethiya yoelpadhin mudhaw lagoengu adhapa; kalanu nungu purkanu mos woeydhadhin, kalanu Yesu geth gimal wanadhin a yapu poeybadhin nuyn, ‘Ngidh zapul imiz a?’ ");
INSERT INTO mwp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nuy maygum kadaypa nagiz a kedha muliz, ‘Wa, ngay nagiz kasa moegina imiz, mabaygal ngoedhe puyl nge toedipa.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu lak geth wanan maygumaw purkanu. Nuydh mayguman koeyma nuthadhin noegaypa senabi thonara nuydh mina kuniya gasaman nungu purkaw zuru; nuydh iman mura zapul koey pudumayl. ");
INSERT INTO mwp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu nuyn kuniya wayan lagoepa, a kedha muliz, ‘Ngi goegathoepa kay mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kalanu Yesu a nungu mura niyay kazil memayidhin wara goegathoepa nel Sizariya Pilipiya. Dhadhal nuy thanamulpa yapu poeybaydhin kedha, ‘Ngayapa mulemiw, mabaygal midh umamoeyrngu kedha, ngay nga?’ ");
INSERT INTO mwp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Thana nubepa kedha mulemidhin, ‘Mabaygal kedha, ngi umangu lak igililnga. Wara mabaygal kedha, ngi Yoewane Papthayso, a wara kedha, ngi Elayza, a wara kedha ngi wara kulkubaw peropetha.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nuy lak yapu poeybaydhin nungu niyay kazipa kedha, ‘Ngithamun wakay thoemamay midh, ngay nga?’ Petheru kuniya nubepa kedha mulaydhin, ‘Ngi mina Keriso, ngapa Woeyayzi Mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kalanu nuydh thana koey dharadh gud wadhamoeydhin mabaygoepa mulayle kedha nuy nga nanga. ");
INSERT INTO mwp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kalanu Yesu kuyk aymoedhin ngurpan nungu niyay kazipa kedha, ‘Mabaygaw Kazin bangal ngaru gegeyadh gasamoene mura zoengu a thana yoewthaw kuyku mabaygal bangal ngoena adhapa yawaypu. A matha kedha kuyku misnarel a sabiw ngurpay mabaygal, thana bangal ngoena uma mathamoene. Thoeri goeygi koeliya ngay bangal kaday tharedhe igilpa.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa, Yesu na mura kakal aymoedhin nungu kuthaw thonara. Petheru nuyn moegina adhapa yoelpadhin sizi kalanu mulaydhin kedha, ‘Kuykulnga, kedha gar maygi, ngibepa umapa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kasa kay kedha nuy nanga Yesu kuniya nagaydhin nungu niyay kazipa. Nuy Petherulpa kedha mulaydhin, ‘Ngaybiya kaliya thayay, ngi ngoedhe Sathana, ngidh Awgadhaw doegamuya zapul aymayginga, ngi kasa mabaygaw ubil zapul aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nuydh kalanu mura mabaygal thuraydhin a nungu niyay kazil, kedha mulaydhin thanamulpa mura, ‘Mabayg nga nanga nungu ubi nuydh ngaybiya asin, wa yakanuriz nungu ubilnga a ngaybiya asir ngaw mab ngalagiya nanga. Ngitha bangal imane koey mangal puy, sathawro ngaw thabaynu. Kedha midh mura ngaybiya asin, ngidh ngaru nginu sathawro manin mura goeygiya, ngath midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","‘Setha ngaya nanga thanamun ubi kedha thana thanamun igililnga danal poethaypa, thana kasa guythuyamoeyne bangal thanamun igililnga. Ngadh nanga nungu igililnga kasa guythuyan kuyk nungu danal poethay ngayapa, nuy kedha mabaygan ngaru gasamoene bangal nungu igililnga. ");
INSERT INTO mwp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Matha ngoedhagidh midh, mabaygan sike mura nabi apaw goewaw kapu rugal gasamoeyne, kasa kay kedha nuydh nungu mina igililnga guythuyaypa. Lawnga sena gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Zaginga wara nubepa maypa nungu mina igililnga kuniya gasamoeypa. ");
INSERT INTO mwp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","‘Nga nanga aziran mepa ngawngu a ngaw yangukudungu, wa Mabaygaw Kazi ngaru senawbi mabaygoengu aziran bangal memayine, ngaw kuniya mangay nanga wagel. Koey poeraparal thonara, ngaw koey poerapar a matha kedha Ngaw Thathingu poerapar, a nungu maygi angelal kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu matha umepu thanamulpa kedha, ‘Yakanurayg, dhuray mabaygal itha, thanamulpa umapa lawnga, kurusipa thana Awgadhaw Basalaya thanamun purkan imane, a nanu mina bibir.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siks goeygiw koeliya nanga Yesu nungu gamu puziw mabaygal yoelpamoeydhin Petheru, Zemes, a Yoewane. Thana yoelpaydhin kadaypa koey padoepa. Thana si thanamun kusaygal. Thana nanga Yesulpa nagemir thana imadhin Yesun gamu sakariya thoeyay wara ngadh asidhin. ");
INSERT INTO mwp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nungu gamu rugal lak kedha goerab gamul koethilmayl aymoeydhin, wara mabaygan kedha gamupa dhoemawak garwalgayginga nubi apa goewanu. ");
INSERT INTO mwp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Thana niyay kazil mura imadhin kedha, wara ukasar mabayg Yesuniya ya soegul siyamar, Mose a Elayza. ");
INSERT INTO mwp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Senawbi thonara Petheru Yesulpa kedha mulaydhin, ‘Ngi waza ngoeymun Ngurpay Mabayg. Itha mina balbayginga ngalpa itha, ngoey sike ngithamulpa yaynanob thoeri iradh lagal aymoeypa, ngibepa, Moselpa, a Elayzalpa.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wa, nungu Petheru a ukasar nungu igalayg thanamun aka mina koeyza, nuy koerawayg kedha nuy kay mi yangukuduya balbayginga ya mulepa. ");
INSERT INTO mwp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kalanu koey iradhal ziya thanamuniya gimal pudhaydhin. Sizi ziyangu thana yangu wakay gasamadhin kedha, ‘In ngaw geth mina mamal garkaz kazi, kurusipagemiw nubepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ziyaw kalanu nanga thana nagemidhin sobaginga imadhin matha Yesun, wara mabaygoeginga pasinu. ");
INSERT INTO mwp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Thana na padiya mulupa tadir nanga Yesu mina koeyma mulaydhin thanamulpa kedha, ‘Wara bangal mabaygoepa mina sogum mulayg, ngitha miza nanga imanu, kurusipa bangal Mabaygaw Kazi umangu kaday tharedhe.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Thana nubepa karngemidhin, kasa kay kedha thana matha thanamuniya muynu nungu yangukudu pudhamoeyr kedha, ‘Ina na “umangu kaday tharay yangukudu” aykap muynu miyay?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Thana Yesulpa yapu poeybemidhin kedha, ‘Kuykulnga, ngoey imadhin gimal padoenu Elayza ngibiya kalmel. Thana sabiw ngurpay mabaygal midh paru kedha ngurpan aymarngu, Elayza bangal ngapa kuniya tidhedhe, nungu kalanu Awgadhaw Woeyayzi Mabayg kakal yakamiz mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kuniya mulaydhin thanamulpa, ‘Wa mina, senabi kulba peropeth Elayza, nuy ngaru ngapa kulay, mura zapul balbayginga lak ayman. Kedha nanga, Maygi Thusin midh paru ngalpan ngurpan kedha, “Mabaygaw Kazi ngaru kikir koeyma gasaman ngalpalpa, a mabaygan nuyn adhathoeyaypu.” ");
INSERT INTO mwp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngay ngithamulpa kedha muliz, Elayza muwasidhin nuy kuniya tidaydhin ngapa, a thana matha kedha nubepa gegeyadh danal pathadhin nuyn. Thana thanamun ubinu zapul matha aymoeypu, matha kedha mina poelayzinga midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu a nungu thoeri niyay kazil nanga mangemidhin nungu wara niyay kaziya, mabayg mina koeygarsar thanamuniya. Dhuray sabiw ngurpay mabaygal ya pathowkamoeyr niyay kaziya. ");
INSERT INTO mwp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Thana nanga mabaygan Yesun iman thana madhu pamemin, a tari zilmemin nubepa, a ayawal manin nuyn. ");
INSERT INTO mwp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu yapu poeybaydhin nungu niyay kazipa kedha, ‘Ngitha miyaw ya pathridhamoeypa thanamuniya?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Urapun mabayg sizi mabaygaw miyayngu kuniya muliz, ‘Ngurpay Mabayg, ngath ngaw kazi ngapa manu ngibepa, kuyk nubiya muynu wati mari a nuy dhugi. ");
INSERT INTO mwp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Midh thonara nanga wati marin nuyn gasaman, nuyn mulupa thayan boeradharoepa, a nubiya sik adhapadhan gudiya, a dhang tikitik nudheman, a nungu mura gamu puridhar asin. Ngay ngingu niyay kazipa mulaydhin wati maripa adhapa moeypa, kasa kay kedha thana yan.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kuniya mulaydhin, ‘Ngitha nubi maykuyk, ngitha mina wara pawalgal, ngithamun mina yoepathaman gegeyadh, ngay in mi kuykuthalnga kalmel. Ngaw gamu koewba asin ngithamulngu, mariw kay sena moegina garkaz ngapa ngayapa!’ ");
INSERT INTO mwp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wa, thana nuyn ngapa madhin Yesulpa. Sobaginga wati marin Yesun iman, nuydh gegeyadh manin moegina garkaz, boeradharoepa mulupa thayan a boeradhariya paw tharipa sik gudanu. ");
INSERT INTO mwp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu yapu poeybaydhin senabi moegina kaziw thathipa, ‘Mi kuykuthalnga nuy kedha?’ Nuy thathi kuniya mulaydhin kedha, ‘Mapethoengu kuyk aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Koey garsar thonaralnga wati marin nuthayngu nubepa uma mathamoeypa, muypa thoeyaypa, a wara thonara woerpa thoeyaypa nubepa uma mathamoeypa. Ngidh gar koerkak badh gasaman ngalbelpa a ibupuydhaypa. Ngi nanga ngulayg, ngidh gar aymar.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wa, Yesu kuniya mulaydhin, ‘Ngi mipa kedha ngayapa, “Ngi nanga ngulayg”, ngidh koersar wakay thoemamipa, lawnga midh? Wara zagethoeginga, ngidh nanga mina yoepathaman, na za sobaginga aymiz.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Moegina kaziw thathi nuy gar koeyma muliz, ‘Ngaw mina yoepathaman mepa, kasa kay kedha moegina, ngidh gar ngoena ridh palan a koesimar ngaw mina yoepathaman?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu imadhin kedha, palay moegina buthag asimoeyn zagethoepa, mabaygan amadhan palamulpa. Nuy kedha mulaydhin wati maripa, ‘Ngi wati mari dhugidh a muwamay, ngay ngibepa muliz, ngi adhapa soeyzi moegina garkazingu. Lak bangal nubepa kuniya tidayg!’ ");
INSERT INTO mwp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wati mari ar pugiz, a kasa thayan nuyn garkaz mina gegeyadh, nungu gamu mura puridhar asin, a nuy mari adhapadhadhin nungungu. Kalanu moegina kaziw gamu koeyma sin thayadhin, ngoedhe uma gamu nge. Thana mura mabaygal kedha, ‘Senaw nuy umanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kasa kay kedha Yesu nubiya gethanu nidhaydhin a ibu puydhadhin nuyn a kaday tharadhin. Kalanu moegina garkaz balbayginga taraydhin. ");
INSERT INTO mwp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wa, Yesu muy yoewthaydhin lagiya, a kalmel nungu niyay kazil. Thana muynu nubepa kedha yapu poeybemidhin, ‘Midh paru ngoey wati mari adhapa mayginga, ngoey koeyma nuthemidhin?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kuniya mulaydhin thanamulpa kedha, ‘Matha thoeythu poegay balbayginga kedha wati maripa adhapa maypa, wara za lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu a nungu niyay kazil kalanu thana sizi ladhudhin Galilayaw yabuya, kasa kay kedha thana koey yabuya lawnga, Yesun ubiginga mabaygoepa ngulayg oesipa kedha nuy ngalaga nanga. ");
INSERT INTO mwp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kedha zoenguz kedha, sena waza nungu ngurpay thonar nungu niyay kazipa kedha, ‘Mabaygaw Kazi bangal wati mabaygoepa manine, thana bangal nuyn uma mathamoene. Kasa kay kedha thoeri goeyga koeliya nuy bangal kaday tharedhe igililmaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Thana tidayginga, gasamayginga nungu ngurpay aykap a thana aka gasamar nubepa kuniya yapu poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Thana nanga Kapeniyamoenu mangemidhin, thana kalanu muya uthemidhin lagiya. Si muynu Yesu yapu poeybaydhin nungu niyay kazipa kedha, ‘Ngitha mi moegithap ya umamoeydha ngalpa nanga ngapa tadidha?’ ");
INSERT INTO mwp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kasa kay kedha thana nubepa kuniya ya mulayginga; minguz kedha thana ya pathowkamoeyr yabugudoenu dhadhal kedha, ‘Ngalpalngu nga lak mina koey gimal.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu thana thuraydhin nungu toewalob niyay kazil, a kedha mulaydhin thanamulpa, ‘Ngithamulngu nga nanga kulay thoeyaypa ubin mepa, nuy ngaru mura mabaygiya wagel, a kasa mabaygoepa nuy ngaru ibupuydhay mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kalanu nuydh moegina kaz madhin a thanamuniya parunu kaday tharaydhin. Kalanu Yesu nuyn gamupa gasamoedhin a kedha mulaydhin thanamulpa, ");
INSERT INTO mwp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Mabaygan ngadh nanga ngaw nel tharan moegina kazipa ayawal maypa, nuydh matha kedha ngoena ayawal manin, a muynu nanga matha ngoena lawnga ayawal manin, nuydh urapun mayn ayawal manin ngoena ngadh nanga ngapa wayadhin.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoewane kalanu Yesulpa kedha muliz, ‘Ngurpay Mabayg, ngoey mabayg imanu, nuydh nginu nel thoeraypu wati maripa adhapa maypa mabaygoengu, a ngoey kay nuyn lawnga manu, minguz kedha nuy ngalpan thamu mabayg lawnga, ngalpaniya puziginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kasa kay kedha Yesu kedha mulaydhin thanamulpa, ‘Ngitha nuyn lawnga maygi. Mi mabaygan nanga ngaw nel tharan adhapudhay zagethoepa aymoeypa, nubepa koey zageth ngayapa adhiya thoeraypa lak sizi. ");
INSERT INTO mwp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mabayg nanga nga ngalpalpa wati igalayg lawnga nanga nuy ngaru ngalpan mabayg. ");
INSERT INTO mwp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","‘Ngay ngithamulpa mina ya mulepa, mabaygan ngadh nanga ngibepa woeniw nguki poeyban, kuyk ngi Kerison mabayg, nuydh bangal ngaru nungu modhabiya gasamoene, kuyk nuydh ngaw nel kadaypa manin ngaw ubilnga ayman ngaw mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wara ina kedha, ngadh nanga moegina kazi adhapa ruwaman ngawngu, a mathaman nungu moegina kaziw mina yoepathaman, nubepa senawbi mabaygoepa balbayginga nay, koey kula muduloenu yatharan kalanu nuyn malupa thayan. Nungu mabaygaw kuth ngaru gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nginu gethan nanga wati pawa ayman, ngidh nan sobaginga adhapa manin ngoedhe kedha ngidh nginu geth midh nanga adhapa pathan. Ngibepa matha ngoedhagidh midh kedha, nginu mura gamu senawbi koey muypa thayan, lawnga midh ngidh guythuyan urapun thugal nginu gamungu a ngi gethagi mabayg muya uthiz mina igililmaynu a? Senabi muy ngaru woesimoeyginga. ");
INSERT INTO mwp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nginu ngar lak kedha wati pawal boeradharoenu tariz nanga, ngidh nan sobaginga adhapa manin ngoedhe kedha ngidh nginu ngar midh nanga adhapa pathan. Ngibepa matha ngoedhagidh kedha, ngi kasa muwayzinga muya uthiz mina igililmaynu, nginu ukasar ngaroepa mamu muypa thoeyaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","‘A matha kedha nginu purkaw noegaypa nanga ngin wati wakay thoemamaypa manin, sobaginga adhapa nagiz ngoedhe kedha ngidh midh nan dan nalban nginu purka. Matha ngoedhagidh kedha ngi urapun purkalnga mina igililmaynu muya uthiz, nginu ukasar purkapa mamu koey muypa thoeyaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Senaw ngalaga nanga wati za kuper umaginga koey garsar a koey muy ngalaga nanga woesimayginga siyaypa. ");
INSERT INTO mwp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Matha koerngaygi mabaygal lawnga. Wati thonar na gasaman akalnga ngoedhe muy nge gamu woedhan, nan yoeluthan, ridh palan gamu. Nuy gud ayman wara wati zoengu. In mina za igililmaypa gud ayman adhabadh midh madhu pinin ridh palan, kuykuthal ay. ");
INSERT INTO mwp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na sol mina za, kasa kay kedha nadh na nanu mith guythuyan na wati za aymiz, aydu kuykuthalnga mayginga, na mithagasin. A mina igililnga na ngaru mina mithalnga muynu ngalpaniya, gabu pawa nipa kidhakidhan.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu miyaydhin sizi wara lagoepa, yoewdhayapa. Thana Yuridhaw Koesaya dhadhiya pudhemidhin woeraw doegapa, a mabaygal lak kedha koeygarsar ngapa nubepa garwoeydhamoeydhin. Nuydh thana lak ngurpamoeydhin nungu pawa midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dhuray Parasayalgal sethabi thonara ngapa nubepa nuthaypa, thana kedha yapu poeybemidhin, ‘Ngalpan sabiw yawoeydhayzinga midh, garkazipa matha ngoedhagidh nungu ipipa adhapa woeyaypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu lak kedha yapu poeybaydhin kuniya thanamulpa, ‘Mosen yawoedhayzi yangukudu ngithamulpa midh?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Thana kedha, ‘Mose kudu madhin garkazipa nungu dhadh poelamay yangukudupa thusinu poelaypa a nabepa kuniya woeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu thanamulpa kedha mulaydhin, ‘Wa, Mose kedha zoenguz ngithamulpa kedha sabi paladhin, kuyk ngithamun koerngayginga koeyza. ");
INSERT INTO mwp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kasa kay kedha, koezi payap ngapa parungu nubi apaw goewaw sama woeydhayzimayngu, Awgadhan garkaz a yoepkaz aymoemoedhin, matha kedha Maygi Thusiw ya midh nanga. ");
INSERT INTO mwp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nuydh kedha zapa aymoemoedhin, garkazin bangal nungu apu thathi wanamoene, a nuy garwoeydhamiz nungu ipiya. ");
INSERT INTO mwp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Palamun ukasar mabaygaw gamu kalanu urapun aymiz, palay lak lawnga ukasar mabayg, palamun mamu ngedh urapun gamu aymiz. ");
INSERT INTO mwp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kedha zoenguz Awgadhan nanga garwoeydhamoemoeman mabayg, mabaygoepa dhadh poelamaypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kalanu Yesu a nungu niyaykazil lak lagiya muya uthemin, thana nubepa yapu poeybemidhin, nungu sethabi ngurpay yoepa. ");
INSERT INTO mwp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nuy thanamulpa kuniya kedha mulaydhin, ‘Mi mabaygan nanga, nungu ipi kasa wanan a wara yoepkaz niyaypa yoelpan, nuydh nabepa adhapudhay wati pawa ayman. ");
INSERT INTO mwp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A nadh nanga nanu alay wanan a wara garkaziya niyaypa yoelapiz, nadh adhapudhay wati pawa ayman.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mabaygan mura thonara thanamun kazil ngapa Yesulpa agepu nubepa kuyku nidhaypa thanamulpa kasa kay kedha, nungu niyay kazil thana lawnga mamayidhin. ");
INSERT INTO mwp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nuydh nanga Yesu imadhin, nuy thabukirin miyaydhin a kedha mulaydhin niyay kazipa, ‘Ngitha lawnga maygi sethabi moegina kazil, kasa wanamay thana ngapa ngayapa. Minguz kedha, Awgadhaw Basalaya kedha ngoedhal moegina kazipa, buth pathayzinga, thanamulpa niyay lag. ");
INSERT INTO mwp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","‘Ngay ngithamulpa mina ya mulepa, ngunu nanga ubi Awgadhaw Basalayapa muy uthaypa, nuy ngaru kedha aymiz ngoedhe moegina kaz midh nanga. Nuydh nanga kedha ngoedhalnga aymayginga nanga, nubepa Awgadhaw Basalayoepa gasamoeypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kalanu nuydh thana thoeridhoemoeydhin nungu gethan a geth gimal kabuthan thanamuniya, a kuyku nidhamoeyr thana. ");
INSERT INTO mwp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu na mab sizi lak kuykaymadhin nanga, urapun garkaz nubiya parunu kulun pasoeynaydhin a kedha yapu poeybaydhin, ‘Mina Ngurpay Mabayg, ngath bangal mi mina zageth aymoene, ngayapa mina igililmaypa gasamoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kedha kuniya mulaydhin nubepa, ‘Ngidh midh paru ngoena mina Ngurpay Mabayg tharan? Wara mina mabaygoeginga matha Awgadh kedha. ");
INSERT INTO mwp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ngi sabi yawoedhayzimayngu ngulayg a? Mabayg uma mathamayg, wara mabaygaw ipiya a alaya puru aymayg, mabaygaw za purunu woerdhayg, mabaygiya ngoelkay ya butha woeydhayg, mabayg dhipa yoewthayg, a ngi ngaru apasin nginu apu thathipa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nuy senawbi mabayg kuniya Yesulpa kedha mulaydhin, ‘Ngurpay Mabayg ngath mura thabi zapul aymoeyrngu ngaw yatha pathayngu thonarngu ngapa kurusipa kayib.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu na nuyn imadhin nuydh nuyn maman madhin. Nuy kedha mulaydhin, ‘Matha urapun za ngidh aymoeyginga. Matha ngoedhagidh kedha ngidh yoewdhamoeyne bangal mura nginu zapul bokadhzapupa; a sethabi bokadhzapul mamayine aygi zagi mabaygoepa. A nginu bangal matha ngoedhagidh gimal daparoenu, kow kalanu ngi asir ngaybiya.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nuydh nanga mabaygan Yesun yangukudu karngemidhin nanga, nungu mura dhodho papudhamoeydhin, kalanu kasa wati ngoedhalnga lagoepa kuniya tidaydhin, minguz kedha nuy koey aydeg zapulayg. ");
INSERT INTO mwp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kalanu Yesu nungu niyay kazipa buwayl thayadhin a kedha mulaydhin, ‘Mabayg nga nanga koey aydeg zapulayg, nubepa moegina zageth lawnga Awgadhaw Basalayapa muy uthaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Thana niyay kazil mina koeyma madhu pamemidhin nungu yangukudungu, kasa kay kedha Yesu thanamulpa lak mulaydhin, ‘Ngaw kazil, sena ngoelkay za lawnga Awgadhaw Basalayapa muya uthaypa! ");
INSERT INTO mwp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngay ngithamulpa kedha mulepa, mabayg nga nanga koey aydeg zapulayg nubepa koey zageth muya uthaypa Awgadhaw Basalayapa, koey uruy kamela midh nanga mina moegina arkathiya muya uthiz, sapur kimusaw kuykuyaya uthaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Thana nungu niyay kazil koeyma madhu pamemidhin a kidhakidhan kedha umamoeyr, ‘Kedha na nanga, mura mabaygoepa sike koey zageth mina igililmaypa gasamaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nuy Yesu thanamulpa balbayginga nagiz a kedha muliz, ‘Wa, mabaygoepa muya yoewthaypa lawnga nungu geth, kasa kay kedha Awgadhoepa mura zapa aymoeypa zagethoeginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petheru nubepa kedha mulaydhin, ‘Ngoey ngoeymun mura zapul wanaydhin, a ngoey ngibiya wagel asimoeydhin, ngoey midh.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nuy Yesu kedha, ‘Wa, ngay ngithamulpa mina ya muliz kedha, mabaygan ngadh nanga, kasa waniz, nungu niyaylag, tukuypal, babthal, a nungu apu thathi, a nungu kazil, a nungu zagethaw boeradhar ngaybiya oesipa a mina yangukudupa oengaypa. ");
INSERT INTO mwp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nuydh bangal ngaru, mura koey gimal gasamoene nabi thonaraw aydu zapunu urapun andred thonaralnga, niyay lagal, tukuypal, babthal, apu thathil, a kazil, a matha kedha zagethaw boeradharal. Kasa kay kedha nuydh bangal lak kedha ipidhadh bangal gegeyadh mina gasampu, a matha kedha wagelaw goeyginu, nuydh ngaru igililnga gasamoene. ");
INSERT INTO mwp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dhuray koey garsar koey kupaylgal nubi apa goewanu nanga, thana bangal mamu ngedh wagel, kalaw igililmaynu. A dhuray nanga kayib apal, thanamun kupay bangal koeyza senabi igililmaynu.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Thana nanga Yoerusalemoepa tadir Yesu matha kulay woelmay thanamuniya. Yesun niyay kazil a mura mabaygal ngaya nanga asimoeydhin thana mina koeyma madhu pamemidhin, kedha nuy senawbi lagoepa koezi, a thana aka gasamoedhin. Yesu lak pasipa thuraydhin nungu niyay kazil, a mulaydhin kedha, ‘Kurusipagemiw, zapul bangal kedha aymoeyne ngayapa. Ngalpa ngaru Yoerusalemoepa a Mabaygaw Kazi bangal gud arane thanamulpa, kuyku misnarepa, a sabiw ngurpay mabaygoepa. Thana bangal ngoena umapa wayane, wara goegathaw mabaygoepa bangal manine. ");
INSERT INTO mwp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Thana bangal ngoena giwn mayparuy, a mosan tidaypu, a poelngipu ngoena a umapa mathamoene, kasa kay kedha thoeri goeygiw koeliya, ngay bangal kadaypa igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wa, Zebadin ukasar garkaz kazi Zemes a Yoewane, palay uzarmoedhin Yesulpa kedha mulemoedhin, ‘Ngurpay Mabayg, ngalben ubi kedha ngidh gar kay ngalben ubilnga aymar?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nuy kedha mulaydhin, ‘Na ngipen ubilnga midh ngayapa ngipelpa aymoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Palay kedha nubepa, ‘Ngi bangal nanga kadaypa ngidh gar ngalbelpa mina niyaylag nginu getha doegamoenu a nginu boedha doegamoenu adhapa thamamoene, nginu basalayoenu?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu palamulpa kedha mulaydhin, ‘Ngipel koerawayg kedha, ngipel mipa umempa. Ngipelpa matha ngoedhagidh kedha ngipel wati ngukin waneman ngay mi wati ngukin wanedhe bangal nanga, a ngipelpa papthayso maypa ngaw bangal wati papthaysomay midh nanga?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Palay kedha mulemoedhin, ‘Wa, ngalbelpa matha ngoedhagidh.’ Yesu palamulpa kedha mulaydhin, ‘Wa, ngipel bangal wanimoene senabi wati ngukin, ngay bangal mi wati ngukin wanedhe nanga, a papthayso mamamoene ngaw papthaysomay midh nanga, ");
INSERT INTO mwp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kasa kay kedha, ngaw getha doegam a boedha doegam niyaypa nanga sena ngaw kupay lawnga aymoeypa sepalbi niyay lag nanga buth pathamoedhin matha palamulpa Ngaw Thathin mabayg ngawal nanga adhapa thamamoedhin sew niyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Thana nanga wara nungu ten niyay kazil karngemidhin, palamun yapu poeybayzi ya midh nanga, thana mura gegeyadh gasamoedhin palamulpa, Zemesaw Yoewanew mulipa. ");
INSERT INTO mwp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu mina mura nungu niyay kazil thuraydhin nubepa, kalanu kedha mulaydhin thanamulpa, ‘Ngitha ngulaygal kedha, setha wara goegathaw mabaygaw pawal midh nanga thanamun koey kupaylgal, thana kasa thanamun geth pawanu nipa, a thanamun koey mabaygal kasa mura thanamun geth pawalgal mura thanamun mabaygiya. ");
INSERT INTO mwp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngitha bangal kedha aymayg, kasa kay kedha ngithamulngu ngunu nanga ubi koey kupaypa gasamoeypa, nuy bangal ngaru apapudhepa a mura mabaygaw zagethaw mabayg aymiz. ");
INSERT INTO mwp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ngunu nanga ngithamulngu kulay thoeyaypa ubi, nuy ngaru ibupuydhay mabayg mura mabaygaw, ngoedhe kedha nge nubepa zagethoepa aymoeygi maypa lawnga. Nuy ngoedhe mapu zagethaw mabayg mura mabaygoepa ");
INSERT INTO mwp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ngoedhe kedha Mabaygaw Kazi midh nanga, ngay ngapa lawnga mabaygoepa ngayapa zagethoepa. Ngay ngapa mabaygoepa zagethoepa, ngaw igililnga kuth thoeraypa thanamulpa gudaz puydhaypa wati pawaw doegamoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Thana nanga si Zerikonu mangemidhin Yesu a nungu niyay kazil a koey garsar mabaygal mabapa nanga lak buth pathemidhin. Wara mabayg maygum nel Bartimayoes, Timayoesan kazi nuy si yabugudaw pasinu nir, aypa zapa ngoena yoewdhaypa mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nuydh nanga karngemidhin kedha, Yesu Nazarethoelayg si, nuydh walmay kuyk ayman kedha, ‘Yesu, ngi adhapudhay mabayg Dhawithan Kazi, ngoena gar sib wanar.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mabaygan nuyn koey dharadh lawnga mar wal maythayle, a kedha umamoeyr, ‘Yagi asir.’ Kasa kay kedha nuy lak sizi koey gimiya wal mer, ‘Dhawithan Kazi, ngoena gar ibupuydhar.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kuniya baltharaydhin a kedha mulaydhin, ‘Ngapa thuraw nuyn.’ Thana nuyn maygum thuradhin. Thana kedha nubepa, ‘Oy! Ngibepa mina yangu wakay, kaday tari nuydh ngin thuran.’ ");
INSERT INTO mwp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nuydh sobaginga nungu koey sodh adhathayan, mamu katpalgidhin, kalanu Yesulpa uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu nubepa kedha yapu poeybaydhin, ‘Midh nginu ubilnga, ngath kay miyay aympa ngibepa?’ Nuy maygum kedha mulaydhin, ‘Ngurpay Mabayg, ngidh gar ngaw purkaw buya balbayg tidamar?’ ");
INSERT INTO mwp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu nubepa kedha mulaydhin, ‘Kaday tari, uzar, nginu mina yoepathaman ngayapa, nginu purka balbayg paliman.’ Mina senabi thonara nuy balbayg asidhin, nuy balbayginga nagaydhin kalanu nuy Yesuniya wagel asidhin yabugudoenu. ");
INSERT INTO mwp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu a mura mabaygal Yoerusalemoepa amadhan aymoeydhin, thana gasamoedhin ukasar moegina goegath nel Bethpayz a Bethoeni. Thana ngapa Olibaw Padoepa amadhan. Yesu kulay wayamoedhin ukasar nungu niyay kazi. ");
INSERT INTO mwp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Palamun zageth yadu palgadhin kedha, ‘Sepa uzarmoeriw mudhaw lag sey parunu, ngipel kay na mangempa ngipel balbayginga imane asinaw kazi, yatharayzinga. Mabayg kulay niyayginga, senabi asinaw kazi. Gud wayaw ngapa ngayapa mariw koepa. ");
INSERT INTO mwp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","‘Mabayg kay na ngipelpa yapu poeybay kedha, “Ngipel mipa manin?” Ngipel kay kedha mulemoeriw nubepa, “Kuykulnga ubin mepa, a lak kay ngapa kuniya maypa sobaginga.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Palay uzarman a iman asinaw kazi yabugudoenu, dhoerdhimoeyzinga lagaw pasa gudoepa. Palay gud idhun nanga, ");
INSERT INTO mwp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dhuray mabaygal pasinu palamulpa kedha mulemin, ‘Ngipel mipa kedha ayman, gud wayan asinaw kazi?’ ");
INSERT INTO mwp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Palamun kuniya ya kedha, Yesu palamulpa midh na mulaydhin, mabaygan palay kasa guythuyamin. ");
INSERT INTO mwp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Palay nan asinaw kazi Yesulpa manin a thanamun koey sodhal gimiya gud palimoeydhin asinaw kaziya, a Yesu thanuraydhin gimal. ");
INSERT INTO mwp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Koey garsar mabaygal thanamun koey sodhal gud palemoeydhin yabugudiya, a wara mabaygal puy thamal tidamoeyr boeradharoengu, a yabugudiya idimar. ");
INSERT INTO mwp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Koey garsar mabaygal nubiya parunu a koeygarsar nubiya kaliya, kedha wal tidumar kuykayman, ‘Ngoey Awgadh koeyma thawmanin, woenab ngi ngapa Kuykulnga. Awgadhaw nel adhapudhay koey gimal, a ngi ngapa nungu kupaynu muynu, a nungu nel. ");
INSERT INTO mwp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Awgadh koeyma thawmaypa, a woenab ngibepa nga ngapa gudaz puydhaypa ngalpan thathiw Dhawithan basalaya, a thawmanin Awgadh. Senabi basalaya ngaru koey ridhanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu nuy muy yuthiz Yoerusalemiya, a nuy muy yoewthaydhin koey yoewthanu, a imaydhin mura nanu zapul muynu. Nuy goeyga koey pawpa, nuy a nungu niyay kazil lak adhapa ladhudhin senabi moegina mudhaw lagoepa, Bethoeni. ");
INSERT INTO mwp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wara goeyga thana kuniya tidemidhin Bethoeningu a Yesun gamu ayginga ");
INSERT INTO mwp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","nuydh wara aypuy imadhin puy nel dhani, koey maludh nisalnga. Nuy imaypa sipa uzaraydhin kedha, nuy aydenga. Nuy na ngapa nuydh iman kedha, matha nisal ayginga. Nungu ayngu thonara lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nuy Yesu mulaydhin dhaniw puypa kedha, ‘Lak war mabaygoepa nginungu purthaypa lawnga.’ Thana niyay kazin nungu ya karngemin. ");
INSERT INTO mwp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Thana nanga mangemidhin Yoerusalemoenu, Yesu uzaraydhin koey yoewthoepa. Nuy koeyma ya poeybaydhin a adhapa wayaydhin setha mabaygal ngaya nanga zapul yoewdhamoeyr yoewthanu muynu. Bokadhzoengu sakariya thoeyay mabagaw biraygil kuykul idimoedhin. A setha ngaya nanga moeginga uruyl yoewdhamoeyr nuydh thanamun apa niyay lagal lak kuykul idimoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A nuy lak ubig asidhin mabaygoengu yoewthaw boeradhariya thawpay pasi luman adhaw zapun gurepa muya yoewthaw boeradhariya. ");
INSERT INTO mwp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kalanu nungu ngurpay ya mabaygoepa kedha, ‘Awgadhaw yangukudu Minar Poelayzinga kedha, “Ngaw koey lag, kedha thoeraypu ngaw thoeythu poegay lag, mura nubi apaw goewaw mabaygoepa”. Kasa kay kedha ngitha ngoedhe puru mabaygal ngoelkay modhabilmayl zapul yoewdhamoeypa maygi lagoenu muynu!’ ");
INSERT INTO mwp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Thana koey misnarel a sabiw ngurpay mabaygal karngemin senabi ya, zapul midh paru nanga, thana lak thabukir gasaman, luman wara doegam Yesulpa mathamoeypa. Thana iman kedha mura mabaygal madhu pamemidhin a asimoeydhin nubiya, thana kedha zoenguz akan nungungu. ");
INSERT INTO mwp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kut dhib asidhin nanga Yesu a nungu niyay kazil, thana senabi goegath wanadhin. ");
INSERT INTO mwp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mina bathaynga wara goeyginu thana tadir yabugudiya, thana iman senawbi dhaniw puy Yesu kulay kuth madhin yadu nubepa, nuy mura umanga sipil kalmel. ");
INSERT INTO mwp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petheru nuy wakay thayadhin Yesu midh na mulaydhin, a nubepa kedha mulaydhin, ‘Ngurpay Mabayg, nagi senawbi aypuy na umanga, senaw mi dhaniw puy ngidh kuth tharadhin.’ ");
INSERT INTO mwp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kuniya mulaydhin thanamulpa, ‘Kedha yakanurayg, ngitha nanga Awgadh mina yoepathaman, ");
INSERT INTO mwp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ngithamulpa zagethoeginga kedha ngidh koey pad mura adhathayan malupa. Ngidh na mina yoepathaman nginu ngoenakapoenu nanga ngoelkay yoepathamayginga, ngidh gasaman mi zapa nanga ngi yoewdhepa. ");
INSERT INTO mwp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","In nabi za kedha, ngay ngithamulpa muliz, ngitha nanga thoeythu pagemin a yoewdhemin ngithamun ubilmaypa, ngidh ngaru mina yoepathaman Awgadh kedha, senabi za ngidh gasaman muynu ngibiya. Wa, kedha nanga ngibepa Awgadhan poeyban, ngi mi ubilmaypa nanga umepa. ");
INSERT INTO mwp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A wara kedha ngithamun thoeythu poegaynu nanga, nginu ngoenakap gegeyadh, kuyk wara mabayg gegeyadh ayman ngibepa, ngidh ngaru guythuyan senabi gegeyadh, mabaygoepa; ngidh na kedha wanan nanga nginu Daparaw Thathin guythuyan mura gegeyadh nginu.’ ");
INSERT INTO mwp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu a nungu niyaykazil lak kuniya tidemidhin Yoerusalemoepa. Nuy nanga koey yoewthiya woelmay, thana koey misnarel, a sabiw ngurpay mabaygal, a thanamun koey mabaygal ngapa nubepa ");
INSERT INTO mwp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a kedha mulemin, ‘Muli ngoeymulpa, ngidh ngalagaz kupay gasamoengu nabi zagethoepa, a ngibepa matha ngoedhagidh ngadh mangu kedha aymoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kuniya mulaydhin thanamulpa, ‘Wa, ngayapa lak kedha matha urapun yapu poeybay ngithamulpa. Ngitha kay ngayapa mulemiw, wa ngayapa lak kedha ngithamulpa mulaypa kedha, ngaw kupay ngalagaz. ");
INSERT INTO mwp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sena nungu Yoewanen Papthayso, nungu papthayso zageth, na ngalagaz ngapa; Yoewanen kupay Awgadhoengu lawnga mabaygoengu?’ ");
INSERT INTO mwp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Thana kidhakidhan ya umamoeyr thanamuniya muynu, ‘Ngalpa kay midh mulemipa. Ngalpa kay na kedha mulemipa, Yoewane nungu kupay Awgadhoengu ngapa, nuy kay kedha mulepa, “Ngitha minguz Yoewanelpa mina yoepathamayginga?” ");
INSERT INTO mwp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wara kedha, ngalpa kedha umamoeypa nanga, “Yoewanen kupay Awgadhoengu lawnga, na kasa mabaygoengu!” ngoeymun aka kedha zoengu, wara mabaygoengu. Mabaygaw mura wakay thoemamay kedha, nuy Yoewane Peropetha.’ ");
INSERT INTO mwp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kurusipa thana kedha mulemidhin nubepa, ‘Ngoey koerawaygal.’ Yesu thanamulpa kuniya mulaydhin, ‘Ngitha yagigal, nungu kupay midh paru? Wa, ngay lak kedha ngath ngaw kupay seysithamayginga ngithamulpa nubi zagethoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kalanu nuy thanamulpa yoewthaw kuyku mabaygoepa ya thonar tidan kedha, ‘Wara thonar apaw lagaw mabayg nuydh goeraypal uthun nagu boeradharoenu. Nuydh pa pagaydhin mura nabiya war war doegamuya. Wara doegamoenu nuydh arkath aymoedhin, goereypal nanga almathamoeyn muynu nanga, ikay sinaki pungaypa. Koey gimal nanga nuydh thuraw lag moeydhadhin mabaygoepa danal poethaypa. Kalanu nuy yoenu madhin senabi apaw lag danal poethay mabaygoepa. Ya woeydhayzinga kedha, ayboewdhaw thonar nanga gasaman, mura ayde dhadhiya mamayin nubepa a thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","‘Ayboewdhaw nanga nuydh nungu zagethaw mabayg wayadhin nungu modhabipa gasamaypa thanamulngu. ");
INSERT INTO mwp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Thana apaw lagaw wati danal poethay mabaygal, nuyn gasamoedhin a palngidhin a kuniya wayadhin, wara nubepa modhabiya mayginga za. ");
INSERT INTO mwp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‘Kalanu nuydh wara wayadhin zagethaw mabayg, kasa thana apaw lagaw danal poethay mabaygal nuyn kuykuya mathamoedhin, a gegeyadh nuyn madhin aziralnga. ");
INSERT INTO mwp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nuydh kuykun lak wara wayadhin, a thana nuyn uma mathamoedhin. Koeygarsar ngapa kalanu thana kedha wati pawa ayman, palngimoeyr, a dhuray thana uma mathamoeyr. ");
INSERT INTO mwp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Kurusipa wara mabaygoeginga, matha urapun wanadhin kuyku mabaygaw garkaz kazi, nungu mamal kazi; nuydh nuyn wayan. Nuy nubiya muynu kedha, “Thana ngaru apasin ngaw kazipa.” ");
INSERT INTO mwp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‘Kasa kay kedha thana apaw lagaw danal poethay mabaygal kidhakidhan ya mulemin kedha, “In kuyku mabaygaw kazi, ngalpa mathampa nuyn, lak bangal nungu aykuyk mura ngalpa manine, lak bangal nungu mura zapul ngalpan zapul.” ");
INSERT INTO mwp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lak thana nuyn gasamoedhin, uma mathamoedhin, a adhathayadhin nungu gamu apaw lagoenu.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kalanu Yesu sethabi kuyku mabaygoepa yapu poeybaydhin kedha, ‘Ngithamulpa midh, matha ngoedhagidh a? Nuy apaw lagaw kuyk ngaru ngapa thanamulpa uma mathamoeypa, wati mabaygoepa, a poeyban apaw lag wara nagu mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ngitha ngaru ngulaygal Maygi Thusingu nabi Minar Poelayzinga, adhamintiday ya kedha, “Lagaw moeydhayzi mabaygal nanga thana mina kula adhathayan, wati kulapa thaman. Kasa kay kedha na mina kula, nan ngulayg lagaw konanu kabuthan puridhiroepa. ");
INSERT INTO mwp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ina ngalpan kuykulmay aymayzinga zageth Ngalpan imaypa mina adhapudhay.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Thana Yoewdhayalgaw kuyku mabaygal ubin memayidhin Yesulpa kunumaypa, kuyk thana gasamoedhin kedha nuy thanamulpa kuniya yadu umay, kasa kay kedha thana mura mabaygoengu akan, mabayg koeygarsar. Kalanu thana nuyn wanadhin, a ladhudhin adhapa. ");
INSERT INTO mwp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kalanu thana mabaygal wayamoeydhin dhuray Parasayalgal a dhuray Erodhan mabaygal. Erodh nuy thanamun kuyk sabi doegam. Thana ngapa Yesulpa ya nuraypa a gasamoeypa nubepa. ");
INSERT INTO mwp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Thana ngapa a kedha mulemin, ‘Koey Ngurpay Mabayg, ngoey ngulaygal kedha ngi mina balbayginga yadu umepa mura mabaygoepa. Ngidh kasa wakay thoemamayginga Awgadhaw ngurpay yadu umepa kasa midh, mabayg kupay mabayg a mabayg kasa mabayg. Wa, nungu Romaniw kuyku mabaygaw ya woedhayzinga kedha, mabayg ngaru nubepa bokadhza thoeyaypa.’ Thana nubepa lak mulaydhin kedha, ‘Muli ngoeymulpa, ngalpan sabinu matha ngoedhagidh midh ngalpalpa kasa bokadhzapul sakariya thayan Romaniw mopakuyku mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nuydh Yesu iman thanamun ya nuray, nuy kedha muliz thanamulpa, ‘Ngitha mingu ngayapa ya nuraypa? Ngapa mar silba bokadhza, a ngath imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Thana nubepa urapun manin, a nuy yapu poeybiz, ‘Ina ngoenu paru a nel bokadhzapunu poelayzinga?’ Thana kedha, ‘Romaniw kuyku mabaygaw.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu kuniya muliz, ‘Setha mi zapul nanga, nungu Romaniw kuyku mabaygaw zapul, ngalpa nubepa mamayipa; a setha mi zapul nanga Awgadhaw zapul, ngalpa nubepa mamayipa.’ Thana nanga karngemidhin, thana mina koeyma madhu pamemidhin Yesun yangukudungu. ");
INSERT INTO mwp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wagel nge thana Sadusayalgal ngapa Yesulpa. Thana lak kedha yoewthaw koey mabaygal, thanamun mina yoepathaman kedha, mabayg umangu kaday tharaypa lawnga, kuthaw thonara. ");
INSERT INTO mwp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Thana mulemidhin nubepa, ‘Ngurpay Mabayg, Mosen ngurpay kedha, ipilayg mabayg nanga umanga, nuydh wanan ipi kaziginga, mina pawa kedha nungu tukuyap ngaru niyaypa yoelapiz senabi maykiya, lak palay kazil gasamoeyn kulay alaypa, nungu buwayngu poethayle. ");
INSERT INTO mwp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","‘Wara thonara thana seben tukuypal mura. Kuykuyg nuy niyaypa yoelpaydhin, nuy kazigig umanga. A nubiya wagel nuydh nungu mayk yoelpadhin a nuy kalanu umanga kazigig. ");
INSERT INTO mwp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","‘Wagel nanga nungu tukuypan yoelpadhin nanga; lak kedha nuy kazigig umanga. ");
INSERT INTO mwp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sizi pawpa mura seben tukuypal nabiya niyaypa yoelpemipa nanga kasa kay kedha kazigigal mura um poegaypu. Mina kalanu na mayk umanga. ");
INSERT INTO mwp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","‘Nginu ngurpaynu kedha, senabi thonara kay bangal mura umaw mabaygal lak kaday nithamoene umangu. Na senabi thonara ngunu ipi bangal aymidhe; thana mura seben tukuypal nabiya niyaypa yoelpemidhin?’ ");
INSERT INTO mwp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nuy Yesu kuniya mulaydhin thanamulpa, ‘Ngitha mina koey koerawaygal Minar Poelayzinga midh a Awgadhaw poerapar koey bibirilnga. ");
INSERT INTO mwp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Uma mabaygal mi thonara nanga lak kaday nithamoene, thana matha kedha angelal daparanu midh nanga, garkaz a yoepkaz lak niyaypa yoelpaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","‘Wara kedha thana uma mabaygal, ngaru bangal kaday nithamoene. Ngitha Mosen Thusi geth tidaydhin a? Ngurpan ngalpan muynu, muy na siyay bupanu. Sena mina poelayzinga kedha, “Awgadhaw ya kedha Moselpa, ‘Ngay ngaru Abraman Awgadh, Isakan Awgadh, Yakubun Awgadh.’” Nuy lawnga kedha, “Ngay kulay thonar thanamun Awgadh.” Nuy kedha, “Ngay ngaru thanamun Awgadh.” Ngay kedha zoenguz ngithamulpa kedha, thana Abramiya ngaru igililmayl. Ngitha mina koey yababir umamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesu nanga Sadusaylgoepa yadu umay urapun sabiw ngurpay mabayg lak si mer, nuydh karngemidhin thanamun ya pathukamay ya. Nuydh imadhin kedha Yesu thanamulpa mina balbayginga mura umay, kalanu nuy lak yapu poeybaydhin Yesulpa kedha, ‘Mi sabiw yawoedhayzinga adhapudhay mura wara sabiw yawoedhayzimaya?’ ");
INSERT INTO mwp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kuniya kedha mulaydhin, ‘Mina adhapudhay sabiw yawoedhayzinga ina kedha, “Kurusipagemiw ngitha Isoereylaw mabaygal, ngalpan Kuykulnga urapun, Awgadh. Matha nuy kedha, ");
INSERT INTO mwp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘Ngitha ngaru maman manin ngithamun Kuykulnga mura ngithamun ngoenakapoengu, a mura ngithamun mina muy igililmayngu, a mura ngithamun wakay thamamayngu, a ngithamun gamu moegawngu.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘ “Ina wara wagelkun lak kedha koey mina sabiw yawoedhayzinga, ‘Ngitha ngaru maman manin ngithamun tukuyap, ngidh nginu gamu midh mina koeyma maman maypa.’ Wara sabiginga palamuniya lak gimanoeka, ipal ngaru adhapudhay mina sabi.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nuy sabiw ngurpay mabayg nubepa Yesulpa kedha mulaydhin, ‘Ngi mi mina yadu umepa kedha, matha Kuykulnga kedha mina Awgadh, wara kedha ngoedhal mabaygoeginga nubiya pasinu, ");
INSERT INTO mwp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","a mabaygan ngaru nuyn maman maypa mura nungu ngoenakapoengu a mura nungu mina muy igililmayngu, a mura nungu wakay thoemamayngu, a mura nungu gamu magawngu, a nuydh ngaru nungu pasiw tukuyap maman manin nuydh nungu gamu midh maman maypa. Ipal palbi ukasar sabi adhapudhay mina sabi, wara kedha ngoedhal sabiginga, kasa ngidh midh uruy poeyban oltanu Awgadhoepa nuy mina balbayginga, kasa kay kedha na kedha lawnga ipal palbi ukasar sabi midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Senabi thonar Yesu imadhin kedha, nungu sabiw ngurpay mabaygaw yoeday mura mina balbayginga. Yesu nubepa kedha mulaydhin, ‘Nginu mina amadhan Awgadhaw Basalayapa muya uthaypa, ngi koey sigal lawnga.’ Sethabi thonara yoewthaw kuyku mabaygal thana Yesulpa lak yapa yapupoeybayginga. Minguz kedha, thana matha ngoedhagidh lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kalanu Yesu nuydh ngurpay aymoedhin koey yoewthanu muynu. Nuy yapu poeybiz, ‘Thana sabiw ngurpay mabaygal midh paru kedha ngurpay ayimpu, “Awgadhaw Mina Woeyayzinga Mesaya, nuy ngapa Dhawithan buway mabayg, Dhawithan Kazi?” ");
INSERT INTO mwp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kay paypa kulay Dhawitha, Maygi Mariw bibirinu muynu, nuydh yadu palgadhin nuyn kedha, “Nuy Kuykulnga mulaydhin ngaw Kuykulmaypa kedha, ‘Ngi ngapa in thanuripa ngaw getha doegamoenu, kurusipa ngath nginu mura thabukiriw mabaygal mulupa idimpa; a ngidh ngar tharal thanamuniya gimal.’” ");
INSERT INTO mwp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‘In nubi yangukudunu muynu, Dhawitha nungu geth nuyn Kuykulnga thoeraypa, Awgadhaw Woeyayzi Mabayg. Thana midh paru kedha, “Awgadhaw Woeyayzi Mabayg Dhawithaniya wagel.” Lawnga nuy mina kay paypa kulay, meparu Awgadhiya kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu nanga thana mabaygal ngurpamoeyr nanga nuy thanamulpa kedha mulaydhin, ‘Kulay bangal nagemipu, a koey poeypiyam bangal sabiw ngurpay mabaygoengu, thana ngulayg gurguy toedipu, koey kuykuthal sodhalgal mabaygoepa thanamulpa apasipa, a thanamun ubi kedha, mabaygoepa thanamulpa apasidh ya umamoeypa barpudhay lagoenu. ");
INSERT INTO mwp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A mabaygoepa thanamulpa mina niyay lagoepa buth woenaypa yoewthanu, a matha kedha aygudaw lagoenu lak kedha. ");
INSERT INTO mwp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","‘Kasa kay kedha thana mina azirginga, kasa ngoelkay modhabinu barpudhamoeypa yoepkaz maykaw lagiya. Kalanu thana uthay aympa thanamun wati pawangu imoeyle, thana koey kuykuthal thoeythu pagemipu, mabaygaw parunu. Kedha ngoedhal mabaygan bangal mina koey gegeyadh gasamoene kuth.’ ");
INSERT INTO mwp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nuy Yesu kalanu pasinu thanuraydhin, imaypa mabaygan ngalaga nanga bokadhza thayar yoewthoepa. Koey garsar bokadhzapul mabaygan koey bokadhzapul idimar, yoewthapa. ");
INSERT INTO mwp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kasa gar kay kedha urapun yoepkaz mayk, nadh gar matha ukasar mina moegina kula bokadhza thayamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kalanu mura nungu niyay kazil thuraydhin a kedha mulaydhin thanamulpa kedha, ‘In ngay ngithamulpa mina ya muliz, ina nabi yoepkaz maykan nadh mura gimal thayanu mabaygiya mura thanamun thoeyayzimaynu. ");
INSERT INTO mwp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Thanamun matha ngoedhagidh mina koeyza, urapun kay kedha thana poeybamoeyn Awgadhoepa moenari koethil zapul, kasa na mayk nadh mura poeyban bokadhzagimay bokadhza; nadh mura nanungu poeyban Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu nanga adhapa padhadhin koey yoewthangu, nungu niyay kazil nubepa mulemin kedha, ‘Ngurpay Mabayg, sepa nagi, nubi kapu yoewth mina kapu kulaw moeydhayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kuniya mulaydhin thanamulpa, ‘Ngitha imiz setha koey lagal moeydhayzimayl. Kasa kay kedha kalanu bangal sethabi moeydhayzi kulal mura noeridhedhe, wara urapun kulapa woenaypa lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Senabi kaliya Yesu kadaypa Olibaw Padiya, nuy apa thanuraydhin sey, sizi nuy bal nagaydhin koey yoewthapa. Nungu niyay kazil ngapa wagel, Petheru, Zemes, Yoewane, a Andhoeru, nubepa yapa yapupoeybaypa muynu, thanamun ya ubilnga. ");
INSERT INTO mwp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","‘Sethabi mura zapul nanga, ngidh kulay pudhamoeynu, thana bangal mi thonar mangemine? A ngoey midh paru bangal ngulayg asimoeyne kedha, thonar amadhan thamiz?’ ");
INSERT INTO mwp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kuniya thanamulpa kedha muliz, ‘Thonaral koey garsar, wara mina a wara ngoelkay. Ngitha koey poeypiyam a wergoegadhasig bangal ngoelkay mabaygoengu ngithamulngu karum poelayle. ");
INSERT INTO mwp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kedha mabaygal bangal yaynanob mangemine a thana bangal koey garsar mabaygal ngoelkemoeypu kedha, “Matha ngay Kuykulmayngu ngapa ngithamulpa. Ngay nungu Mina Woeyayzi Mabayg.” Wa, koeygarsar bangal mabaygal thanamuniya asimoeyne wati mabaygiya, thanamun wati yabugudiya. ");
INSERT INTO mwp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Wara kedha, mabaygal bangal koeyma silamoeypu ngithamuniya amadhan a ngithamulngu koey sigal. Amadhan nanga ngitha koewbu nur karngemine, koey sigal nanga ngitha koewbu ya gasampu. Aka bangal gasamayg, sethabi thonaral ngaru kulay mangemine, mina kuthaw thonar matha lawnga ka. ");
INSERT INTO mwp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mamu kedha mura koey goegathal ngaru pazalmemipu kidhakidhan, a koey aygi wathal bangal gasamoeyne, a kobegadh lagiya nanga nabi apaw boeradhar bangal garguy medhedhe. Mura thabi zapul ngaru kulay, wagel bangal sirisir ngaru koeyza aymidhe. Kulay mapul nanga setha ngoedhe yoepkaziw koeykoeyne kazimay kikir kayn gamu tariz. Kulay kasa moegina wagel bangal koeyza.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","A ngitha lak kedha, ngitha bangal ngaru koey poeypiyam, wati thonar bangal dhadha mangepu mura thonara, a ngitha bangal sabipa mamayine yoewthaw kuyku mabaygiya parunu, wati ngadh oesipa poelngin. A ngitha bangal sabipa mamayine kuyku mabaygoepa a matha kedha mopakuykupa, ngitha senabi thonar aka gasamayg, sena kapu buth ngaw yoepa yadu poelgaypa thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","‘Wa, in bangal kapu igilaw yangu wakay ngaru bangal yadu poelgaypu mura goegathiya. ");
INSERT INTO mwp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A ngitha bangal nanga sabin gasamoeypu nanga ngitha bangal akag sabiw kuyku mabaygoengu, a nungu minamay zagethoengu. Koeyma wakay thoemamayg kotaw thonarnu parunu ngitha bangal miza nanga ya umamoeypa. Thonara na gasamoene bangal, nuydh Maygi Marin ngaru danal pathar ngitha, a mina yangukudul poeybamoeypu ngithamulpa umamoeypa kuyku mabaygiya parunu. ");
INSERT INTO mwp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kedha thonar nanga gasaman nanga apthathkazil yaynanob bangal kidhakidhan sabinu gud aremipu uma mathamoeypa thanamulpa. Matha kedha tukuyap tukuyap, thathi kazi, a matha kedha kazil thanamun apu thathi, kasa ipidhadh gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mura bangal mabaygan wati ngoenakap gasampu ngithamulpa, minguz kedha ngitha ngaw gamu puziw mabaygal, kasa kay kedha mabaygal nanga ngaya ngaybiya ngaru kalmel kuthoepa thana bangal matha ngoedhagidh gasamoene ngaru igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu lak mulaydhin thanamulpa kedha, ‘Ngitha bangal imane koey gegeyadh za. Nuy bangal kaday tharedhe wara kupay lagoenu, nungu kupay lawnga. (Ngitha getha tidayzi mabaygal ngitha gasaman a? Ngath miyay thonar tidan, a ngoenu maygi laganu muynu.) Senabi thonar mina wati thonar; ngitha ngaya nanga sey Yoewdhayawlgaw doegamoenu nanga, ngitha adhapa zilmemin padoepa sobaginga. ");
INSERT INTO mwp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngitha nanga ngaya gabupa thanuriz sey gimal thodhanu, ngithamulpa koey zageth lagoepa muya yoewthaypa, rugapa gasamoeypa; lawnga ngitha matha zilmemin. ");
INSERT INTO mwp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngitha ngaya nanga apawlagoenu, lak lagoepa kuniya tidayg sumay sodhoepa. ");
INSERT INTO mwp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Thana yoepkazil ngaya nanga maythalgal a moegina mapethalgal, thanamun sirisir mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kapu za ngitha Awgadhoepa yoewdhemin kedha wati zangu dhadha mangayle gabu thonara. Gabu thonara nanga wati thonar, mapethoepa mina koey gegeyadh sey adhal bupanu; mura mabaygoepa gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‘Kedha wati thonaraw goeygil nanga ngaru mina koey gegeyadh. Kedha wati thonar ngaru adhapudhay mura wati thonaral nubi gugu ubidh thoeyayzimayngu kulay ngapa kurusipa nabi thonara a nabi gugu ubidh thoeyayzimay bangal kuth, kedha ngoedhal wati thonarginga. ");
INSERT INTO mwp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kasa kay kedha Awgadhan nuydh nan lak thawpayn pathan sethabi goeygil. Nuydh aymayginga nay mura mabaygal ngaru um pudhepa, kurusipa mura eygi thayamoeyn. Nuydh minguz thawpayn pathan sethabi goeygil, kuyk nungu adhapa thamayzi mabaygal, setha ngaya nanga nuydh bangal nubepa mamayine. ");
INSERT INTO mwp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Ngath kedha zoenguz ngithamulpa mura sakar pudhan, mabayg bangal nanga ngithamulpa muledhe kedha, “Mesaya in Awgadhaw Mina Woeyayzi Mabayg!” a wara mabaygan wara yadu palgan kedha, “Senaw nuy.” Sepa bangal mina yoepathamayg. ");
INSERT INTO mwp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngoelkay peropethal mangemine bangal, a wara ngoelkay mabaygal ngaya nanga kedha yaynanob umamoeypu, “Matha ngay Awgadhaw Mina Woeyayzi Mabayg.” Thana kedha mabaygal ngulaygal adhapudhay zagethal aymoeyne bangal senabi thonara. Thanamun kasa ubi kedha thana Awgadhaw adhapa thamayzi mabaygal, adhapa ruwamoeyne wati yabugudoepa. ");
INSERT INTO mwp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Koey poeypiyam bangal, wagel kay thabi zapul, ngath ngithamulpa kulay yadu palgan mura mina zapul. ");
INSERT INTO mwp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Sethabi wati goeygil kulay, kalanu goeyga zurug asin a moelpal buyag asin, ");
INSERT INTO mwp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","a setha nanga thithuyl pudhemin daparngu mulupa. Wa, sethabi mura koey bibiril zugubal thana mina bibirig asimoeyn, a thana adhapa mamayin thanamun mina yabugudoengu. ");
INSERT INTO mwp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","‘Senabi thonara bangal mabaygan mura kakal imane ngay Mabaygaw Kazi bangal ziyanu ngapa mulupa, ngaybiya mura bibir, woenab a poerapar. ");
INSERT INTO mwp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngaw bangal kalanu angelal wayedhe mura thabi po gubaw gizuya garwoeydhamoeypa ngaw adhapa thoemayzi mabaygal, mura nubi po gubaw gizungu wara kibungu wara kibupa. ");
INSERT INTO mwp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Wara ay puy koewsa meparu nungu nel dhani, kapu za ngitha nubiya ngurpemipa. Nungu nanga mura thamangu kayn nikil kadaypa puydhan a maludh gamulnga aymiz, ngitha ngulayg asimoeyn kedha, naygay thonar amadhan thamiz. ");
INSERT INTO mwp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wa, ngitha mi thonara bangal thabi moegithap zapul imamoeyne, ngaw kulay yangukudu ya midh nanga, ngitha ngulayg asimoeyne kedha, Mabaygaw Kaziw mangay amadhan. ");
INSERT INTO mwp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kedha yakanurayg, mi thonara nanga mura thabi thonaral yakamoeyne bangal, dhuray mabaygal kaybaw maykuykoengu matha memayipa. ");
INSERT INTO mwp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kurusipa nabi apa goewa a dapar idimidhe bangal a muwasin kasa kay kedha ngaw yangukudupa ngaru muwasiginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu lak mulaydhin thanamulpa, ‘Mabaygoeginga ngulayg kedha ngaw Mabaygaw Kaziw mi thonara lak ngapa kuniya. Ngalpa goeygingu koerawaygal, awangu koerawaygal. Thana daparaw angelal a matha kedha ngay ngoey mura koerawaygal. Matha Thathi kedha ngulayg, ngay mi thonara lak ngapa kuniya.’ ");
INSERT INTO mwp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yesu lak mulaydhin thanamulpa kedha, ‘Koey poeypiyam, ngoena bangal ugaypu, ngay bangal lak boey, kasa kay kedha midh thonara ngitha koerawaygal. ");
INSERT INTO mwp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ina ngoedhe kedha ngoedhalnga mabayg koey kuykuthalnga yawar mizin, nuydh zapul mura a lag ya wadhiz nungu zagethaw mabaygiya. Nuydh thanamulpa yaynanob zagethal thuraydhin. A nuydh pasa gudaw danal pathay mabaygoepa kedha mulaydhin, “Thura bangal yawaypu.” ");
INSERT INTO mwp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","A ngitha lak kedha ngitha mura ngaru bangal thura yawaypu, ngitha koerawaygal kedha lagaw Kuykulnga bangal midh thonara boey kuniya tidhedhe, midh kuthoepa lawnga dhadha kubilu, lawnga pawlaw poeybaynu, lawnga bathaynga. ");
INSERT INTO mwp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","‘Nuy bangal nanga dhadha sakara mangedhe nanga, nubepa ngithamulpa uthuyg imaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ina ngaw yangukudu ngithamulpa a matha kedha mura mabaygoepa, kedha, danal bangal poethaypu.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ukasar goeyga na wanamoedhin nanga thanamun yoewthaw koey thonara amadhan thamayidhin, thana matha yistagi thoewa ay purthaypu. Thanamun kuyku misnarel a sabiw ngurpay mabaygal thana sakariya nagemir kedha, thana kay midh paru Yesun gumi gasampa a kay nuyn uma mathampa. ");
INSERT INTO mwp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Thana kedha umadhin, ‘Ngalpalpa nubepa ay aymay thonara gasamoeypa lawnga, kedha zoengu mabayg mina koey garsar, thanamulngu gegeyadh gasamoeyle a silamoeyle.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wa, Yesu senawbi thonara moegina goegathoenu mer, Bethoeninu nungu igalgaw Simonan lagoenu, nuy nga nanga kulay wati goengaw kikirilayg. Yesu nanga nungu igalgaw laganu ngoenakap thayar, wara yoepkaz ngapa muy araydhin senabi lagiya. Nabiya mer pudu wakasu kapu ganulnga buyunu. Nabi wakasu mina koey modhabilnga, wakasu nel nad. A nanu buyu na koethil kulaw aymayzinga, nadh kalanu buyu mudul papoelamoeydhin a senabi wakasu Yesun pada kuykunu suladhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Senabi thonara mabaygan mura imadhin kedha nadh Yesun pada kuykunu mura kupal madhin senabi wakasu, wara mabaygan gegeyadh gasamoedhin kedha. Thana kidhakidhan umamoeyr kedha, ‘Sena mingu kasa sagul palanu. ");
INSERT INTO mwp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nadh senabi wakasu nay mina koey bokadhzapa yoewdhan, kalanu nadh senabi bokadhza aygi zagi mabaygoepa nay poeyban, 15,000 dolapa.’ Thana kedha zoenguz koey dharadh mulaydhin nabepa. ");
INSERT INTO mwp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu kedha mulaydhin, ‘Nan wanaw ngitha nabepa mingu wati ngoenakap gasaman, ina nadh ngayapa mina adhapudhay thoeyaygi zageth aymoenu. ");
INSERT INTO mwp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Setha ngaya aygi zagi mabaygal thana bangal ngithamuniya kalmel mura thonar koeygarsar, ngitha thonaralgal thanamulpa danal poethaypa. Ngay nanga ngayapa ngithamuniya ngaru maypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ina nanga nadh senaw kedha zapun kulay yakamoedhin, nanu mina ibupuydhan, nadh ngaybiya pada kuykunu nabi wakasu sulan nadh buth pathan ngaw gamu moerama thoeyaypa. ");
INSERT INTO mwp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","‘Mina ngay ngithamulpa kedha, igilaw yangu wakay nanga ngalagiya yadu poelgaypu nubi po gubaw gizunu a matha kedha in nanu zageth nadh ayman lak bangal kedha yadu poelgaypu mura mabaygoepa, ingaru za nanu doegamuya.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kalanu Yudha Keriyothoelayg nuy wara Yesun niyaykazi toewalob niyaykazingu, uzaraydhin Yesulpa yadu poelgaypa kuyku misnarepa. Nungu imul poethay kedha. ");
INSERT INTO mwp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Thanamun dhiwa mina koeyza nuy kay midh nanga mulepa, thana waza nubepa mulemidhin nungu modhabipa gasamoeypa. Kalanu Yudha buth thoemaypu Yesulpa yadu poelgaypa thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Koeykoeyne goeyga nanga gasamoedhin, senabi yistagi bredaw aygudaw goeyga thana Yesun niyay kazil nubepa yapu poeybemidhin kedha, ‘Nginu ubi midh ngoey kay ngalagapa ladhuypa ngibepa kay Kaludhay Aypa buth poethaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nuydh ukasar kulay wayamoedhin nungu niyay kazi, kedha yadayg, ‘Uzarmariw kedha koey goegathoepa. Ngipel kay nanga ngukiw zapulayg garkaz imaypa, nubiya kay wagel asimariw. ");
INSERT INTO mwp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nuy kay na mi lagiya muya uthuy, ngipel kay sew lagaw thathipa kedha mulemariw, “Ngalbe Ngurpay Mabaygan ngapa wayamoenu kedha, nungu aygudaw lag ngalaga, nuy kay ngalaga Kaludhay Ay aymay aydu purathipa nungu niyay kaziya kalmel.” ");
INSERT INTO mwp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nuy kay nungu gethan yadu poelgaypa aygudaw lag kapu koey gudalnga kathaygoenu gimanoeka, mura nanu zapul si nabiya muynu, sew kay ngalpalpa buth pathane.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kalanu palay kulay uzarmoedhin, koey goegathoepa. Palay mangemidhin nanga palay imaydhin mina mura zapul balbayginga kedha, mina Yesulpa palamulpa midh nanga mulaydhin. Kalanu palay aygudaw zapul mura buth pathamoeydhin Kaludhay Aypa. ");
INSERT INTO mwp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sethabi kutoepa nanga Yesu a nungu niyay kazil thana ngabunadhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ayguda dhadhal nuy kedha mulaydhin nungu toewalob niyay kazipa, ‘In bangal kuyku nidhane ngithamulngu urapu mabaygan bangal ngoena gud arane, kasa kay nuy lak mamu kay kalmel ngalpaniya aydu purathipa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Thana niyaykazin karngemidhin nanga thana mina gegeyadh gasamoedhin aka a koerkak badh kalmel, thana yaynanob nubepa yapu poebemir kedha, ‘Kuykulnga ngidh ngan maypa, ngoena a?’ ");
INSERT INTO mwp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kuniya mulaydhin nungu toewalob niyaykazipa kedha, ‘Ngitha mura ngaybiya nithaman kalmel, a ngalpa kalmel mura bredal thardhamoeypa urapun aygudaw zapunu, kasa kay ngaru urapun ngithamulngu nuydh bangal ngoena ngaru guda arane. ");
INSERT INTO mwp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngay nanga ngay Mabaygaw Kazi ngaru bangal um medhedhe kuyku nidhaypa Awgadhaw yawoedhayzinga Minar Poelayzinga muynu Maygi Thusinu, kasa kay kedha ina mina koey gegeyadh senawbi mabaygoepa ngadh bangal nanga senaw Mabaygaw Kazi guda arane. Nubepa matha ngoedhagidh kedha nuyn kasa nay kazi mayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Thana matha ay purthar, Yesu nuydh madhin nan bred a eso poeybadhin Awgadhoepa. Kalanu nuydh nan dhadhiya patidhadhin thanamulpa nungu niyay kazipa. Nuy kedha thanamulpa, ‘Mariw ina a gasamaw ngaw gamu.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kalanu nuydh lak kedha, umal ngukiw kap madhin a eso poeybaydhin, Awgadhoepa. Kalanu thanamulpa madhin nuyn kap, a thana mura wanimoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nuy thanamulpa mulaydhin kedha, ‘Wanimaw koezi ngitha mura, ina ngaw kulka ngath ngithamulpa poeyban, ina mina kuyku nidhan Awgadhaw yawoedhayzinga, ngaw kulka pay yoewdhiz mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngay ngithamulpa mina ya muliz kedha, ngayapa lak nabi umal ngukipa woenipa lawnga, kurusipa bangal senawbi thonar ngay bangal wanedhe kayin umal ngukin Awgadhaw Basalayoenu muynu.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sew kalanu thana maygi na puydhadhin a ladhudhin Olibaw Padoepa. ");
INSERT INTO mwp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nuy thanamulpa kedha mulaydhin, ‘Nubi kubilu kay ngitha ngaru mura bupa aremipa ngawngu, ngoena kay ngaw kusayg woenaypa. Na Minar Poelayzinga kedha, “Awgadhan bangal mamuy danal poethay mabayg uma mathamoene a setha nanga nungu mamuyl thana bangal wad wadgoepa zoelmemine.” A ngitha matha kedha guythuyayzi mamuyl midh. ");
INSERT INTO mwp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kasa kay kedha Thathin bangal ngoena lak kadaypa manine moeram gudangu ngay bangal ngithamuniya kulay Galilayapa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petheru kedha Yesulpa, ‘Ngayapa ngibepa kasa woenaypa lawnga. Kasa kay ngidh, thana mura nginungu kuniya pudhemine, ngay bangal ngaru ngibiya kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kedha mulaydhin Petherulpa, ‘Kame! Ngay ngibepa kedha muliz, kaybaw kubilu wagel kay garkaz pawl poeybepa ukasar thonaralnga, ngi kay kulay thoeri thonaralnga ngawngu koerawayg kudun tharepa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petheru kuniya koey dharadh mulaydhin kedha, ‘Ngayapa kedha ngoedhal zapa wara aymoeypa mina sogum lawnga, kasa kay midh thana sikedh ngoeba kalmel uma mathampa ngay kay ngaru kalmel ngibiya.’ Thana kalanu mura kedha mulemidhin nubepa. ");
INSERT INTO mwp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wa, thana gasamoedhin apaw lag nel Gethsemoene. Yesu a nungu niyay kazil si nanga ngabunadhin nuy kedha thanamulpa, ‘Ngitha koew ngoena ugaw, ngay mamu kedha uzaripa thoeythupoegaypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nuydh nubiya kalmel yoelpamoeydhin thanamulngu Petheru, Zemes, a Yoewane. Senabi thonara nuydh mina koeyma ngoenakap kikir gasamoedhin a koerkak badh. ");
INSERT INTO mwp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nuy kedha thanamulpa, nungu thoeri niyay kazipa, ‘Ina ngaw ngoenakap kikir mina koeyza, ngoena mina koeyma nudhepa. Ngitha koew nithamaw a danal poethay kay aymoeziw.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nuy kalanu thanamulngu moegina sigapa uzaraydhin si nuy kasa boeradharoepa nungungu mulupa gud pudhaydhin a thoeythupagaydhin kedha, ‘Ngibepa sike balbayginga kedha in nubi gamu mapu adhapa manin ngawngu.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nuy kedha thoeythu poegaydhin, ‘Bab! Ngaw Thathi, wara zaginga ngibepa koey zageth aymoeypa, ngidh gar adhapa mar in nabi kikiriw mapu ngawngu, kasa kay kedha ina nginu ubilnga aymar, ngaw ubilnga lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wa, nuy na ngapa kuniya tidaydhin, nuydh imiz thana uthuy. Nuy kedha Petherulpa, ‘Simona, ngitha mingu uthuy poeydhanu? Ngithamulpa urapu awapa danal poethay matha koey gegeyadh a? ");
INSERT INTO mwp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Matha ngoedhagidh kedha ngitha danal poethay aymoeziw a yoewdhemiziw ngithamulpa magaw poelaypa, wagel kay sethabi nuthayl zapun ngitha karum paledhe. Ngithamun mariw ubil danal poethaypa ngaybiya kalmel aymoeypa, kasa kay ngithamun gamul goegadhimayl.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu kalanu lak kuniya tidiz a thoeythupagiz kulay yangukudu ya. ");
INSERT INTO mwp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sew kalanu nuy lak ngapa kuniya nungu niyay kazipa, imiz thana uthuy, minguz kedha thanamun gamul koey gegadhimayl. Thana wara kuniya nubepa yangukudugigal. ");
INSERT INTO mwp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nuy lak uzaraydhin thanamulngu kalanu ngapa kuniya tidaydhin. Nuydh imiz thana matha uthuy, nuy kedha thanamulpa, ‘Ngithamun ubi uthuypa, wa matha uthuy palemoeziw, thonar gasaman Mabaygaw Kaziw, gud aran wati mabaygaw gethoepa. ");
INSERT INTO mwp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","‘Kadaypa memayiw, ngalpa ladhuypa. Wa, kedha nagemiw senawbi mabayg mangiz, in ngadh kay nanga ngoena gud oeraypa.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesun yanu dhadhal, Yudha wara nungu niyay kazi mina sobaginga mangiz; nubiya kalmel koey garsar mabaygal thana koewbu rugalgal, kuyay thurikal a gabagabal. Thana kuyku mabaygan wayaydhin, kuyku misnaren, sabiw ngurpay mabaygan, a yoewthaw koey mabaygan. ");
INSERT INTO mwp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wagel kay mura thabi zapul, Yudha kulay mulaydhin koewbu mabaygoepa kedha, ‘Ngath kay nanga ngan gud thapampa, ngitha kay nuyn gasamaw, a kasa kay balbayginga nuyn adhapa yoelpan.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudha na mangaydhin, nuy balbayginga Yesulpa uzaraydhin a nuy kedha mulaydhin, ‘Ngurpay Mabayg senaw ngi?’ Kalanu nuydh Yesun gud thapamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Thana kalanu koewbu mabaygal ngapa mina koey ridh gasamoedhin Yesun. ");
INSERT INTO mwp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wara pasiw puziw mabayg Yesun, nuydh nungu kuyay thurik adhapa paradhin a woerimadhin koey misnariw zagethaw mabaygiya, adhapa pathadhin nungu kawra. ");
INSERT INTO mwp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kalanu nuy Yesu Yudhan mabaygoepa muliz kedha, ‘Ngitha ngapa mipa kuyay thurikalgal a gabagabalgal, ngayapa gasamoeypa? Ngay sabiw koerngaygi mabayg lawnga. ");
INSERT INTO mwp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngay nanga ngithamuniya amadhan, senaw koey yoewthanu ngath ngurpay aymarngu ngitha ngoena gasamoeyginga.’ Itha mura thabi zapul aymoeypa nanga kuyku nidhaypa Maygi Thusinu Minar Poelayzimayl. ");
INSERT INTO mwp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kalanu nungu niyay kazil mura wad wadgoepa nanithadhin nungungu. ");
INSERT INTO mwp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Thana nanga Yesun adhapa yoelpadhin nanga, nuy wara kayin mabayg Yesuniya wagel asidhin. Nungu gamu rug matha urapun dhoemawak. Thana nuyn gasamaypa madhin, kasa thana kasa nungu dhoemawak gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nuydh gamu woerdhay zagig zoelmaydhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Thana nuyn Yesun madhin, kuyku misnariw lagoepa, mura koey misnarel, a yoewthaw koey mabaygal, a sabiw ngurpay mabaygal ngalaga nanga garwoeydhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petheru koey sigal wagel woelmay a muya yoewthaydhin kotaw boeradhariya kuyku misnariw lagoenu. Nuy si muythay pasinu nir kom poelaypa nungu gamupa, kuyku misnariw danal poethay mabaygiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nuy kuyku misnari a nubeya kalmel nungu Yoewdhayalgaw koey mabaygal kawnselal, thanamun ubi Yesulpa mathamoeypa. Thana kasa kobegadh mabayg luman Yesulpa mulamoeypa kedha, nuydh za gegeyadh ayman. Kasa kay kedha thana wara gegeyadh imayginga nubiya, nubepa kuthoepa thoeraypa. ");
INSERT INTO mwp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Koeygarsar mabaygal ngapa sole yangukudu ya umamoeyr nubepa gasamoeypa, kasa kay kedha thanamun yaynanob yangukudul ngaru kotanu balbayg oesiginga Yesulpa kuthoepa thuraypa. ");
INSERT INTO mwp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dhuray thanamulngu kaday nithamoedhin a ngoelkay yangukudu butha woeydhamoeydhin kedha, ");
INSERT INTO mwp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Ngoey kulay karngemidhin nuyn, nuy kedha umay, “Ngath bangal idimoene ina gethaw aymayzinga, koey yoewth idimoene, a lak bangal ngath moeydhane thoeri goeygilnga; ngaw gethan lawnga, kasa bangal yangukudun.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kasa kedha thanamun yangukudul lak kedha balbayg oesiginga, Yesulpa kuth thoeraypa. ");
INSERT INTO mwp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nuy kuyku misnare kaday tariz thanamuniya dhadhal Yesulpa yapu poeybiz kedha, ‘Ngi wara yangukudulayg sakar maypa a? Sena mura wati za ngibiya woeydhoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nuy Yesu kasa ngaru yagig. Nuy kuyku misnari lak Yesun yapu poeyban kedha, ‘Ngi mina Keriso a. Nungu Kazi sey nga nanga koey woenabalayg pika gimal?’ ");
INSERT INTO mwp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kuniya mulaydhin nubepa kedha, ‘Wa senaw ngay, a ngitha bangal imane Mabaygaw Kazi Kuykulmay getha doegamoenu daparaw niyay lagoenu gimanoeka, ngay bangal boey mura daparaw ziyanu dhadhal.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nuydh kuyku misnaren nungu dhoemawak pakadamoedhin thabukirin a wal mizin kedha, ‘Wara lak yaginga koezi powpa, ");
INSERT INTO mwp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ngalpa mura nungu ya karngemidhin kedha, ina nungu mina kawrag Awgadhoepa. Ngithamun wakay thamamay midh?’ Thana kedha, ‘Nuy wati mabayg, nuyn kay ngaru uma mathamoene.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dhuray thanamulngu parupa mosal adhamoeyr a purkiya za yatharadhin nubiya; kalanu koey dharadh mathamar nuyn a kedha umamoeyr, ‘Imaypa ka muli, ngin ngadh mathampa, ngi nanga sike mina peropetha a?’ Kalanu danal poethay mabaygan madhin a dak tidar nuyn. ");
INSERT INTO mwp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Senawbi thonar nuy Petheru matha ka apal muynu kulaw panu muynu, muythay komoepa pasinu nir. Kedha nanga na kuyku misnariw zagethaw yoepkaz nagiz nanga. Nadh nuyn iman, na kedha muliz nubepa, ‘Kame! Ngi wara senaw, ngi puzir senawbi Nazarethoelgiya, Yesuniya.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kasa kay kedha Petheru mina koeyma gud thadhaydhin kedha, ‘Ngay koerawayg ngi mi yadu umepa, ngath nginu ya tidayginga.’ Kalanu nuy pasagudoepa uzaraydhin sizi. Sinubi thonara kay kalakala poeybiz. ");
INSERT INTO mwp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nadh zagethaw yoepkazin nuyn mi thonara lak iman, na mabaygoepa buwayl thayiz nabiya ngaya nanga pasiya sir. Nadh sinubi thonara nuyn azir pagan kedha, ‘Nagemiw, senaw nuy, nuy wara puzir.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petheru mina koeyma gud thadhiz. Mina moegina buth, kalanu mabaygal Petherulpa kedha mulemin, ‘Kasa balbayginga muli kedha, ngi wara puzir, senaw ngi lak Galilayaw mabayg kakal.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petheru kedha mulaydhin thanamulpa, ‘Ngay ngithamulpa mina yadu umepa, ngay nungungu koerawayg ngitha mi mabaygaw ya nanga umamoeypa. Ngay kay na ngoelkay ya mulepa nanga, ngath bangal wati kuth gasamoene Awgadhoengu.’ ");
INSERT INTO mwp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mina senawbi thonara kay kalakala lak poeybiz; nuydh Petheru ngoenanu madhin Yesun midh nanga mulaydhin nubepa kedha, ‘Wagel kay kalakala lak poeybepa, ngi kay ngaru mina sobaginga ngawngu gud thadhi thoeri thonaralnga.’ Nuy nanga Petheru ngoenanu mamayidhin sethabi yangukudul Yesun, nungu kasa may mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mina bathaynga nanga thana kuyku misnaren mina sobaginga garwoeydhamoeydhin. Thanamuniya kalmel yoewthaw koey mabaygal a sabiw ngurpay mabaygal a dhuray wara koey mabaygal, mura thanamun Yoewdhayalgaw kawnselaw mabaygal. Thana garwoeydhamoeydhin ya umamoeypa, Yesulpa mathamoeypa. Thana Yesun urukamin aymoedhin a yoelpaydhin nuyn Pilatholpa. ");
INSERT INTO mwp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatho nuyn yapu poeybadhin kedha, ‘Ngi Mina Yoewdhayalgaw Kuykulnga a?’ Yesu kuniya kedha mulaydhin, ‘Wa, nginu yangukudu moegina balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Thana kuyku misnaren nuyn kasa mina koeyma mulamoeyr. ");
INSERT INTO mwp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatho lak yapu poeybadhin nubepa, ‘Ngi midh paru thanamulpa kuniya ya mulayginga, nagi thana mura wati za ngibiya woeydhoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu kasa ngaru yagig. Nuy Pilatho dan kathamaydhin kedha, nuy Yesu midh paru kuniya yagig. ");
INSERT INTO mwp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nungu Pilathon pawa kedha, mura Kaludhay Ayngu thonara nanga, nuydh ngulayg mabaygaw ubilnga kunumayzi mabayg pa wayan. ");
INSERT INTO mwp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Senawbi thonara nanga wara mabayg Barabas muynu kunumay lagoenu, minguz kedha nuy koey kawragil mabayg, wara thonara nuy koey silamaynu muynu Yoerusalemoenu, a wara mabayg nuydh uma mathamoedhin. ");
INSERT INTO mwp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mabaygan garwoeydhamoeydhin a yapu poeybemidhin Pilatholpa kedha, ‘Ngi kay pa woeyaypa ngoeymulpa urapun mabayg kulay midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nuy yapu poeybiz thanamulpa kedha, ‘Ngithamun ubi midh, Yoewdhayalgaw Mopakuyk ngithamulpa pa woeyaypa a?’ ");
INSERT INTO mwp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Minguz kedha, nuy Pilatho mina koey ngulayg kedha, thana yoewthaw koey mabaygal kasa uwan memayidhin, thana kedha zoenguz Yesun kotoepa madhin. ");
INSERT INTO mwp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kasa kay kedha thana kuyku misnarel mulaydhin mabaygoepa kedha, ‘Ngitha kedha wal mamayi, “Barabasan kay ngoeymulpa ngapa pa wayar”.’ Thana Yesulpa wal mayginga. Thana Barabasoelpa walmemayir. ");
INSERT INTO mwp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatho kedha yapu poeybadhin thanamulpa, ‘Kedha kay nanga, wa ngath kay miza ayimpa nubepa ngan nanga ngitha kedha thuraypu Yoewdhayalgaw Mopakuyk?’ ");
INSERT INTO mwp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Thana kedha wal memayir, ‘Sathawro puydhaw nuyn.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nuy kay Pilatho kedha umay thanamulpa, ‘Mipa kay nuyn sathawro puydhaypa, nuydh za miyay gegeyadh aymoenu?’ Thana na kay zizigi moeyngu mina gegeyadh wal memayir kedha, ‘Sathawro puydhaw nuyn.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilathon ubi nuydh mabaygaw ngoenakapul balbayg palepa. Nuydh Barabasan pa wayadhin thanamulpa, kasa kay kedha nuydh Yesun nungu koewbu mabaygoepa gud aradhin poelngipa, kalanu sathawro puydhaypa madhin. ");
INSERT INTO mwp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Thana koewbu mabaygan Yesun muya thayadhin gabmenaw lagiya. A thana thuradhin mura thanamun koewbu mabaygal. ");
INSERT INTO mwp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kasa nubepa giwn maypa thana bamagadh gamul koey sodh Yesuniya angadhin. Minguz kedha, sena matha mopakuyku oengay gamul dhoemawak. Thana nubepa patal puyngu ngoelkay korone aymoedhin a nungu kuykuya angadhin. ");
INSERT INTO mwp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kalanu thana nuyn mina gegeyadh giwn soelmar kedha, ‘Ngaru Igilil Mopakuyk Yoewdhayalgaw.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Thana nuyn boegin kuyk tidar, a parupa mosan tidar. Thana nubeya parunu kulun pasoenoemoeyr. ");
INSERT INTO mwp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Thanamun nanga giwnsoelmay muwasin, thana kalanu bamagadh gamul rugan thudhan a nungu geth rugan kay kuniya ubaman. Kalanu thana adhapa yoelpadhin nuyn, sathawro puydhaypa. ");
INSERT INTO mwp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Senawbi thonara urapun mabayg nungu maboenu woelmay, nungu nel Simona, Sayrinoelayg nuy, Alesandoerom a Rupoesom thathi. Thana apasiginga nuyn gasamoedhin Yesun sathawropa thoeridhoeypa. ");
INSERT INTO mwp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Thana Yesun adhapa madhin padoepa, nel Golgotha. Ngalpadh kedha Kuyku Sibuy. ");
INSERT INTO mwp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Thana nubepa nuthan madhin umal ngukiw a theral za garwoeydhamoeyzinga muynu. Senabi theral za nel mer. Kasa kay kedha Yesu ubigasidhin woenile. ");
INSERT INTO mwp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kalanu thana nuyn sathawro puydhadhin neylan a nungu gamu rugal thanamuniya dhadh mamayidhin. Thana days thayar imaypa kedha ngadh kay gasamaypa mi dhoemawakul. ");
INSERT INTO mwp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Senawbi bathaynga nayn koelokoenu thana nuyn sathawro puydhadhin nanga, ");
INSERT INTO mwp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","thana nubeya yangukudulnga za wanadhin gimal kuyku laganu kedha yadaynga, ‘Yoewdhayalgaw Mopakuyk.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nubeya wara ukasar wadhwadhgam sathawro poeydhamoedhin ukasar mina koey geth geth puru kaz mabayg. Wara getha doegamoenu wara boedha doegamoenu. ");
INSERT INTO mwp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mabaygal ngaya nanga sike pasiya tadir, thana kasa kuyk woerimoeyr kedha umamoeyr, ‘Ngidh ngulayg idiman Awgadhaw lag, yoewth a lak moeydhan thoeri goeygiw kaliya a? ");
INSERT INTO mwp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Midh paru ngi nginungu balbayg tidayginga a? Ngapa mulupa pagar seyzi sathawrowngu nginu igililnga kuykuthal palal.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Thana koey misnarel a yoewthaw sabiw ngurpay mabaygal lak kedha nuyn giwn soelmar kedha, ‘Nuydh wara mabaygal gudaz pudhepa, kasa kay kedha nuy nungu geth ibupuydhayginga.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","‘Nuy kedha mulaydhin, nuy Keriso, Isoereylaw Kuykulnga. Ngalpa kay imaypa, nuy kay nanga nungu geth mulupa poegaypa, wa ngoey kay nubepa mina yoepathamoeypa.’ A sepal ngawal nanga nubeya wadhwadhgam sathawro puydhamoedhin, palay lak nuyn giwn mar. ");
INSERT INTO mwp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dhadha goeyginu nanga mura wadhwadhgam inur thoeydhamoeydhin, senabi koey goegathoenu kurusipa thoeri klok. ");
INSERT INTO mwp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kalanu Yesu koey gimiya wal miyaydhin thanamudh kedha, ‘Eli, Eli lema sabakthani?’ Muynu kedha, ‘Ngaw Awgadh, ngaw Awgadh, ngidh mingu ngoena kasa wananu?’ ");
INSERT INTO mwp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dhuray mabaygal si pasinu sir thana karngemidhin, thana kedha mulemidhin, ‘Nuy Peropethoepa Elayzalpa wal mepa sikedh.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Urapun mabayg thanamulngu zilamiz sathawropa a spanz sobaginga sisaberal ngukinu muynu thardhan, kalanu puy kopin pagan Yesulpa yoewdhan nubepa woenipa a kedha mulaydhin, ‘Thumaka mamu ugaypa, nuydh kay sikedh peropetha Elayza nuyn mulupa maypa sathawrowngu.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Senawbi thonara Yesu gimiya wal miyaydhin, nungu moeygoepa guban, ");
INSERT INTO mwp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","a koey yoewthanu thanamun wulaw koey dhoemawak nanu geth pakadamoeydhin gimanakaz mulupa. ");
INSERT INTO mwp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nuy koewbu kuyku mabayg nanga imadhin kedha, Yesu midh paru nanga muwasidhin gimal sathawronu, nuy kedha mulaydhin, ‘In nubi mabayg nuy mina Awgadhaw Kazi.’ ");
INSERT INTO mwp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dhuray si memayir yoepkazil, thana moegina sigaz nagemir. Thanamuniya kalmel Mariya Magdalangu, a Salome a wara Mariya na moegina Zemes a Yoewsepa, palamun apu. ");
INSERT INTO mwp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Thana nubeya kalmel Yesu na Galilayoenu mer, a ibupuydhar nuyn, aymoeyr mura nungu ubilmayl. A matha kedha dhuray yoepkazil nubeya ngaya nanga Yoerusalemoepa asimoeydhin, thana lak si mamayir. ");
INSERT INTO mwp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Wara koey mabayg thanamuniya, thanamun Yoewdhayalgaw kawnselaw mabayg, nungu nel Yoewsepa, Aramathiyalayg. Nuy lak mina kapu akasizi mabayg, nuydh ugar Awgadhaw Basalayaw mangay thonar. Thanamun za buthapoethay goeyga kutoepa nanga sabadhaw paru, nuy Yoewsepa mina akaginga Pilatholpa pa uzaraydhin a yapu poeybaydhin Yesun gamupa. Nuy thanamun sabadhoengu kikimidhin. ");
INSERT INTO mwp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yoewsepa Pilathon madhu paman nuy nanga Yesun gamu lumar. Nuydh Pilatho koewbu kuyku mabayg thuran a kalanu yapu poeybiz kedha, ‘Yesu mina kulkub um mema?’ ");
INSERT INTO mwp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mura nanga karngemidhin koewbu kuyku mabaygaw yangukudu nanga Pilatho kalanu Yoewsepalpa wa madhin kedha, nubepa gamu maypa, Yesun gamu. ");
INSERT INTO mwp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nuydh Yoewsepa mina kapu goerab gamul dhoemawak barpudhadhin, Yesun gamu mulupa madhin, a senabi kayn dhoemawakun nuradhin. Kalanu kulaw sakaynu muynu aradhin, sena mi sakay nanga kulangu adhapa pamadhin. Mura na muwasidhin nuydh mina koey kula gawan thayadhin parunu senabi sakay gudanu. ");
INSERT INTO mwp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magdala a wara Mariya, Yoewsepan apu, palay yawayar Yesun gamu ngalaga nanga wanadhin. ");
INSERT INTO mwp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabadhaw kal Mariya Magdaloengu, a wara Mariya Zemesan apu, a Salome thana ganul wakasul mamayidhin Yesun gamupa pinipa. ");
INSERT INTO mwp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mina bathaynga, kulay wiki goeyga Sandi, wagel kay goeyga palgin, thana ladhudhin moeram gudoepa. ");
INSERT INTO mwp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yabugudiya thana tadir, thana kedha umamoeyr, ‘Ngadh kay sena moeram gudangu kula adhapa thamaypa ngalpalpa, sena pasagudoengu?’ ");
INSERT INTO mwp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sena mina koey kula. Thana nagemin a iman na kula muwasizinga adhapa thamayzinga. ");
INSERT INTO mwp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Thana muya uthemidhin senabi sakaynu muynu; thana iman kayn mabayg getha doegamoenu nir, nungu goerab gamul dhoemawak koey gamulnga. Thana mina koeyma madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nuy kedha, ‘Koeyma wakay thoemamayg, ngay ngulayg ngitha Yesun lumaypa Nazarethoelayg, ngan nanga sathawro puydhangu, kasa kay kedha nuy in mayginga, nuy kaday tharayngu. ");
INSERT INTO mwp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngitha kuniya tidemiw, a in nubi ya nungu niyay kazipa mariw, a Petheru wara, “Nuy Galilayapa uzaridhe, bangal ngithamuniya kulay, ngitha bangal imane nuyn sin, nuy ngithamulpa midh na mulaydhin.” ’ ");
INSERT INTO mwp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Thana sethabi yoepkazil kuniya zilmemidhin moeram gudoengu, thana koeyma aka gasamoedhin. Thana wara mabaygoepa mulayginga kuyk thanamun aka koeyza. ");
INSERT INTO mwp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kuykuyam wiki goeyga nanga Yesu kaday tharaydhin umangu; kulay nuy yakamoeydhin Mariyalpa Magdalinalayg. Nan ngan nanga nuydh kulay kapu zageth aymoedhin nabepa kedha, nuydh seben wati maril adhapa mamayidhin nanungu. ");
INSERT INTO mwp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nadh nanga Yesun imadhin nanga nuy igililnga, na sepa uzaraydhin nungu puziw mabaygoepa, thanamun koerkak badh a may Yesulpa. ");
INSERT INTO mwp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Thana nanga karngemin nanu ya kedha, Yesu igililnga, nadh nuyn imanu, thana mina yoepathamayginga. ");
INSERT INTO mwp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yesu wara kuniya yakamoeydhin ukasar niyay kazipa palay na palamun maboenu woelmemar moegina goegathoepa. ");
INSERT INTO mwp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Palay na kuniya tidemoedhin wara niyay kazipa mulemoedhin, kasa kay kedha thana mina yoepathamayginga. ");
INSERT INTO mwp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu lak yakamoeydhin mina moeygoepa nungu eleben niyay kazipa thana nanga ay purthar. Nuy koey dharadh mulaydhin thanamulpa, minguz kedha, thana mina yoepoethamoeyginga; thana kasa koey kuyk woelemipu thanamulpa senaw ngaya nanga nuyn imadhin kedha nuy lak igililnga. ");
INSERT INTO mwp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nuy thanamulpa kedha mulaydhin, ‘Ladhu Awgadhaw aymayzi mabaygal ngalagiya nanga thabi po gubaw gizunu muynu nipa, in bangal nubi mina igililmay yangukudu mawthu yaday poelgaypu thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ngaya bangal nanga mina yoepathamoeypu a papthayso mamayipu nanga, thana bangal gudaz puydhamoeyne. A ngaya nanga mina yoepathamayg, thana bangal wati kuthoepa wayedhe. ");
INSERT INTO mwp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","‘Setha ngaya nanga mina yoepathamoeyzigal thanamulpa bangal poeybane Awgadhaw bibirpa yakamoeypa kedha; thana bangal wati maril adhapa mamayipu, kuyk thana bangal ngaw nel gima gasampu; thana bangal wara yangukuduya umamoeypu. ");
INSERT INTO mwp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Thana kasa kobegadh thabul gasamoeyn lawnga moerampa uma mathamay wati nguki wanimpa, thanamulpa umapa lawnga. Wara kedha thana bangal ngulayg kikiril mabayg dhoey nidhamoeypu a balbay tidamoeypu kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesun senawbi yangukudu kalanu, nuyn kadaypa madhin daparpa, Awgadhaw getha doegam niyay lagoepa. ");
INSERT INTO mwp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Thana niyay kazil ladhudhin, maw siparuy mura doegamuya; Kuykulnga zagethan meparuy thanamuniya kalmel; a mina yoepathamaypa thanamun maw nuydh bibir palimoeypu thanamun zageth, thana matha ngoedhagidh koey zagethoepa aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Thiyopolay, ina ngaw thusi ngibepa. Itha mina zapul ngath yadu mamayipa aymoeydhin ngalpaniya muynu. Ngalpaniya koeyma mabaygal kulay, itha thabi ngoedha thoeyayl thana purkan imadhin mura Awgadhaw kuyku nidhayzi zagethal mina kuykoengu, a maw tharemipu mura thabi ngadha thoeyayl midh nanga. Wara mabaygan koey magaw gasamoedhin senabi ngulayg minar paladhin thusinu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wa, ngay lak kedha, ngath mura itha thabi ngoedha thoeyayl ngaw ngulaygoepa ngurpamoeydhin geth tidemidhin woergi nopa mina kuykoengu kuthoepa; wagel kay ngath minar palimoeyngu ngibepa ngi wara koey mabayg ngalpaniya, itha mura ngibepa mina balbayginga thayamoeyn. ");
INSERT INTO mwp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wa, ngibepa mina ngulaygoepa gasamoeypa koezi, pasinu ngin midh nanga ngurpadhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wa, nabi ya kedha kuykaymaydhin. Wara misnare meparu Yoewdhayanu, nungu nel Zakaraya. Nungu zageth misnarew zageth kedha, nuy Abayzan doegam mabayg. Senawbi thonara thanamun Yoewdhayaw mopakuyk Erodh. Zakarayan ipiw nel Elisapetha. Na lak misnarew buwayngu Aronan buwayngu ");
INSERT INTO mwp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Palamun ngara pudhamay kalmel balbayginga Awgadhaw parunu. Awgadhaw maygi ya woedhay sabil palay pathidhayginga. ");
INSERT INTO mwp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kasa kay kedha palay gar mina kazigig, kuyk Elisapetha kazigi kupa a matha kedha palay kalmel apu thathi aymoemoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wa nabi thonara nanga Zakaraya a nubiya nungu doegam mabaygal misnarel thanamun thonara koey yoewthapa danal pathaypa. Thanamun misnarew wara koey pawa kedha, kasa ubipa misnaren nabi mina zageth aymayginga koey yoewthanu muynu thanamun mura garwoeydhamay thonara. Thanamun kulba pawa kedha mamu kulaw aymayzi za mamaman nge. Thana ngulayg za ayman, imaypa kedha ngunu thonara nge. Ngaru nuy senawbi misnaren yoewthoepa mina muypa, maygi dhadhabuthoepa. Nabi thonara kulaw aymayzi za pudhamoedhin Zakaraniya. Nuy mina muy doegampa senawbi zagethoepa, muy aymoeydhin oltanu gimal, ganul thupa. ");
INSERT INTO mwp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wa nuy nanga muynu sensa thayar mura mabaygal adhal thana thoeythu pagemir thanamun pawa kedha. ");
INSERT INTO mwp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nuy nanga si muynu Awgadhaw angela danapa yakamiz nubepa oltaw getha doegamoenu tharaydhin senaw ngalaga nanga ganul thu. ");
INSERT INTO mwp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaraya nanga Angela imadhin nuyn mina koeyma madhu pamadhin a nuydh koey aka gasamoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kasa kay kedha Angela nubepa kedha mulaydhin, ‘Zakaraya, ngi akan maygi Awgadh nuydh karngemidhin nginu thoeythu poegay a nginu ipin bangal thurkiyay kazi imane, a ngidh bangal nuyn nel tharane Yoewane. ");
INSERT INTO mwp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ngi bangal ika dhiw gasamoene kalmel koeyma mabaygal nungu kazimay thonara. ");
INSERT INTO mwp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","‘Nuy ngaru bangal koesimidhe kadaypa mina adhapudhay koey mabayg Awgadhaw parunu. Nuy bangal woenig umal nguki a matha kedha puridhoeral umal nguki. Nungu kazimay thonarngu Maygi Mari nubiya muynu magaw poelaypa nubepa nungu zagethoenu. ");
INSERT INTO mwp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nuydh koey garsar Isoereylaw mabaygal bangal kuniya ruwaymaypa thanamun Kuykupa Mina Awgadh. ");
INSERT INTO mwp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nungu zageth bangal Awgadhaw parunu ngoedhe kedha Elayza, nuy bangal Maygi Mariw magawnu siparuy Kuykulmay yabugud buth pathan. Nuydh bangal mabaygaw ngoenakap lak balbayg poelaypa thathiw ngoenakap thanamun kazipa a matha kedha kawragi mabaygal garthil thoeyaypa balbayginga niyaypa mina mabaygiya. Nuydh mabaygal dhoeynidhaypu balbayginga Kuykulmaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nuy Zakaraya kuniya mulaydhin Angeloepa kedha, ‘Ngath kay midh paru ngulayg kedha, ngalbe bangal kazi gasamoene, kedha zoengu ngay koey thathi a ngaw ipi koey mabayg aymayzinga.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nuy Angela kedha mulaydhin nubepa, ‘In ngay Gabriyel. Ngay mura thonara Awgadhaw parunu kaday sipa a nuydh ngoena ngapa wayanu ngibepa nabi kapu wakayl yangukudu manin. ");
INSERT INTO mwp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ngi kurusipagi, wa ngidh ngaw yangukudul mina yoepathamayginga; a ngidh bangal imane. Itha bangal thabi yangukudul kuykunidhamoeyne mina balbayginga sethabi thonara. Wa, ngibepa kedha, ngi bangal yagig kurusipa senabi thonar gasamoene, kuyk ngidh ngaw ya mina yoepathamayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wa, senabi thonara mura mabaygan ugar Zakarayan, thanamulpa kakal nuy koey kuykuthalnga muynu oltanu. ");
INSERT INTO mwp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nuy nanga adhapadhadhin nuyn yagi paladhin. Wa, thana ngulayg asimoeyn kedha, nuydh adhapudhay za goeygiw piki iman muynu koey yoewthanu, kedha zoengu nuy ya mulayginga. Nuy thanamulpa gethan ya muliz. ");
INSERT INTO mwp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nungu zagethaw thonar nanga muwasidhin muynu koey yoewthanu, nuy kuniya tidaydhin lagoepa. ");
INSERT INTO mwp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Soeyzi moegina dhadhabuth nungu ipi Elisapetha na mapunga aymaydhin. Payb moelpalalnga na matha lagoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na kedha mulaydhin, ‘Ngay mina koey kuykuthalnga kasa uzaraydhin, kazigig kurusipa Kuykulmay ibupuydhan a kozan ngayapa poeyban. Ngayapa lak azirpa lawnga mabaygaw parunu.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapethana nanga siks moelpalal aymoeydhin maythapa, Awgadhan nungu yaday woeyay Angela wayadhin Gabriyelan Galiyoepa, moegina goegath nel Nazareth. ");
INSERT INTO mwp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nubiya yangukudu mer muynu ngoewakazipa, Yoewsepalpa nga nanga gudapa thurayzinga. Nuy Yoewsepa Dhawithan buway mabayg. Nanu ngoewakaziw nel Mariya, kapu akasizi ngoewakaz. ");
INSERT INTO mwp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angela ngapa nabepa kedha mulaydhin, ‘Awgadh ngibeya kalmel a nungu adhapudhay koey woenab.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wa, Mariya nabiya koeygarsar wakay thoemamay, Angelaw yangukudungu. Nadh kedha wakay thayadhin, ‘Ina kow aykap gar sike midh paru.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kasa kedha Angela nabepa kedha mulaydhin, ‘Mariya ngi akag, Awgadhan ngin mina adhapa thamadhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ngi bangal mapunga aymidhe a ngidh bangal thurkuyay kazi gasamane, ngidh bangal nungu nel tharane Yesu. ");
INSERT INTO mwp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nuy bangal mina adhapudhay, a nuyn bangal kedha thoeraypu Awgadhaw Kazi, nuy koey Awgadh gimal. Awgadhan nuyn bangal Mopakuyk aymoene, Dhawitha nanga midh, nungu buway apakuyk. ");
INSERT INTO mwp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nuy bangal Yakubun kaziw kaziw ingaru Mopakuyk, nungu basalaya kuthaginga kuykuginga!’ ");
INSERT INTO mwp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Mariya angeloepa kedha mulaydhin, ‘Ngath bangal midh paru kazi gasamoene, ngay alaygig ngoewakaz?’ ");
INSERT INTO mwp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angela kedha mulaydhin Mariyalpa, ‘Awgadhaw Maygi Mari bangal ngibiya kalmel, a Awgadhaw bibir a woenab bangal ngibiya ngidh bangal gasamoene. Kedha zoenguz nginu maygi kazi bangal kedha thoeraypu “Awgadhaw Kazi.” ");
INSERT INTO mwp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","‘Wa, ngidh nginu tukuyap Elisapethana ngoenanu maypa? Thana waza kedha, “Nabepa kazipa gasamoeypa lawnga.” Kasa kay kedha na nanu geth lak mapunga lak siks moelpalal, na kasa koey apu. ");
INSERT INTO mwp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Awgadhoepa mura za aymoeypa zagethoeginga, mura balbayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Mariya kedha, ‘Ina bangal ngaybiya aymidhe nginu yangukudu ya midh nanga. Wa, ngay mina Awgadhaw zagethaw mabayg.’ Kalanu Angela nan wanadhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angelaw yangukudu kalanu nanga, Mariya wakay thoemamayn gasamadhin nanu tukuyap Elisapethana. Nadh nanu moenari rugal matha thoeray buth pathaydhin kalanu sobaginga uzaraydhin Yoewdhayoepa Elisapethana goegath muynu padaw dhadhabuthanu. ");
INSERT INTO mwp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na nanga mangaydhin si, na muy araydhin Zakarayan lagiya Elisapethana alay. Mariya nan Elisapethana ikan gasamadhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sena namuyth nanga Mariya ikan gasamadhin Elisapethana. Senawbi thonara Elisapethana mapeth ikan dhiwan soersimoeydhin muynu nabiya. Mina senabi thonara na ngulayg asidhin Maygi Mariw zageth nabiya, a Maygi Mariw woenab nabiya ngoena pudhaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na gima gudiya mulaydhin kedha, ‘Wa, Awgadhaw woenab ngibiya, a ngin mina adhapa thamayidhin mura yoepkaziya, a Awgadhaw woenab nginu kaziya senaw ngibiya nanga muynu! ");
INSERT INTO mwp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ina mingu mina adhapudhay za ngayapa aymiz kedha, ngoezu Kuykulmay apu ngayapa ngapa imaypa mema? ");
INSERT INTO mwp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sena namuyth nanga ngath karngeminu nginu ikal yangukudu nguzu mapeth muynu ngaybiya ikan dhiwan katan thoeydhadhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wa, ika dhiw gasamar ina mina matha ngoedhagidh ngidh mina yoepathamadhin Kuykulmay woeyayzi yangukudu ngibiya kuyku nidhane.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya kedha, ‘Ngath ngoezu ngoenakapun Kuykulnga koeyma thawmaypa; ");
INSERT INTO mwp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ngath koey ika gasamoedhin kuyk ngaw Kaludhay Mabayg, Awgadh. ");
INSERT INTO mwp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nuydh ngoena ngoenanu manin ngay nungu parunu koey apal zagethaw mabayg. Koezi kayboengu pawpa mura mabaygal ngoena bangal kedha thoeraypu, “Koey dhiwal yoepkaz.” ");
INSERT INTO mwp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kedha zoenguz kedha adhapudhay Koey Awgadh nuydh mina kapu zageth ayman ngayapa. Ngalpa ngaru koeyma thawmanin nungu maygi nel. ");
INSERT INTO mwp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nuydh nungu pawdh a gabu pawa yakaman ngalpalpa mura mabaygal ngaya nanga apasin nubepa, maykuyk mulupa maykuyk kadaypa. ");
INSERT INTO mwp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nuydh nungu koey bibiril geth woenabalnga, poeraparalnga, adhapa gud paliman gamu dhub yoewruyl mabaygoepa mathamaypa. Thanamun buwayl thoeyay idimoeyn mura. ");
INSERT INTO mwp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nuydh ngulayg Adhapudhay Mopakuykul mulupa thayamoeyn, thanamun kupay zagethoengu. A mabaygal ngaya mina apal nuydh kadaypa mamayin. ");
INSERT INTO mwp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aygi zagi mabaygal nuydh zapun poeybiz, gamul dhiba mamayin, a setha ngaya aydegal a zapulgal thana adhapuydhan gethal aygimayl. ");
INSERT INTO mwp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nungu kulkubaw yawadhayzinga ngalpan thathiw thathipa, nuyn kuyku nidhan kayib. Nuy ngapa Isoereylaw kaziw kazipa ibupuydhaypa ");
INSERT INTO mwp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nuydh ngoenanu manin Abrama, yakaman nungu sib wanan a matha kedha mura nungu kaziw kazipa ngaru a ngaru, nungu kulay yangukudu midh nanga.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya na sike thoeri moelpalalnga Elisapethaniya, wagel kay na kuniya tidaydhin nanu lagoepa. ");
INSERT INTO mwp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na na gasamadhin thonar Elisapethana kazimay thonar, nadh gasamadhin thurkiyay kazi. ");
INSERT INTO mwp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nanu pasiw mabaygal a mura nanu buway karngemidhin kedha, Kuykulmay mina pawa midh, nabepa. Thana mina koey ika gasaman nabiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Urapun wiki kaliya thana mura ngapa mapethoepa motho poethaypa. Wa, thanamun ubi kedha thana nuyn Zakarayan thoeraypa, nungu thathiw nel. ");
INSERT INTO mwp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kasa kay kedha nungu apu kedha, ‘Maygi, nungu nel bangal Yoewane.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Thana kedha nabepa, ‘Buwaynu muynu kedha nelginga!’ ");
INSERT INTO mwp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kalanu thana nungu thathipa geth aymayn yapu poeybemin kedha, ‘Nginu ubilnga mi nel nubepa maypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaraya gethan yadu palgan thusi poelay za, kalanu kedha palan, ‘Nungu nel Yoewane.’ Thana koeyma madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mina senabi thonara nuy Zakaraya balbayg asidhin gudiya ya muliz a nuydh mina koeyma thawmanin Awgadh. ");
INSERT INTO mwp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Thanamun pasiw igalgal mina koey aka gasamoedhin sethabi zapungu. Na ya gud palaydhin adhapa nupa mura senabi padaw lagiya Yoewdhayanu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mura setha ngaya nanga karngemidhin thana ngoenanu madhin senabi zapa a yapu poeybemidhin, ‘Nuy bangal senawbi mapeth mi mabayg?’ Mabaygoepa kakal kedha Kuykulmay woenab nubiya muynu. ");
INSERT INTO mwp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nungu mapethaw thathi Zakaraya, nubiya muynu Maygi Mari, nuydh Awgadhaw ya yadu poelgaypu kedha, ");
INSERT INTO mwp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‘Ngalpa koeyma thawmanin Kuykulnga Isoereylaw Awgadh! Nuy ngapa ngalpalpa ibupuydhaypa a nungu mabaygoepa gudaz puydhaypa. ");
INSERT INTO mwp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nuydh ngalpalpa poeybadhin Adhapudhay Kaladhuy Mabayg Dhawithan buwayngu ngapa, nuy Dhawitha Awgadhaw zagethaw mabayg. ");
INSERT INTO mwp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nuydh mina kulay mulaydhin, a ya wadhadhin nungu maygi peropethaya kedha, ");
INSERT INTO mwp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Nuydh ngalpan gudaz puydhamoeyne mura wati mabaygoengu, a sethabi wati bibiringu mabaygan ngadh ngalpan gegeyadh yawaypa.” ");
INSERT INTO mwp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nuy senawbi thonara thanamulpa mulaydhin kedha, “Nuydh bangal yakaman gabu pawa a pawdh ngalpan thathiw thathipa. A ngoenanu maypa nungu maygi ya woedhayzinga ngalpalpa.” ");
INSERT INTO mwp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ya woedhan koey ridhanga nuydh ayman ngalpan muruygoepa Abramalpa. Nungu koey ridha ya kedha, nuydh gudaz puydhamoeyn ngalpa ngalpan wati mabaygoengu. Nuydh ayman ngalpa nungu zagethaw mabaygal, akapa lawnga mina zageth ayman. ");
INSERT INTO mwp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Lak ngalpa balbayginga nungu adhapa thoemayzimayl, maygi mabaygal nungu parunu, mura ngalpan igililmay goeyginu. ");
INSERT INTO mwp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngaw Kazi ngin bangal kedha thoeraypu, Maygi peropetha, Mina Koey Awgadhaw. Ngi kulay thayiz ngalpan Kuykulmaya Buth pathan yabugud nubepa. ");
INSERT INTO mwp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lak ngidh nungu mabaygal yadu thuriz kedha, thana bangal kedha kuniya gudaz puydhamoeyne, gudwoeyamoeyn thanamun wati pawal. ");
INSERT INTO mwp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ngalpan Awgadh koey pawdhal Awgadh, nuydh ngara pudhamay ngalpan balbay tidaypa mina yabugudiya. Nungu bangal mina kaludhay thonar gasamoene, mura zapul bangal kapu ngoedhalmayl nungu buya nanga zuru pathane na gimaz daparngu, kayin goeyga midh nanga miziz inura nanga ngaya nipa, um koey amadhan, nuydh adhapa yoelpamoeyn mina yabugudoepa, balbayginga gabu pawanu nipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nuy senabi mapeth koesimipu, koey bibirilnga koey magawlnga nungu gamu igililnga a nungu mari. Nuy mabaygoegi dhadhabuthanu niparuy kurusipa nungu thonar gasamoedhin nuy kakal aymoedhin mura Isoereylaw mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Senabi thonara nanga, wara Romaniw adhapudhay mopakuyk meparuy, nungu nel Augustus. Nuydh ya madhin kedha, ‘Mura mabaygaw nelay ngaru getha tiday mabaygoepa poeybamoeyn, mura thanamun goegathiya.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Senawbi thonara thanamun kuyku mabayg sey Siriyaw doegamoenu nel Koewiriniyus. Sena waza thanamun mina koeykoeyne, mabaygaw getha tiday Koewirininsan thonarnu. ");
INSERT INTO mwp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wa, mura mabaygal ngaru thanamun lagoepa, nelpa poeybaypa getha tiday zagethaw mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A thanamuniya muynu Mariyana maku thoeyayzinga Yoewsepa, nuy lak miyaydhin moegina goegathoengu, Nazarethoengu, Galilaya doegamoengu. Nuy kuniya nungu kazimay lagoepa, goegath Bethliyama Yoewdhayanu. Thanamun kulkubaw mopa kuyk Dhawitha lak senawbi goegathoenu kazi madhin, a Yoewsepa nuy Dhawithan buway mabayg. Nuy kedha zoenguz Bethliyamapa miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nubiya kalmel nungu maku thoeyayzi yoepkaz Mariya, palamulpa palamun nelpa mulaypa zagethaw mabaygoepa. Na sinubi thonara mapunga. ");
INSERT INTO mwp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Thana sey Bethliyamanu nanga nanu kazimay thonar gasamadhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nadh nanu kuykuy kazi imadhin thurkuyay kazi. Nadh nuyn dhumawakun nuradhin a powbiyaw lagoenu muynu wanadhin nuyn; kedha zoenguz kedha, thanamulpa waza buthaginga uthuypa mura lagal. ");
INSERT INTO mwp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dhuray mamuy danal poethay mabaygal sey adhal bupanu. Senabi kubilu thana thanamun mamuyl danal pathar. ");
INSERT INTO mwp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kedha nanga thana imadhin Awgadhaw Woeyayzi Angela, thanamulpa tharaydhin, senawbi thonara Awgadhaw buya a poerapar thanamuniya nagaydhin. Wa, thanamun mamuy danal poethay mabaygaw aka mina koey zapul. ");
INSERT INTO mwp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kasa kay kedha nuy Angela kedha mulaydhin, ‘Ngitha akan maygi, ngath kapu yangukudu oengaypa ngithamulpa a matha kedha mura mabaygoepa, ikal dhiwal yangukudu. ");
INSERT INTO mwp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","In nubi goeyginu ngithamulpa ngithamun Kaludhay Mabayg dan adhanu, sey Dhawithan goegathanu. Nungu nel Keriso, ngithamun Kuykulnga, Awgadhaw Mina Adhapa Thamayzinga. ");
INSERT INTO mwp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ngithamulpa bangal kakal, ngitha bangal nuyn mapeth imane powbiyaw lagoenu muynu nuy dhoemawakun abayzinga. Nuyn Awgadhan kedha maku thayadhin.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Senabi thonara koey garsar daparaw angelal danapa yakamoeydhin. Thana na puyamar Awgadhoepa thawmaypa kedha, ");
INSERT INTO mwp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‘Awgadh nuy ngaru woenabaw a poerapoeraw Awgadh sey gimal dapara, a in apal kapu woenab, a pawdh ngithamulpa; minguz kedha, mabaygal nanga balbayginga Awgadhaw purkapa.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Thana nanga angelal kuniya tidemidhin daparpa, thana mamuy danal poethay mabaygal mulemin kidhakidhan, ‘Ngalpa ladhuypa, Bethliyamapa senabi zapa purkaw imaypa, Kuykulmaypa midh na mulaydhin ngalpalpa.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Thana sobaginga ladhudhin; imadhin Mariya a Yoewsepa a mapeth muynu poebiyaw lagoenu yoewir. ");
INSERT INTO mwp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Thana nanga mamuy danal poethay mabaygal mapeth imadhin, thana yadu thuray aymoedhin aputhathipa, Angela thanamulpa midh na umamoeyr senawbi mapeth yadu palgadhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mura mabaygal ngadh na karngemidhin thana koeyma madhu pamemidhin mamuy danal poethay mabaygal midh na umamoeyr thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya mina koeyma ngoenanu mamayidhin sethabi yaday a koeyma kuykunu wanamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Thana nanga mamuy danal poethay mabaygal kuniya tidemidhin, thana koeyma thawmadhin Awgadh, thana midh na karngemidhin a imaydhin, angelal midh na umamoeyr thanamulpa. ");
INSERT INTO mwp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Urapun wiki kaliya, thonara nanga gasamoedhin moegina mapethoepa motho poethaypa, thana nuyn nel tharadhin Yesun, angelaw poeybayzi nel. Wagel kay Mariya maythalayg, angela kulay Mariyalpa mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Thanamun senabi thonaraw igililnga kedha, Mosen minar poelayzimaynu muynu kedha, ‘Matha kuykuy garkaz kazil ngaru Awgadhoepa kuniya poeyban a eso manin.’ Mariya nanga puduya adhadhin palay Yoewsepaw kazi oengadhin Yoerusalemaw koey yoewthoepa, Awgadhoepa yadu poelgaypa, a eso maypa. ");
INSERT INTO mwp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Palay sipa aymoeypa mura sabiw yawoeydhayzinga midh nanga, ukasar moegina uruy ngaru Awgadhoepa mamaman. Sethabi moegina uruyl goeynaw ngoedhalmayl. ");
INSERT INTO mwp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Senawbi thonara Yoerusalemoenu mabayg meparu, nungu nel Simiyon, nuy mina Awgadhiya gathil thoeyayzi mabayg a Maygi Mari waza nubiya kalmel. Mura nungu thoeythu poegaynu muynu ubi kedha, kurusipa bangal nungu danal Isoereylaw buway koerkak badh bangal balbayg asine; ");
INSERT INTO mwp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","kalmel nubiya Maygi Mariw ibupuydhay, kuykunidhaypa Awgadhaw Adhapa Thoemayzi Mabaygoepa imaypa, wagel nungu kuth. ");
INSERT INTO mwp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maygi Mari yoelpadhin Simiyonan koey yoewthaw boeradharoepa muypa senabi thonarnu. Senabi thonaraw Yoewsepaw Mariyaw palay palamun kazi Yesun yoewthiya muy thayadhin mura zapa balbayg poelaypa, thanamun sabi midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon nuydh kazi thoeridhaydhin nungu gethan palamulngu, gamupa gasamoedhin a Awgadhoepa eso pugaydhin kedha, ");
INSERT INTO mwp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","‘Kuykulnga, ngidh nginu yawoeydhayzinga kuyku nidhan, a ngaw zageth ina apal mura muwasin; ngidh ngoena pawoeyar mura kay balbayginga, matha kedha nginu kulba yangukudu midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Minguz kedha, ngath ngaw purkan iman nginu Adhapa Thamayzi Gudaz Puydhay Mabayg. ");
INSERT INTO mwp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Ngidh nanga mura mabaygaw danal buth pathadhin kedha, nuy bangal nginu buya mekath azaz mabaygoepa yakamoeypa, nginu mina igililmay yabugud, a adhapudhay woenab a poerapar yakamoeypa Isoereylaw mabaygiya.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Palay kaziw aputhathi mina koeyma madhu pamemoedhin Simiyonan yangu, palamun kazipa. ");
INSERT INTO mwp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kalanu Simiyon kuyku nidhadhin thanamuniya a kaziw apupa kedha mulaydhin, ‘In nubi kazi adhapa thamadhin Awgadhaw koey zagethoepa aymoeypa. Nungu may dhuray bangal Isoereylaw mabaygal mulupa idimpu a dhuray bangal kadaypa gasamipu. Nuy bangal ngoedhe Awgadhaw maku thoeyayzinga, kasa kay kedha koeygarsar mabaygal nubepa kuniya lak bangal koey dharadh umamoeypu. ");
INSERT INTO mwp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Minguz kedha, thanamuniya wara wati wakay thamamay muynu Awgadhaw Sey Sithamayzi Mabaygoepa. Wa, thanamun kedha wati wakaythamamayil bangal kakal aymidhe. Nginu koerkak badh a ngoenakap mapu bangal adhapudhay koeyza ngoedhe nginu ngoenakapoenu kulka yoewdhepu.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wa, senabi thonara lak mina koey apu peropetha meparu; nanu nel Ana na Panuwelan kazi, na Asan buway mabayg. Na 84 wathalayg a nanu alay mina kulkub um miyaydhin, palamun niyaypa yoelpay wathal matha seben mura. Kalanu nadh yoewth gamupa gasamoedhin. Kubilu goeyga na aygudoeginga matha thoeythu pagepu. ");
INSERT INTO mwp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na balbayginga mina senabi thonara mangaydhin, Awgadhoepa eso pugaydhin Kazipa, a mulaydhin kapu ya Kaziw doegumuya mabaygan ngaya nanga ugadhin Awgadhaw thonara Yoerusalemoepa gudaz puydhaypa. ");
INSERT INTO mwp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kalanu palay Mariyaw Yoewsepaw mina mura aymoedhin Awgadhaw poeybayzi sabiw ubilnga, kalanu thana kuniya tidemidhin thanamun lagoepa, Nazarethoepa Galilayoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nuy kazi si koesimadhin, koey magawlnga, a mina koey gudal ngulayg moegina kaz, a Awgadhaw woenab nubiya kalmel mura thonara. ");
INSERT INTO mwp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wa, mura woethiya Yesun apu thathi Yoerusalemoepa memampu Kaludhay Ay Aymay thonarpa. ");
INSERT INTO mwp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu nanga toewalob wathalayg aymoedhin thana lak memayidhin thanamun pawa midh nanga; ");
INSERT INTO mwp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ay aymay nanga muwasidhin, thanamun mab kuyk aymaydhin lagoepa kuniya, kasa kay kedha Yesu nuy yaw pugaydhin kuniya Yoerusalemoenu. Nungu apu thathi koerawayg kedha nuy palamun mabaygiya kalmel oesiginga. ");
INSERT INTO mwp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Palamun wakay thoemamaypa kedha, nuy mabaygaw mopanu kalmel, palay kedha zoengu kay woenag. Kurusipa kutapa palay lumadhin nuyn palamun igalgoepa a tukuypoepa yapupoeybemar. ");
INSERT INTO mwp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Palay nuyn yan lumar, kalanu palay kuniya tidemoedhin Yoerusalemoepa, nuyn lumadhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kurusipa thoeri goeygilnga nanga palay nuyn imadhin muynu koey yoewthanu. Nuy nir thanamun yoewthaw sabiw ngurpay mabaygiya, kurusipagay thanamulpa, a yapu poeybay mura moegithap sabi muynu. ");
INSERT INTO mwp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mura setha ngaya nanga nungu yoepa kurusipagemir nuy kuniya midh nanga umay thanamulpa ngurpay mabaygoepa, thana mina madhu pamemidhin kedha, nungu ngulayg mina koeyza. ");
INSERT INTO mwp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nungu apu thathin nanga nuyn imadhin koey yoewthanu muynu, palay mina madhu pamemidhin. Nungu apu kedha nubepa, ‘Ngoezu kazi, ngidh midh paru kedha aymoenu ngalbelpa? Nginu thathi a ngay, ngidh ngalbe mina wakay thoemaypa mamamoenu imaypa lumarngu ngin.’ ");
INSERT INTO mwp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nuy kedha palamulpa, ‘Mingu ngipel ngoena lumarngu? Ngipel nay ngulayg kedha ngay ngaru Ngaw Thathiw lagoenu muynu?’ ");
INSERT INTO mwp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kasa kay kedha palay tidayginga nungu ya nuy palamulpa kuniya midh nanga mulaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nuy kalanu asidhin palamuniya kuniya Nazarethoepa, a koey kurusipoegayl kazi palamulpa. Nungu apuwan mura thabi zapul thabi ngoedha thoeyay nanu ngoenakapoenu muynu gasamoeypu. ");
INSERT INTO mwp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu koesimaydhin kalmel koey ngulayg a gamu magaw mina balbayginga Awgadhaw parunu a mabaygaw parunu. ");
INSERT INTO mwp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yoewanen zageth kedha kuykaymaydhin. Senabi thonara Taybiriyoes thanamun Romaniw mina mopakuy. Nuy 15 wathalnga kuyk thanamun. Nubiya apal puwa kuyku mabaygal kedha, Pontiyas Pilatho Yoewdhayalgaw kuykulnga, a Erodh nuy Galilayaw kuykulnga. Nungu tukuyap Pilip nuy kuykulnga thabi koey goegathoepa, Ithuriya a Trakonaytiz, a koey goegath Abilene thanamun mopakuy Laysaniyas. ");
INSERT INTO mwp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Thanamun Yoewdhayalgaw kuyku misnare sepalbi thonara Anas a Kayapas. Wa, palamun thonara nanga Awgadhaw yangukudu ngapa Yoewanelpa, Zakarayan kazipa, nuy mabaygoegi dhadhabuthoenu. ");
INSERT INTO mwp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nuy mura maw tharepu muynu Yuridhaw Koesaw dhadhabuthiya. Nuy kedha umepu, ‘Adhapa ngithamun wati igililmay pawangu, adhapa garthil thayemiw a ngapa papthayso moeypa ngithamun wati pawapa mura gud woeyaypa.’ Mabaygal ngaru paptayso mamayin garthil thoeyaypa thanamun wati pawangu, a thanamun wati pawal mura gud woeyamoeyn, a mura garwalgamoeyn; Awgadhan guythuyan senabi gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mina kay paypa kulay Awgadhaw kulba peropethan, Isaya minar paladhin kedha, ‘Yangu wakay poegaypa muynu bupanu mabaygoegi dhadhabuthanu, “Buth pathaw, balbay tidaw senabi ruwayl yabugud, Kuykulmaypa mabapa. ");
INSERT INTO mwp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mura muydhal bangal gud mathamoeyne, mura bangal moegina padal a koey padal apa thoeyamoeyne. Ruwayl yabugudal mura bangal balbay tidamoeyne, mura sethabi wati yabugudal ngaru bangal balbay tidamoeyne Kuykulmaypa mabapa. ");
INSERT INTO mwp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wagel kay mura mabaygan imane kedha, Awgadhaw Gudaz Puydhay Mabayg mangedhe koey poeraparoelnga.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nuy Yoewane adha min tidar kedha thanamulpa setha mi mabaygaw moeyay ngapa nubepa thanamulpa paptayso moeypa, ‘Ngay madhupamiz ngitha yoewthaw mabaygal ngapa ngayapa. Ngithamun mari igililnga ngithamulpa balbayginga lawnga midh? Ngitha midh paru ngulaygal kedha, ngitha lak kedha ngaru koey poeypiyam Awgadhaw thabukiringu? Nungu thonar senaw ngapa ngithamulpa, kasa kay kedha ngitha matha kedha mina nanga thabul muyngu akan pungamoeypa! ");
INSERT INTO mwp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngitha kedha mulayg, “Ngoey Abraman buway, Awgadhaw mina mabaygal.” Sena kasa ngithamun geth wakay thamamay; Awgadhan ngulayg ngitha adhal waniz kupayngu, a wara mabaygal muy arimoeyn, ngithamun buth manin. Awgadhoepa zagethoeginga kedha, nuydh mabayg ayman thabi kulangu, Abramalpa kazil. ");
INSERT INTO mwp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngitha a mura mabaygal matha kedha puy midh, thurik senaw buyal woeydhaypa poethaypa sethabi puypa, apa kuykuya pathaypa sipiya; puyn nanga mina koewsan mayginga, nuyn adhapa pathan a muypa thayan.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Thana mabaygal nubepa yapu poeybemir kedha, ‘Wa, kedha midh, ngoey bangal midh memayine?’ ");
INSERT INTO mwp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nuydh Yoewane sakar pudhaydhin thanamulpa kedha, ‘Nginu nanga ukasar koey sodh, matha ngoedhagidh ngidh poeybar urapun nubepa senaw nga nanga zagig a matha kedha ay, senaw nga nanga aygig, ngidh poeyban nubepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bokadhzoengu garwoeydhamay mabaygal lak kedha ngapa, nubepa thanamulpa paptayso maypa. Thana kedha nubepa, ‘Ngurpay mabayg, ngoey bangal midh memayine?’ ");
INSERT INTO mwp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nuy kedha thanamulpa, ‘Bokadhzangu garwoeydhamay nanga, kasa balbaygi bokadhza mar mabaygoengu, kuyk ngithamun sabi midh nanga. Lak wara bokadhzapul pasinu maygi.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Koewbu mabaygal lak kedha yapu poeybemir, ‘Wa, ngoey bangal midh memayine?’ (Thanamun koewbu mabaygal matha kedha kunumay mabaygal.) Nuy kedha thanamulpa, ‘Koey kuyk woelayg mabaygoepa, a thanamulngu bokadhzapul koey dharadh maygi, aka poelayg thana, kuyk ngithamun sole yaday ngithamun kuyku mabaygoepa. Ngitha moegina bokadhza gasampa ngithamun zagethaw modhabiya, sena matha ngoedhagidh ngithamulpa.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mura sethabi thonara mabaygan koey garsar wakay thoemamaydhin kedha, ‘Yoewane sike Awgadhaw Mina Adhapa Thamayzinga, Keriso.’ Kuyk thana Kerisolpa thural yawaypu, a moeydhemipu nungu moengaypa. ");
INSERT INTO mwp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoewane nuy mura gudiya mulaydhin thanamulpa mura kedha, ‘Ngay koey mabayg lawnga, ngath ngitha kasa ngukin paptayso mamayipa, kasa kay kedha ngaybiya nga nanga ngapa wagel, nuy ngaybiya mina adhapudhay nungu poerapar koeyza. Ngay matha ngoedhagidh lawnga nungu azaz sanaw urikampa dhoerdhimaypa. Ngath nabi thonara ngitha matha ngukin papthayso mamayipa, nuydh bangal kay ngitha mina papthayso mamayipu, a nungu papthays mina wardh. Nuydh bangal Maygi Mari ngithamuniya woenaypu. ");
INSERT INTO mwp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","‘Senabi goeyga bangal na ngoedhe kedha ayboewdhaw thonar midh nanga, Mina Apaw Lagaw Mabayg bangal mangedhe, nubiya nungu zagethaw rug a nuydh bangal dhadhiya dhadh mamayine mina kunaw kapul a wati zapul, ayngu noeral. Ayngu noeral, bupal nuydh adhapa mamayin, adha mulan ingaru muypa thayan. Mina zapul ayde aymoeyn, sawalagoenu waniz.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Matha ina lawnga, nuydh lu palepu thana koeygarsar sakaral yakamoeypu thanamun mina igililmaypa, a koerngaypa Awgadhaw mina yangukudu. ");
INSERT INTO mwp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nuydh matha kedha thanamun kuyku mabayg Erodhalpa koey dharadh mayparuy kuyk nuy nungu tukuypaw ipi gamupa thamadhin nubepa ipi. Nanu nel Erodhiyas. Erodh nuydh pasinu wara wati zapul aymoeypu. ");
INSERT INTO mwp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kalanu nuydh adhapudhay gegeyadh aymoedhin, Yoewanen kunumay lagoenu thayadhin. ");
INSERT INTO mwp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wagel kay Yoewanen kunumay lagoenu thayadhin nuydh kulay paptayso mamayidhin mura mabaygal. A thanamuniya kalmel Yesu lak kedha ngapa Yoewanelpa nubepa papthayso maypa. A nungu paptayso kalanu nungu thoeythu poegay. Balbayginga senawbi thonara dapar gud pudhaydhin, ");
INSERT INTO mwp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","A sizi ngapa mulupa Maygi Marin uruy gamu ngoedha madhin a nubiya gimal aymay, a matha kedha yangu wakay ngapa daparoengu kedha, ‘Ina Ngaw Geth Mamal Kazi, nuy ngayapa mina matha ngoedhagidh.’ ");
INSERT INTO mwp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wa, senabi kalanu Yesu nungu zageth kuyk aymoedhin nungu wathal sey kedha thoerti. Nuy midh thonara moegina mapeth mabaygoepa kedha nuy Yoewsepan kazi. Yoewsepa nuy Elin kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nuy Mathathan kazi, Mathatha nuy Lebin kazi, Lebi a Melkin kazi, Melki nuy Zanayn kazi, Zanay nuy Yoewsepan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoewsepa nuy Mathathayasan kazi, Mathathayas Aymosan kazi, Aymos a Naman kazi, Nama Eslin kazi, Esli Nagayn kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay Mathan kazi, Matha Mathayasan kazi, Mathayas Seman kazi, Sema Zosikan kazi, Zosika Zodan kazi, a Zoda Yonan kazi, a Yona Resan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Resan Zerubaybelan kazi, Zoerababel Seyaltiyalan kazi, a Seyaltiyal Nerin kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriya Melkin kazi, a Melki Adin kazi, Adi nuy Kosaman kazi, Kosama Elmadaman kazi, Elmadama Eran kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Era Zosuwan kazi, a Zosuwa Elayzan kazi, Elayza Zoriman kazi, Zorima Mathathan kazi, Mathatha Lebin kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi Simiyonan kazi, Simiyon Yudhan kazi, Yudha Yoewsepan kazi, Yoewsepa Yonaman kazi, Yonam Elikaman kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elikam Mileyan kazi, Mileya Menan kazi, Mena Mathathan kazi, Mathatha Nathoenan kazi, Nathan Dhawithan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dhawitha Zesin kazi, Zesi Obedan Kazi, Oben Bowazan kazi, Bowaz Salmonan kazi, Salmon Nasonan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason Aminoedaban kazi, Aminoedaba Adiminan kazi, Adimin nuy Aronan kazi, Aroen nuy Ezronan kazi, Ezron nuy Perezan kazi, Perez nuy Yudhan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudha Yakubun kazi, Yakubu Isakan kazi, Isaka Abraman kazi, Abrama Teran kazi, Tera nuy Nayon kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nayo Serugan kazi, Serug nuy Rewan kazi, Rewa nuy Pelegan kazi, Peleg Eberan kazi, Eber Selan kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela Kananan kazi, Kanana nuy Arpakasan kazi, Apakas nuy Seman kazi, Sem nuy Nowan kazi, Nowa Lamekon kazi. ");
INSERT INTO mwp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameko nuy Matuselan kazi, Matusela nuy Enokan kazi, Enoka nuy Zaredan kazi, Zareda Malalelan kazi, Malalel Kananan kazi, ");
INSERT INTO mwp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keynana Enosan kazi, Enos Sethan kazi, Seth Adhaman kazi, a Adham Awgadhaw kazi. ");
INSERT INTO mwp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesun papthayso kalanu nuydh Yuridhaw Koesangu uzaraydhin a Maygi Mari nubiya muynu magaw paladhin a nuyn yoelpadhin mabaygoegi dhadhasakarpa. ");
INSERT INTO mwp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Si Sathana Yesun nuthadhin poti goeygilnga a senawbi thonara nuy aygudagig, kutanu nungu maytha mina ayginga. ");
INSERT INTO mwp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wa, Sathana ngulayg, nuy ngapa Yesulpa a kedha mulaydhin, ‘Ngi nanga Awgadhaw Mina Kazi, koey bibiril mabayg ngidh nabi kula kidh thoeyaypa ngibepa aypa, nginu geth yangukudun.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu nubepa kuniya buwayl thayaydhin, mamayidhin Maygi Thusiw yangukudul kedha, ‘Mabayg lawnga matha ayngu igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kalanu Sathanan nuyn kadaypa yoelpadhin koey gimapa, danthayadhin nubepa mura nubi gugu ubidh thoeyayzinga a nanu basalayal muynu. ");
INSERT INTO mwp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nuy kedha Yesulpa, ‘Mura itha ngath kay ngibepa poeybamoeypa kalmel woenab a poerapar a ngath kay ngin aympa Kuykulnga thanamulpa, ngidh kay ngoena nanga thawmaypa a kulun pasoeynipa ngayapa. Kedha zoenguz kedha ngoena kuyk aymoedhin mura itha thabi adhapudhay zapul a ngay kupaylayg kedha, ngath ngulayg ngibepa poeyban ina a matha kedha wara mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kuniya mulaydhin Sathanalpa, ‘Lawnga, kedha lawnga Maygi Thusinu muynu kedha, “Ngidh matha nginu Kuykulnga Awgadh thawmaypa a matha nubepa apa pudhemipa. Matha nuy urapun.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kalanu Sathana nuyn madhin Yoerusalemoepa koey yoewthoepa. Nuydh nuyn yoelpadhin mina koey gimanoeka thodhapa, kalanu kedha mulaydhin nubepa, ‘Ngi nanga sike Awgadhaw Kazi, katpoelag koezi mulupa. ");
INSERT INTO mwp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wara Minar Poelayzinga Maygi Thusinu muynu kedha, “Awgadhan kay woeyamoeypa nungu danal poethayzi angelal. ");
INSERT INTO mwp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ngibepa kadaypa gasamoeypa thanamun gethan nginungu kulangu panoenamoeyle nginu ngarangu.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu kedha nubepa, ‘A, kasa kay wara mina yangukudu kedha, “Maygi ngidh nuthan nginu Kuykulnga Awgadh.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wa, Sathana nanga nuydh mura nungu nuthay zageth muwasidhin nuydh kalanu Yesun wanadhin moegina buthapa. ");
INSERT INTO mwp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu nuydh gasamoedhin Maygi Mariw bibir zagethoepa; kalanu kuniya tidaydhin Galilayapa. Nungu ya mura zilmaydhin sethabi goegathiya. ");
INSERT INTO mwp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nungu zageth nuydh ngurpan, matha ayimpu muynu thanamun yoewthal, mura goegathiya. Mabaygan nuyn mura thawmayparuy. ");
INSERT INTO mwp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kalanu Yesu uzaraydhin Nazarethoepa, nuyn ngalaga na koesimoeydhin. Wa, sabadhaw goeyginu nuy uzaraydhin yoewthoepa amenipa, nungu pawa midh nanga. Si muynu nuy kaday tharaydhin Maygi Thusipa getha tidaypa, mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Thana nubepa madhin Isayan Minar Poelayzinga thusi. Nuydh gud pudhadhin a imadhin ngalaga nanga Minar Poelayzinga kedha, ");
INSERT INTO mwp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Kuykulmay Maygi Mari ngaybiya muynu. Nungu ubilnga ngay, ngath nungu kapu yangu wakaypa yadu poelgaypa mabaygoepa mura. Gamu ayginga gamu zaginga. Nuydh ngoena wayan gud idhuypa mabaygal ngaya gegeyadh nipa, yatharayzimayl; a matha kedha maygumal lak purkaw zuru bangal kuniya gasamoene; a pa woeyamoeyne bangal mabaygal ngaya nanga gegeyadh gasampa. ");
INSERT INTO mwp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A ngath bangal mina thonar yadu palgane, Kuykulnga mi thonara bangal nungu mabaygal kaludhamoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu tupal thayan thusi a kuniya manin zagethaw mabaygoepa. Kalanu apa thanuriz nungu mawpa, thanamun pawa midh nanga. Mura mabaygal yoewthanu matha nuyn yawayar. ");
INSERT INTO mwp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nuydh nungu ngurpan muyngu thusingu yadu palgan, ‘In nubi minar poelayzi yangukudu kuykunidhan, ina nabi thonara. Ngitha nan kawran karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mura mabaygan madhu pamemidhin kedha, nungu yangukudul mina adhapudhay. Thana kidhakidhan kedha mulemidhin, ‘E! Nuy ngoedhe koey mabayg koey ngulayg pawdhal yangukudu mulayle. In mina nuy Yoewsepan kazi; nuy midh paru nungu geth kadaypa thamepa?’ ");
INSERT INTO mwp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nuy thanamulpa kuniya mulaydhin kedha, ‘Wa, ngayapa kakal kedha ngithamun wakay thoemamay midh. Ngitha karngemidhin mura setha zapul ngath aymoeydhin Kapoeniyamoenu a ngithamun wakay thoemamay kedha, Nubi mabayg matha ngoedhagidh mayginga kedha adhapudhay zagethoepa aymoeypa ina. Kulba yangukudu waza kedha, “Dokta, ngidh ngaru kulay nginu geth gamu balbayg tidan, a matha kedha nginu geth mabaygaw gamul.” Wa, na kedha kuniya Ngitha karngemidhin mura setha zapul ngath aymoeydhin Kapoeniyamoenu a ngithamun ubi ngath lak adhapudhay zagethal kow aymoeypa, kasa kay kedha ngitha ngoena mina yoepathamayginga aymipa. ");
INSERT INTO mwp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngay kedha zoenguz ngithamulpa kedha, mura mabaygal thana peropeth ayawal mayginga muynu nungu goegathoenu. ");
INSERT INTO mwp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Kulba peropethal lak kedha matha moenari thanamulpa kurusipagemipu. Peropeth Elayzan thonarnu nanga, dapar mura thamudhaydhin ariginga thoeri wathalnga a sikis moelpalalnga mina aygi thonar mura ngalpan goegathiya. Ngalpan yoepkaz maykal koey garsar maythaygin memayipu senawbi thonara ina Isoereylanu, ");
INSERT INTO mwp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kasa kay kedha peropeth Elayzan thanamulpa woeyayginga. Awgadhan nuyn wayadhin maykoepa, wara goegathoepa muynu Sidonoenu, goegath nel Zarepath. ");
INSERT INTO mwp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","‘Wara peropeth Elisan thonarnu lak kedha wati goengawl kikirilgal koeygarsar Isoereylanu, kasa kay kedha wara thanamulngu mabayg dhoeynidhayginga, Siriyalayg Naman adhaw mabayg nuyn dhoey nidhadhin.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Thana nanga Yesun thabi yangukudu karngemidhin, thana thabukirin kaday nithamadhin. Thana sobaginga adhapa wayadhin nuyn thanamun goegathangu kalanu gimal pawaw guypa. Thanamun ubi thana nuyn padoengu mulupa thayan padaw dhadhasakarpa, mina koey gudalnga. Kasa kay kedha thana yan ayman. ");
INSERT INTO mwp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nuy mabaygaw kubinu dhadhal araydhin a uzaraydhin adhapa. ");
INSERT INTO mwp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu nuy uzaraydhin Kapoeniyamoepa, na wara goegath, Galilayoenu muynu. Wara nuydh Sabadhoenu mabaygal ngurpamoeyr. ");
INSERT INTO mwp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Thana mina madhu pamemidhin nungu ngurpayngu, kedha zoenguz kedha nuy mina akaginga nungungu maw tharepu. ");
INSERT INTO mwp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wara mabayg thanamuniya yoewthanu muynu wati mariw moelayzinga muynu. Nuy mina koey gimiya ar pugay kedha, ");
INSERT INTO mwp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‘E! Ngi mipa ngoeymulpa ubin mepa, Yesu Nazarethoelayg? Ngi ngapa mipa, idimaypa ngoeymulpa? Ngay ngulayg ngi nga nanga, ngi Awgadhaw Maygi Mabayg, Mesiya!’ ");
INSERT INTO mwp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kalanu Yesu kedha puridharalnga mulaydhin, poeybiz wati maripa, ‘Yagi asir! Ngapa adhapadhar mabaygoengu!’ Wati marin nuyn mabayg mulupa thayan boeradharoepa thanamuniya parunu, adhapadhan nungungu mabaygoengu. Wara za gegeyadh mayginga nubepa kuniya. ");
INSERT INTO mwp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mabaygal mina koeyma madhu pamemidhin, kidhakidhan mulemin kedha, ‘Setha midh paru, sethabi yangukudul nungu; nungu kupaynu, a koey bibirilnga nuy ya muliz wati maripa, a thana maril ngulayg dhanamiz mabaygoengu muyngu.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Senabi za Yesu aymoedhin, ya mura zilmaydhin muynu sethabi goegathiya. ");
INSERT INTO mwp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nuydh Yesu wanadhin yoewth, Simonan lagoepa uzaraydhin. Simonan yoepkaz ira si muynu koey sumaylayg. Si thana nanu kikiriw yadu thuran Yesun. ");
INSERT INTO mwp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wa, nuy uzariz a nanu uthuy lagoenu pasinu tariz. Nuy ya muliz kedha, ‘Kikir adhapa nanunguz!’ Wa, nanu gamu thoew asin, kikiriw nan wanan. Na sobaginga kaday tariz a ayman zageth mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Goeyga na pudhiz nanga, mura ngoenu igalgal na kikirilgal, kobegadh kikirilgal thana Yesulpa ngapa mamayin; nuydh geth gimal wanar thanamuniya mura balbay tidamoeyr. ");
INSERT INTO mwp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wati maril lak kedha nuydh adhapa mamayir koey garsar mabaygoengu. Thana ar pugemir kedha, ‘E! Ngi Awgadhaw Kazi!’ Yesu mulaydhin thanamulngu ya mulayle, kedha zoenguz kedha thana ngulaygal kedha nuy Awgadhaw Woeyayzi Mabayg, Mesiya. ");
INSERT INTO mwp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Goeyga na miziz nanga Yesu nuydh senabi mudhaw lag wanan, nuy uzariz adhapa yagi doegampa, kasa kay kedha mabaygan nuyn luman. Thana nanga nuyn iman thanamun ubi kedha nuy kay sin thanamuniya, thanamun ubiginga nubepa maboepa wadgoepa. ");
INSERT INTO mwp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yesu thanamulpa kedha, ‘Lawnga, ngay ngaru maw sipa ina nabi kapu ya Awgadhaw. Ngay ngaru wara mudhaw lagoepa, matha ina lawnga. Awgadhan ngoena kedha zagethoepa ngapa wayadhin aymoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wa, nuy maw siparuy mura goegathaw yoewthiya war kuniya, a wara kuniya. Nuy mura Yoewdhayalgiya. ");
INSERT INTO mwp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wara goeyginu Yesu nuy malu buwadhoenu mer. Malu nel Genesareth. Nuy si sir kasa kedha mabaygaw moeyay mina koeyza mamu zug nanamoeyr nubiya mura doegamuya. Thana nungu mawpa koeyma ubin memayir, Awgadhaw yoepa koerngaypa. ");
INSERT INTO mwp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nuydh ukasar wapi gasamay but imamoedhin thawala gimal. Thana wapiw zagethaw mabaygal kay adhal thawala; thana pingel garwalgamoeyr. ");
INSERT INTO mwp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wara wapiw gasamay mabayg thanamulngu nel Simona. Yesu pathaydhin Simonan butanu a nubepa muliz kedha, ‘Ngidh gar moegina adhapa, guythuyaypa nan but lagaw buwadhoengu?’ Wa, nuy Yesu si pathaydhin. Nuy apa thanuraydhin a nuydh ngurpay ayman thanamulpa, mura mabaygoepa, adhaz malungu. ");
INSERT INTO mwp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ngurpay na muwasin nanga Yesu kedha mulaydhin Simonalpa, ‘Ngitha nan but adhapa thapar malupa, pingepa lak thoeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nuy Simona kedha mulaydhin, ‘Kuyku Mabayg, ngoey mura kubilu koeyma nuthemirngu wapipa, kubil kuthal marngu kasa moegan wapiginga, kasa kay kedha, nginu ya ngath kay pinge thoeyaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kalanu thana thayamoeydhin pingel. Thana wapil mina koeygarsar gasamoeydhin, pingel mina amadhan pakadamay. ");
INSERT INTO mwp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Thana thanamun zagethaw igalgoepa geth aymoeyn wara butangu thanamulpa ibupudaypa. Kalanu sepalbi but mura gudiya yoewdhiz wapilnga, mina amadhan dudupay. ");
INSERT INTO mwp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Petherulpa kakal kedha ina ngadha thoeyay mina wardh, nuy kulun pasayniz Yesuniya parunu, a kedha mulaydhin, ‘Kuykulnga, ngi ngawngu uzar, ngay kasa wati pawa mabayg, ngay ngibepa matha ngoedhagidh lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nuy a nungu zagethaw igalgal, thana mina koeyma madhu pamemidhin kedha, gasamayzi wapil mina koey garsar. ");
INSERT INTO mwp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zemes a Yoewane ukasar kuyk kazi Zebadin, palay wara butaw mabayg. Palay a Simona mura thonara zageth kazil. Palay lak kedha mina madhu pameman. Yesu kedha mulaydhin Simonalpa, ‘Ngi akan maygi, ngitha bangal ngaw pingew thoeyay mabaygal kedha zagethoepa, ngitha bangal mabaygal garwoeydhamoeypu.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Thana palbi but kadaypa yoewthemoedhin thawaliya, mura zapul wanaydhin, kalanu Yesuniya wagel asimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wara thonara nuy Yesu mudhaw lagoenu; nuy mabayg si kikirin pungaypu, wati goengawl kikirilayg. Nuydh kikiril mabaygan Yesun imadhin, nuy ngapa nubiya kulun pasayneydhin. Nuy yoewdhaydhin Yesuniya kedha, ‘Kuykulnga nginu ubi nanga ngibepa zagethoeginga kedha, ngidh ngoena balbayg poelaypa; a ngaw gamu bangal pudhunga aymiz.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu nanga nuyn imadhin nungu mina koeyma koerkak badh miyaydhin. Nuydh nungu geth luwayadhin a gasamoedhin nuyn a kedha mulaydhin, ‘Wa ngaw mina ubi kedha ngath kay ngin balbayg poelaypa. Ngi balbayg asir kedha thonar nginu kikiringu.’ Mina sobaginga nuy balbayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kalanu Yesu nubepa koeyma mulaydhin kedha, ‘Wara mabaygoepa mulayg, ngi balbayginga uzar misnarepa nuydh kay ngin zoeyzoeynidhepa a mina yapathamaypa kedha, ngi balbayg asin. Sew kalanu kay ngi mer koey yoewthoepa aymaypa nginu eso uruy poeyban; ina Mosen Sabi yawoedhayzinga, mura mabaygoepa imaypa kedha ngi balbayginga mabaygiya oesipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wa, Yesu nuyn gud wadhadhin kasa kay na ya pungaypu mabaygiya adhapa war lagiya. Mabaygal na karngemipu nanga thana ngapa nubepa koerngaypa, koey garsar mabaygal. Thana ngapa toedipu koerngaypa Yesun mina ya a nubepa thanamun kikiril mabaygoepa balbayg tidaypa. ");
INSERT INTO mwp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nuy ngaru adhapa thamepu yagi dhadhabuthoepa, lak nuydh mina thonara gasampu nungu Thathipa thoeythupoegaypa. ");
INSERT INTO mwp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wara goeyga Yesu ngurpay aymar mabaygoepa. Dhuray Parasayalgal a sabiw ngurpay mabaygal lak si nir. Thana garwoeydhamoeydhin mura goegathoengu, Galilayoengu, a Yoewdhayangu, a matha kedha ngapa Yoerusalemoengu. Kuykulmay woenab koey bibirilnga ngaru Yesuniya senabi thonara kikiril mabaygoepa balbay tidaypa. ");
INSERT INTO mwp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dhadhal nanga wara mabaygal mangemidhin thana ngapa angadhin dhag kikirilayg, magawgig. Thana nuyn thoeridhar nuy uthuy lagoenu yoewir. Thana muya yoewthaypa nuthemir Yesulpa, nuyn parunu wanan. ");
INSERT INTO mwp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mabayg koeygarsar, thana yan nuthemin Yesulpa gasamaypa. Thana kadaypa thodhapa nuyn thoeridhan; arkath ayman lagaw thodhanu, balbayginga Yesuniya gimal. Thana nuyn senabi kikirilayg arkathiya mulupa madhin apal wakunu yoewthan Yesuniya parunu. ");
INSERT INTO mwp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu na imadhin thanamun mina yoepathaman koeyza nuy dhagoepa ya mulaydhin kikiril gamupa, ‘Ngaw igalayg, nginu mura wati pawal gud woeyamoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dhuray sabiw ngurpay mabaygal thana kalmel nir a Parasayalgal thana thanamuniya muynu kedha umamoeyr ‘In mabayg nga yadu umepa, Awgadh mogo pugan! Matha Awgadhaw kupay kedha nuydh gud wayan wati pawa!’ ");
INSERT INTO mwp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu senabi thonara ngulayg asidhin thanamun wakay thoemamay midh nanga, nuy thanamulpa mulaydhin kedha, ‘Ngitha mingu senawbi wakay thoemamipa? ");
INSERT INTO mwp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngitha koey ngulaygal kedha palbi ukasar zageth ngaru kalmel za, wara kedha ngay kikiril mabaygoepa muliz, “Nginu mura wati pawal gudwoeyamoeyn!” lawnga ngay na kedha muliz, “Kaday tari a kusumar nginu uthuy rugal a mab uzar lagoepa.” ");
INSERT INTO mwp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngath ngithamulpa kakal ayman kedha, Mabaygaw Kazi kupaylnga ina apal gud woeyamoeyn mabaygaw wati pawal.’ Kalanu nuy dhagoepa buwayl thayadhin a mulaydhin, ‘Ngay ngibepa muliz kedha, kaday tari, nginu uthuy zapul kusumaw a lagoepa uzar!’ ");
INSERT INTO mwp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Thanamuniya parunu thana nagemir, nuy kikiril mabayg, kaday thariz, kusuman nungu uthuy rugal, uzariz lagoepa. Nuydh Awgadh mina koeyma thawmadhin. ");
INSERT INTO mwp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mabaygan mura mina koeyma madhu pamemidhin, thanamun aka koeyza. Thana koeyma Awgadh thawmadhin kedha, ‘Ngoey kedha kapu ngoedhal za kulay imayginga, ina kayib miza nanga.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Senabi kalanu Yesu uzaraydhin adhapa, a imadhin bokadhzoengu garwoeydhamay mabayg nel Lebi, nuy muynu nungu zagethaw lagoenu. Yesu nubepa muliz, ‘Ngaybiya asir.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nuy matha koerar asin zapul mura nungu waniz, a nuy asin Yesuniya. ");
INSERT INTO mwp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kalanu Lebi koey ay ayman nungu lagoenu Yesulpa, a nungu niyay kazil a koey garsar dhuray mabaygal kalmel, bokadhzoengu garwoeydhamay mabaygal a wara mabaygal. ");
INSERT INTO mwp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dhuray Parasayalgal, a sabiw ngurpay mabaygal thana iman, Yesun aygudan kalmel sethabi pasipa imay mabaygal a bokadhzoengu garwoeydhamay mabaygal. Thana nungu niyay kazipa yapu poeybemidhin, ‘Ngitha mingu kedha wati mabaygiya kalmel ay purthaypa a ngukiw wanimpa, bokadhzoengu garwoeydhamay mabaygal a pasipa imay mabaygal?’ ");
INSERT INTO mwp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu thanamulpa kuniya muliz kedha, ‘Mabayg nanga kikirigig, nuy doktapa ubin mayginga, mabayg nga kikirilayg, wa nuy ubin miziz. Ngay ngapa mayginga mina mabaygoepa thuraypa, ngay ngaru wati pawa mabaygoepa thanamulpa buwayl idimpa Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngay ngapa mayginga mina mabaygoepa thuraypa setha ngaya nanga kedha, thana matha ngoedhagidh, ngath ngaru thuran ibuypuydhan wara mabayg, wati pawa mabaygal thanamulpa garthil thoeyaypa. ");
INSERT INTO mwp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wara mabaygal Yesulpa kedha, ‘Yoewane Papthayson niyay kazil a matha kedha mura Parasayalgaw niyay kazil ngulayg aygudoegasimoeypu Awgadhoepa apasin, a thoeythu pagemipa, koey garsar thonaralnga. Midh paru nginu niyay kazil matha ay purthaypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu thanamulpa kedha adha min tidan, ‘Gethaw garwoeydhamay ay nanga, koey zageth mabayg aygudoeginga garwoeydhamayzi mabaygaw parunu. Nuy niyaypa yoelpayzi garkaz, nuy nanga sena kalmel mabaygan ngaru mura gasaman, aygudaginga lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wagel bangal koey thonar gasamoene a nuyn niyaypa yoelpayzi mabayg adhapa manin thanamulngu. Senabi thonara kay thana aygudoegasimoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu lak wara ya matha ngoedhagidh aymoedhin thanamulpa, ‘Koey zageth mabaygan kayn sodh pakadaman, pasis gasaman nanungu a kulba sodhanu woeydhan. Lawnga na gegeyadh nuydh gegeyadh manin kayn sodh a wara kedha sena kayn dhoemawak matha ngoedhagidh lawnga kulapa sodhanu woeydhan. ");
INSERT INTO mwp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","‘A matha kedha umal ngukiw za, uruy goengaw aymayzinga. Kulba goengaw ngaru piranga, mabaygoepa matha ngoedhagidh lawnga kayn umal nguki malan kulba goengawya; kedha nanga sik waliz mina koeyma arkath dhanaman, mura idiman umal nguki a uruy goengaw. ");
INSERT INTO mwp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kapu za kedha kayn umal nguki nanga nan ngaru kayn uruy goengawya malan. ");
INSERT INTO mwp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nga nanga kulba umal ngukiw woenilayg nuy ngaru kayn umal nguki ubiginga. Nungu wakay thoemamay kedha, kulba nguki ngaru balbayginga. Ngitha sike kayn ngurpayngu ubigigal.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Senabi thonara Yesu a nungu niyay kazil, thanamun mab woelmay kunaw apaw lagiya dhadhiya, goeyga sabadh. Thana niyay kazil puykunaw tiday kuyk ayman, a poey palemoeyr gethanu, thanamulpa aygudapa. ");
INSERT INTO mwp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wara thana Parasayalgal yapu poeybemin, ‘Ngitha midh paru zageth ayimpa sabadhaw goeyginu? Ina ngalpan sabinu wadhan sabadhoenu mabaygan zageth ulaypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kuniya mulaydhin thanamulpa kedha, ‘Ngitha geth tidayginga, Maygi Thusinu muynu kedha, kay paypa kulay ngalpan buway apakuyk, Dhawitha nuydh lak kedha za aymoedhin. Wara thonara nuy a nungu mabaygal koey maytha aygi pagar. Nuy muy yoewdhaydhin Awgadhaw koey yoewthoepa, ");
INSERT INTO mwp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A kusumoeydhin thanamulpa woenabal thoewa aydel sizi, kalanu purthadhin. Matha koey yoewthaw niyay kaziw aydel, sethabi thoewa aydel wara mabaygoepa lawnga, sabilnga; Awgadhoepa poeybayzimayl.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kalanu Yesu kuth madhin thanamulpa, ‘Mabaygaw Kazi ngay Kuykulnga, ngath mura yawaypa zapul matha kedha sabadhaw goeyga. Mabaygaw Kazi lak kedha sabadhaw kuyk.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wara Sabadh Yesu uzaraydhin moegina yoewthoepa, nubiya kalmel nungu niyay kazil. Wara kikirilayg sey nungu getha doegam geth muwayzinga. ");
INSERT INTO mwp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dhuray sabiw ngurpay mabaygal a wara Parasayalgal, thanamun koey ubi Yesulpa karum poelaypa thana, kedha zoenguz nuyn danal poethaypa koey amadhan, imaypa kedha nuydh mabayg dhoey nidhan sabadhoenu. Thanamun ubi nuyn kotapa maypa. ");
INSERT INTO mwp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu nuy ngulayg thanamun wakay thamamayl. Nuy muliz kikiril mabaygoepa kedha, ‘Kaday tari ngapa koepa uzar parupa.’ Wa, nuy mabayg kaday thariz a sir si. ");
INSERT INTO mwp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kalanu Yesu buwayl thayadhin thanamulpa a yapu poeybaydhin, ‘Ngay ngithamulpa kedha muliz, ngalpan sabi midh, sabadhoenu midh ayman? Matha ngoedhagidh midh mabayg ibu puydhan lawnga gegeyadh manin a? Igil palan lawnga uma mathaman mabayg?’ ");
INSERT INTO mwp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nuy thanamulpa mura nagiz kalanu kedha mulaydhin kikiril mabaygoepa, ‘Geth adhapa luwayar.’ Nuy kikiril mabaygan ayman, a nungu geth balbayg asidhin senabi thonar. ");
INSERT INTO mwp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Thanamun thabukir mina koeyza, thana ya mulemin kidhakidhan, ‘Ngalpa bangal Yesulpa miza aymoeyne?’ ");
INSERT INTO mwp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Senabi thonara Yesu nuy kadaypa padoepa walaydhin thoeythupoegaypa. Nuydh thoeythupoegay mura kubil madhin si, Awgadhoepa ");
INSERT INTO mwp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Goeyga nanga miziz nuydh nungu niyay kazil thuriz nubepa, a thanamulngu nuydh toewalob mamayidhin, adhapa thamamayidhin thana nungu mabaygal. Nuydh thanamulpa kupay zageth poeybadhin kedha, thana bangal nungu zageth oengaypu. ");
INSERT INTO mwp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wara nungu nel Simona (nuydh nuyn nel tharadhin Petheru) a wara Petherun tukuyap Andhoeru; Zemes a Yoewane, Pilip a Bartholemi, ");
INSERT INTO mwp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayu a Thomas, wara Zemes Alpiyasan kazi a Simona (thana nuyn kedha thoeraypu koey buway mabayg). ");
INSERT INTO mwp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudha nungu thathiw nel lak Zemes a war Yudha Keriyothoelayg Yesun ngadh nanga guda aradhin yoewthaw koey mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kalanu Yesu a nungu toewalob niyay kazil kalmel mulupa pugamoeydhin padoengu. Nuy si tharaydhin. Mabaygaw moeyay mina koeyza, a koey garsar dhuray thanamulngu nungu niyay kazil ngaya nanga nubepa kurusipagemipu. Thana mura doegamoengu ngapa mura Yoewdhayaw goegathoengu, matha kedha Yoerusalemoengu, a malu buwadhoengu goegathal Thayar a Saydon. ");
INSERT INTO mwp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Thana ngapa nubepa nungu ngurpaypa kurusipagaypa a nubepa thanamun kikiripa dhoey nidhaypa. Matha kedha dhuray thanamuniya setha ngaya nanga wati mariw malayzimayl, nuydh thanamuniya lak kedha dhoey nidhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mura mabaygal yaynanob muynu kuwanu nuthemir nubiya gamu thoeraypa, kuyk thana gasamar thanamun gamunu nungu woenab a bibir, dhoey nidhamoeyr thana, thanamun kikiringu. ");
INSERT INTO mwp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu mina wadhe thulu nagaydhin nungu niyay kazipa a kedha mulaydhin, ‘Ika dhiw gasamaw ngitha ngaya nanga zagigal, kuyk Awgadhan ngithamulpa za matha ngoedhagidh ayman muynu nungu basalayoenu. ");
INSERT INTO mwp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A ngitha ngaya nanga maythaygin memayipa ina kayib, ika dhiw gasamaw, kuyk ngitha bangal mina balbayg tidamoeyne. Ika dhiw gasamaw ngitha ngaya nanga may maypa kayib, kuyk ngithamuniya bangal giw guda nithane. ");
INSERT INTO mwp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Ngitha nanga koey dharadh mamayipa a mabaygaw ngithamulpa ngoenakapul mapu puydhemipa a pasipa yawayipa ngoedhe wati mabaygal, kuyk ngitha ngaw puziw mabaygal, ika dhiw gasamaw ngitha. ");
INSERT INTO mwp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wa, kedha ngadha thoeyay nanga aymiz ngitha ngaru ika dhiw gasaman a mina katan thoeydhamin ikan, kuyk ngithamun modhabiya bangal koeyza daparoenu gimal. Kay paypa kulay thanamun thathin lak kedha ngoedhal pawal aymaypu maygi peropethoepa, itha thana ngithamulpa mi wati pawal nanga aymoeypa kayib. ");
INSERT INTO mwp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Kasa kay kedha, wati za bangal mangedhe ngithamuniya, ngitha ngaya nanga koey aydegal zapulgal kayib. Sena ngitha gasampa kayib ngithamun modhabiya. ");
INSERT INTO mwp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ngithamun ngunu nanga maythal gimal wazimoeypa a gamul dhub yoerimaypa kayib, wati za bangal ngithamuniya mangedhe a ngitha bangal maytha aygi thoeyaypu. A matha kedha ngitha ngaya nanga giw maypa kayib, wati za bangal ngithamuniya mangedhe a ngitha bangal may mayparuy. ");
INSERT INTO mwp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Midh thonara nanga mura mabaygan thawmaypa ngin a apasimaypa ngidh ngaru koey poeypiyam senabi thonara nginungu poethingu oerayle. Nginu zageth midh, mabaygaw purkapa matha ngoedhagidh, lawnga Awgadhaw purkapa matha ngoedhagidh, nginu igililnga sike na ngoedhe ngoelkay peropetha midh nanga. Kulba mabaygan thanamulpa mina yoepathamoeypu kasa kay kedha thana mina peropethoepa kurusipoegayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu lak mulaydhin thanamulpa kedha, ‘Kedha ngay ngithamulpa muliz, ngitha ngayapa nanga koerngayl kawralmayl, ngitha ngaru mam pathridhan ngithamun wati igalgoepa, mina pawa ayman mabaygan ngadh ngin adhapa iman. ");
INSERT INTO mwp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Woenabal ya muliz, mabaygoepa ngadh wati za bag thayan ngithamulpa a thoeythu pagedha thanamulpa mabaygan ngaya ngithamulpa mogo pugaypa. ");
INSERT INTO mwp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mabayg nanga ngibepa gegeyadh, matha kedha nuydh ngibiya getha doegam dakanu wariman, matha ngoedhagidh kedha yoewdhan nubepa nginu wara doegam dak nubepa lak warimoeypa. Mabaygan nga nginu gabu sodh manin, wa nginu sodh lak kedha nubepa mar. ");
INSERT INTO mwp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","‘Mabayg nanga ngibepa yoewdhiz, matha ngoedhagidh poeybar senabi za nubepa. A mabaygan nanga nginungu za manin ngi lak mulayginga kuniya maypa, senabi zapa. ");
INSERT INTO mwp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kedha ngoedhal za nginu mi zapa ubi thana ayman ngibepa, matha ngoedhagidh kedha ngidh kedha ngoedhal pawa ayman mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Midh kay paru Awgadhan ngibepa woenab poeybaypa, pud balbayg tidaypa, ngidh nanga maman maypa, matha setha ngaya nanga ngibepa koey ubilmayl; wati mabaygoepa lak kedha senabi kapu pawa ayimpa. ");
INSERT INTO mwp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","‘A ngidh nanga kapu pawa ayimpa matha thanamulpa mabaygal ngaya mina pawa ayman ngibepa, midh kay paru ngidh Awgadhoengu woenab gasaman? Wati mabaygal lak kedha senabi mina pawa ayimpa. ");
INSERT INTO mwp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A ngidh nanga zapul thawpay thonarpa kusuman matha nginu igalgoepa, a lak kuniya kusuman, midh kay paru ngidh Awgadhoengu woenab gasaman? Wati pawa mabayg lak kedha mina pawa ayimpa. Minguz kedha, thanamulpa kedha thana lak kuniya gasaman thana miza nanga manin. ");
INSERT INTO mwp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","‘Lawnga ngitha ngaru wati igalgal maman maypa, mina pawa thanamulpa ayman. Ngidh nanga za kasa thawpay thonarpa poeyban, koeyma wakay thoemamayg kedha, thana kay lak kuniya maypa ngibepa lawnga midh. Ngitha bangal kedha koey modhabiya gasamoene, ngitha bangal nungu kazil aymoeyne, koey Awgadh gimal. Ngidh mina pawa angan nanga, mina mabaygoepa, a wati mabaygoepa, wa sena balbayginga, Awgadhaw pawa midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ngi ngaru mabaygoepa gabudhan mepa, koey dharadh mayginga, a ibupuydhay ayman mina mabaygoepa a matha kedha wati mabaygoepa nginu Daparaw Thathi midh na koey gabunga.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Mabaygal bangal mulamayg, Awgadhan lak ngin mulamayginga, zoeyzi noeydhayginga. Mabaygan yadu idimayg, Awgadhan lak ngin idimayginga. Wati pawal mabaygaw guythuyan, Awgadhan lak kedha guythuyan nginu wati pawal. ");
INSERT INTO mwp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngitha bangal koeyma zapul poeybamoeypa wara mabaygoepa, mabayg amadhan a mabayg sigal, ngidh Awgadhoengu gasaman koey modhabiya; nungu ibupuydhan matha pungaypa, watha pathayginga daparoengu nginu gethoepa; ngidh gasaman koey gudapalam. Ngidh midh na minampa mabaygoepa za poeyban, wa, Awgadhan bangal lak kedha ngoedhalnga ngibepa minampu, ngidh mabaygoepa midh nanga minampa.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu muliz thanamulpa nubi adha min tidayzi ya kedha, ‘Urapun maygum nubepa lak matha ngoedhagidh lawnga wara maygum yoelpan nubiya kalmel; palamun kalmel mab matha ngoedhagidh lawnga, palay kasa pudheman muydhiya mulupa. ");
INSERT INTO mwp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ngurpay moegina kaz nanga gimal lawnga thanamun ngurpay mabaygiya, matha kedha mura mabaygal; thana nanga thanamun ngurpay muwasin, wa thana kedha ngoedhalnga aymoeyn, thanamun ngurpay mabayg midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Mipa ngidh nubi pawa ayimpa nginu tukuypaw gegeyadh abaypa a nginu gegeyadh nanga mina koeyza? In nabi pawa matha kedha thoekay midh. Ngi kay midh paru tukuypoepa mulaypa adhapa maypa, kasa kay kedha ngidh imayginga kedha nginu purkanu lak kedha mina koey thoekaylnga. Paru idhayg, nginu purka kulay balbay tidar, lak kay ngi pudhunga nagepa nginu tukuypoepa ibupuydhaypa, thoekay adhapa maypa nungu purkangu.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu lak adha min tidar thanamulpa kedha, ‘Mina puynu wati puy koewsa puydhayginga, matha kedha puy bibirigoesiginga, mina koewsa puydhayginga. ");
INSERT INTO mwp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A matha kedha mura puyl thana koewsa parempa thanamun geth koewsalmayl. Ngalpa kedha kuniya seysithaman a iman, mina puy kakal a wati puy kakal; a matha kedha mura puyl ngalpa puy koewsangu ngulaygal. Matha kedha pigal, ngidh koey zageth paran patal puyngu, a koey zageth ngidh goeraypal paran bupangu. ");
INSERT INTO mwp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","‘Wara kedha, mina mabayg nanga, nungu kurunu woerdhayzimayl mura mina zapul wara mabaygoepa yakamaypa. Mabayg nanga nubiya muynu mura wati wakay thamamayl nungu ngoenakapoenu, nungu gud lak kedha ngaru wati gud; mina mabayg nanga, nungu ngoenakap wakay thoemamayl mura balbayginga, wa nungu gud lak balbayginga. Gudan yadu palgan nginu, muynu nginu ngoenakap balbayginga a gegeyadh.’ ");
INSERT INTO mwp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Ngitha mingu ngoena kedha thoeraypa, “Kuykulnga, Kuykulnga,” a ngitha ngaw ya aymoeyginga ngay na ngithamulpa umepa. ");
INSERT INTO mwp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mabaygal ngaya ngapa ngayapa a karngemin ngaw yangukudul, a ayman sethabi yaday, wa balbayginga. Ngath ngithamulpa adha min tidan senabi mabaygaw igililnga. ");
INSERT INTO mwp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","‘Matha kedha mabaygan ngadh mina lag moeydhan; nuydh kulay Anaran koey mulupa kulapa, a koey ridhanga nan kulan malan. Koey bubunu nanga nan garguy mayginga, kuykul thoeyayginga, kedha zoenguz kedha na balbaygi boeradhoeranu moeydhayzinga. ");
INSERT INTO mwp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kasa kay kedha mabaygal ngaya karngemipa kasa kay thana aymoeyginga sethabi yaday, thana matha kedha senawbi mabayg, nga nanga lag moeydhan kasa boeradharoenu gimal, mamu kuyk ridh poelayginga. Koey bubu na lag gasaman nan sobaginga kuykul thayan, al mathaman.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu nanga muwasidhin ya, mura zapul yadu palgamoeydhin mabaygoepa, nuy kalanu Kapoeniyamoepa uzaraydhin. ");
INSERT INTO mwp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wara Romaniw koewbu kuyk si, nungu zagethaw mabayg nubepa mina kapu mabayg nungu kikir mina koeyza, amadhan um. ");
INSERT INTO mwp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nuydh nanga koewbu kuyku mabaygan karngemidhin Yesun ya, nuydh wayadhin wara igalgal, Yoewdhayalgaw koey mabaygal, yoewdhemidhin nubepa ngapa thuraypa, balbay tidaypa senawbi zagethaw mabayg kikirilayg. ");
INSERT INTO mwp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Thana ngapa Yesulpa, koeyma apa pudhemin nubepa balbay tidaypa kikiril mabayg. Thana kedha, ‘In Romaniw kuyk mina mabayg, kapu za ngidh nuyn ibupuydhan. ");
INSERT INTO mwp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nuydh maman mamayipu mura ngalpan mabaygal a nuydh nungungu ngoeymulpa yoewth moeydhadhin.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu asidhin thanamuniya, Romaniw kuyku mabaygoepa. Thana nanga lagoepa amadhan aymoeydhin nuydh lak wayadhin igalgal, kuyku mabaygaw yaday mamayin kedha Yesulpa, ‘Kuykulnga ngidh nginungu koeyma zageth aymayg ngoeymulpa. Ngay matha ngoedhagidh lawnga ngi ngapa muy ariz ngaw lagiya, ");
INSERT INTO mwp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A matha kedha ngaw imaypa kedha, ngay matha ngoedhagidh lawnga ngibiya kalmel thanuriz. Ngibepa matha ngoedhagidh kedha, kasa nginu yangukudu mar a ngaw zagethaw mabayg kay balbaygoesipa. ");
INSERT INTO mwp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngay ngawngu ngulayg, kuyk ngaw zageth, ngaybiya gimal ngaw mopakuykul a ngaybiya apal koewbu mabaygal zageth ulaypa. Ngay wara mabaygoepa kedha, “Uzar!” Nuy uzariz. Ngay na kedha, “Aya.” Nuy uzariz ngapa. Ngay ngaw danal poethay zagethaw mabaygoepa kedha, “Ina aymar” nuydh ayman senabi zageth. A nginu yangukudu ngaru koey bibirilnga ngaybiya, kasa nginu yangukudu manin nanga, ngaw zagethaw mabayg kay balbaygoesipa nungu kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu nanga karngemidhin Romaniw mabaygaw yangukudu, nuy madhu pamaydhin, kalanu buwayl thayadhin mabaygoepa setha ngaya nanga nubiya puzimoeyr. Nuy kedha thanamulpa, ‘Wa, ngay kay ngithamulpa mina ya mulepa, nubi Romaniw mabaygaw mina yoepathamay mina adhapudhay. Ngath kedha ngoedhal mina yoepathamayzi mabayg kulay imayginga, matha kedha Isoereylaw buwaynu imayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Zapa woeyay mabaygal kuniya tidemidhin koewbu kuyku mabaygaw lagoepa thana iman kedha, nungu zagethaw mabayg koey balbayginga nungu kikiringu. ");
INSERT INTO mwp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Moegina buth dhadhal Yesu kuniya tidaydhin wara goegathoepa, goegath nel Noeyn. Nubiya kalmel nungu niyay kazil a dhuray koey garsar mabaygal. ");
INSERT INTO mwp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nuy nanga goegathiya muy uthaydhin, e, nagi! Nuydh imadhin mabaygaw koey garsar angar uma mabayg. Wara yoepkaz mayk, in nanu kazi, garkaz umanga. In gar nanu poeypiyam kakur, na wara kazigig. ");
INSERT INTO mwp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nuy Kuykulnga nanga imadhin nungu koerkak badh kasa koeyza nabepa. Nuy nabepa kedha mulaydhin, ‘Ngi mayg asir.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kalanu nuy uma gamupa uzaraydhin a geth luwayadhin, gasamoedhin na ngalaga na thoekaminoenu gimal yoewir. Kalanu thana oengayzi mabaygal thuma asidhin a nuy kedha mulaydhin uma mabaygoepa, ‘Kayn mabayg, ngay ngibepa kedha muliz, kaday tari.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kalanu nuy uma mabayg dan paliz, a nuy igi thanuraydhin, a ya muliz. Wa, ina kedha kuniya Yesu nuyn madhin nungu apupa kuniya. ");
INSERT INTO mwp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Thanamun mura aka koey zapul, a thana Awgadh thawmadhin kedha, ‘Ina kakal kaday tariz mina koey peropeth ngalpaniya dhadhal!’ a wara thanamun yangukudu kedha, ‘In Awgadh ngapa nungu mabaygoepa gudaz puydhaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nubi za kasa koeyma yadu palgadhin mura Yoewdhayalgoepa, a dhuray koeygarsar goegathal. ");
INSERT INTO mwp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wara thonara Yoewane Papthayson niyaykazil mulemidhin nubepa, mura sethabi yaday, Yesu Kerison zageth midh nanga. Yoewane nuydh ukasar nungu niyay kazi thuremoedhin, ");
INSERT INTO mwp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kuykulmaypa wayamoedhin yapu poeybaypa kedha, ‘In ngi a? Awgadhaw Mina Woeyayzinga ngoeymulpa, ngath ngan nanga kulay yadu palgarngu; a lawnga war mabayg si ngapa wagel?’ ");
INSERT INTO mwp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Palay nanga Yesuniya mangemidhin palay kedha, ‘Yoewane Papthayso ngalbe wayaman yapu poeybaypa kedha, in ngi a, ngoeymulpa Awgadhaw Woeyayzi Mabayg, nuydh ngan nanga yadu palgadhin, a lawnga wara sey ngapa wagel a?’ ");
INSERT INTO mwp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mina senabi thonar Yesu koey garsar mabaygal dhoey nidhamoeydhin thanamun mura kikiringu, a matha kedha wati maril adhapa wayamoeyn malayzi mabaygoengu, a maygumal balbay tidamoeyr balbayginga noegaypa. ");
INSERT INTO mwp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nungu Yesun kuniya ya palamulpa, Yoewanen niyay kazipa kedha, ‘Kuniya uzarmariw, mulemoeriw Yoewanelpa, ngipel midh purkan iman ina, a kawran karngemin? Mayguman purkaw buya kuniya gasaman a iman balbayginga, a muwayzimayl thana mab ladhun, a setha nga wati goengawl kikirilgal thana balbayg asimoeyn, lak mina goengaw kuniya gasaman. Kawaragig nanga thana karngemin yaday; uma mabaygal thana igililnga kuniya gasaman a kaday nithaman; a Awgadhaw kapu yangu wakay na mura lagiya yadu poelgaypa zapugi mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngi kedha muli nubepa, “Nginu mina yoepathaman midh? Ngadh nanga ngawngu gegeyadh gasamayginga, wa, nungu ika dhiw bangal koeyza.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kalanu Yoewanen yaday wayay mabayg kuniya tideman, a Yesu kuyk aymoedhin Yoewanelpa mulaypa, kedha yadu palgan mura mabaygoepa, ‘Yoewanen maw nanga, ngithamulpa mabaygoegi dhadhabuthoenu. Ngitha imaypa, adha puydhaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngithamun ubilnga za miyay? Ngitha kedha lawnga muku mabaygoepa imaypa, kasa kat palgipa urapu lagoenu siyayginga, ngoedhe kedha bup guban yoewimaypa, wara kuniya a wara kuniya. Ngitha mipa kedha mi ngoedhal mabaygoepa ubin maypa imaypa, adha puydhapa? Ngitha kedha lawnga mina rugal mabaygoepa imaypa. Ngithamun na kedha ubilnga nanga, ngitha nay mopakuyku mabaygaw koey niyay lagoepa, mina dhoemawakul mabaygal si muynu. ");
INSERT INTO mwp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngayapa mulemiw, ngitha mi mabaygoepa imaypa ladhudhin, ngitha Awgadhaw yangu mabaygoepa a? Awgadhaw peropetha? Wa, ngay ngithamulpa kedha ngitha koey peropetha yawayarngu, nuy ngaru adhapudhay peropethaya gimal. ");
INSERT INTO mwp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mina kulkub ngalbe Yoewanen ngaru yadu palgeman kedha muynu Minar Poelayzinga, “Nag! Ngath ngaw yaday woeyay mabayg bangal kulay wayane ngibiya paruya, ngi ngaw mina Adhapa Thoemayzinga. Nuydh bangal nungu yabugud buth pathane.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu lak mulaydhin thanamulpa kedha, ‘Yoewane, nungu kupay ngaru gimal mura nungu maykuykaw mabaygiya, a mabaygal ngaya nubiya kulay; kasa kay kedha mabaygal ngaya nanga muya uthemin Awgadhaw Basalaya nanga kasa mabayg midh, nuy nanga muy yoewthiz Awgadhaw Basalayoepa nungu igililnga ngaru gimal Yoewanen kulay igililnga midh nanga. Kuyk Awgadhaw Basalayoepa muya uthiz.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesun senabi yangukudu nanga, thana kasa mabaygal, a bokadhzoengu garwoeydhamay mabaygal thana karngemidhin. Thanamulpa kakal kedha na mina yabugud Awgadhaw; setha mabaygal ngaya nanga ngapa Yoewanelpa, nubepa thanamulpa paptayso maypa. ");
INSERT INTO mwp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kasa kay kedha thana Parasayalgal a sabiw ngurpay mabaygal, thana sethabi mina igililmaypa ubigigal, Awgadhaw ubilmaya mabaginga, minguz kedha thana Yoewanelngu paptayso maythayle ubigigal. ");
INSERT INTO mwp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu nuy adha min tidadhin kedha, ‘Thabi maykuyku mabaygal, thana mi ngoedhalmayl? ");
INSERT INTO mwp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Thana ngoedhe moegina kazil nge, goegathoenu dhadhal sagul sipa. Dhuray moegina kazil wal memayipa kedha wara moegina kazipa, “Ngitha mingu girel adhayginga ngoey nanga niyaypa yoelpay na puyampa nanga ngithamulpa? Ngitha sagulginga. Ngoey mamu awmaw na nge puyampa a ngitha may adhayginga?” ");
INSERT INTO mwp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","‘A ngitha mina koerngaygi mabaygal ngoedhe sethabi moegina kazil nge. Yoewane Papatayso nuy ngapa, nuydh amenipa ay aygudag asin, a nuy koerawayg umal ngukingu, a ngitha kedha umamoeypu, “Nubiya wati mari muynu.” ");
INSERT INTO mwp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nubiya kalanu ngay Mabaygaw Kazi na ngapa, ngay aygudoelayg a umal nguki woenile ngulayg; a ngitha kedha, “Nagemiw senabi mabaygoepa! Nuy koey aygudoelayg a koey umal ngukiw woenilayg, wati mabayg. Nuy wati mabaygiya puzipa, bokadhzoengu garwoeydhamay mabaygal a dhuray adhapa imay mabaygal.” ");
INSERT INTO mwp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","‘Kasa kay kedha Awgadhaw mina za kakal yakaman mabaygaw igililmaynu muynu, mura ngaya koerngayl, kawralmayl.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wara thonara urapun thanamun yoewthaw koey mabayg Parasayalayg nuydh Yesun thuradhin nungu lagoepa aygudoepa. Yesu nanga apa thanuriz aypa nanga ");
INSERT INTO mwp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","E! Nagi, wara wati pawa yoepkaz senabi goegathaw, ngapa miyaydhin nubepa. Nadh ya karngemidhin kedha nuy ngapa Parasayalgaw lagoepa aypa, a na kedha zoenguz nubepa ngapa a na angadhin mina kapu ganul wakasu, koey modhabil za. Kapu kulaw aymayzinga, koethilnga. ");
INSERT INTO mwp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na kalanu thanuraydhin nungu siyara apal a mayoesir kay. Nanu ngudin gar nungu siyar garwalgamar. Kalanu nadh nanu yalbupan ngudi adhapa madhin. Gud thapaman nungu siyar Kalanu nadh nanu wakasu gud pudhan a suladhin nungu siyara. ");
INSERT INTO mwp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nuy senawbi yoewthaw koey mabayg, nuydh imadhin a nuy kedha mulaydhin nubiya muynu, ‘Yesu nay mina peropetha nuy ngaru nanungu ubigasin. Nubepa kakal nay na mi doegam mabayg ngadh nanga gasaman nungu siyar, a nanu wati pawa igililnga midh.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kasa kay kedha Yesu mulaydhin nubepa kedha, ‘Simona, ngay ngibepa moegina yoepa mepa.’ Nuy kuniya mulaydhin, ‘Ngurpay Mabayg, wa, ngi muli.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kedha mulaydhin, ‘Wara thonara ukasar mabayg memampu. Palay yaynanob yoewdhemadhin bokadhza bokadhzoengu mabaygoengu. Wara mabaygaw yoewdhayzinga matha pipti dolal a wara koeyza payb andred. ");
INSERT INTO mwp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Thonar na gasamoedhin nanga bokadhzoepa modhabiya maypa, palamulpa koey zageth kasa kay kedha nuy bokadhzoengu mabayg kasa pawayadhin palamun umanga. Ngibepa midh, palamulngu ngunu mam koeyza nubepa bokadhzoengu mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona kuniya mulaydhin kedha, ‘Ngayapa sike kedha, ngunu nanga umanga koeyza gud wayan, nungu mam ngaru koeyza.’ Yesu kuniya mulaydhin, ‘Wa ngi mina yadu umepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kalanu nuy yoepkazipa buwayl thayaydhin a kedha mulaydhin Simonalpa, ‘Ngidh nan imar, senabi yoepkaz; ngay ngapa nginu lagoepa kasa kay kedha ngidh ngayapa nguki poeybayginga siyarpa garwalgaypa, senabi koey pawa aymayginga. Nadh ngaw siyar nanu ngudin garwalgadhin a yalbupan woernu adhapa madhin. ");
INSERT INTO mwp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngidh ngoena gud thapamayginga ayawal maypa, nadh senabi koey pawa ngayapa aymadhin. Kuykuthalnga ngaw siyar gud thapamar. ");
INSERT INTO mwp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngidh idi sulayginga ngaw kuykunu, nadh koey modhabil wakasu suladhin mura ngaw siyara. ");
INSERT INTO mwp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wa, ngay ngibepa kedha muliz, nanu mam ngaru koeyza, minguz kedha, nanungu mura wati pawa guythuyadhin. Kasa kay kedha ngunu nanga kasa moegina gegeyadh guythuyan, nungu kuniya mam kasa moegina.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kalanu Yesu nabepa mulaydhin, ‘Nginu mura gegeyadhal mura gud wayamoeyn.’ ");
INSERT INTO mwp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mura sethabi ayngu purthayzi mabaygal koeyma madhu pamemidhin kedha, ‘Nuy midh paru mabayg, nuy sike matha ngoedhagidh mabaygaw gegeyadhoepa gud woeyaypa lawnga midh?’ ");
INSERT INTO mwp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kalanu nuy yoepkazipa buwayal thayadhin a kedha mulaydhin, ‘Ngin kedha zoenguz kaludhan, kuyk nginu mina yoepathaman. Awgadhaw woenab ngibiya kalmel.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wara thonara Yesu lak miyaydhin wara goegathiya a wara goegathiya. Nuydh senabi kapu yangu wakay Awgadhaw Basalayaw ngurpamoeydhin. Nungu toewalob niyay kazil nubiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A dhuray lak yoepkazil ngaya nanga Yesu kulay dhoey nidhamoeydhin wati maringu a dhuray kikiringu. Mariya (nanu goegath Magdala) Yesu nanungu adhapa mamayidhin seben wati maril, ");
INSERT INTO mwp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","A Yowana Thusan ipi, nuy wara zagethaw kuyku mabayg Erodhan lagoenu, a wara Suzana a dhuray wara yoepkazil ngaya nanga ibupudhay ayimpu Yesulpa a nungu niyay kazil thanamun geth bokadhzoengu. ");
INSERT INTO mwp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mabaygal mura goegathoengu ngapa Yesulpa kedha, wara goegath a kedha ngapa wara goegathoengu nge. Kurusipa mura garwoeydhamiz urapun lagoenu, Yesu nuydh thanamulpa adha min tidan kedha, ");
INSERT INTO mwp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‘Wara thonara nagu uthuy mabayg uzaraydhin apaw lagoepa, kunaw kapupa uthuypa. Nuydh kapul mura thayaydhin wad wadgoepa apaw lagiya. Dhuray kapul pudhemidhin mabawlagiya, a mabaygal kasa ngaran thoeydhamoeydhin sethabi kapul, a dhaparaw uruyl matha purthamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","‘Wara boeradhar nanga koey kulalnga, boeradharoeginga. Setha mi kapul nanga pudhemidhin thana sobaginga malguy adhemidhin, kasa kay kedha boeradhar koey thepadhanga, thanamun malguyl kay pisamoeydhin sobaginga. ");
INSERT INTO mwp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","‘Wara dhuray kapul pudhemidhin poethalaya, a nuy poethalay ngaguya paw thoeraydhin, bibirig palimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","‘Dhuray kapul mina boeradharoenu pudhemidhin, nagul koesimoeydhin, a ayde pudhemidhin kunaw; urapun puy kun nanga andred mura kapul muynu.’ Kalanu Yesu gima gudiya kuth madhin kedha, ‘Ngi nanga kawralnga, wa kurusipagi!’ ");
INSERT INTO mwp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kalanu nungu niyay kazil yapu poeybemidhin Yesulpa kedha, ‘Nginu adha min tiday ya, muynu mi kuykul?’ ");
INSERT INTO mwp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nuy kuniya mulaydhin thanamulpa kedha, ‘Senabi mina ngulayg ngithamulpa poeybayzinga, Awgadhaw Basalaya midh nanga, kasa kay kedha mabaygal na ngaya adhal, “Thana kasa gimal kurusipagemipa adha min tidayzi yoepa. Lak thana nagemipa, mina muynu imayginga; lak thana kurusipagemipa, tidayginga.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Ina na ya adha min tidayzinga kedha, setha kapul Awgadhaw yaday. ");
INSERT INTO mwp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Setha mi kapul pudhemipa yabugudoenu pasinu. Ina ngoedhe kedha nge mabaygan ngaya na karngemin, kasa kay kedha Sathana ngapa adhapa manin senabi mina ya thanamun ngoenakapoengu; thanamulngu mina yoepathamoeyle a mina igililmayngu gasamoeyle. ");
INSERT INTO mwp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‘A setha na mi kapul kulal boeradharoenu pudhemin thana kasa thawpay thonarpa malguy adhemin. Ina matha kedha mabaygaw igililmay thonara tidayzinga kedha, thana karngemin Awgadhaw ya, kasa gimal koey ikalnga thawpay thonarpa. Nuthan nanga ngapa aymiz thanamulpa, thana sobaginga pudhemin adhapa Awgadhoengu. ");
INSERT INTO mwp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‘Setha mi kapul patal boeradharoenu pudhemin, ina ngoedhe kedha nge mabaygal, thana ngurpay karngemin, kasa kay kedha thana koey ubilgal gamu igililmaypa balbaytidaypa thanamulpa. Thanamun ngoenakapul memayipa mura nubi apaw goewaw sirisiril, a sethabi sirisiril matha kedha patal puy midh, goegadh palan mabaygaw mina igililinga, ay puy koewsal matha puydhayginga. ");
INSERT INTO mwp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","‘Dhuray mabaygal thanamun igililmay doegam balbayginga, ngoedhe puy kapul mina boeradharoenu pudhemin. Thana mina ngurpay karngemin a tidan, mina ngoenakapoenu thana matha puzimoeypa, kurusipa mina koewsa gudiya adhan; thana ngaru koewsalmayl.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu lak adha min tidar thanamulpa kedha, ‘Koey zageth mabaygan lampa gamu woeydhan, a kalanu besininu wardhan, lawnga uthuy lagoenu apal tharan. Matha ngoedhagidh kedha nuydh lampa nanu thoeray lagoenu tharan. Lak mabaygan iman nanu buya, thana na ngapa muya uthemin lagiya. ");
INSERT INTO mwp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A matha kedha mabaygaw mina pawa lawnga wati pawa, mi zapul kayib gumi, ngaru bangal kakal mabaygaw parunu, a mi zapul woerdhayzimayl nanga ngaru bangal woerdhayginga. ");
INSERT INTO mwp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‘Poeypiyam kulay Awgadhoengu a kurusipagemiziw nungu yapa; ngadh nanga moegina tidan, Awgadhan bangal nubepa poeybane koeyza. Ngadh nanga tidayginga, nungungu bangal adhapa mamayine, setha nungu mi moegina zapul.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kalanu Yesun apu a tukuypal ngapa nubepa imaypa nuthemir, kasa kay kedha mabayg koeygarsar nuyn zug nanamipa. ");
INSERT INTO mwp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wara mabayg si amadhan kedha mulaydhin Yesulpa, ‘Poeypiyam kulay Awgadhoengu a kurusipagemiziw nungu yapa; ngadh nanga moegina tidan, Awgadhan bangal nubepa poeybane koeyza. Ngadh nanga tidayginga, nungungu bangal adhapa mamayine, setha nungu mi moegina zapul. Sepa nagi, nginu apu a tukuypal ngapa ngibepa imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kedha mulaydhin thanamulpa mura, ‘Ngaw apu a ngaw tukuypal, matha kedha ngaya na karngemin Awgadhaw ya, a ayman nan.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wara goeyginu Yesu a nungu niyay kazil thana butanu pathemidhin. Nuy thanamulpa kedha muliz, ‘Ngalpa tapa maluya wara doegam buwadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Thana memayin, Yesu uthuy yoewnan. Dhadhal thana koey guban gasaman malunu, a woer butanu malay, mina koey akalnga. ");
INSERT INTO mwp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Thana ngapa Yesulpa walman kedha, ‘Kuykulnga! Dan pali! Dan pali! Ibupuydhamoeyr ngalpa, wagel kay ngalpa kasa umamayl.’ Yesu kadaypa mizin, nuydh nungu yangukudun thayamoemoedhin, baw a gub mulupa pudhaydhin, kalanu mina koey idi kayar thoeydhamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kalanu nuy niyay kazipa kedha mulaydhin, ‘Ngithamun kapu akasin ngalaga?’ Thana mina koeyma madhu pamemidhin akan. Kidhakidhan mulemin kedha, ‘In mabayg nga? Nagemiw, bawan a guban ngulayg nubepa karngemin.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu a nungu niyay kazil thana thardhadhin wara buwadhoepa Galilayoengu, Geroesinaw mabaygaw boeradharapa ");
INSERT INTO mwp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu pagan kadaypa, nuydh urapun mabayg gasaman senabi goegathaw, nubiya muynu kuykuthalnga wati maril siparuy. Nuy dhoemowakugig ulaypa, koeyma goeygilnga, a lagoenu niyayginga. Nungu niyay lag uma mabaygaw moerama thoeyay sakayil. ");
INSERT INTO mwp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nuydh nanga Yesun iman, nuy koey may puydhan, mulupa pudhiz nungu siyara, a koeyma wal miziz kedha, ‘Yesu, Koey Awgadhaw Kazi, ngidh kay miza ngayapa ayimpa. Ngay ngibiya koeyma yoewdhiz, ngayapa kuth thoerayg!’ ");
INSERT INTO mwp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wagel kay mariw woengayzi mabayg wal miyaydhin, Yesu kulay mulaydhin, nubepa wati maripa adhapa maypa, senawbi rimarim mabaygoengu. Koey garsar thonaralnga marin nubiya muynu gegeyadh mayparuy, kasa midh mabaygan nuyn kunumpu a dhoerdhimoeypu nungu geth a ngar malil urukamin; kasa kay kedha nuy papudhamoeypu, a wati marin nuyn aka palan adhapa mabaygoegi dhadhabuthoepa. ");
INSERT INTO mwp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu nubepa yapu poeybaydhin kedha, ‘Nginu nel nga?’ Nuy mariw woengayzi mabayg kuniya muliz Yesulpa, ‘Ngaw nel koeygarsar.’ Nuy kedha zoenguz kedha muliz, nubiya wati mari muynu koeygarsar. ");
INSERT INTO mwp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sethabi wati maril yoewdhaydhin Yesun kedha, ‘E! Ngidh gar ngoey senabi koey arkathoepa woeyayg, ngoey mina ubigigal genoepa?’ ");
INSERT INTO mwp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Koeygarsar buruman amadhan padaw berowiya ay purthaypu. Thana wati maril Yesulpa koeyma yoewdhemidhin kedha, nuydh thana wayay burumpa. Wa, Yesu thana wayaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kalanu thana wati maril dhanamaydhin mabaygoengu a burumiya uthemidhin. Sena burumaw woelak, thana mura padiya mulupa zilmemidhin, a dudupamoeydhin malunu adhal. ");
INSERT INTO mwp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Thana burumaw danal poethay mabaygan imadhin, za miza na aymaydhin; thana zilmemidhin, ya angadhin koey goegathoepa a moegina zagethaw mudhaw lagiya. ");
INSERT INTO mwp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mabaygal adhapa ladhudhin imaypa za midh aymaydhin. Thana ngapa Yesulpa, thana imadhin mabayg, wati maril ngungungu na dhanamoeydhin, nuy matha ngoedhagidh Yesun ngaranu apal nir. Nuy doemawakulayg, a nungu wakay thoemamay balbayginga. Thanamun mura mabaygan nuyn imadhin aka koeyza thanamun. ");
INSERT INTO mwp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Thana ngaya na imadhin Yesun zageth, thana umamoeyr mabaygoepa kedha, sena mariw malayzi mabayg midh paru balbay tidadhin, a nuy balbayg asidhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kalanu mura mabaygal sethabi geroesinaw goegathaw, mulemidhin adhapa wayadhin Yesun, kedha zoengu thanamun aka mina koeyza. Wa, Yesu butanu pathiz a geth waniz kuniya wara goegathoepa. ");
INSERT INTO mwp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sena ngungungu nanga wati marin adhapa dhanamoeydhin, nuy Yesuniya koeyma yoewdhiz, ngay gar kay ngibiya pathepa. Kasa kay Yesun nuyn kuniya wayan, a kedha muliz nubepa, ");
INSERT INTO mwp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","‘Lagoepa kuniya uzar, ngi ngulayg Awgadhan ngibepa mina zageth ayman. Uzar kuniya nginu lagoepa a yadu thuri thana Awgadhan ngibepa kapu zageth ayman.’ Wa, nuy kuniya. Mariw dhanamoeyzinga mabayg balbayginga kuniya tidaydhin koey goegathoepa, a mura mabaygal yadu thuraydhin, Yesu nubepa mi kapu zageth na aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu na kuniya tidaydhin war doegam pasingu malungu, koey garsar mabaygal ayawal madhin nuyn, thana kuykuthalnga nuyn ugadhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nuy na butangu pagadhin nanga urapun yoewthaw kuyku mabayg, senabi goegathaw, nel Zayroes nuy kulun pasoeyniz Yesun siyara. Nuy koeyma apasin nubepa kedha, ‘Ngi kay ngaybiya oesipa, ngaw lagoepa?’ ");
INSERT INTO mwp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nuy kedha zoenguz yoewdhaydhin, nungu urapun yoepkaz kazi toewalob wathalayg, na koey kikir, amadhan um. ");
INSERT INTO mwp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wara yoepkaz nan moelpalaw kikirin gasamadhin toewalob wathalnga. Nadh nanu matha ngoedhagidh mura sagul paladhin doktaya lumaypa, nabepa balbaygoesipa; kasa kay kedha lawnga na balbayg oesiginga. ");
INSERT INTO mwp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wa, na kalanu ngapa palamay, a dhadhiya sakar thoeray mabaygiya Yesulpa gasamaypa, a nungu dhoemawaku kuth nadh gasaman. Nanu kikir senabi thonara wath pathadhin. ");
INSERT INTO mwp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu yapu poeybiz, ‘Ngoena ngadh gasaman?’ Mura mabaygal koerawayg kudun tharemin. Petheru nubepa kedha muliz, ‘Kuykulnga, mabayg koeygarsar in zug nanamipa ngibiya.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu kedha muliz, ‘Lawnga ngay ngulayg, ngayapa kakal mabayg ngaybiya nidhiz. Ngaybiya kakal gamunu za aymiz, ngath poeyban woenab.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nadh yoepkazin iman kedha, nan dhadha iman, na ngapa koeyma lupan akan, Yesun siyara apasin. Mura mabaygiya parunu nadh mina mura yadu palgadhin senabi kikir, nadh mipa nanga nuyn gamu tharadhin, a senabi thonara nanu kikir muwasin. ");
INSERT INTO mwp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu nabepa kedha muliz, ‘Ngaw kazi uzar, woenab ngibiya kalmel a nginu yabugud bangal balbayginga. Ngin kedha zoenguz mina dhoey nidhan, kuyk nginu mina yoepathaman.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu nanga senabi yadu umay, yaday woeyay mabayg ngapa seyzi yoewthaw kuyku mabaygaw lagoengu, Zayroesan lagoengu. Nuy yaday woeyay mabayg kedha muliz nubepa, ‘Nginu ayde kazi gar guythuyan, mamu Ngurpay Mabayg yoelpayg, kasa thonarngu guythuyayle.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu karngemidhin a nubepa Zayroesoepa muliz, ‘Akan maygi, mina za mina yoepathaman, a na kay balbaygoesipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu midh thonara lagiya muya uthiz, nuy ubigig wara mabayg nubiya kalmel, matha Petheru, Yoewane, a Zemes, a moegina kaziw aputhathi. ");
INSERT INTO mwp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mura mabaygaw may a koerkak badh nabepa, senabi moegina kazipa. Yesu kedha muliz thanamulpa, ‘Mayg asimoey! Moegina kaz um mayginga, na kasa uthuy yoewipa!’ ");
INSERT INTO mwp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Thana kasa nuyn giwn manin, thana ngulaygal kedha, ‘Na umanga.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kasa kay kedha Yesu nabiya gethanu nidhiz a ya muliz, ‘Kaday tari ngaw kazi!’ ");
INSERT INTO mwp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nanu igililnga kuniya tidiz nabepa, a senabi thonara na kaday thariz. Yesu thanamulpa kedha muliz, ‘Aydu poeybaw sena nan.’ ");
INSERT INTO mwp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nanu aputhathi mina koeyma madhu pamemidhin, kasa kay Yesu thanamulpa kedha muliz, ‘Mabaygoepa mulayg, ina miza ayman nanga.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wara goeyginu nanga Yesu ngapa thuraydhin nungu niyaykazil. Nuydh thanamulpa kupay poeyban a woenab mura wati maripa adhapa maypa mabaygoengu; a matha kedha mabayg dhoey nidhan kikiringu. ");
INSERT INTO mwp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sew Kalanu nuydh wayaydhin thanamun, thanamulpa Awgadhaw Basalayapa yadu poelgaypa, a matha kedha dhoey nidhaypa kikiril mabayg. ");
INSERT INTO mwp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nungu yangukudu thanamulpa kedha, ‘Wara za maygi ngithamuniya kalmel ngithamun maboenu; boegi lawnga, yana lawnga, thoewa ay lawnga, bokadhza lawnga, a wara modhabayg sodh ngithamuniya kalmel lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","‘Ngitha na mi lagiya muya idiman nanga, matha sew bangal kurusipa ngitha sizi wara goegathoepa ladhun. ");
INSERT INTO mwp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngitha nanga mi mabaygal ayawal mayginga a koerngayginga nanga ngithamulpa, ngitha ladhun sizi. Ngitha buthu lupemin sanoengu thana nanga iman. Wa, thana ngulayg asin kedha, thanamun koerngayginga koeyza thana ngoedhe inuraw mabaygal nge. Ngitha ngaru wara goegathoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wa, Yesun niyay kazil geth wanemidhin a ladhudhin mura mudhaw loegiya, igilaw ya mura yadu palgadhin a mabaygal balbay tidamoeypu, mura sethabi goegathiya. ");
INSERT INTO mwp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kalanu Erodh thanamun Galilayaw kuyku mabayg, ya gasamoedhin zapul midh na aymoeypu, a nubiya muynu koeygarsar wakay thoemamay. Minguz kedha, dhuray mabaygal kedha umamoeypu, ‘Yoewane Papatayso umangu kaday tharayngu!’ ");
INSERT INTO mwp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A wara kedha umamoeyrngu, ‘Lawnga, in sike kulba Peropetha Elayza lak yakamiz ngalpalpa.’ A dhuray kedha, ‘Wara sike kulba peropetha, ngapa kuniya tidayngu igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kasa kay kedha nuy Erodh kedha, ‘Ngath Yoewane kuyk pathadhin nuy umanga, in mabayg nga nge, yadu poelgaypa ngayapa kedha, nungu zageth koeyza.’ Kalanu nuy koeyma nuthepu Yesulpa imaypa. ");
INSERT INTO mwp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesun niyay kazin nanga nubepa kuniya tidaydhin a mulemidhin mura zapul thana aymoeydhin. Nuydh thana adhapa yoelpaydhin thanamun kusaygal, wara goegathoepa nel Bethsayda. ");
INSERT INTO mwp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kasa kay kedha koey garsar mabaygan karngemidhin, thana wagel asimoeydhin. Wa, nuydh thana ayawal mamayidhin a thana thuraydhin a ngurpadhin thanamun kedha Awgadhaw Basalaya midh nanga, a nuydh balbay tidan mabaygan ngaya nanga kikirilgal. ");
INSERT INTO mwp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Goeyga na pawpa aymiz nanga, nungu toewalob niyay kazil ngapa nubepa, kedha mulemin, ‘Setha mabaygal kuniya wayamoeyr thanamulpa thanamun kutaw aypa barpudaypa, a uthuy lagoepa gasamoeypa, amadhan goegathiya, a mudhaw lagiya; kedha zoenguz kedha ina mabaygoegi lag.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nuy Yesu kuniya kedha muliz thanamulpa, ‘Lawnga, ngitha thanamulpa ayde mamayipa.’ Thana kuniya nubepa kedha mulemin, ‘Itha ngalpaniya matha payb thoewa aydel a ukasar wapi. Nginu ubi midh ngalpa thanamulpa ayde barpudamoeyn, in mabayg koeygarsar.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Senabi thonara mabaygaw garsar mina koeyza, matha garkazil payb thawsan mura. Yesu kedha mulaydhin nungu niyay kazipa, ‘apa thanuri thana, balbayginga pipti, a wara pipti kubiya.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wa, thana niyay kazin muwasin ayman nungu ubilnga, mura mabaygal apa nithamoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu mamayin sethabi payb thoewa aydel a ukasar wapi, a kadaypa nagaydhin daparpa a eso madhin. Kalanu nuydh pathidhan poeybadhin nungu niyay kazipa dhadhiya mamayidhin mura mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Thana mura gamu dhiba mamayidhin senabi moegina ayngu. Kalanu nungu niyaykazil mura garwoeydhamoeydhin moegina burul. Thana 12 mura liday gasamoeydhin mabaygaw wanayzi aydel. ");
INSERT INTO mwp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wara thonara Yesu nuy kay adhal thoeythu pagan; nungu niyaykazil sey nubiya, thana matha thana, mura mabaygal lawnga. Nuydh thana yapu poeybamoeydhin kedha, ‘Mura thana mabaygal, thanamun wakay thoemamay midh, ngay nga?’ ");
INSERT INTO mwp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Thana kuniya mulemidhin, ‘Wara mabaygal kedha, ngi Yoewane Papatayso, ngi umangu lak igililnga; a wara kedha ngi Elayza; a wara mabaygal kedha muliz, ngi wara kulkubaw peropeth.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nuy lak yapupoeybaydhin kedha, ‘Ngithamun wakay thoemamay midh, ngay nga?’ Petheru nuy kuniya mulaydhin kedha, ‘Ngi Awgadhaw Woeyayzinga, ngi Keriso.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kalanu nuydh thana gud wadhaydhin kedha, ‘Mabaygoepa bangal mulayg in nubi ya.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nuy lak ngurpan aymaydhin thanamulpa kedha, ‘Mabaygaw Kazi ngaru bangal kikir gasamane, a thana yoewthaw koey mabaygal a kuyku misnarel a yoewthaw ngurpay mabaygal bangal ngoena adhapa yawaypu. Kalanu mabaygal ngoena uma mathaman a lak thoeri goeygilnga Ngaw Thathin ngoena bangal igil palane umangu.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kalanu nuy mura mabaygoepa mulaydhin ya matha ngoedhagidh kedha, ‘Mabayg nga nanga nungu ubi nuydh ngaybiya asin, wa yakanuriz nungu ubilnga a ngaybiya asir ngaw mab ngalagiya nanga. Ngitha bangal imane koey mangal puy, sathawro ngaw thabaynu. Kedha midh mura ngaybiya asin, ngidh ngaru nginu sathawro manin mura goeygiya, ngath midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Setha ngaya nanga thanamun ubi kedha thana thanamun igililnga danal poethaypa, thana kasa guythuyamoeyne bangal thanamun igililnga. Ngadh nanga nungu igililnga kasa guythuyan kuyk nungu danal poethay ngayapa, nuy kedha mabaygan ngaru gasamoene bangal nungu igililnga. ");
INSERT INTO mwp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Matha ngoedhagidh midh, mabaygan sike mura nabi apaw goewaw kapu rugal gasamoeyne, kasa kay kedha, nuydh nungu mina igililnga guythuyan. Lawnga sena gegeyadh, zaginga nubepa maypa nungu mina igililnga kuniya gasaman. ");
INSERT INTO mwp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","‘Nga nanga aziran mepa ngawngu a ngaw yangukudungu, wa Mabaygaw Kazi ngaru senawbi mabaygoengu aziran bangal memayine, ngaw kuniya mangay nanga wagel. Koey poeraparal thonara, ngaw koey poerapar a matha kedha Ngaw Thathingu poerapar, a nungu maygi angelal kalmel. ");
INSERT INTO mwp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngay ngithamulpa mina yangukudu umepa, dhuray mabaygal itha, thanamulpa umapa lawnga, kurusipa thana Awgadhaw Basalaya thanamun purkan imane.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesun senabi ngurpay eyth goeygi koeliya sikedh nuydh mamayidhin nubiya kalmel Petheru, a Zemes, a Yoewane thana kalanu padapa kadaypa woeydhamoeydhin thoeythu poegaypa. ");
INSERT INTO mwp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Si gimal nanga Yesu nuy thoeythu pagay, nungu paru ngadha kidh thayadhin, a nungu dhoemawakul adhapudhay goerab gamulmayl aymoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Balbayginga senabi thonara thana imamoedhin ukasar mabayg Yesulpa yadu umemar, kulba peropetha Mose a Elayza. ");
INSERT INTO mwp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Palay lak dhadhal palamun poeraparanu, Yesuniya ya sagul siyamar nungu kuthaw thonara midh paru nanga dhadha mangedhe muynu Yoerusalemoenu. ");
INSERT INTO mwp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petheru a wara ukasar niyay kazi thana koeyma uthuyn idimar kasa kay kedha thana uthuyginga, kurusipa thana imadhin senabi adhapudhay ngadhathoeyay sepalbi ukasar mabayg nanga siyamar Yesuniya. ");
INSERT INTO mwp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Palay nanga peropetha nungungu geth waniman Petheru kedha Yesulpa, ‘Kuyku mabayg ina mina kapu za, ngoey kalmel ngithamuniya itha. Kedha midh, ngoey kay thoeri iradh lagal moeydhamoeypa urapun ngibepa, a urapun Moselpa, a urapun Elayzalpa?’ Senabi thonara Petheru koerawayg kedha nuy kay midh mulepa. ");
INSERT INTO mwp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nungu yanu dhadhal, koey iridhal ziya ngapa thoeydhamoeydhin thanamuniya, thana mura muynu ziyanu, niyay kaziw akal koey zapul. ");
INSERT INTO mwp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yangu wakay ngapa ziyangu kedha thanamulpa ‘In Ngaw Geth Kazi, ngaw Adhapa Thoemayzinga, nubepa kurusipagemiw.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yangu wakay kalanu nanga thana imadhin matha Yesu nungu kusayg. Nabi za matha thanamuniya niyay kaziya, thana wara adhapa mulayginga senabi thonara. ");
INSERT INTO mwp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wara na goeyga Yesu a nungu thoeri niyay kazil poegamoeydhin mulupa padoengu koey garsar mabayg Yesuniya dhadha mangaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Urapun mabayg sizi mabaygaw goersarngu wal miyaydhin, ‘Ngurpay Mabayg, ngay ngibiya koeyma apasin, ngidh ngaw kazi iman, nuy gar ngaw Urapun Kazi? ");
INSERT INTO mwp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wati mari nubiya koey garsar thonaralnga, nuy senabi thonara ar pugiz a, ariridh ariz a mulupa pudhiz, a sik gudiya adhan kuyk senabi wati mari. Koey garsar thonaralnga nuydh nuyn gegeyadh manin, a nungu igililnga sagul palan. ");
INSERT INTO mwp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngay nginu niyay kazipa yoewdhaydhin, kasa kay kedha thanamulpa kasa yan nubepa balbay tidaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kuniya mulaydhin, ‘Ngitha nubi maykuyk, ngitha mina wara pawalgal, ngithamun mina yoepathaman gegeyadh, ngay in mi kuykuthalnga kalmel. Ngaw gamu koewba asin ngithamulngu, ngapa koepa kay nginu garkaz kazi mar.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wa, nuy moegina kaz ngapa Yesulpa, dhadhal nuyn wati marin mulupa thayadhin boeradharapa, nuy ariridh ariz. Yesu koey dharadh gar ngalkan senabi wati mari, a balbay tidan nuyn kazi, a kuniya manin nungu thathipa. ");
INSERT INTO mwp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mura mabaygal madhu pamemidhin, kuyk thana imadhin Awgadhaw koey bibiril zageth, moegina kaz dhoey nidhadhin. Mura mabaygiya na ngoenakapoenu thariz nanga Yesun mina zageth, nuy nungu niyay kazipa mulaydhin kedha, ");
INSERT INTO mwp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","‘Ngitha ngayapa kapu kurusipoegay ayman, yakanurayg, ngay ngithamulpa mi yadu umepa kedha, Mabaygaw Kazi bangal gud arane nubi apaw goewaw mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kasa kay kedha thana niyay kazil koerawaygal, nungu aykap midh, nuy miyaw yadu umepa. Nuy uthay thanamulpa yangu thanamulngu gasamoeyle, a thana akan memayir nubepa kuniya yapu poeybayle. ");
INSERT INTO mwp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kalanu thana niyay kaziw ya kasa koeyza woelmay, thanamun ubi imaypa kedha, thanamulngu ngunu kupay koeyza bangal. ");
INSERT INTO mwp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wa, Yesu ngulayg thanamun wakay thoemamay midh nanga. Nuy moegina kaz thuradhin a nubiya pasinu kaday tharadhin, ");
INSERT INTO mwp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A mulaydhin thanamulpa, ‘Mabaygan ngadh nanga ngaw nel tharan nubi moegina kazipa ayawal maypa, nuydh matha kedha ngoena ayawal manin, a muynu nanga matha ngoena lawnga ayawal manin, nuydh urapun mayn ayawal manin ngoena ngadh nanga ngapa wayadhin. Wa, ngithamun ubi imaypa, mabayg nga ngithamulngu koey gimal. Nuy nga nanga koey apal nungu geth imaynu, nuy senawbi mabayg ngaru gimal.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kalanu Yoewane kedha mulaydhin Yesulpa, ‘Kuyku mabayg, ngoey mabayg imanu, nuydh nginu nel thoeraypu wati maripa adhapa maypa mabaygoengu, a ngoey kay nuyn lawnga manu, minguz kedha nuy ngalpan thamu mabayg lawnga, ngalpaniya puziginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kuniya mulaydhin nubepa a matha kedha mura nungu niyay kazipa, ‘Maygi, nuyn lawnga maygi. Mabayg nga nanga nginu zageth mulupa thoeyayginga nuydh ngin ibupuydhan.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesun thonar na amadhan thamayidhin nungu Thathi ubin miyaydhin nubepa kadaypa maypa daparpa, nuy Yesu koey ridhanga parul thayadhin Yoerusalemoepa. ");
INSERT INTO mwp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nuydh mabaygal wayamoeydhin, thana muy uthemidhin Samariyaw mudhaw lagoepa, mura zapa balbay tidaypa nubepa, ");
INSERT INTO mwp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kasa kay kedha thana Samariyaw mabaygan nuyn ayawal mayginga kuyk thana imadhin nungu mab Yoerusalemoepa kuniya, thanamun wati igalgoepa. ");
INSERT INTO mwp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ukasar nungu niyay kazi Zemes a Yoewane imadhin senabi wati ngoedha thoeyay, a kedha mulemoedhin, Yesulpa, ‘Kuykulnga midh, ngi ubilayg ngalpa dapara muy thuraypa mulupa sethabi wati mabaygoepa mathamoeypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu koey dharadh buwayl thayaydhin palamulpa ubigasidhin. ");
INSERT INTO mwp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kalanu thana wara goegathoepa miyaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Thana nanga lak kuykayman mab wara mabayg ngapa Yesulpa a kedha mulaydhin, ‘Ngaw ubi gar ngibiya oesipa koezi kayboengu, nginu mab ngalaga nanga. Ngay bangal nginu gamu puziw mabayg.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kedha nubepa kuniya, ‘Ngibepa matha ngoedhagidh midh? Poksal thana lagalgal, thanamun lagal arkathal boeradharoenu, a uruyl thana lak kedha moeydhamoeypa padhal thanamulpa lagal, kasa kay kedha Mabaygaw Kazi nanga ngay lagagig ngaw gamupa ngoenapudhaypa, ngaw igililnga koey mapunga.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nuy wara mabaygoepa kedha mulaydhin, ‘Ngaybiya asir.’ Kasa kay kedha nuy mabayg kedha mulaydhin nubepa, ‘Kuyku mabayg, kedha midh, ngath mamu Ngaw Thathiw thonar ugaypa, moerama thoeyaypa nuyn. Sew kalanu kay ngay ngapa kalmel bangal ngibiya puzipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu nubepa kedha, ‘Ngi kedha lawnga, setha ngaya nanga kalal idimpa Awgadhiya, thana matha kedha uma mabaygal midh. Ngidh thana wani thanamun geth uma mabaygoepa moerama thoeyaypa; ngi uzar, mabaygal ngapa thuraypa Awgadhaw Basalayaw yangu wakay yadu poelgaypa thanamulpa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wara mabayg kedha mulaydhin, ‘Ngurpay Mabayg, ngaw ubi ngibiya oesipa kasa gar kay kedha kulay ngay mamu kuniya ngaw buwaypa yawo thuraypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kedha mulaydhin nubepa, ‘Ngibiya sike ukasar wakay thoemamay. Mabayg nga nanga nungu geth luwayan boeradharaw zagethaw zapa, matha ngoedhagidh, a nga nanga kuniya nagepa sena gegeyadh, nuy matha ngoedhagidh lawnga Awgadhaw Basalayapa a kedha matha ngoedhagidh lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kalanu Keriso lak adhapa thamayidhin 72 mabaygal. Nuydh thana kulay ukagud wayadhin mura yaynanab goegathoepa, a nuy lak nungungu wagel mabaw mabayg mura sethabi goegathoepa. ");
INSERT INTO mwp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wa, wagel kay nuydh thana woeyamoeydhin, nuydh kulay adha min tidadhin thanamulpa kedha, ‘Itha kurusipoegayzi mabaygal, thana matha kedha ayboewdhaw thonara na gasaman, igililmayl ngoedhe giya aydel, mina koeygarsar kasa kay kedha zagethaw mabaygal kasa moenarimayl kedha mabaygoepa garwoeydhamoeypa Awgadhoepa. Ngitha bangal thoeythupagemipu apaw lagaw Kuykulmaypa nubepa wara zagethaw mabaygoepa ngapa woeyaypa, ayboewdhaw zagethoepa garwoeydhamoeypa. ");
INSERT INTO mwp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","‘Ngitha ladhu, ngath ngitha wayamoeypa thanamulpa ngurpaypa. Ngitha matha kedha mamuy midh, a thana matha kedha thoeydhayl umay midh. ");
INSERT INTO mwp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngitha bangal kedha za oengayg ngithamun maboenu, bokadhzoengu yana lawnga, zangu yoewdhay yana lawnga, a wara azaz san lawnga. Thuma asig ngithamun maboenu mabaygoepa gud bangal thoerayg. ");
INSERT INTO mwp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ngipel mi thonara nanga lagiya muy uthemin, kedha muliz thanamulpa, “Awgadhaw pawdh a woenab ngithamuniya kalmel.” ");
INSERT INTO mwp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nuy lagaw mabayg nanga kapu gabu ngoenakapul mabayg, wa balbayginga ngipen pawdhaw yangukudu ngaru mepa nubiya. Nuy nanga mina mabayg lawnga, wa ngipen pawdhaw yangukudu ngaru lagoengu kuniya tidiz ngipelpa. ");
INSERT INTO mwp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ngipel matha senabi urapun lagoenu niyampa ngipen sob senabi goegathaw. Ngipel matha thanamun poeybayzi aydel purthempa a matha thanamun poeybayzi nguki. Matha ngoedhagidh kedha modhab poeyban zagethaw mabaygoepa. Matha thanamuniya puzir ngipen aypa, mura laga lagiya maygi. ");
INSERT INTO mwp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‘Mi thonara nanga ngipel muy uthiz goegathiya a thana ngipel ayawal mamaman, ngipel matha purthema setha mi ayde ngipelpa poeybiz. ");
INSERT INTO mwp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dhoeynidhamoeyr thanamun goegathaw kikirilgal, a thanamulpa kedha muli, “Awgadhaw Basalaya amadhan aymiz ngithamuniya. Nuydh ngitha ngapa thuriz.” ");
INSERT INTO mwp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","‘Mi goegath nanga ngipel muy uthemin kasa kay kedha thana ngipel ayawal mayginga ngipelpa kurusipoegayginga, wa matha thanamun yabugudoenu dhadhal kaday thariman a kedha mulaypa thanamulpa, ");
INSERT INTO mwp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ngapa nagi, ngalbe poey paleman ngalben sanoengu, ngithamulpa mina yoepathamaypa ngithamun kawrag. Kasa kay kedha Awgadhaw Basalaya yakanurayg. Ina waza ngithamun buth, nungu Basalaya amadhan mema ngithamulpa.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nuy lak mulaydhin nungu sebentitu niyay kazipa kedha, ‘Ngay ngithamulpa kedha muliz, kulay kay paypa Sodomalgal thanamun ipidhadh kulay koeyza kasa kay kedha nubi apaw goewaw zoeyzineydhay thonara gasamoene nanga, Awgadhoepa thanamulpa koey dharadhoepa aymoeypa lawnga. Nuydh ngaru bangal kaybaw kawragi goegath koey dharadh mamayine bangal.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kalanu nuydh mulamoeydhin sethabi goegathal ngalagiya nanga nuydh koey goersar adhapudhay zagethal aymoeydhin. Thana nungu zageth imadhin, kasa kedha thana garki thoeyayginga thanamun ipidhadh gegeyadhoengu. Nuydh goegathaw nelay thurimoeydhin kedha, ‘Kulay ngitha Korazinalgal, wati za ngithamuniya bangal mangedhe; ngitha Bethsaydhalgal lak kedha; thana kay paypa kulay mabaygal Tayaroenu a Saydoninu nay, kedha adhapudhay zagethal imaydhin nay setha mi zagethal ngithamuniya aymoeypu, thana ngaru nay mina kulkub garki thayamoeyn a awmaw rugal ubamoeydhin a muyngu kunural pinimoeydhin kuykuya thanamun wati wakasinoepa yakamoeypa. ");
INSERT INTO mwp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Awgadhaw minamay thonar nanga mangedhe, thana Tayaralgal a Saydonalgal lak moegina balbaygi kuth, ngitha Korazinalgal a Bethsaydhalgal, ngithamulpa bangal koey gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ngitha Kapoeniyamalgal ngithamun gamu dhuba yoeruy koeyza a ubi kedha, ngitha bangal ngithamulngu kaday nithamoene koeyza dapara; kasa kay kedha, ngitha bangal genoepa idimoeyne.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu nungu niyay kazipa lak mulaydhin kedha, ‘Ngitha mina yangukudu mabaygal. Nga nanga koerngaylnga ngithamulpa, wa nuy koerngaylnga ngayapa, a ngadh nanga ngitha adhapa imiz nanga, adhapa iman ngoena, a ngadh nanga ngoena adhapa iman nuydh adhapa iman urapun mabayg ngoena ngadh na wayadhin.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wa, thana ladhudhin senawbi zagethoepa oengaypa. Kalanu nanga thana kuniya tidemidhin koey ikalnga dhiwalnga. Thana kedha mulemidhin, ‘Kuykulnga, lak wara zaginga, wati marin ngoeymulpa karngemin ngoey nanga nginu nel tharan.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu thanamulpa kedha, ‘Ngath Sathanan imadhin, nuy pudhaydhin daparngu ngapa mulupa ngoedhe poenipoen nge. ");
INSERT INTO mwp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Karngemiw kedha, ngath ngithamulpa kupayl madhin kedha, ngithamun maboenu Sathanan nuthan dhadha mangiz. Aka gasamayg Sathanan nuthayl zoengu. Wara thonara ngi gimal tharan thabunu a watharaw githalay. Ngitha gegeyadh gasamayginga kuyk ngath ngitha danal pathepa Sathanalngu. Wara gegeyadh zapa ngithamulpa gasamoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kasa kay kedha, kasa moegina ika gasamaw kedha thana wati maril ngaru ngithamuniya apal, a adhapudhay ika dhiw gasaman ngithamun nelay gimal poelayzimayl dapara.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Senawbi thonara Yesun ika koeyza kuyk Maygi Mari nubiya, a nungu thawmayzi yangukudu kedha, ‘Thathi, ngi gimal Daparaw Kuykulnga a ina apal. Ngay ngibepa koeyma gud woeydhiz, kuyk ngidh mina zapul yadu poelgaypu ngurpaygi mabaygoepa, a ngurpayzi mabaygal nanga mina ngulayg mabaygal. Ngidh wara thonara wardhamoeyn thanamulngu imayle. Wa, sena nginu ubilnga koey mabayg koerawayg a moegina kaz nuy ngulayg, setha ngoenu nanga ngoenakap apal. ");
INSERT INTO mwp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mura sethabi zapul Ngaw Thathin ngayapa mamayidhin muwasimoeydhin, a matha nuy Thathi ngulayg nungu kazingu, mabaygal mura koerawaygal. Matha kedha thana Thathingu lak koerawaygal, matha ngay Nungu Urapun Kazi nungungu ngulayg, a matha kedha ngaya nanga ngath thanamulpa seysithaman, matha thabi mabaygal ngulaygal.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kalanu nuy nungu niyay kazipa buwayal thayadhin, a muynu kedha mulaydhin, ‘Koey woenabalnga ngitha, mabaygal ngaya nanga purkan iman thabi mina zapul kayib. ");
INSERT INTO mwp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wa, ngay ngithamulpa kedha muliz kedha, kuykuthalnga mabaygal yan ugadhin senabi zapa imaypa thanamun purkan, matha kedha koeyma kulba peropethal, a kuyku mabaygan, a thanamun ubi thana purkan iman a kawran karngimir nabi mina za, kasa kay kedha lawnga. Nabi maykuykoepa kakal yakaman.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wara thonara yoewthaw sabiw ngurpay mabayg ngapa Yesulpa, nubepa yabu lumay ayman. Nuy yapupoeybaydhin, ‘Ngurpay Mabayg, ngath bangal miza aymoeyne gasamoeypa ngaru igililmaypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kuniya modhabiya muliz nubepa, ‘Maygi Thusi midh maw tharepa a yadu palgan a? Nginu imaypa midh?’ ");
INSERT INTO mwp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nuy kedha, ‘Ngitha ngaru maman manin ngithamun Kuykulnga mura ngithamun ngoenakapoengu, a mura ngithamun mina muy igililmayngu a mura ngithamun wakay thamamayngu, a ngithamun gamu moegawngu.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kuniya, ‘Wa, ngi balbayginga muliz, ngidh na mina ayman nanga, wa gasaman ngaru igililnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nuy yoewthaw ngurpay mabayg, nungu ubi nuydh kay nungu ya oengaypu kay ngaru. Nuy kedha, ‘Ngaw pasiw mabaygal ngaya ngayapa thanamulpa maman maypa?’ ");
INSERT INTO mwp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu nubepa kuniya adha min tidar kedha, ‘Wara mabayg nuy mulupa miyaydhin Yoerusalemoengu Zerikopa. Dhadhal nanga wati mabaygal nubiya dhadh mangemidhin, mathamoedhin a gamu rugal kusumoedhin, a badh paladhin; wanadhin nuyn thatha igililnga. ");
INSERT INTO mwp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wagel ngapa misnare, nuyn imadhin yabugudoenu. Nuydh kasa iman, nungu mab matha walman wara doegamuya. ");
INSERT INTO mwp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A wagel ngapa senabi yabugudiya misnari buway mabayg; kasa purkan iman, mab matha woelmay. ");
INSERT INTO mwp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nubiya wagel Samariyalayg ngapa senabi yabugudiya. Nuydh iman, a nungu ngoenakap koey koerkak badh. ");
INSERT INTO mwp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nuy gamupa uzaraydhin a umal nguki suladhin nungu badhiya; kalanu wakasu suladhin, a kuykuthal dhoemawakun nurimoeydhin a thoeridhaydhin nungu donkipa. Nuydh madhin nuyn mabaygaw danal poethay lagoepa nubepa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bathaynga na goeyga nanga nuydh ukasar koey bokadhza poeybamoedhin danal poethay mabaygoepa a mulaydhin, “Danal bangal in poethaypu nuyn, ipal palay bokadhzapul eygi thayaman nanga, ngaw kuniya tiday ngapa, ngath lak ukaman ngidh nanga sagul palan nubepa.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesun moeygoepa yangukudu nubepa kedha, ‘Nginu imay midh, itha thoeri mabaygoengu, mathamayzi mabaygaw pasiw mabayg nga?’ ");
INSERT INTO mwp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nuy yoewthaw mabayg kedha kuniya mulaydhin, ‘Nubepa ngadh nanga ibupudhay ayman.’ Yesu kuniya mulaydhin, ‘Wa, ngi uzar, ayman senawbi mina pawa.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu a nungu niyay kazil thanamun maboenu tadir ngapa wara mudhaw lag ngalaga nanga yoepkaz nel Matha. Nadh Yesu a niyaykazil muya idiman nanu lagiya. ");
INSERT INTO mwp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nanu tukuyap wara, nel Mariya. Na Yesun ngaranu apal thanuraydhin, kurusipoegay nungu ngurpaypa. ");
INSERT INTO mwp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kasa kay kedha nanu tukuyap kedha muynu wakay thoemamiz, ngath kay midh paru aydu poeybepa a danal poethay thanamulpa. Na sipa Yesulpa a muliz kedha, ‘Kuykulnga, ngibepa matha ngoedhagidh midh; ngoezu tukuypan ngoena ibupuydhayginga; nadh mura zapul ngayapa wakayn pagepa! Nabepa ya mulaypa ngayapa ibupuydhaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nuy Kuykulnga nabepa kuniya mulaydhin, ‘Matha Matha, ngi mipa koeyma wakayn toemamipa mura thabi zapa; ");
INSERT INTO mwp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nginu tukuyap Mariya, nabepa urapun za matha ngoedhagidh ubilnga; matha ngoedhagidh lawnga nanungu adhapa manin, senawbi mina za, senabi za matha ngoedhagidh mura mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wara thonara Yesu nuy nungu kusayg wara lagoepa thoeythu poegaypa, nuydh na muwasin nanga wara niyay kazi nubepa muliz kedha, ‘Kuykulnga, ngidh bangal ngoey ngurpamoeypu thoeythupoegayn Yoewane midh nanga nungu niyay kazil ngurpamoeydhin?’ ");
INSERT INTO mwp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nuy kedha thanamulpa, ‘Ngitha bangal nanga thoeythupagemipa kedha, “Ngoeymun Thathi gimal dapara, ngoeymulpa koey ubilnga nginu maygi nel thawmanin a kapu za nginu basalaya danapa yakamiz a mura mabaygal ayman nginu ubilnga ina apal, a matha kedha ngoedhalnga gimal dapara. ");
INSERT INTO mwp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ngidh ngoeymulpa matha ngoedhagidh poeybar ngoeymun goeygipa ay. ");
INSERT INTO mwp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ngidh ngoeymulpa ngoeymun ipidhadh gegeyadh gudwayar, a ngoey lak kedha wara mabaygaw ipidhadh gegeyadh gudwayamoeyn, thana mi thonara nanga ngoeymuniya bal pudhemipa. Ngidh gar ngoey ridh palimoeyn mura nuthayl zoengu ngoeymulngu wati zoengu aymayle.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kalanu nuy niyay kazipa mulaydhin kedha, ‘Wara thonara nanga nginu igalayg sike mangiz dhadha kubilu. Nuy ngapa koeysigaz lagoengu. Ngi nanga aygig nanga, ngi ngaru wara igalgoepa a yoewdhiz kedha, “Ngaw igalayg, ngidh gar ngayapa thoeri thoewa aydel kasa thawpay thonarpa? Wara ngaw igalayg mangiz koey sigaz lagoengu; ngay zagig nubepa poeybaypa!” ");
INSERT INTO mwp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Kasa kay kedha nginu igalayg sike kedha muliz ngibepa, “Ngi ngapa maygi, ngaw pasa muynguz thamudhayzinga; ngay a ngaw kazil ngoey uthuy lagoenu. Ngayapa koey zageth uthuy lagoengu dan poelaypa ngibepa zapa poeybaypa.” ");
INSERT INTO mwp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wa, nuy ubigig nungu igalgoepa ibupuydhaypa kedha zoenguz kedha dhadha kubil, kasa kay kedha ngidh ngaru yapu poeybaypa, kurusipa nuy ridha koewban dan paliz a poeyban ngibepa nginu ubilnga mura. ");
INSERT INTO mwp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","‘Wa, ngay ngithamulpa kedha muliz, ngi muliz a ngibepa poeyban, ngidh luman a ngidh iman, pasa mathamar, a na ngaru gud pudhiz ngibepa. ");
INSERT INTO mwp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mura setha ngaya yudhemipa, thana gasaman, a ngadh luman thana iman, a ngadh mathaman wa pasa pudhiz. ");
INSERT INTO mwp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngitha thathil ngaya nanga, ngitha ngulaygal miza balbayginga ngithamun kazipa. Nginu kazi nanga ngibepa wapi tharan, ngidh koey zageth thabu manin nubepa. ");
INSERT INTO mwp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A matha kedha nuydh ngibepa kakur tharan, ngidh koey zageth nubepa watharaw githalay manin. ");
INSERT INTO mwp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","‘Ngithamun igililnga koey garsar zapul yoewdhepa, kasa kay kedha ngitha ngulaygal mina za ngithamun kazipa midh. Daparaw Thathi siba wanan ngaru mina adhapudhay ngithamulpa matha kedha Maygi Mari poeyban mabaygoepa ngaya nanga nubepa yoewdhemipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wara thonara Yesu, nuydh lak kedha zageth ayimpu, a wati mari nuydh adhapa madhin mabaygoengu. Nuy mabayg ngaru yagig, kuyk senawbi wati mari nuy kedha ngoedhalnga, kasa kay kedha wati marin nanga adhapadhadhin mabaygoengu, nuy kalanu ya mulaydhin balbayginga senabi mabayg. Mura mabaygal madhu pamemidhin. ");
INSERT INTO mwp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dhuray mabaygal thanamulngu kedha, ‘In Bilzibul mura wati mariw kuyk nuydh Yesulpa kupay poeyban. Nuy kedha zoenguz ngulayg wati maripa adhapa maypa mabaygoengu.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wara mabaygal yabu luman ayman Yesulpa. Thana nubepa mulemidhin kedha, nuydh kay adhapudhay zageth ayimpa, lak mura mabaygan purkan gasaman kedha, midh Awgadh nubiya kalmel. ");
INSERT INTO mwp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nuy Yesu koey ngulayg thanamun wakay thoemamaynu midh. Nuy kedha thanamulpa, ‘Koey goegath nanga dhadhiya miziz ukasar thamu muynu, kidhakidhan pathowkaman, ngaru piranga sobaginga idimiz, a buway lak kedha, thanamun kedha mabaygaw igililnga bangal ngaru gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Matha kedha Sathanan buway. Na nay nabiya muynu ukasar thamu kidhakidhan pathowkaman, midh paru na kuykuthalnga kaday sipa Sathanan buway. Ngithamun kasa wakay thoemamay kedha ngath ngaw kupay gasaman Sathanalngu wati maripa adhapa maypa. ");
INSERT INTO mwp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","‘Lawnga! Kedha lawnga. Ngay koey ngulayg kedha ngithamun ngurpay kedha, ngithamun niyay kazil ngulayg wati mari adhapa maypa mabaygoengu. Thana ngalagaz thanamun kupay gasamadhin, thana lak Sathanalngu gasaman lawnga midh? Wa, thana ngaru zoeyzi noeydhiz ngitha, ngitha nanga kedha, na kupay ngapa Sathanalngu. (Sathanan wara nel kedha, Bilzibul.) ");
INSERT INTO mwp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na ngaru kakal ngithamulpa kedha ngay ngulayg wati mari adhapa manin kuyk Awgadhaw geth ngaybiya gimal. Kedha nanga Awgadhaw Basalaya dhadha mangiz ngithamuniya, zageth ngaru magawlnga. ");
INSERT INTO mwp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Koey magawl mabayg nanga nubiya mura nungu koewbu rugal butha pathayzimayl danal poethaypa nungu lagoepa; wa muynu mura zapul nungu, balbayginga. ");
INSERT INTO mwp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","‘Wara na mina koey magawl mabayg mangiz nubiya, a senabi lagaw mabayg mulupa thayan, kalanu nuydh koewbu rugal adhapa mamayin senabi lagoengu. Nuy lagaw thathiw mina yoepathaman kedha, nuy balbayginga kuyk sethabi koewbu rugal, kasa kay thana mura adhapa mamayin, a nuydh kowebuzi mabayg nungu ubin dhadh mamayin zapul mura nungu mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","A ngitha sike mi dagam mabaygal? Ngadh nanga ngoena ibupuydhayginga, nuy ngawngu koeysigal, wati igalayg; a mabaygan ngadh nanga ngoena ibupuydhayginga mabaygoepa garwoeydhamoeypa, nuydh mabaygal adhapa thoemaypa, thanamun igililmayl sagul palimoeyn. ");
INSERT INTO mwp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Ngath nubi maykuykaw kuth seysithamaypa ngithamulpa; mabayg sike wati mariw malayzinga, a senawbi wati mari adhapadhan mabaygoengu, nuy kasa mura loegiya ulaypa, ngukigi lag. Nuy lagiya yan lumepa nubepa uthuypa. Nuydh nanga lag gasamoeyginga nuy nubiya muynu kedha miziz, “Ngay lak ngaw kulay niyaylagoepa kuniya tidepa, senabi mabaygaw igililmaypa muypa.” ");
INSERT INTO mwp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","‘Nuy kuniya tidiz senabi niyay lagoepa. Nuydh iman, pudhunga kapu butha poethayzinga. ");
INSERT INTO mwp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wa, wati mari lak gurguy toedipu igalgoepa lumaypa. Nuydh iman seben lak wati maril mina koey gegeyadh nubiya, a thana ngapa sin nubiya nungu niyay lagoenu. Kurusipa nungu muy yoewthayzi mabaygaw igililnga mina koey gegeyadh, kulay nuy midh nanga kuyk wati maril koeygarsar nubiya muynu.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesun kedha ngurpaynu dhadhal, a urapun yoepkaz na wal miziz mabaygoengu dhadhaz. Na nubepa kedha, ‘Koey woenabalnga, ika gasaman senabi yoepkaz ngadh ngin kazi madhin nanga a danal poethaypu.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu nabepa kedha mulaydhin, ‘Kedha za moegina woenabalnga, kasa kay kedha koey woenabalnga kedha mabayg nga Awgadhaw yoepa kurusipagepa a aymoeypa nungu ubilmayl.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wa, mabaygal mina koeyma ngapa Yesulpa, nuy yadu matha umay kedha, ‘Mina koey gegeyadh kaybaw maykuyk. Ngitha mura thonara adhapudhay zageth purkaw imaypa umamoeypa. Matha urapun adhapudhay zageth ngitha imane bangal, sena mi adhapudhay zageth aymoedhin kay paypa kulay Yonan doegamoenu, wa senabi adhapudhay zageth aymoeyne bangal ngithamuniya dhadhal. ");
INSERT INTO mwp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonan sakara nanga nuyn kay paypa kulay yakamoedhin Ninebaw mabaygoepa. Thana imadhin koey zageth kuyk senabi peropetha, a ngitha bangal lak kedha ngoedhal za imane Mabaygaw Kazipa kaybaw maykuykoepa. ");
INSERT INTO mwp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","‘Lawnga! Ngithamun ngoelkay yoepathaman koeyza. Awgadhaw kuthaw goeyga nanga mura mabaygal bangal kaday nithamoene, matha kedha wara kuyku yoepkaz zoey doegamoengu. Kay paypa kulay na ngapa ngalpan kuyku mabaygoepa imaypa, Solomon. Na kakal aymiz kedha nanu mina yoepathaman mina koeyza, ngitha lawnga. Kedha zoenguz na uzaraydhin koeysigaz nanu boeradharoengu, koerngaypa Solomonan yoepa a nungu mina ngurpay. Kasa kay kedha mabayg kay ngithamuniya koeyza adhapudhay Solomonaniya. ");
INSERT INTO mwp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","‘A Ninebaw mabaygal lak kedha kuthaw goeyginu nanga thana mura kaday nithamoene. Na bangal kakal kedha thanamun mina yoepathaman koeyza, ngitha lawnga. Minguz kedha thana gasaman Yonan maw a thana garthi thoeyamoeydhin mura wati pawangu. Wara mabayg maw sipa in nuy ngaru koeyza Yonaniya ngitha mingu garki thoeyayginga?’ ");
INSERT INTO mwp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu lak mulaydhin thanamulpa kedha, ‘Mabaygan koey zageth thungi gamu woeydhan, kalanu bupa wardhan a matha kedha kubarnu apiya thayan. Lawnga nuydh ngaru nanu thoeray lagoenu tharan, kalanu mabaygal muya na uthemin nanga thana iman nanu buya. ");
INSERT INTO mwp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nginu purka matha kedha thunge nginu gamupa, nginu purkiya nanga balbayginga nginu mura gamu koey zurulnga, balbayginga. Wara kedha nginu na purka gegeyadh nginu gamu mura inur, igililnga ngaru gegeyadh. ");
INSERT INTO mwp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","‘Ngithamulpa sike kedha ngithamun gasamayzi ngurpay ngoedhe koey buyalnga. Ngay ngithamulpa kedha muliz, koey poeypiyam bangal, na lawnga inur. ");
INSERT INTO mwp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ngi nanga buyanu nipa nanga sena buya nginu gamunu muynu wara moegina kopi inur mayginga, na zuru mura pathan, matha kedha thunge zuru midh nanga ngi zurunu dhadhal nipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesun senabi ngurpay kalanu, wara Parasayalayg nuyn thuradhin thanamuniya kalmel aygudoepa. Wa, Yesu kalmel asidhin thanamuniya a apa thanuraydhin aygudoepa. ");
INSERT INTO mwp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nuy Parasayalayg madhu pamaydhin nuydh na imadhin kedha Yesun nuy geth garwalgayginga kulay, wagel kay aygud, purthaydhin. ");
INSERT INTO mwp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kuykulnga kedha mulaydhin nubepa, ‘Ngitha Parasayalgal, ngitha kasa adhiya aygudaw rug garwalgan, mina muynu gamunu nanga ngitha mina koey gegeyadh, kunubur a matha kedha wati pawa. ");
INSERT INTO mwp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngitha koey rimarim mabaygal, Awgadh nuydh aymoeydhin mura zapul, za adhal a matha kedha za mina muynu. ");
INSERT INTO mwp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lak ngithamun mina ubi nanga ngitha pudumayl gamunu muynu, zapa garwalgaypa ngoenanu maygi, ngitha ngaru ngoenakapoengu poeybamoeyn aygi zagi mabaygoepa; kalanu ngitha mura balbayginga. ");
INSERT INTO mwp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ngitha bangal gegeyadh gasamoene, Parasayalgal, ngitha mura moegina sabil koey garsar aymoeypa, matha kedha ngitha ngulayg mura moegithap nagul dhadhiya dhadh mamayipa Awgadhoepa a ngithamulpa, kasa kay kedha ngitha mina pawaginga mabaygoepa, a Awgadhaw mamanu maboeginga. Kapu za ngidh oengaypa a wagel kay ngidh aymoeypa mura moegina sabil. ");
INSERT INTO mwp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Ngitha bangal gegeyadh gasamoene Parasayalgal, ngitha koey ubilgal kedha kulay, mina niyaylagal adhapa thamayin ngithamulpa, yoewthanu muynu, a sawalagoenu lak kedha, ngithamun koey ubi mabaygal mura apasimoeyn ngithamulpa. ");
INSERT INTO mwp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wa, ngitha bangal gegeyadh gasamoene, ngithamun igililmayl kasa gimiya muk ngitha ngoedhe kulba moerama thoeyay lagal bupanu muynu pada kuyku kulaginga, mabaygal koerawaygal kasa gimiya toedipu, thanamulpa gumi kedha thana senabi zoengu gegeyadh palimoeyn amenipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wara sabiw ngurpay mabayg, nuy Yesulpa muliz kedha, ‘Ngurpay Mabayg, ngi na senabi yangukuduya umepa ngidh matha kedha ngoey mogo pugamoeypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nuy Yesu nubepa kuniya kedha muliz, ‘Wa, ngithamulpa lak kedha ngitha sabiw ngurpay mabaygal. Ngithamulpa koey gegeyadh bangal. Ngitha mapu thabaynu kabuthoepa mabaygiya, thanamulpa koey mapunga thoeridhoeypa. Ngitha wara moegina thana ibupuydhayginga, senawbi mapu. ");
INSERT INTO mwp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngithamulpa bangal mina koey gegeyadh kedha, ngitha mina thawmanin ayman mura kulba peropethoepa, kapu padhakuyku kulal ayman thanamulpa. Kasa kay kedha ngithamun thawmanin kasa ngoelkay. Minguz kedha, ngithamun thathiw thathil umamathamoeyn thana, ");
INSERT INTO mwp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","A ngithamun ubi kedha, ngitha asimoeyn senabi wati pawa ngithamun thathiw a ayman. Thana umamathampu Awgadhaw woeyayzi peropethal, a ngitha lak thanamulpa pada kuyku kulal aymoeypu. Mina muynu nanga ngithamun ngoenakap ubilnga matha kedha ngithamun thathiw thathil midh. ");
INSERT INTO mwp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Wa, Awgadh koey ngulayg ngithamun buway ngapa midh paru nanga. Nuy nungu adhapudhay ngulaygoengu kedha mulaydhin, “Ngath bangal woeyadhe peropethal a yangu mabaygal sethabi buwaypa, a thana bangal wara umamathamaypu a wara adhapa imepu, a danal poethay thanamulpa gegeyadh.” ");
INSERT INTO mwp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wa senabi gegeyadh nabi maykuykun bangal gasamoene, mura parungu ngapa ngithamun buway gegeyadh, ina gugu ubidh thoeyayzinga na aymoeydhin ina apal. ");
INSERT INTO mwp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","‘Kuykayman Aboelan kulka pay yoewdhaydhin a kurusipa pawpa peropeth Zakaraya kuykuginga mathamoedhin yoewthanu muynu, nuy dhadhal oltanu a koey maygi lag. Wa, ngay ngithamulpa muliz kedha, kaybaw goeygiw mabaygoepa, ngitha bangal mapu gasamoene senabi gegeyadhoengu, parungu ngapa kurusipa kayib. ");
INSERT INTO mwp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ngithamulpa sabiw ngurpay mabaygoepa mina koey gegeyadh. Pasa pudhay za ngithamun gethoenu mepa pasapa gud pudhaypa, ngalaga nanga mura Awgadhaw mina ngurpan lagoenu muynu mepa. Ngithamun ubiginga muya yoewthayle a matha kedha ngitha wara mabaygal ibupuydhayginga, kalanu thana senabi buya gasamayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu nanga geth wanaydhin senabi lagoengu, thana Parasayalgal a sabiw ngurpay mabaygal, thana wagel asimoeydhin a koeygarsar ya umamoeyr a mogo pugar nuyn. Thana na nuyn yapa mar yapu poeybemir koey garsar zapa. ");
INSERT INTO mwp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Minguz kedha, thana nubepa poethi aymar thanamun ubi kedha, thana nuyn gegeyadh manin thana nanga nungungu wati ya gasaman. ");
INSERT INTO mwp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Senabi thonara mabayg buthudh koeygarsar ngapa Yesulpa. Thanamulpa maboepa gegeyadh woerginopa tadir. Yesu kulay nungu niyay kazipa ngurpay ayman kedha, yadu thuriz, ‘Ngitha kulay poeypiyam, Parasayalgal koey gamu dhoebu yoeruylgal, kasa mamuy goengaw oengemipa. ");
INSERT INTO mwp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kasa kay kedha setha mi wati pawal nanga abayzimayl imayginga, mura muy wati pawal nanga thana bangal kakal aymoeyne. ");
INSERT INTO mwp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kasa midh, ngi inura yadu umepa nginu ya bangal gasaman goeygiw buyanu. Kasa ngi midh koey muynu yadu umepa nginu ya bangal karngemin kedha, mabayg thodhanu wal mepa. ");
INSERT INTO mwp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngaw igalgal ngay ngithamulpa kedha muliz, ngitha akan maygi gamun ngadh umamathampa, nubepa kalanu zapa wara aymoeypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","‘Ngay ngithamulpa yadu poelgaypa akal mabayg nga nanga; matha nuy urapun kupaylnga gamu uma mathaman a mari genoepa thayan. Ngayapa mina yoepathamaw, matha nuy urapun kedha akalnga, nubepa apasimaw. ");
INSERT INTO mwp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Awgadhaw danal poethay mura mabaygoepa, matha kedha ngidh payb moegina uruyl yoewdhan ukasar moegina bokadhzoepa, modhab koey apal kasa kay kedha Awgadhoengu yakanurayginga urapun kedha moegina uruy. ");
INSERT INTO mwp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A nungu danal pathan mura ngalpalpa kedha ngoedhalnga, kedha zoenguz kedha nginu kuyku yalbupal nanga, nuy mura ngulayg, nubepa mura kakal. Akaginga, nungu mam a ubilnga mabaygoepa koeyza kedha moegina uruyaya lak gimal.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Wa, ngay lak ngithamulpa ya muliz kedha, mabayg nga ngulayg nuy mabaygaw parunu yadu umepa kedha, nuy ngaw mabayg, wa Mabaygaw Kazin bangal nubepa lak kedha aymoeyne mura Awgadhaw angelaw parunu, senabi goeyginu. ");
INSERT INTO mwp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A mabayg ngadh nanga ngoena adhapa yawaypa mabaygaw parunu, wa Mabaygaw Kazin lak kedha bangal adhapa imane Awgadhaw angelaw parunu. ");
INSERT INTO mwp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mabayg nga gegeyadh yadu umepa ngoena Mabaygaw Kaziya, wa Awgadhan ngulayg nubepa guythuyan sena nungu gegeyadh, kasa kay kedha ngadh nanga Maygi Mari mogo pugan, lawnga nubepa kedha gegeyadhoepa pa woeyaypa lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Wagel bangal thana yoewthaw kuyku mabaygal kasa kobegadh ngitha mamayine thanamun yoewthoepa a ngitha bangal kotoepa gasamoeyne thanamun kupay mabaygiya parunu. Wagel kay bangal nubi za, ngitha koeyma wakay thoemamayg kedha, ngithamun kuniya midh ngithamulpa kaludhaypa. ");
INSERT INTO mwp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maygi Mari bangal senabi thonara kalmel, a nuydh bangal ngitha yangukudun ngurpamoeypu sethabi thonara a ngithamun balbaygi yaday midh nanga kuniya kupay mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mabayg mina koey garsar; urapun mabayg thanamulngu nuy ngapa Yesulpa muliz kedha, ‘Ngurpay Mabayg, ngaw tukuypan ngayapa dhadh mayginga Ngaw Thathiw wanayzinga aykuyk. Ngi gar bangal nubepa muledhe?’ ");
INSERT INTO mwp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu nubepa kedha muliz, ‘Kame, sena ngaw kupay lawnga, ngipen zapa dhadhiya dhadh maypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nuy kalanu mura mabaygoepa mulaydhin kedha, ‘Koey poeypiyam bangal, kunubur oesig ayngu zoengu, setha mabaygaw mina igililmay zapul lawnga, nuy mi koey aydeg zapulayg nanga in apal.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kalanu Yesu thanamulpa adha min tidar kedha, ‘Wara mabayg nuy koey aydeg zapulayg, nungu apawlagoenu ay mina koey goesar. ");
INSERT INTO mwp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nubiya muynu nuy wakay thamamaynu kedha, “Garwoeydhamoeyzi ayde mina koey garsar. Ngaw sawalagal matha ngoedhagidh lawnga bupa woerdhaypa, ngath bangal miza aymoene?” ");
INSERT INTO mwp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nuy kedha wakay thamamayidhin, “Wa, ngath bangal mulupa idimoeyne sawalagal, kalanu bangal ngath koey zapul moeydhamoeyne, ngayapa buthalnga ngaw kun a mura zapa bupaw woerdhaypa. ");
INSERT INTO mwp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kalanu ngay ngayapa muliz kedha, kapu woenab itha mura ngaw kapu zapul mura koey goersar wathaw igililmaypa. Ngay sike bangal matha ngoena pudhedhe; ngay kay mina koeyma aydu purathipa a kay koeyma nguken wanepa.” ");
INSERT INTO mwp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Kasa kay kedha senabi kubilu Awgadh mulaydhin nubepa kedha, “Ngi matha ngoedhagidh lawnga. Ngi kasa matha ngi ngibepa, kaybaw kubilu ngath kay nginu igililnga maypa. Kalanu itha thabi zapul ngadh gasamoeyne, nginu kudun mamayidhin?” ’ ");
INSERT INTO mwp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kalanu Yesu kedha mulaydhin, ‘Ina bangal kedha gegeyadh nanga, mabayg matha ngoedhagidh lawnga nuy nubepa nubiya muynu, kasa kay kedha nungu rugal kasa moenarimayl Awgadhaw doegamoenu.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu nuy muliz nungu niyay kazipa, ‘Wa, nuy matha nungu maythapa wakay thoeyaydhin. Ngitha koeyma wakay thoemamayg ngithamun aypa lak ngitha igililmayl, a ngithamun gamu ubamay rugal. ");
INSERT INTO mwp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngithamun igililmayl ngaru mina zapul, a ngithamun aydel kasa ngoelkay zapul. Ngithamun gamul lak kedha mina zapul, a rugal kasa thawpay thonarpa. ");
INSERT INTO mwp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","‘Matha kedha ngitha uruyl imiz, kuwal, thana nagu uthuyginga a aygud gasaman. Thana sawalagoegigal thanamun aypa garwoeydhamoeypa, kasa kay kedha Awgadhan aydu poeybepa thana, a ngitha nanga mabaygal, Awgadhoepa adhapudhay mamalmayl uruyiya. ");
INSERT INTO mwp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Koey zageth ngidh moegina kuykuthal palan nginu igililnga, kasa midh ngidh koeyma wakay thoemamipa. ");
INSERT INTO mwp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngi nanga koey kuthuka kedha moegina zagethoepa nanga, ngidh kay midh paru koeyma ngoenanu maypa nginu mura igililmay sakarpa? ");
INSERT INTO mwp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nginu dhoemawakupa lak kedha; nagemiw thana setha bupaw poelawal, thana zageth aymayginga, doemawakul aymayginga thanamulpa, ngay ngithamulpa kedha muliz, thana ploewal adhapudhay rugalgal Solomon midh nanga, nuy adhapudhay kuykulnga. ");
INSERT INTO mwp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","‘Matha Awgadhaw zageth kedha, nuydh bupaw poelawal kapu ngadh poelaypa, setha thawpay thonaraw zapul. Kayib thana kapu ngoedhalmayl, bathaynga nanga thana kay asimoeyn a muypu noegidhan. Nuydh ngaru ngin rugan ubampa nginu kapu akasin midh paru kuthuka? ");
INSERT INTO mwp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Koeyma ngoenanu maygi kedha, nginu aypa ngukipa. Inuraw mabaygaw pawa kedha, thana koeyma ngoenanumaypa sethabi zapa. Ngitha kedha maygi. Maythaw doegampa ngoenanu maygi, kuyk nginu Daparaw Thathi ngulayg kedha nginu gamupa za miyay matha ngoedhagidh. ");
INSERT INTO mwp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mamu ngidh ngoenanu manin kuykulmay zageth, a mura nungu ubilmayl; a nuydh kay nginu ubilnga ayman mura, sena nungu kozan ngibepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Ngitha ngaw gamu puziw mabaygal, ngitha koey bibiril mabaygal lawnga, ngoedhe kedha moegina mamuy kubi. Akan maygi, kuyk ngithamun Thathiw ubilnga kedha nuydh ngithamulpa bangal manine mina zageth nungu Basalayanu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngoenanu maygi ngithamun rugal itha apal. Ngidh mamu sakariya bokadhzapupa, nginu rugal. Kalanu ngidh sethabi gasamayzi bokadhzapul poeybamoeyn aygi zagi mabaygoepa. Kalanu ngithamun bokadhzoengu yanal itha apal lawnga. Thana matha ngoedhagidh gimal idimaygi zapul ngalaga nanga, puru mabaygoeginga, a matha kedha moegina uruyginga idimaypa. ");
INSERT INTO mwp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngalaga nanga nginu kapu ubil za, nginu ngoenakap ngaru sin mepa, a zagethal lak kedha thimedhalnga. ");
INSERT INTO mwp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Ngitha ngaru buth poethayzimayl mura thonara, ngithamun rugaw ubamoeypa zagethoepa aymaypa, a ngithamun thungiyal ngaru siyamaypa. ");
INSERT INTO mwp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","37","Ngitha ngoedhe kedha nge, zagethaw mabaygal thanamun kuyku mabayg ugan nuy nanga ngapa kuniya, niyaypa yoelpay ayngu koey kubilu. Matha ngoedhagidh kedha nuy na ngapa nanga pasa mathaman, thana sobaginga pasa pudhan nubepa, kuyk thana danalgal nuyn ugan. Thanamun woenab kedha nuydh iman thana nubepa mina danal poethaypu. Kalanu nuy nungu geth buth pathiz a thanamulpa muliz. Thana mura apa thayan ayngu purthay lagoenu a nuy ngoedhe thanamun zagethaw mabayg; nuydh thana aydu poeybiz. ");
INSERT INTO mwp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","‘Wa, thanamulpa matha ngoedhagidh kedha, nuy mi thonar mangiz nanga, dhadha kubil lawnga amadhan goeygipa, thana ngaru danalgal. ");
INSERT INTO mwp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kedha yakanurayg, mi mabayg nanga nuy lagalayg, nuy ngaru koey poeypiyam mura thonara, puru mabaygoengu muya uthayle. Lagaw mabaygan wara thonara giyaw woengayginga nanga, wa senawbi thonara za mangiz. ");
INSERT INTO mwp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","A ngitha lak kedha ngaru mura thonara buth pathayzimayl, kuyk ngaw Mabaygaw Kaziw kuniya mangay aymidhe bangal ngidh midh thonara nanga wakay thamamayn gasamayginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kalanu Petheru mulaydhin, ‘Kuykulnga, in nginu adha min tiday, matha ngoeymulpa niyaykazipa, lawnga mura mabaygoepa?’ ");
INSERT INTO mwp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nuy Kuykulnga kuniya, ‘Ngay ngabepa kedha muliz kedha, ngithamulngu ngaya nanga kapu akasi zagethaw mabaygal. Mina zagethaw mabayg nga? Nuy kedha ngoedhal mabayg. Nungu kuyku mabayg nanga nubepa kupay poeyban mura lagaw zapa danal poethaypa a aydel dhadhiya dhadh maypa mura mabaygoepa. Nuydh ngaru ayman balbayginga senawbi zageth. ");
INSERT INTO mwp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kapu woenab nubepa zagethaw mabaygoepa kedha nungu kuyku mabaygan nanga iman nuyn, nuy matha zagethan mepa, kuyku mabaygaw yangukudu midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","‘Ngay ngithamulpa mina yadu umepa kedha, nuy kuyku mabaygan ngaru bangal gimaw kupay manine senawbi zagethaw mabaygoepa. Kalanu bangal nuy mura sethabi lagaw zapul danal pathepu. ");
INSERT INTO mwp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A wara kedha, wati zagethaw mabayg nanga, nuy nubiya muynu kedha gasaman, “Ngaw kuyku mabayg koey sobalnga, nubepa ngapa kuniya tidaypa lawnga sobaginga.” Kalanu nungu kawrag kedha, nuy ngulayg palngin wara zagethaw mabaygal, garkazil a matha kedha yoepkazil, nuy koey aygudalnga a koey woenilayg a kasa matha umanga ulaypa. ");
INSERT INTO mwp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Lawnga na gegeyadh, sena nungu wati zagethaw mabaygaw kuyku mabayg ngaru bangal kuniya. Wara goeyginu, nuy dhadha mangiz, nubepa zagethaw mabaygoepa gumi. Nuy zagethaw mabayg senawbi goeygingu koerawayg, a awangu koerawayg. Senawbi wati zagethaw mabaygaw kuth kasa ipidhadh gegeyadh, koeyma mathaman, kalanu kawragi mabaygiya wanan. ");
INSERT INTO mwp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Zagethaw mabayg nga ngulayg nungu kuyku mabaygaw ubilnga midh nanga aymoeypa, kasa kay kedha nungu geth buth pathayginga a aymayginga, nuyn ngaru koeyma palngin, ");
INSERT INTO mwp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A zagethaw mabayg nga nanga koerawayg nungu kuyku mabaygaw ubi midh nanga. Nubepa gumi nuydh kuyku mabaygaw ubilnga aymayginga, nuyn ngaru kasa moegina palngin. Wa, zagethaw mabaygaw kupay yaynanab. Ngunu nanga kupay koeyza nuydh ngaru nungu kuyku mabaygaw ubilnga koeyma oengan, a ngunu nanga kupay apal nuydh moegina oengan nungu kuyku mabaygaw ubilnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kalanu Yesu adha min tidadhin thanamulpa kedha, ‘Ngay ngapa mulupa ngaw zageth ngoedhe muy siyaypa nubi apaw goewaya. Matha ngoedhagidh nay yayamiz kedha thonar. ");
INSERT INTO mwp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngoena ngaru bangal paptayso maypa, na wara papatays koey mapunga, a ngaw ngoenakap mapu ngaru koeyza kurusipa bangal kuyku nidhane. ");
INSERT INTO mwp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngithamulpa sike kedha, ngay na ngapa mulupa ina apal ngaru bangal koewbuginga. Ngay ngithamulpa kedha, ngay ngapa kedha zapa lawnga. Ngay na ngapa nanga na ngaru dhadh poelamay, pawdh lawnga. ");
INSERT INTO mwp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","‘Koezi pawpa ngalpa imane dhadh poelamay urapun buwaynu. Payb mabaygal nanga uka modhabilnga wara doegamoenu a ukasar wara doegamoenu. Thana ngaru kidhakidhan wati igalgal. ");
INSERT INTO mwp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Thanamun dhadh poelamay kedha, thathi a nungu garkaz kazi palay kidhakidhan wati igalayg, a wara apu a nanu yoepkaz kazi lak kedha palay kidhakidhan wati igalayg, a matha kedha apu a nanu yoepkaz ira kidhakidhan wati igalayg aymiz.’ ");
INSERT INTO mwp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu kedha muliz mabaygoepa, ‘Ngitha nanga ziyal imiz kukingu ngapa ngitha balbayginga ngulayg asimoeyn kedha, “Ari kayke” a na kalanu pudhiz. ");
INSERT INTO mwp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A zey gub nanga gamu tariz, ngitha kedha mulemin, “A, komalnga kayke” a na kalanu aymiz. ");
INSERT INTO mwp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngitha kasa ngoelkay, ngitha iman a tidan boeradharaw thonaral a matha kedha ziyal a gubal, Awgadhaw thonaral ngitha matha tidayginga. ");
INSERT INTO mwp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngitha midh paru thonar tidayginga kedha, mina pawa midh? ");
INSERT INTO mwp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","‘Wara thonara mabaygan ngin thuran kotoepa, yapa sakar maypa. Kapu za kedha, ngidh ngaru kulay wakay thayiz, yoepa balbayg poelaypa nubiya. Kapu za ngidh ya balbayg palan adhal nginungu dhoerdhimay mabaygiya mangayle. Kalanu nginu kuth koeyza, ngin bangal dhoerdhimay lagoenu aranu. ");
INSERT INTO mwp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngay ngibepa kedha muliz, ngibepa adhapadhaypa lawnga ngidh bangal kurusipa mura modhabiya manine, bokadhza senabi gegeyadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Senabi thonara dhuray mabaygal Yesun ngulayg paladhin kedha, Pilatho nuydh mabaygal uma mathamoeydhin thana nanga oltanu parunu uruypa poeybaypa Awgadhoepa. Thana Galilayaw mabaygal. ");
INSERT INTO mwp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kuniya mulaydhin thanamulpa kedha, ‘Ngithamun wakay thoemamay sike kedha thana sethabi mabaygal ngaru adhapudhay wati pawalgal mura wara Galilayaw mabayg midh nanga, thana sikedh kedha zoenguz wati kuth gasamoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","‘Lawnga! Ngay ngithamulpa lawnga. Ngitha lak kedha ngaru garkidh thoeyaypa ngithamun wati pawangu. Aymayginga nanga ngitha ngaru bangal kedha ngoedhal kuth gasamoene. ");
INSERT INTO mwp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wara kedha ngitha ngulaygal wara lag na koey kuykuthalnga apaz kadaypa na mulupa pudhaydhin a eythin mabaygal uma mathamoeydhin say Silomoenu. Ngithamun wakay thoemamay sikedh kedha thana adhapudhay wati pawalgal mura wara Yoerusalemaw mabaygal midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","‘Lawnga! Ngay ngithamulpa lawnga, ngitha lak kedha ngaru garkidh thoeyaypa ngithamun wati pawangu. Aymayginga nanga ngitha ngaru bangal kedha ngoedhal kuth gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kalanu Yesu thanamulpa adha min tiday yangukudu kedha umadhin, ‘Wara apaw lagaw mabayg nuydh dhaniw nagu uthudhin nungu goereypaw apaw lagoenu muynu. Nuy sepa aypuypa aypa lumaypa kasa kay yan. ");
INSERT INTO mwp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kalanu nuy kedha mulaydhin nungu zagethaw mabaygoepa, “Sepa nagi nuy kasa wati puy, thoeri wathalnga ngay ngapa aypa lumaypa kasa kay yan! Ngidh nuyn mulupa pathar, kalanu nubi apaw lag lak moegina buthalnga mina nagupa.” ");
INSERT INTO mwp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Kasa kay kedha zagethaw mabayg nuyn yoewdhaydhin kedha, “Kuyku mabayg, ngidh nuyn gar wanar matha urapun wathoepa lak. Ngath nuyn moegina adhiya a narpa kuykuya, lak puwa woeydhaypa moegina saya poelaypa. ");
INSERT INTO mwp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kalanu ngoeba wara wath ugan imaypa. Nuy nanga koewsa puydhiz balbayginga, nuy nanga ayginga adhapa pathan.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wara sabadhoenu nanga Yesu nuydh nungu ngurpay ayman moegina yoewthanu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Urapun yoepkaz sina muynu na muwayzinga 18 wathalnga, minguz kedha wati mari nan gegeyadh marngu, na paypa yoewimoeyzinga. Koey zageth na balbayginga kaday thariz. ");
INSERT INTO mwp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu nan iman nanga nuydh nan gamupa thuran, a nabepa muliz, ‘Kake, ngi kedha thonara pa wayan a muwasin nginu kikiringu.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kalanu nuydh geth nabiya gimal kabuthadhin. Senabi thonara na kaday thariz mina balbayginga, a koeyma thawmanin Awgadh. ");
INSERT INTO mwp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Thanamun yoewthaw kuyku mabayg sey senabi thonara, nuydh gegeyadh gasamadhin kedha, Yesu nanga nan balbay tidadhin sabadhaw goeyginu. Nuy koeyma ya mulaydhin mabaygoepa kedha, ‘Ngitha ngapa mipa Yesulpa sabadhoenu. Ngalpa ngulaygal siks goeygil zagethaw goeygil. Sethabi goeygil matha ngoedhagidh ngithamulpa ngapa nubepa zagethoepa, sabadh lawnga.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesu nuydh kuniya ya madhin nubepa kedha, ‘Ngitha yoewthaw zagethaw mabaygal, ngitha ngoelkay. Sabadhaw goeyginu nanga, mura ngitha ngulayg zagethaw uruy, donki lawnga kaw gud wayan adhapa a yoelpan ngukiw lagoepa, ngukipa poeybaypa. ");
INSERT INTO mwp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uruy danal poethay, sabadhoenu ngithamulpa balbayginga a? Ina nabi yoepkaz midh, na Abraman buway mabayg, a Sathana nuydh nan 18 wathoepa kunamoedhin. Ngath ngaru nan gud wayan sabadhoenu, senabi wati zangu.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wa, thana nanga nungu wati igalgal karngemidhin nanga, thanamun azir koeyza a gegeyadh gasamoedhin, kasa kay kedha mura mabaygaw koey ika dhiw thana nanga imadhin sethabi adhapudhay zagethal. ");
INSERT INTO mwp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesun kasa ya kedha, ‘Ngalpan pudhamay midh Awgadhaw Basalayoepa, a nanu ngoedha midh, a na midh paru? ");
INSERT INTO mwp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na ngoedhe mastadaw kapu midh nanga. Nagu uthuy mabayg nan uthun nungu apaw lagoenu. Kalanu na koesimiz a koeyza aymiz ngoedhe puy nge. Uruyl ngapa thamoenu nipa senabi puynu.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu lak mulaydhin, ‘Ngalpan pudhamay Awgadhaw Basalaya na mi ngoedhalnga. ");
INSERT INTO mwp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na ngoedhe kedha, yoepkazin moegina kadaypa mabal ay kusuman a urapun dhram kun. Kalanu nadh mura kidh thayadhin sepalbi ay, kurusipa na ay mura woeyamiz ayab, kedha zoenguz kedha nabiya kadaypa mabal ay muynu. Wa, kayib nanga mabaygal kasa moegina iman Awgadhaw zageth, na ngaru bangal koesimidhe.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu nungu maboenu woelmay nuydh ngurpay ngaru aymar mudhaw lagiya, kasa kay kedha nungu mab parul thoeyayzinga mepa Yoerusalemapa. ");
INSERT INTO mwp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nungu maboenu wara mabayg ngapa nubepa, kedha yapu poeybaydhin, ‘Kuyku mabayg, kasa moenari mabaygal sike kaludhamoeyne wati kuthoengu?’ Yesu kuniya mulaydhin mabaygoepa, ");
INSERT INTO mwp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","‘Koeyma nuthemipu bangal moegi gudal pasiya muya uthaypa. Ngay ngibepa kedha muliz, koey garsar bangal mabaygal nuthemipu muy yoewthaypa, kasa kay yan. ");
INSERT INTO mwp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Minguz kedha, senabi thonara Lagaw Thathi bangal kaday tharedhe pasa thamudhane. Ngi nanga adhal siparuy ngidh bangal pasa yan mathampu. Ngidh bangal kedha muledhe, “Kuykulnga, ngidh gar pasa pudhar ngoeymulpa.” A nuy bangal ngithamulpa kedha kuniya mulemine, “Ngay ngithamulngu koerawayg, ngitha ngalagaw mabaygal?” ");
INSERT INTO mwp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ngithamun kuniya yangukudu kedha, “Ngoey wara thonara ngibiya kalmel ay purthaypa a nguki wanempa. A wara ngidh ngurpay aymoeydhin ngoeymun mudhaw lagoenu.” ");
INSERT INTO mwp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kasa nuy lagaw thathi lak ngur woeydhiz, “Ngay ngithamulngu koerawayg, ngitha adhapa ngawngu mura wati pawa mabaygal.” ");
INSERT INTO mwp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Wa! Senabi thonara may kasa koeyza, a dhangal tikitik nudhemipu. Ngitha nanga imedhe Awgadhaw Basalayanu muynu Abrama, Isaka, a Yakubu a mura setha peropethal; kasa kay kedha ngitha bangal adhapa yawamoeypu. ");
INSERT INTO mwp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Senabi thonara bangal koey garsar mabaygal ngapa po gubaw gizungu woewr, kuki, naygay, a zayangu. Thana mura garwoeydhamoeyne a apal nithamoene, koey ay bangal purthane Awgadhaw basalayoenu. ");
INSERT INTO mwp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Setha nanga ngaya wagel kayib, senabi thonara thana bangal kulay, a thana kayib ngaya kulay thana bangal wagel.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Senabi thonara dhuray Parasayalgal ngapa Yesulpa a mulemin nubepa kedha, ‘Ngi kay koezi uzar wara doegampa, kuyku mabayg Erodh nuydh ngin mathamaypa maypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesun kuniya yangukudu thanamulpa kedha, ‘Ngitha kuniya ladhu senabi wati kuyku mabaygoepa nga nanga ukasar neylayg, a kedha ngulayg palane nuyn; ngay zagethaw mab ulaypa, mabaygan balbay tidepa, a wati maril adhapa mamayipa kayib a bathaynga; wara goeyginu ngath bangal zageth muwasine.’ ");
INSERT INTO mwp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kalanu nuydh thana moegina mulupa thoeyamoeydhin kedha, ‘Wa, ngay kay ngaru uzaripa ngaw maboenu kayib a bathaynga, a wara koey na goeyga. Matha ngoedhagidh lawnga Awgadhaw peropeth kay adhal mathampa. Nungu kuth ngaru Yoerusalemoenu muynu. ");
INSERT INTO mwp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","A! Yoerusalema, Yoerusalema, ngitha mura thonara Awgadhaw peropethal uma mathamoeypu, a kulan dhanamoeypu Awgadhaw woeyayzi mabaygal ngithamulpa. Koeyma thonaralnga ngaw mina ubi ngath ngaga toeydhamoeypa ngaw geth mura ngithamuniya, Yoerusalemaw mabaygiya, ngoedhe apu pawl ngaga toeydhamoeypu nanu kazil boethanu muynu, kasa kay kedha ngitha ngithamun ubiginga ngawngu. ");
INSERT INTO mwp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","‘Nag! Ngithamun goegath kasa ngithamulpa wanan; a ngay ngithamulpa puridharalnga muliz kedha, Awgadhan kay ngitha wanedhe a ngithamulpa lak ngaw parupa imaypa lawnga kurusipa bangal kuthaw goeyga ngitha bangal kedha umamoeypu, “Koey woenabalnga, nga na balbayginga ngapa Awgadhaw kupaynu muynu.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wara goeyginu sabadhaw goeyginu, Yesu miyaydhin wara Parasayalgaw kuyku mabaygoepa, aygudoepa. Mabaygal danal pathar nuyn, ");
INSERT INTO mwp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","kuyk wara kikirilayg sey, nungu gamu bibiriginga. ");
INSERT INTO mwp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Imaypa, Yesu kedha mulaydhin thanamulpa Parasayalgoepa a yoewthaw sabiw ngurpay mabaygoepa, ‘Ngalpan sabinu midh, matha ngoedhagidh kedha mabaygan dhoey nidhan sabathoenu lawnga midh?’ ");
INSERT INTO mwp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kasa kay kedha thana kuniya ya mulayginga. Kalanu nuydh kikiril mabayg madhin. Nuydh dhoeynidhadhin a wayadhin nuyn. ");
INSERT INTO mwp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kalanu nuy koey mabaygoepa buwayl thoeyadhin a kedha mulaydhin, ‘Ngithamun nanga garkaz kazi mulupa arkathiya pudhiz, lawnga ngithamun kow arkathiya pudhiz, ngitha sobaginga kadaypa manin? Matha kedha goeyga sabadh ngitha ngulayg kadaypa manin a?’ ");
INSERT INTO mwp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Thana kasa yagi asimoeydhin. ");
INSERT INTO mwp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nuydh iman kedha, mabaygan kasa thanamulngu mina niyaylagal mamayir; nuydh thanamulpa adha min tidar kedha, ");
INSERT INTO mwp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‘Mabaygan nanga ngin thuran niyaypa yoelpay aygudoepa nanga, ngidh koey mabaygaw niyaylag mayginga. Kedha nanga wara mabayg ngapa ngibiya wagel koey mabayg ngibiya. ");
INSERT INTO mwp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nuy lagaw thathi ngadh nanga ngin thuran a matha kedha koey mabayg, nuy ngaru ngibepa kedha muliz, “Sena mina niyay lag koey mabaygoepa mar.” Kalanu ngi koey aziralnga mulupa pagan. ");
INSERT INTO mwp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mabaygan nanga ngin thuran niyaypa yoelpay aypa nanga, matha ngoedhagidh kedha ngi kasa matha thanuriz wati niyaylagoenu, kalanu nuy lagaw thathi kay ngibepa muliz, “Igalayg, aya mina lagoepa thami.” Senabi mina pawa mabaygaw parunu ayman, a ngin thawmanin. ");
INSERT INTO mwp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","‘Nga nanga nungungu kadaypa thamiz, nuy ngaru bangal koey aziralnga mulupa thayan, a mabayg nga nanga nungu geth apa pudhiz, bangal nuy gimal thawmanine.’ ");
INSERT INTO mwp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nuy senawbi lagaw thathi ngadh na thuraydhin mabaygal aygudoepa, nuy wara Parasayalgaw kuyku mabayg. Kalanu Yesu nubepa buwayl thayadhin kedha, ‘Ngidh nanga koey ay ayman, maygi ngidh thuran matha nginu pasiw mabaygal, matha kedha nginu igalgal, nginu tukuypal, a setha ngaya nanga kedha bokadhzapul mabaygal ngibiya amadhan. Ngidh na ayman, thana lak kedha ngin thuran kuniya modhabiya. ");
INSERT INTO mwp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kedha lawnga, ngidh nanga koey ay ayman, thuran aygig a zagig, muwayzinga a maboegig, a maygum. ");
INSERT INTO mwp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","‘Kedha na ayman ngidh woenab ngibepa gasaman. Thana aygi zagi mabaygal ngin kuniya modhabiya mayginga, matha ngi thanamulpa mina pawa ayman. Mi thonara nanga Awgadhaw mabaygal lak kaday nithamoene umangu, ngidh bangal mina modhab gasamoene.’ ");
INSERT INTO mwp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wara ayngu mabayg Yesuniya pasinu, nuydh nanga karngemidhin Yesu midh na umay, nuy kuniya mulaydhin kedha, ‘Koey woenabalnga bangal mabayg nga nanga aydu purathidhe, Awgadhaw koey ay aymoeynu, nungu Basalayoenu muynu.’ ");
INSERT INTO mwp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesun kuniya ya nuydh adha min tidadhin kedha, ‘Wara mabayg nuydh buwayl thoeyadhin koey aypa buth pathaypa. Nuydh mura mabaygal thurimoeydhin senabi buthapathayzimoeypa. ");
INSERT INTO mwp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Thonar nanga gasaman nuydh nungu zagethaw mabayg wayadhin thurayzi mabaygoepa ngapa garwoeydhamoeypa kedha, “Ayawal, mura zapul butha pathayzimayl.” ");
INSERT INTO mwp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Kasa kay kedha thana mura yaynanob butha mathamoeydhin. Wara mabayg kedha, “Ngath ngayapa kayn boeradharoepa barpudhan, ngay ngaru sepa imaypa. Ngidh gar ngoena pa wayar.” ");
INSERT INTO mwp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wara mabayg kedha, “Ngath kayn barpudamoeyn 10 kawal, zagethaw uruyl, ngath ngaru thanamun zagethoepa nuthaypa. Ngidh gar ngoena pa wayar?” ");
INSERT INTO mwp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wara mabayg kedha, “Ngath matha kayne geth dhoerdhimiz, ngayapa ngapa maboepa lawnga.” ");
INSERT INTO mwp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‘Nuy zagethaw mabayg ngapa kuniya tidiz nungu kuyku mabaygoepa, a ngulayg palan nuyn. Kalanu kuyku mabaygaw ngurum koeyza; nuy zagethaw mabaygoepa kedha muliz, “Kasa mabaygal ngapa thuri, ngi matha paypa mura goegathaw yabugudiya uzar. Mura koey yabugudiya a moegina yabugudiya uzar. Mabaygal ngaya aygigal, a roepaylgal, a maygumal, a matha kedha maboegigal; mura thana ngapa thuri ngaw koey ay aygudoepa.” ");
INSERT INTO mwp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Wa, nuydh ayman kasa kay buthal matha memayipa. Nuy kuyku mabaygoepa muliz kedha, “Kuyku mabayg, ngath ayman kasa kay buthal matha memayipa.” ");
INSERT INTO mwp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nuy kuyku mabayg kuniya mulaydhin kedha, “Ngi lak uzar mura yabugudiya, matha kedha mura bupiya moegina yabugudiya uzar, a puridharalnga muli thanamulpa ngapa maypa, kurusipa ngaw lag mura gudiya yoewdhiz. ");
INSERT INTO mwp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wa, ngay ngithamulpa kedha muliz, mura setha kulay thurayzi mabaygal, thanamulpa mithal poethaypa lawnga, ngaw koey aygudoepa.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mabaygaw goersar mina koeyza Yesuniya kalmel puzimipa. Nuy thanamulpa adha min tidan kedha, ");
INSERT INTO mwp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Mabayg nga nanga nungu ubi ngaybiya puzipa, nungu mam ngaru ngayapa, apu thathipa lawnga, nungu ipipa kazipa lawnga, a tukuypoepa babathoepa lawnga, a matha kedha nungu geth igililmaypa lawnga. Nungu mam ngayapa ngaru adhapudhay, lawnga nanga Nuy matha ngoedhagidh lawnga ngayapa niyay kazi tariz. ");
INSERT INTO mwp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","‘Ngi nanga mapu zagethoengu ubigasin, nginu geth sathawropa oengaypa ngay midh nanga, lawnga ngi koey zageth ngaw niyay kazi aymiz. ");
INSERT INTO mwp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Matha ngoedhagidh kedha ngidh kulay zapul zoeyzi noeydhemin, wagel kay ngidh zageth ayman. Matha kedha nginu ubi nanga ngidh kuykuthal lag moeydhan kadaypa, mamu bokadhza seysithaman kulay, a matha ngoedhagidh senabi lagoepa ngidh nanga mura muwasipa moeydhan. ");
INSERT INTO mwp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","‘Wara kedha, ngidh kuyk apal kabuthan a muwasiginga kuyk nginu bokadhza mura sagul palan, mura mabaygal nay iman thana ngin giwn manin kedha, ");
INSERT INTO mwp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“In nubi mabaygan kuykuthal lag moeydhaypa a muwasipa lawnga.” ");
INSERT INTO mwp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Wara lak kedha mopakuy nanga koewbupa mepa, nuy ngaru kulay zoeyzoeynoeydhiz a sakar pudhan kedha, nungu koewbu mabaygal matha ngoedhagidh a, wara kuyku koewbu mabaygiya? Nungu mabaygal sike matha ten tawsan a wara koewbu mopakuyu twenti tawsan. ");
INSERT INTO mwp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nuydh nanga iman kedha nuy matha ngoedhagidh lawnga, nungu mabaygal moenarimayl, nuydh ngaru kulay mabaygal wayamoeyn, wara koewbu mopakuykupa yoewdhemin pawdhoepa. ");
INSERT INTO mwp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","‘A ngitha lak kedha, mabayg nga nanga mura nungu geth zapul kuniya wayayginga, nuy matha ngoedhagidh lawnga ngaw niyaykazipa.’ ");
INSERT INTO mwp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu matha maw sipa thanamulpa kedha, ‘Thimedhoegi mabayg nuy ngoedhe wati sol midh nanga. Ngithamun igililmayl ngaru nubi apa goewanu dhadhal a ngithamun mina zageth matha kedha kapu sol midh, ay mith palan; ngitha nanga Awgadhaw mina ngurpay oengayginga nanga ngithamun wati igililmayl ngoedhe kedha wati sol midh nanga, nadh nanu mina mith guythuyan. Nan lak kuniya sol aymayginga, na kasa wati za aymiz. ");
INSERT INTO mwp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","‘Na matha ngoedhagidh lawnga nginu apaw lagaw boeradharoepa ukamaypa, a matha kedha na matha ngoedhagidh lawnga puwa woeydhan. Kedha wati adhabadh ngaru kasa adha thayan. Wa, ngitha ngaru koey poeypiyam bangal. Ngitha nanga kawralgal, kurusipoegemiw.’ ");
INSERT INTO mwp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wara thonara koey garsar bokadhzoengu garwoeydhamay mabaygal a adhapa imayzi mabaygal thana ngapa Yesulpa kurusipoegaypa. ");
INSERT INTO mwp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Thana Parasayalgal a yoewthaw sabiw ngurpay mabaygal nanga imadhin thana moegithap ya umadhin kedha, ‘In nubi mabayg nuydh midh paru ayawal maypa kedha ngoedhal adhapa imayzi mabaygal, a thanamuniya lak woergiya kalmel thanuriz a aydu purathiz?’ ");
INSERT INTO mwp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesulpa kakal kedha thana midh nanga umamoeyr, nuydh thanamulpa buwayl thayadhin a kedha adha min tiday yangukudu mulaydhin, ");
INSERT INTO mwp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‘Urapun mabayg ngithamulngu andred mamuylayg nanga a urapun thanamulngu kasa guythuyan sew bupanu, nuydh ngaru miza aymoene? Nuydh ngaru wanamoeyn sethabi naynti nayn balbaygi mamuyl, thana kasa bupal purthamoeyr. Nuy uzariz a luman guythuyayzi mamuy. ");
INSERT INTO mwp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kurusipa nuydh iman a nungu ika koeyza. Nuydh nungu thabaynu wanan, ");
INSERT INTO mwp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a kuniya lagoepa manin senabi guythuyayzi mamuy. Nuydh mura thurimoeyn nungu igalgal a pasiw mabaygal a thanamulpa kedha muliz, “Ngalpa kalmel ika dhiw gasampa kedha, ngath ngaw guythuyayzi mamuy luman, a ngath iman. Ngalpa kalmel ay ayimpa.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kalanu Yesu lak mulaydhin thanamulpa, ‘Kedha kay urapun wati pawa mabayg nanga mina garki thayan nungu kulay igililmayngu, ina za koey ikalnga dhiwalnga thanamulpa sey daparoenu gimal. Wara nayntinayn mabaygal thana sike balbayginga goeygi matha toedipu; kasa kay kedha Awgadh nuydh kedha koey ika gasamoeyginga nuydh midh na gasamadhin senabi garki thoeyayzi mabaygoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kalanu Yesu nuydh lak thonara tidamoeyr kedha, ‘Wara yoepkaz nabiya ten koethil silba bokadhzapul. Nadh urapun guythuyan, sew kaliya nadh luman. Nadh thunge gamu woeydhan a mathay tadin lagiya a nadh ngaru luman kurusipa nadh iman. ");
INSERT INTO mwp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kalanu nadh amadhan mabaygal thurimoeydhin a igalgal. Na thanamulpa kedha muliz, “Ika gasamaw ngaybiya kalmel, ngath ngoezu guythuyayzi bokadhza luman a ngath iman.” Wa, na matha kedha ngoedhalnga muliz, “Ngay ngithamulpa kedha, ngalpa kalmel ay ayimpa a sagul.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wa, Yesun yangukudu thanamulpa kedha, ‘Ina ngoedhe kedha ngoedhalnga, Awgadhaw angelal midh, ika koeyza urapun wati pawa mabayg garthi thayan nungu wati pawangu, Awgadhoepa.’ ");
INSERT INTO mwp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kalanu Yesu lak mulaydhin thanamulpa kedha, ‘Wara mabayg nanga nubiya ukasar kuyk kazi. ");
INSERT INTO mwp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wara goeyginu nuy kuthay kazi kedha mulaydhin nungu thathipa, “Thathi, kedha thonar ngidh ngayapa mar, setha mi rugal nanga ngaw ya tharayzimayl mura ngaw kupay.” Wa, kalanu nuy thathi dhadhiya dhadh mamayidhin thanamun boeradhar a rugal nungu ukasar kuyk kazipa. ");
INSERT INTO mwp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‘Kasa moenari goeygil kalanu nuy kuthay kazin nungu kupay boeradhar a rugal yoewdhaydhin bokadhzapupa. Kalanu nuydh nungu lag geth wanaydhin, nubiya kalmel mura sethabi bokadhzapul. Nuy koey sigal lagoepa miyaydhin a senawbi lagoenu nanga nuydh kasa sagul paladhin mura nungu bokadhzapul mura nungu kasa ubi midh nanga. ");
INSERT INTO mwp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","‘Kurusipa nuydh mura nungu bokadhzapul sagul palimoeydhin nanga koey aygi wath mangaydhin a nuy kazi koey aygi zagi mabayg aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nuy uzaraydhin senabi goegathaw mabaygoepa, zagethaya lumaydhin, a nuydh nuyn aymoedhin nungu burumpa danal poethaypa. ");
INSERT INTO mwp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nungu gamu ayginga, amadhan nungu burumaw ayngu purthay, bupaw puy koewsal, a mabaygan nuyn aydu poeybayginga. ");
INSERT INTO mwp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‘Kurusipa nuydh kuniya wakay thoemamay gasaman kedha, “Ngaw Thathiw Ayza mina koey garsar, a mura nungu zagethaw mabaygal, ngay mipa ngapa koepa, ina ngath koey maytha aygi gasampa?” ");
INSERT INTO mwp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ina gegeyadh, matha ngoedhagidh kedha ngay lak kaday tharepa a uzaripa Ngaw Thathipa, a bangal muledhe nubepa, “Bab ina ngaw gegeyadh ngath aymoedhin Awgadh a matha kedha ngin. ");
INSERT INTO mwp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngay bangal matha ngoedhagidh lawnga mabaygal ngoena bangal ngibepa kazi ayman. Ngay bangal koey apal nginu ya lumayzi zagethaw mabayg midh nanga.” ");
INSERT INTO mwp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","‘Wa, nuy kaday tharaydhin a kuniya uzaraydhin nungu thathipa, ‘Nuy matha koey sigal lagoengu woelmay ngapa, nungu thathi nuyn iman. Nungu thathiw ika dhiw mina koeyza, a koerkak badh; nungu tari, kazipa a geth thayan, a gud thapaman nuyn. ");
INSERT INTO mwp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nuy kazi kedha mulaydhin, “Thathi, ngath koeyma gegeyadh madhin Awgadh a matha kedha ngin. Matha ngoedhagidh lawnga mabaygan bangal ngoena ngibepa kazi ayman.” ");
INSERT INTO mwp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Lawnga thathin nuydh nuyn maman manin, a gamupa gasaman, mura zagethaw mabaygal thuriz a muliz thanamulpa, “Ayawal tharay, setha mina rugal ngapa mamayi, ubamaw in, a koethil za kay oengaw dhimuriya, a azaz san kay ngaranu angimoeriw. ");
INSERT INTO mwp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ladhu, seyzi ngalpan buzaral kazi kaw ngapa mariw a mathamaw kay, ngalpan kay koey aygud a sagul kayke. ");
INSERT INTO mwp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","In ngaw kazi ngoedhe maygum nge, nuydh lak nungu purkaw buya gasaman, nuyn guythuyaydhin, a ngalpa lak nuyn iman.” Wa, thana koey ay aymoedhin. ");
INSERT INTO mwp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Senabi thonara nuy kuykuy kazi adhal zagethaw boeradharoenu. Nuy nanga kuniya tidaydhin, amadhan na lagoepa aymoeydhin, nuydh na karngemin a soegul. ");
INSERT INTO mwp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Imaypa, nuydh wara zagethaw mabayg thuran, a yapu poeybiz, “Sena miyay ayimpa.” ");
INSERT INTO mwp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Nuy zagethaw mabayg nubepa kedha muliz, “Nginu tukuyap ngapa kuniya tidema lagoepa, a nginu thathin mathamoenu koey buzaral kazi kaw. Thathiw ika koeyza dhiw kedha, nuy balbayginga kuniya mangiz.” ");
INSERT INTO mwp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nungu kuykuygaw thabukir koeyza, nuy muy uthayginga loegiya. Kalanu nungu thathi ngapa adhapadhan, a nubepa yoewdhaydhin ngapa muya yoewthaypa. ");
INSERT INTO mwp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","‘Nuy kuykuyg ubigig. Nuy kedha mulaydhin thathipa, “Bab, ngi ngulayg kedha, ngay ngoedhe zagethaw mabayg koeyma wathalnga ngibepa zagethan merngu. Ngath wara nginu ya pathidhayginga. Ngidh ngayapa za miyay manin, mina lawnga moegina uruy, nani, ngayapa mayginga, ngayapa ngaw igalgoepa aypa aymoeypa. ");
INSERT INTO mwp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kasa kay kedha in nubi kazi nginu, nuydh mura sagul paladhin nginu zapul, wati yoepkazipa, a nuy na lagoenu kuniya mangiz ngidh buzaral kazi kaw mathaman nubepa.” ");
INSERT INTO mwp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Nuy thathi nungu kuykuy kazipa kuniya mulaydhin, “Ngaw kazi, ngi mura thonara in ngaybiya, ngoeba ngoedhe urapun nge, mura ngaw zapul nginu zapul. ");
INSERT INTO mwp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nginu tukuypaw doegam nanga, koey soegalulnga koey dhiwalnga, kedha zoenguz kedha, nuy kuthayg ngoedhe maygum nge nuy lak purkaw zuru kuniya gasaman; a nuy thadhumay asidhin, a ngalpa lak nuyn imangu.” ’ ");
INSERT INTO mwp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kalanu Yesu nuydh za thonar tidan nungu niyay kazipa kedha, ‘Wara koey aydeg zapulayg, mabaygal nuyn yadu palgadhin kedha, nungu bokadhzoengu danal poethay mabayg nuy wati mabayg, nuydh kasa nungu kuyku mabaygaw bokadhzapul sagul palepu. ");
INSERT INTO mwp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kuyku mabayg nuyn thuran a nubepa kedha mulaydhin, “E! Ngi midh merngu nginu zagethan? Ngath wara yaday kerngemipu nginu may. Ngidh ngaru ngoena ngulayg palaypa kedha, nginu mura bokadhzoengu zageth midh nanga, mura ngaw zapul. Ngi bangal lawnga ngaw bokadhzoengu mabayg, ngibepa ngath muwasin poeybane.” ");
INSERT INTO mwp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‘Nuy bokadhzoengu mabayg muliz kedha nubiya muynu, “Ngaw kuyku mabaygan bangal ngoena adhapa wayane kupayngu. Ngath bangal mi zageth gasamoene aypa zapa; ngay matha ngoedhagidh lawnga dharbaw zagethoepa, a ngayapa koey aziralnga ngay bokadhzoepa yoewdhepu mabaygoepa. ");
INSERT INTO mwp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wa, ngath igalayg bangal koesimoeyne koeyza, lak bangal thana ngoena muya thoeyaypu thanamun niyay lagiya, ngay bangal zagethoegig nanga.” ");
INSERT INTO mwp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","‘Kalanu nuydh thuremoeydhin mabaygal ngaya nanga nungu kuyku mabaygoengu umamayl aymoeydhin. Nuy thanamulpa yaynanob mulaydhin kedha, nuydh thanamun umamaypa mulupa thoeyaypa. Nuy kulay mabaygoepa kedha, “Nginu umamayl midh?” ");
INSERT INTO mwp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nuy kuniya, “100 moegina dramal idilmayl.” Nuy bokadhzoengu mabayg kedha mulaydhin, “Ngoeba mulupa thayan matha 50.” ");
INSERT INTO mwp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nuy yapupoeybaydhin wara mabaygoepa kedha, “Nginu umamayl midh?” Nuy kuniya, “1,000 baykal kunalmayl.” Nuy bokadhzoengu mabayg kedha mulaydhin, “Ina nginu umanga poelayzinga, ngoeba mulupa thayan matha 800.” ");
INSERT INTO mwp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nuy aydeg zapulayg moegina thawmadhin nungu wati zagethaw mabayg, kuyk nuydh koeyma wardhan nungu gegeyadh, a igalayg koesimadhin nubepa. Nubi apaw goewaw mabaygal setha ngaya nanga yoewthaw kal thoeyayzimayl, thana mina koey ngulaygal thanamun matha ngoedhagidh ngalagaz. Matha Awgadhaw mabaygal koerawaygal.’ ");
INSERT INTO mwp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‘Matha ngoedhagidh kedha ngidh nubi apaw goewaw mina zapul balbayginga maypa, a ngibepa igalayg koesimoeypa kay nginu ingaru niyaylagoenu. ");
INSERT INTO mwp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ngadh nanga moegina zageth balbayginga angan nanga, wa kakal kedha senabi mabayg balbayginga angane koey zageth; a ngadh nanga za puru ayman nanga moegina zagethoenu, na gegeyadh, nuydh bangal koey zageth lak kedha gegeyadh oengane. ");
INSERT INTO mwp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","‘Matha kedha nginu pawa na gegeyadh nanga, nginu igililmay zapa ina apal danal poethaypa, ngidh bangal daparaw zapul midh danal pathepu. Zoeyzi noeydhay mabaygan koey zageth ngibepa senabi zageth poeyban. ");
INSERT INTO mwp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wara mabaygaw za nanga ngidh gegeyadh danal poethaypu nanga, mabaygal mura ubigigal nginungu zangu poeybayle nginu geth za, ngi waza wati danal poethay mabayg. ");
INSERT INTO mwp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Mabaygan koey zageth ukasar kuykupa zagethan meparu. Wara kuyk Awgadh a wara kuyk bokadhza. Wara nuydh maman manin urapun, a wara kuykupa nuy mamagig. Nuydh matha urapun kuyku mabaygaw ubilnga ayman, a wara kuyku mabayg nuydh adhapa iman. Nginu ngoenakap nginu bokadhzapunu mepa, ngidh Awgadhaw ubilmayl aymoeyginga.’ ");
INSERT INTO mwp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Thana Parasayalgal matha memayipu si. Nungu senabi ngurpay nanga nuydh ayimpu, thana nuyn mulupa thoeyaypu, minguz kedha, thana koey bokadhzoengu ubilgal. ");
INSERT INTO mwp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nuy Yesu thanamulpa kedha mulaydhin, ‘Ngitha ngithamun balbayginga memayipa wara mabaygaw noegaypa, matha Awgadh ngithamun ngoenakapoengu ngulayg. Ngitha nanga kasa mamuy goengaw oengimipa nanga, na mabaygaw noegaypa balbayginga sike, na abere wati za Awgadhaw imaypa.’ ");
INSERT INTO mwp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu lak mulaydhin thanamulpa kedha, ‘Ngoenanu manin Awgadhaw kulba yabugud mabaygoepa; matha kedha sabil Minar Poelayzimayl a kulba peropethaw yaday kurusipa Yoewane Papthayson thonara. Sizi pawpa kapu yangu wakay yadu poelgaypu m