﻿USE sofia;
DROP TABLE IF EXISTS sofia.mwf2018_vpl;
CREATE TABLE mwf2018_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mwf2018_vpl WRITE;
INSERT INTO mwf2018_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bere da marra-re kathu Yile neki mampatha da kangkarl i da putek ngala kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Bere da ngarra ngala kanhi-ka nanhthi, ku i kardu-ka mere da ngatha mewathadha da marra-re-yu, i mere da ngatha mengka murruwurldha thathpirr da ngala kanhi-yu. Mu kura da matha wurrinilakagaktha i thipmam binhi da matha wurrinidha da kanhi-yu. Mu Ngepan Yile neki nukunu wurrinidha kangkarl ngarra kura i dirrapedha wurrini da ngala kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bere Yile neki-ka mam, “Da tarangka warda palarrangnu pirra.” I bere da tarangka danilarrangtha warda pirri. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","I nukunu-ka bamkardu patha, i le warda dinidha da tarangka nhini-nu-yu. I bere da nhini-re-ka mamyerryerr warda da tarangka i da thipmam binhi. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","I da tarangka nhini murrinh panparl-ka tarangka da matha. I da thipmam binhi panparl-ka thipinhi da matha nhini-yu. I bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini, i da-ka marra-re-ka nhini-wa da-yu da kumparra-re mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","I bere Yile neki-ka mam, “Kura-ka mayerryerrnu warda kura kangkarl i kura pepe.” I bere Yile neki-ka mamyerryerr warda kura-yu. Kura numi-ka kanhi ngarra da putek i kura numi-ka kangkarl wangu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","I da kangkarl-ka da marnirra panparl. I bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini. I da-ka perrkenku warda mam mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","I bere Yile neki-ka mam, “Kura ngarra wurranlakagak da ngatha da putek ngala pana-ka pungiyerrnu kura-yu i da putek warda pewirnturtnu.” I da-ka nhini da thathpirr mam. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","I da putek-ka murrinh warda panparl da putek da matha. I kura ngarra yunganyerr-ka panparl kura lalingkin. I Yile neki-ka bamkardu patha, i le warda dinidha da nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","I bere Yile neki-ka mam, “Da ngarra putek thangunu kathu-ka nanhthi purrkpurrk terert warda ngatha puddirurturtnu purru, mi kamarl wanku ngamere-yu, i ngamere-ka mi dhepdhep wanku mi kamarl wanku.” ");
INSERT INTO mwf2018_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","I bere nanhthi purrkpurrk terert warda ngatha puddarnturturt ngarra putek thangunu kathu nanhthi wunku mi kamarl, i ngamere mi wunku dhepdhep i mi kamarl wanku. Bere Yile neki-ka bamkardu patha, i le warda dinidha nanhthi purrkpurrk nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini. I da-ka perrkenkuneme warda mam mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","I bere Yile neki-ka mam, “Nanhthi kanhi kangkarl pangkarlbirlnu pirra da ngarra thipinhi, i nanhthi palarrangnu pirra da ngarra tarangka. I nanhthi nhini-ka da pangkardanu da thipinhi-ya, da tarangka-ya, da mirrangan-ya, da therri-ya i da thangku-ya bere matha wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","I nanhthi nhini-ka da kangkarl kathu pangkarlbirlnu i palarrangnu pira ngarra da putek ngala pana warda ngatha bere matha wangu.” I bere da-ka nhini da thathpirr mam, i nanhthi warda daningkarlbirldha i danilarrangtha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bere Yile neki-ka mampatha ngunga i merrk nanhthi perrkenku ngala ngala nhini. Nanhthi ngunga-wa nanhthi ngala thathpirr-yu i nhini Yile neki-ka pule ngala banpak nanhthi nhini-yu da palarrangnu pirra da ngarra tarangka. I nanhthi merrk-ka banpak pule ngala da pangkawipnu pirra da ngarra thipinhi. I nukunu mampatha-ka nanhthi pilinh wanku nanhthi terert. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Bere Yile neki-ka banpak da kangkarl nanhthi ngunga, merrk i pilinh terert da pangkarlbirlnu-ya i palarrangnu pira da ngarra putek ngala kanhi-yu, i bankuyerrninthanu da tarangka-ya i da thipinhi-ya. I Yile neki bamkardu patha, i le warda dinidha nanhthi nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini, i nhini-ka da-ka 4 warda mam mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Bere Yile neki-ka mam, “Kura lalingkin i kura patha-ka pimardawethnu ku ngurlmirl i ku ngernu ku purrkpurrk terert warda ngatha. I da kangkarl-ka pimardaweth-deyida-nu ku murrirrbe ku purrkpurrk ku ngala ngala-ya parnibarlbarlnu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bere Yile neki mampatha ku ngurlmirl ngala ngala warda i ku ngurlmirl purrkpurrk deyida ngamere i ku numi deyida ku ngernu wanku mampatha. I ku murrirrbe deyida mampatha ku purrkpurrk i ku ngala ngala ku terert. I bere Yile neki-ka bamkardu patha, i le warda dinidha ku nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bere Yile neki-ka mange patha mampirra ku nhini-nu-yu. I murrinh-ka mam, “Ku terert pana parnam ngarra lalingkin i kura patha-ka ku purrkpurrk terert deyida puruwawaknu, i pimardawethnu thathpirr purru kura lalingkin i kura patha. I ku murrirrbe terert warda ngatha puruwawak-deyida-nu i pimardawethnu thathpirr da ngarra putek wanku.” ");
INSERT INTO mwf2018_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini, i nhini-ka da-ka 5 warda mam mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Bere Yile neki-ka mam, “Da ngarra putek thangunu-ka ku terert warda ngatha parurtuynu, ku wililiwunme-ya, ku kanamkertkert-ya, ku parlakmemnu-ya i ku purrkpurrk thathpirr-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","I bere Yile neki mampatha-ka ku wurnangat warda ngatha. I bere bamkardu patha, i le warda dinidha ku nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Bere Yile neki-ka mam, “Kardu warda mawathanu mangini nekineme deyida mani. I kardu nhini-ka pule ngala purrurranu ngarra ku terert warda ngatha, ku ngurlmirl-ya, ku murrirrbe-ya i ku pana parnam ngarra da putek.” ");
INSERT INTO mwf2018_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","I bere Yile neki-ka mampatha kardu, mangini nukunu deyida mani. Kardu nugarn i kardu palngun mampunkuwathangintha. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I murrinh patha nimin-ya mampirrungintha, “Nankungintha-ka wakal terert nanginthawerdurdunu thurru i da pana-re pubuylangnu puru ngarra da putek ngala pana. I kardu warda ngatha pule ngala nuyunu da ngarra putek ngala pana-yu. I ngay-ka bannanpak kardu pule ngala ngarra ku ngurlmirl-nu-ya ngarra ku murrirrbe-nu-ya i ngarra ku wurnangat warda ngatha ngarra da putek ngala pana parnam-ya. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“I nga, mi kamarl i mi dhepdhep terert pana kurrannarrangkadhuk ngarra da putek ngala pana-ka nhini-wa mi dhepdhep nanki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","I mi dhepdhep ku murrirrbe pigunu i ku wurnangat warda ngatha pana parnam ngarra putek-ka mi mulurn i parnu ngatin da matha pana kurranpirrangkadhuk.” I bere mi-ka nhini-wa dampirramut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bere Yile neki-ka bamkardu warda da nhini ngarra nukunu mampatha-yu i bere thathpirr patha i ngala warda le dinidha nukunu-yu. Bere da thipinhi warra ngadha wurrinidha i da tarangka ngadha danilarrangtha wurrini, i nhini-ka da-ka 6 warda mam mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","3","Bere Yile neki-ka marntikerdek warda da wurnangat nhini-yu da kangkarl-yu i da putek ngala kanhi-yu. I nhini-wa da mam 6 marntikerdek-yu. I ngarra da 7 mana mam-ka bangamyuk warda, mere deyida thangku nanhthi mewathadha, mu beyuktha warda dini da ngarra 7 nhini mam-yu. I da 7 nhini-ka da-ka ngala-wa banpak da ngarra nukunu-nu-yu, nhini-ka bangamyuk warda da ngala kanhi thangunu wanku mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bere kanhi-wa murrinh-yu, murrinh ngarra Yile neki pule ngala thathpirr-ya mampatha da kangkarl i da putek ngala kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Bere da marra-re-ka nanhthi thay mananhthi i nanhthi parnu mananhthi da ngarra putek kanhi-yu, nhini Yile neki-ka mere da ngatha kura yelyel wurdithuktha, i mere ngadha nangkal kanidha ngarra putek kanhi kanirurtuydha i dirrangipedha kani. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mu da nhini-re kura-ka wurdarnalaldha dini ngarra putek kathu pepe i kura wurriniwudha ngarra putek. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","I bere Yile neki-ka nanhthi putek mangankut, i nanhthi putek nhini thangunu-ka kardu warda mampatha. I ngarra thimu nukunu warda wurdanwi ngirtkirt nukunu thangunu. I kardu-ka birnu warda wurdankabirl. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Bere Yile neki-ka mi kadin banpak da ngarra Eden pangu kathu ngarra ngunga kathu pangarnturtuy pirrim. I da-ka nhini wangu dampinthat-yu kardu nhini ngarra mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","I da ngarra putek nhini thangunu kathu wurdarnarurturttha wurrini thay lelunh terert da nhini-yu, mi dhepdhep patha wanku. I ngarra mi kadin nhini marda nganangurr-ka thay perrkenku deyida wurdanturturt. Thay numi-ka birnu kardu nukunu, i thay numi-ka ngarra da patha nukun i da wiye nukun kardu the pumabathnu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","I kura ngipilinh wurriniwudha da ngarra mi kadin nhini Eden-yu. I da nhini thangunu ngarra da Eden thangunu-ka memyerryerr ngipilinh 4 kanhi warda wurriniwudha kura-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","14","I ngipilinh nhini-ka murrinh-ka kanhi-wa Pishon, Gihon, Tigris i Euphrates. Ngipilinh nhini Pishon-ka wurriniwudha pangu warda wangu da nan Havilah ngarra da nanhthi gold, nanhthi palyirr lakakkakmam i nanhthi lakumin wunku kangunu patha wurriningkadhuktha. I ngipilinh nhini Pishon-ka wurriniwudha da ngarra nan Cush. I ngipilinh nhini Tigris-ka wurriniwudha da manta da ngarra nan Assyria ngurru-re ngarra ngunga kathu pangarnturtuy pirrim. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bere Yile neki-ka dampinthat kardu nhini-yu da ngarra mi kadin nhini Eden-ya nanhthi thay i mi pirrapenu pani i panirurtuynu ngarra mi kadin nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","I murrinh warda mamna, “Nga, nhinhi-ka mi terert kurrankadhuk pana thanimurrknu mi ngarra thay pana thangunu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mu thay marda nganangurr karrim pangu thangunu mere nukun thulath mi thay nhini thangunu-yu thay ngarra the nabathnu da patha i da wiye-yu. Mu mi thay nhini thangunu thulathnu ngatha-ka nhini-ka thupup da-nu matha nhini-yu,” Yile neki kathu mammardawerr kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bere Yile neki memnu, “Mere patha nhini-yu kardu nugarn kanam numerrnu-yu. Kardu numi deyida mawathanu i pungkayithnu pani i mamanpinu purru.” ");
INSERT INTO mwf2018_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mu Yile neki-ka ku mampatha wardarra nhini-yu ku terert wurnangat warda ngatha i ku murrirrbe wanku ngarra da putek thangunu-yu. I bere ku numi numi warda wurdininadhukthuktha dini ngarra nukunu nhini Adam i murrinh warda punintharraththa wurrini. I murrinh ngarra punintharraththa wurrini-ka ku-ka murrinh-ka nhini da matha murrinh panparl-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I nukunu Adam-ka ku terert warda ngatha ngarra da putek kanhi punintharraththa wurrini i ku murrirrbe wanku. Mu Adam-ka numerrnu da ngatha kardidha i ku terert nhini-ka mere ngadha numi puyingkayiththa parni i mere pumemanpidha parni. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Bere Yile neki-re wurdanwit mamkangurrngurr nukunu Adam-yu ngurrnguwarl ngala yudha i ngalarnarn numi yunganngurrupirt i darripi wurdannangkarl deyida. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","I kardu palngun warda mampatha nanhthi ngarra ngalarnarn nukunu thangunu-yu. I menabertidha wurrini ngarra Adam-nu warda. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Bere Adam-ka, “Aa,” pamngemarda, i mam, “Kardu numi mangini ngay deyida mani karrim kanhi-yu. Nigunu-ka murnu i nginipunh ngay thangunu kardu karrim kanhi-yu. I murrinh nguparlnu-ka palngun, nhini nigunu-ka ngarra ngay thangunu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","I da-ka nhini warda-wa kardu nugarn-yu yile nukunu i kale nukunu kanampunkupartngintha i bemnginthalet palngun nukunu-yu. I peningintha-ka kardu mangini numi da kanamngintha. ");
INSERT INTO mwf2018_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","I bere, nukunu Adam i palngun nukunu-ka kardu marlang kardinginthadha, mu mere yidiwe kaninginthadha. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bere, ku ngarra wurnangat nhini thangunu Yile neki mampatha-ka, ku pangkuy ku numi da kardidha ku warnangkal-yu ku dimpunpewal. Bere ku pangkuy-ka wurriningedha kardu ngarra palngun, i murrinh mamnge, “Nganaka? Murrinh da thathpirr mamnarrungintha Pule ngala-yu mi dhepdhep terert kanhi-nu mere thaninginthamurrknu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mu kardu palngun kathu-ka mamna, “Awu, ngankungintha-ka thay terert karda matha wurdanngankungkangintha mi nganinginthamurrknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mu thay numi pangu da matha karrim marda nganangurr-ka Pule ngala mamngarrungintha, mi thay pangu thangunu-ka mere ngulanginthath nukun i mere manginthathap nukun. Mu mi thay nhini ngatha manginthathap i ngulanginthathnu-ka nhini-ka ngunginthapupnu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mu ku pangkuy kathu-ka mamnge, “Awu wurda, mere murrinh thathpirr nhini-yu. Nankungintha-ka mere ngarra thunginthapup nukun. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mu Pule ngala the kanthin-ka mi thay pana ngatha thulanginthathnu-ka nhini-ka mangini nukunu deyida mani thurrunginthanu. I the warda nanginthabathnu thani da patha-yu i da wiye-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bere nigunu-ka kangkarl mamka warda ngarra thay nhini i memnu warda, “Thay kanhi-ka thay lelunh i mi-re mi patha. I mi thay kanhi ngatha-nu ngulathnu-ka nhini-ka the mabathnu da terert warda ngatha.” Bere mi warda mungarntal pirrim i darntal. I mi nhini-ka damnamut ngarra nangkun nigunu, i nukunu deyida darntal, i mi nhini-ka wulamnginthath warda. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Bere mi nhini thangunu wulamnginthath-ka da terert warda ngatha the kanthinginthadha wurrini i the warda mamnginthabath kardu marlang kardinginthadha-yu. I nhini-ka damnginthawarl nanhthi mulurn ngala warda i nginipunh ngarra peningintha demnginthangkawup. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bere da kungini numi burrburr nhini da ngatha peningintha-ka bimnginthayepup Yile neki wurrinililidha ngarra mi kadin, i nhini peningintha-ka demnginthanham i mamnginthardarri ngarra thay. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bere Yile neki-ka pirrimnakay ngarra Adam, i murrinh mamna, “Ngarra thim?” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","I nukunu Adam kathu-ka mamna, “Ngay-ka bimpayepup thurrinililidha ngarra mi kadin i ngemnhimanham warda i marnarri i marlang wanku bemnungkardu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mu Yile neki kathu-ka murrinh mamna, “Nangkal mampa marlang thardidha-yu? Mi-ka thulamath ngarra thay pangu thangunu-yu murrinh-ka mampa mana-ya, mere nukun thulath mi thay ngangka thangunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mu Adam kathu-ka mamna, “Kardu palngun pana ngarra thamngamut-ka nigunu-wa mi damngamut-yu i mi-ka ngay warda ngulamath-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Bere Yile neki murrinh mamnge ngarra palngun nhini, “Thangku-nu mange nhini nam-yu?” “Awu, ku pangkuy kathu damngathuk i damngayirrart, i mi-ka ngulamath warda,” nigunu kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bere Yile neki-ka murrinh mamna ngarra ku pangkuy, “Da-ka wiye thathpirr-wa pirrampanu nhinhi-yu mange nhini thangunu namnge ngarra kardu palngun-yu. Nhinhi da matha wiye pirrampanu, mu ku terert ngamere-nu-ka wurda. Marra kanhi warda wangu-ka nhinhi-ka bere matha wangu thaniwarlaknu marda-re ngarra putek, i mi-ka wunku putek-wa thanimurrknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I nhinhi i kardu palngun-ka thu kuy da matha thaninginthanu. I ku ngarra nhinhi thangunu panhirethbathnu puru i kardu ngarra nigunu thangunu parethbathnu puru kuy deyida parninu. I kardu pana ngarra tiduk kathu purrunu-ka pununhiwethurrnu ngarra pelpith nhinhi. I nhinhi-ka dalelenu ngarra me timelu nukunu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Bere Yile neki-ka murrinh deyida mamnge kardu palngun, “Ngay-ka da tetemanthay ngampamutnu ngarra putput thurrunu-yu i yidingurr ngala da matha ngampamutnu-yu ngarra kardu wakal-te pubuywathnu puru-yu. Mu kardu-ka nangkun nhinhi da ngatha marda nartnu thurru-yu. I nukunu-ka pule ngala nhinhi purrumpanu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bere Yile neki-ka murrinh mamna Adam, “Ngay mampa-ka mi thay nhini-ka mere thulath nukun, mu nhinhi-ka dimngeyepup murrinh ngarra palngun nhinhi i mi warda thulamath. Mu murrinh ngarra ngay thangunu mampa-ka mere nengabaththa, nhini-ka da putek-ka wiye warda pumpanu, i da-ka tetemanthay pirranu ngarra mi terert pana-re purdirurturtnu puru-yu. I nhinhi-ka wurlk ngala da matha thaninu thanirurtuynu mi-nu-yu thurdururturtnu thurru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","I parnu wiye i nanhthi mayeyep i nanhthi wiye nginipunh nhini mani-yu purdirurturtnu ngarra putek-yu. I pana warda ngarra purdirurturtnu purru mi nhini warda thanimurrknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I wurlk ngala da matha thaninu nginthirrin wunku mi thurdururturtnu-yu mi dhepdhep nhinhi-yu. I bere matha wangu wurlk ngala thaninu i ngarra thupup da-nu mana, i ngarra putek deyida thurdiwurlnu, putek nhini da ngatha ngarra ngay mamnhiwatha da marra-re-yu.” Yile neki-ka murrinh-ka nhini-wa mampirrungime. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bere nukunu Adam-ka murrinh warda panparl palngun nukunu, Eve. Murrinh Eve-ka birnu, nhini-ka kalekale ngarra kardu birnu thurran. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bere Yile neki-ka mampirruwathangintha nanhthi darripi, ku thangunu, i bamnginthardurdi warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Bere nhini thangunu-ka Yile neki-ka mam, “Nga, peningintha pana-ka mangini nekineme deyida mani i the warda kanthinngintha da patha i da wiye. Mu mi thay numi pana deyida karrim-ka, mi ngarra birnu nukunu-ka, mere nukun ngurdunkungkangintha i mere kulanginthath nukun. Mu mi thay nhini ngatha pulanginthathnu-ka nhini-ka kardu bere matha wangu birnu da matha kaningintha,” mam Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","I bere, nhini thangunu-ka wurdanpunkungkarel-warda-ngintha da ngarra mi kadin Eden thangunu kathu-yu. I da numi warda wangu nanginthadha dini. I bere da ngarra putek nhini da kardirurtuydha Adam-yu, da putek nhini da ngatha ngarra Yile neki-re mampatha nukunu Adam-ya ngarra da marra-re kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bere ngarra wurdanpunkungkarel-thangunu-ngintha-ka nhini Yile neki-ka ku angel dampunkuwinthatneme ngarra mayern kumparra mi kadin-nu wangu wunku nanhthi sword wunku thungku benarduydha pirri. Ku angel nhini-ka mayern nhini da ngarra thay birnu nukunu pirangkadhaneme pe kardu kama kurdinginthawurl. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Bere da nhini thangunu-ka da numi warda kardinginthadha Adam Eve peningintha-yu. Bere nigunu Eve-ka wakal nugarn bamngebat i murrinh warda mam, “Yile neki-ka mamngimanpi i nhini-ka kardu wakal warda damngamut.” I bere nigunu murrinh panparl-ka Cain-wa. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","I da nakurl-te wakal nugarn numi deyida bamngebat. I murrinh panparl-ka Abel-wa. Bere piguna nhini-ka puddamkarurturt warda. Nukunu Abel-ka ku thip i ku nenigut dirranpedha wurrini i nukunu Cain-ka nanhthi putek wurrinirurtuydha i mi dhepdhep wurdinirurturttha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bere da nakurl deyida nukunu Cain-ka mi ngarra wurdinirurturttha wurrini-ka kanamkut warda i ngarra Yile neki warda damnamut. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","I nukunu Abel deyida-ka ku thip ngarra kumparra bammat, manganmert ku ngen patha-ya i panmat i damnamut ngarra Yile neki. I Yile neki-ka le warda dininadha Abel-yu ngarra ku ngen thip thangunu damnamut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mu ngarra nukunu Cain-ka mere le dininadha ngarra mi dhepdhep nhini damnamut-yu. I nhini-ka Cain-ka kamarl thu kuy warda kardidha i ngarra marda wanku denamardarurrdha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bere Yile neki kathu-ka murrinh mamna Cain, “Thangku-nu kuy thanam-yu ngarra marda nhinhi demnhimardarurr kanam-yu i ngarra kamarl wanku thu kuy ngirrannhingkathenh ngem? ");
INSERT INTO mwf2018_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mu mange patha ngatha nedha marra-re-ka nhini-ka le-wa thanidha-ya. Mu mange-ka mere patha nedha, nhini-ka thirranunginikatnu mange wiye-ka mere thama nukun. Mu nenuyit da matha-nu thurru, i nhini mange wiye-ka mere warda nabath nukun thurru.” ");
INSERT INTO mwf2018_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Bere nhini thangunu-ka nukunu Cain-ka murrinh mamna ngarra ngathan nukunu Abel-ya, “Ka, purru mani pangu wangu.” Bere punnadha pangu warda wangu da ngarra nhini da. I bere nukunu Cain-ka thu panmat warda wurdantinumi ngathan nukunu Abel-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bere nhini thangunu Yile neki kathu-ka dantharrpu Cain, “Ngarra ngathan nhinhi-yu?” “Yaa, mere the mabath, ngarra kama kanam,” Cain kathu-yu mamna. “Ngay-ka mere ngirrape-wa ngurru nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mu Yile neki kathu-ka mamna, “The nganthin berengunh mange wiye ngala namna ngathan nhinhi thu thanmat. I kumulung nukunu ngarra putek thangunu kabim pangu-ka yibimngakaykay warda i mamnga yibim, ‘mange ngurdumpawerl-deyida-nu.’ ");
INSERT INTO mwf2018_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","I kumulung nhini-ka ngarra putek warda yunganthung, nhini-ka ngarra putek-ka wiye warda pumpanu nhinhi-nu-yu. I ngarra putek-te thanirurtuynu mi dhepdhep-nu-ka, nhini-ka mere ngarra warda purdimparurturtnu, da-ka nhini-re-wa da putek-ka da wiye thathpirr bumpapaknu-yu. I bere nhinhi-ka kardu bere matha therduynu thani da pana ngangka-re-ya i kardu manangka da thaninu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Bere Cain kathu-ka murrinh mamna ngarra Yile neki-nu, “Da-ka tetemanthay ngala-wa nhini-yu ngarra ngay-nu thamngamut-yu. I murrinh pana deyida namnga, nhini-ka tetemanthay deyida. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","I thurdungingkarelnu da putek patha kanhi thangunu-ya i nhinhi-re kathu thurdungingkarelnu-ya. I ngay-ka kardu bere matha wangu ngerduynu ngani da pana ngangka-re i kardu manangka da nganinu. I kardu ngatha pubangirdurtnu-ka, nhini-ka thu pungibatnu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mu Yile neki kathu-ka mamna, “Awu wurda. Kardu ngatha pubanhirdurt i thu punhibatnu-ka nhini ngay-ka mange thathpirr deyida ngurdurrawerlnu.” Bere Yile neki-ka nanhthi magim warda damnamut ngarra nginipunh nukunu Cain-yu, i nhini-ka kardu ngatha pubamkardu nanhthi magim nhini ngarra nginipunh nukunu-ya i nhini kardu-ka mere ngarra warda thu puyibattha Cain-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Bere murrinh nhini thangunu damnintharikerdek, nukunu Cain-ka kanampart i nungardurr warda ngarra Yile neki kathu-yu. I nadha warda dini da nan-nu warda wangu Nod, i nhini da kardidha-yu. Da Nod nhini-ka pangu wangu ngarra ngunga kathu pangarnturtuy pirrim ngarra da Eden wangu danimardabaththa pirri. Bere Cain i palngun nukunu-ka kardu wakal bampirrubatngintha, i murrinh nukunu-ka Enoch-wa. I Enoch thangunu kathu-ka kanhi-wa kardu perrenerethbaththaneme purne-yu. Nukunu Irad, Mehujael, Methushael, i Lamech. Mu Lamech thangunu kathu-ka wakal perrkenkuneme-wa, nukunu Jabal, Jubal i Tubal Cain pigunu ngatha-yu. Nukunu Jabal-ka nukunu da matha kardu kumparra kardipuptha-yu da ngarra nanhthi tents-yu i da wurriniwattha da pana ngangka-re ku wunku menbertidha wurrini ku thip-ya, ku puliki, i ku nenigut. I nukunu Jubal-ka, nukunu da matha kardu kumparra-yu nanhthi meringerrentha wurrini nanhthi kitta mani i nanhthi flute-yu. I nukunu Tubal Cain-ka, nukunu da matha kardu kumparra-yu mewathadha wurrini nanhthi lithpurr, thamul i nanhthi nginipunh nhini mani-yu nanhthi steel thangunu-yu. Bere, nukunu Adam-ka wakal numi deyida bamnabat, i murrinh nukunu-ka Seth-wa. Bere kanhi-wa kardu-yu ngarra Adam thangunu kathu perrenerethbaththaneme purne-yu. Nukunu Seth, Enosh, Kenan, Mahalalel, Jared, Enoch, Methuselah, Lamech i Noah. Kardu-ka pardidha i ngarra ngalantharr thathpirr da mana pinimnu i wakal-ka wakal terert-wa pumenbertidha pardi-ya. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bere kardu-ka puy wangu daniwithpiththa wurrini i kardu ngarra wurnangat da mana pardidha da ngarra putek ngala kanhi. I kardu-ka pubanalangtha purni da pana ngangka-re-ya wunku wakal wurnangat, wakal murruwurlwunka-ya. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Bere da nhini-re-ka ku angel wiye ngamere pardidha i parnampart Yile neki-yu. I puddanthut kangkarl kathu-yu i ngarra da putek kanhi. I ku-ka pubampunkardu kardu palngun murruwurlwunka, i nhini-ka pumampunkarart warda i panthinpunpinhat. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Bere Yile neki-ka mam, “Ngepan ngay-ka mere ngirranpe nukun ngani ngarra kardu pangu-yu da bere matha wangu-yu, nhini-ka pigunu pangu-ka kardu da matha parnam-yu. Mu da-ka da thangku 120 ngarramutnu-yu kardu parnibirnunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Bere da nhini-re ngarra ku angel wiye nhini-re puddanthut i ngarra kardu palngun pubangampunlet i wakal terert wunku pumenmertidha pardi-ka kardu nginipunh ngen ngala ngala terert pardidha da ngarra putek ngala kanhi-yu. I da nakurl-re deyida pardidha kanhi-yu. I kardu-ka murrinh puddininyiththa purni kardu nginipunh ngen ngala ngala kardu lurruth nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Bere Yile neki-ka bampunkardu kardu da ngarra putek kanhi mange wiye da matha pumebaththa pardi. I kardu-ka da wiye da matha pubenayengkarnirntha pardi i da wiye da matha marda pumerttha purni. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","I nhini Yile neki-ka dammardathin ngala da matha warda ngarra kardu mampunpatha i da ngarra putek kanhi dampunpinthat-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I mam, “Ngay-ka ngirranparlaknu warda kardu terert pana-yu ngarra mampunpatha-yu. I ku wunku ngirranparlaknu ku ngala ngala-ya, ku purrkpurrk-ya i murrirrbe wanku. Kardu i ku wurnangat warda ngatha ngirranparlaknu, nhini-ka damngimardathin wanku ngarra mampunpatha-yu,” mam Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mu kardu numi da matha Yile neki-yu le menanamardadha dini-yu. I murrinh nukunu-ka nan-wa Noah. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","I kanhi-wa murrinh ngarra Noah nukunu-yu. Nukunu-ka wakal nugarn perrkenkuneme menbertidha kardi. I murrinh pigunu-ka Shem, Ham i Japheth. Nukunu da matha Noah kardu patha kardidha da nhini-re-yu, i nukunu-ka murrinh wunku menabaththa wurrini Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Mu kardu wurnangat-ka kardu wiye da matha pardidha i thu kuy da matha pardidha. I Yile neki bampunkardu da mange wiye da matha pumebaththa pardi i da ngarra mange pigunu-ka wiye da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","I bere Yile neki kathu-ka mamna ngarra Noah, “Nga, ngay-ka ngirranparlaknu kardu wurnangat warda ngatha da ngarra putek pana parnam. Kardu-ka da mange wiye da matha parnam i thu kuy da matha parnam. Ngay-ka mere marda mart da mange wiye-yu, i nhini ngay-ka ngirranparlaknu da-nu matha warda. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mu nhinhi-ka tharntu ngala darderdenu nanhthi thay patha thangunu kathu i da weyi ngala ngala i da purrkpurrk dadhangarryerrnu. I nanhthi thipmam letetmam nawarlaknu ngurru kanhi-re i pangu-re marda numi-re, i ngarra da weyi inside deyida namardawarlaknu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tharntu-ka nanhthi-ka pangkuy-wa nawathanu i ngala da marda i kangkarl thathpirr nawathanu. Tharntu ngala thathpirr nimin-ya nawathanu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I da weyi tuwa nawathanu ngarra ngurru-re. I pelpith dupaknu i kunungingki pirrabekthaynu ngarra pelpith ngurru. I ngarra da weyi-ka da-ka perrkenkuneme dupaknu pepe numi-yu, i kanganu i kangkarl. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Mu nga, ngay-ka kura ngala da matha ngurduthuknu i da putek ngala pana-ka mawerdum-da-matha-nu. I kardu i ku wurnangat warda ngatha panthikwiknu i pudduntinuminu i ngirranparlak da-nu matha. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mu murrinh ngarra ngay ngampamutnu, murrinh patha nimin-ya, i murrinh-ka kanhi-wa. Nhinhi-ka ngarra tharntu thanirdinu i palngun nhinhi wanku. I wakal nhinhi-re i palngun pigunu-re narnerdinungime. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","I ku-ka perrkenku perrkenku-wa thirranmardaputhnu ku bere ngatha warda ku murrirrbe-ya i ku terert warda ngatha ku nugarn ku mirringi, i nhini-ka birnu warda ngatha parninu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I mi dhepdhep mi terert warda ngatha thanikutnu i durdurdinu ngarra tharntu mi nankungime-nu-ya i mi ku-nu-ya.” Nhini-wa murrinh patha thathpirr Yile neki kathu mamna Noah-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","I bere nukunu Noah-ka murrinh da matha mamnabath i mange nhini mam-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Bere da nhini thangunu Yile neki-ka mamna ngarra nukunu Noah, “Ngay-ka ngirranhingkadha ngardi nhinhi da matha kardu patha thathpirr thanam-yu. I nhini nankungime-ka narnerdinu-warda-ngime ngarra tharntu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","I nanmertinu ku wanku 14-wa ku-yu ku pana ngarra tarangka murrinh mampa-re-yu, ku nugarn 7 i ku mirringi 7. Mu ku ngamere ku mere tarangka thathpirr-ka perrkenku perrkenku nanbertinu ku nugarn i ku mirringi. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","I ku murrirrbe deyida ku nugarn 7 i ku mirringi 7 nanmertnu. I da nakurlnu deyida-nu ku terert nhini-ka pawithpith-deyida-nu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","I bere da ngarra 7 pamanu-ka kura yelyel ngurduthuknu da ngarra putek ngala pana. I kura-ka bere ngatha wangu pirrayelnu da 40 days i da thipinhi 40. I kardu wurnangat warda ngatha i ku wurnangat warda ngatha panthikwiknu. I ngay-ka ngirranparlak da-nu matha ngarra kardu i ku mampunpatha-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","I bere nukunu Noah-ka murrinh mamnabath murrinh ngarra Yile neki thangunu mamna-yu i mange nhini mam-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bere da thangku nukunu Noah-ka kardu da thangku 600-wa kardidha ngarra Yile neki-re kura ngala wurdanthuk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Bere nukunu Noah, palngun nukunu, wakal nukunu-re i palngun pigunu parnamkardi-warda-ngime ngarra tharntu, nhini-ka mere warda ngarra pankuyiwiknungime. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","I ku wunku parnardi ku wurnangat warda ngatha wunku ku murrirrbe. I ku ngamere tarangka-ya, i ngamere manangka tarangka thathpirr, i pirdurdidha ngarra tharntu perrkenku perrkenku ku nugarn-ya ku mirringi-ya murrinh ngarra Yile neki thangunu mamna ngarra Noah. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","I da ngarra 7 nhini thangunu parnamkardingime-ka wunku ku wunku, Yile neki-ka kura ngala nimin-ya, wurdanthuk warda. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","12","Bere da nhini-re nukunu Noah-ka 600 da thangku nukunu-yu kardidha. I da merrk perrkenku i da 17 days, da nhini-re-ka kura ngarra putek pepe thangunu kathu-ka lurruth ngala da matha dempirnturt, i da ngarra kangkarl thangunu kathu kura ngala da matha pirriyeldha bere matha wangu ngarra da 40 i da thipinhi 40 da mana. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Bere Noah i palngun nukunu i wakal nukunu Shem, Ham i Japheth, i palngun pigunu-re parnamkardingime ngarra tharntu. I da ngarra 7 nhini thangunu mam-ka Yile neki-re kura ngala wurdanthuk. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","I ku wanku parnardi ku ngala ngala, ku purrkpurrk i ku murrirrbe purrkpurrk wunku. I ku-ka perrkenku perrkenku pirdurdidha wunku Noah-yu, ");
INSERT INTO mwf2018_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","murrinh ngarra Yile neki thangunu mamna ngarra Noah. I bere Yile neki-re-ka danthap warda nanhthi tuwa. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","I kura ngala thathpirr warda wurdanthuk-yu da ngarra 40 da-nu mana. I bere kura-ka puy wangu denawirnturttha wurrini i kura-ka puy wangu ngala wangu wurrinidha, mu tharntu-ka puy wurrinirurturttha ngarra kura kangkarl-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","I kura-ka puy wurrinimardawiththa i ngarra da palyirr ngala ngala da mana mamperdum, i puy kunungingki deyida wangu dempirnturt kura-yu ngarra mampeweth da mana. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","I kardu i ku wurnangat warda ngatha daninthikwiktha wurrini da ngarra putek kanhi pardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yile neki-re pirrimpunparlak kardu i ku wurnangat warda ngatha da ngarra putek ngala kanhi pardidha-yu. Mu Noah da matha peningime birnu pardedhangime-yu i ku wunku ngarra tharntu pardinganamardadha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bere kura ngala thathpirr-ka kuguk-wa pirridha da merrk 5 da mana. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bere Yile neki-ka bere ngatha dirrankupedhangime kardi kardu Noah peningime i ku wunku ngarra tharntu pardinganamardadha. Bere nhini thangunu-ka nanhthi wirrirr warda wurdanthuk yurrirrdha i kura-ka yunginiyerrdha wurrini thawath. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","3","Kura lurruth ngala nhini ngarra putek pepe thangunu denawirnturttha wurrini-ka, manthap warda. I kura yelyel deyida manthap. I kura ngala ngarra da putek mamperdum-ka thawath da matha da merrk 5-nu-ya wurdanathuttha wurrini, ");
INSERT INTO mwf2018_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","i ngarra tharntu pirret da mana ngarra da palyirr ngala kangkarl. Da-ka murrinh-ka Ararat palyirr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","I kura-ka puy wangu wurdanathuttha wurrini da 74 days-nu-ya i ngarra palyirr ngala ngala da mana daniwerurtuydha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bere da 40 days thangunu mam, nukunu Noah-ka nanhthi window ngarra mampatha ngarra tharntu-ka mantharl warda ");
INSERT INTO mwf2018_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","i ku wak wurdanthuk. Mu ku-ka mere wurdanawurldha, mu bere matha benarduy-da-dha ngatha kardi ngarra kura thathpirr yunganyerr. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","I da 7 thangunu mam-ka ngarra ku nhini-re benarduy da-dha ngatha kardi-ka ku numi warda wurdanthuk ku bamanthamarl kura-nu bamkardu wurdannayith. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mu kura-ka kuguk da ngatha ngala da ngatha pirridha i ku nhini-ka mere da ngatha ngarra pirrangittha, i nhini-ka wurdawurl deyida ngarra tharntu. I Noah-ka nithi yungannawuy wurdankarl ku nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Bere da ngarra 7 nhini thangunu kathu-ka ngana deyida wurdanthuk ku nhini da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","I da kungini nhini da ngatha wurdawurl nanhthi mulurn marra wanku kanthibirrdha tharra wurdannangkarl ngarra Noah-nu. I nukunu-ka the warda mammath kura-ka yunganyerr warda ");
INSERT INTO mwf2018_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Bere da 7 nhini thangunu-ka da numi deyida ku nhini da ngatha wurdanthuk, mu ku-ka mere wurdananawurldha ku bamanthamarl nhini-ya. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Bere da nhini-re ngarra nukunu Noah-re kardidha ngarra da thangku nukunu 601, da merrk numi i da numi, kura nhini-ka yunganyerr. I bere nanhthi pana ngarra ngurru kangkarl ngarra pelpith darnarrawup-ka yunganwurr warda mintherr i bamkardu nhini kura-ka yunganyerr warda. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","I bere da merrk perrkenku nhini thangunu-ka da putek-ka tumtum thathpirr warda yudha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","I bere Yile neki kathu-ka mamna Noah, ");
INSERT INTO mwf2018_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nungewuy-warda-ngime ngarra tharntu kathu-yu ");
INSERT INTO mwf2018_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","i ku wanku kathu thungunwurr. I ku-ka ngana deyida pawithpithnu i pubuylang-deyida-nu purru da ngarra putek ngala pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","I bere Noah peningime-ka pungamkawuy-warda-ngime. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","I ku wanku pungawurr warda, ku ngala ngala-ya, ku purrkpurrk-ya, ku parlakmenanudha wurrini-ya, ku murrirrbe-ya, ku terert warda ngatha pungawurr, i ku pumemkarart-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Bere nhini thangunu Noah-ka nanhthi palyirr warda bangamkarda. I ku pana ku numi numi ku ngarra tarangka-ka menkararttha pirri puninthuktha warda pirri. I thungku ngarra palyirr numi numi ku binhi da matha ningamnapek Yile neki-nu. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bere Yile neki menthingap warda kangunu patha ngarra ku thangunu kathu wurriniwuyrdarridha, i murrinh warda memnu, “Ngay-ka mere deyida mawiye nukun da putek ngala pana-yu kura ngala-re-yu, kardu thangunu da mange wiye pumebaththa pardi. Kardu-ka da mange wiye da matha pubenthengkarnirn pumpan ngarra mamay-re kathu, mu ngay-ka mere deyida ngirranparlak nukun kardu i ku, mange kanhi ngamam mani. ");
INSERT INTO mwf2018_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mu ngarra da putek ngala pana pirra da-nu ngatha-ka, da ngarra ngunga-re-ya, da thipinhi-ya, da merrk-ya, mirrangan-ya, da malarnpakpak-ya i da thangku-ya, da nhini-ka da bere ngatha wangu purungkadhuknu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Bere Yile neki kathu-ka murrinh patha nimin-ya mampirruneme Noah i wakal nukunu. “Nga. Nanki-ka wakal terert nubuymanguthputhnu nuru i ngana deyida pawithpithnu i pubuylangnu puru da pana ngangka-re. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","I ku terert-ka penanmanhamnu puru, ku ngala ngala-ya, ku purrkpurrk-ya, ku murrirrbe-ya i ku ngurlmirl-ya. I ngay-ka kardu pule ngala bunanpaknu narnirranu ngarra ku wurnangat warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","I ku nhini-ka ku-ka dhepdhep nanki nhini-yu. Ngay-ka mi ngamnarramut da marra-re-yu, mu marra-ka ku wanku i mi dhepdhep nurumurrknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mu ku ngen-ka mere nullath ngarra kumulung wanku da ngatha dim-yu, mu kumulung warra ngadha pirriwu i panirikerdek-da-nu mana. Kumulung-ka nanhthi ngala-wa, nanhthi ngarra nginipunh birnu nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Mu ku-re ngatha kardu balelenu i purdurinuminu ngatha-ka nhini ngay-ka ngurdunawerl-deyida-nu ku nhini-yu. I kardu numi-re ngatha kardu pubatnu purdurinuminu-ka nhini ngay-ka ngurdunawerl-deyida-nu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ngay mamnanpatha nanki-ka mangini ngay deyida mani. I nhini kardu nangkal ngatha thu pubat i kurdurinumi kardu numi, nhini-ka kardu ngamere deyida-ka thu puddunawelnu puddurinuminu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bere nanki-ka wakal terert nubuymanguthputh nuru i ngana deyida pawithpithnu i pubuylangnu puru da pana nganka-re.” ");
INSERT INTO mwf2018_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bere Yile neki kathu-ka mampirru-deyida-neme Noah i wakal nukunu-re, ");
INSERT INTO mwf2018_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mu nga. Murrinh ngay murrinh patha nimin-ya nganarrumutnuneme. Murrinh kanhi-ka nankuneme-nu i kardu pumpan deyida kathu tiduk, ");
INSERT INTO mwf2018_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","i ku deyida wanku ku terert nhini ngarra tharntu kathu pungawurr. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","I kanhi-wa murrinh-yu nganarrumutnuneme-yu. Ngay-ka mere deyida ngurduthuk nukun kura ngala thathpirr kanhi mani-yu i mere deyida ngirranparlak nukun kardu wurnangat-yu i ku wanku-yu. I ngay-ka mere deyida mawiye nukun da putek ngala pana-yu kura ngala-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","“I mange kanhi-wa the numabathnemenu-yu murrinh ngarra ngay thangunu ngamnarrumutneme-yu. Ngay-ka ku kanamkek ngay bupaknu ngarra kalakkalak. I da-ka nhini-re-wa the numabathnemenu-yu murrinh ngay punu da bere matha wangu nankuneme-nu i kardu pumpan deyida tiduk kathu i ku wanku. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","I ngarra ngurduthuknu-re nanhthi kalakkalak-ka i nhini-re-ka nubangkardunemenu ku kanamkek wunku ");
INSERT INTO mwf2018_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ngay-ka the da ngatha mabathnu murrinh nhini ngarra ngay thangunu ngamnarrumutneme-yu murrinh pana ngamam mere deyida ngurduthuk kura ngala thathpirr-ya, i mere nukun deyida ngirranparlak kardu i ku. ");
INSERT INTO mwf2018_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","17","I ngarra ku kanamkek nhini-re pinthanu ngarra kalakkalak, ngay-ka bangkardu i the da ngatha mabathnu murrinh patha nhini ngay thangunu ngamnarramut-yu i ku wunku da bere matha wangu-yu. Ngarra ku kanamkek-te nubangkardunu-ka nhini-wa da-yu the numabathnu-yu murrinh ngay thangunu ngamnarramut-yu.” Yile neki kathu-yu mampirruneme. Bere wakal nukunu Noah-ka Shem, Ham i Japheth. Bere da ngarra kura ngala-re thangunu kathu-ka i kardu-ka kanhi-wa pigunu thangunu-yu pubammanguthputh-yu kardu wurnangat thurran kanhi warda ngatha ngarra da putek ngala kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bere kardu-ka daniwithpith-deyida-dha wurrini i ngarra kardu wurnangat da mana pardidha. I murrinh-ka murrinh numi da matha pardingerrentha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bere kardu wurnangat nhini-ka purnidha kanhi warda wangu ngarra ngunga kathu pangarnturtuy pirrim i da ngarra darrinpirr ngala parrarntuy, da-ka murrinh-ka Babylonia-wa. I da punnungampinhingka nhini da. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","I murrinh warda pumemnu, “Ya. Nanhthi putek parldart parlartnemenu i nanhthi palyirr wanku pumangkarnunemenu i pumawathanemenu i pinariwunemenu ngarra thungku, i nhini-ka tetemam-nu thathpirr, i nanhthi terert nimin-ya pumawathanemenu.” Bere nanhthi warda pumampatha thelput-nu i nanhthi letetmam parnamkut nanhthi ngarra pumaletetnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","I murrinh deyida pumemnu, “Ya peneme. Da thelput terert warda pumawathanemenu. Mu thelput numi-ka pangkuy thathpirr pumawathanemenu puy wangu ngarra marnirra ngana da ngatha wangu pirranu, i nhini-ka kardu ngala warda pubuynupaknungime. I nekingime-ka mere nukun pumerdarrarrngime pubuylang-nukun-ngime da pana ngangka-re. Mu kanhi da matha paninungime.” ");
INSERT INTO mwf2018_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bere da nhini thangunu-ka Yile neki-ka wurdanthut i bangampunmangkardu thelput terert nhini i thelput pangkuy nhini ngarra kardu-re pumewathadha pardi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","I murrinh memnu, “Kardu kanhi-ka kardu numi da matha parnam i murrinh-te numi da matha parnamngerren. I da ngarra mange marra-re pigunu da matha warda marda pumanganart pumpan. I da ngarra nhini da matha warda wangu mange pamam pumpan-ka da nhini da matha mange puyemanu puru. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ka, purdithuthneme,” Yile neki kathu-ka mam. “Murrinh ngarra pigunu parnamngerren-ka pumarrungkarnuneme. I nhini kardu-ka peyetmutnu warda puru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Bere Yile neki-ka murrinh mampunthawingkarnu, i nhini-re warda kardu-ka parnampart warda ngarra pumewathadha pardi da thelput terert nhini-yu. I nhini thangunu-ka pumemnarrarr warda da pana ngangka-re ngarra putek kanhi Yile neki-re banpunlang. ");
INSERT INTO mwf2018_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Bere da nhini murrinh pumpanparl-ka Babel-wa, murrinh kanhi-nu-ya murrinh memkarnu. I da-ka nhini da Yile neki-re murrinh mampirrungkarnu-yu i nhini thangunu-ka banpunlang warda kardu nhini-yu da pana ngangka-re da ngarra putek ngala kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yile Neki-ka dirranganngipe wurran patha da matha nginipunh ku thip mani.Nukunu-ka dannhemut nanhthi terert warda ngatha ngarra ngay marda manganart ngem mangimanpinu. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Nukunu-ka damngangkarda da ngarra parnu pekpek i ngarra kura ngipilinh. I nhini da bengiyuktha dini. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ngarra le wiye warda ngem Yile Neki-ka ngepan patha i ngepan lurruth ngalla warda nhini-yu damngamut. Yile Neki-ka damngangkarda mayern ngarra patha da matha. Nhini-ka kardu warda ngatha the pumabath-nu Yile Neki-ka kardu patha. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Bere ngarra ngurrannilili da ngarra thipmam binhi-ka ngennham ngurran mamngingkayip wurran.Ma Yile Neki-ka dirranganngipe wurran da bere matha wangu nhini ngay-ka mere ngarra ngennham nukun. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Nhinhi-ka nangawathawathanu mi dhepdhep ngay, ngarra kardu wiyenpun ngay pubangingkardunu wanku.Nhinhi-ka kardu pathanhi wanku, i thamngamarda ma kura kathu nangadhaletnu. ");
INSERT INTO mwf2018_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ngay-ka the nganhthin nhinhi-ka kardu pathanhi i kardu marda nanganngert thurran da bere matha wangu.Yile Neki, da thelput ngarra nhinhi-ka da thelput ngay deyida nhini-yu i da bere matha wangu ngarra nganambirnu kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","2","Le da matha pumpan kardu pana-yu ngarra Yile neki-re mampunmayerrarr da mange wiye ngarra pumebaththa purni-yu, i nhini-ka mere warda kuntirda da wiye thangunu-yu. Mu kardu nhini-ka kardu tarangka warda parnam ngarra da mange wiye thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Mu ngay deyida mani-ka ngarra mere nganinatharrmudha ngarra Yile neki-nu da mange wiye ngay-nu-yu, nhini ngay-ka durdumemardadha ngardi du thangunu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Ngay-ka da tetemanthay da matha bangarnurt da thipinhi-ya i da ngunga-ya, nhini ngay-ka the menhibaththa ngurrini mere le thaningadha ngay-yu. Ngay-ka mere thathpirr lurruth ngardidha, mu larrin da matha ngardidha ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Bere, ngay-ka memnu mange ngay, “Ngay-ka nganinatharrmunu warda Yile neki da ngarra mange wiye merithuktha ngurrini-yu.” I bere nhini ngay-ka nganampatharrmu warda ngarra nhinhi-yu da mange wiye medha ngurrini-yu. Ngay-ka murrinh mampa warda ngatha terert. I nhini nhinhi-ka thirrimngimaputh warda da ngarra mange wiye medha ngardi-yu i thamngimayekum warda da nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Mu nginipunh nhini mani-ya kardu wurnangat ngarra nhinhi-ka murrinh kuddimpayith kuru da ngarra tetemanthay-re kubardurt kuru-yu. I nhini da tetemanthay-ka mere nukun warda ngarra manmeyurrut nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ngay-ka ngurrumpanu ngarra nhinhi i nhinhi-ka nangiyibirnunu ngarra da tetemanthay-nu ngatha-yu. Ngay-ka nganimparelnu lurruth da matha, nhini nhinhi-ka namngiyibirnu i thirranganngipe thurran ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Bere Yile neki kathu mannhe, “Ngay-ka ngurdunanthethithnu ngurru da ngarra mange nangiriwaknu nuru-yu. Ngay-ka ngununarrangkanu ngurru i ngirrananpenu ngurru-ya. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Mu nginipunh ku miyul mani-ka pirda-wa. Ku-ka tetemanthay-wa thurduyethith-yu ku pana-ya ku thungantutul thurran-ya. I kardu nukun da matha ku nhini-yu mayit kurru-yu nanhthi bridle bit-te kungudhawirurr kurru.” ");
INSERT INTO mwf2018_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Mu bere, kardu wiyenpun-ka panthin pumpan nanhthi yidingurr da tetemanthay da matha pubangarnurdurt pumpan. Mu bere Yile neki-ka bere matha wangu dirranganpunpe wurran kardu pana ngarra puddamnayemit pumpan-yu. Nukunu-ka marda thathpirr manganpunart wurran kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Bere nanki kardu pana ngarra da mange ngarra yuthpan nanthin numpan-ka le da matha narninu nhini-yu. I nanki kardu pana ngarra murrinh thathpi Yile neki nukunu numamnabath numpan-ka le da matha narninarelnu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Nuyemanh-ka mangini da weyi palyirr lurruth ngalla mani. Da ngarra kuy ngalla kathu pirrim-ka, neki warda thumarnarri ngarra weyi palyirr. Nukunu da matha mannhimanpinungime da ngarra thennham thurran kanhi mani-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Yile, panhingamardathin kathu ngarra ngay. Nhinhi-ka ngala thathpirr marda nangangert thurran ngay-yu i thirranganngipe thathpirr thanam ngala, nhini-ka nangimayerrarrnu ngarra mange wiye ngay mebaththa ngardi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Thirrangimaputh da mange wiye terert merithuktha ngardi i nangitarangkanu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ngay-ka the nganthin da mange wiye merithuktha ngardi-yu i kanamnginganawe da ngatha wurran ngarra mukmuk ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ngay-ka da mange ngarra nhinhi mere ngenhimariwaktha ngurri i nhinhi-ka damngimangkardu da mange wiye ngarra ngay merithuktha ngurrini-yu. I da-ka yuthpan da thathpirr nhinhi-ka mere le thinga ngay-yu. I da-ka nhini-ka yuthpan da-ya thurdungingkarelnu ngarra nhinhi kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ngay-ka da ngarra marra-re kathu bammat-ka kardu wiye da matha ngardidha ngay-yu. I da marra-re ngarra kale ngay kathu ngardinganamardadha-ka kardu wiye ngardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Mu nhinhi marda nanganart thim-ka kardu kardu-nu thathpirr ngurrunu, nhini nhinhi-ka Yile, da mange ngarra nhinhi da matha thangiwinhingkayithnu i dungiwerdinu ngarra mukmuk ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Nangimayerrarr da mange wiye thangunu medha ngardi i nhini ngay-ka tarangka warda ngurrunu. Nangimardatarangka da matha i nhini ngay-ka tarangka warda ngurrunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","I thangamutnu le thathpirr. Nhinhi-ka thamngimardarduy ngala da matha, nhini ngay-ka kardu wiyengi ngala da matha ngardidha-yu. Mu le thangamut i ngay-ka le deyida nganinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Thuyngimayekum warda da ngarra mange wiye medha ngardi-yu i thirrangimaputh warda da ngarra mange wiye merithuktha ngurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Yile, magulkul ngarra ngay-ka patha da matha nangimardatarangka, nhini ngay-ka bempayengkarnirnnu ngurru nhinhi da matha-nu, i murrinh ngarra nhinhi da matha ngay mampabathnu ngurru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Mu mere thurdungingkarel nukun ngarra nhinhi thangunu kathu-yu i mere nangimart nukun ngepan ngarra nhinhi ngarra ngay wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ngay-ka the nganthin nhinhi da matha namngiyibirnu-yu, mu thangamut deyida-nu nanhthi le-yu i nangimanpinu thurru murrinh ngarra nhinhi da matha mampabathnu ngurru. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","I nhini ngay-ka nganpinhingkayithnu warda ngurru da ngarra mange nhinhi-yu kardu pana-nu-yu ngarra da mange wiye pamam pumpan-yu i nhini kardu-ka purdimpawurlnu warda kathu ngarra nhinhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Yile, nhinhi da matha kardu namngiyibirnu-yu, mu nhini-ka mere thungibat nukun ngay-yu. Mu ngay-ka le da matha nganinu i kardu ngurdirrayithnu ngurru da mange yuthpan thathpirr nhinhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Pule, murrinh thangamut kathu-ya i nhini ngay-ka nganhiriparlnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Nhinhi-ka mere marda nart nanhthi kama ngampamutnu-yu i mange ngarra kama mampanu-ya, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Mu nhinhi marda nanganngert thim-ka murrinh ngarra nhinhi da matha mampabathnu ngurru i pangimardathinnu thathpirr da mange ngarra wiye medha ngurrini-ya. ");
INSERT INTO mwf2018_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Da ngarra tetemanthay i yitthitme thurran-ka murrinh thinangerren ngarra Nuyemanh. Ma da tetemanthay i yitthitme nhinhi-ka thaninapartnu Nuyemanh. Nukunu warda mayitnu nanhthi tetemanthay i nanhthi yitthitme nhinhi-yu, i kardu warda parnturtpan thani-nu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yile, nhinhi-ka thirrangannginhinhnhinh i the thathpirr thanthinngi. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Nhinhi-ka the namngibath ngarra ngay-re ngem-yu i ngarra ngay-re ngarrim-yu. I nhinhi-ka the-wa namngibath thim mukmuk ngay-yu da ngarra ngathparr kathu-yu thim-ya. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Nhinhi-ka thirranganngibath thim ngarra ngay ngurranwat-yu i ngarra ngay ngabimngurrkurrk-yu. Nhinhi-ka the thanthin thim mange terert ngarra ngay ngamam ngurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Nhinhi-ka the-wa thanthin ngarra murrinh ngamanu ngurru-yu ngarra murrinh mere da ngatha ngamanu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Yile, nhinhi-ka thirranganngipe thanam i namngiyit da matha thanam. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nhinhi-ka the-wa namngibath thim da pepe thathpirr-yu, i ngay-ka mere the manhibath da ngarra nhinhi mani-yu the nammath thurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ngarra wangu nimin ngunuwinhatnhinganamanu-yu ngarra Ngepan nhinhi kathu-yu? Nhini-ka manangka da warda mere ngarra ngunuwinhatnhinganama, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Da Heaven ngatha ngimardawithnu-ka nhinhi-ka pangu da matha thim. I ngununu ngatha ngi da ngarra kardu ngarra ngepan pibimpup thangunu-ka i pangu da nganinu ngadha nhini nhinhi-ka pangu deyida thim-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","I ngay mani ngunu ngatha ngi da ngathparr ngarra ngunga kathu pangarnturtuy pirrim i pangu ngatha wangu ngay ngunu ngi ngarra lalingkin langkarr-ya i nganinu ngatha pangu, ");
INSERT INTO mwf2018_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","nhinhi-ka pangu da matha warra thanam i nangiyitnu ngarra mange batbat nhinhi i thirrangipenu thani. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","I ngay mani ngurdunungath ngarra thipinhi mallu thathpirr-ka ");
INSERT INTO mwf2018_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","nhinhi-ka dangingkardu da ngatha-nu, nhini-ka da thipinhi mallu-ka da bere matha wangu dampalarrang dim nginipunh da ngunga deyida mani ngarra nhinhi-nu-yu. Da ngunga i da thipinhi-ka wurdamninthaweparl da matha nhinhi-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Nhinhi-ka namngiwatha ngay-yu ngala da matha i danngipak ngarra kale ngay marda nigunu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Yile, nhinhi-ka ngala thathpirr-wa i ngay-ka ngamnhiriparl nganam i namngimardat ngay-yu, nhinhi-ka namngingkalelunh ngala da matha ngay-yu. I da mange ngarra terert nhinhi nam thurran-ka murruwurlnhima ngala da matha nhinhi-yu. Ngay-ka the-wa nganthin. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Da marra-re ngarra kale ngay marda ngardinganamardadha i ngurdanarurturttha ngardi nhinhi da matha the nengibaththa thardi ngay-yu, mu kardu ngatha-ka wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Nhinhi-ka damngingkardu ngay-yu kardu mere da ngatha banabattha-yu. I nhinhi-ka tharntilil wardarra ngarra buk nhinhi da thangku numa thangku ngay nganibirnunu-yu kardu ngay mere da ngatha banabattha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","18","Yile, ngay-ka da tetemanthay bangamnhimardurt ngem-yu ngarra mukmuk terert nhinhi-yu. Ngay-ka mere ngarra ngunhimariwu mukmuk ngarra nhinhi-yu, nhini-ka nanhthi mukmuk-ka nginipunh darrimurn mani-wa nguriwu ngani-yu mu puy deyida wangu. Mu ngay ngatha ngunhimariwu mukmuk terert nhinhi-ka i ngarra marikerdeknu-re-ka nhini nhinhi-ka bere ngatha wangu thirrangipenu thani ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Yile, ngay marda manganart ngem kardu wiyenpun thunthuknu warda i marda manganart ngem kardu thu-wunma wunku parningipartnu warda ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Kardu nhini-ka murrinh wiye pumamnhirdarrithak parnam-ya i nhinhi murrinh wiye parnamnhirdarrikut parnam-ya. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Yile, ngay-ka mere thathpirr marda manart ngurru kardu pana ngarra mere marda kumanhert thathpirr kuru-yu i murrinh mere thathpirr kumayit kuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Yile, ngay-ka mere marda manart ngurru ngala thathpirr-yu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Yile, thirranginhinhnhinhnu i the nangimabathnu marda ngarra ngay. Thurdungithapnu i the nangimabathnu mukmuk ngay. ");
INSERT INTO mwf2018_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Dangimangkardu mani da mange wiye kama mammath ngurran. I bere matha wangu thunungangkanu thurru da mange ngarra nhinhi wangu i nhini ngay-ka bere matha wangu birnu nganinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Neki-ka mere nukun murrinh pumabath ngarra thubemkanirn thurran-yu. Ma puduyemitngime purru ngarra Yile neki da matha. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Murrinh kanhi-ka murrinh murntak i murrinh-ka murrinh nukunu Jonah-wa. Yile nukunu-ka murrinh-ka Amittai-wa. Nukunu Jonah-ka murrinh ngarra Yile neki nukun-wa wurdanarrayiththa wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Bere Yile neki-ka murrinh mamna ngarra Jonah-yu, “Thununu thi ngarra thelput terert pangu da ngamengka da nan Nineveh i kardu murrinh narranu da mange wiye da matha parnam da pangu-yu. I ngay-ka the-wa nganthinpun ngem kardu da mange wiye da matha parnam pangu-yu i kardu-ka ngay-re warda ngunmatnu-yu,” Yile neki kathu mamna-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Mu nukunu Jonah-ka mere murrinh menabaththa Yile neki-yu, wurda. Mu nukunu-ka dempinhirdarriparl mayern numi deyida wangu nadha dini i nuywinhattha-mana-wa-nintha ngarra Yile neki-yu. Nadha dini da ngarra nan Joppa da ngarra lalingkin manta. I ngana da tharntu bangarnurt. Tharntu nhini-ka mengkadha pirri da ngamengka-nu wangu da nan-nu Spain. I nukunu-ka ku mani pay mamna ngarra kardu pule ngala ngarra nanhthi tharntu nukun. I kanammardap warda nukunu Jonah-yu ngarra tharntu. Bere peneme kardu ngarra tharntu wurlk pumedhaneme punne-ka pumpankardurrneme da ngamengka-nu warda wangu da nan-nu Spain. I nukunu da wanku Jonah nuywinhattha-mana-wa-nintha ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Bere puy punnedhaneme. Mu Yile neki-ka nanhthi wirrirr ngala wurdanpirruthukneme i tharntu-ka nanhthi warda buywarntartadha. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Bere peneme kardu pana wurlk ngarra tharntu pumedhaneme punne-ka puninkungkawerrdha-warda-neme kardi i nhini-ka parderrukaykaydhaneme ngarra ku darrikardu ngepan peneme-nu pumankumanpinuneme nanhthi tharntu pumayibirnununeme. I nhini thangunu-ka pumemnungkuneme mange peneme, “Ya, nanhthi pirraputhneme nanhthi purrkpurrk nganaka-ya i nhini-ka parnturtparn warda purrunu.” I bere pibimkaputhneme nanhthi purrkpurrk-yu, i nhini-ka parnturtparn warda tharntu wurrinidha nhini-yu. Mu nukunu Jonah-ka yungurrkurrktha da ngatha ngurrnguwarl ngala pepe ngarra tharntu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","I kardu pule ngala ngarra tharntu nukunu-ka wurdanthut pangu pepe i bangarnurt Jonah-yu. I marnurt i mamna, “Ya, thangku-dha thibim kanhi-yu? Thewirnturt kathu i Pule ngala nhinhi nimin thaninakaykaynu manhimanpinemenu. Nukunu-ka panhemardathinnu-kama-neme i manhiyibirnu-kama-neme,” mamna nukunu nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Mu peneme nhini kathu-ka pumemnungkuneme, “Ya, nangkal-wa kardu kanhi-yu yungannhebangneme thu wirrirr ngala kanhi-yu?” Bere nanhthi pi warda pumangankakutneme mange murntak warra pumedhaneme punne. Nanhthi ngamere-ka nanhthi pangkuy pangkuy i nanhthi numi da matha-ka ngaliwe-wa. Bere nanhthi warda punginingkartpirtthaneme pe i nukunu da pi ngaliwe-yu manganart-yu Jonah da. I nhini-ka the warda panthinkaneme Jonah da yunganpirrubangneme-yu thu wirrirr ngala nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","I pumamna-warda-neme, “Nga, ngankuneme-ka ngunhirirda-mani-neme?” Pumamna-warda-neme ngarra nukunu Jonah-yu. “Thu wirrirr kanhi-ka nhinhi da matha nawa thunganngarrubangneme-yu? Thangku-nu thanam kanhi-yu ngarra tharntu kanhi-yu?” Pumamnaneme. “Nhinhi-ka kardu ngarra-dha kathu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Mu nukunu kathu-ka mampirruneme, “Ngay-ka kardu Hebrew-wa,” mam nukunu-yu. “I Pule ngala ngay-ka dhi-wa kathu dim kangkarl. I nukunu-ka mampatha da putek kanhi i lalingkin kanhi,” mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","“I ngay-ka ngunuwinhattha-mana-wa-nintha ngarra Pule ngala ngay kathu-yu.” Bere peneme-ka perrananhamtha-warda-neme parde ngarra wirrirr ngala pangu thangunu-ya i ngarra Pule ngala Jonah nukunu. I pumamnaneme, “Ya, nhini-ka da mange wiye-wa nam nhinhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Mu thu wirrirr deyida kathu-ka puy deyida kathu dimpuyit lurruth. I pumamna-deyida-neme peneme-yu, “Ngarra-re ngiyemanuneme ngankuneme-yu ngarra thu wirrirr kanhi madhapnu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Mu nukunu Jonah kathu-ka mampirruneme, “Nga, nunnengikununeme ngarra lalingkin i nhini-ka thu wirrirr kanhi-ka madhapnu warda i da watmam deyida pirranu. Ngay da matha ngungannarrubangneme thu wirrirr ngala kanhi-yu. Ngay da matha mere murrinh menabaththa Pule ngala ngay-yu i nhini-ka thu wirrirr ngala kanhi wurdannhethukneme-yu,” mampirruneme nukunu Jonah kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Mu peneme nhini-ka mere punnekudhaneme ngarra lalingkin wangu nukunu Jonah-yu, wurda. Nhini-ka puyemkangurruka-da-matha-neme. Puddankathapneme da matha puyemkangurruka-mana-wa-neme da ngarra pangkin-nu-yu. Mu wurda, puddamkabay-da-matha-neme ngala. Mu thu wirrirr-ka puy wurrinidha thu lurruth deyida kathu dimpuyit. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Bere peneme nhini-ka pumamnaneme ngarra Pule ngala Jonah nukunu wangu-yu, “Nukunu Jonah ngatha ngunnakununeme i payiwiknu-ka nhinhi-ka mere nukun thungankubatneme i thurdungankurinumineme,” pumamnaneme ngarra Pule ngala Jonah nukunu-yu. “Mu nhinhi nimin thurdanngarruthukneme thu wirrirr ngala kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Bere kardu-ka nukunu Jonah-ka pumangankabertneme i punnungamkakuneme ngarra lalingkin warda wangu. I nhini thangunu-ka thu wirrirr-ka manthap warda nhini-yu i da watmam warda pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","I peneme nhini-ka perranamanhamtha-warda-neme parde ngarra Yile neki-yu. I da nakurl-te-wa ku puliki warda pumpannabatneme ku pinnangamnapekneme Yile neki-nu-yu nhini nukunu thangunu weyida mampunkuyibirnuneme-yu. Nhini-wa murrinh-yu pamamnaneme ngarra Yile neki da ngarra marra-re kathu ngarra wirrirr ngala pantet-yu. I mange-ka kanhi da pumamkaneme kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Bere ngarra nukunu-re Jonah punnungamkakuneme-ka ngarra lalingkin-ya Yile neki-ka ku ngurlmirl ngala wurdannathuk dinthuduth nukunu Jonah-yu. Mu kardu-ka birnu-wa kardidha ngarra marda ku ngurlmirl. I da-ka perrkenkuneme-wa kardidha-yu ngarra marda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Bere ngarra ku ngurlmirl ngala kardinganamardadha-ka nukunu Jonah-ka murrinh kardinangerrentha ngarra Pule ngala nukunu warda wangu Yile neki-ya. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","I menadha kardi, “Ngay-ka mere menanumanpidha ngani ngay ngatha-yu, wurda. Mu ngay-ka nganampakay ngarra nhinhi. I nhinhi-ka thamngidhart i namngimanpi. I ngay-ka ngungipuptha warda-wa i ngardimpakaykay-deyida-dha ngarra kura pewerti thangunu kathu, i nhinhi-ka dimngayepup warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","I nhinhi-ka thunungamngiku ngarra kura pewerti ngarra da lalingkin marda nganangurr. Bere lalingkin-ka da pana ngangka-ya nanhthi lalingkin da matha. I nanhthi ngurntinh da matha ngarra thurdanthuk-ka daningiwetuttha wurrini nanhthi ngala ngala da matha. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","I ngay-ka memnu, ‘Aa, mere ngurdimpawurlnu i da thelput ngala nhini-ka mere warda bangkardunu deyida thelput patha nhinhi ngarra ngarnampangerren-ya,’ memnu mange ngay marda-re. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","“I kardu-ka damngiyiwik warda nhini-yu. Lalingkin ngardithurduthurduththa i daningiyikiktha kardi. Kura lalingkin-ka da pana ngangka-ya ngala da matha. Nanhthi kurrugurruk ngarra pelpith-yu panngiweral i puningiwekarldha kardi nanhthi kurrugurruk i nanhthi mimpi. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","“Bere puy ngurrinidha ngarra da pewerti thathpirr da palyirr ngala pepe kura pewerti puy ngurrinidha. Ngay-ka mamngingkat i kardu ngungipuptha warda-wa pangu-yu. Mu nhinhi-ka thanthinngimardawith deyida ngarra da kura pewerti pangu kathu-yu. Nhinhi Pule ngala ngay namngiyibirnu. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Kardu ngingamnuthap ngungipuptha warda-wa, mu ngay-ka ngardimpakaykay-deyida-dha i nhinhi-ka dimngayepup da ngarra nhinhi thangunu kathu thim da patha nimin-ya. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","“Bere kardu ngamere-ka puddampirrayemit pumpan-ka ku ngepan ngarra darrikardu pigunu, mu nhinhi-ka parnamnhipart i mere kuddumpayemit warda kuru. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Mu ngay-ka nganhiriparlnu ngani nanhthi thamarl ngarra ngay-re nganimparelnu. I ku puliki ngumpabatnu ngarra murrinh nhinhi mampa-ya marra-re-ya ngumpabatnu. Nhinhi da matha mani kardu nanthibirnu-yu.” Bere murrinh damnarikerdek nukunu Jonah ngarra Yile neki kardinangerrentha-yu ngarra ku ngurlmirl ngala nhini kardinganamardadha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Bere nhini thangunu Yile neki-ka ku ngurlmirl ngala nhini wurdanthuk ngarra nukunu warda Jonah pibenu ngarra pangkin darrimurn-ya nhini da-yu. I bere ku ngurlmirl nhini-ka dimme warda nukunu Jonah-yu ngarra darrimurn da pangkin thathpirr warda. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Bere nhini thangunu Yile neki-ka murrinh deyida mamna ngarra Jonah-yu, ");
INSERT INTO mwf2018_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Thununu thi da Nineveh deyida wangu ngarra thelput terert pangu-ya. I kardu narranu murrinh ngarra mampa marra-re-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","I bere nukunu Jonah-ka murrinh mamnabath Yile neki-yu i nadha dini puy da Nineveh-nu warda wangu. Bere da-ka Nineveh-ka da ngala nimin-ya da thelput manta manta benaletettha wurrini. I da nhini punulili pi marda nganangurr yuthpan-ka da-ka nginipunh perrkenkuneme mani-wa punirrit pi-yu. Nginipunh nhini mani-wa da Nineveh pangu medha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Bere ngarra nukunu Jonah pangarntuy mana da nhini-ka i bere pantet warda wurrinililidha. Wurrinililidha da numi kanawit nhini-yu. I thipinhire nhini-wa murrinh warda pantet-yu murrinh warda merradha wurrini, “Nga kardu, nubingayepup kathu murrinh kanhi-yu. Da merrk numi i kanganu pinthabardinu-ka Pule ngala Yile neki punanmatnu warda nhini-yu i thelput wanku bunanmapeknu purru.” Murrinh nginipunh kanhi mani-wa merradha wurrini nukunu Jonah-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","I kardu-ka murrinh thathpirr warda kanampunmardardi murrinh Yile neki-yu murrinh ngarra nukunu Jonah merradha wurrini-yu. Bere mi warda parnampart mi dhepdhep mere parnimurrktha warda. I pubanardurdidha punni nanhthi kaligu wurdurdulkmam warda nhini-ka dampunmardathin warda da ngarra mange wiye pumedha pardi-yu. Kardu wurnangat warda ngatha pubanardurdidha punni nanhthi kaligu wurdurdulkmam da matha i kardu pule ngala ngala-ya i kardu kanganu pardingkadhuktha-ya. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Mu kardu pule ngala thathpirr da ngarra nhini dinirradha-ka murrinh pamnayepup ngarra nukunu Jonah murrinh nhini wurdanarrayiththa wurrini-yu. I pampirrayepup kardu wurnangat mange nhini pumedha punni-yu. Bere nhini thangunu weyida nukunu kardu pule ngala thathpirr warda-ka dempirnturt ngarra da chair ngala ngarra nukunu kathu kardipuptha-yu i yunganpirt nanhthi kaligu patha i bardi nanhthi kaligu nanhthi wurdurdulkmam warda. I kanawup ngarra nanhthi nguwurt mulurnu-ya. Nhini-ka nukunu deyida wanku dammardathin da mange wiye medha kardi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","I nhini thangunu nukunu-ka murrinh warda darntilil i kardu wanku wurdanpunkuthukneme pumebaththaneme tharra murrinh nhini-yu ngarra kardu wurnangat-nu warda wangu punnedhaneme. I murrinh-ka kanhi-wa mam kardu pule ngala thathpirr darntilil-yu. “Nga kardu, murrinh kanhi-ka ngarra kardu ngala thathpirr ngemnarra nanki thangunu kanhi-yu i kardu ngala ngala ngamere deyida-re. Murrinh kanhi-ka the da matha numabathnu. Bere nga, mere nangkal nukun kanimurrk mi-yu i mere nangkal nukun kura kanigurdugurduk. I ngana deyida ku puliki i ku thip i ku nenigut i ku terert warda ngatha mi parnu mere kawekat nukun karni. I kura mere kurugurdugurduk nukun. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","I kardu wurnangat warda ngatha nanhthi nubuyrdurdinu nanhthi kaligu wurdurdulkmam da matha i ngana deyida ku wurnangat warda ngatha-ka nubunnurdurdinu nanhthi kaligu wurdurdulkmam da ngatha. I murrinh-ka murrinh yuthpan thathpirr-wa numananu nuddinayithnu ngarra Pule ngala Yile neki-yu. I narnipartnu warda da mange wiye pana-yu i mere nuntithuk nukun thu kuy ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","I nhini Pule ngala Yile neki-ka mukmuk-ka purdurduynu kama-ya i nhini-ka mere warda pinamardakatnu pi. I mere kama punhibatnungime i mere kama purdunhirinuminuminungime nhini-yu.” Nhini-wa murrinh-yu ngarra kardu pule ngala thathpirr mampirra ngarra da pigunu-yu da pangu da Nineveh. ");
INSERT INTO mwf2018_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Bere ngarra Yile neki bampunmangkardu mange pangu pumedha pardi-ka i mange wiye parnampart-ka nhini nukunu-ka mukmuk-ka wurdannurduy da thathpirr nhini-yu. I mere warda puynmattha wurdintinumidha da pangu Nineveh-yu i mere buynmapektha warda thelput-yu ngarra murrinh marra-re nukunu Jonah merradha wurrini murrinh Yile neki-yu ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Bere Yile neki-ka mukmuk wurdannurduy i mere warda puynmattha kardu pangu-yu. I nukunu Jonah-ka kardu denamardarurrdha warda kardi i kardu ningamardakattha warda kardi mere wanku puynmattha kardu ngarra da Nineveh-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Bere nhini nukunu Jonah kathu-ka mamna Yile neki-yu, “Pule, ngay-ka kardu the menhibaththa ngurrini da marra-re mange kanhi nam-yu da pangu da ngarra ngay da wangu. Nhini weyida ngay pana nguniwinhattha-mana-wa ngay-yu da ngathparr wangu-yu da nan-ya Spain. I ngay-ka the-wa nganthin nhinhi-ka Pule ngala kardu wurnangat warda ngatha marda-wa thathpirr nanganpunart thurran-yu. I thirranganpunpe thanam-yu i nampunmanpi thanam-yu. I nhinhi-ka kardu thanthanka thanam i kardu murlmurl thanam i mange patha da matha thanampirra ngarra kardu-yu. Mu kardu ngatha da mange wiye parnipartnu-ka i murrinh ngarra nhinhi pumampabathnu thathpirr-ka nhinhi-ka mukmuk-ka thurdurduynu warda i mere warda thunmatnu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Mu marra kanhi-ka ngay warda thungibatnu i thurdungirinuminu. Nhini-ka patha-wa nhini-yu ngay ngupupnu-yu. Birnu-ka mere marda mart,” nukunu Jonah kathu mamna ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Bere Yile neki kathu-ka mamna ngarra Jonah-yu, “Nhinhi-ka mere nukun kinanhimardakat kani.” ");
INSERT INTO mwf2018_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Bere nukunu Jonah-ka yungawuy warda da ngarra thelput terert nhini-yu da Nineveh-yu. I nadha dini pangu wangu i kanawup da manta da ngatha ngarra thelput nhini-yu da ngarra ngunga kathu pangarnturtuy wurran. I mulurn dawup i kanawup ngarra mulurn da. Bere dinimardamardadha i diniyekattha warda ngarra pamanu Yile neki da pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Bere Yile neki-ka nanhthi thay mulurn mampatha i bannapak Jonah-nu. Wurdarnturturt mere pirdith i dampet. I nhini-ka ngarra thay mulurn warda bengkaburrdha dini. Nukunu Jonah-ka le warda dinidha nanhthi mulurn pangu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Bere da thipinhire nhini da pankapurl mana warda manta-ka Yile neki-ka wurdanthuk ku ngurrmu nanhthi mulurn-nu pamarikerdeknu. I bere demkawath warda nanhthi thay mulurn ngarra Jonah dinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Bere da ngunga numi thipinhire da ngatha da pankapurl nhini-ka Yile neki-ka wurdannathuk nanhthi wirrirr dernturr ngarra ngunga kathu pangarnturtuy wurran-yu. I nukunu Jonah-ka demperurr warda ngarra pelpith-yu i kardu denaralaldha warda-wa. I murrinh memnu marda-re, “Ngay-ka marda manganart ngupupnu warda. Nhini-ka patha-wa nhini-yu ngupupnu-yu mere nganibirnu nukun.” ");
INSERT INTO mwf2018_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Bere Yile neki kathu-ka mamna, “Nhini-ka mange patha pana-yu nam-yu kinangamnhimardakat kem ngarra thay mulurn-te thangunu demkawath pana ngarra nhinhi-yu?” “Yu,” mamna Jonah kathu-yu. “Nhini-ka patha-wa nhini-yu ngay ningamngimardakat dim-yu. Ngay-ka ningamngimardakat thathpirr dim nhini-ka ngay-ka marda warda manganart ngem ngupupnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Bere Yile neki kathu-ka mamna, “Nhinhi-ka damnhinamardathin dim nanhthi thay mulurn-nu ngarra demkawath-te-yu. Mu nhinhi-ka nanhthi-ka mere newathadha-wa i mere thurdirurturttha i mere thirrangipedha thani nanhthi mulurn pana-yu. Nanhthi thay mulurn-ka da thipinhi numi da matha pangarntuy-yu. I da numi pirridha i thipinhire nhini weyida pankapurl mana warda manta-ka demkawath warda. ");
INSERT INTO mwf2018_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Mange nginipunh nhini mani damnhinamardathin dim nanhthi mulurn-nu, ngay-ka nginipunh nhini deyida mani damngimpirramardathin dim kardu pangu-nu-yu ngarra da Nineveh-yu. I mange patha-wa nhini-yu damngimpirramardathin dim kardu pangu-nu-yu. Da pangu-ka kardu mamay wurnangat-wa parnam i mange wiye i mange patha-ka mere ngatha the kumabath, wurda da ngatha. Kardu mere thapath pangu kardu mamay-yu, kardu wurnangat nimin-ya pangu-yu 120,000, i ku wanku parnam ku wurnangat-yu.” Bere murrinh-yu Yile neki kathu ngarra Jonah dininangerrentha-yu damnarikerdek warda-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Murrinh kanhi-ka murrinh ngarra Jesus Christ-te bammat. Bere da ngarra marra-re kathu-ka kale nukunu Jesus Mary-ya, kardu niyeniye nukunu Joseph. Mu kardu peningintha-ka kardu mere da ngatha benanginthalettha ngarra nigunu-re Mary-ka the warda mebaththa wurrini kardu marda wurrinidha-yu. Nhini-ka Ngepan Yile neki thangunu weyida nigunu-yu damngemut kardu marda pangu kardidha warda-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mu nukunu Joseph-ka mam mana-wa, nigunu Mary-ka kardu nugarn numi thangunu mana-wa kardu marda pangu wurrinidha-yu. Bere nukunu Joseph-ka kardu patha-wa kardidha-yu i murrinh law kardu ngarra Jews nukunu daninmariwaktha wurrini. I nhini-ka murrinh nginipunh kanhi mani-wa memnu murrinh mange nukunu ngatha-yu, “Ngay-ka mere murrinh nukun marra kardu ngarra terert wangu-yu nigunu Mary kardu putput kurran pangu-yu. Mu ngay-ka murrinh thawath da matha marrunungime ngarra kardu darrikardu nigunu, i nhini-ka menginthardarrarrnu ngurru i mere warda benginthalet nukun.” ");
INSERT INTO mwf2018_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mu bere, ngarra mukmuk nhini-re benayengkarnirntha dini-ka ku angel ngarra Yile neki thangunu kathu pangamnaruy ngarra nukunu da, da ngarra nirn-te yudha. I murrinh mamna, “Joseph, nhinhi-ka kardu tharntethbath thathpirr thurran ngarra King David thangunu kathu. Mu nga. Mere nukun yidiwe thaninge ngarra nigunu Mary-yu, mu kardu bere matha wangu denginthaletnu thani. Nigunu kardu putput pana kanam-ka ngarra Ngepan Yile neki thangunu kathu damngemut wakal pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nigunu-ka kardu wakal nugarn-wa buyngebatnu-yu i nhinhi-ka murrinh thuparlnu-ka nan-wa Jesus, nhini nukunu-ka kardu pirranmaputhnu purru da ngarra wiye pumammath parnam kardu darrikardu nukunu kardu Jews-ya. I nhini nukunu-ka da mange wiye pirrinmaputhnu ngarra kardu wurnangat thangunu kathu, i kardu warda manthibirnunu purru.” Ku angel nhini kathu-yu mamna ngarra Joseph. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Bere da murntak nhini warra-ka Yile neki kathu murrinh mamna ngarra ku prophet nukunu. I murrinh-ka kanhi-wa mamna, “Nga. Kardu mardinhpuy manangka nangkun paningenu kardu putput paninu-yu, da nakurlnu-wa. I wakal-ka nugarn-wa buyngebatnu-yu. I murrinh nukunu-ka nan-wa Immanuel.” Murrinh kanhi-wa-nu, “Yile neki-ka kanhi-wa dim ngarra nekingime.” I bere da nhini-re ngarra nigunu Mary putput kardidha warda-ka, murrinh nhini ngarra Yile neki thangunu kathu ngarra ku prophet nukunu mamna da murntak warra-ka, murrinh nhini-ka murrinh da thathpirr nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bere ngarra nukunu thangunu Joseph bangamnirn ngarra yungurrkurrktha-ka, kardu warda dempirnturt i murrinh warda mamnabath ku angel mamna-yu. I nhini nukunu Joseph-ka kardu warda manganmert nigunu Mary-yu i kardu warda bamnginthamardi nigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mu peningintha-ka mere da ngatha kaningintharrittha da-yu, mu da ngarra wakal nugarn-te warda bampirrubatngintha. I kardu wakal nugarn nhini-ka Joseph murrinh panparl-ka nukunu-wa Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bere, ngarra nukunu-re Jesus bammat da ngarra Bethlehem-ka, nukunu Hered-ka ku pule ngala dinirradha pangu-yu da nan-ya Judea. Da Bethlehem nhini-ka ngarra da ngala nhini Judea pirrimpirra. Bere kardu nugarn ngamere parramkaruyneme pangu da da nan Jerusalem. Peneme nhini-ka da pangu thangunu kathu punnadhaneme-yu ngarra da ngunga kathu pangarnturtuy wurran. I peneme-ka bere matha wangu nanhthi pilinh pirabaththaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bere peneme nhini-ka murrinh warda pumerradha pardi kardu pana ngarra da Jerusalem pardidha-ya, “Ya. Ngarra wangu da-yu ngarra kardu wakal nugarn nhini bammat-yu, kardu wakal pana ngarra kardu Pule ngala pinarranu-yu ngarra kardu Jews-yu?” Parrinintharrpudha-yu. “Ngankuneme-ka ngubamkangkarduneme nanhthi pilinh nukunu pangu thangunu kathu-ya ngarra ngunga kathu pangarnturtuy wurran-yu. I nhini ngankuneme-ka the warda nganthinkaneme nukunu bammat wardarra-yu, wakal nugarn pana-ya ngarra kardu Pule ngala pinarranu-yu ngarra kardu Jews nukun-ya. I ngankuneme kanhi da ngunnadhaneme-yu nukunu-nu ngubangkardunemenu i ngenawinhipingkarlnemenu-yu.” Murrinh nhini-wa murrinh pumerrudhaneme parde peneme nhini kathu-yu ngarra kardu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bere ngarra nukunu-re pule Hered panthepup murrinh nhini-ka, nukunu-ka kardu puniyengkawerrdha warda kardi i kardu wurnangat pangu deyida wanku ngarra da Jerusalem pardingkadhuktha. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bere nukunu Hered-ka dimpirrakay warda ku yilarn ngala ngala i kardu pana ngarra puddininthethiththa purni murrinh law ngarra kardu Jews nukun. I mampirra, “Ya. Ngarra mani wangu nukunu Christ buybatnu-yu, kardu nugarn pana ngarra Yile neki mam da murntak warra purduthuknu-yu ku Pule ngala-nu pinarranu ngarra kardu Jews-yu?” Dampunkudharrpuneme nukunu kathu Hered-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","I peneme kathu-ka pumamnaneme, “Ya. Da pana wangu da nan-ya Bethlehem ngarra da pirrimpirra-ya Judea. I kanhi-wa murrinh mam ku prophet-yu da murntak warra-yu, murrinh ngarra Yile neki thangunu-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nga, kardu ngarra da Bethlehem narnam da ngarra ngala pirrimnarra Judea. Da nanki-ka da mere warda pirranarranu-yu da kunungingki, nhini-ka kardu Pule ngala buynarrabatnu da pangu Bethlehem-yu. I nukunu-wa kardu kumparra purrunarranu i pirrananpenu pani-yu kardu ngarra ngay-yu kardu ngarra narrarntethbath ngarra nukunu Israel thangunu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bere nhini thangunu nukunu Hered-ka dimpirrukayneme murrinh dederrk-nu kardu peneme ngamere pana ngarra nanhthi pilinh nhini pubamkangkarduneme i mampirruneme, “Ya peneme. Minthire nankuneme pana-yu nubamkangkarduneme nanhthi pilinh nhini da marra-re kathu-yu?” I peneme kathu murrinh pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I ngana deyida mampirruneme, “Nga. Narnu-warda-neme da pangu nan Bethlehem i niranawinhadhathnemenu kardu wakal nugarn nhini-nu i ngarra nubardurt-da-nu-mana-neme. I murrinh-ka nuddungangkarlnu-kathu-neme i kanhi deyida ngarra ngay ngem. I nhini ngay-ka pana deyida ngurrunanu warda wangu i bangkardunu kardu wakal nugarn nhini-yu i ngenawinhipingkarlnu i ngariparlnu warda nukunu-yu.” Nhini-wa mampirruneme nukunu Hered kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Bere murrinh nhini thangunu peneme nhini-ka punnungamkardurr-warda-neme i puy punnadhaneme da Bethlehem-nu warda wangu. Mu ngarra peneme-re punnadhaneme-ka nanhthi pilinh nhini da ngatha da ngarra marra-re pubamkangkarduneme-ka pangu warra kumparra wurrinirrudhaneme ngarra peneme. I peneme-ka parraneriwaktha-warda-neme purne da Bethlehem-nu wangu, i le patha nimin-ya punnadhaneme. Bere nanhthi pilinh nhini-ka puy wurrinidha i pirret i pirringanawedha pangu kathu da kangkarl ngarra thelput nhini da ngarra kardu wakal nugarn nhini kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bere nhini thangunu-ka peneme nhini-ka parnamkardi-warda-neme ngarra thelput nhini da i pubamkangkarduneme kardu wakal nugarn nhini-yu wunku kale nukunu Mary-ya. I perremnawinhipingkarlneme i parramkariparlneme mange pana mani ngarra pule ngala pumerradha purni. I ngarra nanhthi bag ngarra peneme-ka pumamkadharlurlneme i parramnamutmutneme nanhthi gold nanhthi mani-ya, i nanhthi tulurulumam nanhthi kangunu patha, i nanhthi nginipunh maminanh mani kangunu patha. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bere nhini thangunu Yile neki kathu-ka mampirruneme ngarra peneme nhini ngarra da nirn-te, “Nga. Mere nukun nuddewurlneme pangu wangu ngarra Hered-yu i mere numana-nukun-neme ngarra wangu da nukunu kanam.” Bere peneme nhini-ka perremkawirnturtneme i puddamkawurlneme ngarra da peneme-nu warda wangu da mayern numi deyida-nu wangu punnadhaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bere ngarra peneme thangunu punnungamkardurrneme-ka ku angel ngarra Yile neki thangunu kathu pangamnaruy ngarra Joseph da nirn-te. I murrinh mamna, “Ya, wurr thewirnturt. Kardu wakal nugarn pana i kalekale nankubertinu-warda-ngintha ngarra da ngamengka-nu warda wangu ngarra da nan Egypt. Nukunu Hered-ka pirranawinhadhathnu pani da pana ngangka-re-wa wakal nugarn nhinhi-nu thu pubatnu-yu. Mu nunnardurr-warda-ngime i pirtpirt da matha nunnanungime. I pangu da matha narnengimenu da nan Egypt i murrinh ngarra ngay da mana manarrunungime nuddewurlnungime kanhi deyida kathu-yu.” Ku angel-te kathu-yu mamna ngarra Joseph. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bere da thipinhi nhini da ngatha nukunu Joseph-ka dempirnturt i wakal nugarn pana i kalekale mampunkubertngintha i pumpankardurr-warda-ngime da nan-nu warda wangu Egypt. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","I pangu da ngadha pardedhangime i ngarra nukunu da mana Hered yibimpup. I murrinh nhini Yile neki thangunu kathu yunangurrkurrktha da murntak warra-ka murrinh da thathpirr nhini-yu ngarra ku prophet nukunu-dha warra mamna-yu, “Ngay-ka ngirranakaynu wakal nugarn ngarra ngay pangu thangunu kathu purrunu da Egypt.” ");
INSERT INTO mwf2018_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bere peneme nhini kardu ngarra nanhthi pilinh pirabaththaneme parde puddamkawurlneme da ngarra peneme-nu-ka da mayern numi deyida-re punnadhaneme i mere murrinh puddinangkarldhaneme ngarra nukunu wangu Hered-yu. Bere ngarra nukunu-re Hered pampirruyepupneme peneme-ka pangu wardarra puddamkawurlneme-ka, nukunu-ka kardu warda darntithi ngala da matha nhini-yu, nhini peneme-ka parramnayirrarartneme nhini-yu. Bere nukunu Hered-ka ku soldier ngarra nukunu warda wurdanpunthuk kardu thu-nu warda punthuknu puru kardu mamay nugarn kardu pana-ya ngarra kardu thangku numi i kardu thangku perrkenku-ya, da nan warda wangu Bethlehem i da town purrkpurrk pangu da ngatha. Bere Hered-ka memnu mange nukunu, “Ngay mani ngunthuknu ngurru kardu mamay nugarn nhini mani ngatha-ka ngay-ka ngubatnu mani warda kardu wakal nugarn pana ngarra ku Pule ngala ngarra kardu Jews pirranu-yu. Nhini kardu peneme pana ngarra nanhthi pilinh pirabaththaneme purne-ka murrinh pumamnganeme da ngarra marra-re pubamkangkarduneme ngarra pilinh ngarra nukunu da thangku perrkenku-dha warra-ya,” memnu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","I nhini murrinh ngarra nukunu ku prophet Jeremiah mam wardarra-ka murrinh nhini-ka murrinh da thathpirr nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","I kanhi-wa murrinh mam nukunu Jeremiah-yu, “Nga. Nubiyepupnu nanhthi du ngala da matha da nan thangunu kathu Ramah. Kardu kalekale pana ngarra parrarntethbath kardu kunugunu pana nan thangunu Rachel, parnamkarrk i dampunmardathin dim ngala da matha. Peningime-ka parnamkakarrkngime kardu wakal peningime-nu. I peningime-ka mere ngarra nukun kumadhapngime du-yu, nhini kardu wakal wurnangat peningime-ka kardu makardu warda thu thangunu punninthuktha warda purni nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bere nhini thangunu ngarra nukunu Hered yibimpup-ka ku angel ngarra Yile neki thangunu kathu pangamnaruy deyida ngarra nukunu Joseph-yu da nirn da ngatha-re da pangu wangu-yu Egypt. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","I murrinh mamna deyida, “Ya Joseph, wurr thewirnturt. Kardu wakal nugarn pana i kalekale thurdunkungkarl-deyida-ngintha pangu deyida da nan Israel. Kardu pana ngarra marda merttha wurrini thu puybattha kardu wakal nugarn nankungintha-ka, nukunu kardu nhini-ka yibimpup warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bere nukunu Joseph-ka dempirnturt i mampunkubertngintha wakal i kalekale i puddamkawurlngime pangu deyida da nan Israel. ");
INSERT INTO mwf2018_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mu nukunu Joseph-ka pamnayepup warda nukunu nan Archelaus wakal nukunu nan Hered ku pule ngala warda dinirradha ngarra da Judea-yu. I nukunu Joseph-ka demmanham warda nhini-yu i mere warda ngarra parnewupthangime da nhini-yu. Mu Yile neki kathu-ka mamna deyida ngarra da nirn-te, “Ya. Da pangu wangu nimin narnungime Kelili i narnepupnungime pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bere peningime-ka punnadha-warda-ngime da nan-nu warda wangu Kelili i pangu da pardedhangime da ngarra nan-ya Nazareth. I murrinh nhini Yile neki nukunu yunangurrkurrktha da murntak warra-ka murrinh-ka murrinh da thathpirr nhini-yu ngarra ku prophet wardarra piyemam-yu, “Kardu nukunu nhini-ka kardu Nazareth-mawu-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bere nhini thangunu-ka John the Baptist nadha dini ngarra da darrinpirr pularn, da ngarra nan-ya Judea. Nukunu-ka murrinh ngarra Yile neki thangunu kathu wurdanarrayiththa wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","I kanhi-wa murrinh merradha wurrini-yu, “Ya kardu. Pananmardathinnu warda thathpirr da mange wiye nhini thangunu nanthin numpan-yu, i narnipartnu warda nhini-yu. Mu da-ka manta warda wurran kathu-yu ngarra Yile neki-re ku Pule ngala thathpirr warda pinarranu ngarra kardu wurnangat warda ngatha-yu.” Nhini-wa murrinh merradha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bere nukunu ku prophet nan-ya Isaiah murrinh darntilil da murntak warra-ya, kardu-ka nukunu John the Baptist da matha-nu kurrunu kathu-yu. I kanhi-wa murrinh mam-yu, “Kardu nugarn panirrakaykaynu ngarra da darrinpirr pularn ngarra kardu-nu wangu, murrinh kanhi-nu-ya. ‘Ya. Kardu Pule ngala-ka tiduk kathu purrunu, nhini-ka da mayern numanawathawathanu nukunu nhini-nu, da mayern yuthpan nubunayithithnu.’” Murrinh nhini-wa nukunu Isaiah darntilil da murntak warra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bere nukunu John the Baptist banardurdidha wurrini-ka nanhthi kaligu mampatha ku nan thangunu pemarr ngarra ku camel. I nanhthi belk menarlarlarrdha wurrini-ka nanhthi leather ku darripi-wa. I ku-ka wurrinimurrktha-ka ku thalarrithay i ku thithay. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bere kardu wurnangat warda ngatha da nan thangunu kathu Jerusalem i Judea i manta ngangka da kathu ngarra kura ngipilinh ngala da nan-ya Jordan punninadha kathu ngarra John the Baptist-nu. I murrinh ngarra nukunu pubinanayepuptha pardi. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I kardu-ka daninmardathintha warda kardi i puddininayiththa pardi ngarra Yile neki-nu wangu da mange wiye nhini ngarra pumebaththa pardi-yu. I nukunu nhini John the Baptist-ka kardu daninluluwewudha warda wurrini ngarra kura ngipilinh ngala nhini Jordan-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bere kardu ngalantharr pana nan-ya Pharisees i Sadducees punninadha ngarra nukunu-nu John the Baptist kardu panluluwewunu pirra. Mu John the Baptist bampunkardu i mampirra kathu, “Ya. Nanki-ka nginipunh ku pangkuy murlak mani. Nanki kanhi nunningadha-ka ngay-nu ngananluluwewunu ngirra i nhini Yile neki-ka mere punanmatnu warda nhini-yu. Mu nhini-ka manangka mange-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nanki-ka da mange wiye da ngatha numammath numpan. Mu marra-re nanki-ka narnipart-wa-nu da mange wiye nhini-yu mu da mange patha da matha numabathnu nuru i nhini kardu-ka the warda pumananmathnu da mange wiye nhini thangunu narnipartnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","I nga. Mere nubeyengkarnirn nuru Yile neki le dimnarra-yu nhini nanki-ka kardu narrarntethbath kardu ngalantharr pana Abraham. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Ya,” mampirra. “The mana nanthin-ya thay mi dhepdhep-yu. Nanhthi thay mi dhepdhep mani mi wiye kinthatut-ka nhini kardu mani-ka lithpurr kukangkat ngarra thay ngimalmin pepe kathu i kinapek ngarra thungku. I nginipunh nhini deyida mani nanki-yu numamyit numpan da mange wiye. I nhini Yile neki-ka punanmatnu i pirrananputhnu ngarra thungku ngala wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mu John the Baptist kathu-ka mampirra, “Ya. Ngay-ka kardu mere pule ngala kanhi-yu. Mu kardu pana ngarra tiduk kathu pununu pi-ka nukunu nimin kardu Pule ngala thathpirr-yu. Ngay-ka mere mani ngurdimerereth ngarra me sandal nukunu-yu. Nhini-ka ngay-ka wurdanngiwerdi ngemmanham-wa nhini-yu. Nhini nukunu-ka kardu Pule ngala thathpirr warda nhini-yu. Ngay-ka berengunh nganinanluluwewudha ngurrini kura patha da matha-re nhini-ka da mange wiye narnampart warda, mu nukunu nhini-ka bunannginirdinu Ngepan ngarra Yile neki-yu. I ku Ngepan nhini-ka nginipunh thungku deyida mani i pinananmapeknu purru da ngarra mange wiye nanki wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“I nga,” John the Baptist kathu-yu mampirra deyida. “The mana nanthin-ya mi-ya i da mange ngarra mi pumamyerryerr pumpan-yu-ya nanhthi darripi ngernu i mi kamarl thathpirr-ya. I nhini thangunu-ka parnammardawu ngarra nanhthi pot i panthin ngadha pirrim. Mu darripi ngernu-ka pinnangampek pangu wangu ngarra thungku. I bere kardu pana ngarra tiduk kathu pununu pi-ka kardu-ka nginipunh ku gardener nhini mani-wa. Nukunu-ka kardu manyerryerrnu purru kardu patha i kardu wiye. I kardu pana ngarra da mange wiye panthin pumpan-ka pirranputhnu ngarra thungku ngala wangu, thungku nhini mere ngarra ngadha kingkan,” nukunu John the Baptist kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bere nhini thangunu nukunu Jesus-ka nadha dini da nan thangunu kathu Kelili da kura ngipilinh ngala pangu da-nu, da nan-ya Jordan, kardu nukunu-re John the Baptist paluwewunu ngarra kura ngipilinh ngala nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mu nukunu John the Baptist kathu-ka mamna ngarra Jesus, “Awu, nhinhi-ka kardu Pule ngala-wa i nhini-ka nhinhi-wa kathu thangiluwewu ngay-yu. Mu thangku-nu-wa ngay nganhiluwewunu-yu?” Mamna. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mu Jesus kathu-ka mamna, “Aa berengunh. Nhinhi thangiluwewunu-yu. I da nhini thangunu warda-ka neki-ka da mange ngarra Yile ngay nukunu warda pamanu purru nhini-yu.” Bere John the Baptist-ka daluwewu warda Jesus-yu ngarra kura ngipilinh ngala nhini da. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","I bere ngarra nukunu-re Jesus wurranmardawith ngarra ngipilinh thangunu kathu-ka da marnirra kalakkalak memnadharl warda. I nukunu-ka kangkarl mamka i bamkardu Ngepan ngarra Yile neki kathu wurdamnathut ngarra nukunu-nu, mangini ku kuluntutuk mani wurdanthut tharra. ");
INSERT INTO mwf2018_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","I da kangkarl kathu-ka murrinh dimngeng. I kanhi-wa mam murrinh-yu, “Nukunu pana-ka kardu wakal nugarn ngay-wa. Ngay-ka marda thathpirr-wa manganart ngurran. I le da matha nganamna nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bere nhini thangunu-ka Ngepan ngarra Yile neki nukunu mengkayidha tharra Jesus-yu ngarra da darrinpirr pularn-nu warda wangu. Da pangu nadha dini-ka ku karrath marullulnu pani. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bere da pirdithme nimin kardidha pangu-yu da merrk numi-ya i kanganu wurrinirrittha-yu, i mi-ka mere kanimurrktha. Bere da merrk numi-ya i kanganu nhini thangunu-ka Jesus-ka medeyi da matha yunganpirntay. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","I ku karrath kathu nanadha dini, i murrinh mamna, “Ya. Nhinhi ngatha wakal ngarra Pule ngala nukun thurran-ka, nhini-ka thurdathnu mani nanhthi palyirr kanhi i mi lawam warda pirrampanu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mu Jesus kathu-ka mamna, “Murrinh ngarra Yile ngay yibimnangurrkurrk-ka kanhi-wa, ‘Kardu mani-ka mere kanibirnu mi dhepdhep da matha-re kanammurrk, wurda. Mu murrinh thathpi ngarra Yile ngay thangunu kathu binayepupnu i manabathnu purru nhini kardu-ka panibirnunu warda thathpirr nhini-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bere nhini thangunu ku karrath-ka pangu warda wangu mebertidha wurrini Jesus-yu da Jerusalem-nu. I kanthinnala da kangkarl thathpirr da ngarra church ngala pangu da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","I nhini da nukunu kathu-ka mamna, “Ya. Nhinhi ngatha wakal ngarra Pule ngala nukun thurran-ka, nhini-ka thurdiwal mani kanhi da wangu i pepe da mana.” I ngana deyida murrinh mamna ngarra Jesus, “Murrinh ngarra Yile nhinhi nukunu-ka kanhi-wa yibim, ‘Nukunu Yile nhinhi-ka ku angel ngarra nukunu purdumpathuknu i pumanhiyitnu, i nhini-ka mere warda thanimemurrknu ngarra nanhthi palyirr pepe-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mu Jesus kathu-ka mamna, “Yu, nhini-ka murrinh. Mu murrinh numi yibimnangurrkurrk-ka kanhi-wa, ‘Mere da matha duthap Pule ngala Yile ngay ngathayida-nu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bere nhini thangunu-ka ku karrath pangu warda wangu mebertidha tharra Jesus-yu da ngarra palyirr kangkarl thathpirr kanthinmardawith. I kanthinkarr da terert warda ngatha, da thelput terert i kardu terert i nanhthi purrkpurrk wurnangat warda ngatha ngarra da putek ngala kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I mamna warda, “Nga. Nhinhi ngatha thengawinhipingkarlnu kumparra warra kanhi ngarra ngay i murrinh ngarra ngay nangabathnu kardu pule ngala ngurrumpanu, nhini ngay-ka ngampamutnu warda da wurnangat kanhi warda ngatha kurrankadhuk ngarra nganthinnhingkarr ngarrim-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mu Jesus kathu-ka mamna, “Ku karrath, pata thunu-wa thi. Mu nga, murrinh thathpi Yile ngay-ka kanhi-wa yibim-yu, ‘Nukunu da matha kardu Pule ngala thathpirr. I murrinh ngarra nukunu da matha dinayewupnu thurru i murrinh nanabathnu thurru. I da mange ngarra nukunu da matha thamanu thurru-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bere nhini thangunu ku karrath-ka kanampart warda Jesus-yu i ku angel warda parramnaruy i pirapedha warda pardi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bere, ngarra nukunu-re Jesus pamnayepup John the Baptist ngarra jail warda parramnadhap-ka, nhini nukunu-ka pangu warda wangu nadha dini da ngala nan-nu-ya, Kelili. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mu ngarra da town nhini Nazareth-ka mere kaniwuptha, mu puy wangu nadha dini da ngarra Capernaum da mana, i nhini da kanawup. Da nhini Capernaum-ka da manta ngangka da ngipilinh ngala nan-ya Kelili. Mu da murntak warra da pangu-ka da nan-ya Zebulun i Naphtali pumengkawadhadha purni. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bere nhini da matha Jesus kardipuptha-yu, i nhini-ka murrinh murntak pana ngarra ku prophet nan-ya Isaiah darntilil-ka, murrinh da thathpirr warda nhini-yu. I kanhi-wa murrinh mam-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kardu nhini ngarra da Zebulun i Naphtali parnam, i da ngamimarda pangu kathu da ngarra ngipilinh Jordan parnam, i ngarra lalingkin manta parnam, i da ngarra ngala nhini Kelili ngarra kardu mere Jews parnam. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bere kardu wurnangat nhini ngarra da thipmam binhi da matha parnam, mu kardu nhini-ka da tarangka thathpirr warda pubangkardunu i parralarrangnu nhini-yu. Kardu nhini-ka da wiye da matha pumarntithuk parnam i mere da ngatha the pumabath Yile neki. Mu Yile neki-ka da mayern yuthpan tarangka ngarra nukunu pankarrnu warda nhini-yu.” Nhini-wa nukunu Isaiah darntilil-yu da murntak warra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bere nhini thangunu Jesus-ka murrinh warda pantet ngarra kardu wurdanarrayiththa wurrini. I kanhi-wa murrinh merradha wurrini-yu, “Ya kardu. Pananmardathinnu warda thathpirr da mange wiye nhini thangunu nanthin numpan-yu, i narnipartnu warda nhini-yu. Mu da-ka manta warda kurran kathu ngarra Yile neki-re kardu Pule ngala thathpirr warda pinarranu ngarra kardu wurnangat warda ngatha-yu.” Merradha wurrini-yu Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bere nhini thangunu Jesus-ka nadha dini da ngipilinh ngala nan-nu Kelili. I ngarra nukunu-re punimardadha wurrini ngarra ngipilinh-ka nukunu bampunkungkardu piguna Simon, murrinh nukunu numi-ka Peter-ya i ngathan nukunu Andrew nanhthi karlay parderuthtuththa ngarra ngipilinh ku ngurlmirl-nu. Piguna nhini-ka kardu bere matha parderuthtuththa ku ngurlmirl-nu nanhthi karlay-re. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bere Jesus kathu-ka mampirru, “Ya. Nanku-ka kardu bere matha wangu ku ngurlmirl-nu narnamkaruthtuth, mu tharra-ya purruneme ngarra ngay. Ngay-ka ngurdinankuyethithnu kardu-nu nururrakaykaynu i kardu ngarra ngay pangilerrnu puru i pangiriwaknu puru.” ");
INSERT INTO mwf2018_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bere piguna nhini-ka parnamkapart warda nanhthi karlay-yu i parraneriwaktha punne ngarra Jesus warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I puy deyida wangu punnedhaneme-ka, Jesus bampunkungkardu piguna James i John ngarra tharntu nanhthi karlay parraneredhaneme pirrine wunku yile piguna nan, Zebedee. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bere Jesus-ka wurranpirrukay piguna nhini-yu. I nhini thangunu-ka parnamkapart warda yile piguna pangu da wangu ngarra tharntu. I ngarra Jesus warda parraneriwaktha punne. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bere Jesus-ka nawattha dini da ngarra church terert pangu-yu da ngarra ngala nan-ya Kelili, i murrinh thelerrdhe patha daninthelerrdha wurrini murrinh ngarra Yile neki-re kardu Pule ngala thathpirr pirranu ngarra kardu. I kardu matharr-wunngini wunku menpathadha wurrini, nanhthi matharr terert warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bere, murrinh nhini ngarra matharr-wunngini menpathadha wurrini-ka bamlang warda da ngathparr wangu i da ngarra ngala nhini nan-ya Siriya da mana. I kardu da ngarra nhini-ka kardu matharr-wunngini terert pumenmertidha purni ngarra Jesus-nu, matharr terert-ya i yidingurr terert. Kardu wunku ku ngepan wiye panthidha purni-ya, i kardu matharr werrerrerr panthidha purni-ya i kardu punintedha wurrini. Bere Jesus-ka menpathadha wurrini kardu matharr-wunngini terert nhini-yu i kardu-ka manangka matharr warda nhini pardingkadhuktha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bere kardu wurnangat nimin-ya parraniriwaktha warda purni Kangkarlmawu-yu da ngarra Kelili thangunu kathu i da town 10 nhini pangu-yu, i da ngarra Jerusalem thangunu kathu, i da Judea, i da ngamimarda pangu kathu ngipilinh ngala nhini-ya Jordan. Kardu wurnangat nhini warda ngatha parraniriwaktha purni Kangkarlmawu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bere Kangkarlmawu bampunkardu kardu wurnangat ngarra pubemkardurdu-yu. I nhini nukunu-ka dimmardawith warda ngarra da palyirr i kanawup. I kardu pulangay nukunu deyida pirrimkamardawithneme da pangu-yu i ngarra Kangkarlmawu manta parnamkawupneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","I bere nukunu-ka murrinh warda wurdanpunthethith kardu ngarra wurnangat nhini. I mampirra, ");
INSERT INTO mwf2018_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nga kardu. Nanki kardu ngamere kanhi nirrimkadhuk-ya ngepan ngarra nanki mere lurruth ngala numabath ngatha-ka, nhini nanki-ka le da matha narninu. Nhini Yile neki-ka kardu Pule ngala da matha dimnarra, i nukunu-ka pirrananpenu purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“I nanki kardu ngamere kanhi ngarra damnanmardathin kanam-ka, le deyida narninu, nhini Yile neki-ka ngarra nanki da matha mananmanpinu purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“I nanki kardu pana ngarra Yile neki da matha nuddamnayemit numpan-ka, kardu le da matha narninu, nhini Yile neki-ka da putek ngala kanhi panarramutnu i kardu pule ngala nuyunu da kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“I nanki deyida kardu pana ngarra marda thathpirr numanganart da mange yuthpan-nu nariwaknu, nhini nanki-ka le deyida narninu. Yile neki-ka da mange yuthpan nhini panarrangkardanu purru. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“I nanki deyida kardu ngamere kanhi kardu ngarra darrikardu-nanmarda i da mange patha patha numampirra numpan ngarra kardu ngamere-ka, nhini nanki-ka le da matha narninu. Yile neki-ka mange patha deyida manarranu purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“I nanki deyida kardu pana ngarra marda thathpirr numanganart numpan Yile neki, le da matha narninu nhini-yu, nhini nanki-ka da ngarra Yile neki nukunu narninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“I nanki kardu ngarra makthuk numpan-ya i murlmurl thathpirr narnam, nhini-ka le da matha nurunu nhini-yu. Nhini Yile neki kathu-ka murrinh manarranu, ‘Nanki-ka kardu wakal ngay da matha nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“I nanki kardu ngarra da tetemanthay kama pubannarrapak pumpan-ya kardu ngarra ngamere kathu, nhini nanki-ka da mange ngarra Yile neki nukun weyida narrarntiwak numpan. Nhini nanki-ka kardu le patha da matha narninu, nhini Yile neki-ka kardu Pule ngala da matha dimnarra nhini-yu, i nukunu pirrananpenu pani. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“I nga. Kardu ngamere pana deyida murrinh pumanannarrithaknu ngatha i da tetemanthay ngatha pubunarrapaknu i murrinh pananthirrarartnu parni nanki-nu, nhini nanki-ka le da matha narninu nhini-yu. Kardu-ka mange nhini pumanarranu puru nhini nanki-ka kardu ngarra ngay weyida narramngiriwak numpan. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","I da murntak warra da mange wiye nhini deyida mani pumerrudhaneme purne ngarra ku prophet-yu kardu ngarra Yile neki nukunu-yu. Nhini nanki-ka le da matha narninu nhini Yile neki-ka nanhthi patha patha mamnarrayit dim da ngarra Heaven nanki-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“I nga,” Kangkarlmawu kathu-yu mampirra. “Nanki-ka nanhthi mangini salk mani kardu wurnangat kanhi warda ngatha-nu ngarra da putek ngala kanhi parnam. Nginipunh nanhthi salk mani nanhthi patha ku ngen-nu-ka, nhini nanki-ka patha deyida numampirra numpan kardu wurnangat kanhi-nu. Mu nanhthi salk nanhthi murntak i wiye ngatha-ka nanhthi-ka mere patha deyida kirra, wurda. I nanhthi-ka nunnuku warda nhini-yu, i kardu-ka punnudhurrthurrnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“I ngana deyida nanki-ka nginipunh da tarangka mani damlarrang pirrim-ya kardu wurnangat kanhi-nu da ngarra putek ngala kanhi parnam-ya. Nginipunh da town mani-ya da ngarra palyirr kangkarl dim-ka da-ka damlarrang pilampirdarri da matha dim nhini-yu. I nhini nanki-ka kardu pilampirdarri deyida narnam kardu-nu pubananmangkardunu da mange ngarra patha patha nhini ngarra nanki namam numpan. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nga. Mere nangkal ngadha karibirl thungku lem-yu i bupak pepe ngarra nanhthi pakit, wurda. Mu nukunu-ka kangkarl da matha mamkale i thungku-ka palarrangnu pintha i kardu ngarra thelput nhini pirrimkadhuk-ka bere matha wangu parnammirlbirl nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nginipunh nhini mani nanki-ka da mange tarangka i patha da matha numarranu nuru. I nhini kardu-ka pubananmangkardunu parni da mange patha patha nhini ngarra namam numpan-ya. I nhini kardu-ka pariparlnu warda parni Yile neki-yu ngarra da Heaven dim-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","I ngana deyida Kangkarlmawu kathu-ka mampirra, “Nga. Nanki kama nubenthengkarnirn numpan-ka ngay-ka ngurrinidha da putek ngala kanhi murrinh law ngarra Moses i ku prophet ngarra Yile neki nukun nguninmakudha-mana-wa-neme murrinh law murntak nhini-ya? Mu wurda, ngay-ka mere nukun ngununkumakuneme murrinh law nhini-yu. Mu ngay-ka mange ngamanu ngurru da mange nhini da matha ngarra murrinh law nhini mam-yu, i nhini nanki-ka the warda numabathnu nuru murrinh law nhini-ka murrinh da thathpirr nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mu ngarra da putek ngala kanhi i da kangkarl pangu pirra da ngatha-nu, murrinh law nhini-ka bere ngatha pungurrkurrknu, i murrinh-ka mere ngarra nukun kiyerrarr murrinh kunungingki ngatha yida-yu. Mu murrinh-ka bere ngatha wangu pungurrkurrknu i ngarra da putek ngala kanhi da mana panirikerdeknu. Kanhi-ka murrinh thathpirr-wa mamnarra ngem-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Mu kardu nangkal ngatha murrinh law kunungingki ngatha yida muparlnu-ka i murrinh purdunthethithnu ngatha kardu ngamere pumuparl-deyida-nu-ka, nhini nukunu-ka kardu ngathayida da matha paninu i mere kardu ngala paninu nhini-yu kardu ngarra Yile neki nukun-yu. Mu kardu nangkal ngatha murrinh thathpirr mabathnu purru murrinh law nhini, i kardu ngarra ngamere deyida purdunthethithnu purru murrinh pumabathnu puru, nhini nukunu-ka kardu ngala thathpirr purrunu kardu ngarra Yile neki nukun-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Nga, ngay-ka manarranu-ka murrinh thathpirr numanabathnu nuru murrinh thathpi ngarra Yile neki nukunu, i da mange ngarra nukunu da matha nariwaknu nuru ngala deyida wangu nuyunpewalnu da mange kardu pana-ya ngarra murrinh law Moses nukun puddanpunthethith pumpan, i kardu nan-ya kardu Pharisees. I mange nhini ngatha nuyemanu nuru-ka nhini nanki-ka kardu ngarra Yile neki da matha nukunu nhini-yu. I nukunu-ka ku pule ngala nanki da matha pinarranu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nga, nanki-ka the mana nanthin murrinh law murntak nhini nganaka ngarra Moses nukunu. Murrinh-ka kanhi-wa yibim-yu, ‘Mere nukun thu thubat i thurdurinuminu kardu numi. Mu kardu ngatha kubat i kurdurinumi kardu numi, nhini kardu-ka pumabertinu puru kardu nhini-yu ngarra murrinh court-nu wangu i nukunu nhini-ka pirramardatnu kumparra warra ngarra ku judge. I ku judge-ka murrinh mananu ngarra kama pamanu kardu nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mu ngay murrinh manarranu-ka kardu ngatha kanarithi ngarra kardu numi, nhini kardu-ka pumaberti-deyida-nu puru kardu nhini-yu da ngarra murrinh court-nu warda wangu. I kardu ngatha murrinh mardarrithaknu ngarra kardu numi, nhini kardu-ka pumabertinu puru kardu nhini-yu ngarra kardu pule ngala ngala-nu wangu. I kardu ngatha murrinh mananu ngarra kardu numi, ‘Nhinhi-ka pelpith wiye thathpirr-wa,’ nhini Yile neki-ka kurduthuknu kama kardu nhini-yu ngarra da thungku ngala wangu-yu, da Hell-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“I nga. Ngarra narnirdi thelput ngarra Yile neki nukunu-ka i nanhthi nanamutnu ngarra Yile neki, mu nhini nanki-ka nuddiyerr deyida kardu numi da ngatha thu kuy thanamnintha ngarra nhinhi kathu, ");
INSERT INTO mwf2018_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nhini-ka thanipartnu ngadha nanhthi pana-yu ngarra thenamuttha-yu, i thurrunanu warra ngadha ngarra kardu nhini i murlmurl warda thaninintha. Nhini-re warda thurdiwurlnu i nanhthi nhini thanamutnu warda ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“I ngana deyida, kardu ngatha murrinh mampa, ‘Nhinhi-ka da mange wiye nam, nhini ngay-ka ngarra murrinh court-nu warda manhibertinu ngurru.’ Mu murlmurl da matha thurruninthanu murrinh ngarra court-nu wangu-yu. Mu wurda ngatha-ka nhini-ka manhiberti da matha-nu purru ngarra murrinh court nhini-yu, i nhini-ka ngarra ku judge panamutnu. I ku judge nhini-ka nhinhi-ka panamutnu warda ngarra ku policeman, i nhini ku policeman-ka pampadhapnu warda ngarra jail. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","I pangu da matha thinganamardanu i ngarra ku mani terert da mana pay thamanu, ku fine-ya. Murrinh thathpirr mamnarra-yu.” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“I nga, murrinh deyida manarranu,” Kangkarlmawu kathu-yu mampirra. “Nanki-ka the mana nanthin murrinh law kanhi yibim-yu, ‘Mere nukun nabert kardu palngun karnabuy i ngarra nigunu warda thaninginthawit.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mu ngay-ka murrinh manarranu-ka, kardu nugarn kathu pirrabathnu ngatha kardu palngun numi, i nukunu-ka marda manganart dim paninginthawitnu ngarra nigunu, nhini-ka mangini kanamnginthawit mani wardarra nukunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","I nhini-ka nanhthi kamarl numi ngarra nanki ngatha-re nubangkardunu i da wiye warda nuyemanu, nhini-ka kamarl-ka nunguyngkapirt i nunnuku warda nhini-yu. Nhini-ka patha-wa nhini-yu kamarl numi da matha numabathnu nuru. Mu kamarl perrkenku ngatha numabathnu nuru i da mange wiye-nu ngatha numabathnu nuru, nhini-ka ngarra da thungku ngala da matha narninu da nakurlnu-re. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“I ngana deyida ngarra mange batbat nanki-re da mange wiye numabath ngatha nuru-ka, nhini mange-ka nubemartal-wa i nunnuku warda nhini-yu. Nhini-ka patha-wa nhini-yu mange numi da matha numabathnu nuru. Mu mange perrkenku ngatha numabathnu nuru i da mange wiye-nu ngatha numabathnu nuru-ka, nhini-ka ngarra thungku ngala da matha narninu da nakurlnu-re.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“I nga, murrinh law murntak numi kanhi nubinthepup nawa?” Kangkarlmawu kathu-yu mampirra. “Kardu nugarn ngatha kanipart palngun nukunu, i nukunu-ka murrinh pangerililnu ngarra nanhthi peypa murrinh kanhi-ya, ‘Palngun kanhi-ka palngun mere ngay warda nhini-yu, wurda, nganampart warda,’ i bamardanu nanhthi peypa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mu ngay murrinh manarranu-ka, kardu nugarn ngatha kanipart palngun nukunu, i nigunu-ka mere merithuktha kani ngarra nugarn ngamere, mu nangkun nigunu-ka ngathayida kanipart ngatha-ka, nhini-ka nginipunh ngarra kardu nugarn numi deyida mani kanamut nigunu nhini i kaninginthawitnu. I nukunu kardu nugarn nhini warra-ka mungamparl deyida da law nhini-yu, nhini nukunu-ka kardu palngun karnabuy warda kanthin wurran.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“I nga.” Kangkarlmawu kathu-yu mampirra. “Nanki-ka the mana nanthin murrinh murntak kanhi yibim-ya. Ngarra murrinh kanhi mani nuyemananu ngarra Yile neki wangu, ‘Yu, ngay-ka mampanu ngurru da nhini-yu, Yile.’ Murrinh nhini-ka murrinh da matha numanayitnu nuru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Mu ngay-ka murrinh kanhi-wa manarranu-yu. Ngarra murrinh nginipunh nhini mani numarranu nuru ngarra kardu-ka, nhini-ka mere nukun numangkawadha Yile neki-yu, nginipunh kanhi mani-ya, ‘Yu, Kangkarlmawu thathpirr.’ I ngana deyida mere nukun numangkawadha da Heaven, nginipunh kanhi mani-yu, ‘Yu, da Heaven thathpirr.’ I mere nukun deyida numangkawadha da putek ngala kanhi, i da Jerusalem, i pelpith nanki ngatha yida, wurda da matha. Yile neki da matha da wurnangat kanhi warda ngatha i da kangkarl mampatha i da terert nhini warda ngatha da nukunu, i da mamnginikat dim. I nanki-ka mere ngarra deyida pemarr nanki nuddunumath pemarr thipmam i pemarr bamam da mana-nu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Mu ‘Yu’ da matha nuyemanu nuru, i ‘Wurda’ da matha nuyemanu nuru. I nhini-ka nhini da matha murrinh-yu. Mu murrinh pirdithme ngatha nubangkawunu-ka ngarra murrinh ‘Yu’-nu i ‘Wurda’-nu-ka, nhini-ka murrinh ku karrath thangunu kathu-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nanki-ka the mana nanthin murrinh law murntak kanhi yibim nganaka, ‘Nhinhi ngatha thungungkapirt kamarl ngarra kardu numi, nhini nukunu deyida kamarl ngarra nhinhi pungunhingkapirtnu. I nanhthi dimu ngatha dardiwarl ngarra kardu numi, nhini nukunu deyida kathu banhirdiwarl dimu ngarra nhinhi-yu. I mange-ka nginipunh nhini mani-wa mange mungamninthawurr.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mu ngay murrinh manarranu-ka, mere nukun nuddurrawerl kardu ngamere pana-ya ngarra ngurradhath pananngurrunu-ya. Mu kardu ngatha banhidhamurrurduk ngarra thamurru batbat-ka nhini-ka thamurru numi-re thanamut i banhidhamurrurduk deyida. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","“I kardu ngatha murrinh court-nu manhibertinu purru nanhthi shirt nhinhi-nu-ka, nhini-ka thanamut da matha nanhthi shirt nhinhi i nanhthi kawut wanku thanamutnu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","I ku soldier ngatha nanhthi swag nukunu kampamut nanhthi thuynamanthinu thurru da kunungingki-nu, nhini nhinhi-ka da ngathparr da matha thuynamanthinu thurru nukunu nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","I kardu ngatha nanhthi-nu panhidharrpunu-ka nhini-ka thanamut da matha. I kardu ngatha nanhthi-nu panhidharrpunu da kunungingki da matha-nu nhini-ka thanamut deyida nanhthi nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“I nga,” Kangkarlmawu kathu-yu mampirra. “Nanki-ka the mana nanthin murrinh murntak kanhi-ya ngarra pumedha purni-ya, ‘Marda numanart nuru kardu pana-ya ngarra marda pumangannhert pumpan-ya. I kardu pana deyida ngarra thu kuy pumpannarra-ka, nhini nanki-ka thu kuy deyida nururranu ngarra kardu nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mu ngay murrinh manarranu-ka marda thathpirr numanartnu nuru kardu nhini ngarra thu kuy pumpannarra i kardu ngarra mere kumananart kuru-yu. I Yile neki nadharrpunu da mange patha marranu purru kardu pana ngarra da tetemanthay pubannarrapak pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","I nhini nanki-ka kardu wakal ngarra Yile neki nukunu warda nurunu nhini-yu. Nukunu-ka kardu wurnangat warda ngatha marda manganpunart dim. I nukunu-ka nanhthi ngunga nukunu dampirralarrang dim ngarra kardu wurnangat warda ngatha-nu, kardu pathanpun-nu-ya i kardu wiyenpun-nu-ya. I nukunu-ka kura yelyel wurdanpirrathukthuk wurran ngarra kardu pathanpun-nu i kardu wiyenpun-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Mu nga. Nanki ngatha marda numanartnu nuru kardu pana da matha ngarra marda pumangannanart pumpan-ka nhini-ka nubenthengkarnirn Yile neki-ka panantiparlnu nhini-yu? Nginipunh kardu wiyenpun pana ngarra ku mani pumpanpunmatkut ku Government-nu mange nhini deyida pamam pumpan nhini-yu. Mu nanki-ka kardu wurnangat warda ngatha marda thathpirr numenurtnu nuru. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","I murrinh ngatha narnirrangerrennu ngarra kardu darrikardu nanki da matha-ka, nhini-ka nubenthengkarnirn narnam mange patha nhini-yu? Kardu pana mani ngarra mere kariwak kuru Yile neki-ka mange nginipunh nhini deyida pamam pumpan nhini-yu. Mu nanki-ka ngarra kardu terert da matha nururrangerrennu. ");
INSERT INTO mwf2018_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yile neki-ka kardu yuthpan thathpirr dim. I nhini nanki-ka mangini nukunu deyida mani kardu yuthpan thathpirr nurunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Bere Kangkarlmawu kathu-ka mampirra deyida, “Nga kardu. Ngarra murrinh prayer-re nuyemanu nuru, i ngarra kardu-re numanmanpinu nuru, i mange nginipunh nhini mani nuyemananu nuru ngarra Yile neki-nu-ka, nhini-ka mange-ka mere pilampirdarri nukun nuyema nuru ngarra kardu terert pirananmathnu puru i panantiparlnu nhini-yu. Mu ngarra pilampirdarri mange nhini ngatha nuyemanu nuru-ka nhini Yile neki-ka mere kanantiparl nukun i mere kanarramut nukun nanhthi ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mu ngarra nanhthi kama i mi kama narramut ngarra kardu mananhthi-wunka-ka, nhini-ka watmam dere matha narramut ngarra kardu terert makardu-re. Mu kardu pana nganaka ngarra pumerntart pumpan Yile neki mana-wa parrarntiwak pumpan, kardu nhini-ka nanhthi parrampirramut ngarra kardu mananhthi-wunka-nu-ka ngarra kardu terert-te panganpunmath mange nhini pamam pumpan-yu, da ngarra murrinh church kama i da ngarra kardu pubemkardurdu kama. Nhini-wa kardu mange kardu pantiparlnu puru-yu. Mu Yile neki-ka mere kantiparl nukun kardu nhini-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Nhini-ka ngarra nanki-re nanhthi kama i mi kama narramut ngarra kardu mananhthi-wunka-ka, nhini-ka watmam da matha narramut kardu ngarra makardu-re-ya, i nhini-ka kardu darrikardu nhinhi ngathayida-ka mere warda the manhimabath nhini-yu. I nhini-ka Yile neki da matha banhimangkardunu, i nukunu-ka nanhthi ngarra nukunu thathpirr warda pampamutnu da nakurl-te-nu-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“I nga.” Kangkarlmawu kathu-yu mampirra. “Ngarra murrinh prayer numananu nuru-ka, nhini-ka mere nirat nukun ngarra kardu wurnangat pubemkardurdu-yu i pirananmathnu da ngarra church kama i da pana ngangka-re kama. Mu kardu pana-ya ngarra pumerntart pumpan Yile neki mana-wa parrarntiwak pumpan-ka mange nginipunh nhini mani pamam pumpan-ya nhini-ka kardu pantiparlnu puru kardu nhini-yu. Mu Yile neki-ka mere kantiparl nukun kardu nhini-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mu kardu numerrnhi da matha da ngarra nhinhi thanirdinu i nanhthi tuwa thenumadhapnu i pangu da matha thurdinayithnu thi ngarra Yile neki-nu. Yile neki-ka kardu mere ngarra dangkardu, mu nukunu kathu-wa banhimangkardunu mange pana numerrnhi ngarra murrinh thurdinayithnu thi, i nukunu-ka nanhthi warda pampamutnu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“I mere nukun murrinh ngathayida nuddinayithnu nuru wunku murrinh pangkuy i pirdithme wanku. Mu kardu ngamere pana da mange nhini pamam pumpan-ya i pubenthengkanirn pumpan Yile neki-ka birrayepupnu mana-wa nhini-ka murrinh prayer pangkuy weyida pumpannangerren, mu wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mu mere nuddinayith nukun nuru murrinh prayer pangkuy nginipunh nhini mani-ya. Nukunu Yile neki-ka the thathpirr kanthinnan i the deyida kanthin thangku nanhthi kama nadharrpunu ngarra mere da ngatha nedharrpudha. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mu murrinh-ka kanhi mani-wa nuddinayithnu nuru ngarra Yile neki-yu. Yile, ngarra da Heaven thim. Nhinhi da matha ngala thathpirr-yu i patha da matha. I nhinhi da matha nganhiriparlnu ngarni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I nganki nganhidharrpunu thingarranu kardu Pule ngala thathpirr ngarra kardu wurnangat warda ngatha. I da mange ngarra marda nangannganart thim nganki-nu, nhini nganki deyida mange nhini nguyemampanu nguru, nginipunh kardu pana mani da kangkarl parnam da mange ngarra nhinhi da matha pumampa pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","I mi dhepdhep thangarramutmutnu thurru. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","I thirranganmaputhnu da mange wiye ngumebaththa ngardi, nhini nganki-ka nguyenthekum warda da mange wiye ngarra kardu ngamere thangunu kathu pumengarradha purni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","I nanganmanpinu murrinh ngarra nhinhi da matha ngumampabathnu ngarni ngarra ku karrath-te mangantullulnu-yu. I nanganyitnu thurru nganki-yu, nhini ku karrath-ka mere ngarra nukun manganbert. Murrinh-ka nginipunh nhini mani-wa nuddinayithnu nuru ngarra Yile neki-nu wangu,” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“I nga. Ngarra kardu-re da wiye pumanarranu-ka, nhini-ka nuyuyekum da wiye nhini, i nhini Yile neki deyida puynanmayekum da wiye nhini ngarra numebaththa nurni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mu mere ngatha nuyunmayekum da mange wiye ngarra kardu ngamere thangunu kathu, nhini Yile neki-ka mere deyida kuynanmayekum nukun da wiye nhini ngarra numebaththa nurni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nga.” Jesus kathu-yu mampirra. “Ngarra murrinh prayer-nu nuddinayithnu nuru-re-ka i mi dhepdhep narnipartnu ngadha-ka, nhini-ka mere kanankawethin-wa nukun nhini-yu. Mu kardu pana ngarra pumerntart pumpan Yile neki mana-wa parrarntiwak pumpan-ka kardu dampunkawethin wurran i mere kumenungkapurl kamarl ngarra pigunu i mere kuyuwepek pemarr pigunu-yu. I nhini kardu ngamere kathu-ka pubampunmangkardu mi parnampart ngadha murrinh prayer-nu. I kardu ngamere kathu parrampuntiparl pumpan kardu nhini-yu, mu Yile neki da matha wurda-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mu ngarra mi-re narnipartnu ngadha i murrinh nuddinayithnu nuru ngarra Yile neki, nhini-ka kardu bere ngatha numenungkapurlnu nuru kamarl ngarra nanki i pemarr wunku nuyuwepeknu nuru. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","I nhini kardu ngamere-ka mere warda the pumananmabath-nu da mange nhini namam numpan-yu. Nga. Yile neki-ka kardu mere ngarra nubangkardu, nukunu kathu-wa bananmangkardunu da mange nhini watmam namam numpan-yu i nukunu-ka nanhthi nakurlnu panarramutnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“I nga,” Kangkarlmawu kathu-yu mampirra. “Mere nukun nubemardarr nuru nanhthi purrkpurrk pana nanhthi terert i ku mani terert ngarra da putek ngala kanhi narnam. Nanhthi nhini-ka panirikerdek da matha-nu i ku kakurruth parnimurrknu nanhthi nhini-yu, i nhini-ka nanhthi warda piwurdup da matha-nu. I kardu darrarart-wunka kumanankardap nukun nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mu mange ngarra Yile neki da matha nukunu nariwaknu nuru, i nhini-ka mangini nanhthi purrkpurrk mani nubemardarrnu nuru da kangkarl da Heaven-ya. I nanhthi nhini-ka mere kanirerdek i mere kiwurdup nukun pangu-yu i mere nangkal nukun darrarart manankardap nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","I nanki ngatha mangini nhini mani nubemardarrnu nuru da kangkarl-ka, nhini nanki-ka marda numartnu nuru pangu da matha narninu ngarra da Heaven.” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“I nga. Nanhthi kamarl ngarra nanki-ka mangini thungku layit mani-wa nhini-yu ngarra ngepan nanki-nu-yu. Nanhthi kamarl ngatha da patha-nu numpanmirlbirl, nhini-ka nanhthi ngepan-ka tarangka da matha palarrangnu pani nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mu kamarl ngatha da wiye-nu numpanmirlbirl-ka, nhini ngepan-ka da ngarra thipmam binhi mani-wa narnam nhini-yu. I ngepan ngarra nanki manangka tarangka ngatha numammath narnam-ka, nhini ngepan nanki-ka thipmam binhi ngala da matha nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mu nga. Mere nangkal ngadha murrinh birruyepupnintha i murrinh marrubathnintha ku pule ngala ngala perrkenku-nu-yu, wurda. Mu nukunu-ka ku pule ngala numi da matha murrinh manabath-yu le kanina i mere ngarra murrinh manabath ku pule ngala numi-yu i mere le kanina nukunu-yu. I nga. Mange nginipunh nhini mani-ka Yile neki i ku mani-ka mere kinintha nukun ku pule ngala nanki-nu-yu, wurda-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","I nhini ngay murrinh manarranu-ka mere nenuwerr nukun ngarra mi dhepdhep wangu-yu i kura patha-nu-yu nanhthi ngarra kardu birnu nukunu-yu. Nanki-ka kardu berengunh birnu narnam i nhini-ka ngala-wa, mu mi dhepdhep-ka kunungingki da matha, nhini nanki-ka mere nenuwerr nukun. I ngana deyida mere nenuwerr nukun nanhthi ngarra nubuyrdurdinu nuru-yu. Nginipunh ngarra nanki-ka ngala-wa, mu nanhthi ngarra nubardurdi numpan-ka kunungingki da matha nhini-yu, nhini-ka mere nukun nenuwerr. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Nga, ku murrirrbe nubangkardu kumpanmarlbarl nganaka. Ku pangu-ka mi mere kubabirr kuru mi kamarl. I mere kuddururturt kuru mi dhepdhep i mere kubarartal i mere kubemardarr kuru mi-yu ngarra thelput, wurda da matha nhini-yu. Mu Yile neki da matha da ngarra kangkarl dim-ka dirranganpunpe kanam ku murrirrbe kanhi i mi dampirramutmut wurran-yu. I nhini Yile neki-ka nanki deyida wanku pirrananpenu purru nhini-yu. Nanki-ka kardu-wa, mu ku murrirrbe-ka ku da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nga. Mere nangkal ngadha da pirdithme panibirnunu ngarra da putek kanhi-yu penewerrnu ngatha pani da mange nginipunh nhini wangu-yu wurda, mere niyema-nukun-neme nuru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“I mere nenuwerr nukun nanhthi ngarra nubuyrdurdinu nuru. Nga, nubangkardu mi purripulawa purrkpurrk pangu kurrankadhuk-yu. Mi-ka mere wurlk kuyema kuru i nanhthi kaligu mere kawarl karni nanhthi pangu pubuyrdurdinu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","I mi pangu-ka lelunh da matha dimpunpewal ngarra nanhthi kaligu ngarra King Solomon banardurdidha wurrini nanhthi kaligu murruwurlngka nimin-ya da murntak warra-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yile neki-ka mamlelunh mi purripulawa terert warda ngatha, mu mi-ka mere pirdith i demmugarl. Marra kanhi-ka mi kibimkadhuk, mu thipinhire-ka mi-ka demmugarl warda, i kardu-ka niraputh warda mi nhini-yu. Mu Yile neki-ka lelunh da matha mampatha, i nhini-ka nanki deyida pirrananpenu purru nanhthi-nu nubuyrdurdinu nuru nhini-yu. Nga, mi i nanhthi-nu ngatha nerrewerr numpan-ka nhini-ka nuddamnayemit kunungingki da matha ngarra Yile neki-nu. Mu nuddunayemitnu thathpirr nuru ngarra nukunu. I nhini-ka ");
INSERT INTO mwf2018_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","mere nenuwerr nukun i murrinh mere nuyema nukun, ‘Mi-ka ngarra wangu nganikutnu, i kura-ka ngarra wangu ngiwurlnu, i nanhthi kaligu-ka ngarra wangu martnu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“Mu kardu ngamere nhini ngatha mi i nanhthi-nu perrewerr pumpan-ya. Mu nanki-nu-ka Yile neki pirrananpenu purru nhini-yu. Nukunu-ka the kanthinnan ngarra mi mami narnam i nanhthi mananhthi narnam. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yile neki-ka kumparra da matha nubupaknu ku Pule ngala pinarranu i da mange patha ngarra nukunu da matha nariwaknu nuru. I nhini nukunu-ka mi dhepdhep, kura patha i nanhthi kaligu panarramutmutnu purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","I mere nenuwerr nukun nuru da thipinhire-nu-yu. Mu da thipinhire da matha nubeyengkarnirnnu nuru da nhini-nu-yu. Mu marra kanhi nubeyengkarnirnnu nuru da tetemanthay ngarra da marra kanhi nukun da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Kangkarlmawu mampirra deyida ngarra kardu terert, “Nga kardu. Mere nukun murrinh nuddunyith nuru kardu ngarra ngamere-yu, kardu wiyenpun kama pumpan-ya i kardu pathanpun kama-ya. I mere numannarrithak nukun nuru kardu nhini-yu. Mu mange nhini ngatha nuyemanu nuru-ka nhini Yile neki-ka mange nhini deyida manarranu nhini-yu. Da mange nhini ngarra numampirra numpan kardu ngarra ngamere, nhini Yile neki kathu-ka mange nhini da ngatha manarra-deyida-nu purru ngarra nanki. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nhini-ka nginipunh kardu pana mani nganaka thamkarda thirrim ngarra kamarl nukunu kardu numi nanhthi thay kunungingki kanamkardi-ya. Mu nhinhi-ka nemnupe-wa nanhthi thay ngala kanamnhingkardi deyida ngarra kamarl nhinhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","I mere nukun nana ngarra kardu nhini-yu, ‘Ya. Nanhthi thay kunungingki mani ngungumpapirt ngarra kamarl nhinhi,’ ngarra nhinhi-re thanthin thirrim wunku thay ngala pana kanamnhingkardi. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mere nukun numerart nuru nginipunh nhini mani-yu, wurda. Mu marra-re warra ngadha-ka nanhthi thay ngala thunguyngkapirt ngarra kamarl nhinhi kanamnhingkardi. I nhini kamarl-ka tarangka da matha dangkardunu-yu nanhthi thay kunungingki pana-nu thungunapirtnu ngarra kardu numi kathu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“I nga,” Jesus kathu-yu mampirra. “Mere nukun narramutmut nuru murrinh ngarra Yile neki nukunu i mi ngarra Yile neki nukunu ngarra kardu wiyenpun-yu, nhini kardu-ka murrinh ngarra nukunu i mi nhini ngarra nukunu pirraputh da matha-nu, i nanki deyida wanku panankamitnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Bere Jesus kathu-ka murrinh deyida mampirra, “Yile neki nadharrpunu nuru nanhthi pana-nu-ya ngarra narnamyeyma. I ngana deyida nanhthi nhini-nu nirawinhadhathnu nuru, i nhini Yile neki-ka nanhthi-ka panarrangkardanu warda nhini-yu. Kardu bere ngatha wangu nadharrpunu nuru Yile neki, i nhini nukunu-ka nanhthi warda kanarramutnu warda ngarra nanki-yu nanhthi pana ngarra narramtharrpu-yu, mange nhini ngatha nuyemanu nuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I nga, nankuneme yileyile. Wakal nankuneme ngatha kanankudharrpuneme mi lawam-nu-ka, nankuneme-ka mere ngarra kama mani narrumutneme nanhthi palyirr-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","I ku ngurlmirl-nu ngatha kanankudharrpuneme-ka, nankuneme-ka mere ngarra kama mani narrumutneme ku pangkuy-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kardu nanki-ka mere patha thathpirr nuru, mu nanki-ka the-wa numamath mi dhepdhep patha da matha narrampirramutmut-yu ngarra wakal nanki-yu. Mu Yile neki-ka patha thathpirr-wa nhini-yu, nhini nukunu-ka da kangkarl kathu nanhthi patha thathpirr damnarramutmut wurran kardu pana-nu ngarra narrantharrpu numpan-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nanki-ka kardu le numpanpirra kardu pangu kathu ngarra da mange patha pumamnarra pumpan-yu, na? Nhini nanki-ka da mange patha nhini da ngatha numarranu nuru-yu ngarra kardu nhini-yu. Nhini-wa murrinh law ngarra Moses nukunu i ku prophet terert wanku da murntak thangunu kathu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Da mayern pana da ngarra Yile neki-nu nungam dim-ka da-ka mayern ngalthe i kunungingki da matha nhini-yu. Mu da mayern ngarra da thungku ngala-nu da Hell wangu nungam dim-ka, da-ka mayern ngala da marda nhini-yu. Nhini nanki-ka nurulilinu ngarra mayern ngalthe da matha, i nhini nanki-ka kardu bere matha wangu birnu narninu. Kardu ngamere da matha pubangarnurdurt pumpan da mayern ngalthe nhini, i mayern nhini-ka da tetemanthay da matha nhini-yu. “Mu da mayern da ngala da marda-ya kardu wurnangat da matha pibiwat da nhini-yu, i da mayern nhini-ka pekpek da matha. Mu kardu nhini-ka pubarikerdek da-nu matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nga kardu,” Jesus kathu-yu mampirra. “Thawath wangu nururranu kardu nugarn pana ku prophet thirrukduk-ya ngarra murrinh thathpi Yile neki nukunu mana-wa puddampirrayith pumpan. Mu kardu-ka pumenthart da matha pumpan-ya. Kardu nhini-ka thanthanka da matha purunarranu kathu ngarra nanki nginipunh ku thip mani, mu kardu thathpirr-ka nginipunh ku were pulangarr mani-wa pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","“Mu nanki-ka da mange niranmayenhthenhnu nuru kardu nhini-yu da ngarra mange nhini-re puyemanu puru-yu. Nginipunh nanhthi thay patha mani nganaka, mi dhepdhep patha da matha memkalele dim. I thay nanhthi wiye-ka mi dhepdhep wiye da matha memkalele wurran. I mi kumpampa mani-ka mere karuy ngarra thay mululumpu-yu, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mi dhepdhep wiye-ka mere ngarra karuy ngarra nanhthi thay patha. I mi dhepdhep patha-ka mere ngarra karuy ngarra nanhthi thay wiye, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I nanhthi thay wunku mi dhepdhep wiye ngatha pirranu-ka nhini kardu-ka bartal-wa thay nhini-yu i kunuku ngarra thungku wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","I nginipunh nhini mani nanki-ka niranmayenhthenhnu nuru ku prophet thirrukduk nhini-yu ngarra mange nhini-re puyemanu puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“I nga, murrinh numi warda manarranu,” Jesus kathu-yu mampirra. “Kardu terert da matha pumamnga pumpan, ‘Pule.’ Mu kardu mere terert nhini thathpirr kuyu nukun da pangu ngarra da Heaven thathpirr kuyu nukun da pangu ngarra da Heaven i bere matha wangu parninu pangu-yu, wurda. Mu kardu pana da matha ngarra murrinh thathpi Yile ngay nukunu pubinayepupnu puru i murrinh pumanabathnu puru da ngarra Heaven wangu parninu da bere matha-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Da nakurlnu ngarra kardu wurnangat warda ngatha piramardatnu kumparra warra ngarra Yile neki, kardu terert-ka murrinh pumanganu, ‘Pule, ngankuneme-ka murrinh thathpi Yile neki da matha ngurdinirrayiththa ngurni ngarra kardu warda ngatha. Ngankuneme-ka ngepan wiye wanku ngirranmapuththa ngurni ngarra kardu-yu, i da mange ngalangala ngumerradha ngardi, murrinh ngarra nhinhi da matha ngumenhnhirdarrine ngurni.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Mu ngay-ka murrinh warda marranu ngarra kardu nhini-yu, ‘Ngay-ka kardu mere the mananmath nanki-yu. Mu bere kardu nuru warda ngarra ngay thangunu kathu-yu kardu wiyenan, nhini kardu-ka mere murrinh thathpirr the numengabaththa narni.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nga. Kardu nangkal ngatha murrinh ngarra ngay bingayewupnu purru i murrinh mangabathnu purru, nhini nukunu-ka nginipunh kardu pana mani-wa kardu pelpith patha ngarra thelput nukunu bangarnerde ngarra da palyirr werlpen-darri-ya i da tetemam da matha pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","I nhini thangunu-ka kura ngala warda kanamyel i ngipilinh-ka dempirnturt i manthalert da mana i nanhthi wirrirr lurruth ngala wurrinidha i panmatnintha ngarra thelput nhini-yu. Mu da thelput nhini-ka mere nuykudha, nhini-ka ngarra palyirr thangunu weyida bangarnerde nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Mu nga. Kardu nangkal ngatha murrinh thathpi ngarra ngay bingayepupnu purru i kardu pana mere murrinh mangabathnu-ka, nhini nukunu-ka nginipunh kardu pana mani-wa kardu pelpith wiye ngarra thelput nukunu bangarnerde ngarra da darrimurn kupkup-darri. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","I nhini thangunu-ka kura ngala warda kanamyel i ngipilinh-ka dempirnturt i manthalert da mana i nanhthi wirrirr lurruth ngala wurrinidha i panmatnintha ngarra thelput nhini-yu. I thelput nhini-ka banpek ngala da-matha-nintha nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bere Jesus-ka murrinh warda dampirrarikerdek murrinh ngarra wurdanpunthethith thangunu-yu ngarra kardu. I kardu-ka pumemnamardat ngala da matha ngarra mange Jesus-te wurdininthethiththa dini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nukunu-ka mere kardu pana mani ngarra murrinh law Jews pigunu puddininthethiththa purni, wurda da matha. Mu nukunu wurdininthethiththa wurrini-ka murrinh wunku lurruth ngala da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bere Jesus-ka wurdanthut warda ngarra da palyirr thangunu kathu-yu i kardu wurnangat nimin-ya parraniriwaktha warda purni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bere kardu nugarn numi wunku nanhthi matharr ngala leprosy-ya kanthidha wurrini-ka, wurrininadha ngarra Jesus. I demnawinhipingkarl pangu warra kumparra. I mamna, “Pule, marda ngatha nart-ka nhinhi-ka nangiwathanu kardu darripi tarangka ngurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bere Jesus-ka pirrimnalangma i manthap warda kardu nhini-yu. I mamna, “Yu, ngay-ka marda manganart ngarrim manhiwathanu. Nhinhi-ka kardu darripi tarangka warda thurrunu.” I da nhini-re-ka kardu nugarn nhini-ka kardu patha warda kardidha, i matharr ngala nhini-ka kanampart warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I Jesus kathu-ka mamna, “Nga. Mere nukun thantherr ngarra kardu-yu mange kanhi thangunu mampa-yu. Mu ngarra ku yilarn ngala da matha thununanu thi i nukunu-ka banhinginingkardunu warda nhinhi-yu. I nhini thangunu-ka mampa nukunu-yu, ‘Yu, nhinhi-ka kardu manangka matharr warda kardu darripi tarangka thurran.’ I nhini thangunu-ka ku murrirrbe i ku thip thanamutnu ngarra ku yilarn ngala, i nukunu-ka pinapeknu warda nhini-yu, ku nhini ngarra da murntak warra nukunu murrinh mam Moses thanamutnu-ya. I nhini-ka the warda ngatha pumanhibathnu kardu terert-yu nhinhi-ka kardu tarangka thathpirr warda nhini-yu.” Nhini-wa murrinh-yu Jesus kathu-yu mamna i wurdanthuk warda nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bere Jesus-ka pangu warda wangu nadha dini da nan-nu Capernaum. Bere da ngarra nhini-ka ku pule ngala ngarra ku soldier terert dinirradha-ka ngarra Jesus-nu warda wurrininadha. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I murrinh menadha kardi, “Pule, kardu nugarn numi ngarra wurlk mamnga wurran-ka kardu matharr ngala da matha kabimngurrkurrk pangu-yu ngarra da, i mere ngarra da matha kewirnturt. Nangawatha mani mampa,” kardu nhini kathu-yu danidharrpudha pirri. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Bere Jesus kathu-ka mamna, “Mampa-ya, ngay-ka ngurrunanu i mampawathanu nukunu pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mu ku pule nhini kathu-ka mamna, “Awu Pule. Mere thurru nukun da ngarra ngay nhini-ka thunungiwerdi nukun. Mu kanhi da wangu murrinh thamanu i nhini kardu matharrngini pangu-ka patha warda nangawathanu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngay deyida wanku ku pule ngala dimnga ngarra ngay-yu i ngay-ka ku pule ngala ngempirra ngarra ku soldier ngamere-yu. I ngay mamna kardu ngarra ngay numi, ‘Pangu wangu thunu thi.’ I nukunu-ka nhini wangu nadha dini. I mamna kardu numi, ‘Thurru kathu.’ I nhini-ka nadha warda kathu dini. I mamna kardu numi deyida, ‘Mange kanhi thamanu.’ I nhini nukunu-ka mange nhini-ka mamnga deyida.” Nhini-wa murrinh ku pule ngala soldier nhini mamna ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bere murrinh nhini bimnayepup thangunu-ka, Jesus-ka memnamardat warda thathpirr ngarra kardu nhini-yu. I wurdampirramardarduy warda pirrim ngarra kardu nhini-ya ngarra parraniriwaktha purni. I murrinh warda mampirra, “Nga. Murrinh thathpirr kanhi manarranu-yu. Kardu pule ngala kanhi karrim-ka murrinh thathpirr mamngabath murrinh kardu matharrngini pangu-nu patha mawathanu. Kardu Jews-wa thathpirr mere murrinh thathpirr kumangabath karni-yu mangini kardu pule ngala kanhi mani kardu ngamengka murrinh mamngabath karrim-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","I nga murrinh numi manarranu-yu. Kardu wurnangat da ngamengka pana ngangka-re warda ngatha da nakurlnu puyuwerrnu ngarra da Heaven da ngarra Yile neki nukunu i le thathpirr parninu wunku ngalantharr murntak nan Abraham, Isaac i Jacob puyunu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mu kardu Jews terert nhini ngarra da Heaven puyumardawiththa-ka Yile neki-ka purdunkartelnu da ngarra thipmam binhi wangu-ya, i kardu nhini-ka du ngala parnikarrknu wunku yidingurr ngala da matha da pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bere Jesus-ka murrinh warda mamna ngarra kardu pule ngala nhini, “Nga. Thurdiwurlnu ngarra da, nhinhi-ka murrinh namngabath kardu matharrngini-nu mawathanu-yu, i nhini ngay-ka mampatha warda nukunu nhini-yu.” I bere da nhini thangunu kardu matharrngini nhini-ka kardu patha warda dinidha manangka matharr. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bere nhini thangunu Jesus-ka nungardurr warda i nanadha dini ngarra thelput nukunu-nu Simon. Bere da ngarra thelput nhini Jesus-ka bamkardu pipi nginarr nukunu Simon matharr yungurrkurrktha matharr pimut-wa mebaththa-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bere Jesus-ka wurriningedha i mange manthap. I da nhini-re-ka kardu patha warda dinidha i matharr-ka kanampart warda. I dempirnturt i dinidha warda. I nhini thangunu nigunu-ka mi warda dhepdhep mamnawathawatha. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bere da nhini da ngatha ngarra ngunga thangunu kananthurrk-ka kardu-ka kardu terert ku ngepan wiye wanku panthingkadhuktha punni pumenbertidha punni ngarra Jesus-nu. I bere nukunu-ka ku ngepan wiye terert pirrinmapuththa wurrini ngarra kardu thangunu kathu-yu murrinh ngarra thathpi nukunu-re. I nukunu-ka menpathadha wurrini kardu terert kardu ngarra matharr panthidha punni. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Da murntak warra-ka kardu ngalantharr nan Isaiah ku prophet-ya murrinh ngarra Yile neki wurdanarrayiththa wurrini ngarra kardu. I murrinh nhini yungurrkurrktha murrinh da thathpirr nhini-yu ngarra Jesus menpathadha wurrini ngarra kardu. I kanhi-wa murrinh nukunu Isaiah mam-yu, “Nukunu-ka kardu matharr wurnangat warda ngatha menpathadha wurrini i nhini matharr-ka pirrinmapuththa warda wurrini.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bere nhini thangunu Jesus-ka bampunkardu kardu wurnangat nimin-ya ngarra pubemkardurdu-yu. I nhini-ka murrinh mampirruneme ngarra pulangay nukunu, “Nga peneme. Nurukath-wa-neme ngarra ngipilinh i ngamimarda pangu kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bere kardu nugarn pana ngarra murrinh law kardu Jews pigunu wurdininthethiththa wurrini wurrininadha kathu ngarra Jesus i murrinh mamna, “Ya Pule. Ngay-ka bere matha wangu nganhiriwaknu ngani.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mu Jesus kathu-ka mamna, “Da-ka tetemanthay-wa dardurtnu thurru ngarra ngay thangiriwaknu thani-yu. Nga, ku were pulangarr pumpannupup-ka ngarra da weyi-wa, i ku murrirrbe-ka ngarra da ku dirri pumpannupup. Mu ngay mani, kardu ngarra da kangkarl kathu ngurdamnarrathut-ka kardu manangka da da matha mere ngarra ngadha da-yu nganirrit i nganipup.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bere kardu numi warda ngarra Jesus daniriwaktha wurrini-ka murrinh kathu mamna, “Pule nga. Ngay-ka nganhiriwaknu ngani, mu kuguk da ngatha. Ngay-ka nganinu ngadha ngarra Yile ngay i ngarra pupup da-nu mana. I nhini-ka babirrnu warda. I nhini thangunu ngay-ka nganhiriwaknu warda ngani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mu Jesus kathu-ka mamna, “Kardu pana ngarra mere da ngatha the kumangibath kuru-ka kardu nhini-wa pangu pubanmirrbirrnu puru-yu kardu ngarra pumpanpuwup-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bere Kangkarlmawu-ka kanammardap ngarra tharntu wunku pulangay nukunu wanku parnamkamardapneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bere nanhthi wirrirr ngala pangampirruruyneme wanku kura ngurntinh ngala, i tharntu-ka kura medhalerttha warda wurrini i dedhardumtha warda nhini-yu. Mu nukunu Kangkarlmawu-ka ngurrnguwarl yungurrkurrktha ngarra tharntu tiduk kathu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bere peneme-ka pumamkardurt-warda-neme Kangkarlmawu-yu i murrinh pumamnaneme, “Pule, kardu pangankudhardumnu-warda-neme ngankuneme-yu. Kardu-ka nhinhi-ka nangankuyibirnunu-mani-neme?” Pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bere Kangkarlmawu kathu-ka mampirruneme, “Thangku-dha nankuneme nerremkanhamneme-yu? Nankuneme-ka murrinh nganaka-ya numengabaththaneme-ya ngarra ngay menankuyibirnudhaneme-yu.” Bere Kangkarlmawu-ka dempirnturt warda i banpunkudhapnintha thu wirrirr ngala nhini-yu i kura ngurntinh ngala deyida wanku. I nhini thangunu ngipilinh nhini-ka watmam deyida dinidha. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bere peneme nhini-ka pumemnamardatneme i murrinh pumemnungkuneme mange peneme, “Ya. Kardu kanhi-ka kardu mere nginipunh nekineme mani. Nukunu-ka kardu lurruth ngala nimin-ya. Nanhthi wirrirr ngala i kura ngurntinh ngala wanku deyida murrinh pumamnabathnintha murrinh ngarra thathpi nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bere Jesus i peneme wanku parramkaruyneme da ngamimardi kanhi kathu da ngipilinh ngala nhini, da nan-ya Kadara. I pangu da kardu nugarn perrkenku wurrinininthadha kathu ngarra Jesus-nu da ngarra mintilbith thangunu kathu. Penintha nhini-ka ku ngepan wiye kanthininthadha wurrini i kardu walmamka-wa nhini-yu. I mere nangkal puyidha da pangu ngarra penintha kardininthapuptha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bere penintha-ka pirrimninthakay i murrinh lurruth mamnintha, “Ya, Jesus. Nhinhi-ka wakal Pule ngala nukunu-wa,” mamnintha. “Thangku-nu ngankunintha-nu-yu marda nanganngankurtnintha-yu? Mere thungankubatnintha nukun marra-yu mu kuguk da ngatha i thungankubatninthanu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bere da nhini-re-ka ku pigipigi ku wurnangat pangu wangu pardimurrktha manta ngangka da. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bere ku ngepan wiye nhini-ka pumemnarlupurl Jesus-yu i pumamna, “Nga, nganki ngatha thunganbatnu nhini-ka thurdungankarel pangu da matha ngarra ku pigipigi pangu-yu i ku ngarninnginirdinu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Yu bere-ya. Nuru-wa.” Jesus kathu-yu mampirra. I nhini thangunu-ka ku-ka pungawurr warda kathu ngarra kardu penintha nhini thangunu-yu i parnampart warda i ku ngepan wiye nhini-ka parnampunnginirdi warda nhini-yu. I nhini thangunu ku pigipigi-ka tharra warda dinidha parrampirntigat ngarra palyirr thangunu kathu ngarra ngipilinh ngala da mana. I nhini-ka dampunthiwik warda ku nhini-yu i bangarntikerdek da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bere kardu nugarn pana ngarra ku pigipigi pirapedhaneme parde-ka mange nhini pubamkangkarduneme-ka nhini-ka tharra warda punnungamkawinhatneme i murrinh parraninkuyelerrdhaneme ngarra kardu da pana ngangka-re-ya murrinh penintha-nu ngarra ku ngepan wiye kanthininthadha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bere nhini thangunu-ka kardu wurnangat warda ngatha punninadha pangu-yu i parramnaruy pubamkardu ngarra Jesus. Bere nhini thangunu kardu-ka murrinh warda pumamna ngarra Jesus, “Ya. Nhinhi-ka thunurdurrnu warda marra kanhi-yu da ngarra nganki kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bere nukunu Jesus kanammardap ngarra tharntu i wurdawurl deyida da ngarra da ngamimarda-nu pangu kathu wurrankath da ngarra nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bere kardu ngamere punnenadhaneme ngarra nukunu wunku kardu pulith pumenamathbaththaneme punne ngarra da pit-te. Mu Jesus-ka the menkumabaththaneme pirri ngarra marda peneme-yu murrinh da thathpirr pumamnabathneme nukunu-ka mawathanu patha da thathpirr kardu pulith nhini-yu. I bere murrinh mamna ngarra kardu pulith nhini-yu, “Nga. Da mange wiye pana ngarra nhinhi nebaththa thurrini-ka ngarrimnhimaputh warda-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bere kardu pana ngarra murrinh law kardu Jews pigunu puddininthethiththa purni-ka pubimnayepup warda ngarra murrinh Jesus mamna-yu i murrinh warda pumemnungkuneme mange peneme ngatha, “Ya. Nukunu karrim pana-ka murrinh damnakumugat-wa kanam pana-yu ngarra Yile neki wangu. Nukunu-ka mere ngarra nukun kirramaputh mange da wiye pangu-yu ngarra kardu pulith pangu-yu, wurda. Mu Yile neki da matha kirramaputh da mange wiye pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mu Jesus-ka bangampunkumardeneme mukmuk ngarra kardu peneme nhini-yu, i mampirruneme, “Thangku-nu ngay nubemngayengkarnirnneme nirrim-yu da wiye nginipunh pana mani numamnganeme narnam-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Mu nga. Ngay, kardu ngarra darrikardu nanki thathpirr-ka kardu Pule ngala thathpirr-wa. I ngay mani-ka ngirramaputh-wa da mange wiye-yu kardu ngarra nugarn pulith kabim kanhi-yu. Mu kardu numi ngatha yida nawa kama murrinh kanhi-yu. Mu mere nangkal kama patha mawatha kardu pulith kanhi-yu. I nhini ngay-ka patha thathpirr warda purrulilinu-yu i nhini-ka the warda numabathnu ngay-ka ngirranmaputh da mange wiye ngarra nukunu mebaththa wurrini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bere kardu pulith nhini-ka dempirnturt warda i pangu wangu wurrinililidha ngarra da nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mu kardu wurnangat-ka pubamkardu i perrenham warda i parriniriparldha warda pardi Yile neki-yu. I murrinh pumemnu, “Ya. Nekingime-ka mere ngarra ngadha thubengkardudhangime thani mange nginipunh kanhi mani ngarra kardu thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bere nhini thangunu Jesus-ka kanampart warda da nhini thangunu-yu i mayern warda wurrinililidha. Bere nukunu-ka kardu nugarn bamkardu dinidha ngarra thelput kunungingki ku mani dininmatkuttha ngarra kardu ku Government-nu-wa. I murrinh nukunu kardu nhini-ka nan-wa Matthew. I Jesus kathu-ka mamna, “Ya, kagu. Thurru kathu. Purrunu warda. I kardu thangiriwaknu ngarra ngay warda.” Bere nukunu Matthew-ka dempirnturt i darntiwak ngarra Jesus pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","I bere ngarra thelput nukunu da mana Levi pangamnintharuy mi dhepdhep-nu wunku pulangay nukunu Jesus. I kardu terert deyida wanku purnenadhaneme pangu ngarra Jesus i pulangay nukunu i mi pirrinemurrkthaneme-yu. Kardu ngamere nhini-ka ku mani purninmatkuttha ngarra kardu ku nan-nu Government. I kardu ngamere deyida-ka murrinh law kardu Jews pigunu mere murrinh pumebaththa puyi. Kardu-ka nhini-wa pirrinimurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bere kardu pana nan Pharisees kardu ngarra murrinh law Jews pigunu puddininthethiththa punni-ka pubampungkungkarduneme i pumampirruneme ngarra pulangay nukunu Jesus, “Ya, peneme. Thangku-dha Pule nhinhi-yu parnamkamurrkneme kanhi-yu ngarra kardu wiyepun pana mani-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mu Jesus kathu-ka bimpunkumayepupneme murrinh nhini-yu i mampirruneme, “Nga. Kardu pana ngarra manangka matharr lurruth ngala-ka mere deyida kirranakay ku wanangal-yu. Mu kardu pana da matha matharr wunku nhini da matha kirranakay ku wanangal-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Nga, nubeyengkarnirnnemenu murrinh murntak kanhi yibim ngarra Yile nukunu-yu, ‘Ngay marda mangannanart ngurran nanki-ka kardu thanthanka da matha niyemanu nuru.’ Mu nanki-ka ku numpanthuk numpan ku thip-yu i ninnangampek numpan nhini-ka Yile neki weyida marda numanganart numpan. Mu ngala thathpirr-ka kardu thanthanka da matha nuyemanu nuru-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bere pulangay nukunu John the Baptist mi parnamkapart-ngadha-neme nhini-ka Yile neki ngadha murrinh pardenangerrenthaneme i parraneriparldhaneme parde. Bere kardu punninadha ngarra Jesus i pumamna, “Ya. Pulangay nukunu John the Baptist-ka mi mere da ngatha karnemurrkneme nhini-ka ngarra Yile neki da ngatha parnamnangerrenneme i parramkariparlneme parnamka. I kardu pana Pharisees-ya mange nhini da ngatha pamam pumpan. Mu thangku-nu pulangay nhinhi-yu mange mere nginipunh nhini mani kuyemaneme kuru-yu? Mu kardu ngarra nhinhi pana-ka bere matha wangu mi parnamkamurrkneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mu Jesus kathu-ka mampirruneme, “The mana nanthinkaneme-ya ngarra kardu nugarn-te manganmert kardu palngun i bemnginthalet warda-ka kardu darrikardu nukunu-ka puyemperr warda kardu terert warda ngatha i le da matha nhini-yu. I kardu-ka mere ngarra kanmardathin, wurda da matha. Mu ngarra nugarn nhini-re kumabert mani-ka ngarra kardu darrikardu nukunu kathu-ya, nhini-ka mi dhepdhep-ka karnipart deyida nhini-yu i kanmardathinnu warda ki nukunu-nu-yu. I da mange nginipunh nhini deyida mani ngarra ngay kardu-re pumangibertnu pulangay ngarra ngay thangunu kathu nganinkupartnemenu-ka nhini peneme-ka pankumardathinnemenu i mi dhepdhep-ka parnepart-deyida-nemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bere Jesus kathu-ka murrinh numi deyida mampirruneme, “Nga. Nanhthi kaligu murntak nganaka nanhthi muyu wunku. Mere nangkal ngadha kawarl kani ngarra nanhthi kaligu marra-yu i ngarra kaligu murntak nhini-nu mawathanu-yu. Nhini-ka ngarra napurl-te warda-ka nanhthi kaligu marra nimin-ka wurrannurrurrurr mamkunungingki warda ngarra kaligu murntak thangunu kathu-yu. I nhini ngarra nanhthi muyu ngarra murntak-ka nanhthi muyu ngala warda kirra nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","I ngana deyida mere nangkal ngadha kawinhimardapak kura wine marra-yu ngarra nanhthi pul ku darripi murntak ngananu-yu. Mu mange nhini ngatha kama kurru-ka kura wine marra-ka kurduwi i kururup warda nhini-yu i nanhthi pul ku darripi murntak-ka kingutuy warda i kura-ka kewinhipak warda. I nanhthi pul ku darripi murntak-ka nanhthi wiye warda kirra nhini-yu. Mu kura wine marra ngatha-ka nawinhimardapaknu ngarra nanhthi pul ku darripi marra da matha,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bere ngarra nukunu-re Jesus murrinh nhini pirringerrentha-ka kardu nugarn wurrininadha ngarra nukunu-nu. Nukunu-ka ku pule ngala ngarra da church kardu Jews pigunu. Bere nukunu-ka demnawinhipingkarl ngarra Jesus kumparra warra, i mamna, “Pule nga. Kardu wakal ngay mardinhpuy ngay-ka kardu makardu warda kardu yibimpup. Mu purrunu ngadha ngarra thelput ngay wangu i nathapnu i patha nawathanu i kardu birnu warda paninu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Bere penintha nhini Jesus i Jairus-ka naninthadha warda dini da ngarra nukunu-nu warda wangu nan Jairus. I kardu pulangay nukunu deyida wanku parraneriwakthaneme purne Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bere kardu palngun numi ngangka da matharr kanthidha wurrini. Matharr nhini-ka kardu palngun nukun matharr kumulung-wa, i da bere matha wangu wurrinikutkuttha. Da-ka da pirdithme nimin-ya mebaththa wurrini-yu da thangku 12-wa. Bere nigunu nhini-ka tiduk wangu wurrininadha ngarra Jesus i mammathap ngarra nanhthi kaligu nukunu da mana ngarra bunibalbalktha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I memnu mange nigunu, “Kaligu nukunu ngatha ngarra bardi kurran mathapnu-ka nhini-ka kardu patha warda manangka matharr ngurrunu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bere Jesus-ka wurdarduy i bamkardu nigunu nhini-yu i murrinh warda mamnge, “Nga. Nhinhi-ka kardu patha warda manangka matharr thempirntiway thirrim pana-yu, nhini-ka ngarra ngay thangunu murrinh namngabath mamnhiwatha nhini-yu.” Bere da nhini-re-ka nigunu-ka patha warda kardidha, manangka matharr warda nigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bere Jesus i Jairus-ka puy wangu naninthadha dini i pangamnintharuy warda ngarra thelput nukunu Jairus. I Jesus-ka bamkardu kardu ngarra tharrmanthi-nu ngarra pubabirrnu i kardu terert du pardikarrkmardadha. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I bere Jesus-ka murrinh mampirra kardu terert nhini-yu, “Ya, nungiwuy warda kardu terert. Kardu mardinhpuy pana kabim-ka mere yungipuptha, mu kardu ngurrnguwarl da matha yibim.” Mu kardu kathu-ka pangankampa warda ngatha ngarra nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bere ngarra Jesus kardu yunganpunnurr warda ngarra thelput thangunu kathu-ka, nukunu-ka kanardi ngarra nigunu da ngarra kardu mardinhpuy nhini yungurrkurrktha i mange ngarra nigunu manganmart i nigunu-ka dempirnturt warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bere nhini thangunu-ka murrinh nhini ngarra Jesus medha wurrini-ka bamlang da pana ngangka-re warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bere nhini thangunu Jesus-ka nungardurr warda da nhini thangunu-yu. Bere ngarra nukunu-re nalilidha dini-ka kardu kamarrama perrkenku warda danininthariwaktha wurrini i purnenakaykaydhanintha, “Pule, kardu tharntethbath ngarra King David, panhingarrumardathin-ngadha-nintha ngankunintha-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bere Jesus-ka ngarra thelput warda kanardi. I penintha nhini deyida-ka parnamnardinintha. Bere Jesus kathu-ka mampirrunintha, “Nga. Nankunintha-ka murrinh numamngabathnintha kamarl ngarra nankunintha manankungkawathaninthanu-yu?” “Yu, pule,” pumamnanintha. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bere Jesus-ka menkungkadhadhaptha-warda-nintha pirri kamarl ngarra penintha-yu, i murrinh mampirrunintha, “Nankunintha-ka murrinh numamngabathnintha ngay-ka kamarl patha warda manankungkawathanintha-nu, nhini ngay-ka manankungkawatha-warda-nintha kamarl ngarra nankunintha-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bere kardu kamarrama nhini-ka kamarl patha warda kardininthadha i wurrinininthabirlbirldha warda. Bere Jesus kathu-ka mampirrunintha, “Nga. Mere nukun nankuyelerrnintha nuru ngarra kardu terert-yu mange kanhi thangunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mu penintha nhini-ka da pana-re naninthalilidha dini i murrinh nhini banninthalang-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bere ngarra kardu kamarrama nhini nungamninthardurr warda-ka kardu ngamere kathu punninadha ngarra Jesus wunku kardu nugarn numi nhini mere ngarra murrinh kaningerrentha. Ku ngepan wiye wanku kanamnginirdi ngarra ngepan nukunu i mere warda wurringerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bere Jesus-ka nungammaku warda ku ngepan wiye ngarra kardu nhini mebaththa wurrini-yu i nukunu nhini-ka murrinh warda wurriningerrentha. Bere kardu terert-ka pumemnamardat warda ngarra Jesus, i murrinh pumenanudha purni, “Ya. Nekingime-ka mere ngadha thubemangkardudhangime thani mange ngala nginipunh kanhi mani-yu da ngarra Israel kanhi-yu, wurda da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mu peneme pana kardu nan-ya kardu Pharisees-ka murrinh pumenanudhaneme purne mange peneme, “Ya. Nukunu pana-ka ku karrath kathu nanhthi lurruth ngala damnamutmut wurran i da-ka nhini weyida pirrimpunmaputh wurran ku ngepan wiye wiye ngarra kardu thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Bere nhini thangunu-ka Jesus wurriniwattha da ngarra town terert da matha i ngarra murrinh church terert kardu Jews pigunu murrinh daninthelerrdha wurrini ngarra kardu Yile neki thathpirr-wa ku Pule ngala thathpirr-yu i pirranpenu pani kardu ngarra nukunu-yu. I kardu matharr-wunngini wunku menpathadha wurrini, nanhthi matharr terert warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bere ngarra Jesus bampunkardu warda kardu wurnangat nhini-yu nukunu-ka dampirramardathin warda nhini weyida ngangka da pirriningkadhuktha-yu nginipunh ku thip mani ngarra kardu mere nangkal ngadha dirranpedha kani. I kardu-ka mere ngarra pumenumanpidha pardi. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bere Jesus murrinh warda mampirruneme ngarra pulangay nukunu, “Nga. Kardu wurnangat terert nimin-ya parnam da ngarra putek ngala kanhi. Mu nanki-ka kardu mere thathpirr terert nhini-yu i mere ngarra nanthelerr nukun murrinh ngarra Yile neki nukun kardu ngarra wurnangat kanhi warda ngatha. Kardu mani bangkardu mi thungku dim-ka mere ngarra murartal mi terert warda ngatha mange nukunu ngatha-yu, mu nhini-ka kardu terert da matha kirrarrakay kumamanpi. ");
INSERT INTO mwf2018_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","I nanki deyida mani nadharrpunu Yile neki kardu-nu pumananmanpinu murrinh thathpi ngarra nukunu panthelerrnu puru ngarra kardu wurnangat kanhi warda ngatha parnam ngarra da putek ngala kanhi.” ");
INSERT INTO mwf2018_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Bere Jesus-ka pirrimpirrukayneme panpunkuwerrneme kardu ngarra nukunu kardu peneme 12 nhini-ya. I ngepan lurruth ngala dampirrumutneme ku ngepan wiye-nu pirankumaputhnu-warda-neme ngarra kardu thangunu kathu-yu. I kardu matharr-wunngini-nu pumankuwathanemenu puru kardu patha-nu, nanhthi matharr pana warda ngatha wurran-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I kanhi-wa kardu murrinh peneme-yu kardu pulangay nukunu Jesus, ku apostle-ya. Marra-re-ka nukunu Simon, kardu nhini-ya Peter pumengkawadhadha pardi, i ngathan nukunu Andrew-ya. I piguna James i John wakal ngarra nukunu Zebedee-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","I nukunu Philip-ya, Bartholomew, i Thomas. I nukunu Matthew kardu pana-ya ngarra ku mani wurrininmatkuttha kathu ngarra kardu ku Government-nu. I nukunu James, wakal ngarra nukunu Alphaeus. I nukunu Thaddaeus. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","I Simon Patriot, i nukunu Judas Iscariot, kardu pana-ya ngarra Jesus da nakurl-te dampirramut kardu ngarra wiyenpun-nu wangu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bere ngarra mayern-nu warda purdunkuthuknemenu peneme nhini kardu 12-ya, Jesus-ka kanhi-wa murrinh mampirruneme-yu, “Nga peneme. Nurnewatnemenu da pana ngangka-re-ya da ngarra kardu Jews da matha parnamkadhuk-yu. Mu mere nurnewat-nukun-neme da pangu wangu kardu pana ngarra mere thathpirr Jews pigunu-yu, i da nan-nu-ya Samaria. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mu pangu da matha nurnewatnemenu kardu ngarra da Jews pigunu da ngarra Israel-ya. Kardu nhini-ka kardu nginipunh ku thip mani parnawarrk-ya, kardu puyenthekum warda Yile neki-nu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nurnewatnemenu i murrinh kanhi nuddurrayithnemenu nuru, ‘Nga kardu. Da-ka manta warda da kurran kathu-yu ngarra Yile neki-re ku Pule ngala thathpirr warda pinarranu ngarra kardu wurnangat warda ngatha.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","I mampirru-deyida-neme Jesus kathu-yu, “Nga. Kardu matharr-wunngini numankuwathanemenu nuru kardu patha warda ngatha parninu. I kardu ngatha kupup deyida pana-ka nhini-ka nuddunkabirl-deyida-nu nhini-yu. I kardu nhini deyida wanku nanhthi matharr leprosy panthin pumpan, numankuwathanemenu nuru kardu darripi tarangka warda parninu. I ku ngepan wiye ku terert nirankumaputhnemenu nuru ngarra kardu thangunu. Nga, ngay-ka ngurdinankuyethiththaneme ngurrini i ngepan lurruth ngala wanku ngamnarrumutneme. I ngay-ka mere ngenankudharrpudhaneme ku mani-nu-yu nawa? I da mange nginipunh nhini mani nankuneme-ka mange patha da matha numarrunemenu nuru ngarra kardu terert i mere nankudharrpu-nukun-neme nuru ku mani-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“I nga numi-yu,” Jesus kathu-yu mampirruneme. “Ngarra nunnardurr-re-neme-nu-ka ku mani-ka mere nukun numabathneme nuru. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","I nanhthi bag mi dhepdhep nukunu-ka mere numabathneme. I nanhthi thingkilit numi deyida i me put numi deyida mere numabath-nukun-neme nuru. I nanhthi thay ngarra wilili nukun mere numi deyida numabath-nukun-neme. Nankuneme-ka wurlk ngarra Yile neki nukunu nuyemananemenu nuru, nhini-ka kardu pangu-ka mi i nanhthi warda panarrumutmutnemenu parne i piranankupenemenu parne nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“I ngarra da town ngala kama i da kunungingki ngatha kama narurtuynemenu-ka, marra-re-ka kardu patha warra ngadha nubardurtnemenu. I ngarra nukunu nhini da matha nenemenu-yu i ngarra nunnardurr-da-nu-mana-neme da numi deyida-nu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","I ngarra thelput nhini-re narnerdinemenu-ka murrinh-ka kanhi-wa numarrunemenu ngarra kardu-yu, ‘Nga, Yile neki pirrananpenu pani.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","I kardu nhini-ka le ngatha parninarrunemenu ngarra thelput nhini nenemenu-ka, nhini Yile neki-ka pirranpenu thathpirr pani kardu nhini-yu murrinh nginipunh numampirruneme pana-ya. Mu mere ngatha le kuyunarrunemenu da ngarra thelput nhini nenemenu-ka, nhini-ka murrinh numankumartnemenu murrinh pana-ya ngarra numampirruneme-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“I nga numi-yu,” Jesus kathu-yu mampirruneme. “Mu da numi ngatha naruy-deyida-nemenu-ka i kardu mere ngatha deyida le puyunarrunemenu i mere murrinh kubinarruyepupnemenu-ka, nhini-ka ngarra da nhini narnepartnu-re-neme-ka me sandal-ka nunguynumewurrnemenu i putek ngarra me sandal pepe thangunu-ka nuyunumerurtulnemenu. I kardu terert nhini-ka pubanankumangkardunemenu i the warda pumabathnu Yile neki-ka mere warda pirranpenu pani nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“I nga, murrinh thathpirr kanhi manarrunemenu-yu. Kardu murntak pana nganaka ngarra da Sodom i Gomorrah pardidha-ka, da wiye wiye thathpirr pumedha pardi. I da nakurl deyida-nu kardu nhini-ka piramardatnu kumparra warra ngarra Yile neki, i da nhini-nu-re-ka da wiye thathpirr pirrarranu kardu nhini-nu-yu. Mu kardu pana nimin ngarra mere le puyunarrunemenu-ya ngarra da town nhini naruynemenu-ya nhini-ka da-ka wiye ngala thathpirr warda pirrarranu kardu nhini-nu-yu da nakurlnu-ya ngarra kardu wurnangat warda ngatha piramardatnu kumparra warra ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“I nga numi-yu,” mampirruneme Jesus kathu-yu. “Ngay-ka ngurdunankuthuknemenu kardu ngarra murlakpun deyida wangu, i kardu nhini-ka mere le kuyunarrunemenu. Nankuneme-ka mangini ku thip mani ngurdunankuthuknemenu pangu wangu-yu ngarra ku were pulangarr ngala mani wangu. Nhini nankuneme-ka kardu thawath da matha nanemenu i yarrarr numangkanemenu nuru nginipunh ku pangkuy mani-ya, i ngana deyida thu kuy-ka wurda-wa, kardu thanthanka da matha nanemenu nginipunh ku yinpi mani deyida. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","I thawath da wangu nanemenu, nhini kardu ngamere-ka ngawurt warda purunankungawurtnemenu i ngarra murrinh court-nu warda wangu pumanankubertinemenu puru, i thu whip-te pumanankulalarrnemenu parni da ngarra church pigunu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I kardu nhini-ka mange lurruth-te panankuwurrnemenu i pumanankubertinemenu puru ngarra ku pule ngala ngala-nu wangu. I pubunankupaknemenu kumparra warra ngarra ku pule ngala ngala nhini-nu wangu-yu. Da terert nhini-wa pumanarrunemenu puru nhini nankuneme-ka kardu ngarra ngay weyida. I nankuneme-ka murrinh ngarra ngay nuddurrayithnemenu nuru ngarra ku pule ngala ngala nhini-nu-yu i ngarra kardu pana deyida wanku kardu mere Jews-ya nuddurrayithnemenu nuru murrinh thathpi ngay-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","I nga. Ngarra kardu-re pumanankubertinemenu puru ngarra murrinh court-nu wangu-ka mere numenungkumardawerr-nukun-neme murrinh ngarra numarrunemenu ngarra kardu pule ngala ngala pangu-yu. Mu pangu da Yile neki kathu panarrumutnemenu ngarra murrinh numarrunemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I Ngepan ngarra nukunu-re manankudhawiyithnemenu-yu i nhini-ka mere murrinh ngarra nankuneme-re nururrungerrennemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“I da nhini-nu-re-ka kardu ngarra darrikardu nankuneme deyida thu kuy purunarrunemenu-yu nginipunh kanhi mani-ya. Kardu nugarn ngathan nukunu mabertinu purru pangu da wangu ngarra kardu murlakpun thu pubatnu parni i purdurinuminu. I yileyile-ka wakal nukunu mabertinu pangu warda wangu kardu-nu thu pubatnu parni i purdurinuminu. I kardu wakal deyida-ka yileyile i kalekale nukunu pangu warda wangu mankubertinungintha purru kardu-nu thu punkubatnungintha. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","I kardu wurnangat-ka mere marda pumanankurtnemenu nhini-ka kardu ngarra ngay weyida nankuneme-yu. Mu kardu nangkal ngatha bere matha wangu pangiriwaknu purru i mere kaningipart nukun-ka, kardu nhini-ka kardu bere matha wangu paninu ngarra Yile ngay. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“I nga murrinh numi kanhi manarrunemenu-yu,” Jesus kathu-yu mampirruneme. “I da ngarra narurtuy-re-neme nuru-ka i kardu ngatha da tetemanthay pubunarrupaknemenu-ka, nhini-ka nunnawinhatnu-warda-neme i ngarra da numi wardarra nanemenu. I nga, murrinh thathpirr kanhi manarrunemenu-yu. Nankuneme-ka da pana-re nurnewatnemenu da ngarra Israel i murrinh ngarra ngay nuddurruyithnemenu nuru. Mu ngay, kardu da ngarra Heaven thangunu kathu ngurdanthut-ka, ngurdiwurl-deyida-nu kathu ngarra mere da ngatha murrinh ngay ngarra kardu numarrurikerdeknemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“I nga,” mampirruneme Jesus kathu-yu. “Ngay-ka mukmuk ngala nganthin ngem i ngurdannankuyethithneme nganam. I ngay-ka kardu pule ngemnarruneme, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I nhini nankuneme-ka ngurdannankuyethithneme murrinh ngarra ngay thangunu, i numangirartnu-warda-neme, i nhini-ka patha thathpirr narnenemenu. I kardu-ka da tetemanthay pubanngapak ngay-nu-yu i ku karrath ngatha yida pumengadha pardi. I nhini kardu-ka da wiye thathpirr warda pumanarrunemenu ngarra nankuneme-yu, nhini nankuneme-ka kardu ngarra ngay weyida nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nga. Kardu thangku ngatha mange nhini pinumardarriwupnu parni ngarra mange pumanarranemenu-ka, nhini-ka da nakurl-te warda the pumabathnu kardu wurnangat warda ngatha ngarra nukunu Yile neki-re warda manmardarripurlnu. Nhini murrinh manarrunemenu-ka mere nukun nenkumanhamneme kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","I murrinh kanhi ngarra nankuneme da matha menarrudhaneme ngurrini-ka nhini-ka ngarra kardu terert warda ngatha murrinh nuyemarranemenu nuru, pilampirdarri da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“I nga. Mere nenkumanham-nukun-neme kardu pana-yu ngarra thu kama kunankuthukneme. Kardu nhini-ka nanhthi nginipunh ngarra nankuneme da matha punankuthuknemenu, mu mere ngarra kunankumabatneme nanhthi ngepan ngarra nankuneme-yu, wurda. Mu Yile neki da matha nemanhamnemenu nuru-yu, nukunu da matha kardu mani pirranputhnu ngarra da thungku ngala wangu, da nan Hell, nanhthi nginipunh-ya i nanhthi ngepan wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nga, ku murrirrbe purrkpurrk nganaka, ku-ka ngathayida-wa nawa? I ku ngatha thelim nuyemanu-ka nhini ku mani wakal da matha numart. Mu Yile ngay-ka the kanthin ku terert nhini warda ngatha-yu. I ku numi ngatha buybat i kupup nhini nukunu-ka the kanthin ku murrirrbe nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I nanki deyida wanku the kanthinnan. I thangku numa ngatha nanhthi pemarr ngarra pelpith nanki nanthin numpan-ka the deyida kanthin nukunu Yile ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nhini ngay murrinh manarranu-ka mere nenham nukun nuru, nanki-ka ngala thathpirr nimpunpewal ngarra ku murrirrbe-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“I nga murrinh numi-yu,” Jesus kathu-yu mampirruneme. “Nankuneme-ka kardu ngay-wa. I kardu ngatha murrinh nuyemarranemenu nuru nankuneme-ka ngarra ngay da matha narramngiriwakneme numpanka, nhini ngay-ka murrinh mananu deyida ngarra Yile ngay wangu da kangkarl dim, nankuneme-ka kardu ngarra ngay nukun-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mu kardu nangkal ngatha ngarra kardu ngamere-nu wangu murrinh kanhi marranu, ‘Ngay-ka mere ngariwak ngurru Jesus-yu’, nhini ngay-ka mananu deyida ngarra Yile ngay wangu, ‘Kardu pana-ka kardu mere thathpirr ngarra ngay nukun pana-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“I nga numi-yu. Nankuneme nuyemamka-mana-neme ngay-ka ngurrinidha da putek ngala kanhi-nu da mange watmam-nu mebaththa? Mu wurda, kardu-ka thu puyunuthuknu puru nhini-ka ngarra ngay thangunu weyida nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nginipunh yileyile mani thu kuy purrunanu ngarra wakal nukunu, i kalekale mani thu kuy deyida purrungenu ngarra wakal nigunu. I wunku marda pipingintha mani thu kuy paninginthanu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","I kardu nangkal ngatha ngarra ngay pangiriwaknu purru-ka i kardu nhini-ka thu kuy deyida purunanu ngarra kardu darrikardu nukunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“I nga murrinh numi manarrunemenu-yu,” Jesus kathu-yu mampirruneme. “Nankuneme-ka ngay-wa thathpirr kumparra marda numangertnemenu nuru-yu ngarra yileyile i kalekale nankuneme-yu. I ngana deyida nankuneme-ka ngay-wa thathpirr kumparra marda numangertnemenu nuru-yu ngarra wakal nankuneme wangu-yu. Mu mere ngatha marda thathpirr numangertnemenu nuru nginipunh nhini mani nankuneme-ka mere warda kardu ngarra ngay nurunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“I kanhi numi-yu. Kardu-ka da tetemanthay da matha pubungapaknu ngay-nu-yu. I thu pungibatnu parni i ngay-ka ngupupnu ngarra thay kathu nginthanu. Mu nanki ngatha kardu ngarra ngay narni-ka, nhini kardu-ka mange nginipunh nhini deyida mani kumanarra kama-ya. Mu mere ngatha nangiriwaknu nuru nginipunh nhini mani, nanki-ka mere ngarra nuru nukun kardu ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mu kardu nangkal ngatha marda mart menuyibirnunu i da mange ngarra nukunu da matha pamanu purru, nhini nukunu-ka pupup da matha-nu nhini-yu. Mu kardu nangkal ngatha puynuyekumnu thathpirr i ngay da matha kumparra bungipaknu, nhini nukunu-ka kardu bere matha wangu birnu paninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nga. Kardu ngatha pubinarrayepupnu i le puyunarranu da ngarra pigunu-ya, nhini-ka ngay deyida wanku le puyunganu nhini-yu. I ngana deyida le puyunanu nukunu nhini kardu ngarra ngay wurdanngithuk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","I kardu nangkal ngatha pubinayepupnu ku prophet, kardu pana ngarra murrinh thathpi Yile neki nukunu wurdampirrayith wurran, nhini Yile neki-ka mange patha marranu purru da mange patha nhini deyida mani ngarra ku prophet mamna wurran-ya. I ngana deyida kardu nangkal ngatha pubinayepupnu kardu patha ngarra Yile neki darntiwak wurran, nhini Yile neki-ka mange patha marranu purru da mange patha nhini deyida mani ngarra kardu patha nhini mamna wurran-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“I nga murrinh tiduk kanhi manarranu-yu. Kardu nangkal ngatha kanamut kura burrburr kardu ngarra ngay-nu-ya, kardu ngathayida-ya, nhini Yile neki-ka nanhthi thangku nanhthi kama-ya patha panamutnu ngarra kardu nhini-yu.” Jesus kathu-yu mampirruneme ngarra pulangay nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bere, Jesus-ka murrinh dampirrurikerdek-warda-neme murrinh ngarra wurdininkuyethiththaneme kardi ngarra pulangay nukunu-yu. I nhini thangunu-ka nungardurr warda da nhini thangunu-yu i pangu warda wangu da nan-nu Kelili nadha dini i murrinh ngarra Yile neki nukun wurdininthethiththa wurrini da ngarra town terert nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bere nukunu John the Baptist-ka ngarra da jail dininganamardadha da nhini-re-yu. Mu nukunu-ka pamnayepup Jesus da mange ngala ngala nhini medha wurrini. I nhini nukunu John the Baptist-ka murrinh warda wurdanmathuk kardu ngarra pulangay nukunu-re pumenabaththaneme tharra ngarra Jesus-nu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","I pumamnaneme, “Ya. Nhinhi da kardu Pule ngala-yu ngarra nukunu John the Baptist mengarradha wurrini-yu purrunu kathu-yu? Nhinhi da kama kardu-yu i kardu numi deyida kama da nakurl karuynu i nukunu nhini kama ngarninamardamardanu-yu?” Peneme nhini-re kathu parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mu Jesus kathu-ka mampirruneme, “Nga. Nuddenawurlneme ngarra nukunu John the Baptist i murrinh numananemenu da mange kanhi ngarra nubengimangkardudhaneme nurne-ya i murrinh ngarra kardu kathu pumenarrudhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kardu kamarrama-ka pumpanmirlbirl warda, i kardu pulith parnalili warda. I kardu ngarra matharr leprosy pumebaththa purni-ka kardu tarangka warda pumpan. I kardu ngarra the wiye-ka pubinthewup warda pumpan nhini-yu. I kardu ngarra marra purniwuwuptha-ka birnu deyida pumpan nhini-yu. I kardu ngarra mananhthi-wunka-ka murrinh pubimnayepup warda pumpan murrinh thathpi ngarra Yile neki nukun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","I kanhi numi-yu. Nga. Kardu nangkal ngatha bere ngatha wangu murrinh mangabathnu purru i mere kaningipart nukun, kardu nhini-ka le da matha paninu nhini-yu. Nhini-wa murrinh-yu numananemenu ngarra nukunu John the Baptist-yu.” Jesus kathu-yu mampirruneme kardu ngarra pulangay nukunu John the Baptist-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bere ngarra peneme nhini-ka punnungamkardurr-warda-neme, i Jesus murrinh warda wurdampirrayith ngarra kardu terert murrinh ngarra nukunu-nu-ya John the Baptist. I mampirra, “Nga kardu. Da marra-re nganaka ngarra nanki-re da pangu wangu ngarra da darrinpirr pularn nunninadha John the Baptist-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? Kardu manangka lurruth ngala kama numenadha nurni-yu nginipunh nanhthi parnu mani wurdanparl pirrim nanhthi wirrirr-te-yu? Mu wurda nawa nukunu-yu? Nukunu-ka kardu lurruth ngala da matha kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","I ngana deyida nunninadha ngarra nukunu-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? I numenadha nurni nanhthi kaligu patha patha kama banardurdidha wurrini? Mu wurda nawa? Kardu pana ngarra kaligu patha patha pubardurdi pumpan-ka da ngarra thelput ngala ngala da matha pumpannupup-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","I ngana deyida nunninadha ngarra nukunu-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? Nanki-ka numenadha nurni nukunu-ka ku prophet kama i murrinh thathpi ngarra Yile neki nukunu kama wurdanayiththa wurrini? Yu, bere thathpirr-ya. Nukunu-ka ku prophet-wa kanam, ku prophet ngala thathpirr nungampunkuwewurtneme nukunu nhini-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Nga. Ku prophet ngamere murntak warra-ka murrinh parrarntilil murrinh ngarra nukunu-nu-yu John the Baptist. Ku prophet murntak nhini-ka Yile neki kathu murrinh kanhi-wa dampirrumutneme-yu, i mam, ‘Ngay-ka kardu nugarn ngurduthuknu wunku murrinh ngay-yu. Nukunu nhini-ka kumparra warra pununu pi i kardu warda manpathawathanu kardu ngarra nukunu nhini tiduk kathu purrunu-yu.’ Nhini-wa murrinh parrarntilil ku prophet ngamere da murntak warra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nga, murrinh thathpirr kanhi manarranu-yu,” Jesus kathu-yu mampirra. “Nukunu nhini John the Baptist-ka kardu ngala thathpirr-wa kardu nungamnanpewurt ngarra kardu wurnangat kanhi warda ngatha ngarra da putek ngala kanhi narnam-ya, i kardu pana deyida wanku nungampunpewurt kardu ngarra da murntak warra pardingkadhuktha. Mu kardu nangkal ngatha ngarra murrinh thathpi ngay da matha mangabathnu purru-ka nhini nukunu-ka ngala thathpirr-wa punuwewurtnu ngarra nukunu nhini John the Baptist-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“I da ngarra marra-re kathu nganaka ngarra nukunu-re John the Baptist murrinh wurdanarrayiththa wurrini ngarra kardu ngarra da darrinpirr pularn wangu i ngarra marra kanhi da mana, kardu-ka murrinh pamam pumpan-ka, ‘Yile neki-ka ku Pule ngala thathpirr pirranhengimenu-yu.’ Mu kardu murlakpun pamam pumpan-ka, ‘Yile neki mere kirranhe-nukun-ngime wurda da matha nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","I da murntak warra-ka nukunu Moses, i ku prophet terert murrinh puddanayiththa purni ngarra nukunu-nu Yile neki ku Pule ngala thathpirr pinu-yu. I murrinh nhini-ka puddanayiththa purni i ngarra nukunu John the Baptist da mana pangarntuy-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ku prophet murntak nhini murrinh-ka kanhi-wa pumedha purni, ‘Kardu nugarn numi da nakurlnu purrunu kathu, kardu nginipunh Elijah deyida mani pamanu purru nhini-yu.’ Mu ngay murrinh manarranu-ka nukunu nhini ngarra pumedha purni-ka berengunh pangarntuy warda nhini-yu, i nukunu nhini kardu-ka John the Baptist-wa. Murrinh-ka numangabathnu nhini-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nanki-ka murrinh nhini-ya nubingayepupnu i murrinh numangabathnu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“I nga numi-yu,” Jesus kathu-yu mampirra. “Nanki, kardu wurnangat narnam kanhi-ka kardu nginipunh mamay mani narnamyekdhek i narnampirrakaykay ngarra mamay ngamere-ya. I murrinh kanhi numampirra numpan, ");
INSERT INTO mwf2018_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nganki-ka nanhthi dhekdhek ngardirrayekdhektha nanhthi kardu marrit mamngintha-ya ngathayida ngumenthart, mu nanki-ka mere le narnidha nanhthi dhekdhek nhini-nu-yu. I nanhthi dhekdhek ngathayida ku birrbirr ngumenthart-ya, mu nanki-ka mere narnikarrktha.’ Mange nhini mani-wa nanki-ka mere da matha le patha narni.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Nga, ngarra nukunu nhini-re John the Baptist pangarntuy-ka nukunu-ka mi dhepdhep kunungingki da matha kardimurrktha i mere kanigurdugurduktha kura wine-yu. I murrinh numenadha nurni nanki-yu, ‘Nukunu nhini-ka ku ngepan wiye kanthin wurran.’ I kardu nukunu nhini-ka narnampart warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","I ngay, kardu ngarra darrikardu nanki thathpirr ngangarntuy-re-ka mi dhepdhep ngardimurrktha i kura wine ngardigurdugurduktha. Mu kardu-ka numamnga numpan, ‘Ya. Nukunu nhini-ka kardu bere matha wangu mi kanammurrk i kura kanamkurdugurduk-yu. I nukunu nhini-ka wurrannupup-ya ngarra kardu wiyenpun i kardu ngarra ku mani pumpanpunmatkut ku Government-nu-ya,’ numamnga numpan ngarra ngay-nu-ya. Mu nga. Kardu nangkal ngatha ngarra Yile ngay darntiwak wurran-ka nukunu nhini-ka the kanthin da mange ngarra nukunu thathpirr-ka patha-wa nhini-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Bere Kangkarlmawu-ka mange ngala ngala nimin merradha wurrini kardu pangu-nu ngarra da nan pardipuptha-yu, da Korazin i da Bethsaida. Mu kardu nhini-ka mere parniparttha da mange wiye ngarra pumebaththa purni-yu. I bere Jesus kathu-ka nungampirramardawal i mampirra ngarra kardu nhini-yu, “Da-ka wiye thathpirr pirranarranu nanki-nu-yu da ngarra Korazin i Bethsaida narnapup-yu. Mange ngala ngala menarradha ngurrini nanki-nu-yu, mu nanki-ka mere narniparttha da mange wiye nhini-yu. Mu mange ngala ngala nhini da ngatha merradha ngatha kardu pangu-nu ngarra da Tyre i Sidon parnapup-ka, kardu nhini-ka da mange wiye parniparttha-wa da murntak warra i denmardathintha warda thathpirr da mange wiye nhini ngarra pumebaththa purni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“I nga,” Jesus kathu-yu mampirra. “Kardu nhini-ka ngarra da Tyre i Sidon parnapup-ka da nakurl-te piramardatnu kumparra warra ngarra Yile neki-yu, i da-ka wiye pirrarranu kardu nhini-nu da nhini-nu-re-yu. Mu da-ka wiye ngala thathpirr pirranarranu nanki-nu-yu ngarra niramardatnu kumparra warra ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","I nanki-nu ngarra da Capernaum narnapup ngarra kardu numemnungala numpan-ka Yile neki-ka pananpinhithputhnu da ngarra thungku ngala wangu-yu. Ngay-ka mange ngala ngala deyida menarradha ngurrini nanki-nu-yu, mu nanki-ka mere narniparttha da mange wiye ngarra numammath numpan-yu. Mu mange ngala ngala nhini da ngatha merradha ngatha kardu nhini ngarra da Sodom pardipuptha-ka, kardu nhini-ka murrinh pumengabaththa-wa i da nhini-ka bere ngatha pirrangidha-wa marra kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","I ngay murrinh manarranu-ka kardu nhini ngarra da Sodom thangunu kathu piramardatnu kumparra warra ngarra Yile neki wangu-ka da-ka wiye da matha pirrarranu kardu nhini-nu-yu. Mu da nhini-nu-re-ka da-ka wiye ngala thathpirr warda pirranarranu nanki-nu-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bere nhini thangunu Jesus-ka murrinh wurdamnayith ngarra Yile nukunu-nu wangu. I mamna, “Yile, nhinhi da matha Pule ngala thathpirr thim ngarra da kangkarl i da putek ngala kanhi-yu. I ngay-ka ngamnhiriparl ngem nhini weyida da mange ngarra nhinhi thampunkarr wardarra kardu pana ngatha yida, mu mere thenkarrdha da mange ngarra nhinhi kardu ngarra murrinh piyemam pumpan the pumammath pumpan da terert. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yu Yile, nhini da matha mange marda nanganart thim.” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bere nhini thangunu Jesus kathu-ka mampirra kardu ngarra terert-yu. “Nga kardu. Yile ngay-ka murrinh wurnangat warda ngatha banngiwerdi ngarra mukmuk ngay i nanhthi lurruth ngala thathpirr damngamut. I kardu-ka mere thathpirr the numangibath ngay-yu, mu Yile ngay da matha the thathpirr kanthinngi. I ngana deyida mere nangkal the thathpirr mabath Yile ngay-yu, mu ngay da matha wakal ngarra nukunu-ya the nganthin nukunu pangu-yu. I ngay-ka kardu ngamere deyida ngurdunthethithnu ngarra Yile ngay-nu-yu kardu ngarra ngay mampunkarart-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nga. Kardu nangkal ngatha le wiye kani da tetemanthay thangunu bangarnurdurt wurran, nhini kardu-ka purrunganu kathu ngarra ngay, i ngay-ka ngurduwupnu kardu nhini-yu i bayuknu pi i marda pekpek warda paninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","I ngarra ngay da matha pangiriwaknu purru-yu i murrinh thathpi ngarra ngay da matha mangabathnu purru. Ngay-ka kardu thanthanngingka-wa i ngirranganpunpe nganam kardu-yu, i ngay-ka mere menungala ngurru, wurda. Ngarra ngay da matha nurunganu i murrinh numangabathnu nuru i nhini ngepan ngarra nanki-ka patha da matha narninu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Murrinh thathpi ngay-ka mere thathpirr tetemanthay, i da mange ngarra ngay-ka mere deyida tetemanthay nangimariwaknu nuru.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bere nhini thangunu Jesus-ka nungardurr warda da nhini thangunu-yu i pangu warda wangu nadha dini ngarra da church kardu Jews pigunu i kanardi warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","I da nhini da kardu nugarn numi dinidha ngangka da mange wardi punimawerlerldha kardi mange numi-re-yu. Bere da-ka Saturday-wa nhini-yu i kardu peneme pana nan-ya Pharisees kardu pirangkadhaneme pirrine kardu ngarra kama pamanu nukunu Jesus mange ngarra nukunu kardu pangu ngarra mange mamawathanu. Peneme nhini-ka marda pumertthaneme purne nukunu Jesus mange ngarra kardu pangu mamawathanu, i nhini Jesus-ka munmaparlnu warda murrinh law kardu ngarra Jews pigunu-yu i nhini-ka murrinh warda pangkabirrnemenu. Bere peneme nhini-ka parramkadharrpuneme ngarra Jesus, “Ya. Ngarra murrinh law nekineme yibim-yu? Da Saturday kanhi ngarra da nekineme bannhiyukneme-ka mange da patha thathpirr nhini-yu kardu nawathanu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mu Jesus kathu-ka mampirruneme, “Nga. Ku thip ngarra nankuneme kama buybat ngarra da weyi ngala-ya da ngarra Saturday mani-ya, ngarra mani warda niyemanemenu nankuneme nhini-yu? Nankuneme-ka naneme pangu i nungurlartneme ku thip pangu-yu nawa? I nhini-ka numayibirnu-warda-neme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mu ku thip-ka ku da matha nhini-yu. Mu kardu-ka ngala thathpirr-wa nhini-yu, nhini-ka berengunh-wa kardu numanmanpinu nhini-yu i mange patha nuyumarranu nuru da ngarra Saturday mani-yu. Nhini-wa murrinh law nekineme yibim-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bere Jesus kathu-ka mamna ngarra kardu nugarn mange wardi nhini-yu, “Nga. Mange pana ngarra nhinhi thungurathtath-nu.” Bere kardu nugarn nhini-ka mange yungammarathtath i mange nhini-ka patha warda mebaththa pirri nginipunh mange patha numi pangu-re deyida mani mebaththa kardi. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bere nhini thangunu kardu Pharisees-ka pungawurr warda ngarra da church kathu-yu. I murrinh warda puddanayiththaneme pe murrinh ngarra-re da mange nukunu Jesus thu pubatnemenu-yu. Murrinh pumemnungkuneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bere ngarra nukunu-re Jesus panthepup kardu thu pubatnu-ka, nhini nukunu-ka nungardurr warda da nhini thangunu-yu, i pangu warda wangu nadha dini. I kardu wurnangat nimin-ya parraniriwaktha purni. I kardu matharr-wunngini kardu terert warda ngatha menpathadha wurrini pangu da. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","I murrinh warda merradha wurrini kardu terert nhini-yu, “Nga, mere nukun nanthelerr da mange kanhi thangunu menarradha ngurrini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bere, ngarra Jesus da mange ngala ngala terert nhini merradha wurrini-ka nhini-ka murrinh murntak pana ngarra ku prophet nan-ya Isaiah darntilil-ka murrinh da thathpirr nhini-yu. I kanhi-wa murrinh-yu ngarra Yile neki kathu mamna ngarra nukunu Isaiah-yu, murrinh ngarra nukunu-nu-ya Jesus, ");
INSERT INTO mwf2018_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nga kardu. Nukunu pana-ka kardu ngarra ngay-wa i wurlk ngarra ngay mamnga wurran. Ngay-ka memmangkart nukunu nhini-yu, i ngay-ka marda thathpirr manganart ngurran. I ngay-ka le thathpirr ngemna. I ngay-ka bumardardinu ngepan ngay ngarra nukunu wangu-yu, i nhini nukunu-ka murrinh thathpi ngarra ngay purdirrayithnu purru ngarra kardu da mange wiye-nu parnipartnu. I murrinh nhini thangunu ngay-ka kardu warda manthibirnunu da ngarra thungku ngala nhini thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nukunu nhini-ka mere kankabirr nukun ngarra kardu, i mere kanirrawapa nukun. I mere murrinh lurruth nukun purdirrayith purru ngarra kardu terert wangu parningkadhuknu-yu, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I nukunu nhini-ka kardu thanthanka da matha purrurranu ngarra kardu pana manangka lurruth ngala parnam i kardu pana ngarra mere kumenumanpi kuru-yu. I nukunu-ka kardu bere ngatha wangu purdirrayithnu purru murrinh thathpi ngarra ngay da matha i ngarra kardu thathpirr murrinh pumangabathnu puru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","I kardu wurnangat da matha pubinayepupnu puru murrinh thathpi ngarra nukunu i kardu-ka the warda pumabathnu nukunu pirranpenu purru i kardu pule ngala pirranu-yu.” Nhini-wa murrinh nukunu Isaiah darntilil-yu, murrinh ngarra nukunu-nu-ya Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bere nhini thangunu-ka kardu nugarn pumebertidha purni ngarra Jesus. Nukunu kardu nhini-ka ku ngepan wiye kanthidha wurrini, i nhini nukunu-ka mere ngarra murrinh kaningerrentha i mere ngarra kanibirlbirldha. Bere Jesus-ka nungammaku warda ku ngepan wiye ngarra kardu nhini thangunu kathu-yu i nukunu-ka patha deyida kardidha i murrinh warda kardingerrentha i kamarl patha deyida wurrinibirlbirldha. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","I kardu wurnangat pubangammangkardu da mange nhini Jesus mamna-yu i kardu warda pumemnamardat. I murrinh pumemnu, “Ya. Nukunu pana karrim-ka kardu darntethbath kama ngarra nukunu King David thangunu kathu. Nukunu kardu nhini kama ngarra Yile neki mam warra purdunhethuknungime ku Pule ngala pinhenungime. Nukunu da kama kardu pana-yu, na?” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mu bere kardu Pharisees-ka pubimpirrayepup murrinh nhini ngarra kardu pumenanudha purni, i nhini-ka murrinh warda pumampirra, “Awu wurda, nukunu-ka mere wurridha ngarra Yile neki kathu. Mu nukunu-ka ku karrath kathu damnamut nanhthi lurruth ngala pana-yu, i da-ka nhini weyida pirrimpunmaputh wurran ku ngepan wiye ngarra kardu thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bere Jesus-ka the-wa menkumabaththaneme wurrini i nhini-ka murrinh warda mampirruneme ngarra kardu Pharisees nhini-yu, “Nga peneme. Kardu darrikardu ngatha thu kuyunuthuk kuru-ka nhini-ka kardu thu kuyunurikerdek-wa nhini-yu. I kardu darrikardu manta ngatha thu kuyuthuk kuru-ka nhini kardu-ka kuyunurikerdek deyida nhini-yu. I kardu-ka mere warda lurruth parnenungime, i mere warda mitmit parnenungime nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","I mangini nhini mani ku karrath-ka mere kirranmaputh kurru ku ngepan wiye wiye nukunu ngarra kardu thangunu kathu-yu, wurda da matha. Mu nukunu nhini i ku ngepan wiye wiye ngarra nukunu-ka marda ngala da matha parnamkaneme-yu. Mu ku karrath ngatha ku ngepan wiye wiye kirranmaputh kurru-ka nhini peneme-ka mere warda mitmit karnenemenu, i mere warda lurruth ngala karne-nukun-neme, wurda da matha warda. I peneme-ka kuyunungkurikerdek-da-matha-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Nankuneme numamkaneme-ka ku karrath kathu nanhthi lurruth ngala ngarra nukunu damngamutmut wurran ngarra ngay ku ngepan wiye wiye-nu ngarrimpunmaputh ngurran-yu. Mu nga, murrinh kanhi nganankudharrpunemenu, kardu nangkal nimin nanhthi lurruth ngala dampirramutmut wurran kardu ngarra nankuneme ku ngepan wiye wiye-nu pibimpunmaputh pumpan-yu? Nganaka, nangkal nhini-yu? Yile neki nawa nanhthi lurruth ngala dampirramutmut wurran-yu? Mu nhini nankuneme-ka murrinh narrampirrayirrart ngarra ngay-nu-yu numamnganeme ku karrath kathu nanhthi lurruth ngala damngamutmut wurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mu nga. Ngay-ka ngarrimpunmaputh ngurran ku ngepan wiye wiye ngarra kardu thangunu kathu, nhini ngay nganthin ngurran-ka ku ngepan lurruth ngala ngarra Yile neki thangunu kathu-wa. Nanhthi lurruth ngarra ku karrath nukunu-ka wurda-wa nhini-yu. I nhini-ka the-wa numabathnemenu Yile neki kardu Pule ngala wardarra dimpirra kardu ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“I ngana deyida,” Jesus kathu-yu mampirruneme. “Mere nangkal ngadha kanimardi ngarra thelput kardu nugarn lurruth ngala nukunu-yu i mangkardap nanhthi purrkpurrk nukunu-yu, wurda da matha. Mu kardu nhini-ka pumadharrkirrknu warra ngadha kardu nugarn lurruth ngala nhini-yu i nhini-ka nanhthi purrkpurrk nukunu warda pumangkardap nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“I nga numi-yu. Kardu nangkal ngatha mere kangiriwak kurru ngarra ngay, nhini nukunu-ka mere marda thathpirr mangert kurru. I ngana deyida kardu ngatha mere kunperr kurru kardu ngarra ngay-nu, kardu nhini-ka bannganthalang warda-wa nhini-yu ngarra ngay wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“I nga,” Jesus kathu-yu mampirruneme. “Kardu ngatha da mange wiye panipartnu, nhini Yile neki-ka pirramaputhnu i puymayekumnu da mange wiye nhini ngarra mebaththa wurrini-yu. I kardu ngatha murrinh mardarrithaknu ngarra Yile neki wangu, mu da nakurl-te pamardathinnu murrinh nhini thangunu, nhini Yile neki-ka pirramaputh deyida-nu i puymayekumnu murrinh wiye nhini thangunu-yu. Mu nga. Kardu ngatha murrinh mardarrithaknu ku Ngepan patha ngarra Yile neki nukunu i da mange patha nhini mam wurran-ya, nhini Yile neki-ka mere ngarra kirramaputh i mere ngarra kuymayekum murrinh wiye nhini-yu, wurda da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I kardu ngatha murrinh mangirdarrithaknu ngay kardu darrikardu nanki thathpirr-ka nhini Yile ngay-ka puymayekumnu murrinh wiye nhini-yu. Mu kardu murrinh pumardarrithaknu ngatha ngarra Ngepan patha ngarra Yile neki nukunu, nhini Yile neki-ka mere ngarra kuynmayekum nukun murrinh wiye nhini-yu marra kanhi kama, i da nakurl deyida-nu kama, wurda da matha nhini-yu. Nukunu-ka mere ngarra kuynmayekum nukun, wurda da matha.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Bere Jesus-ka murrinh deyida mampirruneme, “Nga. Nanhthi thay wunku mi dhepdhep patha ngatha memkalele wurran, nhini-ka thay patha da matha wurdanturturt wurran. Mu nanhthi thay wunku mi dhepdhep wiye ngatha memkalele wurran, nhini-ka thay wiye da matha wurdanturturt wurran. I mangini nhini mani nubangkardunu i nirathenhnu nanhthi thay patha kama i nanhthi thay wiye kama ngarra mi thangunu kathu memkalele wurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nankuneme-ka kardu wiyenanku-da-matha-neme mangini ku pangkuy murlak mani numamkaneme numpan. Nankuneme-ka murrinh ngarra marda nankuneme thangunu kathu narnamkangerrenneme, i marda ngarra nankuneme-ka wiye da matha nhini-yu. I murrinh patha-ka mere ngarra narnengerrenneme, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nankuneme-ka mukmuk da wiye da matha nubemkayengkarnirnneme numpan i nhini-ka murrinh wiye da matha narnamkangerrenneme ngarra marda nankuneme thangunu kathu. Mu kardu patha ngatha-ka mukmuk patha da matha benthengkarnirn wurran i murrinh patha da matha kanamngerren ngarra marda nukunu thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“I nga, murrinh kanhi manarrunemenu-ka da nakurl-te-nu nganaka ngarra kardu wurnangat warda ngatha piramardatnu kumparra warra ngarra Yile neki, nhini nankuneme-ka murrinh numananemenu thangku-dha murrinh thathpi wiye wiye nhini nardengerrenthaneme-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","I nhini thangunu Yile neki-ka pirranputhnu warda kardu-yu da ngarra thungku ngala wangu-yu nhini-ka murrinh wiye wiye thangunu weyida pardingerrentha-yu. Mu kardu wurnangat ngamere-ka ngarra nukunu da matha puyunu, nhini kardu ngamere nhini-ka murrinh patha patha da matha pumedha purni ngarra da putek ngala kanhi-re pardidha-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bere nhini thangunu kardu Pharisees ngamere i kardu nugarn ngamere pana ngarra murrinh law kardu Jews nukun puddininthethiththa purni-ka murrinh warda pumamnaneme ngarra Jesus, “Ya Pule. Da mange ngala mani nangarru-kathu-neme i ngubanhimangkardunemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mu Kangkarlmawu kathu-ka mampirruneme, “Nga. Nanki-ka kardu wiyenan i mere thathpirr murrinh numanabath nuru murrinh ngarra Yile neki nukunu. I wurda da matha, nanki-ka mere nubangimangkardu nukun da mange ngala ngamanu-yu. Mu nga. Da murntak warra nganaka Yile neki kathu da mange ngala mamna ngarra kardu prophet murntak nhini-nu-ya Jonah. I da mange ngala mangini murntak nhini da matha nubangkardu-deyida-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nukunu nhini Jonah-ka dininganamardadha ngarra marda nukunu ku ngurlmirl ngala da-ka perrenkuneme-wa mam. I nhini thangunu ku ngurlmirl nhini-ka dimme warda nukunu-yu. I mange nginipunh nhini deyida mani ngay, kardu ngarra da kangkarl kathu ngurdamnarrathut-ka kardu nganinganamardanu pepe ngarra da putek ngala kanhi da perrkenkuneme-nu. I da nhini thangunu ngay-ka ngurdingkabirl-deyida-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“I nga. Da nakurl-te ngarra kardu wurnangat warda ngatha niramardatnu kumparra warra ngarra Yile neki, kardu nhini deyida wanku ngarra da nan thangunu-ya Nineveh pardipuptha-ka ngarra Yile neki deyida kumparra warra piramardatnu. Kardu nhini-ka murrinh pubimnayepup i murrinh pumamnabath ngarra ku prophet nhini-ya Jonah murrinh merradha wurrini. I nhini kardu-ka daninmardathintha warda kardi da mange wiye thangunu pumebaththa pardi i parnampart warda nhini-yu. Mu da nakurl-nu-re-ka kardu nhini kathu-ka murrinh pumanarranu, ‘Nanki-ka mere ngadha narniparttha da mange wiye ngarra numebaththa nurni nhini Yile neki-ka ngarra da thungku ngala warda wangu purdunanthuknu.’ I nga, murrinh kanhi manarranu, kardu ngalantharr murntak nhini Jonah-ka kardu ngala-wa nukunu-yu, mu kardu nugarn numi kanhi da karrim kardu ngala thathpirr dimpewal ngarra nukunu Jonah-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“I ngana deyida kardu muthingka ngala pana nganaka da nan thangunu kathu Sheba. Da murntak warra nigunu nadha dini da ngathparr nhini thangunu kathu i murrinh-nu binanayewuptha dini murrinh ngarra nukunu nan-ya King Solomon, kardu nukunu nhini-ya ngarra murrinh mukmuk ngala kanthidha wurrini. I da nakurl-te nigunu wanku kumparra warra pirramardatnu ngarra Yile neki i kanhi-wa murrinh manarranu da nhini-nu-re-yu, ‘Nanki-ka mere ngadha narniparttha da mange wiye ngarra numebaththa nardi, nhini nanki-ka ngarra da thungku ngala da matha nurunu-yu.’ Nigunu kathu-yu manarranu. Yu, nukunu ngalantharr nhini King Solomon-ka kardu ngala-wa, mu kardu nugarn numi kanhi da karrim kardu ngala thathpirr dimpewal ngarra nukunu nhini King Solomon-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bere Jesus-ka murrinh deyida mampirra, “Nga. Ngarra ku ngepan wiye thangunu kardu kanampart-ka, nhini-ka nungawat dim da ngarra demtumtum ngarra kura makura i da-nu dirranganpinhadhath tharra. Mu mere ngatha bardurt da-yu ");
INSERT INTO mwf2018_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nhini nukunu-ka murrinh warda memnu mange nukunu, ‘Aa yu. Ngay-ka ngurdinawurlnu kardu pangu deyida ngarra nganampart i nganinginirdi-deyida-nu.’ “I bere nhini-ka wurdamnawurl pangu deyida, i bangarnurt kardu nhini da ngatha-ka maku da ngatha kanam, mere kaninginirdidha ku ngepan numi thangunu kathu, mu kardu patha i watmam da matha kardidha kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bere ku ngepan wiye nhini-ka mampirrukayneme ku 7 deyida kathu, i ku-ka ku wiyenpun warda thathpirr nhini-yu. I ku-ka parnamkanginirdi-warda-neme kardu nhini-yu i da warda parnamkapupneme. I nukunu kardu nhini-ka kardu wiye thathpirr warda wurran nhini-yu, mu da marra-re-ka kardu nhini-ka wiye kunungingki da matha wurrinidha-yu. I mange nginipunh nhini mani, nanki deyida wanku kardu wiyenan numpan. Mu da nakurlnu kardu wiye thathpirr nurunu mangini kardu kanhi mani ku ngepan wiye parnamkanginirdineme.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bere ngarra Jesus-te murrinh da ngatha wurdinirrayiththa dini-ka, kale nukunu i ngathan nukunu-ka parramkaruyngime ngarra thelput nhini da. Kardu-ka pangu da kathu outside penganadhaydhangime i murrinh puddannathukngime ngarra nukunu-nu Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","I kardu numi kathu-ka mamna ngarra Jesus, “Ya. Kale nhinhi i ngathan nhinhi-ka kanhi kibimkangime nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mu Jesus kathu-ka mamna, “Nangkal nimin ngay-yu kale mamnge ngurran-yu? I nangkal nimin ngay-yu ngathan mamna ngurran-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I daninkardadha warda dini mange ngarra nukunu-re ngarra pulangay nukunu i murrinh warda mam, “Nga. Kardu kanhi nimin karrimkadhuk kale mampirra ngurran-yu i ngathan mampirra ngurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","I kardu nangkal ngatha da mange ngarra Yile ngay nukunu pariwaknu purru-ka, kardu-ka nhini-wa kardu darrikardu ngay thathpirr-yu. Nhini-wa kardu-yu ngathan ngay, munak ngay i kale ngay-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bere da ngunga numi nhini da ngatha Jesus-ka yungawuy ngarra thelput thangunu kathu i nadha dini pangu warda wangu ngarra ngipilinh ngala-nu. I pangu da dinidha da dimunurdi. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bere kardu wurnangat nimin-ya puyemnawerr ngarra Jesus i nhini nukunu-ka ngarra tharntu warda kanammardap dinidha, i kardu-ka pangu-re pidha da ngarra ngipilinh nganangurru. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bere murrinh terert da matha wurdanarrayiththa dini ngarra tharntu thangunu kathu-yu murrinh pana-ya ngarra yungkamnumtha. I murrinh warda mampirra, “Ya kardu. Nubingayepup kathu. Murrinh kanhi-ka murrinh ngarra kardu nugarn wurlk medha wurrini ngarra mi kadin. Bere nukunu-ka mi kamarl mangankut i mi warda kamarl wurriniwuthpuththa weyi ngarra ku puliki meyeththa wurrini nanhthi thay pangkuy wuting-te. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Bere nukunu-ka da pana-re wurriniwuthpuththa. Mu mi kamarl ngamere-ka banawaththa wurrini ngarra mayern i ku murrirrbe-ka pardimurrktha warda mi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","I mi kamarl ngamere-ka banawaththa wurrini ngarra palyirr kurethkurethmam. I mi-ka puddarnturturt pirtpirt da matha nhini-ka putek kunungingki-wa nhini-yu i tukuriki wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mu ngarra ngunga ngala mana warda pirridha-ka nhini-ka mulurn therrke warda dempunmugarl nhini-yu. Nhini-ka ngimalmin mananhthi-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“I mi kamarl ngamere-ka banawaththa wurrini ngarra nanhthi nan wangu mayeyep. Mi-ka pangarntuy i wurda. Mu nanhthi mayeyep-ka nanhthi ngala da matha puddarnturturt i mi nhini-ka pumpanpunpekarl i parrampirradhap mi nhini-yu i pumpanpunthinkun warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“I mi kamarl ngamere mi terert thathpirr-ka banawaththa wurrini ngarra da putek patha. I mi-ka pangarntuy i puddarnturturt da matha i mi terert warda pinthut nhini-yu. Ngamere mi kamarl dhepdhep nhini pinthut-ka mi-ka terert nimin-ya. I ngamere mi kamarl dhepdhep nhini pinthut-ka mi-ka terert tharrngini nhini-yu. I ngamere mi kamarl dhepdhep nhini pinthut-ka mi-ka ngamere da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bere Jesus kathu-ka mampirra, “Kardu nangkal ngatha mangimarta murrinh kanhi-ka, kardu nhini-ka murrinh-ka mabathnu warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bere nhini thangunu-ka pulangay nukunu Jesus-ka purnenadhaneme ngarra Jesus i murrinh pumamnaneme, “Ya pule. Thangku-nu murrinh nginipunh nhini mani thurdampirrayith thurran-yu murrinh pana ngarra yibimkamnum-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bere Jesus kathu-ka mampirruneme, “Yile ngay-ka bannankuwerdi-wardarra-neme da ngarra mange nukunu-yu i da mange ngarra-re ku Pule ngala thathpirr pinu-yu. I mere nangkal ngadha the mebaththa wurri da mange nhini-yu, mu nankuneme da matha the warda thathpirr nanthinkaneme. Mu kardu ngamere pangu-ka Yile neki-ka mere buynperdidha da mange nhini-nu-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Nga. Kardu ngatha bingayewupnu purru ngarra murrinh thathpi ngay i kunungingki mangimartanu, nhini Yile neki-ka kanamut warda mangimartanu ngala da matha. Mu kardu nangkal ngatha mere bingayewup kurru murrinh ngarra ngay, nhini Yile neki-ka mamartnu warda mukmuk kunungingki nhini ngarra kanthin wurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kardu pangu-ka mange pubamngimangkardu pumpan mu mere thathpirr kumangimarta kuru, i kardu-ka pubimngayewup pumpan mu mere thathpirr kumangimarta kuru. Kardu-ka mere warda marda kumart kuru murrinh pumangimartanu-yu, wurda. I da-ka nhini weyida murrinh kanhi ngurdampirrayith ngurran murrinh ngarra yibimkamnum-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Da murntak warra kardu ngalantharr nan Isaiah ku prophet-ya murrinh ngarra Yile neki nukunu darntilil-yu. I murrinh-ka murrinh da thathpirr nhini-yu. I kanhi-wa murrinh darntilil-yu, ‘Kardu-ka mere kumangimarta kuru ngarra murrinh ngay-yu wurda da matha. Kardu-ka mange pubangimangkardunu puru mu mere thathpirr kumangimartanu, i kardu-ka pubingayewupnu puru mu mere thathpirr kumangimartanu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kardu-ka marda wiye pirrim i mutmutwunthe. I kardu-ka kamarl pumpanmirlbirl, mu kardu-ka nginipunh kamarrama mani-wa pumpan. Mu kardu ngatha mange ngarra ngay thathpirr pubengimangkardudha i murrinh pubingayepuptha i puddingawurldha, nhini ngay-ka ngirranginmapuththa warda da mange wiye i buynpaktha kardu ngarra Yile neki nukunu nhini-yu, mu wurda.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bere Jesus kathu-ka mampirru-deyida-neme, “Mu nankuneme-ka kardu mere pangu mani numpankaneme kanhi. Nankuneme-ka mange ngarra ngay nubamngimangkarduneme numpan i murrinh nubimngayepupneme numpan i numpanngimangawurtneme. I nhini nankuneme-ka le patha warda numpankaneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","“Nga. Kanhi-ka murrinh thathpirr manarrunemenu. Da murntak warra-ka kardu nugarn pana nganaka ngarra murrinh Yile neki nukunu puddanarrayiththa purni ku prophet-ya, i kardu ngamere deyida ngarra Yile neki parraniriwaktha purni-ka kardu marda pumerttha purni pubangingkardunu i murrinh ngarra ngay pubingayewupnu puru. Mu wurda, kardu nhini-ka mere pubengingkardudha i mere pubinangayewuptha puyi ngarra murrinh ngay-yu. Mu nankuneme-ka nubamngimangkarduneme i nubimngayepupneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nga, nubingayepup-kathu-neme,” Jesus kathu-yu mampirru-deyida-neme. “Ngay-ka ngurdunarrumeriyithnemenu murrinh pana ngarra kardu mi kamarl wurriniwuthpuththa-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kardu ngamere pubinthepup murrinh thathpi ngarra Yile neki nukunu. Mu murrinh-ka mere kumarta-wa i nhini-ka mere pirdith i ku karrath kathu wurran i manganpunmart murrinh nhini ngarra pubinthepup thangunu-yu. Kardu nhini-ka nginipunh mi kamarl pana mani nganaka ngarra da mayern banawaththa wurrini i ku murrirrbe pana da tiduk-te pardimurrktha mi kamarl nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“I kardu ngamere deyida-ka murrinh thathpi ngarra Yile neki nukunu pubinthepup i murrinh ngadha pumammath i le patha warda parnam-ya. Mu ngarra kardu-re da tetemanthay pubanpirrapak, murrinh ngarra Yile neki nukunu weyida pumammath pumpan-ka, nhini-ka parnampart warda pirtpirt da matha murrinh nhini-yu, nhini-ka mere thathpirr pumeyittha da marra-re-yu. Kardu nhini-ka nginipunh mi kamarl pana mani ngarra palyirr kurethkurethmam banawaththa wurrini i mi pirtpirt da matha puddarnturturt, mu nanhthi ngimalmin-ka mananhthi-wa i nhini-ka mere pirdith dempunmugarl. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“I kardu ngamere deyida-ka murrinh thathpi ngarra Yile neki nukunu pubinthepup. Mu kardu-ka pubenthengkarnirn da ngatha pumpan nanhthi purrkpurrk terert da ngarra da putek kanhi nukun i ku mani deyida marda pumanganart pumpan. I nhini nanhthi nhini thangunu-ka dampirradhap warda kardu ngarra murrinh Yile neki nukunu kumanabathnu thathpirr kuru. Kardu nhini-ka mangini mi kamarl pana mani ngarra nanhthi mayeyep wangu buniwinharrarrdha wurrini. Mi-ka pangarntuy, mu nanhthi mayeyep-ka pumpanpunpekarl i parrampirradhap i pumpanpunthinkun warda mi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Mu kardu ngamere thathpirr warda-ka pubinthepup murrinh thathpi ngarra Yile neki nukunu. Kardu nhini-ka murrinh thathpirr warda pumamnabath pumpan i murrinh pumanganmarta i pumpantet warda parrarntiwak thathpirr warda pumpan Yile neki-yu. Kardu ngamere nhini-ka da mange terert nimin-ya pumpanna Yile neki-nu-yu. I kardu ngamere-ka da mange terert tharrngini pumamna pumpan Yile neki-nu-yu. I kardu ngamere-ka da mange kunungingki da matha pumpanna Yile neki-nu-yu. Kardu nhini-ka nginipunh mi kamarl pana mani ngarra da putek patha banawaththa wurrini. I mi-ka puddarnturturt i mi terert warda pinthut-yu. I mi ngamere-ka mi terert tharrngini pinthut i mi ngamere deyida-ka mi ngamere da matha pinthut.” Nhini-wa murrinh-yu Jesus kathu wurdanpirrumeriyithneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bere Jesus-ka murrinh numi deyida wurdampirrayith murrinh mampunkardarrath-ya. I mampirra, “Nga. Da nakurlnu-re ngarra Yile neki ku Pule ngala thathpirr pirranu ngarra kardu wurnangat warda ngatha, nhini-ka mangini murrinh kanhi mani ngurdinarrayithnu-yu. “Bere kardu pule ngala-ka mi kamarl patha mi yimun-ya bebirrbirrdha wurrini ngarra da putek nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bere, da thipinhi nhini ngarra kardu terert ngurrnguwarl pardingurrkurrktha-ka, kardu nugarn numi kathu nadha dini ngarra mi kadin nhini da. Kardu nugarn nhini-ka mere marda merttha wurri ku pule ngala nhini, i nhini nukunu-ka mi kamarl wiye bebirrbirrdha wurrini ngarra mi kamarl mi yimun wangu-yu, mi nginipunh memninthangkarnu mani. I bere nukunu nhini-ka pangu warda wangu nawinhararttha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","“Bere mi kamarl mi yimun i mi kamarl wiye pangarnturtuy warda i wurdamnintharurturt. I da nakurl-te ngarra mi dhepdhep wanku pangarnturtuy ngarra mi yimun nhini-yu, kardu pana ngarra mi kadin nhini wurlk pumedhaneme purne-ka pangankathenh-warda-neme nanhthi parnu wiye wanku puddanturturt memninthangkarnu. I bere, ngarra ku pule ngala warda purnenadhaneme, i murrinh pumamnaneme, ‘Ya pule. Mi kamarl patha da matha debirrbirrdha thurrini nhinhi-yu nawa? Nhini-ka ngarra-dha kathu nanhthi parnu wiye pangu puddarnturturt pumpan pangu-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I ku pule nhini kathu-ka mampirruneme, ‘Kardu nugarn pana ngarra mere marda mangert kurru mi kamarl wiye pangu bebirrbirrdha wurrini i nanhthi parnu wiye pana warda puddarnturturt-yu.’ I peneme kathu-ka pumamnaneme, ‘Nanhthi parnu wiye pangu-ka ngungumparlarartnemenu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I ku pule kathu-ka mampirruneme, ‘Awu, kuguk da ngatha. Mu ngarra parnu wiye-re nungurlarartneme nukun-ka mi yimun nukun deyida nungurlarartneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mu bere ngatha mi yimun i nanhthi parnu wiye purdinintharurturtnu i ngarra mi yimun da mana mi thungku warda pingkadhuknu. I da nhini-nu-re murrinh kanhi marrunemenu kardu nugarn ngamere pana, “Nanhthi parnu wiye pangu ngarra memninthangkarnu nungurlarartnemenu nuru i numalalarrnemenu nuru i ngarra thungku warda niraputhnemenu. I mi nhini mi yimun-ka nubarartalnu-warda-neme, i nadhakthuknemenu i ngarra thelput ngay mi ngarra dhepdhep nukun nuburdurdinemenu.” ’” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bere Jesus-ka murrinh numi deyida wurdanpunthethith, i mampirra, “Da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Yile neki nukunu i ku Pule ngala thathpirr pirranu, mange-ka murrinh nginipunh kanhi mani-wa ngurdinarrayithnu kanhi. Bere kardu nugarn manganart mi kamarl mi mustard-ya i bangammirr warda ngarra putek. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mi kamarl nhini-ka mi kunungingki thathpirr-wa. I mi wurdarnturturt-ka thay-ka ngala-wa mi wanku-ya. I ku murrirrbe wanku pumpannupup ngarra nithinu thay nhini-yu i ku dirri wanku pumampatha pumpan,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bere Jesus-ka murrinh numi deyida wurdanpunthethith, i mampirra, “Ngay-ka murrinh deyida ngurdiyithnu da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Yile neki nukunu i ku Pule ngala thathpirr pirranu. Bere kardu palngun manganart nanhthi turlurlumam kunungingki i mamkarnu ngarra mi lawam. I nigunu-ka mi ninganthi warda i mi lawam-ka ngala warda dinidha nanhthi turlurlumam kunungingki nhini thangunu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bere murrinh niyith-niyith terert nginipunh nhini mani Kangkarlmawu wurdanarrayiththa wurrini-ya kardu ngarra wurnangat-yu murrinh nginipunh yibimkamnum mani-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Murrinh-ka terert da matha wurdanarrayiththa wurrini da ngarra marra-re kathu Yile neki mampatha da putek ngala kanhi i ngarra marra kanhi da mana. I murrinh terert nhini-ka murrinh ngarra kardu mere da ngatha the pumebaththa puyi. I murrinh-ka nhini-wa kardu ngalantharr murntak ku prophet-ya mam-yu murrinh ngarra Jesus wurdanarrayiththa wurrini-yu. I murrinh-ka murrinh da thathpirr warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bere nhini thangunu Jesus-ka kanampunpart warda kardu wurnangat nhini i pangu warda wangu nadha dini i ngarra thelput warda kanardi. I bere pulangay nukunu kathu-ka pumamnaneme, “Ya pule. Thurdungarrumeriyithnemenu murrinh pana ngarra nanhthi parnu wiye-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bere Jesus kathu-ka mampirruneme, “Kardu pule pana ngarra mi yimun mi kamarl patha-ya bebirrbirrdha wurrini-ka nhini-ka ngay-wa, kardu ngarra darrikardu nanki. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I da putek pana ngarra mi kamarl bebirrbirrdha wurrini-ka mangini da putek ngala kanhi mani-yu. I mi kamarl patha pana-ka mangini kardu ngarra Yile neki nukunu-wa nhini-yu. I nanhthi parnu wiye-ka mangini kardu ngarra ku karrath nukunu mani. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","40","I kardu pana ngarra mi kamarl wiye bebirrbirrdha wurrini-ka nginipunh ku karrath mani-wa nhini-yu. I kardu nugarn pana ngarra mi dhepdhep patha parranedhakthukthaneme parde-ka nginipunh ku angel mani-wa nhini-yu. I ku nhini-ka da nakurlnu pankudhakthuknemenu puru kardu ngarra Yile neki nukunu, i da nhini thangunu da putek ngala kanhi-ka pirtalnu warda nhini-yu. I mange nginipunh nanhthi parnu wiye pana mani parranedhakthukthaneme purne i ngarra thungku warda pibimkaputhneme, kardu wiye deyida panthakthuknemenu puru i ngarra da thungku ngala-nu wangu pirankuputhnemenu puru. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","“I ngay, kardu darrikardu nanki thathpirr-ka ku angel ngarra ngay ngurdunthuknu da pana ngangka-re i kardu wiyenpun da matha panthakthuknu puru i kardu ngamere pana ngarra da wiye-nu pumampuntullul pumpan ngarra kardu-ya. I ku angel nhini-ka pumanyerryerrnu kardu wiyenpun nhini ");
INSERT INTO mwf2018_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","i ngarra da thungku ngala-nu warda wangu piranputhnu kardu wiyenpun nhini-yu. I kardu nhini-ka du ngala da matha parnikarrknu wunku nanhthi yidingurr ngala da matha parninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","I kardu ngarra Yile neki nukunu-ka, kardu pathanpun-ka, da bere matha wangu puyunu i parninu da ngarra nukunu dim, i kardu-ka panlarrangnu pani mangini nanhthi ngunga deyida mani.” I bere Jesus kathu-ka mampirruneme, “Kardu nangkal ngatha mangimarta murrinh kanhi-ka, kardu nhini-ka murrinh-ka mabathnu warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bere, ngarra Jesus-te murrinh nhini darntikerdek-ka nhini nukunu-ka nungardurr warda da nhini thangunu-yu ");
INSERT INTO mwf2018_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","i pangu warda wangu nadha dini wurdawurl da ngarra nukunu. Bere, nukunu-ka kanardi ngarra da church kardu Jews pigunu, i kardu warda wurdininthethiththa dini murrinh ngarra Yile neki nukunu. I kardu-ka pumemnamardat da matha murrinh ngarra pubimnayepup thangunu-yu. I murrinh warda pumenanudha pirrini mange pigunu ngatha-yu, “Ya. Kardu ngarra-re kathu nukunu kanhi kardu mukmuk ngala kanhi kanthin dim-yu? I ngarra-dha kathu nanhthi lurruth ngala kanhi ngarra da mange patha patha kanhi mam wurran-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mu nukunu-ka wakal nukunu ku carpenter-wa nawa? I kale nukunu-ka Mary-wa nawa? I ngathan nukunu-ka James, Joseph, Simon i Judas nawa? ");
INSERT INTO mwf2018_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","I munak nukunu terert-ka kanhi parnapup deyida nawa? Nhini-ka thangku-dha nukunu kanhi kardu mukmuk ngala kanthin kem-yu?” Nhini-wa kardu-yu murrinh pumenanudha pardi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I bere nhini thangunu kardu-ka mere warda pubinanayepuptha. Bere Jesus kathu-ka mampirra, “Nga. Kardu wurnangat warda ngatha pubimnayewup pumpan i murrinh pumamnabath pumpan kardu nugarn pana ngarra murrinh Yile neki nukunu wurdamyith wurran. Mu ngarra da nukunu mana kardu ngarra darrikardu nukunu mana wurdampirrayith-ka, nhini kardu-ka mere warda kubinayepup nhini-yu i mere warda murrinh kumanabath nhini-yu ngarra murrinh thathpi nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bere Jesus-ka mere ngarra ngadha merradha da mange patha patha terert da pangu-yu, nhini kardu mere murrinh weyida pubinanayepuptha puyi i mere murrinh pumenabaththa puyi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bere kardu pule ngala Hered, kardu ngarra da Kelili dinirradha-ka pamnayepup Jesus i da mange patha patha merradha wurrini nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","I nukunu kathu murrinh merradha dini kardu ngarra nukunu, “Ya. Nukunu Jesus pana-ka John the Baptist-wa kardu wurdamkabirl deyida. Nhini weyida da mange patha patha pana mam wurran-yu i kardu lurruth ngala pana kurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Bere da murntak warra-ka kardu pule ngala nhini Hered-ka manganbertnintha ngarra palngun ngathan nukunu nukun Philip. Murrinh nigunu-ka nan-wa Heredias. Bere ngarra da nhini-re nukunu John the Baptist-ka murrinh kanhi kathu mamna ngarra Hered-yu, “Ya. Nhinhi-ka mere neberttha kardu palngun pana-yu. Nigunu-ka kardu palngun ngathan nhinhi nukunu-wa. I nhini-ka da mange wiye-wa nam nhini-yu.” I bere murrinh nhini thangunu nukunu John the Baptist murrinh mamna ngarra Hered-ka, nhini nukunu Hered-ka ku soldier ngarra nukunu wurdanpunkuthukneme nukunu-nu John the Baptist pumabertnemenu i pumadharrkirrknu i panadhapnemenu ngarra da jail. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nukunu Hered marda merttha wurrini-ka John the Baptist thu pubatnu i purdurinuminu mu nukunu-ka dempunmanham ngarra kardu wurnangat nhini, kardu-ka murrinh kanhi pumedha purni, “Ya. Nukunu pana John the Baptist-ka ku prophet thathpirr-wa pana kurran-yu.” Kardu kathu-yu pumam. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bere da ngarra birthday nukunu-re Hered pangamnaruy-ka, nukunu-ka kardu warda dimpirrakay mi dhepdhep-nu pullathnu i le patha parninu. Bere kardu wurnangat warda ngatha pubemnangkardurdu warda. Bere kardu wakal mardinhpuy nigunu Heredias-ya pangampirraruy ngarra kardu terert nhini-yu i kardirrapurrktha nanhthi mampurrkinh. I nukunu Hered le patha nimin diningedha-ya ngarra nanhthi kardipurrktha nigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","I nhini Hered kathu-ka mamnge, “Ya. Thangku ngadha nanhthi marda nanganart nhinhi-yu? I nanhthi ngarra marda nartnu-ka nhini nanhthi-ka ngampamutnu warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bere kardu mardinhpuy ngarra kale nigunu nan Heredias-ya mamnge, “Kale, ngarra murrinh mananu ngarra kardu pule ngala pangu-yu? Thangku nanhthi ngadharrpunu-yu?” Dantharrpu nigunu kathu-yu. Mu kalekale kathu-ka mamnge, “Nga. Thadharrpunu pelpith ngarra nukunu John the Baptist badhamartalnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mu nukunu Hered ngarra murrinh-te bimngeyepup-ka, kardu dammardathin warda. Mu nukunu-ka mere ngarra warda “wurda” mengedha nhini-yu. Nhini-ka murrinh thathpi nukunu wardarra damngemut i kardu terert wanku pubimnayepup murrinh ngarra marra-re mamnge-yu. I bere nhini-ka “Yu berengunh,” mamnge nukunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bere nukunu Hered-ka ku soldier wurdannathuk ngarra John the Baptist-nu i nhini-ka banganthamartal warda pelpith nukunu-yu da ngarra jail-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","I nhini thangunu ku soldier nhini-ka ku pelpith nukunu John the Baptist-ka ngarra nanhthi plate-te mebaththa tharra. I damngemut ngarra kardu mardinhpuy nhini. I kardu mardinhpuy nhini-ka damngemut warda ngarra kale nigunu kardu nan Heredias. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bere nhini thangunu-ka kardu pulangay nukunu John the Baptist-ka purnenadha-kathu-neme i ku nginipunh nukunu pumangankartneme i pubankardineme ngarra da weyi palyirr da. I nhini thangunu-ka parnamnatharrmuneme Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bere ngarra Jesus pamnayepup nukunu John the Baptist pelpith pubanganthamartal-ka nukunu-ka nungardurr da nhini thangunu kathu-yu i ngarra tharntu warda kanammardap i pangu warda wangu nadha dini da ngarra watmam-nu. Bere kardu wurnangat puyemnayepup Jesus nadha dini da ngarra watmam-nu-yu i nhini kardu-ka parnampart da pigunu-yu i parriniriwaktha warda punni ngarra dimunurdi purnimardadha punni. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bere ngarra Jesus nanhthi tharntu thangunu kathu wurdawal-ka, nukunu-ka bampunkardu warda kardu wurnangat nhini ngarra parraniriwaktha purni-yu i nukunu-ka dampirramardathin warda nhini weyida ngangka da pirriningkadhuktha-yu i kardu matharr-wunngini menpathadha wurrini pangu da. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bere da kungini nhini-ka pulangay nukunu kathu punnenadhaneme i pumamna-warda-neme, “Pule. Kardu-ka thurdunthuknu warda ngarra thelput manta manta kanhi nimin pumpan-ya mi dhepdhep-nu parnikutkutnu. Da-ka kungini warda kanhi-yu i mi-ka mami-wa kanhi-yu thanamngime.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mu Jesus kathu-ka mampirruneme, “Awu, kardu-ka bere ngatha puyunu-yu. Mu nankuneme-wa mi dhepdhep narramutnu-yu mi pullathnu kardu kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bere peneme kathu-ka pumamnaneme, “Mi-ka 5 mi lawam nganthinkaneme ngarrim-yu i ku ngurlmirl perrkenku wanku.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bere Jesus kathu-ka mampirruneme, “Berengunh nhini-yu. Mi i ku kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I Jesus kathu-ka mampirru-deyida-neme, “Kardu terert warda ngatha numarranu parniwupnu pangu ngarra parnu.” Bere Jesus-ka mangankut mi lawam 5 nhini-yu i ku ngurlmirl perrkenku wanku. I kangkarl mamka i ngarra Yile nukunu warda mamna, “Mi i ku kanhi patha-wa thamngarramut-yu.” I bere mi nhini-ka mungarnterrarr i dampirrumutmutneme ngarra pulangay nukunu i peneme nhini-ka ngarra kardu warda parranirramutmuttha purne. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mi lawam i ku ngurlmirl nhini-ka Jesus mewathadha pirri-ka mi terert warda nhini-yu i ku ngurlmirl-yu. Kardu wurnangat warda ngatha mi i ku pullamath-yu i kardu-ka bangampunmardan-wa. Bere nhini thangunu peneme nhini-ka punnekutkutthaneme mi i ku ngarra kardu thangunu parraniritmuttha punni. I nanhthi thelerrtherr nanhthi 12-wa pumedhalertertthaneme punne-yu mi i ku titmut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kardu wurnangat warda ngatha kardu nugarn kardu palngun kardu mamay mi i ku pullamath-yu. Kardu nugarn da matha-wa 5,000 pangu pirrinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bere nhini thangunu Jesus-ka murrinh mampirruneme ngarra pulangay nukunu, “Nga peneme. Ngarra tharntu warda narnemardapneme i kumparra warra nanemenu da ngamimarda-nu pangu kathu.” I bere nukunu-ka kardu wurnangat pangu-ka wurdanpunthuk warda i ngarra da-nu warda wangu puddalath. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bere kardu thangunu wurdanpunthuk-ka, mange nukunu-re dimmardawith warda da ngarra palyirr i ngarra Yile nukunu warda wurdananayiththa dini. Bere da thipinhi nhini-ka nukunu-ka pangu da dinidha numerrnu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mu peneme-ka ngarra ngipilinh marda nganangurr warda punnadhaneme ngarra nanhthi tharntu-re. Kardu-ka puyenangurrukadhaneme purne, mu nanhthi wirrirr warda kathu dampunkuwirnteneme i parranemardatthaneme purne. I tharntu-ka wurrinithudhuththa nanhthi ngurntinh-te i ngurru kanhi-re punibattha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bere da manta warda puningkapurldha wurrini-ka nukunu Jesus-ka wurrinilildha warda kathu ngarra kura ngipilinh kangkarl-yu ngarra pulangay nukunu-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I ngarra peneme-re pubamkangkarduneme Jesus wurrinililidha ngarra kura ngipilinh kangkarl-ka, peneme-ka perremkanhamneme ngala da matha i murrinh pumemnungkuneme, “Ya. Ku wurdarr pangu kathu kurrannilili-yu ngarra kura kangkarl-yu.” I peneme-ka pardewapadha-warda-neme, i perremkanhamneme ngala da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mu Jesus kathu-ka mampirruneme, “Ya peneme. Mere nengimanhamneme, kardu ngay-wa kanhi-yu. Kardu numenungkuyit-thathpirr-neme-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bere nukunu Peter kathu-ka mamna, “Pule, kardu nhinhi da thathpirr pana kathu thurrannilili-yu, kardu-ka thirrangakaynu ngurdiwalnu i ngurrumpalilinu ngarra kura kangkarl i ngamparuynu ngarra nhinhi.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mu Jesus kathu-ka mamna, “Yu mampa-ya, kagu.” I nukunu Peter-ka kardu warda wurdawal ngarra tharntu kathu-yu i wurrininalilidha pangu warda wangu ngarra Jesus-nu ngarra kura ngipilinh kangkarl nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mu ngarra nukunu-re bamkardu nanhthi ngurntinh ngala i wirrirr ngala, nhini-ka denham warda i wurrinidhadumtha warda wangu ngarra kura-yu. I pirrimnakay ngarra Jesus, i mamna, “Pule, kardu nangiyibirnu-ya i kardu ngurranthardum warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bere Jesus-ka wurrininalangmadha i manganmert, i murrinh warda mamna, “Thangku-dha mere murrinh nengabaththa ngay menhimanpidha ngurri thurrililidha-yu ngarra ngipilinh kanhi kangkarl-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bere ngarra penintha-re kanamninthamardap ngarra tharntu-ka nanhthi wirrirr ngala nhini-ka manthap warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bere nhini thangunu peneme nhini-ka parramkariparl-warda-neme Jesus-yu, i pumamnaneme, “Pule, nhinhi-ka kardu wakal Yile neki nukunu thathpirr-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bere peneme nhini Jesus wanku-ka pumpankakathneme ngamimarda kathu ngarra ngipilinh ngala nhini i parramkaruyneme da nan Gennesaret. I puddamkalalneme ngarra tharntu thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bere kardu da nhini thangunu-ka pubamkardu i panganthenh Jesus-yu. I nhini kardu-ka tharra warda punnidha i kardu matharr-wunngini punninmetkuttha da pana ngangka-re kathu. ");
INSERT INTO mwf2018_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","I pumenadha purni ngarra Jesus-yu, “Ya, thurrurralilinu manta pangu ngarra kardu matharr-wunngini i nhini kardu-ka pumanhidhadhapnu puyu ngarra nanhthi kaligu nhinhi.” Bere kardu matharr-wunngini terert-ka pumedhadhaptha pardi nanhthi kaligu nukunu Jesus-yu i patha deyida pardidha manangka matharr warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bere kardu nugarn pana ngarra murrinh law Jews pigunu marda pumertthaneme purne kardu Pharisees-ya, i kardu nugarn ngamere deyida ngarra murrinh law Jews pigunu puddininkuyethiththaneme purne-ka da nan thangunu kathu Jerusalem purnedhaneme i parramnaruyneme ngarra Jesus. I murrinh pumamnaneme, ");
INSERT INTO mwf2018_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ya. Thangku-dha pulangay nhinhi-yu da mange law nekineme mere kariwakneme kuru-yu ngarra ngalantharr murntak thangunu parrannhemutneme-yu? Mu peneme pangu-ka mi parnamkamurrkneme i mange ngarra peneme-ka mere warra ngadha pumenamapurldhaneme da mange murntak pana ngarra nekineme-yu ngarra kardu ngalantharr thangunu parrannhemutneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mu Jesus kathu-ka mampirruneme, “Mu nankuneme-ka thangku-dha-wa murrinh ngarra Yile neki nukunu thathpirr narnamkapartneme-yu i murrinh law pana da matha ngarra kardu ngalantharr murntak thangunu narramkariwakneme numpanka-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yile neki mam-ka, ‘Yileyile i kalekale nanki-ka murrinh nubirruyewupnungintha nuru i murrinh numarrubathnungintha nuru. I kardu nangkal ngatha mere murrinh marrubathnungintha ngarra yileyile i kalekale-ka i murrinh mankurdarrithaknungintha-ka kardu nhini-ka thu nubatnu i nuddurinuminu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","“Mu nga. Nankuneme-ka murrinh thirrukduk da matha nuddanpunkuyethithneme numpanka-yu nginipunh murrinh kanhi mani namamkaneme-ya, ‘Kardu nangkal ngatha nanhthi purrkpurrk patha i ku mani kanthin wurran-ka, nukunu nhini-ka mere ngarra nukun karrumutngintha ngarra yileyile i kalekale i mere ngarra nukun mankumanpingintha.’ Nhini-ka murrinh nginipunh kanhi nukun marrungintha, ‘Nanhthi purrkpurrk patha ngay i ku mani ngay-ka ngamnamut wardarra ngarra Yile neki-nu wangu. I nhini ngay-ka mere ngarra warda nganarrumutngintha nanhthi-yu i mere ngarra nukun warda manankumanpingintha nankungintha-yu.’ Nhini-wa murrinh thirrukduk nankuneme nuddanpunkuyethithneme-yu. Mu nhini nankuneme-ka murrinh narnamkapart-warda-neme murrinh ngarra thathpi Yile neki thangunu kathu-yu, i ngarra ku prophet nukunu thangunu kathu-yu. Mu murrinh ngarra kardu ngalantharr murntak nankuneme nimin narramkariwak-da-matha-neme numpanka-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“I nhini nankuneme-ka murrinh ngathayida narramnayirrarartneme numpanka ngarra Yile neki-yu i kardu ngathayida numemkadhart-da-matha-neme da ngarra mange nukunu-yu narramkariwak-mana-neme. I ku prophet murntak pana nan Isaiah murrinh thathpirr danirilildha wurrini-yu i kanhi-wa murrinh mam-yu, murrinh damnankurililneme-ya, murrinh thathpi Yile neki nukunu, ");
INSERT INTO mwf2018_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Kardu kanhi-ka parramngiriparl pumpan ngay-yu ngarra murrinh thathpi pigunu-re-yu, mu ngarra marda pigunu thathpirr-ka mere marda kumangert kuru. I kardu kanhi-ka parramngiriparl pumpan i pumamngingala pumpan kardu ngathayida-nu murrinh da matha dampunthawinhinhinh kanam. Mu nhini pigunu-ka da mange ngarra kardu thangunu da matha puddanpunthethith pumpan-yu, mu da mange ngarra ngay thathpirr-ka mere kurdunthethith kuru.’ Nhini-wa murrinh Yile neki-yu murrinh ngarra nukunu Isaiah thangunu darntilil-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bere Jesus-ka pirrimpirrakay kardu panpunperr kardu wurnangat. I murrinh warda mampirra, “Kardu, nubingayepup kathu, kardu murrinh thathpirr the numabathnu murrinh kanhi ngarra ngay manarranu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nanki-ka mere thathpirr wiye nuru ngarra mi i ku thangunu narnammurrk-yu, wurda. Mu kardu-ka wiye thathpirr wurran-ka ngarra marda nukunu thangunu kathu, i nhini-ka da mange wiye da matha mam wurran-yu i murrinh thathpi wiye warda wurranngerren-yu.” Jesus kathu-yu mampirruneme ngarra kardu Pharisees. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bere nhini thangunu-ka pulangay nukunu Jesus purnenadha-kathu-neme i pumamnaneme, “Ya pule. Kardu nugarn pana nganaka Pharisees thampunkumardarteneme ngarra murrinh pana thangunu nampirruneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mu Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Kardu peneme Pharisees pangu karrimkaneme-ka nanhthi mangini thay mani pumamkaneme pirrim. I nanhthi thay terert pana ngarra Yile ngay mere buniwakpaktha-ka nhini nukunu-ka pungurlarart-deyida-nu warda kathu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mu peneme pangu deyida-ka bere ngatha ngadha kiyemaneme karne i mere nukun nubirruyepupneme. Kardu-ka mangini kamarrama mani pumpankaneme, i kardu kamarrama ngamere deyida mani pumpanpunkungkayineme pumpanka. I nhini peneme-ka kardu pubuywathnu-warda-neme ngarra weyi pewerti wangu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mu bere nukunu Peter kathu-ka mamna, “Ya. Murrinh pana nganaka ngarra marra-re thurdanngarrayith-ka, murrinh mani thurdungarrumeriyithneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mu nukunu Jesus kathu-ka mampirruneme, “Nankuneme-ka mere deyida numangimartaneme murrinh nhini-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nankuneme-ka the-wa numabathneme murrinh nhini-yu. Nga. Mi i ku-ka ngarra thathpi wangu kanardi i ngarra kurnthik i yungawuy deyida. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mu kardu thathpirr wiye wurran-ka ngarra marda nukunu thathpirr-wa thangunu i ngarra thathpi thangunu kathu yungawuy ngarra wurranngerren da mana. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","“Da mange wiye ngarra kardu mam wurran-ka nhini-ka ngarra marda nukunu thangunu thathpirr-wa. I nhini-ka da mange wiye warda benthengkarnirn wurran i nhini thangunu-ka da mange wiye mangini kanhi mani warda mam wurran-yu. Nukunu nhini-ka kardu thu panmat wurran i wurdantinumi-yu. I mange wiye wurran ngarra kardu palngun karnabuy ngamere-yu. I nanhthi darrarart wurran. I murrinh dampirrayirrarart wurran. I murrinh mampunnarrithak wurran. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da mange wiye terert nhini-wa kardu-yu ngarra marda nukunu thangunu kathu mempiye wurran-yu. Mu kardu ngatha mange ngarra nukunu mere menumapurl-ka da ngarra mange murntak i mi wurranmurrk-ka nhini-ka kardu-ka mere thathpirr wiye kurru nhini-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bere nhini thangunu nukunu Jesus-ka nungardurr warda i pangu warda wangu nadha dini da manta pana warda kardidha da nan-ya Tyre i Sidon. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bere kardu palngun numi da nan thangunu kathu Canaan da nhini da kardipuptha, kardu mere Jews-wa nigunu-yu. Bere nigunu-ka nanadha dini ngarra Jesus-nu warda wangu wurrininakaykaydha i bangantipak ngarra nukunu da mana. I mamna, “Pule, kardu tharntethbath ngarra King David thangunu, nangimanpinu kathu. Kardu wakal mardinhpuy ngay-ka ku ngepan wiye kanthin wurran, i ku nhini-ka bere matha wangu mampiyewiye kanam nigunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mu Jesus-ka mere dedharttha kardu palngun nhini-nu-yu. I bere pulangay nukunu Jesus purnenadhaneme i pumamnaneme, “Ya. Kardu palngun kanhi-ka thurduthuk warda. Nigunu-ka kardu bere matha wangu dannheriwakneme kanam i bere matha wangu wurrannhekaykayneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mu Jesus kathu-ka mampirruneme, “Yile ngay-ka wurdanngithuk da putek ngala kanhi-nu kardu Jews da matha-nu manmanpinu ngurru, kardu pana-ya ngarra parrarntethbath thangunu kardu ngalantharr nan-ya Israel. Kardu nhini-ka mere warda kariwak kuru ngarra Yile ngay-yu, i nhini kardu-ka nginipunh ku thip mani parnawarrk-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bere kardu palngun nhini da ngatha-ka wurrininadha deyida ngarra Jesus i demnawinhipingkarl pangu warra kumparra ngarra nukunu. I mamna, “Pule, nangimanpinu kathu ngadha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mu Jesus kathu-ka mamnge, “Awu, ngay-ka mere ngarra marradhap nukun kardu Jews kanhi mampunmanpi nganam-yu. Mu nga. Kardu mani-ka mere marradhap kardu ngarra mamay mi parrampirramut ngarra ku were-nu wangu mi parramut-yu, wurda da ngatha nhini-yu. Nhini ku were-ka tiduk-wa mi parrampirramut-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Yu, bere-ya pule,” nigunu kathu-yu mamna. “Mu ku were ngatha yida parnammurrk ngarra mi kardu thangunu perrenimpurr pumpan ngarra table kathu-yu. Nhini ngay-ka mere ngarra bunhidhap nukun kardu Jews nampunmanpi thanam-yu, mu kunungingki da matha nangimanpinu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mu Jesus kathu-ka mamnge, “Nhinhi-ka murrinh thathpirr namngabath thurran wakal nhinhi-nu mampawathanu-yu. Nhini wakal nhinhi-ka ku ngepan wiye-ka ngarrimngeputh warda i patha warda nigunu-yu ngarra murrinh thamngidharrpu thangunu-yu.” I bere kardu wakal mardinhpuy nhini-ka patha warda wurrinidha i ku ngepan wiye nhini-ka kanampart warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bere Jesus-ka nungardurr warda da nhini thangunu-yu i pangu warda wangu nadha dini da ngarra kura ngipilinh ngala nan-nu da Kelili. I dimmardawith warda ngarra da palyirr i kanawup pangu da. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bere kardu wurnangat nimin-ya ngangka da parraninarurtuydha purni, i kardu matharr-wunngini wanku pumenbertidha purni ngarra nukunu. Kardu mere ngarra purnililidha-ya, i kardu kamarrama, kardu pulith-ya, i kardu ngarra manangka murrinh-wunthay parningerrentha-ya. I kardu matharr-wunngini ngamere deyida wanku pumenbertidha purni ngarra Jesus-nu. I kardu-ka pinganpuwuptha pi kardu matharr-wunngini nhini-yu kumparra warra ngarra me nukunu Jesus. I Jesus-ka menpathadha warda dini, i nhini kardu-ka patha warda pardidha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","I kardu pana ngarra manangka murrinh parningerrentha-ka murrinh warda pardingerrentha, i kardu pulith terert nhini pardidha-ka patha warda pardidha. I kardu pana ngarra manangka wilili parnililidha-ka kardu wilili patha warda purnililidha, i kardu kamarrama terert wanku pardidha-ka kardu kamarl patha warda pardibirlbirldha. I kardu terert pangu pardidha-ka pumemnamardat ngala da matha ngarra Jesus-te mange ngala nhini merradha dini ngarra kardu matharr-wunngini terert nhini-yu. I nhini-ka parraniriparldha warda pardi ngarra Yile neki-nu, ku Pule ngala nhini-ya da ngarra Israel nukun dimpirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Bere Jesus-ka pirrimpirrukayneme kardu pulangay nukunu i mampirruneme, “Peneme, ngay-ka damngimardathin kardu wurnangat kanhi-nu. Kardu pardidha-ka da perrkenkuneme warda ngarra ngay-yu i mi-ka mami warda parnam. Mu kardu kanhi ngatha ngurdunthuknu warda marra kanhi ngarra medeyi wanku parnam-ka nhini-ka mankarr nukun warda i kubuywath nukun warda ngarra da pigunu-nu purunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bere pulangay nukunu Jesus-ka pumamnaneme, “Ya pule. Da kanhi-ka da mi mamirdarri-wa thanthinpun terert thanam. Mu ngarra-wa mi-yu pubanyerderrnu kardu wurnangat kanhi-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mu Jesus kathu-ka mampirruneme, “Mi-ka thangku numa mi lawam nanthinkaneme nirrimka-yu?” “Mi-ka 7-wa i ku ngurlmirl purrkpurrk deyida wanku kanhi kem-yu,” peneme kathu pumamnaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bere nukunu Jesus-ka mampirra kardu ngarra wurnangat-yu, “Kardu, narniwup mani ngarra putek.” ");
INSERT INTO mwf2018_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bere kardu-ka parnawup i nukunu-ka mi lawam 7 nhini i ku ngurlmirl purrkpurrk mangankut i ngarra Yile neki warda mamna, “Mi kanhi ngarra thamngarramut-ka mi-ka patha-wa.” I bere nukunu-ka mi munganterrarr i ku ngurlmirl-ka mamyerryerr warda nukunu-yu. I dampirrumutmut-warda-neme ngarra pulangay nukunu. I peneme nhini-ka mi warda parranirramutmuttha pardi ngarra kardu wurnangat wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Mi lawam i ku ngurlmirl nhini thangunu-ka Jesus daninmadha pirri ngarra mange nukunu thangunu-ka mi terert i ku terert pardimurrktha. I kardu-ka mampunmay i bangampunmardan warda nhini-yu. Kardu-ka kardu wurnangat nimin-ya pardimurrktha-yu kardu nugarn, kardu palngun i kardu mamay. Kardu nugarn da matha-wa 4,000 pangu pirrinidha-yu. I bere mi i ku thangunu parrarntikerdek-ka peneme nhini-ka parranedhakthukthaneme purne mi i ku ngarra kardu thangunu parraniritmuttha pirrini. Mi i ku nhini thangunu pumamkadhalertneme-ka nanhthi 7 thelerrlerr-wa, nanhthi-ka ngala ngala nimin-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bere nhini thangunu nukunu Jesus-ka kardu warda wurdanpunthuk. I nukunu-ka ngarra tharntu warda kanammardap. I nungardurr nadha dini da ngamimarda-nu kathu da nan-nu warda wangu Magadan. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bere pulangay nukunu Jesus-ka pumpankakathneme ngamimarda kathu ngarra ngipilinh ngala. Mu peneme-ka mi lawam puyemkayekumneme mere pumebaththaneme mi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","I bere Jesus kathu-ka mampirruneme, “Nga peneme. Thawath wangu nururranemenu nanhthi turlururlumam ngarra peneme pana Pharisees kardu ngarra murrinh law nekineme marda pumangankartneme pumpan i kardu ngalantharr nan-ya Sadducees,” mampirruneme Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bere peneme nhini-ka murrinh warda puddanayiththaneme pirrine i pumenanudhaneme pirrine mange peneme ngatha, “Murrinh kanhi mannheneme-ka mi lawam-nu kama mere thumebaththaneme mi thanthekum-da-matha-neme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bere Jesus-ka the-wa mebaththa dini ngarra murrinh peneme puddanayiththaneme pirrine mange peneme ngatha-yu. I bere mampirruneme, “Ya. Thangku-nu nuddamkayithneme nirrimka-yu mi lawam mami numamkaneme i mi nuyemkayekumneme-yu? Nankuneme-ka murrinh mere da ngatha the numabathneme, na? ");
INSERT INTO mwf2018_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I murrinh-ka mere da ngatha numangimartaneme murrinh ngarra mamnarruneme-yu? Mu nga. Nuddingayerr-mani-neme ngarra mi munirerrarrdha ngirri mi lawam 5 nhini-yu i ngampirramut kardu wurnangat pangu-yu kardu nugarn 5,000-wa. I thangku numa-wa nanhthi thelerrtherr numedhalertertthaneme nurne-yu mi parriniritmut thangunu-yu da nhini-re-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","I ngana deyida mi nhini-re-yu nganaka munirerrarrdha ngirri mi lawam 7 nhini-yu i ngampirramut kardu wurnangat pangu kardu nugarn 4,000-ya. I thangku numa deyida nhini-yu nanhthi thelerrtherr numedhalertertthaneme nurne-yu mi parriniritmut thangunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I bere Jesus-ka mampirru-deyida-neme, “Nga peneme. Nankuneme-ka murrinh mere da ngatha numangimartaneme narne, nawa? Mu mi lawam-ka mere thathpirr ngurdananarruyiththaneme ngirri.” I bere Jesus-ka murrinh mampunkumardawerrneme i mampirru-deyida-neme, “Thawath wangu nururranemenu nanhthi turlururlumam ngarra kardu nugarn pana Pharisees i kardu Sadducees-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I bere kardu pulangay nukunu Jesus-ka the warda pumamkabathneme murrinh nhini mampirruneme ngarra nanhthi turlururlumam-ya murrinh ngarra kardu ngalantharr pana Pharisees i Sadducees puddanpunthethith pumpan nhini-yu, mu mi lawam-ka wurda-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bere Jesus-ka pangu warda wangu nadha dini manta ngangka da nan-ya, Sesariya Filipi. I bere murrinh kanhi warda mampirruneme ngarra pulangay nukunu, “Ya peneme. Ngay kardu ngarra da kangkarl kathu ngurdamnarrathut-ka, nangkal mana-wa ngay-yu kardu wurnangat pumamnga pumpan-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bere peneme kathu-ka pumamnaneme, “Kardu ngamere pumampa pumpan-ka John the Baptist mana-wa. I kardu ngamere deyida pumampa pumpan-ka kardu nan mana-wa Elijah, kardu thurdamkabirl deyida. I kardu ngamere deyida pumampa pumpan-ka ku prophet nhini kama-ya Jeremiah. I ngamere deyida pumampa pumpan-ka ku prophet numi deyida thurdamkabirl.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mu Jesus kathu-ka mampirruneme, “Mu nankuneme-ka nangkal mana-wa thathpirr ngay-yu numamnganeme numpan-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bere Simon Peter kathu-ka mamna, “Nhinhi-ka Christ-wa, kardu wakal ngarra Yile neki nukunu ngarra da kangkarl kanam-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","I Jesus kathu-ka mamna, “Simon, Jonah marra marda. Yu, murrinh da thathpirr namnga-yu. Nhinhi-ka le da matha thaninu. Kardu mere nangkal murrinh nhini mempadha, mu Yile ngay da matha ngarra da kangkarl dim murrinh nhini dampamut mampa-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","I nga, murrinh kanhi mampanu. Murrinh nhinhi-ka Peter-wa, murrinh kanhi-nu-ya nanhthi palyirr tetemam. I kardu wurnangat warda ngatha da pana ngangka-re thangunu pangiriwaknu puru i murrinh pumangabathnu puru kardu nhini-ka da tetemanthay da matha pingkadhuknu nginipunh da palyirr ngala mani pirrim-yu. I kardu-ka bere matha wangu birnu parninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I ngarra murrinh thurdurrayithnu thurru da ngatha-re-ya kardu wurnangat puruwatnu da mayern ngarra Yile ngay nukun i da ngarra nukunu da mana panaruynu. Nanhthi mangini ki mani ngarra nanhthi tuwa nukun ngampamutnu, i nhinhi-ka narradharlnu da ngarra Yile ngay nukun kardu wurnangat-nu. I ngarra murrinh kanhi narranu ngarra kardu, ‘Awu, mayern pana-ka mere mayern thathpirr-wa,’ nhini Yile neki-ka murrinh nhini deyida pamanu. I ngana deyida murrinh kanhi narranu ngarra kardu, ‘Yu, kanhi-wa mayern thathpirr-yu,’ nhini Yile neki-ka murrinh nhini deyida pamanu.” Nhini-wa murrinh-yu Jesus kathu mamna ngarra Peter. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","I bere Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Nga peneme. Kardu mere nangkal nukun murrinh numananeme ngay da kardu Christ-yu i Yile ngay wurdingithuk-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bere da nhini thangunu Jesus-ka murrinh kanhi warda merrudhaneme wurrini ngarra pulangay nukunu, murrinh yuthpan i pilampirdarri-ya. I mam, “Nga peneme. Ngay-ka da Jerusalem-nu warda wangu ngunungam da matha ngem. I kardu pangu-ka kardu ngalantharr ngalantharr-ya, ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law kardu Jews nukun puddanpunthethith pumpan, kardu pumangirtanu i thu pungibatnu pani i thu pangilurturtnu purru ngay-yu. I nhini thangunu-ka puddungirinuminu warda. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mu nukunu Peter-ka manganmert Jesus wurrinininthadha da kunungingki tharrngini wangu murrinh mange penintha-nu. I murrinh mamna, “Ya pule, pirda-wa murrinh nhini-yu. Mere murrinh nhini thama thurru. Kardu-ka mere kunhibat nukun-ya, wurda da matha. Mu Yile neki da matha pirranhipenu pani.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bere Jesus-ka wurdamnarduy pirrim ngarra Peter, i mamna, “Ya Peter, murrinh ngarra thirrimngerren pana-ka murrinh ngarra ku karrath thangunu kathu-wa. Nhinhi-ka thunungamngingkamit-wa da mange ngarra Yile ngay nukunu. Nhinhi-ka denthengkarnirn thurran mangini kardu mani-wa i mere deyengkarnirn thani da mange ngarra Yile ngay nukunu, wurda da matha.” I Jesus kathu-ka mamna ngarra ku karrath, “Ku karrath, pata thurru-wa, thaningipart warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bere Jesus kathu-ka murrinh mampirruneme ngarra pulangay nukunu, “Nga. Kardu nangkal ngatha ngarra ngay pangiriwaknu pani-ka, nhini nukunu-ka puynuyekumnu warda i panipartnu warda purru da ngarra mange nukunu marda manganart wurran. I kardu ngathayida thu puthuknu puru i palurturtnu purru i thu purdurinuminu mangini ngay deyida mani pumanganu puru, kardu nhini-ka mangirart-da-nu-matha purru ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Mu kardu nangkal ngatha marda mart menuyibirnunu i da mange ngarra nukunu da matha pamanu purru, nhini nukunu-ka pupup da matha-nu nhini-yu. Mu kardu nangkal ngatha puynuyekumnu thathpirr i ngay da matha kumparra bungipaknu, nhini nukunu-ka kardu bere matha wangu birnu paninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“I ngana deyida kardu ngatha bemnuyengkarnirn kanam ngarra nukunu-nu ngatha i nanhthi purrkpurrk terert nimin bemmardarr wurran, nhini-ka patha-wa-nu nukunu-nu-yu? Awu wurda da matha. Mu ngarra nukunu nhini-re pupupnu-ka nanhthi purrkpurrk nhini-ka mere ngarra kumayibirnu nukun da bere matha wangu birnu paninu-yu, wurda da matha nhini-yu. I kardu-re pupupnu-ka mere deyida ngarra kurdingkabirl mange nukunu ngatha-yu. I nanhthi purrkpurrk nhini deyida mani wanku mere ngarra kuddungkabirl nukunu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","“Nga. Ngay, kardu darrikardu nanki thathpirr-ka da nakurl-te ngurdiwurlnu kathu, kardu pule ngala thathpirr ngurrunu wunku nanhthi lurruth ngala ngarra Yile ngay thangunu i wunku ku angel wurnangat ngarra ngay. I da nhini-nu-re-ka kardu nhini ngarra da mayern patha parriniriwaktha purni, kardu nhini-ka le patha thathpirr puyunu da ngarra Yile ngay nukun. Mu kardu nhini ngarra da wiye parriniriwaktha purni nhini ngay-ka ngurdunkartelnu ngarra da thungku ngala wangu. I nga, murrinh thathpirr kanhi manarranu-yu. Kardu ngamere nibimkadhuk kanhi-ka kardu mere da ngatha nuyuwuwupnu da ngarra ngay da mana deyida nubangingkardu-nu kardu pule ngala thathpirr ngurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bere da 6 mana mam-ka nukunu Jesus-ka menkubertidhaneme tharra nukunu Peter, i piguna James i John. I kanthinpunkumardawithneme ngarra da palyirr kangkarl thathpirr-ya numidharrwunku-da-matha-neme nukun mange peneme da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bere da palyirr kangkarl nhini da ngatha peneme-ka pubamkangkarduneme nukunu Jesus-ka kamarl ngarra nginipunh nukunu-ka wurdamnungkath warda i damkalarrang ngala da matha nginipunh nanhthi ngunga mani damkalarrang pirrim-ya. I nanhthi kaligu ngarra banardidha wurrini-ka wurdannath nanhthi damlarrang bamam thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bere nhini thangunu peneme nhini-ka pubamkangkardu-deyida-neme kardu ngalantharr murntak nan Elijah i Moses puddananayiththanintha pe ngarra Jesus wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","I bere nukunu Peter kathu-ka mamna ngarra Jesus, “Pule, da patha-ya patha da mange kanhi-yu ngarra nekineme thanamneme kanhi-yu. I marda ngatha nart-ka ngay-ka nanhthi wuwup ngawupnu nanhthi perrkenkuneme, nanhthi numi nhinhi-nu, nanhthi numi nukunu Elijah-nu i nanhthi numi nukunu Moses-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bere ngarra nukunu-re Peter pirrinangerrentha-ka nanhthi kalakkalak da kangkarl wurrinidha kathu nanhthi kalakkalak damlarrang wurran-ya. I murrinh ngerren warda pubimkayepupneme ngarra kalakkalak kathu-yu i murrinh kanhi-wa mampirruneme-yu, “Ya. Kardu nugarn kanhi karrim-ka kardu wakal ngay-wa. I ngay-ka marda-wa thathpirr manganart ngurran nukunu-yu. I nankuneme-ka nubinayepup-da-matha-neme nuru nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","I pubimkayepupneme thangunu-ka peneme-ka kardu warda perremkanhamneme ngala da matha nhini-yu, i perremkawinhimardardumneme ngarra putek. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mu Jesus-ka wurrinirrudhaneme i mampunkuthapneme i mampirru-warda-neme, “Nga, newirnturtneme i mere nenham-nukun-neme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","I bere peneme-ka kangkarl pumamkangkaneme i pubamkangkarduneme nukunu da matha Jesus numidharrnu pirridha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bere da ngarra palyirr nhini thangunu kathu puddanathut-da-ngatha-neme punne-ka Jesus kathu-ka mampirruneme peneme nhini-yu, “Nga peneme. Kardu mere nangkal nukun nuddunayithneme da mange kanhi thangunu nubamkangkarduneme-yu mu ngarra ngay da mana ngurdingkabirl-deyida-nu, kardu ngay-ya darrikardu nanki thathpirr-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bere peneme kathu-ka ngarra Jesus pumamnaneme, “Nga. Kardu nugarn pana nganaka, kardu ngarra murrinh law nekineme puddanpunthethith pumpan-yu kardu kanhi-wa murrinh pumam pumpan-ya, ‘Nukunu Elijah-ka kumparra warra-wa pununu pi da kanhi-yu. I kardu nugarn pana ngarra Yile neki purduthuknu-ka tiduk-wa kathu pununu pi da kanhi-yu.’ Thangku-nu murrinh nhini pumam pumpan-yu?” Peneme kathu parramkadharrpuneme ngarra Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I Jesus kathu-ka mampirruneme, “Yu, murrinh thathpirr nhini-yu,” mampirruneme. “Nukunu Elijah-ka kumparra warra-wa pununu pi da kanhi-yu i kardu-nu bunyithithnu purru. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mu murrinh kanhi manarruneme-ka nukunu Elijah-ka berengunh wardarra wurrinidha da kanhi-yu. I kardu-ka puddankapi-wa i mange mere patha punninadha i pumpanmat puddantinumi nukunu-yu. I nginipunh nhini deyida mani kardu-ka mange mere patha purunganu-yu i mere murrinh pumangabathnu murrinh ngarra ngay-yu, kardu ngay-ya darrikardu ngarra nanki thathpirr-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bere kardu pulangay nukunu Jesus-ka the warda pumamkabathneme murrinh nhini ngarra mampirruneme-ka murrinh ngarra John the Baptist-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bere Jesus i kardu pulangay nukunu-ka puddamkawurlneme ngarra kardu wurnangat nhini. I bere kardu nugarn wurrininadha ngarra Jesus i demnawinhipingkarl kumparra warra ");
INSERT INTO mwf2018_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","i mamna, “Pule, pangamardathin ngadha wakal ngay-nu kardu kigay-ya i namanpinu. Nukunu-ka kardu parnterte thathpirr wurran i bawath kanam ngarra thungku i ngarra kura ngatha yida. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mu ngay-ka menkubertidhaneme tharra ngarra pulangay nhinhi, mu peneme-ka mere ngarra patha pumewathadhaneme, wurda puddamnabay-da-matha-neme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mu Jesus kathu-ka mampirra ngarra kardu wurnangat-yu, “Nanki-ka murrinh-ka nubimngayewup numpan murrinh ngarra ngay-yu mu murrinh-ka mere thathpirr numangabath nuru. Da pirdithme da matha murrinh ngurdininanthethiththa ngardi, mu murrinh-ka nanki-ka mere da ngatha numangabath nuru murrinh ngarra thathpi ngay-yu. Ngarra-wa diki murrinh ngay ngurdinanthethithnu ngani-yu i murrinh numangabathnu thathpirr-yu? Kardu kathu numangabert kardu kigay pana.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bere Jesus kathu-ka murrinh mamna ngarra ku ngepan wiye-yu, “Ya. Thungiwuy kathu ngarra kardu pana-yu.” Bere ku ngepan wiye-ka yungawuy warda kathu ngarra kardu kigay thangunu kathu-yu. I kardu nhini-ka patha warda dinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bere nhini thangunu ngarra kardu wurnangat mana puddalath pangu wangu-ka, pulangay nukunu Jesus-ka murrinh warda pumamnaneme, “Thangku-dha ngankuneme-yu mere ngunnemakudhaneme nguddamnabayneme ku ngepan wiye nhini ngarra kardu kigay pangu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bere Jesus kathu-ka mampirruneme, “Nankuneme-ka murrinh nganaka-ya numengabaththaneme-yu. Mu nga. Nankuneme ngatha murrinh thathpirr numangabathneme murrinh kunungingki ngatha nhini nankuneme-ka niyemana-mani-warda-neme ngarra da palyirr ngala kanhi karrim-yu, ‘Da palyirr ngala thunurdurr i pangu wangu thurrunu.’ I nhini da palyirr nhini-ka murrinh warda manarrubathneme i punurdurrnu nhini-yu. I nginipunh nhini mani-ya mange da terert warda ngatha nuyemanuneme nuru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bere ngarra kardu pulangay nukunu Jesus pubemkangkardurduneme da Kelili-ka nukunu Jesus-ka murrinh-ka kanhi-wa mampirruneme-yu, “Nga peneme. Ngay kardu ngarra darrikardu nanki thathpirr-ka pumangirtanu i pumangibertinu puru kardu ngarra pule ngala ngala-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","I nhini thangunu-ka thu pungibatnu i puddungirinuminu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu.” Bere pulangay nukunu-ka dampunkumardathin-warda-neme ngala da matha murrinh nhini thangunu mampirruneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bere Jesus i pulangay nukunu-ka parramkaruyneme da nan-ya Capernaum. Bere kardu nugarn pana ngarra ku tax mani purninmatkuttha da church ngala-nu kardu Jews nukun-ka, purnenadhaneme ngarra Peter i murrinh pumamnaneme, “Ya. Pule nankuneme-ka ku mani ngadha dammutmut wurran da church ngala-nu-yu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","I Peter kathu-ka mampirruneme, “Yu, nukunu-ka ku mani dammutmut wurran.” Bere ngarra nukunu-re Peter kanardi ngarra thelput, Jesus warra ngadha murrinh mamna, “Nganaka Simon? Ngarra denthengkarnirn thanam nhinhi-yu? Thangku kardu thangunu kathu ku tax mani-yu parnampunmatkut-yu ku pule ngala ngala da kanhi-yu? Kardu darrikardu ngarra pigunu ku pule ngala ngala nukun parnampunmatkut kama i kardu ngamengka kama parnampunmatkut. Kardu ngarra nimin denthengkarnirn thanam nhinhi-yu?” Jesus kathu-yu dantharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bere Peter kathu-ka mamna, “Kardu ngamengka thangunu kathu ku tax mani-yu parnampunmatkut-yu.” “Yu,” Jesus kathu-yu mamna. “Ku pule ngala-ka mere kaninmatkut kurru ku tax mani ngarra kardu darrikardu nukunu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mu neki-ka mere pumankumardaraki-nukun-neme peneme pana ngarra ku tax mani parnampunmatkut da church ngala-nu, nhini-ka thurrunu pangu ngarra kura ngipilinh ngala i ku ngurlmirl-nu thikunu. I ku ngurlmirl marra-re warra ngadha manhimartnu-ka ku mani dardurtnu ngarra thathpi nukunu. Ku mani nhini-ka bere matha ku-yu ngarra murrinh pumam kathu-yu neki-nu parramutnu-yu. I ku mani nhini-ka narrubathnemenu pangu warda wangu ngarra peneme nhini ngarra ku mani parnampunmatkut da church ngala-nu-yu.” Jesus kathu-yu mamna ngarra Peter. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bere kardu pulangay nukunu punnenadhaneme ngarra Jesus i murrinh pumamnaneme, “Pule. Kardu nangkal nimin-nu peneme ngatha-yu kardu pule ngala parethbathnu ngarra nhinhi da nhini-nu-re ngarra Yile neki kardu Pule ngala thathpirr pinhenu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bere Jesus-ka manganmert kardu mamay kumparra pangu warra ngarra peneme i bamnungurrupak warda ngarra nukunu ");
INSERT INTO mwf2018_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","i mampirruneme, “Murrinh thathpirr kanhi-yu. Nankuneme-ka kardu nginipunh mamay kanhi narnenemenu. Mu wurda ngatha-ka nankuneme-ka mere ngarra nukun narneneme da kangkarl-yu ngarra Yile neki ku Pule ngala thathpirr pinhenu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kardu nangkal ngatha marda mart kardu pule ngala purrunu-ka nhini nukunu-ka kardu kunungingki buynupaknu nginipunh kardu mamay karrim kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","I kardu nangkal ngatha mardarrilenu kardu mamay nginipunh kanhi mani karrim-ka nhini kardu-ka ngay deyida wanku mangirdarrilenu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bere Jesus-ka murrinh deyida mampirruneme, “Nga. Kardu mamay kanhi karrim-ka murrinh ngarra ngay mamngabath wurran-yu. Mu kardu nangkal ngatha puynardarripupnu i ngarra ngay paningipartnu kardu mamay kanhi mani karrim-ka nhini nukunu-ka da mange wiye ngala da matha mana nhini-yu. Mu nukunu nhini-nu-ka da-ka patha-wa kumadhamadharrk-yu nanhthi palyirr ngala yitthit-ya ngarra thamarl nukunu i kunnuku pangu mani wangu i kayiwik ngarra kura lalingkin. I nhini nukunu-ka mere mani warda kuynardarripup da ngarra wiye wangu-yu kardu mamay nginipunh kanhi mani karrim-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“I nga,” Jesus kathu-yu mampirruneme. “Kardu-ka bere matha wangu pananngurradhathnu puru i pumanantullulnu puru ngarra nanki-yu da ngarra mange wiye-nu niyemanu nuru. Mu da-ka wiye da thathpirr pirranu kardu nhini-nu ngarra mange pumanarranu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mu nanhthi mange kama i ngarra nanhthi me kama ngarra nankuneme-re da mange wiye numabathnu-ngatha-neme nuru nhini mange i me nhini-ka nubemartal-wa-neme nhini-yu. Nhini-ka da mange patha da thathpirr mange numi da matha numabathnuneme nuru-yu i nhini-ka da kangkarl nemardawithnuneme ngarra Yile ngay dim i bere matha wangu birnu narnenemenu da pangu-yu. Mu mange perrkenku i me perrkenku ngatha numabathnuneme nuru-ka i da mange wiye da ngatha numabathnuneme nuru, nhini-ka da pangu wangu nanemenu ngarra thungku ngala dim, thungku mere ngarra kingkan nukun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","I ngana deyida nanhthi kamarl ngarra nankuneme deyida-re da mange wiye numabathnu-ngatha-neme nuru, nhini kamarl nhini-ka nunguyngkapirt-wa-neme nhini-yu. Nhini-ka mange patha da thathpirr kamarl numi da matha numabathnuneme nuru-yu i nhini-ka nemardawithnemenu da ngarra Yile ngay dim-ya i bere matha wangu birnu narnenemenu da pangu-yu. I Yile ngay-ka ku Pule ngala thathpirr warda pinarrunemenu. Mu kamarl perrkenku ngatha numabathnuneme nuru-ka i da mange wiye da ngatha numabathnuneme nuru-ka nhini-ka da pangu nanemenu ngarra thungku ngala dim. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“I nga numi-yu,” Jesus kathu-yu mampirruneme. “Kardu mamay kanhi karrim-ka mere nukun kunungingki nubupaknemenu, wurda da matha. Mu nga, murrinh kanhi manurrunemenu. Ku angel ngarra mamay terert kanhi-ka ku bere matha wangu parnam ngarra Yile ngay wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nga. Kardu nugarn mabath ki ku thip, ku-ka 100-wa, i bere matha wangu ku kirranpe kani. Mu ku thip numi ngatha kaniwarrk-ka ngarra warda kama kardu nugarn nhini-yu? Nukunu nhini-ka kaninpart ku thip ngamere nhini 99-yu ngangka da mi parnu kawekat karni i kunu kirrawinhadhath tharra ku thip numi nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","I ngarra ku thip nhini bangarnurt-ka nhini nukunu-ka le warda kani. Nukunu-ka le kanam ngarra ku thip 99 ngarra mere karniwarrktha. Mu nukunu pana-ka le patha thathpirr kanamna ngarra ku thip nhini bangarnurt-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","I nginipunh murrinh nhini mani-ya Yile neki le da thathpirr kanampirra kardu mamay mani-ka murrinh ngarra nukunu pumamnabath parnam. I nukunu-ka mere le kani ngarra mamay kanhi mere warda murrinh pumanabathnu i parniwarrknu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bere Jesus kathu-ka mampirra, “Nga. Kardu ngatha da wiye mampanu-ka nhini-ka thurrunanu pangu ngarra kardu nhini-yu i murrinh nananu da ngarra mange wiye nhini mampa-yu. I thurrunanu ngarra kardu nhini i mere nangkal numi the manhimabathnu. I kardu nhini ngatha murrinh bimpayepupnu, nhini-ka murlmurl deyida kanimpa kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mu mere ngatha bimpayepupnu-ka nhini-ka kardu numi kama i kardu perrkenku kama nankubertinunintha thurru ngarra kardu nhini deyida narnuneme. I penintha nhini-ka kardu nangkanga purruninthanu ngarra murrinh deyida kardu nhini nananu-yu. Da-ka mange-ka ngarra murrinh Yile neki yibim. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mu kardu nhini ngatha mere birruyepupnintha kardu penintha nhini, nhini-ka murrinh warda thantherrnu kardu pana ngarra da church parnardurdi-yu. I kardu nhini ngatha mere birrayepupnu-ka, nhini-ka thanipart da matha kardu nhini-yu, nhini nukunu-ka mere marda mart kurru da mange ngarra Yile neki nukun kariwak kurru. Nhini-ka thanipart da matha kardu nhini-yu, nhini-ka mangini kardu da ngamengka thangunu kathu mani nadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“I nga, murrinh thathpirr kanhi manarranu-yu. Nanki ngatha nanhthi thangku nanhthi kama nubudhap da ngarra putek ngala kanhi-ka, nhini-ka Yile ngay kathu deyida kardu ngarra kangkarl dim-ya budhap nanhthi nhini-yu. Mu nanhthi nhini ngatha mere nubudhapnu nhini da ngarra putek ngala kanhi-ka, nhini Yile ngay deyida wanku mere budhapnu nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","I nga, murrinh numi manarranu-yu. Nginipunh kardu perrkenku ngatha ‘Yu’ manintha nanhthi thangku nanhthi-nu-ka, i ngarra Yile ngay-nu warda ngarra da kangkarl dim paninthadharrpunu-ka, nhini nukunu-ka parrumutnu-warda-nintha nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kardu perrkenku kama, i kardu perrkenkuneme kama kardu ngarra ngay-ya pubengkardurdunemenu murrinh prayer-nu i thangku nanhthi-nu kama, nhini ngay deyida wanku nganinu ngarra kardu nhini-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bere nukunu Peter wurrininadha ngarra Jesus i murrinh mamna, “Pule, kardu ngatha da wiye manganu i nhini ngay-ka nguymayekum warda da wiye nhini-yu. I ngana deyida da wiye manganu i ngay-ka nguymayekum-deyida-nu. I mangini nhini deyida mani da mange 7 manganu i ngay-ka da nguymayekumnu warda ngurru da 7 nhini-yu, nhini-ka bere matha warda da nhini-yu?” Dantharrpu Peter kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mu Jesus kathu-ka mamna, “Awu, manangka da 7 nhini ngatha thuymayekum-yu, mu puy deyida wangu da mangini 77 mani thuymayekumnu thurru da wiye nhini ngarra mampanu purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nga, da mange ngarra Yile ngay nukun-ka mangini murrinh kanhi mani ngurdinarrayithnu, murrinh ngarra kardu pule ngala-ya. Bere nukunu nhini kardu pule ngala-ka manganart nanhthi buk nukunu i bengkardudha dini murrinh ngarra kardu nukun ngarra ku mani borrow pumamna i mere da ngatha puddinangkarldha. Kardu nhini-ka kardu ngarra nukunu wurlk pumenadha purni. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Bere ngarra nanhthi buk nhini da ngatha-re bengkardudha dini-ka kardu nugarn numi pumenabertidha purni. Nukunu nhini-ka wurlk menadha kardi kardu pule ngala nhini-nu i ku mani ngala nimin borrow mamna i mere da ngatha wurdinangkarldha. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nukunu nhini-ka ku mani maku da matha i mere thangku mebaththa wurrini. I nhini ku pule ngala kathu-ka mampirruneme kardu ngamere ngarra nukunu, ‘Ya. Nukunu kanhi karrim-ka thelim nuyemanemenu i palngun nukunu wanku i mamay ngarra nukunu i nanhthi purrkpurrk nukunu wanku thelim nuyemanemenu i nhini thangunu ku mani nhini-ka nangamutnu-warda-kathu-neme.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mu nukunu nhini-ka demnawinhipingkarl kumparra warra ngarra ku pule ngala nhini i murrinh mamna, ‘Awu pule, thaningipartnu ngadha, i nhini ngay-ka ku mani terert warda ngatha ngurdumpangkarlnu warda.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bere ku pule ngala nhini-ka damnamardathin warda kardu nhini-nu i pammayekum warda ku mani ngala nhini-yu i wurdanthuk da matha nukunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bere nukunu kardu nugarn nhini-ka dempirnturt i pangu warda wangu nadha dini i bamkardu kardu numi deyida ngarra ku mani borrow mamna i mere da ngatha wurdinangkarldha. I nukunu nhini-ka mangarnta i medhamarliptha warda i murrinh menadha pirri, ‘Ku mani ngay kathu thurdungangkarlnu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mu nukunu nhini kathu-ka mamna, ‘Awu, thaningipartnu ngadha, i nhini ngay-ka ku ngurdumpangkarlnu warda.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mu nukunu kardu nugarn nhini-ka mere binayepuptha i ngarra jail warda damnadhap i ngarra ku mani da mana wurdannangkarl. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mu bere, ngarra kardu ngamere nhini ngarra wurlk pumenadha purni ku pule ngala nhini-nu pubangamkamangkarduneme-ka, kardu-ka mampunkumardarakineme i parnamnatharrmu-warda-neme ngarra ku pule ngala nhini. ");
INSERT INTO mwf2018_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","I bere, ku pule ngala nhini-ka dimnakay warda kardu nhini ngarra ku mani pammayekum-yu, i murrinh mamna, ‘Ya. Nhinhi-ka kardu wiye da matha. Ngay-ka ngamnhimayekum ku mani ngala nhini ngarra mere thurdingangkarl-da-dha ngatha-yu nhini-ka themngiwinhipingkarl i namnga, “Thaningipartnu ngadha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","I nhinhi deyida denhimardathintha kardu pangu-nu-yu mangini ngay mani damngimardathin nhinhi-nu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Bere ku pule ngala nhini-ka damnarithi da matha kardu nhini-nu i damnadhap warda ngarra jail ngarra ku mani terert da matha thathpirr wurdannangkarl.” ");
INSERT INTO mwf2018_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","I bere Jesus kathu-ka mampirra ngarra kardu, “Nga. Yile ngay da ngarra kangkarl dim-ka mange nhini mani manarranu ngarra nanki mere da ngatha pananmardathinnu thathpirr i puynmayekumnu da wiye nhini ngarra kardu ngamere kathu pumanarranu puru-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bere kardu nugarn wurrininadha ngarra Jesus i murrinh mam, “Pule, thangku da mange patha ngamanu ngurru ngarra Yile neki nginu da bere matha wangu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I bere Jesus kathu-ka mamna, “Thangku-nu thamngidharrpu thirrim ngay-yu ngarra da mange patha thamanu thurru-yu? Yile neki da matha patha thathpirr-yu. I murrinh ngarra nukunu da matha nanabathnu thurru i nhini-ka kardu bere matha wangu birnu thaninu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mu kardu nugarn nhini kathu-ka mamna, “Thangku murrinh nhini-yu ngarra mabathnu ngurru-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Kanhi-wa murrinh-yu”, Jesus kathu-yu mamna, “‘Kardu-ka mere thu thubat nukun i mere thurdurinumi nukun. I mere nukun da mange nangerithuk thurru kardu ngarra palngun nugarn karnabuy nukunu-yu. I mere darrarart nukun thurru. I mere tharrayirrarart nukun thurru. I ngarra yileyile i kalekale dirruyewupnungintha thurru i murrinh narrubathnungintha thurru. I kardu ngamere marda nanartnu thurru nginipunh nhinhi deyida mani marda nemnurt thanam-ya.’” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","I bere kardu nhini kathu-ka mamna, “Pule, murrinh nhini-ka bere matha wangu mebaththa ngardi. Mu thangku numi warda mange ngamanu ngurru-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","I bere Jesus kathu-ka mamna, “Nga, da mange patha thathpirr thamanu thurru-ka, nhini-ka nanhthi purrkpurrk ngarra nhinhi warda ngatha thelim thamanu i ku mani nhini-ka tharramutmutnu thurru kardu ngarra nanhthi mananhthiwunka. I nhini thangunu-ka da ngarra Yile neki-re thimardawithnu warda nhini-ka nanhthi patha-ka mere warda thaniyeymanu nhini-yu. I bere mampa, thurru warda i mange nhini thamanu i thurdingawurlnu ngarra ngay deyida kathu i thangiriwaknu warda thani ngarra ngay da matha wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mu kardu nugarn nhini-ka murrinh nhini-re binthepup-ka nhini-ka danimardathintha warda pirri nhini-yu. Nhini nukunu-ka nanhthi purrkpurrk terert kanthidha dini i mere da matha ngarra thelim midha nhini-yu. Bere nukunu nhini-ka kanampart warda ngarra Jesus-yu i nadha dini pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bere Jesus-ka murrinh warda mampirruneme ngarra pulangay nukunu, “Nga. Kardu nangkal ngatha nanhthi purrkpurrk terert mammath wurran-ka nhini-ka da tetemanthay-wa nhini-yu mere ngarra kama pinanu Yile neki Pule ngala ngarra kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nga. Murrinh deyida manarrunemenu. Kardu nangkal ngatha nanhthi terert mabath kurru-ka i purduyemitnu purru ngarra nanhthi nhini-ka, nukunu nhini-ka da tetemanthay nimin-ya mere ngarra kama kimardawith ngarra da Yile neki nukunu wangu-yu i mere ngarra nukun kani ngarra nukunu-yu. Nga. Ku nan ku camel nganaka? Ku-ka da tetemanthay-wa ngarra kanirdi-yu ngarra weyi kamarl ngarra nanhthi nil-yu, nawa? I mange nginipunh nhini mani-ya da-ka tetemanthay nimin-ya kardu nangkal ngatha nanhthi terert wanku mammath wurran ngarra pimardawithnu ngarra da Yile neki nukunu wangu-yu i pinu pangu-yu ngarra nukunu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bere peneme nhini-ka pumemnamardatneme ngala da matha murrinh ngarra Jesus thangunu merrudhaneme pirri-yu. I murrinh pumamnaneme, “Ya. Kardu nangkal mani warda Yile neki manthiyibirnu-yu i panmardawithnu da kangkarl-yu ngarra da nukunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bere Jesus-ka mempirrubirl-warda-neme pirrim yuthpan i murrinh mampirruneme, “Kardu-ka mere nangkal meyibirnu mange nukunu ngatha-yu, wurda, mu Yile neki da matha mani mayibirnu-yu. Nukunu da matha mani kardu manthibirnu-yu. Nukunu da matha mange da terert warda ngatha kama kurru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bere nukunu kathu Peter-ka mamna ngarra Jesus, “Nga. Ngankuneme-ka ngarnamkapart-warda-neme nanhthi purrkpurrk terert-yu, i kardu darrikardu ngankuneme wanku, i nanhthi thelput i nanhthi terert warda ngatha ngarnamkapartneme nhini weyida ngarra nhinhi warda nganhiriwaknemenu nguru-yu. Nhini-ka thangku nanhthi pangarrumutnuneme ngarra ngankuneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","I Jesus murrinh mampirruneme, “Nga. Kanhi-ka murrinh thathpirr manarrununeme. Da nakurl-te ngay kardu darrikardu nanki thathpirr-ka ku Pule ngala thathpirr nginu ngarra da chair ngala da kangkarl wangu-yu da ngarra lelunh marra thathpirr pangu-yu. I da nhini-nu-re-ka nankuneme deyida kardu 12 ngarra ngay narraningiriwakthaneme narde ku pule ngala deyida nenuneme ngarra da chair ngala ngala i nerrununeme ngarra kardu Jews wurnangat warda ngatha, kardu yek 12 nhini-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","I kardu nangkal ngatha thelput nukunu panipartnu i kardu ngathan, munak, kalekale i yileyile i kardu wakal nukunu paninpartnu i da ngarra putek nukunu wanku panipartnu i ngarra ngay warda pangiriwaknu pani, nhini Yile ngay-ka panamutmutnu purru thelput terert-ya i kardu darrikardu terert ngarra da putek ngala kanhi ngadha paninu-yu. I da nakurl-te-ka kardu nhini-ka bere matha wangu pinu kangkarl da ngarra Yile ngay wangu dim.” ");
INSERT INTO mwf2018_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","I Jesus-ka murrinh deyida mampirruneme, “Nga. Kardu terert ngamere ngarra kardu pumemnungalangala pumpan da ngarra putek ngala kanhi, nhini kardu-ka kunungingki warda thathpirr puyunu tiduk da ngarra Yile neki nukunu wangu. I kardu terert ngamere deyida-re kardu ngarra kunungingki pubamnupak pumpan da ngarra putek ngala kanhi, nhini kardu-ka ngala warda thathpirr puyunu kumparra ngarra da Yile neki nukunu wangu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bere Jesus kathu-ka mampirra, “Nga. Da nakurl-nu-re ngarra Yile neki ku Pule ngala thathpirr pinu, nhini-ka mangini murrinh kanhi mani ngurdinarrayithnu-yu. “Bere kardu nugarn pule ngala-ka da mi kadin ngala kanthidha dini i mi grape terert wurdinirurturttha dini. Bere da thipinhire pankapurl nukunu nhini-ka dempirnturt i pangu warda wangu nadha dini kardu-nu wurrinirrakaykaydha ngarra mi kadin nukunu-nu wurlk pumananu puru. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I murrinh merradha wurrini, i mam, ‘Ya. Wurlk numanganu ngatha ngarra mi kadin ngay nhini-ka ku $40 nganarramutmutnu ngirra da kungini terert-ya.’ I kardu kathu-ka ‘Yu’ pumenadha pardi. I bere nukunu ku pule nhini-ka wurdanpunthuk warda kardu nhini-yu ngarra mi kadin nukunu wurlk pumananu puru. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Bere nhini thangunu ngarra nanhthi ngunga dempirnturt-ka nukunu ku pule nhini-ka pangu deyida nadha dini ngarra kardu wurnangat pirriningkadhuktha-yu. I bampunkungkarduneme kardu nugarn ngamere ngathayida pedhaneme manangka wurlk. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I murrinh warda mampirruneme, ‘Ya peneme. Nankuneme deyida wanku wurlk numanganemenu ngarra mi kadin ngay, i nhini ngay-ka ku mani patha nganarrumutnemenu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I bere peneme nhini-ka pangu warda wangu punnadhaneme ngarra mi kadin nukunu wurlk-nu pumananemenu. “Bere nhini thangunu ngarra nanhthi ngunga kangkarl thathpirr warda pirridha-ka nukunu ku pule ngala nhini-ka kardu nugarn ngamere deyida wurdanpunkuthukneme ngarra mi kadin nukunu wurlk pumananemenu. I da ngunga numi nhini da ngatha da kungini nukun warda pirridha, kardu nugarn ngamere deyida wurdanpunkuthukneme ngarra mi kadin nukunu deyida-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“I bere nhini thangunu-ka da ngarra kungini thathpirr warda pirridha ngunga-yu, nukunu nhini-ka pangu deyida wangu nadha dini i kardu nugarn ngamere deyida bampunkungkarduneme ngathayida pedhaneme. I murrinh warda mampirruneme, ‘Ya. Thangku-dha da pirdithme kanhi nedhaneme nankuneme-yu manangka wurlk-yu kardu ngathayida narnamkaneme?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","I peneme kathu-ka pumamnaneme, ‘Awu, kardu mere nangkal ngadha wurlk dengarrumutthaneme.’ I nukunu nhini kathu-ka mampirruneme, ‘Mampa-ya, na-warda-neme pangu wangu i wurlk deyida numanganemenu ngarra mi kadin ngay.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bere ngarra nanhthi ngunga warda kanarnum-ka ku pule ngala nhini kathu-ka dimnakay warda kardu numi nhini-nu ngarra kardu dirranpedha kardi kardu pana ngarra wurlk pumenadha pardi ku pule ngala nhini-nu. I ku pule nhini kathu-ka mamna ngarra nukunu nhini-yu, ‘Ya. Thirrarrukayneme kardu nugarn pana ngarra mi kadin wurlk pumengadhaneme purne i ku mani tharrumutmutnemenu. I kardu ngarra tiduk ngarrimpirrukayneme, nhini-wa ku mani kumparra tharrumutnemenu. I kardu nugarn terert warda ngatha ku mani tharrumutmutnemenu i ngarra kardu nugarn pana da mana ngarra kardu marra-re ngarrimpirrukayneme.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“I bere nukunu kardu nhini-ka ku $40 danirrumutmutthaneme pirri kardu nugarn ngarra da kungini thathpirr wurlk pumpankaretneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","I bere kardu nugarn ngamere nhini ngarra da ngunga pankapurl wurlk-nu pumpankaretneme-ka pangu warda purnedhaneme ku mani-nu parnekutnemenu, i pubenayengkanirnthaneme purne ku mani ngala parnekutnemenu. Mu nukunu kardu nhini-ka ku $40 nhini da ngatha danirrumutmutthaneme pirri. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Bere kardu nugarn peneme nhini-ka ku mani nhini pardekutkutthaneme i pangu warda wangu purnenadhaneme ngarra ku pule ngala thathpirr i murrinh warda parranengkabirrdhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","I murrinh pumamnaneme, ‘Ya. Kardu nugarn pana nganaka ngarra da tiduk thirrimpirrukayneme-ka, wurlk kunungingki da matha pumempadhaneme parde. Mu ngankuneme-ka wurlk da pirdithme ngumempadhaneme ngarde ngarra da ngunga-re kathu pankapurl, nginthirrin ngala wanku ngardedhaneme. Mu nhinhi-ka ku mani nhini da ngatha thamngarrumutneme kardu ngankuneme terert kanhi warda ngatha.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“‘Mu bere,’ ku pule ngala nhini kathu-ka mamna ngarra kardu numi ngarra peneme-yu. ‘Awu wurda. Ngay-ka mere ngadha ngenarruyirrartthaneme, wurda. Mu nankuneme kardu-ka numamnga-mana-neme-ya ku $40 da matha-nu wurlk nuyemanemenu nuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mu ku mani pana-ka numabathnu-warda-neme i ngarra da warda wangu nanemenu. Mu ngay marda merttha ngini-ka ku mani nhini da ngatha ngampirrumutneme-yu kardu pana ngarra wurlk tiduk warda ngarrimpirrukayneme-ya i nankuneme ku mani nhini da ngatha ngamnarrumutneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mu ngay ku mani ngarra ngay ngammutmut ngurran-ka mange ngarra ngay da matha marda manganart ngurran. Mu nankuneme-ka kardu nanganpunkungke-kama-neme nhini-ka da mange patha mampirruneme i ku mani nhini da ngatha ngampirrumutneme kardu pana ngarra da tiduk kathu ngarrimpirrukayneme-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bere nhini-wa murrinh-yu ngarra Jesus wurdampirrayith. I murrinh warda mampirra, “Nga. Mange-ka nginipunh nhini mani-wa pamanu-yu ngarra Yile neki ku Pule ngala thathpirr pinu-yu. Kardu pana ngathayida kunungingki bamnupak tiduk kathu wurran da ngarra putek ngala kanhi, nhini kardu-ka ngala warda thathpirr purrunu kumparra ngarra da Yile neki nukun. I kardu pana ngarra memnungala dim da ngarra putek ngala kanhi bamnupak-ka, nhini kardu-ka kunungingki warda thathpirr purrunu tiduk da ngarra Yile neki nukunu wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bere ngarra Jesus pangu warda wangu nadha dini da Jerusalem-nu-ka, nukunu-ka panpunkuwerrneme pulangay nukunu kardu 12-ya mange peneme da matha i murrinh kanhi warda mampirruneme ngarra purnelilidhaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Nga peneme. Nubingayepupneme,” Jesus kathu-yu mampirruneme. “Nekineme kanhi-ka da Jerusalem-nu warda wangu thurranneme. I da pangu-ka ngay kardu ngarra darrikardu nanki thathpirr-ka pumangirtanu warda nhini-yu. I nhini thangunu ngay-ka pumangibertinu puru ngarra ku yilarn ngala ngala i kardu ngarra murrinh law puddanpunthethith pumpan. I nhini thangunu-ka pubungipaknu kumparra pangu warra ngarra kardu. I murrinh thirrukduk pumangirdarrithaknemenu ngay mana-wa da mange wiye mebaththa ngurrini-yu. I nhini-ka murrinh pumanganu warda ngay-ka thu pungibatnu i ngupupnu. I nhini thangunu ngay-ka pubangimardanu i pumangibertnu pangu warda wangu kardu ngarra mere thathpirr Jews-ya. I kardu nhini-ka pirangikampanu parni i thu pumangirdarrilalarrnu parni thu whip-te. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu,” Jesus kathu-yu mampirruneme ngarra pulangay nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bere palngun nukunu Zebedee i wakal nigunu perrkenku wanku purnenadhangime ngarra Jesus i perremnawinhipingkarlngime i murrinh mamna nigunu kathu-yu, “Pule, kardu nhinhi-ka da mange nanganu mani piguna kanhi-nu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Bere Jesus kathu-ka mamnge, “Ngarra-wa mange mampanu ngay-yu?” I nigunu kathu-ka mamna, “Ngarra nhinhi-re kardu Pule ngala thathpirr thinu da kangkarl pangu-ka, piguna kanhi-ka kardu pule ngala deyida mani penu i penhinganangurrunu mani ngarra nhinhi ngurru-yu batbat i thakunh-yu?” Dantharrpu nigunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mu Jesus kathu-ka mampirru, “Nanku-ka da mange mere thathpirr the numabath da mange ngala da matha pana-yu ngarra narramngidharrpu-yu. Kardu pana ngarra Jerusalem-ka thu pungithuknu puru i pangilututnu warda purru. I mange mere patha purunganu. Nanku-ka mange nhini deyida-nu pumanarrunu puru, na?” I piguna kathu-ka pumamna, “Yu, nganku-ka marda-wa ngumangankart nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I Jesus kathu-ka mampirru, “Yu, bere-ya. Mange-ka nhini da matha pumanarrunu-yu, i nhini-ka mange mere patha purunarrunu. Mu kardu pana ngarra penginganangurruninthanu ngarra batbat i thakunh-te-ka ngay-ka mere ngarra nukun mankungkarartnintha kardu nhini-yu. Mu Yile ngay-ka mampunkungkarart-wardarra-nintha kardu ngarra batbat i thakunh-te pininthanu-yu,” mampirru Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bere kardu ngarra pulangay ngamere kardu 10 kathu-ka puyempirruyepup murrinh ngarra piguna James i John pumenadha pe ngarra Jesus i nhini-ka peneme-ka parrampirrurithi warda ngarra piguna nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bere nhini thangunu Jesus-ka panpunkuwerrneme kardu pulangay nukunu-yu i mampirruneme, “Nga peneme. The mana nanthinpunkuneme-ya kardu pule ngala ngala pangu kardu mere thathpirr Jews-ya. Kardu pule ngala ngala nhini-ka da tetemanthay pirrimpirra ngarra kardu-nu-yu. I kardu pule ngala pirrimpirra ngarra kardu wurnangat nimin-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mu nankuneme-nu-ka mange mere nginipunh nhini mani nanemenu. Kardu numi ngatha ngarra nankuneme marda mart kardu pule ngala pinarrunemenu, nhini nukunu-ka kunungingki-wa buynupaknu i manankumanpi-warda-ngatha-neme kurru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","I kardu numi ngatha marda mart kardu kumparra pinarrunemenu, nhini nukunu-ka kunungingki-wa buynupaknu i manankumanpi-warda-ngatha-neme kurru. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nginipunh ngay mani kardu ngarra da kangkarl kathu ngurdamnarrathut-ka ngurrinidha da putek ngala kanhi kardu-wa-nu manmanpinu ngurru, mere kardu-nu pumangimanpinu puru. I ngana deyida ngurrinidha da kanhi-ka kardu-nu ngunarrapupnu i kardu-ka ngay-re-wa mananthibirnu-nu-yu. Ngay-ka ngunarrapupnu da mange wiye thangunu numedha nardi. I nhini thangunu-ka kardu mananthibirnunu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bere Jesus i pulangay nukunu-ka pumpankardurr-warda-neme-ka ngarra da nan Jericho i kardu wurnangat parrampunkuriwakneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bere kardu kamarrama perrkenku manta pangu da dinininthadha ngurru ngarra da mayern. Kardu nhini-ka bimninthayepup Jesus wunku kardu wurnangat wanku pubeyarrarrdha pardi. I dinininthakaykaydha warda, “Jesus, kardu tharntethbath ngarra King David thangunu kathu. Panhimardathin ngadha ngankunintha-nu i nangankumanpinunintha,” mamnintha penintha kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mu kardu wurnangat kathu-ka pumampirrunintha ngarra penintha nhini-yu, “Ya. Nadhap ngadha. Mere thininthakaykay, derrk da matha thinintha.” Mu penintha-ka puy deyida wangu dinininthakaykaydha lurruth da matha i pumenadhanintha dini, “Ya Jesus. Kardu tharntethbath ngarra King David thangunu kathu. Panhimardathin ngadha ngankunintha-nu i nangankumanpinunintha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","I bere Jesus-ka pirret warda mampirrunintha, “Thangku-nu? Mange ngarra-wa manarruninthanu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Pule,” pumamnanintha. “Nangankungkawathaninthanu kamarl ngankunintha patha ngurruninthabirlbirlnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bere Jesus-ka dampunkumardathinnintha penintha nhini-nu, i menkungkadhadhaptha-warda-nintha pirri kamarl ngarra penintha-yu. I bere kardu kamarrama nhini-ka kamarl patha warda kardininthadha i wurrinininthabirlbirldha warda i ngarra Jesus warda danininthariwaktha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bere nhini thangunu-ka Jesus i kardu pulangay nukunu-ka punnedhaneme da Jerusalem-nu warda wangu. Bere da nan warra ngadha parramkaruyneme da Bethphage i da palyirr nhini da nan Olive. I da-ka Jerusalem warda manta pardedhaneme-yu. I bere Jesus-ka mampirrukaynintha kardu pulangay nukunu kardu perrkenku purdunkuthukninthanu kumparra warra. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ya penintha,” mampirrunintha. “Kumparra warra thununinthanu thi da ngarra town kunungingki pangu-yu. I ngarra thanintharuynu-re-ka ku tangki i ku wakal nigunu daninthangkardunu pangu da karrimngintha. Ku-ka memnginthadharrk-wa pirrim. I thurdunintharerethnu nanhthi rup i ku perrkenku nhini-ka naninthabathnu warda kathu thurru ngarra ngay kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mu kardu ngatha murrinh kanhi manarruninthanu-ka, ‘Ya. Thangku-nu thurdannintharereth thanam ku pana-yu?’ Mu murrinh nankunintha-ka kanhi-wa numananinthanu-yu, ‘Nga. Pule ngankunintha-nu marda manganart ku perrkenku kanhi-yu. I bere nukunu nhini-ka purdunankuthuknu ku tangki wanku-yu.’” Murrinh-ka nhini-wa Jesus mampirrunintha-yu. I bere wurdanpunkuthuk-warda-nintha pangu warda wangu ku tangki perrkenku nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I da-ka nhini-ka murrinh thathpi ngarra Yile neki nukunu da murntak warra mam-ka murrinh thathpirr warda yibim da nhini-re-yu. I kanhi-wa murrinh mam-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kardu pana ngarra da nan narnam Zion, ‘Nga, kanhi kurran ku Pule ngala nanki ngarra ku tangki wakal kanthimnganardarri. Nukunu-ka kardu thanthanka da matha wurran.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bere penintha-ka naninthadha warda dini i ku tangki perrkenku nhini-ka bangamninthardurt warda pirringinthadha pangu ngarra thelput. I bere ku nhini-ka wurdannintharereth warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I meninthabaththa wurrini ku tangki i ku wakal nigunu nhini-yu ngarra Jesus-nu warda wangu-yu. I nanhthi kaligu penintha-ka yingamninthardarriwup ngarra pangkin ku tangki perrkenku. I Jesus-ka kanarnarrila warda ngarra ku tangki wakal nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","I kardu terert-ka nanhthi kaligu ngarra pigunu pardinaweweptha purni ngarra mayern pangu warra kumparra ngarra ku tangki-nu purrulilinu. I kardu ngamere-ka nithinu mulurn thay wath mani thangunu kathu pumunibewaththa punni i pingangkaweptha purni pangu warra kumparra ngarra ku tangki-nu purrulilinu wunku Jesus wanku pinthanhinganardarridha. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kardu wurnangat nimin-ya kumparra ngarra Jesus punnililidha i tiduk kathu ngarra Jesus parraniriwaktha punni. I kardu-ka punnikaykaydha i pumenanudha punni, “Ya, mampa. Nukunu kardu kanhi kanthim-ka kardu Pule ngala paninu kardu nginipunh pangu mani ngalantharr murntak nekingime-yu nukunu King David-ya. Pariparl-warda-ngime kardu Pule ngala kanthim kanhi-nu-yu. Yile neki-ka wurdannhethukngime kardu kanhi-yu. Mampa pariparlnu-warda-ngime Yile neki-yu.” Nhini-wa murrinh-yu punnikaykaydha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bere Jesus-ka pangarntuy warda da Jerusalem ngarra ku tangki pinthanhinganardarridha. I bere kardu wurnangat pangu pardidha-ka punninkawerrdha kardi i murrinh pumenanudha pi, “Ya, kardu nangkal kurran pana-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","I kardu ngamere kathu-ka murrinh pumerradha pi, “Nukunu pana kanthim-ka Jesus-wa, kardu Nazareth-mawu-ya. Nukunu-ka murrinh ngarra Yile neki nukun wurdanpirrayith wurran, ku prophet-wa nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bere Jesus-ka kanardi warda ngarra da church ngala kardu Jews pigunu. I kardu bampunkardu thelim pumedha pardi i peyim pumedha pardi ku yinpi, ku thip, ku nenigut i nanhthi purrkpurrk wanku ngarra da church ngala nhini-yu. Bere Jesus-ka wurdanpunkarel warda kardu nhini-yu. I daniwinhekpaktha wurrini nanhthi table kardu ngarra nanhthi pigunu kardu pana ngarra ku mani purninmatkuttha-yu. I wurriniwuthpuththa nanhthi chair kardu ngarra nanhthi pigunu kardu pana ngarra ku yinpi thelim pumedha pardi. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I bere Jesus kathu-ka murrinh warda mampirra kardu nhini-yu, “Nga. Yile neki-ka kanhi-wa murrinh nukunu yibimna-yu, ‘Thelput kanhi ngarra ngay-ka kardu-nu pirawatnu i parningangerrennu.’ Mu nanki-ka nubemkardurdu narnam kanhi ku mani-nu numampunkapdap narnam kardu ngarra terert thangunu kathu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bere kardu pulith i kardu kamarrama-ka punninadha ngarra da church ngala nhini da, i Jesus-ka patha menpathadha wurrini-yu kardu matharr-wunngini terert nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bere ku yilarn ngala ngala i kardu ngalantharr pana ngarra murrinh law kardu Jews pigunu puddininthethiththa purni-ka kardu mampunkumardarakineme warda nhini nukunu Jesus-ka da mange patha patha merradha wurrini-yu i kardu mamay wanku murrinh pikaykaydha ngarra da church ngala nhini-yu. Murrinh kanhi-wa kardu mamay pikaykaydha i pumenanudha pi, “Ya, mampa. Nukunu kardu kanhi karrim-ka kardu Pule ngala paninu kardu nginipunh pangu mani ngalantharr murntak nekingime-yu nukunu King David-ya. Mampa, pariparl-warda-ngime kardu Pule ngala karrim kanhi-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bere kardu ngalantharr nhini kathu-ka murrinh warda pumamna ngarra Jesus, “Ya, dimpirrayepup thirrim kardu mamay pana parnamkaykay-yu?” I Jesus kathu-ka murrinh mampirra, “Yu berengunh, ngay-ka bimpirrayepup ngarrim. Mu nankuneme-ka rit ngadha numedhaneme-ya murrinh kanhi ngarra Yile neki-yu, ‘Kardu mamay terert-ka murrinh tiparlti ngarra Yile neki-nu pariparlnu parni-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bere nhini thangunu Jesus i pulangay nukunu-ka pumpankardurr-warda-neme da Jerusalem thangunu kathu-yu i da Bethany warda wangu purnedhaneme i pangu da parnamkawitneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bere da thipinhire nhini-ka Jesus i pulangay nukunu-ka pumpankardurr-warda-neme da nan thangunu-yu da Bethany i punnedhaneme da Jerusalem-nu warda wangu. Bere Jesus-ka mi medeyi wurrinidha. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I nukunu bamkardu-yu nanhthi thay nanhthi nginipunh mi kurrangarr mani thay nan-ya fig-yu. I wurrinidha pangu da ngarra thay nhini da mi-nu. Mu mi-ka mere berdurttha, wurda, mu nanhthi mulurn da matha dinidha. Mi-ka mere da ngatha pinthangettha ngarra thay nhini-yu. I bere Jesus kathu-ka murrinh mamna warda ngarra thay nhini-yu, “Nga. Nhinhi thay pana thirrim-ka mi-ka mere deyida thinthatutnu thirra.” I bere thay nhini-ka demkawath warda. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bere pulangay nukunu Jesus-ka pubamkangkarduneme thay demkawath i pumemmardart-da-matha-neme. “Ya,” pumemnungkuneme. “Ngarra-re thay pana-yu mere pirdith demkawath-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mu Jesus kathu-ka mampirruneme, “Nga. Murrinh thathpirr kanhi-yu. Nankuneme ngatha murrinh thathpirr numangabathneme nuru, nhini nankuneme deyida-ka mange nginipunh pana deyida mani niyemanuneme ngarra thay pana mani karrim-yu. I ngana deyida ngarra da palyirr ngala pana karrim numananemenu, ‘Da palyirr ngala, thewirnturt i ngarra da lalingkin thununukunu.’ I nhini da palyirr ngala-ka murrinh warda manarrubathnuneme, kununuku nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","I Jesus kathu-ka mampirruneme, “Ngarra Yile ngay-re nadharrpununeme-ka nhini murrinh thathpirr numanabathnuneme da panarrumutnuneme-ya i nhini nukunu-ka kanarrumut-da-matha-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bere nhini thangunu-ka Jesus-ka wurdawurl deyida da ngarra church ngala kardu Jews pigunu. I ngarra nukunu-re kardu wurdininthethiththa dini ku yilarn ngala ngala thathpirr i kardu pule ngala ngala thathpirr punnenadhaneme. I murrinh pumamnaneme, “Ya. Nhinhi-ka nangkal thangunu murrinh mampa kardu thurdanpunthethith thurran kardu kanhi-yu? Kardu pule ngala ngarra nimin wurdannhithuk da kanhi-yu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mu Jesus kathu-ka mampirruneme, “Mu nga. Ngay-ka murrinh deyida nganankudharrpunemenu. I murrinh thathpirr ngatha nangidhartnemenu nhini ngay-ka murrinh manarrunemenu warda kardu nangkal wurdanngithuk-yu da mange kanhi-nu ngamam ngurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nangkal kardu John the Baptist wurdanthuk-yu kardu pana-ya ngarra kardu daninluluwewudha wurrini kura-re-yu? Nangkal nimin thathpirr wurdanthuk nukunu-yu? Yile neki thangunu kama i kardu thangunu kama-ya, ngarra nimin-yu?” Dampunkudharrpuneme Jesus kathu-yu. Bere kardu peneme nhini-ka puddanadharlurldhaneme pe murrinh mange peneme ngatha. “Murrinh kanhi ngatha pumananemenu, ‘Yile neki wurdanthuk nukunu John the Baptist-yu’, nhini nukunu Jesus-ka murrinh manhenemenu warda, ‘Mu thangku-dha murrinh mere numenabaththaneme-yu ngarra nukunu John the Baptist-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","I ngana deyida murrinh kanhi ngatha pumananemenu, ‘Kardu thangunu-wa nukunu John the Baptist wurdanthuk-yu.’ Nhini-ka kardu wurnangat kanhi-ka ngarra warda mange kumanheneme nhini-yu?” Nhini-wa murrinh pumenanudhaneme pe kardu peneme nhini-yu. I perrempunmanham kardu wurnangat, nhini-ka kardu wurnangat-ka the-wa panthidha purni Yile neki wurdanthuk nukunu John the Baptist-yu i murrinh ngarra Yile neki thangunu wurdanarrayiththa wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bere kardu peneme nhini kathu-ka pumamna-warda-neme ngarra Jesus-yu, “Yaa. Ngankuneme-ka mere the ngumabathneme nangkal nimin wurdanthuk nukunu John the Baptist-yu.” Mu Jesus kathu-ka mampirruneme, “Yu, bere-ya. Nhini ngay-ka mere deyida manarru-nukun-neme nangkal ngay wurdanngithuk-yu i mange kanhi ngarra ngay ngamam ngurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bere Jesus kathu-ka mampirruneme ngarra ku yilarn ngala ngala i kardu pule ngala ngala, “Nga. Nubingayepup-kathu-neme murrinh kanhi ngurdinarruyithnemenu. Kardu yileyile-ka kardu wakal nugarn perrkenku menkubertidha kardi. “Bere nukunu wurrininadha ngarra wakal nugarn kumparra-nu, i mamna, ‘Ya. Thurrunu pangu marra kanhi i wurlk nanganu ngarra mi kadin ngay ngarra mi grape terert wurdarnturturt wurran.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mu wakal nukunu nhini-ka mamna, ‘Awu, mere marda mart wurlk pangu ngamanu-yu.’ Mu da nakurl-te nukunu nhini-ka mange nukunu da ngatha mam, ‘Awu, bere ngatha ngurrunu.’ I ngarra mi kadin nhini wurrinidha i wurlk warda menadha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Bere nukunu yileyile nhini-ka wurrininadha ngarra wakal nukunu numi i murrinh mamna, ‘Ya. Thurrunu pangu marra kanhi i wurlk nanganu ngarra mi kadin ngay ngarra mi grape terert wurdarnturturt wurran.’ I nukunu nhini-ka mamna ngarra yile nukunu, ‘Yu yile, mampa-ya.’ I nukunu nhini-ka pangu warda nadha dini, mu mere wurridha ngarra mi kadin wurlk-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bere Jesus kathu-ka mampirruneme ngarra kardu peneme nhini-yu, “Nganaka, kardu wakal ngarra nimin murrinh mamnabath yile nukunu-yu?” I kardu kathu-ka pumamnaneme, “Kardu pana nimin wakal kumparra-ya.” I bere Jesus kathu-ka mampirruneme, “Nga. Murrinh thathpirr kanhi manarrunemenu-yu. Kardu nugarn pana ngarra ku mani parnamnanmatkut ku Government-nu i ku mani pumamnankapdap pumpan, i kardu palngun wiye wiye deyida wanku, kardu nhini-ka da mange wiye parnipirrnu warda i da mange ngarra Yile neki nukunu warda pariwaknu purru i da ngarra Yile neki nukunu wangu purunu, mu nankuneme-ka wurda-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nukunu nan John the Baptist-ka pangamnarraruy i damnarrangkarda da mange yuthpan-yu. Mu nankuneme-ka mere murrinh numenabaththaneme nukunu-yu. Mu kardu nhini ngarra ku mani parnamnanmatkut i kardu palngun wiye wiye nhini-ka murrinh pumamnabath. I nhini nankuneme-ka nubampunmangkardu-wa mange nhini pumedha purni, mu nankuneme-ka mere narnepartthaneme da mange wiye nhini ngarra numebaththaneme nurne i mere murrinh numenabaththaneme nukunu John the Baptist-yu, wurda da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nga.” Jesus kathu-yu mampirruneme. “Nubingayepup-kathu-neme murrinh numi kanhi murrinh yibimkamnum-ya. Bere kardu pule ngala ngarra mi kamarl mi grape bebirrbirrdha wurrini da ngarra putek nukunu. I nhini thangunu-ka nanhthi palyirr bengkardadha wurrini pana-re daniwegattha wurrini. I mampatha nanhthi palyirr werlpen pewerti marda mi kakpa-nu i punnuriyerrknu me-re. I thelput kangkarl deyida bangamkarda kardu-nu pirrabirlbirlnu pi kardu nukun mi grape nhini kanidarrarart. Bere nhini thangunu-ka kardu ngamere pirrimpirrukayneme mi ngarra kadin nukunu piranapenemenu parne. I murrinh mampirruneme, ‘Nga peneme. Mi ngarra grape-te thungku pebaynu-ka numuberartalnemenu i mi warda pumemarryerrnemenu nhini-yu.’ Bere nhini thangunu-ka kardu pule nhini-ka kanampart nungardurr warda mi kadin nhini-yu i da ngamengka-nu warda wangu nadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Bere, da nakurl-te ngarra mi grape nhini-re mi thungku thungku wurriningkadhuktha-ka nukunu ku pule nhini-ka kardu ngarra nukunu wurdanpunkuthukneme mi pumanayerryerrnemenu kardu pana thangunu ngarra mi kadin nukunu piranapedhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mu peneme nhini-ka pumanganpunkurtaneme kardu nugarn nhini ngarra kardu pule wurdanpunkuthukneme-yu. I kardu numi-ka thu purnebatthaneme parde, i kardu numi-ka thu pumpankabatneme puddankarinumineme, i kardu numi-ka nguni palyirr pubewelerrdhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Bere nhini thangunu kardu pule ngala nhini-ka kardu deyida wurdanpunkuthukneme kardu terert tharrngini warda mi pumanayerryerrnemenu. Mu kardu pana ngarra mi kadin nukunu piranapedhaneme parde-ka thu deyida kathu punninkuthukthaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Bere nhini thangunu nukunu kardu pule ngala nhini-ka wakal nugarn ngarra nukunu thathpirr wurdanthuk. I murrinh memnu, ‘Wakal ngay pubinayepupnemenu i mere thu kubat-nukun-neme.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mu bere, ngarra kardu nhini-re pubamkangkarduneme kardu wakal ngarra kardu pule ngala nukunu, nhini-ka murrinh warda pumemnungkuneme, ‘Ya, nhini da kunungam kem wakal nukunu thathpirr kardu pule-yu. Da nakurlnu ngarra yile nukunu-re pupupnu-ka nukunu warda mi kadin ngala kanhi martnu i mabathnu pi-yu. Ka, purru-wa-neme i thu pubatnemenu ngangka da i nhini nekineme warda-wa mi kadin ngala kanhi pumartnemenu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bere peneme nhini-ka pumangankartaneme wakal nukunu kardu pule nhini-yu i punnungamkakuneme pangu wangu outside ngarra mi kadin i thu pumpankabatneme i puddankarinumi-warda-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","I bere Jesus kathu-ka mampirruneme, “Mu nga. Murrinh mani numanganemenu. Ngarra kardu pule ngala nhini kathu kurdiwurl, ngarra mana warda mange nhini-yu marrunemenu ngarra kardu peneme pana ngarra wakal nukunu thu pumpankabatneme-yu?” Dampunkudharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","I peneme kathu-ka pumamnaneme ngarra Jesus, “Nukunu kardu pule nhini-ka thu punkuthuknu-warda-neme i purdunkurinuminuminemenu thathpirr warda peneme wiye nhini-yu. I kardu ngamere deyida pirrarrukaynemenu mi ngarra kadin nukunu piranapenemenu parne-yu, kardu nhini-ya ngarra mi grape mi thungku pumanayerryerrnemenu parne.” ");
INSERT INTO mwf2018_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bere Jesus kathu-ka murrinh mampirruneme, “Nga. Nankuneme-ka murrinh rit ngadha numedhaneme murrinh ngarra Yile neki nukun yibimnangurrkurrk-yu? Kanhi-wa murrinh nhini-yu. ‘Kardu nugarn pana ngarra thelput pubengkardadha pardi nanhthi palyirr-te, nanhthi palyirr numi punnungamku, nhini-ka nanhthi wiye mana-wa pamam. Mu marra kanhi nanhthi palyirr ngala nhini-ka tetemam warda pirrim ngarra thelput nhini-yu. I da thelput nhini-ka yuthpan warda pirrim nanhthi palyirr nhini thangunu-yu. I Yile neki banpak nanhthi palyirr nhini-yu, i nhini-ka patha warda thathpirr.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“I nga.” Jesus kathu-ka mampirruneme. “Yile neki-ka mere warda mange patha manarrunemenu purru i mere ku Pule ngala pinarrunemenu ngarra nankuneme-yu, wurda. Mu kardu ngamere deyida ngarra da mange nukunu parrarntiwak thathpirr pumpan-ka, da mange patha marranu purru i ku Pule ngala thathpirr pirranu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","I nga. Kardu ngatha bamengkatnu ngarra palyirr tetemam ngala nhini, nhini nukunu-ka buydhanmertal-wa nhini-yu. I nanhthi palyirr nhini ngatha kaniyegarl ngarra kardu, nhini-ka bamerl da matha nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bere, ngarra ku yilarn ngala ngala i kardu Pharisees nhini murrinh pubimnayepupneme-ka, kardu peneme-ka pumangankamartaneme murrinh nhini Jesus wurdanpunkuyithneme murrinh mampunkungkardarrathneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I nhini-ka parramnarithi-warda-neme i pumertadhaneme-wa. Mu wurda, peneme nhini-ka parnamkapartneme, nhini-ka perrempunmanham ngarra kardu wurnangat. I kardu wurnangat nhini-ka murrinh kanhi pumedha purni, “Ya. Nukunu pana Jesus-ka ku prophet thathpirr-wa pana kurran-yu.” Kardu-yu pumam. ");
INSERT INTO mwf2018_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bere kardu Pharisees ngamere puyemnawerrneme ngarra Jesus, i murrinh dampunkudharrpuneme i mampirruneme, ");
INSERT INTO mwf2018_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ya, kardu nukunu nhini Christ nganaka? Kardu ngarra kathu darntethbath nukunu nhini-yu?” I peneme nhini kathu-ka pumamnaneme, “Nukunu kardu darntethbath-ka ngarra King David thangunu-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bere Jesus-ka murrinh deyida mampirruneme, “Nga. Ngepan ngarra Yile neki nukunu murrinh kanhi mamna ngarra King David da murntak warra, ‘Nukunu Christ-ka ku pule nhinhi-wa nananu thurru.’ Mu nankuneme numamnganeme-ka nukunu nhini-ka ngarra King David thangunu kathu darntethbath-yu. Nhini-ka thangku-dha King David menadha wurrini ‘Pule-yu’?” Mampirruneme Jesus kathu-yu. “Nga. Kanhi-wa murrinh-yu ngarra nukunu King David mam-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Pule ngala Yile neki murrinh mamna ngarra ku pule ngay-yu, “Nga. Kanhi thinu ngarra ngay batbat-te i kardu pule ngala deyida wanku thinu. I kardu pana ngarra mere marda kumanhert kuru, nhini ngay-ka ngirranputhnu pangu warra kumparra, i nenawinhipingkarlnu ngarra me nhinhi.”’ Nhini-wa murrinh King David darntilil-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","King David-ka ‘Pule’ menadha wurrini kardu Christ-yu. Mu ngarra-re nukunu Christ-yu kardu darntethbath ngarra King David thangunu-yu?” Jesus kathu-yu dampunkudharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mu mere nangkal ngadha murrinh nhini-yu dedharttha. I da nhini thangunu kardu nhini-ka mere deyida murrinh perradharrpudhaneme nhini-ka perremkamanham-weyida-neme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bere Jesus-ka bempirrangkarnirn warda kardu ngarra da Jerusalem pardipuptha-yu i medha warda dini murrinh mange nukunu, “Ya, kardu Jerusalem-nan-mawu. Ngay-ka damngimardathin-wa dim nanki-nu-yu. Nanki-ka thu numpanpunthuk numpan ku prophet-yu i nguni palyirr nubangampunpelerr numpan kardu nugarn pana ngarra Yile neki kathu wurdanpunthuk nanki-nu. I da terert da matha ngay marda menanarttha ngurrini-yu i menanmanpidha ngurrini-yu i menanperdurdudha ngurrini mangini ku kalekale thikin mani mampunperdurdu-ya ku ngarra wakal nigunu. Mu nanki-ka mere marda numengerttha nuyi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mu nga. Yile neki-ka paninanpartnu warda nanki-yu i da church ngala nanki. ");
INSERT INTO mwf2018_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“I ngay murrinh manarranu-ka nanki-ka mere deyida nubangingkardunu, mu da ngarra ngay thathpirr ngurdiwurlnu da ngarra putek ngala kanhi. I da nhini-nu-re nanki-ka murrinh kanhi warda numanganu, ‘Ya mampa, pariparlnu-warda-ngime kardu kanhi ngarra Yile neki kathu wurdanthuk wunku lurruth ngala Yile neki nukunu.’” Nhini-wa murrinh Jesus denarramardamtha dini kardu ngarra da Jerusalem pardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bere Jesus-ka yungawuy ngarra da church ngala pigunu kardu Jews i nungardurr warda. I kardu pulangay kathu-ka pumamnaneme, “Pule nga. Da church ngala kanhi karrim-ka da ngala nawa? I da-ka patha-wa thathpirr.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mu Jesus kathu-ka mamna, “Nga. Da church ngala kanhi ngarra nubamkangkarduneme nibimka-ka da nakurl-nu-wa kardu-re pubayimpurrnu puru palyirr terert kanhi-yu. I nanhthi palyirr ngala ngala kanhi-ka da pana ngangka-re buymardarrurrnu purru.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bere nhini thangunu Jesus i pulangay nukunu-ka punnadhaneme i pirrimkamardawithneme da palyirr nan-nu Olive i da kangkarl parnamkawupneme. Bere ngarra kardu makardu mana warda-ka pulangay nukunu-ka purnenadhaneme ngarra Jesus i pumamnaneme, “Ya pule. Minthire kardu thu kuy pubayimpurrnu puru-yu da church ngala pangu karrim-yu? I ngarra-re-wa kardu ngankuneme the ngumabathnuneme-yu da ngarra manta warda da nhini-re puyimpurrnu puru-yu? I ngana deyida ngarra-re the ngumabathnuneme-yu da putek kanhi panirikerdeknu-yu i minthire nhinhi thurdiwurlnu kathu-yu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mu Jesus kathu-ka mampirruneme, “Nga peneme. Nankuneme-ka thawath wangu nanemenu kardu pana ngarra murrinh thirrukduk panarrayirrarartnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nga. Kardu nugarn terert warda kathu purunu nhini-yu i murrinh panarrayirrarartnu parni nginipunh murrinh kanhi mani-ya pumanarranu-ya, ‘Ngay-ka Christ-wa. I Yile neki wurdanngithuk ngay-yu.’ I kardu wurnangat ngamere deyida murrinh nhini pumarrabathnu puru kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“I nanki-ka nubirrayepupnu kardu wurnangat thu kuy ngala da matha puyuwurdupnu da manta kanhi ngatha-ya. I nuyurrayepupnu kardu wurnangat thu kuy ngala puyithuknu puru da ngathparr pangu wangu-ya. Mu nanki-ka mere nenham nukun da nhini-re-yu mange-ka nginipunh nhini mani-wa puyemanu puru-yu. Mu da putek kanhi-ka mere da ngatha panirikerdeknu da nhini-nu-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kardu wurnangat warda pumethanu puru da ngamengka da numi numi nhini thangunu kathu. I kardu pule ngala ngala i kardu ngarra peneme ngatha pumethanemenu puru-ya. I da putek-ka purrurangkaltangkalnu da pana ngangka-re-ya. I kardu wurnangat-ka mi dhepdhep-ka mami parninu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","I da nhini-re-nu-ka kardu-ka da tetemanthay pubardurtnu puru da puretnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“I nga. Kardu-ka mere marda pumananartnu puru nhini-ka ngay thangunu weyida narramngiriwak numpan nhini-yu. I kardu-ka purunanngawurtnu i pumananbertinu puru ngarra murrinh court wangu. I kardu thu punanthuknu puru i pudduntinuminuminu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","I da nhini-nu-re-ka kardu wurnangat pangu-ka parnipartnu warda Yile neki-yu. I kardu darrikardu ngamere pigunu-ka pangu warda wangu pumenubertinu puru ngarra thu pubatnu i puwelerrnu parni. I kardu nhini-ka mere warda marda pumunurtnu parni. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Nga. Kardu nugarn terert warda kathu purunu nhini-yu i murrinh panarrayirrarartnu parni nginipunh murrinh kanhi mani-ya pumanarranu-ya, ‘Ngay-ka Christ-wa. I Yile neki wurdanngithuk ngay-yu.’ I kardu wurnangat ngamere deyida murrinh nhini pumarrabathnu puru kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","I da wiye thathpirr-ka buylangnu da pana ngangka-re i kardu wurnangat-ka mere warda marda pumenurtnu parni. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mu kardu nangkal ngatha bere ngatha wangu pangiriwaknu thathpirr pani i mere kaningipart nukun-ka kardu nhini-ka bere matha wangu paninu ngarra ngay-yu da kangkarl wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mu da putek kanhi-ka mere da ngatha panirikerdeknu da nhini-re-yu. Mu da marra-re warra ngadha-ka murrinh thelerrdhe patha ngarra ngay nanthelerrnu nuru da ngarra pana ngangka-re-ya ngarra kardu wurnangat warda ngatha. I kardu-ka the warda pumabathnu ngay da matha ku Pule ngala thathpirr pinarranu. I nhini thangunu-ka da putek kanhi-ka panirikerdek-da-nu-matha nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Bere Jesus kathu-ka mampirru-deyida-neme, “Murrinh kanhi-ka nubiyepup-thathpirr-neme i numangimartanemenu. Nga, nubangkardunu kardu walmamka kardu kurdumparle thathpirr pirranu ngarra da church ngala pangu-yu. Nukunu nhini-ka Yile ngay mere marda thathpirr mart kurru. I nukunu nhini-ka mere mani kanirdi i kirra ngatha ngarra da church pangu-yu. Nukunu kardu ngalantharr murntak Daniel ku prophet-ya, murrinh darntilil ngarra nukunu kardu wiye nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mu bere ngarra nukunu ku walmamka nhini-re nubangkardunu pirranu pangu-ka tharra pirtpirt da matha nunnuwinhatnu ngarra da palyirr da ngathparr pangu wangu-yu nanki-yu kardu ngarra da Judea narnam-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","I ngarra da nhini-nu-re-ka kardu ngatha pinu ngarra thelput werlpen da kangkarl kathu-ka, nukunu nhini-ka mere deyida kanirdi ngarra thelput nukunu nanhthi purrkpurrk nukunu-nu panikutnu, mu tharra da matha punuwinhatnu ngarra da palyirr-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","I kardu deyida ngarra mi kadin panirurtuynu ngatha-ka nukunu nhini-ka mere deyida pununu pi pangu ngarra thelput nanhthi kawut nukunu-nu martnu, mu tharra da matha punuwinhatnu nhini-yu ngarra da palyirr-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","I da nhini-nu-re-ka da-ka tetemanthay-wa pubardurtnu kardu palngun-yu kardu ngarra putput purunu-yu i kardu palngun pana ngarra kardu mamay punthaygurduknu puru ngapurlu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nhini Yile ngay nadharrpunu da tetemanthay nhini-ka mere karuy nukun da ngarra burrburr-yu i da ngarra Saturday-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“I da nhini-re-ka kardu wurnangat warda ngatha da tetemanthay nimin-ya pubardurtnu thu kuy ngala nhini thangunu-yu i da nginipunh nhini mani-ya. I da ngarra marra-re kathu ngarra Yile ngay mampatha da putek ngala kanhi i kardu wanku mampatha i da ngarra marra kanhi da mana thim-ka da tetemanthay ngala nimin-ka mere puberdurdurttha puyi da nhini-re-yu, mu da tetemanthay ngala nimin-ka kurran-wa kathu nhini-yu da nakurlnu-yu. I da tetemanthay ngala nhini thangunu pirtalnu-ka nhini-ka mere deyida paninu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mu da tetemanthay ngala nhini ngatha pirranu bere ngatha wangu-ka nhini-ka kardu wurnangat warda ngatha puruwuwupnu nhini-yu. Mu Yile ngay-ka mere warda purdumurlnu da tetemanthay ngala pirdithme nhini pirranu-yu. Mu pangu da wangu ngaliwe bartal-da-nu-matha da tetemanthay nhini-yu kardu pana-nu kardu ngarra nukunu thathpirr kardu ngarra mampunkarart-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bere Jesus kathu-ka mampirru-deyida-neme, “Nga. Da ngarra nhini-nu-re-ka kardu ngamere kama murrinh pumanarranu-ya murrinh nginipunh kanhi mani-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim kanhi, Yile neki kathu wurdanthuk nukunu-yu.’ I ngana deyida murrinh kama pumanarranu-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim pangu-ya.’ Mu murrinh nhini-ka mere thathpirr murrinh nhini-yu, murrinh thirrukduk-wa. I mere murrinh nukun numarrabath nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","I kardu parurtuynu pira kardu Christ thirrukduk-ya kardu pumenurartnu parni Yile ngay mana-wa kurdunthuk. I ngana deyida kardu nugarn ngamere deyida parurtuynu pira kardu pumenurartnu parni murrinh ngarra Yile ngay mana-wa kurdurrayith kani. Mu kardu nhini-ka kardu thirrukduk deyida. I kardu nugarn nhini-ka mange ngala ngala terert puyemanu parni-ya wunku nanhthi lurruth ngala deyida puyemanu parni. I kardu wurnangat warda ngatha pumerramardatnu parni. I kardu nhini kathu-ka panarrayirrarartnu parni kardu wurnangat warda ngatha i nanki kama kardu ngarra Yile ngay nukunu-yu kanarrayirrart nukun. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nga, nubingayepup kathu. Ngay-ka mamnarruneme ngem murrinh terert kanhi-ka the numabathnemenu da nhini-nu paruynu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bere Jesus kathu-ka mampirru-deyida-neme, “Nga. Da ngarra nhini-nu-re-ka kardu ngamere kama murrinh pumanarranu-ya murrinh nginipunh kanhi mani-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim pangu ngarra da darrinpirr pularn i Yile neki kathu wurdanthuk nukunu-yu.’ Mu wurda, mere nukun nuru da pangu-yu. I kardu ngamere deyida kama murrinh pumanarranu-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim pangu marnarri dim-ya.’ Mu wurda, murrinh mere nukun numarrabath nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","I da nhini thangunu kardu-ka pubangingkardunu ngay kardu darrikardu nanki thathpirr-ka ngurrunu kathu i pangilarrangnu purru-yu nginipunh thu malarntath mani dimmamath i damkayip da terert warda ngatha mange nginipunh nhini da mani ngay ngurdiwurl-deyida-nu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bere Jesus kathu-ka pumamnaneme, “Ngarra ku nginipunh yibimpup kabim-ka nhini-wa da-yu ngarra ku tiwungku puyuwerrnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“I nga.” Kangkarlmawu kathu-yu mampirru-deyida-neme. “Ngarra thu kuy ngala nhini i da tetemanthay ngala nhini thangunu-ka nanhthi ngunga-ka mere warda palarrangnu pirra, wurda warda nhini-yu. I ngana deyida nanhthi merrk-ka mere warda pangkawipnu pirra-yu. I nanhthi pilinh-ka parniyimpurrnu kangkarl kathu-yu. I nanhthi pana kangkarl karnam-ka pirangkaltangkalnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","I da nhini thangunu kardu-ka pubangingkardunu ngay kardu darrikardu nanki thathpirr-ka ngurrunu kathu ngarra kalakkalak ngurrurdurdinu kathu. I kardu-ka du da matha parnikarrknu ngarra pubangingkardunu kardu Pule ngala thathpirr warda ngurrunu nhini-yu wunku nanhthi lurruth ngala i ngay da matha warda pangilarrangnu purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","I nanhthi trumpet ngala warda lurruth pirrakaynu i ku angel warda ngurdunthuknu kardu ngarra Yile ngay nukunu purunmetkutnu i punperrnu puru da pana ngangka-re-ya. Kardu nhini ngarra Yile ngay menkararttha wurrini da ngala kurran kanhi i ngangka-re-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bere Jesus-ka murrinh deyida wurdampirruyithneme i mampirruneme, “Nga. Numangkathannu nanhthi thay thangunu kathu. The mana nanthin-ya nanhthi marlanpakpak ngarra thay-yu pangarntuy warda-ka nhini-ka da thangku manta warda nhini-yu, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","I mange nginipunh nhini deyida mani-ya ngarra nanki-re nubangkardunu nanhthi kangkarl nhini pamanu purru-ka nhini-ka the numabathnu da-ka manta warda ngay ngurdiwurlnu da putek ngala kanhi-yu i Yile ngay-ka ku Pule ngala thathpirr warda pinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Nga, murrinh thathpirr kanhi-yu. Thu kuy ngala nhini i da terert nhini ngarra ngay ngurdininarruyiththaneme ngini-ka da nhini-ka panarraruynu ngarra kardu wurnangat kanhi-re kardu birnu da ngatha numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","I nga, nanhthi ngunga, merrk, nanhthi pilinh i da putek ngala kanhi-ka nanhthi mananhthi-nu warda i manangka da-nu warda panirikerdek-da-nu-matha. Mu murrinh thathpi ngarra ngay-ka mere ngarra nukun kanirikerdek, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Mu da nhini-nu-re ngarra ngay deyida ngurdiwurlnu kathu-ka, kardu-ka mere nangkal-wa the mabathnu da nhini-nu-yu. I ku angel deyida wunku mere the pumabathnu-yu i ngay deyida wanku da nhini mere the mabathnu-yu, ngay ngarra wakal nukunu thathpirr-ya. Mu Yile ngay da matha the kanthin dim da ngarra ngay purdungithuk-deyida-nu-yu ngarra ngurdiwurl-deyida-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Nga. Da murntak warra nganaka ngarra nukunu Noah tharntu ngala bangarnerde. Nukunu Noah-ka murrinh merradha kardi da mange wiye parnipartnu i puddinawurlnu ngarra Yile neki i mere the pumebaththa da minthire kura ngala parraruynu-yu. I bere kardu-ka murrinh-ka mere pubinayepuptha mu bere matha wangu mi pardimurrktha kura pardigurdugurduktha i bere ngatha wangu kardu nugarn i palngun pubanamardurdidha punni i ngarra Noah da mana parnamkardingime ngarra tharntu wunku kardu darrikardu nukunu. I nhini thangunu-ka kura ngala warda kanamyel kura ngala nimin-ya wurrinidha i kardu-ka dampunthiwik warda. Mange nginipunh nhini mani kardu pumedha pardi da ngarra nhini-re-ya. Mu kardu-ka mange-ka piyema-deyida-nu parni da nakurlnu ngarra ngay-re ngurdiwurlnu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","I nga,” Jesus kathu-yu mampirru-deyida-neme. “Ngarra ngay-re ngurdiwurl-deyida-nu kathu-ka kardu nugarn perrkenku-ka paninintharurtuynu ngarra mi kadin. I Yile ngay-ka pamardawithnu numi kangkarl i numi-ka panipartnu pangu da wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","I kardu palngun perrkenku-ka mi kamarl pilanginthayerlnu pani. I Yile ngay-ka numi da matha pamardawithnu kangkarl wangu i numi deyida panipartnu pangu da wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nhini nankuneme-ka niranunginikatnuneme i nuyungabirlbirlnuneme nhini-ka mere the numabathneme da minthire ngarra ngay deyida ngurdiwurlnu kathu-yu, kardu Pule nankuneme-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nga. Kardu darrarartka nganaka. Nukunu-ka purrunu pangu ngarra thelput ngarra kardu-re mere mankulkulnu pi i mangkardap warda nanhthi karnabuy-nu. Mu kardu ngatha mankulkul ki-ka kardu darrarartka nhini-nu-yu, nhini-ka kardu-ka kiranginikat warda kardu nhini-nu-yu i kubumadhap warda darrarart nhini-yu ngarra thelput nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mange nginipunh nhini mani-ya nanki-ka mere the numabathnu minthire ngay ngurrunu kathu-yu, nhini nanki-ka niranginginikatnu i nuyungamardamardanu ngarra ngay deyida kathu ngurdiwurlnu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Bere Jesus kathu-ka murrinh numi deyida mampirra, “Kardu pana ngarra wurlk patha mamna wurran ku pule ngala nukunu-nu-ka nginipunh kardu kanhi mani-wa. Nga, kardu pule ngala-ka memmangkart kardu ngarra wurlk thangunu kathu pumenadha punni thelput ngarra nukunu pirranapenu pi i kardu pule parethbathnu kardu pule pirranu ngarra kardu nukunu. I nhini thangunu kardu pule ngala-ka nungardurr pangu warda wangu da ngarra numi-nu. I kardu pule numi ngarra darntethbath-ka thelput dirranapedha kardi-yu i wurlk danirramutmuttha wurrini i mi dhepdhep danirramutmuttha kardi ngarra kardu nhini-yu. Nukunu kardu nhini-ka kardu patha-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bere da nakurl-te kardu pule ngala nhini-ka wurdawurl deyida kathu i bamkardu kardu pule numi-yu da mange patha wurrinidha i nhini-ka le warda kardinadha kardu pule ngala nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bere kardu pule ngala nhini-ka banpak warda kardu pule numi nhini-yu nanhthi terert ngarra nukunu pirranapenu pi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“I nga,” Jesus kathu-yu mampirra. “Mu kardu nhini murrinh kanhi ngatha midha, ‘Yaa, kardu pule ngala pangu-ka da pirdithme kanarnum-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ngay-ka kardu mere mange patha marrabathnu ngi kardu ngarra nukunu-yu.’ I nhini thangunu nukunu-ka thu panpunthuk warda kanam i mi dhepdhep kanammurrk i kura murlak ngala da matha kanamkurdugurduk wunku kardu ngamere ngarra kura parnamkurdugurduk. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mange nhini mani nukunu kama kurru-ka nukunu-ka nhini-ka mere mani the-wa mabath ngarra pule ngala purdiwurl-deyida-nu kathu-yu. I mere mani-wa makulkul ki nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I ngarra nukunu pule ngala nhini-re purdiwurlnu-ka nhini bangkardunu nukunu-ka kardu wiye-wa nhini-yu i nhini-ka pubatnu warda i purdungkarelnu nhini-yu kardu da ngarra wiyenpun parnam pangu-ya wunku nanhthi yidingurr ngala da matha parninu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Bere Jesus kathu-ka mampirru-deyida-neme, “Nga peneme. Da nakurlnu ngarra ngay ngurdiwurl-deyida-nu kathu-ka, nhini-ka mangini murrinh ngurdinarruyithnemenu kanhi mani manarrunemenu-yu. “Bere, kardu mardinhpuy 10 pumangankakutngime thungku lem numi numi i parramkaribirlngime i pumpankardurr-warda-ngime kardu nugarn pubamardabinungime i ngarra thelput warda pumangebertinungime ngarra kardu palngun buynginthamardinu warda, i mi dhepdhep-nu parnemurrknungime. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","“Bere kardu mardinhpuy 5 ngamere nhini-ka kardu pelpith wiye-wa pardedhangime, i kardu mardinhpuy 5 ngamere nhini deyida-ka kardu pelpith patha-wa pardedhangime. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kardu mardinhpuy 5 pelpith wiye pardedhangime nhini-ka thungku lem peningime pumebaththangime purne wunku nanhthi kerosene kunungingki pana da matha ngarra thungku lem dininganamardadha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mu kardu mardinhpuy 5 pelpith patha pardedhangime, nhini-ka thungku lem peningime pumebaththangime purne wunku nanhthi kerosene ngala ngarra nanhthi pul wanku pumebaththangime purne. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Bere kardu nugarn nhini ngarra buynginthamardinu warda-ka da pirdithme da ngatha kardidha, mere da ngatha deruydha. I kardu mardinhpuy peningime nhini-ka kardu warda pardewalawalakadhangime i ngurrnguwarl warda pardengurrkurrkthangime. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","I bere da thipinhi nhini-ka da kalkkalk-ya kardu numi kathu pirrimkay, i mam, ‘Ya. Kardu nugarn nhini-ka pangu kathu kurran, kardu nhini-ya ngarra palngun warda buynginthamardinu. Ka, purru-warda-ngime i pubamardabinungime.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Bere kardu mardinhpuy nhini-ka perremkawirnturt-warda-ngime i thungku lem warda parramkaribirlngime. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","I kardu mardinhpuy pelpith wiye pardedhangime nhini-ka murrinh warda pumampirrungime ngarra kardu mardinhpuy pelpith patha pardedhangime, ‘Ya. Nanhthi kerosene mani kathu. Thungku lem ngarra ngankungime-ka wurrankarrarr warda.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mu peningime pelpith patha pardedhangime nhini kathu-ka pumampirrungime, ‘Awu, ngankungime-ka nanhthi ngarra ngankungime da matha-nu ngumebaththangime ngurne. Mu nanhthi ngatha nganarrumutnungime-ka thungku lem ngarra ngankungime deyida kingankumangkarrarr-nukun-ngime. Mu na-warda-ngime pangu wangu ngarra shop i nanhthi narnekutnungime.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bere kardu mardinhpuy nhini-ka pangu warda wangu purnedhangime nanhthi kerosene-nu parnekutnungime. Mu ngarra peningime-re pumpankardurrngime-ka kardu nugarn nhini-ka pangarntuy warda ngarra buynginthamardinu. I kardu mardinhpuy 5 pelpith patha nhini pardedhangime ngarra pardenamardamardadhangime-ka kardu warda pubangamkamardabingime nukunu nhini-yu, i pangu warda wangu purnedhangime ngarra da thelput mi dhepdhep parnimurrknungime. I parnamkardingime thangunu-ka nanhthi tuwa-ka danthap warda ngarra da thelput nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Bere da nakurl-te puddamkawurlngime kardu mardinhpuy 5 pelpith wiye nhini ngarra nanhthi kerosene-nu purnedhangime parramkaruyngime ngarra da thelput nhini-yu. I pibimnakayngime ngarra ku pule ngala nhini-nu ngarra dininganamardadha-yu. I pumamnangime, ‘Ya pule, nanhthi tuwa kathu nangarrudharlngime ngarnerdinungime.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mu nukunu nhini kathu-ka mampirrungime, ‘Awu, ngay-ka mere thathpirr the manankubathngime.’” Nhini-wa murrinh wurdampirrayith ngarra Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","I bere nukunu Jesus kathu-ka mampirra ngarra kardu nhini, “Nga kardu. Da bere matha wangu nuyungabirlbirlnu i nganarraruynu-yu, nhini kardu-ka mere da matha the numangibath da minthire kama ngurdinarrawurl-deyida-nu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bere nhini thangunu Jesus-ka murrinh numi warda wurdampirrayith. I mampirra, “Nga kardu. Da nakurlnu ngarra Yile neki-re ku Pule ngala thathpirr pinarranu kardu wurnangat warda ngatha, nhini-ka mangini murrinh ngurdinarrayithnu kanhi mani manarranu-yu. “Bere, kardu pule ngala da manta warda punurdurrnu da mayern ngathparr-nu pununu pi, nukunu-ka dimpirrukayneme kardu nugarn ngarra wurlk pumenadhaneme parde, i mampirruneme, ‘Nga. Da thelput ngay kanhi i nanhthi purrkpurrk wanku nirangape-warra-nemenu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I dampirrumut-warda-neme ku mani ngala, nhini peneme-ka nanhthi peyim puyemanemenu i nanhthi warda thelim puyemanemenu i ku mani ngala thathpirr deyida pubanangkardurdunemenu puru. “Bere kardu nugarn numi ngarra wurlk menadha wurrini-ka kardu mukmuk patha nimin kanthidha dini ku mani nukun-yu, i nhini kardu pule nhini-ka ku mani ngala damnamut ku $5,000. I kardu numi deyida ngarra wurlk menadha wurrini-ka kardu mukmuk patha tharrngini ku mani nukun-yu, i nhini kardu pule nhini-ka ku mani ngala tharrngini damnamut-yu ku $2,000. I kardu nugarn numi ngarra wurlk menadha wurrini-ka kardu mukmuk patha kunungingki da matha kanthidha wurrini ku mani nukun-yu, i nhini kardu pule-ka ku mani kunungingki da matha damnamut-yu ku-ka $1,000. I bere nhini thangunu kardu pule ngala nhini-ka nungardurr warda i pangu warda wangu nadha dini da ngathparr-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Bere kardu nugarn nhini ngarra ku mani ngala nhini ku $5,000 mebaththa wurrini-ka pirtpirt da matha nanhthi peyim medha wurrini i thelim deyida medha wurrini i ku mani benamangkardurdudha kardi ngarra ku mani nhini ku pule kathu damnamut. I ku mani nukunu-ka ku $10,000 warda-wa mebaththa wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","I kardu nugarn numi nhini ngarra ku mani $2,000 mebaththa wurrini-ka mange nhini deyida mani menadha wurrini. I ku mani nukunu-ka ku $4,000 warda mebaththa wurrini nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mu kardu nugarn pana ngarra ku pule ngala kathu ku mani $1,000 damnamut-ka, bangammirr warda ku mani nhini-yu ngarra da putek pepe wurdanngath. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bere kardu pule ngala nhini-ka da pirdithme nimin da pangu kardidha-ya. I nhini thangunu-ka wurdawurl i dimpirrukayneme kardu ngarra nukunu, i mampirruneme, ‘Nganaka peneme? Ku mani-ka ngala thathpirr warda nubangamngangkardurduneme ngarra ku mani nhini ngay ngamnarrumutneme-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bere kardu nugarn nhini ngarra ku $5,000 da marra-re menabaththa wurrini-ka murrinh mamna, ‘Pule, nhinhi-ka ku $5,000 thamngamut, i ngay-ka wurlk ngala mempadha ngardi. I nga, ku $5,000 numi deyida manganpart kanhi nhinhi-nu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","I ku pule nhini kathu-ka mamna, ‘Kardu pathanhi nhinhi-yu. Nhinhi-ka wurlk patha da matha nengadha thurrini i murrinh namngabath. I nhinhi-ka thirrangapedha thathpirr thardi nanhthi ngarra purrkpurrk ngay-yu i nhini ngay-ka nanhthi terert warda ngatha ngampamutnu i thirrangapenu thani. Tharra-ya, ngarra ngay warda thaninu i le patha thathpirr thaninu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Bere, kardu numi warda kathu wurrininadha pangu, kardu nhini-ya ngarra ku pule kathu ku $2,000 damnamut-yu. I nukunu nhini kathu-ka mamna, ‘Pule, nhinhi-ka ku $2,000 thamngamut, i ngay-ka wurlk ngala deyida mempadha ngardi. I nga, ku $2,000 numi deyida bangampangkawu i bempangkardurdudha ngardi kanhi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I ku pule nhini kathu-ka mamna, ‘Kardu pathanhi. Nhinhi-ka wurlk patha da matha nengadha thurrini i murrinh namngabath. I nhinhi-ka thirrangapedha thathpirr thardi nanhthi ngarra purrkpurrk ngay-yu, i nhini ngay-ka nanhthi terert warda ngampamutnu i thirrangapenu thani. Tharra-ya, ngarra ngay thaninu i le patha thathpirr thaninu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Bere nhini thangunu kardu numi wurrininadha kathu, kardu nhini-ya ngarra ku pule ngala damnamut ku $1,000. I nukunu nhini kathu-ka mamna ngarra ku pule ngala wangu, ‘Ya. Ngay-ka the nganthin-nhi nhinhi-yu kardu tetemanthay-wa. Nhinhi-ka thanthakthuk thurran mi dhepdhep karnabuy da ngarra kardu ngamere kathu mi kamarl pubebirrbirrdha purni. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","I nhini ngay-ka ngemnhimanham-wa i ku mani nhini ngarra thamngamut-ka ngurdanngath warda. Ku-ka bangammirr ngarra putek pepe. Mu nga, ku-ka kanhi-wa ngurdumpangkarl-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bere, ku pule nhini kathu-ka mamna, ‘Nhinhi-ka kardu wiye-wa. Nhinhi-ka mere wurlk-wa ningadha. Mu nhinhi-ka namnga mana-wa the nengibaththa thurrini mi dhepdhep mana-wa nganthakthuk ngurran da ngarra kardu ngamere kathu mi kamarl pubebirrbirrdha purni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mu nhinhi ku mani kanhi-ka ngarra bank-wa duyngardidha-yu. Nhini-ka ku mani kunungingki deyida dengangkardurdudha i thengamuttha wunku ku mani kanhi ngarra thamngamut-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Bere, ku pule nhini kathu-ka mampirruneme ngarra kardu nukunu ngamere-ya, ‘Ya. Ku $1,000 pangu numamartneme i nanamutnemenu kardu nugarn pana ngarra ku $10,000 kanthin pirrim-ya.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","I mam deyida ku pule nhini kathu-yu, ‘Nga. Kardu nangkal ngatha mabath ki nanhthi ngamere, nhini nukunu-ka bere ngatha wangu nanhthi terert kanikutkkut nhini-yu. Mu kardu nangkal ngatha mabath ki nanhthi kunungingki da matha-ka nhini kardu-ka ku mamart da matha nanhthi nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Bere ku pule ngala nhini kathu murrinh deyida mampirruneme ngarra kardu nukunu, ‘Ya. Kardu kanhi karrim ngarra mere wurlk mengadha kani-ka, kardu nunnuku-warda-neme outside da ngarra thipmam binhi wangu. I pangu da du ngala da matha panikarrknu wunku nanhthi yidingurr ngala da matha paninu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“I nga. Kanhi-ka murrinh numi deyida ngurdinarrayithnu-yu,” Jesus kathu-yu mampirra. “Ngay, kardu ngarra da kangkarl kathu ngurdamnarrathut-ka, da nakurl-te-nu ngurdiwurl-deyida-nu kathu i pangilarrangnu ngala da matha wunku ku angel ngarra ngay nganemenu kathu. I da nhini-nu-re ngay-ka ku pule ngala thathpirr nginu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I kardu wurnangat warda ngatha ngarra da putek ngala kanhi narnam-ka nubengkardurdunu i nirangimardatnu kumparra warra ngarra ngay. I ngay-ka mananyerryerrnu warda kardu wurnangat nhini warda ngatha ngarra group perrkenku nuyunu-ya, mangini kardu nugarn mani mampunyerryerr wurran ku thip i ku nenigut mani-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I ngay-ka kardu pathanpun ngunperrnu ngarra batbat ngay-re, i kardu wiyenpun ngunperrnu ngarra thakunh-te. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“I bere nhini thangunu ngay kardu ngarra pule ngala thathpirr-ka murrinh kanhi marranu kardu ngarra batbat-te pirangkadhuknu-yu, ‘Kagu. Yile ngay-ka mamnanthibirnu, i nukunu-ka le thathpirr dimnarra. Nanki-ka da ngarra ngay warda wangu nurunu, da-ka nanki warda-wa nhini-yu. Da nhini-ka ngay mamnarrawatha ngarra da putek ngala kanhi-re mampatha.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“I nga. Ngarra ngay-re medeyi ngardidha, nanki-ka mi narramngamut. I ngarra ngay-re demngiralal, nhini nanki-ka kura patha narramngamut. I ngay-ka kardu ngamengka thangunu kathu, mu nanki numamnga-ka, ‘Thanirdi kanhi ngarra thelput nganki.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I ngarra ngay-re nanhthi kaligu mananhthi mebaththa ngardi, nhini nanki-ka nanhthi kaligu narramngamut. I ngarra ngay-re matharr ngardidha-ka, nhini nanki-ka nirangipedha nardi. I ngarra jail-te parramngadhap, nhini nanki-ka narramngaruy. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“I nhini thangunu kardu pathanpun nhini-ka murrinh kanhi warda pumanganu pira, ‘Pule, minthire ngubamnhingkardu medeyi thardidha-yu i mi ngarrampamut-yu? I minthire ngubamnhingkardu demnhiralal i kura patha ngarrampamut-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","I minthire ngubamnhingkardu kardu ngamengka thangunu kathu i ngumenhibertidha ngurni ngarra thelput nganki-yu? I ngana deyida minthire ngubamnhingkardu nanhthi kaligu mananhthi nebaththa thurrini i nanhthi kaligu ngarrampamut-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","I minthire ngubamnhingkardu kardu matharrnhingini thardidha-yu? I minthire ngubamnhingkardu ngarra jail thanardi i thininganamardadha-yu i ngarramparuy-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“I bere, ngay-ka murrinh kanhi warda marranu ngarra kardu nhini-yu, ‘Nga. Murrinh thathpirr kanhi manarranu-yu. Da mange patha patha nhini ngarra kardu ngathayida kardu ngarra ngay-ya numerradha nurni, nhini nanki-ka nginipunh ngay deyida mani da mange patha nhini numengadha nurni-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bere murrinh nhini thangunu ngay-ka murrinh kanhi warda marranu kardu ngarra thakunh-te pirangkadhuknu-yu. ‘Ya kardu. Nanki-ka narningipartnu warda. Yile ngay-ka mere da matha le kinarra ngarra nanki-yu. Mu mampa puy, nuru-wa ngarra da thungku ngala pangu da bere matha wangu dimum. Yile ngay kathu da thungku ngala pangu mampirruwathawathaneme-ka ku karrath-nu i ku ngepan wiye wiye ngarra nukunu da matha nukun, i pangu da matha penkuwekpeknemenu pani.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","“I nga. Ngarra ngay-re medeyi ngardidha-ka nanki-ka mere nerrangamuttha mi dhepdhep-yu. I ngarra ngay-re demngiralal, nanki-ka mere nerrangamuttha kura patha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I ngay-ka kardu ngamengka thangunu kathu, mu nanki-ka mere numengadha, ‘Kagu, thanirdinu kathu.’ I ngarra ngay-re nanhthi kaligu mananhthi mebaththa ngardi, nanki-ka mere nerrangamuttha nanhthi kaligu-yu. I ngarra ngay-re matharr ngardidha i ngarra da jail ngininganamardadha, nanki-ka mere nerrangaruydha. ");
INSERT INTO mwf2018_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“I bere kardu nhini kathu-ka murrinh pumanganu pira, ‘Pule, minthire ngubamnhingkardu medeyi thardidha i demnhiralal? I minthire ngubamnhingkardu kardu ngamengka thangunu kathu wunku kaligu mananhthi-yu? I minthire ngubamnhingkardu matharr thardidha-yu i ngarra jail thininganamardadha-yu i mere ngumenhimanpidha-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","I ngay-ka murrinh kanhi warda marranu, ‘Nga. Murrinh thathpirr kanhi manarranu-yu. Ngarra nanki-re mere numenmanpidha kardu ngarra ngay kardu ngathayida pana, nhini nanki-ka mere deyida numengimanpidha ngay-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“I nhini thangunu kardu wiyenpun nhini-ka da ngarra yidingurr ngala nukun purunu i bere matha wangu panlututnu pani. Mu kardu pathanpun-ka kardu bere matha wangu parninu da ngarra Yile neki nukunu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bere ngarra Jesus-te murrinh terert nhini warda dampirrarikerdek murrinh ngarra wurdanpunthethith thangunu-yu ngarra kardu, nhini-ka murrinh warda mampirruneme ngarra pulangay nukunu, ");
INSERT INTO mwf2018_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nga peneme. Da-ka perrkenku warda wangu pirri mange ngarra punniret warda-yu da Passover-nu-yu. I da nhini-nu-re-ka ngay kardu ngarra darrikardu nanki thathpirr kardu pumangibertinu puru. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bere ku yilarn ngala ngala i kardu ngalantharr ngalantharr puyemperr warda da ngarra thelput nukunu Caiaphas, ku yilarn ngala thathpirr-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","I peneme nhini-ka murrinh dederrk-te puddanayiththa punni ngarra-re nukunu Jesus pumartanu-yu i thu pubatnu i puddurinuminu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","I kanhi-wa murrinh-yu kardu nugarn nhini pumenanudha punni-yu, “Ya nga. Ngarra kardu-re parikerdeknu da Passover kanhi-ka nhini-ka Jesus warda pumartanemenu. Mu marra kanhi ngatha pumarta-nukun-neme kardu-ka kanhirithi-nukun-neme i thu kunhituk-nukun-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bere Jesus-ka da nan dinidha-yu da Bethany ngarra thelput Simon nukunu. I nukunu Simon nhini-ka matharr leprosy kanthidha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bere ngarra nukunu-re Jesus mi dhepdhep dinimurrktha-ka kardu palngun kathu wurrininadha wunku nanhthi oil kangunu patha nimin-ya ngarra nanhthi pul-te. I bere dampewewu ngarra pelpith nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mu kardu pulangay nukunu Jesus-ka mampunkumardarakineme ngarra palngun nhini-yu i murrinh pumenanungkudhaneme pirrine, “Ya. Thangku-dha nanhthi oil pangu-yu dampewewu-yu? Nanhthi-ka wurdanpi-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nigunu nanhthi-ka denhemuttha-wa-neme i nekineme-ka nanhthi warda thelim thumedhaneme nhini-yu ku mani ngala-nu-ya, i ku mani nhini-ka therrumutmuttha-warda-ngime kardu ngarra mananhthi-wunka-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bere Jesus-ka the-wa mebaththa dini ngarra murrinh peneme puddanayiththaneme pirrine mange peneme ngatha-yu. I bere mampirruneme, “Thangku-dha murrinh pana ngarra palngun kanhi numamkardarrithakneme nirrimka-yu? Mange ngarra nigunu mamnga-ka mange lelunh-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kardu pana ngarra nanhthi mananhthi-wunka-ka kardu bere matha wangu perduynu parni kanhi. Mu ngay-ka mere ngani ngatha nukun ngarra nankuneme kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nigunu-ka damngiwewu wardarra ngarra nginipunh ngay-yu nanhthi oil patha kanhi-yu i mamngawathawatha wardarra ngarra nginipunh ngay-nu-yu pubangibirrnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","I murrinh deyida thathpirr kanhi-yu,” Jesus kathu mampirruneme. “Kardu pana ngangka-re puddirrayithnu puru murrinh ngarra ngay-yu. I murrinh numi deyida puddirrayithnu puru murrinh ngarra kardu palngun kanhi thangunu damngiwewu-yu. Da pana ngangka-re kardu wurnangat nimin-ya pubiyepupnu puru kardu palngun kanhi i mange patha kanhi-yu ngarra mamnga-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bere nhini thangunu-ka nukunu Judas Iscariot kardu pulangay nukunu Jesus kardu 12-ya kanampunkupart-warda-neme i wurrinirradha ngarra ku yilarn ngala ngala. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","I mampirruneme, “Ya, ku thangku numa nangamutnuneme ngarra Jesus ngatha manankumanpinuneme i pumartanemenu-yu?” Bere peneme-ka pumpankariwu-warda-neme ku mani ku silver 30-ya i parramkamutneme ngarra Judas Iscariot-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bere nhini thangunu-ka nukunu Judas Iscariot-ka dirrangkadha wurrini da ngarra kardu makardu-nu thathpirr ngarra Jesus-yu i nhini-ka pirrarrakaynu warda ku yilarn ngala ngala nhini-yu kardu warda pumartanu Jesus-yu i pumabertinu puru pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bere da ngarra kumparra marra-re da ngarra ngala nhini da Passover-ya da-ka pangarntuy warda nhini-yu. Bere pulangay nukunu Jesus purnenadhaneme i pumamnaneme, “Ya pule. Ngarra wangu mi ngumampawathawathanemenu-yu mi lawam werlpen i ku ngen mi nekineme-nu pullathnuneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Nga. Nunnanemenu da pangu-ya i kardu nugarn banankumardabineme. I murrinh-ka kanhi-wa numananemenu, ‘Kardu Pule ngankuneme da-ka manta warda kardu pubangingkardunu nukunu ngala thathpirr-yu. I nukunu i ngankuneme deyida wanku mi lawam werlpen mani i ku ngen ngullathnemenu mi passover-ya da ngarra thelput nhinhi.’” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bere peneme-ka pangu warda wangu purnedhaneme i murrinh pumamnabathneme murrinh ngarra Jesus mampirruneme-yu. I pangu da mi warda pumamkawathawathaneme mi lawam werlpen i ku ngen-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bere da thipinhi nhini-ka Jesus i pulangay nukunu kardu 12-ya parramkaruy-warda-neme ngarra thelput nhini-yu i parnamkawup-warda-neme ngarra mi-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bere nhini thangunu-ka ngarra peneme-re mi pirrinemurrkthaneme-ka Jesus-ka murrinh warda mampirruneme, “Nga peneme. Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu. Kardu nugarn numi kanhi da kem kardu paningipartnu-yu i manmanpinu kardu wiyenpun pangu pumangirtanu i pumangibertinu puru pangu warda wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","I ngarra peneme-re murrinh ngarra Jesus pubimnayepupneme-ka kardu dampunkumardathin-warda-neme ngala da matha. I ngarra Jesus parranedharrpudhaneme pirrine numi numi murrinh nginipunh kanhi mani-ya, “Pule, ngay-ka wurda, nawa?” Pumenadhaneme pirrine. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mu Jesus kathu-ka mampirruneme, “Kardu-ka kardu nhini-wa ngarra mi lawam ngurduninthakulknu ngarra nanhthi dish kanhi marda ngala. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bere ngay kardu darrikardu nanki thathpirr-ka ngupupnu warda murrinh nginipunh ngarra Yile ngay da matha mam da murntak warra-ya. Mu kardu nugarn nhini-ka kardu ngarra ngay parramutnu kardu ngarra wiyenpun-ka, da-ka da wiye-wa-nu ngarra nukunu-nu-yu. I nhini-ka nukunu-ka patha-dha-wa nhini-yu mere banabattha-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bere nukunu Judas Iscariot murrinh warda mamna ngarra Jesus, “Pule, ngay-ka wurda, nawa?” Mu Jesus kathu-ka mamna, “Yu, nhinhi da kardu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bere ngarra mi-re pirrinemurrktha-da-ngatha-neme-ka nukunu Jesus-ka mi lawam werlpen manganart dim i Yile nukunu darntiparl mi-nu-yu i munirrarerrarrdha dini. I mampirruneme, “Nga peneme. Mi kanhi nullathnemenu.” I mi warda dampirrumutmutneme. I mampirru-deyida-neme, “Mi kanhi-ka nginipunh ngay-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","I ngana deyida nanhthi kap manganart kura wine wanku i Yile nukunu deyida darntiparl kura wine-nu-yu i dampirrumutneme. I mampirruneme, “Nga peneme, nubagurdukneme kura kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kura wine kanhi-ka kumulung ngay-wa. Kumulung ngay-ka pinthawunu i ngay-ka ngupupnu i nhini-ka da wiye ngarra kardu pumammath pumpan-ka ngirranmaputhnu warda nhini-yu kardu ngarra murrinh ngay pumangabathnu puru-yu. Yile ngay da murntak warra mam da mange wiye pirranmaputhnu ngarra kardu thangunu, i nhini-ka murrinh-ka murrinh da thathpirr ngarra kumulung ngay-re pinthawunu-yu,” mampirruneme Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","I murrinh thathpirr kanhi manarrunemenu. “Ngay-ka mere deyida bagurduknu kura mi kakpa nginipunh kanhi mani-yu. Mu da ngala kurran kathu-ka ngarra Yile ngay da matha Pule ngala thathpirr pinu-ka nhini-ka ngay-ka kura deyida bagurduknu kura mi kakpa marra-yu,” nukunu kathu-yu Jesus mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bere nhini thangunu peneme-ka pardinareldhaneme nanhthi thamarl tiparlti ngarra Yile neki-nu wangu. I pungamkawuyneme warda ngarra thelput thangunu kathu i pangu warda wangu punnedhaneme da palyirr nhini da, nan Olive. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","I bere Jesus kathu-ka mampirru-warda-neme, “Nga. Da thipinhi marra kanhi-ka nankuneme-ka kardu narnengipartnemenu i kardu numenganthardarrarrnemenu murrinh nginipunh nhini mani-wa ngarra Yile ngay mam da murntak warra-yu. I murrinh-ka kanhi-wa mam-yu, ‘Ngay-ka ngubat-wa-nu kardu nugarn Pule ngala pana ngarra ku thip dirranganpunpe kanam-yu. I nhini thangunu ku thip-ka pumerdarrarrnu-warda-nintha nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","I nhini thangunu Yile ngay-ka purdungingkabirl-deyida-nu. I ngay-ka kumparra wardarra ngununu ngi da nan-nu wangu Kelili.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mu nukunu Peter kathu-ka ngarra Jesus mamna, “Kardu peneme ngatha parnenhipartnemenu i pumerdarrarrnemenu, nhini-ka ngay da matha wurda-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mu Jesus kathu-ka mamna ngarra Peter-yu, “Murrinh kanhi mampanu-ka murrinh thathpirr-wa. Thipinhi marra kanhi-ka ngarra ku rooster mere da ngatha pirrakaynu, nhinhi-ka kardu narranu murrinh kanhi perrkenkuneme-yu, ‘Ngay-ka kardu mere the-wa mabath kardu nugarn pangu-yu.’ I nhini thangunu ku rooster-ka pirrakaynu warda diyepupnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mu Peter kathu-ka mamna ngarra Jesus, “Awu wurda, ngay-ka mere da matha ngama nukun ngay mere the manhibath nhinhi-yu. Kardu ngatha yida thu kungibatnu mange nginipunh nhinhi deyida mani thu punhibatnu pana, ngay-ka mere da matha ngama nukun ngay mere the manhibath nhinhi-yu.” I peneme ngamere pana-ka murrinh nginipunh nhini deyida mani pumamnaneme ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bere nhini thangunu Jesus i pulangay nukunu-ka purnedhaneme ngarra da nan Gethsemane ngarra thay terert-ya. Bere Jesus kathu-ka mampirruneme, “Nga, kanhi da nenuneme, mu ngay-ka ngurran dhi wangu-wa murrinh-nu ngarra Yile ngay nganinangerrennu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bere Jesus-ka mampirrukayneme Peter, i James i John piguna-ya. Yile piguna-ka Zebedee-wa. I bere purnedha-warda-neme manta pangu da wangu. Bere Jesus-ka kardu danimardathintha warda dini ngala da matha i nginipunh nukunu-ka dinirartaldhanintha. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I mampirruneme ngarra Peter, James i John, “Ngay-ka damngimardathin warda dim ngala da matha. I ngay-ka ngingamnuthap ngem-ka kardu ngupupnu warda. Nankuneme-ka karda nenemenu ngarra ngay i bere ngatha wangu nebirlbirlnemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bere Jesus-ka wurrinidha pangu wangu manta ngangka da ngatha i murrinh kardinangerrentha ngarra Yile nukunu. I dempinhimardardum ngarra putek i murrinh mamna, “Yile, kardu-ka pangilututnu i thu pungibatnu. Nganaka kama-ya marda nanganart dunthap warda kardu nhini-yu i mere kangilutut nukun i mere kungibat nukun. Nhini-wa ngay marda manganart ngem-yu. Mu nhinhi mange ngatha marda nart kardu thangunu pangilututnu i thu pungibatnu, nhini-ka ngay-re marda manganart-yu. Mange ngarra nhinhi marda nanganart-ka ngay-ka marda deyida manganart mange nhini-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bere nhini thangunu Jesus-ka wurdawurl pangu ngarra pulangay nukunu kardu perrkenkuneme nhini-nu-ya i bampunkurdurtneme kardu ngurrnguwarl pirrinengurrkurrkthaneme. I murrinh mamna ngarra Peter, “Peter. Thangku-nu ngurrnguwarl pana nirrimkangurrkurrkneme-yu? Thangku-dha mere narnebirlbirl kunungingki ngadha-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kardu thathpirr narnebirlbirlneme-ya i ngarra Yile ngay warda nadharrpununeme manankumanpineme mere da mange wiye nukun niyemaneme ngarra nukunu-re ku karrath manankurullulnemenu. I ngepan ngarra nankuneme marda numangankartneme numpanka mange yuthpan da matha-nu, mu nanhthi nginipunh ngarra nankuneme-ka mere lurruth ngala numabathneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bere Jesus-ka wurdawurl i murrinh deyida kardinangerrentha ngarra Yile nukunu i murrinh mamna, “Yile, mange ngatha marda nart kardu thangunu pangilututnu i thu pungibatnu, nhini-ka ngay-re marda manganart-yu. Mange ngarra nhinhi marda nanganart-ka ngay-ka marda deyida manganart mange nhini-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I nhini thangunu-ka wurdawurl deyida ngarra pulangay nukunu perrkenkuneme i bampunkurdurt-deyida-neme kardu ngurrnguwarl pirrinengurrkurrkthaneme, nhini-ka kardu pardewalawalakadha-da-ngatha-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bere Jesus-ka kanampunkupartneme i wurdawurl deyida i murrinh-nu kardinangerrentha ngarra Yile nukunu murrinh nginipunh marra-re deyida mani kardinangerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","I murrinh nhini thangunu-ka wurdampirruwurl-deyida-kathu-neme ngarra peneme i mampirruneme, “Ya. Nankuneme-ka karda ngatha narnamkangurrkurrkneme i bangamnankuyukneme dim? Nga. Ngay kardu darrikardu nanki thathpirr-ka kardu pumangirtanu warda i ngay pubangimardanu kardu ngarra nugarn wiyenpun warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ka. Newirnturtneme, purru-warda-neme. Nhini da kunungam kardu nugarn numi-yu kardu ngarra kanamngipart ngay-yu i kardu ngarra mampunmanpi kardu nugarn wiyenpun kardu ngay-nu pumangirtanu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bere ngarra Jesus-te pirringerren-da-dha-ngatha-ka kardu nugarn numi nhini Judas Iscariot-ya pangarntuy warda. I kardu nugarn terert deyida wanku parrarntuy wanku thu sword i thu thay pumebaththa purni. Nukunu-ka nhini da wanku Judas Iscariot kardu pulangay nukunu Jesus ngadha daniriwaktha kardi-yu kardu 12-ya mam numi-yu da ngarra marra-re-ya. Ku yilarn ngala ngala i kardu ngalantharr ngalantharr puddanpunthuk kardu murlakpun nhini-yu Jesus-nu pumartanu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mu nukunu nhini Judas Iscariot-ka murrinh mampirra wardarra ngarra kardu murlakpun mange ngarra-re manmanpinu Jesus pumartanu-yu. I kanhi-wa murrinh mampirra wardarra, “Kardu pana ngarra ngadhamurrudhungnu-ka nhini-wa kardu-yu numartanu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bere Judas Iscariot-ka wurrininadha ngarra Jesus i murrinh mamna, “Pule, marda nhinhi-ka pekpek warda nabathnu thurru.” I nhini-ka danthamurrudhung warda ngarra thamurru nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bere Jesus kathu-ka mamna, “Nga, wunkarrare mange kanhi thamanu.” I bere kardu murlakpun nhini-ka purnenadhaneme i pumangarnta warda Jesus-yu, tetemam da matha pumamyit pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I kardu nugarn numi ngarra pulangay nukunu Jesus-ka thu sword manganart i panthertal the numi ngarra kardu pana ngarra wurlk nukunu menadha wurrini ngarra ku yilarn ngala thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","I Jesus kathu-ka mamna ngarra pulangay nukunu nhini, “Thu pana thanthin thirrim-ka dupak. Thu pana-ka kardu pana nganaka ngarra thu panthuk wurran nhini da kardu-yu punnungamnubirr parnam-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nhinhi-ka mere the nabath ngay-yu ngirranakay ngarra Yile ngay-yu. I nukunu-ka purdunthuknu-ka ku angel terert nimin-ya ngarra ngay pumangimanpinu puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mu wurda, ngay-ka mere ngarra ngirranakay nukun. Murrinh ngarra Yile ngay yibim-ka kanhi-wa, ‘Kardu wiyenpun-ka bere ngatha pumangirta i thu pungibatnu.’ Nhini-ka murrinh nukunu Yile ngay thangunu yingampup yibim da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mu Jesus kathu-ka murrinh mampirra ngarra kardu murlakpun nhini-yu, “Nanki-ka nunningadha ngay-nu numangirtanu nginipunh kardu pana deyida mani kardu darrarartka numartanu wunku thu sword pangkuy pangkuy i thu thay. Mu ngay-ka da terert da matha ngardipuptha ngarra da church ngala i ngurdinthethiththa ngardi pangu-yu. Mu nanki-ka mere numengirtadha ngadha da nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mu Yile ngay murrinh ngarra nukunu-ka murrinh da thathpirr nhini-yu. Da murntak warra mam-ka kanhi-wa kardu nugarn murlakpun pumangirtanu ngay-yu nginipunh nanki mani numanganngirta warda marra kanhi-yu,” Jesus kathu-yu mampirra. Bere nhini thangunu pulangay nukunu Jesus-ka parnamkapartneme i tharra warda punnungamkawinhatneme. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bere da thipinhire nhini da pankapurl-ka ku yilarn ngala ngala i kardu ngalantharr pule ngala ngala-ka kardu pubemkangkardurduneme i murrinh warda pumenanungkudhaneme parde mange peneme da matha murrinh ngarra-re Jesus thu pubatnemenu i puddurinuminemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","I bere pumambedharrkirrk warda Jesus-yu ngarra nithi nukunu i pangu warda wangu pumebertidha purni ngarra nukunu da Pilate i parramnamut warda. Nukunu Pilate-ka ku pule ngala dinirradha ngarra kardu. Nukunu-ka da ngarra Rome thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bere nukunu Judas Iscariot nhini-ya ngarra Jesus kanampart-ka kardu warda panthepup Jesus thu pubatnu i puddurinuminu. I nhini nukunu-ka danimardathintha warda kardi da mange nhini thangunu mamna-yu. I nhini ku mani ku silver 30-ya wurdanpirrungkalath-warda-neme ngarra ku yilarn ngala ngala i kardu ngalantharr ngalantharr. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I murrinh warda mampirruneme, “Ya. Ngay-ka da mange wiye ngala thathpirr ngamam. Ngay ngamnarramut-ka kardu patha-wa i mere da wiye merithuktha kani, wurda da matha. Mu nankuneme-ka thu nubatnemenu warda. Mu pirda ngadha-ya, mere kupup nukun nukunu nhini-yu.” Mu peneme nhini kathu-ka pumamnaneme, “Awu wurda-wa ngankuneme-yu. Pana-ka da mange ngarra nhinhi da matha nam pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bere nhini thangunu Judas Iscariot-ka pirrimputh warda ku mani nhini-yu ngarra putek da ngarra church ngala pangu-yu. I pangu warda wangu nadha dini, i memnudhamadharrk mange nukunu ngarra nanhthi thay i ngarra yibimpup da mana. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bere ku yilarn ngala ngala-ka ku pardekuttha-warda-neme parde ku mani nhini-yu ngarra Judas Iscariot pirrimputh, i murrinh warda pumemnungkuneme, “Nga. Kardu nugarn nawa pupupnu ngarra ku mani kanhi thangunu, nhini ku kanhi-ka mere ngarra pubupak-nukun-neme ku mani pangu warra-yu ngarra da church ngala kanhi-yu, wurda da matha, nhini-wa murrinh law nekineme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mu da putek kama pumartnemenu ngarra ku mani kanhi-yu-ya, na?” Nhini-wa murrinh pumemnungkuneme mange peneme ngatha-yu. I bere nhini thangunu-ka da putek warda pumangankartneme ngarra kardu nugarn numi thangunu kathu ngarra nanhthi pot nanhthi parldart thangunu mewathadha kardi da nhini-yu. I bere peneme nhini-ka da mintilbith warda pubankapakneme da putek nhini-yu i kardu ngamengka ku pubebirrbirrdha pardi pangu-yu, kardu ngarra da Jerusalem-te pardiwuwuptha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I da ngarra marra kanhi da mana kardu pamam pumpan da putek nhini-ka, “Da putek ngarra kumulung pirrim.” Nhini-ka ku mani nhini da ngatha nganaka ngarra Jesus thangunu thu pumpanmat. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","I murrinh murntak nhini ngarra ku prophet murntak nan Jeremiah darntilil-ka murrinh da thathpirr nhini-yu. Murrinh nhini-ka kanhi-wa mam-yu, “Kardu-ka ku mani pumangankut, ku silver 30-ya. Kardu nhini ngarra da Israel thangunu-ka ku mani nhini pumangankut i ku mani nhini-ka ku nukunu-nu warda Jesus pumanganbert. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","I ku mani nhini da ngatha parramnamut ngarra kardu nugarn nhini-yu ngarra nanhthi pot mampatha wurran nanhthi parldart thangunu i da putek nukunu peyim warda pumamna ngarra ku mani nhini-re-yu.” Nhini-wa murrinh-yu ngarra Yile neki kathu mamna ngarra nukunu Jeremiah da murntak warra, i murrinh nhini-ka murrinh da thathpirr nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bere da thipinhire nhini da pankapurl da Saturday, ku yilarn ngala ngala i kardu nan-ya kardu Pharisees purnenadhaneme ngarra nukunu-nu Pilate. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","I pumamnaneme, “Ya pule. Kardu nugarn pangu kabim nganaka ngarra daniyirrararttha kardi, ngankuneme-ka nguddamkayerr-warda-neme murrinh mam ngarra kardu birnu-re kardidha-ya. Nukunu mam-ka, ‘Da perrkenkuneme paruynu-ka ngay-ka ngurdingkabirl-deyida-nu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mu kanhi ngarrimnhidharrpuneme-ka ku soldier thurdunkuthuknemenu i kardu pirangkanemenu pira da weyi palyirr nhini ngarra ku nginipunh nukunu pubannurdi-ya. Nhini-ka kardu pulangay nukunu kuru nukun pangu-yu i kumart nukun ku nginipunh nukunu-yu, i nhini-ka murrinh nukun karrayirrart kuru kardu wurdamkabirl deyida. I murrinh nhini ngatha karrayirrart nukun kuru nhini-ka murrinh wiye ngala thathpirr warda ngarra murrinh nhini dannheyirrartneme i mannheneme-ya, ‘Yile neki wurdanngithuk ngay-yu.’” Nhini-wa peneme kathu-yu pumamnaneme ngarra nukunu Pilate-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bere nukunu Pilate kathu-ka mampirruneme, “Mampa-ya, ku soldier nirrarrukayneme i ngarra da weyi palyirr-nu pirangkanemenu pira.” ");
INSERT INTO mwf2018_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bere kardu peneme nhini-ka pangu warda wangu purnedhaneme da ngarra weyi palyirr nhini-nu. I nanhthi warda magim pubankapakneme nanhthi kikmun-te ngarra nanhthi palyirr wululuthpe ngala nhini-yu, i nhini-ka the warda pumabathnemenu kardu kama kumadharl-ya nanhthi palyirr nhini-yu. I ku soldier-ka bere ngatha pirangkadhaneme pe pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bere da Saturday nhini ngarra kardu Jews-te benyuktha dini-ka da dirntal warda nhini-yu. I bere da thipinhire nhini da pankapurl da Sunday-ya, nigunu nhini Mary Magdalene i Mary kardu numi deyida pangu warda wangu nanginthadha dini ngarra da weyi palyirr nhini-nu banginthangkardunu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bere da putek-ka dinirangkaltangkaldha warda nhini-yu. I ku angel ngarra Yile neki thangunu kathu wurdanthut da ngarra weyi palyirr nhini-nu-yu. I wurdarlerl nanhthi palyirr wululuthpe ngala nhini-yu i mantharl warda. I kanawup kangkarl warda ngarra palyirr nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","I ku angel nhini-ka mangini thu malarntath mani dinimamaththa, i nanhthi kaligu ngarra nukunu-ka bamam thathpirr mangini nanhthi kalakkalak mani. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","I ku soldier nhini ngarra pirangkadhaneme parde da weyi palyirr nhini-ka kardu puninkungkawerrdhaneme kardi ngala da matha i nanhthi werrerrerr pumerdarrithakthaneme parde. I peneme-ka pubanawaththaneme parde i puninkurtedhaneme dini mangini ku pibimkapup-mani-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bere ku angel nhini-ka murrinh warda mampirrungintha ngarra kardu palngun nhini-yu, “Ya peningintha. Mere thenginthanham. Ngay-ka the-wa nganthin Jesus-nu nangannawinhadhathngintha numpan-yu, nukunu nhini-ya ngarra thay pubangarnerde. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu ku nginipunh nukunu-ka maku warda kanhi-yu. Nukunu-ka wurdamkabirl warda-wa murrinh mangini da marra-re warra menarradha wurrini. Mu nga, thurrungintha kathu i danginthangkardunu da ngarra nhini-yu ku ngarra nginipunh nukunu thangunu yungurrkurrktha-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","I ngana deyida ku angel kathu-ka mampirrungintha, “Nga. Pata wangu pirtpirt da matha thununginthanu thi ngarra pulangay nukunu, i murrinh-ka kanhi-wa numarrunemenu-yu, ‘Nukunu Jesus-ka wurdamkabirl warda-wa. I pangu wardarra kumparra kunungam kem da nan-nu Kelili bammanthiwat, i pangu da banankardunu-yu.’ Nhini-wa murrinh-yu numarrunemenu-yu ngarra pulangay nukunu-yu,” ku angel kathu-yu mampirrungintha. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bere nhini thangunu-ka nungamnginthardurr pirtpirt da matha i nanginthawinhararttha dini pangu warda wangu murrinh thelerrdhe-nu parnirrutharrmunemenu peningintha wangu-yu. I kardu-ka denanginthanhamtha wangu tharra i le patha wangu nanginthadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bere, kardu pulangay nukunu Jesus, kardu peneme 11 nhini-ya, pangu warda wangu purnedhaneme da nan-nu Kelili i pirrimkamardawith-warda-neme da palyirr nhini ngarra Jesus murrinh mampirruneme-yu punnanemenu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bere Jesus-ka pangampirruruy-warda-neme ngarra peneme nhini-yu ngarra da palyirr pardedhaneme. I ngarra peneme-re Jesus pubamkangkarduneme-ka kardu-ka perremnawinhipingkarlneme ngarra nukunu-nu. Mu peneme nhini kardu ngamere-ka pamamka-mana-wa-neme kardu numi deyida pangampirruruyneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Bere Jesus-ka manta wurrinirrudhaneme i murrinh mampirruneme, “Nga peneme. Yile ngay-ka kardu Pule ngala thathpirr warda banngipak, i ngarra da putek ngala kanhi i da kangkarl kathu kurrankadhuk-ka ngay-ka kardu Pule ngala thathpirr nginarranu. ");
INSERT INTO mwf2018_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","I nhini ngay-ka murrinh manarrunemenu-ka da pana ngangka-re nunnawatnemenu ngarra kardu wurnangat warda ngatha da kurran pana-re warda ngatha da ngarra putek ngala kanhi, i murrinh nuyemarranu nuru ngarra ngay da matha pangiriwaknu puru. I nankuneme-ka kardu nanluwewunu nuru i murrinh kanhi warda nuyemarranu, ‘Kardu Pule ngala nanki thathpirr warda-ka Yile neki-wa, i wakal nukunu, i Ngepan patha ngarra nukunu wanku.’ ");
INSERT INTO mwf2018_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","I kardu nuddunkuyethithnemenu nuru murrinh thathpi ngarra ngay da matha pumangabathnu thathpirr puru, murrinh terert nhini-ya ngarra ngay menarrudhaneme ngurrini-ya. I ngay-ka bere matha wangu nganinu ngarra nankuneme-yu i ngarra da putek ngala kanhi da mana panirikerdeknu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Murrinh kanhi-ka murrinh thelerrdhe patha murrinh ngarra Jesus Christ nukun, wakal nukunu Yile neki-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Murrinh kanhi pantet-ka ngarra kardu ngalantharr murntak nan Isaiah murrinh darntilil. I kanhi-wa murrinh darntilil-yu murrinh ngarra Yile neki kathu mamna, “Nga. Ngay-ka ngurduthuknu kardu nugarn numi kardu pinhimardanu tharra kumparra warra. I nukunu kardu nugarn nhini-wa murrinh ngarra ngay panthelerrnu purru ngarra kardu-yu. I nhini kardu-ka puyumpamardamardanu i pumempawathawathanu ngarra nhinhi-re tharraruynu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I nukunu kardu nugarn nhini-ka purrukaykaynu da pana-re-ya ngarra da darrinpirr pularn-ya, ‘Ya,’ marranu kardu-yu. ‘Mayern numanawathawathanu kardu Pule ngala-nu tiduk kathu purrunu. Mayern nubunayithithnu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","I bere murrinh nhini ngarra nukunu Isaiah darntilil-ka kardu thathpirr-ka pangarntuy warda ngarra da darrinpirr pularn nhini-yu. Murrinh nukunu-ka John the Baptist-wa. I nukunu-ka daninthelerrdha wurrini pangu da ngarra kardu murrinh Yile neki nukunu-yu. I kanhi-wa merradha wurrini, “Nga. Narnipartnu warda da mange wiye pana nanthin numpan-yu i nhini ngay-ka ngananluluwewunu warda ngurru kura patha-re. I nhini Yile neki-ka pirrananmaputhnu warda da mange wiye ngarra numammath numpan-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bere kardu wurnangat warda ngatha da nan thangunu kathu Judea i Jerusalem punninadha ngarra John-nu i murrinh ngarra nukunu pubimnayepup. I murrinh pumenanudha punni, “Murrinh ngarra nukunu-ka murrinh thathpirr-wa. Nekineme-ka mange wiye da thathpirr thumedhaneme thurrini.” I kardu-ka ngarra Yile neki deyida pumenadha punni mange wiye numi numi deyida parnamnatharrmu ngarra nukunu-yu. I nhini thangunu-ka nukunu John the Baptist-ka daninluluwewudha wurrini ngarra ngipilinh ngala da nan, Jordan. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bere nukunu John the Baptist banardurdidha wurrini-ka nanhthi kaligu mampatha ku nan thangunu pemarr ngarra ku camel. I nanhthi belk menarlarlarrdha wurrini-ka nanhthi leather ku darripi-wa. I ku-ka wurrinimurrktha-ka ku thalarrithay i ku thithay. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bere nukunu John the Baptist-ka murrinh numi deyida merradha wurrini ngarra kardu. “Ya. Ngay-ka kardu mere Pule ngala kanhi-yu. Mu kardu pana ngarra tiduk kathu pununu pi-ka nukunu nimin kardu Pule ngala thathpirr-yu. Ngay-ka mere mani ngurdimerereth ngarra me sandal nukunu-yu. Nhini ngay-ka wurdanngiwerdi ngemmanham-wa nhini-yu. Nukunu-ka kardu Pule ngala thathpirr warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngay-ka berengunh nganinanluluwewudha ngurrini kura patha da matha-re, mu nukunu nhini-ka bunannginirdinu Ngepan ngarra Yile neki nukun-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bere nhini thangunu-ka nukunu Jesus-ka nadha dini da nan thangunu kathu Nazareth ngarra da ngala thathpirr nan-ya Kelili. I nadha dini i pangamnaruy da mana ngarra nukunu John the Baptist. Bere nukunu John the Baptist-ka daluwewu warda Jesus-yu ngarra ngipilinh da nan-ya Jordan. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","I bere ngarra nukunu-re Jesus wurranmardawith ngarra ngipilinh thangunu kathu-ka da marnirra kalakkalak memnadharl warda. I nukunu-ka kangkarl mamka i bamkardu Ngepan ngarra Yile neki kathu wurdamnathut ngarra nukunu-nu, mangini ku kuluntutuk mani wurdanthut tharra. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","I da kangkarl kathu-ka murrinh dimngeng. I kanhi-wa murrinh mam-yu, “Nhinhi-ka kardu wakal nugarn ngay-wa. Ngay-ka marda-wa thathpirr mangannhert ngurran. I le da matha ngurranpa nhinhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bere nhini thangunu-ka Ngepan Yile neki thangunu wurdanthuk warda Jesus-yu da ngarra darrinpirr pularn-nu warda wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Da-ka nhini da da pirdithme kardidha-yu da merrk numi-ya i kanganu. I nukunu ku karrath-ka ku bere matha merulluldha kardi Jesus-yu pangu da. I ku were pulangarr wanku-ya i ku nginipunh nhini mani-ya pardidha da pangu-yu. Mu ku angel-ka bere ngatha wangu pirapedha punni Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bere ngarra nukunu-re pule Hered thangunu John the Baptist banurdi ngarra jail-ka, Jesus-ka nadha dini da ngala pangu da nan-ya Kelili i murrinh ngarra Yile nukunu thangunu daninthelerrdha wurrini ngarra kardu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I kanhi-wa murrinh merradha wurrini-yu, “Nga. Da-ka manta warda kurran kathu ngarra Yile neki-re ku Pule ngala thathpirr warda pinarranu purru kardu ngarra nukunu. Nhini-ka narnipartnu warda da mange wiye ngarra nanthin numpan-yu i numabath warda nuru murrinh thelerrdhe patha kanhi ngarra Yile neki thangunu-yu.” Jesus kathu-yu murrinh merradha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bere nhini thangunu Jesus-ka nadha dini da ngipilinh ngala nan-nu Kelili. I ngarra nukunu-re punimardadha wurrini ngarra ngipilinh-ka nukunu bampunkungkardu piguna Simon i Andrew nanhthi karlay parderuthtuththa ngarra ngipilinh ku ngurlmirl-nu. Piguna nhini-ka kardu bere matha parderuthtuththa ku ngurlmirl-nu nanhthi karlay-re. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bere Jesus kathu-ka mampirru, “Ya. Nanku-ka kardu bere matha wangu ku ngurlmirl-nu narnamkaruthtuth, mu tharra-ya purruneme ngarra ngay. Ngay-ka ngurdinankuyethithnu kardu-nu nururrakaykaynu i kardu ngarra ngay pangilerrnu puru i pangiriwaknu puru.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bere piguna nhini-ka parnamkapart warda nanhthi karlay-yu i parraneriwaktha punne ngarra Jesus warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","I puy deyida wangu punnedhaneme kunungingki-ka, Kangkarlmawu bampunkungkardu piguna James i John ngarra tharntu nanhthi karlay parraneredhaneme pirrine wunku yile piguna nan, Zebedee. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bere Kangkarlmawu-ka wurranpirrukay piguna nhini-yu. I nhini thangunu-ka parnamkapart warda yile piguna i kardu ngamere pangu da wangu ngarra tharntu. I ngarra Kangkarlmawu warda parraneriwaktha punne. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bere nhini thangunu-ka Jesus i pulangay nukunu-ka punnedhaneme da nan-nu warda wangu Capernaum. I da ngarra Saturday mana-ka, Jesus-ka kanardi ngarra murrinh church kardu Jews pigunu i murrinh ngarra Yile neki nukunu wurdininthethiththa dini ngarra kardu. Da Saturday mana warda-ka benyuk warda dini kardu Jews-yu i ngarra murrinh church pardirdurdi. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","I kardu ngarra wurdininthethiththa dini-ka kardu pumemnamardat da matha murrinh ngarra Jesus merradha dini-yu. Mu nukunu-ka nginipunh kardu Pule ngala da matha mani wurdininthethiththa dini, i mere pana mani kardu nhini-ya ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Bere da ngarra church nhini-ka kardu nugarn dinidha pangu da wunku ku ngepan wiye kanthidha wurrini. Bere nukunu nhini-ka dimnakay ngarra Jesus wangu i mamna, “Nga, Jesus kardu Nazareth-mawu. Ngay-ka the-wa mamnhibath ngurran nhinhi-yu. Pule ngala wurdannhithuk-yu. I nhinhi-ka patha i yuthpan da matha thurran i mere nabath thani da mange wiye-yu. I nhinhi-ka wakal nukunu-wa. Mu thangku-nu thurrinidha da kanhi-yu? Thurdungankartelnu i thurdungantinuminuminu ku ngepan wiye terert kanhi-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mu Jesus kathu-ka mamna ngarra ku ngepan wiye nhini-yu, “Watmam thi. I thungiwuy kathu ngarra kardu pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bere ku ngepan wiye nhini-ka buniwaththa kardi i bunirangkaltangkaldha kardi kardu nugarn nhini-yu. I nhini ku ngepan wiye-ka kardiwapadha i yungawuy warda ngarra kardu nhini thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I kardu wurnangat-ka pumemnamardat ngala da matha nhini-yu i murrinh pumenanudha punni mange pigunu, “Thangku-wa kanhi-yu? Kanhi-ka mange murrinh marra-wa kanhi-yu wurdannhiyethithngime-yu. Nukunu-ka kardu Pule ngala thathpirr-wa i kardu lurruth ngala. I ku ngepan wiye ngatha yida murrinh pumamnabath pumpan-yu ngarra murrinh mampirra wurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I bere murrinh nhini ngarra Kangkarlmawu medha wurrini-ka banalangtha wurrini murrinh-yu da pana ngangka-re ngarra da ngala nan Kelili. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bere nhini thangunu-ka Kangkarlmawu i pulangay nukunu-ka pumpankardurr-warda-neme ngarra murrinh church nhini thangunu-yu i punnedhaneme ngarra thelput piguna-nu Simon i Andrew. Bere parnamkardineme wunku piguna James i John. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bere da ngarra thelput nhini-ka pipi nginarr nukunu Simon-ka matharr yungurrkurrktha matharr pimut-wa mebaththa yu. I kardu-ka parrantherr Jesus-yu kardu matharr pangu yungurrkurrktha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bere Kangkarlmawu-ka wurriningedha i mange manganmart i dampirnturt i dinidha warda. I da nhini-re-ka kardu patha warda dinidha i matharr-ka kanampart warda. I nhini thangunu nigunu-ka mi warda dhepdhep mampirruwathawathangime. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bere da nhini da ngatha ngarra ngunga thangunu kananthurrk-ka kardu-ka kardu matharr-wunngini terert pumenbertidha punni ngarra Kangkarlmawu-nu i kardu terert ku ngepan wiye wanku panthingkadhuktha punni. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kardu wurnangat nimin-ya da nan thangunu kathu da Capernaum pubenangkardurdudha punni ngarra tuwa ngarra thelput ngarra Kangkarlmawu dinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I nukunu-ka menpathadha wurrini kardu terert kardu ngarra matharr numi numi panthidha punni. I ku ngepan wiye terert pirrinmapuththa wurrini ngarra kardu thangunu kathu-yu. Mu mere wurdirramurldha ku ngepan wiye-yu murrinh-yu. Mu banpunthap da matha nhini ku ngepan wiye-ka the-wa panthidha punni Jesus-ka wakal Yile neki nukunu-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bere da numi nhini warda-ka bere ngatha thipinhi pirridha, Kangkarlmawu-ka dempirnturt nungardurr ngarra thelput nhini thangunu-yu i nadha dini numidharrnu da ngarra watmam wangu ngarra kardu makardu-ya. I dininangerrentha ngarra Yile nukunu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bere nhini thangunu-ka nukunu Simon i pulangay nukunu Kangkarlmawu-ka pumpankawinhayneme Kangkarlmawu-yu. I punnungamkardurrneme i piranawinhadhaththaneme tharra i pubangamkardurt-da-mana-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","I murrinh pumamnaneme, “Ya. Kardu wurnangat warda ngatha panganpawinhadhath parnam nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mu Kangkarlmawu kathu-ka mampirruneme, “Nekineme-ka da ngamere deyida-nu purruwatnuneme. Ngay-ka ngangarntuy da putek ngala kanhi-ka kardu wurnangat warda ngatha nganthelerrnu ngurru murrinh ngarra Yile ngay nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bere nhini thangunu Kangkarlmawu-ka wurriniwattha da pana-re-ya da ngala nhini Kelili. I nukunu-ka daninthelerrdha wurrini murrinh ngarra Yile nukunu thangunu ngarra murrinh church terert kardu Jews pigunu. I ku ngepan wiye deyida wanku pirrinmapuththa wurrini ngarra kardu thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bere kardu nugarn numi wunku nanhthi matharr leprosy kanthidha wurrini, wurrininadha ngarra Jesus. I demnawinhipingkarl pangu warra kumparra i mamna, “Ya pule. Marda ngatha nart-ka nhinhi-ka nangiwathanu-wa kardu darripi tarangka ngurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bere Jesus-ka damnamardathin warda kardu nhini-nu-yu i nhini-ka pirrimnalangma warda i manthap. I murrinh mamna, “Yu, ngay-ka marda manganart ngarrim manhiwathanu. Nhinhi-ka kardu darripi tarangka warda thurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","I da nhini-re-ka kardu nugarn nhini-ka patha warda kardidha i matharr ngala nhini-ka kanampart warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","I Jesus kathu-ka mamna, “Nga. Mere nukun thantherr ngarra kardu-yu mange kanhi thangunu mampa-yu. Mu ngarra ku yilarn ngala da matha thununu thi i nukunu-ka banhinginingkardunu nhinhi-yu. I nhini thangunu-ka murrinh mampanu ku yilarn nhini-yu, ‘Yu, nhinhi-ka kardu manangka matharr warda, kardu darripi tarangka warda.’ I nhini thangunu-ka ku murrirrbe i ku thip thanamutnu ngarra ku yilarn-yu, ku nhini ngarra nukunu Moses mam-ya da murntak warra thanamutnu-ya. I nhini thangunu ku nhini-ka ku yilarn warda pinapeknu Yile neki-nu-yu. I nhini-ka the warda ngatha pumanhibathnu kardu wurnangat-yu nhinhi-ka kardu tarangka thathpirr warda nhini-yu.” Nhini-wa murrinh-yu Jesus kathu-yu mamna i wurdanthuk warda nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mu kardu nugarn nhini-ka mere murrinh menabaththa murrinh ngarra Jesus mamna-yu. I murrinh-ka bunilangtha weyida wurrini murrinh da ngarra Jesus patha mampatha-yu. Bere nhini thangunu Jesus-ka mere ngarra warda wurridha ngarra da town wangu-yu nhini-ka kardu nukun kirardarrirtirt kuru i kardu wurnangat nukun kuyunawerr kuru ngarra nukunu-yu. Mu nukunu-ka kardidha da ngarra bekmamarda da matha wangu. Mu kardu wurnangat-ka bere ngatha wangu punninawattha da pana ngangka-re thangunu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bere da thangku numa kama Kangkarlmawu-ka wurdawurl deyida da nan-nu Capernaum ngarra da nukunu. I murrinh-ka bamlang nukunu wurdawurl-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","I nhini thangunu-ka kardu-ka puyemnawerr warda thelput ngarra dinidha-yu. Nhini thelput-ka memmarlip da mana i outside deyida wanku kardu wurnangat-yu. I Kangkarlmawu-ka wurdanarrayiththa warda dini murrinh ngarra Yile neki nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bere da nhini-re-ka kardu ngamere parramkaruyneme ngarra thelput nhini da wunku kardu pulith pumenamathbaththaneme punne ngarra da pit-te. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu kardu-ka mere ngarra pumebaththaneme puye ngarra Jesus-nu-yu nhini-ka kardu wurnangat weyida pinganulipiyiptha purni. Bere peneme nhini-ka parnamkalaneme kangkarl da ngarra roof werlpen da mana. I weyi warda parramkawebangneme kangkarl kathu-yu ngarra Jesus da mana daniwebaththa pirri. I kardu pulith nhini-ka puddankathutneme ngarra pit nukunu nanhthi rup-te ngarra Jesus da mana warra kumparra pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mu Jesus-ka the menkumabaththaneme pirri ngarra marda peneme-yu murrinh da thathpirr pumamnabathneme nukunu-ka mawathanu patha da thathpirr kardu pulith nhini-yu. I bere murrinh mamna ngarra kardu pulith nhini-yu, “Nga. Da mange wiye pana ngarra nhinhi nebaththa thurrini-ka ngarrimnhimaputh warda-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bere kardu pana ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-ka pubimnayepup warda ngarra murrinh Jesus mamna-yu i pubenayengkarnirntha pi nginipunh kanhi mani-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Thangku-nu nukunu-yu murrinh nhini menadha pirri ngarra kardu pulith pangu-yu? Nukunu pangu-ka murrinh damnakumugat-wa kanam pana ngarra Yile neki-yu ngarra murrinh menadha pirri kardu pulith pangu-yu. Nukunu-ka mere ngarra nukun kirramaputh da mange wiye ngarra kardu pulith pangu-yu, wurda. Mu Yile neki da matha kirramaputh da mange wiye pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mu Jesus-ka bangampunkumardeneme murrinh pangu pubenayengkarnirnthaneme pe-yu. I mampirruneme, “Thangku-nu ngay nubemngayengkarnirnneme nirrimka-yu da mange nginipunh pana mani numamnganeme narnam-yu? ");
INSERT INTO mwf2018_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Mu nga. Ngay kardu ngarra darrikardu nanki thathpirr-ka kardu Pule ngala thathpirr-wa. I ngay mani-ka ngirramaputh-wa da mange wiye-yu kardu ngarra nugarn pulith kabim kanhi-yu. Mu kardu numi ngatha yida nawa kama murrinh kanhi-yu. Mu mere nangkal kama patha mawatha kardu pulith kanhi-yu. I nhini ngay-ka patha thathpirr warda kardu purrulilinu-yu i nhini-ka the warda numabathnu ngay-ka ngirranmaputh da mange wiye ngarra nukunu mebaththa wurrini-yu.” Bere Jesus kathu-ka mamna ngarra kardu pulith nhini-yu, “Ya, ngay-ka mampanu thewirnturt kathu i nartnu da pit nhinhi-yu i thurrulilinu pangu warda wangu ngarra da nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bere kardu pulith nhini-ka dempirnturt warda i manganart da ngarra pit nukunu i wurrinililidha warda pangu wangu. Mu kardu wurnangat-ka pubamkardu i pumemnamardat warda i parriniriparldha warda pardi Yile neki-yu. I murrinh pumemnu, “Ya. Nekingime-ka mere ngarra ngadha thubengkardudhangime thani mange nginipunh kanhi mani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bere nhini thangunu nukunu Kangkarlmawu-ka nadha deyida dini da ngarra ngipilinh ngala-nu. I kardu wurnangat puyemnawerr warda nhini-yu, i nukunu-ka murrinh wurdininthethiththa warda dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bere nhini thangunu ngarra Jesus-te mayern wurrinililidha-ka, nukunu-ka kardu nugarn bamkardu dinidha ngarra thelput kunungingki ku mani dininmatkuttha ngarra kardu ku Government-nu-wa. I murrinh nukunu kardu nhini-ka nan-wa Levi. I yile nukunu-ka nan-wa Alphaeus. “Ya, kagu.” Jesus kathu-yu mamna. “Thurru kathu. Purrunu warda. I kardu thangiriwaknu ngarra ngay warda.” Bere nukunu Levi-ka dempirnturt i darntiwak ngarra Jesus pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","I ngarra thelput nukunu da mana Levi pangamnintharuy mi dhepdhep-nu wunku pulangay nukunu Jesus, i bere parnamkawupneme. I kardu terert deyida wanku pirrinidha pangu mi dhepdhep-nu-yu. Kardu ngamere nhini-ka ku mani purninmatkuttha ngarra kardu ku nan-nu Government. I kardu ngamere deyida-ka murrinh law kardu Jews pigunu mere murrinh pumebaththa puyi. Kardu terert nhini-ka ngarra Jesus deyida wanku parraniriwaktha purni. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bere kardu nugarn pana ngarra murrinh law Jews pigunu puddininthethiththa purni kardu Pharisees-ya pubamkardu Jesus dinimurrktha mi ngarra kardu pana ku mani purninmatkuttha ngarra kardu i kardu pana ngarra murrinh law Jews pigunu mere murrinh pumebaththa puyi. Bere kardu Pharisees nhini-ka parrampunkudharrpuneme ngarra pulangay nukunu Jesus, “Ya peneme,” pumampirruneme. “Thangku-dha nukunu Jesus kanammurrk pangu-yu ngarra kardu pana ku mani parnampunmatkut ngarra kardu-yu i ngarra kardu pangu mere murrinh kumabath kuru ngarra murrinh law nekineme-yu? Nukunu-ka mere kurrumurrk nhini-yu ngarra kardu wiyenpun pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mu Jesus kathu-ka bimpunkumayepupneme murrinh nhini-yu i mampirruneme, “Ya. Kardu pana ngarra manangka matharr ngala-ka mere deyida kirranakay ku doctor. Mu kardu nhini da matha matharr wunku kirranakay ku doctor-yu. Mange nginipunh nhini deyida mani ngay-ka ngurrinidha da kanhi-yu kardu pana-nu manmanpinu ngurru ngarra da mange wiye panthin pumpan-ya i murrinh marranu ngurru-ka parnipartnu warda da mange wiye-yu. Mu ngay-ka mere ngurridha kardu pana-nu ngarra pamam pumpan kardu pathanpun-ya,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bere pulangay nukunu John the Baptist i kardu Pharisees ngamere mi parnamkapart-ngadha-neme nhini-ka Yile neki ngadha murrinh pardenangerrenthaneme i parraneriparldhaneme parde. Bere kardu ngamere-ka purnenadhaneme ngarra Jesus-nu i pumamnaneme, “Ya. Pulangay nukunu John the Baptist i kardu Pharisees-ka mi-ka parnamkapart-ngadha-neme nhini-ka ngarra Yile neki ngadha parnamnangerrenneme i parramkariparlneme parnam. Mu thangku-dha pulangay nhinhi-yu mange mere nginipunh nhini mani kuyemaneme kuru-yu mi mere ngadha karnemurrkneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mu Jesus kathu-ka mampirruneme, “The mana nanthinkaneme-ya ngarra kardu nugarn-te manganmert kardu palngun i bemnginthalet warda-ka kardu darrikardu nukunu-ka puyemperr warda mi dhepdhep pullathnu-yu. I bere kardu terert warda ngatha le da matha i marda ngala mi parnammurrk-yu, i mi-ka mere ngarra ngadha karnipart, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mu ngarra nugarn nhini-re kumabert mani-ka ngarra kardu darrikardu nukunu kathu-ya, nhini-ka mi dhepdhep-ka karnipart deyida nhini-yu i kanmardathinnu warda ki nukunu-nu-yu. I da mange nginipunh nhini deyida mani ngarra ngay kardu-re pumangibertnu pulangay ngarra ngay thangunu kathu nganinkupartnemenu-ka nhini peneme-ka pankumardathinnemenu i mi dhepdhep-ka parnepart-deyida-nemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bere Jesus kathu-ka murrinh numi deyida mampirruneme, “Nga. Nanhthi kaligu murntak nganaka nanhthi muyu wunku. Mere nangkal ngadha kawarl kani ngarra nanhthi kaligu marra-yu i ngarra kaligu murntak nhini-nu mawathanu-yu. Nhini-ka ngarra napurl-te warda-ka nanhthi kaligu marra nimin-ka wurrannurrurrurr mamkunungingki warda i kingurrurduk warda ngarra kaligu murntak thangunu kathu-yu. I nhini ngarra nanhthi muyu ngarra murntak-ka nanhthi muyu ngala warda kirra nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","I ngana deyida mere nangkal ngadha kawinhimardapak kura wine marra-yu ngarra nanhthi pul ku darripi murntak ngananu-yu. Mu mange nhini ngatha kama kurru-ka kura wine marra-ka kurduwi i kururup warda nhini-yu i nanhthi pul ku darripi murntak-ka kingutuy warda i kura-ka kewinhipak warda. I nanhthi pul ku darripi murntak-ka nanhthi wiye warda kirra nhini-yu. Mu kura wine marra ngatha-ka nawinhimardapaknu ngarra nanhthi pul ku darripi marra da matha,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bere da ngarra Saturday mana da ngarra kardu Jews benyuktha dini-ka Kangkarlmawu i pulangay nukunu-ka purnelilidhaneme da ngarra mi katin ngarra mi yimun da matha wangu wurrinidha. I pulangay nukunu Kangkarlmawu-ka pumuniwerartaldhaneme purne ngarra mi kamarl pelpith da matha i purnemurrktha-warda-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bere kardu nugarn pana kardu Pharisees-ya pumamnaneme ngarra Jesus, “Ya. Thangku-dha pulangay nhinhi mi pana kumungamkawerartalneme kumpanka-yu i pumpankamurrkneme-yu? Peneme-ka mange mere piyema-nukun-neme marra kanhi-yu ngarra kardu wurnangat warda ngatha-re bangamnganyuk dim-yu. Nhini-wa da murrinh law yibim-yu, murrinh law nekineme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Mu Kangkarlmawu kathu-ka mampirruneme, “Nankuneme-ka rit ngadha numedhaneme-ya murrinh ngarra King David mange mam-yu ngarra nukunu-re medeyi kardidha-yu wunku pulangay nukunu-yu? Nga, nukunu-ka kanardi ngarra thelput Pule ngala Yile neki nukunu i mi danthakthuk mi lawam pangu diningkadhuktha mi Yile neki nukunu. I nukunu-ka wulamath mi nhini-yu i ngarra kardu nukunu deyida wanku danirrumutmutthaneme i pullamkath-warda-neme nhini-yu. Da nhini-re nukunu Abiathar-ka dinidha ku yilarn ngala. Murrinh law nekineme yibim-ka ku yilarn da matha mi lawam pangu-yu pumpanmurrk-yu, mu nukunu King David i kardu ngarra nukunu mi-ka pullamkath-weyida-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I Kangkarlmawu kathu-ka mampirru-deyida-neme, “Yile neki marra-re mampatha-ka kardu nugarn. I nhini thangunu tiduk nhini mampatha-ka da Saturday kardu-nu banyuknu pi. Nhini da matha mange yibim-yu. Nukunu Yile neki-ka da-ka nhini-wa dammut-yu i nekineme-ka banhiyuk-wa-nu-neme pi. ");
INSERT INTO mwf2018_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mu ngay kardu ngarra darrikardu nanki thathpirr-ka kardu Pule ngala thathpirr-wa ngarra da wurnangat nukunu-ya i da ngarra Saturday deyida wanku. Mu nhini-ka berengunh-wa pulangay ngay mi pana pumungamkawerartalneme pumpanka-yu.” Kangkarlmawu kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bere Kangkarlmawu-ka kanardi deyida ngarra murrinh church kardu Jews pigunu. I da nhini-ka kardu nugarn numi dinidha ngangka da mange wardi punimawerlerldha kardi mange numi-re. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Da-ka Saturday-wa nhini-yu i kardu ngamere Pharisees-ya pirangkadhaneme pirrine kardu ngarra kama pamanu Kangkarlmawu mange ngarra nukunu kardu pangu ngarra mange mamawathanu. Peneme nhini-ka marda pumertthaneme purne Kangkarlmawu mange ngarra kardu pangu mamawathanu, i nhini nukunu-ka munmaparlnu warda murrinh law kardu ngarra Jews pigunu-yu i nhini-ka murrinh warda pangkabirrnemenu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bere nukunu Jesus-ka murrinh mamna kardu nugarn nhini-yu, “Wurr, thewirnturt kathu. Thurru kathu i kumparra kanhi warra thirrat.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","I Jesus kathu mampirra kardu ngarra terert, “Ngarra nimin murrinh law nekingime pirrim-yu? Da Saturday ngarra da nekingime bangannhiyukngime-ya, ngarra nimin da mange patha-yu? Kardu kama pumankumanpinungime purru i kardu mere kama pumankumanpingime purru? I ngana deyida ngarra nimin da mange patha-yu? Kardu kama pumankuyibirnunungime purru i kardu kama punkuthuknungime purru? Da-ka ngarra nimin da mange yuthpan-nu-yu?” Jesus kathu-yu dampuntharrpu. Mu kardu-ka manangka murrinh watmam da matha pirrinidha. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bere Jesus-ka yerrarr mamka kanhi-re ngarra kardu i pumammardaraki warda, nhini kardu-ka tetepumanthi-wa i mere marda pumerttha murrinh ngarra nukunu-yu. I murrinh mamna deyida ngarra kardu nugarn nhini-yu, “Nga. Mange pana ngarra nhinhi thungurathtath.” Bere kardu nugarn nhini-ka mange yungantathtath i mange nhini-ka patha warda mebaththa pirri nginipunh mange patha numi pangu-re deyida mani mebaththa kardi. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bere nhini thangunu kardu Pharisees-ka pungawurr warda nhini-yu i pubemkamardabineme kardu nugarn pana kardu pule Hered nukun. I murrinh warda puddanayiththaneme pe murrinh ngarra-re da mange Kangkarlmawu thu pubatnemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Bere nukunu Jesus i kardu pulangay nukunu-ka punnungamkardurr-warda-neme da ngarra nhini thangunu-yu i punnadhaneme da ngarra ngipilinh ngala-nu. Kardu wurnangat nimin-ya parraniriwaktha purni Jesus-yu. Kardu nhini-ka da-ka da nan thangunu kathu Kelili i da Judea-ya i da nan Jerusalem i da Idumea-ya. I da ngamimarda thangunu kathu da ngipilinh Jordan-ya i da nan thangunu kathu-ya Tyre i da Sidon-ya. Kardu wurnangat nimin-ya parraniriwaktha purni Jesus nhini weyida puyemnayepup mange ngala ngala merradha wurrini ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bere Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Ya peneme. Tharntu kathu numangartneme i manta kanhi nubungapakneme. Kardu kubangirerda nukun kardu wurnangat-wa kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bere Jesus-ka kardu matharr-wunngini terert menpathadha wurrini. I kardu matharr-wunngini ngamere deyida kardu puddanarururttha purni kardu pumathapnu-wa ngarra Jesus kardu patha-wa manpathanu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","I kardu pana ngarra ku ngepan wiye panthidha purni-ka ngarra Jesus mana pubengkardu-ka nhini-ka pubananabat warda pangu warra kumparra ngarra nukunu i pardinakaykaydha warda nhini-yu. I pumenadha purni, “Nhinhi-ka wakal Pule ngala Yile neki nukunu-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","I Jesus kathu-ka murrinh warda menmardawerrdha wurrini, “Nga. Mere nukun nanthelerr murrinh nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bere nhini thangunu Kangkarlmawu-ka dimmardawith warda da ngarra palyirr i kardu ngarra marda mampunkurtneme-ka pirrimpirrukayneme. I kardu nhini-ka pirrimnamardawithneme ngarra nukunu da ngarra palyirr kangkarl. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","I kardu nhini-ka ngarra mampunkungkarartneme i pirrimpirrukayneme-ka kardu-ka 12-wa i kardu-ka pulangay nukunu-wa thathpirr. I mampirruneme, “Nga peneme. Ngay-ka ngurdunankuthuknemenu da pana ngangka-re-ya i murrinh ngarra ngay kardu nankuyelerrnemenu nuru. I ngay-ka nganarrumutnemenu nanhthi lurruth ngala i nhini-ka nirankumaputhnemenu nuru ku ngepan wiye terert ngarra kardu thangunu kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bere kanhi-wa kardu murrinh peneme-yu ngarra Jesus mampunkungkarartneme-yu. Nukunu Simon, mu Jesus panparl-ka murrinh numi deyida Peter-wa murrinh-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","I piguna James i John, i yile piguna-ka nukunu Zebedee-wa. I piguna nhini nukunu Jesus-ka murrinh numi deyida panpunkuparl murrinh-ka Boanerges-wa. Murrinh kanhi-nu-ya kardu parramkarithi-ka nanhthi nginipunh banganthaymirr mani. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","I nukunu Andrew-ya, Philip i Bartholomew, Matthew, Thomas i James. Yile nukunu James-ka Alphaeus-wa. I nukunu Thaddaeus i Simon Patriot. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","I nukunu Judas Iscariot, kardu pana-ya ngarra Jesus dampirramut da nakurl-te kardu ngarra wiyenpun. Kardu-ka nugarn-ka nhini-wa Jesus menkungkarartthaneme dini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bere nhini thangunu Jesus-ka wurdawurl da ngarra nukunu. I kardu wurnangat puyemnawerr deyida ngarra nukunu-yu. Kardu-ka wurnangat nimin-ya i Jesus i pulangay nukunu-ka mere warda ngarra pulleththaneme mi dhepdhep-yu nhini kardu-ka parrampirruwerr-da-matha-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bere ngarra kardu darrikardu manta nukunu murrinh nhini-re puyemkayepupngime-ka nhini-ka punnenadhangime nukunu-nu piranakaynungime i ngarra da-nu mana-wa pumabertinungime. Peningime-ka pumemnungkungime, “Nukunu-ka kardu pelpith wiye-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","I ngana deyida kardu nugarn ngamere pana ngarra murrinh law puddininthethiththa punni, punnina-deyida-dha ngarra Jesus-nu da nan thangunu kathu Jerusalem. I murrinh puddanarrayiththa punni i pumerradha punni, “Nukunu Jesus-ka ku karrath da matha mammath wurran. I da-ka nhini-re-wa pirrimpunmaputh wurran ku ngepan wiye wiye ngarra kardu thangunu kathu.” Nhini-wa murrinh puddanarrayiththa punni ngarra nukunu-nu Jesus-yu murrinh pardirdarrikutkuttha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bere Jesus-ka kardu panpunperr manta manta i murrinh warda mampirra, “Nga kardu, nubingayepup kathu. Nukunu ku karrath-ka mere ngarra kununuku ngarra kardu kathu-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","I nga, kanhi numi-yu. Kardu darrikardu ngatha thu kuyunuthuk kuru-ka nhini-ka kardu kuyunurikerdek-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","I kardu darrikardu manta ngatha thu kuyuthuk kuru-ka nhini kardu-ka kuyunurikerdek deyida nhini-yu. I kardu-ka mere warda lurruth parnenungime i mere warda mitmit parnenungime nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","I mangini nhini mani ku karrath-ka mere kirranmaputh kurru ku ngepan wiye wiye nukunu ngarra kardu thangunu kathu-yu, wurda da matha. Mu nukunu nhini i ku ngepan wiye wiye ngarra nukunu-ka marda ngala da matha parnamkaneme-yu. Mu ku karrath ngatha ku ngepan wiye wiye kirranmaputh kurru-ka, nhini peneme-ka mere warda mitmit karnenemenu, i mere warda lurruth ngala karne-nukun-neme, wurda da matha warda. I peneme-ka kuyunungkurikerdek-da-matha-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bere nukunu Jesus-ka murrinh deyida mampirra, “Nga. Mere nangkal ngadha kanimardi ngarra thelput kardu lurruth ngala nukunu-yu i mangkardap nanhthi purrkpurrk nukunu-yu. Mu kardu madharrkirrk warra ngadha kardu lurruth ngala nhini-yu i nhini-ka nanhthi purrkpurrk nukunu warda mangkardap nhini-yu.” Murrinh-ka nhini-wa mampirra ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","I murrinh deyida mampirra, “Nga, murrinh kanhi manarranu-ka murrinh thathpirr-wa. Kardu ngatha da mange wiye panipartnu, nhini Yile neki-ka pirramaputhnu i puymayekumnu da mange wiye nhini ngarra mebaththa wurrini-yu. I kardu ngatha murrinh mardarrithaknu ngarra Yile neki wangu, mu da nakurl-te pamardathinnu murrinh nhini thangunu, nhini Yile neki-ka pirramaputh-deyida-nu i puymayekumnu murrinh wiye nhini thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mu nga. Kardu ngatha murrinh mardarrithak ngarra Ngepan patha Yile neki nukunu, nhini Yile neki-ka mere ngarra kirramaputh i mere ngarra kuymayekum da mange wiye nhini-yu. Mu da mange wiye nhini-ka da bere matha wangu mabathnu purru kardu paninu da kanhi-yu i da numi nhini wangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Murrinh nhini Jesus mampirra-ka murrinh nhini weyida kardu pumerdarrithaktha punni Ngepan Yile neki nukunu i murrinh pumedha punni, “Nukunu Jesus-ka ku ngepan wiye ngala da matha mammath wurran,” murrinh pardirdarrikutkuttha. Mu da thathpirr-ka nukunu Jesus-ka ku Ngepan Yile neki da matha nukunu mebaththa wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bere ngarra da nhini-re-ka kale nukunu Jesus i ngathan nukunu-ka parramkaruyngime ngarra thelput nhini da. Kardu-ka pangu da kathu outside penganadhaydhangime ngarra thelput i murrinh puddannathukngime ngarra nukunu-nu Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kardu wurnangat nimin-ya parraniwegattha pirrini ngarra Jesus-yu. I murrinh pumamna, “Ya. Kale nhinhi i ngathan nhinhi-ka kanhi kibimkangime nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mu Jesus kathu-ka mampirra, “Nangkal nimin ngay-yu kale mamnge ngurran-yu? I nangkal nimin ngay-yu ngathan mamna ngurran-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I yerrarr mamka warda kanhi-re ngarra kardu parraniwegattha pirrini. I mampirra deyida, “Ya. Nanki-wa nimin kale mamnarra ngurran-yu i ngathan wanku deyida mamnarra ngurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kardu nangkal ngatha da mange ngarra Yile neki nukunu pariwaknu purru-ka, kardu-ka nhini-wa kardu darrikardu ngay thathpirr-yu. Nhini-wa kardu-yu ngathan ngay, munak ngay i kale ngay-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bere kardu wurnangat nimin-ya puyemnawerr deyida ngarra Kangkarlmawu ngarra ngipilinh nganangurru ngipilinh ngala-ya. I nhini nukunu-ka kanammardap ngarra tharntu i nhini da kathu wurdininthethiththa dini-yu ngarra kardu pangu-re pidha manta da ngarra dimunurdi. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bere murrinh niyithniyith terert wurdanarrayiththa dini murrinh pana-ya ngarra yungkamnumtha. Murrinh numi-ka kanhi-wa mampirra, ");
INSERT INTO mwf2018_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ya kardu, nubingayepup kathu,” nukunu Kangkarlmawu kathu-yu mampirra. “Murrinh kanhi-ka murrinh ngarra kardu nugarn wurlk medha wurrini ngarra mi kadin. Bere nukunu-ka mi kamarl mangankut i mi warda kamarl wurriniwuthpuththa weyi ngarra ku puliki meyeththa wurrini nanhthi thay pangkuy wuting-te. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I bere nukunu-ka da pana-re-ya wurriniwuthpuththa mi kamarl-yu. “Bere mi kamarl ngamere-ka buniwinharrdha wurrini ngarra mayern i ku murrirrbe-ka pardimurrktha warda mi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","I mi kamarl ngamere-ka buniwinharrdha wurrini ngarra palyirr kurethkurethmam. I mi-ka puddarnturturt pirtpirt da matha nhini-ka putek kunungingki-wa nhini-yu i tukuriki wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mu ngarra ngunga ngala mana warda pirridha-ka nhini-ka mulurn therrke warda dempunmugarl nhini-yu. Nhini-ka ngimalmin kunungingki-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“I mi kamarl ngamere-ka buniwinharrdha wurrini ngarra nanhthi nan wangu mayeyep. Mi-ka pangarnturtuy, mu nanhthi mayeyep-ka nanhthi ngala da matha puddarnturturt i mi nhini-ka pumpanpunpekarl i parrampirradhap mi nhini-yu i pumpanpunthinkun warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","I mi kamarl ngamere mi terert thathpirr-ka banawaththa wurrini ngarra putek patha. I mi-ka pangarnturtuy i puddarnturturt i mi terert warda pinthutut nhini-yu. Ngamere mi kamarl dhepdhep nhini pinthutut-ka mi-ka ngamere da matha. I ngamere mi kamarl dhepdhep nhini pinthutut-ka mi-ka terert tharrngini nhini-yu. I ngamere mi kamarl dhepdhep nhini pinthutut-ka mi-ka terert nimin-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bere Jesus kathu-ka mampirra, “Kardu nangkal ngatha mangimarta murrinh niyithniyith kanhi-ka nukunu kardu nhini-ka murrinh-ka mabath warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bere kardu ngarra terert puddalath warda da ngarra pigunu-ka kardu ngamere i kardu pulangay nukunu Jesus kardu 12-ya murrinh warda pumamna, “Ya pule. Thurdungarrameriyith mani murrinh pana ngarra kardu mi kamarl wurriniwuthpuththa-yu. I murrinh niyithniyith ngamere nginipunh nhini mani thurdungarrameriyithnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bere Jesus kathu-ka mampirra, “Yile ngay bannanperdi wardarra ngarra mukmuk nanki da ngarra mange nukunu-yu, i da mange ngarra-re ku Pule ngala thathpirr pinu-yu. I mere nangkal ngadha the mebaththa wurri da mange nhini-yu, mu nanki da matha the warda thathpirr nanthin. Mu kardu ngamere-ka pubinthepup da matha pumpan murrinh niyithniyith yibimkamnum-ya. Mu mere thathpirr kumarta murrinh nhini-yu, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Kardu nhini-ka da mange ngarra ngay pubamngimangkardu pumpan mu mere thathpirr kumangimarta kuru, i kardu-ka pubimngayewup pumpan mu mere thathpirr kumangimarta kuru. Mu kardu ngatha kumangimarta kuru murrinh niyithniyith yibimkamnum-ka nhini kardu-ka karnipart warda da mange wiye ngarra pigunu-yu i ngarra Yile ngay warda kurdunawurl nhini-yu. I nukunu-ka kirranmaputh warda da ngarra mange wiye ngarra pigunu thangunu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bere Jesus kathu-ka mampirra deyida, “Nanki-ka mere numarta murrinh niyithniyith nhini-yu ngarra kardu numi mi kamarl wurriniwuthpuththa-yu?” Dampuntharrpu. “Murrinh nhini ngatha mere numarta murrinh yibimkamnum-ka nhini-ka mere numarta-deyida-nu murrinh niyithniyith yibimkamnum ngamere-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bere Kangkarlmawu-ka murrinh wurdanpirrameriyith thathpirr warda i mampirra, “Nga. Mi kamarl pana ngarra kardu nhini wurriniwuthpuththa-ka nginipunh murrinh Yile ngay nukun. I kardu pana ngarra mi kamarl wurriniwuthpuththa-ka nginipunh kardu pana mani kardu ngarra murrinh Yile ngay nukun dampunthelerr wurran. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I mi kamarl pana ngarra mayern banawaththa wurrini-ka nginipunh pana mani kardu ngarra pubinthepup murrinh ngarra Yile ngay nukun-ya. I mere pirdith ku karrath kathu wurran i murrinh ngarra Yile ngay nukun manganpunmart i puyenthekum warda nhini-yu nginipunh ku murrirrbe pangu deyida mani mi kamarl nhini pardimurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I mi kamarl pana ngarra palyirr kurethkurethmam banawaththa wurrini-ka nginipunh pana mani kardu ngarra pubinthepup murrinh ngarra Yile ngay nukun-ya. I kardu murrinh ngadha pumammath-ya i le patha warda parnam-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mi kamarl nhini-ka mi pirtpirt da matha puddarnturturt, mu nanhthi ngimalmin pigunu-ka kunungingki-wa i mere pirdith dempunmugarl. Mange nginipunh nhini mani-ka ngarra kardu-re pumampirrarithuk pumpan i pumampuntullul pumpan ngarra murrinh Yile ngay nukunu weyida pumammath pumpan-ka, nhini-ka parnampart warda pirtpirt da matha murrinh nhini-yu. Nhini-ka mere thathpirr pumeyittha da marra-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I mi kamarl pana ngarra nanhthi mayeyep banawaththa wurrini-ka nginipunh pana mani kardu ngarra pubinthepup murrinh ngarra Yile ngay nukun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mu kardu nhini-ka dampunpethin wurran i ku mani i nanhthi mirrkat-ka marda pumanganart da matha pumpan. I nginipunh nanhthi mayeyep deyida mani wurdarnturturt ngala-ya i damnadhap warda mi-yu i panthinkun warda. Nhini-ka ku mani i nanhthi mirrkat ngarra kardu marda pumanganart-ka i damnadhap warda kardu murrinh kumanabathnu thathpirr kuru murrinh ngarra Yile ngay nukun-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“I mi kamarl pana ngarra putek patha banawaththa wurrini-ka nginipunh pana mani kardu ngarra pubinthepup murrinh ngarra Yile ngay nukun-ya i murrinh pumamnabath warda i pumpantet parrarntiwak pumpan Yile ngay-yu. I mi pana ngarra mi kamarl pelpith ngamere pinthutut-ka mi nhini-ka nginipunh kardu pana mani ngarra da mange ngarra kunungingki ngadha pumamna pumpan Yile ngay-nu-ya. I mi pana ngarra mi kamarl pelpith terert tharrngini pinthutut-ka mi nhini-ka nginipunh kardu pana mani ngarra da mange terert tharrngini pumamna pumpan-ya Yile ngay-nu. I mi pana ngarra mi kamarl pelpith terert nimin-ya pinthutut-ka mi nhini-ka nginipunh kardu pana mani ngarra da mange terert nimin-ya pumamna pumpan Yile ngay-nu-ya.” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bere Kangkarlmawu-ka murrinh niyithniyith numi deyida wurdampirrayith i mampirra, “Nga. Mere nangkal ngadha karibirl thungku lem-yu i bupak pepe ngarra nanhthi pakit. I nukunu-ka mere ngarra ngadha bupak ngarra da pit pepe-yu wurda. Mu nukunu-ka mamkale kangkarl kathu nhini-ka thungku parlarrangnu pintha. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Murrinh nginipunh nhini deyida mani murrinh niyithniyith yibimkamnum nhini-ya da nakurl-te-wa murrinh nhini pumartanu-yu kardu-yu. Mu kardu-ka murrinh-ka mere da ngatha the kumabath marra-yu, mu da nakurl-te-wa murrinh nhini-yu the pumabathnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Kardu nangkal ngatha mangimarta murrinh niyithniyith kanhi-ka nukunu kardu nhini-ka murrinh-ka mabath da matha warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bere Kangkarlmawu kathu-ka mampirra deyida, “Nga. Kanhi-ka murrinh thathpirr nubiyepup nuru. Kunungingki ngatha murrinh nubiyewup nuru-ka, nhini Yile neki-ka kanarramut warda numamarta kunungingki da matha. Mu ngala thathpirr ngatha murrinh nubiyewup nuru-ka nhini Yile neki-ka kanarramut warda numamarta ngala da matha. I puy deyida wangu panarramutmutnu purru i nurumangawurtnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","I kardu ngarra wurranmangawurt thathpirr murrinh ngarra Yile neki nukun, nhini nukunu-ka panamutmutnu purru puy deyida wangu purrumangawurtnu. Mu kardu ngarra mere biyewup thathpirr kurru-ka nhini Yile neki-ka mamartnu warda murrinh ngarra kunungingki manganmarta-yu,” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Bere nhini thangunu-ka Kangkarlmawu-ka murrinh numi deyida mampirra, “Nga. Ngay-ka murrinh numi deyida ngurdinarrayithnu murrinh yibimkamnum-ya. Da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Yile neki nukunu ku Pule ngala thathpirr pirranu, mange-ka murrinh nginipunh kanhi mani-wa ngurdiyithnu kanhi. “Bere kardu nugarn mi kamarl mangankut i mi bangammirrbirr ngarra putek. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","I nhini thangunu nukunu-ka kanawit ngurrnguwarl ngadha da numi-yu. I pankapurl nhini-ka kanammirlbirl ngadha nhini-yu. I thipinhi nhini-ka kanawit deyida ngurrnguwarl. I mange nginipunh nhini-re mani mam wurran-ka mi pangarnturtuy warda kathu wurran mi therrke i puddarnturturt kathu pumpan i mi ngala da mana. Mu nukunu-ka mere the-wa mabath mi ngarra-re mam wurran mi puddarnturturt pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mu mi-ka mange pigunu-re mi puddarnturturt pumpan ngarra putek thangunu-yu. Mi marra-re-ka mi therrke pangarnturtuy. I nhini thangunu-ka mi kamarl terert warda mi ngatin pangarnturtuy. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","I mi pinthutut mi thungku thathpirr warda. I nhini thangunu nukunu-ka mi bangammerartal i danthakthuk warda nhini-yu. Mange nginipunh nhini mani-wa kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Pule ngala Yile neki nukunu-yu.” Nhini-wa murrinh Kangkarlmawu kathu wurdampirrayith-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Bere Kangkarlmawu kathu-ka murrinh deyida mampirra, “Nga. Ngay-ka murrinh numi deyida ngurdinarrayithnu. Da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Yile neki nukunu i ku Pule ngala thathpirr pirranu, mange-ka murrinh nginipunh kanhi mani-wa ngurdiyithnu kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Nga. The mana nanthin mi kamarl mi mustard. Mi kamarl nhini-ka mi kunungingki thathpirr-wa. Bere kardu-ka mi kamarl nhini-ka manganart i bangammirr ngarra putek. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","I nhini thangunu-ka mi wurdarnturturt-ka thay-ka ngala-wa mi wanku-ya. I ku murrirrbe wanku pumpannupup ngarra nithinu thay nhini-yu i ku dirri wanku pumampatha pumpan,” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bere murrinh niyithniyith terert nginipunh nhini mani Kangkarlmawu wurdanarrayiththa wurrini-ya kardu ngarra wurnangat-yu, murrinh-ka nhini-wa ngatha pumeyit punni ngarra mukmuk pigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I kardu pana ngatha puyenanawerr punni ngarra nukunu ngarra murrinh nhini ngatha wurdanarrayiththa wurrini-ya. Mu da nakurl-te ngarra kardu wurnangat warda puddanalath pangu wangu-ka nhini-re warda nukunu wurdinirrumeriyithneme murrinh yibimkamnum nhini-yu ngarra pulangay nukunu-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bere da nhini da ngatha ngarra nanhthi ngunga-re kananthurrk-ka nukunu Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Peneme, ka purrukath-wa-neme ngarra ngipilinh i ngamimarda pangu kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bere kardu pulangay nukunu-ka parnamkamardapneme ngarra tharntu ngarra Jesus dininganamardadha-yu. I pumpankardurr-warda-neme da ngamimarda-nu kathu-yu. I kardu wurnangat-ka pangu da wangu parnampunkupartneme tiduk pidha ngarra dimunurdi da pangkin. I tharntu ngamere deyida wanku pumpannurdurr-yu i parraniriwaktha warda punni Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bere puy punnedhaneme ngarra ngipilinh ngala i nhini da wirrirr ngala pangampirruruyneme nanhthi ngurntinh ngala wanku. I nanhthi ngurntinh ngala-ka punibattha wurrini ngarra tharntu i yingarlurl-da-dha-matha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mu nukunu Jesus-ka ngurrnguwarl yungurrkurrktha ngarra tharntu tiduk kathu wurdanangkardaldha-yu ngarra nanhthi pila-re. I peneme nhini-ka pumamkardurt-warda-neme i murrinh pumamnaneme, “Pule, kardu pangankudhardumnu-warda-neme ngankuneme-yu. Kardu-ka nhinhi-ka nangankuyibirnunu-mani-neme?” Pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bere Jesus-ka dempirnturt warda i murrinh lurruth warda mamna ngarra nanhthi wirrirr-yu, “Bere-ya, nadhap warda-ya.” I nanhthi ngurntinh deyida wanku mamna, “Bere-ya, da-ka watmam warda thirra-ya.” I nhini thangunu-ka wirrirr manthap warda i kura ngipilinh ngala nhini-ka watmam deyida yudha. ");
INSERT INTO mwf2018_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bere Jesus kathu-ka mampirruneme, “Thangku-dha nankuneme nerremkanhamneme-yu? Nankuneme-ka murrinh nganaka-ya numengabaththaneme-ya ngarra ngay menankuyibirnudhaneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","I bere peneme nhini-ka perremkanham-warda-neme ngala da matha. I murrinh pumemnungkuneme mange peneme, “Ya. Kardu kanhi-ka kardu mere nginipunh nekineme mani. Nukunu-ka kardu lurruth ngala nimin-ya. Nanhthi wirrirr i ngurntinh wanku deyida murrinh pumamnabathnintha-yu murrinh ngarra thathpi nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bere Kangkarlmawu i pulangay nukunu-ka purnedhaneme i parramkaruyneme da ngamimarda pangu kathu ngarra ngipilinh ngala da ngarra kardu nan pardipuptha, kardu Kadarinh. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Bere ngarra nukunu-re Jesus wurdawal ngarra tharntu kathu-ka kardu nugarn numi wurrininadha kardu ku ngepan wiye kanthidha wurrini. Nukunu-ka da ngarra mintilbith-wa kardipuptha. I nukunu-ka nanhthi chain-te mana-wa pumedharrkirrktha, mu wurda puddamnabay. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Da terert nimin-ya kardu nukunu-yu pumedharrkirrktha mana-wa puyi mange perrkenku i tharrmu perrkenku. Mu nukunu-ka wurda, bere matha wangu bunirartaldha wurrini nanhthi chain nhini-yu ngarra mange i tharrmu-yu. I kardu mere nangkal ngadha meyitthittha wurri. Nukunu-ka kardu lurruth ngala-wa wurrinidha-yu ku ngepan wiye wanku kanthidha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Da bere matha wangu da ngunga da thipinhi-yu kardiwapa ngarra da mintilbith-ya i ngarra da palyirr wangu. I nanhthi palyirr wutingwuting-te menanuyetheththa wurrini kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bere kardu nugarn nhini da Jesus bamkardu-yu da ngathparr kathu nathiptha dini. I nhini-ka tharra warda nungampinhat ngarra Jesus-nu i demnawinhipingkarl kumparra warra ngarra nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mu Jesus kathu-ka mamna ngarra kardu nhini-yu, “Ngepan wiye, thungiwuy kathu ngarra kardu pana-yu.” I nukunu kathu-ka dimnakay, “Ya Jesus,” mamna. “Nhinhi-ka wakal Pule ngala Yile neki nukunu-wa. Thangku-nu ngay-yu? Yile neki-ka bimngayepup dim ngarra murrinh kanhi ngay ngamnhidharrpu ngem-yu. Nhini-ka mere thungibat nukun ngay-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Nangkal murrinh nhinhi-yu?” Jesus kathu-yu mamna. “Murrinh ngay-ka wurnangat-wa. Nhini weyida ku ngepan wiye ku wurnangat nimin-ya nganthin ngurran-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I nukunu nhini-ka menanarlupurldha kardi i menadha kardi ngarra Jesus, “Mere nukun thurdungankarel da numi-nu warda wangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bere da nhini-re-ka ku pigipigi ku wurnangat pangu wangu pardimurrktha manta ngangka da ngarra palyirr. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","I ku ngepan wiye nhini-ka pumamna ngarra Jesus, “Thurdungankarel pangu ngarra ku pigipigi i ngarninnginirdinu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“Yu bere-ya. Nuru-wa.” Jesus kathu-yu mampirra. I nhini thangunu-ka ku-ka pungawurr warda kathu ngarra kardu nhini thangunu-yu i parnampart warda. I Jesus-ka wurdanpunkarel warda ngarra ku pigipigi wangu i ku ngepan wiye nhini-ka parnampunnginirdi warda nhini-yu. Ku pigipigi-ka ku wurnangat nimin-ya ku 2,000-wa. I nhini thangunu ku pigipigi-ka tharra warda dinidha parrampirntigat ngarra palyirr thangunu kathu ngarra ngipilinh ngala da mana. I nhini-ka dampunthiwik warda ku nhini-yu i bangarntikerdek da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bere kardu nugarn ngarra ku pigipigi pirapedhaneme parde-ka tharra warda punnungamkawinhatneme i murrinh parrininkuyelerrdhaneme ngarra kardu da ngarra town i da pana ngangka-re-ya. I nhini thangunu-ka kardu wurnangat warda ngatha punnidha pangu-yu ");
INSERT INTO mwf2018_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","i parramnaruy ngarra Jesus. I kardu nhini-nu wanku pubamkardu kardu ngarra ngepan wiye ku wurnangat mebaththa wurrini. Nukunu kardu nhini-ka watmam warda dinidha i pelpith patha thathpirr warda dinidha i nanhthi kaligu thathpirr warda bardi. I nhini thangunu kardu-ka perrenham warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","I kardu nugarn pangu ngarra Jesus pubangammangkarduneme kardu nugarn nhini mampatha-ka nhini-ka murrinh warda parraninkuyelerrdhaneme purne murrinh ngarra kardu nhini patha mampatha-yu i ngarra ku pigipigi dampunthiwik-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bere nhini thangunu-ka kardu-ka murrinh warda pumamna ngarra Jesus, “Ya. Nhinhi-ka thunurdurrnu warda marra kanhi-yu da ngarra nganki kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bere ngarra nukunu-re Jesus kanammardap ngarra tharntu-ka kardu nugarn nhini ngarra ku ngepan wiye mebaththa wurrini-ka memnarlupurl i murrinh mamna ngarra Jesus, “Ngay deyida wanku purrunu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mu Jesus kathu-ka mamna, “Awu wurda. Mu pangu wangu thununu thi kardu ngarra darrikardu nhinhi i thanthelerrnu thurru Yile neki-ka dampamardathin nhinhi-nu i patha mamnhiwatha warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bere nukunu kardu nhini-ka pangu warda wangu nadha dini ngarra da town 10 nhini-ya, da nan Decapolis, i kardu warda daninthelerrdha wurrini murrinh ngarra Jesus mampatha nukunu-yu. I kardu wurnangat nimin-ya pumemnamardat da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bere nhini thangunu Jesus-ka nungamkath deyida da ngipilinh ngala nhini da ngamimarda pangu kathu nanhthi tharntu-re. I wurdawal i karnawup dinidha ngarra pangkin dimunurdi. I kardu wurnangat warda puyemnawerr ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bere kardu nugarn wurrininadha ngarra Jesus-nu. Murrinh nukunu-ka Jairus-wa i nukunu-ka kardu pule deyida ngarra murrinh church kardu Jews pigunu. Bere nukunu Jairus-ka demnawinhipingkarl kumparra warra ngarra Jesus ");
INSERT INTO mwf2018_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","i memnarlupurl i mamna, “Pule nga. Wakal ngay kardu mardinhpuy kardu matharr ngala yibim kardu manta warda pupupnu. Mu purrunu ngadha da ngarra ngay i nathapnu i patha nawathanu i kardu birnu da ngatha paninu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bere penintha nhini Jesus i Jairus-ka naninthadha warda dini da ngarra nukunu-nu warda wangu nan Jairus. I kardu wurnangat wanku parraniriwaktha punni Jesus-yu i pubenarerdadha punni manta manta ngangka da ngarra nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bere kardu ngarra wurnangat nhini-ka kardu palngun numi pangu da matharr kanthidha wurrini. Matharr nhini-ka kardu palngun pigunu matharr kumulung-wa i da bere matha wangu wurrinikutkuttha. Da-ka da thangku 12-wa da pirdithme nimin-ya mebaththa wurrini-yu matharr kumulung nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I nigunu-ka ku mani ngala da matha danirramutmuttha wurrini ngarra ku doctor terert kardu patha pumewathadha mana-wa, mu puddamngebay da matha. I nigunu-ka matharr ngala thathpirr warda mebaththa wurrini i pakpakmenginidha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Mu nigunu-ka pamnayepup Jesus-ka kardu matharr-wunngini wurnangat menpathadha wurrini. I memnu mange nigunu, “Kaligu nukunu ngatha ngarra bardi kurran mathapnu-ka nhini-ka kardu patha warda manangka matharr ngurrunu nhini-yu.” I bere nigunu-ka tiduk wangu wurrininadha i manthap ngarra kaligu nukunu da mana ngarra bunibalbalktha wurrini. I da nhini-re-ka kardu patha warda kardidha nhini-yu i kumulung-ka mamngedhap warda. I yingamnuthap ngarra nginipunh nigunu-yu kardu patha warda kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mu nukunu Jesus-ka yingamnuthap kardu numi patha mampatha-yu ngarra lurruth ngala nukunu thangunu. I nhini-ka yerrarr mamka ngarra kardu wangu i murrinh mampirra, “Nangkal kardu ngay mamngithap-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mu pulangay nukunu kathu-ka pumamnaneme, “Kardu wurnangat mana-ya pubangamnhirerda pumpan-ya. Thangku-nu thentharrpu thurran-yu nangkal mamngithap-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bere Jesus-ka yerrarr mengka-da-dha-ngatha pirri kardu ngarra manthap-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mu nigunu kardu palngun nhini-ka the kanthin Jesus patha mampatha-yu i nhini-ka wurrininadha warda ngarra nukunu i demnawinhipingkarl kumparra warra. Nigunu-ka denham i kardiwerrerrdha warda. I nhini thangunu-ka murrinh thathpirr warda wurdamnayith. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bere Jesus kathu-ka mamnge, “Nga, nhinhi-ka kardu patha warda manangka matharr thim pana-yu nhini-ka ngarra ngay thangunu murrinh namngabath mamnhiwatha nhini-yu. Mampa-ya, thurru warda marda pekpek wanku nabath thurru i matharr pana-ka kanamnhipart wurdantinumi warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mu bere ngarra nukunu-re Jesus murrinh pirringengerren-da-dha-ngatha-ka kardu nugarn ngamere-ka ngarra thelput nukunu thangunu kathu Jairus-ka parramkaruy-warda-neme wunku murrinh tharrmudharrmu-yu. I pumamnaneme ngarra nukunu Jairus, “Ya. Wakal nhinhi-ka mere warda thurduyemit, ku berengunh. Mu nukunu Pule pana-ka thanipart da tiduk warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mu nukunu Jesus-ka bimpunkumayepupneme kardu pangu-yu ngarra nukunu Jairus pumenadhaneme pe-yu i murrinh mamna warda ngarra Jairus, “Nga, mere thenham nukun. Mu ngarra ngay da matha thurdungayemitnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I nhini thangunu-ka Jesus-ka wurrinidha ngarra thelput Jairus nukunu. I nukunu Peter i piguna James i John kardu perrkenkuneme da matha pangu punnedhaneme ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","I parramkaruyneme ngarra thelput nukunu da Jairus. I Jesus-ka binthepup kardu terert du pardikarrkmardadha. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bere Jesus-ka kanardi ngarra thelput i mampirra ngarra kardu, “Ya. Thangku-nu narnamkarrkmarda-yu i narnamkarrk-yu? Kardu mardinhpuy kanhi kabim-ka mere yungipuptha, mu kardu ngurrnguwarl da matha yibim.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mu kardu kathu-ka mere murrinh pumenabaththa i pangankampa warda ngarra nukunu Jesus-yu. Bere nhini thangunu Jesus-ka kardu yunganpunnurr warda ngarra thelput thangunu kathu-yu. I mampirrukay-warda-ngime yileyile i kalekale i pulangay nukunu perrkenkuneme deyida i parnamkardingime ngarra nigunu da ngarra kardu mardinhpuy nhini yungurrkurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bere Jesus-ka mange ngarra nigunu manganmart i murrinh mamnge ngarra murrinh nukunu-re, murrinh-ka kanhi-wa mamnge-yu, “Talitha kumi,” murrinh kanhi-nu-ya, “Mardinhpuy, thewirnturt kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I nhini thangunu nigunu-ka dempirnturt warda i pirrililidha warda. I kardu terert-ka pumemnamardat ngala da matha. Kardu mardinhpuy nhini-ka nigunu thangku-ka 12-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bere Jesus-ka mampirrungime ngarra kardu wangu-yu, “Nga. Mere nukun nuddirruyithngime ngarra kardu terert-yu mange kanhi thangunu-yu.” I mampirra deyida, “Nga, mi-ka nangemut warda mi pulathnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bere da nhini thangunu-ka nukunu Jesus-ka nungardurr warda da nhini-yu i nadha dini pangu warda wangu i wurdawurl da ngarra nukunu-nu wunku pulangay nukunu deyida wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bere da ngarra Saturday mana-ka Jesus-ka kanardi warda ngarra murrinh church kardu Jews pigunu-yu. I nukunu-ka murrinh ngarra Yile nukunu thangunu wurdininthethiththa dini kardu ngarra terert-yu. I kardu-ka pumemnamardat da matha murrinh ngarra pubimnayepup thangunu-yu, i mange pigunu ngatha murrinh pumenanudha pirrini-ya, “Ya. Kardu kanhi-ka kardu mukmuk ngala da matha. Nangkal wurdiniyethiththa kardi mukmuk ngala kanhi-yu? I ngarra-re mange mam wurran mange patha patha kanhi-yu? Neki kardu mani mere mange pama purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mu nukunu kardu kanhi-ka kardu carpenter da matha nawa? I nukunu-ka wakal Mary nigunu-wa. I ngathan nukunu-ka James, Joses, Judas i Simon-wa. I munak nukunu-ka parnapup deyida da kanhi-yu nawa? Kardu nugarn kanhi-ka mere thathpirr Yile neki wurdithuktha.” Murrinh-ka nhini-wa pumenanudha pirrini-yu ngarra Jesus-nu-yu. I murrinh ngarra nukunu wurdanarrayiththa dini-ka mere warda pumenabaththa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bere Jesus kathu-ka mampirra warda, “Kardu wurnangat warda ngatha pubimnayewup pumpan i murrinh pumamnabath pumpan kardu ngarra murrinh Yile neki nukunu wurdamyith wurran-yu. Mu ngarra da nukunu mana kardu ngarra darrikardu nukunu mana wurdampirrayith-ka nhini-ka mere warda kubinayepup nhini-yu i mere warda murrinh kumanabath nhini-yu ngarra murrinh thathpi nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bere Jesus-ka mere ngarra ngadha mange patha patha merradha wurri da pangu-yu nhini weyida kardu mere pubinanayepuptha puyi i murrinh mere pumenabaththa puyi nhini-yu. Mu kardu matharr-wunngini ngamere da matha menthadhaptha wurrini-yu i menpathadha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bere nukunu-ka mempirramardat da matha kardu nhini kardu darrikardu ngarra nukunu-yu mere murrinh pumenabaththa da pangu-yu ngarra da nukunu-yu. Bere nhini thangunu Kangkarlmawu-ka nawattha dini ngarra da town purrkpurrk manta da ngarra nukunu da i murrinh Yile nukunu thangunu wurdininthethiththa wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I bere pirrimpirrukayneme i panpunkuwerr-warda-neme kardu pulangay nukunu kardu 12 nhini-yu purdunkuthukthuknuneme kardu perrkenku perrkenku-ya. Bere nukunu kathu-ka mampirruneme, “Nga peneme. Ngay-ka lurruth ngala nganarrumutnuneme i bunankupaknuneme ngala deyida wangu, i nhini-ka ku ngepan wiye nirankumaputhnu-warda-neme na ngarra kardu thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I murrinh deyida mampirruneme, “I nga. Ngarra nardurrnemenu-re-ka nanhthi thay ngarra wilili nukunu da matha punankumathaknuneme tharra i numabathnuneme nuru-yu. Mu mi lawam i nanhthi bag i ku mani-ka mere nukun numabathneme nuru. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mu me sandal da matha nubuymerdinuneme-yu i nanhthi kaligu-ka nanhthi pana da matha ngarra nubamkardineme nibimka nhini da matha numabathnuneme nuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","I kardu nangkal ngatha nunamardalenuneme ngarra thelput nukunu-ka nhini da matha nenemenu ngarra thelput pangu da matha ngarra nunardurr-da-nu-mana-neme da numi deyida-nu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Mu da numi nhini-nu ngatha kardu mere nunungkumardalenemenu-ka i mere nangkal murrinh mere binarruyepupnuneme-ka, nhini da ngarra nhini narnepartnemenu-re-ka me sandal nunguynungkumewurrnuneme i putek ngarra me sandal pepe thangunu-ka nuyunungkumerurtulnuneme. I kardu nhini-ka the warda pumabathnu Yile neki-ka mere warda le pirranu nhini-yu, nhini-ka parramnankungkamit-da matha-neme nhini-yu.” Bere nhini thangunu Jesus-ka wurdanpunkuthukthuk-warda-neme kardu perrkenku perrkenku-ya da terert-nu pana-re warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bere peneme 12 nhini-ka da pana ngangka-re punnewatthaneme i murrinh kardu pumerrudhaneme punne, “Nga kardu. Da mange wiye ngarra numammath numpan-ka narnipartnu warda i da mange ngarra Yile neki warda nariwaknu nuru.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","I peneme-ka pirankumapuththaneme punne ku ngepan wiye kardu ngarra terert thangunu kathu. I nanhthi oil pumenkuwarlakthaneme punne ngarra kardu matharr-wunngini terert i pumenkuwathadhaneme punne nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bere kardu pule ngala Hered-ka pamnayepup Jesus i da mange patha patha merradha wurrini nhini-yu. I kardu wurnangat deyida puyemnayepup da mange patha patha nhini-yu. I bere kardu ngamere kathu pumenanudha pardi-ka, murrinh kanhi-wa, “Ya. Nukunu Jesus pana-ka John the Baptist-wa kardu wurdamkabirl deyida. Nhini weyida da mange patha patha pana mam wurran-yu i kardu lurruth ngala pana kurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mu kardu ngamere deyida kathu pumenanudha pardi-ka murrinh kanhi deyida, “Awu, nukunu-ka kardu ngalantharr murntak pana-wa kardu nan Elijah wurdamkabirl deyida. Kardu pana nganaka ngarra murrinh Yile neki nukunu wurdanarrayiththa wurrini.” I kardu ngamere murrinh numi deyida kathu pumenanudha purni-ka murrinh kanhi-wa, “Awu, nukunu-ka ku prophet-wa, mangini ku prophet murntak mani warra pardipuptha i ngarra murrinh Yile neki nukun puddanarrayiththa pardi.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bere nukunu Hered-ka murrinh terert nhini pampirrayepup i murrinh warda mam, “Nukunu pana-ka John the Baptist-wa i kardu-ka wurdamkabirl deyida. Kardu nukunu nhini-ka pana da kardu-yu. Da murntak nhini warra-ka ngarra pelpith nukunu banganthamartal ngay-yu.” Nhini-wa mam nukunu kathu Hered-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Bere da murntak warra-ka kardu pule ngala nhini Hered-ka manganbertnintha ngarra palngun ngathan nukunu nukun Philip. Murrinh nigunu-ka nan-wa Heredias. Bere ngarra da nhini-re nukunu John the Baptist-ka murrinh kanhi kathu mamna ngarra Hered-yu, “Ya. Nhinhi-ka mere neberttha kardu palngun pana-yu. Nigunu-ka kardu palngun ngathan nhinhi nukunu-wa. I nhini-ka da mange wiye-wa nam nhini-yu.” I bere murrinh nhini thangunu nukunu John the Baptist murrinh mamna ngarra Hered-ka, nhini nukunu Hered-ka ku soldier ngarra nukunu wurdanpunkuthukneme nukunu-nu John the Baptist pumabertnemenu i panadhapnemenu ngarra da jail. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bere kardu palngun nhini nan Heredias-ka damnarithi warda ngarra nukunu John the Baptist. I nigunu marda merttha wurrini-ka thu pubatnu i purdurinuminu. Mu nigunu-ka mere ngarra thu puybattha nukunu-yu, nhini-ka nukunu-wa Hered dirrapedha kardi John the Baptist ngarra da jail dinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nukunu Hered-ka denamanhamtha dini ngarra John the Baptist-nu i murrinh nginipunh kanhi-wa marda-re memnu, “Kardu kanhi-ka kardu thathpirr-wa ngarra Yile neki kathu wurdanthuk. I nukunu-ka kardu patha-wa nimin kanhi-yu.” Nukunu Hered-ka le nimin binanayepup kardi-ya murrinh ngarra Yile neki nukun ngarra John the Baptist thangunu kathu wurdananayiththa wurrini-yu. Mu murrinh ngarra nhini ngatha-re binayepup kardi-ka nhini-ka daniwethintha kardi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bere da ngarra birthday nukunu-re Hered pangamnaruy-ka, nukunu-ka kardu warda dimpirrakay mi dhepdhep-nu pullathnu i le patha parninu. I da nhini-re nigunu Heredias-ka murrinh benayengkarnirntha wurrini kanhi-nu mani-wa, “Ngarra kardu terert-te pubengkardurdunu i mi dhepdhep parnimurrknu-ka nhini Hered-ka mange nganathuknu nukunu John the Baptist thu pubatnu-yu.” Bere kardu wurnangat warda ngatha pubemnangkardurdu warda. Kardu-ka kardu nugarn ngarra ku Government thangunu kathu i kardu ku pule ngala ngala ngarra ku soldier thangunu kathu-yu, i kardu pule ngala ngala ngarra da nan Kelili thangunu kathu. I bere kardu terert nhini-ka mi dhepdhep pardimurrktha i le patha wanku pardidha ngarra birthday nukunu Hered dinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bere kardu wakal mardinhpuy nigunu Heredias-ya pangampirraruy ngarra kardu terert nhini-yu. I kardirrapurrktha nanhthi mampurrkinh. I nukunu Hered i kardu pule ngala ngala terert warda ngatha le nimin pirriningedha-ya ngarra nanhthi kardipurrktha nigunu-yu. I nhini Hered kathu-ka mamnge, “Ya. Thangku ngadha nanhthi marda nanganart nhinhi-yu? I nanhthi ngarra marda nartnu-ka nhini nanhthi-ka ngampamutnu warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","I murrinh deyida mamnge, “Murrinh kanhi mampanu-ka murrinh thathpirr-wa. Ngay-ka nanhthi ngampamutnu nanhthi thangidharrpunu ngatha-yu. Nanhthi nhini-ka thangidharrpunu ngatha mampayerrnu nanhthi purrkpurrk ngarra ngay-ya, i ku mani ngarra ngay, i da thelput terert ngarra ngay-ya, nhini nanhthi-ka mampayerrnu i ngampamutnu warda nhini-yu.” Hered kathu-yu mamnge. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bere kardu mardinhpuy nhini-ka yungawuy pangu-re ngarra kale nigunu nan Heredias-ya i mamnge, “Kale, ngarra murrinh mananu ngarra kardu pule ngala pangu-yu? Thangku nanhthi ngadharrpunu-yu?” Dantharrpu nigunu kathu-yu. Mu kalekale kathu-ka mamnge, “Nga. Thadharrpunu pelpith ngarra nukunu John the Baptist badhamartalnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I bere kardu mardinhpuy nhini-ka pirtpirt nimin-ya wurdamnawurl ngarra kardu pule nhini-nu i mamna, “Nga. Ngay marda manganart-ka pelpith ngarra nukunu John the Baptist dadhamartalnu i thangamutnu-yu. I nangabathnu kathu ku pelpith nukunu-yu ngarra nanhthi plate-te marra da matha-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mu ngarra murrinh-te bimngeyepup-ka, nukunu Hered-ka dammardathin warda. Mu nukunu-ka mere ngarra warda “wurda” mengedha nhini-yu. Nhini-ka murrinh thathpi nukunu wardarra damngemut i kardu terert wanku pubimnayepup murrinh ngarra marra-re mamnge-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bere nukunu Hered-ka ku soldier wurdannathuk ngarra John the Baptist-nu i badhamartalnu i purdunangkarlnu pelpith nukunu-yu. Bere ku soldier nhini-ka pangu warda wangu nanadha dini ngarra John the Baptist ngarra da jail dinidha. I nhini-ka banganthamartal warda nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I nhini thangunu ku soldier nhini-ka ku pelpith nukunu John the Baptist-ka ngarra nanhthi plate-te mebaththa tharra. I damngemut ngarra kardu mardinhpuy nhini. I kardu mardinhpuy nhini-ka damngemut warda ngarra kale nigunu kardu nan Heredias. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bere nhini thangunu-ka ngarra pulangay nukunu John the Baptist puyemnayepupneme kardu Pule Hered thangunu John the Baptist banganthamartal-ya, nhini-ka purnenadha-kathu-neme i ku nginipunh nukunu pumangankartneme i pubankardineme ngarra da weyi palyirr da. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bere kardu apostle 12 nhini ngarra Jesus wurdanpunkuthukneme-ka kardu puddanalaththa-warda-kathu-neme ngarra nukunu deyida. I murrinh warda puddamnayithneme murrinh ngarra peneme kathu puddininthethiththa punne ngarra kardu i mange ngarra pumerradha punne-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bere da nhini-re ngarra peneme parramnaruyneme Jesus-ka kardu wurnangat parranirurtuydha pi ngarra Jesus, i nhini peneme i Jesus wanku-ka mere ngarra ngadha mi dhepdhep pulleththaneme kardu wurnangat kathu pumenkumathpuththaneme pardi. I nhini nukunu-ka mampirruneme ngarra pulangay nukunu-yu, “Peneme ka. Purru-warda-neme da ngarra watmam pangu wangu i banankuyuknu-ngadha-neme pi.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bere peneme 12 nhini i Jesus wanku-ka parnamkamardapneme ngarra tharntu i punnadhaneme da ngarra watmam-nu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mu kardu-ka pubampunkungkarduneme peneme nhini-yu ngarra tharntu panganpunkuthenhneme. I kardu terert-ka punniwinhararttha pangu warra kumparra ngarra da dimunurdi purnimardadha purni ngarra Jesus-nu warda wangu nadha dini ngarra tharntu. Kardu-ka wurnangat nimin-ya ngarra da town terert thangunu kathu punniwinhararttha ngarra da watmam pangu-nu warda wangu ngarra Jesus purnedhaneme-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","36","Bere ngarra Jesus nanhthi tharntu thangunu kathu wurdawal-ka, nukunu-ka bampunkardu warda kardu wurnangat nhini-yu ngarra kumparra-dha warra parrarntuy. I nukunu-ka dampirramardathin warda nhini weyida ngangka da pirriningkadhuktha-yu nginipunh ku thip mani ngarra kardu mere nangkal ngadha dirranpedha kani. I nhini nukunu-ka murrinh ngarra Yile neki nukunu warda wurdininthethiththa dini da pirdithme nimin-ya i da-ka kungini da mana pirridha. Bere nhini thangunu pulangay nukunu kathu-ka pumamna-warda-neme, “Pule. Kardu-ka thurdunthuknu warda ngarra thelput manta manta kanhi nimin pumpan-ya mi dhepdhep-nu parnikutkutnu. Da-ka kungini warda kanhi-yu i mi-ka mami-wa kanhi-yu thanamngime.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mu Jesus kathu-ka mampirruneme, “Awu, nankuneme-wa mi dhepdhep narramutnu-yu mi pullathnu kardu kanhi-yu.” Mu peneme kathu-ka pumamnaneme, “Ngankuneme ngatha mi bread ngarnerrakutnu-ka nhini-ka ku mani ngala nimin-ya, ku mangini $2,000 mani-ya peyim nguyemanemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Mu thangku numa mi lawam nanthinkaneme narnam-yu?” Mampirruneme Jesus kathu-yu. “Na-mani-neme pangu i mi mani thangku numa nubangkardunemenu-yu.” Bere peneme-ka purnedha-warda-neme pangu ngarra kardu terert i mi pubangamkardurtneme i puddamnawurlneme ngarra Jesus deyida i pumamnaneme, “Mi-ka 5 mi lawam nganthinkaneme ngarrim-yu i ku ngurlmirl perrkenku wanku,” pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bere nukunu Jesus kathu-ka mampirru-deyida-neme ngarra pulangay nukunu, “Kardu terert warda ngatha numarranu parniwupnu pangu ngarra parnu ngatin i kardu-ka pumeyerryerrnu puyu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bere kardu-ka parnawup warda i nginipunh 50 mani pangu wangu, i nginipunh 50 mani kanhi kathu, i nginipunh 100 mani pangu wangu, i nginipunh 100 mani deyida pangu-re. Mange nginipunh nhini mani-ya kardu pana ngangka-re-yu pumenayerryerrdha purni. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bere Jesus-ka mangankut mi lawam 5 nhini-yu i ku ngurlmirl perrkenku wanku. I kangkarl mamka i ngarra Yile nukunu warda mamna, “Mi i ku kanhi patha-wa thamngarramut-yu.” I bere mi nhini-ka mungarnterrarr i dampirrumutmutneme ngarra pulangay nukunu i peneme nhini-ka ngarra kardu warda parranirramutmuttha purne. I ngana deyida ku ngurlmirl perrkenku deyida mungamparl i mungamparl i kardu warda parranirramutmuttha purne. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mi lawam i ku ngurlmirl nhini-ka Jesus mewathadha pirri-ka mi terert warda nhini-yu i ku ngurlmirl-yu. Kardu wurnangat warda ngatha mi i ku pullamath-yu i kardu-ka bangampunmardan-wa ngarra marda mampunbay mi i ku thangunu pardimurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bere nhini thangunu peneme nhini kardu 12-ka purnekutkutthaneme mi i ku ngarra kardu thangunu parraniritmuttha pirrini. I nanhthi thelerrtherr nanhthi 12-wa pumedhalertertthaneme parde mi i ku titmut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kardu wurnangat warda ngatha kardu nugarn kardu palngun kardu mamay mi i ku pullamath-yu. Kardu nugarn da matha-wa 5,000 pangu pirrinidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bere nhini thangunu-ka nukunu Jesus-ka mampirruneme ngarra pulangay nukunu-yu, “Nga peneme. Nankuneme-ka kumparra wardarra naneme ngamimarda pangu kathu nanhthi tharntu-re da nan-nu Bethsaida.” I bere kardu wurnangat pangu-ka wurdanpunthuk warda da ngarra pigunu warda wangu puddanalaththa. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bere kardu thangunu wurdanpuntharr-ka nukunu Jesus-ka dimmardawith warda ngarra da palyirr i ngarra Yile nukunu warda murrinh wurdananayiththa dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bere da thipinhi nhini-ka kardu peneme 12 nhini-ka ngarra marda nganangurr ngarra ngipilinh punnedhaneme ngarra nanhthi tharntu-re. Mu nukunu Jesus-ka pirridha numerrnu ngarra da pangkin kathu ");
INSERT INTO mwf2018_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","i bampunkungkarduneme pulangay nukunu-yu da tetemanthay pubangamkardurtneme ngarra tharntu-yu puyenangurrukadhaneme punne nanhthi wirrirr thangunu dampunkuwirnteneme parranemardatthaneme punne. Bere da nhini thangunu-ka da manta warda puningkapurldha wurrini-ya nukunu Jesus-ka nungardurr warda da pangkin kathu-yu i wurrinililidha warda ngarra kura ngipilinh kangkarl ngarra pulangay nukunu-nu. Nukunu-ka kardu benkukattha-warda-neme, ");
INSERT INTO mwf2018_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mu peneme-ka pubamkangkarduneme wurrinililidha ngarra kura kangkarl-yu i nhini-ka pardiwapadhaneme ");
INSERT INTO mwf2018_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","i perremkanhamneme ngala da matha i pumamka-mana-wa-neme ku wurdarr wurrinililidha pangu-yu. Mu nukunu Jesus kathu-ka mampirruneme, “Peneme. Kardu thathpirr numenungkuyitneme i mere nengimanhamneme, kardu ngay weyida kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bere ngarra nukunu-re Jesus kanammardap ngarra tharntu-ka nanhthi wirrirr ngala nhini-ka manthap warda. I peneme nhini-ka kardu pumemnamardat-da-thathpirr-neme ");
INSERT INTO mwf2018_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nhini weyida mere the pumebaththaneme nukunu Jesus-yu kardu ngala thathpirr-yu lurruth ngala-yu. I ngana deyida mere the pumemabaththaneme nukunu ngarra-re mange mi pangu danirramutmuttha kardi ngarra kardu wurnangat nhini-yu. Mu mukmuk peneme-ka mampunkurdarrimepu-da-matha-neme mange pangu lurruth ngala ngarra Jesus medha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bere peneme nhini Kangkarlmawu wanku-ka pumpankakathneme ngamimarda kathu ngarra ngipilinh ngala nhini i parramkaruyneme da nan Gennesaret. Bere puddamkalalneme ngarra tharntu thangunu kathu-yu i tharntu-ka pumamkadharrkirrk-warda-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bere ngarra tharntu thangunu parnamkapartneme-ka kardu da nhini thangunu-ka pubamkardu i panganthenh Kangkarlmawu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","I nhini kardu-ka tharra warda punniwinhararttha i kardu matharr-wunngini punninmetkuttha da pana ngangka-re. I ngarra kardu-re puyenanayepuptha ngarra nukunu ngatha Kangkarlmawu dinidha-ka, nhini kardu-ka kardu matharr-wunngini pumenabertidha purni ngarra nukunu da ngarra nanhthi pit pigunu-re kathu pumenamathbaththa purni. ");
INSERT INTO mwf2018_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bere Kangkarlmawu-ka da pana ngangka-re wurriniwattha ngarra da town ngala ngala, da town purrkpurrk i da pana ngarra thelput numi numi wurriningkadhuktha-ya. I kardu-ka bere matha wangu kardu matharr-wunngini-yu panthiwattha purni ngarra Kangkarlmawu-nu-yu i pinganpuwuptha purni ngarra mayern ngala wangu i pumenadha purni ngarra nukunu-yu, “Ya, thurrurralilinu manta pangu ngarra kardu matharr-wunngini i nhini kardu-ka pumanhidhadhapnu puyu ngarra nanhthi kaligu nhinhi.” Bere kardu matharr-wunngini terert-ka pumedhadhaptha pardi nanhthi kaligu nukunu Kangkarlmawu-yu i patha deyida pardidha manangka matharr warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Bere kardu nugarn pana ngarra murrinh law Jews pigunu marda pumerttha punni kardu Pharisees-ya, i kardu nugarn pana deyida ngarra murrinh law Jews pigunu puddininkuyethiththaneme purne-ka kardu bere matha wangu mange ngarra pigunu pumenamapurl da warra ngadha i nhini mana-ka mi warda pulleth nhini-yu. Nhini-wa da mange murntak-yu ngarra ngalantharr murntak thathpirr pigunu-yu puddanpunthethith-yu. I kanhi deyida mi dhepdhep-ka ngarra shop pardikutkut-ka mi pumepurl da warra ngadha i nhini mani-ka mi warda pulleth nhini-yu. Nhini-wa da mange murntak-yu. I ngana deyida nanhthi kap nanhthi pot i nanhthi dish pumepurl punni da mange murntak-ya. I da mange murntak ngamere deyida wanku parraniriwak punni-yu. Bere kardu Pharisees nhini i kardu nugarn pana ngarra murrinh law Jews pigunu puddininthethiththa punni-ka da Jerusalem thangunu kathu punnedhaneme i ngarra Kangkarlmawu puyemnawerr-warda-neme. I pubampunkungkarduneme pulangay nukunu Kangkarlmawu kardu ngamere mi dhepdhep pardemurrkthaneme, mu mange ngarra peneme-ka mere pumenamapurldhaneme da mange ngarra murntak nhini-yu da ngarra mange Jews pigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I bere kardu Pharisees i kardu nugarn nhini ngarra murrinh law Jews pigunu puddininthethiththa punni-ka murrinh warda pumamnaneme ngarra Kangkarlmawu, “Nga. Pulangay nhinhi-ka mi pangu karnamkamurrkneme mu mange ngarra peneme-ka mere pumenamapurldhaneme da mange murntak pana ngarra nekineme-yu. Mu thangku-dha da mange mere kariwakneme kuru da mange murntak ngarra ngalantharr murntak parrannhemutneme-yu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mu Kangkarlmawu kathu-ka mampirruneme ngarra kardu Pharisees i kardu ngamere nhini-yu, “Kardu ngalantharr pana nan Isaiah murrinh thathpirr danirilildha wurrini-yu da murntak warra-ya murrinh ngarra Yile neki nukunu-ya. Nukunu-ka damnankurililneme nankuneme-yu numemkarart-da-matha-neme numpanka-yu ngarra da mange Yile neki nukunu wangu-yu. I kanhi-wa mam murrinh-yu Yile neki thangunu-yu, “‘Kardu kanhi-ka parramngiriparl pumpan ngay-yu ngarra murrinh thathpi pigunu-re-yu, mu ngarra marda pigunu thathpirr-ka mere marda kumangert kuru. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I kardu kanhi-ka parramngiriparl pumpan i pumamngingala pumpan kardu ngathayida-nu murrinh da matha dampunthawinhinhinh kanam. Mu nhini pigunu-ka da mange ngarra kardu thangunu da matha puddanpunthethith pumpan-yu, mu da mange ngarra ngay thathpirr-ka mere kurdunthethith kuru.’ Nhini-wa murrinh Yile neki-yu murrinh ngarra nukunu Isaiah thangunu darntilil-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bere Kangkarlmawu-ka mampirru-deyida-neme, “Nankuneme-ka murrinh kardu ngarra ngalantharr murntak da-dha matha numamkayitneme numpanka-yu, mu murrinh ngarra Yile neki nukunu-ka narnamkapart-da-matha-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nankuneme-ka mange pathanankumaneme yina murrinh ngarra Yile neki nukunu narnamkapirrneme numpanka-yu i murrinh ngarra ngalantharr murntak da matha numamkayitneme numpanka murrinh ngarra parramnarramut-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Nga. Murrinh kanhi nukunu Moses darntilil da murntak warra-ya murrinh ngarra Yile neki nukunu, ‘Yileyile i kalekale nanki-ka murrinh nubirruyewupnungintha nuru i murrinh numarrubathnungintha nuru. Mu kardu nangkal ngatha mere murrinh marrubathnungintha ngarra yileyile i kalekale-ka i murrinh mampunkurdarrithakngintha wurran-ka kardu nhini-ka thu nubatnu nuddurinuminu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mu nankuneme-ka murrinh thirrukduk nuddanpunkuyethithneme numpanka-yu nginipunh murrinh kanhi mani-ya, ‘Kardu nangkal ngatha nanhthi purrkpurrk patha i ku mani kanthin wurran-ka nukunu nhini-ka mere nimin karrumut-thathpirr-ngintha ngarra yileyile i kalekale i mere nimin mankumanpi-thathpirr-ngintha kurru.’ Nhini-ka murrinh nginipunh kanhi nukun-wa marrungintha, ‘Nanhthi purrkpurrk patha ngay i ku mani ngay-ka ngamnamut wardarra ngarra Yile neki. I nhini ngay-ka mere ngarra nganarrumutngintha nanhthi-yu i mere ngarra manankumanpingintha.’ Kanhi-wa murrinh nuddanpunkuyethithneme numpanka-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Mu nhini nankuneme-ka murrinh narnamkapart-warda-neme murrinh ngarra Yile neki nukunu-yu i murrinh ngarra ngalantharr murntak da matha numamkayitneme numpanka-yu. I murrinh thirrukduk ngamere deyida nginipunh nhini mani-wa nuddanpunkuyethithneme numpanka-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bere Kangkarlmawu-ka pirrimpirrakay deyida kardu panpunperr kardu wurnangat. I murrinh warda mampirra, “Kardu, nubingayepup kathu kardu murrinh the thathpirr numabathnu murrinh kanhi ngarra ngay manarranu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kardu-ka mere thathpirr wiye kurru ngarra mi i ku thangunu wurranmurrk-yu, wurda. Mu kardu-ka wiye thathpirr wurran-ka ngarra marda nukunu thangunu kathu i nhini-ka da mange wiye da matha mam wurran-yu i murrinh thathpi wiye wurranngerren-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bere nhini thangunu Kangkarlmawu-ka kanampunpart kardu-yu i ngarra thelput-nu warda wangu nadha dini i kanardi. I pulangay nukunu warda parramkadharrpuneme murrinh pangu ngarra kardu mampirra-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bere Kangkarlmawu kathu-ka mampirruneme, “Nankuneme-ka mere deyida numangimartaneme murrinh pangu medha ngirri-yu? Nankuneme-ka the-wa numabathneme murrinh nhini-yu. Kardu-ka mere thathpirr wiye kurru ngarra mi i ku thangunu wurranmurrk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mi i ku-ka ngarra thathpi wangu kanardi i ngarra kurnthik i yungawuy deyida. Mi i ku-ka ngarra marda wangu-ka mere kariwiye kirra ngarra da mange wiye wangu-yu, wurda,” Kangkarlmawu kathu-yu mampirruneme. Murrinh kanhi thangunu nukunu mam-ya ku i mi terert warda ngatha-ka nhini-ka berengunh purrumurrk warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bere Kangkarlmawu-ka murrinh deyida mampirruneme, “Kardu-ka wiye thathpirr wurran-ka ngarra marda nukunu thathpirr-wa thangunu i nhini-ka mange wiye da matha mam wurran-yu i murrinh thathpi wiye wurranngerren-yu. Mu mi i ku-ka mere kariwiye kirra ngarra marda kardu nukunu-yu, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Da mange wiye ngarra kardu mam wurran-ka nhini-ka ngarra marda nukunu thangunu thathpirr-wa. I nhini-ka da mange wiye warda benthengkarnirn wurran i nhini thangunu-ka da mange nginipunh kanhi mani warda mam wurran-yu. Nukunu-ka da mange mamngerithuk wurran ngarra kardu mardinhpuy-yu. I nanhthi darrarart wurran. I kardu thu panmat wurdantinumi. I da mange mamngerithuk wurran ngarra kardu palngun karnabuy nugarn numi nukun. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","I kardu mawumawu wurran. I kardu dampirrayirrarart wurran. I kardu ningke-ningke wurran. I murrinh mampunnarrithak wurran. I kardu memnungala wurran. I kardu pelpith wiye wurran. I da mange wiye da matha wurran mange da ngarra marda manganart wurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Da mange wiye terert nhini-wa thathpirr kardu-yu ngarra marda nukunu thangunu kathu damnariwiye pirrim-yu,” Kangkarlmawu kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bere nhini thangunu Kangkarlmawu-ka nungardurr warda i nadha dini da manta pangu da nan-nu Tyre i Sidon. Bere nukunu-ka wurrinidha ngarra thelput warda kanardi dinidha. Nukunu-ka kardu menkangaththa mana-wa, mu wurda. Kardu wurdammay mere ngarra menkangaththa. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kardu palngun deyida pamnayepup ngarra nukunu dinidha-yu ngarra thelput pana-yu. Nigunu-ka kardu mere Jews, mu da nigunu-ka da-ka Phoenicia-wa kardipuptha-yu. I nigunu-ka kardu mardinhpuy wakal mebertidha kardi ku ngepan wiye wanku kanamnginirdi kardu ngarra mardinhpuy nhini-yu. Bere nigunu kardu palngun nhini-ka nanadha dini ngarra Jesus-nu warda. I pangamnaruy da mana i bamnabat ngarra putek ngarra nukunu-nu. I murrinh warda mamna, “Pule. Thirramaputhnu ku ngepan wiye pangu ngarra wakal ngay.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mu Jesus kathu-ka mamnge, “Ngay-ka kardu ngarra darrikardu ngay warra ngadha manmanpinu kumparra-yu kardu Jews-ya. Mu nhinhi i kardu darrikardu nhinhi ngatha manmanpinu warra ngadha ngurru-ka nhini-ka nginipunh mi dhepdhep ngarra kardu mamay pigunu deyida mani ngarra ku were ngarramutnu. I nhini-ka mange mere yuthpan thathpirr nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Yu, bere-ya pule,” nigunu kathu-yu mamna. “Mu ku were ngatha yida mi pumpanmurrk mi perrenimpurr pumpan kardu mamay thangunu-yu. Mu nhini-ka nangimanpi kunungingki da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","I bere Jesus kathu-ka mamnge, “Murrinh pana ngarra namnga-ka yuthpan-wa i nhini-ka ku ngepan wiye pangu-ka kanampart warda ngarra wakal nhinhi-yu. Mu bere nhinhi-ka thurdiwurlnu warda ngarra da nhinhi wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bere kardu palngun nhini-ka wurdawurl warda i bangarnurt wakal nigunu watmam yungurrkurrktha ngarra da pit. I ku ngepan wiye nhini-ka kanampart warda. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bere nhini thangunu Kangkarlmawu-ka nungardurr da nhini thangunu Tyre-yu i nadha dini da ngarra nan-nu warda wangu Sidon. I puy deyida wangu nadha dini ngarra ngipilinh ngala da nan Kelili. I nadha dini da ngarra town da 10, da-ka nan-wa Decapolis. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bere da nhini da Decapolis kardu ngamere kathu kardu nugarn pumenabertidha purni ngarra Kangkarlmawu-nu. I kardu nugarn nhini-ka kardu the wiye kardidha mere binayewuptha kani i themen wiye mere thathpirr kaningerrentha. Bere kardu ngamere nhini da ngatha pumemnarlupurl ngarra Kangkarlmawu i pumamna, “Pule. Kardu kanhi-ka nayethapnu ngarra the i ngarra themen nadhanmethapnu i nawathanu patha deyida paninu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bere Kangkarlmawu i kardu nugarn nhini-ka mebertidha wurrini pangu wangu kardu mange penintha wurrinininthadha. Bere Kangkarlmawu-ka mange perrkenku kanantherdi ngarra the nukunu kardu nhini. I nhini thangunu-ka thade kanamnumabe ngarra mange i manthanmethap ngarra themen wiye kardu nhini. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I nhini thangunu nukunu-ka kangkarl mamka i ngirtkirt ngadha wurdammardaputh i mamna ngarra kardu nhini-yu murrinh nukunu-re, “Yepata.” Nhini-ka murrinh kanhi-nu-ya, “Bang thirraye.” ");
INSERT INTO mwf2018_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I bere da nhini thangunu-ka the nukunu kardu nhini-ka bang pirrinthe warda nhini-yu. I themen wangu patha warda pirringerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bere Kangkarlmawu i kardu nugarn nhini-ka wurdamninthawurl ngarra kardu ngamere nhini-yu. I Kangkarlmawu kathu-ka murrinh warda merradha wurrini, “Ya kardu. Kardu-ka mere nukun numarra kardu kanhi mampatha-yu.” Mu kardu ngamere nhini-ka murrinh parrininthelerrdha weyida purni nhini-yu ngarra kardu wurnangat-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I bere kardu wurnangat nhini ngarra puyemnayepup kardu nugarn nhini mampatha-ka kardu warda pumemnamardat nhini ngarra Kangkarlmawu-yu i murrinh pumenanudha purni, “Ya. Mange ngarra nukunu mam wurran-ka mange patha da matha. Nukunu-ka kardu the wiye ngatha yida mampunpatha wurran i kardu themen wiye ngatha yida mampunpatha wurran.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bere nhini thangunu-ka kardu wurnangat ngala deyida pubemnangkardurdu ngarra Jesus. I kardu-ka mi-ka mami-wa. Bere nukunu Jesus-ka pirrimpirrukayneme kardu pulangay nukunu i mampirruneme, ");
INSERT INTO mwf2018_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Peneme. Ngay-ka damngimpirramardathin kardu wurnangat kanhi-nu. Kardu pardidha-ka da perrkenkuneme-wa ngarra ngay-yu i mi-ka mami warda parnam. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mu kardu kanhi ngatha ngurdunthuknu warda marra kanhi ngarra medeyi wanku parnam-ka nhini-ka kubuywath nukun warda kuru i mankarr nukun warda nhini-yu. Kardu ngamere-ka da wilili ngathparr purunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bere pulangay nukunu Kangkarlmawu-ka pumamnaneme, “Pule. Da kanhi-ka da mi mamirdarri-wa thanthinpun terert thanam. Mu ngarra-wa mi lawam panikutnuneme-yu kardu wurnangat kanhi parrumutnuneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mu Kangkarlmawu kathu-ka mampirruneme, “Mi-ka thangku numa mi lawam nanthinkaneme nirrimka-yu?” “Mi-ka 7-wa nhini-yu,” peneme kathu pumamnaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bere nukunu Kangkarlmawu-ka mampirra kardu ngarra wurnangat-yu, “Kardu nga. Narniwup mani ngarra putek.” Bere kardu-ka parnawup i nukunu-ka mi 7 nhini-ka mangankut i Yile nukunu darntiparl mi nhini-nu-yu. I bere nukunu-ka mi mungarnterrarr i dampirrumutmut-warda-neme ngarra pulangay nukunu. I peneme nhini-ka mi warda parranirramutmutthaneme pardi ngarra kardu wurnangat wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","I peneme nhini-ka ku ngurlmirl purrkpurrk deyida wanku panthidhaneme pirrine. I Kangkarlmawu-ka ku nhini mangankut i Yile nukunu deyida darntiparl ku nhini-nu-yu. I ngarra pulangay nukunu warda dampirrumutmutneme i mampirruneme, “Nga peneme. Ku ngurlmirl kanhi-ka narramutmut-deyida-nuneme nuru ngarra kardu wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mi lawam i ku ngurlmirl nhini-ka Kangkarlmawu mewathadha pirri-ka mi i ku terert warda nhini-yu. I kardu wurnangat ku i mi nhini pullamath-ka mampunmay i bangampunmardan warda nhini-yu. Kardu-ka kardu wurnangat nimin-ya mi i ku pullamath-yu 4,000-wa kardu nhini-yu. I bere mi i ku thangunu pullamath-ka peneme nhini-ka pardekutthaneme purne mi i ku ngarra parraniritmut thangunu pardi. I mi i ku nhini thangunu-ka pumedhaletetthaneme purne-ka nanhthi-ka 7-wa thelerrtherr-yu, nanhthi-ka ngala ngala nimin-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bere nhini thangunu Kangkarlmawu-ka kardu warda wurdanpunthuk. I kanammardap ngarra tharntu pulangay nukunu wanku. I pumpankardurrneme i puy punnedhaneme da ngamimarda-nu kathu da nan-nu Dalmanutha. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bere da nhini thangunu kardu Pharisees ngamere deyida purnenadhaneme ngarra Kangkarlmawu-nu. I parranedharrpudhaneme pe da mange pubuythaptha-mana-wa-neme ngarra Kangkarlmawu-nu. I murrinh pumamnaneme, “Ya. Da mange ngala mani nangarruneme nanhthi lurruth ngala ngarra Yile neki thangunu kathu-yu. I nhini ngankuneme-ka the warda ngumanhibathnemenu nukunu da thathpirr wurdannhithuk kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bere Kangkarlmawu-ka wurdammardaputh i mampirruneme, “Thangku-nu nankuneme-yu i kardu wurnangat warda ngatha narramngidharrpu narnam da mange ngala ngamanu-yu ngarra nanhthi lurruth ngala ngarra Yile neki thangunu kathu-yu? Mu ngay-ka mere ngama nukun da mange ngala nanki-nu-yu nubangkardunu-yu. Kanhi-ka murrinh thathpirr-wa,” nukunu kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bere nhini thangunu Kangkarlmawu-ka kanampunpart warda kardu-yu i kanammardap deyida ngarra tharntu wunku pulangay nukunu wanku. I purnedhaneme da ngamimarda-nu kathu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bere Kangkarlmawu i pulangay nukunu-ka puy purnedhaneme. Mu pulangay nukunu-ka mi lawam puyemkayekumneme mere pumebaththaneme mi terert-yu. Mu mi numi da matha pumebaththaneme purne-yu ngarra tharntu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bere Jesus kathu-ka murrinh mampunkumardawerrneme i mampirruneme, “Nga peneme. Thawath wangu nururranemenu nanhthi turlururlumam ngarra kardu pana Pharisees peneme-ya kardu ngarra murrinh law nekineme marda pumangankartneme pumpan. I ngana deyida thawath wangu nanuneme nanhthi turlururlumam ngarra kardu pule ngala nhini nukunu Hered-ya,” mampirruneme Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bere peneme nhini-ka murrinh warda puddanayiththaneme pirrine i pumenanudhaneme pirrine mange peneme ngatha, “Murrinh kanhi mannheneme-ka mi lawam-nu kama mere thumebaththaneme mi thanthekum-da-matha-neme.” Mu peneme nhini-ka mere thathpirr pumemartadhaneme murrinh ngarra Jesus mampirruneme ngarra nanhthi turlururlumam kardu Pharisees peneme-ya i ngarra kardu pule ngala Hered nukunu-ya. Mu Jesus murrinh nhini mampunkurdarrathneme nanhthi turlururlumam-ka ngarra kardu Pharisees-ya murrinh kanhi-nu mam-yu da murrinh parrampunpinhingkayit pumpan da ngarra mange wiye wangu. I nanhthi turlururlumam pana deyida ngarra kardu pule ngala Hered-ka murrinh kanhi-nu mam-yu da murrinh dampunpinhingkayit wurran da ngarra mange wiye wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bere Jesus-ka the-wa mebaththa dini ngarra murrinh peneme puddanayiththaneme pirrine mange peneme ngatha-yu. I bere mampirruneme, “Ya. Thangku-nu nuddamkayithneme nirrimka-yu mi lawam mami numamkaneme i mi nuyemkayekumneme-yu? Murrinh-ka mere da ngatha numangimartaneme murrinh ngarra mamnarruneme-yu? Nankuneme-ka murrinh mere da ngatha the numabathneme, na? ");
INSERT INTO mwf2018_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kardu nankuneme-ka kamarl wanku nanthinkaneme numpanka mu kardu-ka mere thathpirr nubangkarduneme. I nankuneme-ka the perrkenku wanku nanthinkaneme numpanka, mu kardu-ka murrinh-ka mere thathpirr nubingayewupneme nuru. Mu nga. Nuddingayerr-mani-neme ");
INSERT INTO mwf2018_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ngarra mi munirerrarrdha ngirri mi lawam 5 nhini-yu i ngampirramut kardu wurnangat pangu-yu kardu nugarn 5,000-wa. I thangku numa-wa nanhthi thelelerr numedhalertertthaneme nurne-yu mi parriniritmut thangunu-yu da nhini-re-yu?” I peneme kathu-ka pumamnaneme, “Mi-ka nanhthi thelelerr 12-wa da nhini-re-yu ngumedhalertertthaneme ngurne-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","I bere Jesus kathu-ka murrinh deyida mampirruneme, “I ngana deyida mi nhini-re-yu nganaka munirerrarrdha ngirri mi lawam 7 nhini-yu i ngampirramut kardu wurnangat pangu kardu 4,000-ya. I thangku numa deyida nhini-yu nanhthi thelelerr numedhalertertthaneme nurne-yu mi parriniritmut thangunu-yu?” Dampunkudharrpuneme. I peneme kathu-ka pumamnaneme, “Mi-ka nanhthi thelelerr 7-wa da nhini-re-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","I bere nukunu Jesus-ka dampunkudharrpuneme i mampirru-deyida-neme, “Nga peneme. Nankuneme-ka murrinh mere da ngatha numangimartaneme narne, nawa?” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bere Kangkarlmawu i kardu pulangay nukunu-ka parramkaruyneme da ngamimarda kathu-yu da nan Bethsaida nanhthi tharntu-re. Bere da nhini da kardu kamarrama pumenabertidha purni ngarra Kangkarlmawu-nu i murrinh pumamna, “Pule. Kardu kamarrama kanhi-ka nangkathapnu kamarl nukunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bere Kangkarlmawu-ka manganmert nukunu nhini-yu i mebertidha wurrini da ngathparr tharrngini wangu ngarra kardu makardu. I bere nanhthi thade menthanmethap ngarra Kangkarlmawu kathu-yu i mamkathap nanhthi thade-re nhini-yu ngarra kamarl nukunu. I mamna warda kardu ngarra kamarrama nhini-yu, “Kardu-ka ngarra nam thirrim nhinhi-yu? Kardu-ka patha warda thirrimmirlbirl?” Jesus kathu-yu dantharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I bere nukunu nhini-ka kardu wurrinibirlbirldha warda i murrinh warda mamna ngarra Kangkarlmawu, “Yu, kardu-ka berengunh bampunkardu ngarrim, mu ngawuy da ngatha ngarrim i nginipunh nanhthi thay da ngatha kardu-yu parnalili.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I ngana deyida Kangkarlmawu-ka mamkathap deyida ngarra kamarl nukunu-yu. I ngana deyida birlbirl pirrim i nhini thathpirr warda tarangka pirribirlbirldha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bere Kangkarlmawu-ka wurdanthuk warda kardu nhini-yu. I mamna, “Nga. Thurdiwurlnu warda da ngarra nhinhi wangu, mu mere nukun thurdiwurl da Bethsaida wangu ngarra kardu karrimkadhuk-yu,” nukunu kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bere nhini thangunu-ka nukunu Jesus i pulangay nukunu-ka punnewatthaneme da pana-re-ya da town purrkpurrk ngarra da ngala nan-ya Sesariya Filipi. Bere ngarra punnelili-re-neme nukunu Jesus-ka dampunkudharrpuneme kardu pulangay nukunu i mampirruneme, “Ya peneme. Ngay-ka nangkal mana-wa kardu-yu murrinh pumamnga pumpan-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","I peneme kathu-ka pumamnaneme, “Kardu ngamere pumampa pumpan-ka John the Baptist mana-wa. I kardu ngamere deyida pumampa pumpan-ka kardu nan mana-wa Elijah kardu thurdamkabirl deyida. I kardu ngamere deyida pumampa pumpan-ka kardu ngalantharr murntak mana-wa murrinh ngarra Yile neki nukunu wurdanarrayiththa wurrini i kardu thurdamkabirl deyida.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bere Jesus-ka dampunkudharrpu-deyida-neme i mampirruneme ngarra pulangay nukunu, “Mu nankuneme ngay-ka nangkal mana-wa thathpirr numamnganeme numpanka-yu?” I bere nukunu kathu Peter-ka danthart i mamna, “Nhinhi-ka Christ-wa, kardu ngarra Yile neki mam purduthuknu da murntak warra-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mu Jesus kathu-ka mampirruneme, “Kardu mere nangkal nukun murrinh numananeme ngay da kardu-yu Christ-yu i Yile ngay wurdanngithuk-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bere nhini thangunu nukunu Jesus-ka murrinh warda pantet wurdininkuyethiththaneme wurrini da murrinh ngarra mange nukunu ngatha-ya. I mampirruneme ngarra pulangay nukunu, “Nga. Ngay kardu darrikardu nanki thathpirr-ka da nakurlnu pumangirtanu i thu pungithuknu puru i thu pangilurturtnu purru ngay kardu nhini thangunu-yu kardu ngalantharr ngalantharr-ya i ku yilarn ngala ngala i kardu pana ngarra murrinh law nekineme puddanpunthethith pumpan-yu. I kardu nhini-ka mere murrinh pumangabathnu ngarra ngay-yu. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu. Mu da perrkenkuneme mana pamanu-ka ngurdingkabirl-deyida-nu,” nukunu kathu-yu Jesus mampirruneme-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","murrinh tarangka thathpirr wurdanpunkuyethithneme-yu. Mu nukunu Peter-ka manganmert Jesus pangu wangu kunungingki murrinh mange penintha-nu. I bere Peter kathu-ka mamna ngarra Jesus, “Ya. Pirda-wa murrinh nhini-yu. Mere murrinh nhini thama thurru. Kardu-ka mere kunhibat nukun-ya, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mu Jesus-ka wurdarduy pirrim i wurdanpunkuyithneme ngarra kardu pulangay nukunu wangu-yu. I bere nungamnamardawal warda ngarra Peter i mamna, “Murrinh ngarra nhinhi thurranngerren-ka murrinh ngarra ku karrath thangunu kathu-wa. Nukunu da ku-yu ngarra ngay mamngirullul wurran-yu. Nhinhi-ka denthengkarnirn thurran-ka nginipunh kardu mani-wa mu mange ngarra Yile ngay nukunu-ka mere deyengkarnirn thani, wurda.” I Jesus kathu-ka mamna ngarra ku karrath, “Ku karrath, pata thurru-wa, thaningipart warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bere nhini thangunu-ka nukunu Jesus-ka kardu warda pirrimpirrakay kardu wurnangat-yu. I bere kardu-ka pubemnangkardurdu i pulangay nukunu wanku. Bere Jesus kathu-ka mampirra, “Nga. Kardu nangkal ngatha kardu pulangay ngay purrunu i pangilerrnu-ka, nhini nukunu-ka puynuyekum-wa-nu i panipartnu warda da ngarra mange nukunu marda manganart wurran-yu. I kardu ngatha yida thu puthuknu puru i palurturtnu purru i thu pubatnu nginipunh ngay deyida mani pumanganu puru nhini kardu nhini-ka mangirart-da-nu-matha purru ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Mu kardu nangkal ngatha marda mart menuyibirnunu i da mange ngarra nukunu da matha pamanu purru, nhini nukunu-ka pupup da matha-nu nhini-yu. Mu kardu nangkal ngatha puynuyekumnu thathpirr-ka i murrinh ngarra ngay panthelerrnu purru i mangirart-da-nu-matha purru, nhini nukunu-ka kardu bere matha wangu birnu paninu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“I ngana deyida kardu ngatha bemnuyengkarnirn kanam ngarra nukunu-nu ngatha i nanhthi purrkpurrk terert nimin bemmardarr wurran, nhini-ka patha-wa-nu nukunu-nu-yu? Awu wurda da matha. Mu ngarra nukunu nhini-re pupupnu-ka nanhthi purrkpurrk nhini-ka mere ngarra kumayibirnu nukun da bere matha wangu birnu paninu-yu, wurda da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","I kardu-re pupupnu-ka mere deyida ngarra kurdingkabirl mange nukunu ngatha-yu. I nanhthi purrkpurrk nhini deyida mani wanku mere ngarra kuddungkabirl nukunu kardu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","I nukunu Jesus-ka murrinh deyida mampirra, “Kardu wurnangat-wa da mange wiye da matha pumpan da pana ngangka-re. I kardu nhini-ka parnampart warda Yile ngay-yu. I nga. Kardu nangkal ngatha yidiwe kurrunga i murrinh thathpi ngarra ngay yidi marradhay kurru ngarra kardu, nhini ngay kardu darrikardu nanki thathpirr-ka yidiwe ngurrunanu ngarra kardu nhini-yu da nakurlnu da nhini-re-ya ngarra ngay ngurru-deyida-nu kathu wunku lurruth ngala wanku ngarra Yile ngay thangunu kathu i ku angel terert deyida wanku.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","I Jesus-ka murrinh deyida mampirra, “Nga. Murrinh thathpirr-wa kanhi-yu. Kardu ngamere nibim kanhi-ka mere da ngatha nuyuwuwupnu mu da ngarra nubangkardu-da-nu-mana Yile ngay ku Pule ngala thathpirr pirranu kardu ngarra nukunu-yu wunku nanhthi lurruth ngala wanku.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bere da 6 mana mam-ka nukunu Jesus-ka menkubertidhaneme tharra nukunu Peter, James i John. I kanthinpunkumardawithneme ngarra da palyirr kangkarl thathpirr-ya numidharrwunku-da-matha-neme nukun mange peneme da matha. Bere da palyirr kangkarl nhini da ngatha peneme-ka pubamkangkarduneme nukunu Jesus-ka kamarl ngarra nginipunh nukunu-ka wurdamnungkath warda. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","I nanhthi kaligu nukunu ngarra banardidha wurrini-ka wurdannath nanhthi damlarrang bamam thathpirr. Kardu mere nangkal pana ngangka mapurl mani nanhthi kaligu bamam nginipunh nhini mani-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bere nhini thangunu peneme nhini-ka pubamkangkardu-deyida-neme kardu ngalantharr murntak nan Elijah i Moses puddananayiththanintha pe ngarra Jesus wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bere nukunu Peter kathu-ka mamna ngarra Jesus, “Pule, da patha-ya patha da mange kanhi-yu ngarra nekineme thanamneme kanhi-yu. Ngankuneme-ka nanhthi wuwup ngawupnemenu nanhthi perrkenkuneme. Nanhthi numi nhinhi-nu nanhthi numi nukunu Elijah-nu i nanhthi numi nukunu Moses-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nukunu Peter murrinh kanhi mam-ka murrinh derntereth-wa. Peneme nhini-ka pununkungkawerrdhaneme kardi. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bere nanhthi kalakkalak wurrinidha kathu nhini thangunu-yu i dampunkurdarrupneme Jesus i penintha Moses I Elijah. I murrinh ngerren warda pubimkayepupneme ngarra kalakkalak kathu-yu, i murrinh kanhi-wa mampirruneme-yu, “Ya. Kardu nugarn kanhi karrim-ka kardu wakal ngay-wa. I ngay-ka marda-wa thathpirr manganart ngurran nukunu-yu. I nankuneme-ka nubinayepup-da-matha-neme nuru nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bere peneme nhini-ka yerrarr pumamkangkaneme, mu pubamkangkarduneme-ka nukunu da matha Jesus numidharrnu pirridha ngarra peneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bere da ngarra palyirr nhini thangunu kathu puddanathut-da-ngatha-neme punne-ka Jesus kathu-ka mampirruneme, “Nga peneme. Kardu mere nangkal nukun nuddunayithneme da mange kanhi thangunu nubamkangkarduneme-yu mu ngarra ngay da mana ngurdingkabirl-deyida-nu kardu ngay-ya darrikardu nanki thathpirr-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I bere peneme nhini-ka murrinh warda pumamnabathneme ngarra Jesus, mu mange murrinh peneme pumenungkudhaneme punne, “Thangku nukunu murrinh Jesus mam-yu kardu purdingkabirl-deyida-nu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","I peneme kathu-ka ngarra Jesus pumamnaneme, “Nga. Kardu nugarn pana nganaka, kardu ngarra murrinh law nekineme puddanpunthethith pumpan-yu, kardu nhini-wa murrinh pamam pumpan-ya, ‘Nukunu Elijah-ka kumparra warra-wa pununu pi da kanhi-yu. I kardu nugarn pana ngarra Yile neki purduthuknu-ka tiduk-wa kathu pununu pi da kanhi-yu.’ Kardu-ka nhini-wa murrinh pamam pumpan-yu. Thangku-nu murrinh nhini pamam pumpan-yu?” Peneme kathu parramkadharrpuneme ngarra Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","I Jesus kathu-ka mampirruneme, “Yu, murrinh thathpirr nhini-yu,” mampirruneme. “Nukunu Elijah-ka kumparra warra-wa pununu pi da kanhi-yu i kardu-nu bunyithithnu purru. Mu murrinh kanhi manarruneme-ka nukunu Elijah-ka berengunh wardarra wurrinidha da kanhi-yu. I kardu-ka mange mere patha punninadha i pumpanmat puddantinumi nukunu-yu. I nginipunh nhini deyida mani-ka murrinh ngarra Yile ngay mam-ka ngay deyida wanku mange mere patha purunganu-yu i mere murrinh pumangabathnu murrinh ngarra ngay-yu, kardu ngay-ya darrikardu ngarra nanki thathpirr-yu. I murrinh ngarra Yile ngay yudha-ka murrinh da thathpirr ngarra kardu-re thu pumpanmat thangunu nukunu Elijah-yu,” nukunu Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bere Kangkarlmawu i pulangay ngamere nukunu-ka puddamkathutneme ngarra da palyirr kangkarl thangunu kathu. I purnerrudhaneme ngarra pulangay ngamere nukunu-nu. I pubampunkungkarduneme kardu wurnangat puyempirruwerrneme ngarra peneme nhini-yu. I kardu nugarn ngamere murrinh law kardu Jews pigunu puddininthethiththa punni-ka murrinh thu kuy pumampirrungkaneme ngarra pulangay ngamere nukunu Kangkarlmawu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bere ngarra kardu wurnangat nhini mana pubamkardu Kangkarlmawu-ka kardu-ka pubemkabat ngala da matha i punnungamnawinhat ngarra nukunu-nu i le warda pinadha ngarra pubamkardu thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mu Kangkarlmawu-ka dampunkudharrpuneme ngarra pulangay nukunu-yu i mampirruneme, “Thangku-wa murrinh thu kuy pana-yu nardedhaneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mu kardu nugarn numi pirrimnangeng ngarra kardu wurnangat kathu i mamna ngarra Kangkarlmawu, “Pule, wakal nugarn ngay mempabertidha ngurrini ngarra nhinhi-nu patha nawathanu. Nukunu-ka ku ngepan wiye kanthin wurran i mere kaningerren warda murrinh-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","I ku ngepan wiye mana warda mangarnta-ka nhini-ka wurdarntururt warda kanam nhini-yu i nhini-ka mantharryirr warda kanam nanhthi thurrulk ngarra thathpi i dimu damlirr kanam i parnte kanam ngarra nginipunh ngala kanhi wangu. Mu ngay-ka ngampunkudharrpuneme ngarra pulangay nhinhi ku ngepan wiye nhini punnimakudha-mana-neme, mu wurda puddamnabay-da-matha-neme.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mu Kangkarlmawu kathu-ka mampirra ngarra kardu wurnangat-yu, “Nanki-ka murrinh-ka nubimngayewup numpan murrinh ngarra ngay-yu mu murrinh-ka mere thathpirr numangabath nuru. Da pirdithme da matha murrinh ngurdininanthethiththa ngardi, mu murrinh-ka nanki-ka mere da ngatha numangabath nuru murrinh ngarra thathpi ngay-yu. Ngarra-wa diki murrinh ngay ngurdinanthethithnu ngani-yu i murrinh numangabathnu thathpirr-yu? Kardu kathu numangabert kardu kigay pana,” Kangkarlmawu kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bere kardu kigay nhini-ka pumenabertidha punni ngarra Kangkarlmawu-nu. Bere ku ngepan wiye mana bamkardu Kangkarlmawu-ka nhini kardu kigay nhini-ka wurdarnturt i bammat warda i bunirangkaltangkaldha wurrini i wurdanarlerlerldha kardi ngarra putek kardithurrulkthaydha ngarra thathpi nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mu Kangkarlmawu kathu-ka dantharrpu ngarra yile nukunu-yu i mamna, “Ya. Thangku numa da thangku-yu ku ngepan wiye mebaththa wurrini-yu?” I yileyile kathu-ka mamna, “Kardu mamay-re kathu wurrinidha ku ngepan wiye kanhi kanthidha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","I da terert da matha ku ngepan wiye-re kanamputhputh-yu ngarra thungku-ya i ngarra kura ngipilinh wangu-ya kardu purdurinuminu-mana-wa pubatnu. Mu nhinhi kama-ya kardu kigay kanhi nawathanu-yu. Nhinhi-ka panhingarrumardathinnungintha ngankungintha-nu i patha warda nangarruwathanungintha.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","I Jesus kathu-ka mamna, “Murrinh ngarra-nu namnga pana-yu ngay mawathanu kama-ya? Mu nhinhi murrinh ngatha nangabathnu mawathanu-wa nhini ngay-ka mawathanu warda nhini-yu. Kardu nangkal ngatha murrinh mangabathnu thathpirr-ka nhini ngay-ka mange ngama da thathpirr nhini-yu ngarra kangidharrpu thangunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bere yile nukunu kathu kardu kigay nhini-ka murrinh lurruth warda pirrimngeng i mamna, “Nga. Ngay-ka murrinh thathpirr mampabath wakal ngay nawathanu patha deyida-yu. Nangimanpinu thurru ngay-yu kardu bere matha wangu murrinh thathpirr mampabathnu ngurru.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bere Jesus-ka bampunkardu kardu puyenanawerrdha warda punni ngarra nukunu manta i nhini-ka murrinh warda mamna ngarra ku ngepan wiye nhini-yu, “Ya. Ku ngepan wiye. Nhinhi-ka the nukunu nanthekum i themen nukunu nanthapnintha. Mu thungiwuy warda kathu ngarra kardu kigay pana-yu i mere deyida thaninginirdi nukun ngarra nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I ku ngepan wiye nhini-ka kardiwapadha warda i bunirangkaltangkaldha kardi ngala da matha i nhini-ka kanampart warda i yungawuy warda ku ngepan wiye nhini-yu ngarra kardu kigay nhini thangunu kathu-yu. I kardu kigay nhini-ka parnte ngadha yungurrkurrktha nginipunh ku yibimpup deyida mani. Mu kardu wurnangat kathu-ka pamam, “Ya. Kardu kigay kanhi-ka yibimpup warda, nawa?” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mu Jesus-ka mange ngarra nukunu kardu kigay nhini manganmart i dampirnturt i pirridha warda kardu kigay nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bere nhini thangunu-ka Jesus-ka wurdawurl deyida ngarra thelput i kanardi. I ngarra kardu wurnangat mana puddalath pangu wangu ngarra thelput-ka, pulangay nukunu Jesus-ka murrinh warda pumamnaneme, “Thangku-dha ngankuneme-yu mere ngunnemakudhaneme nguddamnabayneme ku ngepan wiye nhini ngarra kardu kigay pangu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","I Jesus kathu-ka mampirruneme, “Yile ngay warra ngadha nerradharrpudhaneme i nhini-ka nunnemakudha-warda-neme nhini-yu, ku ngepan wiye nginipunh nhini mani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bere nhini thangunu-ka Kangkarlmawu i pulangay nukunu-ka punnungamkardurr-warda-neme da nhini thangunu-yu i yuthpan da matha punnedhaneme da Kelili-nu-yu. Nhini Kangkarlmawu-ka mere ngadha marda merttha wurri kardu-nu puyunawerrnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bere Jesus-ka wurdinkuyethiththaneme wurrini kardu pulangay nukunu da-nu matha. I bere murrinh-ka kanhi-wa mampirruneme-yu, “Nga. Ngay kardu ngarra darrikardu nanki thathpirr-ka pumangirtanu i pumangibertinu puru kardu ngarra pule ngala ngala-nu. I nhini thangunu-ka thu pungibatnu i puddungirinuminu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mu pulangay nukunu Jesus-ka mere pumemartadhaneme ngarra murrinh nhini mampirruneme-yu. I mere ngarra ngadha perradharrpudhaneme murrinh wurdirruriyiththaneme-yu nhini-ka perremkamanham-weyida-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bere Kangkarlmawu i pulangay nukunu-ka pangu warda wangu purnedhaneme i parramkaruyneme da ngarra nan Capernaum da. I ngarra thelput warda parnamkardineme. Bere Kangkarlmawu kathu-ka dampunkudharrpuneme i mampirruneme, “Ya peneme. Thangku murrinh nankuneme-yu nuddanadharlurldhaneme nurne-yu ngarra mayern thurrinililidhaneme kanhi kathu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mu peneme-ka mere perredhartthaneme manangka murrinh, nhini thangunu weyida murrinh mange peneme puddanadharlurldhaneme purne kardu nangkal nimin-nu peneme ngatha-yu kardu pule ngala-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bere Kangkarlmawu-ka kanawup warda i murrinh mampirruneme kardu ngarra pulangay nukunu kardu 12 nhini, “Peneme. Kagu manta kathu,” mampirruneme. “Nga. Kardu nangkal ngatha marda mart kardu pule ngala purrunu-ka nhini nukunu-ka kardu kunungingki buynupaknu i kardu terert da matha manmanpinu purru,” nukunu kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bere nhini thangunu Kangkarlmawu-ka manganmert kardu mamay kumparra pangu warra ngarra peneme i bamnungurrupak warda ngarra nukunu i panthamayirrikat. I mampirru-deyida-neme, ");
INSERT INTO mwf2018_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nga. Kardu nangkal ngatha mardarrilenu kardu mamay nginipunh kanhi mani karrim-ka nhini kardu-ka ngay deyida wanku mangirdarrilenu nhini-yu. I ngana deyida kardu nangkal ngatha mangirdarrilenu ngay-nu-ka nhini nukunu-ka mardarrile-deyida-nu thathpirr ngarra Yile ngay-yu nukunu pana ngarra wurdanngithuk-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bere nukunu John kathu-ka mamna ngarra Jesus, “Pule. Ngankuneme-ka ngubamkangkarduneme kardu nugarn numi kardinmawuthpuththa ku ngepan wiye ngarra kardu thangunu ngarra murrinh nhinhi menhirdarrinedha kardi. Mu ngankuneme-ka ngubuymadhaptha-mana-wa-neme nhini nukunu-ka kardu mere nekineme-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mu Jesus kathu-ka mampirruneme, “Awu, mere mani nubumadhap-nukun-neme. Kardu nangkal ngatha mange patha mam wurran nanhthi lurruth ngala ngarra ngay thangunu i murrinh ngarra ngay-re mamngirdarrine wurran-ka nukunu nhini-ka mere murrinh mangirdarrithak kurru nhini-yu ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kardu nangkal ngatha ngarra nekineme mere manhengkaneme kurru-ka, nhini-ka kardu mangini nekineme deyida mani nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","I Jesus kathu-ka mampirru-deyida-neme, “Nga peneme. Murrinh thathpirr kanhi manarrunemenu-yu. Kardu nangkal ngatha the mamnankubathneme ngarra kardu pulangay ngay i nhini-ka mange patha purrunarrunemenu i kura patha ngatha yida punankudhaygurduknemenu-ka nhini Yile ngay ngarra wurdanngithuk da kanhi-ka le pinanu kardu ngarra nhini-nu-yu i mange patha deyida purrunanu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bere Kangkarlmawu-ka murrinh deyida mampirruneme, “Nga. Kardu mamay kanhi karrim-ka murrinh ngarra ngay mamngabath wurran-yu. Mu kardu nangkal ngatha puynardarripupnu i ngarra ngay paningipartnu kardu mamay kanhi mani karrim-ka nhini nukunu-ka da mange wiye ngala da matha mana nhini-yu. Mu nukunu nhini-nu-ka da-ka patha-wa kumadhamadharrk-yu nanhthi palyirr ngala yitthit-ya ngarra thamarl nukunu i kunnuku pangu mani wangu i kayiwik ngarra kura lalingkin. I nhini nukunu-ka mere mani warda kuynardarripup da ngarra wiye wangu-yu kardu mamay nginipunh kanhi mani karrim-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bere Kangkarlmawu-ka mampirru-deyida-neme, “Nga. Mu nanhthi mange ngarra nankuneme deyida-re da mange wiye numabathnu-ngatha-neme nuru nhini mange nhini-ka nubemartal-wa-neme nhini-yu. Nhini-ka da mange patha da thathpirr mange numi da matha numabathnuneme nuru-yu i nhini-ka da kangkarl nemardawithnuneme ngarra Yile ngay dim i bere matha wangu birnu narnenemenu da pangu-yu. Mu mange perrkenku ngatha numabathnuneme nuru-ka i da mange wiye da ngatha numabathnuneme nuru, nhini-ka da pangu wangu nanemenu ngarra thungku ngala dim, thungku mere ngarra kingkan nukun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“I ngana deyida nanhthi me ngarra nankuneme deyida-re da mange wiye numabathnu-ngatha-neme nuru nhini me-ka nubemertal-wa-neme nhini-yu. Nhini-ka mange patha da thathpirr me numi da matha numabathnuneme nuru-yu i nhini-ka da kangkarl nemardawithnemenu ngarra Yile ngay dim i bere matha wangu birnu narnenemenu da pangu-yu. Mu me perrkenku ngatha numabathnuneme nuru-ka i da mange wiye da ngatha numabathnuneme nuru, nhini-ka da pangu wangu nanemenu ngarra thungku ngala dim. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“I ngana deyida nanhthi kamarl ngarra nankuneme deyida-re da mange wiye numabathnu-ngatha-neme nuru, nhini kamarl nhini-ka nunguyngkapirt-wa-neme nhini-yu. Nhini-ka mange patha da thathpirr kamarl numi da matha numabathnuneme nuru-yu i nhini-ka nemardawithnemenu da ngarra Yile ngay dim-ya i bere matha wangu birnu narnenemenu da pangu-yu. I Yile ngay-ka ku Pule ngala thathpirr warda pinarrunemenu. Mu kamarl perrkenku ngatha numabathnuneme nuru-ka i da mange wiye da ngatha numabathnuneme nuru-ka nhini-ka da pangu nanemenu ngarra thungku ngala dim. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Da pangu-ka ngarra ku kirrikdarri ku bere matha wangu dim i thungku-ka bere matha wangu panpemath wurran. ");
INSERT INTO mwf2018_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“I nanki kardu wurnangat warda ngatha Yile ngay-ka bunanthadhapnu thungku-re kardu ngarra mana-wa yuthpan thathpirr numpan.” ");
INSERT INTO mwf2018_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Bere Kangkarlmawu-ka mampirru-deyida-neme, “Nga. Nanhthi salk-ka patha nawa ku ngen nukun-yu? Mu nga, nanhthi salk murntak manangka thithimarnti-ka nhini-ka wiye da matha nhini-yu i mere da matha nanhthi salk patha deyida nhini-yu. I bere nhini nankuneme-ka nanhthi nginipunh salk patha deyida mani nanemenu i nankuneme-ka patha-wa nururrunemenu ngarra kardu-yu. I kardu marda pekpek thathpirr nanemenu mange nankuneme ngatha-yu,” nukunu kathu-yu Kangkarlmawu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bere nhini thangunu Kangkarlmawu-ka nungardurr warda da nan thangunu kathu Kelili i pangu warda wangu nadha dini da nan-nu Judea. I puy deyida wangu nadha dini da ngamimarda pangu kathu da ngipilinh nan Jordan. I kardu wurnangat nimin-ya puyemnawerr-yu i nukunu-ka murrinh deyida wurdininthethiththa dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bere kardu nugarn ngamere pana ngarra murrinh law kardu Jews pigunu marda pumerttha purni, kardu Pharisees-ya, purnenadhaneme ngarra Jesus-nu i murrinh perrenathuktha-mana-wa-neme. I pumamnaneme, “Ya. Ngarra-re murrinh law nekineme yibim-yu? Mange-ka patha nhini-yu kardu nugarn kanipart kurdurinumi mani-yu palngun ngarra nukunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mu Jesus kathu-ka mampirruneme, “Nukunu Moses-ka ngarra mam murrinh nhini-nu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mu peneme kathu-ka pumamnaneme, “Kanhi-wa murrinh Moses mam-yu da murntak warra-ya, ‘Kardu nugarn ngatha marda mart kardu palngun nukunu kanipart kurdurinumi-ka nhini nukunu-ka murrinh karilil ngarra nanhthi peypa mere marda mart kardu palngun nukunu nhini-yu. I kangemut warda nanhthi peypa murrinh nhini-yu ngarra palngun nukunu i nhini-ka kanipart warda thathpirr kurdurinumi-yu palngun nukunu-yu.’ Nhini-wa murrinh Moses mam-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mu Jesus kathu-ka mampirruneme, “Nga. Nukunu Moses darntilil murrinh law pana-ka nhini nanki-ka kardu tetenumanthi-wa numpan i mange ngarra nanki da matha marda numanganart numpan. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mu da marra-re kathu ngarra Yile neki mampatha da putek ngala kanhi-ka kardu nugarn i kardu palngun mampunkuwathangintha. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","I da-ka nhini weyida kardu nugarn-ka kaninkupart-warda-ngintha ngarra yileyile i kalekale-yu i benginthalet ngarra palngun nukunu warda. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","I nhini peningintha-ka kardu numi da matha warda kurrungintha nhini-yu. Nhini peningintha-ka kardu mere warda perrkenku kurrungintha-yu, mu kardu numi da matha warda nhini-yu wurranngintha. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yile neki-ka kardu nugarn i palngun mampunkuwathangintha i bangampunkuletngintha i kardu numi da matha warda wurranngintha nhini-yu. Mu nhini-ka mere warda kardu nangkal bunkulangngintha nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bere nhini thangunu Jesus i pulangay nukunu-ka puddamkawurlneme ngarra thelput da i parnamkardineme. I pulangay nukunu-ka parramkadharrpuneme murrinh pangu ngarra kardu Pharisees merrudhaneme dini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bere Jesus kathu-ka mampirruneme, “Nga. Kardu nugarn ngatha kanipart kurdurinumi ngarra palngun nukunu i palngun numi kathu mabert i benginthalet-ka nhini nukunu-ka da mange wiye-wa mamnge nhini-yu ngarra palngun marra-re kanampart-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","I ngana deyida kardu palngun ngatha kanipart kurdurinumi ngarra nangkun nigunu i kardu nugarn numi kathu mabert i benginthalet-ka nhini nigunu-ka da mange wiye deyida mamna nhini-yu nangkun ngarra nigunu marra-re kanampart-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bere kardu terert-ka kardu mamay pigunu pumenmertidha purni ngarra Jesus-nu kardu manthadhapnu pi i murrinh parradharrpunu pi ngarra Yile nukunu wangu. Mu kardu pulangay nukunu Jesus-ka kardu pubuynkumadhaptha-mana-wa-neme ngarra kardu pumenmertidha mana-wa kardu mamay ngarra nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mu Jesus-ka bampunkumangkarduneme pulangay nukunu pubuynkumadhaptha-mana-wa-neme i nhini nukunu-ka pumamkamardaraki-warda-neme i mampirru-warda-neme, “Ya peneme. Kardu mamay kanhi-ka purunganu kathu i mere nubunkumadhap-nukun-neme. Kardu nangkal ngatha murrinh ngarra ngay mangabathnu kardu nginipunh mamay kanhi deyida mani murrinh pumamngabath pumpan-ya nhini kardu-ka Yile ngay-ka kardu pirrapenu pani kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Mu nga,” Jesus kathu-yu mampirruneme. “Kanhi-ka murrinh thathpirr-wa. Kardu mamay kanhi-ka le thathpirr parnamnga i murrinh pumamngabath parnam ngarra ngay-nu-yu. I kardu wurnangat warda ngatha murrinh thathpirr pumangabathnu mangini kardu mamay kibimkadhuk kanhi mani-yu, nhini Yile ngay-ka pirranpenu warda pani kardu nhini-yu. Mu nga. Kardu nangkal ngatha mere murrinh pumangabathnu-ka, nhini kardu-ka mere Yile neki nukunu parninu nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bere nhini thangunu Jesus-ka dininbetkuttha kardu mamay-yu numi numi ngarra lawali nukunu pirriningkadhuktha i kardu mamay numi mebertidha i puy merradha dini Jesus-yu. I nukunu-ka menpedhadhaptha dini ngarra pelpith-yu i ngarra Yile nukunu danirradharrpudha dini kardu bere matha wangu pirranpenu pani. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bere nhini thangunu Jesus-ka dempirnturt i wurrinililidha pangu warda wangu. Bere kardu nugarn numi-ka nanawinhararttha kathu dini ngarra Jesus-nu i demnawinhipingkarl kumparra pangu warra. I mamna kathu, “Pule, nhinhi-ka kardu patha-wa. Mu ngay-ka da-ka ngarra ngamanu ngurru ngarra Yile neki nganinu da bere matha wangu-yu?” Kardu nugarn nhini kathu dantharrpu ngarra Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bere Jesus kathu-ka mamna, “Thangku-nu nhinhi namnga-yu ngay-ka kardu patha-yu? Mere nangkal ngadha kardu patha kani-yu, mu Yile neki da matha patha thathpirr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nga. Nhinhi-ka the mana thanthin murrinh ngarra Yile neki da murntak warra mam-yu. I murrinh-ka kanhi-wa mam, ‘Kardu-ka mere thu thubat nukun i mere thurdurinumi nukun. I mere nukun da mange nangerithuk thurru kardu ngarra palngun nugarn karnabuy nukunu-yu. I mere darrarart nukun thurru. I mere tharrayirrarart nukun thurru. I mere nukun nankapdap thurru. I ngarra yileyile i kalekale dirruyewupnungintha thurru i murrinh narrubathnungintha thurru.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I kardu nhini kathu-ka mamna, “Pule, murrinh nhini-ka kardu mamay-re ngardidha i marra kanhi da mana murrinh bere matha mebaththa ngardi murrinh nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mu bere Jesus-ka marda thathpirr merttha wurrini kardu nhini-nu-yu. I memnabirl pirrim yuthpan i murrinh warda mamna, “Nga. Da mange numi da matha warda thamanu thurru. Nanhthi purrkpurrk ngarra nhinhi warda ngatha thelim thamanu i ku mani nhini-ka tharramutmutnu thurru kardu ngarra nanhthi mananhthi-wunka. I nhini thangunu-ka da ngarra Yile neki-re thimardawithnu-ka nhini-ka nanhthi patha-ka mere warda thaniyeymanu nhini-yu. I bere mampa, thurru warda i mange nhini thamanu i thurdingawurlnu ngarra ngay deyida kathu i thangirwaknu warda thani ngarra ngay wangu nhini-yu. I da nakurl-te-ka Yile neki-re nanhthi patha nimin-ya pampamutnu da ngarra nukunu wangu-yu. I bere mampa, thurru warda i mange nhini thamanu i thurdingawurlnu ngarra ngay deyida kathu i thurrunu warda ngarra ngay nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mu kardu nugarn nhini murrinh nhini-re binthepup-ka nhini nukunu-ka kardu warda danimardathintha pirri nhini-yu. Nhini nukunu-ka nanhthi purrkpurrk terert kanthidha dini i mere da matha ngarra thelim midha nhini-yu. Bere nukunu nhini-ka kanampart warda ngarra Jesus-yu i nadha dini pangu warda wangu danimardathintha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bere nhini thangunu Jesus-ka wurdampirrumardarduyneme ngarra pulangay nukunu i mampirruneme, “Nga. Kardu nangkal ngatha nanhthi purrkpurrk terert mammath wurran-ka nhini-ka da tetemanthay-wa nhini-yu mere ngarra kama pinanu Yile neki ku Pule ngala ngarra kardu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mu kardu pulangay nukunu Jesus-ka pumemnamardat-warda-neme murrinh pangu ngarra Jesus menadha pirri-yu kardu pangu ngarra nanhthi terert kanthidha dini i ngarra murrinh peneme deyida wanku mampirruneme. Bere Jesus-ka murrinh deyida mampirruneme, “Nga. Kardu darrikardu ngay,” mampirruneme. “Kardu nangkal ngatha nanhthi terert mabath kurru i purduyemitnu purru ngarra nanhthi nhini-ka, nukunu nhini-ka da tetemanthay nimin-ya mere ngarra kama pinanu Yile neki ku Pule ngala ngarra nukunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nga. Ku nan ku camel nganaka? Ku-ka da tetemanthay-wa ngarra kanirdi-yu ngarra da weyi kamarl ngarra nanhthi nil-yu, nawa? I mange nginipunh nhini mani-ya da-ka tetemanthay nimin-ya kardu nangkal ngatha nanhthi terert wanku mammath wurran ngarra pimardawithnu ngarra da Yile neki nukunu wangu-yu i pinu pangu-yu ngarra nukunu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bere ngana deyida peneme nhini-ka pumemnamardatneme ngala da matha murrinh ngarra Jesus thangunu merrudhaneme pirri-yu. I murrinh pumemnungkuneme mange peneme ngatha, “Ya. Kardu nangkal mani warda Yile neki manthiyibirnu-yu i panmardawithnu kangkarl-yu ngarra da nukunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bere Jesus-ka mempirrubirl-warda-neme pirrim yuthpan i murrinh mampirruneme, “Kardu-ka mere nangkal meyibirnu mange nukunu ngatha-yu, wurda, mu Yile neki da matha mani mayibirnu-yu. Nukunu da matha mani kardu manthibirnu-yu. Nukunu da matha mange da terert warda ngatha kama kurru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bere nukunu kathu Peter-ka mamna ngarra Jesus, “Nga. Ngankuneme-ka ngarnamkapart-warda-neme nanhthi purrkpurrk terert-yu, i kardu darrikardu ngankuneme wanku, i nanhthi thelput i nanhthi terert warda ngatha ngarnamkapartneme nhini weyida ngarra nhinhi warda nganhiriwaknemenu nguru-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Mu Jesus kathu-ka mampirruneme, “Nga. Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu. Kardu nangkal ngatha thelput nukunu panipartnu i kardu ngathan, munak, kalekale i yileyile i kardu wakal nukunu paninpartnu i da ngarra putek nukunu wanku panipartnu i ngarra ngay warda pangiriwaknu pani i murrinh ngarra ngay pantherlerrnu purru, nhini Yile ngay-ka panamutmutnu purru thelput terert-ya i kardu ngathan terert, munak terert, kalekale terert, yileyile terert i wakal terert-ya i da putek terert panamutmutnu purru ngarra da putek ngala kanhi ngadha paninu-yu. I ngana deyida kardu ngamere ngatha kathu da tetemanthay da wiye thathpirr pubunapaknu puru, mu nukunu nhini-ka bere ngatha wangu pangiriwaknu purru, nhini nukunu-ka bere matha wangu paninu kangkarl da ngarra Yile ngay wangu dim.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","I Jesus-ka murrinh deyida mampirruneme, “Nga. Kardu terert ngamere ngarra kardu pumemnungalangala pumpan da ngarra putek ngala kanhi, nhini kardu-ka kunungingki warda thathpirr puyunu tiduk da ngarra Yile neki nukunu wangu. I kardu terert ngamere deyida-re kardu ngarra kunungingki pubamnupak pumpan da ngarra putek ngala kanhi, nhini kardu-ka ngala warda thathpirr puyunu kumparra ngarra da Yile neki nukunu wangu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bere nhini thangunu Jesus i pulangay nukunu-ka purnelilidhaneme ngarra mayern da Jerusalem-nu warda wangu. Jesus-ka kumparra pangu warra wurrinililidha. I pulangay nukunu-ka pumemnamardatneme ngarra nukunu-yu. I kardu ngamere deyida ngarra parraniriwaktha purni tiduk-ka perrenham. Bere Jesus-ka kardu pulangay nukunu da matha panpunkuwerrneme mange peneme da matha. I murrinh warda mampirruneme murrinh ngarra kardu da mange wiye pumananu puru-yu da ngarra Jerusalem wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nga peneme. Nubingayepupneme,” Jesus kathu-yu mampirruneme. “Nekineme kanhi-ka da Jerusalem-nu warda wangu thurranneme. I da pangu-ka ngay kardu ngarra darrikardu nanki thathpirr-ka pumangirtanu warda nhini-yu. I nhini thangunu ngay-ka pumangibertinu puru ngarra ku yilarn ngala ngala i kardu ngarra murrinh law puddanpunthethith pumpan. I nhini thangunu-ka pubungipaknu kumparra pangu warra ngarra kardu. I murrinh thirrukduk pumangirdarrithaknemenu ngay mana-wa da mange wiye mebaththa ngurrini-yu. I nhini-ka murrinh pumanganu warda ngay-ka thu pungibatnu i ngupupnu. I nhini thangunu ngay-ka pubangimardanu i pumangibertnu pangu warda wangu kardu ngarra mere thathpirr Jews-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I kardu nhini-ka pirangikampanu parni i parningingkabebenu parni nanhthi thade-re i thu pumangirdarrilalarrnu parni thu whip-te. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu,” Jesus kathu-yu mampirruneme ngarra pulangay nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bere nhini thangunu piguna James i John-ka punnanadha ngarra Jesus-nu. Yile piguna-ka nukunu nan-wa Zebedee. Bere piguna kathu-ka pumamna ngarra Jesus, “Pule, kardu nhinhi-ka da mange nangarrunu mani nganku-nu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ngarra-wa mange manarrunu ngay-yu?” Jesus kathu-yu mampirru. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I piguna kathu-ka pumamna, “Nga. Ngarra nhinhi-re kardu Pule ngala thathpirr thinu da kangkarl pangu-ka, nganku-ka kardu pule ngala deyida mani ngenu i ngenhinganangurrunu mani ngarra nhinhi ngurru-yu batbat i thakunh-yu?” Parramkadharrpu piguna kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mu Jesus kathu-ka mampirru, “Nanku-ka da mange mere thathpirr the numabath da mange ngala da matha pana-yu ngarra narramngidharrpu-yu. Kardu pana ngarra Jerusalem-ka thu pungithuknu puru i pangilututnu warda purru. I mange mere patha purunganu. Nanku-ka mange nhini deyida-nu pumanarrunu puru, na?” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","I piguna kathu-ka pumamna, “Yu, nganku-ka marda-wa ngumangankart nhini-yu.” I Jesus kathu-ka mampirru, “Yu, bere-ya. Mange-ka nhini da matha pumanarrunu-yu, i nhini-ka mange mere patha purunarrunu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mu kardu pana ngarra penginganangurruninthanu ngarra batbat i thakunh-te-ka ngay-ka mere ngarra nukun mankungkarartnintha kardu nhini-yu. Mu Yile ngay-ka mampunkungkarart-wardarra-nintha kardu ngarra batbat i thakunh-te pininthanu-yu,” mampirru Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bere kardu ngarra pulangay ngamere kardu 10 kathu-ka puyempirruyepup murrinh ngarra piguna James i John pumenadha pe ngarra Jesus i nhini-ka peneme-ka parrampirrurithi warda ngarra piguna nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bere nhini thangunu Jesus-ka panpunkuwerrneme kardu pulangay nukunu-yu i mampirruneme, “Nga peneme. The mana nanthinpunkuneme-ya kardu pule ngala ngala pangu kardu mere thathpirr Jews-ya. Kardu pule ngala ngala nhini-ka da tetemanthay pirrimpirra ngarra kardu-nu-yu. I kardu pule ngala pirrimpirra ngarra kardu wurnangat nimin-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Mu nankuneme-nu-ka mange mere nginipunh nhini mani nanemenu. Kardu numi ngatha ngarra nankuneme marda mart kardu pule ngala pinarrunemenu, nhini nukunu-ka kunungingki-wa buynupaknu i manankumanpi-warda-ngatha-neme kurru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","I kardu numi ngatha marda mart kardu kumparra pinarrunemenu, nhini nukunu-ka kunungingki-wa buynupaknu i manankumanpi-warda-ngatha-neme kurru. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nginipunh ngay mani kardu ngarra da kangkarl kathu ngurdamnarrathut-ka ngurrinidha da putek ngala kanhi kardu-wa-nu manmanpinu ngurru, mere kardu-nu pumangimanpinu puru. I ngana deyida ngurrinidha da kanhi-ka kardu-nu ngunarrapupnu i kardu-ka ngay-re-wa mananthibirnunu-yu. Ngay-ka ngunarrapupnu da mange wiye thangunu numedha nardi. I nhini thangunu-ka kardu mananthibirnu-nu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bere Jesus i pulangay nukunu-ka parramkaruyneme ngarra da nan Jericho i pirrinidha-ngadha-neme pangu da. I bere ngarra pumpankardurr-te-warda-neme-ka wunku kardu wurnangat parrampunkuriwakneme, i kardu kamarrama manta pangu da dinidha ngurru ngarra da mayern. Kardu nhini-ka kardu bere matha wangu dinikaykaydha ku mani-nu. Murrinh nukunu-ka nan-wa Bartimaeus. I yile nukunu-ka nan-wa Timaeus. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bere ngarra nukunu-re Bartimaeus binthepup ngarra Jesus kardu Nazareth-mawu wurrinililidha manta ngarra nukunu, nhini nukunu-ka dimnakay warda i mamna, “Jesus, kardu tharntethbath ngarra King David thangunu kathu. Panhingamardathin ngadha ngay-nu i nangimanpinu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mu kardu wurnangat kathu-ka pumamna ngarra nukunu Bartimaeus, “Ya. Nadhap ngadha. Mere thinakaykay derrk da matha thi.” Mu nukunu-ka puy deyida wangu dininakaykaydha lurruth da matha i menadha dini, “Ya Jesus. Kardu tharntethbath ngarra King David thangunu kathu. Panhingamardathin ngadha ngay-nu i nangimanpinu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bere Jesus-ka pirret i murrinh mampirra ngarra kardu, “Ya. Niranakay kathu purrunu kanhi.” I nhini-ka pibimnakay warda kardu kamarrama nhini-yu i pumamna, “Ya. Le warda thi. Thewirnturt, kagu. Nukunu-ka pirrimpakay nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bere nukunu Bartimaeus-ka nanhthi kawut nukunu kanthinyegarl i kanampart i dempirnturt wurdawal kangkarl wangu i wurrininadha ngarra Jesus-nu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I Jesus kathu-ka mamna ngarra nukunu, “Thangku-nu? Mange ngarra-wa mampanu?” I kardu kamarrama kathu-ka mamna, “Pule, nangingkawathanu kamarl ngay patha ngurrubirlbirlnu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I bere Jesus kathu-ka mamna, “Ngay-ka manhingkawathanu kamarl ngarra nhinhi, nhini-ka murrinh ngarra ngay thangunu namngabath kamarl pana manhingkawathanu-yu. Mampa-ya nhinhi-ka thurrunu warda.” Bere da nhini thangunu-re-ka kardu kamarrama nhini-ka wurrinibirlbirldha warda i kardu kamarl-ka patha da matha mebaththa wurrini. I nukunu nhini-ka daniriwaktha warda wurrini ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bere nhini thangunu-ka Kangkarlmawu i kardu pulangay nukunu-ka punnedhaneme da Jerusalem-nu warda wangu. Bere parramkaruy-warda-neme da nan Bethphage i da Bethany i da palyirr nhini da, da nan Olive. I da-ka Jerusalem warda manta pardedhaneme-yu. Bere Kangkarlmawu-ka mampirrukaynintha kardu pulangay nukunu perrkenku kardu purdunkuthukninthanu kumparra warra. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","I mampirrunintha, “Ya penintha. Kumparra warra thununinthanu thi da ngarra town kunungingki pangu-yu. I ngarra thanintharuynu-re-ka ku tangki wakal daninthangkardunu pangu da karrim. Ku-ka mendharrk-wa pirrim. I mere nangkal ngadha kanirdarrilaladha ku nhini-yu. I thurdunintharerethnu nanhthi rup i ku-ka naninthabathnu warda kathu thurru ngarra ngay kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mu kardu ngatha murrinh kanhi manarruninthanu-ka, ‘Ya. Thangku-nu thurdannintharereth thanam ku pana-yu?’ Mu murrinh nankunintha-ka kanhi-wa numananinthanu-yu, ‘Nga. Pule ngankunintha-nu marda manganart ku kanhi-yu. Mu nukunu-ka mere pirdith deyida purdumpangkarlnu.’” Murrinh-ka nhini-wa Kangkarlmawu mampirrunintha-yu. I bere wurdanpunkuthuk-warda-nintha pangu warda wangu ku tangki nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Bere penintha-ka naninthadha dini i ku tangki nhini-ka bangamninthardurt warda pirridha pangu ngarra thelput ngarra mayern ngala menadharrktha pirri ngarra tuwa manta. I bere ku nhini-ka wurdannintharereth warda. Mu kardu ngamere-ka parrampunkudharrpunintha i pumampirrunintha, “Ya penintha. Thangku-nu thurdannintharereth thanam ku tangki pana-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I penintha kathu murrinh ngarra Jesus mampirrunintha-ka pumampirru-warda-nintha murrinh nhini-yu. I bere kardu ngamere nhini-ka puddanpunkuthuk-warda-nintha ku tangki wanku-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bere nhini thangunu penintha nhini-ka meninthabaththa wurrini ku tangki nhini-yu ngarra Jesus-nu warda wangu-yu. I nanhthi kaligu penintha-ka yingamninthardarriwup ngarra pangkin ku tangki. I Jesus-ka kanarnarrila warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bere Jesus-ka pinthanhinganardarridha ngarra ku tangki nhini-yu da Jerusalem-nu warda wangu. I kardu terert-ka nanhthi kaligu ngarra pigunu pardinaweweptha purni ngarra mayern pangu warra kumparra ngarra ku tangki-nu purrulilinu. I kardu ngamere-ka nithinu mulurn thay wath mani thangunu kathu pumunibewaththa punni i pingangkaweptha purni pangu warra kumparra ngarra ku tangki-nu purrulilinu wunku Jesus wanku pinthanhinganardarridha. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Kardu wurnangat nimin-ya kumparra ngarra Jesus punnililidha i tiduk kathu ngarra Jesus parraniriwaktha punni. I kardu-ka punnikaykaydha i pumenanudha punni, “Ya, mampa. Pariparl-warda-ngime kardu Pule ngala kanthim kanhi-nu-yu. Yile neki-ka wurdannhethukngime kardu kanhi-yu. Mampa pariparlnu-warda-ngime purru Yile neki-yu. Nukunu kardu kanhi-ka kardu Pule ngala paninu kardu nginipunh pangu mani ngalantharr murntak nekingime-yu nukunu King David-ya. Mampa pariparlnu-warda-ngime Yile neki-yu.” Nhini-wa murrinh-yu punnikaykaydha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bere Jesus-ka pangarntuy warda da Jerusalem ngarra ku tangki pinthanhinganardarridha. I bere wurdanthut i ngarra murrinh church ngala kardu Jews pigunu kanardi warda. I yerrarr mengkadha wurrini. Mu da-ka nhini-ka da kungini-wa i nhini nukunu-ka nungardurr da nhini thangunu-yu. I wurdawurl da pangu deyida da nan Bethany wangu wunku pulangay nukunu kardu 12 nhini punnedhaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bere da thipinhire nhini-ka Kangkarlmawu i pulangay nukunu-ka pumpankardurr-warda-neme da nan thangunu-yu da Bethany i punnedhaneme da Jerusalem-nu warda wangu. Bere Kangkarlmawu-ka mi medeyi wurrinidha. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I da ngarra ngathparr da ngatha nukunu bamkardu-yu nanhthi thay nanhthi nginipunh mi kurrangarr mani thay nan-ya fig wunku mulurn terert wanku-yu. I wurrinidha pangu da ngarra thay nhini da mi-nu. Mu mi-ka mere berdurttha, wurda, mu nanhthi mulurn da matha dinidha. Mi-ka mere da ngatha pinthangettha ngarra thay nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bere Jesus-ka murrinh mamna warda ngarra thay nhini-yu, “Nga. Nhinhi thay pana thirrim-ka mi-ka mere deyida thinthatutnu thirra i mere nangkal deyida paninhimurrknu ngarra mi nhinhi thangunu-yu.” I pulangay nukunu-ka pubimnayepupneme murrinh nhini menadha pirri ngarra thay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bere peneme-ka bere ngatha wangu puy punnadhaneme i parramkaruyneme da Jerusalem da. Bere Jesus-ka kanardi warda ngarra da church ngala kardu Jews pigunu. I kardu bampunkardu thelim pumedha pardi i payim pumedha pardi ku yinpi, ku thip, ku nenigut i nanhthi purrkpurrk wanku ngarra da church ngala nhini-yu. Bere Jesus-ka wurdanpunkarel warda kardu nhini-yu. I daniwinhekpaktha wurrini nanhthi table kardu ngarra nanhthi pigunu kardu pana ngarra ku mani purninmatkuttha-yu. I wurriniwuthpuththa nanhthi chair kardu ngarra nanhthi pigunu kardu pana ngarra ku yinpi thelim pumedha pardi. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I murrinh mampirra, “Ya. Nanhthi pana i ku-ka mere nukun numabath nuru ngarra da church ngala kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bere nhini thangunu Jesus-ka murrinh warda wurdanpunthethith kardu nhini ngarra wurdanpunkarel-yu i mampirra, “Nga. Yile neki-ka kanhi-wa murrinh nukunu yibimna-yu. I kanhi-wa mam-yu, ‘Thelput kanhi ngarra ngay-ka kardu-nu pirawatnu i parningangerrennu ngarra ngay kardu da pana-re ngangka thangunu-ya.’ Mu nanki-ka nubemkardurdu narnam kanhi ku mani-nu numampunkapdap narnam kardu ngarra terert thangunu kathu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bere ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law kardu Jews pigunu puddininthethiththa purni-ka puyemnayepupneme Jesus wurdanpunkarel kardu pana ngarra da church ngala pardidha. I nhini-ka parramnarithi-warda-neme. I murrinh pumemnungkuneme mange peneme ngatha, “Ya. Ngarra-re-wa Jesus thu pubatnemenu-yu?” Mu kardu nugarn peneme nhini-ka perremkamanhamneme ngarra Jesus-yu nhini-ka kardu wurnangat nimin-ya pumenanamardattha purni-yu ngarra murrinh nukunu wurdininthethiththa wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bere da thipinhi nhini-ka Jesus i pulangay nukunu-ka pumpankardurr-warda-neme da Jerusalem thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bere da thipinhire nhini pankapurl peneme-ka puddamkawurlneme pumpanka da Jerusalem-nu warda wangu. I punnedhaneme i pubamkangkarduneme thay nhini-yu nanhthi nan-ya fig. Mu nanhthi-ka demkawath-wa kangkarl da kathu ngarra ngimalmin da mana pepe. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","I nukunu Peter-ka wurdantherr thay nhini-yu i murrinh ngarra Jesus menadha pirri-yu nanhthi thay nhini-nu-yu. “Ya pule, dangkardu.” Peter kathu-yu mamna. “Kanhi karrim thay fig nhini-yu ngarra nhinhi nam mi mere deyida pinthatutnu pirra-yu. Nanhthi-ka demkawath warda thay kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mu Jesus kathu-ka mampirruneme, “Nankuneme-ka murrinh thathpirr numanabathnuneme ngarra Yile ngay i mange nginipunh nhini deyida mani niyemanemenu nuru-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu. Kardu nangkal ngatha murrinh thathpirr manabathnu ngarra Yile ngay, nhini nukunu-ka murrinh mana ngarra da palyirr ngala kanhi karrim, ‘Thurrurdurr pangu wangu i thununuku mange nhinhi ngarra lalingkin’. I nhini-ka da palyirr kanhi-ka kurrurdurr warda i kununuku warda mange nukunu ngarra lalingkin wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“I murrinh numi manarrunemenu. Ngarra Yile ngay-re nadharrpununeme-ka nhini murrinh thathpirr numanabathnuneme da panarrumutnuneme-ya i nhini nukunu-ka kanarrumut-da-matha-neme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","I ngana deyida ngarra nankuneme-re niranangerrennemenu ngarra Yile ngay i thu kuy da ngatha marda pepe pirrim narnamnaneme ngarra kardu numi, nhini marra-re warra ngadha-ka nuyunayekumneme da ngarra mange wiye kardu ngarra numi kathu mamnarruneme-yu. I mere deyida nanariyithineme nhini-yu kardu ngarra nangkal ngatha-yu. I nhini thangunu Yile ngay-ka da mange wiye ngarra nankuneme-ka pirranankumaputhnu-warda-neme ngarra nankuneme-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bere nhini thangunu-ka Jesus i pulangay nukunu-ka puy punnadhaneme i puddamkawurl-deyida-neme pangu deyida da nan Jerusalem. Bere ngarra nukunu-re Jesus wurrinililidha ngarra da church ngala nhini, ku yilarn ngala ngala i kardu pana ngarra murrinh law puddininthethiththa purni i kardu ngalantharr ngalantharr wanku purnenadhaneme ngarra Jesus-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","I murrinh pumamnaneme, “Ya. Nhinhi-ka nangkal thangunu murrinh mampa kardu thurdanpunthethith thurran i kardu pana thurdanpunkarel ngarra da church ngala kanhi thangunu kathu-yu? Kardu pule ngala ngarra nimin wurdannhithuk da kanhi-yu?” Parramkadharrpuneme kardu nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mu Jesus kathu-ka mampirruneme, “Mu nga. Ngay-ka murrinh deyida nganankudharrpunemenu. I murrinh thathpirr ngatha nangidhartnemenu nhini ngay-ka murrinh manarrunemenu warda kardu nangkal wurdanngithuk-yu da mange kanhi-nu ngamam ngurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nga, murrinh mani numanganemenu. Nangkal kardu John the Baptist wurdanthuk-yu kardu pana-ya ngarra kardu daninluluwewudha wurrini kura-re-yu? Nangkal nimin thathpirr wurdanthuk nukunu-yu? Yile neki thangunu kama i kardu thangunu kama-ya, ngarra nimin-yu?” Dampunkudharrpuneme Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bere kardu peneme nhini-ka puddanadharlurldhaneme pe murrinh mange peneme ngatha. “Murrinh kanhi ngatha pumananemenu, ‘Yile neki wurdanthuk nukunu John the Baptist-yu’, nhini nukunu Jesus-ka murrinh manhenemenu warda, ‘Mu thangku-dha murrinh mere numenabaththaneme-yu ngarra nukunu John the Baptist-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","I ngana deyida murrinh kanhi ngatha pumananemenu, ‘Kardu thangunu-wa nukunu John the Baptist wurdanthuk-yu’, nhini-ka kardu wurnangat kanhi-ka ngarra warda mange kumanheneme nhini-yu?” Nhini-wa murrinh pumenanudhaneme pe kardu peneme nhini-yu. I perrempunmanham kardu wurnangat, nhini-ka kardu wurnangat-ka the-wa panthidha purni Yile neki wurdanthuk nukunu John the Baptist-yu i murrinh ngarra Yile neki thangunu wurdanarrayiththa wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bere kardu peneme nhini kathu-ka pumamna-warda-neme ngarra Jesus-yu, “Yaa. Ngankuneme-ka mere the ngumabathneme nangkal nimin wurdanthuk nukunu John the Baptist-yu.” Mu Jesus kathu-ka mampirruneme, “Yu, bere-ya. Nhini ngay-ka mere deyida manarru-nukun-neme nangkal ngay wurdanngithuk-yu i mange kanhi ngarra ngay ngamam ngurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bere nhini thangunu Kangkarlmawu-ka murrinh warda mampirra ngarra kardu murrinh yibimkamnum-ya, “Yu bere, kardu pule ngala mi grape bebirrbirrdha wurrini ngarra putek nukunu. I nanhthi palyirr bengkardadha wurrini kanhi-re daniwegattha wurrini. I mampatha nanhthi palyirr werlpen pewerti marda mi kakpa-nu i punnuriyerrknu me-re. I thelput kangkarl deyida bangamkarda kardu-nu pirrabirlbirlnu pi kardu nukun mi grape nhini kanidarrarart. Bere nhini thangunu-ka kardu ngamere pirrimpirrukayneme mi ngarra kadin nukunu piranapenemenu parne. I murrinh mampirruneme, ‘Nga peneme. Mi ngarra grape-te thungku pebaynu-ka numuberartalnemenu i mi warda pumemarryerrnemenu nhini-yu.’ Bere nhini thangunu-ka kardu pule nhini-ka kanampart nungardurr warda mi kadin nhini-yu i da ngamengka-nu warda wangu nadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Bere da nakurl-te ngarra mi grape nhini-re demmay-ka kardu pule nhini-ka wurdanthuk kardu nugarn numi mi pumanayerrnemenu kardu pangu ngarra mi kadin nukunu piranapedhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mu peneme nhini-ka pumangankartaneme i punnebatthaneme parde kardu nugarn pana ngarra kardu pule wurdanthuk-ka i puddankathukneme pangu deyida wangu i mi-ka grape-ka mami-wa nayeymadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Bere nhini thangunu-ka kardu pule nhini-ka kardu numi deyida kathu wurdanthuk mi grape deyida-nu pumanayerrnemenu. Mu peneme nhini kathu-ka pubamkawerdupneme thu thay-re ngarra pelpith. I mange wirritmarnti pardenadhaneme kardu nhini-yu ngarra kardu pule wurdanthuk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","I ngana deyida kardu pule nhini-ka kardu nugarn numi deyida kathu wurdanthuk mi grape deyida-nu pumanayerrnemenu. Mu peneme nhini kathu-ka pumpankabat-deyida-neme i thu puddankarinumineme. Bere nhini thangunu kardu pule nhini-ka bere kathu wurdininthukthuktha dini kardu-ka numi numi-wa mi grape pangu da-nu. Mu peneme nhini-ka ngarra mi kadin piranapedhaneme parde-ka thu-ka pata kathu punninthuktha punni ngamere thu putput i ngamere thu puddininkurinuminumidhaneme punne. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Bere kardu ngarra nugarn mana kardu ngarra pule nukun pumpanpuntikerdek-ka kardu numi warda kanthidha dini kardu purduthuknu-yu mi grape deyida-nu-yu. I kardu nugarn nhini mebertidha dini-ka wakal ngarra nukunu thathpirr-wa. I nukunu kardu pule nhini-ka memnu, ‘Wakal ngay ngatha pangu ngurduthuknu-ka nhini kama kununkumardaleneme i murrinh-yu kubinayepupneme.’ I bere kardu pule nhini-ka wurdanpirruthuk-warda-neme wakal nukunu ngarra peneme nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mu peneme nhini ngarra nukunu-re pubamkangkarduneme-ka murrinh pumemnungkuneme mange peneme, ‘Nga. Nhini da kunungam kem wakal nukunu thathpirr kardu pule-yu. Ngarra yile nukunu-re pupupnu-ka nukunu warda mi kadin kanhi-yu martnu i mabathnu pi-yu. Mu nga, ka. Purru-wa-neme i thu pubatnemenu pangu da i nekineme warda mi kadin kanhi-yu pumartnemenu-yu i pumabathnemenu pi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bere peneme nhini-ka pumangankartaneme wakal nukunu kardu pule nhini-yu i thu pumpankabatneme i puddankarinumi-warda-neme nhini-yu. I nginipunh nukunu-ka punnungamkakuneme pangu wangu outside ngarra mi kadin.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bere murrinh nhini thangunu Kangkarlmawu kathu-ka mampirra deyida ngarra kardu-yu. “Nga. Ngarra kardu pule ngala mana kathu kurdiwurl ngarra mi kadin nukunu-ka ngarra mana warda mange nhini-yu marrunemenu ngarra kardu peneme nhini-yu ngarra wakal nukunu thu pumpankabatneme-yu? Nukunu kardu pule ngala nhini-ka thu punkuthuknu-warda-neme i purdunkurinuminuminemenu warda peneme nhini-yu. I kardu ngamere deyida pirrarrukaynuneme mi ngarra kadin nukunu piranapenemenu parne-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","I Kangkarlmawu kathu-ka mampirra deyida, “Nanki-ka murrinh rit ngadha numedha murrinh ngarra Yile neki nukun yibimnangurrkkurrk-yu. I murrinh-ka kanhi-wa, ‘Kardu nugarn pana ngarra thelput pubengkardadha punni nanhthi palyirr-te nanhthi palyirr numi punnungamku nhini-ka nanhthi wiye mana-wa pamam. Mu marra kanhi nanhthi palyirr ngala nhini-ka tetemam warda pirrim ngarra thelput nhini-yu. I da thelput nhini-ka yuthpan warda pirrim nanhthi palyirr nhini thangunu-yu. I Yile neki banpak nanhthi palyirr nhini-yu, i nhini-ka patha warda thathpirr.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bere ngarra ku yilarn ngala ngala i kardu ngalantharr ngalantharr wanku murrinh pubimnayepupneme-ka, kardu peneme-ka pumangankamartaneme murrinh nhini Kangkarlmawu wurdanpunkuyithneme murrinh mampunkungkardarrathneme-yu. I nhini-ka parramnarithi-warda-neme i pumertadhaneme-wa. Mu wurda, peneme nhini-ka parnamkapartneme, nhini-ka perrempunmanham ngarra kardu wurnangat i nhini-ka parnampart warda Kangkarlmawu-yu i puy punnidha pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bere kardu pule ngala ngala kathu pibimpirrukayneme kardu nugarn ngamere pana Pharisees i kardu ngamere nugarn pana ngarra pule Hered nukun, i puddanpunkuthukneme ngarra Jesus-nu murrinh perrenathuk-mana-wa-neme murrinh merdarrithaktha kardu ngarra pule ngala wangu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bere kardu peneme nhini-ka purnenadha-kathu-neme i murrinh pumamnaneme ngarra Jesus, “Ya pule. Ngankuneme-ka the-wa nganthinnhineme murrinh thathpirr-wa thurdanpirrayith thurran-yu ngarra kardu wurnangat warda ngatha i kardu pule ngala ngala wanku. I nhinhi-ka kardu mere nangkal ngadha themanham thani murrinh-yu. I nhinhi-ka da mange ngarra Yile neki nukun murrinh thathpirr thurdanpunthethith thurran. Mu nga. Ngarra-re murrinh law nekineme yibim-yu? Mange-ka yuthpan ku mani-yu nganamutmut nguru kardu pule ngala ngarra ku Government-yu nukunu Caesar-yu? Mange nhini-ka yuthpan kama i mange wiye kama?” Parramkadharrpuneme peneme nhini kathu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mu Jesus-ka the menkumabaththaneme dini murrinh pangu pumenadhaneme pe-yu murrinh perranathuktha-mana-wa-neme i merdarrithaktha mana-wa ngarra pule ngala Caesar. I nhini-ka mampirru-warda-neme, “Ya. Thangku-dha ngay nerrangathuktha-mana-wa-neme-yu? Ku mani silver kathu numangabathneme kanhi i ku mani bangkardunu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bere peneme nhini-ka ku mani silver parramnamutneme. I nukunu Jesus kathu-ka mampirru-warda-neme, “Nangkal pelpith kanhi ngarra ku mani silver kanhi-yu? I nangkal murrinh nukunu yibim-yu?” I peneme kathu-ka pumamnaneme, “Pana-ka pelpith nukunu kardu pule ngala ngarra ku Government nukunu-wa nan-ya Caesar. I murrinh nukunu deyida wanku kabim pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mu Jesus kathu-ka mampirruneme, “Ku mani kanhi ku nukunu ngatha Caesar-ka nhini-ka nuddunangkarl pangu deyida wangu ngarra nukunu. I nanhthi pana deyida ngarra Yile neki nukunu-ka nhini-ka nuddunangkarlnu pangu deyida wangu ngarra nukunu.” I bere kardu nhini-ka pumemnamardat-warda-neme ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bere kardu nugarn ngamere kardu nan-ya Sadducees purnenadhaneme ngarra Jesus. Kardu nhini-ka murrinh puddininthethiththa purni-ka kardu ngarra punniwuwuptha-ka mere deyida ku nginipunh puddingkarlbirlnu nhini-yu. Bere kardu peneme nhini kardu Sadducees-ka murrinh warda pumamnaneme ngarra Jesus murrinh perranathuktha-mana-wa-neme, ");
INSERT INTO mwf2018_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ya pule. Kanhi-wa murrinh law ngarra nukunu Moses dannherililneme da murntak warra-yu, ‘Kardu nugarn ngatha kupup-ka i palngun nukunu kanampart i kardu manangka wakal da ngatha, nhini-ka ngathan nukunu kathu warda mabert i benginthalet kardu palngun nhini-yu. I nukunu nhini-ka kardu wakal yingammapup warda kardu palngun nhini-yu ngathan nukunu yibimpup nukun-yu.’ Nhini-wa murrinh law Moses darntilil-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","I kardu peneme nhini-ka murrinh deyida pumamnaneme ngarra Jesus-yu, “Nga. Murrinh kanhi nguddimpayithnemenu. Kardu-ka 7-wa ngathan ngathan-yu. I bere kardu ngathan kumparra warra ngadha manganmert i bemnginthalet kardu palngun-yu. I kardinginthadha i yibimpup kardu nugarn nhini i manangka wakal. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","I nhini thangunu-ka kardu ngathan nukunu numi deyida manganmert i bemnginthalet kardu palngun nhini-yu, kardinginthadha i yibimpup deyida kardu ngathan nhini i manangka wakal da ngatha. Nhini thangunu-ka kardu ngathan numi deyida manganmert i bemnginthalet kardu palngun nhini-yu, kardinginthadha i yibimpup deyida kardu ngathan nhini i manangka wakal da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","I mange-ka nginipunh nhini mani-wa pumedha punni-yu ngathan ngathan ngamere nhini-yu, i wakal-ka manangka wakal da matha. Bere nhini thangunu ngarra pirriniwuwuptha-ka kardu palngun nhini deyida wanku yibimpup.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nhini-wa murrinh peneme nhini kathu puddamnayithneme-yu. I pumamna-deyida-neme, “Mu nga pule. Da nakurlnu da ngala ngarra nhini-re kardu ngarra wurnangat-te puddingkarlbirlnu-ka kardu ngathan ngarra nimin nangkun nigunu thathpirr warda-yu kardu palngun nhini pingenu-yu da nhini-nu-re-yu? Nhini nigunu-ka nangkun nigunu-ka 7-wa menkadhuktha kardi-yu da ngarra putek kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mu Jesus kathu-ka mampirruneme, “Nankuneme-ka mere thathpirr the numabathneme murrinh ngarra Yile neki nukunu. I mere the numabathneme nanhthi lurruth ngarra nukunu-yu. Mu murrinh ngarra numamnganeme-ka mere thathpirr murrinh nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mu nga. Da nakurlnu da ngala ngarra nhini-nu-re kardu ngarra wurnangat-te puddingkarlbirlnu-ka kardu nugarn i kardu palngun mere ngarra deyida benginthaletnu da ngarra nhini-nu-re-yu, wurda. I kardu mere nangkal deyida bayenu kardu palngun i nugarn da ngarra nhini-re-yu. Mu kardu wurnangat warda ngatha puyemanu puru ku nginipunh angel mani-ya da kangkarl pangu karnam-ya. I mere nangkal da matha benginthaletnu, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“I kanhi murrinh numi-yu ngurdinarruyithnemenu murrinh ngarra kardu puddingkarlbirl-deyida-nu. Nankuneme-ka murrinh rit ngadha numedhaneme-ya murrinh pana ngarra nukunu Moses i thay nhini pirrinamumtha da murntak warra-ya. Da nhini-re-ka Yile neki kathu mamna Moses, ‘Ngay-ka kardu Pule ngala ngempirruneme ngarra kardu ngalantharr murntak nan-ya Abraham, Isaac i Jacob.’ Nhini-wa murrinh-yu mamna ngarra Yile neki thangunu kathu-yu ngarra Moses-yu. I ngarra murrinh nhini-re mamna-ka kardu ngalantharr murntak nhini-ka pirrinewuwuptha-wardarra-neme nhini-yu da ngarra putek ngala kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mu puddamkangkabirl-weyida-neme ngarra nukunu wangu Yile neki parnamkaneme. Yile neki-ka dimpirra-wa kardu Pule ngala kardu wurnangat warda ngatha kardu ngarra birnu da matha parnam. Nukunu-ka mere Pule ngala ngarra kardu punniwuwuptha-yu, wurda. I nhini murrinh pana ngarra nuddanpunthethith numpan-ka mere thathpirr murrinh nhini-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bere ngarra nukunu-re Jesus i kardu nhini murrinh pumenanungkudhaneme pirrine-ka kardu nugarn numi-ka wurrinirrudha-warda-kathu-neme pangu da i binarruyepupthaneme pirri murrinh nhini-yu. Nukunu kardu nhini-ka kardu ngarra murrinh law kardu Jews pigunu-wa wurdininthethiththa wurrini. I nukunu kardu nhini-ka bimnayepup ngarra Jesus murrinh patha da matha dampunkudhartneme ngarra kardu nhini-yu. I bere nukunu nhini-ka pangu deyida dantharrpu Jesus i mamna, “Ya. Nukunu Moses-ka murrinh law terert dannhemutneme. Mu murrinh-ka ngarra nimin murrinh ngala thathpirr-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mu Jesus kathu-ka mamna, “Nga. Kanhi-wa murrinh law ngala thathpirr-yu. I nubingayepup kathu kardu pana narrarntethbath ngarra ngalantharr murntak nan Israel. Nga, ‘Yile neki da matha ku Pule ngala thathpirr dimnarra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","I nanki-ka marda thathpirr numartnu nuru Yile neki wunku marda-ya i wunku mukmuk-ya wunku ngepan-ya wunku nginipunh wanku.’ Nhini-wa murrinh law ngala thathpirr-yu i kumparra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","I murrinh law numi darntethbath-ka kanhi-wa, ‘Nginipunh nanki deyida mani marda numemnurt numpan i nimnupe numpan-ya nhini nanki-ka marda numanartnu nuru i niranpe-deyida-nu nuru kardu ngamere-yu.’ Kanhi-wa murrinh law perrkenku ngala thathpirr-yu,” Jesus kathu-yu mamna kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mu kardu nhini kathu-ka mamna ngarra Jesus deyida, “Nhini-ka murrinh-ka yuthpan da thathpirr, pule. Yile neki da matha ku Pule ngala thathpirr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I murrinh yuthpan da matha kardu nganki-ka marda ngumartnu nguru nukunu-yu wunku marda i wunku mukmuk i wunku nginipunh wanku. I kanhi deyida wanku kardu-ka marda ngumanartnu nguru i ngiranpenu nguru nginipunh nganki deyida mani marda ngumemnurt ngumpan i ngimnupe ngumpan-ya. Mu nganki-ka ku bere matha wangu ngumpanthuk ngumpan ku thip-yu i nginnangampek ngumpan nhini-ka Yile neki weyida marda ngumanganart ngumpan. I nhini-ka ngala-wa, mu ngala thathpirr-ka murrinh law perrkenku pana ngumabathnu nguru-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kardu nugarn nhini-ka murrinh patha da matha danthart Jesus-yu. I nhini Jesus kathu-ka mamna, “Nhinhi-ka denthengkarnirn thurran yuthpan da matha i da-ka manta warda Yile neki ku Pule ngala pimpanu ngarra nhinhi-yu.” Bere nhini thangunu kardu-ka dala pumamnamarda warda i mere ngarra warda murrinh perradharrpudha ngarra nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bere nhini thangunu Jesus-ka wurdininthethiththa dini kardu ngarra church ngala kardu Jews pigunu-yu. I murrinh mampirra, “Nga. Kardu pana ngarra murrinh law nukun puddannanthethith pumpan-ka nginipunh kanhi mani-wa murrinh pamam pumpan-yu, ‘Nukunu Christ-ka kardu darntethbath ngarra nukunu thangunu kardu ngalantharr murntak King David-ya.’ Nhini-wa pamam pumpan-yu. Mu thangku-nu murrinh nhini-yu pamam pumpan-yu?” Jesus kathu-yu dampuntharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Nga. Ngepan Yile neki nukunu murrinh mamna David murrinh ngarra darntilil-yu da murntak warra. I murrinh-ka kanhi-wa, ‘Yile neki murrinh mamna ngarra pule ngay.’ Kanhi-wa murrinh mam-yu, ‘Nhinhi-ka kanhi-re thinu ngarra ngay batbat-te i kardu pule ngala thinu-yu. I kardu pana ngarra mere marda kumanhert kuru nhini ngay-ka ngirranputhnu pangu warra kumparra ngarra nhinhi. I nhinhi-ka kardu pule ngala warda thirranu ngarra kardu nhini-yu.’ Nhini-wa murrinh David darntilil-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","I Jesus kathu-ka mampirra deyida, “Nukunu David mam-ka kanhi-wa murrinh-yu, ‘Nukunu Christ-ka kardu pule ngala ngay-wa.’” I Jesus mampirra deyida, “Mu ngarra-re nukunu Christ-yu kardu darntethbath ngarra David thangunu-yu? Nukunu Christ-ka kardu pule ngala-wa dim,” murrinh wurdamnuyith Jesus-yu. Bere kardu wurnangat ngarra pubimnayepup murrinh nhini-ka kardu le nimin pardinadha-ya murrinh ngarra nukunu Jesus wurdanpunthethith-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bere Kangkarlmawu-ka murrinh numi deyida wurdininthethiththa dini i mampirra, “Nga kardu. Thawath wangu nururranu kardu nugarn pana ngarra murrinh law puddannanthethith pumpan-yu. Kardu nhini-ka marda pumangannanart pumpan kardu pule ngala da matha nubankardunu i nantiparlnu nuru i ‘Pule’ numarranu nuru. I nhini weyida nanhthi kaligu pangkuy nanhthi patha pubardurdi pumpan i pumpannilili pana ngangka-re ngarra kardu wurnangat pirrimkadhuk-ya. Nhini-wa mange-yu le pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","“I ngana deyida ngarra da church mana parnardi-ka nhini-ka ngarra da chair patha da matha ngarra kardu pule ngala ngala nukun parnapup-ya. I ngana deyida ngarra kardu wurnangat-te puyemperr pirrim mi dhepdhep-nu-ka nhini-ka le-wa parnam ngarra da chair patha deyida parnawup ngarra kardu pule ngala ngala nukunu-ya. Nhini-wa mange-yu le pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“I ngana deyida kardu nhini-ka mere kiranpe karni kardu palngun mekmunurr. Mu nanhthi purrkpurrk i ku mani pigunu parnampunmakut parnam. I ngana deyida pumemnurart pumpan nginipunh kardu patha mani nhini-ka murrinh pirdithme parnamnangerren ngarra Yile neki. Nhini-wa mange-yu kardu nhini le parnam-yu. Mu Yile neki-ka mere marda manart kurru mange pana ngarra pumenthart pumpan da ngarra mange nukunu parrarntiwak mana pumpan-yu, nhini-ka da nakurl-te purdunkartelnu thathpirr kardu nhini-yu,” Kangkarlmawu kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Bere nhini thangunu Jesus-ka kanawup manta ngangka da ngarra nanhthi box ngarra kardu ku mani pubunimardardurdidha pi ngarra da church ngala nhini pirridha-yu. I kardu ngathayida dirrankadha dini ku mani kardu pubunimardardurdidha pi. I kardu wurnangat wunku ku mani ngala wanku pubunimardardurdidha pi ku mani terert ngarra nanhthi box nhini-yu Yile neki nukun. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","I nhini thangunu-ka kardu palngun mekmunurr warda kathu wurrinidha wunku ku mani kunungingki mebaththa wurrini. I nigunu-ka kanammardawu ku nginipunh five cent perrkenku ngarra nanhthi box nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bere nhini thangunu-ka Jesus mampirrukayneme kardu pulangay nukunu i mampirruneme, “Nga peneme. Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu. Kardu mekmunurr kurran pangu ku mani ngala thathpirr kanammardawu-yu ngarra nanhthi box pana-yu, ku-ka dimpunpewal ngarra kardu ngamere-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","“Mu kardu pangu karrimkadhuk-ka ku mani ngarra pumarntimut thangunu pimardathpuththa-yu, mu kardu palngun mekmunurr pangu-ka nanhthi pangu banmardardi nanhthi-ka nanhthi bere matha mebaththa kardi-yu, i nhini nanhthi-ka mananhthi warda kathu mi-nu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bere Jesus-ka yungawuy ngarra da church ngala pigunu kardu Jews i nungardurr warda. I kardu numi pulangay nukunu kathu mamna, “Pule nga. Da church ngala kanhi karrim-ka pubuniwakpaktha purni nanhthi palyirr ngala ngala nawa? I da-ka church ngala thathpirr kanhi-yu i da-ka patha-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mu Jesus kathu-ka mamna, “Nga. Da church ngala kanhi ngarra damkardu thirrim-ka da nakurl-nu-wa kardu-re pubayimpurrnu puru palyirr terert kanhi-yu. I nanhthi palyirr ngala ngala kanhi-ka da pana ngangka-re buymardarrurrnu purru.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bere nhini thangunu Jesus i pulangay nukunu-ka punnadhaneme i pirrimkamardawithneme da palyirr nan-nu Olive i da kangkarl parnamkawupneme i pumengkadhaneme pirrine pangu wangu ngarra church ngala nhini da pirabaththaneme pirrine. Bere ngarra kardu makardu mana warda-ka peneme Peter, James, John i Andrew purnenadhaneme ngarra Jesus i pumamnaneme, ");
INSERT INTO mwf2018_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ya pule. Minthire kardu thu kuy pubayimpurrnu puru-yu da church ngala pangu karrim-yu? I ngarra-re-wa kardu ngankuneme the ngumabathnemenu-yu ngarra da manta-nu warda-yu da nhini-re pubayimpurrnu puru-yu? I kanhi deyida numi-yu, ngarra-re-wa the ngumabathnemenu da ngarra manta-nu warda ngarra da nhinhi-re kardu Pule ngala thathpirr thingarranu ngarra kardu wurnangat warda ngatha?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mu Jesus kathu-ka mampirruneme, “Nga peneme. Nankuneme-ka thawath wangu nanemenu mere nangkal nukun murrinh thirrukduk kanarruyirrarart-nukun-neme. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nga. Kardu nugarn terert warda kathu purunu nhini-yu i murrinh panarrayirrarartnu parni nginipunh murrinh kanhi mani-ya pumanarranu-ya, ‘Ngay-ka Christ-wa. I Yile neki wurdanngithuk ngay-yu.’ I kardu wurnangat ngamere deyida murrinh nhini pumarrabathnu puru kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“I nanki-ka nubirrayepupnu kardu wurnangat thu kuy ngala da matha puyuwurdupnu da manta kanhi ngatha-ya. I nuyurrayepupnu kardu wurnangat thu kuy ngala puyithuknu puru da ngathparr pangu wangu-ya. Mu nanki-ka mere nenham nukun da nhini-re-yu, mange-ka nginipunh nhini mani-wa puyemanu puru-yu. Mu da putek kanhi-ka mere da ngatha panirikerdeknu da nhini-nu-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kardu wurnangat warda pumethanu puru da ngamengka da numi numi nhini thangunu kathu. I kardu pule ngala ngala i kardu ngarra peneme ngatha pumethanemenu puru-ya. I da putek-ka purrurangkaltangkalnu da pana ngangka-re-ya. I kardu wurnangat-ka mi dhepdhep-ka mami parninu. I da nhini-re-nu-ka kardu-ka da tetemanthay pubardurtnu puru da puretnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“I nga. Thawath-nu deyida wangu. Kardu-ka mere marda pumananartnu puru nhini-ka ngay thangunu weyida narramngiriwak numpan nhini-yu. I kardu-ka purunanngawurtnu i pumananbertinu puru ngarra murrinh court wangu. I kardu thu punanthuknu puru ngarra da church-ya. I nhini thangunu-ka pumananbertinu puru ngarra kardu pule ngala ngala. I kumparra pangu warra pubunanpaknu ngarra kardu pule ngala ngala nhini da, nhini-ka ngay thangunu weyida marda numanganngert numpan. I da nhini-nu-re-ka murrinh nuddurrayithnu kardu nhini-yu murrinh ngarra ngay thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mu da putek kanhi-ka mere da ngatha panirikerdeknu da nhini-re-yu. Mu da marra-re warra ngadha-ka murrinh thelerrdhe patha ngarra ngay nanthelerrnu nuru da ngarra pana ngangka-re-ya ngarra kardu wurnangat warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“I kardu pana-re ngarra purunanngawurtnu-ka i murrinh court wangu pumananbertinu puru-ka, nhini nanki-ka mere numenumardawerr nukun murrinh numarranu-yu ngarra kardu pule ngala ngala wangu. Mu Ngepan ngarra Yile ngay-ka murrinh panarramutnu ngarra kardu pule ngala ngala wangu murrinh numarranu-yu. I murrinh ngarra nururrangerrennu-ka nhini-ka murrinh ngarra Ngepan Yile ngay thangunu kathu i mere murrinh nanki thangunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Kardu-ka mere marda pumanartnu kardu ngarra ngay parramngiriwak pumpan-yu. I pumanbertinu puru kardu ngarra ngay-yu ngarra kardu pule ngala ngala wangu-yu thu punthuknu-yu pudduntinuminuminu-yu. Nginipunh kanhi mani-ya kardu-ka kardu ngathan nukunu mabertinu purru thu pubatnu-ya. I kardu yileyile-ka wakal nukunu mabertinu purru pangu wangu thu pubatnu-yu. I kardu-ka yileyile i kalekale pigunu pumanbertinu puru pangu wangu thu punkuthuknungime puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kardu wurnangat warda ngatha mere marda pumananartnu puru, nhini-ka ngarra ngay thangunu weyida marda numanganngert numpan-yu. Mu kardu nangkal ngatha bere ngatha wangu pangiriwaknu thathpirr pani i mere kaningipart nukun-ka kardu nhini-ka bere matha wangu paninu ngarra ngay-yu da kangkarl wangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Bere Jesus kathu-ka mampirru-deyida-neme, “Nga. Murrinh kanhi-ka nubiyepup-thathpirr-neme i numangimartanemenu. Nga, nubangkardunu kardu walmamka kardu kurdumparle thathpirr pirranu ngarra da church ngala pangu-yu. Nukunu nhini-ka Yile ngay mere marda thathpirr mart kurru. I nukunu nhini-ka mere mani kanirdi i kirra ngatha ngarra da church pangu-yu. Mu ngarra nukunu-re nubangkardunu pirranu pangu-ka tharra pirtpirt da matha nunnuwinhatnu ngarra da palyirr da ngathparr pangu wangu-yu nanki-yu kardu ngarra da Judea narnam-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“I ngarra da nhini-nu-re-ka kardu ngatha pinu ngarra thelput werlpen da kangkarl kathu-ka, nukunu nhini-ka mere deyida kanirdi ngarra thelput nukunu nanhthi purrkpurrk nukunu-nu panikutnu, mu tharra da matha punuwinhatnu ngarra da palyirr-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","I kardu deyida ngarra mi kadin panirurtuynu ngatha-ka, nukunu nhini-ka mere deyida pununu pi pangu ngarra thelput nanhthi kawut nukunu-nu martnu, mu tharra da matha punuwinhatnu nhini-yu ngarra da palyirr-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","I da nhini-nu-re-ka da-ka tetemanthay-wa pubardurtnu kardu palngun-yu kardu ngarra putput purunu-yu i kardu palngun pana ngarra kardu mamay punthaygurduknu puru ngapurlu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nhini Yile ngay nadharrpunu da tetemanthay nhini-ka mere karuy nukun da ngarra burrburr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“I da nhini-re-ka kardu wurnangat warda ngatha da tetemanthay nimin-ya pubardurtnu thu kuy ngala nhini thangunu-yu i da nginipunh nhini mani-ya. I da ngarra marra-re kathu ngarra Yile ngay mampatha da putek ngala kanhi i kardu wanku mampatha i da ngarra marra kanhi da mana thim-ka da tetemanthay ngala nimin-ka mere puberdurdurttha puyi da nhini-re-yu, mu da tetemanthay ngala nimin-ka kurran-wa kathu nhini-yu da nakurlnu-yu. I da tetemanthay ngala nhini thangunu pirtalnu-ka nhini-ka mere deyida paninu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mu da tetemanthay ngala nhini ngatha pirranu bere ngatha wangu-ka nhini-ka kardu wurnangat warda ngatha puruwuwupnu nhini-yu. Mu Yile ngay-ka mere warda purdumurlnu da tetemanthay ngala pirdithme nhini pirranu-yu. Mu pangu da wangu ngaliwe bartal-da-nu-matha da tetemanthay nhini-yu kardu pana-nu kardu ngarra nukunu thathpirr kardu ngarra mampunkarart-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Bere Jesus kathu-ka mampirru-deyida-neme, “Nga. Da ngarra nhini-nu-re-ka kardu ngamere kama murrinh pumanarranu-ya murrinh nginipunh kanhi mani-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim kanhi, Yile neki kathu wurdanthuk nukunu-yu.’ I ngana deyida murrinh kama pumanarranu-ya, ‘Nga nubangkardu. Nukunu Christ-ka karrim pangu-ya.’ Mu murrinh nhini-ka mere thathpirr murrinh nhini-yu, murrinh thirrukduk-wa. I mere murrinh nukun numarrabath nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","I kardu parurtuynu pira kardu Christ thirrukduk-ya kardu pumenurartnu parni Yile ngay mana-wa kurdunthuk. I ngana deyida kardu nugarn ngamere deyida parurtuynu pira kardu pumenurartnu parni murrinh ngarra Yile ngay mana-wa kurdurrayith kani. Mu kardu nhini-ka kardu thirrukduk deyida. I kardu nugarn nhini-ka mange ngala ngala terert puyemanu parni-ya wunku nanhthi lurruth ngala deyida puyemanu parni. I kardu wurnangat warda ngatha pumerramardatnu parni. I kardu nhini kathu-ka panarrayirrarartnu parni kardu wurnangat warda ngatha i nanki kama kardu ngarra Yile ngay nukunu-yu kanarrayirrart nukun. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mu nhini-ka kardu-ka thawath wangu-wa nururrabirlbirlnu-yu kardu thirrukduk-wunthay nhini-nu-yu. Ngay-ka mamnarruneme ngem murrinh terert kanhi-ka the numabathnemenu da nhini-yu paruynu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Ngarra thu kuy ngala nhini i da tetemanthay ngala nhini thangunu-ka nanhthi ngunga-ka mere warda palarrangnu pirra, wurda warda nhini-yu. I ngana deyida nanhthi merrk-ka mere warda pangkawipnu pirra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","I nanhthi pilinh-ka parniyimpurrnu kangkarl kathu-yu. I nanhthi pana kangkarl karnam-ka pirangkaltangkalnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“I da nhini thangunu kardu-ka pubangingkardunu ngay kardu darrikardu nanki thathpirr-ka ngurrunu kathu ngarra kalakkalak ngurrurdurdinu kathu. I pubangingkardunu kardu Pule ngala thathpirr warda ngurrunu nhini-yu wunku nanhthi lurruth ngala i ngay da matha warda pangilarrangnu purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bere nhini thangunu-ka ku angel warda ngurdunthuknu kardu ngarra Yile ngay nukunu purunmetkutnu i punperrnu puru da pana ngangka-re-ya. Kardu nhini ngarra Yile ngay menkararttha wurrini da ngala kurran kanhi i ngangka-re-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bere Jesus-ka murrinh deyida wurdampirruyithneme i mampirruneme, “Nga. Numangkathannu nanhthi thay thangunu kathu. The mana nanthin-ya nanhthi marlanpakpak ngarra thay-yu pangarntuy warda-ka nhini-ka da thangku manta warda nhini-yu, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","I mange nginipunh nhini deyida mani-ya ngarra nanki-re nubangkardunu nanhthi kangkarl nhini pamanu purru-ka nhini-ka the numabathnu da-ka manta warda ngay ngurdiwurlnu da putek ngala kanhi-yu i Yile ngay-ka ku Pule ngala thathpirr warda pinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Nga, murrinh thathpirr kanhi-yu. Thu kuy ngala nhini i da terert nhini ngarra ngay ngurdininarruyiththaneme ngini-ka da nhini-ka panarraruynu ngarra kardu wurnangat kanhi-re kardu birnu da ngatha numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I nga, nanhthi ngunga, merrk, nanhthi pilinh i da putek ngala kanhi-ka nanhthi mananhthi-nu warda i manangka da-nu warda panirikerdek-da-nu-matha. Mu murrinh thathpi ngarra ngay-ka mere ngarra nukun kanirikerdek, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Mu da nhini-nu-re ngarra ngay deyida ngurdiwurlnu kathu-ka, kardu-ka mere nangkal-wa the mabathnu da nhini-nu-yu. I ku angel deyida wunku mere the pumabathnu-yu i ngay deyida wanku da nhini mere the mabathnu-yu, ngay ngarra wakal nukunu thathpirr-ya. Mu Yile ngay da matha the kanthin dim da ngarra ngay purdungithuk-deyida-nu-yu ngarra ngurdiwurl-deyida-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mu nhini nanki-ka niranunginikatnu i nuyungabirlbirlnu, nhini nanki-ka mere the numabath ngarra ngay ngurrunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Mu nga. Da nhini-re ngarra ngay ngurrunu kathu-ka kardu mange nginipunh nugarn pana mani-ya da ngarra mayern ngathparr wangu nadha dini. I thelput nukunu kanampirrapart ngarra kardu wurlk nukunu pumenadha pardi kardu ngarra da piranapedha pardi-ya. I kardu nhini-ka wurlk dampirramut i murrinh mamna kardu numi ngarra nanhthi tuwa menadharlurldha pirri, ‘Ya. Bere ngatha wangu thirrangabirlbirlnu kathu i thirrangamardamardanu ngarra ngay ngurdiwurl-deyida-nu kathu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","I Jesus-ka murrinh deyida mampirruneme, “Ngay-ka kardu nugarn nginipunh nhini deyida mani ngarra thelput nukunu pangu mebaththa dini-ya. I nanki-ka kardu nginipunh pana mani ngarra wurlk pumenadha pardi. I nhini nanki-ka nuyungabirlbirl-nu i narningamardamardanu, nhini-ka mere the numabath minthire kama ngurdinarrawurl-deyida-nu kathu-yu, da kungini kama-ya, da kalkkalk kama-ya, da pangkararanu kama-ya i thipinhire pungkapurlnu kama-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","“Mu nanki-ka mere the numabath ngarra ngay deyida kathu ngurdiwurlnu-yu, nhini-ka nuyungabirlbirlnu bere ngatha wangu, da pirtpirt da matha ngurdinarrawurl nukun kathu-yu. I mere nuyungiyekum nukun ngarra ngay kathu ngurdiwurlnu-yu, mu nuyungabirlbirl-da-nu matha i narningamardamardanu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bere kardu Jews-ka pubenangkardurdu punni da Jerusalem pangu-yu da thangku terert-yu. I mi-ka pulleth mi lawam werlpen. I da-ka nhini murrinh-ka da nan-wa Passover. Bere da-ka da nhini-wa i kardu wurnangat nimin-ya pubemkardurdu warda da Passover-nu-ya. Mu da-ka da perrkengku warda wangu pirri mange ngarra punniret warda da Passover nhini-nu-yu. Bere da nhini-re-ka ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-ka murrinh dederrk-te puddanayiththa punni ngarra-re Kangkarlmawu pumartanu-yu i thu pubatnu i puddurinuminu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kanhi-wa murrinh-yu kardu nugarn nhini pumenanudha punni-yu, “Ya nga. Ngarra kardu-re murrinh tiparlti ngarra Yile neki wangu partalnu-re-ka i mi lawam werlpen nhini parikerdeknu-ka nhini-ka Kangkarlmawu warda pumartanemenu. Mu marra kanhi ngatha pumarta-nukun-neme, kardu-ka kanhirithi-nukun-neme i thu kunhituk-nukun-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mu Kangkarlmawu-ka da nan dinidha-yu da Bethany ngarra thelput Simon nukunu. I nukunu Simon nhini-ka matharr leprosy kanthidha wurrini da murntak warra-yu. Bere ngarra nukunu-re Jesus mi dhepdhep dinimurrktha-ka kardu palngun wurrininadha wunku nanhthi oil kangunu patha nimin-ya ngarra nanhthi pul-te. I bere mantharl i dampewewu ngarra pelpith nukunu Jesus-yu. Kardu palngun nhini-ka da murntak warra manganart nanhthi oil kangunu patha nhini-yu i ku mani ngala-wa pay mam manganart nigunu-yu. I murrinh nanhthi oil-ka nanhthi nan-wa nard. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mu kardu ngamere-ka mampunkumardarakineme ngarra palngun nhini-yu i murrinh pumenanungkudhaneme pirrine, “Ya. Thangku-dha nanhthi oil pangu-yu dampewewu-yu? Nanhthi-ka wurdanpi-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nigunu nanhthi-ka denhemuttha-wa-neme i nekineme-ka nanhthi warda thelim thumedhaneme nhini-yu ku mani ngala-nu-ya, i nhini ku mani nhini-ka therrumutmuttha-warda-ngime kardu ngarra mananhthi-wunka-ya.” Murrinh tetemam da matha pumenanungkudhaneme pirrine. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","“Ya. Pama da pi,” Jesus kathu-yu mampirruneme. “Thangku-dha murrinh pana ngarra nigunu numamkardarrithakneme nirrimka-yu? Mange ngarra nigunu mamnga-ka mange lelunh-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","I ngana deyida Jesus kathu-yu mampirruneme, “Kardu pana ngarra nanhthi mananhthi-wunka-ka kardu bere matha wangu perduynu parni kanhi da i ngarra marda-re numankurtneme-ka kardu-ka numankumanpinu-weyida-neme nhini-yu. Mu ngay-ka mere ngani ngatha nukun ngarra nankuneme kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nhini-ka mange patha-wa nhini-yu kardu palngun kanhi-yu nanhthi oil damngiwewewu ngarra pelpith ngay. Nigunu-ka damngiwewu wardarra ngarra nginipunh ngay-yu nanhthi oil patha kanhi-yu i mamngawathawatha wardarra ngarra nginipunh ngay-nu-yu pubangibirrnu-yu.” Jesus kathu-yu mampirruneme. Nhini-wa mange murntak-yu pume punni nanhthi oil kangunu patha parrininpewu punni ngarra ku nginipunh puwup-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Murrinh deyida thathpirr kanhi-yu,” Jesus kathu mampirruneme. “Kardu pana ngangka-re puddirrayithnu puru murrinh ngarra ngay-yu. I murrinh numi deyida puddirrayithnu puru murrinh ngarra kardu palngun kanhi thangunu damngiwewu-yu. Da pana ngangka-re kardu wurnangat nimin-ya pubiyepupnu puru kardu palngun kanhi i mange patha kanhi-yu ngarra mamnga-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bere nhini thangunu-ka nukunu Judas Iscariot, kardu pulangay nukunu Jesus kardu 12-ya kanampunkupart-warda-neme i wurrinirradha ngarra ku yilarn ngala ngala murrinh dederrk-nu marrunemenu ngarra-re nukunu mankumanpinuneme-yu Kangkarlmawu pumartanemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bere murrinh pubimnayepup-thangunu-neme nukunu Judas-ka, peneme-ka le warda pardedhaneme ku yilarn ngala ngala nhini-yu. I pumamnaneme ku mani panamutnemenu. Bere nhini thangunu nukunu Judas-ka dirrangkadha wurrini da ngarra kardu makardu-nu thathpirr ngarra Kangkarlmawu-yu i nhini-ka pirrarrakaynu warda ku yilarn ngala ngala nhini-yu kardu warda pumartanu Kangkarlmawu-yu i pumabertinu puru pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bere da ngarra kumparra marra-re da ngarra ngala nhini da Passover-ya da-ka pangarntuy warda nhini-yu. I kardu-ka pulleth-ka mi lawam werlpen-wa. I ku thip-ka purninthuktha warda ku dhepdhep-nu da ngarra marra-re nhini-yu. Bere da ngala nhini-re-ka pulangay nukunu Jesus-ka pumamnaneme, “Ya pule. Ngarra wangu mi ngumampawathawathanemenu-yu mi lawam werlpen i ku ngen mi nekineme-nu pullathnuneme-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bere nukunu Jesus-ka pulangay nukunu perrkenku mampirrukaynintha i mampirrunintha, “Penintha. Thununinthanu thi pangu da nan Jerusalem. I da pangu-ka kardu nugarn banankumardabininthanu nanhthi pot kura patha wanku piwepupnu purru ngarra pelpith nukunu-yu. I nhini thangunu-ka thaninthariwaknu thurru ");
INSERT INTO mwf2018_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","i pangu da mana ngarra thelput paniridinu. I murrinh kanhi numananunintha ngarra kardu pule ngala ngarra thelput nhini nukunu, ‘Ya. Kardu pule ngankunintha wurdanngankuthuknintha kanhi-yu. I nukunu-ka mam, “Ngarra da ngay-yu ngarra da mi ngulathnu mi Passover-yu wunku pulangay ngay wanku mi lawam werlpen i ku ngen ngullathnuneme-yu?”’ ");
INSERT INTO mwf2018_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I nhini thangunu kardu nhini-ka panankumardawithnunintha i panarrungkardanunintha da nhini-yu ngarra thelput kangkarl-yu. I nanhthi table i nanhthi chair wanku ngarra da ngala nhini-yu pingkadhuknu-yu. I nhini da da-yu ngarra mi naninthawathawathanu-yu mi lawam werlpen i ku thip ku ngen nekineme-nu-yu.” Nhini-wa murrinh-yu ngarra Jesus mampirrunintha-yu i wurdanpunkuthuk-warda-nintha. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bere penintha nhini-ka naninthadha dini da Jerusalem-nu warda wangu i pubemkamardabineme kardu nugarn nhini-yu wunku nanhthi pot kura wanku yingawepuptha wurrini-yu. I mamnintharluy i danininthariwaktha warda wurrini ngarra thelput nhini da nginipunh ngarra Jesus deyida mani murrinh nhini mampirrunintha. Bere penintha nhini-ka mi warda mamninthawathawatha mi lawam werlpen i ku ngen-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bere da thipinhi nhini-ka Jesus i pulangay nukunu kardu 12-ya parramkaruy-warda-neme ngarra thelput nhini-yu i parnamkardi-warda-neme ngarra mi-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bere nhini thangunu ngarra peneme-re mi pirrinemurrkthaneme-ka ngarra nanhthi table, Jesus-ka murrinh warda mampirruneme, “Nga peneme. Kanhi-ka murrinh thathpirr-wa manarrunemenu-yu. Kardu nugarn numi kanhi da kem ngarra ngay mi dimmurrk, kardu paningipartnu-yu i manmanpinu kardu wiyenpun pangu pumangirtanu i pumangibertinu puru pangu warda wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I ngarra peneme-re murrinh ngarra Jesus pubimnayepupneme-ka kardu dampunkumardathin-warda-neme nhini-yu. I ngarra Jesus parranedharrpudhaneme pirrine numi numi murrinh nginipunh kanhi mani-ya, “Ngay-ka wurda, nawa?” Pumenadhaneme pirrine. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mu Jesus kathu-ka mampirruneme, “Kardu nugarn nhini-ka kardu kanhi da kem kardu 12 ngarra nankuneme-ya. Kardu-ka kardu nhini-wa ngarra mi lawam ngurduninthakulknu ngarra nanhthi dish kanhi marda ngala. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bere ngay kardu darrikardu nanki thathpirr-ka ngupupnu warda murrinh nginipunh ngarra Yile ngay da matha mam da murntak warra-ya. Mu kardu nugarn nhini-ka kardu ngarra ngay parramutnu-ka kardu ngarra wiyenpun-ka, da-ka da wiye-wa-nu ngarra nukunu-nu-yu. I nukunu-ka patha-dha-wa nhini-yu mere banabattha-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bere ngarra mi-re pirrinemurrktha-da-ngatha-neme-ka nukunu Jesus-ka mi lawam werlpen manganart i Yile nukunu darntiparl mi-nu-yu i munirrurerrarrdhaneme dini. I mampirruneme, “Nga peneme, mi kanhi.” I mi warda dampirrumutmutneme. I mampirru-deyida-neme, “Mi kanhi-ka nginipunh ngay-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","I ngana deyida nanhthi kap manganart kura wine wanku i Yile nukunu deyida darntiparl kura wine-nu-yu i dampirrumutneme i perrenemadhaneme pirrine i numi numi pirrinegurdugurdukthaneme kura wine nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I nukunu Jesus-ka mampirru-deyida-neme, “Kura wine kanhi-ka kumulung ngay-wa. Kumulung ngay-ka pinthawunu i ngay-ka ngupupnu. I nhini-ka da wiye ngarra kardu pumammath pumpan-ka ngirranmaputhnu warda nhini-yu kardu ngarra murrinh ngay pumangabathnu puru-yu. Yile ngay da murntak warra mam da mange wiye pirranmaputhnu ngarra kardu thangunu, i nhini-ka murrinh-ka murrinh da thathpirr ngarra kumulung ngay-re pinthawunu-yu,” mampirruneme Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“I murrinh thathpirr kanhi manarrunemenu. Ngay-ka mere deyida bagurduknu kura mi kakpa nginipunh kanhi mani-yu. Mu da ngala kurran kathu-ka ngarra Yile ngay da matha Pule ngala thathpirr pinu-ka nhini ngay-ka kura deyida bagurduknu kura mi kakpa marra-yu,” nukunu kathu-yu Jesus mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bere nhini thangunu peneme-ka pardinareldhaneme nanhthi thamarl tiparlti ngarra Yile neki-nu wangu. I nhini thangunu-ka pungamkawuyneme ngarra thelput thangunu kathu i pangu warda wangu punnedhaneme da palyirr nhini da, nan Olive. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I bere Jesus kathu-ka mampirru-warda-neme, “Nga. Nankuneme-ka kardu narnengipartnemenu i kardu numenganthardarrarrnemenu murrinh nginipunh nhini mani-wa ngarra Yile ngay mam da murntak warra-yu. I kanhi-wa mam murrinh-yu, ‘Ngay-ka ngubat-wa-nu kardu nugarn pule ngala pana ngarra ku thip dirranganpunpe kanam-yu. I nhini thangunu ku thip-ka pumerdarrarrnu-warda-nintha nhini-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","I Jesus-ka mampirru-deyida-neme, “I nhini thangunu Yile ngay-ka purdungingkabirl-deyida-nu. I ngay-ka kumparra wardarra ngununu ngi da nan-nu wangu Kelili.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mu nukunu Peter kathu-ka ngarra Jesus mamna, “Kardu peneme ngatha parnenhipartnemenu i pumerdarrarrnemenu, nhini-ka ngay da matha wurda-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mu Jesus kathu-ka mamna ngarra Peter, “Murrinh kanhi mampanu-ka murrinh thathpirr-wa. Thipinhi marra kanhi-ka ngarra ku rooster mere da ngatha pirrakaynu, nhinhi-ka kardu narranu murrinh kanhi perrkenkuneme-yu, ‘Ngay-ka kardu mere the-wa mabath kardu nugarn pangu-yu.’ I nhini thangunu ku rooster-ka pirrakaynu warda nanhthi kaykay perrkenku-nu diyepupnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mu Peter kathu-ka mamna murrinh lurruth ngala ngarra Jesus, “Awu wurda, ngay-ka mere da matha ngama nukun ngay mere the manhibath nhinhi-yu. Kardu ngatha yida thu kungibatnu mange nginipunh nhinhi deyida mani thu punhibatnu pana, ngay-ka mere da matha ngama nukun mere the manhibath nhinhi-yu.” I peneme ngamere pana-ka murrinh nginipunh nhini deyida mani pumamnaneme ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bere nhini thangunu Jesus i pulangay nukunu-ka parramkaruyneme ngarra da nan Gethsemane ngarra thay terert-ya. Bere Jesus kathu-ka mampirruneme, “Nga, kanhi da nenuneme, mu ngay-ka ngurran dhi wangu-wa murrinh-nu ngarra Yile ngay nganinangerrennu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bere Jesus-ka mampirrukayneme Peter, James i John i purnedhaneme manta pangu da wangu. Nukunu-ka kardu danimardathintha warda dini ngala da matha i nginipunh nukunu-ka dinirartaldhanintha. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I mampirruneme ngarra Peter, James i John, “Ngay-ka damngimardathin warda dim ngala da matha. I ngay-ka ngingamnuthap ngem-ka kardu ngupupnu warda. Nankuneme-ka karda nenemenu i bere ngatha wangu nebirlbirlnemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Bere Jesus-ka wurrinidha pangu wangu manta ngangka da ngatha i murrinh kardinangerrentha ngarra Yile nukunu. I dempinhimardardum ngarra putek i murrinh mamna murrinh ngarra nukunu-re murrinh kanhi, “Abba,” murrinh kanhi-nu-ya, “Yile.” I murrinh numi deyida mamna, “Kardu-ka pangilututnu i thu pungibatnu. Nganaka kama-ya marda nanganart dunthap warda kardu nhini-yu i mere kangilutut nukun i mere kungibat nukun. Mange nhini-wa marda manganart ngem ngay-yu. Mu nhinhi mange ngatha marda nart kardu thangunu pangilututnu i thu pungibatnu, nhini-ka ngay-re marda manganart-yu. Mange ngarra nhinhi marda nanganart-ka ngay-ka marda deyida manganart mange nhini-yu.” I murrinh deyida mamna, “Yile, nhinhi-ka kardu lurruth ngala-wa i mange terert warda ngatha nukun nam thurran. I nhinhi da matha mani dunthap warda-yu kardu mere kangilutut nukun ngay i mere kungibat nukun kani. Mu nhinhi ngatha marda nart kardu thangunu thu pungibatnu i pangilututnu, nhini-ka bere ngatha puyemanganu. Mange ngarra nhinhi marda nartnu, ngay-ka marda deyida manganart mange nhini-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I nhini thangunu Jesus-ka wurdawurl pangu ngarra pulangay nukunu kardu perrkenkuneme nhini-nu-ya i bampunkurdurtneme kardu ngurrnguwarl pirrinengurrkurrkthaneme. I murrinh mamna ngarra Simon Peter, “Simon. Thangku-nu ngurrnguwarl pana thibimngurrkurrk-yu? Thangku-dha mere thanibirlbirl kunungingki ngadha-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","I ngana deyida murrinh mampirruneme ngarra kardu perrkenkuneme nhini-yu, “Kardu thathpirr narnebirlbirlneme-ya i ngarra Yile ngay warda nadharrpununeme manankumanpinuneme mere da mange wiye nukun niyemaneme ngarra nukunu-re ku karrath manankurullulnuneme-yu. I ngepan ngarra nankuneme marda numangankartneme numpanka mange yuthpan da matha-nu, mu nanhthi nginipunh ngarra nankuneme-ka mere lurruth ngala numabathneme.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bere Jesus-ka wurdawurl deyida i murrinh deyida kardinangerrentha ngarra Yile nukunu murrinh nginipunh marra-re deyida mani kardinangerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I nhini thangunu-ka wurdawurl deyida ngarra pulangay nukunu perrkenkuneme i bampunkurdurt-deyida-neme kardu ngurrnguwarl pirrinengurrkurrkthaneme, nhini-ka kardu pardewalawalakadha-da-ngatha-neme. Bere peneme-ka birl pirrimkaneme i pubamkangkarduneme Jesus, mu peneme-ka manangka murrinh-wa pirrinedhaneme, mere warda murrinh pumenadhaneme ngarra nukunu-yu, kardu yidiwe warda pirrinedhaneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","I nhini thangunu Jesus-ka wurdawurl pangu deyida kardinangerrentha ngarra Yile nukunu. I murrinh nhini thangunu-ka wurdampirruwurl-deyida-kathu-neme ngarra peneme i bangampunkungkardu-deyida-neme kardu ngurrnguwarl. I mampirruneme, “Ya. Nankuneme-ka karda ngatha narnamkangurrkurrkneme i bangamnankuyukneme dim? Bere-ya. Kardu-ka pumpan warda kathu ngay-nu-ya kardu ngarra darrikardu nanki thathpirr. Kardu warda pumangirtanu i ngay pubangimardanu kardu ngarra nugarn wiyenpun warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ka, newirnturtneme, purru-warda-neme. Nhini da kunungam kardu nugarn numi-yu kardu ngarra kanamngipart ngay-yu i kardu ngarra mampunmanpi kardu nugarn wiyenpun ngay-nu pumangirtanu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bere ngarra Jesus-te pirringerren-da-dha-ngatha-ka kardu nugarn numi nhini Judas-ya pangarntuy warda. I kardu nugarn terert deyida wanku parrarntuy wanku thu sword i thu thay pumebaththa purni. Nukunu-ka nhini da wanku Judas Iscariot kardu pulangay nukunu Jesus ngadha daniriwaktha kardi-yu kardu 12-ya mam numi-yu da ngarra marra-re-ya. Ku yilarn ngala ngala i kardu ngarra murrinh law kardu Jews pigunu puddininthethiththa purni i kardu ngalantharr ngalantharr puddanpunthuk kardu murlakpun nhini-yu Jesus-nu pumartanu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mu nukunu nhini Judas-ka murrinh mampirra wardarra ngarra kardu murlakpun mange ngarra-re manmanpinu Jesus pumartanu-yu. I ngarra murrinh mampirra wardarra-ka kanhi-wa, “Kardu pana ngarra ngadhamurrudhungnu-ka nhini-wa kardu-yu numartanu-yu i pangu warda wangu numabertinu nuru i niranginikatnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bere Judas-ka manta ngangka da wurrininadha ngarra Jesus i murrinh mamna, “Pule.” I nhini-ka danthamurrudhung warda ngarra thamurru nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","I bere kardu murlakpun nhini-ka pumangarnta warda Jesus-yu, tetemam da matha pumamyit pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","I kardu nugarn numi ngarra pulangay nukunu Jesus-ka thu sword manganart i panthertal the numi ngarra kardu pana ngarra wurlk nukunu menadha wurrini ngarra ku yilarn ngala thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","I bere Jesus kathu-ka murrinh mampirra ngarra kardu murlakpun nhini-yu, “Nanki-ka nunningadha ngay-nu i numanganngirta nginipunh kardu pana deyida mani kardu darrarartka numartanu wunku thu sword pangkuy pangkuy i thu thay. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mu ngay-ka da terert da matha nirripuptha wunku nanki-yu ngarra da church ngala i ngurdininanthethiththa ngardi pangu-yu, mu nanki-ka mere numengirtadha ngadha da nhini-re-yu. Mu Yile ngay murrinh ngarra nukunu-ka murrinh da thathpirr nhini-yu. Da murntak warra mam-ka kanhi-wa, kardu nugarn murlakpun pumangirtanu ngay-yu nginipunh nanki mani numanganngirta warda marra kanhi-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bere da nhini thangunu kardu pulangay nukunu Jesus-ka parnamkapart-warda-neme nukunu-yu i tharra warda punnungamkawinhatneme. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","I kardu kigay numi ngangka da pirridha ngarra Jesus wunku nanhthi kaligu sheet da matha banardidha pirri. Bere kardu nugarn murlakpun-ka pumangarnta warda nukunu nhini-yu, mu nukunu-ka mampunmakat nungampinhat kardu manangka kaligu wanku, mu kardu murlakpun nhini-ka nanhthi kaligu sheet da matha pumeyittha pi pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bere kardu murlakpun nhini-ka Jesus warda pumebertidha purni ngarra da thelput ku yilarn ngala thathpirr nukun. I nhini da kardu nugarn terert puyemperr, ku yilarn ngala ngala-ya i kardu nugarn pana ngarra murrinh law kardu Jews pigunu puddininthethiththa purni-ya i kardu ngalantharr ngalantharr wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mu nukunu Peter-ka daniriwaktha wurrini Jesus-yu da ngathparr tharrngini kathu. I kanardi ngarra gate nanhthi fence ngarra da thelput nhini dampegat dim-yu da thelput ngarra ku yilarn ngala thathpirr nukun. I kanawup ngarra ku soldier ngamere i thungku warda denartaldha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Bere ku yilarn ngala ngala i kardu nugarn terert deyida murrinh perremnudharrpu mange pigunu. Murrinh-ka kanhi mani-wa pumedha pirrini-yu, “Ya. Kardu nangkal ngadha bamkardu Jesus murrinh law ngarra nekineme mungamparl-yu? I kardu nangkal nimin murrinh manhenemenu-yu? I nhini-ka kardu warda thu pubatnemenu nhini-yu.” Murrinh nhini mani-wa perremnudharrpu mange pigunu ngatha. Bere kardu ngamere-ka murrinh thirrukduk pumerdarrithaktha pi ngarra Jesus-nu, mu peneme murrinh-ka puddanangkawuydhaneme pe. I mere nangkal ngadha midha murrinh thathpirr-yu nukunu Jesus mungamparl ngadha murrinh law pigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","I nhini thangunu kardu ngamere deyida-ka perrenawirnturturtthaneme pe i murrinh thirrukduk deyida pumerdarrithakthaneme pe ngarra Jesus-yu. I pumedhaneme pe-yu, “Nga. Ngankuneme murrinh-ka kanhi-wa ngubimnayepupneme-yu. I mam-wa murrinh-yu, ");
INSERT INTO mwf2018_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Da church ngala kanhi ngarra kardu thangunu pumampatha-ka ngay-ka bayimpurrnu i bawarntartanu i barderdenu da church numi deyida mere kardu thangunu pubarderdenu nhini-yu, i da-ka perrkenkuneme-wa ngay barikerdeknu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Murrinh nhini mani-wa pardekutkutthaneme-yu ngarra Jesus mana-wa mam-yu. Mu murrinh-ka puddanangkawuydhaneme pe. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bere ku yilarn ngala thathpirr-ka dempirnturt warda kumparra ngarra kardu i murrinh warda mamna ngarra Jesus, “Nganaka? Murrinh kanhi-ka murrinh da thathpirr peneme kanhi pumampaneme pirrim-yu? Murrinh-ka nangarranu nhinhi-yu i thurdingarrayithnu mani?” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mu Jesus-ka mere dedharttha i manangka murrinh da matha pirridha. Bere ku yilarn ngala thathpirr-ka murrinh mamna deyida, “Nhinhi-ka wakal Yile neki nukun? Nukunu-ka wurdannhithuk da kanhi-yu? I nhinhi-ka kardu Christ-wa, na?” Dantharrpu ku yilarn ngala kathu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","I Jesus kathu-ka “Yu” mamna. “I nanki-ka nubangingkardunu ngay kardu darrikardu nanki thathpirr-ka nginu ngarra Yile ngay ngarra ngurru nukunu-re batbat. I ngankunintha-ka marda ngala ngininthanu kardu Pule ngala thathpirr-yu. I nanki-ka nubangingkardunu ngay-yu ngurru-deyida-nu kathu ngurrurdurdinu ngarra kalakkalak da kangkarl thangunu kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mu ku yilarn ngala thathpirr ngarra murrinh nhini thangunu bimnayepup-ka kardu denamardarurrdha warda pirri ngarra Jesus-nu-yu i nhini-ka memnumangurrukduk warda ngarra nanhthi kaligu nukunu-yu i murrinh mampirra ngarra kardu-yu, “Mere nangkal warda paninhitharrmununeme. Nekineme-ka murrinh berengunh thubimnayepupneme murrinh ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nukunu mam-ka kardu wakal nukunu Yile neki nukunu thathpirr i kardu pininthanu marda ngala ngarra Yile neki-yu. Kardu mere nangkal nukun kama mange nhini-yu. Bere matha nhini-yu. Ngarra-wa mange pumananemenu-yu?” Mu kardu kathu-ka pumemnunkuneme, “Nga. Nekineme-ka thu pubatnu-warda-neme. Nukunu-ka pupupnu warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","I nhini thangunu kardu ngamere-ka nanhthi thade warda pardingkabebedha pardi ngarra nukunu Jesus-yu. I pumpankangkaral-warda-neme ngarra kamarl nukunu nanhthi kaligu-re i thu purnethukthaneme pe. I murrinh pumenadhaneme parde, “Ya. Nangarru-mani-neme nangkal pannhibat-yu. Nhinhi-ka the-wa nabath kardu ngarra pannhibat-yu nhinhi namngarra-ka wakal Yile neki nukunu-wa.” I nhini thangunu ku soldier-ka pangu warda wangu pumebertidhaneme purne i thu purnethuktha-warda-neme parde Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Mu da ngarra nhini-re-ka nukunu Peter-ka ngangka da ngatha dinidha outside ngarra thungku denartaldha dini. Bere kardu mardinhpuy ngarra ku yilarn ngala thathpirr wurlk menadha wurrini-ka bamkardu warda nukunu-yu ngarra thungku dinidha-yu. I nigunu-ka wurrininadha manta i pankardurr i dirranganthenh warda, i murrinh mamna, “Ya. Nhinhi da matha thardininthadha ngarra Jesus-yu kardu pangu-ya Nazareth-mawu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mu Peter kathu-ka mamnge, “Murrinh ngarra-nu nam thirrim pana kathu-yu? Murrinh nhinhi-ka mere manhimarta murrinh pana kathu namnga thirrim-yu.” Bere nukunu Peter-ka wurdawurl pangu deyida ngarra gate ngarra nanhthi fence ngarra thelput nhini dampegat dim-ya. I da-ka nhini da ngatha ku rooster-ka pirrimkay warda. ");
INSERT INTO mwf2018_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bere nhini thangunu-ka kardu mardinhpuy nhini da ngatha bamkardu deyida Peter pangu-yu. I nigunu-ka mampirra ngarra kardu ngamere pirriningkadhuktha pangu da, “Ya. Kardu nugarn pana karrim-ka kardu pulangay nukunu-wa Jesus.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mu Peter kathu-ka mamnge deyida, “Awu, wurda-wa ngay-yu.” I da kunungingki da ngadha kardu ngamere pana ngarra nukunu Peter manta pirriningkadhuktha-ka pumamna warda-wa ngarra nukunu-yu, “Nga. Nhinhi-ka kardu pulangay nukunu thathpirr-wa Jesus-yu, nawa? Nhinhi-ka da nan deyida thangunu kathu-wa Kelili.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bere nukunu Peter kathu-ka mampirra, “Nga. Yile neki-ka the kanthin murrinh ngarra ngay ngamam ngarrim kanhi-yu. I ngay ngatha murrinh nganarrayirrartnu-ka nukunu-ka the-wa mabath nhini-yu. I nhini-ka murrinh manarranu-ka, ngay-ka mere the-wa mabath kardu nugarn pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I da-ka nhini da ngatha ku rooster-ka pirrimkay deyida perrkenku warda mam nhini-yu. I nukunu Peter-ka binthepup i wurdantherr warda murrinh nhini ngarra Jesus mamna. “Nhinhi-ka kardu narranu murrinh perrkenkuneme thamanu mere the nangibathnu ngay-yu. I nhini thangunu-ka ku warda rooster deyida pirrakaynu tiduk nhini-yu.” Bere nukunu Peter-ka benayengkarnirntha dini murrinh nhini da ngarra Jesus thangunu mamna i murrinh ngarra nukunu wangu menadha kardi. I nhini thangunu-ka du ngala da matha kardikarrktha. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bere thipinhire nhini pankapurl-ka ku yilarn ngala ngala i kardu ngalantharr ngalantharr i kardu pana ngarra murrinh law puddininthethiththa punni-ka murrinh pumenanungkudha pirrini da ngarra-re mange Jesus thu pubatnu-yu. Bere nhini thangunu-ka pumambedharrkirrk warda Jesus-yu ngarra nithi i pumebertidha purni ngarra nukunu-nu Pilate i parramnamut. Nukunu Pilate-ka kardu pule ngala thathpirr dinirradha ngarra da nan-ya Judea. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bere nukunu Pilate kathu-ka mamna ngarra Jesus, “Ya. Nhinhi-ka kardu Pule ngala thurranpirra kardu ngarra Jews-yu?” Mu Jesus kathu-ka mamna, “Murrinh thathpi nhinhi da matha nam pana.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bere nhini thangunu nukunu Pilate-ka binarrayepuptha dini ku yilarn ngala ngala murrinh pumerdarrithaktha pi i murrinh thirrukduk pumenadha pi murrinh terert-ya ngarra Jesus wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bere nukunu Pilate kathu-ka mamna deyida ngarra Jesus, “Nganaka? Murrinh terert kanhi-ka murrinh da thathpirr kanhi kumampa kibim-yu? Murrinh-ka nanganu mani?” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mu nukunu Jesus-ka kardu manangka murrinh pirridha. I nukunu Pilate-ka memnamardat warda kardu watmam pirridha Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bere da thangku terert-te ngarra da ngala nhini-re da Passover-ya nukunu Pilate-ka yunguniwuy kardu numi-yu ngarra jail thangunu kathu-yu. Kardu ngarra nugarn nhini ngatha ngarra kardu parranidharrpu thangunu-ka, kardu nhini da matha Pilate yunguniwuy-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bere da nhini-re kardu-ka terert ngarra jail pardingkadhuktha-yu. Kardu nhini-ka punninthuktha punni kardu ngarra Government thangunu i kardu ngamere deyida puddinintinuminumidha punni. I kardu nugarn wiye numi-ka murrinh-ka nan-wa Barrabas. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","I bere kardu wurnangat puyemnawerr ngarra thelput nukunu Pilate kardu padharrpunu kardu numi-nu punguwuynu ngarra jail thangunu kathu nginipunh mange bere matha wangu merradha dini. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bere Pilate-ka mampirra warda ngarra kardu, “Ya. Kardu ngarra nimin nganipartnu-yu i ngurdunarrathuknu-yu? Kardu kanhi ngarra numamna numpan-ya kardu Pule ngala ngarra nanki kardu Jews ngurduthuknu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Murrinh nhini nukunu Pilate dampuntharrpu-ya, nhini nukunu-ka the-wa mebaththa dini ku yilarn ngala ngala-ka panganke-wa ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mu ku yilarn ngala ngala-ka pana-re punnidha ngarra kardu-ya i murrinh pumerradha punni, “Ya. Nadharrpunu Pilate nukunu-nu Barrabas punguwuynu, mu nukunu Jesus-ka wurda-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bere nukunu Pilate kathu-ka mampirra deyida ngarra kardu, “Ya kardu. Mu ngarra-wa ngamanu kardu nugarn kanhi karrim-yu ngarra numamna numpan kardu Pule ngala-ya ngarra nanki kardu Jews-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mu kardu kathu-ka pardinakaykaydha i pumenadha pardi ngarra nukunu wangu Pilate, “Ya. Nukunu pana-ka darderdenu i thinthatnu ngarra thay i pupup-da-nu mana.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mu nukunu Pilate-ka mampirra deyida, “Thangku-nu-wa? Ngarra ngadha medha wurrini merithuktha wurrini da mange wiye-yu nukunu-yu?” Mu kardu kathu-ka puy deyida kathu pardinakaykaydha i pumenadha pardi, “Ya. Nukunu pana-ka darderdenu i thinthat-da-nu-matha ngarra thay i pupup-da-nu-mana.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bere nukunu Pilate marda merttha wurrini-ka mange ngarra kardu-wa marda pumerttha punni, i nhini-ka yunganwuy warda kardu nugarn wiye nhini Barrabas-yu. I wurdanthuk warda Jesus-yu ngarra ku soldier thu pumarlarlarrnu parni thu whip-te. I bere ku soldier-ka thu warda pumerdarrirlarlarrdha pardi thu whip-te. Thu whip nhini-ka turethturethmam nanhthi wunku murnu wuting wuting wanku thu yidingurr ngala da matha nhini-yu. I nhini thangunu nukunu Pilate-ka mampirra ngarra ku soldier-yu, “Pata, puy. Numaberti warda Jesus-yu i nubarderde i ninthatnu warda ngarra thay i pupup-da-nu-mana.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bere ku soldier ngamere-ka pumebertidhaneme purne pangu warda wangu Jesus-yu i parnamkardineme ngarra da thelput ngala nan nukunu Pilate. I ku soldier terert warda puyemnungkuwerrneme da nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","I nanhthi kaligu ngarra banardidha wurrini Jesus-ka pungankamapirt-warda-neme i pubankardurdineme nanhthi numi warda, nanhthi-ka purple-wa colour-yu nanhthi nginipunh pana mani ngarra kardu pule ngala ngala pubanardurdidha purni. I nanhthi nginipunh mayeyep mani nanhthi wutingwuting-ya pingamkamerlarlneme. I pubankawerdineme ngarra pelpith nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bere nhini thangunu-ka perrenanawinhipingkarldhaneme parde ngarra nukunu kumparra i pumenadhaneme parde murrinh parrinegumugatthaneme, “Ya Pule. Da pirdithme da matha thanibirnunu nhinhi-yu kardu Pule ngala ngarra kardu Jews pigunu thimpirra.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I thu purnewelerrdha-warda-neme parde ngarra pelpith nukunu thu thay-re i thade pardengkabebedhaneme parde i ngarra nginipunh nukunu wangu i perrenanawinhipingkarldhaneme parde kumugat wiye da matha pumenadhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bere ngarra da wiye nhini thangunu pumenadhaneme parde-ka nanhthi kaligu purple nhini-ka pungankamapirtneme i kaligu ngarra nukunu thathpirr warda pubankardurdineme. Bere nhini thangunu peneme nhini ku soldier-ka pangu warda wangu pumebertidhaneme purne kardu pubarderdenemenu i pumangkalenemenu ngarra thay. I Jesus-ka panamanthidha wurrini nanhthi thay. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bere pumpannurdurr warda da nhini thangunu-yu i punnililidha pangu warda wangu. Bere ngarra punnilili-re-ka ku soldier pubamkardu kardu nugarn da ngamengka thangunu kathu nadha dini, da nan-ya Cyrene. I murrinh nukunu-ka Simon-wa. I wakal nukunu nan-ya Alexander i Rufus. Bere ku soldier-ka pumangawil nukunu Simon i nanhthi thay pana pananamanthidha wurrini Jesus-nu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","I puy punnidha i Jesus pumebertidha purni pangu warda wangu ngarra palyirr pinpith da nan-ya Golgotha. Golgotha nhini-ka murrinh ngarra pigunu-wa kardu Jews. Murrinh kanhi-nu-ya nanhthi mangini murnu pelpith mam pirrim da palyirr pinpith pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bere ku soldier-ka parramnamutneme kura wine i nanhthi mirrithin pumamnangkarnuneme nhini-ka mere warda palurturtnu ngala nhini-yu. Mu Jesus-ka mere ngarra begurduktha, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bere peneme ku soldier-ka pubangammarderde mange ngarra Jesus-yu i ngarra me pubangammerderde ngarra thay nhini-yu. I parrampirnturt pubanpak i pinthanhidha i pupupnu warda Jesus-yu. I nhini thangunu ku soldier-ka nanhthi warda pirrineyekdhekthaneme nanhthi kaligu ngarra Jesus-nu-yu, nanhthi nhini-ka kardu nangkal kama warda martnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bere ngarra nukunu-re Jesus pubanpak ngarra thay-ka nanhthi ngunga pirridha-ka da thipinhire-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","I ngarra thay nhini ngarra Jesus menangkaledha pinthanhi-ka murrinh wanku pubanpak kangkarl ngarra pelpith nukunu. Murrinh nhini-ka kanhi-wa, “Kardu kanhi kanthim-ka kardu Pule ngala ngarra kardu Jews pigunu-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I kardu nugarn perrkenku, kardu darrarart-yu parrampunkuwirnturt-deyida-nintha ngarra thay. Kardu numi-ka ngarra batbat-te pinthanhidha ngarra Jesus i kardu numi-ka ngarra thakunh-te pinthanhidha. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bere ngarra Jesus birnu da ngatha pinthanhidha-ka kardu-ka pubeyerrarrdha pi i murrinh pumerdarrithaktha pi ngarra nukunu, “Ya,” pumenadha pi. “Nhinhi nam-ka dayimpurrnu da church ngala pangu i darderde-deyida-nu nanhthi numi i da perrkenkuneme darikerdeknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mu nenuyibirnu mani i thurdithut mani kathu ngarra thay pana-yu,” kardu kathu pumenadha pi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","I ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-ka nhini deyida wanku punningkalkbelktha pardi ngarra Jesus-yu. I mange pigunu murrinh pumenanudha pardi, “Ya. Nukunu-ka kardu terert menthibirnudha wurrini-yu, mu nukunu-ka mere ngarra menuyibirnu kani nukunu ngatha-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“I nekineme ngatha pubangkardunemenu ngarra thay thangunu kathu mange nukunu-re purdithutnu, nhini nekineme-ka murrinh thathpirr warda pumanabathnuneme nukunu-ka wurdanthuk da thathpirr ngarra Yile neki thangunu kathu-yu. I nukunu-ka kardu Pule ngala thathpirr ngarra kardu Jews nekineme-yu.” I kardu darrarart wunkungkanintha nhini murrinh meninthardarrithak-deyida-dha pinthanhi ngarra Jesus deyida-nu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bere nanhthi ngunga ngarra pelpith pirridha-ka da-ka thipinhi-wa pangarntuy nhini-yu da pana ngangka-re-ya. Da thipinhi nhini pirridha-ka da kungini da mana i ngunga-ka nhini-wa pangarntuy-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","I da nhini-re-wa Jesus-ka lurruth pinthimnakay ngarra Yile nukunu wangu i mamna ngarra murrinh nukunu-re, “Eluy, Eluy lama sabakthani.” Murrinh-ka kanhi-nu-ya, “Yile, Yile, thangku-dha ngay thanamngipart-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","I kardu ngamere ngarra pidha pangu manta pubimnayepup Jesus-yu murrinh ngarra medha pinthanhi, i murrinh pumemnu mange pigunu, “Ya. Nukunu-ka pinthimnakaykay kardu ngalantharr pangu kardu nan Elijah.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bere kardu nugarn numi tharra nungampinhat pangu i manganart nanhthi pekpek i wurdankulk ngarra kura wine thithimanti i manthawidharrkirrk ngarra thay pangkuy kumparra warra Jesus-nu kura pungudhungnu. I murrinh mampirra ngarra kardu, “Ya. Kuguk mup. Pinamardamardangime nukunu kama Elijah panaruynu i purduthutnu Jesus-yu ngarra thay thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bere Jesus-ka lurruth ngala deyida pinthimkay i yibimpup warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","I da nhini-re-ka nanhthi kaligu ngala pinthanhidha ngarra da church ngala kardu Jews pigunu-ka dimngurruduk warda kanganu, kangkarl thangunu kathu-ka i pepe da mana. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bere ku soldier ku pule ngala-ka pirringanamedha pangu da manta ngarra thay bamkardu Jesus yibimpup-yu i bimnayepup ngarra nukunu pinthimkay-yu. I murrinh warda mam, “Kardu nugarn kanhi kanthim-ka kardu wakal Yile neki nukunu thathpirr-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","I ngana deyida kardu palngun ngamere pana pirabaththangime pe Jesus pinthanhidha ngarra thay i pubamkangkardungime yibimpup-ka peningime pedhangime da ngathparr tharrngini kathu. Murrinh peningime-ka kanhi-wa Mary Magdalene-ya i Mary pana kale piguna James kardu kigay-ya i nukunu Joses, i palngun numi murrinh-ka Salome-wa. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kardu palngun nhini-ka parraneriwakthangime parde Jesus da nan wangu Kelili da marra-re-ya i pumemanpidhangime punne i parranenamutmutthangime punne mi dhepdhep-yu. I kardu palngun ngamere deyida kardu terert pangu da pidha, kardu ngarra parriniriwaktha punni da Jerusalem-nu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Bere, da ngarra Jesus yibimpup-ka da-ka Friday-wa. Bere da pana warda ngarra ngunga kardithurrk-ka nhini-wa da-yu Saturday warda-yu mange ngarra kardu Jews pigunu-yu kardu benyuktha dini. Bere da ngarra kungini mana warda da Friday nhini-ka kardu nugarn pana nan Joseph wurrininadha bere ngatha daniwirntedha wurrini ngarra nukunu-nu kardu pule ngala Pilate. I dantharrpu ku nginipunh nukunu-nu Jesus martnu. Kardu nugarn nhini Joseph-ka da nan thangunu kathu Arimathea-wa. I nukunu-ka kardu yuthpan thathpirr i kardu patha. I kardu pana ngatha yida kardiwup i puddanayithneme pirrine ngarra ngalantharr ngalantharr kardu Jews-ya. I nukunu-ka kardimardamardadha da ngarra Yile neki ku Pule ngala thathpirr pirranu ngarra kardu wurnangat warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bere nukunu Joseph dantharrpu thangunu nginipunh nukunu Jesus-nu-ka kardu pule ngala nhini Pilate-ka kardu bemkabat da matha i memnu mange nukunu, “Ba. Jesus-ka yibimpup kama warda-ya?” I nhini-ka ku soldier ngarra pule kumparra dimnakay warda i mamna, “Ya. Jesus-ka yibimpup warda?” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","I ku soldier nhini-ka Pilate kanamnatharrmu Jesus-ka yibimpup warda. I nukunu kathu-ka Pilate mamna ngarra Joseph, “Yu berengunh, ku nginipunh nukunu nart warda.” ");
INSERT INTO mwf2018_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bere nhini thangunu-ka nukunu Joseph-ka wurrinidha ku nginipunh Jesus-nu wunku nanhthi kaligu sheet nanhthi patha da matha. I mantharday ku nginipunh nhini-yu i mamlarlarr ngarra nanhthi kaligu sheet nhini da. I nhini thangunu-ka yingampup ngarra weyi palyirr ngarra kardu thangunu pumampatha-yu. I nhini-ka wurdannerlerl i danthap warda nanhthi palyirr ngala werlpen nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bere palngun perrkenku nhini Mary Magdalene i Mary pana ngarra kale nukunu Joses-ka bamnginthangkardu da weyi palyirr nhini-yu ngarra Joseph yingampup ku nginipunh nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bere da Saturday nhini ngarra kardu Jews-te benyuk dini-ka da dirntal warda nhini-yu. I kardu palngun nhini nan Mary Magdalene i Mary pana kale nukunu James i palngun numi deyida nan Salome nanhthi oil warda pumangankartngime ku nginipunh nukunu-nu Jesus pawewunungime. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bere da thipinhire nhini da pankapurl da Sunday-ya kardu palngun pana-ka punnedhangime ngarra weyi palyirr nhini-nu wunku nanhthi oil kangunu patha wanku. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","I ngarra punnelili-re-dhangime-ka murrinh kanhi pumenanungkudhangime punne, “Ya. Nangkal purdunherurtnungime nanhthi palyirr ngala pangu-yu ngarra denthap pirrim-yu ngarra weyi palyirr-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bere pumpankabirlbirlngime peningime-yu i pubamkangkardu-warda-ngime da weyi palyirr nhini-ka menadharldha wardarra dini. I palyirr ngala werlpen nhini-ka ngurru-re warda pirridha. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bere peningime-ka parnamkardi-warda-ngime ngarra weyi palyirr nhini-yu i pubamkangkardungime-ka ku angel dinibangurrdha nginipunh kardu kigay mani medha dini. Nukunu dinidha ngarra kanhi-re batbat i nhini peningime-ka perremkanham-warda-ngime. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bere ku angel kathu-ka mampirrungime, “Peningime nga. Mere nenhamngime. Ngay-ka the-wa nganthin Jesus-nu nangannawinhadhathngime numpanka-yu. Jesus pana-ya kardu Nazareth-mawu-ya i kardu pana ngarra thay pinthimkatneme-ya. Yu da-ka kanhi da-ya ku nginipunh nukunu yungurrkurrktha-yu. Mu ku nginipunh nukunu-ka maku-wa kanhi-yu. Nukunu-ka kardu wurdamkabirl warda-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mu ku angel kathu-ka mampirru-deyida-ngime, “Mu nga. Na-warda-ngime i murrinh kanhi numarrununeme ngarra pulangay nukunu wanku Peter-ya, ‘Nga. Nukunu Jesus-ka pangu wardarra kumparra kunungam kem da nan-nu Kelili. I nukunu-ka pangu wardarra banankardunu-yu murrinh nginipunh mamnarra murntak warra-ya.’ Nhini-wa murrinh-yu numarranuneme ngarra pulangay nukunu-yu,” ku angel kathu-yu mampirrungime. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bere nhini thangunu peningime-ka pungamkawuy-warda-ngime ngarra weyi palyirr thangunu kathu-yu i punnungamkawinhat-warda-ngime. Nhini peningime-ka perremkanhamngime ngala da matha i punnawerrerrdhangime. Peningime-ka mere ngadha perrenkuyelerrdhangime ngarra kardu-yu mu nhini-ka kardu perremkanham-weyida-ngime nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bere ngarra Jesus thangunu wurdamkabirl-ka da Sunday thipinhire nhini-ka kardu marra-re bamkardu nukunu-ka nigunu Mary Magdalene-wa. Da murntak warra nukunu Jesus pirrimmaputh ku ngepan wiye ku-ka 7-wa ngarra nigunu thangunu Mary Magdalene nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bere ngarra Mary Magdalene thangunu bamkardu Jesus, nigunu-ka nadha dini pangu warda wangu i dampunkuyerrneme kardu peneme pana ngarra Jesus pardedhaneme. Kardu nhini-ka daninkumardathinthaneme-wa kardi i du ngala pardekarrkthaneme nhini-ka Jesus thangunu weyida yibimpup. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mu kardu-ka mere murrinh pumengebaththaneme ngarra Mary Magdalene dampunkuyerrneme-yu ngarra Jesus wurdamkabirl-yu i ngarra nigunu bamkardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bere nhini thangunu nukunu-ka pangampirruruynintha ngarra kardu naninthalilidha dini da numi deyida-nu wangu. Mu penintha nhini-ka mere dirrangininthathenhtha marra-re-yu ngarra nukunu-yu, nhini-ka kamarl nukunu-ka wurdamkath kamarl numi deyida wurrinibirlbirldha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mu bere ngarra Jesus dirranganninthathenh-te-ka nhini penintha-ka wurdamninthawurl deyida da Jerusalem-nu i murrinh parrampunkuyerrnintha ngarra pulangay nukunu Jesus i kardu ngamere, mu kardu-ka mere murrinh-wa pumerrubaththanintha, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bere tiduk nhini thangunu Jesus-ka pangampirruruyneme ngarra pulangay nukunu warda, kardu-ka 11-wa ngarra mi dhepdhep-te pirrinemurrkthaneme-yu. I nukunu-ka murrinh nungampirrumardawalneme nhini-ka kardu tetepumamkayineme i murrinh thangunu mere pumebaththaneme parne murrinh ngarra kardu thangunu parraninkuyelerrdhaneme punne-yu murrinh thelerrdhe-ya ngarra nukunu pubamkangkardungime wurdamkabirl-warda-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I nhini thangunu Jesus kathu-ka mampirruneme, “Nga peneme. Nuruwatnuneme da pana ngangka-re i kardu nanthelerrnu nuru kardu ngarra wurnangat da matha murrinh thelerrdhe patha kanhi ngarra murrinh ngay-nu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","I kardu nangkal ngatha murrinh nhini mabathnu-ka i paluwewunu nhini-ka Yile ngay-ka mayibirnunu ngarra thungku ngala thangunu-yu. Mu kardu nangkal ngatha murrinh nhini mere mabath-ka nhini Yile ngay-ka purdungkarelnu ngarra thungku ngala nhini wangu wunku mange wiye nukunu wanku mabathnu purru. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“I kardu nangkal ngatha murrinh ngarra ngay mangabathnu thathpirr purru-ka kardu nhini-ka mange patha da matha pamanu purru nanhthi lurruth ngarra ngay thangunu. I nga, mange-ka nginipunh kanhi mani-wa pamanu purru-yu. Nukunu-ka ku ngepan wiye pirranmaputhnu purru ngarra kardu thangunu-yu murrinh ngarra ngay-re mangirdarrinenu purru. I murrinh themen numi numi deyida purrungerrennu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","I ngana deyida ku pangkuy mulak ngatha mawinhikatnu martnu-ka i balelenu, nhini-ka mere ngarra kupup nukun kardu nhini-yu. I kura poison ngatha bagurduk bawinhikat-ka nhini nukunu-ka mere ngarra matharr bardurt i mere ngarra kupup. I ngana deyida mange ngarra nukunu manpethapnu ngarra pelpith kardu matharr wunngini i nhini-ka kardu patha warda purunu. Mange-ka mange nginipunh nhini mani-wa pamanu purru-yu i nhini-ka kardu wurnangat warda ngatha the warda pumabathnu Yile ngay-ka lurruth ngala da matha dim-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bere murrinh nhini thangunu Pule Jesus mampirruneme-ka Yile nukunu-ka kanthinmardawith warda wangu i ngarra ngurru nukunu batbat-te kanawup. I nukunu deyida wanku ku Pule ngala thathpirr warda dim nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bere nhini thangunu-ka pulangay nukunu Jesus-ka punnewattha-warda-neme da pana ngangka-re-ya i parrinkuyelerrdhaneme punne murrinh ngarra Jesus nukunu-ya. I Pule Jesus-ka bere matha wangu menkumanpidhaneme wurrini mange patha patha da matha pumerrudhaneme punne. I nhini kardu wurnangat nimin-ya the pumebaththa punni murrinh ngarra peneme-ka murrinh da thathpirr. Bere, nhini-wa murrinh-yu murrinh ngarra Kangkarlmawu nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ya, pule Theophilus. Ngay-ka ngamparilil murrinh kanhi ngarra Jesus da ngarra putek kanhi kardidha-ya. I kardu terert deyida parrinirilildha purni murrinh kanhi da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kardu pana ngarra Jesus pubamkardu i murrinh ngarra nukunu puddininthethiththa purni, murrinh kanhi parraninganthelerrdha purni-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","I ngay-ka murrinh thathpirr bere matha wangu binayewuptha ngurrini murrinh kanhi ngarra Jesus-yu i murrinh-ka ngurrinikutkuttha-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","I nhini-ka memnu warda mange patha-wa kanhi-yu murrinh ngala warda ngatha ngarililnu. I nga, pule Theophilus. Murrinh ngala kanhi ngamparilil-ka, nhini-ka murrinh da thathpirr murrinh pana ngarra kardu ngamere deyida pumempadha purni-yu. Mu murrinh ngala da matha warda ngurdimpayithnu thathpirr kanhi murrinh ngarra Jesus nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bere da murntak warra ngarra nukunu pule Hered dinirradha kardu ngarra Judea pardidha-ka ku yilarn deyida kardidha, murrinh nukunu-ka nan-wa Zechariah. Nukunu Zechariah i ku yilarn ngamere deyida-re kardu murrinh pumenkawadhadha purni-ka Abijah-wa. I palngun nukunu Zechariah-ka murrinh nigunu-ka Elizabeth-wa, i yile nigunu-ka ku yilarn deyida kardu ngarra nukunu ngalantharr nan Aaron darntethbath-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bere peningintha nhini Zechariah i Elizabeth-ka kardu da mange patha da matha kardinginthadha, i Yile neki the menkubaththangintha wurrini nhini-yu. I ngarra murrinh Yile neki nukunu pumenabaththangintha purne bere matha wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mu peningintha nhini-ka manangka wakal-wunkuma da matha-ngintha kardinginthadha. Nigunu Elizabeth-ka kardu manangka wakal da matha banabattha. I peningintha nhini-ka kardu ngalantharr kunugunu warda kardinginthadha. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bere nukunu Zechariah i ku yilarn ngamere deyida, kardu-ka ku Abijah-wa wurlk pumenadha purni Yile neki nukun ngarra da church ngala kardu Jews pigunu-ya. Mange nhini-wa pume purni pumenamararttha ngarra ku yilarn ngamere-ya ngarra da church ngala nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bere ku yilarn ngamere-ka nukunu-wa Zechariah pumemmangkart-yu panirdinu ngarra da church ngala nhini-yu i nanhthi kangunu patha nhini-nu pinanartaknu nanhthi warnak ngarra Yile neki-nu-yu, mange ngarra pume purni, i nhini-wa pumemmangkart Zechariah-yu. Bere nukunu Zechariah-ka kanardi warda i nanhthi warnak kangunu patha warda ninganartaktha pirri ");
INSERT INTO mwf2018_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","da nhini-re ngarra kardu wurnangat outside pirriningkadhuktha i murrinh Yile neki pirrinangerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bere da nhini-re-ka ku angel ngarra Yile neki thangunu kathu pangamnaruy ngarra Zechariah pangu-re batbat pirridha ngarra da altar ngarra da nukunu nanhthi warnak ninganartaktha pirri Yile neki-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bere nukunu Zechariah bamkardu ku angel nhini-yu i bemkabat warda i demmanham. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mu ku angel kathu-ka mamna, “Nga Zechariah, mere thengimanham. Pule ngala Yile neki kathu-ka bimpayepup-wa murrinh ngarra thanidharrpudha thardi-yu i nhini-ka palngun nhinhi Elizabeth-ya wakal nugarn buyngebatnu i murrinh thuparlnu-ka John-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","I mamna deyida ku angel kathu-yu, “Ngarra wakal nhinhi-re buybatnu-ka nhini-ka le patha warda thathpirr thaninu i kardu wurnangat deyida wanku le patha parninu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nhini-ka Ngepan Yile neki thangunu panimardardinu ngarra nginipunh nukunu-yu ngarra buybatnu-re-yu i bere matha wangu paninu nhini-yu. I nukunu-ka purdirurturtnu i kardu ngala purrunu. I Yile neki-ka le thathpirr paninanu. I nukunu nhini-ka mere kurrugurdugurduk nukun kura murlak-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I kardu Jews wurnangat purdunkalathnu ngarra Yile neki-nu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I kumparra warra pununu pi ngarra kardu nugarn pana ngarra Yile neki kathu purduthuknu-yu. I Yile neki-ka nanhthi lurruth ngala panamutnu ngarra ngepan nukunu mangini nukunu deyida mani kardu ngalantharr murntak nan-ya Elijah nanhthi lurruth ngala damnamut-ya. I nukunu-ka purdirrayithnu purru murrinh ngarra Yile neki nukunu ngarra kardu wurnangat. I nhini kardu yileyile-ka marda deyida pumanartnu puru wakal peneme-yu. I kardu pana ngarra da mange wiye pummamath pumpan-ka parnipartnu warda i nhini-ka kardu nginipunh pana deyida mani ngarra kardu mange patha panthin pumpan kardu puyemanu puru. Da-ka mange-ka nginipunh nhini mani-wa wakal nhinhi purdunkalathnu-yu kardu Jews ngarra Yile neki-nu wangu-yu. I nhini kardu-ka pumenawathawathanu i puyunamardamardanu kardu Pule ngala pana-nu kardu ngarra tiduk kathu pununu pi-yu i parraruynu kardu ngarra nhini da.” Nhini-wa murrinh-yu ku angel mamna ngarra Zechariah. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bere nukunu Zechariah kathu-ka mamna ngarra ku angel nhini-yu, “Mu ngay-ka ngarra-re the danngiyerdi thirrim pana kathu-yu murrinh thathpirr namnga thirrim-yu? Ngay-ka kardu ngalantharr warda-wa i palngun ngay-ka kardu kunugunu warda-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mu ku angel kathu-ka mamna, “Ngay-ka Gabriel-wa. I ngay-ka bere matha wangu nganamnintha ngarra Pule ngala Yile neki-ya. I nukunu da murrinh nhini-yu damngamut i wurdanngithuk ngarra nhinhi-nu murrinh patha kanhi ngamnhiyerr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mu nhinhi-ka mere murrinh nengabaththa ngay-yu, nhini nhinhi-ka manangka murrinh ngadha thurrunu themen mampadhapnu i ngarra wakal nhinhi da mana buympabatnu thathpirr. I murrinh kanhi ngarra mampa-ka da-ka murrinh da thathpirr thuyepupnu nhini-yu.” Ku angel kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mu kardu wurnangat-ka da outside da ngatha pirriningkadhuktha. I da pirdithme nimin pardinayekattha-ya kardu-yu nukunu Zechariah-nu pungiwuynu i murrinh-nu purdirrayithnu. Mu kardu kathu-ka murrinh warda pumenanudha purni, “Ya. Thangku-dha nukunu Zechariah da pirdithme kanam pangu-yu inside-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bere nhini thangunu nukunu Zechariah-ka yungawuy warda ngarra da church ngala nhini thangunu-yu, mu mere ngarra warda murrinh wurdinirrayiththa ngarra kardu wangu-yu, wurda. Nukunu pangu pirridha-ka murrinh mange da matha-re daninkarrdha pirri i nhini-ka kardu warda murrinh pumenanudha pi, “Ya, nukunu kama murrinh thathpi ngarra Yile neki thangunu kathu bimnayepup pangu ngarra da church ngala-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bere nhini thangunu nukunu Zechariah-ka wurlk-ka marntikerdek warda ngarra da church ngala pangu-yu ngarra Jerusalem-yu, i nungardurr da ngarra nukunu-nu warda wangu nadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bere nhini thangunu-ka palngun nukunu Zechariah Elizabeth-ka kardu marda warda wurrinidha. I nigunu-ka kardidha ngarra thelput inside da matha mange nigunu da matha kardidha. Da-ka merrk 5 warda kardidha-yu, i mere nangkal ngadha bengkardudha i dengeruydha. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Bere nigunu-ka murrinh menanudha kardi mange nigunu ngatha, “Yile neki-ka mange patha mamnga i le damngamut. Ngay-ka kardu marda warda ngurran i mere ngarra warda manangka wakal-ngimarda ngurrunu, nhini Yile neki-ka wakal warda damngamut. I nhini ngay-ka mere warda kurdungiwerdi nukunu ngarra kardu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Bere da nhini-re ngarra nigunu Elizabeth kardu putput wurrinidha da merrk da 6 warda kardidha, Yile neki kathu wurdanngethuk ku angel nhini da ngatha nukunu Gabriel-ya ngarra kardu mardinhpuy nan-nu-ya Mary pangamngeruy. Nigunu Mary kardidha-ka da Nazareth, da town kunungingki-ya da ngarra ngala nan-ya Kelili. I nigunu-ka kardu niye-niye nukunu-wa Joseph. Nukunu Joseph-ka kardu darntethbath nukunu nan King David. Bere peningintha nhini Mary i Joseph-ka mere da ngatha benanginthalettha i mere da ngatha kaningintharrittha. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bere ku angel nhini-ka pangamngeruy ngarra Mary i murrinh mamnge, “Ya Mary. Le warda thani. Pule ngala Yile neki-ka memnhimangkart i nukunu-ka kanam ngarra nhinhi.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mu nigunu Mary-ka werrerrmamngini i mere murrinh memartadha murrinh nhini ngarra mamnge-yu. I nhini-ka murrinh marda-re memnu mange nigunu, “Ngarra-nu murrinh kanhi mamnga karrim-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mu ku angel kathu-ka mamnge deyida ngarra nigunu, “Nga Mary, mere thenham. Yile neki-ka mange patha thathpirr nhinhi mampa memnhimangkart-yu i le dimpa. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nhinhi-ka kardu putput thurrunu i kardu wakal nugarn buympabatnu, i murrinh nukunu thuparlnu-ka Jesus-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I nukunu-ka kardu Pule ngala thathpirr purrunu. I nukunu-ka wakal nugarn ngarra Pule ngala Yile neki nukunu-wa paninu-yu. I Yile neki-ka bupaknu nukunu-yu kardu Pule ngala thathpirr pinu nginipunh King David mani-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I nukunu-ka bere matha wangu kardu Pule ngala pirranu ngarra kardu Jews, kardu parrarntethbath ngarra nukunu Jacob-ya. Nukunu-ka bere matha wangu pinu kardu Pule ngala thathpirr-yu,” ku angel kathu mamnge ngarra Mary-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mu nigunu Mary kathu-ka mamna ngarra ku angel, “Ngarra-re-wa kardu putput ngurrunu ngay-yu? Ngay-ka mere ngadha nganingintharrittha kardu nugarn-yu i ngay-ka mere da ngatha benanginthalettha kardu nugarn-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mu ku angel kathu-ka mamnge ngarra Mary, “Yile neki-ka kardu lurruth ngala-wa. I nukunu-ka purdumpathuknu Ngepan patha ngarra nukunu i ngarra nhinhi paninu i wakal pampamutnu. I kardu wakal nhini ngarra Ngepan patha thangunu buympabatnu-ka, nhini nukunu-ka wakal nugarn Yile neki nukunu thathpirr-wa purrunu nhini-yu. I nukunu-ka mange wiye-ka mere ngarra nukun kama kurru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bere ku angel kathu-ka mamnge deyida ngarra Mary, “Ya, Mary. Kardu darrikardu nhinhi Elizabeth nganaka? Nigunu-ka kardu kunugunu warda-wa, mu nigunu-ka kardu putput wardarra wurran, da-ka merrk 6 warda kanam. Da murntak warra-ka kardu wakal mere ngarra berdurdurttha kani da marra-re-yu, mu Yile neki kathu-ka damngemut weyida nhini-yu kardu wakal-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yile neki-ka lurruth ngala-wa i nukunu-ka mange terert warda ngatha mam wurran. I mange-ka mere ngarra nukun kurdubay, wurda da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bere Mary kathu-ka mamna, “Yu, Yile neki-ka Pule ngala ngay dimnga nhini-yu. I murrinh ngarra thathpi nukunu-ka ngay-ka marda-wa manganart ngurran nhini-yu, i murrinh manabathnu ngurru. Yu berengunh, murrinh pana ngarra nhinhi namnga-ka ngay-ka da-nu thathpirr murrinh-nu marda manganart,” Mary kathu-yu mamna ngarra ku angel-yu. Bere murrinh nhini thangunu-ka ku angel nhini-ka nungardurr warda kanampart warda Mary-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Bere Mary-ka dempirnturt nungardurr warda pirtpirt da matha nadha dini da Judea-nu warda wangu da ngarra palyirr-nganamarda ngarra dim da-ya, da ngarra Elizabeth i Zechariah kardinginthapuptha-ya. Bere nigunu nadha dini-ka da ngarra thelput peniningtha, i pangamngeruy ngarra kardu darrikardu nigunu kardu kunugunu nhini Elizabeth. I Mary kathu-ka mamnge, “Yu, le warda ngem kardu ngay-yu ngangamparuy-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bere murrinh ngarra Mary-re mamnge Elizabeth-ka wakal ngarra nigunu Elizabeth putput yungurrkurrktha-ka yibimputeth warda nhini-yu. I Ngepan ngarra Yile neki thangunu kanammardardi warda ngarra nigunu Elizabeth-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bere Elizabeth-ka le patha thathpirr diningedha i mamnge ngarra Mary, “Nga. Yile neki-ka memnhimangkart nhinhi-yu kardu ngarra palngun wurnangat thangunu kathu da ngarra ngala kanhi. I nukunu-ka le thathpirr dimpa i le deyida dimna ngarra wakal nhinhi buympabatnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bere Elizabeth kathu-ka murrinh numi deyida mamnge ngarra Mary, “Mary, nhinhi-ka kardu kale nukunu ngarra Pule ngala ngarra ngay nukun-yu. Yile neki-ka mange patha thathpirr mamnga kardu ngarra nhinhi-nu wurdanngathuk i thangamngaruy-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","I ngarra marra-re nhinhi thunungamngimardale-ka wakal kanhi ngarra marda nganthin ngarrim-ka le patha yudha i yibimputeth warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","I Mary, nhinhi-ka murrinh thathpi ngarra Yile neki thangunu namnabath murrinh thathpirr-wa mampa-yu i nhinhi-ka le warda thathpirr thaninu,” Elizabeth kathu-yu mamnge ngarra Mary. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bere Mary kathu-ka mamnge ngarra Elizabeth, “Ngay-ka ngarntiparl nganam Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","I ngepan ngay-ka le thathpirr warda nganam ngarra nukunu thangunu mamngiyibirnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngay-ka kardu mere muthingka kardu ngala, mu nukunu da matha bamngingkardu i memngimangkart-yu, i da nakurl-te kardu wurnangat da matha pariparlnu puru Yile neki, nhini nukunu-ka ngay thangunu mange patha thathpirr mamnga.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","I Mary-ka bere ngatha wangu murrinh medha pirri, i mam, “Yile neki-ka kardu ngala thathpirr-wa, i nukunu-ka kardu lurruth ngala thathpirr i patha da matha. I kardu mere nangkal mani kama kurru nginipunh nukunu-yu. Nukunu-ka mange patha thathpirr mamnga wurran. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yile neki-ka bere ngatha wangu dirranganpunpe kanam kardu wurnangat pana ngarra murrinh nukunu pubimnayewup pumpan i murrinh pumamnabath pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I nukunu-ka bere ngatha wangu mange lurruth ngala mam wurran. Nukunu-ka pirranputhnu purru kardu pana ngarra pumemnungala pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I kardu pana deyida wanku kardu pule ngala ngala-ya pepe da matha panthutthutnu kardu nhini-yu. I kardu pana ngarra ngathayida pumemnukunungingki pumpan-ka nukunu-ka manngalanu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I kardu pana ngarra mi mami parnam i nanhthi mananhthi parnam-ka nukunu Yile neki-ka parramutmutnu mi i nanhthi, i nhini kardu-ka banmardannu warda nhini-yu. I kardu pana ngarra nanhthi terert panthin pumpan-ka Yile neki kathu nanhthi purrkpurrk nhini paninmatkutnu-wa, i nhini kardu-ka purdunthukthuknu warda wunku nanhthi puruyeymanu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","“I Yile neki-ka mannhimanpi-warda-ngime i dirrangannhipengime wurran nekingime kardu ngarra tharntethbathngime ngalantharr nekingime nan-ya Israel. Nhini-wa murrinh Yile neki kathu-yu mampirruneme ngarra Abraham i kardu ngalantharr nekingime. Nukunu mam-ya, ‘Ngay-ka bere matha wangu ngirrananpenu ngurru.’” Nhini-wa murrinh nigunu Mary-yu murrinh darntiparl ngarra Yile neki wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bere nigunu Mary-ka pangu da ngadha kardinginthadha ngarra Elizabeth da merrk perrkenkuneme-nu-ya. I nhini thangunu-ka wurdantharr Elizabeth i nungardurr warda da ngarra thelput nigunu-nu warda wangu wurdawurl da nan Nazareth. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bere nhini thangunu kardu kunugunu pana nan Elizabeth-ka bamngebat warda kardu wakal nugarn. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I bere murrinh warda banalangtha wurrini pana-re kardu ngarra darrikardu nigunu Elizabeth da mana, i kardu ngarra ngamere da manta pana pardipuptha-yu. I kardu-ka le warda pardingedha, nhini Yile neki-ka mange patha da matha mamnge i wakal damngemut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bere da-ka 8 warda mam, i nhini kardu darrikardu peningintha-ka parrampirruruyngintha ngarra Zechariah i Elizabeth. I wakal peningintha-ka kardu warda puddanwit nhini-yu kardu nugarn-nu warda purrunu. I murrinh warda puyiparldha murrinh ngarra yile nukunu deyida mani Zechariah. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mu kale nukunu kathu-ka mampirra, “Awu, wurda-wa murrinh nhini-yu. Mu murrinh ngunginthaparlnu-ka John-wa.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mu kardu kathu-ka pumamnge, “Murrinh ngarra thangunu pana-yu? Kardu ngarra darrikardu nankungintha-ka mere nangkal ngadha mebaththa kani murrinh pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","I nhini thangunu-ka ngarra yileyile Zechariah-ya murrinh mange-re pumenadha pi i parrantharrpu warda, “Mu nangkal-wa murrinh thuparlnu kardu wakal-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bere nukunu Zechariah-ka murrinh mange-re mampirra nanhthi peypa-nu. I ngarra nanhthi peypa nhini-re darntilil murrinh-ka kanhi-wa, “Murrinh nukunu nguparlnu-ka John-wa.” I kardu kathu-ka pumemnamardart warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bere da nhini-re nukunu Zechariah-ka kardingerren-deyida-dha. Nukunu-ka kardu manangka murrinh kardidha i mere deyida themen denadhaptha ku angel thangunu-yu, mu kardu kardingerrentha warda i murrinh daniriparldha kardi ngarra Yile neki wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","I kardu darrikardu peningintha i kardu ngamere ngarra da manta pana pardipuptha-ka puyenthepup i perrenham ngala da matha nhini-yu. I murrinh nhini-ka banalangtha wurrini da pana ngangka-re ngarra kardu pardipuptha ngarra da palyirr-nganamarda nhini-re-yu da nan-ya Judea. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","I kardu ngarra murrinh nhini-re puyenthepup-ka murrinh warda pumenanudha purni, “Ya. Kardu wakal kanhi purdirurturtnu-ka kardu ngarra kama pamanu purru pana-yu?” Nhini-wa murrinh pumenanudha purni, nhini kardu-ka the-wa pumebaththa purni Yile neki dirrapedha kardi wakal nukunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Bere Ngepan Yile neki thangunu kanamnginirdi warda ngarra Zechariah, yile nukunu John-ya, i nhini-ka murrinh warda wurdampirruyithngime murrinh ngarra Yile neki thangunu-yu. I kanhi-wa murrinh mam-yu, ");
INSERT INTO mwf2018_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mampa, pariparl-warda-ngime Yile neki. Nukunu-ka kardu Pule ngala thathpirr-wa dinnhengime kardu ngarra nekingime-ya, kardu ngarra ngalantharr nan thangunu Israel tharntethbathngime. I nukunu Yile neki-ka wurrininhedhangime i mannhiyibirnungime. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","“I da murntak warra-ka kardu ngalantharr ku prophet-ya kanhi da murrinh pumerradha purni-yu, ‘Nga. Yile neki-ka purdunhethuknungime kardu nugarn kardu lurruth ngala, i nukunu kardu nhini-ka manhiyibirnunungime. I nukunu nhini-ka kardu parethbathnu ngarra King David thangunu kathu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I nukunu kardu nhini-ka manhiyibirnunungime kardu ngarra murlakpun thangunu kathu i kardu pana ngarra mere marda kumanhertngime kuru.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","“I ngana deyida Yile neki kathu-ka mamna ngarra nukunu pule Abraham da murntak warra-ya. I kanhi-wa murrinh ngarra nukunu kathu mamna ngarra Abraham-yu i kardu ngarra ngalantharr ngalantharr murntak deyida mampirruneme, ‘Ngay-ka ngirrananpenu ngani. I ngay-ka mananthibirnunu kardu ngarra pana thangunu kathu mere marda kumananart kuru. I nhini-ka mere ngarra warda nenmanham nukun nuru nhini-yu ngarra da mange ngay da matha nangimariwaknu nuru. I nhini nanki-ka da mange patha yuthpan da matha numabathnu nuru i kardu patha da matha nurunu da bere matha wangu-yu.’” Nhini-wa murrinh Yile neki kathu mampirruneme-yu i murrinh mere panayekumtha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","I bere nukunu Zechariah-ka bere ngatha wangu murrinh medha pirri, “I nga, muluk,” mamna ngarra wakal nukunu-nu. “Nhinhi-ka kardu bere matha wangu murrinh ngarra Pule ngala Yile neki thangunu thurdirrayithnu thurru, ku prophet-wa nhinhi thurrunanu-yu. I nhinhi-ka da nakurlnu-wa kumparra warra thununanu thi ngarra kardu pule ngala pana ngarra kardu tiduk warda kathu pununu pi. I nhinhi-ka thurdunthethithnu thurru kardu murrinh ngarra Yile neki nukunu-yu, i nhini kardu-ka pumenawathawathanu i parninamardamardanu kardu Pule ngala pana-nu ngarra tiduk nimin parraruynu purru. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","I nhinhi-ka murrinh thanthelerrnu thurru kardu pana-nu Yile neki kardu manmayerrarrnu purru da ngarra mange wiye thangunu panthin parnam i kardu warda manthibirnunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","I bere nukunu Zechariah-ka murrinh bere ngatha wangu medha pirri, “Yile neki-ka marda thathpirr mangannhertngime dim. I nukunu-ka purdunhethuknungime kardu Pule ngala nhini da kangkarl thangunu kathu. I nukunu nhini-ka manhimayerrarrnungime da mange wiye ngarra nekingime thanthinngime thurran i manhiyibirnunu-warda-ngime. I nukunu Pule ngala nhini-ka da thathpirr warda panhengkardanungime da ngarra Yile neki nukunu wangu, i nhini-ka kardu watmam purrunungime i marda pekpek da matha paninungime. I ngarra Pule ngala nhini purrunu kathu-ka, da nginipunh nanhthi ngunga marra deyida kathu mani punhengkapurlnungime, i mere warda pinungime da ngarra thipmam binhi wangu-yu.” Nhini-wa murrinh Zechariah mamna ngarra wakal nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bere nhini thangunu-ka kardu wakal nugarn nhini John-ya kardu wurdanturturt lurruth ngala da matha nanhthi nginipunh nukunu i ngepan nukunu. I nukunu-ka marda merttha wurrini da mange ngarra Yile neki nukunu wangu. I nukunu da kardipuptha-ka ngarra da darrinpirr pularn i ngarra demnungkarr da mana. I nhini-ka pangampirraruy warda ngarra kardu-yu, kardu ngarra parrarntethbath nukunu Israel, kardu Jews-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Bere nukunu Caesar Augustus-ka ku pule ngala thathpirr dinirradha ngarra kardu wurnangat warda ngatha kardu Jews-ya, i kardu wurnangat ngamere deyida, kardu manangka thathpirr Jews-ya. Bere nukunu nhini-ka kardu ngarra nukunu thangunu kathu wurdanpunkuthukneme da pana ngangka-re purnewatthaneme i kardu-nu purnintiwudha purni i murrinh ngarra kardu-nu parrinintilildha purni ngarra nanhthi peypa wardarra dinindarriwuptha wurrini kardu wurnangat warda ngatha kardu nukunu-wa-nu Caesar Augustus the thathpirr manmathnu. Mu da murntak warra-ka mere nangkal ngadha kardu puyntiwudha i mere murrinh dentilildha wurri murrinh ngarra kardu wurnangat warda ngatha-yu, wurda. Bere da nhini-re-ka nukunu nan Quirinius ku pule ngala dinirradha da ngarra nan-ya Siriya. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bere nhini thangunu-ka kardu wurnangat warda ngatha parranirurtuydha purni ngarra da town pigunu i murrinh parrinintilildha purni ngarra nanhthi peypa. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Bere peningintha Joseph i Mary-ka da ngarra nan thangunu kathu Nazareth nungamnginthardurr da ngarra ngala pirrimpirra Kelili, i nanginthadha dini da ngarra Bethlehem-nu warda wangu da ngarra ngala pirrim Judea-ya. I pangamngintharuy murrinh-nu pankurililnungintha. Da pangu Bethlehem-ka da nukunu King David-wa, i nukunu Joseph-ka kardu darntethbath ngarra nukunu King David i da-ka da nukunu deyida wanku nhini-yu. Bere kardu niyeniye nukunu Joseph-ka Mary-wa, i nigunu-ka kardu putput warda wurrinidha da nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bere ngarra peningintha-re dininginthadha da pangu Bethlehem-ka nigunu Mary-ka kardu warda wakal buyngebatnu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Peningintha-ka da-nu mana warda kaninginthardidha ngarra da thelput ngala nhini-yu dininginthadha, mu nhini-ka kardu wurnangat weyida menadhalerttha wurrini da-yu. Mu nhini kanamnginthardi-ka da ngarra thelput ku puliki nukun weyida nhini-yu. Bere dininginthadha da nhini-ka kardu wakal nugarn bamngebat Mary-yu. Wakal marra-re bamngebat-ka nhini-wa. I bere nigunu-ka panpekarl warda wakal nhini-yu nanhthi kaligu purrkpurrk-te i yingammardapup ngarra nanhthi box mi parnu wanku ngarra ku puliki nukun. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bere da ngarra manta pangu da ngatha Bethlehem-ka, kardu nugarn pirapedhaneme parde ku thip peneme da thipinhi nhini da ngatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","I ku angel ngarra Yile neki thangunu pangampirruruyneme i thungku layit ngala da matha ngarra Yile neki thangunu kathu dampunkularrangneme. I nhini kardu peneme-ka puninkungkawerrdha-warda-neme kardi. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mu ku angel kathu-ka mampirruneme, “Ya. Mere nenhamneme. Ngay-ka murrinh thelerrdhe patha nimin-ya menarrubaththaneme ngurrini i nganankuyerrnemenu, i nhini nankuneme-ka le thathpirr warda narnenemenu. Murrinh thelerrdhe patha kanhi-ka kardu wurnangat warda ngatha-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nga. Da thipinhi marra kanhi-ka kardu wakal nugarn bammat da town kunungingki pangu wangu-yu da ngarra King David kardipuptha-ya. Kardu wakal nhini-ka Christ-wa, kardu pana ngarra Yile neki kathu wurdannarrathuk nankuneme-nu-yu i kardu wurnangat deyida-nu wanku. Nukunu-ka kardu Pule ngala thathpirr-wa purrunarranu, i nukunu-ka pirrananmaputhnu purru da mange ngarra wiye nanthin numpan i mananthibirnunu warda purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","I nga. Da-ka kanhi-re-wa kardu wakal pangu-yu nubardurtnemenu-yu. Nunnanemenu da ngarra town pangu wangu i nubardurtnemenu kardu wakal nhini-yu yibimngurrkurrk ngarra nanhthi box mi parnu ngarra ku puliki nukunu da ngarra thelput nhini-yu. Kardu wakal nhini-ka yibimngurrkurrk i panpekarl-wa yibim nanhthi kaligu purrkpurrk-te,” ku angel kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bere nhini thangunu-ka ku angel wurnangat warda thathpirr da ngarra kangkarl thangunu kathu parramnaruy ngarra ku angel numi nhini-dha warra pangampirruruyneme. I ku angel terert warda ngatha murrinh parraniriparldha pardi ngarra Yile neki wangu-yu. I kanhi-wa murrinh pumedha pardi, ");
INSERT INTO mwf2018_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pule ngala pangu dim-ka kardu ngala-wa thathpirr. Mampa nga. Pariparl warda nukunu-yu. I kardu pana da matha ngarra nukunu kathu le dimpirra-ka marda pekpek warda purunu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bere nhini thangunu ku angel-ka pumpannurdurr warda i puddalath da ngarra kangkarl warda wangu da Heaven-ya. Bere kardu nugarn nhini-ka murrinh warda pumemnungkuneme mange peneme ngatha, “Ka. Purru-wa-neme da pangu wangu Bethlehem i pubangkardunemenu kardu wakal nhini ngarra murrinh ku angel mannheneme murrinh ngarra Yile neki thangunu wurdannhemathukneme-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bere peneme nhini-ka punnungamkardurr-warda-neme da Bethlehem-nu warda wangu pirtpirt da matha. I nhini da pubangampunkurdurtngintha Mary i Joseph-yu wunku kardu wakal nhini yungurrkurrktha ngarra nanhthi box mi parnu ku puliki nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bere ngarra wakal nhini thangunu pubamkangkarduneme-ka murrinh warda parrinthelerrdha purni murrinh ngarra ku angel mampirruneme-yu murrinh nhini da kardu wakal nugarn nhini bammat-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","I kardu-ka pumempirrumardat-warda-neme murrinh thathpi ngarra peneme nhini thangunu pubimpirruyepupneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bere nigunu Mary-ka da warda wurdantherr da ngarra marra-re nhini-yu ngarra ku angel pangamngeruy i da ngarra wakal nhini da mana bamngebat. I bere matha wangu benayengkarnirntha warda wurrini nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bere nhini thangunu peneme nhini-ka puddamkawurlneme pangu deyida ngarra ku thip peneme. I murrinh ngala da matha parrineriparldhaneme purne ngarra Yile neki wangu, nhini-ka pubamkangkardu-thangunu-weyida-neme i pubimkayepupneme nginipunh murrinh pangu deyida mani ngarra ku angel thangunu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bere da ngarra 8 warda mam ngarra wakal nugarn nhini thangunu bammat-ka, kardu warda puddanwit nhini-yu kardu nugarn-nu warda purrunu. I peningintha nhini murrinh pannginthaparl-ka murrinh nukunu-ka Jesus-wa. Nhini-wa murrinh-yu mamngengkawadha ku angel kathu da marra-re ngarra Mary-yu ngarra kardu manangka marda da ngatha kardidha. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Bere kardu ngalantharr pana nan Moses darntilil murrinh law Yile neki nukunu da murntak warra-ya. I kardu Jews-ka bere matha wangu murrinh law nhini pumebaththa purni. I murrinh law numi-ka kanhi-wa. Kardu kalekale pana ngatha kardu wakal marra bamngebat-ka nhini nigunu-ka mere ngadha kurru pangu kanirdi ngarra murrinh church ngala da-ka merrk numi-wa i kanganu. I da nhini thangunu nigunu-ka mangkadhuk kurru ku yinhpi perrkenku ngarra ku yilarn-nu ngarra da church. I nukunu warda ku kubat-yu i pinanapek-yu ngarra Yile neki-nu-yu. I nhini thangunu nigunu-ka mengeyerrarr warda i nhini nigunu-ka kanirdi warda ngarra murrinh church ngala nhini-yu. Nhini-wa murrinh law numi-yu. Bere peningintha nhini Mary i Joseph-ka wunku wakal Jesus-ya parnamkapartngime da nhini-yu Bethlehem i da Jerusalem-nu warda wangu punnadhangime nigunu Mary-nu kardu mengeyerrarrnu. I ngana deyida nanginthadha dini Jesus-nu manginthabertinu purru ngarra murrinh church ngala pangu-yu i Yile neki panginthangkarrnu i panamutnungintha panginthariparlnu wakal nhini-nu-yu. Nhini deyida murrinh law numi nukunu Moses darntilil-yu kardu wakal nugarn kumparra kanthinginthangkarr i kanamutngintha ngarra Yile neki wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bere da nhini-re kardu ngalantharr numi kardidha ngarra murrinh church ngala-yu. Murrinh nukunu-ka Simeon-wa i nukunu kardipuptha-ka da Jerusalem da. Nukunu Simeon-ka kardu patha da matha wurrinidha i bere matha wangu murrinh thathpi Yile neki menabaththa kardi. I Ngepan Yile neki-ka bere matha wangu kardidha ngarra nukunu-yu. Bere nukunu-ka kardimardamardadha da ngarra minthire-nu Yile neki purduthuknu-yu kardu pule ngala pana kardu manthibirnunu kardu Jews-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","I Ngepan Yile neki mamna nukunu-ka panibirnu da matha-nu ngarra nukunu Christ da mana bangkardunu kardu pana ngarra Yile neki purduthuknu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bere ngarra Mary i Joseph parramkaruyngime i wakal-nu panginthangkarrnu i panamutnungintha ngarra Yile neki, bere da nhini-re-ka Ngepan Yile neki mamna Simeon-yu, “Thurrunu pangu ngarra church ngala.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bere Simeon-ka wurrinidha ngarra church ngala nhini da i bampunkungkardungintha Mary i Joseph i wakal Jesus. I wakal nhini-ka manganmert warda i kanthinumardadha pirri i Yile neki warda darntiparl. I kanhi-wa murrinh thathpi daniriparldha pirri-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yile, nhinhi-ka Pule ngala da matha. I murrinh thathpi nhinhi-ka murrinh da thathpirr nhini-yu. Kanhi-wa kardu wakal murrinh nhinhi nam-yu thurdungarrathuknu-yu. Ngay-ka ngardinamardamardadha nukunu kanhi-nu-yu. I nhini ngay-ka bamkardu warda i nhini-ka berengunh ngay ngupupnu warda-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ngay-ka marra kanhi-ka bamkardu warda kardu wakal kanhi ngarra thurdanngarrathuk kardu-nu-yu. Nhinhi thurdanngarrathuk-ka kardu-nu manganthibirnunu. Kanhi-ka da ngarra mange nhinhi da matha wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I nukunu kardu wakal kanhi-ka kardu manangka Jews deyida wanku purrunmetkutnu ngarra nhinhi-nu wangu i kardu manthibirnunu. I kardu nhini manangka Jews-ka pantiparlnu warda parni kardu Jews kardu ngarra nhinhi-yu.” Nhini-wa murrinh tiparlti Simeon mamna ngarra Yile neki wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bere peningintha Mary i Joseph-ka pumemnamardatngintha ngarra murrinh nukunu Simeon menadha pirri ngarra kardu wakal nugarn nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Bere nukunu Simeon kathu-ka mampirrungintha murrinh thathpi kanhi-yu, “Yile neki-ka pirranankupenungintha pani i mange patha da matha manarrunungintha purru.” I bere ngarra Mary warda kalekale Jesus-ya mamnge, “Nga. Yile neki-ka wurdanthuk wakal kanhi-yu da kanhi da-nu. I da nakurlnu-wa kardu the pumabathnu-yu Yile neki wurdanthuk nukunu-yu. I kardu Jews wurnangat da matha murrinh thathpi nukunu pumanabathnu puru-yu i pariwaknu puru. Mu kardu Jews terert deyida mere murrinh pumanabathnu puru-yu ngarra murrinh thathpi nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","I kardu nhini-ka murrinh pumardarrithaknu parni, mu nukunu-ka kardu mukmuk banmarderdenu purru i kardu-ka murrinh marranu purru murrinh nhini ngarra banmarderdenu purru-yu. I nga Mary,” mamnge. “Nhini-ka da-ka tetemanthay-wa-nu dardurtnu nhinhi-nu-yu i panhimardathinnu purru-yu. Nhini-ka da-ka nginipunh thu nayp deyida mani panhiwarlnu ngarra magulkul nhinhi-nu-yu.” Nhini-wa Simeon kathu-yu murrinh mamnge ngarra nigunu Mary-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Bere da ngarra church ngala nhini-ka kardu muthingka kunugunu thathpirr kardidha pangu da. Murrinh nigunu-ka nan-wa Anna. I yile nigunu murrinh-ka nan-wa Phanuel. Nukunu-ka kardu yek Asher-wa. Bere da marra-re nigunu-ka demnginthalet kardu nugarn-ka da thangku 7 kardinginthadha-yu. I nukunu yibimpup-ka nigunu-ka kardu mekmunurr warda wurrinidha da-ka da thangku 84-wa. Bere nigunu-ka kardu bere matha wangu kardinangerrentha ngarra Yile neki wangu i daniriparldha wurrini pangu da ngarra murrinh church ngala-yu. I da ngamere ngadha-ka mi-ka mere ngadha wurrimurrktha nhini-ka ngarra Yile neki ngadha kardinangerrentha wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bere kardu kunugunu nhini Anna-ka wurrinirrudhangintha ngarra Mary i Joseph i Yile neki darntiparl wakal nugarn nhini-nu wurdanthuk-yu. I kardu ngarra Jews terert warda wurdampirrayith murrinh ngarra wakal nhini Jesus-nu-yu. Kardu Jews nhini-ka kardu ngarra pardinamardamardadha kardu pana-nu ngarra Yile neki purduthuknu-yu i kardu manthibirnunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bere nhini thangunu-ka Mary i Joseph-ka mamngintharikerdek warda mange nhini menginthadha kardi-yu mange ngarra Yile neki nukunu wangu-yu da ngarra murrinh church ngala pangu-yu. Bere nhini thangunu-ka punnadha-warda-ngime da ngarra peningime-nu warda wangu da nan-ya Nazareth da ngarra ngala pangu nan-ya Kelili. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","I nhini da nukunu Jesus wurdanarurturttha kardi-yu lurruth ngala da matha i kardu pelpith patha. I da mange ngarra Yile neki da matha nukunu daniriwaktha wurrini-yu. I Yile neki-ka bere matha wangu dirrapedha kardi i le da matha kardinadha ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bere da thangku terert Mary i Joseph-ka pirringinthawattha da Jerusalem i mi lawam werlpen pulleth wunku kardu Jews wurnangat da ngarra nan-nu-ya Passover. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bere ngarra nukunu mana Jesus thangku 12 warda mam wurrinidha-ka pangu deyida punnadhangime da Jerusalem da ngala nhini-nu da nan Passover. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bere da ngarra nhini mana Passover dirntal-ka peningintha Mary i Joseph i kardu wurnangat-ka pumenardarrarrdha warda pi puddanalaththa pi da ngarra pigunu warda wangu. Mu nukunu Jesus-ka pangu da ngatha kardidha da nan Jerusalem. Mu Mary i Joseph-ka menanginthabiyedha kardi mere the menginthabaththa wurri Jesus pangu da ngatha kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Peningintha-ka mamngintha mana nukunu-ka wurrannilili kardu ngarra ngamere mana-wa. Bere puy purnililidha i ngarra ngunga kanarnum da mana. I bere Mary i Joseph-ka pannginthawinhay i kardu warda piranawinhadhaththangintha purne Jesus-nu kardu ngarra terert. I kardu darrikardu peningintha i kardu ngamere deyida wanku parraninkudharrpudhangintha purne i menginthadha wurrini murrinh-yu, “Ya. Jesus-ka nubamkardu ngadha?” “Awu wurda, makardu,” pumerrudhangintha purni. I bere mere warda ngarra benginthardurttha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bere nhini thangunu-ka wurdamnginthawurl deyida da pangu-nu Jerusalem i da pana ngangka-re piranawinhadhaththangintha purne. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bere da perrkenkuneme mana mam-ka bangamnginthardurt Jesus-yu pangu dinidha ngarra murrinh church ngala wunku kardu ngalantharr pana ngarra murrinh law puddinthethiththa purni. Nukunu-ka binarruyepupthaneme dini murrinh ngarra thathpi peneme-yu i murrinh daninkudharrpudhaneme dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","I kardu wurnangat ngarra murrinh Jesus pubimnayepup-ka i kardu warda pumemnamardat da matha murrinh ngarra thathpi nukunu-yu. I pumenanudha purni, “Ya. Nubinayepup kardu kigay pangu kempirrungerrenneme kardu ngarra ngalantharr pangu. Nukunu-ka kardu mukmuk ngala thathpirr kanthin wurran.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","I peningintha Mary i Joseph-ka pumemnamardat-deyida-ngintha ngarra murrinh thathpi Jesus merrudhaneme dini-yu. Bere Mary kathu-ka mamna ngarra Jesus, “Ya, muluk. Thangku-nu thanam kanhi da ngatha-yu? Thangku-dha mere thurridha ngarra ngankungintha-yu? Ngankungintha-ka ngampawerrngintha nhinhi-nu i da pana-re ngirampawinhadhaththangintha ngurne-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mu Jesus kathu-ka mampirrungintha, “Thangku-nu-wa ngay nirangawinhadhaththangintha nurne-yu? Nankungintha-ka the-wa nenginthabaththa nhini-yu ngay da kanhi ngarra thelput Yile ngay nukun ngani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mu peningintha-ka mere menginthamartadha murrinh pangu ngarra Jesus mampirrungintha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bere nhini thangunu Jesus-ka nungardurr warda da nhini thangunu i wunku Mary i Joseph puddamkawurlngime da ngarra nan-ya Nazareth. Bere nukunu Jesus-ka murrinh thathpi ngarra kalekale i yileyile bere matha wangu merrubaththangintha wurrini. Bere nigunu Mary-ka bere ngatha wangu benayengkarnirntha wurrini ngarra mange Jesus medha wurrini murrinh ngarra thathpi nukunu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bere nukunu Jesus-ka puy wurdanarurturttha wurrini i ngarra kardu nugarn da mana. I nukunu-ka mukmuk patha da matha mebaththa wurrini. I Yile neki-ka le da matha kardinadha i kardu deyida wanku le pardinadha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Bere nukunu John the Baptist, wakal nukunu nan Zechariah-ya da pangu da ngatha kardidha da ngarra darrinpirr pularn. Bere Yile neki kathu wurdamnayith mamna ngarra nukunu i wurdanthuk da ngarra manta ngipilinh ngala pangu-ya da nan Jordan. I nukunu-ka murrinh thathpi Yile neki thangunu wurdanarrayiththa wurrini ngarra kardu-yu. Bere da nhini-re-ka ku pule ngala thathpirr dinirradha-ka nan-wa Tiberius ngarra kardu wurnangat warda ngatha. I nukunu dinirradha-ka da-ka thangku 15-wa. I da nan Judea-ka ku pule ngala dinirradha-ka nukunu nan-wa Pontius Pilate. I da nan Kelili-ka ku pule ngala dinirradha-ka nukunu nan-wa Hered. I da penintha nan Iturea i Trachonitus-ka ku pule ngala dinirradha-ka nukunu nan-wa Philip. Nukunu-ka ngathan nukunu Hered-wa. I da nan Abilene-ka ku pule ngala dinirradha-ka nan-wa Lysanias. I ku yilarn ngala thathpirr dinininthadha-ka nukunu nan-wa Annas i nukunu Caiaphas-wa. Bere da nhini-re-ka ngarra ku pule ngalangala nhini pirrinirradha ngarra kardu-ka Yile neki wurdanthuk nukunu John the Baptist-yu da pana ngangka-re-ya ngarra da manta ngipilinh Jordan. I nukunu merradha wurrini ngarra kardu murrinh thathpi Yile neki thangunu, “Nga, kardu,” merradha wurrini. “Nanki-ka narnipartnu warda da mange wiye-yu ngarra numammath numpan-yu i pananmardathinnu. I nhini Yile neki-ka mananmayerrnu da mange wiye pana ngarra nanthin numpan-yu i ngay-ka ngananluluwewunu warda ngurru.” Nhini-wa murrinh merradha wurrini ngarra kardu-yu nukunu John-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bere da murntak warra kardu ngalantharr pana nan Isaiah murrinh thathpi Yile neki wurdanarrayiththa wurrini. I nukunu da darntilil John-nu kurrunu kathu-yu kardu-nu bunyithithnu i manpathawathanu kardu Pule ngala-nu ngarra Yile neki wurdanthuk-yu da ngarra putek kanhi-yu. I kanhi-wa murrinh thathpi darntilil Isaiah-yu ngarra nukunu John the Baptist purrunu kathu-yu, “Kardu nugarn bere matha wangu panikaykaynu ngarra darrinpirr pularn. Nukunu-ka panirrakaykaynu ngarra kardu murrinh kanhi-nu, ‘Ya, marranu kardu-yu. Mayern numanawathawathanu kardu Pule ngala-nu tiduk kathu purrunu. Mayern nubunayithithnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“‘I nubanamardabirrnu nuru da pewertipewerti-yu i nubanaweturuthturuthnu nuru da pana ngarra putek pangkuy-pangkuy i ngarra da murruwurldarri da mana pungurrkurrknu. Nubunayithithnu nuru da ngarra mayern durdurdurtmam-yu i numanardarrimurruwurlnu da ngarra mayern pewertipewerti-yu. I numanawathanu mayern-yu punangurrkurrknu wardarra kardu numi pana ngarra Yile neki purduthuknu tiduk kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","I nhini-ka kardu pubangkardunu warda kardu Pule ngala nhini-yu kardu ngarra mananthibirnunu-yu da ngarra mange wiye thangunu-yu, i nhini-ka purdunarrawurlnu ngarra Yile neki wangu-yu.’” Kanhi-wa murrinh thathpi kardu ngalantharr pangu nan Isaiah darntilil ngarra John the Baptist-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bere kardu wurnangat punninadha ngarra nukunu-nu John the Baptist kardu panluluwewunu pirra. Mu John the Baptist kathu-ka mampirra, “Ya. Nanki-ka nginipunh ku pangkuy murlak mani. Nanki kanhi nunningadha-ka ngay-nu ngananluluwewunu ngirra i nhini Yile neki-ka mere punanmatnu warda nhini-yu. Mu nhini-ka manangka mange-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nanki-ka da mange wiye da ngatha numammath numpan. Mu marra-re nanki-ka narnipart-wa-nu da mange wiye nhini-yu i da mange patha da matha numabathnu nuru nhini kardu-ka the warda pumananmathnu da mange wiye nhini thangunu narnipartnu-yu. I nga, mere nubeyengkarnirn nuru Yile neki le dimnarra-yu nhini nanki-ka kardu narrarntethbath kardu ngalantharr pana Abraham. Yile neki-ka nanhthi palyirr kanhi ngatha yida-ka kurdethkath-wa i kardu kuyu mani-ka nhini-ka kardu ngarra Abraham thangunu warda parrarntethbath. Yu, nhini Pule ngala thathpirr Yile neki-ka le dininadha ngarra nukunu Abraham-yu mu nanki-ka mere le-wa kinarra nhini nanki-ka da mange wiye da ngatha nanthin numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Ya,” mampirra, “The mana nanthin-ya thay mi dhepdhep-yu. Nanhthi thay mi dhepdhep mani mi wiye kinthatut-ka nhini kardu mani-ka lithpurr kukangkat ngarra thay ngimalmin pepe kathu i kinapek ngarra thungku. I nginipunh nhini deyida mani nanki-yu numamyit numpan da mange wiye. I nhini Yile neki-ka punanmatnu i pirrananputhnu ngarra thungku ngala wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bere kardu kathu-ka pumamna ngarra John the Baptist-yu, “Mu nganki-ka ngarra nimin ngiyemanu mange-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mu John the Baptist kathu-ka mampirra, “Da-ka kanhi mani-wa niyemanu nuru-yu. Nanhthi shirt perrkenku ngatha numammath numpan-ka nhini-ka nanamut nanhthi numi-yu kardu ngarra shirt mananhthi kanam. I ngana deyida mi dhepdhep ngatha nanthin numpan-ka nhini nanamut mi-yu kardu ngarra mami kanam,” mampirra John the Baptist kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bere nhini thangunu-ka kardu ngamere deyida wanku punninadha ngarra nukunu-nu John the Baptist kardu panluluwewunu pirra. Kardu nhini-ka ku mani punninmatkuttha ngarra kardu thangunu ku Government-nu. Bere kardu nhini-ka murrinh nhini da ngatha parrantharrpu John the Baptist-yu i pumamna, “Nga, pule. Nganki-ka ngarra nimin ngiyemanu nguru-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mu nukunu John the Baptist kathu-ka mampirra, “Bere ngatha wangu nurunmatkutnu ngarra kardu thangunu ku Government-nu ku mani-yu. Mu mere numankapdap nukun nuru ku mani ngarra kardu thangunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bere nhini thangunu-ka ku soldier warda punninadha ngarra nukunu-nu John the Baptist. I murrinh nhini da ngatha parrantharrpu i pumamna, “Ya. Mu nganki-ka? Ngarra deyida ngiyemanu nguru-yu?” Mu John the Baptist kathu-ka mampirra, “Nga. Kardu-ka mere nunthuk nukun nuru i ku mani mere nurunmatkat nukun. I kardu murrinh mere nukun numandarrithak i ku mani mere numankapdap nukun. I ku mani pay nanki-ka le da matha nuru nhini-yu ngarra ku pule nanki thangunu kanarramutmut kuru-yu,” John the Baptist kathu-yu mampirra ngarra ku soldier. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bere kardu wurnangat nimin-ya pubinanayewuptha punni-yu murrinh thathpirr ngarra John the Baptist-yu murrinh Yile neki thangunu-ya. I kardu-ka murrinh warda pumenanudha punni, “Ya. Nukunu da matha kama-ya kardu kanhi Christ-yu-ya. Kardu pana ngarra Yile neki wurdanthuk-ya. I nukunu kama manhiyibirnunungime.” Murrinh nginipunh nhini mani-wa kardu-yu pumenanudha punni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mu John the Baptist kathu-ka mampirra, “Ya. Ngay-ka kardu mere pule ngala kanhi-yu. Mu kardu pana ngarra tiduk kathu pununu pi-ka nukunu nimin kardu Pule ngala thathpirr-yu. Ngay-ka mere mani ngurdimerereth ngarra me sandal nukunu-yu. Nhini ngay-ka wurdanngiwerdi ngemmanham-wa nhini-yu. Nukunu-ka kardu Pule ngala thathpirr warda nhini-yu. Ngay-ka berengunh nganinanluluwewudha ngurrini kura patha da matha-re mu nukunu nhini-ka bunannginirdinu Ngepan ngarra Yile neki-yu. I ku Ngepan nhini-ka nginipunh thungku deyida mani i pinananmapeknu purru da ngarra mange wiye nanki wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“I nga.” John the Baptist kathu-yu mampirra deyida. “The mana nanthin mi-ya i da mange ngarra mi pumamyerryerr pumpan nanhthi darripi ngernu i mi kamarl thathpirr-ya. I nhini thangunu-ka parnammardawu ngarra nanhthi pot i panthin ngadha pirrim. Mu darripi ngernu-ka pinnangampek pangu wangu ngarra thungku. I bere kardu pana ngarra tiduk kathu pununu pi-ka kardu-ka nginipunh gardener nhini mani-wa. Nukunu-ka kardu manyerryerrnu purru kardu patha i kardu wiye. I kardu pana ngarra da mange wiye panthin pumpan-ka pirranputhnu ngarra thungku ngala wangu, thungku nhini mere ngarra ngadha kingkan,” nukunu John the Baptist kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bere murrinh thathpi nginipunh nhini mani-wa wurdanarrayiththa wurrini-yu ngarra kardu-yu. I bere matha wangu merradha wurrini, “Nga, kardu. Nanki-ka numenawathawathanu nuru kardu Pule ngala thathpirr nungam kathu dim.” Kanhi-wa murrinh thelerrdha patha-yu ngarra nukunu John the Baptist daninthelerrdha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bere nhini thangunu nukunu John the Baptist-ka murrinh menadha kardi ngarra pule ngala Hered, “Nga, nhinhi-ka namyit thurran-ka da mange wiye da matha. Nhini-ka mange wiye-wa nhinhi i kardu malla nanganmert palngun ngarra ngathan nhinhi nukunu-yu,” John the Baptist kathu-yu menadha kardi. Nhini da da mange wiye nukunu Hered medha kardi-yu i da mange wiye ngamere deyida wanku medha kardi. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","I da mange wiye numi deyida nukunu kathu mamna ngarra John the Baptist-yu. Nukunu-ka banurdi John the Baptist ngarra jail warda, nhini-ka murrinh menadha ngunu weyida kardi nukunu wangu John the Baptist-yu nukunu Hered-ka da mange wiye da matha mebaththa wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bere da nhini-re ngarra nukunu John the Baptist daninluluwewudha wurrini kardu i nukunu Jesus deyida wanku daluwewu. I nhini thangunu Jesus-ka pirrinangerrentha ngarra Yile nukunu wangu i nhini-ka nanhthi marnirra i kalakkalak memnadharl warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","I Ngepan ngarra Yile neki thangunu-ka wurdamnathut ngarra Jesus-yu mangini ku kuluntutuk-wa wurdanthut-yu. I Yile nukunu kathu-ka mamna warda ngarra Jesus-yu, “Nhinhi-ka kardu wakal nugarn ngay-wa. Ngay-ka marda-wa thathpirr manganhert ngurran. I le da matha ngurranpa nhinhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bere ngarra Jesus-te pantet murrinh thathpi ngarra Yile neki thangunu wurdanarrayiththa wurrini-ka nukunu da-ka da thangku nukunu-ka 30-wa wurrinidha-yu. Bere kardu pumedha mana-wa punni Joseph mana-wa Yile nukunu Jesus-yu. Bere Joseph nhini-ka yile nukunu-ka nan-wa Heli. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","I yile nukunu Heli-ka nan-wa Matthat. I yile nukunu Matthat-ka nan-wa Levi. I yile nukunu Levi-ka nan-wa Melchi. I yile nukunu Melchi-ka nan-wa Jannai. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","I yile nukunu Jannai-ka nan-wa Joseph numi deyida. I yile nukunu Joseph-ka nan-wa Mattathias. I yile nukunu Mattathias-ka nan-wa Amos. I yile nukunu Amos-ka nan-wa Nahum. I yile nukunu Nahum-ka nan-wa Esli. I yile nukunu Esli-ka nan-wa Naggai. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","I yile nukunu Naggai-ka nan-wa Maath. I yile nukunu Maath-ka nan-wa Mattathias numi deyida. I yile nukunu Mattathias-ka nan-wa Semein. I yile nukunu Semein-ka nan-wa Josech. I yile nukunu Josech-ka nan-wa Joda. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","I yile nukunu Joda-ka nan-wa Joanan. I yile nukunu Joanan-ka nan-wa Rhesa. I yile nukunu Rhesa-ka nan-wa Zerubbabel. I yile nukunu Zerubbabel-ka nan-wa Shealtiel. I yile nukunu Shealtiel-ka nan-wa Neri. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","I yile nukunu Neri-ka nan-wa Melchi numi deyida. I yile nukunu Melchi-ka nan-wa Addi. I yile nukunu Addi-ka nan-wa Cosam. I yile nukunu Cosam-ka nan-wa Elmadam. I yile nukunu Elmadam-ka nan-wa Er. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","I yile nukunu Er-ka nan-wa Joshua. I yile nukunu Joshua-ka nan-wa Eliezer. I yile nukunu Eliezer-ka nan-wa Jorim. I yile nukunu Jorim-ka nan-wa Matthat numi deyida. I yile nukunu Matthat-ka nan-wa Levi numi deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","I yile nukunu Levi-ka nan-wa Simeon. I yile nukunu Simeon-ka nan-wa Judah. I yile nukunu Judah-ka nan-wa Joseph numi deyida. I yile nukunu Joseph-ka nan-wa Jonam. I yile nukunu Jonam-ka nan-wa Eliakim. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","I yile nukunu Eliakim-ka nan-wa Melea. I yile nukunu Melea-ka nan-wa Menna. I yile nukunu Menna-ka nan-wa Mattatha. I yile nukunu Mattatha-ka nan-wa Nathan. I yile nukunu Nathan-ka nan-wa David. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","I yile nukunu David-ka nan-wa Jesse. I yile nukunu Jesse-ka nan-wa Obed. I yile nukunu Obed-ka nan-wa Boaz. I yile nukunu Boaz-ka nan-wa Salmon. I yile nukunu Salmon-ka nan-wa Nahshon. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","I yile nukunu Nahshon-ka nan-wa Amminadab. I yile nukunu Amminadab-ka nan-wa Admin. I yile nukunu Admin-ka nan-wa Arni. I yile nukunu Arni-ka nan-wa Hezron. I yile nukunu Hezron-ka nan-wa Perez. I yile nukunu Perez-ka nan-wa Judah numi deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","I yile nukunu Judah-ka nan-wa Jacob. I yile nukunu Jacob-ka nan-wa Isaac. I yile nukunu Isaac-ka nan-wa Abraham. I yile nukunu Abraham-ka nan-wa Terah. I yile nukunu Terah-ka nan-wa Nahor. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","I yile nukunu Nahor-ka nan-wa Serug. I yile nukunu Serug-ka nan-wa Reu. I yile nukunu Reu-ka nan-wa Peleg. I yile nukunu Peleg-ka nan-wa Eber. I yile nukunu Eber-ka nan-wa Shelah. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","I yile nukunu Shelah-ka nan-wa Cainan. I yile nukunu Cainan-ka nan-wa Arphaxad. I yile nukunu Arphaxad-ka nan-wa Shem. I yile nukunu Shem-ka nan-wa Noah. I yile nukunu Noah-ka nan-wa Lamech. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","I yile nukunu Lamech-ka nan-wa Methuselah. I yile nukunu Methuselah-ka nan-wa Enoch. I yile nukunu Enoch-ka nan-wa Jared. I yile nukunu Jared-ka nan-wa Mahalaleel. I yile nukunu Mahalaleel-ka nan-wa Kenan. ");
INSERT INTO mwf2018_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","I yile nukunu Kenan-ka nan-wa Enosh. I yile nukunu Enosh-ka nan-wa Seth. I yile nukunu Seth-ka nan-wa Adam. I yile nukunu warda Adam-ka Yile neki warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bere Ngepan ngarra Yile neki thangunu-ka bere matha wangu kardidha ngarra Jesus-yu. Bere Jesus-ka kanampart nungardurr warda da nhini Jordan-yu i Ngepan ngarra Yile neki nukunu mengkayidha tharra da ngarra darrinpirr pularn wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","I pangu da kardidha da pirdithme nimin-ya da merrk numi-ya i kanganu. I nukunu ku karrath-ka ku bere matha wangu merulluldha wurrini-yu. I nukunu-ka mi mere kanimurrktha da nhini-yu. Bere da merrk nhini mana kanarntikerdek-ka nukunu-ka kardu warda medeyi kardidha mi dhepdhep-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bere ku karrath kathu-ka mamna warda ngarra Jesus, “Ya, nhinhi ngatha wakal ngarra Pule ngala nukun thurran-ka, nhini-ka thurdathnu mani nanhthi palyirr kanhi i mi lawam warda pirrampanu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mu Jesus kathu-ka mamna, “Murrinh ngarra Yile ngay yibimnangurrkurrk-ka kanhi-wa, ‘Kardu mani-ka mere kanibirnu mi dhepdhep da matha-re kanammurrk, wurda.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bere nhini thangunu ku karrath-ka kanthinmardawith Jesus-yu da ngarra kangkarl warda. I daninangkardadha pirri pirtpirt da matha da terert pana-re ngarra kardu pardidha-yu i kardu ngarra pule ngalangala pirrinirradha-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","I nukunu ku karrath kathu-ka mamna, “Ngay-ka ku pule ngala-wa ngempirra da pangu-yu. I ngay-ka ku pule ngala deyida mani bupak kardu numi-yu da ngarra pangu-nu pirranu-yu kardu ngarra nangkal ngatha ngay marda mart-yu. Mu nhinhi ngatha thengawinhipingkarlnu-ka ngarra ngay kumparra kanhi warra i murrinh ngarra ngay nangabathnu kardu pule ngala ngurrumpanu, nhini ngay-ka ngampamutnu warda da wurnangat kanhi warda ngatha kurrankadhuk ngarra nganthinnhingkarr ngarrim-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mu Jesus kathu-ka mamna, “Murrinh thathpi Yile ngay nukunu-ka kanhi-wa yibim-yu, ‘Nukunu da matha kardu Pule ngala thathpirr. I murrinh ngarra nukunu da matha dinayewupnu thurru i murrinh nanabathnu thurru. I da mange ngarra nukunu da matha thamanu thurru-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bere nhini thangunu-ka ku karrath mebertidha tharra Jesus da ngarra Jerusalem-nu warda wangu. I kanthinmardawith da kangkarl thathpirr warda ngarra da church ngala pangu da ngatha. I nhini da nukunu kathu-ka mamna, “Ya, nhinhi ngatha wakal ngarra Pule ngala Yile neki nukun thurran-ka, nhini-ka thurdiwal mani kanhi da wangu i pepe da mana.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","I ngana deyida murrinh mamna ngarra Jesus, “Murrinh ngarra Yile nhinhi nukunu-ka kanhi-wa yibim, ‘Nukunu Yile nhinhi-ka ku angel ngarra nukunu purdumpathuknu i ");
INSERT INTO mwf2018_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","pumanhiyitnu, i nhini-ka mere warda thanimemurrknu ngarra nanhthi palyirr pepe-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mu Jesus kathu-ka mamna, “Yu, nhini-ka murrinh. Mu murrinh numi yibimnangurrkurrk-ka kani-wa, ‘Mere da matha duthap Pule ngala Yile ngay ngathayida-nu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bere nhini thangunu ku karrath-ka bere matha warda merulluldha wurrini Jesus-yu i kanampart ngadha nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Bere nhini thangunu Jesus-ka wurdawurl deyida da ngarra ngala nan-ya Kelili. Ngepan Yile neki nukunu ku bere matha wangu kardidha ngarra nukunu-yu i melurruththa wurrini. Nukunu Jesus-ka wurrinirdurdidha ngarra murrinh church kardu Jews pigunu i murrinh ngarra Yile nukunu thangunu wurdininthethiththa wurrini. I nhini kardu-ka parriniriparldha warda punni Yile neki-yu. I nhini thangunu-ka murrinh warda banalangtha wurrini murrinh ngarra nukunu-yu da pana ngangka-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bere Jesus-ka nadha dini pangu warda wangu da nan-ya Nazareth da ngarra nukunu da wurdanturturt. Bere da ngarra Saturday mana-ka nukunu-ka kanardi ngarra murrinh church kardu Jews pigunu pangu da. I pirret pangu warra kumparra ngarra kardu murrinh read pamanu pirra murrinh ngarra thathpi Yile neki nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","I kardu-ka wurrininadha i nanhthi murrinh peypa damnamut murrinh ngarra ngalantharr murntak nan darntilil Isaiah. Bere Jesus-ka wurdantereth murrinh nhini-yu i rit warda merradha pirri. I kanhi-wa murrinh-yu, ");
INSERT INTO mwf2018_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Pule ngala Yile neki-ka memngimangkart ngay-yu i Ngepan nukunu-ka kanam ngarra ngay-wa. I nhini ngay-ka murrinh thelerrdha patha nganthelerrnu ngurru ngarra kardu nanhthi parnamyeyma i dampunpethin wurran. I nukunu wurdanngithuk ngay kardu pana-nu ngarra ku karrath mampunyit wurran kardu ngungunwuynu, i kardu nhini-ka da-ka pubangkardunu warda da mange ngarra Pule ngala nukunu wangu-yu. Ngay kardu-ka ngungumawuynu ngarra ku karrath thangunu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","I Pule ngala-ka mange patha da matha marranu purru kardu pana ngarra murrinh nukunu pumanabathnu purru-yu.” Nhini-wa murrinh ngarra Jesus rit merradha pirri-yu ngarra murrinh kardu ngalantharr nan thangunu-yu Isaiah. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bere Jesus-ka panpekarl murrinh peypa nhini-yu i wurdannangkarl ngarra kardu nugarn nhini. I kanawup warda i murrinh warda purdunthethithnu pi ngarra kardu. I kardu-ka kamarl-ka pangu da wangu pirangkadha pi i le menwaldha dini kardu pangu-yu murrinh ngarra nukunu pubinayepupnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bere nukunu Jesus kathu-ka mampirra, “Nga. Marra kanhi da matha murrinh thathpi pana ngarra nukunu Isaiah thangunu nubinthepup-ka, murrinh da matha-nu thathpirr murrinh thathpi nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bere kardu-ka pumemnamardat warda ngarra murrinh thathpi lelunh Jesus thangunu-yu. I murrinh pumenanudha punni, “Murrinh thathpi nukunu-ka murrinh patha da matha thathpirr. Mu ngarra-re-wa nukunu wurdanthuk ngarra Yile neki thangunu kathu-yu, nukunu pana-ka wakal Joseph da matha nukunu, nawa?” Pumenanudha punni kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mu bere Jesus kathu-ka mampirra, “Ngay-ka the-wa nganthin murrinh kanhi-wa numanganu, ‘Nga, doctor. Nenuwatha nhinhi-yu patha thathpirr.’ I murrinh numi deyida nginipunh kanhi mani numanganu-yu, ‘Mange patha da matha thamanu thurru da kanhi-yu da ngarra nhinhi-yu nginipunh pangu deyida mani mange patha-patha nedha thardi da nan-ya Capernaum.’ Nhini-wa murrinh numanganu ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mu kanhi-wa murrinh thathpirr-yu,” Jesus kathu-yu mampirra. “Kardu pana ngarra murrinh thathpi Yile neki nukunu wurdampirrayith wurran i nungawat dim da pana ngangka-re, kardu-ka pubimnayewup pumpan i murrinh pumamnabath pumpan. Mu da ngarra nukunu warda wangu nungam-ka kardu darrikardu nukunu-ka mere warda murrinh kumanabath nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“I nga,” Jesus kathu-yu mampirra deyida. “Nubingayepup kathu. Da murntak warra-ka kardu ngalantharr nan Elijah wurdanarrayiththa wurrini murrinh thathpi Pule ngala Yile neki nukun. I da nhini-re-ka mere ngadha kaniyeldha da thangku perrkenkuneme i kanganu i nhini-ka mi-ka mami-wa. I kardu mekmunurr mekmunurr nanki kardu Jews pirrinidha da nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mu Yile neki-ka wurdanthuk nukunu Elijah ngarra kardu mekmunurr da ngamengka wangu. I nigunu-ka mere thathpirr darrikardu nigunu nhini-yu. Nigunu kardipuptha-ka da ngarra town nan-ya Zarephath da ngarra ngala nan-ya Sidon. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","I the mana nanthin deyida-ya kardu numi pana deyida nan Elisha murrinh thathpi Yile neki deyida wurdanarrayiththa wurrini. I da nhini-re-ka kardu nanki kardu Jews kardu terert da matha matharr leprosy pumebaththa punni. I kardu nugarn ngamengka pana nan Naaman matharr leprosy deyida mebaththa wurrini. Mu nukunu-ka murrinh thathpi ngarra nukunu Elisha mamnabath i nhini Yile neki-ka patha warda mampatha nhini-yu. Mu kardu nanki kardu Jews-ya matharr leprosy da ngatha pumebaththa punni da nhini-re-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bere kardu-ka murrinh warda pumenanudha pirrini, “Ya. Nukunu pana-ka murrinh nekingime nganaka-ya wurdannhiyithngime dim-ya.” Bere kardu-ka parramnarithi ngala warda thathpirr ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Perrempirnturt punninadha i pumangarnta i panthinnurr pangu warda wangu outside ngarra church i puy panthiwurrdha punni i da ngarra palyirr da mana nhini da manta ngarra town. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kardu-ka punnikudha mana-wa ngarra dirryerrdi wangu, mu nukunu-ka kanampunpart wurrinililidha bere matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bere nhini thangunu nukunu Jesus-ka nadha dini da nan-nu warda wangu Capernaum da ngarra ngala nan-ya Kelili. Bere da ngarra Saturday-ka kanardi da ngarra church kardu Jews pigunu i murrinh wurdininthethiththa dini murrinh ngarra thathpi Yile neki nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I bere kardu nhini-ka pumenanamardattha warda pirrini murrinh thathpi nhini-yu, nhini nukunu wurdininthethiththa dini-ka nginipunh kardu pule ngala mani. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bere da ngarra church nhini-ka kardu nugarn dinidha pangu da wunku ku ngepan wiye kanthidha wurrini. Bere nukunu nhini-ka lurruth dimnakay ngarra Jesus warda wangu i mamna murrinh-yu, ");
INSERT INTO mwf2018_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ya. Jesus kardu Nazareth-mawu. Ngay-ka the-wa mamnhibath nhinhi-yu. Pule ngala wurdannhithuk kanhi-yu. Nhinhi-ka patha i yuthpan da matha thurran i mere nabath thani da mange wiye-yu. I nhinhi-ka wakal nukunu-wa. Mu thangku-nu nhinhi thurrinidha da kanhi-yu? Thurdungankartelnu i thurdungantinuminuminu ku ngepan wiye terert kanhi-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mu Jesus kathu-ka mamna ngarra ku ngepan wiye nhini-yu, “Ya. Watmam thi. I thungiwuy kathu ngarra kardu pana-yu.” Bere ku ngepan wiye nhini-ka buniwaththa kardi i yungawuy warda kathu ku ngepan wiye nhini-yu ngarra kardu thangunu kathu-yu. I kardu terert pubamkardu nukunu nhini yungurrkurrktha pangu da i mere ngadha yidingurr denamuttha. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","I kardu wurnangat-ka pumemnamardat ngala da matha nhini-yu i murrinh pumenanudha punni, “Ya. Thangku murrinh kanhi-yu? Nukunu pana-ka kardu pule ngala thathpirr-wa i lurruth ngala. I ku ngepan wiye ngatha yida murrinh pumamnabath pumpan-yu ngarra murrinh mampirra wurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bere nhini thangunu-ka murrinh nhini ngarra Jesus medha wurrini-ka bamlang pana ngangka-re warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bere nhini thangunu nukunu Jesus-ka nungardurr warda da ngarra church thangunu kathu-yu i nadha dini ngarra thelput nukunu Simon. Bere da ngarra thelput nhini-ka pipi nginarr nukunu Simon-ka matharr yungurrkurrktha matharr pimut-wa mebaththa yu. I kardu-ka pumamnakay Jesus-yu kardu palngun nhini-nu patha deyida mawathanu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bere Jesus-ka wurriningedha demngewinhikul ngarra nigunu i nanhthi pimut nhini-ka mamngedhap warda nhini-yu. Bere matharr pimut nhini-ka kanampart warda nigunu-yu i nigunu-ka dempirnturt i mi warda merruwathawathadhangime kardi mi dhepdhep. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bere da nhini da ngatha ngarra ngunga thangunu kananthurrk-ka kardu-ka kardu matharr-wunngini terert pumenbertidha punni ngarra Jesus kardu matharr panpunkarlparl. Kangkarlmawu-ka menthadhaptha wurrini kardu nhini-yu i patha deyida menpathadha dini ");
INSERT INTO mwf2018_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","i ku ngepan wiye wanku ngarra kardu thangunu pirrinmapuththa wurrini-yu. Bere ngarra ku ngepan wiye thangunu kardu pardinpirrdha-ka i pardinakaykaydha ngarra nukunu pumenadha pardi, “Ya. Nhinhi-ka wakal Pule ngala nukunu-wa,” pumenadha pardi. Mu Jesus-ka banpunthap murrinh nhini-yu nhini-ka ku ngepan wiye-ka the-wa panthidha punni Jesus-yu wakal nukunu Pule ngala Yile neki wurdanthuk nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bere nhini thangunu da wunkudharr burrinhi mana-ka nukunu Jesus-ka nadha dini numidharrnu da ngarra watmam-nu warda wangu. Mu kardu-ka pumpannurdurr deyida i piranawinhadhaththa pardi ngarra nukunu-nu i ngarra pubangarnurt da mana. I murrinh-ka pumamna, “Pule, mere thaninganpart nukun nganki-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mu nukunu kathu-ka mampirra, “Ngay-ka da ngamere deyida pana ngangka-re ngunuwatnu ngi i murrinh thelerrdha patha nganthelerrnu ngurru murrinh pana ngarra Yile neki kardu Pule ngala thathpirr pinu-yu. Nhini-wa nukunu ngay wurdanngithuk da putek ngala kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bere nhini thangunu nukunu Jesus-ka da pana ngangka-re wurriniwattha i murrinh thathpi Yile nukunu nukun wurdininthethiththa wurrini ngarra da church terert kardu Jews pigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bere Jesus-ka pirridha manta pangu da ngarra da dimunurdi da ngipilinh ngala da nan-ya Kelili wunku kardu wurnangat pidha manta ngana da ngatha ngarra nukunu i puddanarururttha purni kardu manta purunanu ngarra nukunu murrinh pubinayepupnu murrinh thathpi ngarra Yile neki wurdanarrayiththa pirri-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mu bere Jesus-ka bamkardu tharntu perrkenku pirrininthangkadhuktha ngarra ngipilinh dimunurdi pangu da ngatha kardu thangunu pubuniwakpaktha. Mu kardu nhini-ka nanhthi karlay ngadha pumepurldhaneme pirrine pangu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bere Jesus-ka kanammardap ngarra nanhthi tharntu numi, nanhthi ngarra Simon nukunu-wa. I murrinh mamna ngarra Simon, “Ya Simon. Kunungingki ngadha thurdingirurtnu pangu wangu.” Bere Jesus-ka kanawup ngarra tharntu i kardu warda murrinh wurdininthethiththa warda dini kathu ngarra tharntu pangu da. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bere nhini thangunu ngarra murrinh dampirrarikerdek-ka Jesus kathu-ka mamna ngarra Simon, “Nga. Naneme pangu wangu ngarra kura pewerti i nunnakunemenu nanhthi karlay pana ku ngurlmirl-nu numaruthnemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mu Simon kathu-ka mamna, “Ya Pule. Ngankuneme-ka ngarderuthtuththaneme da bere matha wangu da thipinhi i nguddamkabayneme maku, maku da matha. Mu berengunh ngay-ka murrinh thathpi nhinhi-ka mampabathnu i nanhthi karlay kanhi ngumadharday-deyida-nemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bere nukunu Simon i kardu ngamere deyida wanku nanhthi tharntu-re purnedhaneme pangu wangu ngarra kura pewerti i nanhthi warda karlay pumamkadhardayneme i puddankakulkneme nanhthi nhini-yu. Bere ku ngurlmirl terert nimin-ya pumamkaruthneme i nanhthi karlay nhini-ka pumamkadhalertneme i wurrirartaldha warda wangu nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bere peneme nhini-ka pumampunkungkarlayneme kardu nugarn ngamere ngarra tharntu numi kathu pumankumanpinemenu. Bere kardu nhini-ka purnerrudhaneme ngangka da i kardu warda ku pumedhalertertthaneme purne tharntu perrkenku ku ngurlmirl-yu, ku ngurlmirl terert nimin-ya. I tharntu perrkenku nhini-ka nanhthi manta warda denkuyiwikthanintha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Mu ngarra nukunu-re Simon Peter bamkardu ku ngurlmirl terert nhini, nukunu-ka memnamardat i demnawinhipingkarl kumparra ngarra Jesus. I murrinh warda mamna, “Pule, nhinhi-ka mange lurruth ngala thathpirr-wa nam kanhi-yu i kardu patha da matha nhinhi-yu. Mu ngay-ka kardu wiye merithuktha ngardi, nhini-ka thaningipart warda nhini-yu.” Mu Jesus kathu mamna, “Ya. Mere thenham thi. Mu marra kanhi wangu-ka nhinhi-ka mere warda thanikunu ku ngurlmirl-yu, mu nhinhi-ka thurrurrakaykaynu kardu warda ngatha i ngarra ngay warda pangilerrnu i pangiriwaknu puru.” Bere kardu nugarn ngamere deyida-ka pumemnamardatneme ngarra ku ngurlmirl terert nhini-yu i kardu piguna nhini deyida wanku James i John pumemnamardat-yu. Kardu piguna nhini-ka kardu pulangay nukunu Simon-wa. I yile piguna-ka nan-wa Zebedee. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bere nhini thangunu kardu nugarn nhini-ka pubuniwakpakthaneme tharntu perrkenku nhini-yu. I parnamkapart-da-matha-neme nanhthi tharntu i nanhthi purrkpurrk wanku i parramkariwak-warda-neme Jesus. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bere nhini thangunu nukunu Jesus-ka da numi-nu warda wangu nadha dini. Bere da nhini-ka kardu nugarn pangu da dinidha wunku matharr leprosy kanthidha wurrini. Bere kardu nugarn nhini-ka bamkardu Jesus-yu. Wurrininadha i demnawinhimardardum bamnabat kumparra pangu warra ngarra Jesus. I mamna murrinh, “Pule, marda ngatha nart-ka nhinhi-ka nangiwatha-wa kardu darripi tarangka ngurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bere Jesus-ka pirrimnanalabe i manthap nukunu-yu. I murrinh mamna, “Yu, ngay-ka marda manganart ngarrim manhiwathanu. Nhinhi-ka kardu darripi tarangka warda thurrunu.” I da nhini-re-ka kardu nugarn nhini-ka patha warda i matharr ngala nhini-ka kanampart warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","I Jesus kathu-ka mamna, “Nga. Mere nukun thantherr ngarra kardu-yu ngay thangunu mamnhiwatha-yu. Mu ngarra ku yilarn ngala da matha thununu thi i nukunu-ka banhinginingkardunu nhinhi-yu. I nhini thangunu-ka mampanu nukunu-yu, ‘Yu, nhinhi-ka kardu manangka matharr warda kardu darripi tarangka warda.’ I nhini thangunu-ka ku murrirrbe i ku thip thanamutnu ngarra ku yilarn-yu, ku nhini ngarra nukunu Moses mam-ya da murntak warra thanamutnu-ya. I nhini thangunu ku nhini-ka yilarn warda pinapeknu ku Yile neki-nu-yu. I nhini-ka the warda ngatha pumanhibathnu kardu wurnangat-yu nhinhi-ka kardu tarangka thathpirr warda nhini-yu.” Nhini-wa murrinh-yu Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bere murrinh thelerrdhe Jesus nukunu-ka bamlang warda da pana ngangka-re-ya. I kardu wurnangat warda punninadha ngarra murrinh nukunu pubinayepupnu-yu. I kardu matharr-wungini deyida wanku punninadha kardu manpathanu pi. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bere Jesus-ka wurriniwattha numidharrnu da ngarra watmam-nu i murrinh ngarra Yile nukunu da matha-nu wurrininangerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bere Jesus-ka murrinh wurdininthethiththa pirri murrinh thathpi Yile neki nukunu. Kardu terert pardingkadhuktha ngarra da thelput inside pubinayepuptha pardi. I kardu Pharisees deyida pirrinidha pangu da i kardu pana ngarra murrinh law Jews pigunu puddininthethiththa purni. Kardu nhini-ka da town purrkpurrk thangunu kathu-ya punnidha, da ngarra nan-ya Kelili, da Judea i da nan-ya Jerusalem. I pangu da ngarra thelput nhini inside pubinanayepuptha pirrini ngarra Jesus. Kardu wurnangat nimin-ya pubinanayepuptha pirrini pangu da. I Yile neki-wa nukunu-yu lurruth ngala damnamut kardu matharr-wunngini-nu manpathanu purru. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","I bere kardu ngamere deyida kathu parramkaruyneme ngarra da thelput nhini da ngatha wunku kardu pulith pumenamathbaththaneme purne ngarra nanhthi nginipunh da pit mani. Kardu-ka pumebertidha-mana-wa-neme ngarra Jesus-nu pinganapuptha-mana-wa-neme. Mu kardu-ka puddamkabay-wa-neme ");
INSERT INTO mwf2018_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","nhini-ka kardu wurnangat weyida pinganulipiyiptha purni. Bere peneme nhini-ka parnamkangkalaneme kangkarl da ngarra roof werlpen. I weyi warda parramkawebangneme kangkarl kathu. I kardu pulith nhini-ka puddankathutneme ngarra pit nukunu nanhthi rup-te ngarra Jesus da mana warra kumparra pirridha, i kardu wurnangat pidha kanhi-re. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mu Jesus-ka the menkumabaththaneme pirri ngarra marda peneme-yu murrinh da thathpirr pumamnabathneme nukunu-ka mawathanu patha da thathpirr kardu pulith nhini-yu. I bere murrinh mamna ngarra kardu pulith nhini-yu, “Nga. Da mange wiye pana ngarra nhinhi nebaththa thurrini-ka ngarrimnhimaputh warda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bere kardu Pharisees nhini i kardu pana ngarra murrinh law kardu Jews pigunu puddininthethiththa purni-ka pubimnayepup warda ngarra murrinh Jesus mamna-yu i murrinh warda pumemnungkuneme mange peneme ngatha, “Ya. Nangkal kardu kanhi-yu? Thangku-nu murrinh nhini nukunu pana mam pirrim-yu? Nukunu-ka murrinh damnakumugat-wa kanam pana-yu ngarra Yile neki wangu. Nukunu-ka mere ngarra nukun kirramaputh mange da wiye pangu-yu ngarra kardu pulith pangu-yu, wurda. Mu Yile neki da matha kirramaputh da mange wiye pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mu Jesus-ka bangampunkumardeneme mukmuk ngarra kardu peneme nhini-yu, i mampirruneme, “Thangku-nu ngay nubemngayengkarnirnneme nirrim-ka da mange nginipunh pana mani numamnganeme narnam-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Mu nga. Ngay kardu ngarra darrikardu nanki thathpirr-ka kardu Pule ngala thathpirr-wa, i murrinh thathpirr ngurranngerren. I ngay mani-ka ngirramaputh-wa da mange wiye kardu ngarra nugarn pulith kabim kanhi-yu. I ngana deyida ngay mani-ka ngawirnturtnu i kardu patha warda kani kardu purrulilinu-yu. I nhini-ka the warda numabathnu ngay-ka ngirramaputhnu da mange wiye ngarra nukunu mebaththa wurrini-yu.” Bere Jesus kathu-ka mamna ngarra kardu pulith nhini-yu, “Ya. Ngay-ka mampanu thewirnturt kathu i da pit pana nartnu i thurrulilinu warda ngarra da nhinhi wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bere kardu nugarn pulith nhini-ka dempirnturt warda i kumparra warra pirrimpunmardart ngarra kardu. I manganart warda nanhthi da pit i wurrinililidha pangu warda wangu da ngarra nukunu-nu, i daniriparldha wurrini Yile neki. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","I kardu wurnangat da matha pubamkardu kardu pulith nhini-yu i pumemnamardat warda i parraniriparldha pardi Yile neki-yu. I murrinh pumenanudha purni, “Ya. Yile neki-ka ngala-wa thathpirr dinnhengime. Nekingime-ka thubamkardungime da mange ngala da matha marra kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bere nhini thangunu-ka nukunu Jesus-ka yungawuy ngarra thelput thangunu kathu-yu i nungardurr warda i pangu warda wangu nadha dini. Bere ngarra nukunu-re mayern wurrinililidha-ka nukunu-ka kardu nugarn bamkardu wurran dinidha ngarra thelput kunungingki ku mani dininmatkuttha ngarra kardu ku nan-nu Government. Murrinh nukunu kardu nhini-ka nan-wa Levi. “Ya, kagu.” Jesus kathu-yu mamna. “Thurru kathu, purrunu warda. I kardu ngarra ngay warda thangiriwaknu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bere nukunu Levi-ka dempirnturt i nanhthi nukunu-ka kanampart pangu da matha i darntiwak ngarra Jesus pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","I ngarra thelput nukunu da mana Levi pangamnintharuy. I nhini da nukunu Levi-yu mi mampirruwathawathaneme-yu wunku nukunu Jesus mi dhepdhep-yu i pulangay nukunu wanku. Bere nhini da mi pirrinemurrkthaneme i kardu ngamere deyida wanku mi pirrinimurrktha. Kardu ngamere nhini-ka ku mani punninmatkuttha ngarra kardu ku nan-nu Government, i kardu ngamere deyida pangu-yu mi pirrinimurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bere kardu pana ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-ka kardu Pharisees-ya parrampunkudharrpuneme ngarra pulangay nukunu Jesus, “Ya, peneme,” pumampirruneme. “Thangku-dha nankuneme-yu narnamkamurrkneme kanhi-yu ngarra kardu pana ku mani parnampunmatkut ngarra kardu-yu i kardu pana ngarra da mange wiye pumammath pumpan-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mu nukunu Jesus kathu-ka mampirruneme ngarra kardu Pharisees-yu, “Ya. Kardu pana ngarra manangka matharr lurruth ngala-ka mere deyida kirranakay ku doctor-yu. Mu kardu pana da matha matharr wunku nhini da matha kirranakay ku doctor-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mange nginipunh nhini deyida mani ngay-ka ngurrinidha da kanhi-yu kardu pana-nu manmanpinu ngurru ngarra da mange wiye panthin pumpan-ya i murrinh marranu ngurru-ka parnipartnu warda da mange wiye-yu. Mu ngay-ka mere ngurridha kardu pana-nu ngarra pamam pumpan kardu pathanpun-ya,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bere kardu punnidha ngarra Jesus i pumamna, “Ya. Pulangay nukunu John the Baptist-ka mi mere da ngatha karnemurrkneme nhini-ka ngarra Yile neki ngadha parnamnangerrenneme i parramkariparlneme parnamka. I kardu pana Pharisees-ya mange nhini da ngatha pamam pumpan. Mu thangku-dha pulangay nhinhi-yu mange mere nginipunh nhini mani kuyemaneme kuru-yu? Mu kardu ngarra nhinhi pana-ka bere matha wangu mi parnamkamurrkneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mu Jesus kathu-ka mampirra, “The mana nanthin-ya ngarra kardu nugarn-te manganmert palngun i bemnginthalet warda-ka kardu darrikardu nukunu-ka puyemperr warda mi dhepdhep pangu pullathnu-yu. I bere kardu terert warda ngatha le da matha i marda ngala mi parnammurrk-yu, i mi-ka mere ngarra ngadha karnipart, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mu ngarra nugarn nhini-re kumabert mani-ka ngarra kardu darrikardu nukunu kathu-ya, nhini-ka mi dhepdhep-ka karnipart deyida nhini-yu i kanmardathinnu warda ki nukunu-nu-yu. I mange nginipunh nhini deyida mani ngarra kardu-re pumangibertinu ngarra pulangay ngay thangunu kathu nganinkupartnuneme-ka nhini peneme-ka pankumardathinnu-warda-neme pi mi dhepdhep-ka parnepart-deyida-nemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bere Jesus kathu-ka murrinh numi deyida mampirra, “Nga. Nanhthi kaligu murntak nganaka nanhthi muyu wunku. Mere nangkal ngadha kawarl kani ngarra nanhthi kaligu marra-yu i ngarra kaligu murntak nhini-nu mawathanu-yu. Nhini-ka ngarra napurl-re warda-ka nanhthi kaligu marra nimin-ka wurrannurrurrurr mamkunungingki i kingurrurduk warda ngarra kaligu murntak thangunu kathu-yu. I nhini ngarra nanhthi muyu ngarra murntak-ka nanhthi muyu ngala warda kirra nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","I ngana deyida mere nangkal ngadha kawinhimardapak kura wine marra-yu ngarra nanhthi pul ku darripi murntak ngananu-yu. Mu mange nhini ngatha kama kurru-ka kura wine marra-ka kurduwi i kururup warda nhini-yu i nanhthi pul ku darripi murntak-ka kingutuy warda. I kura-ka kewinhipak warda. I nanhthi pul ku darripi murntak-ka nanhthi wiye warda kirra nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mu kura wine marra ngatha-ka nhini-ka nawinhimardapaknu ngarra nanhthi pul ku darripi marra da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","I bere murrinh numi deyida mampirra Jesus kathu-yu murrinh yibimkamnum-ya. “I nga,” mampirra. “Kardu pana ngarra kura wine murntak da matha kanamkurdugurduk-ka mere marda mart kura wine marra bagurduk-yu. Mu nukunu nhini-ka murrinh mam-ka, ‘Kura wine murntak kanhi-ka patha da matha nhini-yu,’” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bere da ngarra Saturday mana-ka ngarra kardu Jews benyuktha dini-ka nukunu Jesus i kardu pulangay nukunu-ka purnelilidhaneme ngarra mi kadin da matha wangu ngarra mi yimun da matha wangu wurrinidha. Bere pulangay nukunu Jesus-ka pumuniwerartaldhaneme purne ngarra mi kamarl pelpith ngamere da matha i pumewingthaneme purne i purnemurrktha-warda-neme. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bere kardu pana kardu nhini Pharisees-ya pumampirruneme ngarra pulangay nukunu-yu, “Ya. Thangku-nu mi pana numungamkawerartalneme numpanka marra kanhi-yu? Nankuneme-ka mange mere niyema-nukun-neme nuru nhini-yu da marra kanhi ngarra kardu wurnangat warda ngatha-re bangamnganyuk dim-yu. Nhini-wa da murrinh law pirrim-yu murrinh law nekineme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mu Jesus kathu-ka mampirruneme ngarra kardu Pharisees nhini-yu, “Nankuneme-ka rit numedhaneme-ya murrinh ngarra King David mange mam-yu ngarra nukunu-re medeyi kardidha-yu wunku pulangay nukunu? ");
INSERT INTO mwf2018_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nukunu-ka kanardi ngarra thelput Pule ngala Yile neki nukunu i mi danthakthuk mi lawam pangu diningkadhuktha mi Yile neki nukunu. I nukunu-ka wulamath mi nhini-yu i ngarra kardu nukunu deyida wanku danirrumutmutthaneme i pullamkath-warda-neme nhini-yu. Mu murrinh law nekineme pirrim-ka ku yilarn da matha mi lawam pangu-yu pumpanmurrk-yu, mu nukunu King David i kardu ngarra nukunu mi-ka pullamkath-weyida-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","I bere Jesus kathu-ka mampirru-deyida-neme, “Nga. Ngay kardu darrikardu nanki thathpirr-ka kardu Pule ngala thathpirr-wa ngarra da wurnangat nukunu-ya i da ngarra Saturday deyida wanku. Mu nhini-ka berengunh-wa pulangay ngay mi pana pumungamkawerartalneme pumpanka-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bere, da ngarra Saturday numi mana-ka nukunu Jesus-ka kanardi deyida ngarra murrinh church kardu Jews pigunu i kardu warda wurdininthethiththa dini. Bere da nhini-ka kardu nugarn numi dinidha ngangka da mange wardi punimawerlerldha kardi mange batbat-te. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bere kardu pana ngarra murrinh law Jews pigunu puddininthethiththa punni-ka kardu Pharisees-ya kardu pirangkadhaneme pirrine kardu ngarra kama pamanu nukunu Jesus mange ngarra nukunu kardu pangu ngarra mange mamawathanu-yu. Peneme nhini-ka marda pumertthaneme purne nukunu Jesus mange ngarra kardu pangu mamawathanu, i nhini Jesus-ka munmaparlnu warda murrinh law kardu ngarra Jews pigunu-yu i nhini-ka murrinh warda pangkabirrnemenu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mu nukunu Jesus-ka bangampunkumardeneme peneme nhini-yu i mamna warda murrinh-yu ngarra kardu nugarn nhini-yu, “Ya. Wurr, thewirnturt kathu. Thurru kathu i kumparra kanhi warra thirrat.” Bere kardu nugarn nhini-ka dempirnturt i kumparra warra wurrinidha i pirret pangu da. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bere Jesus kathu-ka mampirra ngarra kardu terert, “Nga kardu,” mampirra. “Murrinh kanhi nganantharrpunu. Ngarra nimin murrinh law nekingime pirrim-yu? Da Saturday ngarra da nekingime bangannhiyukngime-ya, ngarra nimin da mange yuthpan pamanungime purru-yu? Kardu kama pumankumanpinungime purru i kardu kama mere pumankumanpingime purru? I ngana deyida ngarra nimin da mange patha-yu? Kardu kama pumankuyibirnunungime purru i kardu kama purdunkuthuknungime purru? Da-ka ngarra nimin da mange yuthpan-nu-yu?” Jesus kathu-yu dampuntharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bere Jesus-ka yerrarr mamka kanhi-re ngarra kardu i murrinh warda mamna ngarra kardu nugarn nhini-yu, “Nga. Mange ngarra nhinhi pana thungurathtath.” Bere nukunu-ka yungantathtath nhini-ka mange patha warda mebaththa pirri nginipunh patha numi pangu-re deyida mani mebaththa kardi. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bere nhini thangunu kardu Pharisees nhini-ka dempunkumardarurr-thathpirr-warda-neme ngarra Jesus-nu-yu. I murrinh warda puddanayiththaneme pe murrinh ngarra-re da mange nukunu Jesus thu pubatnemenu-yu. Murrinh pumemnungkuneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bere Jesus-ka dimmardawith da ngarra palyirr murrinh-nu ngarra Yile nukunu pinangerrennu. I pangu da kardidha thipinhi-yu kardinangerrentha i pankapurl da mana. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bere da thipinhire nhini-ka nukunu-ka pirrimpirrakay kardu wurnangat pana ngarra parriniriwaktha purni-ya. I bere ngarra kardu nhini thangunu kathu-ka kardu nugarn 12 da matha mampunkungkarartneme i murrinh panpunkuparlneme ku nan-wa apostle, nhini-ka kardu purdunkuthukthuknuneme da pana ngangka-re i murrinh thathpi ngarra nukunu pankuyelerrnuneme puru. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Bere kanhi-wa murrinh peneme-yu ngarra Jesus mampunkungkarartneme-yu. Nukunu Simon, mu Jesus panparl-ka murrinh numi deyida Peter-wa murrinh-yu. I ngathan nukunu Peter nan Andrew-ya. I nukunu James, John, Philip, Bartholomew, Matthew i Thomas. I nukunu James numi deyida, yile nukunu-ka nan-wa Alphaeus. I Simon numi deyida kardu pana ngarra bere matha wangu da-nu wurdanamangkarteldha kardi da ngarra putek nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","I nukunu Judas, yile nukunu-ka nan-wa James. I nukunu Judas Iscariot, kardu pana-ya ngarra Jesus dampirramut kardu ngarra wiyenpun-nu-ya da nakurl-nu-re-ya. Kardu-ka nugarn-ka nhini-wa Jesus menkungkarartthaneme pirri-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Bere nhini thangunu nukunu Jesus-ka wurdanthut ngarra da palyirr nhini thangunu kathu wunku kardu nugarn pana ngarra mampunkungkarartneme ku apostle-ya. I puddamkathutneme i ngarra kanganu-wa da ngarra werlpendarri da mana. I nhini da Jesus murrinh wurdininthethiththa dini-yu. Kardu wurnangat da matha pangu-yu murrinh ngarra Jesus pubinayepuptha pirrini-yu i kardu matharr-wunngini menpathadha wurrini i ku ngepan wiye pirrinmapuththa wurrini ngarra kardu thangunu kathu. Kardu wurnangat-ka da-ka nan thangunu kathu-wa da Judea i Jerusalem i da nan Tyre i Sidon da ngarra manta dimnintha lalingkin. Nhini-wa kardu-yu ngarra Jesus punninadha-yu murrinh pubimnayepup-yu i kardu matharr-wunngini menpathadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kardu wurnangat mana-wa pumedhadhaptha puyi ngarra nginipunh Jesus-yu i lurruth ngarra nukunu-ka kardipirrdha wurrini ngarra kardu wangu i nhini kardu-ka patha da matha punnidha nhini-yu. Bere Jesus-ka kardu matharr-wunngini terert da matha menpathadha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bere nhini thangunu Jesus-ka wurdampirramardarduy ngarra pulangay i murrinh mampirruneme, “Nga. Kardu pana ngarra nanhthi numpanyeyma-ka nhini Yile neki-ka Pule ngala da matha dimnarra i pirrananpenu purru nanki-yu i nhini-ka le-wa narni nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","I kardu pana ngarra medeyi numpan-ka da nakurlnu-wa nanki bananmardannu-yu i nhini-ka le-wa nuru nhini-yu. I kardu pana ngarra damnanmardathin wurran-ka da nakurlnu-wa nanki-yu le manankulkulnu-yu i nhini-ka le-wa nuru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“I nga. Kardu ngamere pana deyida murrinh pumanannarrithaknu ngatha i da tetemanthay ngatha pubunarrapaknu i murrinh pananthirrarartnu parni nanki-nu, nhini nanki-ka le da matha narninu nhini-yu. Kardu-ka mange nhini pumanarranu puru nhini nanki-ka kardu ngarra ngay weyida narramngiriwak numpan ngay kardu darrikardu nanki thathpirr-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","I da murntak warra da mange wiye nhini deyida mani pumerrudhaneme purne ngarra ku prophet-yu kardu ngarra Yile neki nukunu-yu. Nhini nanki-ka le da matha narninu nhini Yile neki-ka nanhthi patha patha mamnarrayit dim da ngarra Heaven nanki-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mu nga. Nanki kardu pana ngarra nanhthi terert numammath numpan-ya nhini nanki mere le nukun nuru nhini-ka mange murruwurl pekpek da matha nanthin numpan marra kanhi-yu mu da nakurl-te-wa mere warda numabathnu nuru nanhthi terert nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“I nanki kardu pana ngarra bamnanmardan wurran-ka nhini nanki mere ngarra le nuru nukun nhini-yu, nhini nanki-ka da nakurlnu-wa medeyi narninu. I nanki kardu pana ngarra le mamnankulkul wurran marra kanhi, nhini-ka mere le nuru nhini-yu. Nhini-ka da nakurlnu-wa pananmardatthinnu pi nanki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“I kardu ngatha murrinh panantiparlnu-ka nhini nanki-ka mere le nukun nuru. Mange nginipunh nhini mani-wa da murntak warra kardu-ka parranintiparldha punni kardu ngalantharr murntak ngarra murrinh thirrukduk da matha puddanarrayiththa punni.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mu nga,” Jesus kathu-yu mampirra deyida. “Nubingayepup kathu. Nanki-ka marda-wa numanartnu nuru kardu kuylarr-yu i kardu pana ngarra mere marda kumananart kuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","I da mange patha da matha numarranu nuru kardu pana ngarra nanhthi pangannantel pumpan-yu i Yile neki nadharrpunu da mange patha marranu purru kardu pana ngarra da tetemanthay pubannarrapak pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“I kardu ngatha kubananthamurrurduk ngarra thamurru-ka, nhini nanki-ka mere nurdunangkarl deyida thu-yu nhini-yu. Mu bere ngatha nurdunamurl banande ngarra thamurru numi-yu. I kardu ngatha darrarart nanhthi blanket manankabibirl-ka nhini-ka mere thu kuy nuyuna mu bere ngatha nurdunamurl mabath kurru nanhthi numi deyida-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","I kardu ngatha nanhthi-nu panantharrpunu-ka nhini-ka nanamut da matha. I kardu ngatha nanhthi pumanankardapnu-ka, nhini nanki-ka nuyuyekum-da-matha-nu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Nanki-ka kardu le numpanpirra kardu pangu kathu ngarra da mange patha pumamnarra pumpan-yu, na? Nhini nanki-ka da mange patha nhini da ngatha numarranu nuru-yu ngarra kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mu nanki ngatha marda numanartnu nuru kardu pana da matha ngarra marda wardarra pumangannanart pumpan-ya nhini-ka ngathayida-wa nhini-yu. Nhini-ka kardu wiyenpun pana ngatha yida marda pumanganpunart pumpan-yu kardu pana ngarra marda wardarra pumanganpunart pumpan kardu ngarra wiyenpun nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","I da mange patha ngatha numarranu nuru kardu pana da matha ngarra da mange patha wardarra pumamnarra pumpan-ya nhini-ka ngathayida-wa nhini-yu. Nhini-ka kardu wiyenpun-ka nginipunh mange nhini deyida mani pamam pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","I nanki ngatha nanhthi narramut ngadha kardu pana da matha ngarra nanhthi puddunarrangkarlnu-ka nhini-ka ngathayida-wa nhini-yu. Nhini-ka kardu wiyenpun-ka nginipunh mange nhini deyida mani pamam pumpan-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Mu nga,” Jesus kathu-yu mampirra deyida. “Nanki-ka puy deyida wangu thathpirr. I kardu marda numanartnu nuru kardu pana ngarra mere ngarra kumananart kuru nanki-yu. I da mange patha da matha numarranu nuru i nanhthi narramutmut ngadha nuru i nanhthi mere ngatha kuddunarrangkarl-ka nhini-ka berengunh-wa nhini-yu. Nhini-wa mange thathpirr-yu i Pule ngala Yile neki-ka le warda pinarranu i nanki-ka wakal nukunu warda nurunu nhini-yu. Nhini-wa da mange nukunu-yu. Nukunu-ka kardu murlmurl wurranpirra ngarra kardu wiyenpun-yu i kardu pana ngarra mere tiparlti kuru ngarra nukunu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nhini nanki-ka kardu murlmurl nururra ngarra kardu wurnangat warda ngatha nginipunh Yile neki deyida mani kardu murlmurl wurranpirra ngarra kardu wurnangat warda ngatha.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“I nga,” Jesus kathu-yu mampirra deyida. “Mere nukun murrinh nuddunyith nuru kardu ngarra ngamere-yu kardu wiyenpun kama pumpan-ya i kardu pathanpun kama-ya. I mere nukun nuntirda nuru kardu nhini-yu. I nhini Yile neki-ka mere warda punantirda nanki-yu. I kardu ngatha da mange wiye kumanarra-ka nhini nanki-ka mere nukun nuddurrangkarl da mange wiye nhini-yu. I nhini Yile neki-ka pirrananmaputhnu warda da mange wiye ngarra nanki thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“I nanhthi narramut ngarra kardu i nhini Yile neki-ka panarramut nanhthi-yu ngarra nanki. Nukunu-ka nanhthi panarramutmutnu purru makurrinh da matha. Nginipunh nanhthi tin mani nganaka mi numadhalet i numadhamnum i nuburangkarltangkarl i mi deyida numadhalert kangkarl i kurruwu da mana kanhi-re. Nginipunh nhini mani-ya Yile neki-ka panarramutmutnu purru ngarra nanki-yu. Mu nanki ngatha manangka makurrinh nuru ngarra kardu ngamere-ka nhini Yile neki-ka makurrinh kunungingki deyida kanarramut nhini-yu. Mu nanki ngatha makurrinh patha nururra ngarra kardu ngamere-ka nhini Yile neki-ka makurrinh patha deyida panarramutnu ngarra nanki-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bere Jesus kathu-ka murrinh deyida mampirra, “Nga. Kardu kamarrama ngatha maberti kurru kardu kamarrama numi-ka nhini-ka kardu-ka buyninthabat-wa ngarra weyi pewerti-yu, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","I nga. Kardu ngalantharr nganaka ngarra murrinh-te pantet kardu wurdanpunthethith-ka nhini kardu-ka mere da ngatha mukmuk ngala kumabath kuru nginipunh kardu ngalantharr nukunu deyida mani-yu. Mu da nakurl-wa ngarra kardu-re pangkathannu murrinh ngala thathpirr-ka, nhini kardu-ka mukmuk ngala warda wanku pumabathnu puru nginipunh kardu ngalantharr nhini deyida mani.” ");
INSERT INTO mwf2018_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bere Jesus-ka murrinh deyida mampirra, “Nga. Thangku-nu nubamkardu numpan nanhthi putek kunungingki ngarra kamarl kardu ngamere-yu. Mu nanki-ka numemnupe-wa nanhthi thay ngala kanamnankardi deyida ngarra kamarl nanki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","I numarra nuru, ‘Ngurdinhingkaputhnu nanhthi putek kunungingki pana-yu’ mu nanki-ka mere da ngatha nubangkardu nanhthi thay ngala ngarra kamarl nanki-yu. Mu nanki-ka nuyiyengkawuy mana-wa mere nubangkardu mana-wa thay ngala pana ngarra kamarl nanki-yu. Mu marra-re warra ngadha-ka nanhthi thay ngala nhini warra ngadha nunguyngkapirt ngarra kamarl nanki-yu i nhini-ka nubangkardunu tarangka thathpirr nanhthi putek kunungingki pana ngarra kardu ngamere-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“I nga,” Jesus kathu-yu mampirra deyida. “Nanhthi thay patha nganaka mi dhepdhep wiye-ka mere ngarra kinthat nhini-yu. I nanhthi thay wiye-ka mere ngarra kinthat mi dhepdhep patha-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mu nanki mani-ka niranthenhthenhnu thay terert da matha i ngarra mi pinthatutnu-yu. Mi kumpampa-ka mere karuy mani ngarra thay mululumpu-yu i mi mangkamurr-ka mere karuy mani ngarra nanhthi mayepup-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Da mange nginipunh nhini deyida mani kardu-ka niranthenhthenh deyida. Kardu pana marda patha mammath wurran-ka nhini nukunu-ka da mange patha-wa mam wurran i murrinh thathpi patha da matha wurranngerren. Mu kardu pana marda wiye mammath wurran-ka nhini nukunu-ka da mange wiye-wa mam wurran i murrinh thathpi wiye da matha wurranngerren nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“I nga,” Jesus kathu-yu mampirra deyida. “Nanki numamnga numpan-ka, ‘Pule’ nawa?. Mu nanki-ka mere murrinh numangabath nuru-wa. Nhini-ka thangku-nu-wa ‘Pule’ numamnga numpan-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mu nga. Kardu nangkal ngatha purrunu kathu ngarra ngay i murrinh thathpi ngay bingayepupnu i murrinh mangabathnu, nhini nukunu-ka nginipunh kardu nugarn pana mani ngarra thelput bangarnerde. Da marra-re warra ngadha-ka nukunu nhini-ka da weyi ngala pankurrk i ngarra palyirr pepe da mana. I da palyirr nhini thangunu-ka thelput warda bangarnerde i ngarra bangarntikerdek da mana. Thelput nhini-ka nanhthi tetemam da matha pirridha. Bere nhini thangunu-ka kura ngala warda kardiyeldha wurrini i ngipilinh-ka dempirnturt i manthawidhalert da mana i kura-ka wilan warda nungampinhat nhini-yu i thelput nhini-ka panmatnintha. Mu nanhthi-ka mere nuykudha-wa thelput nhini-yu. Mu tetemam da ngatha pirridha nhini-ka ngarra palyirr thangunu weyida bangarnerde nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Mu nga. Nangkal ngatha murrinh thathpi ngarra ngay bingayepupnu i mere murrinh mangabathnu nhini nukunu-ka nginipunh kardu nugarn numi niyith-niyith kanhi mani ngarra thelput bangarnerde. Nukunu nhini bangarnerde thelput-ka ngarra putek da matha kangkarl mere puykurrktha pepe-yu ngarra palyirr. I nhini thangunu-ka kura wilan deyida wurrinidha kathu i thelput nukunu panmatnintha. I thelput nhini-ka banpek-da-matha-nintha nhini-yu.” Bere murrinh Jesus-yu dampirrarikerdek murrinh wurdanpunthethith ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bere nhini thangunu Jesus-ka nadha dini pangu warda wangu da nan-nu Capernaum. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bere da ngarra nhini-ka ku pule ngala ngarra ku soldier terert nukunu dinirradha pangu da, kardu manangka Jews-wa nukunu-yu. I kardu nugarn numi ngarra wurlk menadha wurrini-ka kardu matharr ngala da matha yungurrkurrktha kardu manta warda yungipuptha. I kardu pule nhini-ka marda merttha kardi ngala da matha kardu matharrngini nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bere kardu pule nhini-ka pamnayepup Jesus-yu. I wurdanpunkuthukneme kardu ngalantharr-ngalantharr kardu Jews-ya ngarra Jesus-nu piranakaynuneme kardu matharrngini-nu mawathanu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Bere peneme nhini-ka punnanadhaneme ngarra nukunu-nu Jesus. I pumemnarlupurlneme i pumamnaneme, “Ya. Kardu pule ngala pangu ngarra ku soldier dimpirra-ka kardu patha-wa nukunu-yu. Nukunu-ka kardu marda-wa mangannganart kanam nganki kardu Jews-yu i nukunu da bangamngarrarderde-yu da ngarra church nganki-yu. Mu kardu nugarn numi ngarra wurlk mamna wurran-ka kardu matharr ngala yibim. Nhini-ka patha-wa nhini-yu nukunu namanpinu-yu i kardu matharrngini nhini-ka nanawathanu patha deyida pinu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Bere Jesus-ka punnadha-warda-neme kardu ngarra pule nhini-nu ngarra thelput nukunu-nu. Bere ngarra Jesus-te manta warda wurrinidha ngarra thelput nhini-ka ku pule nhini-ka wurdanpunkuthukneme kardu ngarra nukunu ngarra Jesus-nu wunku murrinh wanku. I pumamnaneme ngarra Jesus, “Pule, kanhi-wa murrinh ku pule nganki murrinh wurdanpathuk-yu. Nga. Mere thurru nukun kathu ngarra thelput ngay-yu. Ngay-ka thunungiwerdi-wa nukun nhini-yu. I ngay wangu mere ngurrumpa nukun ngarra nhinhi-yu. Mu pana da kathu thirranu i murrinh thamanu pana da kathu i nhini kardu matharr-ngini kanhi-ka patha warda nawathanu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngay deyida wanku ku pule ngala dimnga ngarra ngay-yu i ngay-ka ku pule ngala ngempirra ngarra ku soldier ngamere-yu. I ngay mamna kardu ngarra ngay numi, ‘Pangu wangu thunu thi.’ I nukunu-ka nhini wangu nungam dim. I mamna kardu numi, ‘Thurru kathu.’ I nhini-ka wurran warda kathu. I mamna kardu numi deyida, ‘Mange kanhi thamanu.’ I nhini-ka nukunu-ka mange nhini-ka mamnga deyida.” Nhini-wa murrinh ku pule ngala soldier nhini wurdannathuk ngarra Jesus-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bere Jesus-ka memnamardat da matha thathpirr warda ngarra kardu nhini kathu bimnayepup-yu. I bere wurdampirramardarduy warda pirrim kardu ngarra terert parraniriwaktha purni i murrinh mampirra, “Nga. Murrinh thathpirr kanhi manarranu-yu. Kardu pule ngala soldier pangu-ka murrinh thathpirr mamngabath murrinh kardu matharrngini pangu-nu patha mawathanu. Kardu Jews-wa thathpirr mere murrinh thathpirr kumangabath karni-yu nginipunh kardu pule ngala kanhi mani kardu ngamengka murrinh mamngabath kanam-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bere kardu peneme pana ngarra ku pule nhini wurdanpunkuthukneme ngarra Jesus-nu-ka kardu warda puddamkawurlneme ngarra thelput ku pule nhini nukun i pubamkangkarduneme kardu matharrngini-ka kardu patha warda dinidha manangka matharr. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bere nhini thangunu nukunu Jesus-ka da numi-nu warda wangu nadha dini da nan-nu Nain. I pulangay nukunu wanku purnedhaneme i kardu wurnangat deyida wanku. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bere ngarra Jesus manta mana warda wurrinidha da ngarra gate da town nhini-ka, nukunu-ka bampunkardu kardu wurnangat punganawurrdha warda kathu purni wunku ku kardu yibimpup pubabirrnu ngarra nanhthi stretcher kathu pumenamathbaththaneme purne. Kardu yibimpup nhini-ka wakal nugarn nigunu numi da matha kardu palngun mekmunurr nhini-yu. I nigunu-ka du wurrinikarrktha. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bere Jesus-ka bamkardu kardu palngun nhini-yu i dammardathin warda nigunu-nu. I murrinh mamnge, “Nga, mere thurrukarrk nukun,” mamnge. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bere Jesus-ka wurrinidha ngarra nanhthi stretcher i mange-re warda manthap. I kardu ngarra pumenamathbaththaneme purne-ka pibimkat-warda-neme. Bere Jesus-ka mamna warda kardu ngarra yibimpup nhini-yu, “Ya. Thewirnturt kathu kardu nugarn pana ngarra thibimpup-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bere kardu nugarn yibimpup nhini-ka dempirnturt wurdamkabirl warda i kardingerrentha warda nhini-yu. Bere Jesus-ka wurdanngengkarl warda ngarra kalekale wangu-yu nukunu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bere kardu wurnangat-ka pumemnamardat ngala da matha i Yile neki warda parraniriparldha pardi. I kanhi-wa murrinh-yu pumenanudha purni, “Ya. Kardu kanhi karrim-ka kardu ngala thathpirr-wa ngarra Yile neki thangunu kathu kardu prophet-ya. Yile neki-ka pangannheruy-warda-ngime i manhimanpinungime.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bere nhini thangunu ngarra Jesus wurdankabirl kardu nhini-ka murrinh warda banalangtha wurrini da pana ngangka-re da ngarra ngala nan-ya Judea i da manta ngangka da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bere kardu pulangay nukunu John the Baptist-ka puyemnayepup deyida mange da ngarra Jesus wurdankabirl kardu yibimpup nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","I bere nukunu John the Baptist-ka pirrimpirrukaynintha kardu pulangay nukunu perrkenku i murrinh mampirrunintha, “Nga penintha. Thununinthanu thi ngarra Jesus i thaninthadharrpunu nukunu kama kardu Pule ngala ngarra Yile neki wurdanthuk-yu i kardu Pule ngala numi kama nakurlnu purrunu kathu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bere pangu warda wangu naninthadha dini ngarra Jesus-nu i pangamnintharuy da mana i murrinh pumamnanintha, “Ya Pule. Nukunu John the Baptist-ka wurdanngankuthuknintha wunku murrinh kanhi. Nhinhi da kama kardu Pule ngala ngarra Yile neki wurdannhithuk i kardu Pule ngala numi deyida kama da nakurlnu purrunu kathu i nukunu nhini kama ngarninamardamardanu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bere da ngarra nhini-re damninthadharrpu-ka Jesus-ka kardu matharr-wunngini menpathadha wurrini i kardu kamarrama terert menpathadha dini i ku ngepan wiye pirrinmapuththa wurrini ngarra kardu thangunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bere Jesus kathu mampirrunintha ngarra kardu pana ngarra John the Baptist wurdanpunkuthuknintha-yu, “Nga. Thurdininthawurlnu ngarra John the Baptist deyida i numananunintha da mange kanhi ngarra nubengimangkardudhanintha thardi-ya i murrinh ngarra kardu kathu pumenarrudhanintha parde. Kardu kamarrama-ka pumpanmirlbirl deyida i kardu pulith-ka pumpannilili deyida nhini-yu. I kardu matharr leprosy pumebaththa purni-ka kardu tarangka warda pumpan. I kardu ngarra the wiye-ka pubinthewup deyida pumpan nhini-yu. I kardu ku puwup thangunu-ka kardu birnu deyida pumpan nhini-yu. I kardu ngarra nanhthi purrkpurrk pumpanyeyma-ka berengunh murrinh thelerrdhe patha ngarra Yile neki thangunu pubinthepup. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","I kanhi numi-yu. Nga. Kardu nangkal ngatha bere ngatha wangu murrinh mangabathnu purru i mere kaningipart nukun, kardu nhini-ka le da matha paninu nhini-yu. Nhini-wa murrinh-yu numaninthanu ngarra nukunu John the Baptist-yu,” Jesus kathu-yu mampirrunintha. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bere penintha nhini-ka pangu deyida wangu wurdamninthawurl ngarra John the Baptist-nu. Bere Jesus-ka wurdanarrayiththa dini kardu ngarra wurnangat-yu ngarra murrinh nukunu-nu John the Baptist. I mampirra, “Nga kardu. Da marra-re nganaka ngarra nanki-re da pangu wangu ngarra da darrinpirr pularn nunninadha John the Baptist-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? Kardu manangka lurruth ngala kama numenadha nurni-yu nginipunh nanhthi parnu mani wurdanparl pirrim nanhthi wirrirr-te-yu? Mu wurda nawa nukunu-yu? Nukunu-ka kardu lurruth ngala da matha kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","I ngana deyida nunninadha ngarra nukunu-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? I numenadha nurni nanhthi kaligu patha patha kama banardurdidha wurrini? Mu wurda nawa? Kardu pana ngarra kaligu patha patha pubardurdi pumpan-ka da ngarra thelput ngala ngala da matha pumpannupup-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","I ngana deyida nunninadha ngarra nukunu-nu nubamkardu-ka, kardu ngarra mana-wa kardu nukunu nginipunh medha kardi-yu? Nanki-ka numenadha nurni nukunu-ka ku prophet kama i murrinh thathpi ngarra Yile neki nukunu kama wurdanayiththa wurrini? Yu, bere thathpirr-ya. Nukunu-ka ku prophet-wa kanam, ku prophet ngala thathpirr nungampunkuwewurtneme nukunu nhini-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","“Nga. Ku prophet ngamere murntak warra-ka murrinh parrarntilil murrinh ngarra nukunu-nu-yu John the Baptist. Ku prophet murntak nhini-ka Yile neki kathu murrinh kanhi-wa dampirrumutneme-yu, i mam, ‘Ngay-ka kardu nugarn ngurduthuknu wunku murrinh ngay-yu. Nukunu nhini-ka kumparra warra pununu pi i kardu warda manpathawathanu kardu ngarra nukunu nhini tiduk kathu purrunu-yu.’ Nhini-wa murrinh parrarntilil ku prophet ngamere da murntak warra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Nga, murrinh thathpirr kanhi manarranu-yu,” Jesus kathu-yu mampirra. “Nukunu nhini John the Baptist-ka kardu ngala thathpirr-wa kardu nungamnanpewurt ngarra kardu wurnangat kanhi warda ngatha ngarra da putek ngala kanhi narnam-ya, i kardu pana deyida wanku nungampunpewurt kardu ngarra da murntak warra pardingkadhuktha. Mu kardu nangkal ngatha ngarra murrinh thathpi ngay da matha mangabathnu purru-ka nhini nukunu-ka ngala thathpirr-wa punuwewurtnu ngarra nukunu nhini John the Baptist-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Kardu wurnangat da matha murrinh ngarra thathpi John the Baptist pubinanayepuptha punni-yu i da mange wiye parnampart i da mange ngarra Yile neki warda parraniriwaktha punni. I nhini thangunu nukunu John the Baptist-ka daninluluwewudha warda wurrini. Kardu wiyenpun deyida wanku ngarra ku mani punninmatkuttha ngarra kardu thangunu ku Government-nu da mange ngarra Yile neki parraniriwaktha deyida punni-yu i daninluluwewudha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mu kardu nugarn pana ngarra murrinh law puddininthethith punni-ka perremkamit da mange ngarra Yile neki nukunu i mere pubinanayepuptha murrinh thathpi ngarra John the Baptist i nukunu-ka mere warda denluwewudha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","“Mu nga,” Jesus kathu-yu mampirra deyida. “Nanki, kardu wurnangat narnam kanhi-ka kardu nginipunh mamay mani narnamyekdhek i narnampirrakaykay ngarra mamay ngamere-ya. I murrinh kanhi numampirra numpan, ‘Nganki-ka nanhthi dhekdhek ngardirrayekdhektha nanhthi kardu marrit mamngintha-ya ngathayida ngumenthart. Mu nanki-ka mere le narnidha nanhthi dhekdhek nhini-nu-yu. I nanhthi dhekdhek ngathayida ku birrbirr ngumenthart-ya, mu nanki-ka mere narnikarrktha.’ Mange nhini mani-wa nanki-ka mere da matha le patha narni.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Nga. Nukunu John the Baptist pangarntuy i mi dhepdhep kunungingki da matha kardimurrktha i mere kanigurdugurduktha kura wine-yu. I murrinh numenadha nurni nanki-yu, ‘Nukunu nhini-ka ku ngepan wiye kanthin wurran.’ I kardu nukunu nhini-ka narnampart warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I ngay, kardu ngarra darrikardu nanki thathpirr ngangarntuy-re-ka mi dhepdhep ngardimurrktha i kura wine ngardigurdugurduktha. Mu kardu-ka numamnga numpan, ‘Ya. Nukunu nhini-ka kardu bere matha wangu mi kanammurrk i kura kanamkurdugurduk-yu. I nukunu nhini-ka wurrannupup-ya ngarra kardu wiyenpun i kardu ngarra ku mani pumpanpunmatkut ku Government-nu-ya,’ numamnga numpan ngarra ngay-nu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Mu nga. Kardu nangkal ngatha ngarra Yile ngay darntiwak wurran-ka nukunu nhini-ka the kanthin da mange ngarra nukunu thathpirr-ka patha-wa nhini-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bere nhini thangunu-ka kardu Pharisees numi kathu dantharrpu Jesus mi dhepdhep-nu pininthamurrknu. Bere Jesus-ka pangu warda wangu wurrinininthadha ngarra thelput nukunu da mana i dinininthamurrktha pangu da. Murrinh nukunu kardu Pharisees nhini-ka Simon-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bere da ngarra town nhini-ka kardu palngun wiye thathpirr merithuktha kardi pangu da kardidha. I nigunu-ka pamnayepup Jesus-yu mi dinininthamurrktha-yu ngarra thelput nukunu Simon kardu Pharisees-ya. Bere nigunu-ka nanhthi oil wunku kangunu patha manganart nanhthi pul-te i wurrininadha ngarra Jesus-nu ngarra thelput nhini da. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bere Jesus-ka denawinhimunedha yu ngarra mi-re yumurrktha-yu. Bere kardu palngun nhini-ka wurrininadha i pirret tiduk kathu i pirrikarrktha. I nanhthi kakpa nigunu-ka danimewewudha pirri ngarra me nukunu Jesus. I dilangammertum warda nanhthi pemarr ngarra nigunu-re. I dammedhung i dammewewu nanhthi oil wunku kangunu patha nhini-yu ngarra me nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bere nukunu Simon-ka bangammangkardu da mange nhini-nu-yu i murrinh memnu marda-re, “Kardu nugarn kanhi ngatha murrinh ngarra thathpi Yile neki ngatha kurdiyith kurru-ka nhini nukunu-ka the-wa mabath kurru kardu palngun kanhi ngarra manthadhap kanam-ka kardu wiye ngala thathpirr-wa i nhini-ka kurdungkarel-wa nukunu-yu kardu palngun kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mu Jesus kathu-ka mamna, “Simon, ngay-ka murrinh ngurdimpayithnu i murrinh mampanu.” “Thangku murrinh Pule?” Mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bere Jesus kathu-ka mamna, “Nga. Kardu nugarn yina ku mani dampirrumut-ngadha-nintha ngarra kardu. I ngarra kardu numi-ka damnamut $100 i ngarra kardu numi damnamut-ka $5-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","I da nakurl-te-wa nukunu-yu dampunkudharrpunintha ku mani-nu purdunangkarlnintha-nu. Mu kardu penintha nhini-ka mere ngarra ngadha purdinangkarldhanintha, mananhthi. Bere nhini thangunu nukunu kardu pana ngarra ku mani dampirrumutnintha-ka murrinh mampirrunintha ngarra penintha nhini-yu, ‘Nga. Nankunintha-ka mere ngarra nuddungangkalathnintha ku mani-yu, nhini-ka thuyninthayekum warda.’ I bere nga,” Jesus kathu-yu mamna ngarra Simon. “Kardu nangkal nimin penintha nhini-yu marda thathpirr manganart-yu kardu pangu ngarra ku mani dampirrumutnintha-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mu Simon kathu-ka mamna ngarra Jesus, “Kardu nugarn pana kama ngarra ku mani ngala damnamut ngadha.” “Yu nhini da,” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bere Jesus-ka wurdamngerduy kardu ngarra palngun nhini wangu i murrinh deyida mamna ngarra Simon, “Nga. Ngay nganardi ngarra thelput nhinhi-ka mere thengamuttha kura patha-yu nanhthi putekngime ngarra ngay-yu ngurdanamekulktha-yu. Mu nga. Kardu palngun kanhi-ka damngimewewu ngarra nanhthi kakpa nigunu-re i dilamngimertum ngarra pemarr nigunu-re. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","I nga. Nganardi ngarra thelput nhinhi-ka mere thengidhamurrudhungtha i mere thengiwewewudha nanhthi oil wunku kangunu patha ngarra pemarr ngay-yu. Mu kardu palngun kanhi kem-ka bere matha wangu daningimedhungnhungtha dini i damngimewewu nanhthi oil wunku kangunu patha ngarra me ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yu, kardu palngun kanhi-ka marda-wa thathpirr manganngert ngay-yu, nhini ngay-ka ngarrimmaputh warda da ngarra mange wiye terert kanthidha wurrini-yu. Mu ngay ngatha ngirramaputh da mange wiye kunungingki da matha ngarra kardu pangidharrpunu, nhini kardu nhini-ka kunungingki da matha marda mangert-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bere Jesus kathu-ka mamnge kardu ngarra palngun nhini-yu, “Ngay-ka ngarrimnhimaputh warda da mange wiye terert ngarra thanthidha thurrini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bere kardu ngamere ngarra pirrinimurrktha pangu-ka pubimnayepup murrinh nhini ngarra Jesus mamnge-yu i murrinh pumemnu mange pigunu, “Ya. Nangkal kardu kanhi-yu? Nukunu kanhi-ka da mange wiye ngatha yida wanku pirrimpunmaputh wurran ngarra kardu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bere Jesus kathu-ka mamnge deyida ngarra kardu palngun nhini-yu, “Nhinhi-ka murrinh thathpi ngay namngabath thathpirr i nhini-ka kardu tarangka warda thurran i mamnhiyibirnu da mange wiye thangunu. Mampa, thurrunu warda i wunku marda pekpek wanku thurrunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bere nhini thangunu-ka Jesus i kardu pulangay nukunu 12-ya punnewatthaneme da ngarra town terert da matha. I nukunu-ka murrinh daninthelerrdha wurrini ngarra kardu Yile neki ku Pule ngala thathpirr-yu i pirranpenu pani kardu ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","I kardu palngun ngamere deyida punnewatthangime ngarra Jesus-yu. Kardu palngun nhini-ka da murntak warra Jesus matharr menkuwathadhangime dini-yu i ku ngepan wiye pirrinkumapuththangime dini. I kanhi-wa kardu murrinh peningime ngamere-yu kardu nan-ya Mary Magdalene ngarra ku 7 mebaththa wurrini ku ngepan wiye Jesus pirrimmaputh-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","I nan Joanna. Nangkun nigunu-ka nan-wa Chuza kardu pana ngarra wurlk menadha wurrini ngarra ku pule ngala Hered. I kardu numi deyida-ka nan Susanna. I kardu palngun ngamere deyida wanku punnewatthangime-yu ngarra Jesus i mi wanku punnirrakutkutthaneme i pumerrawathawathadhaneme punne Jesus i pulangay nukunu-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bere kardu wurnangat nimin-ya punninawattha ngarra Jesus-nu da ngarra terert thangunu kathu i kardu puyemnawerr warda ngarra nukunu. Bere Jesus-ka murrinh warda wurdampirrayith murrinh yibimkamnum. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","I mampirra, “Nga. Murrinh kanhi-ka murrinh ngarra kardu nugarn wurlk medha wurrini ngarra mi kadin. Nukunu-ka mi kamarl mangankut i mi warda kamarl wurriniwuthpuththa weyi ngarra ku puliki meyeththa wurrini nanhthi thay pangkuy wuting-te. Bere nukunu-ka da pana-re-ya mi wurriniwuthpuththa-yu. “Bere mi kamarl ngamere-ka banawaththa wurrini ngarra mayern-wa i kardu warda mi-yu punnadhurrthurrdha punni-yu i mi ngamere ku murrirrbe-ka pardimurrktha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","I mi kamarl ngamere-ka banawaththa wurrini ngarra palyirr kurethkurethmam. I mi-ka puddarnturturt, mu dempunmugarl nhini nanhthi putek nhini-ka tumtum-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I mi kamarl ngamere-ka banawaththa wurrini ngarra nanhthi nan wangu mayeyep. I mi-ka pangarnturtuy i puddarnturturt, mu nanhthi mayeyep deyida puddarnturturt ngala da matha i mi-ka pumpanpunpekarl i parrampirradhap mi nhini-yu i pumpanpunthinkun warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","I mi kamarl ngamere-ka banawaththa wurrini ngarra putek patha. I mi-ka pangarnturtuy i puddarnturturt i mi kamarl pelpith terert da matha warda pinthutut nhini-yu. “Kardu nangkal ngatha mangimarta murrinh niyith-niyith kanhi-ka nukunu kardu nhini-ka murrinh-ka mabath warda nhini-yu,” Jesus kathu-yu mampirra, murrinh lurruthmanthay-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bere pulangay nukunu Jesus kathu-ka pumamnaneme ngarra Jesus, “Ya pule. Thurdungarrumeriyith-mani-neme murrinh pana ngarra kardu mi kamarl wurriniwuthpuththa-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bere Jesus kathu-ka mampirruneme, “Yile ngay-ka bannankuwerdi-wardarra-neme ngarra mukmuk nankuneme-yu da ngarra mange nukunu-yu, i da mange ngarra ku Pule ngala thathpirr pinu-yu. I mere nangkal ngadha the mebaththa wurri da mange nhini-yu, mu nanki da matha the warda thathpirr nanthin. Mu kardu ngamere-ka pubinthepup da matha pumpan murrinh niyith-niyith yibimkamnum-ya. Mu mere thathpirr kumarta murrinh nhini-yu, wurda da matha. I kardu nhini-ka da mange ngarra ngay pubamngimangkardu pumpan mu mere kumarta da mange ngarra Yile ngay nukunu-yu. I kardu-ka pubimngayewup pumpan, mu mere thathpirr kumangimarta kuru. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nga. Murrinh nhini-ka ngurdunarrumeriyithnu-warda-neme,” Jesus kathu-yu mampirruneme. “Mi kamarl pana ngarra kardu nhini wurriniwuthpuththa-ka nginipunh murrinh thathpi Yile ngay nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I mayern pana ngarra mi kamarl ngamere banawaththa wurrini-ka nginipunh kardu pana mani ngarra murrinh thathpi Yile ngay pubinthepup, mu ku karrath kathu wurran-ka i murrinh nhini-ka manganpunmart warda. I nhini kardu-ka mere warda kubiyepup murrinh nhini-yu i mere ngarra murrinh kumanabath i nhini Yile ngay-ka mere ngarra warda manthibirnunu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","I palyirr kurethkurethmam pana ngarra mi kamarl ngamere banawaththa wurrini-ka nginipunh kardu pana mani ngarra murrinh thathpi Yile ngay pubinthepup i le patha ngadha murrinh pumamyit pumpan. Mu murrinh kunungingki da matha ngadha pumamyit i nhini-ka mere ngadha ngepan lurruth kuddururturt nhini-yu. I ngarra ku karrath-te mampuntullul murrinh nhini parnipartnu-ka, nhini murrinh-ka parnampart warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I nanhthi mayeyep pana ngarra mi kamarl ngamere banawaththa wurrini-ka nginipunh kardu pana mani ngarra murrinh thathpi Yile ngay pubinthepup, mu kardu nhini-ka mere thathpirr kuddunayemit kuru ngarra Yile ngay-yu mu bere matha wangu pubenthengkarnirn pumpan ku mani-nu i da mange pekpek-nu. I nanhthi nhini-ka dampirradhap i kardu-ka mere ngarra ngepan lurruth kuddururturt nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","I ngarra putek patha pana ngarra mi kamarl ngamere banawaththa wurrini-ka nginipunh kardu pana mani ngarra murrinh thathpi Yile ngay pubinthepup. I kardu-ka murrinh thathpirr pumamnabath pumpan i bere ngatha wangu pumamyit pumpan murrinh nhini-yu i da mange patha da matha pamam pumpan Yile neki-nu. I nukunu-ka le da matha wurranpirra nhini-yu.” Jesus kathu-yu mampirruneme murrinh wurdanpirrumeriyithneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bere Jesus-ka murrinh niyithniyith numi deyida wurdampirrayith i mampirra, “Nga. Mere nangkal ngadha karibirl thungku lem-yu i bupak pepe ngarra nanhthi pakit i ngarra da pit pepe, wurda. Mu nukunu-ka mamkale kangkarl kathu thungku parlarrangnu pintha i kardu ngarra thelput nukunu-re parnimardinu-ka nhini-ka thungku nhini warda pubangkardunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","I nga. Murrinh nginipunh nhini deyida mani murrinh niyithniyith yibimkamnum nhini-ya da nakurl-te-wa murrinh nhini pumartanu-yu kardu-yu. Mu kardu-ka murrinh-ka mere da ngatha the kumabath marra-yu, mu da nakurl-te-wa murrinh nhini-yu the pumabathnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nhini nanki-ka murrinh thathpirr nubiyewup nuru. Murrinh kunungingki ngatha numarta nuru-ka, nhini Yile neki-ka kanarramut warda numamarta ngala da matha. Mu mere nubiyewup thathpirr nuru-ka nhini Yile neki-ka mananmartnu warda murrinh ngarra kunungingki ngarra namam numpan numanganmarta-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bere kale nukunu Jesus i ngathan nukunu-ka parramkaruyngime ngarra kardu ngarra parraniwegattha pirrini ngarra Jesus-yu. Mu kardu-ka mere ngarra puyenadhangime ngarra Jesus-yu nhini-ka kardu wurnangat da matha pinganulipiyiptha pirrini ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bere kardu ngamere parrantherr Jesus-yu i pumamna, “Ya. Kale nhinhi i ngathan nhinhi-ka pangu da outside kibimkangime nhinhi-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mu Jesus kathu-ka mampirra, “Nga. Kardu nangkal ngatha murrinh thathpi Yile neki nukunu biyepupnu purru i murrinh manabathnu purru, nhini nukunu-ka kardu ngarra darrikardu ngay thathpirr-wa. I kardu-ka nhini-wa kale ngay-yu i ngathan ngay-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bere Jesus-ka kanammardap ngarra tharntu wunku pulangay nukunu wanku parnamkamardapneme. I mampirruneme, “Ka peneme. Purrukath-wa-neme ngarra ngipilinh ngala kanhi i ngamimarda pangu kathu.” Bere pumpankardurr-warda-neme da ngamimarda-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bere puy purnedhaneme ngarra ngipilinh ngala i Jesus-ka ngurrnguwarl warda yungurrkurrktha ngarra tharntu nhini-yu. Bere nanhthi wirrirr ngala pangampirruruyneme wanku kura ngurntinh ngala, i tharntu-ka kura medhalerttha warda wurrini i dedhardumtha warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bere peneme-ka pumamkardurt-warda-neme Jesus-yu i murrinh pumamnaneme, “Pule, Pule. Kardu pangankudhardumnu-warda-neme ngankuneme-yu.” Bere Jesus-ka dempirnturt warda i banpunkudhapnintha thu wirrirr ngala nhini-yu i kura ngurntinh ngala deyida wanku. I nhini thangunu ngipilinh nhini-ka watmam deyida dinidha. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bere Jesus kathu-ka mampirruneme, “Ya peneme. Thangku-dha nankuneme nerremkanhamneme numpanka-yu? Nankuneme-ka murrinh-wa numangabathneme nhini-yu ngirranankupeneme ngurru.” Bere peneme nhini-ka pumemnamardatneme i perremkanhamneme i murrinh pumemnungkuneme mange peneme, “Ya, kardu kanhi-ka kardu mere nginipunh nekineme mani. Nukunu-ka kardu lurruth ngala nimin-ya. Nanhthi wirrirr ngala i kura ngurntinh ngala wanku deyida murrinh pumamnabathnintha murrinh ngarra thathpi nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bere pumpankakath-warda-neme da ngamimarda pangu kathu ngarra ngipilinh ngala nhini da i pibimkatneme ngarra kardu nan pardipuptha, kardu Kadarinh. Da nhini-ka demninthamardatat dim da nan-ya Kelili da ngamimarda pangu kathu ngarra ngipilinh ngala nhini-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bere Jesus-ka wurdawal ngarra tharntu kathu i pirret ngarra dimunurdi. I kardu nugarn wunku ku ngepan wiye terert kanthidha wurrini bangammardabi warda. Kardu nhini-ka mere kanipuptha ngarra thelput ngarra da town-yu mu da pirdithme nimin-ya ngarra mintilbith da matha kardipuptha kardu marlang da matha kardidha. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ku ngepan wiye nhini-ka bere matha wangu punningawurttha kardu nhini-yu. I kardu-ka nanhthi chain-te mana-wa pumedharrkirrktha mange i tharrmu i pirangibaththa mana-wa mu wurda, puddamnabay. Nukunu-ka bunirartaldha wurrini nanhthi chain nhini-yu i ku ngepan wiye-ka pumengkayidha punni da ngarra kardu makardu wangu pardidha-ya. Mu ngarra nukunu-re kardu nhini bamkardu Jesus-ka, kardu warda pirrimkay i bamnabat dempinhimardardum ngarra Jesus kumparra pangu warra i murrinh lurruth mamna, “Ya Jesus. Nhinhi-ka wakal Pule ngala Yile neki nukunu-wa,” mamna. “Thangku-nu ngay-nu-yu marda nanganngert-yu? Mere thungibat nukun ngay-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Nangkal murrinh nhinhi-yu?” Jesus kathu-yu mamna. “Murrinh ngay-ka wurnangat-wa,” mamna. “Nhini weyida ku ngepan wiye ku wurnangat nimin-ya nganthin ngurran-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Bere ku ngepan wiye nhini-ka pumemnarlupurl Jesus-yu i pumamna, “Mere thurdungankarel nukun pangu-yu da thipmam binhi-yu ngarra ku ngepan wiye terert parnam-yu mu pangu da matha thurdungankarelnu ngarra ku pigipigi pangu-yu i ku ngarninnginirdinu.” Bere Jesus-ka wurdanpunkarel warda ngarra ku pigipigi terert ngarra pardimurrktha manta ngangka da ngarra palyirr. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bere ku ngepan wiye nhini-ka pungawurr ngarra kardu nhini thangunu kathu i parnampunnginirdi warda ngarra ku pigipigi wangu-yu. I nhini thangunu-ka ku pigipigi-ka tharra warda dinidha parrampirntigat ngarra palyirr thangunu kathu ngarra ngipilinh ngala da mana. I nhini-ka dampunthiwik warda ku nhini-yu i bangarntikerdek da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bere kardu nugarn pana ngarra ku pigipigi pirapedhaneme parde-ka mange nhini pubamkangkarduneme i tharra warda punnungamkawinhatneme i murrinh parraninkuyelerrdhaneme ngarra kardu da ngarra town i da pana ngangka-re-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bere nhini thangunu-ka kardu wurnangat nimin-ya punnidha pangu-yu i parramnaruy ngarra Jesus. I pubamkardu warda kardu ngarra ngepan wiye ku wurnangat mebaththa wurrini dinidha ngarra Jesus-yu. Nukunu-ka kardu pelpith patha thathpirr warda dinidha i nanhthi kaligu thathpirr warda banardidha dini. I nhini kardu-ka perrenham warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bere kardu nugarn pana ngarra Jesus pubangamkamangkarduneme kardu nugarn nhini patha mampatha-ka nhini-ka murrinh warda parraninkuyelerrdhaneme punne murrinh ngarra kardu nhini patha mampatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bere nhini thangunu kardu nhini nan Kadarinh-ka kardu perrenham ngala da matha mange pangu thangunu ngarra Jesus medha wurrini-yu i parrantharrpu warda Jesus kardu da panipartnu da pangu ngarra pigunu-yu. I bere Jesus-ka wurdawurl ngarra tharntu i kanammardap warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Mu bere kardu nugarn nhini-ka ngarra ku ngepan wiye mebaththa wurrini-ka memnarlupurl ngarra Jesus i mamna, “Ngay deyida wanku purrunu?” Mu Jesus kathu-ka mamna, “Awu wurda. Mu pangu wangu thununu thi da ngarra nhinhi i kardu thanthelerrnu thurru Yile ngay-ka patha mamnhiwatha warda.” I bere wurdanthuk warda kardu nhini-yu. Bere kardu nugarn nhini-ka da pana ngangka-re wurriniwattha i kardu daninthelerrdha wurrini murrinh ngarra kardu Jesus patha mampatha nukunu-yu. Bere Jesus-ka nungardurr warda da nhini thangunu-yu i wurrankath deyida da ngipilinh ngamimarda pangu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bere ngarra nukunu-re Jesus wurdawurl da ngamimarda pangu deyida kathu-nu ngarra punnadha-kathu-neme, kardu wurnangat-ka pirrininamardamardadha i nhini-ka puyemnamarda warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bere kardu nugarn wurrininadha ngarra Jesus-nu. Murrinh nukunu-ka Jairus-wa i nukunu-ka ku pule ngala deyida ngarra da church kardu Jews pigunu. Bere nukunu Jairus-ka demnawinhipingkarl ngarra Jesus kumparra warra, i mamna, “Pule nga. Thurrunu kathu ngadha ngarra thelput ngay wangu? ");
INSERT INTO mwf2018_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kardu wakal mardinhpuy ngay-ya kardu matharr ngala yibim kardu manta warda pupupnu. Nigunu-ka kardu da thangku 12-wa. I ngay-ka kardu wakal mardinhpuy makardu-re warda kathu, mu kardu numi da matha nganthin nganam,” mamna. Bere penintha nhini Jesus i Jairus-ka naninthadha warda dini da ngarra nukunu-nu warda wangu nan Jairus. I kardu wurnangat wanku parraniriwaktha purni Jesus-yu i pubenarerdadha purni manta ngangka da ngarra Jesus-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bere ngarra kardu wurnangat nhini-ka kardu palngun numi ngangka da matharr kanthidha wurrini. Matharr nhini-ka kardu palngun nukun matharr kumulung-wa, i da bere matha wangu wurrinikutkuttha. Da-ka da pirdithme nimin-ya mebaththa wurrini-yu da thangku 12-wa. I nigunu-ka ku mani ngala da matha danirramutmuttha wurrini ngarra ku doctor terert kardu patha-nu pumewathadha mana-wa, mu puddamngebay da matha. Mere nangkal ngadha ku doctor patha mewathadha, wurda da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bere kardu palngun nhini-ka tiduk wangu wurrininadha ngarra Jesus i mammathap ngarra nanhthi kaligu nukunu da mana ngarra bunibalbalktha wurrini. I nhini thangunu-ka kardu patha warda kardidha nhini-yu i kumulung-ka mamngedhap warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bere Jesus kathu-ka mampirra kardu ngarra wurnangat nhini, “Ya. Nangkal kardu ngay mamngithap-yu?” Mu kardu kathu-ka pumenadha purni, “Nganki-ka wurda-wa.” Bere nukunu Peter kathu-ka mamna ngarra Jesus, “Nga pule. Kardu wurnangat kanhi-ka pubangamnhirerda pumpan i pumamnhidhadhap pumpan. I murrinh namngarra-ka, ‘Nangkal mamngithap-yu?’” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mu Jesus kathu-ka mampirra, “Awu, kardu thathpirr mamngithap. Nhini-ka ngingamnuthap nanhthi lurruth ngala ngarra ngay thangunu kathu-ka yungawuy warda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bere kardu palngun nhini-ka the warda mebaththa wurrini ngarra Jesus the warda kanthidha wurrini nigunu mammathap-yu. I nhini nigunu-ka wurrininadha pangu da ngarra nukunu wurrininawerrerrerrdha i demnawinhipingkarl kumparra warra ngarra Jesus. I murrinh damnardarrirda murrinh ngarra matharr nhini mebaththa wurrini i manthap nukunu-yu i nhini-ka patha warda kardidha manangka matharr. I kardu wurnangat wunku deyida pubimngeyepup murrinh nhini ngarra Jesus mamna-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bere Jesus kathu-ka mamnge, “Nga. Nhinhi-ka kardu patha warda manangka matharr thempirntiway thirrim pana-yu, nhini-ka ngarra ngay thangunu murrinh namngabath mamnhiwatha nhini-yu. Mampa, thununu warda marda pekpek wanku nabathnu thurru.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mu bere ngarra nukunu-re Jesus murrinh pirringengerren da-dha ngatha-ka kardu nugarn pangamnaruy wurran ngarra thelput nukunu thangunu Jairus wunku murrinh menabaththa tharra. I mamna warda ngarra Jairus, “Ya. Wakal nhinhi-ka mere warda thurduyemit nukun, ku berengunh. Mu nukunu Pule pana karrim-ka thuyekum warda wangu, da tiduk warda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mu Jesus-ka binthepup murrinh thelerrdhe nhini-yu, i mamna warda ngarra Jairus, “Nga. Mere werrerrnangini nukun i mere thenham nukun. Mu ngarra ngay da matha murrinh nangabath nigunu-ka ngurdungkabirlnu i panibirnu deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bere nhini thangunu-ka pangamnintharuy warda ngarra thelput nukunu Jairus. Bere Jesus-ka kanardi ngarra da thelput nhini-yu wunku Peter, John i James, i yileyile kalekale nigunu kardu mardinhpuy pana ngarra yibimpup-ya. Mu kardu ngamere-ka Jesus mampirra, “Mere narnirdi nukun pangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bere kardu wurnangat-ka du pardingekarrktha. Mu Jesus kathu-ka mampirra, “Ya kardu. Mere narnikarrk. Kardu mardinhpuy kanhi kabim-ka mere yungipuptha, mu kardu ngurrnguwarl da matha yibim.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mu kardu kathu-ka pangankampa warda ngatha ngarra nukunu Jesus-yu nhini-ka the panthidha purni kardu yibimpup thathpirr nigunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bere Jesus-ka wurriningedha ngarra kardu mardinhpuy nhini-yu i mange ngarra nigunu manganart, i murrinh mamnge, “Ya. Kardu mardinhpuy, thewirnturt kathu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bere nanhthi ngepan ngarra nigunu-ka wurdamngewurl deyida i birnu deyida dinidha i dempirnturt warda. Bere Jesus kathu-ka mampirrungintha ngarra yileyile i kalekale nigunu, “Nga. Mi-ka nangemutngintha mi pulathnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bere peningintha-ka pumemnamardat-thathpirr-ngintha nhini-yu. Mu Jesus kathu-ka murrinh deyida mampirrungintha, “Nga peningintha. Mere nukun thanginthardarrirda ngarra kardu da mange kanhi thangunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Bere Jesus-ka pirrimpirrukayneme panpunkuwerrneme kardu nukunu kardu 12-ya. I murrinh mampirruneme, “Nga peneme. Ngay-ka nanhthi lurruth ngala nganarrumutnuneme i bunankupaknuneme ngala deyida wangu i nhini-ka ku ngepan wiye nirankumaputhnu-warda-neme na ngarra kardu thangunu kathu-yu i kardu matharr-wunngini patha numankuwathanuneme nuru. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mampa, nawardaneme da pana ngangka-re-ya i murrinh kanhi-ya kardu nuddurruyithnuneme nuru, ‘Ya. Narnipartnu warda da mange wiye pana ngarra numammath numpan-yu i nuddunawurlnu ngarra Yile neki i nhini nukunu-ka kardu pule ngala thathpirr pinarranu i pirrananpenu pani’, murrinh-ka nhini-wa numarranu nuru-yu. I kardu matharr-wunngini patha numankuwathanuneme nuru. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I nga,” Jesus kathu-yu mampirruneme. “Ngarra nunnardurrnuneme-re-ka nanhthi purrkpurrk-ka mere nukun numabath nuru. Nanhthi nginipunh thay ngarra wilili nukunu, nanhthi bag-ya, mi lawam-ya, ku mani-ya, nginipunh nhini mani mere numabath nukun nuru, wurda. I nanhthi kaligu pana da matha ngarra nubamkardurdineme nibimka nhini da matha numabathnuneme nuru-yu, mu kaligu numi deyida wangu-ka wurda-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“I nga. Kardu nangkal ngatha nunamardalenuneme ngarra thelput nukunu-ka nhini da matha nenemenu i ngarra nunnardurr-da-nu-mana-neme da town numi deyida-nu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mu kardu ngatha mere nunungkumardalenemenu-ka nhini da ngarra nhini narnepartnemenu-re-ka me sandal-ka nunguynungkumewurrnuneme i putek ngarra me sandal pepe thangunu-ka nuyunungkumerurtulnuneme. I kardu nhini-ka the warda pumabathnu Yile neki-ka mere warda le pirranu nhini-yu, nhini-ka parramnankungkamit-da-matha-neme nhini-yu,” mampirruneme Jesus kathu-yu. Bere nhini thangunu Jesus-ka wurdanpunkuthuk-warda-neme kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bere kardu peneme nhini-ka da pana ngangka-re purnewatthaneme da ngarra town terert-ya. I kardu murrinh thelerrdhe patha ngarra Yile neki thangunu parraninkuyelerrdhaneme purne. I kardu matharr-wunngini patha pumenkuwathadhaneme purne. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bere kardu pule ngala nhini Hered-ka pamnayepup Jesus ngarra mange ngarra patha-patha medha wurrini-yu. Mu nukunu-ka mere thathpirr the mebaththa wurri Jesus-yu. Nhini-ka kardu ngamere pumenadha punni Jesus-ka John the Baptist kardu wurdamkabirl deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","I kardu ngamere pumenadha punni Jesus-ka kardu ngalantharr murntak Elijah. I kardu ngamere deyida pumenadha punni Jesus-ka kardu ngalantharr murntak numi ngarra murrinh thathpi Yile neki wurdanarrayiththa wurrini wurdamkabirl deyida. Nhini-wa nukunu Hered-yu mere thathpirr the mebaththa wurri Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mu memnu marda-re, “Kardu pana John the Baptist-ka pelpith nukunu banganthamartal murntak warra-wa nhini-yu. Nhini-ka kardu nangkal mana-wa kardu nugarn pana ngarra ngamnayepup murrinh ngarra kardu thangunu-yu?” Memnu. Nhini-ka nukunu Hered-ka bengkardudha mana-wa Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bere kardu 12 apostle nhini ngarra Jesus wurdanpunkuthukneme-ka kardu puddanalaththa-warda-kathu-neme pe ngarra Jesus deyida. I murrinh warda pardenadharrmudharrmudhaneme parde murrinh ngarra peneme kathu puddininkuyethiththaneme punne ngarra kardu i mange ngarra pumerrudhaneme punne-yu. Bere nhini thangunu Jesus-ka menkubertidhaneme wurrini da nan-nu warda wangu Bethsaida mange peneme da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mu kardu-ka puyemnayepup Jesus nadha dini da Bethsaida-nu-yu i nhini-ka parriniriwaktha warda punni i ngarra pubangarntipak da mana. Bere Jesus-ka le punungammardale i murrinh warda wurdininthethitha dini murrinh da mange ngarra Yile neki nukun. I kardu matharr-wunngini patha menpathadha wurrini. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","13","Bere Jesus-ka murrinh wurdininthethiththa dini i ngarra tina kananthurrk da mana. Bere pulangay nukunu-ka punnenadhaneme i pumamnaneme, “Pule, kardu-ka thurdunthuknu warda ngarra thelput manta manta kanhi nimin pumpan-ya mi-nu parnikutkutnu i da-nu parniwitnu. Mi-ka mami-wa da kanhi-yu,” pumamnaneme. Mu Jesus kathu-ka mampirruneme, “Awu, nankuneme-wa mi dhepdhep narrumutneme mi pullathnu kardu kanhi-yu.” Mu peneme kathu-ka pumamnaneme, “Ngankuneme-ka mi lawam 5 da matha nganthinkaneme ngarrimka i ku ngurlmirl perrkenku wanku. Mu ngankuneme-ka mi deyida ngarnekutnuneme mi kardu kanhi-nu pullathnu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kardu wurnangat nimin-ya pangu-yu pirrinidha-yu nginipunh 5,000 mani kardu nugarn ngatha menthap-yu. Bere Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Kardu terert warda ngatha parniwupnu i nginipunh kardu 50 mani pumeyerryerrnu puru numarra wangu-yu.” Jesus kathu-yu mampirruneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bere peneme-ka murrinh pumampirruneme nhini ngarra kardu. I kardu-ka parnawup warda nhini-yu nginipunh 50 mani kanhi kathu i nginipunh 50 mani pangu wangu i nginipunh 50 deyida mani pangu-re. Mange nginipunh nhini mani-ya pana ngangka pumenayerryerrdha punni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bere Jesus-ka mangankut mi lawam 5 nhini-yu i ku ngurlmirl perrkenku wanku. I kangkarl mamka i Yile nukunu darntiparl mi-nu-yu i ku ngurlmirl-nu. I mi i ku nhini-ka mungarnterrarr i dampirrumutmutneme ngarra pulangay nukunu. I nhini peneme-ka ngarra kardu warda parranirrumutmutthaneme punne. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mi lawam i ku ngurlmirl nhini-ka Jesus-ka mewathadha pirri-ka mi terert warda nhini-yu i ku ngurlmirl-yu. Kardu wurnangat warda ngatha mi i ku pullamath-yu i kardu-ka mi i ku-ka bangampunmardan-wa. Bere nhini thangunu peneme nhini-ka punnekutkutthaneme mi i ku ngarra kardu thangunu parraniritmuttha punni. I nanhthi thelerrtherr nanhthi 12-wa pumedhalertertthaneme punne-yu mi i ku titmut-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bere Jesus-ka kardu numerrnu murrinh dininangerrentha ngarra Yile nukunu wangu. I kardu pulangay nukunu-ka manta ngangka da pirrinedhaneme. Bere peneme nhini pulangay nukunu-ka punnenadhaneme. I Jesus kathu-ka mampirruneme, “Nga peneme. Kardu-ka ngay-ka Jesus pumamngingkawadha pumpan-yu mu nangkal mana-wa thathpirr kardu pubemngayengkarnirn pumpan-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","I peneme kathu-ka pumamnaneme, “Kardu ngamere pubempayengkarnirn thathpirr pumpan-ka John the Baptist-wa. I kardu ngamere pubempayengkarnirn thathpirr pumpan-ka kardu ngalantharr murntak pana-ya nan Elijah-ya. I kardu ngamere deyida pubempayengkarnirn thathpirr pumpan-ka kardu ngalantharr murntak numi deyida ngarra murrinh thathpi Yile neki wurdanarrayiththa wurrini.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bere Jesus kathu-ka mampirru-deyida-neme dampunkudharrpuneme, “Mu nankuneme-ka nangkal mana-wa thathpirr numamnganeme numpanka-yu?” I bere nukunu Peter kathu-ka danthart i mamna, “Nhinhi-ka Christ-wa, kardu pana ngarra Yile neki mam purduthuknu da murntak warra-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mu Jesus kathu-ka mampirruneme, “Nga peneme. Kardu mere nangkal nukun murrinh numananeme ngay da kardu-yu Christ-yu i Yile ngay wurdanngithuk-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bere Jesus kathu-ka murrinh deyida mampirruneme ngarra pulangay nukunu, “Nga peneme. Ngay kardu darrikardu nanki thathpirr-ka da nakurlnu pumangirtanu i thu pungithuknu i thu pangilurturtnu purru ngay kardu nhini thangunu-yu kardu ngalantharr ngalantharr-ya i ku yilarn ngala ngala i kardu pana ngarra murrinh law nekineme puddanpunthethith pumpan-yu. I kardu nhini-ka mere murrinh pumangabathnu ngarra ngay-yu. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","I ngana deyida mampirruneme, “Kardu nangkal ngatha kardu ngarra ngay purrunu i pangilerrnu nhini-ka nukunu-ka puynuyekum-wa-nu purru i kanipart warda kurru da ngarra mange nukunu marda manganart wurran-yu i bere matha wangu pangiriwaknu purru. I kardu ngatha yida thu puthuknu puru i palurturtnu purru i thu purdurinuminu mangini ngay deyida mani pumanganu puru, kardu nhini-ka mangirart-da-nu-matha purru ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mu kardu nangkal ngatha marda mart menuyibirnunu i da mange ngarra nukunu da matha pamanu purru, nhini nukunu-ka pupup da matha-nu nhini-yu. Mu kardu nangkal ngatha puynuyekumnu thathpirr i ngay da matha kumparra bungipaknu, nhini nukunu-ka kardu bere matha wangu birnu paninu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“I ngana deyida kardu ngatha bemnuyengkarnirn kanam ngarra nukunu-nu ngatha i nanhthi purrkpurrk terert nimin bemmardarr wurran, nhini-ka patha-wa-nu nukunu-nu-yu? Awu wurda da matha. Mu ngarra nukunu nhini-re pupupnu-ka nanhthi purrkpurrk nhini-ka mere ngarra kumayibirnu nukun da bere matha wangu birnu paninu-yu, wurda da matha nhini-yu. I kardu-re pupupnu-ka mere deyida ngarra kurdingkabirl mange nukunu ngatha-yu. I nanhthi purrkpurrk nhini deyida mani wanku mere ngarra kuddungkabirl nukunu kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","I nga. Kardu nangkal ngatha yidiwe kurrunga i murrinh thathpi ngarra ngay yidi marradhay kurru ngarra kardu, nhini ngay kardu darrikardu nanki thathpirr-ka yidiwe ngurrunanu ngarra kardu nhini-yu da nakurlnu da nhini-re-ya ngarra ngay ngurru-deyida-nu kathu wunku lurruth ngala wanku ngarra Yile ngay thangunu kathu i ku angel terert deyida wanku. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“I nga. Murrinh kanhi-ka murrinh thathpirr-wa kanhi-yu,” Jesus kathu-yu mampirruneme. “Kardu ngamere nibimkaneme kanhi-ka mere da ngatha newuwupnuneme mu da ngarra nubangkardu-da-nu-mana-neme Yile ngay ku pule ngala thathpirr pirranu kardu ngarra nukunu-yu i pirranpenu pani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bere nginipunh da 8 mana mam-ka Jesus-ka mampirrukayneme Peter i James i John i kanthinpunkumardawithneme ngarra da palyirr kangkarl thathpirr-ya nukunu Jesus-nu pinangerrennu ngarra Yile nukunu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bere ngarra nukunu-re Jesus dininangerrentha ngarra Yile nukunu-ka kamarl ngarra nukunu wurdamnungkath warda i nanhthi kaligu ngarra banardidha wurrini-ka wurdannath nanhthi damlarrang bamam thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bere nhini thangunu peneme nhini pubamkangkarduneme-ka kardu ngalantharr perrkenku puddananayiththanintha pe ngarra Jesus wangu. Penintha nhini-ka kardu murntak nan-ya Moses i Elijah ");
INSERT INTO mwf2018_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","i kardu dampunkularrang-deyida-nintha. Penintha nhini-ka murrinh puddananayiththanintha pe murrinh ngarra da nakurl-te-wa Jesus pupupnu thu kardu-re thangunu da pangu-yu Jerusalem da ngarra mange Yile nukunu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bere Peter peneme nhini-ka kardu pirrinewalawalakadhaneme pangu-yu. Mu ngarra Jesus-te danilarrangtha pirri-ka peneme-ka wert pirrimkangkaneme i pubampunkungkarduneme Jesus i penintha pana Moses i Elijah dampunkularrangneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bere ngarra penintha nhini-re kanininthaparttha warda Jesus-ka nukunu Peter kathu-ka mamna ngarra Jesus, “Ya pule. Da patha-ya patha da mange kanhi-yu ngarra nekineme thanamneme kanhi-yu. Ngankuneme-ka nanhthi wuwup ngawupnemenu nanhthi perrkenkuneme. Nanhthi numi nhinhi-nu nanhthi numi nukunu Elijah-nu i nanhthi numi nukunu Moses-nu.” Nukunu Peter-ka murrinh dampinhun warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bere ngarra nukunu-re Peter pirrinangerrentha-ka nanhthi kalakkalak wurrinidha kathu i dampunkurdarrupneme Jesus i penintha nhini Moses i Elijah. I kardu pulangay nukunu Jesus-ka perremkanham-warda-neme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","I murrinh ngerren warda pubimkayepupneme ngarra kalakkalak kathu-yu i murrinh kanhi-wa mampirruneme-yu, “Ya. Kardu nugarn kanhi karrim-ka kardu wakal ngay-wa. I ngay-ka marda-wa thathpirr manganart ngurran nukunu-yu. I nankuneme-ka nubinayepup-da-matha-neme nuru nukunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bere nhini thangunu peneme nhini pubamkangkarduneme-ka nukunu da matha Jesus numidharrnu pirridha-yu. Bere peneme nhini-ka mere warda puddananarruyiththaneme ngarra kardu-yu da mange nhini ngarra pubamkangkarduneme pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bere da thipinhire nhini-ka Jesus i kardu pulangay nukunu kardu perrkenkuneme-ya puddamkathutneme ngarra da palyirr kangkarl thangunu kathu. I kardu wurnangat pubangammardabi ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Mu kardu ngarra wurnangat nhini-ka kardu nugarn pirrimnakay ngarra Jesus, “Ya pule,” mamna. “Wakal ngay kanhi-ka ku ngepan wiye kanthin wurran. Wakal ngay-ka numi kanhi da matha, nhini-ka thurru kanhi dangkardunu mani. Ku ngepan wiye nhini-ka ku bere matha wangu wurranngawurt i nhini-ka kanampapa warda i parnte kanam i nhini-ka mantharryirr warda kanam nanhthi thurrulk ngarra thathpi. Mange-ka nhini-wa mamna wurran-yu i nhini-ka kardu mampinhimak warda i da ngamere da matha kanampirr wurran nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mu ngay-ka ngampunkudharrpuneme ngarra pulangay nhinhi ku ngepan wiye nhini punnimakudha-mana-neme, mu wurda puddamnabay-da-matha-neme.” Kardu nhini kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mu Jesus kathu-ka mampirra ngarra kardu wurnangat-yu, “Nanki-ka murrinh-ka nubimngayewup numpan murrinh ngarra ngay-yu mu murrinh-ka mere thathpirr numangabath nuru. Da pirdithme da matha murrinh ngurdininanthethiththa ngardi, mu murrinh-ka mere da ngatha numangabath nuru murrinh ngarra thathpi ngay-yu i mange mere yuthpan da ngatha nuru. Mu ngarra-wa diki murrinh ngay ngurdinanthethithnu ngani-yu i murrinh numangabathnu thathpirr-yu? Nga. Kardu kathu nangabert kardu kigay pana,” Jesus kathu-yu mamna ngarra yile nukunu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bere ngarra kardu nhini-re mebertidha wurrini ngarra Jesus-nu-ka ku ngepan wiye-ka mangarnta kardu kigay nhini-yu i wurdarnturt bammat ngarra putek i parnte warda. Bere Jesus-ka nungammaku ku ngepan wiye nhini-yu i kardu kigay-ka wurdannangkarl warda ngarra yile nukunu wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bere kardu wurnangat-ka pumemnamardat warda ngarra Jesus-yu i nanhthi lurruth nukunu ngarra Yile nukunu thangunu kathu-yu. Bere ngarra kardu nhini-re murrinh da ngatha puddanayiththa punni mange patha nhini ngarra Jesus medha wurrini-ka, Jesus-ka wurdampirrumardarduyneme ngarra pulangay nukunu i mampirruneme, ");
INSERT INTO mwf2018_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nga peneme. Nubingayepupneme kathu i murrinh thathpirr numangabathnuneme murrinh kanhi. Ngay kardu darrikardu nanki thathpirr-ka pumangirtanu i pumangibertinu puru ngarra kardu pule ngala-ngala-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mu peneme-ka mere pumemartadhaneme murrinh nhini-yu, nhini Yile neki-ka mere da ngatha buyinkuwerdidhaneme ngarra mukmuk peneme-yu. I peneme-ka mere ngarra ngadha perradharrpudhaneme murrinh wurdirruriyiththaneme-yu nhini-ka perremkamanham-weyida-neme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bere pulangay nukunu Jesus-ka murrinh peneme da matha puddanadharlurldhaneme punne kardu nangkal nimin-nu peneme ngatha-yu kardu pule ngala parethbathnu ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mu nukunu Jesus-ka the menkumabaththaneme pirri i nhini-ka manganmert warda kardu mamay i bamnungurrupak warda ngarra nukunu i panthamayirrikat. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","I mampirruneme ngarra pulangay nukunu, “Nga. Kardu nangkal ngatha mangirdarrilenu kardu mamay nginipunh kanhi mani karrim-ka nhini-ka ngay deyida wanku mangirdarrilenu nhini-yu. I ngana deyida kardu nangkal ngatha mangirdarrilenu ngay-nu-ka nhini nukunu-ka mardarrile-deyida-nu thathpirr ngarra Yile ngay-yu nukunu pana ngarra wurdanngithuk-yu. I nga,” mampirruneme. “Kardu nangkal ngatha kunungingki buynupaknu nhini nukunu-ka kardu ngala thathpirr pinu i pinpewalnu ngarra kardu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bere nukunu John kathu-ka mamna ngarra Jesus, “Pule, ngankuneme-ka ngubamkangkarduneme kardu nugarn numi kardinmawuthpuththa ku ngepan wiye ngarra kardu thangunu ngarra murrinh nhinhi menhirdarrinedha kardi. Mu ngankuneme-ka ngubuymadhaptha-mana-wa-neme nhini nukunu-ka kardu mere nekineme-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mu Jesus kathu-ka mampirruneme, “Awu, mere mani nubumadhap-nukun-neme. Kardu nangkal ngatha ngarra nekineme mere manhengkaneme kurru-ka nhini-ka kardu nekineme-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bere da-ka manta warda pirrinadha ngarra Yile neki kathu pamardawithnu Jesus da kangkarl-nu warda wangu-yu. I nhini Jesus-ka da mayern numi da matha warda pirrinadha da nan-nu Jerusalem. I nungardurr warda da nhini-nu-yu bere ngatha daniwirntedha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I bere nukunu-ka kardu ngamere wurdanpunkthukneme kumparra warra da-nu pumanawathawathanemenu. Bere kardu ngamere nhini-ka punnadhaneme i parramkaruyneme da town ngarra kardu ngamengka da nan pardipuptha, da nan-ya Samaria. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bere Jesus-ka tiduk kathu nadha dini i pangarntuy da nhini da. Mu kardu da ngarra Samaria nhini-ka parramkamit-wa da-nu-yu. Mu nhini Jesus-ka bere ngatha wangu nadha dini da Jerusalem-nu warda wangu. Kardu pana ngarra da Samaria pardidha-ka mere marda pumenarttha puyi kardu pangu da ngarra Jerusalem thangunu kathu. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bere ngarra piguna-re James i John pubamkangkardu Jesus parramkamit thangunu-ka nhini-ka pumamna warda ngarra Jesus, “Pule, nganku-ka Yile neki ngadharrpunu purduthuknu thungku bantikerdek da matha-nu kardu kanhi-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mu Jesus-ka wurdampirrurduy pirrim ngarra piguna wangu, i murrinh mampirru, “Awu, mange nhini-ka pirda-wa. Mu kardu-nu thathpirr marda numanartnu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bere nhini thangunu-ka punnungamkardurr-warda-neme da town numi-nu warda wangu purnedhaneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bere ngarra purnelilidhaneme-ka pubemkamardabineme kardu nugarn numi. I nukunu kathu-ka mamna ngarra Jesus-yu, “Ya. Ngay-ka bere matha wangu nganhiriwaknu ngani.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mu Jesus kathu-ka mamna, “Da-ka tetemanthay-wa dardurtnu thurru ngarra ngay thangiriwaknu thani-yu. Nga, ku were pulangarr pumpannupup-ka ngarra da weyi-wa, i ku murrirrbe-ka ngarra da ku dirri pumpannupup. Mu ngay mani, kardu darrikardu nanki thathpirr-ka kardu manangka da da matha mere ngarra ngadha da-yu nganirrit i nganipup.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bere nhini thangunu Jesus kathu-ka mamna ngarra kardu nugarn numi deyida, “Nga. Nhinhi-ka thangiriwaknu thani.” Mu kardu nhini kathu-ka mamna ngarra Jesus, “Ya pule, kuguk da ngatha. Ngay-ka nganinu ngadha ngarra Yile ngay i ngarra pupup da-nu mana i babirrnu warda. I nhini thangunu ngay-ka nganhiriwaknu warda ngani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mu Jesus kathu-ka mamna, “Kardu pana ngarra mere da ngatha the kumangibath kuru-ka kardu nhini-wa pangu pubanmirrbirrnu puru-yu kardu ngarra pumpanpuwup-yu. Mu nhinhi-ka thurrunu kathu i thangiriwaknu thani ngarra ngay marra da matha i murrinh thanthelerrnu thurru Yile neki da matha ku Pule ngala pirranu i pirranpe purru kardu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bere nhini thangunu-ka kardu nugarn numi deyida mamna ngarra Jesus, “Pule, ngay-ka nganhiriwaknu ngani, mu marra-re warra ngadha ngay-ka murrinh ngurdirrayithnu ngarra kardu darrikardu ngay. I ‘yu’ ngatha pumanganu-ka nhini ngay-ka nganhiriwaknu warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mu Jesus kathu-ka mamna, “Nhinhi ngatha thangiriwaknu thani ngarra ngay-ka, nhini-ka mere thangku nebirl nukun, mu ngarra ngay da matha warda thangiriwaknu thurru. Mu kardu nangkal ngatha nenabibirl ngarra thangku nanhthi ngatha i ngay mere kumparra bungipak, nhini nukunu-ka mere ngarra Yile neki wurlk kurruna, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bere nhini thangunu Pule Jesus-ka kardu ngamere deyida mampunkarart, kardu-ka 72-wa. I panpunperr warda kardu purdunthukthuknu purru perrkenku perrkenku da pana ngangka-re kumparra warra ngarra da mayern nukunu pununu pi. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bere panpunperr i mampirra, “Nga. Kardu wurnangat terert nimin-ya parnam da ngarra putek ngala kanhi. Mu nanki-ka kardu mere thathpirr terert nhini-yu i mere ngarra nanthelerr nukun murrinh ngarra Yile neki nukun kardu ngarra wurnangat kanhi warda ngatha. Kardu mani bangkardu mi thungku dim-ka mere ngarra murartal mi terert warda ngatha mange nukunu ngatha-yu, mu nhini-ka kardu terert da matha kirrarrakay kumamanpi. I nanki deyida mani nadharrpunu Yile neki kardu-nu pumananmanpinu murrinh thathpi ngarra nukunu panthelerrnu puru ngarra kardu wurnangat kanhi warda ngatha parnam ngarra da putek ngala kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“I nga mampa, nurunu warda. I kardu wurnangat ngamere pana mere marda kumangert kuru ngay-yu, nhini ngay-ka ngurdunanthuknu nginipunh ku thip mani nanki-yu kardu pana-nu nginipunh ku were pulangarr murlakpun mani parninarranu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","I nga. Ngarra nururdurrnu-re-ka mere nukun numabath nuru ku mani-yu i nanhthi bag. I me put-ka nanhthi pana da matha ngarra nubammerdi nibim numabathnu nuru-yu. I parnturtpan da matha nurunu nhini-yu i mere nuddurrayith nukun nuru kardu-yu ngarra mayern nurulilinu-re-yu, mu nubankatnu da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“I ngarra da town naruynemenu i ngarra thelput-te narnerdinemenu-ka, marra-re-ka kanhi-wa murrinh numarranu-yu kardu ngarra thelput parningkadhuknu-yu, ‘Ya. Yile neki-ka pirrananpenu pani.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","I kardu pathanpun ngatha ngarra da thelput nhini parningkadhuknu-ka, nhini Yile neki-ka pirranpenu thathpirr pani kardu nhini-nu-yu. Mu kardu nhini ngatha mere le puyunarranu marda ngarra pigunu ngatha-ka, nhini-ka murrinh nuddunmangkarlnu murrinh nhini ngarra numampirra-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","I ngarra thelput kardu pathanpun da matha narnepupnemenu i mere nukun nunnerdurrneme ngarra da thelput ngamere-yu. I mi dhepdhep i kura ngarra panarramutnemenu-ka nullath-da-nu-matha-neme nhini-yu. Mange-ka patha-wa nhini-yu kardu mi dhepdhep panarramutnemenu-yu, nhini-ka wurlk ngarra Yile neki weyida nuyemananu nuru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“I ngarra da town-te naruynemenu ngarra kardu le puyunarranu, nhini-ka nullath-da-matha-neme-nu mi dhepdhep ngarra panarramutnemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I kardu matharr-wunngini pangu numankuwathanemenu nuru patha i murrinh kanhi-wa numarranemenu-ya, ‘Yile neki-ka manta warda Pule ngala pinarranu thathpirr, nhini-ka da mange ngarra nukunu da matha nariwaknu nuru.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Mu ngarra da town narurtuynemenu nuru-ka i kardu ngatha mere le puyunarranu marda ngarra pigunu ngatha-ka, nhini-ka ngarra mayern pilampirdarri nanuneme i murrinh-ka kanhi-wa numarrunemenu-yu ngarra kardu, ");
INSERT INTO mwf2018_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nga. Ngankuneme-ka murrinh mana-wa nguddinarruyiththaneme murrinh thathpi ngarra Yile neki nukunu wangu, mu nanki-ka murrinh mere da matha nubinayepuptha. Nhini ngankuneme-ka me putek kanhi ngarra me put pepe ngankuneme-ka nguyunungkumerurturlnemenu i da kanhi-ka ngunnardurr-warda-nemenu ngankuneme-yu.’ I bere kardu nhini pubanankumangkardunemenu i the warda pumabathnu Yile neki-ka mere warda pirranpenu pani nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“I nga, murrinh kanhi manarranu,” Jesus kathu-yu mampirra. “Kardu murntak pana nganaka ngarra da nan Sodom pardidha-ka da wiye thathpirr pumedha pardi. I da nakurl-te-nu kardu nhini-ka piramardatnu kumparra warra ngarra Yile ngay, i nhini-ka da wiye thathpirr pirrarranu kardu nhini-nu-yu. Mu kardu pana nimin ngarra mere le puyunarrunemenu-ya ngarra da town nhini naruynemenu-ya, nhini-ka da-ka wiye ngala thathpirr pirrarranu kardu nhini-nu-yu da nakurl-te-yu ngarra piramardatnu kumparra warra ngarra Yile neki wangu-yu.” Nhini-wa Jesus murrinh mampirra-yu kardu ngarra 72 nhini-yu. Bere nhini thangunu kardu 72 nhini-ka da pana ngangka-re punniwattha i kardu murrinh parraninthelerrdha purni murrinh ngarra Yile neki nukunu, i kardu matharr-wunngini pumenpathadha purni patha da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bere Kangkarlmawu-ka murrinh warda mampirra ngarra kardu pangu da nan pardipuptha-yu da Korazin i da Bethsaida. Murrinh-ka kanhi-wa mampirra-yu, “Da-ka wiye thathpirr pirranarranu nanki-nu-yu da ngarra Korazin i Bethsaida narnapup-yu. Mange ngala ngala menarradha ngurrini nanki-nu-yu, mu nanki-ka mere narniparttha da mange wiye nhini-yu. Mu mange ngala ngala nhini da ngatha merradha ngatha kardu pangu-nu ngarra da Tyre i Sidon parnapup-ka, kardu nhini-ka da mange wiye parniparttha-wa da murntak warra i denmardathintha warda thathpirr da mange wiye nhini ngarra pumebaththa purni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“I nga,” Jesus kathu-yu mampirra. “Kardu nhini-ka ngarra da Tyre i Sidon parnapup-ka da nakurl-te piramardatnu kumparra warra ngarra Yile neki-yu, i da-ka wiye pirrarranu kardu nhini-nu da nhini-nu-re-yu. Mu da-ka wiye ngala thathpirr pirranarranu nanki-nu-yu ngarra niramardatnu kumparra warra ngarra Yile neki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","I nanki-nu ngarra da Capernaum narnapup ngarra kardu numemnungala numpan-ka Yile neki-ka pananpinhithputhnu da ngarra thungku ngala wangu-yu. Ngay-ka mange ngala ngala deyida menarradha ngurrini nanki-nu-yu, mu nanki-ka mere narniparttha da mange wiye ngarra numammath numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“I nga,” Jesus-yu mampirra. “Kardu nangkal ngatha binarrayepupnu i murrinh manarrabathnu purru-ka kardu nhini deyida bingayepupnu ngay-yu i murrinh mangabathnu purru-yu. Mu kardu nangkal ngatha murrinh panankamitnu nhini-ka ngay deyida wanku pangingkamitnu nhini-yu i Yile ngay ngarra wurdanngithuk ngay-ka pangkatmit-deyida-nu pi nhini-yu. Mampa-ya nuru warda,” Jesus kathu-yu mampirra i wurdanpunthuk warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bere nhini thangunu-ka kardu 72 nhini-ka puddalath warda ngarra Jesus i le patha thathpirr warda punnidha. I murrinh pumenadha pardi ngarra Jesus, “Pule, ku ngepan wiye ngarra kardu panthingkadhuktha pardi-ka ku ngiranmapuththa warda ngardi i pardinpirrdha warda purni nhini-yu ngarra murrinh nhinhi ngumenhnhirdarrine ngurni.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mu Jesus kathu-ka mampirra, “Yu, ngay-ka bamkardu ku karrath-yu pirtpirt da matha dimmat i mentharday da kangkarl kathu nginipunh thu malarntath mani wurranmamath. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“I nga,” Jesus kathu-yu mampirra. “Ngay-ka nanhthi lurruth ngala ngarra ngay wardarra ngamnarramut, i nhini-ka bere ngatha nunnuthurrnu i nunnuwinhikatnu ngarra ku pangkuy murlak i ku dalmarnti-yu, i nhini-ka mere ngarra bananlele nukun ngarra wurlk Yile neki-re numananu nuru-yu. I ku karrath-ka mere ngarra mananmert nanki-yu, nhini-ka ngay wangu-wa nanhthi lurruth ngala thathpirr ngempewal ngarra nanhthi lurruth ngala nukunu ku karrath nhini-yu. I nanhthi lurruth ngala ngay thangunu-ka berengunh ngamnarramut wardarra. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Mu nga,” Jesus kathu-yu mampirra. “Nanki le patha nardidha-ka nhini-ka ku ngepan wiye ngarra kardu panthidha purni-ka niranmapuththa nardi-ya murrinh ngarra thathpi nanki thangunu kathu-yu. Mu le thathpirr warda nurunu nhini nanki-ka kardu ngarra Yile ngay nukunu warda nhini-yu, i murrinh ngarra nanki-ka damnantilil wardarra nanhthi ngarra buk nukunu, i nhini nanki-ka bere matha wangu narninu ngarra da nukunu wangu-yu da kangkarl-ya,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bere da nhini-re ngarra kardu nhini puddamnalath ngarra Jesus-ka, nukunu-ka le thathpirr dinidha ngarra Ngepan Yile nukunu thangunu-yu. I murrinh warda mamna ngarra Yile nukunu, “Yile, nhinhi da matha Pule ngala thathpirr thim ngarra kangkarl i da putek kanhi-yu. I ngay-ka ngamnhiriparl ngem nhini weyida da mange ngarra nhinhi thampunkarr wardarra kardu pana ngatha yida, mu mere thenkarrdha da mange ngarra nhinhi kardu ngarra murrinh piyemam pumpan the pumammath pumpan da terert. Yu Yile, nhini da matha mange marda nanganart thim,” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bere nhini thangunu Jesus kathu-ka mampirra ngarra kardu, “Nga kardu. Yile ngay-ka murrinh wurnangat warda ngatha banngiwerdi ngarra mukmuk ngay i nanhthi lurruth ngala thathpirr damngamut. I kardu-ka mere thathpirr the numangibath ngay-yu, mu Yile ngay da matha the thathpirr kanthinngi. I ngana deyida mere nangkal the thathpirr mabath Yile ngay-yu, mu ngay da matha wakal ngarra nukunu-ya the nganthin nukunu pangu-yu. I ngay-ka kardu ngamere deyida ngurdunthethithnu ngarra Yile ngay-nu-yu kardu ngarra ngay mampunkarart-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bere Jesus-ka wurdampirrumardarduyneme pirrim ngarra kardu pulangay nukunu i mampirruneme peneme da matha, “Nhini-ka patha-wa thathpirr nubamngingkarduneme ngay-yu Christ-ya wakal nukunu Pule ngala Yile neki wurdanngithuk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nankuneme-ka nubamngingkarduneme ngay-yu i nubimngayepupneme murrinh thathpi ngarra ngay-yu. I kardu murntak nhini ku prophet-ya i kardu pule ngala ngala-ya nginipunh nhini deyida mani marda pumerttha punni. Mu kardu-ka mere pubengingkardudha ngay-yu i mere pubinangayepuptha ngay-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bere kardu nugarn ngarra murrinh law Jews pigunu wurdininthethiththa wurrini-ka dempirnturt warda i murrinh wurdanthap ngarra Jesus-yu. I mamna, “Ya Pule. Ngarra-wa mange ngamanu ngurru kanhi-yu kardu ngay birnu-nu bere matha wangu nganinu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bere Jesus kathu-ka mamna, “Nhinhi-ka thurdanpunthethith thurran murrinh law Moses nukunu nawa? I ngarra-re-wa murrinh law nhini mam yibim-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“Kanhi-wa murrinh law-yu,” nukunu kardu nhini kathu-yu mamna ngarra Jesus-yu. “Marda thathpirr pumartnu purru Yile neki, wunku marda-ya, i wunku ngepan-ya i wunku nginipunh-ya i wunku mukmuk wanku. I nginipunh neki deyida mani marda thumemnurt thurran i thirrimnupe thurran nhini-ka marda pumanartnu purru i pirranpe-deyida-nu purru kardu ngamere-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Yu, nhini da,” Jesus kathu-yu mamna. “Mange nhini thamanu thurru-ka i nhini-ka bere matha wangu birnu thaninu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mu kardu nhini kathu-ka da the mabathnu purru thangku kardu nimin marda manartnu purru-yu. I nhini-ka murrinh deyida mamna ngarra Jesus, “Ya. Kardu ngamere pana ngarra marda manartnu ngurru-ka kardu-ka wunku ngamengka kama i kardu ngarra darrikardu ngay kama marda manartnu ngurru-yu?” Dantharrpu kardu nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bere Jesus-ka murrinh warda wurdamnayith i mamna, “Nga. Kardu nugarn nungardurr da Jerusalem thangunu kathu i nadha dini wurdanthut da ngarra nan-nu warda wangu Jericho. Bere ngarra nukunu-re nadha dini-ka kardu darrarart-wunka kathu parnamnamanthip i pumangarnta i nanhthi purrkpurrk nukunu pardimatkuttha. I punnibattha pardi i pumpantalal da mana. I parnampart pangu da yungurrkurrktha. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Bere nhini thangunu-ka ku yilarn ngarra da church ngala pangu Jerusalem thangunu kathu-ka wurrinidha wurdanthut ngarra mayern nhini da ngatha. Mu ngarra nukunu-re bamkardu kardu nhini yungurrkurrktha-ka nhini-ka panthikat pangu-re nadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","I nhini thangunu-ka kardu numi deyida ngarra da church ngala thangunu wurlk medha kardi kardu Levite-ya wurrinidha wurdanthut ngarra mayern nhini da ngatha. I nukunu-ka bamkardu deyida kardu nhini yungurrkurrktha-yu i panthikat deyida pangu-re nadha dini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","I nhini thangunu-ka kardu numi deyida wurrinidha ngarra mayern nhini da ngatha wunku ku tangki wanku. Nukunu kardu nhini-ka kardu ngamengka da nan-wa Samaria thangunu kathu. I nukunu deyida bamkardu kardu nhini yungurrkurrktha-yu i damnamardathin warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I bere wurrininadha pangu i mamparlak nanhthi oil i kura wine ngarra nanhthi lirrwi kumulung nanhthi punadhapnu yidingurr. I nanhthi strapping warda bannapak. I nhini thangunu-ka bannarripak ngarra ku tangki nukunu i mebertidha wurrini pangu warda wangu ngarra thelput ngala ngarra kardu da parnapup-ya. I kanthinnurdi i pangu da dirrapedha kardi. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Bere da thipinhire nhini kardu nhini-ka ku mani damnamut ngarra kardu pule nhini ngarra da thelput ngala nhini meyittha dini. I murrinh warda mamna, ‘Nga. Ku mani kanhi nabathnu i kardu matharr-ngini kanhi thirrangapenu thani. Mu ngay-ka ngunungam warda ngem. Mu ku mani kanhi ngatha kunungingki-ka nhini-ka nakurl deyida ku ngampamutnu ngarra ngurdiwurl-deyida-nu kathu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nhini-wa murrinh niyithniyith Jesus wurdamnayith-yu ngarra kardu pana ngarra murrinh law wurdininthethiththa wurrini-yu. I murrinh warda mamna, “Nga. Kardu perrkenkuneme nawa purnelilidhaneme ngarra mayern nhini-yu i pubamkangkarduneme kardu nhini ngarra thu pumpanmat-yu. Mu kardu ngarra nimin kardu patha thathpirr wurrininadha-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","I kardu nhini kathu-ka mamna ngarra Jesus, “Kardu pana nimin darrikardu marda-yu ngarra damnamardathin i mammanpi, nukunu nhini darrikardu wurrininadha i marda manganart-yu.” I Jesus kathu-ka mamna deyida, “Yu nhini da. Mu nga, nhinhi-ka mange-ka mangini nhini deyida mani thamanu thurru-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Bere Jesus i pulangay nukunu-ka pumpankardurr-warda-neme da nhini thangunu i da numi deyida-nu warda wangu punnadhaneme. Bere parramkaruyneme da town kunungingki i punnadhaneme da ngarra thelput piguna Martha i Mary. Bere nigunu Martha-ka nungammardale Jesus-yu. I mamna, “Kagu, thanirdinu mi dhepdhep-nu.” Bere Jesus-ka kanardi i kanawup. Bere nigunu Martha-ka mi warda mewathawathadha kardi, mu nigunu Mary-ka wurrininadha ngarra Jesus i kanawup pepe manta ngangka da ngarra me nukunu, i binanayepuptha dini murrinh ngarra wurdiniyiththa kathu dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mu bere nigunu Martha-ka mi dhepdhep terert merruwathawathadhaneme kardi-yu mange nigunu-yu, i kardu-ka mammardaraki-wa Mary-nu-yu mere memanpidha-yu. I nhini nigunu-ka wurrininadha ngarra Jesus i mamna, “Pule, munak ngay kanhi-ka kanamngipart mange ngay da matha mi manarruwathawathanemenu ngani-yu. Mu nhinhi-ka murrinh nange-wa nigunu mangimanpinu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mu Jesus kathu-ka mamnge, “Martha, Martha. Mere thewerr nukun. Mu nga, mukmuk terert-ka mere nabath thurru. ");
INSERT INTO mwf2018_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mu da mange numi da matha thama thurru-yu, mangini Mary kanhi mani mam dim-ya. Nigunu-ka murrinh thathpi ngarra ngay da matha bimngayepup dim, i nhini-ka mere ngarra nukun ngurduthuk ngay-yu.” Jesus kathu-yu mamnge. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bere nhini thangunu Jesus i pulangay nukunu-ka pumpankardurr-warda-neme i da numi-nu warda wangu punnedhaneme. I Jesus-ka dininangerrentha ngarra Yile nukunu wangu. Bere ngarra nukunu-re murrinh damnarikerdek ngarra Yile nukunu-ka kardu numi pulangay nukunu kathu-ka mamna, “Pule, thurdungankuyethithnuneme da mange pana ngarra Yile neki nukunu wangu ngenangerrennuneme nginipunh John the Baptist mani wurdanpunkuyethithneme ngarra pulangay nukunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bere Jesus kathu-ka mampirruneme, “Kanhi mani-wa murrinh nenangerrennemenu ngarra Yile neki-yu. Yile, nhinhi da matha ngala thathpirr-yu i patha da matha. I nhinhi da matha nganhiriparlnu ngarni-yu. I nganki nganhidharrpunu thingarranu kardu Pule ngala thathpirr ngarra kardu wurnangat warda ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","I mi dhepdhep thangarramutmutnu thurru. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","I thirranganmaputhnu da mange wiye ngumebaththa ngardi, nhini nganki-ka nguyenthekum warda da mange wiye ngarra kardu ngamere thangunu kathu pumengarradha purni-yu. I nanganmanpinu murrinh ngarra nhinhi da matha ngumampabathnu ngarni ngarra ku karrath-te mangantullulnu-yu. I nanganyitnu thurru nganki-yu, nhini ku karrath-ka mere ngarra nukun manganbert. Murrinh-ka nginipunh nhini mani-wa nuddinayithnu nuru ngarra Yile neki-nu wangu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","“I nga, murrinh numi-yu,” nukunu kathu-yu mampirruneme. “Kardu numi ngatha ngarra nankuneme pununanu kama pi ngarra darrikardu nukunu ngarra da kalkkalk i murrinh mananu, ‘Ya, mi dhepdhep kathu thangamut. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kardu pulangay ngay pangamngaruy marra kanhi da ngathparr thangunu kathu i ngay mi-ka mami-wa nukunu-nu-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","I kardu darrikardu nhinhi-ka pimpakay ngarra inside thangunu kathu, ‘Nga, mere nangimaputh nukun. Ngay-ka nganthap wardarra nanhthi tuwa-yu i ngay i wakal ngay-ka ngarra da pit ngarrimkangime. I ngay-ka mere ngarra ngewirnturt nukun i mi dhepdhep mere ngampamut nukun.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bere kardu darrikardu nukunu nhini-ka mere ngarra kewirnturt i kanamut mi dhepdhep. Mu bere ngatha nukunu nhini padharrpu kama pani, nhini nukunu-ka kewirnturt i mi kanamut mi pana ngarra nukunu dantharrpu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Nga,” Jesus kathu-yu mampirruneme. “Mange nginipunh murrinh nhini mani-ya nankuneme-ka bere ngatha wangu nadharrpununeme narne Yile ngay nanhthi pana-nu narnamyeyma. I ngana deyida nanhthi nhini-nu nirawinhadhathnemenu nuru, i nhini Yile ngay-ka nanhthi-ka panarrungkardanuneme warda nhini-yu. Kardu bere matha wangu nadharrpununeme nuru Yile neki, i nhini nukunu-ka nanhthi warda kanarrumutnu warda ngarra nankuneme-yu nanhthi pana ngarra da narramkadharrpuneme-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“I nga nankuneme yile yile,” Jesus-yu mampirra. “Wakal nankuneme ngatha kanankudharrpuneme ku ngurlmirl-nu, nankuneme-ka mere narramutneme-mani-wa ku pangkuy-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","I ku tumtum-nu ngatha kanankudharrpuneme-ka nankuneme-ka mere ngarra kama mani narrumutneme ku nan-yu nawa dalmarnti, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kardu nanki-ka mere patha thathpirr nuru mu nanki-ka the-wa numammath mi dhepdhep patha da matha narrampirramut-yu ngarra wakal nanki-yu. Mu Yile neki-ka patha thathpirr-wa nhini-yu, nhini nukunu-ka da kangkarl kathu nanhthi patha thathpirr damnarramutmut wurran nhini-yu. I nukunu ngatha nadharrpu ngarra Ngepan nukunu-nu paninannginirdinu-ka i nhini-ka panarramutnu warda nhini-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bere nhini thangunu Jesus-ka nungammaku ku ngepan wiye ngarra kardu nugarn thangunu kathu. Ku ngepan wiye nhini-ka murrinh bunidhapeptha wurrini kardu nhini-yu. Mu ngarra nukunu-re Jesus nungammaku ku nhini-ka, kardu nugarn nhini-ka murrinh deyida kardingerrentha. I kardu wurnangat-ka pumemnamardat warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mu kardu ngamere murrinh pumerradha punni, “Awu, nukunu Jesus-ka ku karrath kathu damnamut nanhthi lurruth ngala pana-yu i da-ka nhini weyida pirrimpunmaputh wurran ku ngepan wiye ngarra kardu thangunu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","I kardu ngamere-ka pubuythaptha mana-wa Jesus-yu i parrantharrpu da mange ngala-nu pamanu wunku lurruth ngala ngarra pule ngala Yile neki thangunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mu Jesus-ka bangampunmarde i murrinh warda mampirra, “Nga kardu. Kardu darrikardu ngatha thu kuyunuthuk kuru-ka nhini-ka kardu kuyunurikerdek-wa nhini-yu. I kardu darrikardu manta ngatha kuyuthuk kuru-ka nhini-ka kardu kuyunurikerdek deyida nhini-yu. I kardu-ka mere warda lurruth parnenungime, i mere warda mitmit parnenungime nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","I mangini nhini mani ku karrath-ka mere kirranmaputh kurru ku ngepan wiye wiye nukunu ngarra kardu thangunu kathu-yu, wurda da matha. Mu nukunu nhini i ku ngepan wiye wiye ngarra nukunu-ka marda ngala da matha parnamkaneme-yu. Mu ku karrath ngatha ku ngepan wiye wiye kirranmaputh kurru-ka nhini peneme-ka mere warda mitmit karnenemenu, i mere warda lurruth ngala karne-nukun-neme, wurda da matha warda. I peneme-ka kuyunungkurikerdek-da-matha-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Nankuneme numamkaneme-ka ku karrath kathu nanhthi lurruth ngala ngarra nukunu damngamutmut wurran ngarra ngay ku ngepan wiye wiye-nu ngarrimpunmaputh ngurran-yu. Mu nga, murrinh kanhi nganankudharrpunemenu, kardu nangkal nimin nanhthi lurruth ngala dampirramutmut wurran kardu ngarra nankuneme ku ngepan wiye wiye-nu pibimpunmaputh pumpan-yu? Nganaka, nangkal nhini-yu? Yile neki nawa nanhthi lurruth ngala dampirramutmut wurran-yu? Mu nhini nankuneme-ka murrinh narrampirrayirrart ngarra ngay-nu-yu numamnganeme ku karrath kathu nanhthi lurruth ngala damngamutmut wurran-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mu nga. Ngay-ka ngarrimpunmaputh ngurran ku ngepan wiye wiye ngarra kardu thangunu kathu, nhini ngay nganthin ngurran-ka ku ngepan lurruth ngala ngarra Yile neki thangunu kathu-wa. Nanhthi lurruth ngarra ku karrath nukunu-ka wurda-wa nhini-yu. I nhini-ka the-wa numabathnemenu Yile neki kardu Pule ngala wardarra dimpirra kardu ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“I nga.” Jesus kathu-yu mampirra. “Kanhi-wa murrinh numi-yu. Kardu lurruth ngala wunku thamul wanku-ka dirranganpe kanam thelput nukunu i nanhthi purrkpurrk nukunu-yu. I mere nangkal ngadha mangkardap nanhthi purrkpurrk nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mu kardu lurruth ngala thathpirr ngatha meninthatha kardu nhini-yu i kardu nhini-re kathu kawarl, nhini-ka thamul nukunu ngarra wurdiniyemittha wurrini-ka mamakutnu warda i nanhthi purrkpurrk nukunu wanku mangkardarrarartnu i marrayerryerrnu warda ngarra kardu darrikardu nukunu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“I nga numi-yu. Kardu nangkal ngatha mere kangiriwak kurru ngarra ngay, nhini nukunu-ka mere marda thathpirr mangert kurru. I ngana deyida kardu ngatha mere kunperr kurru kardu ngarra ngay-nu, kardu nhini-ka bannganthalang warda-wa nhini-yu ngarra ngay wangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bere Jesus-ka murrinh deyida mampirra, “Nga. Ngarra ku ngepan wiye thangunu kardu kanampart-ka, nhini-ka nungawat dim da ngarra demtumtum ngarra kura makura i da-nu dirranganpinhadhath tharra. Mu mere ngatha bardurt da-yu nhini nukunu-ka murrinh warda memnu mange nukunu, ‘Aa yu. Ngay-ka ngurdinawurlnu kardu pangu deyida ngarra nganampart i nganinginirdi-deyida-nu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bere nhini thangunu-ka wurdamnawurl pangu deyida i bangarnurt kardu nhini da ngatha-ka watmam warda i patha da matha kanam kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bere ku ngepan wiye nhini-ka mampirrukayneme ku 7 deyida kathu i ku-ka ku wiyenpun thathpirr nhini-yu. I ku-ka parnamkanginirdi-warda-neme kardu nhini-yu i da warda parnamkapupneme. I nukunu kardu nhini-ka kardu wiye thathpirr warda wurran kardu nhini-yu, mu da marra-re-ka kardu nhini-ka wiye kunungingki da matha wurrinidha-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bere ngarra nukunu-re Jesus diningerren-da-dha-ngatha-ka kardu palngun numi dimnakay ngarra kardu wurnangat thangunu kathu. I mamna, “Nga. Kale nhinhi-ka le-wa kani nginipunh pana-yu wakal nugarn thirrim pana mani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mu Jesus kathu-ka mamnge, “Yu, mu kardu nangkal ngatha binayepup murrinh ngarra Yile ngay i murrinh manabath-ka nukunu nhini-ka le-wa thathpirr kurru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bere kardu wurnangat nimin-ya puyenawerrdha punni ngarra Kangkarlmawu. I murrinh warda mampirra, “Kardu wurnangat warda ngatha kardu wiyenpun i mere thathpirr pumanabath puru murrinh ngarra thathpi Pule ngala Yile neki-yu. Kardu-ka parramngidharrpu da mange ngala-nu ngamanu wunku lurruth Pule ngala Yile neki wanku. Da murntak warra nganaka Yile neki kathu da mange ngala mamna ngarra kardu prophet murntak nhini-nu-ya Jonah. I da mange ngala mangini murntak nhini da matha pubangkardu-deyida-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yu, kardu nhini-wa Pule ngala Yile neki manthibirnu-yu ngarra ku ngurlmirl ngala thangunu-yu. I nhini kardu pangu Nineveh-ka the-wa pumebaththa punni Pule ngala Yile neki-ka ngala-wa thathpirr. I mange nginipunh nhini deyida mani ngay, kardu ngarra da kangkarl kathu ngurdamnarrathut-ka nhini Yile neki deyida mangiyibirnu-deyida-nu, i kardu pubamngingkardunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","I kardu muthingka pana nganaka da nan thangunu kathu Sheba. Da murntak warra nigunu nadha dini da ngathparr nhini thangunu kathu i murrinh-nu binanayewuptha dini murrinh ngarra nukunu nan-ya King Solomon, kardu nukunu nhini-ya ngarra murrinh mukmuk ngala kanthidha wurrini. I da nakurl-te nigunu wanku kumparra warra pirramardatnu ngarra Yile neki i kanhi-wa murrinh manarranu da nhini-nu-re-yu, ‘Nanki-ka mere ngadha narniparttha da mange wiye ngarra numebaththa nardi, nhini nanki-ka ngarra da thungku ngala da matha nurunu-yu.’ Nigunu kathu-yu manarranu. Yu, nukunu ngalantharr nhini King Solomon-ka kardu ngala-wa, mu kardu nugarn numi kanhi da karrim kardu ngala thathpirr dimpewal ngarra nukunu nhini King Solomon-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“I nga. Da nakurl-te ngarra kardu wurnangat warda ngatha niramardatnu kumparra warra ngarra Yile neki, kardu nhini deyida wanku ngarra da nan thangunu-ya Nineveh pardipuptha-ka ngarra Yile neki deyida kumparra warra piramardatnu. Kardu nhini-ka murrinh pubimnayepup i murrinh pumamnabath ngarra ku prophet nhini-ya Jonah murrinh merradha wurrini. I nhini kardu-ka daninmardathintha warda kardi da mange wiye thangunu pumebaththa pardi i parnampart warda nhini-yu. Mu da nakurl-nu-re-ka kardu nhini kathu-ka murrinh pumanarranu, ‘Nanki-ka mere ngadha narniparttha da mange wiye ngarra numebaththa nurni nhini Yile neki-ka ngarra da thungku ngala warda wangu purdunanthuknu.’ I nga, murrinh kanhi manarranu, kardu ngalantharr murntak nhini Jonah-ka kardu ngala-wa nukunu-yu, mu kardu nugarn numi kanhi da karrim kardu ngala thathpirr dimpewal ngarra nukunu Jonah-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bere nukunu Jesus-ka murrinh numi warda mampirra, “Nga. Mere nangkal ngadha karibirl thungku lem-yu i kurdungath warda nhini-yu. I nukunu-ka mere deyida bupak pepe ngarra pakit-yu, wurda. Mu nukunu-ka kangkarl da matha mamkale i thungku-ka parlarrangnu pintha. I kardu ngarra thelput nukunu-re parnimardinu-ka nhini-ka thungku nhini warda pubangkardunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I nga. Nanhthi kamarl ngarra nanki-ka mangini thungku layit mani-wa nhini-yu ngarra ngepan nanki-nu-yu. Nanhthi kamarl ngatha da patha-nu numpanmirlbirl, nhini-ka nanhthi ngepan-ka tarangka da matha palarrangnu pani nhini-yu. Mu kamarl ngatha da wiye-nu numpanmirlbirl-ka, nhini ngepan-ka da ngarra thipmam binhi mani-wa narnam nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","I nga. Murrinh thathpi ngay-ka mangini thungku damlarrang deyida mani ngarra nginipunh nanki-nu-yu. Nhini-ka mere nangingkamit nukun murrinh ngarra ngay-yu i nhini-ka mere warda thipmam binhi nurunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mu nga. Murrinh thathpi ngay numangabathnu ngatha nuru i nurdungayemitnu ngatha nuru-ka nhini-ka mere warda thipmam binhi nurunu nhini-yu. Mu nhini nanki da ngarra patha da matha nurunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bere ngarra nukunu-re Jesus murrinh dampirrarikerdek-ka kardu nugarn kardu Pharisees-ya dantharrpu Jesus mi dhepdhep pulathnu ngarra thelput nukunu wangu-yu. Bere Jesus i kardu nhini-ka pangu warda wangu naninthadha dini ngarra thelput kardu nhini da nukunu. Bere kanamninthardi i mi warda dinininthamurrktha wunku kardu Pharisees ngamere wanku-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bere kardu nugarn nhini kathu-ka bemkabatnintha ngarra Jesus-yu nhini-ka mere menanumapurldha warra ngadha mange ngarra nukunu-yu da ngarra mange murntak kardu ngarra nhini Pharisees pumedha punni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bere Jesus kathu-ka mampirra, “Nanki kardu Pharisees-ka kardu bere matha wangu numemnupurl numpan nanhthi nginipunh nanki-yu. Mu marda ngarra nanki-ka nanhthi wiye ngala thathpirr nanthin numpan i wertnumarnti-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nanki-ka kardu mere ngadha the thathpirr numabath nuru. Pule ngala Yile neki-ka nanhthi nginipunh ngarra nanki mampatha i nanhthi marda ngarra nanki deyida wanku mampatha. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nhini-ka mere nukun kardu wertnumarnti nuru mu nanhthi narramutmutnu nuru ngarra kardu mananhthi-wunka i nhini-ka nginipunh ngarra nanki-ka tarangka warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nanki kardu Pharisees-ka mere le nukun nuru. Nanki-ka mi ngarra kadin thangunu kathu mi kunungingki narramnamutmut numpan ngarra Yile neki-yu. Mu nanki-ka mere thathpirr marda numart nuru Yile neki-yu i mere mange patha nururra ngarra kardu-yu. Mange-ka patha-wa nhini-yu nanhthi narramnamutmut numpan ngarra Yile neki-yu, mu da ngala thathpirr-ka marda numartnu nuru Yile neki-yu i da mange patha nururranu ngarra kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“I ngana deyida,” Jesus kathu mampirra. “Nanki kardu Pharisees-ya mere le nukun nuru. Ngarra da church mana narnardi-ka nhini-ka le-wa numpan nhini-yu narnawup ngarra da chair patha-patha-yu ngarra kumparra wurrankadhuk-yu. I nanki-ka le numpan numpannilili pana ngangka-re ngarra kardu wurnangat pirrimkadhuk i nhini kardu-ka pirananthenhthenhnu warda nhini-yu i panantiparlnu warda parni nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“I ngana deyida mere le nukun nuru. Nanki-ka nginipunh kardu patha mani numemnurart numpan mu marda nanki-ka wiye thathpirr-wa i da mange wiye pangannanka pumpan ngarra kardu wurnangat-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bere kardu Pharisees kardu numi-ya mamna warda ngarra Jesus-yu, “Pule, nhinhi-ka kardu thanngankampa thanam-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mu Jesus kathu-ka mampirra deyida, “Nanki ngarra murrinh law nuddanpunthethith numpan-ka mere le nukun nuru nhini-yu. Nanki-ka nungannarriral numpan ngarra murrinh law nhini-yu. Nanki-ka murrinh law ngamere deyida numampatha numpan i kardu numampunnilil numpan murrinh pumanarrabathnu puru-yu i da tetemanthay da matha narrampirramutmut numpan-yu. Mu nanki-ka mere deyida numenumabath nuru murrinh law ngarra nanki ngatha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“I ngana deyida mere le nukun nuru nhini-yu. Kardu ngalantharr murntak nanki-ka da murntak warra punninthuktha punni kardu pana ngarra murrinh thathpi Yile neki puddanarrayiththa punni. I nanki-ka da mintilbith pana ngarra pubenmirrbirrdha punni-ka da lelunh da matha numampatha numpan i niranganpe numpan da nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kardu ngalantharr nanki-ka thu punninthuktha punni kardu pana ngarra murrinh thathpi Yile neki puddanarrayiththa punni i nhini nanki-ka niranganpe warda numpan da mintilbith pigunu-yu. Nhini nanki-ka le-wa numpan kardu thu punninthuktha punni-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nga. Da murntak warra-ka Yile neki murrinh kanhi-wa mam-yu, ‘Ngay-ka ngurdurradhukthuknu ngurru kardu nugarn-yu ngarra kardu Jews-nu-yu i murrinh thathpi ngay-ka puddurrayithnu puru-yu. Mu kardu Jews-ka punthuknu puru kardu ngamere nhini-yu i yidingurr parramutmutnu puru kardu ngamere-yu,’ mam nukunu Yile neki kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“I nga.” Jesus kathu-yu mampirra deyida. “Kardu ngalantharr murntak nanki-ka thu punninthuktha punni kardu nugarn pana ngarra Yile neki wurdininthukthuktha dini-yu. Kardu marra-re thangunu kathu nukunu nan-wa Abel i ngarra da nukunu da mana Zechariah kardu ngarra nanki-ka thu punninthuktha punni kardu nhini-yu. I ngay murrinh manarranu-ka Yile neki-ka punantirdanu nanki kardu pana ngarra birnu narnam kardu pana-nu kardu ngarra darrikardu nanki thangunu punninthuktha punni kardu nhini-ya. Nukunu nhini Zechariah-ka pumpanmat ngarra murrinh church ngala da matha da manta ngangka da ngarra ku pinnangamnapek pibim Yile neki-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“I ngana deyida,” Jesus kathu-yu mampirra. “Nanki ngarra murrinh law nuddanpunthethith numpan-ka mere le nukun nuru nhini-yu. Nanki-ka mere thathpirr nuddunthethith nuru murrinh law-yu. Mu nanki-ka numpanpunpengkaywuy numpan kardu-yu i narrampirradhawup numpan kardu-yu da mange ngarra Yile neki nukunu the pumabathnu-yu.” Nhini-wa murrinh-yu Jesus mampirra ngarra kardu Pharisees-ya. I nhini thangunu-ka kanampunpart warda i nungardurr pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Mu kardu nhini-ka parramnarithi warda ngarra Jesus-yu. I nhini thangunu kardu Pharisees nhini-ka bere ngatha wangu murrinh parranidharrpudha punni ngarra Jesus-yu kardu bere matha mana wangu-wa perrengurradhaththa puyi nukunu-yu i murrinh perrenakthuktha mana-wa puyi i kardu warda pumertadha i puyibattha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bere nhini thangunu-ka kardu wurnangat puyemperr ngarra Jesus-yu. Kardu-ka wurnangat nimin-ya i nanhthi me-ka punnanumethurrthurrdha-wa punni. Mu da marra-re warra ngadha-ka Jesus-ka wurdampirruyithneme ngarra pulangay nukunu, “Nga peneme,” mampirruneme. “Thawath wangu nururrunemenu kardu Pharisees-yu kardu pana ngarra murrinh law puddannanthethith pumpan-ya. Kardu nhini-ka patha-wa pumemnurart pumpan mu kardu-ka kardu wiye-wa nhini-yu. I parrampunpinhingkayit pumpan da ngarra wiye wangu. Nhini-ka thawath da matha wangu nururruneme i mere nankuriwak-nukun-neme nuru kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Mu nga. Kardu thangku ngatha mange nhini pinumardarriwupnu parni ngarra mange pumanarranemenu-ka, nhini-ka da nakurl-te warda the pumabathnu kardu wurnangat warda ngatha ngarra nukunu Yile neki-re warda manmardarripurlnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","I murrinh dederrk pana ngarra kardu namam numpan da ngarra thipinhi-ya i murrinh ngarakngarak numpan ngarra thelput nganamarda nhini da nakurl-te-wa kardu wurnangat warda ngatha pubiyepupnu murrinh nhini pilampirdarri da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","I nga peneme. Ngay-ka manarrunemenu mere nukun nenkumanhamneme kardu pana ngarra thu punankuthuknu-ngatha-neme-yu. Kardu punankuthukneme-ka nginipunh da matha, mu kardu nhini-ka mere ngarra kunankubatneme nukun nanhthi ngepan ngarra nankuneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mu Yile neki da matha nemanhamnemenu nuru-yu, nukunu da matha kardu mani pirranputhnu ngarra da thungku ngala wangu, da nan Hell, nanhthi nginipunh-ya i nanhthi ngepan wanku. I nhini ngay-ka mamnankumardawerrneme nankuneme-ka numerrdharrnu nukunu da matha nemanhamneme nuru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Nga, ku murrirrbe purrkpurrk nganaka, ku-ka ngathayida-wa nawa? I ku ngatha thelim nuyemanu-ka nhini ku mani wakal da matha numart. Mu Yile ngay-ka the kanthin ku terert nhini warda ngatha-yu. I ku numi ngatha buybat i kupup nhini nukunu-ka the kanthin ku murrirrbe nhini-yu. I nanki deyida wanku the kanthinnan. I thangku numa ngatha nanhthi pemarr ngarra pelpith nanki nanthin numpan-ka the deyida kanthin nukunu Yile ngay-yu. Nhini ngay murrinh manarranu-ka mere nenham nukun nuru, nanki-ka ngala thathpirr nimpunpewal ngarra ku murrirrbe-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“I nga. Nubingayepup-kathu-neme,” Jesus kathu-yu mampirruneme. “Nankuneme-ka kardu ngay-wa. I kardu ngatha murrinh nuyemarranemenu nuru nankuneme-ka ngarra ngay da matha narramngiriwakneme numpanka, nhini ngay kardu darrikardu nanki thathpirr-ka nganirratharrmunu ku angel pangu parnam ngarra da Yile ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mu kardu nangkal ngatha ngarra kardu ngamere-nu wangu murrinh kanhi marranu, ‘Ngay-ka mere ngariwak ngurru Jesus-yu.’ Nhini ngay kardu darrikardu nanki thathpirr-ka murrinh nhini deyida wanku nganirratharrmunu ngarra ku angel-yu, ‘Kardu pana-ka kardu mere thathpirr ngarra ngay nukun pana-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","I kardu ngatha murrinh mangirdarrithak ngarra ngay-ka, Yile ngay-ka kunumaku mani-wa da mange wiye nhini-yu. Mu kardu ngatha murrinh mardarrithak ku ngepan patha Yile ngay nukunu, nhini Yile neki-ka mere ngarra kirramaputh i mere ngarra kuymayekum da mange wiye nhini-yu, wurda da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“I nga. Ngarra kardu-re purunankungawurtnemenu-ka i murrinh court wangu pumanankubertinuneme-ka nhini-ka mere numerrungkumardawerr-nukun-neme murrinh pangu wangu ku pule ngala-ngala numarrunemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mu ngepan Yile ngay nukunu-ka manankudhawiyithnuneme murrinh thathpi ngarra numarrununeme-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bere kardu nugarn numi kardu ngarra wurnangat thangunu kathu mamna ngarra Jesus, “Ya pule. Ngarra yile ngay-re yibimpup-ka ngathan ngay-ka mangankut nanhthi purrkpurrk ngarra nukunu mamngarruwekurrk-yu. Mu ngathan ngay nananu mangayerrnu kathu nanhthi purrkpurrk ngamere-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mu Jesus kathu-ka mamna, “Ya, nhini-ka mere da mange ngay mananu-yu. Mu kardu pule numi nananu da mange nhini-nu mampayerrnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bere Jesus kathu-ka mampirra warda ngarra kardu wurnangat nhini, “Nga kardu. Thawath wangu i mere numangurruthputh nuru nanhthi purrkpurrk-nu-yu i ku mani. I mere mawumawu nuru nanhthi-nu-yu. Nhini nanki-ka mere warda nukun le nenumut nuru nanhthi terert nhini numabath nuru-yu. I mere ngarra narnibirnu nukun nanhthi pana nanthinkadhuk numpan da bere matha wangu-yu, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bere Jesus-ka murrinh warda wurdampirrayith, murrinh mampunkardarrath-ya, i mampirra, “Murrinh kanhi ngurdinarrayithnu-ka kardu nugarn ngarra nanhthi wurnangat mebaththa wurrini nanhthi purrkpurrk-ya. I mi kadin ngala wanku mebaththa dini i mi terert da matha wurdinirurturttha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“Bere mange nukunu memnu, ‘Da thelput ngamere ngay-ka kunungingki-wa i da ngalthe mi dhepdhep nukun-yu ngarra mi kadin ngay thangunu ngarrimkutkut-yu. Mu ngarra-wa da burdurdinu ngirra mi wurnangat-darri kanhi-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aa berengunh, the warda nganthin,’ memnu. ‘Thelput kunungingki-ka bawirtpirtnu ngurru i thelput ngala ngala thathpirr warda barderdenu ngurru i mi dhepdhep terert warda ngatha burdurdinu ngurru nhini-yu i bemardarrnu ngurru i nanhthi purrkpurrk ngamere deyida wanku. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","I nhini thangunu-ka menunu mange ngay. Aa, ngay-ka mi terert da matha nganthin ngem i nanhthi purrkpurrk deyida wanku nganthin ngem. Ngay-ka mere warda wurlk ngamanu ngurru da kurran kanhi wangu-yu. Mu ngay-ka bere matha wangu bangiyuknu pani nhini-yu. I ngay-ka mi-ka nganimurrknu i kura nganigurdugurduknu i le da matha nganinu nhini-yu,’ nukunu nhini-yu memnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mu Yile neki-ka murrinh mananu ngarra kardu nhini-yu, ‘Nhinhi-ka kardu pelpith wiye-wa. Thipinhi marra-ka nhinhi-ka thupup-wa-nu. I mi terert pana i nanhthi purrkpurrk nhinhi demmardarr thim i namngurruthputh thim-ka nhini-ka nawekurrk da-nu matha nhini-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bere murrinh nhini thangunu Jesus kathu-ka mampirra ngarra kardu, “Nga kardu. Mere numangurruthputh nuru i nubemardarr nuru mi i nanhthi purrkpurrk-yu mangini kardu nhini mani-yu. Nukunu kardu nhini wurdanayemittha wurrini-ka mi i nanhthi purrkpurrk nukunu da matha, i Yile neki-ka mere menanabirldha. Mu kardu nukunu nhini-ka yibimpup-wa nhini-yu. Nhini nanki-ka mere nukun numarart nuru kardu nhini-yu, mu ngarra Yile neki da matha numenabirl nuru-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bere Jesus-ka wurdampirrumardarduyneme ngarra pulangay nukunu i mampirruneme, “Nga, mere nenuwerrneme ngarra mi dhepdhep wangu-yu i nanhthi purrkpurrk. Mu Yile ngay da matha pirranankupenuneme purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nankuneme-ka kardu-wa thathpirr mu mi i nanhthi-ka kunungingki-wa. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nga, ku wak nganaka? Ku-ka mi mere kubabirr kuru mi kamarl. I mere kuddururturt kuru mi dhepdhep i mere kubarartal i mere kubemardarr kuru mi-yu ngarra thelput, wurda da matha nhini-yu. Mu Yile ngay-ka dirranganpunpe kanam ku nhini-yu i mi dampirramutmut wurran. Mu nankuneme-ka kardu-wa pana-yu i ngala thathpirr, mu ku wak-ka mere kardu nhini-yu nhini Yile ngay-ka pirranankupenemenu purru nankuneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Nga. Mere nangkal ngadha da pirdithme panibirnunu ngarra da putek kanhi-yu penewerrnu ngatha pani da mange nginipunh nhini wangu-yu wurda, mere niyema-nukun-neme nuru nhini-yu. Nhini-ka mere nenuwerrneme nuru mi dhepdhepnu-yu i nanhthi kaligu-nu-yu i nanhthi purrkpurrk-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nga, nubangkardu mi purripulawa purrkpurrk pangu kurrankadhuk-yu. Mi-ka mere wurlk kuyema kuru i nanhthi kaligu mere kawarl karni nanhthi pangu pubuyrdurdinu, wurda. I mi pangu-ka lelunh da matha dimpunpewal ngarra nanhthi kaligu ngarra King Solomon banardurdidha wurrini nanhthi kaligu murruwurlngka nimin-ya da murntak warra-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yile neki-ka mamlelunh mi purripulawa terert warda ngatha, mu mi-ka mere pirdith i demmugarl. Marra kanhi-ka mi kibimkadhuk, mu thipinhire-ka mi-ka demmugarl warda, i kardu-ka niraputh warda mi nhini-yu. Mu Yile neki-ka lelunh da matha mampatha, i nhini-ka nanki deyida pirrananpenu purru nanhthi-nu nubuyrdurdinu nuru nhini-yu. Nga, mi i nanhthi-nu ngatha nerrewerr numpan-ka nhini-ka nuddamnayemit kunungingki da matha ngarra Yile neki-nu. Mu nuddunayemitnu thathpirr nuru ngarra nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Mere nenuwerrneme nuru mi dhepdhep-nu-yu i kura-nu-yu nhini-ka Yile ngay-wa panarramutmutnuneme purru nhini-yu. Nukunu-ka the kanthinnankuneme ngarra mi mami narnamkaneme i nanhthi mananhthi narnamkaneme. Mu kardu pana ngarra Yile ngay mere the kumabath-ka bere matha wangu perrewerr pumpan mi-nu i kura. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mu nankuneme nenawerrneme nuru-ka Yile ngay da matha nukunu. I nukunu da matha marda numartnuneme nuru-yu i da mange nukunu da matha nariwaknemenu nuru-yu. I kumparra nubupaknemenu nuru-yu i nhini-ka mi i nanhthi-ka panarrumutmutnu-warda-neme purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nga. Nankuneme-ka kardu ngay-wa nhini-ka mere nenhamneme nhini-yu. Yile ngay-ka ku Pule ngala nankuneme-wa i nukunu-ka marda mangannankurtneme wurran dirrangannankupeneme wurran. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nanhthi purrkpurrk-ka mere nubemardarrneme nuru, mu narrumutmutneme nuru ngarra kardu mananhthi-wunka. Mange nginipunh nhini mani-ya nariwakneme nuru ngarra mange Yile ngay wangu i nhini nukunu-ka nanhthi patha warda bunarrupaknemenu ngarra da nukunu wangu-yu. I nanhthi nhini-ka bere matha wangu pingkadhuknu da ngarra Yile ngay wangu-yu. I kardu-ka mere nangkal darrarart kurru nanhthi nhini i ku wungki-ka mere kulath nukun nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","I nankuneme ngatha mangini nhini mani nubemardarrnuneme nuru da kangkarl-ka, nhini nankuneme-ka marda numartnuneme nuru pangu da matha narnenuneme ngarra da Heaven.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","40","Bere Jesus-ka wurdampirrayith warda murrinh ngarra nukunu deyida kathu purdiwurlnu ngarra da putek ngala kanhi. Murrinh-ka kanhi-wa mampirra-yu, “Nga. Kardu pule ngala wurrinidha mi dhepdhep-nu kardu ngarra perrkenku-nu marrit mamngintha. Mu ngarra thelput nukunu-re kanampart-ka kanhi-wa murrinh mampirruneme ngarra kardu nukunu wurlk pumenadha punni-yu, ‘Nga peneme. Nankuneme-ka kanhi da nengamardamardaneme. Ngay-ka nakurl ngurdiwurlnu thipinhi deyida da kalkkalk kama.’ “Bere kardu ngarra pule ngala nhini-re wurdawurl-ka nukunu-ka panmat ngarra tuwa i kardu ngarra nukunu-ka tuwa pumamnadharlneme. I kardu pule ngala nhini-ka le warda kardidha nhini kardu ngarra nukunu-ka pinamardamardadha-weyida-neme nhini-yu. Nhini-ka patha-wa nhini-yu kardu pangu pinamardamardadhaneme nukunu-nu-yu. I nhini pule ngala nhini-ka mi dhepdhep warda mampathawatha i dampirrumutneme kardu ngarra nukunu. Nginipunh nhini mani-ya nanki-ka nuyungamardamardanu ngay kardu ngarra darrikardu nanki thathpirr-nu ngurdiwurlnu da ngarra putek ngala kanhi deyida. Nanki-ka mere the numabathnu ngarra ngay deyida kathu ngurdiwurlnu-yu. Mu ngurrunu kathu-ka ngarra da pana ngarra nanki mere manankulkulnu pi ngay-nu. “Nga. Kardu darrarartka nganaka. Nukunu-ka purrunu pangu ngarra thelput ngarra kardu-re mere mankulkulnu pi i mangkardap warda nanhthi karnabuy-nu. Mu kardu ngatha mankulkul ki-ka kardu darrarartka nhini-nu-yu, nhini-ka kardu-ka kiranginikat warda kardu nhini-nu-yu i kubumadhap warda darrarart nhini-yu ngarra thelput nukunu-yu. Mange nginipunh nhini mani-ya nanki-ka mere the numabathnu minthire ngay ngurrunu kathu-yu, nhini nanki-ka niranginginikatnu i nuyungamardamardanu ngarra ngay deyida kathu ngurdiwurlnu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bere nukunu Peter kathu-ka mamna ngarra Jesus, “Nhinhi-ka murrinh pana murrinh ngankuneme da matha kama thurdamngarrayithneme-yu? I kardu wurnangat-nu kama thurdamngarrayith-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Mu Jesus kathu-ka murrinh numi deyida mampirra kardu pana ngarra wurlk patha mamna wurran ku pule ngala nukunu-nu-ka nginipunh kardu kanhi mani-wa. “Nga. Kardu pule ngala-ka memmangkart kardu ngarra wurlk thangunu kathu pumenadha punni thelput ngarra nukunu pirranapenu pi i kardu pule parethbathnu kardu pule pirranu ngarra kardu nukunu. I nhini thangunu kardu pule ngala-ka nungardurr pangu warda wangu da ngarra numi-nu. I kardu pule numi ngarra darntethbath-ka thelput dirranapedha kardi-yu i wurlk danirramutmuttha wurrini i mi dhepdhep danirramutmuttha kardi ngarra kardu nhini-yu. Nukunu kardu-ka kardu patha-wa. Bere da nakurl-te kardu pule ngala nhini-ka wurdawurl deyida kathu i bamkardu kardu pule numi-yu da mange patha wurrinidha i nhini-ka le warda kardinadha kardu pule ngala nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bere kardu pule ngala nhini-ka banpak warda kardu pule numi nhini-yu nanhthi terert ngarra nukunu pirranapenu pi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“I nga,” Jesus kathu-yu mampirra. “Mu kardu nhini murrinh kanhi ngatha midha, ‘Yaa, kardu pule ngala pangu-ka da pirdithme kanarnum-ya. Ngay-ka kardu mere mange patha marrabathnu ngi kardu ngarra nukunu-yu.’ I nhini thangunu nukunu-ka thu panpunthuk warda kanam i mi dhepdhep kanammurrk i kura murlak da matha kanamkurdugurduk. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mange nhini mani nukunu kama kurru-ka nukunu nhini-ka mere mani the-wa mabath ngarra pule ngala purdiwurl-deyida-nu kathu-yu. I mere mani-wa makulkul ki nhini-yu. I ngarra nukunu pule ngala nhini-re purdiwurlnu-ka nhini bangkardunu nukunu-ka kardu wiye-wa nhini-yu i nhini-ka pubatnu warda i purdungkarelnu nhini-yu kardu da ngarra wiyenpun parnam pangu-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nga. Kardu nugarn pana ngatha murrinh thathpi binayepupnu ngarra kardu pule ngala nukunu i mere murrinh manabath, nhini-ka da nakurl-te-wa kardu pule ngala nhini-ka pubatnu warda lurruth da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","I kardu nugarn pana ngatha mere binayepup murrinh thathpi pule ngala nukunu i da mange wiye mam ngarra ku pule nukunu mere marda mart-ya, da nakurl-te-wa kardu pule ngala nhini-ka kubat deyida nhini-yu thawath. Nhini nukunu-ka mere binanayepuptha murrinh thathpi ngarra pule ngala nukunu-yu da ngarra marra-re kathu-yu. “Nga,” Jesus kathu-yu mampirra. “Yile neki ngatha-ka damnarramut mukmuk ngala-ka nhini nukunu marda mangannanart-ka da mange patha da matha nurunanu. I Yile neki damnarramut nanhthi purrkpurrk terert ngatha-ka nhini nukunu marda mangannanart-ka kardu numanmanpinu nuru i nanhthi nhini narramutmutnu nuru. I murrinh thathpi nukunu ngatha the numammath numpan-ka nhini nukunu marda mangannanart-ka kardu numarranu nuru murrinh nhini-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Bere Jesus-ka murrinh deyida mampirra, “Nga. Ngay-ka ngurrinidha da putek ngala kanhi-ka kardu marranu ngurru da mange wiye-ka parnipartnu warda. Ngay ngurrinidha-ka da mange wurlk ngarra Yile ngay-nu mananu ngurru. I ngay-ka bangamngimardarta da ngatha wurran i ngarra da mange wurlk nhini da mana marikerdeknu. I nhini thangunu-ka kardu wurnangat warda ngatha the pumenumabathnu da mange ngarra wiye pumammath pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","I nhini kardu-ka mere warda marda ngala watmam puyunu, wurda. Mu kardu ngamere-ka marda pumangertnu puru ngay i pangiriwaknu da mange ngarra ngay wangu. I ngamere-ka mere marda pumangertnu puru i kardu nhini-ka puddurdarrarrnu puru nhini-yu. Nhini weyida ngay ngurrinidha da kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Nga. Nginipunh kanhi mani-ya kardu puddurdarrarrnu puru. Kardu 5 kama-ya ngarra da numi penungime-ya. I kardu perrkenku kama-ya marda pumangertnunintha pe ngay-nu. I kardu perrkenkuneme kama-ya mere marda pumangertnungime pe ngay-nu-yu. Mange nginipunh nhini mani-ya kardu wurnangat warda ngatha puddurdarrarrnu puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yileyile i wakal-ka purduninthardarrarrnu i kalekale i wakal-ka purdunginthardarrarrnu. I wunku mardapipingintha purdunginthardarrarrnu. Mange nginipunh nhini mani-ya kardu darrikardu manta puddurdarrarrnu puru-yu. Kardu ngamere-ka marda pumangertnu puru i ngamere-ka wurda, mere marda pumangertnu puru ngay-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bere Jesus-ka murrinh deyida mampirra ngarra kardu wurnangat-yu. “Nga. Ngarra nanki-re nubangkardunu kalakkalak thipmam purrunu kathu nhini-ka the-wa numabath nhini-yu kura paniyelnu. I nhini-ka kura da thathpirr kanamyel. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","I ngarra nanki-re nubangkardunu therri wirrirr punuwirrnu nhini-ka the-wa numabath nhini-yu da dernturr-yu. I nhini-ka da dernturr da thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Nanki-ka nanganthenhthenh-wa numpan kalakkalak i wirrirr-yu. I nanki-ka nubamngimangkardu da mange ngarra ngay medha ngurrini-yu i murrinh deyida nubinangayepuptha nunni, mu nanki-ka mere nirangingithenhtha ngay-yu, wurda. Nanki-ka kardu numemnurart da matha numpan da mange ngarra Yile neki narrarntiwak numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nanki-ka nuddunudhadhapnu da mange ngarra patha thathpirr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nga. Kardu ngatha murrinh mampa, ‘Nhinhi-ka da mange wiye nam, nhini ngay-ka ngarra murrinh court-nu warda manhibertinu ngurru.’ Mu murlmurl da matha thurruninthanu murrinh ngarra court-nu wangu-yu. Mu wurda ngatha-ka nhini-ka manhiberti da matha-nu purru ngarra murrinh court nhini-yu, i nhini-ka ngarra ku judge panamutnu. I ku judge nhini-ka nhinhi-ka panamutnu warda ngarra ku policeman, i nhini ku policeman-ka pampadhapnu warda ngarra jail. ");
INSERT INTO mwf2018_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","I pangu da matha thinganamardanu i ngarra ku mani terert da mana pay thamanu, ku fine-ya. Murrinh thathpirr mamnarra-yu.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bere da nhini-re kardu ngamere punnidha ngarra Jesus i pumamna, “Nga. Kardu ngamere pangu thangunu kathu da nan Kelili punnidha da nan Jerusalem ngarra murrinh church ngala ku-nu pinnanapeknu ngarra Yile neki-nu. Mu ngarra nhini-re Yile neki pinnanapektha punni-ka ku pule ngala nhini Pilate wurdanpunthuk ngarra ku soldier nukunu-ka ngarra kardu nhini-yu i thu punninthuktha warda punni nhini-yu. “Pule, kardu nhini-ka kardu wiyenpun kama punnidha nhini weyida Yile neki wurdanpirramurl kardu pirriniwuwuptha nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mu Jesus kathu-ka mampirra, “Ya. Nanki nubenthengkarnirn kardu pangu-ka mange wiye ngala thathpirr pumedha punni nawa? I nhini-nu thu punninthuktha punni pangu-yu? Nanki nubenthengkarnirn kardu nhini-ka da mange wiye ngala thathpirr pumedha punni i kardu ngamere deyida wanku-yu ngarra da Kelili mange wiye kunungingki-wa ngatha pumedha punni-yu?” Dampuntharrpu Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Awu, mange mere nhini-nu-yu thathpirr pangu-yu. Mu nga,” Jesus kathu-yu mampirra. “Nanki ngatha da mange wiye mere narnipartnu-ka nhini-ka nuyuwuwup deyida nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I kardu pana 18 nganaka ngarra thelput pangkuy-re panpunmel da nan-ya Siloam. Nanki nubenthengkarnirn-ka kardu nhini-ka pirriniwuwuptha-ka da mange wiye ngala thathpirr thangunu pumedha punni i kardu ngamere deyida wanku da ngarra Jerusalem da mange wiye kunungingki-wa ngatha pumedha punni-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awu wurda-wa nhini ngay manarra-deyida-nu kardu wurnangat warda ngatha da mange wiye pumammath pumpan-yu. I nanki ngatha da mange wiye mere narnipartnu-ka nhini-ka nuyuwuwup deyida nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bere Jesus-ka murrinh deyida wurdampirrayith, i mampirra, “Nga. Kardu pule mi thay fig wurdinirurturttha dini ngarra mi kadin nukunu. “Bere da nakurl-te kardu pule nhini wurrinidha ngarra thay nhini da bengkardudha wurrini mi-nu-yu. Mu mi-ka mami-wa, mere berdurttha. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","I nukunu-ka bere ngatha wangu daninayerdurrdha kardi, mu mi-ka mami-wa mere berdurttha. I kardu pule nhini kathu-ka mamna warda ngarra kardu pana ngarra mi kadin nukunu dirranapedha kardi, ‘Ya,’ mamna. ‘Ngay-ka nganinayerdurrdha ngardi da thangku perrkenkuneme warda ngarra thay mi kanhi-nu-yu, mu mi-ka mami da ngatha kanhi-yu i mi mamingka da matha. Mu nhini-ka thuwangkat warda thay kanhi-yu i thunguyegaynu i mi thay numi deyida-nu babirrnu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mu nukunu nhini kathu-ka mamna, ‘Ya pule. Pama da pirra ngadha. Ngay-ka ngumekurrknu kanhi-re i nganimewunu mi ngukin ku puliki thangunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","I mi ngatha pinthatnu da thangku kurran kathu-ka nhini-ka bere ngatha pirranu. Mu wurda-nu ngatha-ka murrinh deyida nanganu nguwangkatnu nhini-yu.’” Nhini-wa murrinh Jesus wurdampirrayith-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bere nhini thangunu ngarra da Saturday mana mam-ka, Jesus-ka murrinh wurdininthethiththa dini ngarra da church kardu Jews pigunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bere kardu palngun pangu da dinidha wunku ku ngepan wiye kanthidha dini. Ku ngepan wiye nhini-ka matharr ngala damngemut i da-ka thangku 18-wa mam bere matha wangu pangkin denawinhikuldha kardi-yu i mere ngarra yuthpan yungirathtaththa wurri. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bere Jesus-ka bamkardu nigunu-yu i dimngekay, “Ya muthingka, kagu. Matharr pana-ka kanamnhipart warda marra kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","I marnarrithap ngarra pangkin nigunu. I nigunu-ka yuthpan warda pirret i Yile neki warda darntiparl nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mu ku pule ngala ngarra da church nhini-ka kardu damnarithi warda ngarra Jesus-nu, nhini-ka mampatha thangunu weyida kardu palngun nhini-yu ngarra da Saturday. I nhini nukunu-ka mampirra ngarra kardu warda wangu, “Nga kardu. Da-ka 6 da matha nawa wurlk pamanungime purru-yu? I da ngarra Saturday mana-ka bangannhiyuk-warda-ngime dim nhini-yu, nawa? I nanki kardu matharr ngatha numabath nuru-ka, nhini-ka nurunanu kathu da ngarra 6 ngamere nhini da matha-yu i mananpathanu patha warda. Mu ngarra da Saturday-ka mere nuruna nukun ngarra nukunu-yu matharr mananpathanu-yu, wurda.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mu Jesus kathu-ka mamna ngarra kardu pule nhini-yu, “Ya. Nanki-ka numemnadhart numpan Yile neki narrarntiwak mana numpan mange ngarra nukunu wangu. Nga. Nanki-ka numampuntharrkirrk ku tangki i ku puliki. I nuddanpunthukthuk numpan kura patha-nu da terert-ya. I da Saturday deyida wanku nuddanpunthukthuk kura patha-nu warda-yu, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mu kardu palngun kanhi-ka, nigunu-ka kardu-wa thathpirr, mere ku tangki. I nigunu-ka kardu darntethbath ngarra ngalantharr nan thangunu kathu-ya Abraham. I ku karrath-ka mertadha kardi nigunu-yu da thangku 18 da mana, mu kanhi-ka mange patha-wa mamnge ngay-yu mampatha i ngurdankarel ku ngepan wiye-yu marra kanhi-yu da ngarra Saturday. I nhini karrath-ka mere mayit warda kurru nigunu kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bere kardu pule ngala nhini i ngamere pana ngarra Jesus mere marda pumerttha-ka, kardu yidiwe warda pardidha ngarra murrinh nhini pubimnayepup-yu. Mu kardu terert ngamere-ka kardu le patha nimin pardinadha ngarra mange ngala ngala da mange terert nhini Jesus medha wurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bere Jesus-ka murrinh numi deyida wurdanpunthethith. I mampirra, “Nga. Ngay-ka ngurdinarrayithnu murrinh numi deyida. Da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Yile neki nukunu i ku Pule ngala thathpirr pirranu mange-ka murrinh nginipunh kanhi mani-wa ngurdiyithnu kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nanki-ka the mana nanthin nawa mi kamarl mustard. Mi kamarl nhini-ka mi kunungingki thathpirr-wa. Bere kardu-ka mi kamarl nhini-ka manganart i bangammirr ngarra putek. I nhini thangunu-ka mi-ka wurdanturturt warda thay ngala da mana. I ku murrirrbe pumpannupup ngarra nithinu-nithinu i ku dirri wanku pumampatha pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","“I nga.” Jesus kathu-yu mampirra deyida. “Ngay-ka murrinh deyida ngurdiyithnu da mange ngarra kardu wurnangat murrinh pumanabathnu puru murrinh ngarra Pule ngala Yile neki nukunu i ku Pule ngala thathpirr pirranu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nanki-ka the mana nanthin nawa nanhthi baking powder-yu. Bere kardu palngun manganart nanhthi baking powder kunungingki i mamkarnu ngarra mi lawam. I nigunu-ka mi ninganthi warda i mi lawam-ka ngala warda dinidha nanhthi baking powder kunungingki nhini thangunu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bere nhini thangunu Jesus-ka pangu-nu wangu nadha dini da Jerusalem-nu. Ngarra mayern-te wurrinililidha-ka nukunu-ka wurdininthethiththa wurrini kardu wurnangat da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bere kardu numi kathu mamna ngarra Jesus, “Pule. Yile neki-ka kardu ngamere da matha manthibirnunu-yu?” Dantharrpu. Bere Jesus-ka murrinh warda mampirra, ");
INSERT INTO mwf2018_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nga kardu. Da mayern pangu ngarra Yile neki nukunu yibim-ka mayern ngalthe i da weyi ngalthe wanku thanirdi pangu-yu nginipunh nanhthi tuwa ngarra thelput mani. Thurduthap da matha-nu ngala nanhthi weyi ngalthe nhini thanirdinu-yu. Kardu wurnangat nimin-ya purdudhadhapnu da weyi ngalthe nhini parnirdinu-yu mu kardu-ka mere ngarra karnirdi nukun. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Bere nhini thangunu kardu pule ngala da ngarra thelput nhini padhapnu nanhthi tuwa, nhini-ka tiduk warda numaripurlnu mere ngarra narnirdinu nhini paninanpartnu outside ngarra thelput niranu. I nhini nanki-ka nubatnu nira ngarra tuwa i niranakaykaynu, ‘Pule, nangarradharl kathu tuwa.’ Mu nukunu kathu-ka pananthartnu, ‘Awu wurda. Ngay-ka mere the mananmath nangkal nanki pana-yu. I mere the mananmath ngarra-dha kathu nanki-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","I nhini nanki-ka murrinh deyida nuddunangkarl numananu, ‘Nekineme-ka mi dhepdhep-ka marda ngala thardimurrkthaneme i thurdininganthethiththa thardi da ngarra nganki wangu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mu nukunu manarra deyida-nu kathu, ‘Ngay-ka mere the mananmath i mere the mananmath ngarra-dha kathu nunnidha. Bata-ya nuru-wa. Nanki-ka kardu wiyenan ngala thathpirr-wa.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“I nhini thangunu nanki nubankardunemenu-ka kardu ngalantharr murntak nan Abraham, Isaac i Jacob penemenu ngarra da Pule ngala Yile neki nukunu. I kardu wurnangat pana wanku ngarra murrinh thathpi Yile neki puddanarrayiththa punni ngarra da putek kanhi pardidha-yu. Mu nanki-ka mere nuru nukun da pangu-yu mu nhini kardu pule ngala pangu-ka purdunankarel da matha-nu nhini-yu. I nhini nanki-ka du ngala warda narnikarrknu i dimu ngarra nanki nalirrnu narni nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kardu wurnangat nimin-ya puyuwerrnu ngarra da kangkarl ngarra Pule ngala Yile neki nukunu-yu da ngamengka pana-re ngangka-ya i kardu le da matha parninu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“I nga.” Jesus kathu-yu mampirra deyida. “Kardu ngamere ngarra marra-re pubinthepup murrinh Yile neki-ka kardu nhini-wa tiduk warda purunu da ngarra Pule ngala Yile neki-yu. I kardu pana ngarra murrinh tiduk pubinthepup-ka kardu nhini-wa kumparra purunu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bere da nhini-re-ka kardu Pharisees ngamere punninadha ngarra Jesus-nu i murrinh pumamnaneme, “Nga. Nhinhi-ka thunurdurrnu warda-ya da ngarra kanhi thangunu-yu nhini-ka pule Hered-ka thu punhibat-da-nu-matha nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mu Jesus kathu-ka mampirruneme, “Nukunu Hered pana-ka kardu dakthuk da matha kanam. Mu nankuneme-ka nananemenu pangu ngarra nukunu i murrinh numananemenu, ‘Ngay-ka mampunpatha ngurran kardu matharr-wunngini i ku ngepan wiye ngarrimpunmaputh ngurran ngarra kardu i thipinhire-ka mange kanhi deyida ngamanu ngurru. I da thipinhire deyida, i thipinhire karrim nhini kathu-ya nhini-wa ngay wurlk marikerdeknu-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nga. Numananu-ka, ‘Mere ngunuwinhart-nukun-nintha-ya mu ngay-ka bere matha ngunungam da Jerusalem-nu warda marra kanhi-yu, i thipinhire deyida, i thipinhire karrim nhini kathu-ya. Ngarra da kanhi-ka mere kungibat nukun mu da pangu da matha Jerusalem pungibatnu-yu. Da-ka pangu da-ya punninthuktha pi-yu kardu pana ngarra murrinh thathpi Yile neki puddanayiththa punni-yu.’ Mampa nana-warda-neme i numananeme murrinh nhini,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bere nhini thangunu Jesus-ka bempirrangkarnirn warda kardu ngarra Jerusalem pardidha-yu i medha warda dini murrinh mange nukunu, “Ya, kardu Jerusalem-nan-mawu. Ngay-ka damngimardathin-wa dim nanki-nu-yu. Nanki-ka thu numpanpunthuk numpan ku prophet-yu. I kardu nugarn pana ngarra Yile ngay wurdannarradhukthuk dim-ka nguni palyirr nubangampunpelerr numpan. Da terert da matha ngay marda menanarttha ngurrini-yu i nguninanperrdha ngurrini-yu i menanperdurdudha ngurrini nginipunh ku kalekale thikin mani mampunperdurdu-ya ku ngarra wakal nigunu. Mu nanki-ka mere marda numengerttha nuyi. ");
INSERT INTO mwf2018_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mu nga. Yile neki-ka paninanpartnu warda i da church ngala nanki i mere warda pirrananpenu pani nhini-yu. I nanki-ka mere ngarra deyida nubangingkardunu mu ngarra ngay deyida kathu ngurdiwurlnu ngarra da putek ngala kanhi. I da nhini-nu-re nanki-ka murrinh kanhi warda numanganu, ‘Ya mampa, pariparlnu-warda-ngime kardu kanhi ngarra Yile neki kathu wurdanthuk wunku lurruth ngala Yile neki nukunu.’” Nhini-wa murrinh Jesus denarramardamtha dini kardu ngarra da Jerusalem pardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Da ngarra Saturday-ka Jesus-ka wurrinidha da ngarra thelput kardu pule ngala kardu Pharisees nukunu mi dhepdhep-nu-yu. I kardu ngamere deyida wanku pangu pirrinidha i pirangkadha pirrini mange ngarra pamanu muparlnu ngarra murrinh law pigunu da ngarra benyuktha-re dini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","I kardu nugarn deyida wurrininadha ngarra Jesus wunku nithi wurdanbewi i tharrmu wurdantharrmuwi. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bere Jesus kathu-ka mampirra ngarra kardu Pharisees ngamere i kardu pana ngarra murrinh law puddininthethiththa punni, “Ya. Ngarra murrinh law nekineme pirrim-yu?” Dampuntharrpu. “Da ngarra Saturday-ka berengunh nhini patha kardu matharr pumankumanpinemenu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mu kardu-ka manangka murrinh da matha pirrinidha. Bere Jesus-ka manganmert kardu nhini-yu i mampatha warda i wurdanthuk pangu warda wangu nadha dini nukunu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","I Jesus kathu-ka mampirra deyida, “Nga. Wakal ngarra nanki mani buybat kirrayeruy ngarra weyi pewerti ngarra da Saturday-ka nhini nanki-ka nuruna pangu i nungurlart i numabert, nawa? I nginipunh ku puliki nanki ngatha yida buybat kirrayeruy, nhini nanki-ka nungurlart deyida nhini-yu, nawa?” ");
INSERT INTO mwf2018_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mu kardu-ka manangka murrinh da ngatha pirrinidha i mere perredhart-da-dha-ngatha ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bere kardu-ka puyemperr warda ngarra nanhthi table i parnawup mi dhepdhep-nu. Bere Jesus bampunkardu kardu ngamere kardu ngathayida parnawup ngarra nanhthi chair ku pule ngala ngala nukun. I nhini-ka murrinh warda wurdampirrayith murrinh yibimkamnum-ya. I mampirra, ");
INSERT INTO mwf2018_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ya. Ngarra kardu-re kirrampakay mi dhepdhep-nu kardu ngarra perrkenku-nu bamnginthamardi-ka nhini-ka mere thaniwup nukun ngarra da chair kardu pule ngala ngala nukun-yu. Nhini-ka kardu pule ngala thathpirr kama nukun kurru kardu ngarra kinhiwewal kama-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","I nukunu kardu pana ngarra pirrimpakay mi dhepdhep-nu-ka mampanu murrinh-yu, ‘Nga. Kardu kanhi-ka paniwupnu ngarra chair pana-yu, nukunu-ka kardu pule ngala-wa karrim kanhi-yu.’ I bere nhinhi-ka yidiwe warda thaninu i thaniwupnu ngathparr kathu tiduk thinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Mu ngarra nanki-re mi dhepdhep-nu kinarrakay-ka nuyungkadhuk pangu da kathu tiduk i mere narniwup nukun ngarra chair ku pule ngala ngala nukun-yu. I da nakurl-te kardu nhini pinarrakaynu i manarranu murrinh kanhi, ‘Kagu. Nuru kathu manta kanhi nuyunu ngarra ngay ngarra da chair patha patha kanhi.’ I nhini kardu ngamere-ka pubanankardunu nanki-ka kardu ngala ngala da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Nga. Kanhi murrinh numi-yu,” Jesus kathu-yu mampirra. “Kardu nangkal ngatha menungala-ka nhini-ka da nakurl-te pinu kardu manangka pule-ya. Mu kardu nangkal ngatha buynupak kunungingki-ka nhini-ka da nakurl-te-wa nukunu-yu kardu pule ngala pinu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bere Jesus kathu-ka mamna ngarra kardu pule ngala nhini-yu kardu pana-ya ngarra dimnakay mi dhepdhep nhini-nu-yu, “Nga,” mamna. “Mi dhepdhep terert ngatha nawathawathanu-ka mere ngatha thanirrakaykay kardu ngarra pulangay nhinhi ngatha i kardu darrikardu nhinhi i kardu pana ngarra ku mani ngala pumammath pumpan. Nhini kardu nhini-ka da nakurl nukun deyida karnimpakaykay mi dhepdhep deyida-nu-yu. Mu Yile neki-ka mere ngarra panhiriparlnu mange nhini-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mu mi dhepdhep terert ngatha nawathawathanu-ka nhini-ka thanirrakaykaynu kardu pana ngarra ku mani mananhthi-wunka, i kardu pulith i kardu kamarrama i kardu mangini nhini mani thanirrakaykaynu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","I kardu nhini-ka mere ngarra karnimpakaykay nukun ngarra da pigunu kathu-yu mi dhepdhep-nu-yu, wurda. Kardu nhini-ka kardu mananhthi-wunka da matha. Mu nhinhi-ka kardu le da ngatha thani nhini-yu. I da nakurl-te Yile neki-ka panhiriparlnu i nanhthi patha patha da matha pampamutmutnu da nhini-nu-re ngarra kardu pathanpun puddingkarlbirlnu-yu,” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bere kardu numi pangu da dinimurrktha, i bimnayepup murrinh thathpi ngarra Jesus. I mamna, “Yu pule, kardu pana ngarra da nakurlnu mi dhepdhep puyumurrknu da ngarra Yile neki da Heaven wangu-ka, kardu nhini-ka le da matha puyunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bere Jesus kathu-ka murrinh warda wurdamnayith i mamna, “Nga. Kardu nugarn numi, mi dhepdhep terert mampathawatha i kardu warda daninthelerrdha wurrini mi-nu-yu kardu wurnangat pullathnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bere ngarra mi-re warda mampathawatha-ka kardu warda wurdanthuk kardu numi ngarra nukunu-yu, i kardu warda wurrinirrakaykaydha, ‘Ya, kardu. Mi warda kagu,’ merradha wurrini kardu nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Mu kardu-ka murrinh parriniyirrararttha purni thirrukduk. I numi-ka murrinh nginipunh kanhi mani mam, ‘Awu, ngay-ka da putek ngadha peyim ngamam marra kanhi i ngununu ngi bangkardunu. Nhini-ka mere ngarra nganimurrk mi dhepdhep pana-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","I kardu numi mam deyida, ‘Awu bere ngadha. Ngay-ka ku puliki terert ngadha mangankut peyim ngamam marra kanhi-yu. I ngay-ka bunthadhapnu ngadha ngani marra-yu. I nhini-ka mere ngarra kama ngurru nukun mi dhepdhep pana-nu-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","I ngana deyida kardu numi kathu-ka mam deyida, ‘Awu wurda. Ngay-ka kardu marra ngadha palngun ngay bamnginthamardi i mere ngurru nukun mi dhepdhep pana-nu-yu, wurda.’ Murrinh mangini thirrukduk nhini mani-wa pumedha purni kardu terert nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Bere kardu nhini-ka wurdawurl pangu i murrinh kanamnatharrmu ngarra ku pule nukunu. I kardu pule nhini ngarra mi mewathawathadha dini-ka pumammardaraki ngala da matha warda nhini-yu. I mamna ngarra kardu nhini deyida, ‘Nga. Wunkarra-re wangu thunu thi da pana ngangka-re-ya ngarra da thelput purrkpurrk i thurrurrakaykaynu i nanbertinu kathu thurru kardu mananhthi-wunka i kardu pulith i kamarrama.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Bere kardu nhini-ka pangu warda wangu nadha dini wurrinirrakaykaydha kardu mi dhepdhep-nu. Bere nhini thangunu-ka wurdawurl deyida tharra i menbertidha wurrini kardu nhini-yu ngangka da ngarra thelput mi-nu. I murrinh warda mamna ngarra ku pule nukunu, ‘Pule, berengunh kardu nhini-ka kanhi karrimkadhuk. Mu da thelput kanhi-ka da-ka ngala da marda da ngatha.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mu ku pule nhini kathu-ka mamna deyida, ‘Ya. Thunu deyida thi i da puy tharrngini wangu thununu thi ngarra da puth i thurrurrakaykaynu kardu nhini da kathu i pimardalipnu thathpirr ngarra thelput kanhi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","I murrinh thathpirr kanhi mampanu. Kardu nhini ngarra marra-re ngempirrakay mi kanhi-ka, kardu-ka mere kulath nukun.’” Nhini-wa murrinh wurdamyith Jesus-yu ngarra murrinh yungkamnumtha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bere nhini thangunu-ka kardu wurnangat nimin-ya parraniriwaktha punni Jesus-yu. Bere nukunu Jesus-ka pirret i wurdampirramardarduy ngarra kardu i mampirra, ");
INSERT INTO mwf2018_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nga kardu. Nanki-ka ngay-wa thathpirr kumparra marda numangertnu nuru-yu ngarra yileyile i kalekale nanki-yu. I ngana deyida nanki-ka ngay-wa thathpirr kumparra marda numangert nuru-yu ngarra palngun i wakal nanki i ngathan i munak nanki-yu. Mu mere ngatha marda thathpirr numangertnu nuru nginipunh nhini mani nanki-ka mere warda kardu ngarra ngay nurunu nhini-yu. I nanki deyida nuynuyekum i ngay da matha kumparra nubungipaknu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nga. Kardu-ka da mange wiye da matha pumanarranu puru nhini nanki-ka kardu pulangay ngay weyida. I yidingurr ngala panarramutnu i punanthuknu kama. Mu nanki-ka mere marda numart da mange nginipunh kanhi mani mere ngatha pumanarranu puru-ka nhini-ka mere ngarra nukun pulangay ngay nurunga, i mere ngarra nukun kangilerr ngarra ngay-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bere Jesus-ka murrinh warda wurdampirrayith i mampirra, “Kardu ngatha thelput ngala barderde-ka da marra-re warra ngadha-ka mukmuk da warra ngadha bengkarnirn nanhthi purrkpurrk pangu-nu ngarra thelput-yu. I ku mani nukunu puriwunu thangku numa nanhthi kanthin dim-yu thelput nhini-nu barderdenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mu nukunu ngatha mukmuk mere bengkarnirn marra-re-ka nhini nukunu barderde kuret wardarra-ka kunungingki wardarra bangarnerde i nhini ku mani-ka kanimarikerdek wardarra i mere ngarra warda barikerdek thelput nhini-yu. I kardu-ka kirakampa warda karni nhini-yu, ");
INSERT INTO mwf2018_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Kardu pana-ka thelput pantet mu mere ngarra barikerdek nukun,’ murrinh pumananu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“I nga.” Jesus kathu-yu mampirra deyida. “Ku pule ngala wunku kardu tharrngini-ka mere kunkuwarra kunu ki kuyethukneme pangu kardu ngarra pule ngala numi wunku kardu wurnangat thathpirr-ya. Mu marra-re warra ngadha-ka mukmuk da warra ngadha bengkarnirn kuntiwu i thangku numa kardu nukunu-yu puyethuknuneme-yu kardu ngarra nugarn ngamere-yu i kardu ngarra nukunu-ka lurruth-ka ngala puyethuknuneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mu kardu nhini ngatha the mabath ku pule numi i kardu ngarra nukunu punnunmirrnu nhini-ka kardu warda purdunthuknu kardu ngarra pule ngalanhini-nu kardu warda ngatha murrinh pekpek i watmam penuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“I nga,” Jesus kathu-yu mampirra. “Mange nginipunh nhini mani-ya nanki-ka nubengayengkarnirnnu warra ngadha kardu ngarra pulangay ngay ngatha nurunganu-yu i nangilerrnu-yu. Kardu pulangay ngay nurunga-ka nhini nanki-ka kumparra warra nubungipak mu kalekale i yileyile i nanhthi purrkpurrk-ka tiduk-wa nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Bere Jesus-ka mampirra deyida, “Nga. Nanhthi salk-ka patha nawa ku ngen nukun-yu? Mu nga. Nanhthi salk murntak manangka thithimarnti-ka nhini-ka wiye da matha nhini-yu i mere da matha nanhthi salk patha deyida nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nanhthi-ka wiye da matha nhini-yu i nunnuku warda nanhthi nhini-yu. Kardu nangkal ngatha murrinh kanhi mangimarta-ka kardu nhini-ka murrinh-ka mabath warda nhini-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bere kardu terert deyida puyemnawerr ngarra Jesus murrinh thathpi nukunu pubinayepupnu. Bere ngarra kardu terert nhini-ka, ngamere-ka kardu pana-wa ngarra ku mani parrinidhakthuktha purni ngarra kardu thangunu ku Government-nu, i ngamere-ka kardu pana murrinh law kardu Jews pigunu mere marda pumerttha puyi, kardu wiyenpun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bere kardu Pharisees i kardu pana ngarra murrinh law Jews pigunu puddininthethiththa purni-ka pubampunkungkardu-warda-neme kardu nhini wunku Jesus-yu i pumemnungkuneme mange peneme, “Ya. Nukunu kardu pangu-ka wurrannupup kardu ngarra wiyenpun i mi wanku kanammurrk ngarra kardu nhini-yu, nukunu-ka mere kama kurru mange nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bere Jesus kathu-ka murrinh wurdampirrayith i mampirra kardu terert, ");
INSERT INTO mwf2018_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nga. Kardu nugarn mabath ki ku thip, ku-ka 100-wa, i bere matha wangu ku kirranpe kani. Mu ku thip numi ngatha kaniwarrk-ka ngarra warda kama kardu nugarn nhini-yu? Nukunu nhini-ka kaninpart ku thip ngamere nhini 99-yu ngangka da mi parnu kawekat karni i kunu kirrawinhadhath tharra ku thip numi nhini-nu-yu i ngarra bardurt da mana. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","I nhini nukunu-ka le warda kani i kuymanthi ku thip nhini-yu ngarra lamala nukunu i maberti tharra ngarra da warda wangu. I ngarra nukunu-re kurdiwurl pangu warda wangu ngarra thelput nukunu-nu-ka, nukunu nhini-ka kirrarrakay kardu pangu ngatha karni-ya i murrinh kanhi marra, ‘Nga kardu. Ngay-ka bangarnurt warda ku thip pana ngarra kanawarrk-yu. Mu mampa marda ngala warda ngatha le pinungime wunku ngay marra kanhi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“I nga.” Jesus kathu-yu mampirra. “Nginipunh murrinh nhini mani-ya Yile neki i kardu pana ngarra da Heaven parnam-ka le da thathpirr parninanu ngarra kardu nangkal ngatha kanipart da mange wiye i kariwak kurru da mange ngarra Yile neki nukunu. Yile neki i kardu pana ngarra da Heaven parnam-ka le parnampirra kardu ngarra pathanpun-yu kardu 99-yu, mu kardu pana thathpirr le parninanu-yu ngarra da mange wiye panipartnu i ngarra Yile neki wurdamnawurl-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bere Jesus-ka murrinh numi deyida wurdampirrayith i mampirra, “Nga. Kardu palngun mabath ki ku mani, ku-ka ngala-wa. Mu ku mani ku numi ngatha mathak ngarra thelput-ka ngarra warda kama kardu palngun nhini-yu? Nigunu nhini-ka thungku lem karibirl i kirrawinhadhath kani ngarra thelput da thipmam binhi-yu inside i kuputh warda thelput-yu i ngarra ku mani bardurt da mana. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","I ngarra nigunu-re ku mani nhini bardurt-ka, nigunu-ka kirrarrakay kardu da pangu ngatha karni i murrinh kanhi marra, ‘Nga kardu. Ngay-ka bangarnurt warda ku mani pana ngarra manthak-yu. Mu mampa, marda ngala warda ngatha le pinungime wunku ngay marra kanhi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“I nga.” Jesus kathu-yu mampirra. “Nginipunh murrinh nhini mani-ya kardu pana ngarra kanipart da mange wiye i kurdinawurl ngarra Yile neki, nhini ku angel nukunu Yile neki da kangkarl parnam-ka le thathpirr warda karnina nhini-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bere Jesus-ka murrinh numi deyida wurdampirrayith i mampirra, “Nga. Murrinh kanhi-ka murrinh kardu yileyile i wakal nugarn nukunu perrkenku. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bere wakal nukunu numi kardu wakal tinay-ka mamna ngarra yileyile, ‘Yile, nanhthi ku mani kathu thangamut i nanhthi purrkpurrk wanku i da putek kunungingki nangayerrnu. Nanhthi ngarra nawekurrknu ngamere-ka thangamutnu warda,’ mamna. Bere yileyile-ka nanhthi nukunu mampirruyerryerr warda wakal nukunu perrkenku-yu i damnamut nanhthi purrkpurrk ngamere wakal kardu tinay nimin. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","14","“Bere nhini thangunu wakal nhini tinay-ka kanamkut nanhthi purrkpurrk i ku mani nukunu i nungardurr warda. Pangu warda wangu nadha dini da ngathparr da ngamengka-nu. I da ngamengka nhini da mange wiye da matha merithuktha kardi i kura murlak kardigurdugurduktha. I ku mani-re wurdinipidha kardi i bunirikerdektha kardi i bantikerdek da mana. “Bere nhini thangunu-ka mi-ka mami warda-wa mi dhepdhep-yu pardidha da nhini-yu kardu wurnangat warda ngatha i nukunu deyida wanku kardu medeyi kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bere kardu warda nugarn numi wurlk ngarra ku pigipigi damnamut da nhini-yu. I nukunu-ka ku warda dirranpedha kardi mi danirramutmuttha kardi mi ku pigipigi nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mu nukunu-ka kardu medeyi da ngatha kardidha i marda merttha wurrini mi ku pigipigi nukunu pulathnu, mu mere nangkal ngadha denamuttha mi dhepdhep nukunu-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bere nhini thangunu-ka kardu warda pamkathip. I memnu, ‘Ngay-ka kardu pelpith wiye-wa ngardidha, mu kardu ngarra yile ngay nukunu wurlk parnamna-ka mi dhepdhep ngala da matha parnammurrk pangu-yu. Mu ngay-ka kanhi da medeyi nganam-yu i ngunganpirntay nganam ngala da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mu bere ngurdinawurlnu pangu deyida ngarra yile ngay i murrinh kanhi mananu, “Yile, ngay-ka da mange wiye da matha merithuktha ngardi. Ngay-ka mamnhimardaraki ngarra nhinhi-nu-yu i Yile neki deyida wanku mammardaraki. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngay-ka da mange wiye da matha ngardidha nhini-ka mere deyida wakal nhinhi nganimpa nukun. Mu ngay-ka wurlk da matha mampanu ngurru mange nginipunh kardu ngamere ngarra nhinhi wurlk pumampa pumpan.” Murrinh-ka murrinh nhini-wa mananu-yu ngarra yile ngay-nu-yu,’ memnu nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Bere nukunu nhini-ka dempirnturt nungardurr warda da ngarra nhini thangunu-yu i nanadha dini pangu warda wangu ngarra Yile nukunu-nu. Bere da ngathparr kathu nathiptha dini pangu kathu yileyile-ka bamkardu i mam, ‘Wakal ngay da matha pangu kathu kununganthip kem-yu.’ I damnamardathin warda wangu yileyile-yu i nanawinhararttha wangu bangammardabi i mangarnta panthamayirrikat i danthamurrudhung. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Bere wakal kathu-ka mamna, ‘Yile, ngay-ka kardu wiye da matha ngardidha,’ mamna. ‘Ngay-ka mammardaraki ngarra Yile neki-yu i nhinhi deyida wanku mamnhimardaraki. Ngay-ka kardu yidiwe warda i mere nukun deyida wakal nhinhi nganimpa nukun,’ mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Bere yileyile kathu-ka mampirra pangu warda wangu ngarra kardu wurlk pumenadha purni, ‘Ya. Nanhthi kaligu patha da matha kathu i buyrdurdinu nukunu kanhi, i nanhthi ring mange nukunu i me put wanku, wunkarra-re-nu kathu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","I ku puliki pelenangka patha nubatnu i nubanhengkabunemenu. Nekineme-ka le warda paninuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wakal ngay kanhi-ka kanamngipart kardu mangini ku yibimpup mani-wa kardidha-yu. Mu marra kanhi kardu-ka wurdamngawurl i birnu deyida dim. Nukunu wakal kanhi-ka kanawarrk-wa mu marra kanhi kardu-ka bangarnurt warda-wa.’ “Bere nhini thangunu-ka mi warda pardimurrktha mi dhepdhep ngala da matha i ku wanku pardimurrktha i le da matha pardidha. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bere ngathan nukunu kardu kumparra nimin-ka pangu da ngatha da ngathparr tharrngini wurlk medha kardi da nhini-re-yu. Mu ngarra nukunu-re wurdawurl wurlk thangunu kathu marntikerdek-ka wurrinidha kathu ngarra thelput manta warda-ka i binthepup. ‘Thangku kanhi-yu kemkarrkmarda kanhi-yu i nanhthi wunku thamarl karnarntel-yu i nanhthi purrkpurrk karnampurrkpurrk-yu?’ Memnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","I bere nukunu kardu numi wurrannakay i mamna, ‘Ya. Thangku pana-yu?’ Mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Ya. Ngathan nhinhi-ka marra kanhi wurdawurl,’ mamna. ‘I mi warda dhepdhep ngala kanhi ngarnammurrk i le ngarnamna. Yile nhinhi-ka ku puliki pelenangka patha panmat nhini nukunu-ka wurdamnawurl warda nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mu nukunu kathu-ka ngathan ngala nhini-ka marda ngarra nukunu-ka ningammardakat da matha i mere kanirdidha mi-nu-yu, wurda. Bere yileyile kathu-ka wurrininadha i mamna, ‘Ya. Thanirdi kathu-ya. Kagu thanirdi kathu,’ mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mu nukunu wakal ngala nhini kathu-ka mamna, ‘Yile, ngay-ka wurlk ngala da matha mempadha ngardi da pirdithme nimin-ya i murrinh mempabaththa ngardi nhinhi-yu. Mu nhinhi-ka mere ngadha thangku thengamuttha ku nenigut kama-ya ku dhepdhep-nu ngarra pulangay ngay ngulleththaneme,’ mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I ngana deyida mamna, ‘Mu nga. Wakal nhinhi pana-ka wurdinipidha kardi ku mani nhinhi-yu ngarra kardu palngun wiyenpun kardirrittha. Mu marra kanhi-ka wurdampawurl warda nukunu pangu-yu i nhinhi thannabat-ka ku puliki ku pelenangka patha pana warda thannabat-yu i narnammurrk pana warda.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mu yileyile kathu-ka mamna, ‘Nga. Nhinhi-ka kanhi da matha thanam ngarra ngay. Nanhthi purrkpurrk terert kanhi warda ngatha nanhthi ngarra ngay-ka nanhthi nhinhi deyida wanku nhini-yu,’ mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","‘Mu kanhi ngathan nhinhi-ka nginipunh ku yibimpup mani-wa kardidha-yu, mu kardu-ka birnu-wa kanam marra kanhi-yu. Nukunu-ka kardu nginipunh kanawarrk mani-wa, mu nukunu-ka wurdawurl deyida. Mu mampa-ya kardu le warda paningime mi panimurrkngime,’ mamna yileyile kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bere Jesus-ka murrinh numi deyida wurdampirruyithneme ngarra pulangay nukunu. I mampirruneme, “Nga. Kardu pule ngala kanthingkadhuktha dini nanhthi purrkpurrk terert nimin-ya i ku mani terert wanku. Bere nukunu nhini-ka kardu nugarn numi banpak i dirranapedha kardi nanhthi ngarra purrkpurrk nukunu i ku mani. Mu bere, da nakurl-te kardu ngamere kathu punninadha pangu ngarra kardu pule ngala nhini i parnamnatharrmu, ‘Ya pule. Kardu nugarn pana ngarra nanhthi nhinhi dirranganpape kanam nganaka, nukunu-ka ku mani nhinhi wurdanpi wurran.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Bere kardu pule ngala nhini-ka dimnakay warda nukunu kardu nugarn nhini-yu i murrinh mamna, ‘Ya. Kardu-ka pumamnga nhinhi-ka mere thathpirr thirrangape thani nanhthi purrkpurrk ngay-yu i ku mani ngay i thurdannganthapi thanam nanhthi-yu. I nhini-ka murrinh thangarililnu ngarra nanhthi peypa thangku numa warda nanhthi namngabath thim marra kanhi-yu i thangku numa ku mani-yu. I nhini ngay-ka the warda thathpirr mabathnu thangku numa nanhthi-yu danngantharikerdek-yu. I nhini thangunu murrinh peypa nhini tharililnu tharikerdeknu-ka nhini wurlk ngarra ngay-ka thanipartnu warda nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Bere kardu nhini-ka memnu mange nukunu ngatha, ‘Ya. Ku pule ngay-ka purdungikunu ngarra wurlk kanhi-yu. I ngarra warda ngamanu ngay nhini-yu? Ngay-ka wurlk ngarra mi kadin mere nganirutuy nukun nhini ngay-ka kardu mere lurruth ngala nhini-yu. I ngay-ka mere ngarra nganirrakaykay ku mani ngarra kardu-yu nhini ngay-ka kardu yidiwe-ngiwe-wa nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ba yu berengunh,’ memnu. ‘Ngay-ka the warda nganthin mange ngamanu-yu. Ngay-ka mankuripulangaynemenu wunku kardu pana-ya ngarra nanhthi pumammarart pumpan i mere da ngatha puddunangkalaththaneme-ya ngarra ku pule ngay-yu. I da ngarra wurlk kanhi ngay-re marikerdeknu-ka nhini-ka kardu nhini warda pumangirnarnanu warda parni nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Bere nukunu kardu nhini-ka dinirrakaykaydha warda numi numi kardu pana ngarra ku mani i mi dhepdhep mere da ngatha puddunangkalaththa ngarra ku pule ngala nhini-yu. I dantharrpu kardu numi-yu, i mamna, ‘Ya. Thangku numa da ngatha nanhthi thurdunangkalathnu-yu ku pule pana-nu-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","I kardu nugarn nhini kathu-ka mamna, ‘Ngay ngurdunangkalathnu-ka nanhthi olive oil terert, nanhthi-ka 100 drums-wa.’ Mu nukunu nhini kathu-ka mamna, ‘Nga. Nanhthi peypa wunku murrinh nhinhi-ka kanhi-wa. Nayerrarrnu nanhthi 100 drums-yu i nanhthi 50 drums warda dupaknu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“I kardu numi deyida kathu dimnakay, i mamna, ‘Thangku numa da ngatha nanhthi thurdunangkalathnu-yu ngarra ku pule pangu-nu-yu?’ I kardu nugarn nhini kathu-ka mamna, ‘Ngay ngurdunangkalathnu-ka mi wheat terert mi-ka 100 bags-wa.’ Mu kardu nugarn nhini kathu-ka mamna, ‘Nga. Nanhthi peypa wunku murrinh nhinhi-ka kanhi-wa. Nayerrarrnu mi 100 bags i dupaknu warda mi 80 bags.’ I mange nginipunh nhini mani-wa merrudhaneme wurrini kardu ngarra terert-yu i le warda dampirrumutneme nhini-yu i mampunkupulangayneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bere ku pule ngala nhini pamnayepup mange ngarra nukunu nhini medha kardi. I dimnakay warda kardu nhini-yu, i murrinh mamna, ‘Ya. Nhinhi-ka kardu mukmuk patha-ya. Nhinhi-ka nampunkuripulangayneme ngarra kardu i nhini-ka kardu warda pumanhirnarnanemenu da nakurl-te-nu-ya, nawa?’” Bere Jesus kathu-ka mampirru-deyida-neme ngarra kardu nhini-yu, “Nga. Kardu pana ngarra mere kariwak kuru da mange ngarra Yile neki nukunu-ka kardu mukmuk ngala-wunpe ngarra ku mani i nanhthi purrkpurrk nukun-yu, i kardu pirrimpunpewal kardu ngarra Yile neki nukun wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“I nga,” Jesus kathu-yu mampirruneme. “Nankuneme deyida-ka kardu numankumanpinemenu i numankuripulangaynemenu ngarra ku mani nankuneme-re-yu. I ku mani narrumutmutnemenu nuru kardu ngarra mananhthi-wunka da ngarra putek ngala kanhi parnam. I da nakurlnu-re ngarra nuyuwuwupnemenu-re-ka, nhini Yile neki-ka le paninarrunemenu da mange patha nhini thangunu numerrudhaneme nardi-yu, i nukunu-ka panankumardawithnemenu da ngarra nukunu wangu dim. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","I kardu nangkal ngatha pirrapenu ngatha thathpirr purru nanhthi mani kunungingki i nanhthi purrkpurrk i mere kurrudarrarart-ka, nhini nukunu-ka ku mani ngala deyida wanku pirrapenu purru nhini-yu. Mu ku mani i nanhthi purrkpurrk mere thathpirr kirrapenu ngatha-ka i kurrudarrarart-ka, nhini nukunu-ka mere ngarra kirrapenu nukun kurru ku mani ngala-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","I nankuneme mere ngatha nirapeneme ku mani thathpirr-ka i nanhthi purrkpurrk ngarra da putek kanhi-ka, i nhini da nakurlnu Yile neki-ka mere warda kurdunarruyemit-nukun-neme nanhthi purrkpurrk patha patha-yu ngarra da nukunu wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yile neki-ka nanhthi wurnangat warda ngatha damnarramutmut wurran, mu mere ngatha nirape thathpirr nuru nanhthi nhini-ka, nhini nukunu-ka mere kanarramut nukun nanhthi patha patha nanhthi ngarra numabathnu nuru-yu da nakurl-te-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mu nga. Mere nangkal ngadha murrinh birruyepupnintha i murrinh marrubathnintha ku pule ngala ngala perrkenku-nu-yu, wurda. Mu nukunu-ka ku pule ngala numi da matha murrinh manabath-yu le kanina i mere ngarra murrinh manabath ku pule ngala numi-yu i mere le kanina nukunu-yu. I nga. Mange nginipunh nhini mani-ka Yile neki i ku mani-ka mere kinintha nukun ku pule ngala nanki-nu-yu, wurda-wa nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bere kardu Pharisees pana ngarra ku mani marda pumerttha punni-ka murrinh thathpi pubimnayepup ngarra Jesus-yu i pangankampa warda ngarra nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mu Jesus kathu-ka mampirra ngarra kardu Pharisees nhini-yu, “Nga. Nanki-ka kardu bere matha wangu numentart numpan kardu patha i nginipunh nhini mani kardu pubamnankardu pumpan-yu. Mu Yile neki-ka the-wa mamnankumabathneme ngarra marda nankuneme-yu. Kardu-ka parramnankuriparlneme parnamka mu Yile neki-ka mere marda manankumartneme mange ngarra nankuneme wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Da murntak warra nukunu Moses-ka darntilil murrinh law Yile neki nukunu kardu-nu. I nhini thangunu kardu nugarn ngamere-ka ku prophet-ya murrinh thathpi Yile neki puddanarrayiththa punni i ngarra John the Baptist da mana pangarntuy. I ngarra da nhini thangunu kathu-ka ngay-ka murrinh thelerrdhe patha nganinthelerrdha ngurrini da mange Yile neki nukunu-yu i murrinh nukunu ngatha ku Pule ngala thathpirr i dirranganpunpe wurran kardu ngarra nukunu-yu. I kardu wurnangat nimin-ya puddanthadhap pumpan ngala da matha da mange ngarra nukunu wangu pariwaknu puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mu murrinh law murntak pana ngarra Moses darntilil-ka murrinh lurruth ngala da ngatha yibim i mere ngarra kiyerrarr nhini-yu, wurda. Nhini-ka bere ngatha pirrana ngarra da putek i pilinh kanhi panirikerdeknu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“I nga. Kardu nugarn ngatha kanipart kurdurinumi ngarra palngun nukunu i palngun numi kathu mabert i bemnginthalet-ka nhini nukunu-ka da mange wiye-wa mam nhini-yu. I kardu nugarn numi deyida kathu mabert kardu palngun nhini kardu nugarn ngarra marra-re bemnginthalet-ka nhini nukunu deyida wanku da mange wiye mam-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","21","Bere Jesus kathu-ka murrinh mampirra, “Nga kardu. Murrinh kanhi ngurdinarrayithnu-ka kardu nugarn perrkenku. Kardu numi-ka ku mani ngala i nanhthi purrkpurrk terert kanthidha dini, i kardu numi-ka kardu mananhthingka. I kardu mananhthingka nhini murrinh nukunu-ka nan-wa Lazarus. “Bere kardu pana ku mani terert kanthidha dini-ka nanhthi kaligu patha da matha banardurdidha kardi i mi dhepdhep terert da matha kardimurrktha. Mu nukunu kardu numi nhini Lazarus-ka mi mami kardidha i nukunu-ka nanhthi lirrwi terert mebaththa wurrini i ku were parranigudhugudhuktha pardi. Bere nukunu Lazarus-ka kardu bere matha kardingurrkurrktha outside ngarra thelput nukunu kardu nhini ngarra mi terert kardimurrktha i mi-nu marda merttha kardi mi ngarra daniritmuttha kardi. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Bere da nakurl-te warda nukunu Lazarus-ka yibimpup warda i ku angel-ka panthinmardawith ku ngepan nukunu-yu ngarra da kangkarl wangu i kanamngurruwup ngarra ngalantharr nan-ya Abraham. I kardu nugarn nhini deyida ngarra mi dhepdhep terert kanthidha dini-ka yibimpup deyida nhini-yu i pubangammirr. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I ngepan nukunu-ka nadha dini pangu da wangu ngarra da thungku ngala dim da nan-ya Hades i pangu da kardidha wunku nanhthi yidingurr ngala danilututtha kardi. Bere nhini thangunu nukunu-ka kangkarl mamka warda-wa i bamkardu Abraham da ngathparr nimin dinidha-ya i wunku Lazarus dinininthadha pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Bere dimnakay warda i mamna, ‘Yile Abraham, kanhimardathin kathu ngadha ngay-nu. I thurduthuk Lazarus mange purdimakulknu ngarra kura i thurdungathuknu ngarra nanhthi themen ngay mangidhanmethapnu pangidhanmeburrnu. Ngay-ka ngarra thungku ngala kanhi nganam wunku nanhthi yidingurr ngala da matha damngilutut kanam,’ mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mu nukunu Abraham kathu-ka mamna, ‘Ya. Nhinhi-ka the-wa nammath ngarra birnu-re thardidha-ka nhinhi-ka da patha da matha pirrimpadha, mu nukunu kanhi Lazarus-ka da wiye da matha kardinadha-yu. Mu marra kanhi Lazarus-ka ngarra ngay warda ngemnintha ngarra da patha kanhi i le warda dim. Mu nhinhi-ka ngarra da wiye warda thanam ngarra da thungku ngala wunku nanhthi yidingurr ngala damnhilutut kanam. ");
INSERT INTO mwf2018_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","I nga murrinh numi-yu. Da ngarra kanhi thubemkarduneme thim-ka da marda nganangurr da pewerti-rdi weyida da palarrngkarda dim-ya, i nhini nganki-ka mere ngarra nguru ngarra nhinhi thim-yu i nanki kathu mere ngarra nuru kanhi ngarra ngankunintha nganamnintha.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mu nukunu kardu nhini kathu-ka mamna, ‘Yile Abraham, ngay-ka nganhidharrpunu thurduthuknu Lazarus da ngarra putek ngala pangu ngarra thelput yile ngay nukunu, ");
INSERT INTO mwf2018_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","i murrinh manmardawerrnu kardu ngathan ngay 5 pangu karnam-yu i marranu murrinh kanhi, mere nukun nuru da wiye kanhi ngarra ngay kamngilutut kanam-yu, mu narnipart-da-nu-matha da mange wiye-yu i da mange ngarra Yile neki nukunu warda nariwaknu nuru.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mu Abraham kathu mamna, ‘Ya. Ngathan nhinhi-ka murrinh panthin wardarra pumpan murrinh ngarra Moses thangunu-ya i murrinh ngarra ku prophet thangunu i murrinh nhini da matha pubiyepupnu puru-yu i pumanmardawerrnu puru-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mu kardu nhini kathu-ka mamna, ‘Awu, wurda-wa nhini-yu, yile Abraham. Kardu mere nukun kubirrayepup murrinh nhini-yu. Mu kardu numi ngatha kurdingkabirl ku ngarra putek thangunu i kunurra ki pangu ngarra da pigunu, nhini-ka murrinh-ka pubinayepup da matha nhini-yu i parnipartnu warda da mange wiye nhini-yu i da mange ngarra Yile neki nukunu warda pariwaknu puru nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mu Abraham kathu-ka mamna, ‘Mu nga. Kardu mere ngatha pubiyepupnu murrinh ngarra Moses thangunu i murrinh ngarra ku prophet thangunu, nhini pigunu-ka mere warda nangkal murrinh thathpi nhini pubinayepupnu kardu pana ngatha ngarra purdingkabirl-deyida-nu-yu, wurda da matha.’” Nhini-wa murrinh-yu Jesus wurdampirrayith. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Bere nhini thangunu Jesus-ka mampirruneme ngarra pulangay nukunu, “Nga. Kardu-ka bere matha wangu pananngurradhathnu puru i pumanantullulnu puru nanki-yu da ngarra mange wiye-nu niyemanu nuru. Mu da-ka wiye da thathpirr pirranu kardu nhini-nu ngarra mange pumanarranu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mu nga. Da-ka patha-wa kardu nhini-nu-yu kumadhamadharrk-yu nanhthi palyirr ngala yitthit-ya ngarra thamarl nukunu i kunnuku pangu mani wangu i kayiwik ngarra kura lalingkin. I nhini nukunu-ka mere mani warda kuynardarripup da ngarra wiye wangu-yu nhini kardu ngarra ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mu nga peneme. Thawath wangu mange nirabathneme kardu nginipunh nhini-nu mani-yu.” Bere Jesus-ka mampirruneme deyida ngarra pulangay nukunu kardu pana ngarra murrinh thathpi nukunu pumenabaththaneme punne. “Nga peneme,” mampirruneme. “Da mange wiye ngatha numenungkuneme mange nankuneme-ka nhini-ka murrinh thununamardawal da matha nhini-yu. I nukunu kardu nhini kamardathin ngatha-ka da mange wiye nhini thangunu mam-ka nhini-ka nuyunungkuyekumneme da matha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nukunu nhini-ka da mange wiye terert kama manarruneme kani da nginipunh 7 mani-ya da ngunga numi ngatha-ya. I nhini da mange 7 ngatha kamardathin ki-ka nhini nankuneme-ka nuyunayekum-warda-neme nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bere pulangay nukunu Jesus-ka pumamnaneme, “Pule, bere matha wangu nangankumanpineme thani murrinh thathpirr ngumampabathnuneme ngarne.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bere Jesus kathu-ka mampirruneme, “Nankuneme ngatha murrinh thathpirr numangabathneme murrinh kunungingki ngatha nhini nankuneme-ka niyemana-mani warda-neme ngarra thay ngala kanhi karrim-yu, ‘Nanhthi thay thunginulart mange nhinhi i thununuku mange nhinhi pangu wangu ngarra kura lalingkin.’ I nhini nanhthi thay nhini-ka murrinh warda manarrubathneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“I nga peneme.” Jesus kathu-yu mampirruneme deyida. “Kardu numi kama wurlk manarruneme kurru ngarra mi kadin i ku thip ngatha-ka, bere ngarra wurlk-te marikerdek nukunu-ka ngarra thelput kanirdi i mere ngarra ngadha numananeme, ‘Kagu, thaniwup kanhi i mi ngadha thanimurrknu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awu wurda, mere ngadha numananeme murrinh nhini-yu, mu murrinh-ka kanhi-wa numananeme-yu, ‘Mi dhepdhep ngankuneme nangarruwathawathanemenu i nangarrubathnuneme thurru i kanhi da. I ngarra ngankuneme mi ngarikerdeknu-ka nhini-ka nhinhi warda thanimurrknu nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nhini-wa da mange thathpirr yibim-yu. I nukunu-ka bere matha wangu murrinh manarrubathnuneme purru-yu mu nankuneme-ka mere ngarra nariparlneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","I nankuneme-ka mange kardu nginipunh wurlk nhini mani medha kardi i murrinh thathpi ngay numangabathnuneme nuru. Nhini-wa da mange thathpirr yibim-yu i ngay-ka mere warda bere ngatha wangu nganankuriparl-nukun-neme ngani nhini-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bere Jesus i pulangay nukunu-ka kardu da Jerusalem-nu warda wangu purnelilidhaneme. Bere da ngarra nan Samaria i Kelili-ya marda nganangurr nhini-wa pardililidhaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I da ngarra manta mana warda parraniruydhaneme da ngarra town kunungingki nhini-ka kardu nugarn 10 pardengkadhukthaneme da ngathparr kathu. Kardu nhini-ka matharr leprosy pumebaththaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bere peneme nhini-ka pardenakaykaydhaneme ngarra Jesus-nu, “Pule Jesus,” pumamnaneme. “Kardu panhimardathinnu ngadha ngankuneme-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bere Jesus-ka bampunkungkarduneme i mampirruneme, “Nga. Nananemenu pangu wangu ngarra ku yilarn i nanhthi nginipunh ngarra nankuneme banankungkardunemenu pi. I murrinh warda manarrunemenu, ‘Yu berengunh, nankuneme-ka darripi tarangka warda, manangka matharr.’” Bere kardu nhini-ka pangu warda wangu purnenadhaneme. I ngarra purnelilidhaneme-re-ka nhini peneme-ka manangka matharr warda purnedhaneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bere ngarra kardu numi-re bemnungkardu nanhthi matharr nhini-ka mananhthi warda, nhini-ka wurdamnawurl ngarra Jesus deyida i daniriparldha tharra ngarra Yile neki wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I bamnabat i dempinhimardardum kumparra warra ngarra Jesus, i mamna, “Pule, nhinhi-ka pathanhi kardu namngiwatha manangka matharr warda ngay-yu.” Mamna. Nukunu kardu nhini-ka da nan thangunu kathu-wa Samaria. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bere Jesus-ka mempirrubirlneme i murrinh mampirruneme ngarra pulangay nukunu, “Nga. Thangku numa kardu matharr mananhthi warda-yu, kardu-ka 10 nawa? Mu ngarra kardu 9 ngamere-yu?” Mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","“Mu nukunu kanhi da Samaria thangunu kathu kanhi da matha kardu ngamengka thangunu-ya wurdamngawurl ngarra ngay-yu, i darntiparl ngarra Yile neki.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bere Jesus kathu-ka mamna ngarra kardu nugarn nhini-yu, “Nga. Nhinhi-ka kardu manangka matharr warda thibim pana-yu, nhini-ka murrinh thathpirr namngabath mamnhiwatha manangka matharr warda-yu. Mampa thewirnturt warda i thununu warda thi pangu warda wangu,” mamna Jesus kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bere nhini thangunu-ka kardu Pharisees pumamna ngarra Jesus, “Ya pule. Minthire-wa Yile neki ku Pule ngala thathpirr pinhenemenu-yu i pirranhipenuneme pi-yu?” Parramkadharrpuneme. Mu Jesus kathu-ka mampirruneme, “Ya. Nankuneme-ka mere ngarra nukun nubangkardunemenu ngarra kamarl nankuneme-re-yu Yile neki pinu thathpirr ku Pule ngala-yu, wurda mange mere nhini nukun-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","I kardu-ka mere kiyema nukun, ‘Ya, nubangkardu nga. I nubangkardu pangu wangu.’ Wurda, mere ngarra nukun nubangkardunemenu mange nginipunh nhini mani-yu, wurda. Mu nga,” mampirruneme. “Yile neki-ka kardu ngamere wardarra ku Pule ngala dimpirra ngarra kardu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bere Jesus kathu-ka mampirru-warda-neme ngarra pulangay nukunu, “Nga peneme. Da nakurlnu nankuneme-ka marda numangertnuneme-ka nubangingkardunemenu ngay kardu darrikardu nanki thathpirr ngurdiwurl-deyida-nu kathu-yu. Mu nankuneme-ka mere nubangingkardu-nukun-neme ngay ngurdiwurl-deyida-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","I kardu-ka pumanarrunemenu, ‘Nga. Nubangkarduneme nukunu-ka dhi-wa karrim. Nga. Nubangkarduneme nukunu-ka kanhi karrim.’ Mu mere nubirruyepup-nukun-neme murrinh nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Mu nankuneme-ka the-wa thathpirr numabathnemenu ngarra ngay-re ngurdiwurl-deyida-nu kathu-yu. Nga. Nginipunh thu malarntath mani dimmamath nganaka i damkayip da terert warda ngatha, mange nginipunh nhini da mani ngay ngurdiwurl-deyida-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mu da marra-re warra ngadha-ka kardu parnambirnu kanhi ngadha pangamutnu nanhthi yidingurr ngala pangilututnu i nhini-ka mere warda marda pumangertnu ngay-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","“Nga. Da murntak warra nganaka ngarra nukunu Noah tharntu ngala bangarnerde. Nukunu Noah-ka murrinh merradha kardi da mange wiye parnipartnu i puddinawurlnu ngarra Yile neki. Mu kardu-ka murrinh-ka mere pubinayepuptha mu bere matha wangu mi pardimurrktha kura pardigurdugurduktha i bere ngatha wangu kardu nugarn i palngun pubanamardurdidha punni i ngarra Noah da mana parnamkardingime ngarra tharntu wunku kardu darrikardu nukunu. I nhini thangunu-ka kura ngala warda kanamyel kura ngala nimin-ya wurrinidha i kardu-ka dampunthiwik warda. Mange nginipunh nhini mani kardu pumedha pardi da ngarra nhini-re-ya. Mu kardu-ka mange-ka piyema-deyida-nu parni da nakurlnu ngarra ngay-re ngurdiwurlnu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“I ngana deyida kardu nan Lot nganaka. Da murntak nhini-re-ka kardu-ka mi pardimurrktha i kura pardigurdugurduktha i nanhthi peyim pumedha pardi i nanhthi thelim pumedha pardi i mi kamarl pubebirrdha pardi i thelput puberderdedha punni da nhini nan-ya Sodom. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mu ngarra nukunu-re Lot i kardu darrikardu nukunu da punnungamkardurrngime da Sodom thangunu-ka Yile neki-ka wurdanthuk thungku ngala da matha kangkarl thangunu kathu i panpunthuk da matha kardu wiyenpun pangu-yu, kardu nhini ngarra Yile neki mere marda pumerttha puyi-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mange nginipunh nhini mani-yu kardu-ka nakurlnu piyemanu puru ngarra ngay-re ngurdiwurl-deyida-nu kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“I nga. Da ngarra nhini-re-ka kardu ngatha pinu ngarra thelput welpen da kangkarl kathu nukunu-ka mere ngarra nukun kanirdi nanhthi purrkpurrk padhakthuk nukun. I ngana deyida kardu ngatha panirurtuynu ngarra mi kadin nukunu-ka mere ngarra nukun purdiwurlnu ngarra thelput nanhthi purrkpurrk nukunu panikutnu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","I the mana nanthinkaneme palngun nukunu Lot. Nigunu-ka memmirl da ngarra nhini parnamkapart-kathu-ngime-yu i parnte warda yibimpup. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kardu nangkal ngatha marda martnu menuyibirnunu nukunu ngatha-ka nhini-ka pupup-wa-nu nukunu-yu. Mu nangkal ngatha marda mart da mange ngarra Yile ngay wangu-ka nukunu-ka bere matha wangu birnu paninu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“I nga,” Jesus kathu-yu mampirru-deyida-neme. “Ngarra ngay-re ngurdiwurl-deyida-nu kathu-ka kardu perrkenku-ka punginthangurrkurrknu ngurrnguwarl da thipinhi. I Yile ngay-ka pamardawithnu numi kangkarl i numi-ka panipartnu pangu da wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","I kardu palngun perrkenku-ka mi kamarl pilanginthayerlnu pani. I Yile ngay-ka numi da matha pamardawithnu kangkarl wangu i numi deyida panipartnu pangu da wangu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bere pulangay nukunu Jesus kathu-ka pumamnaneme, “Pule, ngarra-wa da mange kanhi pamanu pi-yu?” Mu Jesus kathu-ka mampirruneme murrinh yibimkamnum-ya, “Ngarra ku nginipunh yibimpup kabim-ka nhini-wa da-yu ngarra ku tiwungku puyuwerrnu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bere Jesus-ka wurdanpunkuyethithneme pulangay nukunu murrinh ngarra Yile neki bere matha wangu puddunayithnuneme puru i mere kunkuwarra dallanumamardaneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I mampirruneme murrinh yibimkamnum-ya, “Nga peneme. Da ngarra numi wangu ku judge kardidha. I nukunu-ka mere marda merttha wurri Yile neki i mere murrinh binarrayewuptha wurri kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Bere da ngarra nhini-ka kardu palngun mekmunurr kardidha. Nigunu-ka bere matha wangu kardinawattha ngarra ku judge nhini-yu i menadha kardi ngarra nukunu-yu, ‘Ya pule. Nangimanpinu ngadha kardu pangu-nu nanhthi mengimarithuktha kardi kardu penhimanhamnu i nungawilnu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mu ku judge nhini-ka bere matha wangu daningkatmittha kardi da pirdithme da matha. Mu da nakurl-te-wa memnu mange nukunu ku judge-yu, ‘Ngay-ka mere binayewup ngurru murrinh thathpi Yile neki nukunu-yu i kardu deyida wanku mere birrayewup ngurru, ");
INSERT INTO mwf2018_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mu kardu palngun mekmunurr kanhi-wa murrinh damngirdarda kanam-yu nhini ngay-ka mamanpinu warda i mungewilnu nhini-yu. I nhini nigunu-ka mere warda pirrangawatnu i mere warda bungimurrkmurrk nukun kirra nhini-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bere pule Jesus kathu-ka mampirruneme, “Nga. Ku judge wiye nhini-ka mammanpi i mungamngewil kardu mekmunurr nhini. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","I mange nginipunh nhini mani-ya Yile neki-ka manmanpinu thathpirr purru kardu ngarra nukunu kardu munililnu purru da mange ngarra yuthpan nukunu wangu-yu kardu ngatha bere matha wangu padharrpunu parni nukunu-yu. I mere ngarra nukun mantharrmubath manmanpinu-yu, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mu nukunu-ka pirtpirt da matha munililnu purru da ngarra yuthpan nukunu wangu-yu. Mu nga. Ngarra ngay-re kardu darrikardu nanki thathpirr ngurdiwurl-deyida-nu kathu da ngarra putek ngala kanhi-ka, kardu-ka bannurtnu kardu ngarra murrinh Yile ngay da ngatha pumanabathnu puru i parninangerren da-nu ngatha?” Jesus kathu-yu dampunkudharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bere kardu ngamere kathu-ka murrinh kanhi pumedha purni, “Nganki-ka kardu pathanngan-wa i kardu ngamere pana terert pumpan-ka wiyenpun-wa.” I bere Jesus-ka murrinh kanhi warda mampirra ngarra kardu nhini-yu, murrinh yibimkamnum-ya, ");
INSERT INTO mwf2018_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nga. Kardu perrkenku wurrinininthadha ngarra da church ngala murrinh-nu penangerrenninthanu ngarra Yile neki-nu. Bere kardu numi marda merttha kardi murrinh law kardu Jews pigunu, nukunu-ka kardu Pharisees-wa. I kardu nugarn numi-ka ku mani daninmadhakthuktha wurrini ngarra kardu thangunu kathu ku Government-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Bere kardu Pharisees nhini-ka dempirnturt pirret pangu da i murrinh Yile neki wurdamnayith murrinh mange nukunu ngatha wurdamnuyith. I mamna, ‘Yile, ngay ngamnhiriparl-wa nhini ngay-ka mere kardu nginipunh nugarn ngamere wiye pana mani pamam pumpan. Ngay-ka da mange wiye mere ngama ngurru i mere nganidarrarart i ngay-ka mere nganinbetkut kardu ngarra palngun ngamere-yu. I ngay-ka kardu mere nimin wiye ngani mere kardu nginipunh nugarn pana mani karrim kardu ngarra ku mani danthakthuk wurran ku Government-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngay-ka mi nganampirr-wa nganam mi dhepdhep-yu da numi-numingka, nhini-ka ngarra murrinh nhinhi weyida nganampangerren. I ku mani ngay-ka mampayerryerr ngurran ngarra nhinhi,’ mamna kardu Pharisees nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mu kardu nugarn numi pana ngarra ku mani danidhakthuktha kardi ku Government-nu-ka pirridha da pangu kathu ngathparr tharrngini-wa. I nukunu-ka yidiwe pirridha pelpith pepe mewedha pirri. I nukunu kathu-ka mamna ngarra Yile neki wangu-yu, ‘Yile, ngay-ka kardu wiyengi ngala da matha, mu panhimardathinnu ngadha ngay-nu-yu i da mange wiye nangimayerrarrnu,’ mam kardu nhini-yu.” Nhini-wa murrinh-yu ngarra Jesus mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","I bere Jesus kathu-ka mampirra deyida ngarra kardu-yu, “Nga. Kardu nhini nawa kardu yuthpan warda wurrininadha ngarra Yile neki wangu-yu ngarra da thelput nukunu warda wangu wurdawurl, nhini nukunu weyida danidharrpudha wurrini Yile neki da mange wiye mammayerrarr-wa nhini-yu. Mu kardu nugarn numi nhini nganaka, kardu Pharisees-ya, kardu mere yuthpan thathpirr wurrinadha ngarra Yile neki wangu-yu, wurda, kardu memnungala-wa. Mu nga.” Jesus kathu-yu mampirra. “Kardu nangkal ngatha menungala-ka nhini Yile neki-ka kunungingki da matha kardu bupak nhini-yu. Mu kardu nangkal ngatha kunungingki buynupak-ka nhini Yile neki-ka pawirnturtnu ngala da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bere nhini thangunu kardu-ka pumenbertidha purni kardu mamay i wakal wewunmarda ngarra Jesus-nu, kardu manpedhadhapnu pi i murrinh parradharrpunu pi kardu pirranpenu pani ngarra Yile neki-nu wangu. Mu pulangay ngarra nukunu Jesus pubampunkungkardungime i pumampirrungime, “Ya peningime. Mere numanberti kathu nuru kardu mamay-yu ngarra nukunu Jesus.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Mu Jesus kathu-ka dinirrakaykaydha kardu mamay purunanu kathu-yu. I mampirru-warda-neme ngarra pulangay nukunu, “Nga peneme. Mere nubunthap nukun kardu mamay kanhi-yu, mu kardu-ka purunga warda kathu. Mu nga.” Jesus kathu-yu mampirruneme, “Kanhi-ka murrinh thathpirr-wa. Kardu mamay kanhi-ka le thathpirr parnamnga i murrinh pumamngabath parnam ngarra ngay-nu-yu. I kardu wurnangat warda ngatha murrinh thathpirr pumangabathnu mangini kardu mamay kibimkadhuk kanhi mani-yu, nhini Yile ngay-ka pirranpenu warda pani kardu nhini-yu. Mu nga. Kardu nangkal ngatha mere murrinh pumangabathnu-ka, nhini kardu-ka mere Yile neki nukunu parninu nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bere kardu pule ngala kardu Jews-ya murrinh kathu mamna ngarra Jesus, “Pule, nhinhi-ka kardu patha-wa. Mu ngay-ka da-ka ngarra ngamanu ngurru ngarra Yile neki nginu-yu da bere matha wangu-yu?” Dantharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bere nukunu Jesus kathu-ka mamna, “Thangku-nu nhinhi namnga-yu ngay-ka kardu patha-yu? Kardu mere nangkal ngadha patha kani-yu, mu Yile neki da matha patha thathpirr-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nhinhi-ka the mana thanthin Yile neki da murntak warra mam-yu. I murrinh-ka kanhi-wa mam, ‘Mere nukun da mange nangerithuk thurru kardu ngarra palngun nugarn karnabuy nukunu-yu. I kardu-ka mere thu thubat nukun i mere thurdurinumi nukun. I mere darrarart nukun thurru. I mere tharrayirrarart nukun thurru. I ngarra kalekale i yileyile dirruyewupnungintha thurru i murrinh narrubathnungintha thurru.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","I kardu nhini kathu-ka mamna, “Pule, murrinh nhini-ka kardu mamay-re ngardidha i marra kanhi da mana murrinh bere matha mebaththa ngardi murrinh nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mu Jesus kathu-ka mamna, “Nga. Da numi warda thama thurru-yu. Nanhthi purrkpurrk ngarra nhinhi warda ngatha thelim thamanu i ku mani nhini-ka tharramutmutnu thurru kardu ngarra nanhthi mananhthiwunka. I nhini thangunu-ka da ngarra Yile neki-re thimardawithnu-ka nhini-ka nanhthi patha-ka mere warda thaniyeymanu nhini-yu. I bere mampa, thurru warda i mange nhini thamanu i thurdingawurlnu ngarra ngay deyida kathu i thangirwaknu warda thani ngarra ngay wangu nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mu kardu nugarn nhini-ka murrinh nhini-re binthepup-ka nhini-ka danimardathintha warda pirri nhini-yu. Nhini-ka nukunu-ka nanhthi purrkpurrk terert kanthidha dini i mere da matha ngarra thelim midha nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bere Jesus bamkardu-ka kardu danimardathintha pirri i murrinh warda mam, “Nga. Kardu nangkal ngatha nanhthi purrkpurrk terert mammath wurran-ka nhini-ka da tetemanthay-wa nhini-yu mere ngarra kama pinanu Yile neki ku Pule ngala ngarra kardu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ku nan ku camel nganaka? Ku-ka da tetemanthay-wa ngarra kanirdi ngarra weyi kamarl ngarra nanhthi nil-yu, nawa? I mange nginipunh nhini mani-ya da-ka tetemanthay nimin-ya kardu ngarra nanhthi terert wanku mammath wurran ngarra pimardawithnu ngarra da Yile neki nukunu wangu-yu,” Jesus kathu-yu mam. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bere kardu ngamere pana ngarra pubimnayepup murrinh Jesus menadha pirri-ka murrinh pumamna warda, “Ya pule, kardu nangkal mani warda Yile neki manthiyibirnu-yu i panmardawithnu da kangkarl-yu ngarra da nukunu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mu Jesus kathu-ka mampirra, “Kardu-ka mere nangkal meyibirnu mange nukunu ngatha-yu, mu Yile ngay da matha mani mayibirnu-yu. Nukunu da matha-ka mange wurnangat da matha kama kurru nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bere nukunu kathu Peter-ka mamna ngarra Jesus, “Nga. Ngankuneme-ka ngarnamkapart-warda-neme kardu darrikardu ngankuneme i nanhthi thelput i nanhthi terert warda ngatha ngarnamkapartneme nhini weyida ngarra nhinhi warda nganhiriwaknuneme nguru-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Nga. Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu,” Jesus kathu-yu mampirruneme. “Kardu nangkal ngatha thelput nukunu panipartnu i palngun nukunu, wakal nukunu i kardu ngathan, kalekale i yileyile i ngarra ngay warda pangiriwaknu purru i murrinh ngarra ngay panthelerrnu purru, ");
INSERT INTO mwf2018_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nhini Yile ngay-ka panamutmutnu purru thelput terert-ya i kardu darrikardu terert ngarra da putek ngala kanhi ngadha paninu-yu. I da nakurl-te-ka kardu nhini-ka bere matha wangu pinu kangkarl da ngarra Yile ngay wangu dim.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bere Jesus-ka panpunkuwerrneme kardu pulangay nukunu kardu 12-ya i mampirruneme, “Nga peneme. Nekineme-ka da Jerusalem-nu warda thurranneme. Da murntak warra-ka kardu pana ngarra parrarntilil murrinh thathpi Yile ngay-ka murrinh pana ngarra kardu piyemanganu puru ngay-yu kardu darrikardu nanki thathpirr-yu. I da pangu-ka da mange nhini da matha piyemanganu puru-yu i parningingkabebenu parni nanhthi thade-re. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kardu-ka parramut ngay-yu kardu ngarra mere Jews. I kardu-ka pangagumugatnu i pungingkalkbelknu parni i pirangikampanu parni. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","I nhini thangunu-ka thu pumangirdarrirlarlarrnu parni thu whip-te. I nhini thangunu-ka thu pungibatnu i puddungirinuminu warda nhini-yu. Mu da perrkenkuneme mana pamanu-ka ngay-ka ngurdingkabirl-deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mu pulangay nukunu Jesus-ka mere pumemartadhaneme ngarra murrinh nhini mampirruneme-yu. Kardu-ka mere the-wa pumemabaththaneme murrinh nhini-yu mu pamamka-mana-wa-neme murrinh yibimkamnum. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bere Jesus i pulangay nukunu-ka manta warda purnedhaneme da nan-nu Jericho. Bere da pangu-ka kardu kamarrama dinidha ngarra ngurru ngarra mayern-yu kardu danintharrpudha kardi ku mani-nu panamutmutnu parni mi dhepdhep-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bere nukunu nhini-ka bimpirrayepup Jesus wunku kardu wurnangat wanku pubeyarrarrdha pardi. I mampirra kardu ngarra ngamere-ya, “Ya. Thangku kardu kumpan kanhi kathu-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","I pumamna, “Pana-ka nukunu Jesus kardu Nazareth-mawu wunku kardu wurnangat wanku kumpan pana kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bere kardu kamarrama nhini-ka dimnakay warda, “Jesus, kardu tharntethbath ngarra King David. Panhingamardathin ngadha i nangimanpinu,” mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mu kardu ngamere ngarra kumparra warra punnidha-ka pumamna, “Ya. Nadhap ngadha. Derrk da matha thi.” Mu nukunu nhini-ka puy deyida wangu dininakaykaydha lurruth da matha i menadha dini, “Ya. Kardu tharntethbath ngarra King David, panhingamardathin ngadha i nangimanpinu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bere Jesus-ka pirret i mampirra ngarra kardu ngamere, “Nga. Nukunu pana-ka numangaberti kathu.” Bere kardu-ka pumebertidha purni ngarra Jesus-nu warda. I Jesus kathu-ka mamna, ");
INSERT INTO mwf2018_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Thangku-nu? Mange ngarra-wa mampanu?” “Pule,” mamna. “Nangingkawathanu kamarl ngay patha ngurrubirlbirlnu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","I Jesus kathu-ka mamna, “Mampa-ya thurrubirlbirl warda. Nhinhi-ka thurrubirlbirlnu warda-ka nhini-ka murrinh ngarra ngay thangunu weyida namngabath kamarl pana manhingkawathanu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bere kardu kamarrama nhini-ka wurrinibirlbirldha warda i ngarra Yile neki warda daniriparldha wurrini i daniriwaktha warda wurrini ngarra Jesus-yu. I kardu wurnangat pana pubamkardu kardu nhini kamarl patha warda kardidha i ngarra Yile neki deyida wanku parraniriparldha purni. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bere Jesus i kardu wurnangat-ka purnidha da Jericho-nu wangu. I ngarra purnelilidhaneme i parramkaruyneme-ka puy punnalilidhaneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bere kardu nugarn numi kardidha pangu da i murrinh nukunu-ka nan-wa Zacchaeus. Nukunu-ka ku mani ngala da matha kanthidha kardi, i nukunu deyida kardu pule ngala-wa kardu pana ngarra ku mani pardinmatkuttha ngarra kardu kathu-yu ku mani dininmatkuttha ngarra kardu thangunu kathu ku Government ngala ngala-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bere nukunu Zacchaeus-ka marda merttha wurrini Jesus bangkardunu, mu nukunu-ka kardu ngaliweri-wa i mere ngarra bengkardudha nukunu-yu, nhini-ka kardu wurnangat deyida wanku parraningkawuptha purni ngarra nukunu-nu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bere nukunu Zacchaeus-ka kumparra warra ngarra kardu nawinhararttha dini i kanala ngarra thay ngala Jesus-nu bangkardunu kardu ngarra bakatnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","I bere Jesus-ka pangarntuy warda wurran ngarra thay nhini-yu i kangkarl mamnangka i mamna, “Zacchaeus. Mangini-re thurdithut kathu. Ngay-ka nginu ngadha ngarra da thelput nhinhi marra kanhi-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bere nukunu Zacchaeus-ka wurdanthut pirtpirt da matha i le warda dininadha ngarra Jesus-nu-yu i nungammardale ngarra thelput nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bere kardu wurnangat-ka pubampunkungkardunintha Jesus i Zacchaeus naninthadha dini pangu warda wangu i murrinh puddanangkakduktha pardi i pumenanudha pardi mange pigunu, “Nukunu Jesus-ka mere kurru i mere kinintha ngangka-yu kardu ngarra wiye pangu mani-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bere ngarra thelput nukunu mana-ka, Zacchaeus pirrimmardat kumparra warra ngarra Jesus-yu, i mamna, “Nga pule. Ngay-ka marrayerryerrnu nanhthi i ku mani ngay ngamere ngarra kardu mananhthi parnam. I kardu ngatha ku mani mampunkapdap-ka ngay-ka ku nhini-ka ngurdurrangkalathnu ngurru i ku mani ngamere deyida wanku ngarramutmutnu ngurru.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bere Jesus kathu-ka mamna, “Nga. Yile ngay-ka da mange wiye manhimayerrarrnu ngarra nhinhi i kardu ngarra darrikardu nhinhi wanku kardu ngarra thelput kanhi narnam-ya i mananthibirnunu warda. Nhinhi-ka kardu tharntethbath ngarra nukunu ngalantharr nhini Abraham. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngay, kardu ngarra darrikardu nanki thathpirr-ka kardu-nu ngurrurrakaykaynu kardu pana ngarra Yile ngay parnampart-yu i ngurdunkalathnu ngarra nukunu deyida wangu. Kardu nhini-ka kardu nginipunh parnawarrk mani-wa i ngay-ka manthibirnunu kardu nhini-yu.” Jesus kathu-yu mamna. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bere kardu pana ngarra thelput Zacchaeus nukunu-ka pubininayepuptha pirrini murrinh ngarra thathpi Jesus. I kardu-ka pamam mana-wa Yile neki-ka ku Pule ngala warda thathpirr pirranu ngarra nukunu-re Jesus paruynu ngarra da Jerusalem-yu. Nhini-ka da manta warda Jerusalem Jesus kardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mu Jesus-ka murrinh wurdampirrayith i mampirra, “Nga. Murrinh kanhi ngurdiyithnu-ka kardu pule ngala nungardurr da ngathparr-nu wangu, i da pangu-ka kardu-ka pubanpak kardu pule ngala thathpirr. I bere nhini thangunu nukunu wurdawurl deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Bere da ngarra manta warda punurdurrnu-ka nukunu-ka pirrimpirrukayneme kardu nugarn 10 ngarra wurlk pumenadhaneme parde i danirrumutmutthaneme ku $200. I mampirruneme, ‘Nga. Ku mani kanhi nekutkutneme i nanhthi peyim i thelim niyemanuneme nuru i puy nubangangkardurdununeme nuru ku mani ngala ngay-nu ngarra ngay-re nganirdumnu-yu da numi wangu-yu,’ mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mu kardu wurnangat da ngarra nhini-ka mere marda pumerttha puyi kardu pule ngala nhini-yu nhini-ka kardu ngamere deyida puddanpunthuk da ngarra nhini-nu-yu kardu pumerradha punni, ‘Mere nubupak nukun ku pule ngala kingarra nukun kardu ngarra nganki kardu kem kanhi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mu kardu-ka pubanpak ku pule thathpirr ngala dinidha-yu i nhini nukunu-ka wurdawurl da ngarra nukunu deyida wangu. “Bere nukunu-ka dimpirrukay-deyida-neme kardu 10 nhini-yu ngarra ku mani danirrumutmutthaneme dini-yu ku the mabathnu mani ngarra ku mani pumedhaneme parde. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bere kardu marra-re-ka mamna, ‘Pule, ngay ku mani bangampangkardurdu-ka ku $200 thangunu-ka ku mani ngala, ngay mammath ngem-ka ku $2,000-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I ku pule ngala nhini kathu-ka mamna, ‘Nhini-ka patha-wa nhini-yu. Nhinhi-ka wurlk patha da matha thardingadha nhini-yu. Nhinhi dangamngangkardurdu-ka ku mani ngala da matha ngarra ku mani kunungingki thangunu-yu. Nhini ngay-ka bunhipaknu ku pule ngala thirranu ngarra da town 10-ya.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Bere kardu numi warda kathu wurrininadha pangu i mamna, ‘Pule, ngay-ka bangampangkardurdu ku mani ngala deyida. Ngay nganthin ngem-ka ku $1,000-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bere ku pule ngala nhini kathu-ka mamna ngarra nukunu-yu, ‘Nhini-ka patha-wa. Ngay-ka bunhipaknu ku pule ngala thirranu ngarra da town 5-ya.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Bere nhini thangunu-ka kardu numi wurrininadha kathu i mamna, ‘Pule, ku mani nhinhi thamngamut-ka kanhi ku-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngay-ka panpewut ngarra kaligu i ngurdanpangath nhini ngay-ka ngemnhimanham da matha nhini-yu. Nhinhi-ka kardu tetemanthay-wa. Nhinhi-ka kardu nampunterda thanam kardu ngarra wurlk ngala parnampa nhinhi-yu i ku mani ngala warda thurrankutkut nhini-yu. Nhini ngay-ka mere warda bempangkardurdudha ku mani-yu nhini ngay-ka ngemnhimanham ku mani nangimart nukun ngarra ngay-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Bere ku pule nhini kathu-ka mamna, ‘Nhinhi-ka kardu wiye da matha mere murrinh nengabaththa ngay-yu. Nhinhi namnga-ka ngay-ka kardu tetemanthay nginim nawa, i nganampunmatkut kardu ku mani. Yu mampa-ya nhini da matha ngay mange mampanu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Thangku-dha ku mani ngay mere duyngardidha ngarra bank-yu? Nhini-ka ku mani kunungingki deyida dengangkardurdudha i thengamuttha wunku ku mani kanhi ngarra thamngamut-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Bere ku pule nhini-ka mampirruneme kardu ngarra ngamere nukunu-yu, ‘Nga. Numamartneme ku $200 ngarra nukunu-yu i nanamutneme kardu nugarn pangu wunku ku $2,000 kanthin dim.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mu kardu nhini kathu-ka pumamnaneme, ‘Ya pule. Nukunu-ka ku mani ngala wardarra kanthin dim nhini-ka thanamut kardu numi warda nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mu ku pule ngala nhini kathu-ka mampirruneme, ‘Nga. Kardu nangkal ngatha mabath ki nanhthi ngamere, nhini nukunu-ka bere ngatha wangu nanhthi terert kanikutkkut nhini-yu. Mu kardu nangkal ngatha mabath ki nanhthi kunungingki da matha-ka nhini kardu-ka ku mamart da matha nanhthi nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","I ngana deyida, kardu pana ngarra mere marda pumengerttha puyi ku pule ngala ngirranu, kardu-ka numanberti kathu nuru ngarra ngay kanhi,’ mampirruneme kardu ngarra nukunu-yu, ‘i nunthuknu i nudduntinuminuminu kumparra kanhi warra ngarra kamarl ngay.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bere murrinh nhini thangunu Jesus mampirra-ka, nukunu-ka kumparra warra nadha dini ngarra pulangay nukunu da Jerusalem-nu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bere da manta warda punnalilidhaneme da nan-nu warda-ya Bethphage i da Bethany i da palyirr nan-ya Olive. I bere Jesus-ka mampirrukaynintha kardu pulangay nukunu kardu perrkenku purdunkuthukninthanu kumparra warra. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ya penintha,” mampirrunintha. “Kumparra warra thununinthanu thi da ngarra town kunungingki pangu-yu. I ngarra thanintharuy-nu-ka ku tangki wakal daninthangkardunu pangu da mentharrk karrim. Mere nangkal ngadha kanirdarrilaladha ku nhini-yu. I thurdunintharerethnu nanhthi rup i ku-ka naninthabathnu warda kathu thurru ngarra ngay kanhi. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mu kardu ngatha murrinh kanhi manarruninthanu-ka, ‘Ya. Thangku-nu thurdannintharereth thanam ku pana-yu?’ Mu murrinh nankunintha-ka kanhi-wa numananinthanu-yu, ‘Nga. Pule ngankunintha-nu marda manganart ku kanhi-yu ku panirdarrilanu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Murrinh-ka nhini-wa Jesus-yu mampirrunintha yu, i bere wurdanpunkuthuk-warda-nintha kumparra warra ku tangki nhini-nu-yu. Bere penintha nhini-ka naninthadha warda dini i ku tangki wakal nhini-ka bangamninthardurt murrinh nginipunh nhini da mani Jesus mampirrunintha murrinh marra-re kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mu bere ngarra ku nhini-re wurdininintharereththa pirri-ka kardu ngamere ku ngarra tangki peneme-ka pumampirrunintha, “Ya penintha. Thangku-nu thurdannintharereth thanam ku pana-yu?” Parrampunkudharrpunintha. “Ku tangki ngankuneme-wa pana-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","I penintha kathu-ka mamnintha, “Awu, Pule ngankunintha marda manganart ku kanhi-yu panirdarrilanu.” I bere kardu nhini kathu-ka pumampirrunintha, “Yu, mampa-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bere wurdannintharereth thangunu-ka ku-ka meninthabaththa warda tharra ngarra Jesus-nu warda wangu-yu. I nanhthi kawut ngarra penintha-ka yingamninthardarriwup warda pangkin ngarra ku tangki, i mamninthamanpi warda Jesus-yu i kanarnarrila warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bere Jesus-ka pinthanhinganardarridha ngarra ku tangki nhini-yu da Jerusalem-nu warda wangu. I kardu-ka nanhthi kawut ngarra pigunu pardinaweweptha purni ngarra mayern pangu warra kumparra ngarra ku tangki wurrinililidha wunku Jesus pinthanhinganardarridha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bere puy wangu punnidha i puddanthut da palyirr nhini thangunu Olive i da-ka manta warda punnidha da Jerusalem-nu. Bere ngarra da nhini-ka kardu wurnangat pana ngarra Jesus parriniriwaktha purni-ka le patha thathpirr warda pardidha i parraniriparldha purni ngarra Yile neki wangu murrinh ngala da matha. Kardu nhini-ka pubemangkardudha purni Jesus-yu da mange ngala ngala nhini ngarra kardu merradha wurrini-yu i nhini weyida parraniriparldha purni Yile neki-yu. I murrinh mange pigunu ngatha pumenanudha purni, ");
INSERT INTO mwf2018_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ya. Mampa. Pariparl-warda-ngime kardu Pule ngala kanthim kanhi-nu-yu ngarra Yile neki kathu wurdannhethukngime kanhi-yu. Nekingime-ka marda pekpek thathpirr warda thamamnangime ngarra Yile neki wangu-yu. Mampa, pariparl-warda-ngime ngarra Yile neki wangu-yu.” Nhini-wa murrinh thathpi punnikaykaydha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bere kardu Pharisees ngamere ngarra kardu wurnangat nhini punnidha-ka murrinh pumamna ngarra Jesus, “Ya Pule. Kardu kanhi dunthapnu ngarra parramnhiriparl pumpan.” ");
INSERT INTO mwf2018_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mu Jesus kathu-ka mampirruneme ngarra kardu peneme nhini-yu, “Nga. Murrinh kanhi-ka murrinh thathpirr manarrunemenu-yu. Kardu kanhi ngatha bunthapnu i manangka murrinh ngatha purunu-ka nhini nanhthi palyirr purrkpurrk kanhi kurrankadhuk-ka purukaykaynu warda i pangiriparlnu warda puru ngay-yu,” mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bere Jesus-ka manta warda wurrinidha ngarra da Jerusalem-nu-yu i bamkardu da nhini-yu i dirrabaththa warda wurrini. I du warda wurrinikarrktha kardu ngarra da pangu-nu pardingkadhuktha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","I murrinh memnu murrinh marda-re, “Ngay-ka damngimardathin nanki-nu. Mu marra kanhi nanki-ka numenanabirldha ngarra Yile ngay mana-wa i marda pekpek numenabaththa mana-wa ngarra nukunu wangu-yu, mu wurda. Nhini nanki-ka mere thathpirr the numengibaththa ngay-yu, kardu-ka ngay da matha nukunu kathu wurdanngithuk-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mu da nakurlnu-wa kardu murlakpun purunarranu kathu da kanhi-yu pananpegatnu i pana ngangka-re panarradhawupnu i pubunankatmit-nu nanki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","I nhini-ka punnunanmirrnu i banantikerdeknu nhini-yu kardu wurnangat warda ngatha i mamay wanku-yu. I thelput ngarra nanki wanku pubunanmapeknu puru. Mange-ka nhini-wa pumanarranu puru nhini nanki-ka mere the numengibaththa ngay-yu nhini Yile ngay kathu wurdanngithuk kardu menanthibirnudha nanki-yu.” Murrinh nhini-wa Jesus mampirra murrinh marda-re kardu ngarra da Israel pardidha-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bere Jesus-ka kanardi warda ngarra murrinh church ngala pangu da Jerusalem i wurdanpunkarel warda kardu pana ngarra thelim pumedha pardi i peyim pumedha pardi ku yinpi ku thip i ku ngamere pangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","I merradha wurrini murrinh-yu, “Nga. Yile neki-ka kanhi-wa murrinh thathpi nukunu yibim-yu. ‘Thelput kanhi ngarra ngay-ka kardu-nu parningangerrennu ngarra ngay.’ Mu nanki-ka nubemkardurdu narnam kanhi ku mani-nu numampunkapdap narnam kardu ngarra terert thangunu kathu-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bere nhini thangunu Jesus-ka bere matha wangu kardu wurdininthethiththa kardi da pangu-yu ngarra da church ngala-yu. Mu bere ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law Jews pigunu puddininthethiththa punni-ka marda pumerttha punni Jesus thu pubatnu puddurinuminu, ");
INSERT INTO mwf2018_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mu kardu-ka pumenadalladalladha-wa punni ngarra-re Jesus thu pubatnu-yu nhini-ka kardu wurnangat-ka bere matha wangu pubinanayewuptha punni i marda pumerttha punni murrinh ngarra thathpi Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bere da numi ngadha ngarra nukunu-re Jesus wurdininthethiththa dini ngarra murrinh church ngala nhini ku yilarn ngala ngala thathpirr i kardu pule ngala ngala thathpirr punninadha. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","I murrinh pamamna, “Ya. Nhinhi-ka nangkal thangunu murrinh mampa kardu thurdanpunthethith thurran kardu kanhi-yu? Kardu pule ngala ngarra nimin wurdannhithuk da kanhi-yu?” Parrantharrpu kardu nhini kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","“Ngay-ka murrinh deyida nganantharrpunu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“Nukunu John the Baptist nganaka kardu pana ngarra kardu daninluluwewudha wurrini kura-re-ya? Yu nukunu da nangkal nimin thathpirr wurdanthuk-yu? Yile neki thangunu kama i kardu thangunu kama-ya? Ngarra nimin-yu? Murrinh mani numanganu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bere kardu nugarn nhini-ka puddanadharlurldha pi murrinh mange pigunu ngatha. “Murrinh kanhi ngatha pumananuneme Yile neki wurdanthuk nukunu John-yu, nhini nukunu Jesus-ka murrinh manhenemenu warda, ‘Mu thangku-dha murrinh mere numenabaththaneme-yu ngarra nukunu John the Baptist-yu?’ ");
INSERT INTO mwf2018_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","I ngana deyida murrinh kanhi ngatha pumananuneme kardu thangunu-wa nukunu John the Baptist wurdanthuk-yu nhini kardu wurnangat kanhi-ka thu palyirr pubanhiwelerrnu-warda-neme nhini kardu-ka pamam pumpan Yile neki wurdanthuk nukunu John the Baptist-yu.” Murrinh nginipunh nhini mani puddanadharlurldha pi-yu mange pigunu ngatha-yu mu kardu-ka murrinh pumenadalladalladha-wa-neme pe murrinh pumenadhaneme-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","“Yaa,” pumamna. “Nganki-ka mere the ngumabath nangkal nimin wurdanthuk nukunu John the Baptist-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mu Jesus kathu-ka mampirra, “Yu, bere-ya. Nhini-ka ngay-ka mere deyida manarra nukun nhini-yu nangkal ngay wurdanngithuk-yu i mange kanhi-nu ngamam ngurran-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bere nhini thangunu Jesus-ka murrinh warda mampirra ngarra kardu murrinh yibimkamnum-ya. “Yu bere, kardu pule ngala mi grape bebirrbirrdha wurrini ngarra mi kadin nukunu. Bere nhini thangunu-ka kardu ngamere pirrimpirrukayneme mi ngarra kadin nukunu piranapenemenu parne. I murrinh mampirruneme, ‘Nga peneme. Mi ngarra grape-te thungku pebaynu-ka numuberartalnemenu i mi warda numangayerryerrnuneme nhini-yu.’ Bere nhini thangunu-ka kardu pule nhini-ka kanampart nungardurr warda mi kadin nhini-yu i da ngamengka-nu warda wangu nadha dini i da pirdithme da matha kardidha pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Bere da nakurl-te ngarra mi grape nhini-re demmay-ka kardu pule nhini-ka wurdanthuk kardu nugarn numi mi pumanayerrnemenu kardu pangu ngarra mi kadin nukunu piranapedhaneme parde. Mu peneme nhini-ka pumangankartaneme i punnebatthaneme parde kardu nhini ngarra kardu pule wurdanthuk-ka i puddankathukneme pangu deyida wangu i mi-ka grape-ka mami-wa nayeymadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Bere nhini thangunu-ka kardu pule nhini-ka kardu numi deyida kathu wurdanthuk mi grape deyida-nu pumanayerrnemenu. Mu peneme nhini kathu-ka punnebatthaneme parde i mange wirritmarnti pardenadhaneme kardu nhini-yu i puddankathuk-deyida-neme pangu wangu i mi-ka mami-wa nayeymadha dini. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I nhini thangunu-ka kardu nugarn numi deyida kathu wurdanthuk mi grape deyida-nu pumanayerrnemenu. Mu peneme nhini kathu-ka yidingurr ngala parramnamutneme i punnungamkakuneme ngarra mi kadin thangunu kathu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“‘Ngarra ngamanu warda ngay-yu?’ Kardu pule nhini memnu mange nukunu. ‘Aa, the nganthin warda. Wakal nugarn ngay pangu ngurduthuknu. Nukunu-ka marda thathpirr manganart ngurran i nhini kama murlmurl penanuneme-yu i mi panamutnuneme-yu.’ “Bere kardu pule nhini-ka wurdanpirruthuk-warda-neme wakal nukunu ngarra peneme nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mu peneme nhini ngarra nukunu-re pubamkangkarduneme-ka murrinh pumemnungkuneme mange peneme, ‘Nga, nhini da kunungam kem wakal nukunu thathpirr kardu pule-yu. Ngarra yile nukunu-re pupupnu-ka nukunu warda mi kadin kanhi-yu martnu i mabathnu pi-yu. Mu nga, ka. Purru-wa-neme i thu pubatnemenu pangu da i nekineme warda mi kadin kanhi-yu pumartnemenu-yu i pumabathnemenu pi-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bere pumangankartaneme wakal nukunu kardu pule nhini-yu i punnungamkakuneme pangu wangu outside ngarra mi kadin-yu i thu pumpankabatneme i puddankarinumi-warda-neme nhini-yu. “Nga. Ngarra mana warda mange nhini-yu marrunemenu kardu pule ngala-yu ngarra kardu peneme pana ngarra wakal nukunu thu pumpankabatneme-yu?” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Yu, kardu pule-ka purdiwurlnu i thu punkuthuknu-warda-neme i purdunkurinuminuminemenu warda peneme nhini-yu. I kardu ngamere deyida pirrarrukaynuneme mi ngarra kadin nukunu piranapenemenu parne-yu.” Bere kardu-ka pubimnayepup murrinh nhini-yu i pumamna warda, “Awu wurda, mange mere nginipunh nhini mani.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bere Jesus-ka bampunkardu ngarra kardu i mampirra warda, “Nga. Thangku murrinh kanhi-nu-yu? Kanhi-ka murrinh thathpi pule ngala Kangkarlmawu nukunu parrarntilil da murntak warra-yu. ‘Kardu nugarn pana ngarra thelput pubengkardadha punni nanhthi palyirr-te nanhthi palyirr numi punnungamku nhini-ka nanhthi wiye mana-wa pamam. Mu marra kanhi nanhthi palyirr ngala nhini-ka tetemam warda pirrim ngarra thelput nhini-yu. I da thelput nhini-ka yuthpan warda pirrim nanhthi palyirr nhini thangunu-yu. I Yile neki banpak nanhthi palyirr nhini-yu.’ ");
INSERT INTO mwf2018_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nga.” Jesus kathu-yu mampirra deyida. “Kardu nangkal ngatha bamengkatnu ngarra palyirr nhini-ka nukunu nhini-ka buydhanmertal-wa nhini-yu. I nanhthi palyirr nhini ngatha kaniyegarl ngarra kardu nhini-ka bamerl da matha nhini-yu,” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bere ku yilarn ngala ngala thathpirr i kardu pana ngarra murrinh law Jews pigunu puddininthethiththa punni-ka pumanganmarta murrinh nhini-yu ngarra kardu pule ngala i mi kadin nukunu murrinh ngarra Jesus wurdampirrayith-yu. I nhini-ka parramnarithi warda i pumertadha-wa. Mu kardu-ka perrempunmanham kardu wurnangat i nhini-ka parnampart warda Jesus-yu i puy punnidha pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bere kardu peneme pana ngarra Jesus wurdanpunkuyithneme-ka bere matha wangu pirangkadhaneme parde ngarra Jesus. I puddanpunkuthukneme kardu wiyenpun ngamere Jesus-nu pumapulangaynuneme. I kardu nhini-ka murrinh thathpi peneme-re perrenakthuktha-mana-wa-neme ngarra Jesus murrinh merdarrithaktha ngarra kardu pule ngala wangu-ya i nhini-ka ku soldier ngarra nukunu pumartanemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bere kardu nhini-ka pumamnaneme ngarra Jesus, “Ya pule. Ngankuneme-ka the-wa nganthinnhineme murrinh thathpirr-wa thurdanpirrayith thurran-yu ngarra kardu wurnangat warda ngatha i kardu pule ngala ngala wanku. I nhinhi-ka da mange ngarra Yile neki murrinh thathpirr thurdanpunthethith thurran. Mu ngarra-re murrinh law nekineme pirrim-yu? ");
INSERT INTO mwf2018_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mange-ka yuthpan ku mani-yu nganamutmut nguru ngarra kardu pule ngala-yu ngarra ku Government-yu nukunu Caesar-yu? Mange nhini-ka yuthpan kama i mange wiye kama?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mu nukunu Jesus-ka the menkumabaththaneme dini murrinh pangu pumenadhaneme pe-yu murrinh perrenakthuktha-mana-wa-neme i murrinh merdarrithaktha mana-wa ngarra pule ngala Caesar. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nhini-ka Jesus kathu-ka mampirruneme, “Ku mani silver mani kathu nangamutneme. Nangkal pelpith kanhi ngarra nanhthi mani silver kanhi-yu?” Jesus kathu-yu dampunkudharrpuneme. “I nangkal murrinh nukunu yibim-yu?” “Pana-ka pelpith nukunu kardu pule ngala ngarra ku Government nukunu-wa Caesar. I murrinh nukunu deyida wanku kabim pana-yu,” pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mu Jesus kathu-ka mampirruneme, “Ku mani kanhi ku nukunu ngatha Caesar-ka nhini-ka nuddunangkarl pangu deyida wangu ngarra Caesar. I nanhthi pana deyida ngarra Yile neki nukunu-ka nhini-ka nuddunangkarlnu pangu deyida wangu ngarra nukunu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bere kardu nhini-ka mere perrenakthukthaneme murrinh thathpi peneme-re i ngarra kardu wurnangat-te pangu da pidha. Mu kardu-ka pumemnamardat-warda-neme ngarra murrinh Kangkarlmawu mampirruneme-yu i kardu manangka murrinh pedhaneme pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bere nhini thangunu kardu ngamere kardu nan-ya Sadducees punninadha ngarra Jesus. Kardu nhini-ka murrinh puddininthethiththa punni-ka kardu ngarra punniwuwuptha-ka mere deyida nginipunh puddingkarlbirlnu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bere kardu nhini kardu Sadducees-ka murrinh warda pumamna ngarra Jesus murrinh perrunathuktha mana-wa, “Ya pule. Kanhi-wa murrinh law ngarra nukunu Moses dannherililneme da murntak warra-yu, ‘Kardu nugarn ngatha kupup-ka i palngun nukunu kanampart i kardu manangka wakal da ngatha, nhini-ka ngathan nukunu kathu warda mabert i benginthalet kardu palngun nhini-yu i nukunu-ka kardu wakal yingammapup warda kardu palngun nhini-yu ngathan nukunu nukun-yu.’” Nhini-wa murrinh law Moses darntilil-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","I kardu nhini-ka murrinh deyida pumamna ngarra Jesus, “Nga. Murrinh kanhi nguddimpayithnu. Kardu-ka 7-wa ngathan ngathan-yu. I bere ngathan kumparra warra ngadha manganmert i bemnginthalet kardu palngun-yu. I kardinginthadha i yibimpup kardu nugarn nhini i manangka wakal. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","I nhini thangunu-ka kardu ngathan numi deyida manganmert i bemnginthalet kardu palngun nhini-yu, kardinginthadha i yibimpup deyida kardu ngathan nhini i manangka wakal da ngatha. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nhini thangunu-ka kardu ngathan numi deyida manganmert i bemnginthalet kardu palngun nhini-yu, kardinginthadha i yibimpup deyida kardu ngathan nhini-yu i manangka wakal da ngatha. I mange-ka nginipunh nhini mani-wa pumedha punni-yu ngathan ngathan ngamere nhini-yu i wakal-ka manangka wakal da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bere nhini thangunu ngarra pirriniwuwuptha-ka kardu palngun nhini deyida wanku yibimpup.” Nhini-wa murrinh Jesus puddamnayith-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","I pumamna deyida, “Mu nga pule. Da nakurlnu da ngala ngarra nhini-re kardu ngarra wurnangat-te puddingkarlbirlnu-ka kardu ngathan ngarra nimin nangkun nigunu thathpirr warda-yu kardu palngun nhini pingenu-yu da nhini-re-yu? Nhini nigunu-ka nangkun nigunu-ka 7-wa menkadhuktha kardi-yu da ngarra putek kanhi-yu,” parrantharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mu Jesus kathu-ka mampirra, “Kardu wurnangat pana ngarra birnu parnam-ka nugarn i palngun pubemlet pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mu nga. Kardu pathanpun pana ngarra Yile neki da nakurlnu purdunkarlbirlnu-ka kardu nhini-ka nugarn i palngun mere ngarra deyida benginthalet da ngarra nhini-re-yu, wurda. I kardu mere nangkal deyida bayenu kardu palngun i nugarn da nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mu kardu nhini-ka puyemanu puru ku nginipunh angel mani-ya i mere deyida puyuwuwupnu. Kardu nhini-ka kardu ngarra Yile neki nukunu nhini nukunu-ka purdunkarlbirlnu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“I ngana deyida nukunu Moses wurdanayiththa wurrini da murntak warra-yu murrinh ngarra kardu puddingkarlbirl-deyida-nu. Nukunu wurdanayiththa wurrini nganaka ngarra thay nhini puniwemaththa pirri. I kanhi-wa mam murrinh-yu, ‘Yile neki-ka ku Pule ngala thathpirr. I nukunu-ka ku Pule dimpirruneme kardu ngalantharr murntak kardu nan Abraham, Isaac i nukunu nan Jacob.’ Nhini-wa murrinh mam Moses-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","I ngarra murrinh nhini-re mam Moses-ka kardu ngalantharr murntak nhini-ka pirrinewuwuptha-wardarra-neme nhini-yu, mu kardu-ka birnu da ngatha thathpirr da nhini-re-yu i Yile neki-ka ku Pule da ngatha dimpirruneme ngarra peneme nhini-yu. Yile neki-ka ku Pule dimpirra ngarra kardu wurnangat warda ngatha kardu ngarra birnu da matha parnam ngarra puddamkabirl-ya. Nukunu-ka mere Pule ngala ngarra kardu punniwuwuptha-yu, wurda.” Jesus kathu-yu mampirra. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bere kardu nugarn pana ngarra murrinh law Moses nukunu puddinithethiththa punni-ka pumamna warda ngarra Jesus, “Pule, murrinh pana ngarra nampirruneme-ka murrinh patha da matha.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bere nhini thangunu kardu-ka perremmanham warda murrinh deyida-nu perradharrpudha-yu nukunu Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Bere Jesus-ka murrinh numi deyida mampirra, “Nga. Kardu ngamere pamam pumpan-ka murrinh kanhi, ‘Nukunu Christ-ka kardu darntethbath ngarra nukunu ngalantharr murntak thangunu King David-ya.’ Nhini-wa pamam pumpan-yu. Mu thangku-nu murrinh nhini-yu pamam pumpan-yu?” Jesus kathu-yu dampuntharrpu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Nga. Da murntak warra nukunu David darntilil murrinh thathpi Yile neki nukunu. I murrinh nhini-ka kanhi-wa, ‘Yile neki murrinh mamna ngarra ku pule ngay.’ I murrinh-ka kanhi-wa, ‘Nhinhi-ka kanhi-re thinu ngarra ngay batbat-te i kardu pule ngala deyida wanku thinu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","I kardu pana ngarra mere marda kumanhert kuru nhini ngay-ka mankunungingkinu i ngay-ka bunhipaknu ku pule ngala warda thirranu ngarra kardu nhini-yu.’ Nhini-wa murrinh David darntilil-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","I Jesus kathu-ka mampirra deyida, “Nukunu King David-ka ‘Pule’ menadha wurrini kardu Christ-yu. Mu ngarra-re nukunu Christ-yu kardu darntethbath ngarra David thangunu-yu?” Murrinh Jesus kathu-yu dampunkudharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bere ngarra kardu terert-te pubinanayepuptha pirrini ngarra Jesus, nukunu-ka mampirruneme ngarra pulangay nukunu, ");
INSERT INTO mwf2018_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nga peneme. Thawath wangu nunnurraneme kardu nugarn pana ngarra murrinh law puddanpunthethith pumpan-yu. Kardu nhini-ka marda pumangannanart pumpan kardu pule ngala da matha nubankardunu i nantiparlnu nuru i ‘Pule’ numarranu nuru. I nhini weyida nanhthi kaligu pangkuy nanhthi patha pubardurdi pumpan i pumpannilili pana ngangka-re ngarra kardu wurnangat pirrimkadhuk-ya. I ngana deyida ngarra da church mana parnardi-ka nhini-ka ngarra da chair patha da matha ngarra kardu pule ngala ngala nukun parnapup-ya. I ngana deyida ngarra kardu wurnangat-te puyemperr pirrim mi dhepdhep-nu-ka nhini-ka le-wa parnam ngarra da chair patha deyida parnawup ngarra kardu pule ngala ngala nukunu-ya. Nhini-wa mange-yu le pumpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“I ngana deyida kardu nhini-ka mere kiranpe karni kardu palngun mekmunurr. Mu nanhthi purrkpurrk i ku mani pigunu parnampunmatkut parnam. I ngana deyida pumemnurart pumpan nginipunh kardu patha mani, nhini-ka murrinh pirdithme parnamnangerren ngarra Yile neki. Nhini-wa mange-yu kardu nhini le parnamkaneme-yu. Mu Yile neki-ka mere marda manart kurru mange pana ngarra pumenthart pumpan da ngarra mange nukunu parrarntiwak mana pumpan-yu, nhini-ka da nakurl-te purdunkartelnu thathpirr kardu nhini-yu.” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bere Jesus-ka dinidha ngarra murrinh church ngala nhini manta ngangka da ngarra nanhthi box ngarra kardu ku mani pubunimardardurdidha pi Yile neki nukunu. Bere kangkarl mamka i bampunkardu kardu pana wunku ku mani ngala wanku pubunimardardurdidha pi ku mani-yu ngarra nanhthi box nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","I bamkardu deyida kardu palngun mekmunurr warda kathu wurrinidha wunku ku mani kunungingki wanku. I nigunu-ka kanammardawu ku five cent perrkenku ngarra nanhthi box nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bere nhini thangunu-ka Jesus mampirruneme ngarra pulangay nukunu, “Nga peneme. Kanhi-ka murrinh thathpirr-wa manarrunemenu kanhi-yu. Kardu mekmunurr kurran pangu ku mani ngala thathpirr kanammardawu-yu ngarra nanhthi box pana-yu, ku-ka dimpunpewal ngarra kardu ngamere-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mu kardu pangu kibim-ka ku mani ngarra pumarntimut thangunu pimardathpuththa-yu, mu kardu palngun mekmunurr pangu-ka nanhthi pangu banmardardi nanhthi-ka nanhthi bere matha mebaththa kardi-yu, i nhini-ka nanhthi-ka mananhthi warda mi-nu-yu,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bere Jesus i pulangay nukunu-ka da ngarra outside pedhaneme da church ngala nhini kardu Jews pigunu i pulangay nukunu-ka mange peneme da matha pumemnungkuneme, “Nga. Da church ngala kanhi-ka da-ka patha-wa nawa? Kardu-ka pubuniwakpaktha punni nanhthi palyirr lelunh nawa? I kardu ngamere deyida wanku nanhthi patha patha parrammut da thelput ngala kanhi-nu Yile neki nukunu.” Mu Jesus kathu-ka mampirruneme, ");
INSERT INTO mwf2018_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nga. Da church ngala kanhi ngarra nubamkangkarduneme nirrimka-ka da nakurl-nu-wa kardu-re thu kuy puyimpurrnu puru palyirr terert kanhi-yu. I nanhthi palyirr ngala ngala kanhi-ka da pana ngangka-re buymardarrurrnu purru.” ");
INSERT INTO mwf2018_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bere pulangay Jesus nukunu-ka pumamnaneme, “Ya pule. Minthire kardu thu kuy puyimpurrnu puru-yu da church ngala kanhi-yu? I ngarra-re-wa kardu ngankuneme the ngumabathnuneme-yu da ngarra manta warda da nhini-re puyimpurrnu puru-yu? I ngana deyida ngarra-re the ngumabathnuneme-yu da putek kanhi panirikerdeknu-yu i minthire nhinhi thurdiwurlnu kathu-yu?” Parramkadharrpuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mu Jesus kathu-ka mampirruneme, “Nga peneme. Nankuneme-ka thawath wangu nanemenu karda pana ngarra murrinh thirrukduk panarrayirrarartnu-yu. Nga, kardu nugarn wurnangat warda kathu purunu nhini-yu i murrinh panarrayirrarartnu parni nginipunh murrinh kanhi mani-ya pumanarranu-ya, ‘Ngay-ka Christ-wa. I Yile neki wurdanngithuk ngay-yu. Da putek kanhi-ka da manta warda panirikerdeknu i ngay da matha mananthibirnunu-yu.’ Mu mere nubirrayepup nukun kardu nhini-yu i mere nukun narntiwak nuru. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“I nanki-ka nuyurrayepupnu kardu wurnangat thu kuy ngala puyithuknu puru thu kuy terert da matha. Mu nanki-ka mere nenham nukun da nhini-re-yu mange-ka nginipunh nhini mani-wa piyemanu puru-yu. Mu da putek kanhi-ka mere da ngatha panirikerdeknu da nhini-re-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kardu wurnangat warda pumethanu puru da ngamengka da numi numi deyida wangu. I kardu pule ngala ngala i kardu ngarra peneme ngatha pumethanu puru-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","I da putek-ka purrurangkaltangkalnu da pana-re-ya. I kardu wurnangat-ka mi dhepdhep-ka mami parninu i matharr ngala parninu. I nubangkardunu nanhthi punkarlparlnu da kangkarl kathu-yu pamanu purru i kardu-ka punkawerrnu warda pani ngala da matha. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mu nga. Da marra-re warra ngadha-ka kardu-ka purunanngawurtnu i da tetemanthay da matha panarramutnu nhini-ka ngay thangunu weyida narramngiriwak numpan nhini-yu. I kardu-ka pumananbertinu puru ngarra murrinh court wangu ngarra murrinh church-ya i pubunannurdinu ngarra jail. I ngana deyida kumparra pangu warra pubunanpaknu ngarra kardu pule ngala ngala nhini-ka ngay thangunu weyida marda numanganngert numpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","I da nhini-nu-re-ka murrinh nuddurrayithnu ngarra murrinh ngay-yu murrinh ngarra mange patha patha menarradha ngurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mu mere numenumardawerr nukun murrinh numarranu-yu ngarra kardu pule ngala ngala wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mu ngay-ka murrinh nganarramutnu murrinh thathpi mukmuk ngarra kardu pule ngala ngala nhini-nu numarranu-yu. I nanki-ka murrinh numunwilnu ngarra kardu nhini-yu, i kardu-ka mere ngarra pananthartnu ngarra nanki-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“I kardu darrikardu nanki ngatha yida pubunanpaknu kumparra pangu warra ngarra kardu pule ngala ngala nhini-yu. Kardu yileyile i kalekale i kardu ngathan i pulangay wanku paninanpirrnu. I kardu pule ngala ngala nhini-ka thu warda punanthuknu-yu puddunantinuminuminu-yu kardu ngamere da matha nanki. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yu, kardu darrikardu nanki i kardu wurnangat deyida wanku mere marda pumananartnu-yu nhini-ka ngarra ngay thangunu weyida marda numanganngert numpan nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mu kardu mere nenham nukun nhini-ka Yile ngay-ka bere matha wangu manannarnanu purru nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mu kardu lurruth da matha nurunu i ngarra ngay da matha nuddungayemitnu nuru i nhini-ka kardu bere matha wangu birnu narninu da kangkarl wangu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Ngarra nanki-re nubankardunu kardu murlakpun pawegatnu da Jerusalem-ka, nhini nanki-ka the warda numabathnu da-ka manta warda ngarra kardu pangu pantikerdeknu-yu i thelput wanku pubunmapeknu puru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","I da nhini-nu-re-ka nanki ngarra da Judea narnam-ka pirtpirt da matha nunnuwinhartnu ngarra da palyirr da ngathparr wangu-yu. I kardu ngamere nanki deyida wanku ngarra da Jerusalem narnam-ka nunnuwinhart-deyida-nu i pangu da narninu ngadha ngarra da palyirr. I nanki ngarra da puth narnam-ka mere nuru nukun da ngarra Jerusalem wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Da nhini-re-ka da wiye nimin pirranu-ya kardu Jews nukunu-yu. Nhini kardu-ka parnampart warda Yile ngay i nhini-ka kardu wurnangat nimin-ya puruwuwupnu i nhini-ka murrinh thathpi ngarra Yile ngay nukunu da murntak warra parrarntilil-ka murrinh thathpirr warda pirranu da nhini-re-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I da nhini-re-ka da-ka tetemanthay-wa pubardurtnu kardu palngun-yu kardu ngarra putput purunu-yu i kardu palngun pana ngarra kardu mamay punthaygurduknu puru ngapurlu. Palngun thingarru. I kardu wurnangat warda ngatha ngarra da putek kanhi-ka panmardathinnu ngala da matha da nhini-re-yu. I da-ka tetemanthay nimin-ya pubardurtnu kardu Jews wurnangat warda ngatha-nu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“I kardu murlakpun nhini-ka kardu wurnangat nimin-ya punthuknu i pantikerdeknu thu sword-te. I kardu wurnangat ngamere-ka pumanbertinu puru da ngamengka wangu i pubunnurdinu puru ngarra jail-yu. I kardu murlakpun nhini kardu mere Jews-ya ngarra Jerusalem da ngatha parninu i ngarra Yile ngay da mana murrinh marranu ‘Nurunu warda.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Ngay-ka ngurdiwurl-deyida-nu kathu ngarra da putek ngala kanhi. Mu da marra-re-ka nanhthi ngunga, merrk i pilinh-ka mere kirra nukun nginipunh marra kanhi mani karrim kanhi. Mu nanhthi-ka pirangkaltangkalnu warda nhini-yu. I da pangu ngarra nanhthi lalingkin-ka nanhthi ngurntinh ngala ngala pimerrmerrnu. I kardu wurnangat nimin-ya da pana ngangka-re punkawerrnu pani ngala da matha i pubuywathnu puru i manmerlmerlnu i penhamnu ngala da matha. I kardu mere the pumabathnu puru kardu punkarithpurrnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“I da nhini thangunu kardu-ka pubangingkardunu ngay kardu darrikardu nanki thathpirr ngurrunu kathu ngarra kalakkalak ngurrurdarrirdurdinu kathu. I pubangingkardunu kardu Pule ngala thathpirr warda ngurrunu nhini-yu wunku nanhthi lurruth ngala i ngay da matha warda pangirlarrangnu purru-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mu nga. Ngarra nanki-re nubangkardunu da terert nhini pamanu purru-ka nhini-ka kangkarl numangkanu i ngay-nu manankulkulnu pi ngurrunu kathu-yu. I ngana deyida da-ka manta warda ngarra Yile ngay mananthibirnunu-yu da ngarra nhini thangunu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bere Jesus-ka murrinh warda wurdampirrayithneme murrinh yibimkamnum-ya i mampirruneme, “Nanki-ka the mana nanthin nawa da ngarra mange ngarra thay wangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nanhthi marlanpakpak ngarra thay pangarntuy warda-ka nhini-ka the numabath da thangku-ka manta warda nhini-yu, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","I mange nginipunh nhini deyida mani-ya ngarra nanki-re nubangkardunu nanhthi kangkarl nhini pamanu purru-ka nhini-ka the numabathnu da-ka manta warda ngay ngurdiwurlnu da putek ngala kanhi-yu i Yile ngay-ka ku Pule ngala thathpirr warda pinu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nga, murrinh thathpirr kanhi-yu. Thu kuy ngala nhini i da terert nhini ngarra ngay ngurdininarruyiththaneme ngini-ka da nhini-ka panarraruynu ngarra kardu wurnangat kanhi-re kardu birnu da ngatha numpan-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Da putek ngala kanhi-yu nanhthi ngunga, merrk i pilinh-ka nanhthi mananhthi-nu warda i manangka da-nu warda panirikerdek-da-nu matha. Mu murrinh thathpi ngarra ngay-ka mere ngarra nukun kanirikerdek, wurda. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nanki-ka mere the numabath ngarra ngay deyida kathu ngurdiwurlnu-yu nhini-ka ngay-nu da matha manankulkulnu pi-yu. I thawath wangu nurunu i mere nukun numenumardawerrnu nanhthi purrpurrk-nu-yu ku mani-nu-yu i mere nurumurrk bere matha wangu mi dhepdhep terert-yu i mere nurugurdugurduk bere matha wangu kura murlak-yu. Mu mange nginipunh nhini mani niyemanu nuru-ka nhini-ka nuyungiyekumnu warda nhini-yu i mere nukun warda manankulkul kani ngarra ngay-re ngurrunu kathu-yu. I ngarra ngay-re ngurrunu kathu-ka nhini-ka nubengingkabatnu warda nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","I ngarra ngay-re ngurrunu kathu da ngarra putek ngala kanhi-ka kardu wurnangat warda ngatha pubangingkardunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nhini nanki-ka niranginikatnu i nuyungabirlbirlnu i manankulkulnu pi ngay-nu-yu. Mu Yile ngay nadharrpunu mananlurruthnu ngarra da tetemanthay nhini-nu-yu i nadharrpu deyida-nu manannarnanu pi-yu i nhini nanki-ka nuyunu marda ngala warda ngarra ngay kardu darrikardu nanki thathpirr ngarra ngay-re ngurdiwurl-deyida-nu kathu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bere Jesus-ka kardu bere matha wangu wurdininthethiththa kardi kardu wurnangat-yu ngarra da church ngala kardu Jews pigunu-yu. I da thipinhi mana-ka nukunu-ka pirriwat ngarra da palyirr nhini nan Olive i kardirrit da pangu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","I da thipinhire puningkapurl-ka kardu puyenawerr punni ngarra da church nhini-yu murrinh pubinayepupnu murrinh thathpi Jesus nukunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bere kardu Jews-ka pubenangkardurdu punni da Jerusalem pangu-yu da thangku terert-yu. I mi-ka pulleth mi lawam werlpen. I da-ka nhini murrinh-ka da nan-wa Passover. Bere da-ka da nhini-wa i kardu wurnangat nimin-ya pubemkardurdu warda da Passover-nu-ya. Bere da-ka manta warda mange ngarra punniret warda-yu da Passover nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bere da nhini-re-ka ku yilarn ngala ngala i kardu nugarn pana ngarra murrinh law kardu Jews pigunu puddininthethiththa punni-ka murrinh dederrk-te puddanayiththa punni ngarra-re nukunu Jesus pumartanu-yu i thu pubatnu i puddurinuminu-yu. Mu kardu nugarn nhini-ka perrempunmanham kardu wurnangat pana ngarra murrinh thathpi Jesus nukunu pubinanayewuptha pardi, nhini-ka thu nukun kunthuknu nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bere nhini thangunu-ka ku karrath kanamnginirdi nukunu Judas Iscariot kardu pulangay nukunu Jesus kardu 12-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I nukunu nhini-ka kanampunkupart-warda-neme i wurrirradha ngarra ku yilarn ngala ngala i kardu nugarn pana ngarra da church ngala pirapedhaneme parde murrinh dederrk-nu marrunemenu ngarra-re nukunu mankumanpinemenu-yu Jesus pumartanemenu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bere murrinh pubimnayepup-thangunu-neme nukunu Judas-ka, peneme-ka le warda pardedhaneme nhini-yu. I pumamnaneme ku mani panamutnuneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I nukunu Judas-ka le deyida kardidha ku mani panamutnemenu da nakurlnu i nhini nukunu-ka dirrangkadha wurrini da ngarra kardu terert makardu-nu thathpirr ngarra Jesus-yu i nhini-ka pirrarrakaynu warda ku yilarn ngala ngala nhini-yu kardu warda pumartanu Jesus-yu i pumabertinu puru pangu warda wangu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bere da ngala nhini da Passover-ka da-ka pangarntuy warda nhini-yu. I kardu-ka mi lawam werlpen pardimurrktha i ku warda purninthuktha ku thip-ya ku dhepdhep-nu da ngarra ngala nhini-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bere Jesus-ka kardu pulangay nukunu kardu perrkenku Peter i John mampirrukaynintha i mampirrunintha, “Penintha. Thununinthanu thi pangu wangu i ku thip i mi dhepdhep warra numanhewathawathanemenu mi pullathnemenu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Ngarra-wa da-yu mi i ku maninthawathawathanu-yu?” Damninthadharrpu penintha kathu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“Nga.” Jesus kathu-yu mampirrunintha. “Thununinthanu thi pangu da nan Jerusalem. I da pangu da kardu nugarn banankumardabininthanu nanhthi pot kura patha wanku piwepupnu purru ngarra pelpith nukunu-yu. I nhini thangunu-ka thaninthariwaknu thurru i pangu da mana ngarra thelput paniridinu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","I murrinh-ka kanhi-wa numananinthanu kardu ngarra pule ngala thelput nhini nukunu-yu, ‘Ya. Kardu Pule ngankunintha wurdanngankuthuknintha kanhi-yu. I nukunu-ka mam, “Ngarra da ngay-yu ngarra da mi ngulathnu mi Passover-yu wunku pulangay ngay wanku mi lawam werlpen i ku ngen ngullathnemenu-yu?”’ ");
INSERT INTO mwf2018_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I nhini thangunu kardu nhini-ka panankumardawithnunintha i panarrungkardanunintha da nhini-yu ngarra thelput kangkarl nhini-yu. I nanhthi table i nanhthi chair wanku ngarra da ngala nhini-yu pingkadhuknu-yu. I nhini da da-yu ngarra mi naninthawathawathanu-yu mi lawam werlpen i ku thip ku ngen nekineme-nu-yu.” Nhini-wa murrinh-yu ngarra Jesus mampirrunintha-yu i wurdanpunkuthuk-warda-nintha. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bere penintha nhini-ka pangu warda wangu naninthadha dini da Jerusalem-nu warda wangu i ngarra bangamninthardurt da mana i pangamnaruynintha kardu nugarn nhini-yu i da ngarra thelput wanku. I murrinh-ka nginipunh nhini da matha mani ngarra Jesus mampirrunintha-yu. I pangu da mi warda mamninthawathawatha mi lawam werlpen i ku ngen-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bere da ngunga kanarnum warda nhini-yu, Jesus i pulangay nukunu ku apostle-ya parramkaruy-warda-neme ngarra da thelput nhini-yu i parnamkardi-warda-neme i parnamkawupneme mi-nu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bere nukunu Jesus kathu-ka mampirruneme, “Nga peneme. Ngay-ka marda merttha ngurrini mi dhepdhep mi Passover kanhi-ya pulathnemenu mitmit. I mi kanhi thangunu-ka kardu thu pungibatnu warda. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","I nga. Ngarra mi kanhi-re ngarikerdeknu-ka ngay-ka mere deyida mi mangini kanhi mani ngulathnu-yu i ngarra mi marra da mana ngulathnu pangu wangu da ngarra Yile ngay nukunu, da nhini-nu-re ngarra Yile ngay ku Pule ngala thathpirr pinu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bere nukunu-ka nanhthi kap warda manganart dim kura wine wanku i Yile nukunu darntiparl kura nhini-nu-yu. I mampirru-deyida-neme, “Nga peneme. Nenumanemenu kura kanhi i nubagurduknemenu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mu ngay-ka mere deyida bagurduknu kura mi kakpa nginipunh kanhi mani-yu, mu ngarra Yile ngay da mana ku Pule ngala thathpirr pinu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bere nhini thangunu-ka mi lawam werlpen warda manganart dim i Yile nukunu deyida darntiparl mi nhini-nu-yu i munirrurerrarrdhaneme dini i dampirrumutmutneme. I mampirruneme, “Nga peneme. Mi kanhi-ka nginipunh ngay-wa. Ngay-ka ngunarrupupnemenu nankuneme-nu. I mange kanhi-ka da bere matha wangu nuyemanemenu nuru i nuddungiyelerrnemenu nuru ngarra ngay mi kanhi thangunu ngarra ngamnarrumutneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bere ngarra mi thangunu parramkarikerdekneme-ka Jesus-ka mange nginipunh nhini da ngatha mani manganart dim nanhthi kap kura wine wanku. I mampirru-deyida-neme, “Nga. Kura wine kanhi-ka kumulung ngay-wa. Kumulung ngay-ka pinthawunu nankuneme-nu i ngay-ka ngunarrupupnemenu. Ngay-ka ngirrananmaputhnu warda da mange wiye ngarra numammath numpan nhini kumulung ngay-ka pinthawunu. Yile ngay-ka da murntak warra mam da mange wiye pirranmaputhnu ngarra kardu thangunu i manthibirnu purru. I nhini murrinh-ka murrinh da thathpirr pirranu ngarra kumulung ngay-re pinthawunu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","“Nga peneme.” Jesus kathu-yu mampirruneme. “Ngay, kardu ngarra darrikardu nanki thathpirr-ka nginipunh ngay ngenumutnu i ngupupnu ngarra kardu wiyenpun thangunu kathu i thu pungibatnu parni. I da nhini-ka mange ngarra Yile ngay marda manganngert dim ngay-nu-yu. Mu nga. Kardu nugarn pana ngarra paningipartnu i manmanpinu kardu wiyenpun pangu pumangirtanu, nukunu nhini-ka kanhi da matha mi dimmurrk ngarra ngay. Mu da-ka wiye thathpirr-wa nukunu-nu-yu nhini thangunu weyida da mange nhini ngarra manganu purru ngay-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bere nhini thangunu-ka pulangay nukunu Jesus-ka murrinh warda perrenedharrpudhaneme pirrine mange peneme ngatha, “Ya. Nangkal nimin parramutnu Jesus-yu ngarra kardu wiyenpun wangu-yu?” Pumenanudhaneme pirrine peneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bere nhini thangunu-ka pulangay nukunu Jesus-ka murrinh mange peneme puddanadharlurldhaneme punne kardu nangkal nimin-nu peneme ngatha-yu kardu pule ngala parethbathnu ngarra Jesus-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mu Jesus kathu-ka mampirruneme, “Nga peneme. Kardu pule ngala ngala pangu da ngamengka wangu kardu mere Jews-ya kardu nhini-ka kardu da tetemanthay pirrimpirra ngarra kardu wurnangat pangu-yu. Mu kardu pule ngala ngala murlakpun nhini-ka murrinh pumungampunwil pumpan kardu ngarra pigunu kardu pule patha patha pumampirra pumpan. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Mu nankuneme-nu-ka mange mere nginipunh nhini mani nanemenu. Mu kardu nangkal ngatha marda mart kardu pule ngala kardu kumparra purrunu-ya nhini nukunu-ka buynupaknu nginipunh kardu kigay mani i manmanpi warda ngatha kurru kardu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Murrinh numi kanhi, nga. Kardu nangkal nimin kardu ngala-yu? Kardu pana kama ngarra mi dhepdhep da matha dimmurrk i kardu pana kama ngarra mi mamnabath kathu wurran ngarra kardu pana-nu ngarra mi dimmurrk warra-yu? Kardu pana ngarra mi dimmurrk da matha-ka kardu ngala nawa nhini-yu? Mu ngay-ka nganam ngarra nankuneme-ka manankumanpinuneme da matha ngurru. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“I nga.” Jesus kathu-yu mampirru-deyida-neme. “Nankuneme-ka kardu bere matha wangu narnamkaneme ngarra ngay i mere narnengipartthaneme ngarra ngay-re da tetemanthay ngatha berdurdurttha ngurrini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yile ngay-ka da nakurlnu bungipaknu kardu Pule ngala thathpirr nginu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","I mange nginipunh nhini mani ngay deyida da nakurlnu bunankupaknuneme kardu pule-yu da pangu-yu ngarra Yile ngay nukunu i nekineme-ka marda ngala warda pinuneme i mi pimurrknuneme da pangu-yu. Nankuneme-ka kardu pule ngala ngala nerrunemenu kardu ngarra Jews-ya kardu yek 12-ya.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bere Jesus-ka murrinh warda wurdamnayith ngarra Simon Peter, “Nga Simon,” nukunu kathu-yu mamna Jesus. “Nukunu ku karrath-ka dantharrpu Yile ngay nankuneme-nu purdunankudhadhapnemenu purru i manankurullulnuneme purru da mange wiye-nu. I Yile ngay kathu-ka wurdannamurl nukunu-yu. Nukunu ku karrath marda mangannankurtneme dim-ka narnengipartnuneme i numenganthadarrarrnuneme ngarra ngay-yu mange nginipunh mi wheat mani-ya mi kamarl thathpirr-ka kanampart warda nanhthi darripi ngernu-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mu ngay-ka ngantharrpu Yile ngay, nhinhi-nu kardu manhilurruthnu i mere thurdubay nukun ngarra ngay-yu ngarra nukunu-re Satan manhirullulnu-yu. Mu nhinhi kardu-ka thaningipart-wa-nu ngadha, mu nhini thangunu-ka thuyngamarriknu warda thathpirr thurru i murrinh warda nangabathnu thurru. I da nhini-nu-re-ka nhinhi-ka nankulurruthnuneme kardu pulangay ngay warda nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bere nukunu Peter kathu-ka mamna ngarra Jesus, “Pule, ngay-ka mere nukun nganinhipart. Kardu ngatha pubunhirdinu ngarra jail-ka ngay-ka panirdi-deyida-nu neki-yu. I kardu ngatha thu punhibatnu puddunhirinuminu, nhini ngay-ka puddungirinumi-deyida-nu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Nga Peter.” Jesus kathu-yu mamna. “Murrinh kanhi-ka murrinh thathpirr. Thipinhi marra-ka ngarra ku rooster mere da ngatha pirrakaynu-ka, nhinhi-ka kardu narranu murrinh kanhi perrkenkuneme-yu, ‘Ngay-ka mere the-wa mabath kardu nugarn pangu-yu.’” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bere Jesus-ka mampirru-deyida-neme ngarra pulangay nukunu, “Nga peneme. Da murntak warra ngay-ka ngurdannankuthukneme i murrinh thathpi ngarra ngay narranenkuyelerrdhaneme nurni ngarra kardu nawa? I nankuneme-ka mere numebaththaneme narne ku mani, nanhthi bag i me sandal ngamere nawa? Mu nankuneme-ka mi i nanhthi nunneyeymadhaneme da nhini-re-yu?” Jesus kathu-yu dampunkudharrpuneme. “Awu wurda,” peneme kathu-yu pumamnaneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Mu nga.” Jesus kathu-yu mampirru-deyida-neme. “Nanhthi bag i ku mani ngatha nanthinkaneme nirrim-ka nhini-ka numabathnuneme warda nuru nhini-yu. I thu sword deyida wanku numabathnuneme nuru. Mu thu sword mathu ngatha-ka nanhthi kawut thelim niyemanemenu i thu sword warda numartnuneme nhini-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Murrinh thathpi Yile ngay-ka kanhi-wa yibim-yu, ‘Kardu-ka da mange pumanganu purru ngarra ngay kardu nginipunh mange pana mani pumampirra pumpan kardu ngarra wiyenpun ngarra murrinh law pumungantharrath pumpan-yu.’ I murrinh kanhi-ka da nakurlnu murrinh-ka pirra-da-nu-thathpirr nhini-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bere pulangay Jesus nukunu-ka pumamna-warda-neme, “Nga pule. Thu sword perrkenku-ka kanhi nganthinkaneme ngibimka.” “Yu, berengunh,” Jesus kathu-yu mampirruneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bere nhini thangunu Jesus-ka nungardurr warda da thelput nhini thangunu-yu i nadha dini da palyirr nan-nu warda wangu Olive mange ngarra medha ngatha pirriwattha-ya. I kardu pulangay nukunu deyida wanku parraneriwakthaneme pe-yu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bere ngarra parramkaruy-re-neme da pangu-ka nukunu Jesus kathu-ka mampirruneme, “Nga. Nankuneme-ka Yile ngay nadharrpnuneme manankumanpinuneme kardu yuthpan da matha nanemenu ngarra nukunu-re ku karrath manankurullulnuneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bere Jesus-ka wurrinidha pangu wangu da manta ngangka da ngatha i dempinhipingkarl i ngarra Yile nukunu warda dininangerrentha. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Yile,” mamna. “Kardu-ka pangilututnu i thu pungibatnu. Nganaka kama-ya marda nanganart dunthap warda kardu nhini-yu i mere kangilutut nukun i mere kungibat nukun. Nhini-wa ngay marda manganart ngem-yu. Mu nhinhi mange ngatha marda nart kardu thangunu pangilututnu i thu pungibatnu, nhini-ka ngay-re marda manganart-yu. Mange ngarra nhinhi marda nanganart-ka ngay-ka marda deyida manganart mange nhini-nu-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bere ku angel da kangkarl thangunu kathu pangamnaruy warda ngarra Jesus i mamlurruth deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mu Jesus-ka dammardathin ngala thathpirr i puy deyida wangu murrinh lurruth manganart dininangerrentha ngarra Yile nukunu wangu. I nginthirrin nukunu-ka ngala da matha diniyelyeldha ngarra putek wangu nginipunh nanhthi kumulung mani-ya. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bere murrinh nhini thangunu-ka Jesus-ka dempirnturt warda i wurdawurl ngarra pulangay nukunu i bampunkurdurtneme kardu ngurrnguwarl pirrinengurrkurrkthaneme, ngurrnguwarl mardathin thangunu mampunkumerlmerlneme. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bere Jesus-ka mampunkurdurtneme i mampirruneme, “Nga peneme. Thangku-dha nirrimkangurrkurrkneme pana-yu? Wurr, newirnturturtneme i Yile ngay warda nadharrpununeme manankumanpinuneme mere da mange wiye nukun niyemaneme ngarra nukunu-re ku karrath manankurullulnuneme-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bere ngarra nukunu-re Jesus pirringerren-da-dha-ngatha-ka kardu nugarn terert kardu murlakpun-ya parrarntuy warda ngarra manta Jesus-yu. I nukunu Judas-ka kumparra warra yunguninkardurrdha tharra. Nukunu nhini-ka kardu pulangay nukunu Jesus ngadha wurrininadha kardu 12-ya da ngarra marra-re-ya. I nukunu-ka murrinh kanhi-wa mampirra wardarra kardu murlakpun nhini-yu, “Kardu pana ngarra ngadhamurrudhungnu-ka nhini-wa Jesus-yu i numartanu-yu.” Bere Judas-ka manta warda wurrininadha ngarra Jesus padhamurrudhungnu ngarra thamurru nukunu. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mu Jesus kathu-ka mamna, “Judas, nhinhi-ka thangidhamurrudhungnu nawa i nhini kardu kibim kanhi-ka pumangirtanu ngay-yu nawa?” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bere pulangay nukunu Jesus-ka bampunkardu kardu murlakpun nhini-ka pumartanu warda Jesus-yu i nhini-ka pumamna-warda-neme ngarra Jesus-yu, “Pule. Ngankuneme-ka nguyethuknuneme kardu kanhi-yu thu sword ngankuneme-re-yu?” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I bere kardu numi kardu ngarra pulangay nukunu Jesus-ka thu sword nukunu yunganpirt i panthertal ngarra the batbat ngarra kardu pana ngarra wurlk menadha wurrini ngarra ku yilarn ngala thathpirr. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mu Jesus kathu-ka mampirruneme ngarra pulangay nukunu, “Ya peneme, pirda warda thu kuy-yu.” I nhini-ka manthethap kardu nhini the nukunu-yu i manthewatha patha deyida. ");
INSERT INTO mwf2018_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bere kardu terert pangu da pidha ngarra Jesus-nu pumartanu, kardu-ka ku yilarn ngala ngala-ya i kardu pule ngala ngala ngamere ngarra murrinh church thangunu i kardu ngalantharr ngalantharr deyida wanku. I bere Jesus kathu-ka mampirra ngarra kardu nugarn murlakpun nhini-yu, “Ya kardu. Mange nginipunh kardu darrarartwunka narnampunngawurt-ka, mange nginipunh nhini mani numangirtanu-yu, nawa? I nanki-ka numebaththa nunni thu sword i thu kumukurr wanku, nawa? ");
INSERT INTO mwf2018_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mu ngay-ka da terert da matha ngirripuptha wunku nanki-yu ngarra church ngala pangu-yu mu nanki-ka mere numengirtadha ngadha da nhini-re-yu. Mu marra kanhi da matha numangirtanu nawa? Nukunu ku karrath-ka mamnanyit wurran i nanki-ka ngarra nukunu da matha narrarntiwak numpan-yu.” ");
INSERT INTO mwf2018_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bere kardu nhini-ka pumangarnta warda Jesus-yu i pumebertidha punni ngarra thelput ngarra ku yilarn ngala thathpirr nukun. Bere Peter-ka danintiwaktha wurrini kardu murlakpu