﻿USE sofia;
DROP TABLE IF EXISTS sofia.mwc_vpl;
CREATE TABLE mwc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mwc_vpl WRITE;
INSERT INTO mwc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ae kapore Theophilus, kom pipiya kaikapom. Dagudagunai pipiya pesarisi si wose rubai, kata wose kamotiyai si tupuwa wai sita kirumisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nanakasike pipiya matasiyai si kinana, ba warana si yoneyonei wai rutainina sita kirumisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kona kairavina, yauku i kesiku wose ereonowasi dagudagunai a kinana kabitamni, ba anosi i gaire, kata kom kairavim ata kiruma kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kata kom awaika wata si beyebeyim wai, ereonowana basusi kuta kuira kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Maranai Herod Judeyai ibi taupauma wai, namai priest kesana i mamana, kana waba Zechariah. Kona wai, priest Abijah ana pipiya kesana, ba kaowana Elizabeth yebo, Aaron ana rakaraka kesana. ");
INSERT INTO mwc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Asi ruwamo wai, kosi God matanai piraga gaire pipiyisi, ba kosi Bada wonana si bosisira kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba saba natunatusi wai kega, basuna Elizabeth wai kaipokina, ba kosi asi ruwamo wai si morapa saki. ");
INSERT INTO mwc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mara kesana, Zechariah ana pipiya yabata asi mara i botu kata yove tapaoro kamonai sita saibira. Ba kona maranai wai God matanai priest saibirina Zechariah i wosewosei. ");
INSERT INTO mwc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ba priest asi dudura si kibi wai nanakasike, ababinebineyai si binei kata, ita riu God ana ku yove kamona, ba raunabonabo tepanai bane ita kapuni. ");
INSERT INTO mwc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ba bane kapunina maranai, pipiya korotosi matarai si kesanisi ba si rauupari. ");
INSERT INTO mwc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Damanina ba Bada ana aneya kurina i rere matara, ba bane kana raunabonabo kasaunai imsiri. ");
INSERT INTO mwc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ba Zechariah aneya i kinani wai, i sikwana ba i nagara saki. ");
INSERT INTO mwc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Saba aneya i wona, “Zecharaiah, kega kuna nagara, God am pari i nonori. Ba kaowam Elizabeth ini tuwa natum sebare, ba kana waba ke yorei John. ");
INSERT INTO mwc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kona ina tupuwa wai, kom kuni nuwagaire ba yam ina sisira, ba pipiya pesarisi yebo sini nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ana tupuwa maranai, Kanuma Kaoaobaisyena ini bonuvei. Ba kega meyanai wine kona okowa maragasina ina tomani. Ba Bada matanai, kona wai pipiya kaikapona. ");
INSERT INTO mwc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ba Israel biyisi pesarisi ini neveramagisi, Bada asi God kurina. ");
INSERT INTO mwc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ba peroveta Elizah rautainina ana maragatai, ba kanuminai, ini nao Bada naonai ina nae. Tamatama natunatusi yabata ini kesana meyisi. Ba pipiya kawa kasekasesi asi nuwasuya ina birai, kata pipiya gaigairesi asi nuwasuyai sina nuwasuya. Ba Bada ana pipiya ina bobunagisi kata kairavina sina bo kabitam.” ");
INSERT INTO mwc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah aneya i toirubai i wona, “Mekabage ana kuiri kata awaika kui sisiyei wai ina tupuwa, basuna yauku kaowaku yabata wai, ka morapa saki?” ");
INSERT INTO mwc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneya i kaobeyei i wona, “Yauku Gabriel, God naonai a imsimsiri. Ba kona i poraiku wai kurim ati sisiya, ba niko wara gairena ata wonim. ");
INSERT INTO mwc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ba wonaku wai bisuwona ina tupuwa. Saba kom kega kuigeruvei kairavina, karaku kom kawam ina pota, ba kega kuni bi sisiya yepo, ina tupuwa wai ku marana.” ");
INSERT INTO mwc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kona maranai, pipiya Zechariah si potapotai, ba nuwanuwasi i kairagaraga kata, awaika basuna wai, God ana yove kamonai i mana i veoroma saki. ");
INSERT INTO mwc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Maranai i kasibau wai, kega kurisi i sisiya. Saba si kuiri kata God ana yove kamonai matakira i kitai, kairavina yaronai wata kurisi ibi sisiya. ");
INSERT INTO mwc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ba ana saibira, God ana yove kamonai i kakabi wai, i veramaga ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nikona murinai, kaowana Elizabeth i manawa, ba nawaravi asi five yove kamonai wata i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeth i wona, “Bada nikona kairaviku i wosei, kata ana yagaire i beyiku, ba pipiya matasiyai au tepa bainuba i yauna taveyei.” ");
INSERT INTO mwc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth i manawa nawaravi kana bi six kamonai, ba God aneya Gabriel i porai ku Nazareth. Kona meyagina wai Galilee kamonai. ");
INSERT INTO mwc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I nae yegeyege sinitupana kesana, kana waba Mary kurina. Ba Mary wai, kona sebare kana waba Joseph, si bobeyei kata ita rabai. Ba Joseph wai, kona taupauma David ana rakaraka kesana. ");
INSERT INTO mwc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneya i nae Mary kurina ba i wona, “Enosaire! nuwanuba kurim ina mana, ba Bada kurim ina mana, ba ini gairena sakiyim.” ");
INSERT INTO mwc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ba Mary aneya ana sisiya i nonori wai, nuwanuwana i kairagaraga, ba i nuwasuya kabakaba. ");
INSERT INTO mwc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Saba aneya i wona, “Kega kuna nagara, basuna God kurim ebi nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kom kuna manawa, ba kuni tuwa natum sebare, ba kana waba kuna yorei Iesu. ");
INSERT INTO mwc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kona wai kana waba ina rakata saki, ba sina yorei God kaidamo sakina natuna. Ba God ina wosei ini Taupauma, tamana David rutainina. ");
INSERT INTO mwc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ba kona Jacob natunatuna ini Taupauma damanisi, ba ana basileiya kega turina.” ");
INSERT INTO mwc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary saba aneya i toirubai i wona, “Nikona mekabage kuriku ina tupuwa, kairavina, yauku wai sini matupaku?” ");
INSERT INTO mwc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneya i kaobeyei i wona, “Kanuma Kaoaobaisiena kurim ina botu, ba God kaidamo sakina ana maragata ina waku tawanim. Kona kairavina pipiyaikei kaoaobaisiyena ina tupuwa, ba sina yorei God natuna. ");
INSERT INTO mwc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kuna nosi kata waresim Elizabeth pipiya si wona kata kona kaipokina, ba i morapa saki. Saba kona karaku wai, i manawa kana nawaravi six. ");
INSERT INTO mwc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kairavina God kega kesana awaika ita wose kabakabai.” ");
INSERT INTO mwc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary i kaobeyei i wona, “Yauku Bada ana saibisaibirina, abi damanina kata kuwona wai nanakasike kuriku ina tupuwa.” Ba damanina aneya i sumarei. ");
INSERT INTO mwc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kona maranai, Mary i bobunaga, ba yagiyagina wata i nae ku Judiya koyakoyana, ba i nae ku meyaga kesana. ");
INSERT INTO mwc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ba namai, Mary i riu Zechariah ana ku yove, ba Elizabeth i enowei. ");
INSERT INTO mwc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maranai, Elizabeth ana bi eno! eno! i nonori wai, pepeya siyana kamonai i bokwayo, ba Elizabeth kanuma kaoaobaisiena i bonuvei. ");
INSERT INTO mwc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ba gamona kaikaponai i para i wona, “Bibaine ereonowasi kamosi yai wai kom bibi gairenim, ba natum kuni tuvei wai, yebo kona bibi gairenina!” ");
INSERT INTO mwc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Saba awaika kairavina yauku kuriku bo kuwaya i rakata, wai au Bada sinana i botu kuriku? ");
INSERT INTO mwc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kairavina maranai am bai eno eno a nonori wai, pepeya siaku kamonai ere nuwagairena i bokwayo. ");
INSERT INTO mwc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kom wasike bibi gairenim, kairavina kui geruwana kata awaika Bada i wonim wai, ina tupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary i wona, “Nuwanuwaku Bada abo kabakabari, ");
INSERT INTO mwc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ba kanumiku ebi nuwagaire kairavina, God wai au baibai yawasina. ");
INSERT INTO mwc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yauku ana saibisaibirina moyamoyakiku i nosiku kairavina, karaku ba karakuwata, sina yoriku bibi gairenina. ");
INSERT INTO mwc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God maragata sakina, ba kana waba kaoaobaisiena, basuna sawara kaikaposi kairaviku i wosisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dam ba dam nununai, iyabosi te naganagarei wai, ebi nuwanuwanisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yaronai wose maragasisi i wosisi, ba kosi iyabosi nuwa sinesiyai si imsigegae wai, i buburanisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Taupauma maragasisi asi aba makimakirai i tere kireisi, ba moyamoyakisi ibo kabarisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Soya raoboraobosi sawara gaigairesiyai i bonuvisi, ba marimariyisi kwebusi i pora taveyisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana saibisaibirina Israel i baisi, ba wawata kurisi i kao baiyoyobana wai nanakasike, ");
INSERT INTO mwc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kega ini nota wapei. Kata Abraham, ba natunatuna ini nuwanuwana damanisi.” ");
INSERT INTO mwc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary Elizabeth yabata si mamana yepo, nawaravi kana bi tonu, ba i veramaga ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ba Elizabeth ana bi tuwa marana i neratui wai, i tuwa natuna sebare. ");
INSERT INTO mwc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Warewaresina ba maturaturana warana si nonori kata, Bada kurina i yagaire saki wai, ereonowasi Elizabeth yabata si nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ba taparoro kesana murinai, si botu sebareikei sinibonaina kairavina, ba tamana Zechariah kana wabai sita yorei. ");
INSERT INTO mwc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Saba sinana i wona, “Kega, kana waba kona yorei John.” ");
INSERT INTO mwc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Saba kurina si wona, “Am rakaraka kamosiyai kega kesana kotoi kana waba nanakasike.” ");
INSERT INTO mwc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Damanina ba tamana kurina si siwa bi beyena, ba si toirubai kata ana waina abi waba pipiyaikei sita yorei. ");
INSERT INTO mwc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Saba Zechariah pepa kairavina i baba wai si berei, ba ereonowasi si sikwana kata i kiruma i wona, “Kana waba wai John.” ");
INSERT INTO mwc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ba mara kesana kawana i botatari wai pepena i yayaura ba bi sisiya i dagu meyei, ba Bada i bokabakabari. ");
INSERT INTO mwc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Maturaturana ereonowasi si nagara saki ba si wareyei, ba warana si rakasi wai Judeyai koyakoyana ereonowana i bonuvei. ");
INSERT INTO mwc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ba pipiya ereonowasi nikona si nonori wai, si nuwasuyei ba si toiruba si wona, “Niko pipiyikei wai kona kotoi?, Kairavina, iru matara kata Bada ana maragata wai kona gwabinai emamana.” ");
INSERT INTO mwc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Damanina ba kanuma kaoaobaisiyena John tamana Zechariah i bonuvei, ba i naovei wai God wonana i sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","I wona, “Bada Israel ana God tana bokabakabari, basuna i botu ana pipiya i baisisi, ba i tom baubaunisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ba God ana saibisaibirina, David ana rakaraka kamonai, aba bai yawasa kota kairavita i porai. ");
INSERT INTO mwc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Matapanaki, ana peroveta kaoaobaisiesi kurisi ikao bi yoyobana wai, nanakasike. ");
INSERT INTO mwc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kata, iyabosi tebi sinikaikaiyita, ba kata abiya yarosiyai yebo, ini taraparanita. ");
INSERT INTO mwc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ba ana kao bi yoyobana kaoaobaisiena ina nosi wai, nosinosita ini nuwanuwanisi. ");
INSERT INTO mwc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abraham kurina i kao bi yoyobana, ");
INSERT INTO mwc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kata, abiya yarosiyai ini taraparanita, ba maragata ina berita wai, kega ere naganagarita tana bo saibirei. ");
INSERT INTO mwc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kata, kota naonai ata wose sina gaire, ba mara ereonowana kaoaobaisieta ata yawasa kamosiyai tana mana. ");
INSERT INTO mwc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ba kom natuku, sina yorim God kaoaobaisiena ana peroveta, kairavina, kom Bada naonai kuni nao kuna nae, ba ana keta kuna bobunagi. ");
INSERT INTO mwc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ana pipiya kuna wonisi sina kuiri, kata asi piraga goyo sina tombaubauna taveyisi wai, sina yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ata God bai nuwanuwana bitana kairavina, ata bai bai yawasina sapamai ini porai kurita. ");
INSERT INTO mwc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ba kosi rabobo wakunai, ba baidibara kamonai te mamana wai kurisi, ");
INSERT INTO mwc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ina rauyasegana, ba kaeta nuwanuba ketana ku kamona ina tere bi totori. Ba pipiyaikei kanumai ba tupuwai i rakata, ba i maragata. Ba kupura mom kamonai i mamana yepo ku deba i kasibau, Israel biyisi kurisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kona maranai, Caesar Augustus wonana maragasina i kasibau. Kata Rome dobuna ereonowana kamonai, pipiya ereonowasi sita baiyavisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Qurinius, Syria kamonai ibi bada maranai, nikona wai koroto baiyavina dagudaguna. ");
INSERT INTO mwc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ba pipiya ereonowasi si nae ikeikesisi asi ku meyaga, ba kasi waba sita kirumisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kata Joseph yebo, Galilee kamonai, Nazareth meyagina i kasibau taveyei ba i gae ku Judiya. Ba i nae David ana ku meyaga ku Bethlehem, basuna kona wai David ana dam kesana. ");
INSERT INTO mwc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ba Mary matapa i manawa, ba kana bobeya Joseph yabata si nae nakai, kasi waba kiruma kairavina. ");
INSERT INTO mwc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Namai si mamana yepo Mary ana bi tuwa marana i neratui, ");
INSERT INTO mwc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ba natuna yarokona sebare i tuvei. Ba garai i sumai ba aba payapayaya asi aba kamkam kamonai i dau’vei, kairavina wagawaga asi yove kamonai wai gawara kega. ");
INSERT INTO mwc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kona pominai, meyaga gwabinai sheep aba potapotaisi si mamana. Kwapu kamonai asi abapayapayaya si potapotaisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ba Bada ana aneya i rerematara kurisi. Ba Bada ana kadara i ruyasegana i subibirisi wai, kosi si nagara saki. ");
INSERT INTO mwc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Saba aneya kurisi i wona, “Kega kona nagara, nuwagaire warana kaikapo sakina a botuvei, komi ba pipiya ereonowasi kairavisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Karaku, David ana meyaga kamonai bai yawasa biyina kurimi i tupuwa, kona wai Bada Keriso ");
INSERT INTO mwc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nikona ami matakira, kata pepeya aba payapaya asi abakamkam kamonai garai si sumai ba edudauwa kona panani.” ");
INSERT INTO mwc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Damanina ba mara kesana sapama kaikorotona aneya yabata si rerematara. Ba God si bookabakabari ba si wonawona, ");
INSERT INTO mwc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kadara God kaidamo sakina kurina. Ba dobu wai pipiya kurisi ebi yagaire wai nuwanuba ina mana.” ");
INSERT INTO mwc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ba aneya si sumarisi si veramaga ku sapama maranai, sheep potapotaisi si kao boneyana si wona, “Ta nanae ku Bethlehem ba niko wose i tupuwa Bada i wonita wai tana kitai.” ");
INSERT INTO mwc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Damanina ba yagiyagina wata si nae Mary ba Joseph si pananisi, ba pepeya aba payapaya asi abakamkam yovena kamonai si kinani. ");
INSERT INTO mwc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ba pepeya si kinani murinai wai, awaika aneya niko pipiyaikei kairavina i wonisi wai warana si rakasi pipiya kurisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ba pipiya ereonowasi awaika sheep aba potapotaisi si wonisi wai si wareyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Saba Mary nikosi wosesi ereonowasi nuwanuwanai i tatawanisi, ba i nota bitetei. ");
INSERT INTO mwc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ba sheep potapotasi si veramaga awaika si nonori ba si kitai wai, God si bokabakabari ba si bokuwayei. Basuna awaika aneya i wonisi wai, rautainina i tupuwa si kitai. ");
INSERT INTO mwc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Taparoro kesana murinai, pepeya sini bonaina maranai, kana waba si yorei Iesu. Niko waba kona muriyai sinana ita manawa wai aneya i berei. ");
INSERT INTO mwc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ba bi gairena suwarina marana i neratui wai, Moses i kaotunetunei wai nanakasike. Joseph ba Mary Iesu si yauni si nae ku Jerusalem, Bada sita bere meyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ba Bada wonana itamo kiruma wai nanakasike. Kata sebasebare yarokosi ereonowasi, Bada kurina sita bosireisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba Bada wonana i wona wai nanakasike, puyo bunuwa sita kapuni, bunebune ruwamo kona buruko soesoesi asi ruwamo. ");
INSERT INTO mwc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kona maranai, sebare kesana kana waba Simion, Jerusalem yai i mamana. Simion kona piraga gaire pipiyina, ba Kanuma Kaoaobaisiyena i bonuvei wai, Israel ana bai yawasina i potapotai. ");
INSERT INTO mwc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kanuma Kaobaisiyena Simion i beyei, kata Bada Keriso ita kitai ba muriyai ita rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iesu tutununa si yauni si riu Bada wonana i wona wai sita wosei maranai, kanuma kaoaobaisiena Simion i bonuvei wai i riu ku yove tapaoro. ");
INSERT INTO mwc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ba Simion yaronai Iesu i pewai, ba God i bokabakabari i wona, ");
INSERT INTO mwc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bada karaku yona am saibisaibirina ku kao bai yoyobani wai nanakasike, ke boterei kata nuwanubai ina rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kairavina am baibai yawasina matakuwai a kitai, ");
INSERT INTO mwc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","pipiya ereonowasi matasiyai kubo kabitamni wai. ");
INSERT INTO mwc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yasegana pipiya tumana kurisi ina ruayasegana, ba kadara am pipiya Israel kurisi.” ");
INSERT INTO mwc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion awaika Iesu kairavina i sisiyei wai, tamana ba sinana si wareyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Damanina ba Simion i gairenisi ba sinana Mary i wonei i wona, “Niko pipiyaikei kona God i binei kata, Israel pesarisi kurisi ina kasibai goyona ba ini yawasa. Nikona God ana matakira kata pipiya pesarisi sina kao bi goyoni. ");
INSERT INTO mwc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ba asi nota mama bai buneyisi ini debeisi. Ba nuwapoya nanakasike bage seri kom nuwanuwam katekatem ina tupa rebui.” ");
INSERT INTO mwc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Namai yebo peroveta wasike kesana i mamana, kana waba Anna, tamana Phanuel kona Asher ana dam kesana. Anna i tabine bodu seven wata, ");
INSERT INTO mwc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ba i sobere i mamana yepo kana bodu eighty-four, i morapa saki. Saba kega meyana God ana yove i kasibau taveyei, kao ba pom ibi siya ba i raupari. ");
INSERT INTO mwc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion, Mary ba Joseph yabata sibi sisiya ba, Anna i botu kurisi ba i kaikaiwa God kurina. Ba iyabosi sibi potapota kata God Jerusalem ita tombaubauni kairavina, ereonowasi kurisi pipiyaikei i sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph ba Mary awaika ereonowasi, Bada wonana i wona wai nanakasike si wosei i kakaba ba, si veramaga ku Galilee ba si nae asi ku meyaga ku Nazareth. ");
INSERT INTO mwc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ba pipiyaikei i rakata ba i maragata, nuwasuya i bonuvei ba God ana bai nuwanuwana kurina i mana ");
INSERT INTO mwc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bodu patepatena, Iesu tutununa si nenae ku Jerusalem, bai Saubona poragina kairavina. ");
INSERT INTO mwc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Asi dudura nununai, Iesu kana bodu twelve ba si urabai si nae ku poraga mena. ");
INSERT INTO mwc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Poraga i kakaba murina, Iesu tutununa si veraveramaga ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Joseph ba Mary si nosi kata Iesu koroto kamosiyai yabata sita nenae. Nao kao si yewo pom, ba rabisiyai turaturasi ba asi rakaraka kamosiyai si bokabai. ");
INSERT INTO mwc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba kega si panani wai, si nuveni si veramaga ku Jerusalem. ");
INSERT INTO mwc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kao tonu murinai, yove tapaoro kamonai si panani, Jew bi beyebeyena biyisi kamosiyai i mamana, ibi taina baenegisi ba ibi kasekasemainisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ba ereonowasi si nonori wai, ana kuira ba ana kaobeyena si wareyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tutununa si kinani wai si sikwanei, ba sinana i wona, “Natuku! Awaika kairavina nikasike ku wosei? Tamam yabata, ere yapoyi kai ba, ere naganagari kai ka nuvenuvenim.” ");
INSERT INTO mwc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kona saba i kaobeyisi, i wona, “Awaika kairavina ko nuvenuveniku? Kota kuiri kata yauku tamaku ana yove kamonai a mamana.” ");
INSERT INTO mwc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Saba kosi kega si kuiri kata kona awaika kurisi ibi sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Damanina ba yabata si veramaga ku Nazareth, ba mamanina ibo sisiriyisi. Saba sinana nikosi wose ereonowasi nuwasinenai i notanota bi teteisi. ");
INSERT INTO mwc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu tupuwai ba nuwasuyai i rakata, God ba pipiya i nuwa gairenisi. ");
INSERT INTO mwc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibrius Caesar Rome kupurina kamonai ibi kaiwabo bodu kana bi fifteen kamonai, Pontius Pilate wai Judeyai ibi bada. Ba Herod kona Galilee yai ibi bada, ba tuwateina Phillip wai Ituria ba Traconitis kamosi yai ibi bada. Ba Lysanias wai kona Abilene yai ibi bada. ");
INSERT INTO mwc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kona maranai, Annas ba Caiaphas wai kosi priest kaikaposi. Ba God wonana i botu Zechariah natuna sebare John, kupura mom kamonai i mamana wai kurina. ");
INSERT INTO mwc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ba kona Jordan kupurina ereonowana kamonai i yewo, ba pipiya kurisi i raumamara i wonawona, “Ami piraga, goyosiyai koi nuwabirabira, ba kona babataito, kata God ami piraga goyosi ina notataveyisi.” ");
INSERT INTO mwc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Peroveta Isaiah ana buka kamonai i kiruma wai nanakasike i wona, “Pipiya kesana kupura mom kamonai e paraparara e wonawona, Bada kairavina keta ko bobunagi ba ana keta kobo bitotori. ");
INSERT INTO mwc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sanaga ereonowana ko tabuna, koya kaikaposi ba soesoesi kobo bipopona, keta kiyokiyosi kobo bi totora, ba keta bi gesokesokisi ko mumuisi. ");
INSERT INTO mwc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kata pipiya ereonowasi God ana baibai yawasina sina kitai.” ");
INSERT INTO mwc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pipiya korotosi si botubotu kurina babataito kairavina wai i wona, “Komi mota natunatua ribasi! Kotoi i wonimi kata God ana bi buibuiya e botubotu wai nagarina kona vera? ");
INSERT INTO mwc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Awaika kesana ko wosei ini beyena kata komi ami piragagoyosi koi sinikikiyana, ba kega kona nosi kona wona, yakai Abraham natunatuna. A woniwonim, God rubarubana Abraham natunatuna, nikosi akimai ina woseisi. ");
INSERT INTO mwc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kirama i bobunagi kata keyama ereonowasi kega te uwauwa wai, warowarovisi yai ina tara tavetaveyana, ba ini garu gegeyana ku keyama karakarasina.” ");
INSERT INTO mwc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ba pipiya pesarisi si toirubai si wona, “Kata yakai mekabage kana wose?” ");
INSERT INTO mwc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John i kaobeyisi i wona, “Kotoi wata karinai gara ruwamo te mamana wai, kesana kotoi karinai gara kega emamana wai ina berei. Ba kotoi wata karinai kam e mamana wai, wosena kesanina ina wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi aba yauyauna biyisi si botu sita babataito wai si toirubai si wona, “Bada yakai mekabage kana wose?” ");
INSERT INTO mwc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I wonisi i wona, “Ruba si terei wai, kega kona yauna koni subonei.” ");
INSERT INTO mwc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ba abiyabiyisi mutusi si toirubai si wona, “Ba yakai mekabage kana wose?” I kaobeya i wona, “Pipiya asi money kega ere mainimi kona sekwaisi, ba kega pipiya koni kunumaka kwarumisi, ba ami maisa mekabage koyuyauni wai, koi nuwagaire.” ");
INSERT INTO mwc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pipiya sima baenega, ba nuwasinesiyai si nosinosi bage John wai kona Keriso. ");
INSERT INTO mwc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saba John ereonowasi kurisi i wona, “Yauku okowai a babataitoimi, saba pipiya kesana e botubotu kona ana maragata i rakata saki kega yauku rautainiku. Yauku kega gaireku, ba kana kae sumasuma ata tombaunisi. Kona keyama karakarasinai ba kanuma kaoaobaisiena ina babataitoimi. ");
INSERT INTO mwc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wheat kana kasi bubu yaronai, kata wheat tupana ina kasi bubui, ba wheat ina bobunagi ana bobitaura yovena ku kamona ini wani, ba muguna keyama karata bonabonanai ina kapuni.” ");
INSERT INTO mwc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","John keta pesarisi ba bubausi yai wara gairena pipiya kurisi i raumamarei ba ikao bi nuwarupairisi. ");
INSERT INTO mwc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Saba, John kaiwabo Herod ikao rumatanei, basuna tuwateina kaowana kana waba Herodias i utusekwai, ba yebo, wose goyogoyosi pesarisi kairavisi. ");
INSERT INTO mwc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ba yebo Herod wose goyona i tetetawani, kata John ku patuma yovena i tere riuvei. ");
INSERT INTO mwc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ba pipiya ereonowasi si babataito maranai, Iesu yebo i babataito. Ba i raupari maranai, sapama i tamotatara. ");
INSERT INTO mwc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ba kanuma kaoaobaisiena tupuwa i kotei, ba bunebune rautainina i gakira ku tepana. Ba gamo sapamai i wona, “Kom natuku au nuwayauyauna, kom yai ba abi nuwagaire saki.” ");
INSERT INTO mwc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu kana bodu matapa iti thirty, ba ana saibira i dagui. Iesu sebare wai pipiya sinosi kona wai Joseph natuna, ba Joseph si nosi kata tamana wai Heli. ");
INSERT INTO mwc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ba Heli tamana wai Mathat, ba Mathat tamana wai Levi, ba Levi wai tamana Melki, ba Melki tamana wai Jannai, ba Jannai wai tamana Joseph. ");
INSERT INTO mwc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph wai tamana Mattathias, ba Mattathias wai tamana Amos, ba Amos wai tamana Nahum, ba Nahum wai tamana Esli, ba Esli wai tamana Naggai. ");
INSERT INTO mwc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai tamana wai Maath, ba Maath tamana wai Mattathias ba Mattathias tamana wai Semein, ba Semein tamana wai Josech, ba Josech tamana wai Joda. ");
INSERT INTO mwc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda tamana wai Joanan, ba Joanan tamana wai Rhesa, ba Rhesa tamana wai Zerubbabel, ba Zerubbabel tamana wai Shealtiel ba Shealtiel tamana wai Neri. ");
INSERT INTO mwc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tamana wai Melki, ba Melki tamana wai Addi, ba Addi tamana wai Cosam, ba Cosam tamana wai Elmadam, ba Elmadam tamana wai Er. ");
INSERT INTO mwc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wai tamana Joshua, ba Joshua wai tamana Eliezer, ba Eliezer wai tamana Jorim, ba Jorim wai tamana Matthat, ba Matthat wai tamana Levi. ");
INSERT INTO mwc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi wai tamana Simeon, ba Simeon wai tamana Judah, ba Judah wai tamana Joseph, ba Joseph wai tamana Jonam, ba Jonam wai tamana Eliakim. ");
INSERT INTO mwc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim wai tamana Melea, ba Melea wai tamana Menna, ba Menna wai tamana Mattatha, ba Mattatha wai tamana Nathan, ba Nathan wai tamana David. ");
INSERT INTO mwc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David wai tamana Jessie, ba Jesse wai tamana Obed, ba Obed wai tamana Boaz, ba Boaz wai tamana Salmon, ba Salmon wai tamana Nashon. ");
INSERT INTO mwc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon wai tamana Amminadab, ba Amminadab wai tamana Ram, ba Ram wai tamana Hezron, ba Hezron wai tamana Perez, ba Perez wai tamana Judah. ");
INSERT INTO mwc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah wai tamana Jacob, ba Jacob wai tamana Isaac, ba Isaac wai tamana Abraham, ba Abraham wai tamana Terah, ba Terah wai tamana Nahor. ");
INSERT INTO mwc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor wai tamana Serug ba Serug wai tamana Reu, ba Reu wai tamana Peleg, ba Peleg wai tamana Eber, ba Eber wai tamana Selah. ");
INSERT INTO mwc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selah wai tamana Cainan, ba Cainan wai tamana Arphaxad, ba Arphaxad wai tamana Shem, ba Shem wai tamana Noah, ba Noah wai tamana Lamech. ");
INSERT INTO mwc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech wai tamana Methuselah, ba Methuselah wai tamana Enoch, ba Enoch wai tamana Jared ba Jared wai tamana Mahalalel, ba Mahalalel wai tamana Kenan. ");
INSERT INTO mwc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wai tamana Enosh, ba Enosh wai tamana Seth, ba Seth wai tamana Adam, ba Adam wai tamana God. ");
INSERT INTO mwc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Kanuma Kaoaobaisiyena i bonuvei ba Jordan yai i veramaga. Ba i naovei wai, i riu ku kupura mom, ");
INSERT INTO mwc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ba namai kao forty Satan i sakariyei. Kona maranai kega kesana awaika i kam rubai, ba ana bi siya damonai wai soya i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ba Satan i wonei i wona, “Kom God natuna wai, nikosi akima ke wonisi sini kam.” ");
INSERT INTO mwc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Saba Iesu i kaobeyei i wona, God wonana i kirumi i wona, ”Pipiya asi yawasa wai kega kamwai wata.” ");
INSERT INTO mwc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Damanina Satan Iesu i urabai i gae koya ku tepana, ba dobu tupana i bibeyei. ");
INSERT INTO mwc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ba i wona, “Baibadana ba ana kadara ereonowana i beriku wai kotoi wata ana wainei wai ana berei. ");
INSERT INTO mwc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ba kom kuna bopepetiku wai, nikosi sini karimi yai.” ");
INSERT INTO mwc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Saba Iesu i kaobeyei i wona, “God wonana i kirumi i wona, God i kesina wata ke bopepetei, ba ke bosaibirei.” ");
INSERT INTO mwc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Damanina ba Satan i urabai i nae ku Jerusalem, ba yove taparoro tepanai dama i msiri ba Satan i wona, “Kom God natuna wai, nimai ki sou, ");
INSERT INTO mwc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kairavina, God wonana i kirumi i wona, God ana aneya kom kairavim ina kao tuneyisi kata sini taraparanim. ");
INSERT INTO mwc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ba kosi yarosiyai sina bokabarim, wai kaem kega ku akima kuna ravi.” ");
INSERT INTO mwc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Saba Iesu i kaobeyei i wona, “God wonana i wona, Bada am God kega ke raurubai.” ");
INSERT INTO mwc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nikosi bai sakari ereonowasi i kakabi wai Satan Iesu i sumarei mara soena, ba ta marai yebo ina veramaga. ");
INSERT INTO mwc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu Kanuma Kaoaobaisiyena ana maragatai i veramaga ku Galilee, ba warana i tuwapesari kupura ereonowana i bonuvei. ");
INSERT INTO mwc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Duwu yovesi kamosiyai i beyebeyena ba pipiya ereonowasi si kao bi gegaeni. ");
INSERT INTO mwc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ba i nae ku Nazareth, i rakata wai ku meyagina. Ba i riu ku duwu yovena mamanina sabbath maranai i wosewosei wai rautanina. Ba i bomsiri ita baiyawa. ");
INSERT INTO mwc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba peroveta Isaiah ana buka si berei i botatari, ba gawara i panani memena i kiruma i wona, ");
INSERT INTO mwc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bada kanumina kauriku emamana, kairavina i bineiku, kata moyamoyakisi kurisi wara gairena ata botuvei. I poraiku kata patupatumisi kurisi tombaubaunisi ani yoneyonei, ba matapotapotasi sini kinana, ba bobogoyosi ana tombaunisi. ");
INSERT INTO mwc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ba ani yonayona kata mara i botu, Bada ana pipiya ini yawasisi.” ");
INSERT INTO mwc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Damanina Iesu buka i gudui ba aba saibisaibirina i bere meyei ba i makira. Ba pipiya ereonowasi duwu yovena kamonai si kita damanei, ");
INSERT INTO mwc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ba kurisi i wona, “Niko God wonana ko nonori wai karaku e tuputupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pipiya ereonowasi si kao bigegaeni, ba wona kai masavisi i sisiyana wai si wareyei ba si wona, “Niko Joseph natuna kona?” ");
INSERT INTO mwc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Saba Iesu kurisi i wona,” A kuiri niko bi maibai kona woniku kona wona, “Doctor, ki yawasa meyim! Ba yebo kona wona, awaika Capernum kamonai ku wosei wai am meyaga kamonai ke wosei kana kinani. ");
INSERT INTO mwc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ba Iesu i wona abi suwonimi, “Peroveta ana meyaga dama biyisi sina kao sirei. ");
INSERT INTO mwc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Abi suwonim kata Elijah ana marai kega i kusana bodu tonu ba nawaravi six, ba gomara kaikapona dobu ereonowana i yauni. Kona maranai, Israel kamonai sobesobere pesarisi si mamana, ");
INSERT INTO mwc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","saba God Elijah i porai kega kesana meo sobere kurina, ba sobere kesana, Zerephathyai, Sidon kupurina kamonai i mamana wai kona wata kurina. ");
INSERT INTO mwc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ba peroveta Elisha ana marai, Israel kamonai pipiya pesarisi lepa gubagina si yauni, ba kega kesana i yawasi, saba Naaman Syira biyina wata i yawasi. ");
INSERT INTO mwc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pipiya ereonowasi duwu yovena kamonai nikona si nonori wai, si yagisi saki. ");
INSERT INTO mwc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Si bomsiri ba Iesu si taina se’eseri si kasibau ku meyaga kupuna, ba si yauni si gae asi meyaga si bowai wai koyana ku tepana, asi waina ku sanaga siti garukirei. ");
INSERT INTO mwc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Saba, koroto basusiyai wata i sonaga ba i nae. ");
INSERT INTO mwc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","I nae ku Capernaum, meyaga kesana Galilee kamonai, ba Sabbath maranai pipiya ibi beyebeyisi. ");
INSERT INTO mwc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ba ereonowasi ana bi beyebeyena si wareyei, kairavina ana sisiya wai ere maragasina. ");
INSERT INTO mwc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ba namai duwu yovena kamonai sebare kesana kanuma goyona i riuni wai i mamana. Ba gamona kaikaponai i rasa i wona, ");
INSERT INTO mwc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai! Iesu Nazareth biyim awaika kurikai kuna wosei, ku botu kuna kasi bai goyonikai kona? A kuirim kom kotoi. kom God ana Kawari Yonayona Kaoaobaisiyena!” ");
INSERT INTO mwc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu gamona padapadanai i wona, “Kawam e pota ba nao sebare ke kasibau taveyei!” Damanina pipiya ereonowasi naosiyai kanuma goyona sebarena i garukirei ku tano, ba i kasibautaveyei, ba kega kesana awaika goyona kurina i wosei. ");
INSERT INTO mwc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ba pipiya ereonowasi si wareyei ba si kaoboneyana si wona, “Agi! Saba niko awaika? Niko sebare ana sisiya abi maragasisi naki wai, kanuma goyogoyosi e kao tunetuneisi wai tebo sisiriyei.” ");
INSERT INTO mwc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ba Iesu warana kupura tupana i bonuvei. ");
INSERT INTO mwc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu duwu yovena i sumarei ba i nae Simon ana ku yove. Simon rawana wasikena i gubaga sinina i boborabora saki, wai Iesu si babai kata iti baisi. ");
INSERT INTO mwc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Damanina Iesu i nae wasikena ana aba dudauwa gwabinai i msiri ba sini borabora i kao tunetunei ita kasibautaveyei. Ba sini borabora mara kesana wasikena i kasibautaveyei, ba i bomsiri ba kairavisi i bosaibira. ");
INSERT INTO mwc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ba rabisi pompomai pipiya turaturasi kasi gubaga bubausiyai ereonowasi, si yaunisi si botu Iesu kurina, ba i borubaisi wai si yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yebo pipiya pesarisi kamosiyai kanuma goyogoyosi ere paraparasi si kasibau ba si wona, “Kom wai God natuna!” Saba i kaotunetuneisi kega siti sisiya, kairavina si kuiri kata kona wai Keriso. ");
INSERT INTO mwc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mara tom didibarinai Iesu i kasibau i nae ku kupura mamawapana, ba pipiya wai si nuvenuveni. Ba maranai si panani wai si babai kata kega iti sumarisi. ");
INSERT INTO mwc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Saba i wona, “God ana basileya warana gairena meyaga mutusi yebo kurisi ana rumamarei, basuna kona kairavina i poriku.” ");
INSERT INTO mwc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Damanina Judia biyisi asi duwu yovesi kamosiyai i rumamara neubuwa. ");
INSERT INTO mwc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mara kesana, Iesu Gennesaret torenai i msimsiri, ba pipiya korotosi si una raturatui, ba God wonana sibi tainabaenegei. ");
INSERT INTO mwc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ba i kinana kata waka asi ruwamo banobanotisi toreyai si taina biyotisi, ba asi sewari si boosuwana. ");
INSERT INTO mwc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu Simon ana ku waka i geru ba i babai i yori yoginaikei i kasibau, ba waka tepanai i makira, ba pipiya toreyai ibi beyebeyisi. ");
INSERT INTO mwc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Maranai i sisiya i kakaba wai, Simon i wonei i wona, “Waka nakata ke yauni ke gae ku ragu ba kam birauwa yabata sewari koi garu kikirana kona banota.” ");
INSERT INTO mwc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saba Simon i kaobeyei i wona, “Bada, yakai ka banota maratom ba kega kesana awaika ka yauni, Saba kom ku wona kairavina sewari ana terekirana.” Damanina sewari ");
INSERT INTO mwc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","si tere kikirana wai iyana si kona sasara, ba sewari yoginaikei sita tamorebu. ");
INSERT INTO mwc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Damanina turaturasi waka kesanai si mamana wai si rutapieisi sita botu siti baisisi. Ba si botu waka ruwamo si bonuvisi wai si dagui si raukwauruba. ");
INSERT INTO mwc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Maranai Simon Peter nikona i kinani wai i maere sogasoga Iesu naonai ba i wona, “Bada ki sumariku yauku piraga goyo pipiyiku.” ");
INSERT INTO mwc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon Peter turaturana ereonowasi yabata, iyana pesara si konai wai si wareyei. ");
INSERT INTO mwc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ba yebo Zebedee natunatuna James ba John yabata. Iesu Simon kurina i wona, “Kega ke nagara, karaku ba mara murinai, kom pipiya kuna banotisi.” ");
INSERT INTO mwc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Damania waka toreyai si taina gegeyana, ba sawara ereonowasi si sumamarana, ba Iesu si saununuri. ");
INSERT INTO mwc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu meyaga kesanai i mamana maranai, sebare kesana lepa gubagina sinina i bonuvei wai i botu kurina. Ba Iesu i kinani wai naonai i peku ku tano ba i babai i wona, “Bada kuna wainei wai kuni yawasiku.” ");
INSERT INTO mwc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu yarona i bororona sebarena i borubai ba i wona, “Yauku awaiwainei, ke yawasa!” Ba mara kesana Lepa sebarena i kasibautaveyei. ");
INSERT INTO mwc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Damanina Iesu sebarena i kaotunei i wona, “Kega kesana kotoi kuna wonei, saba totorina ke nae Priest kurina, ba sinim ki beyei ina kinani. Ba Moses i kaotunei wai nanakasike, ke puyobunuwa ba, pipiya ereonowasi kurisi kuni debeim kata kom ku yawasa.” ");
INSERT INTO mwc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Saba Iesu warana i rakata kupura ereonowana i yauni, ba pipiya korotosi si botu siti taina baenegei, ba kasi gubaga iti yawasana. ");
INSERT INTO mwc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Saba Iesu mamanina i nesaira ku kupura mamawapasi, ba namai i raupari. ");
INSERT INTO mwc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mara kesana, Iesu ibi beyebeyena maranai, Pharisee mutusi ba giugiu biyisi meyaga ereonowasi yai si botu, Galileeyai, Judiya ba Jerusalem yai si botu ba naikakaraku si makira si mamana. Ba Bada ana maragata yebo nai Iesu gwabinai imamana kata, pipiya gubagubagisi iti yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ba pipiya mutusi sebare kesana sinina raobona kemakemai si kabari si botuwei, ba asi waina sita yauni sita riu, ku yove kamona Iesu naonai siti dauvei. ");
INSERT INTO mwc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Saba kega rubana sita yauni sita riu, kairavina koroto i rakata, ba keta kega. Kona kairavina ku wadakupuna si kabari si gae, ba wadakupuna si rebui, ba kemakemai si sonagi i gakira koroto ku basusi, ba Iesu naonai si dauvei. ");
INSERT INTO mwc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Maranai, Iesu asi bi geruwana i kitai wai, sebarena kurina i wona, “Kwaina, am piraga goyo a notataveyisi.” ");
INSERT INTO mwc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Saba giugiu biyisi ba Pharisee biyisi i kesisi nuwanuwasi yai si nuwasuya si wona, “Niko meo sebare wai e kao bigigima? God i kesina wata piraga goyo ina nota taveyisi ba kega kesana kotoi.” ");
INSERT INTO mwc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu asi nota i kuiri wai kurisi i wona, “Awaika kairavina nikasike ko nuwanuwasuya? ");
INSERT INTO mwc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Meo sisiya rumatarina, am piraga goyo a nota taveyisi, kona ana wona, ke bomsiri ba ke yewo? ");
INSERT INTO mwc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Saba kona kuiri Sebare Natuna bai maragata i yauni kata dobuwai piraga goyo ina nota taveyana ba i wona, nao sebare sini raoboraobona kurina, “Kemsiri, am yagoro ke yauni ke nae ku yove.” ");
INSERT INTO mwc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ba mara kesana i bomsiri pipiya ereonowasi matasi yai, ana aba dudauwa i yauni, ba God i bokabakabari i nae ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pipiya ereonowasi si wareyei, ba si nuwasuya kabakaba, ba God sibo kabakabari si wona, “Karaku wose kaimasivisi kega meyana ka kinakinana wai ka kinana.” ");
INSERT INTO mwc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kona murinai Iesu i kasibau, ba tax aba yuyauna sebarena, ana bagibagi yovenai i makira i mamana wai i kitai. Iesu i wona ki sununuriku ");
INSERT INTO mwc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ba Levi i bomsiri sawara ereonowana isu mamarana, ba isu nunuri. ");
INSERT INTO mwc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Damanina ba Levi Iesu kairavina ana yoveyai kam kaikapona i wosei, ba tax aba yuyauna biyisi pesarisi ba pipiya mutusi yabata i yorisi si botu ba si kamkam. ");
INSERT INTO mwc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Saba, Pharisee ba giugiu biyisi, kosi asi duwu kesanina. Si botu Iesu ana Nonorayauna kurisi mena si gwini, si wona, “Awaika kairavina komi piraga goyo pipiyisi ba tax aba yuyauna biyisi yabata ko kamkam?” ");
INSERT INTO mwc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu i kaobeyisi i wona, “Pipiya yawayawasisi kega asi waina Doctor saba gubagubagisi wata. ");
INSERT INTO mwc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yauku kega pipiya gairesi kairavisi a botu, saba piragagoyo pipiyisi ata yorisi kata siti nuwabirabira.” ");
INSERT INTO mwc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pharisee si gwini si wona, “John ana Nonorayauna tebi siya ba te raupari, ba yakai yebo, ama Nonorayauna yabata. Saba kom am Nonorayauna wai te kamkam ba te tomatoma bonabona.” ");
INSERT INTO mwc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu i kaobeya i wona, “Komi ami waina tabine wau sebarena kana bonunu yabata te mamana wai kona wosisi sini siya kona? ");
INSERT INTO mwc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Saba mara ebotubotu kata tabine wau sebarena kamosi yai sina yauna taveyei, kona maranai kosi sini siya.” ");
INSERT INTO mwc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu niko wona bi maibai kurisi isisiya i wona, “Kega kesana kotoi gara wauna ina sikai ba gara katamanina tepanai ina popo ratui, ina wosei wai karaku wata gara wauna ina tamosika. Ba gara wauna gara katamanina yabata kana kinana ina rusisirei. ");
INSERT INTO mwc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ba kega kesana kotoi wine wauna, wine katamanina kana ku dubi ina sewai, ina wosei wai, dubi ini kwata, ba wine ina soro ba dubi ina goyo. ");
INSERT INTO mwc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wine wauna wai wine kana dubi wauna ku kamona mena sina sewai. ");
INSERT INTO mwc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ba kega kesana kotoi wine wauna tomanina ana waina kairavina i wona kata wine katamanina tomanina, i gaire saki”. ");
INSERT INTO mwc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabbath kesana, Iesu wheat baosi kamosi yai wata i yewo i nenae, ba ana Nonorayauna wheat uwasi si pokepoke, ba yaro kamosiyai si gosogoso ba si kamkam. ");
INSERT INTO mwc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba Pharisee mutusi si wona, “Awaika kairavina ata giu i wona kata Sabbath maranai niko wose kega kota wosei saba ko wosewosei?” ");
INSERT INTO mwc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu i kaobeyisi i wona, “Komi David ana pipiya yabata soya si rabobo maranai, awaika si wosei wai ko baiyavi kona kega? ");
INSERT INTO mwc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I rui God ana ku yove kamona ba God si puyoi wai kamna i yauni i kani ba mutuna ana pipiya i berisi si kani, saba ata giu i wona kata kega kesana kotoi wata niko kam ita kani saba priest wata sita kani.” ");
INSERT INTO mwc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ba damanina Iesu kurisi i wona, “Sebare Natuna wai Sabbath badana.” ");
INSERT INTO mwc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yebo Sabbath kesana, Iesu i riu ku duvu yovena ba i giugiu. Ba sebare kesana yaro kasauna raobona yebo namai i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pharisee ba giugiu biyisi Iesu sibo kibukibui kata pipiya kesana Sabbath maranai iti biyawasi wai siti kunumakei. ");
INSERT INTO mwc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Saba Iesu awaika si nosinosi wai i kuiri, ba sebare yarona raobona kurina i wona, “Ke gae pipiya ereonowasi naosi yai kuni imsiri.” Damanina i bomsiri ba i gae pipiya naosi yai i imsiri. ");
INSERT INTO mwc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesu i wona, “Ata toirubaimi kata, ata giu awaika ebi damaninei Sabbath marana gairena tana wosei kona, goyona tana wosei? Pipiya ana yawasa tana kasi bai goyoni kona, tani yawasi?” ");
INSERT INTO mwc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ereonowasi i kita nanagisi ba sebarena i wonei, “Yarom ke kotoi.” Ba yarona i kotoi maranai wai, yagiyagina wata i yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Saba kosi si yagisi saki, ba kosi wata si sisiya, kata awaika sita wosei Iesu kurina. ");
INSERT INTO mwc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kona maranai Iesu i gae koya baranai ita rupari, ba kona pomnai God kurina i rupari maratom. ");
INSERT INTO mwc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ba mara i tom wai, ana Nonorayauna i yorisi si nae kurina, ba asi twelve i bineisi ba i yoreisi Apostle. ");
INSERT INTO mwc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon kana waba i yorei Peter ba tuwa teina Andrew, James ba John, Phillip ba Bartholomew, ");
INSERT INTO mwc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, ba Thomas, Alpheus natuna James, ba Simon kona si yorei Zealot. ");
INSERT INTO mwc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","James natuna Judas ba Judas Iscariot, muriyai kona ini wawanei. ");
INSERT INTO mwc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ba yabata si gakira, ana Nonorayauna ba koroto kaikapona si mamana wai nakai. Ba yebo pipiya korotosi Judia kupurina ereonowanai, ba Jerusalem yai ba yebo tore biyisi Tyre ba Sidon, ");
INSERT INTO mwc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Si botu sita nonori, ba kasi gubaga iti yawasa. Ba yabosi kanuma goyogoyosi sibi magoyoisi wai i yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ba pipiya ereonowasi asi waina kata, sita borubai, basuna maragata karinai i botubotu ba piiya ereonowasi si yawayawasa. ");
INSERT INTO mwc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ba ana Nonorayauna i kinakinanisi wai i wona, “Bibi gairenimi komi iyabomi moyamoyakimi basuna God ana basileiya wai komi karimi yai.” ");
INSERT INTO mwc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yebo i wona, “Bada ini gairenimi komi soya karaku ko raoboraobo wai, kona kam siyabagi.” Ba i wona, “Bada ini gairenimi komi karaku ko tutou wai, kona maniba. ");
INSERT INTO mwc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bibi gairenimi komi maranai pipiya kurimi sini yagisi, maranai si nane kupukupusimi ba sina yegaimi, ba Sebare Natuna kairavina kami waba sina kao bigoyoni, ba sini sinikikiyimi. ");
INSERT INTO mwc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kona maranai ki nuwagaire ba ke riku basuna am maisa wai sapamai i rakata saki e mamana. Kairavina tamatamasi wai yebo nanakasike peroperoveta si wosisi. ");
INSERT INTO mwc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Saba komi iyabomi karaku ko mariya wai, kurimi ina goyo saki kairavina matapa koi nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ba iyabomi karaku ko kam siyabagi wai, komi kurimi ina goyo saki kairavina komi soya kona rabobo. Ba Komi iyabomi karaku ko manimaniba wai, kurimi ina goyo saki kairavina koni yapoya ba kona tou. ");
INSERT INTO mwc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Maranai komi pipiya ereonowasi sina kao bai gegaenimi wai, komi kurimi ina goyo saki, kairavina tamatamasi nanakasike peroveta kwarukwarumisi si woseisi. ");
INSERT INTO mwc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Saba komi iyabomi ko nonoriku wai a wonewonimi, kami abiya koi nuwa yauyaunisi, iyabosi kurim tebi yagisi wai gairena kurisi ko wosei. ");
INSERT INTO mwc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ba kosi iyabosi kawasiyai te kao nawaimi wai koi gairenisi ba iyabosi wose goyona kurim sina wosei wai kairavisi ko rupari. ");
INSERT INTO mwc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kotoi wata nebanebam ina ravi wai ki kam tabirim yebo newana ina ravi. Ba kotoi wata kam tara sowo ina yauni wai ke boterei yebo kam kwama ina yauni. ");
INSERT INTO mwc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pipiya ereonowasi abi sawara kairavina sini baba wai ke berisi, ba maranai kotoi wata am bi sawara ina yauni wai kega ki babai kata ini neveramagei. ");
INSERT INTO mwc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Awaika am waina pipiya kurim sina wosei wai, kesanina yebo kurisi ke wosei. ");
INSERT INTO mwc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pipiya tebi nuwayuyaunim wai kosi wata kuni nuwayuyaunisi wai, awaika kairavina bi gairena kuna yauni? Piraga goyo pipiyisi yebo, wosena kesanina te wosewosei. ");
INSERT INTO mwc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba pipiya wose gairena kurim te wosewosei wai kosi wata kurisi wose gairena kuna wosei wai, awaika kairavina bi gairena kuna yauni? Piraga goyo pipiyisi yebo, kona wosena te wose wosei. ");
INSERT INTO mwc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ba pipiya iyabosi am berena sini sarobi wai kosi wata kurisi kuna berena wai, awaika kairavina bi gairena kuna yauni? Kairavina piragagoyo biyisi yebo, piragagoyo pipiyisi kurisi te bereberena, kata asi waina awaika si berena wai tupana sina yauna meyei. ");
INSERT INTO mwc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Saba kami abiya koi nuwayauyaunisi, ba kurisi gairena ko wosei. Ko berena kurisi wai kega karisiyai bisarobina kona nosi. Ba ami maisa wai ina rakata saki kona yauni ba God kaidamona sakina ini natunatunimi. Basuna pipiya goyogoyosi ba pipiya kega tebi kaikaiwa wai, kurisi ebi yagaire. ");
INSERT INTO mwc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ba Tamami mekabage ebi nuwanuwanimi wai, komi yebo nanakasike koi nuwanuwana. ");
INSERT INTO mwc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Pipiya kega koni buibuiyisi, ba God yebo kega ini buibuiyimi. Pipiya kega kona kao bi goyonisi, ba God yebo kega ina kao bai goyonimi. Pipiya asi goyona ko nota taveyisi ba God yebo ami goyona ina nota taveyisi. ");
INSERT INTO mwc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ke berena ba God ina bere sakiyim, rukosokosovina ba boraturatuna ba ina kam sewasewai ku tokarami ini utusewai. Abi rubai kuna berena wai rubana kesaninai ina berim”. ");
INSERT INTO mwc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ba Iesu niko bai maibai kurisi i sisiya i wona, “sebare mata potapotana kega rubana sebare mata potapotana kesana ini naovei, ini naovei wai, asi ruwamo ku dogu sina peku. ");
INSERT INTO mwc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kega kesana meo kiruma ipiya ana bi beyebeyena biyina ina getawani, saba maranai ana kiruma ini kakabi wai asi ruwamo wai bi poponisi. ");
INSERT INTO mwc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Awaika kairavina momokara kwainam matana kamonai ke kinakinani, ba kom keyama dobona matam kamonai e mamana wai kega ke kina kinani? ");
INSERT INTO mwc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mekabage kwainam kurina kuna wona, Kwaina ke botu matam kamonai momokara ana botaveyei, ba kom i kesim mata kamomi yai wai keyama dobona kega ke kitakitai. Kom kwarukwarumim kainaona matam kamonai keyama dobona ke kaibotaveyei, kata kuni kinana kabitam wai, kwainam mata kamonai momokara kuna botaveyei.” ");
INSERT INTO mwc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Keyama gairena kega rubana uwana goyona ina uwei, ba keyama goyona kega rubana uwana gairena ina uwei. ");
INSERT INTO mwc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Keyama ereonowasi uwasiyai ba ta kuikuirisi. Pipiya koveya kega keyama biru goragoranai te pokepokei, ba grape kega sinamona ere rurirurina tepanai te pokepokei. ");
INSERT INTO mwc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pipiya gairena sawara gairesi nuwanuwanai i gaeni wai, ebi irakaibuwana. Ba pipiya goyona yebo, sawara goyosi nuwanuwanai i gaeni wai, ebi irakaibuwana. Basuna awaika nuwanuwanai i bonuwa wai, kawanai e kasikasibau. ");
INSERT INTO mwc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Awaika kairavina ko yoreyoriku ko wonawona, Bada, Bada ba saba awaika a wonimi wai kega ko wosewosei? ");
INSERT INTO mwc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kotoi wata e botubotu kuriku ba wonaku e nonori, ba e wosewosei wai kona pipiyina ani beyimi kona kuiri, kata kona kana kinana mekabage ");
INSERT INTO mwc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kona wai bage, pipiya ana yove bowaina kairavina, dogu i karoi i gakira saki, ba ana tukeke akima tepanai i totori wai rutainina. Ba kabaita i kasibau wai okowa maragasina yove i ravi, saba yove kega i nuke, basuna ana yove i bowa kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Saba kotoi wata wonaku e nonori, ba kega e wosewosei wai, kona pipiya ana yove tano tepanai i bowa momei rautinina, kega ere buna. Ba maranai kabaita i kasibau yove i ravi wai, yagiyagina wata ina peku. Ba ana pekuna wai ina goyo saki.” ");
INSERT INTO mwc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu nikosi sawara ereonowasi, pipiya kurisi i sisiyana i kakaba wai, i nae ku Capernaum. ");
INSERT INTO mwc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ba namai Capernaum kamonai, Rome biyisi asi abiya badana kesana i mamana. Ba ana saibisaibirina kaimatanina kesana, i gubaga saki yoginaikei ba ita rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Abiya badana sisiya i nonori kata Iesu i botu, wai Jews asi pipiya kaikaposi i poraisi, kata Iesu siti babai ita botu ba, ana saibisaibirina iti yawasi. ");
INSERT INTO mwc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Maranai si botu Iesu kurina wai, si baba sakiyei si wona, “Niko sebare kuti baisi, kona wai sebare gairena. ");
INSERT INTO mwc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ata pipiya i nuwayauyaunisi ba kona ata duwu yovena i bowai.” ");
INSERT INTO mwc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Damanina ba Iesu i tauya yabata si nae, matapa ku yove si veravera kasibau, ba bi abiya badana turaturana i poraisi niko sisiya sita wonei. Si wona, “Bada, kega kuriku botu kairavina kuni nuwapoyei, yauku kega pipiya gaireku ba au ku yove kuna riu.” ");
INSERT INTO mwc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","I kesiku a nota meyiku kata yauku kega damaniku ba ata botu kurim, saba namai wona wata ke wonei ba au saibisaibirina ina yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yauku babada kaikaposi gaburisiyai abo bagibagi, ba gaburikuwai yebo bibi abiyisi te mamana. Nikona ana wonei ke nae, ba ina nae, ba nokona ana wonei ke botu, ba ina botu. Ba au saibisaibirina ana wonei nikona ke wosei ba ina wosei. ");
INSERT INTO mwc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu niko sisiya i nonori wai, abiya badana i wareyei. Ba i taibira koroto si kibikibi wai kurisi bai wona, “Awonewonim, ke memena Israel kamonai bi geruwana kaikapona nikasike a panani.” ");
INSERT INTO mwc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Damanina abiya badana turaturana si veramaga ku yove wai, saibisaibirina yawayawasina si kitai. ");
INSERT INTO mwc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kona murinai, Iesu i nae ku meyaga kaikapona kesana, kana waba Nain, ana Nonorayauna ba koroto kaikapona yabata si nae. ");
INSERT INTO mwc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iesu i nae meyaga kaikapona ku matam ketana i veravera kasibau ba, pipiya mutusi sebare raoboraobona si kabari si kasikasibau. Kona wai wasike sobesoberena kesana natuna sebare kesanaikei. Ba meyaga kamonai, koroto kaikapona wasikena yabata si kasikasibau. ");
INSERT INTO mwc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Maranai Bada wasikena i kinani wai i nuwapoyei ba i wona, “Kega ke tou.” ");
INSERT INTO mwc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Damanina ba i yewo i nae kemakema i borubai ba pipiya iyaboi si kabari si nenae wai, si imsiri ba Iesu i wona, “Sebareikei a wonewonim, ke bomsiri.” ");
INSERT INTO mwc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Damanina sebare raboraobona i bomsiri i makira, ba bisisiya i dagui, ba Iesu i yauni sinana i bere meyei. ");
INSERT INTO mwc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pipiya ereonowasi si nagara saki, ba God sibo kabakabari ba si wona, “Peroveta kaikapo sakina kamotiyai i rerematara. God i botu ana pipiya ini baisisi.” ");
INSERT INTO mwc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ba Iesu awaika i wosei wai, warana i rakata Judia tupana i bonuvei, ba yebo kupura gwabisiai yabata. ");
INSERT INTO mwc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John ana Nonorayauna si nae nikosi wose ereonowana John kurina si sisiyei wai, ana Nonorayauna ruwamo i yorisi. ");
INSERT INTO mwc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ba i poraisi Bada kurina siti toiruba. Sita wona, “Pipiya kapotapotai ita botu wai damanina kom, kona, pipiya kesana kana potai?” ");
INSERT INTO mwc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Maranai, si botu Iesu kurina wai si wona, “John babataito biyina i poraikai kata toirubaim. Kata, pipiya ka potapotai ita botu wai, damanina kom kona, pipiya kesana kana potai?” ");
INSERT INTO mwc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kona maranai, Iesu pipiya pesarisi kasi gubaga i yawasisi ba yebo gubaga bubausiyai ba kanuma goyogoyosi i kasibaunisi. Ba mata potapotasi pesarisi i wosisi si kinana. ");
INSERT INTO mwc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kona kairavina John ana Kawariyonayona i kaobeyisi i wona, “Ko veramaga ba awaika ko kitai ba ko nonori wai John ko wonei. Mata potapotasi tebi kinana, digadigasi te yewoyewo, iyabosi lepa si yauni wai si yawasa, ba taina potapotasi te nonora, raoboraobosi si bomsiri mena, ba moyamoyakisi wara gairena te noonori. ");
INSERT INTO mwc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Koitoi wata ini geruviku ba ana nota kega ina kairagaraga wai God ini gaireni.” ");
INSERT INTO mwc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John ana kawari yonoyona si kasibau taveyana murinai, Iesu i dagui koroto kurisi John ibi sisiyei. I wona, ko kasibau ku kupura momna wai, awaika kota kitai? Gwanewa sibe i tapitapi kota kitai kona? ");
INSERT INTO mwc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ko kasibau awaika kota kitai? Sebare gara gaigairesiya i kaubunaga wai kota kitai kona? Kega, yabosi gara monimonikisi te kotekote ba tema kamkam mom wai, kosi taupauma asi yove kamosiyai te mamana. ");
INSERT INTO mwc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Saba ko kasibau awaika kota kitai, Peroveta kota kitai kona? Eee, bisuwona, saba a wonewonim kona wai kega Peroveta mom, ba saba Peroveta kaikapona kesana. ");
INSERT INTO mwc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Niko pipiya kairavina kiruma katamanisiyai si kiruma si wona, God i wona, “Au kawari yonayona ani porai ini nao ba kairavim keta ina bobunagi.” ");
INSERT INTO mwc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A wonewonim John wai pipiya kaikapo sakina, kega kesana kotoi niko dobuwai i getawani. Saba kotoi wata God ana basileiya kamonai ina terekireina meyei wai, kona pipiyina wai i rakata saki John i getawani. ");
INSERT INTO mwc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pipiya ereonowasi ba yebo tax aba yuyauna damsi yabata maranai Iesu wonana si nonori wai si damaninei kata God ana keta wai keta damana. Kairavina matapa si bosisira ba John i babataitoisi. ");
INSERT INTO mwc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Saba Pharisee ba giugiu biyisi ikesisi God ana keta si sinikikiyei kairavina kosi si totoyana wai John kega i babataitoisi. ");
INSERT INTO mwc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yebo Iesu i wona, “Niko kimta pipiyisi mekabage ana tere gubaisi? Kosi kasi kinana mekabage? ");
INSERT INTO mwc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kosi wai, pipiyaguna aba gimogimona gawarinai te makimakira, ba te paraparara tebi kaoboneyana wai, rutainisi. Duvu kesana sina para duvu kurisi sina wona, yakai kairavimi kai durere ba kega ko riku, ba rabobo taborina ka taborei, saba kega ko tou. ");
INSERT INTO mwc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","John Babataito biyina i botu i siya, ba kega wine i tomatomani, ba komi ko wona kata, kona kanuma goyona kamonai e mamana.” ");
INSERT INTO mwc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ba Sebare Natuna i botu e kamkam ba e tomatoma, ba komi ko wona, Niko sebare ko kinani, toma neganegana, ba kam woraworana. Piraga goyo pipiyisi, ba tax aba yauyauna damsi kwainasi. ");
INSERT INTO mwc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Saba iyabosi God ana nuwasuya si yauni te kibikibi wai, asi yawasai sini mamatarei, kata bisuwona kona wai nuwasuya damana. ");
INSERT INTO mwc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee kesana Iesu i yorei kata, rabisi kamna ana yoveyai sita kam yabata. Damanina Iesu i nae Pharisee ana ku yove ba nebanebanai i kasi makirei ba si kamkam. ");
INSERT INTO mwc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kona meyaginai wasike kesana ana yawasa kamonai piraga goyowai i mamana. Ba maranai i nonori kata Iesu Pharisee ana yove kamonai i kamkam wai, bane dubina i yauni i botu, ");
INSERT INTO mwc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iesu murinai i msiri i tutou, ba mata okovinai kaekaena i sorupisi. Ba uyavinai kaekaena i kasipupunisi, ba ibo yoyaona, ba bane ku kaekaena mena i utusewai. ");
INSERT INTO mwc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ba nao Pharisee niko wose i kitai wai, nuwasinenai i wona, “Niko sebare bisuwona kona Peroveta wai, ita kuiri kata kotai i borubai, ba kona abi wasike? Kona wai piraga goyo wasikena.” ");
INSERT INTO mwc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu i kaobeyei i wona, “Simon, sawara kesa ana wonim.” Simon i wona, “Eee damanina, bai beyebeyena biyim ke woniku.” ");
INSERT INTO mwc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu i wona, “Sebasebaresi asi ruwamo money aba bereberena sebarena karinai kasi taraboga si mamana, kesana kana taraboga five hundred kina ba kesana wai fifty kina. ");
INSERT INTO mwc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba asi ruwamo karisiyai money kega ba kasi taraboga sita saroba, kona kairavina wai damanina sebasebaresi asi ruwamo kasi taraboga i kasipupuna, ba i nota taveyisi. Meo sebare ke nosinosi ini nuwa yauyauna sakiyei?” ");
INSERT INTO mwc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon i kaobeyei i wona, “Anosinosi kata kotoi kana taraboga kaikapona i kasipupuni wai kona.” Iesu i wona, “Ku kaobeyana kabitam.” ");
INSERT INTO mwc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Damanina i taibira wasike kurina, ba Simon kurina i wona, “Niko wasike ku kitai? A botu am ku yove ba kaeku kairavisi okowa kega ku beriku, saba kona mata okovinai kaeku i sorupa ba uyavinai i kasipupuna. ");
INSERT INTO mwc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ba kega ku yaoniku, saba niko wasike a riu maranai kaeku yaonisi i dagui ba kega i boterei. ");
INSERT INTO mwc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kom gayamiku kega monamonai kui boroi, saba kona baneyai kaeku i boroi. ");
INSERT INTO mwc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kona kairavina a wonewonim, ana nuwayuyauna i rakata kairavina, ana piraga goyo pesarina a nota taveyei. Saba, kotoi wata ana nuwayauyauna yogina mom ini mamatarei wai, ana piraga goyo yogina mom wata ana nota taveyei.” ");
INSERT INTO mwc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Damanina Iesu wasikena i wonei, i wona, “Am piraga goyosi a nota taveyisi.” ");
INSERT INTO mwc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pipiya mutusi si makira si kamkam wai si dagui i kesisi kamosiyai sibi kaoboneyana si wona, “Niko pipiya kona kotoi wai yebo piragagoyo e notanota taveyana?” ");
INSERT INTO mwc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Saba Iesu wasike kurina i wona “Am bigeruwana i yawasim, nuwanubai ke nae.” ");
INSERT INTO mwc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kona murinai, Iesu meyaga ba kwanatu nununsiyai i yewo neubuwa. Ba God ana basileiya warana gaireni i rumamarei ana Nonorayauna asi twelve yabata. ");
INSERT INTO mwc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ba yebo bibaine mutusi gubagubagisi i yawasisi, ba kanuma goyogoyosi karisiyai i kasibaunisi wai, yabata si nae. Bage Mary, kona si yorei Magdalene, kona karinai kanuma goyogoyosi asi seven i kasibaunisi. ");
INSERT INTO mwc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kesana wai Joanna, kona kaoana Cuza, Herod ana yove kana aba potapota sebarena. Ba yebo Susanna, ba bibaine pesarisi yabata. Nikosi bibaine i kesisi asi maragatai Iesu ana Nonorayauna yabata si potapotaisi ba si baisisi. ");
INSERT INTO mwc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pipiya meyaga bubausi yai Iesu si notuwei, ba koroto i rakata saki maranai, Iesu nikasike kurisi i maiba ");
INSERT INTO mwc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","i wona, “Mara kesana, baobao biyina i kasibau ana pesi ita baoni, ba maranai ana pesi i raubusagi wai, mutunsi si peku ku keta ba pipiya si utu gudai, ba manu si botu si kam roboi. ");
INSERT INTO mwc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ba mutusi si ririga tano ku akiyakimina mena, ba saba tano gasara taveyina kairavina, si rutiti wai sibo sivisiviyisi. ");
INSERT INTO mwc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mutusi si ririga ku sinamona kamosi, ba sinamona yabata si rautiti wai, sinamona si piro bunuwana. ");
INSERT INTO mwc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ba yebo mutusi si ririga tano ku gairena mena, ba si rutiti si gae wai, uwana hundred si uwei. Nikona i sisiyei i kakaba wai, i para i wona, “Kotoi wata ere tinam wai ke nonora kabitam!” ");
INSERT INTO mwc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niko bai maiba basuna kairavina ana Nonorayauna si toirubai wai i wona, ");
INSERT INTO mwc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Komi God ana Basileiya mama bi buneyina kuirina ko yauni, ba pipiya mutusi kurisi wai abi maiba, kata sina kinana, ba kega sina kinani, ba sina nonora, ba saba kega sina kuiri.” ");
INSERT INTO mwc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Niko bimaiba basuna wai nikasike, pesi wai, kona God wonana. ");
INSERT INTO mwc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pesi si ririga ku keta wai, bage iyabosi God wonana si nonori, saba satan i botu, ba nuwanuwasi yai i yauna taveyei. Kata sina kayo bi geruwana ba sita yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ba pesi si si riga tano ku akiyakimina wai, bage kosi iyabosi God wonana ere nuwagairesi si nonori, saba kega i gakira ku nuwa sinesi. Kosi si geruwana mara soenaikei ba rauruba marana i botu wai si peku. ");
INSERT INTO mwc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ba pesi si ririga sinamona kukamona wai, bage kosi iyaboi God wonana si nonori, ba saba niko dobu yawasina, ba mariyina, ba nuwagairena yapoyina i piro bunuisi wai, kega si uwa. ");
INSERT INTO mwc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ba pesi si ririga tano ku gairena wai, bage iyabosi God wonana si nonori ba nuwagaire yai si yauni, ba si bosisiri. Ba simsi kikita wai si uwa. ");
INSERT INTO mwc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kega kesana kotoi kibe i kapuni ba kabomai i kasitawani kona kemakema gaburinai i terei. Kega, saba yasegana kana bi rorokeyai tebi rorokei kata pipiya ku yove sina riuriu wai yaseganina sina kitai. ");
INSERT INTO mwc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Awaika wata mama bi buneyina ina yauni ina kasibau ini debei. Ba awaika wata kasikasi tawanina, ina panani ba ina yauni ina kasibau ku yasegana. ");
INSERT INTO mwc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kona kairavina awaika ko nonori wai, ko nuwasuya kabitam, basuna kotai wata karinai awaika emamana wai, tepanai yebo ina beremeyei. Ba koitoi wata karinai kega kesana awaika emamana wai, karinai awaika soesoenaikei emamana wai, ina yauna taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Damanina Iesu sinana ba teiteina si botu sita kitai, saba koroto i rakata saki kairavina kega rubana sita riu kurina. ");
INSERT INTO mwc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ba pipiya kesana Iesu i wonei, i wona, “Sinam ba titeim wai matarai tebi potapota, asi waina sina kinanim.” ");
INSERT INTO mwc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Saba Iesu i kaobeya i wona, “sinaku ba teiteiku wai iyabosi God wonana te nonori ba te bosisiriei wai.” ");
INSERT INTO mwc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mara kesana, Iesu ana Nonorayauna i wonisi i wona, “niko boga tani garubonei no ku sepina.” Damanina si geru ku waka ba si tauya. ");
INSERT INTO mwc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sibi garubona maranai Iesu waka kamonai i kenokira ba i kenowapa i dudauwa ba sibe goyona i bomsiri, ba waka okowa i siusiuni wai, yogina mom sita rukwauruba. ");
INSERT INTO mwc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana Nonorayauna si rubaunui ba si wona, “Bada! Bada! kota tana toma bunuwa.” Iesu i bomsiri sibe ba yoyo i kaotuneyisi, ba sibe i boterei ba nisa i niworovi. ");
INSERT INTO mwc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Damanina ana Nonorayauna i wonisi i wona, “Ami bai geruwana memena?” Saba kosi si nagara, ba si wareyei, ba si kaoboneyana si wona, “Niko sebare wai, kona kotoi? Wai sibe ba yoyo e kaotuneyisi wai te bosisirei.” ");
INSERT INTO mwc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu ana Nonorayauna yabata Galilee tokana si garubonei ku sepina, Gerasenes biyisi asi ku kupura mena. ");
INSERT INTO mwc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu ku tore ibi sukira maranai, nao meyaga sebare kesana kanuma goyogoyosi kamonai si mamana wai, i verabeyei. Niko sebare mamanina ere nimanimana i mamana, ba kega yoveyai i mamana, saba karawaga nadegubisi kamosiyai i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Maranai Iesu i kinani wai i rasa, ba i peku ku kaena, ba i para i wona, “Iesu! God kaidamona sakina natuna, awaika ke wiwaini kuriku kuna wosei? Abi babaim kega saroba kuna beriku.” ");
INSERT INTO mwc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iesu kanuma goyona i kaotunei ita kasibau taveyei kairavina nikasike i wona. Mara pesarina kanuma goyona i riu ku kamona. Ba bagunai wata kaekaena ba yaroyarona chain yai pipiya si kau patupatuma, saba chain i yarayaraga, ba kanuma goyona ibi naorabei ku kupura momna mena. ");
INSERT INTO mwc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu i toirubai i wona, “Kom kam waba kotoi?” Ba kona i kaobeyei i wona, “Yauku kau waba wai koroto, basuna kanuma goyogoyosi pesarisi si riu ku kamoku. ");
INSERT INTO mwc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ba kanuma goyogoyosi Iesu si baba tupetupeni, kata kega iti poraisi ku sanaga kega ere pusirina mena. ");
INSERT INTO mwc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Saba namai koya baranai poro yaboyabo si kamkam, kanuma goyogoyosi Iesu si babai kata iti poraisi sita riu poro ku kamosi, ba damania i damaninei. ");
INSERT INTO mwc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba sebarena si kasibau taveyei maranai, si nae poro ku kamosi si riu. Ba poro ereonowasi koya tepanai si vera si gakira ku sanaga, si peku ba enagai si toma bunuwa. ");
INSERT INTO mwc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ba poro kasi abapotapota nikona si kinani wai, si vera si nae ku meyaga, ba kupura ereonowana awaika si kinani wai, si mamatarei. ");
INSERT INTO mwc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pipiya si kasibau awaika itupuwa wai kinanina kairavina. Ba maranai si botu Iesu kurina wai, nao sebare kanuma goyogoyosi si kasibautaveyei wai, ere garana ba gayamina i gaire Iesu kaenai i makira i mamana si panani wai, si nagara. ");
INSERT INTO mwc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iyabosi si kinani wai, pipiya si wonisi kata mekabage sebarena i yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba nao kupura pipiyisi ereonowasi si nagara saki wai, Iesu si babai kata ita kasibau taveyisi. Damanina Iesu i sugae ku waka ba i kasibau taveyana. ");
INSERT INTO mwc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ba nao sebare kanuma goyogoyosi si kasibau taveyei wai, Iesu i babai kata yabata sita nae. Saba Iesu i pora taveyei i wona, ");
INSERT INTO mwc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ke veramaga am ku yove, ba awaika God kairavim i wosei wai ki sisiyei. Damanina sebarena i nae meyaga kamonai i yewo, ba awaika Iesu kairavina i wosei wai i sisiyei.” ");
INSERT INTO mwc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Maranai Iesu i veramaga mena ku sepina wai, pipiya si vera beyei, basuna ereonowasi wai, kona si potapotai. ");
INSERT INTO mwc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kona maranai, duvu yovena badana kesana, kana waba Jairus i verakasibau, ba Iesu kaenai i peku, ba i baba sakiyei kata yabata sita nae ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Basuna natuna wasike kesanaikei, kana bodu twelve i raborabobo. Iesu ketai i yewo i nenae ba koroto i rakata saki si subibiri, ba si una takutakuri. ");
INSERT INTO mwc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ba kamosi yai wai, wasike kesana yabata, bodu twelve rubana ana tara i vera, saba kega kesana kotoi rubana iti yawasi. ");
INSERT INTO mwc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Koroto kamosi yai Iesu murinai wata i botu, ba kana gara kawa gepogepona i borubai, ba yagiyagina wata ana tara vera i boterei. ");
INSERT INTO mwc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu i toiruba i wona, “Kotoi i borubaiku?” Saba pipiya ereonowasi si buruburuwei. Peter i wona, “Bada, pipiya si koroto saki ba te unauna takutakurim.” ");
INSERT INTO mwc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Saba Iesu i wona, “Maranai maragata gwabikuwai i kasibau wai, a kuiri kata pipiya kesana i borubaiku.” ");
INSERT INTO mwc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ba nao wasike i kinani kata kona i rudeba, ba kega rubana ita koba wai, ere kirokirorona i botu, ba Iesu kaenai i peku. Ba nai pipiya ereonowasi matasiyai Iesu i wonei kata awaika kairavina i borubai, ba mekabage i yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu i wonei i wona, “Natuku, am bai geruana i yawasim, nuwanubai ke nae.” ");
INSERT INTO mwc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu karauwata i bisisiya, ba pipiya kesana duvu yovena badana ana yoveyai i wasaga i botu. Ba i wona, “Jairus natum wai i rabobo, ba giugiu biyina kega kuni sinikaini.” ");
INSERT INTO mwc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu i nonori wai Jairus i wonei i wona, “Kega ke nagara, ki geruwana mom ba natum ina yawasa.” ");
INSERT INTO mwc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I verakasibau Jairus ana ku yove maranai, pipiya ereonowasi i gesisi matarai si mana. Saba Peter, John ba James, ba pipiyaikei tamana ba sinana wata yabata si riu ku yove kamona. ");
INSERT INTO mwc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kona maranai pipiya ereonowasi pipiyaikei kairavina sibi nuwapoya, ba si tutou. Iesu i wona, “Tou ko botere, pipiyaikei kega i rabobo, kona wai i kenouwapa mom.” ");
INSERT INTO mwc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Saba kosi si bomanibei, basuna si kuiri kata kona i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Saba Iesu wasikeikei yarona i yauni ba i wona, “Natuku ke bomsiri.” ");
INSERT INTO mwc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kanumina i veramaga mena, ba mara kesana i msiri. Ba damanina Iesu i wonisi kata kam sita berei ita kam. ");
INSERT INTO mwc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana ba sinana si wareyei, ba Iesu ikao tunetuneyisi kata, awaika i tupuwa wai kega kesana kotoi sita wonei. ");
INSERT INTO mwc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu ana Nonorayauna asi twelve i yorisi si kesanisi wai maranai, bibadana ba maragata i berisi. Kata kanuma goyo goyosi ereonowasi sita rukwabina, ba gubaga bubausiyai siti yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Damanina i poraisi si kasibau, God ana basileiya sita rumamarei, ba gubagubagisi siti yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I wonisi i wona, “Kega kesana awaika wagawaga kairavina kona kabari. Kega ruwakuna kona kautu kona yauni, kona kam ba money, kona kwama kana bi rauwa kona yauni. ");
INSERT INTO mwc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Meo yoveyai sini payapayayim wai, kona yovenai kona mamana yepo, nao meyaga kona kasibau taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ba maranai pipiya kega sina verabeyimi ba sini kaikaivimi wai, nao meyaga ko kasibau taveyei. Ba kaemi popokauna ko kasi tatabi, ini beyisi kata God asi saroba ina berisi.” ");
INSERT INTO mwc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Damanina si tauya si nae meyaga nununai wara gairena si rumamarei, ba kupura ereonowanai pipiya gubagubagisi si yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Maranai Galilee kana taupauma Herod awaika ereonowana si tupu tupuwa i nonori wai, ana nota i kairagaraga. Basuna pipiya mutusi si wona wona kata, John babataito biyina raoboraobonai i bomsiri mena. ");
INSERT INTO mwc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pipiya mutusi si wona wona kata Elizah i rerematara. Ba yebo mutusi si wona wona kata, peroveta wadubona kesana rabobowai i bomsiri mena. ");
INSERT INTO mwc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod i wona, “John kamyona a wona wai si kasiyaragi. Saba niko sebare wai kona kotoi wai warana a noonori?” Ba i wosewose rubai kata Iesu ita kinani. ");
INSERT INTO mwc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu ana Nonorayauna si veramaga wai, awaika si wosei wai ereonowana si wonei. Damanina i urabaisi ba kosi wata si kasibau si nae ku meyaga kesana, ku Bethsida. ");
INSERT INTO mwc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ba pipiya korotosi si nonori wai si kibi. Damanina i kaikaivisi ba God ana basileiya warana kurisi i sisiyei. Ba iyabosi asi waina kasi gubaga iti yawasa wai i yawasisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rabisi pompom yai ana Nonorayauna asi twelve si botu kurina ba si wona, “Niko kupura wai kupura kabana, pipiya ki poraisi sina nae ku meyagai, kata kam sina panani ba sina kam ba sina dauwa.” ");
INSERT INTO mwc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Saba kona i kaobeyisi i wona, “Komi kam ko berisi sina kam.” Kosi si wona, “Yakai karikiyai wai iyana ruwamo ba bread asi five wata, ba niko wai, koroto i rakata saki, kega rubarubana kasi kam kana gimoni?” ");
INSERT INTO mwc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nao koroto kamonai wai sebasebare ereonowasi asi five thousand. Iesu i wona, “Pipiya ko tomgeyarisi kata pipiya asi fifty duwu nununai sina makira.” ");
INSERT INTO mwc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ana nonora yauna si wosei i kakaba wai pipiya ereonowasi si makira. ");
INSERT INTO mwc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Damanina bread asi five ba iyana asi ruwamo i yauna, i gagawa ku sapama i kaikaiwa, ba i kiya yaragana, ba ana nonora yauna i berisi kata pipiya siti kodisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pipiya ereonowasi si kam wai si kam siyabagi, ba ana nonora yauna puwata si utubitaura wai tegara asi twelve si bonuvisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mara kesana, Iesu i kesina i raupari ba ana Nonorayauna si botu kurina wai i toirubaisi i wona, “Pipiya ko nonorisi te wona wona kata yauku kotoi?” ");
INSERT INTO mwc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Si kaobeyei si wona, “Pipiya mutusi si wona, kom wai John Babataito biyina ba mutusi si wona Elijah, ba yebo mutusi si wona kata Peroveta katamanina kesana raoboraobona i bomsiri mena.” ");
INSERT INTO mwc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ba komi mekabae ko wona wona, ko nosinosi yauku kotoi?” Peter i kaobeyei i wona, “Kom wai Keriso God i poraim ku botu.” ");
INSERT INTO mwc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu sisiya padapadana i berisi kata nikona kega kesana kotoi kurina siti mamatarei. ");
INSERT INTO mwc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iesu ereonowasi kurisi i wona, “Sebare Natuna wose pesarina ina paiwarisi, kaikaiwabosi, ba Priest kaikaposi, ba giugiu biyisi sini sinikikiyei, ba sina kasibunui. Saba mara bai tonuina murinai ina bomsiri ba ina yawasa mena.” ");
INSERT INTO mwc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Damanina ereonowasi kurisi i wona, “Kotoi wata ana waina ini saununuriku wai, i kesina ini sini kikiyena meyei. Ba mara patepatena ana korosi ina kabari ba, ini saununuriku. ");
INSERT INTO mwc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Karavina kotoi wata am yawasa kairaviku ina kao taveyei wai, kega ini siwani, ba kotoi wata ana yawasa ina gegenuwei wai, ini siwani. ");
INSERT INTO mwc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Maranai dobu tupana ini karimi yai ba saba pipiyim kuni siwanim wai, awaika gairena kuna yoyoi? ");
INSERT INTO mwc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kotoi wata yauku ba wonaku ini sinimayei wai, maranai Sebare Natuna ana kadarai ba Tama ba aneya kaobaisiesi asi kadarai ina botu wai yebo, ini sinimayei. ");
INSERT INTO mwc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Abi suwonimi komi mutumi nina kom simsiri wai, God ana basileiya kona kaikinani ba muriyai kona robobo.” ");
INSERT INTO mwc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mara kesana, Iesu nikosi i sisiyana ba tapaoro kesana murinai, Peter, John ba James i urabaisi si gae koya ku tepana sita rupari. ");
INSERT INTO mwc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ba i raupari maranai naona, kana kinana i birai ba kana gara ibo poepoe ba i rauyasegana nanakasike bage ita bo kadari. ");
INSERT INTO mwc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sebasebare asi ruwamo Moses ba Elijah, ");
INSERT INTO mwc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ere kadarisi si rerematara ba Iesu yabata sibi sisiya. Kata Iesu mekabage God ana waina kairavina, Jerusalem yai ita rabobo, wai kona sibi sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter turaturana koi wai si dudauwa, ba maranai si kenomataka wai, Iesu ere kadarina si kitai sebasebare ruwamo yabata si imsimsiri. ");
INSERT INTO mwc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ba nakoi sebasebare Iesu sibi sumarei wai maranai, Peter i wona, “Bada, i gaire saki yakai nina, gweda tonu kana bowaisi, kesana kom kairavim, ba kesana Moses kairavina, ba kesana Elijah kairavina.” Kega i kuiri kata awaika ibi sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter karauwata ibi sisiya, ba guba i botu i sowoisi, ba guba ku kamona s riuriu wai Nonorayauna si nagara. ");
INSERT INTO mwc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ba guba kamonai gamo si nonori i wona, “Nikona yauku natuku au binebinena, gamona ko nonori.” ");
INSERT INTO mwc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gamo i sisiya i kakaba wai si kinana kata Iesu i kesina wata. Kona maranai nonora yauna awaika si kinani wai i kesisi nuwanuwasi yai sita tawani, ba kega kesana kotoi si wonei. ");
INSERT INTO mwc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mara i tom wai, ana Nonorayauna asi tonu yabata koyai si gakira, ba koroto kaikapona Iesu si verabeyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ba koroto kamonai sebare kesana i parara i wona, “Bi beyebeyena biyim! abi babaim natuku kuta kitai, basuna kona wai natuku sebare kesanaikei. ");
INSERT INTO mwc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ba kanuma goyona e yuyauni wai mara kesana erasarasa paraparaga, e paoropaoro ba e pekupeku, ba kawa puropurona te kasikasibau. Kega e boterei ba e kasikasi bi goyoni. ");
INSERT INTO mwc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Am nonora yauna ai babaisi kata siti kasibauni, saba kosi si wose kabai.” ");
INSERT INTO mwc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu i kaobeya i wona, “Komi pipiyimi bai geruwana kabakabaimi. Mara i veoroma meo rubana yabata tana mana ba ani beyebeyimi.” Ba sebarena i wonei i wona, “Natum ke botuwei.” ");
INSERT INTO mwc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sebareikei i yewo i botubotu wai, kanuma goyona i yauni ba i garukirei ku tano, ba i paoro, Saba Iesu kanuma goyona i rasa bokabari ba sebareikei i yawasi, ba tamana i bere meyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pipiya ereonowasi God ana maragata kaikapona si kitai wai, si wareyei. Iesu awaika i wosei wai pipiya karakuwata naki si wareyei si nenae, ba ana Nonorayauna kurisi i wona. ");
INSERT INTO mwc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Awaika ana wonimi wai ko nonora kabitamni. Pipiya kesana ina bomsiri ini wawana wai, yauku Sebare Natuna pipiya ku yarosi ina teriku. ");
INSERT INTO mwc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Saba Iesu ana nonora yauna nikona basuna si buruburuwei. Asi nota i kasi biwapawapai, kona kairavina basuna kega si kuiri. Ba kosi si nagara wai, kega si toirubai. ");
INSERT INTO mwc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mara kesana, Iesu ana Nonorayauna wata si dagui sibi kawapata. Kata kamosi yai, kotoi pipiya kaikapona. ");
INSERT INTO mwc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu asi nota i kuiri wai, pipiyaikei iyauni ba parinai imsiriyei. ");
INSERT INTO mwc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ba kurisi i wona, “Kotoi wata kau wabai niko pipiyaikei ini enoenowei wai, yauku ebi enoenoviku. Ba kotoi wata yauku ini enoenoviku wai kega yauku saba kotoi i poraiku wai kona ebi enoenowei. Kairavina kotoi wata ereonowami kamomi yai ebi muri kobokobowa wai, kona pipiya kaikapo sakina.” ");
INSERT INTO mwc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John i wona, “Bada sebare kesana ka kitai kam wabai kanuma goyosi i raukwabina, ba ka wonei kata ita boterei basuna kona kega kota ata pipiya.” ");
INSERT INTO mwc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu i wona, “Kega koi gesei kairavina kotoi wata kega ini abiyimi wai kona wai kwainami.” ");
INSERT INTO mwc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu ana gaena ku sapama marana i neratui kairavina nuwanuwana i tetei wai i tauya ku Jerusalem. ");
INSERT INTO mwc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ba kawari yonayona i poraisi si nao si nae, Samaria meyaga kesana ku kamona, namai kairavina sita bobunaga ba muri yai ita botu. ");
INSERT INTO mwc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Saba namai pipiya kega si verebeyei ba si enoenowei, basuna si kiuri kata kona i nenae ku Jerusalem. ");
INSERT INTO mwc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iesu ana Nonorayauna James ba John, niko wose si kinani wai si wona, “Bada am waina keyama kai karakarasina sapamai kana yore kirei ina karasisi kona?” ");
INSERT INTO mwc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu saba i taibira ba i yegaisi. ");
INSERT INTO mwc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ba ana Nonorayauna yabata si nae ku meyaga kesana. ");
INSERT INTO mwc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iesu ana Nonorayauna yabata ketai si yewo si nenai, ba sebare kesana i bomsiri Iesu i wonei i wona, “Memei wata kuna yewo kuna nae wai ana kibim.” ");
INSERT INTO mwc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu i kaobeyei i wona, “Dipa kukousi ere kasi nipona, ba kaidamona manusi ere kasi nigu, saba Sebare Natuna wai ana aba dudauwa gawarina kega.” ");
INSERT INTO mwc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sebare bauna yebo kurina i wona, “Ki sununuriku.” Saba sebarena i kaobeyei i wona, “Bada ke boteriku a nanae tamaku a na kai dogui.” ");
INSERT INTO mwc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu kurina i wona, “Raboraobosi ke boterisi i kesisi sina dogui meyisi, ba saba kom ke nae God ana basileiya kuna rumamarei.” ");
INSERT INTO mwc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ba sebare kesana yebo i wona, “Bada yauku au waina ana kibim, ba saba kainaona ke boteriku ana nae au rakaraka ana kai bi kiuruwisi.” ");
INSERT INTO mwc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu i kaobeya i wona, “Kotoi wata idagui e roberobe, ba erau sinimura wai, kona kega rubana God ana basileiya kamonai ina saibira.” ");
INSERT INTO mwc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nikona murinai, Bada ana nonora yauna asi seventy-two i bineisi ba ruwamoruwamo i poraisi siti nao sita nae, ku meyaga ba kupura ereonowasi mekei i nenae wai nakai. ");
INSERT INTO mwc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I wonisi i wona, “Boyauna wai i rakata saki ba saba saibirabiyisi wai kega pesarisi ko rupari boyauna badana kurina kata saibisaibirisi mutusi yebo ini poraisi ana ku bao mena sina boyauna. ");
INSERT INTO mwc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ko nae ba ko nosi kata abi poraimi wai sheep wotusi rutinisi kukou garagara kamosi yai kona yewo. ");
INSERT INTO mwc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kega money bobitaura, kona kautu, kona kami kae sumasuma kona kabara, ba ketai pipiya kega kona toriyisi. ");
INSERT INTO mwc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maranai meo ku yove kona riuriu wai, kainaona ko wona, nuwanuba niko yove yai ina mana. ");
INSERT INTO mwc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Memei bage yove kamonai nuwanuba sebarena ina mamana wai ami bi kaikaiwa ina yauni. Ba kega wai ami nuwanuba ina veramaga mena kurimi. ");
INSERT INTO mwc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nao yove yai koma kikita, ba kega yove bausi kurisi koi garubonabona. Ba awaika wata sina puyoimi wai ko kam ba ko toma, kairavina bagibagi biyisi wai asi maisa sina yauni. ");
INSERT INTO mwc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Maranai ku meyaga kona riu ba awaika wata sina puyoimi wai ko kam. ");
INSERT INTO mwc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nao meyaga pipiya gubagubagisi koi yawasisi ba ko wonisi kata God ana basileiya i botu gwabisi yai. ");
INSERT INTO mwc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Saba maranai kona riu ku meyaga, ba pipiya kega sini enoenovim wai, ko kasibau ku keta ba ko wona, ");
INSERT INTO mwc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ami meyaga popokauna kae kamoki yai ka kasikasi tatabisi. Kata komi wai God i kesina ina kasi bi goyonimi. Ba saba nikona wata kati nuwarupairimi, kata God ana basileiya i botu gwabimi yai. ");
INSERT INTO mwc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A wonewonim kata bi buibiuya maranai God Sodom ini nuwanuwani, ba nao meyaga kega ini nuwanuwani.” ");
INSERT INTO mwc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kiwayape Chorazin! ba yebo kiwayape kom Bethsaida! Komi kurimi wai ina goyo saki. Komi kamomi yai wose kaikaposi a wose wai, Tyre ba Sidon kamosi yai ata wosisi wai, pipiya matapanaki rowarowa garasi sita kote ba isarai siti guya, ba sita makira sita mamana. Siti mamatara kata kosi asi piraga goyowai si nuwa birabira. ");
INSERT INTO mwc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bi buibiuya maranai wai God Tyre ba Sidon ini nuwanuwanisi ba komi wai kega. ");
INSERT INTO mwc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ba kom Capernaum, ke nosinosi kata kom i kesim kuna bokabara meyim ba kuna gae ku sapama? Kega, kom wai kuna gakira ku keyama kai karakarasina. ");
INSERT INTO mwc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kotoi wata ini taina baenegimi wai, yauku ebi taina baenegiku. Ba kotoi wata ini sinikikiyim wai yauku ebi sinikikiyiku. Ba kotoi wata ini sinikikiyiku wai, kotoi i poraiku wai, kona ebi sinikikiyei. ");
INSERT INTO mwc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nakoi sebasebare asi Seventy-two ere nuwagairesi si veramaga ba si wona, “Bada, kom wabami yai kanuma goyogoyosi ka kaotunetuneyisi wai sibo sisirikai.” ");
INSERT INTO mwc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu i kaobeyisi i wona, “Satan a kinani sapamai i peku, nanakasike bage ita bokadari.” ");
INSERT INTO mwc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Maragata a berimi kata mota ba rido koni utu gudeyana, ba abiya ana maragata ereonowana kona bobainubai. Ba kega kesana awaika goyonai kurimi ina wosei. ");
INSERT INTO mwc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba kega kanuma goyogoyosi sibo sisirimi kairavina koi nuwagaire, saba koi nuwagaire basuna kami waba wai sapamai God i kiruma. ");
INSERT INTO mwc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kona maranai, Iesu Kanuma Kaoaobaisiyenai i nuwagaire saki wai i wona, “Abi kaikaivim Tama kom sapama ba dobu badana! Abi kaikaivim kairavina nikosi sawara wai pipiya kuikuirisi ba nuwanuwasuyisi kurisi mena kui buneyisi. Ba pipiya neganegasi kui beyisi, nikona mekabage am waina ita tupuwa wai i tupuwa. ");
INSERT INTO mwc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tamaku sawara ereonowasi i beriku, ba kega kesana meo pipiya i kuiri kata natuna wai kotoi, saba tamana i kesina wata. Ba kega kesa meo pipiya i kuiri kata tamana wai kotoi, saba natuna i kesina wata ba iyabosi natuna i binebineisi wai ini beyisi.” ");
INSERT INTO mwc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Damanina Iesu i kamtabiri ba ana nonora yauna wata kurisi i wona, “Koi nuwagaire saki kata nikosi sawara ko kinana. ");
INSERT INTO mwc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A wonimi, Peroveta ba Taupauma pesarisi si waini kata awaika ko kinani wai sita kinani, saba kega si kinani. Ba awaika ko nonori wai, sita nonori saba kega si nonori.” ");
INSERT INTO mwc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mara, kesana kirukiruma biyina kesana i botu, ba ana waina Iesu ita raurubai. Ba i toirubai i wona, “Bibeyebeyena biyim awaika ana wosei wai, yawasa mama damanina ana yauni?” ");
INSERT INTO mwc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu i kaobeyei i wona, “Moses ana kiruma kamonai awaika i kiruma ba, mekabage ke baibaiyawi?” ");
INSERT INTO mwc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kona i kaobeyei i wona, “Bada am God nuwanuwam tupanai, ba pipiyim tupanai, ba am maragata tupanai, ba am nota tupanai ki nuwayauyauni. Ba maturam ki nuwayauyauni nanakasike bage kom ikesim kebi nuwayauyaunim.” ");
INSERT INTO mwc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu i kaobeyei i wona, “Ku wona kabitam, nikona ke wosei, ba kuna yawasa.” ");
INSERT INTO mwc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Saba kona ana waina pipiya siti wareyei kairavina Iesu i toirubai i wona, “Ba maturaku wai kotoi?” ");
INSERT INTO mwc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu i kaobeyei i wona, “Mara kesana, Jerusalem sebare i yewo i gaigakira ku Jericho ba, pisipisikarisi i kasipananisi. Kana gara si tom sabusabui, ba si raviravi yepo, matapa kasibunuina wata namai ba si vera si sumarei. ");
INSERT INTO mwc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ba priest kesana yebo ketana kesaninai i gaigakira, ba maranai sebarena i kitai wai, i garubona ku sepina ba totorina i nae. ");
INSERT INTO mwc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ba nanakasike yebo, Levi pipiyina kesana i botu ku gawarina, ba sebarena i kitai wai, i garubona ku sepina, ba totorina i nae. ");
INSERT INTO mwc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Saba Sameria biyina kesana, kona ketanai ibo wagawaga, ba maranai i kitai wai, i kamyosukuei. ");
INSERT INTO mwc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I nae kurina ba kana mauwa monamona ba wine i sewai ba i sumai. Damanina ba ana donkey ku tepana i tere geyei ba i yauni i nae wagawaga biyisi asi ku yove ba namai i pota kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ba mara i tom wai, yove kana aba potapota money i berei ba i wona, “Niko sebare ke pota kabitamni, ba awaika wata kairavina kuna wosei wai ana veramaga wai ani maisanim.” ");
INSERT INTO mwc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu i wona, “Nikosi pipiya asi tonu kamosi yai, mekona ke nosinosi kata nao sebare pisipisikarisi si ravi wai maturana?” ");
INSERT INTO mwc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kairuwana kuira biyina kaobeyei i wona, “I kamyosukuwei wai, kona.” Iesu i wonei i wona, “Ke nae ba wosena kesanina ke wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ana Nonorayauna yabata si yewo si nenae ba si botu ku meyaga kesana. Namai wasike kana waba Martha Iesu i yorei ana ku yove i riu. ");
INSERT INTO mwc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha teina wai Mary. Ba Mary i nae Bada kaenai i makira ba ana giu i nonora kabikabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha ana saibira i rakata ba ibi nuwapoya, wai i nae Iesu kurina ba i wona, Bada kega i gaire kata, teukikei i sumariku ba saibira tupana i kesiku wata a wosewosei, ke wonei kata, ini baisiku. ");
INSERT INTO mwc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bada i kaobeyei i wona, “Martha, Martha, kom wai sawara pesarisi kebi nuwapoyana ba ebi magoyowanim. ");
INSERT INTO mwc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Saba sawara kesanaikei wata kuta waini, Mary wai sawara gairena i binei, wai karinai kega rubana sina yauna taveyei.” ");
INSERT INTO mwc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mara kesana, Iesu gawara kesanai i raupari. Ba maranai i rupari i kakaba wai, ana Nonorayauna kesana i wona, “Bada, John ana Nonorayauna pari i beyisi wai nanakasike ki beyikai kana rupari.” ");
INSERT INTO mwc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu kurisi i wona, “Maranai kona raupari wai, ko wona, Tama, kam waba kata kaobaisiyei, am basileiya ita botu ");
INSERT INTO mwc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mara patepatena kama kam ke bereberikai. ");
INSERT INTO mwc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ba ama piraga goyosi ke nota taveyisi. Nanakasike yebo yakai pipiya kurikai goyona te wosewosei wai kana nota taveyisi. Ba kega ku baisakari ki naovikai.” ");
INSERT INTO mwc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Damanina Iesu ana nonora yauna kurisi i wona, “Memei bage komi kesana nubakutuwai ita nae kwainana kurina ba ita wona, kwaina bread asi tonu kuta beriku, ");
INSERT INTO mwc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwainaku kesana ebo wagawaga ba karaku wata mom i vera kasibau au ku yove, ba yauku gwabikuwai kega kesana kam e mamana ba ana berei ina kam.” ");
INSERT INTO mwc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Saba kona yove komonai i kaobeya i wona, “Kega kuni sini kainiku, matamketa matapa a sagiri ba natunatuku yabata ka dudauwa. Kega rubana ana bomsiri ba awaika kesana ana berim. ");
INSERT INTO mwc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A wonewonimi, kega kwainana kairavina i bomsiri ba kam i berei. Saba, i tepa tora, ba i baba tupetupeni kairavina, i bomsiri ba awaika i waiwaini wai ereonowana i berei. ");
INSERT INTO mwc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kesanina a wonewonimi, koni baba ba ina berimi. Ko nuvena ba kona panana, ko rukesakesara, ba kurimi matam keta ina botaveyei. ");
INSERT INTO mwc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kairavina pipiya ereonowasi tebi baba wai, te yuyauna. Ba te nuvenuvena wai te panapanana ba terau kesakesara wai, matamketa kurisi e botaveyei. ");
INSERT INTO mwc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kom kotoi wata tama, maranai natum ita botu kurim iyana kairavina iti baba wai, mota kuta berei kona? ");
INSERT INTO mwc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kona pupau kairavina iti kawakinana wai rido kuta berei kona? ");
INSERT INTO mwc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ko goyo meo kana pata saba, ko kuiri kata sawara gaigairesi natunatumi ko bereberisi nanakasike yebo, iyabosi wata tama sapamai kurina sini baba wai kanuma kaobaisiena ina berisi.” ");
INSERT INTO mwc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mara kesana, Iesu kanuma goyona sebare kawa potapotana gwabinai ibi kasibauni. Ba maranai kanuma goyona i kasibau taveyana wai, sebare kawa gumegumena i sisiya ba pipiya pesarisi si wareyei. ");
INSERT INTO mwc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Saba pipiya mutusi si wona, “Kanuma goyogoyosi asi kaiwabo Beelzebub, Iesu maragata i berei wai kanuma goyogoyosi ebi kasibaunisi.” ");
INSERT INTO mwc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mutusi asi waina Iesu sita raurubai wai si babai kata wose kaimasavina ita wose sita kinani wai, siti geruwei kata kona, God maragata i berei. ");
INSERT INTO mwc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Saba Iesu asi nota i kuiri wai kurisi i wona, “Meo Basileiya wata i kesina ina geyara meyei wai kega ini maragata. Ba meo rakaraka wata i kesina ina geyara meyei wai ina peku.” ");
INSERT INTO mwc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Abisiri yai Satan i kesina ina geyara meyei wai ana basileiya mekabage ini imsikikita?” Nikasike abi sisiya, basuna komi ko wona kata yauku Beelzebub maragata i beriku wai, kanuma goyogoyosi abi kasibaunisi. ");
INSERT INTO mwc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Memena bage yauku Beelzebub maragata i beriku kanuma goyogoyosi abi kasibaunisi wai, kata, ko woniku kotoi ana maragatai wai ami Nonorayauna kanuma goyosi tebi kasibaunisi? I kesimi ami Nonorayauna sini mamatara kata komi ko kwaruma. ");
INSERT INTO mwc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saba kega, yauku kona God nimanai ba ana maragatai abi kasibaunisi. Nikona ebi beyebeyena kata God ana Basileiya matapa i botu kurimi. ");
INSERT INTO mwc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Maranai, sebare maragasina ere kapiyina ana yove ini taraparanei wai ana sawara ereonowasi sina ma kabitam. ");
INSERT INTO mwc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ba saba sebare kesana maragata, sakina ina kokona ina bo binubai ba ana kapiya i notanota tepanei wai ina yauna taveyei. Ba ana sawara ina yauna ini koda. ");
INSERT INTO mwc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kotoi wata kega kairaviku wai ebi abiyiku ba kotoi wata kega ebi baisiku e gedogedowa wai, kona ebi buburana. ");
INSERT INTO mwc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Maranai kanuma goyona pipiya e kasikasibau taveyei wai e nenae kupuramom kamonai biyakam gawarina e nuvenuveni. Saba maranai kega ina panani wai ina wona, ana veramaga nao ku yove ai sumarei wai nakai. ");
INSERT INTO mwc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ba ina veramaga wai, yovena gairena ba bunabunagina ina panani. ");
INSERT INTO mwc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Damamanina ina kasibau ina nae kanuma goyosi asi seven, bisu goyosi, kega bage kona rutinina, ina urabaisi sina riu, ba namai sina mana. Kona murinai wai, nao pipiya ana yawasa ina goyo saki kega bage kainaonai.” ");
INSERT INTO mwc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu nikosi ibi sisiyana wai wasike koroto kamosi yai i parara i wona, “Sinam bi bi gairenina i tuwim ba i susuim.” ");
INSERT INTO mwc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iesu i kaobeya i wona, “Damanina, ba saba iyaboi God wonana te noonori, ba te bosisiriyei wai, kosi bi bi gairenisi.” ");
INSERT INTO mwc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Koroto i rakarakata wai Iesu i wona, “Niko kimta pipiyisi wai kawa kasekasesi. Asi waina matakira sita kinana. Saba kega kesana sina kitai, ba Jonah wata ana matakira sina kitai. ");
INSERT INTO mwc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Peroveta Jonah Nineveh biyisi kurisi i matakira wai, yebo nanakasike Sebare Natuna niko kimta kurisi ini matakira. ");
INSERT INTO mwc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ba bi buibuiya maranai Sheba Taupaumina wasike ina bomsiri niko kimta pipiyisi ina kao bi goyonisi. Basuna ana kupura rabaraba, ba i nae Taupauma Solomon ana giu gaigairesi i nonora. Ba a wonewonim kata pipiya kesana nina, kona wai Solomon i getawani, ba saba komi kega ami waina koni taina baenegei. ");
INSERT INTO mwc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineveh biyisi yebo, bi buibiuya maranai sina bomsiri sina kao bi goyonimi, basuna Jonah kurisi i rumara wai si nuwabirabira. Ba karaku pipiya kesana Jonah i getawani wai nina, saba, komi kega ami waina koni nuwabirabira.” ");
INSERT INTO mwc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kega meyana pipiya kibe e kapukapuni ba, kabomai e tarataratawani, kona ebi buniyei. Saba ebi rorokei kata, pipiya ereonowasi te riuriu ku yove wai yaseganina te kitakitai. ");
INSERT INTO mwc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matami wai tupuvimi kana kibe. Maranai matami gairesi wai tupuvimi ereonowana yaseganina. Saba matami sina goyo wai tupuvimi ereonowana ini baidibari. ");
INSERT INTO mwc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ko wose kabitamni kata yasegana kamomi yai kega ini baidibari. ");
INSERT INTO mwc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kona kairavina tupuvimi ereonowana yasegana kamonai ina mana kega mutuna baidibara kamonai ina mana, saba tupuvimi ereonowana. Nanakasike bage kibe e yaseyasegana kurimi.” ");
INSERT INTO mwc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu i sisiya i kakaba wai, Pharisee kesana i babai kata yabata sita kam. Damanina ba i riu ku yove ba nimasunai i tupa kema ba ita kam. ");
INSERT INTO mwc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee i sikwana saki kata Iesu kega dudura i kibi, yarona ita kai bosuvei ba muri yai ita kam. ");
INSERT INTO mwc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ba Bada kurina i wona, “Komi Pharisee biyimi vedu ba kaboma kupusi wata kobo suwana. Saba, kamomi yai wai nota meyana, ba wose goyosi si bonuwa. ");
INSERT INTO mwc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Neganegami! Kata God kupuna wata i wosei kona kamonai yabata i wosei? ");
INSERT INTO mwc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Saba awaika ami kaboma ba vedu kamosi yai te mamana wai moyamoyakisi ko berisi. Ba kurimi awaika ereonowasi sina gaire. ");
INSERT INTO mwc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Komi Pharisee koi nuwapoya basuna kam kasi bibi gairena, mint ba rue asi ten kamosi yai wai, kesana God ko puyopuyoi. Saba pipiya kurisi wose kega gairesi ko wosewose ba God kega kobi nuwayauyauni. Saba wose tupana kona wosisi, ba kega kesana kona'netaveyei. ");
INSERT INTO mwc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Komi Pharisee koi nuwapoya basuna duwu yovesi kamosi yai ami waina pipiya kaikaposi asi gawarai kona makira. Ba ami waina aba gimogimona gawarisi yai, pipiya ere bokuwayisi sini kaikaivimi. ");
INSERT INTO mwc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Komi Pharisee, koi nuwapoya basuna komi bage karawaga kega ere matakirisi. Pipiya tepasi yai sina yewo ba kega sina kuiri kata, nao gawarai pipiya raboraobosi si doguisi.” ");
INSERT INTO mwc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ba giugiu biyina kesana i kaobeyei i wona, “Bai beyebeyena bitam, nikasike kebi sisiya wai, yakai yabata kebi gigimikai.” ");
INSERT INTO mwc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu i kaobeyei i wona, “Ba komi yebo kairuwana kuira biyimi, kurimi ina goyo saki basuna bita kaikapona pipiya ku ririwasi ko tereterei, ba kega rubana sina kabari. Saba komi kega misi yaromi yai kobo rorona kata, koni baisisi nakosi bita kona kabara. ");
INSERT INTO mwc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Koi nuwapoya kata peroveta asi karawaga ko bowabowa ba nosinosimi nikosi Peroperoveta si kasibunuwana. ");
INSERT INTO mwc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kata nikasike ko wosei wai i kesimi koi mamatara meyimi kata awaika nosinosimi si wosei. Kosi Peroperoveta si kasibunuwana ba komi kasi karawaga ko bowa.” ");
INSERT INTO mwc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nikona kairavina God ana nuwasu yai i wona, “Peroperoveta ba kawari yonayona ani porapora kurisi. Mutusi sini kasibunuwana ba mutusi sini tupa ketowanisi. ");
INSERT INTO mwc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kona kairavina, dobu dagudagunai ba i botu karaku. Peroperoveta ereonowasi tarasi si soro kairavina, niko kimta pipiyisi kunumaka sina kabari. ");
INSERT INTO mwc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel tarana i sororo maranai ba i botu Zechariah tarana i sororo wai ku marana. Kona wai ana runabonabo ba gawara kaowaobaisiena basusi yai si kasibunui. Damanina, a woewonimi niko kimta pipiyimi kunumaka tupana kona kabari. ");
INSERT INTO mwc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Komi kirukiruma biyimi kurimi ina goyo saki basuna komi kuira matamketana ko sagira potai, ba kega rubana kona riu. Pipiya iyabosi riu te waiwaini wai kobi gesisi. ");
INSERT INTO mwc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu kona gawarina i kasibau taveyei maranai, giugiu bitasi ba Pharisee biyisi si dagui si kaobigoyona sakiyei, ba sawara pesarisi kairavisi sibi kasekasemaini. ");
INSERT INTO mwc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kaena sibo taini kata, iti sisiya goyo wai siti kunumakei. ");
INSERT INTO mwc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kona maranai koroto kaikapona si notuwa ba, sibi ututawatawana bibirana. Ba Iesu ana Nonorayauna wata kurisi ikai bisisiya i wona, “Ko kita kabitamnimi, kata Pharisee biyisi asi yeast, kega ini garubona kurimi. Kosi wai kwaruma bitasi ");
INSERT INTO mwc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awaika wata ma kobakobasi wai ina tere kasibauwana ku matara. Ba awaika wata mama bi buneyisi wai God ini mamatarana. ");
INSERT INTO mwc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yebo awaika wata baidibarai kui sisiyei wai, kao basunai sina nonori, ba awaika wata yove kamonai ku koba ba kui pona simsimyei wai, wada kupunai sina rumamarei.” ");
INSERT INTO mwc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A wonewonimi, turaturaku, pipiya iyaboi tupuvim sina kasibunui wai kega ko nagarisi. Basuna kona murinai, kega yebo awaika goyona sina wosei. ");
INSERT INTO mwc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ani beyimi kata kotoi kona nagarei. God ko nagarei, basuna, kona ana maragata emamana kata ina kasibunuim murinai wai, ini garuim keyama karata bonabonana ku kamona. Eee, a wonewonimi, kona ko nagarei. ");
INSERT INTO mwc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Airita asi five kota gimonisi wai, maisasi i yogiyogi saki, Saba God nakosi manu kega kesana i nota wapei. ");
INSERT INTO mwc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bisuwona, God uyavim ereonowana i baiyavi ba i kuiri kata biyamo. Kega ko nagara, komi maisami wai i rakata saki, airita pesarisi maisasi ko getawanisi. ");
INSERT INTO mwc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A wonewonimi, kotoi wata pipiya naosi yai ini debei kata kona yauku au pipiya wai, yauku Sebare Natuna kesanina God ana aneya naosi yai kairavina ana wosei. Ani mamatara kata kona wai yauku au pipiya. ");
INSERT INTO mwc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Saba, kotoi wata pipiya naosi yai debai ini sinikikiyiku wai, yebo God ana aneya naosi yai debai ani sinikikiyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ba iyabosi wata yauku Sebare Natuna sina kao bi goyoniku wai, ereonowasi God ina nota taveyisi. Saba kotoi wata Kanuma Kaoaobaisiyena ini gigimi wai, kega ina nota taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Maranai, sina tina seserim sina nae duvu yovesi babadisi ba kaikaiwabosi kurisi. Ba naosi yai koni i msiri bi kasekase mainimi kairavina wai, kega koi nuwapoya kata mekabage koni taraparana meyimi, kona mekabage koni sisiya. ");
INSERT INTO mwc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kairavina kona maranai, Kanuma Kaoaobaisiyena ini beyebeyimi kata mekabage koni sisiya.” ");
INSERT INTO mwc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ba sebare kesana koroto kamosi yai Iesu kurina iwona, “Bi beyebeyena bitam, tuwaku ke wonei kata ama buderi tamakai i sumarei wai kani kodei.” ");
INSERT INTO mwc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu i kaobeyei i wona, “Au sebare, kotoi bibadana i beriku kata ani buibuiyimi, kona tamami buderina ami ruwamo kamomi yai ati kodei.” ");
INSERT INTO mwc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ba ereonowasi kurisi i wona, “Mataisiga wosesi bubausi yai, ko kita kabitamnimi. Basuna, bagunai wata sawara biyamo wata karimi yai, saba yawasa damana wai kega namai.” ");
INSERT INTO mwc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Damanina Iesu niko bi maibai kurisi isisiya i wona, “Mara kesana, sebare marimariyina ana tanowai kam si uwa kabitam.” ");
INSERT INTO mwc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I kesina i nuwasuya awaika ana wosei, yauku karikuwai kega gawara emamana ba niko kam ani gaeni. ");
INSERT INTO mwc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Damanina i wona, “Nikona ana wosei, au gweda ana rika ba gweda kaikaposi ana bowa, ba namai kau kam ereonowana ba au sawara mutusi yabata ani gaena.” ");
INSERT INTO mwc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba ana wona, kom damaina, am sawara gairesi si pesara saki kui gaena, bodu pesarisi kairavina. Kema bi nubaim, ke kam, ke toma ba ki nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Saba God sebarena i wonei, i wona, “Kom neganegam, karaku niko pominai am yawasa ana yauna taveyei. Ba nikoi sawara ereonowasi ikesim kairavim kubi gaeni wai, kotoi ina yauna ini karinai?” ");
INSERT INTO mwc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesu ana sisiya i bokoboi wai i wona, “Nikona kesanina iyaboi wata sawara ba mariya i kesisi wata kairavisi te bobitauri wai God matanai kosi kega marimariyisi.” ");
INSERT INTO mwc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Damanina Iesu ana Nonorayauna kurisi iwona, “Kona kairavina a wonewonim, kega ami yawasa kairavina kam koni nuwapoyei kona, tupuvimi kairavina gara koni nuwapoyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yawasa wai sawara kaikapona kega bage kam, ba tupuvim wai sawara kaikapona kega bage gara. ");
INSERT INTO mwc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Agaoga ko kinanisi, kosi kega te bobao kona tebo kasira kosi asi bobitaura yovesi kega. Saba God ebi kanisi! God kurina wai komi kamasavimi kega bage manu rutainisi ");
INSERT INTO mwc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kom kotoi wata nikona kebi nuwapoyei wai, kom rubana am yawasa kuna wosei misi ina veoroma kona? ");
INSERT INTO mwc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Memei bage sawara sosoena kega kuna wosei wai, awaika kairavina sawara mutusi kairavisi kebi nuwapoya? ");
INSERT INTO mwc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Saru ko kitaisi mekabage dipai te rautiti, kosi kega te bobagibagi, kona kasi gara ikesisi te wosewose. Saba ana wonimi, Taupauma Solomon i mariya saki, ba kana gara kega kesana monimonikina bage nikosi saru kesana rautainina. ");
INSERT INTO mwc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God gwanewa nanakasike ebi garabunagi, gwanewa karaku nina ba maram sina kapuni ina kara taveyei. Komi nanakasike ini garabunagimi kona? Ami bi geruwana si soesoe saki. ");
INSERT INTO mwc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kega koni nuwapoya. Kega kam ba toma koi nuwapoyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kairavina pipiya kega bibi geruwanisi, nikosi sawara te veravera nunurana. Ba Tamam i kuiri kata, komi ami waina nikosi sawara. ");
INSERT INTO mwc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Saba ana Basileiya ko kai nuveni, ba nikos sawara ereonowasi ina berimi. ");
INSERT INTO mwc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sheep rukunaikei, kega kona nagara, kairavina Tamami ebi nuwagaire kata ana Basileiya ina berimi. ");
INSERT INTO mwc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami sawara ereonowasi koi gimona, ba maisana moyamoyakisi ko berisi. Dobu mariyina kega ami ku kautu koi wana. Saba sapama mariyina ami ku kautu koi wana, wai kega pisipisikarisi sina yauni, kona wekuwekuma kega sini goyoni. ");
INSERT INTO mwc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kairavina, memei ami mariya kobo bitaura wai, yebo nuwanuwami mamanina namai sina mana. ");
INSERT INTO mwc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ko kaubunaga ba ko bobunaga saibira kairavina. Ba ko kinana kata ami kibe sina karata bonabona. ");
INSERT INTO mwc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bage saibisaibirisi, asi bada tabine poragina kairavina te potapotai ba ina veramaga wai rutinina. Ina botu ina rukesakesara wai, mara kesana matam keta kairavina sina botaveyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maranai asi bada ina botu ba ana saibisaibirisi mata waerewaresi sina mamana ina kitaisi wai ini nuwagaire saki. Abi suwonimi, kona yabata ina kaubunaga ba ina bosaibirisi, ini makirisi ba ina potasi sina ba kam. ");
INSERT INTO mwc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bagunai wata pom basunai, kona ku mara tom tom mena asi bada ina botu, saba bobo bunagisi ina pananisi wai ini nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kota kuiri kata, yove badana ina kuiri, meo maranai pisipisikarisi ana yove sina rebui wai, kega rubana ina botereisi ana yove sina rebui. ");
INSERT INTO mwc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ba komi yabata yebo kona bobunaga, basuna kega ko kuiri kata meo maranai Sebare Natuna ina botu. ");
INSERT INTO mwc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter Iesu i toirubai i wona, “Bada, niko bi maibai kebi sisiya wai, yakai am nonorayauna wata kurikai kebi sisiya kona, pipiya ereonowakai kurikai?” ");
INSERT INTO mwc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bada i kaobeyei i wona, “Meo saibisaibirina yapaikina, ba nuwanuwasuyina wai, kona ana bada ina terei ana saibisaibirisi mutusi ina potaisi, ba kasi kam bi koda maranai ini koda kabitam. ");
INSERT INTO mwc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maranai ana bada ina botu ku yove, ba kona wosena ina wosewosei, ina kinani wai ini nuwagaireni. ");
INSERT INTO mwc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Abi suwonimi, kona saibisaibirina ana bada ina terei kata, ana sawara ereonowana ina potai. ");
INSERT INTO mwc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Saba maranai nao saibisaibirina ina wona, Au bada ebi metewa saki, kega e botubotu yagiyagina. Ba ina dagui, saibisaibirisi mutusi, bibaine ba sebasebare ina raviravisi, ba ina kamkam ba ina tomatoma neganega ");
INSERT INTO mwc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kona saibisaibirina wai kega ina kuiri kata abi siri yai, kona meo maranai, ana bada ina botu. Ba ina botu wai, ini tara yaraganei, ba ana gawara kega bibi geruvisi kamosi yai ina terei, yabata sina mana. ");
INSERT INTO mwc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Meo saibisaibirina ana bada ana waina i kuiri, ba saba kega i wosei, kona kega ibo bunaga wai, ina kwapu sakiyei. ");
INSERT INTO mwc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Saba meo saibisaibirina ana bada ana waina kega i kuiri, ba saroba yaunina wosena i wosei wai, kona kega ina kwapu sakiyei. Iyabosi wata pesarina i bereisi wai, ereonowasi karisi yai e waiwaini pesarina ina yauni. Ba kotoi wata kaikapo sakina i berei, potaina kairavina wai, yebo e waiwaini kaikapo sakina, karinai ina yauni. ");
INSERT INTO mwc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yauku bibuibuiya kaikarakarasina a botuvei ku dobu. Awaina sakiyei kata, matapa sita kasiri ita karakarata. ");
INSERT INTO mwc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Saba yauku babataito ana riuni, ba ere nuwa yaraku abi potapota yepo ina rauroboi. ");
INSERT INTO mwc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Komi ko nosinosi kata yauku nuwanuba ku dobu a botuvei, saba a wonewonim kega nuwanuba ba bi buburana. ");
INSERT INTO mwc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Karaku ba karaku wata, rakaraka kesana kamonai, pipiya asi five sina mamana wai, sina keyauwarisi. Ruwamo asi tonu sini abiyisi, ba tonu asi ruwamo sini abiyisi. ");
INSERT INTO mwc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kosi sina keyauwarisi wai, tama natuna sebare ini abiyei, ba sebare tamana ini abiyei. Sina natuna wasikena ini abiyei, ba wasike sinana ini abiyei. Ba sina rawana wasikena ini abiyei, ba wasike kaowana sinana ini abiyei.” ");
INSERT INTO mwc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ba yebo pipiya korotosi kurisi i wona, “Maranai guba enaga sipunai egegai ko kitakitai wai, mara kesana ko wonawona ina kusana, ba e kusakusana. ");
INSERT INTO mwc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ba maranai, sibe kariwabo yai everavera damina ko yuyauni wai, ko wonawona ina boborabora, ba e booborabora. ");
INSERT INTO mwc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kwarukwarumimi! komi sapama ba dobu kasi kinanai wai, mara kobi sisiyei. Ba awaika kairavina karaku niko mara basuna kega ko kuiri? ");
INSERT INTO mwc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Awaika kairavina kega kebi buibuiya meyim, kata abi wose wai wose gairena. ");
INSERT INTO mwc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maranai kam abiya ina urabaim, bi buibuiyim kairavina kona nenae wai, ke wose rubai kata keta dobonai ami nuwabadona kona bo bitotori, ba koni kwainana. Ba kega wai, ina taina seserim kona nae bi buibuiya bitana kurina. Ba bi baibuiya bitana patuma sebarena ku yarona ina terim, ba patuma sebarena ku patuma yovena ina tere riuwim. ");
INSERT INTO mwc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A wonewonim kega rubana patuma yovena kuna kasibau taveyei yepo, kam kunumaka maisana kuna bokoboi wai damaina.” ");
INSERT INTO mwc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kona maranai, pipiya mutusi nai simamana wai, Iesu si wonei kata Galilee biyisi mutusi God kurina si puyopuyo bunuwa wai, Pilate i kasibunuwana, ba tarasi asi puyobunuwa yabata i saretabira. ");
INSERT INTO mwc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu ikaobeyisi iwona, “Komi ko nosinosi kata nikosi Galilee biyisi nikasike si rabobo wai, kosi asi piraga goyo sirakata saki, kega bage Gallilee biyisi tupasi rutainisi kona? ");
INSERT INTO mwc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kega, saba ana wonimi, komi ami piraga goyowai koni nuwa birabira wai damanina. Ba kega wai, komi yabata kona rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ba nakosi pipiya asi eighteen, Saloam yai yove kaidagimina i peku ikasibunuisi wai kosi mekabage. Ko nosinosi kata kosi asi piragagoyo si rakata saki, kega bage pipiya ereonowasi Jerusalem yai te mamana wai, rutainisi kona? ");
INSERT INTO mwc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ana wonimi kega, saba ereonowami ami piraga goyowai koni nuwabirabira wai damaina. Ba kega wai, komi yebo ereonowami kona rabobo.” ");
INSERT INTO mwc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Damanina Iesu niko bi maibai i sisiya i wona, “Sebare kesana koveya keyamina ana wine baona kamonai i baoni. Ba inae koveya uwana pokeina kairavina, saba uwana kega kesana ipanani. ");
INSERT INTO mwc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ana bao kana aba potapota sebarera kurina i wona, karaku bodu tonu ai nebira niko ku koveya keyamina, saba kega kesana uwana a kitai pasika. Ke tara taveyei! awaika kairavina tano wata ebi yakwarei. ");
INSERT INTO mwc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Saba bao kana aba potapota sebarena i wona, Bada, bodu kesanaikei wata ke boterei ina mana, kunukununa ana sutabuni ba tano kana bi gairena ana terei ");
INSERT INTO mwc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ba no bodunai ina uwa wai damainina, ba kega wai, kata ana tara taveyei.” ");
INSERT INTO mwc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabbath kesana, Jew biyisi asi duvu yovena kamonai Iesu ibi beyebeyena. ");
INSERT INTO mwc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ba wasike kesana kanuma goyona i gubagi wai, nai i mamana. Kona wasikena wai bodu eighteen i sikena bonei, ba ririwana i taina rukumi, ba kega rubana iti imsiri totora. ");
INSERT INTO mwc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Maranai, Iesu wasikena i kinanai wai i yorei, ba kurina i wona. “Wasike kam gubaga i yawasa.” ");
INSERT INTO mwc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Damanina yarona ku tepana i terei, ba mara kesana i msiri totora, ba God ibo kabakabari. ");
INSERT INTO mwc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jew biyisi asi duvu yovena badana i yagisi, basuna Iesu Sabbath maranai ba pipiya i yawasi. Kona kairavina pipiya kurisi i wona, “Saibira kasi mara wai asi six, kosi marasi yai wai kona botu biyawasa kairavina, ba kega Sabbath maranai.” ");
INSERT INTO mwc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iesu i kaobeyei i wona, “Komi kwaruma bitami! Komi kesakesasike wata Sabbath maranai ami abapayapayaya kasi yove yai ko tombaunisi, ba ko urauraba kasibauvisi okowa kobi tomanisi kona? ");
INSERT INTO mwc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Niko wasike wai Abraham natuna, ba Satan i kaupatupatumi bodu eighteen i kakaba. Kata sabbath maranai tana tombauni kona kega?” ");
INSERT INTO mwc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu nikasike i sisiya wai kana abiya si sinimaya. Saba pipiya wai, wose kaimasavisi i wose kairavina si nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu i toiruba i wona, God ana Basileiya wai, mekabage, mekabage ana tere gubai? ");
INSERT INTO mwc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kona wai nikasike, sebare kesana mustard pesina i yauni ba ana bao kamonai i baoni. Mastard i rautiti i gae i keyama, ba manu ragaraganai kasi nigu si bowa. ");
INSERT INTO mwc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ba i toiruba mena i wona, “God ana Basileiya awaika yabata ana tere gubai? ");
INSERT INTO mwc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kona wai nikasike, maranai wasike yeast yogina mom i yauni, ba flour kaikapona yabata i tabiri. Ba i terei i mana flour i ruruwa wai, rutainina.” ");
INSERT INTO mwc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu i bomsiri ku Jerusalem i nenae wai, keta dobonai meyaga kaikaposi, ba yogiyogisi kamosi yai ibi beyebeyena, ba i nenae. ");
INSERT INTO mwc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ba pipiya kesana i toirubai i wona, “Bada, pipiya kega pesarisi yawasa mama damanina sina yauni kona?” ");
INSERT INTO mwc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Iesu i kaobeyisi i wona, “Ko wose rubai kata matamketa kiudunai kona riu. Basuna pipiya pesarisi sina wose rubai kata sina riu, saba kega rubarubana. ");
INSERT INTO mwc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maranai yove badana ina bomsiri, ba matamketa ina gudui wai, komi matarai koni imsiri ba kona rau kesakesara.” Ba koni bi baba kona wona wona, “Bada matamketa kairavikai kuta botaveyei.” Saba kona ina kaobeyimi ina wona, “Komi kega a kuirimi, memena ko botu?” ");
INSERT INTO mwc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ba komi kona wona, “Kom rorowa yabata ta kam ba ta toma, ba ama meyagai kui beyebeyena.” ");
INSERT INTO mwc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Saba kona ina kaobeyimi ina wona, “Komi kega a kuirimi, kona memena ko botu, ko nesirana, komi ereonowami piraga goyo pipiyimi! ");
INSERT INTO mwc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Maranai, Abrabam, Isaac, Jacob ba peroperoveta ereonowasi God ana Basileiya kamonai sina mamana kona kitaisi wai, komi kupunai kona tou, ba nibomi koni tara gisigisi. ");
INSERT INTO mwc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kona maranai, pipiya kupura ereonowanai sina botu. God ana ku Basileiya. Ba poraga kamonai, asi gawara sina yauna sina makira. ");
INSERT INTO mwc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Damanina ba iyabosi karaku tebi nao wai sini muri, ba iyabosi karaku tebi muri wai sini nao.” ");
INSERT INTO mwc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kona maranai giugiu bitasi mutusi si botu Iesu kurina, ba si wonei, si wona, “Niko kupura ke kasibau taveyei ke nesaira, basuna Herod ana waina ina kasibunuim.” ");
INSERT INTO mwc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu i kaobeyisi i wona, “Ko nae nao kukou garagara ko wonei, kata karaku ba maram kanuma goyogoyosi ani kasibaunisi ba gubagubagisi ani yawasisi. Ba kao bi tonuinai au saibira ani kakabi. ");
INSERT INTO mwc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bagunai wata mekabage, saba karaku, maram, ba mara bi tonuinai awaika a wosewosei wai ana bo koboi. Kega kesana God ana Peroveta memena ina rabobo saba Jerusalem kamonai wata ina rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ae kiwaiape Jerusalem, Jerusalem, kom peroveta pesarisi kui kasibunuwana, ba God ana kawari yonayona kurim i poraisi wai, akimai kui guda bunuwana. Mara i pesara saki a waini kata am pipiya ereonowasi ati kesanisi, bage kokorereko sinasi, mapemapenai natunatuna e tapitapi ragaunisi wai, rutainina. Saba kom kega am waina. ");
INSERT INTO mwc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ke kinani, kona kairavina wai, am yove tapaoro kwebuna ina mana. Abi suwonim kom kega kuna kinakinaniku yepo maranai kuna wona, “Bibi gairenina kotoi bada wabanai e botubotu.” ");
INSERT INTO mwc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabbath kesana, Iesu i nae Pharisee biyisi asi bada kesana ana yoveyai ita kam, ba pipiya wai, Iesu sibo kibukibu kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ba sebare kesana yaroyarona ba kaekaena sibo ruruwana wai nai Iesu naonai i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu Pharisee ba kairuwana kuira biyisi i toirubaisi, i wona, “Ata giu mekabage e wonawona, Sabbath maranai tani yawasa kona kega?” ");
INSERT INTO mwc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Saba kosi kega kesana awaika si sisiyei, damanina sebarena i yauni i yawasi, ba i pora taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Damanina Iesu i wonisi i wona, “Memena bage kom kotoi wata, Sabbath maranai am abapayapayaya kona natum ku dogu kamona ita peku wai, yagiyagina wata kuta taina gaeyei kona kega?” ");
INSERT INTO mwc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Saba kega kesana kotoi nikona kairavina i kaobeyei. ");
INSERT INTO mwc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Maranai pipiya gawara kaimatanisi si bobine Iesu i kinani wai, niko bi maibai ereonowasi kurisi i sisiya. ");
INSERT INTO mwc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","I wona, “Maranai tabine kamna kairavina sina yorim wai, kega pipiya kaikaiposi asi gawarai ke makira. Memei bage pipiya bi badana kesana, kega kom rutainim yebo si yorei. ");
INSERT INTO mwc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kona kairavina nao sebare komi ami ruamo i yorimi wai, ina botu ba ina wona, “Am aba makimakira niko sebare ke berei.” Damanina kom kuni sinimaya ba gawara mominai kuna makira. ");
INSERT INTO mwc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Saba maranai sina yorim wai, ke nae gawara mominai ke makira. Ba nao pipiya kotai i yorim wai, ina botu maranai ina wona, “Kwaina ke magae ku gawara gairena.” Damanina pipiya si yorisi wai ereonowasi matasi yai sina kao bi gegaenim. ");
INSERT INTO mwc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kairavina iyabosi wata te teretere geyana meyisi wai ereonowasi ina tere kireisi. Ba iyabosi wata te teretere kirana meyisi wai, ina bokabarisi. ");
INSERT INTO mwc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Damanina Iesu kam badana kurina i wona, “Maranai kao basuna kamna, kona rabisi kamna kuna wosei wai, kega turaturam ba tuwa teiteim, kona am rakaraka, kona maturaturam marimariyisi kuna yorisi sina kam. Kairavina kosi yebo sina yorim, ba awaika ku wosei wai sini sarobi. ");
INSERT INTO mwc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Saba kam kaikapona kuna wosei wai pipiya moyamoyakisi, ba sikesikenisi, ba mata potapotasi, ba digadigasi ke yorisi sina kam ");
INSERT INTO mwc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kosi pipiyisi karaku wata kega sina sarobim, saba God ini gairenim. Ba pipiya asi yawasa totorisi sina bomsiri mena maranai. God ini maisanim.” ");
INSERT INTO mwc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sebare kesana Iesu yabata si makira si kamkam, ba niko sisiya i nonori maranai, Iesu kurina i wona, “Bi bi gairensi kona kotoi God ana basileya poraginai ina makira ba ina kam.” ");
INSERT INTO mwc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu i kobeyei i wona, “Mara kesana, sebare kesana kam kaikapo sakina i tupuvi, ba pipiya pesarisi i yorisi.” ");
INSERT INTO mwc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ba kamna marana i neratui wai, ana saibisaibirina i porai i nae pipiya iyabosi i yorisi wai, kurisi ita wonisi, “Ko botu sawara ereonowana ka bobunagi i kakaba.” ");
INSERT INTO mwc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Saba kosi ereonowasi si dagui asi sisiya si teretere sisirana. Pipiya i nao wai i wona, “Au tano karaku wata mom a gimoni, ba a nenae ana kitai, abi babaimi ko boteriku.” ");
INSERT INTO mwc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kesana i wona, “Yauku karaku wata mom au bullock asi ten a gimonisi. Ba a kasikasibau ana raurubaisi, sina bagibagi kabitam kona kega. Abi babaimi ko boteriku.” ");
INSERT INTO mwc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yebo kesana i wona, “Yauku karauku wata mom a tabine, kona kairaina kega rubana ana botu.” ");
INSERT INTO mwc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aba sabisaibirina i veramaga, ba awaika si sisiyei wai, ereonowana ana bada i wonei. Ana bada i yagisi wai i wona, “Yagiyagina ke kasibau, ba meyaga kamonai keta badai, ba keta soesoesiyai pipiya moyamoyakisi ba sikesikenisi, ba mata potapotasi ba digadigasi, ke urabaisi kona botu.” ");
INSERT INTO mwc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kega rabarabana ba saibisaibirina i wona, “Bada awaika ku wona wai a wosei, ba saba gawara tupana i madamana.” ");
INSERT INTO mwc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Damanina ana bada i wona, “Ke kasibau meyaga ku kupuna ba keta kaikaposi yai ba soesoesi yai pipiya ke wonisi sina riu au yove sini bonuvei.” ");
INSERT INTO mwc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ana wonimi, iyabosi wata a yorisi ba si totoyana wai, kega kesana au kam ina kam rubai. ");
INSERT INTO mwc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mara kesana, koroto kaikapona Iesu yabata si yewo si nenae ba, i taibira ba kurisi i wona. ");
INSERT INTO mwc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Kotoi wata ina botu kuriku, ba saba tamana ba sinana, ba nobuna ba tuwateina, ba yebo i kesina ana yawasa kega ini sinikikiyei wai, kona kega au nonorayauna. ");
INSERT INTO mwc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ba kotoi wata ana korosi kega ina kabari, ba ini saununuriku wai, kona kega au nonorayauna. ");
INSERT INTO mwc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kom kotoi wata am waina yove kaidagimina bowaina kairavina wai, kainaona kuna makira, ba maisana kuna kai rubai. Kata bi suwona money rubana, ba yovena kuni kakabi kona kega? ");
INSERT INTO mwc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Saba tukeke wata kuni totorana, ba yovena kega kuni kakabi wai, pipya ereonowasi sina kitai wai sini namim. ");
INSERT INTO mwc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Sina wona, niko sebare yove bowaina i dagui, saba kega rubana ini kakabi. ");
INSERT INTO mwc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ba taupauma kesana ina tauya taupauma kesana yabata bi abiya kairavina wai, kainaona ina makira ba ini nuwa notanota. Rubarubanana ana abiyabiyisi asi ten thousand, ba kana abiya ana abiyabiyisi asi twenty thousand ini imsi beyisi kona? ");
INSERT INTO mwc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ba kega rubarubanana wai, kana abiya rabarabai ina botubotu maranai, ana kawari yonayona ini poraisi sina nae nuwanuba kairavina sini babai. ");
INSERT INTO mwc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iesu ana sisiya ibo koboi ba i wona, “Kesanina komi, kotoi wata sawara ereonowasi kega ini sinikikiyana wai, kega rubana ini sununuriku. Ba kona wai kega au nonorayauna.” ");
INSERT INTO mwc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Enaga wai gairena, ba maranai enaga damina ina kakaba wai, kega rubana tana wosei ini enaga mena. ");
INSERT INTO mwc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kona wai kega i gaire, kata tano kana bibi gairena kukamona tana terei bao kairavina. Kona tano kurina wai i goyo, ba ku boga tani utusewa taveyei. Komi ere tainami wai, ko nonora. ");
INSERT INTO mwc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mara kesana tax aba yuyauna biyisi ba piraga goyo pipiyisi si botu Iesu siti taina baenegei. ");
INSERT INTO mwc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Saba Pharisee biyisi ba giugiu bitasi si dagui si gwinigwini “Niko sebare piraga goyo pipiyisi ebi turaturanisi, ba yabata te kamkam.” ");
INSERT INTO mwc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kata Iesu niko bi maibai kurisi i sisiya. ");
INSERT INTO mwc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","I wona, “Memena bage komi kesana ana sheep asi hundred ba kesana iti siwani wai, awaika ita wosei? Nakoi sheep asi ninty-nine kwapu kamonai iti sumarisi, ba nao kesanaikei i siwana wai, ita nuvenuveni yepo ita panani. ");
INSERT INTO mwc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ba ita panani wai, ere nuwa gairenina ku kabarana ita terei ba ita kabari, ");
INSERT INTO mwc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ba ita veramaga ana ku yove.” Damanina turaturana ba maturaturana ita yorisi ba ita wona, “Au sheep i siwana wai a panani, kairavina abi nuwagaire, ko botu tani nuagaire.” ");
INSERT INTO mwc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A wonewonimi, kesanina yebo nanakasike, piraga goyo pipiyina kesana ikei ini nuwabirabira wai, sapamai kairavina nuwagaire ina rakata saki. Kega bage pipya gaigairesi asi ninety-nine. ");
INSERT INTO mwc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kona memena bage wasike kesana, ana money asi ten ba kesana iti siwani wai, awaika ita wosei? Kibe ita kapuni ba ana yove ita rubunagi, ba kupura ereonowana ita nuvena kabikabitamni yepo ita panani wai damaina. ");
INSERT INTO mwc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ba ina panani maranai, turaturana ba warewaresina ina yorisi, ba ina wona, “Kobotu, au money kesana ai siwani wai a panani kairavina tani nuwagaire.” ");
INSERT INTO mwc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A wonewonimi, kesanina yebo nanakasike piraga goyo pipiyina kesana ikei ini nuwabirabira wai, kairavina God ana aneya sini nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu sisiya i tere damadamanei i wona, “Mara kesana sebare natunatuna sabasebare asi ruwamo yabata si mamana.” ");
INSERT INTO mwc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ba natuna murimurina i wona, “Tama, yauku kau koda buderi sawarisi, karaku nina ke beriku. Damanina ba ana sawara natunatuna asi ruamo i kodeisi.” ");
INSERT INTO mwc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kega rabarabana, ba natuna murimurina ana sawara i gimogimona, ba i kasibau taveyana i nae ku kupura rabaraba. Ba namai, ana money ereonowana i garuroboi. ");
INSERT INTO mwc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ana money i kakabi murinai wai, nao kupura kamonai gomara kaikapona i tupuwa. Ba kona karinai wai kega kesana awaika i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Damanina ba i nae nao kupura pipiyina marimariyina kesana, kairavina ita bagibagi. Ba nao kupura pipiyina, i porai i nae ana poro ita potaisi. ");
INSERT INTO mwc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ba soya i raobo saki wai, ana waina kata poro kasi kam kwapirisi ita kam, basuna kega kesana kotoi kam i berei. ");
INSERT INTO mwc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kona maranai, nota kurina i botu, ba i wona, “Tamaku ana saibisaibirisi ereonowasi ebi maisanisi, ba kasi kam i rakata saki, ba yauku nina soya a raboraobo. ");
INSERT INTO mwc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ana bomsiri ana veramaga tamaku kurina, ba ana wona, tama, kom ba God kurimi piraga goyo awosei. ");
INSERT INTO mwc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yauku kega damaniku ba kuna yoriku natum, gwabimi yai ana bagibagi am sabisabirisi kesana rutainina.” ");
INSERT INTO mwc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Damanina ba i bomsiri i veramaga tamana kurina. Kega i verakasibau ku yove, ba rabarabai naki tamana i kinana i kitai wai i nuwapoyei. I vera i kasibau natuna i tararausi ba i yaoni.” ");
INSERT INTO mwc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ba natuna i wona, “Tama yauku kona kom ba God kurimi piraga goyo a wosei, yauku kega damaniku ba kuna yoriku natum.” ");
INSERT INTO mwc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Saba tamana ana saibisaibirisi kurisi i para i wona, “Yagiyaginai kwama monimonikina natuku koi kotei, ba ring ku yaro rakorakona ko terei. Ba kae sumasuma ku kaena koi kotei. ");
INSERT INTO mwc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ba ko nae cow natuna bi kam potana ko kasibunui, ba ereonowata kam kai kapona tana wosei, ba tani nuagaire. ");
INSERT INTO mwc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kairavina niko natuku sebare i rabobo ba i yawasa, i siwana ba a panani, ba damanina kam kaikapona si dagui si bobunagi.” ");
INSERT INTO mwc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kona maranai, natuna iyarokona wai kwapu kamonai i bobagibagi yepo i veraveramaga ku yove. Ba maranai i botu ku yove gwabina wai, inaba gugurina ba pipiya si rikuriku wai i nonorisi. ");
INSERT INTO mwc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Damanina aba saibisaibirina kesana i yorei, ba i toirubai i wona, “Awaika e tuputupuwa?” ");
INSERT INTO mwc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ba saibisaibirina i kaobeyei i wona, “Teimkikei i veramaga mena ku yove. Ba teimkikei sinina gairena, ba yawayawasina i veramaga kairavina, tamam cow natuna bi kampotana i kasibunui.” ");
INSERT INTO mwc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Damanina tuwana i yagisi saki, wai kega i riu ku yove kamona. Ba tamana i kasibau i babai kata ita riu. ");
INSERT INTO mwc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Saba i totoyana, ba tamana i kaobeyei i wona, “Ke kinani, nikosi bodu pesarisi patupatumisi rutainina kairavim abo bagibagi, ba kega meyanai gamom ai kawakasekasyei. Ba awaika gairena kairaviku ku wosei? Kega gote natuna wata ku beriku, turaturaku yabata ka kam ba kai nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Saba niko natum, am sawara bibaine kakaiwakisi kurisi i berena paraparagana. Ba i veramaga ku yove wai, cow natuna bi kam potana kairavina ku kasibunui.” ");
INSERT INTO mwc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamana i kaobeyei i wona, “Natuku, kom wai mamanina gwabikuwai ke mamana, ba au sawara ereonoana wai, kom karimi yai. ");
INSERT INTO mwc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Saba tati nuagaire, ba yata sita sisira basuna, niko teim i rabobo, ba i yawasa, i siwana, ba tapanana meyei. ");
INSERT INTO mwc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ana nonora yauna i wonisi i wona, “Sebare marimariyina kesana, pipipya si botu si wonei, kata ana sawara kasi aba potapota pipiyina wai, ana sawara i resoreso bi garugaruwana.” ");
INSERT INTO mwc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Damanina i yorei i botu kurina, ba i wona, “Niko, sisiyim mekabage a noonori, ki mamatariku ana kuiri, kata kom mekabage au sawara ke potapotai. Basuna, kom kega au sawara kuna pota mena.” ");
INSERT INTO mwc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ba sawara kasi aba potapota nuwasinenai i wona, “Au bada au saibirai ebi rukaibuviku ba awaika ana wosei? Yauku kega maragasiku ba tano ana karoi ba abi sinimaya kega rubana ani kawa kinana.” ");
INSERT INTO mwc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","I wona, “A kuiri awaika ana wosei kata, ana rukaibau maranai wai, turaturaku sina urabaiku asi ku yove mena.” ");
INSERT INTO mwc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Damanina ba, pipiya ereonowasi ana bada ana sawara si yauna mom, ba kega si maisani wai, i yorisi si botu. Ba pipiya i nao i botu wai i toirubai i wona, “Kom au bada gwabinai kam taraboga biyamo wata te mamana?” ");
INSERT INTO mwc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","I kaobeyei i wona, “Yauku olive oil eight hundred gallons a yauni.” Ba sawara aba potapota sebarena i wona, “Nina am paper ke yauni ba yagiyagina ke birai, ke kirumi four hundred gallons wata.” ");
INSERT INTO mwc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ba pipiya bai ruwaina kurina i wona, “Ba kom, au bada gwabinai kam taraboga biyamo te mamana?” I kaobeyei i wona, “Yauku flour begs asi thousand a yanisi.” Sawara aba potapota sebarena i wona, “Nina am paper ke yauni ba ke birai ke kirumi eight hundred wata. ");
INSERT INTO mwc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sebare marimariyina ana sawara kasi aba potapota kwarukwarumina ana bi kose kairavina ikao bi gegaeni. Basuna niko dobu pipiyisi wai, si kose saki kega bage yasegana pipiyisi. ");
INSERT INTO mwc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iesu i wona, “Niko dobu ana mari yai pipiya ki turaturanisi kata marana ina netaveyei wai komi sapamai sina verabeyim ba sini kaikaivim. ");
INSERT INTO mwc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kotoi wata sawara soesoesi yai kega sini tumaganei wai yebo sawara kaikaposi yai kega sini tumaganei. Ba kotoi wata sawara soesoesi yai ina kwaruma wai yebo sawara kaikaposi yai ina kwaruma. ");
INSERT INTO mwc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Memena bage kom niko dobu mariyina kairavina kega tebi tumaganim wai, awaika kairavina mariya damana kairavina sini tumaganim. ");
INSERT INTO mwc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ba pipiya asi sawara potaisi kairavina kega sini tumaganeim wai kega kesana kotoi sawara ina berim kuni karimi yai.” ");
INSERT INTO mwc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Saibisaibirina kega rubana babada ruamo ina bo saibirisi, kesana ina bosaibira kabitamni, ba kesana ina kaosirei. Kesana ini nuwayauyauni, ba kesana ini sinikikiyei. Komi kega God, ba money kona bosaibirisi. ");
INSERT INTO mwc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee biyisi nikona si nonori wai, Iesu si kao bibisakei, basuna kosi money si nuwayauyauni. ");
INSERT INTO mwc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu i wona, “Komi pipiya matasi yai ko wosewose bage komi pipiya gairemi, ba saba God nuwanuwami i kuiri.” Kairavina abi sawara pipiya te nosinosi kurisi sawara kaikapona wai God kurina wai mo’omosina. ");
INSERT INTO mwc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Komi Peroperoveta asi kiruma ba Moses ana kao tunetune, ko kibikibi yepo, John Babataito bitana ana ku mara. Saba kona maranai ba i botu karaku wai, God ana basileiya warana gairena te raumamarei, ba pipiya ereonowasi tebi ratu ku kamona te riuriu. ");
INSERT INTO mwc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sapama ba dobu rubana sina momosa, saba Moses ana kao tunetune kega rubana soesoena ikei wata ina momosa. ");
INSERT INTO mwc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Meo sebare wata kaowana ini gesei ba wasike kesana bauna ina rabai wai, kona e raukaipara. Ba meo sebare wasike bi bi sairina ina rabai wai, kona yebo e raukaipara. ");
INSERT INTO mwc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mara kesana, namai sebare marimariyina kesana i mamana. Mara patepatena gara monimonikisi yai i kau bunaga, ba ibi mayawana. ");
INSERT INTO mwc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ba namai yebo sebare moyamoyakina kesana, kana waba Lazarus, sinina ereonowana gubaga si bonuvi ba i mamana. Pipiya si kabakabari si botubotu sebare marimariyina ana matam ketai si tereterei. ");
INSERT INTO mwc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I bi potapota kata, sebare marimariyina ana aba kamkam tepanai, kam pinipinimisi sita peku wai, ita kam. Ba yebo kukou si botubotu ba kana gubaga si remoremo. ");
INSERT INTO mwc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mara i botu wai, sebare moyamoyakina i rabobo ba aneya kanumina si yauni si gae Abraham parinai si makirei. Ba sebare marimariyina yebo i rabobo, ba si dogui, ");
INSERT INTO mwc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ba kanumina i nae rabobo ku gawarina. Namai, sini yara kamonai i gagawa, ba rabarabai naki Abraham i kitai, ba parinai wai Lararus i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ba Abraham kurina i yore i wona “Tama Abraham, ki kamyosukuviku, ba Larzarus ki porai yaro rakorakonai okowai ina kutubi, ba pepeku ini nubanubai. Basuna yauku niko keyama kaikarakarasina kamonai, sini yara kaikaponai a mamana.” ");
INSERT INTO mwc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Saba Abraham i kaobeya i wona, “Natuku, ke nosi kata yawayawasim maranai, kom am sawara gairesi ku yauna, ba Lazarus sawara goyosi i yauna, saba karaku kom siniyara kamonai, ba kona ebi nuwagaire. ");
INSERT INTO mwc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ba kesana wai kawana sanagina kaikapona kom ba yakai basuti yai e mamana, kata iyabosi nimai kurimi nae asi waina wai, kega rubana sina wosei, kona kega kotoi, memena ke mamana wai ini garubona kurikai.” ");
INSERT INTO mwc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sebare marimariyina i kaobeya i wona, “Kata tama, abi babaim Lazarus ki porai ina nae tamaku ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Namai tuateiteiku asi five te mamana, ina wonisi sina kuiri kata kosi kega sina botu niko ku siniyara gawarina.” ");
INSERT INTO mwc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrabam i kaobeya i wona, “Tuwateiteim gwabisi yai wai Moses ba Peroperoveta te mamana, kosi awaika tebi sisiyei wai sina nonori.” ");
INSERT INTO mwc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sebare marimariyina i kaobeya i wona, “Tama Abraham, kona wai kega rubana. Saba pipiya kesana rabobowai ina bomsiri mena ba ina nae kurisi wai sini nuwabirabira.” ");
INSERT INTO mwc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham i kaobeya i wona, “Moses ba Peroperoveta gamosi kega sina nonora wai, bagunai wata pipiya kesana rabobowai ina bomsiri mena, saba kega sini nuwabirabira.” ");
INSERT INTO mwc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu ana Nonorayauna kurisi i wona, “Mekosi sawara pipiya te wosewosisi tebi piragagoyo wai, sina tupuwa. Saba, kotoi karinai te botubotu wai sarobina ina goyo saki. ");
INSERT INTO mwc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","I gaire kata kona pipiyina kamyonai akima kaikapona tata kausi ba ku boga tati garukirei. Ba kega nikosi pipiya gunaguna ku goyona iti naovisi. ");
INSERT INTO mwc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kona kairavina ko kita kabitanimi! Tuateim wose goyona ina wosei wai ke kao rumatani. Ba ini nuwabirabira wai ana goyona ke nota taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Memena bage kao kesana kamonai mara seven wose goyona kurim ita wosei, ba mara seven ita botu ita wona, kurim ita tombaubauni wai, ke nota taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ba Apostles Bada kurina si wona, “Ama bi geruwana ki rakasi.” ");
INSERT INTO mwc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ba kona i kaobeya i wona, “Ami bi geruwana ina rakata mustard pesina rutainina wai, niko keyama kaikapona kurina kona wona, ke tamosapu ba nisa kamonai kuna rautiti, wai ina bosisirimi. ");
INSERT INTO mwc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Memena bage kom am saibisaibirina kwapu kamonai sheep ina potapotaisi kona ina roberobe yepo ina veramaga ku yove wai kuna wona kuna kam kona? ");
INSERT INTO mwc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kona kuna wona kau kamdauwa ke bobunagi. Ba ki kaubunaga ba kuna bo saibiriku ana kam ba ana toma, kona murinai kom kuna kam ba kuna toma. ");
INSERT INTO mwc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aba saibisaibirina ana bada ana waina ereonowana ina wosei saba kega ini kaikaivi. ");
INSERT INTO mwc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nanakasike yebo komi, maranai awaika ereonowana sina wonimi wai kona wosei ina kakaba wai, kona wona “Yakai kona aba saibisaibira mom, ama saibira ka wose wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mara kesana, Iesu i tauya ku Jerusalem wai, Samaria ba Galilee biyisi asi bi paraparatai wata i nenae. ");
INSERT INTO mwc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ba ku meyaga kesana iriuriu wai sebasebare asi ten, ereronowasi kasi gubaga leprosy, si verabeyei. Ba rabarabai si msiri. ");
INSERT INTO mwc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ba si parara si wona “Bada Iesu ki nuwanuwanikai!” ");
INSERT INTO mwc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu i kinanisi wai i wona, “Ko nae priest kurisi sina bo kinakinanimi.” Ba si nenae wai keta dobonai si yawasa. ");
INSERT INTO mwc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba kamosi yai sebare kesana, maranai i kinani kata i yawasa wai, i veramaga gamona kaikaponai God i bokabakabari. ");
INSERT INTO mwc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ba Iesu kaenai ku tano i peku ba i kaikaivi. Ba kona sebarena wai, Sameria biyina ");
INSERT INTO mwc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu i toiruba i wona, “Pipiya asi ten si yawasa ba asi nine memena? ");
INSERT INTO mwc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Awaika kairavina niko pipiya tumana i kesina i veramaga God ebi kaikaivi. ");
INSERT INTO mwc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ba Iesu kurina i wona, “Ke bomsiri ba ke nae, am bi geruwana i yawasim.” ");
INSERT INTO mwc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mara kesana Pharisee biyisi Iesu si toirubai, kata meyana God ana Basileiya ita botu. Iesu i kaobeya i wona, “God ana Basileiya ina botu wai, kega aba kina kinanina. ");
INSERT INTO mwc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kona pipiya sina wona, nina karaku! kona noi karaku! basuna God ana Basileiya wai komi kamomi yai.” ");
INSERT INTO mwc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ba ana Nonorayauna kurisi i wona, “Mara e botubotu kona maranai ami waina kata Sebare Natuna kota kinani, saba kega kona kinani. ");
INSERT INTO mwc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pipiya kurimi sina wona, sebarena noi! kona sina wona sebarena nina! kega kona vera kibikibisi. ");
INSERT INTO mwc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kairavina, Sebare Natuna ana botuna marana wai bage guba ebo kadari rutainina. Ebo kadari wai sapama erau yasegana e nenae ku sepina. ");
INSERT INTO mwc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Saba kainaona niko kimta sini sinikikiyei, ba sini nomosa kaikapona ina yauni. ");
INSERT INTO mwc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sebare Natuna ana botu marana wai, kesanina bage Noah ana marai. ");
INSERT INTO mwc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pipiya ereonowasi si kamkam ba si tomatoma, ba sibi tabitabine yepo, Noah i riu ku waka mena. Ba damanina kutukutuba i botu ba ereonowasi ikasi baigoyonisi. ");
INSERT INTO mwc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kesanina nanakasike yebo Lot ana marai. Pipiya si tomatoma ba si kamkam, sibi gimogimona, ba si bobao ba si bowabowa. ");
INSERT INTO mwc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Saba maranai Lot meyaga kana waba Sodom i kasibau taveyei wai, keyama kai karakarasina ba akima boraborasi sapamai si peku, ba pipiya ereonowasi ikasi baigoyonisi. ");
INSERT INTO mwc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nanakasike yebo, maranai Sebare Natuna ina rerematara wai marana. ");
INSERT INTO mwc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kona maranai kotoi wata ana yove wada kupuna tepanai ina mamana wai, kega rubana ina gakira ku yove kamona ana sawara ina yauna. Kesanina yebo, kotoi wata kwapu kamonai ina mamana wai, kega rubana ina veramaga ana ku yove awaika kesana kairavina. ");
INSERT INTO mwc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot kaowana ko nosi. ");
INSERT INTO mwc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kotoi wata ina wose rubai ana yawasa botawanina kairavina wai, ini siwani. Ba kotoi wata ana yawasa ini siwani wai, ini yawasi. ");
INSERT INTO mwc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A wonewonim, kona pominai pipiya ruamo aba dudauwa gawarina kesanai sina dudauwa, kesana ina yauna taveyei ba kesana wata ina mana. ");
INSERT INTO mwc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bibaine asi ruwamo pegapega sina gudagudai, kesana ina yauna taveyei ba kesana wata ina mana.” ");
INSERT INTO mwc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sebasebare ruwamo kwapu kamonai, kesana ina yauna taveyei ba kesana ina mana. ");
INSERT INTO mwc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ana Nonorayauna si toirubai si wona, “Bada memena?” I kaobeya i wona, “pipiya raboraobona memena e mamana wai namai poyake sina notuwa. ");
INSERT INTO mwc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu bi maibai ana Nonorayauna kurisi i sisiya. Ba i beyebebeyisi sita kuri kata, mamanina sita rupari, ba kega pari sita boterei. ");
INSERT INTO mwc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I wona, “Meyaga kesana kamonai, bi buibuiya bitana kesana i mamana kona wai, God kega i naganagarei, ba pipiya kega i bokuwayisi.” ");
INSERT INTO mwc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ba kona meyagina kamonai wai, yebo sobere kesana i mamana, ba mamanina i botubotu ibi babai, i wonawona, “Ki baisiku kau abiya yabata ama bi kawapata kuna bo bitotori.” ");
INSERT INTO mwc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Saba mara pesarina bi buibuiya bitana niko sobere ana bibaba i to’otoyanei. Yepo mara kesana, nuwasinenai i nuwasuya i wona, “Bagunai wata God kega a naganagarei, ba pipiya kega a bokuwayisi. ");
INSERT INTO mwc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Saba, niko sobere ebi sinikaina sakiyiku kairavina, awaika e waiwaini wai, ana bo bi totori. Ba kega ana wosei wai, ini sinikaina sakiyiku.” ");
INSERT INTO mwc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ba Bada i wona, “Bi buibuiya kwarukwarumina awaika i sisiyei wai, ko nonori? ");
INSERT INTO mwc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","God ana pipiya binebinesi kao ba pom kurina te tutou wai, ini buibuiya kabitam ba yawasa totorina ina berisi kona? Ba kega ini baita yaginisi kona? ");
INSERT INTO mwc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A wonewonimi, ina kinana kabitamni kata, awaika te waiwaini wai yagiyagina wata sina yauni. Saba, Sebare Natuna ina botu maranai wai, dobuwai bi geruwana ina panani kona?” ");
INSERT INTO mwc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pipiya mutusi asi gairena si notanota tepanisi, ba pipiya ereonowasi si kitakita kireisi wai, niko bi maibai Iesu kurisi i sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I wona, “Mara kesana sebasebare asi ruwamo, si nae ku yove taparoro rupari kairavina. Kesana wai Pharisee ba kesana, wai, tax aba yauyauna biyina. ");
INSERT INTO mwc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee biyina i msisaira, ba i kesina kairavina i rupari. i wona, “God abi kaikaivim kata yauku kega sebasebare mutusi rutainisi kosi wai, pisipisikarisi, matamataisigisi, kwarukwarumisi, ba rurukaiparisi kona niko tax aba yuyauna sebarena rutinina. ");
INSERT INTO mwc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yauku taparoro kesakesasike kamosi yai abi siya kao ruamo, ba awaika ereonowana a yuyani wai, asi ten kamonai kesana God a bereberei.” ");
INSERT INTO mwc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Saba tax aba yuyauna sebarena rabarabainaki i msiri, ba kega rubana ita gagawa ku sapama. Saba nuwanuwana i ravi ba i wona, “God ki nuwanuwaniku, yauku piraga goyo pipiyiku.” ");
INSERT INTO mwc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A wonewonimi, tax aba yuyauna sebarena ana piraga goyo ereonowana, God i nota taveyei ba kega Pharisee. Pipiya ereonowasi sina bokabara meyisi wai, God ina tere kireisi. Ba pipiya iyabosi te teretere kireina meyisi wai, ina bokabarisi. ");
INSERT INTO mwc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pipiya yebo pepeya si yauna si botubotu, Iesu yaronai ita borubaisi kairavina. Ba maranai ana Nonorayauna nikona si kinani wai, si yegaisi. ");
INSERT INTO mwc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Saba Iesu pipiya gunaguna i yorisi si botu kurina, ba i wona, “Pipiya gunaguna ko boterisi sina botu kuriku, ba kega koni gesisi. Kairavina, pipiya, nikosi pipiya gunaguna rutainisi wai, kosi God ana Basileiya karisi yai.” ");
INSERT INTO mwc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Abi suwonimi, kotoi wata God ana Basileiya, kega pipiya gunaguna rutainisi ina yauni wai, kega meyana ina riu ku kamona. ");
INSERT INTO mwc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jew biyisi asi bada kesana, Iesu i toirubai i wona, “Aba bi beyebeyena gairem, awaika ana wosei, ba yawasa mama damanina ana yauni?” ");
INSERT INTO mwc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu i kaobeyei i wona, “Awaika kairavina ku yoriku gaireku, kega kesana kotoi gairena, saba God i kesina wata gairena. ");
INSERT INTO mwc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","God wonana ku kuiri? Kega ke rukaipara, kega ke kasibunuwa, kega ke pisikara, kega pipiya kesana ki sisiyana kwarumei, ba tamam ba sinam ke kao baisiyeisi.” ");
INSERT INTO mwc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sebarena i kaobeya i wona, “Yauku yogiyogikuwai ba i botu karaku, nikosi wona ereonowasi abo sisiriyana.” ");
INSERT INTO mwc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu nikona i nonori maranai wai, kurina i wona, “Wose kesana wata kuna wosei, am sawara ereonowana ki gimonei ba moneyna pipiya moyamoyakisi ke berisi, ba am mariya sapamai kuna yauni. Ba ke botu kuni sununuriku.” ");
INSERT INTO mwc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Saba kona i nonori wai, i nuwapoya saki, basuna kona wai i mariya saki. ");
INSERT INTO mwc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu sebarena i kitai kata ibi nuwapoya wai, i wona, “God ana Basileiya riunina kairavina wai, pipiya marimariyisi kurisi ina padapada. ");
INSERT INTO mwc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Abi suwonimi, God ana Basileiya riu boneina kairavina pipiya marimariyina kurina i padapada saki. Kega bage camel siu niponina ina riu bonei rutainina.” ");
INSERT INTO mwc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pipiya nikona si nonori wai, si toirubai si wona, “Kata iyabosi wata yawasa mamadamanina sina yauni?” ");
INSERT INTO mwc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu i kaobeya i wona, “Awaika pipiya kurisi i padapada wai, God kurina kega i padapada.” ");
INSERT INTO mwc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter Iesu kurina i wona, “Yakai ama sawara ereonowasi kai sumamarana, ba kom ka kibikibim.” ");
INSERT INTO mwc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu kurisi i wona, “A bisuwonimi, kotoi wata God ana Basileiya kairavina ana yove ba kaowana, kona tuwateiteina, kona natunatuna, ba tutununa ini sumarisi wai, ");
INSERT INTO mwc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","puyo kaikapo sakina ina yauni, niko maranai. Ba mara damonai yawasa mamadamanina ina yauni.” ");
INSERT INTO mwc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu ana Nonorayauna asi twelve i taina sireisi, ba kurisi i wona, “Ta gegae ku Jerusalem, ba awaika ereonowana Peroperoveta Sebare Natuna kairavina si kirumi wai, wosena ina tupuwa. ");
INSERT INTO mwc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sina patumi, pipiya bausi ku yarosi sina terei. Kosi sini namei, sini gigimi, sina kanui, sina kwapui, ba sina kasibunui. ");
INSERT INTO mwc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Saba mara bi tonuinai ina bomsiri mena. ");
INSERT INTO mwc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Saba ana nonora yauna nikona si subi buruburuvei. Kurisi wai basuna i buniyei, ba awaika i bi sisiyei wai kega si kuiri.” ");
INSERT INTO mwc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu i veravera kasibau ku Jericho maranai, sebare mata potapotana kesana keta parinai i makira i mamana ba ibi kawakinana. ");
INSERT INTO mwc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ba maranai i nonori kata pipiya korotosi parinai si yewo si nenae wai, i toirubaisi i wona, “Awaika etuputupuwa?” ");
INSERT INTO mwc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Si wonei si wona, “Iesu Nazareth biyina i yewo e nenae.” ");
INSERT INTO mwc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","I para i wona, “Iesu David Natuna! ki kamyosukuviku.” ");
INSERT INTO mwc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pipiya keta sibi naovei wai sebare mata potapotana si yegai, ba si wonei kata kawana ita pota. Saba kona gamona kaikaponai i para tupetupena i wona, “David Natuna ki nuanuaniku!” ");
INSERT INTO mwc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu i msiri, ba pipiya i wonisi kata sebare mata potapotana sita botuvei kurina. Maranai i botu Iesu ku parina wai, Iesu sebarena i toirubai, ");
INSERT INTO mwc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","I wona, “Am waina awaika kairavim ana wosei?” Sebarena i kaobeya i wona, “Bada au waina ani kinana.” ");
INSERT INTO mwc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu kurina i wona, “Ki kinana, am bi geruwana i yawasim.” ");
INSERT INTO mwc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yagiyagina wata sebarena i kinana, ba Iesu i saununuri, God i bokabakabari ba Pipiya ereonowasi si kinani wai, kosi yabata God si bokabakabari. ");
INSERT INTO mwc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu i riu ku Jericho, ba kamonai i yewo i nenae. ");
INSERT INTO mwc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ba kona meyaginai, sebare kesana, kana waba Zacchaeus i mamana. Kona wai tax aba yuyauna biyisi asi bada kesana, ba sebare marimariyina. ");
INSERT INTO mwc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ana waina mekabage, ba Iesu ita kinani. Saba kega rubana, basuna kona wai i dubodubo saki, ba pipiya korotosi si imsi papari. ");
INSERT INTO mwc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kona kairavina i vera i nao i nae, ba keyama kana waba sikamo i gaeni. Kata Iesu kona ketanai i botubotu wai, ita kinani. ");
INSERT INTO mwc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu i botu kona ku gawarina maranai, i gagawa, ba kurina i wona, “Zacchaeus, ke gakira yagiyagina, karaku am yoveyai ana mana.” ");
INSERT INTO mwc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Damanina Zacchaeus yagiyagina wata i gakira, ba ere nuwagairena Iesu i kaikaivi, ba i urabai i nae ana ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pipiya ereonowasi nikona si kinani wai si yagisi, ba si rugugu si wona, “Piragagoyo pipiyina saba kurina ebo wagawaga.” ");
INSERT INTO mwc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saba Zacchaeus i bomsiri, ba i wona, “Bada, karaku nina ke kinani, au sawara ana keyauwari ruwamo, ba sepina pipiya moyamoyakisi ana berisi. Ba memena bage kotoi wata a kwarumei, ba ana sawara yogina a pisikari wai, ana bere meyei. Ba rubana kesanina asi bata yebo ku tepana ana terei. ");
INSERT INTO mwc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu kurina i wona, “Karaku yona yawasa i botu niko ku yove, basuna niko sebare wai yebo kona Abraham natuna. ");
INSERT INTO mwc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kairavina, Sebare Natuna i botu pipiya siwasiwanisi ina nuvenisi ba ini yawasisi.” ");
INSERT INTO mwc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pipiya nikona sibi taina baenegei maranai, Iesu ana sisiya i tubotaini, ba bi maibai kurisi i sisiya. Basuna matapa i botu Jerusalem ku gwabina, ba pipiya si nosinosi kata, God ana Basileiya mara kesana ita rerematara. ");
INSERT INTO mwc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iesu i wona, “Mara kesana, sebare marimariyina kesana i mamana, kona wai pipiya kaimatanina. Ba mara kesana, i tauya ita bowagawaga, ku rabaraba kupura kesana. Ba namai pipiya maragata sita berei kata bi taupauma kairavina, ba yebo ita veramaga mena. ");
INSERT INTO mwc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Muriyai ita tauya wai, ana saibisaibirisi asi ten i yoriisi, ba kesakesasike wata gold ibo pataisi i berisi. Ba i wona, “Nikosi money ko taura sina bobagibagi yepo ana veramaga. ");
INSERT INTO mwc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Saba ana pipiya si sinikikiyei wai kairavina, i nae ba murinai wara si porai si wona “Niko sebare kega ama waina kurikai ini Taupauma. ");
INSERT INTO mwc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Saba sebarena si wosei i Taupauma, ba i veramaga mena ana ku yove. Ba ana saibisaibirisi money i berisi wai, asi wara i porai sita botu, ba karisiyai ita kuiri kata, ana money mekabage wata si wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ana saibisaibirina kesana i nao i botu wai i wona, “Bada am gold kesana ku beriku wai yebo ten tepanai a wosei”. ");
INSERT INTO mwc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ana bada i kaobeyei i wona, “Kuwose kabitamni, kom aba saibisaibira gairem. Sawara soesoena ku wose kabitamni kairavina meyaga kaikaposi ten ana berim kuni badisi. ");
INSERT INTO mwc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ana saibisaibirina kana bi ruwamo i botu ba i wona, “Bada am gold nina, ku tepana yebo yaro sepina a wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ana bada i kaobeyei i wona, “Kom meyaga kaikaposi yaro sepina ki badisi.” ");
INSERT INTO mwc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ba ana saibisaibirina kesana yebo i botu kurina, ba i wona, “Bada am gold ku beriku wai nina, garai a sumai ba ai buneyei i mamana. ");
INSERT INTO mwc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A nagarim, basuna kom sebare padapadam, kom awaika kega ku tereterei wai ke yuyauni, ba awaika kega ku bobaoni wai ke bo’oyauna.” ");
INSERT INTO mwc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ana bada i kaobeyei i wona, “Kom aba saibisaibira kawakasekasem, kom i kesim am sisiyai ani buibuiyim. Ku kuiri kata yauku sebare padapadaku, awaika kega a terei wai a yuyauni, ba awaika kega a baoni wai a bo’oyauna. ");
INSERT INTO mwc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Awaika kairavina au money kega ku terei i bagibagi? Kata a veramaga wai yebo yogina tepanai ata yauni.” ");
INSERT INTO mwc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Damanina pipiya nai parinai simsimsiri wai, kurisi i wona, “Gold karinai ko yauna taveyei, ba ko nae nao saibisabirina karinai gold asi ten te mamana wai ko berei.” ");
INSERT INTO mwc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Saba kosi si wona, “Bada, kona wai gwabinai matapa gold asi ten te mamana.” ");
INSERT INTO mwc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Taupauma i kaobeya i wona, “Pipiya iyabosi wata gwabisi yai sawara pesarisi te mamana wai, yebo tepanai ana berisi ani pesari. Ba saba, iyabosi wata gwabisi yai kega kesana awaika emamana wai, awaika yogina ikei gwabisi yai e mamana wai, ana yauna taveyei. ");
INSERT INTO mwc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ba nakosi kau abiya, iyabosi kega asi waina yauku ati Taupauma wai, ko yaunisi ko botu nina naokuwai koni kasibunuwana.” ");
INSERT INTO mwc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu nikona i sisiyei i kakaba wai, i tauya i nao i gegae ku Jerusalem. ");
INSERT INTO mwc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba maranai i botu Bethphage, ba Bethany meyagisi ku gwabisi, koya kana waba Olives tepanai ana Nonorayauna ruwamo i poraisi si nao. Ba kurisi i wona, ");
INSERT INTO mwc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Koi nao ko nae nao ku meyaga naoti yai. Ba kona riuriu wai, donkey natuna nigonigorina kona kinani. Kega meyana pipiya kesana i geru ku tepana. Ko tombubauni ba ko yauni ko botu nikei. ");
INSERT INTO mwc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ba memena bage kotoi wata ina toirubaimi ina wona, “Awaika kairavina ko tombubauni? Ko wonei ko wona, Bada e waiwaini.” ");
INSERT INTO mwc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pipiysi iyabosi wata i poraisi si nae wai, awaika wata Iesu i wonisi wai nanakasike i tupuwa si kinani. ");
INSERT INTO mwc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba donkey kana nigora si tombubauni maranai, donkey babadisi si toirubaisi si wona, “Awaika kairavina donkey ko tombubauni?” ");
INSERT INTO mwc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kosi saba si kaobeyisi si wona, “Bada e waiwaini.” ");
INSERT INTO mwc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Damanina si yauni si nae Iesu kurina, ba kasi gara ku tepana si garu gegeyana, ba Iesu donkey ku tepana si gerui. ");
INSERT INTO mwc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu i geru i nenae wai, pipiya kasi tarasowo si botavetaveyana ba naonai ketai si yabara. ");
INSERT INTO mwc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ba i botu Olive koyana ita gakirei gawarinai, ana Nonorayauna korotosi si dagui wose kaimasavisi i wose si kinana kairavina, gamosi kaikaponai God si bokabakabari. ");
INSERT INTO mwc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Si wona, “Taupauma Bada kana wabai e botubotu wai, God ini gaireni. Nuwanuba sapamai ba Kadara God kurina.” ");
INSERT INTO mwc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pharisee biyisi mutusi koroto kamonai Iesu kurina si wona, “Bi beyebeyena biyim, am Nonorayauna ke wonisi kawasi sina pota.” ");
INSERT INTO mwc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","I kaobeyisi i wona, “A wonewonim kosi kawasi sina pota wai, saba akima sina parara”. ");
INSERT INTO mwc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I botu Jerusalem ku gwabina maranai, i kinana meyagina i kinani, wai kairavina i tou. ");
INSERT INTO mwc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","I wona, “Kom niko marai awaika nuwanuba ita berim wai kuirina wata kuta yauni. Saba karaku kega rubana matami yai kuna kinani. ");
INSERT INTO mwc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mara ina botu wai, kam abiya sina botu sina gari pipinim, ba sini subibirim, ba sepinai ba seipinai, sina riu beyebeyim. ");
INSERT INTO mwc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kom, ba natunatum am papa kamonai te mamana wai, sina kasi baigoyonimi. Kega kesana akima kana gawarai e mamana wai, sina boterei kana gawarai ina mana. Basuna kom God i botu kurim wai marana kui buruburuvei.” ");
INSERT INTO mwc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Damanina, Iesu i riu ku yove taparoro kamona, ba pipiya sibi gimogimona wai, i rukwabina si rukasikasibau. ");
INSERT INTO mwc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kurisi i wona, “God wonana i kirumi i wona, au yove wai pari yovena. Saba komi ko wosei wai pisipisikarisi asi aba kobakoba yovena.” ");
INSERT INTO mwc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Marana patepatena yove taparoro kamonai ibi beyebeyena. Saba priest babadisi, ba giu bi beyebeyena biyisi, ba pipiya asi babada asi waina sita kasibunui. ");
INSERT INTO mwc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Saba kega keta memena si panani ba sita wosei, basuna pipiya ereonowasi kona wata wonana sibo kikisi. ");
INSERT INTO mwc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mara kesana, Iesu yove taparoro kamonai ibi beyebeyena, ba wara gairena i raumamarei maranai, priest kaikaposi, ba giugiu biyisi Israel asi babada yabata si botu kurina, ba si toirubai si wona, ");
INSERT INTO mwc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ke wonikai memena bi badana ku yauni wai nikosi wose ke wosewose, kotoi i damaninei?” ");
INSERT INTO mwc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu i kaobeyisi i wona, “Yauku yebo ana toirubaimi. ");
INSERT INTO mwc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John sapamai bi badana i yauni wai, i babataito kona pipiya karisi yai?” ");
INSERT INTO mwc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","I kesisi wata kamosi yai si kawapata, ba si wona, “Tana wona sapamai bi badana i yauni wai, ina toirubaita ina wona, awaika kairavina John kega koi geruvei.” ");
INSERT INTO mwc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ba yebo tana wona pipiya karisiyai bibadana i yaunu wai, pipiya ereonowasi akimai sini kasibunuwanita. Basuna kosi si kuiri kata John kona Peroveta kesana.” ");
INSERT INTO mwc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kona kairavina si kaobeyei si wona, “Kega ka kuiri memena bi damaina i yauni.” ");
INSERT INTO mwc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu i wona, “Yauku yebo kega ana wonimi kata memena bibadana a yauni wai nikosi wose a wosewose.” ");
INSERT INTO mwc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Damanina Iesu niko bimaiba pipiya i wonisi, i wona, “Mara kesana, sebare kesana wine i baoni ba baona baobao bitasi i berisi sita potai. Ba i kasibau taveayana i nae mara veoromina. ");
INSERT INTO mwc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ba boyauna kana marai, ana sabisaibirina kesana i porai aba potapota biyisi kurisi, kata kana koda wine uwana, mutuna sita berei.Saba bao aba potapota biyisi ana saibisaibirina si ravi, ba yaro kabana si pora taveyei i nae. ");
INSERT INTO mwc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sebarena yebo ana saibisaibirina kesana i pora meyei. Saba niko sabisaibirina si ravi, ba si wosei i sinimaya, ba yaro kabana si pora taveyei i nae. ");
INSERT INTO mwc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sebarena kega i boterei, saba ana saibisaibirina yebo kana bi tonu i porai i nae. Saba kosi si ravi ba sinina si purupurukani, ba si garu kasibauvei.” ");
INSERT INTO mwc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Damanina wine baona badana i wona, “Awaika ana wosei? Natuku ai nuwayuyauni wai, kona ani porai, memena bage kona sina bokuwayei.” ");
INSERT INTO mwc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ba bao aba potapotaisi natuna si kinani wai, si kao boneyana si wona, “Niko wine baona badana natuna, tana kasibunui, ba niko bao ini karitiyai.” ");
INSERT INTO mwc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Damanina wine baona ku kupuna si garu kasibauvei, ba si kasibunui. Wine baona badana awaika kurisi ina wosei? ");
INSERT INTO mwc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ina botu nakosi bao aba potapotaisi ini kasibunuwana, ba wine baona pipiya bausi ina berisi. Pipiya si nonori wai, si wona, “Nikona kega meyana ina tupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu totorina kurisi i kinana, ba i toiruba i wona, “God wonawona si kirumi wai mekabage e wonaona? Akima yove bowabowasi si sinikaikaiyei wai, kona akimina, akima kaimasavina damana. ");
INSERT INTO mwc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipiya ereonowasi kona akimina ku tepana sina peku wai, sini pokipokiyisi. Ba akimina kotoi wata ku tepana ina peku wai, kona pipiyina ina kasi gudagudai.” ");
INSERT INTO mwc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Giugiu bitasi ba priest kaikaposi keta si nuveni kata, mekabage ba yagiyagina wata sita patumi. Basuna si kuiri kata niko bi maiba wai kosi kasi sisiya, saba pipiya si nagarisi. ");
INSERT INTO mwc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kona kairavina pipiya bi kae botaina biyisi si maisanisi kata kaena sita botaini. Ba awaika iti sisiyana goyoi wai, Rome kaiwabona ku yarona sita terei. ");
INSERT INTO mwc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Damanina bi kae botaina biyisi Iesu si toirubai si wona, “Bai beyebeyena biyim, ka kuiri kata kom awaika kebi sisiyana, ba kebi beyebeyena wai, totorisi wata. Ba kega kesana kotoi kurina ke pekupeku. Kom God ana ketai, ba wona damanai kebi beyebeyena.” ");
INSERT INTO mwc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Si wona, “Kuta wonikai Caesar tax kana berei wai, damanina kona kega?” ");
INSERT INTO mwc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu i kuiri kata kosi sibi kae bo taina, wai kurisi i wona, ");
INSERT INTO mwc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Silver coin kesana koi beyiku ana kinani.” Ba si beyei i kinani wai, i wona, “Kotoi gubana, ba kana waba niko coin tepanai?” ");
INSERT INTO mwc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ba kosi si kaobeyei si wona, “Caesar.” Iesu kurisi i wona, “Awaika Caesar karinai wai, damanina Caesar ko berei. Ba awaika God karinai wai yebo, God ko berei.” ");
INSERT INTO mwc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Awaika debai i sisiyei wai, kega rubana kaena sita botaini. Ba i kaobeyisi wai, si sinimaya ba kawasi si pota. ");
INSERT INTO mwc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ba Sadducee biyisi, duvu kesana, kosi si nosinosi kata pipiya sina rabobo wai, kega sina bomsiri mena. Si botu Iesu kurina ba si toirubai. ");
INSERT INTO mwc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Si wona, “Bi beyebeyena biyim, Moses ama giu i kirumi i wona kata maranai, sebare tabitabinena kega ere natunatuna ba ina rabobo wai, tuwateina soberena ina rabai, kata, natunatuna ini tuveisi.” ");
INSERT INTO mwc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Mara kesana, sebasebare asi seven si tupuwa. Sebare iyarokona wasike kesana i rabai, saba kega ere natunatuna, ba sebarena i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ba soberena teina murinai i tupuwa wai, i rabai. ");
INSERT INTO mwc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yebo teisi kasi bi tonu murisiyai yebo i rabai. Ba wosena kesanina i tuputupuwa yepo, sebasebaresi asi seven wasikena kesanina si rabai. Ba saba kega ere natunatusi ba si rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ba bokoboina wai wasikena yebo i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sebasebare asi seven niko wasike si rabai. Ba raboraobosi asi bomsiri mena maranai, niko wasike wai kotoi kaowana?” ");
INSERT INTO mwc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu i kaobeyisi i wona, “Karaku niko kimta sebasebare ba bibaine te tabitabine. ");
INSERT INTO mwc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Saba, pipiya bobo bunagisi God matanai, mara waunai sina bomsiri mena, ba kega meyanai sina tabine. ");
INSERT INTO mwc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kosi wai aneya rutainisi, ba kega meyana sina rabobo. Kosi wai God natunatuna, basuna, kosi rabobowai sina bomsiri mena. ");
INSERT INTO mwc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Saba Moses dipa kaikarakarasina rurutuvinai i debeina kabitamni, kata raboraobosi si bomsiri mena kairavina i sisiya i wona, “Bada wai kona Abraham ana God, ba Isaac ana God, ba Jacob ana God. ");
INSERT INTO mwc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kona wai pipiya yawayawsisi asi God, kega pipiya raboraobosi asi God. Basuna kona kurina wai, pipiya ereonowasi yawayawasisi.” ");
INSERT INTO mwc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Giu bi beyebeyena biyisi mutusi si kaobeyei si wona, “Ku kaobeyena kabitam.” ");
INSERT INTO mwc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Damanina ba kega kesana kotoi muri yai i toiruba meyei. ");
INSERT INTO mwc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Damanina Iesu i toirubaisi i wona, “Mekabage wai pipiya te wonawona kata, keriso kona David natuna? ");
INSERT INTO mwc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Basuna David i kesina Psalm bukana kamonai i wona, BADA GOD au Bada, kurina i wona: Nina kasukuwai ke makira ke mana, ");
INSERT INTO mwc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","yepo kam abiya ereonowasi kae gaburimi yai, kaem kana aba mamana ana tereisi. ");
INSERT INTO mwc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David i wona kata ana Bada Keriso, ba mekabaga wai Keriso, kona David natuna?” ");
INSERT INTO mwc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pipiya ereonowasi sibi taina baenega maranai, Iesu ana Nonorayauna kurisi i wona, ");
INSERT INTO mwc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ko kita kabitamnimi, kata komi kega giu bi beyebeyena biyisi rutainisi. Kosi asi waina kasi tara sowo veoromisi, tokarukaruvisi sina kote, ba sina yewo neubuwa. Asi waina kata bi gimona gawarisiyai pipiya sina bo kuwayisi, ba sini kaikaivisi. Kosi Jew biyisi asi duwu yovesi yai aba mamana kaimatanisi te binebine ba te makimakira. Ba poraga gawarisi yai wai, kaiwabo asi gawarai te makimakira. ");
INSERT INTO mwc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kosi sobesobere te getawanisi, ba asi sawara, ba asi yove tebi karisi yai. Ba tebi kwarukwaruma wai, asi pari veoroma goyosi te raupari. Kosi pipiyisi wai, asi saroba goyona mom sina yauni.” ");
INSERT INTO mwc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu yove taparoro kamonai ibi kinana, ba pipiya marimariyisi, asi puyo, puyo kana ku bo bitaura mena si tereterei. ");
INSERT INTO mwc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ba yebo ibi kinana, ba sobere moyamoyakina kesana i botu, ba penipeni yogiyogisi asi ruwamo i terisi. ");
INSERT INTO mwc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu i wona, “Abi suwonimi, niko sobere moyamoyakina, ana puyo i rakata saki i terei. Kega bage pipiya ereonowasi. ");
INSERT INTO mwc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nikosi pipiya ereonowasi, asi mariya nunusiyai, asi puyo si taura. Saba kona wai, ana gomara kamonai, awaika tepanai ita mana wai, ereonowana i terei.” ");
INSERT INTO mwc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu ana Nonorayauna mutusi, yove tapaoro si kinani wai sibi wareyei. Kata akima monimonikisi yai, ba pipiya God si puyoi wai, sawarisi yai si sarui wai, kana kinana ibi nuwarubaruba. Saba Iesu i wona, ");
INSERT INTO mwc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mara e botubotu, kata awaika karaku nina ko kinakinana wai, kega akima kesana wata kana gawarai ina mana, ereonowasi sini garukikirana.” ");
INSERT INTO mwc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ana Nonorayauna si toirubai si wona, “Bi beyebeyena biyim, meo maranai nikosi sawara sina tupuwa, ba abi matakira kana kitai kata nikosi sawara sina dagui sina tupuwa?” ");
INSERT INTO mwc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu i kaobeyisi i wona, “Ko kita kabitam, kata pipiya kega sini kwarukwarumimi.” Basuna pipiya pesarisi wabakuwai sina botu sini sisiya, ba sina wona, “Yauku Keriso ba, mara i botu saba kega koni saununurisi. ");
INSERT INTO mwc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maranai abiya, ba pipiya bi badana sini bi gegeyei, warana kona nonori wai, kega kona nagara. Nikosi sawara sina tupuwa, saba mara damona kega ina botu yagiyagina.” ");
INSERT INTO mwc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","I wona, dam kesana ina bomsiri, ba dam kesana ini abiyei. Ba kupura kesana ina bomsiri, ba kupura kesana ini abiyei. ");
INSERT INTO mwc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dobu ereonowana kamonai, uriyoyo kaikaposi, ba gomara, ba gubaga goyogoyosi sina tupuwa. Ba wose aba naganagarisi, ba matakira kaikaposi, sapamai sina tupuwa. ");
INSERT INTO mwc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nikosi sawara muri yai sina tupuwa. Saba, kainaona komi sina patumimi, ba sini tupa ketowanimi. Ba sina yaunimi kona nae Jew biyisi asi duwu ku yovesi, ba sini kasekase mainimi, ba patuma ku yovesi sina terimi. Ba yauku kairaviku sina botuvimi tautaupauma ba kaikaiwabosi kurisi. ");
INSERT INTO mwc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ba kona maranai wara gairena kurisi koni sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Saba, kainaona ko nuwasuya kabitam, kata kega mekabage kona papara meyimi kairavina koni nuwapoya. ");
INSERT INTO mwc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Basuna nuwasuya, ba sisiya ana berimi, wai kega kami abiya kesana ini imsi beyei kona ina teresirei. ");
INSERT INTO mwc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tutunumi, ba tuwateiteimi, ba turaturami, ba ami rakaraka damana, kami abiya ku yarosi sina terimi, ba mutumi sini kasi bunuwanimi. ");
INSERT INTO mwc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yauku kairaviku, pipiya ereonowasi sini sinikikiyimi. ");
INSERT INTO mwc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ba kega uyavimi kesana wata, gayamimi yai ina siwana. ");
INSERT INTO mwc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Koni imsikikita wai, yawasa mamadamanina kona yauni. ");
INSERT INTO mwc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Maranai abiya biyisi kona kinanisi Jerusalem sini bi subibiri wai, kona kuiri kata Jerusalem kasi bi goyonina marana i botu. ");
INSERT INTO mwc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ba pipiya iyabosi Judia kupurinai te mamana wai, sina vera ku koya. Ba iyabosi wata Jerusalem meyagina kamonai te mamana wai, sina kasibau taveyei ba yebo iyabosi matarai te mamana wai, kega sina riu ku kamona. ");
INSERT INTO mwc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kairavina nikona wai, God ana saroba. Peroveta si kirumi wai, ereonowana ina tupuwa. ");
INSERT INTO mwc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kona maranai bibaine manamanavisi, ba bibi susuisi kurisi wai ina goyo saki. Ba nuwapoya kaikapona, ina botu niko ku kupura, ba God ana saroba nikosi pipiya ina berisi. ");
INSERT INTO mwc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba mutusi seri yai sina rabobo, ba mutusi wai sina patumisi, ba sina yaunisi sina nae dobu bubausi yai sina terisi. Ba God kega si kuiri wai pipiyisi, Jerusalem sina resoresoi yepo, God asi mara rubana i terei wai ina yauni. ");
INSERT INTO mwc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kona maranai, kao ba nawaravi, ba gwamegwame kurisi, matakira bubausi yai sina tupuwa. Ba dobuwai yoyo ini bi garui, ba gugurinai wai, dam ereonowasi sina nagara, ba asi nota ina peku. ");
INSERT INTO mwc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pipiya sina nagara saki, ba sini potapota kata awaika dobuwai ina tupuwa. Kairavina sapama sawarisi sina rugusugusu, ba asi keta sini siwani. ");
INSERT INTO mwc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kona maranai, Sebare Natuna kadara kaikaponai, ba ere maragasina guba kamonai ina botubotu sina kitai. ");
INSERT INTO mwc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nikosi sawara sina dagui sina tuputupuwa maranai wai, ko msiri, ba ko tarakata, basuna ami bai yawasa i neratui. ");
INSERT INTO mwc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Damanina ba Iesu niko bimaibai kurisi i sisiya i wona, “Koveya keyamina, ba keyama mutusi, ereonowasi ko kinanisi, ");
INSERT INTO mwc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","maranai sina dagui sina numonumo wai, ko kuiri kata kwamra i tom. ");
INSERT INTO mwc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kesanina yebo, maranai nikosi sawara kona kinana sina tupuwa wai, kona kuiri kata God ana Basileiya i neratui. ");
INSERT INTO mwc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Abi suwonimi, kata nikosi sawara ereonowasi sina tupuwa, ba muri yai niko kimta pipiyisi sina rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sapama ba dobu sina momosa, saba wonaku kega meyanai ina momosa. ");
INSERT INTO mwc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ko pota kabitamnimi! kega bikam poragana, ba toma neganega kurisi kona peku saki. Ba kega niko dobu yawasina koni nuwapoyei, ba marana ina botu wai, ini sikwanimi bage riwariwa rutainina. ");
INSERT INTO mwc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kairavina, kona maranai pipiya dobuwai te mamana wai, ereonowasi kurisi ina botu. ");
INSERT INTO mwc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Matami sina tamotatara, ba mamanina kona rupari. Kata maragata kona yauni, ba nikosi sawara sina tupuwa wai, ereonowasi kona riubonena, ba Sebare Natuna naonai koni imsiri.” ");
INSERT INTO mwc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesu mara patepatena, yove tapaoro kamonai ibi beyebeyena. Ba rabisi patepatena, i kasikasibau Olives ku koyana, ba namai i mamana yepo, mara i tomtom. ");
INSERT INTO mwc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ba mamanina, maratom didibarinai, bi taina baenegina kairavina, pipiya ereonowasi si nenae ku yove taparoro mena. ");
INSERT INTO mwc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mara i botu, kata kam kaikapona kana waba, Baisaubona kamna kairavina. Kona maranai wai flour kega yeast yabata te kapukapuni. ");
INSERT INTO mwc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Priest kaikaiwabosi, ba giugiu bitasi pipiya si nagarisi kairavina, bibuneyai Iesu kasibunuina ketana si nuvenuveni. ");
INSERT INTO mwc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Damanina ba Satan, Iesu ana Nonorayauna kesana, kana waba Judas Iscariot i riuni. ");
INSERT INTO mwc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ba damanina Judas i nae priest kaikaiwabosi, ba yove tapaoro kana aba potapota babadisi yabata si sisiya, kata mekabage Iesu kurisi iti wawanei. ");
INSERT INTO mwc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kosi si nuwagaire saki, ba si damaninei kata, Judas money yai siti maisani. ");
INSERT INTO mwc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas i damaninei, ba i dagui keta i nuvenuveni, kata kega koroto matasi yai, Iesu ku yarosi ita terei. ");
INSERT INTO mwc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Damanina, ba bread kega yeast yabata, kanina marana i neratui. Ba kona maranai, sheep natunatusi baisaubona kamna kairavina, siti kasibunuwana. ");
INSERT INTO mwc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ba Iesu ana Nonorayauna asi ruwamo, Peter ba John i poraisi i wona, “Ko nae kairavita Baisaubona kamna kona bobunagi.” ");
INSERT INTO mwc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Saba kosi si toirubai si wona, “Am waina memena kana bo bunagi?” ");
INSERT INTO mwc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iesu i kaobeyisi i wona, “Maranai, meyaga ku kaikapona kona riuriu wai, sebare kesana okowa kiubuna ina kabakabari, ba ina vera beyimi. Ko kibi ko nae meo ku yove ina riuriu wai, kona ku yovena mena.” ");
INSERT INTO mwc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ba yove badana kurina ko wona, bi beyebeyena bitana i wona, “Yauku au Nonorayauna yabata, baisaubona kamna kana kani wai, gawarina memena?” ");
INSERT INTO mwc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kona yovena kamonai, tepana batarinai, gawara kaikapona, ereonowana bobo kepanina ini beyimi. Namai baisaubona kamna ko bobunagi. ");
INSERT INTO mwc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Damanina ba si tauya si nae, ba awaika ereonowana Iesu kurisi i sisiyei wai, nanakasike si panani. Ba baisaubona kamna si bobunagi. ");
INSERT INTO mwc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kam maranai, Iesu ana Nonorayauna yabata kam gawarinai si makira, ");
INSERT INTO mwc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ba kurisi i wona, “Awaina sakiyei, kata niko baisaubona kamna komi yabata tata kani, ba muriyai siniyara ana paiwarei. ");
INSERT INTO mwc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A wonewonimi, niko kam kega ana kanikani yepo, basuna damana God ana Basileiya kamonai, ina tupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesu vedu i yauni murinai, God kurina i kaikaiwa, ba i wona, “‘Nikona ko yauni, ba i kesimi kamomi yai koi kodei. ");
INSERT INTO mwc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kairavina a wonewomim, vine uwana kega ana tomatomani yepo, God ana Basileiya ina botu.’” ");
INSERT INTO mwc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Damanina ba bread i yauni, ba God kurina i kaikaiwa, ba i botomni, ba ana Nonorayauna i berisi, i wona, “Nikona yauku tupuviku, komi kairavimi i berena wai yauku aba nuwa raupairiku kairavina, nikona ko wosei.” ");
INSERT INTO mwc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kambira murinai, wosena kesanina, vedu i yauni, ba i wona, “Niko vedu kona God ana kao baiyoyobana wauna, yauku taraku kamonai, komi kairavimi i tamosewa wai. ");
INSERT INTO mwc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Saba ko nonora, pipiya yauku ini wawaniku wai, kona pipiyina karaku nina yabata ka kamkam. ");
INSERT INTO mwc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God i wainei kairavina, nanakasike Sebare Natuna ina rabobo. Saba, meo pipiya ini wawanei wai, kona pipiyina saroba goyona mom ina yauni.” ");
INSERT INTO mwc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Damanina ba si dagui i kesisi kamosi yai sibi kasekasemaina bibirana, kata kotoi niko wose ita wosei. ");
INSERT INTO mwc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yebo Iesu ana Nonorayauna kamosi yai, bi kawapata i tupuwa, kata kamosi yai kotoi pipiya kaikapona. ");
INSERT INTO mwc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu kurisi i wona, “Matara damsi asi taupauma bi badabada bitasi, ba iyabosi bi badana te yuyauna wai, i kesisi te yoreyore meyisi, kata kosi pipiya kuris si gaire saki. ");
INSERT INTO mwc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Saba komi kurimi wai, kega nanakasike, komi kamomi yai pipiya kaikapona ina wosei kata kona ini pipiyaikei rutainina. Ba bi badana ina wosei kata, kona saibisaibirina rutainina. ");
INSERT INTO mwc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kata kotoi pipiya kaikapona, pipiya e makimakira ba e kamkam wai kona, pipiya ebo saibira wai? Eee, nao pipiya e kamkam wai kona. Saba, komi kamomi yai wai, yauku kona saibisaibirina kesana. ");
INSERT INTO mwc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Au ruruba ereonowasi kamosi yai wai, komi yabata tamsiri. ");
INSERT INTO mwc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ba Tamaku mekabage maragata i beriku ani bada wai, komi yebo, nanakasike maragata ana berimi koni bada. ");
INSERT INTO mwc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kata au Basileiya kamonai wai, komi yauku yabata tana kam, ba tana toma. Ba taupauma asi aba makimakirai kona makira, ba Israel damsi asi twelve koni taupaumisi.” ");
INSERT INTO mwc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu i wona, Simon! Simon! Ke nonora! satan God gwabinai bi damanina i yauni. kata ereonowami ina raurubaimi. Goyona, ba gairena kamomi yai ini buburanei, nanakasike bage, baobao bitana wheat e rukosokosovi wai rutainina. ");
INSERT INTO mwc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Saba Simon, kom kairavim matapa a rupari, kata am bi geruwana kega ina peku. Ba maranai kuna veramaga mena kuriku wai, tuwateiteim kuna bobi maragasisi. ");
INSERT INTO mwc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Saba Simon i kaobeyei i wona, “Bada yauku abo bunaga, kata kom yabata tana nae ku patuma yove, ba tana rabobo.” ");
INSERT INTO mwc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu i kaobeyei i wona, “Peter, a wonewonim, karaku, muri yai kokorereko ina tou wai, kom mara tonu kuni gesaira kuna wona, kata kega kukuiriku.” ");
INSERT INTO mwc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Damanina ba Iesu ana Nonorayauna i toirubaisi i wona, “Nao maranai, kega money kana kautu, kona wagawaga asi kautu, ba kae sumasuma yabata ai poraimi wai, sawara kesana kobo kabai kona kega?” Kosi si kaobeyei si wona, “kega awaika kesana kabo kabai.” ");
INSERT INTO mwc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu i wona, “Saba karaku kotoi wata ere ana money kautuna, kona ere ana wagawaga kautuna wai, ina yauna. Ba kotoi wata karinai seri kega wai, kana tara sowo ini gimonei, ba seri kesana ina gimoni. ");
INSERT INTO mwc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kairavina a wonewonim, peroperoveta kairaviku si kiruma si wona, pipiya goyogoyosi rutainisi ina rabobo. Ba awaika kairaviku si kirukirumi wai, wosena e tuputupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ana Nonorayauna si wona, “Bada ke kinani, nina seri ruwamo.” Iesu i kaobeyisi i wona, “Kona damanina.” ");
INSERT INTO mwc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu mamanina i wosewosei wai rutainina, meyaga kaikapona i kasibau taveyei, ba ana Nonorayauna yabata si nae Olive ku koyana. ");
INSERT INTO mwc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba si verakaibau ku gawarina wai, ana Nonorayauna kurisi i wona, “Ko rupari kata kega ku ruruba kona riu.” ");
INSERT INTO mwc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Damanina i sumarisi kega i nae saki, ba i maere sogasoga, ba i rupari. ");
INSERT INTO mwc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","I wona, “Tama kuna waini wai niko paiwara veduna karikuwai ke yauna taveyei. Saba kega yauku au waina, ba kom am wainai ina tupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ba sapamai aneya i botu, kurina i rerematara, ba ibo bi maragasi. ");
INSERT INTO mwc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesu nuwayara kaikapo sakina kamonai i rupari, ba poyapoyana tara rutainina ku tano si toitoi. ");
INSERT INTO mwc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I raupari yepo, i veramaga maranai wai, ana Nonorayauna nuwapoya i bobunuisi wai, si kenouwapa si dudauwa i kitaisi. ");
INSERT INTO mwc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ba kurisi i wona, “Awaika kairavina ko dudauwa? Ko bomsiri kona rupari, kata kega ku ruruba kamona kona riu.” ");
INSERT INTO mwc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Karaku wata ibi sisiya, ba pipiya korotosi, ana Nonorayauna kesana, sebare kana waba Judas, i naovisi wai si verakasibau. Judas i nae Iesu yaonina kairavina, ");
INSERT INTO mwc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","saba Iesu i toirubai i wona, “Judas, mekabage, kom Sebare Natuna bi yoyaowai kebi wawanei kona?” ");
INSERT INTO mwc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Maranai, ana Nonorayauna yabata si mamana wai, si kinani kata awaika ita tupuwa wai si wona, “Bada, ama seri yai kani rauwa kona?” ");
INSERT INTO mwc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba ana Nonorayauna kesana, priest kaikapona ana saibisaibirina kesana i tarai, ba tainana i tara yaragi. ");
INSERT INTO mwc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Saba Iesu i wona, “Damanina niko wose ko boterei!” Ba sebarena tainana i borubai, ba i yawasi. ");
INSERT INTO mwc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Damanina priest kaikaiwabosi, ba yove tapaoro kana aba potapota babadisi, ba babada mutusi, si botu sita patumi wai kurisi i wona, “Ko nosi kata yauku kami abiya wai kepata, ba seri yabata ko botu. ");
INSERT INTO mwc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mara patepatena komi yabata yove tapaoro kamonai ta mamana, ba kega ko patumiku. Saba nikona wai ami mara, baidibara ebi kaiwabo wai marana.” ");
INSERT INTO mwc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Damanina Iesu si patumi, ba si urabai si nae si riu priest kaiwabona ana ku yove. Ba Peter rabarabai naki murisi yai i kibisi i nae. ");
INSERT INTO mwc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Saba, maranai yove garina basunai keyama si kasiri, ba si makira si mamana wai, Peter i botu ba yabata si makira si mamana. ");
INSERT INTO mwc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ba maranai aba saibisaibira wasikena kesana, keyama yaseganinai Peter i makira i mamana i kinani wai, i botu i kita kabikabitamni. Ba i wona, “Niko sebare yebo kona Iesu yabata si yewoyewo.” ");
INSERT INTO mwc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Saba Peter i gesaira i wona, “Wasike, yauku nao sebare kega misi a kuiri.” ");
INSERT INTO mwc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kega rabarabana, ba sebare kesana, Peter i rupanani wai i wona, “Kom yebo pipiyisi kesana.” Saba Peter i kaobeyei i wona, “Sebare, yauku kega yabata!” ");
INSERT INTO mwc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Si mana misi rabarabana, ba sebare kesana ikao tupetupena i wona, “Bisuwona’ niko sebare kona Iesu yabata si yewoyewo, basuna kona wai Galilee biyina.” ");
INSERT INTO mwc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Saba Peter i kaobeya i wona, “Sebare, awaika ke bisisiyei wai, yauku kega a kuiri.” Peter karaku wata ibi sisiya ba kokorereko i tou. ");
INSERT INTO mwc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Damanina Bada i taibira, ba totorina Peter i kitai. Ba Peter nuwanuwana i rupaira kata Bada mekabage kurina i wona, “Karaku niko pominai, muri yai kokorereko ina tou wai, kom mara tonu kuna wona kata kega ku kuiriku.” ");
INSERT INTO mwc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ba Peter i kasibau yove ku matarina, ba i tou saburere. ");
INSERT INTO mwc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ba sebasebare iyabosi Iesu si potapotai wai, si dagui si raviravi, ba si bigigimi. ");
INSERT INTO mwc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matana si kaupotai, ba si wona, “Ke wonikai kotoi i ravim?” ");
INSERT INTO mwc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba asi sisiya goyogoyosi pesarisiyai si kao bigoyoni. ");
INSERT INTO mwc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mara i tom wai, Israel babadisi, ba priest kaikaiwabosi, ba giu bi beyebeyena bitasi si botu si kesanisi. Ba abiya biyisi Iesu si urabai si botu ba rorititaina naosi yai imsiri. ");
INSERT INTO mwc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ba kosi Iesu si toirubai si wona, “Ke wonikai kom Keriso kona?” Iesu i kaobeyisi i wona, “Komi ana wonimi wai, karaku wata kega koni geruviku, ");
INSERT INTO mwc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ba ana toirubaimi wai, memena bage kega kona kaobeyiku. ");
INSERT INTO mwc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Saba karaku, ba karaku wata, Sebare Natuna God maragata sakina, kasaunai ina makira ina mana.” ");
INSERT INTO mwc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Damanina kosi ereonowasi si toirubai si wona, “Bisuwona kata kom God natuna kona? “I kaobeyisi i wona, “Ko wona kata yauku God natuna.” ");
INSERT INTO mwc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba kosi si wona, “Kega kesana kotoi awaika ina wonita, ba kota i kesita mom kawanai awaika i sisiei wai ta nonori.” ");
INSERT INTO mwc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Damanina ba pipiya duvuna ereonowana si bomsiri, ba Iesu si urabai si nae Pilate kurina. ");
INSERT INTO mwc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba namai Pilate naonai, si dagui sibi kunumakei. Si wona, “Niko sebare ama dam ibi beyena goyoisi wai, ka panani. Pipiya i wonisi kata, Taupauma Caesar kurina tax kega sini maisa, ba i wona kata kona wai Taupauma Keriso.” ");
INSERT INTO mwc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate Iesu i toirubai i wona, “Bisuwona kom Jew biyisi asi taupauma?” Iesu i kaobeyei i wona, “Eee mekabage ku wona wai, damanina nanakasike.” ");
INSERT INTO mwc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate priest kaikaiwabosi, ba pipiya korotosi kurisi i wona, “Niko sebare kega kesana ana goyona a panani, ba saroba ata berei. ");
INSERT INTO mwc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Saba kosi si kao tupetupena si wona, “Judia kupurina ereonowanai, niko sebare ana bi beyebeyenai, pipiya kamosiyai reso, ba bi rauwa te tuputupuwa. Galilee yai i dagui, ba i botu karaku nikei i verakasibau.” ");
INSERT INTO mwc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Maranai, Pilate nikona i nonori wai, i toiruba i wona, “Niko sebare Galilee biyina kona?” ");
INSERT INTO mwc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kona maranai wai, Herod yebo i botu Jerusalem kamonai i mamana. Ba maranai, Pilate i nonori kata Iesu kona ana bibadana kupurinai i botu wai, damania Iesu i porai Herod kurina. ");
INSERT INTO mwc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ba maranai, Herod Iesu i kinani wai, i nuwagaire saki. Basuna warana i nonori, ba niko mara veoromina ibi potapota, kata ana waina mekabage ba ita kinani. Ba ana waina Iesu, matakira ita wose ita kinana. ");
INSERT INTO mwc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod toiruba pesarisi Iesu i toirubai, saba Iesu kega i kaobeyei. ");
INSERT INTO mwc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Priest kaikaiwabosi, ba giu bi beyebeyena bitasi si bomsiri, ba kunumaka kaikapona Iesu si berei. ");
INSERT INTO mwc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ba Herod ana abiyabiyisi yabata Iesu si namei, ba si gigimi, ba gara monimonikina si kotei, ba si porai i veramaga Pilate kurina. ");
INSERT INTO mwc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kona maranai, Herod ba Pilate si kwainana, basuna asi ruwamo wai si abiya katamana. ");
INSERT INTO mwc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate pipiya asi babada yabata, ba priest kaikaiwabosi i yorisi si notuwa, ");
INSERT INTO mwc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ba kurisi i wona, “Niko sebare ko yauni ko botu kuriku, ba ko wona kata kona pipiya ibi naovena goyoisi.” Saba, nina naomi yai ai kasekasemaini, ba a panani kata kega kesana ana goyona awaika, ba koti kunumakei. ");
INSERT INTO mwc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod yebo, kega ana goyona kesana i panani kairavina, i porai i veramaga kurita. Karaku nina ko kinani, niko sebare kega kesana awaika i wose goyoi, ba ina rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kona kairavina, kana kwapui, ba kana boterei i na nae. (Jew biyisi asi dudura kata, baisaubona kamna maranai patupatumina kesana sini baba wai sina tombauni.) ");
INSERT INTO mwc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Damanina koroto tupana si para takuri si wona, “Ko kasibunui! ba Barabas kairavikai ko tombubauni.” ");
INSERT INTO mwc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas kona meyaga kaikapona kamonai bi rauwa, ba i kasibunuwa kairavina ku patuma yovena si tere riuwei. ");
INSERT INTO mwc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate ana waina kata Iesu ita rubotaveyei ita nae kairavina, koroto kurisi i baba mena. ");
INSERT INTO mwc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Saba kosi si para damadamana, si wonawona, “Ko tuparatui! Ko tuparatui!” ");
INSERT INTO mwc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mara kana bi tonuna Pilate kurisi i sisiya i wona, “Awaika kairavina, awaika i wose goyoi? Yauku kega ana goyona kesana a panani, ba ina rabobo. Kona kairavina ana wonisi sina kwapui ba ana boterei i nanae.” ");
INSERT INTO mwc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Saba gamosi kaikaponai, si para tupetupena kata, Iesu sita tuparatui, si parapara yepo, Pilate si getawani. ");
INSERT INTO mwc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Damanina Pilate asi waina i wosei. ");
INSERT INTO mwc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas kairavina si baba wai, patuma yovena kamonai birauwa, ba kasibunuwa kairavina i mamana wai, i botaveyei. Ba Iesu i bere taveyei kurisi, kata awaika si waiwainei wai, kurina sita wosei. ");
INSERT INTO mwc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Damanina ba abiyabiyisi Iesu si uraba taveyei. Ba si nenae maranai, sebare kesana kana waba Simon, Cyrene biyina i riuriu ku Jerusalem wai, si panani. Abiyabiyisi si yauni, ba korosi ku tepana si terei, ba si wosei Iesu murinai i yewo si nae. ");
INSERT INTO mwc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Koroto kaikapona Iesu si kibi si nae, bibaine mutusi yabata murinai sibi nuwapoya, ba si tou rasarasa, ba si nenae. ");
INSERT INTO mwc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu i taibira kurisi, ba i wona, “Jerusalem bibaine! kega kairaviku ko tou, saba komi i kesimi kairavimi, ba natunatumi kairavisi ko tou. ");
INSERT INTO mwc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kairavina, mara e botubotu, ba kona maranai pipiya sina wona, “Saito naki, kata bibaine si kaipoki, ba kega meyana si tuwa kona si tomana.” ");
INSERT INTO mwc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kona maranai, pipiya koya kaikaposi kurisi sina wona, “Ko peku ku tepakai,” ba koya yogiyogisi kurisi sina wona, “Ko sowoikai.” ");
INSERT INTO mwc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kairavina keyama matagina maranai, pipiya nikosi wose sina wose wai, keyama ina maowa maranai wai awaika ina tupuwa? ");
INSERT INTO mwc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abiyabiyisi yebo, sebasebare botabira bitasi asi ruwamo, si urabaisi si kasibau, Iesu yabata, sita kasibunuisi. ");
INSERT INTO mwc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Maranai si botu gawara kana waba, Gayamateuteu ku gawarina wai, Iesu namai si tuparatui. Ba botabira bitasi asi ruwamo yebo, kesana kasaunai, ba kesana gedunai, si tuparatuisi. ");
INSERT INTO mwc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu i wona, “Tama ke nota taveyisi kairavina kega si kuiri awaika te wosewosei.” Ba kana gara aba binebine si garui ba si kodei. ");
INSERT INTO mwc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pipiya nai simsiri sibi kinana, ba Jew biyisi asi babada Iesu si kao bibisakei. Si wona, “Pipiya mutusi i yawasisi, ba kona Keriso, God i binei wai, mede i kesina i yawasa meyei tana kinani!” ");
INSERT INTO mwc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abiyabiyisi yebo, si botu si namei, ba wine kawasi kwamkarina si yauni si tomani, ");
INSERT INTO mwc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ba si wona, “Kom Jew biyisi asi taupauma wai, i kesim ki yawasa meyeim!” ");
INSERT INTO mwc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba korosi yai, gayamina tepanai nikosi wona si kiruma si wona, “NIKONA JEW BIYISI ASI TAUPAUMA” ");
INSERT INTO mwc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nakoi sebasebare kawakasekasesi nai si roroke wai, kesana Iesu i namei i wona, “Kom Keriso kona? Kom ba yakai ki yawasita!” ");
INSERT INTO mwc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Saba, kesana i bomsiri kwainana i yegai i wona, “Kom God ke naganagarei kona kega? Kom ba kona wai, sarobina kesanina ko yuyauni. ");
INSERT INTO mwc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kota saroba ta yuyauni wai i gaire, basuna wose goyogoyosi ta wose kairavina, sarobina ta yuyauni. Saba niko sebare kona kega kesana awaika i wose goyoi.” ");
INSERT INTO mwc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Damanina ba i wona, “Iesu am ku Basileiya kuna riuriu wai, kega ki notawapiku.” ");
INSERT INTO mwc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu i kaobeyei i wona, “Abi suwonim karaku kom, ba yauku paradaisi yai tana mana.” ");
INSERT INTO mwc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Matapa ibi kao basuna, ba kao rarana i boterei, ba baidibara kupura ereonowana i sowopotai. Ba nanakasike i mana yepo 3 o’clock rabisiai. ");
INSERT INTO mwc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ba yove taparoro kamona, garai i tupayaragi wai, garana i tamosika ruwamo si tupuwa. ");
INSERT INTO mwc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ba Iesu gamona kaiponai i para i wona, “Tama ku yarom kanumiku a tereterei.” Nikona i wonei murinai wai, i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ba abiyabiyisi asi bada kesana, niko wose i tupuwa i kinani wai God i bokabakabari ba i wona, “Bisuwona niko sebare wai, kona sebare gairena.” ");
INSERT INTO mwc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pipiya ereonowasi si kesanisi si raugayo, ba niko wose i tupuwa si kinani wai, ere nuwapoyisi nuwanuwasi si botawana ba si veramaga asi ku yove. ");
INSERT INTO mwc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Saba pipiya iyabosi Iesu si kuira sakiyei, ba yebo bibaine iyabosi wata Galileeyai si kibi si botu wai, rabarabai naki si imsiri, ba nikosi wose si kinakinana. ");
INSERT INTO mwc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kona maranai wai, sebare kesana kana waba Joseph, rorititaina duwuna kamonai i mamana. Kona wai sebare gairena kesana, ba ana yawasa totorina. ");
INSERT INTO mwc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Maranai, Rorititaina si duwu ba niko wose sita wosei wai, kona kega i damaninei. Kona ana meyaga Arimathea, Judia kupurina kamonai, namai i botu. Ba kona wai God ana Basileiya ana botubotuna i potapotai. ");
INSERT INTO mwc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I nae Pilate kurina, ba Iesu tupuvina kairavina i baba. ");
INSERT INTO mwc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ba damanina i nae Iesu tupuvina korosi yai i terekirei, ba linen garanai i sumai. Ba karawaga wauna mom, akima nadegubina si karoi. Ba kega kesana kotoi si terei wai, namai i dauwei ");
INSERT INTO mwc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kona kaona wai bobunaga marana ba Sabbath marana matapa ine ratui. ");
INSERT INTO mwc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ba bibaine iyabosi wata Iesu Galilee yai si kibi si botu wai, Joseph yabata si nae ba karawaga si kinani. Ba mekabage wata Iesu tupuvina kamonai si terei wai, si kinani. ");
INSERT INTO mwc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Damanina si veramaga asi ku yove, ba Iesu tupuvina kana bane si bobunaga. Ba Bada ana kao tunetune kairavina si bosisiri wai, Sabbath maranai si yakam. ");
INSERT INTO mwc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabbath murinai maratom didibarinai bibaine si bomsiri bane si bobunaga wai si yauna si sukumara ku karawaga. ");
INSERT INTO mwc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba si vera kasibau ku karawaga wai, akima kaikapona, karawaga matam ketana si gudui wai, bi bi peuru taveyina si kitai. ");
INSERT INTO mwc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Saba si riu karawaga ku kamona wai, Bada Iesu tupuvina kega si panani ");
INSERT INTO mwc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nuwanuwasi i kairagaraga, ba nikona si nuwanuwasuyei maranai, mara kesana sebasebare asi ruwamo kasi gara kwari kadakadarisi parisi yai simsimsiri wai, si kinanisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ba si nagara saki wai, si pepeta naosi yai si gakira ku tano. Saba sebasebaresi kurisi si wona, “Awaika kairavina raoboraobosi kamosi yai, pipiya yawayawasina ko nuvenuveni? ");
INSERT INTO mwc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kona kega nina, kona i bomsiri. Galilee yai awaika i wonimi wai ko nosi?” ");
INSERT INTO mwc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","I wona, “Sebare Natuna piraga goyo pipiyisi ku yarosi sina terei, ba sina tuparatui. Ba mara bai tonuinai ina yawasa, ba ina bomsiri mena.” ");
INSERT INTO mwc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Damanina wonana nuwanuwasi yai i rupaira. ");
INSERT INTO mwc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba karawagai si veramaga mena wai, nikosi wose ereonowasi, Iesu ana nonora yauna asi eleven ba yebo pipiya mutusi yabata si wonisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bibainesi wai, Mary Magdalene, Joana, ba James sinana Mary, ba yebo bibaine mutusi, nikosi wose Iesu ana Nonorayauna si wonisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Saba, Iesu ana Nonorayauna kega si geruvisi. Si nosi kata awaika si sisiyei wai, sisiya paraparaga. ");
INSERT INTO mwc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Saba Peter i bomsiri, ba i vera i nae ku karawaga, ba i runoma i kinana wai, kega kesana awaika i kinani. Saba linen garanai Iesu si sumai wai, kona wata i dudauwa wai i kinani. Ba i veramaga mena ku yove, ba awaika i tupuwa wai i nota kabakabai. ");
INSERT INTO mwc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kona maranai, Iesu turaturana asi ruwamo, ketai si yewo si nenae ku Emmaus. Kona meyagina ba ku Jerusalem wai, ana rabaraba nanakasike seven mile rubana. ");
INSERT INTO mwc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba asi ruwamo wose ereonowasi si tupuwa wai, kosi si bi sisiyana. ");
INSERT INTO mwc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sibi toirubaruba, ba sibi sisiyana maranai, Iesu imsiratu kurisi, ba yabata si yewo si nae. ");
INSERT INTO mwc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kosi si kinani, ba saba si buruburuvei. ");
INSERT INTO mwc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu i toirubaisi i wona, “Ami ruwamo awaika kobi kaoboneyanei, ba ko yewoyewo?” Kosi simsiri, ba naosi nuwapoya i bonuwa. ");
INSERT INTO mwc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kesana kana waba Cleopas i toirubai i wona, “Kom wagawagam Jerusalem kamonai, kega ku kuiri rorowa mom awaika i tupuwa kona?” ");
INSERT INTO mwc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu i toirubaisi i wona, “Ba awaika i tupuwa?” Kosi si kaobeyei si wona, “Awaika Iesu Nazareth biyina kurina i tupuwa wai. Kona wai, Peroveta, pipiya ereonowasi ba God matasi yai, ana sisiya ba ana wose si maragata saki. ");
INSERT INTO mwc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Priest kaikaiwabosi, ba ata babada si yauni, ba pipiya si berisi sita kasibunui, ba korosi yai si tuparatui i rabobo. ");
INSERT INTO mwc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kabi geruvei, kata kona Israel ita tombaubauni. Nikosi wose si tupuwa wai, karaku mara kana bi tonu. ");
INSERT INTO mwc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ba yebo ku tepana kata ama bibaine mutusi si sikwanikai. Karaku maratomai si sukumara ku karawaga, ");
INSERT INTO mwc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","saba tupuvina kega si panani. Ba si veramaga wai, si wonikai kata, aneya kurisi si rerematara, ba si wonisi kata, Iesu wai yawayawasina. ");
INSERT INTO mwc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Damanina turaturakai mutusi si nae ku karawaga, ba mekabage bibaine sisisiya wai, nanakasike si kinani, saba pipiyina kega si kinani.” ");
INSERT INTO mwc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesu kurisi i wona, “Abi neganegami naki, mekabage wai awaika Peroperoveta si sisiyei wai, kega koi geruwana yagiyaginei. ");
INSERT INTO mwc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bi suwona kata Iesu nikosi wose ina paiwarana, ba ana ku kadara ina riu kona?” ");
INSERT INTO mwc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ba Iesu God wonana ereonowasi, kona i kesina mom kairavina si kiruma wai, i tere bi totorana. Moses ana bukai i dagui, ba i nae Peroperoveta ereonowasi si kiruma wai, kurisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba si nae matapa ku Emmaus si veravera kasibau wai, Iesu i wosei bage kona ita veravera damana. ");
INSERT INTO mwc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Saba kosi si yawatawani si wona, “Kega kuna nae, kao matapa i kakaba, ba matapa e pompom, ke botu yabata tana mana.” Damanina ba i riu yabata sita mana. ");
INSERT INTO mwc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba si makira sita kam maranai, bread i yauni, God kurina i kaikaiwa ba i kiyatomni, ba i dagui ita berisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kona maranai matasi si tamotatara, ba si kuiri, saba naosi yai i vera siwana. ");
INSERT INTO mwc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Si kao boneyana si wona, “Pasinakata kona kairavina ketai kurita i bisisiya, ba God wonana si kirumi wai, kurita ibi debei maranai, nuwanuwata kamosi yai keyama karakarasina rutainina i karakarata.” ");
INSERT INTO mwc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Damanina mara kesana si bomsiri, ba si veramaga ku Jerusalem. Ba namai ana Nonorayauna asi eleven mutusi yabata si kesanisi si mamana wai, si pananisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ba kurisi si wona, “Bisuwona Bada i bomsiri! Ba bisuwona Simon kurina i rerematara” ");
INSERT INTO mwc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Damanina asi ruwamo awaika ketai kurisi i tupuwa wai, ba mekabage Bada bread i kiyakiyatomni, ba si kita panani wai kurisi si sisiyei. ");
INSERT INTO mwc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Karaku wata nikona si bisisiyei, ba Iesu i kesina mom basusi yai i msiri, ba i wona, “Nuwanuba kurimi emana.” ");
INSERT INTO mwc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kosi si sikwana negenegisi, ba si nagara, si nosi bage momosika sita kinani. ");
INSERT INTO mwc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Saba kurisi i wona, “Awaika kairavina ko nagara, awaika kairavina ami nota te kairagaraga? ");
INSERT INTO mwc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yaroyaroku ba kaekaeku ko kinana, nikona yauku i kesiku mom, ko borubaiku ba kona kinani, kata momosika kega ere biyosi ba ere sirikesi. Bage karaku nina ko kinakinaniku wai, rutainina.” ");
INSERT INTO mwc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kona i wonisi murinai, yaroyarona ba kaekaena i beyisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nuwagaire i bobunvisi, ba si bi wareyei wai, kega si bi geruwana kabitamni. Kona kairavina i toirubaisi i wona, “Karaku nina komi karimi yai awaika kesana kanina kairavina e mamana kona kega?” ");
INSERT INTO mwc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Damanina iyana gibugibuna mutuna si yauni si berei, ");
INSERT INTO mwc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ba matasi yai i yauni i kani. ");
INSERT INTO mwc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Damanina ba kurisi i wona, “Nikosi wose kairavisi yabata ta mamana maranai, a wonimi. Sawara ereonowana Moses, ba Peroperoveta ba Psalms bukasi, kamosi yai, kairaviku si kiruma wai, wosesi sina tupuwa.” ");
INSERT INTO mwc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Damanina asi nota i botatari, kata awaika Peroperoveta si kiruma wai, sita kuira kabitamni. ");
INSERT INTO mwc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kurisi i wona, “Nikasike si kiruma, si wona Keriso sini yara ina paiwarei ina rabobo, ba mara bitonuinai, ina bomsiri mena. ");
INSERT INTO mwc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ba Jerusalem yai sina dagui, nuwabirabira ba piragagoyo nota taveyina kana wabai, dam ereonowasi kurisi sina rumamara. ");
INSERT INTO mwc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Komi nikosi wose kasi bi mamatara pipiyimi. ");
INSERT INTO mwc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Awaika Tamaku ikao biyoyobanimi wai, ani porai kurimi. Saba meyaga kamonai koni bi potapota yepo, maragata sapamai, ina gakira kurimi.” ");
INSERT INTO mwc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Damanina ba ana Nonorayauna Jerusalem yai, i urabaisi si kasibau si nae ku Bethany, ba yaroyarona i bokabara, ba i gairenisi. ");
INSERT INTO mwc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ibi gairenisi maranai, i sumarisi, ba God i yauna taveyei, i gae ku sapama. ");
INSERT INTO mwc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Damanina ba ana Nonorayauna si bokabakabari, ba ere nuwagairesi si veramaga ku Jerusalem. ");
INSERT INTO mwc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba mara patepatena yove taparoro kamonai wata si mamana, ba God sibo kabakabari.");
ALTER TABLE mwc_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
