﻿USE sofia;
DROP TABLE IF EXISTS sofia.mvn_vpl;
CREATE TABLE mvn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mvn_vpl WRITE;
INSERT INTO mvn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iginuma taina Iesu Tau Ito‑yavuha wanowanohina wayahi. Iesu wana vovouna Davida ka naona wana Abaraham. ");
INSERT INTO mvn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ka Iesu wanowanohina ai wava deina. Abaraham natuna Isaki, ka Isaki natuna Iakobo, ka Iakobo natuna Iuda na vavaneina. ");
INSERT INTO mvn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda‑nana natunatuna ainua Peresi ka Sera, ka ayoi ai wava Tama. Peresi natuna Esironi, ka Esironi natuna Ram. ");
INSERT INTO mvn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ka Ram natuna Aminadaba, ka Aminadaba natuna Nasoni, ka Nasoni natuna Salimoni, ");
INSERT INTO mvn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ka Salimoni awana Rahaba, e natui Boasa, ka Boasa awana Ruta, e Ruta natui Obedi, ka Obedi natuna Iese. ");
INSERT INTO mvn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese natuna Davida, tauna kiniV ka Davida‑nana Uria awana iwadae, e tavinei ka natui Solomoni. ");
INSERT INTO mvn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Reoboam, ka Reoboam natuna Abia, ka Abia natuna Asa. ");
INSERT INTO mvn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natuna Ieosapata, ka Ieosapata natuna Ieoram, ka Ieoram natuna Usia. ");
INSERT INTO mvn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia natuna Iotam, ka Iotam natuna Ahasi, ka Ahasi natuna Esekia. ");
INSERT INTO mvn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia natuna Manase, ka Manase natuna Amoni, ka Amoni natuna Iosia. ");
INSERT INTO mvn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia natuna Iekonia na vavaneina ka yai tutea me Babiloni iomo, e me Iudea ivo‑vivini, ineiei, ihohoni yai papani Babiloni wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tutana Babiloni nihenina imamaei Iekonia natuna Sealitieli, ka Sealitieli natuna Serubabela. ");
INSERT INTO mvn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabela natuna Abiuda, ka Abiuda natuna Eliakim, ka Eliakim natuna Asori. ");
INSERT INTO mvn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asori natuna Sadoka, ka Sadoka natuna Akim, ka Akim natuna Eliuda. ");
INSERT INTO mvn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eleasari, ka Eleasari natuna Matani, ka Matani natuna Iakobo. ");
INSERT INTO mvn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo natuna Iosepa, ka tauna Mari awai ka Mari natui vivane Iesu, ka Iesu‑nana ivi‑wahani Tau Ito‑yavuha. ");
INSERT INTO mvn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iesu wanowanohina kaiaiavi deina. Aituhu kavi‑putu Abaraham wayahina, ka aituhu kaiaiavi a itoava Davida wayahina, taui ai yau 14. Ka aituhu kavi‑putu Davida wayahina, ka aituhu kaiaiavi a itoava me Babiloni me Iudea ineiei papani Babiloni wayahina, taui ai yau 14 deina. Ka aituhu kavi‑putu yai nae Babiloni wayahina, ka aituhu kaiaiavi a itoava Tau Ito‑yavuha ya tupua wayahina, taui ai yau 14 deina. ");
INSERT INTO mvn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ka Iesu Tau Ito‑yavuha ya tupua taina deina. Iesu ayona Mari ivi‑awa‑kanakanapiei Iosepa wayahina, ka ainua eha ita‑vavanua, ka Mari mamaei, ka yanꞌ amwanainaha vinꞌ‑omo Nuana Ahihinata wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ka Iosepa avaha vaneana nononi deina, tauna ya nuanua vihahaiei, ka nuanuana hivahivana dewei, iuna tauna yana dewa tunutunuhina, ka eha ya nuanua Mari ini‑yauyau ananina na‑vaniahe tomotau mataia. ");
INSERT INTO mvn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ka tauna nuanua deina, e dauva ka avea Kauvea yanꞌ anelose aitam omo, e vonei, ivona, “Iosepa, wamke Davida wana, eha enua‑vita Mari yanꞌ amwanainahana wayahina. Iuna dewana Nuana Ahihinata wayahina vinꞌ‑omo. Wayahina, akanai etaini yam manua, awam. ");
INSERT INTO mvn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ka apaina natuna onotona vi‑natunei, e ana wava evi‑wahani Iesu, iuna tauna ya tomotau yai goyona wayahi na‑ito‑yavuhi.” ");
INSERT INTO mvn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dewaia habuhabui ivinꞌ‑omo deina, ka nonova tau apa‑taputapu aitam Kauvea yana vona mai‑haeyei, e Iginuma nihenina ginumi ivona, ");
INSERT INTO mvn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ahabana mata‑yauyona nꞌ‑amwanainahei, e natuna onotona vi‑natunei, ka ana wava ivi‑wahani Emanuela” (ka wava‑nana a vo‑vina “Yaubada nui kamamaei”). ");
INSERT INTO mvn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wayahina, Iosepa dauvea mini, e anelose‑nana ya vonana nua‑vi‑avini, e Mari tavinei. ");
INSERT INTO mvn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ka ainua eha ita‑dauva a itoava tevana onotona vi‑natunei wayahina. Ka Iosepa tevanana vi‑wahani Iesu. ");
INSERT INTO mvn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tutana Iesu tupua meagai Betelehem nihenina, KiniV Erodi papani Iudea veimeyei. Ka tuta‑nana wayahina tau nua‑uya tupwai yai papani ponimanea ini‑tawanei iomo meagai Ierusalem wayahina, e taui me Ierusalem ivi‑tanatanaiei, ");
INSERT INTO mvn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ivona, “Itomi me Iudea yami kiniV vovouna aveta? Anamanei avaha tupua, iuna tauna a wadima vinꞌ‑omo adueyei papani ponimanea. Wayahina, aomo ana‑iwaodu wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ka KiniV Erodi yai vonaia nononi, e ateatena viviha, ka kadu me Ierusalem yoko ateatei viviha vonaia wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wayahina, Erodi me Iudea yai tau vi‑nomu mata‑genai, kadu veimea a tau viwavenena hone‑hohoni, e wayahia vi‑tanai, ivona, “Aveta baina Tau Ito‑yavuha‑nana ya tupua?” ");
INSERT INTO mvn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka taui ivona, “Meagai Betelehem nihenina, aina papani Iudea nihenina, ka tau apa‑taputapu yana hae Iginuma nihenina deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Apaina, Betelehem wayahina me Isiraeli ai tau veimea vinꞌ‑omo. Tauna yau tomotau ai tau dune‑vi‑avina, sipiV ai tau dune‑vi‑avina deina. Aina wayahina, Betelehem meagai kaikaiwabona ka ana wava eha kikituna papani Iudea meagaina habuhabui wayahia.’” ");
INSERT INTO mvn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wayahina, Erodi tau nua‑uya‑naia hone‑hivahivai, e vi‑tanaiei avi tuta wadima‑nana vinꞌ‑omana vovou. ");
INSERT INTO mvn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ka Erodi, avaha yai nau‑pata nononi, veimeyei, ivona, “Una‑ne Betelehem wayahina, e tevana taina unene‑vidovidohei. Ka avi tuta uvaniahei, umavina umataedau, e yauke kadu ana‑ne, ana‑iwaodu wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ka kini‑nanaV ya vonana tau nua‑uya‑naia wayahia iakwa, e taui ine. Ka wadima‑nana, nonova ponimanea idudueyei mataia, ivi‑muniei, e papanina wadima‑nana ivane vꞌ‑ito‑matani, ka tenoke ine, e tevanana ivaniahei mamaei. ");
INSERT INTO mvn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ka wadima‑nana wayahina tau nua‑uya‑naia idewa‑haiawa ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ka manua inui, e tevanana ayona Mari nui idueyei, e aei ivi‑tupa‑gumi tevanana wayahina, e iaiwaodu wayahina. Ka yai pai vi‑ai iwaei, e am‑venena‑kavovo patana ani‑vainena ivitua‑neiei, iomanei, e tevanina venei, aina goulaV, ka pai mau ahiahina ana wava libanosiV, ka kadu aitam pai mau ahiahina ana wava muroV. ");
INSERT INTO mvn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ka munia, avea Yaubada tau nua‑uya‑naia mataedai eha Erodi wayahina imavina. Wayahina, imini, ka mani etawana wayahina imavina yai papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka avaha tau nua‑uya‑naia ini‑tawanei, akanai aitam anelose Kauvea wayahina avea Iosepa wayahina vinꞌ‑omo, e mataedei ivona, “Emini, ka tevana ayona nui etaini enovoei papani Egipita wayahina, e tenoke umamaei a itoava amataedam baina umavina wayahina. Yami novo taina nau‑wawanimi, iuna mosikuna Erodi tevana taina nenei na‑nau‑vi‑anigi.” ");
INSERT INTO mvn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Akaka ioyoma‑nana nihenina Iosepa mini, e tevana ayona nui taini neiei papani Egipita wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ka Egipita nihenina imamaei a itoava Erodi aniga wayahina. Iakwa, e imavina ka yai mavina vinꞌ‑omo Kauvea yana vona Iginuma nihenina deina. Aitam tau apa‑taputapu mai‑haeyei ivona, “Egipita wayahina natu ahone‑taitaini.” ");
INSERT INTO mvn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ka Erodi tau nua‑uya‑naia pota‑wayohei. Ka tutana anamanei taui eha imavina, iuna yai nua‑uya tauna ya vitupu vane‑tawanei, tauna nua‑goyo ani‑vainena. Ka ya veimea boui, e tau vi‑naua vi‑tunei ine meagai Betelehem wayahina, ka kadu ine meagai aitamoata aitamoata Betelehem awaniana wayahia, ka yaheyahe ononotoi taui ai ponimana ainua wayahina opu‑me ina‑nau‑vi‑anigi‑neiei. Erodi ya veimea boui deina, iuna tau nua‑uya‑naia yai vona wayahina Tau Ito‑yavuha ya tupua wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ka dewana vinꞌ‑omo tau apa‑taputapu ana wava Ieremia nonova mai‑haeyei deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Vi‑vonavona‑vaine kanononi meagai Rama wayahina vinꞌ‑omo, vivane ivi‑mohai ananina kadu na mata‑inui ivi‑vonevoneyei. Rakeli yai tete ivi‑mohai ka yai vi‑mohai eha ta‑biga, iuna natunatui avaha ianiga.” ");
INSERT INTO mvn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erodi yanꞌ aniga munina, Kauvea yanꞌ anelose vinꞌ‑omo Iosepa wayahina tutana tauna Egipita nihenina mamaei, ka avea vonei, ");
INSERT INTO mvn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ivona, “Iosepa, emini, ka tevana ayona nui etaini, umavina papani Isiraeli wayahina. Iuna tevana a ginibaina avaha aniga.” ");
INSERT INTO mvn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wayahina, Iosepa mini, e tevana ayona nui taini, imavina ine Isiraeli. ");
INSERT INTO mvn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ka tutana imavina iomo, Iosepa aitam vane nononi vivane Erodi natuna, ana wava Arekelausi, amana vi‑nau‑seani, e vi‑tau veimea papani Iudea nihenina. Akaka Iosepa matauta, ka eha nuanuana na‑vane papani Iudea wayahina. Ka Yaubada anamana venei avea, e Iosepa tutu‑vivina, ka ine papani Galili wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ka meagai Nasareta nihenina vi‑meagaiei. Ka dewana tau apa‑taputapu yai hae nau‑yehai, vivane, “Tauna ivi‑wahani me Nasareta aitam.” ");
INSERT INTO mvn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka tuta tanoi wayahina Ioni Tau Bapitaiso vinꞌ‑omo, ka papani Iudea anata nihenina naunau‑wahe, vonavona, ");
INSERT INTO mvn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Yami dewa goyona wayahi unua‑vinana, iuna Yaubada ya pai veimea vi‑maupwani.” ");
INSERT INTO mvn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nonova tau apa‑taputapu Isaia Ioni‑nana wayahina apa‑taputapuei, ivona, “Tau vi‑hone aitam meagai anata nihenina movina ananina wayahina si‑vinꞌ‑omanei ka vonavona, ‘Kauvea yana etawana uvo‑vi‑aiaia! Kadu uvo‑vi‑tunutunuhi!’” ");
INSERT INTO mvn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ka Ioni‑nana ana kwama moimoiana a nau‑vevewana vahitau kameliV vutuvutuna wayahina deina, ka a haiona bulumakauV wagana, ka ana maꞌ digwai kadu mamau a daudau. ");
INSERT INTO mvn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka Ioni‑nana meagai anata naunau‑wahe. Ka meagai Ierusalem a tau maꞌ, kadu papani Iudea a tau maꞌ, kadue Daudau Ioridani baimina a tau maꞌ habuhabui iomomo Ioni‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ka avaha yai dewa goyona ihaeyei, akanai tauna vi‑bapitaisoei Daudau Ioridani nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ka taui Parisi yai yoko wayahia kadu taui Sadusi yai yoko wayahia habuhabui aveta tauna bapitaiso wayahina iomomoi. Ka tutana Ioni dueyei ivona, “Itomi tau vitupu, mwata deina. Unuanua apaina Yaubada ya nua‑goyo wayahimia una‑novo ami bapitaiso ana heta wayahina, ika? ");
INSERT INTO mvn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kate avonemi eha. Nau‑wawanimi yami nua‑vinana tunuhina uviwaveneka yami dewa ahiahina wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Abaraham vivane Yaubada a niam, ka aituhu itomi unuanua taumi Abaraham a tupua‑nenenehi, ka aituhu unuanua kadu itomi Yaubada yaiana deina, yami nuanua taina eha tunuhina. Itomi eha ami pata una‑novo dewa‑yaiyai Yaubada wayahina deinake. Udueyei. Yaubada ya bagibagi ani‑vainena, ka tauna ana pata hanu taina wayahina Abaraham a tupua‑nenenehi vevewane‑neiei. Wayahina, yaka dede eha aitam aviani Yaubada matana. ");
INSERT INTO mvn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Unononi avonemi. Aituhu yami dewa eha ahiahina, akanai yawaimi aitam ai deina, ka eha uana ahiahina. Wayahina, tomotau ai‑nana iguhani, ihaponei nꞌ‑anai. Wayahina, apaina Yaubada na‑dewa‑yaiyaiemi, na‑haponemi ai ananata nihenina deina. ");
INSERT INTO mvn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tuta ataina yau paisewa taina. Aituhu aviyaivia inua‑vinana, taui avi‑bapitaisoei daudaua. Ka aitam onoto muniua omomo, ka tauna vane‑tawaneu. Eha nau‑wawaniu tauna anꞌ ae‑yapayapana ayavuhi, iuna tauna ananina ka yauke kikitu. Ka onoto‑nana ya paisewa vinꞌ‑omo Nuana Ahihinata wayahina. Ka aituhu aviyaivia ivitumahanei, taui Nuana Ahihinata ivaniahei onoto‑nana wayahina, kate aituhu aviyaivia ivihahaiei, taui ai ananata ivaniahei onoto‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ka onoto‑nana ya paisewa aitam tau baguna deina. Ka tauna na pai tana‑vewana nimana omomo. Ka apaina aituhu aviyaivia yai dewa ahiahina, taui aniani ahiahina deina. Ka aituhu aviyaivia yai dewa goyona, taui aniani mavununa deina. Ka tauna aniani ahiahina ka aniani mavununa na‑tana‑vewani, e ahiahina yanꞌ anana nihenina na‑totohi, kate goyona ai ananata‑vavaha nihenina na‑haponei.” ");
INSERT INTO mvn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ka munia, Iesu papani Galili ni‑tawanei, e omo Daudau Ioridani wayahina, ka tauna nuanua deina, “Yau nuanua vivane Ioni daudau wayahina vi‑bapitaisoeu.” ");
INSERT INTO mvn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kate Ioni, avaha Iesu ya nuanuana nononi, nuanuana vihahaiei. Wayahina, Ioni ivona, “Nau‑wawaniu wamke evi‑bapitaisoeu, iuna evane‑tawaneu. Ka aviani wayahina eomo wayahiua, e yauke avi‑bapitaisoem?” ");
INSERT INTO mvn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka Iesu Ioni ya vonana vi‑mavinei, ivona, “Tuta ataina wayahina yau nuanua akanai. Iuna aviani Yaubada ya nuanua aitamoata aitamoata, nau‑wawanika kadedewei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wayahina, Ioni awaehei, e tauna Iesu vi‑bapitaisoei daudaua. Ka tutana Iesu daudaua igayo omo, wahuma am‑waei, e Iesu Nuana Ahihinata dueyei, ana dune bunebune deina, e opu‑me hetana itoha. ");
INSERT INTO mvn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka aitam movi wahuma wayahina tomotau‑naia vonei, ivona, “Aina Natu‑hoiu, e tauna adune‑nuanuaiei ananina, kadu tauna wayahina adewa‑haiawa ananina.” ");
INSERT INTO mvn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dewaia iakwa, Nuana Ahihinata Iesu taini neiei meagai anata wayahina. Iuna tenoke nau‑wawani nua goyogoyoi ai tau veimea ana‑dibidibiei goyona wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka auyewa ai yau 40 ka ioyoma ai yau 40 nihenia, Iesu eha tꞌ‑amam, wayahina am navovo ananina. ");
INSERT INTO mvn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka tau vito‑nubu vinꞌ‑omo, ivona, “Aituhu wamke Yaubada natuna, am pata hanu taina eveimeyei ivi‑aniani.” ");
INSERT INTO mvn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka Iesu ivona, “Iginuma nihenina veimea mamaei vivane, ‘Tomotau yawai eha aniani ana heta wayahina ta‑vinꞌ‑omo, kate tomotau yawai Yaubada yana vona aitamoata aitamoata wayahia ivinꞌ‑omo.’” ");
INSERT INTO mvn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iakwa, e nua goyogoyoi ai tau veimea Iesu taini neiei meagai ahihinata wayahina, vivane Ierusalem, e Manua Vito‑pota hetana vaneyei. ");
INSERT INTO mvn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","E wayahina vonei, ivona, “Aituhu wamke Yaubada natuna, akanai nau‑wawanim taina wayahina eni‑ubau, ka eha enꞌ‑aniga, iuna Iginuma nihenina ivona, ‘Yaubada tauna yanꞌ anelose veimeyei inau‑matavem ka taui nimaia ivaneyem, eha aem evi‑tupe hanu wayahina.’” ");
INSERT INTO mvn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka Iesu ivona, “Kadu aitam vona Iginuma nihenina mamaei ivona, ‘Eha yam Kauvea Yaubada evito‑nubu.’” ");
INSERT INTO mvn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ka nua goyogoyoi ai tau veimea Iesu taini‑havinei oya ananina hetana, ka tanoi wayahina tauna pai veimea kaikaiwabo tanopi habuhabuna nihenina viwavenei Iesu dueyei. Kadu pai veimea‑naia ai tau veimea didigai viwavenei. ");
INSERT INTO mvn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ka kadu vito‑nubu‑havinei, ivona, “Aituhu ena‑iwaodu wayahiua, pai veimea tanoi habuhabuna avenem, eveimeyei, kadu didigana aitamoata aitamoata wayahia avenem, vivane didigam.” ");
INSERT INTO mvn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wayahina, Iesu yapoi, ivona, “Satana, eni‑tawaneu! Iginuma nihenina veimea mamaei, ivona, ‘Yam Kauvea Yaubada wayahina ena‑iwaodu, ka tauna ana heta yana vona evi‑ateteyei.’” ");
INSERT INTO mvn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iakwa, nua goyogoyoi ai tau veimea Iesu ni‑tawanei, ka munia, anelose Yaubada wayahina ivinꞌ‑omo iaivaitei. ");
INSERT INTO mvn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ka munia, avaha Iesu vane nononi vivane Ioni manua yohona nihenina iboui, akanai tauna mavina ine papani Galili wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka tauna ya meagai naona Nasareta ni‑tawanei ka omo meagai Kapenaum wayahina, e tenoke mamaei, ya meagai vovouna. Meagai‑nana Navu Galili maupwanina, papani taina vivane me Sebuluni ka me Napitali yai papani. ");
INSERT INTO mvn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nonova tau apa‑taputapu Isaia dewana mai‑haeyei Iginuma nihenina, ka dewaia ivinꞌ‑omo deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Me Sebuluni kadu me Napitali yai papani, aina etawana navu wayahina ka Daudau Ioridani niwanina. Papani taina vivane taui eha me Iudea yai papani Galili. ");
INSERT INTO mvn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Taui novanovana a meagai nihenina imamaei, kate ataina tuta wayahina avaha maheta ananina idueyei. Nonova aniga iwaunina a meagai nihenina imamaei, kate ataina tuta wayahina aitam maheta avaha ivane idueyei.” ");
INSERT INTO mvn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka avaha Iesu ubo‑tamana meagai Kapenaum wayahina, tauna ya nau‑wahe vi‑putu, ivona, “Yami dewa goyona wayahina unua‑vinana, iuna Yaubada ya pai veimea vi‑maupwani.” ");
INSERT INTO mvn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aitam tuta Iesu Navu Galili tania ni‑awana, e tau nau‑agida ainua dueyei inau‑agida navua. Aitam ana wava Simoni, tauna kadu ivi‑wahani Pita, ka vaneina ana wava Aniduru. ");
INSERT INTO mvn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ka Iesu honei, ivona, “Uvi‑munieu, e aviwavenemi medeina tomotau uvi‑onai.” ");
INSERT INTO mvn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka ivo‑kwayavoni, ka yai agida ini‑tawanei, ka ivi‑putu Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ka Iesu neine, e tau nau‑agida aitonu waea yai agida iauya‑numa vaniahai, taui Iamesa ka vaneina Ioni ka amai tauna ana wava Sebedi. Ka Iesu Iamesa taina ainua honei. ");
INSERT INTO mvn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ka imini, ivo‑kwayavoni, e amai waea ini‑tawanei, ivi‑putu Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu papani Galili habuhabuna tutu‑vivina, ka meagai aitamoata aitamoata yai manua tapanono nihenia viwavenei, ka Vaneana Ahiahina Yaubada ya pai veimea wayahina naunau‑waheyei, kadu tomotau ai kwanaha aitamoata aitamoata kadu muya aitamoata aitamoata vo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wayahina, Iesu yana dewa vaneana neine papani Siria meagaina habuhabuna wayahia, e inononi. Akaka papani Siria a tau maꞌ ine, e tau kwanakwanaha habuhabui iomanei Iesu wayahina. Taui tupwai ivi‑kwanaha ananina, ka tupwai inini viviha, kadu tupwai nua goyogoyoi iveimeyei inaunau‑wanana, e tupwai ai kwanaha wayahina inini si‑bananaitena, kadue tupwai tau penapena. Ka Iesu habuhabui vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wayahina, yoko ananina ivi‑putu Iesu ivi‑muniei. Tomotaui tau maꞌ papani Galili wayahina, ka papani Dekapolisi wayahina, kadue tau maꞌ Ierusalem wayahina, ka papani Iudea wayahina, ka kadu taui Daudau Ioridani papanina wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ka Iesu avaha yoko‑naia ananina inau‑hohona iakwa dueyei, e tauna ivane oya, e tanoi wayahina manuena. Ka a tau vi‑muni‑waiwai kadu ivane‑me iomo wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ka Iesu vi‑putu viwavenena wayahia, vonavona, ");
INSERT INTO mvn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aituhu aviyaivia avaha ianamanei taui awakabi Yaubada matana, ka eha aitam aviani yai dewa wayahia Yaubada nꞌ‑apa‑vidovidohe, ");
INSERT INTO mvn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aituhu aviyaivia ataina ivi‑mohai, ");
INSERT INTO mvn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aituhu aviyaivia eha ita‑nua‑vane, ka taui ai wava eha ananina tomotau mataia, ");
INSERT INTO mvn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aituhu aviyaivia yai nuanua ananina Yaubada ya nuanua ivi‑ateteyei, ");
INSERT INTO mvn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aituhu aviyaivia mani tomotau iate‑nuanuaiei, ");
INSERT INTO mvn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aituhu aviyaivia yai nuanua eha tana‑vewanina, kate tuta tuta yai nuanua maheta nuai vo‑vi‑mahetei, ");
INSERT INTO mvn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aituhu aviyaivia havia ivo‑vi‑gomani ivi‑yaiana, ");
INSERT INTO mvn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aituhu aviyaivia Yaubada yana vona ivi‑ateteyei, kate inahe ivaniahei yai dewa tunutunuhina wayahina, ");
INSERT INTO mvn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ka aituhu aviyaivia itomi wayahimia uvi‑muni‑waiwaieu, ka aituhu mani tomotau inau‑vonuvonuemi, kadu ivi‑ginibaiemi, kadue yai vitupu wayahina iapa‑goyogoyoemi yauke taua wayahiu, akanai, taumi avaha nau‑iaiava uvaniahei deina. ");
INSERT INTO mvn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Avaha uanamanei tuta nonova a itoava tuta ataina wayahina, Yaubada ya tau apa‑taputapu inahe ivaniahei tomotau wayahia aitamoata deinake. Wayahina, vona ahiahina, nau‑wawanimi udewa‑haiawa ani‑vainena. Iuna Yaubada ami nau‑pata ahiahina poyꞌ‑avini wahuma, ka apaina uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Itomi au tau vi‑muni‑waiwai tau maꞌ tanopi una‑ivaitei, niuna aniani na‑ivaitei deina. Aituhu niuna wetona iopu iakwa, unana eha ana pata vidoha‑havine. Akanai, tomotau ivihahaiei, iepa‑yavunei etawana wayahina, ka tomotau iva‑taunei tanopia. ");
INSERT INTO mvn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ka kadu itomi lampaV a maheta tau maꞌ tanopi wayahi deina. Aituhu aitam meagai atu‑oyaoyana hetana mamaei, eha ana pata tomotau meagai‑nana ihive. ");
INSERT INTO mvn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kadu deinake, avi tuta lampaV katunu, eha kunia kata‑tana‑kabubu lampaV hetana. Eha yaka dewa deina. Kate yaka dewa lampaV a pai vi‑ai hetana kaboui, e manua habuhabuna na‑mahetei, e lampanaV tomotau habuhabuna manuana nihenina ivaitei deina. ");
INSERT INTO mvn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Itomi kadu lampaV deinake. Nau‑wawanimi yami maheta unꞌ‑awaehei na‑mahetei tomotau mataia, e taui yami dewa ahiahina idueyei deina, ka apaina taui Amami wahuma inꞌ‑awa‑davei. ");
INSERT INTO mvn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kaiwadi, tupwami unuanua yau paisewa wayahina yauke aomo iuna Mosese ya veimea anꞌ‑epa‑yavunei, o kaiwadi, unuanua aviani Yaubada vonemi tau apa‑taputapu yaꞌ iginuma nihenina anꞌ‑epa‑yavunei. Kate yau paisewa eha deina. Yau paisewa vivane Yaubada yana vona habuhabuna anꞌ anamana aviwavenemi, unꞌ‑anamane‑vidoha. ");
INSERT INTO mvn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka memeanina nuami vi‑tupatupa, kate avonemi, mani viwavenena eha ana pata Yaubada yana vona na‑nau‑seani. Ka Iginuma habuhabuna akanai mamaei bana mamanaina a itoava apa‑taputapu aitamoata aitamoata ivinꞌ‑omo ina‑iakwa wayahina. Apaina wahuma kadu tanopi imaiova, kate Iginuma maꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ka aituhu aviyaivia aitam veimea kikitu‑vainena Yaubada ya Veimea nihenina ivihahaiei, itana‑bwegebwegei, kadu aituhu taui mani tomotau iviwavenei itana‑bwegebwegei aitamoata deina, apaina taui ai wava ipu‑hoina Yaubada ya pai veimea nihenina. Kate aituhu aviyaivia Yaubada ya Veimea idewa‑nubunubui, kadu aituhu taui mani tomotau iviwavenei ivi‑ateteyei, apaina taui ai wava ani‑vainena Yaubada ya pai veimea nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aituhu Parisi yai dewa yami dewa vane‑tawanei, o aituhu veimea a tau viwavenena yai dewa yami dewa vane‑tawanei, itomi eha ami pata Yaubada ya pai veimea uvaniahe. Iuna Parisi kadu veimea a tau viwavenena iviwavenena tunuhina, kate taui eha ita‑dewa‑nubunubu. ");
INSERT INTO mvn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Unononi avo‑vi‑mahetemi. Avaha uanamanei tuta nonova wayahina Yaubada ya veimea yaka tupua‑nenenehi veimeyei, ivona, ‘Eha enau‑vi‑aniga’, ka ‘kadu aituhu aviyaivia inau‑vi‑aniga, akanai dewa‑yaiyai ivaniahei.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kate ataina avonemi tunina. Aituhu koiaka nua‑goyo a niam wayahina, apaina dewana wayahina Yaubada na‑nau‑yanahi, ka a dewa‑yaiyai vaniahei. Kadue aituhu koiaka a niam apa‑goyogoyoei, aka veimea veimeyei vivane Sanederini yoko tauna a dewa‑yaiyai ivi‑nua‑dadani. Kate ataina avonemi tunina. Aituhu koiaka a niam vonei, ‘Taum kwavakwavam,’ apaina Yaubada tauna a dewa‑yaiyai vi‑nua‑dadani, ka kaiwadi, tauna na‑nu ai ananata nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","O aituhu avaha yam am‑venena‑kavovo eomaomanei pai am‑venena wayahina, e enꞌ‑am‑venena Yaubada wayahina, ka aituhu yam dewana niwanina enuani, ‘Ia! Au niau ya nua‑vita mamaei. Iuna yauke yau goyona wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Aituhu enuani deina, nau‑wawanim yam am‑venena‑kavovo eboui pai am‑venena nepena, ka naona emavina am niam wayahina, e nui uvi‑niana‑havine. Iakwa, akanai emavina, e yam am‑venena‑kavovona Yaubada wayahina enꞌ‑am‑venena. ");
INSERT INTO mvn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","O aituhu yam goyona wayahina aitam onoto epam, e neiem tau vaneneha matana wayahina, e apa‑goyogoyoem, yauke avonem tutana etawana nui uneine, aituhu evo‑vi‑tunutunuhi‑kwayavoni, evidoha deina. Iuna aituhu vitana matana a manua uvaniahei, kaiwadi, tau vanenehana aitam tau nau‑havia veimeyei poyꞌ‑avinim, neiem manua yohona nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Memeanina nuam vi‑tupatupa, kate avonem, eha am pata manua yohonana eni‑tawane a itoava am aga habuhabuna enau‑pata‑yehai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Avaha uanamanei nonova Yaubada ya veimea yaka tupua‑nenenehi veimeyei, ivona, ‘Eha ekenene.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kate aveimeyemi tunina. Aituhu avi onoto vavine wayahina nuanua‑hivahiva, tauna nuana nihenina avaha kenene vavinena wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wayahina, aituhu goyona vinꞌ‑omo matam ateim ya dunea, e vo‑vi‑peum, nau‑wawanim matam emoi‑yavunei. Viha‑nana eha ananina, ka tupwana. Ahiahina wayahim aituhu hutam aitamoata evo‑haini deina. Iuna aituhu goyona vi‑peum, apaina Yaubada yam dewa‑yaiyai vi‑nua‑dadani, e kaiwadi, tauna veimeyem vivane ininim habuhabuna ihaponei ena‑opu ai ananata nihenina. Aina viha‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka kadu aituhu goyona vinꞌ‑omo nimam ateim ya dewea, e vo‑vi‑peum, nau‑wawanim nimam eupwa‑yavunei. Viha‑nana eha ananina, ka tupwana. Ahiahina wayahim aituhu hutam aitamoata evo‑haini deina. Iuna aituhu goyona vi‑peum, apaina Yaubada yam dewa‑yaiyai vi‑nua‑dadani, e kaiwadi, tauna veimeyem vivane ininim habuhabuna ihaponei ena‑opu ai ananata nihenina. Aina viha‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Avaha uanamanei nonova Yaubada ya veimea yaka tupua‑nenenehi veimeyei, ivona, ‘Aituhu onoto aitam nuanuana apaina awana na‑vaiobuei, naona onotona nau‑wawani yana leta ginumi, awanana venei, ka munia, ainua ivaiobu.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kate ataina aviwavenemi tunina. Aituhu aitam vavine eha ta‑kenene, ka aituhu awana ya nuanua na‑vaiobuei, onotona ya nuanuana vivane goyona. Apaina, kaiwadi, vavinena tavine‑tamana mani onoto wayahina. Aituhu deina, vavinena avaha kenene. Kate iuna kenene‑nana wayahina vivane vavinena awana naona yana dewa goyona. Ka aituhu onoto vꞌ‑inuana vavinena tavine, tauna kadu kenene deina. Iuna Yaubada matana nihenina vaiobu‑nana tavine naona eha ta‑kweui, akanai mamaei. ");
INSERT INTO mvn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kadu avaha uanamanei nonova aitam Mosese ya veimea yaka tupua‑nenenehi wayahia ivona, ‘Avi tuta evona‑dabadaba Kauvea wayahina, aituhu tauna ana wava etomani, eha am pata yam vona‑dabadabana evo‑vine, kate nau‑wawanim enau‑yehai.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kate ataina aviwavenemi tunina. Vona‑dabadaba aitamoata aitamoata ivinꞌ‑omo Yaubada matana. Wayahina, eha evona‑dabadaba. Eha evona, ‘Avona‑dabadaba Kauvea a wavea.’ Kadu eha evona, ‘Avona‑dabadaba wahuma wayahina,’ iuna Yaubada ya pai manuena ahihi‑vainena wahuma nihenina mamaei, ka avaha Kauvea ana wava etomani deina. ");
INSERT INTO mvn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kadu eha evona, ‘Avona‑dabadaba tanopi wayahina,’ iuna Yaubada aena a pai vi‑ai ahihi‑vainena vivane tanopi, ka avaha Kauvea ana wava etomani deina. Kadu eha evona, ‘Avona‑dabadaba meagai Ierusalem wayahina,’ iuna Ierusalem vivane Yaubada ya meagai, tauna KiniV Bagibagi‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kadue eha evona, ‘Avona‑dabadaba taua ununu wayahina,’ iuna wamke eha am pata apanam aitamoata eveimeye na‑vo‑vi‑kavui o na‑vo‑vi‑nigei, a? ");
INSERT INTO mvn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wayahina, akanai ena‑vona, ‘Ika, apaina adewei deina,’ o kadi ena‑vona, ‘Eha, apaina eha adewe deina.’ Aituhu kadu aitam vona ebou yam vona hetana, vonana hetana vinꞌ‑omo Satana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Avaha uanamanei nonova, avi tuta aitam tomotau gonia vaniahei a niam wayahina, Yaubada ya veimea yaka tupua‑nenenehi veimeyei, ivona, ‘Mata aitamoata a nau‑pata mata aitamoata, kadu niho aitamoata a nau‑pata niho aitamoata.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kate ataina aviwavenemi tunina. Aituhu tomotau goyogoyona vi‑goyom, eha enau‑pata goyo‑nana wayahina. Aituhu koiaka awayaem ateim piahi, akanai awayaem akenim enꞌ‑awaehei kadu na‑piahi. ");
INSERT INTO mvn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O aituhu koiaka ya nuanua vitana matana wayahina am kwama nꞌ‑epei, kadu yam sita hetana evenei. ");
INSERT INTO mvn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O aituhu koiaka (tau nau‑havia deina) veimeyem ya gugua ehunia aitam meagai wayahina (deina me Rom yai veimea tauna awaehei, meagai aitamoata akanai), nau‑wawanim eawaehei kadu meagai vꞌ‑inuana wayahina ehunia ena‑ne. ");
INSERT INTO mvn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kadu aituhu koiaka vinꞌ‑omo wayahima, e viama aitam amane wayahima, amanena evenei, ka eha yam gugua enua‑tania. O aituhu koiaka vinꞌ‑omo wayahima, e ya nuanua aitam amane evenei, ka aituhu tauna vonem, ‘Apaina amanena anau‑patam,’ eha evihahaie. ");
INSERT INTO mvn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Avaha uanamanei nonova Yaubada ya veimea yaka tupua‑nenenehi veimeyei, ivona, ‘Yaiami udewa‑vidovidohei, kate ami havia unau‑nikonikoiei.’ ");
INSERT INTO mvn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kate ataina aviwavenemi tunina. Ami havia kadu udewa‑vidovidohei! Ka aituhu aviyaivia ivo‑vi‑vihami, nau‑wawanimi uviama wayahi Yaubada na‑ivaitei. ");
INSERT INTO mvn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","E aituhu yami dewa deina, akanai Yaubada wahuma ivona wayahimi, ‘Taui natunatu‑hoiu.’ Iuna tauna babau a maheta awaehei vanavana tau goyogoyona wayahi ka kadu tau ahiahina wayahi. Kadu deinake, yana wei awaehei atuatuna tau tunutunuhi wayahi ka kadu tau goyogoyoi wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Udueyei. Aituhu yaiami ai heta udewa‑vidovidohei, dewana eha aitam aviani ahiahina Yaubada matana. Iuna tau goyogoyona, takesiV a tau vitua deina, yaiai idewa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","O aituhu vavaneimi ai heta unau‑kaiwei, ka eha mani tomotau, medeina yami dewana ahiahina Yaubada matana? Iuna taui eha Yaubada itꞌ‑anamane vavanei inau‑kaiwei deinake. ");
INSERT INTO mvn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ka taumi nau‑wawanimi uvi‑muni‑waiwaieu, ka nau‑wawanimi tomotau habuhabui udewa‑vidovidohei, Amami wahuma yana dewa deina.” ");
INSERT INTO mvn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu ya viwavenena auyewana neine deina, ivona, “Avi tuta nuanuami taui payapayaya wayahia unꞌ‑am‑venena‑kavovo, eha tomotau mataia udewadewa. Aituhu udewadewa deina, apaina eha ami nau‑pata uvaniahe Amami wahuma wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ka avi tuta unꞌ‑am‑venena‑kavovo payapayayai wayahia, eha udedewe tau viam‑nonona yai dewa deina. Avi tuta tau viam‑nonona iam‑venena‑kavovo payapayayai wayahia manua tapanono nihenina, o kaiwadi etawana wayahina, naona taui bwegigi ivaivaini. Iuna yai nuanua tomotau matai inꞌ‑onei idudueyei, e tomotau‑naia inꞌ‑apa‑vidovidohei. Memeanina nuami vi‑tupatupa, kate avonemi, taui ai nau‑pata habuhabuna avaha ivaniahei tuta ataina‑ohota wayahina ka baina tanopia. Eha kadu aitam aviani potapotai wahuma. ");
INSERT INTO mvn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kate itomi avi tuta unꞌ‑am‑venena‑kavovo, akanai nau‑wawanimi ugenuana, ka eha una‑ipupu yami dewa wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ka unꞌ‑am‑venena‑hivahiva deinake. Aituhu udedewei deina, akanai tomotau eha idudueyemi, kate Amami dewa hivahivana aitamoata aitamoata dudueyei, kadu tauna ana heta yami am‑venena‑kavovo hivahivana dudueyei, ka munia, tauna nau‑pata ahiahina venemi uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ka avi tuta uviama Yaubada wayahina, eha udedewe tau viam‑nonona yai dewa deina. Avi tuta tau viam‑nonona iviama, taui yai nuanua ananina imimini manua tapanono nihenina, o kaiwadi imimini etawana mutuna wayahina, e iviama. Yai dewa deina, iuna yai nuanua ananina tomotau matai inꞌ‑onei idudueyei, inꞌ‑apa‑vidovidohei. Memeanina nuami vi‑tupatupa, kate avonemi, taui ai nau‑pata habuhabuna avaha ivaniahei, vivane tomotau iawa‑davei. ");
INSERT INTO mvn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kate taumi, avi tuta uviama, akanai naona yami bubuna‑honota unui nihenina, ka avaha awana ugudui, akanai Amami nui uviama‑hivahiva wayahina deina. Ka Amami avaha dewa hivahivana aitamoata aitamoata anamane‑yehai, ka munia, tauna ana heta na‑nau‑patami. ");
INSERT INTO mvn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kadu avi tuta itomi uviama, eha uvona‑havihavine. Tau maꞌ novanovana igwenigweni deina, ka ivitumahana yai viama ai nau‑pata ivaniahei iuna itomani‑havihavine. ");
INSERT INTO mvn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Eha uviama taui deina. Iuna aviani nau‑wawanimi, akanai Amami mai‑anamanei munia amane‑naia wayahi uviama. ");
INSERT INTO mvn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wayahina, avi tuta uviama, viama taina yami pai dune. ");
INSERT INTO mvn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ka yama nuanua eveimeyeai. ");
INSERT INTO mvn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ka ama maꞌ ataina wayahina eveneai. ");
INSERT INTO mvn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ka yamꞌ aga wayahima enua‑piahi, ");
INSERT INTO mvn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ka kadu eha enau‑dadaneai ananina, ");
INSERT INTO mvn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aituhu yaiam yai goyona wayahima enua‑piahi, munia Amam wahuma kadu na‑nua‑piahim yam goyona wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ka aituhu eha yaiam yai goyona enua‑piahi, munia Amam eha na‑nua‑piahim yam goyona wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kadu avi tuta yami tapanono wayahina am uvihahaiei dewa‑didiguna wayahina, eha unua‑vita tepamia tau viam‑nonona yai dewa deina. Tau viam‑nonona inua‑vita tepaia, iuna yai nuanua tomotau tepai idueyei, inꞌ‑anamanei vivane idewa‑didiguna, e dewana wayahina inꞌ‑apa‑vidovidohei. Memeanina nuami vi‑tupatupa, kate avonemi, taui ai nau‑pata habuhabuna avaha ivaniahei, vivane tau maꞌ tanopi iawa‑davei. ");
INSERT INTO mvn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kate avi tuta am evihahaiei dewa‑didiguna wayahina, tepam enau‑vunahi kadue evꞌ‑imta. ");
INSERT INTO mvn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ka aituhu yam dewa deina, eha memeanina tomotau inꞌ‑anamanei edewa‑didiguna. Wayahina, yam dewa‑hivahiva taina Amam wahuma ana heta dueyei. Ka apaina am nau‑pata ahiahina evaniahei tauna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Eha yami kaikaiwabo baina tanopia ugwaugwaui. Iuna kaikaiwabo tanopia imavunu, ka itoi, ka igoyo deina, kadu baina tanopia tau vainau yami manua inuinui, ivainaui. ");
INSERT INTO mvn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kate taumi nau‑wawanimi yami kaikaiwabo ugwaugwaui wahuma nihenina. Iuna kaikaiwabo wahuma eha imavunu, ka eha itoi, ka tau vainau eha ai pata ivainaui. ");
INSERT INTO mvn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Avonemi deina iuna aituhu aviani kaikaiwabona matamia o kadi aviani uvitumahanei ananina nuami nihenina, akanai tuta tuta dewaia o guguaia wayahina unuanua. ");
INSERT INTO mvn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mataka vivane ininika a lampaV deina. Aituhu eha aitam goyona matakaia, maheta ana pata nuinu nuaka nihenina. E dewa tunutunuhina natanata nihenikaia deina. ");
INSERT INTO mvn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka aituhu mataka goyogoyona, maheta eha ana pata na‑nu nuaka nihenina. Wayahina, dewa goyona natanata ininikaia deina. Kaiwadi, wamke evitumahanei, ‘O ahiahina. Maheta nuinu nuau nihenina,’ kate aituhu maheta‑nana vivane maheta vitupu, yawaim novanovana ani‑vainena mamaei! ");
INSERT INTO mvn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ka kadu avo‑vi‑mahete‑havinemi deina. Eha ami pata tuta aitamoata nihenina kauvea ainua wayahi uvi‑tau paisewa. Apaina aitam kauvea unau‑nikonikoiei, ka aitam udune‑nuanuaiei, o kadi aitam kauvea unꞌ‑apa‑vidovidohei, kate aitam unꞌ‑apa‑goyogoyoei. Wayahina, eha ami pata tuta aitamoata nihenina Yaubada wayahina kadu kina tanopia wayahina uvi‑tau paisewa. ");
INSERT INTO mvn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wayahina, pai mini ananina taina avonemi. Eha unuanua toyoina yami maꞌ tanopia wayahina, vivane ami maꞌ ana pata o eha, o ami daudau ana pata o eha, o kadi ami kwama ana pata o eha. Iuna yawaika dewa ananina wayahikaia, kate guguaia ininika wayahina eha aitam dewa ananina. ");
INSERT INTO mvn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Taina aitam pai dune avenemi. Manua yaveyaveha wayahia udunedune, ka unuanua wayahi. Eha aitam tuta manua‑naia ita‑bagubaguna, kadu eha itꞌ‑aihana, kadu eha yai anana ita‑totohi. Iuna Amami wahuma ai maꞌ venevenei. Yaubada manua‑naia dewa‑vidovidohei, kate tauna itomi tomotau dewa‑vidovidohemi ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ka aituhu unuanua toyoina yami maꞌ wayahina, aviani ta‑vinꞌ‑omo? Ami pata yawaimi uvo‑vi‑manamanaia deina? Eha ami pata. ");
INSERT INTO mvn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wayahina, aviani wayahina unuanua toyoina ami kwama wayahi? Ka buyeta wayahia udunedune, ka unuanua wayahi. Taui eha ita‑paipaisewa ananina ai kwama wayahina, kadu eha ita‑mai‑nuanua medeina ai kwama inau‑vevewanei. ");
INSERT INTO mvn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kate vona ahiahina, tuta nonova wayahina KiniV Solomoni kaikaiwabo ananina, kadu tauna ana kwama kadu a vaivana ahiahina, kate avonemi buyeta ana dune ahihi‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Unuanua. Ataina buyeta itapatapa, ka ma‑putua ipeu, ka tomotau ihaponei ai ananata nihenina. Kate Yaubada buyeta ana kwama ahihi‑vainena vevewanei. Yaubada ya dewana vivane ahiahina buyeta wayahina, ka buyeta eha aitam aviani. Wayahina, nau‑wawanimi uvitumahana tunuhina Yaubada yana dewa wayahimi vivane ahiahina. Iuna itomi tomotau buyeta uvidoha‑tawanei. Ataina yami vitumahana kikituna, kate nau‑wawanimi Yaubada uvitumahana‑vavahi. ");
INSERT INTO mvn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wayahina, eha nau‑wawanimi uvi‑putu unuanua toyoina ka ami heta uvonevonemi, ‘Aviani anꞌ‑ani? Aviani ana‑nim? Aviani aweteni?’ ");
INSERT INTO mvn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Taui eha Yaubada itꞌ‑anamane inuanua toyoina guguaia wayahia deinake. Kate Amami wahuma avaha anamanei itomi nau‑wawanimi ami maꞌ, ka ami daudau, kadue ami kwama, ka tauna guguaia venevenemi akanai. ");
INSERT INTO mvn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kate itomi nau‑wawanimi naona Yaubada ya pai veimea, kadu yana etawana tunutunuhina unaunau‑nene wayahia, uvaniahei. Aituhu yana etawana uvi‑muniei deina, akanai tauna ami maꞌ, kadu ami kwama venevenemi akanai. ");
INSERT INTO mvn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wayahina, eha unuanua toyoina aviani ta‑vinꞌ‑omo ma‑putua wayahina. Iuna auyewa aitamoata aitamoata ana vita iomomo, ka vita‑naia akanai ataina wayahina. Eha nau‑wawanimi auyewa ataina ana vita ma‑putua ana vita nui uvi‑popoi.” ");
INSERT INTO mvn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu ya viwavenena auyewana wayahina neine deina, ivona, “Eha mani tomotau uapa‑goyogoyoe. Aituhu tomotau uapa‑goyogoyoe, apaina Yaubada nꞌ‑apa‑goyogoyoemi. ");
INSERT INTO mvn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Avi apa‑goyogoyo yami nuanua mani tomotau wayahi, apaina apa‑goyogoyo‑nana uvaniahei Yaubada wayahina deinake. Yami itoava mani tomotau wayahi vivane ami itoava Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ka wamke medeina? Wamke matama idebona deina mamaei ka eha eta‑dudueye. Wayahina, medeina vaneim matana nihenina ai kamukamumuna wayahina edunedune? ");
INSERT INTO mvn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","O aviani wayahina vaneim wayahina ena‑vona, ‘Ena‑pota. Ai kamukamumuna matama anꞌ‑epa‑yavunei,’ kate eha am pata, iuna idebona matama mamaei? ");
INSERT INTO mvn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Vona ahiahina, wamke aitam tau vitupu. Nau‑wawanim naona idebona matama enꞌ‑epa‑yavunei. Na‑iakwa, edune‑vidoha, ka munia, am pata vaneim matana ai kamukamumuna enꞌ‑epa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Eha Yaubada yana vona ahihinata tomotaui yai dewa kedewa deina enꞌ‑am‑venena‑kavovo. Iuna kedewa eha dewa ahihinata itꞌ‑anamane. Apaina vonana ivihahaiei ka wamke avaha edewa‑wayohei wayahia deina. Kadu eha nau‑wawanim tomotaui yai dewa pono yai dewa deina eviwavenei. Iuna yami viwavenena taitainene deina, kate pono eha itꞌ‑anamane taitainene aviani. Wayahina, apaina iva‑vi‑gawagawami. Ka imavina wayahima, ihovam, kadu ivita‑vovonim. ");
INSERT INTO mvn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aituhu eviama Yaubada wayahina, akanai apaina yam viama evaniahei tauna wayahina. Kadu aituhu enaunau‑nene, apaina evaniahei. Ka aituhu etutu‑keakeana, apaina tauna awa‑pota na‑waei wayahim. ");
INSERT INTO mvn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iuna, aituhu aviyaivia iviama Yaubada wayahina, apaina taui nau‑pata ivaniahei. Ka aituhu aviyaivia inaunau‑nene, apaina kadu ivaniahei. Kaduke aituhu aviyaivia itutu‑keakeana, apaina taui wayahi gani na‑waei. ");
INSERT INTO mvn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Udueyei. Aituhu aitam tevana wayahimia am navovo, ka aituhu tauna viamemi palaua uvenei, itomi yami dewa medeina? Eha memeanina natunatumi hanu uvenei. ");
INSERT INTO mvn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O kaiwadi, aituhu natunatumi iana wayahina iviamemi, eha memeanina mwata uvenei. ");
INSERT INTO mvn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vona ahiahina, itomi tau goyogoyomi, kate taumi avaha uanamanei am‑venena ahiahina natunatumi uvenevenei. Wayahina unuani. Amami wahuma tauna ahihinata, ka tauna ya nuanua ananina, aituhu aviyaivia iviamei, akanai dewa ahiahina na‑venei. ");
INSERT INTO mvn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wayahina, vona ananina avonemi ataina. Aviani yami nuanua tomotau idedewei wayahimi, akanai nau‑wawanimi udedewei taui wayahi aitamoata deina. Vonana vivane pai mini ananina Mosese ya veimea nihenina kadue pai mini taina tau apa‑taputapu yai iginuma a nau‑itava. ");
INSERT INTO mvn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Itomi nau‑wawanimi awa wayowayona wayahina una‑nui, e yawai ahiahina uvaniahei deina. Iuna vita‑vovona anꞌ awa bababana, ka memeanina tomotau etawanana ivaniahei. Ka tomotau habuhabui etawanana ivi‑muniei deina, ka apaina Yaubada na‑vita‑vovona‑vavahi. ");
INSERT INTO mvn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kate yawai ahiahina anꞌ awa vivane wayawayo‑vainena, kadue eha memeanina tomotau etawanana ivaniahe, ka vitana wayahi ivi‑muniei. Vona ahiahina, tomotau aitonuata ivaniahei kadu ivi‑muni‑waiwaiei. ");
INSERT INTO mvn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Itomi udune‑vivinimi, ka eha tau apa‑taputapu vitupu unꞌ‑awaehe inonomi. Iuna apaina tau vitupu tupwai iomomo wayahimia, ka ai dune inua‑opu deina, sipiV deina. Kate nuai nihenina taui kedewa manimanini deina, ka yai nuanua vivane ivita‑vovonimi. ");
INSERT INTO mvn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka apaina taui yai dewa wayahina unꞌ‑anamanei. Unononi. Mata‑duduna wayahina eha aka pata uana dibidibina kaponui. Iuna mata‑duduna eha ana pata vi‑madaiba. ");
INSERT INTO mvn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Avaha uanamanei, aituhu ai ahiahina, akanai uana ahiahina. Ka aituhu ai goyona, akanai uana kadu goyona. ");
INSERT INTO mvn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Vona ahiahina, aituhu ai ahiahina, eha ana pata uana goyona ta‑vinꞌ‑omo wayahina. Ka kadu deina, aituhu ai goyona, eha ana pata uana ahiahina ta‑vinꞌ‑omo ai‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wayahina, unuani. Aituhu aitam ai eha ta‑ua ahiahina, katana‑yavunei, katunu nꞌ‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Avona‑havinemi, itomi ami pata tau apa‑taputapu vitupu unꞌ‑anamanei yai dewa bwagona wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tomotau habuhabui iapa‑vi‑kauveau, kate ataina avonemi, aitamoata aitamoata wayahia eha ai pata inunu‑me Yaubada ya pai veimea nihenina. Kate aituhu aviyaivia ai pata Yaubada ya pai veimea ina‑nu‑me, akanai taui Amau wahuma ya nuanua idedewei. ");
INSERT INTO mvn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tuta omomo wayahina, aitam auyewa wayahina yauke yau tomotau avi‑nua‑dadanei. Ka apaina auyewana wayahina, tomotau habuhabui wayahiua ina‑vona, ‘O Kauvea, kaiwa ananina. Nonova apaipaisewa wayahim, kadu am wava anaunau‑waheyei, kadu nua gawagawami tomotau wayahia asi‑vi‑ni‑ubauei, kaduke dewa pai nua‑tupatupa adedewei am wavea.’ ");
INSERT INTO mvn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kate tomotau habuhabui mataia yauke tau vona‑naia avonei, ana‑vona, ‘Tuta nonova a itoava tuta ataina wayahina, eha atꞌ‑anamanemi aviyaivia. Taumi tau goyogoyomi. Wayahina, una‑opu wayahiua!’ ");
INSERT INTO mvn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aituhu aviyaivia yau vonana inononi kadu aituhu ivi‑ateteyei, taui aitam tau yona manua nuanua‑uyana deina, e ya manua hanu hetana yonei. ");
INSERT INTO mvn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Munia wei ananina atuatuna, kadu diwaya itaina iopu, kaduke yahina ananina hunahuna. Kate dewaia habuhabui eha ai pata. Apaina ya manua mimini. Iuna tauna ya manua hanu hetana yonei. ");
INSERT INTO mvn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kate aituhu aviyaivia yau vonana inononi, kate aituhu eha ita‑vi‑ateteye, taui aitam tau yona manua kwavakwavana deina, e ya manua magama hetana yonei. ");
INSERT INTO mvn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Munia wei ananina atuatuna, kadu diwaya itaina iopu, kaduke yahina ananina hunahuna. Akaka manuana am‑bwata‑vinei kadu am‑bwege‑vainei.” ");
INSERT INTO mvn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ka avaha Iesu ya nau‑wahena nau‑yehai deina, yoko‑nana nuai vi‑tupatupa ananina ya viwavenena wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ka taui ivonavona, “Yaubada tauna ya nua‑uya ananina venei. Wayahina, ya viwavenena vivane tunutunuhina ka bagibagina, eha Mosese ya veimea a tau viwavenena yai viwavenena ihanuana deina.” ");
INSERT INTO mvn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ya nau‑wahena iakwa, e Iesu oyea opu‑me, ka yoko ananina ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka aitam onoto wayahia ininina igoyo ananina aitam muya wayahina, vivane lepero. Ka Mosese yai veimea nihenina ivona deina, aituhu aviyaivia muyana epei, taui eha ai pata mani tomotau nui itapanono, ka mani tomotau eha ai pata ivo‑dadana. Ka tau leperona omo Iesu wayahina, vi‑tupa‑gum, ka viamei, ivona, “Kauvea, avaha anamanem, ka aituhu yam nuanua, memeanina wayahim evo‑vi‑aiaieu, avidoha.” ");
INSERT INTO mvn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Akaka Iesu nimana tunei, e onotona ininina vo‑dadani, e ivona, “O ahiahina, yau nuanua deina. Evidoha!” Ka onotona a lepero iakwa‑kwayavoni ka ininina vi‑vovouna. ");
INSERT INTO mvn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka Iesu vonei, ivona, “Ena‑ne, kate eha aitam koiaka kaduke dewana wayahina emataede. Ka ena‑ne tunutunuhina tau vi‑nomu wayahina, e tauna eviwavenem vivane avaha evidoha. Kadu aviani Mosese ya veimea veimeyeka vidohana wayahina, evi‑nomu Yaubada wayahina deina. Dewana na‑iakwa, e akanai tomotau habuhabui inꞌ‑anamanem avaha evi‑vovouna.” ");
INSERT INTO mvn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka Iesu omomo meagai Kapenaum wayahina, ka me Rom yai tau nau‑havia ai tau eta‑naonao aitam omo ka viama Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ka tauna ivona, “Kauvea, yau tau paisewa ana viha ani‑vainena wayahina bebebewa. Tauna yau manua nihenina dauva‑ohota.” ");
INSERT INTO mvn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Akaka Iesu ivona, “Nui kana‑nei yam manua, e tenoke avo‑vi‑aiaiei.” ");
INSERT INTO mvn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka tau eta‑naonaona Iesu ya vonana vona‑nau‑patei, ivona, “Kauvea, wamke ananim, ka yauke kikitu. Wayahina, eha nau‑wawaniu paisewa ananina avenem, eomo yau manua wayahina. Akanai baina evona‑ohota, e yam veimeata wayahina ana pata yau tau paisewa vidoha akanai. ");
INSERT INTO mvn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iuna yauke avaha veimea a venavenau anamane‑yehai. Iuna, yauke au tau veimea mamaei, ka tuta tuta iveimeyeu, avi‑ateteyei. Kaduke tau nau‑havia tupwai aveimeyei, ka tuta tuta ivi‑ateteyeu aitamoata deina. Aitam aveimeyei, avona, ‘Ena‑nei!’ e tauna neine. E kadu aitam aveimeyei, avona, ‘Enꞌ‑omoi!’ e tauna omomo. Kaduke yau tau paisewa aveimeyei, avona, ‘Ataina edewei!’ e tauna dedewei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ka avaha Iesu onotona ya vonana nononi, tauna nuana vi‑tupatupa dewa‑haiawa ananina wayahina. Akaka, magigino ka yokoia ivi‑muniei vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi. Onoto taina ya vitumahana ani‑vainena! Eha kadu aitam koiaka ata‑vaniahe me Isiraeli wayahimia ya vitumahana deina. ");
INSERT INTO mvn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Apaina, tomotau habuhabuna papani ponimanea kadu aunupua wayahia vivane papani aitamoata aitamoata wayahia iomomo wayahiua, ka Abaraham, ka Isaki, ka Iakobo nui inꞌ‑am, nau‑hohona ananina nihenina Yaubada ya pai veimea nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ka tupwai wayahimia naona didikuna uvaniahei, kate nau‑hohonana uvihahaiei. Wayahina, apaina Yaubada na‑hapone‑yavunemi novanovana nihenina, e tenoke utou‑navonavovo, iuna viha‑vavaha wayahimia.” ");
INSERT INTO mvn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Vonana iakwa, e Iesu tau nau‑havia ai tau eta‑naonao‑nana vonei, ivona, “Ana pata deina. Emavina yam manua wayahina. Yam viama avaha vinꞌ‑omo, iuna evitumahaneu au pata.” Ka babau‑nana wayahina ya tau paisewa vidoha‑yehai. ");
INSERT INTO mvn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ka Iesu Pita ya manua inui ka Pita nawana dueyei ivi‑kwanaha. Inini nau‑genanava. ");
INSERT INTO mvn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Wayahina, tauna ine, e nimai vo‑dadani, e ai kwanaha am‑niniei, iopu iakwa. Ka vavinena imini, e aniani Iesu ivenei. ");
INSERT INTO mvn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ka avaha babau ionu, tau maꞌ meagai yaiai tupwai iomaomanei, ka nua gawagawamina tomotau‑naia nihenia imamaei, yawai iveimeyei. Ka Iesu ya vonea nua‑naia si‑vi‑ni‑ubauei, ka tau kwanakwanaha habuhabui vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dewana vinꞌ‑omo tau apa‑taputapu Isaia ya iginuma deina, ivona, “Tauna aka viha kadu aka kwanaha vitua‑yavunei.” ");
INSERT INTO mvn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ka munia, Iesu avaha yoko ananina dueyei imavimavinei, e a tau vi‑muni‑waiwai vonei, ivona, “Kaubo‑tamana mani papania navua.” ");
INSERT INTO mvn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka eha ani‑hoina ini‑tawanei, ka veimea a tau viwavenena aitam omo ka vonei, ivona, “Tau Viwavenena, nuanuau avi‑muni‑waiwaiem, ka avi papania ena‑ne, yauke avi‑muni‑waiwaiem.” ");
INSERT INTO mvn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Iesu onotona yana vona nau‑patei vona tana‑minikuna wayahina, ivona, “Kedewa udaudana yai pai dauva vivane guba nihenina, kadu manua yai pai dauva vivane hiu nihenina. Kate yauke, Tauna Vi‑tomotau, eha yau manua, ka eha yau pai dauva. Wayahina, aituhu evi‑muni‑waiwaieu, eha yam pai dauva, yauke deina.” ");
INSERT INTO mvn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka kadu aitam tau vi‑muni omo, ka Iesu viamei, ivona, “Kauvea, yau nuanua avi‑muni‑waiwaiem. Ka aituhu memeanina wayahima, naona eawaeheu amavina amau wayahina. Ka tauna yana tuta na‑iakwa, atavuni, e munia avinꞌ‑omo wayahima, ka auyewana avi‑putu avi‑muni‑waiwaiem.” ");
INSERT INTO mvn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka Iesu ivona, “Avi tuta amam inusi, taui eha itꞌ‑anamaneu ai pata itavuni unuvovoa. Kate wamke avaha eanamaneu. Wayahina, ataina nau‑wawanim evi‑putu evi‑muni‑waiwaieu.” ");
INSERT INTO mvn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ipupu‑naia iakwa, e tauna a tau vi‑muni‑waiwai nui igenu, ivi‑ata waea. ");
INSERT INTO mvn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka tutana iaubo‑tamana mani papania, Iesu wae nihenina dauva ino‑ainei. Ka eha aitam pai iaiaya nui, wedinia ananina vi‑putu hunahuna, ka nupuna iaiwa‑tavutavuni waea, ka tuta eha ananina na‑iakwa wayahina igavivina. Ka a tau vi‑muni‑waiwai imatamatauta. ");
INSERT INTO mvn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wayahina, taui Iesu inau‑vi‑dagui, ka ivona, “Kauvea, eito‑yavuhika! Kagavivina!” ");
INSERT INTO mvn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka tauna vonei, “Aviani wayahina umatamatauta? Yami vitumahana vivane kikituna, a?” E tauna mini, e yahina ka nupuna vonei, ivona, “Ugenuana!” Ka ana habuhabuna mana gomana. ");
INSERT INTO mvn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka avaha a tau vi‑muni‑waiwai dewana idueyei, nuai vi‑tupatupa, ka matataui ivonavona, “Ia! Yahina kadue nupuna movina inononi! Avi onoto tauna?” ");
INSERT INTO mvn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ka avaha iaubo‑tamana, me Gadara yai papani iduduna, e onoto ainua na nua gawagawami ivinꞌ‑omo wayahina. Taui unuvovo gubana nihenia imamaei, ka yai dewa manimanini‑vainena. Wayahina, me Gadara eha ai pata etawanana wayahina ivenavenau. ");
INSERT INTO mvn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ka onoto‑naia Iesu idueyei ka ivi‑hone, “Ia! Wamke Yaubada Natuna. Aviani wayahina eomoi baina wayahiaia? Kaiwadi, yam nuanua edewa‑yaiyaieai ataina, a? Vona ahiahina, auyewana vivane apaina.” ");
INSERT INTO mvn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ka nepeia pono habuhabui iduaduana, ka tau dune‑vi‑avina tupwai idune‑vivini. ");
INSERT INTO mvn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wayahina, nua‑naia gawagawami Iesu wayahina iviama, ivona, “Aituhu esi‑vinꞌ‑omaneai, memeanina pono tanoi nihenia eva‑tawaneai?” ");
INSERT INTO mvn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Akaka tauna awaehei, e vonei, “Una‑nei!” Wayahina, nua‑naia onoto‑naia ainua ini‑tawanei ine ponoia wayahia, ka inui. Ka vo‑kwayavonina, ponoia habuhabui inau‑bwanunua kemana ananina wayahina ipeu navua, igavivina. ");
INSERT INTO mvn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wayahina, ponoia ai tau dune‑vi‑avinai yai matauta nui, inovo ine yai megeia, ka aviani tau vi‑nau‑wana wayahia vinꞌ‑omo idueyei, akanai dewaia habuhabui tau vi‑meagai‑naia imataedai. ");
INSERT INTO mvn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ka avaha inononi, tau vi‑meagai‑naia yai nuanua Iesu yai papani na‑ni‑tawanei. Wayahina, habuhabui ivinꞌ‑omo Iesu wayahina, ka avaha ivaniahei, iviama wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wayahina Iesu igenu, ka waea ivi‑ata, ione‑tamane tauna ya megeia Kapenaum. ");
INSERT INTO mvn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka onoto tupwai iomo wayahina, e taui tau penapena aitam ya pai dauva hetana iavanei, iomanei Iesu wayahina. Ka Iesu avaha onoto‑naia yai vitumahana anamanei, tau penapenana vonei, ivona, “Au niau, enꞌ‑ate‑vatu ka edewa‑haiawa. Iuna yam dewa goyona avaha anua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ka veimea a tau viwavenena tupwai Iesu ya vonana inononi, ka imaga‑bawei, ka matataui ivonavona, “Onoto taina vivane Yaubada ana wava vainaui! Iuna vona ahiahina, baina tanopia Yaubada ana heta‑ohota ana pata dewa goyona na‑nua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ka Iesu yai nuanua avaha anamanei, wayahina vonei, ivona, “Aviani wayahina nuami nihenina unua‑goyo wayahiua? Yami nuanuana eha tunuhina. ");
INSERT INTO mvn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Unuanua tutana avona, ‘Yam dewa goyona avaha anua‑piahi’ vonana vivane vonata. Iuna eha aitam aviani uta‑dueye, a? ");
INSERT INTO mvn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wayahina, au veimea tanopia aviwavenemi, unꞌ‑anamanei vivane yauke, Tauna Vi‑tomotau, au pata tomotau yai dewa goyona anua‑piahi‑neiei.” Akaka tauna tau penapenana vonei, ivona, “Emini, e yam pai dauva eavanei, e emavina yam megeia.” ");
INSERT INTO mvn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka tau penapenana mini, e mavina ya megeia. ");
INSERT INTO mvn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ka yoko‑nana avaha paisewana idueyei, nuai vi‑tupatupa ananina, ka ivona, “Yaubada, kaiwa ananina! Yam veimea avaha tomotau wayahia eawaehei.” ");
INSERT INTO mvn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka Iesu papani‑nana ni‑tawanei, ka neine, e aitam onoto dueyei ana wava Mateu takesiV a manua nihenina manuena, paipaisewa, ka vonei, ivona, “Evi‑muni‑waiwaieu.” Wayahina, Mateu mini, e Iesu vi‑muni‑waiwaiei. ");
INSERT INTO mvn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka aitam tuta munia, Mateu aniani vo‑vi‑aiaia ya manua wayahina, e didikuna vi‑tunei omo Iesu kadu a tau vi‑muni‑waiwai nui wayahia, e taui iomoi. Ka Mateu kadu didikuna vi‑tunei iomo yaiana tupwai wayahia, ka taui vivane takesiV a tau vitue, ka kadu mani tomotau Parisi inuanua vivane tau goyogoyona. Ka taui iomoi, e habuhabui nui imanuena ka iamam. ");
INSERT INTO mvn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Akaka tupwai Parisi, avaha dewana idueyei, iomo Iesu a tau vi‑muni‑waiwai wayahia, e ivi‑tanaiei, ivona, “Yami tau viwavenena takesiV a tau vitue, kadue tau goyogoyona tupwai nui iamam nau‑tamoata, a? Ka ya dewana viwaveneai vivane tauna aitam tau goyogoyona, taui deina.” ");
INSERT INTO mvn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kate Iesu yai vonana nononi, wayahina tauna vona‑nau‑patei vona tana‑minikuna wayahina, ivona, “Aituhu aviyaivia yawai ahiahina, taui eha nau‑wawani dokitaV ihone na‑omo na‑ivaite, kate tau kwanakwanaha nau‑wawani idedewei deina, ika? ");
INSERT INTO mvn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kate nau‑wawanimi Yaubada yana vona Iginuma nihenina unua‑haui, ivona, ‘Yauke yau nuanua udune‑nuanuaiemi, ka eha yau nuanua uvi‑nomu wayahiua.’ Eha yau paisewa tau tunutunuhina avi‑hone ana‑ivaite, kate yau paisewa vivane tau goyogoyona avi‑honei ana‑ivaitei.” ");
INSERT INTO mvn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka munia, Ioni Tau Bapitaiso a tau vi‑muni‑waiwai iomo, e Iesu ivi‑tanaiei, ivona, “Itoai yama yoko kadu Parisi yai yoko am wayahina adewa‑didiguna yama tapanono wayahi. Kate medeina wamke am tau vi‑muni‑waiwai eha idewa‑didiguna?” ");
INSERT INTO mvn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka Iesu vona‑nau‑patei vona tana‑minikuna wayahina, ivona, “Eha memeanina tau tavine yaiana ivi‑mohai tauna matana. Iuna taui nau‑wawani nui idewa‑haiawa. Kate tuta tepakaia tau tavinena nau‑wawani ni‑tawanei. Ka auyewana wayahina yaiana idewa‑didiguna akanai.” ");
INSERT INTO mvn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ka kadu aitam vona tana‑minikuna wayahia vo‑vi‑mahetei, ivona, “Aituhu aitam kwama am‑yehia tupwana, eha nau‑wawanika kaleko vovouna kanꞌ‑epe, e kwama tutuaina kabwadi wayahina. Apaina kwamana nꞌ‑am‑yehia ananina. Iuna vovouna bagibagina, ka tutuaina ihanuana. ");
INSERT INTO mvn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ka aituhu wainaV vovouna kanau‑vevewanei, eha nau‑wawanika kana‑iwaha pai iwaha tutuaina nihenina. Iuna wainanaV punopunono bagibagina, ka pai iwaha tutuaina ihanuana. Apaina pai iwaha wagana nꞌ‑am‑yehia, kadue wainanaV na‑iwaha na‑opu na‑iakwa. Kate nau‑wawanika wainaV vovouna kana‑iwahi pai iwaha vovouna nihenina, e ainua ahiahina deinake.” Iesu ya vonana wayahina viwavenei eha ana pata ya viwavenena vovouna viwavenena tutuaina nui inau‑tamoia. ");
INSERT INTO mvn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka Iesu vonana vonavona, ka aitam tau veimea omo, e Iesu matana aena vi‑tupa‑gum, e ivona, “Kauvea, ataina natu vavinena aniga, kate nuanuau enꞌ‑omo, e ininina evo‑dadani na‑mini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ka Iesu mini, e tau veimeana nui ivi‑putu ineine, ka kadu Iesu a tau vi‑muni‑waiwai nui ineine. ");
INSERT INTO mvn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","E ineine ka aitam vavine, dayahi ponimana ai yau 12 nihenia taitaina, munia iomomo, e vavinena Iesu ana kwama ivo‑dadani. ");
INSERT INTO mvn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vavinena idewei deina iuna nuai nihenina ivonavona, “Aituhu Iesu ana kwama upuna avo‑dadani, akanai, avidoha.” ");
INSERT INTO mvn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ka Iesu magigino, e vavinena dueyei ka ivona, “Kaiwa ananina, Natu, kadu unꞌ‑ate‑vatu. Yami vitumahana wayahina avaha uvidoha.” Ka vavine‑nana avaha ividoha‑yehai. ");
INSERT INTO mvn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dewana iakwa, e Iesu tau veimeana ya manua vaniahei, e tau vi‑mohai ivi‑mohai dueyei, ka tumo a tau vaina tumo ivaivaina, e movi nata‑vaine. ");
INSERT INTO mvn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ka Iesu vonei, ivona, “Ugenuana, una‑opu. Iuna tevana taina eha tꞌ‑aniga, kate ino‑ainei.” Ka tomotaui ivinepei. ");
INSERT INTO mvn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ka avaha yokoia ini‑ubau iakwa, e Iesu inui, e tevanina nimana vo‑epei, e tevanina na yawaina mini. ");
INSERT INTO mvn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ka munia, tau vi‑meagai habuhabui papani‑nana nihenina vaneana inononi. ");
INSERT INTO mvn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka Iesu papani tanoi ni‑tawanei, e neine, ka tau mata‑goyo ainua ivi‑muniei, e ivi‑honehone movi ananina wayahina, ivonavona, “Davida wana, edune‑nuanuaieai.” ");
INSERT INTO mvn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka Iesu aitam manua inui, e tau mata‑goyoi iomo wayahina, e Iesu vi‑tanaiei, ivona, “Itomi medeina? Uvitumahaneu vivane au pata matami avo‑vi‑aiaia, a?” Ka, taui ivona, “Kauvea, ika, am pata.” ");
INSERT INTO mvn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Akaka matai vo‑dadani, e vonei, ivona, “Akanai, ataina yami vidoha vinꞌ‑omo yami vitumahana aitamoata deinake.” ");
INSERT INTO mvn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E ivi‑putu idunedune. Kate Iesu ai veimea toyoina venei, ivona, “Eha aitam koiaka umataede.” ");
INSERT INTO mvn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kate taui ine, ka Iesu ya veimea toyoina ibwegei, ka tauna vaneana iaipupuei papani habuhabuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ka tutana Iesu a tau vi‑muni‑waiwai nui manuana ini‑tawanei, tupwai tomotau aitam onoto iomanei Iesu wayahina. Ka nua gawagawamina onotona veimeyei, ka eha ana pata na‑ipupu. ");
INSERT INTO mvn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka avaha Iesu nua gawagawamina one‑yavunei, e onotona vidoha, e vi‑putu ipuipupu. Ka yokoia nuai vi‑tupatupa ananina, ka idewa‑haiawa, ivona, “Nonova a itoava ataina wayahina, eha aitam koiaka ya paisewana deina kata‑dueye papani Isiraeli nihenina.” ");
INSERT INTO mvn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kate Parisi yoko ivona, “Tauna nua gawagawami one‑yavunei nua gawagawami yai kauvea ya bagibagi wayahina, eha Yaubada ya bagibagi wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ka Iesu meagai anani kadue mwatutukui wayahia tutu‑vivina, ka yai manua tapanono nihenia viwavenena, ka Vaneana Ahiahina Yaubada ya pai veimea wayahina naunau‑waheyei, ka kadu kwanaha aitamoata aitamoata wayahia tomotau vo‑vi‑aiai‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ka avi tuta tauna yoko dudueyei, e ate‑nuanuaiei. Iuna taui ai vita habuhabui, ka eha aitam koiaka ta‑ivaite. Taui vivane sipiV nini‑vi‑pani deina, iuna eha ai tau dune‑vi‑avina. ");
INSERT INTO mvn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Tomotau taina aihana ananina, kate tau aihana eha yoko. ");
INSERT INTO mvn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wayahina, Tau Vi‑baguna uviamei tauna tau aihana tupwai na‑va‑tawanei ina‑nu ya baguna nihenina, inꞌ‑aikayo.” ");
INSERT INTO mvn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu tauna a tau vi‑muni‑waiwai ai yau 12 honei, iomo wayahina, e bagibagi venei taui ai pata nua gawagawami tomotau nihenia ione‑yavunei, kadu kwanaha, ka muya aitamoata aitamoata tomotau wayahia ivo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ka a tau hae anani ai yau 12 ai wava taina. Naona Simoni, (Iesu vi‑wahani Pita), ka vaneina Aniduru, kadue Iamesa ka vaneina Ioni, taui amai Sebedi. ");
INSERT INTO mvn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ka Pilipi ka Baritolomeu, kadue Tomasi ka Mateu, tauna takesiV a tau vitue. Kadu aitam Iamesa Alipaeusi natuna, ka Tadaeusi. ");
INSERT INTO mvn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ka kadu aitam Simoni, tauna aitam Kananai yai tomotau (taui manimanini ka me Rom yai veimea ivihahaiei), ka Iudasa me Kariota, tauna apaina Iesu na‑vauyei. ");
INSERT INTO mvn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ka Iesu taui ai yau 12‑naia vi‑tunei. Ka naona tauna ai veimea venei, ya viwavenena mamanaina wayahina. Viwavenena vi‑putu deina, ivona, “Eha uneine taui eha me Iudea wayahia, kadu eha Samaria meagaina nihenia unuinu. ");
INSERT INTO mvn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kate uneine yaka yoko me Isiraeli wayahia. Taui sipiV ini‑tupatupa deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E tomotau‑naia unaunau‑wahei deina, ‘Yaubada ya pai veimea vi‑maupwani.’ ");
INSERT INTO mvn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tau kwanakwanaha uvo‑vi‑aiaiei, kadue tau mate usi‑vi‑mini‑havine yawayawaina, kadue tau lepero uvo‑vi‑aiaiei, kadue nua gawagawami tomotau nihenia unꞌ‑one‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka yami tutu‑vivina wayahina eha kina, o toea ami kode nihenina utotohi kabwaga wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Eha kadue kubukubu unꞌ‑epe, ka eha kadue ami kwama ainua, ka eha kadue ami ae‑yapayapa ainua, ka eha yami guna ainua unꞌ‑epe. Iuna aviani tau paisewa nau‑wawani yai paisewa wayahina, dewaia habuhabui ivaniahei tomotaui ina‑ivaitei wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ka avi meagai unuinui, aituhu anani o mwatutukui, naona koiaka yana dewa tunutunuhina unene wayahina, e tauna nui ya manua nihenina umamaei a itoava meagai‑nana uni‑tawanei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka avi tuta ya manua unui, naona unau‑kaiwa wayahina, ka unau‑iaiavei. ");
INSERT INTO mvn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aituhu taui manuana nihenina imamaei yai dewa udueyei vivane tunuhina, akanai uawaehei yami nau‑iaiava mamaei akanai. Kate aituhu yai dewa udueyei vivane goyona, akanai yami nau‑iaiava unꞌ‑epa‑havine wayahimia. ");
INSERT INTO mvn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka aituhu aviyaivia eha itainimi yai manua, o aituhu aviyaivia eha yai nuanua yami mataeda inononi, manua‑nana o meagai‑nana uni‑tawanei, kadue aemia genahihi ututu‑putu‑yavunei yai papania. Dewana pai dune tau vi‑meagai‑naia wayahia, vivane munia taui dewa‑yaiyai ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Memeanina nuami vi‑tupatupa, kate taina deina avonemi. Apaina vitana matana anꞌ auyewa wayahina, tau vi‑meagai Sodom ka tau vi‑meagai Gomora ai dewa‑yaiyai tupwana ivaniahei, kate aituhu aviyaivia habuhabui ivihahaiemi, taui ai dewa‑yaiyai ananina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ataina avi‑tunemi uneine tomotau wayahia. Itomi sipiV deina, kate taui kedewa manimanini deina. Wayahina, nau‑wawanimi yami nua‑uya vivane wayo ya nua‑uya deina, ka udune‑vivinimi ahiahina, kadue nau‑wawanimi yami dewa vivane bunebune yai dewa deina, ka eha mani tomotau uvo‑vi‑nua‑goyo. ");
INSERT INTO mvn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Udune‑vivinimi ahiahina! Iuna apaina tomotau tupwai manimanini ipoyꞌ‑avinimi, e ineiemi me Isiraeli aka tau veimea wayahia, e ipiahimi. Ka yai manua tapanono nihenia imoamoanimi, iuna inuanua itomi yai vitumahana uvi‑goyoi. ");
INSERT INTO mvn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ka taua wayahiu ineiemi ai tau veimea anani mataia, kadue yai kiniV mataia, e ivitavitami. Ka tau veimea‑naia wayahia uhaehae taua wayahiu, kadu uhaehae taui eha me Isiraeli wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ka avi tuta avaha ipoyꞌ‑avinimi, e mataia umimini, eha umatamatauta, kadue eha unuanua vitana medeina una‑vona. Iuna apaina, tuta‑naia wayahia, Yaubada yami vona na‑venemi. ");
INSERT INTO mvn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wayahina auyewaia, yami vona eha na‑omo itomi ami heta wayahimia, kate yami vona na‑omo Yaubada Amami Nuana Ahihinata wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tuta omomo wayahina, tomotau ai havia vivane taui yai yoko nihenina. Ka tupwai vavanei ivauyei mani tomotau wayahia, e inau‑vi‑anigi. Ka tomotau tupwai natunatui ivauyei mani tomotau wayahia, e inau‑vi‑anigi deina, kadue yaheyahe tupwai ayo‑amai ivauyei mani tomotau wayahia, e inau‑vi‑anigi deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ka kadu tomotau yoko habuhabui inau‑haviemi. Iuna taumi au tau vitumahana. Kate aituhu aviyaivia itoha‑vi‑anai, e imimini toyoina, apaina tuta a pai nau‑yehata wayahina taui ana‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wayahina, avi tuta ivunuvunumi aitam papani wayahina, nau‑wawanimi una‑novo mani megeia. Memeanina nuami vi‑tupatupa, kate avonemi, apaina meagai habuhabuna papani Isiraeli nihenina unaunau‑wahei, kate yami paisewana eha unau‑yehai. Iuna yauke, Tauna Vi‑tomotau, amavina yami paisewana niwanina. ");
INSERT INTO mvn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Vona tana‑minikuna ivona, ");
INSERT INTO mvn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Avaha uanamanei, tomotau yai dewa wayahiua vivane manimaninina. Wayahina, eha nau‑wawanimi unuanua apaina tomotau yai dewa wayahimia bigana. Akanai, ahiahina wayahimi aituhu apaina itomi au tau vi‑muni‑waiwai dewa aitamoata uvaniahei, yauke deina. Tomotau avaha ivi‑wahaniu Beelesebubi, ka wava‑nana kadu aitam wava Satana wayahina. Wayahina, apaina inꞌ‑apa‑goyogoyo‑vainemi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wayahina, eha nau‑wawanimi umatamatauta taui yai dewa‑naia wayahi. Apaina Yaubada dewa‑hivahiva aitamoata aitamoata na‑si‑vinꞌ‑omanei kadueyei, kanꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Akaka aviani novanovana nihenina ahaeyei wayahimia, apaina nua‑uyana auyewa nihenina uhaeyei tomotau yoko wayahia. Kadu aviani avi‑awa‑yayaei wayahimia, apaina unau‑waheyei vuvunaha. ");
INSERT INTO mvn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka eha taui ininimi inau‑vi‑anigi umatamataute. Iuna apaina taui eha ai pata nuami inau‑vi‑anigi. Kate avonemi, nau‑wawanimi Yaubada umatamatautei. Iuna tauna ininimi nuami ainua veimeyei. E tauna ana pata ainua na‑vita‑vovoni meagai ai ananata nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pai dune taina avenemi unononi. Manua yaveyaveha kikituna ainua kaimwaneyei ai nau‑pata toea aitamoata, ka Yaubada manua aitamoata aitamoata dune‑vi‑avini. E aituhu aitam wayahia na‑peu nꞌ‑aniga, Amami wahuma avaha anamanei, kadu tauna nuani deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ka tauna avaha dewa aitamoata aitamoata anamane‑yehai. Ika, tauna avaha apanami ai yau anamane‑yehai. ");
INSERT INTO mvn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wayahina, eha umatamatauta. Iuna Yaubada aitamoata aitamoata wayahimia dune‑nuanuaiemi ani‑vainena, eha manua yaveyaveha kikituna habuhabui deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ka aituhu aviyaivia ihaehaeyeu tomotau mataia, apaina wahuma yauke kadu taui ahaeyei Amau matana. ");
INSERT INTO mvn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kate aituhu aviyaivia itana‑tavuniu tomotau mataia, apaina yauke kadu wahuma Amau matana atana‑tavuni deina. ");
INSERT INTO mvn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Eha unuanua aomo tanopia, iuna nua gomagomanina avenemi uvaniahei. Eha‑ohota. Yau pai mini ananina inama aomanei tanopia. Wayahina, havia vinꞌ‑omo. Iuna yau viwavenena tomotau tana‑vewani akanai. Tomotau ivitumahaneu o ivihahaieu. ");
INSERT INTO mvn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vona ahiahina, yau omana wayahina vivane, ‘Onoto amana ainua inau‑haviei, Ka vavine ayona ainua ivi‑nauei, Ka vavine nawana ainua ivi‑nauei. ");
INSERT INTO mvn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ka onoto a havia vivane yana yoko.’ ");
INSERT INTO mvn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ka aituhu koiaka ya dune‑nuanuai amana o ayona wayahi ananina, ka aituhu ya dune‑nuanuai wayahiu kikituna, eha nau‑wawaniu anꞌ‑awaehe tauna vivane au tau vi‑muni‑waiwai aitam. Kadu deinake, aituhu koiaka ya dune‑nuanuai natunatuna wayahi ananina, kate aituhu ya dune‑nuanuai wayahiu kikituna, eha nau‑wawaniu anꞌ‑awaehe tauna vivane au tau vi‑muni‑waiwai aitam. ");
INSERT INTO mvn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ka aituhu koiaka eha yawaina nꞌ‑awaeheu vivane nꞌ‑aniga wayahiu, taui ai nahenahea ianiga deina, eha nau‑wawaniu anꞌ‑awaehe tauna vivane au tau vi‑muni‑waiwai aitam. ");
INSERT INTO mvn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ka vona ahiahina taina. Aituhu aviyaivia yawai taina ipoyꞌ‑avini, inua‑tania, apaina yawai‑vavaha itutu‑haini. Kate aituhu aviyaivia yawai taina ivo‑haini wayahiu, apaina yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aituhu aviyaivia itainimi yai manua ka ivaniahami, akanai taui ivaniahau deinake. Kadue aituhu aviyaivia ivaniahau, akanai taui kadu au tau vi‑tune ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ka aituhu aviyaivia tau apa‑taputapu itaini, ivaniahei, akanai taui tau apa‑taputapu a nau‑pata ivaniahei. Ka aituhu aviyaivia onoto tunutunuhina itaini, ivaniahei iuna tauna onoto tunutunuhina, akanai taui onoto tunutunuhina a nau‑pata ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kadu aituhu aviyaivia dewa ahiahina idewei wayahimi iuna itomi au tau vi‑muni‑waiwai, apaina taui ai nau‑pata ahiahina dewana wayahina ivaniahei. Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Aituhu dewana kikituna, vei na daudauna kwekwekwena aitam wayahimia am wava kikituna ivenem, ina‑ivaitem deina, akanai dewana kikituna a nau‑pata ahiahina potapotai ivaniahei.” Iesu ya viwavene‑nana mamanaina iakwa, e a tau vi‑muni‑waiwai vi‑tunei ine, e yai paisewa ivi‑putu. ");
INSERT INTO mvn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ka avaha Iesu tauna a tau vi‑muni‑waiwai ai yau 12 ai veimeana nau‑yehai, e papani tanoi ni‑tawanei, omo papani Galili a meagai wayahia, e inuinu, e tau vi‑meagai‑naia viwavenena ka naunau‑wahei. ");
INSERT INTO mvn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ka Ioni Tau Bapitaiso manua yohona nihenina mamaei. Ka Ioni avaha Tau Ito‑yavuha vaneana nononi, e tauna a tau vi‑muni‑waiwai vi‑tunei iomo Iesu wayahina, ");
INSERT INTO mvn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","e ivi‑tanaiei, ivona, “Yama tau viwavenena ya vi‑tanai taina, ‘Wamke vivane Tau Ito‑yavuha‑nana, nonova a itoava ataina wayahina apotapotam, o kaiwadi, mani onoto Tau Ito‑yavuha‑nana, e nau‑wawaniai tauna apotepotei?’” ");
INSERT INTO mvn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Iesu yai vonana vona‑nau‑patei, ivona, “Una‑nei, e dewa‑naia avaha unononi kadu dewa‑naia avaha udueyei unau‑viviwavei Ioni wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yau dewaia vivane tau mata‑goyogoyo iduedue, ka tau penapena ini‑awana, kadu tau lepero ividoha, ka taui tanihai am‑potapotana inononona, kadu tau mate imimini, ka taui eha kaikaiwabo Vaneana Ahiahina inonononi. Dewaia iviwavenemi taua koiaka. ");
INSERT INTO mvn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ka aituhu aviyaivia yau viwavenena inononi, ka aituhu eha yai vitumahana ivo‑haini, taui avaha nau‑iaiava ivaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ka Ioni Tau Bapitaiso a tau vi‑muni‑waiwai ineine, e Iesu yokoia habuhabui vo‑vi‑mahetei Ioni wayahina, ivona, “Tutana unei anata, e Ioni ya nau‑wahe unononi, tauna avi onoto? Kaiwadi, tauna vivane ihanuana, vekuvekuna na yahinina nau‑yueyue? Eha. ");
INSERT INTO mvn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka tutana unei anata, e Ioni udueyei, avi onoto udueyei? Kaiwadi, tauna vivane kaikaiwabo aitam, onoto na kwama bigana vovouna? Eha. Iuna taui ai kwama bigana kadu vovouna iweteweteni vivane kiniV, kadu taui kiniV yai manua nihenia imamaei. ");
INSERT INTO mvn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka Ioni medeina? Tauna avi onoto? Tauna aitam tau apa‑taputapu, a? Vona ahiahina avonemi, tauna tau apa‑taputapu aitamoata aitamoata vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iuna nonova iginuma tauna wayahina deina, ‘Apaina yau tau mataeda avi‑tunei, na‑eta‑naoem. Ka naona tauna yam etawana na‑hadani, e yam paisewa vo‑vi‑meani.’ ");
INSERT INTO mvn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Memeanina nuami vi‑tupatupa, kate avonemi, nonova a itoava Ioni Tau Bapitaiso ya tupua wayahina, eha kadu aitam onoto tauna deina. Tauna habuhabui vane‑tawanei. Kate vona ahiahina taina, aituhu aviyaivia inuinu Yaubada ya pai veimea nihenina, taui Ioni inata‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Tau apa‑taputapu yai iginuma Iginuma nihenina, kadu Yaubada ya veimea Iginuma nihenina, ainua iapa‑taputapu tomotau wayahia a itoava Ioni ana tuta wayahina, e Ioni Tau Bapitaiso ya paisewa vi‑putui. Kate auyewana wayahina a itoava tuta ataina wayahina, Yaubada ya pai veimea na bagibagina omomoi, tau nau‑havia bagibagina deina. Ka aituhu aviyaivia ibagibagi, akanai taui ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka aituhu yami nuanua uvitumahaneu, avonemi Ioni‑nana aitam mataina Iginuma nihenina nau‑yehai, vivane ivona, ‘Apaina Elidia na‑omo.’ ");
INSERT INTO mvn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui. ");
INSERT INTO mvn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tomotau ataina imamaei yai dewa medeina? Ka aviani wayahina abou‑viwavei? Aitam pai dune avenemi taina. Taui yai dewa yaheyahe imanuena maketia deina, e ivivi‑hone mani tomotau wayahia, ivonavona, ");
INSERT INTO mvn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Itoai inava ainaua, ");
INSERT INTO mvn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pai dune‑nana avenemi iuna tutana Ioni omo, tauna yana dewa deina. Eha na dewa‑haiawana tꞌ‑amam, ka eha na dewa‑haiawana ta‑nimnim, ka tomotau ivonavona, ‘Tauna yana dewa deina iuna nua gawagawamina yawaina veimeyei.’ ");
INSERT INTO mvn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kate tutana yauke, Tauna Vi‑tomotau, aomo, yauke yau dewa tunina. Yauke na dewa‑haiawiu amam kadu na dewa‑haiawiu animnim, kate tomotaui ivonavona, ‘Udueyei, tau am aitam kadu wainaV a tau nim. Tauna eha onoto ahiahina iuna yaiana vivane takesiV a tau vitue kadu tau goyogoyona!’ Taui ivonavona deina, kate avonemi, ");
INSERT INTO mvn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vonana iakwa, e Iesu vi‑putu tomotau tupwai apa‑goyogoyoei. Tau vi‑meagai‑naia imamaei aveta tauna avaha ya dewa‑bagibagi habuhabui dedewei, kate taui eha ita‑vitumahane, kadu eha ita‑nua‑vinana. Wayahina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aioi, meagai Korasini! Goyona wayahimia! Aioi, meagai Betesaida! Goyona wayahimia! Iuna dewa‑bagibagi habuhabui avaha adedewei wayahimi, kate eha uta‑nua‑vinana yami dewa goyona wayahia. Aituhu nonova dewa‑bagibagi‑naia ata‑dewe meagai Taia nihenina, o kadi meagai Sidoni nihenina, avaha anamanei nonova tau vi‑meagai‑naia ita‑nua‑vinana, kwama moimoiana kadu hanavua, e yai nua‑vita ananina iviwavenei deina. ");
INSERT INTO mvn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ka avonemi, vitana matana anꞌ auyewa na‑omo, ka auyewana wayahina, tau vi‑meagai Taia kadu tau vi‑meagai Sidoni ai dewa‑yaiyai ivaniahei, kate itomi ami dewa‑yaiyai ananina uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka aioi, meagai Kapenaum! Goyona wayahimia! Itomi unuanua apaina wahuma wayahina una‑vane, a? Kate avonemi eha. Apaina una‑opu ai ananata a papani HadesiV nihenina. Iuna dewa‑bagibagi habuhabui avaha adedewei wayahimi, kate eha uta‑nua‑vinana yami dewa goyona wayahia. Aituhu nonova dewa‑bagibagi‑naia ata‑dewe meagai Sodom nihenina, avaha anamanei nonova tau vi‑meagai‑naia ita‑nua‑vinana, ka ataina yai meagai ta‑mimini. ");
INSERT INTO mvn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka avonemi, vitana matana anꞌ auyewa wayahina, tau vi‑meagai Sodom ai dewa‑yaiyai ivaniahei, kate itomi ami dewa‑yaiyai ananina uvaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vonana iakwa, e Iesu viama, ivona, “Amau, wamke wahuma ka tanopi ai Kauvea, awa‑davem, iuna dewaia tau nua‑uya kadu tau anamana wayahia ehivehivei. Kate taui eha yai nua‑uya, meameai deina, taui wayahia esi‑vinꞌ‑omanei. ");
INSERT INTO mvn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ika, Amau, yam dewana deina, iuna dewana vo‑vi‑dewa‑haiawim.” ");
INSERT INTO mvn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka Iesu ivona, “Amau avaha dewa habuhabuna awaeheu aveimeyei. Ka eha kadu aitam koiaka tꞌ‑anamaneu, Amau ana heta akanai. Ka eha kadu aitam koiaka Amau tꞌ‑anamane, kate Natuna au heta akanai. Ka aituhu aviyaivia yau nuanua, akanai Amau asi‑vinꞌ‑omanei inꞌ‑anamanei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Wayahina, aituhu aviyaivia habuhabumi uaihanua, o aituhu ami vita ananina, akanai wayahiua unꞌ‑omo, e avo‑vi‑aiaiemi, uvidoha, uvi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Itomi nau‑wawanimi unꞌ‑awaeheu aveimeyemi, kadu nua‑uya wayahiua unꞌ‑epei. Iuna yauke yau dewa vivane bigana kadu nuau nihenina anua‑opu. Wayahina, aituhu uvinꞌ‑omo wayahiua, vona ahiahina, nua gomagomanina uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iuna aviani aveimeyemi eha vitana, kadu avi pai avana avenemi aina memeanina.” ");
INSERT INTO mvn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ka munia, auyewa tapanono wayahina, Iesu tauna a tau vi‑muni‑waiwai nui baguna nihenina ineine, ka a tau vi‑muni‑waiwai am inavovo. Wayahina, witiV uana iaiponuponu ka iamam. ");
INSERT INTO mvn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ka tupwai Parisi avaha idueyei, e Iesu wayahina ivona, “Edueyei! Am tau vi‑muni‑waiwai aka veimea tapanono wayahina ibwegebwegei yai dewa taina wayahina. Eveimeyei igenuana!” ");
INSERT INTO mvn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka Iesu ivona, “Nonova Davida yana dewa deinake, tutana yaiana nui am inavovo. Viviwava‑nana Iginuma nihenina. Avaha uaiavi, ika? ");
INSERT INTO mvn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tauna Yaubada ya manua inui, e palaua vito‑potana, pai due ana heta, iam. Ka aitam veimea mamaei, e palauana mani tomotau wayahi vito‑potei, tau vi‑nomu ai heta akanai. Kate tau vi‑nomuana awaehei iania. Dewana unuani o eha? ");
INSERT INTO mvn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ka kadu aitam pai dune taina. Auyewa tapanono aitamoata aitamoata wayahina tau vi‑nomu ipaipaisewa Manua Vito‑pota nihenina. Wayahina, veimea auyewa tapanono wayahina ibwegebwegei deina, kate Yaubada matana yai dewa eha goyona. Unua‑haui o eha? ");
INSERT INTO mvn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka yauke avonemi, Manua Vito‑pota vivane dewa ananina, kate ataina aitam mamaei, ka tauna Manua Vito‑pota vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kate itomi eha vona taina Yaubada wayahina anꞌ anamana utꞌ‑anamane vidoha, ‘Yauke yau nuanua unꞌ‑ate‑nuanuaiemi, ka eha yau nuanua uvi‑nomu wayahiua.’ Aituhu vonana wayahina uta‑nua‑hau, eha nau‑wawanimi tomotau tunutunuhi taina uapa‑goyogoyoe. ");
INSERT INTO mvn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iuna yauke, Tauna Vi‑tomotau, kadu auyewa tapanono aveimeyei. Ka taua avaha yai dewa taina awaehei.” ");
INSERT INTO mvn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ka Iesu papani tanoi ni‑tawanei ka yai manua tapanono inui. ");
INSERT INTO mvn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ka aitam onoto nihenina mamaei na nima‑begabegana. Ka tupwai tomotau yai nuanua aitam goyona ivaniahei Iesu yana dewa nihenina, e munia taui ai pata ivitevitei dewana wayahina. Akaka tomotaui Iesu ivi‑tanaiei, ivona, “Aituhu tau kwanakwanaha kavo‑vi‑aiaiei auyewa tapanono wayahina, dewana dewa ahiahina o dewa goyona?” ");
INSERT INTO mvn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka Iesu yai vi‑tanai nau‑patei pai dune wayahina, ivona, “Aituhu aitam sipiV ipeu iopu guba auyewa tapanono wayahina, akanai, aitamoata aitamoata wayahimia, aituhu yam sipiV, nau‑wawanim epoyꞌ‑avini, etaini, ka evane‑meiei. Ka dewa ahiahina edewei sipi‑nanaV wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka Yaubada ya nuanua sipiV kaivaitei, ka ya nuanua ananina tomotau kaivaitei. Wayahina, nau‑wawanika dewa ahiahina kadedewei tomotau wayahi auyewa tapanono wayahia. Ka avi tuta dewaia ahiahina kadedewei, eha aka veimea kata‑bwegebwege.” ");
INSERT INTO mvn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Akaka Iesu onotona vonei, ivona, “Nimam etunei.” E tunei, akanai ka vidoha habuhabuna, papanina ahiahina deinake. ");
INSERT INTO mvn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ka Parisi ini‑ubau, e ivi‑putu ivi‑nua‑hauhau medeina Iesu inau‑vi‑anigi. Iuna taui ivitumahanei vivane Iesu avaha ai veimea bwegebwegei ya dewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka Iesu avaha yai nuanuana anamanei, wayahina manua tapanono‑nana ni‑tawanei ka ine. Ka yoko habuhabui ivi‑muniei, ka tauna habuhabui wayahia ivi‑kwanaha vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka vona panina wayahina vonavona wayahia deina, ivona, “Eha mani tomotau wayahia uhaeyeu taua koiaka.” ");
INSERT INTO mvn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ka yana dewa taina vinꞌ‑omo tau apa‑taputapu Isaia ya iginuma deina. Iginumana nihenina Yaubada ivona, ");
INSERT INTO mvn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yau tau paisewa udueyei, Tauna avi‑nua‑dadanei. Ka adune‑nuanuaiei, kadu nuau nihenina adewa‑haiawa tauna wayahina. Nuau Ahihinata avenei mamaei, e tauna ya paisewa vo‑vi‑meani. Ka tau vi‑meagai papani aitamoata aitamoata nihenina tauna wayahina yau vi‑nua‑dadana kadu yau dewa tunutunuhina inononi. ");
INSERT INTO mvn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka tauna eha vito‑patapata, kadu eha vi‑honehone movina ananina wayahina. Kadu eha aitam koiaka tauna movina ananina inononi etawana tutana tauna vi‑heyoheyo, iuna yana dewa eha deinake. ");
INSERT INTO mvn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ka tauna eha taui yai vitumahana ihanuana nꞌ‑apa‑goyogoyoe. Iuna ya nuanua yai vitumahana na‑nata. Ka tauna eha odama davunina na‑hapone deina, ka ya nuanua taui eha yai ate‑vatu dune‑nuanuaiei, kadu na‑ivaitei. Ka dewa tunutunuhina vivane dewa goyona vane‑tawanei tauna ya paisewa wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ka tau maꞌ tanopi habuhabui ivitumahanei tauna na‑ito‑yavuhi‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka munia tupwai tomotau aitam onoto Iesu wayahina iomanei. Ka onotona matana goyona, kadu tauna eha ana pata na‑ipupu, iuna aitam nua gawagawamina onotona veimeyei deina. Ka Iesu vo‑vi‑aiaiei ka onoto‑nana vidoha. Iakwa, e ana pata ipuipupu kadu matana duedue. ");
INSERT INTO mvn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ka yoko habuhabui nuai venau‑tupatupa dewa‑bagibagina wayahina, ka ivonavona, “Kaiwadi, onoto taina Davida Natuna, vivane yaka Tau Ito‑yavuha‑nana, o eha?” ");
INSERT INTO mvn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ka Parisi avaha yoko‑naia yai vonana inononi, akaka ivona, “Onoto taina ana pata nua gawagawami veimeyei kadue one‑yavunei, iuna tauna ya bagibagi vinꞌ‑omo Beelesebubi wayahina. Tauna nua gawagawami yai kauvea, kadu tauna awaehei onoto taina dewaia dedewei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ka Iesu yai nuanua avaha anamanei, ka vona tana‑minikuna wayahina vonei, ivona, “Aituhu tau maꞌ aitamoata aitamoata pai veimea nihenina ai heta wayahia ivi‑naua, apaina pai veimeana na‑goyo, na‑iakwa. Kadu deinake, aituhu tau vi‑meagai o tomotau yoko nihenina aitamoata aitamoata ivi‑naua, apaina meagai‑nana o yoko‑nana na‑goyo, na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kadue aituhu Satana tauna ya nua gawagawami one‑yavunei, akanai tauna ya bagibagi tana‑vewani deina, e apaina ya pai veimea na‑peu na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Itomi uvonavona yau bagibagi Beelesebubi wayahina vinꞌ‑omo, e nua gawagawami aone‑yavunei deina. Ka ami tau vi‑muni‑waiwai tupwai ai pata kadu ione‑yavunei. Wayahina, yau vi‑tanai wayahimia taina. Aituhu yauke yau bagibagi vinꞌ‑omo Beelesebubi wayahina, kaiwadi ami tau vi‑muni‑waiwai yai bagibagi koiaka wayahina vinꞌ‑omo? Aituhu uvonavona deina, apaina ami tau vi‑muni‑waiwai inꞌ‑apa‑goyogoyomi. ");
INSERT INTO mvn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kate aituhu yau bagibagi vinꞌ‑omo Yaubada Nuana Ahihinata wayahina, kadue aituhu nua gawagawami aone‑yavunei deina, vona ahiahina avonemi, Yaubada ya pai veimea avaha si‑vo‑tanimi. ");
INSERT INTO mvn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kadu aitam pai dune avenemi, unononi. Aituhu tau bagibagi tauna ya manua dune‑vi‑avini ahiahina, tau vainau eha ana pata ya gugua na‑vainau. Kate aituhu aitam tau vainau vinꞌ‑omo, e naona tau bagibagi‑nana na‑yohoni, akanai munia, tauna ana pata ya manua na‑nui, e memeanina ya gugua na‑vainaui. Wayahina, avi tuta nua gawagawami aone‑yavuhei, unꞌ‑anamanei yau bagibagi eha ta‑vinꞌ‑omo Satana wayahina, kate yauke avaha Satana ayohoni. ");
INSERT INTO mvn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ka aituhu aviyaivia eha ina‑ivaiteu, taui au havia. Kadu aituhu aviyaivia eha yauke nui mani tomotau kakwakwakwei, akanai taui mani tomotau ivo‑tahoi ini‑tawaneu. ");
INSERT INTO mvn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wayahina, aituhu aviyaivia wayahimia yami nuanua nua‑piaha uvaniahei, avonemi ana pata yami goyona aitamoata aitamoata wayahi nua‑piaha uvaniahei, kadu ana pata yami apa‑goyogoyo aitamoata aitamoata Yaubada wayahina nua‑piaha uvaniahei. Kate udu! Aituhu Nuana Ahihinata uapa‑goyogoyoei, eha ana pata dewana goyona wayahina nua‑piaha uvaniahe. ");
INSERT INTO mvn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","O aituhu aviyaivia Tauna Vi‑tomotau iapa‑goyogoyoeu, ana pata dewana goyona wayahina nua‑piaha ivaniahei. Kate aituhu aviyaivia Nuana Ahihinata iapa‑goyogoyoei, eha ana pata dewana goyona wayahina nua‑piaha ivaniahe. Tanopi taina hetana eha ivaniahe, ka kadu apaina tuta tepakaia omomo wayahina eha ivaniahe. Iuna Nuana Ahihinata eta‑naoemi unua‑vinana goyona habuhabui wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Aituhu ai ahiahina, apaina uana ahiahina, ka aituhu ai goyona, apaina uana kadu goyona. Wayahina, aituhu uana kadueyei, ai kanꞌ‑anamanei ahiahina o kadi goyona deinake. ");
INSERT INTO mvn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ka itomi ai goyona deina o mwata natunatuna deina. Ika, nuami goyona. Wayahina, eha ami pata vona ahiahina uvonavona. Iuna avi nuanua nuaka nihenina mamaei, apaina nuanua‑nana na‑iwahi awakaia. ");
INSERT INTO mvn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wayahina, dewa ahiahina ivinꞌ‑omo tomotau ahiahina wayahia, kadu dewa goyona ivinꞌ‑omo tomotau goyona wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ka vona‑vavaha avonemi, apaina aitam auyewa omomo, ka auyewana wayahina Yaubada tomotau aitamoata aitamoata nꞌ‑apa‑vidovidohei o kadi nꞌ‑apa‑goyogoyoei yai dewa wayahi kadu yai vona wayahi. Ka auyewana wayahina tomotau habuhabui nau‑wawani yai vona‑kavokavovo aitamoata aitamoata wayahina ivona‑nau‑pata Yaubada wayahina, e Yaubada na‑nononi, e ai dewa‑yaiyai wayahi vi‑nua‑dadani. ");
INSERT INTO mvn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wayahina, avonemi, apaina Yaubada nꞌ‑apa‑vidovidohemi yami vona wayahi, o kadi tauna nꞌ‑apa‑goyogoyoemi yami vona wayahi.” ");
INSERT INTO mvn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ka tau ginuma anani ka Parisi tupwai iviamei, ivona, “Tau Viwavenena, itoai nuanuai iaiaya aitam evevewanei, adueyei. Aina ana pata anꞌ‑anamanem yam vona tunuhina.” ");
INSERT INTO mvn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka Iesu nau‑pata ivona, “Itomi tau goyogoyomi kadu itomi tau kenekenenemi. Yami nuanuana iaiaya avevewanei wayahimi vivane dewa goyona. Wayahina, iaiaya aitamoata akanai uvaniahei, ka iaiayana vivane tau apa‑taputapu Iona a iaiaya deina. ");
INSERT INTO mvn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tuta nonova Iona iana ananina nihenina mamaei auyewa aitonu kadu ioyoma aitonu wayahina, e munia vinꞌ‑omo. Ka apaina Tauna Vi‑tomotau itavuniu tanopi nihenina amamaei auyewa aitonu kadu ioyoma aitonu, e munia avinꞌ‑omo deina. ");
INSERT INTO mvn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Apaina, vitana matana anꞌ auyewana wayahina, tau vi‑meagai Nineve itomi nui umimini Yaubada matana, kate taui imana‑giboemi. Iuna tutana Iona nau‑wahe wayahia, taui inononi inua‑vinana. Kate tuta ataina aitam mamaei, ka tauna Iona vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ka kadu deinake, auyewana wayahina, papani Seba ana kwiniV itomi nui umimini Yaubada matana, ka kadu vavinena mana‑giboemi. Iuna nonova tauna ya papani ni‑tawanei ine bana mamanaina, e KiniV Solomoni ya nua‑uya na‑nononi. Kate udueyei. Tuta ataina aitam mamaei, ka tauna Solomoni vane‑tawanei. Wayahina, kadueyei Yaubada am‑venena ani‑vainena venemi, kate eha uta‑nononi, ka eha uta‑nua‑vinana yami dewa goyona wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Unononi, e pai dune aviwavenemi. Aituhu nua gawagawamina onoto na‑ni‑tawanei, nua‑nana na‑ni‑awana‑kavovo anata nihenina, iuna tauna kadu aitam pai vi‑yawai wayahina naunau‑nene. Ka munia, aituhu eha kadu aitam ta‑vaniahe, akanai ");
INSERT INTO mvn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ana heta ivona, ‘Ia! Onoto‑nana avaha ani‑tawanei amavina wayahina, kadu anu‑havine nihenina, e amamaei, vivane yau manua.’ Ka nua‑nana avaha onoto‑nana vaniahei, akaka ya manua tutuaina taina vaniahei inau‑hinia, ka ivaivanei, kate awakabina. ");
INSERT INTO mvn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Wayahina, nua‑nana ine, e mani nua gawagawami‑vainei ai yau 7 vaniahai, omanei, e nui imavina onoto‑nana wayahina, ka habuhabui inui ka imaꞌ‑vavaha. Ka tuta naona onoto‑nana yawaina goyona, iuna nua gawagawamina aitamoata yawaina veimeyei. Kate munia, yawaina goyo‑vainena, iuna nua gawagawami ai yau 8 iveimeyei. Ka itomi tomotau goyogoyomi, ka aituhu Nuana Ahihinata eha nihenimia, apaina yawaimi goyo‑vainena onoto‑nana deinake.” ");
INSERT INTO mvn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ka Iesu manua nihenina yokoia wayahia vonavona, eha ya vonana ta‑nau‑yehai, e ayona ka vavaneina iomo, e manuana upuna imimini, ka inaunau‑nene, ina‑ipupu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka aitam koiaka Iesu vonei, “Edu, ayom ka vavaneim upuna imimini, ka inenenem ivonem.” ");
INSERT INTO mvn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Iesu ya vonana nau‑patei, ivona, “Ayou koiaka? Ka vavaneiu aviyaivia?” ");
INSERT INTO mvn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ka nimana vi‑yoyoei a tau vi‑muni‑waiwai wayahia, ka ivona, “Udueyei! Taui taina ayou kadu vavaneiu! ");
INSERT INTO mvn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iuna aituhu aviyaivia Amau wahuma ivi‑ateteyei, taui vivane vavaneiu, ka novunovu ka ayoyou.” ");
INSERT INTO mvn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka auyewana wayahina Iesu manua‑nana ni‑tawanei, iopu Navu Galili tania, e manuena. Ya nuanua yoko inꞌ‑omo wayahina, e viwavenena. ");
INSERT INTO mvn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka yoko ananina inau‑hohona wayahina, akaka tauna aitam wae wayahina igenu, manuena, ka yoko‑nana tania imimini. ");
INSERT INTO mvn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","E nua‑uya habuhabuna viwavenei vona tana‑minikuna nihenina, ivona, “Tau baguna aitam inei ya baguna, e witiV utuna si‑yavuyavunei. ");
INSERT INTO mvn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ka tupwai utuia etawana ipeu. Wayahina, manua idueyei, e iyaveha iopu iam‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka tupwai utuia tanopi hanuhanuna wayahina ipeu. Ka munia, inau‑tabo‑kwayavoni, iuna tanopi‑nana avavana. ");
INSERT INTO mvn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ka apaina babau apu‑gabwani, e nau‑moewa, iuna wanohi eha tanopi kwekwekwena ita‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka tupwai utuia mata‑dududuna nepena ipeu, e nui inau‑tabo tamotamota. Ka mata‑dududuna bagibagi, e isi‑vi‑anai, e witiV aniga. ");
INSERT INTO mvn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka tupwai utuia tanopi ahiahina wayahina ipeu, e inau‑tabo, inatanata. Ka iuaua, ka tupwai utuia uai ai yau 100, ka tupwai 60, ka kadu tupwai 30. ");
INSERT INTO mvn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vonana iakwa, e a tau vi‑muni‑waiwai ivinꞌ‑omo, e Iesu ivi‑tanaiei, ivona, “Aviani wayahina vona tana‑minikuna ana heta wayahina yokoia wayahia eviwavenena?” ");
INSERT INTO mvn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka Iesu ivona, “Yaubada avaha awaehemi nua‑uya hivahivana ya pai veimea wayahina unꞌ‑anamanei, kate yokoia eha. ");
INSERT INTO mvn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nua‑uya Yaubada wayahina deina. Aituhu aviyaivia yai anamana wayahia mamaei, ka aituhu idewa‑nubunubui, apaina yai nua‑uya ani‑vainena ivaniahei. Ka aituhu aviyaivia eha ita‑dewa‑nubunubu, avi anamana ataina wayahia mamaei, apaina ivo‑haini. ");
INSERT INTO mvn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taui idunedune, kate eha itꞌ‑anamane, ka ivanevaneneha, kate eha ita‑nononi kadu eha ita‑nua‑hau. Wayahina, vona tana‑minikuna wayahia aviwavenei, iuna eha yai nuanua ananina Yaubada inꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wayahina, nonova tau apa‑taputapu Isaia mai‑haeyei deina, ivona, ‘Tuta tuta uvanevaneneha ka nuami eha tꞌ‑am‑hauhau. Ka kadu udunedune, ka eha ami pata unꞌ‑anamane ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iuna tomotau taina ununui ivi‑toyoa, ka tanihai itupa‑potei, kadue matai ivo‑potei. Aituhu yai dewa eha deina, kaiwadi ai pata mataia idunedune, ka tanihaia inononi, kadue inua‑haui. Ka aituhu inua‑haui, imavina wayahiua, e adewa‑vidovidohei.’ Tuta ataina tomotau yai dewa tomotaui nonova yai dewa aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kate taumi au tau vi‑muni‑waiwai tunimi. Yaubada avaha nau‑iaiavemi. Wayahina, ami pata matamia udunedune, e avaha uanamane, ka kadu tanihamia unononi, e avaha unua‑haui. ");
INSERT INTO mvn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Memeanina nuami vi‑tupatupa, kate avonemi, ataina dewaia ududueyei ka unonononi, ka avonemi, tuta nonova a itoava tuta ataina wayahina tau apa‑taputapu habuhabui kadu tau tunutunuhi habuhabui nuanuai ananina dewaia idudueye kadu nuanuai vonaia inonononi, kate eha ita‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wayahina, itomi unononi, e utu a si‑yavuyavunena anꞌ anamana avo‑vi‑mahetemi, unꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aituhu aviyaivia Yaubada ya pai veimea ipuipupuna inonona‑ohoi, ka eha ita‑nua‑hau, apaina Tau Vi‑goyo‑nana na‑omo, e vonaia nuai wayahia vainaui. Ka utuia ipeu etawana ai anamana deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ka kadu utuia tupwai tanopi hanuhanuna wayahina ipeu. Ka tomotau tupwai ipupu ahiahina inononi, kadu yai dewa‑haiawa nui iawaehei. ");
INSERT INTO mvn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kate wanohi eha ta‑toyotoyoa, ka imamaei tuta eha ani‑hoina wayahina. Iuna aituhu avi tuta Vaneana Ahiahina a vitumahana wayahina bebewa o kadi vita ivaniahei, taui ipeu‑kwayavoni, ka yai vitumahana ivo‑haini. ");
INSERT INTO mvn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ka utuia tupwai mata‑dududuna nepena ipeu. Ka tomotau tupwai Vaneana Ahiahina inononi, kate aviani nau‑wawani tanopi taina wayahina, taui dewaia ivi‑putu inuanua ananina wayahi. Kadu inuanua ananina kaikaiwabo yai gugua wayahina, ka guguaia inonoi. E yai nuanua‑naia Vaneana Ahiahina si‑guani aniga deina. Wayahina, taui eha ai pata ina‑ua. ");
INSERT INTO mvn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka utuia tupwai tanopi ahiahina wayahina ipeu. Ka tomotau tupwai Vaneana Ahiahina inononi kadu anꞌ anamana wayahia mamaei, e aihana ahiahi ivinꞌ‑omo wayahia. Tupwai uai 100, ka tupwai uai 60, ka tupwai uai 30.” ");
INSERT INTO mvn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kadu aitam vona tana‑minikuna Iesu venei, ivona, “Yaubada ya pai veimea deina. Aitam tau baguna witiV uana ahiahina epei, e ya baguna nihenina si‑yavuyavunei. ");
INSERT INTO mvn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ka aitam ioyoma tauna ino‑ainei, e a havia aitam omo, e baguna inui, e mata‑duduna nau‑yavuyavunei witi‑hoinaV nihenia, e munia ine. ");
INSERT INTO mvn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wayahina, ainua itabo ivane tuta aitamoata wayahina, e ainua ivi‑putu iua vivane witiV kadu mata‑duduna. ");
INSERT INTO mvn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ka avaha tau vi‑bagunana ya tau dune‑vi‑avina tupwai idueyei, imavina wayahina, imataedei, ivona, ‘Bada, yam baguna witiV ahiahina avaha igoyo. Kaiwadi, medeina mata‑duduna habuhabuna nui itabotabo?’ ");
INSERT INTO mvn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ka tau vi‑bagunana ivona, ‘Ia! Au havia aitam omo dewei.’ Wayahina, ya tau paisewa‑naia ivi‑tanaiei, ivona, ‘Medeina yam nuanua? Ana‑nei, e mata‑dudu‑naia asi‑apui?’ ");
INSERT INTO mvn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ka bada‑nana ivona, ‘Eha. Aituhu mata‑dudu‑naia usi‑apui, tuta aitamoata wayahina witiV wanohi uvi‑goyoi deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Akanai, nui itabotabo a itoava tuta aihana wayahina. Apaina yau tau aihana avonei deina, “Naona mata‑dudu‑naia unau‑hohoni, unau‑itavi. Apaina utunu‑yavunei. Ka witiV unau‑hohoni, e yau anana nihenina utotohi.” ’” ");
INSERT INTO mvn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ka kadu aitam vona tana‑minikuna venei, ivona, “Yaubada ya pai veimea mata‑sinisinina utuna deina. Ka onoto utuna aitamoata epei, e ya baguna nihenina baguni. ");
INSERT INTO mvn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka mata‑sinisinina utuna kikitu‑vainena, ka yana tabo munina vi‑ai. Wayahina, manua iomomo, e nahana wayahia ai hiu iyoneyone‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ka kadu aitam vona tana‑minikuna venei, ivona, “Yaubada ya pai veimea palaua a pai vo‑vi‑nata deina. Ka vavine pai vo‑vi‑nata aya‑kituna iepei, e palaua ananina nui ivinei. Pai vo‑vi‑nata aya‑kituna, kate bagibagina, e ana pata palaua ananina habuhabuna vo‑vi‑natei.” ");
INSERT INTO mvn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ka Iesu nua‑uya habuhabuna yokoia viwavenei, kate tuta habuhabuna wayahina vona tana‑minikuna ai heta wayahia viwavenena tomotau wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dewana wayahina tau apa‑taputapu ya vona‑dabadaba mamaei. Tanoi nonova mai‑haeyei, ivona, “Vona tana‑minikuna wayahina ahaeyei. Ka aviani Yaubada hivehivei nonova tanopi a vevewana ana tuta a itoava tuta ataina wayahina avo‑vi‑mahetei.” ");
INSERT INTO mvn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ipupu taina iakwa, e Iesu yokoia ni‑tawanei, mavina manua‑nana wayahina, e inui. Ka munia a tau vi‑muni‑waiwai iomo wayahina, e iviamei, ivona, “Itoai yama nuanua vona tana‑minikuna mata‑duduna ka witiV ainua wayahina anꞌ anamana evo‑vi‑maheteai anua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wayahina Iesu ivona, “WitiV utuna a tau si‑yavuyavunena tanoi vivane Tauna Vi‑tomotau, ");
INSERT INTO mvn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ka baguna tanoi vivane tanopi habuhabuna, ka witiV utuna ahiahina tanoi taui Yaubada ya pai veimea a tau vi‑muni‑waiwai, ka mata‑duduna tanoi taui Tau Vi‑goyo a tau vi‑muni‑waiwai, ");
INSERT INTO mvn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ka mata‑duduna a tau si‑yavuyavunena tanoi vivane Satana. Ka aihana ana tuta tanoi vivane tuta a pai nau‑yehata, ka tau aihana tanoi vivane Yaubada yanꞌ anelose. ");
INSERT INTO mvn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ka tau aihana‑naia iomo, e mata‑dudu‑naia inau‑hohoni, inau‑itavi, itunu‑yavunei. Ka apaina, tuta a pai nau‑yehata wayahina, deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apaina auyewana wayahina yauke, Tauna Vi‑tomotau, yau anelose avi‑tunei iomo, e dewa goyona aitamoata aitamoata kadue tau goyogoyona aitamoata aitamoata inau‑hohoni, inau‑itavi, ka yau pai veimea wayahina ivitua‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iakwa, e ai ananata nihenina ihaponei, ka tanoi papani‑nana wayahina tomotau ivi‑mohai kadue ivi‑mahi‑nununa, iuna viha ani‑vainena wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka auyewana wayahina tau tunutunuhi Yaubada matana kanꞌ‑anamanei ahiahina, iuna amai tauna didigana venei ya pai veimea nihenina. Wayahina, itunu‑mahetei, babau deina. Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui. ");
INSERT INTO mvn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yaubada ya pai veimea vivane kaikaiwabo ya gugua vi‑maiena ani‑vainena deina. Nonova kaikaiwabona epei, e omo aitam tano wayahina, e guguana a pai vi‑ai ikayo, hivei. Ka munia, aitam onoto omo, vaniahei, e tauna ya dewa‑haiawa ananina. Wayahina, hive‑havinei, e mavina ya manua wayahina. Ka ya dewa‑haiawa nui ya gugua habuhabui vituei, imwaneyei. Ka ai nau‑pata epei, ine, e tano‑nana vi‑maiei, yana tano. E tauna kaikaiwabo ya gugua a nau‑pata ani‑vainena poyꞌ‑avini deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ka kadu Yaubada ya pai veimea tau aimwane aitam, e mwani ahiahina wayahina naunau‑nene deina. ");
INSERT INTO mvn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka aitam auyewa, tauna mwani ahihi‑vainena vaniahei. Wayahina, ine, e ya gugua habuhabuna imwaneyei, e ai nau‑pata wayahina mwani‑nana ahihi‑vainena vi‑maiei, yana mwani. ");
INSERT INTO mvn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ka kadu Yaubada ya pai veimea aitam agida deina, e tomotau inenehi hawana. Ka mani iana mani iana ivi‑onai, ");
INSERT INTO mvn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","e avaha agida‑nana nau‑vi‑anata, e itaini ivane tania. Ka tomotau imanuena, e iana habuhabui itana‑vewani. Ka iana ahiahi nau‑kai nihenia ivi‑aia, ka iana goyogoyoi iyavunei. ");
INSERT INTO mvn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka tuta a pai nau‑yehata ana dewa deina. Auyewana wayahina anelose inꞌ‑omo, e tau goyogoyona itana‑vewani tau ahiahina wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ka tau goyogoyona ivituei, ione‑neiei ana ai ananata nihenina, e tanoi ivi‑mohai ka ihidahida ananina.” ");
INSERT INTO mvn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wayahina, Iesu vi‑tanaiei, ivona, “Itomi medeina? Vona tana‑minikuna tanoi habuhabui avaha uanamanei o eha?” Ka a tau vi‑muni‑waiwai ivona, “Ika, avaha.” ");
INSERT INTO mvn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wayahina, vonei, ivona, “Vona ahiahina, tupwai tau viwavenena Yaubada ya veimea tutuaina ianamanei ahiahina. Ka aituhu aviyaivia wayahia kadu avaha Yaubada ya pai maꞌ vaneana ianamanei ahiahina, taui aitam kaikaiwabo deina. E taui ai pata yai manua inui, e gugua tutuai ai nau‑pata ananina kadu gugua vovoui ai nau‑pata ananina isi‑vinꞌ‑omanei.” ");
INSERT INTO mvn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka Iesu avaha ya vona tana‑minikuna tanoi nau‑yehai, e papani tanoi ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","E mavi‑havine ya megeia, ka omo yai manua tapanono wayahina, inui, e vi‑putu tomotau viwavenei. Ka tomotaui nuai vi‑tupatupa, e ivona, “Koiaka onoto taina ya nua‑uya venei, ka koiaka awaehei tauna dewa‑bagibagina dedewei?” ");
INSERT INTO mvn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kadu ivona, “Kaiwadi, onoto taina vivane tau yona manua ana wava Iosepa natuna, a? Ka ayona vivane Mari, ka vavaneina Iamesa ka Iosepa ka Simoni ka Iudasa kanamanei, ");
INSERT INTO mvn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ka kadu novunovuna nui kamamaei. Tauna itoka aitamoata deina. Wayahina, onoto taina ya nua‑uya aveta baina wayahina vinꞌ‑omo? Tauna koiaka?” ");
INSERT INTO mvn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wayahina, inua‑goyo ka ivihahaiei. Ka Iesu vonei, ivona, “Tau apa‑taputapu apa‑vidovidoha ivaniahei tomotau habuhabuna wayahia. Kate tau vi‑meagai yai megeia, kadu yai yoko yai manua imana‑giboei.” ");
INSERT INTO mvn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wayahina, Iesu tauna ya megeia eha dewa‑bagibagina habuhabuna ta‑dewe, iuna taui eha ita‑vitumahane. ");
INSERT INTO mvn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tuta tanoi wayahina Erodi, tauna Galili a tau veimea, Iesu yana dewa vaneana nononi, ");
INSERT INTO mvn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e Erodi tauna ya tau paisewa wayahia Iesu ya dewaia voneyei, ivona, “Onoto‑nana vivane Ioni Tau Bapitaiso, ka tauna avaha anigea mini‑havine! Wayahina ya bagibagi ananina nui dewadewa.” ");
INSERT INTO mvn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erodi ipuipupu Ioni Tau Bapitaiso yanꞌ aniga wayahina deina, iuna nonova tauna Ioni poyꞌ‑avini, ka yohoni, ka manua yohona nihenina boui. Ka dewaia ivinꞌ‑omo Ioni wayahina, iuna aitam vavine ai wava Erodiasa wayahi. Naona Erodiasa Erodi vaneina ana wava Pilipi awana, ");
INSERT INTO mvn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kate Erodi ya nuanua namoiana. Wayahina, epei, tavinei. Iakwa, e Ioni Tau Bapitaiso omo Erodi wayahina, haeyei, ivona, “Yam dewa taina eha dewa ahiahina. Avaha vaneim awana etavinei, ka dewana vivane kenene.” ");
INSERT INTO mvn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wayahina, Erodi nua‑goyo ka nuanuana Ioni na‑nau‑vi‑anigi, kate tomotau habuhabui iawaehei Ioni vivane tau apa‑taputapu aitam. Wayahina, Erodi matamatauta, ka eha Ioni ta‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka munia, Erodi yanꞌ auyewa tupua a pai nua‑vi‑avina toneina wayahina, yoko inau‑hohona, ka Erodiasa natuna vavinena yoko mataia tavona, e Erodi vo‑vi‑dewa‑haiawi. ");
INSERT INTO mvn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ka tavona iakwa, e Erodi ahabanana wayahina vona‑nua‑kabubu. Ivona, “Aviani yam nuanua, avenem. Avona‑dabadaba wayahima.” ");
INSERT INTO mvn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ka ahabanana omo ayona wayahina, e ainua iaipupu. Iakwa, e ahabanana mavina, e Erodi vonei, ivona, “Nuanuau Ioni Tau Bapitaiso unununa nau‑kai nihenina ena‑uani, eveneu adueyei.” ");
INSERT INTO mvn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ka Erodi avaha ahabanana ya viamana nononi, e nuana ivita ananina. Ka akanai ya vona‑dabadaba nuani, kadu yaiana inau‑hohona matana avaha yana vona inononi, wayahina awaehei. ");
INSERT INTO mvn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka ya tau paisewa aitam manua yohona vi‑tunei, e Ioni magana upwei, ");
INSERT INTO mvn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","e unununa nau‑kaia uani, omanei, e ahabanana venei. Ka ahabanana epei, e neiei ayona wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka Ioni a tau vi‑muni‑waiwai iomo, e Ioni tau matena iepei, ka ineiei itavuni. Ka munia, iomo Iesu wayahina, e dewana ihaeyei. ");
INSERT INTO mvn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ka avaha Iesu dewana nononi, aitam wae igenu, inei aitam papani eha meagai, vivane anata. Ka yoko Iesu yana nae vaneana inononi, wayahina yai meagai ini‑tawanei, e etawana iomo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ka tutana Iesu waea iopu tania, yoko ananina dueyei, e ate‑nuanuaiei, e tau kwanakwanaha wayahia vo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka vinanavi a tau vi‑muni‑waiwai iomo, e Iesu ivonei, ivona, “Kauvea, papani taina anata, ka eha ani‑hoina vi‑novane. Wayahina, nau‑wawanim yoko taina evi‑tunei, imavina, e ai maꞌ ivi‑maiei meagai nepeia wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka Iesu vonei, ivona, “Taui eha nau‑wawani ini‑tawaneka. Akanai, itomi uvenei inꞌ‑am.” ");
INSERT INTO mvn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka ivonei, ivona, “Ia! Medeina adewe? Ama maꞌ eha habuhabuna, vivane palaua nima papanina, ka iana ainuata.” ");
INSERT INTO mvn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka Iesu vonei, ivona, “Palaua ka iana uomaneu.” ");
INSERT INTO mvn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ka tauna yoko vonei, ivona, “Wetau wayahina umanuena,” e imanuena. Ka palaua nima papania ka iana ainua epei, ka dune‑vane wahuma, nau‑kaiwei. Ka munia, gibui, e a tau vi‑muni‑waiwai venei, e tomotau ivo‑patai. ");
INSERT INTO mvn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ka habuhabui iam‑iaua, ka aniani kamukamumuna inau‑gwaugwaui venuana ai yau 12 ivi‑nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ka taui iam‑iaua ononotoi ai heta ai yau 5000 deina, ka kadu vaivine ka yahehei habuhabui eha ai yau ita‑iavi. ");
INSERT INTO mvn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka vo‑kwayavoni tauna a tau vi‑muni‑waiwai veimeyei wae igenu ivi‑ata, ieta‑naoi mani papania, ka tuta aitamoata wayahina tauna tomotau yoko nui mamaei, ka habuhabui vonei iyavuta, imavina yai megeia. ");
INSERT INTO mvn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ka avaha yoko iyavuta deina, Iesu ana heta ivane oya na‑viama Yaubada wayahina. Ka avaha ioyoma, ka Iesu ana heta mamaei. ");
INSERT INTO mvn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ka a tau vi‑muni‑waiwai avaha yai waꞌ ivoiei, itana‑opu ana, ka yahina ananina ivaniahei. Ka yai waꞌ nau‑vinevinei, kadu ibebebewa, iuna yahina tepaia hunahuna. ");
INSERT INTO mvn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ka mata‑hamwahamwanina Iesu navu hetana omomo, e a tau vi‑muni‑waiwai nepeia vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ka tanoi wayahina a tau vi‑muni‑waiwai Iesu idueyei hawana hetana omomo, ka avaha idueyei imatamatauta ananina, e igagada. Ka ivona, “Aioi! Unupa!” ");
INSERT INTO mvn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Akaka Iesu vonei, “Eha umatamatauta. Unꞌ‑ate‑vatu. Iuna yauke taua.” ");
INSERT INTO mvn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wayahina, Pita ivona, “Kauvea, aituhu vona ahiahina wamke, akanai evoneu hawana hetana aopu, anꞌ‑omo wayahima.” ");
INSERT INTO mvn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Akaka Iesu ivona, “Ahiahina. Ena‑opu, enꞌ‑omoi.” Ka Pita waea iopu, e hawana hetana omomo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kate tutana venavenau, yahina ananina tepana dudueyei, e matamatauta, e hawana gavivina, e vi‑hone, “Kauvea, eivaiteu!” ");
INSERT INTO mvn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka Iesu vo‑kwayavoni Pita vo‑vi‑avini, akaka ivona, “Yam vitumahana aya‑kituna. Aviani iuna eva‑hamwahamwana?” ");
INSERT INTO mvn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka tutana ainua waea igenu, yahina iakwa ka mana gomana. ");
INSERT INTO mvn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ka taui wae a tau maꞌ iaiwaodu Iesu wayahina, akaka ivona, “Vona ahiahina, wamke Yaubada Natu‑hoina.” ");
INSERT INTO mvn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iakwa, iaubo‑tamana papani Genesareta wayahina, e iduduna tania. ");
INSERT INTO mvn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ka papani‑nana a tau maꞌ avaha Iesu ianamanei, ka tuyeha ivi‑tunei iomo yai meagai habuhabui wayahia, e yai tau kwanakwanaha habuhabui Iesu wayahina iomanei. ");
INSERT INTO mvn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ka iviamei, ivona, “Kauvea, memeanina tau kwanakwanaha taina am kwama awaniana ivo‑dadana‑ohoi? Aina ana pata ividoha.” Ka Iesu awaeha, e aviyaivia yokoia wayahia ana kwama ivo‑dadani, habuhabui ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ka munia, Parisi tupwai kadu veimea a tau viwavenena tupwai Ierusalem wayahina iomo Iesu wayahina, ka ivona, ");
INSERT INTO mvn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aviani iuna am tau vi‑muni‑waiwai eha nimai inosinosi, kate iamam? Yai dewana yaka tupua‑nenenehi yai dewa am‑nosi habuhabuka nau‑wawanika bwegebwegei, ka wamke eawaehei, a?” ");
INSERT INTO mvn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ka vonei, ivona, “Yami tupua‑nenenehi yai dewa uvi‑muniei, ka itomi Yaubada ya veimea ubwegebwegei deina. ");
INSERT INTO mvn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iuna Yaubada ya veimea ainua mamaei. Aitam ivona, ‘Amam kadu ayom evi‑ateteyei,’ ka vꞌ‑inuana kadu ivona, ‘Aituhu koiaka amana o kadi ayona apa‑goyoei, nau‑wawanimi tomotauna unau‑vi‑anigi.’ ");
INSERT INTO mvn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kate itomi yami viwavenena vitupu wayahina uvonavona, ‘Aituhu koiaka amana ka ayona vonei, “Yau gugua avaha awaehei Yaubada wayahina. Eha au pata ana‑ivaitemi guguana wayahina,” tauna onoto ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ka aituhu tauna eha amana na‑ivaite, dewana eha aitam aviani matamia, iuna unuanua tauna avaha Yaubada ivaitei.’ Yami dewa tutuaina uvi‑muniei deina, kate dewana wayahina Yaubada ya veimea udewa‑kavokavovoei. ");
INSERT INTO mvn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Vona ahiahina, itomi tau vitupu! Nonova tau apa‑taputapu Isaia apa‑taputapu tunuhina wayahimi tutana Yaubada yana vona haeyei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tomotau taina awaia iapa‑vidovidoheu, kate nuai wayahina eha ivi‑ateteyeu. ");
INSERT INTO mvn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ka itapanono‑wayoheu, iuna yai tapanono vinꞌ‑omo tomotau yai nuenuea.’” ");
INSERT INTO mvn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kadu Iesu yoko honei, ka vonei, ivona, “Vona taina unononi, unua‑haui. ");
INSERT INTO mvn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaubada ya veimea voneka, aituhu nuaka ivi‑gawama Yaubada matana dewana eha ahiahina. Ka avonemi, aituhu aviyaivia aniani awaia iboui, anianina eha ana pata tomotaui nuai na‑vo‑vi‑gawami Yaubada matana. Kate vona goyona tomotau awaia ivinꞌ‑omo, vonaia ana pata tomotaui nuai ivo‑vi‑gawami Yaubada matana.” ");
INSERT INTO mvn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iesu ya vonana iakwa, ka a tau vi‑muni‑waiwai iomo wayahina, e ivonei, ivona, “Kauvea, enononi. Parisi yoko avaha inua‑goyo, iuna yam vonana wayahi.” ");
INSERT INTO mvn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ka Iesu ivona, “Aviani ataina tabotabo, ka aituhu Amau eha ta‑baguna, Parisi deina, apaina aitamoata aitamoata na‑si‑apu‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Akanai. Eha Parisi yai viwavenena unononi. Taui tau eta‑naonao kadu tau mata‑goyo deina. Aituhu aviyaivia tau mata‑goyo, o kadi Parisi ivi‑muniei, apaina ainua ina‑peu kemana ina‑opu.” ");
INSERT INTO mvn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka Pita viamei, ivona, “Vona tana‑minikuna tanoi anꞌ anamana evo‑vi‑mahetei wayahiaia.” ");
INSERT INTO mvn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka Iesu ivona, “Ia! Eha uta‑nua‑hau, a? ");
INSERT INTO mvn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Unononi. Aviani awamia na‑nu madimia, haina wayahina na‑opu, na‑ne, na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ka aviani awamia vinꞌ‑omo, aina vinꞌ‑omo nuami wayahina. Ka aituhu nuami goyona, apaina yami vona yawaimi na‑vo‑vi‑gawami. ");
INSERT INTO mvn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nua‑goyo, nau‑vi‑aniga, kenene, ni‑awana‑kavokavovo, vainau, vona vitupu, awa‑viaoha, kadu mabonu. Dewaia habuhabui ivinꞌ‑omo tomotau nuai wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ka dewaia tomotau nuai ivo‑vi‑gawami Yaubada matana. Kate aituhu nimaka eha kata‑nosi, ka aituhu apaina kanꞌ‑am, dewana eha ana pata nuaka na‑vo‑vi‑gawami Yaubada matana.” ");
INSERT INTO mvn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ka Iesu tauna a tau vi‑muni‑waiwai nui papani tanoi ini‑tawanei, iomo meagai Taia kadu meagai Sidoni ai papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka papani‑nana nihenina vavine aitam papani Kanaani wayahina ivinꞌ‑omo, ka ivi‑hone Iesu wayahina, ivona, “Kauvea, wamke Davida yana yoko, edune‑nuanuaieai! Natuai vavinena yawaina igoyo‑vaine, iuna nua gawagawamina veimeyei, ka vitevitei ka nua‑nana yana dewa wayahina natuai vi‑kwavakwava.” ");
INSERT INTO mvn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kate Iesu eha Kanaani vavinena yai vi‑hone ta‑nau‑pate, ka genuana. Ka munia, a tau vi‑muni‑waiwai iomo wayahina, ka ihidei, ivona, “Vavinena avaha ivi‑honehone wayahima, ka ataina taui ivi‑munieai, ka ivi‑honehone ananina. Wayahina, nau‑wawanim evihahaiei, evi‑tunei ina‑opu.” ");
INSERT INTO mvn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka Iesu ivona, “Yaubada vi‑tuneu aomo me Isiraeli ini‑tupatupai wayahia, iuna taui sipiV ini‑tupatupai deina. Ka nau‑wawaniu taui ai heta aivaitei, eha mani tomotau.” ");
INSERT INTO mvn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka vavinena iomo Iesu matana, aei ivi‑tupa‑gumi, e ivona, “Kauvea, eivaiteai!” ");
INSERT INTO mvn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka Iesu ivona, “Eha nau‑wawaniu yaheyahe ai maꞌ anꞌ‑epei avenei kedewa wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka vavinena ivona, “Kauvea, yam vonana vona tunuhina. Ka edueyei. Aniani kamukamumuna ipeupeu kaikaiwabo ya pai am wayahina. Ka vona ahiahina, ya kedewa nau‑wawani kamukamumu‑naia iamam, a?” ");
INSERT INTO mvn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kadu Iesu vavinena yai vonana vona‑nau‑patei, ivona, “Wamike tau vitumahana bagibagimi akanai. Wayahina, avaha yami viamana awaehei.” E babau‑nana wayahina vavinena natui vidoha. ");
INSERT INTO mvn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ka Iesu tauna a tau vi‑muni‑waiwai nui papani Taia ka Sidoni ini‑tawanei iomo Navu Galili, ka tania ini‑awana. Ka tauna oya kikituna ivane, manuena. ");
INSERT INTO mvn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka yoko ani‑vainena iomo wayahina, ka yai tau kwanakwanaha iomanei, ka Iesu nepena ibouni. Taui aei goyona, ka matai goyona, ka tau penapena, ka taui meai danui, kadu mani tau kwanakwanaha nui. Ka Iesu habuhabui vo‑vi‑aiaiei, ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka yokoia idudueyei vivane taui meai danui ipuipupu, ka tau penapena ividoha, ka taui aei goyona ini‑tunutunuha, ka kadu taui matai goyona idunedune ahiahina. Wayahina, yokoia nuai vi‑tupatupa ananina, ka me Isiraeli yai Yaubada iawa‑davedavei. ");
INSERT INTO mvn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ka Iesu tauna a tau vi‑muni‑waiwai hone‑hohoni, iomo, e vonei, ivona, “Yauke yoko taina ate‑nuanuaiei. Iuna avaha auyewa aitonu baina nui kamamaei, ka eha ai maꞌ. Wayahina, eha nuanuau am inavovo avi‑tune imavina yai megeia. Iuna apaina etawana matai nꞌ‑am‑honohonoi.” ");
INSERT INTO mvn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Akaka a tau vi‑muni‑waiwai nuai vi‑tupatupa, ka ivonei, ivona, “Papani taina eha meagai, kate ana. Kaiwadi, yoko taina ananina, ka medeina aniani ana pata wayahi kavaniahe?” ");
INSERT INTO mvn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ka Iesu vi‑tanaiei, ivona, “Ami palaua ai vi‑am mamae?” Ka taui ivona, “Wayahiaia palaua ai yau 7, kadu iana kikituna aitonuata.” ");
INSERT INTO mvn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka yoko veimeyei tanopia imanuena. ");
INSERT INTO mvn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iakwa, e palaua ai yau 7 iana nui epei, ka wayahi vona nau‑kaiwa Yaubada wayahina, ka gibui, e a tau vi‑muni‑waiwai venei, e taui yokoia ivo‑patai. ");
INSERT INTO mvn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ka habuhabui iam‑iaua, ka kamukamumuna ikwakwei venuana ai yau 7 ivi‑nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ka tau am ononotoata ai yau vivane 4000, ka yaheyahe vaivine habuhabui eha ita‑iavi. ");
INSERT INTO mvn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ka avaha iam‑iaua, e Iesu yokoia vonei, ivona, “Kaiwa ananina. Ataina nau‑wawanimi umavina yami megeia.” Wayahina, imavina. Ka tauna waea igenu, ka a tau vi‑muni‑waiwai nui ivi‑ata, iomo meagai Magadani ya papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ka aitam tuta wayahina Parisi yoko tupwai kadu Sadusi yoko tupwai iomo Iesu wayahina, ka yai nuanua inau‑dadani yai viama wayahina, ka ivonei, “Aituhu iaiaya aitam evevewane adueyei, akanai anꞌ‑anamanem vivane Yaubada vi‑tunem eomoi baina.” ");
INSERT INTO mvn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka Iesu ivona, “Aituhu babau onuonu, ka aituhu wahuma udueyei yabebenina, akaka una‑vona, ‘O, ahiahina. Ma‑putua mana‑gomana.’ ");
INSERT INTO mvn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","O aituhu mana‑putua umini ka aituhu wahuma udueyei yabebenina ka novanovanina, akaka una‑vona, ‘Ia! Wei yahina nui ivinꞌ‑omo ataina.’ Itomi ami pata nua‑uya uvaniahei wahuma ana dune wayahina deina. Kate eha ami pata nua‑uya uvaniahe iaiaya‑naia ivinꞌ‑omo tuta ataina wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aituhu aviyaivia yai nuanua naona aitam iaiaya idueyei, e munia ivitumahaneu, taui ai hum vivane goyogoyona kadu taui tau kenekenene Yaubada matana deina. Iuna taui yai vitumahana Yaubada wayahina ini‑tawanei. Tomotaui iaiaya aitamoata ivaniahei, ana heta iaiayana vinꞌ‑omo tau apa‑taputapu Iona wayahina deina.” Ka Iesu ya vonana iakwa, e ni‑tawanei ine. ");
INSERT INTO mvn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ka munia, Navu Galili iona‑tamanei mani papania, ka a tau vi‑muni‑waiwai ai kabwaga ivi‑nua‑pania, eha itꞌ‑epe. ");
INSERT INTO mvn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka Iesu vonei, ivona, “Parisi ka Sadusi ai palaua a pai vo‑vi‑nata vivane goyona. Udune‑vivinimi.” ");
INSERT INTO mvn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka a tau vi‑muni‑waiwai matataui ivonavona, “Iesu ya vonana wayahiaia vinꞌ‑omo, iuna aka kabwaga kavi‑nua‑pania.” ");
INSERT INTO mvn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka Iesu avaha yai nuanua anamanei, vonei, ivona, “Aviani wayahina uvonavona vivane, ‘Eha aka kabwaga’? Eha ata‑nuanua aka kabwaga wayahina. Uvonavona deina iuna yami vitumahana eha bagibagina. ");
INSERT INTO mvn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Unuani. Tutana palaua ai yau 5 aepei, e tomotau ai yau 5000 uvenei, munia kamukamumuna itupwa, ka venuana ai vi‑am ukwakwe? Habuhabuna, a? ");
INSERT INTO mvn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ka kadu tutana palaua ai yau 7 aepei, e tomotau ai yau 4000 uvenei, munia kamukamumuna itupwa, ka venuana ai vi‑am ukwakwe? Habuhabuna, a? ");
INSERT INTO mvn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aviani wayahina nuami eha tꞌ‑am‑hau. Eha aniani wayahina ata‑vonavona, kate avonavona wayahimia, ‘Parisi ka Sadusi ai palaua a pai vo‑vi‑nata vivane goyona. Udune‑vivinimi.’” ");
INSERT INTO mvn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Vonana wayahina a tau vi‑muni‑waiwai nuai am‑haui, ka eha palauata a pai vo‑vi‑nata wayahina vonavona, kate Iesu vonavona Parisi ka Sadusi yai viwavenena wayahina. Yai viwavenena goyona, ka aituhu inononi, munia yawai igoyo. Wayahina, nau‑wawani idune‑vi‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka Iesu Sisarea Pilipi a papani omoi, ka vi‑tanai tauna a tau vi‑muni‑waiwai wayahia, ivona, “Medeina tomotau ivonavona yauke, Tauna Vi‑tomotau, wayahiu? Taui inuanua yauke koiaka?” ");
INSERT INTO mvn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka taui ivona, “Tupwai tomotau ivonavona wamke Ioni Tau Bapitaiso, ka tupwai ivonavona wamke Elidia, ka tupwai ivonavona wamke Ieremia, o kaiwadi kadu aitam tau apa‑taputapu.” ");
INSERT INTO mvn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka Iesu vi‑tanai‑havinei, ivona, “Itomi medeina? Unuanua yauke koiaka?” ");
INSERT INTO mvn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka Simoni Pita ivona, “Wamke Tau Ito‑yavuha‑hoim, Yaubada Maꞌ‑vavaha Natuna.” ");
INSERT INTO mvn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Iesu vonei, ivona, “Simoni, Iona natuna, kaiwa ananina. Avaha nau‑iaiava evaniahei. Nua‑uyana wayahima, ka eha ta‑vinꞌ‑omo tomotau wayahia, kate Amau Yaubada wahuma vi‑nua‑dadanem, e viwavenem. ");
INSERT INTO mvn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kadu ataina avi‑putu avi‑wahanim PitaV. Ka apaina yau ekalesia ayonei hanu taina hetana, ka papani HadesiV a bagibagi eha ana pata yau ekalesia na‑bagibagi‑tawane. ");
INSERT INTO mvn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kadu yau bagibagi pai veimea wahuma wayahina awaehem. Ka apaina avi dewa tanopia evito‑potei, munia dewana kadu vito‑potana wahuma. Ka avi dewa tanopia eyavuhi, munia dewana kadu wahuma yavuyavuhina.” ");
INSERT INTO mvn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Vonana Pita wayahina iakwa, e tauna vona panina wayahina aitam dewa vito‑potei a tau vi‑muni‑waiwai wayahia, ivona, “Eha aitam koiaka uhaeye yauke vivane Tau Ito‑yavuha‑nana.” ");
INSERT INTO mvn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ka auyewana wayahina Iesu vi‑putu a tau vi‑muni‑waiwai vo‑vi‑mahetei inꞌ‑anamanei aviani na‑omo tauna wayahina. Ivona, “Yauke nau‑wawaniu ana‑ne Ierusalem wayahina, ka tenoke viha ananina avaniahei dewa habuhabuna wayahina ononotoi anani wayahia, kadu tau vi‑nomu wayahia, kadu veimea a tau viwavenena wayahia. Ka ina‑nau‑vi‑anigiu. Ka munia, auyewa aitonu na‑iakwa, e Yaubada na‑si‑vi‑mini‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ka avaha Pita vonana nononi, tauna Iesu taini‑tawanei, ka vonei, ivona, “Ia! Eha ana pata! Kauvea, eha nau‑wawanim dewana wayahima na‑vinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka Iesu magigino, ka Pita wayahina ivona, “Wamke Satana! Eni‑tawaneu! Eha evito‑potau! Yam nuanua tomotau yai nuanua deina, ka eha Yaubada ya nuanua deina.” ");
INSERT INTO mvn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Aituhu aviyaivia inuanua ivi‑munieu, taui nau‑wawani yai nuanua ibou‑ohoi, ivihahaiei. Ka kadu yau nuanua iawaehei idedewei, kadue taui nau‑wawani ai ai nahanahana inꞌ‑epei, e ai pata ivi‑muni‑waiwaieu deinake. ");
INSERT INTO mvn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iuna aituhu aviyaivia yai nuanua inua‑tania, taui yawai‑hoi itutu‑haini. Kate aituhu aviyaivia yai nuanua ibou‑ohoi ka ivihahaiei, iuna idune‑nuanuaieu, akanai taui yawai‑hoi ivaniahei kadu ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unononi. Aituhu ataina kaikaiwabo yai gugua ani‑vainena tanopia evaniahei, kate aituhu apaina tuta a pai nau‑yehata wayahina nuam evo‑haini, medeina evidoha? Avaha yawai‑vavaha evo‑haini deina. O apaina, vitana matana anꞌ auyewa wayahina, medeina nuam a nau‑pata evaniahe Yaubada evene? Eha am pata. Avi nau‑pata nau‑wawani nuam wayahina? Eha aitam. ");
INSERT INTO mvn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Apaina yauke, Tauna Vi‑tomotau, Amau didigana nui kadu Amau yanꞌ anelose nui amavina. Ka auyewana wayahina, tomotau aitamoata aitamoata anau‑patai taui nau‑wawani yai dewa wayahi deina. ");
INSERT INTO mvn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Memeanina nuami vi‑tupatupa, kate avonemi, tupwami umamaei a itoava yauke, Tauna Vi‑tomotau, amavina wayahina. Ka auyewana wayahina udune‑havineu, kadu yau pai veimea udueyei.” ");
INSERT INTO mvn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ka auyewa ai yau 6 munia, Iesu tauna a tau vi‑muni‑waiwai aitonu epai, e nui ivane aitam oya ananina wayahina. Ka a tau vi‑muni‑waiwaia vivane Pita, ka Iamesa, kadu Iamesa vaneina Ioni. ");
INSERT INTO mvn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tutana yai maꞌ oyana wayahina, Iesu tepana idueyei tapa‑yayai babau ana dune deina, ka ana kwama kavukavuata, maheta mahemaheina deina. ");
INSERT INTO mvn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ka tuta aitamoata wayahina Mosese, Elidia ainua ivinꞌ‑omo Iesu wayahina, e nui iaipuipupu. ");
INSERT INTO mvn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ka Pita Iesu vonei, ivona, “Kauvea, yaka maꞌ papani taina ahiahina. Wayahina, aituhu yam nuanua, vekevekeke aitonu ayonei, aitam wamke wayahim, ka aitam Mosese wayahina, ka aitam Elidia wayahina, ka …” ");
INSERT INTO mvn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ya ipupuna eha ta‑nau‑yehai, ka you mahetana habuhabui tana‑kabubui, ka you‑nana wayahina movi aitam vinꞌ‑omo inononi, ivona, “Taina Natu‑hoiu, adune‑nuanuaiei, ka tauna wayahina adewa‑haiawa ananina. Nau‑wawanimi yana vona unononi.” ");
INSERT INTO mvn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ka tau vi‑muni‑waiwai, avaha vonana inononi, yai matauta nui ipeu, ivi‑kabubu. ");
INSERT INTO mvn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ka Iesu omo, vo‑dadani, ka ivona, “Umini, eha umatamatauta.” ");
INSERT INTO mvn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ka idune‑vane, ka Iesu a heta‑ohota mimini idueyei. ");
INSERT INTO mvn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ka tutana oyea iopupu‑me, Iesu veimeyei, ivona, “Dewaia avaha udueyei eha mani tomotau umataedai. Ugenuana a itoava yauke, Tauna Vi‑tomotau, anigea amini‑havine wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka a tau vi‑muni‑waiwai ivi‑tanaiei, ivona, “Aviani wayahina veimea a tau viwavenena ivonavona Elidia mai‑omo, e munia, Tau Ito‑yavuha‑nana na‑omo?” ");
INSERT INTO mvn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka Iesu ivona, “Ika. Vonana tunuhina. Elidia ya paisewa taina deina. Tauna mai‑omo, e dewa habuhabuna vo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka unononi avonemi. Elidiana avaha omo, kate tomotau taina eha itꞌ‑anamane koiaka. Wayahina, aviani yai nuanua goyona, akanai taui avaha tauna wayahina idewei. Apaina kadue yauke, Tauna Vi‑tomotau, ivi‑goyou deinake.” ");
INSERT INTO mvn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Vonana wayahina a tau vi‑muni‑waiwaia nuai am‑haui, e ianamanei Elidia‑nana vivane Ioni Tau Bapitaiso. ");
INSERT INTO mvn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ka Iesu tauna a tau vi‑muni‑waiwai aitonu nui iopu yoko wayahia, ka aitam onoto omo, vi‑tupa‑gum Iesu matana. ");
INSERT INTO mvn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ka viamei, ivona, “Kauvea, natu onotona eate‑nuanuaiei, evo‑vi‑aiaiei. Iuna tuta habuhabuna mani nua epepei, veimeyei, ka ininina si‑bananaitena, wayahina ininina viviha ananina. Ka tupwai tuta tauna ai yabeyabena nihenina peupeu, ka tupwai tuta daudaua peupeu. ");
INSERT INTO mvn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka am tau vi‑muni‑waiwai wayahia aomanei, kate taui eha ai pata ivo‑vi‑aiaie.” ");
INSERT INTO mvn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wayahina Iesu ivona, “Ia! Itomi medeina? Kaiwadi, tepami toyoina, ka eha uta‑vitumahaneu, a? Aioi! Avaha tepami a toyoa wayahina ininiu yoina! Ai vi‑am wahava nau‑wawanimi nui kamamaei, e apaina unꞌ‑anamaneu, o kaiwadi, ai vi‑am tuta nau‑wawanimi aviwavenemi, e apaina ami pata? Tevanina uomanei baina wayahiua.” ");
INSERT INTO mvn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ka Iesu nua gawagawamina veimeyei tevanina wayahina na‑opu, na‑ni‑tawanei. Iakwa, e tevanina vidoha. ");
INSERT INTO mvn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ka munia, a tau vi‑muni‑waiwai yokoia ini‑tawanei, e iomo Iesu wayahina. Ka avaha ai heta Iesu nui, ivi‑tanaiei, ivona, “Kauvea, medeina itoai eha ama pata nua gawagawamina atꞌ‑epa‑yavune?” ");
INSERT INTO mvn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E Iesu ivona, “Itomi eha ami pata, iuna yami vitumahana ihanuana. Memeanina nuami vi‑tupatupa, kate avonemi, vitumahana kikituna a bagibagi ani‑vainena. Aituhu yami vitumahana ya nata mata‑sinisinina utuna deina, apaina oya tanoi uveimeyei, una‑vona, ‘Ena‑novo tenoke wayahina!’ ka dewana vinꞌ‑omo‑kwayavoni. Ka aviani yami nuanua, avi dewa‑bagibagina, ami pata wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ka munia, papani Galili nihenina ini‑keyekeyei, ka Iesu mataedai, ivona, “Yauke Tauna Vi‑tomotau, ka apaina au tau vi‑nua‑hauhau am‑veneneyeu au havia wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ka taui ina‑nau‑vi‑anigiu, ka auyewa vꞌ‑itonuna munina wayahina, Yaubada na‑si‑vi‑mini‑havineu.” Ka a tau vi‑muni‑waiwai, avaha Iesu ya hae‑nana inononi, inua‑vita ananina. ");
INSERT INTO mvn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka munia, meagai Kapenaum inui, ka takesiV Manua Vito‑pota wayahina a tau vitue iomo, e Pita ivaniahei, ivi‑tanaiei, ivona, “Yami tau viwavenena medeina? Tauna Manua Vito‑pota a takesiV awaehei veneai, o eha?” ");
INSERT INTO mvn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka Pita ivona, “Ika! Tauna yana dewa deina.” Ka avaha imavina yai manua wayahina, Iesu Pita vonei, ivona, “Simoni, yau vi‑tanai aitam wayahim. Tau veimea tanopi taina wayahina yai dewa medeina? Koiaka yai tomotau wayahia yai takesiV vivitua? Kaiwadi, taui natunatui wayahia, o kadi mani tomotau wayahia?” ");
INSERT INTO mvn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wayahina, Pita vona‑nau‑patei, ivona, “Mani tomotau wayahia, eha natunatui wayahia.” Ka Iesu kadue vona‑havine, ivona, “Vona ahiahina, mani tomotau wayahia. Wayahina, natunatui eha nau‑wawani takesiV ivenevene, a? Ka avonem, Yaubada yana dewa aitamoata deinake. Wayahina, aituhu aviyaivia Yaubada natunatuna, taui eha nau‑wawani Manua Vito‑pota a takesiV ivenevene. ");
INSERT INTO mvn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kate eha yau nuanua taui yaka dewa wayahina inua‑goyo. Wayahina, yaka takesiV evaniahei deina. Ataina tuta bani enꞌ‑epe, ena‑opu tania, ka avi iana naona etaini, ianana awana esi‑tanai, ka nihenina kinana enꞌ‑epei eomanei takesiV a tau vitue wayahia, evenei. Aina ana pata wamke yauke aka inua wayahika deina.” ");
INSERT INTO mvn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka auyewana wayahina Iesu a tau vi‑muni‑waiwai iomo wayahina, ivi‑tanaiei, ivona, “Kauvea, koiaka ana wava mani wava vane‑tawanei Yaubada ya pai veimea wahuma nihenina?” ");
INSERT INTO mvn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ka Iesu tevana kikituna aitam honei, e tevanina niwania vi‑au‑mini, ");
INSERT INTO mvn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","ka a tau vi‑muni‑waiwai vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia wayahimia yami nua‑opu, tevana taina deina, akanai itomi heta‑hoina Yaubada ya pai veimea nihenina. Iuna nau‑wawanimi unua‑vinana, ka unua‑opu tevana mwatutukui deina. Aituhu eha unua‑opu, eha ami pata una‑nu Yaubada ya pai veimea nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ka aituhu aviyaivia tevana taina deina inau‑kaiwei, iuna tevanana vitumahaneu, vona ahiahina, tomotaui kadu taua inau‑kaiweu deina. ");
INSERT INTO mvn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kate aituhu wamke evi‑tau vi‑peuna, akanai taum evidoha aituhu naona hanu ananina itana‑ipwe otom wayahina, e bebega ihaponem ena‑opu egavivina deina. Iuna aituhu aitam tevana taina deina vitumahaneu evo‑vi‑peui, ka aituhu apaina tevanana goyona dedewei, akanai munia, dewa‑yaiyai ananina evaniahei Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aioi! Aituhu mani tomotau goyona idedewei, ka aituhu iuna wamke yam dewa goyona, vona ahiahina, apaina dewa‑yaiyai ananina evaniahei. Eha aka pata dewa goyona aitamoata aitamoata kavito‑pote, kate aioi tau maꞌ tanopi wayahia, iuna taui inahe ananina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Wayahina, aituhu nimam, o aem vo‑vi‑peum edewa‑goyona, nau‑wawanim ena‑upwa‑ohoi, ka enꞌ‑one‑yavunei. Eha aitam aviani aituhu na nimam kukukuna, o penapenam yawai‑vavaha evaniahei. Kate aituhu na nimam, o na aem dewa goyona edewa‑nubunubui, apaina nima‑nuanuam, o ae‑nuanuam ai ananata‑vavaha nihenina ihaponem. ");
INSERT INTO mvn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kadu deina, aituhu matam vo‑vi‑peum edewa‑goyona, nau‑wawanim emoi‑yavunei. Eha aitam aviani aituhu na matam papani‑keana yawai‑vavaha evaniahei. Kate aituhu na matam goyona edewa‑nubunubui, apaina mata‑nuanuam ai ananata‑vavaha nihenina ihaponem. ");
INSERT INTO mvn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Eha aitam tevana taina deina utana‑wavini. Tuta habuhabuna tevana yai anelose wahuma imamaei, ka tuta tuta Amau matana idudueyei. ");
INSERT INTO mvn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Medeina unuanua? Aituhu aitam onoto yana sipiV ai yau 100, ka aituhu aitamoata wayahia ni‑pani, e maiova, onotona medeina yana dewa? Tauna 99‑naia oya bouni, e aitam maimaiovina na‑nenei, a? ");
INSERT INTO mvn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Memeanina nuami vi‑tupatupa, kate avonemi, tauna 99‑naia wayahi dewa‑haiawa, kate aituhu maimaiovina vaniahe‑havinei, apaina ya dewa‑haiawa wayahina ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka dewana deina, Amami wahuma ya nuanua eha aitam tevana taina deina na‑ni‑pani. ");
INSERT INTO mvn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ka aituhu vaneim vi‑goyom yana dewa goyona wayahina, wamke am heta nau‑wawanim enꞌ‑omo tauna ana heta wayahina, ka ami inua ya goyona evo‑vi‑mahetei. Aituhu tauna movim nononi, yawaina avaha vidoha Yaubada matana yam dewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kate aituhu tauna eha nuanuana movim na‑nononi, eni‑tawanei ena‑ne, e tomotau aitamoata o ainua kadu etaini nui, ka mataia vaneimna ya goyona evo‑vi‑mahetei. Ka itomi habuhabumi nau‑wawanimi Yaubada ya veimea taina uvi‑muniei, ivona, ‘Vitana matana wayahina, nau‑wawanimi tau hae ainua o aitonu mataia dewa habuhabuna uvo‑vi‑mahetei.’ ");
INSERT INTO mvn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka aituhu tauna eha nuanuana movimi na‑nononi, akanai uvona‑opuei tau ekalesia habuhabui wayahia. Ka aituhu tauna eha nuanuana kadue tau ekalesia habuhabui yai vona na‑nononi, akanai uvihahaiei. Tauna nau‑wawani na‑opu ekalesia wayahina, taui eha yai vitumahana deina o kadi takesiV a tau vitue deina. ");
INSERT INTO mvn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Memeanina nuami vi‑tupatupa, kate avonemi, unononi. Aituhu avi dewa tanopia uvito‑pote deina, avaha dewaia kadu wahuma vito‑potana. Ka kadue aituhu avi dewa tanopia uyavuhi, avaha dewaia kadu wahuma yavuyavuhina. ");
INSERT INTO mvn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Memeanina nuami vi‑tupatupa, kate avona‑havinemi, unononi. Aituhu aviyaivia ainua o aitonu wayahimia tanopia uawaeha aitam dewa wayahina, kadue aituhu dewana wayahina uviama Amau wahuma wayahina, akanai tauna yami viamana nꞌ‑awaehei. ");
INSERT INTO mvn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iuna aituhu avi papani tomotau ainua o aitonu au wavea inau‑hohona, iviama, yauke kadue nui amamaei.” ");
INSERT INTO mvn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ka viwavenena tanoi iakwa, e Pita omo Iesu wayahina, vi‑tanaiei, ivona, “Kauvea, aituhu tuta habuhabuna wayahina au niau vi‑goyou, ai vi‑am tuta wayahina nau‑wawaniu ya goyona anua‑piahi? Akanai tuta ai yau 7?” ");
INSERT INTO mvn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka Iesu vonei, ivona, “Eha. Tuta ai yau 7 eha ana pata, kate avonem tuta ai yau 490 deina. Iuna avi tuta tauna nua‑vinana, nau‑wawanim enua‑piahi. ");
INSERT INTO mvn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nau‑wawanim ededewei deina iuna Yaubada ya pai veimea pai dune taina deina. Aitam kiniV ya nuanua ya tau paisewa ai aga inau‑patei. ");
INSERT INTO mvn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wayahina kini‑nanaV vi‑putu, e tau paisewa aitam iomanei anꞌ aga talenita ai yau 10,000, ");
INSERT INTO mvn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ka onotona eha ana pata na‑nau‑pate. Wayahina, kini‑nanaV veimeyei onotona, tauna awana, natunatui nui kadue yai gugua habuhabui iaimwaneyei, e kini‑nanaV nau‑pata tupwana vaniahei deina. ");
INSERT INTO mvn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kate tau paisewana, ya nua‑vita kadu yanꞌ ate‑viviha nui, viama wayahina ivona, ‘Aioi! Kauvea, enꞌ‑ate‑nuanuaieu. Apaina au aga habuhabuna anau‑patam.’ ");
INSERT INTO mvn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Akaka kini‑nanaV ate‑nuanuaiei, e anꞌ aga habuhabuna nua‑piahi, e tau paisewa‑nana iopu. ");
INSERT INTO mvn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Iopu ka a niam aitam vaniahei, ka a niamna anꞌ aga wayahina mamaei, vivane 10 kina ana heta. Ka tau paisewa‑nana a niam otona vo‑vi‑avini, e veimeyei, ‘Ataina tuta am aga wayahiua enau‑patei.’ ");
INSERT INTO mvn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wayahina, a niamna ate‑viviha, e wayahina viama, ivona, ‘Aioi! Au niau, enꞌ‑ate‑nuanuaieu. Apaina au aga habuhabuna anau‑patam.’ ");
INSERT INTO mvn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kate tau paisewa‑nana a niamna ya viama vihahaiei, ka manua yohona nihenina boui, e veimeyei tenoke mamae a itoava anꞌ aga habuhabuna na‑nau‑patei. ");
INSERT INTO mvn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ka kini‑nanaV ya tau paisewa tupwai dewana idueyei, ka inua‑vita ananina wayahina. Akaka iomo yai kauvea wayahina, e imataedei. ");
INSERT INTO mvn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ka kini‑nanaV avaha vaneana nononi, ya tau paisewa‑nana hone‑havinei, omo, e vonei, ivona, ‘Wamke aitam tau paisewa goyo‑vainem! Wamke am aga ani‑vainena wayahiua anua‑piahi. Iuna eviameu, e ate‑nuanuaiem. ");
INSERT INTO mvn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wamke kadue nau‑wawanim am niamna enꞌ‑ate‑nuanuaie, e kadu anꞌ aga ena‑nua‑piahi deinake.’ ");
INSERT INTO mvn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ka kini‑nanaV nua‑goyo ananina. Wayahina, tauna a tau dune‑vi‑avina veimeyei manua yohona tau paisewa‑nana ivunuvunui a itoava anꞌ aga habuhabuna na‑nau‑pata‑yehai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Unononi ahiahina. Amau wahuma kadue dedeweyemi deina. Aituhu eha vavaneimi yai goyona wayahimia una‑nua‑piahi, apaina Amau eha yami goyona na‑nua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu ya viwavenena tanoi nau‑yehai, e papani Galili ini‑tawanei, e papani Iudea inui, e Daudau Ioridani iaubo‑tamani. ");
INSERT INTO mvn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ka yoko ananina Iesu ivi‑muni‑waiwaiei, ka tenoke tauna yai tau kwanakwanaha vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kadu Parisi tupwai iomo tauna wayahina, ka yai nuanua Iesu inau‑dadani yai vi‑tanai wayahina, e yai nuanua ya goyona ivaniahei deina. Ka ivi‑tanaiei, ivona, “Evoneai, Mosese ya veimea awaeheka aituhu yaka nuanua, akanai awawaka kavaiobuei, a?” ");
INSERT INTO mvn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Iesu ivona, “Itomi avaha Iginuma uanamanei o eha? Iginuma voneka vivane naona, ‘Yaubada tomotau vevewane‑neiei, vivane onotona kadu vavinena’ ");
INSERT INTO mvn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","kadu Yaubada ivona, ‘Wayahina, onoto nau‑wawani ayo‑amana na‑ni‑tawanei, ka awana tavinei, ka taui ainua akanai yoko vovouna, inini aitamoata.’ ");
INSERT INTO mvn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nonova ainua imaꞌ‑keyekeyei, ka ataina avaha aitamoata. Yaubada avaha yai tavine wayahina vi‑manueni. Wayahina, eha aitam tomotau nau‑wawani yai tavine na‑tana‑vewani.” ");
INSERT INTO mvn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wayahina ivi‑tanaiei, ivona, “Aituhu yam vonana tunuhina, aviani wayahina Mosese awaeheka onoto nau‑wawani naona vaiobu ana leta awana venei, e munia akanai vihahaiei, vi‑tunei, e yai tavine vꞌ‑iakwani deinake?” ");
INSERT INTO mvn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Iesu ivona, “Mosese awaehemi deina, iuna tepami toyoina, kadu eha yami nuanua Yaubada yana vona uvi‑ateteye. Kate tuta naona wayahina, eha Yaubada ya nuanua awawami uvaiobue. Tauna ya nuanua vivane aituhu utavine, akanai umamaei deina. ");
INSERT INTO mvn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wayahina, ataina yauke awaehemi awawami uvaiobuei, iuna aitamoata wayahina, vivane kenene ana heta. Kate aituhu awami eha ita‑kenene, ka aituhu evaiobuei, kadu aituhu etavine‑tamane, wamke avaha evi‑tau kenekenene.” ");
INSERT INTO mvn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka a tau vi‑muni‑waiwai inau‑patei, ivona, “Aituhu onoto awana ai veimea vitana deina, dewa tavine eha ahiahina, kadue tubuao imamaei akanai.” ");
INSERT INTO mvn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ka Iesu ivona, “Tomotau habuhabui eha ai pata viwavenena tanoi iawaehe tunuhina, idewedewe. Ka aituhu aviyaivia ai pata, akanai taui iawaehei vonana vona ahiahina kadu ivi‑ateteyei. ");
INSERT INTO mvn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Onoto tupwai yai tupua wayahina eha ai pata itavine, iuna ivi‑tau poapoana. Ka onoto tupwai apaina ivi‑tau poapoana, ka eha ai pata itavine, iuna mani onoto dabai. Kadue onoto tupwai yai nuanua tavine ivihahaiei Yaubada ya pai veimea wayahina. Ka aituhu aviyaivia ai pata viwavenena tanoi iawaehei, ivi‑ateteyei, akanai yawai ividoha deina.” ");
INSERT INTO mvn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ka munia, tupwai tomotau iomomo, e yaheyahe iomaomanei Iesu wayahina. Ka yai nuanua tauna nimana bouni, nau‑iaiavei, ka kadu viama wayahi Yaubada wayahina. Kate Iesu a tau vi‑muni‑waiwai avaha tomotaui idudueyei, ivihahaiei, ivito‑potai. ");
INSERT INTO mvn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Akaka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Eha yaheyahe uvito‑potai deina, kate nau‑wawanimi uawaehei wayahiua iomomo. Iuna Yaubada ya nuanua yaheyahe taina deina wayahi vivane taui ya pai veimea wahuma inuinu.” ");
INSERT INTO mvn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wayahina, Iesu yaheyahe‑naia nimana bouni, nau‑iaiavai. Iakwa, papani‑nana ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ka tupunaina aitam omo Iesu wayahina, ka ivona, “Tau Viwavenena, yau nuanua yawai‑vavaha avaniahei. Wayahina, avi dewa ahiahina nau‑wawaniu adewei avaniahei?” ");
INSERT INTO mvn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka Iesu ivona, “Aviani wayahina dewa ahiahina wayahina evi‑tanatanaieu? Iuna, aitamoata mamaei, ka Tauna ana heta ahiahina. Aituhu yam nuanua yawai‑vavaha evaniahei, akanai Yaubada ya veimea evi‑ateteyei.” ");
INSERT INTO mvn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka tupunaina vi‑tanaiei, ivona, “Avi veimea?” Ka Iesu vona‑nau‑patei, ivona, “‘Eha enau‑vi‑aniga, eha ekenene, eha evainau, eha evitupu, ");
INSERT INTO mvn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ka amam ka ayom evi‑ateteyei’ ka kadue, ‘yaiam edewa‑vidovidohei taum edewa‑vidovidohem deina.’” ");
INSERT INTO mvn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka tupunaina ivona, “Nonova a itoava ataina wayahina veimeaia habuhabui avi‑muniei ahiahina. Ka aviani kadue nau‑wawaniu adewei?” ");
INSERT INTO mvn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka Iesu ivona, “Aituhu nuanuam yam dewa habuhabuna tunutunuhina Yaubada matana, akanai nau‑wawanim emavina yam megeia, e yam gugua habuhabuna eimwaneyei, e ai nau‑pata tau payapayaya evo‑pata‑neiei. Na‑iakwa, emavi‑havine evi‑munieu. Aituhu edewei deinake, apaina am nau‑pata ahiahina wahuma evaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka tupunaina, avaha Iesu ya vonana nononi, ya nua‑vita nui ni‑tawanei. Iuna tauna avaha tau kaikaiwabo tanopia, ka ya gugua habuhabuna nua‑tania, ka eha ya nuanua nꞌ‑am‑venena‑kavovo. ");
INSERT INTO mvn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wayahina, Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, tau kaikaiwabo yai nui Yaubada ya pai veimea wahuma nihenina vita‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka kadue avonemi, vahitau kameliV yai nui haima matana vitana, kate tau kaikaiwaboi yai nui Yaubada ya pai veimea wahuma vita‑vainena.” ");
INSERT INTO mvn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka Iesu a tau vi‑muni‑waiwai ya vonana inononi, ka nuai venau‑tupatupa ani‑vainena. Wayahina taui ivona, “Aioi! Aituhu tau kaikaiwaboi wayahi deina, medeina mani tomotau ito‑yavuha ivaniahe?” ");
INSERT INTO mvn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ka Iesu dunedune wayahia, ka ivona, “Tomotau ai heta eha ai pata ito‑yavuha ivaniahe. Kate aituhu Yaubada ya bagibagi mamaei wayahi, dewa habuhabuna memeanina.” ");
INSERT INTO mvn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wayahina, Pita vi‑tanaiei, ivona, “Kauvea, itoai medeina? Iuna avaha yama gugua habuhabui ani‑tawanei, e avi‑muni‑waiwaiem?” ");
INSERT INTO mvn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Iesu habuhabui vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, ami nau‑pata potapotami. Apaina auyewana wayahina, tanopi vovouna wayahina, yauke, Tauna Vi‑tomotau, didigau nui yau pai manuena ahihi‑vainena hetana amanuena, ka itomi au tau vi‑muni‑waiwai kadue yami pai manuena ahiahina ai yau 12 hetaia umanuena, e me Isiraeli yai yoko ai yau 12 una‑nau‑yanahi. ");
INSERT INTO mvn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka eha itomi ami heta. Ka tuta tepakaia, aituhu aviyaivia yai manua, o vavanei, o novunovui, o amamai, o ayoyoi, o natunatui, o yai tano ini‑tawanei, iuna yai nuanua ananina ivi‑muni‑waiwaieu, akanai, taui ai nau‑pata a vo‑vi‑tupana 100 ivaniahei deina, kadue yawai‑vavaha nui ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kate taui habuhabui ataina tuta wayahina ai wava anani tanopia, apaina ai wava kikitui wahuma. Ka taui habuhabui ataina tuta wayahina ai wava kikitui tanopia, apaina ai wava anani wahuma.” ");
INSERT INTO mvn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ka Iesu avaha ya vonana ipuipupuei, e vo‑vi‑mahetei vona tana‑minikuna aitam wayahina, ivona, “Yaubada ya pai veimea wahuma aitam tau vi‑baguna wainaV deina, ka aitam auyewa mata‑hamwahamwanina wayahina mini, omo megeia, e tau paisewa wayahia naunau‑nene, ya baguna ipaisewei. ");
INSERT INTO mvn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ka avaha tupwai vaniahai, nui iawaehei ai nau‑pata auyewana wayahina vivane kina aitamoata. Ipupu iakwa, e vi‑tune‑neiei inei ya baguna, ivi‑putu ipaipaisewa. ");
INSERT INTO mvn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ka babau avaha ivane mana‑putu a niwanina wayahina, e tau vi‑bagunana omo‑havine meagai‑nana wayahina, e kadu tomotau tupwai vaniahai maketia imaꞌ‑kavokavovo. ");
INSERT INTO mvn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wayahina, hone‑neiei, ivona, ‘Itomi kadue una‑nei yau baguna, e upaisewa. Ka apaiku yami paisewa a nau‑pata tunuhina avenemi.’ Akaka iawaehei ine ya baguna wayahina, e taui kadue ivi‑putu ipaipaisewa. ");
INSERT INTO mvn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka auyewa pouna wayahina, ka kadu vinanavi wayahina, tau vi‑bagunana yana dewa aitamoata deina, ka tomotau tupwai vaniahai, e vi‑tune‑neiei inei ya baguna ipaipaisewa. ");
INSERT INTO mvn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka pai nau‑yehata wayahina, eha ani‑hoina babau na‑onu, tauna omo‑havine megeia, e tomotau tupwai vaniahai, e vi‑tanaiei, ivona, ‘Aviani wayahina auyewa habuhabuna umaꞌ‑kavokavovo?’ ");
INSERT INTO mvn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka taui ivona, ‘Eha aitam koiaka ta‑honeai, nꞌ‑awaeheai apaisewa.’ Ka tau vi‑bagunana ivona, ‘Itomi kadu una‑nei yau baguna, upaisewa.’ ");
INSERT INTO mvn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Akaka, babau onuonu ana tuta wayahina, tau vi‑bagunana tauna a tau dune‑vi‑avina honei, ivona, ‘Tau paisewa habuhabui ehone‑neiei, e ai nau‑pata evenei. Taui vovoui wayahia evi‑putu, e naona taui ai nau‑pata evenei. Ka edewei deina a itoava taui mata‑hamwahamwanina ivi‑putu evaniahei wayahina, e pai nau‑yehata taui ai nau‑pata evenei.’ ");
INSERT INTO mvn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ka taui vinanavi ana heta wayahina ipaisewa iomo, e aitamoata aitamoata wayahia a nau‑pata kina aitamoata epei. ");
INSERT INTO mvn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka munia, habuhabui iomo, e aitamoata aitamoata wayahia a nau‑pata kina aitamoata epei deina. Ka pai nau‑yehata wayahina, taui naona ivi‑putu iomo. Ka taui inuanua nau‑wawani ai nau‑pata ananina, iuna yai paisewa tuta mamanaina wayahina. Kate taui kadue kina aitamoata ivaniahei yaiai habuhabui deina. ");
INSERT INTO mvn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wayahina, avaha yai kina iepei, taui tau vi‑bagunana wayahina inau‑vonuvonu. ");
INSERT INTO mvn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","E ivonavona, ‘Ia! Taui vovoui yai paisewa ana tuta vivane babau aitamoata, kate itoai yama paisewa ana tuta mamanaina wayahina. Ika, auyewa habuhabuna babau nihenina apaipaisewa, ka wamke avaha ai nau‑pata evenei itoai aitamoata deina. Yam dewana eha tunuhina!’ ");
INSERT INTO mvn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka tau vi‑bagunana aitam wayahia vonei, ivona, ‘Au niau, yau dewana vivane tunuhina. Enuani. Yaka awaeha medeina? Kawaehei yam paisewa ataina wayahina a nau‑pata vivane kina aitamoata, a? ");
INSERT INTO mvn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wayahina, yam kina taina enꞌ‑epei, ena‑ne. Yauke yau nuanua vivane taui vovoui ai nau‑pata avenei wamke am nau‑pata aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Edu! Yau kina habuhabuna aveimeyei. Aituhu yau nuanua anau‑patai deina, dewana eha aitam aviani wayahima, a? O medeina? Avaha yau am‑venena awawaehina tomotau wayahia edueyei, ka evi‑bwanou, a?’” ");
INSERT INTO mvn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Vona tana‑minikuna tanoi iakwa, e Iesu vonei, ivona, “Wayahina, avona‑havinemi, taui habuhabui ataina tuta wayahina ai wava anani tanopia, apaina ai wava kikitui wahuma, ka taui habuhabui ataina tuta wayahina ai wava kikitui tanopia, apaina ai wava anani wahuma.” ");
INSERT INTO mvn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka munia, Iesu tauna a tau vi‑muni‑waiwai nui ivanevane Ierusalem wayahina etawana, ka Iesu taui ai yau 12 hone‑hohoni etawana wayahina vivane taui ai heta, e vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ataina tuta kavanevane Ierusalem wayahina. Ka apaina yauke, Tauna Vi‑tomotau, au tau vi‑nua‑hauhau vi‑nua‑hauhaueu tau vi‑nomu mata‑genai wayahia, ka veimea a tau viwavenena wayahia. Ka munia, taui iveimeyeu anꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ka taui ineieu me Rom wayahia, e me Rom ivi‑waipoeu, e yavunaia imoamoaniu, e ai nahenahea itutu‑pwatau, anꞌ‑aniga. Ka auyewa aitonu na‑iakwa, Yaubada na‑si‑vi‑mini‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ipupu tanoi iakwa, e Sebedi awana natunatui ainua nui iomo, e ayoi Iesu wayahina ivi‑tupa‑gum ka ivona, “Yama nuanua aitam mamaei.” ");
INSERT INTO mvn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka Iesu ivona, “Aviani nuanuami?” Ka vavine‑nana ivona, “Apaina, avi tuta evi‑tau veimea, taum yam pai manuena ahihi‑vainena emanueni. Ka ataina nuanuai natunatuai eawaehei nepema imanuena, aitam ateima, aitam akenima, e ai wava ananina deinake, wamke am wava ananina deina.” ");
INSERT INTO mvn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wayahina, Iesu ononotoi vonei, ivona, “Itomi eha yami viamana anꞌ anamana utꞌ‑anamane. Apaina viha ana vei wayahina ana‑nim, ka inahe ananina avaniahei. Itomi medeina? Memeanina itomi kadu vei‑nana wayahina inahe una‑nim?” Ka ivona, “Ama pata.” ");
INSERT INTO mvn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka Iesu ivona, “Vona ahiahina, nau‑wawanimi vei‑nana wayahina inahe una‑nim. Ka eha nau‑wawaniu taui apaina yau pai veimea nihenina ateiua ka akeniua imanuena avi‑nua‑dadanei. Iuna Amau wahuma ana heta avaha pai vi‑ai‑naia vo‑vi‑aiaia, kadu avaha tomotaui vi‑nua‑dadanei.” ");
INSERT INTO mvn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka mani tau vi‑muni‑waiwai ai yau 10 avaha Iamesa ka taina Ioni yai viamana tanoi inononi, inua‑goyoei. ");
INSERT INTO mvn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wayahina, Iesu habuhabui hone‑hohoni, e vonei, ivona, “Itomi uanamanei kauvea tanopia taui yai tomotau iveimeyei yai bagibagi wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kate itomi eha nau‑wawanimi taui deina udedewe. Aituhu koiaka wayahimia nuanuana anꞌ anamana na‑nata, tauna nau‑wawani naona na‑nua‑opu, e yaiana wayahi vi‑tau paisewa. ");
INSERT INTO mvn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ka kadu aituhu koiaka wayahimia nuanuana vi‑tau eta‑naonao wayahimia, tauna nau‑wawani naona yaiana wayahi vi‑tau paisewa‑kavokavovo ");
INSERT INTO mvn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","yauke, Tauna Vi‑tomotau, deina. Yauke aomo tanopia, iuna yau nuanua avi‑tau paisewa tomotau habuhabumi wayahimi. Eha yau nuanua tomotau ivi‑tau paisewa wayahiu. Itomi nau‑wawanimi yami goyona wayahi Yaubada unau‑pate, kate eha ami pata. Wayahina, yauke awaehei avi‑tau nau‑seana itomi wayahimi kadu mani tomotau habuhabui wayahi, kadu anꞌ‑aniga tomotau habuhabui ai ito‑yavuha wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Vonana iakwa, e Iesu tauna a tau vi‑muni‑waiwai nui meagai Ieriko ini‑tawanei, ivenavenau, ka yoko ananina Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka tau mata‑goyogoyo ainua etawana nepena imanuena, ka avaha Iesu ya tutu‑vivina vaneana inononi, e Iesu wayahina ivi‑putu ivi‑honehone movi ananina wayahina, “Kauvea, Davida wana, edune‑nuanuaieai!” ");
INSERT INTO mvn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka yoko imimini ononotoi ainua awaniaia iapa‑goyogoyoei, ivito‑potepotei, ivona, “Ia! Ami inua ugenuana! Akanai vi‑hone!” Kate ainuaia movi ani‑vainena wayahina ivi‑hone‑havihavine, ivonavona, “Kauvea, Davida wana, edune‑nuanuaieai!” ");
INSERT INTO mvn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wayahina, Iesu mini, e ainuaia honei, ivona, “Aviani nuanuami wayahimi adewei?” ");
INSERT INTO mvn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka ivona, “Kauvea, memeanina matai edewa‑vidovidohei, adunedune?” ");
INSERT INTO mvn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Iesu ate‑nuanuaiei, e matai vo‑dadani. Ka vo‑kwayavonina ividoha, idunedune, ka taui kadu ivi‑putu Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ka Iesu yokoia nui ivanevane Ierusalem wayahina, ka iomomo meagai Betepage wayahina, meagaina Oya Olive baimina. Ka Iesu tauna a tau vi‑muni‑waiwai ainua vi‑nua‑dadanei, e vi‑tunei, ieta‑naoi. ");
INSERT INTO mvn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ka vonei, ivona, “Ami inua una‑ne tunutunuhimi megeia, ka aitam aseV udueyei ai wayahina itana‑ipwei, natui ayona ainua imamaei. Ainua uyavuhi, uomanei wayahiua. ");
INSERT INTO mvn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aituhu aitam koiaka vi‑tanaiemi yami dewana wayahina, uvona‑nau‑patei, ‘Kauvea ya nuanua,’ e vo‑kwayavonina nꞌ‑awaehemi unꞌ‑omanei.” ");
INSERT INTO mvn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dewana vinꞌ‑omo, iuna nonova tau apa‑taputapu mai‑voneka deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sioni natuna vavinena, vivane tau maꞌ Ierusalem, umataedai, una‑vona, ‘Udueyei! Yami kiniV omomo wayahimia, ka tauna tau nua‑opu, ka vahitau hetana vi‑ata. Ka kadu a pai vi‑ata nua‑opuna, vahitauna aitam aseV natui.’” ");
INSERT INTO mvn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka a tau vi‑muni‑waiwai ainua ine, e yana vona ivi‑ateteyei. ");
INSERT INTO mvn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","E vahitau‑nana na natui ivaniahei, e iomanei. Ka ai pai bwaꞌ badobadona wayahina vahitau waui iyaveni, akaka Iesu manuena, vi‑ata. ");
INSERT INTO mvn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ka yoko ani‑vainena kadue ai kwama wayahina etawana iyaveni, ka tupwai tomotau ai nahanahai na yawayawai itana‑guyeguyei etawana a vaivana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ka yokoia tupwai Iesu ieta‑naoei, ka tupwai ivi‑muniei, e habuhabui iawa‑davadava, ka ivi‑honehone, ivonavona, “Davida natuna, awa‑davem. Eito‑yavuhiai!” “Kaiwa ananina wayahima! Kauvea a wavea eomomoi!” “Kaiwa ananina Tauna Heta‑hoina wahuma wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ka tutana Iesu inu Ierusalem wayahina, tau vi‑meagai habuhabui nuai venau‑tamatamana, ka matataui ivi‑tanatanai, ivonavona, “Koiaka tauna?” ");
INSERT INTO mvn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka yokoia ivona‑nau‑patei, “Tauna tau apa‑taputapu ana wava Iesu, ka meagai Nasareta wayahina papani Galili nihenina omo baina.” ");
INSERT INTO mvn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ka Iesu inu Manua Vito‑pota nihenina, e tau aimwane habuhabui, ka tau vi‑maiena habuhabui vo‑tahoi ini‑ubaubau, ka kina a tau si‑vi‑tamatamana yai tana‑pwaina vi‑kabubui, ka bunebune ai tau aimwane yai pai maꞌ va‑bwegebwegei, ");
INSERT INTO mvn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","e vonei, ivona, “Iginuma nihenina ivona, ‘Yau manua ivi‑wahani “Viama A Manua” ’ kate itomi uvo‑vinei ka ataina vivane ‘vainau a manua.’” ");
INSERT INTO mvn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka tau mata‑goyogoyona ka tau kopekope iomo Iesu wayahina Manua Vito‑pota nihenina, e tauna vo‑vi‑aiaiei, ividoha. ");
INSERT INTO mvn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kate tau vi‑nomu mata‑genai, ka veimea a tau viwavenena Iesu ya dewa‑bagibagi paipaisewa idudueyei, kadu yaheyahe movi inononi. Yaheyahe Iesu wayahina ivi‑honehone Manua Vito‑pota nihenina, ivonavona, “Davida natuna, eito‑yavuhiai”. Wayahina, tau vi‑nomu mata‑genai, ka veimea a tau viwavenena inua‑goyoei. Iuna eha ita‑vitumahane, ka inuanua yaheyahe yai vonana vivane vitupu. ");
INSERT INTO mvn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Akaka taui Iesu wayahina ivona, “Yaheyahe taina yai vona enononi?” Ka Iesu ivona, “Ika. Avaha anononi. Kate itomi medeina? Kaiwadi, Iginuma ana vona nuami ipani, a? Vivane ivona, ‘Yaheyahe mwatutukui awaia am awa‑dava ahiahina evaniahei.’” ");
INSERT INTO mvn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ka Iesu ni‑tawanei, iopu Ierusalem wayahina, e omo meagai Betani wayahina, e dauva ioyoma. ");
INSERT INTO mvn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mana navia, mana‑putua, Iesu mini, ka mavi‑havine Ierusalem wayahina, ka am navovo. ");
INSERT INTO mvn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka etawana nepena ai ana dune madaiba deina na yawaina dueyei, e omo wayahina. Kate eha aitam uana ta‑dueye, yawaina ana noe mamaei. Ka Iesu ai‑nana wayahina ivona, “Tuta omomo, eha ena‑ua‑havine.” Ka ya bwanata iakwa, e ai‑nana yawaina habuhabui inau‑moewa. ");
INSERT INTO mvn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ka Iesu a tau vi‑muni‑waiwai ai‑nana idueyei, ka nuai vi‑tupatupa, e taui ivi‑tanaiei, ivona, “Medeina edewei, e vo‑kwayavonina ai‑nana avaha nau‑putu ipwavu deina?” ");
INSERT INTO mvn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Iesu vonei, “Memeanina nuami vi‑tupatupa, kate avonemi, aituhu yami vitumahana nui, ka aituhu eha uva‑hamwahamwana, dewa tanoi ai‑nana wayahina avevewanei ataina vivane dewa kikituna. Itomi kadue ami pata uvevewanei deina. Kadue aituhu yami vitumahana nui, itomi ami pata oya tanoi uveimeyei, una‑vona, ‘Ena‑opu hawana,’ e oyana vi‑ateteyemi. ");
INSERT INTO mvn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aituhu yami vitumahana nui Yaubada wayahina uviama, apaina aviani uviama wayahina uvaniahei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ka Iesu mavina omo Manua Vito‑pota wayahina, ka vi‑putu viwavenena, ka tau vi‑nomu mata‑genai, ka tau eta‑naonao iomo wayahina, e ivi‑tanaiei, ivona, “Koiaka ana wava ananina awaehem yam dewa taina ededewei? Kadu koiaka yam bagibagi venem?” ");
INSERT INTO mvn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka Iesu vonei, ivona, “Naona amai‑vi‑tanaiemi, ka aituhu unau‑patau, akanai, yauke kadue amataedami au veimea wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yau vi‑tanai taina. Koiaka ana wava ananina Ioni Tau Bapitaiso awaehei tauna tomotau vi‑bapitaisoei? Kadi Yaubada o tomotau?” Ka taui matataui ivitana‑heyoheyo, ivonavona, “Medeina ya vi‑tanai tanoi kanau‑pate? Aituhu kana‑vona, ‘Yaubada wayahina’, apaina tauna vi‑tanai‑havineka, na‑vona, ‘Aituhu deina, aviani wayahina Ioni ya nau‑wahena eha uta‑vitumahane?’ ");
INSERT INTO mvn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kate aituhu kana‑vona, ‘Tomotau wayahia’, akanai yokoia inononi, e apaina ivunuka, iuna taui habuhabui iawaehei Ioni aitam tau apa‑taputapu Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wayahina, Iesu ya vi‑tanai tanoi eha ita‑nau‑pata‑vidohe, ka ivona, “Kaiwadi, itoai eha atꞌ‑anamane.” Akaka tauna vonei, ivona, “Wayahina, eha yau nuanua amataedami koiaka awaeheu dewaia adedewei. ");
INSERT INTO mvn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kate vona tana‑minikuna taina unononi, e avi‑tanaiemi. Onoto aitam natunatuna ainua ononotoi imamaei. Ka aitam auyewa onoto‑nana mai‑tupuina wayahina ivona, ‘Natu, ataina ena‑ne yaka baguna, e epaisewa.’ ");
INSERT INTO mvn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ka mai‑tupuina ivona, ‘Eha yau nuanua. Yauke ikoi.’ Kate munia nua‑vinana, e ine baguna, e paisewei. ");
INSERT INTO mvn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Munia onoto‑nana natuna vꞌ‑inuana kadue vonei deina, ivona, ‘Natu, ataina ena‑ne yaka baguna, e epaisewa.’ Ka vꞌ‑inuana ivona, ‘O, ahiahina. Apaina ana‑ne.’ Kate eha ta‑ne. ");
INSERT INTO mvn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ka ataina avi‑tanaiemi, natunatuna ainua wayahia, koiaka amana ya nuanua dewei?” Ka ivona, “Unu‑tauna.” Wayahina, Iesu vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, unononi. Tau goyogoyona, ka takesiV a tau vitue, ka kenene a tau aimwane, kadue mani tomotau goyona deina inuinu Yaubada ya pai veimea nihenina, kate itomi eha. ");
INSERT INTO mvn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iuna nonova, Ioni etawana tunuhina viwavenemi, kate itomi eha uta‑vitumahane. Takesi a tau vitue, kadue kenene a tau aimwane ivitumahanei. Ka matamia taui yai nua‑vinana udueyei, kate dewana eha ana pata wayahimi. Itomi eha ya nau‑wahena uta‑vitumahane, kadu eha uta‑nua‑vinana. ");
INSERT INTO mvn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Uvanevaneneha, e kadu aitam vona tana‑minikuna wayahina avonemi. Aitam tau vi‑tano baguna wainaV baguni yana tano nihenina, e tutu‑gani‑vivini, e wainaV a pai pipi kadue nau‑vevewanei nihenina, kadu pai dune‑vi‑avina a manua mamanaina baguna nihenina yonei. Iakwa, e tau dune‑vi‑avina tupwai nui iawaehei bagunana idune‑vi‑avini, ka aihana ana tuta wayahina taui ai vo‑pata ivaniahei, kadu tau vi‑tano tauna a vo‑pata ivenei. Iuna tauna ya baguna. Ka tau vi‑tano‑nana tauya ine mani meagai tupwana bana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ka aihana ana tuta vinꞌ‑omo, e tau vi‑tano‑nana ya tau paisewa tupwai vi‑tunei imavina, ya nuanua vivane wainaV uana iepei bagunana a tau dune‑vi‑avina wayahia, vivane a vo‑pata. ");
INSERT INTO mvn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kate tau dune‑vi‑avina‑naia ya tau paisewa ipoyꞌ‑avini. Ka aitam ivunui, ka vꞌ‑inuana inau‑vi‑anigi, ka vꞌ‑itonuna itutu‑hanuhanui. ");
INSERT INTO mvn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Munia tau vi‑tano‑nana mani tau paisewa vi‑tunei, ine wayahia, ka tau paisewaia ai yau habuhabui. Kate tau dune‑vi‑avina‑naia yai dewa aitamoata, vivane habuhabui ivunu‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka tuta pai nau‑yehata wayahina natuna onotona vi‑tunei ine wayahia. Ka tau vi‑tano‑nana ana heta wayahina vonavona, ‘Akanai, natu ivi‑ateteyei.’ ");
INSERT INTO mvn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ka natu‑nana omomo, e aitam tau dune‑vi‑avina wayahia ivona, ‘Yaiau, aina natuna aitamoata‑hoina kavunui! Na‑iakwa, itoka tauna yana gabu kaveimeyei, a?’ ");
INSERT INTO mvn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wayahina ipoyꞌ‑avini baguna nihenina, e itaini iopu inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ka yau vi‑tanai wayahimia taina. Avi tuta tau vi‑tano‑nana na‑mavi‑havine yana tano wayahina, medeina yana dewa tau dune‑vi‑avina‑naia wayahia?” ");
INSERT INTO mvn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka tau vi‑nomu mata‑genai, ka tau eta‑naonao ivona, “Tauna nau‑wawani tau goyogoyo‑naia na‑nau‑vi‑anigi dewa‑yaiyai ananina wayahina. Iakwa, e tau dune‑vi‑avina vovoui kadu ahiahi vaniahei, e apaina aihana ana tuta wayahina taui a nau‑pata ivenei tunuhina, avaha iawaehei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","E Iesu kadue vonei, ivona, “Ika, deinake. Kate medeina itomi mwagemwagemi? Kaiwadi Iginuma ana vona taina Tau Ito‑yavuha‑nana wayahina eha uta‑nua‑vi‑avini? Ivona, ‘Ohonana nonova manua a tau yona ivihahaiei, ka ataina tuta wayahina mimini, ka avaha vi‑ohona naona, kadue tauna ohona habuhabuna bagibagi‑tawanei, e veimeyei.’ ‘Dewana Kauvea ya paisewa, kadu matakaia ahihi‑vainena.’ ");
INSERT INTO mvn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wayahina, avonemi, tuta naona Yaubada ya pai veimea wayahimia mamaei. Kate tauna ya pai veimea nꞌ‑epei wayahimia, ka nꞌ‑am‑veneneyei mani tomotau wayahia. Iuna taui ya pai veimea uana ahiahina iuaua. ");
INSERT INTO mvn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aituhu aviyaivia ina‑peu ohona taina hetana, apaina idobwedobwe‑neiei. Kate aituhu ohonana na‑peu tomotau hetaia, akanai ohonana na‑mukumukui.” ");
INSERT INTO mvn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ka tau vi‑nomu mata‑genai, ka Parisi nui Iesu ya vona tana‑minikuna tanoi inononi, ka avaha ianamanei tau dune‑vi‑avina‑naia goyogoyoi viviwavea vivane taui. Wayahina, inua‑goyoei. ");
INSERT INTO mvn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","E taui yai nuanua Iesu ipoyꞌ‑avini, kate eha ita‑dewe. Iuna yokoia ivitumahanei Iesu tau apa‑taputapu aitam, ka iawa‑vidovidohei. Wayahina, tau vi‑nomu kadu Parisi yokoia imatamatautei. ");
INSERT INTO mvn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu kadu aitam vona tana‑minikuna wayahina tomotau ipupuei. ");
INSERT INTO mvn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ivona, “Yaubada ya pai veimea taina deina. Aitam kiniV mamaei, ka natuna onotona anianina nau‑vevewanei ya tavine wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka kini‑nanaV tauna ya tau paisewa vi‑tune‑neiei, ine aviyaivia ya nuanua mataedai vi‑aniani wayahina. E ya tau paisewa itauya iomo tomotau‑naia wayahia, kate tomotaui, avaha kini‑nanaV ya tuyeha inononi, didikuna ivihahaiei. ");
INSERT INTO mvn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka kini‑nanaV, avaha yai dewaia anamanei, tau paisewa tupwai kadu vi‑tunei, ine, e imataedai havine deina. ‘Yami kiniV anꞌ aniani avaha vo‑vi‑aiaia, potapotami, kadu ya bulumakauV anani ka bulumakauV binabinai avaha vunu‑neiei, ka vahitau habuhabuna deina. Ka tauna vonevonemi, “Unꞌ‑omo natu ya tavine anianina wayahina, kanꞌ‑am, e kadewa‑haiawa.” ’ ");
INSERT INTO mvn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kate tomotaui kadu mataedana ivihahaiei, eha itꞌ‑omo. Ka tupwai imaꞌ‑kavokavovo, ka tupwai ine yai baguna wayahia, kadu tupwai mani paisewa idedewei, aviani taui yai nuanua. ");
INSERT INTO mvn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka tomotaui tupwai kini‑nanaV ya tau paisewa ipoyꞌ‑avini, ivunu‑neiei, inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka tutana kini‑nanaV dewaia tanoi vaneana nononi, tauna nua‑goyo ani‑vainena, ka ya tau nau‑havia vi‑tune‑neiei ine, e taui tau nau‑vi‑aniga‑naia imutu‑neiei, ka yai meagai itunu‑anai akanai. ");
INSERT INTO mvn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ka kini‑nanaV ya tau paisewa honei iomo, e vonei, ivona, ‘Tavine anianina avaha vo‑vi‑aiaina mamaei, kate tomotau‑naia naona amataedai, taui eha nau‑wawani inꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wayahina, uneine etawana wayahia, ka avi tomotau uvaniahai uvonei inꞌ‑omo tavine anianina wayahina, inꞌ‑ania.’ ");
INSERT INTO mvn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E tau paisewa‑naia ine tomotau habuhabui ivaniahai, ivahautei, tupwai goyogoyoi, ka tupwai ahiahi. Ka tavine a manua ivi‑nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ka kini‑nanaV omo manuana, inui, e ya nuanua tau bwanibwani dudueyei. Ka tauna onoto aitam dueyei, ka onotona eha tavine kwamana ta‑weteni. ");
INSERT INTO mvn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wayahina kini‑nanaV vi‑tanaiei, ivona, ‘Au niau, tavine kwamana eha eta‑weteni, wayahina koiaka awaehem baina enu‑mei?’ Ka onoto‑nana matauta nui eha ana pata kini‑nanaV ya vi‑tanai na‑nau‑pate. ");
INSERT INTO mvn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wayahina, kini‑nanaV tauna ya tau paisewa vonei, ivona, ‘Onoto taina upoyꞌ‑avini, e nimana ka aena uyohoyohoni, e uhaponei na‑opu novanovana nihenina, e tanoi wayahina na‑tou, na‑nua‑vita inahe wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Unononi. Tomotau habuhabui Yaubada ya mataeda inononi, kate ai vi‑am wayahia nau‑wawani tauna vi‑nua‑dadanei? Eha habuhabui.” ");
INSERT INTO mvn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ka Parisi ine, e yai vi‑nua‑hauhau ivo‑vi‑aiaia medeina Iesu ipoyꞌ‑avini, ka ivona, “Kavi‑tanatanaiei, ka ya nau‑pata nihenina ya goyona kavaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ka taui wayahia ai tau vi‑muni‑waiwai tupwai ivi‑nua‑dadanei, kadue Erodi yaiana nui ivi‑tunei iomo Iesu wayahina, e ivona, “Tau Viwavenena, avaha anamanem wamke ahiahim, kadu wamke Yaubada ya nuanua eviwavenei tunutunuhina tomotau wayahia. Kadue wamke eha tomotau yai nuanua wayahina eta‑matamatauta, iuna taui ai wava anani eha aitam aviani wayahima. ");
INSERT INTO mvn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wayahina, yama vi‑tanai taina enau‑pata wayahiai. Nau‑wawanika SisaV wayahina takesiV kaboui o eha?” ");
INSERT INTO mvn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka Iesu avaha yai nua‑goyo anamanei, wayahina ivona, “Itomi tau vitupu. Aviani wayahina udewa‑dadana unau‑daeu? ");
INSERT INTO mvn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akanai, aitam kina takesinaV wayahina uomanei wayahiua adueyei.” Ka kinana aitamoata iepe, ivenei dueyei. ");
INSERT INTO mvn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kadu Iesu vonei, ivona, “Kina taina hetana, koiaka mayamayauna iginumi mamaei, ka koiaka ana wava iginumi mamaei?” ");
INSERT INTO mvn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka ivona, “SisaV.” Ka Iesu nau‑patei, ivona, “Deina. Wayahina, aituhu aviani SisaV ya gugua, akanai SisaV uvenevenei, ka aituhu aviani Yaubada ya gugua, akanai Yaubada uvenevenei.” ");
INSERT INTO mvn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ka Iesu yana vona na nua‑uyana inononi, wayahina nuai venau‑tamatamana, ka ini‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka auyewana wayahina, tupwai Sadusi iomo Iesu wayahina. Taui eha mini‑havine ita‑vitumahane, kate mini‑havine wayahina ivi‑tanaiei, ");
INSERT INTO mvn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ivona, “Tau Viwavenena, Mosese ivona aituhu onoto awana ka eha natunatui, ka aituhu onoto‑nana aniga, munia wadaena nau‑wawani namoiana tavine, e aituhu vavinena vi‑natuna, tevanina vivane onoto aninigana natuna. ");
INSERT INTO mvn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ka aitam onoto vavaneina ai yau 6 nui imamae, ka unu‑tauna tavine, e aniga, ka eha aitam natuna. Ka taina nepena vaneina wadaena tavinei. ");
INSERT INTO mvn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka vꞌ‑inuana kadue deina, ka vꞌ‑itonuna deina ineine, e pai nau‑yehata vi‑7‑na. ");
INSERT INTO mvn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka pai nau‑yehata wayahina, vavinena kadue aniga. ");
INSERT INTO mvn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka mini‑havine anꞌ auyewa wayahina, yawai vovouna wayahina, ononotoi ai yau 7 wayahia, koiaka tauna awana? Iuna habuhabui itavinei.” ");
INSERT INTO mvn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka Iesu ivona, “Itomi unuanua bwagona. Iuna eha Iginuma utꞌ‑anamane, kadue eha Yaubada ya bagibagi utꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mini‑havine munia, tomotau eha itavine. Ka taui imini‑havine, yai dewa anelose wahuma aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ika, tau anianiga yai mini‑havine wayahina mwagemwagemi. Iuna eha Iginuma uta‑iaiava ahiahina. Unononi, Yaubada yana vona wayahimia, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yauke Abaraham ya Yaubada kadu Isaki ya Yaubada kadue Iakobo ya Yaubada.’ Ka Yaubada eha tau anianiga yai Yaubada. Tauna taui yawayawai yai Yaubada.” ");
INSERT INTO mvn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ka tomotaui yoko nihenia ya vonana inononi, ka nuai vi‑tupatupa ya viwavenena wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka Parisi yoko, avaha inononi vivane Iesu Sadusi yoko yai vi‑tanai nau‑patei ahiahina ka vane‑tawanei tomotau mataia deina, taui inau‑hohona‑havine, ka iomo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ka taui wayahia veimea a tau nua‑uya aitam omo Iesu wayahina, nuanuana aitam vi‑tanai wayahina na‑nau‑dadani. ");
INSERT INTO mvn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ivona, “Tau Viwavenena, veimea habuhabui wayahia, avi veimea ananina?” ");
INSERT INTO mvn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Iesu ivona, “Veimea ananina taina, ‘Yam Kauvea Yaubada evi‑ateteyei nuam habuhabuna wayahina, kadu ininim habuhabuna wayahina, kadue yam nuanua habuhabuna wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Vonana vona ananina, kadu veimea naona. ");
INSERT INTO mvn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka kadu vꞌ‑inuana taina deina, vivane, ‘Tomotau habuhabui edewa‑vidovidohei taum nuanuam deina.’ ");
INSERT INTO mvn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Veimea habuhabui ai pai mini, kadu tau apa‑taputapu yai iginuma habuhabui ai pai mini ivinꞌ‑omo veimeaia wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ka Parisi‑naia imimini, ka Iesu vi‑tanaiei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Medeina unuanua Tau Ito‑yavuha‑nana wayahina? Avi dede yana dede?” Ka taui ivona, “Davida yana dede wayahina na‑omo.” ");
INSERT INTO mvn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka Iesu vi‑tanaiei, ivona, “Aituhu deina, aviani wayahina Davida apa‑taputapuei Nuana Ahihinata ya bagibagi wayahina, kadue apa‑Kauveyei deina? Ivona, ");
INSERT INTO mvn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yaubada ivona yau Kauvea wayahina, ivona, “Ateiua emanuena a itoava am havia aem iwaunina abouni, eveimeyei wayahina.” ’ ");
INSERT INTO mvn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aituhu Tau Ito‑yavuha vivane Davida ya Kauvea, medeina Tau Ito‑yavuha ana pata Davida yana dede wayahina na‑omo?” ");
INSERT INTO mvn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka eha aitam koiaka ana pata Iesu ya vi‑tanai taina na‑nau‑pate. Ka auyewana wayahina a itoava Iesu yanꞌ aniga wayahina, tomotau imatamatautei. Wayahina, eha aitam koiaka kadue Iesu ta‑vi‑tanatanai‑havine. ");
INSERT INTO mvn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Vonaia iakwa, e Iesu yoko‑naia wayahia kadu a tau vi‑muni‑waiwai wayahia ivona, ");
INSERT INTO mvn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nonova Mosese me Isiraeli veimeyei, ka ataina veimea a tau viwavenena kadue Parisi yoko iveimeyemi deina. ");
INSERT INTO mvn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wayahina, aviani iviwavenemi, akanai nau‑wawanimi uvi‑muniei deina. Kate eha nau‑wawanimi yai dewa udewa‑vꞌ‑iune. Iuna taui eha yai viwavenena ita‑dewa‑nubunubu. ");
INSERT INTO mvn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Taui pai avana vitai tomotau ivenevenei, ka eha pai avana‑naia wayahia ina‑ivaite. ");
INSERT INTO mvn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yai dewa habuhabuna idedewei, iuna yai nuanua tomotau idudueyei, e munia dewaia wayahi inꞌ‑awa‑davedavei. Iginuma a pai vi‑ai tepai ka nimai wayahi badobadona inau‑vevewanei, kadu ivaivana mamanaina ai kwama wayahi iweteweteni. Ka idedewei deina, iuna yai nuanua ivo‑vi‑memeani mani tomotau idudueyei, e munia inuanua Yaubada ivi‑ateteyei bagibagina. ");
INSERT INTO mvn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ka kadu inava ana tuta wayahina, taui nuanuai tana‑pwaina imanuena, ka kadu manua tapanono nihenia yai nuanua ananina pai manuena ahiahina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ka avi tuta maketia ini‑awana, yai nuanua tomotau inau‑kaiwei mani tomotau mataia, kadu yai nuanua tomotaui ivi‑wahani ‘tau viwavenena’, e ai wava isi‑nai mani tomotau mataia deina. ");
INSERT INTO mvn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ka apaina itomi eha nau‑wawanimi tomotau ivi‑wahanimi RabiV. Iuna, habuhabumi yami Kauvea vivane aitamoata‑hoina, ka habuhabumi vavaneimi. ");
INSERT INTO mvn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kadu eha nau‑wawanimi aitam koiaka tanopia vi‑wahani ‘Amau’. Iuna Amami aitamoata‑hoina wahuma mamaei. ");
INSERT INTO mvn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kadu eha nau‑wawanimi tomotau ivi‑wahanimi ‘tau viwavenena’. Iuna Tau Ito‑yavuha taua au heta‑ohota yami tau viwavenena. ");
INSERT INTO mvn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ka aituhu koiaka wayahimia eta‑naonaoemi, tauna nau‑wawani vi‑tau paisewa‑kavokavovo wayahimi. ");
INSERT INTO mvn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ka aituhu koiaka wayahimia nua‑vane, apaina Yaubada onotona na‑dewei, na‑nua‑opu. Ka aituhu koiaka nua‑opu, apaina Yaubada onotona ana wava na‑si‑nai. ");
INSERT INTO mvn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna itomi eha Yaubada ya pai veimea wahuma uta‑nuinu, kadu mani tomotau uvito‑potapotai, ka uvonevonei taui eha ai pata ina‑nu. ");
INSERT INTO mvn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna tuta habuhabuna wayahina meagai habuhabui wayahia ututu‑vivina, iuna yami nuanua onoto aitamoata uvaniahei, uviwavenei, vivane ami tau vi‑muni‑waiwai. Ka munia, onoto‑nana vi‑putu itomi yami dewa na‑dewa‑nubunubu, ka tauna vi‑muniemi. Ka avonemi, itomi Satana ya tau paisewa, ka munia, onoto‑nana vane‑tawanemi paisewa goyona wayahina. Ka apaina ami dewa‑yaiyai uvaniahei yami dewa goyona wayahi, kate tauna a dewa‑yaiyai ainua na‑vaniahei ya dewa goyona wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aioi wayahimi! Itomi vivane tau mata‑goyogoyo, kate mani tomotau ueta‑naonaoe! Iuna itomi uvonavona, ‘Aituhu aviyaivia ivona‑dabadaba Manua Vito‑pota a wavea, taui yai vona‑dabadabana eha aitam aviani. Eha nau‑wawani munia idewa‑yehai. Kate aituhu aviyaivia ivona‑dabadaba Manua Vito‑pota a goulaV wayahina, eha nau‑wawani vona‑dabadabana itana‑bwege.’ ");
INSERT INTO mvn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Vona ahiahina, itomi mwagemwagemi kadu mata‑goyogoyomi! Aviani hetana? Manua Vito‑pota a goulaV, o kadi Manua Vito‑pota ana heta? Avonemi goulanaV ana wava ananina iuna Manua Vito‑pota ana heta ana wava ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ka kadu uvonavona, ‘Aituhu aviyaivia ivona‑dabadaba pai vi‑nomu a wavea, taui yai vona‑dabadabana eha aitam aviani. Eha nau‑wawani idewa‑yehai. Kate aituhu aviyaivia ivona‑dabadaba am‑venena‑kavovo‑nana pai vi‑nomu hetana wayahina, eha nau‑wawani vona‑dabadabana itana‑bwege.’ ");
INSERT INTO mvn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Itomi mwagemwagemi! Aviani ananina? Tomotau yai am‑venena pai vi‑nomu hetana, o kadi pai vi‑nomuna ana heta? Vona tunuhina, pai vi‑nomuna vivane am‑venena‑kavovo‑naia vito‑potepotei. ");
INSERT INTO mvn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wayahina unononi. Aituhu aviyaivia ivona‑dabadaba pai vi‑nomu a wavea, taui kadu ivona‑dabadaba pai vi‑nomu wayahina, kadu avi gugua habuhabuna hetana imamaei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kadue aituhu aviyaivia ivona‑dabadaba Manua Vito‑pota a wavea, taui kadu ivona‑dabadaba Manua Vito‑pota wayahina, kadu Tauna Manua Vito‑pota nihenina mamaei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ka aituhu aviyaivia ivona‑dabadaba wahuma wayahina, taui ivona‑dabadaba Yaubada ya pai manuena ahihi‑vainena wayahina, kadue Tauna pai manuenana hetana manuena wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna Mosese ya veimea kikitui udewa‑nubunubui, ka udune‑vivinimi udedewei tunuhina. Wayahina, yami mata‑sinisinina ana wava minitiV, kadu yami pai tunina tunina utana‑vewani gwau ai yau 10 wayahia, ka gwau ai yau 9 upoyꞌ‑avini, ka gwau aitamoata uam‑veneneyei Yaubada wayahina. Dewana akanai, iuna veimea veimeyeka kadewei deina. Kate avi veimea anani, itomi dewaia udewa‑kavokavovoei, ka eha uta‑dune‑vivinimi. Dewaia anani vivane dewa tunutunuhina mani tomotau wayahi, ka ate‑nuanuai mani tomotau wayahi, kadue vi‑ateate Yaubada wayahina. Dewaia habuhabui uvi‑nua‑pania. Ka avonemi nau‑wawanimi veimeaia anani kadu veimeaia kikitui udewa‑nubunubui. ");
INSERT INTO mvn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Itomi vivane tau eta‑naonao, kate mata‑goyogoyomi. Yami dewa taina deina. Ami buyavi uvo‑vi‑aiaia, e namo‑sihisihi uepa‑yavunei, kate vahitau ananina kameliV deina utonotononi. ");
INSERT INTO mvn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna yawaimi yami dewa taina deina. Vei ka gaeba vuvunaha unosinosia, unau‑wohi, uvo‑vi‑aiaia ahiahina, kate nihenina gawagawamina, ka vainau ka nua‑tani inau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Itomi Parisi yoko mwagemwagemi! Nau‑wawanimi naona vei nihenina ka gaeba nihenina uvo‑vi‑aiaia Yaubada matana. Ka aituhu nihenina tunutunuhina, akanai vuvunaha kadue tunutunuhina Yaubada matana. ");
INSERT INTO mvn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna yawaimi unuvovo deina. Upuna pai vo‑vi‑kavui wayahina uvaivani, e ana dune ahiahina tomotau mataia. Kate nihenina tau mate numanumai, kadue dewa habuhabuna mavununa imamaei. ");
INSERT INTO mvn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tomotau yawaimi idudueyei, ka inuanua itomi tau tunutunuhimi, kate nihenimia vitupu, kadu dewa goyona inau‑vi‑anaimi. ");
INSERT INTO mvn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aioi, itomi veimea a tau viwavenena wayahimi, kadue itomi Parisi yoko wayahimi! Itomi tau vitupu! Iuna ataina tau apa‑taputapu ai unuvovo uaikayokayoi, uvo‑vi‑aiaia, kadu tau tunutunuhi ai unuvovo uvaivani. Ka yami dewaia tanoi ana dune vivane Yaubada ya nuanua uvi‑ateteyei deina. ");
INSERT INTO mvn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kadu uvonavona, ‘Aituhu nonova kamamaei wawaka yai tutea, tutana tau apa‑taputapu‑naia inau‑vi‑anigi, itoai eha kata‑ivaite nau‑vi‑aniga‑naia wayahia.’ ");
INSERT INTO mvn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kate yami vonana wayahina uhaeyeka vivane itomi tau apa‑taputapu‑naia ai tau nau‑vi‑aniga‑naia yai tupua‑nenenehi. ");
INSERT INTO mvn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ka apaina, tau nau‑vi‑aniga‑naia yai paisewa unau‑yehai, e tau apa‑taputapu aitam una‑nau‑vi‑anigi taui deina. ");
INSERT INTO mvn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Itomi mwata natunatuna ka manimaninimi! Eha ami pata meagai ai ananata una‑novo‑tawane! Nau‑wawanimi uvaniahei! ");
INSERT INTO mvn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Unononi. Tuta tepakaia wayahina, yauke tau apa‑taputapu tupwai avi‑tunei, inꞌ‑omo wayahimia, ka kadu tau nua‑uya tupwai, ka kadu tau viwavenena tupwai nui. Kate apaina, tupwai unau‑vi‑anigi, ka tupwai ai nahenahea ututu‑pwatei, kadue tupwai yami manua tapanono nihenia uyavuyavunai, ka meagai aitamoata aitamoata wayahia uvo‑tahoi. ");
INSERT INTO mvn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wayahina, dewa‑yaiyai uvaniahei vivane ami nau‑pata tau tunutunuhi ai aniga habuhabui wayahi. Tuta pai vi‑putu wayahina, onoto tunutunuhina ana wava Abeli dayahina iopu nau‑vi‑aniga wayahina. Ka onoto tunutunuhi habuhabui dayahi iopuopu a itoava tau vi‑nomu ana wava Sekaria, tauna Berekia natuna unau‑vi‑anigi Manua Vito‑pota awana ka pai vi‑nomu niwania wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Memeanina nuami vi‑tupatupa, kate avonemi, dewa‑yaiyai nau‑vi‑aniga habuhabuna tanoi wayahina taumi uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aioi Ierusalem! Aioi tau maꞌ Ierusalem wayahimia! Iuna tuta tuta tau apa‑taputapu‑naia unau‑vi‑anigi, kadu Yaubada a tau vi‑muni‑waiwai ututu‑hanuhanui. Kate tuta habuhabuna wayahina yau nuanua ahonemi unau‑hohoni wayahiua. Ka adune‑vivinimi kamkam vavinena natunatui papeia itana‑kabubui deina. Kate eha yami nuanua. Tuta tuta uvihahaieu. ");
INSERT INTO mvn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Udueyei. Apaina Yaubada na‑ni‑tawanemi, ka yami goyona nui umamaei, uvi‑goyomi. ");
INSERT INTO mvn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka ataina avonemi, apaina eha udune‑havineu a itoava wayahiua uawaeha aitamoata wayahina. Ika, nau‑wawanimi naona uvonavona, ‘Tauna Kauvea a wavea omomoi kanꞌ‑awa‑davei.’ Ka avi auyewa uvonavona deinake, akanai udune‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Vonana iakwa, e Iesu Manua Vito‑pota ni‑tawanei, ka tutana tauna nepena, a tau vi‑muni‑waiwai iomo wayahina, ka manua habuhabuna Manua Vito‑pota papena ananina imamaei iapa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka Iesu ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, ataina manua‑naia habuhabui ududueyei, kate apaina habuhabui ibwege‑yavunei, ka hanu manua‑naia wayahia, kadu hanu manua ai tutu‑gana wayahia imamaei tanopia, eha aitam hanu‑naia wayahia mani hanu hetana.” ");
INSERT INTO mvn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Munia tauna omo Oya Olive wayahina ka manuena, ka a tau vi‑muni‑waiwai iomo wayahina ka taui ai heta nui imamaei, ka iviamei, ivona, “Kauvea, evoneai avi tuta wayahina Manua Vito‑pota ibwegei, ka yam tuta mavina, ka kadu tuta pai nau‑yehata wayahina ai iaiaya emataedai anꞌ‑anamanei.” ");
INSERT INTO mvn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka Iesu ya vona‑nau‑pata mamanaina vi‑putu deina, ivona, “Udune‑vivinimi. Apaina tomotau inꞌ‑omo, ka yai nuanua inonomi. ");
INSERT INTO mvn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wayahina, habuhabui au wavea inꞌ‑omo, iviwavene‑paniemi. Ka aitamoata aitamoata wayahia ina‑vona, ‘Yauke Tau Ito‑yavuha‑nana.’ E taui tomotau habuhabui inonoi deina, ka aituhu aviyaivia taui ivitumahanei, ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kadu apaina, vanevane haviai wayahia unononi, tupwai avaha ivi‑putu, ka tupwai, kaiwadi, apaina ivi‑putu. Kate itomi nau‑wawanimi udune‑vivinimi ahiahina, ka eha unꞌ‑awaehemi ateatemi viviha wayahina. Iuna Yaubada avaha dewaia tanoi veimeyei naona inꞌ‑omo, ka munia tanopi ana tuta pai nau‑yehata na‑omo. ");
INSERT INTO mvn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Wayahina, apaina tau maꞌ papani tau maꞌ mani papani wayahia ivi‑naua, ka kiniV yai yoko mani kiniV yai yoko wayahia ivi‑naua. Kadue am navovo ananina ka yoyoyo inꞌ‑omo meagai habuhabui wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ka dewaia tanoi vivane tuta vitaia ai pai vi‑putu ana heta. ");
INSERT INTO mvn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Apaina tomotau ipoyꞌ‑avinimi, e mani tomotau wayahia ivenemi, ivo‑vihavihami, o ina‑nau‑vi‑anigimi. Ka tau vi‑meagai papani habuhabui nihenia inau‑nikonikoiemi, iuna taumi vivane au tau vitumahana. ");
INSERT INTO mvn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ka auyewaia nihenia au tau vitumahana habuhabui yai vitumahana ivihahaiei ini‑tawaneu, ka ivi‑putu vavanei ivauyei, ka inau‑nikonikoiei, ka kadu inau‑haviei. ");
INSERT INTO mvn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka tau apa‑taputapu vitupu habuhabui inꞌ‑omo, e tomotau habuhabui ieta‑naonao‑paniei. ");
INSERT INTO mvn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka auyewaia nihenia dewa goyona na‑nata. Wayahina, tomotau habuhabui yai dune‑nuanuai mani tomotau wayahia na‑ihanua. ");
INSERT INTO mvn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kate aituhu aviyaivia itoha‑vi‑anai, imimini toyoina a itoava tuta a pai nau‑yehata wayahina, akanai taui dewa‑haiawa‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naona au tau nau‑wahe nau‑wawani ineine meagai habuhabui wayahia, ka Yaubada ya pai veimea Vaneana Ahiahina inaunau‑waheyei tau vi‑meagai‑naia wayahia. Na‑iakwa, ana pata tuta pai nau‑yehata na‑omo. ");
INSERT INTO mvn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nonova tau apa‑taputapu Daniela dewa goyona ani‑vainena apa‑taputapuei vivane apaina na‑omo pai vi‑ai vito‑potana wayahina. Ka Yaubada dewana goyona nau‑nikonikoiei. Iuna dewana pai vi‑ai vito‑potana na‑vo‑vi‑gawagawami. Ka dewana a vinꞌ‑omana aitam iaiaya wayahimi. Ka avi auyewa iaiayana udueyei meagai vito‑potana nihenina mimini (aituhu aviyaivia vona taina iaiaiavi, yau nuanua nuai nꞌ‑am‑haui), ");
INSERT INTO mvn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","auyewana wayahina, Iudea a tau maꞌ nau‑wawani ineine oya wayahia, ina‑novo. ");
INSERT INTO mvn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka aituhu aviyaivia nau‑peuna yai manua hetana wayahina imamaei, taui nau‑wawani ina‑opu ina‑novo‑kwayavoni. Eha nau‑wawani yai manua ina‑nu‑havinei yai gugua ivitue. ");
INSERT INTO mvn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka auyewana wayahina, aituhu aviyaivia baguna nihenina ipaipaisewa, eha nau‑wawani imavina yai megeia, e ai kwama badobadona inꞌ‑epe. ");
INSERT INTO mvn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aioi! Iuna auyewana wayahina taui iamwanainahe kadue taui vi‑nunu vitana ananina ivaniahei! ");
INSERT INTO mvn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nau‑wawanimi uviama auyewa ahiahina Yaubada na‑venemi yami tuta novo wayahina, ka eha kwadudu ana tuta nihenina, ka eha auyewa tapanono wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vona tunutunuhina, auyewana wayahina inahe ani‑vainena na‑omo, eha aitam deina tanopi a vevewana wayahina a itoava tuta ataina wayahina, ka apaina eha kadu aitam na‑vinꞌ‑omo deina. ");
INSERT INTO mvn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vitaia auyewaia vivane vita‑vainena. Ka Yaubada tupwai tomotau vi‑nua‑dadanei vivane ya tomotau. Ka tauna taui wayahi auyewaia na‑vo‑vi‑kutekutei. Aituhu eha, tomotau habuhabui inꞌ‑aniga, eha aitam na‑tupwa. ");
INSERT INTO mvn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Auyewaia nihenia, aituhu koiaka na‑vonemi, ‘Tau Ito‑yavuha taina’ o ‘Tau Ito‑yavuha tanoi’ eha uvitumahane. ");
INSERT INTO mvn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iuna, tau ito‑yavuha vitupu kadue tau apa‑taputapu vitupu inꞌ‑omo, ka taui ai pata iaiaya bagibagi kadu dewa‑bagibagi idedewei. Ka dewaia ivevewanei, e tomotau habuhabui inonoi deina. Tupwai tomotau, taui avaha Yaubada vi‑nua‑dadanei ya tomotau, taui ai heta nuai nꞌ‑am‑haui nono‑naia wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Unuani. Ataina avaha dewaia wayahi amataedami. ");
INSERT INTO mvn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Wayahina, aituhu aviyaivia ivonemi, ‘Tau Ito‑yavuha meagai anata mamaei,’ eha una‑ne anata wayahina. O aituhu aviyaivia ivonemi, ‘Tau Ito‑yavuha manua taina nihenina mamaei,’ eha yai vona uvitumahane. ");
INSERT INTO mvn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Avaha uanamanei, avi tuta vonaina tapa‑yayai babau a papani pai vane wayahina, ana pata kadueyei babau a papani pai onu wayahina. Ka yauke, Tauna Vi‑tomotau, yau mavi‑havine deinake. Vo‑kwayavonina avinꞌ‑omo, ka tomotau habuhabui idudueyeu. ");
INSERT INTO mvn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aitam vona tana‑minikuna taina unononi. ‘Aveta wayahina aitam tau mate mamaei, akanai eha ani‑hoina papani‑nana nihenina bwayobwayo inau‑hohona.’ Wayahina, avi tuta iaiaya tanoi ivinꞌ‑omo udueyei, akanai unꞌ‑anamanei vivane vi‑aioi ana tuta vi‑maupwani. ");
INSERT INTO mvn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ka tuta vitana tanoi na‑iakwa, e vo‑kwayavonina ‘Babau vi‑novane, e kadu wahava ya maheta na‑weu. Ka wadima wahuma imaumaua, ka dewa habuhabui wahuma imamaei yai bagibagi ina‑ihanua.’ ");
INSERT INTO mvn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Munia tomotau yauke, Tauna Vi‑tomotau, au iaiaya wahuma na‑omo idudueyei, kadu yoko habuhabui tanopia idudueyeu you tepana yau bagibagi kadu didigau ani‑vainena nui aomomo. Wayahina, taui ivi‑mohai, iuna yai ini‑yauyau ananina. ");
INSERT INTO mvn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ka bwegigi putuna ananina wayahina yau anelose avi‑tunei ine papani aitamoata aitamoata wayahia tanopi wayahina kadue wahuma wayahina. Ka aituhu aviyaivia avaha avi‑nua‑dadanei, taui ivi‑ateteyeu, akanai anelose‑naia inau‑hohoni iomanei wayahiua. ");
INSERT INTO mvn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aitam pai dune madaiba wayahina aviwavenemi unononi. Avi tuta madaiba yawaina vovouna ivi‑putu itabo‑havine, uanamanei nau‑sisi ana tuta vi‑maupwani. ");
INSERT INTO mvn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wayahina deinake, aituhu avi tuta iaiaya‑naia udune‑vaniahei, akanai unꞌ‑anamanei yau tuta mavi‑havine wayahina avaha vi‑maupwani, tuta eha ani‑hoina na‑iakwa, e udune‑havineu. ");
INSERT INTO mvn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Memeanina nuami vi‑tupatupa, kate avonemi, hum taina eha na‑iakwa a itoava dewai habuhabui ivinꞌ‑omo wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Apaina wahuma taina kadu tanopi taina ina‑iakwa, kate yau vona eha ina‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Unononi ahiahina. Eha aitam koiaka tanopia mamae yau mavi‑havine ana tuta, o kadi anꞌ auyewa tꞌ‑anamane. Anelose wahuma eha itꞌ‑anamane, kadu yauke, Tauna Vi‑tomotau, eha atꞌ‑anamane. Amau a heta‑ohota anamanei. ");
INSERT INTO mvn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nonova Noa yana tuta wayahina, tomotau taui yai dewa ivi‑muniei. Ka yauke, Tauna Vi‑tomotau, yau mavi‑havine ana tuta deina. ");
INSERT INTO mvn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iuna, Noa yana tuta wayahina, naona tomotau iamam, ka inimnim, ka ivi‑awa‑kanakanapi, kadu itavitavine a itoava auyewana Noa yana yoko nui ya waea igenu wayahina. Iakwa, e diwaya ananina vinꞌ‑omoi. ");
INSERT INTO mvn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ka tomotau‑naia mwagemwagei, ka eha itꞌ‑anamane vivane diwaya omomo, na‑tua‑hunuvi, ka tomotaui habuhabui igavivina. Ka yauke, Tauna Vi‑tomotau yau mavi‑havinena anꞌ auyewa deinake. ");
INSERT INTO mvn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Auyewana wayahina, aituhu onoto ainua ibagubaguna, anelose‑naia aitamoata wayahia inꞌ‑epei, ka a niam ivihahaiei na‑mae. ");
INSERT INTO mvn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ka kadu aituhu vaivine ainua iam‑gidoma, anelose‑naia aitamoata wayahia inꞌ‑epei, ka a niam ivihahaiei na‑mae. ");
INSERT INTO mvn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wayahina, itomi udune‑vivinimi, kadu udunedune ahiahina. Yauke yami Kauvea, kate eha yau mavi‑havinena ana tuta utꞌ‑anamane ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ka vona tana‑minikuna taina unononi, ka unuani. Aituhu tau vi‑manua tau vainau ya nuanua nꞌ‑anamane, vivane nuanuana ioyoma pouna na‑omo, e ya manua na‑bwegei, tau vi‑manuana nau‑wawani ya manua na‑dune‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ka itomi nau‑wawanimi udune‑vivinimi deina, kadu udunedune ahiahina. Iuna yauke, Tauna Vi‑tomotau, amavina aitam tau vainau deina. Eha yau mavi‑havinena a babau amai‑vonemi. ");
INSERT INTO mvn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wayahina, kadu aitam vona tana‑minikuna avonemi, e tau nua‑uya yai dewa unꞌ‑anamanei. Yauke aitam tau vi‑manua deina, ka itomi yau tau dune‑vi‑avina. Yau manua nihenina tau paisewa habuhabui imamaei. Ka ataina yami paisewa avenemi. Ka avi tuta nau‑wawani yau tau paisewa‑naia wayahi, akanai itomi ai maꞌ uvenevenei. ");
INSERT INTO mvn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aituhu itomi yami nua‑uya nui, nau‑wawanimi yami paisewana udedewei a itoava amavina wayahina. Aituhu udedewei deina, apaina auyewana wayahina ududueyeu, dewa‑haiawa‑vavaha uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Memeanina nuami vi‑tupatupa, kate avonemi vivane yau gugua habuhabuna avenemi uveimeyei. ");
INSERT INTO mvn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kate aituhu unuanua goyona, ami heta una‑vona, ‘Ia! Tuta bana mamanaina wayahina yau kauvea papani‑nana mamaei. Tuta mamanaina nau‑wawaniu apotapota, e tauna na‑mavina. ");
INSERT INTO mvn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wayahina, nau‑wawaniu yau nuanua avi‑putu adedewei.’ Aituhu uvi‑putu yaiami upiahi, o aituhu uamam‑didiga, o kadi daudau bagibagina unimnim‑didiga tau goyona nui, ");
INSERT INTO mvn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","apaina yauke, yami Kauvea, amavina aitam auyewa wayahina, kate eha auyewana unꞌ‑anamane, ka eha babau‑nana unꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka aituhu yami goyona avaniahei deina, avita‑vovonimi yau inama wayahina, kadu avo‑tahomi una‑ne ami pai vi‑ai wayahina. Pai vi‑ai‑nana vivane tau vitupu yai papani wayahina, ka papani tanoi wayahina taui na vihai itoutou, kadue na vihai nihoi ina‑utaiei.” ");
INSERT INTO mvn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu yana vona mamanaina eha ta‑iakwa, ka neine, ivona, “Auyewaia nihenia Yaubada ya pai veimea wahuma taina deina. Ahahaba ai yau 10 imamaei, ka aitamoata aitamoata wayahia yai lampaV iepei, e ini‑ubau iopu tau tavine ipotepotei. ");
INSERT INTO mvn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ka taui wayahia ahahaba ai yau 5 yai nua‑uya nui, ka ahahaba ai yau 5 mwagemwagei. ");
INSERT INTO mvn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ka taui mwagemwagei yai lampaV iepei, kate eha daudau wayahi itꞌ‑epe. ");
INSERT INTO mvn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kate taui yai nua‑uya nui yai lampaV kadue daudau na gamna nui iepei. ");
INSERT INTO mvn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ka habuhabui tau tavine‑nana ipotapota‑wayohei, ka tauna eha ta‑vo‑kwayavoni. Wayahina, habuhabui idauva iaino‑ainei. ");
INSERT INTO mvn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ka ioyoma pouna movina ananina inononi, ivona, ‘Tau tavine omomoi! Unꞌ‑omo unau‑vi‑taui!’ ");
INSERT INTO mvn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ka ahahaba‑naia habuhabui imini, e yai lampaV ivo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka taui mwagemwagei yaiai iviamei, ivona, ‘Aioi! Itoai yama daudau avaha iakwa. Wayahina, yami daudau uvo‑patai. Iuna yama lampaV iweuweu.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka taui yai nua‑uya nui inau‑patei, ivona, ‘Eha ama pata aivaitemi. Iuna ama daudau eha ana pata habuhabuka wayahika. Itomi uvisina una‑ne tau aimwane daudau wayahina, ka yami daudau uvi‑maiei.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wayahina, taui mwagemwagei yaiai ini‑tawanei, e ineine etawana, ka tuta aitamoata wayahina tau tavine‑nana vinꞌ‑omo. Taui yai nua‑uya nui ai yau 5 avaha ivo‑vi‑aiai. Wayahina, tau tavine‑nana nui manua inui, ka manuana a tau paisewa awana gudu‑potei. Iakwa, e tavine anianina ivi‑putu, idewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ka munia, taui mwagemwagei imavina, e awana wayahina imimini, itutu‑keakeana, ivi‑honehone, iviama, ivonavona, ‘Bada, Bada! Kaiwa ananina. Memeanina awana ewaei wayahiai?’ ");
INSERT INTO mvn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka tau tavine‑nana vona‑nau‑patei, ivona, ‘Memeanina nuami vi‑tupatupa, kate avonemi, eha atꞌ‑anamanemi.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wayahina, viviwavana unuani, ka udune‑vivinimi. Iuna itomi eha yau mavina anꞌ auyewa utꞌ‑anamane, kadu eha yau mavi‑havine a babau utꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ka kadu aitam vona tana‑minikuna avenemi, e Yaubada ya pai veimea wahuma wayahina unꞌ‑anamanei. Aitam tuta onoto kaikaiwabona mamaei. Ka tauna kadu tau vi‑manua aitam. Ka tauna ya tau paisewa aitonu hone‑hohoni, e ivona, ‘Yauke yau nae ana tuta avaha omoi. Ka ataina yau gugua kadu yau kina atana‑vewani avenemi, e itomi udune‑vi‑avini ataina a itoava amavina wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka tau paisewa naona honei, e talenita ai yau 5 venei, e vꞌ‑inuana talenita ai yau 2 venei, e vꞌ‑itonuna talenita aitamoata venei, aitonu ai pata deina. Iakwa, e kaikaiwabona ni‑tawanei ine mani papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ka vo‑kwayavonina, tau paisewa naona ya talenita epei, ine, e vi‑putu paipaisewa. Ka munia ya paisewa wayahina kadue talenita ai yau 5 hetana vaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka deinake, tau paisewa vꞌ‑inuana ya talenita epei, ine, e vi‑putu paipaisewa. Ka munia ya paisewa wayahina kadue talenita ai yau 2 hetana vaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kate tau paisewa vꞌ‑itonuna ya talenita epei, ine, e guba tanopia ikayo, e ya talenita na kodena pai vi‑ai tanopia tavuni. ");
INSERT INTO mvn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ka tuta mamanaina munia, kaikaiwabo‑nana mavina. Ka ya tau paisewa hone‑hohoni, e medeina yai dewa nꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ka tau paisewa naona vinꞌ‑omoi, e ivona, ‘Kauvea, kaiwa ananina. Nonova evitumahaneu, e talenita ai yau 5 eveneu adune‑vi‑avini wayahim. Ka yau paisewa wayahina kadue talenita ai yau 5 hetana avaniahei. Wayahina, ataina habuhabuna talenita ai yau 10 avene‑havinem.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka tau paisewana ya kauvea ivona, ‘Kaiwa ananina. Taum yam dewa ahiahina kadu tunuhina. Nonova gugua tupwai avenem edune‑vi‑avini, ka avaha edune‑vi‑avini ahiahina. Wayahina, ataina gugua habuhabuna avenem eveimeyei. Enꞌ‑omoi, e nui kadewa‑haiawa!’ ");
INSERT INTO mvn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ka tau paisewa vꞌ‑inuana vinꞌ‑omoi, e ivona, ‘Kauvea, kaiwa ananina. Nonova evitumahaneu, e talenita ai yau 2 eveneu adune‑vi‑avini wayahim. Ka yau paisewa wayahina kadue talenita ai yau 2 hetana avaniahei. Wayahina, ataina habuhabuna talenita ai yau 4 avene‑havinem.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka tau paisewana ya kauvea ivona, ‘Kaiwa ananina. Taum yam dewa ahiahina kadu tunuhina. Nonova gugua tupwai avenem edune‑vi‑avini, ka avaha edune‑vi‑avini ahiahina. Wayahina, ataina gugua habuhabuna avenem eveimeyei. Enꞌ‑omoi, e nui kadewa‑haiawa!’ ");
INSERT INTO mvn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ka pai nau‑yehata wayahina, tau paisewa vꞌ‑itonuna vinꞌ‑omoi, e ivona, ‘Kauvea, avaha anamanem, wamke yam dewa eha tunuhina. Iuna tuta tuta baguna eaiaihana, kate bagunaia eha eta‑baguna. Ka manimaninim deinake. ");
INSERT INTO mvn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wayahina, amatamatautem. Akaka, ane, e guba tanopia aikayoi, e yam talenita atavuni tanopia. Ataina yam talenita avene‑havinem.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ka tau paisewana ya kauvea magana bawe wayahina, ka ivona, ‘Ia! Taum goyogoyom, kadu eupu‑tonetonem! Avaha eanamaneu yauke baguna aiaihana, kate eha bagunaia ata‑baguna, a? ");
INSERT INTO mvn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aituhu avaha enuanua deina, wamke nau‑wawanim nonova yau talenita enꞌ‑epe, e mani tomotau ena‑vo‑patai, e ataina ina‑vene‑havinem ka tupwana hetana nui.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ka kaikaiwabo‑nana mani tau paisewa honei ka veimeyei, ivona, ‘Onoto taina ya talenita uvitua‑yavunei, e una‑ne, e tauna avaha talenita ai yau 10 wayahina uvenei.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iuna aituhu aviyaivia kikituna nimaia mamaei, ka aituhu yai dewa tunutunuhina, apaina taui ahiahina ivaniahei hetana. Kate aituhu aviyaivia kikituna nimaia mamaei, ka aituhu yai dewa eha tunutunuhina, apaina aviani kikituna nonova nimaia mamaei avitua‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akanai, tau paisewana goyogoyona yau manua upuna uhaponei. Papani‑nana novanovanina, ka papani‑nana wayahina tomotau na inahei itoutou, kadu na inahei nihoi ina‑utaiei. ");
INSERT INTO mvn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Auyewana wayahina yauke, Tauna Vi‑tomotau, amavi‑havine, avinꞌ‑omo yau anelose nui kadu didigau nui. Ka didigau wahuma wayahina nui yau pai manuena ahihi‑vainena hetana amanuena, e avi‑putu aveimeyei. ");
INSERT INTO mvn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ka tau maꞌ tanopi habuhabui inau‑hohona wayahiua. E habuhabui atana‑vewani, sipiV ai tau dune‑vi‑avina yai dewa deina, tutana taui yai sipiV itana‑vewani vahitau ana wava gotiV wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","E yau sipiV ateiua abouni, ka gotiV akeniua abouni. ");
INSERT INTO mvn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na‑iakwa, e yauke, yai kiniV, taui ateiua avonei, ana‑vona, ‘Itomi avaha nau‑iaiava Amau wayahina uvaniahei. Unꞌ‑omoi, e yami gabu unꞌ‑epei. Nonova, tutana Yaubada dewa habuhabuna vevewanei, tauna kadue pai maꞌ vo‑vi‑aiaia wayahimi. Ka natunatuna aitamoata aitamoata nau‑wawani pai maꞌ‑nana ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iuna tutana yauke am navovo, aniani uveneveneu. Ka tutana magau ayaya, pai nim uveneveneu. Ka tutana yauke abwanibwani, eha yau manua, uvaniahau, e uvoneu, “Evane‑mei, baina emamaei.” ");
INSERT INTO mvn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka tutana yauke eha au kwama, ami kwama uvo‑patau. Ka tutana avi‑kwanaha, udune‑nuanuaieu, udune‑viviniu. Ka tutana yauke manua yohona nihenina yohoyohoniu amamaei, uomomo wayahiua unau‑vi‑tau.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ka taui tunutunuhi vona inau‑patau, ina‑vona, ‘Kauvea, kaiwadi, avi tuta wayahina adueyem am enavovo, e aniani avenem, o kadi magam ayaya, e pai nim avenem? ");
INSERT INTO mvn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kaiwadi, avi tuta wayahina adueyem evi‑tau bwanibwani, avonem, “Evane‑mei, baina emamaei,” o avi tuta wayahina adueyem eha am kwama, e ama kwama avo‑patam? ");
INSERT INTO mvn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ka kaiwadi, avi tuta wayahina adueyem evi‑kwanaha, o manua yohona nihenina yohoyohonim emamaei, e anau‑vi‑taum?’ ");
INSERT INTO mvn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ka yauke, yai kiniV, ana‑vona, ‘Memeanina nuami vi‑tupatupa, kate avonemi, nonova avi dewa ahiahina udedewei vavaneiu ai wava kikitui wayahi, akanai dewaia udedewei taua wayahiu deinake.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na‑iakwa, e taui akeniua ana‑vona, ‘Itomi uni‑tawaneu! Itomi nau‑iaiava Amau wayahina uvihahaiei. Wayahina, avaha bwanata taina uvaniahei. Akanai una‑ne ai ananata‑vavaha nihenina. Yaubada yami pai maꞌ vo‑vi‑aiaia Satana tauna yanꞌ anelose nui wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iuna yauke am navovo, ka eha aitam aviani uta‑veneu anꞌ‑am. Ka magau ayaya, ka eha aitam aviani uta‑veneu ana‑nim. ");
INSERT INTO mvn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka yauke abwanibwani, ka eha uta‑voneu, “Evane‑mei, baina emamaei.” Ka yauke eha au kwama, kate eha ami kwama uta‑nau‑patau. Ka yauke avi‑kwanaha, kadu yauke manua yohona nihenina yohoyohoniu amamaei, kate itomi eha uta‑dune‑viviniu.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ka taui ina‑vona, ‘Kauvea, kaiwadi, avi tuta wayahina adueyem am enavovo, o magam ayaya? O avi tuta wayahina adueyem ebwanibwani, o eha am kwama? O avi tuta wayahina adueyem evi‑kwanaha, o manua yohona nihenina emamaei?’ ");
INSERT INTO mvn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ka yauke ana‑vona, ‘Memeanina nuami vi‑tupatupa, kate avonemi, nonova avi dewa ahiahina nau‑wawanimi udedewe vavaneiu ai wava kikitui wayahi, ka uvihahaiei, eha uta‑dewe, akanai uvihahaieu deinake, eha uta‑dewe wayahiu.’ ");
INSERT INTO mvn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ka taui goyogoyoi ai nau‑pata dewa‑yaiyai‑vavaha ivaniahei deina. Ka taui tunutunuhi ai nau‑pata yawai‑vavaha ivaniahei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ka ya vona mamanaina tanoi iakwa, e Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Avaha uanamanei auyewa ainua na‑iakwa, e Itouvuha Toneina vinꞌ‑omo. Ka tuta‑nana wayahina yauke, Tauna Vi‑tomotau, inꞌ‑am‑veneneyeu, e ai nahenahea itutu‑pwatau.” ");
INSERT INTO mvn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka tau vi‑nomu mata‑genai, ka me Isiraeli yai tau eta‑naonao iomo tau vi‑nomu ananina, ana wava Kaiapasi, ya manua ani‑vainena wayahina, ka inau‑hohona, ");
INSERT INTO mvn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ka ivi‑nua‑hauhau medeina yai vitupu wayahina Iesu ipoyꞌ‑avini ina‑nau‑vi‑anigi. Kadu yai etawana ivo‑vi‑aiai deina. ");
INSERT INTO mvn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka iawaeha, e ivona, “Eha tonei ana tuta nihenina kavunui. Aituhu kadewei deina, apaina tomotau inua‑goyo, ka ivitana‑wahewahe ananina, ka vitana ananina inau‑vevewanei wayahika.” ");
INSERT INTO mvn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka Iesu meagai Betani wayahina mamaei. Ka meagai‑nana wayahina aitam onoto ana wava Simoni mamaei, ka yaiana ivi‑wahani “Simoni Tau Lepero” iuna nonova muya lepero ininina epei, kate a lepero avaha iakwa. Ka Iesu tauna nui imamaei ya manua nihenina. ");
INSERT INTO mvn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ka Iesu yaiana nui iamam. Ka aitam vavine omo manua‑nana wayahina, ka aitam gam omanei, ka gamna vivane hanu ana wava alabasiteraV wayahina inau‑vevewanei, ka nihenina daudau manina ahiahina mamaei, ka patana ani‑vainena. Akaka vavinena omo Iesu wayahina, e daudauna Iesu unununa wayahina ito‑iwaha‑yehai. ");
INSERT INTO mvn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ka avaha a tau vi‑muni‑waiwai dewana idueyei, taui inua‑goyo vavinena wayahina, ka taui matataui ivonavona, “Ia! Daudauna patana ani‑vainena, ka vavinena daudauna habuhabuna ito‑iwaha‑kavokavovo iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aituhu daudauna katꞌ‑aimwaneye, patana ani‑vainena kata‑vaniahe, e tau payapayaya kata‑vene. Dewana vidoha deina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ka Iesu avaha yai nuanua tanoi anamanei, ka vi‑tanaiei, ivona, “Aviani wayahina vavine taina uapa‑goyogoyoei? Ya dewana wayahiu vinꞌ‑omo ya dune‑nuanuai wayahina, ka yauke anau‑kaiwei dewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tuta tepakaia wayahina tau payapayaya nui umamaei auyewa aitamoata aitamoata wayahia. Kate yauke eha deina. Tuta kutakutana ana heta wayahina nui kamamaei. ");
INSERT INTO mvn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ka tutana daudauna ininiua ito‑iwahi, tauna ininiu vo‑vi‑aiaia au unuvovo wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ka memeanina nuami vi‑tupatupa, kate avonemi, tuta tepakaia wayahina, aveta baina wayahina tomotau vaneau ahiahina inau‑waheyei, vavine taina ya dewana itomatomani, ka vavine taina anꞌ anamana ivo‑vi‑natei deina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iakwa, e aitam a tau vi‑muni‑waiwai ai yau 12 wayahia ni‑tawanei, e omo tau vi‑nomu mata‑genai wayahia. Tauna ana wava Iudasa me Kariota. ");
INSERT INTO mvn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ka Iudasa vi‑tanaiei, ivona, “Aituhu Iesu avi‑nua-hauhauei, e aituhu anꞌ‑am‑veneneyei nimamia, ai vi‑am kina au nau‑pata wayahina uveneu?” Ka taui iawaehei a nau‑pata vivane 30 kina silivaV wayahina, ka auyewana iaiavi nimana. ");
INSERT INTO mvn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ka babau‑nana wayahina Iudasa vi‑putu dunedune tuta ahiahina na‑vaniahei, e vi‑nua‑hauhauei nimaia. ");
INSERT INTO mvn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Itouvuha Toneina a vi‑manamana vivane auyewa ai yau 8. Ka auyewa naona wayahina, Iesu a tau vi‑muni‑waiwai iomo wayahina, e ivi‑tanaiei, ivona, “Medeina yam nuanua Itouvuha Toneina amna wayahina? Aveta baina avo‑vi‑aiaia kanꞌ‑ania?” ");
INSERT INTO mvn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka Iesu aitam onoto ana wava tomani, ka vonei, “Una‑ne Ierusalem wayahina, ka onotona umataedei deina, una‑vona, ‘Yama tau viwavenena ivona, “Yau tuta ananina avaha vinꞌ‑omo. Wayahina, yau nuanua yauke au tau vi‑muni‑waiwai nui anꞌ‑omo wayahima, e Itouvuha Toneina anꞌ‑am yam manua nihenina.” ’” ");
INSERT INTO mvn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ka a tau vi‑muni‑waiwai ine, e ya vonana ivi‑ateteyei, e Itouvuha Toneina anꞌ am ivo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Munia babau avaha ionu iakwa, e Iesu tauna a tau vi‑muni‑waiwai ai yau 12 nui avaha inau‑hohona manua‑nana nihenina, e aniani awaniana idaudauva. ");
INSERT INTO mvn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka iamam, e Iesu vonei, “Memeanina nuami vi‑tupatupa, kate avonemi, aitam wayahimia evi‑nua‑hauhau.” ");
INSERT INTO mvn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka taui avaha inononi, inua‑vita ananina. Ka aitamoata aitamoata wayahia ivi‑tanatanaiei, ivona, “Kauvea, kaiwadi, yauke?” ");
INSERT INTO mvn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ka Iesu vona‑nau‑patei, ivona, “Tauna au niau aitam, ka nui amam biahoi aitamoata wayahina, kate apaina vi‑nua‑hauhau au havia wayahia. ");
INSERT INTO mvn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nonova Iginuma nihenina tau apa‑taputapu Tauna Vi‑tomotau yanꞌ aniga iapa‑taputapuei. Ka yauke, Tauna Vi‑tomotau, anꞌ‑aniga apa‑taputapu‑naia deinake. Kate aioi tauna vi‑nua‑hauhau wayahina! Iuna tauna a dewa‑yaiyai ananina, kadu ya ini‑yauyau ananina na‑vaniahei. Aituhu eha ta‑tupua, tauna ta‑vidoha deina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ka Iudasa, tauna vi‑nua‑hauhauei, ivona, “Tau Viwavenena, vona tunuhina, eha yauke?” Ka Iesu ivona, “Ika, wamke. Iuna avaha eawaehei deina, a?” ");
INSERT INTO mvn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ka iamam, ka Iesu palaua aitam epei, nau‑kaiwa Yaubada wayahina, pakeua, e a tau vi‑muni‑waiwai venei. Ka vonei, “Unꞌ‑epei, unꞌ‑ania. Taina ininiu.” ");
INSERT INTO mvn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iakwa, e tauna aitam vei na wainaV epei, nau‑kaiwa Yaubada wayahina, e venei. Ka ivona, “Habuhabumi vei taina wayahina una‑nim. ");
INSERT INTO mvn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Taina dayahiu. Yauke aito‑iwahi, ka awaeha vovouna avevewanei tomotau habuhabui wayahi. E taui yai goyona a nua‑piahi avi‑maiei deina. ");
INSERT INTO mvn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vona ahiahina avonemi, auyewa ataina na‑iakwa, e wainaV habuhabuna avihahaiei a itoava auyewana wainaV vovouna kana‑nim Amau ya pai veimea nihenina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dewana munina, aitam ahe pai awa‑dava Yaubada wayahina iahei. Iakwa, e manua‑nana ini‑tawanei, ine Oya Olive wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ka Iesu vonei, ivona, “Ioyoma taina habuhabumi yami vitumahana na‑ihanua, iuna dewaia ivinꞌ‑omo yauke taua wayahiua, ka uni‑tawaneu una‑novo. Dewaia ivinꞌ‑omo wayahiua deinake, iuna apa‑taputapu dewaia wayahia Iginuma nihenina mamaei. Yaubada ivona, ‘SipiV a tau dune‑vi‑avina avunui, Ka sipiV habuhabui iyavuyavuta ina‑novo.’ ");
INSERT INTO mvn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka yau mini‑havine munina, yauke ana‑ne papani Galili wayahina, ka tenoke apotapotami unꞌ‑omo wayahiua.” ");
INSERT INTO mvn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka Pita ivona, “Kaiwadi, taui habuhabui ini‑tawanem, kate yauke eha. Eha aitam tuta tepakaia wayahina ana‑dewe deina!” ");
INSERT INTO mvn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka Iesu vona‑nau‑patei, ivona, “Memeanina nuam vi‑tupatupa, kate avonem, ioyoma taina wamke ena‑vona, ‘Eha Iesu atꞌ‑anamane.’ Ka yam dewa taina ededewei tuta aitonu wayahia, ka munia kamkam onotona yana tou kanononi.” ");
INSERT INTO mvn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kate Pita ivona, “Eha ana‑dewe deina. Aituhu inau‑vi‑anigiu, eha ani‑tawanem deinake.” Ka tau vi‑muni‑waiwai habuhabui ivonavona aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ka Iesu tauna a tau vi‑muni‑waiwai nui iomo aitam baguna ana wava Gedisemane wayahina, ka vonei, ivona, “Itomi ami yau 8 umanuena baina, ka yauke ana‑nei tenoke aviama.” ");
INSERT INTO mvn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka nui a tau vi‑muni‑waiwai aitonu vituei, vivane Pita, ka Sebedi natunatuna ainua. Ka tauna ana inahe vi‑putu, ka tauna nua‑vita, ka nuanua ananina dewa vitana tepana wayahina mamaei. ");
INSERT INTO mvn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Akaka tauna aitonu vonei, “Yauke nuau ivita ani‑vainena. Eha ani‑hoina anꞌ‑aniga vihana wayahina. Ami itonu nau‑wawanimi baina umamaei, e nui kadune‑vivinika.” ");
INSERT INTO mvn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ka tauna ni‑tawanei ine eha bana, ka vi‑kabubu tepana tanopia, ka viama, “Amau, aituhu ana pata, aviamem viha ana vei taina evituei wayahiua, e apaina eha avaniahe. Kate yau nuanua ananina vivane yam nuanua adedewei, ka eha nuanuau yau nuanua adewe.” ");
INSERT INTO mvn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ka tuta eha ani‑hoina iakwa, e tauna mavina a tau vi‑muni‑waiwai aitonu wayahia, ka taui iaino‑ainei. Wayahina, tauna vi‑tanaiei, ivona, “Pita, medeina? Ami itonu eha ami pata udunedune wayahiu babau aitamoata wayahina, a? ");
INSERT INTO mvn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Itomi nau‑wawanimi udune‑vivinimi, kadue uviama. Aituhu eha uviama, apaina memeanina Satana na‑nonomi, e dewa goyona udewei! Nuami wayahina uawaeha aitamoata wayahiua, kate ininimi iaihanua.” ");
INSERT INTO mvn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka tauna ni‑tawanei tuta vꞌ‑inuana wayahina, e viama. Ivona, “Amau, aituhu nau‑wawaniu viha ana vei taina ana‑nim, akanai deina. Iuna yau nuanua ananina yam nuanua avi‑ateteyei.” ");
INSERT INTO mvn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ka tutana mavi‑havine, taui iaino‑aine‑havinei vaniahai. Iuna matai dududuna. ");
INSERT INTO mvn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wayahina, ni‑tawane‑havine tuta vꞌ‑itonuna wayahina, e viama. Ka ya viama aitamoata. ");
INSERT INTO mvn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka viamana iakwa, mavina a tau vi‑muni‑waiwai wayahia, ka vi‑tanaiei, ivona, “Ia! Kaiwadi, itomi kadue udaudauva uaino‑ainemi, ka uvi‑yawai a itoava ataina wayahina? Udu! Babau‑nana omomoi. Eha ani‑hoina tau goyogoyona iomomo, e yauke, Tauna Vi‑tomotau, ipoyꞌ‑aviniu. ");
INSERT INTO mvn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Umini kana‑ne. Iuna au tau vi‑nua‑hauhau avaha omomo tenoke.” ");
INSERT INTO mvn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu vonana vonavona, ka Iudasa omo. Tauna aitam ai yau 12 wayahia. Ka yoko ananina na inamaia ka na waipaia nui iomomo. Tau vi‑nomu mata‑genai, ka me Isiraeli yai tau eta‑naonao yokoia ivi‑tunei, e Iesu ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ka Iesu a tau vi‑nua‑hauhau avaha iaiaya venei. Ivona, “Tauna amaoi vivane Iesu. Onoto‑nana upoyꞌ‑avini.” ");
INSERT INTO mvn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ka Iudasa omo tunuhina Iesu wayahina, ka ivona, “Tau Viwavenena, ioyoma ahiahina!” E Iudasa Iesu maoi. ");
INSERT INTO mvn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ka Iesu vonei, “Au niau, yam dewa ededewei, a?” Wayahina, ononotoi tupwai ivo‑kwayavoni, e Iesu ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka Iesu a tau vi‑muni‑waiwai aitam avaha dewana dueyei, yana inama epei, e tau vi‑nomu ananina ya tau paisewa aitam vunui, e tanihana upwa‑ohoi. ");
INSERT INTO mvn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kate Iesu vonei, “Yam inama a pai vi‑ai nihenina ebou‑havinei. Iuna aituhu aviyaivia yai inama iepei, apaina mani tomotau na inamaia iomo ivunui, ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ataina, aituhu yau nuanua, au pata Amau aviamei, e tauna anelose yoko ai yau 72,000 vi‑tune inꞌ‑omo wayahiua ivi‑naua wayahiu. ");
INSERT INTO mvn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kate aituhu aviama deina, eha ana pata apa‑taputapu‑naia Iginuma nihenina inꞌ‑omo inau‑yehai. Iuna Iginuma nihenina apa‑taputapu‑naia imamaei, e imai‑voneka aviani ataina idedeweyeu akanai deina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka Iesu yokoia vi‑tanaiei, ivona, “Itomi medeina na inamaia ka na waipaia uvinꞌ‑omo wayahiua upoyꞌ‑aviniu? Kaiwadi, unuanua yau tau nau‑havia habuhabui aeta‑naoi? Eha. Itomi avaha uanamaneu. Auyewa aitamoata aitamoata nihenina Manua Vito‑pota nihenina nui kamanuena, e aviwavenemi, ka eha uta‑poyꞌ‑aviniu. ");
INSERT INTO mvn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kate dewaia habuhabui ivinꞌ‑omoi iuna tau apa‑taputapu yai apa‑taputapu wayahiu nau‑wawani ivinꞌ‑omo deina.” Ka ya vonana iakwa, e a tau vi‑muni‑waiwai habuhabui inovo‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ka yokoia Iesu ipoyꞌ‑avini ineiei tau vi‑nomu ananina ana wava Kaiapasi ya manua wayahina. Iuna veimea a tau viwavenena, kadu me Isiraeli yai tau eta‑naonao avaha manua‑nana nihenina inau‑hohoni, ipotapota. ");
INSERT INTO mvn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka Pita tupwana bana mamanaina wayahina vi‑muniei, ka omo manua‑nana a tutu‑gana wayahina. Ka munia inu, e tau nau‑havia nui imanuena, iuna ya nuanua vitana matana a vi‑nua‑dadana na‑nononi. ");
INSERT INTO mvn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka tau vi‑nomu mata‑genai, kadu Sanederini yoko habuhabui inaunau‑nene tau vitupu wayahia, iuna yai nuanua tau vitupu inꞌ‑omo ivitupu Iesu wayahina, e yai hae‑nana ana pata Iesu ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka tau vitupu habuhabui iomomo, ka ihaehaeyei, kate eha Iesu ya goyona ita‑vaniahe yai hae‑naia nihenia. Pai nau‑yehata wayahina, onoto ainua ivinꞌ‑omo, ");
INSERT INTO mvn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ka ivona, “Onoto taina ivona, ‘Yauke au pata Yaubada ya Manua Vito‑pota avita‑vovoni, ka auyewa aitonu ai heta nihenia ayone‑havinei.’” ");
INSERT INTO mvn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka tau vi‑nomu ananina mini, ka Iesu vi‑tanaiei, ivona, “Medeina? Hae taina enononi? Aviani anꞌ anamana?” ");
INSERT INTO mvn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Iesu eha ya vi‑tanai ta‑nau‑pata. Wayahina, tau vi‑nomu ananina vonei, ivona, “Aveimeyem Yaubada Yawayawaina a wavea, e yau vi‑tanai taina enau‑patei. Taum vivane Tau Ito‑yavuha‑nana, Yaubada Natu‑hoina, o eha?” ");
INSERT INTO mvn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka Iesu vona‑nau‑pata, ivona, “Ika. Yam vonana deinake. Kate habuhabumi ataina unau‑hohoni baina avonemi unononi. Tuta tepakaia wayahina Tauna Vi‑tomotau ududueyeu Tauna Bagibagi‑vavaha ateina amanuena, kadu ududueyeu you nihenina amavimavina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka tau vi‑nomu ananina avaha vonana nononi, tauna ana heta ana kwama si‑yehia pai dune ya nua‑goyo wayahina, ka ivona, “Ia! Onotona ana heta avaha goyona Yaubada wayahina voneka. Eha nau‑wawanika mani hae kanononi. Akanai ataina kavi‑nua‑dadani, a? ");
INSERT INTO mvn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Itomi medeina unuanua?” Ka taui inau‑hohoni ivona, “Tauna nau‑wawani nꞌ‑aniga ya vonana wayahina!” ");
INSERT INTO mvn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ka iomo, imimini‑vivini, ka iaiwani tepana, ka nimaia ivunuvunui. Ka tupwai ipiapiahi, ");
INSERT INTO mvn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ka yai viam‑nonona wayahina ivinepei, ivona, “O Tau Ito‑yavuha. Enꞌ‑apa‑taputapueai. Koiaka vunum?” ");
INSERT INTO mvn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ka Pita atuboua manuena, ka aitam tau paisewa ahabana omo wayahina ka ivona, “Taum kadue Iesu me Galili nui adueyemi.” ");
INSERT INTO mvn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kate Pita tomotaui habuhabui mataia tana‑tavuna, ivona, “Kaiwadi. Aviani wayahina eipuipupu? Eha atꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ka Pita mini, e ine tutu‑gana awana wayahina, e kadu aitam ahabana dueyei, e yaiana vonei, “Udueyei. Onoto taina Iesu me Nasareta nui ini‑awana.” ");
INSERT INTO mvn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka Pita tana‑tavuna‑havine, kadu vona‑vanevane. Ivona, “Ataina Yaubada matana avona tunutunuhina wayahimia. Eha onotona atꞌ‑anamane!” ");
INSERT INTO mvn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tuta eha ani‑hoina munia wayahina, taui nui imimini iomo Pita wayahina, ka ivonei, ivona, “Vona tunutunuhina, avaha anamanem wamke aitam wayahia! Iuna yam ponaitu aitamoata papani‑nana wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Akaka tauna ivona, “Eha onotona atꞌ‑anamane! Aituhu avitupu, nau‑wawaniu Yaubada dewa‑yaiyaieu ananina!” Ka vo‑kwayavonina kamkam onotona toutou. ");
INSERT INTO mvn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iakwa, e Pita Iesu yana vona wayahina nuani, vivane, “Ioyoma taina wamke ena‑vona, ‘Eha Iesu atꞌ‑anamane.’ Ka yam dewana edewei tuta aitonu wayahia, ka munia, kamkam onotona yana tou kanononi.” Ka Pita ine tutu‑gana upuna, ka vi‑mohai, ka na ini‑yauyauna toutou ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mana navia ka mata‑hamwahamwanina wayahina, tau vi‑nomu mata‑genai habuhabui, ka me Isiraeli yai tau eta‑naonao habuhabui iawaeha aitamoata vivane Iesu inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wayahina, Iesu nimana iyohoni, e ineiei me Rom ai tau veimea ananina papani‑nana wayahina ana wava Pilate wayahina. Iuna yai nuanua Pilate‑nana a dewa‑yaiyai veimeyei. ");
INSERT INTO mvn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ka Iudasa, avaha anamanei mosikuna Iesu inau‑vi‑anigi, nua‑vita ya vi‑nua‑hauhau wayahina epei, e mavina tau vi‑nomu mata‑genai, ka me Isiraeli yai tau eta‑naonao wayahia, ka ya nuanua kinaia ai yau 30 na‑vene‑havinei. ");
INSERT INTO mvn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E ivona, “Avaha goyona adewei. Iuna onoto maihina wayahimia avi‑nua‑hauhauei.” Ka taui ivona, “Dewana eha aitam aviani wayahiaia. Akanai dewana yam dewa. Enuanua wayahina.” Ka kinaia ai yau 30 ivihahaiei deinake. ");
INSERT INTO mvn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wayahina, Iudasa omo Manua Vito‑pota wayahina, e kinaia haponei nihenina, e ni‑tawanei. Ka ine, e yavunaia magana tauna si‑guani, e aniga. ");
INSERT INTO mvn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka tau vi‑nomu mata‑genai‑naia kinaia ikwakwei, ka ivona, “Eha aka pata Yaubada yanꞌ am‑venena‑kavovo a pai vi‑ai nihenina kabou, iuna kina taina tomotau a nau‑vi‑aniga a nau‑pata, ka aka veimea dewana vito‑potei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wayahina, matataui ivi‑nua‑dadani kinaia wayahina aitam tau voa kunia yana tano ivi‑maiei. E tano‑nana nihenina vivane tau bwanibwani ai unuvovo itavutavuni. ");
INSERT INTO mvn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wayahina, tano‑nana ivi‑wahani, “Dayaha Tanopina” ka wava‑nana mamaei a itoava tuta ataina wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dewana wayahina taui tau apa‑taputapu ana wava Ieremia yanꞌ apa‑taputapu inau‑yehai. Nonova Ieremia ginumi deina, “Ka me Isiraeli tauna a nau‑pata iawaehei vivane kina hanu ai yau 30. ");
INSERT INTO mvn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ka kinaia iepei, e wayahia tau voa kunia yana tano ivi‑maiei. Yau Kauvea veimeyeu deina.” ");
INSERT INTO mvn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wayahina, Iesu Pilate matana ivi‑au‑mini, ka Pilate tau veimea ananina papani‑nana wayahina. Ka Pilate Iesu vi‑tanaiei, ivona, “Kaiwadi, wamke vivane me Iudea yai kiniV, ika?” Ka Iesu vona‑nau‑patei, “Taum evonavona deinake.” ");
INSERT INTO mvn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka munia, tau vi‑nomu mata‑genai, ka me Isiraeli yai tau eta‑naonao ivitevitei Pilate matana, kate Iesu eha aitam aviani ta‑nau‑pate. ");
INSERT INTO mvn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Wayahina, Pilate vi‑tanaiei, ivona, “Medeina egenuana? Hae taina am tau apa‑goyogoyo wayahia enononi. Evona‑nau‑pata o eha?” ");
INSERT INTO mvn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Iesu eha kadu vona ta‑nau‑pate, ka vaneneha‑ohota. Wayahina, Pilate nuana vi‑tupatupa ananina. ");
INSERT INTO mvn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ka ponimana aitamoata aitamoata wayahina Itouvuha Toneina ana tuta niwanina wayahina, me Rom ai tau veimea‑naia me Isiraeli iaivaitei aitam dewa awawaehina wayahina. Ka me Isiraeli yai dewa, e yoko inau‑hohona, e aitam yaiana manua yohona nihenina mamaei ivi‑nua‑dadanei, e me Rom ai tau veimea onoto‑nana na‑yavuhi wayahi. ");
INSERT INTO mvn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka tuta tanoi wayahina aitam onoto manua yohona nihenina mamaei ana wava Barabasa. Ka tomotau habuhabui ianamanei tauna tau goyona ananina. ");
INSERT INTO mvn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wayahina, tutana tomotau yoko avaha inau‑hohoni iomo Pilate wayahina, e Pilate vi‑tanaiei, ivona, “Avi onoto nuanuami ataina wayahimi ayavuhi? Barabasa o Iesu, tauna ivi‑wahani Tau Ito‑yavuha?” ");
INSERT INTO mvn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilate avaha anamanei vi‑bwanoua iana‑dibidibiei vivane Iesu na‑nau‑vi‑anigi. Wayahina, Pilate dewa‑dadani Iesu na‑yavuhi deinake. ");
INSERT INTO mvn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka Pilate manuena tau vaneneha a pai manuena hetana, ka tuta aitamoata wayahina, Pilate awana tuyeha iva‑tawanei omo wayahina, ivona, “Eha aitam aviani goyona evi‑nua‑dadani onoto maihina taina wayahina. Iuna auyewa taina avaha ama ava aepei, e onoto‑nana wayahina pai matauta ananina nihenina avaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kate tau vi‑nomu mata‑genai habuhabui, kadu me Isiraeli yai tau eta‑naonao habuhabui yokoia inau‑vi‑nehanehai Pilate iviamei Barabasa na‑yavuhi wayahia, ka Iesu na‑nau‑vi‑anigi. Ka yokoia iawaehei deina. ");
INSERT INTO mvn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka Pilate vi‑tanai‑havinei, ivona, “Ainua wayahia koiaka nuanuami wayahimi ayavuhi?” Ka taui ivona, “Barabasa!” ");
INSERT INTO mvn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Akaka Pilate vi‑tanaiei, ivona, “Aituhu deina, medeina adewei Iesu wayahina, tauna ivi‑wahani Tau Ito‑yavuha?” Wayahina habuhabui ikonukonua, “Ai nahenahea etutu‑pwatei!” ");
INSERT INTO mvn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kate Pilate vona‑nau‑patei, vi‑tanaiei, “Aviani tauna ya goyona? Avi veimea tana‑bwegei?” Ka yokoia movi natanata, ka ikonukonua, ivonavona, “Ai nahenahea etutu‑pwatei!” ");
INSERT INTO mvn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wayahina, Pilate nuana am‑haui, ka anamanei eha ana pata yokoia nuai na‑vo‑vine. Kadu tauna dueyei avaha ivi‑putu ivi‑naua. Wayahina, daudaua nimana nosia yokoia mataia, iaiaya wayahia, ka ivona, “Dewa‑yaiyai omomo onoto taina dayahina wayahina. Ka yauke maihiu. Yanꞌ aniga eha yau nuanua, kate itomi yami nuanua.” ");
INSERT INTO mvn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka yoko habuhabui ivona, “Akanai! Ahiahina aituhu dayahina patana avaniahei, ka aituhu dewa‑yaiyai dewa taina wayahina vinꞌ‑omo, akanai, itoai kadu natunatuai avaniahei!” ");
INSERT INTO mvn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ka Pilate avaha yai vonana nononi, e Barabasa yavuhi wayahia, e kadu ya tau nau‑havia veimeyei Iesu yavunaia ipiapiahi. Kadu awaehei munia itutu‑pwatei ai nahenahea. ");
INSERT INTO mvn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Akaka tau nau‑havia‑naia Iesu ineiei yai manua ananina nihenina, ana wava Paraetorium, ka yai yoko habuhabui ihone‑hohoni iomomo Iesu wayahina imimini‑vi‑avini. ");
INSERT INTO mvn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ka ana kwama imwai‑neiei, e kwama kaikaiwabona yabebenina wayahina ivi‑kwamei, aitam kiniV deina, akaka ivi‑waipoei. ");
INSERT INTO mvn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ka kunu‑nabanaba manawa na tonana wayahina imetani, ka tonana komokuku tonana a vi‑manamana deina, e unununa iboui. Ka ai iepei, e nima ateina nihenina iboui, kiniV ya pai veimea ana guna deina, e kadu iomomo matana, aei ivi‑tupa‑gum, ka ivi‑waipoei, ivonavona, “Kaiwa ananina! Wamke me Iudea yai kiniV!” ");
INSERT INTO mvn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ka kadu iaiwani, ka ai‑nana iepei, e wayahina unununa ipiahi‑havihavinei. ");
INSERT INTO mvn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ka yai vi‑waipo iakwa, e kwama kaikaiwabona wayahina imwaia, ka tauna a kwamea ivi‑weteni‑havinei, e itaini ineie. Iuna yai nuanua ai nahenahea itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ka etawana wayahina tau nau‑havia‑naia aitam onoto me Sirene, ana wava Simoni, ivaniahei, ka inau‑vi‑nehenehei Iesu anꞌ ai nahanahana nꞌ‑avanei. ");
INSERT INTO mvn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ka Simoni‑nana avanei a itoava ivinꞌ‑omo papani Goligota wayahina. (Goligota anꞌ anamana vivane “Ununu‑kabwa” meagaina.) ");
INSERT INTO mvn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ka wainaV ka apasiuma ivinei, ka ivene vivane viha eha vi‑pae ananina, kate Iesu, avaha nim‑dadana, wainanaV vihahaiei. ");
INSERT INTO mvn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ka ai nahanahana tanopia iboui, ka avaha ana kwama imwaia, Iesu ai‑nana hetana itutu‑pwatei, e ivi‑au‑mini. Iakwa, e tau nau‑havia‑naia Iesu ana kwama ivituei, e iawaehei ivimwa‑nene, ka aituhu koiaka eta‑naoi, tauna Iesu ana kwama na‑poyꞌ‑avini, vivane ana kwama. ");
INSERT INTO mvn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ka yai vimwa‑nene iakwa, imanuena, e idune‑potapota. ");
INSERT INTO mvn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka anꞌ ai nahanaha unununa wayahina pai iaiava itutu‑pwatei. Ka pai iaiava‑nana yanꞌ aniga iuna viwavenei, ivona, “iesu, me iudea yai kiniV.” ");
INSERT INTO mvn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ka kadu tau vainau ainua nui ai nahenahea itutu‑pwatei, aitam ateina, ka aitam akenina. ");
INSERT INTO mvn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ka tomotau tupwai etawana Iesu ai nahenahea ivi‑waipoei, ka ivinepei. ");
INSERT INTO mvn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ivonavona, “Ia! Ka taum am pata Manua Vito‑pota evita‑vovoni, kadu auyewa aitonu nihenia am pata eyone‑havine, a? Aituhu deina, akanai, eito‑yavuhim! Aituhu wamke Yaubada Natu‑hoina, akanai eviwaveneai deina. Ai nahenahea enꞌ‑opu‑mei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kadu tau vi‑nomu mata‑genai, ka veimea a tau viwavenena, ka me Isiraeli a tau eta‑naonao Iesu ivinepei deinake, ivona‑opuopuei ka ivonavona, ");
INSERT INTO mvn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ia! Onoto taina medeina? Tauna mani tomotau ito‑yavuhi, kate eha ana pata tauna ana heta na‑ito‑yavuhi. Ka tauna vivane papani Isiraeli ana kiniV, a? Aituhu ai nahenahea na‑opu‑mei, akanai, kavitumahanei. ");
INSERT INTO mvn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauna Yaubada vitumahanei, ka potepotei, kadue ivona, ‘Yauke Yaubada natuna.’ Wayahina, aituhu Yaubada awaeha aitamoata deina, tauna na‑ito‑yavuhi, a?” ");
INSERT INTO mvn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ka tau vainaui Iesu nui itutu‑pwatei, taui ai ai nahenahea kadue iapa‑goyogoyoei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Auyewa pouna wayahina a itoava vinanavi niwanina wayahina papani‑nana habuhabuna vi‑novanei. ");
INSERT INTO mvn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka vinanavi niwanina wayahina Iesu movina ananina wayahina vi‑hone, ivona, “Oi! Eli, Eli! Lama sabakatani.” Ka a vo‑vina vivane, “Aioi! Yau Yaubada, Yau Yaubada! Aviani wayahina evihahaieu?” ");
INSERT INTO mvn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ka tupwai tomotau nepena imimini ya vi‑hone tanoi inononi, e ivona, “Unononi. Onoto taina tau apa‑taputapu Elidia honehonei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wayahina, aitamoata wayahia visina ine banou epei, e wainaV yuyuna wayahina si‑utuvi. E aitam ai wayahina nihona tupa‑tonei, e vi‑yoyoe ivane Iesu awana, vivane ana nunui. ");
INSERT INTO mvn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka onoto‑nana yaiana ivonei, ivona, “Egenuana. Kaiwadi, mosikuna Elidia na‑omo na‑ito‑yavuhi, o eha? Akanai. Kapotapota, kadueyei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka Iesu movina ananina wayahina vi‑hone‑havine, e nuana yavuhi, yawaina iakwa. ");
INSERT INTO mvn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ka tuta aitamoata wayahina bubuna‑honota vito‑potana a pai bwaꞌ Manua Vito‑pota nihenina am‑yehi‑nuei, vi‑putu hetana ka iopu ipuna. Ka yoyoyo si‑putu, ka hanu anani iam‑vidaha‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ka kadu unuvovo habuhabui awai iam‑wae‑neiei, ka tau vitumahana habuhabui nonova inusi, imini‑havine. ");
INSERT INTO mvn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka taui unuvovoa iopu ivinꞌ‑omo. Ka Iesu ya mini‑havine munina taui kadu ini‑awana, e meagai Ierusalem inuinui, ka tomotau yoko ananina idudueyei. ");
INSERT INTO mvn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ka tau nau‑havia‑naia yai tau eta‑naonao nui Iesu idune‑vi‑avini. Ka yoyoyo idueyei, kadue dewaia habuhabuna ivinꞌ‑omo idueyei. Iakwa, e imatamatauta ananina, e ivona, “Vona ahiahina, onoto taina vivane Yaubada Natu‑hoina!” ");
INSERT INTO mvn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka meagaina wayahina vaivine habuhabui idune‑potapota, ka eha nepena, kate tupwana bana wayahina. Nonova taui Iesu nui iomo papani Galili wayahina, iuna Iesu ivi‑muniei, ka ana maꞌ inau‑vevewanei. ");
INSERT INTO mvn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ka vaivine wayahia aitonu mamae. Aitam ana wava Mari me Magidala, ka aitam wahana tauna Iamesa ka Iosepa ayoi, e kadu aitam Sebedi natunatuna ayoi. ");
INSERT INTO mvn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka vinanavi wayahina, babau eha ani‑hoina na‑onu, e tau kaikaiwabo aitam, me Arimatea, omoi. Tauna Iesu a tau vi‑muni aitam, ana wava Iosepa. ");
INSERT INTO mvn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ka tauna omo Pilate wayahina, e Iesu tau matena viamei. Ka Pilate awaehei, e ya tau paisewa veimeyei vivane ivenei. ");
INSERT INTO mvn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wayahina, Iosepa yaiana nui iomo, e Iesu tau matena iepei, e kwama lineniV kavukavuna kadu kaikaiwabona wayahina iaumei. ");
INSERT INTO mvn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","E taui tau matena Iosepa a unuvovo vovouna nihenina iboui. Ka nonova Iosepa ya tau paisewa unuvovo‑nana iaikayoi, guba oya nihenina deina. Ka pai nau‑yehata wayahina hanu ananina ka am‑vivinina wayahina unuvovo awana ibou‑potei. Iakwa, e Iosepa unuvovo‑nana ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka Mari me Magidala wahana nui ainua unuvovo nepena imanuena, ka ivi‑kovekovei. ");
INSERT INTO mvn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ka Iesu itutu‑pwatei me Isiraeli yai auyewa pai vo‑vi‑aiai wayahina. Ka mana navia yai auyewa tapanono wayahina, tau vi‑nomu mata‑genai, ka Parisi yoko habuhabui nui iomo Pilate wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","E ivona, “Bada, tau vitupu‑nana, nonova yawayawaina mamaei, ka yana vona anuani, ivona, ‘Auyewa aitonu iakwa, e anigea amini‑havine.’ ");
INSERT INTO mvn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wayahina, aituhu memeanina wayahima, eveimeyei tauna a unuvovo a tau dune‑vi‑avina idune‑potepotei a itoava auyewa aitonu na‑iakwa wayahina. Aituhu eha, apaina a tau vi‑muni‑waiwai inꞌ‑omo, e tau matena inꞌ‑avanei, ina‑novoei, ka tomotau ina‑nonoi vivane anigea avaha mini‑havine. Ka deinake vitupu vꞌ‑inuana vitupu naona goyo‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ka Pilate vonei, ivona, “Akanai. Tau dune‑vi‑avina uveimeyei ina‑ne, e unuvovo‑nana idune‑pota‑vidovidohei.” ");
INSERT INTO mvn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Akaka onoto‑naia iomo unuvovo‑nana wayahina, ka hanu‑nana awana bou‑potei hetana yai pai ainana iaiwaiwahi, vi‑toyoa. Kadu tau dune‑vi‑avina‑naia iveimeyei idune‑vi‑avini ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Auyewa tapanono‑nana iakwa, e mana navia, wiki vovouna anꞌ auyewa naona wayahina, ka Mari me Magidala wahana nui iomo unuvovoa tau matena inau‑vi‑taui. ");
INSERT INTO mvn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka yoyoyo ani‑vainena si‑putu, iuna Kauvea yanꞌ anelose aitam wahuma opu‑me, e tauna hanu‑nana unuvovo awana buge‑mavinei, ka hetana manuena. ");
INSERT INTO mvn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ka anelose‑nana ana due vonaina deina, ka ana kwama kavukavu‑hoina. ");
INSERT INTO mvn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka unuvovo a tau dune‑vi‑avina‑naia, avaha anelose‑nana idueyei, akaka imatamatauta ananina ya bagibagi wayahina, ka itatatava, ipeu tanopia, habuhabui tau mate deina. ");
INSERT INTO mvn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka anelose‑nana vaivine‑naia vonei, ivona, “Eha umatamatauta. Avaha anamanei uomo Iesu tauna avaha inau‑vi‑anigi unenenei. ");
INSERT INTO mvn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kate tauna eha baina. Iuna avaha anigea mini‑havine, nonova mai‑vonemi deina. Unꞌ‑omoi, ka ya pai dauva awakabina udueyei. ");
INSERT INTO mvn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na‑iakwa, uvisina una‑ne, e a tau vi‑muni‑waiwai umataedai, uvonei, una‑vona, ‘Tauna avaha anigea mini‑havine, ka mai‑neine papani Galili wayahina. Tanoi una‑nei udune‑havinei.’ Ana pata deina. Avaha amataedami.” ");
INSERT INTO mvn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wayahina, vaivine‑naia yai matauta nui kadue yai dewa‑haiawa nui unuvovo ini‑tawanei, ka ivisi‑kwayavoni imavine Iesu a tau vi‑muni‑waiwai wayahia imataedai. ");
INSERT INTO mvn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka etawana inau‑bwanunua, ka Iesu vaniahai, e tauna vonei, “Mana‑putu ahiahina.” Ka taui iomo, e ivi‑tupa‑gum, ka aena ivo‑dadani, ka iaiwaodu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka Iesu vonei, ivona, “Eha umatamatauta. Una‑ne, e yaiau umataedai ina‑ne papani Galili wayahina, e tanoi idueyeu.” ");
INSERT INTO mvn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vaivine‑naia etawana ineine, ka tuta aitamoata wayahina unuvovo a tau dune‑vi‑avina‑naia tupwai ine meagai Ierusalem wayahina. Ka aviani vinꞌ‑omoi ihaeyei tau vi‑nomu mata‑genai wayahia deina. ");
INSERT INTO mvn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wayahina, tau vi‑nomu‑naia, ka me Isiraeli yai tau eta‑naonao inau‑hohona. Ka yai vi‑nua‑hauhau ivo‑vi‑aiaia, e imavina tau nau‑havia‑naia wayahia, e iana‑dibidibiei, ka kina habuhabuna ivenei. ");
INSERT INTO mvn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ka iveimeyei ivitupu. Ivona, “Aituhu tomotau ivi‑tanatanaiemi aviani vinꞌ‑omo wayahina, nau‑wawanimi una‑vona, ‘Ioyoma pouna itoai aino‑aineai, ka a tau vi‑muni‑waiwai iomo, e tau matena ivainaui.’ ");
INSERT INTO mvn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Una‑vona deinake, ka aituhu Pilate vaneana taina nononi, akanai itoai aivaitemi, anonoi, e tauna vitumahaneai. Apaina tauna eha dewa‑yaiyaiemi.” ");
INSERT INTO mvn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Akaka tau nau‑havia‑naia iawaehei kinaia iepe, e ivitupu deinake. Ka me Iudea habuhabui vitupu taina inononi, ka auyewana wayahina a itoava tuta ataina wayahina viviwava‑nana ivitumahanei, kadue inau‑viviwavei. ");
INSERT INTO mvn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka Iesu a tau vi‑muni‑waiwai ai yau 11 iomo papani Galili wayahina. E ivane oya‑nana Iesu haeyei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ka Iesu idueyei, e wayahina iaiwaodu, kate tupwai wayahia iva‑hamwahamwana. ");
INSERT INTO mvn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka Iesu omo wayahia, e vonei, ivona, “Amau avaha veimea habuhabuna wahuma kadu tanopia veneu aveimeyei. ");
INSERT INTO mvn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wayahina, una‑ne, e papani habuhabui wayahia unaunau‑wahe, ka tomotau uviwavenei taui nau‑wawani ivitumahaneu, kadu ivi‑muni‑waiwaieu. Ka kadue uvi‑bapitaisoei Amau a wavea, ka Natuna a wavea, ka kadu Nuana Ahihinata a wavea. ");
INSERT INTO mvn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ka nua‑uya habuhabuna avaha avenemi, uviwavenei taui kadu nau‑wawani ivi‑ateteyeu. Vona ahiahina, tuta habuhabuna yauke nui kamamaei, ataina wayahina a itoava tanopi anꞌ auyewa pai nau‑yehata wayahina.” Ana pata deina. Yauke Mateu ");
INSERT INTO mvn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesu Tau Ito‑yavuha, Yaubada Natuna, Vaneana Ahiahina vi‑putu vona taina wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yaubada ya tau apa‑taputapu ana wava Isaia Yaubada yana vona ginumi deina, ivona, “Apaina yau tau mataeda avi‑tunei, e tauna eta‑naoem, e yam etawana na‑hadani,” ");
INSERT INTO mvn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“e tauna anata nihenina vi‑honehone, ‘Kauvea ya etawana uhadani, tauna ya paisewa uvo‑vi‑meani.’” ");
INSERT INTO mvn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ka Ioni Tau Vi‑bapitaiso omo, e apa‑taputapu‑nana nau‑yehai. Tauna anata mamaei, ka tenoke tomotau vi‑bapitaisoei ka nau‑waheyei deina, ivona, “Nau‑wawanimi yami goyona uhaeyei, ka wayahia unua‑vinana. Na‑iakwa, avi‑bapitaisoemi, ka Yaubada yami goyona na‑nua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka tau vi‑meagai habuhabui papani Iudea nihenina, ka habuhabui meagai Ierusalem wayahina ine Ioni wayahina Daudau Ioridani wayahina. Ka avaha yai goyona ihaeyei, e Ioni vi‑bapitaiso‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ka Ioni ana kwama moimoiana a nau‑vevewana kameliV vutuvutuna wayahina, ka dobwana a haiona bulumakauV wagana wayahina weteweteni, ka tauna ana maꞌ wakipou ka mamau udaudana ai daudau. Ana kwama kadu ana maꞌ eha mani tomotau ai kwama ahiahina o ai maꞌ ahiahina deina. ");
INSERT INTO mvn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ka Ioni ya nau‑wahe deina, ivona, “Tauna bagibagi‑tawaneu omomo, ka eha nau‑wawaniu ana‑iwaodu ae‑yapayapana ai pai yohona ayavuhi, iuna tauna ana wava au wava vane‑tawane‑vainei. ");
INSERT INTO mvn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tuta ataina wayahina yauke daudaua avi‑bapitaisoemi, kate apaina tauna Nuana Ahihinata wayahina vi‑bapitaisoemi.” ");
INSERT INTO mvn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ka Iesu ya meagai naona Nasareta, papani Galili nihenina. Ka tauna ya meagai ni‑tawanei, e omo Daudau Ioridani wayahina, iuna ya nuanua a bapitaiso vaniahei Ioni wayahina. Ka Ioni Iesu vi‑bapitaisoei Daudau Ioridani nihenina. ");
INSERT INTO mvn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ka tutana Iesu daudaua tube vi‑ata, tauna dune‑vane, e wahuma dueyei am‑yehi‑nuei, ka Nuana Ahihinata bunebune deina opu‑me, e Iesu wayahina itoha. ");
INSERT INTO mvn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka wahuma aitam movi vinꞌ‑omo, ivona, “Wamke Natu‑hoiu, ka adune‑nuanuaiem. Taum wayahim adewa‑haiawa ananina.” ");
INSERT INTO mvn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ka tuta aitamoata wayahina Nuana Ahihinata Iesu vi‑tunei inei anata. ");
INSERT INTO mvn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ka auyewa ai yau 40 nihenia anata mamaei ka auyewaia nihenia Satana omo wayahina, e nau‑dadana‑havihavinei. Ka tenoke Iesu pono udaudana nui imamaei, ka anelose iomo wayahina iaivaitei. ");
INSERT INTO mvn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka avaha Erodi Ioni yohoni, e Iesu omo papani Galili inui, ka tauna Yaubada Vaneana Ahiahina naunau‑wahei, ");
INSERT INTO mvn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","vonavona, “Tuta pai vo‑vi‑aiai avaha iakwa, ka Yaubada ya pai veimea avaha omo niwanikaia. Wayahina, nau‑wawanimi unua‑vinana, e Vaneana Ahiahina uvitumahanei.” ");
INSERT INTO mvn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ka Navu Galili wayahina Iesu tania ni‑awana, ka Simoni ka vaneina Aniduru dueyei agida ivivi‑ai navua, iuna taui tau nau‑agida. ");
INSERT INTO mvn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka Iesu vonei, ivona, “Unꞌ‑omoi, uvi‑muni‑waiwaieu, e aviwavenemi unau‑agida tomotau wayahi.” ");
INSERT INTO mvn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ka ivo‑kwayavoni yai agida ini‑tawanei, e Iesu ivi‑muni‑waiwaiei. ");
INSERT INTO mvn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ka tauna neine, e Sebedi natunatuna ainua ai wava Iamesa ka Ioni dueyei, ka taui kadu wae nihenina imamaei yai agida iauya‑numi. ");
INSERT INTO mvn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ka Iesu hone‑kwayavoni. Ka taui amai Sebedi tauna ya tau paisewa tupwai nui wae nihenina ini‑tawanei, e Iesu ivi‑muni‑waiwaiei. ");
INSERT INTO mvn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ka meagai Kapenaum inui, ka tutana auyewa tapanono vinꞌ‑omo, tauna yai pai nau‑hohona inui, e ya viwavenena vi‑putui. ");
INSERT INTO mvn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ka me Kapenaum nuai vi‑tupatupa ya viwavenena wayahina, iuna Iesu wayahina viwavenena anꞌ awaeha mamaei, ka tauna viwavenei tunuhina kadu bagibagina, eha tau ginuma yai viwavenena ihanuana deina. ");
INSERT INTO mvn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka babau‑nana wayahina aitam onoto pai nau‑hohonana nihenina mamaei, ka nua gawagawamina avaha onotona inui mamaei, ka nua‑nana onotona yawaina veimeyei. Ka movina ananina wayahina nua‑nana Iesu vi‑honei, ");
INSERT INTO mvn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ivona, “Iesu, tevana Nasareta! Aviani iuna eomoi baina? Kaiwadi, eomo evita‑vovoniai, a? Ika, avaha anamanem. Taum vivane Yaubada Yanꞌ Onoto Ahihimata.” ");
INSERT INTO mvn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kate vona panina wayahina Iesu nua‑nana ya vonana vito‑potei, ivona, “Egenuana, ka onoto taina eni‑tawanei!” ");
INSERT INTO mvn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka avaha nua goyo‑nana onotona bebewei, ka konua ananina, e ni‑ubau iopu wayahina, e ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka tomotaui habuhabui nuai vi‑tupatupa ananina. Ka dewana wayahina ivi‑tanatanaiei, ivonavona, “Dewana aviani? Kaiwadi, viwavene‑nana vovouna, ka tunuhina, ka bagibagina! Ika, tauna wayahina awaeha mamaei, e nua gawagawami veimeyei, ivi‑ateteyei.” ");
INSERT INTO mvn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ka Iesu vaneana ni‑kwayavoni meagai habuhabui papani Galili nihenina wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ka pai nau‑hohonana wayahina ini‑ubau iopu, e ine tunuhina Simoni ka Aniduru ainua yai manua wayahina, ka Iamesa Ioni ainua nui inui. ");
INSERT INTO mvn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ka Simoni nawana idaudauva ivi‑kwanaha genanavina, ka Iesu a tau vi‑muni‑waiwai iomo tauna wayahina, ivoneyei. ");
INSERT INTO mvn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka Iesu omo vavinena wayahia, e nimai vo‑vi‑avini, e vavinena si‑vi‑mini. Ka genanavi‑nana am‑niniei, ividoha. Wayahina, vavine‑nana imini, ai maꞌ ivo‑vi‑aiaia, iboui, e Iesu yaiana nui iam. ");
INSERT INTO mvn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka vinanavi‑nana, avaha babau ionu, tau vi‑meagai‑naia tau kwanakwanaha yoko iomanei Iesu wayahina, ka kadu aituhu aviyaivia nihenia nua gawagawami imamaei, e yawai iveimeyei, taui kadu iomanei. ");
INSERT INTO mvn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ka tau vi‑meagai habuhabui manuana mataetana wayahina inau‑hohona. ");
INSERT INTO mvn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ka tauna yoko ivi‑kwanakwanaha mani muya mani muya wayahia vo‑vi‑aiaiei, ka nua gawagawami habuhabui si‑vinꞌ‑omanei. Ka eha aitam nua gawagawamina tꞌ‑awaehe na‑ipupu. Iuna nua gawagawami habuhabui avaha ianamanei vivane tauna Tau Ito‑yavuha‑nana. ");
INSERT INTO mvn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ka mana navia, mata‑hamwahamwanina wayahina, tauna mini‑kwayavoni, e anata wayahina ine na‑viama Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ka munia Simoni yaiana nui inaunau‑nene wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka avaha ivaniahei taui yai nua‑tupatupa nui ivonei, ivona, “Tomotau habuhabui inenenem!” ");
INSERT INTO mvn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka tauna vonei, ivona, “Nau‑wawanika meagai nepekaia wayahia kani‑keyekeyeka, ka tau vi‑meagai tanoi kadu anaunau‑waheyei. Paisewa taina vivane pai mini ananina ka kadu iuna ananina aomo tanopia.” ");
INSERT INTO mvn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ka papani Galili habuhabuna nihenina ni‑awana, ka tauna tau vi‑meagai yai pai nau‑hohona tunina tunina nihenia naunau‑waheyei, ka nua gawagawami si‑vinꞌ‑omanei tomotau‑naia wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka aitam tau lepero omo Iesu wayahina, ka aena vi‑tupa‑gumi, e viama wayahina, ivona, “Avaha anamanem am pata, ka aituhu yam nuanua, kaiwadi evo‑vi‑aiaieu?” ");
INSERT INTO mvn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ka Iesu onotona dune‑nuanuaiei, ka nimana tunei vo‑dadani, ka vonei, ivona, “Nuanuau. Evidoha.” ");
INSERT INTO mvn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ka vo‑kwayavoni a lepero ni‑tawanei, ka vidoha. ");
INSERT INTO mvn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ka vona panina wayahina Iesu nau‑vi‑avini, ka vi‑tune‑kwayavoni, ");
INSERT INTO mvn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ivona, “Edu! Eha aitam tomotau yam vidoha evoneyei. Kate ena‑ne tau vi‑nomu wayahina, ka taum eviwavenei. Ka avi dewa Mosese ya veimea veimeyem yam vidoha wayahina, dewana enꞌ‑am‑veneneyei, aitam pai dune tomotau wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kate onoto‑nana Iesu movina eha ta‑vi‑munie. Tauna ine, e ya vidoha wayahina ivona ananina, ka ipupu‑kavokavovoei. Ka onoto‑nana ya dewana iakwa, e Iesu eha ana pata aitam meagai wayahina na‑nu tau vi‑meagai mataia. Iuna taui yai nuanua ananina idudueyei. Wayahina, avi tuta inononi Iesu yai meagai nihenina mamaei, inau‑bwanunua, inau‑hohona, ivitana‑wahewahe. Wayahina, tauna nau‑wawani ana nihenia mamaei, kate tomotau papani habuhabui wayahia inaunau‑nene ka iomomo Iesu wayahina ana nihenia. ");
INSERT INTO mvn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ka auyewa aitonuata iakwa, Iesu mavina tauna ya meagai Kapenaum wayahina ka mamaei, ka tomotau vaneana inononi. ");
INSERT INTO mvn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka tomotau habuhabui inau‑hohona. Wayahina, eha yai pai maꞌ, kadu manua awana imaꞌ‑potei. Ka tauna Yaubada yana vona nau‑waheyei. ");
INSERT INTO mvn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka tomotau tupwai iomo, ka tau penapena aitam nui iomanei, a tau avana ai yau na nau‑punina. ");
INSERT INTO mvn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka eha memeanina inꞌ‑omo nepena, iuna yokoia ananina ibou‑potai. Wayahina, taui ivane manua hetana a nau‑peuna, e kwanana upuna mamaei isi‑nai. Ka avaha ibwegei, e tau penapena tauna a pai dauva nui ivi‑yoyoei iopu Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ka Iesu, avaha tau avanaia yai vitumahana dueyei, tau penapena vonei, ivona, “Natu, yam goyona avaha anua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka Yaubada ya veimea a tau viwavenena tupwai manua‑nana nihenina nui imanuena, ka taui nuai nihenina inuanua, ");
INSERT INTO mvn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aviani wayahina onoto taina ivona deina? Tauna ya vonana wayahina Yaubada apa‑goyogoyoei. Koiaka ana pata yaka goyona nꞌ‑epa‑yavunei? Yaubada ana heta!” ");
INSERT INTO mvn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ka vo‑kwayavoni Iesu tauna nuana nihenina taui yai nuanuaia anamane‑yehai. Wayahina vonei, ivona, “Aviani iuna nuami nihenina dewaia unuenueyei? ");
INSERT INTO mvn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Avi dewa dewa ainua taina wayahia memeanina? Kaiwadi, aituhu tau penapena avonei, ‘Yam goyona avaha anua‑piahi’, eha aitam aviani ududueye, a? Ka aituhu avonei, ‘Emini, ka yam pai dauva eavanei, e ena‑ne’, au awaeha mamaei, a? ");
INSERT INTO mvn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ka pai vo‑vi‑tupana avenemi, unꞌ‑anamaneu yauke, Tauna Vi‑tomotau, au awaeha mamaei tanopia goyona anua‑piahi.” Wayahina, tau penapena vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Avonem, emini, ka yam pai dauva eavanei, e ena‑nei yam manua.” ");
INSERT INTO mvn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ka tau penapenana mini, ka ya pai dauva avane‑kwayavoni, ka yoko mataia iopu ine. Ka dewana wayahina taui habuhabui nuai vi‑tupatupa, ka Yaubada iawa‑davei, ivonavona, “Tuta nonova wayahina a itoava tuta ataina wayahina eha aitam tuta dewaia deina kata‑dueye.” ");
INSERT INTO mvn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ka Iesu iopu‑havine Navu Galili awaniana wayahina, ka yoko habuhabui iomo tauna wayahina, ka tauna viwavenei. ");
INSERT INTO mvn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ka tutana neine, tauna Alipaeusi natuna ana wava Levi dueyei takesiV a pai vi‑ai wayahina manuena. Ka vonei, ivona, “Evi‑muni‑waiwaieu.” Ka tauna mini, e vi‑muni‑waiwaiei. ");
INSERT INTO mvn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ka munia Iesu manuena Levi ya manua nihenina ka amam. Ka takesiV a tau nau‑hohona yoko ka tau goyogoyona yoko nui Iesu ivi‑muniei. Wayahina, habuhabui yokoia ainuai wayahia tauna nui imanuena ka iamam. (Tuta tuta Parisi yokoia ainuai imana‑giboei.) ");
INSERT INTO mvn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka Parisi yai tau ginuma idueyei Iesu takesiV a tau nau‑hohona ka tau goyogoyona nui iamam. Wayahina, taui Iesu a tau vi‑muni‑waiwai ivi‑tanaiei, ivona, “Aviani iuna tauna takesiV a tau nau‑hohona ka tau goyogoyona nui iamam ka inimnim?” Vi‑tanai‑nana wayahina kadu Iesu imana‑giboei. ");
INSERT INTO mvn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka avaha Iesu yai vi‑tanai‑nana nononi, aitam vona tana‑minikuna wayahina vona‑nau‑patei, ivona, “‘Aituhu aviyaivia ibagibagi, taui eha nau‑wawani dokitaV ihone na‑ivaitei, kate tau kwanakwanaha ai heta nau‑wawani dokitaV ihone na‑ivaitei.’ Yauke eha ata‑omo iuna yau nuanua tau tunutunuhi ahonehone, kate aomo tau goyogoyona ai heta ahonehonei.” ");
INSERT INTO mvn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ka Ioni Tau Vi‑bapitaiso a tau vi‑muni‑waiwai idewa‑didiguna, ka kadu Parisi yai dewa aitamoata deina, ka Yaubada iawa‑davedavei dewana wayahina. Ka tupwai tomotau iomo Iesu wayahina, e ivi‑tanaiei, ivona, “Aviani wayahina Ioni a tau vi‑muni‑waiwai ka kadu Parisi ai tau vi‑muni‑waiwai idewa‑didiguna, kate am tau vi‑muni‑waiwai eha?” ");
INSERT INTO mvn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ka Iesu vonei, ivona, “Tau tavine onotona yaiana nui eha nau‑wawani ivi‑mohai, kate nau‑wawani idewa‑haiawa. Wayahina, tutana taui tau tavine onotona nui imamaei, eha memeanina wayahia idewa‑didiguna. ");
INSERT INTO mvn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka tuta tepakaia wayahina, aitam auyewa omomo, ka auyewana wayahina tau tavine onotona tauna yaiana na‑ni‑tawanei. Akaka auyewana wayahina yaiana idewa‑didiguna. ");
INSERT INTO mvn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Eha nau‑wawanika aitam kaleko vovouna kasi‑yehia, e kwama tutuaina wayahina katone‑pote. Iuna kaleko vovouna bagibagina, ka munia kaleko tutuaina nꞌ‑am‑yehi‑vainei. ");
INSERT INTO mvn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kadu deina, eha nau‑wawanika wainaV a pai aiwaha tutuaina nihenina wainaV vovouna kana‑iwahi. Iuna apaina wainaV vovouna punopuno nau‑vevewanei, e wainaV a pai aiwaha na‑nau‑vi‑pwaini, kadu pai aiwaha nꞌ‑am‑guani, e wainaV na‑iwaha, e ainua igoyo deina. Eha kadedewe deina. Itoka nau‑wawanika wainaV a pai aiwaha vovouna nihenina wainaV vovouna kana‑iwahi.” ");
INSERT INTO mvn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka aitam auyewa tapanono wayahina, tauna a tau vi‑muni‑waiwai nui baguna witiV nihenina ineine, ka a tau vi‑muni‑waiwai witiV uana iaiponuponui. ");
INSERT INTO mvn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wayahina, Parisi yoko tauna ivonei, ivona, “Ia! Edueyei! Aviani idedewei aka veimea vito‑potei auyewa tapanono wayahina. Aviani wayahina idedewei deina?” ");
INSERT INTO mvn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka Iesu vonei, “Kaiwadi, itomi avaha KiniV Davida yana dewa wayahina uaiaiava, a? Tutana tauna taui nui eha ai maꞌ, ka am inavovo, medeina dewei? ");
INSERT INTO mvn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tauna Yaubada ya manua inui, e palaua vitovito‑potana ania. Vona ahiahina, aitam veimea mamaei, e veimeana tau vi‑nomu ai heta awaehei palauana ianiania, ka tomotau kavokavovo vito‑potei. Ka udueyei. Davida eha aitam tau vi‑nomu, kate tauna ania, ka taui nui vene‑neiei, ka kadu iania. Tutana dewana vinꞌ‑omo, Abiata tau vi‑nomu ananina.” ");
INSERT INTO mvn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iakwa, e pai mini ananina vonei, ivona, “Yaubada auyewa tapanono vevewanei iuna ya nuanua tomotau ividoha wayahina. Eha tomotau ta‑vevewane auyewa tapanono a vidoha wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wayahina, yauke, Tauna Vi‑tomotau, auyewa tapanono aveimeyei.” ");
INSERT INTO mvn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ka kadu aitam tuta wayahina Iesu pai nau‑hohona inui, ka aitam onoto na nima begabegana nihenina mamaei. ");
INSERT INTO mvn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka tupwai tomotau imamaei, ka taui Iesu idune‑vi‑avini. Aituhu auyewa tapanono wayahina tauna tomotau vo‑vi‑aiaiei, taui yai nuanua ivitevitei. Iuna inuanua dewana vivane paisewa, ka paisewa habuhabuna vito‑potana auyewa tapanono wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ka tauna onotona na nima begabegana vonei, ivona, “Emini yoko mataia.” ");
INSERT INTO mvn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ka yoko wayahia vi‑tanai, ivona, “Auyewa tapanono wayahina nau‑wawanika dewa ahiahina kadedewei, o kadi dewa goyona? Kaiwadi, kavo‑vi‑aiai o kanau‑vi‑aniga?” Kate imohi‑patei. ");
INSERT INTO mvn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka Iesu magana bawe, ka dune‑nau‑nene wayahia. Ka tauna nua‑vita ani‑vainena, iuna taui eha ai pata inꞌ‑ate‑nuanuai. E onoto‑nana vonei, “Nimam etunei!” Ka tunei, ka nimana vidoha‑havine. ");
INSERT INTO mvn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Akaka Parisi yoko inua‑goyo. Wayahina, ini‑ubau iopu, e ivo‑kwayavoni ine Erodi yaiana nui wayahia, e ipuipupu wayahia medeina Iesu ina‑nau‑vi‑anigi. (Tuta nonova wayahina Erodi yaiana vivane Parisi ai havia.) ");
INSERT INTO mvn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ka Iesu tauna a tau vi‑muni‑waiwai nui iopu tania ka aitam yoko ananina papani Galili wayahina ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ka kadu mani tomotau, avaha ya dewaia habuhabui vaneana inononi, nui iomomo. Ka taui vivane papani Iudea wayahina, ka meagai Ierusalem wayahina, ka papani Idumea wayahina, ka Daudau Ioridani papanina wayahina, ka kadu meagai Taia ka meagai Sidoni wayahia. Yoko tunina tunina, ka habuhabui. ");
INSERT INTO mvn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ka tauna a tau vi‑muni‑waiwai vonei wae aya‑ketuna aitamoata ivo‑vi‑aiaia, potepotei, ana pata vi‑ata, iuna eha ya nuanua yoko tania ivi‑tunu‑havihavine. ");
INSERT INTO mvn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iuna tauna avaha tomotau habuhabui vo‑vi‑aiai‑neiei. Wayahina, tau kwanakwanaha‑naia igwagwaheyei, iuna yai nuanua ininina ivo‑dadani, ividoha. ");
INSERT INTO mvn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka aituhu avi tomotau nua gawagawami nihenia imamaei, tutana tomotaui habuhabui Iesu idudueyei, taui matana ipeupeu, na konuai ivonavona, “Wamke Yaubada Natuna.” ");
INSERT INTO mvn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka tauna vona panina wayahina vito‑potei. Eha ya nuanua taui koiaka tauna isi‑vinꞌ‑omane. ");
INSERT INTO mvn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ka Iesu ivane oya, ka aituhu aviyaivia ya nuanua, taui vi‑nua‑dadanei ka honei, e taui wayahina iomo. ");
INSERT INTO mvn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka wayahia ononotoi ai yau 12 vi‑nua‑dadanei, e vi‑wahani a tau hae anani. Ka ya nuanua taui nui ina‑maei, ka munia vi‑tunei inaunau‑wahe. ");
INSERT INTO mvn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ka tauna ai awaeha venei nua gawagawami tomotau nihenia inꞌ‑epa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ka taui habuhabui ai wava taina. Aitam Simoni vi‑wahani Pita, ");
INSERT INTO mvn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ka Sebedi natuna ana wava Iamesa, ka Iamesa vaneina ana wava Ioni, ainua vi‑wahani Boaneregesi (a vo‑vina “Anitana Natunatuna”), ");
INSERT INTO mvn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ka Aniduru, ka Pilipi, ka Baritolomeu, ka Mateu, ka Tomasi, ka Alipaeusi natuna ana wava Iamesa, ka Tadaeusi, ka Simoni aitam Kananai yai tomotau (taui manimanini ka me Rom yai veimea ivihahaiei), ");
INSERT INTO mvn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ka Iudasa me Kariota, tauna Iesu vauyei. ");
INSERT INTO mvn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ka Iesu tauna a tau vi‑muni‑waiwai nui manua inui, kate yoko ananina inau‑hohona‑havine. Wayahina, Iesu yaiana nui eha ai pata ivi‑yawai, ka eha ai pata inꞌ‑am. ");
INSERT INTO mvn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ka avaha Iesu yana yoko vaneana inononi, ivinꞌ‑omo ka yai nuanua idune‑vi‑avini. Iuna matataui ivonavona, “Vona ahiahina, tauna vi‑kwavakwava.” ");
INSERT INTO mvn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka tau ginuma Ierusalem wayahina iopu‑me, ka ivonavona, “Beelesebubi tauna nihenina mamaei. Ka tauna ya bagibagi vinꞌ‑omo nua gawagawami ai tau veimea wayahina, e bagibagi‑nana wayahina nua gawagawami epa‑yavunei.” ");
INSERT INTO mvn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ka Iesu taui hone‑hohoni, e vona tana‑minikuneyei, ivona, “Medeina Satana ana heta Satana epa‑yavunei? ");
INSERT INTO mvn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aituhu aitam pai veimea ana heta wayahina vi‑naua, pai veimeana eha ana pata mimini. ");
INSERT INTO mvn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O aituhu aitam yoko ana heta wayahina vi‑naua, yokoia eha ana pata mimini. ");
INSERT INTO mvn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","O aituhu Satana tauna yana yoko wayahia vi‑naua, tauna ana heta ya pai veimea tana‑vewani, ka eha ana pata mimini, kate ya pai veimea na‑iakwa‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pai dune taina avenemi. Onoto bagibagina ya manua Satana ya manua deina. Ka eha memeanina aitam koiaka na‑nui, e ya gugua vainaui, iuna tauna bagibagina. Kate aituhu naona aitam onoto yavunaia tau bagibagi‑nana nimana ka aena na‑yohoni, munia tauna ana pata gugua‑naia na‑vainaui. ");
INSERT INTO mvn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia yai dewa goyona wayahia inua‑vinana, dewa goyo‑naia anua‑piahi. Ka aituhu aviyaivia Yaubada imana‑giboei, kate munia inua‑vinana, akanai vonaia anua‑piahi. ");
INSERT INTO mvn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kate aituhu aviyaivia Nuana Ahihinata imana‑giboei, eha ana pata goyo‑nana na‑iakwa. Avaha goyona‑vavaha idedewei.” ");
INSERT INTO mvn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ivona deina, iuna tupwai ivonavona nua gawagawamina nihenina mamaei, ka vonana anꞌ anamana vivane Iesu Nuana gawagawamina. ");
INSERT INTO mvn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ka dewaia iakwa, tauna ayona vavaneina nui iomo, ka imimini manua upuna, ka aitam tau mataeda ivi‑tunei, na‑honei. ");
INSERT INTO mvn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wayahina, yoko imaꞌ‑gwaugwaui imataedei, ivona, “Edu! Ayom ka vavaneim vuvunaha inenenem.” ");
INSERT INTO mvn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kate Iesu tomotaui vi‑tanaiei, ivona, “Koiaka ayou, ka aviyaivia vavaneiu?” ");
INSERT INTO mvn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka Iesu taui imaꞌ‑gwaugwaui wayahia dune‑nau‑nene, e ivona, “Udu. Baina ayou ka vavaneiu imamaei! ");
INSERT INTO mvn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iuna aituhu aviyaivia Yaubada ya nuanua idedewei, tomotaui vivane vavaneiu, ka novunovu, ka ayoyou.” ");
INSERT INTO mvn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ka Iesu viwavenena‑havine Navu Galili taniana. Ka yoko ani‑vainena inau‑hohona. Wayahina, tauna waea vi‑ata‑havine ka manuena, ka yoko habuhabuna navu taniana imamaei. ");
INSERT INTO mvn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ka nua‑uya habuhabui viwavenei vona tana‑minikuna wayahia, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Unononi! Aitam tau si‑yavuyavunena ine utuna na‑si‑yavuyavunei. ");
INSERT INTO mvn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ka si‑yavuyavunei ka utuia tupwai ipeu etawana, ka manua iyaveha iomoi iania. ");
INSERT INTO mvn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka utuia tupwai ipeu hanuhanuna, wayahina eha tanopi ananina. E itabo‑kwayavoni iuna tanopi eha badobadona. ");
INSERT INTO mvn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kate avaha babau ivana‑weavi, e iwenono, iuna utuia wanohi tanopi eha ita‑vo‑vi‑avini ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka utuia tupwai mata‑duduna wayahina ipeu ka mata‑duduna itabo si‑guani ka eha ita‑ua. ");
INSERT INTO mvn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kate utuia tupwai tanopi ahiahina wayahina ipeu, ka itabo, inata, iuaua. Tupwai 30, ka tupwai 60, ka tupwai 100.” ");
INSERT INTO mvn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E Iesu ivona, “Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ka tutana Iesu ana heta mamaei, tauna a tau hae anani ai yau 12, ka kadu tupwai tomotau nui, iviamei, ivona, “Ana pata evo‑vi‑mahetei wayahiaia?” ");
INSERT INTO mvn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ka vonei, ivona, “Yaubada tauna ya pai veimea a viwavenena hivahivana avaha si‑vinꞌ‑omanei wayahimia, kate taui upuna imamaei, vona tana‑minikuna ai heta wayahia aipuipupuei. ");
INSERT INTO mvn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wayahina, nonova Yaubada a tau apa‑taputapu aitam ginumi deina, ivona, ‘Tuta habuhabuna idunedune kate eha ita‑dueye, ka ivanevaneneha kate eha ita‑nononi. Wayahina eha ita‑nua‑hau, ka eha ita‑magigino. Iuna aituhu inua‑vinana, Yaubada yai goyona na‑nua‑tavuni!’” ");
INSERT INTO mvn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","E Iesu ya nua‑vita wayahina vonei, ivona, “Ia! Vona tana‑minikunana memeanina, ka nuami eha tꞌ‑am‑hau, a? Kaiwadi, medeina mani vona tana‑minikuna una‑nua‑uye? ");
INSERT INTO mvn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tau si‑yavuyavunena Yaubada yana vona si‑yavuyavunei. ");
INSERT INTO mvn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka tupwai tomotau utuia etawana imamaei deina, ka Yaubada ya vonana inononi. Ka avaha inononi, Satana nau‑manini omo ka avi vona avaha nuai nihenina si‑yavuyavunei, tauna epei neiei. ");
INSERT INTO mvn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ka mani tomotau utuia hanuhanuna imamaei deina, ka taui, avaha vonana inononi, yai dewa‑haiawa nui iawaehei, ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kate taui eha wanohi. Wayahina, avi tuta vita ivaniahei, o avi tuta mani tomotau imana‑giboei iuna vonana ivitumahanei, eha ai pata itoha‑vi‑anai, ka vo‑kwayavonina yai vitumahana ivo‑haini. ");
INSERT INTO mvn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka mani tomotau utuia mata‑duduna nihenina imamaei deina, ka taui vonana inononi, ");
INSERT INTO mvn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ka munia yai nua‑vita nui yawai wayahi inuanua toyoina, kadu ivitumahana‑wayohe aituhu kaikaiwabo habuhabui igwaugwaui, munia idewa‑haiawa deina, kadu yai nuanua mani dewa wayahi vinꞌ‑omo aitamoata deina. Ka dewaia habuhabui vonana isi‑guani, mata‑duduna aniani isi‑guani deina, ka taui eha ina‑ua. ");
INSERT INTO mvn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ka mani tomotau utuia tanopi ahiahina imamaei deina, ka taui vonana inononi, inua‑vi‑avini, idedewei, e iuaua. Tupwai 30, ka tupwai 60, ka tupwai 100.” ");
INSERT INTO mvn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kadue vonei, ivona, “Yaka dewa medeina? Kunia kaomanei, e maheta kabou‑potei wayahina? Eha. Maheta a pai vi‑ai wayahina kaboui, e kavidoha deina. ");
INSERT INTO mvn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Avonemi deina iuna avi dewa hivahivana tomotau idedewei ataina, apaina maheta nihenina kadudueyei. ");
INSERT INTO mvn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka vonei, ivona, “Udu! Vonaia avaha unononi nau‑wawanimi unua‑vi‑avini ahiahina. Iuna aituhu yami vitumahana ananina, ami nau‑pata ananina uvaniahei, kadu hetana. ");
INSERT INTO mvn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ika, Yaubada ya nuanua aituhu aviyaivia tauna ya vonana ivitumahanei, yai nua‑uya na‑nata. Wayahina, si‑vinꞌ‑omanei, inꞌ‑anamanei. Kate aituhu aviyaivia Yaubada ya vonana ivihahaiei, avi nua‑uya nonova wayahia mamaei tauna nꞌ‑epa‑yavunei.” ");
INSERT INTO mvn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kadu ivona, “Yaubada ya pai veimea deina. Aitam onoto aniani utuna tanopia si‑yavuyavunei. ");
INSERT INTO mvn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ka munia, auyewa ka ioyoma utuia ai heta itabotabo kadu inatanata. Ka aituhu onotona daudauva o aituhu tauna mini ni‑awana, tauna yana dewa eha aitam aviani utuia wayahia. Akanai taui ai heta ai pata inatanata, ka onotona eha tꞌ‑anamane medeina yai nata. ");
INSERT INTO mvn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tanopi ana heta ana pata utuia vo‑vi‑natei. Naona gabuna, e munia yawaina, e sisina, e uana. ");
INSERT INTO mvn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ka avi tuta uana na‑hou, onotona na‑tutu‑ponuponui, iuna avaha aihana ana tuta vinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kadu ivona, “Aviani wayahina Yaubada ya pai veimea abou‑viwavei avo‑vi‑mahetemi, o kadi avi vona tana‑minikuna wayahina aviwavenemi? ");
INSERT INTO mvn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yaubada ya pai veimea mata‑sinisinina utuna deina. Mani utuna habuhabui anani, ka mata‑sinisinina utuna kikitu‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka avaha kabaguni, na‑tabo, e wetau habuhabuna nata‑tawanei. Ka nahana ananina boui, wayahina memeanina manua inꞌ‑omo, e nahana ai hiu iyoneyonei.” ");
INSERT INTO mvn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ka vona tana‑minikuna habuhabuna deina wayahia tauna Yaubada yana vona naunau‑waheyei a itoava taui ai pata wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ka ya viwavenena tomotau wayahia vona tana‑minikuna ana noe. Ka munia, avi tuta tauna a tau vi‑muni‑waiwai nui ai heta imamaei, taui wayahia vona tana‑minikunaia habuhabui vo‑vi‑mahetei. ");
INSERT INTO mvn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ka auyewana, avaha vinanavi, ka Iesu tauna a tau vi‑muni‑waiwai honei, e vonei, ivona, “Mani papania kaubo‑tamani.” ");
INSERT INTO mvn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wayahina, a tau vi‑muni‑waiwai yokoia ini‑tawanei ka waena avaha Iesu manuena nihenina, igenu, ine, ka mani waꞌ tupwai nui. ");
INSERT INTO mvn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka tuta kutakutana iakwa, e wedinia ananina hunahuna omo ka nupuna wae iwa‑tavutavuni, wayahina waena eha ani‑hoina na‑nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tauna wae munina mamaei kunuhana hetana ino‑ainei. Wayahina, inau‑vi‑dagudagui ka ivonei, “Tau Viwavenena, eha ani‑hoina kagavivina! Kaiwadi, dewana eha aitam aviani wayahima?” ");
INSERT INTO mvn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka tauna mini, e yahina awa‑tania, e nupuna vonei, ivona, “Unꞌ‑am‑paipaimi!” e yahina iakwa, mana gomana. ");
INSERT INTO mvn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E tauna a tau vi‑muni‑waiwai vi‑tanaiei, ivona, “Aviani wayahina umatamatauta deina? Kaiwadi, nonova a itoava ataina wayahina itomi eha yami vitumahana, a?” ");
INSERT INTO mvn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kate taui imatamatauta ani‑vainena, ka matataui ivonavona, “Koiaka tauna? Yahina kadu nupuna veimeyei, e movina inononi!” ");
INSERT INTO mvn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ka Navu Galili iona‑tamanei ka papani Gerasene anꞌ awa‑navua inu‑me. ");
INSERT INTO mvn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ka Iesu iopu tania. Ka papani‑nana wayahina aitam onoto guba wayahina ni‑ubau omo Iesu wayahina. Ka guba‑naia nihenia tomotau ai unuvovo. ");
INSERT INTO mvn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ka onotona nihenina nua gawagawamina aitam mamaei, ka onoto‑nana ya pai maꞌ vivane guba‑naia. Nonova tomotau iyohoni manawa kainumu wayahina, kate eha ai pata. ");
INSERT INTO mvn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Iuna tuta habuhabuna manawa kainumu wayahina nimana kadu aena iyohoyohoni, kate tauna dobwedobwei. Kadu avi kainumu vitana wayahia aena ihavini, tauna tutu‑paipaia. Onoto‑nana tomotau habuhabui bagibagi‑tawanei, ka eha ai pata iveimeye. ");
INSERT INTO mvn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ioyoma kadu auyewa, unuvovo gubaia kadu oyea konukonua kadu tauna ana heta wagana dabedabei hanu wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Onoto‑nana avaha enoma Iesu dueyei, nau‑bwanunua Iesu matana, e aena vi‑tupa‑gumi. ");
INSERT INTO mvn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ka Iesu vonei, ivona, “Nua gawagawamim, onoto taina wayahina eopu‑me!” Wayahina, nua gawagawamina konua ananina, ivona, “Iesu, wamke Yaubada‑heta‑hoina Natuna. Aviani yam nuanua edewei wayahiua? Evona‑dabadaba Yaubada a wavea eha edewa‑yaiyaieu!” ");
INSERT INTO mvn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ka Iesu nua‑nana vi‑tanaiei, ivona, “Medeina am wava?” Ka nua‑nana vona‑nau‑pata, ivona, “Ama wava LegioniV, iuna habuhabuai onoto taina nihenina amamaei.” ");
INSERT INTO mvn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ka nua‑nana Iesu viama‑havihavinei, ivona, “Eha evi‑tuneai ana‑ne mani papani wayahina. Yama nuanua papani taina nihenina amamaei.” ");
INSERT INTO mvn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ka oyaoyana nepena pono habuhabui yai pai duana. ");
INSERT INTO mvn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wayahina, nua gawagawami Iesu iviamei, ivona, “Evi‑tuneai ana‑ne ponoia, kadu eawaeheai ana‑nu nihenia.” ");
INSERT INTO mvn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ka Iesu awaehei. Wayahina nua gawagawami habuhabui onoto‑nana wayahina iopu‑me, e ponoia inui. Ka ponoia habuhabui, ai yau 2000 deina, ivisi‑bwahana, e kemana inau‑bwanubwanunua ini‑ubau navua, igavivina. ");
INSERT INTO mvn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dewana iakwa, ponoia ai tau dune‑vi‑avina inovo ine meagai ananina a tau maꞌ wayahia kadu meagai kikitui ai tau maꞌ wayahia, e vaneana imataedai. Wayahina, tau vi‑meagai‑naia iomo ai pata taui mataia aviani avaha vinꞌ‑omo idudueyei. ");
INSERT INTO mvn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ka tutana iomo Iesu wayahina, onoto‑nana idudueyei. Nonova nua gawagawami nihenina imamaei, kate tauna ya nuanua avaha tunuha, ka ana kwama weteni, mamaei ahiahina. Ka tau vi‑meagai‑naia habuhabui imatamatauta. ");
INSERT INTO mvn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka tomotaui mataia dewana idueyei yaiai wayahia iaipuipupu medeina onoto‑nana vidoha, ka medeina ponoia iainahe. ");
INSERT INTO mvn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wayahina, tau vi‑meagai‑naia ivi‑putu Iesu ihidehidei yai papani na‑ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ka Iesu opuopu waea vi‑ata. Ka onoto‑nana avaha nua gawagawami ini‑tawanei Iesu wayahina viama‑bagibagi, ivona, “Tau Veimea, yau nuanua ananina nui kani‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kate Iesu eha tꞌ‑awaehe, ka ivona, “Eha. Wamke nau‑wawanim emavi‑havine yam megeia, ka yam yoko wayahia. Ka dewaia anani Yaubada dewei wayahim, kadu tauna yanꞌ ate‑nuanuai wayahima emataedai inononi.” ");
INSERT INTO mvn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wayahina, onoto‑nana inei papani ana wava Dekapolisi, e tauna tau vi‑meagai‑naia nau‑viviwavei. Ka tomotau‑naia, avaha Iesu ya vevewana bagibagina tauna wayahina idueyei, kadu avaha onoto‑nana ya vidoha vaneana inononi, taui nuai vi‑tupatupa. ");
INSERT INTO mvn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ka Iesu tauna a tau vi‑muni‑waiwai nui iona‑tamane‑havine papani Galili anꞌ awa‑navua. Ka yoko ananina tauna awaniana inau‑hohona tania. ");
INSERT INTO mvn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ka aitam onoto omo, ana wava Iairusa. Tauna aitam manua pai nau‑hohona a tau dune‑vi‑avina. Ka onotona Iesu vaniahei, ka ya nua‑opu nui matana iwaodu ");
INSERT INTO mvn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ka viama‑bagibagi, ivona, “Kauvea, natu ahabana a kwanaha ivita, ka tauna anianiga. Nuanuau enꞌ‑omo evo‑dadani, vidoha.” ");
INSERT INTO mvn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka Iesu awaehei, e tauna nui ivi‑putu ineine Iairusa ya manua wayahina. Ka avaha ineine, e yoko ananina ivi‑muniei etawana ka ivi‑tunu‑havihavinei. ");
INSERT INTO mvn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ka yokoia nihenina aitam vavine kwanakwanahina mamaei, ka a kwanaha vivane dayahina itaina auyewa aitamoata aitamoata wayahina ponimana ai yau 12 nihenia. Kadu apaina taitaina. ");
INSERT INTO mvn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nonova a itoava auyewana wayahina vavine‑nana dokitaV habuhabui wayahia yana kina vꞌ‑iakwani kate eha ta‑vidoha. Vona ahiahina, a kwanahana nata. ");
INSERT INTO mvn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ka vavine‑nana Iesu vi‑muniei, iuna nonova tomotau ipuipupuei Iesu wayahina, e nononi. Wayahina, vavinena nuana nihenina vonavona, “Aituhu tauna ana kwama ana heta avo‑dadani, akanai yau vidoha avaniahei deina.” Wayahina, ine tauna nepena, e ana kwama vo‑dadani. ");
INSERT INTO mvn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E dayahina si‑dabana‑kwayavoni, ka vavine‑nana ininina nihenina ayaunei avaha vidoha. ");
INSERT INTO mvn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka Iesu kadu ayaunei vivane ininina wayahina bagibagina iopu. Wayahina, magigino, e yokoia vi‑tanaiei, ivona, “Koiaka au kwama vo‑dadani?” ");
INSERT INTO mvn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka a tau vi‑muni‑waiwai yai nua‑tupatupa nui ivi‑tanaiei, ivona, “Ia! Bada, avaha edueyei yoko ivi‑tunu‑havihavinem. Wayahina, aviani iuna evi‑tanai, ‘Koiaka vo‑dadaniu?’” ");
INSERT INTO mvn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka Iesu dune‑nau‑nene yoko niwanina, iuna ya nuanua koiaka dewei dueyei. ");
INSERT INTO mvn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vavine‑nana, avaha ana heta ya vidoha anamanei, Iesu wayahina omo, ya tatava kadu ya matauta nui. E vavine‑nana Iesu matana ipeu, wayahina iwaodu deina, ka yana dewa iuna haeyei ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka Iesu ivona, “Natu, yam vidoha taina evaniahei iuna evitumahaneu. Emini, ka nua gomagomanina nui ena‑ne, ka yam vidoha taina wayahina edewa‑haiawa, iuna yam dewa hidahida avaha iakwa.” ");
INSERT INTO mvn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka tutana Iesu vonavona vavine‑nana wayahina, tupwai tomotau Iairusa ya manua wayahina mataeda iomanei, ivona, “Bada, natum yawaina avaha iakwa. Wayahina, eha tau viwavenena yana tuta eoneonei. Ataina eha ana pata na‑ivaitem.” ");
INSERT INTO mvn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kate Iesu kadu mataedana nononi, ka eha ya nuanua. Wayahina, tauna Iairusa vonei, ivona, “Eha ematamatauta. Evitumahaneu akanai.” ");
INSERT INTO mvn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ka Iesu yoko habuhabui vito‑potai, iuna eha ya nuanua ivi‑munie manua wayahina. Akanai a tau hae anani aitonu nui, aina Pita, Iamesa, ka Iamesa taina Ioni. ");
INSERT INTO mvn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ka ine Iairusa ya manua wayahina, ka tutana iomoi vi‑mohai ananina inononi. ");
INSERT INTO mvn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","E Iesu manua inui, e tau vi‑mohai vonei, ivona, “Aviani wayahina uvi‑mohai ka uvitana‑wahewahe? Ahabana eha tꞌ‑aniga. Ino‑ainei akanai.” Ka Iesu avaha anamanei aviani na‑vevewanei. ");
INSERT INTO mvn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka tau vi‑mohai‑naia ivi‑nepei. Wayahina, Iesu tomotau habuhabui vo‑tahoi iopu, kate ahabana amana kadu ayona kadu a tau hae anani aitonu nui bubuna‑honota aveta ahabana daudauva nihenina inui. ");
INSERT INTO mvn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E Iesu ahabana nimana vo‑vi‑avini, e movina ivona, “Talita kumi!” ka a vo‑vina vivane “Ahabam, avonem emini!” ");
INSERT INTO mvn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ka vo‑kwayavoni ahabana mini ka ni‑awana (tauna avaha a ponimana 12 vaniahei). Ka taui Iesu nui nuai vi‑tupatupa ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ka Iesu vona panina wayahina nau‑vi‑avini, ivona, “Eha aitam koiaka wayahina uhae yau dewana wayahina.” Kadu ivona, “Ahabana anꞌ am uvo‑vi‑aiaia, uvenei, nꞌ‑am.” ");
INSERT INTO mvn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ka Iesu papanina ni‑tawanei, e mavi‑havine tauna ya megeia Nasareta, ka a tau vi‑muni‑waiwai ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ka avaha auyewa tapanono vinꞌ‑omo, tauna ine yai manua pai nau‑hohona wayahina, e vi‑putu viwavenena. Ka habuhabui yokoia nihenia inononi nuai vi‑tupatupa. Wayahina, tomotaui matataui ivonavona, “Koiaka onoto taina nua‑uya taina anꞌ awaeha venei? Ka avi nua‑uya taina, tauna ana pata dewa‑bagibagi habuhabui dedewei?” ");
INSERT INTO mvn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kadu tomotaui matataui ivi‑tanatanaiei, ivonavona, “Tauna aitam tau yona, vivane Mari natui, a? Kadue vavaneina Iamesa, ka Iosese, ka Iudasa, ka Simoni baina imamaei anamanei. Kadu novunovuna tauka nui kamamaei. Medeina tauna vane‑tawaneka?” Wayahina, tomotaui inua‑goyoei kadu ivihahaiei. ");
INSERT INTO mvn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka Iesu taui vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ka tauna ya meagai nihenina tomotau eha yai vitumahana. Wayahina, eha memeanina dewa‑bagibagi habuhabui paipaisewe tenoke. Tau kwanakwanaha aitonuata wayahia nimana bouni, e vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ka Iesu nuana venau‑tupatupa, iuna me Nasareta eha ita‑vitumahane. Ka tauna mani meagai wayahia ni‑keyekeyei ka viwavenena. ");
INSERT INTO mvn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka Iesu tauna a tau hae anani ai yau 12 hone‑hohoni, e ai awaeha venei, e taui nua goyogoyoi isi‑yavunei, e tomotau ividoha. ");
INSERT INTO mvn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ka tauna ai veimea yai nae wayahina venei. Ivona ina‑ne, eha aitam aviani nimaia, eha palaua, eha kode, kadu eha kina. Guna ana heta nimaia akanai. ");
INSERT INTO mvn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ka ae‑yapayapai ai pai yohonata iweteni, ka eha kwama ainua. ");
INSERT INTO mvn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kadu vonei, ivona, “Papani tanoi wayahia, aituhu avi meagai inau‑kaiwemi, e una‑nu manua aitamoata, e manua‑nana nihenina umamaei. Eha uaubo‑tamanemi mani manua mani manua wayahia meagai‑nana nihenina. ");
INSERT INTO mvn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ka papani tanoi wayahia aituhu avi meagai eha inau‑kaiwemi, ka aituhu tomotaui eha itainimi unꞌ‑omo yai manua nihenia, o aituhu eha yami nau‑wahe inononi, akanai meagai‑nana ai apunava aemia unau‑vutuvutuha‑yavunei idudueyei, e uni‑tawanei. Ka pai dune wayahi uvenei deina vivane ai dewa‑yaiyai Yaubada wayahina omomo.” ");
INSERT INTO mvn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ka Iesu tauna a tau vi‑muni‑waiwai ainua ainua vi‑tunei, e itutu‑vivini meagai habuhabui wayahia, e tau vi‑meagai‑naia inaunau‑waheyei vivane taui nau‑wawani inua‑vinana yai dewa goyona wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ka nua goyogoyoi tomotau wayahia isi‑yavunei, kadu tau kwanakwanaha iawa‑tunutunui wetona wayahina, e ividoha. ");
INSERT INTO mvn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ka Kini Erodi dewaia vaneana nononi, iuna tomotau habuhabui Iesu ana wava isi‑nai, ka tauna anꞌ anamana avaha nata. Ka tupwai tomotau ivonavona, “Ioni Tau Vi‑bapitaiso anigea mini‑havine. Wayahina, tauna ana pata dewa‑bagibagi‑naia dedewei.” ");
INSERT INTO mvn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka tupwai ivonavona, “Tauna Elidia.” Kadu tupwai ivonavona, “Tauna aitam tau apa‑taputapu, tau apa‑taputapu nonova imamaei deina.” ");
INSERT INTO mvn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kate Erodi, avaha vaneana nononi ivona, “Ia! Ioni, tauna otona aupwei, kaiwadi anigea mini‑havine!” ");
INSERT INTO mvn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Nonova Erodi yana dewa taina deina. Tauna vaneina Pilipi awana nemei, e tavinei. Vavinena ai wava Erodiasa. Ka dewana wayahina Ioni Erodi yapoyapoi, ivona, “Yam dewana dewa goyona. Eha ana pata vaneim awana enemei.” Wayahina, Ioni ya vonana wayahina, Erodiasa inua‑goyo Ioni wayahina, ka yai nuanua ananina Ioni ivunui, kate eha ai pata. Iuna Erodi avaha anamanei Ioni onoto tunuhina ka ahihinata, vivane Yaubada a tau paisewa ahiahina aitam. Wayahina, Erodi Ioni matamatautei kadu ya nuanua dewa goyona Ioni wayahina bou‑potei. Wayahina, Erodi tauna ya tau nau‑havia vi‑tunei ine, e Ioni ipoyꞌ‑avini, iomanei manua yohona wayahina, e nihenina iboui na‑maei. Ka tuta habuhabuna Erodi Ioni honehonei, iuna ya nuanua Ioni yana vona na‑nononi. Kate tuta aitamoata aitamoata wayahia avaha nononi, Erodi nuana venau‑tamatamana, kadu nua‑vita Ioni ya vonaia wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ka auyewa memeanina vinꞌ‑omo Erodiasa yai nuanua wayahina, vivane Erodi yanꞌ auyewa tupua wayahina. Ka tauna aniani ananina nau‑vevewanei ononotoi anani wayahi, vivane ya tau kaikaiwabo wayahi, ka havia a tau eta‑naonao wayahi, kadu Galili anꞌ ononotoi anani wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ka Erodiasa natui ahabana ana heta nu‑me, e tavona Erodi tomotaui nui wayahi. Ka tavonana taui habuhabui vo‑vi‑dewa‑haiawi. Wayahina, KiniV Erodi ahabana vonei, ivona, “Aviani yam nuanua avenem? Eviameu, ka avenem akanai!” ");
INSERT INTO mvn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kadue ya vona‑dabadaba bou hetana, ivona, “Aviani yam nuanua, eviama, avenem akanai. Aituhu yam nuanua, yau pai veimea atana‑vewani papani ainua wayahia, e aitam avenem eveimeyei.” ");
INSERT INTO mvn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka ahabana ni‑ubau iopu ayona wayahia, e vi‑tanaiei, ivona, “Ayou, aviani wayahina aviama?” Ka ayona ivona, “Ena‑ne Erodi wayahina, eviamei Ioni Tau Vi‑bapitaiso unununa wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ka visi‑kwayavoni inu KiniV Erodi wayahina, e ivona, “Yau nuanua babau taina wayahina Ioni Tau Bapitaiso unununa na nau‑kaina eveneu.” ");
INSERT INTO mvn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ka Erodi nua‑vita ananina, kate eha memeanina ta‑vihaihai, iuna avaha ya vona‑dabadaba boui yaiana habuhabui mataia. ");
INSERT INTO mvn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wayahina, Erodi tauna ya tau nau‑havia aitamoata vi‑tunei ine manua yohona wayahina, ka a veimea Ioni otona na‑upwei. ");
INSERT INTO mvn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Iakwa, e tau nau‑haviana Ioni unununa nau‑kaia omanei, e ahabana venei. Ka ahabana epei, e neiei ayona wayahina, e venei. ");
INSERT INTO mvn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ka avaha Ioni a tau vi‑muni‑waiwai vaneana inononi, iomo, e tau matena iepei ineiei, e unuvovoa iboui. ");
INSERT INTO mvn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ka Iesu a tau hae anani yai nae wayahina imavina, e inau‑hohona tauna wayahina, e taui yai dewa habuhabui kadu yai viwavenena habuhabui imataedei. ");
INSERT INTO mvn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ka Iesu vonei, ivona, “Nau‑wawanika kana‑ne enoma, ka paisewa taina kaboui, e aka heta kavi‑yawai.” Iesu vonei deina iuna tomotau yoko ani‑vainena iomomo kadu ineine. Ka tuta tuta ipaipaisewa, ka eha aitam tuta ahiahina wayahi inꞌ‑am. ");
INSERT INTO mvn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wayahina, taui ai heta waea igenu ine anata. ");
INSERT INTO mvn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kate tomotau tupwai yai nae idudueyei, ka ianamanei taui aviyaivia, ka kadu avaha ianamanei aveta baina ineine. Wayahina, tau vi‑meagai meagai habuhabui wayahia aeia inau‑bwanubwanunua, e imai‑omoi tanoi anata wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ka tutana Iesu waea iopu, tomotau yoko ananina dueyei. Ka tauna eha ta‑nua‑vita, kate ate‑nuanuaiei, iuna taui sipiV ini‑panipani deina, ka eha aitam tau dune‑vi‑avina wayahi. Wayahina, tauna vi‑putu nua‑uya habuhabuna viwavenei. ");
INSERT INTO mvn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ka tuta‑nana wayahina, babau avaha onuonu. Wayahina, a tau vi‑muni‑waiwai iomo tauna wayahina, ka ivona, “Kauvea, papani taina vivane anata, eha aitam meagai, ka babau avaha iakwa. ");
INSERT INTO mvn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wayahina, nau‑wawanim yoko taina evi‑tunei ina‑ne meagai maupwani tupwai wayahia, e tenoke ai maꞌ ivi‑maiei.” ");
INSERT INTO mvn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kate Iesu tauna a tau vi‑muni‑waiwai vona‑nau‑patei, ivona, “Itomi aniani uvenei, inꞌ‑am.” Ka a tau vi‑muni‑waiwai ivona, “Ia! Bada, eha ama pata, iuna yoko ani‑vainena taina ai maꞌ patana vivane onoto aitamoata a nau‑pata wahava ai yau 8 nihenia. Kaiwadi, yam nuanua itoai ana‑ne, e ai palaua avi‑maiei, amavina, avenei?” ");
INSERT INTO mvn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka Iesu vi‑tanaiei, ivona, “Ai vi‑am kabwaga wayahimia? Una‑ne unau‑nene.” Ka avaha ivaniahei, ivona, “Wayahiaia palaua ai yau 5 kadu iana ainua.” ");
INSERT INTO mvn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ka Iesu ai veimea venei taui ina‑ne, e yoko habuhabui iviamei mani gwau, mani gwau, wetau ananawina hetana imanuena. ");
INSERT INTO mvn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wayahina, gwau gwau imaꞌ‑nenehi, tupwai 100, ka tupwai 50. ");
INSERT INTO mvn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka tauna palaua ai yau 5 ka iana ainua epei, ka dune‑vane wahuma, e Amana nau‑kaiwei. Iakwa, e palaua gibui, e a tau vi‑muni‑waiwai venei, e tomotau mataia iboubou, kadu Iesu iana ainua gibui vo‑patei. ");
INSERT INTO mvn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ka yoko habuhabui iam‑iaua. ");
INSERT INTO mvn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka munia, a tau vi‑muni‑waiwai ine, e kamukamumuna ikwakwei venuana ai yau 12 kadu iana. ");
INSERT INTO mvn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ka ononotoi palauana iam ai yau 5000. Ka vaivinei ka yahehei iam eha ita‑iavi. ");
INSERT INTO mvn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ka dewaia iakwa, Iesu tauna a tau vi‑muni‑waiwai veimeyei waea ivi‑ata, e papani tanoi Betesaida wayahina vi‑tunei etawana inaoi, ka tuta aitamoata wayahina tauna yokoia vi‑tunei iyavuta. ");
INSERT INTO mvn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ka avaha vi‑tunei, ivane oya na‑viama Amana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ka vinanavi a tau vi‑muni‑waiwai waea navu niwanina, ka tauna ana heta tanopia. ");
INSERT INTO mvn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ka Iesu dueyei yai voi wayahina iaihanua, iuna yahina tepaia omomoi. Ka mata‑hamwahamwanina wayahina Iesu omo wayahia, navu hetana ni‑awana. Ka tuta eha ani‑hoina na‑ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kate taui waea avaha idueyei navu hetana omomo, ivona, “Ia! Unupa!” ");
INSERT INTO mvn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Habuhabui idudueyei ateatei vo‑yavuyavunena, kadu iganova. Wayahina, vo‑kwayavonina tauna vonei, ivona, “Eha umatauta kate nau‑wawanimi unꞌ‑ate‑vatu, iuna yauke taua Iesu.” ");
INSERT INTO mvn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E Iesu waea vi‑ata, ka yahina iakwa, ka taui waea nuai venau‑tupatupa ananina. ");
INSERT INTO mvn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iuna tutana yokoia palauana iam‑neiei, dewana ananina wayahina eha ita‑nua‑hau, iuna nuai toyoina. ");
INSERT INTO mvn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ka avaha Navu Galili iona‑tamanei meagai Genesareta anꞌ awa‑navua ini‑ubau, e yai waꞌ iyohoni tania. ");
INSERT INTO mvn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ka tutana waea ini‑ubaubau, tomotaui Iesu ianamanei. ");
INSERT INTO mvn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wayahina, tau vi‑meagai‑naia inau‑bwanubwanunua, e papanina habuhabuna nihenina, ka aveta baina inononi Iesu mamaei, taui tau kwanakwanaha yai pai dauva hetana iavana iomanei tauna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ka aveta tauna ine, meagai mwatutukui o kadi meagai anani, taui tau kwanakwanaha maketia ibouni, ka Iesu iviamei awaehei ana kwama awaniana ivo‑dadani. Ka aituhu aviyaivia ivo‑dadani, ividoha. ");
INSERT INTO mvn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka Parisi kadu tau ginuma tupwai Iesu wayahina inau‑hohona, taui Ierusalem wayahina iomo papani Genesareta wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka taui Iesu a tau vi‑muni‑waiwai idudueyei ai maꞌ iamam nimai idewa‑kavokavovoei, eha ita‑nosinosi. Parisi yai dewa tunina. ");
INSERT INTO mvn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi yai yoko kadu me Iudea habuhabui yai dewa deina. Aituhu nimai eha ita‑nosi tunuhina, eha ai pata inꞌ‑am. Ka taui yai tupua‑nenenehi yai dewa tutuaina ivo‑vi‑ananai. ");
INSERT INTO mvn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ka avaha maketi wayahina imavi‑havine, aituhu yai dewa pai am‑nosi eha ita‑vi‑munie tunuhina, eha ai pata inꞌ‑am. Ka kadu mani dewa habuhabui deina ivi‑muniei, e ai veimea pai am‑nosi vei wayahi, ka kunia wayahi, ka gaeba wayahi.) ");
INSERT INTO mvn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wayahina, Parisi‑naia ka tau ginuma‑naia Iesu ivi‑tanaiei, ivona, “Aviani iuna am tau vi‑muni‑waiwai eha dewa tutuaina yaka tupua‑nenenehi wayahia ita‑vi‑muni‑waiwaie, kate taui iamam, ka nimai idewa‑kavokavovoei?” ");
INSERT INTO mvn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka tauna vona‑nau‑patei, ivona, “Nonova Isaia apa‑taputapuemi tunuhina tutana tauna itomi tau vitupu wayahimi ginumi, ivona, ‘Tomotau taina tau tapanono, kate yai nuanua bana mamanaina wayahiua. ");
INSERT INTO mvn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wayahiua iawa‑dava‑kavovo, iuna yai viwavenena vivane tomotau yai viwavenena kadu ai veimea vivane tomotau yai veimea, eha Yaubada ya veimea.’” ");
INSERT INTO mvn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kadu Iesu ivona, “Yaubada ya veimea ubou‑ohoi, ka tomotau yai dewa tutuaina uvo‑vi‑ananai.” ");
INSERT INTO mvn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kadu vonei, ivona, “Itomi unuanua nua‑uya wayahimia mamaei. Ia! Yaubada ya veimea uvihahaiei iuna nuanuami yami dewa tutuaina uvo‑vi‑ananai. ");
INSERT INTO mvn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosese tauna ya ginuma nihenina ginumi deina, ivona, ‘Amam ka ayom evi‑ateteyei’ kadu ivona, ‘Aituhu aviyaivia amai o ayoi imana‑giboei, nau‑wawanimi unau‑vi‑anigi akanai.’ ");
INSERT INTO mvn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kate itomi yami viwavenena tunina. Uviwavenei aituhu aviyaivia amai o ayoi ivonei deina, ‘Nonova au pata aivaitemi, kate kina‑naia avaha awaehei Yaubada wayahina. Ka kina‑naia avaha vi‑Koribana e vito‑potana deina. Wayahina, ataina eha au pata kina‑naia wayahia ana‑ivaitemi.’ ");
INSERT INTO mvn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ka kadu itomi ai veimea uvenei vivane tuta tepakaia wayahina taui eha nau‑wawani aitam aviani amai wayahi o ayoi wayahi idedewe. ");
INSERT INTO mvn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wayahina, yami dewa tutuaina uvi‑muniei, ka tuta aitamoata wayahina Yaubada movina udewa‑kavokavovoei. Kadu mani dewa habuhabui udedewei deina.” ");
INSERT INTO mvn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E tauna yoko hone‑hohoni‑havinei, e vonei, ivona, “Habuhabumi, unononi, e unꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aituhu tomotau aniani tunina tunina inꞌ‑ania, Yaubada eha nua‑goyo. Kate dewa goyona habuhabuna tomotau nuai wayahina ivinꞌ‑omo. Ka dewaia Yaubada ivo‑vi‑nua‑goyoi, ka dewaia tomotau yawai ivitevitei. ");
INSERT INTO mvn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ka avaha tauna yokoia ni‑tawanei, e manua inui, a tau vi‑muni‑waiwai vonana wayahina ivi‑tanaiei. ");
INSERT INTO mvn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ka tauna vi‑tanaiei, “Ia! Kadu itomi? Eha yami nua‑uya nui, ka eha utꞌ‑anamane. Eha aitam aniani ana pata viteviteka. ");
INSERT INTO mvn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iuna aniani eha ana pata nuaka nihenia ta‑nu. Amo‑poaka ana heta ana pata na‑nu nihenina, e apaina na‑opu haina wayahina.” (Vonana wayahina Iesu vahitau habuhabuna awaehei tomotau inꞌ‑ania.) ");
INSERT INTO mvn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kadu ivona, “Avi dewa tomotau nuai wayahina ivinꞌ‑omo, dewaia ai pata tomotau ivitevitei. ");
INSERT INTO mvn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iuna nuai nihenia nuanua goyogoyoi habuhabui ivinꞌ‑omo, vivane gema, ka vainau, ka nau‑vi‑aniga, ");
INSERT INTO mvn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ka awa‑neme o kenene, ka gugua a nua‑tania, ka nua‑goyo, ka vitupu, ka nau‑wana, ka vi‑bwanou, ka apa‑goyogoyo, ka nua‑vane, ka kadu dewa mwagemwagei. ");
INSERT INTO mvn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dewaia goyogoyoi habuhabui tomotau nuai wayahia ivinꞌ‑omo, ka dewai tomotau ivitevitei.” ");
INSERT INTO mvn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ka tauna papani‑nana ni‑tawanei ka meagai Taia a papani wayahina omo, e aitam manua inui, ka eha ya nuanua tomotau inꞌ‑anamanei, kate eha ana pata ta‑hive. ");
INSERT INTO mvn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ka aitam vavine avaha Iesu vaneana inononi, ivisina iomo, e aena ipeu, me Iudea yai pai nua‑opu deina. Iomo iuna nua gawagawamina natui vavinena kikituna nihenina mamaei. Ka vavinena Iesu iviamei nua gawagawami‑nana natui nihenina nꞌ‑epa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ka vavine‑nana eha me Iudea, kate ayo‑amai me Girisi, ka yai tupua papani Siro‑Poenisia nihenina. ");
INSERT INTO mvn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka Iesu vonei, ivona, “Eha nau‑wawaniu me Iudea ai palaua anꞌ‑epei, e kedewa wayahia ahaponei, e kedewa inꞌ‑ania. Me Iudea nau‑wawani naona inꞌ‑am‑iaua.” ");
INSERT INTO mvn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka vavine‑nana vona inau‑patei, ivona, “Ika, Kauvea, yam vonana tunuhina. Kate me Iudea ai maꞌ kamukamumui tupwai ipeu iopu tanopia, ka kedewa‑naia ai pata kamukamumu‑naia inꞌ‑am, a?” ");
INSERT INTO mvn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ka Iesu vonei, ivona, “Yami vona‑nau‑patana ahihi‑vainena! Akanai, una‑ne‑kai. Yami viama avaha awaehei. Nua gawagawami‑nana avaha natumi ni‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ka vavine‑nana imavi‑havine yai manua wayahina, e natui ivaniahei avaha vidoha, ya pai dauva hetana daudauva. Ka nua gawagawami‑nana avaha ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ka Iesu meagai Taia a papani ni‑tawanei, e meagai Sidoni tutu‑honoi, iopu Navu Galili wayahina, e papani Dekapolisi inui. ");
INSERT INTO mvn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka tenoke aitam onoto tanihana am‑potapotana ka meana danuna mamaei. Ka tomotau iomanei Iesu wayahina, ka iviamei vo‑dadani, vo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka Iesu onotona yoko wayahina neiei vivane ainuata. E Iesu nima‑tabona ainua tunei onoto‑nana tanihana nihenia, kadu nimana hetana iwani, e onoto‑nana meana vo‑dadani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","E wahuma wayahina dune‑vane, ka yawaina honoi, e kadu vonei, ivona “Epata!” (a vo‑vina “Uwaei!”) ");
INSERT INTO mvn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ka tanihana iam‑waewaei, meana vidoha, e ipupu ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iakwa, Iesu yokoia vona panina wayahina veimeyei eha dewana wayahina mani tomotau imataedai. Tauna vona‑havihavinei, kate taui inau‑viviwava ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ka tomotaui habuhabui nuai vi‑tupatupa ananina, ka ivonavona, “Tauna dewa habuhabui dedewei ahiahina! Ika, tauna ana pata taui tanihai am‑potapotai vo‑vi‑aiaiei inononi, kadu ana pata taui meai danui vo‑vi‑aiaiei iaipupu akanai.” ");
INSERT INTO mvn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tuta tanoi wayahina kadu aitam yoko ananina inau‑hohona Iesu wayahina. Ka tauna a tau vi‑muni‑waiwai hone‑hohoni‑neiei, iomo wayahina, e vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yauke tomotau taina ate‑nuanuaiei, iuna avaha auyewa aitonu nui kamamaei ka eha ai kabwaga. ");
INSERT INTO mvn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka aituhu avi‑tunei imavi‑havine yai megeia am navovo nꞌ‑epai, apaina etawana wayahina matai nꞌ‑am‑vivivina ina‑peu. Iuna tupwai wayahia bana mamanaina wayahina iomo baina wayahiua.” ");
INSERT INTO mvn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka a tau vi‑muni‑waiwai ivi‑tanaiei, ivona, “Bada, medeina anata taina nihenina palaua avaniahei tomotau habuhabui taina iam‑iaua akanai?” ");
INSERT INTO mvn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka Iesu vi‑tanaiei, ivona, “Ami palaua ai vi‑am mamaei?” Ka taui vona inau‑patei, ivona, “Habuhabuna ai yau 7.” ");
INSERT INTO mvn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akaka tauna tomotau veimeyei tanopia imanuena, e palauaia ai yau 7 epai, ka avaha nau‑kaiwa Yaubada wayahina, gibui, e a tau vi‑muni‑waiwai venei. Ka taui tomotaui ivo‑patai. ");
INSERT INTO mvn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kadu iana mwatutukui tupwai wayahia, ka Iesu kadu epai, Yaubada nau‑kaiwei, e a tau vi‑muni‑waiwai venei. Kadu iana ivo‑patai. ");
INSERT INTO mvn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ka tomotau habuhabui iam‑iaua, ka kamukamumuna ikwakwai venuana anani ai yau 7 ivi‑nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ka yoko‑naia wayahia ononotoi ai yau 4000 deina. Ka Iesu tomotau vi‑tunei imavi‑havine yai megeia. ");
INSERT INTO mvn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka tauna a tau vi‑muni‑waiwai nui ivo‑kwayavoni yai waꞌ igenu ivi‑ata inei papani Dalamanuta. ");
INSERT INTO mvn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ka tupwai Parisi iomo Iesu wayahina, ka yana vona wayahina ivito‑patapata. Taui yai nuanua ivito‑nubui, wayahina iviamei aitam iaiaya bagibagina wahuma aitam vevewanei wayahi, idueyei, inꞌ‑anamanei anꞌ awaeha vinꞌ‑omo Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka Iesu ya nua‑vita ananina nui yawaina am‑honoi, ka vonei, ivona, “Aviani wayahina yoko habuhabumi ataina umamaei yami nuanua iaiaya bagibagina ududueyei? Memeanina nuami vi‑tupatupa, kate avonemi, eha aitam iaiaya adewe udueye.” ");
INSERT INTO mvn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ka tauna ni‑tawanei, e yai waea ivi‑ata‑havine ivi‑putu iona‑tamane mani papania. ");
INSERT INTO mvn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ka ai palaua eha ita‑vitua‑neie, ka palaua aitamoata ana heta waea itupwa. ");
INSERT INTO mvn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ka Iesu nau‑vi‑avini, ivona, “Udune‑vivinimi! Parisi kadu Erodi ai palaua a pai vo‑vi‑nata goyona. Nau‑wawanimi uvihahaiei!” ");
INSERT INTO mvn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Akaka a tau vi‑muni‑waiwai matataui ivitua‑dahadaha, ka ivona, “Iesu ya vonana deina, iuna aka palaua kavi‑nua‑pania.” ");
INSERT INTO mvn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka Iesu medeina inuanua avaha anamanei. Wayahina tauna vi‑tanaiei, ivona, “Aviani wayahina uvonavona vivane eha aka palaua? Eha ata‑ipuipupu aka palaua wayahina. Nonova a itoava ataina wayahina itomi nuami eha tꞌ‑am‑hauhau, a? Kaiwadi, nuami toyoina? ");
INSERT INTO mvn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Itomi na matami, kate eha ami pata udune‑vidovidoha, ka kadu itomi na tanihami, kate eha ami pata unononi ahiahina, a? Eha yau dewa tomotau yoko wayahi uta‑nua‑vi‑avini, a? ");
INSERT INTO mvn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tutana palaua nima papani‑keana agibui tomotau ai yau 5000 wayahi, ai vi‑am venuana itupwa ukwakwei?” Ka ivona, “Habuhabuna ai yau 12.” ");
INSERT INTO mvn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","E Iesu kadu vi‑tanaiei, ivona, “Ka tutana palaua ai yau 7 agibui tomotau ai yau 4000 wayahi, ai vi‑am venuana itupwa ukwakwei?” Ka ivona, “Habuhabuna ai yau 7.” ");
INSERT INTO mvn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kadu Iesu vi‑tanaiei, ivona, “Vona ahiahina, matamia udueyei, kate nuami eha tꞌ‑am‑hauhau, a?” ");
INSERT INTO mvn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ka meagai Betesaida wayahina iomo, e tomotau tupwai onoto tau mata‑goyo itaini ineiei Iesu wayahina, e iviamei vivane matana vo‑dadani, vo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka Iesu tau mata‑goyona nimana poyꞌ‑avini, e taini opuei meagaina nini‑vanina. E Iesu onoto‑nana matana ainua iwani ka nimana wayahina vo‑dadani. Ka vi‑tanaiei, “Ana pata aviani edueyei?” ");
INSERT INTO mvn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka onoto‑nana dune‑nau‑nene, ka ivona, “Tomotau adueyei, kate ai dune oaoana, ai ini‑awana deina.” ");
INSERT INTO mvn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wayahina, Iesu onoto‑nana matana vo‑dadana‑havinei, ka mahetei, e dewa habuhabuna dudueyei ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iakwa, e Iesu onoto‑nana nau‑vi‑avini, ka vi‑tunei na‑nei ya manua, kadu ivona, “Eha ena‑nu meagai ananina nihenina.” ");
INSERT INTO mvn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ka Iesu tauna a tau vi‑muni‑waiwai nui ini‑tawanei ineine meagai‑naia imamaei meagai Sisarea Pilipi nepena, ka tauna a tau vi‑muni‑waiwai vi‑tanaiei, ivona, “Medeina tomotau yai vona wayahiu, vivane yauke koiaka?” ");
INSERT INTO mvn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka taui ivona, “Tomotau tupwai ivonavona wamke Ioni Tau Bapitaiso, ka tupwai ivonavona wamke Elidia, ka tupwai ivonavona wamke aitam tau apa‑taputapu.” ");
INSERT INTO mvn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kadue vi‑tanai‑havinei, ivona, “Medeina unuanua, vivane yauke koiaka?” Ka Pita vona‑nau‑patei, ivona, “Wamke Tau Ito‑yavuha‑hoim.” ");
INSERT INTO mvn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka Iesu vona panina boui, ivona, “Eha aitam koiaka wayahina uhaeyeu!” ");
INSERT INTO mvn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kadue vi‑putu viwavenena wayahia, ivona, “Tuta omomo yauke, Tauna Vi‑tomotau, inahe ananina nꞌ‑epau. Apaina ononotoi anani, ka tau vi‑nomu mata‑genai, ka Yaubada movina a tau ginuma ivimwa‑hihieu, ina‑nau‑vi‑anigiu. Kate auyewa aitonu na‑iakwa amini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu vo‑vi‑mahetei ahiahina yanꞌ aniga wayahina. Kate Pita Iesu taini neiei, e yapoi. ");
INSERT INTO mvn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ka Iesu magigino, e tauna a tau vi‑muni‑waiwai habuhabui dudueyei, e tauna Pita yapoi, ivona, “Wamke Satana, ataina tuta eni‑tawaneu. Iuna yam nuanua tomotau yai nuanua deina, ka eha Yaubada ya nuanua deina.” ");
INSERT INTO mvn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ka munia, Iesu yoko‑nana, kadu a tau vi‑muni‑waiwai nui hone‑hohoni‑neiei, e ivona, “Aituhu aviyaivia yai nuanua ivi‑muni‑waiwaieu, taui nau‑wawani yai nuanua kadu yai dewa ivihahaiei, kadu nau‑wawani iawaehei apaina ihidahida, ai nahanaha a hidahida deina, kadu nau‑wawani ivi‑muni‑waiwaieu. ");
INSERT INTO mvn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vona ahiahina, aituhu aviyaivia yai nuanua taui yawai taina inua‑tania, apaina taui yawai‑vavaha itutu‑haini. Ka aituhu aviyaivia yawai taina iawaehei yauke wayahiu, o aituhu aviyaivia iawaehei Vaneana Ahiahina wayahina, apaina taui yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aituhu aviyaivia tanopia gugua ani‑vainena inau‑gwaugwaui, kadu aituhu apaina yawai‑vavaha itutu‑haini, medeina ividoha? Eha kadu aitam pai vidoha ta‑mamae wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Avi nau‑pata ana pata nuaka kahaponei akanai? Eha aitam. ");
INSERT INTO mvn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Goyona kadu kenene ai tuta ataina nihenina kamamaei. Ka vona ahiahina, aituhu aviyaivia tuta ataina yauke, Tauna Vi‑tomotau, wayahiu iaini‑yauyau, o aituhu tuta ataina yau viwavenena ivihahaiei, apaina avi tuta Amau didigana nui kadu tauna yanꞌ anelose ahihiata nui amavina, tomotaui wayahi ana‑ini‑yauyau kadu avihahaiei. ");
INSERT INTO mvn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Memeanina nuami vi‑tupatupa, kate avonemi, tupwami baina umimini eha unꞌ‑aniga a itoava Yaubada ya pai veimea a vinꞌ‑omana bagibagina udueyei wayahina. Akanai dewana na‑iakwa, munia unꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ka munia, auyewa ai yau 6 iakwa, Iesu Pita, ka Iamesa, ka Ioni taini neiei, e taui ai heta nui ivane oya ananina. Ka taui mataia tauna ininina am‑vinei tunina. ");
INSERT INTO mvn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ka tauna ana kwama mahemahe‑vainena ka kavukavu‑vainena. Eha ana pata tau am‑nosi tanopia ivo‑vi‑kavui deinake. ");
INSERT INTO mvn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ka Elidia ka Mosese ainua iomo tauna wayahina, ka Iesu nui iaipuipupu. Ka a tau hae anani dewaia habuhabui idudueyei. ");
INSERT INTO mvn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wayahina, Pita Iesu wayahina ivona, “RabiV, tuta ahiahina avaha kavaniahei. Wayahina, baina kamamae, ka vekevekeke aitonu ayonei, aitam wamke wayahim, ka aitam Mosese wayahina, ka kadu aitam Elidia wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ivona deina iuna taui imatamatauta ananina ka tauna eha tꞌ‑anamane vidoha avi vona tunuhina. ");
INSERT INTO mvn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka aitam you vinꞌ‑omo, e nau‑kabubutani, ka you wayahina Yaubada movina omo, ivona, “Taina Natu adune‑nuanuaiei. Nau‑wawanimi movina unononi!” ");
INSERT INTO mvn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ka idune‑nau‑nene, ka tau apa‑taputapu‑naia ainua eha ita‑dueye. Iesu a heta‑ohota nui. ");
INSERT INTO mvn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ka oyea iopupu‑me, ka Iesu vona panina wayahina veimeyei, ivona, “Eha aitam koiaka dewaia udueyei wayahi umataede. Apaina yauke, Tauna Vi‑tomotau, anigea amini‑havine. Ka dewana munina ana pata una‑ipupu dewaia wayahi.” ");
INSERT INTO mvn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wayahina, dewaia inua‑tania, ka matataui ivi‑vonavona vonaia “mini havine anigea” ai anamana aviani. ");
INSERT INTO mvn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ka ivi‑tanaiei, ivona, “Aviani wayahina tau ginuma ivona Elidia nau‑wawani mai‑omo?” ");
INSERT INTO mvn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka tauna vona‑nau‑patei, ivona, “Vona ahiahina, Elidia eta‑naoi, ka tauna dewa habuhabuna vo‑vi‑aiaia. Iginuma kadu apa‑taputapu wayahiu vivane yauke, Tauna Vi‑tomotau, viha habuhabuna avaniahei, ka tomotau imana‑giboeu. Kaiwadi, vonaia uvitumahanei, o eha? ");
INSERT INTO mvn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ka tuta ataina wayahina avonemi, Elidia avaha omo, ka avi goyona tomotau yai nuanua idedewei tauna wayahina, vona ahiahina, avaha idewa‑yehai, apa‑taputapu‑naia Iginuma nihenina iginumi tauna wayahina aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ka Iesu a tau vi‑muni‑waiwai ai yai 9 oya ipuna imamaei. Ka yoko ananina avaha inau‑hohona nepena imamaei. Kadu tau ginuma Iesu a tau vi‑muni‑waiwai nui ivi‑vonavona. Iesu tauna a tau vi‑muni‑waiwai ai yau 3 nui iomo, e dewana idueyei. ");
INSERT INTO mvn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ka avaha yoko habuhabuna Iesu idudueyei, taui nuai vi‑tupatupa ananina, ka tupwai wayahia inau‑bwanunua tauna wayahina, inau‑kaiwei. ");
INSERT INTO mvn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka tauna a tau vi‑muni‑waiwai vi‑tanaiei, ivona, “Aviani wayahina taui nui uvi‑vonavona?” ");
INSERT INTO mvn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kate aitam onoto yokoia nihenina vona‑nau‑patei, ivona, “Tau Viwavenena, natu onotona wayahima aomanei, iuna aitam nua kwavakwavana tauna nihenina mamaei, ka meana vo‑vi‑danui. ");
INSERT INTO mvn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ka avi tuta nua‑nana inu nihenina, tauna yawaina veimeyei, ka haponei iopu tanopia, ka awana punopuno, ka nihona vi‑tana‑kikokiko, ka ininina vi‑bananaita. Ka yauke avaha am tau vi‑muni‑waiwai aviamei nua‑nana isi‑yavunei, kate taui eha ai pata.” ");
INSERT INTO mvn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka Iesu wayahia ivona, “Taumi medeina? Habuhabumi awakabimi! Yami vitumahana eha! Ininiu ihanua wayahimi. Wayahiua tevana unꞌ‑omanei.” ");
INSERT INTO mvn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ka wayahina iomanei. Ka avaha nua‑nana Iesu dueyei, vo‑kwayavoni tevana haponei iopu tanopia ka vo‑vi‑bwatabwata‑vinei, ka tevana awana punopuno. ");
INSERT INTO mvn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka Iesu tevana amana vi‑tanaiei, ivona, “Avi tuta nua‑nana vi‑putu omomo wayahina?” Ka amana ivona, “Aya‑ketuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ka tuta habuhabuna nua‑nana ai ananata nihenina oneonei, ka kadu daudau nihenina oneonei. Iuna nua‑nana vitapewa natu na‑nau‑vi‑anigi. Ka aituhu memeanina aitam dewa edewe, enꞌ‑ate‑nuanuaieai, eivaiteai.” ");
INSERT INTO mvn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka Iesu vonei, ivona, “‘Aituhu memeanina?’ Aituhu aviyaivia ivitumahana, dewa habuhabui taui wayahi memeanina.” ");
INSERT INTO mvn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ka vo‑kwayavonina tevana amana ya nua‑vita nui vi‑hone, ivona, “Avitumahana tupwana, kate eha au pata. Yau vitumahana evo‑vi‑natei!” ");
INSERT INTO mvn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ka avaha Iesu yokoia habuhabui dueyei, vivane inau‑bwanunua, inau‑hohona, tauna nua goyogoyo‑nana veimeyei, ivona, “Wamke, nua taum, meana evo‑vi‑danui ka tanihana evo‑vi‑potei. Ka avonem, tauna wayahina eni‑ubau ena‑opu, ka eha tevana taina nihenina ena‑nu havine.” ");
INSERT INTO mvn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka nua‑nana konua, ka tevana yueyuei ananina, e iopu ine. Ka tevana ana dune tau aniga deina. Ka yokoia habuhabui ivonavona, “Avaha aniga.” ");
INSERT INTO mvn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kate Iesu nimana vo‑vi‑avini ka si‑vi‑mini, e tevana mini. ");
INSERT INTO mvn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ka avaha Iesu manua inui, a tau vi‑muni‑waiwai matataui ivi‑tanaiei, ivona, “Aviani wayahina eha ama pata asi‑yavune?” ");
INSERT INTO mvn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka vonei, ivona, “Avi nua nua‑nana deina eha memeanina kasi‑yavunei. Dewa aitamoata ana heta ana pata, vivane kaviama‑bagibagi Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ka papani‑nana ini‑tawanei, ka papani Galili ino‑honoi, ka Iesu eha ya nuanua tomotau inꞌ‑anamane aveta imamaei. ");
INSERT INTO mvn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Iuna tauna a tau vi‑muni‑waiwai ai heta viwavenei. Ka vonei, ivona, “Aitam onoto yauke, Tauna Vi‑tomotau, nꞌ‑am‑veneneyeu, ka tomotau ipoyꞌ‑aviniu, ina‑nau‑vi‑anigiu. Ka avaha aniga, auyewa aitonu munia amini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka taui viwavenena taina eha ita‑vi‑nua‑uye, kate taui yai matauta nui. Wayahina, eha ita‑vi‑tanai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ka Kapenaum wayahina iomo, ka avaha manua nihenina imamaei Iesu tauna a tau vi‑muni‑waiwai vi‑tanai‑neiei, ivona, “Aviani wayahina uvi‑vonavona etawana?” ");
INSERT INTO mvn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka taui yai ini‑yauyau nui, wayahina yana vona eha ita‑nau‑pate. Iuna etawana ivi‑vonavona ananina matataui koiaka wayahia ana wava yaiana ai wava vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ka tauna manuena, ka a tau hae anani ai yau 12 hone‑hohoni, ka vonei, ivona, “Aituhu aviyaivia yai nuanua yaiana ieta‑naoi, taui nau‑wawani iawaehei pai nau‑yehata ivinꞌ‑omo, kadu nau‑wawani ivi‑tau paisewa yaiana habuhabui wayahi.” ");
INSERT INTO mvn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka tauna aitam tevana aya‑ketuna taini, e niwania si‑vi‑mini, tana‑wapia, e a tau hae anani vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aituhu aviyaivia aitam tevana aya‑ketuna deina au wavea inau‑kaiwei, taua inau‑kaiweu deina. Ka aituhu aviyaivia inau‑kaiweu, eha yauke au heta inau‑kaiweu, kate tuta aitamoata wayahina kadu yauke au Tau Vi‑tune inau‑kaiwei.” ");
INSERT INTO mvn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka Ioni vonei, ivona, “Tau Viwavenena, itoai aitam onoto adueyei am wavea nua goyogoyoi si‑yavuyavunei. Ka itoai avito‑potei, iuna tauna eha yaka yoko nihenina.” ");
INSERT INTO mvn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kate Iesu vona‑nau‑patei, ivona, “Eha nau‑wawanimi uvito‑pote, iuna eha memeanina tomotau aitam dewa‑bagibagina idewei au wavea. Wayahina, aituhu ai pata dewa‑bagibagina au wavea idewei, eha memeanina tuta kutakutana na‑iakwa wayahina, inꞌ‑apa‑goyogoyoeu. ");
INSERT INTO mvn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aituhu aviyaivia eha ivihahaieka, taui iaivaiteka. ");
INSERT INTO mvn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia vei na daudauna ivenemi una‑nim iuna itomi taua Tau Ito‑yavuha yau tomotau, apaina taui ai nau‑pata dewana wayahina ivaniahei, eha itutu‑haini. ");
INSERT INTO mvn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ka apaina tevana aya‑ketui tupwai ivitumahaneu, ka aituhu aviyaivia yai dewa goyona wayahia aitam tevana idewei, ka aituhu dewana wayahina, tevana ya vitumahana vo‑haini, e dewa goyona dedewei, apaina tomotaui inahe vita‑vainena ivaniahei. Ika, aituhu tuta naona wayahina tomotaui yaiai ivinꞌ‑omo, e hanu ananina otoi iyohoni, e ihaponei bebega, vona ahiahina, taui igavivina ividoha deina. Iuna aituhu avaha igavivina, eha ai pata tevana yawaina ivi‑goyo deina. ");
INSERT INTO mvn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Wayahina avonemi, aituhu nimam dewa goyona dedewei, nau‑wawanim eupwa‑yavunei. Akanai ataina viha, ka aituhu yawai‑vavaha wayahina ena‑nu na nima‑upwaupwam, evidoha deina. Kate aituhu na nima‑nuanuam ai ananata ena‑nui, aioi wayahim. Iuna meagai‑nana nihenina ai‑nana eha na‑weu. ");
INSERT INTO mvn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ka aituhu aem dewa goyona dedewei, nau‑wawanim eupwa‑yavunei. Akanai ataina viha, ka aituhu yawai‑vavaha wayahina ena‑nu na ae‑goagoam, avaha evidoha deina. Kate aituhu na ae‑nuanuam ai ananata wayahina Yaubada na‑haponem, aioi wayahim. ");
INSERT INTO mvn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ka aituhu matam dewa goyona dedewei, nau‑wawanim etupa‑yavunei. Akanai ataina viha, ka aituhu na matam aitamoata Yaubada ya pai veimea nihenina ena‑nu, evidoha deina. Kate aituhu na mata nuanuam ai ananata wayahina Yaubada na‑haponem, aioi wayahim. ");
INSERT INTO mvn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ai ananata a papani wayahina imonamonana nihenia eha inꞌ‑aniga, ka ai‑nana eha na‑weu. Viha‑vavaha akanai. ");
INSERT INTO mvn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tomotau habuhabui nau‑dadana ivaniahei ai ananata deina, iuna Yaubada ya nuanua yawai vidoha. Ka aituhu aviyaivia nau‑dadanaia ivane‑tawanei, dewana yai dewa goyona anai deina. Ka aituhu aviyaivia taui yai goyona iepa‑yavunei, akanai ivi‑weto. Vona ahiahina, niuna wetona aniani dewa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Akanai niuna ahiahina, ka aituhu wetona iakwa, avaha vi‑una. Eha ana pata vidoha‑havine. Itomi nau‑wawanimi uvi‑weto ka udewa‑vidovidohemi, ka nua gomagomanina wayahimia unua‑vi‑avini deina.” ");
INSERT INTO mvn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ka Iesu papani‑nana ni‑tawanei, e papani Iudea inui, e Daudau Ioridani ona‑tamanei papanina. Ka kadu aitam tuta tomotau yoko inau‑hohona wayahina, ka yana dewa tuta tuta deina, viwavenei. ");
INSERT INTO mvn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ka Parisi tupwai iomo, e yai nuanua Iesu ivito‑nubui. Wayahina, ivi‑tanaiei, ivona, “Bada, medeina aka veimea vaiobu wayahina? Ana pata onoto awana na‑vaiobuei?” ");
INSERT INTO mvn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ka Iesu vi‑tanaiei, ivona, “Medeina Mosese veimeyemi?” ");
INSERT INTO mvn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka Parisi ivona, “Mosese awaeheka deina, aituhu avi onoto nuanuana vaiobu, naona nau‑wawani ya vihaihai ginumi awana na‑haeyei, e munia na‑vaiobu, na‑ne.” ");
INSERT INTO mvn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka Iesu vonei, ivona, “Mosese veimeana ginumi wayahimi, iuna nuami toyoina, eha ami pata unꞌ‑ate‑nuanuai. ");
INSERT INTO mvn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kate unuani, tutana Yaubada naona tanopi vevewanei ‘tomotau ainua vevewanei, onotona ka vavinena.’ ");
INSERT INTO mvn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Wayahina, onoto nau‑wawani ayona amana ni‑tawanei ka awana ainua ivi‑manueni. ");
INSERT INTO mvn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ka avaha ainuai inini ivi‑aitamoata.’ Nonova ainua tunina imamae, kate yai tavine munia, aitamoata imamae. ");
INSERT INTO mvn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wayahina, aituhu aviyaivia Yaubada avaha bou‑nuei, eha aitam koiaka nau‑wawani bou‑keye.” ");
INSERT INTO mvn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ka munia, avaha imavina manua, Iesu a tau vi‑muni‑waiwai ivi‑tanaiei vaiobu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka Iesu vonei, “Aituhu koiaka ya vavine vaiobuei, ka mani vavine wayahina tavine‑tamana, vona ahiahina, onoto‑nana awana tutuaina wayahina dewa goyona nau‑vevewanei, vivane kenene. ");
INSERT INTO mvn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ka aituhu koiaka yai onoto ivaiobuei ka mani onoto wayahina itavine‑tamana, vavine‑nana avaha ikenene.” ");
INSERT INTO mvn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ka tomotau yaheyahe iomanei Iesu wayahina, iuna yai nuanua tauna nimana bouni, na‑nau‑iaiavei. Kate a tau vi‑muni‑waiwai tomotaui yaheyahe nui ivito‑potai, iuna eha yai nuanua Kauvea ana tuta na‑one‑yavune dewa kikituna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka avaha Iesu tauna a tau vi‑muni‑waiwai yai dewa dueyei, magana bawe, e ivona, “Eha yaheyahe wayahiua uvito‑potai! Nau‑wawanimi uawaehei inꞌ‑omo wayahiua. Iuna memeanina yaheyahe ai pata Yaubada ya pai veimea nihenina ina‑nu. ");
INSERT INTO mvn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia inua‑vane, taui eha ai pata Yaubada ya pai veimea nihenina ina‑nu. Ka aituhu aviyaivia inua‑opu, tevana aya‑ketuna deina, taui ai heta ai pata ina‑nu nihenina.” ");
INSERT INTO mvn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wayahina, Iesu yaheyahe aitamoata aitamoata tana‑wapi‑neiei, e nimana bouni, e nau‑iaiavei. ");
INSERT INTO mvn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tutana Iesu mini na‑ne, aitam onoto nau‑bwanunua omo tauna matana, vi‑tupa‑gum, e ivona, “Tau Viwavenena, avaha anamanem vivane wamke tau viwavenena ahiahina aitam. Wayahina, yau nuanua evoneu aviani adewei apaina yawai‑vavaha avaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka Iesu onotona vonei, ivona, “Mehenai eawa‑vidovidoheu? Iuna eha aitam koiaka ahiahina, Yaubada a heta‑ohota ahiahina. ");
INSERT INTO mvn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ka wamke Yaubada ya veimea avaha eanamanei. ‘Eha enau‑vi‑aniga. Eha ekenene. Eha evainau. Eha evitupu. Eha yam viam‑nonona wayahina mani tomotau yai gugua evitua‑neiei. Ayo‑amam evi‑ateteyei.’” ");
INSERT INTO mvn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka onotona ivona, “Tau Viwavenena, yau tuta tevana a itoava tuta ataina wayahina veimeaia avi‑ateteye‑vainei.” ");
INSERT INTO mvn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ka Iesu onoto‑nana dune‑vi‑anai, kadu dune‑nuanuaiei. Wayahina, vonei, ivona, “Akanai, ka dewa aitamoata nau‑wawanim. Emavi‑havine yam megeia, ka yam gugua habuhabui eimwaneyei, e ai nau‑pata tau payapayaya evo‑patai. Na‑iakwa, enꞌ‑omo wayahiua evi‑muni‑waiwaieu. Apaina yam kaikaiwabo wahuma evaniahei.” ");
INSERT INTO mvn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ka tutana onoto‑nana vonana nononi, nuana ivita ani‑vainena, iuna tauna ya kaikaiwabo ananina nua‑tania. Wayahina, magigino, ka ya nua‑vita nui ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wayahina, Iesu dune‑nau‑nene a tau vi‑muni‑waiwai wayahia ka vonei, ivona, “Aituhu aviyaivia tau kaikaiwabo, taui yai nui Yaubada ya pai veimea nihenina vita‑vainena!” ");
INSERT INTO mvn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ka a tau vi‑muni‑waiwai nuai vi‑tupatupa ya vonana wayahina. Ka Iesu vonei, ivona, “Natunatu, Yaubada ya pai veimea ana nui vivane vita‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vona ahiahina, aituhu kameliV (tauna vahitau ananina) ana pata haima matana na‑nui, e tau kaikaiwabo ai pata Yaubada ya pai veimea ina‑nu. Kate, vona ahiahina, dewaia ainua eha ana pata.” ");
INSERT INTO mvn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vonana wayahina a tau vi‑muni‑waiwai nuai venau‑tamatamani ananina, e ivi‑tanaiei, ivona, “Ia! Aituhu yam vonana tunuhina, kaiwadi, koiaka ana pata ito‑yavuha vaniahe?” ");
INSERT INTO mvn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wayahina, Iesu dune‑vi‑anai wayahia, e vonei, ivona, “Tomotau ai heta eha ai pata ito‑yavuha ivaniahe. Kate Yaubada wayahina, dewa habuhabuna memeanina.” ");
INSERT INTO mvn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ka Pita vonei, ivona, “Bada, itoai medeina? Iuna yama gugua habuhabuna avaha ani‑tawane‑neiei, e avi‑muni‑waiwaiem!” ");
INSERT INTO mvn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka Iesu ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia yai manua, o vavanei, o novunovui, o ayoyoi, o amamai, o natunatui, o yai tano ini‑tawane‑neiei wayahiu o aituhu ini‑tawane‑neiei Vaneana Ahiahina wayahina, ");
INSERT INTO mvn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","akanai taui yawai taina tanopia wayahina ai nau‑pata a vo‑vi‑tupana ai yau 100 deina ivaniahei, (vivane manua, ka vavanei, ka novunovui, ka ayoyoi, ka natunatui, ka kadu tano. Kate guguaia nui kadu mana‑gibo kadu inahe ivaniahei), kadu apaina, yawai‑vavaha wahuma ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ataina tomotau habuhabui mani tomotau ieta‑naoi, kate apaina taui pai nau‑yehata ivinꞌ‑omo, ka ataina tomotau habuhabui pai nau‑yehata iomomo, kate apaina ieta‑naoi.” ");
INSERT INTO mvn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ka taui etawana ivanevane meagai Ierusalem wayahina, ka Iesu eta‑naonaoi ka a tau vi‑muni‑waiwai ivi‑muniei, e taui nuai venau‑tamatamana. Ka mani tomotau yai matauta nui etawana munia ivi‑muniei. Ka tauna a tau hae anani ai yau 12 taini‑havinei, ka taui ai heta mataedai aviani na‑omo tauna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ivona, “Tuta ataina kavanevane Ierusalem wayahina. Ka yauke, Tauna Vi‑tomotau, au tau vauya na‑vauyeu tau vi‑nomu mata‑genai wayahia, ka veimea a tau viwavenena wayahia, ka taui yau aniga iveimeyei. Ka munia, inꞌ‑am‑veneneyeu taui eha me Iudea wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ka taui eha me Iudea ivi‑waipoeu, ka iaiwaiwaniu, ka manawea imoamoaniu. Ka munia, ina‑nau‑vi‑anigiu. Kate auyewa vꞌ‑itonuna wayahina amini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Apaina Iamesa ka Ioni, taui Sebedi natunatuna, iomo Iesu wayahina ka ivonei, ivona, “Tau Viwavenena, ama inua aomo wayahima, e yama nuanua aviani wayahina aviamem, akanai eawaeheai.” ");
INSERT INTO mvn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka Iesu ivona, “Aviani wayahimi adewei?” ");
INSERT INTO mvn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka taui ivona, “Apaina, avi tuta yam pai veimea evaniahei, e didigam nui eveimeyei, itoai yama nuanua nepema amanuena, aitam ateima, aitam akenima. E, aka itonu kaveimeyei deina.” ");
INSERT INTO mvn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka Iesu vi‑tanaiei, ivona, “Itomi yami viamana anꞌ anamana eha utꞌ‑anamane. Itomi medeina? Viha ana vei apaina ana‑nim, kadu ami pata una‑nim? O bapitaiso vita‑vainena apaina avaniahei, kadu ami pata bapitaiso‑nana uawaehei aitamoata deina?” ");
INSERT INTO mvn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka taui ivona, “Ama pata.” Ka Iesu ivona, “Vona ahiahina, vei‑nana apaina ana‑nim, kadu munia itomi una‑nim, ka kadu bapitaiso‑nana apaina avaniahei, kadu munia itomi bapitaiso‑nana uvaniahei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kate yauke eha au pata taui apaina ateiua ka akeniua imanuena avi‑nua‑dadane. Iuna Yaubada avaha pai manuenaia ainua vo‑vi‑aiaia, ka tauna ana heta taui imanuena hetaia vi‑nua‑dadanei. Eha yauke.” ");
INSERT INTO mvn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ka tau vi‑muni‑waiwai ai yau 10, avaha Iamesa ka Ioni yai viamana inononi, inua‑goyoei. ");
INSERT INTO mvn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wayahina, Iesu habuhabui hone‑hohoni ka vonei, ivona, “Itomi avaha taui eha me Iudea yai dewa uanamanei. Taui ai tau veimea yai nua‑vane nui mani tomotau iveimeyei. Ka aituhu aviyaivia wayahia ai wava anani, o aituhu dewa ananina ai awaeha wayahia mamaei, taui dewa panina wayahina mani tomotau ibou‑opuei. ");
INSERT INTO mvn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kate eha yau nuanua itomi wayahimia udedewe deina. Aituhu koiaka wayahimia yam nuanua am wava ananina, wamke nau‑wawanim evi‑tau paisewa yaiam wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka aituhu koiaka wayahimia yam nuanua yaiam habuhabui eta‑naoi, wamke nau‑wawanim evi‑tau paisewa‑kavokavovo yaiam habuhabui wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nau‑wawanimi yauke taua unuaniu. Aviani wayahina yauke, Tauna Vi‑tomotau, avinꞌ‑omo tanopia? Kaiwadi, avinꞌ‑omo yau nuanua mani tomotau ivi‑tau paisewa‑kavokavovo wayahiu, e aveimeye? Eha‑ohota. Avinꞌ‑omo avi‑tau paisewa‑kavokavovo tomotau wayahi, ka yau aniga awaehei nau‑pata tomotau habuhabui nuai wayahi. Ka yau nuanua ana‑ito‑yavuhi deina.” ");
INSERT INTO mvn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ka taui iomo meagai Ieriko wayahina. Ka tutana Iesu tauna a tau vi‑muni‑waiwai nui Ieriko ini‑tawanei, yoko ananina imata‑weapui, ka aitam tau mata‑goyo ana wava Batimaeusa etawana awaniana manuena. Tauna Timaeusa natuna, ka tauna nau‑gagada kina ka gugua wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka avaha Batimaeusa vane nononi vivane Iesu me Nasareta omo‑neine, tauna vi‑putu vi‑hone Iesu wayahina, ivona, “Iesu, wamke Davida wana, eate‑nuanuaieu!” ");
INSERT INTO mvn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ka tomotau habuhabui Batimaeusa awaniana imimini ivito‑potei, ivona, “Eha movim! Vi‑hone akanai!” Kate yai vonana eha aitam aviani tauna wayahina. Tauna vi‑hone nau‑vi‑didimana, ivona, “Davida wana, eate‑nuanuaieu!” ");
INSERT INTO mvn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ka Iesu venau‑genuana, ka ivona, “Uhonei, na‑omo baina.” Ka tomotau ivona, “Akanai, edewa‑haiawa! Emini, Iesu honehonem.” ");
INSERT INTO mvn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ka tauna a pai bwaꞌ hapone‑yavunei, e ni‑ubau, omo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ka Iesu vi‑tanaiei, ivona, “Aviani yam nuanua adewei wayahim?” Ka tau mata‑goyo vonei, ivona, “Tau Viwavenena, nuanuau adunedune.” ");
INSERT INTO mvn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka Iesu vonei, ivona, “Ena‑ne‑kai. Tuta ataina yam vitumahana vo‑vi‑aiaiem.” Ka vo‑kwayavonina matana vi‑hadahadana, e tauna Iesu vi‑muni‑waiwaiei etawana. ");
INSERT INTO mvn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tutana ivanevane Ierusalem wayahina, ivinꞌ‑omo meagai kikitui Betepage ka Betani nepeia, anoi Oya Olive baimina, ka Ierusalem tepaia eha bana mamanaina. Ka Iesu tauna a tau vi‑muni‑waiwai ainua mai‑vi‑tunei aitam meagai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Tauna ai veimea venei, ivona, “Una‑ne meagai tenoke matamia, ka avi tuta unuinu wayahina, aitam aseV udune‑vaniahei ai wayahina itana‑ipwei. Ase‑nanaV mata‑yauyona. Eha aitam koiaka ta‑vi‑ata‑dadana. Ka ase‑nanaV uyavuhi, e baina uomaneu. ");
INSERT INTO mvn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aituhu aitam koiaka vi‑tanaiemi, na‑vona, ‘Aviani wayahina aseV uyavuyavuhi?’ akanai ami inua una‑vona, ‘Dewa taina Kauvea ya nuanua, e tuta eha ani‑hoina na‑iakwa na‑va‑tawane‑havinei na‑omo baina.’” ");
INSERT INTO mvn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka ainuai iomo meagai‑nana wayahina ka aseV ivaniahei etawana, manua nepena, e ai wayahina itana‑ipwei, kadu ivi‑putu iyavuhi. ");
INSERT INTO mvn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iyavuyavuhi, e tupwai tomotau nepeia ivi‑tanaiei, “Aviani wayahina aseV uyavuyavuhi?” ");
INSERT INTO mvn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E ainuai vona inau‑patei Iesu avaha mataedai deina, e tomotaui iawaehei. ");
INSERT INTO mvn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","E ase‑nanaV itaini iomanei Iesu wayahina, ka taui ai kwamea wauna iyaveni, ka Iesu vi‑ateyei. ");
INSERT INTO mvn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ka yoko habuhabui ai kwamea etawana iyaveni‑neiei, ka tupwai ai nahana na yawaina iguye‑neiei, e etawana ivaivani. ");
INSERT INTO mvn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ka yokoia wayahia tupwai Iesu ieta‑naonaoi, ka tupwai ivi‑muniei. Ka habuhabui iawa‑davadava ka ivi‑honehone, ivonavona, “OsanaV!” kadu ivonavona, “Kaiwa ananina! Tauna Yaubada a wavea vinꞌ‑omo nau‑iaiava avaha vaniahei!” ");
INSERT INTO mvn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadu ivonavona, “Itoai wai Davida ya pai veimea omomo, ka yama nau‑iaiava avaniahei wayahina!” kadu ivonavona, ");
INSERT INTO mvn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ka Iesu avaha Ierusalem inu nihenina, e omo Manua Vito‑pota wayahina, inui, ka dewa habuhabui Manua Vito‑pota nihenina dueyei. Ka auyewana wayahina avaha vinanavi. Wayahina, tauna a tau hae anani ai yau 12 nui imavina meagai Betani wayahina, idauva. ");
INSERT INTO mvn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ka mana navia imini ka Betani wayahina imavimavi Ierusalem wayahina, ka Iesu am navovo, ");
INSERT INTO mvn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ka enoma ai ana dune madaiba deina na yawaina dueyei. Wayahina, omo nepena, e ya nuanua uana wayahina nꞌ‑am‑patapata. Ka dueyei vivane yawainata, uaua ana tuta apaina. ");
INSERT INTO mvn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka Iesu ai‑nana bwanatei, ivona, “Eha ena‑ua‑havine, akanai!” Ka a tau vi‑muni‑waiwai ya vonana inononi. ");
INSERT INTO mvn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ka Ierusalem wayahina iomo, e inu Manua Vito‑pota nihenina, ka tauna tau aimwane ka tau vi‑maiena nihenina vo‑taho‑neiei. Ka kina a tau bou‑tamatamanena yai tana‑pwaina vi‑kabubu‑neiei, ka bunebune a tau aimwane yai pai maꞌ kadu vi‑kabubu‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka kadu taui habuhabui yai gugua iavanei Manua Vito‑pota nihenina itutu‑honoi, ka tauna dewana vito‑potei. ");
INSERT INTO mvn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka tauna ya viwavenena nihenina vi‑tanaiei, ivona, “Itomi medeina? Kaiwadi, Iginuma nihenina Yaubada yana vona uanamanei o eha? Iginuma nihenina ivona, ‘Yau manua vivane manua pai viama tomotau habuhabui wayahi.’ Kate itomi avaha uvo‑vinei vivane ‘tau vainau yai pai maꞌ.’” ");
INSERT INTO mvn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ka tau vi‑nomu mata‑genai ka veimea a tau eta‑naonao Iesu ya vonana inononi, ka inua‑goyoei. Wayahina, ivi‑putu ivi‑nua‑hauhau medeina ina‑nau‑vi‑anigi, iuna avaha ianamanei tomotau habuhabui Iesu ya viwavenena nuai epei. Wayahina, tau vi‑nomu mata‑genai ka veimea a tau eta‑naonao imatamatauta Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ka vinanavi Iesu tauna a tau vi‑muni‑waiwai nui Ierusalem ini‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ka mana navia imini imavimavina Ierusalem wayahina, ka etawana ineine, ka ai‑nana Iesu bwanatei idueyei avaha yawaina habuhabui inau‑moewa, tabona ipwavu iopu wanohina. ");
INSERT INTO mvn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka Pita Iesu ya vonana nuani, e ivona, “Tau Viwavenena, edu! Ai‑nana ebwanatei avaha ipwavu!” ");
INSERT INTO mvn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka Iesu vonei, ivona, “Aituhu yami vitumahana Yaubada wayahina, itomi kadu ami pata dewa‑bagibagi udedewei. ");
INSERT INTO mvn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia eha iva‑hamwahamwana kate Yaubada ivitumahanei, taui ai pata oya tenoke iveimeyei, ina‑vona, ‘Ena‑opu, emanuena hawana.’ E oyana movi na‑nononi. ");
INSERT INTO mvn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wayahina, ataina avonemi, aviani yami viama nihenia Yaubada uviamei, nau‑wawanimi uvitumahanei avaha uvaniahei, e munia Yaubada nꞌ‑awaehemi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ka avi tuta uviama Yaubada wayahina, aituhu yaiami yai dewa goyona wayahimia unuani, ka aituhu yami nua‑goyo wayahia mamaei, nau‑wawanimi naona unua‑piahi. Iuna, aituhu mani tomotau yai dewa goyona wayahimia unua‑piahi, Amami wahuma yami dewa goyona Tauna wayahina na‑nua‑piahi aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ka imavi‑havine Ierusalem wayahina, ka Iesu Manua Vito‑pota a bubuna‑honota ani‑vainena nihenina ni‑awana. Ka tau vi‑nomu mata‑genai ka veimea a tau viwavenena kadu ononotoi anani iomo tauna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","E Iesu ivi‑tanaiei, ivona, “Taum koiaka? Avi awaeha wayahima?” Kadu ivi‑tanaiei, ivona, “Koiaka awaehem manua taina eveimeyei?” ");
INSERT INTO mvn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ka Iesu vona‑nau‑patei, ivona, “Naona vi‑tanai aitamoata avi‑tanaiemi. Ka aituhu vi‑tanai‑nana unau‑patau, yauke kadu avonemi avi awaeha wayahiua mamaei dewaia adedewei. ");
INSERT INTO mvn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yau vi‑tanai vivane Ioni Tau Bapitaiso ya bapitaiso wayahina. Koiaka Ioni awaehei tauna tomotau vi‑bapitaisoei? Yaubada awaehei, o kadi tomotau iawaehei? Uvoneu, anononi.” ");
INSERT INTO mvn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ka taui matataui ivi‑vonavona deina, “Ya vonana medeina kanau‑patei? Aituhu kana‑vona, ‘Yaubada wayahina,’ apaina tauna ya vi‑tanai wayahikaia vivane ‘Aviani wayahina eha Ioni uta‑vitumahane?’ ");
INSERT INTO mvn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kate aituhu kana‑vona, ‘Tomotau wayahia,’ apaina yoko inua‑goyoeka.” (Iuna tomotau habuhabui ivitumahanei vivane Ioni Yaubada a tau apa‑taputapu aitam.) ");
INSERT INTO mvn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wayahina, Iesu ya vi‑tanai‑nana eha ita‑nau‑pate ahiahina. Taui ivona, “Eha atꞌ‑anamane.” Akaka Iesu vonei, ivona, “Akanai. Eha ahaeyemi koiaka awaeheu dewaia adedewei.” ");
INSERT INTO mvn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ka Iesu vona tana‑minikuna vonei, ivona, “Aitam onoto tauna ya baguna baguni, ka bagu‑nana vivane manawa ana noe. Uana wetona ana wava wainaV. E tauna tutu‑gani, ka wainaV a pai va‑buyo kayoi hanu yanayanana nihenina, ka manua pai dune baguna nihenina yonei. Ka aituhu tau vainau iomomo, idudueyei. Avaha vo‑vi‑aiai‑yehai, e tauna tau nau‑matava tupwai awaehei taui ya baguna idune‑vi‑avini. Ka tau nau‑matava‑naia iawaehei ai‑ponuponu ana tuta wayahina, bada‑nana a nau‑pata wainaV wayahina iva‑tawanei akanai. Ka iawaehei aitamoata deina, e tau bagu‑nana ni‑tawanei ine mani papania. ");
INSERT INTO mvn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ka munia, ai‑ponuponu ana tuta vinꞌ‑omo, e tau bagu‑nana ya tau paisewa aitam vi‑tunei ine vivane tau nau‑matava‑naia wainaV a nau‑pata ivenei na‑omane‑havinei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kate tau nau‑matava‑naia tau paisewana ipoyꞌ‑avini, ivunui, e awakabina ivi‑tunei mavi‑havine yana bada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wayahina, tau bagu‑nana ya tau paisewa vꞌ‑inuana kadu vi‑tunei ine wayahia. Ka unununa ivunui ka idewa‑yaiyaiei ananina, ka ya ini‑yauyau nui mavi‑havine yana bada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wayahina bada‑nana vꞌ‑itonuna vi‑tunei ine wayahia, ka tauna inau‑vi‑anigi. Ka munia, habuhabui kadu vi‑tunei ine wayahia. Ka tupwai ivunu‑neiei, ka tupwai inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ka bada‑nana wayahina aitamoata mamaei, vivane tauna natu‑hoina, ka dune‑nuanuaiei ananina. Wayahina, tauna natuna vi‑tunei ine wayahia, iuna tauna ana heta vonavona, ‘Anamanei vivane natu movina ivi‑ateteyei.’ ");
INSERT INTO mvn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kate avaha natuna vinꞌ‑omo wayahia idueyei, tau nau‑matava‑naia matataui ivonavona, ‘Yaiau, tau bagu‑nana natuna omomo, kadu ataina nau‑wawanika kanau‑vi‑anigi. Munia baguna taina vivane yaka baguna, e kaveimeyei.’ ");
INSERT INTO mvn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wayahina ipoyꞌ‑avini, inau‑vi‑anigi, e baguna nini‑vanina ihaponei iopu.” ");
INSERT INTO mvn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ka avaha Iesu ya ipupuna iakwa, e vi‑tanaiei, ivona, “Apaina tau bagu‑nana yana dewa medeina? Vona ahiahina, tau bagu‑nana nau‑wawani mavi‑havine, e tau nau‑matava‑naia habuhabui na‑nau‑vi‑anigi! Ka munia, tauna ya baguna mani tau nau‑matava wayahia nꞌ‑awaehei idune‑vi‑avini.” ");
INSERT INTO mvn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ka Iesu kadu aitam vona tana‑minikuna Iginuma nihenina vonei, ivona, “Unuani. Iginuma nihenina ivona deina, ‘Ohonana tau yona ivihahaiei avaha mini ka vi‑ohona toyoina. Kadu ohonana ohona habuhabui bagibagi‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dewana taina Kauvea yana dewa, ka matakaia ahihi‑vainena.’” ");
INSERT INTO mvn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka tau vi‑nomu mata‑genai ka Parisi avaha Iesu yana vona tana‑minikunana inononi, ianamanei taui vivane tau nau‑matava‑naia goyogoyoi viviwavana nihenina. Ka yai nuanua ipoyꞌ‑avini, kate eha ita‑dewe, iuna yoko wayahia imatamatauta. Wayahina, auyewa‑nana wayahina tauna ini‑tawanei ka ine. ");
INSERT INTO mvn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka munia, ononotoi anani yoko ainua ivi‑tunei ine Iesu wayahina. Iuna ononotoi anani yai nuanua vi‑tanai wayahina inonoi. Aitam yoko Parisi wayahia (ka taui me Rom yai veimea idewa‑vihahaiei ananina). Ka kadu aitam yoko vivane Erodi yaiana (ka taui me Rom yai veimea iawaehei, iuna me Rom ai tau veimea avaha Erodi awaehei me Iudea veimeyei). ");
INSERT INTO mvn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka yoko ainua taina ivinꞌ‑omo Iesu wayahina, e iana‑dibidibiei, ivona, “Tau Viwavenena, avaha anamanem wamke tau viwavenena ahiahina aitam. Ka taui ai wava anani eha ai pata yam vi‑nua‑dadana ivo‑vinei, iuna taui eha aitam aviani wayahima. Vona ahiahina, yam viwavenena awaehei aitamoata vona tunutunuhina wayahina, ka Yaubada ya etawana eviwavenei ahiahina. Kaiwadi, itoka me Iudea aka veimea awaeheka SisaV takesiV kavenevenei, o eha? ");
INSERT INTO mvn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaiwadi nau‑wawanika takesinaV SisaV kavenevenei, o eha?” Kate Iesu yai vito‑nubu avaha anamanei. Wayahina vonei, ivona, “Mehenai unononou? Aitam me Rom yai toea uomanei wayahiua adueyei.” ");
INSERT INTO mvn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ka aitam toeana ivenei, ka Iesu vi‑tanaiei, ivona, “Uvoneu, toea taina wayahina koiaka mayamayauna mamaei ka medeina ana wava?” E ivona, “SisaV.” ");
INSERT INTO mvn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wayahina Iesu vonei, ivona, “Deina. Wayahina avonemi, aviani nau‑wawanimi SisaV uvenevenei, tauna uvenevenei deina. Ka aviani nau‑wawanimi Yaubada uvenevenei, tauna uvenevenei deina.” Ka Iesu ya nau‑patana wayahina nuai venau‑tamatamana ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ka kadu aitam yoko, taui Sadusi wayahia, iomo Iesu wayahina. Taui eha ita‑vitumahane apaina taui aninigai imini‑havine wayahina. Ka Iesu ivi‑tanaiei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tau Viwavenena, Mosese veimea taina ginumi wayahika, ivona, ‘Aituhu aitam onoto tavine ka eha natuna, ka aituhu nꞌ‑aniga, onotona vaneina nau‑wawani wadaena na‑tavine. Ka aituhu vavinena vi‑natuna, natu‑nana vivane tau aniga yana gabu nꞌ‑epei.’” ");
INSERT INTO mvn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kadue pai dune ivenei, ivona, “Aitam onoto vavaneina nui imamaei, ai yau 7, ka unu‑tauna tavine, ka eha natuna. Ka onotona aniga, ka kadu vaneina nepena wadaena tavine, ka kadu eha natuna, ka aniga deina. ");
INSERT INTO mvn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kadue vaneina nepena wadaena epei, ka kadu imamaei, ka eha natuna, ka onotona aniga. ");
INSERT INTO mvn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Akanai ka vavaneina habuhabui wadaena itavinei ka habuhabui ianiga‑yehata, ka eha kadu natunatui. Ka munia, vavinena aniga. ");
INSERT INTO mvn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka yama vi‑tanai taina. Apaina, mini‑havine a tutea, vavine‑nana avi onoto awana? Iuna taui ai yau 7 avaha itavinei.” ");
INSERT INTO mvn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka Iesu nau‑patei, ivona, “Nuanua taina vivane yami goyona, a? Iuna Iginuma eha utꞌ‑anamane ahiahina. Ka kadu eha Yaubada ya bagibagi utꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Udu! Mini‑havine munia, tomotau eha ai pata itavine. Iuna apaina taui anelose wahuma deina, eha onotona ka eha vavinena. ");
INSERT INTO mvn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tuta nonova wayahina Yaubada Mosese vonei mini‑havine wayahina. Aituhu Iginuma una‑iavi ahiahina, udune‑vaniahei. Aitam tuta Mosese udana neine ka ai yabeyabena tupatupa nihenina dueyei. Ka Yaubada ai yabeyabena wayahina vonei, ivona, ‘Yauke Abaraham ya Yaubada, kadu Isaki ya Yaubada, kadu Iakobo ya Yaubada.’ ");
INSERT INTO mvn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaubada eha tomotau aninigai yai Yaubada, kate tomotau yawayawai yai Yaubada. Tutana Yaubada Mosese vonei deina, Abaraham, ka Isaki, e Iakobo avaha inusi, ka ponimana habuhabui iakwa. Kate udu! Yaubada ivona vivane taui yawayawai. Wayahina, itomi yami viwavenena mini‑havine wayahina mwagemwage‑vainena!” ");
INSERT INTO mvn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ka Yaubada ya veimea a tau viwavenena aitam omo ka tauna Sadusi Iesu nui yai vito‑dahadaha nononi, kadu tauna Iesu ya nau‑pata nononi ahiahina ana noe. Wayahina, tauna Iesu vi‑tanaiei, ivona, “Veimea habuhabui wayahia, avi veimea ananina?” ");
INSERT INTO mvn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Iesu ivona, “Veimea ananina taina. Ka nonova Mosese vonemi deina, ivona, ‘Itomi me Isiraeli unononi. Yaka Yaubada, vivane Kauvea Yaubada a heta‑ohota. ");
INSERT INTO mvn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nau‑wawanika Kauvea yaka Yaubada kadune‑nuanuaiei nuaka wayahina, ka ininika wayahina, ka yaka nuanua wayahina, ka kadu yaka bagibagi habuhabuna wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka kadu aitam veimea ananina taina, ‘Yaiami udewa‑vidovidohei itomi ami heta udewa‑vidovidohemi aitamoata deina.’ Veimea ainua veimea habuhabui ivane‑tawane‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka veimea a tau viwavenena Iesu ya vona‑nau‑patana nononi ka ivona, “Tau Viwavenena, yam vonana tunuhina. Iuna Yaubada aitamoata mamaei, ka eha kadu aitam yaubada ta‑mamae. ");
INSERT INTO mvn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kadu aituhu Yaubada kadewa‑vidovidohei nuaka wayahina, kadu ininika wayahina, kadu yaka nuanua wayahina, kadu yaka bagibagi wayahina, ka aituhu yaiaka kadewa‑vidovidohei itoka aka heta kadewa‑vidovidoheka aitamoata deina, dewaia vi‑nomu habuhabui kadu am‑venena awawaehina habuhabui vane‑tawane‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ka Iesu onoto‑nana ya nua‑uya nononi ya nau‑pata nihenina. Wayahina, vonei, ivona, “Wamke Yaubada ya pai veimea avaha eva‑vi‑maupwani.” Ka tauna ya ipupu‑nana iakwa, ka munia eha aitam koiaka Iesu ta‑vito‑nubu‑dadana vi‑tanai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka Iesu Manua Vito‑pota nihenina mamaei, ka tomotau viwavenei. Ka tauna vi‑tanaiei, ivona, “Medeina Yaubada ya veimea a tau viwavenena ivonavona Tau Ito‑yavuha‑nana Davida ya dedea vinꞌ‑omo? ");
INSERT INTO mvn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tuta nonova wayahina Nuana Ahihinata Davida nua‑uya venei. Ka Davida Tau Ito‑yavuha‑nana wayahina apa‑taputapuei, ivona, ‘Yaubada yau Kauvea vonei, ivona, “Ateiua emanuena a itoava am havia habuhabui abou‑opuei aem ipuna wayahina.” ’ ");
INSERT INTO mvn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida Tau Ito‑yavuha‑nana vi‑wahani ‘yau Kauvea’, wayahina medeina munia ana pata Tau Ito‑yavuha‑nana Davida ya dedea vinꞌ‑omo?” Ka yoko habuhabui Iesu ya viwavene‑nana nuai epei. ");
INSERT INTO mvn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu ya viwavenena nihenina ivona, “Udune‑vivinimi! Eha veimea a tau viwavenena yai dewa uvi‑muniei. Yai dewa taina deina. Tuta habuhabuna yai nuanua ai heta ai kwama mamanaina iweteweteni, ka yai nuanua maketia tomotau inau‑kaiwei kadu ai wava isi‑nai. ");
INSERT INTO mvn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kadue yai nuanua pai manuena ahiahina manua tapanono nihenia ivaniahei, e tomotau mataia imanuena. Kadue kanibutu ai tutea yai nuanua tana‑pwaina imanuena. ");
INSERT INTO mvn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ka kadu tuta habuhabuna tomotau mataia yai viama ivi‑manamana‑vaine. Ka yai viama‑naia vivane viama vitupu, iuna nuai nihenina inuanua medeina apaina wadawadae inonoi, e yai manua ivainaui. Wayahina, apaina taui kadu mani onoto deina ai dewa‑yaiyai ananina ivaniahei Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ka Iesu ine am‑venena‑kavovo a pai vi‑ai wayahina, e mahi‑naona manuena, ka tomotau habuhabui yai am‑venena‑kavovo ivivi‑ai ka Iesu mata‑wapuwapu. Ka kaikaiwabo habuhabui iomomo, e yai am‑venena‑kavovo ananina ibouboui pai vi‑ai nihenina. ");
INSERT INTO mvn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka wadae naunau‑yoguna dudueyei ka yai am‑venena‑kavovo toea ainuata ibouni. ");
INSERT INTO mvn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","E Iesu tauna a tau vi‑muni‑waiwai hone‑hohoni, e vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, wadaena yai am‑venena‑kavovo tomotau habuhabui yai am‑venena‑kavovo vane‑tawane‑neiei. ");
INSERT INTO mvn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iuna tomotaui habuhabui yai tupwa ananina mamaei. Kate wadaena naunau‑yoguna, e yai vitumahana nui avaha yai toea habuhabuna ibou‑yehai. Ka eha aitam yai tupwa ta‑mamae.” ");
INSERT INTO mvn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tutana Manua Vito‑pota wayahina opu‑me, a tau vi‑muni‑waiwai aitam ivona, “Tau Viwavenena, edu! Hanu pai yona taina yai nata ani‑vainei, kadu manua taina habuhabui ai dune ahihi‑vainei!” ");
INSERT INTO mvn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka Iesu nau‑patei, ivona, “Manua taina anani habuhabui edudueyei, a? Ataina hanu habuhabui ivi‑popoi deina, kate apaina eha aitam popona na‑mae. Iuna aitamoata aitamoata wayahia itutu‑guaguani ipeupeu iopuopu.” ");
INSERT INTO mvn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ka Iesu ivane Oya Olive, e manuena Manua Vito‑pota mahi‑naona, ka Pita, ka Iamesa, ka Ioni ka Aniduru iomo wayahina, ka matataui iviamei, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ehaeyeai avi tuta dewaia ivi‑putu. Kadu yama nuanua emai‑voneai avi iaiaya adueyei anꞌ‑anamanei tuta eha ani‑hoina na‑iakwa wayahina dewaia ivi‑putu.” ");
INSERT INTO mvn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka Iesu ya vo‑vi‑maheta mamanaina vi‑putui aitam vona panina wayahina, ivona, “Udune‑vivinimi! Eha nau‑wawanimi aitam koiaka unꞌ‑awaehe na‑nonomi. ");
INSERT INTO mvn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iuna apaina tomotau habuhabui au wava ivainaui, ka ivonevonemi, ina‑vona, ‘Yauke au heta‑ohota Tau Ito‑yavuha‑nana!’ Ka taui ai pata tomotau habuhabui inonoi. ");
INSERT INTO mvn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ka avi tuta havia vaneai unononi, o aituhu tomotau inuanua apaina havia ivi‑putu, eha nau‑wawanimi umatamatauta vaneai wayahia. Iuna Yaubada dewaia nꞌ‑awaehei ivinꞌ‑omo, ka tuta pai nau‑yehata wayahina dewaia munia na‑omo. ");
INSERT INTO mvn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vona ahiahina, mani papani mani papani wayahia ivi‑naua, kadu mani pai veimea mani pai veimea wayahia ivi‑naua. Ka yoyoyo isi‑putuputu papani tunina tunina nihenia, kadu am navovo papani tunina tunina nihenia ivinꞌ‑omo. Dewaia habuhabui viha tutana vaivine ivi‑putu ivi‑natuna deina. ");
INSERT INTO mvn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","11","Udune‑vivinimi dewa aitamoata aitamoata wayahia. Tomotau ina‑mana‑giboemi iuna uvitumahaneu. Ka inꞌ‑am‑veneneyemi meagai ai tau veimea gabemaniV nimaia, ka manua tapanono nihenia imoamoanimi. Ka tomotaui ivihahaieu itainimi umimini papani ai tau veimea mataia, kadu kiniV mataia. Ka taui wayahia uhaehaeyeu. Kate avi tuta inꞌ‑epami inꞌ‑am‑veneneyemi, eha umai‑nuanua toyoina medeina una‑ipupu. Iuna avi tuta nau‑wawanimi uhae wayahiu, babau‑nana nihenina Nuana Ahihinata yami vona na‑venemi, e vonaia una‑ipupu. Ana pata deina, iuna vonaia eha itomi wayahimia ivinꞌ‑omo, kate vonaia ivinꞌ‑omo Nuana Ahihinata ana heta wayahina. Ka tau veimea‑naia ka kini‑naiaV Vaneana Ahiahina unau‑waheyei. Vona ahiahina, yoko habuhabui nau‑wawani naona Vaneana Ahiahina inononi. Ka munia, tuta na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ka vavanei taui vavanei inꞌ‑am‑veneneyei aniga wayahina, ka amamai taui natunatui inꞌ‑am‑veneneyei aniga wayahina, kadu yaheyahe ai veimea amamai ka ayoyoi wayahia ivihahaiei, ka inꞌ‑am‑veneneyei aniga wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ka tomotau habuhabui inua‑goyo‑vainemi iuna yauke au wava usi‑nai. Kate aituhu aviyaivia itoha‑vi‑anai a itoava tuta pai nau‑yehata wayahina, taui ana‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Apaina tomotau aitam amane goyogoyona ivi‑au‑mini papani vito‑potana nihenina. Ka Yaubada amane‑nana nau‑nikonikoiei, ka Ierusalem a nau‑kinakinago vinꞌ‑omo amane‑nana wayahina. Ka dewana munia aioi habuhabui inꞌ‑omo. (Aituhu aviyaivia vona taina iaiaiavi, yau nuanua nuai nꞌ‑am‑haui.) Ka avi tuta me Iudea amane‑nana idudueyei papani vito‑pota‑vainena nihenina, taui nau‑wawani ina‑novo atu‑oyaoyana wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ka tuta‑nana wayahina, aituhu aviyaivia mataeta imamaei, eha ana pata ina‑nui yai manua, e yai gugua inꞌ‑epei, kate taui nau‑wawani ini‑ubau ina‑novo. ");
INSERT INTO mvn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ka tuta‑nana wayahina, aituhu aviyaivia yai baguna nihenina imamaei, eha ana pata imavi‑havine yai megeia, e ai kwama inꞌ‑epei, kate taui nau‑wawani ini‑ubau ina‑novo. ");
INSERT INTO mvn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aioi! tau amwanainahe wayahia kadu tau vi‑nunu wayahia tuta tanoi wayahina! ");
INSERT INTO mvn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nau‑wawanimi uviama dewaia ai vinꞌ‑omana eha kwadudu ana tuta nihenina ivinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iuna auyewaia vivane vita ana tuta. Nonova, tutana Yaubada tanopi vevewanei a itoava tuta ataina wayahina, eha kadu aitam tuta vitana deina ta‑vinꞌ‑omo. Ka munia, avi vita ivinꞌ‑omo tuta tepakaia, eha vita‑naia ivane‑tawane. ");
INSERT INTO mvn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ka Yaubada ya vi‑nua‑hauhau vivane auyewai vo‑vi‑kutei. Aituhu tauna eha ta‑vo‑vi‑kute deina, eha aitam koiaka ana pata vitai itupwa. Ka Yaubada tomotau vi‑nua‑dadanei ito‑yavuha ivaniahei. Wayahina, tauna auyewai vo‑vi‑kutei tomotaui wayahi. ");
INSERT INTO mvn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ka auyewaia nihenina, aituhu aitam koiaka vonemi, ‘Udueyei, yaka Tau Ito‑yavuha baina’, o aituhu aitam vonemi, ‘Udu! Tanoi mamaei’, eha yai vona uvitumahane. ");
INSERT INTO mvn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iuna tau ito‑yavuha vitupu kadu tau apa‑taputapu vitupu ivinꞌ‑omo‑nananena. Ka taui iaiaya kadu dewa‑bagibagi habuhabui ivevewanei, iuna yai nuanua Yaubada ya tomotau inonoi. Kate taui eha ai pata tomotau‑naia avaha Yaubada vi‑nua‑dadanei inono. ");
INSERT INTO mvn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kate itomi nau‑wawanimi udune‑vivinimi! Akanai, yauke avaha dewai habuhabui iomomo apa‑taputapu‑yehai wayahimia. ");
INSERT INTO mvn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ka vita‑naia munia ‘babau ya maheta na‑weu, ka wahava ya maheta eha. ");
INSERT INTO mvn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ka wadima wahuma imemeavuna, ka aviani wahuma ivenavenau ivenau‑tupatupa.’ ");
INSERT INTO mvn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuta‑nana wayahina yauke, Tauna Vi‑tomotau, wahuma aopu‑me you nihenina, ka tomotau yauke yau bagibagi ani‑vainena kadu didigau nui idudueyeu. ");
INSERT INTO mvn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka yauke yau anelose avi‑tunei ine papani aitamoata aitamoata wayahia, ka papani‑naia wayahia taui Yaubada vi‑nua‑dadanei inau‑hohoni iomanei wayahiua. ");
INSERT INTO mvn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aitam pai dune ai madaiba wayahina atana‑minikunemi. Avaha madaiba yawaina itabotabo, avaha uanamanei nau‑sisi ana tuta omomo. ");
INSERT INTO mvn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","31","Wayahina, avi tuta dewa‑naia habuhabui iomomo ududueyei, unꞌ‑anamanei dewa‑naia vivane tuta pai nau‑yehata a iaiaya. Wayahina, unꞌ‑anamanei tuta eha ani‑hoina na‑iakwa wayahina, e amavi‑havine tanopia. Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Apaina wahuma ka tanopi ina‑iakwa, kate yauke yau vona eha ina‑iakwa. Kadu tau maꞌ tanopi imamaei a itoava dewaia habuhabui ina‑nau‑yehai wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ka yauke yau mavi‑havine anꞌ auyewa eha aitam koiaka tꞌ‑anamane. Eha aitam anelose tꞌ‑anamane, kadu yauke taua eha atꞌ‑anamane! Akanai Amaka ana heta auyewana anamanei. ");
INSERT INTO mvn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","34","Nau‑wawanimi udune‑vivinimi, kadu nau‑wawanimi umini‑potepotemi. Iuna auyewana eha utꞌ‑anamane. Aitam pai dune avenemi. Aitam tau veimea ya nuanua yana nae. Wayahina, tauna ya tau paisewa habuhabui hone‑hohoni‑neiei, e aitamoata aitamoata wayahia ai veimea venei, vivane medeina ipaipaisewa a itoava tauna ya mavi‑havine anꞌ auyewa wayahina. Kadu tauna ya manua awana a tau dune‑vi‑avina haeyei, ivona, ‘Nau‑wawanim edune‑vi‑avini ahiahina!’ Ya vo‑vi‑aiai habuhabui iakwa, e ya meagai ni‑tawanei ine mani papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ka itomi nau‑wawanimi udune‑vivinimi aitamoata deina. Iuna eha utꞌ‑anamane avi tuta yauke, manua a tau veimea, amavi‑havine. Kaiwadi, vinanavi, o kadi ioyoma pouna, o kadi kamkam yana tou wayahina, o kadi mana‑putua. ");
INSERT INTO mvn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kaiwadi, aituhu yauke amavi‑havine‑kwayavoni, itomi nau‑wawanimi umimini udunedune, iuna aituhu amavi‑havine, ka aituhu itomi uaino‑ainemi, apaina ini‑yauyau uvaniahei deina. Wayahina, avona‑havinemi, udune‑vivinimi! ");
INSERT INTO mvn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yau mataedana itomi wayahimia. Kate tomotau habuhabui anau‑vi‑avini aitamoata deina. Taui kadu nau‑wawani yawai idune‑vi‑avini!” ");
INSERT INTO mvn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mana navia me Iudea yai auyewa ananina aitam, vivane aitam tonei ana wava Itouvuha Toneina, ka taui yai dewa palauata iamam, eha a pai nata nihenina. Ka tau vi‑nomu mata‑genai ka tau ginuma matataui inaunau‑nene medeina Iesu ipoyꞌ‑avini, iuna yai nuanua ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ka ivona deina, “Itouvuha Toneina ana tuta eha tuta ahiahina yaka vi‑nua‑hauhau wayahina. Iuna apaina, avi tuta tomotau avaha yaka dewa ianamanei, akanai, inua‑goyoeka kadu ivitana‑wahewahe ananina. Ka aituhu tomotau yai dewa deina, apaina me Rom ai tau veimea baina vunuka akanai.” ");
INSERT INTO mvn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka Iesu meagai Betani mamaei, ka omo Simoni Lepero ya manua, ka manuena, e amam. Ka vavine aitam omo Iesu wayahina ka aitam gam omanei. Ka gam‑nana inau‑vevewanei aitam hanu ana wava alabasiteraV wayahina, ka nihenina daudau na manina ani‑vainena ana wava naridaV, vivane naridataV. Daudau‑nana patana ani‑vainena. Ka vavine‑nana gam‑nana otona dobwei, e Iesu unununa wayahina ito‑iwahi. ");
INSERT INTO mvn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka tupwai imamaei, avaha dewana idueyei, magai bawe, ka matataui ivonavona, “Ia! Aviani wayahina daudau‑nana dewa‑kavokavovoei deina? ");
INSERT INTO mvn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Daudau‑nana patana ani‑vainena! Onoto a nau‑pata ponimana aitamoata nihenina vivane eha ana pata. Memeanina kaimwaneyei, e patana tau payapayaya kavene kaivaite deina.” Ka vavine‑nana inau‑vonuvonuei deina. ");
INSERT INTO mvn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kate Iesu ivona, “Itomi ugenuana! Aviani iuna uvona‑yaiyaiei? Vavine taina avaha dewa ahiahina wayahiua dewei. Nau‑wawanika kapa‑vidovidohei wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iuna tuta tuta tau payapayaya nui umamaei. Ka avi tuta yami nuanua una‑ivaitei, ami pata udedewei deina. Kate itomi eha yauke nui kamaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aviani ananina vavine‑nana wayahina, tauna avaha awaehei, e wayahiua dewei deina, vivane ininiu maꞌ‑iwa‑tunutunui au itavuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Memeanina nuami vi‑tupatupa, kate avonemi, papani aitamoata aitamoata wayahina, tanopi taina wayahina, aveta tomotau Vaneana Ahiahina inaunau‑waheyei, tomotau vavine‑nana ya dewana inononi, e vavine‑nana inuanuani.” ");
INSERT INTO mvn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ka Iesu a tau hae anani ai yau 12 wayahia, aitam ana wava Iudasa me Kariota. Tauna omo tau vi‑nomu mata‑genai wayahia, vivane Iesu na‑vauyei wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ka taui, avaha ya vonana inononi, idewa‑haiawa, ka ivona‑dabadaba Iudasa wayahina kina ivenei. Ka tauna awaehei naunau‑nene medeina kadi memeanina na‑vauyei. ");
INSERT INTO mvn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka palaua eha a pai nata toneina anꞌ auyewa naona wayahina, me Iudea yai dewa Itouvuha Toneina a vahitau sipiV ivunui, ivi‑nomui. Ka Iesu a tau vi‑muni‑waiwai iomo tauna wayahina, e ivi‑tanaiei, ivona, “Aveta yam nuanua ana‑ne, e Itouvuha Toneina avo‑vi‑aiai enꞌ‑am?” ");
INSERT INTO mvn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wayahina, Iesu tauna a tau vi‑muni‑waiwai ainua ai veimea venei, ivona, “Ierusalem una‑nei, ka tenoke aitam onoto pai goi na daudauna avavanei na‑vaniahami. Nau‑wawanimi uvi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ka avi manua tauna inui, tau vi‑manua‑nana uvonei, ‘Tau Viwavenena ivona, “Yau tutu‑honota bwanibwani aveta? Iuna au tau vi‑muni‑waiwai nui Itouvuha Toneina anꞌ‑am?” ’ ");
INSERT INTO mvn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ka tauna aitam tutu‑honota ananina hetana na‑viwavenemi, ka avaha itauni‑yehai, tenoke nau‑wawanimi aka maꞌ uvo‑vi‑aiaia, uboui.” Ka ya vonana iakwa, tauna ainua vi‑tunei ine Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ka tau vi‑muni‑waiwai‑naia ine, ka Ierusalem inui, ka dewa habuhabui ivaniahei Iesu ya vonana aitamoata deina. Ka Itouvuha Toneina amna iboui, e munia inꞌ‑am. ");
INSERT INTO mvn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ka avaha vinanavi, e tauna a tau hae anani ai yau 12 nui iomo manua‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ka me Iudea yai dewa deina, iam‑daudauva. Ka Iesu ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aitam wayahimia na‑vauyeu. Ika, tauna nui kamam.” ");
INSERT INTO mvn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka a tau hae nuai ivita, ka aitamoata aitamoata wayahia ivi‑tanatanaiei, ivona, “Kaiwadi, yauke, o kadu aitam?” ");
INSERT INTO mvn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ka tauna vonei, ivona, “Itomi ami yau 12. Ka au tau vauya vivane aitam wayahimia. Ika, tauna ama inua ama palaua nau‑kaia asi‑utuvi. ");
INSERT INTO mvn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vona ahiahina, yauke, Tauna Vi‑tomotau, nau‑wawaniu anꞌ‑aniga Iginuma ana vona wayahiu deina, kate aioi tauna au tau vauya wayahina! Aituhu tauna eha ta‑tupua, tauna vidoha deina.” ");
INSERT INTO mvn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ka habuhabui iamam, ka tauna palaua eha a pai nata epei ka ya viama wayahina Yaubada nau‑kaiwei. Iakwa, palauana pakeui, e vo‑patai, ka ivona, “Unꞌ‑epei, ininiu taina.” ");
INSERT INTO mvn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E vei na wainaV epei, Yaubada nau‑kaiwei, e venei, e habuhabui inimi. ");
INSERT INTO mvn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","E vonei, ivona “Dayahiu taina. Yaubada tauna yanꞌ awaeha vovouna vona‑dabedabei, ka dayahiu aito‑iwahi awaehana ana pata vi‑putu. ");
INSERT INTO mvn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Memeanina nuami vi‑tupatupa, kate avonemi, eha kadu aitam tuta tanopia wainaV ana‑nim. Apaina, tuta tepakaia wayahina, wainaV ana‑nim‑havinei Yaubada ya pai veimea nihenina.” ");
INSERT INTO mvn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ka taui Yaubada inau‑kaiwei yai nau‑senasena wayahina, e ini‑ubau iopu, ivane Oya Olive wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ka Iesu vonei, ivona, “Apaiku habuhabumi unovo‑tawaneu. Yaubada Iginuma nihenina avaha ivona deina, ivona, ‘SipiV A Tau Dune‑vi‑avina avunui, ka sipiV habuhabui iyavuta.’ ");
INSERT INTO mvn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ka apaina, yau mini‑havine munia, papani Galili nihenina apotapotami.” ");
INSERT INTO mvn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka Pita vonei, ivona, “Aituhu habuhabui inovo‑tawanem, yauke eha.” ");
INSERT INTO mvn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kate Iesu vonei, ivona, “Memeanina nuam vi‑tupatupa, kate avonem, ioyoma taina wamke etana‑tavuneu tuta vꞌ‑itonuna wayahina, ka munia, kamkam onotona yana tou vꞌ‑inuana kanononi.” ");
INSERT INTO mvn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka Pita vona panina wayahina vona‑vanevane, ivona, “Aituhu tomotau inau‑vi‑anigika, eha avi‑ebuem, akanai nui kanꞌ‑aniga.” Ka tau hae anani habuhabui ivonavona aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ka iomo baguna ana wava Gedisemane wayahina, e tauna a tau vi‑muni‑waiwai vonei, ivona, “Baina itomi umanuena upotapotau, ka aviama.” ");
INSERT INTO mvn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka tauna Pita, ka Iamesa, ka Ioni hone‑hohoni‑neiei, e na nau‑punina inei enoma. Ka nua‑vita ani‑vainena Iesu nuana epei, ka vitana wayahina tauna nuanua ananina. ");
INSERT INTO mvn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka tauna vonei, ivona, “Aioi! Nuau ivita ani‑vainena, eha ani‑hoina vita‑nana wayahina anꞌ‑aniga. Baina umamaei, ka uduedue aka havia wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ka Iesu ana heta ine enoma, e tanopia ipeu, ka viama, ivona, “Amau, aituhu ana pata, hidahida ana tuta taina ebou‑potei wayahiu.” ");
INSERT INTO mvn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","E ivona, “AbaV (a vo‑vina ‘Amau’), dewa habuhabuna memeanina wayahima. Ka aituhu ana pata, dewa hidahida ana vei taina wayahiua enꞌ‑epei. Kate aituhu yam nuanua ana‑nim, akanai, yau nuanua deina.” ");
INSERT INTO mvn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya viamana iakwa, e mini, mavina aitonu wayahia, ka dueyei taui iaino‑ainei. Wayahina, tauna Pita vonei, ivona, “Simoni, eino‑ainem! Babau aitamoata wayahina aviamem, kate wamke eha am pata, a? ");
INSERT INTO mvn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ami itonu nau‑wawanimi udune‑vivinimi ka uviama nau‑dadana taina eha vane‑tawanemi. Nuaka nihenina yaka nuanua Yaubada kavi‑ateteyei, kate ininika ihanua.” ");
INSERT INTO mvn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ka tauna ni‑tawanei, ine enoma, e viama‑havine. Ka ya viama vꞌ‑inuana a venavenau ya viama naona a venavenau aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iakwa, e mavi‑havine, ka aitonu dueyei taui iaino‑aine‑havinei, iuna matai huna‑dududuna ka eha ai pata ita‑dunedune. Ka avaha imimini, taui eha itꞌ‑anamane medeina ya vonana inau‑pate. ");
INSERT INTO mvn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Ka tauna ine, e ya viama vꞌ‑itonuna boui. Iakwa, mavi‑havine, ka vonei, ivona, “Ia! Itomi medeina? Udaudauva, uvi‑yawai, uaino‑ainemi, a? Goyona a babau avaha vinꞌ‑omo. Umini! Udueyei! Yauke, Tauna Vi‑tomotau, au tau vauya tomotau goyogoyoi nui iomomo wayahiu.” ");
INSERT INTO mvn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ka Iesu ipuipupu, ka tuta aitamoata wayahina Iudasa vinꞌ‑omo. Tauna tau hae anani ai yau 12 wayahia aitam. Ka tauna nui tupwai tomotau iomo. Ka tau vi‑nomu mata‑genai, ka tau ginuma, ka ononotoi anani tomotau‑naia ivi‑nua‑dadanei, ka na inamai kadu na punumai ivi‑tunei Iesu ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iudasa, a tau vauya, tomotaui iaiaya mai‑venei, ivona, “Tauna amaoi, tauna upoyꞌ‑avini ka utaini uneiei ononotoi anani wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ka tutana vinꞌ‑omo Iesu wayahina ivona, “Tau Viwavenena,” ka maoi. ");
INSERT INTO mvn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wayahina, taui Iesu ipoyꞌ‑avini ivo‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka Iesu a tau hae imimini nepena, ka wayahia aitam yana inama si‑waia ka tau vi‑nomu ananina ya tau paisewa tanihana upwa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka Iesu tomotaui vonei, ivona, “Kaiwadi, itomi nau‑wawanimi uvinꞌ‑omo na inamami ka na punumaimi, e yauke tau vainau deina upoyꞌ‑aviniu, a? ");
INSERT INTO mvn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Auyewa habuhabui nihenia Manua Vito‑pota nihenina nui kamamaei, ka tenoke aviwavenena, kate eha uta‑poyꞌ‑aviniu. Kate yami dewa taina ivinꞌ‑omo, e apa‑taputapu tupwai Iginuma nihenina inau‑yehai.” ");
INSERT INTO mvn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka Iesu a tau hae anani habuhabui inovo‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka aitam tupunata Iesu vi‑muniei, ka tauna ana kwama eha, kate pai bwaꞌ lineniV ana heta. Ka tomotau‑naia yai nuanua kadu tauna ipoyꞌ‑avini, ");
INSERT INTO mvn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kate tauna a pai bwaena lineniV venau‑tawanei, ka nagonegonena novo‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ka Iesu itaini ineiei tau vi‑nomu ananina ya manua wayahina, ka tenoke tau vi‑nomu mata‑genai habuhabui, ka ononotoi anani, ka tau ginuma inau‑hohoni. ");
INSERT INTO mvn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ka Pita enoma vi‑muniei, e manua‑nana a tutu‑gana awana wayahina inu, e omo atubou wayahina. Ka tau nau‑havia tupwai imamaei, ka ai yabeyabena wayahina ivivi‑vana. Wayahina, Pita omo, manuena, e vivi‑vana. ");
INSERT INTO mvn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ka manua nihenina tau vi‑nomu mata‑genai, ka tau nau‑hohona habuhabui yai vitana‑dibidibi inene‑dadani. Ka me Iudea yai dewa aituhu tau ipupu ainua yai vona aitamoata, ana pata Iesu ina‑nau‑vi‑anigi. Kate eha aitam aviani goyona ita‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iuna tau ipupu habuhabui ivitupu tauna wayahina, kate taui yai vitupu tunina tunina. Wayahina, eha itꞌ‑awaeha aitamoata. ");
INSERT INTO mvn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tupwai imini ka ivitupu deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ya vonana anononi, tauna ivona, ‘Manua Vito‑pota taina tomotau nimaia iyonei avita‑vovoni, ka auyewa aitonu nihenia au pata kadu aitam manua ayonei, ka manua‑nana eha tomotau nimaia ita‑yone.’” ");
INSERT INTO mvn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kate taui yai vitupu eha itꞌ‑awaeha aitamoata. ");
INSERT INTO mvn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wayahina, tau vi‑nomu ananina yoko niwania mini, e tauna Iesu vi‑tanaiei, ivona, “Medeina? Am pata tomotau taina movi enau‑patai, o eha? Ivitevitem ananina. Enononi, o eha?” ");
INSERT INTO mvn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kate Iesu genuana, eha ta‑ipupu. Ka tau vi‑nomu ananina vi‑tanai‑havinei, ivona, “Kaiwadi, wamke Tau Ito‑yavuha‑nana, Tau Nau‑iaiava‑vavaha Natuna, o eha?” ");
INSERT INTO mvn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka Iesu ivona, “Ika, yauke. Ka apaina itomi habuhabumi yauke, Tauna Vi‑tomotau, ududueyeu Tau Bagibagi‑vavaha ateina amanuena, ka you nihenina amavi‑havine.” ");
INSERT INTO mvn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ka avaha tau vi‑nomu ananina vonaia nononi, tauna, ya maga‑bawe ananina nui, ana kwama si‑yehia, ka ivona, “Ana pata deina! Eha nau‑wawanika kadu aitam tau hae kanononi. ");
INSERT INTO mvn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Itomi avaha tauna movina unononi. Tauna Yaubada apa‑goyogoyoei. Medeina yami vi‑nua‑dadana?” Ka habuhabui iawaehei aitamoata tauna nau‑wawani nꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ka tupwai wayahia iomo, e iaiwaiwani, ka tauna matana ivo‑potepotei, e ipwaipwaikia, ka ivonevonei, ivona, “O, tau apa‑taputapu! Koiaka vunum? Evoneai!” Ka tau nau‑havia itaini ineiei, e ivunuvunui. ");
INSERT INTO mvn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ka Pita manua‑nana upuna mamaei, manua a tutu‑gana nihenina, kate eha manua anꞌ awa‑pota nihenina. Ka ahabana aitam, tau vi‑nomu ananina yanꞌ ahahaba wayahia, omo. ");
INSERT INTO mvn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ka avaha Pita vivi‑vana dueyei, dune‑vi‑anai, e ivona, “Taum Iesu onoto Nasareta nui umamaei.” ");
INSERT INTO mvn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kate Pita tana‑tavuna, ivona, “Eha atꞌ‑anamane aviani wayahina eipuipupu.” Ka tauna mini, e tutu‑gana awana wayahina ine. Ka kamkam onotona itou. ");
INSERT INTO mvn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka ahabanana dune‑havinei, e taui imimini nepena wayahia ivona, “Tauna aitam wayahia.” ");
INSERT INTO mvn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ka Pita tana‑tavuna‑havine. Ka tuta eha ani‑hoina iakwa, ka taui tauna nepena imimini ivona‑havinei, “Vona ahiahina, anamanem wamke aitam wayahia. Iuna wamke me Galili aitam!” ");
INSERT INTO mvn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka Pita vona‑dabadaba wayahia ivona, “Onoto taina wayahina uaipuipupu eha atꞌ‑anamane!” Kadu tauna a bwanata bou hetana, ivona, “Aituhu ataina avitupu, yau nuanua Yaubada dewa‑yaiyaieu!” ");
INSERT INTO mvn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ka tuta‑nana wayahina kamkam onotona yana tou vꞌ‑inuei. Ka Pita Iesu yanꞌ apa‑taputapu nuani, ivona “Etana‑tavuneu tuta vꞌ‑itonuna wayahina, ka munia, kamkam onotona yana tou vꞌ‑inuana kanononi.” E Pita nuana am‑haui, ka nua‑vita ananina, e vi‑putu toutou, ka vi‑mohai. ");
INSERT INTO mvn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ka mata‑hamwahamwanina tau vi‑nomu mata‑genai, ka ononotoi anani, ka tau ginuma, ka tau nau‑hohona habuhabui nui inau‑hohona ivi‑nua‑hauhau medeina Iesu inau‑vi‑anigi. Wayahina, nimana iyohoyohoni ka itaini ineiei Pilate wayahina, inꞌ‑am‑veneneyei. ");
INSERT INTO mvn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka Pilate Iesu vi‑tanaiei, ivona, “Kaiwadi, wamke me Iudea yai kiniV?” Ka Iesu ivona, “Yam vona deina.” ");
INSERT INTO mvn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka tau vi‑nomu mata‑genai Iesu ivitevitei dewa goyogoyoi habuhabui wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wayahina, Pilate Iesu vi‑tanai‑havinei, ivona, “Am vita taina enononi? Medeina yai ipupuna eha etana‑pote?” ");
INSERT INTO mvn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kate Iesu eha aitam vona ta‑nau‑pata wayahina. Wayahina, Pilate nuana vi‑tupatupa. ");
INSERT INTO mvn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka ponimana aitamoata aitamoata wayahina, Itouvuha Toneina ana tuta wayahina, Pilate manua yohona wayahina aitam onoto yavuhi, nꞌ‑awaehei na‑ni‑ubau, koiaka me Iudea ivi‑nua‑dadanei. ");
INSERT INTO mvn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ka tuta tanoi wayahina me Iudea tupwai me Rom yai veimea ivihahaiei, kadu taui me Rom inau‑haviei. Ka aitam wayahia ana wava Barabasa, ka tauna tomotau nau‑vi‑anigi haviana nihenina. Wayahina, me Rom Barabasa yaiana nui ipoyꞌ‑avini, ka manua yohona nihenina ibouni. ");
INSERT INTO mvn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ka yokoia omo Pilate matana, ka taui ihidehidei, ivonavona, “Ataina ana pata aitam onoto eyavuhi wayahiaia, yam dewa ponimana aitamoata aitamoata wayahina deina?” ");
INSERT INTO mvn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ka Pilate vona‑nau‑patei, ivona, “Ika. Kaiwadi, yami nuanua itomi me Iudea yami kiniV ayavuhi wayahimi, a?” ");
INSERT INTO mvn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilate dewa‑dadana Iesu na‑yavuhi. Iuna avaha anamanei tau vi‑nomu mata‑genai ivi‑bwanou Iesu wayahina, e yai nuanua ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kate tau vi‑nomu mata‑genai yokoia inau‑vi‑nehanehai vivane nuai ivo‑vi‑vatui Barabasa wayahina. Akaka yokoia Iesu ivihahaiei, ka Barabasa ana heta ana wava itomatomani. ");
INSERT INTO mvn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wayahina, Pilate vi‑tanaiei, ivona, “Aituhu Barabasa ayavuhi, medeina adewei tauna itomi me Iudea uvi‑wahani yami kiniV wayahina?” ");
INSERT INTO mvn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kate yokoia ivi‑hone‑havihavine, ivona, “Ai nahanaha wayahina etutu‑pwatei, nꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ka Pilate vi‑tanaiei, ivona, “Mehenai? Tauna ya goyona aviani?” Kate taui mainini ivi‑honehone, ivona, “Ai nahanaha wayahina etutu‑pwatei.” ");
INSERT INTO mvn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ka Pilate ya nuanua yokoia vo‑vi‑dewa‑haiawi. Wayahina, Barabasa yavuhi wayahia, ka ya tau nau‑havia veimeyei yavunai wayahina Iesu imoamoani. Ka munia, ai nahanaha wayahina itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ka Pilate ya tau nau‑havia Iesu itaini ineiei Pilate ya manua ananina a tutu‑gana nihenina (manuana ana wava Paraetorium) ka tau nau‑havia yai yoko habuhabui ihone‑hohoni. ");
INSERT INTO mvn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ka tau kaikaiwabo ana kwama yabebeni‑vainena wayahina Iesu ivi‑weteni, ka a kunu‑nabanaba mata‑duduna wayahina imetani, unununa iboui. Mata‑dudu‑nana tonatonana mamanaina, komokuku deina. ");
INSERT INTO mvn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ka ivi‑au‑mini, ka vi‑waipo wayahina ivona, “Kaiwa ananina! Wamke me Iudea yai kiniV!” ");
INSERT INTO mvn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ka kadu guna wayahina unununa ivunu‑havihavinei ka iaiwaiwani. Ka iomo matana, ivi‑tupa‑gum, iaiwaodu vitupu wayahina. Taui ivi‑waipoei deina. ");
INSERT INTO mvn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ka ivi‑waipoei iakwa, e kwamana yabebeni‑vainena iepa‑yavunei, e tauna ana kwama ivi‑weteni‑havinei, ka itaini ineiei iopu, e ai nahenahea itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka tutana etawana ineine aitam onoto me Sirene novi wayahina omomoi. E tauna ipoyꞌ‑avini ka inau‑vi‑nehenehei Iesu anꞌ ai nahanaha nꞌ‑avanei. Onotona ana wava Simoni, ka natunatuna ai wava Alekisanidera ka Rupusa. ");
INSERT INTO mvn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ka tau nau‑havia itaini ineiei papani ana wava Goligota wayahina, (Goligota a vo‑vina “Ununu‑kabwa”, iuna ana dune deina). ");
INSERT INTO mvn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ka wainaV na munamunana aitam, ana wava muroV, iaunu‑vinevinei, ivenei, vivane viha eha vi‑pae ananina, kate Iesu vihahaiei. ");
INSERT INTO mvn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Akaka ai nahanaha tanopia iboui, ka Iesu itutu‑pwatei, e ivi‑au‑mini, igumi. Ka munia, tau nau‑havia‑naia yai nuanua Iesu ana kwama ivo‑patei. Akaka taui matataui ana kwama wayahina iviam‑wanene‑havihavine. ");
INSERT INTO mvn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mana‑putu ka auyewa a niwanina wayahina, Iesu ai nahenahea itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka me Rom yai dewa aituhu aviyaivia itutu‑pwatei, taui nau‑wawani yai goyona iginumi aitam pai iaiava wayahina. Ka Iesu a pai iaiava ivona, “me iudea yai kiniV.” Ka pai iaiava‑nana ai nahenahea itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ka kadu tau vainau ainua nui itutu‑pwatei, aitam Iesu ateina ka aitam akenina. ");
INSERT INTO mvn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ka tomotau tupwai etawana wayahina iomomo ka ineine. Ka taui Iesu wayahina ununui inau‑waiwainoi, ivi‑waipoei, ka imana‑giboei, ivi‑honehone, “Ia! Taum enuanua am pata Manua Vito‑pota evita‑vovoni, e auyewa aitonu nihenia eyone‑havinei, a? ");
INSERT INTO mvn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ataina ai nahenahea ena‑opu‑me, eito‑yavuhim!” ");
INSERT INTO mvn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ka tau vi‑nomu mata‑genai, ka veimea a tau ginuma kadu Iesu ivi‑waipoei, e matataui mainini ivonavona, “Mani tomotau ito‑yavuhi, kate tauna eha ana pata ana heta na‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aituhu tauna yaka Tau Ito‑yavuha, ka aituhu tauna me Isiraeli yaka KiniV, tauna nau‑wawani ai nahanahana wayahina na‑opu‑me kadueyei, e kavitumahanei.” Ka tau vainau ainua ai ai nahanaha wayahia kadu imana‑giboei. ");
INSERT INTO mvn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ka auyewa pouna wayahina, papani habuhabuna vi‑novanei a itoava babau aitonu iakwa wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka vinanavi Iesu movina ani‑vainena wayahina vi‑hone, ivona, “Eloi, Eloi, lama sabakatani?” ka a vo‑vina “Yau Yaubada, Yau Yaubada, aviani iuna evihahaieu?” ");
INSERT INTO mvn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ka tupwai tomotau nepena imimini ya vi‑honena inononi, ka taui ivona, “Unononi, tauna Elidia honehonei.” ");
INSERT INTO mvn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka aitam wayahia nau‑bwanunua ine, e banou epei, e wainaV honahonana nihenina si‑utuvi. Ka guna tabona wayahina tupa‑tonei, e tunei Iesu awana na‑kukui. Ka onotona ivona, “Akanai, kapotapota. Kaiwadi, Elidia na‑omoi ai nahanahana wayahina na‑opu‑meiei, o eha? Kadueyei.” ");
INSERT INTO mvn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ka Iesu maininina vi‑hone, e yawaina iakwa. ");
INSERT INTO mvn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka awa‑potana Manua Vito‑pota awana wayahina kwaikwaioyo am‑yehi‑nuei, hetana wayahina iopu ipuna. ");
INSERT INTO mvn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ka tau nau‑havia ai tau eta‑naonao ai nahanahana matana mimini. Ka tauna avaha Iesu ya vi‑hone nononi, kadu yanꞌ aniga dueyei, ivona, “Vona ahiahina, onoto‑nana vivane Yaubada Natu‑hoina!” ");
INSERT INTO mvn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka vaivine tupwai bana mamanaina imimini iduedue. Aitonu wayahia ai wava taina, aitam Mari me Magidala, ka vꞌ‑inuana Mari wahai, taui Iosese ka taina Iamesa ayoi, ka vꞌ‑itonuna Salome. ");
INSERT INTO mvn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Taui aitonu nonova Iesu ivi‑muni‑waiwaiei, ka ana maꞌ inau‑vevewanei tutana papani Galili itutu‑vivina, kadu vaivine habuhabui, taui Iesu nui nonova ivane‑me Ierusalem wayahina, taui imimini iduedue. ");
INSERT INTO mvn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Me Iudea yai dewa auyewa aitamoata aitamoata iaiaiavi deina. Avi tuta babau onuonu, taui yai auyewa a pai vi‑putu. Ka auyewana Iesu aniga vivane auyewa pai vo‑vi‑aiai taui yai SabataV wayahina, ka avaha vinanavi. Wayahina, Iesu yaiana nau‑wawani ivo‑kwayavoni tau matena ivi‑opuei ai nahenahea, iuna SabataV wayahina ai veimea paisewana ivito‑potei. ");
INSERT INTO mvn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Akaka aitam onoto, ana wava Iosepa, tauna me Arimatea, omoi. Ka tauna me Iudea yai tau nau‑hohona ka yai tau eta‑naonao aitam, ka ya vitumahana nui potapota avi tuta Yaubada ya pai veimea tanopia vi‑putu. Ka Iosepa yanꞌ ate‑vatu nui omo Pilate matana, ka ya viama boui vivane Pilate Iesu tau matena awaehei unuvovoa na‑boui. ");
INSERT INTO mvn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka Pilate yauna inovo, ivona, “Ia! Vona ahiahina, avaha aniga?” Akaka tau nau‑havia ai tau eta‑naonao honei. Tauna omo, e Pilate vi‑tanaiei, ivona, “Medeina, Iesu avaha aniga?” ");
INSERT INTO mvn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ka tauna ivona, “Ika, avaha aniga.” Wayahina, Pilate Iosepa ya viamana awaehei Iesu tau matena nꞌ‑epei. ");
INSERT INTO mvn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ka Iosepa kaleko lineniV kavukavuna vi‑maiei omanei, e Iesu tau matena ai nahenahea opu‑meiei, e kalekona lineniV wayahina umei. Iakwa, unuvovoa boui. Ka unuvovona nonova ihana‑nibei hanu nihenina, ka hanu ani‑vainena ka yanayanana vo‑bwatabwata‑vinei, e unuvovona awana ibou‑potei deina. ");
INSERT INTO mvn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ka Mari me Magidala ka wahana Mari (Iosese ayona) unuvovona idudueyei. ");
INSERT INTO mvn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ka avaha SabataV iakwa, Mari me Magidala, ka Iamesa ayona ai wava Mari, ka Salome, aitonu gugua ivi‑maiei mutumutu deina, e taui yai nuanua ina‑ne, e Iesu tau matena iaiwa‑tunutunui. ");
INSERT INTO mvn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ka mana‑putua tutana babau vinꞌ‑omo wiki anꞌ auyewa naona wayahina taui ineine unuvovoa. ");
INSERT INTO mvn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ka aitonu matataui ivi‑tanatanaiei, ivonavona, “Koiaka ana pata unuvovona awana hanu‑nana ani‑vainena vo‑bwatabwata‑vinei wayahika?” ");
INSERT INTO mvn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ka ivenavenau, kadu ivonavona deina, e idune‑vane, ka hanu‑nana ani‑vainena idueyei avaha unuvovona awaniana mamaei. ");
INSERT INTO mvn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ka unuvovona inui, ka tupunaina aitamoata nihenina idueyei, ka tauna Iesu tau matena a pai vi‑ai ateina manuena, ka ana kwama kavukavuna. Ka taui nuai vi‑tupatupa ananina, kadu imatamatauta. ");
INSERT INTO mvn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ka tauna wayahia vonei, ivona, “Eha umatamatauta. Iesu onoto Nasareta, itutu‑vi‑nahenahei, ka tauna unenenei. Kate tauna avaha mini‑havine. Eha baina ta‑mamae. Udu, a pai vi‑ai awakabina! ");
INSERT INTO mvn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ka una‑ne, e a tau vi‑muni‑waiwai kadu Pita uvonei, ‘Iesu papani Galili wayahina eta‑naonaoemi. E tanoi wayahina udueyei, nonova ya vonana wayahimia aitamoata deina.’” ");
INSERT INTO mvn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka unuvovo‑nana wayahina ini‑ubau, ka yai nua‑tupatupa nui itatatava ka inovo ine. Ka eha aitam koiaka wayahina ita‑mataede, iuna imatamatauta ananina. ");
INSERT INTO mvn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu mini‑havine mana‑putua wiki anꞌ auyewa naona wayahina, ka naona tauna omo Mari me Magidala wayahina, e ivi‑tepa‑duedue. Nonova Iesu nua goyogoyoi ai yau 7 Mari me Magidala nihenina epa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ka Mari, avaha tauna dueyei, ine taui nonova Iesu nui imamaei. Taui yai nua‑vita ananina nui ivi‑mohai. Ka Mari vonei, ivona, “Iesu mini‑havine kadu avaha adueyei!” ");
INSERT INTO mvn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka avaha Mari ya vonana inononi, vivane Iesu yawayawaina kadu Mari avaha dueyei, eha ai pata ivitumahane. ");
INSERT INTO mvn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ka munia, onoto ainua udana a etawana ineine, ka Iesu omo wayahia. Ininina ana dune tunina. ");
INSERT INTO mvn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wayahina, ainua imavi‑havine Iesu a tau vi‑muni‑waiwai wayahia, e ihaeyei. Kate a tau vi‑muni‑waiwai eha kadu taui yai mataeda ita‑vitumahane. ");
INSERT INTO mvn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ka munia, Iesu a tau hae anani ai yau 11 matataui imanuena ka iamam, e Iesu vinꞌ‑omo wayahia. Ka Iesu vona panina wayahina yapoi, iuna aituhu aviyaivia ya mini‑havine avaha idueyei imataedai, mataeda habuhabui ivihahaiei. Ka kadu Iesu yapoi iuna taui nuai toyoina. ");
INSERT INTO mvn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ka tauna ai veimea venei, ivona, “Papani aitamoata aitamoata wayahina tanopi habuhabuna wayahina una‑ne, ka Vaneana Ahiahina unaunau‑waheyei tomotau habuhabui wayahia. ");
INSERT INTO mvn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ka aituhu aviyaivia ivitumahanei, ka kadu aituhu yai bapitaiso ivaniahei, ana‑ito‑yavuhi. Kate aituhu aviyaivia eha ita‑vitumahane, taui dewa goyona idedewei. Wayahina, apaina ai dewa‑yaiyai ivaniahei Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka aituhu aviyaivia ivitumahaneu, yai awaeha ivaniahei iaiaya taina idedewei, e tomotau idudueyei. Taui ai pata au wavea nua goyogoyoi iepa‑yavunei, kadu ai pata movi vovoui wayahia ivonavona. ");
INSERT INTO mvn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kadu ai pata mwata honahonana nimaia iepepei, ka aituhu daudau honahonana inimi, eha na‑honai, kadu ai pata nimai tau kwanakwanaha wayahia ibouni, e ividoha.” ");
INSERT INTO mvn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ka avaha Kauvea Iesu vonana ipupu‑yehai, Yaubada tauna si‑nai wahuma, ka tauna Yaubada ateina manuena. ");
INSERT INTO mvn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ka a tau vi‑muni‑waiwai papani aitamoata aitamoata nihenina ini‑keyekeyei, inaunau‑wahe, ka Kauvea Nuana nui imamaei, ka kadu Kauvea taui nui ipaipaisewa. Ka tauna awaehei iaiaya idedewei, ka iaiaya‑naia wayahia tauna vo‑vi‑meani tau maꞌ tanopi a tau hae yai nau‑wahe ivitumahanei. Ana pata deina. Yauke Marika ");
INSERT INTO mvn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Bada, Teopilusi, am wava ananina, ka anau‑kaiwem. Ataina amataedam vivane yaka Tau Ito‑yavuha avaha vinꞌ‑omoi, ka tauna ana wava Iesu. Tomotau dewai habuhabui idedewei Iesu wayahina, ka tauna dewa‑bagibagi habuhabui dedewei tanopia. Tupwai tomotau dewaia habuhabui idueyei mataia, vivane dewai naona a itoava dewaia pai nau‑yehata wayahina, ka tau dune‑naia ivi‑tau paisewa Yaubada wayahina, ka avaha dewaia tomotau habuhabui imataedai, inononi. Ka tau dune‑naia tupwai avaha Iesu vaneana iginumi‑yehai, ka iginumaia tunuhina taui mataia deina. Ka taui yai iginuma ka kadu itoka yaka vitumahana vivane aitamoata. Ka kadu yauke dewaia habuhabui, tuta nonova omomo tuta ataina wayahina, anamane‑vidohei, kate yauke eha mataua ata‑dueye. Wayahina, nuanuau dewaia habuhabui aipupu‑vidohem. ");
INSERT INTO mvn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Avaha dewaia vaneana enononi, kate yau nuanua dewaia aitamoata aitamoata amataedam dewaia ivinꞌ‑omo deina. Na‑iakwa, enꞌ‑anamanei dewaia habuhabui eha vitupu, kate vona tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yau ipupu taina vi‑putu tutana KiniV Erodi papani Iudea veimeyei. Ka tau vi‑nomu aitam ana wava Sekaria mamaei, ka tauna yana dede vivane Aroni, ka wanohina ana wava Abia. Ka Sekaria ya vavine ana wava Elisabeti, ka Elisabeti kadu yana dede vivane Aroni. ");
INSERT INTO mvn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ainuai yai dewa habuhabuna tunuhina Yaubada matana, ka ainuai Yaubada ya veimea iaupu‑moimoihei ahiahina. ");
INSERT INTO mvn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kate taui eha natui, iuna Elisabeti gagana, ka ainuai avaha ivi‑nainai. ");
INSERT INTO mvn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ka aitam tuta wayahina Sekaria yana yoko yai tuta vinꞌ‑omo vi‑nomu inau‑vevewana me Iudea habuhabui wayahi. Ka aitam auyewa wayahina Sekaria ana heta vi‑nomu nau‑vevewanei Yaubada matana. ");
INSERT INTO mvn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ka tau vi‑nomu yai dewa deina. Taui inau‑hohona, e aitam yaiai wayahia ivi‑nua‑dadana amane wayahia. Ka amane‑naia ionei tanopia, idueyei, e inꞌ‑anamanei koiaka wayahia Yaubada vi‑nua‑dadanei Kauvea ya Manua Vito‑pota na‑nui, e manina hunahunana pai vi‑nomu wayahina na‑tunu. ");
INSERT INTO mvn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ka auyewana wayahina, tutana vi‑nomu ana tuta vinꞌ‑omo, tau tapanono habuhabui inau‑hohona Manua Vito‑pota mataetana, e iviama. ");
INSERT INTO mvn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka Yaubada yanꞌ anelose aitam omo Sekaria wayahina, ka Sekaria dueyei vivane vi‑nomu a pai vi‑ai ateina wayahina mimini. ");
INSERT INTO mvn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ka tutana Sekaria dueyei, nuana dadana kadu matauta ananina epei. ");
INSERT INTO mvn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka anelose‑nana ivona, “Sekaria, eha ematauta. Yaubada avaha yam viama nononi, ka apaina awam Elisabeti natum onotona vi‑natunei, ka am veimea Yaubada wayahina mamaei, vivane evi‑wahani Ioni. ");
INSERT INTO mvn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ka tauna wayahina udewa‑haiawa, kadu tomotau habuhabui idewa‑haiawa yam tevana ya tupua wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iuna apaina Yaubada nꞌ‑awaehei natum ana wava ananina. Ka tauna a veimea Yaubada wayahina mamaei, vivane wainaV vito‑potana tauna wayahina, ka kadu daudau bagibagina aitamoata aitamoata vito‑potana tauna wayahina. Eha ana pata tauna daudau‑nana na‑nim. Ka apaina, tauna ya tupua ana tuta wayahina, Yaubada Nuana Ahihinata ininina nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ka tauna ya paisewa wayahina me Isiraeli habuhabui na‑eta‑naoi imavina Kauvea yai Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ka naona tauna na‑omo, e ya paisewa paipaisewei. Ka munia, Kauvea na‑omo. Ka apaina, natum ya paisewa bagibagina ka ate‑vatuna ananina nui, tau apa‑taputapu Elidia ya paisewa nonova deina. Ka natum ya nau‑wahe wayahina ononotoi nuai na‑si‑mavinei natunatui wayahia, e inuanua‑havinei. Ka kadu ya nau‑wahe wayahina taui ununui toyoina, e Yaubada ya veimea itana‑bwegebwegei na‑si‑magiginoei etawana tunutunuhina wayahina. E Kauvea tauna ya tomotau na‑vo‑vi‑aiaiei Tau Ito‑yavuha yanꞌ omana wayahina deina.” ");
INSERT INTO mvn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ka Sekaria anelose‑nana vonei, ivona, “Yam vonaia nua‑tupatupana wayahiua, iuna yauke avaha avi‑onoto ananiu ka yau vavine kadu vi‑vavine ananina.” ");
INSERT INTO mvn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka anelose‑nana ivona, “Ia! Yauke au wava Gabarieli! Ka tuta habuhabuna Yaubada matana amimini, ka ataina tuta tauna vi‑tuneu aomo vane ahiahina ahaeyei wayahima. ");
INSERT INTO mvn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ka wamke yau vane wayahima eha eta‑vitumahane. Wayahina, ataina meam na‑danu awam hetana wayahina, ka wamke eha am pata ena‑ipupu a itoava yau vane anꞌ anamana ahiahina vinꞌ‑omo wayahina. Ika, naona yau vane taina na‑omo, ka munia, wamke am pata ena‑ipupu‑havine.” ");
INSERT INTO mvn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka tomotau habuhabui Manua Vito‑pota mataetana ipotapota tuta mamanaina Sekaria ya mavina wayahina, kadu inuanua aviani iuna Sekaria vi‑kiwada nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka munia, tutana Sekaria ni‑ubau iopu, tauna eha ana pata na‑ipupu wayahia, ka meana ivita. Dewana wayahina ianamanei avaha Manua Vito‑pota nihenina yana dune dueyei vivane iaiaya. Tauna nimana vi‑yoyoei, iuna eha ana pata na‑ipupu wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka avaha Sekaria ya vi‑nomu anꞌ auyewa tupwai iakwa, tauna Ierusalem ni‑tawanei, e mavi‑havine ya megeia. ");
INSERT INTO mvn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tuta tanoi munia, ya vavine Elisabeti amwanainahe. Ka wahava ai yau 5 nihenia Elisabeti eha ta‑ni‑awana, kate manua nihenina mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ka Elisabeti ivona, “Au yava taina Yaubada wayahina. Nonova gaganiu, wayahina aini‑yauyau, ka ataina tuta ini‑yauyau‑nana avaha iakwa.” ");
INSERT INTO mvn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ka avaha Elisabeti a wahava vi‑6‑na iakwa, Yaubada tauna yanꞌ anelose Gabarieli vi‑tunei opu‑me papani Galili wayahina, aitam meagai ana wava Nasareta wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ka Gabarieli omo aitam ahabana nuanua‑hanina wayahina ana wava Mari. Ahabana tauna Iosepa wayahina ivi‑awa‑kanakanapiei, ka onotona KiniV Davida ya tupua‑nenenehi aitam. ");
INSERT INTO mvn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka anelose‑nana omo, vonei, ivona, “Kaiwa ananina, Mari! Kauvea ya dune‑nuanuai ananina wayahima! Tauna ya nuanua na‑nau‑iaiavam.” ");
INSERT INTO mvn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ka Mari nuana imwage, ka nuanua ananina vonana anꞌ anamana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka anelose‑nana ivona, “Mari, eha ematauta. Yaubada ya dune‑nuanuai ananina wayahima mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka apaina enꞌ‑amwanainahe ka natum onotona evi‑natunei, ana wava uvi‑wahani Iesu. ");
INSERT INTO mvn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Apaina tauna ana wava ani‑vainena, ka tomotau inꞌ‑awaehei tauna vivane Yaubada Natu‑hoina. Ka Kauvea Yaubada nꞌ‑awaehei natum ya veimea bagibagina vaniahei, tauna wana Davida ya veimea aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ka tauna Iakobo yana dede na‑veimeyei, ka ya veimea vivane maꞌ‑vavaha, eha ana pata na‑iakwa.” ");
INSERT INTO mvn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ka Mari vi‑tanai anelose‑nana wayahina, ivona, “Medeina yauke natu avi‑natune? Iuna ataina eha ata‑tavine.” ");
INSERT INTO mvn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka anelose‑nana ivona, “Apaina Nuana Ahihinata na‑opu‑me wayahima, ka Yaubada na‑vo‑vi‑bagibagim, e am pata natum evi‑natunei. Ka tevanina vivane Yaubada Heta‑hoina Natuna, ka kadu tauna Ahihinata. ");
INSERT INTO mvn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ka vaneim Elisabeti avaha vi‑vavine ananina, ka nonova gagana, kate ataina tauna kadu amwanainahe, ka avaha a wahava vi‑6‑na vaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dewaia ivinꞌ‑omo deina, iuna Yaubada ana pata dewa habuhabuna wayahina. Eha aitam aviani vitana tauna wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Vonana iakwa, e Mari ivona, “Yauke Yaubada ya tau paisewa vavinena. Aviani yam vona wayahiua, akanai yau nuanua na‑omo deina.” Ka anelose‑nana Mari ni‑tawanei, ine. ");
INSERT INTO mvn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka dewaia munia Mari mini, vo‑vi‑aiai, e ya meagai ni‑tawanei, e vo‑kwayavonina omo vaneina Elisabeti ya meagai wayahina. Ka meagai‑nana atu‑oyaoyana mamaei papani Iudea nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ka Mari Sekaria ya manua inui, ka vaneina Elisabeti nau‑kaiwei. ");
INSERT INTO mvn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ka tutana Elisabeti nau‑kaiwa‑nana vaneina wayahina nononi, e tevana madina haihaiawa, ka Nuana Ahihinata Elisabeti nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ka movina ananina wayahina Elisabeti vi‑hone ivona, “Vaneiu, Yaubada dune‑nuanuaiem ananina. Eha kadu aitam ahabana wamke deina, iuna wamke habuhabui evane‑tawanei. Apaina natum evi‑natunei, ka Yaubada kadu tauna na‑dune‑nuanuaiei ananina! ");
INSERT INTO mvn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka medeina wamke yau Kauvea ayona eomo enau‑vi‑tau? Yauke au wava kikituna, kate dewana ededewei wayahiu vivane dewa ananina. Wayahina, adewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iuna tutana yam nau‑kaiwa anononi, e tevana madiua haihaiawa ananina. ");
INSERT INTO mvn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ka wamke Kauvea yanꞌ apa‑taputapu wayahim evitumahanei akanai. Wayahina, apaina yam dewa‑haiawa ananina evaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ka Mari ivona, ");
INSERT INTO mvn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ka nuau nihenina adewa‑haiawa, ");
INSERT INTO mvn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iuna yauke ya tau paisewa aitam, ");
INSERT INTO mvn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iuna Yaubada, Tauna Bagibagi‑vavaha, ");
INSERT INTO mvn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tauna tomotaui imatamatautei ate‑nuanuaiei. ");
INSERT INTO mvn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ka tauna nimana bagibagina tunei, ");
INSERT INTO mvn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tauna avaha tau veimea ai wava ananina ");
INSERT INTO mvn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kadu tauna tau am navovo vi‑ani iam‑iaua ");
INSERT INTO mvn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ka tauna avaha ya vona‑dabadaba ");
INSERT INTO mvn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ika, Yaubada avaha Abaraham nuani, ");
INSERT INTO mvn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ka Mari yanꞌ ahe tanoi nau‑yehai. Ka tauna Elisabeti ainua nui imamaei a itoava wahava aitonu iakwa wayahina deina. Ka munia, Mari mavina ya megeia. ");
INSERT INTO mvn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka tutana Elisabeti vi‑natuna tevana vivane onotona. ");
INSERT INTO mvn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ka yai yoko ka kadu yaiai Yaubada yanꞌ ate‑nuanuai ani‑vainena Elisabeti wayahia inononi kadu habuhabui nui idewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ka tevana yana tuta tupua munia, auyewa ai yau 7 iakwa, e yana yoko inau‑hohona, e tevana ininina idabei. Ka tomotau yai nuanua amana ana wava Sekaria wayahina ivi‑wahani, vivane wahana. ");
INSERT INTO mvn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kate ayona dewana ivito‑potei, ivona, “Eha. Tevana taina ana wava Ioni.” ");
INSERT INTO mvn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka tomotau‑naia ivona, “Wava taina eha itomi ami wava! Eha aitam onoto ana wava Ioni itomi ami dede nihenina.” ");
INSERT INTO mvn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wayahina, taui nimaia ivi‑yoyoei amana wayahina, e ivi‑tanatanaiei medeina tevana ana wava tunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ka Sekaria pai ginuma viamei, e tevana ana wava ginumi, ivona, “Ana wava Ioni.” Ka yokoia habuhabui avaha idueyei, nuai vi‑tupatupa! ");
INSERT INTO mvn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka dewana iakwa, e Sekaria meana vidoha, e tauna ana pata na‑ipupu‑havine, ka ivona, “Yaubada awa‑davedavei!” ");
INSERT INTO mvn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ka Sekaria yaiana habuhabui imatamatauta, ka dewana vaneana tutu‑vivina papani Iudea atu‑oyaoyana habuhabui wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ka aviyaivia viviwavana inononi, taui matataui ivi‑tanatanaiei, ivonavona, “Tevana tanoi koiaka? Medeina ya paisewa?” Ka tomotau habuhabui ianamane‑yehai, e Yaubada ya bagibagi tevana wayahina mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ka Nuana Ahihinata omo Ioni amana Sekaria wayahina, e nau‑vi‑anai, e tauna apa‑taputapu taina deina, ");
INSERT INTO mvn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nau‑wawanika Kauvea kawa‑davedavei! ");
INSERT INTO mvn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ka tauna yaka Tau Ito‑yavuha veneka, ");
INSERT INTO mvn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nonova Yaubada tauna yana vona haeyei ");
INSERT INTO mvn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tauna aka havia bou‑potei wayahikaia, ");
INSERT INTO mvn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ka kadu nonova tauna vona‑dabadaba ");
INSERT INTO mvn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tauna ya vona‑dabadabana boui ");
INSERT INTO mvn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ka vona‑dabadaba‑nana vivane ");
INSERT INTO mvn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ka nau‑wawanika kapaipaisewa ");
INSERT INTO mvn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka wamke, natu, apaina ivi‑wahanim ");
INSERT INTO mvn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka kadu wamke tauna ya tomotau ehaeyei, ");
INSERT INTO mvn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yaka Yaubada dewei deina ");
INSERT INTO mvn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ka ito‑yavuha‑nana na‑vana taui ");
INSERT INTO mvn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ka tevanina nata, ka nuana bagibagina. Ka tauna ya meagai ni‑tawanei, e ana heta mamaei papani anata nihenina a itoava ya paisewa nau‑wahe vi‑putui me Isiraeli mataia wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka Ioni yana tuta tevana wayahina, me Rom ai tau veimea ananina ana wava SisaV Augusitusi. Ka tauna ya veimea boui, e meagai aitamoata aitamoata a tomotau ai wava iginumi, e ina‑iaiavi. Iuna sisa‑nana ya nuanua ya pai veimea Rom a tomotau ai yau nꞌ‑anamanei, ka kadu ya nuanua yoko‑naia aitamoata aitamoata yai takesiV ivituei tunuhina deina. ");
INSERT INTO mvn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Iaiava taina vivane iaiava naona tutana Kuiriniusi papani Siria veimeyei.) ");
INSERT INTO mvn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wayahina, tomotau habuhabui nau‑wawani imavimavine amamai yai meagai wayahia, e tenoke ai wava iginumi. ");
INSERT INTO mvn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wayahina, Iosepa meagai Nasareta papani Galili nihenina ni‑tawanei, ka omo meagai Betelehem wayahina papani Iudea nihenina. Tauna nau‑wawani dewei deina, iuna meagai Betelehem Davida ya meagai, ka Iosepa yana dede vivane Davida yana dede. ");
INSERT INTO mvn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ka tauna Mari ainua iomo, e ai wava iginumi, iuna Mari tauna a vi‑awa‑kanakanapi, ka Mari avaha amwanainahe. ");
INSERT INTO mvn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ka tutana Betelehem nihenina imamaei, avaha a wahava vaniahei vi‑natuna. ");
INSERT INTO mvn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka Mari natuna mai‑tupuina vi‑natunei, ka tevanina kwama wayahina umei, ka vahitau yai pai am nihenina boui, iuna tomotau manua bwanibwani inau‑vi‑anai, ka eha kadu aitam pai maꞌ ta‑mamae wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka papani‑nana nihenina atu‑oyaoyana sipiV ai tau dune‑vi‑avina yai sipiV idune‑vivini ioyomana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka Kauvea yanꞌ anelose aitam ya vinꞌ‑omana vi‑au‑novoi, ka Kauvea didigana tunu‑mahemahei, e sipiV ai tau dune‑vi‑avina‑naia habuhabui imatamatauta ananina. ");
INSERT INTO mvn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ka anelose‑nana vonei, ivona, “Eha umatauta, kate udewa‑haiawa! Iuna vane ahiahina aomanei wayahimia. Ka vane taina tomotau habuhabumi yami pai dewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ka ioyoma taina Davida ya meagai nihenina, yami Tau Ito‑yavuha avaha tupua, tauna yami Kauvea. ");
INSERT INTO mvn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ka iaiaya wayahimi taina. Tevanina na iumana kwama wayahina, ka vahitau yai pai am nihenina daudauva. Avi tuta tevanina uvaniahei, udueyei deinake.” ");
INSERT INTO mvn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ka vo‑kwayavonina anelose habuhabui iomo ka Yaubada iawa‑davedavei, ivonavona, ");
INSERT INTO mvn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yaubada wahuma hetana awa‑davedavei! ");
INSERT INTO mvn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ka avaha anelose‑naia imavi‑havine wahuma, sipiV ai tau dune‑vi‑avina‑naia matataui ivonavona, “Kana‑nei Betelehem, e dewa tanoi Kauvea haeyeka kadueyei.” ");
INSERT INTO mvn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wayahina, ivisina, ine, e Mari ka Iosepa ivaniahai, kadu tevanina vahitau yai pai am nihenina daudauva idueyei. ");
INSERT INTO mvn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ka avaha tevanina idueyei, ivi‑putu anelose‑nana ya vonana tevanina wayahina imataedai mani tomotau wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ka avi tomotau vaneana inononi, akanai habuhabui nuai vi‑tupatupa sipiV ai tau dune‑vi‑avina‑naia yai vonaia wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka Mari yai vonaia habuhabuna nua‑vi‑avini, ka nuanua ananina wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ka sipiV ai tau dune‑vi‑avina‑naia ini‑tawanei, imavina yai sipiV wayahia, ka tutana etawana ivenavenau Yaubada iawa‑davedavei. Iuna dewaia idueyei kadu dewaia inononi habuhabui anelose‑nana ya vonana aitamoata. Wayahina, idewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ka tevanina ya tupua munia, auyewa ai yau 7 iakwa, e wagana idabei, e ivi‑wahani Iesu. Nonova anelose‑nana wavana tomani Mari wayahia tutana eha itꞌ‑amwanainahe. ");
INSERT INTO mvn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ka tuta tupwana munia, aitam auyewa omo, ka Iosepa Mari ainua ai veimea ainua mamaei. Veimea ainua Mosese ya veimea nihenina mamaei. Aitam veimea vonei dewa pai vidoha idewei Mari wayahi. Ka kadu aitam veimea vonei tevanina iam‑veneneyei Kauvea matana. Wayahina, taui tevanina ihuni, ivane Ierusalem wayahina, ka Yaubada iam‑veneneyei Mosese ya veimea veimeyei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ka Kauvea ya veimea taina Iginuma nihenina mamaei, ivona, “Nau‑wawanimi yaheyahe imai‑tupua aitamoata aitamoata ubou‑keyei Kauvea wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka taui ine, e yai pai vi‑nomu Yaubada wayahina ivenei. Iuna Yaubada ya veimea nihenina ivona, “Yami vi‑nomu vivane bunebune ainua, o kadi gabu‑tutuna ainua.” ");
INSERT INTO mvn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka tuta‑nana wayahina Ierusalem nihenina aitam onoto ana wava Simeoni mamaei. Tauna onoto ahiahina, ka yawaina tunutunuhina, ka tuta habuhabuna wayahina tauna Kauvea vi‑ateteyei. Tauna toha‑vi‑anai, ka me Isiraeli yai Tau Ito‑yavuha potepotei. Ka Nuana Ahihinata omo wayahina, e nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ka tuta nonova Nuana Ahihinata apa‑taputapuei ka avaha nua‑uya si‑vinꞌ‑omanei vivane eha ana pata na‑nusi a itoava tauna Tau Ito‑yavuha Kauvea wayahina na‑dueyei matana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ka auyewana wayahina Nuana Ahihinata eta‑naoei, na‑omo Manua Vito‑pota a pai ni‑awana wayahina, e inui ka nihenina mamaei. Ka Iesu ayo‑amana tauna iomanei, e veimea ivi‑ateteyei. ");
INSERT INTO mvn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ka tutana Simeoni dueyei, tevanina epei nimana, e Yaubada nau‑kaiwei kadu awa‑davei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kauvea, wamke am heta‑ohota eveimeyeai. ");
INSERT INTO mvn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iuna taina mata‑hoiua ");
INSERT INTO mvn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nonova yam vi‑nua‑hauhau ");
INSERT INTO mvn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wayahina, tauna vivane maheta ");
INSERT INTO mvn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ka ayo‑amana nuai vi‑tupatupa Simeoni ya vonana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ka Simeoni taui aitonu nau‑iaiavei. Ka kadu ayona Mari vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ka taui yai ipupu wayahina ");
INSERT INTO mvn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ka aitam tau apa‑taputapu vavinena ana wava Ana mamaei. Tauna Panuela natuna kadu yana dede vivane Asera. Ka vavinena avaha vi‑nainai. ");
INSERT INTO mvn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nonova tavine, ka ponimana ai yau 7 iakwa awana inusi, ka vavinena avaha wadae mamaei a itoava a ponimana ai yau 84 vaniahei wayahina. Ka tuta tuta Manua Vito‑pota nihenina mamaei, eha ta‑ni‑tawane. Auyewa kadu ioyoma wayahia vavinena Yaubada vi‑ateteyei ya viama wayahia, kadu dewa‑didiguna am navovo wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka babau‑nana wayahina vavine‑nana omo Manua Vito‑pota a pai ni‑awana wayahina, ka avaha tevana vaniahei, Yaubada nau‑kaiwei. Ka me Isiraeli tupwai yai nuanua ananina vivane Ierusalem a Tau Ito‑yavuha na‑omo idueyei, wayahina ipotepotei. Ka auyewana wayahina vavinena vi‑putu tomotau habuhabui mataedai yai Tau Ito‑yavuha avaha omoi, vivane Iesu. ");
INSERT INTO mvn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ka Iesu ayo‑amana avaha Yaubada ya veimea ana dewa habuhabuna inau‑yehai meagai Ierusalem nihenina, akanai taui papani Iudea ini‑tawanei, imavina papani Galili wayahina, ka iomo taui yai meagai ana wava Nasareta wayahina, ka imamaei. ");
INSERT INTO mvn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ka tevana nata ka ininina bagibagina, ka kadu nua‑uya nau‑vi‑anai. Ka Yaubada tevanina nau‑iaiavei. ");
INSERT INTO mvn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ka ponimana aitamoata aitamoata nihenina Iesu ayo‑amana ivanevane Ierusalem wayahina, e Itouvuha Toneina idedewei. ");
INSERT INTO mvn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ka tutana Iesu a ponimana 12 vaniahei, nui ivane toneina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka avaha toneina iakwa, tomotau habuhabui imavimavina yai megeia, ka tevanina Ierusalem nihenina mamaei, kate ayo‑amana eha itꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Taui eha ita‑dueye, kate inuanua tauna yoko ananina nui imavimavina yai megeia. Ka avaha ioyoma naona iakwa, e taui iomo yai dede wayahia, kadu iomo yaiai wayahia inaunau‑nenei kadu ivi‑tanatanaiei. ");
INSERT INTO mvn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kate eha aitam koiaka wayahia ta‑dueye, e taui inau‑nene‑wayohe. Wayahina, ayo‑amana imagigino imavi Ierusalem wayahina, e tenoke inaunau‑nenei. ");
INSERT INTO mvn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ka avaha auyewa vꞌ‑itonuna iakwa, ivaniahei Manua Vito‑pota a pai nau‑hohona nihenina. Ka tauna me Iudea yai tau viwavenena nui imamaei, e tauna yai vona wayahia vanevaneneha ka kadu vi‑tanatanaiei. ");
INSERT INTO mvn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ka taui habuhabui avaha ya nua‑uya inononi, nuai vi‑tupatupa ananina, iuna ya vona‑nau‑pata tunutunuhina, ka kadu yanꞌ anamana ito‑niuna. ");
INSERT INTO mvn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ka tutana ayo‑amana ivaniahei idueyei, nuai imwage. Ka ayona yapoi, ka vonei, ivona, “Ia! Natuai, aviani wayahina edeweyeai deinake? Amam ama inua yama nua‑vita ananina nui anaunau‑nene‑wayohem.” ");
INSERT INTO mvn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka Iesu vi‑tanaiei, ivona, “Kaiwadi, aviani wayahina uneneu? Eha utꞌ‑anamane vivane yauke nau‑wawaniu Amau ya manua nihenina amamaei? Nau‑wawanimi unꞌ‑anamane deina.” ");
INSERT INTO mvn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ka ayo‑amana nuai eha tꞌ‑am‑hau tauna ya vonana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Akanai ka, Iesu nui imavina Nasareta wayahina, ka tauna yai vona habuhabuna vi‑ateteyei. Kate ayona dewaia habuhabui inuanuani. ");
INSERT INTO mvn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ka Iesu ya nua‑uya nata, ka kadu ininina bagibagina, ka Yaubada kadu tomotau idewa‑haiawa ya dewaia wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka munia aitam ponimana omo, ka tau veimea ai wava tupwai deina. Me Rom ai tau veimea (o kadi yai sisaV) ana wava Tiberiusi, ka tauna avaha vi‑sisaV ponimana ai yau 15 iakwa. Ka papani Iudea a tau veimea Rom wayahina ana wava Ponitiusi Pilate. Ka papani Galili a tau veimea ana wava Erodi, ka tauna vaneina ana wava Pilipi papani Iturea kadu papani Tarakonitisi veimeyei. Ka papani Abilene a tau veimea ana wava Lisaniasi. ");
INSERT INTO mvn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ka Anasi kadu Kaiapasi ainua tau vi‑nomu anani. Ka ponimana tanoi nihenina Yaubada yana vona omo Sekaria natuna ana wava Ioni wayahina. Ka tauna papani anata mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wayahina, Ioni udanata ni‑tawanei, omo Daudau Ioridani a papani wayahina, e tomotau tenoke naunau‑wahei, ivona, “Itomi nau‑wawanimi yami dewa goyona uvihahaiei, e avi‑bapitaisoemi, e Yaubada yami goyona na‑nua‑piahi deina.” ");
INSERT INTO mvn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nonova tau apa‑taputapu ana wava Isaia yana buki nihenina ginumi deina, ka Isaia Ioni yana dewa apa‑taputapuei, ivona, “Tau vi‑hone aitam udanata movina ananina vi‑honehone, ivona, ‘Nau‑wawanimi Kauvea ya etawana uvunahi kadu uvo‑vi‑tunutunuhi, ka ya paisewa uvo‑vi‑meani deina! ");
INSERT INTO mvn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nau‑wawanimi avi awa‑haha ataina imamaei uvi‑nau‑vi‑anai nau‑peuna, kadu avi oya o avi atu‑oyaoyana ataina imamaei utana‑yaveni. Ka nau‑wawanimi avi etawana bwagobwagona uvo‑vi‑tunuhi, kadu avi etawana vitana uvo‑vi‑meani. ");
INSERT INTO mvn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iakwa, e tomotau habuhabui ito‑yavuha Yaubada wayahina idueyei!’” ");
INSERT INTO mvn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ka tomotau habuhabui iomomo Ioni wayahina, iuna yai nuanua tauna vi‑bapitaisoei, ka Ioni naunau‑wahei, ivona, “Ia! Taumi tau vitupu, mwata deina! Avaha uanamanei Yaubada ya nua‑goyo kadu ya dewa‑yaiyai inꞌ‑omo, ka ataina yami nuanua dewaia ainua una‑novo‑tawanei, a? ");
INSERT INTO mvn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Akanai ka, nau‑wawanimi yami nua‑vinana ahiahina Yaubada uviwavenei yami dewa ahiahina wayahia. Eha uvonavona wayahimia, ‘Itoai Abaraham ya tupua‑nenenehi. Wayahina, vona ahiahina, Yaubada dune‑nuanuaieai.’ Ataina avonemi eha ana pata! Memeanina Yaubada wayahina hanu taina wayahia tauna Abaraham ya tupua‑nenenehi vovoui vevewane‑neiei. ");
INSERT INTO mvn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Udune‑vivinimi! Aituhu yami dewa eha ahiahina, tuta eha ani‑hoina na‑iakwa wayahina Yaubada na‑tana‑yavunemi, tomotau ai eha uana ahiahina itana‑yavunei aitamoata deina. Ka Yaubada ai ananata nihenina na‑onemi nꞌ‑anaimi.” ");
INSERT INTO mvn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka yokoia Ioni ivi‑tanaiei, ivona, “Aituhu yam vonana tunuhina, aviani nau‑wawaniai adedewei, e avidoha Yaubada matana?” ");
INSERT INTO mvn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ka Ioni vona‑nau‑pata, ivona, “Aituhu aviyaivia wayahimia ami kwama ainua, ka aituhu koiaka eha ana kwama, akanai tauna aitam uvenei. O aituhu aviyaivia wayahimia ami maꞌ anani, akanai tau am navovo uvo‑patai.” ");
INSERT INTO mvn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ka takesiV a tau vitue tupwai iomo ai bapitaiso wayahina, ka taui Ioni ivi‑tanaiei, ivona, “Tau Viwavenena, medeina eveimeyeai?” ");
INSERT INTO mvn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka Ioni ivona, “Nau‑wawanimi takesiV uvivitue takesiV a veimea aitamoata deina, ka eha yami nuanua uboubou hetana.” ");
INSERT INTO mvn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka tau nau‑havia tupwai ivi‑tanaiei, ivona, “Ka itoai medeina ama veimea?” Ka Ioni ivona, “Eha tomotau uvo‑vi‑matautei, e taui yai kina ivenevenemi, ka eha uvitupu‑kavokavovo tomotau wayahia. Ka nau‑wawanimi ami nau‑pata ataina wayahina udewa‑haiawa. Eha tuta tuta unau‑vonuvonu ami nau‑pata wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ka tomotau habuhabui Tau Ito‑yavuha yana omana ipotepotei, ka tupwai inuanua‑mwagemwage tauna vivane Ioni. ");
INSERT INTO mvn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wayahina Ioni vonei, ivona, “Yauke daudaua avi‑bapitaisoemi. Ka aitam onoto muniua omomoi, ka tauna vi‑bapitaisoemi dewa ainua wayahia, vivane Nuana Ahihinata wayahina, ka kadu ai ananata wayahina. Ka tauna bagibagi‑tawaneu deina. Eha nau‑wawaniu aena anꞌ ae‑yapayapa a manawa ayavuhi, iuna tauna ananina, ka yauke kikitu. ");
INSERT INTO mvn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ka onoto‑nana yana ipea witiV na‑yueyue, e uana imaumaua. Ka munia, tauna uana ahiahi na‑totohi yanꞌ anana nihenina, ka hainina ai ananata‑vavaha nihenina na‑tunui.” ");
INSERT INTO mvn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ka Ioni tomotau naunau‑wahei vona habuhabuna ka tunina tunina wayahia, ka Vaneana Ahiahina naunau‑waheyei. ");
INSERT INTO mvn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kate Ioni KiniV Erodi yapoyapoi, iuna Erodi avaha vaneina awana ai wava Erodiasa awa‑nemei ka tavine‑tamanei, ka Ioni kadu Erodi ya goyona tunina tunina haehaeyei. ");
INSERT INTO mvn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ka aitam auyewa Erodi Ioni poyꞌ‑avini, e manua yohona nihenina boui. Ka dewana wayahina Erodi tauna ya dewa goyona vo‑vi‑natei. ");
INSERT INTO mvn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ka tuta tanoi wayahina, tutana Ioni ni‑awana ka paipaisewa, tauna yoko habuhabui vi‑bapitaisoei. Ka munia, kadu Iesu omo wayahina, e Ioni kadu Iesu vi‑bapitaisoei. Ka Iesu Yaubada wayahina viama, ka wahuma am‑waei, ");
INSERT INTO mvn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ka Nuana Ahihinata opu‑me Iesu wayahina aitam bunebune deina. Ka aitam movi wahuma wayahina Iesu vonei, ivona, “Wamke Natu‑hoiu adune‑nuanuaiem, ka wayahim adewa‑haiawa ananina.” ");
INSERT INTO mvn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ka tutana Iesu a ponimana ai yau 30 vaniahei, tauna ya paisewa tomotau wayahia vi‑putu. Ka tomotau habuhabui ivitumahana‑kavokavovo vivane tauna amana Iosepa. Ka Iosepa amana Eli ");
INSERT INTO mvn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ka Eli amana Matati ka Matati amana Levi ka Levi amana Meliki ka Meliki amana Ianai ka Ianai amana Iosepa. ");
INSERT INTO mvn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ka Iosepa amana Matatiasi ka Matatiasi amana Amosa ka Amosa amana Nahum ka Nahum amana Esili ka Esili amana Nagai. ");
INSERT INTO mvn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ka Nagai amana Maati ka Maati amana Matatiasi ka Matatiasi amana Semeini ka Semeini amana Ioseki ka Ioseki amana Ioda. ");
INSERT INTO mvn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ka Ioda amana Ioanani ka Ioanani amana Resa ka Resa amana Serubabela ka Serubabela amana Sealitieli ka Sealitieli amana Neri. ");
INSERT INTO mvn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ka Neri amana Meliki ka Meliki amana Adi ka Adi amana Kosam ka Kosam amana Elimadam ka Elimadam amana Eri. ");
INSERT INTO mvn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri amana Iosua ka Iosua amana Elieseri ka Elieseri amana Iorim ka Iorim amana Matati ka Matati amana Levi. ");
INSERT INTO mvn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ka Levi amana Simeoni ka Simeoni amana Iuda ka Iuda amana Iosepa ka Iosepa amana Ionam ka Ionam amana Eliakim. ");
INSERT INTO mvn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ka Eliakim amana Melea ka Melea amana Mena ka Mena amana Matata ka Matata amana Natani ka Natani amana Davida. ");
INSERT INTO mvn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ka Davida amana Iese ka Iese amana Obedi ka Obedi amana Boasa ka Boasa amana Salimoni ka Salimoni amana Nasoni. ");
INSERT INTO mvn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ka Nasoni amana Aminadaba ka Aminadaba amana Adamini ka Adamini amana Arani ka Arani amana Esironi ka Esironi amana Peresi ka Peresi amana Iuda. ");
INSERT INTO mvn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ka Iuda amana Iakobo ka Iakobo amana Isaki ka Isaki amana Abaraham ka Abaraham amana Tera ka Tera amana Naori. ");
INSERT INTO mvn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ka Naori amana Seruge ka Seruge amana Reu ka Reu amana Pelegi ka Pelegi amana Eberi ka Eberi amana Sela. ");
INSERT INTO mvn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ka Sela amana Kainani ka Kainani amana Arapakisadi ka Arapakisadi amana Semi ka Semi amana Noa ka Noa amana Lameki. ");
INSERT INTO mvn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ka Lameki amana Metusela ka Metusela amana Enoki ka Enoki amana Iaredi ka Iaredi amana Mahalaleli ka Mahalaleli amana Kenani. ");
INSERT INTO mvn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ka Kenani amana Enosi ka Enosi amana Seti ka Seti amana Adam ka Adam amana Yaubada. ");
INSERT INTO mvn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ka Iesu a bapitaiso Daudau Ioridani iakwa, e Nuana Ahihinata nau‑vi‑anai, e papani udanata wayahina taini neiei. ");
INSERT INTO mvn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ka auyewa ai yau 40 nihenia Satana dewa‑dadani Iesu na‑vo‑vi‑peu nau‑dadana wayahina. Ka auyewaia nihenia Iesu eha tꞌ‑amam, wayahina am navovo‑vaine. ");
INSERT INTO mvn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ka Satana Iesu vonei, ivona, “Wamke Yaubada natuna akanai. Wayahina, am pata hanu taina eveimeyei ivi‑palaua, enꞌ‑am.” ");
INSERT INTO mvn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka Iesu ivona, “Iginuma nihenina veimea mamaei, ivona, ‘Tomotau eha ividoha aniani ana heta wayahina.’” ");
INSERT INTO mvn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ka dewana iakwa, e Satana Iesu taini‑vaneyei oya tabona, e vo‑kwayavonina Satana amane vevewanei mayamayau deina, ka tauna tanopi a pai veimea aitamoata aitamoata Iesu viwavenei, ka vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Edueyei! Pai veimea habuhabui taina yauke yau pai veimea. Ka koiaka avi‑nua‑dadanei, akanai tauna avenei vivane ya pai veimea. ");
INSERT INTO mvn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aituhu wamke wayahiua ena‑iwaodu, akanai avenem, eveimeyei. Ka kadu ai gugua habuhabuna vivane yam gugua, kadu didigam.” ");
INSERT INTO mvn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka Iesu ivona, “Iginuma nihenina veimea mamaei, ivona, ‘Yam Kauvea Yaubada a heta‑ohota wayahina ena‑iwaodu, ka nau‑wawanim tauna yana vona evi‑ateteyei.’” ");
INSERT INTO mvn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ka dewana iakwa, e Satana Iesu taini neiei meagai Ierusalem wayahina, e Manua Vito‑pota heta‑hoina vaneyei, ka vonei, ivona, “Wamke Yaubada natuna akanai. Wayahina, aituhu eni‑ubau, eha aitam inahe evaniahe. ");
INSERT INTO mvn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iuna Iginuma nihenina ivona deina, ‘Yaubada tauna yanꞌ anelose na‑veimeyei, e taui idune‑vivinim. ");
INSERT INTO mvn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wayahina, taui ikamom nimaia, ivo‑epam. Ka eha aem inahe hanu wayahia.’” ");
INSERT INTO mvn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka Iesu vona‑nau‑patei, ivona, “Vona aitam mamaei Iginuma nihenina, ivona, ‘Eha yam Kauvea Yaubada enau‑dadani.’” ");
INSERT INTO mvn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ka avaha Satana ya nau‑dadana habuhabuna tanoi Iesu wayahina nau‑yehai, e ni‑tawanei. Ka munia, avi tuta vitana Iesu wayahina kadi memeanina Satana wayahina, akanai Satana mavina, e nau‑dadana‑havinei. ");
INSERT INTO mvn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ka Iesu mavina papani Galili wayahina, ka Nuana Ahihinata ya bagibagi nihenina mamaei. Ka me Galili habuhabui vaneana inononi. ");
INSERT INTO mvn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ka tauna omomo yai manua tapanono wayahia, e naunau‑wahei, ka taui habuhabui iapa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka munia, Iesu omo meagai Nasareta wayahina. Ponimana habuhabuna iakwa, e tauna meagai‑nana nihenina natanata, ka tanoi ayo‑amana inau‑matava. Ka aitam auyewa tapanono wayahina Iesu manua tapanono inui, yana dewa deina, e mini, Iginuma na‑iaiavi. ");
INSERT INTO mvn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka tau apa‑taputapu Isaia ya iginuma ivenei, e tauna si‑yamwayamwani, e upwa taina vaniahei, e iaiavi, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kauvea Nuana wayahiua mamaei, Iuna tauna vi‑nua‑dadaneu Vaneana Ahiahina tau payapayaya anaunau‑wahei. Ka kadu vi‑tuneu aomo taui Satana yohoyohoni wayahia, ai ito‑yavuha ahaehaeyei. Ka kadu taui matai goyogoyona wayahia yai vidoha‑havine ahaehaeyei. Ka kadu tau maꞌ vita ai havia nimaia ana‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ka kadu amataedami, aitam ponimana mamaei, ka ponimanana nihenina Kauvea tauna ya tomotau na‑nau‑iaiavei.” ");
INSERT INTO mvn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ka Iesu avaha Iginumana iaiavi‑yehai, nunumi, e Iginuma‑nana a tau dune‑vi‑avina vene‑havinei, e manuena. Ka tauna tau vaneneha habuhabui nuai epei, ka idune‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka tauna vonei, ivona, “Apa‑taputapu tanoi avaha aiaiavi unononi ataina tuta anꞌ anamana vaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ka taui habuhabui nuai vi‑tupatupa ya vonana ahiahina wayahina, ka iapa‑vidovidohei, ivona, “Kaiwadi, onoto taina vivane Iosepa natuna, a? Ka ya nua‑uyana aveta baina wayahina vaniahei?” ");
INSERT INTO mvn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka tauna vonei, ivona, “Avaha anamanemi, apaina vona tana‑minikuna taina uvoneu, una‑vona, ");
INSERT INTO mvn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ka tauna vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, tau apa‑taputapu habuhabuai dewa taina avaniahei. Yama meagai nihenina tomotau eha yama hae ita‑nononi, kadu eha ita‑vi‑ateteye. ");
INSERT INTO mvn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nonova tau apa‑taputapu Elidia yana tuta nihenina wadawadae habuhabui papani Isiraeli nihenina imamaei. Ka am navovo ananina vinꞌ‑omo ponimana aitonu ka tupwana nihenia, ka wei eha tꞌ‑atuatuna. ");
INSERT INTO mvn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kate Yaubada eha aitam Isiraeli vavinena ta‑vi‑nua‑dadane, e Elidia vi‑tune na‑omo wayahia. Yaubada aitam wadae meagai Sarepati wayahina vi‑nua‑dadanei, e taui Elidia dune‑vi‑avini. Taui imamaei meagai ananina Sidoni maupwanina. ");
INSERT INTO mvn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ka kadu tuta nonova tau apa‑taputapu Elisa yana tuta nihenina deina. Tau lepero habuhabui papani Isiraeli nihenina imamaei, ka eha aitam koiaka wayahia ya vidoha ta‑vaniahe. Onoto aitamoata‑hoina ya vidoha vaniahei, ka tauna ana wava Naamani, ka ya papani vivane Siria, eha Isiraeli.” ");
INSERT INTO mvn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ka tutana taui manua tapanono nihenina Iesu ya vonana inononi, taui imaga‑bawei ani‑vainena. Iuna yana vona baimina tanoi taui wayahi inua‑haui. ");
INSERT INTO mvn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wayahina, imini, e Iesu ipoyꞌ‑avini, e megeia itaini iopuei ineiei yai meagai oyana wayahina. Ka oya‑nana hetana ivi‑au‑mini vivane yai nuanua ivitu‑voi‑one kemana, na‑opu nꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kate tauna yokoia tutu‑vewani ka aveta ya nuanua wayahina ine akanai. ");
INSERT INTO mvn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ka dewaia iakwa, tauna meagai Nasareta ni‑tawanei, iopu meagai Kapenaum wayahina. Meagai‑nana papani Galili nihenina mamaei. Ka meagai‑nana nihenina auyewa tapanono wayahina tauna vi‑putu tomotau viwavenei. ");
INSERT INTO mvn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka tomotaui habuhabui nuai vi‑tupatupa ananina ya nau‑wahe wayahina. Iuna ya viwavenena eha ihanuana, kate tunutunuhina kadu bagibagina. ");
INSERT INTO mvn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ka manua tapanono‑nana nihenina aitam onoto mamaei, ka onotona nihenina aitam nua gawagawamina mamaei. Nonova nua‑nana inui, ka ininina veimeyei. Ka onotona movina ananina vi‑hone, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aioi! Iesu, wamke onoto Nasareta, aviani iuna eomo baina wayahiaia? Kaiwadi, yam nuanua evita‑vovoniai, a? Yauke avaha anamanem koiaka. Akanai, taum vivane Yaubada Natuna Ahihimata!” ");
INSERT INTO mvn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ka Iesu nua‑nana veimeyei, ivona, “Egenuana! Onoto taina eni‑tawanei!” Ka vo‑kwayavonina yokoia mataia, nua‑nana gawagawamina onotona onei iopu tanopia. Ka munia, nua‑nana iopu ni‑tawanei, ka onotona eha aitam inahe ta‑vaniahe. Tauna ahiahina ana noe. ");
INSERT INTO mvn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka tomotaui habuhabui yaui inovo, ka taui ivi‑tanatanaiei, ivonavona, “Ia! Onoto taina vonata ya bagibagi wayahina nua gawagawamina veimeyei ivi‑ateteyei, ini‑ubau iopu!” ");
INSERT INTO mvn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka Iesu vaneana ine papani Galili habuhabuna nihenina, kadu papania awaniana imamaei nihenia. ");
INSERT INTO mvn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dewana iakwa, e Iesu manua tapanono‑nana ni‑tawanei, iopu Simoni ya manua wayahina. Ka manua‑nana nihenina Simoni nawana vavinena inini nau‑genanava ivi‑kwanaha. Wayahina, Simoni yana yoko Iesu ihidei na‑dewa‑vidohei. ");
INSERT INTO mvn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ka Iesu inu, ka vavinena pai dauva nepena mini, e ai kwanaha veimeyei na‑genuana. E kwanahana ni‑tawanei, ine. Ka vavinena imini, e ai maꞌ ivo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ka munia, tutana babau onuonu, tomotau yai tau kwanakwanaha ai kwanaha tunina tunina wayahi itaini iomanei Iesu wayahina. Ka tauna aitamoata aitamoata wayahia vo‑dadani, ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka tomotau habuhabui nihenia nua gawagawamina imamaei. Ka nua‑naia tupwai tomotau wayahia ini‑ubau iopu, ivi‑honehone, ivonavona, “Akanai, taum Yaubada Natu‑hoina!” Kate Iesu eha ya nuanua ina‑vona deinake, iuna nua‑naia avaha ianamanei tauna koiaka. Wayahina, tauna vito‑potai, ivona, “Ugenuana! Eha una‑ipupu!” ");
INSERT INTO mvn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ka avaha mana navi, Iesu meagai‑nana ni‑tawanei, ka ana heta omo papani anata wayahina. Ka tomotaui inaunau‑nene wayahina, ka munia ivaniahei. Ka taui yai nuanua inꞌ‑ana‑dibidibiei yai meagai nihenina nui imamaei. Iuna eha yai nuanua tauna na‑ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kate tauna vonei, ivona, “Nau‑wawaniu Vaneana Ahiahina Yaubada ya pai veimea wayahina anaunau‑waheyei mani meagai nihenia. Iuna Yaubada vi‑tuneu aomo paisewana apaipaisewei.” ");
INSERT INTO mvn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wayahina, tauna omo papani Iudea a meagai wayahia, ka manua tapanono habuhabuna nihenia naunau‑wahe. ");
INSERT INTO mvn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ka aitam tuta Iesu mimini Navu Genesareta baimina, ka yoko iomomo imini‑potepotei, iuna yai nuanua ya nau‑wahe Yaubada yana vona wayahina inononi. ");
INSERT INTO mvn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka tauna matana onei tania wayahina, ka tau nau‑mwaneha yai waꞌ ainua dueyei. Taui avaha iopu wae‑naia wayahia, ka yai agida inosinosia. ");
INSERT INTO mvn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ka Iesu aitam wae ainua wayahia igenu, wae‑nana Simoni yana waꞌ, ka tauna Simoni viamei, ivona, “Aituhu memeanina, kana‑opu tupwana evavai?” E Simoni awaehei, e Iesu manuena wae nihenina ka viwavenena yoko wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ka avaha ya viwavenena tanoi iakwa, tauna Simoni vonei, ivona, “Simoni, kana‑vane bebega, e yam agida enenehi.” ");
INSERT INTO mvn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka Simoni ivona, “Kauvea, ioyoma a itoava mana‑putua wayahina anau‑agida, ka eha iana ata‑vi‑one. Kate, aituhu yam nuanua deina, akanai agida anenehi.” ");
INSERT INTO mvn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Inenehi, ka iana habuhabui ivi‑onai, ka agida eha ani‑hoina nꞌ‑am‑yehia. ");
INSERT INTO mvn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wayahina, yaiai mani waea inaunau‑waiei inꞌ‑omo ina‑ivaitei. Ka taui iomo, e wae ainua ivi‑nau‑vi‑anai, ka ainua ivi‑putu igavigavivina. ");
INSERT INTO mvn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ka Simoni Pita, avaha iana habuhabuna dueyei, Iesu aena iwaodu. E Pita ivona, “Kauvea, eni‑tawaneu. Iuna wamke onoto ahiahim, kate yauke tau goyona.” ");
INSERT INTO mvn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni ivona deina iuna tauna yaiana ya waea nui nuai vi‑tupatupa iana ivi‑onai wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ka kadu yaiana mani waea Iamesa ka Ioni ainua nuai vi‑tupatupa dewa‑bagibagina tanoi wayahina. Taui ainua Sebedi natunatuna. Ka Iesu Pita vonei, ivona, “Eha ateatem viviha dewana wayahina. Ataina a itoava tuta tepakaia wayahina tomotau evi‑onai.” ");
INSERT INTO mvn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wayahina, habuhabui ivane tania, e yai waꞌ ka dewa habuhabuna ini‑tawanei, e Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ka aitam tuta Iesu mamaei aitam meagai nihenina. Ka meagai‑nana nihenina aitam onoto mamaei, ka ininina habuhabuna lepero epei, ka onoto‑nana Iesu dueyei, iwaodu tanopia, ka ihida, ivona, “Kauvea, avaha anamanem, ka aituhu yam nuanua, memeanina edewau avidoha.” ");
INSERT INTO mvn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ka Iesu nimana tunei, e onoto‑nana ininina vo‑dadani, ka ivona, “O, ahiahina. Yau nuanua deina. Evidoha!” Ka vo‑kwayavonina onoto‑nana a lepero ni‑tawanei iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ka Iesu onoto‑nana veimeyei, ivona, “Ena‑ne, ka eha aitam koiaka dewana wayahina ehaeye. Kate ena‑omo tunuhina tau vi‑nomu wayahina, e tauna ana pata na‑dueyem vivane am kwanaha iakwa, ka kadu yam vi‑nomu evenei. Yaubada veimeana vi‑nomu‑nana wayahina Mosese vonei, e tauna ginumi ya veimea nihenina mamaei. Ka yam vi‑nomu tanoi evenei, e tomotau inꞌ‑anamanem avaha evidoha.” ");
INSERT INTO mvn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka dewana iakwa, e Iesu vaneana ine papani tunina tunina wayahia, iuna tomotau habuhabui iaipuipupu wayahina. Wayahina, tomotau habuhabui inau‑hohona, yai nuanua ya nau‑wahe inononi, kadu yai nuanua ai kwanaha wayahia ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kate tauna yana dewa deina. Tuta habuhabuna wayahina tauna yoko‑naia ni‑tawanei, ka ana heta neine anata wayahina, e tanoi viama Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ka aitam auyewa wayahina Iesu aitam manua nihenina mamaei, e yoko viwavenei. Ka Parisi tupwai, kadu Mosese ya veimea a tau viwavenena tupwai avaha iomo papani Galili wayahina. Taui yai meagai papani Galili nihenina, ka papani Iudea nihenina, ka kadu meagai Ierusalem wayahina. Ka taui yoko nui imamaei manua‑nana nihenina, e ivanevaneneha. Ka auyewana wayahina Yaubada ya bagibagi mamaei, e Iesu ana pata tau kwanakwanaha na‑vo‑vi‑aiaiei ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka ononoto tupwai iomo, e tau kwanakwanaha aitam ya pai dauva hetana iavanei. Ka tau kwanakwanahana a kwanaha taina deina. Tauna eha ana pata aena o nimana na‑tune, ka kadu eha ana pata na‑mini. Ka a tau avana yai nuanua manua‑nana ina‑nu, e ai niai Iesu aena iboui. ");
INSERT INTO mvn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kate yoko ananina awa imaꞌ‑potepotei, ka tau avanai idewa‑wayohei. Wayahina, tau kwanakwanaha ya pai dauva nui ivaneyei manua hetana. Ka manua‑nana papena nau‑peuna iboui, ka papena tupwana iepei, awana inau‑vevewanei, ka ai niam ivi‑kukei manawa wayahina manua niwanina, e Iesu matana iboui deina. ");
INSERT INTO mvn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ka Iesu tau kwanakwanaha yaiana yai vitumahana dueyei. Wayahina, tauna tau kwanakwanaha vonei, ivona, “Au niau, yam dewa goyona habuhabuna anua‑piahi‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ka Parisi habuhabui kadu veimea a tau viwavenena habuhabui ivi‑putu inuanua taina deina, “Onoto taina vonavona goyona Yaubada wayahina, e tauna Yaubada ya bagibagi vainaui deina. Iuna Yaubada a heta‑ohota ana pata dewa goyona na‑nua‑piahi. Eha kadu aitam.” ");
INSERT INTO mvn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ka Iesu avaha yai nuanua tanoi anamane‑yehai. Wayahina tauna vonei, ivona, “Aviani wayahina nuami nihenina unuanua deinake yau vonana wayahina? ");
INSERT INTO mvn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aviani memeanina wayahiua, ka aviani vitana wayahiua? Memeanina ana‑vona, ‘Yam dewa goyona anua‑piahi,’ o kaiwadi memeanina ana‑vona, ‘Emini, eni‑awana’? ");
INSERT INTO mvn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iaiaya aitam avenemi unꞌ‑anamaneu yauke, Tauna Vi‑tomotau, au awaeha mamaei tomotau yai goyona ana‑nua‑piahi tanopia akanai.” Wayahina, tauna magigino, e tau kwanakwanaha vonei, ivona, “Aveimeyem, emini, e yam pai dauva eavanei, ena‑ne yam megeia.” ");
INSERT INTO mvn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ka onotona vo‑kwayavonina mini yoko mataia, ka ya pai dauva avanei, ine ya megeia. Ka neine ya dewa‑haiawa nui Yaubada awa‑davedavei. ");
INSERT INTO mvn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ka yokoia manua nihenina idudueyei, ka habuhabui nuai vi‑tupatupa ananina, ka yai matauta nui Yaubada iawa‑davedavei, ka ivonavona, “Ataina avaha pai nua‑tupatupa ananina kadueyei!” ");
INSERT INTO mvn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ka munia, Iesu ni‑awana ka aitam takesiV a tau vitue ana wava Levi dueyei. Tauna takesiV a vekevekeke kikituna nihenina manuena. Ka Iesu vonei, ivona, “Evi‑munieu.” ");
INSERT INTO mvn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","E Levi mini, e dewa habuhabuna ni‑tawanei, e Iesu vi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ka munia, Levi aniani ananina Iesu wayahina nau‑vevewanei ya manua nihenina. Ka yoko ananina iomo, kadu takesiV a tau vitue habuhabui nui imanuena iamam. ");
INSERT INTO mvn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ka Parisi tupwai, kadu veimea a tau viwavenena tupwai Parisi yai yoko wayahina imamaei. Ka taui inau‑vonuvonu Iesu a tau vi‑muni‑waiwai wayahia, ivona, “Yoko taina tomotau goyona, vivane takesiV a tau vitue, kadu tau goyogoyona habuhabuna. Ka itomi nui unau‑hohona, kadu nui uamam, kadu nui unimnim. Aviani iuna udedewei deina?” ");
INSERT INTO mvn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kate Iesu yai vonana nononi, ka nau‑patei vona tana‑minikuna wayahina, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yauke aomo tanopia, ka yau paisewa taina deina. Aituhu aviyaivia tau goyogoyona, taui ahonei inua‑vinana, e ividoha Yaubada matana. Kate aituhu aviyaivia yawai ahiahi, eha ahonehone. Iuna eha aitam aviani wayahina taui nau‑wawani inua‑vinana, a?” ");
INSERT INTO mvn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka munia, tupwai tomotau iomo Iesu wayahina, ka ivi‑tanaiei, ivona, “Tuta tuta Ioni (Tau Bapitaiso) a tau vi‑muni‑waiwai idewa‑didiguna, ka am inavovo, ka tuta tuta iviama Yaubada wayahina. Kadu tuta tuta Parisi a tau vi‑muni‑waiwai idewa‑didiguna deinake. Kate wamke am tau vi‑muni‑waiwai eha dewa‑didiguna ita‑vi‑munie. Taui iam‑kavokavovo kadu inim‑kavokavovo. Medeina?” ");
INSERT INTO mvn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka Iesu ivona, “Medeina nau‑wawanika kadedewei tavine ana tuta wayahina? Aituhu tau tavine onotona mamaei ya tavine wayahina, eha nau‑wawanika aniani kavito‑potei yaiana wayahia, iuna habuhabui idewa‑haiawa ai niam wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kate avonemi, tuta tepakaia aitam tuta omomoi, ka auyewana wayahina tau tavine onotona yaiana na‑ni‑tawanei. Ka munia, auyewa‑naia nihenia yaiana inua‑vita kadu am inavovo.” ");
INSERT INTO mvn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ka kadu aitam vona tana‑minikuna vonei, ivona, “Aituhu kwama tutuaina am‑yehia, eha nau‑wawanika kwama vovouna kasi‑yehia, e tutuaina kauya‑numi. Aituhu kadewei deina, kwama vovouna kavi‑goyoi. Ka kadu aviani kasi‑yehia vovouna wayahina ana dune eha aitamoata tutuaina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ka kadu aitam vona tana‑minikuna taina vonei, ivona, “Aituhu wainaV vovouna mamaei, eha nau‑wawanika pai iwaha tutuaina nihenina kana‑iwahi. Iuna apaina wainaV vovouna a punopuno bagibagina, ka pai iwaha tutuaina nꞌ‑am‑haui, ka wainaV na‑taini na‑opu tanopia. Dewa ainua ina‑goyo deina. ");
INSERT INTO mvn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dewana vivane mwagemwagena. Nau‑wawanika wainaV vovouna kana‑iwahi pai iwaha vovouna ana heta nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Unononi. Habuhabuka avaha kanamanei, aituhu wainaV tutuaina avaha unim‑dadana, eha yami nuanua wainaV vovouna unim‑dadana. Eha. Iuna una‑vona, ‘Tutuaina dibidibina, ka vovouna gibwana.’ Ka kadu aitamoata deina, tomotau yai nuanua yai dewa tutuaina, eha yai nuanua yau viwavenena vovouna. Kate yai nuanua tanoi eha ta‑vinꞌ‑omo nua‑uya wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aitam tapanono wayahina Iesu tauna a tau vi‑muni‑waiwai nui aitam baguna witiV nihenina ineine, e a tau vi‑muni‑waiwai witiV uana iponuponui, imutumutui nimaia, e iamam. ");
INSERT INTO mvn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ka tupwai Parisi avaha dewana idueyei, Iesu ivi‑tanaiei, ivona, “Ia! Am tau vi‑muni‑waiwai utuna iponuponui auyewa tapanono wayahina. Taui ipaipaisewa deina, ka yai dewana aka veimea tana‑bwegebwegei! Medeina eawaehei?” ");
INSERT INTO mvn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ka Iesu Parisi‑naia yai vonana vona‑nau‑patei, ivona, “Iginuma uaiaiavi ahiahina o eha? Nonova aitam tuta KiniV Davida tauna a tau nau‑havia nui am inavovo. Ka yana dewa medeina? Viviwava tanoi unuani o eha? ");
INSERT INTO mvn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tauna Yaubada ya manua inui, ka palaua vitovito‑potana epei. Aitam veimea mamaei palaua‑nana wayahina, vivane tau vi‑nomu ai heta ai pata ianiania. Mani tomotau ai awaeha eha ta‑mamae. Kate Davida yaiana nui am inavovo. Wayahina, tauna epei, e yaiana venei, e ianiania akanai.” ");
INSERT INTO mvn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wayahina, Iesu kadu vonei, ivona, “Yauke, Tauna Vi‑tomotau, vivane auyewa tapanono a Kauvea akanai.” ");
INSERT INTO mvn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ka kadu aitam auyewa tapanono wayahina Iesu inu aitam manua tapanono nihenina, e taui imamaei viwavenei. Ka manua‑nana nihenina aitam onoto mamaei, ka nimana ateina begabegana. ");
INSERT INTO mvn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ka veimea a tau viwavenena tupwai, ka Parisi tupwai imamaei, ka yai nuanua Iesu yana dewa goyona ivaniahei, e munia, taui ai pata ya goyona wayahina iyapoyapoi kadu idewa‑yaiyaiei. Wayahina, taui yana dewa habuhabuna idune‑vi‑anai. Aituhu tauna aitam tomotau na‑vo‑vi‑aiaiei auyewa tapanono wayahina, taui inuanua dewana vivane dewa goyona, iuna paipaisewa auyewa tapanono wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ka Iesu avaha yai nuanua anamanei. Wayahina, onotona vonei, ivona, “Emini, e evane‑mei baina matakaia.” E onotona mini, e ivane tomotau habuhabui mataia. ");
INSERT INTO mvn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka Iesu veimea a tau viwavenena wayahia, ka Parisi wayahia vi‑tanatanaiei, ivona, “Aka veimea auyewa tapanono wayahina medeina? Uvoneu. Aka veimea vivane tomotau kaivaitei, o kadi kavo‑vihavihai? Uvoneu. Aka veimea vivane tomotau yawai kana‑ito‑yavuhi, o kadi yawai kavita‑vovoni?” ");
INSERT INTO mvn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ka tauna dunedune habuhabui wayahia, kate taui eha ya vonana wayahina ita‑nau‑pata. Wayahina, tauna onotona vonei, ivona, “Nimam etunei.” E onotona nimana tunei, e vo‑kwayavonina nimana vidoha. ");
INSERT INTO mvn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ka veimea a tau viwavenena, kadu Parisi‑naia imaga‑bawei ananina Iesu ya dewana wayahina, ka taui matataui ivi‑putu iawaehei medeina yana dewa habuhabui inꞌ‑awa‑tani. ");
INSERT INTO mvn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tuta tanoi wayahina Iesu ivane oyaoyana aitam, e tenoke ioyomana wayahina viama Yaubada wayahina a itoava ioyomana iakwa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ka mana navia, tauna a tau vi‑muni‑waiwai habuhabui honei, ka ai yoko wayahia ononotoi ai yau 12 vi‑nua‑dadanei ivi‑tau hae anani. ");
INSERT INTO mvn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ka tau hae‑naia ai wava taina, Simoni, tauna kadu vi‑wahani Pita, ka taina Aniduru, ka kadu Iamesa ka Ioni, ka kadu Pilipi ka Baritolomeu, ka kadu ");
INSERT INTO mvn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu ka Tomasi, ka kadu mani Iamesa, tauna Alipaeusi natuna, ka kadu mani Simoni, (tauna manimaninina, ka me Rom yai veimea vihahaiei), ");
INSERT INTO mvn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ka kadu Iudasa, tauna Iamesa natuna, ka kadu Iudasa me Kariota, tauna munia Iesu vi‑nua‑hauhauei. ");
INSERT INTO mvn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ka Iesu tauna a tau hae nui oyaoyana wayahina iopu‑me, ka a tau vi‑muni‑waiwai habuhabui nui inau‑hohona‑havine aitam papani nau‑peuna wayahina. Ka yoko‑nana ani‑vainena, iuna tomotau‑naia yai meagai ini‑tawanei inau‑hohona papani‑nana wayahina. Ka tupwai yai meagai papani Iudea nihenina imamaei, kadu tupwai yai meagai vivane Ierusalem, ka tupwai yai meagai tania imamaei, vivane Taia ka Sidoni. ");
INSERT INTO mvn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ka iomo iuna yai nuanua Iesu ya nau‑wahe ina‑nononi, kadu yai nuanua tauna ai kwanaha wayahia na‑vo‑vi‑aiaiei, ividoha. Ka tupwai wayahia yawai igoyo nua gawagawami wayahia, ka iomo, e tauna na‑vo‑vi‑aiaiei, ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ka tomotau habuhabui yokoia nihenina yai nuanua Iesu ivo‑dadani nimaia, iuna bagibagi omomo tauna ininina wayahina ka bagibagi‑nana ai kwanaha aitamoata aitamoata vo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wayahina, Iesu matana onei a tau vi‑muni‑waiwai wayahia, e ivona, ");
INSERT INTO mvn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ka ataina itomi am unavovo. ");
INSERT INTO mvn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ka avi tuta tomotau inau‑nikonikoiemi, o ivihahaiemi, o imana‑giboemi, o inꞌ‑apa‑goyogoyoemi iuna itomi yauke, Tauna Vi‑tomotau, yau tomotau, akanai ami nau‑iaiava wayahimia mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Avona‑havinemi, avi tuta dewaia inꞌ‑omo wayahimia uvaniahei, akanai nau‑wawanimi udewa‑haiawa ananina. Iuna ami nau‑pata ahiahina potapotami wahuma. Nonova ami havia yai tupua‑nenenehi tau apa‑taputapu idedeweyei aitamoata deina.” Ka mani tomotau wayahia vona panina boui deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ataina tupwami uvi‑tau kaikaiwabo. ");
INSERT INTO mvn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ataina tupwami uamam‑iaua. ");
INSERT INTO mvn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ka avi tuta tomotau habuhabui inꞌ‑apa‑vidovidohemi, nau‑wawanimi udune‑vivinimi. Iuna nonova tomotau‑naia yai tupua‑nenenehi tau apa‑taputapu vitupu iapa‑vidovidohei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ka Iesu ya viwavenena vo‑vi‑tupanei, ivona, “Aituhu aviyaivia wayahimia yami nuanua yau vonana unononi, aitamoata aitamoata wayahimia avonemi, nau‑wawanimi ami havia udewa‑vidovidohei. Ka aituhu tomotau inau‑nikonikoiemi, nau‑wawanimi dewa ahiahina udedewei taui wayahi, e una‑ivaitei. ");
INSERT INTO mvn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ka aituhu tomotau inꞌ‑apa‑goyogoyoemi, nau‑wawanimi unꞌ‑apa‑vidovidohei. Ka aituhu tomotau ivi‑goyomi, nau‑wawanimi uviama Yaubada wayahina, e tauna yai goyona na‑nua‑piahi. ");
INSERT INTO mvn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka aituhu koiaka nevanuami ateina vinanahi, nau‑wawanimi nevanuami akenina unꞌ‑awaehei tauna ana pata kadu vinanahi. Ka aituhu aviyaivia yami sita ivainaui, nau‑wawanimi kadue ami kwama unꞌ‑awaehei inꞌ‑epei. ");
INSERT INTO mvn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka aituhu aviyaivia yami gugua iviamemi, nau‑wawanimi uvenei. Ka aituhu tomotau yami gugua ivainaui, akanai, nau‑wawanimi ugenuana. Eha unuanuani, e ivene‑havinemi. ");
INSERT INTO mvn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ataina ami veimea avenemi. Aviani yami nuanua tomotau wayahimi idedewei, akanai nau‑wawanimi mani tomotau udedeweyei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aituhu tomotau idune‑nuanuaiemi, ka aituhu itomi kadu taui udune‑nuanuaiei, dewana wayahina eha aitam nau‑pata ahiahina uvaniahe Yaubada wayahina, iuna dewana memeanina. Vona ahiahina, tuta tuta tau goyogoyoi idedewei deina. ");
INSERT INTO mvn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka aituhu tomotau idewa‑vidovidohemi, ka aituhu itomi unau‑pata udewa‑vidovidohei, dewana wayahina eha aitam nau‑pata ahiahina uvaniahe Yaubada wayahina, iuna dewana memeanina. Vona ahiahina, memeanina kadu tau goyogoyoi idedewei deina, a? ");
INSERT INTO mvn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka aituhu yami kina yaiami ai pata inau‑pata‑havinemi uvenevenei, dewana wayahina eha aitam nau‑pata ahiahina uvaniahe Yaubada wayahina, iuna dewana memeanina. Vona ahiahina, memeanina kadu tau goyogoyoi yai kina yaiai ivenevenei, iuna inuanua apaina kina‑naia ai nau‑pata ivaniahe‑havinei. ");
INSERT INTO mvn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Habuhabumi avonemi taina deina, nau‑wawanimi dewa‑naia uvane‑tawanei. Nau‑wawanimi ami havia udewa‑vidovidohei dewa ahiahina wayahina. Kadu yami kina uvene‑kavokavovo mani tomotau wayahia, ka eha ami nau‑pata wayahia upotapota. Ka aituhu dewaia habuhabui udedewei deina, apaina ami nau‑pata ananina uvaniahei Yaubada Heta‑hoina wayahina, ka tauna vi‑wahanimi, ‘Natunatu!’ Nau‑wawanimi udedewei deina, iuna tuta tuta tauna taui eha Yaubada ita‑nau‑kaiwe kadu tau goyogoyoi dewa‑bigebigei. ");
INSERT INTO mvn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wayahina, itomi nau‑wawanimi mani tomotau unꞌ‑ate‑nuanuaiei Amami ate‑nuanuaiemi aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ka Iesu ya viwavenena vo‑vi‑tupanei, ivona, “Eha nau‑wawanimi mani tomotau uvona‑yaiyaiei. Aituhu dewana uvihahaiei, apaina Yaubada eha na‑vona‑yaiyaiemi. Kadu eha nau‑wawanimi yaiami ubwanatei yai goyona wayahi. Aituhu dewana uvihahaiei, apaina Yaubada eha na‑bwanatami yami goyona wayahi. Nau‑wawanimi yaiami yai dewa goyona wayahimia unua‑piahi. Aituhu udedewei deina, apaina Yaubada yami dewa goyona tauna wayahina na‑nua‑piahi‑neiei. ");
INSERT INTO mvn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ka kadu aitamoata aitamoata wayahimia avonemi, aituhu yami gugua ahiahina mani tomotau uvo‑patai, apaina Yaubada tauna ya gugua ahiahina na‑vo‑patami. Ka ami pata‑nana uvaniahei eha kikituna, kate nimami ainua vi‑nau‑vi‑anai kadu hetana. Avi dewa uvi‑muniei yaiami wayahia, akanai Yaubada na‑vo‑patami aitamoata deinake. Iuna tauna yami pai vo‑pata mani tomotau wayahi na‑epei, ka pai vo‑pata‑nana wayahina ami vo‑pata na‑vo‑vi‑aiaia wayahimia.” ");
INSERT INTO mvn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ka Iesu vona tana‑minikuna taina vonei, ivona, “Aituhu aitam tau mata‑goyo tauna a niam matana goyona eta‑naonaoei, apaina ainuai guba nihenina ina‑peu. ");
INSERT INTO mvn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ka kadu aitamoata deina, tau vi‑muni‑waiwai ai wava eha taui ai tau viwavenena ana wava ivane‑tawane. Ka avi tau vi‑muni‑waiwai avaha inua‑hau‑yehai, akanai munia, taui yai nua‑uya ka ai tau viwavenena ya nua‑uya vivane aitamoata. ");
INSERT INTO mvn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Memeanina itomi vaneimi ya goyona kikituna udueyei, e wayahina uvi‑vonavona, ka yami goyona ananina mamaei, kate eha utꞌ‑anamane. Yami dewa taina avo‑vi‑mahetemi. Vaneimi matana ai kamukamumuna mamaei, kate itomi matamia idebona mamaei deinake. Ai kamukamumuna ami pata ududueyei, kate idebona eha ami pata ududueye, a? ");
INSERT INTO mvn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aituhu aitam wayahimia vaneim evonei, ‘O vaneiu, nau‑wawanim eawaeheu ai kamukamumuna matama anꞌ‑epa‑yavunei evidoha,’ dewana eha ana pata. Iuna idebona ananina matamia mamaei. Nau‑wawanimi naona idebona matamia unꞌ‑epei. Ka munia, uvidoha udunedune ahiahina, e ami pata vaneimi una‑ivaitei, e ai kamukamumuna matana unꞌ‑epa‑yavunei tunuhina.” ");
INSERT INTO mvn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ka Iesu yana vona vo‑vi‑tupanei, ka ivona, “Aituhu aitam ai ahiahina, akanai ai‑nana kadu uana ahiahina na‑ua. Eha ana pata ai‑nana uana goyona na‑ua. Ka kadu aituhu aitam ai goyona, ai‑nana uana goyona na‑ua. Eha ana pata ai‑nana uana ahiahina na‑ua. ");
INSERT INTO mvn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka aituhu ai uana aitam kadueyei, akanai avaha avi ai wayahina ua‑nana vinꞌ‑omo kanamanei. Iuna eha aka pata madaiba uana kai‑ponuponu mata‑duduna wayahina. Ka kadue eha aka pata wainaV uana kai‑ponuponu inaina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wayahina, aituhu aitam onoto ahiahina, tauna nuanua ahiahina, ka kadu tauna dewa ahiahina nua‑vi‑avini nuana nihenina, e munia, dewaia ahiahina ivinꞌ‑omo‑nananena nuana wayahina. Ka aituhu aitam onoto goyona, tauna nuanua goyona, ka kadu tauna dewa goyona nua‑vi‑avini nuana nihenina, e munia, dewaia goyona ivinꞌ‑omo‑nananena nuana wayahina. Wayahina, aviani kanua‑vi‑avini nuaka nihenina, apaina nuanua‑naia ina‑iwaiwahi yaka vona nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ka medeina itomi uapa‑kauveau, kate ami veimea avenevenemi utana‑bwegebwegei? ");
INSERT INTO mvn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aitam vona tana‑minikuna avenemi avo‑vi‑mahetemi. Aituhu aviyaivia iomo wayahiua, ka aituhu yau vona inononi, kadu aituhu ivi‑putu yau vona ivi‑ateteyei, taui tau yona manua ahiahina deina. ");
INSERT INTO mvn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ka tau yona manua ahiahina ya paisewa taina deina. Naona tauna yanꞌ avutu toyoina vaniahei hanuhanuna wayahina, e ya manua hanuhanuna hetana na‑yonei. Munia, wei ananina atuatuna, ka diwaya bagibagina taitaina, ka manua‑nana vi‑nanahi, kate eha ta‑vi‑goyo. Iuna tau yona manua‑nana ya paisewa tunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kate aituhu aviyaivia iomo wayahiua, ka yau vona inononi, kate aituhu eha yau vona ivi‑ateteye, taui vivane tau yona manua mwagemwagena deina. Iuna tau yona manua mwagemwagena ya manua yonei magamata wayahina, eha yanꞌ avutu. Ka tutana diwaya‑nana manua‑nana vi‑nanahi, vo‑kwayavonina am‑vinei, ka diwaya‑nana tutu‑bwege‑yehai, ka manua‑nana iakwa.” ");
INSERT INTO mvn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka Iesu tauna ya viwavenena tomotau wayahia nau‑yehai, e omo meagai Kapenaum wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ka meagai‑nana nihenina aitam me Rom yai tau nau‑havia ai yau 100 ai tau eta‑naonao mamaei. Ka tau eta‑naonaona tauna ya tau paisewa aitam apa‑vidovidohei ananina, kate tau paisewana vi‑kwanaha ananina, ka tuta eha ani‑hoina na‑iakwa nꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ka tau eta‑naonao‑nana Iesu yana omana vaneana nononi, ka ya nuanua Iesu na‑omo, e ya tau paisewa na‑vo‑vi‑aiaiei, vidoha. Wayahina, tauna me Iudea yai ononotoi anani tupwai viamei aituhu memeanina ina‑ne Iesu wayahina, e taui imataedei deina. Ka taui tauna ya nuanuana iawaehei. ");
INSERT INTO mvn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","E ononotoi anani‑naia iomo Iesu wayahina, e ihidahida bagibagina, ivona, “Kauvea, yama nuanua ananina mamaei. Tau eta‑naonao tanoi vivane ama niam aitam, ka tauna onoto ahiahina, wayahina nau‑wawanim ena‑ivaitei. Tauna ya tau paisewa aitam vi‑kwanaha, ka yama nuanua kana‑ne, e evo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Onotona vivane me Rom aitam, kate tauna tunina, iuna tauna itoka me Iudea dewa‑vidovidoheka. Kadu tauna ana heta avaha yana kina awaehei yaka manua tapanono aitam ana yona wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wayahina, Iesu awaehei nui ineine tau eta‑naonao ya manua wayahina. Ka eha ani‑hoina manuana ivaniahe, ka tau eta‑naonao‑nana tauna yaiana tupwai vi‑tunei iomo Iesu wayahina. Ka yaiana Iesu ivaniahei etawana, e ivona, “Ama niam ivona deina, ‘Bada, taum am wava ananina, ka yauke au wava kikituna. Wayahina, eha nau‑wawanim avitavitam, e bana mamanaina eomo wayahiua. Kadu eha nau‑wawanim yau manua ena‑nu, iuna am wava ananina. ");
INSERT INTO mvn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ka kadue eha nau‑wawanim anꞌ‑omo wayahima, e etawana aviamem matama, iuna wamke am wava ananina. Aituhu memeanina wayahima, akanai yam vonata ana pata yau tau paisewa ya vidoha wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iuna avaha itoka tomotau aka awaeha a venavenau anua‑hau‑yehai. Yauke au tau veimea anani imamaei, ka taui iveimeyeu, avi‑ateteyei. Ka kadu yauke vivane tau veimea aitam, e yau tau nau‑havia aveimeyei, ivi‑ateteyeu. Aitam aveimeyei, avona, “Ena‑nei!” e tauna neine. Ka kadu aitam aveimeyei, avona, “Enꞌ‑omoi!” e tauna omomo. Ka kadu yau tau paisewa‑kavokavovo aveimeyei, avona, “Edewei!” e tauna dedewei deina. Avaha anamanem vivane am awaeha mamaei akanai.’” ");
INSERT INTO mvn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ka Iesu, avaha vonana nononi, nuana vi‑tupatupa ananina. Wayahina magigino, e yoko ivi‑muniei vonei, ivona, “Vona ahiahina, nonova a itoava ataina wayahina, eha aitam koiaka ya vitumahana ananina deina ata‑vaniahe. Eha aitam me Isiraeli ya vitumahana deinake!” ");
INSERT INTO mvn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka vonana iakwa, e tau mataeda‑naia imavi‑havine tau eta‑naonao‑nana ya manua wayahina, ka tau paisewana ivaniahei avaha vidoha. ");
INSERT INTO mvn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ka tuta eha ani‑hoina iakwa, e Iesu omo aitam meagai ana wava Naini wayahina. Ka a tau vi‑muni‑waiwai kadu yoko ananina nui iomomo. ");
INSERT INTO mvn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ka iomo meagai a tutu‑gana wayahina, ka eha ani‑hoina ina‑nu, ka tau aniga a tau avana idudueyei meagai‑nana ini‑tawanei, e ineine itavuni meagai‑nana upuna. Ka tau anigana tanoi wadaena natuna aitamoata‑hoina. Ka yoko ananina wadaena nui ineine etawana, e itavuni. ");
INSERT INTO mvn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka tutana Iesu wadaena dueyei, tauna ate‑nuanuaiei ananina. Wayahina, tauna vavinena vonei, ivona, “Eha nau‑wawanimi uvi‑mohai.” ");
INSERT INTO mvn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E tauna omo tau anigana ana iuma wayahina, vo‑dadani, ka tau avanai imimini, ipotapota. Ka Iesu tau matena vonei, ivona, “Tupunaim, aveimeyem emini!” ");
INSERT INTO mvn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka onotona mini, e vi‑putu ipuipupu. Wayahina, Iesu onotona taini omanei ayona wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ka papani‑nana nihenina tomotau habuhabui imatamatauta, kadue Yaubada iawa‑davedavei, ivona, “Tau apa‑taputapu ananina aitam avaha omoi baina!” Kadu ivonavona, “Yaubada avaha omoi, ka ya nuanua itoka ya tomotau na‑ivaiteka.” ");
INSERT INTO mvn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ka Iesu vaneana tanoi ine papani Iudea habuhabuna nihenina, ka kadu ine meagai habuhabui papani Iudea nepena wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ka munia, Ioni Tau Bapitaiso a tau vi‑muni‑waiwai iomo Ioni wayahina, e dewaia habuhabui vanena imataedei, e tauna nononi. Iakwa, tauna ainua wayahia honei. ");
INSERT INTO mvn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","E tauna ainuai vi‑tunei ine Iesu wayahina, iuna Ioni ya nuanua ivi‑tanaiei, “Bada, vona tunuhina medeina? Taum vivane onotona nonova Ioni vonavona wayahina vivane apaina na‑omo wayahiaia, na‑ito‑yavuhiai, o kadi nau‑wawaniai mani onoto apotepotei?” ");
INSERT INTO mvn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ka ainuaia iomo Iesu wayahina, e ivona, “Bada, Ioni Tau Bapitaiso vi‑tuneai, aomo avi‑tanaiem, ‘Vona tunuhina medeina? Taum vivane onotona, e nonova taui ivona wayahina apaina na‑omo wayahiaia, e na‑ito‑yavuhiai, o kadi nau‑wawaniai mani onoto apotepotei?’” ");
INSERT INTO mvn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka auyewana wayahina, ka kadu babau‑nana nihenina Iesu tau kwanakwanaha habuhabui ai kwanaha kadue ai muya ito‑yavuhi ividoha. Ka nua gawagawamina tupwai tomotau ivitavitai, kadue Iesu tomotaui vo‑vi‑aiaiei ividoha. Ka kadu tau mata‑goyo habuhabui matai vo‑vi‑aiaia idunedune. ");
INSERT INTO mvn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ka dewa‑bagibagi‑naia iakwa, e Iesu Ioni a tau mataeda ainuai yai vi‑tanai nau‑patei, ivona, “Itomi avaha dewaia habuhabui ududueyei matamia, kadu avaha unonononi tanihamia. Wayahina, ami inua umavina, e Ioni umataedei deinake, vivane ataina tau mata‑goyo matai avaha ividoha idunedune, ka kadu tau penapena aei ividoha ini‑awana, ka kadu tau lepero avaha avo‑vi‑aiaiei ividoha, ka kadu taui tanihai am‑potapotana avaha ividoha inonononi, ka kadu tau aniga imini‑havine, ka kadu Vaneana Ahiahina Yaubada wayahina tau payapayaya anaunau‑wahei, ka avaha inononi. ");
INSERT INTO mvn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wayahina, avonemi, aituhu aviyaivia eha wayahiu iva‑hamwahamwana, kate ivitumahaneu ahiahina, akanai taui ai nau‑iaiava mamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka avaha Ioni a tau mataeda imavina, Iesu vi‑putu yokoia haeyei Ioni wayahina, ivona, “Nonova itomi uomomo anata wayahina, e Ioni ya nau‑wahe unononi. Ka tutana udedewei deina, avi onoto unuanua tenoke uvaniahei? Kaiwadi unuanua tauna aitam onoto wetau ihanuana yahina nihenina nau‑yueyue uvaniahe deina? Eha. ");
INSERT INTO mvn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O avi onoto unuanua uvaniahei? Kaiwadi unuanua aitam tau kaikaiwabo ana kwama ahihi‑vainena uvaniahe anata wayahina? Eha. Iuna tau kaikaiwabo eha ita‑mamae anata nihenina, kate taui na guguai ahiahina imamaei yai manua ananina nihenina, a? ");
INSERT INTO mvn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Uvoneu. Avi onoto unuanua uvaniahei tenoke? Kaiwadi unuanua tau apa‑taputapu aitam uvaniahei, a? Ika! Ka ataina avonemi, Ioni mani tau apa‑taputapu vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iuna Iginuma nihenina aitam apa‑taputapu Ioni Tau Bapitaiso wayahina mamaei, ivona, ‘Yaubada tauna Natu‑hoina vonei, ivona, “Onoto taina vivane yau tau mataeda. Ka naona tauna avi‑tunei ine tepama, e tauna ya paisewa wayahina wamke yam etawana na‑hadani, ka yam paisewa na‑vo‑vi‑meani wayahim.” ’ ");
INSERT INTO mvn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Vona ahiahina, Ioni tau maꞌ tanopi habuhabui vane‑tawanei. Ika, tauna taui yai tupua nonova wayahina a itoava taui yai tupua ataina wayahina vane‑tawanei. Kate unononiu! Vona ahiahina, aituhu aviyaivia Yaubada ya pai veimea ivaniahei, kadu aituhu ina‑nu nihenina, ka aituhu imamaei, akanai tomotaui Ioni Tau Bapitaiso ivane‑tawanei. Aituhu taui ai wava kikitui, dewana eha aitam aviani. Taui Ioni ivane‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nonova yokoia, kadu takesiV a tau vitue Ioni ya nau‑wahena inononi, kadu iawaehei nau‑wahena tunutunuhina. Wayahina, taui habuhabui Ioni iviamei tauna vi‑bapitaisoei, ka ai bapitaiso wayahina dewa tunuhina idedewei deina. Wayahina, tutana taui Iesu ya vonaia inononi, Yaubada iawa‑davedavei, iuna avaha ianamanei Yaubada ya etawana vivane etawana tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kate Parisi habuhabui, kadu Mosese ya veimea a tau viwavenena habuhabui Ioni ya nau‑wahena ivihahaiei, ka taui kadu Yaubada ya nuanua ahiahina wayahi ivihahaiei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ka Iesu ya nuanua Parisi yai dewa yokoia na‑mataedai. Wayahina ivona, “Medeina ana‑vona tomotaui tuta ataina imamaei wayahi? Taui yai dewa medeina? Kaiwadi, aviani wayahina abou‑viwavei una‑nua‑haui? ");
INSERT INTO mvn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Taui yai dewa yaheyahe imanuena maketi wayahina yai dewa deina. Yaheyahe‑naia ai yau ainua, ka aitam yau yaiai wayahia ivivi‑hone, ivonavona, ");
INSERT INTO mvn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Vona ahiahina, Ioni Tau Bapitaiso omo wayahimia, ka tuta tuta yana dewa aniani ahiahina vihahaiei, kate dewa‑didiguna dedewei, kadue eha aitam tuta Ioni wainaV ta‑nim. Ka tomotau tupwai inau‑vonuvonu wayahina, ivona, ‘Udueyei! Onoto taina yana dewa kwavakwavana! Nua gawagawamina veimeyei akanai!’ ");
INSERT INTO mvn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka munia, yauke, Tauna Vi‑tomotau, aomo wayahimia, ka yau dewa tunina. Yauke aniani amam kadu wainaV animnim. Ka tomotau tupwai inau‑vonuvonu wayahiu, ivona, ‘Udueyei! Onoto taina yana dewa goyona! Tuta tuta aniani‑mei amam, kadu tuta tuta waina‑mei nimnim. Ka yaiana udueyei! Taui vivane tau goyogoyona takesiV a tau vitue, kadue taui itoai avihahaiei deina!’ ");
INSERT INTO mvn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka avonemi, aka pata nua‑uya tunutunuhina kanꞌ‑anamanei taina deina. Tau nua‑uya yai nua‑uya iviwaveneka taui yai dewa tunutunuhina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aitam tuta Parisi aitam, ana wava Simoni, Iesu honei, e nui inꞌ‑am. Ka Iesu awaehei, omo, ka Parisi‑nana ya manua inui ka daudauva amam. ");
INSERT INTO mvn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka meagai‑nana nihenina aitam vavine tau kenekenene mamaei. Ka vavinena avaha anamanei Iesu Parisi‑nana ya manua nihenina amam. Wayahina, vavinena bunama manina ahiahina na gamna omanei, ");
INSERT INTO mvn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ka manua‑nana inui, ka omo Iesu munina, ka aena nepena mini ka vi‑putu toutou ka mata‑inuna Iesu aena si‑vi‑niginigia. Ka apanana mamanaina wayahina aena nau‑wohi, kadu vi‑putu Iesu aena maoi, ka bunama iwaiwahi Iesu aena wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka Parisi‑nana (Simoni), ana heta nihenina nuanua, “Ia! Onoto taina eha aitam tau apa‑taputapu ahiahina. Aituhu tauna tau apa‑taputapu ahiahina, akanai tauna nꞌ‑anamane vavine taina vo‑dadani vivane tau goyogoyona. Ka aituhu tauna anamane deina, vavine taina yana dewa ta‑vihahaie kadu ta‑vito‑pote akanai.” ");
INSERT INTO mvn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ka Iesu Simoni wayahina ivona, “Simoni, yau nuanua aitam vona tana‑minikuna avonem.” Ka Simoni ivona, “Kauvea, ahiahina. Evoneu.” ");
INSERT INTO mvn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wayahina Iesu ivona, “Aitam tau kaikaiwabo mamaei, ka nonova onoto ainua ai aga iboui tau kaikaiwabona wayahina. Aitam onoto anꞌ aga 500 kina ka a niam anꞌ aga 50 kina. ");
INSERT INTO mvn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka munia ainuai eha ai pata bada‑nana inau‑pate. Wayahina, bada‑nana ainuai ai aga nua‑tavuni. Akanai yau vi‑tanai wayahima taina. Ainuai wayahia, koiaka ya dune‑nuanuai yana bada wayahina ananina?” ");
INSERT INTO mvn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ka Simoni Iesu ya vonana vona‑nau‑patei, ivona, “Kaiwadi, onotona anꞌ aga ananina nua‑tavuni. Tauna yana bada na‑nau‑kaiweyei ananina.” Ka Iesu ivona, “Ika, vona ahiahina.” ");
INSERT INTO mvn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wayahina, Iesu magigino vavinena wayahina, kate Simoni wayahina vonavona, “Simoni, nau‑wawanim vavine taina yana dewa edueyei ahiahina. Naona yam manua anu‑mei, ka eha daudau pai toa eta‑veneu. Ka vavine taina mata‑inuna aeu nosia ka apanana wayahina nau‑wohi. ");
INSERT INTO mvn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kadu wamke pai nau‑kaiwa ana mao eha eta‑veneu. Ka vavine taina yau omana naona wayahina a itoava ataina wayahina aeu maomaoi. ");
INSERT INTO mvn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Eha kadu bunamea ununu eta‑buyou. Ka vavinena taina akanai ya bunamea aeu ito‑iwahi. ");
INSERT INTO mvn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wayahina, avonem, tauna yana dewa goyona habuhabui avaha anua‑tavuni, wayahina tauna dune‑nuanuaieu ananina. Kate aituhu aviyaivia yai goyona aitonuata anua‑tavuni, taui yai dune‑nuanuai wayahiua vivane kikituna.” ");
INSERT INTO mvn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ka Iesu vavinena vonei, ivona, “Avaha yam goyona anua‑tavuni.” ");
INSERT INTO mvn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ka ononotoi taui nui iamam Iesu ya vonana inononi, ka taui matataui ivona, “Onoto taina koiaka? Tauna vonavona vivane tauna ana pata dewa goyona na‑nua‑tavuni! Kaiwadi, tauna koiaka?” ");
INSERT INTO mvn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kate Iesu vavinena wayahina ivona, “Avaha yam ito‑yavuha evaniahei, iuna yam vitumahana mamaei. Wayahina, yam nua gomagomanina nui ena‑ne‑kai.” ");
INSERT INTO mvn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka tuta munia, Iesu tutu‑vivini meagai anani wayahia kadu meagai kikitui wayahia, ka tauna Yaubada ya pai veimea ana ipupu ahiahina naunau‑waheyei. Ka a tau vi‑muni‑waiwai ai yau 12 nui ineine, ");
INSERT INTO mvn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ka vaivine tupwai kadu nui ineine. Nonova Iesu nua gawagawamina epa‑yavunei vaivine‑naia wayahia, kadu taui ai kwanaha vo‑vi‑aiaia ividoha. Vaivine‑naia wayahia tupwai ai wava taina. Aitam ana wava Mari (ivi‑wahani “me Magidala”), ka nonova tauna nihenina Iesu nua gawagawamina ai yau 7 epa‑yavunei, ");
INSERT INTO mvn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kadu aitam ai wava Ioana, taui Kusa awana, ka Kusa taina vivane KiniV Erodi ya tau paisewa ananina aitam, ka kadu aitam ai wava Susana. Ka mani vaivine habuhabui nui ineine ini‑keyekeyei, ka taui yai gugua wayahina Iesu tauna yaiana nui iaivaitei. ");
INSERT INTO mvn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ka aitam tuta tomotau yoko meagai habuhabuna wayahia iomomo, inau‑hohona Iesu wayahina, ka Iesu vona tana‑minikuna taina vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tau baguna aitam omo ya baguna wayahina, ka witiV utuna si‑yavuyavunena, ka tupwai utu etawana ipeu, ka tomotau iva‑taunei ivi‑goyoi, kadu manua iyaveyaveha idueyei iopu iania. ");
INSERT INTO mvn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka tupwai utu ipeu hanuhanuna wayahina, ka munia itabo, e iwenono, iuna tanopi‑nana nihenina eha daudau. ");
INSERT INTO mvn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka tupwai utu mata‑duduna nihenina ipeu, ka mata‑duduna itabo si‑guani, wayahina utu‑naia eha ita‑ua. ");
INSERT INTO mvn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka tupwai utu tanopi ahiahina wayahina ipeu, itabotabo, inatanata, e iuaua. Ka aihana ana tuta wayahina tau aihana utu ai yau 100 ivaniahei utu‑naia aitamoata aitamoata wayahia.” Ka Iesu yokoia vonei, ivona, “Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka munia, a tau vi‑muni‑waiwai ivi‑tanaiei, ivona, “Yam vona tana‑minikuna anꞌ anamana medeina?” ");
INSERT INTO mvn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka tauna ivona, “Yaubada avaha awaehemi ya pai veimea a nua‑uya hivahivana unononi unꞌ‑anamanei, kate tomotau yoko vona tana‑minikuna ana heta avonevonei inononi. Iuna apa‑taputapu Iginuma nihenina ivona, ‘taui idunedune, kate eha ai pata inꞌ‑anamane, ka taui ivanevaneneha, kate eha ai pata ina‑nua‑hau.’ ");
INSERT INTO mvn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ka vona tana‑minikunana anꞌ anamana taina. Utu‑naia vivane Yaubada yana vona deina. ");
INSERT INTO mvn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ka utu‑naia etawana ipeu vivane tomotaui vonana inononi, ka munia, Satana omo, vonana vainaui nuai wayahina deina. Ka taui eha ai pata vonana ivitumahane, kadu eha ai pata ito‑yavuha ivaniahe Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka utu‑naia ipeu tanopi hanuhanuna wayahina vivane tomotaui naona Yaubada yana vona inononi, idewa‑haiawa, kate taui nihenia eha wanohina. Wayahina, yai vitumahana mamaei a itoava vito‑nubu ana tuta wayahina, e ipeu iopu. ");
INSERT INTO mvn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka utu‑naia ipeu mata‑duduna nihenina vivane tomotaui vonana inononi, e ivi‑putu ineine, kate munia eha ai pata ina‑ua. Iuna tuta tuta nua‑vita yawai tanopia epepei, ka kadu yai nuanua ananina kaikaiwabo yai gugua tanopia ivaniahei, ka kadu yai nuanua ananina idewa‑haiawa tanopia. Wayahina, eha ina‑ua. ");
INSERT INTO mvn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ka utu‑naia ipeu tanopi ahiahina wayahina vivane tomotaui nuai ahiahina nihenina vonana inononi, inua‑vi‑avini, igwagwaheyei, e munia iuaua ahiahina. ");
INSERT INTO mvn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Eha aitam koiaka wayahikaia lampaV na‑tunu, e munia na‑hive kunia nihenina, o na‑bwae sita wayahina. Eha. Yaka dewa lampaV vuvunaha kabouboui, e ana pata manua a tau maꞌ na‑mahetei deina. ");
INSERT INTO mvn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vona ahiahina, avi nua‑uya ataina vitana wayahimi, apaina Yaubada nua‑uya‑naia na‑si‑vinꞌ‑omanei kadueyei. Ka kadu avi nua‑uya ataina hivahivana, apaina habuhabuka nua‑uya‑naia kanꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wayahina, avi tuta Yaubada yana vona wayahina uvanevaneneha, nau‑wawanimi udune‑vivinimi kadu unononi ahiahina. Iuna aituhu aviyaivia ataina ivanevaneneha ahiahina, inononi, vona ahiahina, taui nua‑uya ivaniahei, ka apaina yai nua‑uya na‑nata deina. Kate aituhu aviyaivia ataina inuanua vivane yai nua‑uya mamaei, ka aituhu eha ivanevaneneha ahiahina, apaina aviani inuanua ataina wayahia mamaei, nua‑uyana ivo‑haini na‑iakwa akanai.” ");
INSERT INTO mvn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ka munia, Iesu ayona kadu vavaneina iomo papani‑nana wayahina, ka yai nuanua idueyei. Ka yoko ananina manua‑nana imaꞌ‑potei, wayahina taui eha ai pata ina‑nu Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka aitam koiaka tauna mataedei, ivona, “Kauvea, ayom kadu vavaneim tanevava vuvunaha imimini, ka taui nuanuai wamke.” ");
INSERT INTO mvn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka Iesu vona‑nau‑patei, ivona, “Vona ahiahina, aituhu aviyaivia Yaubada yana vona inononi, ka aituhu idewa‑nubunubui, taui vivane ayoyou kadu vavaneiu Yaubada matana.” ");
INSERT INTO mvn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aitam tuta Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Nau‑wawanika kaone‑tamaneka navu taina papanina.” Ka igenu, e ivi‑naya. ");
INSERT INTO mvn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ka ivenavenau, ka Iesu daudauva, ka ino‑ainei. Ka wedinia vi‑putu hunahuna navu‑nana, ka nupuna ananina yai waꞌ nau‑goigoia, ka eha ani‑hoina igavivina. ");
INSERT INTO mvn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wayahina, a tau vi‑muni‑waiwai yai matauta nui Iesu inau‑vi‑dagui, ka ivona, “Aioi! Kauvea, Kauvea emini! Kagavivina!” Ka Iesu mini, e yahina ka nupuna awa‑tani, ivona, “Akanai!” Akaka wedinia genuana, e gomana. ");
INSERT INTO mvn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ka Iesu tauna a tau vi‑muni‑waiwai vi‑tanaiei, ivona, “Itomi medeina? Itomi yami vitumahana aveta?” Ka taui yai matauta nui, kadu nuai vi‑tupatupa ananina, ka matataui ivonavona, “Avi onoto taina? Iuna yahina kadu nupuna veimeyei, kadue movina ivi‑ateteyei.” ");
INSERT INTO mvn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ka Galili a papani ione‑tamanei, ka ivi‑naya, iomo inui me Gerasene yai tania. ");
INSERT INTO mvn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ka Iesu iopu taniana, ka aitam tau vi‑meagai omo. Nonova a itoava auyewana wayahina, nua gawagawamina habuhabui onotona nihenina imamaei. Wayahina, tuta mamanaina wayahina onotona eha ana kwama kadu eha ya manua, kate tauna ya pai maꞌ vivane unuvovo gubai nihenia. ");
INSERT INTO mvn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ka tuta tuta tomotau ipoyꞌ‑avini, ka nimana ka aena iyohoyohoni manawa kainumu wayahina, kadue tupwai tomotau idune‑vi‑anai. Kate nua gawagawamina bagibagi‑vainena, e onotona ininina epepei, e onotona vi‑kwavakwava, akaka kainumui tutu‑paipaia, ka nua‑nana veimeyei ine anata wayahina. Ka tutana Iesu onotona dueyei, akanai tauna nua gawagawamina veimeyei onotona wayahina na‑ni‑ubau na‑opu, na‑ni‑tawanei. Wayahina, onotona ipeu Iesu aena, ka dune‑opu ka konua, vi‑hone ananina, ivona, “Aioi! Iesu! Wamke Yaubada Tau Bagibagi Natuna! Aviani yam nuanua taua wayahiu? Aviani edewau? Aviama‑bagibagi wayahima eha edewa‑yaiyaieu!” ");
INSERT INTO mvn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka Iesu vi‑tanaiei, ivona, “Medeina am wava?” Ka tauna ivona, “Ama wava LegioniV.” Iuna nua gawagawamina yoko ani‑vainena avaha onotona inui, e nihenina imamaei. ");
INSERT INTO mvn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ka nua‑naia ihidahida‑havihavine Iesu wayahina, ka iviama‑bagibagi, ivona, “Eha eoneai ana‑opu Guba Pai Inahe wayahina!” ");
INSERT INTO mvn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ka maupwanina pono yoko ananina iduaduana oyaoyana wayahina. Ka nua gawagawamina yoko iviama‑bagibagi Iesu wayahina, ivona, “Eawaeheai ponoia anu nihenia.” Ka Iesu awaehei deina. ");
INSERT INTO mvn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ka tutana nua‑naia onotona ini‑tawanei, ponoia inui, ka ponoia ivi‑kwavakwava, ka yoko inau‑bwanunua bawai ai ivina. Ka kemana wayahina ipeu, ka igavivina navua, ianiga. ");
INSERT INTO mvn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ka avaha ponoia ai tau dune‑vi‑avina ponoia habuhabui yai aniga idudueyei, taui inovo ine meagai ananina ka meagai kikitui wayahia, ka tau vi‑meagai vaneana imataedai. ");
INSERT INTO mvn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Akaka tomotaui habuhabui iomo, yai nuanua aviani vinꞌ‑omoi idueyei. Ka iomo Iesu wayahina, ka onotona idudueyei. Nonova nua gawagawamina tauna nihenina mamaei, ka avaha vidoha, ka nuanua tunuhina, ka ana kwama weteni, ka Iesu aena manuena. Wayahina, tomotaui imatamatauta. ");
INSERT INTO mvn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ka tomotaui mataia dewana idueyei, medeina onotona ya vidoha vaniahei mani tomotau imataedai. ");
INSERT INTO mvn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iakwa, e me Gerasene habuhabui yai matauta nata ananina. Wayahina, taui Iesu ivihahaiei, ka yai nuanua tauna yai papani na‑ni‑tawanei. Wayahina, Iesu tauna a tau vi‑muni‑waiwai nui yai waꞌ igenu. ");
INSERT INTO mvn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ka onotona avaha nua‑naia gawagawami ini‑tawanei mini, iopu Iesu wayahina, e viama‑bagibagi, ivona, “Ana pata yauke nui kana‑ne?” Kate Iesu vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Eha. Wamke nau‑wawanim emavina yam megeia, ka dewa‑bagibagina Yaubada dewei wayahim emataedai.” Wayahina, onotona ine ya megeia, ka tauna Iesu ya paisewa bagibagina tau vi‑meagai yoko habuhabui mataedai. ");
INSERT INTO mvn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka Iesu tauna a tau vi‑muni‑waiwai nui ione‑tamane‑havinei, ka yoko ananina yai dewa‑haiawa nui ivenau‑potepotei, iuna yai nuanua ananina tauna. ");
INSERT INTO mvn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ka aitam onoto omo, ana wava Iairusa. Tauna yai manua tapanono a tau dune‑vi‑avina. Ka omo, e Iesu aena iwaodu, e viama‑bagibagi, ivona, “Kauvea, kanꞌ‑omo yau manua wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iuna natu tupu‑keana vavinena vi‑kwanaha ananina. Tauna a ponimana ai yau 12 ana heta vaniahei, ka tuta eha ani‑hoina na‑iakwa nꞌ‑aniga.” Ka Iesu ya viama awaehei, e Iairusi nui etawana ineine, ka yoko ananina ivi‑muniei, ka eha ani‑hoina ivi‑tunu‑havihavinei. ");
INSERT INTO mvn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ka yokoia nihenina aitam vavine ai kwanaha nui. Ka kwanahana vivane dayahi taitaina a itoava ponimana ai yau 12 nihenia, ka apaina neine. Tuta habuhabuna dokitaV idewa‑dadani isi‑vi‑yawai, kate eha ai pata, idewa‑wayohei. ");
INSERT INTO mvn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka vavinena ai heta inuanua deina, “Aituhu ana kwama ana heta avo‑dadani, akanai, avidoha.” Wayahina iomo, ivo‑dadani, akaka ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wayahina, Iesu yauna inovo, ka ivona, “Ia! Koiaka vo‑dadaniu?” Ka tomotau habuhabui yoko nihenina itana‑tavuni. Ka Pita vonei, ivona, “Kauvea, yoko taina imini‑vivinem, kadu itunu‑dadanim, a?” ");
INSERT INTO mvn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kate Iesu ivona, “Eha deina. Aitam koiaka au kwama vo‑dadani, ka avaha anamanei bagibagi tupwana ni‑tawaneu, ka one‑tamanei tau vo‑dadana wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ka vavinena anamanei Iesu avaha yai dewa anamanei. Wayahina iomo, ka yai tatava nui iaiwaodu Iesu aena, ka yoko mataia yai dewa iuna isi‑vinꞌ‑omanei, ivona, “Kauvea, nuanuai avidoha, wayahina am kwama avo‑dadani, ka avidoha‑kwayavoni.” ");
INSERT INTO mvn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ka Iesu vavinena vonei, ivona, “Natu, yami vitumahana nui, wayahina uvidoha‑dadana, ka avaha uvidoha. Wayahina, nua gomagomanina nui una‑ne‑kai.” ");
INSERT INTO mvn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka tutana Iesu vonavona vavinena wayahia, Iairusi ya tau paisewa aitam omo, e vane omanei ya manua wayahina, ivona, “Bada, natum yawaina avaha iakwa. Wayahina, eha tau viwavenena yana tuta eone‑kavovo.” ");
INSERT INTO mvn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka avaha tuyehana Iesu nononi, tauna Iairusi vonei, ivona, “Eha ematamatauta, kate nau‑wawanim evitumahaneu apaina natum vidoha.” ");
INSERT INTO mvn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ka ineine, ka iomo megeia. Ka Iesu yoko ananina vito‑potai, eha manuana nihenina ina‑nu. Ka ya nuanua Pita, ka Ioni, ka Iamesa, kadu tevanina amana ka ayona nui inuinu. ");
INSERT INTO mvn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ka tuta aitamoata wayahina yoko itoutou, ka ivi‑mohai ananina tevanina wayahina. Ka Iesu yai vi‑mohai vito‑potei, ivona, “Akanai tou! Ugenuana. Iuna tevanina eha tꞌ‑aniga, kate ino‑ainei.” ");
INSERT INTO mvn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ka tomotaui Iesu ivi‑nepei, iuna ianamanei tevana avaha aniga akanai. ");
INSERT INTO mvn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kate Iesu tevana nimana ivoa, ka vonei, ivona, “Natu, emini.” ");
INSERT INTO mvn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ka vo‑kwayavonina tevana nuana mavina, ka yawaina epei, e mini. Ka Iesu tevana ayona ka amana wayahia ivona, “Aniani uvenei, nꞌ‑am.” ");
INSERT INTO mvn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ka dewana wayahina amana kadu ayona nuai vi‑tupatupa ananina, wayahina Iesu kadu vonei, ivona, “Eha aitam koiaka yau paisewana uhaeye.” ");
INSERT INTO mvn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ka aitam auyewa wayahina Iesu tauna a tau hae ai yau 12 hone‑hohoni, ka tauna bagibagi venei, kadu ai awaeha venei ai pata nua gawagawamina tomotau wayahia iepa‑yavunei, kadu ai pata tomotau ai kwanaha isi‑vi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kadu vi‑tunei ine Yaubada ya pai veimea vaneana inaunau‑waheyei tomotau wayahia, kadu ai kwanaha isi‑vi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ka tauna ai veimea yai nae wayahina venei deina, ivona, “Eha aitam aviani wayahimia uhunia. Eha ami guna, eha ami kode, eha ami aniani, ka eha ami kwama ainua. ");
INSERT INTO mvn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ka avi tuta aitam meagai unui, avi manua wayahina ihonemi, akanai manuana unui, e manuana nihenina umamaei a itoava meagaina uni‑tawanei wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka avi tuta aitam meagai unui, aituhu eha inau‑kaiwemi, akanai meagaina a genahihi aemia ututu‑putu‑yavunei, ka uni‑tawanei. Ka tau vi‑meagai‑naia iaiaya uviwavenei deina, inꞌ‑anamanei apaina vitana ivaniahei Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ka ya ipupuna iakwa, a tau hae ini‑tawanei ineine meagai meagai, ka itutu‑vivina, e Vaneana Ahiahina inaunau‑waheyei, kadu tau kwanakwanaha papani aitamoata aitamoata nihenia isi‑vi‑yawai ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ka tuta‑nana wayahina Erodi, tauna Galili a tau veimea, dewaia tanoi habuhabui vaneai nononi, ka nuana vi‑tupatupa ananina wayahina. Iuna tupwai tomotau ivonavona, “Ioni Tau Bapitaiso avaha anigea mini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ka tupwai ivonavona, “Eha. Taina Elidia avaha omoi.” Kadu tupwai ivonavona, “Aitam tau apa‑taputapu, tuta nonova wayahina, avaha mini‑havine anigea, ka ataina paipaisewa.” ");
INSERT INTO mvn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ka Erodi kadu ivona, “Yauke yau veimea wayahina avaha Ioni magana aupwei. Ka avi onoto taina ivonevoneyei?” Wayahina, Erodi ya nuanua Iesu vaniahei, e dueyei. ");
INSERT INTO mvn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ka avaha Iesu a tau vi‑muni‑waiwai yai tutu‑vivina inau‑yehai, imavina, ka yai paisewa habuhabuna iaipupuei Iesu wayahina. Iakwa, e tauna taini, e nui iomo aitam meagai ana wava Betesaida wayahina, vivane ivi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kate eha ana pata taui ai heta imamae. Iuna tutana yoko vane inononi, taui kadu Iesu wayahina iomomo ivi‑muniei. Ka Iesu nau‑kaiwei, ka Yaubada ya pai veimea wayahina viwavenei, kadu tau kwanakwanaha wayahia si‑vi‑yawai ividoha. ");
INSERT INTO mvn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wayahina, habuhabui imamaei a itoava babau onuonu wayahina, ka Iesu a tau vi‑muni‑waiwai ai yau 12‑naia iomo tauna wayahina, ka ivonei, ivona, “Kauvea, aituhu yoko taina evi‑tunei imavina meagai nepeia wayahia, dewana dewa ahiahina deina. Iuna taui ai maꞌ ka yai pai dauva inaunau‑nene. Iuna baina papani anata, eha aitam aviani wayahi.” ");
INSERT INTO mvn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka tauna wayahia ivona, “Taumi uvi‑aniania.” Ka taui ivona‑nau‑pata, “Medeina? Itoai ama maꞌ eha habuhabuna. Palaua nima papani‑keana, ka iana ainua ai heta wayahiaia. Kaiwadi, yam nuanua ana‑ne aitam meagai wayahina, e yoko ai maꞌ aimwane, a?” ");
INSERT INTO mvn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ka yokoia wayahia ononotoi ai heta ai yau 5000 deina. Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Tomotau taina utana‑vewani, e yai yoko aitamoata aitamoata ai yau 50 deina imanuena.” ");
INSERT INTO mvn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ka taui inei, e ya vonana idewei, ka tomotau‑naia imanuena yai yoko wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ka Iesu palaua nima papani‑keana kadu iana ainua epei, ka wahuma dune‑vane, e Yaubada nau‑kaiwei aniani wayahina. Iakwa, gibui, ka a tau vi‑muni‑waiwai venei, e taui tomotau ivo‑patai. ");
INSERT INTO mvn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wayahina, yokoia iam‑iaua, ka aniani itupwa venuana ai yau 12 nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ka aitam tuta wayahina Iesu tauna a tau vi‑muni‑waiwai nui imamaei, ka tauna ana heta Yaubada wayahina viama, e ya viama iakwa, tauna a tau vi‑muni‑waiwai vi‑tanaiei, ivona, “Medeina tomotau ivonavona wayahiu, vivane yauke koiaka?” ");
INSERT INTO mvn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka a tau vi‑muni‑waiwai ivona‑nau‑pata, “Tomotau tupwai ivonavona wamke Ioni Tau Bapitaiso, ka tupwai ivonavona wamke Elidia, ka tupwai ivonavona wamke aitam tau apa‑taputapu, tuta nonova wayahina, ka anigea emini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ka tauna kadu vi‑tanaiei, ivona, “Kate taumi, medeina yami nuanua vivane yauke koiaka?” Ka Pita vona‑nau‑pata, “Wamke Tau Ito‑yavuha‑hoim Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka Iesu nau‑patana nononi, ka awaehei vivane tunuhina, kate ai veimea ananina venei, ivona, “Nua‑uyana vito‑potana mani tomotau wayahia. Eha umataedai deina.” ");
INSERT INTO mvn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kadu vonei, ivona, “Apaina yauke, Tauna Vi‑tomotau, inahe ka viha ananina avaniahei, ka ononotoi anani, ka tau vi‑nomu mata‑genai, kadu veimea a tau viwavenena ivihahaieu, e ina‑nau‑vi‑anigiu, kate munia, auyewa aitonu ina‑iakwa, Yaubada na‑si‑vi‑mini‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ka munia, tauna yoko wayahia ivona, “Aituhu aviyaivia wayahimia yami nuanua uvi‑muni‑waiwaieu, itomi nau‑wawanimi ami vita unꞌ‑awaehei, ka kadu ami ai nahanaha uavanei auyewa aitamoata aitamoata wayahina, e uvi‑muni‑waiwaieu deinake. ");
INSERT INTO mvn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ka aituhu aviyaivia wayahimia yami nuanua yawaimi unua‑tania, apaina yawai‑vavaha ututu‑haini. Ka aituhu aviyaivia wayahimia yawaimi unꞌ‑awaeheu, e wayahiu unꞌ‑aniga, apaina taumi yawai‑vavaha uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Unononi. Aituhu aviyaivia kaikaiwabo ani‑vainena tanopia ivaniahei, ka aituhu apaina nuai ivo‑haini, o aituhu yawai‑vavaha itutu‑haini, yai dewana vivane dewa‑kavokavovo, a? ");
INSERT INTO mvn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ka tuta ataina aituhu aviyaivia wayahiu ina‑ini‑yauyau, ka aituhu yau viwavenena wayahina ina‑ini‑yauyau, ka aituhu itana‑tavuneu, apaina tomotau‑naia dewa goyona ivaniahei. Iuna apaina yauke, Tauna Vi‑tomotau, amavina tanopi taina wayahina. Ka auyewana wayahina yauke didigau wayahiua, kadu Amau didigana wayahiua, kadu yanꞌ anelose ahihinata didigai nui amavina, ka auyewana wayahina tomotau‑naia atana‑tavunei. ");
INSERT INTO mvn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Vona ahiahina, tupwai tomotau wayahimia Yaubada ya pai veimea matamia udueyei, e munia unꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ka Iesu ya vonana nau‑yehai, ka auyewa ai yau 8 iakwa, tauna Pita, ka Ioni, ka Iamesa vi‑nua‑dadanei, ka aitonu nui ivane aitam oya, e ya nuanua viama Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ka tutana Iesu viama tepana ana dune habuhabuna am‑vinei, kadu ana kwama ana dune am‑vinei vivane kavukavu‑hoina, vonaina ana dune deina. ");
INSERT INTO mvn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ka onoto ainua, vivane Mosese kadu Elidia, iomo Iesu wayahina, e nui inau‑basekwa. ");
INSERT INTO mvn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ka ainuai wayahia kadu maheta ani‑vainena vanavana. Ka Iesu nui iaipuipupu tauna yanꞌ aniga apaina Ierusalema wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ka Pita tauna yaiana nui avaha iaino‑ainei, ka munia, imini, ka maheta ananina vanavana Iesu didigana wayahina idudueyei, kadu yaiana ainua nui idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kadu idueyei eha ani‑hoina ainuaia Iesu ina‑ni‑tawanei. Wayahina, Pita vi‑putu vonavona‑kavokavovo, ivona, “Kauvea, baina kadewa‑haiawa, iuna habuhabuka nui kamamaei. Wayahina, ama itonu vekevekeke aitonu ayonei, aitam wamke wayahim, ka kadu aitam Mosese wayahina, ka kadu aitam Elidia wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ya vonana eha ta‑nau‑yehai, ka tuta aitamoata hetaia aitam you vinꞌ‑omo, iopu ka tana‑kabubui. Wayahina, tau vi‑muni‑waiwai aitonu imatamatauta you‑nana nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka you‑nana nihenina aitam movi inononi, ivona, “Taina Natu ahihi‑hoina. Wayahina, nau‑wawanimi yana vona unononi.” ");
INSERT INTO mvn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka avaha movina ipupu iakwa, e Iesu ana heta mimini idueyei. Ka tuta tanoi wayahina, tau vi‑muni‑waiwai aitonuia dewana ihivehivei, eha yaiai ita‑mataedai. ");
INSERT INTO mvn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ka mana navi, Iesu tauna a tau vi‑muni‑waiwai nui oya‑nana wayahina iopu‑me, e yoko ananina tauna ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ka aitam onoto yokoia nihenina Iesu dueyei ka vi‑hone, ivona, “Tau Viwavenena, yau nuanua ananina natu onotona evo‑vi‑aiaiei, e tauna vidoha. Tauna natu tupu‑keana. ");
INSERT INTO mvn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ka tuta habuhabuna nua gawagawamina natu epepei, ka vo‑kwayavonina vi‑putu konukonua ananina, ka nua‑nana yana dewa wayahina tauna vi‑kwavakwava, ka awana wayahina punopuno vinꞌ‑omo, ka tuta habuhabuna vitevitei deina. ");
INSERT INTO mvn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ka avaha am tau vi‑muni‑waiwai taina aviamei nua gawagawamina inꞌ‑epa‑yavune, kate taui eha ai pata.” ");
INSERT INTO mvn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka Iesu ivona, “Aioi, itomi! Ununumi toyoina kadu eha yami vitumahana! Kaiwadi, tuta tuta yami dewa vitavitau!” Ka onotona wayahina ivona, “Natumna eomanei baina wayahiua.” ");
INSERT INTO mvn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ka tutana tupunaina omomo Iesu wayahina, nua‑nana gawagawamina nihenina one‑opuei tanopia ka nau‑yueyuei. Wayahina, Iesu nua‑nana veimeyei na‑ni‑ubau na‑opu tupunaina wayahina, e vidoha. Iakwa, Iesu tupunaina epe‑neiei amana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ka tomotau yokoia avaha dewana idueyei, ivona, “Dewana Yaubada bagibagi‑vainena wayahina vinꞌ‑omo!” Ka nuai vi‑tupatupa ananina. Ka tomotaui nuai vi‑tupatupa Iesu yana dewa habuhabuna wayahina, ka tuta aitamoata wayahina Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Unononi ahiahina! Yau vona taina wayahimia vona ananina. Apaina aitam onoto yauke, Tauna Vi‑tomotau, nꞌ‑am‑veneneyeu au havia wayahia, e taui ai pata iveimeyeu.” ");
INSERT INTO mvn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka a tau vi‑muni‑waiwai ya vonana eha ita‑nua‑hau. Tuta‑nana wayahina taui eha ai pata, iuna anamana vonaia wayahina vivane hivahivana. Kate eha Iesu ita‑vi‑tanai na‑vo‑vi‑mahete wayahia, iuna iaini‑yauyau. ");
INSERT INTO mvn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ka a tau vi‑muni‑waiwai matataui ivito‑dahadaha vivane apaina koiaka wayahia ana wava ananina. ");
INSERT INTO mvn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ka Iesu avaha yai nuanua tanoi anamanei. Wayahina, aitam tevana epei omanei, e nepena vi‑au‑mini, e taui vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Tevana kikituna taina udueyei. Aituhu aviyaivia aitam tevana kikituna taina deina inau‑kaiwei au wava wayahina, taui dewana wayahina kadu taua inau‑kaiweu. Ka aituhu aviyaivia inau‑kaiweu, dewana wayahina kadu au tau vi‑tune inau‑kaiwei. Wayahina, aituhu koiaka wayahimia na‑nua‑opu‑vaine, apaina tauna ana wava ani‑vainena Yaubada matana.” ");
INSERT INTO mvn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ka a tau vi‑muni‑waiwai ana wava Ioni vonei, ivona, “Kauvea, itoai aitam onoto adueyei, ka tauna nua gawagawamina vitua‑yavunei am wava a bagibagi wayahina. Ka itoai yana dewa avito‑potei, iuna onoto‑nana eha yaka yoko.” ");
INSERT INTO mvn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ka Iesu ivona, “Eha nau‑wawanimi uvito‑pote. Yami dewana eha ahiahina. Iuna aituhu aviyaivia eha ami havia, akanai taui iaivaitemi.” ");
INSERT INTO mvn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka Iesu ya mavi‑havine wahuma wayahina anꞌ auyewa avaha vi‑hinahina. Wayahina, ya nuanua ananina na‑vane Ierusalem wayahina. Ka tauna a tau vi‑muni‑waiwai nui etawana ineine. ");
INSERT INTO mvn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ineine, ka Iesu tau mataeda tupwai vi‑tunei iomo naona me Samaria yai meagai aitam wayahina, e tau vi‑meagai tauna ya vinꞌ‑omana wayahina ivo‑vi‑aiai. ");
INSERT INTO mvn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kate tau vi‑meagai‑naia eha ita‑nau‑kaiwe, kate vihahaiei. Iuna taui avaha anamanei, Iesu kadu tauna a tau vi‑muni‑waiwai nui ivanevane Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ka Iamesa kadu Ioni, avaha tomotaui yai vihaihai tanoi inononi, e Iesu ivi‑tanaiei, ivona, “Kauvea, medeina yam nuanua? Nau‑wawaniai ai ananata wahuma wayahina aveimeyei na‑opu‑me, e meagai taina avita‑vovoni?” ");
INSERT INTO mvn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kate Iesu magigino, ka ainuai awa‑viaohei yai vonana wayahina, ");
INSERT INTO mvn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ka tauna a tau vi‑muni‑waiwai nui mani meagai wayahina iomo. ");
INSERT INTO mvn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ka ineine etawana, ka aitam onoto omo, e Iesu wayahina ivona, “Yauke yau nuanua ananina tuta tuta avi‑muni‑waiwaiem. Ka yau nuanua aveta eneine, akanai yauke avi‑muniem.” ");
INSERT INTO mvn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka Iesu onotona vona‑nau‑patei, ivona, “Naona enuani. ");
INSERT INTO mvn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ka Iesu kadu aitam onoto wayahina ivona, “Evi‑muni‑waiwaieu.” Ka onoto‑nana ivona, “Kauvea, naona eawaeheu amavina megeia, e amau yana tuta na‑iakwa wayahina apotepotei. Na‑iakwa, atavuni, akanai avi‑putu avi‑muniem.” ");
INSERT INTO mvn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ka Iesu vona‑nau‑patei, ivona, “Taui aninigai nau‑wawani tau mate itavuni, kate wamke nau‑wawanim ena‑ne evi‑putu Yaubada ya pai veimea enaunau‑waheyei.” ");
INSERT INTO mvn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka onoto vꞌ‑itonuna kadu omo, e ivona, “Kauvea, yau nuanua apaina avi‑putu avi‑muniem, ka ataina yau nuanua eawaeheu amavina yau megeia, e yau yoko wayahia anau‑kapoiei. Na‑iakwa, avi‑putu avi‑muniem akanai.” ");
INSERT INTO mvn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kate Iesu vonei, ivona, “Aituhu aviyaivia aitam paisewa ivi‑nua‑dadani, ivi‑putui, ka aituhu tuta tuta yai nuanua imagigino, e mani paisewa inuanua wayahina, taui eha nau‑wawani Yaubada ya paisewa idedewe.” ");
INSERT INTO mvn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ka dewaia munina Kauvea Iesu mani tau vi‑muni ai yau 72 vi‑nua‑dadanei, e vi‑tunei ine ainua ka ainua meagai anani kadu meagai kikitui papanina habuhabuna wayahina. Iuna ya nuanua tuta eha ani‑hoina na‑iakwa, tauna tau vi‑meagai‑naia na‑nau‑vi‑taui. ");
INSERT INTO mvn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ka tauna a tau vi‑muni vovoui vonei, ivona, “Aihana taina vivane ananina, kate tau paisewa eha ai pata, aitonuata ai heta. Wayahina, nau‑wawanimi aihana taina a Kauvea wayahina uviama, e tauna kadu mani tau paisewa vi‑tunei ine yanꞌ aihana nihenina ipaipaisewa. ");
INSERT INTO mvn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Una‑ne, upaisewa. Itomi lamiV deinake, ka avi‑tunemi kedewa manimanini niwania. Wayahina, nau‑wawanimi udune‑vivinimi! ");
INSERT INTO mvn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka yami nae taina wayahina eha nau‑wawanimi kina o kina a pai vi‑ai unꞌ‑epe. Ika, nau‑wawanimi uneine ka eha ami kode, ka kadu eha ami ae‑yapayapa vꞌ‑inuana unꞌ‑epe. Ka avi tuta uni‑awana etawana, eha nau‑wawanimi babau uoneone vona‑kavokavovo wayahina. Wayahina, eha aitam koiaka unau‑kaiwe etawana. ");
INSERT INTO mvn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ka avi tuta aitam manua nihenina unuinu, nau‑wawanimi naona una‑vona, ‘Yau nuanua manua taina kadu taui imamaei baina nua gomagomanina ivaniahei Yaubada wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka aituhu tau vi‑manua‑naia wayahia aitam mamaei, e tauna ya nuanua ananina vivane nua gomagomanina, akanai enau‑iaiavei, e yam nua gomagomanina tauna wayahina mamaei akanai. Ka aituhu tau vi‑manua‑naia wayahia eha aitam ya nuanua nua gomagomanina na‑vaniahe, akanai nua‑vita uvaniahei, iuna yam nua gomagomanina mavi‑havinem, ka kadu nau‑wawanimi manua‑nana uni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka aituhu tau vi‑manua‑naia wayahia aitam yami nua gomagomanina vaniahei, akanai manua‑nana nihenina umamaei a itoava meagai‑nana uni‑tawanei wayahina. Eha mani manua mani manua wayahia uneine umamae meagai‑nana nihenina. Kate nau‑wawanimi avi manua umai‑nui, akanai manua‑nana nihenina umamaei. Ka avi pai am o avi pai nim tau vi‑manua‑naia iam‑veneneyemi, akanai uamam kadu unimnim deina. Eha anianina wayahina uvi‑tanatanaie. Iuna itomi tau paisewa nau‑wawanimi ami nau‑pata paisewana wayahina uvaniahei. Wayahina, aituhu tomotaui yai nuanua ivo‑patami, akanai, eha ami vo‑pata uvihahaie! ");
INSERT INTO mvn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka aituhu avi meagai inau‑kaiwemi, itainimi, e nui umamaei, avi aniani matamia ibouboui akanai, aniani taina uamam. ");
INSERT INTO mvn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ka avi tau kwanakwanaha tenoke imamaei uvo‑vi‑aiaiei ividoha, ka kadu unaunau‑wahei, una‑vona, ‘Yaubada ya pai veimea avaha omo nepemia.’ ");
INSERT INTO mvn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka avi tuta aitam meagai unuinu, aituhu tau vi‑meagai‑naia ivihahaiemi, akanai itomi etawana uneine, e wayahia una‑vona, ");
INSERT INTO mvn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yami meagai a genahihi aeai pwatepwatei, kate udueyei! Ataina anau‑wohi‑yavunei matamia yami iaiaya wayahina. Ka iaiaya taina anꞌ anamana vivane apaina Yaubada meagai taina na‑vita‑vovoni. Ka yama nuanua unꞌ‑anamanei Yaubada ya pai veimea avaha vi‑maupwani wayahimia.’ ");
INSERT INTO mvn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ataina avonemi, apaina, vita‑vovona anꞌ auyewa wayahina, tau vi‑meagai‑naia nonova Sodom nihenina ai vita‑vovona ivaniahei, akanai taui ai dewa‑yaiyai ivaniahei, kate avi meagai ivihahaiemi, taui ai dewa‑yaiyai ani‑vainena ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aioi, meagai Korasini! Kadu aioi, meagai Betesaida! Aioi wayahimia! Iuna avaha dewa‑bagibagi‑vainenaia habuhabuna matamia adedewei ududueyei, kate ataina eha yami vitumahana. Ka aituhu dewa‑bagibagi‑vaine‑naia adedewe taui eha me Iudea wayahi, taui meagai Taia o kadi meagai Sidoni imamaei nihenia, vona ahiahina, tau vi‑meagai‑naia ivitumahana, ka yai dewa goyona wayahia inua‑vinana, kadu kwama moimoiana iweteweteni, kadu hanavu nihenina imanuena, iuna inua‑vita. ");
INSERT INTO mvn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ka avona‑havine. Vita‑vovona anꞌ auyewa wayahina, tau vi‑meagai Taia ka Sidoni ai viha ivaniahei, kate itomi inahe ani‑vainena uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka meagai Kapenaum, apaina wamke medeina? Ataina enuanua auyewa pai nau‑yehata wayahina wahuma evaniahei, a? Avonem eha! Apaina ena‑opu ai ananata a papani HadesiV wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aituhu aviyaivia movimi inononi, taui kadu moviu inononi. Ka aituhu aviyaivia ivihahaiemi, taui kadu taua ivihahaieu. Ka kadu aituhu aviyaivia ivihahaieu, taui kadu Yaubada ivihahaiei. Iuna tauna vi‑tuneu.” ");
INSERT INTO mvn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ka ya ipupuna iakwa, e tau paisewa‑naia ai yau 72 ini‑tawanei, ine, ipaipaisewa. Ka yai paisewa iakwa, imavina iomo yai dewa‑haiawa nui, ka imataedei, ivona, “Kauvea, itoai avaha nua gawagawamina habuhabuna aveimeyei tomotau ini‑tawanei. Ka tomotau avo‑vi‑aiaiei deina, iuna am wava a bagibagi wayahina apaipaisewa.” ");
INSERT INTO mvn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka tauna vonei, ivona, “Ika. Nua habuhabui nau‑wawani yau veimea ivi‑ateteyei deina. Nonova Satana adudueyei wahuma mamaei, ka kadu tauna ipeu iopu vonaina deinake. ");
INSERT INTO mvn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ka udu! Avaha ami awaeha bagibagina avenemi, e nua gawagawamina uveimeyei, ka ataina taui mwata kadu weweda deina uva‑taunei. Ami havia yai bagibagi ubagibagi‑tawanei. Wayahina, eha aitam nua gawagawamina ana pata vi‑goyomi. ");
INSERT INTO mvn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka nua‑naia uveimeyei nau‑wawani ivi‑ateteyemi. Ka udewa‑haiawa dewana wayahina. Ka avonemi, kadu aitam dewa mamaei dewana vane‑tawanei. Yaubada avaha itomi ami wava ginumi wahuma, ka dewa‑nana vivane dewa ananina, ka nau‑wawanimi udewa‑haiawa ananina dewa‑nana wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka Iesu ya vonana tau paisewa‑naia wayahia iakwa, e Nuana Ahihinata dewa‑haiawa venei, ka dewa‑haiawana nau‑vi‑anai, ka Iesu tauna Amana awa‑davei, ivona, “Amau, kaiwa ananina! Wamke wahuma kadu tanopi ai Kauvea, ka awa‑davedavem! Iuna yam nua‑uya ehivehivei tanopi a tau nua‑uya wayahia kadu tanopi a tau anamana wayahia. Ka aituhu aviyaivia ivitumahanem, meameai ayo‑amai ivitumahanei deina, akanai tomotaui wayahia yam nua‑uya esi‑vinꞌ‑omanei inꞌ‑anamanei. Amau, kaiwa ananina. Iuna dewana vivane yam nuanua. ");
INSERT INTO mvn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Amau avaha dewa habuhabuna awaeheu aveimeyei. Ka tauna ana heta anamaneu vivane yauke Natuna koiaka. Ka eha kadu aitam tꞌ‑anamaneu taua koiaka. Ka aitamoata deina, eha kadu aitam Amau tꞌ‑anamane, akanai yauke taua au heta anamanei. Ka yau nuanua Amau asi‑vinꞌ‑omanei mani tomotau wayahia, e kadu inꞌ‑anamanei.” ");
INSERT INTO mvn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ka ya viama tanoi iakwa, e tauna magigino a tau vi‑muni‑waiwai ai yau 12 wayahia, ka vonei, ivona, “Vona ahiahina, itomi nau‑iaiava ananina uvaniahei Yaubada wayahina! Iuna tauna awaehemi yau dewaia ududueyei! ");
INSERT INTO mvn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Avonemi, tuta nonova a itoava tuta ataina wayahina tau apa‑taputapu habuhabui, kadu tau veimea habuhabui yai nuanua dewaia idudueye, kate eha ai pata. Ka kadu yai nuanua vonaia inonononi, kate eha ai pata.” ");
INSERT INTO mvn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ka aitam auyewa wayahina, Mosese ya veimea a tau nua‑uya aitam mini, ka ya nuanua Iesu a nua‑uya nau‑dadani aitam vi‑tanai wayahina. Akaka ivona, “Tau Viwavenena, avi dewa nau‑wawaniu yawai‑vavaha avaniahei?” ");
INSERT INTO mvn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka vona‑nau‑patei, ka vi‑tanaiei, ivona, “Aviani Iginuma voneka? Medeina enuanua wayahina?” ");
INSERT INTO mvn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka tau nua‑uya‑nana ivona, “Iginuma voneka, ‘Nau‑wawanim Yaubada yam Kauvea edewa‑nuanuaiei nuam habuhabuna wayahina, kadu yam nuanua habuhabuna wayahina, ka kadu yam bagibagi habuhabuna wayahina’ ka kadu voneka, ‘Nau‑wawanim am niam edewa‑nuanuaiei wamke aitamoata deina.’” ");
INSERT INTO mvn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Akaka Iesu vonei, ivona, “Yam vona‑nau‑patana vivane tunutunuhina. Aituhu ededewei deina, akanai yawai‑vavaha evaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ka onoto‑nana eha tupwai tomotau ta‑dewa‑nuanuaie. Kate tauna ya nuanua mani tomotau inuanua yana dewa vivane tunutunuhina ana noe. Wayahina, tauna Iesu vi‑tanaiei, ivona, “Ka au niau koiaka?” ");
INSERT INTO mvn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ka Iesu vona‑nau‑patei aitam viviwava wayahina vivane tana‑minikuneyei, ivona, “Aitam onoto meagai Ierusalem ni‑tawanei, opuopu meagai Ieriko wayahina. Ka etawana tau vainau tupwai ivaniahei, ipoyꞌ‑avini, ka ana kwama inau‑kakia, kadu ivunuvunui, ka eha ani‑hoina nꞌ‑aniga. Iakwa, onotona ini‑tawanei etawana wayahina, ka inovo‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka munia, tau vi‑nomu aitam etawana tanoi wayahina opuopu. Ka avaha onoto‑nana dueyei, tauna ni‑tawanei etawana papania. ");
INSERT INTO mvn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ka munia, dede Levi onotona aitam opuopu, ka avaha onoto‑nana dueyei, tauna kadu ni‑tawanei etawana papania. ");
INSERT INTO mvn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka munia, aitam onoto papani Samaria wayahina etawana opuopu. Ka tutana tauna onoto‑nana dueyei, dune‑nuanuaiei. ");
INSERT INTO mvn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ka omo wayahina, ka ana bwaka wayahia bunama ka wainaV iwahi, kadu pania. Iakwa, tauna tau inahena si‑nai, omanei tauna ya vahitau wayahina, e hetana boui. Ka Samaria onotona etawana baimina aena ni‑awana, ka tau inahe‑nana vi‑ata ineine a itoava aitam manua pai dauva ivaniahei wayahina. Ka auyewana Samaria onotona dune‑vi‑avini kadu nau‑matava. ");
INSERT INTO mvn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ka mana navia, hanu ainua ana kode wayahina epei, e tau vi‑manuana venei patana wayahina, ka ivona, ‘Onoto tanoi edune‑vi‑avini. Ka avi tuta amavina, aituhu aviani evenevenei hetana, yauke avene‑havinem.’” ");
INSERT INTO mvn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ka ya viviwavana iakwa, e Iesu tau nua‑uya‑nana vi‑tanaiei, ivona, “Aitonu wayahia, koiaka enuanua vivane tau inahe‑nana vi‑niana?” ");
INSERT INTO mvn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka tau nua‑uya‑nana ivona, “Tauna dewa‑vidovidohei.” Ka Iesu vonei, “Ika. Wayahina, wamke nau‑wawanim evi‑putu ededewei deina.” ");
INSERT INTO mvn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka Iesu tauna a tau vi‑muni‑waiwai nui ivi‑putu‑havine etawana ivanevane Ierusalem wayahina. Ka iomo aitam meagai kikituna wayahina, ka vavine aitam, ana wava Marita, nau‑kaiwei, ka taini neiei ya manua. ");
INSERT INTO mvn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ka Marita taina, ana wava Mari, Iesu aena manuena, ka yana ipupu wayahina vanevaneneha. ");
INSERT INTO mvn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ka Marita nuana ivita, iuna dewa habuhabuna mamaei aniani ananina wayahina. Wayahina, Marita omo Iesu wayahina, e viamei, ivona, “Kauvea, medeina? Taiu yana dewa eha tunuhina. Iuna ni‑tawaneu au heta apaipaisewa. Eveimeyei mavina na‑ivaiteu!” ");
INSERT INTO mvn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka Kauvea vona‑nau‑pata, ivona, “O, Marita, Marita! Dewa habuhabuna wayahina enuanua toyoina, kadu dewaia wayahina nuam ivita. ");
INSERT INTO mvn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kate avonem, dewa aitamoata vivane dewa ananina, ka Mari avaha dewana vi‑nua‑dadani. Wayahina, ataina eha nau‑wawaniu dewa tunina aveimeye.” ");
INSERT INTO mvn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ka aitam auyewa wayahina, papani aitam wayahina Iesu viama Yaubada wayahina. Ka viama‑nana iakwa, aitam a tau vi‑muni‑waiwai wayahia omo viamei, ivona, “Kauvea, aituhu memeanina wayahima, aitam viama Yaubada wayahina eviwaveneai, anuani aviama, Ioni Tau Bapitaiso a tau vi‑muni‑waiwai aitam viama viwavenei deina.” ");
INSERT INTO mvn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wayahina vonei, ivona, “Avi tuta uviama Yaubada wayahina, uviama taina deina, ");
INSERT INTO mvn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ka ama maꞌ ataina wayahina eveneai. ");
INSERT INTO mvn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ka yama goyona enua‑piahi, ");
INSERT INTO mvn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ka viamana iakwa, viviwava wayahina viwavenei viama a venavenau wayahina, ivona, “Aituhu ioyoma pouna wayahina eomo am niam ya manua wayahina, ka aituhu evi‑honei, ena‑vona, ‘Au niau, kaiwa ananina. ");
INSERT INTO mvn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Au niau aitam yana nae wayahina avaha omo wayahiua, ka eha aitam aviani wayahiua yau manua nihenina avene nꞌ‑ania. Wayahina, yau nuanua palaua aitonu eveneu, avenei.’ ");
INSERT INTO mvn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka am niam manua nihenina na‑vonem, ‘Ia! Edu! Avaha ioyoma pouna. Avaha manua awana awa‑pota abou‑potei, ka kadu yauke natunatu nui avaha adaudauva. Eha memeanina wayahiu amini, aivaitem.’ ");
INSERT INTO mvn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Unononi avonemi. Tauna am niam, kate eha ya nuanua na‑ivaitem, iuna ioyoma pouna wayahina eomo. Ka aituhu etutu‑keakeana, munia tauna na‑mini, ka aviani kaiwadi nuanuam na‑venem, iuna yam ate‑vatu nui egwagwaheyei. ");
INSERT INTO mvn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wayahina, avonemi, viama Yaubada wayahina aitamoata deina. Aituhu uviama, apaina tauna na‑venemi. Aituhu unaunau‑nene, apaina uvaniahei. Kadu aituhu awana bou‑potana wayahina ututu‑keakeana, apaina awana wayahimia nꞌ‑am‑waei. ");
INSERT INTO mvn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vona ahiahina, aituhu aviyaivia iviama toyoina, apaina ivaniahei. Ka aituhu aviyaivia inaunau‑nene, apaina yai nuanua ivaniahei. Ka kadu aituhu aviyaivia itutu‑keakeana, apaina awana bou‑potana wayahia nꞌ‑am‑waei. ");
INSERT INTO mvn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ka tupwami natunatumi imamaei. Ka aituhu natumi am navovo omo wayahimia, e ya nuanua iana uvenei, itomi medeina? Kaiwadi, mwata uvenei? Eha. ");
INSERT INTO mvn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O aituhu tauna ya nuanua kamkam pouna uvenei, itomi medeina? Kaiwadi, weweda uvenei? Eha. ");
INSERT INTO mvn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Avaha anamanemi, yami dewa aitamoata aitamoata eha tunutunuhina Yaubada matana, a? Kate avaha uanamanei, dewa ahiahina udedewei natunatumi wayahi. Wayahina, nau‑wawanimi unuani, Amami wahuma yana dewa ahiahina itomi tanopia yami dewa ahiahina vane‑tawanei. Ka kadu tauna ya nuanua aituhu aviyaivia yai nuanua ananina Nuana Ahihinata ivaniahei, ka aituhu iviamei wayahina deina, tauna yai viamana nꞌ‑awaehei, na‑venei!” ");
INSERT INTO mvn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ka aitam tuta Iesu aitam onoto ivaitei. Onotona eha ana pata na‑ipupu, iuna nua goyogoyona nihenina veimeyei deina. Ka Iesu nua goyogoyo‑nana veimeyei onotona wayahina na‑ni‑ubau na‑opu. Iakwa, onotona vidoha, e ipuipupu. Ka yokoia dewana idueyei nuai venau‑tupatupa, kadue idewa‑haiawa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kate tupwai wayahia ivonavona, “Iesu yana dewa eha ahiahina. Iuna Beelesebubi vivane nua goyogoyoi habuhabui ai tau veimea, ka tauna Iesu ya bagibagi awaehei, e bagibagi‑nana wayahina tomotau vo‑vi‑aiaiei ividoha.” ");
INSERT INTO mvn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka tupwai yokoia wayahia yai nuanua inau‑dadani. Wayahina, iviamei aitam iaiaya wahuma wayahina na‑venei, idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ka Iesu avaha yai nuanua tanoi anamanei. Wayahina vonei, ivona, “Aituhu avi pai veimea nihenina tomotau‑naia ai heta ivi‑naua, apaina pai veimea‑nana ivita‑vovoni na‑iakwa. Kadu avi dede nihenina tomotau‑naia ai heta ivi‑vonavona ivi‑naua, apaina dede‑nana na‑goyo, ivita‑vovoni, na‑peu. ");
INSERT INTO mvn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wayahina unononi. Aituhu yami vona wayahiu tunutunuhina, Satana tauna ana heta vi‑naua. Ka medeina ya pai veimea na‑mini deinake? Eha ana pata. Itomi uvonavona yauke nua goyogoyona aveimeyei Beelesebubi ya bagibagi wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka unuani. Ami tau vi‑muni tupwai kadu nua goyogoyoi iveimeyei, kadi koiaka ya bagibagi wayahina iveimeyei? Aituhu taua Beelesebubi ya bagibagi wayahina adedewei, ami tau vi‑muni medeina? Apaina taui yami vonana wayahiu inau‑yanahimi. ");
INSERT INTO mvn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka aituhu yauke nua goyogoyoi aveimeyei Yaubada ya bagibagi wayahina, dewana viwavenemi Yaubada ya pai veimea avaha vinꞌ‑omo wayahimia, a? ");
INSERT INTO mvn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","Kadu aitam pai dune avenemi. Aituhu aitam tau vi‑manua bagibagina mamaei, Satana deinake, akanai tauna ya waipai nꞌ‑epei, e ya gugua dune‑vi‑avini ahiahina. Ka tauna nuanua vivane ya waipai bagibagina ana pata. Ka aituhu kadu aitam onoto na‑omo, ka aituhu onotona vꞌ‑inuana tau vi‑manuana bagibagi‑tawanei, onoto‑nana ana pata tau vi‑manuana ya waipai nꞌ‑epa‑tawanei. Na‑iakwa, onoto‑nana tau vi‑manuana ya gugua vainaui, ka munia guguaia yaiana wayahia vo‑patai. Ka yauke onoto vꞌ‑inuana deinake. ");
INSERT INTO mvn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Udune‑vivinimi! Etawana ainua wayahimi mamaei. Kadi itomi yaiau, o kadi itomi au havia. Aituhu itomi yaiau, aihana ana tuta nihenina nui kapaipaisewa, una‑ivaiteu. Kate aituhu itomi au havia, aihana ana tuta nihenina eha nui kapaipaisewa, iuna yau paisewa uvi‑goyoi. ");
INSERT INTO mvn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nua goyogoyona yai dewa taina. Taui tomotau nihenina inu imamaei, iveimeyei. Ka aituhu tau bagibagi aitam omo, e aituhu tauna aitam nua goyogoyona veimeyei, vivane a tomotau na‑ni‑tawanei, nua goyogoyo‑nana omomoi anata, e pai maꞌ vovouna wayahina naunau‑nene. Ka naunau‑nene‑wayohe. Wayahina, nua goyogoyo‑nana ana heta ivona, ‘Ia! Nonova amamaei ahiahina. Wayahina, ataina amavina tomotauna wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka avaha mavina tomotau‑nana wayahina, ana dune ahiahina vaniahei aitam manua deina, avaha nihenina inau‑hinihini‑yehai, kadu avaha inau‑wohi‑yehai. ");
INSERT INTO mvn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wayahina, nua goyogoyo‑nana ine, e nua goyogoyo‑vainei ai yau 7 vaniahai, taui yai goyona goyo‑vainena. Akaka omanei tomotau‑nana wayahina, e habuhabui inu nihenina, ka imamaei. Ka nonova tomotau‑nana yawaina goyona, kate pai nau‑yehata wayahina yawaina goyo‑vainena.” ");
INSERT INTO mvn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka tutana Iesu vonana ipuipupuei, vavine aitam yokoia wayahia ivi‑hone movi ananina wayahina, ivona, “Kaiwa ananina ayom wayahia. Iuna, Yaubada nau‑iaiavei, vivane taui madi vi‑natunem, kadue nunui matana wayahia enunu!” ");
INSERT INTO mvn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka tauna vona‑nau‑patei, ivona, “Ika, akanai. Kate unononi, avonemi. Aituhu aviyaivia Yaubada yana vona inononi, kadu aituhu idewa‑nubunubui, taui ai nau‑iaiava ahihi‑vainena ivaniahei kadu idewa‑haiawa.” ");
INSERT INTO mvn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ka tutana Iesu dueyei yoko inau‑hohona, ka ai yau natanata, tauna vonei, ivona, “Ataina itomi tau maꞌ tanopi tomotau goyogoyomi. Iuna taumi yami nuanua naona iaiaya adewei, udueyei, e munia uawaehei uvitumahaneu. Ka apaina iaiaya aitamoata ana heta udueyei. Ka iaiayana taina. Aitam iaiaya omomo vivane tau apa‑taputapu ana wava Iona deina. ");
INSERT INTO mvn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iuna tuta nonova Iona aitam iaiaya me Nineve wayahi. Kadu tuta eha ani‑hoina na‑iakwa yauke, Tauna Vi‑tomotau, aitam iaiaya itomi wayahimi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ka apaina, vitana matana anꞌ auyewa wayahina, tomotau habuhabui imini‑havine. Ka auyewana wayahina me Seba yai kwiniV itomi nui umimini, ka vavinena inꞌ‑apa‑goyogoyoemi. Iuna nonova Solomoni yana tuta nihenina, taui ine bana mamanaina, iuna yai nuanua Solomoni ya nua‑uya ina‑nononi. Ka ataina Tauna Vi‑tomotau yau nua‑uya Solomoni ya nua‑uya vane‑tawanei, kate itomi eha uta‑nononiu. ");
INSERT INTO mvn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka kadu apaina, vitana matana anꞌ auyewa wayahina, me Nineve itomi nui umimini, ka taui inꞌ‑apa‑goyogoyoemi. Iuna tutana Iona omo wayahia, e naunau‑wahei, taui inononi kadu inua‑vinana. Ka Tauna Vi‑tomotau au wava Iona ana wava vane‑tawanei, kate eha uta‑nononiu. Wayahina kadueyei, yami dewana eha tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Eha nau‑wawanika lampaV katunu‑mahete, e manua nihenina kahivei. Eha. Aituhu avaha lampaV katunu‑mahetei, nau‑wawanika a pai vi‑ai hetana kaboui, ka taui habuhabui manua inuinu ai pata a maheta idudueyei ahiahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ka aitamoata aitamoata wayahimia nau‑wawanimi unononi. Nuami lampanaV deina, ka ininimi manua deina. Ka nuami ininimi habuhabuna vo‑vi‑mahetei, kadu veimeyei. Ka aituhu nuami tunutunuhina, ininimi habuhabuna mahemaheina. Iuna tuta tuta nuami tunutunuhina vona tunutunuhina nꞌ‑awaehei na‑nuinu nihenimia. Ka aituhu nuami goyona, ininimi habuhabuna novanovanina. Iuna tuta tuta nuami goyona vona goyona nꞌ‑awaehei na‑nuinu nihenimia. ");
INSERT INTO mvn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wayahina, anau‑vi‑avinimi udune‑vivinimi ahiahina. Eha nau‑wawanimi maheta ana vona ebou‑pote. ");
INSERT INTO mvn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aituhu maheta nihenimia nau‑vi‑anaimi, ininimi habuhabuna mahemaheina, ka eha aitam aviani novanovanina, akanai yawaimi habuhabuna tunutunuhina, lampaV a maheta wayahimi tapa‑yayai deinake.” ");
INSERT INTO mvn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka avaha ya ipupuna iakwa, aitam Parisi ya nuanua iomo ya manua, e Iesu nui inꞌ‑am. Ka Iesu awaehei deina. Wayahina, iomoi manua, e Iesu inui, e daudauva baimina, e potapota aniani wayahina. Ka Iesu eha me Iudea yai dewa tutuaina ta‑vi‑muni. Naona taui nimai inosia, e munia iamam. ");
INSERT INTO mvn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka avaha Parisi‑nana Iesu yana dewa dueyei, e nuana venau‑tupatupa. ");
INSERT INTO mvn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Kauvea vonei, ivona, “Itomi Parisi habuhabumi vei kadu nau‑kai upuiata unosinosia. Ka inemanema kadu goyona habuhabuna nuami nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ia! Itomi naunau‑wanami! Yaubada ininimi vevewanei, ka tauna kadu nuami vevewanei. Wayahina, nau‑wawanimi kadu nuami unosinosia dewa tunutunuhina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aituhu yami nuanua yawaimi vidoha Yaubada matana, akanai nau‑wawanimi tomotau una‑ivaitei ka uam‑venena‑kavovo. Na‑iakwa, yami dewa habuhabuna ividoha Yaubada matana deinake. ");
INSERT INTO mvn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Itomi yami dewa taina deina. Aviani kikituna tabotabo yami baguna nihenina ana wava minitiV kadu rueV deina, guguaia utana‑vewani gwau ai yau 10 wayahia, ka gwau aitamoata Yaubada uvo‑patei akanai. Kate, aioi, itomi Parisi wayahimia! Dewa‑yaiyai ananina potapotami. Iuna uvitupu tomotau wayahia, kadu uvainau deina, ka kadu eha Yaubada udewa‑vidovidohe. ");
INSERT INTO mvn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aioi, itomi Parisi wayahimia! Dewa‑yaiyai ananina potapotami. Iuna yami nuanua ananina tomotau idudueyemi. Wayahina, yami dewa vivane tuta tuta pai manuena naona pai nau‑hohona nihenina uepepei idudueyemi. Ka kadue yami nuanua maketi wayahina tomotau inau‑kaiwemi iuna ami wava ananina. ");
INSERT INTO mvn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aioi, itomi Parisi wayahimia! Ika! Dewa‑yaiyai ananina potapotami. Itomi vivane unuvovo hivahivana deina, ka mani tomotau eha tꞌ‑anamane itomi tanopi nihenina umamaei. Wayahina, ini‑awana hetamia, ivo‑dadanimi, e ivi‑gawagawami, kate eha itꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ka veimea a tau nua‑uya aitam vonei, ivona, “Tau Viwavenena, yam vonana wayahina kadu eapa‑goyogoyoeai!” ");
INSERT INTO mvn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ka Iesu vona‑nau‑pata, ivona, “Kadu aioi, itomi veimea a tau nua‑uya wayahimia! Dewa‑yaiyai ananina kadu potapotami. Iuna dewa vitana tomotau uvi‑avanai veimea wayahina, kate vita‑naia eha una‑ivaite, eha aitam aviani udedewe wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aioi wayahimia! Iuna tau apa‑taputapu nonova imamaei ai unuvovo uyoneyonei tomotau mataia, kate amamami ivunu‑neiei. Ka nuami nihenina tau apa‑taputapu‑naia yai nau‑wahe wayahimia uvihahaiei. ");
INSERT INTO mvn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wayahina, yami dewana viwaveneka amamami yai dewa uawaehei vivane dewa ahiahina. Amamami tau apa‑taputapu ivunuvunui, kadu itomi yai nau‑wahe ubou‑potei yawaimi wayahina, e ai unuvovo uyoneyonei deinake. ");
INSERT INTO mvn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yaubada ya nua‑uya ani‑vainena, ka nonova tauna ivona deinake, ‘Yauke tau apa‑taputapu kadu tau hae avi‑tunei iomomo yau tomotau wayahia. Kate yau tomotau tupwai inau‑vi‑anigi‑neiei, kadu tupwai idewa‑yaiyai‑neiei.’ ");
INSERT INTO mvn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ka tanopi a vevewana ana tuta a itoava tuta ataina wayahina, tomotau Yaubada ya tau apa‑taputapu ivunu‑neiei, kadu dayahi itaina iopu. Wayahina, apaina vitana matana ana tuta wayahina, Yaubada taumi dewa‑yaiyaiemi yami dewa goyo‑naia wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nonova Abeli dayahina itaina iopu iuna vaneina tauna vunui. Ka munia, Sekaria dayahina itaina iopu, iuna tomotau ivunui pai vi‑nomu a pai vi‑ai ka Manua Vito‑pota niwania. Ika, avona‑havinemi, apaina dewa‑yaiyai uvaniahei tau apa‑taputapu‑naia habuhabui dayahi wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ia! Itomi, veimea a tau nua‑uya habuhabumi, aioi wayahimia! Iuna Yaubada ya nua‑uya a pai yavuha uhivehivei tomotau wayahia. Itomi nua‑uya a etawana uvihahaiei. Ka tupwai tomotau yai nuanua nua‑uya a etawana ivaniahei, kate yami dewa vivane tomotaui ubou‑potai.” ");
INSERT INTO mvn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ka tutana Iesu manua‑nana ni‑tawanei, Parisi ka veimea a tau viwavenena ivi‑vonavona ananina ya vonana wayahina. Iapa‑goyogoyoei, ka ivi‑putu yai vi‑tanai wayahina inau‑dadani. ");
INSERT INTO mvn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iuna yai nuanua ya vona‑nau‑pata nihenina dewa goyona ivaniahe, e munia ipoyꞌ‑avini, idewa‑yaiyaie goyo‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ka tuta aitamoata wayahina yoko ani‑vainena inau‑hohona Iesu wayahina. Taui ai yau ani‑vainena. Aituhu katana‑vewani gwau habuhabui wayahia, gwau aitamoata aitamoata wayahia ai yau 1000. Ka taui ivitu‑voivoi‑onei, ka kadu iva‑taunei. Ka naona Iesu ipupu tauna a tau vi‑muni‑waiwai ai yau 12 wayahia, ka ivona, “Udune‑vivinimi ahiahina. Me Parisi yai dewa habuhabuna vivane vitupu, kadu dewa viam‑nonona! Eha udedewe deina. Yai viwavenena palaua a pai vo‑vi‑nata deina. Iuna yai viwavenena kikituna ana pata yawaimi vi‑goyoi ananina. ");
INSERT INTO mvn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tuta ataina taui yai vitupu ihivehivei, ka apaina Yaubada yai dewa aitamoata aitamoata si‑vinꞌ‑omanei matakaia kadudueyei vivane goyona. ");
INSERT INTO mvn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kadu aituhu aviani novanovana nihenina uvoneyei, uhivehivei, apaina auyewa nihenina tomotau habuhabui yami vonana inononi, inꞌ‑anamanei. Kadu aituhu aviani wayahina uvi‑awa‑yaya yami manua nihenina, apaina ihae‑yavunei, e tomotau habuhabui inononi etawana. ");
INSERT INTO mvn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yaiau, unononi avonemi. Tupwai tomotau manimanini, e taui yai dewa ininimi ivunui, inau‑vi‑anigimi. Eha nau‑wawanimi tomotau‑naia umatamataute. Taui yai bagibagi vi‑kutakuta. Iuna taui ai pata ininimi‑henai inau‑vi‑anigi, kate eha ai pata nuami ivita‑vovoni. ");
INSERT INTO mvn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka avonemi, nau‑wawanimi Yaubada umatamatautei. Iuna tauna ya bagibagi eha vi‑kutakuta. Ataina ana pata ininimi na‑vunui, kadu apaina ana pata nuami na‑haponei ai ananata a meagai nihenina. Vona ahiahina, nau‑wawanimi Tauna umatamatautei. ");
INSERT INTO mvn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kwakwagonu patana aviani? Eha ananina. Kadi ai yau 5 kavi‑maiei toea ainuata deina. Manua taina kikituna, ka Yaubada eha aitam wayahia vi‑nua‑pani. ");
INSERT INTO mvn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kadu Yaubada avaha apanami aitamoata aitamoata ununumi wayahina iaiavi‑yehai kadu nuani. Iuna tauna dune‑nuanuaiemi. Wayahina, eha nau‑wawanimi tomotau umatamataute. Iuna tomotau aitamoata kwakwagonu habuhabui vane‑tawanei Yaubada matana. ");
INSERT INTO mvn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ka aituhu aviyaivia tanopia tomotau mataia iawaehei yauke, Tauna Vi‑tomotau, vivane ai niam, apaina wahuma yauke Yaubada yanꞌ anelose mataia anꞌ‑awaehei vivane taui yaiau, ka kadu yauke anꞌ‑apa‑vidovidohei yai dewa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ka aituhu aviyaivia tanopia tomotau mataia itana‑tavuneu, apaina wahuma yauke Yaubada yanꞌ anelose mataia atana‑tavunei. ");
INSERT INTO mvn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ka aituhu aviyaivia tanopia taua, Tauna Vi‑tomotau, imana‑giboeu o iapa‑goyogoyoeu, apaina kadi ana pata taui yai goyona tanoi wayahina nua‑piaha ivaniahei wayahi Yaubada wayahina. Kate aituhu aviyaivia tanopia Nuana Ahihinata iapa‑goyogoyoei, apaina eha ana pata taui nua‑piaha ivaniahe dewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ka apaina aituhu tomotau iyohonimi, itainimi manua tapanono wayahina, ka aituhu inau‑dadanimi yai vi‑tanai wayahia, eha nau‑wawanimi umatamatauta yami ipupu‑tana‑pota wayahina, ka eha nau‑wawanimi umai‑nuani. ");
INSERT INTO mvn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iuna apaina auyewana wayahina Nuana Ahihinata na‑ivaitemi, ka tauna yami vona viwavenemi, aviani nau‑wawanimi unau‑pata tunutunuhina wayahiu.” ");
INSERT INTO mvn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ka aitam onoto yokoia wayahina vi‑honei, ivona, “Tau Viwavenena, yauke ka vaneiu ama inua amai inusi, ka yau nuanua wamke vaneiu eveimeyei tauna amai yana gabu na‑tana‑vewani, e na‑vo‑patau.” ");
INSERT INTO mvn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ka Iesu onoto‑nana vona‑nau‑patei, ivona, “Yauke koiaka? Eha nau‑wawaniu avi‑tau vaneneha ami vo‑pata wayahina. Yau paisewa tunina.” ");
INSERT INTO mvn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Akaka tauna yokoia habuhabui nau‑vi‑avini, ivona, “Nau‑wawanimi itomi yami nuanua ananina udune‑vi‑avini ahiahina! Eha nau‑wawanimi tau kaikaiwabo ai gugua nuami iepepe. Iuna eha aka pata yawai‑hoika kavaniahe gugua habuhabuna wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ka Iesu aitam pai dune venei vona tana‑minikuna wayahina, ivona, “Aitam tau kaikaiwabo ya baguna ananina mamaei, ka bagunana nihenina aniani habuhabuna tabotabo, ka kadue aikayo ananina wayahina vaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akaka, onoto‑nana tauna ana heta nuanua, e vi‑nua‑dadana ivona, ‘Aikayo taina vivane ananina, ka yau anana eha ai pata. Aviani nau‑wawaniu adewei?’ ");
INSERT INTO mvn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ka nuanua iakwa, e tauna ana heta vonei, ivona, ‘Avaha anamanei. Nau‑wawaniu anana kikitui kadu tutuai taina abwege‑neiei ayavunei, ka anana vovoui kadu anani ayone‑neiei. E au aniani ka kadu yau gugua habuhabuna nihenia atotohi akanai. ");
INSERT INTO mvn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na‑iakwa, yau dewa‑haiawa nui au heta ana‑vona, “Akanai sinasinapu. Aitam tau kaikaiwabo yauke. Avaha avo‑vi‑aiai‑vavaha, ka yau kaikaiwabo habuhabuna au pata ponimana ai vi‑am iomomo wayahi. Wayahina, au pata yau paisewa habuhabuna abou‑ohoi, avi‑yawai, ka adewa‑haiawa deina. Iuna avaha au maꞌ ka au daudau habuhabuna au pata.” ’ ");
INSERT INTO mvn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ka Yaubada onoto‑nana vonei, ivona, ‘Taum mwagemwagem! Iuna ioyoma taina yawaim anꞌ‑epei, enꞌ‑aniga. Ka yam gugua‑naia avaha evi‑ai‑neiei wayahim, kaiwadi, ma‑putua koiaka ya gugua?’” ");
INSERT INTO mvn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ka Iesu ya vona tana‑minikuna iakwa, e pai nau‑yehata wayahina ivona, “Aituhu aviyaivia kaikaiwabo ai gugua wayahina ipaipaisewa, ka aituhu tanopia gugua‑naia igwaugwaui, kate tuta aitamoata wayahina aituhu eha yai nuanua Yaubada ya gugua igwaugwau wahuma, vona ahiahina, taui mwagemwagei!” ");
INSERT INTO mvn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Wayahina avonemi, eha nau‑wawanimi yami maꞌ tanopia unuanua toyoina! Eha nau‑wawanimi ami maꞌ o ami kwama wayahi unuanua toyoina! ");
INSERT INTO mvn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Iuna yawaika aniani vane‑tawanei, kadu ininika kwama vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aitam pai dune avenemi bwayobwayo wayahina. Unuani. Tuta habuhabuna eha ibagubaguna, ka eha iaiaikayo, ka kadu eha yai anana. Kate taui akanai. Iuna tuta habuhabuna Yaubada ai maꞌ vevewanei, ka awawaehina am‑veneneyei. Ka bwayobwayo eha aitam vevewana ananina Yaubada matana, kate itomi vevewana ananina matana. ");
INSERT INTO mvn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ka koiaka wayahimia yami nuanua toyoina wayahina ami pata yami tuta tanopia uvo‑vi‑manamanaia? Eha aitam wayahimia, a? ");
INSERT INTO mvn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ka dewana vivane dewa kikituna ka aitamoata. Aituhu itomi eha ami pata dewa kikituna aitamoata udewe, aviani iuna unuanua ananina dewa ananina habuhabuna wayahina? Nau‑wawanimi yami nua‑vita dewa‑naia habuhabui wayahi ubou‑ohoi. ");
INSERT INTO mvn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ka kadu aitam pai dune avenemi sisinai wayahina. Sisinai yai tabo unuani. Tuta habuhabuna eha ita‑paipaisewa, kadue eha ai kwama ita‑nau‑vevewane. Ka vona ahiahina, tuta nonova wayahina, Solomoni ana kwama kadu tauna a vaivana ai dune ahiahi, ka sisinai ai dune ahihi‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yaubada ya dune‑vi‑avina ahiahina wetau wayahina deina. Ka wetau eha vevewana ananina tauna matana. Iuna ataina wetau nau‑sisi, ka ma‑putua nau‑moewa, ka tomotau isi‑apui, ka ai ananata nihenina ihaponei, na‑iakwa. Ka itomi vevewana ananina tauna matana. Wayahina, aituhu Yaubada sisinai ai kwama venevenei, vona ahiahina, kadue nau‑wawanimi uvitumahanei ami kwama na‑venevenemi. O, taumi! Yami vitumahana vivane ihanuana. ");
INSERT INTO mvn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wayahina, tuta tuta eha nau‑wawanimi unuanua toyoina ami maꞌ, o ami daudau wayahi. Ugenuana. ");
INSERT INTO mvn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Me tanopi habuhabui, taui eha Yaubada itꞌ‑anamane, gugua tanoi wayahina inuanua toyoina. Ka aviani nau‑wawanimi, vona ahiahina, Yaubada avaha anamane‑yehai. ");
INSERT INTO mvn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dewa aitamoata nau‑wawanimi, vivane Yaubada ya pai veimea wayahina unuanua. Aituhu yami nuanua ya pai veimea uvaniahei, akanai tauna gugua habuhabui baina tanopia na‑venevenemi hetana. ");
INSERT INTO mvn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vona ahiahina, itomi Yaubada yana sipiV. Ka tauna ya dewa‑haiawa nui ya pai veimea nꞌ‑awaehemi. Wayahina, eha nau‑wawanimi umatamatauta. ");
INSERT INTO mvn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akanai yami gugua una‑imwaneyei, e kina‑naia tau payapayaya uvo‑pata‑neiei. E yami kode uvevewanei wahuma deinake, ka kode‑naia ina‑maꞌ‑vavaha. Iuna wahuma eha aitam tau vainau ana pata yam gugua na‑vainau, ka kadu wahuma ganagana eha ita‑mamae. ");
INSERT INTO mvn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nau‑wawanimi udedewei deina, iuna avi dewa wayahina unuanuani ananina, dewaia nuami iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Aituhu tuta habuhabuna uvo‑vi‑aiaimi, ka aituhu tuta habuhabuna yami Kauvea wayahina upaipaisewa, ka aituhu ami kwama paisewa wayahina uweteweteni, ka kadu aituhu yami lampaV wayahimia upotapota, akanai itomi tau sinasinapumi. ");
INSERT INTO mvn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Aituhu yami dewa deina, akanai itomi vivane tau paisewa yai kauvea ipotepotei deina. Tauna ine tavine anꞌ am ananina wayahina, ka ya tau paisewa ianamanei amna na‑iakwa, tuta eha ani‑hoina na‑iakwa wayahina, yai kauvea na‑mavina. Wayahina, taui ipotapota, idunedune ya mavina wayahina. Ka avi tuta tauna tutu‑keana, taui ivo‑kwayavoni, ka ya manua awana iwaei, na‑nui. ");
INSERT INTO mvn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ka avi tuta kauveana mavina, aituhu aviyaivia imimini, ipaipaisewa, taui patana ahiahina ivaniahei tauna wayahina. Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Apaina kauvea‑nana ana kwama ahiahina na‑boui, e paisewa ana kwama na‑weteni, e tauna ya tau paisewa nꞌ‑awaehei imanuena, e tauna vi‑tau paisewa taui wayahi, e aniani na‑omanei wayahia inꞌ‑am. ");
INSERT INTO mvn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kaiwadi, aituhu ya mavina vi‑kiwada tupwana, ya tau paisewa medeina? Avonemi, aituhu avi tau paisewa ipotapota, ipaipaisewa a itoava ya mavina wayahina, ioyoma pouna, o kaiwadi, avi tuta munia, apaina tau paisewa‑naia idewa‑haiawa tauna matana. ");
INSERT INTO mvn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ka kadu vona tana‑minikuna taina unuani. Aituhu aitam tau vi‑manua avaha anamanei tau vainau na‑omo ya manua wayahina, vona ahiahina, tau vi‑manuana nau‑wawani potapota kadu dunedune. E avi tuta tau vainau na‑omo, tau vi‑manuana ana pata bou‑potei, eha nꞌ‑awaehe na‑nu. ");
INSERT INTO mvn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wayahina, itomi nau‑wawanimi uvo‑vi‑aiaimi ahiahina aitamoata deina yau mavina ana tuta wayahina. Iuna apaina yauke, Tauna Vi‑tomotau, amavina. Kate eha aitam koiaka tꞌ‑anamane avi babau wayahina amavina.” ");
INSERT INTO mvn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wayahina, Pita vi‑tanaiei, ivona, “Kauvea, vona tana‑minikuna tanoi itoai ama heta wayahiaia evonavona, o kadi tomotau habuhabui wayahia?” ");
INSERT INTO mvn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ka Iesu ivona, “Aituhu aviyaivia tau paisewa ahiahina, apaina kauvea tomotaui vaniahai, e paisewa ananina na‑venei idedewei tauna wayahina ya manua nihenina. Ka taui yai paisewa vivane mani tau paisewa ai maꞌ ivo‑patai auyewa aitamoata aitamoata wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Apaina, avi tuta yai kauvea mavina wayahina, aituhu aviyaivia yai paisewa ipaipaisewei ahiahina, patana ahiahina ivaniahei kauveana matana. ");
INSERT INTO mvn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Vona ahiahina, apaina kauveana ya gugua ahiahina habuhabuna nꞌ‑awaehei wayahia, e taui guguaia iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kate aituhu aitam tau paisewa taui wayahia tauna ana heta nuanua, ‘Yau kauvea ine bana mamanaina, kadu vi‑kiwadi ananina. Wayahina, baina yauke yau nuanua adedewei,’ kaiwadi, apaina ya paisewa ni‑tawanei, ka vi‑putu mani tau paisewa vunuvunui, ka kadu ana maꞌ vo‑vi‑natei, kadu daudau bagibagina nimnim, ka nim‑kwavakwava. ");
INSERT INTO mvn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ka munia, avi tuta ya kauvea mavina, tau paisewa‑nana eha potapota, ka eha dunedune. Iuna, tauna eha auyewana, o babauna tꞌ‑anamane ahiahina. Wayahina, yauna na‑novo. Ka kauveana na‑omo, na‑poyꞌ‑avini, e hutana na‑upwa‑honoi, ka manuana upuna dewa‑yaiyaiei taui eha yai vitumahana nui. ");
INSERT INTO mvn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aituhu avi tau paisewa yai kauvea ya nuanua ianamanei ahiahina, kate aituhu eha ivo‑vi‑aiai, ka aituhu eha idedewe deina, apaina yai kauvea na‑dewa‑yaiyaiei ananina. ");
INSERT INTO mvn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ka aituhu avi tau paisewa eha yai kauvea ya nuanua itꞌ‑anamane vidoha, ka aituhu taui dewa goyona idedewei, apaina yai kauvea dewa‑yaiyaiei kikituna, eha ananina. Unononi. Aituhu aviyaivia dewa habuhabuna ivaniahei Yaubada wayahina, akanai taui ai veimea tauna wayahina kadu ananina deina. Ka aituhu aviyaivia ai vo‑pata ananina Yaubada wayahina, akanai taui nau‑wawani paisewa ananina idedewei deina. ");
INSERT INTO mvn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yauke aomo tanopia iuna yau nuanua ai ananata atunui, ka yau nuanua ananina ai‑nana avaha atunu‑yehai, ka ataina ananata. ");
INSERT INTO mvn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ka tuta eha ani‑hoina na‑iakwa wayahina, nau‑dadana vita‑vainena avaniahei, kadu viha ananina avaniahei a itoava nau‑dadana na‑iakwa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka itomi medeina unuanua yau paisewa wayahina? Kaiwadi, unuanua yau paisewa tanopia a pai mini ananina vivane nua gomagomanina tomotau wayahi aomane ivaniahe? Avonemi eha. Yau paisewa tanopia a pai mini ananina tau maꞌ tanopi atana‑vewani, vivane taui ivi‑nua‑dadaneu, o kadi taui ivihahaieu. ");
INSERT INTO mvn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tuta ataina a itoava auyewa pai nau‑yehata wayahina, aituhu manua aitamoata nihenina tomotau ai yau 5 imamaei, yoko tanoi atana‑vewani, ainua ka aitonu nui inau‑havia. ");
INSERT INTO mvn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","O kadi onoto a havia vivane natuna onotona, o kadi vavine ai havia vivane natui vavinena, o kadi vavine ai havia vivane nawai vavinena, ka havia‑naia ivi‑naua.” ");
INSERT INTO mvn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ka Iesu ya ipupuna tanoi a tau vi‑muni‑waiwai wayahia iakwa, ka tauna tomotaui yokoia wayahia ivona, “Aituhu avi tuta you nigenigena babau onuonu a papani ududueyei, avaha uanamanei ka uvonavona, ‘Apaina wei nꞌ‑atuna,’ ka vonana vona tunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","O kadi aituhu ponimanea yahina hunahuna, akaka uvonavona, ‘Ataina babau ananina kavaniahei,’ kadu vonana vona tunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ia! Itomi tau vitupu ananina! Iuna avaha tanopi a iaiaya uanamane‑yehai. Wayahina, itomi kadu ami pata iaiaya‑naia Yaubada venevenemi unꞌ‑anamane, kate uvihahaiei. Wayahina, eha uta‑nua‑hau iaiaya‑naia wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kaiwadi, aviani iuna itomi eha ami pata uvi‑nua‑dadana ahiahina? ");
INSERT INTO mvn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Unononi. Aituhu wamke am havia ya nuanua na‑tainim tau vaneneha matana vitana matana wayahina, wamke nau‑wawanim naona ami inua unꞌ‑awaehei uvidoha. Eha nau‑wawanim epotapota tau vanenehana ya vi‑nua‑dadana wayahina. Kaiwadi, aituhu tauna yam goyona vaniahei, apaina tauna ya tau nau‑havia veimeyei ipoyꞌ‑avinim, e manua yohona nihenina iyohonim, emamaei. ");
INSERT INTO mvn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aioi! Avaha dewana iakwa, eha aitam vona‑yavuha wayahim ta‑mamae. Am veimea manua yohona nihenina emamaei a itoava am aga habuhabuna enau‑pata‑yehai wayahina!” ");
INSERT INTO mvn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tuta‑nana wayahina tupwai tomotau iomo, ka Iesu wayahina iaipuipupu aitam dewa goyona wayahina, ivona, “Kauvea, me Galili tupwai iomo baina, ka ivivi‑nomu Yaubada wayahina Manua Vito‑pota nihenina. Ka Pilate tauna ya tau nau‑havia veimeyei tomotaui inau‑vi‑anigi, e dayahi yai vi‑nomu nui ivi‑nomui.” ");
INSERT INTO mvn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ka Iesu vonei, “Kaiwadi, unuanua me Galili‑naia tau goyogoyona ananina, ka dewana vivane iuna Yaubada yai aniga awaehei deina, a? ");
INSERT INTO mvn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kate avonemi eha. Yai aniga eha ta‑vinꞌ‑omo yai goyona wayahina! Kate vona ahiahina, aituhu itomi eha unua‑vinana yami dewa goyona wayahia, apaina kadu unꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ka medeina yami nuanua taui me Siloam ai yau 18 wayahia? Nonova manua mamanaina ipeu nau‑vunuvunui inusi ana noe. Kaiwadi, unuanua taui mani tomotau Ierusalem nihenina igoyo‑tawanei, ka dewana vivane iuna Yaubada yai aniga awaehei deina, a? ");
INSERT INTO mvn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kate avonemi eha. Yai aniga eha ta‑vinꞌ‑omo yai goyona wayahina! Kate vona ahiahina, aituhu itomi eha unua‑vinana yami dewa goyona wayahia, apaina kadu unꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ka kadu vona tana‑minikuna venei, ivona, “Aitam tau baguna ya baguna nihenina madaiba aitam mamaei. Ka tuta habuhabuna omomo ai‑nana wayahina, e ya nuanua uana nꞌ‑ai‑ponu, ka eha aitam tuta uana ta‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wayahina, tau bagunana ya tau dune‑vi‑avina honei, e vonei, ivona, ‘Avaha eanamanei, ponimana aitonu nihenia aomomo, e madaiba taina uana anꞌ‑ai‑ponu, ka eha aitam uana ata‑vaniahe. Ataina nau‑wawanim etana‑yavunei. Ka tano taina nihenina mani ai kabaguni.’ ");
INSERT INTO mvn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ka tau dune‑vi‑avina‑nana vona‑nau‑patei, ivona, ‘Bada, aituhu memeanina wayahima, ataina eha atana‑yavune. Ka ataina a itoava ponimana tepakaia wayahina adewa‑dadana adewa‑vidohei. Awaniana aikayo, kadu pai tabo wayahina abouboui, e apaina kadueyei. ");
INSERT INTO mvn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aituhu na‑ua, akanai mimini, o aituhu eha na‑ua, akanai, katana‑yavunei.’” ");
INSERT INTO mvn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aitam auyewa tapanono wayahina, tauna inu aitam manua tapanono nihenina, e tomotau viwavenei. ");
INSERT INTO mvn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ka aitam vavine imamaei, ka ponimana ai yau 18 nihenia nua gawagawamina inini nihenina mamaei, ka nua‑nana upui vi‑goyoi, ka yai venau iwaodu‑ohota deina, ka eha ai pata ita‑tunuha. ");
INSERT INTO mvn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ka tutana Iesu vavinena dueyei, honei, ka vavinena wayahia ivona, “Ataina ami kwanaha avaha iakwa, ayavuhimi uvidoha.” ");
INSERT INTO mvn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ka nimana boui, ka vo‑kwayavonina vavinena imini tunuhina, e Yaubada iawa‑davei. ");
INSERT INTO mvn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ka manua tapanono‑nana a tau dune‑vi‑avina avaha Iesu ya dewana dueyei, tauna nua‑goyo ananina wayahina. Iuna tauna nuanua aituhu Iesu auyewa tapanono wayahina kwanaha dewa‑vidohei, dewana vivane paisewa. Wayahina, onoto‑nana mini, ka yoko inau‑hohona mataedai, ivona, “Vona tunutunuhina, kanamanei veimea auyewa ai yau 6 nihenia awaeheka yaka paisewa kapaipaisewei. Akanai auyewa‑naia nihenia uomomo uvidoha, ka itomi tau kwanakwanaha eha nau‑wawanimi auyewa tapanono wayahia uomomo, uvidoha!” ");
INSERT INTO mvn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ka Iesu vonana nononi, ka habuhabui wayahia ivona, “Ia! Itomi tau vitupu ka tau viam‑nonona. Iuna auyewa tapanono aitamoata aitamoata wayahia itomi yami vahitau habuhabui uyavuyavuhi yai pai maꞌ wayahina, kadu uneiei vuvunaha ai daudau inimnim. ");
INSERT INTO mvn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka unuani. Vavine taina Abaraham yana yoko aitam, eha vahitau. Ka Satana yohoni ponimana mamanaina ai yau 18 nihenia. Ataina ayavuhi ividoha, ka dewana vivane dewa ahiahina, eha dewa goyona.” ");
INSERT INTO mvn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ka Iesu ya vonana iakwa, a havia habuhabui iaini‑yauyau, ka tomotau yoko idewa‑haiawa ananina tauna ya paisewa bagibagina wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ka yokoia wayahia kadu ivona, “Medeina Yaubada ya pai veimea avo‑vi‑mahetemi unua‑haui? Aviani wayahina abou‑viwave? ");
INSERT INTO mvn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yaubada ya pai veimea mata‑sinisinina utuna aitam deina, ka aitam onoto epei, e ya baguna nihenina baguni. E mata‑sinisinina itabo, e nata ananina, aitam ai deinake. Ka munia, manua iomomo, ka ai hiu nahana nihenia iyoneyonei.” ");
INSERT INTO mvn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ka vona‑havinei, ivona, “Aviani wayahina Yaubada ya pai veimea abou‑viwave? ");
INSERT INTO mvn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yaubada ya pai veimea palaua a pai vo‑vi‑nata tupwana deina, ka aitam vavine epei, ka palaua habuhabuna nui vinei. Pai vo‑vi‑nata eha habuhabuna, kate bagibagina. Wayahina, palaua habuhabuna inata.” ");
INSERT INTO mvn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tuta‑nana wayahina Iesu vanevane Ierusalem wayahina, ka etawana wayahina tauna meagai anani kadu kikitui omo vaniahei, ka meagai‑naia nihenia viwavenena kadu naunau‑wahe. ");
INSERT INTO mvn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka aitam onoto vi‑tanaiei, ivona, “Kauvea medeina? Apaina tomotau aitonuata ai heta yawai‑vavaha ivaniahei, o kadi tomotau habuhabuai avaniahei?” Ka Iesu vona‑nau‑pata, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nau‑wawanimi ubebebewa unuinu awa wayowayona wayahina. Iuna apaina tomotau habuhabui ibebebewa inuinu awa‑nana wayahina, kate eha ai pata, idewa‑wayohei. ");
INSERT INTO mvn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ka apaina aitam auyewa wayahina tau vi‑manua na‑mini, ka ya manua awana na‑gudui. Ka auyewana wayahina, pai nui ana tuta avaha iakwa, ka itomi upuna umimini. Ka ututu‑keakeana, ka kadu uviama, uvonavona, ‘Kauvea, awana ewaei, e anu‑mei.’ Kate tauna yami vonana na‑vona‑nau‑patei, e wayahimia na‑vona, ‘Eha atꞌ‑anamanemi.’ ");
INSERT INTO mvn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ka itomi unau‑patei, una‑vona, ‘Ika. Eanamaneai. Nonova nui kamam, kanimnim, kadu yama megeia eviwaveneai.’ ");
INSERT INTO mvn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kate tauna vonemi, na‑vona, ‘Ia! Habuhabumi una‑opu! Itomi tau goyogoyona eha atꞌ‑anamanemi!’ ");
INSERT INTO mvn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akaka vonana na‑iakwa, e udunedune, ka Abaraham, ka Isaki, ka Iakobo, ka kadu tau apa‑taputapu habuhabui taui nui ududueyei Yaubada ya pai veimea nihenina imamaei, ka itomi upuna umamaei. Wayahina, yami tou kadu yami nua‑vita ani‑vainena nui nihomi una‑uta‑vi‑anai, iuna tenoke wayahina ami viha ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ka apaina tomotau iomomo meagai habuhabui wayahia, ka papani habuhabui wayahia, e yai pai maꞌ ahiahina ivaniahei Yaubada ya pai veimea nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ka ataina tupwai tomotau ai wava kikituna, ka apaina auyewana wayahina, taui ai wava ananina. Ka kadu ataina tupwai tomotau ai wava ananina, ka apaina auyewana wayahina, taui ai wava kikituna.” ");
INSERT INTO mvn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka ya viwavenena tanoi iakwa, e tupwai Parisi iomo, ka Iesu ivonei, ivona, “Papani taina eni‑tawanei, ena‑novo. Iuna Erodi ya nuanua ananina na‑nau‑vi‑anigim.” ");
INSERT INTO mvn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka Iesu vona‑nau‑patei, ivona, “Una‑nei kedewa‑nana wayahina, ka uvonei avona taina deina, ‘Ataina kadu ma‑putua yau paisewa apaipaisewei, vivane nua gawagawamina tomotau wayahia aepa‑yavunei, kadu tau kwanakwanaha avo‑vi‑aiaiei ividoha. Ka auyewa vꞌ‑itonuna wayahina yau paisewa anau‑yehai.’ ");
INSERT INTO mvn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ka au veimea mamaei vivane ataina kadu ma‑putua wayahina aneine Ierusalem wayahina. Iuna tuta nonova a itoava tuta ataina wayahina, tau apa‑taputapu habuhabui ianianiga meagai Ierusalem nihenina. Ka kadu Ierusalem nihenina anꞌ‑aniga deinake. ");
INSERT INTO mvn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aioi, Ierusalem! Aioi, wayahimia! Iuna tuta nonova a itoava tuta ataina wayahina tau apa‑taputapu habuhabui unau‑vi‑anigi. Ka Yaubada tauna ya tau mataeda vi‑tunei iomomo wayahimia, ka aitamoata aitamoata wayahia ututu‑hanuhanui. Ka tuta habuhabuna wayahina yauke yau nuanua ananina ahonemi, unau‑hohona wayahiua, kamkam vavinena natunatui papeia ibou‑potapotai deina, kate uvihahaieu! ");
INSERT INTO mvn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wayahina, ataina itomi payapayaya, iuna uvihahaieu. Ka vona ahiahina avonemi, apaina eha ami pata udune‑havineu. Aituhu avi tuta una‑vona, ‘Kaiwa ananina tauna ya nau‑iaiava nui Yaubada a wavea omomo wayahiaia,’ vona ahiahina, auyewana wayahina udune‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aitam tapanono wayahina Iesu omo am wayahina aitam tau veimea ya manua nihenina. Ka tau vi‑manua‑nana aitam Parisi. Ka tupwai Parisi yai yoko nui imamaei, ka taui Iesu idune‑vi‑anai, iuna yai nuanua Iesu ya dewa goyona ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka avaha ianamanei aitam tau kwanakwanaha nui imamaei, ka nimana ka aena nononei. Ka tau kwanakwanahana Iesu matana mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Wayahina, Iesu ya vi‑tanai Parisi yai yoko wayahia, kadu veimea a tau anamana wayahia deina, ivona, “Medeina unuanua? Aka veimea awaeheka tomotau kavo‑vi‑aiaiei ividoha auyewa tapanono wayahina, o kadi veimea dewana vito‑potaka?” ");
INSERT INTO mvn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ka taui eha ita‑nau‑pate ya vi‑tanai‑nana wayahina. Wayahina, Iesu tau kwanakwanahana tana‑wapia, ka a kwanaha vo‑vi‑aiaiei. Akaka vi‑tunei ine ya megeia. ");
INSERT INTO mvn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iakwa, e Iesu magigino Parisi wayahia, e vonei, ivona, “Itomi yami dewa medeina? Aituhu aitam natunatumi ipeu gubana auyewa tapanono wayahina, nau‑wawanimi uvo‑kwayavoni una‑ivaitei, utaini, a? O aituhu aitam yami vahitau, aseV deina, o bulumakauV, ipeu gubana auyewa tapanono wayahina, kadu nau‑wawanimi uvo‑kwayavoni una‑ivaitei, utaini, a?” ");
INSERT INTO mvn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ka eha aitam Parisi taui yai yoko wayahia ana pata na‑nau‑pata Iesu ya vonana wayahina. Iuna avaha ianamanei yana vona vivane tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ka am‑nana nihenina Iesu tupwai tomotau yai dewa dueyei, vivane tuta tuta yai nuanua pai manuena ahiahina wayahina imanuena, ka yaiai pai manuena goyona wayahina imanuena. Wayahina, aitam vona tana‑minikuna venei, e viwavenei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Aituhu aitam koiaka honem pai am kanibutu wayahina, eha nau‑wawanim ena‑vane pai manuena ahiahina tomotau mataia wayahina, e tau toniwaga kanibutu nepena emanuena. Iuna eha etꞌ‑anamane‑vidoha. Kaiwadi, munia, aitam onoto ananina na‑omo, ka aituhu tauna ana wava wamke am wava vane‑tawanei, aviani edewei? ");
INSERT INTO mvn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tuta eha ani‑hoina na‑iakwa wayahina, e tau toniwagana kanibutu veimeyem ena‑novo, e tauna onoto ananina nꞌ‑awaehei nepena na‑manuena, ka taum ena‑opu pai manuena ononotoi vovoui wayahia, ka ini‑yauyau evaniahei tomotau habuhabui mataia deinake. ");
INSERT INTO mvn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wayahina, aituhu aitam koiaka honem kanibutu wayahina, nau‑wawanim pai manuena pai nau‑yehata evi‑nua‑dadani wayahim, eha pai manuena naona. Ka munia, aituhu tau toniwaga kanibutu vaniaham, e tauna vonem, ‘O, au niau, kaiwa ananina! Emini ena‑vane pai manuena ahiahina nepeua.’ Ka yam dewa‑haiawa nui awa‑vidovidoha evaniahei tomotau habuhabui mataia deinake. ");
INSERT INTO mvn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Avonemi deina iuna aituhu aviyaivia inua‑vane, apaina ini‑yauyau ivaniahei mani tomotau mataia. Kate aituhu aviyaivia inua‑opu, apaina awa‑vidovidoha ivaniahei mani tomotau mataia.” ");
INSERT INTO mvn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Vonana iakwa, e Iesu tau vi‑manua‑nana honei, e vonei, ivona, “Aituhu avi tuta am‑kavokavovo ananina, o am‑kavokavovo kikituna enau‑vevewanei, eha nau‑wawanim yaiam, o vavaneim, o yam tomotau, o tau kaikaiwabo ai heta ehonehone iomomo am‑naia wayahia. Iuna apaina taui ihonem ka tanopia inau‑patam na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kate avonem, aituhu avi tuta aniani enau‑vevewanei, nau‑wawanim taui payapayayai, ka tau bwanubwanui, ka tau penapena, ka kadu tau mata‑goyogoyo ehonehonei iomomo, e nui uamam. ");
INSERT INTO mvn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Baina tanopia taui eha ai pata ina‑nau‑patam. Wayahina, apaina, auyewana tau tunutunuhina imini‑havine wayahina, akanai Yaubada ana heta na‑nau‑patam yam dewa ahiahina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ka aitam onoto nui iamam avaha Iesu ya vonana nononi, e tauna Iesu vonei, ivona, “Aituhu aviyaivia ai pata inu Yaubada ya pai veimea nihenina, ka aituhu Yaubada awaehei nui iamam, akanai tomotaui nau‑iaiava ananina ivaniahei deina.” ");
INSERT INTO mvn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wayahina, Iesu onoto‑nana ya vonana vona‑nau‑patei aitam vona tana‑minikuna wayahina, e ivona, “Aitam tuta onoto ananina aitam aniani nau‑vevewanei, e tomotau habuhabui honei inꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ka avaha ya tau paisewa aniani ivo‑vi‑aiaia, tauna ya tau mataeda vi‑tunei ine tomotaui wayahia, e mataedai deina, ‘Unꞌ‑omo, ka aninina unꞌ‑am. Iuna avaha ivo‑vi‑aiaia, ka tauna potapotami.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kate habuhabui ivona ikoi. Wayahina, mani vona ka mani vona ivonevonei. Aitam wayahia tau mataeda‑nana vonei, ivona, ‘O, ataina yauke tano vovouna avi‑maiei, ka nau‑wawaniu ataina ana‑ne, e tano‑nana adueyei medeina. Wayahina, eha au pata aninina wayahina anꞌ‑omo.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ka kadu aitam wayahia tau mataeda‑nana vonei, ivona, ‘O, ataina yauke bulumakauV ai yau 10 avi‑maiei, ka nau‑wawaniu ataina ana‑nei, e apaisewa‑dadani. Wayahina eha au pata anꞌ‑omo.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ka kadu aitam wayahia tau mataeda‑nana vonei, ivona, ‘O, ataina yauke vovou atavine. Wayahina eha au pata anꞌ‑omo.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Wayahina, tau mataeda‑nana mavina ya kauvea wayahina, ka mataedei, ivona, ‘Bada, habuhabui ivona ikoi. Eha yai nuanua.’ Ka kauvea‑nana nua‑goyo. Wayahina, tauna ya tau mataeda‑nana vonei, ivona, ‘Evisina ena‑ne meagai ananina a etawana aitamoata aitamoata wayahia, ka aituhu aviyaivia evaniahai, akanai tomotaui ehonei eomane‑neiei baina aninina wayahina, vivane tau payapayaya habuhabui, ka tau penapena habuhabui, ka tau mata‑goyogoyo habuhabui, ka kadue tau ae‑goyogoyo habuhabui ehonei inau‑hohoni inꞌ‑am.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Akaka ya tau mataeda‑nana ine dewei deinake, ka munia mavina omo ka ivona, ‘Bada, avaha tomotau‑naia ahonei iomoi, ka yam manua eha ita‑nau‑vi‑anai. Pai manuena tupwai imamaei ataina.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wayahina, kauvea‑nana kadu ivona, ‘Ena‑ne meagai kikitui wayahia, ka etawana aitamoata aitamoata nihenia enaunau‑nene, ka aituhu aviyaivia edueyei, enau‑vi‑nehanehai inꞌ‑omo aninina wayahina. Iuna yau nuanua yau manua inau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ka vona ahiahina, tomotaui naona ahonei, eha aitam wayahia nui anꞌ‑am. Iuna taui ivihahaieu.’” ");
INSERT INTO mvn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ka aitam auyewa wayahina yoko ananina ivi‑muniei. Wayahina, Iesu magigino, e yokoia vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Aituhu aviyaivia wayahimia yami nuanua uvi‑muni‑waiwaieu, akanai taumi nau‑wawanimi yami dune‑nuanuai wayahiu yami dune‑nuanuai mani tomotau wayahi vane‑tawanei. Ka aituhu amamami, o ayoyomi, o awawami, o natunatumi, o vavaneimi, o novunovumi, o kadi itomi yawaimi udune‑nuanuaiei ananina, eha ami pata uvi‑muni‑waiwaieu. Aituhu yami nuanua uvi‑muni‑waiwaieu, akanai nau‑wawanimi taua au heta udune‑nuanuaieu ananina. ");
INSERT INTO mvn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ka aituhu avi vita, o avi viha avenemi uvihahaiei, taumi eha ami pata uvi‑muni‑waiwaieu. Ka aituhu yami nuanua uvi‑muni‑waiwaieu, akanai nau‑wawanimi yawaimi habuhabuna unꞌ‑awaeheu a itoava yami aniga wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yami vi‑nua‑dadana tanoi wayahiu abou‑viwavei deina. Aituhu aitam wayahimia yam nuanua manua mamanaina eyonei pai dune‑vi‑avini wayahina, naona nau‑wawanim emanuena, ka enuanua tunuhina yoana patana wayahina. Iuna aituhu patana eha wayahima, akanai eha nau‑wawanim evi‑putu manua‑nana eyoneyone. ");
INSERT INTO mvn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aituhu patana eha wayahima, ka aituhu evi‑putu eyoneyone, apaina tomotau ivinepam, ivi‑waipoem. Iuna wamke eha am pata yam manua enau‑yehai. ");
INSERT INTO mvn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ka tomotaui yai pai vinepa wayahina ivonavona, ‘Ia! Onoto taina udueyei vivane mwagemwagena. Iuna tauna vi‑putu ya manua yoneyone, ka eha ana pata na‑nau‑yehai.’ ");
INSERT INTO mvn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ka aitamoata deina, aituhu aitam kiniV ya nuanua tauna a havia vi‑nauei, tauna nau‑wawani naona manuena ka nuanua tunuhina ya tau nau‑havia ai yau wayahina. Ka aituhu ya tau nau‑havia ai yau 10,000 ka aituhu a havia ya tau nau‑havia ai yau 20,000, akanai eha nau‑wawani havia‑nana vi‑putu ivi‑naua. Iuna a havia bagibagi‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tauna eha ana pata na‑vane. Wayahina, tauna nau‑wawani tuyeha ya tau mataeda na‑venei, vi‑tunei ine a havia bana mamanaina wayahina. Ka nau‑wawani tuyehana nihenina a havia viamei aituhu memeanina taui wayahia, tuta gomagomanina inꞌ‑awaehei, eha ivi‑naua. ");
INSERT INTO mvn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wayahina avonemi deina. Aituhu yami nuanua uvi‑muni‑waiwaieu, akanai taumi nau‑wawanimi naona umanuena, ka unuanua tunuhina patana wayahina. Nau‑wawanimi naona yami gugua habuhabuna, kadu yami nuanua habuhabuna uni‑tawanei, e munia ami pata uvi‑muni‑waiwaieu. Aituhu eha ami pata deina, eha nau‑wawanimi uvi‑putu uvi‑munieu. ");
INSERT INTO mvn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hawana a uta‑dadana ahiahina aniani wayahina. Ka aituhu hawana bagibagina iakwa, eha ana pata aniani na‑vo‑vi‑aiai. A paisewa avaha iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka itomi nau‑wawanimi hawana goyona uhapone‑kavokavovo tanopia, haina deina. Aituhu aviyaivia yai nuanua vonana inononi, akanai yau nuanua ina‑nua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aitam auyewa wayahina takesiV a tau vitua tupwai, kadu tau goyogoyona tupwai iomo Iesu wayahina, e yoko ainua yai nuanua tauna ya nau‑wahe inononi. ");
INSERT INTO mvn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka Parisi yai yoko, kadu veimea a tau viwavenena tupwai inau‑vonuvonu dewana wayahina, ivonavona, “Ia! Onoto taina onoto goyona. Iuna tauna tau goyogoyona vi‑yaiana‑neiei, kadu nui iamam!” ");
INSERT INTO mvn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wayahina, Iesu yai vonana nau‑patei aitam vona tana‑minikuna wayahina, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Aituhu aitam wayahimia yam sipiV ai yau 100 imamaei, ka aituhu aitam wayahia ni‑tupa, medeina edewei? Vona ahiahina, nau‑wawanim sipiV ai yau 99 ai pai maꞌ nihenina eni‑tawanei, ka sipinaV vivino‑panina enaunau‑nene wayahina a itoava evaniahei wayahina, a? ");
INSERT INTO mvn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ka aituhu evaniahei, yam dewa‑haiawa nui eavanei, ");
INSERT INTO mvn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","emavi megeia. Ka yaiam ehonei, inau‑hohoni, e evonei, ena‑vona, ‘Yaiau, nui kadewa‑haiawa! Iuna avaha sipinaV vivino‑panina avaniahei!’ ");
INSERT INTO mvn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aituhu avi tuta tau goyogoyona aitamoata nua‑vinana, vona ahiahina, tau maꞌ wahuma idewa‑haiawa ananina dewana wayahina. Ka aituhu tomotau ahiahina ai yau 99 imamaei, ka aituhu eha nau‑wawani inua‑vinana, tau maꞌ wahuma eha idewa‑haiawa ananina dewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kadu deinake, aituhu aitam vavine yai kina ai yau 10 imamaei, ka aituhu aitamoata maiova, medeina idewei? Vavinena nau‑wawani lampaV ina‑tunu, ka yai manua habuhabuna na‑nau‑hinihinia, kadue inaunau‑nene ahiahina wayahina a itoava ivaniahei wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ka avi tuta ivaniahei, yai dewa‑haiawa nui yaiai kadue taui nepeia imamaei ihonei, inau‑hohona, ka wayahia ina‑vona, ‘Yaiau, nui kadewa‑haiawa. Iuna avaha yama kina maimaiovina avaniahei!’ ");
INSERT INTO mvn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ka vona ahiahina avonemi, aituhu tomotau aitamoata nua‑vinana, Yaubada yanꞌ anelose idewa‑haiawa ananina dewana wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ka Iesu kadu aitam vona tana‑minikuna nau‑viviwavei, ivona, “Aitam kauvea natunatuna ononotoi ainua nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka aitam auyewa wayahina natuna nepena omo amana wayahina, ka vonei, ivona, ‘Amau, nuanuau ataina tuta au tana‑vewana yam gugua habuhabuna, ka yam tano wayahina eveneu.’ Wayahina, kauveana ya gugua habuhabuna tana‑vewani natunatuna wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka auyewa tupwai iakwa, nepena yana tano imwaneyei, ka kina‑naia habuhabui vaniahei totohi, ka ya gugua vo‑vi‑aiaia, e ni‑tawanei ine bana mamanaina mani papani wayahina. Ka tenoke dewa‑kavokavovo, ka yana kina vꞌ‑iakwani. ");
INSERT INTO mvn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ka avaha habuhabuna iakwa, awakabina mamaei. Ka tuta tanoi wayahina am navovo ananina papani‑nana wayahina vinꞌ‑omo, ka onoto‑nana eha ana maꞌ. ");
INSERT INTO mvn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wayahina, naunau‑nene paisewa wayahina, ka aitam meagai a kauvea vaniahei, ka kauveana vi‑tunei omo yana pono na‑dune‑vi‑avini. ");
INSERT INTO mvn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ka onoto‑nana am navovo ananina, ka ya nuanua pono ai maꞌ nꞌ‑am. Iuna eha aitam koiaka papani‑nana nihenina ana maꞌ ta‑venevene. ");
INSERT INTO mvn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ka aitam tuta wayahina nua‑vinana, ka ana heta wayahina ivona, ‘Aioi! Vona ahiahina, amau ya tau paisewai ai maꞌ ananina, kate yauke taua baina am navovo vunuvunu. ");
INSERT INTO mvn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wayahina, amini ana‑ne amau wayahina, ana‑vona, “Amau, avaha agoyo Yaubada wayahina, ka kadu wamke wayahima. ");
INSERT INTO mvn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wayahina, eha nau‑wawaniu evi‑wahaniu natum. Aituhu memeanina wayahim, enꞌ‑awaeheu avi‑tau paisewa wayahim.” ’ ");
INSERT INTO mvn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ka onotona nuanua deina, wayahina mini, e amana wayahina ine. Ka enoma amana dueyei etawana omomo. Ka yanꞌ ate‑nuanuai nui nau‑bwanunua wayahina, e tana‑wapia, ka nau‑kaiwei, e maoi. ");
INSERT INTO mvn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wayahina, natuna amana vonei, ivona, ‘Amau, avaha agoyo Yaubada wayahina ka kadue wamke wayahima. Eha nau‑wawaniu evi‑wahaniu natum.’ ");
INSERT INTO mvn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kate amana ya dewa‑haiawa nui ya tau paisewa honei, e wayahia ivona, ‘Uvisina, e au kwama ahiahina unꞌ‑omanei, ka natu taina uvi‑weteni, kadu mwani aitam unꞌ‑omanei, e nimana uvaivani, kadu ae‑yapayapana uvenei, na‑weteni. ");
INSERT INTO mvn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka munia, una‑ne, e bulumakauV tupunaina ka binabinana uvunui, kadu aniani ananina nui uvo‑vi‑aiaia. E habuhabuka nau‑wawanika nui kadewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iuna nonova natu taina aniga deina, ka ataina yawayawaina kavaniahe‑havinei!’ Ka yai dewa‑haiawa nui ivi‑putu ikanibutu. ");
INSERT INTO mvn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ka tuta aitamoata wayahina natuna unu‑tauna baguna nihenina paipaisewa. Ka avaha ya paisewa nau‑yehai, etawana wayahina megeia mavimavina, e inava putuna ka aheahe ainua nononi, kadu tomotau itavotavona nononi. ");
INSERT INTO mvn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wayahina, aitam yai tau paisewa honei, e vi‑tanaiei, ivona, ‘Aviani iuna ataina idewa‑haiawa deinake?’ ");
INSERT INTO mvn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka tau paisewana ivona, ‘Vaneim yawayawaina ka ahiahina avaha mavina, ka amam veimeyeai bulumakauV tupunaina ka binabinana avunui, e nui kadewa‑haiawa. Iuna natu‑nana vaniahe‑havinei.’ ");
INSERT INTO mvn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ka avaha unu‑tauna vonana nononi, tauna nua‑goyo ananina. Wayahina, eha nuanuana manua na‑nui, kate upuna mamaei. Wayahina, amana iopu natuna unu‑tauna wayahina, ka viamei vivane ainua ina‑nu manua. ");
INSERT INTO mvn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka unu‑tauna ivona, ‘Eha‑ohota! Ai vi‑am ponimana nihenia avaha wayahim apaipaisewa, tau paisewa‑kavokavovo deinake? Ka kadu au veimea aitamoata aitamoata wayahima avi‑muniei, avi‑ateteyei. Ka eha aitam tuta eta‑dewa‑vidovidoheu! Eha aitam gotiV kikituna etꞌ‑awaeheu, e yaiau nui ata‑dewa‑haiawa! Eha aitam. Eha‑ohota! ");
INSERT INTO mvn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kate natum taina avaha tau kenekenene vaivine nui yam gugua habuhabuna nau‑yavuyavunei. Ka ataina mavina, ka yam dewa medeina? Yaka tau paisewa eveimeyei bulumakauV tupunaina ka binabinana ivunui wayahina, a?’ ");
INSERT INTO mvn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ka kauveana natuna unu‑tauna wayahina ivona, ‘Natu, avaha eanamanei, tuta habuhabuna nihenina aka inua nui kamamaei, kadue avaha eanamanei, avaha yau pai veimea habuhabuna nimama aboui eveimeyei. ");
INSERT INTO mvn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kate yau dewana tunutunuhina, ka kadu nau‑wawanika kadewa‑haiawa deinake. Iuna nonova taim aniga deina, ka ataina tuta yawayawaina kavaniahe‑havinei. Nonova tauna vivino‑panina, kate ataina avaha mavina.’” ");
INSERT INTO mvn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu kadu vona tana‑minikuna taina a tau vi‑muni‑waiwai vonei, ivona, “Aitam tau kaikaiwabo mamaei, ka tauna tau aimwane aitam. Ka ya tau paisewa aitamoata ya paisewa kadu yana kina habuhabuna veimeyei kadu dune‑vi‑avini. Ka aitam tuta wayahina tupwai tomotau vane iomanei tau kaikaiwabo‑nana wayahina, ivona, ‘Bada, yam tau dune‑vi‑avina‑nana yam guguaia wayahia dewa‑kavokavovoei.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wayahina, tau kaikaiwabo‑nana ya tau dune‑vi‑avina honei ka vonei, ivona, ‘Avaha dewa goyona wayahim anononi. Ka yau nuanua aviani ededewei yau kina aitamoata aitamoata wayahina anꞌ‑anamanei. Wayahina, nau‑wawanim yam dewa eginumi eveneu adueyei. Na‑iakwa, ena‑opu. Iuna yam paisewa wayahiu avaha iakwa.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Akaka tau dune‑vi‑avina‑nana nuanua, ka ana heta wayahina ivona, ‘Aioi! Ataina medeina adewe avidoha? Iuna yau kauvea avaha vihahaieu. Eha yau bagibagi, wayahina eha memeanina wayahiu abagubaguna. Ka aituhu ana‑omo tomotau wayahia, e aniani aviame, ini‑yauyau avaniahe deinake. ");
INSERT INTO mvn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Avaha anamanei! Taina deina adewei, e apaina avi tuta eha yau paisewa, akanai yaiau habuhabui avaniahai ina‑ivaiteu.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wayahina, tau dune‑vi‑avina‑nana ya kauvea a tau vi‑aga habuhabui honei, e aitamoata aitamoata wayahia vinꞌ‑omo wayahina. Ka tauna onoto naona vi‑tanaiei, ivona, ‘Ai vi‑am am aga yau kauvea wayahina?’ ");
INSERT INTO mvn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ka onotona vona‑nau‑patei, ivona, ‘Au aga vivane gam bunama wayahina ai yau 100 aepei.’ Wayahina, tau dune‑vi‑avina‑nana ivona, ‘Buki taina nihenina am aga‑nana evo‑vinei, ai yau 50 ana heta eginumi.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ka onoto vꞌ‑inuana inui, e tau dune‑vi‑avina‑nana vi‑tanaiei, ivona, ‘Ka wamke medeina, ai vi‑am am aga yau kauvea wayahina?’ Ka vꞌ‑inuana nau‑patei, ivona, ‘Au aga vivane tegana ananina palaua wayahina ai yau 100 aepei.’ Wayahina, tau dune‑vi‑avina‑nana kadue ivona, ‘Buki taina nihenina am aga‑nana evo‑vinei, ai yau 80 ana heta eginumi.’ Ka tauna ya kauvea a tau vi‑aga habuhabui ai aga bou‑opuei deinake. ");
INSERT INTO mvn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ka munina kauvea‑nana ya dewana vaneana nononi, e awa‑vidovidohei, ivona, ‘O! Tauna ya nua‑uya ananina, wayahina dewei deinake.’” Ka vona tana‑minikuna tanoi iakwa, e Iesu vo‑vi‑mahetei, ivona, “Tau vi‑tanopi yai nua‑uya nui ibagibagi, idedewei ai heta wayahia deinake, kate Yaubada yana yoko eha yai nua‑uya nui deina. ");
INSERT INTO mvn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Wayahina avonemi, itomi nau‑wawanimi tanopi a gugua unꞌ‑am‑veneneyei, ka tomotau una‑ivaitei, e ivi‑yaianemi deina. Iuna apaina auyewa pai nau‑yehata omomoi, ka auyewana wayahina tanopi a gugua na‑iakwa. Ka auyewana wayahina Yaubada na‑nau‑kaiwemi, e pai maꞌ‑vavaha nihenina una‑nu, e umamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ka Iesu ya vo‑vi‑maheta neine, ivona, “Aituhu aviyaivia yai dewa tunutunuhina gugua aitonuata wayahina, apaina taui yai dewa kadu tunutunuhina gugua habuhabuna wayahina. Kadu aituhu aviyaivia ivitupu gugua aitonuata wayahina, apaina taui kadu ivitupu gugua habuhabuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wayahina, aituhu Yaubada tanopi a gugua venemi uveimeyei tanopia, kadue aituhu yami veimea eha tunutunuhina gugua‑naia wayahina, vona ahiahina, eha Yaubada ya nuanua wahuma a gugua na‑vo‑patami. ");
INSERT INTO mvn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka aituhu eha tauna ya gugua uveimeye ahiahina, vona ahiahina, apaina eha tauna ya nuanua itomi yami gugua na‑venemi, e ami heta uveimeye. Eha‑ohota. ");
INSERT INTO mvn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Vona ahiahina, tau paisewa eha ana pata vi‑tau paisewa kauvea ainua wayahia. Kaiwadi, apaina tauna kauvea naona vihahaiei, ka kauvea vꞌ‑inuana dune‑nuanuaiei, o kadi kauvea naona vi‑ateteyei, ka kauvea vꞌ‑inuana nau‑nikonikoiei. Wayahina, eha ami pata tuta aitamoata nihenina uvi‑tau paisewa Yaubada wayahina, kadu uvi‑tau paisewa kina wayahina. Nau‑wawanimi aitam uvi‑nua‑dadani, ka aitam uni‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ka tutana Parisi‑naia imimini nepena yana vona habuhabuna tanoi inononi, ivi‑putu Iesu ivi‑waipoei. Iuna taui kina nuanuai ananina. ");
INSERT INTO mvn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wayahina, Iesu Parisi‑naia vonei, ivona, “Itomi yami nuanua ananina yami dewa ana dune vivane ahiahina mani tomotau mataia. Kate Yaubada avaha yami dewa goyona ka maimaiovina nihenimia imamaei anamane‑yehai. Vona ahiahina, aviani tomotau nuai iepepei kadu iapa‑vidovidohei ananina, iuna ana dune ahiahina mataia, vona ahiahina, Yaubada dewaia nau‑nikonikoiei. ");
INSERT INTO mvn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tuta nonova a itoava Ioni Tau Bapitaiso yana tuta wayahina, Mosese ya veimea kadu tau apa‑taputapu yai iginuma yawaika iveimeyei. Ka Ioni Tau Bapitaiso yana tuta wayahina a itoava tuta ataina wayahina vane ahiahina Yaubada ya pai veimea wayahina anaunau‑wahei wayahimia, ka aituhu aviyaivia yai bagibagi, taui Yaubada ya pai veimea nihenina inu‑dadani. ");
INSERT INTO mvn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mosese ya veimea a bagibagi mamaei, kadu avonevonemi, veimeana habuhabuna vivane vona tunutunuhina, ka tuta tepakaia wayahina veimeana a bagibagi eha na‑ihanua. Ika, tuta tepakaia wayahina memeanina wahuma ka tanopi ina‑iakwa, ka Mosese ya veimea a iginuma aitamoata aitamoata eha ina‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wayahina, aituhu koiaka awana vaiobuei, e tavine‑tamana mani vavine wayahina, tauna avaha vi‑tau kenekenene, ka kadu aituhu koiaka vavine vaivaiobuna tavine, onoto‑nana kadue avaha vi‑tau kenekenene.” ");
INSERT INTO mvn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ka Iesu kadu aitam vona tana‑minikuna vonei, ivona, “Aitam tuta aitam tau kaikaiwabo ka aitam onoto ana wava Lasarusi ainua imamaei. Ka tau kaikaiwabo‑nana ana kwama lineniV ahihi‑vainei, ka kadue ana maꞌ habuhabuna ahiahina. Wayahina, auyewa aitamoata aitamoata nihenina tauna dewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka Lasarusi payapayaya ka gonigoniana. Wayahina, yaiana iomanei, e tau kaikaiwabo ya manua mataetana iboui, e mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ka avi tuta Lasarusi tau kaikaiwabo‑nana ana maꞌ kamukamumuna tupwana vaniahei, akanai tauna amam, e dewa‑haiawa. Ka tuta habuhabuna kedewa ivinꞌ‑omo, e Lasarusi a gonia itaumi‑neiei. ");
INSERT INTO mvn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ka aitam auyewa Lasarusi yana tuta iakwa, ka anelose ivinꞌ‑omo itaini iomanei Abaraham nepena iboui, vivane tau tunutunuhina yai papani wayahina. Ka munia, tau kaikaiwabo‑nana kadue aniga, e unuvovoa iboui. Ka apaina tauna iopu tau goyogoyona yai papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka tenoke papani HadesiV nihenina a dewa‑yaiyai vaniahei vivane viha‑vainena. Ka dune‑vane, e bana mamanaina wayahina Abaraham dueyei, ka Lasarusi nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wayahina, tau kaikaiwabo‑nana vi‑hone ananina ka viama, ivona, ‘Aioi! Amau, Abaraham! Kaiwa ananina, enꞌ‑ate‑nuanuaieu, e Lasarusi evi‑tunei na‑opu wayahiua, e nima‑tabona wayahina daudau tutumina bunuva wayahina meau vi‑bigei. Iuna papani taina wayahina ai yabeyabena nihenina viha‑vainena avaniahei.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akaka Abaraham vona‑nau‑patei, ivona, ‘Eha. Natu, enuani. Nonova tanopia yawaim habuhabuna dewa‑haiawa ana noe, ka Lasarusi eha aitam pai dewa‑haiawa ta‑vaniahe, ka tauna viviha. Ka ataina tuta tauna ya dewa‑haiawa vaniahei, mamaei, ka wamke eviviha. ");
INSERT INTO mvn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kadue niwanikaia bebega ito‑niuna mamaei, ka tana‑vewanika. Wayahina, eha ama pata wayahimia aubo‑tamana, kadue eha ami pata wayahiaia uaubo‑tamana. Akanai kamamaei deinake.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ka tau kaikaiwabo‑nana viama‑havine, ivona, ‘O, amau, aituhu deina, aviamem Lasarusi evi‑tunei na‑omo yau yoko wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Iuna vavaneiu ai yau 5 imamaei, ka yau nuanua Lasarusi mataedai nau‑vi‑avini. Aituhu tauna nau‑vi‑avini deina, apaina taui eha kadu inꞌ‑omo baina viha‑vainena a papani wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka Abaraham vona‑nau‑patei, ivona, ‘Tuta habuhabuna taui Iginuma inononi, ka Mosese, ka kadu tau apa‑taputapu habuhabui inau‑vi‑avini viha‑vainena a papani wayahina. Vavaneim nau‑wawani vonaia inononi.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kate tau kaikaiwabo‑nana ivona, ‘Amau Abaraham, Iginuma ana vona ana heta eha ana pata. Kate aituhu aitam koiaka anigea mini‑havine, ka aituhu tauna na‑omo wayahia, avaha tauna idueyei, dewana ana pata inua‑vinana ahiahina yai dewa goyona wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka Abaraham vona‑nau‑patei, ivona, ‘Eha. Aituhu Mosese yana vona ivihahaiei, ka aituhu tau apa‑taputapu yai vona ivihahaiei, taui eha ai pata inua‑vinana. Kadue aituhu aitam koiaka anigea mini‑havine na‑omo wayahia, e nau‑vi‑avini, taui kadue tauna ivihahaiei aitamoata deinake.’” ");
INSERT INTO mvn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ka aitam auyewa wayahina Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Tuta tuta pai vito‑nubu bagibagina ivinꞌ‑omo‑nananena tomotau wayahia, ka pai vito‑nubu‑naia iana‑dibidibiei, e dewa goyona idedewei. Ka aituhu koiaka pai vito‑nubu nau‑vevewanei, e mani tomotau dewa goyona idedewei, vona ahiahina, onoto‑nana a dewa‑yaiyai potepotei. ");
INSERT INTO mvn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wayahina, aituhu koiaka vi‑tau vi‑peuna, onoto‑nana vidoha aituhu naona yaiana hanu ananina itana‑ipwe otona wayahina, e bebega ihapone na‑opu gavivina deina. Iuna aituhu koiaka aitam tevana yaheyahe taina wayahia deina na‑vo‑vi‑peui, e tevanana dewa goyona dewei, apaina onoto‑nana a dewa‑yaiyai ananina vaniahei Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wayahina, udune‑vivinimi! Ka aituhu vaneim wayahima goyona dewei, nau‑wawanim edewa‑dadani evo‑vi‑tunuhi. Ka aituhu vaneim yam vona nononi, ka aituhu nua‑vinana, nau‑wawanim enua‑piahi. ");
INSERT INTO mvn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ka aituhu vaneimna goyona ai yau 7 dedewei wayahima auyewa aitamoata nihenina, ka aituhu tuta aitamoata aitamoata wayahina tauna vinꞌ‑omo wayahima, e viamem, na‑vona, ‘Wayahima anua‑vinana, ka aviamem yau goyona wayahima enua‑piahi,’ akanai wamke nau‑wawanim ya goyona habuhabuna enua‑piahi.” ");
INSERT INTO mvn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wayahina, Iesu a tau hae‑naia ivonei, ivona, “Kauvea, yama vitumahana evo‑vi‑bagibagia.” ");
INSERT INTO mvn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka Kauvea vona‑nau‑patei, ivona, “Aituhu yami vitumahana mata‑sinisinina utuna deina, itomi ami pata ai taina ananina uveimeyei una‑vona, ‘Esi‑apum ka ena‑ne hawana nihenina, ka tenoke ebagunim,’ e ai‑nana yami vona‑naia na‑dewei deinake. ");
INSERT INTO mvn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ka aituhu aitam wayahimia evi‑tau kaikaiwabo, wamke yam dewa medeina? Aituhu yam tau paisewa‑kavokavovo ya paisewa baguna nau‑yehai, o kadi aituhu tauna yam sipiV dune‑vi‑avini‑yehai, ka avaha mavina yam manua wayahina, kaiwadi, nau‑wawanim evonei, ena‑vona, ‘Kaiwa ananina, enꞌ‑omoi, emanuena, kadue enꞌ‑am‑kai.’ Eha‑ohota. ");
INSERT INTO mvn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nau‑wawanim naona eveimeyei, ena‑vona, ‘Enꞌ‑omoi ka au maꞌ evo‑vi‑aiaia, eveneu, anꞌ‑am kadue ana‑nim. Na‑iakwa, akanai enꞌ‑am ka ena‑nim.’ ");
INSERT INTO mvn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ka medeina? Aituhu yam tau paisewa‑nana yam veimea vi‑muniei ka dewei, apaina nau‑wawanim enau‑kaiwe ananina ya dewaia wayahina? Eha. Iuna tauna yam tau paisewa‑kavokavovo. ");
INSERT INTO mvn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka taua taumi deinake. Wayahina, avi tuta yami paisewa habuhabuna aveimeyemi unau‑yehai, eha nau‑wawanimi uvona‑vanevane. Kate itomi nau‑wawanimi una‑vona, ‘Eha nau‑wawaniai enꞌ‑apa‑vidovidoheai. Iuna avi dewa anau‑yehai, vona ahiahina, dewaia vivane ama nau‑wawana ai heta.’” ");
INSERT INTO mvn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ka Iesu avaha Ierusalem wayahina vanevane, ka papani Samaria ka papani Galili niwania vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ka eha ani‑hoina aitam meagai wayahina na‑nu, ka tau lepero ai yau 10 ivaniahei. Ka taui tupwana bana mamanaina wayahina imimini, ipotepotei, ");
INSERT INTO mvn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka movi ananina wayahina ivivi‑hone, ivona, “Kauvea Iesu, eate‑nuanuaieai.” ");
INSERT INTO mvn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wayahina, magigino, e vonei, ivona, “Una‑ne, e tau vi‑nomu wayahia uviwavenemi.” Ka taui ivi‑putu ineine, ka etawana ai lepero iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ka aitam wayahia, tauna Samaria onotona, dueyei vivane avaha vidoha. Wayahina ya nau‑kaiwa nui mavi‑havine, ka tauna movina ananina wayahina Yaubada awa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","E tauna omo Iesu aena ipeu, vi‑kabubu, e nau‑kaiwei. ");
INSERT INTO mvn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wayahina, Iesu vi‑tanai, ivona, “Ia! Onoto ai yau 10 habuhabui avo‑vi‑aiai‑neiei, a? Kaiwadi, mani ononotoi ai yau 9 aveta? ");
INSERT INTO mvn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aviani iuna aitamoata wayahia, vivane Samaria onotona taina, ana heta mavina, e Yaubada awa‑davedavei?” ");
INSERT INTO mvn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ka Iesu Samaria onotona vonei, ivona, “Emini, ena‑ne. Yam vidoha evaniahei iuna yam vitumahana mamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ka Parisi tupwai iomo Iesu wayahina ka ivi‑tanaiei, “Avi tuta Yaubada ya pai veimea na‑omo, kadueyei?” Ka Iesu yai vi‑tanai‑nana nau‑patei deina, ivona, “Tomotau eha ai pata taui mataia Yaubada ya pai veimea a vinꞌ‑omana idueye. Ka aituhu udune‑vi‑anai wayahina, eha ami pata udueye. ");
INSERT INTO mvn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ka kadue eha ana pata una‑vona, ‘Udueyei! Baina avaha vi‑putu,’ o ‘Tenoke papani‑nana wayahina avaha vi‑putu.’ Eha ami pata uvonavona deina, iuna Yaubada ya pai veimea vivane nihenimia mamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ka munia, Iesu tauna a tau vi‑muni‑waiwai wayahia ivona, “Apaina ani‑tawanemi, ka tuta tepakaia wayahina nuanuami ananina yauke, Tauna Vi‑tomotau, nui kamamae auyewa aitamoata ana heta wayahina, kate eha ana pata ududueyeu. ");
INSERT INTO mvn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka aituhu tomotau ivonemi, ina‑vona, ‘Tauna Vi‑tomotau tanoi mamaei,’ o aituhu ina‑vona, ‘Baina mamaei!’ eha nau‑wawanimi yai vona uvitumahane, kadu eha yai vonaia deina uvi‑munie. ");
INSERT INTO mvn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ka aitam auyewa tuta tepakaia wayahina amavina wayahimia, ka auyewana wayahina eha uva‑hamwahamwana wayahiu. Iuna auyewana wayahina unꞌ‑anamaneu ahiahina, ka yau vinꞌ‑omana ana dune vivane vonaina ana dune deinake, ka wahuma papanina wayahina a itoava papani‑nana wayahina venavenau. ");
INSERT INTO mvn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ka munia, dewaia ivinꞌ‑omoi, ka naona tuta taina a tomotau yauke, Tauna Vi‑tomotau, ivihahaieu, ka dewa hidahida habuhabuna avaniahei tomotau taina wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tau maꞌ tanopi yai dewa yau mavi‑havine ana tuta wayahina vivane tau maꞌ tanopi yai dewa Noa yana tuta wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iuna nonova Noa ya tutea tomotau iamam ka inimnim, ka kadue ononotoi ka vaivinei itavitavine, kadue natunatui iawaehei itavitavine deina a itoava auyewana Noa ya waea igenu wayahina. Ka auyewana wayahina diwaya ananina vinꞌ‑omo, e tomotau‑naia habuhabui vita‑vovoni. Ka tuta tepakaia wayahina yau vinꞌ‑omana anꞌ auyewa wayahina tomotau yai dewa aitamoata tomotau‑naia yai dewa deinake. ");
INSERT INTO mvn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka kadue tau maꞌ tanopi yai dewa deinake Lota yana tuta nihenina. Iuna nonova Lota ya tutea tomotau iamam ka inimnim, ka ivi‑maiena ka iaimwaneyei, kadue ibagubaguna ka iyonayona. ");
INSERT INTO mvn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ka idedewei deinake a itoava Lota meagai Sodom ni‑tawanei wayahina. Ka auyewana wayahina ai yabeyabena hanu weweavina nui wahuma wayahina atuatuna, wei deina, ka ai‑nana tomotau‑naia habuhabui vita‑vovoni. ");
INSERT INTO mvn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ka yau vinꞌ‑omana anꞌ auyewa taina deina. ");
INSERT INTO mvn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Auyewana wayahina aituhu aviyaivia manua hetana nau‑peuna imamaei, ka aituhu yau vinꞌ‑omana idueyei, eha nau‑wawani yai manua ina‑nui, e yai gugua inꞌ‑epe. O aituhu aviyaivia baguna ipaipaisewa, eha nau‑wawani megeia imavina yai gugua wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ka nau‑wawanimi Lota awana yai dewa unua‑vi‑avini! ");
INSERT INTO mvn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aituhu aviyaivia yai nuanua taui ai heta yawai iveimeyei, taui yawai itutu‑haini. Kate aituhu aviyaivia iawaeheu yawai aveimeyei, taui yawai‑vavaha ivaniahei deina. ");
INSERT INTO mvn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Vona ahiahina, ioyomana nihenina tomotau ainua pai dauva aitamoata wayahina idaudauva, ka aitam avi‑nua‑dadanei, anꞌ‑epei, ka aitam avihahaiei, mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ka kadu deinake vaivine ainua iam‑gidoma, ka aitam avi‑nua‑dadanei, anꞌ‑epei, ka aitam avihahaiei, imamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wayahina, a tau vi‑muni‑waiwai ivi‑tanaiei, ivona, “Kauvea dewaia tanoi aveta ivinꞌ‑omo?” Ka Iesu ya vona‑nau‑pata vivane aitam vona tana‑minikuna, ivona, “‘Aveta baina waga aninigai imamae, anai wayahina bwayobwayo inau‑hohona.’ Kadu aveta baina iaiayaia ududueyei, unꞌ‑anamanei dewaia ivinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aitam auyewa wayahina Iesu tauna a tau vi‑muni‑waiwai vona tana‑minikuna aitam venei, e viwavenei vivane tuta tuta taui nau‑wawani iviama Yaubada wayahina, ka eha ina‑ihanua. ");
INSERT INTO mvn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ivona, “Aitam meagai nihenina tau vaneneha aitam mamaei. Ka tauna eha ya matauta. Eha Yaubada ta‑mataute, ka kadue eha tomotau ta‑dewa‑didigune. Wayahina, yana dewa eha tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kadue meagaina nihenina aitam wadae imamaei. Ka tuta habuhabuna wadaena iomomo tau vanenehana wayahina, ka iviamei, ‘Bada, nau‑wawanim evo‑taitaieai ama havia wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Auyewa aitamoata aitamoata wayahina wadae‑nana yai dewa deina, ka tau vaneneha‑nana eha nuanuana na‑ivaite. Ka aitam tuta wayahina tau vaneneha‑nana ininina yoina. Tauna ana heta wayahina ivona, ‘Ia! Akanai. Eha Yaubada amatamataute, ka kadue eha tomotau adewa‑didigune. ");
INSERT INTO mvn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kate wadae‑nana yai omana‑havihavine wayahiua, ka avaha aihanua. Wayahina, ataina ana‑ivaitei ai havia wayahina, ka apaina eha imavi‑havihavine wayahiua!’” ");
INSERT INTO mvn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka Kauvea kadue vonei, ivona, “Nau‑wawanimi tau vaneneha‑nana manimaninina tanoi yana vona unuani. Iuna tauna vivane onoto goyona, kate apaina vi‑nua‑dadani wadae‑nana na‑ivaitei. ");
INSERT INTO mvn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wayahina, vona ahiahina, Yaubada vivane ahihinata, ka tauna ya tomotau ate‑nuanuaiei. Ka aituhu ya tomotau auyewa ka ioyoma nihenia iviama‑havihavine wayahina, vona ahiahina, tauna ya nuanua ananina na‑ivaitei, kadu goyona na‑bou‑potei wayahia. Kaiwadi, tauna vi‑kiwadi? Avonemi, eha. ");
INSERT INTO mvn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tauna ya ivaita na‑va‑tawanei, e vo‑kwayavonina vinꞌ‑omo wayahia. Kate yau vi‑tanai taina wayahimia. Avi tuta yauke, Tauna Vi‑tomotau, amavina tanopia, kaiwadi, tomotau ivitumahaneu avaniahei, o eha?” ");
INSERT INTO mvn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ka tomotau tupwai inua‑vane, ka ivitumahanei taui tunutunuhi ka mani tomotau goyogoyoi. Wayahina, Iesu vona tana‑minikuna taina venei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Aitam tuta wayahina onoto ainua ivane Manua Vito‑pota inui, iuna yai nuanua iviama Yaubada wayahina. Aitam Parisi ka aitam takesiV a tau vitua. ");
INSERT INTO mvn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ka Parisi‑nana mini, e viama, ivona, ‘O Yaubada, anau‑kaiwa wayahima, iuna yauke eha mani tomotau deina. Taui yai dewa vivane gugua inua‑tania, ka ivainau, kadu ivivitupu, kadu ikenekenene. Ka adewa‑haiawa ananina iuna yauke eha takesiV a tau vitua tanoi deina. ");
INSERT INTO mvn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iuna wiki aitamoata aitamoata nihenina auyewa ainua wayahia au aniani habuhabuna kadu au pai nim habuhabuna avito‑potau, ka kadue tuta tuta yau gugua habuhabuna atana‑vewani gwau ai yau 10 wayahia, ka gwau aitamoata wayahia avene‑kavovo‑havinem, yam veimea veimeyeai deina.’ ");
INSERT INTO mvn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ka takesiV a tau vitua‑nana ya ini‑yauyau nui mini tupwana bana mamanaina Yaubada ya pai vi‑nomu wayahina, ka manakadana vinanahi, ka dune‑opu, e viama, ivona, ‘O Yaubada, avaha eanamaneu yauke tau goyogoyona. Wayahina, aviamem eate‑nuanuaieu!’” ");
INSERT INTO mvn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wayahina, Iesu kadue wayahia ivona, “Vona ahiahina, ononotoi ainuai yai viama iakwa, e imavina yai megeia, ka aitamoata tunutunuhina Yaubada matana, vivane takesiV a tau vitua‑nana, eha Parisi‑nana. Iuna aituhu aviyaivia inua‑vane, apaina taui apa‑goyogoyo ivaniahei Yaubada wayahina. Ka aituhu aviyaivia inua‑opu, apaina taui apa‑vidovidoha ivaniahei Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ka tupwai tomotau natunatui motutukui iomane‑neiei, e yai nuanua Iesu nimana bouni kadu nau‑iaiavai. Ka a tau vi‑muni‑waiwai, avaha tomotaui yai dewa idueyei, ivito‑potai. ");
INSERT INTO mvn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka Iesu yaheheia honei inau‑hohoni wayahina, ka tauna a tau vi‑muni‑waiwai vonei, “Eha yaheyahe uvito‑potai wayahiua. Kate nau‑wawanimi unꞌ‑awaehei wayahiua iomomo. Iuna aituhu aviyaivia ivitumahaneu yaheyahe deina, vona ahiahina, memeanina taui wayahia Yaubada ya pai veimea ivaniahei, e ina-nui. ");
INSERT INTO mvn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia eha ivitumahaneu yaheyahe yai vitumahana deina, eha kadu aitam etawana ta‑mamae wayahi. Taui eha ai pata Yaubada ya pai veimea ina‑nu.” ");
INSERT INTO mvn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ka me Iudea yai tau eta‑naonao aitam omo, e Iesu vi‑tanaiei, ivona, “Tau Viwavenena Ahiahina, aviani nau‑wawaniu adewei, e munia yawai‑vavaha avaniahei?” ");
INSERT INTO mvn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka Iesu onoto‑nana vona‑nau‑patei, ivona, “Aviani wayahina eawꞌ‑ahihieu? Iuna Yaubada a heta‑ohota vivane ahiahina, eha kadu aitam koiaka. ");
INSERT INTO mvn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ka avaha Yaubada ya veimea eanamane‑yehai, vivane ‘Eha ekenene, eha enau‑vi‑aniga, eha evainau, eha evitupu‑kavokavovo, ka kadue nau‑wawanim amam ka ayom evi‑ateteyei.’” ");
INSERT INTO mvn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka onoto‑nana ivona, “Yau tuta tevana wayahina a itoava tuta ataina wayahina veimea‑naia avi‑muniei.” ");
INSERT INTO mvn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka Iesu avaha ya vonana nononi, vonei, ivona, “Kadu aitam dewa bou‑potam. Wamke nau‑wawanim yam gugua habuhabuna eimwaneyei, e ai nau‑pata tau payapayaya wayahia evo‑patai. Na‑iakwa, emavina, evi‑munieu. E apaina yam kaikaiwabo wahuma evaniahei deina.” ");
INSERT INTO mvn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kate tauna, avaha vonana nononi, magigino, ka ya nua‑vita nui ni‑tawanei. Iuna ya kaikaiwabo ananina mamaei, ka nua‑tania. ");
INSERT INTO mvn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ka Iesu avaha onotona ya nua‑vitana anamanei. Wayahina, tomotau nepena wayahia ivona, “Aioi! Aituhu aviyaivia yai kaikaiwabo ananina mamaei, taui yai nui Yaubada ya pai veimea nihenina vivane vita‑vainena. ");
INSERT INTO mvn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vona ahiahina, kameliV vahitau ananina, ka aituhu haima matana wayahina inu‑dadani, dewana vitana wayahina. Ka aituhu tau kaikaiwabo Yaubada ya pai veimea nihenina inu‑dadani, taui eha ai pata.” ");
INSERT INTO mvn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ka yokoia Iesu nui imamaei avaha vonana inononi, nuai vi‑tupatupa, ka ivi‑tanaiei, ivona, “Aioi! Aituhu taina deina tau kaikaiwabo wayahi, koiaka ana pata ito‑yavuha Yaubada wayahina na‑vaniahe?” ");
INSERT INTO mvn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kadue wayahia ivona, “Avi dewa tomotau eha ai pata, dewaia vivane memeanina Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wayahina, Pita Iesu vonei, “Kauvea, edueyei. Itoai avaha yama meagai kadu yama gugua habuhabuna ani‑tawanei, e avi‑muniem. Wayahina, medeina wayahiai?” ");
INSERT INTO mvn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka Iesu tauna a tau vi‑muni‑waiwai habuhabui vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia yai meagai, o awawai, o vavanei, o amamai, o ayoyoi, o natunatui ini‑tawane‑neiei, iuna yai nuanua Yaubada ya pai veimea ivaniahei, ");
INSERT INTO mvn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tuta taina wayahina tanopia taui mani tomotau habuhabui ivaniahei yai yoko deina, ka kadue apaina yawai‑vavaha ivaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ka Iesu tauna a tau hae ai yau 12‑naia nau‑hohoni, e nau‑niai enoi neiei, e vonei, ivona, “Ataina tuta kana‑vanevane Ierusalem wayahina, ka avi dewa habuhabui nonova tau apa‑taputapu iginumi yauke, Tauna Vi‑tomotau, wayahiu, apaina ivinꞌ‑omo, udueyei. ");
INSERT INTO mvn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naona iam‑veneneyeu taui eha me Iudea wayahia, e ivi‑waipoeu, e ivo‑vꞌ‑ini‑yauyau, e iaiwaniu, kadue yavunaia ivunuvunu, ka inau‑vi‑anigiu. ");
INSERT INTO mvn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka kadue munia, auyewa vꞌ‑itonuna wayahina, anigea amini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kate eha aitam a tau vi‑muni‑waiwai wayahia ta‑nua‑hau. Vonaia ai anamana maimaiovina wayahia, ka eha itꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka meagai Ieriko wayahina ivi‑maupwani, ka aitam tau mata‑goyogoyona etawana baimina manuena, ka toea kadu gugua viama tomotau ivenavenau wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ka tauna avaha Iesu yana yoko nui movi nononi, e vi‑tanai, “Aviyaivia ivinꞌ‑omo?” ");
INSERT INTO mvn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka taui nepena ivona‑nau‑patei, ivona, “Taina Iesu, onoto Nasareta omo‑neine.” ");
INSERT INTO mvn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wayahina, tau mata‑goyo‑nana vi‑putu vi‑hone‑havihavine movina ananina wayahina, e vonavona, “O, Iesu, taum Davida wana, nau‑wawanim eate‑nuanuaieu!” ");
INSERT INTO mvn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka tomotaui etawana ieta‑naoi, onoto‑nana ivito‑potei, ivona, “Ia! Egenuana! Akanai vi‑hone!” Akaka tauna eha ta‑genuana, kate movina ani‑vainena wayahina vi‑honehone, vonavona, “O, Davida wana, nau‑wawanim eate‑nuanuaieu.” ");
INSERT INTO mvn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka tutana Iesu onotona ya pai manuena a papani wayahina vi‑maupwani, mini, e tomotaui vonei, ivona, “Onotona uomanei baina wayahiua.” Ka avaha onotona matana mimini, ");
INSERT INTO mvn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","e vi‑tanaiei, ivona, “Aviani nuanuam adewe wayahim?” Ka onotona viamei, ivona, “Kauvea, yau nuanua ananina matau evo‑vi‑aiaia adunedune!” ");
INSERT INTO mvn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Akaka Iesu vonei, ivona, “O, ahiahina. Ataina tuta matam na‑mahete edunedune. Ataina evitumahaneu, wayahina avaha evidoha.” ");
INSERT INTO mvn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ka vo‑kwayavonina matana mahetei, e tauna Yaubada awa‑davedavei, kadu vi‑putu Iesu vi‑muniei. Ka yokoia dewana idueyei, e habuhabui kadu Yaubada iawa‑vidovidohei. ");
INSERT INTO mvn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ka Iesu meagai Ieriko wayahina inu ka omo‑neine. ");
INSERT INTO mvn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka meagai‑nana nihenina aitam takesiV a tau vitua ai tau eta‑naonao mamaei, ana wava Sakaeusi, ka tauna tau kaikaiwabo ananina. ");
INSERT INTO mvn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ka Sakaeusi nuanuana ananina Iesu dueyei, kate yoko ananina nui ivenavenau, ka Sakaeusi kutakutana, wayahina eha ana pata ta‑dueye. ");
INSERT INTO mvn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wayahina, tauna nau‑bwanunua eta‑naoi, e aitam madaiba ana wava sikamoreV ai‑vane, e vivane hetana wayahina na‑dueye, iuna Iesu etawanana omomoi. ");
INSERT INTO mvn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka tutana Iesu omo ai‑nana wayahina, tauna dune‑vane, e Sakaeusi dueyei. E vonei, ivona, “Sakaeusi, eopu‑me‑kwayavoni, iuna ataina wamke yauke yam manua kamamae.” ");
INSERT INTO mvn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wayahina, Sakaeusi vo‑kwayavoni iopu, ka ya dewa‑haiawa nui Iesu ainua ivi‑vaniaha. ");
INSERT INTO mvn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ka tau vi‑meagai habuhabui avaha dewana idueyei ivi‑putu ivi‑vonavona wayahina, ivonavona, “Ia! Onoto‑nana tau goyogoyona, ka Iesu inei ya manua, na‑nau‑vi‑taui! Medeina yana dewa deina?” ");
INSERT INTO mvn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ka Sakaeusi mini, e Kauvea vonei, ivona, “Kauvea, edueyei. Ataina yau gugua habuhabuna atana‑vewani ainua ka ana tupwa aitamoata habuhabuna tau payapayaya avene‑neiei. Ka kadu aituhu aviyaivia nonova avitua‑pani patana aitamoata wayahina, ai vo‑vi‑tupana na nau‑punina hetana aboui.” ");
INSERT INTO mvn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Wayahina, Iesu vonei, ivona, “Ataina tuta wayahina ito‑yavuha avaha vinꞌ‑omo manua taina wayahina. Iuna onoto taina kadu aitam Abaraham wana. ");
INSERT INTO mvn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vona ahiahina, yauke, Tauna Vi‑tomotau, yau paisewa vivane aomo tanopia, e taui tupatupai wayahia anaunau‑nene, kadu ana‑ito‑yavuhi, onoto taina deina.” ");
INSERT INTO mvn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka tutana tomotau‑naia imamaei Sakaeusi ya manua nihenina, Iesu aitam vona tana‑minikuna venei. Iuna avaha ivi‑maupwani Ierusalem wayahina, ka tauna avaha anamane‑yehai vivane yoko‑naia inuanua bwagona, e tuta eha ani‑hoina na‑iakwa wayahina, Yaubada ya pai veimea vi‑putu. Ka kadu taui inuanua bwagona ai pata mataia idudueye. ");
INSERT INTO mvn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wayahina ivona, “Aitam kiniV natuna onotona mamaei papani aitam wayahina, ka mataeda omo wayahina, e nau‑wawani na‑ne bana mamanaina mani papani wayahina, e tenoke vi‑kiniV yai papani habuhabuna wayahina. Ka dewana na‑iakwa, e tauna ya nuanua na‑mavi‑havine ya manua wayahina. Akaka ya gugua vo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka eha ani‑hoina na‑ni‑tawane wayahina, tauna ya tau paisewa ai yau 10 honei inau‑hohoni wayahina. Ka yana kina tupwai tana‑vewani, ka aitamoata aitamoata wayahia ai vo‑pata venei, e vonei, ivona, ‘Ami vo‑pata taina avenemi, vivane kode aitamoata. Ka ani‑tawanemi, ka nau‑wawanimi uvi‑paisewei, e kina tupwana hetana uvaniahei wayahiu a itoava amavi‑havine wayahimia wayahina.’ Vonana iakwa, e ni‑tawanei ine bana mamanaina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kate taui kiniV natu‑nana ya papani nihenina imamaei inau‑nikonikoiei. Wayahina, taui yai tau mataeda yoko ivi‑tunei ine papani‑nana bana mamanaina wayahina, ka ivona, ‘Itoai eha yama nuanua onoto tanoi vi‑kiniV, ka eha yama nuanua tauna veimeyeai.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kate yai vona eha aitam aviani tenoke papani‑nana bana mamanaina wayahina, ka yai kauvea vi‑kiniV, kadu mavi‑havine, yana vona wayahia aitamoata deina. Ka avaha mavina, tauna ya tau paisewa nonova yana kina vo‑patai honei inau‑hohoni wayahina. Iuna ya nuanua nꞌ‑anamane vivane ai vi‑am kina ai vo‑pata hetana ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka aitam onoto eta‑naoi ya kauvea matana, mini, e vonei, ivona, ‘Bada, nonova yam kina wayahia au vo‑pata vivane kode aitamoata. Ka kodena wayahina avaha kode ai yau 10 avaniahei wayahim, ka ataina avene‑havinem.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka kauvea‑nana ivona, ‘Dewa ahiahina! Wamke tau dune‑vi‑avina ahiahina aitam. Avaha eviwaveneu aituhu yau toea tupwai awaehem edune‑vi‑avini, akanai, am pata dewa tunutunuhina ededewei. Wayahina, ataina meagai ai yau 10 awaehem, evi‑tau veimea wayahi.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ka onoto vꞌ‑inuana kadu omo, e ivona, ‘Bada, nonova yam kina wayahia au vo‑pata vivane kode aitamoata. Ka kodena wayahina avaha kode ai yau 5 avaniahei wayahim, ka ataina avene‑havinem.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wayahina kauvea‑nana kadu tauna vonei, ivona, ‘Ahiahina. Wayahina meagai ai yau 5 awaehem evi‑tau veimea wayahi.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ka kadu aitam tau paisewa omo, e ivona, ‘Bada, nonova yam kina wayahia au vo‑pata vivane kode aitamoata. Ka kodena taina avene‑havinem. Nonova kodena kaleko wayahina aumei, e abou‑vidovidohei ahiahina a itoava ataina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Adewei deina iuna avaha anamanem vivane taum onoto manimaninim, ka yam dewa eha ebagubaguna, kate mani tomotau yai paisewa a nau‑pata epepei, ka kadue eha esi‑yavuyavunena, kate mani tomotau yai aihana enꞌ‑aihana. Wayahina amatamatautem.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ka ya kauvea‑nana ivona, ‘Ia! Taum tau paisewa goyom! Yam vonea anau‑yanahim, iuna avaha eanamaneu vivane yauke onoto manimaniniu, ka yau kaikaiwabo aepepei mani tomotau yai paisewa wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wayahina, nonova nau‑wawanim yau kina banikaV nihenina ebou, e avi tuta amavina wayahina, kodena avaniahe kadu a vo‑vi‑tupana hetana.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ka tauna ya tau paisewa tupwai imimini nepena vonei, ivona, ‘Au kodena onoto taina wayahina unꞌ‑epe, e onotona naona vinꞌ‑omo kode ai yau 10 wayahina uvenei.’ ");
INSERT INTO mvn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Akaka tau paisewa‑naia nuai vi‑tupatupa, wayahina ivona, ‘Ia! Bada, yam dewana eha tunutunuhina, iuna onoto‑nana avaha kode ai yau 10 wayahina!’ ");
INSERT INTO mvn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kate yai kauvea‑nana wayahia ivona, ‘Eha. Yau dewana vivane tunutunuhina, wayahina uvenei deina. Iuna vona‑vavaha, aituhu aviyaivia ivitumahaneu, ka iupu‑moimoiha, apaina gugua habuhabuna avenei. Ka aituhu aviyaivia eha ivitumahaneu, ka iupu‑tonetonene, apaina aviani kikituna wayahia mamaei anꞌ‑epa‑yavune, e munia, awakabi imamaei akanai. ");
INSERT INTO mvn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka nonova yau tomotau tupwai au havia, iuna yau veimea ivihahaiei. Wayahina, ataina tuta uomanei wayahiua, e mataua unau‑vi‑anigi.’” ");
INSERT INTO mvn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu ya vonana nau‑yehai, mini, e a tau vi‑muni‑waiwai nui ivanevane Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ka yai venavenau wayahina meagai Betepage kadu meagai Betani wayahia ivi‑maupwani. Ka meagai ainuai wayahia Oya Olive eha bana. Ka tauna a tau vi‑muni‑waiwai ainua mai‑vi‑tunei ieta‑naoi papanina wayahina ai mataeda nui. ");
INSERT INTO mvn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ivona, “Meagaina tanoi tepakaia wayahina una‑ne, e tanoi wayahina apaina aitam vahitau udune‑vaniahei, vivane aseV tupunaina. Eha aitam tomotau ta‑vi‑ata‑dadana. Ka vahitauna uyavuhi, unꞌ‑omane‑havinei baina wayahiua. ");
INSERT INTO mvn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka aituhu koiaka wayahimia na‑vona, ‘Ia! Aviani wayahina tanai vahitauna uyavuyavuhi?’, onoto‑nana uvona‑nau‑patei, una‑vona, ‘Yaka Kauvea ya nuanua.’” ");
INSERT INTO mvn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Akaka taui ineine, e dewa habuhabuna ivaniahei Iesu yana vona deina. ");
INSERT INTO mvn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka tutana ase‑nanaV iyavuyavuhi, tau vi‑vahitau‑naia ivi‑tanaiei, ivona, “Aviani wayahina yama vahitau uyavuyavuhi?” ");
INSERT INTO mvn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wayahina ivona, “Yaka Kauvea ya nuanua.” ");
INSERT INTO mvn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ka vahitauna itaini ineiei Iesu wayahina. Ka ai kwama wauna iyaveni, ka Iesu vi‑ata hetana. ");
INSERT INTO mvn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka tutana neine etawana, tomotau habuhabui ai kwama kadu etawana iyaveni‑neiei. Iuna yai dewa‑haiawa nui ya etawana ivaivani. ");
INSERT INTO mvn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ka tauna yoko nui ineine Oya Olive a etawana wayahina, ka etawana iopu Ierusalem wayahina. Ka tau vi‑muni yoko habuhabui yai dewa‑haiawa nui ivi‑putu movi ananina wayahina Yaubada iawa‑vidovidohei, kadu iaheahe, iuna avaha Yaubada ya dewa‑bagibagina habuhabuna idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ivonavona, “Kaiwa ananina, Kauvea! Iuna kiniV taina omomo am wavea vivane kiniV ahiahina!” kadu ivonavona, ");
INSERT INTO mvn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka Parisi tupwai yokoia nihenina avaha vonaia inononi, Iesu ivito‑potei, ivona, “Ia! Tau Viwavenena, nau‑wawanim am tau vi‑muni‑waiwai eveimeyei awa‑dava taina wayahina igenuana!” ");
INSERT INTO mvn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ka Iesu vona‑nau‑patei, ivona, “Eha nau‑wawaniu avito‑potai. Iuna aituhu taui igenuana, vona ahiahina, hanu taina etawana baimina yai dewa‑haiawa nui ivi‑putu iawa‑davadava.” ");
INSERT INTO mvn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka avaha Iesu vinꞌ‑omo Ierusalem nepena, ka meagaina ananina dueyei, e nuana ivita, e toutou. Ka meagaina wayahina ivona, ");
INSERT INTO mvn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“O Ierusalem! Aituhu ataina wamke eanamane ahiahina koiaka ana pata nua gomagomanina na‑venem, evidoha deina. Kate eha etꞌ‑anamane, iuna nua‑uya‑nana hivahivana matama. ");
INSERT INTO mvn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka apaina, tuta tepakaia wayahina, am havia inꞌ‑omo, e havia ana yona iyonei awaniam, ka itutu‑gani‑vivinem, e ibou‑potapotam. ");
INSERT INTO mvn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ka munia, yam tutu‑gana itutu‑bwegebwegei. Na‑iakwa, tomotaui habuhabui yam tutu‑gana nihenina iva‑taunei tanopia, ka kadue manua habuhabuna ibwegebwege‑neiei deinake. Ka avaha haviana inau‑yehai, vona ahiahina, auyewana wayahina eha aitam hanu mani hanu hetana mamae nihenima. Apaina am havia idewam deinake, iuna ataina eha Yaubada yanꞌ omana wayahima etꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ka avaha meagai Ierusalem inui, tauna omo Manua Vito‑pota wayahina, ka avi tau aimwane vahitau pai vi‑nomu iaimwanei nihenina vo‑tahoi. ");
INSERT INTO mvn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ka vonei, ivona, “Iginuma nihenina Yaubada voneka deina, ‘Yau manua ivi‑wahani “Viama A Manua”,’ kate itomi avaha uvo‑vinei vivane ‘tau vainau yai manua’.” ");
INSERT INTO mvn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka mana navia a itoava yanꞌ auyewa pai nau‑yehata wayahina, auyewa aitamoata aitamoata wayahina, Manua Vito‑pota nihenina yoko wayahia viwavenena. Ka tau vi‑nomu mata‑genai, ka veimea a tau viwavenena, ka kadue tau eta‑naonao yai nuanua ananina Iesu ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kate yai etawana eha ai pata ita‑vaniahe, iuna auyewa aitamoata aitamoata wayahina yoko ananina Iesu ya viwavenena wayahina ivanevaneneha, kadu nuai epepei. ");
INSERT INTO mvn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ka aitam auyewa wayahina Iesu tomotau wayahia viwavenena Manua Vito‑pota a pai nau‑hohona nihenina kadue Vane Ahiahina nau‑waheyei. Ka tau vi‑nomu mata‑genai, kadu veimea a tau viwavenena, ka tau eta‑naonao nui iomo. ");
INSERT INTO mvn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ka ivi‑tanaiei, ivona, “Taum koiaka? Evoneai avi awaeha wayahina dewaia ededewei, o kadi koiaka am awaeha venem.” ");
INSERT INTO mvn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka vona‑nau‑patei, ivona, “Kaduke yau vi‑tanai mamaei, e avi‑tanaiemi. ");
INSERT INTO mvn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioni Tau Bapitaiso, ya bapitaiso medeina? Kaiwadi, tauna dedewei iuna a veimea vinꞌ‑omo Yaubada wahuma wayahina, o kadi iuna a veimea vinꞌ‑omo tomotau wayahia?” ");
INSERT INTO mvn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka matataui ivi‑vonavona, “Kadi aituhu kana‑vona, ‘Yaubada wahuma wayahina’, e tauna ya vi‑tanai wayahikaia ‘Aituhu deina, aviani wayahina eha uta‑vitumahane?’ ");
INSERT INTO mvn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kadi aituhu kana‑vona, ‘Tomotau wayahia’, e yoko taina habuhabui inau‑vunuka, iuna ivitumahanei Ioni Tau Bapitaiso vivane Yaubada ya tau apa‑taputapu aitam.” ");
INSERT INTO mvn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wayahina, ivona‑nau‑patei, ivona, “Kaiwadi. Itoai eha atꞌ‑anamane aveta baina wayahina a veimea vinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ka Iesu vonei, “A. Wayahina, eha au awaeha iuna asi‑vinꞌ‑omanemi.” ");
INSERT INTO mvn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ka Iesu magigino, ka vona tana‑minikuna taina venei tomotaui ivanevaneneha wayahina, ivona, “Aitam onoto ya baguna wainaV ana noe mamaei, ka awaehei mani tomotau wayahia. Ka taui iawaehei aitamoata taina deina. Taui imamaei, e ya baguna idune‑vi‑avini. Ka apaina aihana ana tuta wayahina iaihani, e uana itana‑vewani, e tau vi‑baguna a vo‑pata ivenevenei. Iawaehei deina, e tauna ya meagai ni‑tawanei ine mani papani wayahina, ka tenoke mamaei tuta mamanaina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ka avaha aihana ana tuta vinꞌ‑omo, e tau vi‑bagunana ya tau paisewa aitam vi‑tunei ine wayahia vivane a vo‑pata ivenei. Kate tomotau‑naia ya tau paisewa ivunuvunui, ka ivi‑tunei mavi‑havine nimanata. ");
INSERT INTO mvn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wayahina, tauna kadu aitam tau paisewa vi‑tunei ine wayahia, ka tauna kaduke ivunuvunui, ivi‑goyoi, e ivi‑tunei nimanata. ");
INSERT INTO mvn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka kaduke tau paisewa vꞌ‑itonuna vi‑tunei ine wayahia, ka taui kaduke ivunui, ininina ivo‑himwani, e baguna upuna ihaponei. ");
INSERT INTO mvn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ka tauna ana heta wayahina ivona, ‘Aviani adewe? Avaha anamanei. Yauke natu adune‑nuanuaiei avi‑tunei ine wayahia, ka tauna kadi ivi‑ateteyei!’ ");
INSERT INTO mvn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kate tomotau‑naia avaha natuna idueyei, e matataui ivonavona, ‘O, ataina tuta yaka auyewa. Iuna onoto taina vivane unu‑tauna. Ka avi tuta amana yana tuta iakwa, vona ahiahina, baguna taina vivane ya gugua. Ka aituhu ataina kanau‑vi‑anigi, apaina tano taina yaka tano.’ ");
INSERT INTO mvn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ka tomotau‑naia baguna upuna ihaponei, kadu inau‑vi‑anigi.” Ka Iesu yokoia vi‑tanaiei, ivona, “Apaina, aviani tau vi‑bagunana na‑dewe tomotau‑naia wayahia? ");
INSERT INTO mvn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Vona ahiahina, tau vi‑bagunana na‑mavi‑havine ya baguna wayahina, ka taui habuhabui na‑nau‑vi‑anigi, kadu ya baguna mani tomotau nꞌ‑awaehei idune‑vi‑avini tunuhina.” Ka yokoia ivona, “Ia! Tomotaui yam vona tana‑minikuna tanoi nihenina vivane tau goyogoyona. Kate eha ama pata itoai adedewe deina.” ");
INSERT INTO mvn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka Iesu dune‑vi‑anai, e ivona, “Aituhu deina, Iginuma taina yauke, Tau Ito‑yavuha, wayahiu anꞌ anamana medeina? Ivona, ‘Ohonana tau yona ivihahaiei, kate ohonana vivane ohona naona, ka tauna ohona habuhabui bagibagi‑tawanei.’ ");
INSERT INTO mvn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ka vona ahiahina, aituhu aviyaivia ohonana wayahina ivito‑paine, apaina ipeu ananina, ka iam‑bwegei. Kate aituhu ohonana na‑peu hetaia, taui apaina na‑mutu‑yehai, hanavu deina.” ");
INSERT INTO mvn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ka veimea a tau viwavenena, ka tau vi‑nomu mata‑genai avaha vona tana‑minikuna tanoi inononi, inua‑goyo. Iuna avaha ianamanei Iesu ya vonana wayahina apa‑goyogoyoei. Wayahina, auyewana wayahina inaunau‑nene aitam etawana ivaniahe vivane ipoyꞌ‑avini. Kate taui imatamatauta yoko‑naia wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Akaka yai vitupu inau‑vevewanei, e mani tomotau ivi‑tunei iomo tauna wayahina. Ka taui iviam‑nonona vivane tau tunutunuhi. Ka veimea a tau viwavenena, ka tau vi‑nomu mata‑genai yai nuanua Iesu yana vona nihenina goyona ivaniahe, ka dewana wayahina iuna mamaei ipoyꞌ‑avini, ka inꞌ‑am‑veneneye me Rom ai tau veimea Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wayahina, tau vitupu‑naia ivinꞌ‑omo, e ivi‑tanaiei, kadu iana‑dibidibiei, ivona, “Tau Viwavenena, anamanem vivane tuta tuta wayahina evonavona ahiahina, kadue eviwaveneai tunutunuhina. Kadu eha aitam koiaka ananina matama, kate Yaubada ya nuanua eviwavenei tunutunuhina tomotau aitamoata aitamoata wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wayahina, nau‑wawanika takesiV SisaV wayahina kavenevenei o eha?” ");
INSERT INTO mvn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka tauna avaha yai viam‑nonona anamanei, wayahina vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Me Rom yai toea aitam uveneu adueyei.” Ka avaha ivenei, vi‑tanaiei, ivona, “Koiaka mayamayauna taina kadu koiaka ana wava taina?” ");
INSERT INTO mvn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ka ivonei, “Ainuai vivane SisaV wayahina.” Ka tauna vona‑nau‑patei, ivona, “Ahiahina. Wayahina, aituhu aviani SisaV ya gugua, akanai nau‑wawanimi SisaV uvenevenei, kadi aituhu aviani Yaubada ya gugua, akanai nau‑wawanimi Yaubada uvenevenei.” ");
INSERT INTO mvn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wayahina, taui eha ai pata vonana nihenina goyona ivaniahe tomotau habuhabui mataia. Ka nuai vi‑tupatupa ananina, e igenuana. ");
INSERT INTO mvn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dewana iakwa, e tupwai Sadusi yoko iomo Iesu wayahina, ka taui ivitumahanei tomotau ianiga, e yawai iakwa, eha imini‑havine. Ka kadu taui yai nuanua ivi‑tanaiei. Wayahina ivona, ");
INSERT INTO mvn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tau Viwavenena, Mosese veimea taina veneka, vivane aituhu onoto eha natuna inusi, ka aituhu wadaena mamaei, onotona vaneina nau‑wawani wadaena na‑tavine. Ka aituhu wadaena vi‑natuna, natunatui vivane onoto‑nana inusi natunatuna. ");
INSERT INTO mvn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Akaka aitam tuta wayahina vavaneina ai yau 7 imamaei, ka unu‑tauna tavine ka inusi, ka eha aitam natuna. ");
INSERT INTO mvn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ka vꞌ‑inuana wadaena tavinei, kate deinake inusi, eha aitam natuna. ");
INSERT INTO mvn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ka vꞌ‑itonuna deinake a itoava aya‑ketuna wayahina. Ka habuhabui inusi, eha aitam natui. ");
INSERT INTO mvn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ka pai nau‑yehata, wadae‑nana kadu inusi. ");
INSERT INTO mvn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wayahina, mini‑havine anꞌ auyewa wayahina, wadae‑nana koiaka awana? Iuna habuhabui itavinei awai?” ");
INSERT INTO mvn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka Iesu vonei, ivona, “Tuta taina wayahina tomotau itavitavine, kadu ayo‑amai iawaehei natunatui itavitavine deinake. ");
INSERT INTO mvn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kate apaina, aituhu aviyaivia Yaubada awaehei imini‑havine anigea, kadu Yaubada ya pai veimea ivaniahei, taui eha itavine, kadu eha aitam koiaka nꞌ‑awaehe itavine. ");
INSERT INTO mvn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kadue eha ana pata inꞌ‑aniga‑havine, iuna mini‑havine ana tuta na‑iakwa, e taui anelose deina, vivane Yaubada natunatuna, kadu mini‑havine natunatuna. ");
INSERT INTO mvn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ka nonova Mosese ya iginuma nihenina viwaveneka mini‑havine omomo. Iuna tutana ai ananata dueyei, ivona, ‘Yaubada vivane Kauvea taui yawayawai wayahi, vivane Abaraham ya Yaubada, ka Isaki ya Yaubada, kadue Iakobo ya Yaubada.’ Tuta tanoi wayahina, aitonu avaha inusi, kate Mosese ivona deinake iuna aitonu yawayawai. ");
INSERT INTO mvn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iuna vona ahiahina, Yaubada eha aninigai yai Yaubada, kate tauna yawayawai yai Yaubada. Iuna tauna matana tomotau habuhabui yawayawai imamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ka veimea a tau viwavenena tupwai ivona‑nau‑pata, ivona, “Akanai. Tau Viwavenena, yam vonana vivane vona tunutunuhina!” ");
INSERT INTO mvn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ka ya vonana munina eha aitam koiaka vatuna nui vi‑tanai wayahina ita‑nau‑dadana. Iuna ya nua‑uya idudueyei akanai. ");
INSERT INTO mvn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ka Iesu vi‑tanaiei, ivona, “Medeina tomotau ivonavona Tau Ito‑yavuha‑nana vivane Davida natuna aitam? ");
INSERT INTO mvn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Buki Sam nihenina Davida ya iginuma voneka, ivona, ‘Yaubada yau Kauvea vonei, ivona, “Nau‑wawanim ateiua emanuena ");
INSERT INTO mvn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","a itoava am havia avunui wayahina, e aem a pai vi‑ai wayahina aomanei inꞌ‑awa‑davedavem.” ’ ");
INSERT INTO mvn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Unononi. Davida onoto‑nana vi‑wahani ‘yau Kauvea’. Ka aituhu deina, medeina Tau Ito‑yavuha‑nana kadue Davida natuna?” ");
INSERT INTO mvn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ka yokoia habuhabui ivanevaneneha, ka tauna a tau vi‑muni‑waiwai wayahia magigino, e nau‑vi‑avini, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Udune‑vivinimi, ka veimea a tau viwavenena yai dewa uvihahaiei. Iuna yai nuanua ai kwama mamanaina iweteweteni, e ini‑awana‑kavokavovo tomotau mataia, kadu yai nuanua tomotau inau‑kaiwei maketia, kadu yai nuanua pai manuena ahiahina wayahina imanuena manua tapanono nihenia, kadu yai nuanua aituhu tomotau ikanibutu, imanuena pai manuena naona wayahia. Yai dewa habuhabuna ivinꞌ‑omo yai nua‑vane wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kadue taui yai vitupu wayahina wadawadae yai manua ivainaui, ka viam‑nonona wayahina tomotau mataia iviama mamanaina, e tomotau inuanua Yaubada idune‑nuanuaiei. Apaina aituhu aviyaivia yai dewa deinake, taui dewa‑yaiyai ani‑vainena ivaniahei Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ka Iesu mimini Manua Vito‑pota nihenina, ka dunedune tau kaikaiwabo wayahia vivane yai am‑venena‑kavovo iboubou iopu am‑venena a pai vi‑ai nihenina. ");
INSERT INTO mvn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ka munia, aitam wadae siwasiwaboai iomo, e toea ainua ai heta pai vi‑ai nihenina iboui. ");
INSERT INTO mvn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ka tauna a tau vi‑muni‑waiwai wayahia ivona, “Vona ahiahina avonemi, wadae siwasiwaboai taina yai am‑venena‑kavovo ani‑vainena iboui, vivane am‑venena habuhabui vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iuna tau kaikaiwabo habuhabui yai natea iam‑venena ka ibouboui, kate vavinena siwasiwaboai taina avaha ai maꞌ patana habuhabuna ibou‑yehai.” ");
INSERT INTO mvn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ka a tau vi‑muni‑waiwai tupwai Manua Vito‑pota a vaivana hanu ahihi‑vainena idudueyei, kadu tomotau yai am‑venena‑kavovo Yaubada wayahina nihenina ai dune ahihi‑vainena idudueyei, ka nuai iepei, e dewaia wayahia ivonavona. Kate Iesu vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gugua taina habuhabui ududueyei ataina ai dune ahiahina. Kate avonemi, aitam auyewa omomo, ka auyewana wayahina eha aitam hanu na‑mae mani hanu hetana, iuna meagai taina a havia inꞌ‑omo ka manua aitamoata aitamoata itutu‑bwegebwegei, kadu meagai habuhabuna ivita‑vovoni.” ");
INSERT INTO mvn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka ivi‑tanaiei, ivona, “Ia! Tau Viwavenena, avi tuta dewaia ivinꞌ‑omo, ka avi iaiaya adueyei anꞌ‑anamanei vivane auyewana vi‑maupwani?” ");
INSERT INTO mvn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ka vona‑nau‑patei, ivona, “Udune‑vivinimi, iuna apaina tau viam‑nonona habuhabui inꞌ‑omo, ka yai nuanua inonomi. Wayahina, aitamoata aitamoata wayahia ivonevonemi, ina‑vona, ‘Vona ahiahina, yauke Tau Ito‑yavuha.’ Kadu ina‑vona, ‘Auyewa pai nau‑yehata vi‑maupwani.’ Kate ataina avonemi, eha yai vona unononi, ka eha uvi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka apaina havia ka vi‑naua vaneana unononi, ka eha nau‑wawanimi umatamatauta wayahina. Iuna naona dewaia nau‑wawani ivinꞌ‑omo, kate auyewa pai nau‑yehata eha visina.” ");
INSERT INTO mvn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ka yana vona wayahia neine, ivona, “Tuta tepakaia papani mani papani nui ivi‑naua, kadu pai veimea mani pai veimea nui inau‑havia. ");
INSERT INTO mvn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ka tuta tepakaia wayahina yoyoyo anani ivinꞌ‑omo, ka am navovo kadue muya tanopi habuhabuna wayahina ivinꞌ‑omo‑nananena. Kadu dewa ka iaiaya ivinꞌ‑omo wahuma wayahina, ka tomotau imatamatautei. ");
INSERT INTO mvn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dewaia tanoi tuta munia ivinꞌ‑omo. Ka tuta naona, tomotau ipoyꞌ‑avinimi, ka idewa‑yaiyaiemi, ka manua tapanono wayahia iomanemi, ka manua yohona nihenia iyohonimi, kadu ivi‑au‑minimi kiniV mataia ka tau veimea mataia. Ka dewaia habuhabui idedeweyemi iuna uvitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka tuta‑naia nihenia itomi nau‑wawanimi tomotau‑naia umataedai wayahiu. ");
INSERT INTO mvn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka nau‑wawanimi ataina uvi‑nua‑dadani vivane auyewana wayahina eha yami ipupu‑tana‑pota wayahina umai‑nuanua. ");
INSERT INTO mvn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iuna auyewana wayahina yauke taua yami vona‑nau‑pata kadu yau nua‑uya avenemi, e itomi ami pata ami havia yai vi‑tanai ubagibagi‑tawanei, eha una‑ini‑yauyau mataia. ");
INSERT INTO mvn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka amamami, ka ayoyomi, ka vavaneimi, ka yami yoko, ka yaiami ivauyemi ami havia wayahia, ka tupwai wayahimia inau‑vi‑anigimi. ");
INSERT INTO mvn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ka au wava wayahina tomotau habuhabui inau‑nikonikoiemi. ");
INSERT INTO mvn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka eha aitam ununumi apanana ivi‑goyo‑vavahi. ");
INSERT INTO mvn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ka aituhu utoha‑vi‑anai, ka aituhu uvi‑ateteyeu auyewaia vitai nihenia, apaina yawai‑vavaha uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ka vona ahiahina tuta tepakaia wayahina Ierusalem a havia ududueyei itutu‑vivinimi, ka imaꞌ‑potapotami, akanai dewaia vivane iaiaya wayahimia, ka tuta eha ani‑hoina na‑iakwa wayahina, e Ierusalem ivita‑vovoni. ");
INSERT INTO mvn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka avaha iaiayaia udueyei deina, aituhu aviyaivia wayahimia papani Iudea nihenina umamaei, nau‑wawanimi oya wayahia una‑novo. Ka aituhu aviyaivia wayahimia meagai Ierusalem nihenina umamaei, nau‑wawanimi meagaina uni‑tawanei. Ka aituhu aviyaivia wayahimia udana umamaei, nau‑wawanimi eha meagai Ierusalem nihenina una‑nu. ");
INSERT INTO mvn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iuna auyewana vivane dewa‑yaiyai anꞌ auyewa Ierusalem wayahina. Ka tau apa‑taputapu habuhabui, tuta nonova a itoava tuta ataina wayahina, auyewana iapa‑taputapuei, ka auyewana yai iginumaia na‑nau‑yehai. ");
INSERT INTO mvn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aioi! Iuna auyewana wayahina aituhu avi vaivine iamwanainahe, o avi vaivine ivivi‑nunu, taui vitana ananina ivaniahei, ka taui imatamatauta ananina. Ka papani taina nihenina tomotau habuhabui inua‑vita ka imatamatauta. Iuna tau vi‑meagai taina dewa‑yaiyai ananina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ka Ierusalem a havia tupwai ivunuvunumi punumai matana wayahina, kadu tupwai iyohoyohonimi, e itainimi papani papani wayahia. Ka Yaubada taui eha me Iudea yai tuta nꞌ‑awaehei veimea manimaninina wayahina meagai Ierusalem iva‑taunei, ka iveimeyei deina a itoava yai tuta na‑iakwa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ka apaina tomotau iaiaya idudueyei babau wayahina, ka wahava wayahina, ka wadima wayahia. Ka tau maꞌ tanopi nuai vi‑tupatupa, ka imatamatauta ananina. Iuna yahina nupunina ani‑vainena idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kadu apaina wadima habuhabui ai venavenau wahuma ivo‑vinei venavenau tunina wayahina. Ka tupwai tomotau, avaha iaiayaia idudueyei, inꞌ‑ate‑viviha ananina, kadu nuai nihenina inꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka dewaia habuhabui ina‑iakwa, e munia yauke, Tauna Vi‑tomotau, yau bagibagi kadu didigau ananina nui amavi‑havine tanopia you nihenina, ka tau maꞌ tanopi idudueyeu. ");
INSERT INTO mvn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ka avi tuta dewaia tanoi ivi‑putu ivinꞌ‑omo, nau‑wawanimi unꞌ‑ate‑vatu, kadu nau‑wawanimi udewa‑haiawa. Iuna tuta eha ani‑hoina na‑iakwa wayahina, e yami ito‑yavuha uvaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ka ya pai vo‑vi‑maheta taina iakwa, e tauna vona tana‑minikuna aitam venei, ivona, “Madaiba unuani, o kadi ai habuhabuna unuani. ");
INSERT INTO mvn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aituhu ai avaha yawaina vovoui ivi‑putu itabo‑havine ududueyei, vona ahiahina, itomi uanamanei nau‑sisi ana tuta omomo, ka tuta eha ani‑hoina na‑iakwa wayahina uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka deinake, aituhu avi tuta iaiayaia habuhabui wahuma ududueyei, nau‑wawanimi unꞌ‑anamanei tuta eha ani‑hoina na‑iakwa wayahina, Yaubada ya pai veimea vi‑mwaupwani. ");
INSERT INTO mvn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Memeanina nuami vi‑tupatupa, kate avonemi, naona dewaia habuhabui ivinꞌ‑omo. Ka munia, tomotau yai tuta tanopia na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kadu yau vonana vivane vona‑vavaha. Aituhu wahuma kadu tanopi imaiova, eha uva‑hamwahamwana, ka yau vonana uvitumahanei, iuna yau vona na‑maꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ka itomi nau‑wawanimi taumi udune‑vivinimi. Iuna memeanina yau mavi‑havine tanopia nuami na‑pania, ka uvi‑putu uamam‑didiga, kadu daudau bagibagina unimnim‑didiga, kadu tanopi ana dewa nuami nau‑vi‑anai. Aituhu udedewe deina, apaina auyewa pai nau‑yehata na‑vo‑kwayavonina vinꞌ‑omo wayahimia ami vuhata deina. ");
INSERT INTO mvn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka auyewana na‑omo vivane tau maꞌ tanopi habuhabui ai vuhata. ");
INSERT INTO mvn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wayahina, nau‑wawanimi tuta habuhabuna wayahina udune‑vivinimi, kadu nau‑wawanimi tuta habuhabuna wayahina uhidahida Yaubada wayahina, e tauna bagibagi nꞌ‑awaehemi. Aituhu deina, avi tuta dewaia vitai habuhabui ivinꞌ‑omo eha ai pata ivi‑peumi, kate itomi utoha‑vi‑anai. Na‑iakwa, yami dewa‑haiawa nui yauke, Tauna Vi‑tomotau, mataua umimini yau vinꞌ‑omana anꞌ auyewa wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ka Iesu yana wiki pai nau‑yehata nihenina, auyewa aitamoata aitamoata wayahina, Manua Vito‑pota mamaei, ka tauna tomotau wayahia viwavenena. Ka babau onuonu ana tuta aitamoata aitamoata wayahina, e Ierusalem ni‑tawanei iopu Oya Olive wayahina, ka tenoke daudauva, ino‑ainei. ");
INSERT INTO mvn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka mana‑putua aitamoata aitamoata wayahina, tomotau habuhabui iomomo Manua Vito‑pota wayahina, e ya viwavenena inonononi. ");
INSERT INTO mvn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ka avaha Itouvuha Toneina vi‑maupwani. Ka toneina wayahina me Iudea ai palaua iapuni tunina, eha a pai vo‑vi‑nata nui ivo‑vine. ");
INSERT INTO mvn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka tau vi‑nomu mata‑genai, kadu Mosese ya veimea a tau viwavenena yai nuanua ananina Iesu ipoyꞌ‑avini, ina‑nau‑vi‑anigi. Ka eha yai nuanua tomotau yoko inua‑goyo dewana wayahina, ka eha yai nuanua ivitana‑wahewahe. ");
INSERT INTO mvn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka tuta aitamoata wayahina Satana omo Iudasa me Kariota wayahina, ka nuana inui, e veimeyei. Iudasa aitam Iesu a tau vi‑muni‑waiwai ai yau 12 wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ka Iudasa omo tau vi‑nomu mata‑genai kadu Manua Vito‑pota a tau nau‑havia wayahia, e nui iaipupu medeina memeanina tauna Iesu na‑vauyei nimaia. ");
INSERT INTO mvn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ka tau eta‑naonao‑naia idewa‑haiawa Iudasa yana vona wayahina, ka ivonei kina tupwai ivenei a nau‑pata wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ka Iudasa taui nui iawaehei aitamoata deina. Kadu iawaehei tauna potapota ka dunedune, ka aitam auyewa o kadi ioyoma wayahina tomotau yoko eha Iesu nui, ka avi tuta tauna avaha anamanei deina, akanai na‑mataedai, e taui ipoyꞌ‑avini. ");
INSERT INTO mvn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ka Itouvuha Toneina anꞌ auyewa vinꞌ‑omo, ka ioyomana me Iudea nau‑wawani Itouvuha vahitau sipiV ivunuvunui, ka palaua tunina nui ianiania. ");
INSERT INTO mvn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Wayahina, Iesu Pita ka Ioni ainua vi‑nua‑dadanei, ka vi‑tunei, ine vivane ieta‑naoi, e yai Itouvuha Toneina inau‑vevewanei, ivo‑vi‑aiaia habuhabui wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka taui ivi‑tanaiei, ivona, “Aveta baina nuanuam wayahika avo‑vi‑aiaia?” ");
INSERT INTO mvn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ka vona‑nau‑patei, ivona, “Avi tuta unuinu Ierusalem nihenina, onoto aitam ya pai goi daudau avavanei vaniahami. Ka onotona uvi‑muniei, e aitam manua na‑nui. Ka itomi kadue manua‑nana nihenina una‑nu. ");
INSERT INTO mvn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ka tau vi‑manua‑nana uvonei, una‑vona, ‘Yama Tau Viwavenena vi‑tanaiem, “Bubuna‑honota taua a tau vi‑muni‑waiwai nui Itouvuha Toneina anꞌ‑ania aveta?” ’ ");
INSERT INTO mvn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","E tauna aitam bubuna‑honota ananina manua hetana mamaei na‑viwavenemi, ka avaha ivo‑vi‑aiaia sita kadu vei wayahia, kadu gugua habuhabui deina. Ka bubuna‑honota‑nana nihenina anianina uvo‑vi‑aiaia wayahika.” ");
INSERT INTO mvn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ka ainuai ine, ka dewaia aitamoata aitamoata ivaniahei Iesu yana vona wayahia deinake, ka Itouvuha Toneina anianina ivo‑vi‑aiaia wayahi. ");
INSERT INTO mvn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ka avaha babau ionu iakwa, e Iesu tauna a tau vi‑muni‑waiwai nui idaudauva, ka nui iamam. ");
INSERT INTO mvn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ka vonei, ivona, “Nuanuau ananina naona itomi nui Itouvuha Toneina anianina taina kanꞌ‑ania, e munina au viha ananina avaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iuna, vona ahiahina, aniani taina vivane pai nau‑yehata wayahiu tanopia. Ka apaina Yaubada ya pai veimea nihenina tomotau Itouvuha Toneina anꞌ anamana tunutunuhina inꞌ‑anamanei, ka auyewana wayahina anꞌ‑ani‑havinei.” ");
INSERT INTO mvn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wayahina, aitam vei na wainanaV epei, ka nau‑kaiwa Yaubada wayahina, ka vonei, ivona, “Vei taina unꞌ‑epei, ka aitamoata aitamoata wayahimia uvo‑patei una‑nimi. ");
INSERT INTO mvn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka avonemi, tuta ataina a itoava Yaubada ya pai veimea a vinꞌ‑omana wayahina, eha kadu aitam tuta wainaV ana‑nim.” ");
INSERT INTO mvn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ka nimna iakwa, e palaua epei, ka nau‑kaiwa Yaubada wayahina, ka pakeui, ka venei, ka vonei, ivona, “Palaua taina ininiu, ka yauke awaehei wayahimi. Dewa taina unuanuani, ka udedewei pai nuana wayahiu.” ");
INSERT INTO mvn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ka anianina iakwa, e kadu aitam vei na wainaV epei, ka venei, ka vonei, ivona, “Vei taina Yaubada yanꞌ awaeha vovouna tau maꞌ tanopi wayahia, ka yauke dayahiu awaehei vivane awaehana vovouna vi‑putu. ");
INSERT INTO mvn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kate onoto‑nana apaina na‑vauyeu, ataina tuta baina wayahina nui kamam. ");
INSERT INTO mvn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Apaina yauke, Tauna Vi‑tomotau, anꞌ‑aniga Iginuma apa‑taputapu wayahiu deina, kate aioi onoto‑nana na‑vauyeu wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ka a tau vi‑muni‑waiwai avaha ya vonana inononi, taui nuai vi‑tupatupa, ka matataui ivi‑tanatanaiei, ivonavona, “Kaiwadi, koiaka wayahikaia ana pata dewana na‑dewe?” ");
INSERT INTO mvn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kadu, ivi‑putu inau‑vonuvonu, iuna ivi‑tanatanaiei, “Koiaka wayahikaia vivane ana wava ananina? Yauke, a?” ");
INSERT INTO mvn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wayahina, Iesu vonei, ivona, “KiniV taui eha me Iudea wayahia iveimeyei veimea toyoina wayahina. Kadu taui tau kaikaiwabo tanopia ai heta wayahia ivona, ‘Itoai tomotau yai tau vo‑taitai,’ ka ai heta iapa‑vidovidohei deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka eha nau‑wawanimi udedewe deina. Aituhu koiaka wayahimia ya nuanua apaina anꞌ anamana na‑nata, tauna nau‑wawani na‑nua‑opu aitam tevana deina. Ka kadue yami tau eta‑naonao nau‑wawani tauna vi‑tau paisewa habuhabumi wayahimi. ");
INSERT INTO mvn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aituhu aitam onoto manuena amam, ka aituhu kadu aitam onoto paipaisewa, e aniani vo‑vi‑aiaia, koiaka ana wava ananina? Tau maꞌ tanopi medeina ivonavona? Vona ahiahina, ivoneka, ‘Tauna manuena amam ananina.’ Kate udueyeu. Yauke avinꞌ‑omo tanopia vivane avi‑tau paisewa habuhabumi wayahimi. Wayahina, yau dewa eha tau maꞌ tanopi yai kiniV yai dewa deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vona ahiahina, itomi avaha umimini toyoina wayahiua yau tuta vitaia habuhabui wayahia. ");
INSERT INTO mvn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Akaka, avi tuta Amau yau pai veimea veneu, akanai avo‑patami, e nui kaveimeyei kiniV deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka yau pai veimea nihenina nui kamam kadue kanimnim. Ka kadue aitamoata aitamoata wayahimia anꞌ‑awaehemi pai maꞌ ahiahina wayahina umanuena, kadu aitamoata aitamoata wayahimia aitam me Isiraeli yai dede ai yau 12 wayahia unau‑yanahi.” ");
INSERT INTO mvn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ka Iesu ivona Simoni wayahina, “Simoni, Simoni enononi. Satana avaha anꞌ awaeha vaniahei Yaubada wayahina, e habuhabumi na‑nau‑dadanimi, e goyona nihenimia na‑vaniahei, aitam tau baguna witiV utuna pouna ka utuna wagana na‑tana‑vewani deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka Simoni, yauke avaha aviama wayahima, e yam vitumahana wayahiu eha evo‑haini. Apaina ena‑ihanua, ka kadu ena‑peu. Ka munia, avi tuta wayahina emavina wayahiua, ka evi‑muni‑havineu, wamke nau‑wawanim yam bagibagi vovouna vavaneim evo‑patai.” ");
INSERT INTO mvn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ka Pita ivona, “Kauvea, yam vonana eha tunuhina, iuna ataina tuta yau ate‑vatu mamaei. Kadue aituhu ipoyꞌ‑avinim itainim manua yohona wayahina, akanai au pata itainiu manua yohona wayahina deinake, o kadi aituhu inau‑vi‑anigim, akanai yawaiu awaehem inau‑vi‑anigiu deinake.” ");
INSERT INTO mvn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ka Iesu vona‑nau‑patei, ivona, “Eha. Pita, avona ahiahina wayahima, ataina tuta a itoava mana‑putua wayahina evi‑ebueu tuta aitonu wayahia, ka ena‑vona wayahiu, ‘Eha onotona atꞌ‑anamane!’ Ka munia kamkam onotona yana tou kanononi.” ");
INSERT INTO mvn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ka ya vonana Pita wayahina iakwa, e tauna a tau vi‑muni‑waiwai habuhabui vi‑tanaiei, ivona, “Nonova habuhabumi awakabimi avi‑tunemi Vane Ahiahina unaunau‑wahei. Eha yami kina, ka eha ami kode, ka eha ami ae‑yapayapami. Ka medeina? Aviani wayahina uvi‑kutakuta?” Ka taui ivona‑nau‑patei, ivona, “Eha aitam. Ama pata ana noe.” ");
INSERT INTO mvn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ka Iesu vonei, “Ataina tuta wayahina avonemi tunina. Ataina aituhu ami kode na kinana wayahimia, nau‑wawanimi unꞌ‑epei, ka kadue aituhu yami kubukubu wayahimia, nau‑wawanimi unꞌ‑epei. Ka aituhu eha yami inama, nau‑wawanimi ami kwama tupwai una‑imwaneyei, e inama uvi‑maiei. ");
INSERT INTO mvn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iuna nonova aitam tau apa‑taputapu wayahiu iginumi deina, ivona, ‘Kadu tauna tau goyogoyoi nui idewa‑yaiyaiei.’ Ka tuta eha ani‑hoina na‑iakwa wayahina, iginumana wayahiu a nau‑yehai na‑vaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka taui ivona‑nau‑pata, ivona, “Kauvea, edueyei. Yama inama ainua taina.” Ka ivona, “Akanai. Ana pata deina.” ");
INSERT INTO mvn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ka Itouvuha Toneina iakwa, tauna a tau vi‑muni‑waiwai nui bubuna‑honota hetana ini‑tawanei, ka yana dewa deina omo Oya Olive wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ka avaha ivinꞌ‑omo, wayahia ivona, “Tuta eha ani‑hoina na‑iakwa wayahina, e Satana na‑nau‑dadanimi. Wayahina, nau‑wawanimi uviama Yaubada wayahina, e bagibagi na‑venemi, ami pata utoha‑vi‑anaimi.” ");
INSERT INTO mvn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ka vonana iakwa, e tauna a tau vi‑muni‑waiwai ni‑tawanei, ine tupwana, onoto ana pata hanu na‑one wayahina deina, ka aena vi‑tupa‑gum, e viama. Ka yana vona deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amau, aituhu yam nuanua, aviamem hidahida tepaua potapotau ebou‑potei wayahiua. Ka yau nuanua ananina yam nuanua vinꞌ‑omo, eha yauke yau nuanua.” ");
INSERT INTO mvn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka aitam anelose wahuma opu‑me, e vo‑vi‑vatui. ");
INSERT INTO mvn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ka nuana ivita ani‑vainena, wayahina viama bagibagina, ka a mweahau opuopu tanopia dayaha bunuvina peupeu deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ka Iesu ya viamana nau‑yehai, e mini, mavina a tau vi‑muni‑waiwai wayahia, ka vaniahei vivane iaino‑ainei, iuna yai nua‑vita ananina wayahina iaihanua. ");
INSERT INTO mvn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ka vonei, ivona, “Ia! Uaino‑ainemi! Umini, ka uviama Yaubada wayahina, iuna apaina ami nau‑dadana na‑omo, ka aituhu eha uviama, apaina goyona udewei.” ");
INSERT INTO mvn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka Iesu ya vonana eha ta‑nau‑yehai, ka yoko avaha ivinꞌ‑omo, ka Iudasa eta‑naonaoi. Tauna Iesu a tau vi‑muni‑waiwai ai yau 12 wayahia aitam. Ka Iudasa omo Iesu nepena, e nevanuana na‑maoi. ");
INSERT INTO mvn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ka Iesu vi‑tanaiei, “Iudasa, eha ena‑ini‑yauyau eomo yauke, Tauna Vi‑tomotau, wayahiua, ka evauyeu aitam mao wayahina, a?” ");
INSERT INTO mvn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ka avaha a tau vi‑muni‑waiwai aviani vinꞌ‑omo ianamanei, ivi‑tanaiei, ivona, “Kauvea, medeina? Nau‑wawaniai inama wayahia avi‑naua?” ");
INSERT INTO mvn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka aitam wayahia eha ta‑potapota Iesu ya vona‑nau‑pata wayahina, ka yana inama si‑naia, ka tau vi‑nomu ananina a tau paisewa aitam tanihana ateina tana‑honoi. ");
INSERT INTO mvn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ka Iesu ivona, “Ia! Ugenuana!” Ka Iesu onotona tanihana vo‑dadani, e vo‑vi‑aiaia. ");
INSERT INTO mvn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iakwa, Iesu magigino tau vi‑nomu mata‑genai, ka Manua Vito‑pota a tau nau‑havia, ka kadu ononotoi anani wayahia, taui avaha ivinꞌ‑omo ipoyꞌ‑avini, ka vi‑tanaiei, ivona, “Yau dewa medeina? Aviani unuanua? Taua vivane havia a tau vi‑putu aitam, o medeina? Aviani iuna na inamami ka na punumaimi uvinꞌ‑omo wayahiua upoyꞌ‑aviniu? ");
INSERT INTO mvn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Avaha uanamanei, auyewa aitamoata aitamoata wayahina nui kamamaei Manua Vito‑pota nihenina, kate auyewaia nihenina eha uta‑vo‑vi‑aviniu. Ka ataina tuta udedewei taina deinake, iuna ataina tuta Satana ya veimea bagibagina.” ");
INSERT INTO mvn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wayahina, Iesu ipoyꞌ‑avini, ka itaini ineiei tau vi‑nomu ananina ya manua wayahina. Ka Pita enoma vi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ka manua upuna wayahina taui Iesu ipoyꞌ‑avini inau‑hohona ka avaha ai ipoui. Ka Pita omo ka nui imanuena. ");
INSERT INTO mvn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka aitam tau paisewa vavinena avaha Pita manuena dueyei, e habuhabui wayahia ivona, “Onoto taina Iesu nui adueyei.” ");
INSERT INTO mvn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka Pita vi‑ebua, ivona, “Vavinem, eha tauna atꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ka munia, tuta eha ani‑hoina iakwa wayahina, aitam onoto Pita dueyei, e vonei, ivona, “Kadu wamke aitam a tau vi‑muni‑waiwai wayahia!” Ka Pita ivona, “Ia! Yauke eha!” ");
INSERT INTO mvn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ka babau aitamoata munia, e kadu aitam onoto yaiana wayahia ivona, “Eha vitupu, onoto taina tauna nui ini‑awana. Iuna ya ponaitu vivane me Galili yai ponaitu!” ");
INSERT INTO mvn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ka Pita vonei, ivona, “Eha! Avonem eha atꞌ‑anamane aviani wayahina evonavona!” Ka Pita ya vonana eha ta‑iakwa, ka kamkam onotona toutou. ");
INSERT INTO mvn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Kauvea magigino, e matana onei Pita matana wayahina, ka dune‑vi‑anai. Ka Pita Iesu yana vona nuani tutana Kauvea ivona, “Ataina naona evi‑ebueu tuta aitonu wayahia, ka munina kamkam onotona yana tou.” ");
INSERT INTO mvn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wayahina, Pita nuana ivita ananina, e iopu vuvunaha ka tou vi‑mohai, iuna ya ini‑yauyau ani‑vainena. ");
INSERT INTO mvn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ka tau nau‑havia‑naia Iesu idune‑vi‑avini ivi‑putu ivi‑waipoei ka ivunuvunui. ");
INSERT INTO mvn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka kadu matana ana bwaꞌ iyohoni, ka yai vi‑waipo wayahina ivunuvunui, ka ivi‑tanatanaiei, ivona, “Wamke tau apa‑taputapu aitam, a? Akanai ka, koiaka vunum?” ");
INSERT INTO mvn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ka kadu vona goyona habuhabuna wayahina imana‑giboei deina. ");
INSERT INTO mvn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka waganai gininia wayahina, me Iudea ai tau veimea inau‑hohona, vivane ononotoi anani, ka tau vi‑nomu mata‑genai, ka kadu veimea a tau viwavenena. Ka Iesu iomanei niwania ivi‑au‑mini. ");
INSERT INTO mvn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ka ivonei, ivona, “Aituhu wamke vivane Tau Ito‑yavuha‑nana, akanai evoneai deina.” Ka Iesu vona‑nau‑patei, ivona, “Aituhu avonemi, eha uvitumahaneu, ");
INSERT INTO mvn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka aituhu avi‑tanaiemi, ‘Aviani wayahina eha uvitumahaneu, vivane yauke Tau Ito‑yavuha?’, eha uvona‑nau‑patau tunuhina. ");
INSERT INTO mvn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ka tuta tepakaia eha a ito‑vewana wayahina, yauke, Tauna Vi‑tomotau, amanuena Yaubada Bagibagi‑vainena ateina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wayahina, habuhabui ivi‑tanai‑havine, ivona, “Kaiwadi, wamke vivane Yaubada Natu‑hoina, a?” Ka vona‑nau‑patei, ivona, “Aituhu uvonavona wayahiu deina, yami vona tunuhina.” ");
INSERT INTO mvn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wayahina, taui matataui ivona, “Akanai. Eha nau‑wawanika mani tomotau kavaniahei ya goyona ihaeyei wayahikaia. Iuna avaha yana vona vitupu kanononi, ka vonana ana heta wayahina nau‑wawanika kadewa‑yaiyaiei.” ");
INSERT INTO mvn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wayahina, tau nau‑hohona‑naia habuhabui imini, e Iesu itaini ineiei me Rom ai tau veimea ananina Ierusalem nihenina wayahina, ana wava Pilate. Ka yokoia yai nuanua vivane Pilate yai nuanua Iesu wayahina nꞌ‑awaehei. ");
INSERT INTO mvn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ka ivi‑putu Iesu imana‑giboei Pilate matana, ka ivitupu wayahina, ihaeyei, ivona, “Onoto taina ya viwavenena anononi, ka ya nuanua itoai me Isiraeli habuhabuai SisaV ya takesiV avihahaiei. Ka apaina itomi me Rom unua‑goyo wayahiaia dewana wayahina. Kadu tauna ana heta wayahina vonavona, ‘Yauke vivane Tau Ito‑yavuha, aitam kiniV.’” ");
INSERT INTO mvn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wayahina, Pilate Iesu vi‑tanaiei, ivona, “Kaiwadi, wamke me Iudea yai kiniV, a?” Akaka Iesu vonei, ivona, “Ika, yam vonana deinake.” ");
INSERT INTO mvn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wayahina, Pilate tau vi‑nomu mata‑genai‑naia ka yokoia vonei, ivona, “Eha aitam onoto taina ya goyona ata‑vaniahe.” ");
INSERT INTO mvn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka taui vona panina iboui, ivona, “Me Iudea habuhabuai avitana‑wahewahe kadu anau‑vonuvonu, iuna onoto taina ya nau‑wahe wayahina dewa‑panieai. Tauna vi‑putu papani Galili nihenina, ka kadu omo baina wayahina dedewei aitamoata deina!” ");
INSERT INTO mvn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka Pilate avaha yai vonana nononi, e vi‑tanaiei, ivona, “Kaiwadi, onoto taina vivane me Galili, a?” ");
INSERT INTO mvn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ka taui ivona, “Ika.” Wayahina, Pilate veimeyei ineiei KiniV Erodi wayahina, iuna papani Galili vivane Erodi ya pai veimea. Ka auyewana wayahina Erodi meagai Ierusalem nihenina mamaei. ");
INSERT INTO mvn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ka ineiei Erodi wayahina, ka Erodi ya dewa‑haiawa nui dueyei. Iuna nonova a itoava auyewana wayahina Erodi potapota‑wayohe na‑dueye. Iuna tomotau voneyei Iesu paisewa bagibagina dedewei. Ka Erodi ya nuanua ananina aitam dewa‑bagibagina na‑dueyei matana. ");
INSERT INTO mvn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wayahina, Erodi vi‑tanai habuhabui wayahia Iesu vi‑tanatanaiei, kate Iesu eha aitam wayahia ta‑nau‑pata. ");
INSERT INTO mvn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka tuta aitamoata wayahina tau vi‑nomu mata‑genai, kadu veimea a tau viwavenena yai nua‑goyo ananina nui iapa‑goyogoyoei Erodi matana. ");
INSERT INTO mvn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ka kadu Erodi tauna ya tau nau‑havia nui Iesu ivi‑waipoei kadu ivinepei. Ka kiniV ana kwama ivi‑weteni yai pai vinepa wayahina, e ivi‑tune‑havinei Pilate wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ka nonova a itoava auyewana wayahina Erodi ka Pilate ainua ivi‑mohi‑pata, ka auyewana wayahina ivi‑niana. ");
INSERT INTO mvn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ka Pilate tau vi‑nomu mata‑genai‑naia, ka ononotoi anani‑naia, ka tomotau yokoia honei inau‑hohona, ");
INSERT INTO mvn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","e vonei, ivona, “Onoto taina wayahiua uomanei, e uhaeyeu tauna tomotau dewa‑paniei me Rom ivi‑naua. Ka avaha matamia anau‑dadani, ka eha aitam aviani wayahina uvitevitei ata‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kadu Erodi deina, eha aitam goyona wayahina ta‑vaniahe. Wayahina, tauna vi‑tune‑mavineu. Ka habuhabumi avaha uanamanei, onoto taina eha aitam dewa goyona ta‑dewe. Wayahina, eha nau‑wawani patana aniga na‑vaniahe. ");
INSERT INTO mvn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Akaka a dewa‑yaiyai yavunai ana heta wayahina aveimeyei. Na‑iakwa, ana‑ito‑yavuhi. Ana pata deina.” ");
INSERT INTO mvn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka yoko‑naia avaha Pilate ya vonana inononi, ivi‑honei movi ani‑vainena wayahina, ka ivihahaiei, ivona, “Tauna nau‑wawani nꞌ‑aniga! Itoai yama nuanua Barabasa ena‑ito‑yavuhi wayahiaia.” ");
INSERT INTO mvn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nonova Barabasa‑nana tupwai tomotau eta‑naoi idewa‑paniei, e me Rom ivi‑naua, kadu tauna tomotau nau‑vi‑anigi. Wayahina, me Rom ipoyꞌ‑avini, ka manua yohona nihenina iyohoni mamaei.) ");
INSERT INTO mvn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ka Pilate nuanuana Iesu na‑ito‑yavuhi. Wayahina, yokoia viama‑havine wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kate taui ivi‑hone‑havihavine movi bagibagina wayahina, ivonavona, “Ai nahanahana wayahina etutu‑pwatei! Ai nahanahana wayahina etutu‑pwatei!” ");
INSERT INTO mvn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate yana vona vꞌ‑itonuna wayahina vi‑tanaiei, ivona, “Aviani wayahina atutu‑pwatei? Ya goyona aviani? Eha aitam ya goyona patana aniga wayahina ata‑vaniahe. Wayahina, yau nuanua adewa‑yaiyaiei ana heta. Na‑iakwa, ana‑ito‑yavuhi, ka ana pata deinake.” ");
INSERT INTO mvn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kate yoko‑naia ivi‑honehone‑bagibagi, ivonavona, “Ai nahanahana wayahina etutu‑pwatei!” Ka eha ita‑genuana. ");
INSERT INTO mvn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wayahina munia, Pilate awaehei, e Iesu yanꞌ aniga veimeyei. ");
INSERT INTO mvn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka onoto‑nana nonova tomotau eta‑naoi idewa‑paniei, vivane tau nau‑vi‑aniga aitam iyohoni manua yohona nihenina mamaei ito‑yavuhi, yokoia yai nuanua deina. Ka kadu Pilate yokoia yai nuanua Iesu wayahina awaehei deina. ");
INSERT INTO mvn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ka Iesu ineiei itaini etawana vivane itutu‑pwatei. Ka etawana wayahina aitam onoto ana wava Simoni ivaniahei, tauna me Sirene aitam, ka auyewana wayahina novi wayahina omomo megeia. Ka Iesu anꞌ ai nahanahana Simoni ivenei, ka inau‑vi‑nehenehei vivane Iesu vi‑muniei nꞌ‑avanei na‑omo tutu‑pwata a papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ka yoko ananina Iesu ivi‑muniei, ka yoko‑naia nihenina vaivine tupwai tauna wayahina itoutou kadu ivi‑mohai ananina. ");
INSERT INTO mvn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka Iesu magigino wayahia, e vaivinei vonei, ivona, “Itomi Ierusalem a vaivine eha nau‑wawanimi wayahiu uvi‑mohai. Kate nau‑wawanimi itomi taumi wayahimi kadu natunatumi wayahi uvi‑mohai. ");
INSERT INTO mvn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iuna tuta vitana ananina na‑omo. Ka auyewana wayahina uvonei, una‑vona, ‘Aituhu aviyaivia wayahikaia gagagani, taui vivane idewa‑haiawa, kadu aituhu aviyaivia wayahikaia nunui eha natui ivi‑nunu, taui idewa‑haiawa!’ Auyewana una‑vona deina. Iuna ami havia inꞌ‑omo, ka natunatumi ivunu‑neiei, ka uvi‑mohai ananina wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iginuma voneka deina, ivona, ‘Apaina tomotau oya wayahia ina‑ipupu, ina‑vona, “Oya, una‑peu tauai hetaia!” kadu oyaoyana wayahina ivi‑honei, ina‑vona, “Ubwaeai!” ’ ");
INSERT INTO mvn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iuna vona ahiahina, ataina tuta yauke, Tauna Vi‑tomotau, nui kamamaei. Yauke aitam ai yawayawaina deinake, kate taua eha aitam aviani tomotau taina wayahia. Iuna mosikuna ivi‑goyou. Ka apaina yauke eha wayahimia ata‑mamae. Ka auyewana wayahina, itomi ai pwavupwavuna deinake, ka auyewana wayahina, tomotau ivi‑goyo‑vainemi.” ");
INSERT INTO mvn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ka tau goyogoyona ainua kadu iepai, ka ineiei, e Iesu nui inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ka aitam papani wayahina ivinꞌ‑omo ana wava Ununu‑kabwa. Ka papani‑nana wayahina ai nahanahana tanopia iboui, ka Iesu itutu‑pwatei, e ivi‑tupa‑gumi, ivi‑au‑mini. Ka tau goyogoyo‑naia ainuai kadu ai nahanahana wayahia itutu‑pwatei, ka aitam Iesu ateina, e vꞌ‑inuana Iesu akenina ivi‑tupa‑gumi ivi‑au‑mini‑neiei. ");
INSERT INTO mvn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ka Iesu ivona, “Amau, yau nuanua tomotau taina enua‑piahi, iuna taui mwagemwagei, ka aviani idedewei ataina, eha itꞌ‑anamane.” Ka tau nau‑havia‑naia Iesu ana kwama iepei, e wayahia iviam‑wanene, ka aituhu koiaka wayahia viam‑wanene wayahina ivane, akanai tauna kwamana vituei. ");
INSERT INTO mvn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka yoko‑naia inau‑hohona imimini ka idunedune, ka yai tau eta‑naonao Iesu ivi‑waipoei, ivonavona, “O, mani tomotau ito‑yavuhi. Aituhu Yaubada vi‑nua‑dadanei vivane yaka Tau Ito‑yavuha, akanai ataina tuta nau‑wawani ana heta na‑ito‑yavuhi.” ");
INSERT INTO mvn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka tau nau‑havia‑naia kadu ivinꞌ‑omo matana ka ivi‑waipoei. Ka wainaV yuyuna iomanei, e itune‑vaneyei. ");
INSERT INTO mvn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ka ivona, “Aituhu wamke vivane me Iudea yai kiniV, akanai nau‑wawanim ena‑ito‑yavuhim.” ");
INSERT INTO mvn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ka anꞌ ai nahanahana unununa wayahina pai iaiava iginumi iboui, e tomotau ya goyona inꞌ‑anamanei, ka pai iaiavana ivona, “onoto taina me iudea yai kiniV.” ");
INSERT INTO mvn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ka tau goyogoyona aitam kadu apa‑goyogoyoei, ka yapoi, ivona, “Kaiwadi, wamke Tau Ito‑yavuha o eha? Aituhu wamke vivane Tau Ito‑yavuha, akanai nau‑wawanim am heta ena‑ito‑yavuhim, kadu ena‑ito‑yavuhiai!” ");
INSERT INTO mvn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kate tau goyogoyona papanina wayahina a niam yapoi, ivona, “Ia! Kaiwadi, Yaubada eha ematamataute, a? Iuna aka itonu aka dewa‑yaiyai aitamoata kavaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ka vona ahiahina, aka inua aka dewa‑yaiyai taina akanai, iuna dewa goyona kadewei, kate onoto taina eha aitam yana dewa goyona.” ");
INSERT INTO mvn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wayahina, onoto‑nana Iesu viamei, ivona, “Iesu, apaina yam pai veimea evaniahei, ka yau nuanua auyewana wayahina enuaniu.” ");
INSERT INTO mvn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ka Iesu vona‑nau‑patei, ivona, “Vona ahiahina, ataina tuta wayahina wamke yauke nui papani ahihi‑vainena kavaniahei, ka tenoke wayahina kamaꞌ‑vavaha.” ");
INSERT INTO mvn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ka tutana auyewa pouna vinꞌ‑omo, papani habuhabuna vi‑novanei a itoava babau aitonu iakwa wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dewana vinꞌ‑omoi iuna babau eha ya maheta. Kadu Manua Vito‑pota anꞌ awa‑pota mamanaina nihenina am‑yehi‑nuei. ");
INSERT INTO mvn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ka Iesu movina ananina wayahina vi‑hone, ivona, “Amau, nuau nimama aboui.” Ka ya vonana nau‑yehai, e yawaina iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ka me Rom yai tau nau‑havi‑naia ai tau eta‑naonao dewana dueyei, ka tauna Yaubada awa‑davei, ivona, “Vona ahiahina, onoto taina onoto tunutunuhina, eha tau goyona.” ");
INSERT INTO mvn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ka kadu tau mata‑wapuwapu habuhabui papani‑nana inau‑hohona idunedune avaha dewana idudueyei, e ianamanei vivane dewa goyona idewei. Wayahina, yai nua‑vita nui imavina yai megeia. ");
INSERT INTO mvn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka Iesu yaiana habuhabui, ka kadu vaivinei nonova papani Galili wayahina ivi‑muni‑waiwaiei, taui enoma imimini, ka kadue Iesu yanꞌ aniga idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aitam onoto ana wava Iosepa mamaei, ka tauna me Iudea yai tau eta‑naonao aitam, ka ya meagai ana wava Arimatea. Ka tauna onoto ahiahina ka tunutunuhina, ka tauna mani tau eta‑naonao yai vi‑nua‑dadana Iesu wayahina vihahaiei, iuna ya nuanua ananina Yaubada ya pai veimea na‑vaniahei. ");
INSERT INTO mvn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ka onoto‑nana Pilate wayahina omo, ka Iesu tau matena viamei na‑tavuni. Ka Pilate awaehei deina. ");
INSERT INTO mvn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wayahina, Iosepa omo, ka Iesu tau matena ai nahenahea epe‑opuei, e umei kaleko lineniV kavukavuna wayahina. Iakwa, omanei, e boui unuvovoa. Ka unuvovo‑nana ikayoi hanu nihenina, guba deina, ka vovouna, eha aitam tuta tau mate nihenina ita‑bou. ");
INSERT INTO mvn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ka auyewana auyewa pai vo‑vi‑aiai, iuna tuta eha ani‑hoina na‑iakwa wayahina, me Iudea yai tapanono vi‑putu babau onuonu ana tuta wayahina. Akaka Iosepa yana dewa dewa‑kwayavoni. ");
INSERT INTO mvn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka vaivinei Iesu nui papani Galili wayahina ivinꞌ‑omo, taui Iosepa ivi‑muniei, ka a unuvovo‑nana idudueyei vivane tau matena a pai vi‑ai ana dune medeina. ");
INSERT INTO mvn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ka imavina yai manua wayahina, e pai mau ahiahina bunama ahiahina nui ivinevinei ivo‑vi‑aiaia. Ka taui yai nuanua Iesu tau matena ibuyoi bunamana wayahina, e ivaivani deina. Kate auyewana wayahina taui eha ai pata, iuna auyewa tapanono. Wayahina, nau‑wawani ivi‑yawai Iginuma veimeyei deina. ");
INSERT INTO mvn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ka mana‑navia aina wiki anꞌ auyewa naona, ka mata‑hamwahamwanina wayahina, vaivine‑naia bunama‑nana avaha ivo‑vi‑aiaia iepei iomanei unuvovoa. ");
INSERT INTO mvn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ka tutana iomo unuvovoa, idueyei awana a pai bou‑pota hanu avaha ibuge‑mavinei. ");
INSERT INTO mvn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka unuvovo‑nana inui, ka nihenina eha Kauvea Iesu tau matena ita‑dueye. ");
INSERT INTO mvn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ka nuai vi‑tupatupa dewaia wayahina, ka tutana unuvovo nihenina imimini, vo‑kwayavonina onoto ainua nepeia imimini. Onoto‑naia ai kwama ana dune kavukavu‑vainena, vonaina deina. ");
INSERT INTO mvn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka vaivine‑naia imatamatauta ananina, wayahina ipeu iaiwaodu tepaia tanopia. Ka ononotoi vonei, ivona, “Aviani wayahina onoto yawayawaina unenenei tau aniga ya papani nihenina? ");
INSERT INTO mvn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tauna eha baina. Avaha mini‑havine! Ya vonana wayahimia unuani. Nonova papani Galili nihenina nui umamaei, ka tauna vonemi, ivona, ");
INSERT INTO mvn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Yauke, Tauna Vi‑tomotau, nau‑wawaniu iam‑veneneyeu tau goyogoyona wayahia, e ai nahenahea itutu‑pwatau, ka auyewa vꞌ‑itonuna wayahina anigea amini‑havine.’” ");
INSERT INTO mvn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ka avaha inononi, e vaivine‑naia ya vonana tanoi inuani. ");
INSERT INTO mvn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ka unuvovo ini‑tawanei, ka imavina Iesu a tau hae ai yau 11 wayahia, ka dewaia taina imataedai, kadu mani tomotau nui imamaei imataedai deina. ");
INSERT INTO mvn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ka vaivine‑naia ai wava vivane Mari me Magidala, e Ioana, e kadu aitam Mari (taui Iamesa ayona), ka kadu mani vaivine tupwai nui. ");
INSERT INTO mvn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka tau hae‑naia eha vaivine‑naia yai vona ita‑vitumahane, ka inuanua vaivine‑naia ivi‑kwavakwava, o viviwava viam‑nonona inau‑viviwavei. ");
INSERT INTO mvn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kate Pita mini, ka nau‑bwanunua unuvovoa, ka iwaodu tupwana ka matana onei nihenina, ka tau matena a pai bwaꞌ kalekoata lineniV ana heta imamaei dueyei. Ka nuana vi‑tupatupa ananina dewaia wayahina, ka unuvovona ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka auyewana wayahina Iesu a tau vi‑muni‑waiwai ainua ineine aitam meagai ana wava Emausi wayahina. Ka meagaina ana bana Ierusalem wayahina ai yau 10 kilomitaV deina. ");
INSERT INTO mvn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ka ainuai ineine ka dewaia habuhabui avaha Iesu wayahina ivinꞌ‑omo wayahia iaipuipupu. ");
INSERT INTO mvn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ka ivenavenau ka iaipuipupu, ka Iesu vinꞌ‑omo wayahia, ka nui ineine ");
INSERT INTO mvn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kate tauna eha tꞌ‑awaehe inꞌ‑anamane tauna koiaka. ");
INSERT INTO mvn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka vi‑tanaiei, ivona, “Aviani wayahina uaipuipupu tutana uvenavenau etawana?” Ka taui yai nua‑vita nui matai ione tanopia, ka etawana imini‑vaneneha. ");
INSERT INTO mvn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka aitam wayahia ana wava Kileopasi Iesu vi‑tanaiei, ivona, “Vona ahiahina, wamke am heta‑ohota meagai Ierusalem nihenina mwagemwagem dewaia wayahi ivinꞌ‑omo auyewa aitonuata iakwa wayahia, a?” ");
INSERT INTO mvn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wayahina Iesu vi‑tanaiei, ivona, “Avi dewaia?” Ka taui ivona, “Dewaia ivinꞌ‑omo Iesu me Nasareta wayahina. Tauna tau apa‑taputapu aitam, ka Yaubada matana kadue tomotau habuhabui mataia ya vonaia kadu ya dewaia bagibagina. ");
INSERT INTO mvn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ka yaka tau vi‑nomu mata‑genai, ka aka tau veimea onoto‑nana iam‑veneneyei me Rom ai tau veimea Ierusalem wayahina, ka tauna yanꞌ aniga ai nahenahea veimeyei. Wayahina itutu‑pwatei. ");
INSERT INTO mvn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ka itoai anua‑vaniaha vivane tauna yaka Tau Ito‑yavuha‑nana, kadu anuanua apaina tauna me Isiraeli habuhabuka na‑ito‑yavuhika. Ka dewaia ivinꞌ‑omo, ka auyewa aitonu avaha iakwa. ");
INSERT INTO mvn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ka ataina mata‑hamwahamwanina tupwai vaivine yama yoko wayahina iomo unuvovoa, e imavina, ka itoai nuai vi‑tupatupa yai mataeda wayahiaia wayahina. Iuna ivoneai Iesu tau matena avaha maiova, kadu ivoneai anelose idueyei yai dune nihenina, ka anelose‑naia ivonei Iesu vivane yawayawaina. ");
INSERT INTO mvn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wayahina, ononotoi tupwai wayahiaia inau‑bwanunua iomo unuvovo‑nana wayahina. Ka vona ahiahina, dewa habuhabuna ivaniahei vaivinei yai hae wayahiaia deina, ka eha Iesu tau matena ita‑dueye.” ");
INSERT INTO mvn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka Iesu vonei, ivona, “Ia! Vona ahiahina, itomi mwagemwagemi ananina! Iuna tuta tuta eha memeanina wayahimia tau apa‑taputapu yai iginuma aitamoata aitamoata uvitumahane! ");
INSERT INTO mvn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nonova tau apa‑taputapu dewaia tanoi habuhabui ivinꞌ‑omo Tau Ito‑yavuha wayahina iapa‑taputapuei, vivane naona tauna ana inahe vaniahei, ka munia didigana vaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Akaka tauna vi‑putu Mosese ya iginuma wayahina, ka neine tau apa‑taputapu habuhabui yai iginuma wayahina, ka mataina habuhabui tomatomani inononi, e iginuma habuhabui ana heta wayahina ai anamana vo‑vi‑mahetei ianamane‑vidohei. ");
INSERT INTO mvn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ka meagai Emausi wayahina ivi‑maupwani, ka Iesu matana onei etawana tepaia, tauna ya nuanua meagai omo‑nei deina, eha vi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wayahina, taui iviamei bagibagina, ivona, “Eha eneine, kate baina wayahiaia evi‑yawai yama manua nihenina. Iuna tuta eha ani‑hoina na‑iakwa wayahina babau na‑onu, ka auyewa taina avaha iakwa.” Wayahina, awaehei nui yai manua inui. ");
INSERT INTO mvn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ka tutana iamam, Iesu ai palaua epei, nau‑kaiwa Yaubada wayahina, pakeui, e vo‑patai. ");
INSERT INTO mvn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ka nuai am‑haui, ka ianamanei onoto‑nana vivane Iesu. Ka tauna wayahia maiova. ");
INSERT INTO mvn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ka ainuai ivi‑tanatanaiei, ivonavona, “Vona ahiahina, tutana etawana kaomomo ka tauna Iginuma vo‑vi‑maheteka, akanai nuaka epei, a?” ");
INSERT INTO mvn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wayahina, ainuai imini‑kwayavoni, e imavina Ierusalem wayahina, ka tau hae ai yau 11 ivaniahei, ka tupwai tomotau nui inau‑hohona imamaei, ");
INSERT INTO mvn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ka taui inau‑hohona habuhabui ivonavona, “Vona ahiahina, yaka Kauvea avaha anigea mini‑havine, ka Simoni avaha dueyei.” ");
INSERT INTO mvn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iakwa, e ainuai ivi‑putu, ka aviani vinꞌ‑omo etawana yokoia imataedai, vivane etawana nui ivenavenau, kadu medeina tauna ianamanei tutana palaua pakeui mataia. ");
INSERT INTO mvn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ka yaiai nui dewaia wayahia iaipuipupu, ka Iesu vinꞌ‑omo ka niwania mimini, ka vonei, ivona, “Kaiwa ananina. Yau nuanua nua gomagomanina uvaniahei.” ");
INSERT INTO mvn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka avaha idueyei, nuai vi‑tupatupa ananina kadue imatamatauta ananina. Iuna inuanua unupa idudueyei. ");
INSERT INTO mvn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka Iesu vi‑tanaiei, ivona, “Aviani iuna unua‑vita, ka aviani iuna uva‑hamwahamwana nuami nihenina? ");
INSERT INTO mvn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimau kadu aeu udueyei, ka ininiu uvo‑dadani. Ka unꞌ‑anamanei vivane yauke taua. Unupa eha na ininina, kadu unupa eha na numanumana, kate ainuai wayahiua.” ");
INSERT INTO mvn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ka avaha vonei deina, nimana kadu aena viwavenei idueyei. ");
INSERT INTO mvn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ka taui nuai vi‑tupatupa ananina, kadu idewa‑haiawa ani‑vainena, iuna eha memeanina ivitumahane vivane Iesu idudueyei. Wayahina tauna vonei, ivona, “Aniani baina wayahimia, o eha?” ");
INSERT INTO mvn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka iana avaha ibou‑anai ivenei ");
INSERT INTO mvn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","e mataia ania. ");
INSERT INTO mvn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iakwa, vonei, ivona, “Nonova nui kamamaei avonemi deinake. Iuna apa‑taputapu aitamoata aitamoata wayahiu Iginuma nihenina nau‑wawani ivinꞌ‑omoi. Apa‑taputapu tupwai Mosese ya veimea nihenina imamaei, ka tupwai tau apa‑taputapu yai iginuma nihenina imamaei, ka kadue tupwai Buki Sam nihenina imamaei.” ");
INSERT INTO mvn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ka avaha Iesu vo‑vi‑mahetei deina, nuai tana‑hau‑neiei, e ai pata Iginuma anꞌ anamana ianamanei. ");
INSERT INTO mvn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ka tauna wayahia ivona, “Nonova tau apa‑taputapu iginumi vivane yauke, Tau Ito‑yavuha, nau‑wawaniu inahe ananina avaniahei, ka munia, auyewa vꞌ‑itonuna wayahina anigea amini‑havine. ");
INSERT INTO mvn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka dewaia munia, nua‑vinana kadu goyona a nua‑piaha unau‑waheyei tau maꞌ tanopi habuhabui wayahia au wavea. Ka baina Ierusalem nihenina uvi‑putu unau‑wahe, ka tanopi habuhabuna ututu‑vivini. ");
INSERT INTO mvn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Itomi avaha dewaia habuhabui udueyei. Wayahina, itomi ami pata uvi‑tau hae wayahiu. ");
INSERT INTO mvn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka Amau am‑venena‑kavovo vona‑dabedabeyei, vivane bagibagi wahuma wayahina. Ka bagibagi‑nana avi‑tunei na‑omo wayahimia. Wayahina, ataina a itoava auyewana wayahina, nau‑wawanimi meagai taina nihenina umamaei ka am‑venena‑kavovona upotepotei.” ");
INSERT INTO mvn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ka ya vonana nau‑yehai, e eta‑naoi iomo meagai Betani a papani wayahina. Ka nimana tune‑vaneyei ka nau‑iaiavai. ");
INSERT INTO mvn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka nau‑iaiavana eha ta‑iakwa, ka niwanina ni‑tawanei ivane wahuma wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ka taui iawa‑davei, ka yai dewa‑haiawa ananina nui imavi‑havine Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ka auyewa aitamoata aitamoata wayahina Manua Vito‑pota nihenina imamaei, ka Yaubada iapa‑vidovidohei. Ana pata deina. Yauke Luke ");
INSERT INTO mvn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Naona Vona mamaei, e Vonana Yaubada nui imamaei, kadu Vonana vivane Yaubada. ");
INSERT INTO mvn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naona Vonana Yaubada nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dewa habuhabuna Vonana wayahina ivinꞌ‑omo, ka aituhu Vonana eha, dewa habuhabuna eha. ");
INSERT INTO mvn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yawai‑hoina Vonana nihenina mamaei, ka yawai‑nana Maheta veneka. ");
INSERT INTO mvn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kadu Maheta‑nana novanovana nihenina tapa‑yayai, kate novanovana eha ana pata Maheta‑nana na‑weu. ");
INSERT INTO mvn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ka Yaubada onoto aitam vi‑tunei, ana wava Ioni. ");
INSERT INTO mvn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tauna aitam tau hae Maheta wayahina, ka omo tomotau hae‑nana inononi, e munia Maheta‑nana ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ka Ioni eha Maheta‑nana, kate Ioni omo vi‑tau hae Maheta‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka tuta‑nana wayahina, Maheta‑ohota a vinꞌ‑omo tanopia avaha vi‑maupwanina. Ka tauna habuhabuka vo‑vi‑maheteka. ");
INSERT INTO mvn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Vonana avaha omo tanopia, ka tanopia mamaei. Ka tanopi‑nana a vevewana vinꞌ‑omo Vonana wayahina, kate tau maꞌ tanopi eha itꞌ‑anamane tauna koiaka. ");
INSERT INTO mvn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ka kadu tauna omo yana yoko wayahia, kate taui eha ita‑nau‑kaiwe. ");
INSERT INTO mvn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kate aituhu aviyaivia inau‑kaiwei kadu ivitumahanei vivane tauna Tau Ito‑yavuha‑nana, akanai tauna awaehei taui Yaubada natunatuna. ");
INSERT INTO mvn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iuna taui itupua‑havine, ka tupua‑havinena eha ta‑vinꞌ‑omo tomotau dayahi wayahina, kadu eha ta‑vinꞌ‑omo tomotau yai nuanua wayahina, ka kadu eha ta‑vinꞌ‑omo onoto ya bagibagi wayahina. Eha‑ohota. Tupua‑havine‑nana vinꞌ‑omo Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ka Vonana vi‑tomotau, ka nonova itoai nui amamaei. Yaubada didigana Natu‑hoina vene‑tamani, ka itoai avaha didigana adueyei. Ka am‑venena awawaehina kadu vona‑vavaha Vonana inau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ka Ioni Vonana haeyei, ka vi‑hone movina ananina wayahina, ka ivona, “Onoto‑nana wayahina avonavona tutana ahaeyei, ‘Vivane aitam onoto muniua omomo, kate tauna vane‑tawaneu, iuna tauna avaha mamaei, ka munia yauke atupua aomo.’” ");
INSERT INTO mvn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ka tauna yanꞌ am‑venena awawaehina ananina wayahina nau‑iaiava ivinꞌ‑omo‑nananena, ka itoka tomotau habuhabuka avaha kavaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Iuna Yaubada ya veimea vinꞌ‑omo wayahikaia Mosese wayahina. Kate Yaubada yanꞌ am‑venena awawaehina kadu ya vona‑vavaha vinꞌ‑omo wayahikaia Iesu Tau Ito‑yavuha wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka eha aitam koiaka Yaubada ana dune ta‑dueye, kate Natu‑hoina, tauna nau‑vana Amana madina wayahina, avaha Yaubada viwaveneka. ");
INSERT INTO mvn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ka me Iudea yai tau eta‑naonao Ierusalem nihenina imamaei. Ka tutana Ioni vi‑putu naunau‑wahe, taui tau vi‑nomu tupwai, kadu Levi yana yoko tupwai ivi‑tunei iomo Ioni wayahina, e ivi‑tanaiei, “Wamke koiaka?” ");
INSERT INTO mvn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ka Ioni nau‑pata ahiahina kadu mahemaheina venei, ivona, “Yauke eha Tau Ito‑yavuha‑nana.” ");
INSERT INTO mvn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wayahina, ivi‑tanaiei, ivona, “Aituhu deina, koiaka wamke? Kaiwadi, wamke vivane Elidia, tauna na‑omo, ika?” Ka ivona, “Yauke eha.” Kadu ivi‑tanaiei, “Kadi wamke Tau Apa‑taputapu‑nana, tauna wayahina Mosese vonavona?” Ka Ioni vona‑nau‑pata, ivona, “Yauke eha.” ");
INSERT INTO mvn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wayahina, pai nau‑yehata ivi‑tanaiei, ivona, “Kaiwadi, wamke koiaka? Aviani yam vona taum wayahim, e itoai ama pata amavina, e ama tau vi‑tune amataedai?” ");
INSERT INTO mvn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wayahina, Ioni yai vi‑tanai‑nana nau‑patei, e si‑vinꞌ‑omanei tau apa‑taputapu ana wava Isaia ya iginuma wayahina, ivona, “Yauke aitam onoto anata nihenina avi‑honehone, avonavona, ‘Nau‑wawanimi Kauvea ya etawana uhadani, kadu tauna ya paisewa uvo‑vi‑meani.’ Wayahina, nau‑wawanimi yawaimi uvo‑vi‑tunuhi, e apaina Kauvea ya mataeda unononi.” ");
INSERT INTO mvn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ka tau eta‑naonao tupwai Parisi ivi‑tunei iomo, ");
INSERT INTO mvn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ka Parisi‑naia Ioni ivi‑tanai‑havinei, ivona, “Aituhu wamke eha Tau Ito‑yavuha‑nana, kadi wamke eha Elidia, kadi wamke eha Tau Apa‑taputapu‑nana, akanai mehenai tomotau evi‑bapitaisoei?” ");
INSERT INTO mvn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ka Ioni vonei, ivona, “Yauke daudaua tomotau avi‑bapitaiso‑neiei, kate tuta ataina wayahina aitam onoto niwanimia mimini, ka eha utꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ka tauna muniua omomo, kate yauke eha nau‑wawaniu anꞌ ae‑yapayapa ayavuhi, iuna tauna vane‑tawaneu.” ");
INSERT INTO mvn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dewaia tanoi habuhabui ivinꞌ‑omo papani Betani wayahina. Tanoi Ioni ya pai vi‑bapitaiso Ierusalem papanina Daudau Ioridani wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mana navia Ioni Iesu dueyei omomo wayahina, e Ioni tomotau vonei, ivona “Udu! Onoto tanoi, tauna Yaubada yana LamiV, ka tauna tau maꞌ tanopi habuhabuka yaka goyona habuhabuna nꞌ‑epa‑yavunei yanꞌ aniga wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nonova onoto‑nana wayahina avonavona, tutana avonemi vivane, ‘Onoto aitamoata muniua omomo, kate tauna vane‑tawaneu, iuna tauna avaha mamaei, e munia atupua aomo.’ ");
INSERT INTO mvn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ka nonova, auyewana wayahina, yauke eha atꞌ‑anamane koiaka tauna. Tanoi yauke itomi me Isiraeli avo‑vi‑aiaiemi, kadu daudaua avi‑bapitaisoemi. Ka ataina nau‑wawanimi tauna unꞌ‑anamanei.” ");
INSERT INTO mvn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ka hae‑nana wayahina Ioni Iesu haeyei, ivona, “Yaubada Nuana Ahihinata adueyei ana dune bunebune deina wahuma opu‑me, e Iesu wayahina itoha mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nonova eha atꞌ‑anamane koiaka tauna, ka Yaubada vi‑tuneu bapitaiso daudaua adedewei, e wayahiua haeyei, ivona, ‘Apaina Nuau edueyei na‑opu‑me, ka onoto wayahina na‑toha, ka apaina tauna Yaubada Nuana Ahihinata wayahina tomotau vi‑bapitaiso‑neiei.’” ");
INSERT INTO mvn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ka Ioni kadu vonei, ivona, “Yauke mataua dewana adueyei, wayahina ahaehaeyei vivane tauna Yaubada Natu‑hoina.” ");
INSERT INTO mvn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka mana navia, e Ioni tauna a tau vi‑muni‑waiwai ainua nui imimini, ka Iesu dueyei nepeia neine. ");
INSERT INTO mvn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wayahina, Ioni tauna a tau vi‑muni‑waiwai vonei, ivona, “Onoto tanoi tauna Yaubada yana LamiV.” ");
INSERT INTO mvn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ka a tau vi‑muni‑waiwai ainua, avaha Ioni ya vonana inononi, ivi‑putu Iesu ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ka Iesu magigino, dueyei, e vi‑tanaiei, ivona, “Aviani yami nuanua?” Ka taui ivona, “RabiV, aveta yam pai maꞌ?” (RabiV anꞌ anamana “yau tau viwavenena ananina”.) ");
INSERT INTO mvn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ka Iesu vonei, ivona, “Uvi‑munieu, e yau pai maꞌ udueyei.” Akaka auyewana ivi‑muniei, e ivinꞌ‑omo papani‑nana wayahina, e imamaei vinanavi. ");
INSERT INTO mvn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ka aitam Ioni a tau vi‑muni‑waiwai ainuai ana wava Aniduru. Tauna Simoni Pita taina. ");
INSERT INTO mvn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ka Aniduru vo‑kwayavoni, e avaha akana vaniahei, vonei, ivona, “Simoni, avaha Mesaia‑nanaV avaniahei.” (MesaiaV me Ebereu movi. A vo‑vina me Girisi movia KerisoV, ka anꞌ anamana “Tau Ito‑yavuha”.) ");
INSERT INTO mvn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wayahina, Aniduru Simoni taini omanei Iesu wayahina. Ka tanoi wayahina Iesu Simoni dueyei, e vonei, ivona, “Wamke am wava Simoni, Ioni natuna. Kate am wava vovouna avenem KepasiV.” (KepasiV me Ebereu movi. A vo‑vina me Girisi movia PitaV, ka anꞌ anamana “Hanu”.) ");
INSERT INTO mvn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ka mana navia Iesu ya nuanua na‑nei papani Galili, wayahina ine, e tanoi onoto ana wava Pilipi vaniahei, e vonei, ivona, “Evi‑muni‑waiwaieu.” ");
INSERT INTO mvn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ka Pilipi ya meagai Betesaida, tanoi Pita ka Aniduru yai meagai. ");
INSERT INTO mvn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Pilipi ine, e tauna a niam ana wava Natanaela vaniahei, e vonei, ivona, “Avaha onotona avaniahei, e nonova tauna wayahina Mosese ya veimea nihenina ginumi, kadu tau apa‑taputapu yai iginuma nihenia ihaehaeyei, tauna onoto Nasareta, Iosepa natuna, ana wava Iesu.” ");
INSERT INTO mvn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ka Natanaela Pilipi ya vonana vona‑nau‑patei, ivona, “Kaiwadi. Ana pata aitam aviani na‑ivaiteka Nasareta wayahina vinꞌ‑omo?” Ka Pilipi ivona, “Enꞌ‑omo, ka onotona edueyei.” Ka ainuai iomo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka tutana Iesu Natanaela dueyei, Iesu tomotaui awaniana imimini vonei Natanaela wayahina, ivona, “Vona‑vavaha, onoto taina aitam me Isiraeli‑hoina, kadu eha aitam vitupu nihenina.” ");
INSERT INTO mvn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka Natanaela Iesu vi‑tanaiei, ivona, “Medeina eanamaneu?” Ka Iesu ivona, “Yauke amai‑dueyem madaiba iwaunina emamaei, e munia Pilipi honem.” ");
INSERT INTO mvn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aina wayahina Natanaela nuana vi‑tupatupa, e tauna Iesu vonei, ivona, “Tau Viwavenena, vona ahiahina, wamke Yaubada Natu‑hoina, ka wamke kadu me Isiraeli yama kiniV.” ");
INSERT INTO mvn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ka Iesu vonei, “Ana heta avonem tutana wamke madaiba iwaunina adueyem, e moviuata evitumahaneu? Ataina tuta pai dune aya‑kituna wayahima, ka apaina dewa anani edueyei.” ");
INSERT INTO mvn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E Iesu kadu ivona, “Memeanina nuami vi‑tupatupa, kate avonemi apaina wahuma nꞌ‑am‑waei, e Yaubada yanꞌ anelose udueyei, ivanevane ka iopupu‑me yauke, Tauna Vi‑tomotau, hetaua.” ");
INSERT INTO mvn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka avaha auyewa ainua iakwa, e tau vi‑meagai Kana tavine toneina idedewei Galili a papania. Ka tonei‑nana nihenina Iesu ayona imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ka tomotau‑naia toneina idedewei tuyeha iva‑tawanei omo Iesu tauna a tau vi‑muni‑waiwai nui wayahia, e inꞌ‑omo, e nui inꞌ‑am. Wayahina iomo. ");
INSERT INTO mvn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tutana yaiana ai wainaV ivꞌ‑iakwani, Iesu ayona imataedei, ivona, “Natu, wainaV habuhabuna avaha iakwa.” ");
INSERT INTO mvn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka Iesu ivona, “Vavinemi, eha uveimeyeu, iuna yau paisewa eha ata‑vi‑putu. Apaina.” ");
INSERT INTO mvn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ka tau paisewa tupwai imamaei, ka Iesu ayona taui ivonei, ivona, “Aviani tauna veimeyemi, udewei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ka tuta tanoi wayahina me Iudea yai dewa ivi‑muniei, e nimai kadu yai pai am‑itava inosinosia. Aituhu eha ita‑dewe tunuhina, taui inuanua ivi‑gawama Yaubada matana. Ka dewana wayahina, yai pai iwaha inau‑vevewanei hanu wayahina. Ka tonei‑nana wayahina pai iwaha‑naia ai yau 6 imamaei, ka Iesu dueyei. Ka pai iwaha‑naia awakabi ka anani, ana pata daudau ani‑vainena iaiwahi nihenia, 100 litaV aitamoata aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wayahina, Iesu tau paisewaia vonei, ivona, “Pai iwaha awakabi taina daudau uvi‑nau‑vi‑anai.” Ka taui idewei deina, ka daudau ivane nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Akaka tauna vonei, ivona, “Daudau tupwana pai iwaha nihenia ugoia, e tau vi‑tonei wayahina uneiei.” Ka idewei deina. ");
INSERT INTO mvn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ka tau vi‑tonei‑nana daudau‑nana nim‑dadani, vivane tunina, eha daudau kate avaha vi‑waina, a nau‑dadana ahiahina. Ka tau vi‑tonei‑nana eha tꞌ‑anamane aveta wayahina wainaV tanoi iepei, ka tau paisewaia ai heta ianamanei. Wayahina, tau vi‑tonei‑nana tau tavine onotona honei, ");
INSERT INTO mvn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e vonei, ivona, “Itoka yaka dewa tutuaina vivane naona wainaV ahiahina tomotau kavenei inimnim. Munia, avaha idewa‑haiawa ananina, wainaV goyona kavenei inim‑iaua. Kate wamke yam dewa tunina. Pai vi‑putu wayahina wamke wainaV ahihi‑vainena ehivei, e ataina tau paisewaia iomanei!” ");
INSERT INTO mvn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Dewana Iesu ya dewa‑bagibagina naona ka iaiaya naona si‑vinꞌ‑omanei meagai Kana wayahina, papani Galili nihenina, ka tanoi tauna ya bagibagi tomotau viwavenei, akaka dewana wayahina a tau vi‑muni‑waiwai ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ka tonei‑nana munina, Iesu ka tauna ayona, ka vavaneina, ka kadu a tau vi‑muni‑waiwai nui iopu meagai Kapenaum wayahina, e tanoi auyewa tupwai imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ka avaha tuta vi‑hinahina me Iudea yai Itouvuha Toneina idedewei wayahina. Ka tuta‑nana wayahina Iesu ivane Ierusalem. ");
INSERT INTO mvn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ka inu Manua Vito‑pota nihenina, ka tau aimwane imanuena dudueyei. Ka taui bulumakauV ka sipiV ka bunebune ai tau aimwane, kadu kina a tau vo‑vine yai tana‑pwaina wayahia imanuena Manua Vito‑pota nihenina imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wayahina, manawa metametana epei, e vahitau Manua Vito‑pota wayahina vo‑taho‑neiei, kadu tau vo‑vine yai tana‑pwaina tutu‑bwata‑vine‑neiei, e yai kina tutu‑yavuyavunei, ");
INSERT INTO mvn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","e taui bunebune iaimwanei veimeyei, ivona, “Yami manua taina habuhabui baina wayahina uvituei ina‑opu! Eha Amau ya manua uvo‑vinei vivane yami pai aimwane!” ");
INSERT INTO mvn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka a tau vi‑muni‑waiwai Iesu ya vonana inononi kadu ya dewana idueyei, e munia Iginuma inuani, vivane nihenina ivona, “Yaubada, yau nuanua yam manua wayahina nuau epei ani‑vainena.” ");
INSERT INTO mvn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wayahina, me Iudea ai tau eta‑naonao iomo, e Iesu ivi‑tanaiei, ivona, “Avi iaiaya eviwaveneai adueyei, anꞌ‑anamanei koiaka am awaeha venem, e dewaia habuhabui ededewei?” ");
INSERT INTO mvn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ka Iesu wayahia ivona, “Aituhu manua taina ubwegei, auyewa aitonu na‑iakwa ayone‑havinei.” ");
INSERT INTO mvn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka me Iudea ivona, “Ia! Vivane Manua Vito‑pota taina auyewa aitonu nihenia eyone‑havinei? Eha am pata! Enuani. Manua Vito‑pota taina ponimana ai yau 46 nihenia iyonayona, e apaina inau‑yehai.” ");
INSERT INTO mvn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kate Iesu eha Manua Vito‑pota wayahina ta‑vonavona, kate “manua” aitam vona baimina tauna ininina wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wayahina, tutana Iesu anigea mini‑havine, a tau vi‑muni‑waiwai Iginuma ana vona inuani, kadu Iesu yana vona wayahia inuani vivane ainuai yai hae aitamoata ya mini‑havine wayahina. E a tau vi‑muni‑waiwai hae‑naia ainuai ivitumahana‑vavahi. ");
INSERT INTO mvn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka tutana Iesu Itouvuha Toneina Ierusalem nihenina mamaei, tomotau yoko Iesu ya dewa‑bagibagi idueyei, akaka dewaia wayahi ivitumahanei vivane tauna Tau Ito‑yavuha‑nana. ");
INSERT INTO mvn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ka Iesu tauna ya nuanua eha ta‑ipupu vuvunaha tomotaui wayahia, iuna tauna avaha tomotau habuhabui yai nuanua mai‑vi‑nua‑uyei. ");
INSERT INTO mvn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wayahina, eha aitam koiaka ana pata Iesu na‑vo‑vi‑mahete tomotau yai nuanua wayahi, iuna Iesu, aviani tomotau nuai nihenia mamaei, avaha anamane‑yehai. ");
INSERT INTO mvn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Onoto aitam, ana wava Nikodemusi, tauna aitam Parisi, kadue me Iudea ai tau eta‑naonao aitam. ");
INSERT INTO mvn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka ioyoma tauna omo Iesu wayahina, e vonei, ivona, “Tau Viwavenena, itoai avaha anamanem Yaubada vi‑tunem eomo wayahiaia eviwaveneai. Iuna Yaubada ivaitem, e dewa‑bagibagi ededewei adudueyei. Aituhu Yaubada eha ta‑ivaitem, eha am pata dewa‑bagibagi ededewe.” ");
INSERT INTO mvn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ka Iesu nau‑patei, ivona “Memeanina nuam vi‑tupatupa, kate avonem nau‑wawanim wahuma wayahina etupueyei. Aituhu eha etupu‑havine, eha am pata Yaubada ya pai veimea edueye.” ");
INSERT INTO mvn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ka Nikodemusi Iesu vi‑tanaiei, ivona, “Medeina yauke, onoto ananiu, atupua‑havine? Vona ahiahina, eha au pata ayou madia anu havine, e atupua‑havine.” ");
INSERT INTO mvn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka Iesu nau‑patei, ivona, “Memeanina nuam vi‑tupatupa, kate avonem, aituhu aviyaivia eha daudaua kadue Yaubada Nuana Ahihinata wayahina itupua, akanai taui eha ai pata Yaubada ya pai veimea wayahina ina‑nu. ");
INSERT INTO mvn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ayoyoka wayahia katupueyei, vivane ininika ai heta. Kate tomotau nuai ai tupua‑havine Yaubada Nuana wayahina vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eha enua‑tupatupa iuna avonavona, ‘Nau‑wawanimi wahuma wayahina utupueyei.’ ");
INSERT INTO mvn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tupua‑nana yahina yana huna deina. Aveta wayahina yahina ya nuanua na‑huna, akanai na‑huna deina. Eha am pata yahina eveimeye. Yahina putuna enononi, kate wamke eha etꞌ‑anamane aveta wayahina yahina omomo o kadi aveta wayahina neine. Ka aituhu aviyaivia Yaubada Nuana wayahina itupua‑havine, taui kadu deinake.” ");
INSERT INTO mvn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemusi Iesu vi‑tanaiei, ivona, “Yam vonana medeina anꞌ anamana?” ");
INSERT INTO mvn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Akaka Iesu ivona, “Ia! Wamke me Isiraeli yai tau viwavenena ananina aitam, kate yau vonana eha eta‑nua‑hau, a? ");
INSERT INTO mvn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Memeanina nuam vi‑tupatupa, kate avonem dewaia avaha adueyei kadu dewaia avaha anamane‑yehai, akanai itoai dewaia ahaehaeyei wayahimia, kate itomi eha yama mataeda uta‑vitumahane. ");
INSERT INTO mvn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Avaha dewaia memeanina tanopi taina wayahina ahaehaeyei wayahimia, kate eha hae‑nana uta‑vitumahane. Aituhu apaina dewaia vitana wahuma wayahina aviwavenemi, kaiwadi? Ami pata viwavene‑nana uvitumahanei? ");
INSERT INTO mvn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Eha aitam wayahimia wahuma ta‑vane. Akanai yauke au heta, Tauna Vi‑tomotau, yauke wahuma aopu‑me. ");
INSERT INTO mvn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nonova, tutana me Isiraeli ivenavenau anata nihenina, Mosese mwata kainumu nau‑vevewanei, e tauna ai tabona si‑nai. Ka aituhu aviyaivia ivi‑kwanaha, taui nau‑wawani idunedune wayahina, e ividoha. Ka apaina tomotau isi‑naiu deinake. ");
INSERT INTO mvn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Dewana wayahina aituhu aviyaivia ivitumahaneu, akanai taui yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Iuna Yaubada tomotau habuhabui tanopia dune‑nuanuai ananina. Wayahina, tauna Natu‑hoina vi‑tunei, ka vi‑nomuei wayahi, ka aituhu aviyaivia tauna ivitumahanei, taui eha inꞌ‑aniga‑vavaha, kate yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaubada tauna Natu‑hoina tanopia vi‑tunei, kate eha ya nuanua Natu‑hoina tau maꞌ tanopi na‑yapo yai goyona wayahi. Eha. Kate Yaubada ya nuanua Natu‑hoina wayahina tau maꞌ tanopi na‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ka aituhu aviyaivia Yaubada Natu‑hoina ivitumahanei, apaina taui eha dewa‑yaiyai Yaubada wayahina ivaniahe. Kate aituhu aviyaivia eha ita‑vitumahane, Yaubada avaha veimeyei dewa‑yaiyai yai goyona wayahina ivaniahei. Iuna taui eha Yaubada Natu‑hoina ita‑vitumahane. ");
INSERT INTO mvn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ka taui vi‑nua‑dadana vitana Yaubada wayahina ivaniahei taina deina. Taui goyona idedewei, wayahina yai nuanua ananina novanovana, iuna novanovana yai dewa goyona hivehivei. Maheta avaha omo tanopia, kate tomotaui maheta‑nana ivihahaiei. ");
INSERT INTO mvn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ka aituhu aviyaivia goyona idedewei, taui maheta‑nana inau‑nikonikoiei, kadu eha maheta‑nana wayahina ivinꞌ‑omo. Iuna eha yai nuanua yai dewa goyona a si‑vinꞌ‑omana mani tomotau mataia. Wayahina imatamatautei. ");
INSERT INTO mvn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kate aituhu aviyaivia vona tunutunuhi ivi‑ateteyei, taui maheta‑nana wayahina ivinꞌ‑omo, e nihenina imamaei. Wayahina, habuhabuka aka pata yai dewa ahiahina kadudueyei vivane dewaia Yaubada ya nuanua wayahina ivinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ka tuta munia, Iesu tauna a tau vi‑muni‑waiwai nui iomo papani Iudea wayahina, ka auyewa tupwai tanoi imamaei, kadu Iesu tomotau vi‑bapitaiso‑neiei. ");
INSERT INTO mvn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ka Ioni Tau Bapitaiso meagai Aenoni wayahina mamaei. Meagai‑nana Salim nepena. Ka Ioni kadu tomotau vi‑bapitaiso‑neiei, iuna papani‑nana wayahina daudau ananina. Wayahina, tomotau yoko Ioni wayahina iomomo, e Ioni vi‑bapitaiso‑neiei. ");
INSERT INTO mvn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Naona dewaia ivinꞌ‑omo, ka munia Ioni manua yohona nihenina mamaei.) ");
INSERT INTO mvn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ka tupwai Ioni a tau vi‑muni‑waiwai ivi‑putu ivi‑vonavona aitam me Iudea wayahina, ka ivi‑vonavona aitam dewa wayahina, bapitaiso deina. ");
INSERT INTO mvn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ka tau vi‑vonavona‑naia iomo Ioni wayahina, e ivona, “Tau Viwavenena, onotona nonova Daudau Ioridani papanina ami inua umamaei, ka wamke onoto‑nana ehaeyei wayahiaia. Ka ataina tauna avaha tomotau vi‑bapitaiso‑neiei, ka tomotau habuhabui yam bapitaiso ivihahaiei, ka yai nuanua tauna ya bapitaiso. Wayahina, taui iomomo tauna wayahina!” ");
INSERT INTO mvn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka vonana wayahina Ioni nau‑patei, ivona, “Aviani kavaniahei baina tanopia, dewaia aitamoata aitamoata Yaubada veneveneka, ka tauna ana heta wayahina kavaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Avaha avonemi ka avaha unononi, ‘Yauke eha Tau Ito‑yavuha‑nana, kate naona Yaubada vi‑tuneu aomo onoto‑nana aeta‑naoi.’ ");
INSERT INTO mvn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pai dune taina avenemi. Iesu tau tavine onotona deina, ka yauke a niam deina, apotepotei, kadu avanevaneneha ya vinꞌ‑omana wayahina. Ka tutana tau tavine‑nana movina anononi, akanai yauke adewa‑haiawa ananina. E dewa‑haiawana nau‑vi‑anaiu. ");
INSERT INTO mvn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wayahina, ataina a itoava auyewa pai nau‑yehata wayahina, Iesu ana wava na‑nata, kate yauke au wava na‑opu.” ");
INSERT INTO mvn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tauna wahuma opu‑me, wayahina tauna tomotau habuhabui bagibagi‑tawanei. Aituhu koiaka tanopia vinꞌ‑omo, tauna tanopi tomotauna, kadu tanopi wayahina vonavona. Kate Iesu wahuma opu‑me, wayahina tauna tomotau habuhabui bagibagi‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Avi dewa avaha wahuma dueyei, tauna dewaia haehaeyei. Kate tomotau eha ya hae‑nana ita‑nononi, ka eha ita‑vitumahane. ");
INSERT INTO mvn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ka aituhu koiaka ya hae‑nana vitumahanei, akanai tauna avaha awaehei vivane Yaubada yana vona tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yaubada Iesu vi‑tunei, ka tauna Yaubada yana vona nau‑waheyei. Iuna Yaubada Nuana Ahihinata tauna venei, ka eha a ito‑vewana awaehei. ");
INSERT INTO mvn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yaubada tauna Natu‑hoina dune‑nuanuaiei ananina. Wayahina, Yaubada avaha dewa habuhabuna nimana bouni, e tauna veimeyei. ");
INSERT INTO mvn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ka aituhu aviyaivia Tauna Vi‑tomotau ivitumahanei, taui avaha yawai‑vavaha ivaniahei. Kate aituhu aviyaivia Tauna Vi‑tomotau ivihahaiei, taui eha ai pata yawai‑vavaha inꞌ‑anamane. Iuna Yaubada ya maga bawa wayahia eha na‑iakwa, ka apaina ai dewa‑yaiyai ivaniahei.” ");
INSERT INTO mvn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ka Parisi yai yoko vane inononi vivane Iesu tauna ya bapitaiso wayahina a tau vi‑muni‑waiwai ai yau natanata. Ika, taui ai yau Ioni a tau vi‑muni‑waiwai ai yau nata‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kate Iesu ana heta eha bapitaiso‑nana ta‑dedewe, kate a tau vi‑muni‑waiwai ai heta idedewei.) ");
INSERT INTO mvn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ka tutana Kauvea dewaia habuhabui anamane‑yehai, tauna papani Iudea ni‑tawanei, ka mavi‑havine papani Galili wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ka Iesu ya mavina Galili wayahina, tauna nau‑wawani papani Samaria niwanina neine. ");
INSERT INTO mvn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ka papani Samaria nihenina aitam meagai ivaniahei, ana wava Sikari. Ka meagai‑nana eha bana aitam tano wayahina, kadu nonova Iakobo tanona natuna Iosepa venei. ");
INSERT INTO mvn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka papani‑nana nihenina aitam tovoha mamaei, e nonova Iakobo kayoi. Ka avaha auyewa pouna, e Iesu papani‑nana wayahina vinꞌ‑omo, e tauna avaha ihanua, wayahina manuena, e vi‑yawai. ");
INSERT INTO mvn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ka a tau vi‑muni‑waiwai ine meagai ananina wayahina ai maꞌ ina‑imwane. Ka tuta aya‑kituna iakwa wayahina, aitam vavine Samaria omo daudau na‑goi. Ka Iesu vavinena dueyei, e wayahina ivona, “Daudau egoia, eveneu ana‑nim.” ");
INSERT INTO mvn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ka vavinena Iesu wayahina ivona, “Edu, wamke onoto Iudea ka yauke vavine Samaria. Wayahina, aviani iuna daudau eviameu, avenem?” (Vavinena ivona deina iuna me Iudea ka me Samaria eha ita‑vi‑yaiana.) ");
INSERT INTO mvn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka Iesu vona‑nau‑patei, ivona, “Wamke eha etꞌ‑anamaneu, kadu Yaubada yanꞌ am‑venena eha etꞌ‑anamane ahiahina. Aituhu eanamanei vivane yauke koiaka, akanai, wamke nau‑wawanim eviameu, e yawai a daudau avenem.” ");
INSERT INTO mvn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wayahina, vavinena ivona, “Bada, eha yam pai goi, kadue daudau guba taina opu‑vaine. Wayahina, medeina yawai a daudau eveneu? ");
INSERT INTO mvn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nonova waka Iakobo itoai ama daudau guba taina kayoi, e tauna kadue natunatuna kadue taui yai vahitau daudau taina yai pai nim. Tauna guba taina veneai, ka medeina, wamke Iakobo evane‑tawanei?” ");
INSERT INTO mvn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Iesu nau‑patei, ivona, “Aituhu aviyaivia daudau taina inimnim, taui magai nꞌ‑ayaya‑havine. ");
INSERT INTO mvn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kate aituhu aviyaivia daudau‑nana avenei inimnim, taui eha kadu aitam tuta magai nꞌ‑ayaya. Iuna daudau‑nana avenei nuai nihenina na‑nu, kadu nuai nihenina vi‑tovoha. Wayahina, taui nihenia yawai‑vavaha nꞌ‑am‑iwaiwahi.” ");
INSERT INTO mvn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka vavinena Iesu wayahina ivona, “Bada, daudau‑nana eveneu! Akaka magau eha nꞌ‑ayaya, kadu eha nau‑wawaniu amavi‑havihavine daudau taina wayahina agoigoia.” ");
INSERT INTO mvn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wayahina Iesu ivona, “Ena‑ne, e awam etaini eomanei baina.” ");
INSERT INTO mvn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka vavinena Iesu vonei, ivona, “Yauke eha aitam awau.” Wayahina Iesu ivona, “Yam vonana tupwana ahiahina kadu tupwana vitupu vivane eha aitam awam. ");
INSERT INTO mvn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Iuna, nonova a itoava tuta ataina wayahina awawam ai yau nima papanina, kadu ataina onoto‑nana ami inua megeia umamaei tauna eha awa‑hoim. Wayahina, aviani evoneu, tupwana evona ahiahina deinake.” ");
INSERT INTO mvn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wayahina vavinena Iesu vonei, ivona, “Bada, yam vonana wayahiu tunuhina. Wayahina, avaha anamanem wamke tau apa‑taputapu aitam. ");
INSERT INTO mvn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yau vi‑tanai taina. Avi papani wayahina nau‑wawanika Yaubada kaiwaodu tunuhina? Iuna itoai me Samaria yama tupua‑nenenehi oya taina wayahina itapatapanono, kate itomi me Iudea uvonavona meagai Ierusalem ana heta pai tapanono tunuhina.” ");
INSERT INTO mvn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka Iesu ivona, “Vavinem, yau vona enononi, evitumahanei, iuna tuta tepakaia tomotau eha Yaubada wayahina ina‑iwaodu Samaria oya taina wayahina, kadu eha ina‑iwaodu meagai Ierusalem wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Itomi me Samaria eha utꞌ‑anamane‑vidoha koiaka wayahina uaiwaodu, kate itoai me Iudea anamanei koiaka wayahina aiwaodu, iuna ito‑yavuha wayahiaia vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kate tuta tepakaia wayahina, vivane ataina tuta avaha vi‑putu, aituhu aviyaivia yai nuanua Amaka wayahina ina‑iwaodu, taui nau‑wawani ina‑iwaodu nuai wayahia, kadu ina‑iwaodu vona tunuhina wayahina, eha vitupu wayahina. Iuna Yaubada ya nuanua tomotau ina‑iwaodu wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada vivane Nua, wayahina aituhu aviyaivia yai nuanua ina‑iwaodu Yaubada wayahina, taui nau‑wawani ina‑iwaodu nuai wayahina, kadue nau‑wawani ina‑iwaodu vona tunuhina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka vavinena Iesu vonei, ivona, “Avaha anamanei apaina MesaiaV na‑omo, (tauna ivi‑wahani me Girisi movia ‘Keriso’ V), ka avi tuta tauna na‑omo, tauna nua‑uya habuhabuna na‑vo‑vi‑maheteka.” ");
INSERT INTO mvn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ka Iesu vavinena vonei, ivona, “Tauna yauke, taua avonavona wayahima.” ");
INSERT INTO mvn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tuta‑nana wayahina Iesu a tau vi‑muni‑waiwai imavina, e tauna vavinena ainua iaipuipupu idudueyei, e nuai vi‑tupatupa ananina. Kate akanai, eha aitam koiaka wayahia vavinena wayahina ta‑vona deina, “Aviani yam nuanua?”, ka eha aitam wayahia Iesu wayahina ta‑vona, “Aviani wayahina vavinena ami inua uaipuipupu?”. ");
INSERT INTO mvn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ka vavinena ya pai goi venau‑tawanei, e omo megeia, e tomotau vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Unꞌ‑omoi, e aitam onoto udueyei! Tauna avaha yau dewa habuhabuna tuta nonova a itoava tuta ataina wayahina voneu. Kaiwadi, tauna Tau Ito‑yavuha‑nana?” ");
INSERT INTO mvn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wayahina, tomotaui meagai‑nana ini‑tawanei, iomo Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka tuta aitamoata nihenina Iesu a tau vi‑muni‑waiwai ivonavona, “Tau Viwavenena, aniani taina enꞌ‑am!” ");
INSERT INTO mvn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka tauna yai vonana nau‑patei, ivona, “Au maꞌ mamaei, kate itomi eha utꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ka a tau vi‑muni‑waiwai nuai vi‑tupatupa, e matataui ivi‑vonavona, ivona, “Kaiwadi, koiaka avaha ana maꞌ omanei venei?” ");
INSERT INTO mvn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka Iesu wayahia ivona, “Au maꞌ taina deina. Nau‑wawaniu au tau vi‑tune ya nuanua adedewei, kadue nau‑wawaniu avi paisewa tauna veneu anau‑yehai.” ");
INSERT INTO mvn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ka kadu wayahia ivona, “Yami vona tana‑minikuna aitam mamaei vivane ‘Wahava ai yau na nau‑punina na‑iakwa, e aihana ana tuta vi‑putu,’ kate avona ahiahina wayahimia, udune‑nau‑nene, e tomotau taina ududueyei. Taui aitam baguna deina, ka avaha aniani pani. Wayahina, aihana ana tuta avaha vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ka aituhu aviyaivia wayahimia unꞌ‑aihana, apaina taumi ami nau‑pata uvaniahei, kadu aihana‑nana vivane yawai‑vavaha tomotau wayahi. Wayahina, taui nonova imamaei ibagubaguna, kadu taumi ataina uaiaihane. Ka munia nui udewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vona tana‑minikuna taina vona ahiahina vivane, ");
INSERT INTO mvn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wayahina, baguna taina nihenina avi‑tunemi, unꞌ‑aihana. Ka aviani ataina uaiaihana, taumi eha uta‑baguna, kate nonova mani tomotau ibagubaguni, ka ataina yai vo‑vi‑aiai wayahina uaiaihana.” ");
INSERT INTO mvn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ka meagai tanoi wayahina me Samaria habuhabui Iesu ivitumahanei, iuna vavinena mataedai, ivona, “Tauna yau dewa habuhabuna tuta nonova a itoava tuta ataina wayahina voneu.” ");
INSERT INTO mvn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wayahina, me Samaria iomo Iesu wayahina, e iviamei nui imamaei. Ka Iesu awaehei, e auyewa ainua wayahia Iesu tanoi mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ka kadu mani tomotau yokoia hetaia Iesu ya nau‑wahe inononi, e ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ka yokoia vavinena ivonei, ivona, “Ataina tauna avitumahanei, kate eha vivane yam vonata wayahina. Itoai tauai avaha ya nau‑wahe anononi. Wayahina anamanei ahiahina vivane tauna Tau Ito‑yavuha‑nana, tau maꞌ tanopi habuhabuka wayahika.” ");
INSERT INTO mvn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka auyewaia ainua munia, Iesu papani‑nana ni‑tawanei, e ine papani Galili wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Ka Iesu yana vona aitam deina, “Eha aitam tau apa‑taputapu ana pata awa‑dava na‑vaniahe tau vi‑meagai tauna ya papani wayahina.”) ");
INSERT INTO mvn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ka tutana papani Galili wayahina vinꞌ‑omo, me Galili idewa‑haiawa yana omana wayahina, iuna nonova taui Itouvuha Toneina Ierusalem wayahina ine, e avaha Iesu yana dewa habuhabuna idueyei. ");
INSERT INTO mvn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ka Iesu mavina meagai Kana wayahina, Galili a papani nihenina. Nonova meagai‑nana nihenina tauna daudau vo‑vi‑aiaia vi‑wainaV. Ka aitam tau veimea ananina Kana mamaei, ka natuna onotona vi‑kwanaha meagai Kapenaum wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ka tutana tau veimea‑nana vane nononi vivane Iesu avaha papani Iudea ni‑tawanei, e papani Galili nihenina mamaei, tauna omo Iesu wayahina, e hidei vivane ina‑ne Kapenaum wayahina, e natuna onotona na‑vo‑vi‑aiaiei, iuna tuta eha ani‑hoina na‑iakwa wayahina, e yawaina na‑iakwa. ");
INSERT INTO mvn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ka Iesu onotona vonei, ivona, “Eha aitam tomotau itomi wayahimia evitumahaneu. Aituhu iaiaya kadu dewa‑bagibagi adedewei ududueyei, akanai uvitumahaneu.” ");
INSERT INTO mvn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wayahina tau veimea‑nana vonei, ivona, “Bada, kavisina, e kana‑ne. Apaiku natu nꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ka Iesu ivona, “Emavina yam manua, e natum edueyei, vidoha.” Akaka onotona Iesu yana vona vitumahanei, e ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ka tutana onotona etawana, ya tau paisewa tupwai ivi‑vaniaha, e imataedei, ivona, “Natum a kwanaha avaha iakwa!” ");
INSERT INTO mvn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wayahina, onotona vi‑tanaiei, ivona, “Avi tuta wayahina natu a kwanaha venau‑tawanei?” E taui ivona, “Navinavi, auyewa pouna eha ani‑hoina munina.” ");
INSERT INTO mvn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka onotona nuani, tuta‑nana wayahina Iesu ivona, “Natum vidoha, edueyei.” Wayahina, onotona yana yoko habuhabui, kadu ya tau paisewa habuhabui Iesu ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dewana dewa‑bagibagina vꞌ‑inuana Iesu dewei meagai Kana nihenina. Tauna Iudea a papani ni‑tawanei, e Galili a papani wayahina vinꞌ‑omo, e munia dewei. ");
INSERT INTO mvn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka dewa‑naia iakwa, e me Iudea yai dewa vivane kadu aitam tonei idedewei Ierusalem wayahina. Ka toneina wayahina Iesu ivane Ierusalem. ");
INSERT INTO mvn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ka Ierusalem nihenina SipiV Yai Awa nepena aitam daudau ibwaniu mamaei. Ka daudau‑nana me Ebereu movia ivi‑wahani BetesadaV. Ka papani‑nana wayahina manua pai vi‑wauna nima papanina imamaei daudau awaniana. ");
INSERT INTO mvn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka manua‑naia nihenia tau kwanakwanaha habuhabui idaudauva, tau mata‑goyogoyo, ka tau ae‑goyogoyo, ka tau penapena. ");
INSERT INTO mvn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tuta tuta Kauvea yanꞌ anelose aitam iopu ibwaniu‑nana inui, ka daudau vo‑vi‑tatatavi. Ka daudau ya nau‑tatatava munia, e aituhu koiaka eta‑naoi, na‑opu daudaua, tauna vidoha, aviani deina a kwanaha. ");
INSERT INTO mvn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ka aitam onoto a kwanaha wayahina mamaei ponimana ai yau 38 nihenia. ");
INSERT INTO mvn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ka Iesu vinꞌ‑omo, ka tutana tauna onotona dueyei, ka kadu avaha anamanei ponimana habuhabuna a kwanaha wayahina mamaei, tauna onotona vi‑tanaiei, ivona, “Wamke yam nuanua evidoha?” ");
INSERT INTO mvn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wayahina, tau kwanakwanahana ivona, “Bada, daudau ya nau‑mwaimwai ana tuta wayahina, eha aitam au tau ivaita, e daudaua na‑opueu. Tuta habuhabuna adewa‑dadani ana‑opu kate eha au pata. Naona mani tau kwanakwanaha iopu, e tauna vidoha, ka yauke eha.” ");
INSERT INTO mvn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wayahina, Iesu onotona vonei, ivona, “Emini, ka yam sita enunumi, ka ena‑ne.” ");
INSERT INTO mvn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ka vo‑kwayavonina onotona vidoha, e yana sita epei, e ni‑awana. Ka auyewana auyewa tapanono. ");
INSERT INTO mvn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ka me Iudea ai tau eta‑naonao onotona idudueyei. Wayahina ivi‑tanai, ivona, “Ataina auyewa tapanono ana tuta, ka aviani iuna wamke yam sita eavanei?” ");
INSERT INTO mvn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka onotona yai vonana vona‑nau‑patei, ivona, “Onotona vo‑vi‑aiaieu voneu, ‘Yam sita enꞌ‑epei, ka ena‑ne.’” ");
INSERT INTO mvn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka kadu ivi‑tanaiei, “Avi onoto vonem deina?” ");
INSERT INTO mvn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ka tauna a kwanaha iakwa Iesu ana wava eha tꞌ‑anamane, iuna yoko ananina papani‑nana wayahina, ka Iesu avaha inui ine. ");
INSERT INTO mvn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ka munia, Iesu onotona vaniahei Manua Vito‑pota nihenina, e vonei, ivona, “Edu! Avaha evidoha. Eha kadu goyona ededewe, kadi apaina dewa goyona ani‑vainena evaniahei.” ");
INSERT INTO mvn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka onotona omo me Iudea yai tau eta‑naonao wayahia, e haeyei vivane a tau vo‑vi‑aiai‑nana vivane Iesu. ");
INSERT INTO mvn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dewana wayahina, me Iudea‑naia ivi‑putu Iesu iawa‑viaohei, iuna auyewa tapanono wayahina onotona vo‑vi‑aiaiei. ");
INSERT INTO mvn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka Iesu me Iudea‑naia vonei, ivona, “Auyewa aitamoata aitamoata Amau paipaisewa, kadu yauke apaipaisewa deinake.” ");
INSERT INTO mvn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ka me Iudea‑naia, avaha ya vonana inononi, idewa‑dadani yai etawana memeanina ivaniahei inau‑vi‑anigi. Iuna ainua wayahia mamaei. Naona, taui mataia tauna auyewa tapanono a veimea tana‑bwegei. Ka vꞌ‑inuana, tauna ivona vivane Yaubada tauna Ama‑hoina, e vonana anꞌ anamana vivane tauna ya bagibagi ka Yaubada ya bagibagi eha tunina, kate aitamoata. ");
INSERT INTO mvn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wayahina Iesu tomotaui vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi eha aitam dewa yauke au heta‑ohota au pata adewe. Ka avi dewa Amau dedewei, yauke avaha dewaia adueyei, ka ataina dewaia adedewei. ");
INSERT INTO mvn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iuna Amau dune‑nuanuaieu ananina, ka avi dewa tauna dedewei, tauna dewaia habuhabui viwaveneu. Ka dewaia avaha adewei udueyei kikituna. Apaina Amau dewa ananina viwaveneu adedewei, ka avi tuta habuhabumi dewaia ududueyei, e nuami vi‑tupatupa wayahi. ");
INSERT INTO mvn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Amau tau anianiga si‑vi‑mini‑havine, e yawai venevenei, ka yauke kadu deina. Aituhu aviyaivia yau nuanua, akanai taui yawai avenevenei. ");
INSERT INTO mvn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ka Yaubada eha tomotau ai tau vaneneha, kate tauna awaeheu yauke avi‑tau vaneneha wayahi. Wayahina, yauke ai nau‑pata avi‑nua‑dadani. ");
INSERT INTO mvn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Amau yana dewa deina, iuna tauna ya nuanua tomotau habuhabui iawa‑davedaveu, taui Amau iawa‑davedavei aitamoata deina. Ka aituhu aviyaivia ivihahaieu, taui kadu Amau ivihahaiei, iuna tauna vi‑tuneu aomo. ");
INSERT INTO mvn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Aituhu aviyaivia yau vona inononi, kadu aituhu tauna vi‑tuneu ivitumahanei, akanai taui yawai‑vavaha ivaniahei, e apaina auyewa vitana matana wayahina, taui eha vitana matana wayahina inuinu, iuna avaha aniga a papani ini‑tawanei, e iaubo‑tamana yawai‑hoina a papani wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka kadu memeanina nuami vi‑tupatupa, kate avonemi, tuta tepakaia (ka avaha omo ataina!) tau anianiga Tauna Vi‑tomotau movina inononi, ka aituhu aviyaivia movina inononi yawai‑hoina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Amau vivane yawai‑hoina iuna. Wayahina, tauna avaha awaeheu yauke kadu yawai‑hoina iuna. ");
INSERT INTO mvn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ka kadu tauna awaeheu avi‑tau vaneneha tomotau habuhabui wayahi. Ka nau‑wawaniu adewei deina, iuna yauke avi‑tomotau tanopia. ");
INSERT INTO mvn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eha nau‑wawanimi nuami vi‑tupatupa dewana wayahina. Iuna tuta tepakaia wayahina tau anianiga aitamoata aitamoata unuvovoa moviu inononi, ");
INSERT INTO mvn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","e unuvovoa ini‑ubau ivinꞌ‑omo. Ka aituhu taui yai dewa ahiahina, imini, e yawai‑hoina ivaniahei. Ka aituhu taui yai dewa goyona, imini, e vitana matana a dewa‑yaiyai ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eha au pata yauke taua dewaia tanopia au heta avi‑nua‑dadani. Iuna aviani Yaubada voneu, vonana tunuhina anononi. Wayahina, avi tuta avaneneha ka anau‑yanahi, dewana adewei tunuhina. Iuna eha nuanuau yau nuanua adedewe. Kate tauna vi‑tuneu ya nuanua, akanai nuanuau adedewei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Aituhu yauke au heta ahaehaeyeu, hae‑nana eha hae ahiahina, kadu eha nau‑wawanimi uvitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kate kadu aitam mamaei, ka tauna avaha haeyeu. Ka yauke avaha anamane‑yehai vivane aviani yana hae wayahiu, akanai hae‑nana tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nonova itomi yami tau tuyeha tupwai uvi‑tunei iomo Ioni Tau Bapitaiso wayahina, e tauna vona tunuhina haeyei. ");
INSERT INTO mvn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka eha nau‑wawaniu tomotau yai hae wayahiu anononi. Ka vonana ahaeyei Ioni wayahina, e nuami nꞌ‑am‑hauhau, kadue ito‑yavuha uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Avonemi Ioni Tau Bapitaiso odama deina, ananata ka tunu‑mahetana. Ka nonova tuta kutakutana nihenina itomi yami nuanua tauna ya maheta‑nana wayahina udewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ka Ioni yana hae wayahiu eha ananina. Kate kadu aitam hae wayahiu mamaei, ka hae‑nana ananina. Akanai paisewai adedewei, taui hae ananina wayahiu. Amau paisewaia veneu adedewei. Ka dewaia iviwavenemi Amau vi‑tuneu. ");
INSERT INTO mvn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ka kadu aitam haehaeyeu, tauna au tau vi‑tune, vivane Amau. Kate itomi eha aitam tuta movina uta‑nononi, kadu eha tepana uta‑dueye. ");
INSERT INTO mvn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kadu eha yana vona wayahimia nuami nihenina uta‑nua‑vi‑anai. Iuna Yaubada vi‑tuneu, kate itomi eha uta‑vitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tuta habuhabuna itomi Iginuma uaiaiavi, iuna unuanua Iginuma‑nana nihenina yawai‑vavaha uvaniahei. Kate eha uta‑nua‑hau, e Iginuma‑nana kadu haehaeyeu! ");
INSERT INTO mvn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kate eha yami nuanua wayahiua unꞌ‑omo, e wayahiua yawai‑vavaha uvaniahe. ");
INSERT INTO mvn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Aituhu tomotau iawa‑daveu, o aituhu eha iawa‑daveu, dewana eha aitam aviani wayahiua. ");
INSERT INTO mvn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kate yauke avaha anamanemi itomi eha Yaubada uta‑dune‑nuanuaie nuami nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iuna yauke Amau a wavea aomo wayahimia, kate uvihahaieu. Aituhu kadu aitam onoto na‑omo wayahimia, ka aituhu onotona ana heta ana wava na‑si‑nai, akanai tauna wayahina udewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Itomi yami nuanua tomotau inꞌ‑awa‑davedavemi unononi. Kate awa‑dava Yaubada wayahina, dewana eha aitam aviani wayahimia. Itomi eha udewa‑dadani awa‑dava Yaubada wayahina uvaniahe. Wayahina, eha memeanina wayahimia uvitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eha nau‑wawanimi unuanua yauke Amau matana amana‑giboemi. Kadu aitam onoto mamaei, ana wava Mosese. Ka ataina itomi unuanua apaina tauna na‑ivaitemi, kate avonemi eha. Itomi uvonavona vivane Mosese uvitumahanei, kate apaina tauna na‑mana‑giboemi. ");
INSERT INTO mvn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aituhu itomi Mosese ya iginuma uvitumahana‑vavahi, e nau‑wawanimi kadu yauke uvitumahaneu, iuna nonova tauna wayahiu ginumi. ");
INSERT INTO mvn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kate itomi eha ya hae‑nana uta‑vitumahane, wayahina medeina yau vona uvitumahane?” ");
INSERT INTO mvn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Dewa‑naia iakwa, e me Iudea yai Itouvuha Toneina ana tuta vi‑mwaupwani. Ka Iesu Navu Galili taniana mamaei. Ka navu‑nana ana wava ainua. Tupwai tomotau ivi‑wahani Navu Tiberiasi. Ka Iesu tauna a tau vi‑muni‑waiwai nui ivi‑ata, e navu‑nana iaubo‑tamana mani papania. Ka yoko ananina Iesu ivi‑muniei, iuna taui avaha ya dewa‑bagibagi tau kwanakwanaha wayahi idudueyei. Ka Iesu tauna a tau vi‑muni‑waiwai nui atu‑oyaoyana wayahina ivane, e imanuena. ");
INSERT INTO mvn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ka Iesu dune‑nau‑nene, e yoko ananina dudueyei vivane tauna ana heta wayahina iomomo. E Iesu Pilipi vi‑tanaiei, ivona, “Pilipi, medeina aniani kavi‑maiei vivane ana pata tomotau taina kavi‑am‑neiei?” ");
INSERT INTO mvn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu Pilipi nau‑dadani vi‑tanai‑nana wayahina, iuna Iesu ana heta avaha anamanei apaiku aviani na‑dewei yoko‑naia wayahi. ");
INSERT INTO mvn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka Pilipi Iesu vonei, ivona, “Yoko taina ani‑vainena. Kaiwadi, aituhu onoto a nau‑pata wahava ai yau 8 nihenia mamaei, patana eha ana pata tomotau taina aitamoata aitamoata inꞌ‑am‑dadani.” ");
INSERT INTO mvn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kadu aitam Iesu a tau vi‑muni‑waiwai ana wava Aniduru, tauna Simoni Pita vaneina, vonei, ");
INSERT INTO mvn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ivona, “Aitam tupunaina avaniahei, e tauna a palaua baliV ai yau 5, kadu iana ainua wayahina. Kate kaiwadi, yoko taina wayahi eha ai pata.” ");
INSERT INTO mvn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Tomotau habuhabui uvonei wetau hetana imanuena.” Iuna papani‑nana wetau ahiahina. Ka habuhabui imanuena, ka ononotoi ai heta ai yau 5000 deina. ");
INSERT INTO mvn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ka Iesu palauana epei, e Yaubada wayahina nau‑kaiwa wayahi, ka munina palauana vi‑habu‑vaine. Ka tomotaui imanuena vo‑patai. Ka kadu iana ainuai wayahia dewei deina. Ka yoko‑naia habuhabui iam‑iaua. ");
INSERT INTO mvn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ka avaha habuhabui iam‑iaua, Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Palaua‑naia iam‑tenei ukwakwei. Eha ai iam‑tenei umudamudani.” ");
INSERT INTO mvn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ka tauna palaua ai yau 5 tomotau wayahi vi‑am‑neiei, ka a tau vi‑muni‑waiwai venuana ai yau 12 ivi‑nau‑vi‑anai iam‑tenei wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tutana tomotaui Iesu ya dewa‑bagibagina taina a iaiava idueyei, e ivona, “Vona‑vavaha, tauna Tau Apa‑taputapu‑nana! Nonova Mosese tauna ya iginuma nihenina mai‑voneka, e Tau Apa‑taputapu‑nana tanopia na‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ka Iesu avaha tomotau yai nuanua anamanei vivane tuta kutakutana na‑iakwa, e taui inꞌ‑omo, ipoyꞌ‑avini, e inau‑vi‑nehenehei tauna vi‑kiniV wayahi. Kate dewana eha Iesu ya nuanua. Wayahina, tauna ana heta ine aitam oya wayahina, e maiova. ");
INSERT INTO mvn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka tutana matana si‑hunuvi, a tau vi‑muni‑waiwai iopu Navu Galili taniana. ");
INSERT INTO mvn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ka aitam wae igenui, ivi‑ata, ione‑tamane‑havine meagai Kapenaum wayahina. Ka avaha ana iyaneyane, e vi‑novanei, kate Iesu eha ta‑omo wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ka yahina bagibagina hunahuna, kadu nupunina ananina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ka iyaneyane, ka avaha tupwana enoma ine, 5 o kadi 6 kilomitaV deina, ka Iesu navu hetana omomo yai waꞌ nepena idueyei. Ka tutana idueyei, e habuhabui yaui inovo ananina. ");
INSERT INTO mvn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wayahina, Iesu vonei, “Eha umatamatauta, yauke taua.” ");
INSERT INTO mvn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ka avaha movina inononi, a tau vi‑muni‑waiwai iawaehei Iesu vi‑ata waea. Ka wae‑nana nau‑manini, e ivinꞌ‑omo papani‑nana taniana wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ka mana navi yokoia Navu Galili mani papanina imamaei aveta Iesu palauana wayahina nau‑kaiwa, e iam‑iaua. Ka taui avaha ianamanei auyewa iakwa wayahina Iesu a tau vi‑muni‑waiwai yai waꞌ aitamoata igenui, kadu ianamanei a tau vi‑muni‑waiwai ai heta avaha ivi‑ata ine, ka Iesu eha nui. Ka wae tupwai meagai Tiberiasi ini‑tawanei, iomo, e nepena inu, iduduna. ");
INSERT INTO mvn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ka yoko habuhabui Iesu inene‑wayohei, kadue taui tauna a tau vi‑muni‑waiwai inene‑wayohei deina. Ka yokoia, avaha ianamanei Iesu kadu a tau vi‑muni‑waiwai habuhabui eha nui, ine me Tiberiasi yai waꞌ ivi‑ata, e iaubo‑tamana Kapenaum wayahina, e Iesu inenei. ");
INSERT INTO mvn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ka avaha ivaniahei Navu Galili mani papanina, ivi‑tanaiei, ivona, “Tau Viwavenena, avi tuta baina eomoi?” ");
INSERT INTO mvn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka tauna tomotaui wayahia ivona, “Memeanina nuami vi‑tupatupa, kate avonemi uneneneu iuna palaua‑naia uam‑neiei, e uam‑iaua. Itomi avaha iaiaya ani‑vainena tanoi udueyei, kate eha uta‑nua‑hau. ");
INSERT INTO mvn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eha nau‑wawanimi aniani na‑nau‑kunukunu wayahina upaipaisewa, kate nau‑wawanimi upaipaisewa aniani maꞌ‑vavaha wayahina. Apaina yauke, Tauna Vi‑tomotau, aniani maꞌ‑vavaha avenemi. Ika, Yaubada, Amau, vi‑nua‑dadaneu, ka tauna ya vi‑nua‑dadana tanoi a pai ainana veneu.” ");
INSERT INTO mvn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka taui ivi‑tanaiei, ivona, “Avi dewa Yaubada ya nuanua nau‑wawaniai adedewei?” ");
INSERT INTO mvn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka Iesu vonei, ivona, “Yaubada vi‑tuneu, kadu tauna ya nuanua uvitumahaneu.” ");
INSERT INTO mvn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka ivi‑tanaiei, ivona, “Avi iaiaya bagibagina ena‑dewe eviwaveneai, nau‑wawaniai avitumahanem? ");
INSERT INTO mvn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pai dune taina, nonova yaka tupua‑nenenehi aninina udanata iania, ana wava manaV. Iginuma voneyei deina, ‘Tauna aniani wahuma wayahina venei, e iam,’ kate wamke medeina? Tuta tuta aniani eveneai, anꞌ‑am, e aituhu iaiaya‑nana edewe, adueyei, akanai avitumahanem.” ");
INSERT INTO mvn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka Iesu tomotaui vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, Mosese eha aniani wahuma wayahina ta‑venemi, kate ataina Amau anini‑hoina wahuma wayahina venevenemi. ");
INSERT INTO mvn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Iuna, aitam onoto avaha opu‑me tanopia, ka tauna anini‑hoina Yaubada wayahina, ka kadu tomotau yawai‑hoina venevenei.” ");
INSERT INTO mvn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ka taui kadu Iesu ivonei, ivona, “Bada, ataina a itoava auyewa pai nau‑yehata wayahina, aninina tanoi eveneveneai.” ");
INSERT INTO mvn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ka Iesu vonei, ivona, “Yauke taua yawai anꞌ aniani. Wayahina, aituhu aviyaivia iomo wayahiua, eha aitam tuta am inavovo, kadu aituhu aviyaivia ivitumahaneu, eha aitam tuta magai nꞌ‑ayaya. ");
INSERT INTO mvn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ataina itomi ududueyeu, kate eha uta‑vitumahaneu. Avaha avonemi deina. ");
INSERT INTO mvn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Aituhu aviyaivia Amau na‑veneu, apaina taui wayahiua inꞌ‑omo, kadu eha aitam wayahia atana‑wavini. ");
INSERT INTO mvn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iuna, yauke wahuma aopu‑me, kate eha nuanuau yau nuanua adedewe. Yauke aomo iuna nuanuau tauna vi‑tuneu ya nuanua adedewei. ");
INSERT INTO mvn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ka au tau vi‑tune‑nana tomotau tupwai veneu, kadu tauna ya nuanua yauke eha aitam koiaka wayahia ani‑kaietei, kadu ya nuanua auyewa pai nau‑yehata wayahina, aitamoata aitamoata wayahia anigea asi‑vi‑mini. ");
INSERT INTO mvn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yauke Tauna Vi‑tomotau. Ka aituhu aviyaivia idueyeu, ivitumahaneu, akanai taui habuhabui yawai‑vavaha ivaniahei. Ka yauke, auyewa pai nau‑yehata wayahina, anigea asi‑vi‑mini‑neiei. Ka Amau ya nuanua aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka tau vi‑papani Galili (taui me Iudea), avaha ya vonana inononi, ivi‑putu inau‑vonuvonuei. Iuna tauna ivona, “Yauke aninina, ka yauke wahuma wayahina aopu‑me.” ");
INSERT INTO mvn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ka taui kadu ivona, “Onoto taina Iosepa natuna, ana wava Iesu, a? Ka amana ka ayona kanamanei. Wayahina, medeina tauna ivona, ‘Yauke wahuma aopu‑me’?” ");
INSERT INTO mvn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Akaka Iesu nau‑patei, ivona, “Eha taumi wayahimia unau‑vonuvonu wayahiu. ");
INSERT INTO mvn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iuna, Amau tauna vi‑tuneu, ka aituhu aviyaivia wayahiua iomomo, akanai taui iomomo iuna tauna taitaini. Ka auyewa pai nau‑yehata wayahina yauke taui habuhabui anigea asi‑vi‑mini‑havinei. Ka aituhu aviyaivia Amau eha taitaini, taui eha wayahiua inꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nonova tau apa‑taputapu vona taina ginumi Iginuma nihenina, e ivona, ‘Apaina Yaubada ana heta tomotau habuhabui viwavene‑neiei.’ Wayahina, aituhu aviyaivia Amau ya viwavenena inononi, inua‑haui, akanai taui kadu wayahiua iomomo. ");
INSERT INTO mvn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kate eha aitam koiaka wayahimia Amau ta‑dueye, akanai yauke au heta. Iuna yauke Yaubada ani‑tawanei avinꞌ‑omo baina. Taua au heta avaha Yaubada adueyei. ");
INSERT INTO mvn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia ivitumahaneu, taui avaha yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iuna yauke yawai anꞌ anini‑hoina. ");
INSERT INTO mvn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nonova anata nihenina yami tupua‑nenenehi aninina ana wava manaV ianiania, kate munia ianiga. ");
INSERT INTO mvn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka aniani taina wahuma opu‑me, ka aituhu aviyaivia inꞌ‑ania, apaina taui eha inꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yauke yawai anꞌ aniani, ka wahuma aopu‑me. Ka aituhu aviyaivia aniani taina inꞌ‑ania, akanai taui yawai eha na‑iakwa, kate imaꞌ‑vavaha. Ka aninina avenemi vivane viou. Iuna yauke viou awaehei tau maꞌ tanopi habuhabumi yawaimi wayahi.” ");
INSERT INTO mvn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka me Iudea‑naia avaha ya vonana inononi, matataui ivi‑gwahegwahea, ivona, “Medeina onoto taina ana pata viona na‑veneka, kanꞌ‑ania?” ");
INSERT INTO mvn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ka Iesu vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, yauke Tauna Vi‑tomotau. Aituhu itomi eha viou unꞌ‑ania, ka aituhu eha dayahiu una‑nim, akanai itomi eha yawayawaimi. ");
INSERT INTO mvn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kate aituhu aviyaivia viou ianiania, kadu aituhu dayahiu inimnim, akanai taui avaha yawai‑vavaha ivaniahei, ka auyewa pai nau‑yehata wayahina anigea asi‑vi‑mini‑havinei. ");
INSERT INTO mvn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iuna viou anini‑hoina, kadue dayahiu pai maga biga‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wayahina, aituhu aviyaivia viou ianiania kadue dayahiu inimnim, taui niheniua imamaei, kadue yauke nihenia amamaei. ");
INSERT INTO mvn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Amau yawayawaina, ka tauna vi‑tuneu, kadu yauke yawayawaiu iuna tauna. Wayahina, aituhu aviyaivia yauke taua ianianiu, akanai taui yawayawai iuna yauke aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aniani taina wahuma opu‑me. Kate eha aninina yami tupua‑nenenehi anata nihenina iania deina, e apaina ianiga. Aituhu aviyaivia aniani taina ianiania, taui yawayawai imaꞌ‑vavaha.” ");
INSERT INTO mvn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu vonaia habuhabui haeyei tutana tauna viwavenena manua tapanono nihenina papani Kapenaum nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ka a tau vi‑muni habuhabui Galili nihenina imamaei, kate avaha Iesu ya vonana inononi, e taui matataui ivonavona, “Viwavenena tanoi vita‑vainena. Medeina kawaehe? Eha aka pata.” ");
INSERT INTO mvn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ka Iesu avaha mai‑anamanei vonana wayahina inau‑vonuvonu, e wayahia ivona, “Vonana viteyemi, a? ");
INSERT INTO mvn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yauke Tauna Vi‑tomotau. Aituhu avane papani‑nana wayahina nonova aopu‑me, kadue aituhu itomi udueyeu, kaiwadi, auyewana wayahina medeina unuanua? ");
INSERT INTO mvn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yaubada Nuana Ahihinata, tauna a heta‑ohota yawai iuna. Ka tomotau yai bagibagi eha aitam aviani. Ka yau vonaia avaha avonemi, ka vonaia vivane Yaubada Nuana, kadu vonaia vivane yawai‑hoina. ");
INSERT INTO mvn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ka tupwami eha uta‑vitumahaneu.” (Iesu vonaia tomani iuna tauna mai‑anamanei taui eha ita‑vitumahana, kadu tauna mai‑anamanei koiaka a tau vi‑nua‑hauhauna.) ");
INSERT INTO mvn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ka kadu vonei, ivona, “Tanoi iu‑hoina avaha avonemi, aituhu Amau eha nꞌ‑awaeha, akanai itomi eha ami pata wayahiua unꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Vonana wayahina Iesu a tau vi‑muni habuhabui imagigino, ini‑tawanei, ka eha kadu aitam tuta ita‑vi‑munie. ");
INSERT INTO mvn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ka taui ai yau 12 itupwa, ka Iesu vi‑tanaiei, ivona, “Itomi medeina? Uni‑tawaneu, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Akaka Simoni Pita Iesu vona‑nau‑patei, ivona, “Kauvea, koiaka wayahina anꞌ‑omo? Iuna wamke am heta wayahima yawai‑vavaha ana vona mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Akaka ataina itoai avaha avitumahanem, kadu avaha anamanem wamke Tau Ahihinata Yaubada wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ka Iesu nau‑patei, ivona, “Vona ahiahina, yauke itomi ami yau 12 avi‑nua‑dadanemi, kate aitam wayahimia vivane Satana ya tau paisewa.” ");
INSERT INTO mvn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu vonana ivona Iudasa wayahina. Iudasa tauna Simoni me Kariota natuna, ka kadu aitam Iesu a tau vi‑muni‑waiwai, kate munia tauna Iesu vi‑nua‑hauhauei. ");
INSERT INTO mvn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ka dewaia iakwa, e Iesu papani Galili nihenina ni‑vivivina, ka eha ya nuanua papani Iudea nihenina na‑tutu‑vivina, iuna me Iudea yai tau eta‑naonao yai nuanua ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ka avaha Vekevekeke Toneina ana tuta vi‑mwaupwani, e me Iudea ivo‑vi‑aiai. ");
INSERT INTO mvn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wayahina, Iesu vavaneina ivonei, ivona, “Papani taina eni‑tawanei ena‑ne papani Iudea wayahina, e tenoke am tau vi‑muni ai pata yam dewa‑bagibagi idudueyei.” ");
INSERT INTO mvn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kadu ivonei, ivona, “Eha aitam koiaka dewa hivahivai dedewei, e ana wava na‑nata. Wayahina, aituhu wamke yam nuanua tomotau habuhabui inꞌ‑anamanem, akanai nau‑wawanim taum eviwavenem idudueyem.” ");
INSERT INTO mvn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Vavaneina iaipuipupu deina, iuna taui kadu eha ita‑vitumahane vivane tauna Tau Ito‑yavuha‑nana.) ");
INSERT INTO mvn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ka Iesu vonei, ivona, “Yauke yau tuta eha ata‑vaniahe, apaina. Kate itomi wayahimi, aituhu avi tuta yami nuanua una‑ne, akanai tuta‑nana tuta ahiahina wayahimi, e ami pata una‑ne. ");
INSERT INTO mvn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iuna eha ana pata tau maꞌ tanopi inau‑nikonikoiemi. Kate taui inau‑nikonikoieu, iuna tuta tuta taui mataia yai dewa asi‑vinꞌ‑omanei vivane goyona. ");
INSERT INTO mvn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ahiahina! Itomi una‑ne tonei taina wayahina. Yauke taua eha ana‑ne. Iuna, yau tuta ahiahina eha ta‑vinꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesu avaha ivona deina, e tauna ana heta Galili nihenina mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ka Iesu vavaneina tauna ini‑tawanei, e taui ine tonei‑nana Ierusalem wayahina, kadu munia Iesu papani Galili ni‑tawanei ine tonei‑nana wayahina, kate hivahivana, ka eha aitam koiaka tꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ka tonei‑nana nihenina me Iudea yai tau eta‑naonao Iesu inenenei, kadu ivi‑tanatanaiei, ivonavona, “Tauna aveta?” ");
INSERT INTO mvn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka tanoi wayahina tomotau habuhabui matataui ivi‑awa‑yaya Iesu wayahina, ka inau‑vonuvonu taina deina. Tupwai ivonavona, “Tauna onoto ahiahina,” kate tupwai ivonavona, “Eha! Tauna tau vitupu, ka tomotau vo‑vi‑banabanai.” ");
INSERT INTO mvn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ka eha aitam koiaka ta‑vonavona Iesu wayahina tomotau yoko mataia. Iuna me Iudea habuhabui taui yai tau eta‑naonao imatamatautei. ");
INSERT INTO mvn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ka avaha tonei‑nana ana wiki niwanina, Iesu Manua Vito‑pota a pai vi‑wauna wayahina inu, e vi‑putu tomotau viwavenei. ");
INSERT INTO mvn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wayahina, tutana me Iudea yai tau eta‑naonao inononi, taui nuai vi‑tupatupa ananina kadu matataui ivi‑tanaiei, ivona, “Tauna eha aitam tuta wayahina ta‑iaiava baina yama pai anamana ananina nihenina. Wayahina, aveta wayahina onoto taina ya nua‑uya vaniahei? Kaiwadi!” ");
INSERT INTO mvn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Akaka Iesu nau‑patei, ivona, “Yauke yau nua‑uya eha taua wayahiua ta‑vinꞌ‑omo, kate au tau vi‑tune tauna ya nua‑uya veneu, aviwavenena. ");
INSERT INTO mvn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ka aituhu aviyaivia ivi‑nua‑dadani, e Yaubada ya nuanua idedewei, apaina taui yau viwavenena inꞌ‑anamanei vivane Yaubada wayahina vinꞌ‑omo, eha taua wayahiua ta‑vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aituhu aviyaivia yai nuenuea iviwavenena, yai nuanua taui ai wava isi‑nai, ivo‑vi‑natei. Kate aituhu koiaka a tau vi‑tune ana wava si‑nai, vo‑vi‑natei, tauna onoto ahiahina ka tunuhina, ka tauna nihenina eha aitam aviani goyona. ");
INSERT INTO mvn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vona ahiahina, Mosese ami veimea venemi, kate eha aitam koiaka wayahimia ta‑vivi‑muni ahiahina. Aituhu veimeana uvivi‑muni ahiahina, aviani iuna yami nuanua una‑nau‑vi‑anigiu?” ");
INSERT INTO mvn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka yoko‑naia yana vona inau‑patei, ivona, “Ia! Nua gawagawamina ununum vo‑vi‑magiginoei, wayahina evonavona deina! Koiaka wayahiaia dewa‑dadani na‑nau‑vi‑anigim?” ");
INSERT INTO mvn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ka Iesu yai vonana vona‑nau‑patei, ivona, “Auyewa tapanono wayahina dewa‑bagibagina aitamoata adewei, e onoto avo‑vi‑aiaiei, vidoha. Wayahina, itomi nuami vi‑tupatupa ananina. ");
INSERT INTO mvn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kate medeina itomi yami dewa auyewa tapanono wayahina? Mosese veimeyemi itomi natunatumi ononotoi wagai udabedabe‑neiei pai dune wayahina. (Ka vona tunuhina, veimeana eha Mosese wayahina ta‑vinꞌ‑omo, kate nonova yaka tupua‑nenenehi dewana ivi‑putui, ka dewana taui wayahia vinꞌ‑omo.) ");
INSERT INTO mvn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wayahina, dewana tevana ononotoi wayahia udedewei auyewa tapanono wayahina, iuna Mosese ya veimea uvi‑muniei, ka eha ubwege. Wayahina, aviani iuna unau‑havieu tutana auyewa tapanono wayahina onoto avo‑vi‑aiaiei vidoha‑vainei? ");
INSERT INTO mvn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Avi tuta tomotau yai dewa unau‑yanahi utana‑vewani, kadi ahiahina o goyona, eha nau‑wawanimi yai dewa ai dune ana heta wayahina uvi‑nua‑dadani, kate nau‑wawanimi yai dewa iuna unau‑yanahi.” ");
INSERT INTO mvn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ka tupwai me Ierusalem ivona, “Kaiwadi, tau eta‑naonao yai nuanua onoto taina ina‑nau‑vi‑anigi, a? ");
INSERT INTO mvn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kate udueyei! Tauna avaha tomotau niwania mimini ka vonavona wayahia, ka eha aitam koiaka movina ta‑vito‑pote. Medeina? Yaka tau eta‑naonao avaha iawaehei vivane tauna Tau Ito‑yavuha? ");
INSERT INTO mvn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Eha ana pata. Iuna onoto taina ya meagai avaha kanamanei. Kate avi tuta Tau Ito‑yavuha‑nana na‑omo, eha aitam koiaka ya meagai nꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ka Iesu ya viwavenena Manua Vito‑pota a pai vi‑wauna nihenina eha ta‑iakwa, ka movina ananina wayahina ivona, “Ika, itomi avaha uanamaneu. Ka kadu avi papani wayahina aomo avaha uanamane‑yehai. Yauke aomo papani taina wayahina, kate eha taua yau nuanua ana heta adewei deina. Au tau vi‑tune‑nana, tauna yana dewa ahiahina kadu tunutunuhina akanai. Kate itomi eha utꞌ‑anamane koiaka tauna. ");
INSERT INTO mvn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ka yauke anamanei, iuna tauna vi‑tuneu, ka kadu ani‑tawanei avinꞌ‑omo baina tanopia.” ");
INSERT INTO mvn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ka vonana wayahina tomotau tupwai yoko‑nana nihenina idewa‑dadani ipoyꞌ‑avini. Ka eha aitam koiaka wayahia ta‑vo‑dadani. Iuna tauna eha yana tuta ta‑vaniahe yanꞌ aniga wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ka tomotau habuhabui yoko‑nana nihenina ivitumahanei ka ivona, “Vona ahiahina, onoto taina dewa‑bagibagi habuhabui avaha dedewei. Avi tuta Tau Ito‑yavuha‑nana na‑omo, kadi ana pata tauna ya dewa‑bagibagi onoto taina ya dewa‑bagibagi nata‑tawane?” ");
INSERT INTO mvn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ka tomotau ivi‑awa‑yaya Iesu wayahina deina. Ka avaha Parisi dewaia inononi, e taui kadue tau vi‑nomu mata‑genai taui yai tau nau‑havia ivi‑tunei, e Iesu iyohoni. Wayahina, tau nau‑havia‑naia iomo, e yana vona inononi. ");
INSERT INTO mvn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ka Iesu ivona, “Tuta kutakutana ana heta nui kamamaei. Apaina amavina tauna au tau vi‑tune‑nana wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka apaina uneneneu, kate eha uvaniahau. Ka auyewana wayahina papani tunina wayahina amamaei, ka itomi eha ami pata papani‑nana wayahina unꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wayahina, me Iudea‑naia matataui ivi‑vonavona, ivona, “Aveta wayahina tauna na‑ne vivane apaina eha kavaniahe? Kaiwadi, tauna na‑ne me Iudea‑naia, taui nonova yai meagai ini‑tawanei ine mani papani, e me Girisi nui imamaei? Kadi tenoke tauna me Girisi viwavenei, a? ");
INSERT INTO mvn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ya vonana aviani anꞌ anamana? Iuna ivona, ‘Apaina uneneneu, kate eha uvaniahau,’ ka kadu ivona, ‘Papani tunina wayahina amamaei, ka itomi eha ami pata papani‑nana wayahina unꞌ‑omo.’” ");
INSERT INTO mvn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka toneina anꞌ auyewa ananina auyewa pai nau‑yehata. Ka auyewana wayahina Iesu yoko niwania mini, ka movina ananina vi‑hone, ivona, “Aituhu aviyaivia wayahimia magami ayayana, akanai unꞌ‑omo wayahiua, e una‑nim. ");
INSERT INTO mvn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ka Iginuma ivona deina, ‘Yawai a daudau au tau vitumahana nuana wayahina nꞌ‑am‑iwaiwahi.’” ");
INSERT INTO mvn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ka Iesu tauna ya vonana wayahina ipuipupu Yaubada Nuana Ahihinata wayahina. Ka aituhu aviyaivia Iesu ivitumahanei, apaina Nuana Ahihinata na‑nu nihenia, mamaei. Ka auyewa tanoi wayahina, Nuana Ahihinata eha ta‑nuinu tomotau nihenia, iuna Iesu eha wahuma ta‑vane, kadu tauna eha didigana ta‑vaniahe. Apaina. ");
INSERT INTO mvn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ka tomotau habuhabui Iesu ya vonana inononi, ka tupwai ivona, “Vona ahiahina, onoto taina vivane Tau Apa‑taputapu‑nana.” ");
INSERT INTO mvn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ka tupwai kadue ivona, “Tauna vivane Tau Ito‑yavuha‑nana.” Kate tupwai eha yai nuanua, ka ivona, “Vona ahiahina, Tau Ito‑yavuha‑nana ya tupua eha Galili wayahina! ");
INSERT INTO mvn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Medeina Iginuma voneka? Ivona vivane Tau Ito‑yavuha‑nana Davida yana dede wayahina omomo, kadu Davida ya meagai Betelehem nihenina na‑tupua. Ka Betelehem eha papani Galili nihenina! Wayahina, eha ana pata tauna vivane Tau Ito‑yavuha‑nana.” ");
INSERT INTO mvn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wayahina, tana‑vewana vinꞌ‑omo tomotau‑naia niwania deina. ");
INSERT INTO mvn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ka tupwai yai nuanua Iesu ipoyꞌ‑avini, kate eha aitam koiaka ta‑vo‑dadani. ");
INSERT INTO mvn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ka tau nau‑havia‑naia imavi tau vi‑nomu mata‑genai wayahia kadue Parisi wayahia. Akaka taui tau nau‑havia‑naia ivi‑tanaiei, ivona, “Aviani wayahina itomi eha uta‑poyꞌ‑avini, ka eha uta‑omane baina wayahiaia?” ");
INSERT INTO mvn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ka tau nau‑havia‑naia ivona, “Onoto tanoi yana vona ahihi‑vainena. Eha kadu aitam koiaka deina.” ");
INSERT INTO mvn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ka Parisi ivona, “Ia! Kaiwadi, tauna nonomi, kadu itomi nuami epei, a? ");
INSERT INTO mvn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ka avaha uanamanei, eha aitam koiaka itoai tau veimea o itoai Parisi wayahiaia Iesu ta‑vitumahane. Eha! ");
INSERT INTO mvn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yoko taina ivitumahanei, kate taui mwagemwagei, iuna eha Mosese ya veimea itꞌ‑anamane‑vidoha. Wayahina, ataina Yaubada taui ai nau‑pata goyona venevenei.” ");
INSERT INTO mvn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kate aitam tau veimea wayahia ana wava Nikodemusi. Nonova ioyoma tauna omo Iesu wayahina, e ainua iaipupu. Ka tauna yaiana vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Itoka aka veimea ivona deina, eha nau‑wawanika tomotau kanꞌ‑apa‑goyogoyo‑kavokavovo. Naona nau‑wawanika onoto kanononi, ka aituhu ya goyona kavaniahei deina, akanai, munia aka pata kadewa‑yaiyaiei.” ");
INSERT INTO mvn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ka tau eta‑naonao‑naia kadu Nikodemusi iyapoi, ivona, “Ia! Kaiwadi, wamke kadu aitam tevana Galili, a? Aituhu Iginuma ena‑iavi tunuhina, enꞌ‑anamanei eha aitam tau apa‑taputapu Galili wayahina na‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ka ipupuna iakwa, ka aitamoata aitamoata wayahia imavina yai megeia. ");
INSERT INTO mvn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kate Iesu ivane Oya Olive. ");
INSERT INTO mvn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ka mana navia mana‑putua mavi‑havine omo Manua Vito‑pota a pai vi‑wauna wayahina, ka tomotau habuhabui imaꞌ‑vivinei, e tauna manuena, e vi‑putu viwavenei. ");
INSERT INTO mvn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ka aitam vavine kenene dedewei, ka tomotau ivaniahei, kadu ipoyꞌ‑avini. Ka Mosese ya veimea a tau viwavenena, kadu Parisi vavinena iomanei, e niwania ivi‑au‑mini. ");
INSERT INTO mvn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ka taui Iesu ivonei, ivona, “Tau Viwavenena, vavine taina avaniahei kenene dedewei. ");
INSERT INTO mvn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ka aka veimea Mosese wayahina voneka, aituhu vaivine deinake kavaniahei, nau‑wawanika katutu‑hanuhanui. Ka wamke medeina evoneka?” ");
INSERT INTO mvn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yai nuanua vonana wayahina Iesu inonoi kadu ivitevitei. Kate Iesu eha yai vona ta‑nau‑pate, ka mai‑kokokona magama, ka nima‑tabona magama nihenina ginuginuma. ");
INSERT INTO mvn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka taui apaina ivi‑tanatanaiei. Akaka Iesu mini, e vonei, ivona, “Akanai. Aituhu aitam koiaka wayahimia eha aitam ya goyona, akanai tauna nau‑wawani hanu mai‑hapone vavine tanoi wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ya vonana iakwa, e mai‑kokokona‑havine, e magama nihenina ginuginuma. ");
INSERT INTO mvn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ka tutana tau eta‑naonao‑naia Iesu ya vonana inononi, taui yai goyona inuani. Wayahina, aitamoata aitamoata wayahia ini‑tawanei. Naona taui ivi‑nainai iyavuta, e habuhabui ivi‑muniei ka ine, e ainua imamaei, Iesu ka vavinena mimini. ");
INSERT INTO mvn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Akaka Iesu mini, e vavinena vonei, ivona, “Vavinem, edu! Taui habuhabui yai nuanua ivitavitam avaha iyavuta.” ");
INSERT INTO mvn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ka vavinena Iesu vonei, “Bada, ika. Eha aitam koiaka ta‑mamae.” Ka Iesu vonei, ivona, “Yauke kadu eha avitavitam, ka ahiahina ena‑ne, kate eha kadu goyona edewa‑havine.” ");
INSERT INTO mvn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ka Iesu tomotau wayahia vona‑havine, ivona, “Yauke tau maꞌ tanopi ai maheta. Wayahina, aituhu aviyaivia ivi‑muni‑waiwaieu, akanai yawai a maheta wayahia mamaei, ka eha kadue novanovana nihenina ineine.” ");
INSERT INTO mvn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ka Parisi Iesu wayahina ivi‑vonavona, ivona, “Ataina wamke taum ehaehaeyem. Wayahina, yam hae‑nana eha tunuhina, kadue eha nau‑wawaniai yam hae‑nana anononi.” ");
INSERT INTO mvn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ka Iesu vona‑nau‑pata wayahia, ivona, “Aituhu taua ahaehaeyeu, yau hae‑nana tunuhina. Iuna aitam papani ani‑tawanei aomo baina, ka papani‑nana avaha anamanei. Ka kadu apaina papani‑nana, aveta wayahina amavina, avaha anamanei. Kate itomi mwagemwagemi papani‑nana wayahina. Eha utꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka itomi goyona o ahiahina unau‑yanahi tau maꞌ tanopi habuhabui inau‑yanahi aitamoata deina. Kate ataina yauke eha tomotau ai nau‑pata yai goyona wayahina anau‑yanahi. ");
INSERT INTO mvn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aituhu apaina tomotau anau‑yanahi, ka aituhu ai nau‑pata avi‑nua‑dadani, akanai au pata anau‑yanahi ahiahina, iuna yauke au heta eha dewana ana‑dewe. Kate Amau, tauna vi‑tuneu, tauna nui ana‑dewei. ");
INSERT INTO mvn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kadue ami veimea ivona wayahimia deina, vivane aituhu tau hae ainua yai vona aitamoata, akanai hae‑nana tunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wayahina udu. Yauke taua ahaehaeyeu, ka kadu Amau, tauna vi‑tuneu, haehaeyeu.” ");
INSERT INTO mvn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wayahina ivi‑tanaiei, ivona, “Amam aveta?” Ka Iesu nau‑patai, ivona, “Itomi eha utꞌ‑anamaneu kadue eha Amau utꞌ‑anamane. Aituhu itomi uanamaneu, akanai kadu Amau unꞌ‑anamanei.” ");
INSERT INTO mvn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu ya vonana Manua Vito‑pota a pai vi‑wauna nihenina vonei tutana viwavenei. Dewaia ivinꞌ‑omo am‑venena‑kavovo didiwagana nepena. Ka auyewana wayahina eha aitam koiaka Iesu ta‑poyꞌ‑avini, iuna yana tuta eha ta‑vinꞌ‑omo. Apaina. ");
INSERT INTO mvn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ka Iesu vona‑havinei, ivona, “Apaina ani‑tawanemi, ka itomi unene‑wayoheu. Wayahina, yami dewa goyogoyoi wayahi unꞌ‑aniga. Iuna papani‑nana wayahina aneine itomi eha ami pata unꞌ‑omo.” ");
INSERT INTO mvn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ka me Iudea avaha vonana inononi, matataui ivi‑tanatanaiei, ivonavona, “Medeina ya vonana? Tauna ana heta na‑nau‑vi‑anigi? Kaiwadi, aina iuna tauna ivona, ‘Papani‑nana wayahina aneine, itomi eha ami pata unꞌ‑omo’?” ");
INSERT INTO mvn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kate Iesu vonei, ivona, “Itomi yami pai maꞌ tanopi taina, kate yauke yau pai maꞌ hetana wahuma. Ka itomi yami nuanua ananina tanopi taina wayahina, kate yauke eha ata‑nuanua tanopi taina wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wayahina, avaha avonemi, yami dewa goyogoyoi wayahi unꞌ‑aniga. Aituhu eha uvitumahaneu vivane yauke ‘Taua Amaꞌ‑vavaha,’ akanai vona ahiahina, yami dewa goyogoyoi wayahi unꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wayahina ivi‑tanaiei, “Taum koiaka?” Iesu kadue nau‑patei, ivona, “Nonova a itoava tuta ataina wayahina, ahaehaeyeu aitamoata ka tunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ipupu ananina yami goyona wayahi mamaei, ka au pata anau‑yanahimi wayahi. Kate tauna vi‑tuneu, tauna yana vona tunuhina. Ka aviani tauna voneu anononi, akanai vonaia itomi tau maꞌ tanopi wayahimia ahaehaeyei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kate taui eha yana vona Amana wayahina ita‑nua‑hau. ");
INSERT INTO mvn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Akaka Iesu vonei, ivona, “Yauke Tauna Vi‑tomotau, ka apaina usi‑naiu. Ka dewana na‑iakwa, unꞌ‑anamaneu, e ‘Taua Amaꞌ‑vavaha.’ Yauke eha au heta apaipaisewa, kate aviani Amau viwaveneu, akanai avonavona aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tauna vi‑tuneu, kadue tauna wayahiua mamaei. Ka kadu tauna eha ta‑ni‑tawaneu, iuna tauna yau dewa dudueyei, ka tuta tuta yau dewaia vo‑vi‑dewa‑haiawi.” ");
INSERT INTO mvn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ka tutana Iesu ya vonana inononi, tomotau habuhabui ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ka Iesu me Iudea‑naia (taui ivitumahanei) vone‑neiei, ivona, “Aituhu yau viwavenena uvi‑muni‑waiwaiei, akanai itomi au tau vi‑muni‑waiwai ahiahina. ");
INSERT INTO mvn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wayahina munia, itomi nua‑uya tunutunuhina unꞌ‑anamanei, ka nua‑uya‑nana na‑ito‑yavuhimi.” ");
INSERT INTO mvn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka taui inau‑patei, ivona, “Itoai Abaraham yana dede, ka eha aitam tuta wayahina ata‑vi‑tau paisewa‑kavovo mani tomotau wayahi, iveimeyeai. Wayahina, aviani yam vona anꞌ anamana tutana evona, ‘na‑ito‑yavuhimi’?” ");
INSERT INTO mvn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Wayahina Iesu vone‑neiei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia tau goyogoyona, taui avaha ivi‑tau paisewa‑kavovo goyona wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aituhu onoto ananina aitam tau paisewa‑kavokavovo vi‑maiei, vona ahiahina, tau paisewa‑kavokavovo‑nana eha aitam onoto ananina yana dede wayahia, kate onoto ananina natunatuna, taui vivane yana dede nihenina imaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yauke, Tauna Vi‑tomotau, Amau Natu‑hoina, ka aituhu yauke ayavuhimi, akanai itomi yavuha‑vavaha uvaniahei deina. ");
INSERT INTO mvn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Avaha anamanemi, Abaraham dayahina nihenimia mamaei, kate yami nuanua una‑nau‑vi‑anigiu, iuna yau viwavenena eha uawaehe. ");
INSERT INTO mvn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aviani Amau viwaveneu adueyei, dewaia avonevonemi aitamoata deina. Kate aviani amami vonevonemi, akanai itomi udedewei deina.” ");
INSERT INTO mvn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Akaka taui Iesu ya vonana inau‑patei, ivona, “Itoai amai vivane Abaraham.” Kate Iesu vona‑havinei, ivona, “Aituhu itomi Abaraham natunatu‑hoina, akanai nau‑wawanimi tauna yana dewa ahiahina udedewei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kate yauke Yaubada ya nua‑uya tunutunuhina anononi, kadue ataina nua‑uyana wayahimia ahaehaeyei, kate itomi yami nuanua una‑nau‑vi‑anigiu. Abaraham yana dewa eha itomi yami dewa deina. Eha‑ohota! ");
INSERT INTO mvn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Itomi amami yana dewa udedewei.” Ka taui ivi‑vonavona deina, “Ia! Itoai eha payapayaya. Itoai amai aitamoata, tauna Yaubada a heta‑ohota.” ");
INSERT INTO mvn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ka Iesu wayahia ivona, “Aituhu Yaubada ama‑hoimi, akanai udune‑nuanuaieu. Iuna Yaubada vi‑tuneu aomo baina, amamaei. Eha yau nuenuea aomo, kate tauna ya nuanua aomo baina. ");
INSERT INTO mvn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Itomi eha yau vona uta‑nononi. Iuna eha yami nuanua una‑nua‑hau ahiahina.” ");
INSERT INTO mvn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ka Iesu vona panina taina wayahina vonei, ivona, “Itomi Satana natunatuna, iuna yami nuanua kadu Satana ya nuanua aitamoata, kadu tauna ya nuanua udedewei. Tuta pai vi‑putu wayahina a itoava tuta ataina wayahina, tauna vivane tau nau‑vi‑aniga. Eha aitam tuta tauna nua‑uya tunutunuhina ta‑ivaite. Iuna nua‑uya tunutunuhina eha tauna nihenina. Avi tuta tauna ipuipupu, vitupu ana heta ipuipupui. Iuna tauna tau vitupu, ka kadu tauna vitupu habuhabuna ama‑hoina. ");
INSERT INTO mvn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Udu! Yauke nua‑uya tunutunuhina wayahimia ahaehaeyei, kate eha uta‑vitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Eha aitam koiaka itomi wayahimia am pata yau dewa goyona enau‑viviwaveka, a? Wayahina, aituhu eha yau dewa goyona, kadu aituhu vona tunutunuhina wayahimia avonavona, medeina itomi eha uta‑vitumahaneu? ");
INSERT INTO mvn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Vona ahiahina, iuna taina. Aituhu aviyaivia Yaubada wayahina iomomo, akanai taui Yaubada yana vona inononi. Kate itomi eha Yaubada wayahina uomomo. Aina iuna itomi eha Yaubada ya vonana unonononi.” ");
INSERT INTO mvn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Me Iudea yai tau eta‑naonao Iesu ivonei, ivona, “Itoai yama vona ahiahina kadu tunuhina wayahim. Avonavona wamke me Samaria, kadu avonavona aitam nua gawagawamina veimeyem, a?” ");
INSERT INTO mvn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Akaka Iesu taui vonei, ivona, “Nua gawagawamina eha ta‑veimeyeu. Yauke Amau adewa‑didigunei, kate itomi taua umana‑giboeu. ");
INSERT INTO mvn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ka eha anaunau‑nene didigau wayahina. Vona ahiahina, kadu aitam mamaei, ka tauna ya nuanua didigau uvo‑vi‑natei. Ka avonemi, tauna vivane tau vaneneha. ");
INSERT INTO mvn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia yau vona inuanuani kadu idedewei, akanai taui nuai eha inꞌ‑aniga.” ");
INSERT INTO mvn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vonana wayahina me Iudea Iesu wayahina ivona panina, “Avaha anamane‑vidohem, aitam nua goyogoyona veimeyem! Iuna tuta nonova Abaraham aniga, kadue tau apa‑taputapu habuhabui ianiga deina. Kate wamke evonavona, ‘Aituhu aviyaivia yau vona inuanuani kadu idedewei, taui nuai eha inꞌ‑aniga.’ ");
INSERT INTO mvn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Itoai amai Abaraham avaha aniga, kadue tau apa‑taputapu habuhabui avaha ianiga. Wamke enuanua Abaraham ebagibagi‑tawanei, a? Medeina enuanua deina? Taum koiaka?” ");
INSERT INTO mvn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ka Iesu nau‑patei, ivona, “Aituhu yauke taua didigau avo‑vi‑natei, didigauna awakabina. Kate ataina Amau didigau vo‑vi‑natei, ka itomi uvonavona tauna yami Yaubada. ");
INSERT INTO mvn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nonova a itoava tuta ataina wayahina, itomi eha Yaubada utꞌ‑anamane, kate yauke anamanei. Aituhu ana‑vona, ‘Yaubada eha atꞌ‑anamane,’ vonana vitupu, ka avi‑tau vitupu itomi deina. Kate avonemi, yauke Yaubada anamane‑vidohei, kadu yana vona avi‑muniei, adedewei. ");
INSERT INTO mvn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ka amami Abaraham ya dewa‑haiawa nui yau vinꞌ‑omana vaneana nononi, ka ya nuanua ananina apaina dueyeu. Ka tauna dueyeu, kadu tauna dewa‑haiawa ananina wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ka me Iudea ivonei, ivona, “Ia! Wamke apaina am ponimana ai yau 50 evaniahei, kate medeina evonavona avaha Abaraham edueyei? Eha am pata!” ");
INSERT INTO mvn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ka Iesu vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Tutana Abaraham tupua, ‘Taua Amaꞌ‑vavaha’!” ");
INSERT INTO mvn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tutana me Iudea ya vonana inononi, e taui avaha ianamanei vivane tauna vonavona, “Taua Yaubada.” Wayahina, inua‑goyo‑vaine, kadu hanu iepepe, yai nuanua itutu‑hanuhanui, ivunuvunui. Kate Iesu wayahia maiova, e Manua Vito‑pota a papani wayahina ni‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tutana Iesu neine, tauna aitam onoto etawana dueyei, manuena mamaei. Onotona matana goyona ya tupua wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ka Iesu a tau vi‑muni‑waiwai kadu onoto‑nana idudueyei. Wayahina, taui Iesu ivi‑tanaiei, ivona, “Tau Viwavenena, koiaka dewa goyona dewei, e munia onoto taina matana goyona tupueyei? Kaiwadi, onoto taina yana dewa goyona wayahina vinꞌ‑omo, o kadi amana ayona ainua yai dewa goyona wayahina vinꞌ‑omo?” ");
INSERT INTO mvn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ka Iesu vonei, ivona, “Vona ahiahina, tauna matana goyona tupueyei, kate eha tauna yana dewa goyona wayahina ta‑vinꞌ‑omo, kadu eha amana ayona yai dewa goyona wayahina ta‑vinꞌ‑omo. Ka tauna tupueyei deina, iuna apaina Yaubada tauna ya bagibagi na‑si‑vinꞌ‑omanei, e tomotau idudueyei. ");
INSERT INTO mvn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Itoka nau‑wawanika tuta auyewa nihenina tauna vi‑tuneu ya nuanua kapaipaisewei. Iuna tuta ioyoma omomo, ka eha aitam koiaka ana pata paisewa ioyomana nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ataina yauke tanopia amamaei, ka tuta ataina a itoava yau nae wayahina, yauke vivane tau maꞌ tanopi ai maheta.” ");
INSERT INTO mvn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu, avaha vonana nau‑yehai, iwani iopu tanopi wayahina, ka motopuna nau‑vevewanei deina, e motopunana epei onotona matana wayahina nau‑wohi. ");
INSERT INTO mvn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","E vonei, ivona, “Ena‑ne Ibwaniu Siloam wayahina, ena‑toa (Siloam a vo‑vina ‘Vi‑tune’).” Akaka onotona matana goyona ine, toatoa, ka matana mahete, e tauna dunedune mavina ya megeia. ");
INSERT INTO mvn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ka tau vi‑meagai onotona ya meagai wayahina, kadu yaiana nonova idudueyei, ka ianamanei tauna vivane tau viama. Ka matataui ivi‑tanatanaiei, ivonavona, “Kaiwadi, tauna tau viama‑nana, e tuta tuta mamaei ka viama, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ka tupwai wayahia ivonavona, “Tauna aina.” Ka tupwai ivonavona, “Eha. Tauna mani onoto, kate ainua tepai aitamoata deina.” Ka onotona vonei, ivona, “Yauke taua!” ");
INSERT INTO mvn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wayahina, taui yai vona panina wayahina ivi‑tanaiei, ivona, “Medeina matam dunedune?” ");
INSERT INTO mvn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ka onotona vona‑nau‑patei, ivona, “Onotona, ana wava Iesu, motopuna nau‑vevewanei, e matau wayahina nau‑wohi. Iakwa, tauna voneu, ivona, ‘Ena‑ne Ibwaniu Siloam wayahina, e ena‑toa.’ Wayahina anei, atoatoa, e matau dunedune.” ");
INSERT INTO mvn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ka taui ivi‑tanaiei, ivona, “Tauna aveta?” Ka onotona ivona, “Kaiwadi. Eha katꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ka taui onotona ineiei Parisi yai yoko wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ka tutana Iesu motopuna nau‑vevewanei, onotona matana vo‑vi‑aiaia, auyewana vivane SabataV. ");
INSERT INTO mvn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wayahina, Parisi‑naia kadu onotona ivi‑tanaiei, ivona, “Medeina matam dunedune?” Akaka onotona vonei, ivona, “Iesu motopuna nau‑vevewanei, e matau wayahina nau‑wohi, atoatoa, e ataina adunedune.” ");
INSERT INTO mvn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ka tupwai Parisi ivona, “Vona ahiahina, koiaka dewana dewei, tauna eha Yaubada wayahina ta‑vinꞌ‑omo, iuna tauna SabataV a veimea eha ta‑vi‑ateteye, kate auyewa SabataV wayahina paipaisewa.” Kate tupwai wayahia matataui ivi‑tanatanaiei, ivonavona, “Medeina aitam tau goyogoyona iaiaya ani‑vainei deinake vevewane‑neiei? Aituhu tauna tau goyogoyona, Yaubada eha tauna ya dewa‑bagibagi nꞌ‑awaeha deina!” Ka Parisi yai yoko nihenina inuanua tunina tunina deina, eha aitamoata. Ka matataui ivi‑vonavona. ");
INSERT INTO mvn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka dewa pai nau‑yehata wayahina, Parisi‑naia onotona ivi‑tanai‑havinei, ivona, “Tauna matam vo‑vi‑aiaia. Wayahina, medeina wamke enuanua tauna wayahina?” Ka onotona vona‑nau‑patei, ivona, “Tauna tau apa‑taputapu aitam.” ");
INSERT INTO mvn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kate me Iudea ai tau eta‑naonao eha ita‑vitumahana‑vidoha vivane onotona matana goyona ya tupua wayahina, e ataina matana dunedune. Ka taui nuai vi‑tupatupa‑vaine. Wayahina, taui onotona ayona amana ainua ihonei. ");
INSERT INTO mvn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ka avaha ivinꞌ‑omo, tau eta‑naonao ivi‑tanaiei, ivona, “Onoto taina vivane natu‑hoimi? Uhaeyei tunuhina wayahiaia aituhu matana goyona tupueyei. Kadu medeina ataina dunedune?” ");
INSERT INTO mvn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka onotona ayona amana ainua ivonei, ivona, “Itoai anamane‑vidohei vivane tauna natuai, kadue anamane‑vidohei tauna matana goyona tupueyei. ");
INSERT INTO mvn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kate eha atꞌ‑anamane medeina matana dunedune, kadu eha atꞌ‑anamane koiaka vo‑vi‑aiaia. Tauna uvi‑tanaiei, iuna tauna avaha vi‑onoto, ka memeanina tauna ana heta mataedami!” ");
INSERT INTO mvn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ayona amana ainua vonana ivonei deina, iuna taui yai tau eta‑naonao imatamatautei. Imatamatauta deina, iuna me Iudea yai tau eta‑naonao‑naia avaha ivi‑nua‑dadani, aituhu aviyaivia iawaehei Iesu vivane Tau Ito‑yavuha‑nana, akanai taui manua tapanono wayahina ivito‑potei, eha ai pata nihenina itapanono. ");
INSERT INTO mvn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aina iuna onotona ayona amana ainua ivona, “Tauna uvi‑tanaiei, iuna tauna avaha vi‑onoto.” ");
INSERT INTO mvn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Akaka tuta vꞌ‑inuana wayahina Parisi‑naia onotona matana goyona tupueyei ihonei, e ivona, “Evona‑dabadaba Yaubada matana, kadu vona tunutunuhina evonavona wayahiaia! Iuna itoai avaha tauna anamanei vivane tauna tau goyogoyona.” ");
INSERT INTO mvn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ka onotona ivona, “Aituhu tauna tau goyogoyona, yauke eha atꞌ‑anamane. Kate yauke dewa aitamoata taina anamane‑yehai. Nonova matau goyona, kate ataina avaha adunedune.” ");
INSERT INTO mvn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ka Parisi‑naia kadu ivi‑tanaiei, ivona, “Aviani tauna dewei, e matam vo‑vi‑aiaia?” ");
INSERT INTO mvn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ka onotona ivona, “Avaha avonemi, kate itomi eha uta‑nononi. Aviani iuna yami nuanua unononi‑havine? Kaiwadi, yami nuanua itomi kadu uvi‑tau vi‑muni‑waiwai Iesu wayahina?” ");
INSERT INTO mvn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","29","Ka avaha ya vonana inononi, taui yapo‑vainei, ka ivona, “Itoai Mosese a tau vi‑muni‑waiwai! Iuna avaha anamanei vivane Yaubada Mosese wayahina ipuipupu. Kate itoai eha atꞌ‑anamane aveta wayahina tauna vinꞌ‑omo. Wamke akanai tauna a tau vi‑muni‑waiwai!” ");
INSERT INTO mvn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wayahina onotona vonei, ivona, “Yami vonana dewa tupatupana! Tauna matau vo‑vi‑aiaia, kate itomi eha utꞌ‑anamane aveta wayahina vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Habuhabuka avaha kanamanei Yaubada eha tau goyogoyona yai viama na‑nononi. Kate aituhu aviyaivia Yaubada ivi‑ateteyei, kadu aituhu aviyaivia Yaubada ya nuanua idedewei, akanai Yaubada tomotaui yai viama na‑nononi. ");
INSERT INTO mvn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka kadu avaha kanamanei nonova, tanopi a pai vi‑putu ana tuta wayahina, a itoava tuta ataina wayahina, eha aitam tuta vane kata‑nononi vivane aitam onoto ana pata mani onoto matana goyona tupueyei vo‑vi‑aiaiei, e vidoha. ");
INSERT INTO mvn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wayahina, memeanina kadueyei Yaubada onotona vi‑tunei omo, ka kadu tauna ana pata dewa‑bagibagina dewei.” ");
INSERT INTO mvn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ka Parisi‑naia onotona ivonei, ivona, “Ia! Wamke goyom yam tupua wayahina a itoava tuta ataina wayahina. Wamke tauai eviwaveneai, a? Eha am pata!” Akaka ipoyꞌ‑avini, e manua wayahina ineiei, e vuvunaha ihaponei. ");
INSERT INTO mvn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ka Iesu onotona vaneana nononi vivane avaha vuvunaha ihaponei. Ka tutana Iesu onotona vaniahei, e vi‑tanaiei, ivona, “Medeina enuanua Tauna Vi‑tomotau wayahina? Evitumahanei, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ka onotona vi‑tanaiei, ivona, “Bada, tauna koiaka? Evoneu, e au pata avitumahanei.” ");
INSERT INTO mvn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ka Iesu vonei, ivona, “Avaha edueyei, kadu ataina tauna wayahina eipuipupu.” ");
INSERT INTO mvn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Akaka onotona ivona, “Kauvea, avaha avitumahanem!” E tauna iwaodu Iesu wayahina, kadu awa‑davei. ");
INSERT INTO mvn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ka Iesu ivona, “Yauke avaha tanopi wayahina aomo, e nau‑yanahi aomanei. Wayahina, taui ataina matai goyogoyona, apaina idunedune. Kate taui ataina matai idunedune, apaina ivi‑tau mata‑goyo.” ");
INSERT INTO mvn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Papanina wayahina tupwai Parisi imimini, ka Iesu ya vonana inononi, wayahina ivi‑tanaiei, “Medeina? Evonavona vivane itoai kadu tau mata‑goyo, ika?” ");
INSERT INTO mvn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ka Iesu vonei, ivona, “Aituhu itomi matami goyogoyona, akanai yami goyona avaha iakwa. Kate ataina uvonavona, ‘Itoai adunedune,’ wayahina yami dewa goyona eha na‑iakwa, kadu ami dewa‑yaiyai wayahi potapotami.” ");
INSERT INTO mvn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ka Iesu kadu Parisi‑naia vonei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi taina deina. Aituhu aviyaivia yai nuanua sipiV ai yoko inuinu, ka aituhu eha gani awana wayahina ina‑nu, kate aituhu mani papanina wayahina ivane‑gwavi, akanai taui vivane tau vainau! ");
INSERT INTO mvn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ka aituhu aviyaivia sipiV yai gani awana wayahina inuinu, taui vivane yai sipiV ai tau dune‑vi‑avina ahiahina. ");
INSERT INTO mvn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wayahina, gani awana a tau dune‑vi‑avina awana waewaei taui wayahi, kadu sipiV ai tau dune‑vi‑avina inuinu, kadu taui yai sipiV ai wavea ihonehonei ivinꞌ‑omo. Kadu yai sipiV tau dune‑vi‑avina movi inononi, kadu tau dune‑vi‑avina‑naia ai pata etawana inaonaoi kadu yai sipiV ivinꞌ‑omo vuvunaha. ");
INSERT INTO mvn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ka avaha sipi‑naiaV ivinꞌ‑omo, akanai sipi‑naiaV ai tau dune‑vi‑avina etawana inaonaoi, ka taui ineine, kadu yai sipiV ivi‑muniei. Iuna sipi‑naiaV avaha taui movi ianamane‑yehai. ");
INSERT INTO mvn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ka tau dune‑vi‑avina yai sipiV eha nau‑wawani mani tomotau ivi‑munie. Ka vona ahiahina, avi tuta sipi‑naiaV mani tomotau movina inononi, akanai sipi‑naiaV ina‑novo, iuna tomotau tunina movina tunina, e sipi‑naiaV movina tunina eha itꞌ‑anamane.” ");
INSERT INTO mvn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu vona tana‑minikuna tanoi Parisi‑naia vonei, kate taui eha ita‑nua‑hau. ");
INSERT INTO mvn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wayahina, Iesu vona‑havinei, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, yauke vivane awa sipiV wayahi. ");
INSERT INTO mvn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nonova a itoava tuta ataina wayahina, tomotau habuhabui iomomo, kate taui vivane tau dune‑vi‑avina vitupu, kadu taui tau vainau. Wayahina, yau sipiV eha movi ita‑nononi. ");
INSERT INTO mvn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Awa aitamoata mamaei yau sipiV wayahi, ka yauke taua awa‑nana. Aituhu aviyaivia wayahiua inu‑me, akanai taui ito‑yavuha ivaniahei. Kadu tuta tuta sipi‑naiaV habuhabui inunu‑me kadu iopupu‑me, ka aniani ahiahina ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kate Tau Vainau‑nana yana dewa taina. Tauna ya nuanua na‑omo, na‑vainau, ka na‑nau‑vi‑aniga, ka kadu vi‑goyo. Kate yauke aomo tanopia, iuna yau nuanua tomotau yawai‑hoina ivaniahei, kadu yau nuanua idewa‑haiawa‑iaua. ");
INSERT INTO mvn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yauke sipiV ai tau dune‑vi‑avina ahiahina. Iuna sipiV ai tau dune‑vi‑avina ahiahina yawaina awaehei nꞌ‑aniga yana sipiV wayahi. ");
INSERT INTO mvn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aituhu aviyaivia iomomo, ka aituhu eha yai sipiV, akanai taui tau paisewa ana heta. Ka taui ai nau‑pata ana heta wayahina ivi‑tau dune‑vi‑avina. Wayahina, avi tuta kedewa manimaninina na‑omo, ka avaha tau paisewa‑naia kedewana idueyei, akanai taui sipi‑naiaV ivenau‑tawanei, kadu inovonovo. Wayahina, kedewa manimaninina sipiV nau‑yavuyavu‑neiei, kadu tupwai na‑poyꞌ‑avini, na‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tau paisewa‑naia inovonovo ineine, iuna taui ai nau‑pata ana heta wayahina ipaipaisewa. SipiV‑naia vivane mani onoto yana sipiV, ka tau paisewa‑naia eha sipi‑naiaV ta‑dune‑nuanuaie. ");
INSERT INTO mvn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yauke sipiV ai tau dune‑vi‑avina ahiahina. Amau anamaneu, ka yauke kadu tauna anamanei. Ka yauke yau sipiV anamanei, ka taui kadu ianamaneu deina. Ka yawaiu awaehei, yau sipiV wayahi anꞌ‑aniga. ");
INSERT INTO mvn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yau sipiV habuhabui imamaei. Ka tupwai eha sipiV taina ai yoko nihenina ita‑mamae. Taui ai yoko tunina, ka mani papania imamaei. Apaina kadu taui aomanei, e moviu inononi, kadu wayahiua inꞌ‑omo. Ka yoko‑nana yoko taina nui ivi‑yoko aitamoata, ka ai tau dune‑vi‑avina vivane aitamoata. ");
INSERT INTO mvn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Amau dune‑nuanuaieu ahiahina, iuna yawaiu awaehei vivane anꞌ‑aniga. Kate apaina kadu yawaiu anꞌ‑epa‑havinei. ");
INSERT INTO mvn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Eha aitam tomotau ana pata bagibagi‑tawaneu, e yawaiu nꞌ‑epe deina. Eha. Kate yauke taua au heta yau nuanua anꞌ‑aniga deina. Amau taua awaeheu, e yauke au heta yau aniga aveimeyei. Wayahina, nau‑wawaniu yawaiu abou‑ohoi, kadu nau‑wawaniu anꞌ‑epa‑havinei. Amau ya nuanua deina, kadu tauna ya vona‑dabadaba wayahiua boui deina.” ");
INSERT INTO mvn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ka avaha me Iudea Iesu ya vonana inononi, akanai matataui ivi‑vonavona‑havine ananina. Ka tana‑vewana wayahia vinꞌ‑omo‑havine. ");
INSERT INTO mvn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ka habuhabui yaiai wayahia ivonavona, “Nua gawagawamina aitam tauna veimeyei! Wayahina, tauna vi‑kwavakwava. Eha nau‑wawanika yana vona kanononi.” ");
INSERT INTO mvn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kate tupwai yaiai wayahia ivonavona, “Ya vonana tanoi eha nua gawagawamina yana vona deina. Medeina uvonavona nua gawagawamina ana pata tau mata‑goyo matana vo‑vi‑aiaia? Nua gawagawamina yai dewa eha deina.” ");
INSERT INTO mvn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ka kwadudu ana tuta vinꞌ‑omo, e me Iudea yai dewa, e meagai Ierusalem nihenina aitam tonei idedewei. Tonei‑nana ana wava Manua Vito‑pota a Nau‑iaiava. ");
INSERT INTO mvn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ka Manua Vito‑pota a pai vi‑wauna aitam mamaei, e tomotau ivi‑wahani KiniV Solomoni Ya Pai Vi‑wauna. Ka pai vi‑wauna tanoi nihenina Iesu ni‑awana. ");
INSERT INTO mvn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ka me Iudea yai tau eta‑naonao ivinꞌ‑omo, e Iesu imini‑vivinei, e ivonei, ivona, “Tuta habuhabuna wamke evo‑vi‑tupatupai. Avi tuta wayahina wayahiaia ena‑vona tunutunuhina wayahim? Kaiwadi, taum vivane Tau Ito‑yavuha‑nana, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ka Iesu vonei, ivona, “Avaha avonemi, kate eha uta‑vitumahaneu. Kadu yauke dewa‑bagibagi Amau a wavea apaipaisewei, ka dewaia kadu iviwavenemi yauke taua koiaka. ");
INSERT INTO mvn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kate eha uta‑vitumahaneu, iuna itomi eha yau sipiV. ");
INSERT INTO mvn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yau sipiV moviu inononi, ka yauke kadu taui anamanei, ka kadu taui ivi‑muni‑waiwaieu. ");
INSERT INTO mvn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yauke yawai‑vavaha avenevenei, ka eha ai pata inꞌ‑aniga. Ka eha aitam koiaka na‑bagibagi‑tawaneu, wayahina eha aitam koiaka ana pata yau sipiV nimaua na‑nemau. ");
INSERT INTO mvn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Amau sipi‑naiaV veneu. Kadu Amau tomotau habuhabui bagibagi‑tawanei. Wayahina, eha aitam koiaka ana pata yau sipiV Amau nimana na‑nemei. ");
INSERT INTO mvn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yauke Amau ama inua aitamoata.” ");
INSERT INTO mvn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wayahina, me Iudea yai tau eta‑naonao hanu iepa‑havinei vivane yai nuanua Iesu inau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kate Iesu wayahia ivona, “Amau awaeheu dewa‑bagibagi habuhabui kadu ahiahi adedewei, ka yauke avaha dewaia adedewei matamia. Wayahina, avi dewa, dewaia habuhabui wayahia, unuanua dewa goyona, e nau‑wawanimi ututu‑hanuhanu?” ");
INSERT INTO mvn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahina, me Iudea Iesu ya vonana inau‑patei, ivona, “Eha yam dewa ahiahi wayahi avunum, kate yam awa‑viaoha Yaubada wayahina avunum! Iuna wamke onoto‑hoim, kate evonavona vivane wamke Yaubada!” ");
INSERT INTO mvn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ka Iesu nau‑patei, ivona, “Ami veimea nihenina ivona deina, ‘Avaha avona, itomi yaubada.’ ");
INSERT INTO mvn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Habuhabuka avaha kanamanei Iginuma ya viwavenena habuhabuna tunutunuhina, eha vitupu. Ka Yaubada ivona aituhu aviyaivia yana vona ivitumahanei, akanai taui ‘ivi‑yaubada,’ iuna yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yauke taua medeina? Yaubada vi‑nua‑dadaneu, kadu vi‑tuneu aomo tanopia. Ka yauke avonemi, avona, ‘Yauke Yaubada Natu‑hoina.’ Kate aviani iuna unuanua yauke yau vona wayahina awa‑viaoha Yaubada wayahina? ");
INSERT INTO mvn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aituhu yauke eha Amau ya paisewa apaipaisewa, akanai nau‑wawanimi eha uvitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kate aituhu yauke Amau ya paisewa apaipaisewa, akaka nau‑wawanimi paisewa‑naia ahiahi uvitumahanei. E ami pata unꞌ‑anamane‑vidohei, Amau yauke niheniua mamaei, kadu yauke Amau nihenina amamaei.” ");
INSERT INTO mvn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wayahina, me Iudea‑naia idewa‑dadani‑havine ipoyꞌ‑avini, kate itutu‑haini, e tauna novo‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wayahina, Iesu inei Daudau Ioridani, e one‑tamanei. Nonova papani‑nana Ioni Tau Bapitaiso ya pai bapitaiso. Ka tanoi wayahina Iesu mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Papani‑nana wayahina tomotau yoko Iesu wayahina iomomo, ka matataui ivonavona, “Ioni Tau Bapitaiso eha aitam dewa‑bagibagina ta‑paisewe, kate Ioni yana vona habuhabuna onoto‑nana wayahina vona tunutunuhina.” ");
INSERT INTO mvn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ka papani‑nana wayahina tomotau yoko Iesu ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aitam onoto ana wava Lasarusi vi‑kwanaha. Tauna meagai Betani onotona, kadu novunovuna ainua, ai wava Mari kadu Marita, nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ka Mari tanoi vivane Mari‑nana Iesu aena bunami, e apanana wayahina Iesu aena nau‑wohi. Ka Mari‑nana novuna Lasarusi vi‑kwanaha. ");
INSERT INTO mvn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ka avaha Lasarusi vi‑kwanaha, novunovuna ainuai vane iva‑tawanei omo Iesu wayahina, ivona, “Kauvea, am niam edune‑nuanuaiei avaha vi‑kwanaha.” ");
INSERT INTO mvn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka Iesu, avaha vaneana tanoi nononi, ivona, “Lasarusi a kwanahana a pai nau‑yehata eha aniga. Eha. Vona ahiahina, kwanaha tanoi a pai nau‑yehata wayahina tomotau yoko Yaubada didigana ivo‑vi‑natei, kadu Yaubada Natu‑hoina didigana ivo‑vi‑natei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ka Iesu aitonu dune‑nuanuaiei, vivane Marita, ka vaneina, ka kadu novuna Lasarusi. ");
INSERT INTO mvn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ka avaha Lasarusi vi‑kwanaha vaneana nononi, Iesu eha ta‑omo Lasarusi wayahina, kate aveta Iesu mamaei, tenoke kadu auyewa ainua hetana mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka avaha auyewai ainua iakwa, e Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Ataina tuta kamavina papani Iudea wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ka a tau vi‑muni‑waiwai nuai vi‑tupatupa, wayahina Iesu ivonei, ivona, “Tau Viwavenena, tuta kikituna iakwa me Iudea hanu iepepei, e yai nuanua ivunum. Wayahina, medeina yam nuanua papani‑nana wayahina kamavina?” ");
INSERT INTO mvn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ka Iesu vona tana‑minikuna wayahina nau‑patei, ivona, “Auyewa aitamoata aitamoata a tana‑vewana ainua, a? Aitam tuta auyewa, ka kadu aitam tuta ioyoma. Wayahina, aituhu aviyaivia tuta auyewa nihenina ivenavenau, akanai taui eha ivito‑paine, iuna avaha tanopi a maheta mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kate aituhu aviyaivia novanovana nihenina ivenavenau, apaina taui ivito‑painei, iuna wayahia maheta eha.” ");
INSERT INTO mvn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","13","Ka Iesu, avaha vonana vonei, kadu wayahia ivona, “Aka niam Lasarusi avaha ino‑ainei. Kate yauke ana‑nei tanoi, anau‑vi‑dagui.” Ka Iesu ya vonana vona baimina, ka anꞌ anamana vivane Lasarusi avaha aniga. Kate a tau vi‑muni‑waiwai inuanua Lasarusi ino‑ainei akanai. Wayahina, taui inau‑pata, ivona, “Kauvea, vona ahiahina, aituhu ataina Lasarusi ino‑ainei, dewana dewa ahiahina, ka apaina tauna vidoha.” ");
INSERT INTO mvn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wayahina, Iesu wayahia vona‑vuvunaha, “Lasarusi avaha aniga. ");
INSERT INTO mvn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kate adewa‑haiawa, yauke eha tanoi ata‑mae yanꞌ aniga ana tuta wayahina. Iuna itomi nau‑wawanimi apaiku tanoi wayahina yau dewa udueyei, e uvitumahane‑vidoheu. Akanai ka, kana‑ne ya megeia.” ");
INSERT INTO mvn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ka Tomasi, kadu ivi‑wahani DidimusiV, tauna mini, e yaiana vonei, ivona, “Akanai, yaka tau viwavenena nui kana‑ne, ka avi tuta me Iudea tauna ivunui, inau‑vi‑anigi, akanai itoka tauna nui kanꞌ‑aniga!” ");
INSERT INTO mvn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","Ka Ierusalem ka Betani eha bana, 3 kilomitaV deina. Wayahina, me Iudea yoko Ierusalem ini‑tawanei iomoi Betani. Taui yai dune‑nuanuai nui ivinꞌ‑omo Marita ka Mari wayahia, e nuai iyavai novui wayahina. Ka tutana Iesu omo Betani nepena, tauna vane nononi vivane auyewa na nau‑punina iakwa, e tau vi‑meagai Betani Lasarusi itavuni. ");
INSERT INTO mvn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ka Marita, avaha Iesu omomo vaneana nononi, Betani ni‑tawanei omo Iesu wayahina, ka etawana venau‑potepotei. Kate vaneina Mari manua mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ka Marita avaha Iesu vaniahei wayahina ivona, “Kauvea, aituhu nonova auyewa na nau‑punina iakwa wayahina wamke baina eta‑mae, akanai eha ana pata novu nꞌ‑aniga! ");
INSERT INTO mvn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ka tuta ataina wayahina avaha anamanem, aituhu aviani wayahina Yaubada eviamei, akanai tauna na‑venem.” ");
INSERT INTO mvn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ka Iesu Marita vonei, ivona, “Novum anigea na‑mini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ka Marita ivona, “Ika, avaha anamanei apaina, auyewa pai nau‑yehata wayahina, tauna anigea na‑mini‑havine.” ");
INSERT INTO mvn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ka Iesu vonei, ivona, “Yauke taua mini‑havine‑nana kadu yauke taua yawai‑nana. Wayahina, aituhu aviyaivia ivitumahaneu, taui yawai eha na‑iakwa. Aituhu apaina taui inini inꞌ‑aniga, dewana eha aitam aviani, iuna taui nuai eha inꞌ‑aniga, kate imaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kadu tuta ataina wayahina, aituhu aviyaivia yawayawai kadu aituhu ivitumahaneu, akanai taui yai tuta eha na‑iakwa. Ka Marita, wamke medeina? Vonana evitumahanei, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ka Marita ivona, “Ika, Kauvea, avitumahanem wamke Tau Ito‑yavuha‑nana, taum Yaubada Natu‑hoina. Nonova tau apa‑taputapu iginumi vivane taum tanopia eomomo, kadu ataina avaha eomo, emamaei.” ");
INSERT INTO mvn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ka Marita ipupu‑yehai deina, e mavina ya manua. Ka tauna vaneina Mari vona‑bigebigei, ivona, “Vaneiu, yaka Tau Viwavenena avaha omo, kadu tauna ya nuanua wamke.” ");
INSERT INTO mvn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ka Mari nononi, ka mini‑kwayavoni, e Iesu wayahina vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Ka Iesu meagai Betani eha ta‑nu, ka aveta Marita avaha vi‑vaniaha, akanai tauna papani‑nana wayahina mamaei.) ");
INSERT INTO mvn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ka me Iudea tupwai Mari nui manua ivi‑mohai. Ka tutana Mari manua ni‑tawanei, e visina ine, tomotaui idudueyei, e inuanua Mari neine unuvovoa na‑tou. Wayahina, taui ivi‑muniei. ");
INSERT INTO mvn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ka Mari Iesu wayahina vinꞌ‑omo papani‑nana wayahina, ka dueyei. Akaka Mari Iesu matana iwaodu kadu vonei, ivona, “Kauvea, aituhu wamke baina eta‑mae, vona ahiahina, eha ana pata novu nꞌ‑aniga!” ");
INSERT INTO mvn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ka Iesu Mari yana tou dudueyei, ka kadu me Iudea taui nui iomomo yai tou dudueyei. Wayahina, ateatena viha kadu nuana ivita ananina. ");
INSERT INTO mvn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","E Iesu vi‑tanai, ivona, “Tauna a unuvovo aveta?” Ka tomotaui inau‑patei, ivona, “Kauvea, enꞌ‑omo, aviwavenem.” ");
INSERT INTO mvn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ka Iesu toutou. ");
INSERT INTO mvn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ka me Iudea, avaha Iesu yana tou idueyei, matataui ivona, “Vona ahiahina, tauna a niam dune‑nuanuaiei ananina!” ");
INSERT INTO mvn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ka tupwai wayahia ivona, “Iesu ya bagibagi ani‑vainena. Ka tauna ana pata tau mata‑goyo matana vo‑vi‑aiaia. Kaiwadi, aituhu Iesu ya nuanua, tauna ana pata kadu Lasarusi yanꞌ aniga vito‑potei, a?” ");
INSERT INTO mvn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ka Iesu nuana ivita‑havine, ka tauna omo Lasarusi a unuvovo wayahina. Ka unuvovona aitam guba, ka awana hanu wayahina ibou‑potei. ");
INSERT INTO mvn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Wayahina, Iesu yoko wayahia ivona, “Hanu‑nana unꞌ‑epa‑yavunei!” Kate Marita, tauna tau mate novuna, Iesu ya vonana vona‑nau‑patei, ivona, “Kauvea, eha. Avaha mavunu! Iuna auyewa na nau‑punina avaha iakwa.” ");
INSERT INTO mvn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kate Iesu Marita ya vonana nau‑patei, ivona, “Medeina avaha avonem? Avonem aituhu evitumahaneu, apaina Yaubada didigana edueyei, a?” ");
INSERT INTO mvn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Akaka tomotaui hanu iepa‑yavunei, ka Iesu dune‑vane ka ivona, “Amau, kaiwa ananina. Ataina avaha yau viama enononi. ");
INSERT INTO mvn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ka yauke avaha anamane‑vidohem vivane tuta habuhabuna enononiu. Kate ataina tomotau taina avonei didigam idueyei, iuna yau nuanua taui yam bagibagi idudueyei. Ka dewana na‑iakwa, taui nau‑wawani ivitumahana‑vidoha vivane wamke evi‑tuneu aomo.” ");
INSERT INTO mvn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ka Iesu ya viamana iakwa, e tauna movina ananina vi‑honei, ivona, “Lasarusi, eni‑ubau, eopu‑me!” ");
INSERT INTO mvn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Akaka tau mate ni‑ubau, iopu, tauna na iumana nimana kadu aena. Kadu tepana kaleko lineniV iaumei. Wayahina, Iesu yoko‑nana vonei, ivona, “Kalekona unꞌ‑epa‑yavunei, uyavuhi.” ");
INSERT INTO mvn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ka me Iudea, taui Mari inau‑vi‑taui, Iesu ya dewa‑bagibagi‑nana idueyei. Wayahina, habuhabui Iesu ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka tupwai wayahia eha ita‑vitumahane. Wayahina, taui imavi iomo Parisi wayahia, ka aviani Iesu dewei idudueyei, imataedai deina. ");
INSERT INTO mvn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Akaka tau vi‑nomu mata‑genai, kadu Parisi iawaehei tau veimea yoko inau‑hohoni. Ka avaha inau‑hohoni, taui ivi‑tanaiei, ivona, “Aviani onotona wayahina kadedewei? Iuna eha vitupu, tauna paisewa bagibagi habuhabui dedewei. ");
INSERT INTO mvn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kate aituhu tauna kawaehei tuta tepakaia paipaisewa deina, apaina tomotau habuhabui ivitumahanei. Ka apaina, me Rom ivinꞌ‑omo, e yaka pai veimea ivita‑vovoni, ka kadu me Iudea habuhabuka ivunuka. Wayahina, nau‑wawanika tauna kabou‑potei.” ");
INSERT INTO mvn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ka aitam wayahia, ana wava Kaiapasi, ponimana tanoi wayahina tauna tau vi‑nomu ananina. Ka tauna yaiana vonei, ivona, “Itomi mwagemwagemi. ");
INSERT INTO mvn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iuna itomi eha dewa ahiahina uta‑nua‑hau. Aituhu apaina onoto aitamoata nꞌ‑aniga tomotau yoko habuhabuka wayahika, akanai itoka me Iudea habuhabuka eha kanꞌ‑aniga deina.” ");
INSERT INTO mvn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapasi vonana vonei, kate vonana eha tauna ya nuenuea ta‑vinꞌ‑omo. Tauna tau vi‑nomu ananina ponimana tanoi wayahina, ka Yaubada awaehei tauna apa‑taputapu vivane apaina Iesu nꞌ‑aniga me Iudea yai yoko wayahi deina. ");
INSERT INTO mvn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ka vona ahiahina, Iesu aniga me Iudea wayahi, kate eha taui ai heta wayahi. Iesu kadu aniga Yaubada natunatuna habuhabui wayahi. Taui papani tunina tunina iyavuta imamaei, ka Iesu ya nuanua habuhabui na‑omanei, inau‑hohona, ivi‑yoko aitamoata. ");
INSERT INTO mvn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ka auyewana wayahina, me Iudea yai tau eta‑naonao yai nuanua Iesu ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wayahina, Iesu eha me Iudea mataia ta‑ni‑awana, kate yai meagai ni‑tawanei. Ka tauna ine aitam papani anata nepena wayahina. Ka aitam meagai, ana wava Eparaim, tanoi mamaei. Ka tauna kadu a tau vi‑muni‑waiwai nui tanoi imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ka tutana Itouvuha Toneina ana tuta vi‑hinahina, me Iudea habuhabui yai meagai kikitui ini‑tawanei, ivanevane iomomo meagai Ierusalem wayahina. Ka taui yai dewa tutuaina mamaei, e naona pai vi‑toa a veimea ivi‑muniei, e nuai ivo‑vi‑aiaia deina. Ka dewana na‑iakwa, taui ai pata toneina idedewei tunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ka tomotau‑naia Iesu inenenei. Ka tutana Manua Vito‑pota a papani nihenina imimini, taui yaiai matataui ivi‑tanatanaiei, ivona, “Medeina unuanua? Apaina onotona na‑omo Tonei taina wayahina, o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kate tau vi‑nomu mata‑genai, kadu Parisi avaha veimea bagibagina iboui. Ka veimeana ivona aituhu aviyaivia Iesu ivaniahei, akanai taui nau‑wawani inꞌ‑omo tau eta‑naonao wayahia, ka aveta Iesu mamaei imataeda‑kwayavoni. Ka tau eta‑naonao inuanua memeanina Iesu ipoyꞌ‑avini, iyohoni deina. ");
INSERT INTO mvn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ka auyewa ai yau 6 imamaei, e munia Itouvuha Toneina ivi‑putui. Ka Iesu Eparaim ni‑tawanei, omoi Betani. Betani‑nana Lasarusi ya meagai, ka tauna mamaei. Iuna Iesu avaha tauna anigea si‑vi‑mini. ");
INSERT INTO mvn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ka aniani ananina ibou, iuna yai nuanua Iesu inau‑kaiwei, kadu yai nuanua ana wava isi‑nai. Ka auyewana wayahina Marita aniani bouboui, ka Lasarusi kadu tomotau nui iamam. ");
INSERT INTO mvn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ka tutana iamam, Mari daudau epei, e daudauna manina hunahuna ahihi‑vainena, ana wava naridataV, ka deina ½ litaV, ka daudauna patana ani‑vainena. E Mari omo Iesu wayahina, ka daudauna aena ito‑iwahi‑yehai, e apanana wayahina aena nau‑wohi. Ka daudauna manina ahiahina manua nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ka Iudasa me Kariota, Iesu a tau vi‑muni‑waiwai aitam, tauna apaiku vi‑nua‑hauhauei. Ka Iudasa Mari ya dewana wayahina vi‑vonavona, ivona, ");
INSERT INTO mvn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ia! Nau‑wawani daudau‑nana kaimwane, e a nau‑pata payapayaya wayahia kavenevene, iuna daudauna patana onoto a nau‑pata ponimana aitamoata nihenina deina.” ");
INSERT INTO mvn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ka Iudasa vonavona deina, kate tauna eha payapayaya tꞌ‑ate‑nuanuaie. Iudasa vivane tau vainau aitam. Ka Iesu a tau vi‑muni‑waiwai ai kode aitamoata, ka Iudasa kodena avanei ka tuta tuta aviani ibou nihenina tauna vainaui. ");
INSERT INTO mvn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kate Iesu Iudasa vonei, ivona, “Egenuana! Eha vavinena emana‑giboei! Iuna nonova tauna daudau‑nana bou‑keyei, ka poyꞌ‑avini a itoava ataina wayahina. Wayahina, ataina tauna ito‑iwahi‑yehai, e vo‑vi‑aiaieu au itavuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tuta tuta tau payapayaya nui umamaei, kate eha tuta tuta yauke wayahimia.” ");
INSERT INTO mvn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ka tuta aitamoata wayahina me Iudea yoko ananina mataeda inononi, Iesu meagai Betani mamaei. Wayahina taui iomo Betani, ka yai nuanua Iesu idueyei. Ka eha Iesu ana heta, kate yai nuanua kadue mataia Lasarusi idudueyei. Iuna Iesu avaha tauna anigea si‑vi‑mini. ");
INSERT INTO mvn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wayahina, tau vi‑nomu mata‑genai inuanua nau‑wawani kadu Lasarusi ina‑nau‑vi‑anigi, ka yai vi‑nua‑hauhau iboui idewei deina. ");
INSERT INTO mvn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Iuna me Iudea habuhabui Lasarusi vaneana inononi. Wayahina, Iesu wayahina iomomo kadu ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ka mana navia yoko ani‑vainena imamaei meagai Ierusalem nihenina. Taui avaha iomo Itouvuha Toneina wayahina. Ka vaneana inononi, Iesu vanevane Ierusalem. ");
INSERT INTO mvn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wayahina, taui iomo, e haihai vegana ivituei, ka meagai ini‑tawanei, e etawana ivinꞌ‑omo ivi‑honehone, “OsanaV! Taum Kauvea a wavea eomomo! Itoai awa‑davedavem.” Kadu ivi‑honehone, ");
INSERT INTO mvn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ka Iesu aseV natuna vaniahei, e wayahina manuena, Iginuma ivona deina, ");
INSERT INTO mvn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O, Sioni natuna vavinena, eha ematamatauta! Edueyei! Yam kiniV omomo na nua‑opuna aseV natuna hetana manuena vi‑ata.” ");
INSERT INTO mvn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ka tutana dewana vinꞌ‑omo, Iesu a tau vi‑muni‑waiwai eha Iginuma tanoi anꞌ anamana ita‑nua‑hau. Kate avaha Iesu didigana epa‑havinei, dewana Iginuma nihenina inuani, kadu inuani tomotau avaha dewaia idewei Iesu wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ka yoko‑naia nihenina tomotaui Iesu nui imamaei tutana tauna Lasarusi unuvovoa vi‑honei kadu anigea si‑vi‑mini‑havinei, ka dewana mataia idueyei. Ka taui avaha me Ierusalem kadu mani yoko dewana vaneana imataedai. ");
INSERT INTO mvn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wayahina, tomotau habuhabui meagai Ierusalem ini‑tawanei iomo, e yai nuanua Iesu etawana ivaniahei. Iuna taui avaha Iesu ya dewa‑bagibagina vaneana inononi. ");
INSERT INTO mvn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ka tutana Parisi yoko‑naia idueyei, kadu tutana yoko‑naia yai nau‑kaiwa Iesu wayahina inononi, Parisi imaga‑bawe ananina, ka matataui ivi‑vonavona, ivona, “Udueyei! Tauna bagibagi‑tawaneka. Tau maꞌ tanopi habuhabui avaha ivi‑muniei!” ");
INSERT INTO mvn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ka yokoia ivanevane toneina wayahina, itapanono, ka yokoia nihenina tupwai me Girisi. ");
INSERT INTO mvn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ka taui iomo Pilipi wayahina. Tauna tevana Betesaida, aitam meagai Galili ya papani nihenina. Ka ivona, “Bada, itoai yama nuanua Iesu adueyei.” ");
INSERT INTO mvn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Wayahina, Pilipi omo Aniduru wayahina, e vonei, ka Aniduru Pilipi ainua iomo Iesu wayahina, e me Girisi yai nuanua imataedei. ");
INSERT INTO mvn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ka Iesu ainuai wayahia vona‑nau‑patei, ivona, “Tuta avaha omo, e yauke, Tauna Vi‑tomotau, didigau ananina avaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu witiV waipeina ana heta mamaei, waipei‑nana eha ana pata na‑ua. Waipei‑nana ana heta mamaei. Kate aituhu waipei‑nana tanopia na‑peu, na‑guani, e nꞌ‑aniga deina, akanai ana pata na‑ua ananina. Ka waipei aitamoata waipei habuhabui vevewanei deina. ");
INSERT INTO mvn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aituhu aviyaivia yawai tanopia ipoyꞌ‑avini, taui yawai‑vavaha ini‑kaietei. Kate aituhu aviyaivia yawai tanopia inau‑nikonikoiei, taui yawai‑vavaha ivaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aituhu aviyaivia yai nuanua ivi‑tau paisewa‑kavokavovo wayahiu, taui nau‑wawani ivi‑muni‑waiwaieu. Wayahina, aveta baina yauke amamaei, akanai yau tau paisewa‑kavokavovo nui kamamaei. Ka aituhu aviyaivia ipaipaisewa wayahiu, apaina Amau taui ai wava na‑si‑nai kadu nꞌ‑apa‑vidovidohei.” ");
INSERT INTO mvn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ataina yauke anua‑vita, kate medeina avonavona? Kaiwadi, nau‑wawaniu ana‑vona, ‘Amau, tuta taina wayahina eito‑yavuhiu.’? Eha nau‑wawaniu avonavona deina. Yauke aomo tanopia, iuna tuta ataina wayahina ahidahida. ");
INSERT INTO mvn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wayahina nau‑wawaniu ana‑vona, ‘Amau, am wava esi‑nai!’” Ka wahuma wayahina Yaubada movina vinꞌ‑omo, ivona, “Avaha asi‑nai, kadu apaina asi‑nai‑havinei.” ");
INSERT INTO mvn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ka yoko‑naia imimini movina inononi, ka tupwai ivona, “Anitana!” Ka kadu tupwai ivona, “Aitam anelose ipupu tauna wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kate Iesu vonei, ivona, “Movi‑nana vinꞌ‑omo eha taua na‑ivaiteu. Eha. Movi‑nana vinꞌ‑omo taumi na‑ivaitemi. ");
INSERT INTO mvn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tuta ataina vitana matana ana tuta tau maꞌ tanopi wayahi, ka kadu tuta ataina wayahina tauna tanopi veimeyei a bagibagi abwegei. ");
INSERT INTO mvn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kate apaina tomotau isi‑naiu avane tanopia, e munina tomotau habuhabui wayahiua ataitaini.” ");
INSERT INTO mvn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Vonana wayahina Iesu apa‑taputapu medeina yanꞌ aniga vinꞌ‑omo, vivane ai nahenahea.) ");
INSERT INTO mvn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ka yokoia ivona‑nau‑patei, ivona, “Iginuma voneai, Tau Ito‑yavuha‑nana na‑maꞌ‑vavaha. Aituhu Iginuma tunutunuhina deina, aviani iuna evonavona, ‘Tauna Vi‑tomotau nau‑wawani tomotau isi‑nai’? Tau Ito‑yavuha‑nana kadu Tauna Vi‑tomotau aitamoata o ainua? ‘Tauna Vi‑tomotau‑nana’ koiaka?” ");
INSERT INTO mvn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ka Iesu vonei, ivona, “Ataina maheta wayahimia mamaei, kate tuta eha ani‑hoina na‑iakwa wayahina, maheta‑nana eha wayahimia. Wayahina, tutana maheta‑nana mamaei, taumi nau‑wawanimi uni‑awana. Apaina novanovana omomo, ka aituhu aviyaivia novanovana nihenina ini‑awana, taui eha itꞌ‑anamane aveta baina ineine. ");
INSERT INTO mvn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ataina maheta‑nana wayahimia mamaei. Wayahina, nau‑wawanimi maheta‑nana uvitumahanei. Aituhu uvitumahaneu, akanai itomi maheta‑nana natunatuna deina.” Ka Iesu ya vonana vona‑yehai, ka ine, e ya nuanua tauna ana heta venau‑maiovei tomotau‑naia wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ka Iesu avaha iaiaya bagibagi‑vainei habuhabui mataia dewei, kate tomotau‑naia eha ita‑vitumahana‑vidoha. ");
INSERT INTO mvn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tomotau‑naia yai dewa ka Isaia tau apa‑taputapu yana vona aitamoata deina. Tauna ivona, “Kauvea, koiaka yama hae vitumahane, o kaiwadi, koiaka Yaubada nimana bagibagina dueye?” ");
INSERT INTO mvn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ka taui eha ai pata ivitumahane. Nonova kadu aitam Isaia yana vona deina, ivona, ");
INSERT INTO mvn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yaubada matai vo‑vi‑goyoi, kadu Yaubada yai nuanua vo‑vi‑toyoa. Wayahina, mataia eha ita‑dunedune, kadu inuanua, kate eha ita‑nua‑hau, kadu eha ita‑magigino. Wayahina, eha ata‑vo‑vi‑aiaie.” ");
INSERT INTO mvn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nonova Isaia vonana ginumi iuna tauna Iesu didigana dueyei, ka Iesu wayahina ipuipupu. ");
INSERT INTO mvn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ka tuta aitamoata wayahina tau eta‑naonao habuhabui ivitumahanei, kate taui eha ita‑hae vuvunaha, iuna imatamatauta Parisi wayahia. Aituhu Iesu ihaehaeye vuvunaha, munia Parisi manua tapanono wayahia ivo‑taho, ka kadu yai mavina ivito‑pote. ");
INSERT INTO mvn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tau eta‑naonao‑naia yai nuanua ananina awa‑dava tomotau wayahia ivaniahei, kate eha yai nuanua ananina awa‑dava Yaubada wayahina ivaniahe. ");
INSERT INTO mvn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ka Iesu vi‑hone ananina kadu ivona, “Aituhu aviyaivia ivitumahaneu, taui eha yauke au heta ivitumahaneu, kate taui au tau vi‑tune kadu ivitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aituhu aviyaivia idudueyeu, akanai taui kadu yauke au tau vi‑tune‑nana idudueyei. ");
INSERT INTO mvn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yauke avaha aomo tanopia, ka yauke maheta deina. Ka aituhu aviyaivia ivitumahaneu, taui eha novanovana nihenina imaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aituhu aviyaivia yau vona inononi, ka aituhu eha idedewe, yauke taua eha tomotaui ana‑nau‑yanahi. Iuna eha ata‑omo tau maꞌ tanopi ana‑nau‑yanahi. Kate aomo tau maꞌ tanopi ana‑ito‑yavuhi‑neiei. ");
INSERT INTO mvn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aituhu aviyaivia ivihahaieu, o aituhu aviyaivia yau hae ivihahaiei, akanai aitam mamaei, e apaina na‑nau‑yanahi‑neiei, vivane yau vonana. Ka auyewa pai nau‑yehata wayahina yau vonana tomotaui nꞌ‑apa‑goyogoyoei vitana matana anꞌ auyewa wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iuna ataina tuta wayahina, avi vona avonavona unononi, vonaia eha yauke au heta yau vona, kate vonaia vivane Amau ya vonana. Tauna vi‑tuneu, kadu avi vona avonevonemi, akanai tauna awaeheu avonemi deina, kadu tauna au awaeha veneu medeina vonaia ana‑ipupu wayahimia. ");
INSERT INTO mvn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yauke avaha Amau ya veimea anamane‑vidohei, vivane tauna ya veimea eta‑naoemi yawai‑vavaha uvaniahei. Wayahina, avi vona avonevonemi unononi, akanai vonaia vivane Amau ya vonana ana heta.” ");
INSERT INTO mvn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2","Ka Iesu avaha anamanei vivane yana tuta tanopia eha ani‑hoina na‑iakwa, ka tuta‑nana avaha omo, e tauna tanopi na‑ni‑tawanei, e Amana wayahina na‑vane‑havine. Tuta tuta Iesu tauna a tau vi‑muni‑waiwai tanopia dune‑nuanuaiei, ka ya nuanua dune‑nuanuai‑nana viwavenei inꞌ‑anamanei. Ka Itouvuha Toneina mana navia, ka Iesu tauna a tau vi‑muni‑waiwai ai yau 12 nui, taui ai heta avanana imai‑aniania vinanavi, ka Satana avaha Iudasa me Kariota, Simoni natuna, ana‑dibidibiei, e tauna Iesu vi‑nua‑hauhauei. ");
INSERT INTO mvn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ka Iesu avaha anamanei, Amana avaha dewa habuhabuna nimana bouni, ka Iesu ana heta ana pata na‑veimeyei. Kadu Iesu avaha anamanei tauna Yaubada wayahina vinꞌ‑omo, kadu tauna Yaubada wayahina mavimavina. ");
INSERT INTO mvn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wayahina, tauna am‑nana wayahina mini, a pai bwaꞌ boui, e pai nau‑vi‑ayaya epei, e vi‑haionei. ");
INSERT INTO mvn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka ine, e daudau iwahi gaeba nihenina, epei, e omo, vi‑putu a tau vi‑muni‑waiwai aei nosinosia, kadu pai nau‑vi‑ayaya wayahina vi‑haiona wayahina aei nau‑vi‑ayayi. ");
INSERT INTO mvn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ka tauna omo Simoni Pita wayahina. Kate Pita vonei, ivona, “Kauvea, eha nau‑wawanim aeu enosia!” ");
INSERT INTO mvn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ka Iesu vona‑nau‑patei, ivona, “Ataina wamke eha yau dewa taina etꞌ‑anamane‑vidohe, kate munia enua‑haui.” ");
INSERT INTO mvn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kate Pita vonei, ivona, “Tuta ataina a itoava auyewa pai nau‑yehata wayahina, yauke eha anꞌ‑awaehem aeu enosia.” Kate Iesu vona‑nau‑patei, ivona, “Aituhu yauke eha anosim, vona ahiahina, wamke eha aitam au tau vi‑muni‑waiwai.” ");
INSERT INTO mvn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wayahina, Simoni Pita vonei, ivona, “Kauvea, aituhu deina, eha aeu ana heta, kadu nimau, ununu, habuhabu enosiu!” ");
INSERT INTO mvn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ka Iesu vona‑nau‑patei, ivona, “Aituhu aviyaivia avaha itoa‑yehai, taui nau‑wawani aei ana heta inosia. Taui inini habuhabuna avaha hadahadanina. Ka itomi avaha hadahadanimi deina, kate aitamoata wayahimia eha.” ");
INSERT INTO mvn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu ivona deina, iuna tauna avaha anamanei koiaka munia vi‑nua‑hauhauei. Wayahina, tauna ivona, “Itomi avaha hadahadanimi deina, kate aitamoata wayahimia eha.” ");
INSERT INTO mvn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ka Iesu avaha a tau vi‑muni‑waiwai ai yau 12 aei nosi‑yehai, akanai tauna a pai bwaꞌ weteni‑havinei, e mavina wayahia. E tauna vi‑tanaiei, ivona, “Yau dewana wayahimi unua‑haui, o eha? ");
INSERT INTO mvn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Uvi‑wahaniu ‘Tau Viwavenena’ kadu ‘Kauvea’ ka akanai, vonana vivane vona tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","16","Memeanina nuami vi‑tupatupa, kate avonemi, tau paisewa eha ai tau veimea ivane‑tawane. Kadu aitamoata deina, tau mataeda eha ai tau vi‑tune ivane‑tawane. Kadu aitamoata deina, itomi eha uvane‑tawaneu. Udueyei! Yauke vivane yami Kauvea kadu yami Tau Viwavenena, ka taua avaha aemi anosia. Dewana adewei yami pai dune ivaita wayahina. Wayahina, itomi aitamoata aitamoata nau‑wawanimi tuta tuta una‑ivaitemi. Yauke avaha dewa‑vidovidoha a pai dune ahiahina avenemi. Wayahina, itomi nau‑wawanimi kadu uvi‑tau paisewa aitamoata aitamoata wayahimia, yauke avi‑tau paisewa wayahimia aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ataina yauke avaha dewana aviwavenemi, udueyei, kadu unꞌ‑anamanei. Aituhu viwavene‑nana udewa‑nubunubui, akanai nau‑iaiava uvaniahei deina! ");
INSERT INTO mvn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yau vonana eha habuhabumi wayahimi. Iuna taui nonova avi‑nua‑dadanei anamane‑vidohei. Kate aitam dewa goyona omomo, ka Iginuma nihenina dewana wayahina ivona, ‘Onotona au palaua ania, kate tauna au havia ivaitei.’ Iginumana dewa goyo‑nana apa‑taputapuei deina, ka ataina vi‑nua‑hauhau tanoi na‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ataina dewa goyonana amai‑vonemi, ka apaiku dewana na‑omo. Ka munia, itomi yau vonana unuani, vivane yauke dewana apa‑taputapuei, ka vonana na‑ivaitemi uvitumahaneu ‘Taua Amaꞌ‑vavaha.’ ");
INSERT INTO mvn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Memeanina nuami vi‑tupatupa, kate avonemi, aituhu aviyaivia yau tau mataeda iawaehei, ivitumahanei, akanai taui kadu yauke taua iawaeheu. Kadu aituhu aviyaivia taua iawaeheu, akanai taui kadu tauna vi‑tuneu iawaehei.” ");
INSERT INTO mvn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ka avaha Iesu ivona deina, tauna nuana ivita, e ihae tunuhina, ivona, “Memeanina nuami vi‑tupatupa, kate avonemi, aitam wayahimia vi‑nua‑hauhaueu.” ");
INSERT INTO mvn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ka a tau vi‑muni‑waiwai aitamoata aitamoata ivi‑duedue wayahia, kate taui nuai vi‑tupatupa ananina. Ka eha itꞌ‑anamane‑vidoha koiaka wayahia tauna vonavona wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pai am wayahina Iesu a tau vi‑muni‑waiwai aitam tauna numanumana wayahina ino‑vinavina, e Iesu tauna dune‑nuanuaiei ananina. ");
INSERT INTO mvn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ka Simoni Pita tau vi‑muni‑waiwai‑nana matana vonei, ivona, “Evi‑tanaiei vivane, ‘Koiaka wayahina evonavona?’.” ");
INSERT INTO mvn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wayahina tauna Iesu numanumana wayahina ino‑vinavina vi‑tanaiei, ivona, “Kauvea, koiaka?” ");
INSERT INTO mvn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Akaka Iesu vona‑nau‑patei, ivona, “Gibugibuna taina buyavia asi‑utuvi, avenei, tauna aina.” E gibugibuna si‑utuvi, e tauna Iudasa venei, tauna Simoni me Kariota natuna. ");
INSERT INTO mvn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ka Iudasa avaha gibugibuna epei, Satana vo‑kwayavoni nihenina inu, e veimeyei. Wayahina, Iesu Iudasa vonei, ivona, “Avi dewa yam nuanua, akanai ataina evo‑kwayavoni edewei.” ");
INSERT INTO mvn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kate tau am habuhabui eha Iesu ya vonana Iudasa wayahina anꞌ anamana itꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tupwai inuani, Iudasa kode dune‑vi‑avini. Wayahina, taui inuanua Iesu Iudasa vonei deina iuna Iesu ya nuanua tauna gugua toneina wayahina vi‑maiei, o kadi aitam am‑venena‑kavovo tau payapayaya venei deina. ");
INSERT INTO mvn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kate avaha Iudasa gibugibuna epei, tauna vo‑kwayavoni iopu ine. Ka avaha ioyoma. ");
INSERT INTO mvn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ka avaha Iudasa ine, Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Tuta eha ani‑hoina na‑iakwa, e yauke, Tauna Vi‑tomotau, didigau avaniahei, udueyei. Ka kadu yau dewa wayahina Yaubada didigana avo‑vi‑natei, udueyei. ");
INSERT INTO mvn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ka avaha Yaubada didigana avo‑vi‑natei, akanai tauna didigau na‑vo‑vi‑natei, ka tuta eha ani‑hoina na‑iakwa wayahina tauna na‑dewei deina. ");
INSERT INTO mvn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natunatu, tuta eha ani‑hoina wayahina yauke nui kamamaei. Nonova me Iudea avonei, kadu ataina avonevonemi aitamoata deina, vivane avi papani aneine, itomi eha ami pata unꞌ‑omo. Apaina uneneneu, kate eha ami pata uvaniahau. ");
INSERT INTO mvn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ataina ami veimea vovouna taina avenevenemi, vivane nau‑wawanimi udewa‑vidovidohemi. Yauke avaha adewa‑vidovidohemi, kadu itomi nau‑wawanimi udewa‑vidovidohemi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aituhu udewa‑vidovidohemi, akanai mani tomotau habuhabui yami dewana idudueyei, e inꞌ‑anamanemi itomi au tau vi‑muni‑waiwai.” ");
INSERT INTO mvn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ka Simoni Pita Iesu vi‑tanaiei, ivona, “Kauvea, ataina aveta eneine?” Ka Iesu vona‑nau‑patei, ivona, “Viha a papani aneinei. Ataina wamke eha am pata evi‑munieu, kate munia evi‑munieu.” ");
INSERT INTO mvn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ka Pita kadu vi‑tanaiei, ivona, “Kauvea, ataina tuta aviani wayahina eha memeanina avi‑muniem? Iuna yauke yawaiu awaehei anꞌ‑aniga taum wayahim.” ");
INSERT INTO mvn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kate Iesu vona‑nau‑patei, ivona, “O Pita. Ataina enuanua yawaim eawaehei wayahiu, a? Memeanina nuam vi‑tupatupa, kate avonem wamke eha am pata. Apaiku, ioyoma taina nihenina, wamke evi‑ebueu tuta aitonu wayahina, ka munia, kamkam onotona yana tou!” ");
INSERT INTO mvn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ka Iesu tauna a tau vi‑muni‑waiwai vonei, ivona, “Eha nau‑wawanimi uva‑hamwahamwana, kadu eha unua‑vita. Itomi Yaubada uvitumahanei, ka nau‑wawanimi kadu yauke uvitumahaneu aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Amau ya megeia tauna ya manua nihenina bubuna honohonota habuhabui imamaei. Aituhu vonana vona vitupu, eha avonavona wayahimia deina. Ka yauke meagai‑nana wayahina aneine, e yami pai maꞌ avo‑vi‑aiaia wayahimi. ");
INSERT INTO mvn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yauke etawana anaoi, e yami pai maꞌ avo‑vi‑aiaia. Na‑iakwa, amavina, atainimi kana‑ne meagai‑nana wayahina, ka nui kamaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka etawanana wayahina aneine avaha uanamanei.” ");
INSERT INTO mvn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Akaka Tomasi Iesu vi‑tanaiei, ivona, “Kauvea, itoai eha atꞌ‑anamane aveta baina eneine. Wayahina, medeina ama pata etawanana anꞌ‑anamane‑vidohe?” ");
INSERT INTO mvn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ka Iesu Tomasi vonei, ivona, “Yauke etawanana, kadu yauke vona tunutunuhina, ka kadu yauke yawai‑vavaha. Aituhu aviyaivia yai nuanua iomomo Amau wayahina, taui wayahia eha kadu aitam etawana ta‑mamae, akanai yauke au heta.” ");
INSERT INTO mvn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iesu kadu vonei, ivona, “Aituhu itomi avaha uanamane‑vidoheu, akanai avaha Amau uanamane‑vidohei aitamoata deina. Vona tunuhina, ataina a itoava eha na‑iakwa wayahina, avaha Amau uanamanei, kadu avaha tauna ududueyei.” ");
INSERT INTO mvn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ka Pilipi Iesu wayahina ivona, “Kauvea, Amaka eviwaveneai. Akanai, ana pata deina wayahiai.” ");
INSERT INTO mvn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu vona‑nau‑patei, ivona, “Ia! Pilipi, wamke medeina? Tuta mamanaina yauke avaha itomi nui kamamaei, kate wamke eha etꞌ‑anamaneu ahiahina, a? Vona ahiahina, aituhu aviyaivia avaha idudueyeu, taui kadu avaha Amau idudueyei. Aviani wayahina evona, ‘Amaka eviwaveneai.’ ");
INSERT INTO mvn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kaiwadi! Wamke evitumahaneu yauke Amau nihenina amamaei, o eha? Kaiwadi, evitumahaneu Amau kadu niheniua mamaei, o eha? Aipuipupu wayahimia, kate yau vonana eha ta‑vinꞌ‑omo yauke au heta wayahiua. Vonana Amau ama inua wayahiaia vinꞌ‑omo. Iuna tauna niheniua mamaei, ka tuta tuta tauna ya paisewa dedewei ininiu wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Itomi nau‑wawanimi vona taina uvitumahanei vivane taua Amau nihenina amamaei, kadu Amau taua niheniua mamaei. Aituhu itomi eha ami pata yau vonana uvitumahane, nau‑wawanimi unuani, avaha paisewaia bagibagi‑vainei habuhabui ududueyei, ka dewaia ina‑ivaitemi uvitumahaneu. ");
INSERT INTO mvn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka memeanina nuami vi‑tupatupa, kate avonemi, avi paisewa ataina adedewei, apaina aituhu aviyaivia ivitumahaneu, taui kadu paisewa‑naia idedewei deina. Ataina yau paisewa bagibagi‑vainei vivane kikitui, kate apaina taui yai paisewa bagibagi‑vainei anani, iuna yauke amavina Amaka wayahina, ka yau tau paisewa yau bagibagi avene‑tamani‑neiei. ");
INSERT INTO mvn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kadu aviani yami nuanua, itomi nau‑wawanimi uviama wayahina au wavea, ka yauke anꞌ‑awaehemi, avenevenemi. Ka Amau didigana na‑nata yau dewana wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ika, avona‑havinemi, aituhu aviani uviameu au wavea, akanai yauke anꞌ‑awaehemi, adedewei deina. ");
INSERT INTO mvn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aituhu udune‑nuanuaieu, nau‑wawanimi yau veimea uvi‑ateteyei. ");
INSERT INTO mvn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ka Amau aviamei, e apaina tauna kadu aitam Tau Yava vi‑tunei na‑omo wayahimia. Tau Yava‑nana vivane Nuana Tunutunuhina kadu tauna wayahimia na‑maꞌ‑vavaha. Kate tau maꞌ tanopi eha ai pata Tau Yava‑nana iawaehe, ivaniahe. Iuna taui eha tauna ana dune ita‑dueye, kadu taui eha tauna itꞌ‑anamane. Kate itomi Tau Yava‑nana uanamanei, iuna tauna nui umamaei, kadu apaina tauna nihenimia mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yauke ani‑tawanemi, kate itomi eha tau payapayaya deina. Ka munia, yauke amavina wayahimia. ");
INSERT INTO mvn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tuta eha ani‑hoina na‑iakwa wayahina, e ani‑tawanemi. Tau maꞌ tanopi eha idune‑havineu, kate apaina itomi udune‑havineu. Yauke taua amaꞌ‑vavaha. Wayahina, itomi kadu umaꞌ‑vavaha. ");
INSERT INTO mvn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ka apaina auyewana udune‑havineu wayahina, akanai unꞌ‑anamaneu vivane yauke Amau nihenina amamaei, ka kadu itomi niheniua umamaei, ka kadu yauke nihenimia amamaei. ");
INSERT INTO mvn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aituhu aviyaivia yau veimea ianamanei kadu ivi‑ateteyei, tomotaui idewa‑vidovidoheu akanai. Ka aituhu aviyaivia idewa‑vidovidoheu, vona ahiahina, Amau taui dewa‑vidovidohei, ka kadu yauke taui adewa‑vidovidohei, kadu taui wayahia taua aviwaveneu idudueyeu.” ");
INSERT INTO mvn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ka mani Iudasa (eha me Kariota) ivona, “Kauvea, aviani wayahina taum eviwavenem itoai wayahiaia, kate eha tau maꞌ tanopi wayahia eviwavenem?” ");
INSERT INTO mvn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ka Iesu vona‑nau‑patei, ivona, “Aituhu aviyaivia idewa‑vidovidoheu, akanai taui yau viwavenena ivi‑ateteyei. Ka Amau taui dewa‑vidovidohei, ka ama inua aomo taui wayahia, e taui nui amamaei. ");
INSERT INTO mvn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kate aituhu aviyaivia eha idewa‑vidovidoheu, taui eha kadu yau viwavenena ivi‑ateteye. Viwavenenaia avenemi unononi, kate eha yauke taua au heta wayahiua ta‑vinꞌ‑omo. Viwavenenaia Amau wayahina ivinꞌ‑omo, ka kadu tauna vi‑tuneu aomo tanopia. ");
INSERT INTO mvn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tuta ataina wayahina yauke itomi nui kamamaei. Wayahina, viwavenenaia habuhabui avonevonemi. ");
INSERT INTO mvn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kate apaina, Amau Tau Yava‑nana vi‑tunei na‑omo wayahimia, yauke au wavea. Ka Tau Yava‑nana vivane Nuana Ahihinata. Apaina tauna nua‑uya habuhabuna viwavenemi, ka avi viwavenena avaha avonemi, akanai tauna nuami na‑dadanei, unua‑vi‑avini. ");
INSERT INTO mvn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yauke ani‑tawanemi. Wayahina, nua gomagomanina avenemi na‑maei wayahimia. Ka nua gomagomanina vivane yauke yau nua gomagomanina. Ka yau nua gomagomanina eha tau maꞌ tanopi yai nua gomagomanina ivenemi deina. Eha. Eha nau‑wawanimi dewaia wayahi unuanua toyoina, kadu eha nau‑wawanimi umatamatautei. ");
INSERT INTO mvn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Avaha yau vonana unononi, e avona, ‘Yauke ani‑tawanemi, ka munia amavina wayahimia.’ Aituhu itomi udune‑nuanuaieu ananina, akanai nau‑wawanimi udewa‑haiawa yau nae taina wayahina. Iuna yauke Amau wayahina aneine, ka tauna vane‑tawaneu. ");
INSERT INTO mvn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tuta ataina wayahina yauke avaha dewaia tanoi habuhabuna iomomo amai‑vonemi. Ka yau nuanua apaina, avi tuta dewaia ivinꞌ‑omo, akanai itomi yau vonana unuani, kadu uvitumahane‑vidoheu. ");
INSERT INTO mvn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ataina avonavona wayahimia, kate eha au pata tuta mamanaina wayahina avonavona, iuna tau maꞌ tanopi ai tau veimea ana wava Satana omomo. Tauna eha ana pata na‑bagibagi‑tawaneu, ");
INSERT INTO mvn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kate yau nuanua tau maꞌ tanopi inꞌ‑anamaneu vivane yauke Amau adewa‑vidovidohei, kadu tuta tuta au veimea tauna wayahina avi‑ateteyei tunutunuhina. Yaiau, nau‑wawanika papani taina kani‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yauke manawa‑hoiu, ka Amau vivane tau baguna. ");
INSERT INTO mvn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aituhu avi kikiu eha ina‑ua, tau bagunana aitamoata aitamoata wayahina upwa‑yavunei. Kadu aituhu avi kikiu iuaua, tuta tuta tau bagunana tana‑gadigadia, e munia iuaua ananina. ");
INSERT INTO mvn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ka itomi avaha hadahadanimi, iuna avaha yau vonana avonevonemi. ");
INSERT INTO mvn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Itomi nau‑wawanimi umamaei niheniua. Aituhu umamaei niheniua, akanai yauke amamaei nihenimia. Aituhu aitam kikina manawa upuna mamaei, kiki‑nana eha ana pata na‑ua. Ka itomi kikiu deina. Aituhu itomi eha niheniua umamae, eha ami pata una‑ua. ");
INSERT INTO mvn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yauke manawa ka itomi kikiu. Aituhu aviyaivia niheniua imamaei, yauke taui nihenia amamaei, akanai taui ina‑ua ahiahina. Kate aituhu ubou‑keyemi, ka aituhu ami heta umamaei deina, vona ahiahina, eha ami pata aitam aviani ahiahina upaisewe. ");
INSERT INTO mvn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ika. Aituhu aviyaivia eha niheniua imamae, taui iwenono, ka tau bagunana kiki‑naia na‑hapone‑yavunei. Ka tomotau inꞌ‑omo, e kiki‑naia ikwakwei, inau‑itavi. Ka munia, ai ananata nihenina ihaponei, itunui. ");
INSERT INTO mvn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ka aituhu itomi niheniua umamaei, ka aituhu yau vonana unua‑vi‑avini, ka aituhu yau vonana nihenimia imamaei, akanai aviani yami nuanua, nau‑wawanimi dewaia wayahi uviama, e uvaniahei deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aituhu itomi una‑ua ahiahina, mani tomotau ai pata ua‑naia idudueyei, e inꞌ‑anamanemi uvi‑muni‑waiwaieu. Ka yami dewana Amau didigana na‑vo‑vi‑natei. ");
INSERT INTO mvn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nonova a itoava tuta ataina wayahina, Amau dune‑nuanuaieu. Ka yauke kadu adune‑nuanuaiemi aitamoata deina. Wayahina, ataina nau‑wawanimi yau dune‑nuanuai nihenina umamaei. ");
INSERT INTO mvn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yauke au veimea Amau wayahina avi‑ateteyei, e yauke tauna ya dune‑nuanuai nihenina amamaei deina. Ka aituhu itomi ami veimea wayahiua uvi‑ateteyei, akanai itomi yau dune‑nuanuai nihenina umamaei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Avaha amataedami deina, iuna yau nuanua yau dewa‑haiawa nihenimia mamaei, kadu yau nuanua udewa‑haiawa‑iaua. ");
INSERT INTO mvn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ka ami veimea ananina wayahiua taina, itomi nau‑wawanimi udewa‑vidovidohemi, yauke adewa‑vidovidohemi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aituhu aviyaivia yawai iawaehei yaiai wayahi inꞌ‑aniga, akanai taui yai dewa‑vidovidoha mani dewa‑vidovidoha habuhabuna vane‑tawanei. ");
INSERT INTO mvn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aituhu itomi ami veimea wayahiua uvi‑ateteyei, akanai itomi yaiau ahiahina. ");
INSERT INTO mvn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nonova itomi yau tau paisewa, iuna tau paisewa eha ai tau veimea ya paisewa a venavenau inꞌ‑anamane‑vidohe. Kate tuta ataina wayahina avonevonemi, itomi yaiau ahiahina. Iuna avi nua‑uya Amau wayahina anononi, avaha aviwavenemi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Udueyei! Itomi eha uta‑vi‑nua‑dadaneu. Kate yauke avi‑nua‑dadanemi, kadu anau‑iaiavemi. Iuna yau nuanua una‑ne, una‑ua, ka ua‑naia imaꞌ‑vavaha. Wayahina, aituhu aviani wayahina uviama au wavea, akanai Amau venevenemi deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ka ami veimea ananina wayahiua taina, itomi nau‑wawanimi udewa‑vidovidohemi. ");
INSERT INTO mvn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Aituhu tau maꞌ tanopi inau‑nikonikoiemi, nau‑wawanimi unuanuani, naona inau‑nikonikoieu. ");
INSERT INTO mvn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tau maꞌ tanopi yai dewa goyona. Aituhu itomi yami dewa goyona aitamoata deina, akanai tau maꞌ tanopi ivi‑yaiana wayahimia. Kate yauke avaha avi‑nua‑dadanemi, kadu abou‑keyemi, e itomi tomotau tunimi umamaei. Wayahina, tau maꞌ tanopi inau‑nikonikoiemi, iuna itomi eha taui deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Unuani. Avaha avonemi, avona, ‘Tau paisewa eha ai tau veimea ivane‑tawane.’ Aituhu aviyaivia tau maꞌ tanopi wayahia avaha taua iyapoyapou, apaina tomotaui kadu taumi iyapoyapomi aitamoata deina. Ka aituhu aviyaivia yau viwavenena ivi‑muni‑waiwaiei, apaina tomotaui kadu itomi yami viwavenena ivi‑muni‑waiwaiei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ka aituhu aviyaivia iyapoyapomi, taui idedewei deina, iuna itomi yauke yau yoko, kadu au wava uvo‑vi‑natei. Taui eha Tauna vi‑tuneu itꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yauke avaha aomo wayahia, kadu avaha yai dewa goyona ahaehaeyei tunutunuhina. Kate taui eha yai nuanua ina‑nononi, kadu eha ivitumahaneu. Wayahina, tuta ataina wayahina eha aitam vona‑yavuha ta‑mamae wayahia ana pata ai dewa‑yaiyai na‑bou‑pote. ");
INSERT INTO mvn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aituhu aviyaivia inau‑nikonikoieu, vona ahiahina, taui kadu Amau inau‑nikonikoiei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yauke dewa‑bagibagi habuhabui mataia apaipaisewei, ka tuta naona a itoava tuta ataina wayahina, eha aitam koiaka ana pata dewaia na‑dewe. Aituhu eha dewaia ita‑dudueye, akanai ai dewa‑yaiyai eha potapotai. Ka avaha dewaia adedewei idudueyei, kate taui yauke taua Amau ama inua inau‑nikonikoieai. Wayahina, ai dewa‑yaiyai potapotai akanai. ");
INSERT INTO mvn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ka taui yai dewa goyo‑nana ivinꞌ‑omo Iginuma ivona deina, ‘Yauke taua inau‑nikonikoieu, kate eha iuna.’ ");
INSERT INTO mvn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Apaina yauke Tau Yava‑nana avi‑tunei na‑omo wayahimia, ka tauna Amau wayahina vinꞌ‑omo. Tauna vivane Nuana Tunutunuhina, kadu Amau vi‑tunei na‑omo wayahimia, ka Tau Yava‑nana haehaeyeu. ");
INSERT INTO mvn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ka kadu itomi nau‑wawanimi uhaehaeyeu, iuna yau paisewa a pai vi‑putu wayahina a itoava tuta ataina wayahina nui kamamaei. ");
INSERT INTO mvn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yauke avaha dewaia habuhabui avonemi, iuna yau nuanua eha uni‑panipani, kadu eha yami vitumahana uvo‑haini. ");
INSERT INTO mvn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Apaina taui yai manua tapanono wayahina itana‑wavinimi, kadu tuta omomo wayahina aituhu aviyaivia inau‑vi‑anigimi, akanai taui inuanua yai dewana Yaubada vo‑vi‑dewa‑haiawi. ");
INSERT INTO mvn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yai dewa goyo‑nana wayahimia idedewei iuna taui eha Amau o kadi taua itꞌ‑anamaneai. ");
INSERT INTO mvn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kate, tuta ataina wayahina yauke avaha dewaia tanoi iomomo amai‑vonemi. Ka yau nuanua apaina, avi tuta dewaia ivinꞌ‑omo, akanai itomi unuani, avaha anau‑vi‑avinimi. Naona dewaia tanoi eha ata‑haeye wayahimia, iuna tuta‑nana a itoava tuta ataina wayahina yauke nui kamamaei. ");
INSERT INTO mvn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ka ataina ani‑tawanemi, aneine tauna vi‑tuneu wayahina. Kate eha aitam koiaka wayahimia ta‑vi‑tanaieu, ‘Aveta eneine?’ ");
INSERT INTO mvn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ataina nuami ivita ananina, iuna avaha vonana avonemi unononi. ");
INSERT INTO mvn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kate avona tunutunuhina wayahimia, ataina ani‑tawanemi, ka munia, itomi uvidoha iuna yau nae taina. Aituhu yauke eha ani‑tawanemi, Tau Yava‑nana eha na‑omo wayahimia. Kate aituhu yauke ani‑tawanemi, akanai munia, ami Tau Yava‑nana avi‑tunei na‑omo wayahimia. ");
INSERT INTO mvn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ka avi tuta Tau Yava‑nana na‑omo, tauna dewa aitonu tau maꞌ tanopi wayahia dedewei. Ka dewaia aitonu taina, tauna yai dewa goyona vo‑vi‑mahetei, inꞌ‑anamanei, ka kadu dewa tunutunuhina Yaubada matana vo‑vi‑mahetei inꞌ‑anamanei, ka kadu vitana matana anꞌ auyewa wayahina vo‑vi‑mahetei inꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tau maꞌ tanopi eha inuanua tunuhina dewa goyona wayahina, iuna yauke yai dewa goyona ahaehaeyei wayahia, kate taui eha yau hae ita‑vitumahane ahiahina. ");
INSERT INTO mvn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ka kadu tau maꞌ tanopi eha inuanua tunuhina dewa tunutunuhina wayahina, iuna yauke yai pai dune dewa tunutunuhina wayahina, kate yauke avaha aneine Amau wayahina, e munia taui eha idudueyeu. ");
INSERT INTO mvn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ka kadue tau maꞌ tanopi eha inuanua tunuhina vitana matana anꞌ auyewa wayahina, iuna ataina tuta Yaubada avaha tanopi taina a tau veimea, ana wava Satana, a dewa‑yaiyai vi‑nua‑dadani, ka apaina tauna vaniahei yana dewa goyogoyona wayahi. Ka aituhu tanopi taina a tau veimea a dewa‑yaiyai vaniahei yana dewa goyona wayahi, akanai tauna ya tau paisewa aitamoata aitamoata kadu ai dewa‑yaiyai ivaniahei yai dewa goyona wayahi aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Vona habuhabuna mamaei, kate tuta ataina wayahina eha vonaia habuhabui avonemi, iuna ataina itomi eha ami pata una‑nua‑hau. ");
INSERT INTO mvn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kate apaina Nuana Tunutunuhina na‑omo, ka tauna dewa tunutunuhina habuhabuna vo‑vi‑mahetemi, kadu eta‑naoemi una‑nua‑haui. Ka tauna eha ya nuenuea vonavona, kate aviani tauna nononi, akanai vonaia ai heta vonemi deina. Ka tauna avi dewaia tuta tepakaia ina‑omo wayahi mai‑vonevonemi. ");
INSERT INTO mvn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ka kadu tauna yau nua‑uya nꞌ‑epei, viwavenemi, unꞌ‑anamanei. Wayahina, tauna ya dewana didigau vo‑vi‑natei. ");
INSERT INTO mvn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amau yana gabu habuhabuna kadu ya nua‑uya habuhabuna avaha awaeheu, aveimeyei. Wayahina, au pata avonemi, Nuana Ahihinata yau nua‑uya nꞌ‑epei, viwavenemi, unꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tuta kutakutana na‑iakwa, eha ami pata ududueyeu. Kate tuta kutakutana munia, itomi udune‑havineu.” ");
INSERT INTO mvn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ka tauna a tau vi‑muni‑waiwai tupwai matataui ivi‑tanatanaiei, ivonavona, “Aviani ya vonana anꞌ anamana? Iuna tauna wayahikaia ivona, ‘Tuta kutakutana na‑iakwa, eha ami pata ududueyeu. Kate tuta kutakutana munia, udune‑havineu.’ Kadu wayahikaia ivona, ‘Iuna aneine Amau wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vonana ‘tuta kutakutana’ aviani anꞌ anamana? Kaiwadi! Eha katꞌ‑anamane aviani wayahina tauna ipuipupu.” ");
INSERT INTO mvn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ka Iesu avaha a tau vi‑muni‑waiwai yai nuanua anamanei vivane taui yai nuanua ya vonana wayahina ivi‑tanatanaiei. Wayahina, Iesu vonei, ivona, “Avonemi ‘Tuta kutakutana na‑iakwa, eha ami pata ududueyeu. Kate tuta kutakutana munia, udune‑havineu.’ Vivane taumi vonana wayahina uvi‑tanatanaiemi, a? ");
INSERT INTO mvn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Memeanina nuami vi‑tupatupa, kate avonemi, apaina, aitam auyewa omomo wayahina, itomi uvi‑mohai kadu utoutou. Ka auyewana wayahina tau maꞌ tanopi habuhabui idewa‑haiawa. Itomi unua‑vita, kate munia, yami nua‑vitana na‑iakwa, e itomi udewa‑haiawa. ");
INSERT INTO mvn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pai dune taina vavine aitam wayahina udueyei. Avi tuta vavinena yana tuta vi‑natuna avaha omo, akanai vavinena nua‑vita, iuna viha ana tuta avaha vaniahei. Kate munia, tevana avaha tupua, akanai viha habuhabuna nuai na‑pani, iuna tevana vovouna mamaei, ka vavinena dewa‑haiawa tevana wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ka itomi vavine‑nana deina. Iuna ataina nua‑vita ana tuta avaha vinꞌ‑omo wayahimia. Kate apaina amavina, e udune‑havineu. Ka auyewana wayahina udewa‑haiawa ananina, ka dewa‑haiawana na‑maꞌ‑vavaha. Ka eha aitam koiaka ana pata yami dewa‑haiawana vi‑goyo. ");
INSERT INTO mvn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Apaina auyewana wayahina, yami vi‑tanai wayahiua na‑iakwa. Ka ataina memeanina nuami vi‑tupatupa, kate avonemi taina deina. Aviani wayahina au wavea Amau uviamei, tauna na‑venemi akanai. ");
INSERT INTO mvn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuta nonova a itoava tuta ataina wayahina, eha aitam aviani wayahina au wavea uta‑viame. Ataina tuta avonemi, nau‑wawanimi uviama, e uvaniahei, wayahina udewa‑haiawa‑iaua. ");
INSERT INTO mvn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nonova a itoava tuta ataina wayahina, vona tana‑minikuna wayahina aviwavenemi. Ka aitam auyewa omomo, ka auyewana wayahina eha vona tana‑minikuna wayahina avonevonemi, kate yauke Amau ahaehaeyei vuvunaha wayahimia. ");
INSERT INTO mvn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ka auyewana wayahina, vona ahiahina, itomi au wavea Yaubada uviamei. Ka eha nau‑wawanimi yauke yami viama ana‑ivaite. Eha. Auyewana wayahina itomi ami heta ami pata Amau uviamei tunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Iuna Amau kadu avaha dune‑nuanuaiemi. Tauna dune‑nuanuaiemi deina, iuna itomi avaha udune‑nuanuaieu, ka kadu avaha uvitumahaneu yauke Yaubada wayahina avinꞌ‑omo baina. ");
INSERT INTO mvn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ika, yauke Amau wayahina avinꞌ‑omo baina tanopia, ka yauke tanopi taina anu‑mei amamaei. Kate ataina tuta tanopi ani‑tawanei, e amavimavina Amau wayahina.” ");
INSERT INTO mvn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wayahina, Iesu a tau vi‑muni‑waiwai ivonei, ivona, “Akanai. Ataina tuta wamke avaha evonavona vuvunaha wayahiaia, eha vona tana‑minikuna wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ataina itoai avaha anamane‑vidohem vivane eha nau‑wawanim aitam koiaka vi‑tanatanaiem, iuna wamke avaha vona‑nau‑pata habuhabuna eanamane‑yehai. Dewana wayahina, itoai avitumahanem wamke Yaubada wayahina evinꞌ‑omo baina.” ");
INSERT INTO mvn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ka Iesu vi‑tanaiei, ivona, “Ataina itomi avaha uvitumahaneu, ika? ");
INSERT INTO mvn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tuta omomo, kadu kana‑vona ataina avaha omo, e taumi habuhabumi usi‑noveu, e uyavuta aitamoata aitamoata yami manua wayahia, ka yauke au heta amamaei. Kate yauke eha vivane au heta, iuna Amau ama inua nui amamaei. ");
INSERT INTO mvn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Vonaia habuhabuna ahaehaeyei wayahimia, iuna yau nuanua itomi nua gomagomanina uvaniahei yauke niheniua. Tanopi taina wayahina vitana uvaniahei kadu uhidahida, kate unꞌ‑ate‑vatu akanai, iuna yauke avaha tanopi taina abagibagi‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka Iesu avaha vonana nau‑yehai, e tauna wahuma dune‑vane ka vi‑putu viama, ivona, “Amau, yauke Natu‑hoim, ka ataina au tuta avaha vinꞌ‑omo. Wayahina, didigau evene‑havineu, e tomotau idudueyei, iawa‑davedaveu. Ka kadu apaiku yauke didigam avo‑vi‑natei, e munia tomotau iawa‑davedavem. ");
INSERT INTO mvn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aviama deina iuna wamke avaha eawaeheu tomotau habuhabui aveimeyei. Ka aituhu aviyaivia avaha eveneu, akanai yauke nau‑wawaniu taui habuhabui yawai‑vavaha avenei. ");
INSERT INTO mvn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ka yawai‑vavaha taina deina. Aituhu tomotau inꞌ‑anamanem wamke am heta Yaubada‑hoim, ka kadu aituhu tomotau inꞌ‑anamaneu yauke Iesu Tau Ito‑yavuha, ka kadu aituhu inꞌ‑anamanei, wamke evi‑tuneu aomo baina tanopia. ");
INSERT INTO mvn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Avaha didigam avo‑vi‑natei tanopia, iuna avaha paisewana nonova eveneu anau‑yehai. ");
INSERT INTO mvn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Amau, ataina tuta wayahina wamke matama akanai didigau evene‑havineu. Tuta nonova wayahina aka inua didigaka nui kamamaei, e munia tanopi kavevewanei. Ka yau nuanua tuta tepakaia didigau aitamoata deina aka inua kamamaei. ");
INSERT INTO mvn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","O Amau, nonova au tau vi‑muni‑waiwai habuhabui taina tau maꞌ tanopi, kate taui yam tomotau. Ka taui eveneu, ka avaha yau dewa asi‑vinꞌ‑omanei idudueyei. Wayahina, taui avaha ianamanem, ka kadu avaha yam vona habuhabuna ivi‑ateteyei. ");
INSERT INTO mvn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ka ataina avaha ianamanei, dewaia habuhabui eveneu, akanai wayahima ivinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Iuna viwavenena habuhabuna nonova eveneu, avaha aviwavenei, iawaehei kadue inua‑vi‑avini. Ka taui avaha ianamane‑yehai, yauke taum wayahima avinꞌ‑omo, ka kadu ivitumahanem, wamke evi‑tuneu aomo baina tanopia. ");
INSERT INTO mvn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amau, ataina au tau vi‑muni‑waiwai taina wayahi aviamem. Eha tau maꞌ tanopi wayahi aviamem. Kate tomotau taina eveneu, taui wayahi aviamem, iuna taui vivane yam tomotau. ");
INSERT INTO mvn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yauke yau pai veimea habuhabuna vivane wamke yam pai veimea. Ka aitamoata deina, wamke yam pai veimea habuhabuna avaha eawaeheu vivane yauke yau pai veimea. Ka au tau vi‑muni‑waiwai taina avaha didigau ivo‑vi‑natei taui yai dewa wayahi. ");
INSERT INTO mvn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kate ataina ani‑tawanei aomomo wayahima. Eha baina amamae, kate taui taina nau‑wawani baina tanopia imamaei. O Amau Ahihimata! Am wava bagibagi‑vainena, kadu wamke am wava‑nana avaha eveneu. Ka ataina ahidahidam, taui edune‑vi‑avini, kadu dewa goyona ebou‑potei wayahia am wava a bagibagi wayahina. Iuna yau nuanua taui ivi‑yoko aitamoata, wamke yauke aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nonova a itoava tuta ataina wayahina, yauke taui nui amamaei, ka am wava a bagibagi wayahina adune‑vi‑avini ahiahina, ka kadu goyona abou‑potei wayahia. Ka eha aitam koiaka wayahia ata‑ni‑kaiete, ana heta tauna dewa goyona natuna. Nonova Iginuma onotona wayahina apa‑taputapu vivane tauna nau‑wawani inahe kadu dewa‑yaiyai vaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ataina yauke aomomo wayahima, kate yau vonana avonavona tanopia, iuna yau nuanua yau dewa‑haiawa taui au tau vi‑muni‑waiwai nihenia mamaei, kadu yau nuanua idewa‑haiawa‑iaua. ");
INSERT INTO mvn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Avaha taui taina yam vona avenei, ka avaha ivitumahanei. Wayahina, tau maꞌ tanopi inau‑nikonikoiei, iuna au tau vi‑muni‑waiwai eha tau maꞌ tanopi yai dewa ita‑vi‑munie, ka kadu yauke eha tau maꞌ tanopi yai dewa ata‑vi‑munie deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka eha aviamem taui baina tanopia enꞌ‑epa‑tawane. Kate aviamem eha Tau Goyogoyona eawaehe taui yawai vi‑goyo. ");
INSERT INTO mvn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iuna taui eha tau maꞌ tanopi yai dewa ita‑vi‑munie, yauke kadu eha tau maꞌ tanopi yai dewa ata‑vi‑munie deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wayahina, yau nuanua yam vona tunutunuhina wayahina taui evo‑vi‑aiaiei ebou‑keyei, imamaei yoko tunina tau maꞌ tanopi wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","O Amau, wamke evi‑tuneu aomo tanopia. Ka kadu yauke avaha au tau vi‑muni‑waiwai taina avi‑tunei iomo tau maꞌ tanopi wayahia aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ka yauke yau nuanua apaina taui ivi‑ateteyem ahiahina. Wayahina, ataina taui wayahi yauke abou‑keyeu, iuna yau nuanua ananina pai dune ahiahina avenei idueyei, e apaina taui ibou‑keyei ivi‑ateteyem. ");
INSERT INTO mvn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","O Amau, au tau vi‑muni‑waiwai wayahi aviamem, kate eha taui taina ai heta wayahi. Yauke kadu mani tomotau habuhabui wayahi aviamem. Apaina mani tomotau au tau hae taina yai nau‑wahe inononi, ivitumahaneu. Taui habuhabui wayahi kadu aviamem. ");
INSERT INTO mvn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aviamem habuhabui ivi‑yoko aitamoata. O Amau! Aviamem taui habuhabui aka inua nihenikaia imamaei, wamke niheniua emamaei deina, kadu yauke nihenima amamaei deina. Ka aviamem au tau vi‑muni‑waiwai habuhabui ivi‑yoko aitamoata. Wayahina, tau maꞌ tanopi au tau vi‑muni‑waiwai yai dewa ahiahina idudueyei, e munia ivitumahanem, taum evi‑tuneu ana‑ito‑yavuhi. ");
INSERT INTO mvn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nonova didigam eveneu, ka didigam kadu didigau aitamoata, ka aka inua aitamoata kamamaei deina. Ka yauke avaha au tau vi‑muni‑waiwai taina didigaka avenei, e taui ivi‑yoko aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Vona ahiahina, wamke niheniua emamaei, ka kadu yauke taui nihenia amamaei aitamoata deina. Yauke aviamem taui evo‑vi‑aiaiei, e munia ivi‑yoko aitamoata. Wayahina, apaina tau maꞌ tanopi yai dewa ahiahina idudueyei, vivane au tau vi‑muni‑waiwai ivi‑yoko aitamoata, e tau maꞌ tanopi inꞌ‑anamanei evi‑tuneu, kadu inꞌ‑anamanei taui edune‑nuanuaiei, edune‑nuanuaieu aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Amau! Wamke avaha tau hae taina eveneu. Ka yauke yau nuanua apaina, aveta baina yauke amamaei, akanai taui kadu wayahiua imamaei. Kadu yau nuanua taui didigau idudueyei. Nonova didigauna eveneu, iuna tuta naona wayahina edune‑nuanuaieu. Ika, naona edune‑nuanuaieu, e munia tanopi kavevewanei. ");
INSERT INTO mvn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Amau, Tunutunuhim! Tau maꞌ tanopi eha itꞌ‑anamanem, kate yauke anamanem, ka au tau vi‑muni‑waiwai taina kadu avaha ivitumahanem wamke evi‑tuneu. ");
INSERT INTO mvn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nonova a itoava tuta ataina wayahina, yauke yau paisewa wayahina taum asi‑vinꞌ‑omanem taui wayahia inꞌ‑anamanem. Ka kadu yau paisewa apaiku apaisewei wayahina asi‑vinꞌ‑omanem inꞌ‑anamanem aitamoata deina. Iuna yau nuanua taui yam dune‑nuanuai ananina wayahiu inꞌ‑anamanei, ka yau nuanua dune‑nuanuai‑nana kadu taui nihenia mamaei. Ka kadu yau nuanua yauke taua nihenia amamaei.” ");
INSERT INTO mvn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka avaha ya viamana nau‑yehai, Iesu tauna a tau vi‑muni‑waiwai nui iopu ine. E taui Awa‑haha Kidironi a daudau kikituna iaubo‑tamani papanina. Ka tanoi wayahina aitam baguna mamaei, e tauna kadu a tau vi‑muni‑waiwai nui bagunana inui. ");
INSERT INTO mvn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ka Iudasa, tauna vi‑nua‑hauhauei, kadue papani‑nana anamanei. Iuna tuta habuhabuna Iesu neine bagunana wayahina, e tanoi wayahina tauna kadu a tau vi‑muni‑waiwai nui inau‑hohona. ");
INSERT INTO mvn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wayahina, Iudasa omoi bagunana, ka tauna yoko ananina eta‑naonaoi. Ka yokoia nihenia vivane tau nau‑havia yoko, ka tau mini‑potapota tupwai tau vi‑nomu mata‑genai wayahia, ka kadue tupwai Parisi yai yoko wayahia. Ka taui habuhabui Iudasa ivi‑muniei iomomo bagunana wayahina. Ka taui iomomo yai lampaV wayahia, ka yai odama wayahia, ka kadue havia a gugua wayahia. ");
INSERT INTO mvn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ka Iesu avaha anamanei dewaia habuhabui ivinꞌ‑omo‑nananena. Wayahina, tauna omo yokoia wayahia, e vi‑tanaiei, ivona, “Koiaka unenene?” ");
INSERT INTO mvn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ka taui ivona‑nau‑patei, ivona, “Iesu, onoto Nasareta.” Wayahina, Iesu vonei, ivona, “Yauke Taua Amamaei.” (Ka Iudasa, Iesu a tau vi‑nua‑hauhau, tanoi nui imimini.) ");
INSERT INTO mvn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ka tutana Iesu vonei, ivona, “Yauke Taua Amamaei,” akaka yoko‑naia ivi‑muni‑uhauha, e ipeu tanopia! ");
INSERT INTO mvn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wayahina, Iesu taui vi‑tanai‑havinei, ivona, “Koiaka unenene?” Ka taui ivona, “Iesu, onoto Nasareta.” ");
INSERT INTO mvn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Wayahina, Iesu vona‑havinei, ivona “Avaha avonemi, Yauke Taua Amamaei. Wayahina, aituhu itomi uneneneu, nau‑wawanimi taui taina unꞌ‑awaehei ina‑ne.” ");
INSERT INTO mvn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ka Iesu avaha a tau vi‑muni‑waiwai wayahi viama, ka vonana viamana nau‑yehai, ivona, “Taui avaha eveneu, eha aitam koiaka wayahia ata‑ni‑kaiete.”) ");
INSERT INTO mvn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kate Simoni Pita tauna ya kwasikwasi wayahina, ka taini, e tau vi‑nomu ananina ya tau paisewa ana wava Malikusi vunui, e tanihana ateina upwa‑yavunei. ");
INSERT INTO mvn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Akaka Iesu Pita veimeyei, ivona, “Yam kwasikwasi a pai vi‑ai nihenina ebou‑havinei! Medeina enuanua? Amau avaha viha ana vei veneu, kadu nau‑wawaniu vei‑nana wayahina animnim, o eha? Nau‑wawaniu paisewana Amau veneu anau‑yehai akanai.” ");
INSERT INTO mvn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wayahina, tau nau‑havia yoko, kadu taui yai tau eta‑naonao ananina nui, kadu me Iudea yai tau mini‑potapota Iesu ipoyꞌ‑avini, e iyohoni. ");
INSERT INTO mvn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ka naona taui Kaiapasi nawana wayahina itaini ineiei. Tauna ana wava Anasi. Ponimana tanoi wayahina Kaiapasi vivane tau vi‑nomu ananina. ");
INSERT INTO mvn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ka nonova Kaiapasi me Iudea vonei, ivona, “Aituhu apaina onoto aitamoata nꞌ‑aniga tomotau habuhabuka wayahika, akanai itoka me Iudea habuhabuka eha kanꞌ‑aniga deina.” Ka naona Anasi Iesu vi‑tanatanaiei. ");
INSERT INTO mvn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ka Simoni Pita ka aitam tau vi‑muni‑waiwai nui, ainuai Iesu ivi‑muniei. Ka tau vi‑muni‑waiwai‑nana tau vi‑nomu ananina anamanei ahiahina. Wayahina, tauna ana pata Iesu nui tau vi‑nomu ananina ya manua inui. ");
INSERT INTO mvn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kate Pita nau‑wawani tutu‑gana awana vuvunahina mimini potapota. Ka tau vi‑muni‑waiwai‑nana, tauna tau vi‑nomu ananina anamanei, mavina, e ahabana awa a tau dune‑vi‑avina wayahina ipupu, e ahabana Pita awaehei na‑nu nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ka ahabanana, awa a tau dune‑vi‑avina, Pita vi‑tanaiei, ivona, “Kaiwadi, taum kadu onotona a tau vi‑muni‑waiwai aitam, a?” Akaka Pita vona‑nau‑patei, ivona “Yauke eha.” ");
INSERT INTO mvn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ka ioyomana kwadudu ananina. Wayahina, kwauto ana ganiana mamaei, ka tau paisewa yoko kadu tau nau‑havia yoko imimini ai wayahina, e ivivi‑vana. Ka Pita kadu nui mimini ka tauna vivi‑vana. ");
INSERT INTO mvn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ka tau vi‑nomu ananina Iesu vi‑tanatanaiei tauna a tau vi‑muni‑waiwai wayahi, kadu vi‑tanatanaiei ya viwavenena wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ka Iesu vona‑nau‑patei, ivona, “Auyewa naona a itoava ataina wayahina, yauke yoko habuhabui mataia anaunau‑wahe. Ka manua tapanono habuhabui nihenia, kadu Manua Vito‑pota nihenina, kadu aveta baina me Iudea inau‑hohona, akanai papani‑naia habuhabui nihenia tomotau aviwavenena. Eha aitam aviani ata‑vona‑hive. ");
INSERT INTO mvn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wayahina, aviani wayahina wamke taua evi‑tanatanaieu? Nau‑wawanim taui avaha yau viwavenena inononi evi‑tanatanaiei. Iuna aviani aviwavenei, taui avaha ianamane‑vidohei, kadu taui ai pata imataedam tunuhina.” ");
INSERT INTO mvn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ka tutana Iesu vonana nau‑yehai, tau mini‑potapota aitam Iesu nepena mimini maga‑bawe, piahi, kadu vi‑tanaiei, ivona, “Tauna tau vi‑nomu ananina, kate taum koiaka? Aviani wayahina eipuipupu tau vi‑nomu ananina wayahina deina?” ");
INSERT INTO mvn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ka Iesu vona‑nau‑patei, ivona, “Aituhu avaha vona goyona avonei, akanai vona goyo‑nana tomotau matakaia esi‑vinꞌ‑omanei. Kate aituhu vona ahiahina avonevonei, aviani wayahina evunu?” ");
INSERT INTO mvn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ka nonova bagunana nihenina tau nau‑havia Iesu nimana iyohoni. Ka tutana Anasi Iesu vi‑tanatanaiei, Iesu nimana yohoyohonina mamaei deina. Ka tutana Anasi vi‑tunei ine Kaiapasi wayahina, e tauna kadu vi‑tanatanaiei, akanai Iesu nimana yohoyohonina mamaei deina. ");
INSERT INTO mvn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ka Simoni Pita mimini ka vivi‑vana. Wayahina, taui nui ivi‑tanaiei, ivona, “Wamke kadue aitam a tau vi‑muni‑waiwai wayahia, ika?” Kate Pita tana‑tavutavuna, e ivona, “Yauke eha.” ");
INSERT INTO mvn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ka tau vi‑nomu ananina ya tau paisewa aitam mamaei. Ka Pita avaha aitam tau paisewana yana yoko wayahia tanihana upwa‑yavunei. Wayahina, tau paisewana mini, ivona, “Mataua avaha wamke tauna ami inua adueyemi Baguna Olive nihenina, a?” ");
INSERT INTO mvn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wayahina, Pita tana‑tavutavuna‑havine. Ka visi‑kwayavoni kamkam onotona itou. ");
INSERT INTO mvn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ka avaha mana navia. Ka me Iudea‑naia Iesu itaini, e Kaiapasi ya manua ini‑tawanei, ka ineiei papani Isiraeli a tau veimea ananina wayahina. Tauna aitam me Rom, ana wava Pilate, ka ya manua ananina (manuana ana wava Paraetorium) mamaei. Kate me Iudea‑naia eha nau‑wawani Pilate ya manua ina‑nu, iuna Pilate eha aitam me Isiraeli. Ka me Isiraeli ai veimea Mosese wayahina mamaei dewana vito‑potei. Aituhu dewana idewe, ivi‑gawama Yaubada matana, ka munia eha ai pata Itouvuha Toneina inꞌ‑am. ");
INSERT INTO mvn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dewana vito‑pota wayahina, Pilate ni‑ubau iopu taui wayahia, e vi‑tanaiei, ivona, “Avi vita wayahina onoto taina uvitevitei?” ");
INSERT INTO mvn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ka taui ivona‑nau‑patei, ivona, “Aituhu onoto taina onoto ahiahina, ataina itoai eha ana‑omane taum wayahima.” ");
INSERT INTO mvn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ka Pilate wayahia ivona, “Itomi ami heta uvituei, ka medeina ami veimea awaehemi, akanai unau‑yanahi deina.” Kate me Iudea‑naia ivonei, ivona, “Ataina itomi me Rom eha uawaeheai itoai me Iudea ama pata aitam onoto ana‑nau‑vi‑anigi.” ");
INSERT INTO mvn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ka yai vonana omo deina, e Iesu ya vonana yanꞌ aniga ana dewa wayahina nau‑yehai.) ");
INSERT INTO mvn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wayahina, Pilate mavina, manua ananina nihenina inu, ka kadu Iesu honei, e vi‑tanaiei, ivona, “Vona ahiahina, wamke me Iudea yai kiniV?” ");
INSERT INTO mvn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Wayahina, Iesu vona‑nau‑patei, ivona, “Taum am heta wayahima vi‑tanai taina vinꞌ‑omoi, o kadi mani tomotau avaha ihaeyeu wayahima?” ");
INSERT INTO mvn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ka Pilate vi‑tanaiei, ivona, “Ia! Medeina? Wamke enuanua yauke aitam me Iudea? Eha. Wamke yam tomotau, kadu yami tau vi‑nomu mata‑genai taum iam‑veneneyeu. Aviani yam dewa goyona?” ");
INSERT INTO mvn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ka Iesu vonei, ivona, “Yauke yau pai veimea eha baina tanopi taina wayahina. Aituhu yau pai veimea tanopi taina wayahina, vona ahiahina, au tau vi‑muni‑waiwai nau‑wawani au havia ivi‑naue. Ka aituhu deina, eha memeanina me Iudea ipoyꞌ‑aviniu. Kate ataina yau pai veimea eha baina tanopia.” ");
INSERT INTO mvn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wayahina, Pilate vi‑tanaiei, ivona, “O, wamke vivane aitam kiniV, ika?” Ka Iesu vona‑havine, ivona, “Ataina wamke evonavona yauke aitam kiniV. Ka vona ahiahina, yauke atupua, kadu yauke aomo tanopia, ka yau paisewa ananina vivane vona tunutunuhina ahaehaeyei. Ka aituhu aviyaivia vona tunutunuhina natunatuna, akanai taui habuhabui yau vona inononi.” ");
INSERT INTO mvn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ka Pilate vi‑tanaiei, ivona, “Vona tunutunuhina aviani?” Akaka Pilate ni‑ubau opu‑havine me Iudea wayahia, e vonei, ivona, “Eha aitam yana dewa goyona ata‑vaniahe. Wayahina, eha nau‑wawaniu adewa‑yaiyaie. ");
INSERT INTO mvn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kate yami dewa Itouvuha Toneina aitamoata aitamoata wayahina mamaei, vivane aitam tau goyona ana‑ito‑yavuhi wayahimia. Wayahina, medeina yami nuanua? Ataina itomi me Iudea yami kiniV ana‑ito‑yavuhi wayahimia?” ");
INSERT INTO mvn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kate taui mainini ivi‑hone, “Tauna eha! Itoai yama nuanua Barabasa!” (Ka Barabasa tauna aitam tau vainau.) ");
INSERT INTO mvn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wayahina, Pilate Iesu vi‑tunei ine tau nau‑havia wayahia, e Pilate ai veimea venei, e taui yavunai wayahina imoamoani. ");
INSERT INTO mvn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ka tau nau‑havia‑naia kunu‑nabanaba tonatonana imetani, e Iesu unununa iboui, kadu kwama yabebenina wayahina ivi‑weteni. ");
INSERT INTO mvn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ka iomo‑havihavine Iesu wayahina, e ivonavona, “Kaiwa ananina, me Iudea yai kiniV!” Ka nimaia ipiapiahi. Dewaia habuhabui wayahia ivinepei deina. ");
INSERT INTO mvn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ka dewaia iakwa, e Pilate ni‑ubau opu‑havine me Iudea yokoia wayahia, e vonei, ivona, “Udueyei, tauna aomanei wayahimia. Ka yau nuanua unꞌ‑anamanei, eha aitam tauna yana dewa goyona ata‑vaniahe. Wayahina, nau‑wawaniu ayavuhi akanai.” ");
INSERT INTO mvn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ka Iesu ni‑ubau iopu wayahia, a kunu‑nabanaba tonatonana kadu ana kwama yabebenina ainua weteweteni. Ka Pilate yokoia vonei, ivona, “Onoto taina udueyei!” ");
INSERT INTO mvn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kate tutana tau vi‑nomu mata‑genai, kadu tau mini‑potapota idueyei, ivi‑honehone Pilate wayahina, “Etutu‑pwatei! Etutu‑pwatei!” Wayahina, Pilate vona‑nau‑patei, ivona, “Aituhu itomi yami nuanua ututu‑pwatei, akanai, taumi ami heta uneiei, kadue ai nahenahea ututu‑pwatei! Kate yauke taua eha aitam iuna ata‑vaniahe itoai me Rom ama veimea nihenina, e tauna yanꞌ aniga nꞌ‑awaehe.” ");
INSERT INTO mvn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kate me Iudea ivona‑nau‑pata wayahina, “Aitam iuna mamaei itoai ama veimea nihenina yanꞌ aniga veimeyei. Iuna tauna ivona, ‘Yauke taua Yaubada Natu‑hoina.’” ");
INSERT INTO mvn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ka Pilate avaha vonana nononi, e yauna inovo, kadu matamatauta ananina. ");
INSERT INTO mvn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wayahina, Pilate tauna ya manua ananina inu‑havinei, e Iesu vi‑tanaiei, ivona, “Aveta baina wayahina evinꞌ‑omo?” Kate Iesu eha ta‑vona‑nau‑pata Pilate wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wayahina, Pilate Iesu vi‑tanaiei, ivona, “Aviani wayahina eha evona‑nau‑patau? Vona ahiahina, awaeha mamaei wayahiua. Aituhu yau nuanua, ana‑ito‑yavuhim, o aituhu yau nuanua, atutu‑pwatam. Enua‑haui o eha?” ");
INSERT INTO mvn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ka Iesu ivona, “Ataina wamke eveimeyeu, iuna Yaubada wahuma avaha awaehem ededewei deina. Wayahina, onoto‑nana taua am‑veneneyem yana dewa goyona vivane ani‑vainena.” ");
INSERT INTO mvn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ka babau‑nana a itoava dewa pai nau‑yehata wayahina, Pilate ya nuanua Iesu na‑ito‑yavuhi. Kate me Iudea ivi‑hone‑havihavine, “Aituhu onoto taina ena‑ito‑yavuhi, wamke eha SisaV a niam! Iuna aituhu aviyaivia ivonavona, ‘Yauke aitam kiniV,’ onoto taina vonavona deina, akanai taui vivane SisaV a havia, iuna SisaV ana heta yaka kiniV.” ");
INSERT INTO mvn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ka Pilate, avaha yai vonana nononi, ine, e Iesu taini omanei mataia. Ka Pilate omo tau vaneneha a pai manuena wayahina, e manuena. Ka papani‑nana ana wava Hanuhanuna (ka me Ebereu movia ana wava Gabata). ");
INSERT INTO mvn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ka auyewana vivane Itouvuha Toneina a pai vo‑vi‑aiai, kadu avaha auyewa pouna. Ka Pilate me Iudea vonei, ivona, “Yami kiniV taina udueyei!” ");
INSERT INTO mvn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kate ivi‑honehone, “Enau‑vi‑anigi! Enau‑vi‑anigi! Ai nahenahea etutu‑pwatei!” Akaka Pilate vi‑tanaiei, ivona, “Kaiwadi, aviani wayahina yami kiniV ai nahenahea atutu‑pwatei?” Kate tau vi‑nomu mata‑genai ivona, “Eha kadu aitam yama kiniV! Akanai, SisaV ana heta.” ");
INSERT INTO mvn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ka dewa pai nau‑yehata wayahina Pilate yokoia yai nuanua awaehei, e Iesu a tutu‑pwata veimeyei kadu am‑veneneyei, e ai nahenahea itutu‑pwatei. Ka tau nau‑havia Iesu itaini, iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Akaka Iesu iopu, ine, e tauna anꞌ ai nahanahana avanei. Ka tauna omo papani‑nana ivi‑wahani “Ununu Kabwa.” (Ka me Ebereu movia ana wava Goligota.) ");
INSERT INTO mvn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ka tanoi ai nahenahea itutu‑pwatei, kadu onoto ainua nui, papani aitam, papanina aitam, ka Iesu niwania. ");
INSERT INTO mvn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ka Pilate aitam pai mataeda ginumi, kadu veimeyei vivane Iesu anꞌ ai nahanahana wayahina itutu‑pwatei. Ka pai mataedana ivona, “iesu tevana nasareta, me iudea yai kiniV.” ");
INSERT INTO mvn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ka pai mataedana movi aitonu wayahia ginumi, akanai me Ebereu movia, ka me Rom movia, ka kadue me Girisi movia. Ka papani‑nana meagai Ierusalem nepena, ka me Iudea habuhabui pai mataedana iaiaiavi. ");
INSERT INTO mvn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wayahina, me Iudea yai tau vi‑nomu mata‑genai iomo Pilate wayahina, e ivonei, ivona, “Yam iginuma, ‘Me Iudea Yai KiniV’ eha tunuhina. Kate nau‑wawanim eginumi, ‘Onoto taina ivona, “Yauke me Iudea yai KiniV.” ’ Aina tunutunuhina deina.” ");
INSERT INTO mvn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kate Pilate yai nuanuana vihahaiei, e vonei, ivona, “Aviani avaha aginumi, akanai tunutunuhina! Mamaei deina!” ");
INSERT INTO mvn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ka tau nau‑havia‑naia, avaha Iesu ai nahenahea itutu‑pwatei, ana kwama ivituei, e na nau‑punina wayahina ivo‑pateyei, vivane tau nau‑havia aitamoata aitamoata a vo‑pata. Kadu a pai vitana‑gavagava ana heta mamaei. Ka pai vitana‑gavagavana eha uya‑numina, si‑vivina‑ohoi. ");
INSERT INTO mvn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wayahina, tau nau‑havia‑naia matataui ivona, “Eha kwama taina kasi‑yehia kavi‑goyo. Kate nau‑wawanika kavimwa‑neneyei.” Ka taui yai vonana vinꞌ‑omo nonova Iginuma apa‑taputapuei deina, ivona, “Taui au kwama wayahia ivo‑pateyei, kadu yau pai vitana‑gavagava wayahina ivimwa‑neneyei.” Wayahina, tau nau‑havia idewei deina. ");
INSERT INTO mvn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ka Iesu anꞌ ai nahanaha nepena vaivine tupwai imimini. Taui wayahia na nau‑punina, vivane Iesu ayona, ka ayona vanei, ka kadu aitam Mari (taui Kilopasi awana), ka kadue Mari me Magidala. ");
INSERT INTO mvn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ka Iesu tomotau ainua dueyei, imimini nepena, e taui ayona kadu a tau vi‑muni‑waiwai‑nana (Iesu tauna dune‑nuanuaiei). Ka ayona wayahia ivona, “Vavinemi, onoto taina vivane natumi.” ");
INSERT INTO mvn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ka Iesu tauna a tau vi‑muni‑waiwai‑nana wayahina ivona, “Vavine taina vivane ayom.” Wayahina, munia tau vi‑muni‑waiwai‑nana Iesu ayona taini neiei tauna ya manua wayahina, e tauna dune‑vi‑avini. Ka auyewana a itoava ayona ai tuta iakwa wayahina nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ka dewana iakwa, ka Iesu avaha anamanei tuta nonova wayahina aviani tau apa‑taputapu Iginuma nihenina iapa‑taputapuei tauna ana heta wayahina, akanai tauna dewa‑naia habuhabui avaha nau‑yehai. Ka kadu aitam vona Iginuma nihenina mamaei, ka Iesu nau‑wawani kadu dewana na‑nau‑yehai. Wayahina Iesu ivona, “Magau ayaya.” ");
INSERT INTO mvn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ka wainaV yuyuna na biahoina mamaei. Wayahina, aitam banou nihenina isi‑utuvi, e guna tabona iboui, e isi‑nai Iesu awana wayahina. ");
INSERT INTO mvn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ka avaha Iesu nim‑dadani, ivona, “Avaha!” Akaka unununa iwaodu, ka nuana yavuhi, e yawaina iakwa. ");
INSERT INTO mvn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ka auyewana wayahina me Isiraeli ivo‑vi‑aiai SabataV ananina wayahina, vivane Itouvuha Toneina a pai vi‑putu. Ka taui ai veimea aitam mamaei, e veimeana tomotau ai nahenahea imamaei vito‑potei. Wayahina, me Iudea yai nuanua, me Rom ivisina, e tomotau aitonu inini ivi‑opui ai nahenahea. Wayahina, me Iudea iomo Pilate wayahina, e iviamei tauna tau nau‑havia vi‑tunei, e aei itutu‑dobwedobwei, e deina inꞌ‑aniga‑kwayavoni, e inini inꞌ‑epai. ");
INSERT INTO mvn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ka Pilate yai viamana awaehei. Wayahina, tau nau‑havia iomo, e onotona Iesu papanina aena itutu‑dobwei. Kadu omo, e onotona papani‑nana wayahina aena itutu‑dobwei. ");
INSERT INTO mvn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ka tutana Iesu wayahina iomo, tauna avaha aniga. Wayahina, eha aena ita‑tutu‑dobwe. ");
INSERT INTO mvn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kate aitam tau nau‑havia apia epei, e Iesu baimina tonei. Vo‑kwayavonina dayaha ka daudau ainua itaina iopu. ");
INSERT INTO mvn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ka aitam onoto matana dewaia dueyei. Ka tauna avaha dewaia haeyei, ka tauna yana hae tunuhina. Ka onotona anamane‑vidohei vivane tauna yana hae tunuhina, ka tauna dewana haehaeyei. Wayahina, itomi kadu ami pata uvitumahanei vivane Iesu yanꞌ aniga eha vitupu.) ");
INSERT INTO mvn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dewaia tanoi ivinꞌ‑omo, ka apa‑taputapu Iginuma nihenina inau‑yehai. Aitam apa‑taputapu ivona, “Eha aitam numanumana dobwadobwana.” ");
INSERT INTO mvn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ka kadu aitam ivona, “Tauna itonei idudueyei.” ");
INSERT INTO mvn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ka dewaia munia, Iosepa me Arimatea omo Pilate wayahina, e tauna Iesu tau matena viamei. (Iosepa aitam Iesu a tau vi‑muni, kate tauna vi‑muni‑hivehivei, iuna tauna me Iudea yai tau eta‑naonao matamatautei.) Ka Pilate ya viamana awaehei, e Iosepa omo, e Iesu tau matena epei. ");
INSERT INTO mvn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ka Iosepa a niam Nikodemusi nui iomo. (Nonova, aitam ioyoma, Nikodemusi omo Iesu wayahina.) Ka Nikodemusi nau‑tamoina omanei, gugua ainua manina ani‑vainena kadu ahiahina wayahia inau‑vevewanei. Ka guguaia ainuai ai wava muroV kadu aloeV. Ka nau‑tamoina ana vita ai yau 34 kiloV deina. ");
INSERT INTO mvn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ka ononotoi ainuai Iesu tau matena iepei, e kaleko lineniV mamanaina nau‑tamoina nui iaumei. Dewana vivane me Iudea yai dewa, ka tau mate ivo‑vi‑aiaia a pai vi‑ai wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ka papani‑nana aveta itutu‑nahenahei wayahina, aitam baguna nepena mamaei. Ka bagunana nihenina aitam unuvovo guba mamaei. Ka unuvovona vivane vovouna. Eha aitam tau mate nihenina ita‑bou. ");
INSERT INTO mvn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ka me Iudea SabatanaV ananina wayahina ivo‑vi‑aiai, kadu unuvovona nepena. Wayahina, ononotoia ainuai Iesu tau matena unuvovona nihenina iboui akanai. ");
INSERT INTO mvn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Avaha wiki anꞌ auyewa naona omo, e mata hamwahamwanina Mari me Magidala omo unuvovona wayahina. Ka hanuna gubana awana eha ta‑bou‑pote, kate nepena mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wayahina, Mari nau‑bwanunua omo Simoni Pita kadu tau vi‑muni‑waiwai‑nana (Iesu tauna dune‑nuanuaiei) wayahia, e ivona, “Avaha Kauvea unuvovoa iepei, ineiei! Kaiwadi, eha katꞌ‑anamane aveta baina iboui!” ");
INSERT INTO mvn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Akaka Pita ka tau vi‑muni‑waiwai‑nana ainuai ini‑tawanei iomo unuvovoa. ");
INSERT INTO mvn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ka ainuai inau‑bwanunua, ka tau vi‑muni‑waiwai‑nana venau‑bagibagi, e tauna eta‑naoi unuvovona wayahina, ka Pita munina. ");
INSERT INTO mvn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ka tau vi‑muni‑waiwai‑nana unuvovona wayahina iwaodu dune‑nui, e kalekoata lineniV dueyei, kate tauna eha ta‑nu unuvovona nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ka Simoni Pita munia nau‑bwanunua, e tauna inu tunuhina unuvovona nihenina. Ka Pita kadu kaleko‑naia lineniV dueyei. ");
INSERT INTO mvn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ka aitam kaleko unununa ana iuma mamaei, ka tanoi eha mani kalekona lineniV nui, kate unununa ana iuma nunumina, ka ana heta papani tunina mamaei. ");
INSERT INTO mvn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka tau vi‑muni‑waiwai‑nana, tauna unuvovona wayahina mai‑vinꞌ‑omo, kadu unuvovona inui. Ka tauna dueyei, kadu Iesu ya mini‑havine vitumahanei. ");
INSERT INTO mvn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Iginuma ivona vivane Tau Ito‑yavuha‑nana nau‑wawani anigea mini‑havine. Kate auyewana wayahina Iesu a tau vi‑muni‑waiwai eha Iginuma ita‑nua‑hau. Munia inua‑haui.) ");
INSERT INTO mvn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ka tau vi‑muni‑waiwai ainuai imavina yai manua. ");
INSERT INTO mvn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kate Mari mavina unuvovona wayahina, e nepena mimini vi‑mohai. Tutana toutou, iwaodu, e unuvovoa dune‑nui. ");
INSERT INTO mvn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ka nihenina anelose ainua dueyei, ai kwama kavukavuna, ka ainuai Iesu a pai dauva hetana imanuena, aitam unununa, aitam aena. ");
INSERT INTO mvn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ka anelose‑naia Mari ivi‑tanaiei, ivona, “Vavinem, aviani wayahina evi‑mohai?” Ka Mari vonei, ivona, “Yau Kauvea unuvovoa iepa‑tawanei, ka yauke eha atꞌ‑anamane aveta iboui.” ");
INSERT INTO mvn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ka Mari magigino, e onoto dueyei nepena mimini, kate Mari eha tꞌ‑anamane onotona vivane Iesu. ");
INSERT INTO mvn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ka onotona Mari vi‑tanaiei, ivona, “Vavinem, aviani wayahina evi‑mohai? Koiaka enenenei?” Ka Mari nuanua tauna bagunana a tau dune‑vi‑avina. Wayahina, ivona, “Bada, aituhu wamke eneiei, akanai, aveta eboui evoneu, e anꞌ‑epa‑havinei.” ");
INSERT INTO mvn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wayahina, Iesu Mari ana wava tomani, ivona, “Mari!” Akaka Mari magigino, e me Ebereu movia wayahina ivona, “Raboni!” (Vonana me Ebereu movia anꞌ anamana “yau Tau Viwavenena”.) ");
INSERT INTO mvn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ka Iesu vonei, ivona, “Eha evo‑dadaniu, iuna ataina eha ata‑vane‑havine Amau wayahina. Apaina. Kate wamke ena‑ne vavaneiu wayahia, e ehaeyeu deina, ‘Yauke amavimavina Amau kadu Amami wayahina. Tauna yauke yau Yaubada kadu itomi yami Yaubada.’” ");
INSERT INTO mvn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Akaka Mari me Magidala ine, e tau vi‑muni‑waiwai mataedai vivane Kauvea avaha dueyei, ka tauna ya vonana wayahina kadu mataedai. ");
INSERT INTO mvn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka auyewana wayahina, vivane wiki anꞌ auyewa naona, avaha vinanavi, ka Iesu a tau vi‑muni‑waiwai habuhabui aitam manua nihenina inau‑hohona, ka awa iawa‑potei, e nihenina imamaei. Iuna taui me Iudea yai tau eta‑naonao imatamatautei. Ka Iesu omoi, e niwania mini, e wayahia ivona, “Yau nuanua nua gomagomanina uvaniahei!” ");
INSERT INTO mvn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ka vonana iakwa, e tauna nimana kadu baimina viwavenei idueyei. Wayahina, a tau vi‑muni‑waiwai idewa‑haiawa‑iaua, iuna taui yai Kauvea idudueyei. ");
INSERT INTO mvn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ka Iesu vona‑havinei, ivona, “Yau nuanua nua gomagomanina uvaniahei! Nonova Amau vi‑tuneu, ka ataina yauke avi‑tunemi deina.” ");
INSERT INTO mvn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ka vonana iakwa, e tauna yawaina vene‑tamani‑neiei, kadu wayahia ivona, “Nuana Ahihinata unꞌ‑awaehei uvaniahei. ");
INSERT INTO mvn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aituhu itomi tomotau yai dewa goyona unua‑piahi, akanai Yaubada kadu yai dewa goyona na‑nua‑piahi aitamoata deina. Ka aituhu eha unua‑piahi, akanai, ai dewa‑yaiyai dewaia goyona wayahi potepotei.” ");
INSERT INTO mvn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ka Tomasi, tauna aitam tau vi‑muni‑waiwai ai yau 12 wayahia, ka taui ivi‑wahani DidimusiV. Ka tutana Iesu omo wayahia, Tomasi eha yaiana nui. ");
INSERT INTO mvn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ka munia, yaiana imataedei, ivona, “Yaka Kauvea avaha adune‑havinei!” Kate Tomasi vonei, ivona, “Aituhu au pata yauke nimana a gonia adueyei, ka kadu aituhu au pata goniana avo‑dadani nima‑tabou wayahina, ka kadu aituhu au pata nimau tauna baimina a gonia nihenina aboui, akanai, avitumahanemi. Kate aituhu eha au pata dewaia adewe, eha au pata avitumahanemi.” ");
INSERT INTO mvn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka kadu aitam wiki iakwa, e tau vi‑muni‑waiwai habuhabui manuana nihenina inau‑hohona‑havine, ka kadu Tomasi nui. Ka taui avaha awa iawa‑potei, kate Iesu omo, e niwania mini, e wayahia ivona, “Yau nuanua nua gomagomanina uvaniahei!” ");
INSERT INTO mvn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","E tauna Tomasi vonei, ivona, “Baina nima‑tabom wayahina evo‑dadaniu, kadu nimau edueyei. Ka kadu nimam etunei, e baimiua eboui. Yam va‑hamwahamwana ebou‑ohoi, ka evitumahaneu!” ");
INSERT INTO mvn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ka Tomasi vona‑nau‑patei, ivona, “Taum yau Kauvea kadu yau Yaubada.” ");
INSERT INTO mvn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wayahina, Iesu vonei, ivona, “Tomasi, wamke avaha edueyeu, akanai, ataina evitumahaneu, a? Ka apaina, aituhu aviyaivia eha ita‑dueyeu, kate aituhu taui ai pata ivitumahaneu, akanai, nau‑iaiava ivaniahei. Ka nau‑iaiavana nau‑iaiavana evaniahei vane‑tawanei.” ");
INSERT INTO mvn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu mani dewa‑bagibagi‑vainei habuhabui vevewanei a tau vi‑muni‑waiwai mataia. Ka yauke eha dewaia habuhabui ata‑ginumi buki taina nihenina. ");
INSERT INTO mvn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dewa‑bagibagi‑vainei aitonuata wayahi aginumi buki taini nihenina akanai. Ka itomi ami pata dewaia tanoi una‑iaiavi, uvitumahanei Iesu vivane Tau Ito‑yavuha‑nana, ka kadu uvitumahanei tauna vivane Yaubada Natu‑hoina. Ka yami vitumahana wayahina ami pata yawai‑vavaha uvaniahei Iesu a wavea. ");
INSERT INTO mvn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ka aitam tuta munia, Iesu tauna si‑vinꞌ‑omanei, e a tau vi‑muni‑waiwai idune‑havinei. Ka dewana Navu Tiberiasi wayahina vinꞌ‑omo taina deina. ");
INSERT INTO mvn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tauna a tau vi‑muni‑waiwai tupwai imamaei, taui ai yau 7, vivane Simoni Pita, ka Tomasi (tauna ivi‑wahani DidimusiV), ka Natanaela (tauna ya meagai Kana, aina Galili a papani nihenina), ka Sebedi natunatuna ainua, ka kadu mani tau vi‑muni‑waiwai ainua nui. ");
INSERT INTO mvn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ka Simoni Pita yaiana wayahia ivona, “Yaiau, yauke aneine, anau‑mwaneha.” Ka yaiana ivona, “O, ahiahina, kana‑ne.” Wayahina, habuhabui waea igenu, ivi‑ata, ka ioyomana a itoava mana navi wayahina inau‑mwaneha, kate eha aitam iana. ");
INSERT INTO mvn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ka tutana babau vanevane, taui aitam onoto idueyei, tauna tania mimini, kate eha itꞌ‑anamane tauna Iesu. ");
INSERT INTO mvn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ka Iesu wayahia vi‑tanai, ivona, “Yaiau, iana o eha?” Ka taui ivona‑nau‑patei, ivona, “Eha aitam.” ");
INSERT INTO mvn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ka tauna wayahia ivona, “Agida unꞌ‑onei, uboui wae ateina, akanai iana.” Ka ya vonana deina, agida ionei, iboui, ka eha ai pata ina‑taini wae nihenina, iuna iana habu‑vainena inau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ka tau vi‑muni‑waiwai‑nana (Iesu tauna dune‑nuanuaiei ananina) Pita vonei, ivona, “Tauna yaka Kauvea!” Ka Simoni Pita, avaha nononi vivane Kauvea, ana kwama weteni (iuna inininata nau‑mwaneha), ni‑ubau iopu navua, e itube tania. ");
INSERT INTO mvn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ka tau vi‑muni‑waiwai habuhabui ivoivoi, ka agida iana nau‑vi‑anai iyohona‑potei, e wae munina itaitaini. Ka taui ivinꞌ‑omo deina, iuna tania eha bana mamanaina, kadi ai yau 100 mitaV deina. ");
INSERT INTO mvn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ka tutana tau vi‑muni‑waiwai iduduna, e magama wayahina kwauto ana ganiana idueyei, ka iana avaha ananai, ka palaua nui. ");
INSERT INTO mvn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ka Iesu wayahia ivona, “Tupwai kadu ami iana ataina unau‑agidai uomanei.” ");
INSERT INTO mvn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Wayahina, Simoni Pita waea igenu, e agidana taini, tania vaneyei. Ka iana anani agidana inau‑vi‑anai, ka ai yau vivane 153. Vona ahiahina, iana habuhabui kadu anani, kate agidana eha tꞌ‑am‑yehia. ");
INSERT INTO mvn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ka Iesu wayahia ivona, “Unꞌ‑omoi, ami awahita unꞌ‑am.” Ka eha aitam wayahia yai ate‑vatu nui, wayahina eha aitam ta‑vi‑tanaie, “Taum koiaka?” Iuna aitamoata aitamoata wayahia avaha ianamanei tauna vivane yai Kauvea. ");
INSERT INTO mvn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ka Iesu omo, e palaua epei, venei, kadu iana deina. ");
INSERT INTO mvn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ka tuta‑nana vivane tuta vꞌ‑itonuna ya mini‑havine munina, e Iesu tauna si‑vinꞌ‑omanei, e a tau vi‑muni‑waiwai idudueyei. ");
INSERT INTO mvn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ka taui avaha ai awahita iam iakwa, Iesu Simoni Pita vi‑tanaiei, ivona, “Simoni, wamke Ioni natuna, medeina? Wamke yam dune‑nuanuai wayahiu taui taina yai dune‑nuanuai wayahiu vane‑tawanei?” Ka Pita vona‑nau‑patei, ivona, “Kauvea, ika, avaha eanamaneu adune‑nuanuaiem.” Wayahina, Iesu vonei, ivona, “Nau‑wawanim yau lamiV evi‑am‑neiei.” ");
INSERT INTO mvn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ka Iesu tuta vꞌ‑inuana vi‑tanaiei, ivona, “Simoni, wamke Ioni natuna, edune‑nuanuaieu ananina?” Ka Pita vona‑nau‑patei, ivona, “Kauvea, ika, avaha eanamaneu vivane adune‑nuanuaiem.” Wayahina Iesu vonei, ivona, “Nau‑wawanim yau sipiV edune‑vi‑avini.” ");
INSERT INTO mvn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ka Iesu tuta vꞌ‑itonuna vi‑tanaiei, ivona, “Simoni, wamke Ioni natuna, edune‑nuanuaieu?” Akaka Pita nua‑vita ananina, iuna Iesu tuta vꞌ‑itonuna wayahina vi‑tanaiei, ivona, “Edune‑nuanuaieu?” Wayahina Pita ivona, “Kauvea, wamke avaha nua‑uya habuhabuna enau‑yehai. Avaha eanamaneu adune‑nuanuaiem!” Wayahina, Iesu Pita vonei, ivona, “Nau‑wawanim yau sipiV evi‑am‑neiei. ");
INSERT INTO mvn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Memeanina nuam vi‑tupatupa, kate avonem taina deina. Yam tuta tevana wayahina a itoava tuta ataina wayahina, wamke am kwama eweteweteni, ka avi meagai wayahina yam nuanua, akanai eneine. Kate apaina, yam tuta evi‑nainai wayahina, wamke nimam etunei, ka mani tomotau iyohonim, ka aitam meagai mamaei, ka eha yam nuanua tenoke ena‑ne, kate meagaina wayahina ineiem.” ");
INSERT INTO mvn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iesu ya vonana wayahina Pita yanꞌ aniga apa‑taputapuei, kadu medeina yanꞌ aniga Yaubada didigana vo‑vi‑natei.) Ka Iesu kadu Pita wayahina ivona, “Akanai, evi‑muni‑waiwaieu!” ");
INSERT INTO mvn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ka Pita magigino, ka tauna tau vi‑muni‑waiwai‑nana (Iesu tauna dune‑nuanuaiei ananina) dueyei. (Tauna kadu Itouvuha Toneina wayahina Iesu numanumana wayahina ino‑vinavina, kadu vi‑tanaiei, “Kauvea, koiaka vi‑nua‑hauhauem?”) ");
INSERT INTO mvn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ka Pita, avaha onoto‑nana dueyei, vi‑tanaiei, ivona, “Kauvea, onoto taina medeina?” ");
INSERT INTO mvn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ka Iesu Pita ya vonana vona‑nau‑patei, ivona, “Tuta ataina a itoava yau mavina ana tuta wayahina, aituhu yauke yau nuanua tauna mamaei, dewana eha aitam aviani wamke wayahima. Tauna eha yam tau paisewa, kadu wamke eha tauna eveimeye. Wamke nau‑wawanim evi‑muni‑waiwaieu akanai!” ");
INSERT INTO mvn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ka Iesu a tau vi‑muni‑waiwai tauna ya vonana inononi. Wayahina, taui ivi‑putu imabonu vivane eha ana pata tau vi‑muni‑waiwai‑nana nꞌ‑aniga. Kate Iesu eha ta‑vona deinake. Iesu ya vonana vivane, “Tuta ataina a itoava yau mavina ana tuta wayahina, aituhu yauke yau nuanua tauna mamaei, dewana eha aitam aviani wamke wayahima.” ");
INSERT INTO mvn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ka tau vi‑muni‑waiwai‑nana vivane yauke, Ioni. Ka yauke dewaia habuhabui ahaehaeyei, ka kadu yauke aginuginumi buki taina nihenina. Ka itoai habuhabuai avaha anamanei yauke yau hae habuhabuna vivane tunutunuhina. ");
INSERT INTO mvn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Akanai, Iesu yana dewa habu‑vainei imamaei, ka aituhu yana dewa aitamoata aitamoata aginumi, kaiwadi, tanopi taina habuhabuna kikituna, ka eha ana pata buki‑naia habuhabui imamae nihenina. Ana pata deina. Yauke Ioni ");
INSERT INTO mvn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Bada Teopilusi, nonova buki naona aginumi, ka buki‑nana nihenina Iesu yana dewa habuhabuna kadu ya viwavenena habuhabuna amataedam. Ka buki‑nana nihenina avi‑putu Iesu ya paisewa naona wayahina, e anau‑viviwavem a itoava tauna ivane wahuma wayahina. Tutana Iesu tanopia mamaei, tauna a tau hae vi‑nua‑dadane‑neiei, ka Yaubada Nuana ivaitei tauna a tau hae ai veimea venei. ");
INSERT INTO mvn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Naona tauna ana inahe vaniahei, ka munia mini‑havine anigea. Ka auyewa ai yau 40 nihenia tauna a tau hae viwavenei vivane tauna yawayawaina. Ka kadu vinꞌ‑omo‑nananena wayahia, e ai pai ainana habuhabui vevewanei idudueyei. Wayahina, taui ya mini‑havine iawa‑vidovidohei, ka eha ai pata iva‑hamwahamwana wayahina. Kadu tauna Yaubada ya pai veimea vo‑vi‑mahetei, inua‑haui. ");
INSERT INTO mvn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ka aitam tuta, avaha mini‑havine, tauna taui nui imamaei kadu iamam, ka ai veimea venei, ivona, “Eha Ierusalem uni‑tawane, kate nau‑wawanimi Amaka ya vona‑dabadaba upotepotei. Nonova vona‑dabadaba‑nana amataedami. ");
INSERT INTO mvn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ka unuani. Nonova Ioni Tau Bapitaiso tomotau daudaua vi‑bapitaiso‑neiei. Ka avonemi, auyewa eha habuhabuna ina‑iakwa wayahina, Yaubada vi‑bapitaisoemi Nuana Ahihinata wayahina.” ");
INSERT INTO mvn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wayahina munia, avaha inau‑hohona, taui ya vonana inononi ivi‑putu ivi‑tanatanaiei, ivona, “Kauvea, medeina? Memeanina tuta ataina wamke itoka me Isiraeli eta‑naoeka, e matatauka evi‑kiniV, tuta nonova yaka kiniV deina?” ");
INSERT INTO mvn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ka Iesu ivona, “Amau ana heta dewaia vi‑nua‑dadani, ka kadu tauna ai tuta ka ai ponimana veimeyei. Ka eha nau‑wawanimi tuta‑naia o kadi ponimanaia unꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ka apaina Nuana Ahihinata na‑omo wayahimia, ka tauna vo‑vi‑bagibagimi, e uvi‑tau hae wayahiu meagai Ierusalem nihenina, ka papani Iudea nihenina, ka papani Samaria nihenina, ka kadu meagai habuhabui nihenia, ka kadue tanopi habuhabuna nihenina.” ");
INSERT INTO mvn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ka Iesu, avaha ya vonana nau‑yehai, ivane wahuma, ka tau hae‑naia mataia Iesu idudueyei, e you nihenina maiova. ");
INSERT INTO mvn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iesu avaha ni‑tawanei, ka apaina taui idunedune wahuma. Ka onoto ainua ai kwama kavukavui nepeia imini, ");
INSERT INTO mvn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","e ivona, “Me Galili, aviani wayahina umimini udunedune wahuma? Yaubada avaha Iesu taini ivane wahuma, ka apaina tauna na‑mavi‑havine. Ka kadu apaina ya opu‑mena ana dune ataina yana vane avaha udueyei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wayahina, Oya Olive ini‑tawanei, imavina iomoi Ierusalem. Ka tanoi eha bana, me Iudea ai veimea awaehei ini‑awana auyewa tapanono wayahina, kadi kilomitaV aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ka avaha Ierusalem ivaniahei, taui aitam manua inui, taui yai dewa deina, e ivane aitam bubuna‑honota manua hetana mamaei wayahina. Taui vivane Pita, ka Ioni, ka Ioni vaneina Iamesa, ka Aniduru, ka Pilipi, ka Tomasi, ka Baritolomeu, ka Mateu, kadu mani Iamesa (tauna Alipaeusi natuna), ka Simoni (tauna manimaninina, ka me Rom yai veimea vihahaiei), ka Iudasa (tauna mani Iamesa natuna). ");
INSERT INTO mvn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ka taui habuhabui iawaehei tuta tuta nui iviama Yaubada wayahina. Ka vaivine tupwai nui, ka kadu Iesu ayona Mari nui, ka kadue Iesu vavaneina nui iviama. ");
INSERT INTO mvn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ka Iesu avaha ivane wahuma, ka auyewa tupwai iakwa, a tau vi‑muni‑waiwai inau‑hohona, ka yokoia ai yau kadi 120 deina. Ka Pita niwania mini, e vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Vavaneiu kadu novunovu, nonova Davida yana vona vinꞌ‑omo Nuana Ahihinata wayahina, e tauna apa‑taputapu Iudasa me Kariota wayahina. Ka apa‑taputapu‑nana Iginuma nihenina mamaei kaiaiavi. Nonova Iudasa‑nana nui avi‑tau hae ananiai Iesu wayahina, kate tauna yaka Kauvea vi‑nua‑hauhauei, e am‑veneneyei a havia nimaia. ");
INSERT INTO mvn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ka dewa goyo‑nana wayahina Iudasa patana vaniahei, ka kinana wayahina aitam tanopi vi‑maiei, e tanoi ipeu, e madina tupa‑yehia, ka amoamona habuhabuna vinꞌ‑omo, inusi. ");
INSERT INTO mvn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ka ipuipupuna me Ierusalem habuhabui inononi. Ka movia tano‑nana ivi‑wahani AkelidamaV, ka anꞌ anamana ‘Tanopi Dayaha.’) ");
INSERT INTO mvn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ka Buki Sam nihenina ipupu kavaniahei Iudasa wayahina, ka ipupuna ivona, ‘Ya meagai iakwa, ka eha aitam koiaka ta‑mamae nihenina akanai.’ Ka kadu aitam ivona, ‘Kadu aitam tomotau nau‑wawani tauna ya paisewa nꞌ‑epei.’ ");
INSERT INTO mvn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yaiau, Yaubada movina apa‑taputapu deina, ka Iudasa yanꞌ aniga avaha vinꞌ‑omo. Wayahina, ataina itoka nau‑wawanika Iudasa‑nana a tau nau‑seana kavi‑nua‑dadanei. Ka a tau nau‑seana nau‑wawani itoai tau hae nui anaunau‑wahe Iesu yana tuta tanopia wayahina. Naona, tutana Ioni Tau Bapitaiso Iesu vi‑bapitaisoei, itoai avi‑putu Iesu nui ani‑keyekeyeai. Ka avi‑muni‑waiwaiei deina a itoava auyewa pai nau‑yehata tauna ni‑tawaneai wayahina. Ka Iudasa a tau nau‑seana nau‑wawani aitam tau vi‑muni‑waiwai wayahikaia tuta naona a itoava tuta pai nau‑yehata wayahina deina.” ");
INSERT INTO mvn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wayahina, Iesu a tau hae ai yau 11 onoto ainua ai wava isi‑nai. Aitam Iosepa tauna ivi‑wahani Barisabasi, tauna kadu ivi‑wahani Iusitusi, ka vꞌ‑inuana onoto ana wava Matiasi. ");
INSERT INTO mvn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","E iviama Yaubada wayahina, ivona, “Kauvea, wamke avaha tomotau habuhabuai yama nuanua eanamane‑yehai. Wayahina, yam vi‑nua‑dadana onoto ainua tainake wayahia eviwaveneai anꞌ‑anamanei. ");
INSERT INTO mvn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","E munia onoto‑nana Iudasa na‑nau‑seani, ka kadu tauna vi‑tau hae, ka paipaisewa Iesu wayahina. Iuna Iudasa paisewana venau‑tawanei, ka inei papanina, ka patana ya goyona wayahina vaniahei.” ");
INSERT INTO mvn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ka avaha iviama deina, e onoto ainuai ai wava iginumi hanu kikitui ainua wayahia, e hanu‑naia waga nihenina iboui, e ito‑iwaha. Ka Matiasi ana wava eta‑naoi. Wayahina, tauna inu Iesu a tau hae ai yau 11 nihenina, e tauna kadu yai paisewa epei. ");
INSERT INTO mvn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","2","Ka munia, vi‑aniani ana wava PenitekosiV anꞌ auyewa vinꞌ‑omo. Wayahina, Iesu a tau vitumahana habuhabui inau‑hohona aitam manua nihenina, e imanuena. Ka vo‑kwayavonina aitam duduna inononi wahuma wayahina, wedinia deina. Ka yahina ananina putuna manuana nau‑vi‑anai. ");
INSERT INTO mvn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ka aitam amane idueyei ana dune ai yabeyabena deina, Ka ai‑nana tana‑vewani, e omo aitamoata aitamoata wayahia, e ununuia itoha. ");
INSERT INTO mvn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ka Nuana Ahihinata habuhabui nau‑vi‑anai deina. Ka tau hae‑naia ivi‑putu ipuipupu movi tunina tunina wayahia. Iuna Nuana Ahihinata ivaitei idedewei deina. ");
INSERT INTO mvn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ka tuta‑nana wayahina tau tapanono mani papani wayahia avaha iomo Ierusalem wayahina, e imamaei. Taui me Iudea yai tapanono idewa‑didigunei, kate yai tupua papani tunina tunina nihenina. ");
INSERT INTO mvn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ka taui, tutana dudunana inononi, ivo‑kwayavoni inau‑hohona. Ka tau hae‑naia wayahia ivanevaneneha, ka aitamoata aitamoata wayahia movia inononi. Wayahina, nuai vi‑tupatupa ananina. ");
INSERT INTO mvn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ka taui yaui inovo kadu nuai vi‑tupatupa‑vaine, wayahina ivi‑vonavona, “Ia! Medeina idedewei? Tau vonaia habuhabui taina me Galili, ika? ");
INSERT INTO mvn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kaiwadi, medeina taui ai pata habuhabuka movikaia ipuipupu? ");
INSERT INTO mvn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Itoka yaka papani vivane Paritia, ka Media, ka Elam, ka Mesopotamia, ka Iudea, ka Kapadosia, ka Ponitusi, ka Asia, ");
INSERT INTO mvn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ka Pirigia, ka Pampilia, ka Egipita, ka papani Libia papani Sirene awaniana, ka kadu tupwaka baina vivane tau bwanibwani meagai Rom wayahina, ka tupwaka dede Iudea tunuhina, ka kadu tupwaka dede tunina kate me Isiraeli yai tapanono kavi‑muniei, ");
INSERT INTO mvn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ka kadu tupwaka me Kirete, ka tupwaka me Arabia. Kate habuhabuka movikaia tunina tunina kanonononi. Ka taui Yaubada ya dewa‑bagibagi wayahina ihaehaeyeka.” ");
INSERT INTO mvn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wayahina, tomotaui nuai vi‑tupatupa, eha ta‑vidoha, kadue yai nuanua venau‑tamatamana. Ka matataui ivonavona, “Dewa taina anꞌ anamana medeina?” ");
INSERT INTO mvn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ka mani tomotau tau hae‑naia ivi‑waipoei, ivona, “Taui daudau bagibagina inim‑iaua, ka avaha ivi‑kwavakwava.” ");
INSERT INTO mvn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ka Pita yaiana ai yau 11 nui imimini, ka tauna movina ananina vi‑putu nau‑wahe yokoia wayahia, ivona, “Itomi me Iudea kadu Ierusalem a tau maꞌ habuhabumi, yau vona unononi, avo‑vi‑mahetemi. ");
INSERT INTO mvn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Itomi unuanua yama dewana vinꞌ‑omo daudau bagibagina wayahina, kate eha. Iuna ataina mana‑putu niwanina eha nim vi‑kwavakwava ana tuta. ");
INSERT INTO mvn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kate nonova tau apa‑taputapu ana wava Ioela dewana mai‑haeyei. Ka ataina dewana vinꞌ‑omo Yaubada yana hae aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Iginumana ivona deina, ‘Yaubada ivona, “Apaina, tuta a pai nau‑yehata wayahina, yauke Nuau ana‑ito‑iwahi tomotau habuhabui wayahia. Ka natunatumi ononotoi kadu vaivinei inꞌ‑apa‑taputapu, ka yami tupunata ina‑ino‑dunedune, ka ononotoi ivi‑nainai yai ava inꞌ‑epei. ");
INSERT INTO mvn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Vona ahiahina, tuta tanoi wayahina Nuau ana‑ito‑iwahi yau tau paisewa ononotoi ka vaivinei wayahia, e taui wayahiu inꞌ‑apa‑taputapu. ");
INSERT INTO mvn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Apaina iaiaya avevewanei wahuma, ka tomotaui idudueyei nuai vi‑tupatupa wayahina. Vivane babau vi‑novanovana, ka wahava ana dune yabebenina, vi‑dayaha deina. Ka kadue iaiaya avevewanei tanopia, dayaha deina, ka ai ananata, ka kadu bawa badobadona. Ka iaiaya‑naia ina‑iakwa, munia Kauvea yanꞌ auyewa vinꞌ‑omo. Ka auyewana vivane pai matauta ananina tau maꞌ tanopi wayahi. Ka Kauvea tauna didigana na‑si‑vinꞌ‑omanei, e tomotau habuhabui idudueyei. ");
INSERT INTO mvn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ka aituhu aviyaivia Kauvea ivitumahanei, ka aituhu taui tauna ana wava ivivi‑hone, akanai taui ito‑yavuha ivaniahei akanai.” ’ ");
INSERT INTO mvn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Me Isiraeli, itomi vonana Iesu onoto Nasareta wayahina unononi. Yaubada avaha onotona apa‑vidovidohei. Ka Yaubada tauna awaehei dewa‑bagibagina kadu iaiaya ananina dedewei matamia. Ka kadu Yaubada avaha Iesu‑nana ana wava si‑nai deina, ka viwavenemi, udueyei, ka avaha uanamane‑yehai. ");
INSERT INTO mvn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nonova Yaubada avaha anamanei medeina Iesu yanꞌ aniga vinꞌ‑omo. Wayahina, Yaubada awaehei aitam onoto Iesu‑nana vi‑nua‑hauhauei, am‑veneneyemi. Ka Yaubada kadu mai‑anamanei tau goyogoyoi ina‑ivaitemi ai nahenahea Iesu‑nana ututu‑pwatei, unau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Itomi uvunui deina, kate nonova Yaubada avaha apa‑taputapu vivane Iesu‑nana eha nau‑wawani na‑maꞌ‑vavaha aniga ya papani wayahina. Wayahina, Yaubada aniga ya papani wayahina ito‑yavuhi, ka si‑vi‑mini‑havinei. ");
INSERT INTO mvn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Apa‑taputapu‑nana kavaniahei Davida ya iginuma nihenina, ivona, ‘Yauke avaha adueyei Kauvea mataua maꞌ‑vavaha. Ka tauna ateiua mamaei, ka vo‑vi‑bagibagiu. Wayahina, eha ava‑hamwahamwana. ");
INSERT INTO mvn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wayahina, nuau dewa‑haiawa kadu meau awa‑davedavem ananina. Ka ataina ininiu mamaei, ka nua‑vaniaha nui apotapotam. ");
INSERT INTO mvn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Iuna eha nuau ebou‑vavahi tau anianiga yai papani HadesiV nihenina. Ka eha eawaeha Yam Onoto Ahihinata na‑mavunu. ");
INSERT INTO mvn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ka avaha yawai ahiahina a etawana eviwaveneu anua‑haui, kadu dewa‑haiawa wayahina evi‑nau‑vi‑anaiu matama.’” ");
INSERT INTO mvn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ka Pita kadu ivona, “Vavaneiu, vona tunutunuhina avonemi, Davida ya vonaia ai anamana eha waka Davida wayahina. Iuna Davida‑nana kanamanei nonova inusi, e iboui unuvovoa. Ka tuta ataina a unuvovo‑nana meagai taina nihenina mamaei. ");
INSERT INTO mvn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ka Davida‑nana aitam tau apa‑taputapu, kadu tauna avaha anamanei Yaubada tauna ya vona‑dabadaba wayahina vonei apaina aitam Davida ya tupua‑nenenehi wayahia ya pai veimea veimeyei. ");
INSERT INTO mvn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ka Davida Tau Ito‑yavuha ya mini‑havine mai‑anamanei, e apa‑taputapu dewana wayahina. Wayahina, Davida ginumi, e Yaubada eha Tau Ito‑yavuha‑nana ininina bou‑vavahi tau anianiga yai papani HadesiV nihenina, kadu ginumi, e ininina eha na‑mavunu. ");
INSERT INTO mvn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yauke aipuipupu Iesu‑nana wayahina. Yaubada avaha tauna anigea si‑vi‑mini‑havinei, ka dewana munia itoai habuhabuai adudueyei. ");
INSERT INTO mvn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wayahina, Yaubada bou‑vaneyei, ka tuta ataina tauna Yaubada ateina mamaei. Ka kadu Yaubada tauna Nuana Ahihinata venei, nonova vona‑dabedabeyei deina, ka tuta ataina tauna avaha Nuana Ahihinata ito‑iwahi wayahiaia. Ka ipupu taina movi tunina tunina ududueyei ka unononi vinꞌ‑omo Nuana Ahihinata wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yau vonana tunutunuhina. Iuna Davida eha ta‑vane wahuma, kate Davida ivona deina, ‘Yaubada avaha yau Kauvea vonei, ivona, “Ateiua emanuena, emamaei ");
INSERT INTO mvn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","a itoava am havia avi‑opuei wayahina, aem a pai vi‑ai wayahina abouni, eveimeyei.” ’ ");
INSERT INTO mvn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Wayahina, me Isiraeli habuhabumi nau‑wawanimi unꞌ‑anamanei ahiahina, Iesu‑nana ututu‑vi‑nahenahei. Kate Yaubada avaha Iesu‑nana ana wava si‑nai vivane yaka Kauvea kadue yaka Tau Ito‑yavuha.” ");
INSERT INTO mvn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ka tomotaui, avaha Pita ya nau‑wahena inononi, iaini‑yauyau ananina, kadu nuai vi‑tupatupa. Wayahina, taui Pita yaiana nui wayahia ivi‑tanai, ivona, “Vavaneiai, avaha dewa goyona adewei. Avi dewa nau‑wawaniai adewa‑vidoha?” ");
INSERT INTO mvn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wayahina, Pita ivona, “Vavaneiai, aituhu yami dewa goyona wayahia unua‑vinana, e habuhabumi Iesu Tau Ito‑yavuha a wavea avi‑bapitaisoemi. Ka Yaubada yami dewa goyona na‑nua‑tavuni, e Nuana Ahihinata uvaniahei, vivane am‑venena‑kavovo Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Iuna Yaubada ya vona‑dabadaba‑nana Nuana Ahihinata wayahina vivane itomi wayahimi, ka kadu natunatumi wayahi, ka kadu taui imamaei bana mamanaina Yaubada wayahina wayahi, ka kadu tomotau habuhabui wayahi. Aituhu aviyaivia Yaubada honei iomo tauna wayahina, akanai taui wayahi.” ");
INSERT INTO mvn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ka Pita ya vonana eha ta‑iakwa, kate tauna naunau‑wahe vi‑manamanaia wayahia, ka haehaeyei kadu viamei, ivona, “Yaiau, tuta ataina nau‑wawanimi tomotau goyona wayahia una‑ito‑yavuhimi, iuna tomotaui tuta ataina imamaei yai dewa vivane mavununa.” ");
INSERT INTO mvn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Akaka auyewa‑nana wayahina tomotau ai yau 3000 Pita ya nau‑wahena inononi, iawaehei, bapitaiso ivaniahei, ka kadu taui ivi‑tau ekalesia. ");
INSERT INTO mvn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ka tuta tuta taui tau hae‑naia yai viwavenena inonononi, iawaehei, kadu mani tau ekalesia ivi‑yaianei ahiahina. Ka habuhabui nui palaua ipakepakeua iamam pai nuana Iesu wayahina, kadue yai viama Yaubada wayahina iawaehei aitamoata. ");
INSERT INTO mvn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ka tau ekalesia habuhabui nuai vi‑tupatupa. Iuna Yaubada tau hae‑naia awaehei taui dewa‑bagibagi habuhabui kadu iaiaya habuhabui idedewei. ");
INSERT INTO mvn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ka tau vitumahana imamaei yoko, ka inuanua aitamoata. Wayahina, yai gugua iawaehei vivane tomotau habuhabui yai gugua, ka ivo‑patai deina. ");
INSERT INTO mvn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ka aituhu tupwai wayahia payapayaya, akanai yaiai tupwai yai tanopi o kadi yai gugua iaimwaneyei, e patana ivenevenei tau payapayaya ividoha deina. ");
INSERT INTO mvn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wayahina, auyewa aitamoata aitamoata wayahia taui nui itapanono Manua Vito‑pota a pai nau‑hohona nihenia. Ka kadu taui yai manua nihenia palaua ipakepakeua iamam pai nuana Iesu wayahina, ka kadu yai dewa‑haiawa nui kadu yai nua‑opu nui inau‑hohona, e ai maꞌ iamam. ");
INSERT INTO mvn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ka tuta tuta Yaubada iawa‑davedavei. Ka yoko habuhabui tau vitumahana‑naia yai dewa iawa‑vidovidohei. Ka auyewa aitamoata aitamoata wayahia tupwai tomotau ito‑yavuha ivaniahei. Ka Kauvea tomotaui tau ekalesia ai yau wayahina vi‑nuia, ka ekalesia ai yoko natanata deina. ");
INSERT INTO mvn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ka aitam tuta Pita ka Ioni ainua ivanevane Manua Vito‑pota wayahina, e iviama. Iuna viama ana tuta avaha omo, vivane auyewa pouna ka vinanavi niwanina. ");
INSERT INTO mvn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ka Manua Vito‑pota‑nana anꞌ awa aitam ivi‑wahani Ahihi‑vainena. Ka babau‑nana wayahina aitam tau penapena yaiana tupwai iavavanei, e awa‑nana inuinu. Ka tau penapenana yana tuta tupua wayahina vi‑penapena. Wayahina, auyewa aitamoata aitamoata wayahia yaiana iomaomanei awa‑nana wayahina, e nepena iboui mamaei. Ka am‑venena‑kavovo hidehidei Manua Vito‑pota a tau totoha wayahia. ");
INSERT INTO mvn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ka tau penapenana Pita ka Ioni dueyei eha ani‑hoina inuinu, akaka toea viamei. ");
INSERT INTO mvn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Akaka Pita ka Ioni ainua matai ine, e idudueyei, ka Pita ivona, “Tauai edueyeai!” ");
INSERT INTO mvn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wayahina, tau penapenana dueyei, ka tauna ya nua‑vaniaha nui potapota, e apaina toea ivene. ");
INSERT INTO mvn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ka Pita ivona, “Wayahiua eha kina silivaV, ka eha kina goulaV. Ka aviani wayahiua mamaei awawaehina avenem. Iesu Tau Ito‑yavuha, onoto Nasareta, tauna a wavea avonem, emini ka eni‑awana.” ");
INSERT INTO mvn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ka Pita onotona nimana ateina vo‑vi‑avini, e onotona si‑nai. Ka onotona aena kadu ae‑tutuna ibagibagi, ");
INSERT INTO mvn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","e vo‑kwayavoni ni‑ubau ka mini, e vi‑putu ni‑awana. Wayahina, tauna taui nui inu Manua Vito‑pota nihenina, ka onoto‑nana ni‑awana, ni‑ubaubau, ka awa‑davadava Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ka tomotaui habuhabui Manua Vito‑pota nihenina tau penapenana idudueyei venavenau kadu awa‑davadava Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ka taui ianamanei vivane tau penapenana nonova Manua Vito‑pota anꞌ awa ana wava Ahihi‑vainena nepena mamaei ka hidahida. Wayahina, taui nuai vi‑tupatupa ani‑vainena, kadu yai nuanua venau‑tamatamana ya vidoha wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ka tau penapenana Pita ka Ioni si‑vo‑tani Manua Vito‑pota nihenina, ka yokoia yai nua‑tupatupa nui inau‑bwanunua iomo wayahia aitam tutu‑honota nihenina. Papani tanoi ivi‑wahani Solomoni Ya Tutu‑honota. ");
INSERT INTO mvn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ka tutana Pita dewana dueyei, e yokoia vonei, ivona, “Yaiau, me Isiraeli, aviani wayahina unua‑tupatupa? Ka medeina ududueyeai? Itoai eha onoto taina ata‑vo‑vi‑aiaie vivane venavenau itoai yama bagibagi wayahina, o itoai yama dewa ahiahina wayahina. Eha‑ohota. ");
INSERT INTO mvn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Unononi. Yaubada ya bagibagi vo‑vi‑aiaiei. Yaubada vivane Abaraham, ka Isaki, ka Iakobo yai Yaubada, ka kadu yaka tupua‑nenenehi yai Yaubada. Ka Yaubadana avaha ya Tau Paisewa Iesu didigana vo‑vi‑natei. Nonova itomi uam‑veneneyei iuna yami nuanua una‑nau‑vi‑anigi. Ka Pilate matana uapa‑goyogoyoei, kate Pilate ya nuanua na‑ito‑yavuhi, ka avaha vi‑nua‑dadani na‑dewe deina. ");
INSERT INTO mvn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Vona ahiahina, Iesu vivane Tau Ahihinata kadu Tau Tunutunuhina, kate itomi uvihahaiei, ka yami nuanua tomotau ai tau nau‑vi‑aniga aitam. Wayahina, Pilate uviamei tauna tau nau‑vi‑aniga‑nana na‑yavuhi wayahimia. ");
INSERT INTO mvn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ka tauna yawai a tau vevewana unau‑vi‑anigi deina. Kate Yaubada tauna anigea si‑vi‑mini‑havinei, ka habuhabuai avaha adueyei. ");
INSERT INTO mvn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tau penapena taina bagibagi vaniahei vitumahana Iesu‑nana a wavea wayahina. Ka onoto taina ududueyei kadu tauna uanamanei. Vona ahiahina, Iesu ana wava kadu vitumahana tauna wayahina onoto taina vo‑vi‑aiaiei. Ka itomi ami pata udueyei, tauna avaha vidoha ahiahina ka bagibagina. ");
INSERT INTO mvn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Vavaneiu, avaha anamanemi nonova itomi mwagemwagemi ka Iesu unau‑vi‑anigi, ka kadu ami tau veimea mwagemwagei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ka unuani, Yaubada tauna ya tau apa‑taputapu habuhabui mai‑haeyei vivane Tau Ito‑yavuha‑nana nau‑wawani ana inahe vaniahei. Nonova tau apa‑taputapu‑naia iginumi deina, ka tuta ataina dewaia avaha ivinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wayahina, itomi nau‑wawanimi unua‑vinana. Ka aituhu unua‑vinana, Yaubada yami goyona nꞌ‑epa‑yavunei, kadu ami nau‑dadana ahiahina uvaniahei Kauvea wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ka munia, Yaubada Tau Ito‑yavuha‑nana vi‑tunei na‑mavi‑havinei wayahimia. Tuta nonova Yaubada Iesu mai‑vi‑nua‑dadanei, e tauna ana heta vivane yami Tau Ito‑yavuha. ");
INSERT INTO mvn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tauna avaha ivane wahuma, ka tuta ataina nau‑wawani tanoi mamaei potapota a itoava Yaubada dewa habuhabui vo‑vi‑vovoui wayahina. Nonova tau apa‑taputapu Yaubada ya vona‑dabadaba imai‑haeyei deina. ");
INSERT INTO mvn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ka nonova Mosese kadu apa‑taputapu deinake, ivona, ‘Apaina Yaubada aitam onoto vi‑tunei na‑omo wayahimia, ka tauna vi‑tau apa‑taputapu, yauke deina, ka nau‑wawanimi yana hae habuhabui unononi. ");
INSERT INTO mvn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ka aituhu aviyaivia tau apa‑taputapu‑nana yana vona ivihahaiei, akanai Yaubada tomotaui vi‑goyoi, ka tana‑wavini ya tomotau wayahia.’ ");
INSERT INTO mvn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ika, tau apa‑taputapu habuhabui Samuela a itoava tau apa‑taputapu ataina tuta wayahina dewana imai‑haeyei. ");
INSERT INTO mvn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ka taumi tau apa‑taputapu‑naia yai tupua‑nenenehi, o kana‑vona itomi tau apa‑taputapu yai gabu uvaniahei. Wayahina, vona‑dabadaba‑nana Yaubada waka Abaraham venei, itomi kadu uvaniahei. Vona‑dabadaba‑nana ivona, ‘Apaina aitam yam tupua‑nenenehi na‑omo, ka tauna wayahina tomotau habuhabui tanopi taina wayahina nau‑iaiava ivaniahei.’ ");
INSERT INTO mvn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ka tutana Yaubada tauna ya tau paisewa Iesu vi‑tunei, vona ahiahina, tauna vi‑tunei omo naona itomi me Iudea wayahimia. Iuna Yaubada ya nuanua itomi nau‑iaiava uvaniahei. Ka aituhu itomi yami dewa goyona wayahia unua‑vinana, akanai nau‑iaiavana uvaniahei deina.” ");
INSERT INTO mvn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Ka apaina, Pita ka Ioni ivonavona yoko wayahia, ka tau vi‑nomu mata‑genai, ka Manua Vito‑pota a tau nau‑havia a tau veimea ananina, ka kadu Sadusi yoko yai maga‑bawei nui iomo ainuai wayahia, ipoyꞌ‑avini. Taui imaga‑bawe iuna Pita ka Ioni yokoia iviwavenei Iesu anigea mini‑havine, kadu aituhu memeanina Yaubada Iesu si‑vi‑mini‑havine, akanai memeanina Yaubada kadu mani tomotau na‑si‑vi‑mini‑havine deina. ");
INSERT INTO mvn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","4","Ka habuhabui yokoia nihenina ainuai yai nau‑wahe inononi, ka nau‑wahena ivitumahanei. Ka taui ivi‑tau ekalesia, ka tau ekalesia ononotoi ai yau ivanevane 5000 deina. Kate tau veimea inuanua viwavene‑nana goyona. Wayahina, yai nuanua Pita ka Ioni ainuai ineiei vitana matana wayahina, kate babau avaha ionu. Wayahina, manua yohona nihenina itotohi ipotapota mana na‑navi wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Ka mana navia, tau veimea habuhabui inau‑hohona Ierusalem wayahina vitana matanana wayahina. Taui vivane tau vi‑nomu mata‑genai, ka ononotoi anani, ka Yaubada ya veimea a tau viwavenena. Ka tau vi‑nomu ananina ana wava Anasi, ka Anasi yana yoko habuhabui nui inau‑hohona, ka kadu yana yoko wayahia vivane Kaiapasi, ka Ioni, kadue Alekisanidera. ");
INSERT INTO mvn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ka tau nau‑hohonaia Pita ka Ioni ihonei, ivi‑au‑mini mataia, e ivi‑tanatanaiei, ivona, “Itomi aitam dewa udewei. Kate koiaka awaehemi udewei? Medeina ana wava? Avi bagibagi wayahina udewei?” ");
INSERT INTO mvn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ka Nuana Ahihinata Pita nau‑vi‑anai, e Pita ya vona‑nau‑pata vi‑putu, ivona, “Ama tau veimea ka ononotomi ananimi, ");
INSERT INTO mvn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kaiwadi, ama vitana matana ataina vinꞌ‑omo iuna itoai dewa ahiahina aitam adewei tau penapena taina wayahina, a? Kaiwadi ama vitana matana ataina vinꞌ‑omo iuna itomi yami nuanua unꞌ‑anamanei medeina tauna ya vidoha vinꞌ‑omo, a? ");
INSERT INTO mvn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aituhu deina, akanai itomi tau veimea nau‑wawanimi unꞌ‑anamanei, kadu me Isiraeli habuhabui nau‑wawani inꞌ‑anamanei, onoto taina matamia mimini, iuna ya vidoha vinꞌ‑omo Iesu Tau Ito‑yavuha, onoto Nasareta, a wavea. Itomi Iesu‑nana ai nahenahea ututu‑pwatei, unau‑vi‑anigi, kate Yaubada si‑vi‑mini‑havinei. Ka avona‑havinemi, onoto taina ya vo‑vi‑aiai omo Iesu‑nana ya bagibagi wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu‑nana ohona ahihi‑vainena Yaubada ya manua nihenina deina, kate itomi tau yona ohonana uvihahaiei, uhaponei. Ka ataina Iesu‑nana avaha vi‑ohona naona, ka tauna ohona habuhabui veimeyei. ");
INSERT INTO mvn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ka eha kadu aitam koiaka ana pata na‑ito‑yavuhika. Iesu ana heta. Ka eha kadu aitam wava tanopia mamae wayahina kavi‑hone, e ito‑yavuha kavaniahe. Yaubada awaeheka Iesu ana wava a heta‑ohota kavi‑honei, e ito‑yavuha kavaniahei deinake.” ");
INSERT INTO mvn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ka tutana tau veimea‑naia Pita ka Ioni yai ate‑vatu idudueyei, taui nuai vi‑tupatupa ananina wayahina. Ka tau veimea‑naia ianamanei Pita ka Ioni tau maꞌ meagai, kadu ianamanei taui eha pai viwavenena ananina wayahia ita‑nuinu, ka eha nua‑uyana ananina itꞌ‑epe. Ka tau veimea‑naia inuani, nonova ainuai Iesu nui imamaei. ");
INSERT INTO mvn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ka kadu tau penapenana avaha vidoha idudueyei nepeia mimini. Wayahina, tau veimea‑naia inuanua‑wayohe medeina Pita yana vona inau‑pate. ");
INSERT INTO mvn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wayahina, tau veimea‑naia Pita ka Ioni ka onotona nonova penapenana aitonu ivi‑tunei ine vitana matana a papani upuna wayahina, e tau veimea‑naia ai pata matataui ipuipupu, ivi‑nua‑dadani medeina iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ka ai heta ivi‑tanatanaiei, ivona, “Medeina kadewei onoto ainuai taina wayahi? Iuna Ierusalem a tau maꞌ habuhabui avaha ianamanei, taui iaiaya ananina idewei. Wayahina, aituhu kapa‑goyogoyoei, munia tau maꞌ habuhabui inau‑nikonikoieka. ");
INSERT INTO mvn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Itoka nau‑wawanika tuta tepakaia yai nau‑wahe kavito‑potei, e mani tomotau eha yai vitumahana ivo‑vinevine, ka eha yaka tapanono ini‑tawane deina. Wayahina, nau‑wawanika vona panina wayahina kanau‑vi‑avini, ‘Eha kadu aitam tuta itomi unau‑wahe tauna a wavea.’” ");
INSERT INTO mvn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Akaka tau veimea‑naia ihonei ina‑nu‑havine wayahia, e iveimeyei deina, ivona, “Eha kadu aitam tuta una‑vona Iesu a wavea, kadue eha kadu aitam tuta uviwavenena a wavea tomotau wayahia.” ");
INSERT INTO mvn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kate Pita ka Ioni veimeana inau‑patei, ivona, “Avi dewa nau‑wawaniai Yaubada matana? Itomi ami pata uvi‑nua‑dadani. Kaiwadi, tunutunuhiai aituhu itomi movimi avi‑ateteyei, o kadi tunutunuhiai aituhu Yaubada movina avi‑ateteyei? ");
INSERT INTO mvn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kate avonemi, itoai ama veimea mamaei, vivane aviani avaha mataia adueyei, ka aviani avaha tanihaia anononi, akanai nau‑wawaniai dewaia wayahi anaunau‑wahe.” ");
INSERT INTO mvn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Ka tau veimea‑naia ivona‑dabadaba‑havine aituhu kadu aitam tuta inau‑wahe Iesu a wavea, apaina idewa‑yaiyaiei. Ipupuna iakwa, e iyavuhi. Ka tau veimea‑naia eha yai nuanua iyavuhi, kate eha ai pata aitam etawana ita‑vaniahe idewa‑yaiyaie auyewana wayahina. Iuna tau maꞌ Ierusalem habuhabui Yaubada iawa‑davedavei dewa‑bagibagi‑vainena wayahina. Iuna tau penapenana a ponimana ai yau 40 avaha ni‑tawanei. Wayahina, tau veimea‑naia imatamatauta tau maꞌ Ierusalem habuhabui wayahia, e iyavuhi. ");
INSERT INTO mvn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ka avaha Pita ka Ioni iyavuhi, ainuai imavina yaiai wayahia. Ka aviani tau vi‑nomu mata‑genai, ka ononotoi anani ivonei, Pita ka Ioni yaiai imataedai deina. ");
INSERT INTO mvn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ka avaha yaiai inononi, taui habuhabui nui iviama Yaubada wayahina, tomotau aitamoata ya viama deina, ivona, “Kauvea, wamke wahuma, ka tanopi, ka hawana, ka dewa habuhabui nihenia imamaei evevewanei. ");
INSERT INTO mvn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kadu wamke eawaehei wai Davida apa‑taputapu. Vona ahiahina, tauna yam tau paisewa aitam, ka Nuam Ahihinata ya bagibagi wayahina apa‑taputapu, ivona, ‘Aviani wayahina tomotaui eha Yaubada itꞌ‑anamane ahiahina inua‑goyo? Kadu aviani wayahina me Isiraeli inuanua‑kavokavovo? ");
INSERT INTO mvn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tau maꞌ tanopi yai kiniV kadue ai tau veimea inau‑hohona, ivo‑vi‑aiai, e Yaubada inau‑haviei, ka kadu Natu‑hoina, vivane Tau Ito‑yavuha, inau‑haviei.’ ");
INSERT INTO mvn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Vona ahiahina, Erodi ka Ponitiusi Pilate meagai taina nihenina avaha inau‑hohona Davida yanꞌ apa‑taputapu mai‑vonei deina. Ka taui eha Yaubada itꞌ‑anamane ahiahina, kadu me Isiraeli nui inau‑hohona deina, e Iesu yam tau paisewa ahihinata inau‑haviei. Tauna evi‑nua‑dadanei vivane yama Tau Ito‑yavuha. ");
INSERT INTO mvn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ka taui yai dewana goyona vinꞌ‑omo wamke yam nuanua deina, kadu wamke yam awaeha deina. ");
INSERT INTO mvn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Kauvea, itoai yam tau paisewa, ka tuta ataina tau veimea‑naia iyapoyapoai, kadu yai nuanua idewa‑yaiyaieai. Wayahina, ahidahidam ama havia yai ipupu manimaninina enuani, ka ahidahidam evo‑vi‑bagibagiai kadu evo‑vi‑vatuai, e ama pata yam vona ahaehaeyei tunuhina. ");
INSERT INTO mvn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ka yam bagibagi wayahina tau kwanakwanaha evo‑vi‑aiaiei, ividoha. Ka kadu pai dune bagibagina kadu iaiaya ananina eawaeheai asi‑vinꞌ‑omanei yam tau paisewa ahihinata Iesu a wavea.” ");
INSERT INTO mvn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ka yai viamana inau‑yehai, ka tanopi si‑putu, vi‑yoyoyo, e manua‑nana nihenina imamaei nau‑yueyue. Ka Nuana Ahihinata omo, e habuhabui nau‑vi‑anai, e taui yai ate‑vatu nui Yaubada yana vona ihaehaeyei tunuhina, eha ita‑matamatauta. ");
INSERT INTO mvn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ka tau vitumahana ivi‑habu, ka yai nuanua aitamoata, kadu ai ayaunena aitamoata. Eha ita‑vi‑vonavona ka eha ita‑vonavona, “Yau kina taina, ka itomi eha.” Taui yai gugua habuhabui iawaehei yoko habuhabui yai dewa wayahi. ");
INSERT INTO mvn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ka Kauvea Iesu a tau hae anani ibagibagi ananina, ka tauna ya mini‑havine ihaehaeyei. Ka Yaubada yanꞌ ate‑nuanuai ananina taui habuhabui wayahia mamaei. ");
INSERT INTO mvn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ka eha aitam payapayaya nui, ka habuhabui na kabwagi kadu na kwamai. Iuna aituhu yaiai ivi‑kutakuta, munia tau kaikaiwabo wayahia yai tano kadu yai manua iaimwaneyei, e patana habuhabuna iomanei, e Iesu a tau hae ivenevenei. Ka tau hae‑naia taui ivi‑kutakuta kinaia ivo‑patapatai. Ka tuta tuta ekalesia nihenina tau kaikaiwabo yai dewa deina. ");
INSERT INTO mvn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ka aitam tau kaikaiwabo wayahia ana wava Iosepa. Ka tau hae ivi‑wahani Banabasi, iuna Banabasi anꞌ anamana “tau vo‑vi‑vatu”. Tauna aitam Levi yana dede, ka ya meagai aitam bonabona ana wava Sipirusi. ");
INSERT INTO mvn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ka aitam tuta Banabasi tauna yana tano imwaneyei, e kinaia omanei, e Iesu a tau hae venei, iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Ka mani onoto mamaei ana wava Ananiasi, ka awana ana wava Sapira. Ka ainuai yai tano aitam iaimwaneyei. Ka taui imai‑awaehei patana tupwana ipoyꞌ‑avini ihivei, ka tupwana tau hae ivenei, kate iawaehei yai vitupu wayahina tau hae inonoi, e ina‑vona, “Patana taina tano patana habuhabuna.” Wayahina, Ananiasi patana tupwana omanei, e tau hae venei, iveimeyei. ");
INSERT INTO mvn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wayahina, Pita vi‑tanaiei, ivona, “Ananiasi, aviani iuna Satana eawaehei nuam nihenina na‑veimeyem tano patana tupwana ehivei? Dewana wayahina evitupu Nuana Ahihinata wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nonova tano‑nana vivane wamke yam pai veimea. Ka kadu munia, avaha eimwaneyei, kinaia vivane wamke yam pai veimea. Ka wamke am heta evi‑nua‑dadani kinaia eomanei eveneai. Aviani wayahina enuanua kinaia wayahina evitupu deina? Yam vitupu‑nana eha tomotau wayahiaia, kate wamke avaha evitupu Yaubada wayahina!” ");
INSERT INTO mvn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ka avaha Ananiasi Pita ya vonana nononi, akanai aniga ipeu. Wayahina, matauta ananina tomotau yoko vaneana inononi epai. ");
INSERT INTO mvn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kate tubuao tupwai imini, iomo, e ininina kalekoa iaumei, iavanei, ivituei, e itavuni. ");
INSERT INTO mvn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka eha aitam koiaka Ananiasi awana ta‑mataede. Wayahina, babau aitonu munia Sapira manua‑nana inui. ");
INSERT INTO mvn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ka Pita vi‑tanaiei, ivona, “Sapira, yami tano‑nana avaha uaimwaneyei, ai vi‑am kina patana uepei? Kaiwadi yam onoto voneai deina, ika?” Ka Sapira vona‑nau‑pata, ivona, “A, deinake.” ");
INSERT INTO mvn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wayahina, Pita vonei, ivona, “Medeina itomi ami inua uawaehei aitamoata Kauvea Nuana unau‑dadani deina? Enononi! Yam onoto a tau vi‑ai avaha iaumei itavuni, ka ataina tuta ipotapota iavanam, ivituem aitamoata deinake.” ");
INSERT INTO mvn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ka Sapira aniga‑kwayavoni, ka ipeu Pita aena wayahina. Ka tubuao‑naia inu‑me, idueyei avaha aniga. Wayahina, iavanei ivituei, e awana nepena itavuni. ");
INSERT INTO mvn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ka tau ekalesia habuhabui imatamatauta ananina. Ka mani tomotau, aituhu aviyaivia vaneana inononi, taui kadu imatamatauta deina. ");
INSERT INTO mvn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ka tuta tuta Iesu a tau hae‑naia iaiaya kadu dewa‑bagibagi habuhabui idedewei tomotau mataia. Ka tau ekalesia habuhabui yai dewa inau‑hohona aitam tutu‑honota nihenina. Ka tutu‑honotana Manua Vito‑pota hutana aitam, ka tomotau ivi‑wahani Solomoni Ya Tutu‑honota. ");
INSERT INTO mvn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ka aituhu aviyaivia eha yai vitumahana, o aituhu aviyaivia eha yai ate‑vatu, tomotaui eha nui ita‑tapanono, iuna imatamatauta. Kate tomotau habuhabui ekalesia upuna iawaehei tau ekalesia ai anamana vivane ahiahina. ");
INSERT INTO mvn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ka tomotau habuhabui imatamatauta ekalesia wayahina, kate ononotoi kadu vaivinei habuhabui ivi‑putu Kauvea ivitumahanei. Wayahina, tau ekalesia ai yau natanata. ");
INSERT INTO mvn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ka tau hae‑naia dewa‑bagibagina habuhabuna idedewei. Aituhu Pita iwaunina tau kwanakwanaha inini vo‑dadani, akanai taui ividovidoha. Wayahina, tuta tuta tomotau tau kwanakwanaha na pai dauvi iomaomanei, e iboubouni Pita ya etawana wayahia, e memeanina iwaunina na‑vo‑dadani ividoha. ");
INSERT INTO mvn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ka meagai kikitui Ierusalem awaniana imamaei. Ka meagai‑naia ai tau maꞌ iomomo, inau‑hohona Ierusalem nihenina, ka taui yai tau kwanakwanaha iavanei. Ka kadu aviyaivia nua gawagawami ivo‑vi‑kwanakwanahi iomaomanei, ka habuhabui ividoha. ");
INSERT INTO mvn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ka tau vi‑nomu ananina, ka yaiana habuhabui ivi‑bwanou ananina. Tauna yaiana habuhabui vivane Sadusi yai yoko wayahia. ");
INSERT INTO mvn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ka taui habuhabui iawaehei tau nau‑havia ivi‑tunei ina‑omo Iesu a tau hae wayahia, ipoyꞌ‑avini, e manua yohona nihenina ibouni. Wayahina, idewei deina. ");
INSERT INTO mvn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ka ioyomana wayahina, Kauvea yanꞌ anelose aitam omo, e manua yohonana anꞌ awa waei, e tau hae‑naia si‑vinꞌ‑omane‑neiei. Ka manua yohonana upuna vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Una‑nei Manua Vito‑pota wayahina, e tanoi pai nau‑hohona ananina nihenina umini, e tomotaui wayahia yawai vovouna a vonana habuhabuna unaunau‑waheyei.” ");
INSERT INTO mvn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ka tau hae‑naia anelosena ya vonana inononi, ivi‑ateteyei. E mana navia Manua Vito‑pota a pai nau‑hohona ananina nihenina itotoha, e ivi‑putu iviwavenena tomotau wayahia. Ka munia, tau vi‑nomu ananina tauna yana yoko nui ivinꞌ‑omo. Ka avaha inau‑hohona, taui me Isiraeli ai tau veimea habuhabui ana wava SanederiniV ihone‑hohoni. Ka taui yai tau nau‑havia ivi‑tunei ine manua yohona nihenina, e taui Iesu a tau hae‑naia ina‑omanei mataia. ");
INSERT INTO mvn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ka tau nau‑havia‑naia iomo manua yohona nihenina, kate awakabina idueyei. Wayahina, imavina, ");
INSERT INTO mvn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","imataedai, ivona, “Manua yohona bou‑potapotana mamaei, ka toyoina adueyei, ka kadu a tau dune‑vi‑avina awana wayahina imimini, kadu idunedune akanai. Kate tutana awana awaei, nihenina awakabina!” ");
INSERT INTO mvn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ka Manua Vito‑pota a tau nau‑havia ai tau veimea ananina, kadu tau vi‑nomu ananina ivanevaneneha, ka avaha mataedana inononi, ainuai nuai vi‑tupatupa ani‑vainena, ka eha itꞌ‑anamane aviani vinꞌ‑omo. ");
INSERT INTO mvn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ka munia, aitam onoto omo wayahia, e mataedai, ivona, “Tomotaui manua yohona nihenina ubouni avaha Manua Vito‑pota nihenina imimini, ka ataina iviwavenena tomotau wayahia.” ");
INSERT INTO mvn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wayahina, Manua Vito‑pota a tau nau‑havia ai tau veimea ananina, ka ya tau nau‑havia tupwai nui iomo, e tau hae‑naia ipoyꞌ‑avini. Kate mai‑nuai iomanei imavi‑neiei. Iuna imatamatauta yokoia wayahia, ka eha yai nuanua yokoia ina‑nua‑goyoe. Aituhu yokoia inua‑goyoei, apaina itutu‑hanuhanui. ");
INSERT INTO mvn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wayahina, mai‑nuai iomanei tau veimea‑naia mataia, ivi‑au‑mini‑neiei. Ka tau vi‑nomu ananina vi‑tanaiei, ");
INSERT INTO mvn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ivona, “Aviani nonova aveimeyemi? Unuani, nonova vona panina wayahina avito‑potami uviwavenena tomotau wayahia onoto‑nana a wavea. Ka udu! Avaha meagai Ierusalem yami viwavenena uvi‑nau‑vi‑anai. Udedewei deina, iuna itomi yami pai mini ananina uvitavitai onoto‑nana yanꞌ aniga wayahina, a?” ");
INSERT INTO mvn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ka Pita, ka tau hae‑naia habuhabui ivona, “Itoai nau‑wawaniai Yaubada yana vona avi‑ateteyei, ka eha tomotau ai heta yai vona. ");
INSERT INTO mvn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ka vona tunutunuhina, itomi Iesu ai nahenahea ututu‑pwatei, ka itomi unau‑vi‑anigi deina. Ka yami dewaia iakwa, yaka tupua‑nenenehi yai Yaubada Iesu anigea si‑vi‑mini‑havinei. ");
INSERT INTO mvn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ka Yaubada avaha Iesu‑nana si‑nai ateina wahuma. Ka tauna vivane yaka KiniV Natuna kadu yaka Tau Ito‑yavuha. Yaubada dewei deina, iuna ya nuanua itoka me Isiraeli yaka goyona wayahi kanua‑vinana, kadu ya nuanua tauna yaka dewa goyona na‑nua‑tavuni. ");
INSERT INTO mvn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ka aituhu aviyaivia yama viwavenena ivi‑ateteyei, ka aituhu idedewei, taui Nuana Ahihinata Yaubada wayahina ivaniahei. Itoai dewaia ahaehaeyei, ka kadu Nuana Ahihinata dewaia haehaeyei aitamoata deina.” ");
INSERT INTO mvn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ka tau veimea‑naia avaha Iesu a tau hae yai vonaia inononi, magai bawei ani‑vainena, ka yai nuanua ananina ina‑nau‑vi‑anigi. ");
INSERT INTO mvn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ka aitam onoto wayahia ana wava Gamalieli mini niwania. Tauna aitam Parisi, ka veimea a tau viwavenena ananina, ka tomotau habuhabui iawaehei tauna aitam tau sinasinapu. E tauna veimea boui vivane Iesu a tau hae ivituei, e tuta kutakutana wayahina tutu‑honota‑nana upuna wayahina imamaei. ");
INSERT INTO mvn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ka ivituei iakwa, akaka tauna tau veimea‑naia vonei, ivona, “Me Isiraeli, udune‑vivinimi! Nau‑wawanimi mai‑nuami yami dewa uvi‑nua‑dadani onoto‑naia wayahi. ");
INSERT INTO mvn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Unuani, tuta nonova aitam onoto ana wava Teudasa vinꞌ‑omo, ka tauna ana heta wayahina vona‑vanevane vivane tauna onoto ananina. Ka tomotau ai yau 400 deina inu yana yoko nihenina, e ivi‑muniei. Kate Teudasa a havia inau‑vi‑anigi. Ka yanꞌ aniga munia, a tau vi‑muni iyavuta, ka ataina yana yoko iakwa. ");
INSERT INTO mvn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ka Teudasa munia, tutana me Rom habuhabuka iaiaiavika yai takesiV wayahina, kadu aitam onoto ana wava Iudasa papani Galili wayahina vinꞌ‑omo. Ka tauna ya nau‑wahe a pai mini ananina vivane itoka me Isiraeli nau‑wawanika me Rom yai veimea kavihahaiei. Wayahina, tupwai tomotau nui inau‑hohoni, e ivi‑muniei. Kate tauna a havia ivunui, e tauna a tau vi‑muni iyavuta. ");
INSERT INTO mvn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wayahina, ataina tuta yauke anau‑vi‑avinimi, ugenuana. Eha aitam aviani uvito‑pote onoto‑naia wayahi. Aituhu taui yai yoko kadu yai paisewa vinꞌ‑omo aitam onoto‑henai ya nuanua wayahina, apaina yai dewa habuhabuna ina‑ihanua ina‑iakwa, Teudasa kadu Iudasa yai paisewa deina. ");
INSERT INTO mvn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","O kadi aituhu taui yai yoko kadu yai paisewa vinꞌ‑omo Yaubada ya nuanua wayahina, itomi eha ami pata Yaubada uvito‑pote. Ka aituhu uvito‑pota‑dadana, itomi avaha Yaubada unau‑haviei deina.” ");
INSERT INTO mvn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ka tau veimea yokoia Gamalieli ya vonana inononi, e iawaehei tupwana. Akaka tau hae‑naia ihonei imavina wayahia, e tau nau‑havia iveimeyei imoamoani. Iakwa, taui tau hae‑naia yai nau‑wahe kadu yai viwavenena Iesu a wavea ivito‑potei, e iyavuhi ine. ");
INSERT INTO mvn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ka tau hae‑naia tau veimea yai nau‑hohona ini‑tawanei iomo taui yai yoko wayahia, ka idewa‑haiawa. Iuna Yaubada awaehei ai pata inahe ivaniahei Iesu a wavea. ");
INSERT INTO mvn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ka auyewa aitamoata aitamoata wayahia imavimavina Manua Vito‑pota wayahina, ka tutu‑honota nihenia, ka kadu tomotau yai manua nihenia iviwavenena kadu inaunau‑wahe. Eha aitam auyewa ita‑ni‑tawane. Ka taui Iesu Vaneana Ahiahina inaunau‑wahei, kadu tomotau Iesu ihaehaeyei, tauna vivane Tau Ito‑yavuha‑nana. ");
INSERT INTO mvn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tuta tanoi wayahina Iesu a tau vi‑muni‑waiwai ai yau natanata. Ka ekalesia nihenina yoko ainua mamaei. Nonova habuhabui me Iudea yai tapanono naona ivi‑muniei, ka tupwai wayahia yai tupua‑nenenehi vivane me Ebereu, ka tupwai wayahia yai tupua‑nenenehi vivane me Girisi. Ka tomotau yoko ainuai wayahia ivi‑tau ekalesia. Ka auyewa aitamoata aitamoata, avi tuta aniani wadawadae ivo‑patapatai, taui me Isiraeli wayahia aniani ivaniahei, kate taui me Girisi wayahia eha aniani ita‑vaniahe. Wayahina, tuta tuta taui me Girisi wayahia inau‑vonuvonu, iuna me Girisi wadawadae am inavovo. ");
INSERT INTO mvn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ka Iesu a tau hae ai yau 12 me Girisi yai nua‑vita inononi. Wayahina, taui tau vitumahana habuhabui ihone‑hohoni, e ivona, “Itoai tau hae ama veimea mamaei, Yaubada yana vona anaunau‑wahe. Wayahina, eha ama pata paisewana abou‑ohoi, e avi‑putu aniani avo‑pata. ");
INSERT INTO mvn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Itomi tau ekalesia habuhabumi nau‑wawanimi ononotoi ai yau 7 wayahimia uvi‑nua‑dadanei ivi‑tau paisewa, ka aniani a vo‑pata kawaehei iveimeyei. Ka aituhu aviyaivia ononotoi tunutunuhi matamia, ka kadu aituhu aviyaivia Nuana Ahihinata avaha ivaniahei, e nau‑vi‑anai, ka kadu aituhu aviyaivia na nua‑uyai, akanai ononotoia uvi‑nua‑dadanei paisewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ka itoai tau hae nau‑wawaniai abebewa aviama, kadue abebewa Yaubada yana vona aviwavenei.” ");
INSERT INTO mvn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ka ekalesia yokoia idewa‑haiawa tau hae yai veimeana wayahina. E ononotoi ai yau 7 ivi‑nua‑dadanei taina deina. Naona Sitiveni, tauna ya vitumahana Iesu wayahina bagibagina, kadu Nuana Ahihinata tauna nau‑vi‑anai, ka Pilipi, ka Pirokorusi, ka Nikanoro, ka Timoni, ka Paremenasi, ka kadu Nikolasi. Tauna onoto Anitioki, ka ya tupua eha me Isiraeli wayahia, kate naona tauna me Iudea yai tapanono vi‑muniei, e munia vi‑tau ekalesia. ");
INSERT INTO mvn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wayahina, tau ekalesia habuhabui ononotoia iomane‑neiei Iesu a tau hae mataia, e tau hae‑naia iviama Yaubada wayahina, kadu nimai wayahia ununui ivo‑dadani, e ibou‑keyei paisewana wayahina deina. ");
INSERT INTO mvn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka tuta tanoi wayahina tau nau‑wahe Yaubada yana vona inaunau‑wahei, ka tomotau habuhabui inonononi, ka ivitumahanei. Wayahina, meagai Ierusalem nihenina tau vitumahana ai yau natanata vo‑kwayavonina. Ka kadu tau vi‑nomu mata‑genai habuhabui Iesu vaneana inononi, ivitumahanei, e ivi‑tau ekalesia. ");
INSERT INTO mvn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ka Yaubada tauna yanꞌ am‑venena awawaehina kadu ya bagibagi Sitiveni vi‑nau‑vi‑anai. Wayahina, Sitiveni iaiaya ani‑vainei dedewei, kadu mani dewa dedewei tomotau mataia, ka tomotau nuai vi‑tupatupa wayahia. ");
INSERT INTO mvn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ka tomotau tupwai inau‑hohona itapatapanono aitam pai nau‑hohona nihenina, ka manuana ivi‑wahani, “Itoai Yavuyavuhiai Yama Pai Nau‑hohona.” Taui me Iudea yai tapanono ivi‑muniei, ka yai tupua papani tunina tunina wayahia. Tupwai meagai Sirene wayahina, ka tupwai meagai Alekisanideria wayahina, kadu tupwai papani Silisia wayahina, ka tupwai papani Asia wayahina. Ka taui ivi‑putu Sitiveni wayahina ivi‑vonavona vitumahana wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kate taui eha ai pata yai vona wayahina Sitiveni ibagibagi‑tawane, iuna Sitiveni ya nua‑uya vinꞌ‑omo Nuana Ahihinata wayahina. Ka tuta tuta taui eha ai pata ivona‑nau‑pata. Wayahina, inua‑goyo Sitiveni wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ka taui dewa hivahivana wayahina yaiai tupwai iapa‑dibidibiei ina‑ivaitei, e Sitiveni ivitevitei. Wayahina yaiai ini‑keyekeyei, ivonavona, “Sitiveni avaha yana vona goyona anononi. Tauna Mosese ka Yaubada ainua apa‑goyogoyoei.” ");
INSERT INTO mvn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ka yai vitupu‑nana wayahina me Isiraeli habuhabui, kadu ai tau veimea, kadu Yaubada ya veimea a tau viwavenena inau‑vi‑nehanehai, e Sitiveni ivunui. Wayahina, me Isiraeli ai tau veimea Sitiveni ipoyꞌ‑avini, e ivi‑au‑mini SanederiniV mataia vitana matana wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ka tau veimea‑naia tau vitupu‑naia ihonei inꞌ‑omo, e taui Sitiveni wayahina ivona, “Onoto taina, tuta tuta, Manua Vito‑pota taina mana‑giboei, kadu Mosese ya veimea mana‑giboei, ");
INSERT INTO mvn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ka kadu yana vona anononi, ivona, ‘Apaina Iesu onoto Nasareta Manua Vito‑pota taina na‑tutu‑bwege‑yavunei.’ Ka kadu ivona, ‘Iesu yaka dewa Mosese veneka na‑vo‑vinei, ka munia nau‑wawanika dewa tunina kavi‑muniei.’” ");
INSERT INTO mvn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka tau nau‑hohona‑naia habuhabui SanederiniV nihenina imamaei Sitiveni tepana idune‑vi‑anai, ka tepana ana dune anelose tepana deina, iuna Yaubada didigana mamaei wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wayahina, tau vi‑nomu ananina Sitiveni vi‑tanaiei, ivona, “Medeina? Taui ivitavitam yai vonana vivane vona tunutunuhina, a?” ");
INSERT INTO mvn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ka Sitiveni ivona, “Vavaneiu ka amamau, nau‑wawanimi yau vona taina unononi. Nonova waka Abaraham meagai Harani nihenina mamaei. Kate naona tauna papani ananina ana wava Mesopotamia nihenina mamaei. Ka Yaubada, tauna didigana maꞌ‑vavaha, omo Abaraham wayahina Mesopotamia nihenina, e vonei, ivona, ");
INSERT INTO mvn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Abaraham, yam meagai taina kadu yam yoko taina eni‑tawanei, ena‑ne mani papania. Apaina, papani‑nana aviwavenem.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Wayahina, Abaraham mini, e me Kalidea yai papani ni‑tawanei, omo meagai Harani wayahina, e tenoke mamaei. Ka avaha amana inusi, e Yaubada eta‑naoei papani taina wayahina, ka tuta ataina itoka baina kamamaei. ");
INSERT INTO mvn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka tuta tanoi wayahina Yaubada eha aitam tanopi Abaraham ta‑vene yana gabu wayahina, kate Yaubada apa‑taputapuei, ivona, ‘Papani taina yam tupua‑nenenehi avenei vivane yai tanopi.’ Ka tuta tanoi wayahina Abaraham eha aitam natuna. ");
INSERT INTO mvn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ka Yaubada kadu ya tupua‑nenenehi wayahi apa‑taputapu, ivona, ‘Abaraham, wamke yam tupua‑nenenehi ivi‑tau bwanibwani ine mani papania, ka tau vi‑meagai tanoi iveimeyei ivi‑tau paisewa‑kavovo wayahi, ka tau vi‑meagai‑naia ivitavitai ponimana ai yau 400 nihenia deina.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ka Yaubada ivona, ‘Kate munia, tau vi‑meagai‑naia adewa‑yaiyaiei, iuna yam tupua‑nenenehi ivitavitai ivi‑tau paisewa‑kavovo. Ka munia, papani tanoi wayahina ini‑tawanei ka inꞌ‑omo papani taina wayahina, ka baina ina‑iwaodu wayahiua.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ka Yaubada tauna yanꞌ awaeha Abaraham wayahina nau‑yehai dewa aidaba wayahina. Wayahina, Abaraham natuna ana wava Isaki tupua, ka auyewa vi‑8‑na ya tupua munia, Abaraham ininina dabei. Ka munia, Isaki natuna ana wava Iakobo tupua, ka munia Iakobo natunatuna ai yau 12 itupua. Ka taui ai yau 12‑naia vivane itoka yaka tupua‑nenenehi. ");
INSERT INTO mvn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ka aitam yaka tupua‑nenenehi, ana wava Iosepa. Ka vavaneina ai yau 11 ivi‑bwanouei. Wayahina, tauna iaimwaneyei tupwai tomotau wayahia, ka taui Iosepa ineiei papani Egipita wayahina. Ka Yaubada eha tauna ta‑ni‑tawane, kate ivaitei, ");
INSERT INTO mvn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ka ana vita aitamoata aitamoata wayahina ito‑yavuhi. Ka Yaubada nua‑uya ananina venei, ka me Egipita yai kiniV ana wava ParaoV, avaha nua‑uyana nononi, Iosepa nuana epei. Akaka ParaoV Iosepa si‑nai, vi‑tau veimea ya manua nihenina, ka kadu vi‑tau veimea papani Egipita habuhabuna wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ka munia, am navovo ananina omo papani Egipita wayahina, ka kadu papani Kanaani wayahina. Ka tomotau habuhabui inahe ananina ivaniahei. Ka yaka tupua‑nenenehi eha ai pata ai maꞌ ivaniahe. ");
INSERT INTO mvn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ka avaha Iakobo vane Egipita wayahina nononi, vivane tenoke aniani mamaei, e tuta naona natunatuna ononotoi vi‑tunei inei Egipita aniani wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka munia, kadu imavi‑havine Egipita tuta vꞌ‑inuana wayahina, ka Iosepa tauna vavaneina mataedai, ivona, ‘Yauke vaneimi, au wava Iosepa.’ Ka Iosepa kadu ParaoV wayahina haeyei ivona, ‘Tomotau taina vivane vavaneiu.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ka munia, Iosepa tuyeha va‑tawanei ine amana Iakobo wayahina, e vonei, ivona, ‘Amau, wamke kadu yam yoko habuhabui nui una‑opu wayahiua papani Egipita wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ka Iakobo yana yoko nui ai yau 75 habuhabui papani Kanaani ini‑tawanei, iopu papani Egipita wayahina. Ka munia, papani Egipita nihenina Iakobo aniga, ka kadu yaka tupua‑nenenehi aitamoata aitamoata ianiga Egipita nihenina deina. ");
INSERT INTO mvn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ka tau matena iavanei ivituei iomanei meagai Sekem wayahina, e tenoke itavuni unuvovoa. Nonova Abaraham unuvovo‑nana meagai Sekem nihenina vi‑maiei Hamora natunatuna wayahia. ");
INSERT INTO mvn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ka ponimana habuhabuna munia, Yaubada yanꞌ apa‑taputapu Abaraham wayahina tauna ya tupua‑nenenehi wayahi avaha vi‑maupwani. Ka me Isiraeli papani Egipita nihenina avaha ivi‑habu‑vaine. ");
INSERT INTO mvn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kate ParaoV vovouna ya veimea vi‑putu papani Egipita nihenina, ka Parao‑nanaV Iosepa yana dewa ahiahina Egipita wayahina eha tꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wayahina, Parao‑nanaV manimaninina yaka tupua‑nenenehi wayahia, vivane veimeyei natunatui mwatutukui ione‑yavunei vuvunaha, e ianianiga deina. ");
INSERT INTO mvn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ka tuta tanoi wayahina Mosese tupua, ka ana dune ahihi‑vainena. Ka wahava aitonu nihenia amana ka ayona yai manua nihenina ihivehivei ka idune‑vi‑avini. ");
INSERT INTO mvn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ka tutana isi‑vinꞌ‑omanei vuvunaha, e ParaoV natuna vavinena vaniahei, e taini neiei, e payayei ka awa‑natunei. ");
INSERT INTO mvn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wayahina, me Egipita taui yai nua‑uya habuhabuna Mosese iviwavenei, anamanei. Ka munia, tauna yana vona kadu yana dewa vivane bagibagina. ");
INSERT INTO mvn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ka tutana tauna a ponimana ai yau 40 vaniahei, Mosese ya nuanua vavaneina me Isiraeli na‑nau‑vi‑taui. ");
INSERT INTO mvn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka tanoi yai papani nihenina tauna onoto Egipita dueyei vivane onoto Isiraeli vunuvunu‑kavovoi. Wayahina, Mosese onoto Egipita nau‑vi‑anigi, e vaneina yavei deina. ");
INSERT INTO mvn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ka Mosese nuanua vavaneina avaha ianamanei, tauna nimana wayahina Yaubada na‑ito‑yavuhi. Kate taui eha itꞌ‑anamane. ");
INSERT INTO mvn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ka mana navia, Mosese vavaneina me Isiraeli ainua ivi‑naua vaniahai, ka tauna ya nuanua nꞌ‑awa‑tani. Wayahina, vonei, ivona, ‘Yaiau, itomi yoko aitamoata. Wayahina, mehenai yami maꞌ uvi‑goyogoyoi?’ ");
INSERT INTO mvn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ka tauna vaneina vunuvunui Mosese vitu‑voi‑onei, ka Mosese ya vonana vona‑nau‑patei, ivona, ‘Taum koiaka? Koiaka awaehem evi‑tau veimea, kadu evi‑tau vaneneha tauai wayahiaia? ");
INSERT INTO mvn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Medeina yam nuanua? Kaiwadi, nuanuam ena‑nau‑vi‑anigiu, navinavi onoto Egipita enau‑vi‑anigi deina, a?’ ");
INSERT INTO mvn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ka Mosese, avaha vonana nononi, matamatauta. Iuna tomotau habuhabuna avaha ya dewana anamanei. Wayahina, inovo omo papani Midiani wayahina, ka tenoke vi‑tau bwanibwani, e mamaei. Ka papani‑nana wayahina natunatuna onotona ainua itupua. ");
INSERT INTO mvn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ka avaha ponimana ai yau 40 iakwa, Oya Sinai anata wayahina aitam anelose omo Mosese wayahina, ai yabeyabena nihenina. ");
INSERT INTO mvn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ka tutana Mosese anelose‑nana ana dune dueyei, nuana vi‑tupatupa ananina. Wayahina, ine ai‑nana wayahina, e va‑vi‑maupwani na‑dunedune, ka Kauvea movina omo nononi, ivona, ");
INSERT INTO mvn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yauke yam tupua‑nenenehi yai Yaubada, vivane Abaraham ya Yaubada, ka Isaki ya Yaubada, ka Iakobo ya Yaubada.’ Ka Mosese matamatauta ka tatatava, ka eha ana pata na‑dune‑vane. ");
INSERT INTO mvn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ka Kauvea vonei, ivona, ‘Aem wayahina am ae‑yapayapa eyavuhi, ebouni. Iuna yam pai mini tanopia baina vivane vito‑potana. ");
INSERT INTO mvn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yau tomotau papani Egipita wayahina imamaei, ka avaha yai nua‑vita ananina anamanei, ka avaha yai viama‑toutou anononi. Wayahina, ataina aopu‑me, ana‑ito‑yavuhi. Edu! Ataina tuta wayahina avi‑tunem emavina papani Egipita wayahina.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nonova me Isiraeli Mosese‑nana ivihahaiei, ivona, ‘Koiaka awaehem evi‑tau veimea kadu evi‑tau vaneneha?’ Kate Yaubada yanꞌ anelose vi‑tunei omo Mosese‑nana wayahina, e anelose‑nana ai‑nana wayahina Mosese mataedei, ivona, ‘Yaubada avaha vi‑nua‑dadanem, e vi‑tunem, evi‑tau veimea kadu evi‑tau ito‑yavuha me Isiraeli wayahi.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ka Mosese‑nana me Isiraeli eta‑naoei, ka dewa‑bagibagi kadu iaiaya dedewei papani Egipita nihenina, kadu dedewei Hawana Yabebenina wayahina, ka kadu dedewei anata nihenina ponimana ai yau 40 nihenia. ");
INSERT INTO mvn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosese‑nana me Isiraeli vonei, ivona, ‘Apaina Yaubada aitam onoto vi‑tunei na‑omo wayahimia, ka tauna vi‑tau apa‑taputapu, yauke deina. Ka tauna aitam wayahimia.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tutana yaka tupua‑nenenehi ivi‑didi‑yonayona anata nihenina, Mosese yoko nui imamaei. Ka aitam tuta anelose omo Mosese wayahina Oya Sinai hetana, ka ipuipupu wayahina, kadue ipupu yaka tupua‑nenenehi wayahia. Ka Mosese vona yawayawaina vaniahei, e vene‑tamaneka. ");
INSERT INTO mvn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kate yaka tupua‑nenenehi eha yai nuanua Mosese na‑veimeye. Wayahina, tauna ivihahaiei, ka nuai nihenina yai nuanua imavina papani Egipita wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ka taui Aroni ivonei, ivona, ‘Itoai yama nuanua yaubada tupwai enau‑vevewanei wayahika, e taui ieta‑naoeka. Nonova Mosese papani Egipita wayahina eta‑naoeka, kate ataina tuta eha atꞌ‑anamane aveta baina tauna mamaei.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ka tuta tanoi itupwana inau‑vevewanei nimai wayahia, ana dune aitam bulumakauV deina. E taui ivi‑nomu wayahina, kadu idewa‑haiawa yai nau‑vevewana wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kate tutana Yaubada yai dewana goyona dueyei, tauna ni‑tawanei. Ka avi tuta taui yai nuanua babau, ka wahuma, ka wadima wayahia ina‑iwaodu, Yaubada awaehei idedewei. Tauna eha yai goyona ta‑vo‑vi‑tunuha. Tau apa‑taputapu avaha Yaubada yana vona iginumi taui yai buki nihenia, ka ivona deina, ‘Yau yoko, itomi me Isiraeli, ponimana ai yau 40 anata nihenina umamaei, kate eha uta‑vi‑nomu taua wayahiua, kadu eha am‑venena‑kavovo uta‑veneveneu. ");
INSERT INTO mvn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Eha. Itomi uvi‑nomu yaubada vitupu wayahia yai pai vi‑ai wayahia, taui vivane Moleke kadu Repani. Moleke ya manua tapanono wayahina uvi‑nomu, kadu Repani ya wadima wayahina uvi‑nomu. Taui vivane itupwana unau‑vevewanei pai iwaodu wayahina. Wayahina, apaina meagai Babiloni papani‑nana wayahina avi‑tunemi una‑ne bana mamanaina, ka tanoi wayahina tau vi‑meagai iyohonimi uvi‑tau paisewa‑kavovo taui wayahi.’ ");
INSERT INTO mvn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tutana yaka tupua‑nenenehi imamaei anata nihenina, Ine Vito‑pota yai didi‑yonayona nihenina mamaei. Yaubada Mosese ine‑nana a mayamayau viwavenei, ka Mosese me Isiraeli veimeyei iyonei aitamoata deina. ");
INSERT INTO mvn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ka munia, yaka tupua‑nenenehi Iosua nui iomo papani taina wayahina, ka inui. Ka Yaubada ivaitei, e tauna papani Kanaani a tau maꞌ vo‑tahoi inovo ine, e yaka tupua‑nenenehi papani taina iepei yai tanopi. Ka tutana papani taina inuinu Ine Vito‑pota‑nana iavavanei. Ka ine‑nana papani taina nihenina mamaei a itoava KiniV Davida me Isiraeli veimeyei wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davida dewa‑nuanuai vaniahei Yaubada matana. Wayahina, Davida ya nuanua aitam manua tapanono na‑yonei Iakobo ya Yaubada wayahina, kadu Davida Yaubada viamei nꞌ‑awaehei deina. Kate Yaubada Davida ya viamana eha tꞌ‑awaehe. ");
INSERT INTO mvn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ka munia, Solomoni manua‑nana yonei Yaubada wayahina. ");
INSERT INTO mvn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ka tau apa‑taputapu aitam avaha voneka, Yaubada vivane Wahuma A Tau Veimea. Wayahina, aituhu tomotau‑henai aitam manua iyonei nimaia, manua‑nana eha nau‑wawani Yaubada wayahina. Yau vonana avo‑vi‑tupanei Iginuma wayahina. Iginuma‑nana ivona, ");
INSERT INTO mvn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ “Wahuma yau pai manuena. Ka tanopi aeu a pai vi‑ai.” Yaubada vi‑tanaiemi, ivona, “Avi manua kaiwadi wayahiu uyoneyone?” Kadu ivona, “Kaiwadi, aveta yau pai vi‑yawai uyoneyone? ");
INSERT INTO mvn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yauke taua dewa habuhabuna wahuma kadu dewa habuhabuna tanopia avevewane‑neiei nimaua!” ’ ");
INSERT INTO mvn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nonova yami tupua‑nenenehi Yaubada ya vonana ivihahaiei. Ka tuta ataina itomi ya